/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000179d0ULL, 0x0000000000017650ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000015a90ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x0000000000015c10ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000015c50ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000015ca0ULL, 0x0000000000000160ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015e00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00015a9000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0055100400288080ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9808288080820828ULL,
0x2880809908288080ULL, 0x80b008288080ae08ULL, 0x08288080b2082880ULL, 0x8082801628808084ULL,
0x0000000000031028ULL, 0x2880808492000000ULL, 0x0000000000002200ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x00015a9000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809608288080ULL, 0x8099082880809808ULL,
0x08288080ae082880ULL, 0x8080b208288080b0ULL, 0x8016288080940828ULL, 0x0000000310288082ULL,
0x8094920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000012000000000ULL,
0x00015c1000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809808288080ULL, 0x80b008288080ae08ULL,
0x08288080b2082880ULL, 0x8082801628808099ULL, 0x0000000000031028ULL, 0x2880809992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000001c000000000ULL, 0x00015c5000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8098288080990900ULL, 0x0000000000002880ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809908288080ULL,
0x80b008288080ae08ULL, 0x08288080b2082880ULL, 0x8082801628808098ULL, 0x0000000000031028ULL,
0x2880809892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000026800000000ULL,
0x00015ca000000000ULL, 0x0000016000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL,
0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL,
0x0000001800080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL,
0x00000000000c1704ULL, 0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400801b03ULL, 0x0134290400000b70ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01342804ffffffffULL, 0x0000055000000330ULL, 0x000028c0000005a0ULL, 0x00002a9000002970ULL,
0x0000308000002bf0ULL, 0x00003100000030b0ULL, 0x000058d000003150ULL, 0x00005aa000005970ULL,
0x0000609000005c00ULL, 0x00006110000060c0ULL, 0x000086b000006160ULL, 0x0000888000008750ULL,
0x00008e70000089e0ULL, 0x00008ef000008ea0ULL, 0x0000b50000008f40ULL, 0x0000b6d00000b5a0ULL,
0x0000bcc00000b830ULL, 0x0000bd400000bcf0ULL, 0x0000d7c00000bd90ULL, 0x000143100000d7d0ULL,
0x0001436000014350ULL, 0x000143c000014370ULL, 0x00014400000143e0ULL, 0x000150d000014410ULL,
0x0001516000015110ULL, 0x000151f0000151a0ULL, 0x0001529000015240ULL, 0x00015320000152d0ULL,
0x000153b000015360ULL, 0x0001545000015400ULL, 0x000154e000015490ULL, 0x0001557000015520ULL,
0x00015610000155c0ULL, 0x000156a000015650ULL, 0x00015730000156e0ULL, 0x000157d000015780ULL,
0x0001589000015830ULL, 0x00015950000158f0ULL, 0x00015a10000159b0ULL, 0x0440390400015a70ULL,
0x000000ff00000420ULL, 0x003f01000000f600ULL, 0x0000000f00000460ULL, 0x003f01200000f608ULL,
0x0000000f000004f0ULL, 0x003f01200000f688ULL, 0x0000000f00000510ULL, 0x003f01200000f6a8ULL,
0x0000000f00000520ULL, 0x003f01200000f6c8ULL, 0x000000ff00000b90ULL, 0x003f01070000f600ULL,
0x0000000700000d80ULL, 0x003f010200000004ULL, 0x0000000700000e40ULL, 0x003f010100000000ULL,
0x0000000400001650ULL, 0x003f01070000f6a8ULL, 0x00000004000017a0ULL, 0x003f01010000f6a8ULL,
0x0000000c00001800ULL, 0x003f01010000f6c8ULL, 0x00000019000019b0ULL, 0x003f01050000f6ccULL,
0x0000001900001b90ULL, 0x003f01050000f6ccULL, 0x0000001a000024b0ULL, 0x003f01070000f6b0ULL,
0x0000001a00002560ULL, 0x003f01010000f6b0ULL, 0x0000000d000025c0ULL, 0x003f01010000f608ULL,
0x0000000d000025e0ULL, 0x003f01050000f60cULL, 0x0000000d000027b0ULL, 0x003f01050000f60cULL,
0x0000003600002de0ULL, 0x003f01050000f6acULL, 0x0000003600002fb0ULL, 0x003f01050000f6acULL,
0x0000001000004a60ULL, 0x003f010100000000ULL, 0x0000000c00004ac0ULL, 0x003f01010000f688ULL,
0x0000000400004af0ULL, 0x003f010500000004ULL, 0x0000000400004cb0ULL, 0x003f010500000004ULL,
0x0000000c000054e0ULL, 0x003f01070000f6a8ULL, 0x0000000c000055b0ULL, 0x003f01010000f6a8ULL,
0x0000000d00005610ULL, 0x003f01010000f628ULL, 0x0000000d00005630ULL, 0x003f01050000f62cULL,
0x0000000d00005800ULL, 0x003f01050000f62cULL, 0x0000003a00005df0ULL, 0x003f01050000f6b4ULL,
0x0000003a00005fc0ULL, 0x003f01050000f6b4ULL, 0x0000001800007840ULL, 0x003f010100000000ULL,
0x0000000c000078a0ULL, 0x003f01010000f690ULL, 0x00000004000078d0ULL, 0x003f010500000004ULL,
0x0000000400007a90ULL, 0x003f010500000004ULL, 0x0000000c000082c0ULL, 0x003f01070000f6b0ULL,
0x0000000c00008390ULL, 0x003f01010000f6b0ULL, 0x0000000d000083f0ULL, 0x003f01010000f648ULL,
0x0000000d00008410ULL, 0x003f01050000f64cULL, 0x0000000d000085e0ULL, 0x003f01050000f64cULL,
0x0000003800008bd0ULL, 0x003f01050000f6acULL, 0x0000003800008da0ULL, 0x003f01050000f6acULL,
0x000000120000a620ULL, 0x003f010100000000ULL, 0x0000000f0000a680ULL, 0x003f01010000f698ULL,
0x000000040000a6b0ULL, 0x003f010500000004ULL, 0x000000040000a870ULL, 0x003f010500000004ULL,
0x0000000c0000b160ULL, 0x003f01070000f6a8ULL, 0x0000000c0000b1f0ULL, 0x003f01010000f6a8ULL,
0x000000050000b250ULL, 0x003f01010000f668ULL, 0x000000050000b280ULL, 0x003f01050000f66cULL,
0x000000050000b450ULL, 0x003f01050000f66cULL, 0x000000120000ba20ULL, 0x003f01050000f6b4ULL,
0x000000120000bbf0ULL, 0x003f01050000f6b4ULL, 0x000000040000d570ULL, 0x003f010100000000ULL,
0x0000000e0000d5f0ULL, 0x003f010100000000ULL, 0x000000ff0000e9e0ULL, 0x003f01010000f600ULL,
0x000000ff0000f610ULL, 0x003f01050000f604ULL, 0x000000ff0000f820ULL, 0x003f01050000f604ULL,
0x000000ff0000fa50ULL, 0x003f01010000f600ULL, 0x000000ff0000fa80ULL, 0x003f01050000f604ULL,
0x000000ff0000fc40ULL, 0x003f01050000f604ULL, 0x00000076000126d0ULL, 0x003f010100000000ULL,
0x0000007600012770ULL, 0x003f010500000004ULL, 0x0000007600012940ULL, 0x003f010500000004ULL,
0x0000007900014f30ULL, 0x003f010100000000ULL, 0x0000007900014f90ULL, 0x003f010100000008ULL,
0x0000007900014ff0ULL, 0x003f010100000010ULL, 0x0000007900015060ULL, 0x003f010100000018ULL,
0x00201c0400053803ULL, 0x0000e0c00000e090ULL, 0x0000e5500000e360ULL, 0x0000e9000000e750ULL,
0x000150a00000fca0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002ecULL,
0x0000001b00000002ULL, 0x0000000000000244ULL, 0x0000001b00000002ULL, 0x00000000000001acULL,
0x0000001b00000002ULL, 0x00000000000000f4ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x00000000000002c3ULL, 0x0000001b00000002ULL, 0x000000000000021bULL,
0x0000001b00000002ULL, 0x0000000000000185ULL, 0x0000001b00000002ULL, 0x00000000000000cbULL,
0x0000001b00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff060424ULL, 0x000fe200078e00ffULL,
0x0000000105020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0006ULL,
0x00005c0005060625ULL, 0x000fe200078e0006ULL, 0x00000006020b0981ULL, 0x0002a8000c1e1900ULL,
0x0000000606040981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff737624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000787919ULL, 0x000e620000002600ULL, 0x00005a00ff117624ULL, 0x000fc600078e00ffULL,
0x00000000000e7919ULL, 0x000e620000002300ULL, 0x0000590011117a24ULL, 0x000fe200078e02ffULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00087810ULL, 0x010fcc0007ffe0ffULL,
0x0000000800097305ULL, 0x000864000021f000ULL, 0x000000ffff087224ULL, 0x010fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a09ULL, 0x000059000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d09097227ULL, 0x000fe400078e0008ULL, 0x00000000000d7919ULL, 0x000e680000002100ULL,
0x0000040009097a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a09ULL,
0x0000040002007624ULL, 0x000fca00078e0273ULL, 0x0000590000007a0cULL, 0x000fe40003f26070ULL,
0x00000005ff0a7819ULL, 0x002fd6000001160dULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000e620000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002e4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000309067224ULL, 0x008fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x0000000703037227ULL, 0x000fe400078e0002ULL, 0x0000000000077919ULL, 0x000e680000002200ULL,
0x0000007803747227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a74ULL,
0x0000000009007224ULL, 0x000fca00078e0278ULL, 0x000000090000720cULL, 0x000fe20003fa6070ULL,
0x000001000e027a24ULL, 0x002fe400078e0207ULL, 0x00001fff0e0e7589ULL, 0x000fe400000e0000ULL,
0x00000000020f7a24ULL, 0x000fd000078e020dULL, 0x0000000100005824ULL, 0x000fe200078e0a09ULL,
0x0000000174745810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000090000720cULL, 0x000fe40003fc6070ULL, 0x0000000f0f00780cULL, 0x040fe40003f24070ULL,
0x000000030f00780cULL, 0x040fe40003fa4070ULL, 0x0000007f0f00780cULL, 0x000fca0003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x0000000174746810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL, 0x00000009ff74c212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff069424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00b388ULL, 0x0003e20000000a00ULL, 0x000000ffff087224ULL, 0x000fe200078e0a74ULL,
0x000000010f00780cULL, 0x000fe20003f64070ULL, 0xff317217ff10a424ULL, 0x000fe200078e00ffULL,
0x00f608060f009388ULL, 0x0007e20000008a00ULL, 0x0000000809787224ULL, 0x000fc400078e0278ULL,
0x3fffff80ff08d424ULL, 0x000fe200078e00ffULL, 0x00f400100f00a388ULL, 0x000fe20000004800ULL,
0x0000001078787824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff02d424ULL, 0x002fe400078e00ffULL,
0x7fffff60ff03d424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff09d424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL, 0x00f688020f00d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL, 0x00f6a8080f00d388ULL, 0x000fe80000008a00ULL,
0x00f6c80c0f00b388ULL, 0x000fe20000008a00ULL, 0x000000010b000824ULL, 0x004fe400078e0a04ULL,
0x00005800ff008624ULL, 0x000fe200078e00ffULL, 0x00001fff0a0b7589ULL, 0x000e6200000e0000ULL,
0x0000580005048a24ULL, 0x000fe400078e02ffULL, 0x00005a0000077a24ULL, 0x008fc400078e02ffULL,
0x0000001104767224ULL, 0x000fe400078e02ffULL, 0x0000000107067824ULL, 0x040fe200078e0a78ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000780700720cULL, 0x000fe20003f26070ULL,
0x00005a0074137a24ULL, 0x000fe200078e0276ULL, 0x0000001006067817ULL, 0x000fc80003800000ULL,
0x000000ff06757207ULL, 0x000fc80000800000ULL, 0x000000107500780cULL, 0x000fe20003f05270ULL,
0x000000040e027824ULL, 0x002fc800078e020bULL, 0x0000000202087824ULL, 0x000fd000078e00ffULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000497919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x00000004ff077819ULL, 0x004fca0000011649ULL, 0x0000000108097824ULL, 0x000fe200078e0207ULL,
0x0ffffffe06037810ULL, 0x002fe20007ffe0ffULL, 0x0000001049067824ULL, 0x000fca00078e00ffULL,
0x0000000300037305ULL, 0x000e64000021f000ULL, 0x000000ffff0d7224ULL, 0x002fc800078e0a03ULL,
0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL, 0x0000000d030d7227ULL, 0x000fc800078e0002ULL,
0x0000000178027824ULL, 0x000fc800078e0209ULL, 0x000000020d0d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0f7224ULL, 0x000fc800078e0a0dULL, 0x00005a000f037a24ULL, 0x000fca00078e0202ULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d0810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0daa12ULL, 0x000fca00078e33ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a0dULL, 0x00005a0003027a24ULL, 0x000fe200078e0202ULL,
0x0000000875037217ULL, 0x000fc60007800000ULL, 0x0000000113027824ULL, 0x000fe400078e0202ULL,
0x0000000103087824ULL, 0x000fe400078e0a08ULL, 0x000000110d027224ULL, 0x000fe200078e0202ULL,
0x000000f0060d7812ULL, 0x000fe400078ec0ffULL, 0x000000080700720cULL, 0x000fe20003f06070ULL,
0x0000010002027825ULL, 0x000fc800078e00ffULL, 0x0000000109077824ULL, 0x040fe200078e0249ULL,
0x0000000d020d7212ULL, 0x000fe200078efcffULL, 0x0000001009087824ULL, 0x000fc600078e00ffULL,
0x000060000d027a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff008077812ULL, 0x000fe400078ee207ULL,
0x0000610003037a10ULL, 0x000fc60000ffe4ffULL, 0x0000001007077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000497919ULL, 0x000ea20000000000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x0000000849087211ULL, 0x004fe400078fe0ffULL, 0x0ffffffe06097810ULL, 0x002fca0007ffe0ffULL,
0x0000000900037305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a03ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000703037227ULL, 0x000fc800078e0002ULL,
0x0000000178027824ULL, 0x000fc800078e0208ULL, 0x0000000203037227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a03ULL, 0x00005a0007067a24ULL, 0x000fca00078e0202ULL,
0x00005a0006007a0cULL, 0x000fda0003f06070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe20003f26070ULL,
0x0000001049067824ULL, 0x000fca00078e00ffULL, 0x000000f006097812ULL, 0x000fce00078ec0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff03aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a03ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000000108077824ULL, 0x040fe400078e0249ULL, 0x0000000113027824ULL, 0x000fe400078e0202ULL,
0x0000001008087824ULL, 0x000fe400078e00ffULL, 0x0000001103027224ULL, 0x000fc600078e0202ULL,
0xfffffff008077812ULL, 0x000fe200078ee207ULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x0000000902027212ULL, 0x000fc800078efcffULL,
0x0000600002027a10ULL, 0x000fc80007f1e0ffULL, 0x0000610003037a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000b901c46ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000000000077806ULL, 0x000fe200038e0000ULL,
0x00000004ff3a7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000700027300ULL, 0x000e7000000e0000ULL, 0x0000000700087309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x0000680005027625ULL, 0x000fc800078e003aULL,
0x000000ffff087224ULL, 0x004fd000078e0a08ULL, 0x00f60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006020a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x0000003f0a097810ULL, 0x044fe40007ffe0ffULL, 0x000000ff0a107810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff097819ULL, 0x000fe40000011609ULL, 0x00000008ff087819ULL, 0x002fca0000011610ULL,
0x0000dc4000008947ULL, 0x000fea0003800000ULL, 0x00000002ff727819ULL, 0x000fe2000001160bULL,
0x00000003ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000f6880b077811ULL, 0x000fe400078e18ffULL,
0x03ffffff72047812ULL, 0x000fc800078ec0ffULL, 0x000000090400720cULL, 0x000fda0003f06070ULL,
0x0000000205008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff038624ULL, 0x000fc800078e00ffULL,
0x00006a0000038624ULL, 0x000fe400078e0203ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x0000000104038824ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040c07ff738cULL, 0x0003e20000000000ULL, 0x0000660003028625ULL, 0x000fe200078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000602008981ULL, 0x000ea2000c1e1900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x0000004074557824ULL, 0x000fe200078e00ffULL,
0x00000001ff547819ULL, 0x000fe2000001160bULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000007ff7f8cULL, 0x0007e6000c80043fULL, 0x0000002054777824ULL, 0x000fca00078e00ffULL,
0x00000020550e7812ULL, 0x000fe200078ef877ULL, 0x0000590000007a24ULL, 0x004fc800078e02ffULL,
0x00000040000c7824ULL, 0x002fe200078e00ffULL, 0x000000010b007812ULL, 0x000fc600078ec0ffULL,
0x000064000c027625ULL, 0x000fe200078e000dULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x000000770a0c7217ULL, 0x008fe20007800000ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fc60000011649ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a77ULL,
0x000000040d117810ULL, 0x000fe20007ffe0ffULL, 0x00000001070f7824ULL, 0x000fe200078e020dULL,
0x0000000c0d127810ULL, 0x000fe40007ffe0ffULL, 0x000000070c0c7217ULL, 0x000fe20007800000ULL,
0x000000010f107824ULL, 0x040fe400078e0249ULL, 0x000000080f137824ULL, 0x000fe400078e00ffULL,
0x000000010c0c7824ULL, 0x000fc600078e0a07ULL, 0xfffffff813147812ULL, 0x000fe200078ee210ULL,
0x0000000107137824ULL, 0x000fe200078e0212ULL, 0x000000080d107810ULL, 0x040fe40007ffe0ffULL,
0x0000000c0d00720cULL, 0x080fe20003f66070ULL, 0x000000010e0d7824ULL, 0x000fe200078e020fULL,
0x0000000c1100720cULL, 0x080fe20003f46070ULL, 0x0000000107117824ULL, 0x040fe200078e0211ULL,
0x0000000c1000720cULL, 0x080fe20003f26070ULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x0000000c1200720cULL, 0x000fe20003f06070ULL, 0x000000800d0c7825ULL, 0x000fc800078e00ffULL,
0x000000010e157824ULL, 0x000fe200078e0213ULL, 0x000000700c177812ULL, 0x000fe200078ef806ULL,
0x00000001130c7824ULL, 0x000fe400078e0249ULL, 0x000000010e0f7824ULL, 0x000fe200078e0211ULL,
0x0000001702127210ULL, 0x000fe20007f9e0ffULL, 0x0000000111077824ULL, 0x040fe400078e0249ULL,
0x0000000811167824ULL, 0x000fe400078e00ffULL, 0x0000000813137824ULL, 0x000fc400078e00ffULL,
0x000000010e117824ULL, 0x000fe200078e0210ULL, 0xfffffff816167812ULL, 0x000fe200078ee207ULL,
0x00000001100e7824ULL, 0x040fe200078e0249ULL, 0xfffffff8131a7812ULL, 0x000fe200078ee20cULL,
0x0000000810197824ULL, 0x000fe200078e00ffULL, 0x0000b00054077811ULL, 0x000fe200078e68ffULL,
0x0000000103137824ULL, 0x000fe400020e060dULL, 0x000000800f0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff819187812ULL, 0x000fc600078ee20eULL, 0x00000080110e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1f7812ULL, 0x000fc600078ef806ULL, 0x0000008015107825ULL, 0x000fe200078e00ffULL,
0x000000700e1d7812ULL, 0x000fc600078ef806ULL, 0x0000001014157824ULL, 0x100fe200078e0207ULL,
0x00000070101b7812ULL, 0x000fe200078ef806ULL, 0x0000001016177824ULL, 0x100fe200078e0207ULL,
0x0000001f02067210ULL, 0x000fe20007f9e0ffULL, 0x0000001018197824ULL, 0x100fe200078e0207ULL,
0x0000001d020c7210ULL, 0x040fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000d901c46ULL, 0x0000001b02027210ULL, 0x000fe20007fde0ffULL,
0x000000101a1b7824ULL, 0x000fe400078e0207ULL, 0x0000000103077824ULL, 0x000fc400020e060dULL,
0x00000001030d7824ULL, 0x040fe400028e060fULL, 0x0000000103037824ULL, 0x000fe200030e0611ULL,
0x0000000006177faeULL, 0x0003e8000d101c46ULL, 0x000000000c197faeULL, 0x0003e8000c901c46ULL,
0x00000000021b7faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x008fe200078e00ffULL, 0x0000b000541f7811ULL, 0x000fc800078e68ffULL,
0x0000000c49077211ULL, 0x000fc800078fe8ffULL, 0x00000004070f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001070d7824ULL, 0x040fe200078e0249ULL, 0x0000000807117810ULL, 0x040fe20007ffe0ffULL,
0x0000000807147824ULL, 0x040fe200078e00ffULL, 0x0000000c07127810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0c7824ULL, 0x040fe400078e0207ULL, 0x000000010e077824ULL, 0x000fe200078e020fULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010f107824ULL, 0x040fe200078e0249ULL, 0x000000700c137812ULL, 0x000fe200078ef806ULL,
0x000000080f177824ULL, 0x000fe400078e00ffULL, 0x000000010e0f7824ULL, 0x040fe400078e0211ULL,
0x000000010e157824ULL, 0x000fe200078e0212ULL, 0xfffffff817167812ULL, 0x000fe200078ee210ULL,
0x00000001120c7824ULL, 0x140fe400078e0249ULL, 0x0000000812197824ULL, 0x000fe200078e00ffULL,
0x0000001302127210ULL, 0x000fe20007f1e0ffULL, 0x00000001110e7824ULL, 0x000fc400078e0249ULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0xfffffff8191a7812ULL, 0x000fe200078ee20cULL,
0x0000000103137824ULL, 0x000fe400000e060dULL, 0x00000080070c7825ULL, 0x000fe200078e00ffULL,
0xfffffff811187812ULL, 0x000fc600078ee20eULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1d7812ULL, 0x000fc600078ef806ULL, 0x0000008015107825ULL, 0x000fe200078e00ffULL,
0x000000700e1b7812ULL, 0x000fc600078ef806ULL, 0x0000001014157824ULL, 0x100fe200078e021fULL,
0x0000007010077812ULL, 0x000fe200078ef806ULL, 0x0000001016177824ULL, 0x100fe200078e021fULL,
0x0000001d02067210ULL, 0x000fe20007f1e0ffULL, 0x0000001018197824ULL, 0x100fe200078e021fULL,
0x0000001b020c7210ULL, 0x000fe20007f3e0ffULL, 0x000000101a1b7824ULL, 0x000fe200078e021fULL,
0x0000000702027210ULL, 0x000fe20007f5e0ffULL, 0x0000000103077824ULL, 0x040fe200000e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012157faeULL, 0x0003e2000b901c46ULL,
0x00000001030d7824ULL, 0x000fc400008e060fULL, 0x0000000103037824ULL, 0x000fe200010e0611ULL,
0x0000000006177faeULL, 0x0003e8000b901c46ULL, 0x000000000c197faeULL, 0x0003e8000b901c46ULL,
0x00000000021b7faeULL, 0x0003e4000b901c46ULL, 0x0000000104077810ULL, 0x002fe20007ffe0ffULL,
0x0000001054047824ULL, 0x000fc400078e00ffULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x000000090700720cULL, 0x000fe20003f06070ULL, 0x00000000040473c2ULL, 0x000e5800000e0000ULL,
0x0000000205028824ULL, 0x000fe400078e00ffULL, 0x00006a00ff038624ULL, 0x000fc800078e00ffULL,
0x00006a0002028624ULL, 0x000fc800078e0203ULL, 0x00000001023b8824ULL, 0x000fe200078e0207ULL,
0x0000f6a804047890ULL, 0x002fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000066003b3a8625ULL, 0x000fca00078e003aULL, 0x000000063a068981ULL, 0x000322000c1e1900ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x00000008540c7824ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x00f6a80004027f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c8000c0c7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000bd8000008947ULL, 0x000fea0003800000ULL, 0x00000010040f7812ULL, 0x000fe200078ec0ffULL,
0x0000000205567824ULL, 0x000fc400078e00ffULL, 0x00006a00ff197624ULL, 0x000fe400078e00ffULL,
0x0000002072057824ULL, 0x000fe400078e020fULL, 0x000000ffff3c7224ULL, 0x004fe400078e0003ULL,
0x000000ffff187224ULL, 0x008fe400078e000dULL, 0x00006a0056567624ULL, 0x000fe400078e0219ULL,
0x0000000800057824ULL, 0x000fc400078e0205ULL, 0xff317217ff3e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff487224ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fc400078e00ffULL,
0x000000ffff717224ULL, 0x00afca00078e0007ULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x000000040b047824ULL, 0x002fca00078e00ffULL, 0xfffffff804197812ULL, 0x000fc800078ec0ffULL,
0x0000f6c819047810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc00190f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c1b7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x0000001b0e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc00190f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100b0e7824ULL, 0x000fe200078e00ffULL,
0x00000001480f7810ULL, 0x000fe20007ffe0ffULL, 0x0000590006067a24ULL, 0x010fc600078e02ffULL,
0xffffffe00e0d7812ULL, 0x000fe200078ec0ffULL, 0x00000040060c7824ULL, 0x000fe200078e00ffULL,
0x000000080f00720cULL, 0x000fc60003f26070ULL, 0x00000100480d7824ULL, 0x000fca00078e020dULL,
0x000000400d197810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fc600078e00ffULL,
0x0000002019067812ULL, 0x000fe200078ec0ffULL, 0x000064000c0c7625ULL, 0x000fc800078e000dULL,
0x0000000155357824ULL, 0x000fe200078e0206ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x000000190a067217ULL, 0x000fe40007800000ULL, 0x000000100e0f7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff1a7819ULL, 0x000fe20000011649ULL, 0x0000000106067824ULL, 0x000fc600078e0a19ULL,
0x000000041a197810ULL, 0x040fe20007ffe0ffULL, 0x000000011a0e7824ULL, 0x000fe200078e020fULL,
0x0000000f06067217ULL, 0x000fe40007800000ULL, 0x000000081a347810ULL, 0x000fe20007ffe0ffULL,
0x000000010e187824ULL, 0x000fe200078e0249ULL, 0x0000000c1a377810ULL, 0x000fe20007ffe0ffULL,
0x000000080e1b7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x100fe400078e0a0fULL,
0x0000000137387824ULL, 0x100fe200078e020fULL, 0xfffffff81b367812ULL, 0x000fe200078ee218ULL,
0x0000000119187824ULL, 0x040fe200078e020fULL, 0x000000061900720cULL, 0x080fe20003f66070ULL,
0x00000010491b7824ULL, 0x000fe200078e00ffULL, 0x000000061a00720cULL, 0x080fe20003f86070ULL,
0x0000000118197824ULL, 0x000fe200078e0249ULL, 0x000000063400720cULL, 0x080fe20003f46070ULL,
0x00000008183a7824ULL, 0x000fe200078e00ffULL, 0x000000063700720cULL, 0x000fe20003f06070ULL,
0x00000001341a7824ULL, 0x000fe200078e020fULL, 0x000000701b3f7812ULL, 0x000fe200078ec0ffULL,
0x00000001350e7824ULL, 0x040fe200078e020eULL, 0xfffffff83a067812ULL, 0x000fe200078ee219ULL,
0x0000000135187824ULL, 0x000fc400078e0218ULL, 0x00000001351b7824ULL, 0x000fe400078e021aULL,
0x000000011a347824ULL, 0x040fe400078e0249ULL, 0x000000081a377824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x00000001381a7824ULL, 0x000fe200078e0249ULL,
0x0000003f0e397212ULL, 0x000fe200078efcffULL, 0x00000008383b7824ULL, 0x000fe400078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000390c0e7210ULL, 0x000fe40007fbe0ffULL,
0xfffffff83b3a7812ULL, 0x000fe200078ee21aULL, 0x0000000135357824ULL, 0x000fe200078e0238ULL,
0xfffffff837387812ULL, 0x000fe200078ee234ULL, 0x000000801b1a7825ULL, 0x000fe200078e00ffULL,
0x0000003f18377212ULL, 0x000fc600078efcffULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x000000370c187210ULL, 0x000fe40007fde0ffULL, 0x0000003f1a417212ULL, 0x080fe200078efcffULL,
0x000000010d0f7824ULL, 0x040fe200028e060fULL, 0x0000003f343f7212ULL, 0x000fe200078efcffULL,
0x000000010d197824ULL, 0x000fe200030e0619ULL, 0x0000c00054377811ULL, 0x000fe400078e68ffULL,
0x000000410c1a7210ULL, 0x040fe40007fbe0ffULL, 0x0000003f0c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001036397824ULL, 0x000fc400078e0237ULL, 0x00000010063b7824ULL, 0x100fe400078e0237ULL,
0x00000010383f7824ULL, 0x000fe200078e0237ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e397faeULL, 0x0003e2000e101c46ULL, 0x000000010d1b7824ULL, 0x040fe400028e061bULL,
0x000000103a377824ULL, 0x000fe200078e0237ULL, 0x00000000183b7faeULL, 0x0003e2000d901c46ULL,
0x000000010d0d7824ULL, 0x000fc600030e0635ULL, 0x000000001a3f7faeULL, 0x0003e8000d101c46ULL,
0x000000000c377faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x000000100e067812ULL, 0x000fe200078ec0ffULL, 0x00000010490e7824ULL, 0x040fe200078e00ffULL,
0x0000c00054457811ULL, 0x000fe400078e68ffULL, 0x0000000649067211ULL, 0x000fe400078fe8ffULL,
0x000000700e3f7812ULL, 0x000fc400078ec0ffULL, 0x0000000406187810ULL, 0x040fe20007ffe0ffULL,
0x00000001060f7824ULL, 0x040fe200078e0249ULL, 0x00000008061a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000806367824ULL, 0x040fe200078e00ffULL, 0x0000000c06347810ULL, 0x000fe20007ffe0ffULL,
0x00000001350e7824ULL, 0x040fe400078e0206ULL, 0x0000000135197824ULL, 0x000fe200078e0218ULL,
0xfffffff836367812ULL, 0x000fe200078ee20fULL, 0x0000000118067824ULL, 0x040fe400078e0249ULL,
0x0000000818397824ULL, 0x000fc400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff839067812ULL, 0x000fe200078ee206ULL, 0x00000001351b7824ULL, 0x000fe200078e021aULL,
0x0000003f0e377212ULL, 0x000fe200078efcffULL, 0x000000011a187824ULL, 0x140fe400078e0249ULL,
0x000000081a3b7824ULL, 0x000fe200078e00ffULL, 0x000000370c0e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001341a7824ULL, 0x040fe400078e0249ULL, 0x0000000834417824ULL, 0x000fe200078e00ffULL,
0xfffffff83b387812ULL, 0x000fe200078ee218ULL, 0x0000000135357824ULL, 0x000fc400078e0234ULL,
0x0000008019187825ULL, 0x000fe200078e00ffULL, 0xfffffff8413a7812ULL, 0x000fc600078ee21aULL,
0x000000801b1a7825ULL, 0x000fe200078e00ffULL, 0x0000003f18437212ULL, 0x000fc600078efcffULL,
0x0000008035347825ULL, 0x000fe200078e00ffULL, 0x0000003f1a417212ULL, 0x000fc600078efcffULL,
0x000000010d0f7824ULL, 0x040fe200000e060fULL, 0x0000003f343f7212ULL, 0x000fe200078efcffULL,
0x0000001036377824ULL, 0x100fe200078e0245ULL, 0x000000430c187210ULL, 0x000fe20007f1e0ffULL,
0x0000001006397824ULL, 0x100fe200078e0245ULL, 0x000000410c1a7210ULL, 0x000fe20007f5e0ffULL,
0x00000010383b7824ULL, 0x000fe200078e0245ULL, 0x0000003f0c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d197824ULL, 0x040fe200000e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e377faeULL, 0x0003e2000b901c46ULL, 0x000000010d1b7824ULL, 0x000fc400010e061bULL,
0x000000103a3f7824ULL, 0x000fe200078e0245ULL, 0x0000000018397faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e0635ULL, 0x000000001a3b7faeULL, 0x0003e8000b901c46ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c46ULL, 0x000000080b067824ULL, 0x000fe200078e00ffULL,
0x0000000107187810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff0f7424ULL, 0x000fc600078e00ffULL,
0xfffffff0061a7812ULL, 0x000fe400078ec0ffULL, 0x000000091800720cULL, 0x000fe40003f06070ULL,
0x000000001a0473c2ULL, 0x000e6200000e0000ULL, 0xffffffe0060d7812ULL, 0x040fe400078ec0ffULL,
0x00000010060c7812ULL, 0x040fe400078ec0ffULL, 0x0000000806067812ULL, 0x000fcc00078ec0ffULL,
0x0000000156188824ULL, 0x000fe400078e0218ULL, 0x00000004ff198424ULL, 0x000fe200078e00ffULL,
0x0000000d060d7210ULL, 0x000fe40007ffe00cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000660018188625ULL, 0x000fca00078e0019ULL, 0x00000006180f8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b0001a1a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608000d367f8cULL, 0x0004e4000c80043fULL, 0x0000000000187805ULL, 0x000fc40000015200ULL,
0x00f60c000d357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x00cfe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003418397210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e19ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011435ULL,
0x0000003906067211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000206067819ULL, 0x000fc80000001235ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c000d357984ULL, 0x000ea40000000800ULL,
0x8000000035ff7812ULL, 0x004fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001049517824ULL, 0x000fe200078e00ffULL, 0x00000001ff737819ULL, 0x000fe20000011649ULL,
0x000000200b067824ULL, 0x000fe400078e00ffULL, 0xffffffffff797424ULL, 0x000fe200078e00ffULL,
0x0000007051517812ULL, 0x000fc400078ec0ffULL, 0xffffff8006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c73737812ULL, 0x000fc800078ec0ffULL, 0x0000000673067210ULL, 0x000fca0007ffe051ULL,
0x00f0000006357984ULL, 0x000ea80000000800ULL, 0x00f20000060e7984ULL, 0x0006620000000800ULL,
0x0000003e3500720bULL, 0x004fe20003f1d000ULL, 0x000127f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c377812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fc400078e003eULL, 0x0000001fff7b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff7a7424ULL, 0x000fca00078e00ffULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x0000000b7200720cULL, 0x000fe40003f05270ULL, 0x0000003e3500720bULL, 0x000fe20003f54000ULL,
0x000127827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000067806ULL, 0x000fc400010e0100ULL,
0x000000800b0c8824ULL, 0x000fe200078e0251ULL, 0x0000003e35197209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991006187816ULL, 0x000fe200000000ffULL,
0x00000001730c8824ULL, 0x000fca00078e020cULL, 0x00f400190c008388ULL, 0x0005e20000000800ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000193e0c7221ULL, 0x004fe20000010000ULL, 0x000000ff06ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00397308ULL, 0x000ea40000000800ULL, 0x000000393d3d7220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011649ULL,
0x000126b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c390c7589ULL, 0x0004e400000e0000ULL,
0x0000000c2c2c7220ULL, 0x08cfe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c14147220ULL, 0x080fe20000410000ULL, 0x0000000c15157220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0006ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490c7811ULL, 0x000fe200078ff0ffULL,
0x000125927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c390c7589ULL, 0x0004e400000e0000ULL,
0x0000000c2e2e7220ULL, 0x08cfe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c16167220ULL, 0x080fe20000410000ULL, 0x0000000c17177220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff37ff7812ULL, 0x000fe20007806006ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000003e35067209ULL, 0x000fd60007810000ULL,
0x8000000635350221ULL, 0x000fe20000010000ULL, 0x00007610ff0c0816ULL, 0x000fc6000000000cULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500030308ULL, 0x000ea40000000800ULL,
0x000000030e0e0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000003d0e0e7221ULL, 0x002fc20000010000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x000000080b347824ULL, 0x000fca00078e00ffULL, 0xfffffff034367812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0036357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003418377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e19ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0036357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100c0c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff347819ULL, 0x000fe40000011649ULL,
0x0000541000357816ULL, 0x000fe20000000000ULL, 0x000121427f007947ULL, 0x000fea000b800000ULL,
0x00001f3435027589ULL, 0x0002a400000e0000ULL, 0x00000008340c7810ULL, 0x000fe20007ffe0ffULL,
0x000121727f007947ULL, 0x000fea000b800000ULL, 0x00001f0c35007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010340c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0035ULL, 0x0000311000197802ULL, 0x000fc40000000f00ULL,
0x00012b4000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018340c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0035ULL,
0x0000316000197802ULL, 0x000fc40000000f00ULL, 0x00012af000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000020b0c7824ULL, 0x00cfe200078e00ffULL,
0x0000000749197812ULL, 0x000fe200078ec0ffULL, 0x000002000b447824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000040c187812ULL, 0x000fc400078ec0ffULL,
0x0000000819387812ULL, 0x000fe400078ef849ULL, 0x0000001849357211ULL, 0x042fe400078fe0ffULL,
0xfffff80044447812ULL, 0x000fe200078ec0ffULL, 0x0000000838597824ULL, 0x040fe200078e00ffULL,
0x0000000849187812ULL, 0x000fe200078ec0ffULL, 0x0000000138587824ULL, 0x000fca00078e0235ULL,
0xfffffff859597812ULL, 0x000fca00078ee258ULL, 0x0000001059597824ULL, 0x000fc800078e00ffULL,
0x00000001594b7824ULL, 0x000fc400078e0244ULL, 0x000000040b357824ULL, 0x000fe200078e00ffULL,
0x00000004ff367819ULL, 0x000fe20000011649ULL, 0x00000008383b7824ULL, 0x000fe200078e00ffULL,
0x0000001918347212ULL, 0x000fe400078efcffULL, 0x0000000435357812ULL, 0x000fe400078ec0ffULL,
0x0000b00054577811ULL, 0x000fe200078e68ffULL, 0x00000008344a7824ULL, 0x000fe200078e00ffULL,
0x0000001018407812ULL, 0x000fe200078efe19ULL, 0x0000000136397824ULL, 0x000fe200078e0235ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000834377824ULL, 0x000fc400078e00ffULL,
0x0000000134357824ULL, 0x000fe400078e0239ULL, 0x0000000139417824ULL, 0x000fe400078e0240ULL,
0x0000000840427824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee235ULL,
0x0000000840467824ULL, 0x000fe200078e00ffULL, 0x00000002354e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000454357824ULL, 0x000fe200078e0236ULL, 0xfffffff8424d7812ULL, 0x000fe200078ee241ULL,
0x000000104a3c7824ULL, 0x000fe200078e0257ULL, 0xfffffff8374e7812ULL, 0x000fc400078ee24eULL,
0x00000002354c7810ULL, 0x000fe40007ffe038ULL, 0x00000002414f7810ULL, 0x000fe20007ffe0ffULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x000000104e347824ULL, 0x000fe200078e0257ULL,
0xfffffff83b4c7812ULL, 0x000fe400078ee24cULL, 0x009000004b38783bULL, 0x000ea20000000200ULL,
0xfffffff8464f7812ULL, 0x000fe400078ee24fULL, 0x000000104c4c7824ULL, 0x000fe200078e0244ULL,
0x000000003434783bULL, 0x000ee20000004200ULL, 0x00000018ff187819ULL, 0x002fc4000001163eULL,
0x0000ffff3e407812ULL, 0x000fe400078ec0ffULL, 0x00000018ff19723eULL, 0x000fe200020006ffULL,
0x0000000238388231ULL, 0x084fe200003400ffULL, 0x00000018ff187819ULL, 0x000fe2000001163fULL,
0x000000023a3a8231ULL, 0x000fe200003400ffULL, 0x0000ffff3f427812ULL, 0x000fe200078ec0ffULL,
0x20000019ff457230ULL, 0x000fe20000004100ULL, 0x00000018ff41723eULL, 0x000fe200020006ffULL,
0x0000000039398231ULL, 0x080fe200003400ffULL, 0x00000008ff187819ULL, 0x000fe20000011640ULL,
0x000000003b3b8231ULL, 0x000fe200003400ffULL, 0x00000008ff407819ULL, 0x000fe20000011642ULL,
0x20000041ff477230ULL, 0x000fe20000004100ULL, 0x00000018ff18723eULL, 0x000fc400020006ffULL,
0x00000040ff42723eULL, 0x000fe400020006ffULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x20000018ff197230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe2000001163eULL,
0x20000042ff467230ULL, 0x000fe20000004100ULL, 0x000000ff3e427812ULL, 0x000fe400078ec0ffULL,
0x000000ff18537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff187819ULL, 0x000fc40000011619ULL,
0x00000010ff3e7819ULL, 0x000fe40000011647ULL, 0x00000010ff197819ULL, 0x000fe40000011646ULL,
0x00000010ff437819ULL, 0x000fe4000001163fULL, 0x000000ff3f3f7812ULL, 0x000fe400078ec0ffULL,
0x0000105445187816ULL, 0x000fe40000000018ULL, 0x000010543e197816ULL, 0x000fc40000000019ULL,
0x000000ff435c7812ULL, 0x000fe400078ec0ffULL, 0x0000003fff43723eULL, 0x000fe400020006ffULL,
0x000000ff3c417812ULL, 0x000fe200078ec0ffULL, 0x000000183810723cULL, 0x000be20000041810ULL,
0x000000ff343f7812ULL, 0x008fe200078ec0ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000000ff35507812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x0000003fff47723eULL, 0x000fe400020006ffULL, 0x00000010ff197819ULL, 0x020fe4000001163cULL,
0x00000050ff3f723eULL, 0x000fe400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe4000001163dULL,
0x000000ff195a7812ULL, 0x000fe200078ec0ffULL, 0x20000041ff197230ULL, 0x000fe20000004100ULL,
0x000000ff3d407812ULL, 0x000fe200078ec0ffULL, 0x2000003fff417230ULL, 0x000fe20000004100ULL,
0x000000ff5b5b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff527819ULL, 0x100fe40000011634ULL,
0x00000010ff3f7819ULL, 0x000fe40000011634ULL, 0x0000ffff34347812ULL, 0x000fe400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000005aff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fe20000011634ULL, 0x20000040ff5d7230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x2000005bff5f7230ULL, 0x000fe20000004100ULL,
0x0000ffff3c3e7812ULL, 0x000fe200078ec0ffULL, 0x20000047ff407230ULL, 0x000fe20000004100ULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x20000052ff477230ULL, 0x000fe20000004100ULL,
0x00000018ff187819ULL, 0x000fc4000001163cULL, 0x00000018ff3c7819ULL, 0x000fe2000001163dULL,
0x20000034ff527230ULL, 0x000fe20000004100ULL, 0x0000ffff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff197819ULL, 0x000fe40000011619ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000008ff3e7819ULL, 0x000fe4000001163eULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff607819ULL, 0x000fe4000001165fULL, 0x00000018ff34723eULL, 0x000fe400020006ffULL,
0x000010545e187816ULL, 0x000fe40000000019ULL, 0x00000008ff3d7819ULL, 0x000fe2000001163dULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x0000105460197816ULL, 0x000fc4000000005dULL, 0x00000018ff507819ULL, 0x100fe20000011635ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe40000011635ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x00000018382c723cULL, 0x000b62000004182cULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x000000ff3f3f7812ULL, 0x000fe200078ec0ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x0000ffff35357812ULL, 0x000fe200078ec0ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000008ff357819ULL, 0x000fe20000011635ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x020fe20000011634ULL,
0x2000003fff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe2000001163eULL,
0x000000104d3f7824ULL, 0x000fe200078e0257ULL, 0x00000010ff187819ULL, 0x000fe40000011636ULL,
0x00000035ff5d723eULL, 0x000fc400020006ffULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff357819ULL, 0x000fe2000001163dULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x0000105419347816ULL, 0x000fe40000000034ULL, 0x000000ff185e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff187819ULL, 0x000fe40000011642ULL, 0x00000010ff197819ULL, 0x000fc40000011653ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff427819ULL, 0x000fe40000011637ULL, 0x000010543c357816ULL, 0x000fe40000000035ULL,
0x0000105419187816ULL, 0x000fe20000000018ULL, 0x000000003f3c783bULL, 0x000e620000004200ULL,
0x000010545c197816ULL, 0x000fe20000000043ULL, 0x000000104f437824ULL, 0x000fe200078e0257ULL,
0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL, 0x000000343828723cULL, 0x000b620000041828ULL,
0x000000ff42427812ULL, 0x000fc400078ec0ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000042ff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff347819ULL, 0x020fe20000011640ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe20000011641ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x000000004340783bULL, 0x000ea20000004200ULL,
0x000000ff36457812ULL, 0x000fe200078ec0ffULL, 0x000000183814723cULL, 0x000b620000041814ULL,
0x000000ff37467812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x0000005eff53723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x000010545b347816ULL, 0x000fe20000000034ULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x000010545a357816ULL, 0x000fe20000000035ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff537819ULL, 0x000fe20000011653ULL,
0x000000343830723cULL, 0x000be20000041830ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff187819ULL, 0x020fe40000011652ULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff347819ULL, 0x000fc40000011645ULL,
0x00000010ff357819ULL, 0x000fe40000011646ULL, 0x0000105453347816ULL, 0x000fe40000000034ULL,
0x000010545c357816ULL, 0x000fe40000000035ULL, 0x00000010ff197819ULL, 0x000fe4000001165dULL,
0x0000105447187816ULL, 0x000fe40000000018ULL, 0x0000105450197816ULL, 0x000fe20000000019ULL,
0x000000343820723cULL, 0x000be20000041820ULL, 0x000000ff3c627812ULL, 0x002fc400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001163cULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000018ff347819ULL, 0x020fe20000011636ULL, 0x000000183824723cULL, 0x000b620000041824ULL,
0x0000ffff36367812ULL, 0x000fe400078ec0ffULL, 0x00000018ff357819ULL, 0x000fe40000011637ULL,
0x00000008ff367819ULL, 0x000fc40000011636ULL, 0x00000010ff187819ULL, 0x020fe4000001163cULL,
0x0000ffff3c467812ULL, 0x000fe400078ec0ffULL, 0x00000010ff197819ULL, 0x100fe4000001163dULL,
0x000000ff3d5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff527819ULL, 0x000fe4000001163dULL,
0x0000ffff3d637812ULL, 0x000fc400078ec0ffULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x104fe40000011640ULL,
0x000000ff40687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe40000011640ULL,
0x0000ffff403d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff657819ULL, 0x100fe4000001163eULL,
0x000000ff3e507812ULL, 0x040fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fe4000001163eULL,
0x0000ffff3e5c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff537819ULL, 0x000fe40000011641ULL,
0x000000ff41697812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x0000ffff415a7812ULL, 0x000fe400078ec0ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000036ff36723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000034ff347230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe20000011642ULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x000000ff42417812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3e7819ULL, 0x000fe40000011642ULL, 0x0000ffff42457812ULL, 0x000fe200078ec0ffULL,
0x20000062ff427230ULL, 0x000fe20000004100ULL, 0x0000005eff6a723eULL, 0x000fe200020006ffULL,
0x20000061ff5e7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x2000006aff617230ULL, 0x000fe20000004100ULL,
0x00000060ff62723eULL, 0x000fe200020006ffULL, 0x20000052ff607230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fc4000001163fULL, 0x00000035ff35723eULL, 0x000fe200020006ffULL,
0x20000062ff527230ULL, 0x000fe20000004100ULL, 0x000000ff18187812ULL, 0x000fe400078ec0ffULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x0000005fff6a723eULL, 0x000fe200020006ffULL,
0x20000035ff5f7230ULL, 0x000fe20000004100ULL, 0x00000018ff62723eULL, 0x000fe200020006ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc40000011634ULL,
0x00000010ff187819ULL, 0x000fe20000011636ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe4000001165fULL, 0x0000105435187816ULL, 0x000fe40000000018ULL,
0x000000ff19357812ULL, 0x000fe400078ec0ffULL, 0x00000010ff197819ULL, 0x000fe40000011637ULL,
0x00000008ff467819ULL, 0x000fc40000011646ULL, 0x0000105434197816ULL, 0x000fe40000000019ULL,
0x00000046ff36723eULL, 0x000fe200020006ffULL, 0x2000006aff467230ULL, 0x000fe20000004100ULL,
0x00000035ff35723eULL, 0x000fe400020006ffULL, 0x00000008ff347819ULL, 0x000fe20000011663ULL,
0x20000036ff5f7230ULL, 0x000fe20000004100ULL, 0x000000183838723cULL, 0x000b62000004181cULL,
0x20000035ff637230ULL, 0x000fe20000004100ULL, 0x00000034ff6a723eULL, 0x000fc400020006ffULL,
0x009000004c34783bULL, 0x000e620000000200ULL, 0x00000010ff667819ULL, 0x000fe4000001163fULL,
0x0000005dff18723eULL, 0x020fe200020006ffULL, 0x2000006aff1c7230ULL, 0x000fe20000004100ULL,
0x00000040ff19723eULL, 0x000fe400020006ffULL, 0x0000ffff3f3f7812ULL, 0x000fe200078ec0ffULL,
0x20000018ff407230ULL, 0x000fe20000004100ULL, 0x00000041ff18723eULL, 0x000fe200020006ffULL,
0x20000019ff417230ULL, 0x000fe20000004100ULL, 0x00000018ff647819ULL, 0x000fc40000011643ULL,
0x00000008ff3f7819ULL, 0x000fe4000001163fULL, 0x0000003eff19723eULL, 0x000fe200020006ffULL,
0x20000018ff3e7230ULL, 0x000fe20000004100ULL, 0x000000ff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x0000003cff18723eULL, 0x000fe200020006ffULL, 0x20000019ff3c7230ULL, 0x000fe20000004100ULL,
0x000000ff43677812ULL, 0x000fe200078ec0ffULL, 0x2000003fff5d7230ULL, 0x000fe20000004100ULL,
0x00000008ff197819ULL, 0x000fe2000001163dULL, 0x20000064ff3d7230ULL, 0x000fe20000004100ULL,
0x000000ff531d7812ULL, 0x000fe200078ec0ffULL, 0x20000018ff537230ULL, 0x000fe20000004100ULL,
0x000000ff65657812ULL, 0x000fc400078ec0ffULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x00000067ff3f723eULL, 0x000fe400020006ffULL, 0x00000019ff64723eULL, 0x000fe400020006ffULL,
0x0000001dff67723eULL, 0x000fe200020006ffULL, 0x0000000234348231ULL, 0x082fe200003400ffULL,
0x00000010ff187819ULL, 0x000fe20000011642ULL, 0x0000000236368231ULL, 0x000fe200003400ffULL,
0x00000010ff197819ULL, 0x000fe20000011662ULL, 0x0000000035358231ULL, 0x080fe200003400ffULL,
0x00000010ff1d7819ULL, 0x000fe20000011661ULL, 0x0000000037378231ULL, 0x000fe200003400ffULL,
0x00000010ff627819ULL, 0x000fe20000011663ULL, 0x20000067ff617230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x20000064ff427230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x0000105419187816ULL, 0x000fe20000000018ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000105462197816ULL, 0x000fe2000000001dULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff5c7819ULL, 0x000fc4000001165cULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x00000018342c723cULL, 0x000b62000004182cULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff1d7819ULL, 0x000fe4000001161cULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x000010545e1c7816ULL, 0x000fe2000000005fULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00001054601d7816ULL, 0x000fe2000000001dULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x020fe40000011650ULL, 0x00000010ff197819ULL, 0x000fe40000011652ULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x0000001c3428723cULL, 0x000b620000041828ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x00000068ff1e723eULL, 0x000fe400020006ffULL,
0x00000069ff1f723eULL, 0x000fe400020006ffULL, 0x0000105465187816ULL, 0x000fe20000000018ULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x0000105466197816ULL, 0x000fe20000000019ULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00000010ff467819ULL, 0x000fe20000011646ULL,
0x000000183414723cULL, 0x000b640000041814ULL, 0x00000010ff1c7819ULL, 0x020fe4000001165cULL,
0x00000010ff1d7819ULL, 0x000fe4000001165dULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00001054471c7816ULL, 0x000fe4000000001cULL, 0x00001054461d7816ULL, 0x000fe2000000001dULL,
0x2000005aff527230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fc4000001161eULL,
0x00000010ff447819ULL, 0x000fe40000011643ULL, 0x00000010ff197819ULL, 0x000fe4000001161fULL,
0x00000010ff1e7819ULL, 0x000fe40000011661ULL, 0x0000ffff43437812ULL, 0x000fe400078ec0ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff44447812ULL, 0x000fc400078ec0ffULL,
0x000010541e197816ULL, 0x000fe40000000019ULL, 0x00000008ff457819ULL, 0x000fe20000011645ULL,
0x0000001c341c723cULL, 0x000b620000041810ULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff417819ULL, 0x000fe40000011641ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff117819ULL, 0x020fc40000011640ULL, 0x00000010ff107819ULL, 0x000fe40000011642ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000044ff5a723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x2000005bff507230ULL, 0x000fe20000004100ULL,
0x00000045ff44723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x0000105411107816ULL, 0x000fe20000000010ULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x0000105441117816ULL, 0x000fe20000000052ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000105453187816ULL, 0x000fe40000000018ULL,
0x00000010ff127819ULL, 0x000fe4000001163eULL, 0x00000010ff137819ULL, 0x000fe20000011650ULL,
0x000000103424723cULL, 0x000b620000041824ULL, 0x00000010ff3f7819ULL, 0x000fc4000001163fULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff117819ULL, 0x020fe2000001163cULL, 0x000000183430723cULL, 0x000b620000041830ULL,
0x00000010ff107819ULL, 0x000fe40000011644ULL, 0x0000105413127816ULL, 0x000fe40000000012ULL,
0x000010545a137816ULL, 0x000fc4000000003fULL, 0x00000010ff187819ULL, 0x020fe4000001163dULL,
0x0000105411107816ULL, 0x000fe40000000010ULL, 0x0000105418117816ULL, 0x000fe20000000043ULL,
0x000000123420723cULL, 0x040f700000041820ULL, 0x000000103434723cULL, 0x000b6e0000041838ULL,
0x0000f6c854107811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688000cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff387224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x0000040004197984ULL, 0x000ee40000000800ULL,
0x8000000019ff7812ULL, 0x00afc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x0000001812397210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e13ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x004fc80000011419ULL,
0x000000390c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x000000020c0c7819ULL, 0x000fc80000001219ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100b137824ULL, 0x000fe400078e00ffULL, 0x000059000f0f7a24ULL, 0x010fe400078e02ffULL,
0x00000080ff107424ULL, 0x000fe200078e00ffULL, 0xffffffe013117812ULL, 0x000fe200078ec0ffULL,
0x000000400f0f7824ULL, 0x000fc800078e00ffULL, 0x0000010048117824ULL, 0x000fca00078e0211ULL,
0x0000008011127810ULL, 0x000fe20007ffe0ffULL, 0x000064000f107625ULL, 0x000fc600078e0010ULL,
0x00000020120c7812ULL, 0x004fca00078ec0ffULL, 0x00000001550c7824ULL, 0x000fe200078e020cULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000120a0f7217ULL, 0x000fe40007800000ULL,
0x0000001013187812ULL, 0x000fe400078ec0ffULL, 0x00000003ff137819ULL, 0x000fe20000011649ULL,
0x000000010f0f7824ULL, 0x000fc600078e0a12ULL, 0x0000000413387810ULL, 0x040fe20007ffe0ffULL,
0x0000000113127824ULL, 0x140fe200078e0218ULL, 0x0000000f180f7217ULL, 0x000fe40007800000ULL,
0x0000000c13397810ULL, 0x000fe20007ffe0ffULL, 0x0000000112197824ULL, 0x040fe400078e0249ULL,
0x000000010f0f7824ULL, 0x000fe400078e0a18ULL, 0x00000008123c7824ULL, 0x040fe400078e00ffULL,
0x0000000112127824ULL, 0x000fe200078e020cULL, 0x0000000f3800720cULL, 0x0c0fe20003f66070ULL,
0x0000000138387824ULL, 0x100fe200078e0218ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee219ULL,
0x00000001393f7824ULL, 0x100fe200078e0218ULL, 0x0000000813197810ULL, 0x040fe20007ffe0ffULL,
0x00000008383e7824ULL, 0x040fe200078e00ffULL, 0x0000000f1300720cULL, 0x080fe20003f86070ULL,
0x0000000138137824ULL, 0x040fe200078e0249ULL, 0x0000000f1900720cULL, 0x0c0fe20003f46070ULL,
0x0000000119197824ULL, 0x000fe200078e0218ULL, 0x0000000f3900720cULL, 0x000fe20003f06070ULL,
0x00000001383a7824ULL, 0x000fe200078e020cULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000000119397824ULL, 0x040fe200078e0249ULL,
0x00000051120f7212ULL, 0x000fe200078efcffULL, 0x0000000819407824ULL, 0x000fe400078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000000f10127210ULL, 0x000fc60007fbe0ffULL,
0x0000000119387824ULL, 0x100fe200078e020cULL, 0x000000513a0f7212ULL, 0x000fe200078efcffULL,
0x000000013f187824ULL, 0x000fe200078e020cULL, 0xfffffff8400c7812ULL, 0x000fe200078ee239ULL,
0x0000008038387825ULL, 0x000fc800078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x00000051383d7212ULL, 0x000fc600078efcffULL, 0x0000000111137824ULL, 0x000fe200028e0613ULL,
0x0000000f103a7210ULL, 0x000fe20007fbe0ffULL, 0x000000013f407824ULL, 0x040fe200078e0249ULL,
0x00000051180f7212ULL, 0x000fe200078efcffULL, 0x000000083f3f7824ULL, 0x000fe400078e00ffULL,
0x00000001113b7824ULL, 0x000fe200028e063bULL, 0x0000003d10387210ULL, 0x000fe20007fbe0ffULL,
0x000000100c3d7824ULL, 0x100fe200078e0257ULL, 0x0000000f10107210ULL, 0x000fe20007fde0ffULL,
0x000000103c0f7824ULL, 0x000fe200078e0257ULL, 0xfffffff83f407812ULL, 0x000fe200078ee240ULL,
0x0000000111397824ULL, 0x000fc400028e0639ULL, 0x0000000111117824ULL, 0x000fe200030e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120f7faeULL, 0x0003e2000e101c46ULL,
0x000000103e197824ULL, 0x100fe400078e0257ULL, 0x00000010403f7824ULL, 0x000fc600078e0257ULL,
0x000000003a197faeULL, 0x0003e8000d901c46ULL, 0x00000000383d7faeULL, 0x0003e8000d101c46ULL,
0x00000000103f7faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001013127812ULL, 0x000fc800078ec0ffULL, 0x0000001249127211ULL, 0x000fc800078fe8ffULL,
0x0000000812187810ULL, 0x040fe20007ffe0ffULL, 0x00000001120f7824ULL, 0x140fe200078e0249ULL,
0x00000004123a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008123c7824ULL, 0x040fe400078e00ffULL,
0x0000000112387824ULL, 0x000fe400078e020cULL, 0x0000000118197824ULL, 0x000fe200078e0249ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x0000000818407824ULL, 0x000fe200078e00ffULL,
0x0000000c120f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee219ULL, 0x000000013a137824ULL, 0x040fe400078e0249ULL,
0x000000083a3e7824ULL, 0x040fe400078e00ffULL, 0x000000013a3a7824ULL, 0x100fe400078e020cULL,
0x0000000118187824ULL, 0x100fe200078e020cULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL,
0x000000010f127824ULL, 0x040fe400078e020cULL, 0x000000010f0c7824ULL, 0x000fc400078e0249ULL,
0x000000080f3d7824ULL, 0x000fe200078e00ffULL, 0x00000051380f7212ULL, 0x000fe200078efcffULL,
0x000000803a3a7825ULL, 0x000fc600078e00ffULL, 0x0000000f10387210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0xfffffff83d0c7812ULL, 0x000fe400078ee20cULL,
0x000000513a3f7212ULL, 0x080fe200078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000051183d7212ULL, 0x000fe400078efcffULL, 0x0000003f103a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000111397824ULL, 0x040fe200000e0639ULL, 0x00000051120f7212ULL, 0x000fe200078efcffULL,
0x000000100c3f7824ULL, 0x000fe200078e0257ULL, 0x0000003d10187210ULL, 0x040fe20007f1e0ffULL,
0x00000001113b7824ULL, 0x000fe200010e063bULL, 0x0000000f10107210ULL, 0x000fe20007f7e0ffULL,
0x000000103c0f7824ULL, 0x000fc400078e0257ULL, 0x0000000111197824ULL, 0x040fe400000e0619ULL,
0x0000000111117824ULL, 0x000fe200018e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000380f7faeULL, 0x0003e2000b901c46ULL, 0x000000103e137824ULL, 0x100fe400078e0257ULL,
0x00000010403d7824ULL, 0x000fc600078e0257ULL, 0x000000003a137faeULL, 0x0003e8000b901c46ULL,
0x00000000183d7faeULL, 0x0003e8000b901c46ULL, 0x00000000103f7faeULL, 0x0003e4000b901c46ULL,
0x000000080b0c7824ULL, 0x000fe200078e00ffULL, 0x0000000207127810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff107424ULL, 0x000fc600078e00ffULL, 0xfffffff00c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000091200720cULL, 0x000fe40003f06070ULL, 0x000000000c0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000156128824ULL, 0x000fc400078e0212ULL,
0x00000004ff138424ULL, 0x000fc800078e00ffULL, 0x0000660012128625ULL, 0x000fca00078e0013ULL,
0x0000000612108981ULL, 0x000522000c1e1900ULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6a8000c127f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628000d187f8cULL, 0x000664000c80043fULL,
0x0000000000387805ULL, 0x000fc40000015200ULL, 0x00f62c000d0f7984ULL, 0x000ee40000000800ULL,
0x800000000fff7812ULL, 0x00afe40007804819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a380f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3a7824ULL, 0x000fe200000e0e39ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001143aULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e063aULL, 0x000000020c0c7819ULL, 0x000fc8000000120fULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c000d0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000200b0c7824ULL, 0x000fca00078e00ffULL,
0xffffff800c0c7812ULL, 0x000fc800078ec0ffULL, 0x00000080510c7810ULL, 0x000fca0007ffe00cULL,
0x00000001730c7824ULL, 0x000fca00078e020cULL, 0x00f000000c117984ULL, 0x000e680000000800ULL,
0x00f200000c387984ULL, 0x0006a20000000800ULL, 0x000000061100720bULL, 0x002fe20003f1d000ULL,
0x0000f9a27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c3a7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fd200078e0006ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000001720c7810ULL, 0x000fe40007ffe0ffULL,
0x000000061100720bULL, 0x000fe40003f54000ULL, 0x0000000b0c00720cULL, 0x000fe20003f05270ULL,
0x0000f9427f007947ULL, 0x000fd4000b800000ULL, 0x00000000000f7806ULL, 0x000fc400010e0100ULL,
0x000000800b188824ULL, 0x000fe200078e0251ULL, 0x00000006110c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000173198824ULL, 0x000fe200078e0218ULL,
0x000099100f187816ULL, 0x000fc800000000ffULL, 0x00f4000c19008388ULL, 0x0003e20000000800ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000611197209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0fff7812ULL, 0x000fc6000780c0ffULL, 0x00000006190c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00397308ULL, 0x000e640000000800ULL,
0x000000390e0e7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011649ULL, 0x0000f8627f007947ULL, 0x000fea000b800000ULL,
0x00001f0c390c7589ULL, 0x0002e400000e0000ULL, 0x0000000c2c2c7220ULL, 0x08cfe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c14147220ULL, 0x080fe20000410000ULL,
0x0000000c15157220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008490c7811ULL, 0x000fe200078ff0ffULL, 0x0000f7427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c390c7589ULL, 0x00066400000e0000ULL, 0x0000000c2e2e7220ULL, 0x086fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c16167220ULL, 0x080fe20000410000ULL,
0x0000000c17177220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3aff7812ULL, 0x000fe2000780600fULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x00000006110f7209ULL, 0x000fd60007810000ULL, 0x8000000f11110221ULL, 0x000fe20000010000ULL,
0x00007610ff0c0816ULL, 0x000fc6000000000cULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100030308ULL, 0x000e640000000800ULL, 0x0000000338380220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e380e7221ULL, 0x004fc20000010000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x000000080b067824ULL, 0x000fca00078e00ffULL,
0xfffffff0063a7812ULL, 0x000fca00078ec0ffULL, 0x00f6b4003a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780481bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x008fcc0000015200ULL,
0x0000003818117210ULL, 0x000fca0007f1e1ffULL, 0x0000000139387824ULL, 0x000fe200000e0e19ULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011438ULL, 0x0000001106067211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0638ULL, 0x0000000206067819ULL, 0x000fc80000001211ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b4003a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100c067816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff117819ULL, 0x000fe40000011649ULL, 0x0000541000067816ULL, 0x000fe20000000000ULL,
0x0000f2f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1106027589ULL, 0x0002a400000e0000ULL,
0x00000008110c7810ULL, 0x000fe20007ffe0ffULL, 0x0000f3227f007947ULL, 0x000fea000b800000ULL,
0x00001f0c06007589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010110c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0006ULL,
0x0000612000197802ULL, 0x000fc40000000f00ULL, 0x0000fb3000007944ULL, 0x01cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018110c7810ULL, 0x006fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x0000617000197802ULL, 0x000fc40000000f00ULL,
0x0000fae000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000100057507810ULL, 0x000fca0007ffe0ffULL,
0x000000104a537824ULL, 0x100fe400078e0250ULL, 0x000000104e387824ULL, 0x000fc600078e0250ULL,
0x000000005318783bULL, 0x000e680000004200ULL, 0x000000003838783bULL, 0x008ee20000004200ULL,
0x00000010ff117819ULL, 0x102fe40000011618ULL, 0x000000ff18437812ULL, 0x040fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011618ULL, 0x0000ffff18527812ULL, 0x000fc400078ec0ffULL,
0x00000018ff187819ULL, 0x000fe40000011619ULL, 0x00000010ff657819ULL, 0x108fe4000001163aULL,
0x000000ff3a6d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001163aULL,
0x0000ffff3a667812ULL, 0x000fe400078ec0ffULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x00000018ff3a723eULL, 0x000fe400020006ffULL, 0x000000ff1b3e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff477819ULL, 0x100fe40000011639ULL, 0x000000ff39067812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011639ULL, 0x0000ffff39467812ULL, 0x000fc400078ec0ffULL,
0x00000043ff39723eULL, 0x000fe200020006ffULL, 0x20000042ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe20000011619ULL, 0x2000003aff427230ULL, 0x000fe20000004100ULL,
0x000000ff195d7812ULL, 0x040fe200078ec0ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x0000ffff19407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff417819ULL, 0x000fe4000001161aULL,
0x000000ff1a5e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001161aULL,
0x0000ffff1a3c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x100fe4000001161bULL,
0x00000018ff5c7819ULL, 0x000fe4000001161bULL, 0x0000ffff1b3f7812ULL, 0x000fe400078ec0ffULL,
0x009800004b18783bULL, 0x000e620000000200ULL, 0x0000003eff3a723eULL, 0x000fc400020006ffULL,
0x00000010ff457819ULL, 0x100fe40000011638ULL, 0x000000ff380c7812ULL, 0x044fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe40000011638ULL, 0x0000ffff386b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff11117812ULL, 0x000fe400078ec0ffULL, 0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x0000005dff38723eULL, 0x000fe400020006ffULL, 0x0000005bff5d723eULL, 0x000fe200020006ffULL,
0x2000003aff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x100fe2000001163bULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x000000ff3b6f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe4000001163bULL, 0x0000ffff3b687812ULL, 0x000fc400078ec0ffULL,
0x00000011ff3a723eULL, 0x000fe200020006ffULL, 0x2000005dff117230ULL, 0x000fe20000004100ULL,
0x0000005aff3b723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x2000003aff3a7230ULL, 0x000fe20000004100ULL, 0x00000008ff407819ULL, 0x000fe20000011640ULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff397819ULL, 0x000fe20000011639ULL,
0x2000005eff3e7230ULL, 0x000fe20000004100ULL, 0x0000005cff5e723eULL, 0x000fc400020006ffULL,
0x00000008ff5c7819ULL, 0x000fe20000011652ULL, 0x000000104d527824ULL, 0x000fe200078e0250ULL,
0x00000010ff3a7819ULL, 0x000fe2000001163aULL, 0x2000005eff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe20000011638ULL, 0x0000000218188231ULL, 0x082fe200003400ffULL,
0x00000010ff3b7819ULL, 0x000fe2000001163bULL, 0x000000021a1a8231ULL, 0x000fe200003400ffULL,
0x00000040ff5d723eULL, 0x000fe200020006ffULL, 0x0000000019198231ULL, 0x080fe200003400ffULL,
0x000000ff415e7812ULL, 0x000fe200078ec0ffULL, 0x000000001b1b8231ULL, 0x000fe200003400ffULL,
0x000010543a407816ULL, 0x000fc40000000039ULL, 0x000010543b417816ULL, 0x000fe40000000038ULL,
0x000000005238783bULL, 0x000e620000004200ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5f7819ULL, 0x000fe2000001163cULL,
0x2000005cff3c7230ULL, 0x000fe20000004100ULL, 0x0000003dff60723eULL, 0x000fe200020006ffULL,
0x2000005dff3d7230ULL, 0x000fe20000004100ULL, 0x00000010ff437819ULL, 0x000fc40000011643ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000008ff3f7819ULL, 0x000fe4000001163fULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00001054433c7816ULL, 0x000fc4000000003cULL, 0x00001054423d7816ULL, 0x000fe2000000003dULL,
0x2000005eff5c7230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x000000401840723cULL, 0x040b62000004182cULL, 0x000000ff45457812ULL, 0x000fe400078ec0ffULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000010ff2c7819ULL, 0x020fe2000001163eULL, 0x2000003fff2e7230ULL, 0x000fe20000004100ULL,
0x00000010ff2d7819ULL, 0x000fe2000001165cULL, 0x0000003c183c723cULL, 0x000b620000041828ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fc40000011660ULL, 0x0000005fff5d723eULL, 0x000fe400020006ffULL,
0x0000000cff2a723eULL, 0x020fe400020006ffULL, 0x000010542d2c7816ULL, 0x000fe2000000002cULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x00001054602d7816ULL, 0x000fe4000000005bULL,
0x00000006ff2b723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff2a7819ULL, 0x000fc4000001162aULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x2000002bff2b7230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe4000001162eULL,
0x0000002c182c723cULL, 0x000b620000041814ULL, 0x00000010ff067819ULL, 0x102fe40000011638ULL,
0x000000ff38697812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011638ULL,
0x0000ffff380c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff117819ULL, 0x000fe40000011611ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff287819ULL, 0x000fe4000001165dULL,
0x00000044ff14723eULL, 0x020fe400020006ffULL, 0x0000105445387816ULL, 0x000fe2000000002aULL,
0x000000104f457824ULL, 0x000fe200078e0250ULL, 0x00000010ff447819ULL, 0x000fe20000011647ULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x00000010ff2b7819ULL, 0x000fc4000001162bULL,
0x0000105411287816ULL, 0x000fe40000000028ULL, 0x000010545a297816ULL, 0x000fe40000000029ULL,
0x00000010ff117819ULL, 0x100fe40000011639ULL, 0x000000ff395f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011639ULL, 0x0000ffff395a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5d7819ULL, 0x100fe4000001163bULL, 0x000000ff3b637812ULL, 0x040fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe4000001163bULL, 0x0000ffff3b5e7812ULL, 0x000fe400078ec0ffULL,
0x0000105444397816ULL, 0x000fe4000000002bULL, 0x00000008ff3b7819ULL, 0x000fe20000011646ULL,
0x000000281828723cULL, 0x000b62000004181cULL, 0x000000004544783bULL, 0x000e620000004200ULL,
0x00000010ff5b7819ULL, 0x000fc4000001163aULL, 0x000000ff3a617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe4000001163aULL, 0x0000ffff3a5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3a7819ULL, 0x000fe4000001166bULL, 0x0000006cff15723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400020006ffULL, 0x0000003bff3b723eULL, 0x000fe200020006ffULL,
0x20000015ff157230ULL, 0x000fe20000004100ULL, 0x000000ff65657812ULL, 0x000fe200078ec0ffULL,
0x2000003aff3a7230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fe200078ec0ffULL,
0x2000003bff1f7230ULL, 0x020fe20000004100ULL, 0x0000006fff17723eULL, 0x000fe400020006ffULL,
0x0000006dff16723eULL, 0x000fe400020006ffULL, 0x00000065ff1c723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fe20000011668ULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe20000011614ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000008ff1d7819ULL, 0x000fc40000011666ULL,
0x00000010ff147819ULL, 0x000fe4000001163aULL, 0x00000010ff667819ULL, 0x000fe40000011615ULL,
0x00000010ff157819ULL, 0x000fe4000001161fULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000068ff1f723eULL, 0x000fe400020006ffULL, 0x000010543b147816ULL, 0x000fe20000000014ULL,
0x20000070ff1e7230ULL, 0x000fe20000004100ULL, 0x0000001dff1d723eULL, 0x000fe200020006ffULL,
0x000000381838723cULL, 0x000b620000041830ULL, 0x00000010ff167819ULL, 0x000fe20000011616ULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x0000105466157816ULL, 0x000fe40000000015ULL, 0x00000010ff317819ULL, 0x020fe20000011617ULL,
0x2000001dff307230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe2000001161cULL,
0x2000006eff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff327819ULL, 0x000fe40000011667ULL,
0x00001054171c7816ULL, 0x000fe40000000016ULL, 0x00001054321d7816ULL, 0x000fe20000000031ULL,
0x000000141814723cULL, 0x000b620000041824ULL, 0x00000010ff1e7819ULL, 0x000fc4000001161eULL,
0x00000010ff1f7819ULL, 0x000fe4000001161fULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x000010541e257816ULL, 0x020fe4000000001fULL, 0x00000010ff247819ULL, 0x000fe20000011630ULL,
0x0000001c181c723cULL, 0x000b620000041820ULL, 0x000000ff44657812ULL, 0x002fe400078ec0ffULL,
0x00000018ff277819ULL, 0x000fc40000011644ULL, 0x0000ffff44337812ULL, 0x000fe400078ec0ffULL,
0x00000010ff227819ULL, 0x020fe40000011644ULL, 0x00000010ff317819ULL, 0x100fe40000011645ULL,
0x000000ff45667812ULL, 0x040fe400078ec0ffULL, 0x00000018ff447819ULL, 0x000fe40000011645ULL,
0x0000ffff45237812ULL, 0x000fc400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000069ff32723eULL, 0x000fe400020006ffULL, 0x00000010ff307819ULL, 0x100fe40000011646ULL,
0x000000ff46457812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011646ULL,
0x0000ffff46267812ULL, 0x000fc400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x000010546b247816ULL, 0x000fe40000000024ULL, 0x00000010ff217819ULL, 0x100fe20000011647ULL,
0x20000063ff677230ULL, 0x000fe20000004100ULL, 0x000000ff47467812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe40000011647ULL, 0x0000ffff47207812ULL, 0x000fc400078ec0ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000065ff47723eULL, 0x000fe200020006ffULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x0000006aff69723eULL, 0x000fe200020006ffULL, 0x20000032ff6a7230ULL, 0x000fe20000004100ULL,
0x00000066ff62723eULL, 0x000fe200020006ffULL, 0x20000060ff6b7230ULL, 0x000fe20000004100ULL,
0x00000061ff32723eULL, 0x000fe200020006ffULL, 0x20000064ff667230ULL, 0x000fe20000004100ULL,
0x00000027ff63723eULL, 0x000fe200020006ffULL, 0x20000047ff277230ULL, 0x000fe20000004100ULL,
0x00000044ff64723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000045ff60723eULL, 0x000fe200020006ffULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x00000046ff61723eULL, 0x000fe200020006ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000000241844723cULL, 0x000b620000041834ULL, 0x000000ff06067812ULL, 0x000fe200078ec0ffULL,
0x009800004c18783bULL, 0x020e620000000200ULL, 0x000000ff11117812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe2000001160cULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000006ff0c723eULL, 0x000fe200020006ffULL,
0x2000005fff6c7230ULL, 0x000fe20000004100ULL, 0x00000011ff11723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000008ff5a7819ULL, 0x000fe2000001165aULL,
0x2000000cff0c7230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe200020006ffULL,
0x20000011ff347230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fc400078ec0ffULL,
0x0000005aff37723eULL, 0x000fe200020006ffULL, 0x20000024ff367230ULL, 0x000fe20000004100ULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x000000ff31317812ULL, 0x000fe200078ec0ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005cff24723eULL, 0x000fc400020006ffULL,
0x00000031ff5a723eULL, 0x000fe400020006ffULL, 0x00000008ff337819ULL, 0x000fe20000011633ULL,
0x20000024ff247230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166aULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe4000001166cULL,
0x00000010ff317819ULL, 0x000fe4000001160cULL, 0x00000010ff5c7819ULL, 0x000fe20000011634ULL,
0x0000000218188231ULL, 0x082fe200003400ffULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x000000021a1a8231ULL, 0x000fe200003400ffULL, 0x000000ff22117812ULL, 0x000fe200078ec0ffULL,
0x2000005dff227230ULL, 0x000fe20000004100ULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000033ff33723eULL, 0x000fe200020006ffULL,
0x0000000019198231ULL, 0x080fe200003400ffULL, 0x0000105431347816ULL, 0x000fe2000000006aULL,
0x000000001b1b8231ULL, 0x000fe200003400ffULL, 0x000010545c357816ULL, 0x000fe20000000035ULL,
0x20000033ff0c7230ULL, 0x000fe20000004100ULL, 0x000000ff305d7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff5c7819ULL, 0x000fe4000001166bULL,
0x00000010ff307819ULL, 0x000fe40000011636ULL, 0x00000010ff317819ULL, 0x000fe40000011637ULL,
0x00000008ff237819ULL, 0x000fe20000011623ULL, 0x000000341834723cULL, 0x000b620000041840ULL,
0x0000005eff25723eULL, 0x000fc400020006ffULL, 0x00000011ff11723eULL, 0x000fe400020006ffULL,
0x0000105469307816ULL, 0x000fe20000000030ULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x000010545c317816ULL, 0x000fe20000000031ULL, 0x20000011ff117230ULL, 0x000fe20000004100ULL,
0x00000023ff33723eULL, 0x000fe400020006ffULL, 0x00000010ff327819ULL, 0x000fe40000011632ULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x20000033ff417230ULL, 0x020fe20000004100ULL,
0x00000008ff267819ULL, 0x000fc40000011626ULL, 0x00000010ff427819ULL, 0x000fe40000011622ULL,
0x000000ff21217812ULL, 0x000fe400078ec0ffULL, 0x00000010ff237819ULL, 0x000fe40000011667ULL,
0x000010545b227816ULL, 0x000fe40000000032ULL, 0x000000301830723cULL, 0x000b62000004183cULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000010ff247819ULL, 0x000fe40000011624ULL, 0x00000026ff3c723eULL, 0x020fe400020006ffULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000021ff3d723eULL, 0x000fe400020006ffULL,
0x00000010ff267819ULL, 0x000fe40000011627ULL, 0x0000105442237816ULL, 0x000fe20000000023ULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fc40000011662ULL,
0x00000010ff217819ULL, 0x000fe20000011611ULL, 0x2000003cff117230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe2000001165aULL, 0x00000022182c723cULL, 0x000b62000004182cULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000105465247816ULL, 0x000fe40000000024ULL,
0x0000105466257816ULL, 0x000fe20000000025ULL, 0x2000005dff407230ULL, 0x000fe20000004100ULL,
0x0000105421267816ULL, 0x000fc40000000026ULL, 0x000010545a277816ULL, 0x000fe40000000027ULL,
0x00000008ff207819ULL, 0x000fe20000011620ULL, 0x000000241828723cULL, 0x040f620000041828ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff0c7819ULL, 0x000fe4000001160cULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff217819ULL, 0x000fe20000011641ULL,
0x000000261824723cULL, 0x000b620000041838ULL, 0x0000006dff5f723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000020ff22723eULL, 0x020fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000105463207816ULL, 0x000fe2000000000cULL,
0x20000068ff067230ULL, 0x000fe20000004100ULL, 0x0000105464217816ULL, 0x000fe20000000021ULL,
0x20000022ff3a7230ULL, 0x000fe20000004100ULL, 0x00000010ff387819ULL, 0x000fe40000011660ULL,
0x00000010ff237819ULL, 0x000fc40000011640ULL, 0x00000010ff397819ULL, 0x000fe40000011661ULL,
0x0000105423387816ULL, 0x000fe40000000038ULL, 0x000000201820723cULL, 0x000b620000041814ULL,
0x00000010ff0c7819ULL, 0x000fe4000001163dULL, 0x00000010ff117819ULL, 0x000fe40000011611ULL,
0x00000010ff067819ULL, 0x000fe40000011606ULL, 0x00000010ff147819ULL, 0x020fc4000001165fULL,
0x00000010ff157819ULL, 0x000fe4000001163aULL, 0x000010540c397816ULL, 0x000fe40000000039ULL,
0x0000105414147816ULL, 0x000fe40000000011ULL, 0x0000105406157816ULL, 0x000fe20000000015ULL,
0x000000020b067824ULL, 0x000fe400078e00ffULL, 0x00000038181c723cULL, 0x000f66000004181cULL,
0xfffffff8060c7812ULL, 0x000fca00078ec0ffULL, 0x000000141814723cULL, 0x000b6e0000041844ULL,
0x0000f6c854187811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000018187f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f690000cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff067224ULL, 0x000fc600078e00ffULL,
0x00000000001a7805ULL, 0x000fc80000015200ULL, 0x0000040004117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00afc40007804819ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x000000381a117210ULL, 0x000fca0007f1e1ffULL,
0x0000000139387824ULL, 0x000fe200000e0e1bULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x004fc80000011438ULL,
0x000000110c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0638ULL,
0x000000020c0c7819ULL, 0x000fc80000001211ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100b0c7824ULL, 0x004fe400078e00ffULL, 0x0000590010107a24ULL, 0x010fe400078e02ffULL,
0x00000080ff1b7424ULL, 0x000fe200078e00ffULL, 0xffffffe00c117812ULL, 0x000fe200078ec0ffULL,
0x0000004010107824ULL, 0x000fc800078e00ffULL, 0x0000010048117824ULL, 0x000fe400078e0211ULL,
0x00006400101a7625ULL, 0x000fc600078e001bULL, 0x000000c011117810ULL, 0x000fc80007ffe0ffULL,
0x0000002011067812ULL, 0x000fca00078ec0ffULL, 0x0000000155067824ULL, 0x000fe200078e0206ULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x000000100c197812ULL, 0x000fe400078ec0ffULL,
0x000000110a0c7217ULL, 0x000fe40007800000ULL, 0x00000003ff107819ULL, 0x000fc60000011649ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a11ULL, 0x0000000410387810ULL, 0x040fe20007ffe0ffULL,
0x0000000110117824ULL, 0x040fe200078e0219ULL, 0x0000000c103a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c190c7217ULL, 0x000fe20007800000ULL, 0x0000000111187824ULL, 0x040fe400078e0249ULL,
0x0000000811417824ULL, 0x000fe400078e00ffULL, 0x000000010c0c7824ULL, 0x000fc400078e0a19ULL,
0x000000013a3c7824ULL, 0x100fe200078e0219ULL, 0xfffffff841417812ULL, 0x000fe400078ee218ULL,
0x0000000c3800720cULL, 0x0c0fe20003f66070ULL, 0x0000000138387824ULL, 0x000fe200078e0219ULL,
0x0000000810187810ULL, 0x000fe20007ffe0ffULL, 0x000000083c477824ULL, 0x000fe200078e00ffULL,
0x0000000c1000720cULL, 0x080fe20003f86070ULL, 0x0000000111107824ULL, 0x000fe200078e0206ULL,
0x0000000c3a00720cULL, 0x080fe20003f06070ULL, 0x0000000138117824ULL, 0x000fe200078e0249ULL,
0x0000000c1800720cULL, 0x000fe20003f46070ULL, 0x00000008383e7824ULL, 0x000fc400078e00ffULL,
0x00000001383a7824ULL, 0x000fe400078e0206ULL, 0x0000000118397824ULL, 0x000fe200078e0219ULL,
0xfffffff83e437812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005110197212ULL, 0x000fc600078efcffULL,
0x0000000139187824ULL, 0x140fe200078e0206ULL, 0x000000191a107210ULL, 0x000fe20007fbe0ffULL,
0x000000013c387824ULL, 0x000fe200078e0206ULL, 0x000000513a3d7212ULL, 0x000fe200078efcffULL,
0x00000001390c7824ULL, 0x040fe400078e0249ULL, 0x0000000839457824ULL, 0x000fe400078e00ffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20cULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x00000051183f7212ULL, 0x000fc600078efcffULL,
0x000000011b117824ULL, 0x000fe200028e0611ULL, 0x0000003d1a3a7210ULL, 0x000fe20007fbe0ffULL,
0x000000013c067824ULL, 0x000fe200078e0249ULL, 0x00000051383d7212ULL, 0x000fc600078efcffULL,
0x000000011b3b7824ULL, 0x000fe200028e063bULL, 0x0000003f1a187210ULL, 0x040fe20007fbe0ffULL,
0x00000010453f7824ULL, 0x100fe200078e0250ULL, 0x0000003d1a1a7210ULL, 0x000fe20007fde0ffULL,
0x00000010413d7824ULL, 0x000fe200078e0250ULL, 0xfffffff847477812ULL, 0x000fe200078ee206ULL,
0x000000011b197824ULL, 0x040fe400028e0619ULL, 0x000000011b1b7824ULL, 0x000fe200030e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103d7faeULL, 0x0003e2000e101c46ULL,
0x0000001043397824ULL, 0x000fc400078e0250ULL, 0x0000001047417824ULL, 0x000fc600078e0250ULL,
0x000000003a397faeULL, 0x0003e8000d901c46ULL, 0x00000000183f7faeULL, 0x0003e8000d101c46ULL,
0x000000001a417faeULL, 0x0003e2000c101c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x000000100c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c490c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c3a7810ULL, 0x040fe20007ffe0ffULL, 0x000000010c107824ULL, 0x140fe200078e0249ULL,
0x000000080c187810ULL, 0x040fe20007ffe0ffULL, 0x000000080c437824ULL, 0x000fe400078e00ffULL,
0x000000013a117824ULL, 0x140fe400078e0249ULL, 0x000000083a387824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee210ULL, 0x000000010c107824ULL, 0x040fe200078e0206ULL,
0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000118197824ULL, 0x000fe200078e0249ULL,
0xfffffff838457812ULL, 0x000fe200078ee211ULL, 0x00000008183c7824ULL, 0x000fc400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee219ULL,
0x000000013a3a7824ULL, 0x100fe200078e0206ULL, 0x00000051103d7212ULL, 0x000fe200078efcffULL,
0x0000000118187824ULL, 0x100fe400078e0206ULL, 0x000000010c387824ULL, 0x000fe200078e0206ULL,
0x0000003d1a107210ULL, 0x000fe20007f1e0ffULL, 0x000000803a3a7825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000513a417212ULL, 0x000fc600078efcffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x00000051183f7212ULL, 0x000fe400078efcffULL,
0x000000411a3a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010c067824ULL, 0x000fe200078e0249ULL,
0x00000051383d7212ULL, 0x000fe200078efcffULL, 0x000000080c5b7824ULL, 0x000fe400078e00ffULL,
0x000000011b117824ULL, 0x040fe200000e0611ULL, 0x0000003f1a187210ULL, 0x040fe20007f1e0ffULL,
0x000000011b3b7824ULL, 0x000fe200010e063bULL, 0x0000003d1a1a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010433d7824ULL, 0x000fe200078e0250ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee206ULL,
0x000000011b197824ULL, 0x000fc400000e0619ULL, 0x000000011b1b7824ULL, 0x000fe200018e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000103d7faeULL, 0x0003e2000b901c46ULL,
0x0000001045397824ULL, 0x100fe400078e0250ULL, 0x00000010473f7824ULL, 0x100fe400078e0250ULL,
0x000000105b417824ULL, 0x000fe200078e0250ULL, 0x000000003a397faeULL, 0x0003e8000b901c46ULL,
0x00000000183f7faeULL, 0x0003e8000b901c46ULL, 0x000000001a417faeULL, 0x0003e4000b901c46ULL,
0x000000080b0c7824ULL, 0x000fe200078e00ffULL, 0x0000000307107810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff067424ULL, 0x000fc600078e00ffULL, 0xfffffff00c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000091000720cULL, 0x000fe40003f06070ULL, 0x000000000c0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000156108824ULL, 0x000fc400078e0210ULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000660010108625ULL, 0x000fca00078e0011ULL,
0x0000000610068981ULL, 0x000522000c1e1900ULL, 0x0000f6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6b0000c107f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f648000d187f8cULL, 0x000664000c80043fULL,
0x00000000001a7805ULL, 0x000fc40000015200ULL, 0x00f64c000d397984ULL, 0x000ee40000000800ULL,
0x8000000039ff7812ULL, 0x00afe40007804819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x000000381a3b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e1bULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011439ULL, 0x0000003b0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x000000020c0c7819ULL, 0x000fc80000001239ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c000d397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000200b0c7824ULL, 0x000fca00078e00ffULL,
0xffffff800c0c7812ULL, 0x000fc800078ec0ffULL, 0x00000100510c7810ULL, 0x000fca0007ffe00cULL,
0x00000001730c7824ULL, 0x000fca00078e020cULL, 0x00f000000c1a7984ULL, 0x000e680000000800ULL,
0x00f200000c1b7984ULL, 0x0006a20000000800ULL, 0x0000000f1a00720bULL, 0x002fe20003f1d000ULL,
0x0000cd827f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c387812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fd200078e000fULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000002720c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1a00720bULL, 0x000fe40003f54000ULL, 0x0000000b0c00720cULL, 0x000fe20003f05270ULL,
0x0000cd227f007947ULL, 0x000fd4000b800000ULL, 0x00000000000d7806ULL, 0x000fc400010e0100ULL,
0x000000800b188824ULL, 0x000fe200078e0251ULL, 0x0000000f1a0c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000173198824ULL, 0x000fe200078e0218ULL,
0x000099100d187816ULL, 0x000fc800000000ffULL, 0x00f4000c19008388ULL, 0x0003e20000000800ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f1a0c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f0c0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00397308ULL, 0x000e640000000800ULL,
0x000000390e0e7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011649ULL, 0x0000cc427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c390c7589ULL, 0x0002e400000e0000ULL, 0x0000000c34347220ULL, 0x08cfe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c14147220ULL, 0x080fe20000410000ULL,
0x0000000c15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008490c7811ULL, 0x000fe200078ff0ffULL, 0x0000cb227f007947ULL, 0x000fea000b800000ULL,
0x00001f0c390c7589ULL, 0x00066400000e0000ULL, 0x0000000c36367220ULL, 0x086fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c16167220ULL, 0x080fe20000410000ULL,
0x0000000c17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff38ff7812ULL, 0x000fe2000780600dULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000f1a0d7209ULL, 0x000fd60007810000ULL, 0x8000000d1a1a0221ULL, 0x000fe20000010000ULL,
0x00007610ff0c0816ULL, 0x000fc6000000000cULL, 0x3fb8aa3b1a1a0820ULL, 0x000fc80000410000ULL,
0x0000001a00030308ULL, 0x000e640000000800ULL, 0x000000031b1b0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e1b0e7221ULL, 0x004fc20000010000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x000000080b0f7824ULL, 0x000fca00078e00ffULL,
0xfffffff00f387812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00380f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff397224ULL, 0x008fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09001a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc8000001141bULL, 0x0000001a0f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff1a7224ULL, 0x000fca00000e061bULL, 0x000000020f0f7819ULL, 0x000fc8000000121aULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000139397810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00380f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100c0c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff127819ULL, 0x000fe40000011649ULL, 0x00005410000f7816ULL, 0x000fe20000000000ULL,
0x0000c6d27f007947ULL, 0x000fea000b800000ULL, 0x00001f120f027589ULL, 0x0002a400000e0000ULL,
0x00000008120c7810ULL, 0x000fe20007ffe0ffULL, 0x0000c7027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0f007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010120c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000fULL,
0x00008f0000197802ULL, 0x000fc40000000f00ULL, 0x0000cd5000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018120c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00008f5000197802ULL, 0x000fc40000000f00ULL,
0x0000cd0000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000104a397824ULL, 0x000fe200078e0257ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00a000004b18783bULL, 0x000ee80000000200ULL, 0x000000003938783bULL, 0x000ea40000004200ULL,
0x0000000218188231ULL, 0x00cfc400003400ffULL, 0x000000021a1a8231ULL, 0x000fe200003400ffULL,
0x000000ff393d7812ULL, 0x000fe200078ec0ffULL, 0x0000000019198231ULL, 0x082fe200003400ffULL,
0x000000ff383c7812ULL, 0x040fe200078ec0ffULL, 0x000000001b1b8231ULL, 0x000fe200003400ffULL,
0x00000018ff137819ULL, 0x100fe40000011638ULL, 0x00000010ff127819ULL, 0x000fe40000011638ULL,
0x0000ffff38417812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3e7819ULL, 0x000fc40000011639ULL,
0x00000018ff387819ULL, 0x000fe40000011639ULL, 0x0000ffff394a7812ULL, 0x000fe200078ec0ffULL,
0x000000104e397824ULL, 0x100fe200078e0257ULL, 0x0000003dff3f723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000013ff3d723eULL, 0x000fe200020006ffULL,
0x2000003fff467230ULL, 0x000fe20000004100ULL, 0x00000010ff0f7819ULL, 0x100fe2000001163aULL,
0x2000003cff137230ULL, 0x000fe20000004100ULL, 0x000000ff3a0c7812ULL, 0x040fe200078ec0ffULL,
0x2000003dff457230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe2000001163aULL,
0x000000104d3f7824ULL, 0x000fe200078e0257ULL, 0x0000ffff3a427812ULL, 0x000fc400078ec0ffULL,
0x00000010ff477819ULL, 0x100fe4000001163bULL, 0x000000ff3b447812ULL, 0x040fe400078ec0ffULL,
0x00000018ff437819ULL, 0x000fe4000001163bULL, 0x0000ffff3b617812ULL, 0x000fe400078ec0ffULL,
0x00000038ff40723eULL, 0x000fe400020006ffULL, 0x000000003938783bULL, 0x000e620000004200ULL,
0x000000ff3e3e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff3c7819ULL, 0x000fe20000011641ULL,
0x20000040ff4e7230ULL, 0x000fe20000004100ULL, 0x00000008ff3d7819ULL, 0x000fe4000001164aULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x2000003eff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff12127812ULL, 0x000fe200078ec0ffULL, 0x2000003cff417230ULL, 0x000fe20000004100ULL,
0x000000ff0f4d7812ULL, 0x000fe200078ec0ffULL, 0x2000003dff4b7230ULL, 0x000fe20000004100ULL,
0x00000012ff12723eULL, 0x000fe200020006ffULL, 0x000000003f3c783bULL, 0x000ea20000004200ULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x0000000cff0c723eULL, 0x000fe200020006ffULL,
0x20000012ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff127819ULL, 0x000fe40000011613ULL,
0x00000010ff137819ULL, 0x000fe20000011646ULL, 0x2000000cff0c7230ULL, 0x000fe20000004100ULL,
0x00000010ff0f7819ULL, 0x000fe40000011640ULL, 0x000010544a137816ULL, 0x000fe40000000013ULL,
0x000010540f127816ULL, 0x000fc40000000012ULL, 0x00000010ff407819ULL, 0x000fe40000011641ULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff4e7819ULL, 0x000fe2000001164eULL,
0x000000121834723cULL, 0x000be20000041834ULL, 0x00000010ff417819ULL, 0x000fe4000001164bULL,
0x0000105445407816ULL, 0x000fe40000000040ULL, 0x000010544e417816ULL, 0x000fc40000000041ULL,
0x000000ff38137812ULL, 0x022fe400078ec0ffULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x100fe2000001163aULL, 0x000000401830723cULL, 0x000b620000041830ULL,
0x000000ff3a687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001163aULL,
0x0000ffff3a0f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff127819ULL, 0x000fe4000001160cULL,
0x00000018ff667819ULL, 0x000fe40000011638ULL, 0x00000010ff637819ULL, 0x100fe4000001163bULL,
0x000000ff3b3a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001163bULL,
0x0000ffff3b0c7812ULL, 0x000fc400078ec0ffULL, 0x00000013ff13723eULL, 0x000fe400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000044ff3b723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000066ff40723eULL, 0x020fe200020006ffULL, 0x20000013ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff137819ULL, 0x000fe20000011642ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x004fe2000001163cULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x000000ff3c447812ULL, 0x000fc400078ec0ffULL, 0x00000018ff457819ULL, 0x000fe4000001163cULL,
0x0000ffff3c5e7812ULL, 0x000fe200078ec0ffULL, 0x2000006bff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x100fe4000001163dULL, 0x000000ff3d5d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe4000001163dULL, 0x0000ffff3d4e7812ULL, 0x000fc400078ec0ffULL,
0x00000043ff3d723eULL, 0x000fe400020006ffULL, 0x0000003aff6b723eULL, 0x000fe400020006ffULL,
0x00000068ff43723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000013ff3a723eULL, 0x000fe400020006ffULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fc4000001164dULL,
0x00000010ff137819ULL, 0x000fe4000001163bULL, 0x00000010ff687819ULL, 0x000fe20000011647ULL,
0x2000006bff477230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe40000011638ULL,
0x00000010ff657819ULL, 0x100fe40000011639ULL, 0x00000018ff677819ULL, 0x000fe40000011639ULL,
0x0000ffff38387812ULL, 0x000fc400078ec0ffULL, 0x00000061ff3b723eULL, 0x000fe200020006ffULL,
0x2000003aff617230ULL, 0x000fe20000004100ULL, 0x000010544d127816ULL, 0x000fe40000000012ULL,
0x0000105468137816ULL, 0x000fe40000000013ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x000000ff653a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff39697812ULL, 0x000fe200078ec0ffULL,
0x20000067ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff657819ULL, 0x000fe20000011638ULL,
0x000000104f387824ULL, 0x000fe200078e0257ULL, 0x0000ffff39397812ULL, 0x000fe200078ec0ffULL,
0x00000012182c723cULL, 0x000b62000004182cULL, 0x000000ff64677812ULL, 0x000fe200078ec0ffULL,
0x2000003bff647230ULL, 0x000fe20000004100ULL, 0x0000003aff4f723eULL, 0x000fc400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000008ff137819ULL, 0x020fe40000011639ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000067ff127230ULL, 0x000fe20000004100ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x000000ff63687812ULL, 0x000fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fc400020006ffULL,
0x00000062ff63723eULL, 0x000fe200020006ffULL, 0x20000065ff627230ULL, 0x000fe20000004100ULL,
0x00000013ff67723eULL, 0x000fe200020006ffULL, 0x2000004fff137230ULL, 0x000fe20000004100ULL,
0x00000068ff65723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fe2000001163dULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fe4000001163cULL, 0x00000010ff3d7819ULL, 0x000fe20000011664ULL,
0x20000065ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe20000011661ULL,
0x20000067ff617230ULL, 0x000fe20000004100ULL, 0x00001054683d7816ULL, 0x000fc4000000003dULL,
0x000010544f3c7816ULL, 0x000fe4000000003cULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff657819ULL, 0x000fe20000011612ULL,
0x0000003c1828723cULL, 0x000b620000041828ULL, 0x00000010ff687819ULL, 0x000fe40000011613ULL,
0x0000105465127816ULL, 0x000fc40000000066ULL, 0x0000105468137816ULL, 0x000fe40000000069ULL,
0x00000008ff0f7819ULL, 0x000fe4000001160fULL, 0x00000010ff5a7819ULL, 0x100fe4000001163eULL,
0x000000ff3e4b7812ULL, 0x040fe200078ec0ffULL, 0x000000121824723cULL, 0x000b620000041824ULL,
0x00000018ff417819ULL, 0x000fe4000001163eULL, 0x0000ffff3e5b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff3f4d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3d7819ULL, 0x020fe40000011640ULL,
0x00000018ff3e7819ULL, 0x000fe4000001163fULL, 0x0000004aff4f723eULL, 0x000fe400020006ffULL,
0x00000010ff3c7819ULL, 0x000fe40000011642ULL, 0x00000010ff407819ULL, 0x000fc40000011643ULL,
0x0000000fff0f723eULL, 0x000fe400020006ffULL, 0x00000010ff427819ULL, 0x000fe40000011662ULL,
0x00000010ff437819ULL, 0x000fe20000011661ULL, 0x2000000fff0f7230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff647819ULL, 0x000fc40000011664ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000010ff627819ULL, 0x102fe4000001163aULL, 0x000000ff3a6c7812ULL, 0x040fe200078ec0ffULL,
0x2000005dff667230ULL, 0x000fe20000004100ULL, 0x00000018ff127819ULL, 0x000fe4000001163aULL,
0x0000ffff3a4a7812ULL, 0x000fe400078ec0ffULL, 0x0000004dff4d723eULL, 0x000fc400020006ffULL,
0x00000010ff677819ULL, 0x100fe40000011638ULL, 0x000000ff386d7812ULL, 0x040fe200078ec0ffULL,
0x2000004dff5d7230ULL, 0x000fe20000004100ULL, 0x00000018ff137819ULL, 0x000fe40000011638ULL,
0x0000ffff38687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff697819ULL, 0x000fe40000011639ULL,
0x000000ff396e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011639ULL,
0x0000ffff39617812ULL, 0x000fe200078ec0ffULL, 0x2000004fff397230ULL, 0x000fe20000004100ULL,
0x000000ff3b3a7812ULL, 0x000fe400078ec0ffULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x000010543d427816ULL, 0x000fe40000000042ULL, 0x000010543c437816ULL, 0x000fe20000000043ULL,
0x2000003eff4d7230ULL, 0x000fe20000004100ULL, 0x00000018ff387819ULL, 0x000fc4000001163bULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00001054633c7816ULL, 0x000fe40000000040ULL,
0x00001054643d7816ULL, 0x000fe20000000047ULL, 0x20000044ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe4000001163bULL, 0x0000ffff3b407812ULL, 0x000fe400078ec0ffULL,
0x0000003aff3b723eULL, 0x000fe200020006ffULL, 0x0000003c181c723cULL, 0x000fe2000004181cULL,
0x00000012ff3a723eULL, 0x000fc400020006ffULL, 0x00000008ff0c7819ULL, 0x000fe2000001160cULL,
0x2000003bff127230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe400020006ffULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x00000010ff3e7819ULL, 0x000fe2000001160fULL,
0x20000038ff0f7230ULL, 0x000fe20000004100ULL, 0x0000006bff44723eULL, 0x000fe400020006ffULL,
0x000000ff606b7812ULL, 0x000fc400078ec0ffULL, 0x0000000cff60723eULL, 0x000fe200020006ffULL,
0x2000003aff0c7230ULL, 0x000fe20000004100ULL, 0x00001054393e7816ULL, 0x000fe2000000003eULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x000000421838723cULL, 0x000b620000041820ULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x00a000004c20783bULL, 0x020e620000000200ULL,
0x00000008ff4e7819ULL, 0x000fe2000001164eULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe4000001163fULL, 0x0000006aff6a723eULL, 0x000fc400020006ffULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x2000006bff437230ULL, 0x000fe20000004100ULL,
0x00000008ff3f7819ULL, 0x000fe2000001163fULL, 0x2000005fff6b7230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x2000004eff5f7230ULL, 0x000fe20000004100ULL,
0x0000003fff4e723eULL, 0x000fc400020006ffULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff3f7819ULL, 0x000fe20000011660ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000045ff637230ULL, 0x000fe20000004100ULL,
0x000010546a3f7816ULL, 0x000fe2000000003fULL, 0x20000046ff647230ULL, 0x000fe20000004100ULL,
0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff5b7819ULL, 0x000fe2000001165bULL,
0x0000003e1814723cULL, 0x000b620000041814ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x0000000220208231ULL, 0x082fe200003400ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x0000000222228231ULL, 0x000fe200003400ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000004bff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x0000000021218231ULL, 0x080fe200003400ffULL, 0x00000010ff187819ULL, 0x020fe2000001165eULL,
0x0000000023238231ULL, 0x000fe200003400ffULL, 0x00000010ff197819ULL, 0x000fe2000001165fULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fc400020006ffULL,
0x0000005bff4c723eULL, 0x000fe400020006ffULL, 0x0000105463187816ULL, 0x000fe20000000018ULL,
0x20000041ff4b7230ULL, 0x000fe20000004100ULL, 0x0000105464197816ULL, 0x000fe20000000019ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe40000011665ULL,
0x00000010ff3d7819ULL, 0x000fe40000011643ULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x000000182030723cULL, 0x000b620000041830ULL, 0x00000010ff6b7819ULL, 0x000fc4000001166bULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x000000ff695b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1a7819ULL, 0x000fe4000001164fULL, 0x00000010ff1b7819ULL, 0x000fe4000001165aULL,
0x00000008ff687819ULL, 0x000fe40000011668ULL, 0x000010543d3c7816ULL, 0x000fc4000000003cULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x000010546b3d7816ULL, 0x000fe40000000066ULL,
0x0000006dff45723eULL, 0x000fe400020006ffULL, 0x00000067ff42723eULL, 0x000fc400020006ffULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff3e7819ULL, 0x000fe2000001164dULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x020fe2000001164cULL, 0x0000003c2034723cULL, 0x000b620000041834ULL,
0x00000010ff197819ULL, 0x000fe4000001164eULL, 0x0000006eff46723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fc400020006ffULL, 0x000010541b1a7816ULL, 0x000fe2000000001aULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000013ff13723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000068ff60723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000013ff417230ULL, 0x000fe20000004100ULL,
0x000010545c1b7816ULL, 0x000fe2000000005dULL, 0x20000060ff437230ULL, 0x000fe20000004100ULL,
0x000010544b187816ULL, 0x000fe20000000018ULL, 0x20000061ff3d7230ULL, 0x020fe20000004100ULL,
0x000010543e197816ULL, 0x000fc40000000019ULL, 0x000000ff62627812ULL, 0x000fe200078ec0ffULL,
0x0000001a202c723cULL, 0x040b62000004182cULL, 0x000000ff47477812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4a7819ULL, 0x000fe4000001164aULL, 0x00000008ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff1a7819ULL, 0x020fe20000011645ULL, 0x000000182028723cULL, 0x000b620000041828ULL,
0x00000010ff1b7819ULL, 0x000fc40000011642ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000010ff417819ULL, 0x000fe20000011641ULL,
0x2000006cff137230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x020fe20000011643ULL,
0x20000062ff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fc40000011644ULL,
0x00000010ff197819ULL, 0x000fe4000001163dULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x000010541b1a7816ULL, 0x000fe2000000001aULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000010545b1b7816ULL, 0x000fc40000000046ULL,
0x0000105441187816ULL, 0x000fe20000000018ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000105444197816ULL, 0x000fe40000000019ULL, 0x00000010ff137819ULL, 0x000fe20000011613ULL,
0x0000001a2024723cULL, 0x000b620000041824ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff1a7819ULL, 0x020fe20000011612ULL, 0x000000182038723cULL, 0x000b620000041838ULL,
0x00000010ff0f7819ULL, 0x000fe4000001160fULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x000010543c127816ULL, 0x000fe40000000013ULL, 0x00000010ff197819ULL, 0x020fe2000001160cULL,
0x000000020b0c7824ULL, 0x000fe200078e00ffULL, 0x0000105447137816ULL, 0x000fc4000000001aULL,
0x00001054194a7816ULL, 0x000fe4000000004aULL, 0x000010540f4b7816ULL, 0x000fe40000000040ULL,
0xfffffff80c0f7812ULL, 0x000fe200078ec0ffULL, 0x00000012201c723cULL, 0x040b6e000004181cULL,
0x0000f6c854127811ULL, 0x020fe200078e18ffULL, 0x0000004a2020723cULL, 0x000b620000041814ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f698000fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x0000000000147805ULL, 0x020fc80000015200ULL, 0x00000400040f7984ULL, 0x004ea40000000800ULL,
0x800000000fff7812ULL, 0x006fc40007804813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011417ULL,
0x000000160f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x000000020f0f7819ULL, 0x000fc80000001216ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400040f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001480f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000307077810ULL, 0x000fe40007ffe0ffULL,
0x000000080f00720cULL, 0x000fda0003f06070ULL, 0x0000083000000947ULL, 0x000fea0003800000ULL,
0x0000000248077810ULL, 0x000fe20007ffe0ffULL, 0x0000590006067a24ULL, 0x010fe400078e02ffULL,
0x000001000f0f7824ULL, 0x000fe200078e0277ULL, 0x000000080700720cULL, 0x000fe20003f06070ULL,
0x0000004006077824ULL, 0x000fe400078e00ffULL, 0x00000080ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000200f067812ULL, 0x000fca00078ec0ffULL, 0x0000000155187824ULL, 0x000fe400078e0206ULL,
0x0000640007067625ULL, 0x000fe400078e000cULL, 0x000003e000008947ULL, 0x000fea0003800000ULL,
0x0000000f0a0c7217ULL, 0x000fe20007800000ULL, 0x000000100b127824ULL, 0x000fc800078e00ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0x00000010120f7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff127819ULL, 0x000fe40000011649ULL, 0x0000000c0f0c7217ULL, 0x000fe40007800000ULL,
0x0000000812157810ULL, 0x040fe20007ffe0ffULL, 0x0000000112137824ULL, 0x140fe200078e020fULL,
0x0000000412147810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0fULL,
0x0000000c12167810ULL, 0x000fe20007ffe0ffULL, 0x0000000813177824ULL, 0x000fc600078e00ffULL,
0x0000000c1500720cULL, 0x0c0fe20003f46070ULL, 0x0000000115157824ULL, 0x000fe200078e020fULL,
0x0000000c1200720cULL, 0x080fe20003f86070ULL, 0x0000000113127824ULL, 0x000fe200078e0218ULL,
0x0000000c1400720cULL, 0x080fe20003f66070ULL, 0x00000008153c7824ULL, 0x000fe200078e00ffULL,
0x0000000c1600720cULL, 0x000fe20003f06070ULL, 0x00000001130c7824ULL, 0x100fe400078e0249ULL,
0x0000000115137824ULL, 0x000fe400078e0249ULL, 0x0000000114147824ULL, 0x100fe200078e020fULL,
0xfffffff8170c7812ULL, 0x000fe200078ee20cULL, 0x00000001161b7824ULL, 0x000fe200078e020fULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL, 0x0000000114167824ULL, 0x000fc400078e0218ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x00000001140f7824ULL, 0x000fe200078e0249ULL,
0x0000005112197212ULL, 0x000fe200078efcffULL, 0x00000008141a7824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001906127210ULL, 0x000fe40007fbe0ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL, 0x0000000115147824ULL, 0x100fe200078e0218ULL,
0x00000051160f7212ULL, 0x000fe200078efcffULL, 0x000000011b187824ULL, 0x000fc400078e0218ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000f06167210ULL, 0x000fc60007fde0ffULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000011b3d7824ULL, 0x040fe200078e0249ULL,
0x00000051180f7212ULL, 0x080fe200078efcffULL, 0x000000081b3e7824ULL, 0x000fe200078e00ffULL,
0x00000051141b7212ULL, 0x000fe200078efcffULL, 0x0000000107137824ULL, 0x040fe400028e0613ULL,
0x0000000107177824ULL, 0x000fe200030e0617ULL, 0x0000001b06147210ULL, 0x000fe20007fbe0ffULL,
0x000000101a3f7824ULL, 0x000fe200078e0257ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee23dULL,
0x000000100c3d7824ULL, 0x100fe200078e0257ULL, 0x0000000f06067210ULL, 0x000fe20007fde0ffULL,
0x000000103c0f7824ULL, 0x000fc400078e0257ULL, 0x0000000107157824ULL, 0x040fe200028e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123d7faeULL, 0x0003e2000e101c46ULL,
0x000000103e577824ULL, 0x000fe400078e0257ULL, 0x0000000107077824ULL, 0x000fe200030e0619ULL,
0x00000000163f7faeULL, 0x0003e8000d901c46ULL, 0x00000000140f7faeULL, 0x0003e8000d101c46ULL,
0x0000000006577faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x000000100b0c7824ULL, 0x000fca00078e00ffULL, 0x000000100c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c490c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c157810ULL, 0x040fe20007ffe0ffULL,
0x000000010c127824ULL, 0x140fe200078e0218ULL, 0x000000080c177810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0f7824ULL, 0x140fe200078e0249ULL, 0x0000000c0c197810ULL, 0x040fe20007ffe0ffULL,
0x000000080c1a7824ULL, 0x000fe400078e00ffULL, 0x0000000115147824ULL, 0x040fe400078e0218ULL,
0x00000001150c7824ULL, 0x040fe200078e0249ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL,
0x00000008151b7824ULL, 0x000fc400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff81b0c7812ULL, 0x000fe200078ee20cULL, 0x0000000117167824ULL, 0x140fe200078e0218ULL,
0x00000051120f7212ULL, 0x000fe200078efcffULL, 0x0000000117157824ULL, 0x140fe400078e0249ULL,
0x00000008173c7824ULL, 0x000fe200078e00ffULL, 0x0000000f06127210ULL, 0x000fe20007f1e0ffULL,
0x0000000119177824ULL, 0x040fe400078e0249ULL, 0x00000008193e7824ULL, 0x040fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee215ULL, 0x0000000119187824ULL, 0x000fc400078e0218ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fc600078ee217ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000051143d7212ULL, 0x000fc600078efcffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000051161b7212ULL, 0x000fc600078efcffULL,
0x0000000107137824ULL, 0x040fe200000e0613ULL, 0x00000051180f7212ULL, 0x000fe200078efcffULL,
0x000000101a3f7824ULL, 0x100fe200078e0257ULL, 0x0000003d06147210ULL, 0x000fe20007f1e0ffULL,
0x000000100c417824ULL, 0x100fe200078e0257ULL, 0x0000001b06167210ULL, 0x000fe20007f5e0ffULL,
0x000000103c437824ULL, 0x000fe200078e0257ULL, 0x0000000f06067210ULL, 0x000fe20007f7e0ffULL,
0x0000000107157824ULL, 0x040fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123f7faeULL, 0x0003e2000b901c46ULL, 0x0000000107177824ULL, 0x000fc400010e0617ULL,
0x000000103e577824ULL, 0x000fe200078e0257ULL, 0x0000000014417faeULL, 0x0003e2000b901c46ULL,
0x0000000107077824ULL, 0x000fc600018e0619ULL, 0x0000000016437faeULL, 0x0003e8000b901c46ULL,
0x0000000006577faeULL, 0x0003e4000b901c46ULL, 0x0000000471077810ULL, 0x002fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff067424ULL, 0x000fe400078e00ffULL,
0x000000090700720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000156127824ULL, 0x000fe400078e0207ULL, 0x00000004ff137424ULL, 0x000fc800078e00ffULL,
0x0000660012127625ULL, 0x000fca00078e0013ULL, 0x0000000612067981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000080b0c7824ULL, 0x000fca00078e00ffULL,
0xfffffff00c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000000c0473c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000f6a804047890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8000c3c7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6680005127f8cULL, 0x0022a2000c80043fULL,
0x000000ffff3c7224ULL, 0x008fc600078e003dULL, 0x0000000000147805ULL, 0x000fc80000015200ULL,
0x00f66c00050f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016140f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000117167824ULL, 0x000fe200000e0e15ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011416ULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e0616ULL,
0x000000020c0c7819ULL, 0x000fc8000000120fULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c00050f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180720c7811ULL, 0x000fc800078e38ffULL, 0x0000000c730c7210ULL, 0x000fca0007ffe051ULL,
0x00f000000c127984ULL, 0x000ea80000000800ULL, 0x00f200000c3d7984ULL, 0x0006620000000800ULL,
0x0000000d1200720bULL, 0x004fe20003f1d000ULL, 0x0000a0f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c147812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff137424ULL, 0x000fe400078e00ffULL,
0x000000ffff3e7224ULL, 0x000fd200078e000dULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000003720c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000d1200720bULL, 0x000fe40003f54000ULL,
0x0000000b0c00720cULL, 0x000fe20003f05270ULL, 0x0000a0927f007947ULL, 0x000fd4000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x000000800b168824ULL, 0x000fe200078e0251ULL,
0x0000000d120c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100f137816ULL, 0x000fe200000000ffULL, 0x0000000173738824ULL, 0x000fca00078e0216ULL,
0x00f4000c73008388ULL, 0x0005e20000000800ULL, 0x000000ff1300720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000d120c7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0fff7812ULL, 0x000fc6000780c0ffULL,
0x0000000d0c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00137308ULL, 0x000ea40000000800ULL, 0x000000130e0e7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011649ULL,
0x00009fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c130c7589ULL, 0x0004e400000e0000ULL,
0x0000000c34347220ULL, 0x08cfe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000fff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008490c7811ULL, 0x000fe200078ff0ffULL,
0x00009e927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c130c7589ULL, 0x0004e400000e0000ULL,
0x0000000c36367220ULL, 0x08cfe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff14ff7812ULL, 0x000fe2000780600fULL,
0x00000001ff137424ULL, 0x000fe200078e00ffULL, 0x0000000d123e7209ULL, 0x000fd60007810000ULL,
0x8000003e12120221ULL, 0x000fe20000010000ULL, 0x00007610ff130816ULL, 0x000fc60000000013ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200030308ULL, 0x000ea40000000800ULL,
0x000000033d3d0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e3d3d7221ULL, 0x002fc20000010000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x000000080b0e7824ULL, 0x000fca00078e00ffULL, 0xfffffff00e127812ULL, 0x000fca00078ec0ffULL,
0x00f6b400120f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000150e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b400120f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910130c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011649ULL,
0x00005410000d7816ULL, 0x000fe20000000000ULL, 0x00009a427f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d027589ULL, 0x0002a400000e0000ULL, 0x000000080e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00009a727f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x0000bd5000197802ULL, 0x000fc40000000f00ULL,
0x00009f0000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x0000bda000197802ULL, 0x000fc40000000f00ULL, 0x00009eb000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000080072187824ULL, 0x040fe200078e0259ULL, 0x00000003725b7810ULL, 0x000fc40007ffe0ffULL,
0x00000000530c783bULL, 0x00ee620000004200ULL, 0x0000000749167812ULL, 0x000fc400078ec0ffULL,
0x0000000258147810ULL, 0x000fe20007ffe0ffULL, 0x000000005210783bULL, 0x0004e20000004200ULL,
0x0000000816167812ULL, 0x000fca00078ef849ULL, 0x0000000816197824ULL, 0x000fe200078e00ffULL,
0x0000000849167812ULL, 0x000fc800078ec0ffULL, 0x0000000716477812ULL, 0x000fe400078ef849ULL,
0xfffffff819527812ULL, 0x004fe400078ee214ULL, 0x00000010475d7812ULL, 0x040fe200078efcffULL,
0x00000008475f7824ULL, 0x000fc800078e00ffULL, 0x000000085d5c7824ULL, 0x000fe200078e00ffULL,
0x00000010ff3f7819ULL, 0x102fe4000001160cULL, 0x000000ff0c4a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe4000001160cULL, 0x0000ffff0c447812ULL, 0x000fe200078ec0ffULL,
0x000000040b0c7824ULL, 0x000fe200078e00ffULL, 0x00000010ff147819ULL, 0x008fe40000011612ULL,
0x000000ff12467812ULL, 0x000fc400078ec0ffULL, 0x000000040c0c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff197819ULL, 0x000fe40000011612ULL, 0x000000020c0c7812ULL, 0x000fe400078efcffULL,
0x0000ffff12427812ULL, 0x000fe400078ec0ffULL, 0x0000000c490c7211ULL, 0x000fe400078fe0ffULL,
0x00000010ff167819ULL, 0x000fc40000011613ULL, 0x000000ff131a7812ULL, 0x000fe200078ec0ffULL,
0x0000000147127824ULL, 0x100fe200078e020cULL, 0x00000018ff597819ULL, 0x000fe20000011613ULL,
0x000000015d577824ULL, 0x000fe200078e020cULL, 0x0000ffff13477812ULL, 0x000fe200078ec0ffULL,
0x000000805b0c7824ULL, 0x000fe200078e0252ULL, 0x000000ff0d4c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff85f137812ULL, 0x000fe400078ee212ULL, 0x00000018ff4b7819ULL, 0x000fc4000001160dULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x000000ff0e4d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff157819ULL, 0x000fe4000001160eULL, 0x0000004cff12723eULL, 0x000fe200020006ffULL,
0x00000010134c7824ULL, 0x000fe200078e0250ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000004aff137230ULL, 0x000fe20000004100ULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000012ff127230ULL, 0x000fe20000004100ULL, 0x00000018ff177819ULL, 0x000fe2000001160fULL,
0x2000004bff527230ULL, 0x000fe20000004100ULL, 0x00000015ff4a723eULL, 0x000fe200020006ffULL,
0x2000004dff157230ULL, 0x000fe20000004100ULL, 0x000000ff10407812ULL, 0x000fc400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011611ULL, 0x000000ff11437812ULL, 0x000fe400078ec0ffULL,
0x00000018ff1b7819ULL, 0x000fe40000011610ULL, 0x00000017ff4b723eULL, 0x000fe200020006ffULL,
0x2000004aff177230ULL, 0x000fe20000004100ULL, 0x00000040ff4d723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x2000004bff407230ULL, 0x000fe20000004100ULL,
0x00000043ff4a723eULL, 0x000fe200020006ffULL, 0x2000004dff437230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000045ff4b7230ULL, 0x000fe20000004100ULL,
0x0000001bff1b723eULL, 0x000fe200020006ffULL, 0x2000004aff4d7230ULL, 0x000fe20000004100ULL,
0x0000001aff1a723eULL, 0x000fe200020006ffULL, 0x20000046ff457230ULL, 0x000fe20000004100ULL,
0xfffffff85c577812ULL, 0x000fe200078ee257ULL, 0x2000001bff4a7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000001aff467230ULL, 0x000fe20000004100ULL,
0x00000019ff5b723eULL, 0x000fe200020006ffULL, 0x0000001057507824ULL, 0x000fe200078e0250ULL,
0x00000010ff587819ULL, 0x000fe2000001160dULL, 0x00a800001818783bULL, 0x000e620000000200ULL,
0x000000ff0f5a7812ULL, 0x000fe200078ec0ffULL, 0x20000041ff577230ULL, 0x000fe20000004100ULL,
0x0000ffff0d537812ULL, 0x000fc400078ec0ffULL, 0x0000005aff41723eULL, 0x000fe400020006ffULL,
0x000000ff58587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff0d7819ULL, 0x000fe2000001160eULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fe4000001160fULL,
0x000000ff3f5a7812ULL, 0x000fe200078ec0ffULL, 0x2000005bff3f7230ULL, 0x000fe20000004100ULL,
0x0000ffff0e0e7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4f7819ULL, 0x000fe40000011610ULL,
0x00000059ff5b723eULL, 0x000fe400020006ffULL, 0x00000058ff59723eULL, 0x000fe400020006ffULL,
0x00000008ff587819ULL, 0x000fe20000011644ULL, 0x2000005bff447230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff0e7819ULL, 0x000fc4000001160eULL, 0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff0f517812ULL, 0x000fe400078ec0ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000010ff0f7819ULL, 0x000fe40000011611ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000005aff5b7230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x0000000218188231ULL, 0x082fe200003400ffULL, 0x00000008ff537819ULL, 0x000fe20000011653ULL,
0x000000021a1a8231ULL, 0x000fe200003400ffULL, 0x0000000eff0e723eULL, 0x000fe200020006ffULL,
0x2000004eff5a7230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x0000000019198231ULL, 0x080fe200003400ffULL, 0x00000008ff517819ULL, 0x000fe20000011651ULL,
0x000000001b1b8231ULL, 0x000fe200003400ffULL, 0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL,
0x2000004fff4e7230ULL, 0x000fe20000004100ULL, 0x0000ffff10107812ULL, 0x000fc400078ec0ffULL,
0x000000ff0d597812ULL, 0x000fe200078ec0ffULL, 0x20000058ff0d7230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x2000000eff587230ULL, 0x000fe20000004100ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x0000000fff4f723eULL, 0x000fe200020006ffULL,
0x20000053ff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff0e7819ULL, 0x000fe20000011612ULL,
0x20000051ff537230ULL, 0x000fe20000004100ULL, 0x00000008ff107819ULL, 0x000fe20000011610ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff137819ULL, 0x000fc40000011613ULL,
0x00000010ff127819ULL, 0x000fe4000001165bULL, 0x00000010ff0f7819ULL, 0x000fe4000001165cULL,
0x000090000c0c7811ULL, 0x000fe400078e20ffULL, 0x00000010ff51723eULL, 0x000fe400020006ffULL,
0x0000105412127816ULL, 0x000fe40000000013ULL, 0x000010540f137816ULL, 0x000fe2000000000eULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff107819ULL, 0x000fc4000001160dULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x0000ffff11117812ULL, 0x000fe400078ec0ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x000000121834723cULL, 0x000b620000041834ULL,
0x00000008ff5b7819ULL, 0x000fe40000011611ULL, 0x00000010ff577819ULL, 0x000fe20000011657ULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff117819ULL, 0x000fc4000001165dULL, 0x0000105457107816ULL, 0x000fe40000000010ULL,
0x0000105452117816ULL, 0x000fe40000000011ULL, 0x000000ff14127812ULL, 0x020fe400078ec0ffULL,
0x00000010ff147819ULL, 0x000fe40000011615ULL, 0x00000010ff157819ULL, 0x000fe40000011641ULL,
0x00000010ff597819ULL, 0x000fc40000011659ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000012ff57723eULL, 0x000fe400020006ffULL, 0x000000101810723cULL, 0x000b620000041830ULL,
0x0000105459147816ULL, 0x000fe40000000014ULL, 0x000010545a157816ULL, 0x000fe40000000015ULL,
0x00000010ff177819ULL, 0x000fe40000011617ULL, 0x000000ff16307812ULL, 0x020fc400078ec0ffULL,
0x00000010ff167819ULL, 0x000fe40000011640ULL, 0x00000010ff407819ULL, 0x000fe20000011658ULL,
0x000000020c0c8231ULL, 0x082fe200003400ffULL, 0x00000010ff417819ULL, 0x000fe20000011653ULL,
0x000000020e0e8231ULL, 0x000fe200003400ffULL, 0x0000105417407816ULL, 0x000fe20000000040ULL,
0x000000000d0d8231ULL, 0x080fe200003400ffULL, 0x0000105416417816ULL, 0x000fe20000000041ULL,
0x000000000f0f8231ULL, 0x000fe200003400ffULL, 0x000000141814723cULL, 0x000be2000004182cULL,
0x00000030ff30723eULL, 0x000fe200020006ffULL, 0x20000057ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fc4000001164dULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff2c7819ULL, 0x020fe40000011643ULL, 0x00000010ff2d7819ULL, 0x000fe2000001164eULL,
0x20000030ff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff2e7819ULL, 0x000fe2000001164fULL,
0x000000004c30783bULL, 0x000e620000004200ULL, 0x000010542d2c7816ULL, 0x000fe4000000002cULL,
0x000010542e2d7816ULL, 0x000fc4000000004dULL, 0x00000042ff2f723eULL, 0x000fe400020006ffULL,
0x000000401840723cULL, 0x000b620000041828ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff4b7819ULL, 0x000fe2000001164bULL,
0x2000005bff527230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x020fe2000001164aULL,
0x2000002fff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff287819ULL, 0x000fe20000011651ULL,
0x0000002c0c2c723cULL, 0x000be20000041834ULL, 0x00000010ff527819ULL, 0x000fe20000011652ULL,
0x000000005034783bULL, 0x020ea20000004200ULL, 0x00000047ff2b723eULL, 0x000fc400020006ffULL,
0x0000105429287816ULL, 0x000fe40000000028ULL, 0x000010544b297816ULL, 0x000fe20000000052ULL,
0x2000002bff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff457819ULL, 0x000fe40000011645ULL,
0x00000010ff2a7819ULL, 0x000fe40000011653ULL, 0x00000010ff477819ULL, 0x000fe40000011646ULL,
0x000010542a467816ULL, 0x000fc40000000045ULL, 0x000000280c28723cULL, 0x000be20000041810ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff447819ULL, 0x000fe40000011644ULL, 0x00000010ff117819ULL, 0x020fe4000001164bULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x000010543f107816ULL, 0x000fc4000000004aULL,
0x0000105444117816ULL, 0x000fe40000000011ULL, 0x000010544e477816ULL, 0x000fe40000000047ULL,
0x000000ff31447812ULL, 0x002fe400078ec0ffULL, 0x00000010ff5a7819ULL, 0x000fe20000011630ULL,
0x000000100c10723cULL, 0x000be20000041840ULL, 0x00000010ff597819ULL, 0x000fe40000011631ULL,
0x00000018ff457819ULL, 0x000fc40000011632ULL, 0x00000010ff527819ULL, 0x000fe40000011633ULL,
0x00000018ff427819ULL, 0x020fe20000011631ULL, 0x000000460c14723cULL, 0x000be20000041814ULL,
0x0000ffff313f7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff32517812ULL, 0x000fe400078ec0ffULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x000000ff30417812ULL, 0x000fc400078ec0ffULL,
0x00000010ff317819ULL, 0x000fe20000011632ULL, 0x20000044ff577230ULL, 0x000fe20000004100ULL,
0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x004fe40000011634ULL, 0x0000ffff30587812ULL, 0x000fe400078ec0ffULL,
0x000000ff334c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011637ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x000000ff32467812ULL, 0x020fe400078ec0ffULL, 0x00000008ff517819ULL, 0x000fe40000011651ULL,
0x00000018ff407819ULL, 0x000fc40000011630ULL, 0x000000ff355e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011635ULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x20000041ff537230ULL, 0x000fe20000004100ULL, 0x000000ff31317812ULL, 0x000fc400078ec0ffULL,
0x0000ffff334e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4f7819ULL, 0x000fe40000011634ULL,
0x000000ff344d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff307819ULL, 0x000fe40000011635ULL,
0x00000010ff327819ULL, 0x000fe40000011636ULL, 0x000000ff36607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5f7819ULL, 0x000fe40000011636ULL, 0x0000ffff364a7812ULL, 0x000fe400078ec0ffULL,
0x0000005cff44723eULL, 0x000fe400020006ffULL, 0x0000ffff34347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x000fe20000011637ULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x000000ff37617812ULL, 0x000fc400078ec0ffULL, 0x0000ffff37437812ULL, 0x000fe400078ec0ffULL,
0x0000004cff36723eULL, 0x000fe200020006ffULL, 0x20000045ff4c7230ULL, 0x000fe20000004100ULL,
0x00000008ff587819ULL, 0x000fe40000011658ULL, 0x0000005bff5c723eULL, 0x000fe200020006ffULL,
0x20000036ff367230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000046ff37723eULL, 0x000fc400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x0000005eff46723eULL, 0x000fe200020006ffULL, 0x20000059ff5e7230ULL, 0x000fe20000004100ULL,
0x0000005dff45723eULL, 0x000fe200020006ffULL, 0x2000005aff5d7230ULL, 0x000fe20000004100ULL,
0x00000008ff5b7819ULL, 0x000fe2000001163fULL, 0x2000005cff3f7230ULL, 0x000fe20000004100ULL,
0x00000031ff31723eULL, 0x000fe200020006ffULL, 0x20000052ff597230ULL, 0x000fe20000004100ULL,
0x00000018ff477819ULL, 0x000fe20000011633ULL, 0x20000051ff527230ULL, 0x000fe20000004100ULL,
0x00000008ff4e7819ULL, 0x000fe2000001164eULL, 0x20000031ff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff30307812ULL, 0x000fe200078ec0ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000040ff33723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000008ff347819ULL, 0x000fe20000011634ULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x0000005bff5c723eULL, 0x000fe200020006ffULL,
0x20000058ff5b7230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000042ff507230ULL, 0x000fe20000004100ULL, 0x00000030ff51723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe200020006ffULL,
0x2000004eff587230ULL, 0x000fe20000004100ULL, 0x00000010ff307819ULL, 0x000fe20000011653ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff317819ULL, 0x000fe20000011657ULL,
0x20000034ff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x0000ffff35357812ULL, 0x000fe400078ec0ffULL,
0x000010545d307816ULL, 0x000fe40000000030ULL, 0x000010545e317816ULL, 0x000fe40000000031ULL,
0x000000ff32327812ULL, 0x000fe400078ec0ffULL, 0x00000010ff337819ULL, 0x000fc40000011633ULL,
0x00000010ff347819ULL, 0x000fe4000001165bULL, 0x00000008ff537819ULL, 0x000fe40000011635ULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff357819ULL, 0x000fe4000001165cULL,
0x00000032ff57723eULL, 0x000fe400020006ffULL, 0x0000105433347816ULL, 0x000fc40000000034ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x000000301830723cULL, 0x000be20000041824ULL,
0x0000105450357816ULL, 0x000fe20000000035ULL, 0x20000057ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011637ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff247819ULL, 0x020fe40000011636ULL, 0x00000010ff367819ULL, 0x000fc4000001165aULL,
0x0000004dff40723eULL, 0x000fe200020006ffULL, 0x20000047ff4d7230ULL, 0x000fe20000004100ULL,
0x0000105436367816ULL, 0x000fe40000000037ULL, 0x0000105459377816ULL, 0x000fe20000000024ULL,
0x20000040ff477230ULL, 0x000fe20000004100ULL, 0x000000341824723cULL, 0x000b620000041838ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000010ff357819ULL, 0x020fe2000001164cULL,
0x00000036181c723cULL, 0x000f62000004181cULL, 0x00000010ff347819ULL, 0x000fe20000011652ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x000010544d357816ULL, 0x000fe40000000058ULL,
0x00000060ff42723eULL, 0x000fc400020006ffULL, 0x00000061ff41723eULL, 0x000fe400020006ffULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x000000341818723cULL, 0x000b620000041820ULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000008ff4a7819ULL, 0x000fe2000001164aULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x020fc40000011644ULL, 0x00000010ff207819ULL, 0x000fe4000001164eULL,
0x00000010ff227819ULL, 0x000fe40000011645ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x0000005fff40723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000105421207816ULL, 0x000fe20000000020ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000105422217816ULL, 0x000fe20000000053ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fc40000011642ULL, 0x00000010ff237819ULL, 0x000fe40000011650ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x000000200c24723cULL, 0x000b620000041824ULL,
0x00000010ff347819ULL, 0x000fe4000001164bULL, 0x0000105423227816ULL, 0x000fe40000000042ULL,
0x0000105434237816ULL, 0x000fe40000000041ULL, 0x00000010ff367819ULL, 0x000fc40000011647ULL,
0x00000010ff377819ULL, 0x000fe40000011646ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff387819ULL, 0x000fe40000011651ULL, 0x00000010ff217819ULL, 0x020fe40000011640ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff347819ULL, 0x000fc4000001163fULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x000010544f367816ULL, 0x000fe40000000036ULL,
0x0000105438377816ULL, 0x000fe40000000037ULL, 0x00001054214a7816ULL, 0x000fe4000000004aULL,
0x00001054344b7816ULL, 0x000fe20000000043ULL, 0x000000220c20723cULL, 0x040b70000004181cULL,
0x000000360c30723cULL, 0x040b700000041830ULL, 0x0000004a0c1c723cULL, 0x000b620000041818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x00000000040c7f8cULL, 0x0202a2000c80043fULL,
0x0000000148487810ULL, 0x000fc40007ffe0ffULL, 0x0000f6a0720e7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000eff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff187224ULL, 0x004fe200078e000dULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff433000007947ULL, 0x000fea000383ffffULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x000000ffff0d7224ULL, 0x008fe400078e0011ULL, 0x000000ffff097224ULL, 0x000fd400078e0010ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000003d007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000d6e000047802ULL, 0x002fc40000000f00ULL, 0x000083b000007944ULL, 0x014fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003d00007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00cfc8000000003dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000047919ULL, 0x002e680000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x012fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x008fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x042fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000000900097220ULL, 0x040fe20000410000ULL, 0x0000000d000d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x000fe20000410000ULL,
0x0000002e042e7220ULL, 0x044fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000001304137220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x000010000b067824ULL, 0x010fe200078e00ffULL,
0x000000242524723eULL, 0x000fc400000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000202120723eULL, 0x000fe400000010ffULL, 0x000000161716723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fc400000010ffULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x000000262719723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000541032187816ULL, 0x000fe40000000019ULL, 0x00000002ff057819ULL, 0x008fe40000011600ULL,
0x0000000200027812ULL, 0x004fc400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x00000008050f7824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x042fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x000fe20007ffe0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000763232197816ULL, 0x000fe40000000019ULL,
0xfffffff80e0e7812ULL, 0x000fc400078ee203ULL, 0x0000100006037812ULL, 0x000fe400078ee2ffULL,
0xfffffff807087812ULL, 0x040fe400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x0000080054057824ULL, 0x000fe200078e0203ULL, 0x0000000404067810ULL, 0x040fe40007ffe0ffULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0a7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000010ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x000000282904723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x00007632160f7816ULL, 0x000fe20000000012ULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x0000541002107816ULL, 0x040fe20000000004ULL, 0x00000001070e7824ULL, 0x040fe200078e020eULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000141502723eULL, 0x000fe200000010ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x000000090d04723eULL, 0x000fe200000010ffULL, 0x0000001006007388ULL, 0x0003e20000000a00ULL,
0x00000001070c7824ULL, 0x000fe200078e020cULL, 0x000000303105723eULL, 0x000fc400000010ffULL,
0x0000763202077816ULL, 0x140fe40000000004ULL, 0x0000541002067816ULL, 0x002fe40000000004ULL,
0x0000001c1d10723eULL, 0x000fe400000010ffULL, 0x0000002e2f02723eULL, 0x000fe200000010ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x0000002a2b04723eULL, 0x000fe400000010ffULL,
0x0000001e1f11723eULL, 0x000fc800000010ffULL, 0x0000763222097816ULL, 0x000fe40000000011ULL,
0x0000541005067816ULL, 0x142fe40000000024ULL, 0x0000763205077816ULL, 0x000fe40000000024ULL,
0x000000ff00057306ULL, 0x000fe60000209400ULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x0000541020067816ULL, 0x002fc40000000010ULL, 0x0000763220077816ULL, 0x000fca0000000010ULL,
0x000000060c007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x142fe40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x0000000177027824ULL, 0x000fe200078e0200ULL,
0x000000ff00047306ULL, 0x000e660000205400ULL, 0x000000060e007388ULL, 0x0005e40000000a00ULL,
0x00005410160e7816ULL, 0x004fe20000000012ULL, 0x0000001002067824ULL, 0x000fe200078e0203ULL,
0x000000040500720bULL, 0x002fc40003f1d000ULL, 0x000000ff00027245ULL, 0x000fe2000020d400ULL,
0x0004000e08007388ULL, 0x0003e80000000a00ULL, 0x000400180a007388ULL, 0x000fec0000000a00ULL,
0x0000000102020812ULL, 0x000fc400078efcffULL, 0x0000541022087816ULL, 0x002fe40000000011ULL,
0x00000002020d723eULL, 0x000fe400000010ffULL, 0x000000ff5400720cULL, 0x000fe20003f05270ULL,
0x000400080c007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000006107984ULL, 0x000e680000000c00ULL, 0x0004000006187984ULL, 0x000ea80000000c00ULL,
0x0008000006147984ULL, 0x000ee80000000c00ULL, 0x000c0000061c7984ULL, 0x000ee20000000c00ULL,
0x3f803f800d137831ULL, 0x002fc40000200013ULL, 0x3f803f800d127831ULL, 0x040fe40000200012ULL,
0x3f803f800d117831ULL, 0x040fe40000200011ULL, 0x3f803f800d107831ULL, 0x040fe40000200010ULL,
0x3f803f800d1b7831ULL, 0x044fe4000020001bULL, 0x3f803f800d1a7831ULL, 0x040fe4000020001aULL,
0x3f803f800d197831ULL, 0x000fc40000200019ULL, 0x3f803f800d187831ULL, 0x000fe40000200018ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f801b1b7831ULL, 0x000fc4000020001fULL, 0x3f803f801a1a7831ULL, 0x000fe2000020001eULL,
0x0000001006007388ULL, 0x000fe20000000c00ULL, 0x3f803f8019197831ULL, 0x000fe4000020001dULL,
0x3f803f8018187831ULL, 0x000fca000020001cULL, 0x0004001806007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x000000750900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000178027824ULL, 0x000fe200078e0209ULL, 0x00005a00ff107a12ULL, 0x000fe400078e33ffULL,
0x000000010b117812ULL, 0x000fc800078ec0ffULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff077224ULL, 0x004fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705137227ULL, 0x000fc800078e0004ULL,
0x0000000109047824ULL, 0x000fe400078e0200ULL, 0x0000000213077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805047812ULL, 0x000fca00078ef800ULL, 0x0000001004067824ULL, 0x000fe400078e0203ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x0000590007057a24ULL, 0x000fe200078e0274ULL, 0x0000000700067812ULL, 0x002fe200078ec0ffULL,
0x00005a0009027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x0000002000027810ULL, 0x000fe20007ffe0ffULL, 0x0000000811077824ULL, 0x000fc600078e0206ULL,
0x0000000576057210ULL, 0x000fe40007f3e0ffULL, 0x00000003ff097819ULL, 0x000fc60000011602ULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4408ULL, 0x000000750900720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000178047824ULL, 0x102fe200078e0209ULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102097824ULL, 0x000fe400078e0209ULL,
0x0000000413057227ULL, 0x000fe200078e00ffULL, 0x00000003ff0d7819ULL, 0x000fc4000001160cULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a05ULL,
0x00005a0007067a24ULL, 0x000fca00078e0204ULL, 0x00005a0006007a0cULL, 0x000fda0003f26070ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff809067812ULL, 0x000fe400078ef802ULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000001006067824ULL, 0x000fca00078e0203ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x0000000510057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005057a24ULL, 0x000fe400078e0274ULL, 0x00005a0007047a24ULL, 0x000fe400078e0204ULL,
0x0000000811077824ULL, 0x000fe400078e0202ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x0000000576057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440eULL,
0x000000750d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000178027824ULL, 0x100fe200078e020dULL, 0x0000006000007810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x000fe400078e020dULL, 0x0000000213057227ULL, 0x002fc600078e00ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a05ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80d047812ULL, 0x000fe400078ef80cULL,
0x00000003ff0d7819ULL, 0x000fe40000011600ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001004067824ULL, 0x000fc400078e0203ULL, 0x0000000178787824ULL, 0x000fc600078e020dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x0000000510057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005057a24ULL, 0x000fe400078e0274ULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000000811077824ULL, 0x000fe400078e020cULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x0000000576057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4402ULL,
0x000000750d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000007813057227ULL, 0x002fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x00000001000d7824ULL, 0x000fe400078e020dULL, 0x00005a0007027a24ULL, 0x000fc600078e0278ULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fca00078e0203ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x0000000510057207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a05ULL,
0x0000590005037a24ULL, 0x000fe400078e0274ULL, 0x00005a0007787a24ULL, 0x000fe400078e0278ULL,
0x0000000811057824ULL, 0x000fe400078e0200ULL, 0x00005a0003037a24ULL, 0x000fca00078e0278ULL,
0x0000000376037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4406ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000090b00720cULL, 0x000fda0003f06070ULL,
0x0000000205028824ULL, 0x000fc800078e00ffULL, 0x00006a00020f8a24ULL, 0x000fe400078e020bULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x000066000f0e8625ULL, 0x000fe200078e003aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060e028981ULL, 0x000ea2000c1e1900ULL,
0x00006e00ff127624ULL, 0x000fe400078e00ffULL, 0x00006f00ff137624ULL, 0x000fe200078e00ffULL,
0x00f60000ff0c7f8cULL, 0x000e68000c80043fULL, 0x0000000612077981ULL, 0x000722000c1e9900ULL,
0x000001ff1000780cULL, 0x000fe20003f04070ULL, 0x00005800ff117624ULL, 0x000fc400078e00ffULL,
0x0000004073737824ULL, 0x000fe400078e00ffULL, 0x00000080ff157424ULL, 0x000fe200078e00ffULL,
0x0000001f11117810ULL, 0x000fe20007ffe0ffULL, 0x000000400b777824ULL, 0x000fe400078e00ffULL,
0x0000004074037824ULL, 0x000fe200078e00ffULL, 0x00000005ff117819ULL, 0x000fe20000011611ULL,
0x0000007302107224ULL, 0x004fc800078e02ffULL, 0x00006400100e7625ULL, 0x000fe200078e0015ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x00afe40000011649ULL,
0x000000770a107217ULL, 0x000fe40007800000ULL, 0x0000000827217810ULL, 0x000fe20007ffe0ffULL,
0x0000004074747824ULL, 0x000fe200078e0227ULL, 0x0000004949187211ULL, 0x000fe200078fe8ffULL,
0x0000000110107824ULL, 0x000fe200078e0a77ULL, 0x000010000b207811ULL, 0x000fe200078e68ffULL,
0x0000008074127825ULL, 0x040fe200078e00ffULL, 0x0000001074167810ULL, 0x000fc40007ffe0ffULL,
0x0000000874147810ULL, 0x000fe40007ffe0ffULL, 0x00000030121b7812ULL, 0x100fe200078ef806ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000003181e7812ULL, 0x000fe400078ec0ffULL,
0x0000001b0e1a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003016197812ULL, 0x100fe400078ef806ULL, 0x0000002074167810ULL, 0x000fe20007ffe0ffULL,
0x000000010f1b7824ULL, 0x000fe200000e0613ULL, 0x00000030141d7812ULL, 0x000fc400078ef806ULL,
0x000000190e127210ULL, 0x040fe40007f5e0ffULL, 0x0000001d0e1c7210ULL, 0x000fe40007f3e0ffULL,
0x0000001874147810ULL, 0x000fe20007ffe0ffULL, 0x000000010f137824ULL, 0x000fe200010e0617ULL,
0x000000102700720cULL, 0x080fe20003f06070ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000002874187810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffc1e497812ULL, 0x000fe200078ef849ULL,
0x000000010f1d7824ULL, 0x000fe200008e0615ULL, 0x000000102100720cULL, 0x000fe20003f26070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003016197812ULL, 0x000fc400078ef806ULL,
0x00000010272b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000421217824ULL, 0x000fe200078e00ffULL,
0x000000190e167210ULL, 0x000fe20007f7e0ffULL, 0x0000001049497824ULL, 0x000fe200078e0220ULL,
0x00000030141f7812ULL, 0x000fe400078ef806ULL, 0xfffffffc21197812ULL, 0x000fe200078ee21eULL,
0x000000010f177824ULL, 0x000fe200018e0617ULL, 0x0000001f0e147210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a497faeULL, 0x0003e2000c101c46ULL,
0x0000002027217810ULL, 0x000fe20007ffe0ffULL, 0x00000010191f7824ULL, 0x000fe200078e0220ULL,
0x0000002827237810ULL, 0x040fe20007ffe0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000003027257810ULL, 0x000fc40007ffe0ffULL, 0x000000001c1f7faeULL, 0x0005e2000c901c46ULL,
0x00000018272d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f157824ULL, 0x000fe200010e0615ULL,
0x0000003018297812ULL, 0x000fe400078ef806ULL, 0x0000003074187810ULL, 0x040fe20007ffe0ffULL,
0x00000004211b7824ULL, 0x002fe200078e00ffULL, 0x00000038741a7810ULL, 0x000fe40007ffe0ffULL,
0x000000102b00720cULL, 0x080fe40003fa6070ULL, 0x0000003827277810ULL, 0x000fe20007ffe0ffULL,
0x000000042b1f7824ULL, 0x004fe200078e00ffULL, 0x000000290e1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000423297824ULL, 0x040fe200078e00ffULL, 0x000000102300720cULL, 0x080fe20003f46070ULL,
0x00000004252b7824ULL, 0x040fe200078e00ffULL, 0x000000102500720cULL, 0x080fe20003f26070ULL,
0x000000010f1d7824ULL, 0x000fe200030e0619ULL, 0x000000102d00720cULL, 0x000fe20003f86070ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b237812ULL, 0x000fc400078ee21eULL,
0x000000102100720cULL, 0x080fe20003f66070ULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0x0000003018257812ULL, 0x000fe200078ef806ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000102700720cULL, 0x040fe40003f06070ULL, 0x000000250e187210ULL, 0x000fe20007fde0ffULL,
0x00000004272f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1f1f7812ULL, 0x000fe200078ee21eULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0xfffffffc2b277812ULL, 0x100fe200078ee21eULL,
0x000000010f197824ULL, 0x000fe200030e0619ULL, 0xfffffffc2d217812ULL, 0x000fe200078ee21eULL,
0x000000101f1f7824ULL, 0x000fe200078e0220ULL, 0x000000301a2b7812ULL, 0x000fe200078ef806ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0xfffffffc29257812ULL, 0x000fe200078ee21eULL,
0x0000001021217824ULL, 0x000fe200078e0220ULL, 0xfffffffc2f297812ULL, 0x000fe200078ee21eULL,
0x00000000121f7faeULL, 0x0003e2000e901c46ULL, 0x0000002b0e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001025257824ULL, 0x000fc400078e0220ULL, 0x0000001029297824ULL, 0x000fe200078e0220ULL,
0x0000000014217faeULL, 0x0003e2000e101c46ULL, 0x000000010f0f7824ULL, 0x000fc600030e061bULL,
0x0000000016237faeULL, 0x0003e8000d901c46ULL, 0x000000001c257faeULL, 0x0003e8000d101c46ULL,
0x0000000018277faeULL, 0x0003e8000c901c46ULL, 0x000000000e297faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000849147811ULL, 0x04afe400078ff0ffULL,
0x0000001049167811ULL, 0x000fc400078ff0ffULL, 0x00000018491a7811ULL, 0x040fe200078ff0ffULL,
0x0000000414157824ULL, 0x000fe200078e00ffULL, 0x00000020491c7811ULL, 0x040fe200078ff0ffULL,
0x0000000416177824ULL, 0x000fe200078e00ffULL, 0x0000002849227811ULL, 0x040fe200078ff0ffULL,
0x000000041a1b7824ULL, 0x000fe200078e00ffULL, 0x0000003049247811ULL, 0x040fe200078ff0ffULL,
0x000000041c1d7824ULL, 0x000fe200078e00ffULL, 0x0000003849267811ULL, 0x040fe200078ff0ffULL,
0x0000000422197824ULL, 0x000fe200078e00ffULL, 0x0000000349127211ULL, 0x040fe200078ff0ffULL,
0x00000004241f7824ULL, 0x000fe200078e00ffULL, 0x0000004949107211ULL, 0x000fe200078fe8ffULL,
0x0000000426217824ULL, 0x000fe200078e00ffULL, 0x000010000b2f7811ULL, 0x000fe200078e68ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000310207812ULL, 0x000fc600078ec0ffULL,
0x0000000103167824ULL, 0x040fe200078e0216ULL, 0x0ffffffc20497812ULL, 0x000fe200078ef849ULL,
0x0000000103147824ULL, 0x000fe200078e0214ULL, 0xfffffffc15107812ULL, 0x100fe400078ee220ULL,
0xfffffffc17187812ULL, 0x100fe200078ee220ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffffc1b1b7812ULL, 0x100fe400078ee220ULL, 0xfffffffc1d1d7812ULL, 0x100fe200078ee220ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffffc191e7812ULL, 0x000fc400078ee220ULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee220ULL, 0x0000000103197824ULL, 0x000fe200078e021aULL,
0xfffffffc21207812ULL, 0x000fe200078ee220ULL, 0x0000001049497824ULL, 0x100fe200078e022fULL,
0x0000003012217812ULL, 0x100fe200078ef806ULL, 0x0000001010237824ULL, 0x100fe400078e022fULL,
0x0000001018257824ULL, 0x100fe200078e022fULL, 0x000000210e127210ULL, 0x000fe20007f1e0ffULL,
0x000000101b277824ULL, 0x100fe200078e022fULL, 0x0000003016217812ULL, 0x100fe200078ef806ULL,
0x000000101d297824ULL, 0x100fe200078e022fULL, 0x00000030141b7812ULL, 0x000fe200078ef806ULL,
0x000000101e2b7824ULL, 0x000fc400078e022fULL, 0x000000101f2d7824ULL, 0x100fe200078e022fULL,
0x0000001b0e1e7210ULL, 0x000fe20007f3e0ffULL, 0x00000010202f7824ULL, 0x000fe200078e022fULL,
0x000000210e207210ULL, 0x000fe20007f5e0ffULL, 0x0000008019187825ULL, 0x000fc800078e00ffULL,
0x000000010f217824ULL, 0x000fe200010e0617ULL, 0x0000003018177812ULL, 0x000fe200078ef806ULL,
0x0000000103147824ULL, 0x040fe400078e021cULL, 0x0000000103167824ULL, 0x040fe400078e0222ULL,
0x00000001031a7824ULL, 0x000fe400078e0224ULL, 0x000000010f137824ULL, 0x040fe200000e0613ULL,
0x000000170e187210ULL, 0x000fe20007f1e0ffULL, 0x000000010f1f7824ULL, 0x000fc400008e0615ULL,
0x00000001031c7824ULL, 0x000fe200078e0226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012497faeULL, 0x0003e2000b901c46ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0x000000001e237faeULL, 0x0003e2000b901c46ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003014377812ULL, 0x100fe400078ef806ULL, 0x0000000020257faeULL, 0x0003e2000b901c46ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000003016357812ULL, 0x000fc600078ef806ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000301a337812ULL, 0x100fe400078ef806ULL,
0x000000350e167210ULL, 0x000fe20007f3e0ffULL, 0x000000010f197824ULL, 0x040fe200000e0619ULL,
0x000000301c317812ULL, 0x000fe400078ef806ULL, 0x000000370e147210ULL, 0x040fe20007f1e0ffULL,
0x000000010f177824ULL, 0x040fe200008e0617ULL, 0x000000330e1a7210ULL, 0x040fe20007f5e0ffULL,
0x0000000018277faeULL, 0x0003e2000b901c46ULL, 0x000000310e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f157824ULL, 0x000fc400000e0615ULL, 0x000000010f1b7824ULL, 0x040fe400010e061bULL,
0x000000010f0f7824ULL, 0x000fe200018e061dULL, 0x0000000014297faeULL, 0x0003e8000b901c46ULL,
0x00000000162b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a2d7faeULL, 0x0003e8000b901c46ULL,
0x000000000e2f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000e7805ULL, 0x002fc40000015200ULL, 0x00f60400ff137984ULL, 0x000e620000000800ULL,
0x00000011043b7224ULL, 0x000fc400078e02ffULL, 0x000000010a757824ULL, 0x000fe400078e0a00ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x8000000013ff7812ULL, 0x002fe2000780480dULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000062003b3a7625ULL, 0x000fe200078e003aULL, 0x00000008ff757819ULL, 0x000fe20000011675ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120e157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0fULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011413ULL, 0x0000001504047211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000204047819ULL, 0x000fc80000001213ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e640000000000ULL,
0x000000200b047824ULL, 0x002fca00078e0204ULL, 0x00000003ff067819ULL, 0x000fc80000011604ULL,
0x1ffffffe060d7812ULL, 0x000fe400078ec0ffULL, 0x0000000f04067812ULL, 0x000fc600078ec0ffULL,
0x00000001040d7824ULL, 0x000fe400078e020dULL, 0x00000010060f7824ULL, 0x040fe400078e00ffULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000f0d047812ULL, 0x040fe400078ec0ffULL,
0x000000010d0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000f00f047812ULL, 0x000fe400078ee204ULL,
0x0000000f0d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000000004187984ULL, 0x000e62000000cc00ULL,
0x000000f0060d7812ULL, 0x000fca00078ee20dULL, 0x000000000d147984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1c7224ULL, 0x002fe400078e0018ULL, 0x000000ffff187224ULL, 0x000fe400078e0019ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001aULL, 0x000000ffff197224ULL, 0x000fe400078e001bULL,
0x000000ffff1e7224ULL, 0x004fe400078e0014ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0016ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1b7224ULL, 0x000fe200078e0017ULL,
0x0000001c04007388ULL, 0x0003e8000000cc00ULL, 0x000000180d007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff127f8cULL, 0x000ea2000c80043fULL,
0x000000ffff067224ULL, 0x000fc600078e00ffULL, 0x00000000000c7805ULL, 0x002fc80000015200ULL,
0x00f60400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x006fc40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140fULL, 0x0000001504047211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x0000000204047819ULL, 0x000fc8000000120fULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x00006a0005747a24ULL, 0x000fe200078e02ffULL, 0x3db504f307067820ULL, 0x010fe20000410000ULL,
0x0000000211057824ULL, 0x000fe200078e00ffULL, 0x0000f6880b767811ULL, 0x040fe200078e18ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xffffffff00077810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x00000009000c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000f6080b797811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e000eULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x01cfc4000001ff00ULL, 0x000000013900780cULL, 0x000fe20003f25270ULL,
0x00000080ff187424ULL, 0x000fe200078e00ffULL, 0x000000010d1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000bc000007945ULL, 0x000fe20003800000ULL, 0x0000000139147810ULL, 0x020fe20007ffe0ffULL,
0x000000ffff487224ULL, 0x000fe200078e0039ULL, 0x00000001380e7812ULL, 0x000fc400078e0cffULL,
0x000000021400780cULL, 0x040fe20003f06070ULL, 0x000000ffff397224ULL, 0x000fe200078e0014ULL,
0x000000ff14167207ULL, 0x000fc60000800000ULL, 0x000000ffff1a1224ULL, 0x000fca00078e020dULL,
0x000000011a157810ULL, 0x000fc80007ffe0ffULL, 0x000000081500720cULL, 0x000fe20003f46070ULL,
0x0000007302157224ULL, 0x010fc800078e02ffULL, 0x0000640015147625ULL, 0x000fd000078e0018ULL,
0x000005e00000a947ULL, 0x000fea0003800000ULL, 0x0000001004177824ULL, 0x002fe200078e00ffULL,
0x00000002ff467819ULL, 0x000fe20000011604ULL, 0x000000ffff197224ULL, 0x000fc600078e00ffULL,
0x0000003017177812ULL, 0x000fe200078ec0ffULL, 0x00000001031b7824ULL, 0x000fe200078e0246ULL,
0x0000000846457810ULL, 0x040fe40007ffe0ffULL, 0x0000001046477810ULL, 0x000fe20007ffe0ffULL,
0x0000004016187824ULL, 0x000fe200078e0217ULL, 0x00000018464e7810ULL, 0x000fe20007ffe0ffULL,
0x000001001a177824ULL, 0x000fe200078e0277ULL, 0x0000002046507810ULL, 0x000fe20007ffe0ffULL,
0x000000801b1a7825ULL, 0x000fc600078e0018ULL, 0x000000170a427217ULL, 0x000fe20007800000ULL,
0x00000001033f7824ULL, 0x040fe200078e0245ULL, 0x0000001a143c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000103437824ULL, 0x000fe200078e0247ULL, 0x00000004041a7211ULL, 0x000fe200078fe8ffULL,
0x000000803f3e7825ULL, 0x000fc600078e0018ULL, 0x000000031a517812ULL, 0x000fe200078ec0ffULL,
0x00000001153d7824ULL, 0x000fe200008e061bULL, 0x0000003e14407210ULL, 0x000fe20007f5e0ffULL,
0x0000000142447824ULL, 0x000fe200078e0a17ULL, 0x0ffffffc514a7812ULL, 0x000fe200078ef804ULL,
0x00000001031b7824ULL, 0x000fe400078e024eULL, 0x0000008043427825ULL, 0x000fe200078e0018ULL,
0x000000444e00720cULL, 0x000fc60003fa6070ULL, 0x000000020b177824ULL, 0x000fe200078e020eULL,
0x0000004214427210ULL, 0x000fe20007f3e0ffULL, 0x000000801b1a7825ULL, 0x000fc600078e0018ULL,
0x0000100017177811ULL, 0x000fe200078e60ffULL, 0x00000004454c7824ULL, 0x000fe200078e00ffULL,
0x0000001a141a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000115417824ULL, 0x000fe200010e063fULL,
0x000000444500720cULL, 0x080fe20003f46070ULL, 0x0000000115437824ULL, 0x000fe200008e0643ULL,
0xfffffffc4c4c7812ULL, 0x000fe200078ee251ULL, 0x000000104a457824ULL, 0x000fe200078e0217ULL,
0x000000444600720cULL, 0x080fe20003f26070ULL, 0x00000004474a7824ULL, 0x000fe400078e00ffULL,
0x00000001151b7824ULL, 0x000fe200018e061bULL, 0x000000444700720cULL, 0x000fe20003f66070ULL,
0x000000104c477824ULL, 0x000fe200078e0217ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee251ULL,
0x00000001033f7824ULL, 0x000fe200078e0250ULL, 0x00000028464c7810ULL, 0x000fc60007ffe0ffULL,
0x000000104a497824ULL, 0x000fe200078e0217ULL, 0x00000030464a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001034b7824ULL, 0x000fe200078e024cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e2000c901c46ULL, 0x000000803f3e7825ULL, 0x000fe200078e0018ULL,
0x0000003846467810ULL, 0x000fe40007ffe0ffULL, 0x0000000040477faeULL, 0x0005e2000d101c46ULL,
0x00000001034d7824ULL, 0x040fe200078e024aULL, 0x0000003e143e7210ULL, 0x000fe20007f9e0ffULL,
0x00000001034f7824ULL, 0x000fe200078e0246ULL, 0x0000000042497faeULL, 0x0007e2000d901c46ULL,
0x000000444c00720cULL, 0x0c0fe20003f66070ULL, 0x000000044c4c7824ULL, 0x000fe200078e00ffULL,
0x000000444a00720cULL, 0x080fe20003f46070ULL, 0x000000804b3c7825ULL, 0x002fe200078e0018ULL,
0x000000444600720cULL, 0x000fc60003f26070ULL, 0x000000804d407825ULL, 0x004fe200078e0018ULL,
0x0000003c143c7210ULL, 0x000fc60007fde0ffULL, 0x00000001153f7824ULL, 0x040fe200020e063fULL,
0x000000445000720cULL, 0x000fe20003f86070ULL, 0x000000044e427824ULL, 0x008fe400078e00ffULL,
0x0000000450447824ULL, 0x000fe400078e00ffULL, 0x00000001153d7824ULL, 0x000fe200030e063dULL,
0x0000004014407210ULL, 0x000fe20007fde0ffULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc42427812ULL, 0x000fe200078ee251ULL, 0x000000804f187825ULL, 0x000fe200078e0018ULL,
0xfffffffc44447812ULL, 0x000fc400078ee251ULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee251ULL,
0x00000004464e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc4c467812ULL, 0x000fe200078ee251ULL,
0x0000000115417824ULL, 0x000fe200030e0641ULL, 0x0000001814147210ULL, 0x000fe20007fde0ffULL,
0x0000001042437824ULL, 0x000fe200078e0217ULL, 0xfffffffc4e4c7812ULL, 0x000fe200078ee251ULL,
0x0000001044457824ULL, 0x100fe400078e0217ULL, 0x0000001046477824ULL, 0x100fe200078e0217ULL,
0x000000001a437faeULL, 0x0003e2000e901c46ULL, 0x000000104a497824ULL, 0x000fc400078e0217ULL,
0x000000104c177824ULL, 0x000fe200078e0217ULL, 0x000000003e457faeULL, 0x0003e2000e101c46ULL,
0x0000000115157824ULL, 0x000fc600030e0619ULL, 0x000000003c477faeULL, 0x0003e8000d901c46ULL,
0x0000000040497faeULL, 0x0003e8000d101c46ULL, 0x0000000014177faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x000000020b187824ULL, 0x000fe200078e020eULL,
0x00000008043c7811ULL, 0x002fc400078ff0ffULL, 0x0000000404177211ULL, 0x000fe400078fe8ffULL,
0x00001000181a7811ULL, 0x000fe200078e60ffULL, 0x000000043c187824ULL, 0x000fe200078e00ffULL,
0x00000010043e7811ULL, 0x040fe200078ff0ffULL, 0x0000000103417824ULL, 0x000fe200078e023cULL,
0x0000001804407811ULL, 0x040fe400078ff0ffULL, 0x0000002004427811ULL, 0x000fe200078ff0ffULL,
0x000000043e4c7824ULL, 0x000fe200078e00ffULL, 0x0000002804447811ULL, 0x000fe200078ff0ffULL,
0x00000004404e7824ULL, 0x000fe200078e00ffULL, 0x0000003004467811ULL, 0x000fe200078ff0ffULL,
0x0000000442507824ULL, 0x000fe200078e00ffULL, 0x00000038044a7811ULL, 0x000fe200078ff0ffULL,
0x0000000444527824ULL, 0x000fe200078e00ffULL, 0x0000000317177812ULL, 0x000fe200078ec0ffULL,
0x0000000446547824ULL, 0x000fe200078e00ffULL, 0x00000003043d7211ULL, 0x000fe200078ff0ffULL,
0x000000044a567824ULL, 0x000fe200078e00ffULL, 0xfffffffc18497812ULL, 0x100fe200078ee217ULL,
0x0000001004187824ULL, 0x000fe200078e00ffULL, 0xfffffffc4c4b7812ULL, 0x100fe200078ee217ULL,
0x0000000103457824ULL, 0x000fe200078e023eULL, 0xfffffffc4e4d7812ULL, 0x100fe200078ee217ULL,
0x0000001049497824ULL, 0x100fe200078e021aULL, 0xfffffffc504f7812ULL, 0x100fe200078ee217ULL,
0x000000104b4b7824ULL, 0x100fe200078e021aULL, 0xfffffffc52517812ULL, 0x100fe200078ee217ULL,
0x000000104d4d7824ULL, 0x000fe200078e021aULL, 0x0ffffffc17197812ULL, 0x000fe200078ef804ULL,
0x000000104f4f7824ULL, 0x100fe200078e021aULL, 0xfffffffc54537812ULL, 0x100fe200078ee217ULL,
0x0000001051517824ULL, 0x100fe200078e021aULL, 0xfffffffc56557812ULL, 0x000fe200078ee217ULL,
0x0000001019177824ULL, 0x100fe200078e021aULL, 0x00000030181b7812ULL, 0x000fe200078ec0ffULL,
0x0000001053537824ULL, 0x000fc400078e021aULL, 0x0000001055557824ULL, 0x000fe400078e021aULL,
0x00000040161a7824ULL, 0x000fe400078e021bULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x0000000103477824ULL, 0x000fe400078e0240ULL, 0x000000803d3c7825ULL, 0x000fc800078e001aULL,
0x00000001033f7824ULL, 0x000fe200078e0244ULL, 0x0000003c143c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008041407825ULL, 0x000fc800078e001aULL, 0x0000000103437824ULL, 0x040fe200078e0242ULL,
0x0000004014407210ULL, 0x000fe20007f5e0ffULL, 0x0000000103197824ULL, 0x000fe400078e0246ULL,
0x0000008045447825ULL, 0x000fc800078e001aULL, 0x0000008047467825ULL, 0x000fe200078e001aULL,
0x0000004414447210ULL, 0x000fc60007f7e0ffULL, 0x0000000103577824ULL, 0x000fe200078e024aULL,
0x0000004614467210ULL, 0x000fe20007f9e0ffULL, 0x0000008043427825ULL, 0x000fc800078e001aULL,
0x000000803f3e7825ULL, 0x000fc800078e001aULL, 0x0000008019187825ULL, 0x000fc800078e001aULL,
0x00000080571a7825ULL, 0x000fc800078e001aULL, 0x00000001153d7824ULL, 0x040fe200008e063dULL,
0x0000004214427210ULL, 0x040fe20007f3e0ffULL, 0x0000000115417824ULL, 0x040fe200010e0641ULL,
0x0000003e143e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000115457824ULL, 0x040fe200018e0645ULL,
0x0000001814187210ULL, 0x040fe20007f7e0ffULL, 0x0000000115477824ULL, 0x040fe200020e0647ULL,
0x0000001a14147210ULL, 0x000fe20007f9e0ffULL, 0x0000000115437824ULL, 0x040fe200008e0643ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c177faeULL, 0x0003e2000b901c46ULL,
0x00000001153f7824ULL, 0x000fc400010e063fULL, 0x0000000115197824ULL, 0x040fe200018e0619ULL,
0x0000000040497faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600020e061bULL,
0x00000000444b7faeULL, 0x0003e8000b901c46ULL, 0x00000000464d7faeULL, 0x0003e8000b901c46ULL,
0x00000000424f7faeULL, 0x0003e8000b901c46ULL, 0x000000003e517faeULL, 0x0003e8000b901c46ULL,
0x0000000018537faeULL, 0x0003e8000b901c46ULL, 0x0000000014557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000011600780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x000000040f0f7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x000000090f00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000274147824ULL, 0x002fe400078e020fULL, 0x00000004ff157424ULL, 0x000fc800078e00ffULL,
0x0000660014147625ULL, 0x000fca00078e0015ULL, 0x0000000614027981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff497224ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff804157812ULL, 0x020fe200078ec0ffULL, 0x000000020b4a7824ULL, 0x000fe200078e0238ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000149197810ULL, 0x000fe40007ffe0ffULL,
0x0000000715157812ULL, 0x100fe400078ef804ULL, 0x000010004a4a7811ULL, 0x000fe400078e60ffULL,
0x00000001ff147819ULL, 0x000fe20000011615ULL, 0x0000000415177824ULL, 0x040fe200078e00ffULL,
0x00000007043d7812ULL, 0x040fe200078ec0ffULL, 0x00000004151b7824ULL, 0x000fe200078e00ffULL,
0x00000020044b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000114167824ULL, 0x040fe200078e0249ULL,
0x000000083d3f7812ULL, 0x000fe200078ef804ULL, 0x0000000114147824ULL, 0x000fe200078e0219ULL,
0xfffffff84b4b7812ULL, 0x000fc400078ec0ffULL, 0xfffffffc17177812ULL, 0x000fe200078ee216ULL,
0x0000000448167824ULL, 0x000fe200078e0249ULL, 0xfffffffc1b1b7812ULL, 0x000fe400078ee214ULL,
0x000000074b4b7812ULL, 0x000fe200078ef804ULL, 0x0000001017177824ULL, 0x100fe400078e024aULL,
0x0000000216157824ULL, 0x000fe200078e00ffULL, 0x00000001ff167819ULL, 0x000fe2000001164bULL,
0x000000101b407824ULL, 0x000fe200078e024aULL, 0x000000001744783bULL, 0x0002a20000000200ULL,
0x000000044b4d7824ULL, 0x000fe200078e00ffULL, 0x0000001504147211ULL, 0x000fe200078fe0ffULL,
0x00000001164e7824ULL, 0x040fe200078e0219ULL, 0x00000002153d7810ULL, 0x000fe20007ffe0ffULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x0000000116167824ULL, 0x000fe200078e0249ULL,
0x0000000249497810ULL, 0x000fe20007ffe0ffULL, 0x000000103f177824ULL, 0x042fe200078e00ffULL,
0x0000003d043d7211ULL, 0x000fe200078fe0ffULL, 0x000000013f147824ULL, 0x000fe200078e0214ULL,
0xfffffffc4d157812ULL, 0x000fe200078ee216ULL, 0x000000044b577824ULL, 0x000fe200078e00ffULL,
0x000000044900780cULL, 0x000fe20003f25270ULL, 0x000000013f3d7824ULL, 0x000fe200078e023dULL,
0xfffffff017147812ULL, 0x000fc400078ee214ULL, 0xfffffffc57577812ULL, 0x000fc600078ee24eULL,
0x0000001014147824ULL, 0x000fe400078e00ffULL, 0x0000001057577824ULL, 0x000fc600078e024aULL,
0x000000001418783bULL, 0x0002e40000000200ULL, 0x000000103f147824ULL, 0x002fca00078e00ffULL,
0xfffffff0143d7812ULL, 0x000fe400078ee23dULL, 0x00000018ff177819ULL, 0x104fe40000011647ULL,
0x00000010ff167819ULL, 0x000fe20000011647ULL, 0x000000103d4f7824ULL, 0x000fe200078e00ffULL,
0x00000017ff3c723eULL, 0x000fe400020006ffULL, 0x000000ff16177812ULL, 0x000fe400078ec0ffULL,
0x0000ffff473e7812ULL, 0x000fe200078ec0ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000017ff17723eULL, 0x000fc400020006ffULL, 0x00000008ff167819ULL, 0x000fe4000001163eULL,
0x000000ff47477812ULL, 0x000fe200078ec0ffULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000010ff147819ULL, 0x000fe2000001163cULL,
0x00000010153c7824ULL, 0x000fe200078e024aULL, 0x00000010ff177819ULL, 0x000fe20000011617ULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x00001054144d7816ULL, 0x000fe20000000017ULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x00000010ff4c7819ULL, 0x000fe20000011616ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x0000ffff43527812ULL, 0x008fe200078ec0ffULL, 0x000000004f14783bULL, 0x000ea20000000200ULL,
0x00000018ff507819ULL, 0x000fe40000011643ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000050ff50723eULL, 0x000fc400020006ffULL, 0x000010544c4c7816ULL, 0x000fe40000000047ULL,
0x00000010ff477819ULL, 0x000fe20000011643ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x000000ff43437812ULL, 0x000fe400078ec0ffULL, 0x000000ff47517812ULL, 0x000fe200078ec0ffULL,
0x0000004c1810723cULL, 0x000b620000041810ULL, 0x00000008ff477819ULL, 0x000fe40000011652ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe20000011650ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe20000011644ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff4b7819ULL, 0x000fc40000011651ULL,
0x00000010ff4c7819ULL, 0x020fe40000011647ULL, 0x00001054504b7816ULL, 0x000fe4000000004bULL,
0x000010544c4a7816ULL, 0x000fe40000000043ULL, 0x0000ffff44627812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011644ULL, 0x00000010ff607819ULL, 0x002fe2000001163cULL,
0x0000004a1410723cULL, 0x004be20000041810ULL, 0x000000ff3c4c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3c437812ULL, 0x000fe400078ec0ffULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x020fe4000001163cULL, 0x00000008ff3c7819ULL, 0x000fe40000011662ULL,
0x00000018ff5e7819ULL, 0x000fe40000011645ULL, 0x0000005bff5b723eULL, 0x000fc400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe40000011645ULL,
0x000000ff455f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff454f7812ULL, 0x000fe400078ec0ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000010ff567819ULL, 0x000fc40000011646ULL,
0x00000018ff517819ULL, 0x000fe40000011646ULL, 0x000000ff46457812ULL, 0x040fe400078ec0ffULL,
0x0000ffff46477812ULL, 0x000fe400078ec0ffULL, 0x0000005eff46723eULL, 0x000fe200020006ffULL,
0x2000005bff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff445d7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x100fe2000001163dULL,
0x2000003cff5a7230ULL, 0x000fe20000004100ULL, 0x00000018ff597819ULL, 0x000fe2000001163dULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x000000ff3d547812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff507819ULL, 0x100fe4000001163eULL,
0x00000018ff5c7819ULL, 0x000fe4000001163eULL, 0x000000ff3e587812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3e527812ULL, 0x000fe400078ec0ffULL, 0x00000010ff537819ULL, 0x000fc4000001163fULL,
0x00000018ff557819ULL, 0x000fe4000001163fULL, 0x000000ff3f4b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3f617812ULL, 0x000fe400078ec0ffULL, 0x00000000573c783bULL, 0x0002a20000000200ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x000000ff4e637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fe2000001164fULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff4f7819ULL, 0x000fc4000001165bULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff4e7819ULL, 0x000fe4000001165dULL, 0x00000010ff5b7819ULL, 0x000fe4000001165aULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff56567812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x000010545e4f7816ULL, 0x000fe2000000004fULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x000010545b4e7816ULL, 0x000fc4000000004eULL, 0x00000051ff57723eULL, 0x002fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000010ff467819ULL, 0x000fe20000011646ULL,
0x0000004e1834723cULL, 0x000b620000041834ULL, 0x00000010ff517819ULL, 0x000fe20000011662ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000ffff406d7812ULL, 0x000fe200078ec0ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000ffff42687812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4e7819ULL, 0x020fe4000001165fULL, 0x00000010ff4f7819ULL, 0x000fe40000011663ULL,
0x00001054514e7816ULL, 0x000fe4000000004eULL, 0x00001054464f7816ULL, 0x000fe4000000004fULL,
0x00000010ff467819ULL, 0x000fe40000011657ULL, 0x00000010ff517819ULL, 0x000fc40000011656ULL,
0x00000018ff6b7819ULL, 0x000fe20000011640ULL, 0x0000004e1830723cULL, 0x000be20000041830ULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x000fe40000011641ULL,
0x000000ff3e697812ULL, 0x004fe200078ec0ffULL, 0x2000004cff707230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff687819ULL, 0x000fc40000011668ULL,
0x0000105446517816ULL, 0x000fe40000000051ULL, 0x00000018ff6a7819ULL, 0x000fe4000001163fULL,
0x00000010ff637819ULL, 0x000fe40000011640ULL, 0x000000ff405a7812ULL, 0x000fe400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000010ff577819ULL, 0x000fc4000001163eULL,
0x00000018ff6f7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e467812ULL, 0x000fe400078ec0ffULL,
0x00000010ff407819ULL, 0x100fe40000011642ULL, 0x00000018ff647819ULL, 0x000fe40000011642ULL,
0x000000ff42627812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d3e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff667819ULL, 0x100fe4000001163cULL, 0x00000018ff727819ULL, 0x000fe4000001163cULL,
0x000000ff3c717812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3c5e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f427812ULL, 0x000fe400078ec0ffULL, 0x00000008ff477819ULL, 0x000fc40000011647ULL,
0x0000006dff5d723eULL, 0x000fe400020006ffULL, 0x00000068ff4c723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x100fe2000001163dULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x000000ff3d6e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3d567812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6d723eULL, 0x000fe400020006ffULL,
0x000000ff60687812ULL, 0x000fe400078ec0ffULL, 0x0000005aff3d723eULL, 0x000fe200020006ffULL,
0x2000006bff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff607819ULL, 0x000fe20000011643ULL,
0x2000006dff437230ULL, 0x000fe20000004100ULL, 0x00000045ff67723eULL, 0x000fc400020006ffULL,
0x00000047ff6b723eULL, 0x000fe400020006ffULL, 0x00000042ff6a723eULL, 0x000fe200020006ffULL,
0x20000069ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff4d7819ULL, 0x000fe2000001164dULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x000000ff44697812ULL, 0x000fe200078ec0ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000006aff447230ULL, 0x000fe20000004100ULL, 0x000000ff506d7812ULL, 0x000fc400078ec0ffULL,
0x0000004dff50723eULL, 0x000fe400020006ffULL, 0x00000008ff527819ULL, 0x000fe40000011652ULL,
0x00000069ff6a723eULL, 0x000fe200020006ffULL, 0x20000060ff697230ULL, 0x000fe20000004100ULL,
0x0000004aff6c723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000006aff4d7230ULL, 0x000fe20000004100ULL, 0x00000052ff60723eULL, 0x000fe200020006ffULL,
0x20000050ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff507819ULL, 0x000fe20000011667ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x000010546b507816ULL, 0x000fe40000000050ULL, 0x000000ff53537812ULL, 0x000fe200078ec0ffULL,
0x20000064ff477230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x000fe40000011641ULL,
0x000000ff415b7812ULL, 0x000fe200078ec0ffULL, 0x00000050182c723cULL, 0x000b62000004182cULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x00000010ff6b7819ULL, 0x000fe2000001166cULL, 0x20000059ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000062ff4a7230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000005cff627230ULL, 0x000fe20000004100ULL, 0x00000053ff6a723eULL, 0x000fe400020006ffULL,
0x00000065ff4e723eULL, 0x020fe200020006ffULL, 0x20000054ff657230ULL, 0x000fe20000004100ULL,
0x0000005bff4f723eULL, 0x000fe200020006ffULL, 0x2000003dff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff537819ULL, 0x000fe20000011661ULL, 0x2000006dff677230ULL, 0x000fe20000004100ULL,
0x000010546b517816ULL, 0x000fe20000000068ULL, 0x20000060ff617230ULL, 0x000fe20000004100ULL,
0x0000105469507816ULL, 0x000fe20000000070ULL, 0x2000006aff607230ULL, 0x000fe20000004100ULL,
0x000000ff66667812ULL, 0x000fe200078ec0ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff633d7812ULL, 0x000fe200078ec0ffULL, 0x20000058ff637230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x000000501828723cULL, 0x000b620000041828ULL,
0x00000066ff6a723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe20000011664ULL, 0x20000053ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff667819ULL, 0x000fe2000001164dULL,
0x2000006aff4d7230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x0000003dff3d723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff507819ULL, 0x020fe20000011663ULL, 0x2000003dff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fc40000011667ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000105469537816ULL, 0x000fe20000000066ULL, 0x20000055ff587230ULL, 0x000fe20000004100ULL,
0x0000105452527816ULL, 0x000fe20000000065ULL, 0x2000004bff597230ULL, 0x000fe20000004100ULL,
0x0000105462517816ULL, 0x000fc40000000051ULL, 0x0000105461507816ULL, 0x000fe40000000050ULL,
0x000000ff40407812ULL, 0x000fe200078ec0ffULL, 0x000000521824723cULL, 0x040b620000041824ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000008ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff537819ULL, 0x020fe2000001165cULL,
0x000000501820723cULL, 0x000b620000041820ULL, 0x000000ff575c7812ULL, 0x000fe200078ec0ffULL,
0x20000040ff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff577819ULL, 0x000fc40000011664ULL,
0x000000ff5f657812ULL, 0x000fe400078ec0ffULL, 0x00000010ff507819ULL, 0x020fe40000011659ULL,
0x00000010ff517819ULL, 0x000fe40000011660ULL, 0x0000105457507816ULL, 0x000fe40000000050ULL,
0x0000105458517816ULL, 0x000fe40000000051ULL, 0x0000005eff5f723eULL, 0x000fc400020006ffULL,
0x00000010ff5e7819ULL, 0x000fe4000001165aULL, 0x00000010ff527819ULL, 0x000fe2000001165bULL,
0x00000050181c723cULL, 0x000b62000004181cULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x2000005fff5b7230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x000010545e537816ULL, 0x000fe20000000053ULL,
0x2000003eff547230ULL, 0x000fe20000004100ULL, 0x000010545d527816ULL, 0x000fc40000000052ULL,
0x0000ffff41417812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1a7819ULL, 0x020fe40000011647ULL,
0x00000010ff187819ULL, 0x000fe2000001164aULL, 0x000000521434723cULL, 0x000b620000041834ULL,
0x00000010ff197819ULL, 0x000fe4000001164bULL, 0x00000010ff1b7819ULL, 0x000fe4000001164cULL,
0x00000072ff72723eULL, 0x000fc400020006ffULL, 0x00000071ff3d723eULL, 0x000fe400020006ffULL,
0x0000003cff3e723eULL, 0x000fe200020006ffULL, 0x20000072ff3c7230ULL, 0x000fe20000004100ULL,
0x0000006eff40723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000056ff59723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000008ff417819ULL, 0x000fe20000011641ULL, 0x20000065ff5a7230ULL, 0x000fe20000004100ULL,
0x000010541a197816ULL, 0x000fe20000000019ULL, 0x20000059ff537230ULL, 0x020fe20000004100ULL,
0x000010541b187816ULL, 0x000fc40000000018ULL, 0x00000010ff457819ULL, 0x000fe4000001163fULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x00000018142c723cULL, 0x000b62000004182cULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x000000ff45457812ULL, 0x000fe200078ec0ffULL, 0x20000041ff557230ULL, 0x000fe20000004100ULL,
0x00000008ff3f7819ULL, 0x000fc4000001163fULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff1a7819ULL, 0x000fe4000001163dULL, 0x00000010ff1b7819ULL, 0x000fe4000001164dULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff197819ULL, 0x020fc4000001165aULL, 0x00000010ff187819ULL, 0x000fe40000011640ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x0000006fff41723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x2000005cff527230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x000010543c1b7816ULL, 0x000fe2000000001bULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x000010545b1a7816ULL, 0x000fe2000000001aULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000010543e197816ULL, 0x000fc40000000019ULL,
0x0000105453187816ULL, 0x000fe40000000018ULL, 0x00000010ff567819ULL, 0x000fe2000001164eULL,
0x0000001a1428723cULL, 0x040b620000041828ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164fULL,
0x00000010ff4f7819ULL, 0x000fe40000011654ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff1a7819ULL, 0x020fe20000011641ULL, 0x000000181424723cULL, 0x000b620000041824ULL,
0x00000010ff3d7819ULL, 0x000fc40000011652ULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff1b7819ULL, 0x000fe40000011646ULL, 0x00000010ff187819ULL, 0x020fe40000011643ULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff3f7819ULL, 0x000fc4000001163fULL, 0x00001054564f7816ULL, 0x000fe4000000004fULL,
0x00001054554e7816ULL, 0x000fe4000000004eULL, 0x000010541a3d7816ULL, 0x000fe4000000003dULL,
0x000010541b3c7816ULL, 0x000fe40000000042ULL, 0x0000105418457816ULL, 0x000fe20000000045ULL,
0x0000004e1430723cULL, 0x000b620000041830ULL, 0x000010543f447816ULL, 0x000fce0000000044ULL,
0x0000003c1420723cULL, 0x040b700000041820ULL, 0x00000044141c723cULL, 0x000b62000004181cULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe7c000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff387224ULL, 0x000fe200078e000eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffda9000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x0a0fe20000410000ULL,
0x0000000631147220ULL, 0x080fe20000410000ULL, 0x0000000610107220ULL, 0x080fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000062c387220ULL, 0x080fe20000410000ULL, 0x00000006253c7220ULL, 0x080fe20000410000ULL,
0x0000000636157220ULL, 0x080fe20000410000ULL, 0x0000000632177220ULL, 0x080fe20000410000ULL,
0x0000000633187220ULL, 0x080fe20000410000ULL, 0x000000062f2c7220ULL, 0x080fe20000410000ULL,
0x0000000626257220ULL, 0x080fe20000410000ULL, 0x00000006231a7220ULL, 0x080fe20000410000ULL,
0x0000000637167220ULL, 0x080fe20000410000ULL, 0x000000062d337220ULL, 0x080fe20000410000ULL,
0x00000006122f7220ULL, 0x080fe20000410000ULL, 0x00000006133e7220ULL, 0x080fe20000410000ULL,
0x0000000624367220ULL, 0x080fe20000410000ULL, 0x0000000627267220ULL, 0x080fe20000410000ULL,
0x000000ffff237224ULL, 0x000fe200078e0034ULL, 0x000000062e2d7220ULL, 0x080fe20000410000ULL,
0x000000ffff317224ULL, 0x000fe200078e0035ULL, 0x00000006113f7220ULL, 0x080fe20000410000ULL,
0x000000ffff327224ULL, 0x000fe200078e0030ULL, 0x00000006283d7220ULL, 0x080fe20000410000ULL,
0x000000062a127220ULL, 0x080fe20000410000ULL, 0x000000062b137220ULL, 0x080fe20000410000ULL,
0x0000000620397220ULL, 0x080fe20000410000ULL, 0x0000000621377220ULL, 0x080fe20000410000ULL,
0x0000000622197220ULL, 0x080fe20000410000ULL, 0x000000061d247220ULL, 0x080fe20000410000ULL,
0x000000061e1e7220ULL, 0x080fe20000410000ULL, 0x000000061f1f7220ULL, 0x000fe20000410000ULL,
0x000000ffff277224ULL, 0x000fc400078e0014ULL, 0x000000ffff347224ULL, 0x000fe400078e0010ULL,
0x000000ffff357224ULL, 0x000fe400078e0029ULL, 0x000000ffff307224ULL, 0x000fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000076107f8cULL, 0x0002a2000c80043fULL,
0x000000ffff2a7224ULL, 0x000fe400078e0015ULL, 0x000000ffff227224ULL, 0x000fe400078e0016ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0017ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff217224ULL, 0x000fe400078e0012ULL, 0x000000ffff207224ULL, 0x000fe400078e0013ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0019ULL, 0x000000ffff1d7224ULL, 0x000fc400078e001aULL,
0x0000000000127805ULL, 0x002fca0000015200ULL, 0x0000040076157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x006fc40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040076157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000404297824ULL, 0x000fe200078e00ffULL,
0x000000750d00720cULL, 0x000fc80003f06070ULL, 0xfffffff029287812ULL, 0x000fca00078ec0ffULL,
0x000000800b287824ULL, 0x000fca00078e0228ULL, 0x00f4000028107984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a0000187b06ULL, 0x000ee20000209000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x0000000204417824ULL, 0x000fe200078e00ffULL, 0x00005a00ff1a7a12ULL, 0x000fc800078e33ffULL,
0x0000000641417812ULL, 0x000fca00078ec0ffULL, 0x0000000141437824ULL, 0x000fe200078e0200ULL,
0x0000001800187308ULL, 0x008ee40000001000ULL, 0x0ffffffe18157810ULL, 0x008fcc0007ffe0ffULL,
0x0000001500157305ULL, 0x000ee4000021f000ULL, 0x000000ffff177224ULL, 0x008fc800078e0a15ULL,
0x00005a0017177a24ULL, 0x000fc800078e02ffULL, 0x0000001715197227ULL, 0x000fe200078e0014ULL,
0x0000007804147211ULL, 0x000fca00078ff0ffULL, 0x0000001419167227ULL, 0x000fc800078e00ffULL,
0x000000ffff177224ULL, 0x000fc800078e0a16ULL, 0x00005a0017177a24ULL, 0x000fe200078e0214ULL,
0x0000000814147810ULL, 0x000fc80007ffe0ffULL, 0x00005a0017007a0cULL, 0x000fe20003f06070ULL,
0x0000001419197227ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fc800078e0a19ULL,
0x00005a0015187a24ULL, 0x000fe400078e0214ULL, 0x000001000d157824ULL, 0x000fe400078e0277ULL,
0x80005a0017170a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0018007a0cULL, 0x000fe40003f46070ULL,
0x00005a0017007a0cULL, 0x000fe40003f26070ULL, 0x000000150a407217ULL, 0x000fc40007800000ULL,
0x0000000116160810ULL, 0x000fc60007ffe0ffULL, 0x0000000140407824ULL, 0x000fe400078e0a15ULL,
0x000000010c157824ULL, 0x000fe400078e0241ULL, 0x80005a0018182a10ULL, 0x000fe40007ffe0ffULL,
0x0000000115147824ULL, 0x040fe200078e0a40ULL, 0x0000000116161810ULL, 0x000fe40007ffe0ffULL,
0x000000401500720cULL, 0x000fe40003f66070ULL, 0x000000161a167207ULL, 0x000fc40006000000ULL,
0x00005a0018007a0cULL, 0x000fe40003f06070ULL, 0x0000001407157217ULL, 0x000fe20003800000ULL,
0x0000000143147824ULL, 0x000fe200078e0a40ULL, 0x0000001607167217ULL, 0x000fe40003800000ULL,
0x00000004ff157819ULL, 0x000fe40000011615ULL, 0x0000000119192810ULL, 0x000fe20007ffe0ffULL,
0x00000016055b7224ULL, 0x000fe200078e02ffULL, 0x000000ff15187207ULL, 0x000fc40001800000ULL,
0x000000404300720cULL, 0x000fe40003f26070ULL, 0x0000001407147217ULL, 0x000fe20003800000ULL,
0x000000015b157824ULL, 0x000fe200078e0218ULL, 0x0000000119190810ULL, 0x000fe40007ffe0ffULL,
0x000000ff14507207ULL, 0x000fe20000800000ULL, 0x0000000215147825ULL, 0x000fe200078e003aULL,
0x000000191a1a7207ULL, 0x000fe40006000000ULL, 0x0000001041477812ULL, 0x000fc400078efcffULL,
0x0000005b50177211ULL, 0x000fe200078fe0ffULL, 0x0000000614547981ULL, 0x0046a2000c1e9500ULL,
0x0000001a071a7217ULL, 0x000fc60003800000ULL, 0x0000000217167825ULL, 0x000fc800078e003aULL,
0x000000010c157824ULL, 0x008fe200078e0247ULL, 0x0000000616597981ULL, 0x0006a2000c1e9500ULL,
0x0000001a055d7224ULL, 0x000fe400078e02ffULL, 0x0000000115147824ULL, 0x000fe400078e0a40ULL,
0x0000000118197824ULL, 0x000fe200078e025dULL, 0x0000002041497812ULL, 0x000fe200078efcffULL,
0x0000000147457824ULL, 0x000fe200078e0200ULL, 0x0000001407167217ULL, 0x008fe20003800000ULL,
0x0000000219187825ULL, 0x000fe200078e003aULL, 0x000000401500720cULL, 0x000fc40003f26070ULL,
0x00000004ff167819ULL, 0x000fe20000011616ULL, 0x0000000145147824ULL, 0x040fe200078e0a40ULL,
0x0000005d501b7211ULL, 0x000fe200078fe0ffULL, 0x00000006184e7981ULL, 0x0006a2000c1e9500ULL,
0x000000010c4f7824ULL, 0x000fe200078e0249ULL, 0x000000404500720cULL, 0x000fe40003f06070ULL,
0x000000021b1a7825ULL, 0x000fe200078e003aULL, 0x0000001407147217ULL, 0x000fe40003800000ULL,
0x000000ff16187207ULL, 0x008fe20000800000ULL, 0x000000014f487824ULL, 0x000fe200078e0a40ULL,
0x000000061a617981ULL, 0x0006a6000c1e9500ULL, 0x000000015b157824ULL, 0x000fe200078e0218ULL,
0x000000ff14427207ULL, 0x000fc40000000000ULL, 0x0000004807487217ULL, 0x000fe20003800000ULL,
0x0000000215147825ULL, 0x000fe200078e003aULL, 0x000000404f00720cULL, 0x080fe40003f26070ULL,
0x00000004ff487819ULL, 0x000fe20000011648ULL, 0x00000001494d7824ULL, 0x000fe200078e0200ULL,
0x0000000614447981ULL, 0x0002a2000c1e9500ULL, 0x00000030414f7812ULL, 0x000fe400078efcffULL,
0x000000ff484a7207ULL, 0x000fe20000800000ULL, 0x0000000118197824ULL, 0x000fe200078e025dULL,
0x0000005b42177211ULL, 0x040fe200078fe0ffULL, 0x000000014d147824ULL, 0x002fe200078e0a40ULL,
0x0000005d421b7211ULL, 0x008fe200078fe0ffULL, 0x000000015b157824ULL, 0x000fe200078e024aULL,
0x000000404d00720cULL, 0x000fc40003f06070ULL, 0x0000001407147217ULL, 0x000fe20003800000ULL,
0x000000010c5f7824ULL, 0x000fe400078e024fULL, 0x0000000217167825ULL, 0x000fe200078e003aULL,
0x000000ff144c7207ULL, 0x000fc60000000000ULL, 0x0000000219187825ULL, 0x100fe200078e003aULL,
0x00000006164b7981ULL, 0x0002e6000c1e9500ULL, 0x000000021b1a7825ULL, 0x100fe200078e003aULL,
0x0000000618467981ULL, 0x0002e6000c1e9500ULL, 0x0000000215147825ULL, 0x000fe200078e003aULL,
0x000000061a517981ULL, 0x0002e6000c1e9500ULL, 0x000000015f527824ULL, 0x000fe200078e0a40ULL,
0x0000000614487981ULL, 0x0002e2000c1e9500ULL, 0x000000014f557824ULL, 0x000fe200078e0200ULL,
0x0000005b4c177211ULL, 0x002fc400078fe0ffULL, 0x0000005207527217ULL, 0x000fe20003800000ULL,
0x000000014a197824ULL, 0x000fe200078e025dULL, 0x0000005d4c1b7211ULL, 0x000fe200078fe0ffULL,
0x0000000155147824ULL, 0x000fe200078e0a40ULL, 0x000000405f00720cULL, 0x080fe40003f26070ULL,
0x00000004ff527819ULL, 0x000fe20000011652ULL, 0x0000000217167825ULL, 0x100fe200078e003aULL,
0x000000405500720cULL, 0x000fe40003f06070ULL, 0x0000001407147217ULL, 0x000fe20003800000ULL,
0x0000000219187825ULL, 0x100fe200078e003aULL, 0x000000ff52567207ULL, 0x000fe20000800000ULL,
0x0000000616537981ULL, 0x0002e4000c1e9500ULL, 0x000000021b1a7825ULL, 0x000fe200078e003aULL,
0x000000ff14527207ULL, 0x000fe20000000000ULL, 0x00000006184a7981ULL, 0x0002e8000c1e9500ULL,
0x000000061a577981ULL, 0x0002e2000c1e9500ULL, 0x000000015b157824ULL, 0x000fe200078e0256ULL,
0x0000005b52177211ULL, 0x002fc600078fe0ffULL, 0x0000000215147825ULL, 0x000fc800078e003aULL,
0x0000000217167825ULL, 0x000fe400078e003aULL, 0x0000000614147981ULL, 0x0002e2000c1e9500ULL,
0x0000005d52197211ULL, 0x000fc600078fe0ffULL, 0x0000000616177981ULL, 0x0002e2000c1e9500ULL,
0x00000001561b7824ULL, 0x000fe400078e025dULL, 0x0000000219187825ULL, 0x000fc800078e003aULL,
0x000000021b1a7825ULL, 0x000fe400078e003aULL, 0x0000000618187981ULL, 0x0002e8000c1e9500ULL,
0x000000061a1b7981ULL, 0x0002e2000c1e9500ULL, 0xfffffff0505d7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff507424ULL, 0x000fc800078e00ffULL, 0x0000000140567824ULL, 0x000fc800078e025dULL,
0x0000000143637824ULL, 0x000fe200078e0a56ULL, 0x00000001415b7812ULL, 0x040fe400078efcffULL,
0x0000000941157812ULL, 0x002fe400078efcffULL, 0x0000006350637219ULL, 0x000fe200000006ffULL,
0x000000015b5f7824ULL, 0x100fe400078e0200ULL, 0x0000000115197824ULL, 0x000fe400078e0200ULL,
0x000000015f657824ULL, 0x000fc400078e0a56ULL, 0x0000000119697824ULL, 0x000fc600078e0a56ULL,
0x0000006550657219ULL, 0x040fe400000006ffULL, 0x0000006950697219ULL, 0x000fe400000006ffULL,
0x00000011417b7812ULL, 0x040fe400078efcffULL, 0x0000001841717812ULL, 0x040fe400078efcffULL,
0xfffffff04c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000019416f7812ULL, 0x000fc400078efcffULL,
0xfffffff052527812ULL, 0x000fe200078ec0ffULL, 0x000000017b1a7824ULL, 0x100fe400078e0200ULL,
0x0000000171167824ULL, 0x000fe400078e0200ULL, 0x00000001406a7824ULL, 0x000fe400078e024cULL,
0x000000016f7d7824ULL, 0x000fe400078e0200ULL, 0x000000014d627824ULL, 0x000fe200078e0a6aULL,
0x00000021416b7812ULL, 0x000fc800078efcffULL, 0x0000006250627219ULL, 0x000fe200000006ffULL,
0x000000016b6d7824ULL, 0x000fc800078e0200ULL, 0x000000016d647824ULL, 0x000fca00078e0a6aULL,
0x0000006450647219ULL, 0x000fe400000006ffULL, 0x0000541059547816ULL, 0x004fe40000000054ULL,
0x0000000841597812ULL, 0x000fe400078efcffULL, 0x0000005463ff7212ULL, 0x000fc6000780c0ffULL,
0x00000001595d7824ULL, 0x000fe200078e0200ULL, 0x000000404300720cULL, 0x000fc60000701470ULL,
0x000000015d677824ULL, 0x000fe200078e0a56ULL, 0x000000404100720cULL, 0x000fc800007a1070ULL,
0x0000006750677219ULL, 0x000fe400000006ffULL, 0xff80000023237808ULL, 0x000fe40002800000ULL,
0x00005410614e7816ULL, 0x000fc8000000004eULL, 0x0000004e63ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004e65ff7212ULL, 0x080fe4000780c0ffULL, 0x0000004e67ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004e69ff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff0424e7812ULL, 0x000fe400078ec0ffULL,
0x0000005465ff7212ULL, 0x000fc6000782c0ffULL, 0x00000001404e7824ULL, 0x040fe200078e024eULL,
0x0000005467ff7212ULL, 0x080fe4000786c0ffULL, 0x0000005469ff7212ULL, 0x000fe2000788c0ffULL,
0x0000000140547824ULL, 0x000fe400078e0252ULL, 0x00000001454c7824ULL, 0x100fe200078e0a4eULL,
0x000000404300720cULL, 0x080fe20001741470ULL, 0x000000011a527824ULL, 0x100fe200078e0a4eULL,
0x000000405d00720cULL, 0x080fe200037c1470ULL, 0x00000001165e7824ULL, 0x100fe200078e0a4eULL,
0x000000401900720cULL, 0x000fe20002fa1470ULL, 0x000000017d6e7824ULL, 0x000fe200078e0a4eULL,
0x0000004c504e7219ULL, 0x000fc400000006ffULL, 0x00000052504c7219ULL, 0x040fe400000006ffULL,
0x000000404100720cULL, 0x080fe40001741070ULL, 0x000000405900720cULL, 0x080fe400037c1070ULL,
0x000000401500720cULL, 0x000fe40002fa1070ULL, 0x0000005e50527219ULL, 0x000fe400000006ffULL,
0x000054104b4b7816ULL, 0x008fc40000000044ULL, 0x0000541051517816ULL, 0x000fe40000000046ULL,
0xff8000002a2a7808ULL, 0x000fe40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40003000000ULL,
0xff8000002e2e7808ULL, 0x000fe40002800000ULL, 0x0000004b4eff7212ULL, 0x040fe4000784c0ffULL,
0x000000514eff7212ULL, 0x000fc400078cc0ffULL, 0x0000005152ff7212ULL, 0x000fe400078ac0ffULL,
0x000000405f00720cULL, 0x0c0fe40000f21470ULL, 0x000000405f00720cULL, 0x080fe40000701470ULL,
0x000000405d00720cULL, 0x080fe40001f61470ULL, 0x000000401900720cULL, 0x080fe40002781470ULL,
0x000000404500720cULL, 0x000fc40001741470ULL, 0x000000404500720cULL, 0x080fe400037c1470ULL,
0x000000401600720cULL, 0x080fe40002fa1470ULL, 0x0000002841697812ULL, 0x040fe400078efcffULL,
0x0000002941677812ULL, 0x000fe400078efcffULL, 0x000000405b00720cULL, 0x0c0fe40000f21070ULL,
0x000000405b00720cULL, 0x000fc40000701070ULL, 0x000000405900720cULL, 0x080fe40001f61070ULL,
0x000000401500720cULL, 0x080fe40002781070ULL, 0x000000404700720cULL, 0x0c0fe40001741070ULL,
0x000000404700720cULL, 0x080fe400037c1070ULL, 0x000000407100720cULL, 0x000fe40002fa1070ULL,
0x0000006e505e7219ULL, 0x000fc400000006ffULL, 0x0000541053537816ULL, 0x000fe40000000048ULL,
0x0000541057577816ULL, 0x000fe2000000004aULL, 0x0000000169427824ULL, 0x100fe200078e0200ULL,
0xff80000031317808ULL, 0x000fe20000800000ULL, 0x00000001675c7824ULL, 0x000fe200078e0200ULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fc40002000000ULL, 0xff80000038387808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000004b4cff7212ULL, 0x080fe4000782c0ffULL, 0x0000004b52ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004b5eff7212ULL, 0x000fc4000786c0ffULL, 0x000000514cff7212ULL, 0x080fe4000788c0ffULL,
0x000000515eff7212ULL, 0x000fe4000784c0ffULL, 0x0000005362ff7212ULL, 0x040fe400078cc0ffULL,
0x0000005762ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001426c7824ULL, 0x100fe200078e0a6aULL,
0x000000401a00720cULL, 0x080fe20000f21470ULL, 0x000000015c6a7824ULL, 0x000fe200078e0a6aULL,
0x000000401a00720cULL, 0x080fe20002781470ULL, 0x0000000155687824ULL, 0x000fe200078e0a54ULL,
0x000000401600720cULL, 0x000fc40000701470ULL, 0x000000407d00720cULL, 0x0c0fe40001f61470ULL,
0x000000407d00720cULL, 0x080fe40001741470ULL, 0x000000404d00720cULL, 0x0c0fe400037c1470ULL,
0x000000404d00720cULL, 0x000fe40002fa1470ULL, 0x0000003141657812ULL, 0x040fe400078efcffULL,
0x0000003841637812ULL, 0x000fc400078efcffULL, 0x0000003941617812ULL, 0x000fe400078efcffULL,
0x000000407b00720cULL, 0x0c0fe40000f21070ULL, 0x000000407b00720cULL, 0x080fe40002781070ULL,
0x000000407100720cULL, 0x080fe40000701070ULL, 0x000000406f00720cULL, 0x0c0fe40001f61070ULL,
0x000000406f00720cULL, 0x000fc40001741070ULL, 0x000000404900720cULL, 0x0c0fe400037c1070ULL,
0x000000404900720cULL, 0x000fe40002fa1070ULL, 0x0000006c506c7219ULL, 0x040fe400000006ffULL,
0x0000006a506a7219ULL, 0x040fe400000006ffULL, 0x0000006850687219ULL, 0x000fe400000006ffULL,
0x0000541017177816ULL, 0x000fe20000000014ULL, 0x00000001655a7824ULL, 0x100fe200078e0200ULL,
0xff80000033337808ULL, 0x000fe20000800000ULL, 0x0000000163587824ULL, 0x100fe200078e0200ULL,
0xff8000002c2c7808ULL, 0x000fe20002000000ULL, 0x0000000161567824ULL, 0x000fe200078e0200ULL,
0xff80000034347808ULL, 0x000fc40000000000ULL, 0xff8000003f3f7808ULL, 0x000fe40001800000ULL,
0xff8000003e3e7808ULL, 0x000fe40001000000ULL, 0xff8000003d3d7808ULL, 0x000fe40003000000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0x0000005364ff7212ULL, 0x080fe4000782c0ffULL,
0x000000536cff7212ULL, 0x000fc4000788c0ffULL, 0x000000536aff7212ULL, 0x000fe4000780c0ffULL,
0x0000005764ff7212ULL, 0x080fe4000786c0ffULL, 0x000000576cff7212ULL, 0x080fe4000784c0ffULL,
0x000000576aff7212ULL, 0x000fe400078cc0ffULL, 0x0000001768ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015a667824ULL, 0x100fe200078e0a54ULL, 0x000000406d00720cULL, 0x0c0fe20000f21470ULL,
0x0000000158607824ULL, 0x100fe200078e0a54ULL, 0x000000406d00720cULL, 0x080fe20001f61470ULL,
0x0000000156547824ULL, 0x000fe200078e0a54ULL, 0x000000404200720cULL, 0x000fc40002781470ULL,
0x000000404200720cULL, 0x080fe40001741470ULL, 0x000000405c00720cULL, 0x0c0fe40000701470ULL,
0x000000405c00720cULL, 0x080fe400037c1470ULL, 0x000000405500720cULL, 0x080fe40002fa1470ULL,
0x000000406b00720cULL, 0x0c0fe40000f21070ULL, 0x000000406b00720cULL, 0x000fc40001f61070ULL,
0x000000406900720cULL, 0x0c0fe40002781070ULL, 0x000000406900720cULL, 0x080fe40001741070ULL,
0x000000406700720cULL, 0x0c0fe40000701070ULL, 0x000000406700720cULL, 0x080fe400037c1070ULL,
0x000000404f00720cULL, 0x000fe40002fa1070ULL, 0x0000006650667219ULL, 0x000fc400000006ffULL,
0x0000006050607219ULL, 0x040fe400000006ffULL, 0x0000005450547219ULL, 0x000fe400000006ffULL,
0x00005410181b7816ULL, 0x000fe4000000001bULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff80000020207808ULL, 0x000fe40001800000ULL, 0xff80000036367808ULL, 0x000fc40002000000ULL,
0xff80000025257808ULL, 0x000fe40001000000ULL, 0xff8000003c3c7808ULL, 0x000fe40000000000ULL,
0xff80000026267808ULL, 0x000fe40003000000ULL, 0xff80000039397808ULL, 0x000fe40002800000ULL,
0x0000001766ff7212ULL, 0x080fe4000782c0ffULL, 0x0000001760ff7212ULL, 0x000fc4000786c0ffULL,
0x0000001754ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001b68ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001b66ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001b60ff7212ULL, 0x080fe400078cc0ffULL,
0x0000001b54ff7212ULL, 0x000fe400078ac0ffULL, 0x000000405500720cULL, 0x000fc40001741470ULL,
0x000000405a00720cULL, 0x0c0fe40000f21470ULL, 0x000000405a00720cULL, 0x080fe40000701470ULL,
0x000000405800720cULL, 0x0c0fe40001f61470ULL, 0x000000405800720cULL, 0x080fe400037c1470ULL,
0x000000405600720cULL, 0x0c0fe40002781470ULL, 0x000000405600720cULL, 0x000fc40002fa1470ULL,
0x000000404f00720cULL, 0x080fe40001741070ULL, 0x000000406500720cULL, 0x0c0fe40000f21070ULL,
0x000000406500720cULL, 0x080fe40000701070ULL, 0x000000406300720cULL, 0x0c0fe40001f61070ULL,
0x000000406300720cULL, 0x080fe400037c1070ULL, 0x000000406100720cULL, 0x000fc40002781070ULL,
0x000000406100720cULL, 0x000fe40002fa1070ULL, 0xff80000037377808ULL, 0x000fe40000800000ULL,
0xff80000030307808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fc40000000000ULL,
0xff8000001e1e7808ULL, 0x000fe40003000000ULL, 0xff8000001f1f7808ULL, 0x000fc40002800000ULL,
0x000000231000720bULL, 0x004fe20003f1e000ULL, 0x0000001fff1a7424ULL, 0x000fe200078e00ffULL,
0x0000002a1100720bULL, 0x000fe20003f3e000ULL, 0xffffffffff1b7424ULL, 0x000fe200078e00ffULL,
0x0000001023107208ULL, 0x000fe40004000000ULL, 0x000000112a117208ULL, 0x000fe40004800000ULL,
0x000000311000720bULL, 0x000fc40003f1e000ULL, 0x000000221100720bULL, 0x000fe40003f3e000ULL,
0x0000001031157208ULL, 0x000fe40004000000ULL, 0x0000001122107208ULL, 0x000fe40004800000ULL,
0x000000321500720bULL, 0x000fe40003f1e000ULL, 0x0000002b1000720bULL, 0x000fe40003f3e000ULL,
0x0000001532147208ULL, 0x000fc40004000000ULL, 0x000000102b117208ULL, 0x000fe40004800000ULL,
0x000000271400720bULL, 0x000fe40003f1e000ULL, 0x0000002e1100720bULL, 0x000fe40003f3e000ULL,
0x0000001427157208ULL, 0x000fe40004000000ULL, 0x000000112e107208ULL, 0x000fe40004800000ULL,
0x000000381500720bULL, 0x000fc40003f1e000ULL, 0x0000002d1000720bULL, 0x000fe40003f3e000ULL,
0x0000001538147208ULL, 0x000fe40004000000ULL, 0x000000102d117208ULL, 0x000fe40004800000ULL,
0x000000331400720bULL, 0x000fe40003f1e000ULL, 0x0000002c1100720bULL, 0x000fe40003f3e000ULL,
0x0000001433157208ULL, 0x000fc40004000000ULL, 0x000000112c107208ULL, 0x000fe40004800000ULL,
0x000000341500720bULL, 0x000fe40003f1e000ULL, 0x0000002f1000720bULL, 0x000fe40003f3e000ULL,
0x0000001534147208ULL, 0x000fe40004000000ULL, 0x000000102f117208ULL, 0x000fe40004800000ULL,
0x0000003f1400720bULL, 0x000fc40003f1e000ULL, 0x0000003e1100720bULL, 0x000fe40003f3e000ULL,
0x000000143f147208ULL, 0x000fe40004000000ULL, 0x000000113e107208ULL, 0x000fe40004800000ULL,
0x0000003d1400720bULL, 0x000fe40003f1e000ULL, 0x000000211000720bULL, 0x000fe40003f3e000ULL,
0x000000143d147208ULL, 0x000fc40004000000ULL, 0x0000001021117208ULL, 0x000fe40004800000ULL,
0x000000351400720bULL, 0x000fe40003f1e000ULL, 0x000000201100720bULL, 0x000fe40003f3e000ULL,
0x0000001435157208ULL, 0x000fe40004000000ULL, 0x0000001120107208ULL, 0x000fe40004800000ULL,
0x000000361500720bULL, 0x000fc40003f1e000ULL, 0x000000251000720bULL, 0x000fe40003f3e000ULL,
0x0000001536157208ULL, 0x000fe40004000000ULL, 0x0000001025117208ULL, 0x000fe40004800000ULL,
0x0000003c1500720bULL, 0x000fe40003f1e000ULL, 0x000000261100720bULL, 0x000fe40003f3e000ULL,
0x000000153c107208ULL, 0x000fc40004000000ULL, 0x0000001126117208ULL, 0x000fe40004800000ULL,
0x000000391000720bULL, 0x000fe40003f1e000ULL, 0x0000001c1100720bULL, 0x000fe40003f3e000ULL,
0x0000001039107208ULL, 0x000fe40004000000ULL, 0x000000111c147208ULL, 0x000fe40004800000ULL,
0x000000371000720bULL, 0x000fc40003f1e000ULL, 0x0000001d1400720bULL, 0x000fe40003f3e000ULL,
0x0000001037117208ULL, 0x000fe40004000000ULL, 0x000000141d157208ULL, 0x000fe40004800000ULL,
0x000000301100720bULL, 0x000fe40003f1e000ULL, 0x0000001e1500720bULL, 0x000fe40003f3e000ULL,
0x0000001130117208ULL, 0x000fc40004000000ULL, 0x000000151e107208ULL, 0x000fe40004800000ULL,
0x000000241100720bULL, 0x000fe40003f1e000ULL, 0x0000001f1000720bULL, 0x000fe40003f3e000ULL,
0x0000001124167208ULL, 0x000fe40004000000ULL, 0x000000101f187208ULL, 0x000fe20004800000ULL,
0x000014a27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0016107f89ULL, 0x0004e400000e0000ULL,
0x000000101600720bULL, 0x008fc80003f1e000ULL, 0x0000001610197208ULL, 0x000fe20004000000ULL,
0x000014b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0018107f89ULL, 0x000ee800000e0000ULL,
0x0c401f0012117f89ULL, 0x000e6800000e0000ULL, 0x0c401f0013407f89ULL, 0x000ea200000e0000ULL,
0x000000101800720bULL, 0x008fc40003f1e000ULL, 0x000000111200720bULL, 0x002fe40003f3e000ULL,
0x0000001810147208ULL, 0x000fe40004000000ULL, 0x0000001211157208ULL, 0x000fe20004800000ULL,
0x0c201f0019107f89ULL, 0x000e6200000e0000ULL, 0x000000401300720bULL, 0x004fc60003f1e000ULL,
0x0c201f0014117f89ULL, 0x000ea200000e0000ULL, 0x0000001340407208ULL, 0x000fc60004000000ULL,
0x0c201f0015167f89ULL, 0x000ee800000e0000ULL, 0x0c201f0040417f89ULL, 0x0002e400000e0000ULL,
0x000000101900720bULL, 0x002fe40003f1e000ULL, 0x000000111400720bULL, 0x004fe40003f3e000ULL,
0x0000001910107208ULL, 0x000fc40004000000ULL, 0x000000161500720bULL, 0x008fe40003f5e000ULL,
0x0000001411117208ULL, 0x000fe40004800000ULL, 0x0000001516127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b10427820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000304ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b34197823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b35347823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b11357820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b27137823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL,
0x0000003200167308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010842ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010842ULL,
0x0000001300177308ULL, 0x0006a20000000800ULL, 0x3fb8aa3b37327823ULL, 0x102fe20000010842ULL,
0x3fb8aa3b20377823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b3d277823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b26267823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010842ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010842ULL, 0x000000414000720bULL, 0x004fe20003f3e000ULL,
0x0000002300147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b39137823ULL, 0x008fce0000010842ULL,
0x0000003100157308ULL, 0x0002a20000000800ULL, 0x000000161716723eULL, 0x000fce00000010ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b36317823ULL, 0x102fe20000010842ULL,
0x3fb8aa3b3c367823ULL, 0x000fcc0000010842ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x000000141514723eULL, 0x004fce00000010ffULL, 0x0000002a001b7308ULL, 0x0005f00000000800ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x00000004ff2a7e24ULL, 0x004fe2000f8e00ffULL,
0x0000002b2e17723eULL, 0x002fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x3f8000002a2a783eULL, 0x000fc400000010ffULL, 0x0000001900197308ULL, 0x000fe60000000800ULL,
0x000000ffff2b7224ULL, 0x100fe400078e002aULL, 0x000000ffff3c7224ULL, 0x100fe400078e002aULL,
0x000000ffff3d7224ULL, 0x100fe200078e002aULL, 0x0000001b2215723eULL, 0x008fe200000010ffULL,
0x0000003f001a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b211b7823ULL, 0x000fe20000010835ULL,
0x000000ffff427224ULL, 0x000fc800078e002aULL, 0x0000002a1420723cULL, 0x000b6400000418ffULL,
0x0000002d002d7308ULL, 0x000fea0000000800ULL, 0x3fb8aa3b252b7823ULL, 0x020fc60000010835ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000191a1a723eULL, 0x002fce00000010ffULL,
0x0000003800187308ULL, 0x0003f00000000800ULL, 0x0000003300337308ULL, 0x000ee20000000800ULL,
0x0000002d2c19723eULL, 0x004fe200000010ffULL, 0x000000ffff2c7224ULL, 0x000fe200078e002aULL,
0x00000002ff387819ULL, 0x002fe20000011604ULL, 0x000000ffff2d7224ULL, 0x000fc800078e002aULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x00000008383f7824ULL, 0x040fe400078e00ffULL,
0x0000000838437824ULL, 0x000fca00078e00ffULL, 0x0000003e003e7308ULL, 0x000e620000000800ULL,
0x000000183318723eULL, 0x008fe200000010ffULL, 0x0000000838337824ULL, 0x000fcc00078e00ffULL,
0x0000001b002e7308ULL, 0x0003f00000000800ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000002f3e1b723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1e2f7823ULL, 0x000fcc0000010835ULL,
0x0000002c1820723cULL, 0x000b620000041820ULL, 0x0000003400347308ULL, 0x000e6c0000000800ULL,
0x3fb8aa3b1c2c7823ULL, 0x120fe20000010835ULL, 0x00000001381c7810ULL, 0x000fe20007ffe0ffULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d2d7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1f357823ULL, 0x000fe20000010835ULL, 0xfffffff833337812ULL, 0x000fca00078ee21cULL,
0x0000003600367308ULL, 0x000ea20000000800ULL, 0x00000027341c723eULL, 0x002fe400000010ffULL,
0xffffffff38347810ULL, 0x000fca0007ffe0ffULL, 0x0000003700377308ULL, 0x000e700000000800ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x00000031361e723eULL, 0x004fe200000010ffULL,
0x0000000838317824ULL, 0x040fe200078e00ffULL, 0x0000000838367810ULL, 0x000fca0007ffe0ffULL,
0x0000002600267308ULL, 0x000ea20000000800ULL, 0x0000002e371d723eULL, 0x002fe200000010ffULL,
0x00000008382e7824ULL, 0x040fe400078e00ffULL, 0x0000000838377824ULL, 0x000fe400078e00ffULL,
0x0000000836457824ULL, 0x000fe400078e00ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000002b261f723eULL, 0x004fce00000010ffULL, 0x0000002400257308ULL, 0x0002a20000000800ULL,
0x00000004382b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000338267810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82e397812ULL, 0x000fe200078ee22bULL, 0x0000003c1c20723cULL, 0x000b620000041820ULL,
0xfffffff837377812ULL, 0x000fe200078ee226ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000000238247810ULL, 0x042fe20007ffe0ffULL, 0x00000008382b7824ULL, 0x040fe200078e00ffULL,
0x0000000638267810ULL, 0x000fc40007ffe0ffULL, 0xfffffff831317812ULL, 0x000fe200078ee224ULL,
0x00000008383d7824ULL, 0x060fe200078e00ffULL, 0x0000000538247810ULL, 0x000fe20007ffe0ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0xfffffff82b2b7812ULL, 0x000fce00078ee238ULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000ef00000000800ULL,
0x0000002f00277308ULL, 0x0003f00000000800ULL, 0x00000035002e7308ULL, 0x000ee20000000800ULL,
0xfffffff83d2f7812ULL, 0x002fc400078ee224ULL, 0xfffffff83f3d7812ULL, 0x000fe400078ee226ULL,
0xfffffff8433f7812ULL, 0x000fe200078ee234ULL, 0x000000ffff437224ULL, 0x000fe200078e002aULL,
0x000000302526723eULL, 0x004fe400000010ffULL, 0x000000133224723eULL, 0x000fe400000010ffULL,
0x0000002c2d25723eULL, 0x008fe400000010ffULL, 0x000090000b307811ULL, 0x000fc400078e58ffULL,
0x0000000c292c7812ULL, 0x000fe400078ec0ffULL, 0x000000272e27723eULL, 0x000fe200000010ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0230ULL, 0xfffffff845357812ULL, 0x000fe200078ee236ULL,
0x0000001033337824ULL, 0x100fe200078e0230ULL, 0x0000004041137208ULL, 0x000fe20004800000ULL,
0x0000001031317824ULL, 0x100fe400078e0230ULL, 0x000000422420723cULL, 0x000f620000041820ULL,
0x0000001037377824ULL, 0x000fc400078e0230ULL, 0x0000001039397824ULL, 0x000fe400078e0230ULL,
0x000000012b2b7824ULL, 0x000fe400078e022cULL, 0x000000102f2f7824ULL, 0x100fe400078e0230ULL,
0x000000012c337824ULL, 0x040fe200078e0233ULL, 0x000000142b007388ULL, 0x0003e20000000800ULL,
0x000000103d3d7824ULL, 0x100fe400078e0230ULL, 0x000000012c317824ULL, 0x000fe200078e0231ULL,
0x0000001633007388ULL, 0x0003e20000000800ULL, 0x000000103f3f7824ULL, 0x000fc400078e0230ULL,
0x000000012c377824ULL, 0x040fe200078e0237ULL, 0x0000001831007388ULL, 0x0003e20000000800ULL,
0x0000001035357824ULL, 0x000fe400078e0230ULL, 0x000000012c397824ULL, 0x040fe200078e0239ULL,
0x0000001a37007388ULL, 0x0003e20000000800ULL, 0x000000012c2f7824ULL, 0x040fe400078e022fULL,
0x000000012c3d7824ULL, 0x040fe200078e023dULL, 0x0000001c39007388ULL, 0x0003e20000000800ULL,
0x000000012c3f7824ULL, 0x000fc400078e023fULL, 0x000000012c2c7824ULL, 0x000fe200078e0235ULL,
0x0000001e2f007388ULL, 0x0003e20000000800ULL, 0x000000ffff217224ULL, 0x020fc600078e0022ULL,
0x000000243d007388ULL, 0x0003e80000000800ULL, 0x000000263f007388ULL, 0x0003e80000000800ULL,
0x000000152c007388ULL, 0x0003e80000000800ULL, 0x0004001733007388ULL, 0x0003e80000000800ULL,
0x0004001931007388ULL, 0x0003e80000000800ULL, 0x0004001b37007388ULL, 0x0003e80000000800ULL,
0x0004001d39007388ULL, 0x0003e80000000800ULL, 0x0004001f2f007388ULL, 0x0003e80000000800ULL,
0x000400253d007388ULL, 0x0003e80000000800ULL, 0x000400273f007388ULL, 0x0003e80000000800ULL,
0x00f0001028008388ULL, 0x0003e80000000c00ULL, 0x00f2002028008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000079ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080079ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100079ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000010d0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000180079ff7f8cULL, 0x0003e6000c80043fULL, 0x000000080d00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffacc000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x000150e000187802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x012fea0003c00000ULL,
0xfffed7e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x0001512000187802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e000cULL, 0xfffed84000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x0001517000197802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x012fea0003c00000ULL, 0xfffed92000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x000151b000197802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x012fea0003c00000ULL, 0xfffeda4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0035ULL, 0x0001520000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0034ULL, 0x00000a5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xfffede7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0035ULL, 0x0001525000197802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xfffede5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x000152a000187802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x014fea0003c00000ULL,
0xffff063000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x000152e000187802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000cULL, 0xffff068000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x0001533000197802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x014fea0003c00000ULL, 0xffff077000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x0001537000197802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x016fea0003c00000ULL, 0xffff089000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x000153c000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0011ULL, 0x0000089000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xffff0cc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x0001541000197802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xffff0ca000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x0001546000187802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x014fea0003c00000ULL,
0xffff325000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x000154a000187802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0xffff32a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x000154f000197802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x014fea0003c00000ULL, 0xffff339000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x0001553000197802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x016fea0003c00000ULL, 0xffff34b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x0001558000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0012ULL, 0x000006d000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xffff38e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x000155d000197802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xffff38c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x0001562000187802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x012fea0003c00000ULL,
0xffff5ee000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x0001566000187802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000cULL, 0xffff5f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x000156b000197802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x012fea0003c00000ULL, 0xffff602000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x000156f000197802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x012fea0003c00000ULL, 0xffff614000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x0001574000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000eULL, 0x0000051000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e000cULL, 0xffff657000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x0001579000197802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e000cULL,
0xffff655000007947ULL, 0x000fea000383ffffULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x000157e000147802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0041ULL, 0xffffeb2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x006fe200078e0018ULL, 0x0001584000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x000000411800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0012ULL,
0x000158a000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x0000001841187208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000411200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0013ULL,
0x0001590000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x0000001241127208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000411300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0019ULL,
0x0001596000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000001341407208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000411900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0018ULL,
0x000159c000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000001941107208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000411800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0012ULL,
0x00015a2000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000001841117208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000411200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0040ULL,
0x00015a8000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000001241127208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe9f000007947ULL, 0x000fea000383ffffULL, 0x018000003d007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000003d00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3dff7812ULL, 0x040fe4000780c0ffULL,
0x800000003d027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003d00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffea3f002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000001b00007348ULL, 0x000fe80003800000ULL, 0x0c00001716417389ULL, 0x0002a200000e001aULL,
0xfffea3b014007950ULL, 0x000fea0003c3ffffULL, 0x0000007a00007348ULL, 0x000fe80003800000ULL,
0x0000000c180c7389ULL, 0x0002a400000e007bULL, 0x000000ffff187224ULL, 0x002fc400078e0019ULL,
0x00000000ff197424ULL, 0x000fc800078e00ffULL, 0xfffea36018007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f45070ULL, 0x00000000ff197424ULL, 0x000fe200078e00ffULL,
0x0000007900007348ULL, 0x000ff60003800000ULL, 0x00000000000c7806ULL, 0x000fc800050e0100ULL,
0x000000790c0c7212ULL, 0x000fe200078ec0ffULL, 0xfffea30018007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000300ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cf8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001588ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001598ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001628ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000162cULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000015e00ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017600ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017650ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000179d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001628ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015fd8ULL, 0x0000000000015fd8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017600ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000179d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_16_sm_89_cubin_len = 96944;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
