/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016d10ULL, 0x0000000000016890ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000014ef0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000015060ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000150a0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000150e0ULL,
0x0000000000000120ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000015200ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00014ef000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x0052780400288080ULL, 0x0000000000000000ULL, 0x000000b4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9b08288080970828ULL, 0x288080a008288080ULL, 0x80a308288080a208ULL, 0x08288080a4082880ULL,
0x8080a608288080a5ULL, 0xa808288080a70828ULL, 0x288080a908288080ULL, 0x80ab08288080aa08ULL,
0x08288080ad082880ULL, 0x8080b508288080b1ULL, 0xd708288080bc0828ULL, 0x288080df08288080ULL,
0x80ed08288080eb08ULL, 0x08288080ee082880ULL, 0x80808608288080f0ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00014ef000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x000000ccffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9008288080840828ULL, 0x2880809208288080ULL, 0x8098082880809708ULL,
0x0828808099082880ULL, 0x80809b082880809aULL, 0x9e082880809d0828ULL, 0x2880809f08288080ULL,
0x80a408288080a208ULL, 0x08288080a5082880ULL, 0x8080a708288080a6ULL, 0xa908288080a80828ULL,
0x288080ad08288080ULL, 0x80b508288080b108ULL, 0x08288080bc082880ULL, 0x8080df08288080d7ULL,
0xed08288080eb0828ULL, 0x288080ee08288080ULL, 0x808808288080f008ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080889200ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL,
0x0001506000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000d4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880809008288080ULL, 0x8097082880809208ULL,
0x0828808098082880ULL, 0x80809a0828808099ULL, 0x9d082880809b0828ULL, 0x2880809e08288080ULL,
0x80a2082880809f08ULL, 0x08288080a5082880ULL, 0x8080a708288080a6ULL, 0xa908288080a80828ULL,
0x288080aa08288080ULL, 0x80b108288080ad08ULL, 0x08288080b5082880ULL, 0x8080d708288080bcULL,
0xeb08288080df0828ULL, 0x288080ed08288080ULL, 0x80f008288080ee08ULL, 0x16288080a4082880ULL,
0x0000031028808280ULL, 0xa492000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000025800000000ULL, 0x000150a000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x000000d4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880809008288080ULL,
0x8097082880809208ULL, 0x0828808098082880ULL, 0x80809a0828808099ULL, 0x9d082880809b0828ULL,
0x2880809e08288080ULL, 0x80a2082880809f08ULL, 0x08288080a5082880ULL, 0x8080a708288080a6ULL,
0xa908288080a80828ULL, 0x288080aa08288080ULL, 0x80b108288080ad08ULL, 0x08288080b5082880ULL,
0x8080d708288080bcULL, 0xeb08288080df0828ULL, 0x288080ed08288080ULL, 0x80f008288080ee08ULL,
0x16288080a4082880ULL, 0x0000031028808280ULL, 0xa492000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000036000000000ULL, 0x000150e000000000ULL, 0x0000012000000000ULL,
0x0000000000000000ULL, 0x0000001200082f04ULL, 0x00081204000000afULL, 0x000000000000000dULL,
0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL,
0x0000000e00080a04ULL, 0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL,
0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL,
0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x0001366000000020ULL,
0x000138b0000138a0ULL, 0x00013a3000013a20ULL, 0x0160290400013a40ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL,
0x0500001d0500001dULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001602804ULL,
0x00001a0000000120ULL, 0x00001b5000001a90ULL, 0x00001f5000001b80ULL, 0x00001fe000001f80ULL,
0x0000427000002040ULL, 0x000043d000004300ULL, 0x00004810000044f0ULL, 0x0000489000004830ULL,
0x00006960000048f0ULL, 0x00006ac0000069f0ULL, 0x00006ef000006be0ULL, 0x00006f7000006f10ULL,
0x00008f2000006fd0ULL, 0x0000908000008fb0ULL, 0x000094c0000091a0ULL, 0x00009540000094e0ULL,
0x0000b080000095a0ULL, 0x0000d6000000b090ULL, 0x0000df300000d760ULL, 0x000132c00000df60ULL,
0x00013300000132f0ULL, 0x0001333000013310ULL, 0x0001337000013350ULL, 0x00013a1000013380ULL,
0x00013a8000013a70ULL, 0x000141a000013a90ULL, 0x00014260000141f0ULL, 0x00014340000142d0ULL,
0x00014400000143b0ULL, 0x000144b000014450ULL, 0x0001458000014520ULL, 0x00014640000145f0ULL,
0x000146f000014690ULL, 0x000147c000014760ULL, 0x0001488000014830ULL, 0x00014930000148d0ULL,
0x00014a00000149a0ULL, 0x00014ad000014a70ULL, 0x00014b8000014b30ULL, 0x00014c2000014bd0ULL,
0x00014cc000014c70ULL, 0x00014d8000014d10ULL, 0x00014e6000014e00ULL, 0x04c0390400014ec0ULL,
0x000000ff00000220ULL, 0x003f01000000f600ULL, 0x0000000b00000290ULL, 0x003f01200000f608ULL,
0x0000000b000002e0ULL, 0x003f01200000f688ULL, 0x0000000b00000370ULL, 0x003f01200000f6a8ULL,
0x0000000b000003a0ULL, 0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL,
0x0000004100000630ULL, 0x003f01020000f68cULL, 0x00000041000006e0ULL, 0x003f01010000f688ULL,
0x000000ff00000ca0ULL, 0x0004010700000000ULL, 0x000000ff00000d40ULL, 0x0004010100000000ULL,
0x0000003a00000da0ULL, 0x003f010100000020ULL, 0x0000006700000ee0ULL, 0x003f010500000004ULL,
0x0000003a00000f50ULL, 0x003f010500000024ULL, 0x0000003a00000fd0ULL, 0x003f010500000024ULL,
0x0000002f000016e0ULL, 0x003f010700000000ULL, 0x0000002f000017c0ULL, 0x003f010100000000ULL,
0x00000031000017d0ULL, 0x003f010500000004ULL, 0x0000005700001840ULL, 0x003f01010000f608ULL,
0x0000005700001860ULL, 0x003f01050000f60cULL, 0x0000002600001900ULL, 0x003f01050000f60cULL,
0x0000003100001e40ULL, 0x003f010500000004ULL, 0x0000003100001ec0ULL, 0x003f010500000004ULL,
0x0000003a00003910ULL, 0x003f010100000020ULL, 0x0000005000003990ULL, 0x003f01010000f688ULL,
0x00000067000039e0ULL, 0x003f010500000004ULL, 0x0000003a00003a30ULL, 0x003f010500000024ULL,
0x0000003a00003ab0ULL, 0x003f010500000024ULL, 0x0000006000003fe0ULL, 0x003f010700000000ULL,
0x0000006000004060ULL, 0x003f010100000000ULL, 0x0000006100004070ULL, 0x003f010500000004ULL,
0x00000065000040e0ULL, 0x003f01010000f628ULL, 0x0000006500004100ULL, 0x003f01050000f62cULL,
0x00000024000041c0ULL, 0x003f01050000f62cULL, 0x00000024000046e0ULL, 0x003f01050000f6acULL,
0x0000002400004760ULL, 0x003f01050000f6acULL, 0x0000003a00006010ULL, 0x003f010100000020ULL,
0x0000005000006080ULL, 0x003f01010000f690ULL, 0x00000067000060c0ULL, 0x003f010500000004ULL,
0x0000003a00006110ULL, 0x003f010500000024ULL, 0x0000003a00006190ULL, 0x003f010500000024ULL,
0x00000030000066c0ULL, 0x0005010700000000ULL, 0x0000003000006740ULL, 0x0005010100000000ULL,
0x0000005600006750ULL, 0x0005010500000004ULL, 0x00000057000067c0ULL, 0x003f01010000f648ULL,
0x00000057000067e0ULL, 0x003f01050000f64cULL, 0x00000026000068b0ULL, 0x003f01050000f64cULL,
0x0000002500006dc0ULL, 0x003f01050000f6acULL, 0x0000002500006e40ULL, 0x003f01050000f6acULL,
0x0000003a000086e0ULL, 0x003f010100000020ULL, 0x0000005000008750ULL, 0x003f01010000f698ULL,
0x00000067000087b0ULL, 0x003f010500000004ULL, 0x0000003a00008800ULL, 0x003f010500000024ULL,
0x0000003a00008880ULL, 0x003f010500000024ULL, 0x0000006000008cc0ULL, 0x003f010700000000ULL,
0x0000006a00008d40ULL, 0x003f010100000000ULL, 0x0000006100008d50ULL, 0x003f010500000004ULL,
0x0000006500008dc0ULL, 0x003f01010000f668ULL, 0x0000006500008de0ULL, 0x003f01050000f66cULL,
0x0000006500008e70ULL, 0x003f01050000f66cULL, 0x0000002400009390ULL, 0x003f01050000f6acULL,
0x0000002400009410ULL, 0x003f01050000f6acULL, 0x0000003a0000ac20ULL, 0x003f010100000020ULL,
0x000000500000ac80ULL, 0x003f01010000f6a0ULL, 0x000000ff0000ecc0ULL, 0x003f01010000f600ULL,
0x000000ff0000fad0ULL, 0x003f01050000f604ULL, 0x000000ff0000fb70ULL, 0x003f01050000f604ULL,
0x000000ff0000fd80ULL, 0x003f01010000f600ULL, 0x000000ff0000fd90ULL, 0x003f01050000f604ULL,
0x000000ff0000fe20ULL, 0x003f01050000f604ULL, 0x00000037000127a0ULL, 0x003f010100000000ULL,
0x00000037000127e0ULL, 0x003f010500000004ULL, 0x0000003700012bc0ULL, 0x003f010500000004ULL,
0x0000003900014000ULL, 0x003f010100000000ULL, 0x0000003900014060ULL, 0x003f010100000008ULL,
0x00000039000140c0ULL, 0x003f010100000010ULL, 0x0000003900014130ULL, 0x003f010100000018ULL,
0x00141c0400053803ULL, 0x0000ebc00000e970ULL, 0x0000ff300000fe80ULL, 0x0000040100014170ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL,
0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000454ULL, 0x0000001200000002ULL, 0x000000000000034cULL,
0x0000001200000002ULL, 0x0000000000000244ULL, 0x0000001200000002ULL, 0x0000000000000144ULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x000000000000042eULL,
0x0000001200000002ULL, 0x0000000000000326ULL, 0x0000001200000002ULL, 0x0000000000000221ULL,
0x0000001200000002ULL, 0x0000000000000120ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff307624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000000e00047300ULL, 0x000ee200000e0000ULL, 0x0000000830067824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea20000002200ULL, 0x00000100ff177424ULL, 0x000fc600078e00ffULL,
0x00000000002f7919ULL, 0x000f220000002600ULL, 0x0000000e000e7309ULL, 0x000f660000000000ULL,
0x0000000000337919ULL, 0x000ee80000002700ULL, 0x0000000000427919ULL, 0x000f620000000000ULL,
0x00000005ff367819ULL, 0x002fc6000001160bULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x00001fff36367589ULL, 0x000fe200000e0000ULL, 0x000000010d007824ULL, 0x004fc600078e0200ULL,
0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL, 0x00000080000b7824ULL, 0x000fe400078e020bULL,
0x000000082f007824ULL, 0x010fc600078e00ffULL, 0x000000ff0b00720cULL, 0x040fe20003f45270ULL,
0x0000003306007224ULL, 0x008fe200078e0200ULL, 0x0000000f0b00780cULL, 0x040fe20003f64070ULL,
0x00000010420a7824ULL, 0x020fe200078e00ffULL, 0x000000030b00780cULL, 0x040fe40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x00000004ff0f7819ULL, 0x000fe40000011642ULL,
0x000000050400720cULL, 0x002fc40003f02070ULL, 0x000000f00a157812ULL, 0x000fe200078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040d067824ULL, 0x004fe400078e0236ULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fe400078e00ffULL,
0x0000000108117824ULL, 0x040fe200078e020fULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe200078e00ffULL, 0x0000000711137812ULL, 0x000fe200078ec0ffULL,
0x0000000100027824ULL, 0x002fe400078e0211ULL, 0x0000000109007824ULL, 0x000fe200078e0a08ULL,
0x00f688060b009388ULL, 0x000fe20000008a00ULL, 0xff317217ff0cc424ULL, 0x000fc400078e00ffULL,
0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL, 0x000000000f00720cULL, 0x000fe20003f66070ULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f4000c0b00c388ULL, 0x0003e20000004800ULL,
0x3fffff80ff049424ULL, 0x004fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0017ULL, 0x00f6a8040b009388ULL, 0x0005e20000008a00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a0eULL, 0x0000000f130c7812ULL, 0x002fe400078e7842ULL,
0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001502027210ULL, 0x000fe20007f9e0ffULL, 0x00000010110c7824ULL, 0x000fc800078e020cULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100c077824ULL, 0x000fe400078e00ffULL,
0x00000004ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000620033047625ULL, 0x004fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604347981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff357e24ULL, 0x008fe2000f8e00ffULL,
0x0000007f34037810ULL, 0x006fc40007ffe0ffULL, 0x000000ff34027810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff037819ULL, 0x000fe40000011603ULL, 0x00000008ff027819ULL, 0x000fca0000011602ULL,
0x0000e66000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011636ULL,
0x0000000836417824ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fe200078e00ffULL,
0x01ffffff00007812ULL, 0x000fca00078ec0ffULL, 0x0000000235567824ULL, 0x000fca00078e0200ULL,
0x000000035600720cULL, 0x000fda0003f06070ULL, 0x0000000233008824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640000058624ULL, 0x000fe400078e0205ULL,
0x00000003ff007424ULL, 0x000fe400078e00ffULL, 0x0000000156058824ULL, 0x000fe200078e0205ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c0041ff738cULL, 0x0003e20000000000ULL,
0x0000600005048625ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000604408981ULL, 0x0004e2000c1e1900ULL, 0x00000001363f7812ULL, 0x000fe200078ec0ffULL,
0x000000802f3e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fe20000011642ULL,
0x00f6880041ff7f8cULL, 0x0009e2000c80043fULL, 0x00000001ff447819ULL, 0x000fe20000011636ULL,
0x000000103f097824ULL, 0x000fe200078e00ffULL, 0x00000004060c7810ULL, 0x040fe20007ffe0ffULL,
0xff317217ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000135077810ULL, 0x000fe20007ffe0ffULL,
0x0000000109087824ULL, 0x000fe200078e0206ULL, 0x00000008060e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000835057824ULL, 0x004fe200078e0244ULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x00000008080b7824ULL, 0x040fe200078e00ffULL, 0x0000004208007212ULL, 0x082fe200078e3cffULL,
0x0000002005057824ULL, 0x000fe200078e00ffULL, 0x0000000c06127810ULL, 0x000fe20007ffe0ffULL,
0x00000001090d7824ULL, 0x000fe200078e020cULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee200ULL,
0x00002000443d7824ULL, 0x000fe200078e00ffULL, 0x0000000534007217ULL, 0x000fe20007800000ULL,
0x000000080d117824ULL, 0x040fe200078e00ffULL, 0x000000420d047212ULL, 0x080fe200078e3cffULL,
0x0000000109147824ULL, 0x000fe200078e0212ULL, 0x00000000440473c2ULL, 0x000e6200000e0000ULL,
0x0000000100007824ULL, 0x100fe200078e0a05ULL, 0xfffffff811117812ULL, 0x000fe200078ee204ULL,
0x0000000109047824ULL, 0x000fe200078e020eULL, 0x000000603e057812ULL, 0x000fe200078ef805ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000000804197824ULL, 0x040fe200078e00ffULL, 0x0000004204107212ULL, 0x080fe200078e3cffULL,
0x0000000105137824ULL, 0x040fe200078e0204ULL, 0x0000000900047217ULL, 0x000fe20007800000ULL,
0x0000000105177824ULL, 0x040fe200078e0214ULL, 0x0000004214157212ULL, 0x040fe200078e3cffULL,
0x0000000105077824ULL, 0x000fe200078e0208ULL, 0x0000b0003d087810ULL, 0x000fe20007ffe0ffULL,
0x00000001050f7824ULL, 0x000fe200078e020dULL, 0xfffffff819057812ULL, 0x000fe200078ee210ULL,
0x0000000814147824ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000104047824ULL, 0x000fe200078e0a09ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000100b0d7824ULL, 0x100fe200078e0208ULL, 0xfffffff814197812ULL, 0x000fe200078ee215ULL,
0x0000001005157824ULL, 0x100fe200078e0208ULL, 0x000000040e00720cULL, 0x080fe20003f26070ULL,
0x0000001011117824ULL, 0x100fe200078e0208ULL, 0x000000040600720cULL, 0x080fe20003f66070ULL,
0x0000001019197824ULL, 0x000fe200078e0208ULL, 0x000000040c00720cULL, 0x080fe20003f46070ULL,
0x0000f6a804047891ULL, 0x002fe2000f8e203fULL, 0x000000041200720cULL, 0x000fe20003f06070ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000f6a8443a7811ULL, 0x000fe200078e18ffULL,
0x0000580040007a24ULL, 0x008fc800078e02ffULL, 0x0000008000007824ULL, 0x000fca00078e00ffULL,
0x0000000700057210ULL, 0x040fe40007f9e0ffULL, 0x0000000f000f7210ULL, 0x040fe40007fde0ffULL,
0x00005e00050c7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x00005e000f077a11ULL, 0x000fe200078838ffULL, 0x000000ffff047224ULL, 0x000fe200030e06ffULL,
0x0000001300137210ULL, 0x000fe40007fde0ffULL, 0x00005f00050e7a11ULL, 0x000fc400028f3c0eULL,
0x0000001700007210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005f000f0b7a11ULL, 0x000fe200020f3c04ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000700a0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200028e06ffULL,
0x00005e0013087a11ULL, 0x000fe400078838ffULL, 0x00005e00000a7a11ULL, 0x000fe400078c38ffULL,
0x0000000c0f047210ULL, 0x000fc40007fbe0ffULL, 0x00005f0013097a11ULL, 0x000fe400020f3c06ULL,
0x0000000f07067210ULL, 0x080fe40007f9e0ffULL, 0x00005f0000007a11ULL, 0x000fe200030f3c05ULL,
0x000000ffff057224ULL, 0x000fe200028e060eULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff077224ULL, 0x000fe200020e060bULL, 0x0000000f0a0a7210ULL, 0x000fe40007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0009e2000d901c46ULL,
0x000000ffff097224ULL, 0x000fc400028e0609ULL, 0x000000ffff0b7224ULL, 0x000fe200020e0600ULL,
0x0000000006117faeULL, 0x0009e8000d101c46ULL, 0x0000000008157faeULL, 0x0003e2000c901c46ULL,
0x000000023500720cULL, 0x000fc60003f26070ULL, 0x000000000a197faeULL, 0x0005e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x0000000000187805ULL, 0x004fc4000001ff00ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x010fec0000008000ULL,
0x00000000ff6a7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020003a247f8cULL, 0x0004e2000c80043fULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000203a677810ULL, 0x000fe20007ffe0ffULL,
0x00009ea000001947ULL, 0x000fea0003800000ULL, 0x0000000233397824ULL, 0x004fe400078e00ffULL,
0x00006400ff007624ULL, 0x000fc400078e00ffULL, 0xff317217ff3c7424ULL, 0x000fe400078e00ffULL,
0x0000640039397624ULL, 0x000fe400078e0200ULL, 0x000000ffff6c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fe400078e00ffULL, 0x0000010035277824ULL, 0x000fca00078e00ffULL,
0x000000342700720cULL, 0x000fda0003f06070ULL, 0x00009dd000000947ULL, 0x026fea0003800000ULL,
0x0000040067007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5e7224ULL, 0x000fe400078e0056ULL, 0x000000ffff387224ULL, 0x000fe200078e006cULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003a007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003a247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff5d7624ULL, 0x000fe200078e00ffULL, 0x0000000156007812ULL, 0x000fe200078ec0ffULL,
0x0000580040267a24ULL, 0x000fe200078e02ffULL, 0x00000003ff287819ULL, 0x000fe20000011642ULL,
0x00000100354f7824ULL, 0x000fe200078e00ffULL, 0x000000010000780cULL, 0x000fc40003f05070ULL,
0xffffffff5d5d7811ULL, 0x000fe200078e08ffULL, 0xffffffffff407424ULL, 0x000fc600078e00ffULL,
0x000000015d5d7807ULL, 0x000fca0004000000ULL, 0x0000000156567824ULL, 0x000fca00078e025dULL,
0x000000035600720cULL, 0x000fe20003f06070ULL, 0x0000001036007824ULL, 0x000fe200078e00ffULL,
0x00000001ff447819ULL, 0x000fe40000011636ULL, 0x0000000428307810ULL, 0x000fe40007ffe0ffULL,
0x0000001000297812ULL, 0x000fe200078ec0ffULL, 0x0000002044007824ULL, 0x000fcc00078e024fULL,
0x0000005d39248210ULL, 0x000fe20007ffe05eULL, 0x00000004ff258424ULL, 0x000fc800078e00ffULL,
0x0000600024248625ULL, 0x000fc800078e0025ULL, 0x0000000130457824ULL, 0x100fe200078e0229ULL,
0x0000000624408981ULL, 0x000562000c1e1900ULL, 0x0000000128437824ULL, 0x140fe200078e0229ULL,
0x0000000828327810ULL, 0x000fe20007ffe0ffULL, 0x00000010424b7824ULL, 0x000fe200078e00ffULL,
0x0000004245637212ULL, 0x080fe200078e3cffULL, 0x00000008432b7824ULL, 0x040fe200078e00ffULL,
0x0000004243627212ULL, 0x000fe200078e3cffULL, 0x0000000132477824ULL, 0x100fe200078e0229ULL,
0x0000000c28467810ULL, 0x000fe20007ffe0ffULL, 0x0000059000007945ULL, 0x000fe20003800000ULL,
0x0000004000257810ULL, 0x004fe20007ffe0ffULL, 0x0000000845247824ULL, 0x000fe200078e00ffULL,
0x0000000135277810ULL, 0x000fe20007ffe0ffULL, 0x0000000146497824ULL, 0x000fe200078e0229ULL,
0x0000002534007217ULL, 0x000fc40007800000ULL, 0xfffffff824637812ULL, 0x000fe200078ee263ULL,
0x00000008492d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b627812ULL, 0x000fe200078ee262ULL,
0x0000000100247824ULL, 0x100fe200078e0a25ULL, 0x000000603e007812ULL, 0x000fe200078ef825ULL,
0x00000080262b7824ULL, 0x000fe200078e00ffULL, 0x000000022700720cULL, 0x000fe20003f06070ULL,
0x0000000847277824ULL, 0x040fe200078e00ffULL, 0x0000004247647212ULL, 0x080fe200078e3cffULL,
0x0000000100257824ULL, 0x040fe200078e0243ULL, 0x0000004249667212ULL, 0x000fe200078e3cffULL,
0x0000000100267824ULL, 0x040fe200078e0245ULL, 0xfffffff827647812ULL, 0x000fe200078ee264ULL,
0x0000000100277824ULL, 0x040fe200078e0247ULL, 0x000000252b257210ULL, 0x040fe20007f5e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0249ULL, 0x000000262b2c7210ULL, 0x000fc40007f7e0ffULL,
0xfffffff82d667812ULL, 0x000fe200078ee266ULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x0000002024247807ULL, 0x000fe40000000000ULL, 0x00005e00252d7a11ULL, 0x000fe400078438ffULL,
0x000000272b277210ULL, 0x000fe40007f9e0ffULL, 0x0000002924247217ULL, 0x000fe40007800000ULL,
0x00005f00252f7a11ULL, 0x000fe200010f3c26ULL, 0x000000ffff257224ULL, 0x000fe200018e06ffULL,
0x000000002b2b7210ULL, 0x000fe20007f1e0ffULL, 0x000010006c007824ULL, 0x000fe200078e00ffULL,
0x00005e002c267a11ULL, 0x000fe200078438ffULL, 0x0000000124297824ULL, 0x000fe200078e0a29ULL,
0x000000704b317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2e7224ULL, 0x000fe200020e06ffULL,
0x00005f002c2c7a11ULL, 0x000fc400010f3c25ULL, 0x0000100000257812ULL, 0x000fe200078e0cffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x000000292800720cULL, 0x000fe40003f46070ULL,
0x00005e0027287a11ULL, 0x000fe200078638ffULL, 0x0000200044257824ULL, 0x000fe200078e0225ULL,
0x00005e002b2a7a11ULL, 0x000fe400078038ffULL, 0x00005f00272e7a11ULL, 0x000fe400018f3c2eULL,
0x000000312d247210ULL, 0x000fc40007f7e0ffULL, 0x0000b000252d7810ULL, 0x000fe40007ffe0ffULL,
0x0000003126267210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff257224ULL, 0x000fe200018e062fULL,
0x00005f002b2b7a11ULL, 0x000fe200000f3c00ULL, 0x0000001062597824ULL, 0x100fe200078e022dULL,
0x000000293000720cULL, 0x000fe20003f06070ULL, 0x000000ffff277224ULL, 0x000fe200028e062cULL,
0x0000003128287210ULL, 0x080fe20007f7e0ffULL, 0x00000010635a7824ULL, 0x100fe200078e022dULL,
0x000000312a2a7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024597faeULL, 0x0005e2000d101c46ULL, 0x000000293200720cULL, 0x080fe20003f46070ULL,
0x000000086c317824ULL, 0x000fe200078e00ffULL, 0x000000294600720cULL, 0x000fe20003fa6070ULL,
0x000000ffff297224ULL, 0x000fe200018e062eULL, 0xfffffff041007812ULL, 0x000fe200078ec0ffULL,
0x00000010645b7824ULL, 0x000fe200078e022dULL, 0x00000008312f7812ULL, 0x000fe200078e0cffULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0x0000f6a8002c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010665c7824ULL, 0x000fe200078e022dULL, 0x00000000265a7faeULL, 0x0007e2000c101c46ULL,
0xffffffe041007812ULL, 0x000fc400078ec0ffULL, 0x000000012c2f7824ULL, 0x000fe200078e022fULL,
0x00000000285b7faeULL, 0x0007e2000d101c46ULL, 0x0000001041257812ULL, 0x044fe400078ec0ffULL,
0x0000000841577812ULL, 0x000fe200078ec0ffULL, 0x000000002a5c7faeULL, 0x0007e2000e901c46ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000000100007824ULL, 0x000fe400078e0225ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000100577824ULL, 0x000fd000078e0257ULL,
0x000000002f0403c2ULL, 0x000ea40000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000012c317824ULL, 0x000fe200078e0231ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002f547f8cULL, 0x000528000c80043fULL, 0x0000040031267984ULL, 0x0084e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080057247f8cULL, 0x000fe2000c80043fULL, 0x8000000026ff7812ULL, 0x00afc6000784486bULL,
0x00f60c0057277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x000000083f267824ULL, 0x000fe400078e0200ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000277305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000270000735dULL, 0x008fe40003800000ULL,
0x00f60c0026277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002036467824ULL, 0x000fe200078e00ffULL,
0x00000001ff487819ULL, 0x000fe20000011642ULL, 0xffffffffff4a7424ULL, 0x000fe200078e00ffULL,
0x000000704b4b7812ULL, 0x000fe400078ec0ffULL, 0xffffff8046467812ULL, 0x000fe400078ec0ffULL,
0x0000000c48487812ULL, 0x000fc800078ec0ffULL, 0x0000004648007210ULL, 0x000fca0007ffe04bULL,
0x00f0000000277984ULL, 0x000e680000000800ULL, 0x00f2000000267984ULL, 0x0006a20000000800ULL,
0x0000003c2700720bULL, 0x002fe20003f1d000ULL, 0x000127827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800000e0100ULL, 0x0000ffff00297812ULL, 0x000fe2000780c0ffULL,
0x000003e000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x000003b000008947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x000fe40000011636ULL,
0x0000003c2700720bULL, 0x000fe40003f14000ULL, 0x000000362500720cULL, 0x000fe20003f65270ULL,
0x000127427f007947ULL, 0x000ff4000b800000ULL, 0x0000000000007806ULL, 0x000fe400000e0100ULL,
0x000000803625b824ULL, 0x000fe200078e024bULL, 0x000000273c2e7209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fe200078e3cffULL, 0x000000014825b824ULL, 0x000fe400078e0225ULL,
0x8000002e3c247221ULL, 0x000fe20000010000ULL, 0x0000000029ff7212ULL, 0x000fc4000780c0ffULL,
0x00f4002e2500b388ULL, 0x0003e20000000800ULL, 0x3fb8aa3b24247820ULL, 0x000fe20000410000ULL,
0x00000002ff007819ULL, 0x000fc60000011642ULL, 0x00000024002b7308ULL, 0x0002e20000000800ULL,
0x000126d27f007947ULL, 0x000fea000b800000ULL, 0x00001f002b287589ULL, 0x00866400000e0000ULL,
0x0000000800007810ULL, 0x008fe20007ffe0ffULL, 0x000127127f007947ULL, 0x000fea000b800000ULL,
0x00001f002b007589ULL, 0x00072400000e0000ULL, 0x8000002e27270221ULL, 0x100fe20000010000ULL,
0x0000002b3b3b7220ULL, 0x000fe20000410000ULL, 0x0000000023237220ULL, 0x090fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x0000002700370308ULL, 0x000f220000000800ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x0000000006067220ULL, 0x000fe20000410000ULL, 0x00000001ff2c7807ULL, 0x000fe20000000000ULL,
0x0000002821217220ULL, 0x082fe20000410000ULL, 0x0000002820207220ULL, 0x080fe20000410000ULL,
0x000000281d1d7220ULL, 0x080fe20000410000ULL, 0x000000281c1c7220ULL, 0x080fe20000410000ULL,
0x0000002819197220ULL, 0x080fe20000410000ULL, 0x0000002818187220ULL, 0x080fe20000410000ULL,
0x0000002815157220ULL, 0x080fe20000410000ULL, 0x0000002814147220ULL, 0x080fe20000410000ULL,
0x0000002811117220ULL, 0x080fe20000410000ULL, 0x0000002810107220ULL, 0x080fe20000410000ULL,
0x000000280d0d7220ULL, 0x080fe20000410000ULL, 0x000000280c0c7220ULL, 0x080fe20000410000ULL,
0x0000002809097220ULL, 0x080fe20000410000ULL, 0x0000002808087220ULL, 0x080fe20000410000ULL,
0x0000002805057220ULL, 0x080fe20000410000ULL, 0x0000002804047220ULL, 0x000fe20000410000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e002eULL, 0x0000003726260220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003b263b7221ULL, 0x004fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0000040031007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0000040031247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000037ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff267819ULL, 0x000fc40000011642ULL, 0x00005410002b7816ULL, 0x008fe20000000000ULL,
0x000123b27f007947ULL, 0x000fea000b800000ULL, 0x00001f262b5f7589ULL, 0x0002a400000e0000ULL,
0x00000008264c7810ULL, 0x000fe20007ffe0ffULL, 0x000123f27f007947ULL, 0x000fea000b800000ULL,
0x00001f4c2b007589ULL, 0x00066400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010266e7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x00001ff000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x000130b000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018266e7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0000205000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0001305000007944ULL, 0x03cfea0003c00000ULL, 0x0000000236507824ULL, 0x000fe200078e00ffULL,
0x0000000742257812ULL, 0x000fe200078ec0ffULL, 0x0000020036247824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000000450277812ULL, 0x000fc400078ec0ffULL,
0x0000000825307812ULL, 0x000fe400078ef842ULL, 0x00000027422d7211ULL, 0x000fe400078fe0ffULL,
0xfffff800244e7812ULL, 0x000fe400078ec0ffULL, 0x000000072d257812ULL, 0x000fca00078e7830ULL,
0x00000008304d7824ULL, 0x000fe200078e0225ULL, 0x0000000842257812ULL, 0x000fc600078ec0ffULL,
0x000000104d4d7824ULL, 0x000fe400078e024eULL, 0x0000000436247824ULL, 0x040fe200078e00ffULL,
0x0000000725287812ULL, 0x140fe200078ec842ULL, 0x0000100036267824ULL, 0x002fe200078e00ffULL,
0x00000007252e7812ULL, 0x000fe200078ef842ULL, 0x000010006c317824ULL, 0x000fe200078e023dULL,
0x0000000424277812ULL, 0x000fe400078ec0ffULL, 0xffffe00026297812ULL, 0x000fe400078ec0ffULL,
0x0000002742277211ULL, 0x000fe400078fe0ffULL, 0x000000802e327811ULL, 0x000fe200078e18ffULL,
0x000010006c297824ULL, 0x000fe200078e0229ULL, 0x00000002272b7810ULL, 0x008fc40007ffe0ffULL,
0x00000027282f7212ULL, 0x040fe400078e3cffULL, 0x0000002b28517212ULL, 0x000fe400078e3cffULL,
0x0000b00029297810ULL, 0x000fe20007ffe0ffULL, 0x000000082e587824ULL, 0x040fe200078e022fULL,
0x0000b00031337810ULL, 0x000fe20007ffe0ffULL, 0x000000082e537824ULL, 0x000fe200078e0251ULL,
0x000099102c607816ULL, 0x000fe200000000ffULL, 0x000000012f527824ULL, 0x000fe200078e0232ULL,
0x000000022d2d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001058247824ULL, 0x100fe200078e0229ULL,
0x000000ff6000720cULL, 0x000fe20003f05270ULL, 0x0000001053297824ULL, 0x000fe200078e0229ULL,
0x000000072d317812ULL, 0x000fe200078e7830ULL, 0x00000010522c7824ULL, 0x000fc400078e0233ULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x0000000151517824ULL, 0x000fe400078e0232ULL,
0x0000000830317824ULL, 0x000fe200078e0231ULL, 0x000000002928783bULL, 0x004ea20000004200ULL,
0x0000001051337824ULL, 0x000fe400078e0233ULL, 0x00000010314e7824ULL, 0x000fe200078e024eULL,
0x000000002c2c783bULL, 0x000ee80000004200ULL, 0x000000003330783bULL, 0x000f220000004200ULL,
0x00000018ff607819ULL, 0x002fc40000011624ULL, 0x00000010ff657819ULL, 0x000fe40000011624ULL,
0x00000010ff787819ULL, 0x104fe40000011628ULL, 0x000000ff28747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe40000011628ULL, 0x0000ffff288d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff287819ULL, 0x008fc4000001162cULL, 0x00000018ff687819ULL, 0x000fe40000011625ULL,
0x00000010ff8e7819ULL, 0x100fe40000011629ULL, 0x000000ff29767812ULL, 0x040fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe40000011629ULL, 0x0000ffff298c7812ULL, 0x000fe400078ec0ffULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x000000ff2c297812ULL, 0x000fe400078ec0ffULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x20000060ff847230ULL, 0x000fe20000004100ULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000028ff607230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000ffff248f7812ULL, 0x000fe200078ec0ffULL, 0x20000068ff857230ULL, 0x000fe20000004100ULL,
0x00000065ff28723eULL, 0x000fe200020006ffULL, 0x20000029ff687230ULL, 0x000fe20000004100ULL,
0x0000ffff26917812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe20000011625ULL,
0x20000028ff987230ULL, 0x000fe20000004100ULL, 0x000000ff25697812ULL, 0x040fe400078ec0ffULL,
0x0000ffff25907812ULL, 0x000fe400078ec0ffULL, 0x00000008ff297819ULL, 0x000fe4000001168fULL,
0x00000010ff887819ULL, 0x000fe4000001162aULL, 0x000000ff2a7c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff777819ULL, 0x000fe4000001162aULL, 0x0000ffff2a257812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162dULL, 0x00000008ff287819ULL, 0x000fe40000011691ULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000010ff9a7819ULL, 0x000fc4000001162eULL,
0x000000ff2e867812ULL, 0x040fe200078ec0ffULL, 0x20000029ff947230ULL, 0x000fe20000004100ULL,
0x00000018ff807819ULL, 0x000fe4000001162eULL, 0x0000ffff2ea27812ULL, 0x000fe400078ec0ffULL,
0x0000ffff27927812ULL, 0x000fe400078ec0ffULL, 0x000000ff2f2e7812ULL, 0x000fe400078ec0ffULL,
0x0000002aff2a723eULL, 0x000fc400020006ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x0000ffff2ca07812ULL, 0x000fe400078ec0ffULL, 0x00000010ff9b7819ULL, 0x100fe4000001162fULL,
0x00000018ff897819ULL, 0x000fe4000001162fULL, 0x0000ffff2fa37812ULL, 0x000fe400078ec0ffULL,
0x0000002eff2f723eULL, 0x000fe200020006ffULL, 0x2000002aff2e7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe20000011692ULL, 0x20000028ff927230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x2000002fff2f7230ULL, 0x000fe20000004100ULL,
0x00000008ff2a7819ULL, 0x000fc40000011690ULL, 0x00000008ff287819ULL, 0x000fe400000116a0ULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x000000ff24617812ULL, 0x000fe400078ec0ffULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x2000006bff997230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x2000002aff967230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x100fe2000001162bULL,
0x20000029ff917230ULL, 0x000fe20000004100ULL, 0x000000ff2b7e7812ULL, 0x000fe200078ec0ffULL,
0x20000028ff6b7230ULL, 0x000fe20000004100ULL, 0x00000018ff7d7819ULL, 0x000fc4000001162bULL,
0x0000ffff2b247812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2b7819ULL, 0x000fe4000001162cULL,
0x0000ffff2da17812ULL, 0x000fe400078ec0ffULL, 0x000000ff266f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011626ULL, 0x000000ff27727812ULL, 0x000fc400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011627ULL, 0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff287819ULL, 0x000fe400000116a1ULL, 0x00000008ff297819ULL, 0x000fe400000116a2ULL,
0x00000008ff2a7819ULL, 0x000fe400000116a3ULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x20000061ff8a7230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x2000006fff817230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000006eff6f7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000072ff827230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000071ff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fc40000011626ULL, 0x0000002bff2b723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x20000028ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x110fe40000011630ULL, 0x000000ff309d7812ULL, 0x000fe200078ec0ffULL,
0x2000002aff717230ULL, 0x000fe20000004100ULL, 0x00000018ff9c7819ULL, 0x000fc40000011630ULL,
0x0000ffff306a7812ULL, 0x000fe400078ec0ffULL, 0x00000080ff30723eULL, 0x000fe200020006ffULL,
0x2000007eff807230ULL, 0x000fe20000004100ULL, 0x00000086ff61723eULL, 0x000fe200020006ffULL,
0x20000075ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fe2000001162dULL,
0x2000007dff7e7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000002bff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff2d7f7812ULL, 0x000fe200078ec0ffULL,
0x20000029ff757230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x009000004d28783bULL, 0x000e620000000200ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000069ff8b7230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000076ff907230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x20000089ff657230ULL, 0x000fe20000004100ULL, 0x000000ff9b9b7812ULL, 0x000fe200078ec0ffULL,
0x20000030ff307230ULL, 0x000fe20000004100ULL, 0x000000ff33937812ULL, 0x000fc400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011632ULL,
0x0000007fff69723eULL, 0x000fe200020006ffULL, 0x2000007cff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff9a9a7812ULL, 0x000fe200078ec0ffULL, 0x20000073ff897230ULL, 0x000fe20000004100ULL,
0x000000ff327b7812ULL, 0x000fe200078ec0ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff797819ULL, 0x000fc40000011633ULL, 0x00000083ff7c723eULL, 0x000fe200020006ffULL,
0x20000077ff837230ULL, 0x000fe20000004100ULL, 0x0000009bff76723eULL, 0x000fe400020006ffULL,
0x000000ff87877812ULL, 0x000fe200078ec0ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000093ff9b723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x0000009aff77723eULL, 0x000fe400020006ffULL, 0x0000007aff93723eULL, 0x000fc400020006ffULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x0000009cff73723eULL, 0x000fe200020006ffULL, 0x0000005f28288231ULL, 0x082fe200003400ffULL,
0x0000007bff9a723eULL, 0x000fe200020006ffULL, 0x0000005f2a2a8231ULL, 0x000fe200003400ffULL,
0x00000079ff9c723eULL, 0x000fe200020006ffULL, 0x20000093ff797230ULL, 0x000fe20000004100ULL,
0x000000ff787b7812ULL, 0x000fe200078ec0ffULL, 0x2000009bff787230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x2000009aff7a7230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x0000000029298231ULL, 0x080fe200003400ffULL,
0x00000008ff257819ULL, 0x000fe20000011625ULL, 0x20000087ff9b7230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe20000011624ULL, 0x20000088ff9a7230ULL, 0x000fe20000004100ULL,
0x0000007bff93723eULL, 0x000fe200020006ffULL, 0x2000009cff7b7230ULL, 0x000fe20000004100ULL,
0x00000025ff87723eULL, 0x000fe200020006ffULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x00000024ff9c723eULL, 0x000fe200020006ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe20000011627ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe2000001168aULL, 0x20000087ff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011698ULL, 0x2000009cff9c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fc4000001168bULL, 0x00000010ff887819ULL, 0x000fe40000011699ULL,
0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x0000105425247816ULL, 0x000fe40000000024ULL, 0x0000105488257816ULL, 0x000fe4000000008bULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000010ff877819ULL, 0x000fe20000011684ULL, 0x000000242804723cULL, 0x000fe20000041804ULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x2000006dff977230ULL, 0x000fe20000004100ULL,
0x00000010ff947819ULL, 0x000fe20000011694ULL, 0x20000070ff957230ULL, 0x000fe20000004100ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x000000ff26267812ULL, 0x000fc400078ec0ffULL,
0x0000105487247816ULL, 0x000fe40000000094ULL, 0x0000105485257816ULL, 0x000fe40000000096ULL,
0x00000010ff277819ULL, 0x000fe40000011631ULL, 0x00000026ff84723eULL, 0x000fe400020006ffULL,
0x00000010ff267819ULL, 0x000fe20000011681ULL, 0x000000242808723cULL, 0x000fe20000041808ULL,
0x00000010ff977819ULL, 0x000fe20000011697ULL, 0x20000084ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fc40000011682ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x000000ff27247812ULL, 0x000fe400078ec0ffULL, 0x0000105497267816ULL, 0x000fe40000000026ULL,
0x0000105495277816ULL, 0x000fe40000000082ULL, 0x00000024ff84723eULL, 0x000fe400020006ffULL,
0x000000ff8e8e7812ULL, 0x000fc400078ec0ffULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x00000026280c723cULL, 0x000fe2000004180cULL, 0x009000004e24783bULL, 0x000e620000000200ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000084ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff8d7819ULL, 0x000fe2000001168dULL, 0x20000074ff8f7230ULL, 0x000fe20000004100ULL,
0x00000008ff8c7819ULL, 0x000fe2000001168cULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff927819ULL, 0x000fc40000011692ULL,
0x00000010ff827819ULL, 0x000fe4000001166eULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x000010546f6e7816ULL, 0x000fe20000000092ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00001054826f7816ULL, 0x000fe20000000091ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fc4000001166aULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x0000006e2810723cULL, 0x000fe20000041810ULL,
0x00000010ff6a7819ULL, 0x000fe40000011693ULL, 0x00000010ff857819ULL, 0x000fe4000001168eULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x000010546a6e7816ULL, 0x000fc4000000008fULL,
0x00001054856f7816ULL, 0x000fe40000000090ULL, 0x00000010ff6a7819ULL, 0x000fe20000011689ULL,
0x0000000025258231ULL, 0x082fe200003400ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x00000010ff857819ULL, 0x000fe2000001168cULL,
0x0000006e2814723cULL, 0x000fe20000041814ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x0000005f24248231ULL, 0x080fe200003400ffULL, 0x00000010ff807819ULL, 0x000fe20000011680ULL,
0x0000005f26268231ULL, 0x000fe200003400ffULL, 0x00000010ff9a7819ULL, 0x000fc4000001169aULL,
0x00000010ff9b7819ULL, 0x000fe4000001169bULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff8b7819ULL, 0x000fe4000001169cULL, 0x000000ff319f7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff9e7819ULL, 0x000fe40000011631ULL, 0x00000010ff2c7819ULL, 0x000fe40000011632ULL,
0x000010546a847816ULL, 0x000fe4000000008dULL, 0x0000105486857816ULL, 0x000fe40000000085ULL,
0x000010549a9a7816ULL, 0x000fe4000000007fULL, 0x000010549b9b7816ULL, 0x000fc40000000080ULL,
0x00001054838a7816ULL, 0x000fe2000000008aULL, 0x000000842818723cULL, 0x040fe20000041818ULL,
0x000010547e8b7816ULL, 0x000fe4000000008bULL, 0x0000ffff31317812ULL, 0x000fe400078ec0ffULL,
0x000000ff2c2c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff317819ULL, 0x000fe20000011631ULL,
0x0000009a281c723cULL, 0x000fe2000004181cULL, 0x00000010ff2d7819ULL, 0x000fc40000011633ULL,
0x0000ffff32327812ULL, 0x000fe400078ec0ffULL, 0x0000ffff33337812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2e7819ULL, 0x000fe2000001162eULL, 0x0000008a2820723cULL, 0x000fe20000041820ULL,
0x00000031ff31723eULL, 0x000fe400020006ffULL, 0x0000009fff6d723eULL, 0x000fe400020006ffULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff297819ULL, 0x000fe20000011672ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000002cff2a723eULL, 0x000fe200020006ffULL,
0x20000031ff2c7230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe40000011677ULL,
0x000000ff2d2d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff327819ULL, 0x000fe40000011632ULL,
0x00000008ff337819ULL, 0x000fc40000011633ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x000010542e297816ULL, 0x000fe20000000029ULL,
0x2000002aff2e7230ULL, 0x000fe20000004100ULL, 0x00001054002a7816ULL, 0x000fe40000000061ULL,
0x0000009dff74723eULL, 0x000fe400020006ffULL, 0x0000009eff70723eULL, 0x000fc400020006ffULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff007819ULL, 0x000fe20000011665ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff317819ULL, 0x000fe20000011671ULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x0000002dff2d723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fe400020006ffULL,
0x00000033ff33723eULL, 0x000fe200020006ffULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x0000105460287816ULL, 0x000fe2000000006bULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x00000010ff307819ULL, 0x000fe20000011630ULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00000010ff757819ULL, 0x000fc40000011675ULL, 0x0000105400317816ULL, 0x000fe20000000031ULL,
0x000000282408723cULL, 0x000fe20000041808ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff007819ULL, 0x000fe40000011687ULL, 0x0000105430307816ULL, 0x000fe40000000075ULL,
0x0000105400757816ULL, 0x000fe4000000006dULL, 0x00000010ff7a7819ULL, 0x000fc4000001167aULL,
0x00000010ff297819ULL, 0x000fe2000001162eULL, 0x000000302410723cULL, 0x000fe20000041810ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff2b7819ULL, 0x000fc4000001162fULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff837819ULL, 0x000fc40000011670ULL, 0x00000010ff2c7819ULL, 0x000fe4000001162cULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff2d7819ULL, 0x000fe4000001162dULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff327819ULL, 0x000fe40000011632ULL,
0x00000010ff007819ULL, 0x000fc4000001167bULL, 0x00000010ff337819ULL, 0x000fe40000011633ULL,
0x0000105429287816ULL, 0x000fe4000000007aULL, 0x000010547d687816ULL, 0x000fe40000000068ULL,
0x000010547c697816ULL, 0x000fe40000000069ULL, 0x00001054762b7816ULL, 0x000fe4000000002bULL,
0x0000105481747816ULL, 0x000fc40000000074ULL, 0x0000105473827816ULL, 0x000fe20000000082ULL,
0x000000682404723cULL, 0x040fe20000041804ULL, 0x0000105483837816ULL, 0x000fe4000000002cULL,
0x000010542d297816ULL, 0x000fe40000000078ULL, 0x0000105479327816ULL, 0x000fe40000000032ULL,
0x0000105400337816ULL, 0x000fe20000000033ULL, 0x0000002a240c723cULL, 0x040ff0000004180cULL,
0x000000742414723cULL, 0x040ff00000041814ULL, 0x000000822418723cULL, 0x040ff00000041818ULL,
0x00000028241c723cULL, 0x040ff0000004181cULL, 0x000000322420723cULL, 0x000fe20000041820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003a247f8cULL, 0x0002a2000c80043fULL,
0xfffffff850507812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000404f277810ULL, 0x000fe20007ffe0ffULL, 0x00f6880050ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff6b7224ULL, 0x000fe200078e0055ULL, 0x000000016c6c7812ULL, 0x000fc400078e0cffULL,
0x000000342700720cULL, 0x000fda0003f06070ULL, 0x000072d000000947ULL, 0x000fea0003800000ULL,
0x0000040067007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003a007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003a247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff447819ULL, 0x000fe20000011636ULL, 0x00000008385f7824ULL, 0x040fe200078e00ffULL,
0x0000000135257810ULL, 0x000fe20007ffe0ffULL, 0x00001000386a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff2e7819ULL, 0x000fe20000011642ULL, 0x0000001044007824ULL, 0x040fe200078e00ffULL,
0x000000022500720cULL, 0x000fe20003f46070ULL, 0x0000002044257824ULL, 0x000fe200078e024fULL,
0x000000085f607812ULL, 0x000fe200078ec0ffULL, 0x0000580040297a24ULL, 0x020fe200078e02ffULL,
0x0000f6a800617810ULL, 0x000fe20007ffe0ffULL, 0x0000001036287824ULL, 0x000fe200078e00ffULL,
0x0000000860247812ULL, 0x000fe200078e3cffULL, 0x00000080292b7824ULL, 0x000fe200078e00ffULL,
0x0000008025257810ULL, 0x000fe20007ffe0ffULL, 0x0000000161607824ULL, 0x040fe200078e0260ULL,
0x000010006a277812ULL, 0x000fe200078ec0ffULL, 0x0000000161617824ULL, 0x000fe200078e0224ULL,
0x0000002534247217ULL, 0x000fe20007800000ULL, 0x00000000600473c2ULL, 0x000ea200000e0000ULL,
0x0000001028297812ULL, 0x000fe200078ec0ffULL, 0x0000200044277824ULL, 0x000fe200078e0227ULL,
0x000000042e327810ULL, 0x000fe20007ffe0ffULL, 0x0000000124267824ULL, 0x100fe200078e0a25ULL,
0x000000603e247812ULL, 0x000fc400078ef825ULL, 0x0000b00027277810ULL, 0x000fe40007ffe0ffULL,
0x0000002026267807ULL, 0x000fe20001000000ULL, 0x0000000143257824ULL, 0x000fe200078e0224ULL,
0x000000082e307810ULL, 0x000fe20007ffe0ffULL, 0x0000001062627824ULL, 0x100fe200078e0227ULL,
0x0000002629267217ULL, 0x000fe20007800000ULL, 0x0000001063637824ULL, 0x100fe200078e0227ULL,
0x000000252b257210ULL, 0x000fe20007f1e0ffULL, 0x0000001064647824ULL, 0x100fe200078e0227ULL,
0x0000001000657812ULL, 0x000fe200078ec0ffULL, 0x0000001066667824ULL, 0x000fc400078e0227ULL,
0x0000000145277824ULL, 0x100fe400078e0224ULL, 0x0000000147287824ULL, 0x100fe400078e0224ULL,
0x0000000149247824ULL, 0x000fe200078e0224ULL, 0x000000272b277210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00005e00252c7a11ULL, 0x000fe200078038ffULL,
0x0000000126297824ULL, 0x000fe200078e0a29ULL, 0x000000282b2d7210ULL, 0x040fe40007f7e0ffULL,
0x000000242b2b7210ULL, 0x000fc40007f9e0ffULL, 0x00005f0025257a11ULL, 0x000fe200000f3c2aULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005e002d287a11ULL, 0x000fe200078438ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00005e0027267a11ULL, 0x000fe400078038ffULL,
0x000000293200720cULL, 0x000fe40003f66070ULL, 0x00005f002d2d7a11ULL, 0x000fe400010f3c24ULL,
0x0000004b2c247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005f0027277a11ULL, 0x000fc400000f3c2aULL, 0x000000292e00720cULL, 0x040fe20003f46070ULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x00005e002b2a7a11ULL, 0x040fe400078838ffULL,
0x0000000c2e2e7810ULL, 0x000fe40007ffe0ffULL, 0x0000004b28287210ULL, 0x000fe40007fbe0ffULL,
0x000000293000720cULL, 0x000fe40003f06070ULL, 0x00005f002b2b7a11ULL, 0x000fc400020f3c2cULL,
0x000000292e00720cULL, 0x000fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200028e062dULL,
0x0000004b26267210ULL, 0x080fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024627faeULL, 0x0007e2000d101c46ULL, 0x0000004b2a2a7210ULL, 0x000fe40007fbe0ffULL,
0x00000008412c7812ULL, 0x040fe200078ec0ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0xffffffe0412d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fc600028e062bULL,
0x0000000026637faeULL, 0x0007e2000d901c46ULL, 0x0000002d2c657210ULL, 0x000fc60007ffe065ULL,
0x0000000028647faeULL, 0x0007e8000c101c46ULL, 0x000000002a667faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000060247f8cULL, 0x0084e8000c80043fULL, 0x0000040061297984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280065267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x010fc60007844855ULL,
0x00f62c00652b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x008fe200078e0025ULL, 0x000000a000000947ULL, 0x000fea0003800000ULL,
0x0000001041247812ULL, 0x000fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fc600078e00ffULL,
0x0000002d2c247210ULL, 0x000fe40007ffe024ULL, 0x0000000000257305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000250000735dULL, 0x010fe40003800000ULL,
0x00f62c0024257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000804b257810ULL, 0x000fca0007ffe046ULL,
0x0000000148257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ee80000000800ULL,
0x00f2000025007984ULL, 0x0008620000000800ULL, 0x0000003c2700720bULL, 0x008fe20003f1d000ULL,
0x000101727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff24297812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000136257811ULL, 0x000fe400078ff0ffULL, 0x0000003c2700720bULL, 0x000fe40003f14000ULL,
0x000000362500720cULL, 0x000fe20003f65270ULL, 0x000101327f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x000000273c257209ULL, 0x000fe20007810000ULL,
0x00000080362bb824ULL, 0x000fe200078e024bULL, 0x0000ffff24247812ULL, 0x000fe400078e3cffULL,
0x00000002ff6e7819ULL, 0x000fe20000011642ULL, 0x000000014828b824ULL, 0x000fe200078e022bULL,
0x800000253c267221ULL, 0x000fe20000010000ULL, 0x0000002429ff7212ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL, 0x00f400252800b388ULL, 0x0007e60000000800ULL,
0x00000026002b7308ULL, 0x000f240000000800ULL, 0x0000002b3b3b7220ULL, 0x010fe20000410000ULL,
0x000100b27f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b247589ULL, 0x00872400000e0000ULL,
0x0000002404047220ULL, 0x090fe20000410000ULL, 0x0000002405057220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002420207220ULL, 0x080fe20000410000ULL, 0x0000002421217220ULL, 0x000fe20000410000ULL,
0x0000fff27f007947ULL, 0x000fea000b800000ULL, 0x00001f4c2b247589ULL, 0x0008a400000e0000ULL,
0x000000273c3c7209ULL, 0x000fe20007810000ULL, 0x0000002406067220ULL, 0x084fe20000410000ULL,
0x00000001ff2c7807ULL, 0x000fe20000000000ULL, 0x0000002407077220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x8000003c27270221ULL, 0x000fe20000010000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002700370308ULL, 0x000ea20000000800ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x000fe20000410000ULL, 0x0000000037000220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003b003b7221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x0000000838007824ULL, 0x000fe200078e00ffULL, 0xfffffff041257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000125247824ULL, 0x000fca00078e0200ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804855ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x000364000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x020fe40003800000ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804855ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6e7819ULL, 0x008fe40000011642ULL,
0x00000037ff00723eULL, 0x000fe400000010ffULL, 0x000000186e267810ULL, 0x040fe40007ffe0ffULL,
0x000000106e277810ULL, 0x000fe40007ffe0ffULL, 0x00005410002b7816ULL, 0x010fe20000000000ULL,
0x0000fd427f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b6d7589ULL, 0x0002e400000e0000ULL,
0x0000fd827f007947ULL, 0x000fea000b800000ULL, 0x00001f4c2b007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0027ULL,
0x000048a000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0001080000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0026ULL,
0x0000490000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x000107a000007944ULL, 0x01cfea0003c00000ULL,
0x00001000382e7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100036247824ULL, 0x000fe200078e00ffULL, 0x000099102c307816ULL, 0x000fe400000000ffULL,
0x000010002e2e7812ULL, 0x000fe400078e0cffULL, 0xffffe00024557812ULL, 0x000fc400078ec0ffULL,
0x0000b0003d697810ULL, 0x100fe40007ffe02eULL, 0x0000b00055557810ULL, 0x000fe40007ffe02eULL,
0x000000ff3000720cULL, 0x000fe20003f05270ULL, 0x0000001052687824ULL, 0x000fe400078e0269ULL,
0x0000001058547824ULL, 0x100fe400078e0255ULL, 0x0000001053557824ULL, 0x000fe200078e0255ULL,
0x00000000682c783bULL, 0x000f620000004200ULL, 0x0000001051697824ULL, 0x000fc600078e0269ULL,
0x000000005528783bULL, 0x016e680000004200ULL, 0x000000005424783bULL, 0x000ea80000004200ULL,
0x000000006930783bULL, 0x000f220000004200ULL, 0x00000018ff987819ULL, 0x020fe4000001162dULL,
0x00000018ff9a7819ULL, 0x000fc4000001162eULL, 0x00000010ff967819ULL, 0x102fe40000011629ULL,
0x000000ff29787812ULL, 0x040fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011629ULL,
0x0000ffff29957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe4000001162aULL,
0x000000ff2a7c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff297819ULL, 0x000fe4000001162aULL,
0x0000ffff2a927812ULL, 0x000fe400078ec0ffULL, 0x000000ff2b7d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162bULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fc400020006ffULL, 0x00000010ff7b7819ULL, 0x004fe20000011624ULL,
0x2000007dff807230ULL, 0x000fe20000004100ULL, 0x0000ffff24a97812ULL, 0x000fe200078ec0ffULL,
0x2000002aff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff26727812ULL, 0x000fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe40000011628ULL, 0x00000010ff937819ULL, 0x000fe4000001162bULL,
0x0000ffff2b907812ULL, 0x000fc400078ec0ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001162cULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000010ff977819ULL, 0x000fe40000011625ULL,
0x0000ffff25aa7812ULL, 0x000fe200078ec0ffULL, 0x20000029ff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2a7819ULL, 0x000fc400000116a9ULL,
0x00000010ff9c7819ULL, 0x100fe40000011627ULL, 0x000000ff27747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe40000011627ULL, 0x0000ffff27ac7812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fc400020006ffULL,
0x00000010ff277819ULL, 0x110fe20000011630ULL, 0x20000072ff897230ULL, 0x000fe20000004100ULL,
0x000000ff30a27812ULL, 0x040fe200078ec0ffULL, 0x20000075ff847230ULL, 0x000fe20000004100ULL,
0x00000018ffa17819ULL, 0x000fe40000011630ULL, 0x0000ffff307a7812ULL, 0x000fe400078ec0ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000098ff30723eULL, 0x000fc400020006ffULL,
0x000000ff97977812ULL, 0x000fe200078ec0ffULL, 0x2000002bff757230ULL, 0x000fe20000004100ULL,
0x00000008ff987819ULL, 0x000fe200000116aaULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x0000007bff29723eULL, 0x000fe400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x0000ffff26ab7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011624ULL, 0x2000007cff817230ULL, 0x000fe20000004100ULL,
0x000000ff2c7e7812ULL, 0x000fe400078ec0ffULL, 0x0000009aff72723eULL, 0x000fe400020006ffULL,
0x000000ff28767812ULL, 0x000fe400078ec0ffULL, 0x000000ff2d997812ULL, 0x000fe200078ec0ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000097ff2b723eULL, 0x000fe200020006ffULL,
0x20000029ff977230ULL, 0x000fe20000004100ULL, 0x00000098ff9a723eULL, 0x000fe200020006ffULL,
0x2000002aff987230ULL, 0x000fe20000004100ULL, 0x000000ff9c9c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff9d7819ULL, 0x000fe20000011628ULL, 0x2000009aff9a7230ULL, 0x000fe20000004100ULL,
0x00000008ff297819ULL, 0x000fe400000116abULL, 0x00000008ff2a7819ULL, 0x000fe400000116acULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000007eff7c723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000006cff8b7230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000099ff7e723eULL, 0x000fe200020006ffULL, 0x2000002bff997230ULL, 0x000fe20000004100ULL,
0x000000ff2fa07812ULL, 0x000fe200078ec0ffULL, 0x20000074ff887230ULL, 0x000fe20000004100ULL,
0x0000009cff9c723eULL, 0x000fe200020006ffULL, 0x20000076ff837230ULL, 0x000fe20000004100ULL,
0x0000ffff28287812ULL, 0x000fe200078ec0ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff2e9e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff9f7819ULL, 0x000fe4000001162fULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x0000002aff2a723eULL, 0x000fe400020006ffULL,
0x000000ff9d2b7812ULL, 0x000fe200078ec0ffULL, 0x2000009cff9d7230ULL, 0x000fe20000004100ULL,
0x000000a0ff6c723eULL, 0x000fe200020006ffULL, 0x20000029ff9c7230ULL, 0x000fe20000004100ULL,
0x0000009eff76723eULL, 0x000fe200020006ffULL, 0x2000002aff9e7230ULL, 0x000fe20000004100ULL,
0x0000009fff74723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff96a07812ULL, 0x000fe200078ec0ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x0000002bff9f723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff967819ULL, 0x000fc40000011628ULL, 0x009800004d28783bULL, 0x000e620000000200ULL,
0x00000018ff717819ULL, 0x000fe20000011626ULL, 0x2000009fff9f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe4000001162cULL, 0x0000ffff2c8a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff957819ULL, 0x000fe40000011695ULL, 0x00000071ff2c723eULL, 0x000fe400020006ffULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x000000ff94947812ULL, 0x000fe200078ec0ffULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x000000a1ff71723eULL, 0x000fe400020006ffULL,
0x000000ff93a17812ULL, 0x000fe400078ec0ffULL, 0x000000ff246e7812ULL, 0x000fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000ff25707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x000fc4000001162dULL, 0x00000095ff93723eULL, 0x000fe200020006ffULL,
0x20000096ff957230ULL, 0x000fe20000004100ULL, 0x0000ffff2d247812ULL, 0x000fe400078ec0ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011625ULL,
0x00000073ff2d723eULL, 0x000fe400020006ffULL, 0x000000a2ff73723eULL, 0x000fc400020006ffULL,
0x00000008ff967819ULL, 0x000fe20000011692ULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL, 0x0000006d28288231ULL, 0x08afe200003400ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x0000006d2a2a8231ULL, 0x000fe200003400ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x0000000029298231ULL, 0x080fe200003400ffULL,
0x000000a1ffa2723eULL, 0x000fe200020006ffULL, 0x20000093ffa17230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL, 0x20000094ff937230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000006eff8d7230ULL, 0x000fe20000004100ULL,
0x00000096ff94723eULL, 0x000fe200020006ffULL, 0x20000070ff917230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000006fff8c7230ULL, 0x000fe20000004100ULL,
0x00000018ffa37819ULL, 0x000fe20000011631ULL, 0x200000a2ff927230ULL, 0x000fe20000004100ULL,
0x0000008fff96723eULL, 0x000fe200020006ffULL, 0x2000008eff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001162eULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x000000a3ff6f723eULL, 0x000fe200020006ffULL, 0x20000096ff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ffa27819ULL, 0x000fe20000011624ULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x000000ff25a37812ULL, 0x000fe200078ec0ffULL, 0x2000006fff6f7230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe2000001168dULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fc40000011691ULL, 0x00000010ff977819ULL, 0x000fe40000011697ULL,
0x00000010ff967819ULL, 0x000fe40000011699ULL, 0x00000010ff9b7819ULL, 0x000fe40000011626ULL,
0x00000010ff877819ULL, 0x000fe4000001162fULL, 0x0000ffff2e867812ULL, 0x000fe400078ec0ffULL,
0x0000105497247816ULL, 0x000fc40000000024ULL, 0x0000105496257816ULL, 0x000fe40000000025ULL,
0x000000ff9b9b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff87917812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8d7819ULL, 0x000fe20000011686ULL, 0x000000242804723cULL, 0x000fe20000041804ULL,
0x0000009bff9b723eULL, 0x000fe400020006ffULL, 0x00000091ff96723eULL, 0x000fc400020006ffULL,
0x0000008dff91723eULL, 0x000fe200020006ffULL, 0x2000009bff9b7230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe4000001168bULL, 0x00000010ff247819ULL, 0x000fe20000011698ULL,
0x20000091ff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff8d7819ULL, 0x000fe2000001168cULL,
0x20000096ff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff9a7819ULL, 0x000fe4000001169aULL,
0x0000ffff2f267812ULL, 0x000fc400078ec0ffULL, 0x0000105425247816ULL, 0x000fe40000000024ULL,
0x000010548d257816ULL, 0x000fe4000000009aULL, 0x000000ff27917812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8d7819ULL, 0x000fe40000011626ULL, 0x00000010ff277819ULL, 0x000fe20000011688ULL,
0x000000242808723cULL, 0x000fe20000041808ULL, 0x00000010ff267819ULL, 0x000fc40000011689ULL,
0x00000010ff9b7819ULL, 0x000fe4000001169bULL, 0x00000010ff887819ULL, 0x000fe4000001169dULL,
0x000010549b267816ULL, 0x000fe40000000026ULL, 0x0000105488277816ULL, 0x000fe40000000027ULL,
0x00000010ff257819ULL, 0x000fe4000001162cULL, 0x00000010ff247819ULL, 0x000fc4000001162dULL,
0x00000010ff2c7819ULL, 0x000fe2000001169cULL, 0x00000026280c723cULL, 0x000fe2000004180cULL,
0x00000010ff2d7819ULL, 0x000fe4000001169eULL, 0x00001054252c7816ULL, 0x000fe4000000002cULL,
0x00001054242d7816ULL, 0x000fe4000000002dULL, 0x009800004e24783bULL, 0x000e620000000200ULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x000000a0ffa0723eULL, 0x000fc400020006ffULL,
0x00000010ff797819ULL, 0x000fe20000011631ULL, 0x20000078ff827230ULL, 0x000fe20000004100ULL,
0x00000008ff907819ULL, 0x000fe20000011690ULL, 0x200000a0ffa07230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x0000002c2810723cULL, 0x000fe20000041810ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x000000ff79897812ULL, 0x000fe200078ec0ffULL,
0x20000077ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe20000011682ULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff827819ULL, 0x000fe2000001169fULL,
0x20000091ff887230ULL, 0x000fe20000004100ULL, 0x00000010ffa07819ULL, 0x000fe400000116a0ULL,
0x00000008ff7a7819ULL, 0x000fe4000001167aULL, 0x0000105482827816ULL, 0x000fe40000000083ULL,
0x00001054a0837816ULL, 0x000fc40000000079ULL, 0x00000008ff8a7819ULL, 0x000fe4000001168aULL,
0x00000089ff91723eULL, 0x000fe400020006ffULL, 0x00000010ff797819ULL, 0x000fe20000011680ULL,
0x000000822814723cULL, 0x000fe20000041814ULL, 0x0000007aff89723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff2d7819ULL, 0x000fe20000011684ULL,
0x0000006d24248231ULL, 0x082fe200003400ffULL, 0x00000010ff2c7819ULL, 0x000fe20000011695ULL,
0x0000006d26268231ULL, 0x000fe200003400ffULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x0000000025258231ULL, 0x080fe200003400ffULL, 0x00000010ff807819ULL, 0x000fe20000011693ULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe20000011685ULL,
0x20000089ff847230ULL, 0x000fe20000004100ULL, 0x00000010ffa17819ULL, 0x000fc400000116a1ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x000000a2ffa2723eULL, 0x000fe400020006ffULL, 0x000010542d2c7816ULL, 0x000fe2000000002cULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x0000105480807816ULL, 0x000fe20000000081ULL,
0x200000a2ff877230ULL, 0x000fe20000004100ULL, 0x000010547a2d7816ULL, 0x000fe400000000a1ULL,
0x0000105492817816ULL, 0x000fe40000000079ULL, 0x000010547f947816ULL, 0x000fc40000000094ULL,
0x000010547d957816ULL, 0x000fe20000000090ULL, 0x0000002c2818723cULL, 0x040fe20000041818ULL,
0x000000ff31a47812ULL, 0x040fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff307819ULL, 0x000fe40000011630ULL, 0x00000010ff8a7819ULL, 0x000fe2000001168aULL,
0x00000080281c723cULL, 0x000fe2000004181cULL, 0x0000ffff31317812ULL, 0x000fc400078ec0ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000010ff2e7819ULL, 0x100fe40000011632ULL,
0x000000ff32a67812ULL, 0x000fe200078ec0ffULL, 0x000000942820723cULL, 0x000fe20000041820ULL,
0x00000018ffa57819ULL, 0x000fe20000011632ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff2f7819ULL, 0x000fe40000011633ULL, 0x000000ff33a87812ULL, 0x000fc400078ec0ffULL,
0x00000010ff297819ULL, 0x000fe40000011687ULL, 0x0000105475287816ULL, 0x000fe4000000008aULL,
0x0000105430297816ULL, 0x000fe40000000029ULL, 0x00000018ffa77819ULL, 0x000fe40000011633ULL,
0x00000008ff317819ULL, 0x000fe40000011631ULL, 0x0000ffff32327812ULL, 0x000fe200078ec0ffULL,
0x000000282408723cULL, 0x000fe20000041808ULL, 0x0000ffff33337812ULL, 0x000fc400078ec0ffULL,
0x00000031ff31723eULL, 0x000fe400020006ffULL, 0x000000ff2e2e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff2f2f7812ULL, 0x000fe200078ec0ffULL, 0x20000031ff317230ULL, 0x000fe20000004100ULL,
0x00000008ff327819ULL, 0x000fe40000011632ULL, 0x00000008ff337819ULL, 0x000fe40000011633ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff297819ULL, 0x000fe4000001168dULL,
0x000000a3ffa3723eULL, 0x000fe400020006ffULL, 0x000000a4ff6e723eULL, 0x000fe400020006ffULL,
0x000000a6ff78723eULL, 0x000fe200020006ffULL, 0x200000a3ff867230ULL, 0x000fe20000004100ULL,
0x000000a8ff70723eULL, 0x000fe200020006ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000000a5ff77723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x000000a7ffa7723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000002eff2e723eULL, 0x000fe200020006ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x0000002fff2f723eULL, 0x000fe200020006ffULL, 0x200000a7ff7b7230ULL, 0x000fe20000004100ULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x2000002eff2e7230ULL, 0x000fe20000004100ULL,
0x00000033ff33723eULL, 0x000fe200020006ffULL, 0x2000002fff2f7230ULL, 0x000fe20000004100ULL,
0x0000105472287816ULL, 0x000fe2000000008bULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x0000105474297816ULL, 0x000fe20000000029ULL, 0x20000033ff337230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x00000010ff2d7819ULL, 0x000fe4000001168eULL,
0x00000010ff007819ULL, 0x000fe2000001166fULL, 0x000000282410723cULL, 0x000fe20000041810ULL,
0x00000010ff317819ULL, 0x000fe40000011631ULL, 0x000010542d7d7816ULL, 0x000fe4000000007eULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff2b7819ULL, 0x000fc40000011686ULL,
0x0000105400857816ULL, 0x000fe40000000031ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff2d7819ULL, 0x000fe4000001168cULL, 0x00000010ff737819ULL, 0x000fc40000011673ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff897819ULL, 0x000fe40000011691ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000010ff297819ULL, 0x000fe4000001162eULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff2f7819ULL, 0x000fe4000001162fULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff327819ULL, 0x000fe40000011632ULL, 0x00000010ff007819ULL, 0x000fc4000001167bULL,
0x00000010ff337819ULL, 0x000fe40000011633ULL, 0x000010542b2a7816ULL, 0x000fe40000000076ULL,
0x000010548f7c7816ULL, 0x000fe4000000007cULL, 0x000010542d2b7816ULL, 0x000fe4000000006cULL,
0x0000105488887816ULL, 0x000fe40000000073ULL, 0x0000105489897816ULL, 0x000fe2000000006eULL,
0x0000007c2404723cULL, 0x000fe20000041804ULL, 0x0000105471847816ULL, 0x000fc40000000084ULL,
0x0000105429787816ULL, 0x000fe40000000078ULL, 0x000010542f797816ULL, 0x000fe40000000070ULL,
0x0000105477327816ULL, 0x000fe20000000032ULL, 0x0000002a240c723cULL, 0x000fe2000004180cULL,
0x0000105400337816ULL, 0x000fce0000000033ULL, 0x000000882414723cULL, 0x040ff00000041814ULL,
0x000000842418723cULL, 0x040ff00000041818ULL, 0x00000078241c723cULL, 0x040ff0000004181cULL,
0x000000322420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020003a247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000804f277810ULL, 0x000fe20007ffe0ffULL,
0x00f6900050ff7f8cULL, 0x0007e2000c80043fULL, 0x00000001386c7812ULL, 0x000fc400078ec0ffULL,
0x000000342700720cULL, 0x000fda0003f06070ULL, 0x00004bf000000947ULL, 0x000fea0003800000ULL,
0x0000040067007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x000024003a007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x000024003a247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000015e5e7824ULL, 0x000fe400078e025dULL, 0x00000300ff007624ULL, 0x000fe400078e00ffULL,
0x0000580040287a24ULL, 0x000fe200078e02ffULL, 0x000000015e247812ULL, 0x000fe200078ec0ffULL,
0xffffffffff407424ULL, 0x000fe200078e00ffULL, 0xffffffff00007811ULL, 0x000fe400078e08ffULL,
0x000000012400780cULL, 0x000fc80003f05070ULL, 0x0000000100337807ULL, 0x000fca0004000000ULL,
0x000000015e007824ULL, 0x000fe200078e0233ULL, 0x00000001ff447819ULL, 0x000fc80000011636ULL,
0x000000030000720cULL, 0x000fe20003f06070ULL, 0x0000002044277824ULL, 0x000fca00078e024fULL,
0x000000c027277810ULL, 0x000fc80007ffe0ffULL, 0x0000002734007217ULL, 0x000fc60007800000ULL,
0x0000003339248210ULL, 0x000fe20007ffe05eULL, 0x00000004ff258424ULL, 0x000fe400078e00ffULL,
0x0000000100267824ULL, 0x100fe200078e0a27ULL, 0x000000603e007812ULL, 0x000fe200078ef827ULL,
0x0000600024248625ULL, 0x000fe200078e0025ULL, 0x0000000135297810ULL, 0x000fc60007ffe0ffULL,
0x0000008028287824ULL, 0x000fe200078e00ffULL, 0x0000000624408981ULL, 0x000562000c1e1900ULL,
0x000000022900720cULL, 0x000fe20003f46070ULL, 0x0000001036297824ULL, 0x000fe200078e00ffULL,
0xfffffff0412a7812ULL, 0x000fe200078ec0ffULL, 0x0000000147277824ULL, 0x100fe200078e0200ULL,
0x000000085f567812ULL, 0x000fe400078ec0ffULL, 0x0000001029297812ULL, 0x000fe200078ec0ffULL,
0x000000002a0573c2ULL, 0x000ee200000e0000ULL, 0x0000002026267807ULL, 0x000fe20001000000ULL,
0x0000000143247824ULL, 0x104fe200078e0200ULL, 0x0000000856307812ULL, 0x000fe200078e3cffULL,
0x0000000145257824ULL, 0x100fe200078e0200ULL, 0x0000002629267217ULL, 0x000fe20007800000ULL,
0x0000000149007824ULL, 0x000fe200078e0200ULL, 0x0000002428247210ULL, 0x040fe20007f1e0ffULL,
0x00000000300473c2ULL, 0x000ea200000e0000ULL, 0x00000025282b7210ULL, 0x000fe20007f5e0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a29ULL, 0x0000002728277210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005e0024327a11ULL, 0x000fe200078038ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x0000000028007210ULL, 0x000fc40007f9e0ffULL,
0x00005f00242d7a11ULL, 0x000fe200000f3c2dULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005e002b2c7a11ULL, 0x000fe200078038ffULL, 0x000000ffff257224ULL, 0x000fe200020e06ffULL,
0x00000003ff2f7819ULL, 0x000fe40000011642ULL, 0x00005e0027287a11ULL, 0x000fe200078438ffULL,
0x0000f6a805057890ULL, 0x008fe2000fffe03fULL, 0x00005f002b2b7a11ULL, 0x000fe400000f3c2eULL,
0x000000262f00720cULL, 0x000fc40003f06070ULL, 0x00005f0027297a11ULL, 0x000fe400010f3c24ULL,
0x00005e00002a7a11ULL, 0x000fe200078638ffULL, 0x0000000405047290ULL, 0x004fe2000fffe03fULL,
0x0000004b32247210ULL, 0x000fe40007f5e0ffULL, 0x000000042f317810ULL, 0x040fe40007ffe0ffULL,
0x000000082f277810ULL, 0x040fe40007ffe0ffULL, 0x0000000c2f2f7810ULL, 0x000fc40007ffe0ffULL,
0x00005f0000007a11ULL, 0x000fe200018f3c25ULL, 0x000000ffff257224ULL, 0x000fe200010e062dULL,
0x000000263100720cULL, 0x080fe40003f86070ULL, 0x000000262700720cULL, 0x080fe40003f66070ULL,
0x000000262f00720cULL, 0x000fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024597faeULL, 0x0005e2000c101c46ULL, 0x0000004b2c267210ULL, 0x080fe40007fbe0ffULL,
0x0000004b28287210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200028e062bULL,
0x0000004b2a2a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fc600000e0629ULL,
0x00000000265a7faeULL, 0x0005e2000e101c46ULL, 0x000000ffff2b7224ULL, 0x000fc600028e0600ULL,
0x00000000285b7faeULL, 0x0005e8000d901c46ULL, 0x000000002a5c7faeULL, 0x0005e8000d101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000030307f8cULL, 0x000ee8000c800405ULL, 0x0000040556007984ULL, 0x0008620008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480057247f8cULL, 0x004fe2000c80043fULL, 0x8000000000ff7812ULL, 0x002fc6000784486bULL,
0x00f64c0057277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe041267812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff007424ULL, 0x000fe200078e00ffULL, 0x0000001041277812ULL, 0x040fe400078ec0ffULL,
0x0000000841287812ULL, 0x000fc800078ec0ffULL, 0x0000002628267210ULL, 0x000fe40007ffe027ULL,
0x0000000000277305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000270000735dULL, 0x004fe40003800000ULL, 0x00f64c0026277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001004b257810ULL, 0x000fca0007ffe046ULL, 0x0000000148257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000e680000000800ULL, 0x00f2000025007984ULL, 0x0005220000000800ULL,
0x0000003c2700720bULL, 0x002fe20003f1d000ULL, 0x0000dcc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x004fc800000e0100ULL, 0x0000ffff24297812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000236257811ULL, 0x000fe400078ff0ffULL,
0x0000003c2700720bULL, 0x000fe40003f14000ULL, 0x000000362500720cULL, 0x000fe20003f65270ULL,
0x0000dc827f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000273c257209ULL, 0x000fe20007810000ULL, 0x00000080362bb824ULL, 0x000fe200078e024bULL,
0x0000ffff24247812ULL, 0x000fe400078e3cffULL, 0x00000002ff6e7819ULL, 0x000fe20000011642ULL,
0x000000014828b824ULL, 0x000fe200078e022bULL, 0x800000253c267221ULL, 0x000fe20000010000ULL,
0x0000002429ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL,
0x00f400252800b388ULL, 0x0003e60000000800ULL, 0x00000026002b7308ULL, 0x000ea40000000800ULL,
0x0000002b3b3b7220ULL, 0x004fe20000410000ULL, 0x0000dc027f007947ULL, 0x000fea000b800000ULL,
0x00001f6e2b247589ULL, 0x0022a400000e0000ULL, 0x0000002404047220ULL, 0x084fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x000fe20000410000ULL, 0x0000db427f007947ULL, 0x000fea000b800000ULL,
0x00001f4c2b247589ULL, 0x00046400000e0000ULL, 0x000000273c3c7209ULL, 0x000fe20007810000ULL,
0x0000002406067220ULL, 0x082fe20000410000ULL, 0x00000001ff2c7807ULL, 0x000fe20000000000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x8000003c27270221ULL, 0x000fe20000010000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002700370308ULL, 0x000e620000000800ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x0000002422227220ULL, 0x080fe20000410000ULL, 0x0000002423237220ULL, 0x000fe20000410000ULL,
0x0000000037000220ULL, 0x012fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0000003b003b7221ULL, 0x010fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x000000085f257812ULL, 0x000fe400078ec0ffULL,
0xfffffff041007812ULL, 0x000fca00078ec0ffULL, 0x0000000100257824ULL, 0x000fca00078e0225ULL,
0x00f6ac0025007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000324000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x010fe40003800000ULL,
0x00f6ac0025247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff6e7819ULL, 0x000fe40000011642ULL,
0x00000037ff00723eULL, 0x000fe400000010ffULL, 0x000000186e267810ULL, 0x040fe40007ffe0ffULL,
0x000000106e277810ULL, 0x000fe40007ffe0ffULL, 0x00005410002b7816ULL, 0x004fe20000000000ULL,
0x0000d8a27f007947ULL, 0x000fea000b800000ULL, 0x00001f6e2b577589ULL, 0x0002a400000e0000ULL,
0x0000d8e27f007947ULL, 0x000fea000b800000ULL, 0x00001f4c2b007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0027ULL,
0x00006f8000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000e12000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e0026ULL,
0x00006fe000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000e0c000007944ULL, 0x03cfea0003c00000ULL,
0x0000100036247824ULL, 0x000fe200078e00ffULL, 0x000010006a6a7812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000099102c2c7816ULL, 0x000fe400000000ffULL,
0xffffe00024257812ULL, 0x000fe400078ec0ffULL, 0x0000b0003d2d7810ULL, 0x000fc40007ffe06aULL,
0x0000b00025287810ULL, 0x000fe40007ffe06aULL, 0x000000ff2c00720cULL, 0x000fc60003f05270ULL,
0x0000001058247824ULL, 0x100fe400078e0228ULL, 0x0000001053287824ULL, 0x000fe400078e0228ULL,
0x0000001052587824ULL, 0x100fe400078e022dULL, 0x000000002424783bULL, 0x000f220000004200ULL,
0x00000010512d7824ULL, 0x000fc600078e022dULL, 0x000000002828783bULL, 0x016e680000004200ULL,
0x000000005858783bULL, 0x000ea80000004200ULL, 0x000000002d2c783bULL, 0x000f220000004200ULL,
0x00000010ff8f7819ULL, 0x000fe40000011624ULL, 0x000000ff24737812ULL, 0x000fc400078ec0ffULL,
0x00000018ff727819ULL, 0x000fe40000011624ULL, 0x0000ffff247c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff797819ULL, 0x100fe40000011625ULL, 0x000000ff25757812ULL, 0x040fe400078ec0ffULL,
0x00000018ff747819ULL, 0x000fe40000011625ULL, 0x0000ffff258e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff247819ULL, 0x102fe40000011628ULL, 0x000000ff287f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011628ULL, 0x0000ffff287b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff257819ULL, 0x000fe40000011629ULL, 0x000000ff29807812ULL, 0x000fc400078ec0ffULL,
0x00000018ff287819ULL, 0x000fe40000011629ULL, 0x0000ffff297a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff297819ULL, 0x000fe4000001162aULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x20000080ff867230ULL, 0x000fe20000004100ULL, 0x0000ffff589b7812ULL, 0x004fe200078ec0ffULL,
0x20000028ff847230ULL, 0x000fe20000004100ULL, 0x0000ffff599c7812ULL, 0x000fe200078ec0ffULL,
0x20000029ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fc4000001169bULL,
0x00000008ff297819ULL, 0x000fe4000001169cULL, 0x00000010ff8b7819ULL, 0x100fe40000011626ULL,
0x000000ff26777812ULL, 0x040fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe40000011626ULL,
0x0000ffff26897812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fc40000011627ULL,
0x000000ff277d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe40000011627ULL,
0x0000ffff278a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff267819ULL, 0x000fe4000001162aULL,
0x000000ff2a817812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2a707812ULL, 0x000fc400078ec0ffULL,
0x00000010ff277819ULL, 0x100fe4000001162bULL, 0x000000ff2b827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162bULL, 0x0000ffff2b717812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x00000018ff2b7819ULL, 0x000fe20000011658ULL, 0x20000072ff937230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fe200020006ffULL, 0x20000074ff967230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x0000ffff5a9d7812ULL, 0x000fe200078ec0ffULL,
0x20000028ff727230ULL, 0x000fe20000004100ULL, 0x0000ffff5b9e7812ULL, 0x000fe200078ec0ffULL,
0x20000029ff747230ULL, 0x000fe20000004100ULL, 0x00000018ff517819ULL, 0x000fc40000011659ULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000008ff287819ULL, 0x000fe4000001169dULL,
0x00000008ff297819ULL, 0x000fe4000001169eULL, 0x00000051ff53723eULL, 0x000fe200020006ffULL,
0x2000002bff517230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fc400020006ffULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000073ff917230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000075ff947230ULL, 0x000fe20000004100ULL, 0x00000082ff2b723eULL, 0x000fe200020006ffULL,
0x2000007fff857230ULL, 0x000fe20000004100ULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000081ff827230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x2000002bff817230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fe200020006ffULL,
0x2000002aff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff59527812ULL, 0x000fe200078ec0ffULL,
0x20000028ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fe20000011658ULL,
0x20000029ff737230ULL, 0x000fe20000004100ULL, 0x000000ff58327812ULL, 0x000fe200078ec0ffULL,
0x00a000004d28783bULL, 0x000e620000000200ULL, 0x00000010ff977819ULL, 0x000fc4000001165aULL,
0x000000ff5a567812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe4000001165aULL,
0x000000ff5b5a7812ULL, 0x000fe400078ec0ffULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x000000ff2d6a7812ULL, 0x010fe400078ec0ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000052ff6f7230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000053ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fe20000011659ULL,
0x20000056ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff987819ULL, 0x100fe2000001165bULL,
0x2000005aff567230ULL, 0x000fe20000004100ULL, 0x00000018ff597819ULL, 0x000fc4000001165bULL,
0x000000ff2c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2f837812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001162cULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x000000ff2e6c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001162eULL, 0x2000007dff907230ULL, 0x000fe20000004100ULL,
0x0000005cff5a723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x0000005728288231ULL, 0x082fe200003400ffULL, 0x000000ff95957812ULL, 0x000fe200078ec0ffULL,
0x000000572a2a8231ULL, 0x000fe200003400ffULL, 0x0000005bff5c723eULL, 0x000fe200020006ffULL,
0x2000006aff5b7230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x0000000029298231ULL, 0x080fe200003400ffULL, 0x0000006cff6a723eULL, 0x000fe200020006ffULL,
0x000000002b2b8231ULL, 0x000fe200003400ffULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000ffff2c9f7812ULL, 0x000fe200078ec0ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000006bff6c723eULL, 0x000fe200020006ffULL,
0x20000083ff6b7230ULL, 0x000fe20000004100ULL, 0x00000095ff7d723eULL, 0x000fe200020006ffULL,
0x2000007eff837230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x000000ff79957812ULL, 0x000fe200078ec0ffULL,
0x20000078ff887230ULL, 0x000fe20000004100ULL, 0x00000092ff7e723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff97977812ULL, 0x000fc400078ec0ffULL,
0x00000008ff927819ULL, 0x000fe2000001169fULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff997819ULL, 0x000fe4000001162cULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000095ff95723eULL, 0x000fe400020006ffULL, 0x00000008ff8a7819ULL, 0x000fe2000001168aULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fc400020006ffULL,
0x00000097ff78723eULL, 0x000fe200020006ffULL, 0x20000077ff8d7230ULL, 0x000fe20000004100ULL,
0x00000092ff97723eULL, 0x000fe200020006ffULL, 0x20000076ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff7c7819ULL, 0x000fe2000001167cULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x000000ff98987812ULL, 0x000fe400078ec0ffULL, 0x000000ff99997812ULL, 0x000fe400078ec0ffULL,
0x0000008aff8a723eULL, 0x000fc400020006ffULL, 0x0000007cff92723eULL, 0x000fe200020006ffULL,
0x20000097ff7c7230ULL, 0x000fe20000004100ULL, 0x00000098ff76723eULL, 0x000fe200020006ffULL,
0x2000008aff977230ULL, 0x000fe20000004100ULL, 0x00000099ff77723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168eULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x000000ff24987812ULL, 0x000fe200078ec0ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x000000ff25997812ULL, 0x000fc400078ec0ffULL,
0x00000010ff247819ULL, 0x000fe40000011691ULL, 0x00000010ff257819ULL, 0x000fe40000011694ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8a7819ULL, 0x000fe40000011695ULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x000010548f247816ULL, 0x000fe40000000024ULL,
0x000010548a257816ULL, 0x000fe20000000025ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x00000008ff7a7819ULL, 0x000fe4000001167aULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x000000242804723cULL, 0x000fe20000041804ULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff897819ULL, 0x000fe20000011689ULL,
0x2000007bff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe2000001168eULL,
0x2000007aff8e7230ULL, 0x000fe20000004100ULL, 0x000000ff267a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff277b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff247819ULL, 0x000fe40000011692ULL,
0x00000010ff267819ULL, 0x000fe4000001168dULL, 0x00000010ff277819ULL, 0x000fe40000011690ULL,
0x00000010ff8b7819ULL, 0x000fc4000001168bULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000105493247816ULL, 0x000fe40000000024ULL,
0x0000105496257816ULL, 0x000fe20000000025ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000010548b267816ULL, 0x000fe40000000026ULL, 0x000010548c277816ULL, 0x000fc40000000027ULL,
0x00000098ff98723eULL, 0x000fe200020006ffULL, 0x000000242808723cULL, 0x040fe20000041808ULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x0000007aff8d723eULL, 0x000fe200020006ffULL,
0x20000098ff987230ULL, 0x000fe20000004100ULL, 0x0000007bff8f723eULL, 0x000fe200020006ffULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x00000026280c723cULL, 0x000fe2000004180cULL, 0x00000010ff887819ULL, 0x000fe20000011688ULL,
0x00a000004e24783bULL, 0x000e620000000200ULL, 0x00000010ff7a7819ULL, 0x000fe20000011689ULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe20000011697ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00001054877a7816ULL, 0x000fc4000000007aULL,
0x00001054887b7816ULL, 0x000fe4000000007bULL, 0x00000008ff877819ULL, 0x000fe40000011670ULL,
0x00000008ff887819ULL, 0x000fe40000011671ULL, 0x00000010ff707819ULL, 0x000fe20000011685ULL,
0x0000007a2810723cULL, 0x000fe20000041810ULL, 0x00000010ff717819ULL, 0x000fe40000011698ULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000010ff997819ULL, 0x000fe40000011699ULL,
0x0000105471707816ULL, 0x000fe40000000070ULL, 0x0000105499717816ULL, 0x000fe40000000086ULL,
0x00000032ff6e723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x000000702814723cULL, 0x000fe20000041814ULL,
0x00000010ff837819ULL, 0x000fe20000011683ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168aULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fc4000001168fULL, 0x00001054838a7816ULL, 0x000fe2000000008aULL,
0x0000005724248231ULL, 0x082fe200003400ffULL, 0x0000105470837816ULL, 0x000fe20000000081ULL,
0x0000005726268231ULL, 0x000fe200003400ffULL, 0x00000010ff707819ULL, 0x000fe2000001166eULL,
0x0000000025258231ULL, 0x080fe200003400ffULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x00000010ff8b7819ULL, 0x000fe4000001168eULL,
0x00000010ff827819ULL, 0x000fc40000011682ULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff6e7819ULL, 0x000fe4000001167fULL, 0x00000010ff817819ULL, 0x000fe40000011688ULL,
0x00001054848b7816ULL, 0x000fc4000000008bULL, 0x000010548d827816ULL, 0x000fe40000000082ULL,
0x0000105480807816ULL, 0x000fe40000000087ULL, 0x000010546e817816ULL, 0x000fe20000000081ULL,
0x0000008a2818723cULL, 0x000fe20000041818ULL, 0x00000010ff9a7819ULL, 0x100fe4000001162dULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000018ff5d7819ULL, 0x000fc4000001162dULL,
0x00000010ff2c7819ULL, 0x000fe2000001162eULL, 0x00000082281c723cULL, 0x040fe2000004181cULL,
0x000000ff9a9a7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000ffff2d2d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x000000802820723cULL, 0x000fe20000041820ULL,
0x00000010ff727819ULL, 0x000fc40000011672ULL, 0x0000ffff2e327812ULL, 0x000fe400078ec0ffULL,
0x0000009aff9a723eULL, 0x000fe400020006ffULL, 0x00000010ff297819ULL, 0x000fe40000011674ULL,
0x000000ff2c2c7812ULL, 0x000fe200078ec0ffULL, 0x2000009aff797230ULL, 0x000fe20000004100ULL,
0x00000010ff2e7819ULL, 0x100fe4000001162fULL, 0x00000018ff6d7819ULL, 0x000fc4000001162fULL,
0x00000008ff2d7819ULL, 0x000fe4000001162dULL, 0x0000105451287816ULL, 0x000fe40000000072ULL,
0x0000105452297816ULL, 0x000fe40000000029ULL, 0x0000ffff2f2f7812ULL, 0x000fe400078ec0ffULL,
0x0000002cff2c723eULL, 0x000fe400020006ffULL, 0x00000010ff007819ULL, 0x000fe20000011659ULL,
0x000000282408723cULL, 0x000fe20000041808ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x0000002dff2d723eULL, 0x000fc400020006ffULL,
0x00000008ff327819ULL, 0x000fe20000011632ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe20000011673ULL, 0x2000002dff2d7230ULL, 0x000fe20000004100ULL,
0x000000ff2e2e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2f7819ULL, 0x000fe4000001162fULL,
0x00000032ff32723eULL, 0x000fe400020006ffULL, 0x0000105400597816ULL, 0x000fc40000000059ULL,
0x00000010ff297819ULL, 0x000fe2000001165cULL, 0x20000032ff327230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000002eff2e723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe20000011679ULL,
0x2000002eff2e7230ULL, 0x000fe20000004100ULL, 0x0000002fff2f723eULL, 0x000fc400020006ffULL,
0x00001054297c7816ULL, 0x000fe4000000007cULL, 0x00001054005b7816ULL, 0x000fe2000000005bULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff297819ULL, 0x000fe4000001162cULL, 0x00000010ff007819ULL, 0x000fe4000001165dULL,
0x00000010ff2d7819ULL, 0x000fc4000001162dULL, 0x00000010ff7a7819ULL, 0x000fe4000001167dULL,
0x00001054296a7816ULL, 0x000fe4000000006aULL, 0x00000010ff717819ULL, 0x000fe4000001166fULL,
0x00001054007d7816ULL, 0x000fe4000000002dULL, 0x00000010ff297819ULL, 0x000fe4000001166cULL,
0x00000010ff327819ULL, 0x000fc40000011632ULL, 0x00000010ff6f7819ULL, 0x000fe2000001167eULL,
0x0000007c2418723cULL, 0x000fe20000041818ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff2b7819ULL, 0x000fe40000011656ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff587819ULL, 0x000fc40000011658ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff007819ULL, 0x000fc4000001166dULL,
0x00000010ff2f7819ULL, 0x000fe4000001162fULL, 0x0000105429287816ULL, 0x000fe40000000032ULL,
0x000010546f707816ULL, 0x000fe40000000070ULL, 0x000010547a717816ULL, 0x000fe40000000071ULL,
0x00001054782a7816ULL, 0x000fe40000000053ULL, 0x00001054762b7816ULL, 0x000fc4000000002bULL,
0x0000105458587816ULL, 0x000fe20000000075ULL, 0x000000702404723cULL, 0x000fe20000041804ULL,
0x00001054775a7816ULL, 0x000fe4000000005aULL, 0x000010542e6b7816ULL, 0x000fe4000000006bULL,
0x0000105400297816ULL, 0x000fc6000000002fULL, 0x0000002a240c723cULL, 0x040ff0000004180cULL,
0x000000582410723cULL, 0x040ff00000041810ULL, 0x0000005a2414723cULL, 0x040ff00000041814ULL,
0x0000006a241c723cULL, 0x040ff0000004181cULL, 0x000000282420723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003a247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c04f4f7810ULL, 0x000fe20007ffe0ffULL, 0x00f6980050ff7f8cULL, 0x0009e2000c80043fULL,
0x000000015e567824ULL, 0x000fe200078e0233ULL, 0x00000001386c7812ULL, 0x000fe200078e0cffULL,
0x000000ffff6b7224ULL, 0x008fe200078e0031ULL, 0x000000344f00720cULL, 0x000fda0003f06070ULL,
0x0000250000000947ULL, 0x000fea0003800000ULL, 0x0000040067007984ULL, 0x010ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x000024003a007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x000024003a247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000f6a8442f7811ULL, 0x000fe200078e20ffULL,
0x0000580040267a24ULL, 0x020fe200078e02ffULL, 0x0000030035257a10ULL, 0x000fe20007ffe0ffULL,
0x00000000600473c2ULL, 0x0004e200000e0000ULL, 0x00000001ff447819ULL, 0x000fe20000011636ULL,
0x0000008026287824ULL, 0x000fe200078e00ffULL, 0x00000003ff2d7819ULL, 0x000fe40000011642ULL,
0x000000085f6a7812ULL, 0x000fe200078ec0ffULL, 0x0000000825277824ULL, 0x040fe200078e0244ULL,
0x0000000125257810ULL, 0x000fc60007ffe0ffULL, 0x0000002027277824ULL, 0x000fe200078e00ffULL,
0x000000022500720cULL, 0x000fe20003f06070ULL, 0x0000001036257824ULL, 0x000fe400078e00ffULL,
0x000000012f6a7824ULL, 0x000fe200078e026aULL, 0x000000603e007812ULL, 0x000fe400078ef827ULL,
0x0000002734247217ULL, 0x000fc60007800000ULL, 0x0000000143437824ULL, 0x100fe400078e0200ULL,
0x0000000124247824ULL, 0x000fe200078e0a27ULL, 0x0000001025277812ULL, 0x000fe200078ec0ffULL,
0x0000000145457824ULL, 0x100fe200078e0200ULL, 0x0000004328437210ULL, 0x000fe20007f5e0ffULL,
0x0000000147477824ULL, 0x100fe200078e0200ULL, 0x0000002024247807ULL, 0x000fe20000000000ULL,
0x0000000149007824ULL, 0x000fe200078e0200ULL, 0x0000004528457210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x0000002427247217ULL, 0x000fc40007800000ULL,
0x00005e00432c7a11ULL, 0x040fe200078038ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x0000004728477210ULL, 0x040fe40007f5e0ffULL, 0x0000000028297210ULL, 0x000fe20007f9e0ffULL,
0x0000000124007824ULL, 0x000fe200078e0a27ULL, 0x00005f0043257a11ULL, 0x000fe200000f3c26ULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005e0045267a11ULL, 0x000fe400078038ffULL,
0x00005e0047287a11ULL, 0x000fc400078438ffULL, 0x000000042d497810ULL, 0x000fe40007ffe0ffULL,
0x00005f0045277a11ULL, 0x000fe400000f3c2aULL, 0x0000004b26267210ULL, 0x000fe40007fbe0ffULL,
0x000000082d437810ULL, 0x000fe40007ffe0ffULL, 0x00005f00472b7a11ULL, 0x000fe200010f3c24ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x000000002d00720cULL, 0x000fc40003f66070ULL,
0x0000004b2c247210ULL, 0x080fe20007fde0ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x0000000c2d2d7810ULL, 0x000fe40007ffe0ffULL, 0x000000004900720cULL, 0x080fe20003f46070ULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x00005e00292a7a11ULL, 0x000fe400078838ffULL,
0x000000004300720cULL, 0x080fe40003f06070ULL, 0x000000002d00720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024627faeULL, 0x0009e2000d901c46ULL,
0x0000004b28287210ULL, 0x000fc40007fde0ffULL, 0x00005f0029007a11ULL, 0x000fe400020f3c2cULL,
0x0000004b2a2a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff297224ULL, 0x000fe200030e062bULL,
0x0000000026637faeULL, 0x0009e6000d101c46ULL, 0x000000ffff2b7224ULL, 0x000fe200020e0600ULL,
0x0000000028647faeULL, 0x0009e8000c101c46ULL, 0x000000002a667faeULL, 0x0009e8000e901c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x008fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000006a6a7f8cULL, 0x000ea8000c80043fULL, 0x0000040061617984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6680065247f8cULL, 0x010fe2000c80043fULL, 0x8000000061ff7812ULL, 0x008fc60007844831ULL,
0x00f66c0065277984ULL, 0x000ee40000000800ULL, 0x8000000027ff7812ULL, 0x008fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000260000735dULL, 0x010fe20003800000ULL, 0x00f66c0065277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x008fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001804b257810ULL, 0x000fca0007ffe046ULL, 0x0000000148257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000ee80000000800ULL, 0x00f2000025007984ULL, 0x0008620000000800ULL,
0x0000003c2700720bULL, 0x008fe20003f1d000ULL, 0x0000b9427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff24297812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff267424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000336257811ULL, 0x000fe400078ff0ffULL,
0x0000003c2700720bULL, 0x000fe40003f14000ULL, 0x000000362500720cULL, 0x000fe20003f65270ULL,
0x0000b9027f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x000000273c287209ULL, 0x000fe20007810000ULL, 0x00000080364bb824ULL, 0x000fe200078e024bULL,
0x0000ffff24247812ULL, 0x000fe400078e3cffULL, 0x00000002ff6e7819ULL, 0x000fe20000011642ULL,
0x00000001484bb824ULL, 0x000fe200078e024bULL, 0x800000283c257221ULL, 0x000fe20000010000ULL,
0x0000002429ff7212ULL, 0x000fc6000780c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00f400284b00b388ULL, 0x0007e60000000800ULL, 0x00000025002b7308ULL, 0x000f240000000800ULL,
0x0000002b3b3b7220ULL, 0x010fe20000410000ULL, 0x0000b8827f007947ULL, 0x000fea000b800000ULL,
0x00001f6e2b247589ULL, 0x00872400000e0000ULL, 0x0000002404047220ULL, 0x090fe20000410000ULL,
0x0000002405057220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002420207220ULL, 0x080fe20000410000ULL,
0x0000002421217220ULL, 0x000fe20000410000ULL, 0x0000b7c27f007947ULL, 0x000fea000b800000ULL,
0x00001f4c2b247589ULL, 0x0008e400000e0000ULL, 0x8000002827270221ULL, 0x100fe20000010000ULL,
0x00000001ff267807ULL, 0x000fe20000000000ULL, 0x0000002406067220ULL, 0x088fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x0000002700370308ULL, 0x000ee20000000800ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x0000002423237220ULL, 0x000fe20000410000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e0028ULL,
0x0000000037000220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003b003b7221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x0000000838007824ULL, 0x000fe200078e00ffULL,
0xfffffff041257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000125247824ULL, 0x000fca00078e0200ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x008fe40003800000ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff6e7819ULL, 0x000fe40000011642ULL, 0x00000037ff00723eULL, 0x000fe400000010ffULL,
0x000000186e277810ULL, 0x040fe40007ffe0ffULL, 0x000000106e287810ULL, 0x000fe40007ffe0ffULL,
0x00005410002b7816ULL, 0x010fe20000000000ULL, 0x0000b5127f007947ULL, 0x000fea000b800000ULL,
0x00001f6e2b297589ULL, 0x0002e400000e0000ULL, 0x0000b5527f007947ULL, 0x000fea000b800000ULL,
0x00001f4c2b007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6e7224ULL, 0x002fe200078e0028ULL, 0x0000955000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000bb5000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff6e7224ULL, 0x002fe200078e0027ULL, 0x000095b000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000baf000007944ULL, 0x01cfea0003c00000ULL, 0x0000991026247816ULL, 0x000fe200000000ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006848783bULL, 0x000f640000004200ULL,
0x000000ff2400720cULL, 0x000fe40003f05270ULL, 0x000000005458783bULL, 0x000f280000004200ULL,
0x000000006924783bULL, 0x0006a80000004200ULL, 0x00000000552c783bULL, 0x000e620000004200ULL,
0x00000010ff7b7819ULL, 0x020fc40000011648ULL, 0x000000ff486f7812ULL, 0x042fe400078ec0ffULL,
0x00000018ff697819ULL, 0x008fe40000011648ULL, 0x0000ffff48867812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x100fe40000011649ULL, 0x000000ff49717812ULL, 0x000fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fc40000011649ULL, 0x0000ffff49877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7e7819ULL, 0x100fe4000001164aULL, 0x000000ff4a737812ULL, 0x040fe400078ec0ffULL,
0x00000018ff497819ULL, 0x000fe4000001164aULL, 0x0000ffff4a637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fc4000001164bULL, 0x000000ff4b747812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b4c7812ULL, 0x010fe400078ec0ffULL,
0x00000018ff317819ULL, 0x000fe4000001165aULL, 0x00000010ff4f7819ULL, 0x004fe40000011624ULL,
0x000000ff24757812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011624ULL,
0x0000ffff24537812ULL, 0x000fe400078ec0ffULL, 0x00000018ff287819ULL, 0x100fe40000011658ULL,
0x00000018ff247819ULL, 0x000fe40000011625ULL, 0x00000010ff517819ULL, 0x000fe40000011658ULL,
0x00000031ff31723eULL, 0x000fc400020006ffULL, 0x000000ff2c477812ULL, 0x000fe400078ec0ffULL,
0x00000028ff65723eULL, 0x000fe200020006ffULL, 0x20000031ff5f7230ULL, 0x000fe20000004100ULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000010ff527819ULL, 0x000fe20000011625ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000000ff25767812ULL, 0x040fe200078ec0ffULL,
0x20000024ff317230ULL, 0x000fe20000004100ULL, 0x0000ffff25287812ULL, 0x000fc400078ec0ffULL,
0x00000018ff257819ULL, 0x000fe40000011626ULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x000000ff582a7812ULL, 0x000fe400078ec0ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000010ff777819ULL, 0x100fe4000001162eULL, 0x000000ff2e577812ULL, 0x000fe200078ec0ffULL,
0x20000047ff5c7230ULL, 0x000fe20000004100ULL, 0x00000018ff567819ULL, 0x000fc4000001162eULL,
0x0000ffff2e847812ULL, 0x000fe400078ec0ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000051ff24723eULL, 0x000fe400020006ffULL, 0x00000010ff6a7819ULL, 0x000fe20000011659ULL,
0x20000025ff517230ULL, 0x000fe20000004100ULL, 0x000000ff5a327812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x000fc4000001162cULL, 0x00000018ff467819ULL, 0x000fe4000001162cULL,
0x0000ffff2c827812ULL, 0x000fe400078ec0ffULL, 0x0000002aff2e723eULL, 0x000fe400020006ffULL,
0x0000ffff587d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff597f7812ULL, 0x000fe200078ec0ffULL,
0x2000002eff687230ULL, 0x000fe20000004100ULL, 0x00000010ff2a7819ULL, 0x000fc40000011626ULL,
0x000000ff26797812ULL, 0x040fe400078ec0ffULL, 0x0000ffff262c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff267819ULL, 0x000fe40000011627ULL, 0x00000069ff47723eULL, 0x000fe200020006ffULL,
0x20000024ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe4000001165aULL,
0x00000032ff32723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x000000ff6a6a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fe2000001165bULL,
0x20000032ff617230ULL, 0x000fe20000004100ULL, 0x00000018ff547819ULL, 0x000fe4000001162dULL,
0x00000008ff247819ULL, 0x000fe4000001167dULL, 0x00000008ff257819ULL, 0x000fe4000001167fULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x000000ff592b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff2d557812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff307819ULL, 0x000fe40000011659ULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x000000ff6e6e7812ULL, 0x000fc400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000025ff25723eULL, 0x000fe400020006ffULL,
0x00000010ff787819ULL, 0x100fe4000001162fULL, 0x000000ff2f597812ULL, 0x040fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe4000001162fULL, 0x0000ffff2f857812ULL, 0x000fc400078ec0ffULL,
0x0000004bff32723eULL, 0x000fe200020006ffULL, 0x20000026ff4b7230ULL, 0x000fe20000004100ULL,
0x0000ffff5a807812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5b817812ULL, 0x000fe200078ec0ffULL,
0x20000032ff327230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe4000001162dULL,
0x0000ffff2d837812ULL, 0x000fe400078ec0ffULL, 0x0000002bff2f723eULL, 0x000fc400020006ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x2000002fff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff5b457812ULL, 0x000fe200078ec0ffULL,
0x20000055ff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff2b7819ULL, 0x000fe40000011627ULL,
0x000000ff277a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff272d7812ULL, 0x000fc400078ec0ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000006dff26723eULL, 0x000fe200020006ffULL,
0x2000006aff6d7230ULL, 0x000fe20000004100ULL, 0x00000018ff437819ULL, 0x000fe2000001165bULL,
0x20000054ff5b7230ULL, 0x000fe20000004100ULL, 0x0000006eff27723eULL, 0x000fe200020006ffULL,
0x20000024ff6a7230ULL, 0x000fe20000004100ULL, 0x00000058ff54723eULL, 0x000fe200020006ffULL,
0x20000025ff6e7230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe20000011680ULL,
0x20000056ff587230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe20000011681ULL,
0x20000071ff567230ULL, 0x000fe20000004100ULL, 0x000000ff70707812ULL, 0x000fe200078ec0ffULL,
0x20000027ff717230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000006fff55723eULL, 0x000fe200020006ffULL,
0x20000026ff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x20000045ff627230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000070ff26723eULL, 0x000fe200020006ffULL, 0x20000024ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff277819ULL, 0x000fe40000011682ULL, 0x00000048ff2e723eULL, 0x000fe400020006ffULL,
0x00000075ff45723eULL, 0x000fe400020006ffULL, 0x00000073ff48723eULL, 0x000fe200020006ffULL,
0x20000026ff737230ULL, 0x000fe20000004100ULL, 0x00000074ff2f723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000072ff75723eULL, 0x000fe200020006ffULL,
0x20000025ff727230ULL, 0x000fe20000004100ULL, 0x00000027ff74723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00a800004d24783bULL, 0x0002a20000000200ULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000030ff30723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fe20000011668ULL, 0x2000002fff2f7230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x20000030ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff4d7819ULL, 0x002fe20000011686ULL, 0x2000002eff2e7230ULL, 0x000fe20000004100ULL,
0x00000008ff7d7819ULL, 0x000fc40000011687ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x000000ff7e7f7812ULL, 0x000fc400078ec0ffULL, 0x0000105469687816ULL, 0x000fe40000000068ULL,
0x0000007dff7e723eULL, 0x000fe200020006ffULL, 0x2000007cff7d7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000004dff7c7230ULL, 0x000fe20000004100ULL,
0x000010546d697816ULL, 0x000fe2000000006cULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff4d7819ULL, 0x000fe20000011666ULL, 0x20000064ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe2000001166eULL, 0x0000002924248231ULL, 0x084fe200003400ffULL,
0x0000105465647816ULL, 0x000fe2000000006aULL, 0x0000002926268231ULL, 0x000fe200003400ffULL,
0x000010544d657816ULL, 0x000fe2000000006eULL, 0x0000000025258231ULL, 0x080fe200003400ffULL,
0x00000010ff4d7819ULL, 0x000fe20000011662ULL, 0x0000000027278231ULL, 0x000fe200003400ffULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff627819ULL, 0x000fe40000011671ULL,
0x000000ff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x000000682404723cULL, 0x040fe20000041804ULL,
0x00001054624d7816ULL, 0x000fe4000000004dULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000008ff687819ULL, 0x000fe2000001164cULL,
0x000000642408723cULL, 0x000fe20000041808ULL, 0x00000010ff4c7819ULL, 0x000fe2000001166fULL,
0x20000043ff607230ULL, 0x000fe20000004100ULL, 0x00000046ff46723eULL, 0x000fc400020006ffULL,
0x000010544c4c7816ULL, 0x000fe20000000061ULL, 0x2000004fff617230ULL, 0x000fe20000004100ULL,
0x00000076ff30723eULL, 0x000fe200020006ffULL, 0x20000046ff5a7230ULL, 0x000fe20000004100ULL,
0x00000008ff767819ULL, 0x000fe40000011683ULL, 0x00000049ff43723eULL, 0x000fe200020006ffULL,
0x0000004c240c723cULL, 0x000fe2000004180cULL, 0x00a800004e4c783bULL, 0x000e620000000200ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe20000011670ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000004aff46723eULL, 0x000fc400020006ffULL, 0x00000079ff49723eULL, 0x000fe400020006ffULL,
0x0000007aff4a723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x000000ff78797812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff77777812ULL, 0x000fe200078ec0ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fc40000011684ULL, 0x00000008ff7a7819ULL, 0x000fe40000011685ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff717819ULL, 0x000fe40000011672ULL,
0x000010545f707816ULL, 0x000fe40000000070ULL, 0x000000ff525f7812ULL, 0x000fe400078ec0ffULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000008ff537819ULL, 0x000fe20000011653ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000057ff57723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe20000011675ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000105460717816ULL, 0x000fe20000000071ULL,
0x000000004d4d8231ULL, 0x082fe200003400ffULL, 0x0000005fff60723eULL, 0x000fe200020006ffULL,
0x000000004f4f8231ULL, 0x000fe200003400ffULL, 0x00000053ff5f723eULL, 0x000fe200020006ffULL,
0x000000294c4c8231ULL, 0x080fe200003400ffULL, 0x00001054525d7816ULL, 0x000fe2000000005dULL,
0x000000702410723cULL, 0x000fe20000041810ULL, 0x00000010ff537819ULL, 0x000fe2000001165aULL,
0x000000294e4e8231ULL, 0x000fe200003400ffULL, 0x00000010ff747819ULL, 0x000fe20000011674ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe2000001165bULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff757819ULL, 0x000fc40000011676ULL,
0x0000105453747816ULL, 0x000fe40000000074ULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x0000105452757816ULL, 0x000fe40000000075ULL, 0x00000010ff537819ULL, 0x000fe40000011659ULL,
0x00000010ff5a7819ULL, 0x000fe40000011679ULL, 0x00000010ff5c7819ULL, 0x000fe2000001165cULL,
0x000000742418723cULL, 0x000fe20000041818ULL, 0x00000010ff737819ULL, 0x000fc40000011673ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff527819ULL, 0x000fe40000011677ULL,
0x00000010ff597819ULL, 0x000fe40000011658ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff797819ULL, 0x000fc4000001167aULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00001054735c7816ULL, 0x000fe2000000005cULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000105452527816ULL, 0x000fe20000000057ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x000010545a537816ULL, 0x000fc40000000053ULL, 0x0000105459787816ULL, 0x000fe20000000078ULL,
0x0000005c2414723cULL, 0x040fe20000041814ULL, 0x0000105454797816ULL, 0x000fe40000000079ULL,
0x00000008ff287819ULL, 0x000fe40000011628ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x00000052241c723cULL, 0x000fe2000004181cULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x00000010ff007819ULL, 0x000fe40000011643ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x000000782420723cULL, 0x000fe20000041820ULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x20000028ff287230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fc4000001162fULL,
0x00000010ff277819ULL, 0x000fe40000011668ULL, 0x000010547f247816ULL, 0x000fe40000000048ULL,
0x0000105466257816ULL, 0x000fe40000000025ULL, 0x0000105400267816ULL, 0x000fe40000000063ULL,
0x0000105446277816ULL, 0x000fe40000000027ULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x000000244c0c723cULL, 0x000fe2000004180cULL, 0x00000010ff007819ULL, 0x000fc40000011661ULL,
0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL, 0x2000002bff297230ULL, 0x000fe20000004100ULL,
0x000000ff2a2a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff2c7819ULL, 0x000fe2000001162cULL,
0x000000264c10723cULL, 0x000fe20000041810ULL, 0x00000008ff2d7819ULL, 0x000fe4000001162dULL,
0x0000105400247816ULL, 0x000fe40000000045ULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x0000002cff2c723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe20000011631ULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe20000011628ULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x0000002dff2d723eULL, 0x000fe400020006ffULL,
0x0000105400277816ULL, 0x000fc40000000027ULL, 0x00000010ff2b7819ULL, 0x000fe2000001164aULL,
0x2000002dff2d7230ULL, 0x000fe20000004100ULL, 0x00000010ff007819ULL, 0x000fe40000011629ULL,
0x00000010ff577819ULL, 0x000fe40000011656ULL, 0x00000010ff587819ULL, 0x000fe4000001167dULL,
0x00001054002b7816ULL, 0x000fe4000000002bULL, 0x00000010ff557819ULL, 0x000fc40000011655ULL,
0x00000010ff567819ULL, 0x000fe4000001167bULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x00000010ff2e7819ULL, 0x000fe4000001162eULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000010ff7d7819ULL, 0x000fe4000001167eULL, 0x00000010ff257819ULL, 0x000fc40000011630ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff327819ULL, 0x000fe40000011632ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x00000010ff2a7819ULL, 0x000fe4000001162aULL, 0x00000010ff517819ULL, 0x000fc40000011651ULL,
0x00000010ff2c7819ULL, 0x000fe4000001162cULL, 0x00000010ff007819ULL, 0x000fe4000001164bULL,
0x00000010ff2d7819ULL, 0x000fe4000001162dULL, 0x0000105456567816ULL, 0x000fe40000000055ULL,
0x0000105458577816ULL, 0x000fe40000000057ULL, 0x00001054477c7816ULL, 0x000fc4000000007cULL,
0x000010542e7d7816ULL, 0x000fe4000000007dULL, 0x0000105460257816ULL, 0x000fe20000000025ULL,
0x000000564c04723cULL, 0x040fe20000041804ULL, 0x0000105432267816ULL, 0x000fe4000000005fULL,
0x000010542a2a7816ULL, 0x000fe40000000049ULL, 0x00001054512c7816ULL, 0x000fe4000000002cULL,
0x00001054002d7816ULL, 0x000fe2000000002dULL, 0x0000007c4c08723cULL, 0x040ff00000041808ULL,
0x000000244c14723cULL, 0x040ff00000041814ULL, 0x000000264c18723cULL, 0x040ff00000041818ULL,
0x0000002a4c1c723cULL, 0x040ff0000004181cULL, 0x0000002c4c20723cULL, 0x000fe20000041820ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020003a247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a00050ff7f8cULL, 0x0007e2000c80043fULL, 0x000000015e567824ULL, 0x000fe200078e0233ULL,
0x00000001386c7812ULL, 0x000fc400078ec0ffULL, 0x0000030035357a10ULL, 0x018fc80007ffe0ffULL,
0x000000023500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff61c000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea20000002500ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0023ULL, 0x000000ffff357224ULL, 0x000fe400078e0022ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0021ULL, 0x000000ffff337224ULL, 0x000fe400078e0020ULL,
0x000000ffff287224ULL, 0x000fe400078e001fULL, 0x000000ffff317224ULL, 0x000fc400078e001eULL,
0x000000ffff267224ULL, 0x000fe400078e001dULL, 0x000000ffff2f7224ULL, 0x000fe400078e001cULL,
0x000000ffff247224ULL, 0x008fe400078e001bULL, 0x000000ffff2d7224ULL, 0x000fe400078e001aULL,
0x000000ffff227224ULL, 0x000fe400078e0019ULL, 0x000000ffff2b7224ULL, 0x000fe200078e0018ULL,
0x0000000402007c0cULL, 0x004fe2000bf03070ULL, 0x000000ffff207224ULL, 0x000fc400078e0017ULL,
0x000000ffff297224ULL, 0x000fe400078e0016ULL, 0x000000ffff277224ULL, 0x000fe400078e0014ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff237224ULL, 0x000fe400078e0010ULL,
0x000000ffff217224ULL, 0x000fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e0015ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0013ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0011ULL,
0x000000ffff187224ULL, 0x000fe400078e000fULL, 0x000000ffff167224ULL, 0x000fe400078e000dULL,
0x000000ffff1f7224ULL, 0x000fe400078e000cULL, 0x000000ffff147224ULL, 0x000fc400078e000bULL,
0x000000ffff1d7224ULL, 0x000fe400078e000aULL, 0x000000ffff127224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0008ULL, 0x000000ffff107224ULL, 0x000fe400078e0007ULL,
0x000000ffff197224ULL, 0x000fe400078e0006ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0005ULL,
0x000000ffff177224ULL, 0x000fe200078e0004ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x018000003b007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000af9000067802ULL, 0x000fe40000000f00ULL,
0x00009f6000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003b00007308ULL, 0x000ea40000001000ULL,
0xbf80000000027423ULL, 0x004fc8000000003bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000077919ULL, 0x000f220000000000ULL, 0x00000002ff067819ULL, 0x008fe40000011604ULL,
0x0000000807047811ULL, 0x010fe200078ff0ffULL, 0x0000000003057220ULL, 0x004fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000001700177220ULL, 0x044fe20000410000ULL, 0x0000000e000e7220ULL, 0x040fe20000410000ULL,
0x0000001b001b7220ULL, 0x040fe20000410000ULL, 0x0000001200127220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x040fe20000410000ULL, 0x0000001600167220ULL, 0x040fe20000410000ULL,
0x0000002300237220ULL, 0x040fe20000410000ULL, 0x0000001a001a7220ULL, 0x040fe20000410000ULL,
0x0000002700277220ULL, 0x040fe20000410000ULL, 0x0000001e001e7220ULL, 0x040fe20000410000ULL,
0x0000002b002b7220ULL, 0x040fe20000410000ULL, 0x0000002200227220ULL, 0x040fe20000410000ULL,
0x0000002f002f7220ULL, 0x040fe20000410000ULL, 0x0000002600267220ULL, 0x040fe20000410000ULL,
0x0000003300337220ULL, 0x040fe20000410000ULL, 0x0000002a002a7220ULL, 0x000fe20000410000ULL,
0x0000001904197220ULL, 0x048fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000203007812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000400067811ULL, 0x040fe400078ff8ffULL,
0x0000000803157811ULL, 0x000fe400078ff0ffULL, 0x0000000200047811ULL, 0x040fe400078ff8ffULL,
0x00000006000a7811ULL, 0x000fc400078ff8ffULL, 0x0000000702007812ULL, 0x100fe400078e780dULL,
0x0000000706087812ULL, 0x040fe400078e780dULL, 0x0000000706067812ULL, 0x000fe200078e7815ULL,
0x000000080d077824ULL, 0x000fe200078e0200ULL, 0x0000000704057812ULL, 0x100fe200078e780dULL,
0x000010003f007824ULL, 0x000fe200078e00ffULL, 0x000000070a0c7812ULL, 0x000fe200078e780dULL,
0x0000000815137824ULL, 0x000fe200078e0206ULL, 0x0000000702027812ULL, 0x100fe200078e7815ULL,
0x0000000803067824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e7815ULL,
0x000000080d097824ULL, 0x040fe200078e0205ULL, 0x000000070a0a7812ULL, 0x000fe200078e7815ULL,
0x000000080d0b7824ULL, 0x000fe200078e0208ULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x00000008150f7824ULL, 0x040fe200078e0202ULL, 0x0000001b1205723eULL, 0x000fe200000010ffULL,
0x0000000815117824ULL, 0x000fe200078e0204ULL, 0x000000170e04723eULL, 0x000fe200000010ffULL,
0x000000080d0d7824ULL, 0x000fc400078e020cULL, 0x0000000815157824ULL, 0x000fe200078e020aULL,
0x0000763204177816ULL, 0x000fe20000000005ULL, 0x0000080044027824ULL, 0x000fc800078e0200ULL,
0x0000001007077824ULL, 0x100fe400078e0202ULL, 0x0000001009097824ULL, 0x100fe400078e0202ULL,
0x000000100b0b7824ULL, 0x100fe400078e0202ULL, 0x000000100f0f7824ULL, 0x100fe400078e0202ULL,
0x0000001011117824ULL, 0x100fe400078e0202ULL, 0x000000100d0d7824ULL, 0x000fc400078e0202ULL,
0x0000001013137824ULL, 0x100fe400078e0202ULL, 0x0000001015157824ULL, 0x000fe400078e0202ULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x000000231a07723eULL, 0x000fe200000010ffULL,
0x0000000106097824ULL, 0x040fe400078e0209ULL, 0x00000001060b7824ULL, 0x040fe400078e020bULL,
0x00000001060f7824ULL, 0x000fc400078e020fULL, 0x0000000106117824ULL, 0x040fe400078e0211ULL,
0x00000001060d7824ULL, 0x040fe400078e020dULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x0000000106157824ULL, 0x000fe200078e0215ULL, 0x0000001f1606723eULL, 0x000fe400000010ffULL,
0x0000541004167816ULL, 0x000fe40000000005ULL, 0x000000271e04723eULL, 0x000fc400000010ffULL,
0x0000002b2205723eULL, 0x000fe200000010ffULL, 0x0000001608007388ULL, 0x0005e40000000a00ULL,
0x0000541006167816ULL, 0x144fe40000000007ULL, 0x0000763206177816ULL, 0x000fe40000000007ULL,
0x0000541004087816ULL, 0x000fe40000000005ULL, 0x0000002f2606723eULL, 0x000fe200000010ffULL,
0x0000001609007388ULL, 0x0005e20000000a00ULL, 0x000000332a07723eULL, 0x000fc400000010ffULL,
0x0000763204097816ULL, 0x004fe40000000005ULL, 0x000000191004723eULL, 0x000fe400000010ffULL,
0x0000001d1405723eULL, 0x000fe200000010ffULL, 0x000000080b007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x004fe20000000007ULL, 0x00000020440b7824ULL, 0x000fe200078e0203ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x000000211806723eULL, 0x000fe200000010ffULL,
0x000000100b0a7824ULL, 0x000fe200078e0200ULL, 0x000000251c07723eULL, 0x000fe200000010ffULL,
0x000000080d007388ULL, 0x0005e40000000a00ULL, 0x0000541004087816ULL, 0x004fc40000000005ULL,
0x0000763204097816ULL, 0x000fe40000000005ULL, 0x000000292004723eULL, 0x000fe400000010ffULL,
0x0000002d2405723eULL, 0x000fe200000010ffULL, 0x000000080f007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x144fe40000000007ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x000000312806723eULL, 0x000fc400000010ffULL, 0x000000352c07723eULL, 0x000fe200000010ffULL,
0x0000000811007388ULL, 0x0005e40000000a00ULL, 0x0000541004087816ULL, 0x144fe40000000005ULL,
0x0000763204097816ULL, 0x000fe40000000005ULL, 0x000000ff00047306ULL, 0x000fe60000205400ULL,
0x0000000813007388ULL, 0x0005ea0000000a00ULL, 0x000000ff00057306ULL, 0x000ee20000209400ULL,
0x0000541006087816ULL, 0x004fc40000000007ULL, 0x0000763206097816ULL, 0x000fca0000000007ULL,
0x0000000815007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000040500720bULL, 0x008fe40003f1d000ULL, 0x000000ff00047245ULL, 0x000fd6000020d400ULL,
0x0000000104040812ULL, 0x000fc800078efcffULL, 0x000000040406723eULL, 0x000fe200000010ffULL,
0x000400000a1c7984ULL, 0x000ea80000000c00ULL, 0x000c00000a107984ULL, 0x000ee80000000c00ULL,
0x000000000a0c7984ULL, 0x000f280000000c00ULL, 0x000800000a187984ULL, 0x000e620000000c00ULL,
0x3f803f80061d7831ULL, 0x004fc4000020001dULL, 0x3f803f80061f7831ULL, 0x040fe4000020001fULL,
0x3f803f801d1d7831ULL, 0x008fe20000200011ULL, 0x00000300ff117624ULL, 0x000fe200078e00ffULL,
0x3f803f80061e7831ULL, 0x040fe4000020001eULL, 0x3f803f80060f7831ULL, 0x050fe4000020000fULL,
0x000000011100780cULL, 0x000fe20003f05270ULL, 0x3f803f80060e7831ULL, 0x040fe4000020000eULL,
0x3f803f80060d7831ULL, 0x000fc4000020000dULL, 0x3f803f80060c7831ULL, 0x040fe4000020000cULL,
0x3f803f80061c7831ULL, 0x000fe4000020001cULL, 0x3f803f800f0f7831ULL, 0x002fe4000020001bULL,
0x3f803f800e0e7831ULL, 0x000fe4000020001aULL, 0x3f803f800d0d7831ULL, 0x000fe40000200019ULL,
0x3f803f800c0c7831ULL, 0x000fc40000200018ULL, 0x3f803f801f1f7831ULL, 0x000fe40000200013ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200012ULL, 0x0000000c0a007388ULL, 0x0003e20000000c00ULL,
0x3f803f801c1c7831ULL, 0x000fca0000200010ULL, 0x0004001c0a007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f4000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ea20000002700ULL, 0x0000580011057a24ULL, 0x000fe200078e02ffULL,
0x0000000144ff7812ULL, 0x000fe2000780f836ULL, 0x00000800ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x00006600050c7a24ULL, 0x002fe200078e02ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000000ff0300720cULL, 0x000fe20000725670ULL,
0x000000000a147984ULL, 0x0002e40000000c00ULL, 0x000007ff0c067811ULL, 0x000fe200078e40ffULL,
0x0000580010107a24ULL, 0x004fc400078e0207ULL, 0x000004003f077824ULL, 0x000fe400078e00ffULL,
0x0000030010057a24ULL, 0x000fca00078e02ffULL, 0x00000004050d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000d06087211ULL, 0x000fca00078fa8ffULL, 0x00006c0008087625ULL, 0x000fca00078e0009ULL,
0x00000007080e7210ULL, 0x000fe40007f5e0ffULL, 0x01ffffff0c087812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fc800010e0609ULL, 0x000000100b0e7825ULL, 0x000fe200078e000eULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x00afe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x000000010d0c7824ULL, 0x000fe200078e0208ULL, 0x000000700a137812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b127812ULL, 0x000fe200078ec0ffULL, 0x00006c000d0a7625ULL, 0x000fc800078e0009ULL,
0x00006c000c0c7625ULL, 0x000fe200078e0009ULL, 0x0000000a120a7210ULL, 0x000fc80007a1e013ULL,
0x0000000c120c7210ULL, 0x000fe40007c7e013ULL, 0x0000000bff0b7210ULL, 0x000fe400007e44ffULL,
0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL, 0x0000003c0a007986ULL, 0x0003e8000c101906ULL,
0x0000003b0c007986ULL, 0x0003e4000c101906ULL, 0x0000000000007941ULL, 0x00afea0003800000ULL,
0x000000140e007986ULL, 0x0003e2000c101d06ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff11097810ULL, 0x000fc60007ffe0ffULL,
0x00006a00100a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x000000090a0a79a8ULL, 0x000ea400099ee1c6ULL,
0x000000090a00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000000000ULL, 0x0000000cff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff097984ULL, 0x000ee40000000000ULL, 0x000000ff0900720cULL, 0x008fda0003f05270ULL,
0x00002b9000008947ULL, 0x000fea0003800000ULL, 0x000000ff3600720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011603ULL,
0x0000001003097824ULL, 0x000fe200078e00ffULL, 0x00000001050c7810ULL, 0x004fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x002fe200078e00ffULL, 0x0000000c0a157812ULL, 0x000fe400078ec0ffULL,
0x0000007009137812ULL, 0x000fe200078ec0ffULL, 0x00006c00050a7625ULL, 0x000fc800078e000fULL,
0x00006c000c0c7625ULL, 0x000fe200078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000c150c7210ULL, 0x000fe40007b5e013ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a097981ULL, 0x000368000c1e1900ULL,
0x000000060c0e7981ULL, 0x000362000c1e1900ULL, 0x000000021100780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a107981ULL, 0x000362000c1e1900ULL,
0x000000041100780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a127981ULL, 0x000362000c1e1900ULL, 0x000000041100780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a147981ULL, 0x000362000c1e1900ULL,
0x000000061100780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a167981ULL, 0x000362000c1e1900ULL, 0x000000061100780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081100780cULL, 0x002fe40003f06070ULL,
0x00000006050a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fe40007a3e013ULL, 0x00000007050c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fe400078e000fULL,
0x000000060a187981ULL, 0x000366000c1e1900ULL, 0x0000000c150c0210ULL, 0x000fc80007c7e013ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c0c0981ULL, 0x000368000c1e1900ULL,
0x00000007110a7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0d7819ULL, 0x000fc8000001160aULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x020fe400078e0009ULL,
0x000000081a0f7824ULL, 0x040fe200078e00ffULL, 0x000000011a1a7810ULL, 0x000fc80007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000000d1a00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080f0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000010f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001c09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1c7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000020f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000e09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0e7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000030f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001009097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a107981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000040f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001209097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a127981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000050f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001409097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a147981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0f0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000060f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001609097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a167981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0f0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000070f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001809097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a187981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0f0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000000c09097209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030c7824ULL, 0x004fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007a3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0c7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x00000010030a7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc80000011603ULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL,
0x000000010b0a7824ULL, 0x000fca00078e020aULL, 0x000000090a007388ULL, 0x0203e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000001003097824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x0000000144137824ULL, 0x000fe200078e0205ULL,
0x00000002ff0d7819ULL, 0x000fe20000011636ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x00000800ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000c0b0c7812ULL, 0x004fe200078ec0ffULL, 0x0000020036367824ULL, 0x000fe200078e00ffULL,
0x00000013060a7211ULL, 0x000fe200078fa8ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0200ULL,
0x000010d000007945ULL, 0x000fe20003800000ULL, 0x000000010c297824ULL, 0x000fe200078e0209ULL,
0x000000010d097812ULL, 0x000fe200078ec0ffULL, 0x00000002440c8824ULL, 0x100fe200078e023fULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000fULL,
0x00000020030f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000244108824ULL, 0x000fe200078e023fULL,
0x000000070a0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000020c0e8824ULL, 0x100fe200078e0209ULL,
0x00000800360c7812ULL, 0x000fe200078ec0ffULL, 0x0000000210148824ULL, 0x000fe200078e0209ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000108108824ULL, 0x000fe200078e0213ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000029297984ULL, 0x000e620000000800ULL, 0x00000080ff128424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000013d0c7824ULL, 0x000fe200078e020cULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000030044007a0cULL, 0x000fe20003f26070ULL, 0x00006c0010108625ULL, 0x000fc800078e0011ULL,
0x00006c0013128625ULL, 0x000fc800078e0012ULL, 0x000000080e178824ULL, 0x100fe400078e0203ULL,
0x0000000814148824ULL, 0x000fe400078e0203ULL, 0x0000001003157824ULL, 0x000fe200078e020cULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x00000010030c7825ULL, 0x000fe200078e000aULL,
0x00004180141f8811ULL, 0x000fc600078e20ffULL, 0x000000100f0e7825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c157faeULL, 0x0005e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000001003108825ULL, 0x040fe200078e0010ULL,
0x003800000e157faeULL, 0x0007e6000b901c46ULL, 0x0000001003128825ULL, 0x000fe200078e0012ULL,
0x0000000010178faeULL, 0x0009e6000b901c46ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00000000121f8faeULL, 0x0003e2000b901c46ULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff287224ULL, 0x000fc400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x010fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x002fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000d5000001947ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fca00078e0044ULL,
0x0000000233347810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030034007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x0000000105317824ULL, 0x100fe200078e0234ULL,
0x00000001ff2a7819ULL, 0x000fe20000011634ULL, 0x00000800ff307424ULL, 0x000fe200078e00ffULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x00000400342c7824ULL, 0x000fe200078e00ffULL,
0x00000031062b7211ULL, 0x000fe400078fa8ffULL, 0x000000012a2e7812ULL, 0x000fc600078ec0ffULL,
0x00006c002b2a7625ULL, 0x000fc800078e0030ULL, 0x00000002442f9824ULL, 0x100fe200078e023fULL,
0x000000072a2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000244359824ULL, 0x000fe400078e023fULL,
0x000000022f369824ULL, 0x100fe400078e022eULL, 0x00000002353a9824ULL, 0x000fe200078e022eULL,
0x000008002c2e7812ULL, 0x000fe200078ec0ffULL, 0x00000001082d9824ULL, 0x000fe400078e0231ULL,
0x00000080ff309424ULL, 0x000fc400078e00ffULL, 0x00000080ff389424ULL, 0x000fe400078e00ffULL,
0x00006c002d2c9625ULL, 0x000fc800078e0030ULL, 0x000000013d2e7824ULL, 0x000fe400078e022eULL,
0x000000ffff2b7224ULL, 0x000fe400000e062bULL, 0x00006c0031309625ULL, 0x000fc800078e0038ULL,
0x0000001003357824ULL, 0x040fe400078e022eULL, 0x0000000836369824ULL, 0x000fe400078e0203ULL,
0x00000010032e9825ULL, 0x000fc800078e002cULL, 0x000000083a399824ULL, 0x000fe400078e0203ULL,
0x00000010372c7825ULL, 0x100fe200078e002aULL, 0x0000458036379811ULL, 0x000fe400078e20ffULL,
0x0000418039399811ULL, 0x000fe200078e20ffULL, 0x00000010032a7825ULL, 0x000fc800078e002aULL,
0x0000001003309825ULL, 0x000fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002a357faeULL, 0x0003e8000b901c46ULL, 0x003800002c357faeULL, 0x0003e8000b901c46ULL,
0x000000002e379faeULL, 0x0003e8000b901c46ULL, 0x0000000030399faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000040332a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x000fe20000011603ULL,
0x00000002442d7824ULL, 0x000fe200078e023fULL, 0x00000002ff527819ULL, 0x000fe20000011603ULL,
0x00000010032b7824ULL, 0x000fe200078e00ffULL, 0x000000802a2a7812ULL, 0x000fc400078ec0ffULL,
0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL, 0x00000008522f7824ULL, 0x040fe200078e00ffULL,
0x000000702b2b7812ULL, 0x000fe200078ec0ffULL, 0x000001002d2a7824ULL, 0x000fe200078e002aULL,
0x0000000752407812ULL, 0x060fe200078ec0ffULL, 0x00000008522d7824ULL, 0x040fe200078e00ffULL,
0x0000000852547810ULL, 0x000fe40007ffe0ffULL, 0x0000002a2c2c7210ULL, 0x000fe20007ffe02bULL,
0x00000008522b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2a7812ULL, 0x100fe200078ee240ULL,
0x00000008542d7824ULL, 0x040fe200078e00ffULL, 0x00000054ff4e7212ULL, 0x000fe200078e33ffULL,
0x0000000854427824ULL, 0x000fe200078e00ffULL, 0x000000012b2e7812ULL, 0x000fe200078ef640ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002c3c7984ULL, 0x000e620000000800ULL,
0x000000022b307812ULL, 0x140fe400078ef640ULL, 0x000000032b367812ULL, 0x140fe200078ef640ULL,
0x004580002c507984ULL, 0x0002a20000000800ULL, 0x000000042b387812ULL, 0x140fe400078ef640ULL,
0x000000052b3a7812ULL, 0x000fe400078ef640ULL, 0xfffffff82d4e7812ULL, 0x000fe200078ee24eULL,
0x00000004032d7824ULL, 0x000fe200078e00ffULL, 0x00000052ff3e7212ULL, 0x000fc800078e33ffULL,
0x0000000c2d2d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff82f3e7812ULL, 0x000fe400078ee23eULL,
0x00000007542f7812ULL, 0x000fe200078ec0ffULL, 0x0000003c292c7221ULL, 0x002fe20000010100ULL,
0x000000062b3c7812ULL, 0x000fe200078ef640ULL, 0x00000400332b7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b2c317820ULL, 0x000fe20000410000ULL, 0x0000000854407824ULL, 0x000fc400078e00ffULL,
0x000008002b2c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff337224ULL, 0x000fe400078e0034ULL,
0x0000000240467812ULL, 0x100fe200078ef62fULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x000001803d2b7810ULL, 0x000fe40007ffe02cULL, 0xfffffff8422c7812ULL, 0x100fe400078ee22fULL,
0x0000000140427812ULL, 0x000fe200078ef62fULL, 0x000000102a2a7824ULL, 0x000fe200078e022bULL,
0x0000000340487812ULL, 0x000fe200078ef62fULL, 0x000000103e3e7824ULL, 0x000fe200078e022bULL,
0x00000004404a7812ULL, 0x000fe200078ef62fULL, 0x000000012a2a7824ULL, 0x000fe200078e022dULL,
0x00000005404c7812ULL, 0x140fe200078ef62fULL, 0x000000012d3e7824ULL, 0x000fe200078e023eULL,
0x0000000640407812ULL, 0x000fe200078ef62fULL, 0x000000102e2e7824ULL, 0x100fe200078e022bULL,
0x000000002a2f7984ULL, 0x000e620000000800ULL, 0x0000001030307824ULL, 0x100fe200078e022bULL,
0x0000005031317220ULL, 0x004fe20000410000ULL, 0x000000012d2e7824ULL, 0x040fe200078e022eULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x000000012d307824ULL, 0x000fe200078e0230ULL,
0x0000030033007a0cULL, 0x000fe20003f06070ULL, 0x0000001036367824ULL, 0x100fe200078e022bULL,
0x00001f52312a7589ULL, 0x000ea200000e0000ULL, 0x0000001038387824ULL, 0x000fe200078e022bULL,
0x0000003231327221ULL, 0x000fe20000010000ULL, 0x000000012d367824ULL, 0x040fe200078e0236ULL,
0x000000002e2e7984ULL, 0x000ee20000000800ULL, 0x000000012d387824ULL, 0x000fc400078e0238ULL,
0x000000103a3a7824ULL, 0x100fe200078e022bULL, 0x0000000030307984ULL, 0x000f220000000800ULL,
0x000000103c3c7824ULL, 0x100fe400078e022bULL, 0x000000012d3a7824ULL, 0x000fe200078e023aULL,
0x0000000036367984ULL, 0x000ee20000000800ULL, 0x000000102c2c7824ULL, 0x100fe400078e022bULL,
0x0000001042427824ULL, 0x100fe200078e022bULL, 0x0000000038387984ULL, 0x000ee20000000800ULL,
0x0000001046467824ULL, 0x000fc400078e022bULL, 0x0000001048487824ULL, 0x100fe200078e022bULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x000000104a4a7824ULL, 0x100fe400078e022bULL,
0x000000104c4c7824ULL, 0x100fe400078e022bULL, 0x0000001040407824ULL, 0x100fe400078e022bULL,
0x000000104e4e7824ULL, 0x000fe400078e022bULL, 0x000000012d3c7824ULL, 0x040fe200078e023cULL,
0x00001f54312b7589ULL, 0x000fe200000e0000ULL, 0x000000012d2c7824ULL, 0x040fe200078e022cULL,
0x00007610ff507816ULL, 0x002fe2000000002fULL, 0x000000012d427824ULL, 0x000fc400078e0242ULL,
0x000000012d467824ULL, 0x040fe200078e0246ULL, 0x000000003c3c7984ULL, 0x000e620000000800ULL,
0x000000012d487824ULL, 0x040fe200078e0248ULL, 0x0000002a50277223ULL, 0x004fe20000010027ULL,
0x000000012d4a7824ULL, 0x040fe200078e024aULL, 0x000000002c2c7984ULL, 0x000ea20000000800ULL,
0x000000012d4c7824ULL, 0x040fe400078e024cULL, 0x000000012d407824ULL, 0x040fe200078e0240ULL,
0x0000000042427984ULL, 0x000e620000000800ULL, 0x000000012d4e7824ULL, 0x000fe200078e024eULL,
0x00005410ff2d7816ULL, 0x000fc4000000002fULL, 0x0000000046467984ULL, 0x000e660000000800ULL,
0x0000002a2d287223ULL, 0x000fe20000010028ULL, 0x00005410ff2d7816ULL, 0x100fe2000000003eULL,
0x0000000048487984ULL, 0x000ea20000000800ULL, 0x00007610ff3e7816ULL, 0x000fc6000000003eULL,
0x0000002a2d1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff2d7816ULL, 0x108fe2000000002eULL,
0x000000004a4a7984ULL, 0x000ee20000000800ULL, 0x00007610ff2e7816ULL, 0x000fe2000000002eULL,
0x0000002a3e197223ULL, 0x080fe40000010019ULL, 0x0000002a2d267223ULL, 0x080fe20000010026ULL,
0x00005410ff2d7816ULL, 0x110fe20000000030ULL, 0x000000004c4c7984ULL, 0x000f220000000800ULL,
0x00007610ff307816ULL, 0x000fe20000000030ULL, 0x0000002a2e257223ULL, 0x000fc40000010025ULL,
0x0000002a2d247223ULL, 0x080fe20000010024ULL, 0x00005410ff2d7816ULL, 0x100fe20000000036ULL,
0x0000000040407984ULL, 0x000ee20000000800ULL, 0x00007610ff367816ULL, 0x000fe20000000036ULL,
0x0000002a30237223ULL, 0x080fe40000010023ULL, 0x0000002a2d227223ULL, 0x080fe20000010022ULL,
0x00005410ff2d7816ULL, 0x100fe20000000038ULL, 0x000000004e4e7984ULL, 0x000ee20000000800ULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x0000002a36217223ULL, 0x000fc40000010021ULL,
0x0000002a2d207223ULL, 0x080fe20000010020ULL, 0x00005410ff2d7816ULL, 0x100fe2000000003aULL,
0x0000002a381f7223ULL, 0x000fe2000001001fULL, 0x00007610ff3a7816ULL, 0x000fc6000000003aULL,
0x0000002a2d1e7223ULL, 0x080fe2000001001eULL, 0x00005410ff2d7816ULL, 0x102fe2000000003cULL,
0x0000002a3a1d7223ULL, 0x000fe2000001001dULL, 0x00007610ff3c7816ULL, 0x000fc6000000003cULL,
0x0000002a2d1c7223ULL, 0x080fe2000001001cULL, 0x00005410ff2d7816ULL, 0x104fe2000000002cULL,
0x0000002a3c1b7223ULL, 0x000fe2000001001bULL, 0x00007610ff2c7816ULL, 0x000fc6000000002cULL,
0x0000002b2d187223ULL, 0x080fe20000010018ULL, 0x00005410ff2d7816ULL, 0x100fe20000000042ULL,
0x0000002b2c177223ULL, 0x000fe20000010017ULL, 0x00007610ff427816ULL, 0x000fc60000000042ULL,
0x0000002b2d167223ULL, 0x080fe20000010016ULL, 0x00005410ff2d7816ULL, 0x100fe20000000046ULL,
0x0000002b42157223ULL, 0x000fe20000010015ULL, 0x00007610ff467816ULL, 0x000fc60000000046ULL,
0x0000002b2d147223ULL, 0x080fe20000010014ULL, 0x00005410ff2d7816ULL, 0x100fe20000000048ULL,
0x0000002b46137223ULL, 0x000fe20000010013ULL, 0x00007610ff487816ULL, 0x000fc60000000048ULL,
0x0000002b2d127223ULL, 0x080fe20000010012ULL, 0x00005410ff2d7816ULL, 0x108fe2000000004aULL,
0x0000002b48117223ULL, 0x000fe20000010011ULL, 0x00007610ff4a7816ULL, 0x000fc6000000004aULL,
0x0000002b2d107223ULL, 0x080fe20000010010ULL, 0x00005410ff2d7816ULL, 0x110fe2000000004cULL,
0x0000002b4a0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff4c7816ULL, 0x000fc6000000004cULL,
0x0000002b2d0e7223ULL, 0x080fe2000001000eULL, 0x00005410ff2d7816ULL, 0x100fe20000000040ULL,
0x0000002b4c0d7223ULL, 0x000fe2000001000dULL, 0x00007610ff407816ULL, 0x000fc60000000040ULL,
0x0000002b2d0c7223ULL, 0x080fe2000001000cULL, 0x00005410ff2d7816ULL, 0x100fe2000000004eULL,
0x0000002b400b7223ULL, 0x000fe2000001000bULL, 0x00007610ff4e7816ULL, 0x000fc6000000004eULL,
0x0000002b2d0a7223ULL, 0x080fe4000001000aULL, 0x0000002b4e097223ULL, 0x000fe20000010009ULL,
0xfffff2d000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff3f00720cULL, 0x000fe20003f05270ULL,
0x0000001003057824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c03067812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fe200078e0205ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003057824ULL, 0x002fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011603ULL, 0x0000007005037812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc600078ec0ffULL, 0x0000008044037824ULL, 0x000fc800078e0203ULL,
0x0000000106037824ULL, 0x000fca00078e0203ULL, 0x0049803203007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800007037984ULL, 0x002e680000000800ULL, 0x004a000007067984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000603037221ULL, 0x004fca0000010000ULL,
0x0180000003057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0003ULL,
0x0000de8000067802ULL, 0x000fe40000000f00ULL, 0x0000707000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff057224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300067308ULL, 0x000e640000001000ULL, 0xbf80000003057423ULL, 0x002fc80000000006ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000506057223ULL, 0x000fe40000000006ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff087819ULL, 0x004fe40000011603ULL,
0x0000000803417811ULL, 0x000fc600078ff0ffULL, 0x00001f0805067589ULL, 0x000ea200000e0000ULL,
0x00000041ff437212ULL, 0x000fe200078e33ffULL, 0x00000008412a7824ULL, 0x000fe400078e00ffULL,
0x00001f4105077589ULL, 0x00072600000e0000ULL, 0xfffffff82a437812ULL, 0x000fca00078ee243ULL,
0x0000001043437824ULL, 0x000fe200078e0202ULL, 0x00000008ff057212ULL, 0x008fe200078e33ffULL,
0x0000002806287220ULL, 0x044fe20000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000001a061a7220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x000fe20000410000ULL,
0x0000000808067824ULL, 0x000fe200078e00ffULL, 0x0000001807187220ULL, 0x050fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000b070b7220ULL, 0x040fe20000410000ULL, 0x0000000a070a7220ULL, 0x040fe20000410000ULL,
0x0000000907077220ULL, 0x000fe20000410000ULL, 0xfffffff806457812ULL, 0x000fe200078ee205ULL,
0x0000000808057824ULL, 0x040fe200078e00ffULL, 0x0000000708067812ULL, 0x000fc400078ec0ffULL,
0x0000000a0707723eULL, 0x000fe200000010ffULL, 0x00000008410a7824ULL, 0x000fe200078e00ffULL,
0x0000000106097812ULL, 0x040fe400078e3cffULL, 0x0000000206297812ULL, 0x040fe400078e3cffULL,
0x00000003062b7812ULL, 0x000fe200078e3cffULL, 0x0000000808097824ULL, 0x000fe200078e0209ULL,
0x00000004062d7812ULL, 0x000fe200078e3cffULL, 0x0000000808297824ULL, 0x000fe200078e0229ULL,
0x00000005062f7812ULL, 0x000fe200078e3cffULL, 0x00000008082b7824ULL, 0x000fe200078e022bULL,
0x0000000606317812ULL, 0x000fe200078e3cffULL, 0x00000008082d7824ULL, 0x040fe200078e022dULL,
0x000000100f0f723eULL, 0x000fe200000010ffULL, 0x00000008082f7824ULL, 0x040fe200078e022fULL,
0x0000000741107812ULL, 0x000fe200078ec0ffULL, 0x0000000808317824ULL, 0x000fe200078e0231ULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000403127824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d723eULL, 0x000fe200000010ffULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000001029297824ULL, 0x000fe200078e0202ULL,
0xfffffff805057812ULL, 0x000fe200078ee208ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0xfffffff80a337812ULL, 0x000fe200078ee241ULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x0000000110067812ULL, 0x040fe200078e3cffULL, 0x0000001005057824ULL, 0x100fe200078e0202ULL,
0x0000000210087812ULL, 0x040fe200078e3cffULL, 0x0000001033337824ULL, 0x000fe200078e0202ULL,
0x00000003100a7812ULL, 0x040fe200078e3cffULL, 0x0000000841357824ULL, 0x040fe200078e0206ULL,
0x00000004100c7812ULL, 0x040fe200078e3cffULL, 0x0000000841377824ULL, 0x040fe200078e0208ULL,
0x00000005100e7812ULL, 0x040fe200078e3cffULL, 0x0000000841397824ULL, 0x040fe200078e020aULL,
0x0000000610107812ULL, 0x000fe200078e3cffULL, 0x00000008413b7824ULL, 0x002fe200078e020cULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x00000008413d7824ULL, 0x040fe200078e020eULL,
0x0000000c121e7812ULL, 0x000fe200078ec0ffULL, 0x0000000841417824ULL, 0x000fe200078e0210ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x0000001045087824ULL, 0x100fe200078e0202ULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x000000011e067824ULL, 0x040fe200078e0205ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0202ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x0000001031317824ULL, 0x100fe200078e0202ULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x0000001035357824ULL, 0x100fe200078e0202ULL,
0x0000002706007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x100fe200078e0202ULL,
0x0000001c1b1b723eULL, 0x000fe200000010ffULL, 0x0000001039397824ULL, 0x100fe200078e0202ULL,
0x0000001a1919723eULL, 0x000fe200000010ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0202ULL,
0x000000141313723eULL, 0x000fe200000010ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0202ULL,
0x000000181717723eULL, 0x000fe200000010ffULL, 0x0000001041417824ULL, 0x000fe200078e0202ULL,
0x000000161515723eULL, 0x000fe200000010ffULL, 0x000000011e127824ULL, 0x000fc400078e0208ULL,
0x000000011e027824ULL, 0x040fe400078e0209ULL, 0x000000011e087824ULL, 0x040fe400078e0229ULL,
0x000000011e0a7824ULL, 0x040fe200078e022bULL, 0x0000002502007388ULL, 0x000fe20000000800ULL,
0x000000011e0c7824ULL, 0x040fe400078e022dULL, 0x000000011e0e7824ULL, 0x040fe200078e022fULL,
0x0000002308007388ULL, 0x000fe20000000800ULL, 0x000000011e107824ULL, 0x000fc400078e0231ULL,
0x000000011e147824ULL, 0x040fe200078e0233ULL, 0x000000210a007388ULL, 0x000fe20000000800ULL,
0x000000011e167824ULL, 0x040fe400078e0235ULL, 0x000000011e067824ULL, 0x042fe200078e0237ULL,
0x0000001f0c007388ULL, 0x000fe20000000800ULL, 0x000000011e187824ULL, 0x040fe400078e0239ULL,
0x000000011e1a7824ULL, 0x040fe200078e023bULL, 0x0000001d0e007388ULL, 0x000fe20000000800ULL,
0x000000011e207824ULL, 0x000fc400078e0243ULL, 0x000000011e1c7824ULL, 0x040fe200078e023dULL,
0x0000001b10007388ULL, 0x000fe20000000800ULL, 0x000000011e1e7824ULL, 0x000fe400078e0241ULL,
0x0000002044057824ULL, 0x000fe200078e0203ULL, 0x0000001912007388ULL, 0x0003e60000000800ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x0000001714007388ULL, 0x000fe80000000800ULL,
0x0000001516007388ULL, 0x000fe20000000800ULL, 0x000000040412723eULL, 0x002fc600000010ffULL,
0x0000001306007388ULL, 0x000fe80000000800ULL, 0x0000001118007388ULL, 0x000fe80000000800ULL,
0x0000000f1a007388ULL, 0x000fe80000000800ULL, 0x0000000d1c007388ULL, 0x000fe80000000800ULL,
0x0000000b1e007388ULL, 0x000fe80000000800ULL, 0x0000000720007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000005247984ULL, 0x000e680000000c00ULL,
0x0004000005287984ULL, 0x000ea80000000c00ULL, 0x0008000005147984ULL, 0x000ee80000000c00ULL,
0x000c0000052c7984ULL, 0x000f220000000c00ULL, 0x3f803f8012277831ULL, 0x002fc40000200027ULL,
0x3f803f8012267831ULL, 0x040fe40000200026ULL, 0x3f803f8012257831ULL, 0x040fe40000200025ULL,
0x3f803f8012247831ULL, 0x040fe40000200024ULL, 0x3f803f80122b7831ULL, 0x044fe4000020002bULL,
0x3f803f80122a7831ULL, 0x040fe4000020002aULL, 0x3f803f8012297831ULL, 0x000fc40000200029ULL,
0x3f803f8012287831ULL, 0x000fe40000200028ULL, 0x3f803f8027277831ULL, 0x008fe40000200017ULL,
0x3f803f8026267831ULL, 0x000fe40000200016ULL, 0x3f803f8025257831ULL, 0x000fe40000200015ULL,
0x3f803f8024247831ULL, 0x000fe40000200014ULL, 0x3f803f802b2b7831ULL, 0x010fc4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020002eULL, 0x0000002405007388ULL, 0x0003e20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fca000020002cULL,
0x0004002805007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff4400720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002003117810ULL, 0x000fe20007ffe0ffULL, 0x0000000000107919ULL, 0x000ee20000002600ULL,
0x00000003ff127819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000712027812ULL, 0x000fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704067812ULL, 0x000fe400078e4811ULL, 0x0ffffff802057812ULL, 0x002fc400078ef803ULL,
0x0ffffff806077812ULL, 0x000fc600078ef811ULL, 0x0000001005057824ULL, 0x100fe400078e0200ULL,
0x0000001007077824ULL, 0x000fc600078e0200ULL, 0x0000000005087984ULL, 0x0002a80000000c00ULL,
0x00000000070c7984ULL, 0x0044a20000000c00ULL, 0x0000000810137824ULL, 0x048fe400078e00ffULL,
0x0000000810157824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x000000083f107824ULL, 0x000fe200078e00ffULL, 0xfffffff813007812ULL, 0x000fe200078ee212ULL,
0x000000083f127824ULL, 0x000fe200078e00ffULL, 0xfffffff815047812ULL, 0x000fc400078ee204ULL,
0x0000000400027c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404007c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff810037812ULL, 0x000fe200078ee203ULL, 0x000000ffff057224ULL, 0x002fe200000e06ffULL,
0x00005a0002047a11ULL, 0x000fe200078040ffULL, 0x000000ffff077224ULL, 0x004fe200008e06ffULL,
0x00005a0000067a11ULL, 0x000fe400078240ffULL, 0x00005b0002057a11ULL, 0x000fc400000f4405ULL,
0x00005b0000077a11ULL, 0x000fe400008f4407ULL, 0xfffffff812117812ULL, 0x000fe200078ee211ULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x000fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff2c7819ULL, 0x000fe20000011636ULL,
0xffffffffff2d7424ULL, 0x000fc800078e00ffULL, 0x00000002352c7824ULL, 0x000fca00078e022cULL,
0x000000032c00720cULL, 0x000fda0003f06070ULL, 0x0000000233058824ULL, 0x000fc800078e00ffULL,
0x0000640005068a24ULL, 0x000fc800078e022cULL, 0x0000600006068625ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x00000006062d8981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x00f60000ff047f8cULL, 0x000e68000c80043fULL, 0x0000000608327981ULL, 0x000762000c1e9900ULL,
0x00000001350b7810ULL, 0x000fe20007ffe0ffULL, 0x00000040362e7824ULL, 0x000fe400078e00ffULL,
0x000000802f2f7824ULL, 0x000fe200078e00ffULL, 0x000000020b00720cULL, 0x000fe20003f06070ULL,
0x00000100350b7824ULL, 0x000fc400078e022eULL, 0x0000008030307824ULL, 0x000fc600078e00ffULL,
0x000000402f187812ULL, 0x000fe200078ef80bULL, 0x000000302d217224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011642ULL,
0x0000000b34007217ULL, 0x000fe40007800000ULL, 0x000000081d117810ULL, 0x040fe20007ffe0ffULL,
0x000000011d067824ULL, 0x140fe200078e0218ULL, 0x000000181d237810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000101d157810ULL, 0x000fe40007ffe0ffULL,
0x0000000621137210ULL, 0x000fe20007f1e0ffULL, 0x0000000111067824ULL, 0x100fe200078e0218ULL,
0x000000300a1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000115077824ULL, 0x000fe200078e0218ULL,
0x00000003ff0f7819ULL, 0x000fe20000011642ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0013167a11ULL, 0x000fe200078038ffULL, 0x00000004110a7824ULL, 0x000fe200078e00ffULL,
0x0000000721127210ULL, 0x000fc40007f3e0ffULL, 0x00005f0013137a11ULL, 0x000fe200000f3c08ULL,
0x0000000123087824ULL, 0x000fe200078e0218ULL, 0x0000000621067210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00005e00120b7a11ULL, 0x000fe400078238ffULL,
0x0000000821087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e00060c7a11ULL, 0x040fe400078038ffULL, 0x000000201d177810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x00005f0006147a11ULL, 0x000fc400000f3c0dULL,
0x00005e00080e7a11ULL, 0x040fe400078438ffULL, 0x000000161f067210ULL, 0x000fe20007f7e0ffULL,
0x0000000415167824ULL, 0x000fe200078e00ffULL, 0x000000030f0d7812ULL, 0x000fe400078e4842ULL,
0x00005f0008107a11ULL, 0x000fe200010f3c07ULL, 0x000000ffff077224ULL, 0x000fe200018e0613ULL,
0x000000001d00720cULL, 0x000fe40003f06070ULL, 0x00001000360f7811ULL, 0x000fc400078e68ffULL,
0xfffffffc0a0a7812ULL, 0x000fe400078ee20dULL, 0x0000001f0c087210ULL, 0x080fe40007f7e0ffULL,
0x0ffffffc0d427812ULL, 0x000fe200078ef842ULL, 0x000000100a137824ULL, 0x000fe200078e020fULL,
0xfffffffc160c7812ULL, 0x000fe400078ee20dULL, 0x00005f0012127a11ULL, 0x000fe200008f3c09ULL,
0x000000ffff097224ULL, 0x000fe200018e0614ULL, 0x000000001100720cULL, 0x080fe20003f26070ULL,
0x0000001042117824ULL, 0x100fe200078e020fULL, 0x000000001500720cULL, 0x000fe20003f46070ULL,
0x000000100c157824ULL, 0x000fe200078e020fULL, 0x0000001f0b0a7210ULL, 0x000fe20007f9e0ffULL,
0x00000001180c7824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000c101c46ULL, 0x0000000423147824ULL, 0x000fe200078e00ffULL,
0x000000281d197810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0612ULL,
0x0000000c21127210ULL, 0x000fc40007f1e0ffULL, 0x000000002300720cULL, 0x080fe20003f86070ULL,
0x0000000008137faeULL, 0x0005e2000c901c46ULL, 0x000000301d1b7810ULL, 0x040fe40007ffe0ffULL,
0x00005e00120c7a11ULL, 0x000fe200078c38ffULL, 0x000000000a157faeULL, 0x0007e2000d101c46ULL,
0x000000ffff077224ULL, 0x002fe200000e06ffULL, 0x0000001f0e067210ULL, 0x000fe40007fbe0ffULL,
0x000000381d1d7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0012127a11ULL, 0x000fe200030f3c07ULL,
0x000000ffff077224ULL, 0x000fe200028e0610ULL, 0xfffffffc14087812ULL, 0x004fe200078ee20dULL,
0x000000041d147824ULL, 0x000fe200078e00ffULL, 0x000000001700720cULL, 0x000fc40003f66070ULL,
0x000000001900720cULL, 0x080fe20003f46070ULL, 0x0000001008097824ULL, 0x000fe200078e020fULL,
0x000000001b00720cULL, 0x080fe20003f26070ULL, 0x0000000118087824ULL, 0x040fe200078e021bULL,
0x000000001d00720cULL, 0x000fe20003f06070ULL, 0x0000000118007824ULL, 0x040fe200078e0219ULL,
0x0000000006097faeULL, 0x0003e2000e101c46ULL, 0x00000001180a7824ULL, 0x008fe200078e021dULL,
0x00000008210e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000419087824ULL, 0x000fe200078e00ffULL,
0x0000000021107210ULL, 0x000fe20007fbe0ffULL, 0x0000000417007824ULL, 0x000fe200078e00ffULL,
0x0000000a210b7210ULL, 0x000fe20007fde0ffULL, 0x000000041b0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x000fc400078ee20dULL, 0xfffffffc00007812ULL, 0x100fe400078ee20dULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee20dULL, 0x000000ffff077224ULL, 0x002fe200028e06ffULL,
0xfffffffc14067812ULL, 0x000fe200078ee20dULL, 0x0000001000117824ULL, 0x100fe200078e020fULL,
0x00005e0010097a11ULL, 0x000fe200078a38ffULL, 0x0000001008137824ULL, 0x100fe400078e020fULL,
0x000000100a157824ULL, 0x000fe200078e020fULL, 0x00005f0010107a11ULL, 0x000fe200028f3c07ULL,
0x00000010060f7824ULL, 0x000fe200078e020fULL, 0x0000001f0c067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x00005e000e0a7a11ULL, 0x000fe200078838ffULL,
0x000000ffff007224ULL, 0x000fe200030e06ffULL, 0x00005e000b0c7a11ULL, 0x000fe200078c38ffULL,
0x000000ffff077224ULL, 0x000fe200028e0612ULL, 0x0000001f09087210ULL, 0x000fc40007fbe0ffULL,
0x00005f000e0d7a11ULL, 0x000fe400020f3c0dULL, 0x0000001f0a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0610ULL, 0x00005f000b007a11ULL, 0x000fe200030f3c00ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe400020e060dULL, 0x0000000008137faeULL, 0x0003e4000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fc400028e0600ULL, 0x000000000a157faeULL, 0x0003e8000c901c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001842007211ULL, 0x04afe400078ff0ffULL, 0x0000000842157811ULL, 0x040fe400078ff0ffULL,
0x0000000021007210ULL, 0x000fe40007f1e0ffULL, 0x0000001042067811ULL, 0x000fc400078ff0ffULL,
0x0000001842087811ULL, 0x000fe200078ff0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0000167a11ULL, 0x000fe400078038ffULL, 0x00000020420b7811ULL, 0x000fe200078ff0ffULL,
0x0000000118097824ULL, 0x000fe200078e0208ULL, 0x00005f0000227a11ULL, 0x000fe200000f3c07ULL,
0x0000000115007824ULL, 0x000fe200078e0218ULL, 0x00000028420d7811ULL, 0x000fe200078ff0ffULL,
0x0000000118077824ULL, 0x000fe200078e0206ULL, 0x00000003ff137819ULL, 0x100fe20000011642ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x00000030420f7811ULL, 0x000fe200078ff0ffULL,
0x00000001180c7824ULL, 0x000fe200078e020bULL, 0x0000003842117811ULL, 0x000fe200078ff0ffULL,
0x000000040d147824ULL, 0x000fe200078e00ffULL, 0x0000000313137812ULL, 0x000fe200078e4842ULL,
0x000000040f247824ULL, 0x000fe200078e00ffULL, 0x0000000021207210ULL, 0x040fe20007fde0ffULL,
0x00000001180e7824ULL, 0x040fe200078e020dULL, 0x00000007211c7210ULL, 0x040fe20007fbe0ffULL,
0x0000000118107824ULL, 0x040fe200078e020fULL, 0x00000009211a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000118127824ULL, 0x000fe200078e0211ULL, 0x0000100036237811ULL, 0x000fe200078e68ffULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0xfffffffc08077812ULL, 0x100fe200078ee213ULL,
0x000000ffff0d7224ULL, 0x000fe200030e06ffULL, 0x0000000c21187210ULL, 0x000fe20007f3e0ffULL,
0x000000040b0c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc14097812ULL, 0x000fe200078ee213ULL,
0x00000010071b7824ULL, 0x000fe200078e0223ULL, 0x00005e00201e7a11ULL, 0x000fe200078c38ffULL,
0x0000000415007824ULL, 0x000fe200078e00ffULL, 0xfffffffc240b7812ULL, 0x000fe200078ee213ULL,
0x00000010091f7824ULL, 0x000fe200078e0223ULL, 0x0000001021107210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000001221127210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0xfffffffc06067812ULL, 0x000fe200078ee213ULL,
0x0000000411267824ULL, 0x000fe200078e00ffULL, 0x00005f0020207a11ULL, 0x000fe200030f3c0dULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e00180f7a11ULL, 0x000fe200078238ffULL,
0x0000001006197824ULL, 0x100fe200078e0223ULL, 0x0000000e210e7210ULL, 0x000fe20007f5e0ffULL,
0x000000100b217824ULL, 0x000fe200078e0223ULL, 0x00005e001a0d7a11ULL, 0x000fe200078038ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x000000300a247812ULL, 0x000fc400078ec0ffULL,
0x00005e001c0b7a11ULL, 0x000fe400078a38ffULL, 0xfffffffc00007812ULL, 0x000fe400078ee213ULL,
0x00005f0018187a11ULL, 0x000fe200008f3c07ULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x00005f001a1a7a11ULL, 0x000fe200000f3c09ULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0xfffffffc0c087812ULL, 0x000fe200078ee213ULL, 0x0000001000177824ULL, 0x000fe200078e0223ULL,
0x00005e0012147a11ULL, 0x000fc400078638ffULL, 0x0000001624067210ULL, 0x000fe20007f1e0ffULL,
0x00000010081d7824ULL, 0x000fe200078e0223ULL, 0x0ffffffc13427812ULL, 0x000fe400078ef842ULL,
0x00005f001c1c7a11ULL, 0x000fe400028f3c11ULL, 0xfffffffc260c7812ULL, 0x000fe200078ee213ULL,
0x0000001042257824ULL, 0x100fe200078e0223ULL, 0x00005e000e117a11ULL, 0x000fe400078238ffULL,
0x00005e0010137a11ULL, 0x000fe200078438ffULL, 0x000000100c237824ULL, 0x000fe200078e0223ULL,
0x00005f0012007a11ULL, 0x000fe200018f3c07ULL, 0x000000ffff077224ULL, 0x000fe200000e0622ULL,
0x00005f000e167a11ULL, 0x000fc400008f3c09ULL, 0x0000001e24087210ULL, 0x000fe40007f1e0ffULL,
0x00005f0010157a11ULL, 0x000fe200010f3c15ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006257faeULL, 0x0003e2000b901c46ULL, 0x0000000b240a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0620ULL, 0x0000000d240c7210ULL, 0x040fe40007f5e0ffULL,
0x0000000f240e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e061cULL,
0x0000001124107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061aULL,
0x0000001324127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e0618ULL,
0x0000001424147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0616ULL,
0x0000000008177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400028e0615ULL,
0x000000ffff157224ULL, 0x000fe200000e0600ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x00f60400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002036007824ULL, 0x002fc800078e0205ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000000f006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105077812ULL, 0x040fe400078efcffULL, 0x0000000705057812ULL, 0x100fe400078e7800ULL,
0x0000000707077812ULL, 0x000fc600078e7800ULL, 0x0000000105057824ULL, 0x000fe400078e0206ULL,
0x0000000106077824ULL, 0x000fc600078e0207ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001005007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff047f8cULL, 0x002fe8000c80043fULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000023500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000317919ULL, 0x000e620000000000ULL,
0x3db504f332327820ULL, 0x020fe20000410000ULL, 0x0000640033337a24ULL, 0x000fe200078e02ffULL,
0x0000f68836377811ULL, 0x000fe200078e18ffULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0xffffffff02387810ULL, 0x000fe40007ffe0ffULL, 0x0000f60836397811ULL, 0x000fe400078e28ffULL,
0x00000100353d7824ULL, 0x000fe200078e022eULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000003d3400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e003bULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000100257810ULL, 0x000fe20007ffe0ffULL, 0x00000d9000007945ULL, 0x000fe20003800000ULL,
0x000000013f3b7812ULL, 0x000fe200078e0cffULL, 0x000000302d497224ULL, 0x020fe200078e02ffULL,
0x00000001ff247819ULL, 0x000fc40000011625ULL, 0x000000022500780cULL, 0x040fe40003f06070ULL,
0x0000000125567812ULL, 0x000fe200078ec0ffULL, 0x0000030024277a24ULL, 0x000fe400078e0235ULL,
0x000000ffff247224ULL, 0x000fe400078e0000ULL, 0x0000010027407824ULL, 0x040fe200078e022eULL,
0x0000000127297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff007224ULL, 0x000fc600078e0025ULL,
0x000000022900720cULL, 0x000fe40003f26070ULL, 0x0000004040267812ULL, 0x000fca00078ec0ffULL,
0x000000012f447824ULL, 0x000fcc00078e0226ULL, 0x000006b000009947ULL, 0x000fea0003800000ULL,
0x00000002ff417819ULL, 0x002fe20000011631ULL, 0x0000000456487824ULL, 0x000fc600078e00ffULL,
0x00000010414e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000141257824ULL, 0x140fe200078e0244ULL,
0x0000000841467810ULL, 0x040fe40007ffe0ffULL, 0x0000001841507810ULL, 0x000fe20007ffe0ffULL,
0x000000014e277824ULL, 0x100fe200078e0244ULL, 0x00000025493e7210ULL, 0x040fe20007f3e0ffULL,
0x0000000146267824ULL, 0x000fe200078e0244ULL, 0x0000004034257217ULL, 0x000fe20007800000ULL,
0x00000004464f7824ULL, 0x000fe200078e00ffULL, 0x00000027492b7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x0000002649297210ULL, 0x000fe20007f5e0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a40ULL, 0x00005e003e267a11ULL, 0x000fe200078238ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078638ffULL,
0x000000ffff3c7224ULL, 0x000fe200010e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078438ffULL,
0x0000000450557824ULL, 0x040fe200078e00ffULL, 0x00005f002b2b7a11ULL, 0x000fe200018f3c3aULL,
0x00000001503a7824ULL, 0x000fe200078e0244ULL, 0x0000002041517810ULL, 0x000fc40007ffe0ffULL,
0x0000003841547810ULL, 0x040fe40007ffe0ffULL, 0x0000002841527810ULL, 0x040fe40007ffe0ffULL,
0x00005f003e277a11ULL, 0x000fe400008f3c27ULL, 0x0000003041537810ULL, 0x000fe20007ffe0ffULL,
0x00000001523e7824ULL, 0x000fe200078e0244ULL, 0x00005f0029297a11ULL, 0x000fe200010f3c3cULL,
0x00000001513c7824ULL, 0x100fe200078e0244ULL, 0x0000003a49427210ULL, 0x000fe20007f3e0ffULL,
0x00000001543a7824ULL, 0x100fe200078e0244ULL, 0x000000254100720cULL, 0x000fe20003f46070ULL,
0x0000000153417824ULL, 0x000fe200078e0244ULL, 0x00000003ff447819ULL, 0x000fe20000011631ULL,
0x000000ffff477224ULL, 0x000fe200008e06ffULL, 0x0000003c49437210ULL, 0x000fc40007fbe0ffULL,
0x00005e0042407a11ULL, 0x000fe400078238ffULL, 0x0000003a493c7210ULL, 0x040fe20007f7e0ffULL,
0x00000002363a7824ULL, 0x000fe200078e023bULL, 0x0000003e49457210ULL, 0x040fe40007fde0ffULL,
0x00000041493e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x00000003444c7812ULL, 0x000fe200078e4831ULL, 0x000000ffff447224ULL, 0x000fe200028e06ffULL,
0x00005f0042417a11ULL, 0x000fe200008f3c47ULL, 0x000000ffff4a7224ULL, 0x000fe200030e06ffULL,
0x000000254600720cULL, 0x000fe20003f26070ULL, 0x000000ffff477224ULL, 0x000fe200020e06ffULL,
0x000010003a3a7811ULL, 0x000fc400078e60ffULL, 0x0ffffffc4c4d7812ULL, 0x100fe400078ef831ULL,
0xfffffffc484b7812ULL, 0x000fe400078ee231ULL, 0xfffffffc4f4f7812ULL, 0x000fe200078ee24cULL,
0x000000104d4d7824ULL, 0x000fe200078e023aULL, 0x00005e0043427a11ULL, 0x000fe200078a38ffULL,
0x000000104b267825ULL, 0x000fe200078e0026ULL, 0x00005e003e467a11ULL, 0x000fe400078638ffULL,
0x00005f0043437a11ULL, 0x000fe200028f3c44ULL, 0x000000104f4f7824ULL, 0x000fe200078e023aULL,
0x00005e0045447a11ULL, 0x000fe200078a38ffULL, 0x000000104b287825ULL, 0x000fe200078e0028ULL,
0x00005e003c487a11ULL, 0x000fe200078838ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000264d7faeULL, 0x0003e2000d101c46ULL, 0x00005f0045457a11ULL, 0x000fc400028f3c4aULL,
0x00005f003e477a11ULL, 0x000fe200018f3c47ULL, 0x00000000284f7faeULL, 0x0005e2000c901c46ULL,
0x00005f003c497a11ULL, 0x000fe400020f3c49ULL, 0x000000254e00720cULL, 0x080fe40003f26070ULL,
0x000000255000720cULL, 0x080fe40003f46070ULL, 0x000000255100720cULL, 0x0c0fe20003f66070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x000000255200720cULL, 0x0c0fe20003f86070ULL,
0x0000000452277824ULL, 0x002fe200078e00ffULL, 0x000000255300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000453537824ULL, 0x000fe200078e00ffULL, 0x000000255400720cULL, 0x000fe20003fc6070ULL,
0x000000044e257824ULL, 0x000fe200078e00ffULL, 0xfffffffc554d7812ULL, 0x100fe200078ee24cULL,
0x0000000454297824ULL, 0x004fe200078e00ffULL, 0xfffffffc514f7812ULL, 0x000fc400078ee24cULL,
0xfffffffc25257812ULL, 0x000fe200078ee24cULL, 0x000000104d4d7824ULL, 0x000fe200078e023aULL,
0xfffffffc27517812ULL, 0x000fe200078ee24cULL, 0x000000104b267825ULL, 0x000fe200078e002aULL,
0xfffffffc53537812ULL, 0x100fe400078ee24cULL, 0xfffffffc29557812ULL, 0x000fe200078ee24cULL,
0x0000001025257824ULL, 0x000fe400078e023aULL, 0x000000104b287825ULL, 0x000fc600078e0040ULL,
0x0000000026257faeULL, 0x0003e2000c901c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e023aULL,
0x000000104b2a7825ULL, 0x000fe200078e0042ULL, 0x00000000284d7faeULL, 0x0003e6000d101c46ULL,
0x0000001051517824ULL, 0x000fe200078e023aULL, 0x000000002a4f7faeULL, 0x0003e2000d901c46ULL,
0x000000104b407825ULL, 0x000fc800078e0044ULL, 0x0000001053537824ULL, 0x000fe200078e023aULL,
0x0000000040517faeULL, 0x0003e2000e101c46ULL, 0x000000104b427825ULL, 0x000fc800078e0046ULL,
0x0000001055557824ULL, 0x000fe200078e023aULL, 0x0000000042537faeULL, 0x0003e2000e901c46ULL,
0x000000104b447825ULL, 0x000fca00078e0048ULL, 0x0000000044557faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008312b7811ULL, 0x042fe200078ff0ffULL,
0x0000000456527824ULL, 0x000fe200078e00ffULL, 0x0000004431257211ULL, 0x040fe400078ff0ffULL,
0x0000001031417811ULL, 0x000fe200078ff0ffULL, 0x000000012b267824ULL, 0x000fe200078e0244ULL,
0x0000002549277210ULL, 0x000fe20007f3e0ffULL, 0x000000042b4f7824ULL, 0x000fe200078e00ffULL,
0x0000001831437811ULL, 0x000fe400078ff0ffULL, 0x0000002649257210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00005e0027267a11ULL, 0x000fc400078238ffULL,
0x0000002031457811ULL, 0x000fe200078ff0ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005e0025287a11ULL, 0x000fe400078438ffULL, 0x00005f0027277a11ULL, 0x000fe200008f3c3aULL,
0x00000001452b7824ULL, 0x000fe200078e0244ULL, 0x00005f0025297a11ULL, 0x000fe200010f3c2aULL,
0x0000000236257824ULL, 0x000fe200078e023bULL, 0x00000003ff3a7819ULL, 0x000fe20000011631ULL,
0x00000001432a7824ULL, 0x000fe200078e0244ULL, 0x0000002831477811ULL, 0x000fe200078ff0ffULL,
0x0000000443437824ULL, 0x000fe200078e00ffULL, 0x00000030314b7811ULL, 0x000fe200078ff0ffULL,
0x0000000445457824ULL, 0x000fe200078e00ffULL, 0x00000038314d7811ULL, 0x000fc400078ff0ffULL,
0x0000100025557811ULL, 0x000fe200078e60ffULL, 0x0000000141257824ULL, 0x100fe200078e0244ULL,
0x000000033a407812ULL, 0x100fe200078e4831ULL, 0x00000001473a7824ULL, 0x100fe200078e0244ULL,
0xfffffffc52577812ULL, 0x000fe200078ee231ULL, 0x000000014b3c7824ULL, 0x100fe200078e0244ULL,
0x0000002549257210ULL, 0x000fe20007f7e0ffULL, 0x000000014d3e7824ULL, 0x000fe200078e0244ULL,
0xfffffffc4f447812ULL, 0x100fe200078ee240ULL, 0x0000000441417824ULL, 0x000fe200078e00ffULL,
0xfffffffc43487812ULL, 0x100fe200078ee240ULL, 0x0000000447477824ULL, 0x000fe200078e00ffULL,
0xfffffffc454a7812ULL, 0x100fe200078ee240ULL, 0x000000044b4b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc41467812ULL, 0x100fe200078ee240ULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc474c7812ULL, 0x100fe200078ee240ULL, 0x000000104a4f7824ULL, 0x100fe200078e0255ULL,
0xfffffffc4b4e7812ULL, 0x100fe200078ee240ULL, 0x00000010464b7824ULL, 0x100fe200078e0255ULL,
0xfffffffc4d507812ULL, 0x000fe200078ee240ULL, 0x00000010484d7824ULL, 0x000fe200078e0255ULL,
0x0ffffffc40427812ULL, 0x000fe200078ef831ULL, 0x000000ffff407224ULL, 0x000fe200018e06ffULL,
0x0000002a49417210ULL, 0x000fe20007f5e0ffULL, 0x0000001057267825ULL, 0x000fe200078e0026ULL,
0x00005e00252a7a11ULL, 0x000fc400078c38ffULL, 0x0000002b49437210ULL, 0x000fe20007f3e0ffULL,
0x0000001042597824ULL, 0x100fe200078e0255ULL, 0x00005f00252b7a11ULL, 0x000fe200030f3c40ULL,
0x000000ffff427224ULL, 0x000fe200010e06ffULL, 0x0000003a493a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0x00005e0041407a11ULL, 0x000fe200078438ffULL,
0x0000001044257824ULL, 0x000fe200078e0255ULL, 0x0000003c493c7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x0000003e493e7210ULL, 0x000fe20007fbe0ffULL,
0x0000001057287825ULL, 0x000fe200078e0028ULL, 0x00005f0041417a11ULL, 0x000fe200010f3c42ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026597faeULL, 0x0003e2000b901c46ULL,
0x00005e0043427a11ULL, 0x000fe200078238ffULL, 0x000000ffff477224ULL, 0x000fe200020e06ffULL,
0x00005e003a447a11ULL, 0x000fe200078438ffULL, 0x000000ffff497224ULL, 0x000fe200028e06ffULL,
0x00005e003c467a11ULL, 0x000fe200078638ffULL, 0x00000010572a7825ULL, 0x000fe200078e002aULL,
0x00005e003e487a11ULL, 0x000fe200078838ffULL, 0x0000000028257faeULL, 0x0003e2000b901c46ULL,
0x00005f0043437a11ULL, 0x000fe200008f3c4aULL, 0x0000001057407825ULL, 0x040fe200078e0040ULL,
0x00005f003a457a11ULL, 0x000fe200010f3c45ULL, 0x000000002a4b7faeULL, 0x0003e2000b901c46ULL,
0x00005f003c477a11ULL, 0x000fe200018f3c47ULL, 0x0000001057427825ULL, 0x000fe200078e0042ULL,
0x00005f003e497a11ULL, 0x000fe200020f3c49ULL, 0x00000000404d7faeULL, 0x0003e4000b901c46ULL,
0x000000104c517824ULL, 0x000fc400078e0255ULL, 0x0000001057447825ULL, 0x040fe200078e0044ULL,
0x00000000424f7faeULL, 0x0003e6000b901c46ULL, 0x000000104e537824ULL, 0x000fe200078e0255ULL,
0x0000000044517faeULL, 0x0003e2000b901c46ULL, 0x0000001057467825ULL, 0x000fc800078e0046ULL,
0x0000001050557824ULL, 0x000fe200078e0255ULL, 0x0000000046537faeULL, 0x0003e2000b901c46ULL,
0x0000001057487825ULL, 0x000fca00078e0048ULL, 0x0000000048557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5600720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff257624ULL, 0x002fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000002252c7824ULL, 0x000fca00078e022cULL, 0x000000032c00720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000233267824ULL, 0x000fe400078e022cULL,
0x00000004ff277424ULL, 0x000fc800078e00ffULL, 0x0000600026267625ULL, 0x000fca00078e0027ULL,
0x00000006262d7981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008243c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff831247812ULL, 0x040fe200078ec0ffULL, 0x0000000236267824ULL, 0x002fe200078e023fULL,
0x0000002031287810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000724247812ULL, 0x000fe400078ef831ULL, 0xfffffff828287812ULL, 0x000fc400078ec0ffULL,
0x00000001ff257819ULL, 0x000fe40000011624ULL, 0x00000007283e7812ULL, 0x000fe400078ef831ULL,
0x0000000325257812ULL, 0x000fe400078ec0ffULL, 0x0000100026267811ULL, 0x000fe400078e60ffULL,
0x0000003a25277212ULL, 0x000fe400078e3cffULL, 0x00000001ff287819ULL, 0x000fc4000001163eULL,
0x000000013a407810ULL, 0x000fe20007ffe0ffULL, 0x0000000424277824ULL, 0x000fe200078e0227ULL,
0x0000000328417812ULL, 0x000fe400078ec0ffULL, 0x0000004025257212ULL, 0x000fe200078e3cffULL,
0x0000001027277824ULL, 0x100fe200078e0226ULL, 0x0000003a41297212ULL, 0x000fe400078e3cffULL,
0x0000000731427812ULL, 0x040fe200078ec0ffULL, 0x0000000424257824ULL, 0x000fe200078e0225ULL,
0x000000002748783bULL, 0x0002a20000000200ULL, 0x0000003c31247211ULL, 0x000fe200078fe0ffULL,
0x000000043e297824ULL, 0x000fe200078e0229ULL, 0x0000000842467812ULL, 0x000fe200078ef831ULL,
0x0000001025427824ULL, 0x100fe200078e0226ULL, 0x0000000224257810ULL, 0x040fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e0226ULL, 0x0000000724247812ULL, 0x000fc400078e7846ULL,
0x0000004041277212ULL, 0x002fe400078e3cffULL, 0x0000000725257812ULL, 0x000fe200078e7846ULL,
0x00000010464f7824ULL, 0x000fe200078e0224ULL, 0x000000002928783bULL, 0x000e620000000200ULL,
0x000000043e277824ULL, 0x000fe200078e0227ULL, 0x000000023a3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001046467824ULL, 0x000fe200078e0225ULL, 0x000000004240783bULL, 0x000fe20000000200ULL,
0x0000001027277824ULL, 0x000fe200078e0226ULL, 0x000000043a00780cULL, 0x000fc40003f25270ULL,
0x000000043c3c7810ULL, 0x000fc60007ffe0ffULL, 0x000000002724783bULL, 0x000ee20000000200ULL,
0x00000010ff507819ULL, 0x104fe40000011648ULL, 0x00000018ff3e7819ULL, 0x000fe40000011648ULL,
0x000000ff48477812ULL, 0x040fe400078ec0ffULL, 0x0000ffff48717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x100fe40000011649ULL, 0x00000018ff487819ULL, 0x000fc40000011649ULL,
0x000000ff494c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff49727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff527819ULL, 0x100fe4000001164aULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x000000ff4a4d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4a737812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x00000010ff587819ULL, 0x102fe40000011628ULL,
0x00000018ff547819ULL, 0x000fe40000011628ULL, 0x000000ff28557812ULL, 0x040fe400078ec0ffULL,
0x0000ffff28847812ULL, 0x000fe400078ec0ffULL, 0x00000010ff287819ULL, 0x008fc40000011624ULL,
0x00000018ff7b7819ULL, 0x000fe40000011624ULL, 0x000000ff247c7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff24457812ULL, 0x000fe400078ec0ffULL, 0x00000008ff247819ULL, 0x000fe40000011671ULL,
0x00000010ff537819ULL, 0x000fe4000001164bULL, 0x000000ff4b4e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4b747812ULL, 0x000fe400078ec0ffULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x100fe40000011640ULL, 0x00000018ff4b7819ULL, 0x000fe20000011640ULL,
0x2000004aff607230ULL, 0x000fe20000004100ULL, 0x000000ff405e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40857812ULL, 0x000fc400078ec0ffULL, 0x000000ff426d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x100fe40000011625ULL, 0x00000018ff7e7819ULL, 0x000fe40000011625ULL,
0x000000ff257f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff25407812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fc400020006ffULL, 0x00000008ff257819ULL, 0x000fe40000011672ULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x0000006dff4a723eULL, 0x000fe200020006ffULL,
0x20000024ff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff43707812ULL, 0x000fe200078ec0ffULL,
0x2000004cff6b7230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fc40000011673ULL,
0x00000070ff4c723eULL, 0x000fe200020006ffULL, 0x20000025ff707230ULL, 0x000fe20000004100ULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000008ff257819ULL, 0x000fe20000011674ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x100fe2000001162aULL,
0x20000024ff727230ULL, 0x000fe20000004100ULL, 0x00000018ff597819ULL, 0x000fe4000001162aULL,
0x000000ff2a5a7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2a627812ULL, 0x000fe400078ec0ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000003eff2a723eULL, 0x000fe200020006ffULL, 0x20000025ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff247819ULL, 0x000fe40000011685ULL, 0x0000ffff41867812ULL, 0x000fe200078ec0ffULL,
0x2000002aff6f7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x000000ff29577812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001162bULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000008ff257819ULL, 0x000fe40000011686ULL,
0x0000ffff42877812ULL, 0x000fe400078ec0ffULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x0000004eff2a723eULL, 0x000fe400020006ffULL, 0x0000005eff4e723eULL, 0x000fe200020006ffULL,
0x2000005dff5e7230ULL, 0x000fe20000004100ULL, 0x00000018ff5f7819ULL, 0x000fe20000011641ULL,
0x20000024ff5d7230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000047ff6c7230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x2000002aff2a7230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x20000057ff7a7230ULL, 0x000fe20000004100ULL, 0x00000018ff567819ULL, 0x000fe20000011629ULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe20000011687ULL,
0x20000025ff577230ULL, 0x000fe20000004100ULL, 0x0000ffff43887812ULL, 0x000fc400078ec0ffULL,
0x0000005fff47723eULL, 0x000fe200020006ffULL, 0x2000005bff5f7230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000024ff5b723eULL, 0x000fe200020006ffULL,
0x000000104f247824ULL, 0x000fe200078e00ffULL, 0x00000008ff257819ULL, 0x000fe20000011688ULL,
0x20000056ff7d7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe20000011641ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x000000ff41667812ULL, 0x000fe200078ec0ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff777819ULL, 0x000fc40000011642ULL,
0x00000018ff677819ULL, 0x000fe40000011642ULL, 0x00000010ff787819ULL, 0x100fe40000011643ULL,
0x00000018ff6e7819ULL, 0x000fe40000011643ULL, 0x00000010ff3e7819ULL, 0x100fe40000011626ULL,
0x00000018ff807819ULL, 0x000fe40000011626ULL, 0x000000ff26817812ULL, 0x000fc400078ec0ffULL,
0x0000ffff26417812ULL, 0x000fe400078ec0ffULL, 0x00000010ff427819ULL, 0x100fe40000011627ULL,
0x00000018ff827819ULL, 0x000fe40000011627ULL, 0x000000ff27837812ULL, 0x040fe400078ec0ffULL,
0x0000ffff27437812ULL, 0x000fe400078ec0ffULL, 0x00000025ff56723eULL, 0x000fc400020006ffULL,
0x000000002424783bULL, 0x000e620000000200ULL, 0x000000ff50507812ULL, 0x000fe400078ec0ffULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe400020006ffULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x2000004dff647230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe20000011629ULL,
0x2000004bff4d7230ULL, 0x000fe20000004100ULL, 0x0000006eff4b723eULL, 0x000fe200020006ffULL,
0x20000050ff6e7230ULL, 0x000fe20000004100ULL, 0x0000ffff29697812ULL, 0x000fc400078ec0ffULL,
0x0000007bff4f723eULL, 0x000fe200020006ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x0000007cff50723eULL, 0x000fe400020006ffULL, 0x000000ff687c7812ULL, 0x000fe200078ec0ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000008ff7b7819ULL, 0x000fe20000011669ULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x000fc4000001166fULL, 0x00000010ff697819ULL, 0x000fe4000001166eULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x0000105468697816ULL, 0x000fe20000000069ULL, 0x20000048ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x20000051ff717230ULL, 0x000fe20000004100ULL,
0x000000ff52527812ULL, 0x000fc400078ec0ffULL, 0x000010546d687816ULL, 0x000fe4000000006cULL,
0x000000ff2b5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff53537812ULL, 0x000fe400078ec0ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x00000068240c723cULL, 0x002fe2000004180cULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fc400020006ffULL,
0x00000008ff627819ULL, 0x000fe20000011662ULL, 0x20000049ff657230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000055ff767230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x20000063ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe2000001162bULL,
0x20000052ff737230ULL, 0x000fe20000004100ULL, 0x00000066ff48723eULL, 0x000fe200020006ffULL,
0x20000059ff667230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000054ff797230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x000000ff61617812ULL, 0x000fe200078ec0ffULL,
0x20000053ff757230ULL, 0x000fe20000004100ULL, 0x000000ff78787812ULL, 0x000fc400078ec0ffULL,
0x000000ff77777812ULL, 0x000fe400078ec0ffULL, 0x000000ff58597812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe40000011684ULL,
0x00000061ff55723eULL, 0x000fe200020006ffULL, 0x2000005cff617230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x20000062ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000000ff29637812ULL, 0x000fc400078ec0ffULL, 0x00000078ff54723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff297819ULL, 0x000fe20000011672ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000077ff5c723eULL, 0x000fe400020006ffULL,
0x00000059ff78723eULL, 0x000fe400020006ffULL, 0x00000058ff77723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x000010546a717816ULL, 0x000fe20000000071ULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe20000011665ULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fc40000011673ULL,
0x00000063ff6a723eULL, 0x000fe400020006ffULL, 0x0000105429647816ULL, 0x000fe40000000064ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe40000011675ULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff297819ULL, 0x000fc40000011674ULL, 0x0000ffff2b2b7812ULL, 0x000fe400078ec0ffULL,
0x0000105462657816ULL, 0x000fe40000000065ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000105460637816ULL, 0x000fe40000000063ULL, 0x0000105429627816ULL, 0x000fe2000000002aULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff297819ULL, 0x000fe2000001162bULL,
0x000000642404723cULL, 0x000fe20000041804ULL, 0x00000010ff2a7819ULL, 0x000fc40000011679ULL,
0x00000010ff2b7819ULL, 0x000fe40000011678ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x000000622420723cULL, 0x000fe20000041820ULL,
0x000010542a2b7816ULL, 0x000fe4000000002bULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00001054772a7816ULL, 0x000fc40000000076ULL, 0x00000029ff60723eULL, 0x000fe200020006ffULL,
0x0000001046297824ULL, 0x000fe200078e00ffULL, 0x000000ff28627812ULL, 0x000fe200078ec0ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff287819ULL, 0x000fe2000001167dULL,
0x0000002a241c723cULL, 0x000fe2000004181cULL, 0x00000010ff637819ULL, 0x000fe2000001167cULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x0000105428637816ULL, 0x000fc40000000063ULL, 0x000000002928783bULL, 0x000e620000000200ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000062ff46723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x000010547b627816ULL, 0x000fe2000000007aULL,
0x20000046ff647230ULL, 0x000fe20000004100ULL, 0x0000105470707816ULL, 0x000fc4000000006bULL,
0x00000067ff49723eULL, 0x000fe200020006ffULL, 0x2000005aff677230ULL, 0x000fe20000004100ULL,
0x00000008ff467819ULL, 0x000fe20000011645ULL, 0x000000622414723cULL, 0x040fe20000041814ULL,
0x00000010ff457819ULL, 0x000fe2000001166aULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x000000ff44627812ULL, 0x000fe200078ec0ffULL, 0x000000702408723cULL, 0x000fe20000041808ULL,
0x00000010ff447819ULL, 0x000fc4000001165fULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x0000105444457816ULL, 0x000fe40000000045ULL,
0x0000105466697816ULL, 0x000fc40000000069ULL, 0x0000105468687816ULL, 0x000fe40000000067ULL,
0x0000105460447816ULL, 0x000fe40000000061ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x000000682418723cULL, 0x000fe20000041818ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff5b7819ULL, 0x000fc4000001165bULL,
0x00000046ff46723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x000000442410723cULL, 0x000fe20000041810ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000008ff407819ULL, 0x000fe40000011640ULL,
0x000010544d5f7816ULL, 0x000fe4000000005eULL, 0x00000010ff247819ULL, 0x000fc40000011647ULL,
0x00000010ff257819ULL, 0x000fe40000011655ULL, 0x00000010ff267819ULL, 0x000fe40000011649ULL,
0x0000105424257816ULL, 0x000fe40000000025ULL, 0x0000105457247816ULL, 0x000fe40000000048ULL,
0x00000010ff277819ULL, 0x000fe4000001165cULL, 0x00000010ff4c7819ULL, 0x000fc4000001164cULL,
0x0000105426277816ULL, 0x000fe20000000027ULL, 0x000000242808723cULL, 0x042fe20000041808ULL,
0x000010545b267816ULL, 0x000fe4000000004aULL, 0x00000010ff4d7819ULL, 0x000fe40000011654ULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff247819ULL, 0x000fe2000001164bULL,
0x000000262804723cULL, 0x000fe20000041804ULL, 0x00000010ff257819ULL, 0x000fc40000011656ULL,
0x0000007eff51723eULL, 0x000fe400020006ffULL, 0x0000007fff52723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000008ff417819ULL, 0x000fe20000011641ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00001054244d7816ULL, 0x000fe2000000004dULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00001054254c7816ULL, 0x000fc4000000004cULL, 0x0000003eff3e723eULL, 0x000fe400020006ffULL,
0x00000010ff247819ULL, 0x000fe4000001164fULL, 0x00000010ff507819ULL, 0x000fe20000011650ULL,
0x2000003eff447230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe20000011664ULL,
0x0000004c2820723cULL, 0x000fe20000041820ULL, 0x00000010ff257819ULL, 0x000fe40000011646ULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x00000080ff53723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000041ff3e7230ULL, 0x000fe20000004100ULL,
0x000000ff42427812ULL, 0x000fe200078ec0ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000008ff437819ULL, 0x000fe20000011643ULL, 0x20000081ff587230ULL, 0x000fe20000004100ULL,
0x0000105424277816ULL, 0x000fe40000000027ULL, 0x0000105425267816ULL, 0x000fc40000000050ULL,
0x00000082ff5a723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x00000026281c723cULL, 0x000fe2000004181cULL,
0x00000010ff247819ULL, 0x000fe20000011651ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011662ULL, 0x20000083ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fc40000011640ULL, 0x00000043ff43723eULL, 0x000fe400020006ffULL,
0x0000105424417816ULL, 0x000fe40000000041ULL, 0x0000105425407816ULL, 0x000fe20000000052ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe40000011653ULL,
0x00000010ff277819ULL, 0x000fe40000011644ULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x000000402814723cULL, 0x000fe20000041814ULL, 0x00000010ff257819ULL, 0x000fc4000001163eULL,
0x0000105424277816ULL, 0x000fe40000000027ULL, 0x0000105425267816ULL, 0x000fe40000000058ULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff5a7819ULL, 0x000fe2000001165aULL, 0x000000262818723cULL, 0x000fe20000041818ULL,
0x00000010ff257819ULL, 0x000fc40000011642ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff247819ULL, 0x000fe40000011643ULL, 0x000010545d5e7816ULL, 0x000fe4000000004eULL,
0x000010545a257816ULL, 0x000fe40000000025ULL, 0x0000105424247816ULL, 0x000fc60000000059ULL,
0x0000005e280c723cULL, 0x040ff0000004180cULL, 0x000000242810723cULL, 0x000fe20000041810ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe82000007947ULL, 0x000fec000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff3f7224ULL, 0x000fe200078e003bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd92000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000037247f8cULL, 0x000fe2000c80043fULL, 0x0000002132217220ULL, 0x040fe20000410000ULL,
0x0000000e32007220ULL, 0x040fe20000410000ULL, 0x0000000f32267220ULL, 0x040fe20000410000ULL,
0x0000040037277984ULL, 0x000e620000000800ULL, 0x0000002232227220ULL, 0x040fe20000410000ULL,
0x0000001d321d7220ULL, 0x040fe20000410000ULL, 0x00000017322b7220ULL, 0x040fe20000410000ULL,
0x0000000c320c7220ULL, 0x040fe20000410000ULL, 0x0000000d320d7220ULL, 0x040fe20000410000ULL,
0x0000000a32287220ULL, 0x040fe20000410000ULL, 0x0000000b32297220ULL, 0x040fe20000410000ULL,
0x00000004320e7220ULL, 0x040fe20000410000ULL, 0x00000005320f7220ULL, 0x040fe20000410000ULL,
0x0000002032207220ULL, 0x040fe20000410000ULL, 0x0000002332237220ULL, 0x040fe20000410000ULL,
0x00000016322a7220ULL, 0x040fe20000410000ULL, 0x0000001932177220ULL, 0x040fe20000410000ULL,
0x0000000832087220ULL, 0x040fe20000410000ULL, 0x0000000932097220ULL, 0x040fe20000410000ULL,
0x0000000632067220ULL, 0x040fe20000410000ULL, 0x0000000732077220ULL, 0x040fe20000410000ULL,
0x0000001c321c7220ULL, 0x040fe20000410000ULL, 0x0000001e32047220ULL, 0x040fe20000410000ULL,
0x0000001f32057220ULL, 0x040fe20000410000ULL, 0x0000001a323a7220ULL, 0x040fe20000410000ULL,
0x0000001b323c7220ULL, 0x040fe20000410000ULL, 0x0000001132197220ULL, 0x040fe20000410000ULL,
0x0000001832167220ULL, 0x040fe20000410000ULL, 0x00000013323f7220ULL, 0x040fe20000410000ULL,
0x000000ffff117224ULL, 0x000fe200078e0021ULL, 0x0000001032187220ULL, 0x040fe20000410000ULL,
0x000000ffff137224ULL, 0x000fe200078e001dULL, 0x00000012323e7220ULL, 0x040fe20000410000ULL,
0x000000ffff217224ULL, 0x000fe200078e0022ULL, 0x0000001432147220ULL, 0x040fe20000410000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000cULL, 0x0000001532157220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fc400078e000dULL, 0x000000ffff107224ULL, 0x000fe400078e0020ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0026ULL, 0x8000000027ff7812ULL, 0x002fe20007804825ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0028ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0029ULL,
0x000000ffff227224ULL, 0x000fe400078e0023ULL, 0x000000ffff277224ULL, 0x000fc400078e002aULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff127224ULL, 0x000fe400078e001cULL, 0x000000ffff1a7224ULL, 0x000fe400078e0000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0006ULL, 0x000000ffff207224ULL, 0x000fc400078e0007ULL,
0x000000ffff237224ULL, 0x000fe400078e0004ULL, 0x000000ffff267224ULL, 0x000fe400078e0005ULL,
0x000000ffff287224ULL, 0x000fe400078e002bULL, 0x000000ffff297224ULL, 0x000fe400078e003aULL,
0x000000ffff2a7224ULL, 0x000fe200078e003cULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fc400078e003eULL,
0x000000ffff3a7224ULL, 0x000fe200078e003fULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x0000040037057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004311c7824ULL, 0x000fe200078e00ffULL,
0x000000383500720cULL, 0x000fc80003f05270ULL, 0xfffffff01c057812ULL, 0x000fca00078ec0ffULL,
0x0000008036007824ULL, 0x000fca00078e0205ULL, 0x00f4000000047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000231087824ULL, 0x000fe400078e00ffULL,
0x00000001343d7824ULL, 0x000fc600078e0a3dULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108247812ULL, 0x040fe400078efcffULL, 0x00000008083c7812ULL, 0x000fe400078efcffULL,
0x0000003d2400720cULL, 0x080fe40003f26070ULL, 0x0000001008247812ULL, 0x000fe400078efcffULL,
0x0000003d3c00720cULL, 0x080fe40003f06070ULL, 0x0000003d2400720cULL, 0x000fc40003fc6070ULL,
0x00000011083c7812ULL, 0x040fe400078efcffULL, 0x0000001808247812ULL, 0x040fe400078efcffULL,
0x0000003d0800720cULL, 0x080fe40003f46070ULL, 0x0000003d3c00720cULL, 0x080fe40003fa6070ULL,
0x0000003d2400720cULL, 0x000fe40003f66070ULL, 0x00000009083e7812ULL, 0x000fc400078efcffULL,
0x00000019083c7812ULL, 0x040fe400078efcffULL, 0x0000002008247812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x0000003d3e00720cULL, 0x080fe40003f86070ULL, 0x0000003d3c00720cULL, 0x080fe40003f46070ULL,
0x0000003d2400720cULL, 0x000fe40003f26070ULL, 0x00000021083c7812ULL, 0x040fe400078efcffULL,
0x0000002808247812ULL, 0x000fe400078efcffULL, 0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000003d3c00720cULL, 0x080fe40003f06070ULL,
0x0000003d2400720cULL, 0x000fe40003f86070ULL, 0x00000029083c7812ULL, 0x000fc400078efcffULL,
0x0000003008247812ULL, 0x000fe400078efcffULL, 0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000003d3c00720cULL, 0x000fc40003fc6070ULL,
0x0000003d2400720cULL, 0x000fe40003fa6070ULL, 0x00000031083c7812ULL, 0x040fe400078efcffULL,
0x0000003808247812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000003d3c00720cULL, 0x080fe40003f66070ULL, 0x0000003d2400720cULL, 0x000fc40003f46070ULL,
0x0000003d0800720cULL, 0x000fe40003f26070ULL, 0xff7fffff26267808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff27277808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff28287808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff29297808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff2b2b7808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff3a3a7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff407424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002a05047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002b04057209ULL, 0x000fe40007810000ULL, 0x00000019083d7209ULL, 0x000fe40007810000ULL,
0x0000003a053e7209ULL, 0x000fe20007810000ULL, 0x000017e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f003d047f89ULL, 0x0004e400000e0000ULL, 0x000000043d3d7209ULL, 0x00cfe20007810000ULL,
0x000018127f007947ULL, 0x000fea000b800000ULL, 0x0c401f003e047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f0007247f89ULL, 0x000f2200000e0000ULL,
0x000000043e087209ULL, 0x004fc60007810000ULL, 0x0c201f003d047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000002407247209ULL, 0x010fc60007810000ULL, 0x0c201f00093c7f89ULL, 0x002e6800000e0000ULL,
0x0c201f0024257f89ULL, 0x00092200000e0000ULL, 0x000000043d047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000003c09067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x00000004ff3c7e24ULL, 0x002fe2000f8e00ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05197820ULL, 0x000fe20000410000ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3f8000003c3c783eULL, 0x000fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010819ULL, 0x000000ffff3d7224ULL, 0x000fe200078e003cULL,
0x0000000a00097308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b3a197823ULL, 0x000fe20000010819ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fce00000010ffULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f220000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x010fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000003c0840723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000003c0c40723cULL, 0x000fee0000041840ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc31147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002700277308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f280000004000ULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x000000232611723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000272813723eULL, 0x004fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000051dff7c12ULL, 0x008fe2000f80401eULL,
0x0000003c1040723cULL, 0x000fec0000041840ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ea20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x004fe400000010ffULL, 0x0000002425077209ULL, 0x000fca0007810000ULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x00000019001a7308ULL, 0x000ea20000000800ULL,
0x000000292a15723eULL, 0x002fe400000010ffULL, 0x0000002b1a17723eULL, 0x004fce00000010ffULL,
0x0000003c1440723cULL, 0x000fe20000041840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000132204008947ULL, 0x010fde000b800000ULL, 0x001c1fff40187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051dff7c12ULL, 0x008fda000f80401aULL,
0x0000134204008947ULL, 0x010fea000b800000ULL, 0x001c1fff42197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe40000011631ULL, 0x0000000c1c437812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x0000000331ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d3c7824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d4c7824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f287812ULL, 0x140fe400078ef61eULL,
0x000000051f2a7812ULL, 0x140fe400078ef61eULL, 0x000000061f3a7812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x00009000361d7811ULL, 0x000fe400078e58ffULL, 0xfffffff8233e7812ULL, 0x100fe400078ee21eULL,
0x000000011f407812ULL, 0x140fe200078ef61eULL, 0x00000010201c7824ULL, 0x000fe200078e021dULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee221ULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f427812ULL, 0x140fe200078ef61eULL, 0x0000001028247824ULL, 0x100fe200078e021dULL,
0x000000031f447812ULL, 0x140fe200078ef61eULL, 0x000000103a287824ULL, 0x100fe200078e021dULL,
0x000000041f467812ULL, 0x140fe200078ef61eULL, 0x00000010403a7824ULL, 0x100fe200078e021dULL,
0x000000051f487812ULL, 0x140fe200078ef61eULL, 0x00000010443d7824ULL, 0x100fe200078e021dULL,
0x000000061f4a7812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x000000102a267824ULL, 0x100fe400078e021dULL,
0x00000001431f7824ULL, 0x000fe400078e021cULL, 0x000000103c2a7824ULL, 0x100fe400078e021dULL,
0x000000103e1c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x00000010423c7824ULL, 0x000fc400078e021dULL, 0x00000010463e7824ULL, 0x100fe400078e021dULL,
0x00000010483f7824ULL, 0x100fe400078e021dULL, 0x000000104a407824ULL, 0x100fe400078e021dULL,
0x000000104c417824ULL, 0x000fe400078e021dULL, 0x00000001431d7824ULL, 0x040fe400078e021eULL,
0x0000000143217824ULL, 0x000fc400078e0220ULL, 0x0000000143237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x0000000143257824ULL, 0x040fe400078e0224ULL,
0x0000000143277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000143297824ULL, 0x040fe400078e0228ULL, 0x00000001432b7824ULL, 0x040fe200078e022aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x00000001431c7824ULL, 0x000fc400078e021cULL,
0x00000001433a7824ULL, 0x040fe200078e023aULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001433c7824ULL, 0x040fe400078e023cULL, 0x0000000143087824ULL, 0x042fe200078e023dULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x00000001433e7824ULL, 0x040fe400078e023eULL,
0x00000001431e7824ULL, 0x040fe200078e023fULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000143407824ULL, 0x000fc400078e0240ULL, 0x0000000143207824ULL, 0x000fe200078e0241ULL,
0x000000162b007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b3a007388ULL, 0x0007e80000000800ULL, 0x0000000d3c007388ULL, 0x0007e80000000800ULL,
0x0000000f08007388ULL, 0x0007e80000000800ULL, 0x000000113e007388ULL, 0x0007e80000000800ULL,
0x000000131e007388ULL, 0x0007e80000000800ULL, 0x0000001540007388ULL, 0x0007e80000000800ULL,
0x0000001720007388ULL, 0x0007e80000000800ULL, 0x00f0000400008388ULL, 0x0007e80000000c00ULL,
0x00f2001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000039ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080039ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100039ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030035357a10ULL, 0x000fe20007ffe0ffULL, 0x0000180039ff7f8cULL, 0x0003e6000c80043fULL,
0x000000023500720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffbd9000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x000141b000247802ULL, 0x000fe40000000f00ULL,
0x00000f3000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0028ULL,
0xfffed84000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40004000000ULL,
0x0001420000247802ULL, 0x000fe40000000f00ULL, 0x00000ee000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0xfffed88000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x000fe200078e0000ULL, 0x0001427000247802ULL, 0x002fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fc400078e00ffULL,
0x00000e3000007944ULL, 0x03cfea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e002aULL,
0xfffed8d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e0000ULL,
0x000142e000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000dc000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xfffed89000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x000fe200078e0026ULL, 0x0001435000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x00000d5000007944ULL, 0x030fea0003c00000ULL, 0x000000ffff5f7224ULL, 0x004fe200078e002aULL,
0xfffedbf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e004cULL,
0x000143c000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xfffedbb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x010fe40004000000ULL, 0x0001441000247802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xfffefe5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40004000000ULL,
0x0001446000247802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xfffefe9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x008fe200078e00ffULL, 0x000144c000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fc400078e00ffULL, 0x00000be000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xfffeff0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x00afe200078e004cULL, 0x0001453000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x00000b7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xfffeffb000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x0001459000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x00000b1000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6d7224ULL, 0x004fe200078e002aULL,
0xffff027000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e004cULL,
0x0001460000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x00000aa000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xffff022000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x004fe40004000000ULL, 0x0001465000247802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff230000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40004000000ULL,
0x000146a000247802ULL, 0x000fc40000000f00ULL, 0x00000a4000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff234000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x002fe200078e00ffULL, 0x0001470000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fc400078e00ffULL, 0x000009a000007944ULL, 0x038fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff23b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x002fe200078e004cULL, 0x0001477000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000093000007944ULL, 0x038fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xffff246000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x000147d000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x000008d000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff577224ULL, 0x004fe200078e002aULL,
0xffff271000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e004cULL,
0x0001484000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000086000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xffff26c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x010fe40004000000ULL, 0x0001489000247802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff468000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40004000000ULL,
0x000148e000247802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff46c000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6f7424ULL, 0x008fe200078e00ffULL, 0x0001494000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff707424ULL, 0x000fc400078e00ffULL, 0x0000076000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff473000007947ULL, 0x000fea000383ffffULL,
0x000000ffff6e7224ULL, 0x00afe200078e004cULL, 0x000149b000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff6f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x000006f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xffff47e000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6f7424ULL, 0x000fe200078e00ffULL,
0x00014a1000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff707424ULL, 0x000fe400078e00ffULL,
0x0000069000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e002aULL,
0xffff4aa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff6e7224ULL, 0x002fe200078e004cULL,
0x00014a8000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff6f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff707424ULL, 0x000fe400078e00ffULL, 0x0000062000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xffff4a5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e003dULL, 0x00014ae000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x000fc400078e00ffULL, 0x0000058000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0025ULL, 0xffffe7d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e003eULL, 0x00014b4000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000052000007944ULL, 0x020fea0003c00000ULL,
0x000000253e3e7209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x00014b9000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff3c7424ULL, 0x002fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0007ULL, 0x00014be000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002507247209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e003dULL,
0x00014c3000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x000000253d047209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e003eULL, 0x00014c8000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x000000253e057209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x00014cd000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff3c7424ULL, 0x002fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x00014d2000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff3c7424ULL, 0x002fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffe69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e0040ULL,
0x00014d9000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff6e7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff6f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff707224ULL, 0x000fe400078e001dULL,
0x0000031000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e002aULL,
0xffffec7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0042ULL,
0x00014e1000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff6e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff6f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff707224ULL, 0x000fe400078e001dULL,
0x0000029000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff6e7224ULL, 0x002fe200078e00ffULL,
0x00014e7000247802ULL, 0x000fe20000000f00ULL, 0x00001c1fff6f7424ULL, 0x000fc400078e00ffULL,
0x000000ffff707224ULL, 0x000fe400078e001dULL, 0x000000ffff197224ULL, 0x004fe400078e002aULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff707224ULL, 0x002fe200078e001dULL,
0x00014ed000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff6e7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff6f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e002aULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e002aULL,
0xffffebb000007947ULL, 0x000fea000383ffffULL, 0x018000003b037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003b00038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff087807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000308ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff3bff7812ULL, 0x040fe4000780c0ffULL,
0x800000003b057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000308ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003b00037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffeafa006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000004000007348ULL, 0x000fe80003800000ULL,
0x0c00003c25257389ULL, 0x0002a200000e003fULL, 0xfffeaf6008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff257424ULL, 0x000fe200078e00ffULL, 0x0000007000007348ULL, 0x000fe80003800000ULL,
0x0000006e2b2a7389ULL, 0x0002a200000e006fULL, 0xfffeaf2024007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f05070ULL, 0x0000004a00007348ULL, 0x000fd80003800000ULL,
0x0000000000257806ULL, 0x000fc800040e0100ULL, 0x0000004a25287212ULL, 0x000fe200078ec0ffULL,
0x00000000ff257424ULL, 0x000fc800078e00ffULL, 0xfffeaec024007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000468ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a48ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ad8ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001358ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001378ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001388ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013a8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001438ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001440ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001450ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000015200ULL, 0xaf00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016880ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000016890ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016890ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016d10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001438ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015448ULL, 0x0000000000015448ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016880ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016d10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_8_m_8_sm_89_cubin_len = 93680;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
