/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000007ce0ULL, 0x00000000000078a0ULL, 0x00380040005a0d5aULL, 0x0001001100400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL, 0x65722e0061686d5fULL, 0x2e747865742e616cULL,
0x6d5f6c656e72656bULL, 0x756265642e006168ULL, 0x00656d6172665f67ULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x6f632e766e2e616cULL, 0x0034746e6174736eULL,
0x2e6c65722e000000ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x5f67756265642e61ULL,
0x6e2e00656d617266ULL, 0x72676c6c61632e76ULL, 0x2e766e2e00687061ULL, 0x7079746f746f7270ULL,
0x6f632e766e2e0065ULL, 0x2e30746e6174736eULL, 0x6d5f6c656e72656bULL, 0x0000000000006168ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x732e000000000000ULL, 0x0062617472747368ULL, 0x006261747274732eULL, 0x006261746d79732eULL,
0x5f6261746d79732eULL, 0x6e2e0078646e6873ULL, 0x2e006f666e692e76ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL, 0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL,
0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL, 0x6f632e766e2e0061ULL, 0x0033746e6174736eULL,
0x4d34456b00000000ULL, 0x6e2e0058414d5f33ULL, 0x6c61626f6c672e76ULL, 0x6d730074696e692eULL,
0x2e00657a69536d65ULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL, 0x79546c656e72656bULL,
0x0000000000006570ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7265746e695f5f24ULL,
0x5f245f305f6c616eULL, 0x6d735f616475635fULL, 0x725f7063725f3032ULL, 0x33665f7a74665f6eULL,
0x6170776f6c735f32ULL, 0x2e6c65722e006874ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e006369702e74ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x72656b0065707974ULL, 0x0061686d5f6c656eULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e000300000089ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000100000099ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0003000000a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e0001000000b3ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d0022000000d3ULL, 0x00000000000064d0ULL,
0x0000000000000230ULL, 0x0004000300000131ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000700030000018cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d1012000001a8ULL,
0x0000000000000000ULL, 0x0000000000006700ULL, 0x00100003000001b3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x0000002cffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000064d000000000ULL, 0x0000500400000000ULL,
0x0400288080810c00ULL, 0x00000000000018d0ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL, 0x0000001cffffffffULL,
0x0000006800000000ULL, 0x000064d000000000ULL, 0x0000023000000000ULL, 0x0000000000000000ULL,
0x0000000c00082f04ULL, 0x0008120400000034ULL, 0x0000000000000009ULL, 0x0000000900081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000f80008ULL,
0x00000000000c1704ULL, 0x0021f00000f00007ULL, 0x00000000000c1704ULL, 0x0201f00000700006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00381b0380005003ULL, 0x000001d000043104ULL, 0xffffffff007c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000001d0007c2804ULL, 0x000020a000001fd0ULL,
0x0000218000002110ULL, 0x00004120000021f0ULL, 0x0000417000004150ULL, 0x000041b000004180ULL,
0x000041f0000041d0ULL, 0x0000423000004200ULL, 0x0000427000004250ULL, 0x000046d000004280ULL,
0x0000472000004710ULL, 0x0000476000004730ULL, 0x000047a000004780ULL, 0x000047f0000047b0ULL,
0x0000482000004810ULL, 0x00004f4000004830ULL, 0x0000034005903904ULL, 0x00009340000000ffULL,
0x0000037000040100ULL, 0x00009348000000ffULL, 0x0000039000040100ULL, 0x00009350000000ffULL,
0x000003d000040100ULL, 0x00009358000000ffULL, 0x000003f000040100ULL, 0x00009360000000ffULL,
0x0000041000040100ULL, 0x00009368000000ffULL, 0x0000043000040100ULL, 0x00009370000000ffULL,
0x0000045000040100ULL, 0x00009378000000ffULL, 0x0000047000040100ULL, 0x00009380000000ffULL,
0x0000049000040100ULL, 0x00009388000000ffULL, 0x000004b000040100ULL, 0x00009390000000ffULL,
0x000004d000040100ULL, 0x00009398000000ffULL, 0x000004f000040100ULL, 0x000093a0000000ffULL,
0x0000051000040100ULL, 0x000093a8000000ffULL, 0x0000053000040100ULL, 0x000093b0000000ffULL,
0x0000055000040100ULL, 0x000093b8000000ffULL, 0x0000097000040100ULL, 0x000093780000000bULL,
0x000009a0003f0101ULL, 0x000093780000000bULL, 0x00000c60003f0109ULL, 0x000093580000000bULL,
0x00000c90003f0101ULL, 0x000093580000000bULL, 0x00001090003f0109ULL, 0x0000934800000003ULL,
0x000010b0003f0101ULL, 0x0000934800000003ULL, 0x00001bd0003f0109ULL, 0x0000934000000003ULL,
0x00001c30003f0101ULL, 0x0000937800000003ULL, 0x00001c50003f0101ULL, 0x0000938800000003ULL,
0x00001c60003f0101ULL, 0x0000939800000003ULL, 0x00001c70003f0101ULL, 0x000093a800000003ULL,
0x00001ca0003f0101ULL, 0x000093b800000003ULL, 0x00001cb0003f0101ULL, 0x000093b800000003ULL,
0x00001e70003f0109ULL, 0x0000937000000007ULL, 0x00001ea0003f0109ULL, 0x0000939000000009ULL,
0x00001f20003f0101ULL, 0x0000939000000009ULL, 0x00001fa0003f0109ULL, 0x000093b800000003ULL,
0x00002260003f0101ULL, 0x000093b800000003ULL, 0x000024a0003f0109ULL, 0x000093b800000003ULL,
0x00002540003f0101ULL, 0x000093b800000003ULL, 0x00002980003f0109ULL, 0x000093b800000003ULL,
0x000029f0003f0101ULL, 0x000093b800000003ULL, 0x00003540003f0109ULL, 0x000093b800000003ULL,
0x00003580003f0101ULL, 0x000093b800000003ULL, 0x00003650003f0109ULL, 0x000093b800000003ULL,
0x00003660003f0101ULL, 0x000093b800000003ULL, 0x00003850003f0109ULL, 0x0000939800000005ULL,
0x00003860003f0101ULL, 0x0000937800000005ULL, 0x000038e0003f0101ULL, 0x0000934800000003ULL,
0x00003900003f0101ULL, 0x0000935800000003ULL, 0x00003910003f0101ULL, 0x0000936800000003ULL,
0x00003930003f0101ULL, 0x000093b000000003ULL, 0x00003940003f0101ULL, 0x000093b000000003ULL,
0x00003960003f0109ULL, 0x0000934000000003ULL, 0x00003970003f0101ULL, 0x0000934000000003ULL,
0x00003ba0003f0109ULL, 0x0000935000000007ULL, 0x00003f50003f0109ULL, 0x000093580000000bULL,
0x000044a0003f0101ULL, 0x000093b000000003ULL, 0x000044e0003f0101ULL, 0x000093b000000003ULL,
0x00004520003f0109ULL, 0x000093b000000003ULL, 0x00004530003f0101ULL, 0x000093b000000003ULL,
0x00004920003f0109ULL, 0x000093980000000bULL, 0x00004930003f0101ULL, 0x000093980000000bULL,
0x00004ba0003f0109ULL, 0x000093900000000bULL, 0x00004bc0003f0101ULL, 0x0000934800000003ULL,
0x00004cf0003f0101ULL, 0x0000934000000003ULL, 0x00004df0003f0108ULL, 0x0000420000000000ULL,
0x00004e60003f0100ULL, 0x0000420800000000ULL, 0x00004f10003f0100ULL, 0x0000420800000000ULL,
0x000051a0003f0101ULL, 0x0000420800000003ULL, 0x000052a00007010aULL, 0x00004200000000ffULL,
0x0000559000080107ULL, 0x0000420000000005ULL, 0x00005a500007010aULL, 0x00004208000000ffULL,
0x00005d8000080101ULL, 0x0000420800000002ULL, 0x00005d90003f0108ULL, 0x0000420000000002ULL,
0x00005db0003f0108ULL, 0x000093780000000bULL, 0x00005e10003f0109ULL, 0x000093580000000bULL,
0x00005e70003f0109ULL, 0x0000934800000003ULL, 0x00005ed0003f0109ULL, 0x000093b800000003ULL,
0x00005f30003f0109ULL, 0x0000937000000007ULL, 0x00005f90003f0109ULL, 0x0000939000000009ULL,
0x00005ff0003f0109ULL, 0x000093b800000003ULL, 0x00006050003f0109ULL, 0x000093b800000003ULL,
0x000060b0003f0109ULL, 0x000093b800000003ULL, 0x00006110003f0109ULL, 0x000093b800000003ULL,
0x00006170003f0109ULL, 0x000093b000000003ULL, 0x000061d0003f0109ULL, 0x0000934000000003ULL,
0x00006230003f0109ULL, 0x0000935000000007ULL, 0x00006290003f0109ULL, 0x000093b000000003ULL,
0x000062f0003f0109ULL, 0x000093b000000003ULL, 0x00006350003f0109ULL, 0x000093980000000bULL,
0x000063e0003f0109ULL, 0x0000420800000003ULL, 0x00006470003f010aULL, 0x000042000000000fULL,
0x00123803003f010aULL, 0x0000013000141c04ULL, 0x00004d6000004d00ULL, 0x00005da000005d60ULL,
0x00000180000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0401001903ULL,
0x010002100000000dULL, 0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000700000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000500000002ULL, 0x0000000000000000ULL,
0x00000000000000c4ULL, 0x0000000c00000002ULL, 0x00000000000064d0ULL, 0x0000000000000044ULL,
0x0000000c00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL, 0x0000000c00000002ULL,
0x0000000000000000ULL, 0x0000000043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e240000000800ULL, 0x0000000000107919ULL, 0x000e620000002700ULL,
0x00008e00ff027b82ULL, 0x000e620000000a00ULL, 0x0000820000107ab9ULL, 0x000fe20000000a00ULL,
0x0000000410027825ULL, 0x002fca00078e0002ULL, 0x0000001002007981ULL, 0x000ea2000c1e1900ULL,
0x00000000001379c3ULL, 0x000e620000002500ULL, 0x0000030000067ab9ULL, 0x000fe20000000800ULL,
0x00000000000472caULL, 0x004fda00000e0000ULL, 0x0000003f04047890ULL, 0x000fc8000fffe03fULL,
0x000000063f127899ULL, 0x000fe40008011604ULL, 0x0000007f0400788cULL, 0x000fe4000bf04070ULL,
0x000000061200728cULL, 0x000fe4000bf21070ULL, 0x000000010600788cULL, 0x000fe40008704070ULL,
0x0000000612067287ULL, 0x000fe40008800000ULL, 0x0000003f13147287ULL, 0x002fc40008000000ULL,
0x0000000106067887ULL, 0x000fc80008000000ULL, 0x000000061400728cULL, 0x000fcc000bf26070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e620000002300ULL, 0x0000000600037d06ULL, 0x000ea20008209000ULL,
0x0000042000007945ULL, 0x000fe20003800000ULL, 0x0000000000087919ULL, 0x000e620000002200ULL,
0x0000000000027919ULL, 0x000eea0000002100ULL, 0x0000000300037308ULL, 0x004ea20000001000ULL,
0x0000000708ff7212ULL, 0x002fc8000780fcffULL, 0x000000200200780cULL, 0x008fda0000705670ULL,
0x00006600ff048b82ULL, 0x000e620000000a00ULL, 0x00000000003f7886ULL, 0x000fe20000020000ULL,
0x0000007004068810ULL, 0x002fc80007f3e0ffULL, 0x00000000060482caULL, 0x000fe200000e0000ULL,
0x000000ffff048224ULL, 0x000fe200008e0605ULL, 0x0000000207ff7212ULL, 0x000fe2000782fe08ULL,
0x0ffffffe03067836ULL, 0x004fc60000000000ULL, 0x00000000040582caULL, 0x000fc600000e0000ULL,
0x0000000600067305ULL, 0x000e68000021f000ULL, 0x00000004ff047e24ULL, 0x000fca000f8e00ffULL,
0x00000000040482caULL, 0x000fe200000e0000ULL, 0x00000005ff057e24ULL, 0x000fca000f8e00ffULL,
0x00000000050582caULL, 0x000fda00000e0000ULL, 0x00000000040099b9ULL, 0x0003e40008040000ULL,
0x0000000000b41947ULL, 0x002fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001ffe8000087882ULL, 0x000fe20000000000ULL,
0x7ffa000000097882ULL, 0x000fe20000000000ULL, 0x001fff00000a7882ULL, 0x000fe20000000000ULL,
0x7ffc0000000b7882ULL, 0x000fe20000000000ULL, 0x001ffefe000c7882ULL, 0x000fe20000000000ULL,
0x7ffbf800000d7882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x00934008043f75b2ULL, 0x000e620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00934808043f75b2ULL, 0x0004620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x001ffe0000087882ULL, 0x004fe20000000000ULL, 0x7ff8000000097882ULL, 0x000fe20000000000ULL,
0x0093500a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093580c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093600a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093680c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093700a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093780c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093800a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093880c043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00939008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00939808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093a008043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093a808043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093b00a043f75b2ULL, 0x0002620008000100ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0093b80a043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000060572caULL, 0x000fe200000e0000ULL,
0x800000063f087290ULL, 0x000fe2000fffe03fULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000143f077292ULL, 0x000fe2000f8e333fULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000003f0600728cULL, 0x000fc6000bf65070ULL, 0x0000003f00047c82ULL, 0x000fca0008000000ULL,
0x00000005080872a4ULL, 0x000fc8000f8e023fULL, 0x00000008050872a5ULL, 0x000fe4000f8e0004ULL,
0x0000001206047290ULL, 0x000fc8000fffe007ULL, 0x00000004090872a5ULL, 0x000fce000f8e003fULL,
0x0000000900057c82ULL, 0x000fe40008000000ULL, 0x0000003f05077290ULL, 0x000fe4000fffe13fULL,
0x00000000000879c3ULL, 0x000e640000008800ULL, 0x00000007060772a4ULL, 0x000fc8000f8e0204ULL,
0x000000060700728cULL, 0x000fd6000bf26070ULL, 0x0000000706071290ULL, 0x000fe4000fffe13fULL,
0x0000000105051890ULL, 0x000fe4000fffe03fULL, 0x000000060700728cULL, 0x000fc6000bf46070ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x0000065408077896ULL, 0x002fcc0008000007ULL,
0x0000000105052890ULL, 0x000fe2000fffe03fULL, 0x00000007ff037e24ULL, 0x000fe2000f8e00ffULL,
0x000000063f05b292ULL, 0x000fc6000f8e333fULL, 0x0000000402127824ULL, 0x000fe200078e0203ULL,
0x00000030005c8947ULL, 0x000ff00003800000ULL, 0x00000000000d7919ULL, 0x000e620000002600ULL,
0x000000010700780cULL, 0x000fe20003f05270ULL, 0x0000313000007945ULL, 0x000fd80003800000ULL,
0x0000001400208947ULL, 0x000fea0003800000ULL, 0x000000400200780cULL, 0x000fe40003f06070ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fca000001ff00ULL,
0x0000000400988947ULL, 0x000fea0003800000ULL, 0x000000400200780cULL, 0x000fe20003f05270ULL,
0x0000007f00047836ULL, 0x000fca0000000000ULL, 0x00000007ff097819ULL, 0x000fce0000011604ULL,
0x0000000000c88947ULL, 0x000fea0003800000ULL, 0x000000600200780cULL, 0x000fda0003f05270ULL,
0x0000003000140947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fe2000bf24070ULL,
0x0000000110107811ULL, 0x000fca00078e08ffULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000003000040947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fce00078e00ffULL,
0x00000014ff057e24ULL, 0x000fe4000f8e00ffULL, 0xffffffffff0e7424ULL, 0x000fe400078e00ffULL,
0x00000006080a7c24ULL, 0x000fca000f8e0205ULL, 0x00000001ff067819ULL, 0x000fc8000001160aULL,
0x000000090600720cULL, 0x000fda0003f06070ULL, 0x00009000ff078b82ULL, 0x000eb00000000800ULL,
0x00008c00ff048b82ULL, 0x000ee20000000a00ULL, 0x0000000710078224ULL, 0x004fe400078e0206ULL,
0x0000001008067824ULL, 0x000fca00078e00ffULL, 0x0000001006067812ULL, 0x000fe200078ec0ffULL,
0x0000000407048825ULL, 0x008fc800078e0004ULL, 0x00000001ff077424ULL, 0x000fe200078e00ffULL,
0x00000010040e8981ULL, 0x000562000c1e1900ULL, 0x00000001030b7824ULL, 0x000fe200078e0206ULL,
0x00000001080c7812ULL, 0x000fc600078ec0ffULL, 0x009378070b0679a7ULL, 0x000ee4000850003fULL,
0x000024000c0d7824ULL, 0x142fe400078e0203ULL, 0x000000100c0c7824ULL, 0x000fe200078e0203ULL,
0x009378070b0075a7ULL, 0x008e64000800017fULL, 0x0000005000fc8947ULL, 0x006fea0003800000ULL,
0x00000000000c79c3ULL, 0x000e620000002600ULL, 0x000000000a0b72caULL, 0x000fe200000e0000ULL,
0x00006600000e7ab9ULL, 0x000fe20000000a00ULL, 0x000000000d0872caULL, 0x000fe200000e0000ULL,
0x000000700e0e7890ULL, 0x000fe2000ff3e03fULL, 0x000000000c0972caULL, 0x000fe200000e0000ULL,
0x0000003f000a7c82ULL, 0x000fe20008000000ULL, 0x000000000e0d72caULL, 0x020fe200000e0000ULL,
0x0000000f3f0f7290ULL, 0x000fe20008ffe43fULL, 0x000000000000781cULL, 0x000fca0003f0f070ULL,
0x000000060b0b7899ULL, 0x000fe4000800063fULL, 0x0000440008087890ULL, 0x000fe4000fffe03fULL,
0x0000937009097890ULL, 0x000fe4000fffe03fULL, 0x000000400b0b7892ULL, 0x002fd8000f8ec03fULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x000000080e0075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x0000000108087836ULL, 0x000fca0000000000ULL,
0x0000000508007c0cULL, 0x000fda000bf06070ULL, 0xfffffffc00588947ULL, 0x001fea000383ffffULL,
0x0000002c00547947ULL, 0x000fea0003800000ULL, 0x000000040600728cULL, 0x000fe2000bf24070ULL,
0x0000900000077ab9ULL, 0x000fe40000000800ULL, 0x0000000710107c24ULL, 0x000fc6000f8e02ffULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000002c00400947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x00000014ff057e24ULL, 0x000fe4000f8e00ffULL,
0xffffffffff0e7424ULL, 0x000fe400078e00ffULL, 0x00000006080a7c24ULL, 0x000fca000f8e0205ULL,
0x00000001ff077819ULL, 0x000fc8000001160aULL, 0x000000090700720cULL, 0x000fda0003f06070ULL,
0x00008c00ff048b82ULL, 0x000ea20000000a00ULL, 0x0000001008067824ULL, 0x000fe200078e00ffULL,
0x0000000710078211ULL, 0x000fc800078e08ffULL, 0x0000001006067812ULL, 0x000fe200078ec0ffULL,
0x00000001ff0c7424ULL, 0x000fc800078e00ffULL, 0x00000001030b7824ULL, 0x000fe400078e0206ULL,
0x0000000407048825ULL, 0x004fca00078e0004ULL, 0x00000010040e8981ULL, 0x000562000c1e1900ULL,
0x0093580c0b0679a7ULL, 0x000724000850003fULL, 0x00000001080c7812ULL, 0x008fca00078ec0ffULL,
0x000000100c0d7824ULL, 0x002fe200078e0203ULL, 0x009358070b0075a7ULL, 0x010e64000800017fULL,
0x0000005000588947ULL, 0x006fea0003800000ULL, 0x00000000000c79c3ULL, 0x000e620000002600ULL,
0x000000000a0b72caULL, 0x000fe200000e0000ULL, 0x00006600000e7ab9ULL, 0x000fe20000000a00ULL,
0x000000000c0872caULL, 0x000fe200000e0000ULL, 0x000000700e0e7890ULL, 0x000fe2000ff3e03fULL,
0x00000000030772caULL, 0x000fe200000e0000ULL, 0x0000003f000a7c82ULL, 0x000fe20008000000ULL,
0x000000000d0972caULL, 0x000fe200000e0000ULL, 0x0000000f3f0f7290ULL, 0x000fe20008ffe43fULL,
0x000000000e0d72caULL, 0x020fe400000e0000ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x000000060b0b7899ULL, 0x000fc8000800063fULL, 0x0000000708087291ULL, 0x000fe4000f8e683fULL,
0x0000935009097890ULL, 0x000fe4000fffe03fULL, 0x000000400b0b7892ULL, 0x002fd8000f8ec03fULL,
0x00000000003f082fULL, 0x000fe20003820000ULL, 0x000000080e0075b4ULL, 0x0003d80008018000ULL,
0x000000000000181cULL, 0x000fe40000f0e170ULL, 0x000000000000781cULL, 0x000fd60003f2e170ULL,
0xfffffffd00ec0947ULL, 0x002fea000393ffffULL, 0x0000000108087836ULL, 0x000fca0000000000ULL,
0x0000000508007c0cULL, 0x000fda000bf06070ULL, 0xfffffffc005c8947ULL, 0x001fea000383ffffULL,
0x0000002800947947ULL, 0x000fea0003800000ULL, 0x00008800ff127b82ULL, 0x000ea20000000a00ULL,
0x0000840000077ab9ULL, 0x000fe40000000800ULL, 0x00000007100d7c24ULL, 0x002fc8000f8e020dULL,
0x000001000d117824ULL, 0x000fc800078e0202ULL, 0x0000001011047825ULL, 0x004fcc00078e0012ULL,
0x0000001004047981ULL, 0x000f62000c1e9d00ULL, 0x00000040021d7836ULL, 0x000fe20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fc600078e00ffULL,
0x000000ff1d00780cULL, 0x000fda0003f04070ULL, 0x0000000000680947ULL, 0x000fea0003800000ULL,
0x0000004011097836ULL, 0x000fc80000000000ULL, 0x0000001009087825ULL, 0x000fcc00078e0012ULL,
0x0000001008087981ULL, 0x000f62000c1e9d00ULL, 0x00000080020c7836ULL, 0x000fca0000000000ULL,
0x000000ff0c00780cULL, 0x000fda0003f24070ULL, 0x0000000000501947ULL, 0x000fea0003800000ULL,
0x000000c0020c7836ULL, 0x000fca0000000000ULL, 0x000000ff0c00780cULL, 0x000fda0003f24070ULL,
0x000000c0110d9836ULL, 0x000fc80000000000ULL, 0x000000100d0c9825ULL, 0x000fc800078e0012ULL,
0x0000008011117836ULL, 0x000fe40000000000ULL, 0x000000100c0c9981ULL, 0x000ea4000c1e9d00ULL,
0x0000001011127825ULL, 0x000fcc00078e0012ULL, 0x0000001012107981ULL, 0x000f62000c1e9d00ULL,
0x000100000c149824ULL, 0x004fe200078e00ffULL, 0x000000100e189819ULL, 0x000fe200000006ffULL,
0x000100000d169824ULL, 0x000fe200078e00ffULL, 0x000077320c0c9816ULL, 0x000fe200000000ffULL,
0x000100000f1a9824ULL, 0x000fe200078e00ffULL, 0x000077320d0d9816ULL, 0x000fe400000000ffULL,
0x000077320e0e9816ULL, 0x000fe200000000ffULL, 0x000100000c159824ULL, 0x000fe200078e00ffULL,
0x000077320f0f9816ULL, 0x000fe200000000ffULL, 0x000100000d179824ULL, 0x000fc400078e00ffULL,
0x000100000e199824ULL, 0x000fe400078e00ffULL, 0x000100000f1b9824ULL, 0x000fce00078e00ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0093481c030c79a7ULL, 0x000e62000850003fULL,
0x000000ff0200780cULL, 0x000fe20003f44070ULL, 0x0093480d030075a7ULL, 0x002e64000802017fULL,
0x0000004c00689947ULL, 0x002ff40003800000ULL, 0x00000af000017945ULL, 0x000fe80003800000ULL,
0x0000000800b42947ULL, 0x000fea0003800000ULL, 0x00007732040e7816ULL, 0x020fe200000000ffULL,
0x00010000050d7824ULL, 0x040fe200078e00ffULL, 0x00007732051f7816ULL, 0x000fe200000000ffULL,
0x00010000060c7824ULL, 0x000fe200078e00ffULL, 0x00000004ff057819ULL, 0x100fe20000011602ULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff1e7819ULL, 0x000fe20000011602ULL,
0x0001000004047824ULL, 0x000fe200078e00ffULL, 0x0000773206207816ULL, 0x000fe200000000ffULL,
0x00000008050f7824ULL, 0x000fe200078e00ffULL, 0x000000051e067212ULL, 0x000fc400078e3cffULL,
0x0000000eff0e723eULL, 0x000fe4000480710eULL, 0x0000773207217816ULL, 0x040fe400000000ffULL,
0xfffffff80f067812ULL, 0x000fe400078ee206ULL, 0x0000ffff0e057812ULL, 0x000fe200078ec0ffULL,
0x00010000070e7824ULL, 0x000fe200078e00ffULL, 0x0000000dff0f723eULL, 0x000fe2000480710fULL,
0x000000ffff0d7224ULL, 0x000fe200078e0020ULL, 0x0000000cff1e723eULL, 0x000fe2000480711eULL,
0x000000ffff077224ULL, 0x000fe200078e001fULL, 0x00000004ff04723eULL, 0x000fe20004807104ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0021ULL, 0x0000000eff0e723eULL, 0x000fe2000480710eULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x000000ff04047812ULL, 0x000fe200078ec0ffULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x000000100c0c7819ULL, 0x000fc400000006ffULL,
0x0000000dff0d723eULL, 0x000fe4000480710dULL, 0x00000007ff07723eULL, 0x000fe40004807107ULL,
0x0000000cff0c723eULL, 0x000fe4000480710cULL, 0x0000ffff0d1f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff0f0f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff1e1e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff0e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff07207812ULL, 0x000fe200078ec0ffULL,
0x0000001006077824ULL, 0x000fe200078e0203ULL, 0x0000ffff0c0d7812ULL, 0x000fe400078ec0ffULL,
0x0000760405057816ULL, 0x000fe40000000004ULL, 0x0000000102047812ULL, 0x000fe400078ec0ffULL,
0x0000760420207816ULL, 0x000fc4000000000fULL, 0x000076041f1e7816ULL, 0x000fe2000000001eULL,
0x0000000804077824ULL, 0x000fe200078e0207ULL, 0x000076040d0d7816ULL, 0x000fe4000000000eULL,
0x00005410050c7816ULL, 0x000fe40000000020ULL, 0x000054101e0d7816ULL, 0x000fca000000000dULL,
0x0088000c07007388ULL, 0x0003e20000000a00ULL, 0x0000000400f80947ULL, 0x000fea0003800000ULL,
0x0000773208057816ULL, 0x040fe200000000ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x00007732090d7816ULL, 0x042fe200000000ffULL, 0x0001000009067824ULL, 0x000fe200078e00ffULL,
0x00000004ff077819ULL, 0x100fe2000001161dULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe2000001161dULL, 0x000100000a097824ULL, 0x040fe200078e00ffULL,
0x000077320a0e7816ULL, 0x000fe400000000ffULL, 0x00000008ff08723eULL, 0x000fc40004807108ULL,
0x00000005ff0a723eULL, 0x000fe4000480710aULL, 0x000000070c0c7212ULL, 0x000fe200078e3cffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x000000ff08057812ULL, 0x000fe200078ec0ffULL,
0x000100000b087824ULL, 0x040fe200078e00ffULL, 0x0000ffff0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000077320b0f7816ULL, 0x000fe400000000ffULL, 0x000076040a057816ULL, 0x000fc40000000005ULL,
0xfffffff8070c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff077224ULL, 0x000fe200078e000dULL,
0x00000006ff0a723eULL, 0x000fe2000480710aULL, 0x000000ffff067224ULL, 0x000fe200078e000eULL,
0x00000009ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x000000ff0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000009097824ULL, 0x000fe200078e00ffULL,
0x00000007ff07723eULL, 0x000fc40004807107ULL, 0x00000006ff06723eULL, 0x000fe40004807106ULL,
0x00000009ff09723eULL, 0x000fe40004807109ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff070d7812ULL, 0x000fe200078ec0ffULL, 0x000000100c077824ULL, 0x000fe200078e0203ULL,
0x0000ffff06067812ULL, 0x000fe400078ec0ffULL, 0x0000ffff09097812ULL, 0x000fe200078ec0ffULL,
0x0000000804077824ULL, 0x000fe200078e0207ULL, 0x000076040d0a7816ULL, 0x000fc4000000000aULL,
0x00007604060b7816ULL, 0x000fe4000000000bULL, 0x0000760409087816ULL, 0x000fe40000000008ULL,
0x00005410050a7816ULL, 0x000fe4000000000aULL, 0x000054100b0b7816ULL, 0x000fe40000000008ULL,
0x0000008002097810ULL, 0x000fc60007ffe0ffULL, 0x0088000a07007388ULL, 0x0003e20000000a00ULL,
0x000000ff0900780cULL, 0x000fda0003f04070ULL, 0x0000000400380947ULL, 0x002fea0003800000ULL,
0x0000773210057816ULL, 0x040fe200000000ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00000004ff087819ULL, 0x100fe20000011609ULL, 0x0001000011067824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011609ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000010ff10723eULL, 0x000fe20004807110ULL, 0x00000008080a7824ULL, 0x000fe200078e00ffULL,
0x0000000809097212ULL, 0x000fe200078e3cffULL, 0x0001000012077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fe20004807105ULL, 0x0001000013087824ULL, 0x000fe200078e00ffULL,
0x0000773211117816ULL, 0x000fc400000000ffULL, 0x0000773212127816ULL, 0x000fe400000000ffULL,
0x000000ff10107812ULL, 0x000fe400078ec0ffULL, 0x0000ffff05057812ULL, 0x000fe400078ec0ffULL,
0x0000773213137816ULL, 0x000fe400000000ffULL, 0xfffffff80a0a7812ULL, 0x000fe400078ee209ULL,
0x0000760405107816ULL, 0x000fe20000000010ULL, 0x000000ffff057224ULL, 0x000fe200078e0011ULL,
0x00000006ff09723eULL, 0x000fe20004807109ULL, 0x000000ffff067224ULL, 0x000fe200078e0012ULL,
0x00000007ff0b723eULL, 0x000fe2000480710bULL, 0x000000ffff077224ULL, 0x000fe200078e0013ULL,
0x00000008ff08723eULL, 0x000fe20004807108ULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x000000ff09097812ULL, 0x000fe200078ec0ffULL, 0x0001000006067824ULL, 0x000fe200078e00ffULL,
0x000000ff0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0001000007077824ULL, 0x000fe200078e00ffULL,
0x00000005ff05723eULL, 0x000fc40004807105ULL, 0x00000006ff06723eULL, 0x000fe40004807106ULL,
0x00000007ff07723eULL, 0x000fe40004807107ULL, 0x000000ff08087812ULL, 0x000fe400078ec0ffULL,
0x0000ffff050c7812ULL, 0x000fe200078ec0ffULL, 0x000000100a057824ULL, 0x000fe200078e0203ULL,
0x0000ffff06067812ULL, 0x000fe400078ec0ffULL, 0x0000ffff07077812ULL, 0x000fe200078ec0ffULL,
0x0000000804057824ULL, 0x000fe200078e0205ULL, 0x000076040c097816ULL, 0x000fc40000000009ULL,
0x0000760406067816ULL, 0x000fe4000000000bULL, 0x0000760407077816ULL, 0x000fe40000000008ULL,
0x0000541010107816ULL, 0x000fe40000000009ULL, 0x0000541006117816ULL, 0x000fe20000000007ULL,
0x000000c002067836ULL, 0x000fc80000000000ULL, 0x0088001005007388ULL, 0x0003e20000000a00ULL,
0x000000ff0600780cULL, 0x000fda0003f04070ULL, 0x0000000000780947ULL, 0x002fea0003800000ULL,
0x00000004ff057819ULL, 0x100fe40000011606ULL, 0x00000001ff067819ULL, 0x000fe40000011606ULL,
0x0000001aff1a723eULL, 0x000fe4000480711aULL, 0x0000000506067212ULL, 0x000fe200078e3cffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x0000001bff1b723eULL, 0x000fe4000480711bULL,
0x00000014ff14723eULL, 0x000fc40004807114ULL, 0x00000015ff15723eULL, 0x000fe40004807115ULL,
0x00000016ff16723eULL, 0x000fe40004807116ULL, 0x00000017ff17723eULL, 0x000fe40004807117ULL,
0x00000018ff18723eULL, 0x000fe40004807118ULL, 0x00000019ff19723eULL, 0x000fe40004807119ULL,
0xfffffff805067812ULL, 0x000fc400078ee206ULL, 0x000000ff1a1a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff1b1b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff14147812ULL, 0x000fe400078ec0ffULL,
0x000000ff16167812ULL, 0x000fe400078ec0ffULL, 0x000000ff18187812ULL, 0x000fe400078ec0ffULL,
0x0000ffff17177812ULL, 0x000fc400078ec0ffULL, 0x0000ffff15157812ULL, 0x000fe400078ec0ffULL,
0x0000ffff19197812ULL, 0x000fe400078ec0ffULL, 0x0000000306057211ULL, 0x000fe400078e20ffULL,
0x000076041b1a7816ULL, 0x000fe4000000001aULL, 0x0000760417167816ULL, 0x000fe20000000016ULL,
0x0000000804057824ULL, 0x000fe200078e0205ULL, 0x0000760415157816ULL, 0x000fc40000000014ULL,
0x0000760419197816ULL, 0x000fe40000000018ULL, 0x0000541015167816ULL, 0x000fe40000000016ULL,
0x0000541019177816ULL, 0x000fca000000001aULL, 0x0088001605007388ULL, 0x0003e40000000a00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0093401c03ff79a7ULL, 0x0005e2000850003fULL,
0x0000001c00247947ULL, 0x000fea0003800000ULL, 0x00009400ff067b82ULL, 0x000ea40000000a00ULL,
0x0000001006067981ULL, 0x004562000c1e9900ULL, 0x0000000f0200780cULL, 0x000fe20003f04070ULL,
0x00000001ff047424ULL, 0x000fc800078e00ffULL, 0x0093780403ff79a7ULL, 0x0005f0000850003fULL,
0xff7fffffff098424ULL, 0x000fe200078e00ffULL, 0x0093880403ff79a7ULL, 0x0005e2000850003fULL,
0x0093980403ff79a7ULL, 0x0005e2000850003fULL, 0x0093a80403ff79a7ULL, 0x0005e4000850003fULL,
0x0092c00912008388ULL, 0x0005e80000000800ULL, 0x009300ff12008388ULL, 0x0005e20000000800ULL,
0x0093b804030479a7ULL, 0x000ee4000850003fULL, 0x0093b805030075a7ULL, 0x008ee4000800017fULL,
0x0000004000808947ULL, 0x00cfea0003800000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x000000040600728cULL, 0x000fcc000bf24070ULL,
0x000000000000781cULL, 0x000fda0003f0f018ULL, 0x0000001800d80947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000ea20000000000ULL, 0x3b12492506117820ULL, 0x020fe20000410000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0xffffffff060d7890ULL, 0x000fd8000fffe03fULL,
0x000000100f047824ULL, 0x040fe200078e00ffULL, 0x000000010f147812ULL, 0x000fe200078ec0ffULL,
0x00000040ff057424ULL, 0x000fe200078e00ffULL, 0x0000008000017945ULL, 0x000fe20003800000ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000001004047812ULL, 0x000fe200078ec0ffULL,
0x0000001014097824ULL, 0x000fc800078e0203ULL, 0x0000000103077824ULL, 0x000fc800078e0204ULL,
0x00937005070479a7ULL, 0x000ee4000800003fULL, 0x00937005070075a7ULL, 0x008ee4000800017fULL,
0x0000004000288947ULL, 0x008fea0003800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0093900c090479a7ULL, 0x000ee2000850003fULL, 0x0000000f0e00780cULL, 0x004fe20003f04070ULL,
0x0000008000017945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fd200078e00ffULL, 0x0000004014078824ULL, 0x100fe400078e0203ULL,
0x000000040e138824ULL, 0x040fe400078e0203ULL, 0x000000040e0a8824ULL, 0x000fe200078e0207ULL,
0x00939005090075a7ULL, 0x008ea4000802017fULL, 0x0000004000149947ULL, 0x004fea0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x009000000a068984ULL, 0x000fe20000000800ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000040e098824ULL, 0x000fe200078e0203ULL,
0x0092c000130b8984ULL, 0x000e680000000800ULL, 0x0093000009078984ULL, 0x0004a20000000800ULL,
0x0093b80c030479a7ULL, 0x0004a4000850003fULL, 0x000000060b00720bULL, 0x006fda0003f3e000ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000087806ULL, 0x000fc800048e0100ULL,
0x000000ff0800720cULL, 0x000fda0003f25270ULL, 0x0000000000949947ULL, 0x002fea0003800000ULL,
0x800000060b0b7221ULL, 0x000fe20000010000ULL, 0x0000005508ff7812ULL, 0x000fe4000782c0ffULL,
0x000000010e097819ULL, 0x000fe200000006ffULL, 0x3fb8aa3b0b0b7820ULL, 0x000fe20000410000ULL,
0x000000aa08ff7812ULL, 0x040fe4000784c0ffULL, 0x0000550008ff7812ULL, 0x040fe2000786c0ffULL,
0x0000000b00167308ULL, 0x0002a20000000800ULL, 0x0000aa0008ff7812ULL, 0x000fe4000788c0ffULL,
0x0000000609097812ULL, 0x000fc600078ec0ffULL, 0x0000000000149947ULL, 0x000ff00003800000ULL,
0x00001f09160b7589ULL, 0x006e6400000e0000ULL, 0x0000000b18187220ULL, 0x082fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b22227220ULL, 0x000fce0000410000ULL, 0x000000000018a947ULL, 0x000fea0003800000ULL,
0x00000001090a7836ULL, 0x000fcc0000000000ULL, 0x00001f0a160a7589ULL, 0x004ea400000e0000ULL,
0x0000000a19197220ULL, 0x084fe20000410000ULL, 0x0000000a1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000a21217220ULL, 0x080fe20000410000ULL, 0x0000000a23237220ULL, 0x000fce0000410000ULL,
0x000000000018b947ULL, 0x000fea0003800000ULL, 0x00000008090a7812ULL, 0x000fca00078efcffULL,
0x00001f0a160b7589ULL, 0x006e6400000e0000ULL, 0x0000000b1c1c7220ULL, 0x082fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b24247220ULL, 0x080fe20000410000ULL,
0x0000000b26267220ULL, 0x000fce0000410000ULL, 0x000000000018c947ULL, 0x000fea0003800000ULL,
0x0000000909097836ULL, 0x000fca0000000000ULL, 0x00001f09160a7589ULL, 0x004ea400000e0000ULL,
0x0000000a1d1d7220ULL, 0x084fe20000410000ULL, 0x0000000a1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000a25257220ULL, 0x080fe20000410000ULL, 0x0000000a27277220ULL, 0x000fce0000410000ULL,
0x0000001607077220ULL, 0x004fce0000410000ULL, 0x0000006000017945ULL, 0x000fe20003800000ULL,
0x0093b805030075a7ULL, 0x0004a2000802017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x0093b805030095a7ULL, 0x000e24000802007fULL,
0xfffffffc00ec9947ULL, 0x001fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000005ff157819ULL, 0x000fe20000011602ULL, 0x000001c000017945ULL, 0x000fe60003800000ULL,
0x000000031500780cULL, 0x000fda0003f25270ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x000000ff0800720cULL, 0x000fe20000722670ULL, 0x0000010014058824ULL, 0x140fe400078e0203ULL,
0x000000ffff087224ULL, 0x000fe400078e00ffULL, 0x0000010014098824ULL, 0x000fe400078e0203ULL,
0x000000040e058824ULL, 0x000fe400078e0205ULL, 0x000000ffff047224ULL, 0x000fe400078e00ffULL,
0x0000010014178824ULL, 0x000fc400078e0203ULL, 0x000000040e0b9824ULL, 0x042fe400078e0203ULL,
0x000000040e138824ULL, 0x000fe400078e0209ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0092c0060b009388ULL, 0x000fe20000000800ULL, 0x0000010014298824ULL, 0x000fe400078e0203ULL,
0x000000040e178824ULL, 0x000fe200078e0217ULL, 0x0090800005088984ULL, 0x000e620000000800ULL,
0x000000ffff097224ULL, 0x000fc400078e00ffULL, 0x000000040e298824ULL, 0x000fe200078e0229ULL,
0x0090c00013048984ULL, 0x000ea80000000800ULL, 0x00910000170a8984ULL, 0x000ee80000000800ULL,
0x0091400029098984ULL, 0x000f220000000800ULL, 0x0000000807077221ULL, 0x002fc80000010000ULL,
0x0000000407077221ULL, 0x004fe20000010000ULL, 0x000000040e048824ULL, 0x000fc600078e0203ULL,
0x0000000a070a7221ULL, 0x008fc80000010000ULL, 0x000000090a097221ULL, 0x010fca0000010000ULL,
0x0093000904008388ULL, 0x0003e40000000800ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0093b80c030479a7ULL, 0x002e62000850003fULL, 0x0000240014147824ULL, 0x000fe200078e0203ULL,
0x0000000402177811ULL, 0x000fe200078fd8ffULL, 0x0000009000017945ULL, 0x000fe20003800000ULL,
0x0000000715077812ULL, 0x000fe400078e780eULL, 0x0000440014167810ULL, 0x000fe40007ffe0ffULL,
0x0000000717097812ULL, 0x000fe200078e780eULL, 0x000000080e077824ULL, 0x000fc800078e0207ULL,
0x000000080e137824ULL, 0x000fe400078e0209ULL, 0x0000001007087824ULL, 0x000fe200078e0216ULL,
0x0093b805030075a7ULL, 0x002e64000800017fULL, 0x0000003800a48947ULL, 0x002fea0003800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000001013047824ULL, 0x000fe200078e0216ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x000000000808783bULL, 0x000e620000004200ULL,
0x0000400014137836ULL, 0x040fe40000000000ULL, 0x0000402014147836ULL, 0x000fe20000000000ULL,
0x000000000404783bULL, 0x000ea40000004200ULL, 0x0003fff013287812ULL, 0x000fc400078ec0ffULL,
0x000001f013ff7812ULL, 0x040fe4000780c0ffULL, 0x00000004ff307819ULL, 0x000fe20000011628ULL,
0x0000040013287824ULL, 0x000fe200078e00ffULL, 0x0003fff014147812ULL, 0x000fe400078ec0ffULL,
0x00003f0030317812ULL, 0x000fe400078ec0ffULL, 0x000e000028287812ULL, 0x000fe400078ec0ffULL,
0x000000ff31307812ULL, 0x000fc400078ef830ULL, 0x00000004ff147819ULL, 0x000fe40000011614ULL,
0x00006240082c7816ULL, 0x142fe40000000009ULL, 0x00007351082d7816ULL, 0x000fe40000000009ULL,
0x8000002028087812ULL, 0x000fe400078efcffULL, 0x000062400a2e7816ULL, 0x140fe4000000000bULL,
0x000073510a2f7816ULL, 0x000fc4000000000bULL, 0x0000624004287816ULL, 0x144fe40000000005ULL,
0x0000735104297816ULL, 0x000fe20000000005ULL, 0x000000200e047836ULL, 0x000fe20000000000ULL,
0x00006240062a7816ULL, 0x140fe40000000007ULL, 0x00007351062b7816ULL, 0x000fe40000000007ULL,
0x8000002008317807ULL, 0x000fe40000000000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00000000300a72caULL, 0x000fc400000e0000ULL, 0x00000000310b72caULL, 0x000fe400000e0000ULL,
0x0000000715057812ULL, 0x000fe400078e7804ULL, 0x0000000717177812ULL, 0x000fc600078e7804ULL,
0x0000000804057824ULL, 0x040fe400078e0205ULL, 0x0000000804177824ULL, 0x000fe400078e0217ULL,
0x0000001005087824ULL, 0x100fe400078e0216ULL, 0x002000082c187df3ULL, 0x000fe20008700818ULL,
0x00000000300a72caULL, 0x000fe200000e0000ULL, 0x0000001017047824ULL, 0x000fe200078e0216ULL,
0x00000000310b72caULL, 0x000fe400000e0000ULL, 0x00003f0014177812ULL, 0x000fc800078ec0ffULL,
0x000000ff17307812ULL, 0x000fce00078ef814ULL, 0x0020000828207df3ULL, 0x000fe60008000820ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x000000000808783bULL, 0x000e680000004200ULL,
0x000000000404783bULL, 0x000ea20000004200ULL, 0x00006240082c7816ULL, 0x002fc40000000009ULL,
0x00007351082d7816ULL, 0x000fe40000000009ULL, 0x000062400a2e7816ULL, 0x140fe4000000000bULL,
0x000073510a2f7816ULL, 0x000fe4000000000bULL, 0x0000624004287816ULL, 0x144fe40000000005ULL,
0x0000735104297816ULL, 0x000fe20000000005ULL, 0x00000005ff047e24ULL, 0x000fe2000f8e00ffULL,
0x00006240062a7816ULL, 0x000fc40000000007ULL, 0x00007351062b7816ULL, 0x000fe20000000007ULL,
0xffffffff04047836ULL, 0x000fc60000000000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00000000300a72caULL, 0x000fe400000e0000ULL, 0x00000000310b72caULL, 0x000fe400000e0000ULL,
0x000000040f00720cULL, 0x000fd60003f05270ULL, 0x002000082c187df3ULL, 0x000fe20008700818ULL,
0x00000000300a72caULL, 0x000fe400000e0000ULL, 0x00000000310b72caULL, 0x000fda00000e0000ULL,
0x0020000828207df3ULL, 0x000fe60008000820ULL, 0x00008000000079c5ULL, 0x000fe40000010000ULL,
0x00000ea000017945ULL, 0x000fe80003800000ULL, 0x0000000c00a00947ULL, 0x000fea0003800000ULL,
0x0093b80c030479a7ULL, 0x000e62000850003fULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000006000027945ULL, 0x000fe60003800000ULL,
0x0000001814147812ULL, 0x000fe400078ec0ffULL, 0x0000000f0200780cULL, 0x000fc60004744470ULL,
0x0000000103167824ULL, 0x000fe200078e0214ULL, 0x0093b805030075a7ULL, 0x002e64000802017fULL,
0x0000003400909947ULL, 0x002fee0003800000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0093000016047984ULL, 0x000e620000000a00ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x00000300000a7ab9ULL, 0x000fe20000000800ULL, 0x0000000710067c24ULL, 0x000fe2000f8e020dULL,
0x0092c0001209a984ULL, 0x000fe20000000800ULL, 0x000000070a0772a4ULL, 0x000fe2000f8e023fULL,
0x000002d000027945ULL, 0x000fe20003800000ULL, 0x0000c20000087ab9ULL, 0x000fe20000000a00ULL,
0x009300001208a984ULL, 0x000ea20000000800ULL, 0x00000000060c72caULL, 0x000fe200000e0000ULL,
0x0000000707077899ULL, 0x000fe2000800063fULL, 0x00000008ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x00009200000b7ab9ULL, 0x000fe20000000800ULL, 0x00000009ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x00000fff070774a4ULL, 0x000fe2000f8e020bULL, 0x0093200016067984ULL, 0x00072e0000000a00ULL,
0x0000000a0c0a72a4ULL, 0x000fc4000f8e0213ULL, 0x000000040c0c7899ULL, 0x000fe4000800063fULL,
0x0000000a07077291ULL, 0x000fe4000f8fa03fULL, 0x0000000a00297c02ULL, 0x000fe20008000f00ULL,
0x00008600000a7ab9ULL, 0x000fe20000000a00ULL, 0x0000000407077899ULL, 0x000fe4000800063fULL,
0x000001000c0a78a5ULL, 0x000fe2000f8e000aULL, 0x000000102929a824ULL, 0x000fe200078e0202ULL,
0x00000100070878a5ULL, 0x000fc6000f8e0008ULL, 0x000000082928a825ULL, 0x000fe200078e000aULL,
0x0000000a08077287ULL, 0x000fe40008000000ULL, 0x0000000b090a7287ULL, 0x000fe20008000000ULL,
0x01800000040a7836ULL, 0x002fe40000000000ULL, 0x00000008ff167e24ULL, 0x008fe4000f8e00ffULL,
0x00000009ff177e24ULL, 0x000fe2000f8e00ffULL, 0x7f8000000a2a7812ULL, 0x000fe200078ec0ffULL,
0x00000008ff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x000000082800a986ULL, 0x0049e2000c101b10ULL,
0x00000007ff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x01ffffff2a00780cULL, 0x000fe20003f24070ULL,
0x00000009ff0b7e24ULL, 0x000fc4000f8e00ffULL, 0x000000ffff0aa224ULL, 0x000fe400078e0016ULL,
0x0000000aff177e24ULL, 0x000fe4000f8e00ffULL, 0x000000ffff17a224ULL, 0x000fe400078e000bULL,
0x000000ffff167224ULL, 0x000fc800078e000aULL, 0x0000000000141947ULL, 0x010fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0004ULL, 0x00002cf000087802ULL, 0x000fce0000000f00ULL,
0x0000003400f87944ULL, 0x001fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000bULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000400097308ULL, 0x000e640000001000ULL,
0xbf80000004087423ULL, 0x002fc80000000009ULL, 0x800000ff08087221ULL, 0x000fc80000010100ULL,
0x00000008090a7223ULL, 0x000fce0000000009ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0180000005047810ULL, 0x000fe20007ffe0ffULL, 0x000000d000027945ULL, 0x000fe60003800000ULL,
0x7f80000004047812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0400780cULL, 0x000fda0003f24070ULL,
0x0000000000141947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0005ULL,
0x00002de000087802ULL, 0x000fce0000000f00ULL, 0x0000003400bc7944ULL, 0x001fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e000bULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000500047308ULL, 0x000e640000001000ULL, 0xbf80000005087423ULL, 0x002fc80000000004ULL,
0x800000ff08097221ULL, 0x000fc80000010100ULL, 0x0000000904047223ULL, 0x000fce0000000004ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0180000006057836ULL, 0x000fe20000000000ULL,
0x000000d000027945ULL, 0x000fe80003800000ULL, 0x7f80000005057812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0500780cULL, 0x000fda0003f24070ULL, 0x0000000000141947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0006ULL, 0x00002ed000087802ULL, 0x000fce0000000f00ULL,
0x0000003400807944ULL, 0x001fea0003c00000ULL, 0x000000ffff287224ULL, 0x000fe200078e000bULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000600057308ULL, 0x000e640000001000ULL,
0xbf80000006087423ULL, 0x002fc80000000005ULL, 0x800000ff08087221ULL, 0x000fc80000010100ULL,
0x0000000805287223ULL, 0x000fce0000000005ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0180000007057836ULL, 0x000fe20000000000ULL, 0x000000d000027945ULL, 0x000fe80003800000ULL,
0x7f80000005057812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0500780cULL, 0x000fda0003f24070ULL,
0x0000000000141947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0007ULL,
0x00002fc000087802ULL, 0x000fce0000000f00ULL, 0x0000003400447944ULL, 0x001fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e000bULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000700067308ULL, 0x000e640000001000ULL, 0xbf80000007057423ULL, 0x002fc80000000006ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000506067223ULL, 0x000fce0000000006ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000a11057220ULL, 0x040fe20000410000ULL,
0x0000000411047220ULL, 0x040fe20000410000ULL, 0x0000000611067220ULL, 0x000fe20000410000ULL,
0x0000004015297811ULL, 0x000fe200078e20ffULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x000000051a1a7220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000522227220ULL, 0x000fe20000410000ULL, 0x0000002811057220ULL, 0x000fe20000410000ULL,
0x0000000419197220ULL, 0x080fe20000410000ULL, 0x000000041b1b7220ULL, 0x000fe20000410000ULL,
0x000000061d1d7220ULL, 0x000fe20000410000ULL, 0x000000051c1c7220ULL, 0x080fe20000410000ULL,
0x000000051e1e7220ULL, 0x080fe20000410000ULL, 0x0000000524247220ULL, 0x080fe20000410000ULL,
0x0000000526267220ULL, 0x000fe20000410000ULL, 0x000000181905723eULL, 0x000fe200000010ffULL,
0x000000061f1f7220ULL, 0x000fe20000410000ULL, 0x0000001a1b2a723eULL, 0x000fe200000010ffULL,
0x0000000421217220ULL, 0x000fe20000410000ULL, 0x0000001c1d0b723eULL, 0x000fe200000010ffULL,
0x0000000423237220ULL, 0x000fe20000410000ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000000505723aULL, 0x000fe20000000000ULL, 0x0000001e1f28723eULL, 0x000fe200000010ffULL,
0x0000000625257220ULL, 0x000fe20000410000ULL, 0x00000002ff047819ULL, 0x000fe2000001160eULL,
0x000000002a2a723aULL, 0x000e620000000000ULL, 0x000000202108723eULL, 0x000fe200000010ffULL,
0x0000000627277220ULL, 0x000fe20000410000ULL, 0x000000222309723eULL, 0x000fe200000010ffULL,
0x000000000b0b723aULL, 0x000fe20000000000ULL, 0x00000004ff297819ULL, 0x000fe20000011629ULL,
0x00000008040a7836ULL, 0x000fe20000000000ULL, 0x00000003152b7812ULL, 0x000fe200078e7804ULL,
0x000000002828723aULL, 0x000ea20000000000ULL, 0x000000242506723eULL, 0x000fc400000010ffULL,
0x000000262707723eULL, 0x000fe200000010ffULL, 0x000000000808723aULL, 0x000fe20000000000ULL,
0x00000003292d7812ULL, 0x000fe200078e7804ULL, 0x00000008042c7824ULL, 0x040fe200078e022bULL,
0x0000000315157812ULL, 0x000fe200078e780aULL, 0x000000000909723aULL, 0x000ee20000000000ULL,
0x0000000329297812ULL, 0x000fe200078e780aULL, 0x0000000804047824ULL, 0x000fe400078e022dULL,
0x000000000606723aULL, 0x000fe20000000000ULL, 0x000000080a2e7824ULL, 0x000fc400078e0215ULL,
0x000000080a0a7824ULL, 0x000fe200078e0229ULL, 0x000000000707723aULL, 0x000f220000000000ULL,
0x000000202c297824ULL, 0x100fe200078e0213ULL, 0x00000013042b7211ULL, 0x000fe200078e28ffULL,
0x000000202e157824ULL, 0x000fe200078e0213ULL, 0x0000541005047816ULL, 0x142fe2000000002aULL,
0x0000000114297824ULL, 0x040fe200078e0229ULL, 0x0000763205057816ULL, 0x000fe2000000002aULL,
0x0000000114157824ULL, 0x000fe200078e0215ULL, 0x000001f000027945ULL, 0x000fe20003800000ULL,
0x000000200a2d7824ULL, 0x000fc400078e0213ULL, 0x0000000429007388ULL, 0x0005e20000000a00ULL,
0x00000001140a7824ULL, 0x040fe400078e022bULL, 0x0000000114147824ULL, 0x000fe200078e022dULL,
0x000054100b047816ULL, 0x144fe40000000028ULL, 0x000076320b057816ULL, 0x000fe40000000028ULL,
0x00000004ff297819ULL, 0x000fc60000011602ULL, 0x0000000415007388ULL, 0x0007e40000000a00ULL,
0x0000541008047816ULL, 0x108fe20000000009ULL, 0x0000001002157824ULL, 0x000fe200078e00ffULL,
0x0000763208057816ULL, 0x000fe20000000009ULL, 0x0000000829097836ULL, 0x000fe20000000000ULL,
0x0000000e02087812ULL, 0x000fc600078ec0ffULL, 0x000000040a007388ULL, 0x0009e20000000a00ULL,
0x00000001ff087819ULL, 0x000fc80000011608ULL, 0x0000000308287812ULL, 0x000fe400078e7829ULL,
0x0000000308087812ULL, 0x000fc600078e7809ULL, 0x0000000829287824ULL, 0x000fe200078e0228ULL,
0x0000541006047816ULL, 0x150fe20000000007ULL, 0x0000000809087824ULL, 0x000fe200078e0208ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000002028287824ULL, 0x100fe400078e0213ULL,
0x0000002008087824ULL, 0x000fe400078e0213ULL, 0x0000000414007388ULL, 0x0003e20000000a00ULL,
0x0093b80c030679a7ULL, 0x000ea2000850003fULL, 0x0000001015057812ULL, 0x002fca00078ec0ffULL,
0x0000000128047824ULL, 0x000fe400078e0205ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x0093b807030075a7ULL, 0x004e64000802017fULL, 0x0000002800c49947ULL, 0x002fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x0000010029167825ULL, 0x000fe200078e0016ULL, 0x000000f015157812ULL, 0x000fe200078ec0ffULL,
0x000000a000027945ULL, 0x000fe20003800000ULL, 0x0000000008087984ULL, 0x000ea20000000c00ULL,
0x000000ff0200720cULL, 0x000fe40004705670ULL, 0x0000001516147210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff157224ULL, 0x000fca00008e0617ULL, 0x0000000414007986ULL, 0x0023e8000c101d10ULL,
0x0008000814007986ULL, 0x0043e2000c101d10ULL, 0x0093b80c031679a7ULL, 0x000ea4000850003fULL,
0x0093b817030075a7ULL, 0x004ea4000802017fULL, 0x0000002800a49947ULL, 0x006fea0003800000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000000580947ULL, 0x000fea0003800000ULL,
0x0000c000ff047b82ULL, 0x000e620000000a00ULL, 0x0000840000077ab9ULL, 0x000fe20000000800ULL,
0x0000000dff077e24ULL, 0x000fe4000f8e00ffULL, 0x0000000710037c24ULL, 0x000fc8000f8e020dULL,
0x0000000403047825ULL, 0x002fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1d0ULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000879c3ULL, 0x000e620000008800ULL,
0x0000040000077882ULL, 0x000fc40000000000ULL, 0x0000065408077896ULL, 0x002fcc0008000007ULL,
0x0000000700037c02ULL, 0x000fe40008000f00ULL, 0x0000000d04007c0cULL, 0x000fc8000bf05270ULL,
0x00000001ff067807ULL, 0x000fca0000000000ULL, 0x0093c00603007388ULL, 0x0003e80000000000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000010f047812ULL, 0x040fe200078ec0ffULL,
0x000000010f0f7836ULL, 0x000fc80000000000ULL, 0x0000001004057824ULL, 0x000fe200078e0203ULL,
0x000000050f007c0cULL, 0x000fc6000bf06070ULL, 0x0093980c05ff79a7ULL, 0x0005e2000850003fULL,
0x0093780c05ff79a7ULL, 0x0005f2000850003fULL, 0xffffffe400588947ULL, 0x007fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000cc7947ULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x000e640000000a00ULL, 0x0000001006067981ULL, 0x002362000c1e9900ULL,
0x0000000f0200780cULL, 0x000fe20003f04070ULL, 0x00000001ff0a7424ULL, 0x000fc800078e00ffULL,
0x0093480a03ff79a7ULL, 0x0003f0000850003fULL, 0xff317217ff098424ULL, 0x000fe200078e00ffULL,
0x0093580a03ff79a7ULL, 0x0003e2000850003fULL, 0x0093680a03ff79a7ULL, 0x0003e6000850003fULL,
0x0092800912008388ULL, 0x0003e20000000800ULL, 0x0093b00a030479a7ULL, 0x000ea4000850003fULL,
0x0093b005030075a7ULL, 0x004ea4000800017fULL, 0x0000002800048947ULL, 0x006fea0003800000ULL,
0x0093400a030479a7ULL, 0x000e64000850003fULL, 0x00934005030075a7ULL, 0x002e64000800017fULL,
0x0000002800108947ULL, 0x002fea0003800000ULL, 0x000000040600728cULL, 0x000fe2000bf24070ULL,
0x00000005ff117819ULL, 0x000fca0000011602ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x00000010007c0947ULL, 0x000fea0003800000ULL, 0x0000000000127919ULL, 0x000e620000000000ULL,
0x3db504f3060f7820ULL, 0x020fe20000410000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x00000002ff107819ULL, 0x002fca0000011612ULL, 0x00000010110d7824ULL, 0x000fce00078e0210ULL,
0x00000014ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000060e067c24ULL, 0x000fce000f8e0205ULL, 0x000000100e047824ULL, 0x000fe200078e00ffULL,
0x00000000000079c5ULL, 0x000fe20000000000ULL, 0x00000040ff087424ULL, 0x000fe200078e00ffULL,
0x00000000030b72caULL, 0x040fe400000e0000ULL, 0x0000001004047812ULL, 0x000fe400078ec0ffULL,
0x000000010e0c7812ULL, 0x000fe400078ec0ffULL, 0x00000000030a72caULL, 0x040fe200000e0000ULL,
0x0000000103077824ULL, 0x000fc800078e0204ULL, 0x00935008070479a7ULL, 0x0002a4000800003fULL,
0x0000000a0b097899ULL, 0x000fe4000800063fULL, 0x000003ff0b3f7892ULL, 0x000fe4000f82c03fULL,
0x000e0000090b7892ULL, 0x000fe4000f8ec03fULL, 0x000088000a077890ULL, 0x000fe2000fffe03fULL,
0x000020000c087824ULL, 0x002fe200078e0203ULL, 0x0000003f0b0b7287ULL, 0x000fc40008800000ULL,
0x0000000a07097899ULL, 0x000fe4000800063fULL, 0x00000000080872caULL, 0x000fe200000e0000ULL,
0x000003ff073f7892ULL, 0x000fe4000f84c03fULL, 0x0003fff007077892ULL, 0x000fe4000f8ec03fULL,
0x000e0000090c7892ULL, 0x000fe4000f8ec03fULL, 0x000000043f0d7899ULL, 0x000fe20008011607ULL,
0x00935005070075a7ULL, 0x004e62000800017fULL, 0x400000400b077892ULL, 0x000fc4000f8efc3fULL,
0x00003f000d0e7892ULL, 0x000fe4000f8ec03fULL, 0x0003fff008097892ULL, 0x000fe4000f8ec03fULL,
0x000000ff0e0e7892ULL, 0x000fe4000f8ef80dULL, 0x000000043f0b7899ULL, 0x000fe40008011609ULL,
0x0000003f0c097287ULL, 0x000fe40009000000ULL, 0x00003f000b0c7892ULL, 0x000fc4000f8ec03fULL,
0x4000004009097892ULL, 0x000fe4000f8efc3fULL, 0x000000ff0c0c7892ULL, 0x000fe2000f8ef80bULL,
0x0000002400788947ULL, 0x002ff60003800000ULL, 0x00000000000079c5ULL, 0x000fe20000000000ULL,
0x00000009000f7c82ULL, 0x000fe20008000000ULL, 0x00000007000d7c82ULL, 0x000fe20008000000ULL,
0x00000020080b7890ULL, 0x000fe2000fffe03fULL, 0x0000000106047836ULL, 0x000fe40000000000ULL,
0x002000000c1879f3ULL, 0x000fe2000c7008ffULL, 0x000088200a0c7890ULL, 0x000fe2000fffe03fULL,
0x000000100c0b7824ULL, 0x000fe200078e0203ULL, 0x0003fff00b0b7892ULL, 0x000fe2000f8ec03fULL,
0x0000001204007c0cULL, 0x000fe2000bf05270ULL, 0x0003fff00c0c7892ULL, 0x000fc4000f8ec03fULL,
0x000000043f0b7899ULL, 0x000fe4000801160bULL, 0x000000043f0d7899ULL, 0x000fe4000801160cULL,
0x00003f000b0c7892ULL, 0x000fe4000f8ec03fULL, 0x00003f000d0e7892ULL, 0x000fe4000f8ec03fULL,
0x000000ff0c0c7892ULL, 0x000fe4000f8ef80bULL, 0x000000ff0e0e7892ULL, 0x000fe2000f8ef80dULL,
0x00000009000f7c82ULL, 0x000fc40008000000ULL, 0x00000007000d7c82ULL, 0x000fe20008000000ULL,
0x00000040080b7890ULL, 0x000fe4000fffe03fULL, 0x0000006008087890ULL, 0x000fe4000fffe03fULL,
0x0003fff00b0b7892ULL, 0x000fe4000f8ec03fULL, 0x0003fff008087892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0b7899ULL, 0x000fe4000801160bULL, 0x000000043f087899ULL, 0x000fe20008011608ULL,
0x002000000c1879f3ULL, 0x000fe20008700818ULL, 0x000088400a0c7890ULL, 0x000fe2000fffe03fULL,
0x00000009000f7c82ULL, 0x000fe20008000000ULL, 0x000088600a0a7890ULL, 0x000fc4000fffe03fULL,
0x0003fff00c0c7892ULL, 0x000fe4000f8ec03fULL, 0x0003fff00a0a7892ULL, 0x000fe4000f8ec03fULL,
0x000000043f0d7899ULL, 0x000fe4000801160cULL, 0x00003f000b0c7892ULL, 0x000fe4000f8ec03fULL,
0x00003f000d0e7892ULL, 0x000fe4000f8ec03fULL, 0x000000ff0c0c7892ULL, 0x000fc4000f8ef80bULL,
0x000000ff0e0e7892ULL, 0x000fe4000f8ef80dULL, 0x000000043f0b7899ULL, 0x000fe2000801160aULL,
0x00000007000d7c82ULL, 0x000fe20008000000ULL, 0x00003f00080a7892ULL, 0x000fc8000f8ec03fULL,
0x000000ff0a087892ULL, 0x000fe2000f8ef808ULL, 0x002000000c1879f3ULL, 0x000fe20008700818ULL,
0x00003f000b0c7892ULL, 0x000fc8000f8ec03fULL, 0x000000ff0c0c7892ULL, 0x000fc6000f8ef80bULL,
0x00000009000b7c82ULL, 0x000fe20008000000ULL, 0x0000000700097c82ULL, 0x000fc60008000000ULL,
0x0000000c000a7c82ULL, 0x000fe40008000000ULL, 0x00200000081879f3ULL, 0x000fe60008000818ULL,
0x00008000000079c5ULL, 0x000fe40000010000ULL, 0x0093580a0bff79a7ULL, 0x0003e2000850003fULL,
0x0000000f18187220ULL, 0x080fe20000410000ULL, 0x0000000f19197220ULL, 0x080fe20000410000ULL,
0x0000000f1a157220ULL, 0x080fe20000410000ULL, 0x0000000f1b147220ULL, 0x080fe20000410000ULL,
0x0000000f1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000f1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000f1e177220ULL, 0x080fe20000410000ULL, 0x0000000f1f167220ULL, 0x000fe20000410000ULL,
0x0000000000380947ULL, 0x000fec0003800000ULL, 0x0000004006057824ULL, 0x000fca00078e00ffULL,
0x0000000500047248ULL, 0x000fca0007fe0000ULL, 0x0000000104047824ULL, 0x000fe200078e0a05ULL,
0x000000080d057810ULL, 0x000fc80007ffe0ffULL, 0x000000040d00720cULL, 0x080fe40003f06070ULL,
0x000000040500720cULL, 0x000fe40003f26070ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40004000000ULL, 0xff7fffff19197808ULL, 0x000fe40004000000ULL,
0xff7fffff18187808ULL, 0x000fc40004000000ULL, 0xff7fffff16167808ULL, 0x000fe40004800000ULL,
0xff7fffff17177808ULL, 0x000fe40004800000ULL, 0xff7fffff14147808ULL, 0x000fe40004800000ULL,
0xff7fffff15157808ULL, 0x000fce0004800000ULL, 0x0000001815047209ULL, 0x000fe20007810000ULL,
0x000000010e0e7836ULL, 0x000fe20000000000ULL, 0x0000001914067209ULL, 0x000fe20007810000ULL,
0x0000039000007945ULL, 0x000fe20003800000ULL, 0x0000001c17087209ULL, 0x000fe20007810000ULL,
0x0e001f0004057f89ULL, 0x000ea200000e0000ULL, 0x0000001d16137209ULL, 0x000fe40007810000ULL,
0x000000031200780cULL, 0x000fe20003f04070ULL, 0x0e001f0006077f89ULL, 0x000ee200000e0000ULL,
0x000000050e007c0cULL, 0x000fc6000bf26070ULL, 0x0e001f0008097f89ULL, 0x000f2800000e0000ULL,
0x0e001f00131a7f89ULL, 0x000f6200000e0000ULL, 0x0000000504057209ULL, 0x004fe40007810000ULL,
0x0000000706077209ULL, 0x008fc60007810000ULL, 0x0d001f00051e7f89ULL, 0x000ea200000e0000ULL,
0x0000000908097209ULL, 0x010fc60007810000ULL, 0x0d001f0007207f89ULL, 0x000ee200000e0000ULL,
0x0000001a131a7209ULL, 0x020fc60007810000ULL, 0x0d001f0009227f89ULL, 0x000f2800000e0000ULL,
0x0d001f001a1b7f89ULL, 0x000f6200000e0000ULL, 0x0000001e051e7209ULL, 0x004fe40007810000ULL,
0x0000002007207209ULL, 0x008fc60007810000ULL, 0x0c801f001e137f89ULL, 0x000ea200000e0000ULL,
0x0000002209227209ULL, 0x010fc60007810000ULL, 0x0c801f00201f7f89ULL, 0x000ee200000e0000ULL,
0x0000001b1a1b7209ULL, 0x020fc60007810000ULL, 0x0c801f0022217f89ULL, 0x000f2800000e0000ULL,
0x0c801f001b047f89ULL, 0x000f6200000e0000ULL, 0x000000131e137209ULL, 0x004fe40007810000ULL,
0x0000001f201f7209ULL, 0x008fe40007810000ULL, 0x0000002122217209ULL, 0x010fe40007810000ULL,
0x000000041b057209ULL, 0x020fe20007810000ULL, 0x00000000006c0947ULL, 0x000fec0003800000ULL,
0x000000ff1300720bULL, 0x000fe20003f56000ULL, 0x0000006000017945ULL, 0x000fe20003800000ULL,
0x0000000812047824ULL, 0x000fd600078e0203ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x0092801304ff738cULL, 0x0005e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0092801304ff738cULL, 0x0005e40000800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff1f00720bULL, 0x000fe20003f56000ULL, 0x0000005000017945ULL, 0x000fd80003800000ULL,
0x000000000008a947ULL, 0x000fea0003800000ULL, 0x0092841f04ff738cULL, 0x0007e20001000200ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0092841f04ff738cULL, 0x0007e40000800000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff2100720bULL, 0x000fe20003f56000ULL,
0x0000005000017945ULL, 0x000fd80003800000ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x0092a02104ff738cULL, 0x0009e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0092a02104ff738cULL, 0x0009e40000800000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff0500720bULL, 0x000fda0003f56000ULL, 0x000000000008a947ULL, 0x000fea0003800000ULL,
0x0092a40504ff738cULL, 0x0003e20001000200ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0092a40504ff738cULL, 0x0003e40000800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0093b00a030479a7ULL, 0x01ee62000850003fULL, 0x0000000812137824ULL, 0x000fca00078e00ffULL,
0x0000001813067812ULL, 0x000fca00078ec0ffULL, 0x00000001031b7824ULL, 0x000fe200078e0206ULL,
0x0093b005030075a7ULL, 0x002e64000804017fULL, 0x0000001c0064a947ULL, 0x002fea0003800000ULL,
0x009280001b047984ULL, 0x000e680000000a00ULL, 0x0092a0001b067984ULL, 0x000ea20000000a00ULL,
0x0093b00a030879a7ULL, 0x000ee4000850003fULL, 0x0093b009030075a7ULL, 0x008ee2000804017fULL,
0x3fb8aa3b041a7820ULL, 0x002fc80000410000ULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b15157823ULL, 0x000fe2000001081aULL, 0x3fb8aa3b051a7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b061b7820ULL, 0x004fc60000410000ULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b14147823ULL, 0x000fe2000001081aULL, 0x3fb8aa3b1c1a7823ULL, 0x100fe2000001081bULL,
0x3fb8aa3b071c7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b17177823ULL, 0x000fe2000001081bULL,
0x0000001800187308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b1d1b7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b16167823ULL, 0x000fca000001081cULL, 0x0000001500157308ULL, 0x000e700000000800ULL,
0x0000001900197308ULL, 0x000ea20000000800ULL, 0x00000015181c7221ULL, 0x002fce0000010000ULL,
0x0000001400147308ULL, 0x000eb00000000800ULL, 0x0000001a001a7308ULL, 0x000eb00000000800ULL,
0x0000001700177308ULL, 0x000e300000000800ULL, 0x0000001b001b7308ULL, 0x000e300000000800ULL,
0x0000001600167308ULL, 0x000e220000000800ULL, 0x0000001c0014a947ULL, 0x00cfea0003800000ULL,
0x000000171a097221ULL, 0x001fe20000010000ULL, 0x0000001419087221ULL, 0x000fc20000010000ULL,
0x000000161b1d7221ULL, 0x000fe20000010000ULL, 0x0e001f001c1f7f89ULL, 0x000e2200000e0000ULL,
0x0000000f1200780cULL, 0x000fe20003f44070ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x0e001f00091e7f89ULL, 0x000e6800000e0000ULL,
0x0e001f0008217f89ULL, 0x000ea800000e0000ULL, 0x0e001f001d207f89ULL, 0x000ee200000e0000ULL,
0x0000001f1c1f7221ULL, 0x001fc20000010000ULL, 0x0000001e09257221ULL, 0x002fc80000010000ULL,
0x0d001f001f1e7f89ULL, 0x000e2200000e0000ULL, 0x0000002108217221ULL, 0x004fc60000010000ULL,
0x0d001f0025227f89ULL, 0x000e6200000e0000ULL, 0x000000201d267221ULL, 0x008fc60000010000ULL,
0x0d001f0021207f89ULL, 0x000ea800000e0000ULL, 0x0d001f0026237f89ULL, 0x000ee200000e0000ULL,
0x0000001e1f1c7221ULL, 0x001fc20000010000ULL, 0x00000022251e7221ULL, 0x002fe20000010000ULL,
0x00000020211d7221ULL, 0x004fc80000010000ULL, 0x0c801f001e1f7f89ULL, 0x00006200000e0000ULL,
0x0000002326227221ULL, 0x008fc60000010000ULL, 0x0c801f001d207f89ULL, 0x0000a800000e0000ULL,
0x0c801f001c237f89ULL, 0x0000e800000e0000ULL, 0x0c801f0022217f89ULL, 0x00012200000e0000ULL,
0x0000000000302947ULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000f620000003000ULL,
0x0000000712097812ULL, 0x000fe400078ec0ffULL, 0x3ffffffc10087812ULL, 0x000fe400078ec0ffULL,
0x0000000809097812ULL, 0x000fc600078ef812ULL, 0x0000000111087824ULL, 0x000fe200078e0208ULL,
0x00000001ff257819ULL, 0x000fe20000011609ULL, 0x0000000103277824ULL, 0x020fc600078e0224ULL,
0x0000000308247812ULL, 0x000fe200078e7825ULL, 0x000024000c087824ULL, 0x000fc800078e0227ULL,
0x0000000409097824ULL, 0x000fc800078e0224ULL, 0x0000001009087824ULL, 0x000fc800078e0208ULL,
0x0000400008247836ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0093980a0b0879a7ULL, 0x000f64000850003fULL, 0x009398090b0075a7ULL, 0x020f64000804017fULL,
0x000000180080a947ULL, 0x020fea0003800000ULL, 0x00000000000779c3ULL, 0x000f620000003000ULL,
0x43e0000019197820ULL, 0x000fe20000410000ULL, 0x43e0000014147820ULL, 0x000fe20000410000ULL,
0x43e000001a1a7820ULL, 0x000fe20000410000ULL, 0x43e0000017177820ULL, 0x000fe20000410000ULL,
0x43e000001b1b7820ULL, 0x000fe20000410000ULL, 0x43e0000016167820ULL, 0x000fe20000410000ULL,
0x43e0000018087820ULL, 0x000fe20000410000ULL, 0x43e0000015157820ULL, 0x000fe20000410000ULL,
0x000000191414723eULL, 0x000fe20004807114ULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x0000001a1709723eULL, 0x000fe20004807109ULL, 0x000000231c237221ULL, 0x008fc20000010000ULL,
0x0000001b1616723eULL, 0x000fe20004807116ULL, 0x000000201d207221ULL, 0x004fc20000010000ULL,
0x000000081508723eULL, 0x000fe20004807014ULL, 0x0000001f1e1f7221ULL, 0x002fc20000010000ULL,
0x0000541009097816ULL, 0x000fe20000000016ULL, 0x0000002122217221ULL, 0x010fc20000010000ULL,
0x8000000724247c36ULL, 0x020fca0008000000ULL, 0x0000000824007844ULL, 0x0003e20000004100ULL,
0x0000000000380947ULL, 0x000fea0003800000ULL, 0x000000ff1100720cULL, 0x040fe20003f05270ULL,
0x000001000c087824ULL, 0x142fe400078e0203ULL, 0x000000400c0c7824ULL, 0x000fe400078e0203ULL,
0x0000004011097824ULL, 0x000fe400078e0208ULL, 0x00000001130c7824ULL, 0x000fc600078e020cULL,
0x0000000912087211ULL, 0x000fc600078e18ffULL, 0x009000040c008388ULL, 0x0003e80000000800ULL,
0x0090802308007388ULL, 0x0003e80000000800ULL, 0x009004050c008388ULL, 0x0003e80000000800ULL,
0x0090842008007388ULL, 0x0003e80000000800ULL, 0x009020060c008388ULL, 0x0003e80000000800ULL,
0x0090a01f08007388ULL, 0x0003e80000000800ULL, 0x009024070c008388ULL, 0x0003e80000000800ULL,
0x0090a42108007388ULL, 0x0003e40000000800ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0093900a0bff79a7ULL, 0x0005e4000850003fULL, 0xffffffec00989947ULL, 0x007fea000383ffffULL,
0x0093480a03ff79a7ULL, 0x0003e4000850003fULL, 0x0000000000067919ULL, 0x020ee20000002300ULL,
0x0000003f00007836ULL, 0x000fe20000000000ULL, 0x0000000000077919ULL, 0x002ee20000002200ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000783f077890ULL, 0x000fe2000ff3e03fULL, 0x0000007f0000780cULL, 0x000fc60003f04070ULL,
0x0000003f3f087290ULL, 0x000fe20008ffe43fULL, 0x0000010000097ab9ULL, 0x000fe20000000800ULL,
0x00000000000a7ab9ULL, 0x000fe20000000800ULL, 0x00000300ff087b82ULL, 0x000e620000000800ULL,
0x0000000307077899ULL, 0x000fc80008001208ULL, 0x0000000107077890ULL, 0x000fe2000fffe03fULL,
0x0000000906057c24ULL, 0x008fc8000f8e0207ULL, 0x0000000a05047c24ULL, 0x000fe2000f8e0202ULL,
0x000000010800780cULL, 0x002fc80000704070ULL, 0x0000000704007c0cULL, 0x000fda000bf26070ULL,
0x0000000804039824ULL, 0x004fc800078e0203ULL, 0x00934000030099b1ULL, 0x0002a4000800003fULL,
0x000000000000894dULL, 0x004fea0003800000ULL, 0x00000000000879c3ULL, 0x000ee20000008800ULL,
0x0000040000077882ULL, 0x000fe40000000000ULL, 0x0000065408077896ULL, 0x008fd20008000007ULL,
0x0093c007ff007984ULL, 0x004ea40008000000ULL, 0x000000ff0000720cULL, 0x004fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000607ff7212ULL, 0x000fc8000784fcffULL, 0x000000040200780cULL, 0x000fda0005741070ULL,
0x00000000005ca947ULL, 0x000fea0003800000ULL, 0x0000000702007c11ULL, 0x000fe2000f8e20ffULL,
0x001ffffe00047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x7ffff80000057882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x002fd60000000000ULL,
0x00000000000812caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00420004083f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x001ffe0000047882ULL, 0x002fe20000000000ULL, 0x7ff8000000057882ULL, 0x000fd60000000000ULL,
0x00000000000812caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x00420804083f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x00000100ff037424ULL, 0x000fc800078e00ffULL, 0x0042080300ff79a7ULL, 0x0045e6000850003fULL,
0x00000005ff047819ULL, 0x000fe20000011604ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001fff04047589ULL, 0x000ee400000e0000ULL, 0x00000000040572caULL, 0x00afe200000e0000ULL,
0x0000000000007b1dULL, 0x000fd80000010000ULL, 0x000000080500788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x00000004001c8947ULL, 0x000fea0003800000ULL,
0x0000000b05067890ULL, 0x000fc8000fffe106ULL, 0x000000023f067899ULL, 0x000fcc0008011606ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000c005c8947ULL, 0x000fea0003800000ULL,
0x00000000000879c3ULL, 0x000fe20000002600ULL, 0x0000000000077919ULL, 0x000e620000000000ULL,
0x00000300000a7ab9ULL, 0x000fe20000000800ULL, 0x00008400000b7ab9ULL, 0x000fe20000000800ULL,
0x00009200000c7ab9ULL, 0x000fe20000000800ULL, 0x0000000b0a0472a4ULL, 0x000fc6000f8e023fULL,
0x00000000000979c3ULL, 0x000ee20000002700ULL, 0x0000000704047899ULL, 0x000fe4000800063fULL,
0x0000000b090872a4ULL, 0x008fe4000f8e0208ULL, 0xfffffff8050b7890ULL, 0x000fe4000fffe03fULL,
0x00000fff040574a4ULL, 0x000fe4000f8e020cULL, 0x0000000a080a72a4ULL, 0x000fe2000f8e023fULL,
0x0000003f00047c82ULL, 0x002fd60008000000ULL, 0x0000000b04087291ULL, 0x000fe2000f8e103fULL,
0x0000000f0700780cULL, 0x040fe20003f64070ULL, 0x0000000104047890ULL, 0x000fe2000fffe03fULL,
0x000000ff0700720cULL, 0x000fe20003f25270ULL, 0x0000000408097892ULL, 0x000fe4000f8ec03fULL,
0x00000004080c7899ULL, 0x000fe4000800063fULL, 0x000000023f097899ULL, 0x000fe40008011609ULL,
0x000000300c0c7892ULL, 0x000fc4000f8ec03fULL, 0x0000001f09097899ULL, 0x000fe4000800063fULL,
0x000000060400728cULL, 0x000fe4000bf06070ULL, 0x0000000cff037e24ULL, 0x004fe2000f8e00ffULL,
0x000000080a127290ULL, 0x000fe2000fffe03fULL, 0x00000009ff007e24ULL, 0x000fe2000f8e00ffULL,
0x00000003080d7892ULL, 0x000fe4000f8ec03fULL, 0x0000000c070c7290ULL, 0x000fe4000fffe03fULL,
0x00420800030075a7ULL, 0x000e640008000147ULL, 0x00000010007c8947ULL, 0x002ff00003800000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x0000000000443947ULL, 0x000fea0003800000ULL,
0x0000c20000087ab9ULL, 0x000fe20000000a00ULL, 0x000000070d0c7291ULL, 0x000fe4000f8e383fULL,
0x00000080120878a5ULL, 0x000fc8000f8e0008ULL, 0x0000000c07037c11ULL, 0x040fe4000f8e18ffULL,
0x00000008ff047e24ULL, 0x000fe2000f8e00ffULL, 0x000000070d087291ULL, 0x000fe2000f8e203fULL,
0x00000009ff057e24ULL, 0x000fe4000f8e00ffULL, 0x0000000807047825ULL, 0x000fca00078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0400000004037faeULL, 0x0003e2000b921a50ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000420008087890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200408ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a88ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000d000007945ULL, 0x000fe80003800000ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x00000012050c7291ULL, 0x000fe2000f8fa03fULL, 0x00001000ff007424ULL, 0x000fe200078e00ffULL,
0x000000070d137291ULL, 0x000fe2000f8e203fULL, 0x0000c20000087ab9ULL, 0x000fe20000000a00ULL,
0x000000070d0e7291ULL, 0x000fe4000f8e603fULL, 0x000010000c0878a5ULL, 0x000fe4000f8e0008ULL,
0x00004200130f7890ULL, 0x000fe2000fffe03fULL, 0x00000100000c7882ULL, 0x000fd00000000000ULL,
0x0000000e080073baULL, 0x0003e2000800020cULL, 0x00420000ffff79a7ULL, 0x0003e40008000013ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0xfffffffc002c8947ULL, 0x001fea000383ffffULL,
0x0000000800507947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0x00000006ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000400908947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0xff317217ff127424ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x004fe200078e00ffULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0x000000ff000e7202ULL, 0x000fe20000000f00ULL, 0xff317217ff107424ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff097224ULL, 0x000fce00078e00ffULL,
0x0000000404087892ULL, 0x000fe4000f8ec03fULL, 0x0000000404097899ULL, 0x000fe4000800063fULL,
0x000000023f087899ULL, 0x000fe40008011608ULL, 0x0000003009097892ULL, 0x000fe4000f8ec03fULL,
0x0000001f080b7899ULL, 0x000fe4000800063fULL, 0x00000003040c7892ULL, 0x000fc4000f8ec03fULL,
0x00000009ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000907097290ULL, 0x000fe2000fffe03fULL,
0x0000000bff047e24ULL, 0x000fe2000f8e00ffULL, 0x000000070c0a7291ULL, 0x000fe4000f8e603fULL,
0x000000070c087291ULL, 0x000fe4000f8e383fULL, 0x00420004050075a7ULL, 0x000ea20008000147ULL,
0x0000000a050a7291ULL, 0x000fe4000f8e403fULL, 0x0000000805087291ULL, 0x000fc8000f8e183fULL,
0x0000000a08167c11ULL, 0x002fe2000f8e18ffULL, 0x0000000c00988947ULL, 0x004fee0003800000ULL,
0x00400008ff047984ULL, 0x000e620008000a00ULL, 0x0000000104047890ULL, 0x000fc6000fffe03fULL,
0x0000000016147984ULL, 0x000ea20000000a00ULL, 0x000000060400728cULL, 0x000fe2000bf06070ULL,
0x000000100500720bULL, 0x002fe40003f14000ULL, 0x00007632140f7816ULL, 0x044fe2000000000fULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000763215117816ULL, 0x040fe20000000011ULL,
0x0001000015157824ULL, 0x000fe400078e00ffULL, 0x000100000f137824ULL, 0x000fe400078e00ffULL,
0x0001000011177824ULL, 0x000fc800078e00ffULL, 0x0000000000280947ULL, 0x000fea0003800000ULL,
0x0000000510057221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b05057820ULL, 0x000fcc0000410000ULL,
0x0000000500057308ULL, 0x000e640000000800ULL, 0x00000005040f7220ULL, 0x002fc80000410000ULL,
0x0000000f14097223ULL, 0x080fe20000010009ULL, 0x0000000f130e7223ULL, 0x080fe2000001000eULL,
0x0000000f150c7223ULL, 0x080fe2000001000cULL, 0x0000000f170a7223ULL, 0x000fe2000001000aULL,
0x0000000d0f0d7221ULL, 0x000fe20000010000ULL, 0x0000000000347947ULL, 0x000fec0003800000ULL,
0x80000005100f7221ULL, 0x000fe20000010000ULL, 0x0000001304117220ULL, 0x040fe20000410000ULL,
0x0000001404107220ULL, 0x040fe20000410000ULL, 0x0000001504137220ULL, 0x040fe20000410000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fe20000410000ULL, 0x0000001704157220ULL, 0x000fca0000410000ULL,
0x0000000f000f7308ULL, 0x000e640000000800ULL, 0x000000090f097223ULL, 0x042fe20000010010ULL,
0x0000000d0f0d7223ULL, 0x040fe20000010004ULL, 0x0000000e0f0e7223ULL, 0x040fe20000010011ULL,
0x0000000c0f0c7223ULL, 0x040fe20000010013ULL, 0x0000000a0f0a7223ULL, 0x000fe20000010015ULL,
0x000000ffff107224ULL, 0x000fce00078e0005ULL, 0x00404008ff047984ULL, 0x000e680008000a00ULL,
0x0008000016147984ULL, 0x000ea20000000a00ULL, 0x000000120500720bULL, 0x002fe40003f14000ULL,
0x00007632140f7816ULL, 0x044fe2000000000fULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x0000763215117816ULL, 0x040fe20000000011ULL, 0x0001000015157824ULL, 0x000fc400078e00ffULL,
0x000100000f187824ULL, 0x000fe400078e00ffULL, 0x0001000011137824ULL, 0x000fc800078e00ffULL,
0x0000000000280947ULL, 0x000fea0003800000ULL, 0x0000000512057221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b05057820ULL, 0x000fcc0000410000ULL, 0x0000000500057308ULL, 0x000e640000000800ULL,
0x0000000504047220ULL, 0x002fc80000410000ULL, 0x0000000414077223ULL, 0x080fe20000010007ULL,
0x0000000418037223ULL, 0x080fe20000010003ULL, 0x0000000415007223ULL, 0x080fe20000010000ULL,
0x0000000413067223ULL, 0x000fe20000010006ULL, 0x0000000b040b7221ULL, 0x000fe20000010000ULL,
0x0000000000347947ULL, 0x000fec0003800000ULL, 0x80000005120f7221ULL, 0x000fe20000010000ULL,
0x0000001404127220ULL, 0x040fe20000410000ULL, 0x0000001804147220ULL, 0x040fe20000410000ULL,
0x0000001504117220ULL, 0x040fe20000410000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fe20000410000ULL,
0x0000001304137220ULL, 0x000fca0000410000ULL, 0x0000000f000f7308ULL, 0x000e640000000800ULL,
0x000000070f077223ULL, 0x042fe20000010012ULL, 0x0000000b0f0b7223ULL, 0x040fe20000010004ULL,
0x000000030f037223ULL, 0x040fe20000010014ULL, 0x000000000f007223ULL, 0x040fe20000010011ULL,
0x000000060f067223ULL, 0x000fe20000010013ULL, 0x0000000500127202ULL, 0x000fce0000000f00ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x000000070c087291ULL, 0x000fe2000f8e203fULL,
0x00000001ff047424ULL, 0x000fd000078e00ffULL, 0x00420804ffff79a7ULL, 0x0003e60008500008ULL,
0xfffffff8009c8947ULL, 0x003fea000383ffffULL, 0x00000000001c7947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x000000ffff007224ULL, 0x004fe200078e00ffULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff037224ULL, 0x000fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fce00078e00ffULL, 0x00000000000479c3ULL, 0x000fe20000002600ULL,
0x0000840000087ab9ULL, 0x000fe20000000800ULL, 0x0000000d000d7308ULL, 0x000ea20000001000ULL,
0x00008600000a7ab9ULL, 0x000fca0000000a00ULL, 0x00000000000679c3ULL, 0x000ee40000002700ULL,
0x0000000b00107308ULL, 0x0009620000001000ULL, 0x000000090d0f7220ULL, 0x044fe20000410000ULL,
0x0000000e0d0e7220ULL, 0x040fe20000410000ULL, 0x0000000c0d0c7220ULL, 0x040fe20000410000ULL,
0x0000000a0d0d7220ULL, 0x000fe20000410000ULL, 0x00000004080b7824ULL, 0x012fe400078e00ffULL,
0x0000000f0e0e723eULL, 0x000fe200000010ffULL, 0x00000007100a7220ULL, 0x060fe20000410000ULL,
0x0000000310037220ULL, 0x040fe20000410000ULL, 0x0000000010007220ULL, 0x040fe20000410000ULL,
0x0000000610117220ULL, 0x000fe20000410000ULL, 0x0000000c0d0f723eULL, 0x000fc400000010ffULL,
0x0000000a030a723eULL, 0x000fe200000010ffULL, 0x00000008060472a4ULL, 0x008fc8000f8e0204ULL,
0x0000000404067899ULL, 0x000fe4000800063fULL, 0x0000000805047890ULL, 0x000fe4000fffe03fULL,
0x0000000506087290ULL, 0x000fe4000ff1e03fULL, 0x0000000406057290ULL, 0x000fe4000ff3e03fULL,
0x0000003f3f097290ULL, 0x000fe400087fe43fULL, 0x0000003f3f067290ULL, 0x000fc40008ffe43fULL,
0x0000000a080c7291ULL, 0x000fe4000f80403fULL, 0x0000000a05047291ULL, 0x000fe4000f82403fULL,
0x0000000b08087291ULL, 0x000fe400080f4409ULL, 0x0000000b05057291ULL, 0x000fe200088f4406ULL,
0x0000000cff047e24ULL, 0x000fe4000f8e00ffULL, 0x00000004ff087e24ULL, 0x000fe4000f8e00ffULL,
0x00000008ff057e24ULL, 0x000fc4000f8e00ffULL, 0x00000005ff097e24ULL, 0x000fe4000f8e00ffULL,
0x000000020b047825ULL, 0x000fc800078e0004ULL, 0x000000020b067825ULL, 0x000fe200078e0008ULL,
0x00000000110b723eULL, 0x000fe200000010ffULL, 0x0000000e04007986ULL, 0x0003e8000c101b10ULL,
0x0000000a06007986ULL, 0x0003e4000c101b10ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000000a94dULL, 0x000fea0003800000ULL, 0x0000000702027c11ULL, 0x000fc8000f8e20ffULL,
0x00420800020079b1ULL, 0x000e24000800003fULL, 0x00420000020079b1ULL, 0x001fe2000800003fULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x009378070b0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x009378070b0085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffa800ec7947ULL, 0x021fea000383ffffULL, 0x009358070b0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x009358070b0085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffac00907947ULL, 0x021fea000383ffffULL, 0x0093480d030075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0093480d030095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffb000807947ULL, 0x021fea000383ffffULL, 0x0093b805030075a7ULL, 0x0004a2000800017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0093b805030085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffbc00687947ULL, 0x023fea000383ffffULL, 0x00937005070075a7ULL, 0x0006e2000800017fULL,
0x0000b0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00937005070085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffbc00c07947ULL, 0x007fea000383ffffULL, 0x00939005090075a7ULL, 0x0004a2000802017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x00939005090095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffbc00d47947ULL, 0x003fea000383ffffULL, 0x0093b805030075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0093b805030085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffc400447947ULL, 0x001fea000383ffffULL, 0x0093b805030075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0093b805030095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffc800587947ULL, 0x001fea000383ffffULL, 0x0093b807030075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0093b807030095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffd400247947ULL, 0x001fea000383ffffULL, 0x0093b817030075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0093b817030095a7ULL, 0x000e24000802007fULL, 0xfffffffc00ec9947ULL, 0x001fea000383ffffULL,
0xffffffd400447947ULL, 0x001fea000383ffffULL, 0x0093b005030075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0093b005030085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffd400e47947ULL, 0x021fea000383ffffULL, 0x00934005030075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00934005030085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffd400d87947ULL, 0x021fea000383ffffULL, 0x00935005070075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x00935005070085a7ULL, 0x000e24000800007fULL, 0xfffffffc00ec8947ULL, 0x001fea000383ffffULL,
0xffffffd800707947ULL, 0x001fea000383ffffULL, 0x0093b005030075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0093b0050300a5a7ULL, 0x000e24000804007fULL, 0xfffffffc00eca947ULL, 0x001fea000383ffffULL,
0xffffffe000847947ULL, 0x001fea000383ffffULL, 0x0093b009030075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0093b0090300a5a7ULL, 0x000e24000804007fULL, 0xfffffffc00eca947ULL, 0x001fea000383ffffULL,
0xffffffe000d47947ULL, 0x001fea000383ffffULL, 0x009398090b0075a7ULL, 0x000b62000804017fULL,
0x0000d0000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x009398090b00a5a7ULL, 0x000e24000804007fULL, 0xfffffffc00eca947ULL, 0x001fea000383ffffULL,
0xffffffe400687947ULL, 0x01ffea000383ffffULL, 0x00000009ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000009ff057e24ULL, 0x000fce000f8e00ffULL, 0x0000000cff037e24ULL, 0x000fc8000f8e00ffULL,
0x00420805030075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x00420805030085a7ULL, 0x000e24000800007fULL,
0xfffffffc00e88947ULL, 0x001fea000383ffffULL, 0xffffffec00607947ULL, 0x001fea000383ffffULL,
0x0000000bff047e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff057e24ULL, 0x000fce000f8e00ffULL,
0x00000009ff0f7e24ULL, 0x000fc8000f8e00ffULL, 0x004200050f0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x004200050f0085a7ULL, 0x000e24000800007fULL, 0xfffffffc00e88947ULL, 0x001fea000383ffffULL,
0xfffffff000447947ULL, 0x001fea000383ffffULL, 0x018000000b097836ULL, 0x000fe20000000000ULL,
0x0000013000037945ULL, 0x000fe80003800000ULL, 0x7f80000009297812ULL, 0x000fc800078ec0ffULL,
0x018000002900780cULL, 0x000fda0003f25070ULL, 0x0000000b00099308ULL, 0x0000620000001000ULL,
0x0000000000389947ULL, 0x000fea0003800000ULL, 0x000000ff2900720cULL, 0x040fe40003f45070ULL,
0x008000002900780cULL, 0x000fe40003f22070ULL, 0x00000001ff2a7807ULL, 0x000fe40001000000ULL,
0x00000001ff097807ULL, 0x002fc80004800000ULL, 0x000000092aff7212ULL, 0x000fda000782fcffULL,
0x00000000001c9947ULL, 0x000fea0003800000ULL, 0x007fffff0bff7812ULL, 0x040fe4000782c0ffULL,
0x800000000b0b7812ULL, 0x001fe400078ec0ffULL, 0x00000001ff097807ULL, 0x000fc80000800000ULL,
0x000000092aff7212ULL, 0x000fda000782c0ffULL, 0x008000000b091812ULL, 0x000fe200078efcffULL,
0x000000ffff099224ULL, 0x000fe200078e000bULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000b00097308ULL, 0x0002a40000001000ULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x007fe400078e0009ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xffffff98086c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100009400ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000015bULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001c5ULL,
0x00000000000001ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000398ULL,
0x0000000000000150ULL, 0x0000000c00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000cbULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000004e8ULL,
0x00000000000000d8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000029ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005c0ULL,
0x0000000000000048ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000043ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000608ULL,
0x0000000000000788ULL, 0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000100000126ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d90ULL,
0x0000000000000020ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x00000004000000b5ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000db0ULL,
0x0000000000000000ULL, 0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000edULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000db0ULL,
0x0000000000000030ULL, 0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x0000000400000114ULL, 0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000de0ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000006dULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e28ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x000000010000008fULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e30ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000100000032ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL,
0x0000000000006700ULL, 0x0000000c00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007fULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000007580ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000057ULL, 0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000007590ULL,
0x0000000000000400ULL, 0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000100000142ULL, 0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000007590ULL,
0x0000000000000310ULL, 0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000007ce0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000007ce0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e28ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000006700ULL, 0x0000000000006700ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000007580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000410ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000007590ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000310ULL,
0x0000000000000310ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_90_cubin_len = 32304;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
