/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015410ULL, 0x0000000000014f90ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000013b30ULL, 0x0000000000000180ULL, 0x000e002200000106ULL, 0x0000000000013cb0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000013cf0ULL, 0x0000000000000110ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000013e00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00013b3000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x004e240400288080ULL,
0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x80162880808a0828ULL,
0x0000000310288082ULL, 0x808a920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x00013b3000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080880900ULL, 0x0900000010042880ULL, 0x288080882880808aULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0xb8082880808a0828ULL, 0x288080a808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080a8ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL,
0x00013cb000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0xa8082880808a0828ULL, 0x288080b808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080b8ULL, 0x0000001cffffffffULL, 0x0000018000000000ULL,
0x00013cf000000000ULL, 0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000a8ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL,
0x0058190300580160ULL, 0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL,
0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL,
0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x0018310400ff1b03ULL, 0x00012ea000012b50ULL, 0x00012f7000012ec0ULL,
0x00012f9000012f80ULL, 0xffffffff00e82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500001fffffffffULL, 0x0500001f0500001fULL, 0xffffffff0500001fULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00e82804ffffffffULL, 0x000000f0000000c0ULL,
0x00001950000018a0ULL, 0x00001a00000019d0ULL, 0x000028e0000028a0ULL, 0x00003fe000003f40ULL,
0x0000408000004050ULL, 0x00004f6000004f20ULL, 0x0000653000006490ULL, 0x000065d0000065a0ULL,
0x0000753000007500ULL, 0x000088b000008820ULL, 0x0000896000008930ULL, 0x00008ec000008e80ULL,
0x0000a6700000a660ULL, 0x0000d1600000d140ULL, 0x0000d6600000d630ULL, 0x000127f0000127c0ULL,
0x0001281000012800ULL, 0x0001285000012830ULL, 0x0001288000012870ULL, 0x00012fc000012f60ULL,
0x00012fe000012fd0ULL, 0x000136a000013620ULL, 0x0001376000013700ULL, 0x00013800000137b0ULL,
0x000138a000013850ULL, 0x00013940000138f0ULL, 0x00013a40000139c0ULL, 0x00013b0000013aa0ULL,
0x0000017003e03904ULL, 0x0000f600000000ffULL, 0x000001b0003f0100ULL, 0x0000f60800000009ULL,
0x000001e0003f0130ULL, 0x0000f61000000009ULL, 0x00000210003f0130ULL, 0x0000f64800000009ULL,
0x00000240003f0120ULL, 0x0000f66800000009ULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL,
0x00000660003f0107ULL, 0x0000f61400000019ULL, 0x00000780003f0102ULL, 0x0000f61000000019ULL,
0x00000c90003f0101ULL, 0x00000000000000ffULL, 0x00000d2000040107ULL, 0x000000200000000aULL,
0x00000ea0003f0101ULL, 0x000000240000000aULL, 0x00000f50003f0106ULL, 0x000000240000000aULL,
0x00000fe0003f0106ULL, 0x000000240000000aULL, 0x00001640003f0106ULL, 0x0000000000000068ULL,
0x000016b000040107ULL, 0x0000000400000020ULL, 0x000016d000040106ULL, 0x0000f60c00000013ULL,
0x000017d0003f0106ULL, 0x0000f60c00000013ULL, 0x00001c80003f0106ULL, 0x0000000400000020ULL,
0x00001d2000040106ULL, 0x0000000400000020ULL, 0x000036a000040106ULL, 0x000000200000000aULL,
0x00003720003f0101ULL, 0x000000000000001cULL, 0x000037d0003f0101ULL, 0x000000240000000aULL,
0x00003820003f0106ULL, 0x000000240000000aULL, 0x000038b0003f0106ULL, 0x000000240000000aULL,
0x00003d10003f0106ULL, 0x00000000000000ffULL, 0x00003d8000060107ULL, 0x000000040000005fULL,
0x00003da0003f0106ULL, 0x0000f61c00000013ULL, 0x00003ea0003f0106ULL, 0x0000f61c00000013ULL,
0x00004350003f0106ULL, 0x0000f64c00000057ULL, 0x00004410003f0106ULL, 0x0000f64c00000057ULL,
0x00005bc0003f0106ULL, 0x000000200000000aULL, 0x00005c50003f0101ULL, 0x000000000000001cULL,
0x00005cf0003f0101ULL, 0x000000240000000aULL, 0x00005d50003f0106ULL, 0x000000240000000aULL,
0x00005de0003f0106ULL, 0x000000240000000aULL, 0x00006220003f0106ULL, 0x0000000000000068ULL,
0x0000629000040107ULL, 0x0000000400000048ULL, 0x000062b0003f0106ULL, 0x0000f62c00000013ULL,
0x000063f0003f0106ULL, 0x0000f62c00000013ULL, 0x00006880003f0106ULL, 0x0000f64c0000001cULL,
0x00006960003f0106ULL, 0x000000040000001eULL, 0x000080f0003f0106ULL, 0x000000200000000aULL,
0x00008170003f0101ULL, 0x000000000000001cULL, 0x00008210003f0101ULL, 0x000000240000000aULL,
0x00008260003f0106ULL, 0x000000240000000aULL, 0x000082f0003f0106ULL, 0x000000240000000aULL,
0x00008610003f0106ULL, 0x00000000000000ffULL, 0x0000868000060107ULL, 0x000000040000005fULL,
0x000086a0003f0106ULL, 0x0000f63c00000013ULL, 0x00008780003f0106ULL, 0x0000f63c00000013ULL,
0x00008c20003f0106ULL, 0x0000f64c0000000eULL, 0x00008cb0003f0106ULL, 0x0000000400000061ULL,
0x0000a3a0003f0106ULL, 0x000000200000000aULL, 0x0000a400003f0101ULL, 0x0000f64000000013ULL,
0x0000f200003f0101ULL, 0x0000f604000000ffULL, 0x0000f290003f0106ULL, 0x0000f604000000ffULL,
0x0000f4b0003f0106ULL, 0x0000f600000000ffULL, 0x0000f4c0003f0101ULL, 0x0000f604000000ffULL,
0x0000f540003f0106ULL, 0x0000f604000000ffULL, 0x00011cc0003f0106ULL, 0x0000f61400000032ULL,
0x000120a0003f0106ULL, 0x0000f61400000032ULL, 0x00013560003f0106ULL, 0x0000f60800000032ULL,
0x00053803003f0101ULL, 0x0000e07000141c04ULL, 0x0000f5900000e4c0ULL, 0x000135c00000f660ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001ecULL, 0x0000001100000002ULL,
0x000000000000016cULL, 0x0000001100000002ULL, 0x00000000000000d4ULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001c7ULL, 0x0000001100000002ULL,
0x0000000000000147ULL, 0x0000001100000002ULL, 0x00000000000000adULL, 0x0000001100000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe20000000a00ULL,
0x00005800ff137624ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000e680000002200ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000000087919ULL, 0x000ee80000002700ULL,
0x00000000002e7919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x0000008000097824ULL, 0x104fe200078e0207ULL, 0x00000005ff507819ULL, 0x000fe20000011607ULL,
0x00001fff06007589ULL, 0x00066600000e0000ULL, 0x000000ff0900720cULL, 0x040fe40003f05270ULL,
0x000000030900780cULL, 0x040fe20003f44070ULL, 0x00001fff50507589ULL, 0x000ea200000e0000ULL,
0x0000007f0900780cULL, 0x040fe20003f24070ULL, 0x0000620008067625ULL, 0x008fe200078e0011ULL,
0x000000010900780cULL, 0x000fce0003f64070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL, 0x00f60002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x3fffff80ff0ca424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0da424ULL, 0x000fe200078e00ffULL, 0x00f608040900a388ULL, 0x0007e2000000ca00ULL,
0x3fffffc0ff0aa424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6100c0900a388ULL, 0x0007e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x00f6480a0900a388ULL, 0x0007e20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x00f4001009009388ULL, 0x0007e80000004800ULL,
0x00f6680e0900b388ULL, 0x0007e80000008a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000026000000947ULL, 0x000fea0003800000ULL, 0x00000000000e7919ULL, 0x01ce620000000000ULL,
0x0000000450047824ULL, 0x000fc400078e00ffULL, 0x0000001013037824ULL, 0x000fe400078e00ffULL,
0x000000102e027824ULL, 0x000fe400078e00ffULL, 0x00000100ff107424ULL, 0x000fe400078e00ffULL,
0x0000000803027224ULL, 0x000fe200078e0202ULL, 0x000000040e097211ULL, 0x042fe200078fe0ffULL,
0x000000100e047824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000102037824ULL, 0x040fe200078e0209ULL, 0x0000000709057812ULL, 0x000fe400078ec0ffULL,
0x000000070b0d7812ULL, 0x000fe200078ec0ffULL, 0x00000001020c7824ULL, 0x000fe200078e020bULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x000fe200078e0010ULL,
0x0000000f050a7812ULL, 0x000fc600078e780eULL, 0x00005c000c047625ULL, 0x000fe200078e0010ULL,
0x0000000f0d0c7812ULL, 0x000fe400078e780eULL, 0x0000000f02027210ULL, 0x080fe20007f1e0ffULL,
0x00000010090a7824ULL, 0x000fe200078e020aULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b0c7824ULL, 0x000fe400078e020cULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100a097824ULL, 0x000fc400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100c0b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c48ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806467981ULL, 0x014ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff527e24ULL, 0x010fe2000f8e00ffULL, 0x0000007f46477810ULL, 0x004fc40007ffe0ffULL,
0x000000ff46457810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff477819ULL, 0x000fe40000011647ULL,
0x00000008ff457819ULL, 0x000fca0000011645ULL, 0x0000df7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011650ULL, 0x0000001050197824ULL, 0x000fe400078e00ffULL,
0x00000003ff027424ULL, 0x00afe200078e00ffULL, 0x01ffffff00037812ULL, 0x000fca00078ec0ffULL,
0x00000002521a7824ULL, 0x000fca00078e0203ULL, 0x000000471a00720cULL, 0x000fda0003f06070ULL,
0x0000000208008824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640000038624ULL, 0x000fe400078e0203ULL, 0xffffffffff007424ULL, 0x000fe400078e00ffULL,
0x000000011a038824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6140219ff738cULL, 0x0003e20000000000ULL, 0x0000600003048625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000804008981ULL, 0x0004e2000c1e1900ULL,
0x00000001ff1b7819ULL, 0x000fe20000011650ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000150447812ULL, 0x000fe200078ec0ffULL, 0x0000000000027919ULL, 0x002e620000000000ULL,
0x0000000152067810ULL, 0x040fe20007ffe0ffULL, 0x0000000852077824ULL, 0x000fe200078e021bULL,
0x000000001b0473c2ULL, 0x000f2200000e0000ULL, 0x0000001044097824ULL, 0x000fe200078e00ffULL,
0x000000450600720cULL, 0x000fe20003f06070ULL, 0x0000002007077824ULL, 0x000fe200078e00ffULL,
0x00f6100019ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000746047217ULL, 0x004fe20007800000ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff397224ULL, 0x000fc400078e00ffULL, 0x0000000104047824ULL, 0x000fca00078e0a07ULL,
0x0000002004047807ULL, 0x000fe40000000000ULL, 0x00000003ff0a7819ULL, 0x002fe20000011602ULL,
0x0000001002217824ULL, 0x000fe200078e00ffULL, 0x0000000904067217ULL, 0x000fe20007800000ULL,
0x000000802e047824ULL, 0x000fe200078e00ffULL, 0x000000040a0e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090b7824ULL, 0x000fe200078e020aULL, 0x000000080a127810ULL, 0x040fe20007ffe0ffULL,
0x0000f64804047891ULL, 0x010fe2000f8e203fULL, 0x0000000c0a167810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0c7824ULL, 0x040fe200078e00ffULL, 0x000000020b037212ULL, 0x080fe200078e3cffULL,
0x00000001090f7824ULL, 0x040fe200078e020eULL, 0x0000006004077812ULL, 0x000fe200078ef807ULL,
0x0000000109117824ULL, 0x000fe200078e0212ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee203ULL,
0x000000080f107824ULL, 0x040fe200078e00ffULL, 0x000000020f037212ULL, 0x080fe200078e3cffULL,
0x00000001091d7824ULL, 0x000fe200078e0216ULL, 0x0000007f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee203ULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x0000000211037212ULL, 0x080fe200078e3cffULL,
0x0000000106097824ULL, 0x000fe200078e0a09ULL, 0x000000021d057212ULL, 0x000fc400078e3cffULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x000020001b037824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x0000008013057824ULL, 0x000fe200078e00ffULL,
0x000000090a00720cULL, 0x080fe40003f46070ULL, 0x0000b000030d7810ULL, 0x000fe40007ffe0ffULL,
0x0000007f0f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000007f11117812ULL, 0x000fe200078ec0ffULL,
0x0000001014177824ULL, 0x100fe200078e020dULL, 0x0000007f1d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff147424ULL, 0x000fe200078e00ffULL, 0x0000007021217812ULL, 0x000fe200078ec0ffULL,
0x000000100c137824ULL, 0x100fe200078e020dULL, 0x000000090e00720cULL, 0x080fe20003f26070ULL,
0x0000001010157824ULL, 0x100fe200078e020dULL, 0x000000091200720cULL, 0x000fe20003f06070ULL,
0x00000010181f7824ULL, 0x000fc400078e020dULL, 0x00000005000a7224ULL, 0x008fc800078e0207ULL,
0x000000010a067824ULL, 0x040fe400078e020bULL, 0x000000010a0b7824ULL, 0x000fe400078e020fULL,
0x00005e0006067625ULL, 0x000fc800078e0014ULL, 0x000000010a0c7824ULL, 0x000fe200078e0211ULL,
0x0000002106107210ULL, 0x000fe20007f7e0ffULL, 0x000000010a0f7824ULL, 0x000fe400078e021dULL,
0x00005e000b0a7625ULL, 0x000fc800078e0014ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0014ULL,
0x000000210a0a7210ULL, 0x000fc60007f9e0ffULL, 0x00005e000f0e7625ULL, 0x000fe200078e0014ULL,
0x000000210c0c7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0607ULL,
0x000000091600720cULL, 0x000fe20003f66070ULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x000000210e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d101c48ULL,
0xff317217ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x000000000a157faeULL, 0x0005e2000c901c48ULL, 0x000000ffff077224ULL, 0x000fc600078e00ffULL,
0x000000000c177faeULL, 0x0003e2000c101c48ULL, 0x000000455200720cULL, 0x000fc60003f06070ULL,
0x000000000e1f7faeULL, 0x0003e8000d901c48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6481b0a7811ULL, 0x004fc600078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000020000aff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000970000000947ULL, 0x000fea0003800000ULL, 0x00000002080b7824ULL, 0x004fe200078e00ffULL,
0x00007610ff6d7816ULL, 0x000fe2000000006dULL, 0x00006400ff087624ULL, 0x000fe200078e00ffULL,
0x00007610ff6f7816ULL, 0x000fe2000000006fULL, 0xff317217ff067424ULL, 0x000fe200078e00ffULL,
0x00007610ff0c7816ULL, 0x002fe2000000000cULL, 0x000000ffff707224ULL, 0x000fc400078e00ffULL,
0x000064000b0b7624ULL, 0x000fe400078e0208ULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0xffffffc019097812ULL, 0x000fca00078ec0ffULL, 0x0000010052097824ULL, 0x000fca00078e0209ULL,
0x000000460900720cULL, 0x000fda0003f06070ULL, 0x000095d000000947ULL, 0x022fea0003800000ULL,
0x000024000a097984ULL, 0x000e620000000800ULL, 0x0000ffff6d087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff6b7224ULL, 0x000fe400078e001aULL, 0x000000ffff0d7224ULL, 0x000fe200078e0070ULL,
0x00008880080f7816ULL, 0x000fca00000000ffULL, 0x800000000f087824ULL, 0x000fca00078e00ffULL,
0x8000000009ff7812ULL, 0x002fe20007804808ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000076106f697816ULL, 0x000fe40000000069ULL, 0x000076106d0e7816ULL, 0x000fe2000000000eULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x000024000a097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000000f107824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x000024000a097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000300ff607624ULL, 0x000fe200078e00ffULL, 0x000000011a087812ULL, 0x000fe200078ec0ffULL,
0x0000010052667824ULL, 0x000fe200078e00ffULL, 0x00000001ff1b7819ULL, 0x000fe40000011650ULL,
0x000000010800780cULL, 0x000fe40003f05070ULL, 0xffffffff60607811ULL, 0x000fe200078e08ffULL,
0x000000201b087824ULL, 0x000fc600078e0266ULL, 0x0000000160607807ULL, 0x000fe40004000000ULL,
0x00000040080f7810ULL, 0x000fc60007ffe0ffULL, 0x000000011a1a7824ULL, 0x000fe200078e0260ULL,
0x0000006004087812ULL, 0x000fc800078ef80fULL, 0x000000471a00720cULL, 0x000fe20003f06070ULL,
0x0000000500167224ULL, 0x000fe200078e0208ULL, 0x00000003ff1c7819ULL, 0x000fe20000011602ULL,
0xffffffffff007424ULL, 0x000fe200078e00ffULL, 0x0000001019117812ULL, 0x000fe400078ec0ffULL,
0x000000041c1e7810ULL, 0x000fce0007ffe0ffULL, 0x000000600b098210ULL, 0x000fe20007ffe06bULL,
0x00000004ff108424ULL, 0x000fe200078e00ffULL, 0x0000000f46127217ULL, 0x000fe20007800000ULL,
0x000000011c137824ULL, 0x000fe400078e0211ULL, 0x0000600009088625ULL, 0x000fe200078e0010ULL,
0x0000000152107810ULL, 0x000fc60007ffe0ffULL, 0x000000011e157824ULL, 0x000fe200078e0211ULL,
0x0000000808008981ULL, 0x000362000c1e1900ULL, 0x0000000c1c4a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112127824ULL, 0x000fe200078e0a0fULL, 0x0000007f130f7812ULL, 0x000fe200078ec0ffULL,
0x0000000850577824ULL, 0x000fe200078e00ffULL, 0x00000002155d7212ULL, 0x080fe200078e3cffULL,
0x000000014a1d7824ULL, 0x000fe200078e0211ULL, 0x000000451000720cULL, 0x000fe20003f06070ULL,
0x00000080ff1f7424ULL, 0x000fe200078e00ffULL, 0xfffffff057577812ULL, 0x000fe200078ec0ffULL,
0x0000000815087824ULL, 0x002fe200078e00ffULL, 0x0000002012127807ULL, 0x000fe20000000000ULL,
0x0000001002227824ULL, 0x000fe200078e00ffULL, 0x000000021d5b7212ULL, 0x0c0fe200078e3cffULL,
0x000000081d107824ULL, 0x000fe200078e00ffULL, 0xfffffff8085d7812ULL, 0x000fe200078ee25dULL,
0x0000000116087824ULL, 0x000fe200078e020fULL, 0x0000000213147212ULL, 0x040fe200078e3cffULL,
0x0000000870207824ULL, 0x000fe200078e00ffULL, 0x000000081c487810ULL, 0x000fe20007ffe0ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000007022217812ULL, 0x000fe200078ec0ffULL,
0x00005e0008087625ULL, 0x000fe200078e001fULL, 0x0000001112127217ULL, 0x000fe20007800000ULL,
0x00000000570473c2ULL, 0x000e6200000e0000ULL, 0xfffffff8105b7812ULL, 0x000fc400078ee25bULL,
0x0000000820687812ULL, 0x000fe200078e0cffULL, 0x0000000112137824ULL, 0x100fe200078e0a11ULL,
0x0000007f15107812ULL, 0x000fe400078ec0ffULL, 0xfffffff817647812ULL, 0x000fe200078ee214ULL,
0x0000000148177824ULL, 0x000fe200078e0211ULL, 0x0000002108087210ULL, 0x000fe20007f1e0ffULL,
0x0000100070117824ULL, 0x000fe200078e00ffULL, 0x00000000680573c2ULL, 0x000ea200000e0000ULL,
0x0000000116147824ULL, 0x000fe200078e0210ULL, 0x0000007f1d127812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000131c00720cULL, 0x000fe20003f06070ULL,
0x00005e0014147625ULL, 0x000fe200078e001fULL, 0x00001000111c7812ULL, 0x000fc400078e0cffULL,
0x0000007f17117812ULL, 0x040fe200078ec0ffULL, 0x0000000817237824ULL, 0x040fe200078e00ffULL,
0x00000002175c7212ULL, 0x000fe200078e3cffULL, 0x00000001161d7824ULL, 0x000fe200078e0212ULL,
0x0000002114147210ULL, 0x000fe20007f5e0ffULL, 0x0000000116177824ULL, 0x000fe200078e0211ULL,
0x000000131e00720cULL, 0x080fe20003f26070ULL, 0x000020001b1e7824ULL, 0x000fe200078e021cULL,
0x000000134a00720cULL, 0x000fe20003f66070ULL, 0x00005e0017167625ULL, 0x080fe200078e001fULL,
0xfffffff8235c7812ULL, 0x000fe200078ee25cULL, 0x0000f64804047890ULL, 0x002fe2000fffe03fULL,
0x0000b0001e1e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e001d1c7625ULL, 0x000fe200078e001fULL,
0x0000002116167210ULL, 0x000fe20007f9e0ffULL, 0x0000000504057290ULL, 0x004fc4000fffe03fULL,
0x000000ffff157224ULL, 0x000fe200010e0615ULL, 0x000000134800720cULL, 0x000fe20003f46070ULL,
0x0000001064647824ULL, 0x100fe200078e021eULL, 0x000000211c1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000105d637824ULL, 0x100fe400078e021eULL, 0x000000ffff177224ULL, 0x000fe200020e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008647faeULL, 0x0003e2000c101c48ULL,
0x000000105c627824ULL, 0x100fe400078e021eULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x0000000014637faeULL, 0x0003e2000c901c48ULL, 0x000000105b617824ULL, 0x000fc400078e021eULL,
0x0000000450137824ULL, 0x000fe200078e00ffULL, 0x0000000016627faeULL, 0x0003e8000d101c48ULL,
0x000000001c617faeULL, 0x0003e2000d901c48ULL, 0xfffffff013137812ULL, 0x000fc600078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040420157984ULL, 0x0022a20008000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f60c0013167984ULL, 0x000ee20000000800ULL,
0x0000ffff6f087812ULL, 0x000fe400078ec0ffULL, 0x0000ffff0c097812ULL, 0x000fe400078ec0ffULL,
0x0000888008217816ULL, 0x000fc400000000ffULL, 0x0000888009147816ULL, 0x000fc600000000ffULL,
0x8000000021087824ULL, 0x000fe400078e00ffULL, 0x8000000014097824ULL, 0x000fc600078e00ffULL,
0x8000000015ff7812ULL, 0x004fe40007804808ULL, 0x8000000016ff7812ULL, 0x008fe20007824809ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fe400078e00ffULL, 0x8000000014167824ULL, 0x000fe400078e00ffULL,
0x0000000800097305ULL, 0x0004e4000021f000ULL, 0x3fa0000008087823ULL, 0x004fe200000100ffULL,
0x000000090000735dULL, 0x008fe40003800000ULL, 0x00f60c0013097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fc40007824816ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000002050167824ULL, 0x000fe200078e00ffULL,
0x00000001ff177819ULL, 0x000fe40000011602ULL, 0x0000007022157812ULL, 0x000fe400078ec0ffULL,
0xffffff8016167812ULL, 0x000fe400078ec0ffULL, 0x0000000c17177812ULL, 0x000fc800078ec0ffULL,
0x0000001617087210ULL, 0x000fca0007ffe015ULL, 0x00f0000008097984ULL, 0x000ea80000000800ULL,
0x00f20000081c7984ULL, 0x0007220000000800ULL, 0x000000060900720bULL, 0x004fda0003f3d000ULL,
0x00000000001d7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1d227812ULL, 0x000fe2000782c0ffULL,
0x00000001ff1d7424ULL, 0x000fd800078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000060900720bULL, 0x018fe40003f34000ULL, 0x0000000906497209ULL, 0x040fe40007810000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011602ULL, 0x00000002ff1d7819ULL, 0x000fe20000011650ULL,
0x8000004906087221ULL, 0x000fe20000010000ULL, 0x000000081e1f7810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b08087820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400008e0100ULL,
0x000000501d00720cULL, 0x000fe40003f25270ULL, 0x0000ffff06237812ULL, 0x000fe200078e3cffULL,
0x0000000800087308ULL, 0x000ea60000000800ULL, 0x0000002322ff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff1d7807ULL, 0x000fc60001000000ULL, 0x0000008050069824ULL, 0x000fc800078e0215ULL,
0x0000000117069824ULL, 0x000fe200078e0206ULL, 0x00001f1f081f7589ULL, 0x004ea200000e0000ULL,
0x8000004909092221ULL, 0x000fe20000010000ULL, 0x0000000807077220ULL, 0x000fe40000410000ULL,
0x00001f1e081e7589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b09092820ULL, 0x000fc60000410000ULL,
0x00f4004906009388ULL, 0x0009e20000000800ULL, 0x0000000900182308ULL, 0x000e620000000800ULL,
0x000000ffff067224ULL, 0x010fe200078e0049ULL, 0x0000001f27277220ULL, 0x084fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f42427220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x000fe20000410000ULL, 0x0000001e25257220ULL, 0x088fe20000410000ULL,
0x0000001e24247220ULL, 0x080fe20000410000ULL, 0x0000001e41417220ULL, 0x080fe20000410000ULL,
0x0000001e40407220ULL, 0x080fe20000410000ULL, 0x0000001e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001e39397220ULL, 0x080fe20000410000ULL,
0x0000001e38387220ULL, 0x080fe20000410000ULL, 0x0000001e35357220ULL, 0x080fe20000410000ULL,
0x0000001e34347220ULL, 0x080fe20000410000ULL, 0x0000001e31317220ULL, 0x080fe20000410000ULL,
0x0000001e30307220ULL, 0x080fe20000410000ULL, 0x0000001e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001e29297220ULL, 0x080fe20000410000ULL,
0x0000001e28287220ULL, 0x000fe20000410000ULL, 0x000000181c1c2220ULL, 0x002fc80000410000ULL,
0x000000071c077221ULL, 0x018fe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000040420087984ULL, 0x000ea20008000800ULL, 0x8000000021097824ULL, 0x000fca00078e00ffULL,
0x8000000008ff7812ULL, 0x004fe20007804809ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x80000000211c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0004e4000021f000ULL,
0x3fa0000008087823ULL, 0x004fe200000100ffULL, 0x000000090000735dULL, 0x008fe40003800000ULL,
0x0000040420097984ULL, 0x000ea40008000800ULL, 0x8000000009ff7812ULL, 0x004fc4000780481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000004501f7824ULL, 0x000fe200078e00ffULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x0000100050087824ULL, 0x000fe200078e00ffULL, 0x000099101d517816ULL, 0x000fe400000000ffULL,
0x000000041f1f7812ULL, 0x000fe400078ec0ffULL, 0xffffe00008217812ULL, 0x000fe400078ec0ffULL,
0x0000001f021f7211ULL, 0x000fe400078fe0ffULL, 0x0000000709087812ULL, 0x000fe200078ec802ULL,
0x0000100070217824ULL, 0x000fe200078e0221ULL, 0x000000021f237810ULL, 0x000fc40007ffe0ffULL,
0x0000001f081c7212ULL, 0x040fe400078e3cffULL, 0x00000023084c7212ULL, 0x000fe200078e3cffULL,
0x0000000250087824ULL, 0x000fe200078e00ffULL, 0x0000000709677812ULL, 0x000fe200078ef802ULL,
0x0000100070097824ULL, 0x000fe200078e0203ULL, 0x0000b000211e7810ULL, 0x000fe40007ffe0ffULL,
0x00000004081f7812ULL, 0x000fe200078ec0ffULL, 0x0000000867557824ULL, 0x040fe200078e024cULL,
0x0000008067537811ULL, 0x040fe200078e18ffULL, 0x0000000867677824ULL, 0x000fe200078e021cULL,
0x0000b000094d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001055207824ULL, 0x002fe200078e021eULL,
0x0000000702097812ULL, 0x000fe200078ec0ffULL, 0x000000011c547824ULL, 0x100fe200078e0253ULL,
0x0000001f02087211ULL, 0x000fe200078fe0ffULL, 0x000000014c537824ULL, 0x000fe200078e0253ULL,
0x0000000809097812ULL, 0x000fe200078ef802ULL, 0x00000010671e7824ULL, 0x000fe200078e021eULL,
0x00000002081c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001054487824ULL, 0x000fe200078e024dULL,
0x0000000708087812ULL, 0x100fe200078e7809ULL, 0x00000200504c7824ULL, 0x000fe200078e00ffULL,
0x000000071c1c7812ULL, 0x000fe200078e7809ULL, 0x00000010534d7824ULL, 0x000fe200078e024dULL,
0x000000002020783bULL, 0x000e620000004200ULL, 0x0000000809087824ULL, 0x000fe200078e0208ULL,
0x000000ff5100720cULL, 0x000fe20003f05270ULL, 0x0000000809567824ULL, 0x000fe200078e021cULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0xfffff8004c097812ULL, 0x000fc400078ec0ffULL,
0x00000018ff9a723eULL, 0x000fe200000010ffULL, 0x000000001e1c783bULL, 0x000ea20000004200ULL,
0x00000002ff9d7819ULL, 0x000fe20000011602ULL, 0x0000001008087824ULL, 0x100fe200078e0209ULL,
0x000054109a9a7816ULL, 0x000fe2000000009aULL, 0x000000004d4c783bULL, 0x000ee20000004200ULL,
0x0000001056097824ULL, 0x000fe200078e0209ULL, 0x00000010ff8b7819ULL, 0x102fe40000011623ULL,
0x000000ff23817812ULL, 0x000fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fc40000011623ULL,
0x0000ffff238c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff1d777812ULL, 0x004fe400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe40000011622ULL, 0x000000ff22807812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5e7819ULL, 0x000fe40000011622ULL, 0x0000ffff228a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff767819ULL, 0x100fe40000011649ULL, 0x000000ff49827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011649ULL, 0x0000ffff49237812ULL, 0x000fe400078ec0ffULL,
0x000000ff1c757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff927819ULL, 0x008fc4000001164dULL,
0x000000ff4d227812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164dULL,
0x0000ffff4d727812ULL, 0x000fe400078ec0ffULL, 0x00000010ff567819ULL, 0x100fe40000011620ULL,
0x000000ff20837812ULL, 0x000fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fc40000011620ULL,
0x0000ffff20587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x100fe40000011621ULL,
0x000000ff217b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011621ULL,
0x0000ffff218f7812ULL, 0x000fe400078ec0ffULL, 0x00000077ff4d723eULL, 0x000fc400020006ffULL,
0x00000010ff7c7819ULL, 0x100fe4000001164cULL, 0x000000ff4c207812ULL, 0x040fe200078ec0ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000018ff217819ULL, 0x000fe4000001164cULL,
0x0000ffff4c8d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe4000001161fULL,
0x00000075ff4c723eULL, 0x000fc400020006ffULL, 0x00000018ff757819ULL, 0x000fe4000001161eULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff4a867812ULL, 0x000fe400078ec0ffULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000077ff947230ULL, 0x000fe20000004100ULL, 0x000000ff4b877812ULL, 0x000fe400078ec0ffULL,
0x00000086ff77723eULL, 0x000fe200020006ffULL, 0x20000075ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fc4000001161dULL, 0x000000ff487a7812ULL, 0x040fe200078ec0ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000087ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff747819ULL, 0x100fe40000011648ULL, 0x00000018ff787819ULL, 0x000fe20000011648ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000ffff48797812ULL, 0x000fe400078ec0ffULL,
0x0000ffff1e877812ULL, 0x000fc400078ec0ffULL, 0x00000010ff487819ULL, 0x000fe4000001164aULL,
0x00000010ff5a7819ULL, 0x000fe4000001164bULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x2000007aff847230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fe200078ec0ffULL, 0x20000078ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff76767812ULL, 0x000fc400078ec0ffULL, 0x00000008ff797819ULL, 0x000fe40000011679ULL,
0x000000ff48487812ULL, 0x000fe400078ec0ffULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000008ff237819ULL, 0x000fe40000011623ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000086ff987230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000083ff917230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000081ff867230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000087ff957230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000007bff8e7230ULL, 0x000fe20000004100ULL, 0x0000ffff1f887812ULL, 0x000fe200078ec0ffULL,
0x20000074ff837230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x20000076ff817230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fc400020006ffULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x2000005eff877230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000079ff7b7230ULL, 0x000fe20000004100ULL,
0x00000085ff78723eULL, 0x000fe200020006ffULL, 0x20000048ff767230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe200020006ffULL, 0x2000005aff747230ULL, 0x000fe20000004100ULL,
0x00000010ff857819ULL, 0x000fe2000001161cULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000ffff4a517812ULL, 0x000fe200078ec0ffULL, 0x20000023ff797230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fc40000011688ULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x00000020ff5a723eULL, 0x000fe400020006ffULL, 0x00000022ff5e723eULL, 0x000fe400020006ffULL,
0x00000021ff48723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x009000000820783bULL, 0x000fe20000000200ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff517819ULL, 0x000fe20000011651ULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000088ff967230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001164aULL, 0x20000085ff977230ULL, 0x000fe20000004100ULL,
0x00000018ff6a7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b6c7812ULL, 0x000fe400078ec0ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000010ff737819ULL, 0x000fc4000001164eULL, 0x000000ff4e4a7812ULL, 0x040fe200078ec0ffULL,
0x20000071ff857230ULL, 0x000fe20000004100ULL, 0x00000018ff4b7819ULL, 0x000fe4000001164eULL,
0x0000ffff4e657812ULL, 0x000fe400078ec0ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x000000ff4f4e7812ULL, 0x000fe400078ec0ffULL, 0x00000080ff88723eULL, 0x000fe200020006ffULL,
0x20000059ff807230ULL, 0x000fe20000004100ULL, 0x00000018ff7e7819ULL, 0x000fe2000001164fULL,
0x2000007fff597230ULL, 0x000fe20000004100ULL, 0x0000004eff7f723eULL, 0x000fe200020006ffULL,
0x20000051ff717230ULL, 0x000fe20000004100ULL, 0x000000089d517810ULL, 0x000fe20007ffe0ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x0000004bff4e723eULL, 0x000fe200020006ffULL,
0x2000007fff4b7230ULL, 0x000fe20000004100ULL, 0x0000007eff9b723eULL, 0x000fe200020006ffULL,
0x00001f9d9a7f7589ULL, 0x000e6200000e0000ULL, 0x000000ff56567812ULL, 0x000fe200078ec0ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL,
0x00001f519a7e7589ULL, 0x0004e200000e0000ULL, 0x00000008ff587819ULL, 0x000fc40000011658ULL,
0x00000008ff8f7819ULL, 0x000fe4000001168fULL, 0x00000056ff90723eULL, 0x000fe200020006ffULL,
0x2000009bff567230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000010ff4c7819ULL, 0x000fe2000001164cULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000010ff9a7819ULL, 0x004fe4000001164dULL, 0x00000010ff4d7819ULL, 0x000fc40000011697ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000010ff9b7819ULL, 0x000fe40000011698ULL,
0x0000008fff99723eULL, 0x000fe200020006ffULL, 0x2000007dff8f7230ULL, 0x000fe20000004100ULL,
0x000010544d4c7816ULL, 0x000fe2000000004cULL, 0x0000007f20208231ULL, 0x082fe200003400ffULL,
0x000010549b4d7816ULL, 0x000fe2000000009aULL, 0x0000007f22228231ULL, 0x000fe200003400ffULL,
0x20000058ff7d7230ULL, 0x000fe20000004100ULL, 0x0000007e21218231ULL, 0x088fe200003400ffULL,
0x20000099ff587230ULL, 0x000fe20000004100ULL, 0x0000007e23238231ULL, 0x000fe200003400ffULL,
0x00000018ff997819ULL, 0x000fc4000001161cULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x00000008ff9a7819ULL, 0x000fe4000001168cULL, 0x00000099ff98723eULL, 0x000fe200020006ffULL,
0x0000004c2028723cULL, 0x000fe20000041828ULL, 0x00000089ff8c723eULL, 0x000fe400020006ffULL,
0x000000ff8b997812ULL, 0x000fe200078ec0ffULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x0000009aff89723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000ffff1c4c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001161dULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x0000ffff1d9a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e1d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8b7819ULL, 0x000fe4000001168aULL,
0x00000099ff8a723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fc4000001161eULL,
0x000000ff1f9c7812ULL, 0x000fe200078ec0ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff997819ULL, 0x000fe4000001161fULL, 0x0000001cff1e723eULL, 0x000fe400020006ffULL,
0x0000001dff1f723eULL, 0x000fe400020006ffULL, 0x00000008ff1c7819ULL, 0x000fe2000001164cULL,
0x2000001eff4c7230ULL, 0x000fe20000004100ULL, 0x00000008ff1d7819ULL, 0x000fe2000001169aULL,
0x2000001fff1e7230ULL, 0x000fe20000004100ULL, 0x0000001cff1c723eULL, 0x000fc400020006ffULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL,
0x2000001cff1c7230ULL, 0x000fe20000004100ULL, 0x000000ff999a7812ULL, 0x000fe200078ec0ffULL,
0x2000001dff1f7230ULL, 0x000fe20000004100ULL, 0x0000004dff99723eULL, 0x000fe400020006ffULL,
0x00000010ff1d7819ULL, 0x000fe40000011698ULL, 0x00000010ff1c7819ULL, 0x000fc4000001161cULL,
0x00000010ff987819ULL, 0x000fe2000001164cULL, 0x20000099ff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fe4000001161fULL, 0x0000009cff97723eULL, 0x000fe400020006ffULL,
0x0000009aff9a723eULL, 0x000fe400020006ffULL, 0x000010541d1c7816ULL, 0x000fe2000000001cULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x00001054981d7816ULL, 0x000fe2000000004dULL,
0x2000009aff1f7230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fc40000011693ULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x00000010ff947819ULL, 0x000fe20000011694ULL,
0x0000001c202c723cULL, 0x000fe2000004182cULL, 0x00000010ff4d7819ULL, 0x000fe40000011696ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00001054944d7816ULL, 0x000fe4000000004dULL,
0x00000010ff1c7819ULL, 0x000fc4000001161eULL, 0x00000010ff1d7819ULL, 0x000fe4000001164cULL,
0x00000010ff1e7819ULL, 0x000fe4000001161fULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x000010541e1d7816ULL, 0x000fe40000000097ULL, 0x00000010ff4c7819ULL, 0x000fe40000011695ULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00001054934c7816ULL, 0x000fe2000000004cULL,
0x0000001c2030723cULL, 0x040fe20000041830ULL, 0x00900000091c783bULL, 0x000e620000000200ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000008ff8d7819ULL, 0x000fe4000001168dULL, 0x0000004c2034723cULL, 0x000fe20000041834ULL,
0x0000008bff8b723eULL, 0x000fc400020006ffULL, 0x0000008dff93723eULL, 0x000fe400020006ffULL,
0x00000010ff8d7819ULL, 0x000fe20000011658ULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00001054904c7816ULL, 0x000fe40000000091ULL, 0x000010548f4d7816ULL, 0x000fe4000000008eULL,
0x00000010ff907819ULL, 0x000fe40000011659ULL, 0x00000010ff8e7819ULL, 0x000fc40000011680ULL,
0x00000010ff597819ULL, 0x000fe2000001167dULL, 0x0000004c2038723cULL, 0x000fe20000041838ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000093ff7d7230ULL, 0x000fe20000004100ULL,
0x000010548e587816ULL, 0x000fe40000000059ULL, 0x0000105490597816ULL, 0x000fe2000000008dULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fe40000011688ULL,
0x00000010ff887819ULL, 0x000fc40000011686ULL, 0x00000010ff867819ULL, 0x000fe20000011687ULL,
0x00000058203c723cULL, 0x000fe2000004183cULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff4d7819ULL, 0x000fe4000001168cULL, 0x00000010ff8d7819ULL, 0x000fe2000001168aULL,
0x0000007f1c1c8231ULL, 0x082fe200003400ffULL, 0x0000105486587816ULL, 0x000fe2000000008bULL,
0x0000007f1e1e8231ULL, 0x000fe200003400ffULL, 0x00000010ff867819ULL, 0x000fe20000011682ULL,
0x0000007e1d1d8231ULL, 0x080fe200003400ffULL, 0x00000010ff827819ULL, 0x000fe20000011685ULL,
0x0000007e1f1f8231ULL, 0x000fe200003400ffULL, 0x00000010ff597819ULL, 0x000fc40000011689ULL,
0x000010544d4c7816ULL, 0x000fe4000000004cULL, 0x000010548d4d7816ULL, 0x000fe40000000088ULL,
0x0000105482597816ULL, 0x000fe40000000059ULL, 0x00000008ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x0000004c2040723cULL, 0x000fe20000041840ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x000000582024723cULL, 0x000fe20000041824ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe2000001167aULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fe2000001167bULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff7c7c7812ULL, 0x000fc400078ec0ffULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x0000105478217816ULL, 0x000fe40000000079ULL, 0x00000010ff227819ULL, 0x000fe40000011677ULL,
0x00000010ff237819ULL, 0x000fe40000011676ULL, 0x00001054834c7816ULL, 0x000fe20000000084ULL,
0x000000201c2c723cULL, 0x000fe2000004182cULL, 0x00001054814d7816ULL, 0x000fc40000000086ULL,
0x00000010ff757819ULL, 0x000fe40000011675ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x0000004c1c28723cULL, 0x000fe20000041828ULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x0000105423227816ULL, 0x000fe20000000022ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x0000105474237816ULL, 0x000fe20000000075ULL,
0x20000092ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fc4000001164fULL,
0x0000ffff4f4f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff727819ULL, 0x000fe20000011672ULL,
0x000000221c30723cULL, 0x000fe20000041830ULL, 0x00000010ff217819ULL, 0x000fe4000001166eULL,
0x00000010ff207819ULL, 0x000fe40000011671ULL, 0x00000010ff4d7819ULL, 0x000fe4000001166aULL,
0x00000010ff6c7819ULL, 0x000fc4000001166cULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x0000105421207816ULL, 0x000fc40000000020ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x000010544d217816ULL, 0x000fe4000000006cULL, 0x00000010ff227819ULL, 0x000fe4000001165aULL,
0x00000010ff237819ULL, 0x000fe4000001167cULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x000000201c34723cULL, 0x000fe20000041834ULL, 0x00000010ff4d7819ULL, 0x000fc40000011680ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe20000000022ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010544d237816ULL, 0x000fe2000000005eULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fc40000011648ULL, 0x00000010ff207819ULL, 0x000fe4000001167dULL,
0x00000010ff497819ULL, 0x000fe20000011649ULL, 0x000000221c38723cULL, 0x000fe20000041838ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x0000105421207816ULL, 0x000fe40000000020ULL,
0x0000105449217816ULL, 0x000fe40000000072ULL, 0x00000010ff227819ULL, 0x000fc4000001164aULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff237819ULL, 0x000fe2000001164bULL,
0x000000201c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff487819ULL, 0x000fe4000001165fULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff567819ULL, 0x000fc40000011656ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x0000105473227816ULL, 0x000fe40000000022ULL, 0x0000105448237816ULL, 0x000fe40000000023ULL,
0x000010544e4e7816ULL, 0x000fe40000000065ULL, 0x00001054564f7816ULL, 0x000fe2000000004fULL,
0x0000010052567824ULL, 0x000fe200078e00ffULL, 0x00000002ff217819ULL, 0x000fe20000011650ULL,
0x000000221c40723cULL, 0x040ff00000041840ULL, 0x0000004e1c24723cULL, 0x000fee0000041824ULL,
0x0000f610211c7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x000020000aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000040211d7824ULL, 0x000fe200078e0256ULL, 0x000000ff6fff7812ULL, 0x000fe2000780c0ffULL,
0x000000001cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff6dff7812ULL, 0x000fc4000784c0ffULL,
0x000000401d1d7810ULL, 0x000fe40007ffe0ffULL, 0x00000001ff6e7807ULL, 0x000fe40000000000ULL,
0x000000461d00720cULL, 0x000fe40003f06070ULL, 0x000000017000780cULL, 0x000fe40003f25270ULL,
0x00000001ff657807ULL, 0x000fe40001000000ULL, 0x0000006f6e6f7207ULL, 0x000fc40004800000ULL,
0x00007610656d7816ULL, 0x000fe4000000006dULL, 0x0000000170707812ULL, 0x000fc600078e0cffULL,
0x00006ca000000947ULL, 0x000fea0003800000ULL, 0x000024000a1c7984ULL, 0x004ea20000000800ULL,
0x80000000651b7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x004fe2000780481bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x000024000a1c7984ULL, 0x000ea40000000800ULL, 0x800000001cff7812ULL, 0x004fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff1b7424ULL, 0x000fe400078e00ffULL, 0x80000000651d7824ULL, 0x000fe400078e00ffULL,
0x0000001b001c7305ULL, 0x0004e4000021f000ULL, 0x3fa000001b1b7823ULL, 0x004fe200000100ffULL,
0x0000001c0000735dULL, 0x008fe40003800000ULL, 0x000024000a1c7984ULL, 0x000ea40000000800ULL,
0x800000001cff7812ULL, 0x004fc4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000001ff1b7819ULL, 0x000fe20000011650ULL,
0x000000080d6a7824ULL, 0x000fe200078e00ffULL, 0x00000001521c7810ULL, 0x000fe20007ffe0ffULL,
0x0000580000227a24ULL, 0x020fe200078e02ffULL, 0x0000001019217812ULL, 0x000fe200078ec0ffULL,
0x000000201b1f7824ULL, 0x000fe200078e0266ULL, 0x000000451c00720cULL, 0x000fe20003f06070ULL,
0x000010000d6c7824ULL, 0x000fe200078e00ffULL, 0x00000021021d7211ULL, 0x000fe200078fe8ffULL,
0x00000080ff4b7424ULL, 0x000fe200078e00ffULL, 0x000000801f1f7810ULL, 0x000fc40007ffe0ffULL,
0x000000086a1e7812ULL, 0x000fe400078ec0ffULL, 0x0000001f461c7217ULL, 0x000fe40007800000ULL,
0x0000f6481b487811ULL, 0x000fe200078e20ffULL, 0x000000001e0773c2ULL, 0x0004e200000e0000ULL,
0x000000086a5f7812ULL, 0x000fe200078e0cffULL, 0x000000011c207824ULL, 0x100fe200078e0a1fULL,
0x000000021d1c7212ULL, 0x040fe200078e3cffULL, 0x000000081d1d7824ULL, 0x000fe200078e00ffULL,
0x00000060041f7812ULL, 0x000fe200078ef81fULL, 0x00000001485f7824ULL, 0x000fe200078e025fULL,
0x0000002020207807ULL, 0x000fe20000000000ULL, 0x00000000480673c2ULL, 0x0008e200000e0000ULL,
0xfffffff81d5e7812ULL, 0x000fe200078ee21cULL, 0x00000080221f7824ULL, 0x000fe200078e021fULL,
0x0000002021207217ULL, 0x000fc40007800000ULL, 0x00000003ff1d7819ULL, 0x000fe20000011602ULL,
0x000000010f1c7824ULL, 0x000fe200078e021fULL, 0x000010006c1e7812ULL, 0x004fe200078ec0ffULL,
0x0000000120207824ULL, 0x000fe200078e0a21ULL, 0x0000000c1d217810ULL, 0x040fe20007ffe0ffULL,
0x0000000110227824ULL, 0x000fe200078e021fULL, 0x000000041d497810ULL, 0x000fe20007ffe0ffULL,
0x000020001b1e7824ULL, 0x000fe200078e021eULL, 0x000000081d237810ULL, 0x040fe40007ffe0ffULL,
0x000000201d00720cULL, 0x080fe20003f66070ULL, 0x00005e001c1c7625ULL, 0x000fe200078e004bULL,
0x000000204900720cULL, 0x000fc40003f46070ULL, 0x000000202300720cULL, 0x080fe20003f26070ULL,
0x00005e0022227625ULL, 0x000fe200078e004bULL, 0x000000202100720cULL, 0x000fe40003f06070ULL,
0x000000151c1c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000111207824ULL, 0x100fe200078e021fULL,
0x0000b0001e487810ULL, 0x010fe20007ffe0ffULL, 0x00000001121f7824ULL, 0x000fe200078e021fULL,
0x0000000706067290ULL, 0x008fe2000fffe03fULL, 0x00005e0020207625ULL, 0x000fc800078e004bULL,
0x00005e001f1e7625ULL, 0x000fe200078e004bULL, 0x0000001520207210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x0000001522227210ULL, 0x080fe20007f9e0ffULL,
0x000000105e5e7824ULL, 0x100fe200078e0248ULL, 0x000000151e1e7210ULL, 0x000fe20007fde0ffULL,
0x000000105d5d7824ULL, 0x100fe400078e0248ULL, 0x000000ffff237224ULL, 0x000fe200020e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c5e7faeULL, 0x0005e2000d901c48ULL,
0x000000105c5c7824ULL, 0x100fe400078e0248ULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x00000000225d7faeULL, 0x0005e2000d101c48ULL, 0x000000105b5b7824ULL, 0x000fc400078e0248ULL,
0x000000ffff1f7224ULL, 0x000fe200030e061fULL, 0x00000000205c7faeULL, 0x0005e8000c901c48ULL,
0x000000001e5b7faeULL, 0x0005e8000c101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004005f1d7984ULL, 0x0044e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f61c00131e7984ULL, 0x000f220000000800ULL, 0x0000ffff6f6f7812ULL, 0x000fe200078ec0ffULL,
0x80000000141f7824ULL, 0x000fc600078e00ffULL, 0x000088806f1c7816ULL, 0x000fca00000000ffULL,
0x800000001c1c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x008fe4000780481cULL,
0x800000001eff7812ULL, 0x010fe2000782481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000450137824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000141e7824ULL, 0x000fe200078e00ffULL,
0xfffffff013137812ULL, 0x000fe400078ec0ffULL, 0x0000001c001d7305ULL, 0x000724000021f000ULL,
0x3fa000001c1c7823ULL, 0x008fe200000100ffULL, 0x0000001d0000735dULL, 0x010fe40003800000ULL,
0x00f61c00131d7984ULL, 0x000ee40000000800ULL, 0x800000001dff7812ULL, 0x008fc4000782481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000080151c7810ULL, 0x000fe20007ffe016ULL, 0x00000001ff487424ULL, 0x000fc800078e00ffULL,
0x00000001171c7824ULL, 0x000fca00078e021cULL, 0x00f000001c1d7984ULL, 0x000ee80000000800ULL,
0x00f200001c1e7984ULL, 0x0008620000000800ULL, 0x000000061d00720bULL, 0x008fda0003f3d000ULL,
0x00000000001f7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1f227812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000061d00720bULL, 0x012fe40003f34000ULL,
0x0000001d06207209ULL, 0x080fe40007810000ULL, 0x00000001501f7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff497819ULL, 0x000fe20000011602ULL, 0x80000020061c7221ULL, 0x040fe20000010000ULL,
0x0000001d06067209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL,
0x00000000001c7806ULL, 0x000fe400008e0100ULL, 0x000000501f00720cULL, 0x000fe20003f25270ULL,
0x0000002100487308ULL, 0x000e620000000800ULL, 0x0000ffff1c237812ULL, 0x000fc800078e3cffULL,
0x0000002322ff7212ULL, 0x000fce000784c0ffULL, 0x00000080504a9824ULL, 0x000fc800078e0215ULL,
0x0000000117239824ULL, 0x000fe200078e024aULL, 0x00001f49481c7589ULL, 0x002e6200000e0000ULL,
0x800000201d222221ULL, 0x000fe20000010000ULL, 0x0000004807077220ULL, 0x000fe40000410000ULL,
0x00001f51481f7589ULL, 0x00072200000e0000ULL, 0x3fb8aa3b22222820ULL, 0x000fc60000410000ULL,
0x00f4002023009388ULL, 0x0005e20000000800ULL, 0x0000002200182308ULL, 0x000f620000000800ULL,
0x00000001ff487807ULL, 0x008fe20001000000ULL, 0x0000001c28287220ULL, 0x082fe20000410000ULL,
0x0000001c29297220ULL, 0x080fe20000410000ULL, 0x0000001c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001c30307220ULL, 0x080fe20000410000ULL,
0x0000001c31317220ULL, 0x080fe20000410000ULL, 0x0000001c34347220ULL, 0x080fe20000410000ULL,
0x0000001c35357220ULL, 0x080fe20000410000ULL, 0x0000001c38387220ULL, 0x080fe20000410000ULL,
0x0000001c39397220ULL, 0x080fe20000410000ULL, 0x0000001c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001c40407220ULL, 0x080fe20000410000ULL,
0x0000001c41417220ULL, 0x080fe20000410000ULL, 0x0000001c24247220ULL, 0x080fe20000410000ULL,
0x0000001c25257220ULL, 0x000fe20000410000ULL, 0x0000001f2a2a7220ULL, 0x090fe20000410000ULL,
0x0000001f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001f32327220ULL, 0x080fe20000410000ULL,
0x0000001f33337220ULL, 0x080fe20000410000ULL, 0x0000001f36367220ULL, 0x080fe20000410000ULL,
0x0000001f37377220ULL, 0x080fe20000410000ULL, 0x0000001f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001f3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001f3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001f42427220ULL, 0x080fe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f26267220ULL, 0x080fe20000410000ULL,
0x0000001f27277220ULL, 0x000fe20000410000ULL, 0x0000001e181e2220ULL, 0x020fc80000410000ULL,
0x000000071e077221ULL, 0x016fe20000010000ULL, 0x0000015000000947ULL, 0x000fea0003800000ULL,
0x000000080d1c7824ULL, 0x040fe200078e00ffULL, 0x000000010d00780cULL, 0x000fc80003f05270ULL,
0x000000081c1c7812ULL, 0x000fca00078e0cffULL, 0x0000000157577824ULL, 0x000fe200078e021cULL,
0x000000696e1c7207ULL, 0x000fc80004000000ULL, 0x00f64c00571d7984ULL, 0x000e620000000800ULL,
0x0000ffff1c1c7812ULL, 0x000fc800078ec0ffULL, 0x000088801c1e7816ULL, 0x000fca00000000ffULL,
0x800000001e1c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x002fe2000780481cULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001e1e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x00f64c00571d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000780481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000010000d4a7824ULL, 0x000fe200078e00ffULL,
0x00009910484c7816ULL, 0x000fe200000000ffULL, 0x00001000501c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa4723eULL, 0x000fe400000010ffULL, 0x000010004a4a7812ULL, 0x000fe400078e0cffULL,
0xffffe0001c1d7812ULL, 0x000fe400078ec0ffULL, 0x0000b00003577810ULL, 0x100fe40007ffe04aULL,
0x0000b0001d207810ULL, 0x000fc40007ffe04aULL, 0x000000ff4c00720cULL, 0x000fe20003f05270ULL,
0x0000001054587824ULL, 0x100fe200078e0257ULL, 0x00005410a4a47816ULL, 0x000fe200000000a4ULL,
0x00000010675a7824ULL, 0x000fe200078e0220ULL, 0x00000002ffa57819ULL, 0x000fe20000011602ULL,
0x0000001055597824ULL, 0x000fe200078e0220ULL, 0x000000005848783bULL, 0x000e620000004200ULL,
0x0000001053577824ULL, 0x000fc600078e0257ULL, 0x000000005a1c783bULL, 0x000ea80000004200ULL,
0x000000005920783bULL, 0x000ee80000004200ULL, 0x00000000574c783bULL, 0x000f220000004200ULL,
0x00000010ff847819ULL, 0x002fe40000011648ULL, 0x000000ff488b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff1da37812ULL, 0x004fe400078ec0ffULL, 0x00000018ffa07819ULL, 0x000fe4000001161dULL,
0x00000010ff807819ULL, 0x100fe4000001161fULL, 0x000000ff1f9c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff9d7819ULL, 0x000fe4000001161fULL, 0x0000ffff1f797812ULL, 0x000fc400078ec0ffULL,
0x000000ff21947812ULL, 0x008fe400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011620ULL,
0x00000018ff897819ULL, 0x000fe40000011648ULL, 0x0000ffff488d7812ULL, 0x000fe400078ec0ffULL,
0x000000a3ff1f723eULL, 0x000fe400020006ffULL, 0x00000018ff8f7819ULL, 0x000fc40000011621ULL,
0x000000a0ff48723eULL, 0x000fe200020006ffULL, 0x2000001fffa07230ULL, 0x000fe20000004100ULL,
0x000000ff23907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fe2000001161eULL,
0x20000048ff1f7230ULL, 0x000fe20000004100ULL, 0x00000018ff837819ULL, 0x000fe40000011622ULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000010ff957819ULL, 0x000fc4000001161dULL,
0x0000ffff1d967812ULL, 0x000fe400078ec0ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x000000ff498c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x100fe4000001164aULL,
0x000000ff4a757812ULL, 0x000fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fc4000001164aULL,
0x0000ffff4a7c7812ULL, 0x000fe400078ec0ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000010ff827819ULL, 0x100fe4000001164bULL, 0x000000ff4b7d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b9a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff9b7819ULL, 0x110fe4000001164cULL, 0x000000ff4c707812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001164cULL, 0x0000ffff4c4a7812ULL, 0x000fe400078ec0ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000010ff917819ULL, 0x000fc40000011621ULL,
0x0000ffff21867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4b7819ULL, 0x100fe4000001164dULL,
0x000000ff4d4c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe4000001164dULL,
0x0000ffff4d777812ULL, 0x000fe400078ec0ffULL, 0x00000097ff48723eULL, 0x000fe200020006ffULL,
0x20000094ff977230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x2000007eff947230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x100fe2000001164eULL,
0x2000008fff7e7230ULL, 0x000fe20000004100ULL, 0x000000ff4e4d7812ULL, 0x040fe200078ec0ffULL,
0x20000090ff8f7230ULL, 0x000fe20000004100ULL, 0x00000018ff217819ULL, 0x000fe2000001164eULL,
0x20000083ff907230ULL, 0x000fe20000004100ULL, 0x0000ffff4e737812ULL, 0x000fe200078ec0ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x0000008cff4e723eULL, 0x000fc400020006ffULL,
0x00000089ff83723eULL, 0x000fe400020006ffULL, 0x00000010ff877819ULL, 0x000fe20000011622ULL,
0x2000004eff897230ULL, 0x000fe20000004100ULL, 0x0000007dff4e723eULL, 0x000fe200020006ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x000000ff22937812ULL, 0x040fe400078ec0ffULL,
0x0000ffff22857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8e7819ULL, 0x000fc40000011623ULL,
0x00000018ff817819ULL, 0x000fe40000011623ULL, 0x0000ffff23887812ULL, 0x000fe400078ec0ffULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x100fe4000001164fULL,
0x000000ff4f237812ULL, 0x000fe400078ec0ffULL, 0x00000018ff227819ULL, 0x000fc4000001164fULL,
0x0000ffff4f6d7812ULL, 0x000fe400078ec0ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000010ff9e7819ULL, 0x000fe4000001161cULL, 0x00000018ff727819ULL, 0x000fe40000011649ULL,
0x0000007aff4f723eULL, 0x000fe200020006ffULL, 0x2000004eff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fc4000001161eULL, 0x00000071ff4e723eULL, 0x000fe200020006ffULL,
0x2000004cff717230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000021ff4c7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff9e9e7812ULL, 0x000fe200078ec0ffULL, 0x20000081ff8c7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000072ff817230ULL, 0x000fe20000004100ULL,
0x000000ff7b217812ULL, 0x000fc400078ec0ffULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000070ff727230ULL, 0x000fe20000004100ULL, 0x00000018ffa27819ULL, 0x000fe4000001161cULL,
0x0000004dff4d723eULL, 0x000fe200020006ffULL, 0x2000006fff707230ULL, 0x000fe20000004100ULL,
0x0000009eff9e723eULL, 0x000fe200020006ffULL, 0x2000004eff6f7230ULL, 0x000fe20000004100ULL,
0x00000022ff22723eULL, 0x000fe200020006ffULL, 0x2000004dff4e7230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fc400020006ffULL, 0x000000ff1e9f7812ULL, 0x040fe200078ec0ffULL,
0x20000022ff4d7230ULL, 0x000fe20000004100ULL, 0x0000ffff1e7f7812ULL, 0x000fe400078ec0ffULL,
0x000000a2ff1e723eULL, 0x000fe200020006ffULL, 0x2000009effa27230ULL, 0x000fe20000004100ULL,
0x000000ff1ca17812ULL, 0x000fe200078ec0ffULL, 0x20000021ff9e7230ULL, 0x000fe20000004100ULL,
0x000000ff95957812ULL, 0x000fe200078ec0ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x000000ff80227812ULL, 0x000fc400078ec0ffULL, 0x00000008ff217819ULL, 0x000fe40000011679ULL,
0x000000a1ffa1723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff927819ULL, 0x000fe20000011620ULL, 0x200000a1ffa37230ULL, 0x000fe20000004100ULL,
0x000000ff20997812ULL, 0x000fe200078ec0ffULL, 0x20000075ff7d7230ULL, 0x000fe20000004100ULL,
0x0000009fff9f723eULL, 0x000fe200020006ffULL, 0x2000004fff757230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fc400020006ffULL, 0x0000ffff20207812ULL, 0x000fe400078ec0ffULL,
0x00000023ff23723eULL, 0x000fe200020006ffULL, 0x20000095ffa17230ULL, 0x000fe20000004100ULL,
0x00000008ff7f7819ULL, 0x000fe4000001167fULL, 0x00000022ff22723eULL, 0x000fe200020006ffULL,
0x20000023ff4f7230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x0000ffff1c987812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe40000011649ULL,
0x0000ffff491c7812ULL, 0x000fe400078ec0ffULL, 0x0000009dff49723eULL, 0x000fe200020006ffULL,
0x2000009fff9d7230ULL, 0x000fe20000004100ULL, 0x0000007fff79723eULL, 0x000fe200020006ffULL,
0x20000022ff9f7230ULL, 0x000fe20000004100ULL, 0x00000008ff957819ULL, 0x000fe20000011620ULL,
0x20000021ff7f7230ULL, 0x000fe20000004100ULL, 0x00000008ff987819ULL, 0x000fe20000011698ULL,
0x009800000820783bULL, 0x000fe20000000200ULL, 0x00000008ff967819ULL, 0x000fe20000011696ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fc400078ec0ffULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000098ff7b7230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000096ff807230ULL, 0x000fe20000004100ULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000092ff987230ULL, 0x000fe20000004100ULL,
0x000000ff87927812ULL, 0x000fe200078ec0ffULL, 0x20000091ff967230ULL, 0x000fe20000004100ULL,
0x00000086ff87723eULL, 0x000fc400020006ffULL, 0x00000008ff917819ULL, 0x000fe20000011685ULL,
0x00001f51a4867589ULL, 0x000e6200000e0000ULL, 0x00000008ff1c7819ULL, 0x000fe2000001161cULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000010ffa37819ULL, 0x000fe200000116a3ULL,
0x00001fa5a4857589ULL, 0x0004e200000e0000ULL, 0x00000010ffa07819ULL, 0x000fe400000116a0ULL,
0x00000010ffa27819ULL, 0x000fe400000116a2ULL, 0x0000009cff9c723eULL, 0x000fc400020006ffULL,
0x00000010ff9f7819ULL, 0x000fe4000001169fULL, 0x00000008ff9a7819ULL, 0x000fe2000001169aULL,
0x2000009cff9c7230ULL, 0x000fe20000004100ULL, 0x00000008ffa47819ULL, 0x004fe40000011688ULL,
0x00000008ffa57819ULL, 0x000fe4000001168dULL, 0x000000a4ff8d723eULL, 0x000fe400020006ffULL,
0x000000ff1da47812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1d7819ULL, 0x000fe200000116a1ULL,
0x0000008621218231ULL, 0x082fe200003400ffULL, 0x0000001cffa1723eULL, 0x000fe200020006ffULL,
0x0000008623238231ULL, 0x000fe200003400ffULL, 0x00001054a21c7816ULL, 0x000fe200000000a3ULL,
0x0000008520208231ULL, 0x088fe200003400ffULL, 0x000010541d1d7816ULL, 0x000fe200000000a0ULL,
0x0000008522228231ULL, 0x000fe200003400ffULL, 0x00000008ffa07819ULL, 0x000fe2000001167cULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000010ff9c7819ULL, 0x000fc4000001169cULL,
0x000000a0ffa0723eULL, 0x000fe400020006ffULL, 0x0000001c2028723cULL, 0x000fe20000041828ULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000095ff95723eULL, 0x000fe400020006ffULL,
0x00000010ff977819ULL, 0x000fe20000011697ULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fe2000001161eULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fc4000001161fULL, 0x00000010ff1e7819ULL, 0x000fe2000001167bULL,
0x200000a0ff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff1f7819ULL, 0x000fe40000011680ULL,
0x000010541d1e7816ULL, 0x000fe4000000001eULL, 0x000010541c1f7816ULL, 0x000fe4000000001fULL,
0x00000010ff1c7819ULL, 0x000fe4000001169dULL, 0x00000010ff1d7819ULL, 0x000fc4000001169eULL,
0x000000ff9ba07812ULL, 0x000fe200078ec0ffULL, 0x0000001e202c723cULL, 0x040fe2000004182cULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x000010549f1d7816ULL, 0x000fe4000000009cULL,
0x0000009aff9b723eULL, 0x000fe400020006ffULL, 0x00000010ff1f7819ULL, 0x000fe40000011648ULL,
0x00000010ff1e7819ULL, 0x000fe20000011649ULL, 0x0000001c2030723cULL, 0x000fe20000041830ULL,
0x00000010ff487819ULL, 0x000fc40000011679ULL, 0x00000010ff497819ULL, 0x000fe2000001167fULL,
0x2000009bff7f7230ULL, 0x000fe20000004100ULL, 0x000000a0ff9a723eULL, 0x000fe400020006ffULL,
0x000010541f487816ULL, 0x000fe40000000048ULL, 0x000010541e497816ULL, 0x000fe20000000049ULL,
0x2000009aff797230ULL, 0x000fe20000004100ULL, 0x00980000091c783bULL, 0x000e620000000200ULL,
0x000000ff4b9b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff9a7819ULL, 0x000fc4000001164aULL,
0x00000010ff4a7819ULL, 0x000fe20000011699ULL, 0x000000482034723cULL, 0x000fe20000041834ULL,
0x00000010ff4b7819ULL, 0x000fe40000011698ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x000010544b4a7816ULL, 0x000fe4000000004aULL,
0x00001054964b7816ULL, 0x000fc40000000097ULL, 0x00000010ff497819ULL, 0x000fe40000011694ULL,
0x00000010ff487819ULL, 0x000fe40000011695ULL, 0x00000010ff977819ULL, 0x000fe2000001167eULL,
0x0000004a2038723cULL, 0x000fe20000041838ULL, 0x00000010ff947819ULL, 0x000fe40000011687ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fc400020006ffULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x0000105449487816ULL, 0x000fe20000000048ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000105497497816ULL, 0x000fe20000000094ULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x000000ff8a887812ULL, 0x000fe200078ec0ffULL,
0x000000851c1c8231ULL, 0x082fe200003400ffULL, 0x00000010ff4a7819ULL, 0x000fe20000011693ULL,
0x00000048203c723cULL, 0x000fe2000004183cULL, 0x00000010ff4b7819ULL, 0x000fe20000011692ULL,
0x000000851e1e8231ULL, 0x000fe200003400ffULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x000000861d1d8231ULL, 0x080fe200003400ffULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x000000861f1f8231ULL, 0x000fe200003400ffULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff497819ULL, 0x000fe4000001168dULL, 0x00000084ff8a723eULL, 0x000fe400020006ffULL,
0x000000a5ff84723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x000010544b4a7816ULL, 0x000fe2000000004aULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x000010548e4b7816ULL, 0x000fe2000000008fULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x0000105490487816ULL, 0x000fc40000000091ULL,
0x000010548c497816ULL, 0x000fe40000000049ULL, 0x000000ff82a27812ULL, 0x000fe200078ec0ffULL,
0x200000a1ff827230ULL, 0x000fe20000004100ULL, 0x000000a4ffa4723eULL, 0x000fe200020006ffULL,
0x0000004a2040723cULL, 0x040fe20000041840ULL, 0x000000a2ffa1723eULL, 0x000fe400020006ffULL,
0x00000010ff837819ULL, 0x000fe20000011683ULL, 0x200000a4ff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe2000001168bULL, 0x200000a1ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x000000482024723cULL, 0x000fe20000041824ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000010ff227819ULL, 0x000fe40000011681ULL,
0x00000010ff207819ULL, 0x000fe20000011684ULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe40000011682ULL, 0x0000105483207816ULL, 0x000fc40000000020ULL,
0x0000105422217816ULL, 0x000fe40000000021ULL, 0x000010548a4a7816ULL, 0x000fe4000000008bULL,
0x00001054884b7816ULL, 0x000fe40000000089ULL, 0x00000010ff227819ULL, 0x000fe2000001167dULL,
0x000000201c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff237819ULL, 0x000fe4000001167cULL,
0x00000010ff7a7819ULL, 0x000fc4000001167aULL, 0x00000010ff497819ULL, 0x000fe40000011680ULL,
0x0000009bff9b723eULL, 0x000fe200020006ffULL, 0x0000004a1c28723cULL, 0x000fe20000041828ULL,
0x00000008ff777819ULL, 0x000fe40000011677ULL, 0x0000105423227816ULL, 0x000fe20000000022ULL,
0x2000009bff877230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe40000011676ULL,
0x00000010ff207819ULL, 0x000fc4000001167bULL, 0x0000105449237816ULL, 0x000fe4000000007aULL,
0x00000010ff4a7819ULL, 0x000fe40000011675ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x0000009aff9a723eULL, 0x000fe200020006ffULL, 0x000000221c30723cULL, 0x000fe20000041830ULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000105421207816ULL, 0x000fe20000000020ULL,
0x2000009aff7e7230ULL, 0x000fe20000004100ULL, 0x000010544a217816ULL, 0x000fe2000000007fULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x000000ff78787812ULL, 0x000fc400078ec0ffULL,
0x000000ff74747812ULL, 0x000fe400078ec0ffULL, 0x00000010ff237819ULL, 0x000fe20000011671ULL,
0x000000201c34723cULL, 0x000fe20000041834ULL, 0x00000010ff4a7819ULL, 0x000fe40000011687ULL,
0x00000010ff227819ULL, 0x000fe40000011672ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000078ff48723eULL, 0x000fc400020006ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x000010544a237816ULL, 0x000fe40000000023ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe40000011670ULL,
0x00000010ff207819ULL, 0x000fc4000001167eULL, 0x0000105479227816ULL, 0x000fe40000000022ULL,
0x00000010ff4a7819ULL, 0x000fe4000001166fULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x000000221c38723cULL, 0x000fe20000041838ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x0000105421207816ULL, 0x000fe20000000020ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000010544a217816ULL, 0x000fe20000000077ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000010ff227819ULL, 0x000fc4000001164eULL,
0x00000010ff237819ULL, 0x000fe40000011648ULL, 0x00000010ff4f7819ULL, 0x000fe2000001164fULL,
0x000000201c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x0000105423227816ULL, 0x000fe40000000022ULL, 0x0000105474237816ULL, 0x000fe4000000004fULL,
0x00000010ff217819ULL, 0x000fc4000001164cULL, 0x00000010ff207819ULL, 0x000fe40000011673ULL,
0x00000010ff487819ULL, 0x000fe2000001164dULL, 0x000000221c40723cULL, 0x000fe20000041840ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x0000105421207816ULL, 0x000fe40000000020ULL,
0x0000105448217816ULL, 0x000fe4000000006dULL, 0x00000002ff237819ULL, 0x000fc40000011650ULL,
0x000000010d00780cULL, 0x000fc60003f05270ULL, 0x000000201c24723cULL, 0x000fee0000041824ULL,
0x0000f620231c7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x000020000aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000696e6e7207ULL, 0x000fe20004000000ULL, 0x00000004521d7824ULL, 0x000fe200078e0223ULL,
0x000000010dff7812ULL, 0x000fe2000782c0ffULL, 0x000000001cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff6eff7812ULL, 0x000fc4000784c0ffULL, 0x000000801d1d7811ULL, 0x000fe400078e30ffULL,
0x00000001ff697807ULL, 0x000fe40001000000ULL, 0x000000461d00720cULL, 0x000fe40003f46070ULL,
0x000000ff0eff7812ULL, 0x000fe4000780c0ffULL, 0x0000006e696f7207ULL, 0x000fe40004800000ULL,
0x00000001ff6d7807ULL, 0x000fc40004000000ULL, 0x000000010d707812ULL, 0x000fca00078ec0ffULL,
0x0000478000002947ULL, 0x000fea0003800000ULL, 0x000024000a1b7984ULL, 0x004ea20000000800ULL,
0x00000001ff1c7807ULL, 0x000fca0004000000ULL, 0x800000001c1a7824ULL, 0x000fca00078e00ffULL,
0x800000001bff7812ULL, 0x004fe2000782481aULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x000024000a1b7984ULL, 0x000ea40000000800ULL,
0x800000001bff7812ULL, 0x004fe4000782481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000001c1c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1a7424ULL, 0x000fc800078e00ffULL, 0x0000001a001b7305ULL, 0x0004e4000021f000ULL,
0x3fa000001a1a7823ULL, 0x004fe200000100ffULL, 0x0000001b0000735dULL, 0x008fe40003800000ULL,
0x000024000a1b7984ULL, 0x000ea40000000800ULL, 0x800000001bff7812ULL, 0x004fc4000782481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000016b1a7824ULL, 0x000fe400078e0260ULL, 0x00000300ff1b7624ULL, 0x000fe400078e00ffULL,
0x0000580000217a24ULL, 0x000fe200078e02ffULL, 0x000000011a1c7812ULL, 0x000fe200078ec0ffULL,
0xffffffffff007424ULL, 0x000fe200078e00ffULL, 0xffffffff1b1b7811ULL, 0x000fe400078e08ffULL,
0x000000011c00780cULL, 0x000fc80003f25070ULL, 0x000000011b1b7807ULL, 0x000fca0004800000ULL,
0x000000011a1a7824ULL, 0x000fe200078e021bULL, 0x00000001ff1b7819ULL, 0x000fc80000011650ULL,
0x000000471a00720cULL, 0x000fe20003f26070ULL, 0x000000201b1f7824ULL, 0x000fca00078e0266ULL,
0x000000c01f1f7810ULL, 0x000fce0007ffe0ffULL, 0x000000011a1c9824ULL, 0x000fe400078e020bULL,
0x00000004ff1d9424ULL, 0x000fe200078e00ffULL, 0x0000001f46207217ULL, 0x000fc60007800000ULL,
0x000060001c1c9625ULL, 0x000fe200078e001dULL, 0x0000000152227810ULL, 0x000fc60007ffe0ffULL,
0x0000000120207824ULL, 0x100fe200078e0a1fULL, 0x000000081c009981ULL, 0x000562000c1e1900ULL,
0x000000452200720cULL, 0x000fe20003f26070ULL, 0x00000080ff4d7424ULL, 0x000fe200078e00ffULL,
0x00000060041e7812ULL, 0x000fe200078ef81fULL, 0x0000000850607824ULL, 0x000fe200078e00ffULL,
0x00000010191f7812ULL, 0x000fe400078ec0ffULL, 0x0000002020207807ULL, 0x000fe20000800000ULL,
0x0000008021217824ULL, 0x000fe200078e021eULL, 0x00000003ff497819ULL, 0x000fc40000011602ULL,
0x000000201f207217ULL, 0x000fe20007800000ULL, 0x000000010f1c7824ULL, 0x104fe200078e0221ULL,
0x0000000449237810ULL, 0x040fe20007ffe0ffULL, 0x00000001101e7824ULL, 0x000fe200078e0221ULL,
0x00000008494b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000120487824ULL, 0x000fe200078e0a1fULL,
0xfffffff060607812ULL, 0x000fe200078ec0ffULL, 0x0000000111207824ULL, 0x000fe400078e0221ULL,
0x00005e001c1c7625ULL, 0x000fe200078e004dULL, 0x000000484900720cULL, 0x000fc40003f46070ULL,
0x0000000c49497810ULL, 0x000fe20007ffe0ffULL, 0x00005e001e1e7625ULL, 0x000fe200078e004dULL,
0x000000151c1c7210ULL, 0x000fc60007f3e0ffULL, 0x0000000112227824ULL, 0x000fe200078e0221ULL,
0x000000151e1e7210ULL, 0x000fe20007f7e0ffULL, 0x00005e0020207625ULL, 0x000fc800078e004dULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000001520207210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x000000482300720cULL, 0x080fe20003f26070ULL,
0x00005e0022227625ULL, 0x000fe200078e004dULL, 0x000000484b00720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c647faeULL, 0x0005e4000d101c48ULL,
0x000000ffff217224ULL, 0x000fe200020e0621ULL, 0x000000484900720cULL, 0x000fe40003f86070ULL,
0x0000001522227210ULL, 0x000fc40007fbe0ffULL, 0x000000086a487812ULL, 0x000fe400078ec0ffULL,
0x0000f64860497810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200028e0623ULL,
0x000000001e637faeULL, 0x0005e6000c901c48ULL, 0x0000000149487824ULL, 0x000fe200078e0248ULL,
0x0000000020627faeULL, 0x0005e8000d901c48ULL, 0x0000000022617faeULL, 0x0005e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000400481d7984ULL, 0x0044e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f62c00131e7984ULL, 0x000f220000000800ULL,
0x000000010dff7812ULL, 0x000fe2000782c0ffULL, 0x80000000141f7824ULL, 0x000fe200078e00ffULL,
0x000000086a617812ULL, 0x000fc400078e0cffULL, 0x0000006e69627207ULL, 0x000fc80004800000ULL,
0x0000ffff621c7812ULL, 0x000fc800078ec0ffULL, 0x000088801c237816ULL, 0x000fca00000000ffULL,
0x80000000231c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x008fe4000784481cULL,
0x800000001eff7812ULL, 0x010fe2000786481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000000149617824ULL, 0x000fe200078e0261ULL, 0x000000b000003947ULL, 0x000fea0003800000ULL,
0x0000000450137824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x80000000141e7824ULL, 0x000fe200078e00ffULL, 0xfffffff013137812ULL, 0x000fe400078ec0ffULL,
0x0000001c001d7305ULL, 0x000724000021f000ULL, 0x3fa000001c1c7823ULL, 0x008fe200000100ffULL,
0x0000001d0000735dULL, 0x010fe40003800000ULL, 0x00f62c00131d7984ULL, 0x000ee40000000800ULL,
0x800000001dff7812ULL, 0x008fc4000786481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000b947ULL, 0x000fea000383ffffULL, 0x00000100151c7810ULL, 0x000fe20007ffe016ULL,
0x00000001ff487424ULL, 0x004fc800078e00ffULL, 0x00000001171c7824ULL, 0x000fca00078e021cULL,
0x00f000001c1d7984ULL, 0x000ea80000000800ULL, 0x00f200001c1e7984ULL, 0x0007220000000800ULL,
0x000000061d00720bULL, 0x004fda0003f7d000ULL, 0x00000000001f7806ULL, 0x000fc800018e0100ULL,
0x0000ffff1f227812ULL, 0x000fda000786c0ffULL, 0x000003700000b947ULL, 0x000fea0003800000ULL,
0x000000061d00720bULL, 0x018fe40003f74000ULL, 0x0000001d06207209ULL, 0x080fe40007810000ULL,
0x00000002501f7811ULL, 0x000fe400078ff0ffULL, 0x00000002ff4b7819ULL, 0x000fe20000011602ULL,
0x80000020061c7221ULL, 0x040fe20000010000ULL, 0x0000001d06067209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL, 0x00000000001c7806ULL, 0x000fe400018e0100ULL,
0x000000501f00720cULL, 0x000fe20003f65270ULL, 0x0000002100487308ULL, 0x000ea20000000800ULL,
0x0000ffff1c497812ULL, 0x000fc800078e3cffULL, 0x0000004922ff7212ULL, 0x000fce000788c0ffULL,
0x00000080504ab824ULL, 0x000fc800078e0215ULL, 0x000000011749b824ULL, 0x000fe200078e024aULL,
0x00001f4b481c7589ULL, 0x004ea200000e0000ULL, 0x800000201d224221ULL, 0x000fe20000010000ULL,
0x0000004807077220ULL, 0x000fe40000410000ULL, 0x00001f51481f7589ULL, 0x00072200000e0000ULL,
0x3fb8aa3b22224820ULL, 0x000fc60000410000ULL, 0x00f400204900b388ULL, 0x0003e20000000800ULL,
0x0000002200184308ULL, 0x000e620000000800ULL, 0x00000001ff487807ULL, 0x008fe20002000000ULL,
0x0000001c28287220ULL, 0x084fe20000410000ULL, 0x0000001c29297220ULL, 0x080fe20000410000ULL,
0x0000001c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001c30307220ULL, 0x080fe20000410000ULL, 0x0000001c31317220ULL, 0x080fe20000410000ULL,
0x0000001c34347220ULL, 0x080fe20000410000ULL, 0x0000001c35357220ULL, 0x080fe20000410000ULL,
0x0000001c38387220ULL, 0x080fe20000410000ULL, 0x0000001c39397220ULL, 0x080fe20000410000ULL,
0x0000001c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001c40407220ULL, 0x080fe20000410000ULL, 0x0000001c41417220ULL, 0x080fe20000410000ULL,
0x0000001c24247220ULL, 0x080fe20000410000ULL, 0x0000001c25257220ULL, 0x000fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x090fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f42427220ULL, 0x080fe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x000fe20000410000ULL,
0x0000001e181e4220ULL, 0x002fc80000410000ULL, 0x000000071e077221ULL, 0x018fe20000010000ULL,
0x0000015000002947ULL, 0x000fea0003800000ULL, 0x000000086a1d7812ULL, 0x000fca00078ec0ffULL,
0x00000001601c7824ULL, 0x000fe400078e021dULL, 0x80000000231d7824ULL, 0x000fc800078e00ffULL,
0x00f64c001c1c7984ULL, 0x000ea40000000800ULL, 0x800000001cff7812ULL, 0x004fe4000784481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000850607824ULL, 0x000fe400078e00ffULL, 0x000000080d1d7824ULL, 0x000fe400078e00ffULL,
0x8000000023207824ULL, 0x000fe200078e00ffULL, 0xfffffff060607812ULL, 0x000fe200078ec0ffULL,
0x3e000000ff1c7424ULL, 0x000fe200078e00ffULL, 0x000000081d1d7812ULL, 0x000fc800078ec0ffULL,
0x0000f6481d1e7810ULL, 0x000fe40007ffe060ULL, 0x0000001c001d7305ULL, 0x0004e4000021f000ULL,
0x3fa000001c1c7823ULL, 0x004fe200000100ffULL, 0x0000001d0000735dULL, 0x008fe40003800000ULL,
0x000004001e1d7984ULL, 0x000ea40000000800ULL, 0x800000001dff7812ULL, 0x004fe40007844820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00001000501c7824ULL, 0x000fe200078e00ffULL, 0x000010006c4c7812ULL, 0x000fc400078ec0ffULL,
0x00009910484d7816ULL, 0x000fe400000000ffULL, 0xffffe0001c1d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d00720cULL, 0x000fe40003f45270ULL, 0x0000b0001d207810ULL, 0x100fe40007ffe04cULL,
0x0000b000034c7810ULL, 0x000fe40007ffe04cULL, 0x00000018ff96723eULL, 0x000fe200000010ffULL,
0x00000010671c7824ULL, 0x000fe200078e0220ULL, 0x00000002ff997819ULL, 0x000fe20000011602ULL,
0x0000001054497824ULL, 0x000fe200078e024cULL, 0x0000541096967816ULL, 0x000fe20000000096ULL,
0x00000010534c7824ULL, 0x000fc400078e024cULL, 0x0000001055207824ULL, 0x000fe200078e0220ULL,
0x000000001c1c783bULL, 0x000ea80000004200ULL, 0x000000004948783bULL, 0x000ee80000004200ULL,
0x000000004c4c783bULL, 0x000f280000004200ULL, 0x000000002020783bULL, 0x000e620000004200ULL,
0x00000010ff687819ULL, 0x004fc4000001161cULL, 0x000000ff1c907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x008fe40000011648ULL, 0x000000ff486d7812ULL, 0x000fe400078ec0ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000018ff727819ULL, 0x000fe40000011649ULL,
0x000000ff49737812ULL, 0x000fe200078ec0ffULL, 0x2000006cff787230ULL, 0x000fe20000004100ULL,
0x000000ff4a767812ULL, 0x000fc400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000018ff917819ULL, 0x000fe4000001164aULL, 0x00000010ff7e7819ULL, 0x000fe20000011648ULL,
0x2000006dff7c7230ULL, 0x000fe20000004100ULL, 0x0000ffff486e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe4000001164bULL, 0x000000ff4d487812ULL, 0x010fc400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000076ff6c723eULL, 0x000fe200020006ffULL, 0x20000072ff767230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x102fe20000011621ULL, 0x20000073ff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff21837812ULL, 0x000fe200078ec0ffULL, 0x2000006cff727230ULL, 0x000fe20000004100ULL,
0x00000018ff817819ULL, 0x000fc40000011621ULL, 0x0000ffff218c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c947812ULL, 0x000fe400078ec0ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000010ff7f7819ULL, 0x000fe40000011649ULL, 0x0000ffff49777812ULL, 0x000fe200078ec0ffULL,
0x20000091ff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff6f7819ULL, 0x000fc4000001164aULL,
0x0000ffff4a217812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b937812ULL, 0x000fe400078ec0ffULL,
0x00000092ff6d723eULL, 0x000fe400020006ffULL, 0x00000018ff497819ULL, 0x000fe4000001164cULL,
0x00000018ff4a7819ULL, 0x000fe2000001164dULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000048ff92723eULL, 0x000fc400020006ffULL, 0x00000018ff537819ULL, 0x000fe4000001161cULL,
0x0000ffff1c7b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7a7819ULL, 0x100fe4000001161dULL,
0x000000ff1d8f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff867819ULL, 0x000fe4000001161dULL,
0x0000ffff1d8b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe4000001164dULL,
0x0000ffff4d707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1c7819ULL, 0x100fe4000001161eULL,
0x000000ff1e887812ULL, 0x040fe400078ec0ffULL, 0x00000018ff857819ULL, 0x000fe4000001161eULL,
0x0000ffff1e1d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8a7819ULL, 0x100fe4000001161fULL,
0x000000ff1f897812ULL, 0x040fe400078ec0ffULL, 0x00000018ff877819ULL, 0x000fe4000001161fULL,
0x0000ffff1f8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x000fe40000011622ULL,
0x000000ff22847812ULL, 0x000fc400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe40000011622ULL,
0x0000ffff22667812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001164eULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000010ff1f7819ULL, 0x100fe40000011620ULL,
0x000000ff20827812ULL, 0x000fe200078ec0ffULL, 0x20000094ff487230ULL, 0x000fe20000004100ULL,
0x00000018ff807819ULL, 0x000fc40000011620ULL, 0x0000ffff201e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x100fe40000011623ULL, 0x000000ff23797812ULL, 0x040fe400078ec0ffULL,
0x00000018ff757819ULL, 0x000fe40000011623ULL, 0x0000ffff23677812ULL, 0x000fe400078ec0ffULL,
0x00000010ff747819ULL, 0x000fc4000001164bULL, 0x0000ffff4b227812ULL, 0x000fe400078ec0ffULL,
0x00000093ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff237819ULL, 0x000fe4000001164cULL,
0x0000ffff4c207812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff4f4b7812ULL, 0x000fe400078ec0ffULL, 0x00000049ff91723eULL, 0x000fe200020006ffULL,
0x20000092ff497230ULL, 0x000fe20000004100ULL, 0x0000004aff93723eULL, 0x000fc400020006ffULL,
0x00000010ff717819ULL, 0x000fe2000001164eULL, 0x20000091ff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff4e4c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e6b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001164fULL, 0x0000004dff92723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fc400020006ffULL, 0x0000004bff94723eULL, 0x000fe200020006ffULL,
0x20000093ff4b7230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000004eff93723eULL, 0x000fe200020006ffULL, 0x20000092ff4e7230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x20000086ff927230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000082ff867230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000094ff4d7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x2000008fff947230ULL, 0x000fe20000004100ULL,
0x00000084ff82723eULL, 0x000fe200020006ffULL, 0x20000088ff8f7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000085ff887230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000081ff857230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000082ff817230ULL, 0x000fe20000004100ULL,
0x00000008ff6e7819ULL, 0x000fe2000001166eULL, 0x20000079ff827230ULL, 0x000fe20000004100ULL,
0x000000ff7f797812ULL, 0x000fc400078ec0ffULL, 0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000008ff217819ULL, 0x000fe40000011621ULL,
0x00000008ff227819ULL, 0x000fe40000011622ULL, 0x000000ff23237812ULL, 0x000fe400078ec0ffULL,
0x00000053ff91723eULL, 0x000fe200020006ffULL, 0x20000093ff537230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000090ff937230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000089ff907230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000087ff897230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL, 0x20000083ff877230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000080ff847230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000064ff837230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000079ff807230ULL, 0x000fe20000004100ULL,
0x000000ff74747812ULL, 0x000fe200078ec0ffULL, 0x2000006eff797230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fc400020006ffULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x20000021ff6e7230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x00000008ff207819ULL, 0x000fe40000011620ULL,
0x0000007eff7f723eULL, 0x000fe200020006ffULL, 0x20000075ff7e7230ULL, 0x000fe20000004100ULL,
0x00000074ff75723eULL, 0x000fe200020006ffULL, 0x2000006fff747230ULL, 0x000fe20000004100ULL,
0x00000063ff64723eULL, 0x000fe200020006ffULL, 0x20000022ff6f7230ULL, 0x000fe20000004100ULL,
0x00000020ff97723eULL, 0x000fe200020006ffULL, 0x20000023ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe2000001167bULL, 0x00a000000820783bULL, 0x000fe20000000200ULL,
0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x000000ff68957812ULL, 0x000fe200078ec0ffULL, 0x20000097ff687230ULL, 0x000fe20000004100ULL,
0x00000008ff987819ULL, 0x000fe2000001168bULL, 0x2000007bff977230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x2000007aff9a7230ULL, 0x000fe20000004100ULL,
0x00001f99967b7589ULL, 0x000e6200000e0000ULL, 0x000000ff1c1c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff1d7819ULL, 0x000fe2000001161dULL, 0x00001f51967a7589ULL, 0x0004e200000e0000ULL,
0x00000098ff98723eULL, 0x000fe200020006ffULL, 0x20000095ff8b7230ULL, 0x000fe20000004100ULL,
0x00000008ff8d7819ULL, 0x000fe4000001168dULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x0000001dff1d723eULL, 0x000fe400020006ffULL, 0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL,
0x0000008dff9b723eULL, 0x000fe200020006ffULL, 0x20000098ff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff1f1f7812ULL, 0x000fe200078ec0ffULL, 0x2000001cff987230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000001dff957230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe20000011693ULL, 0x2000009bff967230ULL, 0x004fe20000004100ULL,
0x00000010ff1d7819ULL, 0x000fe20000011694ULL, 0x2000008aff997230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fc4000001168bULL, 0x00000010ff9a7819ULL, 0x000fe2000001169aULL,
0x0000007b2020a231ULL, 0x082fe200003400ffULL, 0x0000001fff1f723eULL, 0x000fe200020006ffULL,
0x0000007b2222a231ULL, 0x000fe200003400ffULL, 0x00000008ff1e7819ULL, 0x000fe2000001161eULL,
0x0000007a2121a231ULL, 0x088fe200003400ffULL, 0x000010548b1c7816ULL, 0x000fe2000000001cULL,
0x0000007a2323a231ULL, 0x000fe200003400ffULL, 0x000010549a1d7816ULL, 0x000fe2000000001dULL,
0x2000001fff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff937819ULL, 0x000fc4000001168cULL,
0x0000001eff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x0000001c2028723cULL, 0x000fe20000041828ULL, 0x00000010ff927819ULL, 0x000fe20000011692ULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe40000011697ULL,
0x00000010ff1f7819ULL, 0x000fe4000001168dULL, 0x000000ff8e8e7812ULL, 0x000fc400078ec0ffULL,
0x00001054911e7816ULL, 0x000fe4000000001eULL, 0x00001054921f7816ULL, 0x000fe4000000001fULL,
0x00000010ff1c7819ULL, 0x000fe4000001168fULL, 0x00000010ff1d7819ULL, 0x000fe40000011698ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x0000001e202c723cULL, 0x000fe2000004182cULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000010ff997819ULL, 0x000fe20000011699ULL,
0x2000008eff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff54547812ULL, 0x000fe400078ec0ffULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x000010541d1c7816ULL, 0x000fe4000000001cULL,
0x00001054991d7816ULL, 0x000fe40000000090ULL, 0x00000054ff8e723eULL, 0x000fc400020006ffULL,
0x00000055ff8f723eULL, 0x000fe400020006ffULL, 0x00000010ff1f7819ULL, 0x000fe20000011688ULL,
0x0000001c2030723cULL, 0x000fe20000041830ULL, 0x00000010ff1e7819ULL, 0x000fe20000011689ULL,
0x2000008eff897230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe20000011695ULL,
0x2000008fff887230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fe40000011696ULL,
0x000010541f547816ULL, 0x000fc40000000054ULL, 0x000010541e557816ULL, 0x000fe40000000055ULL,
0x00a00000091c783bULL, 0x000e620000000200ULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe40000011666ULL, 0x00000008ff8f7819ULL, 0x000fe20000011667ULL,
0x20000093ff8d7230ULL, 0x000fe20000004100ULL, 0x000000542034723cULL, 0x000fe20000041834ULL,
0x00000010ff667819ULL, 0x000fc40000011686ULL, 0x00000010ff677819ULL, 0x000fe4000001168aULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff557819ULL, 0x000fe40000011684ULL,
0x00000010ff547819ULL, 0x000fe4000001168cULL, 0x00000010ff867819ULL, 0x000fe4000001168bULL,
0x00000010ff847819ULL, 0x000fc40000011685ULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000105467667816ULL, 0x000fe20000000066ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000105455547816ULL, 0x000fe20000000054ULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x0000105486677816ULL, 0x000fc40000000087ULL, 0x0000105484557816ULL, 0x000fe4000000008dULL,
0x00000008ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x000000662038723cULL, 0x040fe20000041838ULL, 0x00000010ff887819ULL, 0x000fe20000011688ULL,
0x0000007b1c1ca231ULL, 0x082fe200003400ffULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x0000007b1e1ea231ULL, 0x000fe200003400ffULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x0000007a1d1da231ULL, 0x080fe200003400ffULL, 0x00000010ff667819ULL, 0x000fe20000011681ULL,
0x00000054203c723cULL, 0x000fe2000004183cULL, 0x00000010ff677819ULL, 0x000fe20000011682ULL,
0x0000007a1f1fa231ULL, 0x000fe200003400ffULL, 0x00000010ff7e7819ULL, 0x000fc4000001167eULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000010ff557819ULL, 0x000fe4000001168fULL,
0x0000105489667816ULL, 0x000fe20000000066ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x0000105488677816ULL, 0x000fe40000000067ULL, 0x0000105483547816ULL, 0x000fe4000000008eULL,
0x000010547e557816ULL, 0x000fc40000000055ULL, 0x00000010ff767819ULL, 0x000fe20000011676ULL,
0x000000662040723cULL, 0x040fe20000041840ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff6f7819ULL, 0x000fe2000001166fULL, 0x000000542024723cULL, 0x000fe20000041824ULL,
0x00000070ff70723eULL, 0x000fc400020006ffULL, 0x00000010ff6a7819ULL, 0x000fe4000001164fULL,
0x0000ffff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe40000011678ULL, 0x00000010ff207819ULL, 0x000fe40000011679ULL,
0x00000010ff227819ULL, 0x000fe40000011672ULL, 0x0000105421207816ULL, 0x000fc40000000020ULL,
0x0000105476217816ULL, 0x000fe40000000077ULL, 0x00000010ff237819ULL, 0x000fe40000011674ULL,
0x00000010ff547819ULL, 0x000fe40000011675ULL, 0x0000105423227816ULL, 0x000fe20000000022ULL,
0x000000201c2c723cULL, 0x000fe2000004182cULL, 0x0000105454237816ULL, 0x000fe40000000073ULL,
0x00000010ff547819ULL, 0x000fc4000001166dULL, 0x000000ff71717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff217819ULL, 0x000fe2000001166cULL, 0x000000221c30723cULL, 0x000fe20000041830ULL,
0x00000010ff207819ULL, 0x000fe4000001166eULL, 0x000000ff6a6a7812ULL, 0x000fe400078ec0ffULL,
0x0000105421207816ULL, 0x000fe40000000020ULL, 0x0000105454217816ULL, 0x000fc4000000006fULL,
0x00000008ff6b7819ULL, 0x000fe4000001166bULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x000000201c34723cULL, 0x000fe20000041834ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000010ff217819ULL, 0x000fe2000001164aULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fe20000011668ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000105421207816ULL, 0x000fe20000000020ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000010544b217816ULL, 0x000fe20000000070ULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x000000201c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00000010ff227819ULL, 0x000fe40000011648ULL, 0x00000010ff237819ULL, 0x000fe40000011649ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff4e7819ULL, 0x000fc4000001164eULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff207819ULL, 0x000fe40000011653ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x000010547f667816ULL, 0x000fe4000000007cULL, 0x0000105480677816ULL, 0x000fe4000000007dULL,
0x0000105463227816ULL, 0x000fc40000000022ULL, 0x0000105464237816ULL, 0x000fe40000000023ULL,
0x00001054714c7816ULL, 0x000fe2000000004cULL, 0x000000661c28723cULL, 0x040fe20000041828ULL,
0x000010546a4d7816ULL, 0x000fe4000000004dULL, 0x000010544e4e7816ULL, 0x000fe4000000006bULL,
0x00001054204f7816ULL, 0x000fe4000000004fULL, 0x00000002ff217819ULL, 0x000fe20000011650ULL,
0x000000221c38723cULL, 0x040ff00000041838ULL, 0x0000004c1c40723cULL, 0x040ff00000041840ULL,
0x0000004e1c24723cULL, 0x000fee0000041824ULL, 0x0000f630211c7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff20000008000ULL, 0x000020000aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040211d7824ULL, 0x000fe200078e0256ULL,
0x000000ff62ff7812ULL, 0x000fe2000784c0ffULL, 0x000000001cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff0eff7812ULL, 0x000fc4000786c0ffULL, 0x000000c01d1d7810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff207807ULL, 0x000fe40001000000ULL, 0x000000461d00720cULL, 0x000fe40003f46070ULL,
0x000000010d707812ULL, 0x000fe400078ec0ffULL, 0x00000001ff6d7807ULL, 0x000fe40001800000ULL,
0x00000020696f7207ULL, 0x000fc40004800000ULL, 0x0000000170707812ULL, 0x000fca00078e3cffULL,
0x0000226000002947ULL, 0x000fea0003800000ULL, 0x000024000a0e7984ULL, 0x004ea20000000800ULL,
0x80000000651b7824ULL, 0x000fca00078e00ffULL, 0x800000000eff7812ULL, 0x004fe2000784481bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x000024000a0e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe4000784481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x80000000651c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e001b7305ULL, 0x0004e4000021f000ULL, 0x3fa000000e0e7823ULL, 0x004fe200000100ffULL,
0x0000001b0000735dULL, 0x008fe40003800000ULL, 0x000024000a1b7984ULL, 0x000ea40000000800ULL,
0x800000001bff7812ULL, 0x004fc4000784481cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000001ff1b7819ULL, 0x000fe40000011650ULL,
0x00000300520e7a10ULL, 0x000fe40007ffe0ffULL, 0x0000001019217812ULL, 0x000fe400078ec0ffULL,
0x000000010e1c7810ULL, 0x040fe20007ffe0ffULL, 0x000000080e1d7824ULL, 0x000fe200078e021bULL,
0x00000003ff227819ULL, 0x000fe40000011602ULL, 0x000000451c00720cULL, 0x000fe20003f46070ULL,
0x000000201d1d7824ULL, 0x000fe200078e00ffULL, 0x0000000422487810ULL, 0x000fc80007ffe0ffULL,
0x0000001d461e7217ULL, 0x000fe40007800000ULL, 0x00000060040e7812ULL, 0x000fc600078ef81dULL,
0x000000011e1e7824ULL, 0x000fe400078e0a1dULL, 0x00000005001c7224ULL, 0x020fe400078e020eULL,
0x00000080ff1d7424ULL, 0x000fe200078e00ffULL, 0x000000201e1e7807ULL, 0x000fe20001000000ULL,
0x000000010f0f7824ULL, 0x100fe400078e021cULL, 0x0000000110107824ULL, 0x000fe200078e021cULL,
0x0000001e211e7217ULL, 0x000fe20007800000ULL, 0x00005e000f0e7625ULL, 0x000fc800078e001dULL,
0x000000011e217824ULL, 0x000fe200078e0a21ULL, 0x000000150e1e7210ULL, 0x000fe20007f5e0ffULL,
0x00000001110e7824ULL, 0x000fe400078e021cULL, 0x00005e0010107625ULL, 0x000fe200078e001dULL,
0x000000212200720cULL, 0x000fc60003f66070ULL, 0x000000ffff1f7224ULL, 0x000fe200010e060fULL,
0x0000001510107210ULL, 0x000fe20007fbe0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e001dULL,
0x000000214800720cULL, 0x000fc60003f46070ULL, 0x00000001121c7824ULL, 0x000fe200078e021cULL,
0x0000000c22127810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x0000000822227810ULL, 0x000fe20007ffe0ffULL, 0x00005e001c1c7625ULL, 0x000fe200078e001dULL,
0x000000150e0e7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e5e7faeULL, 0x0005e2000d901c48ULL, 0x000000212200720cULL, 0x080fe40003fc6070ULL,
0x000000211200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff0f7224ULL, 0x000fe200020e060fULL,
0x000000151c1c7210ULL, 0x000fe20007f9e0ffULL, 0x00000000105d7faeULL, 0x0005e8000d101c48ULL,
0x000000ffff1d7224ULL, 0x000fc800020e061dULL, 0x000000000e5c7faeULL, 0x0005e8000f101c48ULL,
0x000000001c5b7faeULL, 0x0005e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004005f5f7984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f63c00130f7984ULL, 0x004ea20000000800ULL, 0x0000002069697207ULL, 0x000fe20004800000ULL,
0x8000000014107824ULL, 0x000fc600078e00ffULL, 0x0000ffff691c7812ULL, 0x000fca00078ec0ffULL,
0x800000001c0e7824ULL, 0x000fca00078e00ffULL, 0x800000005fff7812ULL, 0x008fe4000784480eULL,
0x800000000fff7812ULL, 0x004fe20007864810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x8000000014147824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e000f7305ULL, 0x0004e4000021f000ULL,
0x3fa000000e0e7823ULL, 0x004fe200000100ffULL, 0x0000000f0000735dULL, 0x008fe40003800000ULL,
0x00f63c00130f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fc40007864814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000018015167810ULL, 0x000fe20007ffe016ULL, 0x00000001ff127424ULL, 0x000fc800078e00ffULL,
0x0000000117167824ULL, 0x000fca00078e0216ULL, 0x00f00000160f7984ULL, 0x000ea80000000800ULL,
0x00f20000160e7984ULL, 0x0007220000000800ULL, 0x000000060f00720bULL, 0x004fda0003f7d000ULL,
0x0000000000107806ULL, 0x000fc800018e0100ULL, 0x0000ffff10147812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x000000060f00720bULL, 0x018fe40003f74000ULL,
0x0000000f06167209ULL, 0x000fe40007810000ULL, 0x0000000350117811ULL, 0x000fe400078ff0ffULL,
0x00000002ff1f7819ULL, 0x000fe20000011602ULL, 0x8000001606107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400018e0100ULL,
0x000000501100720cULL, 0x000fe40003f65270ULL, 0x0000ffff061d7812ULL, 0x000fe200078e3cffULL,
0x0000001000107308ULL, 0x000ea60000000800ULL, 0x0000001d14ff7212ULL, 0x000fce000788c0ffULL,
0x000000805012b824ULL, 0x000fc800078e0215ULL, 0x000000011717b824ULL, 0x000fe200078e0212ULL,
0x00000001ff127807ULL, 0x000fe20002000000ULL, 0x00001f1f10067589ULL, 0x004ea200000e0000ULL,
0x800000160f114221ULL, 0x000fe20000010000ULL, 0x0000001007077220ULL, 0x000fe40000410000ULL,
0x00001f51100f7589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b11114820ULL, 0x000fc60000410000ULL,
0x00f400161700b388ULL, 0x0009e20000000800ULL, 0x0000001100184308ULL, 0x000f620000000800ULL,
0x0000000628287220ULL, 0x084fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x080fe20000410000ULL,
0x0000000630307220ULL, 0x080fe20000410000ULL, 0x0000000631317220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x000000063c3c7220ULL, 0x080fe20000410000ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x0000000640407220ULL, 0x080fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x000fe20000410000ULL,
0x0000000f2a2a7220ULL, 0x088fe20000410000ULL, 0x0000000f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000f32327220ULL, 0x080fe20000410000ULL, 0x0000000f33337220ULL, 0x080fe20000410000ULL,
0x0000000f36367220ULL, 0x080fe20000410000ULL, 0x0000000f37377220ULL, 0x080fe20000410000ULL,
0x0000000f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000f42427220ULL, 0x080fe20000410000ULL, 0x0000000f43437220ULL, 0x080fe20000410000ULL,
0x0000000f26267220ULL, 0x080fe20000410000ULL, 0x0000000f27277220ULL, 0x000fe20000410000ULL,
0x000000ffff067224ULL, 0x000fe200078e0016ULL, 0x0000000e180e4220ULL, 0x020fc80000410000ULL,
0x000000070e077221ULL, 0x018fe20000010000ULL, 0x0000011000002947ULL, 0x000fea0003800000ULL,
0x000000080d0e7824ULL, 0x000fca00078e00ffULL, 0x000000080e0f7812ULL, 0x000fca00078e0cffULL,
0x00000001600e7824ULL, 0x000fe400078e020fULL, 0x800000001c0f7824ULL, 0x000fc800078e00ffULL,
0x00f64c000e0e7984ULL, 0x000ea40000000800ULL, 0x800000000eff7812ULL, 0x004fe4000784480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001c1c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e000f7305ULL, 0x0004e4000021f000ULL, 0x3fa000000e0e7823ULL, 0x004fe200000100ffULL,
0x0000000f0000735dULL, 0x008fe40003800000ULL, 0x00000400610f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fc4000784481cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000005a14783bULL, 0x000ea20000004200ULL,
0x00000002ff777819ULL, 0x000fc60000011602ULL, 0x00000000591c783bULL, 0x000ee80000004200ULL,
0x000000005848783bULL, 0x000f280000004200ULL, 0x000000005754783bULL, 0x000f620000004200ULL,
0x00000010ff537819ULL, 0x004fe40000011614ULL, 0x000000ff145d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011614ULL, 0x0000ffff14757812ULL, 0x000fe400078ec0ffULL,
0x00000010ff717819ULL, 0x108fe4000001161dULL, 0x000000ff1d7f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001161dULL, 0x0000ffff1d147812ULL, 0x000fc400078ec0ffULL,
0x00000018ff1d723eULL, 0x000fe400000010ffULL, 0x000000ff176c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff155e7812ULL, 0x000fe400078ec0ffULL, 0x000054101d787816ULL, 0x000fe4000000001dULL,
0x00000018ff657819ULL, 0x000fe4000001161fULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x0000005eff7a723eULL, 0x000fe400020006ffULL, 0x000000ff1c7d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff48627812ULL, 0x010fe200078ec0ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x0000005cff5e723eULL, 0x000fe400020006ffULL, 0x000000ff49607812ULL, 0x000fe200078ec0ffULL,
0x00001f51785c7589ULL, 0x0005e200000e0000ULL, 0x0000005dff79723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000018ff617819ULL, 0x000fe20000011648ULL,
0x00001f77785d7589ULL, 0x0007e200000e0000ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000018ff227819ULL, 0x000fc40000011649ULL,
0x00000010ff5b7819ULL, 0x000fe40000011648ULL, 0x00000065ff51723eULL, 0x004fe400020006ffULL,
0x0000ffff48107812ULL, 0x000fe200078ec0ffULL, 0x2000006cff787230ULL, 0x008fe20000004100ULL,
0x0000007dff6c723eULL, 0x000fe400020006ffULL, 0x00000060ff7d723eULL, 0x000fe200020006ffULL,
0x20000051ff607230ULL, 0x000fe20000004100ULL, 0x00000061ff51723eULL, 0x000fe200020006ffULL,
0x20000062ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x100fe2000001164aULL,
0x2000007dff627230ULL, 0x000fe20000004100ULL, 0x000000ff4a487812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000018ff237819ULL, 0x000fc4000001164aULL,
0x0000ffff4a0e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b4a7812ULL, 0x000fe400078ec0ffULL,
0x00000022ff7d723eULL, 0x000fe200020006ffULL, 0x20000051ff227230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe40000011616ULL, 0x00000010ff117819ULL, 0x000fe40000011649ULL,
0x0000ffff49597812ULL, 0x000fc400078ec0ffULL, 0x00000010ff7b7819ULL, 0x000fe40000011615ULL,
0x000000ff16677812ULL, 0x000fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe40000011616ULL,
0x00000010ff767819ULL, 0x100fe40000011617ULL, 0x00000018ff687819ULL, 0x000fe40000011617ULL,
0x00000010ff707819ULL, 0x000fc4000001161cULL, 0x00000018ff497819ULL, 0x000fe4000001164bULL,
0x0000ffff16167812ULL, 0x000fe400078ec0ffULL, 0x0000ffff17177812ULL, 0x000fe400078ec0ffULL,
0x0000004aff51723eULL, 0x000fe400020006ffULL, 0x00000010ff6e7819ULL, 0x000fe4000001161fULL,
0x000000ff1f817812ULL, 0x000fc400078ec0ffULL, 0x0000ffff1f6f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff554f7812ULL, 0x020fe400078ec0ffULL, 0x00000023ff4a723eULL, 0x000fe200020006ffULL,
0x2000007dff237230ULL, 0x000fe20000004100ULL, 0x00000010ff0f7819ULL, 0x000fe4000001164bULL,
0x0000ffff4b1f7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000008ff757819ULL, 0x000fc40000011675ULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x000000ff544b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff577c7812ULL, 0x000fe400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000068ff1d723eULL, 0x000fe400020006ffULL,
0x00000049ff7d723eULL, 0x000fe200020006ffULL, 0x20000051ff497230ULL, 0x000fe20000004100ULL,
0x000000ff7b7b7812ULL, 0x000fe200078ec0ffULL, 0x20000067ff777230ULL, 0x000fe20000004100ULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x000000ff71717812ULL, 0x000fc400078ec0ffULL, 0x0000007eff68723eULL, 0x000fe400020006ffULL,
0x00000008ff167819ULL, 0x000fe40000011616ULL, 0x00000008ff177819ULL, 0x000fe20000011617ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000018ff6d7819ULL, 0x000fe4000001161cULL,
0x00000018ff4d7819ULL, 0x000fe40000011655ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x0000004fff7e723eULL, 0x000fe400020006ffULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000081ff657230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011615ULL,
0x20000075ff817230ULL, 0x000fe20000004100ULL, 0x0000ffff15737812ULL, 0x000fc400078ec0ffULL,
0x0000004bff51723eULL, 0x000fe200020006ffULL, 0x2000007dff4b7230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x000000ff53537812ULL, 0x000fe400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000007bff827230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fc4000001161eULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x20000071ff757230ULL, 0x000fe20000004100ULL, 0x00000017ff17723eULL, 0x000fe400020006ffULL,
0x0000006dff67723eULL, 0x000fe200020006ffULL, 0x2000007fff6d7230ULL, 0x000fe20000004100ULL,
0x0000004dff7d723eULL, 0x000fe200020006ffULL, 0x2000007eff4d7230ULL, 0x000fe20000004100ULL,
0x00000053ff7f723eULL, 0x000fe200020006ffULL, 0x20000074ff7e7230ULL, 0x000fe20000004100ULL,
0x000000ff15717812ULL, 0x000fe200078ec0ffULL, 0x2000007cff537230ULL, 0x000fe20000004100ULL,
0x0000ffff1c727812ULL, 0x000fe200078ec0ffULL, 0x20000070ff747230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fe20000011614ULL, 0x20000016ff7c7230ULL, 0x000fe20000004100ULL,
0x0000ffff1e637812ULL, 0x000fe200078ec0ffULL, 0x20000017ff7b7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x00a800000814783bULL, 0x000ea20000000200ULL,
0x00009910121c7816ULL, 0x000fe200000000ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000018ff4c7819ULL, 0x000fc40000011654ULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x000000ff1e807812ULL, 0x000fe400078ec0ffULL,
0x000000ff76767812ULL, 0x000fe400078ec0ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x000000ff11117812ULL, 0x000fc400078ec0ffULL, 0x00000008ff107819ULL, 0x000fe40000011610ULL,
0x000000ff1c00720cULL, 0x000fe40003f45270ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000000ff564e7812ULL, 0x000fe400078ec0ffULL, 0x0000004cff4f723eULL, 0x000fe200020006ffULL,
0x20000051ff4c7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x00000064ff1c723eULL, 0x000fe400020006ffULL, 0x000000ff6e6e7812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000001cff1c7230ULL, 0x000fe20000004100ULL,
0x00000080ff64723eULL, 0x000fe200020006ffULL, 0x20000073ff807230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000072ff737230ULL, 0x000fe20000004100ULL,
0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL, 0x20000063ff727230ULL, 0x000fe20000004100ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x2000006fff637230ULL, 0x000fe20000004100ULL,
0x00000011ff11723eULL, 0x000fe200020006ffULL, 0x0000005d1414a231ULL, 0x084fe200003400ffULL,
0x00000010ff10723eULL, 0x000fe200020006ffULL, 0x0000005d1616a231ULL, 0x000fe200003400ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x20000011ff6f7230ULL, 0x000fe20000004100ULL,
0x000000ff5a087812ULL, 0x000fe200078ec0ffULL, 0x0000005c1515a231ULL, 0x080fe200003400ffULL,
0x0000004eff51723eULL, 0x000fe200020006ffULL, 0x2000004fff4e7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000007dff4f7230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000076ff7d7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000070ff767230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000071ff707230ULL, 0x000fe20000004100ULL,
0x00000059ff5a723eULL, 0x000fe200020006ffULL, 0x20000010ff597230ULL, 0x000fe20000004100ULL,
0x00000008ff08723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff107819ULL, 0x000fe20000011679ULL, 0x2000006eff717230ULL, 0x000fe20000004100ULL,
0x00000010ff117819ULL, 0x000fe2000001167aULL, 0x2000005bff6e7230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x20000008ff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x0000005c1717a231ULL, 0x000fe200003400ffULL,
0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000008ff0e7819ULL, 0x000fe2000001160eULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000010547f107816ULL, 0x000fe20000000010ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x0000105482117816ULL, 0x000fc40000000011ULL, 0x0000000fff7a723eULL, 0x000fe400020006ffULL,
0x0000000eff08723eULL, 0x000fe400020006ffULL, 0x00000010ff0f7819ULL, 0x000fe2000001165eULL,
0x000000101428723cULL, 0x000fe20000041828ULL, 0x00000010ff0e7819ULL, 0x000fe20000011681ULL,
0x20000008ff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe2000001165fULL,
0x2000007aff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fc40000011680ULL,
0x000010540f0e7816ULL, 0x000fe4000000000eULL, 0x00000018ff667819ULL, 0x000fe4000001161eULL,
0x00001054790f7816ULL, 0x000fe40000000080ULL, 0x00000010ff1e7819ULL, 0x000fe40000011654ULL,
0x00000010ff107819ULL, 0x000fe40000011677ULL, 0x00000010ff117819ULL, 0x000fe2000001167eULL,
0x0000000e142c723cULL, 0x000fe2000004182cULL, 0x00000010ff787819ULL, 0x000fc40000011678ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000008ff1f7819ULL, 0x000fe4000001161fULL,
0x000000ff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000105411107816ULL, 0x000fe40000000010ULL,
0x000010547d117816ULL, 0x000fe40000000078ULL, 0x00000010ff0f7819ULL, 0x000fc4000001161cULL,
0x00000010ff0e7819ULL, 0x000fe4000001167cULL, 0x0000001fff1f723eULL, 0x000fe200020006ffULL,
0x000000101430723cULL, 0x000fe20000041830ULL, 0x0000001eff1e723eULL, 0x000fe400020006ffULL,
0x00000010ff087819ULL, 0x000fe2000001161dULL, 0x2000001fff777230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fe2000001167bULL, 0x2000001eff787230ULL, 0x000fe20000004100ULL,
0x000010540f0e7816ULL, 0x000fe2000000000eULL, 0x00a80000091c783bULL, 0x0004e20000000200ULL,
0x00001054080f7816ULL, 0x000fc4000000007bULL, 0x00000010ff107819ULL, 0x000fe4000001166cULL,
0x00000010ff117819ULL, 0x000fe40000011674ULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x0000000e1434723cULL, 0x000fe20000041834ULL, 0x00000010ff087819ULL, 0x000fe40000011675ULL,
0x0000105411107816ULL, 0x000fe40000000010ULL, 0x0000105408117816ULL, 0x000fc4000000006dULL,
0x00000010ff097819ULL, 0x004fe40000011667ULL, 0x00000010ff087819ULL, 0x000fe40000011673ULL,
0x00000010ff0f7819ULL, 0x000fe20000011668ULL, 0x000000101438723cULL, 0x000fe20000041838ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x0000105409087816ULL, 0x000fc40000000008ULL, 0x000010540f097816ULL, 0x000fe20000000076ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff117819ULL, 0x000fe20000011666ULL,
0x00000008143c723cULL, 0x000fe2000004183cULL, 0x00000010ff0e7819ULL, 0x000fe40000011664ULL,
0x00000010ff0f7819ULL, 0x000fc40000011670ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x0000005d1c1ca231ULL, 0x088fe200003400ffULL, 0x00000010ff097819ULL, 0x000fe20000011663ULL,
0x0000005d1e1ea231ULL, 0x000fe200003400ffULL, 0x0000105411087816ULL, 0x000fe20000000072ULL,
0x0000005c1d1da231ULL, 0x080fe200003400ffULL, 0x0000105460097816ULL, 0x000fe20000000009ULL,
0x0000005c1f1fa231ULL, 0x000fe200003400ffULL, 0x00000010ff107819ULL, 0x000fe40000011671ULL,
0x000010540f0e7816ULL, 0x000fc4000000000eULL, 0x0000ffff546a7812ULL, 0x000fe200078ec0ffULL,
0x000000081424723cULL, 0x040fe20000041824ULL, 0x00000010ff6b7819ULL, 0x000fe40000011655ULL,
0x00001054100f7816ULL, 0x000fe40000000065ULL, 0x0000ffff55557812ULL, 0x000fe400078ec0ffULL,
0x00000010ff127819ULL, 0x100fe40000011656ULL, 0x00000018ff547819ULL, 0x000fe20000011656ULL,
0x0000000e1440723cULL, 0x000fe20000041840ULL, 0x00000010ff217819ULL, 0x000fc40000011657ULL,
0x00000018ff587819ULL, 0x000fe40000011657ULL, 0x0000ffff56567812ULL, 0x000fe400078ec0ffULL,
0x0000ffff57577812ULL, 0x000fe400078ec0ffULL, 0x00000010ff087819ULL, 0x000fe40000011623ULL,
0x00000010ff237819ULL, 0x000fe4000001165aULL, 0x00000008ff557819ULL, 0x000fc40000011655ULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6a7819ULL, 0x000fe4000001166aULL,
0x000000ff12127812ULL, 0x000fe400078ec0ffULL, 0x000000ff21217812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000008ff577819ULL, 0x000fc40000011657ULL,
0x0000105408237816ULL, 0x000fe40000000023ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff497819ULL, 0x000fc40000011649ULL,
0x00000010ff087819ULL, 0x000fe4000001165fULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe200020006ffULL,
0x2000006bff687230ULL, 0x000fe20000004100ULL, 0x00000010ff097819ULL, 0x000fe2000001164aULL,
0x2000006aff677230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x20000012ff127230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fc400020006ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000021ff217230ULL, 0x000fe20000004100ULL, 0x000010546e0e7816ULL, 0x000fe20000000061ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x000010546f0f7816ULL, 0x000fe20000000062ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000105408497816ULL, 0x000fe40000000049ULL,
0x00000010ff087819ULL, 0x000fc4000001164bULL, 0x00000010ff5f7819ULL, 0x000fe20000011677ULL,
0x0000000e1c28723cULL, 0x000fe20000041828ULL, 0x00001054095e7816ULL, 0x000fe4000000005eULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff097819ULL, 0x000fe40000011678ULL,
0x00001054085f7816ULL, 0x000fe4000000005fULL, 0x00000010ff087819ULL, 0x000fc4000001164fULL,
0x00001054094c7816ULL, 0x000fe4000000004cULL, 0x00000010ff4f7819ULL, 0x000fe20000011655ULL,
0x0000005e1c34723cULL, 0x000fe20000041834ULL, 0x00000010ff227819ULL, 0x000fe40000011622ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff487819ULL, 0x000fe40000011648ULL,
0x00000010ff5b7819ULL, 0x000fc4000001165bULL, 0x00000010ff4d7819ULL, 0x000fe4000001164dULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff127819ULL, 0x000fc40000011612ULL, 0x00000010ff097819ULL, 0x000fe40000011653ULL,
0x00000010ff0e7819ULL, 0x000fe40000011621ULL, 0x00000010ff0f7819ULL, 0x000fe40000011654ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff577819ULL, 0x000fc40000011657ULL, 0x00001054084f7816ULL, 0x000fe4000000004fULL,
0x0000105422227816ULL, 0x000fe40000000059ULL, 0x000010545b487816ULL, 0x000fe40000000048ULL,
0x00001054684d7816ULL, 0x000fe4000000004dULL, 0x000010544e4e7816ULL, 0x000fe20000000067ULL,
0x000000221c2c723cULL, 0x000fe2000004182cULL, 0x0000105412087816ULL, 0x000fc40000000051ULL,
0x000010540e097816ULL, 0x000fe40000000009ULL, 0x000010540f567816ULL, 0x000fe40000000056ULL,
0x0000105458577816ULL, 0x000fe20000000057ULL, 0x000000481c30723cULL, 0x040ff00000041830ULL,
0x0000004c1c38723cULL, 0x040ff00000041838ULL, 0x0000004e1c3c723cULL, 0x040ff0000004183cULL,
0x000000081c40723cULL, 0x040ff00000041840ULL, 0x000000561c24723cULL, 0x000fe20000041824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020000aff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6400013ff7f8cULL, 0x0007e2000c80043fULL, 0x0000991069087816ULL, 0x000fc400000000ffULL,
0x00000001ff6d7807ULL, 0x000fe40004000000ULL, 0x000000ff0800720cULL, 0x000fe40003f45270ULL,
0x000000010d707812ULL, 0x000fe400078ec0ffULL, 0x00000001ff209807ULL, 0x000fc80001000000ULL,
0x00007610206f7816ULL, 0x000fe4000000006fULL, 0x0000030052527a10ULL, 0x00cfe40007ffe0ffULL,
0x000000ff0cff7812ULL, 0x000fe4000780c0ffULL, 0x000000455200720cULL, 0x000fe40003f26070ULL,
0x00000001ff0c7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff699000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea40000002500ULL,
0x0000000445007c0cULL, 0x004fda000bf03070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x020fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0000a580000a7802ULL, 0x002fe40000000f00ULL, 0x000095b000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000ea40000001000ULL,
0xbf80000000027423ULL, 0x004fc80000000007ULL, 0x800000ff02057221ULL, 0x000fc80000010100ULL,
0x0000000500007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff057624ULL, 0x000fe400078e00ffULL, 0x00006800ff047624ULL, 0x000fca00078e00ffULL,
0x0000000804057981ULL, 0x000ea8000c1e9900ULL, 0x0000000000027919ULL, 0x000f280000000000ULL,
0x00000000000a7919ULL, 0x002e620000000000ULL, 0x00000002ff087819ULL, 0x010fe40000011602ULL,
0x000000080a027811ULL, 0x002fe200078ff0ffULL, 0x0000000005097220ULL, 0x00cfca0000410000ULL,
0x00001f0809007589ULL, 0x000e6800000e0000ULL, 0x00001f0209027589ULL, 0x000ea200000e0000ULL,
0x0000002800287220ULL, 0x042fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x000fe20000410000ULL,
0x0000002a022a7220ULL, 0x044fe20000410000ULL, 0x0000002b022b7220ULL, 0x040fe20000410000ULL,
0x0000002e022e7220ULL, 0x040fe20000410000ULL, 0x0000002f022f7220ULL, 0x040fe20000410000ULL,
0x0000003202327220ULL, 0x040fe20000410000ULL, 0x0000003302337220ULL, 0x040fe20000410000ULL,
0x0000003602367220ULL, 0x040fe20000410000ULL, 0x0000003702377220ULL, 0x040fe20000410000ULL,
0x0000003a023a7220ULL, 0x040fe20000410000ULL, 0x0000003b023b7220ULL, 0x040fe20000410000ULL,
0x0000003e023e7220ULL, 0x040fe20000410000ULL, 0x0000003f023f7220ULL, 0x040fe20000410000ULL,
0x0000004202427220ULL, 0x040fe20000410000ULL, 0x0000004302437220ULL, 0x040fe20000410000ULL,
0x0000002602267220ULL, 0x040fe20000410000ULL, 0x0000002702277220ULL, 0x000fc80000410000ULL,
0x0000000000007919ULL, 0x020ea20000000000ULL, 0x000000262726723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x004fe400078ec0ffULL,
0x00000002ff117819ULL, 0x002fe40000011600ULL, 0x00000001ff047819ULL, 0x000fe40000011602ULL,
0x00000004020a7811ULL, 0x000fe400078ff8ffULL, 0x0000000800197811ULL, 0x000fe400078ff0ffULL,
0x0000000202057811ULL, 0x000fc400078ff8ffULL, 0x00000006020d7811ULL, 0x000fe400078ff8ffULL,
0x0000000704027812ULL, 0x100fe400078e7811ULL, 0x000000070a0c7812ULL, 0x040fe400078e7811ULL,
0x000000070a0a7812ULL, 0x000fe200078e7819ULL, 0x0000000811097824ULL, 0x000fe200078e0202ULL,
0x0000000705087812ULL, 0x000fe200078e7811ULL, 0x0000100044027824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x000fe200078e7819ULL, 0x0000000819177824ULL, 0x000fe200078e020aULL,
0x000000070d0e7812ULL, 0x000fe200078e7811ULL, 0x00000008000a7824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x100fe200078e7819ULL, 0x0000000819137824ULL, 0x000fe200078e0204ULL,
0x000000070d0d7812ULL, 0x000fe200078e7819ULL, 0x00000008110b7824ULL, 0x040fe200078e0208ULL,
0x000000080a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000008110f7824ULL, 0x000fe200078e020cULL,
0x0000002c2d08723eULL, 0x000fe200000010ffULL, 0x0000000819157824ULL, 0x000fe200078e0205ULL,
0x000000282905723eULL, 0x000fe200000010ffULL, 0x000008001b047824ULL, 0x000fc400078e0202ULL,
0x0000000811117824ULL, 0x000fe200078e020eULL, 0x00005410051c7816ULL, 0x100fe20000000008ULL,
0x0000000819197824ULL, 0x000fe200078e020dULL, 0x00007632051d7816ULL, 0x000fe20000000008ULL,
0x0000001009097824ULL, 0x100fe200078e0204ULL, 0x000000383905723eULL, 0x000fe200000010ffULL,
0x000000100b0d7824ULL, 0x100fe200078e0204ULL, 0x0000003c3d08723eULL, 0x000fe200000010ffULL,
0x000000100f0f7824ULL, 0x100fe400078e0204ULL, 0x0000001013137824ULL, 0x000fe200078e0204ULL,
0x00005410050c7816ULL, 0x000fe20000000008ULL, 0x0000001015157824ULL, 0x000fc400078e0204ULL,
0x0000001011117824ULL, 0x100fe400078e0204ULL, 0x0000001017177824ULL, 0x100fe400078e0204ULL,
0x0000001019197824ULL, 0x000fe400078e0204ULL, 0x00000001090b7824ULL, 0x000fe200078e020aULL,
0x000000303109723eULL, 0x000fe200000010ffULL, 0x000000010a0d7824ULL, 0x040fe400078e020dULL,
0x000000010a0f7824ULL, 0x040fe200078e020fULL, 0x0000001c0b007388ULL, 0x0003e20000000a00ULL,
0x000000010a137824ULL, 0x000fc400078e0213ULL, 0x000000010a157824ULL, 0x040fe400078e0215ULL,
0x000000010a117824ULL, 0x040fe400078e0211ULL, 0x000000010a177824ULL, 0x040fe400078e0217ULL,
0x000000010a197824ULL, 0x000fe200078e0219ULL, 0x00000034350a723eULL, 0x000fe200000010ffULL,
0x000000201b0b7824ULL, 0x002fc600078e0200ULL, 0x00005410091c7816ULL, 0x140fe4000000000aULL,
0x00007632091d7816ULL, 0x000fe2000000000aULL, 0x000000100b127824ULL, 0x000fe200078e0202ULL,
0x000000404109723eULL, 0x000fe400000010ffULL, 0x00000024250a723eULL, 0x000fe200000010ffULL,
0x0000001c0d007388ULL, 0x0003e20000000a00ULL, 0x00000300ff247624ULL, 0x000fe200078e00ffULL,
0x00007632050d7816ULL, 0x002fe40000000008ULL, 0x0000002a2b05723eULL, 0x000fc400000010ffULL,
0x0000002e2f08723eULL, 0x000fe200000010ffULL, 0x0000000c0f007388ULL, 0x0003e40000000a00ULL,
0x00005410090c7816ULL, 0x142fe4000000000aULL, 0x00007632090d7816ULL, 0x000fe4000000000aULL,
0x000000323309723eULL, 0x000fe400000010ffULL, 0x00000036370a723eULL, 0x000fe200000010ffULL,
0x0000000c11007388ULL, 0x0003e40000000a00ULL, 0x00005410050c7816ULL, 0x002fc40000000008ULL,
0x00007632050d7816ULL, 0x000fe40000000008ULL, 0x0000003a3b05723eULL, 0x000fe400000010ffULL,
0x0000003e3f08723eULL, 0x000fe200000010ffULL, 0x0000000c13007388ULL, 0x0003e60000000a00ULL,
0x0000541005107816ULL, 0x140fe40000000008ULL, 0x0000763205117816ULL, 0x000fc40000000008ULL,
0x000000ff00057306ULL, 0x000fe20000205400ULL, 0x00005410090c7816ULL, 0x142fe4000000000aULL,
0x00007632090d7816ULL, 0x000fca000000000aULL, 0x000000ff00087306ULL, 0x000e620000209400ULL,
0x000000424309723eULL, 0x000fe200000010ffULL, 0x0000000c15007388ULL, 0x000fe80000000a00ULL,
0x0000001017007388ULL, 0x0005e20000000a00ULL, 0x000000050800720bULL, 0x002fe40003f1d000ULL,
0x000000ff00057245ULL, 0x000fe4000020d400ULL, 0x0000541009107816ULL, 0x004fc40000000026ULL,
0x0000763209117816ULL, 0x000fca0000000026ULL, 0x0000001019007388ULL, 0x000fe40000000a00ULL,
0x0000000105050812ULL, 0x000fe400078efcffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000012400780cULL, 0x000fe40003f05270ULL, 0x000000050508723eULL, 0x000fc600000010ffULL,
0x00000000120c7984ULL, 0x000e680000000c00ULL, 0x0004000012207984ULL, 0x000ea80000000c00ULL,
0x00080000121c7984ULL, 0x000ee80000000c00ULL, 0x000c000012147984ULL, 0x000f220000000c00ULL,
0x3f803f80080f7831ULL, 0x002fc4000020000fULL, 0x3f803f80080e7831ULL, 0x040fe4000020000eULL,
0x3f803f80080d7831ULL, 0x040fe4000020000dULL, 0x3f803f80080c7831ULL, 0x040fe4000020000cULL,
0x3f803f8008237831ULL, 0x044fe40000200023ULL, 0x3f803f8008227831ULL, 0x040fe40000200022ULL,
0x3f803f8008217831ULL, 0x000fc40000200021ULL, 0x3f803f8008207831ULL, 0x000fe40000200020ULL,
0x3f803f800f0f7831ULL, 0x008fe4000020001fULL, 0x3f803f800e0e7831ULL, 0x000fe4000020001eULL,
0x3f803f800d0d7831ULL, 0x000fe4000020001dULL, 0x3f803f800c0c7831ULL, 0x000fe4000020001cULL,
0x3f803f8023237831ULL, 0x010fc40000200017ULL, 0x3f803f8022227831ULL, 0x000fe20000200016ULL,
0x0000000c12007388ULL, 0x0003e20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe40000200015ULL,
0x3f803f8020207831ULL, 0x000fca0000200014ULL, 0x0004002012007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000306000008947ULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x000ea20000002700ULL, 0x0000580024087a24ULL, 0x000fe200078e02ffULL,
0x000000011bff7812ULL, 0x000fe2000780f850ULL, 0x00001000ff117424ULL, 0x000fe200078e00ffULL,
0x0000000000097919ULL, 0x000ea20000002600ULL, 0x0000660008137a24ULL, 0x000fe200078e02ffULL,
0x000000400b177810ULL, 0x000fe20007ffe0ffULL, 0x00000800440a7824ULL, 0x000fe200078e00ffULL,
0x00000000120c7984ULL, 0x0022e80000000c00ULL, 0x00040000121c7984ULL, 0x0003220000000c00ULL,
0x0000580018187a24ULL, 0x004fe200078e0209ULL, 0x00000fff13097811ULL, 0x000fc600078e40ffULL,
0x0000030018087a24ULL, 0x000fca00078e02ffULL, 0x00000004081a7c10ULL, 0x000fc8000fffe0ffULL,
0x0000001a09107211ULL, 0x000fca00078fa0ffULL, 0x00006c0010107625ULL, 0x000fca00078e0011ULL,
0x0000000a10107210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x000000ff0000720cULL, 0x000fc60000725670ULL, 0x000000100b147825ULL, 0x000fe200078e0010ULL,
0x01ffffff130b7812ULL, 0x000fc600078ec0ffULL, 0x0000001017167825ULL, 0x000fe200078e0010ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x0000001000107824ULL, 0x01afe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000080ff137424ULL, 0x000fe400078e00ffULL,
0x000000011a127824ULL, 0x000fe200078e020bULL, 0x0000007010197812ULL, 0x000fe400078ec0ffULL,
0x0000000c11207812ULL, 0x000fe200078ec0ffULL, 0x00006c001a107625ULL, 0x000fc800078e0013ULL,
0x00006c0012127625ULL, 0x000fe200078e0013ULL, 0x0000001020107210ULL, 0x000fc80007a1e019ULL,
0x0000001220127210ULL, 0x000fe40007c7e019ULL, 0x00000011ff117210ULL, 0x000fe400007e44ffULL,
0x00000013ff137210ULL, 0x000fc60001fe84ffULL, 0x0000000610007986ULL, 0x0003e8000c101908ULL,
0x0000000712007986ULL, 0x0003e4000c101908ULL, 0x0000000c14007986ULL, 0x01a3e2000c101d08ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000001c16007986ULL, 0x0003e8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0xffffffff240d7810ULL, 0x002fc60007ffe0ffULL,
0x00006a0018067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d060679a8ULL, 0x000ea400099ee1c8ULL,
0x0000000d0600720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000000000ULL, 0x0000000cff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x000ea40000000000ULL, 0x000000ff0600720cULL, 0x004fda0003f05270ULL,
0x00002c9000008947ULL, 0x000fea0003800000ULL, 0x000000ff5000720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011600ULL, 0x00000080ff0f7424ULL, 0x002fe200078e00ffULL,
0x00000001080c7810ULL, 0x000fe40007ffe0ffULL, 0x0000007006197812ULL, 0x000fe400078ec0ffULL,
0x0000000c07107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008067625ULL, 0x000fc800078e000fULL,
0x00006c000c0c7625ULL, 0x000fe200078e000fULL, 0x0000000610067210ULL, 0x000fc8000791e019ULL,
0x0000000c100c7210ULL, 0x000fe40007b5e019ULL, 0x00000007ff077210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x0000000806067981ULL, 0x000368000c1e1900ULL,
0x000000080c117981ULL, 0x000362000c1e1900ULL, 0x000000022400780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002080c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e019ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c077981ULL, 0x000362000c1e1900ULL,
0x000000042400780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003080c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c137981ULL, 0x000362000c1e1900ULL, 0x000000042400780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004080c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e000fULL, 0x0000000c100c7210ULL, 0x000fc8000791e019ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c157981ULL, 0x000362000c1e1900ULL,
0x000000062400780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005080c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fc8000791e019ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c177981ULL, 0x000362000c1e1900ULL, 0x000000062400780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082400780cULL, 0x002fe40003f06070ULL,
0x00000006080c7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e000fULL,
0x0000000c100c7210ULL, 0x000fe40007a3e019ULL, 0x00000007080e0810ULL, 0x000fe40007ffe0ffULL,
0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL, 0x00006c000e0e0625ULL, 0x000fca00078e000fULL,
0x0000000e100e0210ULL, 0x000fe40007c7e019ULL, 0x000000080c197981ULL, 0x000364000c1e1900ULL,
0x0000000fff0f0210ULL, 0x000fcc0001fe84ffULL, 0x000000080e0f0981ULL, 0x000366000c1e1900ULL,
0x00000007240c7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0e7819ULL, 0x000fc8000001160cULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x020fe400078e0006ULL,
0x000000081d107824ULL, 0x040fe200078e00ffULL, 0x000000011d1d7810ULL, 0x000fc80007ffe0ffULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x0000000e1d00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008100d7810ULL, 0x040fe40007ffe0ffULL,
0x00000001100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x00000070121f7812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e01fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c1f7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000002100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff127819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e011ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c117981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000003100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000000706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e007ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c077981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000004100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001306067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012137812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e013ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c137981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000005100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001506067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012157812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e015ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c157981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d100d7810ULL, 0x042fe40007ffe0ffULL, 0x00000006100c7810ULL, 0x000fe40007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000003000c007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x0000007012177812ULL, 0x000fc800078ec0ffULL, 0x0000000c140c7210ULL, 0x000fc80007b3e017ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000080c177981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e100d7810ULL, 0x042fe40007ffe0ffULL,
0x00000007100c7810ULL, 0x000fe40007ffe0ffULL, 0x000003000d007a0cULL, 0x000fe40003f26070ULL,
0x000003000c007a0cULL, 0x000fe40003f46070ULL, 0x0000001906067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001080c7824ULL, 0x000fe200078e020dULL,
0x00000001ff147819ULL, 0x000fe20000011600ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fc600078e000dULL, 0x0000007012197812ULL, 0x000fc800078ec0ffULL,
0x0000000c140c7210ULL, 0x000fc80007b3e019ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000080c197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f100d7810ULL, 0x002fe40007ffe0ffULL, 0x0000000f06067209ULL, 0x000fe40007810000ULL,
0x000003000d007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001080c7824ULL, 0x000fe200078e020dULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x00000080ff0d7424ULL, 0x000fe400078e00ffULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fc600078e000dULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007a3e00fULL,
0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL, 0x000000080c0f7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000077824ULL, 0x024fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x002fc80000011600ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fca00078ec0ffULL,
0x000000010c077824ULL, 0x000fca00078e0207ULL, 0x0000000607007388ULL, 0x0003e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000001000077824ULL, 0x002fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011600ULL, 0x000000011b187824ULL, 0x000fe200078e0208ULL,
0x00000002ff0d7819ULL, 0x000fe20000011650ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000070070e7812ULL, 0x000fe200078ec0ffULL, 0x00001000ff117424ULL, 0x000fe200078e00ffULL,
0x0000000c0c0f7812ULL, 0x000fe200078ec0ffULL, 0x0000020050507824ULL, 0x000fe200078e00ffULL,
0x0000001809067211ULL, 0x000fe200078fa0ffULL, 0x0000000103037824ULL, 0x000fe200078e0202ULL,
0x000000010d0c7812ULL, 0x000fe200078ec0ffULL, 0x000000010f1a7824ULL, 0x000fe200078e020eULL,
0x0000004000137810ULL, 0x040fe20007ffe0ffULL, 0x000000021b0d8824ULL, 0x140fe200078e0244ULL,
0x0000006000157810ULL, 0x000fe20007ffe0ffULL, 0x000000021b0f8824ULL, 0x000fe200078e0244ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00006c0006067625ULL, 0x000fe200078e0011ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000020d178824ULL, 0x100fe200078e020cULL,
0x0000000a06067210ULL, 0x000fe20007f3e0ffULL, 0x000000020f1d8824ULL, 0x000fe200078e020cULL,
0x00000800500c7812ULL, 0x000fe200078ec0ffULL, 0x000000010b108824ULL, 0x000fe200078e0218ULL,
0x00000020000f7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff118424ULL, 0x000fc400078e00ffULL,
0x00000001030d7824ULL, 0x000fe400078e020cULL, 0x00000080ff198424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x000003001b007a0cULL, 0x000fe20003f26070ULL,
0x00006c0010108625ULL, 0x000fc800078e0011ULL, 0x00000010001f7824ULL, 0x000fe400078e020dULL,
0x00006c0018188625ULL, 0x000fc800078e0019ULL, 0x0000000817238824ULL, 0x000fe400078e0200ULL,
0x00000010000c7825ULL, 0x000fc600078e0006ULL, 0x0000458023238811ULL, 0x000fe200078e20ffULL,
0x000000081d258824ULL, 0x000fe400078e0200ULL, 0x000000100f0e7825ULL, 0x000fc600078e0006ULL,
0x0000418025258811ULL, 0x000fe200078e20ffULL, 0x0000001013127825ULL, 0x000fc800078e0006ULL,
0x0000001015147825ULL, 0x000fe400078e0006ULL, 0x000000001a067984ULL, 0x0002a40000000800ULL,
0x0000001000168825ULL, 0x040fe400078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c1f7faeULL, 0x0007e2000b901c48ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000010001c8825ULL, 0x000fe400078e0018ULL, 0x003800000e1f7faeULL, 0x0009e2000b901c48ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fc400078e00ffULL,
0x00580000121f7faeULL, 0x000be2000b901c48ULL, 0x000000ffff1a7224ULL, 0x002fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0x00780000141f7faeULL, 0x0003e2000b901c48ULL,
0x00000000000c7805ULL, 0x008fc6000001ff00ULL, 0x0000000016238faeULL, 0x0007e2000b901c48ULL,
0x00000000000e7805ULL, 0x010fc6000001ff00ULL, 0x000000001c258faeULL, 0x0009e2000b901c48ULL,
0x0000000000127805ULL, 0x020fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x008fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000e0000001947ULL, 0x000fea0003800000ULL, 0x00000df000007945ULL, 0x000fe20003800000ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff307224ULL, 0x000fca00078e001bULL,
0x00000002302f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff457224ULL, 0x000fe200078e0030ULL,
0x00000002ff2e7819ULL, 0x000fe20000011600ULL, 0x000000021b437824ULL, 0x000fe200078e0244ULL,
0x000003002f007a0cULL, 0x000fe20003f06070ULL, 0x0000004045307824ULL, 0x000fe200078e00ffULL,
0x000000072e4a7812ULL, 0x040fe200078ec0ffULL, 0x000000082e317824ULL, 0x040fe200078e00ffULL,
0x0000002eff4c7212ULL, 0x000fe200078e33ffULL, 0x000000082e2d7824ULL, 0x000fe200078e00ffULL,
0x0000008030307812ULL, 0x000fe200078ec0ffULL, 0x000000082e337824ULL, 0x000fe200078e00ffULL,
0x0000039000017945ULL, 0x000fe20003800000ULL, 0xfffffff8313c7812ULL, 0x102fe200078ee24aULL,
0x0000001000497824ULL, 0x000fe200078e00ffULL, 0x000000012d3e7812ULL, 0x000fe200078ef64aULL,
0x0000010043437824ULL, 0x000fe200078e0030ULL, 0x000000022d407812ULL, 0x000fc400078ef64aULL,
0x000000032d427812ULL, 0x140fe400078ef64aULL, 0x000000042d467812ULL, 0x140fe400078ef64aULL,
0x000000052d487812ULL, 0x140fe400078ef64aULL, 0x000000062d4a7812ULL, 0x000fe400078ef64aULL,
0xfffffff8334c7812ULL, 0x000fe400078ee24cULL, 0x000000082e2d7810ULL, 0x000fe20007ffe0ffULL,
0x000002c000000947ULL, 0x008fea0003800000ULL, 0x00000001083a7824ULL, 0x100fe200078e022fULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00001000ff317424ULL, 0x000fe200078e00ffULL,
0x00000001ff327819ULL, 0x000fc4000001162fULL, 0x0000003a09307211ULL, 0x000fe400078fa0ffULL,
0x0000000132337812ULL, 0x000fe200078ec0ffULL, 0x000004002f327824ULL, 0x000fe200078e00ffULL,
0x0000002000357810ULL, 0x000fe20007ffe0ffULL, 0x00006c0030307625ULL, 0x000fe200078e0031ULL,
0x0000004000377810ULL, 0x000fe40007ffe0ffULL, 0x0000080032327812ULL, 0x000fe200078ec0ffULL,
0x000000021b349824ULL, 0x140fe200078e0244ULL, 0x0000000a30307210ULL, 0x000fe20007f1e0ffULL,
0x000000021b369824ULL, 0x000fe200078e0244ULL, 0x0000006000417810ULL, 0x000fe20007ffe0ffULL,
0x00000002343f9824ULL, 0x000fc400078e0233ULL, 0x0000000236479824ULL, 0x000fe400078e0233ULL,
0x0000000103337824ULL, 0x000fe400078e0232ULL, 0x000000ffff317224ULL, 0x000fe400000e0631ULL,
0x000000010b389824ULL, 0x000fe400078e023aULL, 0x00000080ff399424ULL, 0x000fe400078e00ffULL,
0x00000080ff3b9424ULL, 0x000fc400078e00ffULL, 0x00000010003d7824ULL, 0x000fe400078e0233ULL,
0x00006c0038389625ULL, 0x000fc800078e0039ULL, 0x0000001000327825ULL, 0x000fc800078e0030ULL,
0x0000001035347825ULL, 0x100fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000323d7faeULL, 0x0003e6000b901c48ULL, 0x0000001037367825ULL, 0x100fe200078e0030ULL,
0x00380000343d7faeULL, 0x0003e6000b901c48ULL, 0x00006c003a3a9625ULL, 0x000fe200078e003bULL,
0x00580000363d7faeULL, 0x0003e6000b901c48ULL, 0x0000001041307825ULL, 0x000fc800078e0030ULL,
0x000000083f3f9824ULL, 0x100fe200078e0200ULL, 0x00780000303d7faeULL, 0x0003e2000b901c48ULL,
0x0000000847419824ULL, 0x000fe400078e0200ULL, 0x0000001000389825ULL, 0x040fe200078e0038ULL,
0x000045803f3f9811ULL, 0x000fe400078e20ffULL, 0x0000418041419811ULL, 0x000fe200078e20ffULL,
0x00000010003a9825ULL, 0x000fe400078e003aULL, 0x00000000383f9faeULL, 0x0003e8000b901c48ULL,
0x000000003a419faeULL, 0x0003e4000b901c48ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff337819ULL, 0x002fe20000011600ULL,
0x0000040045307824ULL, 0x000fe200078e00ffULL, 0x0000007049547812ULL, 0x000fe200078ec0ffULL,
0x000000082d327824ULL, 0x000fe200078e00ffULL, 0x0000000c33337812ULL, 0x000fe200078ec0ffULL,
0x000000082d347824ULL, 0x040fe200078e00ffULL, 0x000000072d317812ULL, 0x000fc400078ec0ffULL,
0x0000004333437210ULL, 0x000fe20007ffe054ULL, 0x000000082d547824ULL, 0x000fe200078e00ffULL,
0x0000080030307812ULL, 0x000fe400078ec0ffULL, 0x0000000132367812ULL, 0x140fe400078ef631ULL,
0x0000000232387812ULL, 0x140fe400078ef631ULL, 0x00000003323a7812ULL, 0x140fe400078ef631ULL,
0x00000004324e7812ULL, 0x000fc400078ef631ULL, 0x0000000532507812ULL, 0x140fe400078ef631ULL,
0x0000000632527812ULL, 0x000fe200078ef631ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800043357984ULL, 0x000e620000000800ULL, 0xfffffff834347812ULL, 0x000fe200078ee231ULL,
0x0000000400327824ULL, 0x000fe200078e00ffULL, 0x0000002dff337212ULL, 0x000fe400078e33ffULL,
0x0000018003317810ULL, 0x000fe40007ffe030ULL, 0xfffffff854307812ULL, 0x000fe400078ee233ULL,
0x0000000c32337812ULL, 0x000fe200078ec0ffULL, 0x000000103e3e7824ULL, 0x100fe200078e0231ULL,
0x0045800043327984ULL, 0x000ee20000000800ULL, 0x0000001040407824ULL, 0x000fc400078e0231ULL,
0x0000001046467824ULL, 0x100fe400078e0231ULL, 0x000000104a4a7824ULL, 0x100fe400078e0231ULL,
0x000000104e4e7824ULL, 0x100fe400078e0231ULL, 0x000000103c3c7824ULL, 0x100fe400078e0231ULL,
0x0000001042427824ULL, 0x100fe400078e0231ULL, 0x0000001048487824ULL, 0x000fc400078e0231ULL,
0x0000001034347824ULL, 0x100fe400078e0231ULL, 0x0000001036367824ULL, 0x100fe400078e0231ULL,
0x0000001038387824ULL, 0x100fe400078e0231ULL, 0x000000103a3a7824ULL, 0x100fe400078e0231ULL,
0x0000001050507824ULL, 0x100fe400078e0231ULL, 0x0000001052527824ULL, 0x000fc400078e0231ULL,
0x000000104c4c7824ULL, 0x100fe400078e0231ULL, 0x0000001030307824ULL, 0x000fe200078e0231ULL,
0x0000003506357221ULL, 0x006fe20000010100ULL, 0x00000001333e7824ULL, 0x040fe400078e023eULL,
0x0000000133407824ULL, 0x000fe200078e0240ULL, 0x3fb8aa3b35357820ULL, 0x000fe20000410000ULL,
0x0000000133467824ULL, 0x040fe400078e0246ULL, 0x00000001334a7824ULL, 0x040fe200078e024aULL,
0x000000003e3e7984ULL, 0x000e620000000800ULL, 0x00000001334e7824ULL, 0x040fe200078e024eULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0x000000013c3c7824ULL, 0x000fe200078e0233ULL,
0x0000000040407984ULL, 0x000ea20000000800ULL, 0x0000000133427824ULL, 0x000fc400078e0242ULL,
0x0000000133487824ULL, 0x040fe200078e0248ULL, 0x0000000046467984ULL, 0x000f220000000800ULL,
0x00000001334c7824ULL, 0x040fe400078e024cULL, 0x0000000133347824ULL, 0x040fe200078e0234ULL,
0x000000004a4a7984ULL, 0x000f620000000800ULL, 0x0000000133367824ULL, 0x040fe400078e0236ULL,
0x0000000133387824ULL, 0x040fe200078e0238ULL, 0x000000004e4e7984ULL, 0x000f620000000800ULL,
0x00000001333a7824ULL, 0x000fe200078e023aULL, 0x0000003235577220ULL, 0x008fe20000410000ULL,
0x0000000133507824ULL, 0x040fe200078e0250ULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x0000000133527824ULL, 0x000fe200078e0252ULL, 0x0000002c572c7221ULL, 0x000fe20000010000ULL,
0x0000000133337824ULL, 0x000fe200078e0230ULL, 0x0000000048487984ULL, 0x000ee20000000800ULL,
0x000000ffff307224ULL, 0x000fc600078e002fULL, 0x000000004c4c7984ULL, 0x000ee40000000800ULL,
0x0000030030007a0cULL, 0x000fe40003f06070ULL, 0x0000000034347984ULL, 0x000ee80000000800ULL,
0x0000000050507984ULL, 0x000ee80000000800ULL, 0x0000000052527984ULL, 0x000ee20000000800ULL,
0x00005410ff547816ULL, 0x002fc4000000003eULL, 0x00007610ff317816ULL, 0x000fe2000000003eULL,
0x000000003c3c7984ULL, 0x000e620000000800ULL, 0x00005410ff3e7816ULL, 0x104fe40000000040ULL,
0x00007610ff357816ULL, 0x000fe20000000040ULL, 0x0000000036367984ULL, 0x000ea20000000800ULL,
0x00005410ff3f7816ULL, 0x110fe40000000046ULL, 0x00007610ff417816ULL, 0x000fe20000000046ULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x00005410ff437816ULL, 0x020fc4000000004aULL,
0x00007610ff457816ULL, 0x000fe2000000004aULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x00005410ff4d7816ULL, 0x100fe4000000004eULL, 0x00007610ff4f7816ULL, 0x000fe2000000004eULL,
0x0000000033337984ULL, 0x000f620000000800ULL, 0x00005410ff377816ULL, 0x108fe40000000042ULL,
0x00007610ff427816ULL, 0x000fe40000000042ULL, 0x00005410ff407816ULL, 0x000fc40000000048ULL,
0x00007610ff487816ULL, 0x000fe40000000048ULL, 0x00005410ff467816ULL, 0x100fe4000000004cULL,
0x00007610ff4c7816ULL, 0x000fe4000000004cULL, 0x00005410ff4a7816ULL, 0x100fe40000000034ULL,
0x00007610ff477816ULL, 0x000fe40000000034ULL, 0x00005410ff517816ULL, 0x000fc40000000050ULL,
0x00007610ff537816ULL, 0x000fe40000000050ULL, 0x00005410ff4e7816ULL, 0x100fe40000000052ULL,
0x00007610ff527816ULL, 0x000fe40000000052ULL, 0x00005410ff327816ULL, 0x102fe4000000003cULL,
0x00007610ff2f7816ULL, 0x000fe4000000003cULL, 0x00005410ff347816ULL, 0x004fc40000000036ULL,
0x00007610ff567816ULL, 0x000fe40000000036ULL, 0x00005410ff497816ULL, 0x110fe40000000038ULL,
0x00007610ff4b7816ULL, 0x000fe40000000038ULL, 0x00005410ff587816ULL, 0x120fe4000000003aULL,
0x00007610ff5a7816ULL, 0x000fe4000000003aULL, 0x00005410ff557816ULL, 0x000fc40000000033ULL,
0x00007610ff507816ULL, 0x000fe20000000033ULL, 0x000064927f007947ULL, 0x000fea000b800000ULL,
0x00001f2e572e7589ULL, 0x0002a400000e0000ULL, 0x000064f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2d572d7589ULL, 0x00072400000e0000ULL, 0x0000002e322b7223ULL, 0x084fe2000001002bULL,
0x0000002e2f2a7223ULL, 0x080fe2000001002aULL, 0x0000002e54297223ULL, 0x080fe20000010029ULL,
0x0000002e31287223ULL, 0x080fe20000010028ULL, 0x0000002e3e277223ULL, 0x080fe20000010027ULL,
0x0000002e35267223ULL, 0x080fe20000010026ULL, 0x0000002e37187223ULL, 0x080fe20000010018ULL,
0x0000002e42257223ULL, 0x080fe20000010025ULL, 0x0000002e3f0c7223ULL, 0x080fe2000001000cULL,
0x0000002e41247223ULL, 0x080fe20000010024ULL, 0x0000002e40137223ULL, 0x080fe20000010013ULL,
0x0000002e48237223ULL, 0x080fe20000010023ULL, 0x0000002e430e7223ULL, 0x080fe2000001000eULL,
0x0000002e45227223ULL, 0x080fe20000010022ULL, 0x0000002e460d7223ULL, 0x080fe2000001000dULL,
0x0000002e4c217223ULL, 0x000fe20000010021ULL, 0x0000002d4a0f7223ULL, 0x090fe2000001000fULL,
0x0000002d47207223ULL, 0x080fe20000010020ULL, 0x0000002d34177223ULL, 0x080fe20000010017ULL,
0x0000002d561f7223ULL, 0x080fe2000001001fULL, 0x0000002d49167223ULL, 0x080fe20000010016ULL,
0x0000002d4b1e7223ULL, 0x080fe2000001001eULL, 0x0000002d58157223ULL, 0x080fe20000010015ULL,
0x0000002d5a1d7223ULL, 0x080fe2000001001dULL, 0x0000002d4d147223ULL, 0x080fe20000010014ULL,
0x0000002d4f1c7223ULL, 0x080fe2000001001cULL, 0x0000002d51127223ULL, 0x080fe20000010012ULL,
0x0000002d531a7223ULL, 0x080fe2000001001aULL, 0x0000002d4e117223ULL, 0x080fe20000010011ULL,
0x0000002d52197223ULL, 0x080fe20000010019ULL, 0x0000002d55107223ULL, 0x080fe20000010010ULL,
0x0000002d50077223ULL, 0x000fe20000010007ULL, 0xfffff24000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x000000ff4400720cULL, 0x000fe20003f05270ULL, 0x0000001000037824ULL, 0x010fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x0000000100087824ULL, 0x000fe200078e0203ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000f240000000000ULL,
0x0000001000037824ULL, 0x010fe200078e00ffULL, 0x00000001ff067819ULL, 0x004fc80000011600ULL,
0x0000007003007812ULL, 0x000fe400078ec0ffULL, 0x0000000c06037812ULL, 0x000fc600078ec0ffULL,
0x000000801b007824ULL, 0x000fc800078e0200ULL, 0x0000000103037824ULL, 0x000fca00078e0200ULL,
0x0049802c03007388ULL, 0x0005e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800008007984ULL, 0x000f280000000800ULL, 0x004a000008037984ULL, 0x004ea20000000800ULL,
0x00000000ff007221ULL, 0x010fc80000010000ULL, 0x0000000300007221ULL, 0x004fca0000010000ULL,
0x0180000000037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e0000ULL,
0x0000d580000a7802ULL, 0x000fe40000000f00ULL, 0x000065b000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff037224ULL, 0x008fe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000037308ULL, 0x000ea40000001000ULL, 0xbf80000000067423ULL, 0x004fc80000000003ULL,
0x800000ff06067221ULL, 0x000fc80000010100ULL, 0x0000000603037223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff2c7819ULL, 0x004fe40000011600ULL,
0x0000000800317811ULL, 0x000fc600078ff0ffULL, 0x00001f2c03067589ULL, 0x000ea200000e0000ULL,
0x00000031ff337212ULL, 0x000fe200078e33ffULL, 0x00000008312e7824ULL, 0x000fe400078e00ffULL,
0x00001f31030a7589ULL, 0x00052600000e0000ULL, 0xfffffff82e337812ULL, 0x000fca00078ee233ULL,
0x0000001033337824ULL, 0x000fe200078e0204ULL, 0x0000002206037220ULL, 0x044fe20000410000ULL,
0x0000000c060c7220ULL, 0x040fe20000410000ULL, 0x0000002406097220ULL, 0x040fe20000410000ULL,
0x0000002b062b7220ULL, 0x000fe20000410000ULL, 0x0000001f0a227220ULL, 0x050fe20000410000ULL,
0x0000001a0a1f7220ULL, 0x040fe20000410000ULL, 0x000000110a117220ULL, 0x040fe20000410000ULL,
0x000000190a1a7220ULL, 0x000fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000002906297220ULL, 0x040fe20000410000ULL, 0x0000002806287220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000001806187220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000002306087220ULL, 0x040fe20000410000ULL,
0x0000000e060e7220ULL, 0x040fe20000410000ULL, 0x0000000d060d7220ULL, 0x000fe20000410000ULL,
0x0000001e0a0b7220ULL, 0x000fe20000410000ULL, 0x0000002106067220ULL, 0x000fe20000410000ULL,
0x0000001d0a1e7220ULL, 0x000fe20000410000ULL, 0x000000082c247824ULL, 0x000fe200078e00ffULL,
0x000000140a147220ULL, 0x040fe20000410000ULL, 0x0000001c0a1d7220ULL, 0x040fe20000410000ULL,
0x000000120a127220ULL, 0x040fe20000410000ULL, 0x0000000c0909723eULL, 0x000fe200000010ffULL,
0x0000000f0a0f7220ULL, 0x040fe20000410000ULL, 0x0000002cff217212ULL, 0x000fe200078e33ffULL,
0x000000200a207220ULL, 0x040fe20000410000ULL, 0x000000170a177220ULL, 0x040fe20000410000ULL,
0x000000160a167220ULL, 0x040fe20000410000ULL, 0x000000150a157220ULL, 0x040fe20000410000ULL,
0x000000100a107220ULL, 0x040fe20000410000ULL, 0x000000070a077220ULL, 0x000fe20000410000ULL,
0x00000008310c7824ULL, 0x000fe200078e00ffULL, 0x000000111a11723eULL, 0x000fe200000010ffULL,
0x00000004001c7824ULL, 0x000fe200078e00ffULL, 0x000000072c0a7812ULL, 0x000fc400078ec0ffULL,
0x00000007311a7812ULL, 0x000fe400078ec0ffULL, 0x0000000d0606723eULL, 0x000fe200000010ffULL,
0x000000082c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff824357812ULL, 0x000fe400078ee221ULL,
0x000000182518723eULL, 0x000fe400000010ffULL, 0x000000130808723eULL, 0x000fe400000010ffULL,
0x000000141d14723eULL, 0x000fc400000010ffULL, 0x000000121f12723eULL, 0x000fe400000010ffULL,
0x0000000e0303723eULL, 0x000fe400000010ffULL, 0x000000160b0b723eULL, 0x000fe400000010ffULL,
0x000000100707723eULL, 0x000fe400000010ffULL, 0x000000010a137812ULL, 0x040fe400078e3cffULL,
0x000000020a197812ULL, 0x000fc400078e3cffULL, 0x000000030a1d7812ULL, 0x000fe200078e3cffULL,
0x000000082c137824ULL, 0x000fe200078e0213ULL, 0x000000040a1f7812ULL, 0x000fe200078e3cffULL,
0x000000082c197824ULL, 0x000fe200078e0219ULL, 0x000000050a217812ULL, 0x000fe200078e3cffULL,
0x000000082c1d7824ULL, 0x000fe200078e021dULL, 0x000000060a237812ULL, 0x000fe200078e3cffULL,
0x000000082c1f7824ULL, 0x000fe200078e021fULL, 0xfffffff80c257812ULL, 0x000fe200078ee231ULL,
0x000000082c217824ULL, 0x000fe200078e0221ULL, 0x000000011a0a7812ULL, 0x040fe200078e3cffULL,
0x0000001013137824ULL, 0x100fe200078e0204ULL, 0x000000021a0c7812ULL, 0x000fe200078e3cffULL,
0x000000082c237824ULL, 0x000fe200078e0223ULL, 0x000000031a0e7812ULL, 0x040fe200078e3cffULL,
0x0000001019197824ULL, 0x100fe200078e0204ULL, 0x000000041a107812ULL, 0x040fe200078e3cffULL,
0x000000101d1d7824ULL, 0x100fe200078e0204ULL, 0x000000051a167812ULL, 0x040fe200078e3cffULL,
0x000000101f1f7824ULL, 0x000fe200078e0204ULL, 0x000000061a1a7812ULL, 0x000fe200078e3cffULL,
0x00000008312d7824ULL, 0x000fe200078e0210ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee22cULL,
0x00000008312f7824ULL, 0x040fe200078e0216ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x00000008312b7824ULL, 0x040fe200078e020eULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000000831297824ULL, 0x040fe200078e020cULL, 0x000000272626723eULL, 0x000fe200000010ffULL,
0x0000000831277824ULL, 0x040fe200078e020aULL, 0x0000000f200f723eULL, 0x000fe200000010ffULL,
0x0000000831317824ULL, 0x000fe200078e021aULL, 0x0000000c1c1a7812ULL, 0x000fe200078ec0ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0204ULL, 0x000000172217723eULL, 0x000fe200000010ffULL,
0x00000010350a7824ULL, 0x000fe200078e0204ULL, 0x000000151e15723eULL, 0x000fe200000010ffULL,
0x000000011a0d7824ULL, 0x000fc400078e020dULL, 0x0000001021217824ULL, 0x100fe400078e0204ULL,
0x000000011a137824ULL, 0x040fe200078e0213ULL, 0x0000002a0d007388ULL, 0x0005e20000000800ULL,
0x0000001023237824ULL, 0x100fe400078e0204ULL, 0x000000011a197824ULL, 0x000fe200078e0219ULL,
0x0000002813007388ULL, 0x0009e20000000800ULL, 0x00000010250c7824ULL, 0x100fe400078e0204ULL,
0x0000001027277824ULL, 0x100fe200078e0204ULL, 0x0000002619007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x000fc400078e0204ULL, 0x000000102b2b7824ULL, 0x100fe400078e0204ULL,
0x000000102d2d7824ULL, 0x100fe400078e0204ULL, 0x000000102f2f7824ULL, 0x100fe400078e0204ULL,
0x0000001031317824ULL, 0x000fe400078e0204ULL, 0x000000011a1d7824ULL, 0x040fe400078e021dULL,
0x000000011a047824ULL, 0x000fc400078e021fULL, 0x000000011a257824ULL, 0x040fe200078e020aULL,
0x000000181d007388ULL, 0x000fe20000000800ULL, 0x000000011a217824ULL, 0x040fe400078e0221ULL,
0x000000011a0a7824ULL, 0x040fe200078e0223ULL, 0x0000000904007388ULL, 0x000fe20000000800ULL,
0x000000011a0c7824ULL, 0x040fe400078e020cULL, 0x000000011a0e7824ULL, 0x040fe200078e0227ULL,
0x0000000821007388ULL, 0x000fe20000000800ULL, 0x000000011a107824ULL, 0x000fc400078e0229ULL,
0x000000011a167824ULL, 0x040fe200078e022bULL, 0x000000030a007388ULL, 0x000fe20000000800ULL,
0x000000011a2d7824ULL, 0x040fe400078e022dULL, 0x000000011a1c7824ULL, 0x040fe200078e0233ULL,
0x0000000625007388ULL, 0x000fe20000000800ULL, 0x000000011a2f7824ULL, 0x040fe400078e022fULL,
0x000000011a1a7824ULL, 0x000fe200078e0231ULL, 0x0000000f0c007388ULL, 0x000fe20000000800ULL,
0x000000201b0d7824ULL, 0x004fc600078e0200ULL, 0x000000170e007388ULL, 0x000fe20000000800ULL,
0x000000100d137824ULL, 0x010fc600078e0202ULL, 0x0000000b10007388ULL, 0x0005e80000000800ULL,
0x0000001516007388ULL, 0x000fe80000000800ULL, 0x000000142d007388ULL, 0x000fe20000000800ULL,
0x000000050510723eULL, 0x004fc600000010ffULL, 0x000000122f007388ULL, 0x000fe80000000800ULL,
0x000000111a007388ULL, 0x000fe80000000800ULL, 0x000000071c007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000013207984ULL, 0x000ea80000000c00ULL,
0x0004000013247984ULL, 0x000f280000000c00ULL, 0x00080000130c7984ULL, 0x000f680000000c00ULL,
0x000c000013087984ULL, 0x000e620000000c00ULL, 0x3f803f8010237831ULL, 0x004fc40000200023ULL,
0x3f803f8010227831ULL, 0x040fe40000200022ULL, 0x3f803f8010217831ULL, 0x040fe40000200021ULL,
0x3f803f8010207831ULL, 0x040fe40000200020ULL, 0x3f803f8010277831ULL, 0x050fe40000200027ULL,
0x3f803f8010267831ULL, 0x040fe40000200026ULL, 0x3f803f8010257831ULL, 0x000fc40000200025ULL,
0x3f803f8010247831ULL, 0x000fe40000200024ULL, 0x3f803f8023237831ULL, 0x020fe4000020000fULL,
0x3f803f8022227831ULL, 0x000fe4000020000eULL, 0x3f803f8021217831ULL, 0x000fe4000020000dULL,
0x3f803f8020207831ULL, 0x000fe4000020000cULL, 0x3f803f8027277831ULL, 0x002fc4000020000bULL,
0x3f803f8026267831ULL, 0x000fe2000020000aULL, 0x0000002013007388ULL, 0x0003e20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200009ULL, 0x3f803f8024247831ULL, 0x000fca0000200008ULL,
0x0004002413007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff1b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x000ea20000002600ULL, 0x00000020001d7810ULL, 0x042fe20007ffe0ffULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x00000040001f7810ULL, 0x040fe20007ffe0ffULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x0000006000217810ULL, 0x000fe20007ffe0ffULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x00000008441b7824ULL, 0x040fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe2000001161dULL,
0x00000008441a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fc4000001161fULL,
0x00000003ff177819ULL, 0x000fe40000011621ULL, 0x0000000715047812ULL, 0x000fe400078e481dULL,
0x0000000716067812ULL, 0x000fe400078e481fULL, 0x0000000717087812ULL, 0x000fe400078e4821ULL,
0x0ffffff804057812ULL, 0x000fe400078ef81dULL, 0x0ffffff806077812ULL, 0x000fe200078ef81fULL,
0x0000001018147824ULL, 0x004fe200078e00ffULL, 0x0ffffff808097812ULL, 0x000fe200078ef821ULL,
0x0000001005087824ULL, 0x100fe200078e0202ULL, 0x00000004050472a4ULL, 0x002fe2000f8e023fULL,
0x00000010070c7824ULL, 0x100fe200078e0202ULL, 0xfffffff014147812ULL, 0x000fe200078ee203ULL,
0x0000001009107824ULL, 0x000fe200078e0202ULL, 0x0000000703037812ULL, 0x100fe200078e4800ULL,
0x0000000008087984ULL, 0x000fe20000000c00ULL, 0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001018197824ULL, 0x040fe200078e00ffULL, 0x0ffffff803037812ULL, 0x100fe200078ef800ULL,
0x000000000c0c7984ULL, 0x000fe20000000c00ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000001018007824ULL, 0x000fe200078e00ffULL, 0xfffffff019167812ULL, 0x000fe200078ee216ULL,
0x0000001003037824ULL, 0x000fe200078e0202ULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x0000000844027824ULL, 0x000fe200078e00ffULL, 0xfffffff000157812ULL, 0x000fe200078ee215ULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x0000000003047984ULL, 0x0002a20000000c00ULL,
0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL, 0x0000000844447824ULL, 0x000fe200078e00ffULL,
0xfffffff8021d7812ULL, 0x000fc400078ee21dULL, 0xfffffff018177812ULL, 0x000fe400078ee217ULL,
0x00000004161a7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff037224ULL, 0x002fe200000e06ffULL,
0x00005a0014027a11ULL, 0x040fe400078040ffULL, 0x0000000417007c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x00005b0014037a11ULL, 0x000fe400000f4403ULL,
0x0000000415157c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005a001a167a11ULL, 0x000fe200078240ffULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x00005a0000187a11ULL, 0x000fc400078440ffULL, 0x00005b001a177a11ULL, 0x000fe200008f4417ULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005a0015147a11ULL, 0x000fe400078040ffULL,
0xfffffff844217812ULL, 0x000fe200078ee221ULL, 0x000000101f167825ULL, 0x000fe200078e0016ULL,
0x00005b0015157a11ULL, 0x000fe400000f441cULL, 0x00005b0000197a11ULL, 0x000fc600010f4419ULL,
0x000000101d147825ULL, 0x000fc800078e0014ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x0000000402007986ULL, 0x004fe8000c101d08ULL, 0x0000000814007986ULL, 0x000fe8000c101d08ULL,
0x0000000c16007986ULL, 0x000fe8000c101d08ULL, 0x0000001018007986ULL, 0x000fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff047624ULL, 0x00afe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011650ULL, 0x00006900ff057624ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe200078e00ffULL, 0x01ffffff03037812ULL, 0x000fe400078ec0ffULL,
0x0000000804317981ULL, 0x000366000c1e9900ULL, 0x00000002522c7824ULL, 0x000fca00078e0203ULL,
0x000000472c00720cULL, 0x000fe40003f06070ULL, 0x0000000152007810ULL, 0x000fd60007ffe0ffULL,
0x0000000208038824ULL, 0x000fc800078e00ffULL, 0x0000640003028a24ULL, 0x000fc800078e022cULL,
0x0000600002028625ULL, 0x000fca00078e0011ULL, 0x00000008022d8981ULL, 0x000362000c1e1900ULL,
0x000000450000720cULL, 0x000fe20003f06070ULL, 0x00000040502f7824ULL, 0x000fe400078e00ffULL,
0x000000802e2e7824ULL, 0x000fe400078e00ffULL, 0x0000010052077824ULL, 0x000fe400078e022fULL,
0x0000008013097824ULL, 0x000fc600078e00ffULL, 0x000000402e007812ULL, 0x000fc600078ef807ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x002e620000000000ULL,
0x0000002d09097224ULL, 0x020fe200078e0200ULL, 0x0000100050137811ULL, 0x000fe200078e68ffULL,
0x00000080ff217424ULL, 0x000fe200078e00ffULL, 0x00000002ff1d7819ULL, 0x102fe2000001160fULL,
0x000000100f1f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fe4000001160fULL,
0x0000007f1d007812ULL, 0x040fe400078ec0ffULL, 0x000000081d117810ULL, 0x000fc40007ffe0ffULL,
0x000000301f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000109007824ULL, 0x000fe200078e0200ULL,
0x000000101d237810ULL, 0x000fe40007ffe0ffULL, 0x0000007f11047812ULL, 0x000fe200078ec0ffULL,
0x00005e0000027625ULL, 0x000fe200078e0021ULL, 0x000000181d257810ULL, 0x000fe40007ffe0ffULL,
0x0000007f23067812ULL, 0x000fe200078ec0ffULL, 0x0000000109047824ULL, 0x000fe200078e0204ULL,
0x0000001f020a7210ULL, 0x000fc40007f1e0ffULL, 0x0000007f25027812ULL, 0x000fe200078ec0ffULL,
0x0000000109067824ULL, 0x000fe200078e0206ULL, 0x0000000746007217ULL, 0x000fe20007800000ULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x000000201d177810ULL, 0x000fe40007ffe0ffULL,
0x0000000312127812ULL, 0x000fe200078e480fULL, 0x0000000109027824ULL, 0x000fe200078e0202ULL,
0x000000281d197810ULL, 0x040fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a07ULL,
0x000000301d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0603ULL,
0x0000001f040c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000007f17047812ULL, 0x000fc400078ec0ffULL, 0x000000002300720cULL, 0x080fe20003fa6070ULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x0000001f06067210ULL, 0x080fe40007f3e0ffULL,
0x000000002500720cULL, 0x080fe20003f86070ULL, 0x0000000109047824ULL, 0x000fe200078e0204ULL,
0x0000001f020e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x0ffffffc12027812ULL, 0x000fe200078ef80fULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000001100720cULL, 0x080fe20003f26070ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x000000001d00720cULL, 0x000fc40003f06070ULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001002157824ULL, 0x000fe200078e0213ULL, 0x0000007f19027812ULL, 0x000fe200078ec0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x0000001f04107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e0603ULL, 0x000000001900720cULL, 0x080fe20003f46070ULL,
0x0000000109027824ULL, 0x000fe200078e0202ULL, 0xfffffffc11047812ULL, 0x000fe200078ee212ULL,
0x000000ffff117224ULL, 0x000fe200018e0605ULL, 0x000000001700720cULL, 0x080fe20003f66070ULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000c101c48ULL, 0x000000001d00720cULL, 0x000fc40003f06070ULL,
0x0000001004057824ULL, 0x000fe200078e0213ULL, 0x0000007f1b047812ULL, 0x000fe200078ec0ffULL,
0x0000000423237824ULL, 0x000fe400078e00ffULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x000000000c057faeULL, 0x0005e2000c901c48ULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x000000001b00720cULL, 0x000fe20003f26070ULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x0000001f020a7210ULL, 0x002fe20007fde0ffULL, 0x0000000109027824ULL, 0x000fe200078e0204ULL,
0xfffffffc23007812ULL, 0x100fe200078ee212ULL, 0x000000041b1b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc17147812ULL, 0x100fe200078ee212ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0603ULL,
0xfffffffc19167812ULL, 0x000fe200078ee212ULL, 0x00005e0002027625ULL, 0x000fe200078e0021ULL,
0x0000007f1d0c7812ULL, 0x004fc400078ec0ffULL, 0xfffffffc1b187812ULL, 0x000fe200078ee212ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x0000001f02027210ULL, 0x000fe20007fde0ffULL,
0x0000000109047824ULL, 0x000fe200078e020cULL, 0xfffffffc250c7812ULL, 0x100fe200078ee212ULL,
0x0000001000097824ULL, 0x000fe200078e0213ULL, 0xfffffffc1d127812ULL, 0x000fe200078ee212ULL,
0x00005e0004047625ULL, 0x000fc600078e0021ULL, 0x0000000006097faeULL, 0x0003e2000e901c48ULL,
0x000000ffff037224ULL, 0x000fe200030e0603ULL, 0x0000001f04047210ULL, 0x000fe20007fde0ffULL,
0x000000100c0d7824ULL, 0x100fe400078e0213ULL, 0x0000001014157824ULL, 0x100fe400078e0213ULL,
0x0000001016177824ULL, 0x100fe200078e0213ULL, 0x000000000e0d7faeULL, 0x0003e2000e101c48ULL,
0x0000001018197824ULL, 0x100fe400078e0213ULL, 0x0000001012137824ULL, 0x000fe200078e0213ULL,
0x0000000010157faeULL, 0x0003e2000d901c48ULL, 0x000000ffff057224ULL, 0x000fc600030e0605ULL,
0x000000000a177faeULL, 0x0003e8000d101c48ULL, 0x0000000002197faeULL, 0x0003e8000c901c48ULL,
0x0000000004137faeULL, 0x0003e2000c101c48ULL, 0x000005a000007947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x002e620000000000ULL, 0x0000002d09007224ULL, 0x020fc400078e0200ULL,
0x00000080ff127424ULL, 0x000fe200078e00ffULL, 0x00000002ff037819ULL, 0x102fe40000011602ULL,
0x00000003ff057819ULL, 0x000fe40000011602ULL, 0x0000007f03077812ULL, 0x040fe400078ec0ffULL,
0x0000000803047810ULL, 0x040fe40007ffe0ffULL, 0x0000001003067810ULL, 0x040fe40007ffe0ffULL,
0x00000018030a7810ULL, 0x000fc40007ffe0ffULL, 0x00000020030c7810ULL, 0x040fe40007ffe0ffULL,
0x00000028030e7810ULL, 0x040fe40007ffe0ffULL, 0x0000003003107810ULL, 0x040fe40007ffe0ffULL,
0x0000003803147810ULL, 0x000fe20007ffe0ffULL, 0x0000000100037824ULL, 0x000fe200078e0207ULL,
0x0000007f04077812ULL, 0x040fe200078ec0ffULL, 0x0000000404047824ULL, 0x000fe200078e00ffULL,
0x0000007f06097812ULL, 0x040fe200078ec0ffULL, 0x0000000406067824ULL, 0x000fe200078e00ffULL,
0x0000007f0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000100077824ULL, 0x000fe200078e0207ULL,
0x0000007f0c117812ULL, 0x000fe200078ec0ffULL, 0x00000001000d7824ULL, 0x000fe200078e0209ULL,
0x0000007f0e137812ULL, 0x000fe200078ec0ffULL, 0x00000001000f7824ULL, 0x000fe200078e020bULL,
0x0000007f10157812ULL, 0x000fe200078ec0ffULL, 0x0000000100117824ULL, 0x000fe200078e0211ULL,
0x0000007f14177812ULL, 0x000fe200078ec0ffULL, 0x0000000100137824ULL, 0x040fe200078e0213ULL,
0x0000000305057812ULL, 0x100fe200078e4802ULL, 0x0000000100217824ULL, 0x000fe200078e0215ULL,
0x00001000500b7811ULL, 0x000fe200078e68ffULL, 0x0000000100257824ULL, 0x000fe200078e0217ULL,
0xfffffffc04047812ULL, 0x100fe200078ee205ULL, 0x0000001002007824ULL, 0x000fe200078e00ffULL,
0x0ffffffc05027812ULL, 0x000fe200078ef802ULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x100fe200078ee205ULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x0000003000097812ULL, 0x000fe200078ec0ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee205ULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c0c7812ULL, 0x100fe200078ee205ULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee205ULL, 0x0000001002157824ULL, 0x000fe200078e020bULL,
0xfffffffc10107812ULL, 0x100fe200078ee205ULL, 0x00005e0003027625ULL, 0x000fe200078e0012ULL,
0xfffffffc14147812ULL, 0x000fc600078ee205ULL, 0x0000001004177824ULL, 0x100fe200078e020bULL,
0x0000000902027210ULL, 0x000fe20007f1e0ffULL, 0x0000001006197824ULL, 0x100fe400078e020bULL,
0x000000100a1b7824ULL, 0x100fe400078e020bULL, 0x000000100c1d7824ULL, 0x100fe400078e020bULL,
0x000000100e1f7824ULL, 0x100fe400078e020bULL, 0x0000001010237824ULL, 0x000fc400078e020bULL,
0x0000001014277824ULL, 0x000fe400078e020bULL, 0x00005e000f0a7625ULL, 0x000fc800078e0012ULL,
0x00005e0007047625ULL, 0x000fc800078e0012ULL, 0x00005e000d067625ULL, 0x000fe200078e0012ULL,
0x0000000904047210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x000000090a0a7210ULL, 0x080fe20007f1e0ffULL, 0x00005e00110c7625ULL, 0x080fe200078e0012ULL,
0x0000000906067210ULL, 0x000fe40007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000b901c48ULL, 0x00005e00130e7625ULL, 0x000fc800078e0012ULL,
0x00005e0021107625ULL, 0x000fc800078e0012ULL, 0x00005e0025127625ULL, 0x000fc800078e0012ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000090c0c7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e0605ULL, 0x000000090e0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x0000000910107210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000000912127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x000000ffff117224ULL, 0x000fc400010e0611ULL, 0x000000ffff137224ULL, 0x000fe200018e0613ULL,
0x0000000006197faeULL, 0x0003e8000b901c48ULL, 0x000000000a1b7faeULL, 0x0003e8000b901c48ULL,
0x000000000c1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010237faeULL, 0x0003e8000b901c48ULL, 0x0000000012277faeULL, 0x0003e4000b901c48ULL,
0x00f60400ff007984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x00f60400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000035000780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e640000000000ULL,
0x0000002050007824ULL, 0x002fc800078e0203ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x00000003ff027819ULL, 0x000fc80000011600ULL, 0x1ffffffe02037812ULL, 0x000fe400078ec0ffULL,
0x000000f004047812ULL, 0x000fe400078ec0ffULL, 0x0000000103057812ULL, 0x040fe400078efcffULL,
0x0000000703037812ULL, 0x100fe400078e7800ULL, 0x0000000705057812ULL, 0x000fc600078e7800ULL,
0x0000000103037824ULL, 0x000fe400078e0204ULL, 0x0000000104057824ULL, 0x000fc600078e0205ULL,
0x0000000003107984ULL, 0x000e68000000cc00ULL, 0x00000000050c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fc400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff137224ULL, 0x000fe200078e000fULL,
0x0000001403007388ULL, 0x0003e8000000cc00ULL, 0x0000001005007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x00f60400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x00f60400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000455200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000307919ULL, 0x000ea20000000000ULL, 0x3db504f331317820ULL, 0x000fe20000410000ULL,
0x0000640008337a24ULL, 0x000fe200078e02ffULL, 0xffffffff45357810ULL, 0x000fe20007ffe0ffULL,
0x0000001050327824ULL, 0x000fe200078e00ffULL, 0x00007610ff347816ULL, 0x000fe20000000034ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x0000010052397824ULL, 0x000fe200078e022fULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000394600720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x028fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0037ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x002fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000100037810ULL, 0x000fe20007ffe0ffULL,
0x00000bd000007945ULL, 0x000fe20003800000ULL, 0x000000013b377812ULL, 0x000fc400078e0cffULL,
0x00000001ff217819ULL, 0x000fe40000011603ULL, 0x000000020300780cULL, 0x040fe40003f06070ULL,
0x0000000103447812ULL, 0x000fe200078ec0ffULL, 0x0000030021027a24ULL, 0x000fc800078e0252ULL,
0x0000010002227824ULL, 0x040fe200078e022fULL, 0x0000000102207810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff027224ULL, 0x000fe400078e0000ULL, 0x000000ffff007224ULL, 0x000fe200078e0003ULL,
0x000000452000720cULL, 0x000fe40003f26070ULL, 0x0000004022217812ULL, 0x000fca00078ec0ffULL,
0x000000012e287824ULL, 0x000fcc00078e0221ULL, 0x000005d000009947ULL, 0x020fea0003800000ULL,
0x00000002ff2a7819ULL, 0x004fe20000011630ULL, 0x000000042d287c24ULL, 0x000fe2000f8e0228ULL,
0x00000003ff217819ULL, 0x000fe20000011630ULL, 0x0000000444417824ULL, 0x000fe200078e00ffULL,
0x0000002246037217ULL, 0x000fe20007800000ULL, 0x0000000250297824ULL, 0x000fe200078e0237ULL,
0x000000082a367810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff3f7424ULL, 0x000fe200078e00ffULL,
0x0000007f2a237812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a22ULL,
0x0000000321437812ULL, 0x000fe200078e4830ULL, 0x0000000436387824ULL, 0x040fe200078e00ffULL,
0x0000007f36217812ULL, 0x000fe200078ec0ffULL, 0x0000000123207824ULL, 0x000fe200078e0228ULL,
0x000000032a00720cULL, 0x000fc40003f26070ULL, 0x000000033600720cULL, 0x000fe20003f46070ULL,
0x0000000121227824ULL, 0x000fe200078e0228ULL, 0xfffffffc41417812ULL, 0x100fe200078ee230ULL,
0x00005e0020207625ULL, 0x080fe200078e003fULL, 0x0000100029297811ULL, 0x000fe400078e60ffULL,
0x0ffffffc43367812ULL, 0x000fe200078ef830ULL, 0x00005e0022227625ULL, 0x000fe200078e003fULL,
0xfffffffc38387812ULL, 0x000fe400078ee243ULL, 0x000000202a3a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010362b7824ULL, 0x000fe200078e0229ULL, 0x000000102a367810ULL, 0x040fe20007ffe0ffULL,
0x0000001041207825ULL, 0x000fe200078e0020ULL, 0x000000282a407810ULL, 0x000fc40007ffe0ffULL,
0x000000302a427810ULL, 0x000fe20007ffe0ffULL, 0x00000010383d7824ULL, 0x000fe200078e0229ULL,
0x000000182a387810ULL, 0x040fe20007ffe0ffULL, 0x0000001041227825ULL, 0x000fe200078e0022ULL,
0x000000382a487810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000202b7faeULL, 0x0003e2000c901c48ULL, 0x000000033600720cULL, 0x080fe40003f26070ULL,
0x000000033a00720cULL, 0x080fe20003f66070ULL, 0x00000000223d7faeULL, 0x0005e2000d101c48ULL,
0x000000033800720cULL, 0x000fc40003f46070ULL, 0x000000034000720cULL, 0x080fe40003f86070ULL,
0x000000034200720cULL, 0x080fe40003fa6070ULL, 0x000000034800720cULL, 0x000fe40003fc6070ULL,
0x0000007f36037812ULL, 0x000fe400078ec0ffULL, 0x0000007f38217812ULL, 0x002fe400078ec0ffULL,
0x0000007f3a237812ULL, 0x004fe200078ec0ffULL, 0x0000000103207824ULL, 0x100fe200078e0228ULL,
0x0000007f402b7812ULL, 0x000fe200078ec0ffULL, 0x0000000121227824ULL, 0x100fe200078e0228ULL,
0x0000007f423d7812ULL, 0x000fe200078ec0ffULL, 0x00000001232a7824ULL, 0x100fe200078e0228ULL,
0x0000007f48497812ULL, 0x000fe200078ec0ffULL, 0x000000012b2b7824ULL, 0x000fc400078e0228ULL,
0x000000013d3c7824ULL, 0x100fe400078e0228ULL, 0x00000001493e7824ULL, 0x000fe400078e0228ULL,
0x0000000436287824ULL, 0x000fe400078e00ffULL, 0x0000000438367824ULL, 0x000fe400078e00ffULL,
0x000000043a387824ULL, 0x000fe200078e00ffULL, 0xfffffffc28287812ULL, 0x100fe200078ee243ULL,
0x00000004403a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc36367812ULL, 0x100fe200078ee243ULL,
0x0000000442407824ULL, 0x000fe200078e00ffULL, 0xfffffffc38387812ULL, 0x100fe200078ee243ULL,
0x0000000448427824ULL, 0x000fe200078e00ffULL, 0xfffffffc3a3a7812ULL, 0x100fe200078ee243ULL,
0x00005e0020207625ULL, 0x000fe200078e003fULL, 0xfffffffc40407812ULL, 0x000fc400078ee243ULL,
0xfffffffc42427812ULL, 0x000fe200078ee243ULL, 0x0000001028037824ULL, 0x100fe400078e0229ULL,
0x0000001036437824ULL, 0x100fe400078e0229ULL, 0x0000001038497824ULL, 0x100fe400078e0229ULL,
0x000000103a4b7824ULL, 0x100fe400078e0229ULL, 0x00000010404d7824ULL, 0x100fe400078e0229ULL,
0x00000010424f7824ULL, 0x000fc400078e0229ULL, 0x00005e0022227625ULL, 0x000fc800078e003fULL,
0x00005e002a287625ULL, 0x000fc800078e003fULL, 0x00005e002b2a7625ULL, 0x000fc800078e003fULL,
0x00005e003c3c7625ULL, 0x000fc800078e003fULL, 0x00005e003e3e7625ULL, 0x000fc800078e003fULL,
0x0000001041207825ULL, 0x000fc800078e0020ULL, 0x0000001041227825ULL, 0x040fe200078e0022ULL,
0x0000000020037faeULL, 0x0003e6000c901c48ULL, 0x0000001041287825ULL, 0x040fe200078e0028ULL,
0x0000000022437faeULL, 0x0003e6000d101c48ULL, 0x00000010412a7825ULL, 0x040fe200078e002aULL,
0x0000000028497faeULL, 0x0003e6000d901c48ULL, 0x00000010413c7825ULL, 0x040fe200078e003cULL,
0x000000002a4b7faeULL, 0x0003e6000e101c48ULL, 0x00000010413e7825ULL, 0x000fe200078e003eULL,
0x000000003c4d7faeULL, 0x0003e8000e901c48ULL, 0x000000003e4f7faeULL, 0x0003e2000f101c48ULL,
0x0000052000007947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x004fe20000011630ULL,
0x000000042d287c24ULL, 0x000fc4000f8e0228ULL, 0x0000000250227824ULL, 0x000fe200078e0237ULL,
0x0000007f03217812ULL, 0x040fe400078ec0ffULL, 0x00000010032b7810ULL, 0x040fe40007ffe0ffULL,
0x00000008032a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000121207824ULL, 0x000fe200078e0228ULL,
0x00000018033a7810ULL, 0x040fe40007ffe0ffULL, 0x00000020033d7810ULL, 0x040fe40007ffe0ffULL,
0x00000028033f7810ULL, 0x000fc40007ffe0ffULL, 0x0000003003407810ULL, 0x000fe20007ffe0ffULL,
0x000000043d4c7824ULL, 0x000fe200078e00ffULL, 0x0000003803487810ULL, 0x000fe20007ffe0ffULL,
0x000000043f547824ULL, 0x000fe200078e00ffULL, 0x0000007f2b217812ULL, 0x000fe200078ec0ffULL,
0x0000000440567824ULL, 0x000fe200078e00ffULL, 0x0000007f2a037812ULL, 0x000fe200078ec0ffULL,
0x0000000448587824ULL, 0x000fe200078e00ffULL, 0x0000007f3a237812ULL, 0x000fe200078ec0ffULL,
0x0000000121387824ULL, 0x100fe200078e0228ULL, 0x0000007f3d297812ULL, 0x000fe200078ec0ffULL,
0x0000000103367824ULL, 0x100fe200078e0228ULL, 0x0000007f3f417812ULL, 0x000fe200078ec0ffULL,
0x00000001233c7824ULL, 0x100fe200078e0228ULL, 0x0000007f40437812ULL, 0x000fe200078ec0ffULL,
0x00000001293e7824ULL, 0x100fe200078e0228ULL, 0x0000007f48497812ULL, 0x000fe200078ec0ffULL,
0x0000000141427824ULL, 0x000fe200078e0228ULL, 0x00000003ff217819ULL, 0x000fe20000011630ULL,
0x00000001434a7824ULL, 0x100fe200078e0228ULL, 0x0000100022297811ULL, 0x000fe200078e60ffULL,
0x00000001494e7824ULL, 0x000fe200078e0228ULL, 0x0000000321237812ULL, 0x000fe200078e4830ULL,
0x000000042a287824ULL, 0x000fc400078e00ffULL, 0x000000042b2a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc23227812ULL, 0x000fe200078ef830ULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc4c407812ULL, 0x100fe200078ee223ULL, 0x0000000444037824ULL, 0x000fe200078e00ffULL,
0xfffffffc54487812ULL, 0x100fe200078ee223ULL, 0x00000080ff437424ULL, 0x000fe200078e00ffULL,
0xfffffffc28287812ULL, 0x000fe200078ee223ULL, 0x0000001022497824ULL, 0x000fe200078e0229ULL,
0xfffffffc2a2a7812ULL, 0x100fe200078ee223ULL, 0x00005e0020207625ULL, 0x000fe200078e0043ULL,
0xfffffffc3a3a7812ULL, 0x000fc400078ee223ULL, 0xfffffffc564c7812ULL, 0x000fe200078ee223ULL,
0x00000010284b7824ULL, 0x000fe200078e0229ULL, 0xfffffffc58547812ULL, 0x000fe200078ee223ULL,
0x000000102a4d7824ULL, 0x100fe200078e0229ULL, 0xfffffffc03037812ULL, 0x000fe200078ee230ULL,
0x000000103a4f7824ULL, 0x100fe400078e0229ULL, 0x0000001040517824ULL, 0x100fe400078e0229ULL,
0x0000001048537824ULL, 0x100fe400078e0229ULL, 0x000000104c557824ULL, 0x000fc400078e0229ULL,
0x0000001054577824ULL, 0x000fe400078e0229ULL, 0x00005e0036227625ULL, 0x000fc800078e0043ULL,
0x00005e0038287625ULL, 0x000fc800078e0043ULL, 0x00005e003c2a7625ULL, 0x000fc800078e0043ULL,
0x00005e003e3c7625ULL, 0x000fc800078e0043ULL, 0x00005e00423e7625ULL, 0x000fc800078e0043ULL,
0x0000001003207825ULL, 0x000fc800078e0020ULL, 0x00005e004a407625ULL, 0x080fe200078e0043ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020497faeULL, 0x0003e6000b901c48ULL,
0x00005e004e427625ULL, 0x000fc800078e0043ULL, 0x0000001003227825ULL, 0x000fc800078e0022ULL,
0x0000001003287825ULL, 0x040fe200078e0028ULL, 0x00000000224b7faeULL, 0x0003e6000b901c48ULL,
0x00000010032a7825ULL, 0x040fe200078e002aULL, 0x00000000284d7faeULL, 0x0003e6000b901c48ULL,
0x00000010033c7825ULL, 0x040fe200078e003cULL, 0x000000002a4f7faeULL, 0x0003e6000b901c48ULL,
0x00000010033e7825ULL, 0x040fe200078e003eULL, 0x000000003c517faeULL, 0x0003e6000b901c48ULL,
0x0000001003407825ULL, 0x040fe200078e0040ULL, 0x000000003e537faeULL, 0x0003e6000b901c48ULL,
0x0000001003427825ULL, 0x000fe200078e0042ULL, 0x0000000040557faeULL, 0x0003e8000b901c48ULL,
0x0000000042577faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff4400720cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000009947ULL, 0x000fea0003800000ULL, 0x00000300ff037624ULL, 0x002fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000002032c7824ULL, 0x000fca00078e022cULL,
0x000000472c00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000233207824ULL, 0x000fe400078e022cULL, 0x00000004ff217424ULL, 0x000fc800078e00ffULL,
0x0000600020207625ULL, 0x000fca00078e0021ULL, 0x00000008202d7981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008023d7824ULL, 0x002fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff830037812ULL, 0x000fe200078ec0ffULL,
0x0000000250237824ULL, 0x000fe200078e023bULL, 0x0000002030297810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000703037812ULL, 0x000fe400078ef830ULL,
0xfffffff829297812ULL, 0x000fc400078ec0ffULL, 0x00000001ff027819ULL, 0x000fe40000011603ULL,
0x0000000729207812ULL, 0x000fe400078ef830ULL, 0x0000000302217812ULL, 0x000fe400078ec0ffULL,
0x00000001ff227819ULL, 0x000fe40000011620ULL, 0x0000003621027212ULL, 0x000fe400078e3cffULL,
0x0000000322297812ULL, 0x000fc400078ec0ffULL, 0x0000100023237811ULL, 0x000fe200078e60ffULL,
0x0000000403027824ULL, 0x000fe200078e0202ULL, 0x00000036292b7212ULL, 0x000fe400078e3cffULL,
0x0000000136227810ULL, 0x000fe20007ffe0ffULL, 0x0000001002487824ULL, 0x000fe200078e0223ULL,
0x0000000236367810ULL, 0x000fe20007ffe0ffULL, 0x0000000420027824ULL, 0x000fc600078e022bULL,
0x000000043600780cULL, 0x000fe20003f25270ULL, 0x0000001002407824ULL, 0x000fe200078e0223ULL,
0x0000002221027212ULL, 0x000fe200078e3cffULL, 0x000000004848783bULL, 0x000e620000000200ULL,
0x0000000730217812ULL, 0x000fc600078ec0ffULL, 0x0000000403287824ULL, 0x000fe200078e0202ULL,
0x00000008215c7812ULL, 0x000fe200078ef830ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x0000002229217212ULL, 0x000fe200078e3cffULL, 0x0000001028287824ULL, 0x000fe200078e0223ULL,
0x0000003d30027211ULL, 0x000fe400078fe0ffULL, 0x000000043d3d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000420207824ULL, 0x000fe200078e0221ULL, 0x00000007024c7812ULL, 0x040fe200078e785cULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x0000000202037810ULL, 0x000fe20007ffe0ffULL,
0x0000001020207824ULL, 0x000fc400078e0223ULL, 0x000000105c4c7824ULL, 0x000fe200078e024cULL,
0x0000000703037812ULL, 0x000fc600078e785cULL, 0x000000002020783bULL, 0x000ee40000000200ULL,
0x000000105c5c7824ULL, 0x000fe200078e0203ULL, 0x00000010ff7b7819ULL, 0x002fe40000011648ULL,
0x0000ffff487c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff737819ULL, 0x100fe4000001164aULL, 0x00000018ff577819ULL, 0x000fc4000001164aULL,
0x000000ff4a697812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4a717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe4000001164bULL, 0x00000018ff6a7819ULL, 0x000fe4000001164bULL,
0x000000ff4b7d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4b6f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4a7819ULL, 0x104fe4000001162aULL, 0x00000018ff7e7819ULL, 0x000fe4000001162aULL,
0x000000ff2a7f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2a4b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x108fe40000011620ULL, 0x00000018ff4f7819ULL, 0x000fc40000011620ULL,
0x000000ff20517812ULL, 0x040fe400078ec0ffULL, 0x0000ffff205b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x0000007bff20723eULL, 0x000fe400020006ffULL,
0x00000010ff787819ULL, 0x000fe40000011649ULL, 0x0000007cff7b723eULL, 0x000fe200020006ffULL,
0x20000020ff7c7230ULL, 0x000fe20000004100ULL, 0x0000ffff49747812ULL, 0x000fc400078ec0ffULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000008ff207819ULL, 0x000fe40000011671ULL, 0x00000018ff387819ULL, 0x000fe40000011648ULL,
0x00000008ff747819ULL, 0x000fe40000011674ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000020ff20723eULL, 0x000fc400020006ffULL, 0x000000ff41627812ULL, 0x000fe400078ec0ffULL,
0x00000038ff72723eULL, 0x000fe400020006ffULL, 0x00000018ff657819ULL, 0x000fe40000011642ULL,
0x00000010ff5a7819ULL, 0x100fe20000011621ULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x00000018ff537819ULL, 0x000fe40000011621ULL, 0x000000ff21547812ULL, 0x000fc400078ec0ffULL,
0x0000ffff21387812ULL, 0x000fe400078ec0ffULL, 0x00000074ff21723eULL, 0x000fe200020006ffULL,
0x20000078ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe20000011629ULL,
0x20000020ff787230ULL, 0x000fe20000004100ULL, 0x000000ff483f7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000018ff487819ULL, 0x000fc40000011649ULL,
0x000000ff49567812ULL, 0x000fe400078ec0ffULL, 0x00000065ff20723eULL, 0x000fe200020006ffULL,
0x20000062ff657230ULL, 0x000fe20000004100ULL, 0x000000ff43497812ULL, 0x000fe400078ec0ffULL,
0x000000ff61617812ULL, 0x000fe200078ec0ffULL, 0x20000020ff627230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x00000049ff49723eULL, 0x000fc400020006ffULL,
0x00000061ff20723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe200078ec0ffULL,
0x20000049ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff3a7819ULL, 0x100fe20000011622ULL,
0x20000020ff497230ULL, 0x000fe20000004100ULL, 0x00000018ff557819ULL, 0x000fe40000011622ULL,
0x000000ff225f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff223c7812ULL, 0x000fc400078ec0ffULL,
0x00000073ff22723eULL, 0x000fe200020006ffULL, 0x20000021ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x00000070ff21723eULL, 0x000fe200020006ffULL,
0x20000022ff717230ULL, 0x000fe20000004100ULL, 0x000000ff4a207812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4b7819ULL, 0x000fe4000001164bULL, 0x0000006fff70723eULL, 0x000fe200020006ffULL,
0x20000021ff6f7230ULL, 0x000fe20000004100ULL, 0x00000020ff22723eULL, 0x000fe200020006ffULL,
0x000000104c207824ULL, 0x000fe200078e00ffULL, 0x0000004bff21723eULL, 0x000fe200020006ffULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff3e7819ULL, 0x100fe20000011623ULL,
0x20000022ff4b7230ULL, 0x000fe20000004100ULL, 0x00000018ff767819ULL, 0x000fe20000011623ULL,
0x20000021ff4c7230ULL, 0x000fe20000004100ULL, 0x000000ff23757812ULL, 0x000fc400078ec0ffULL,
0x0000ffff23447812ULL, 0x000fe400078ec0ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x0000ffff29797812ULL, 0x000fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe40000011641ULL,
0x00000008ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff5d7819ULL, 0x000fe40000011640ULL,
0x00000079ff79723eULL, 0x000fc400020006ffULL, 0x00000018ff7a7819ULL, 0x000fe40000011643ULL,
0x0000ffff405e7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x100fe4000001162bULL, 0x00000018ff807819ULL, 0x000fe4000001162bULL,
0x000000ff2b817812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2b4e7812ULL, 0x000fc400078ec0ffULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000060ff2b723eULL, 0x000fe400020006ffULL,
0x0000007aff60723eULL, 0x000fe200020006ffULL, 0x2000003fff777230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fc4000001165eULL, 0x00000076ff7a723eULL, 0x000fe400020006ffULL,
0x00000075ff79723eULL, 0x000fe400020006ffULL, 0x00000010ff027819ULL, 0x000fe40000011641ULL,
0x0000ffff41037812ULL, 0x000fe400078ec0ffULL, 0x0000005dff76723eULL, 0x000fe200020006ffULL,
0x2000005fff5d7230ULL, 0x000fe20000004100ULL, 0x0000005eff75723eULL, 0x000fe200020006ffULL,
0x2000007aff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff027a7812ULL, 0x000fe200078ec0ffULL,
0x20000079ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff797819ULL, 0x000fe20000011603ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000018ff667819ULL, 0x000fe20000011640ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x000000ff40677812ULL, 0x000fc400078ec0ffULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff027819ULL, 0x000fe40000011677ULL,
0x00000010ff037819ULL, 0x000fe4000001167cULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff6b7819ULL, 0x000fe40000011642ULL, 0x000000ff42637812ULL, 0x000fc400078ec0ffULL,
0x0000ffff426e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe40000011643ULL,
0x0000ffff43647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff587819ULL, 0x100fe40000011628ULL,
0x00000018ff407819ULL, 0x000fe40000011628ULL, 0x000000ff28417812ULL, 0x000fc400078ec0ffULL,
0x0000ffff28597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe40000011629ULL,
0x000000ff29437812ULL, 0x000fe400078ec0ffULL, 0x00000048ff28723eULL, 0x000fe400020006ffULL,
0x00000056ff29723eULL, 0x000fe400020006ffULL, 0x0000105472037816ULL, 0x000fe20000000003ULL,
0x20000028ff287230ULL, 0x000fe20000004100ULL, 0x000010547b027816ULL, 0x000fe20000000002ULL,
0x20000029ff297230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fc400020006ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x000000022024723cULL, 0x002fe20000041824ULL, 0x20000069ff6d7230ULL, 0x000fe20000004100ULL,
0x0000007dff69723eULL, 0x000fe200020006ffULL, 0x20000057ff6c7230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff027819ULL, 0x000fe20000011628ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff287819ULL, 0x000fe20000011629ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff297819ULL, 0x000fc40000011674ULL, 0x00000010ff037819ULL, 0x000fe40000011673ULL,
0x0000105402297816ULL, 0x000fe40000000029ULL, 0x0000105403287816ULL, 0x000fe40000000028ULL,
0x00000010ff027819ULL, 0x000fe4000001166dULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff037819ULL, 0x000fe20000011671ULL, 0x00000028201c723cULL, 0x000fe2000004181cULL,
0x00000010ff6d7819ULL, 0x000fc40000011678ULL, 0x000010546c037816ULL, 0x000fe40000000003ULL,
0x000010546d027816ULL, 0x000fe40000000002ULL, 0x00000010ff287819ULL, 0x000fe40000011669ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff297819ULL, 0x000fe2000001166fULL,
0x000000022004723cULL, 0x000fe20000041804ULL, 0x00000010ff697819ULL, 0x000fc40000011670ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x000010546a297816ULL, 0x000fe20000000029ULL, 0x20000079ff727230ULL, 0x000fe20000004100ULL,
0x0000105469287816ULL, 0x000fe40000000028ULL, 0x000000ff6b777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x00000010ff037819ULL, 0x000fe20000011676ULL,
0x000000282008723cULL, 0x000fe20000041808ULL, 0x00000008ff6b7819ULL, 0x000fe2000001166eULL,
0x2000007aff6e7230ULL, 0x000fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff027819ULL, 0x000fe40000011667ULL, 0x0000105466037816ULL, 0x000fe40000000003ULL,
0x00000064ff67723eULL, 0x000fc400020006ffULL, 0x000000ff2a667812ULL, 0x000fe200078ec0ffULL,
0x000000105c2a7824ULL, 0x000fe200078e00ffULL, 0x00000010ff287819ULL, 0x000fe2000001162bULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe40000011665ULL,
0x00000010ff297819ULL, 0x000fe40000011672ULL, 0x00000010ff657819ULL, 0x000fe4000001166eULL,
0x0000105429647816ULL, 0x000fc40000000064ULL, 0x0000105428657816ULL, 0x000fe40000000065ULL,
0x000000002a28783bULL, 0x000e620000000200ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000077ff79723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x000000642010723cULL, 0x000fe20000041810ULL, 0x0000006bff77723eULL, 0x000fe200020006ffULL,
0x20000079ff6b7230ULL, 0x000fe20000004100ULL, 0x0000105475027816ULL, 0x000fe20000000002ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff58587812ULL, 0x000fe200078ec0ffULL,
0x20000077ff737230ULL, 0x000fe20000004100ULL, 0x00000008ff597819ULL, 0x000fc40000011659ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x00000002200c723cULL, 0x000fe2000004180cULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000010ff027819ULL, 0x000fe40000011663ULL,
0x00000010ff037819ULL, 0x000fe2000001166bULL, 0x20000040ff567230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000041ff577230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000105462037816ULL, 0x000fe20000000003ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000105473027816ULL, 0x000fe20000000002ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fc40000011656ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000008ff627819ULL, 0x000fe2000001165bULL, 0x000000022014723cULL, 0x000fe20000041814ULL,
0x000000ff5a637812ULL, 0x000fe400078ec0ffULL, 0x0000007eff40723eULL, 0x000fe400020006ffULL,
0x0000007fff3f723eULL, 0x000fe400020006ffULL, 0x00000010ff027819ULL, 0x000fe20000011657ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff037819ULL, 0x000fe20000011658ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x00000010ff5a7819ULL, 0x000fe40000011661ULL, 0x00000010ff5b7819ULL, 0x000fe40000011668ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x0000105456037816ULL, 0x000fe20000000003ULL,
0x20000042ff417230ULL, 0x000fe20000004100ULL, 0x0000105459027816ULL, 0x000fe20000000002ULL,
0x20000043ff487230ULL, 0x000fe20000004100ULL, 0x00000008ff4e7819ULL, 0x000fc4000001164eULL,
0x00001054605b7816ULL, 0x000fe4000000005bULL, 0x00001054675a7816ULL, 0x000fe2000000005aULL,
0x000000022824723cULL, 0x002fe20000041824ULL, 0x00000081ff42723eULL, 0x000fe400020006ffULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff387819ULL, 0x000fe20000011638ULL,
0x0000005a2018723cULL, 0x000fe20000041818ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff407819ULL, 0x000fc40000011640ULL,
0x00000010ff3f7819ULL, 0x000fe2000001163fULL, 0x20000080ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff037819ULL, 0x000fe4000001164bULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe2000001164aULL, 0x20000063ff577230ULL, 0x000fe20000004100ULL,
0x00000038ff38723eULL, 0x000fc400020006ffULL, 0x0000105440037816ULL, 0x000fe40000000003ULL,
0x000010544c027816ULL, 0x000fe2000000003fULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00000010ff207819ULL, 0x000fe40000011641ULL, 0x00000010ff497819ULL, 0x000fe40000011649ULL,
0x0000105421487816ULL, 0x000fe20000000048ULL, 0x000000022804723cULL, 0x000fe20000041804ULL,
0x00000010ff427819ULL, 0x000fc40000011642ULL, 0x00000010ff217819ULL, 0x000fe4000001164eULL,
0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL, 0x0000105420497816ULL, 0x000fe40000000049ULL,
0x00000008ff3c7819ULL, 0x000fe4000001163cULL, 0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff207819ULL, 0x000fe20000011643ULL, 0x00000048281c723cULL, 0x000fe2000004181cULL,
0x00000008ff447819ULL, 0x000fc40000011644ULL, 0x00000010ff437819ULL, 0x000fe4000001164dULL,
0x0000105421427816ULL, 0x000fe40000000042ULL, 0x00000010ff027819ULL, 0x000fe40000011653ULL,
0x00000010ff217819ULL, 0x000fe40000011657ULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff037819ULL, 0x000fc40000011638ULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x2000003aff3a7230ULL, 0x000fe20000004100ULL, 0x00000066ff5c723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000003cff3c723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000105420437816ULL, 0x000fe20000000043ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000105402217816ULL, 0x000fe20000000021ULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x0000105403207816ULL, 0x000fc40000000054ULL,
0x00000010ff027819ULL, 0x000fe20000011655ULL, 0x000000422808723cULL, 0x040fe20000041808ULL,
0x00000010ff037819ULL, 0x000fe4000001163aULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0x00000010ff517819ULL, 0x000fe40000011651ULL, 0x00000010ff5c7819ULL, 0x000fe2000001165cULL,
0x000000202810723cULL, 0x000fe20000041810ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff217819ULL, 0x000fe4000001163eULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff447819ULL, 0x000fc40000011644ULL,
0x0000105402037816ULL, 0x000fe40000000003ULL, 0x000010544f637816ULL, 0x000fe4000000005cULL,
0x0000105462627816ULL, 0x000fe40000000051ULL, 0x000010543c027816ULL, 0x000fe4000000005dULL,
0x000010545e217816ULL, 0x000fe40000000021ULL, 0x0000105444207816ULL, 0x000fe2000000005fULL,
0x00000062280c723cULL, 0x040ff0000004180cULL, 0x000000022814723cULL, 0x040ff00000041814ULL,
0x000000202818723cULL, 0x000fe20000041818ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0037ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdae000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00f6140032037984ULL, 0x000e620000000800ULL, 0x0000ffff34007812ULL, 0x000fe200078ec0ffULL,
0x0000002531257220ULL, 0x040fe20000410000ULL, 0x0000001c311c7220ULL, 0x040fe20000410000ULL,
0x0000000431227220ULL, 0x040fe20000410000ULL, 0x0000888000387816ULL, 0x000fe200000000ffULL,
0x0000000531217220ULL, 0x040fe20000410000ULL, 0x0000001131117220ULL, 0x040fe20000410000ULL,
0x0000001431147220ULL, 0x040fe20000410000ULL, 0x0000001531157220ULL, 0x040fe20000410000ULL,
0x8000000038007824ULL, 0x000fe200078e00ffULL, 0x0000002431247220ULL, 0x040fe20000410000ULL,
0x0000002631027220ULL, 0x040fe20000410000ULL, 0x0000002731287220ULL, 0x040fe20000410000ULL,
0x0000001d31237220ULL, 0x040fe20000410000ULL, 0x0000001e31297220ULL, 0x040fe20000410000ULL,
0x0000001f312a7220ULL, 0x040fe20000410000ULL, 0x0000000631067220ULL, 0x040fe20000410000ULL,
0x0000000731077220ULL, 0x040fe20000410000ULL, 0x0000000b31047220ULL, 0x040fe20000410000ULL,
0x0000001031107220ULL, 0x040fe20000410000ULL, 0x0000001731057220ULL, 0x040fe20000410000ULL,
0x0000000d311d7220ULL, 0x040fe20000410000ULL, 0x0000000831207220ULL, 0x040fe20000410000ULL,
0x0000000c311e7220ULL, 0x040fe20000410000ULL, 0x00000012310d7220ULL, 0x040fe20000410000ULL,
0x0000001931177220ULL, 0x040fe20000410000ULL, 0x0000001a312b7220ULL, 0x040fe20000410000ULL,
0x0000001b31367220ULL, 0x040fe20000410000ULL, 0x000000ffff267224ULL, 0x000fe200078e0025ULL,
0x00000009311f7220ULL, 0x040fe20000410000ULL, 0x0000000a31087220ULL, 0x040fe20000410000ULL,
0x0000000f310c7220ULL, 0x040fe20000410000ULL, 0x0000001631127220ULL, 0x040fe20000410000ULL,
0x000000ffff257224ULL, 0x000fe200078e001cULL, 0x0000000e310e7220ULL, 0x040fe20000410000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0011ULL, 0x0000001331137220ULL, 0x040fe20000410000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e0014ULL, 0x0000001831187220ULL, 0x000fe20000410000ULL,
0x000000ffff197224ULL, 0x000fe200078e0015ULL, 0x8000000003ff7812ULL, 0x002fe20007804800ULL,
0x000000ffff277224ULL, 0x000fc400078e0024ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0010ULL,
0x000000ffff167224ULL, 0x000fe400078e0002ULL, 0x000000ffff157224ULL, 0x000fe400078e0028ULL,
0x000000ffff147224ULL, 0x000fe400078e0029ULL, 0x000000ffff0b7224ULL, 0x000fe400078e002aULL,
0x000000ffff0a7224ULL, 0x000fc400078e0006ULL, 0x000000ffff097224ULL, 0x000fe400078e0007ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0004ULL, 0x000000ffff117224ULL, 0x000fe200078e0005ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe400078e002bULL, 0x000000ffff037224ULL, 0x000fe200078e0036ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000038057824ULL, 0x000fe400078e00ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x00f6140032027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000430007824ULL, 0x000fe200078e00ffULL,
0x000000355200720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff000057812ULL, 0x000fca00078ec0ffULL, 0x0000008050027824ULL, 0x000fca00078e0205ULL,
0x00f4000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000230247824ULL, 0x000fe400078e00ffULL, 0x0000000146397824ULL, 0x000fc600078e0a39ULL,
0x0000000624247812ULL, 0x000fc800078ec0ffULL, 0x0000000124287812ULL, 0x040fe400078efcffULL,
0x00000008242a7812ULL, 0x000fe400078efcffULL, 0x000000392800720cULL, 0x080fe40003f26070ULL,
0x0000001024287812ULL, 0x000fe400078efcffULL, 0x000000392a00720cULL, 0x080fe40003f06070ULL,
0x000000392800720cULL, 0x000fc40003fc6070ULL, 0x00000011242a7812ULL, 0x040fe400078efcffULL,
0x0000001824287812ULL, 0x040fe400078efcffULL, 0x000000392400720cULL, 0x080fe40003f46070ULL,
0x000000392a00720cULL, 0x080fe40003fa6070ULL, 0x000000392800720cULL, 0x000fe40003f66070ULL,
0x0000000924367812ULL, 0x000fc400078efcffULL, 0x00000019242a7812ULL, 0x040fe400078efcffULL,
0x0000002024287812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fe40005000000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40004800000ULL,
0xff7fffff26267808ULL, 0x000fc40004800000ULL, 0x000000393600720cULL, 0x080fe40003f86070ULL,
0x000000392a00720cULL, 0x080fe40003f46070ULL, 0x000000392800720cULL, 0x000fe40003f26070ULL,
0x00000021242a7812ULL, 0x040fe400078efcffULL, 0x0000002824287812ULL, 0x000fe400078efcffULL,
0xff7fffff14147808ULL, 0x000fc40004000000ULL, 0xff7fffff25257808ULL, 0x000fe40004000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0x000000392a00720cULL, 0x080fe40003f06070ULL, 0x000000392800720cULL, 0x000fe40003f86070ULL,
0x00000029242a7812ULL, 0x000fc400078efcffULL, 0x0000003024287812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0x000000392a00720cULL, 0x000fc40003fc6070ULL, 0x000000392800720cULL, 0x000fe40003fa6070ULL,
0x00000031242a7812ULL, 0x040fe400078efcffULL, 0x0000003824287812ULL, 0x040fe400078efcffULL,
0x0000003924247812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fe40005800000ULL,
0xff7fffff20207808ULL, 0x000fc40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40004800000ULL, 0x000000392a00720cULL, 0x080fe40003f66070ULL,
0x000000392800720cULL, 0x000fc40003f46070ULL, 0x000000392400720cULL, 0x000fe40003f26070ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL,
0xff7fffff13137808ULL, 0x000fc40007000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40007000000ULL,
0xff7fffff12127808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff11117808ULL, 0x000fe40005800000ULL, 0xff7fffff19197808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff03037808ULL, 0x000fe40004800000ULL, 0xff7fffff17177808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002704297209ULL, 0x004fe20007810000ULL,
0x0000001fff367424ULL, 0x000fe200078e00ffULL, 0x0000001605247209ULL, 0x000fe20007810000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x0000002629047209ULL, 0x000fe40007810000ULL,
0x0000001524057209ULL, 0x000fc40007810000ULL, 0x0000002504047209ULL, 0x000fe40007810000ULL,
0x0000001405247209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x0000000b24297209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fe40007810000ULL,
0x0000000a29247209ULL, 0x000fc40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000000924297209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000000829247209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x0000000f24297209ULL, 0x000fc40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e29297209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000c29047209ULL, 0x000fe40007810000ULL, 0x0000001c05247209ULL, 0x000fe40007810000ULL,
0x0000000d04047209ULL, 0x000fc40007810000ULL, 0x0000001b24057209ULL, 0x000fe40007810000ULL,
0x0000001304297209ULL, 0x000fe40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000001229247209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000001124297209ULL, 0x000fc40007810000ULL, 0x0000001805047209ULL, 0x000fe40007810000ULL,
0x0000001029247209ULL, 0x000fe40007810000ULL, 0x0000001704057209ULL, 0x000fe40007810000ULL,
0x0000000324397209ULL, 0x000fe20007810000ULL, 0x00000f127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x00000004053b7209ULL, 0x008fe20007810000ULL,
0x00000f427f007947ULL, 0x000fea000b800000ULL, 0x0c401f0039047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0007247f89ULL, 0x000f2200000e0000ULL,
0x0000000439287209ULL, 0x008fc60007810000ULL, 0x0c201f003b047f89ULL, 0x000ee200000e0000ULL,
0x00000005062a7209ULL, 0x004fc60007810000ULL, 0x0c201f0028057f89ULL, 0x000ea200000e0000ULL,
0x0000002407247209ULL, 0x010fc60007810000ULL, 0x0c201f002a2b7f89ULL, 0x002e6800000e0000ULL,
0x0c201f0024297f89ULL, 0x00092200000e0000ULL, 0x000000043b047209ULL, 0x008fe40007810000ULL,
0x0000000528057209ULL, 0x004fe40007810000ULL, 0x0000002b2a067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04287820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b053a7820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fc40000000000ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b25257823ULL, 0x000fe20000010828ULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b0b0b7823ULL, 0x000fe2000001083aULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010828ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010828ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b19197823ULL, 0x000fe20000010828ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001083aULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001083aULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001083aULL,
0x3fb8aa3b03037823ULL, 0x000fca000001083aULL, 0x00000023002a7308ULL, 0x000ff00000000800ULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ff00000000800ULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000eb00000000800ULL,
0x0000001c00237308ULL, 0x0007f00000000800ULL, 0x0000001a002b7308ULL, 0x0023e20000000800ULL,
0x00000005ff1c7e24ULL, 0x008fe2000f8e00ffULL, 0x000000140b0b723eULL, 0x004fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000067886ULL, 0x000fc400038e0100ULL,
0x3f8000001c1c783eULL, 0x000fe400000010ffULL, 0x0000001800397308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b081a7823ULL, 0x002fe2000001083aULL, 0x000000272608723eULL, 0x000fcc00000010ffULL,
0x0000001700287308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0a187823ULL, 0x004fe2000001083aULL,
0x000000252a0a723eULL, 0x000fcc00000010ffULL, 0x0000001d00077308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b09177823ULL, 0x002fe2000001083aULL, 0x000000161509723eULL, 0x000fcc00000010ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x000000ffff1d7224ULL, 0x004fce00078e001cULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000001900387308ULL, 0x000ff00000000800ULL,
0x0000001700197308ULL, 0x0005f00000000800ULL, 0x0000001800187308ULL, 0x000ee20000000800ULL,
0x0000001c0814723cULL, 0x004fee00000418ffULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0c1d7823ULL, 0x100fe2000001083aULL, 0x00000022210c723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b0d217823ULL, 0x000fca000001083aULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x00000018190d723eULL, 0x008fe200000010ffULL, 0x000000ffff187224ULL, 0x100fe400078e001cULL,
0x000000ffff197224ULL, 0x000fc800078e001cULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000e700000000800ULL, 0x0000001b00367308ULL, 0x0004e20000000800ULL,
0x0000001a0f0f723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b0e1b7823ULL, 0x004fe2000001083aULL,
0x000000201f0e723eULL, 0x000fca00000010ffULL, 0x0000001d00267308ULL, 0x000fe20000000800ULL,
0x0000000fff1f7424ULL, 0x000fe200078e00ffULL, 0x00000023361a723eULL, 0x008fe200000010ffULL,
0x000000180c14723cULL, 0x000fea0000041814ULL, 0x0000001b001b7308ULL, 0x000e700000000800ULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000001300207308ULL, 0x000ea20000000800ULL,
0x0000001b2619723eULL, 0x002fce00000010ffULL, 0x0000001e001e7308ULL, 0x000e620000000800ULL,
0x00000021201b723eULL, 0x004fe200000010ffULL, 0x000000ffff207224ULL, 0x000fcc00078e001cULL,
0x00000012001d7308ULL, 0x0005e20000000800ULL, 0x000000ffff217224ULL, 0x000fe200078e001cULL,
0x0000001e0718723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b10077823ULL, 0x000fe2000001083aULL,
0xfffffffc30107812ULL, 0x000fc800078ec0ffULL, 0x0000001100227308ULL, 0x000e620000000800ULL,
0x000000392812723eULL, 0x004fe400000010ffULL, 0x000000101f1f7219ULL, 0x000fe200000006ffULL,
0x000000201814723cULL, 0x000fe20000041814ULL, 0x0000002b3810723eULL, 0x000fe400000010ffULL,
0x000000001f2673a1ULL, 0x000ea200000e8000ULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x000000001f0573c4ULL, 0x000eee0000004000ULL, 0x00000003001e7308ULL, 0x000f220000000800ULL,
0x0000001d2211723eULL, 0x002fe200000010ffULL, 0x000000ffff1d7224ULL, 0x000fe200078e001cULL,
0x000000061fff7c12ULL, 0x004fc4000f804026ULL, 0x000000071e13723eULL, 0x010fe400000010ffULL,
0x0000002429077209ULL, 0x000fca0007810000ULL, 0x0000001c1020723cULL, 0x000fe80000041814ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000a1205008947ULL, 0x008fde000b800000ULL,
0x001c1fff20147589ULL, 0x0002a400000e0000ULL, 0x000000001f1673a1ULL, 0x000ee200000e8000ULL,
0x000000001f0573c4ULL, 0x000f220000004000ULL, 0x0000000000067886ULL, 0x000fe400038e0100ULL,
0x000000061fff7c12ULL, 0x008fda000f804016ULL, 0x00000a3205008947ULL, 0x010fea000b800000ULL,
0x001c1fff22157589ULL, 0x00072800000e0000ULL, 0x001c1fff16167589ULL, 0x00066800000e0000ULL,
0x001c1fff00177589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x000fe40000011630ULL,
0x0000000c003d7812ULL, 0x002fc400078ec0ffULL, 0x00000007031c7812ULL, 0x040fe200078ec0ffULL,
0x0000000803217824ULL, 0x040fe200078e00ffULL, 0x00000003ff1f7212ULL, 0x008fe200078e33ffULL,
0x00000008031d7824ULL, 0x040fe200078e00ffULL, 0x0000000330ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000803367824ULL, 0x040fe200078e00ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8211e7812ULL, 0x100fe400078ee21cULL, 0x000000011d207812ULL, 0x100fe200078ef61cULL,
0x0000000803487824ULL, 0x000fe200078e00ffULL, 0x000000021d227812ULL, 0x100fe200078ef61cULL,
0x0000000803217824ULL, 0x000fe200078e00ffULL, 0x000000031d247812ULL, 0x000fc400078ef61cULL,
0x000000041d267812ULL, 0x140fe400078ef61cULL, 0x000000051d287812ULL, 0x140fe400078ef61cULL,
0x000000061d2a7812ULL, 0x000fe200078ef61cULL, 0x00000008031d7824ULL, 0x040fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe400078ee21fULL, 0x00000003ff1f7212ULL, 0x000fe400078e33ffULL,
0x00000007031c7812ULL, 0x000fc400078ec0ffULL, 0x0000900050037811ULL, 0x000fe400078e58ffULL,
0xfffffff821387812ULL, 0x100fe400078ee21cULL, 0x000000011d3a7812ULL, 0x140fe200078ef61cULL,
0x000000101e007824ULL, 0x000fe200078e0203ULL, 0xfffffff848487812ULL, 0x000fe200078ee21fULL,
0x00000010221e7824ULL, 0x100fe200078e0203ULL, 0x000000021d3c7812ULL, 0x140fe200078ef61cULL,
0x0000001026227824ULL, 0x100fe200078e0203ULL, 0x000000031d3e7812ULL, 0x140fe200078ef61cULL,
0x000000102a267824ULL, 0x100fe200078e0203ULL, 0x000000041d407812ULL, 0x140fe200078ef61cULL,
0x000000103a2a7824ULL, 0x100fe200078e0203ULL, 0x000000051d427812ULL, 0x140fe200078ef61cULL,
0x000000103c2b7824ULL, 0x100fe200078e0203ULL, 0x000000061d447812ULL, 0x000fe200078ef61cULL,
0x00000010201c7824ULL, 0x000fc400078e0203ULL, 0x0000001024207824ULL, 0x100fe400078e0203ULL,
0x0000001028247824ULL, 0x100fe400078e0203ULL, 0x000000013d1d7824ULL, 0x000fe400078e0200ULL,
0x0000001036287824ULL, 0x100fe400078e0203ULL, 0x0000001038007824ULL, 0x100fe200078e0203ULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x000000103e367824ULL, 0x000fc400078e0203ULL,
0x0000001040387824ULL, 0x100fe400078e0203ULL, 0x0000001042397824ULL, 0x100fe400078e0203ULL,
0x00000010443a7824ULL, 0x100fe400078e0203ULL, 0x00000010483b7824ULL, 0x000fe400078e0203ULL,
0x000000013d037824ULL, 0x040fe400078e021cULL, 0x000000013d1f7824ULL, 0x000fc400078e021eULL,
0x000000013d217824ULL, 0x040fe200078e0220ULL, 0x0000000a03007388ULL, 0x0007e20000000800ULL,
0x000000013d237824ULL, 0x040fe400078e0222ULL, 0x000000013d257824ULL, 0x040fe200078e0224ULL,
0x0000000c1f007388ULL, 0x0007e20000000800ULL, 0x000000013d277824ULL, 0x040fe400078e0226ULL,
0x000000013d297824ULL, 0x040fe200078e0228ULL, 0x0000000e21007388ULL, 0x0007e20000000800ULL,
0x000000013d007824ULL, 0x000fc400078e0200ULL, 0x000000013d2a7824ULL, 0x040fe200078e022aULL,
0x0000001823007388ULL, 0x0007e20000000800ULL, 0x000000013d1c7824ULL, 0x040fe400078e022bULL,
0x000000013d367824ULL, 0x040fe200078e0236ULL, 0x0000001a25007388ULL, 0x0007e20000000800ULL,
0x000000013d387824ULL, 0x040fe400078e0238ULL, 0x000000013d087824ULL, 0x042fe200078e0239ULL,
0x0000001027007388ULL, 0x0007e20000000800ULL, 0x000000013d3a7824ULL, 0x000fc400078e023aULL,
0x000000013d1e7824ULL, 0x000fe200078e023bULL, 0x0000001229007388ULL, 0x0007e80000000800ULL,
0x0000000900007388ULL, 0x0007e80000000800ULL, 0x0000000b2a007388ULL, 0x0007e80000000800ULL,
0x0000000d1c007388ULL, 0x0007e80000000800ULL, 0x0000000f36007388ULL, 0x0007e80000000800ULL,
0x0000001938007388ULL, 0x0007e80000000800ULL, 0x0000001b08007388ULL, 0x0007e80000000800ULL,
0x000000113a007388ULL, 0x0007e80000000800ULL, 0x000000131e007388ULL, 0x0007e80000000800ULL,
0x00f0000402008388ULL, 0x0007e80000000c00ULL, 0x00f2001402008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030052527a10ULL, 0x000fe20007ffe0ffULL,
0x00f6080032ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff34ff7812ULL, 0x000fc4000780c0ffULL,
0x000000455200720cULL, 0x000fe40003f26070ULL, 0x00000001ff347807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffc07000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e002eULL,
0x0001363000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fe400078e0057ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3d7424ULL, 0x000fe400078e00ffULL,
0x000006c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0036ULL,
0xffff9b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x002fe200078e0057ULL,
0x000136b000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe400078e002dULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3d7424ULL, 0x000fe400078e00ffULL,
0x0000064000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x004fe200078e0036ULL,
0xffff9aa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0005ULL,
0x0001371000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2b7424ULL, 0x000fe400078e00ffULL,
0x000005a000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002aULL,
0xfffff0a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0039ULL,
0x0001377000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2b7424ULL, 0x002fe400078e00ffULL,
0x0000054000007944ULL, 0x024fea0003c00000ULL, 0x0000002a39057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0006ULL, 0x000137c000287802ULL, 0x000fe20000000f00ULL,
0x00000002ff2b7424ULL, 0x002fe400078e00ffULL, 0x000004f000007944ULL, 0x000fea0003c00000ULL,
0x0000002a06397209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0007ULL,
0x0001381000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2b7424ULL, 0x002fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000002a07247209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e003bULL, 0x0001386000287802ULL, 0x000fe20000000f00ULL,
0x00000001ff2b7424ULL, 0x002fc400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x0000002a3b047209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0005ULL,
0x000138b000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2b7424ULL, 0x002fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x0000002a05057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0039ULL, 0x0001390000287802ULL, 0x000fe20000000f00ULL,
0x00000001ff2b7424ULL, 0x002fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000002a39067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x0001395000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2b7424ULL, 0x002fc400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e002aULL,
0xffffef5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0020ULL,
0x000139d000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe400078e001fULL,
0x0000032000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0036ULL,
0xfffff58000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x002fe200078e0022ULL,
0x00013a5000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe400078e001fULL,
0x000002a000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff3b7224ULL, 0x002fe200078e00ffULL,
0x00013ab000387802ULL, 0x000fe20000000f00ULL, 0x00001c1fff3c7424ULL, 0x000fc400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe400078e001fULL, 0x000000ffff157224ULL, 0x004fe400078e0036ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff3d7224ULL, 0x002fe200078e001fULL,
0x00013b1000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x004fe400078e0036ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0036ULL,
0xfffff4c000007947ULL, 0x000fea000383ffffULL, 0x0180000008007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000800008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff097807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000009ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff08ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000008087812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000009ff7212ULL, 0x000fda000780c0ffULL, 0x0080000008000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0008ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000800007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x006fe400078e000aULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffec35008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x0c00002b2a2a7389ULL, 0x0002a200000e0036ULL,
0xfffec31028007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff397424ULL, 0x000fe200078e00ffULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x0000003b3a367389ULL, 0x0002a200000e003cULL,
0xfffec2d038007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000200ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000798ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000810ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ebcULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ee0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f10ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f88ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f98ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000013e00ULL, 0xa800001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014f80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014f90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014f90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015410ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014000ULL, 0x0000000000014000ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014f80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015410ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_16_m_16_sm_89_cubin_len = 87280;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
