/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b2b8ULL, 0x000000000001af38ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x00000000000198c0ULL,
0x0000000000000240ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000019b00ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000198c000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x000198c000000000ULL, 0x0000024000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000c0ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000020000dc2804ULL, 0x000009f000000360ULL, 0x00002f2000002eb0ULL, 0x0000313000003000ULL,
0x000033a000003260ULL, 0x0000393000003920ULL, 0x0000395000003940ULL, 0x00005f5000005ec0ULL,
0x0000616000006030ULL, 0x000063d000006290ULL, 0x0000687000006860ULL, 0x0000689000006880ULL,
0x00008dc000008d30ULL, 0x00008fd000008ea0ULL, 0x0000924000009100ULL, 0x0000968000009670ULL,
0x000096a000009690ULL, 0x0000bbe00000bb70ULL, 0x0000be000000bcd0ULL, 0x0000c0700000bf30ULL,
0x0000c5700000c560ULL, 0x0000c5900000c580ULL, 0x0000e0000000dff0ULL, 0x0000e0200000e010ULL,
0x0001810000018050ULL, 0x000184f0000183e0ULL, 0x000189e0000188e0ULL, 0x00018df000018cc0ULL,
0x0000053004303904ULL, 0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000008ULL,
0x00000720003f0100ULL, 0x0001a68800000008ULL, 0x00000860003f0100ULL, 0x0001a6a800000002ULL,
0x00000960003f0100ULL, 0x0001a6c800000004ULL, 0x000013d0003f0100ULL, 0x0001a60000000008ULL,
0x00001560003f0107ULL, 0x0001a68800000003ULL, 0x00001ef0003f0101ULL, 0x00000000000000ffULL,
0x00001f7000040107ULL, 0x00000000000000ffULL, 0x00001ff000040101ULL, 0x0000002000000002ULL,
0x00002100003f0101ULL, 0x0001a6c800000041ULL, 0x00002280003f0109ULL, 0x0001a6c800000041ULL,
0x00002bd0003f0109ULL, 0x0001a6b000000042ULL, 0x00002c20003f0107ULL, 0x0001a6b000000042ULL,
0x00002c30003f0101ULL, 0x0001a60800000080ULL, 0x00002c50003f0101ULL, 0x0001a60800000080ULL,
0x00002dc0003f0109ULL, 0x0001a60800000080ULL, 0x00003530003f0109ULL, 0x0001a6a800000042ULL,
0x000036c0003f0109ULL, 0x0001a6a800000042ULL, 0x00005280003f0109ULL, 0x0001a6c80000003cULL,
0x000052a0003f0101ULL, 0x0001a6880000007dULL, 0x00005320003f0101ULL, 0x0000000000000006ULL,
0x00005490003f0109ULL, 0x0000000000000006ULL, 0x00005c40003f0109ULL, 0x00000000000000ffULL,
0x00005c8000050107ULL, 0x00000000000000ffULL, 0x00005c9000050101ULL, 0x0001a62800000080ULL,
0x00005cb0003f0101ULL, 0x0001a62800000080ULL, 0x00005e20003f0109ULL, 0x0001a62800000080ULL,
0x000065b0003f0109ULL, 0x0001a6b00000003fULL, 0x00006720003f0109ULL, 0x0001a6b00000003fULL,
0x000080b0003f0109ULL, 0x0001a6c80000003cULL, 0x000080e0003f0101ULL, 0x0001a6900000003eULL,
0x00008130003f0101ULL, 0x0000000000000006ULL, 0x000082a0003f0109ULL, 0x0000000000000006ULL,
0x00008a30003f0109ULL, 0x00000008000000ffULL, 0x00008af000040107ULL, 0x0000000800000086ULL,
0x00008b00003f0101ULL, 0x0001a64800000080ULL, 0x00008b20003f0101ULL, 0x0001a64800000080ULL,
0x00008c90003f0109ULL, 0x0001a64800000080ULL, 0x000093f0003f0109ULL, 0x00000000000000ffULL,
0x0000956000050109ULL, 0x00000000000000ffULL, 0x0000aeb000050109ULL, 0x0000000000000006ULL,
0x0000aee0003f0101ULL, 0x0001a6980000003eULL, 0x0000af40003f0101ULL, 0x0000000000000006ULL,
0x0000b0b0003f0109ULL, 0x0000000000000006ULL, 0x0000b8a0003f0109ULL, 0x00000000000000ffULL,
0x0000b93000040107ULL, 0x00000000000000ffULL, 0x0000b94000050101ULL, 0x0001a6680000003fULL,
0x0000b960003f0101ULL, 0x0001a6680000003fULL, 0x0000bad0003f0109ULL, 0x0001a6680000003fULL,
0x0000c240003f0109ULL, 0x0001a6b00000003fULL, 0x0000c3b0003f0109ULL, 0x0001a6b00000003fULL,
0x0000de00003f0109ULL, 0x0000000000000006ULL, 0x0000de40003f0101ULL, 0x0001a6a000000006ULL,
0x00010050003f0101ULL, 0x0001a60000000008ULL, 0x000119a0003f0101ULL, 0x0001a60000000008ULL,
0x00011b60003f0109ULL, 0x0001a60000000008ULL, 0x00011eb0003f0109ULL, 0x0001a60000000008ULL,
0x00011ed0003f0101ULL, 0x0001a60000000008ULL, 0x00012040003f0109ULL, 0x0001a60000000008ULL,
0x00015670003f0109ULL, 0x0001a68800000002ULL, 0x00015a70003f0101ULL, 0x0001a68800000002ULL,
0x00015be0003f0109ULL, 0x0001a68800000002ULL, 0x00019860003f0109ULL, 0x0001a60800000071ULL,
0x00019870003f0101ULL, 0x0001a61000000071ULL, 0x00019880003f0101ULL, 0x0001a61800000071ULL,
0x00019890003f0101ULL, 0x0001a62000000071ULL, 0x00053803003f0101ULL, 0x0000ef4000301c04ULL,
0x0000f2300000ef70ULL, 0x0000f6100000f420ULL, 0x0000f9f00000f800ULL, 0x0000fde00000fbe0ULL,
0x000120700000ff90ULL, 0x000c0504000198b0ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001600080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001500000002ULL, 0x00000000000198c0ULL, 0x0000000000000044ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000727919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff007b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000172052836ULL, 0x008fe40000000000ULL, 0x0000000472062825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x0000000606062981ULL, 0x000ea8000c1e1900ULL,
0x0000000602092981ULL, 0x0006a2000c1e1900ULL, 0x0000000000087306ULL, 0x010f220000209000ULL,
0x00000400ff0a7b82ULL, 0x000f620000000800ULL, 0x000000ff0000720cULL, 0x000fe20003f65070ULL,
0x0000000000767919ULL, 0x000ee20000002600ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x00000000000e7919ULL, 0x000ee40000002300ULL,
0x0000000800087308ULL, 0x010f240000001000ULL, 0x0ffffffe08047836ULL, 0x010fc40000000000ULL,
0x0000000000087919ULL, 0x000f280000002100ULL, 0x0000000400057305ULL, 0x000764000021f000ULL,
0x000000ffff047224ULL, 0x00afe400078e00ffULL, 0x000000ffff0b7224ULL, 0x020fc800078e0a05ULL,
0x000000000b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b05057227ULL, 0x000fe400078e0004ULL,
0x00000000000b7919ULL, 0x000e680000002200ULL, 0x0000000a05057227ULL, 0x000fe200078e00ffULL,
0x00000005ff777819ULL, 0x010fc60000011608ULL, 0x000000ffff037224ULL, 0x000fc600078e0a05ULL,
0x00001fff77777589ULL, 0x000f2200000e0000ULL, 0x0000000300037224ULL, 0x000fca00078e020aULL,
0x000000000300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a00ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000000300720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000000ff05b212ULL, 0x000fc800078e33ffULL,
0x0000000500047306ULL, 0x000ee20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000400047308ULL, 0x008ee40000001000ULL, 0x0ffffffe04027836ULL, 0x008fcc0000000000ULL,
0x0000000200037305ULL, 0x000764000021f000ULL, 0x000000ffff027224ULL, 0x008fe400078e00ffULL,
0x0000000305077224ULL, 0x020fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a07ULL,
0x0000000703037227ULL, 0x000fe400078e0002ULL, 0x00008400ff07ab82ULL, 0x000f280000000800ULL,
0x0000007603797227ULL, 0x000fc800078e00ffULL, 0x000000040e037c24ULL, 0x002fe2000f8e020bULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e0a79ULL,
0x00001fff0e0e7589ULL, 0x000f2200000e0000ULL, 0x0000000403047c24ULL, 0x000fe4000f8e0208ULL,
0x0000000205027224ULL, 0x000fc600078e0276ULL, 0x0000007f0400780cULL, 0x000fe40003fa4070ULL,
0x000000050200720cULL, 0x000fe40003f06070ULL, 0x000000030400780cULL, 0x000fd20003f84070ULL,
0x00000000000ad919ULL, 0x000e640000008800ULL, 0x0000000102020824ULL, 0x000fe400078e0a05ULL,
0x0000000179790836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000050200720cULL, 0x000fda0003f26070ULL, 0x0000000179791836ULL, 0x000fe20000000000ULL,
0x00000005ff79b212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x000000010400780cULL, 0x000fe20003f64070ULL, 0x000000ffff027224ULL, 0x000fc800078e0a79ULL,
0x0000000205767224ULL, 0x000fe400078e0276ULL, 0xff317217ff05d424ULL, 0x000fe400078e00ffULL,
0x0000000109032824ULL, 0x004fe200078e0a06ULL, 0x000004000009d802ULL, 0x000fc80000000f00ULL,
0x000006540a09d816ULL, 0x002fe20000000009ULL, 0x00008400ff03ab82ULL, 0x000ee80000000800ULL,
0x000000040402d824ULL, 0x000fe200078e0209ULL, 0x0000000000240947ULL, 0x010fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400050200d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002076767824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404027c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803057c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a76ULL, 0x000000760500720cULL, 0x000fe20003f06070ULL,
0x000000077206a224ULL, 0x000fc400078e02ffULL, 0x0000000800157c24ULL, 0x000fe2000f8e02ffULL,
0x00000020050b7446ULL, 0x000fe20003800002ULL, 0x000000040e027824ULL, 0x000fe400078e0277ULL,
0x00000015060a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000402027824ULL, 0x000fe400078e00ffULL, 0x0000000879197c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x00000004002c8947ULL, 0x000fea0003800000ULL,
0x0000000800087d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x00000004ff077819ULL, 0x004fca0000011609ULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207107836ULL, 0x000fe40000000000ULL, 0x00000001020f7824ULL, 0x040fe400078e0207ULL,
0x0000000102117824ULL, 0x000fc800078e0210ULL, 0x0000000176127824ULL, 0x000fe400078e0211ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d050d7227ULL, 0x000fc800078e0004ULL, 0x0000000176047824ULL, 0x000fc800078e020fULL,
0x000000040d057227ULL, 0x000fc800078e00ffULL, 0x000000120d0d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e0a05ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0dULL,
0x0000000813087c24ULL, 0x000fe4000f8e0204ULL, 0x00000008170c7c24ULL, 0x000fe4000f8e0212ULL,
0x0000000000177919ULL, 0x000e620000008800ULL, 0x0000000808007c0cULL, 0x000fe4000bf06070ULL,
0x000000080c007c0cULL, 0x000fd6000bf46070ULL, 0x8000000808080c36ULL, 0x000fe40008000000ULL,
0x800000080c0c2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000808007c0cULL, 0x000fe2000bf26070ULL, 0x000000010d0d2836ULL, 0x000fe20000000000ULL,
0x000000080c007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff087c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010d0d3836ULL, 0x000fc60000000000ULL, 0x00000005080c7207ULL, 0x040fe40004000000ULL,
0x0000000d08137207ULL, 0x000fe40004000000ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x000000ffff057224ULL, 0x000fe400078e0a0cULL, 0x000000ffff0d7224ULL, 0x000fe200078e0a13ULL,
0x0000065417087816ULL, 0x002fe20000000008ULL, 0x0000000805047c24ULL, 0x000fe2000f8e0204ULL,
0x000000020b057248ULL, 0x000fe20007fe0000ULL, 0x000000080d127c24ULL, 0x000fc4000f8e0212ULL,
0x00000001190d7824ULL, 0x040fe400078e0204ULL, 0x0000000119127824ULL, 0x000fe400078e0212ULL,
0x0000000105057824ULL, 0x000fe400078e0a02ULL, 0x000000150c047224ULL, 0x000fe400078e020dULL,
0x0000001009027824ULL, 0x000fe200078e00ffULL, 0x000000050700720cULL, 0x000fe20003f06070ULL,
0x00000015130c7224ULL, 0x000fe200078e0212ULL, 0x000000051000720cULL, 0x000fe20003f26070ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f002077812ULL, 0x000fc600078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000704047212ULL, 0x000fc600078efcffULL,
0x000000010f107824ULL, 0x140fe200078e0209ULL, 0x000000070c0c7212ULL, 0x000fe200078efcffULL,
0x000000100f137824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000001110f7824ULL, 0x040fe200078e0209ULL, 0x000000040c0c7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001011127824ULL, 0x000fe200078e00ffULL, 0xfffffff013077812ULL, 0x000fe400078ee210ULL,
0x0000000505057c10ULL, 0x000fe400097fe4ffULL, 0xfffffff0120f7812ULL, 0x000fe200078ee20fULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x000000050d0d7c10ULL, 0x000fc60009ffe4ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000c101c46ULL, 0x000000000c0f7faeULL, 0x0003e2000c901c46ULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x0000000800087d06ULL, 0x000e620008209000ULL,
0x0000000000097919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ee80000008800ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x0000000209077211ULL, 0x004fca00078fe0ffULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x0000000207107836ULL, 0x000fe40000000000ULL, 0x0000000176027824ULL, 0x040fe400078e0207ULL,
0x0000000176087824ULL, 0x000fe400078e0210ULL, 0x0000001007127824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a05ULL, 0x000000080d0d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000d050d7227ULL, 0x000fcc00078e0004ULL, 0x000000020d047227ULL, 0x000fc800078e00ffULL,
0x000000080d0c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x0000000805057c24ULL, 0x000fe4000f8e0202ULL,
0x000000080d0d7c24ULL, 0x000fc6000f8e0208ULL, 0x0000000805007c0cULL, 0x000fe4000bf06070ULL,
0x000000080d007c0cULL, 0x000fd6000bf46070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x800000080d0d2c36ULL, 0x000fe40008000000ULL, 0x0000000104040836ULL, 0x000fe20000000000ULL,
0x0000000805007c0cULL, 0x000fe2000bf26070ULL, 0x000000010c0c2836ULL, 0x000fe20000000000ULL,
0x000000080d007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff057c12ULL, 0x000fce000f8e33ffULL, 0x0000000104041836ULL, 0x000fe40000000000ULL,
0x000000010c0c3836ULL, 0x000fc60000000000ULL, 0x0000000405047207ULL, 0x040fe40004000000ULL,
0x0000000c050c7207ULL, 0x000fc60004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a0cULL, 0x0000000805027c24ULL, 0x000fe4000f8e0202ULL,
0x000000080d087c24ULL, 0x000fe4000f8e0208ULL, 0x0000000119057824ULL, 0x040fe400078e0202ULL,
0x00000001190d7824ULL, 0x000fe200078e0208ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x0000001009027824ULL, 0x000fc400078e00ffULL, 0x0000001504057224ULL, 0x080fe200078e0205ULL,
0x000006540f087816ULL, 0x008fe20000000008ULL, 0x000000150c0d7224ULL, 0x000fe200078e020dULL,
0x000000f002117812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fc800078e00ffULL,
0x000001000d0c7825ULL, 0x000fe200078e00ffULL, 0x0000001104047212ULL, 0x000fc600078efcffULL,
0x00000001070f7824ULL, 0x100fe200078e0209ULL, 0x000000110c0c7212ULL, 0x000fe200078efcffULL,
0x0000000110077824ULL, 0x040fe200078e0209ULL, 0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0xfffffff0120f7812ULL, 0x000fe400078ee20fULL,
0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff010077812ULL, 0x000fe200078ee207ULL,
0x000000100f0f7824ULL, 0x000fe200078e0208ULL, 0x0000000505057c10ULL, 0x000fc400087fe4ffULL,
0x000000050d0d7c10ULL, 0x000fe20008ffe4ffULL, 0x0000001007077824ULL, 0x000fe400078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e8000b901c46ULL,
0x000000000c077faeULL, 0x0003e4000b901c46ULL, 0x00000000080472caULL, 0x000fe200000e0000ULL,
0x00009400ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001a60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000472047825ULL, 0x002fe200078e0004ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000604747981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x0000007f74757836ULL, 0x004fe40000000000ULL,
0x000000ff740c7836ULL, 0x000fc60000000000ULL, 0x00000007ff757819ULL, 0x000fe40000011675ULL,
0x00000008ff707819ULL, 0x000fca000001160cULL, 0x000000e800c08947ULL, 0x000fea0003800000ULL,
0x00000003ff6a7819ULL, 0x000fe20000011677ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x01ffffff6a6a7812ULL, 0x000fc800078ec0ffULL, 0x000000756a00720cULL, 0x000fda0003f06070ULL,
0x00009600ff048b82ULL, 0x000e620000000800ULL, 0x0000000272038824ULL, 0x000fce00078e00ffULL,
0x00009200ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000403038224ULL, 0x002fe400078e0204ULL,
0x00000004ff047424ULL, 0x000fe400078e00ffULL, 0x000000016a058824ULL, 0x000fe400078e0203ULL,
0x0000000877037824ULL, 0x000fe400078e0208ULL, 0x0000000405068825ULL, 0x004fe400078e0006ULL,
0x01a6880403ff79a7ULL, 0x0003e6000850003fULL, 0x0000000606818981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x00000080795a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff717819ULL, 0x000fca0000011677ULL, 0x00000020716b7824ULL, 0x000fe200078e00ffULL,
0x00009000ff047b82ULL, 0x002e620000000a00ULL, 0x0000000081007224ULL, 0x004fc800078e02ffULL,
0x0000008000037824ULL, 0x000fe200078e00ffULL, 0x000000605a007812ULL, 0x000fc600078ef86bULL,
0x0000008003047825ULL, 0x002fe200078e0004ULL, 0x0000000177037812ULL, 0x000fe200078ec0ffULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x0000006b74067248ULL, 0x000fe20007fe0000ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x000fc60000011609ULL,
0x0000000106067824ULL, 0x000fe400078e0a6bULL, 0x00000001030c7824ULL, 0x000fe400078e0207ULL,
0x00000004070e7836ULL, 0x000fe20000000000ULL, 0x0000000306067248ULL, 0x000fe20007fe0000ULL,
0x000000010c0d7824ULL, 0x040fe400078e0209ULL, 0x000000080c127824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fc400078e0a03ULL, 0x0000000c070f7836ULL, 0x000fe20000000000ULL,
0xfffffff812127812ULL, 0x000fe200078ee20dULL, 0x00000008070d7836ULL, 0x000fe20000000000ULL,
0x000000060e00720cULL, 0x080fe20003f46070ULL, 0x00000001030e7824ULL, 0x000fe200078e020eULL,
0x000000060700720cULL, 0x080fe20003f66070ULL, 0x0000000100077824ULL, 0x000fe200078e020cULL,
0x000000060d00720cULL, 0x080fe20003f26070ULL, 0x000000010e0c7824ULL, 0x040fe200078e0209ULL,
0x000000060f00720cULL, 0x000fe20003f06070ULL, 0x000000080e117824ULL, 0x000fc400078e00ffULL,
0x0000008007067825ULL, 0x000fc600078e00ffULL, 0xfffffff811147812ULL, 0x000fe200078ee20cULL,
0x00000001030d7824ULL, 0x040fe200078e020dULL, 0x0000007006117812ULL, 0x000fe200078ef802ULL,
0x0000000103107824ULL, 0x000fe400078e020fULL, 0x00000001000c7824ULL, 0x040fe400078e020dULL,
0x000000010d037824ULL, 0x040fe400078e0209ULL, 0x000000080d167824ULL, 0x000fe400078e00ffULL,
0x00000001000f7824ULL, 0x000fc400078e0210ULL, 0x0000000110067824ULL, 0x040fe200078e0209ULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x00000008100d7824ULL, 0x000fe200078e00ffULL,
0x0000001104107210ULL, 0x000fe20007f9e0ffULL, 0x00000001000e7824ULL, 0x000fe400078e020eULL,
0x0000200071007824ULL, 0x000fe200078e0208ULL, 0xfffffff80d187812ULL, 0x000fe200078ee206ULL,
0x0000000105117824ULL, 0x000fe400020e0607ULL, 0x000000800e067825ULL, 0x000fc800078e00ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x00000070061d7812ULL, 0x000fc600078ef802ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fc600078ef802ULL,
0x0001600000037836ULL, 0x000fe20000000000ULL, 0x000000700e197812ULL, 0x000fe400078ef802ULL,
0x0000001d04027210ULL, 0x000fe20007f9e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0203ULL,
0x0000001b04067210ULL, 0x000fe20007fbe0ffULL, 0x0000001014157824ULL, 0x100fe200078e0203ULL,
0x0000001904047210ULL, 0x000fe20007fde0ffULL, 0x0000001016177824ULL, 0x100fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d901c46ULL,
0x0000001018197824ULL, 0x000fc400078e0203ULL, 0x0000000105037824ULL, 0x040fe400020e0607ULL,
0x0000000105077824ULL, 0x040fe400028e060dULL, 0x0000000105057824ULL, 0x000fe200030e060fULL,
0x0000000002157faeULL, 0x0003e8000d101c46ULL, 0x0000000006177faeULL, 0x0003e8000c901c46ULL,
0x0000000004197faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fca00078e00ffULL, 0x0000000609037211ULL, 0x000fca00078fe8ffULL,
0x0000000103077824ULL, 0x040fe400078e0209ULL, 0x0000000803127824ULL, 0x000fe400078e00ffULL,
0x00000004030c7836ULL, 0x000fe40000000000ULL, 0x0000000100067824ULL, 0x000fe200078e0203ULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010c0d7824ULL, 0x040fe400078e0209ULL,
0x000000080c147824ULL, 0x000fc400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x00000008030d7836ULL, 0x000fe20000000000ULL,
0x0000007006117812ULL, 0x000fe200078ef802ULL, 0x0000000c030e7836ULL, 0x000fe40000000000ULL,
0x00000001000c7824ULL, 0x040fe200078e020cULL, 0x0000001104107210ULL, 0x000fe20007f1e0ffULL,
0x0000000100037824ULL, 0x040fe400078e020dULL, 0x00000001000f7824ULL, 0x000fe400078e020eULL,
0x000000010e067824ULL, 0x000fc400078e0209ULL, 0x000000080e157824ULL, 0x000fe400078e00ffULL,
0x000000010d007824ULL, 0x040fe400078e0209ULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0xfffffff815167812ULL, 0x000fe200078ee206ULL, 0x00002000710d7824ULL, 0x000fe400078e0208ULL,
0x0000000105117824ULL, 0x000fe200000e0607ULL, 0xfffffff813007812ULL, 0x000fe200078ee200ULL,
0x000160000d1d7836ULL, 0x000fc40000000000ULL, 0x000000800c067825ULL, 0x000fc800078e00ffULL,
0x00000080030c7825ULL, 0x000fe200078e00ffULL, 0x00000070061b7812ULL, 0x000fc600078ef802ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c197812ULL, 0x000fc600078ef802ULL,
0x0000001012137824ULL, 0x100fe200078e021dULL, 0x000000700e037812ULL, 0x000fe200078ef802ULL,
0x0000001014157824ULL, 0x100fe200078e021dULL, 0x0000001b04027210ULL, 0x000fe20007f1e0ffULL,
0x0000001000177824ULL, 0x100fe200078e021dULL, 0x0000001904067210ULL, 0x000fe20007f3e0ffULL,
0x0000001016197824ULL, 0x000fe200078e021dULL, 0x0000000304047210ULL, 0x000fe20007f5e0ffULL,
0x0000000105037824ULL, 0x040fe200000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x0000000105077824ULL, 0x000fc400008e060dULL,
0x0000000105057824ULL, 0x000fe200010e060fULL, 0x0000000002157faeULL, 0x0003e8000b901c46ULL,
0x0000000006177faeULL, 0x0003e8000b901c46ULL, 0x0000000004197faeULL, 0x0003e4000b901c46ULL,
0x0001a6a808007836ULL, 0x000fe20000000000ULL, 0x00000000710472caULL, 0x000fe200000e0000ULL,
0x00000001ff037424ULL, 0x002fe200078e00ffULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x000000ffff847224ULL, 0x000fe200078e00ffULL, 0x00000000000572caULL, 0x000fe400000e0000ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000504047291ULL, 0x000fe2000f8e203fULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000ffff317224ULL, 0x000fe400078e00ffULL, 0x0000000871027824ULL, 0x000fe200078e0200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000003ff7e79a7ULL, 0x0002a20008500004ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x0000000000527805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00002003020279a7ULL, 0x002e62000850003fULL,
0x0000000000567805ULL, 0x000fc4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000000bc00948947ULL, 0x000fec0003800000ULL, 0x00009600ff007b82ULL, 0x000ee20000000800ULL,
0x0000000272077824ULL, 0x000fe200078e00ffULL, 0x00000002ff5b7819ULL, 0x000fe20000011677ULL,
0x000000ffff407224ULL, 0x002fe200078e0003ULL, 0x0000000171597812ULL, 0x000fe200078ec0ffULL,
0xff317217ff7a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x0000000007077224ULL, 0x008fce00078e0200ULL,
0x00000000003c7805ULL, 0x010fce0000015200ULL, 0x0000000477067824ULL, 0x000fca00078e00ffULL,
0xfffffff8063f7812ULL, 0x000fca00078ec0ffULL, 0x0000000108417824ULL, 0x000fc800078e023fULL,
0x01a6c840410075a7ULL, 0x000e62000800017fULL, 0x0001a6c841067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff427224ULL, 0x000fce00078e00ffULL,
0x000000104200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000142427836ULL, 0x000fce0000000000ULL,
0x01a6c840410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009000ff3c7b82ULL, 0x000e620000000a00ULL, 0x00000010773e7824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x0000000158417836ULL, 0x000fe40000000000ULL,
0x0000000581817c24ULL, 0x000fe2000f8e02ffULL, 0xffffffe03e3f7812ULL, 0x000fe400078ec0ffULL,
0x000000704100720cULL, 0x000fe20003f26070ULL, 0x0000008081817824ULL, 0x000fe400078e00ffULL,
0x00000100583f7824ULL, 0x000fc800078e023fULL, 0x000000403f437836ULL, 0x000fca0000000000ULL,
0x00000060433f7812ULL, 0x000fe200078ec0ffULL, 0x00000080813c7825ULL, 0x002fc800078e003cULL,
0x000000015a457824ULL, 0x000fe200078e023fULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x000000103e3f7812ULL, 0x000fe400078ec0ffULL, 0x00000043743e7248ULL, 0x000fe40007fe0000ULL,
0x00000003ff427819ULL, 0x000fc60000011609ULL, 0x000000013e3e7824ULL, 0x000fe400078e0a43ULL,
0x0000000142407824ULL, 0x000fe400078e023fULL, 0x0000000842447836ULL, 0x000fe20000000000ULL,
0x0000003f3e3e7248ULL, 0x000fe20007fe0000ULL, 0x0000000140417824ULL, 0x040fe400078e0209ULL,
0x0000000840467824ULL, 0x000fe400078e00ffULL, 0x000000013e3e7824ULL, 0x000fc400078e0a3fULL,
0x0000000c42477836ULL, 0x000fe20000000000ULL, 0xfffffff846467812ULL, 0x000fe200078ee241ULL,
0x0000000442417836ULL, 0x000fe20000000000ULL, 0x0000003e4200720cULL, 0x080fe20003f86070ULL,
0x0000001009437824ULL, 0x000fe200078e00ffULL, 0x0000003e4400720cULL, 0x0c0fe20003f46070ULL,
0x0000000141427824ULL, 0x140fe200078e023fULL, 0x0000003e4100720cULL, 0x080fe20003f66070ULL,
0x0000000144447824ULL, 0x100fe200078e023fULL, 0x0000003e4700720cULL, 0x040fe20003f06070ULL,
0x00000001475c7824ULL, 0x000fe200078e023fULL, 0x0000007043617812ULL, 0x000fe200078ec0ffULL,
0x00000001453e7824ULL, 0x000fc400078e0240ULL, 0x0000000145407824ULL, 0x040fe400078e0242ULL,
0x0000000142437824ULL, 0x140fe400078e0209ULL, 0x00000008425e7824ULL, 0x000fe400078e00ffULL,
0x0000000145427824ULL, 0x040fe400078e0244ULL, 0x0000000145477824ULL, 0x000fe400078e025cULL,
0x0000000144457824ULL, 0x000fc400078e0209ULL, 0x0000000844607824ULL, 0x000fe400078e00ffULL,
0x000000803e3e7825ULL, 0x000fc800078e00ffULL, 0x0000008040407825ULL, 0x000fc800078e00ffULL,
0x000000015c447824ULL, 0x040fe400078e0209ULL, 0x000000085c5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff85e5c7812ULL, 0x000fe400078ee243ULL, 0xfffffff8605e7812ULL, 0x000fe400078ee245ULL,
0x000000613e437212ULL, 0x080fe400078efcffULL, 0x0000006140457212ULL, 0x000fe400078efcffULL,
0x000000433c3e7210ULL, 0x000fe20007fbe0ffULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0xfffffff85d607812ULL, 0x000fc400078ee244ULL, 0x000000453c407210ULL, 0x000fe20007fde0ffULL,
0x0000008047447825ULL, 0x000fe200078e00ffULL, 0x0000006142637212ULL, 0x000fc600078efcffULL,
0x00002000715d7824ULL, 0x000fe200078e0208ULL, 0x0000006144617212ULL, 0x000fe200078efcffULL,
0x000000013d3f7824ULL, 0x040fe200028e063fULL, 0x000000633c427210ULL, 0x000fe20007fbe0ffULL,
0x000170005d477836ULL, 0x000fe40000000000ULL, 0x000000013d417824ULL, 0x000fe200030e0641ULL,
0x000000613c3c7210ULL, 0x000fe20007fde0ffULL, 0x00000010465d7824ULL, 0x100fe400078e0247ULL,
0x000000105c5f7824ULL, 0x000fc400078e0247ULL, 0x000000105e617824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e5d7faeULL, 0x0003e2000e101c46ULL,
0x000000013d437824ULL, 0x040fe400028e0643ULL, 0x0000001060477824ULL, 0x000fe200078e0247ULL,
0x00000000405f7faeULL, 0x0003e2000d901c46ULL, 0x000000013d3d7824ULL, 0x000fc600030e0645ULL,
0x0000000042617faeULL, 0x0003e8000d101c46ULL, 0x000000003c477faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x000000103e3e7812ULL, 0x000fe200078ec0ffULL,
0x0000001009427824ULL, 0x000fc600078e00ffULL, 0x0000003e093e7211ULL, 0x000fe400078fe8ffULL,
0x0000007042617812ULL, 0x000fc600078ec0ffULL, 0x000000043e407836ULL, 0x000fe40000000000ULL,
0x000000013e3f7824ULL, 0x140fe400078e0209ULL, 0x000000083e467824ULL, 0x000fe400078e00ffULL,
0x0000000140417824ULL, 0x040fe400078e0209ULL, 0x00000008405c7824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee23fULL, 0x00000001453f7824ULL, 0x000fc400078e023eULL,
0x000000083e427836ULL, 0x000fe20000000000ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee241ULL,
0x0000000c3e447836ULL, 0x000fe40000000000ULL, 0x000000803f3e7825ULL, 0x000fc800078e00ffULL,
0x0000000145437824ULL, 0x040fe200078e0242ULL, 0x000000613e477212ULL, 0x000fe200078efcffULL,
0x0000000142417824ULL, 0x140fe400078e0209ULL, 0x00000008425e7824ULL, 0x000fe200078e00ffULL,
0x000000473c3e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000145407824ULL, 0x000fe400078e0240ULL,
0x0000000144427824ULL, 0x040fe200078e0209ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee241ULL,
0x00000008445d7824ULL, 0x000fc400078e00ffULL, 0x0000000145457824ULL, 0x000fe400078e0244ULL,
0x0000200071447824ULL, 0x000fe200078e0208ULL, 0xfffffff85d607812ULL, 0x000fe200078ee242ULL,
0x0000008040407825ULL, 0x000fc800078e00ffULL, 0x0001700044677836ULL, 0x000fe20000000000ULL,
0x0000006140657212ULL, 0x000fe200078efcffULL, 0x0000008043427825ULL, 0x000fc800078e00ffULL,
0x0000008045447825ULL, 0x000fe200078e00ffULL, 0x0000006142637212ULL, 0x000fc600078efcffULL,
0x000000013d3f7824ULL, 0x040fe200000e063fULL, 0x0000006144617212ULL, 0x000fe200078efcffULL,
0x0000001046477824ULL, 0x100fe200078e0267ULL, 0x000000653c407210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e0267ULL, 0x000000633c427210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e0267ULL, 0x000000613c3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000013d417824ULL, 0x040fe200000e0641ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e477faeULL, 0x0003e2000b901c46ULL, 0x000000013d437824ULL, 0x000fc400010e0643ULL,
0x0000001060617824ULL, 0x000fe200078e0267ULL, 0x00000000405d7faeULL, 0x0003e2000b901c46ULL,
0x000000013d3d7824ULL, 0x000fc600018e0645ULL, 0x00000000425f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c617faeULL, 0x0003e4000b901c46ULL, 0x000000016a3e7836ULL, 0x002fe40000000000ULL,
0xffffffffff7b7424ULL, 0x000fc600078e00ffULL, 0x000000753e00720cULL, 0x000fda0003f06070ULL,
0x00009200ff3c8b82ULL, 0x000e620000000a00ULL, 0x00000001073f8824ULL, 0x000fe400078e023eULL,
0x00000008773e7824ULL, 0x000fe400078e00ffULL, 0x000000043f3c8825ULL, 0x002fc600078e003cULL,
0xfffffff03e3f7812ULL, 0x040fe400078ec0ffULL, 0x000000103e407812ULL, 0x000fe200078ec0ffULL,
0x000000063c7b8981ULL, 0x000324000c1e1900ULL, 0x0000000108427824ULL, 0x000fe200078e023fULL,
0xffffffe03e3f7812ULL, 0x040fe200078ec0ffULL, 0x00000001ff417424ULL, 0x000fe200078e00ffULL,
0x000000083e807812ULL, 0x000fe400078ec0ffULL, 0x00000000420572caULL, 0x000fc400000e0000ULL,
0x00000008403f7210ULL, 0x000fe20007ffe03fULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x000000013f807824ULL, 0x000fcc00078e0280ULL, 0x0001a6b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x01a6b041428679a7ULL, 0x0002e4000850003fULL, 0x01a60841804079a7ULL, 0x0022a4000850003fULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x01a60841800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a60841800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000001009697824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe20000011609ULL,
0x00000020773c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x0000007069697812ULL, 0x000fe200078ec0ffULL, 0x000000ffff857224ULL, 0x000fe200078e007aULL,
0xffffff803c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c6e6e7812ULL, 0x000fe400078ec0ffULL,
0x00000008693d7210ULL, 0x000fca0007ffe03cULL, 0x000000013d3d7824ULL, 0x000fca00078e026eULL,
0x01a000003d3f7984ULL, 0x000ea80000000800ULL, 0x01a200003d417984ULL, 0x000b620000000800ULL,
0x0000007a3f00720bULL, 0x004fda0003f1d000ULL, 0x00000000003e7806ULL, 0x000fc800000e0100ULL,
0x000000ff3e00720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000775b00720cULL, 0x000fe40003f45270ULL, 0x0000007a3f00720bULL, 0x0c0fe40003f14000ULL,
0x0000007a3f857209ULL, 0x000fd20007810000ULL, 0x00000080773ca824ULL, 0x000fe400078e0208ULL,
0x00000000003d7806ULL, 0x000fc600000e0100ULL, 0x0000003c6e3ca210ULL, 0x000fe40007ffe069ULL,
0x000000ff3d00720cULL, 0x000fc60003f05270ULL, 0x01a400853c00a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007a853c7221ULL, 0x000fe20000010100ULL,
0x000000ff3dff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003dff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b3c3c7820ULL, 0x000fe20000410000ULL, 0x00ff00003dff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003dff7812ULL, 0x000fe2000788c0ffULL, 0x0000003c00437308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff3c7819ULL, 0x002fcc0000011609ULL,
0x00001f3c433c7589ULL, 0x004e6400000e0000ULL, 0x0000003c54547220ULL, 0x082fe20000410000ULL,
0x0000003c55557220ULL, 0x080fe20000410000ULL, 0x0000003c48487220ULL, 0x080fe20000410000ULL,
0x0000003c49497220ULL, 0x080fe20000410000ULL, 0x0000003c4c4c7220ULL, 0x080fe20000410000ULL,
0x0000003c4d4d7220ULL, 0x080fe20000410000ULL, 0x0000003c50507220ULL, 0x080fe20000410000ULL,
0x0000003c51517220ULL, 0x080fe20000410000ULL, 0x0000003c30307220ULL, 0x080fe20000410000ULL,
0x0000003c31317220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008093c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f3c433c7589ULL, 0x004e6400000e0000ULL,
0x0000003c56567220ULL, 0x082fe20000410000ULL, 0x0000003c57577220ULL, 0x080fe20000410000ULL,
0x0000003c4a4a7220ULL, 0x080fe20000410000ULL, 0x0000003c4b4b7220ULL, 0x080fe20000410000ULL,
0x0000003c4e4e7220ULL, 0x080fe20000410000ULL, 0x0000003c4f4f7220ULL, 0x080fe20000410000ULL,
0x0000003c52527220ULL, 0x080fe20000410000ULL, 0x0000003c53537220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010093c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c433c7589ULL, 0x004e6400000e0000ULL, 0x0000003c0c0c7220ULL, 0x082fe20000410000ULL,
0x0000003c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003c10107220ULL, 0x080fe20000410000ULL,
0x0000003c11117220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003c20207220ULL, 0x080fe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c38387220ULL, 0x080fe20000410000ULL,
0x0000003c39397220ULL, 0x080fe20000410000ULL, 0x0000003c34347220ULL, 0x080fe20000410000ULL,
0x0000003c35357220ULL, 0x000fce0000410000ULL, 0x0000004384847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018093c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3c433c7589ULL, 0x000e6400000e0000ULL, 0x0000003c0e0e7220ULL, 0x082fe20000410000ULL,
0x0000003c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003c12127220ULL, 0x080fe20000410000ULL,
0x0000003c13137220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003c22227220ULL, 0x080fe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003c36367220ULL, 0x080fe20000410000ULL,
0x0000003c37377220ULL, 0x000fce0000410000ULL, 0x0000003d3eff7212ULL, 0x000fda00078030ffULL,
0x800000853f3f0221ULL, 0x000fe20000010000ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b3f3f0820ULL, 0x000fc80000410000ULL, 0x0000003f00040308ULL, 0x000ea40000000800ULL,
0x0000000441410220ULL, 0x004fce0000410000ULL, 0x0000008441847221ULL, 0x000fce0000010000ULL,
0x00000000003c7805ULL, 0x002fce0000015200ULL, 0x01a6a87f420075a7ULL, 0x000e62000800017fULL,
0x0001a6a842417836ULL, 0x000fca0000000000ULL, 0x00000000410572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x002fdc0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a6a87f420075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000410572caULL, 0x000fde00000e0000ULL, 0x00000002777d7824ULL, 0x000fe200078e00ffULL,
0x0000000809687812ULL, 0x000fe200078ec0ffULL, 0x00000004773e7824ULL, 0x000fe200078e00ffULL,
0x00009910403c7816ULL, 0x000fe400000000ffULL, 0x000000047d727812ULL, 0x000fe400078ec0ffULL,
0x0000000768687812ULL, 0x000fe400078ef809ULL, 0x00000072093d7211ULL, 0x000fe400078fe0ffULL,
0x0000001068787812ULL, 0x040fe200078efcffULL, 0x0000000868407824ULL, 0x000fe200078e00ffULL,
0x000000ff3c00720cULL, 0x000fe20003f05270ULL, 0x00000001687f7824ULL, 0x000fe200078e023dULL,
0x000000043e3e7812ULL, 0x000fe200078ec0ffULL, 0x00000400773c7824ULL, 0x000fc400078e00ffULL,
0x000000013d7e7824ULL, 0x000fe200078e0278ULL, 0xfffffff8407f7812ULL, 0x000fe200078ee27fULL,
0x00000008783d7824ULL, 0x000fe200078e00ffULL, 0x0000003e096f7211ULL, 0x000fe200078fe0ffULL,
0x0000100077407824ULL, 0x000fe200078e00ffULL, 0xfffff0003c3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000868437824ULL, 0x040fe200078e00ffULL, 0xfffffff83d7e7812ULL, 0x000fe200078ee27eULL,
0x00000001685c7824ULL, 0x000fe200078e026fULL, 0x00012000087a7810ULL, 0x000fe40007ffe03fULL,
0xffffe00040417812ULL, 0x000fc400078ec0ffULL, 0xfffffff8436c7812ULL, 0x000fe200078ee25cULL,
0x000000107f3e7824ULL, 0x100fe200078e027aULL, 0x00016000085d7810ULL, 0x000fe20007ffe041ULL,
0x000000107e447824ULL, 0x000fe200078e027aULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410003c7816ULL, 0x000fe20000000000ULL,
0x00000008033d7836ULL, 0x000fe40000000000ULL, 0x00000018033f7836ULL, 0x000fe40000000000ULL,
0x00001f053c057589ULL, 0x0002a800000e0000ULL, 0x00001f3d3c027589ULL, 0x0002e800000e0000ULL,
0x00001f033c037589ULL, 0x00026800000e0000ULL, 0x00001f3f3c007589ULL, 0x00026400000e0000ULL,
0x000000003e3c783bULL, 0x002e620000000200ULL, 0x000000106c407824ULL, 0x000fc600078e025dULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x088fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000544447232ULL, 0x084fe40000200000ULL, 0x0000000546467232ULL, 0x000fc40000200000ULL,
0x0000000045457232ULL, 0x080fe40000200000ULL, 0x0000000047477232ULL, 0x000fce0000200000ULL,
0x00000008685e7824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x000000025c737836ULL, 0x000fe20000000000ULL, 0x0000000272727812ULL, 0x000fc800078efcffULL,
0xfffffff85e737812ULL, 0x000fca00078ee273ULL, 0x00000010735d7824ULL, 0x000fcc00078e025dULL,
0x000000005d5c783bULL, 0x000f640000004200ULL, 0x000000ff40607812ULL, 0x068fe400078ec0ffULL,
0x00000010ff927819ULL, 0x000fe40000011641ULL, 0x00000060ff64723eULL, 0x000fe400020006ffULL,
0x0000ffff41907812ULL, 0x000fe400078ec0ffULL, 0x0000ffff40917812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe40000011642ULL, 0x00000008ff917819ULL, 0x000fe40000011691ULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x104fe4000001165cULL,
0x000000ff5c957812ULL, 0x000fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fc4000001165cULL,
0x0000ffff5c837812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x00000010ff6d7819ULL, 0x100fe4000001165eULL, 0x000000ff5e617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe4000001165eULL, 0x0000ffff5e827812ULL, 0x000fc400078ec0ffULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff937819ULL, 0x100fe4000001165fULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff817819ULL, 0x000fe4000001165fULL,
0x0000ffff5f7c7812ULL, 0x000fe400078ec0ffULL, 0x00000061ff61723eULL, 0x000fc400020006ffULL,
0x0000005eff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000061ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL, 0x2000005fff617230ULL, 0x000fe20000004100ULL,
0x0000ffff42897812ULL, 0x000fe200078ec0ffULL, 0x20000093ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe40000011690ULL, 0x0000ffff438c7812ULL, 0x000fc400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000091ff90723eULL, 0x000fe200020006ffULL,
0x20000092ff917230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fe40000011643ULL,
0x0000008eff92723eULL, 0x000fe200020006ffULL, 0x20000093ff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011689ULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe2000001168cULL, 0x20000092ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fc40000011640ULL, 0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x00000010ff8d7819ULL, 0x000fe2000001165dULL, 0x20000089ff927230ULL, 0x000fe20000004100ULL,
0x0000ffff5d887812ULL, 0x000fe200078ec0ffULL, 0x20000093ff897230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x000000ff5d967812ULL, 0x000fe400078ec0ffULL,
0x00000094ff5d723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff837819ULL, 0x000fe20000011683ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff41637812ULL, 0x000fc400078ec0ffULL, 0x000000ff8d947812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff81937812ULL, 0x000fe200078ec0ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000008ff817819ULL, 0x000fe40000011682ULL,
0x00000018ff407819ULL, 0x000fe20000011641ULL, 0x20000062ff677230ULL, 0x000fe20000004100ULL,
0x000000ff42657812ULL, 0x000fe400078ec0ffULL, 0x000000ff43667812ULL, 0x000fe400078ec0ffULL,
0x0000008bff8a723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x00000018ff417819ULL, 0x000fe20000011642ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x20000083ff827230ULL, 0x000fe20000004100ULL,
0x00000094ff8b723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000093ff94723eULL, 0x000fe200020006ffULL, 0x20000088ff837230ULL, 0x000fe20000004100ULL,
0x00000018ff427819ULL, 0x000fe20000011643ULL, 0x2000006dff887230ULL, 0x000fe20000004100ULL,
0x00000081ff93723eULL, 0x000fe200020006ffULL, 0x20000094ff817230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fc400020006ffULL, 0x00000066ff43723eULL, 0x000fe200020006ffULL,
0x20000063ff667230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000093ff6d7230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000065ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe2000001168fULL,
0x20000041ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fe2000001167cULL,
0x20000095ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fc40000011667ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000096ff43723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000010ff947819ULL, 0x000fe20000011666ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x000010548f667816ULL, 0x000fc40000000064ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000105493647816ULL, 0x000fe40000000090ULL, 0x00000010ff907819ULL, 0x000fe20000011663ULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff637819ULL, 0x000fe4000001168cULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff8c7819ULL, 0x000fe40000011641ULL, 0x00000010ff417819ULL, 0x000fe40000011689ULL,
0x00000010ff897819ULL, 0x000fe4000001165cULL, 0x0000105463627816ULL, 0x000fc40000000062ULL,
0x000010545d5c7816ULL, 0x000fe40000000082ULL, 0x000010548d637816ULL, 0x000fe40000000090ULL,
0x00000010ff827819ULL, 0x000fe40000011661ULL, 0x00000010ff8f7819ULL, 0x000fe40000011665ULL,
0x00000010ff427819ULL, 0x000fe20000011642ULL, 0x000000623c4c723cULL, 0x002fe2000004184cULL,
0x00000010ff8d7819ULL, 0x000fc40000011643ULL, 0x00000010ff617819ULL, 0x000fe40000011660ULL,
0x00000010ff407819ULL, 0x000fe20000011640ULL, 0x000000624414723cULL, 0x000fe20000041814ULL,
0x00000010ff657819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fe4000001168aULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff837819ULL, 0x000fc40000011683ULL,
0x00000010ff607819ULL, 0x000fe4000001166dULL, 0x00000010ff677819ULL, 0x000fe40000011691ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168bULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff817819ULL, 0x000fc40000011681ULL,
0x00000010ff6d7819ULL, 0x000fe4000001165fULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x0000105442417816ULL, 0x000fe40000000041ULL, 0x0000105440657816ULL, 0x000fe40000000065ULL,
0x0000105443427816ULL, 0x000fe4000000008cULL, 0x000010545e5d7816ULL, 0x000fc40000000083ULL,
0x0000105461607816ULL, 0x000fe20000000060ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x0000105467677816ULL, 0x000fe40000000094ULL, 0x000010548f407816ULL, 0x000fe40000000092ULL,
0x000010548a437816ULL, 0x000fe2000000008dULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x00001054885e7816ULL, 0x000fe40000000089ULL, 0x00001054815f7816ULL, 0x000fc40000000082ULL,
0x000010546d617816ULL, 0x000fe2000000007cULL, 0x000000663c54723cULL, 0x000fec0000041854ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x0000005c4420723cULL, 0x000fe20000041820ULL, 0x00000072093d7211ULL, 0x000fe200078fe0ffULL,
0x00000008683c7824ULL, 0x000fc400078e00ffULL, 0x00000008783f7824ULL, 0x000fe400078e00ffULL,
0x00000001686d7824ULL, 0x100fe200078e023dULL, 0x00000066440c723cULL, 0x000fe2000004180cULL,
0x00000001783d7824ULL, 0x040fe400078e023dULL, 0x00000001785c7824ULL, 0x040fe200078e026fULL,
0xfffffff83c6d7812ULL, 0x000fe200078ee26dULL, 0x00000008783c7824ULL, 0x000fe200078e00ffULL,
0x000000644410723cULL, 0x000fe20000041810ULL, 0x0000200071727824ULL, 0x000fe200078e0208ULL,
0xfffffff83f7c7812ULL, 0x000fc400078ee25cULL, 0xfffffff83c6f7812ULL, 0x000fe200078ee23dULL,
0x000000106d3c7824ULL, 0x100fe200078e027aULL, 0x000000404418723cULL, 0x000fe20000041818ULL,
0x0001600072837836ULL, 0x000fe40000000000ULL, 0x000000106f7a7824ULL, 0x000fe400078e027aULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x00000042441c723cULL, 0x000fe2000004181cULL,
0x000000107c407824ULL, 0x000fca00078e0283ULL, 0x0000005e4438723cULL, 0x000fec0000041838ULL,
0x000000604444723cULL, 0x000fe20000041834ULL, 0x000000007a34783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000008785d7824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x000000025c7a7836ULL, 0x004fe20000000000ULL, 0xfffffff87d7d7812ULL, 0x000fc800078ec0ffULL,
0xfffffff85d7a7812ULL, 0x000fe200078ee27aULL, 0x00000001087d7824ULL, 0x000fc800078e027dULL,
0x000000107a5c7824ULL, 0x000fcc00078e0283ULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x00000010ff907819ULL, 0x120fe40000011640ULL, 0x000000ff40607812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff40927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff937819ULL, 0x000fe40000011641ULL, 0x000000ff41637812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x0000ffff41947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff957819ULL, 0x100fe40000011642ULL, 0x000000ff42667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x0000ffff428e7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8d7819ULL, 0x100fe40000011643ULL, 0x000000ff43677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011643ULL, 0x0000ffff438f7812ULL, 0x000fe400078ec0ffULL,
0x00000060ff64723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x004fc4000001165cULL,
0x000000ff5c657812ULL, 0x040fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff437819ULL, 0x000fe4000001165cULL, 0x0000ffff5c8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x100fe4000001165dULL, 0x000000ff5d977812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fc4000001165dULL, 0x0000ffff5d8b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe4000001165eULL, 0x000000ff5e817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001165eULL, 0x0000ffff5e897812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000010ff887819ULL, 0x100fe4000001165fULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff967819ULL, 0x000fe4000001165fULL,
0x0000ffff5f827812ULL, 0x000fe400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000066ff5d723eULL, 0x000fc400020006ffULL, 0x00000067ff5f723eULL, 0x000fe200020006ffULL,
0x20000062ff677230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000063ff667230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x2000005dff627230ULL, 0x000fe20000004100ULL, 0x00000065ff5d723eULL, 0x000fe200020006ffULL,
0x2000005fff637230ULL, 0x000fe20000004100ULL, 0x00000043ff5f723eULL, 0x000fe200020006ffULL,
0x20000041ff657230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000005dff417230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x2000005fff5d7230ULL, 0x000fe20000004100ULL, 0x00000061ff5f723eULL, 0x000fe200020006ffULL,
0x20000097ff437230ULL, 0x000fe20000004100ULL, 0x00000096ff96723eULL, 0x000fc400020006ffULL,
0x0000005eff97723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff927819ULL, 0x000fe20000011692ULL, 0x20000081ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff90907812ULL, 0x000fe200078ec0ffULL, 0x2000005fff817230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000096ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff967819ULL, 0x000fe20000011694ULL, 0x20000097ff617230ULL, 0x000fe20000004100ULL,
0x000000ff95977812ULL, 0x000fe200078ec0ffULL, 0x20000092ff957230ULL, 0x000fe20000004100ULL,
0x000000ff93937812ULL, 0x000fc400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000008ff927819ULL, 0x000fe4000001168fULL,
0x00000093ff94723eULL, 0x000fe200020006ffULL, 0x20000090ff937230ULL, 0x000fe20000004100ULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000096ff907230ULL, 0x000fe20000004100ULL,
0x00000008ff8e7819ULL, 0x000fe2000001168eULL, 0x20000097ff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000092ff96723eULL, 0x000fe200020006ffULL, 0x2000008dff927230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fc400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x0000008cff8d723eULL, 0x000fe200020006ffULL, 0x20000096ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8a7819ULL, 0x000fe2000001168aULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x000000ff91977812ULL, 0x000fe200078ec0ffULL, 0x2000008eff917230ULL, 0x000fe20000004100ULL,
0x000000ff88967812ULL, 0x000fe200078ec0ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000008ff8b7819ULL, 0x000fe4000001168bULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000097ff8e723eULL, 0x000fe400020006ffULL,
0x00000008ff887819ULL, 0x000fe20000011689ULL, 0x2000008aff897230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000096ff97723eULL, 0x000fc400020006ffULL, 0x000010548f627816ULL, 0x000fe40000000062ULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff8f7819ULL, 0x000fe40000011641ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000008bff8a7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe2000001168cULL,
0x20000060ff8b7230ULL, 0x000fe20000004100ULL, 0x00000088ff96723eULL, 0x000fe200020006ffULL,
0x20000097ff887230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x00000010ff8c7819ULL, 0x000fe2000001168dULL, 0x20000096ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff977819ULL, 0x000fe20000011666ULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x000010548c427816ULL, 0x000fe4000000008fULL, 0x00000010ff8c7819ULL, 0x000fc4000001165dULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff967819ULL, 0x000fe40000011667ULL,
0x0000105494677816ULL, 0x000fe40000000097ULL, 0x00000010ff947819ULL, 0x000fe40000011665ULL,
0x00000010ff8d7819ULL, 0x000fe4000001165cULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff657819ULL, 0x000fe40000011690ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff5d7819ULL, 0x000fe4000001168aULL, 0x000010548c5c7816ULL, 0x000fc40000000089ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff917819ULL, 0x000fc40000011691ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8a7819ULL, 0x000fe4000001168bULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff897819ULL, 0x000fc4000001165fULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x0000105493667816ULL, 0x000fe40000000064ULL,
0x0000105440657816ULL, 0x000fe40000000065ULL, 0x000010545e5d7816ULL, 0x000fe4000000005dULL,
0x00001054885f7816ULL, 0x000fe20000000061ULL, 0x000000663c54723cULL, 0x002fe20000041854ULL,
0x0000105496647816ULL, 0x000fc40000000095ULL, 0x0000105492637816ULL, 0x000fe40000000063ULL,
0x0000105494407816ULL, 0x000fe20000000091ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x000010548e437816ULL, 0x000fe40000000043ULL, 0x000010548a5e7816ULL, 0x000fe4000000008dULL,
0x0000105481607816ULL, 0x000fe20000000060ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x0000105489617816ULL, 0x000fca0000000082ULL, 0x000000623c4c723cULL, 0x000fec000004184cULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x00000066340c723cULL, 0x008fe2000004180cULL, 0x00000008713c7824ULL, 0x000fc400078e0208ULL,
0x00000001ff3e7424ULL, 0x000fc600078e00ffULL, 0x000000643410723cULL, 0x000fe20000041810ULL,
0x01a6c83e3c3c79a7ULL, 0x00026a000850003fULL, 0x000000623414723cULL, 0x000fe20000041814ULL,
0x01a6883e7dff79a7ULL, 0x0003ea000850003fULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000603444723cULL, 0x002fde0000041844ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009000ff8a7b82ULL, 0x000e620000000a00ULL,
0x0000001077347824ULL, 0x000fe200078e00ffULL, 0x0000850000087ab9ULL, 0x000fe40000000800ULL,
0x000000087b7b7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe034357812ULL, 0x000fe400078ec0ffULL,
0x000000807b7b7824ULL, 0x000fc600078e00ffULL, 0x0000010058357824ULL, 0x000fc800078e0235ULL,
0x0000008035377836ULL, 0x000fca0000000000ULL, 0x0000006037357812ULL, 0x000fe200078ec0ffULL,
0x000000807b8a7825ULL, 0x002fc800078e008aULL, 0x000000015a367824ULL, 0x000fe200078e0235ULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x00000010343d7812ULL, 0x000fe400078ec0ffULL,
0x0000003774347248ULL, 0x000fe40007fe0000ULL, 0x00000003ff357819ULL, 0x000fc60000011609ULL,
0x0000000134347824ULL, 0x000fe400078e0a37ULL, 0x0000000135377824ULL, 0x000fe400078e023dULL,
0x00000004353e7836ULL, 0x000fe20000000000ULL, 0x000000343d347248ULL, 0x000fe20007fe0000ULL,
0x00000001373c7824ULL, 0x040fe400078e0209ULL, 0x00000008373f7824ULL, 0x000fe400078e00ffULL,
0x0000000134347824ULL, 0x000fc600078e0a3dULL, 0xfffffff83f407812ULL, 0x000fe200078ee23cULL,
0x000000013e3c7824ULL, 0x040fe200078e023dULL, 0x000000343e00720cULL, 0x080fe20003f66070ULL,
0x00000008353f7836ULL, 0x000fe20000000000ULL, 0x000000343500720cULL, 0x080fe20003f86070ULL,
0x0000000c353e7836ULL, 0x000fe40000000000ULL, 0x0000000137357824ULL, 0x000fe200078e0236ULL,
0x000000343f00720cULL, 0x080fe20003f46070ULL, 0x000000013c377824ULL, 0x000fe200078e0209ULL,
0x000000343e00720cULL, 0x000fe20003f06070ULL, 0x000000083c427824ULL, 0x000fc400078e00ffULL,
0x0000008035347825ULL, 0x000fc600078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee237ULL,
0x000000013f3f7824ULL, 0x100fe200078e023dULL, 0x0000006934377212ULL, 0x000fe200078efcffULL,
0x000000013c3c7824ULL, 0x000fe400078e0236ULL, 0x000000013e5d7824ULL, 0x000fe200078e023dULL,
0x000000378a347210ULL, 0x000fe20007fbe0ffULL, 0x000000013f417824ULL, 0x040fe400078e0209ULL,
0x000000083f5c7824ULL, 0x000fe400078e00ffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee241ULL, 0x000000013f3e7824ULL, 0x100fe200078e0236ULL,
0x000000693c417212ULL, 0x000fe200078efcffULL, 0x000000015d367824ULL, 0x000fe400078e0236ULL,
0x000000803e3e7825ULL, 0x000fc800078e00ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000693e437212ULL, 0x000fc600078efcffULL, 0x000000018b357824ULL, 0x000fe200028e0635ULL,
0x000000418a3c7210ULL, 0x000fe20007fbe0ffULL, 0x000000015d5e7824ULL, 0x040fe200078e0209ULL,
0x0000006936417212ULL, 0x000fe200078efcffULL, 0x000000085d5d7824ULL, 0x000fe400078e00ffULL,
0x000000018b3d7824ULL, 0x040fe200028e063dULL, 0x000000438a3e7210ULL, 0x000fe20007fbe0ffULL,
0x0000001042437824ULL, 0x100fe200078e0283ULL, 0x000000418a367210ULL, 0x000fe20007fde0ffULL,
0x0000001040417824ULL, 0x000fe200078e0283ULL, 0xfffffff85d5e7812ULL, 0x000fe200078ee25eULL,
0x000000018b3f7824ULL, 0x000fc400028e063fULL, 0x000000105c5d7824ULL, 0x000fe200078e0283ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034417faeULL, 0x0003e2000e101c46ULL,
0x000000018b377824ULL, 0x000fe400030e0637ULL, 0x000000105e5f7824ULL, 0x000fe200078e0283ULL,
0x000000003c437faeULL, 0x0003e8000d901c46ULL, 0x000000003e5d7faeULL, 0x0003e8000d101c46ULL,
0x00000000365f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x0000001034347812ULL, 0x000fc800078ec0ffULL, 0x0000003409357211ULL, 0x000fca00078fe8ffULL,
0x00000004353c7836ULL, 0x000fe40000000000ULL, 0x0000000135347824ULL, 0x140fe400078e0209ULL,
0x00000008353f7824ULL, 0x000fe400078e00ffULL, 0x000000013c377824ULL, 0x040fe400078e0209ULL,
0x000000083c427824ULL, 0x000fe200078e00ffULL, 0xfffffff83f407812ULL, 0x000fe200078ee234ULL,
0x00000008353e7836ULL, 0x000fc40000000000ULL, 0x0000000135347824ULL, 0x000fe200078e0236ULL,
0xfffffff842427812ULL, 0x000fe200078ee237ULL, 0x000000013e3d7824ULL, 0x040fe400078e0209ULL,
0x000000083e5c7824ULL, 0x000fe400078e00ffULL, 0x0000000c35377836ULL, 0x000fe40000000000ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff85c5c7812ULL, 0x000fc600078ee23dULL,
0x000000013c3c7824ULL, 0x100fe200078e0236ULL, 0x0000006934417212ULL, 0x000fe200078efcffULL,
0x000000013e3e7824ULL, 0x100fe400078e0236ULL, 0x0000000137367824ULL, 0x040fe200078e0236ULL,
0x000000418a347210ULL, 0x000fe20007f1e0ffULL, 0x0000000137437824ULL, 0x040fe400078e0209ULL,
0x00000008375e7824ULL, 0x000fe400078e00ffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee243ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000693c5d7212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000000693e437212ULL, 0x080fe400078efcffULL, 0x0000005d8a3c7210ULL, 0x000fe20007f5e0ffULL,
0x000000018b357824ULL, 0x040fe200000e0635ULL, 0x0000006936417212ULL, 0x000fe200078efcffULL,
0x000000105c5d7824ULL, 0x000fe200078e0283ULL, 0x000000438a3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000018b3d7824ULL, 0x000fe200010e063dULL, 0x000000418a367210ULL, 0x000fe20007f7e0ffULL,
0x0000001040417824ULL, 0x000fc400078e0283ULL, 0x0000001042437824ULL, 0x000fe400078e0283ULL,
0x000000018b3f7824ULL, 0x040fe200000e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e2000b901c46ULL, 0x000000018b377824ULL, 0x000fe400018e0637ULL,
0x000000105e5f7824ULL, 0x000fe200078e0283ULL, 0x000000003c437faeULL, 0x0003e8000b901c46ULL,
0x000000003e5d7faeULL, 0x0003e8000b901c46ULL, 0x00000000365f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000035ff8879a7ULL, 0x0002a40008500005ULL, 0x01a62835803479a7ULL, 0x0022e4000850003fULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x01a62835800075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e37ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a62835800075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000002077347824ULL, 0x000fe400078e00ffULL, 0x00000001ff3c7424ULL, 0x000fc600078e00ffULL,
0xffffff8034357812ULL, 0x000fc800078ec0ffULL, 0x0000008008347810ULL, 0x000fc80007ffe035ULL,
0x000000346e347210ULL, 0x000fca0007ffe069ULL, 0x01a0000034367984ULL, 0x000ee80000000800ULL,
0x01a2000034357984ULL, 0x0009220000000800ULL, 0x000000853600720bULL, 0x008fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x016fea0003800000ULL, 0x000000015b347836ULL, 0x000fe20000000000ULL,
0x000000853600720bULL, 0x000fc80003f14000ULL, 0x000000773400720cULL, 0x000fda0003f45270ULL,
0x00000080773ca824ULL, 0x000fe200078e0208ULL, 0x000000853634a209ULL, 0x000fc80007810000ULL,
0x0000003c6e3da210ULL, 0x000fe40007ffe069ULL, 0x00000000003c7806ULL, 0x000fc600000e0100ULL,
0x01a400343d00a388ULL, 0x0003e20000000800ULL, 0x000000ff3c00720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x0000008536347209ULL, 0x000fe40007810000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x0000008534347221ULL, 0x000fe20000010100ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff347819ULL, 0x002fcc0000011609ULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000005434547220ULL, 0x042fe20000410000ULL, 0x0000005534557220ULL, 0x040fe20000410000ULL,
0x0000004834487220ULL, 0x040fe20000410000ULL, 0x0000004934497220ULL, 0x040fe20000410000ULL,
0x0000004c344c7220ULL, 0x040fe20000410000ULL, 0x0000004d344d7220ULL, 0x040fe20000410000ULL,
0x0000005034507220ULL, 0x040fe20000410000ULL, 0x0000005134517220ULL, 0x040fe20000410000ULL,
0x0000003034307220ULL, 0x040fe20000410000ULL, 0x0000003134317220ULL, 0x040fe20000410000ULL,
0x0000002c342c7220ULL, 0x040fe20000410000ULL, 0x0000002d342d7220ULL, 0x040fe20000410000ULL,
0x0000002834287220ULL, 0x040fe20000410000ULL, 0x0000002934297220ULL, 0x040fe20000410000ULL,
0x0000002434247220ULL, 0x040fe20000410000ULL, 0x0000002534257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000000809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x004e6400000e0000ULL, 0x0000005634567220ULL, 0x042fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000003234327220ULL, 0x040fe20000410000ULL,
0x0000003334337220ULL, 0x040fe20000410000ULL, 0x0000002e342e7220ULL, 0x040fe20000410000ULL,
0x0000002f342f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000002634267220ULL, 0x040fe20000410000ULL,
0x0000002734277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x0000001009347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000000c340c7220ULL, 0x042fe20000410000ULL, 0x0000000d340d7220ULL, 0x040fe20000410000ULL,
0x0000001034107220ULL, 0x040fe20000410000ULL, 0x0000001134117220ULL, 0x040fe20000410000ULL,
0x0000001434147220ULL, 0x040fe20000410000ULL, 0x0000001534157220ULL, 0x040fe20000410000ULL,
0x0000001834187220ULL, 0x040fe20000410000ULL, 0x0000001934197220ULL, 0x040fe20000410000ULL,
0x0000001c341c7220ULL, 0x040fe20000410000ULL, 0x0000001d341d7220ULL, 0x040fe20000410000ULL,
0x0000002034207220ULL, 0x040fe20000410000ULL, 0x0000002134217220ULL, 0x040fe20000410000ULL,
0x0000003834387220ULL, 0x040fe20000410000ULL, 0x0000003934397220ULL, 0x040fe20000410000ULL,
0x0000004434447220ULL, 0x040fe20000410000ULL, 0x0000004534457220ULL, 0x000fce0000410000ULL,
0x0000003d84847220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x0000001809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x000e6400000e0000ULL,
0x0000000e340e7220ULL, 0x042fe20000410000ULL, 0x0000000f340f7220ULL, 0x040fe20000410000ULL,
0x0000001234127220ULL, 0x040fe20000410000ULL, 0x0000001334137220ULL, 0x040fe20000410000ULL,
0x0000001634167220ULL, 0x040fe20000410000ULL, 0x0000001734177220ULL, 0x040fe20000410000ULL,
0x0000001a341a7220ULL, 0x040fe20000410000ULL, 0x0000001b341b7220ULL, 0x040fe20000410000ULL,
0x0000001e341e7220ULL, 0x040fe20000410000ULL, 0x0000001f341f7220ULL, 0x040fe20000410000ULL,
0x0000002234227220ULL, 0x040fe20000410000ULL, 0x0000002334237220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x040fe20000410000ULL,
0x0000004634467220ULL, 0x040fe20000410000ULL, 0x0000004734477220ULL, 0x000fce0000410000ULL,
0x0000003c37ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000008536857209ULL, 0x000fd60007810000ULL, 0x8000008536360221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000008435847221ULL, 0x000fe20000010000ULL, 0x0000000000347805ULL, 0x002fe20000015200ULL,
0x0000000877367824ULL, 0x000fca00078e00ffULL, 0xfffffff036377812ULL, 0x000fca00078ec0ffULL,
0x00000001083f7824ULL, 0x000fc800078e0237ULL, 0x01a6b0873f0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a6b0873f0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x0000040077357824ULL, 0x040fe400078e00ffULL,
0x0000100077367824ULL, 0x000fe200078e00ffULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0xfffff00035357812ULL, 0x000fe400078ec0ffULL, 0xffffe00036377812ULL, 0x000fe400078ec0ffULL,
0x0001300008827810ULL, 0x000fc40007ffe035ULL, 0x00017000085c7810ULL, 0x000fc60007ffe037ULL,
0x000000107f3c7824ULL, 0x100fe400078e0282ULL, 0x000000107e347824ULL, 0x000fe400078e0282ULL,
0x000000106c407824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000000836027836ULL, 0x000fe20000000000ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00000010363e7836ULL, 0x000fe40000000000ULL, 0x0000001836427836ULL, 0x000fe40000000000ULL,
0x00001f0235027589ULL, 0x0002a800000e0000ULL, 0x00001f3e35057589ULL, 0x0002e800000e0000ULL,
0x00001f3635037589ULL, 0x00026800000e0000ULL, 0x00001f4235007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e680000000200ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000010735c7824ULL, 0x000fe200078e025cULL,
0x000000004040783bULL, 0x000f2a0000004200ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x00000018ff627819ULL, 0x110fe40000011640ULL, 0x00000018ff637819ULL, 0x000fe40000011641ULL,
0x00000010ff917819ULL, 0x000fc40000011640ULL, 0x000000ff40607812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40937812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe40000011641ULL,
0x000000ff41647812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41957812ULL, 0x000fe400078ec0ffULL,
0x000000ff43667812ULL, 0x000fc400078ec0ffULL, 0x00000010ff967819ULL, 0x100fe40000011642ULL,
0x000000ff42657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011642ULL,
0x0000ffff428e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8d7819ULL, 0x100fe40000011643ULL,
0x00000018ff417819ULL, 0x000fc40000011643ULL, 0x0000ffff43907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x128fe4000001165cULL, 0x000000ff5c437812ULL, 0x040fe400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe4000001165cULL, 0x0000ffff5c877812ULL, 0x000fe400078ec0ffULL,
0x00000062ff62723eULL, 0x000fc400020006ffULL, 0x00000010ff927819ULL, 0x100fe4000001165dULL,
0x000000ff5d987812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d8c7812ULL, 0x000fe400078ec0ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000066ff5d723eULL, 0x000fe200020006ffULL, 0x20000062ff667230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000063ff627230ULL, 0x000fe20000004100ULL,
0x000000ff5e7d7812ULL, 0x000fe200078ec0ffULL, 0x2000005dff637230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fc400020006ffULL, 0x00000060ff61723eULL, 0x000fe400020006ffULL,
0x00000018ff7b7819ULL, 0x100fe4000001165eULL, 0x00000098ff98723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe4000001165eULL,
0x0000ffff5e867812ULL, 0x000fe400078ec0ffULL, 0x00000018ff977819ULL, 0x000fc4000001165fULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000042ff5d723eULL, 0x000fe200020006ffULL,
0x20000041ff427230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000043ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x000fe2000001165fULL,
0x20000098ff437230ULL, 0x000fe20000004100ULL, 0x0000ffff5f677812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fc400020006ffULL,
0x0000007bff5f723eULL, 0x000fe400020006ffULL, 0x00000097ff97723eULL, 0x000fe400020006ffULL,
0x0000005eff98723eULL, 0x000fe200020006ffULL, 0x2000005cff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x2000007dff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff937819ULL, 0x000fe20000011693ULL, 0x2000005fff7d7230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000097ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff977819ULL, 0x000fe20000011695ULL, 0x20000098ff7b7230ULL, 0x000fe20000004100ULL,
0x00000093ff95723eULL, 0x000fe200020006ffULL, 0x20000091ff937230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fc400020006ffULL, 0x000000ff96967812ULL, 0x000fe200078ec0ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff917230ULL, 0x000fe20000004100ULL, 0x00000008ff977819ULL, 0x000fe40000011690ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000008ff8e7819ULL, 0x000fe4000001168eULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000096ff907230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fc400020006ffULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000008dff967230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000097ff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x000000ff92987812ULL, 0x000fe200078ec0ffULL,
0x2000008eff927230ULL, 0x000fe20000004100ULL, 0x00000008ff8c7819ULL, 0x000fc4000001168cULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x000000ff81977812ULL, 0x000fe400078ec0ffULL,
0x00000008ff817819ULL, 0x000fe40000011686ULL, 0x0000008fff8e723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x20000087ff867230ULL, 0x000fe20000004100ULL, 0x00000098ff8f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000097ff98723eULL, 0x000fe200020006ffULL,
0x2000008cff877230ULL, 0x000fe20000004100ULL, 0x00000081ff97723eULL, 0x000fe200020006ffULL,
0x20000060ff8c7230ULL, 0x000fe20000004100ULL, 0x00000008ff677819ULL, 0x000fe20000011667ULL,
0x20000098ff817230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000097ff607230ULL, 0x000fe20000004100ULL, 0x00000067ff99723eULL, 0x000fc400020006ffULL,
0x00000010ff977819ULL, 0x000fe20000011666ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe20000011661ULL, 0x20000099ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011693ULL, 0x00000010ff987819ULL, 0x000fe40000011664ULL,
0x00000010ff937819ULL, 0x000fe40000011694ULL, 0x0000105466667816ULL, 0x000fc40000000067ULL,
0x0000105493677816ULL, 0x000fe40000000098ULL, 0x00000010ff937819ULL, 0x000fe40000011665ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x00000010ff657819ULL, 0x000fe20000011691ULL,
0x000000663c54723cULL, 0x002fe20000041854ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x0000105462657816ULL, 0x000fe20000000065ULL,
0x00000066340c723cULL, 0x000fe2000004180cULL, 0x0000105490627816ULL, 0x000fe20000000093ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe40000011641ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff417819ULL, 0x000fc4000001168dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff8d7819ULL, 0x000fe4000001165cULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x000010545d5c7816ULL, 0x000fe40000000086ULL,
0x00000010ff647819ULL, 0x000fc40000011695ULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff917819ULL, 0x000fe40000011643ULL, 0x000010545e5d7816ULL, 0x000fe40000000087ULL,
0x00000010ff957819ULL, 0x000fe40000011640ULL, 0x00000010ff437819ULL, 0x000fe4000001168eULL,
0x000010548c5e7816ULL, 0x000fe2000000008dULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff407819ULL, 0x000fe20000011692ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168fULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff867819ULL, 0x000fc40000011681ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff8c7819ULL, 0x000fe4000001165fULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x0000105443427816ULL, 0x000fe40000000090ULL, 0x0000105497647816ULL, 0x000fc40000000064ULL,
0x0000105496637816ULL, 0x000fe40000000063ULL, 0x0000105495407816ULL, 0x000fe40000000040ULL,
0x000010548e437816ULL, 0x000fe20000000091ULL, 0x000000643c48723cULL, 0x000fe20000041848ULL,
0x00001054865f7816ULL, 0x000fe2000000007bULL, 0x00017000727b7836ULL, 0x000fe20000000000ULL,
0x000010547d607816ULL, 0x000fe40000000060ULL, 0x000010548c617816ULL, 0x000fe20000000061ULL,
0x000000623c4c723cULL, 0x000fe2000004184cULL, 0x000000107c7d7824ULL, 0x000fca00078e027bULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x000000106d3c7824ULL, 0x000fc400078e0282ULL,
0x000000106f827824ULL, 0x000fc600078e0282ULL, 0x000000623414723cULL, 0x000fe20000041814ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fec000004181cULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000603444723cULL, 0x000fe20000041844ULL, 0x000000008234783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x084fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x080fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x000000107a5c7824ULL, 0x000fe200078e027bULL, 0x000000007d40783bULL, 0x000f2a0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000010ff917819ULL, 0x110fe40000011640ULL,
0x000000ff40607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff617819ULL, 0x000fc40000011640ULL,
0x0000ffff40947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff957819ULL, 0x100fe40000011641ULL,
0x000000ff41637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe40000011641ULL,
0x0000ffff41967812ULL, 0x000fe400078ec0ffULL, 0x00000010ff977819ULL, 0x000fc40000011642ULL,
0x000000ff42657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011642ULL,
0x0000ffff428f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff417819ULL, 0x100fe40000011643ULL,
0x00000010ff907819ULL, 0x000fe40000011643ULL, 0x000000ff439a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff43927812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c427812ULL, 0x068fe400078ec0ffULL,
0x00000018ff437819ULL, 0x100fe4000001165cULL, 0x00000060ff66723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fe4000001165cULL, 0x0000ffff5c867812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fc4000001165dULL,
0x000000ff5d997812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x100fe4000001165eULL,
0x000000ff5e817812ULL, 0x000fe400078ec0ffULL, 0x00000018ff827819ULL, 0x000fc4000001165eULL,
0x0000ffff5e877812ULL, 0x000fe400078ec0ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x100fe4000001165fULL, 0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff987819ULL, 0x000fe4000001165fULL, 0x0000ffff5f677812ULL, 0x000fc400078ec0ffULL,
0x00000042ff5d723eULL, 0x000fe200020006ffULL, 0x20000041ff427230ULL, 0x000fe20000004100ULL,
0x00000043ff5f723eULL, 0x000fe400020006ffULL, 0x00000099ff99723eULL, 0x000fe200020006ffULL,
0x2000005dff417230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000005fff5d7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000099ff437230ULL, 0x000fe20000004100ULL, 0x00000008ff947819ULL, 0x000fc40000011694ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000005eff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x0000009aff9a723eULL, 0x000fe200020006ffULL,
0x20000081ff5c7230ULL, 0x000fe20000004100ULL, 0x00000098ff98723eULL, 0x000fe200020006ffULL,
0x2000005fff817230ULL, 0x000fe20000004100ULL, 0x00000008ff997819ULL, 0x000fe40000011696ULL,
0x000000ff95957812ULL, 0x000fe200078ec0ffULL, 0x20000098ff5f7230ULL, 0x000fe20000004100ULL,
0x00000094ff96723eULL, 0x000fc400020006ffULL, 0x00000061ff64723eULL, 0x000fe200020006ffULL,
0x20000063ff617230ULL, 0x000fe20000004100ULL, 0x000000ff91917812ULL, 0x000fe200078ec0ffULL,
0x2000009aff637230ULL, 0x000fe20000004100ULL, 0x00000095ff98723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x000000ff979a7812ULL, 0x000fe200078ec0ffULL,
0x20000096ff977230ULL, 0x000fe20000004100ULL, 0x00000008ff8f7819ULL, 0x000fe2000001168fULL,
0x20000098ff947230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000008ff967819ULL, 0x000fe20000011692ULL,
0x20000091ff957230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x20000099ff917230ULL, 0x000fe20000004100ULL, 0x00000096ff98723eULL, 0x000fe400020006ffULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fc40000011686ULL,
0x000000ff93997812ULL, 0x000fe200078ec0ffULL, 0x2000008fff937230ULL, 0x000fe20000004100ULL,
0x0000008eff8f723eULL, 0x000fe200020006ffULL, 0x20000098ff8e7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fe2000001168dULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x000000ff8c987812ULL, 0x000fc400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe20000011687ULL,
0x20000086ff877230ULL, 0x000fe20000004100ULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000098ff86723eULL, 0x000fe400020006ffULL,
0x0000008cff98723eULL, 0x000fe200020006ffULL, 0x2000008dff8c7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x20000060ff8d7230ULL, 0x000fe20000004100ULL,
0x00000008ff677819ULL, 0x000fe20000011667ULL, 0x20000098ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff947819ULL, 0x000fe20000011694ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000067ff98723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fc40000011661ULL, 0x000000ff90907812ULL, 0x000fe200078ec0ffULL,
0x20000098ff617230ULL, 0x000fe20000004100ULL, 0x0000105494677816ULL, 0x000fe40000000067ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000010ff947819ULL, 0x000fe40000011665ULL,
0x00000010ff657819ULL, 0x000fe20000011691ULL, 0x20000090ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fc40000011641ULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff417819ULL, 0x000fe4000001168eULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fe4000001168fULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fc400020006ffULL,
0x0000009aff9a723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000099ff90723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x0000105442417816ULL, 0x000fe20000000041ULL, 0x2000009aff927230ULL, 0x000fe20000004100ULL,
0x000010548e427816ULL, 0x000fe20000000091ULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe4000001165dULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff997819ULL, 0x000fe40000011664ULL, 0x00000010ff8f7819ULL, 0x000fe4000001165cULL,
0x00000010ff647819ULL, 0x000fe40000011697ULL, 0x000010548e5c7816ULL, 0x000fc40000000087ULL,
0x0000105495667816ULL, 0x000fe40000000066ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff977819ULL, 0x000fe40000011663ULL, 0x00000010ff877819ULL, 0x000fe20000011681ULL,
0x000000663c54723cULL, 0x002fe20000041854ULL, 0x00000010ff957819ULL, 0x000fe40000011640ULL,
0x00000010ff637819ULL, 0x000fc40000011692ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x00000066340c723cULL, 0x004fe2000004180cULL, 0x00000010ff5d7819ULL, 0x000fe4000001168cULL,
0x00000010ff817819ULL, 0x000fe40000011682ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff407819ULL, 0x000fe40000011693ULL, 0x00000010ff437819ULL, 0x000fc40000011643ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168dULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff827819ULL, 0x000fe4000001165fULL, 0x00000010ff617819ULL, 0x000fc40000011661ULL,
0x0000105462657816ULL, 0x000fe40000000065ULL, 0x0000105463627816ULL, 0x000fe40000000094ULL,
0x000010545e5d7816ULL, 0x000fe4000000005dULL, 0x0000105499647816ULL, 0x000fe40000000064ULL,
0x0000105496637816ULL, 0x000fe40000000097ULL, 0x0000105495407816ULL, 0x000fe20000000040ULL,
0x0000005c3c2c723cULL, 0x000fe2000004182cULL, 0x0000105490437816ULL, 0x000fc40000000043ULL,
0x000010548c5e7816ULL, 0x000fe4000000008fULL, 0x00001054865f7816ULL, 0x000fe20000000087ULL,
0x000000643c48723cULL, 0x000fe20000041848ULL, 0x0000105481607816ULL, 0x000fe40000000060ULL,
0x0000105482617816ULL, 0x000fc60000000061ULL, 0x000000623c4c723cULL, 0x000fec000004184cULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000603c24723cULL, 0x000fec0000041824ULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x00000002773c7824ULL, 0x000fc400078e00ffULL,
0x00000001ff3f7424ULL, 0x000fc600078e00ffULL, 0xfffffff83c3d7812ULL, 0x000fe200078ec0ffULL,
0x00000008713c7824ULL, 0x000fe200078e0208ULL, 0x000000623414723cULL, 0x000fe60000041814ULL,
0x00000001083e7824ULL, 0x000fe400078e023dULL, 0x01a6c83f3c3c79a7ULL, 0x000e62000850003fULL,
0x000000403418723cULL, 0x000fec0000041818ULL, 0x00000042341c723cULL, 0x000fe2000004181cULL,
0x01a6903f3eff79a7ULL, 0x0005ea000850003fULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000603444723cULL, 0x000fee0000041844ULL,
0x0000000000347805ULL, 0x000fe20000015200ULL, 0x0000003d060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000010058827824ULL, 0x000fc800078e026bULL, 0x000000c082377836ULL, 0x000fca0000000000ULL,
0x0000006037357812ULL, 0x000fca00078ec0ffULL, 0x000000015a407824ULL, 0x000fe200078e0235ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x0000003774347248ULL, 0x000fe20007fe0000ULL,
0x0000001077357824ULL, 0x000fc800078e00ffULL, 0x0000000134347824ULL, 0x000fe200078e0a37ULL,
0x0000001035377812ULL, 0x000fe400078ec0ffULL, 0x00000003ff357819ULL, 0x000fe40000011609ULL,
0x0000003437347248ULL, 0x000fc60007fe0000ULL, 0x0000000135367824ULL, 0x140fe400078e0237ULL,
0x0000000134347824ULL, 0x100fe400078e0a37ULL, 0x00000004353c7836ULL, 0x000fe40000000000ULL,
0x00000008353d7836ULL, 0x000fe20000000000ULL, 0x000000343500720cULL, 0x080fe20003f86070ULL,
0x0000000c353f7836ULL, 0x000fe20000000000ULL, 0x000000343c00720cULL, 0x080fe20003f66070ULL,
0x0000000136357824ULL, 0x000fe200078e0240ULL, 0x000000343d00720cULL, 0x080fe20003f46070ULL,
0x000000013c3e7824ULL, 0x000fe200078e0237ULL, 0x000000343f00720cULL, 0x000fe20003f06070ULL,
0x00000001363c7824ULL, 0x000fc400078e0209ULL, 0x0000000836417824ULL, 0x000fe400078e00ffULL,
0x0000008035347825ULL, 0x000fc600078e00ffULL, 0xfffffff841427812ULL, 0x000fe200078ee23cULL,
0x000000013d3d7824ULL, 0x000fe400078e0237ULL, 0x000000013e367824ULL, 0x040fe400078e0209ULL,
0x000000083e437824ULL, 0x040fe400078e00ffULL, 0x000000013e3e7824ULL, 0x000fe400078e0240ULL,
0x000000013f5d7824ULL, 0x000fe200078e0237ULL, 0x0000006934377212ULL, 0x000fe200078efcffULL,
0x000000013d417824ULL, 0x040fe200078e0209ULL, 0xfffffff8435c7812ULL, 0x000fe200078ee236ULL,
0x000000083d5e7824ULL, 0x000fe200078e00ffULL, 0x000000378a347210ULL, 0x000fe20007fbe0ffULL,
0x000000803e3e7825ULL, 0x000fc800078e00ffULL, 0x000000013d367824ULL, 0x100fe400078e0240ULL,
0x000000015d3c7824ULL, 0x000fe200078e0240ULL, 0xfffffff85e407812ULL, 0x000fe200078ee241ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000693e417212ULL, 0x000fc600078efcffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000006936437212ULL, 0x000fc600078efcffULL,
0x000000018b357824ULL, 0x000fe200028e0635ULL, 0x000000418a3e7210ULL, 0x000fe20007fbe0ffULL,
0x000000015d5e7824ULL, 0x040fe200078e0209ULL, 0x000000693c417212ULL, 0x000fe200078efcffULL,
0x000000085d5d7824ULL, 0x000fe400078e00ffULL, 0x000000018b3f7824ULL, 0x040fe200028e063fULL,
0x000000438a367210ULL, 0x000fe20007fbe0ffULL, 0x000000105c437824ULL, 0x100fe200078e027bULL,
0x000000418a3c7210ULL, 0x000fe20007fde0ffULL, 0x0000001042417824ULL, 0x000fe200078e027bULL,
0xfffffff85d5e7812ULL, 0x000fe200078ee25eULL, 0x000000018b377824ULL, 0x000fc400028e0637ULL,
0x00000010405d7824ULL, 0x000fe200078e027bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e2000e101c46ULL, 0x000000018b3d7824ULL, 0x000fe400030e063dULL,
0x000000105e5f7824ULL, 0x000fe200078e027bULL, 0x000000003e437faeULL, 0x0003e8000d901c46ULL,
0x00000000365d7faeULL, 0x0003e8000d101c46ULL, 0x000000003c5f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001077347824ULL, 0x000fca00078e00ffULL,
0x0000001034347812ULL, 0x000fc800078ec0ffULL, 0x0000003409347211ULL, 0x000fca00078fe8ffULL,
0x0000000834377836ULL, 0x000fe40000000000ULL, 0x00000004343e7836ULL, 0x000fe40000000000ULL,
0x0000000134357824ULL, 0x140fe400078e0209ULL, 0x0000000834427824ULL, 0x040fe400078e00ffULL,
0x00000001373d7824ULL, 0x040fe400078e0209ULL, 0x00000008375e7824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee235ULL, 0x00000001343c7824ULL, 0x000fc400078e0240ULL,
0x000000013e367824ULL, 0x040fe200078e0209ULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee23dULL,
0x000000083e3f7824ULL, 0x000fe400078e00ffULL, 0x0000000c34357836ULL, 0x000fe40000000000ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff83f5c7812ULL, 0x000fc600078ee236ULL,
0x000000013e3e7824ULL, 0x100fe200078e0240ULL, 0x000000693c417212ULL, 0x000fe200078efcffULL,
0x0000000137347824ULL, 0x100fe400078e0240ULL, 0x0000000135367824ULL, 0x040fe200078e0240ULL,
0x000000418a3c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000135407824ULL, 0x040fe400078e0209ULL,
0x0000000835437824ULL, 0x000fe400078e00ffULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0xfffffff843407812ULL, 0x000fe200078ee240ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000000693e5d7212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006934437212ULL, 0x080fe400078efcffULL, 0x0000005d8a3e7210ULL, 0x000fe20007f5e0ffULL,
0x000000018b3d7824ULL, 0x040fe200000e063dULL, 0x0000006936417212ULL, 0x000fe200078efcffULL,
0x000000105e5d7824ULL, 0x000fe200078e027bULL, 0x000000438a347210ULL, 0x000fe20007f1e0ffULL,
0x000000018b3f7824ULL, 0x000fe200010e063fULL, 0x000000418a367210ULL, 0x000fe20007f7e0ffULL,
0x0000001042417824ULL, 0x000fc400078e027bULL, 0x000000105c437824ULL, 0x000fe400078e027bULL,
0x000000018b357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c417faeULL, 0x0003e2000b901c46ULL, 0x000000018b377824ULL, 0x000fe400018e0637ULL,
0x00000010405f7824ULL, 0x000fe200078e027bULL, 0x000000003e437faeULL, 0x0003e8000b901c46ULL,
0x00000000345d7faeULL, 0x0003e8000b901c46ULL, 0x00000000365f7faeULL, 0x0003e4000b901c46ULL,
0x000000026a6a7836ULL, 0x000fe20000000000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0xffffffffff817424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe40000000000ULL,
0x000000756a00720cULL, 0x000fca0003f06070ULL, 0x00000000ff0079b0ULL, 0x000ff00008000a48ULL,
0x00009200ff348b82ULL, 0x000e620000000a00ULL, 0x000000016a378824ULL, 0x000fe400078e0207ULL,
0x0000000877367824ULL, 0x000fc400078e00ffULL, 0x0000000437348825ULL, 0x002fca00078e0034ULL,
0x0000000634818981ULL, 0x000322000c1e1900ULL, 0xfffffff036377812ULL, 0x000fe200078ec0ffULL,
0x00000001ff3d7424ULL, 0x000fc600078e00ffULL, 0x0001a6a837867810ULL, 0x000fe20007ffe008ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000083d868679a7ULL, 0x0004e2000850003fULL,
0x01a6483d803479a7ULL, 0x002464000850003fULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x01a64835800075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x004fce0000015200ULL,
0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e37ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a64835800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002077347824ULL, 0x000fe400078e00ffULL,
0x00000001ff3c7424ULL, 0x000fc600078e00ffULL, 0xffffff8034357812ULL, 0x000fc800078ec0ffULL,
0x0000010008347810ULL, 0x000fc80007ffe035ULL, 0x000000346e347210ULL, 0x000fca0007ffe069ULL,
0x01a0000034367984ULL, 0x000e680000000800ULL, 0x01a2000034357984ULL, 0x000b620000000800ULL,
0x000000853600720bULL, 0x002fda0003f1d000ULL, 0x0000000000377806ULL, 0x000fc800000e0100ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x00000004009c8947ULL, 0x02cfea0003800000ULL,
0x000000025b347836ULL, 0x000fe20000000000ULL, 0x000000853600720bULL, 0x000fc80003f14000ULL,
0x000000773400720cULL, 0x000fda0003f45270ULL, 0x00000080773ca824ULL, 0x000fe200078e0208ULL,
0x000000853634a209ULL, 0x000fc80007810000ULL, 0x0000003c6e3da210ULL, 0x000fe40007ffe069ULL,
0x00000000003c7806ULL, 0x000fc600000e0100ULL, 0x01a400343d00a388ULL, 0x0003e20000000800ULL,
0x000000ff3c00720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x0000008536347209ULL, 0x000fe40007810000ULL, 0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL, 0x0000008534347221ULL, 0x000fe20000010100ULL,
0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL, 0xff0000003cff7812ULL, 0x000fe2000788c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003d7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc0000011609ULL,
0x00001f343d347589ULL, 0x004e6400000e0000ULL, 0x0000005434547220ULL, 0x042fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002434247220ULL, 0x040fe20000410000ULL,
0x0000002534257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000809347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343d347589ULL, 0x004e6400000e0000ULL,
0x0000005634567220ULL, 0x042fe20000410000ULL, 0x0000005734577220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004e344e7220ULL, 0x040fe20000410000ULL, 0x0000004f344f7220ULL, 0x040fe20000410000ULL,
0x0000005234527220ULL, 0x040fe20000410000ULL, 0x0000005334537220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002634267220ULL, 0x040fe20000410000ULL, 0x0000002734277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001009347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x004e6400000e0000ULL, 0x0000000c340c7220ULL, 0x042fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x000fce0000410000ULL, 0x0000003d84847220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001809347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343d347589ULL, 0x000e6400000e0000ULL, 0x0000000e340e7220ULL, 0x042fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x040fe20000410000ULL, 0x0000003a343a7220ULL, 0x040fe20000410000ULL,
0x0000003b343b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x000fce0000410000ULL, 0x0000003c37ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000008536857209ULL, 0x000fd60007810000ULL,
0x8000008536360221ULL, 0x000fe20000010000ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600040308ULL, 0x000ea40000000800ULL,
0x0000000435350220ULL, 0x004fce0000410000ULL, 0x0000008435847221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x00000089ff0075a7ULL, 0x000e640008000145ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003d36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x00000089ff0075a7ULL, 0x000e640008000145ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000099103c347816ULL, 0x000fe200000000ffULL, 0x0000040077357824ULL, 0x000fe400078e00ffULL,
0x000000106c407824ULL, 0x000fe200078e0283ULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0xfffff00035357812ULL, 0x000fc800078ec0ffULL, 0x0001400008807810ULL, 0x000fca0007ffe035ULL,
0x000000107f3c7824ULL, 0x100fe400078e0280ULL, 0x000000107e347824ULL, 0x000fe200078e0280ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff367819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000000836027836ULL, 0x000fe20000000000ULL,
0x0000541000357816ULL, 0x000fe20000000000ULL, 0x00000010363e7836ULL, 0x000fe40000000000ULL,
0x0000001836427836ULL, 0x000fe40000000000ULL, 0x00001f0235027589ULL, 0x0002a800000e0000ULL,
0x00001f3e35057589ULL, 0x0002e800000e0000ULL, 0x00001f3635037589ULL, 0x00026800000e0000ULL,
0x00001f4235007589ULL, 0x00026400000e0000ULL, 0x000000003c3c783bULL, 0x002e680000000200ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x084fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x00000010735c7824ULL, 0x000fe200078e0283ULL, 0x000000004040783bULL, 0x000f6a0000004200ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x000000ff40607812ULL, 0x028fe400078ec0ffULL,
0x00000010ff927819ULL, 0x000fc40000011640ULL, 0x00000018ff627819ULL, 0x000fe40000011640ULL,
0x0000ffff40907812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x104fe4000001165cULL,
0x000000ff5c967812ULL, 0x040fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe4000001165cULL,
0x0000ffff5c7f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff41657812ULL, 0x000fe400078ec0ffULL,
0x00000060ff64723eULL, 0x000fe400020006ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x000000ff42667812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe4000001165eULL, 0x000000ff5e607812ULL, 0x000fc400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe4000001165eULL, 0x0000ffff5e837812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f5e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x100fe40000011641ULL,
0x00000018ff637819ULL, 0x000fe40000011641ULL, 0x0000ffff41937812ULL, 0x000fc400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe4000001165fULL, 0x00000010ff8f7819ULL, 0x100fe40000011642ULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x0000ffff428a7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fc400020006ffULL,
0x00000010ff887819ULL, 0x000fe4000001165fULL, 0x0000ffff5f7e7812ULL, 0x000fe400078ec0ffULL,
0x00000066ff42723eULL, 0x000fe200020006ffULL, 0x20000065ff667230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000005eff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe20000011690ULL,
0x20000042ff657230ULL, 0x000fe20000004100ULL, 0x00000018ff957819ULL, 0x100fe20000011643ULL,
0x20000060ff5c7230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x2000005fff607230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fc40000011643ULL,
0x000000ff92927812ULL, 0x000fe200078ec0ffULL, 0x20000094ff5f7230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000095ff42723eULL, 0x000fe400020006ffULL,
0x00000008ff957819ULL, 0x000fe40000011693ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff91947812ULL, 0x000fc400078ec0ffULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff438d7812ULL, 0x040fe400078ec0ffULL,
0x00000092ff91723eULL, 0x000fe200020006ffULL, 0x20000090ff927230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe400020006ffULL, 0x0000008fff90723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x000000ff43677812ULL, 0x000fe200078ec0ffULL,
0x20000095ff8f7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x00000094ff93723eULL, 0x000fe400020006ffULL, 0x00000008ff8a7819ULL, 0x000fe4000001168aULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe4000001165dULL, 0x00000008ff947819ULL, 0x000fe2000001168dULL,
0x20000090ff8d7230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x2000008bff907230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5d897812ULL, 0x040fe400078ec0ffULL, 0x00000067ff43723eULL, 0x000fe200020006ffULL,
0x20000062ff677230ULL, 0x000fe20000004100ULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff5d977812ULL, 0x000fe400078ec0ffULL,
0x00000094ff94723eULL, 0x000fc400020006ffULL, 0x000000ff8e957812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x20000094ff8a7230ULL, 0x000fe20000004100ULL, 0x00000040ff5d723eULL, 0x000fe200020006ffULL,
0x20000041ff407230ULL, 0x000fe20000004100ULL, 0x0000008cff8b723eULL, 0x000fe200020006ffULL,
0x20000096ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff897819ULL, 0x000fe20000011689ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000095ff8c723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff957819ULL, 0x000fe40000011667ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x000000ff88947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x000fe20000011693ULL,
0x20000063ff627230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe20000011683ULL,
0x2000007fff837230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fc40000011640ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff407819ULL, 0x000fe4000001168dULL,
0x00000008ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff8d7819ULL, 0x000fe40000011641ULL,
0x00000094ff7f723eULL, 0x000fe400020006ffULL, 0x00000010ff427819ULL, 0x000fc40000011642ULL,
0x00000010ff417819ULL, 0x000fe2000001168aULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000088ff94723eULL, 0x000fe200020006ffULL, 0x20000089ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe2000001168bULL, 0x20000073ff897230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000094ff737230ULL, 0x000fe20000004100ULL,
0x00000097ff43723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000105442417816ULL, 0x000fe20000000041ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff917819ULL, 0x000fc40000011691ULL,
0x000010548a427816ULL, 0x000fe4000000008dULL, 0x00000010ff8a7819ULL, 0x000fe4000001165dULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff5d7819ULL, 0x000fe40000011688ULL, 0x00000010ff947819ULL, 0x000fc40000011666ULL,
0x00000010ff8b7819ULL, 0x000fe4000001165cULL, 0x00000010ff887819ULL, 0x000fe40000011689ULL,
0x0000105491667816ULL, 0x000fe40000000064ULL, 0x00000010ff917819ULL, 0x000fe40000011665ULL,
0x000010548a5c7816ULL, 0x000fe40000000083ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff657819ULL, 0x000fe4000001168fULL, 0x000010545e5d7816ULL, 0x000fe4000000005dULL,
0x00000010ff837819ULL, 0x000fe40000011660ULL, 0x00001054885e7816ULL, 0x000fe4000000008bULL,
0x00000010ff617819ULL, 0x000fe20000011661ULL, 0x0000005c3c2c723cULL, 0x002fe2000004182cULL,
0x00000010ff607819ULL, 0x000fc40000011673ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8c7819ULL, 0x000fc4000001168cULL,
0x00000010ff887819ULL, 0x000fe4000001167fULL, 0x00000010ff737819ULL, 0x000fe4000001165fULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x0000105462657816ULL, 0x000fe40000000065ULL,
0x0000105440627816ULL, 0x000fe40000000091ULL, 0x0000105461607816ULL, 0x000fc40000000060ULL,
0x0000105467677816ULL, 0x000fe40000000094ULL, 0x0000105495647816ULL, 0x000fe40000000092ULL,
0x0000105490637816ULL, 0x000fe40000000063ULL, 0x0000105493407816ULL, 0x000fe2000000008eULL,
0x000000663c54723cULL, 0x000fe20000041854ULL, 0x000010548c437816ULL, 0x000fe40000000043ULL,
0x00001054885f7816ULL, 0x000fc40000000083ULL, 0x0000105473617816ULL, 0x000fe2000000007eULL,
0x000000643c48723cULL, 0x000fe20000041848ULL, 0x0001600072737836ULL, 0x000fca0000000000ULL,
0x000000623c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x000000106d3c7824ULL, 0x000fc400078e0280ULL, 0x000000106f807824ULL, 0x000fc600078e0280ULL,
0x000000643410723cULL, 0x000fe20000041810ULL, 0x000000003c3c783bULL, 0x000e6a0000000200ULL,
0x000000623414723cULL, 0x000fec0000041814ULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x000000107c417824ULL, 0x000fca00078e0273ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000603444723cULL, 0x000fe20000041844ULL,
0x000000008034783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x080fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x088fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x000000107a5c7824ULL, 0x000fe200078e0273ULL,
0x000000004140783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x0000ffff418d7812ULL, 0x024fe400078ec0ffULL, 0x00000010ff907819ULL, 0x000fc40000011640ULL,
0x00000010ff8c7819ULL, 0x000fe40000011642ULL, 0x00000010ff8a7819ULL, 0x108fe4000001165cULL,
0x000000ff5c937812ULL, 0x040fe400078ec0ffULL, 0x00000018ff927819ULL, 0x000fe4000001165cULL,
0x0000ffff5c7f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x000fc4000001165dULL,
0x000000ff5d947812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d807812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x100fe4000001165fULL, 0x00000010ff7e7819ULL, 0x000fc4000001165fULL,
0x000000ff5f617812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f7a7812ULL, 0x000fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff5f723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff40607812ULL, 0x040fe200078ec0ffULL, 0x2000005fff5c7230ULL, 0x000fe20000004100ULL,
0x0000ffff408e7812ULL, 0x000fe200078ec0ffULL, 0x20000091ff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff917819ULL, 0x000fc4000001168dULL, 0x0000ffff42837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011640ULL, 0x0000ffff43897812ULL, 0x000fe400078ec0ffULL,
0x000000ff42647812ULL, 0x000fe400078ec0ffULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x000000ff41637812ULL, 0x000fc400078ec0ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8f7819ULL, 0x100fe40000011641ULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x00000060ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fc4000001168eULL, 0x00000008ff837819ULL, 0x000fe20000011683ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x00000010ff887819ULL, 0x000fe40000011643ULL, 0x000000ff43667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe4000001165eULL, 0x00000018ff607819ULL, 0x000fc4000001165eULL,
0x0000ffff5e7c7812ULL, 0x000fe400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe40000011689ULL, 0x00000064ff42723eULL, 0x000fe400020006ffULL,
0x00000092ff5e723eULL, 0x000fe400020006ffULL, 0x00000090ff8d723eULL, 0x000fc400020006ffULL,
0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x0000008cff90723eULL, 0x000fe200020006ffULL, 0x20000091ff8c7230ULL, 0x000fe20000004100ULL,
0x000000ff8b927812ULL, 0x000fe200078ec0ffULL, 0x20000063ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff657819ULL, 0x000fe40000011643ULL, 0x0000008eff8e723eULL, 0x000fc400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000066ff43723eULL, 0x000fe200020006ffULL,
0x20000062ff667230ULL, 0x000fe20000004100ULL, 0x000000ff88917812ULL, 0x000fe200078ec0ffULL,
0x20000042ff627230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x20000090ff887230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x20000083ff907230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000043ff637230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000089ff837230ULL, 0x000fe20000004100ULL, 0x00000065ff42723eULL, 0x000fe200020006ffULL,
0x20000041ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff7f7819ULL, 0x000fe2000001167fULL,
0x2000008aff897230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000093ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff807819ULL, 0x000fe20000011680ULL,
0x20000092ff8a7230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000091ff8b7230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x00000010ff927819ULL, 0x000fe40000011664ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x000fe4000001168eULL, 0x000000ff7e917812ULL, 0x000fe200078ec0ffULL,
0x2000007fff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe20000011663ULL,
0x20000080ff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000072ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff7c7819ULL, 0x000fc4000001167cULL,
0x00000008ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff637819ULL, 0x000fe40000011688ULL,
0x00000010ff887819ULL, 0x000fe40000011641ULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff417819ULL, 0x000fe40000011683ULL, 0x00000040ff40723eULL, 0x000fc400020006ffULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000094ff43723eULL, 0x000fe200020006ffULL,
0x20000091ff727230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fc400020006ffULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff837819ULL, 0x000fe2000001165eULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x0000105442417816ULL, 0x000fe20000000041ULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165dULL, 0x0000105489427816ULL, 0x000fc40000000088ULL,
0x00000010ff5d7819ULL, 0x000fe4000001167fULL, 0x00000010ff887819ULL, 0x000fe4000001165cULL,
0x00000010ff7f7819ULL, 0x000fe40000011680ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff917819ULL, 0x000fe40000011666ULL, 0x00000010ff667819ULL, 0x000fc4000001168dULL,
0x000010545e5d7816ULL, 0x000fe4000000005dULL, 0x00000010ff8d7819ULL, 0x000fe40000011665ULL,
0x000010547f5e7816ULL, 0x000fe40000000088ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x00000010ff657819ULL, 0x000fe4000001168cULL, 0x00001054835c7816ULL, 0x000fe4000000007eULL,
0x00000010ff7f7819ULL, 0x000fe40000011660ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x0000005c3c2c723cULL, 0x002fe2000004182cULL,
0x00000010ff8f7819ULL, 0x000fc4000001168fULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff607819ULL, 0x000fe4000001167cULL, 0x00000010ff837819ULL, 0x000fc4000001165fULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x0000105466667816ULL, 0x000fe40000000067ULL,
0x0000105440657816ULL, 0x000fe40000000065ULL, 0x0000105463627816ULL, 0x000fe40000000062ULL,
0x00001054725f7816ULL, 0x000fe40000000061ULL, 0x000010548f677816ULL, 0x000fc40000000092ULL,
0x0000105491647816ULL, 0x000fe40000000064ULL, 0x000010548b637816ULL, 0x000fe2000000008eULL,
0x0000005e3c28723cULL, 0x000fe20000041828ULL, 0x000010548d407816ULL, 0x000fe40000000090ULL,
0x000010548a437816ULL, 0x000fe40000000043ULL, 0x000010547f607816ULL, 0x000fe20000000060ULL,
0x000000663c54723cULL, 0x000fe20000041854ULL, 0x0000105483617816ULL, 0x000fca000000007aULL,
0x000000643c48723cULL, 0x000fec0000041848ULL, 0x000000623c4c723cULL, 0x000fec000004184cULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x000000603c24723cULL, 0x000fec0000041824ULL, 0x00000066340c723cULL, 0x000fe2000004180cULL,
0x00000002773c7824ULL, 0x000fc400078e00ffULL, 0x00000001ff3f7424ULL, 0x000fc600078e00ffULL,
0xfffffff83c3d7812ULL, 0x000fe200078ec0ffULL, 0x000000643410723cULL, 0x000fe80000041810ULL,
0x00000001083e7824ULL, 0x000fe400078e023dULL, 0x0000003f063c79a7ULL, 0x000262000850003fULL,
0x000000623414723cULL, 0x000fec0000041814ULL, 0x000000403418723cULL, 0x000fe20000041818ULL,
0x01a6983f3eff79a7ULL, 0x0003ea000850003fULL, 0x00000042341c723cULL, 0x000fec000004181cULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000603444723cULL, 0x002fde0000041844ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000158357836ULL, 0x000fca0000000000ULL,
0x000000703500720cULL, 0x000fda0003f06070ULL, 0x0000000400e80947ULL, 0x000fea0003800000ULL,
0x00009000ff347b82ULL, 0x000e620000000a00ULL, 0x0000000258377836ULL, 0x000fe20000000000ULL,
0x0000850000087ab9ULL, 0x000fe20000000800ULL, 0x00000100823d7836ULL, 0x000fe40000000000ULL,
0x0000000881367c24ULL, 0x010fe2000f8e02ffULL, 0x000000703700720cULL, 0x000fe40003f06070ULL,
0x000000603d377812ULL, 0x000fe200078ec0ffULL, 0x00000080363f7824ULL, 0x000fc800078e00ffULL,
0x000000015a407824ULL, 0x000fe400078e0237ULL, 0x000000803f347825ULL, 0x002fc800078e0034ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x0000003d74367248ULL, 0x000fe20007fe0000ULL,
0x0000001077377824ULL, 0x000fe200078e00ffULL, 0x00000003ff3c7819ULL, 0x000fc60000011609ULL,
0x0000000136367824ULL, 0x000fe200078e0a3dULL, 0x0000001037377812ULL, 0x000fe200078ec0ffULL,
0x000000043c3e7836ULL, 0x000fe40000000000ULL, 0x000000083c3f7836ULL, 0x000fe20000000000ULL,
0x0000003637367248ULL, 0x000fe20007fe0000ULL, 0x0000000c3c427836ULL, 0x000fe40000000000ULL,
0x000000013c3d7824ULL, 0x100fe400078e0237ULL, 0x0000000136367824ULL, 0x000fc400078e0a37ULL,
0x000000013f417824ULL, 0x100fe400078e0237ULL, 0x00000001425d7824ULL, 0x100fe200078e0237ULL,
0x000000363e00720cULL, 0x0c0fe20003f66070ULL, 0x000000013e3e7824ULL, 0x000fe200078e0237ULL,
0x000000363c00720cULL, 0x080fe20003f86070ULL, 0x000000013d3c7824ULL, 0x000fe200078e0240ULL,
0x000000363f00720cULL, 0x080fe20003f46070ULL, 0x000000083d3f7824ULL, 0x040fe200078e00ffULL,
0x000000364200720cULL, 0x000fe20003f06070ULL, 0x000000013d367824ULL, 0x000fc400078e0209ULL,
0x000000013e377824ULL, 0x140fe400078e0209ULL, 0x000000083e5c7824ULL, 0x040fe200078e00ffULL,
0xfffffff83f427812ULL, 0x000fe200078ee236ULL, 0x000000013e3e7824ULL, 0x000fe400078e0240ULL,
0x00000001413d7824ULL, 0x040fe200078e0209ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee237ULL,
0x00000008415e7824ULL, 0x000fe400078e00ffULL, 0x000000803e3e7825ULL, 0x000fc600078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee23dULL, 0x000000803c3c7825ULL, 0x000fc800078e00ffULL,
0x0000000141367824ULL, 0x100fe200078e0240ULL, 0x000000693e417212ULL, 0x080fe200078efcffULL,
0x000000015d407824ULL, 0x000fe200078e0240ULL, 0x000000693c437212ULL, 0x000fe200078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x00000041343e7210ULL, 0x000fe40007fde0ffULL,
0x00000043343c7210ULL, 0x000fe20007fbe0ffULL, 0x0000008040407825ULL, 0x000fc800078e00ffULL,
0x000000015d5f7824ULL, 0x040fe200078e0209ULL, 0x0000006940437212ULL, 0x080fe200078efcffULL,
0x000000085d607824ULL, 0x000fe200078e00ffULL, 0x00000069365d7212ULL, 0x000fe200078efcffULL,
0x00000001353d7824ULL, 0x040fe400028e063dULL, 0x00000001353f7824ULL, 0x000fe200030e063fULL,
0x0000005d34367210ULL, 0x000fe20007fbe0ffULL, 0x000000105c617824ULL, 0x100fe200078e0273ULL,
0xfffffff860607812ULL, 0x000fe200078ee25fULL, 0x00000010425f7824ULL, 0x100fe200078e0273ULL,
0x0000004334347210ULL, 0x000fe20007fde0ffULL, 0x000000105e437824ULL, 0x000fc400078e0273ULL,
0x0000000135377824ULL, 0x040fe200028e0637ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c5f7faeULL, 0x0003e2000e101c46ULL, 0x0000001060737824ULL, 0x000fe400078e0273ULL,
0x0000000135357824ULL, 0x000fe200030e0641ULL, 0x000000003e617faeULL, 0x0003e8000d901c46ULL,
0x0000000036437faeULL, 0x0003e8000d101c46ULL, 0x0000000034737faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001077367824ULL, 0x000fca00078e00ffULL,
0x0000001036367812ULL, 0x000fc800078ec0ffULL, 0x0000003609377211ULL, 0x000fca00078fe8ffULL,
0x0000000137367824ULL, 0x040fe400078e0240ULL, 0x00000001373c7824ULL, 0x040fe400078e0209ULL,
0x00000008373f7824ULL, 0x000fe400078e00ffULL, 0x00000004373d7836ULL, 0x000fe40000000000ULL,
0x0000000837417836ULL, 0x000fe20000000000ULL, 0xfffffff83f427812ULL, 0x000fe200078ee23cULL,
0x0000000c375c7836ULL, 0x000fc40000000000ULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000013d3c7824ULL, 0x140fe400078e0240ULL, 0x000000013d3f7824ULL, 0x140fe400078e0209ULL,
0x000000083d5e7824ULL, 0x000fe200078e00ffULL, 0x00000069363d7212ULL, 0x000fe200078efcffULL,
0x00000001413e7824ULL, 0x040fe400078e0240ULL, 0x0000000141437824ULL, 0x040fe200078e0209ULL,
0x0000003d34367210ULL, 0x000fe20007f1e0ffULL, 0x0000000841607824ULL, 0x000fc400078e00ffULL,
0x000000015c417824ULL, 0x040fe400078e0209ULL, 0x000000085c627824ULL, 0x040fe400078e00ffULL,
0x000000015c407824ULL, 0x000fe200078e0240ULL, 0xfffffff85e5c7812ULL, 0x000fe200078ee23fULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff8605e7812ULL, 0x000fe400078ee243ULL,
0xfffffff862607812ULL, 0x000fe200078ee241ULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000693c5f7212ULL, 0x000fc600078efcffULL, 0x0000008040407825ULL, 0x000fe200078e00ffULL,
0x000000693e5d7212ULL, 0x000fc600078efcffULL, 0x0000000135377824ULL, 0x040fe200000e0637ULL,
0x0000006940437212ULL, 0x000fe200078efcffULL, 0x0000001042617824ULL, 0x100fe200078e0273ULL,
0x0000005f343c7210ULL, 0x000fe20007f1e0ffULL, 0x000000105c637824ULL, 0x100fe200078e0273ULL,
0x0000005d343e7210ULL, 0x000fe20007f5e0ffULL, 0x000000105e657824ULL, 0x000fe200078e0273ULL,
0x0000004334347210ULL, 0x000fe20007f7e0ffULL, 0x00000001353d7824ULL, 0x040fe200000e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036617faeULL, 0x0003e2000b901c46ULL,
0x00000001353f7824ULL, 0x000fc400010e063fULL, 0x0000001060737824ULL, 0x000fe200078e0273ULL,
0x000000003c637faeULL, 0x0003e2000b901c46ULL, 0x0000000135357824ULL, 0x000fc600018e0641ULL,
0x000000003e657faeULL, 0x0003e8000b901c46ULL, 0x0000000034737faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000877357824ULL, 0x000fe400078e00ffULL,
0x000000205b347824ULL, 0x000fe200078e0208ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000835357812ULL, 0x000fe200078ec0ffULL,
0x0000001059347824ULL, 0x000fe200078e0234ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000001353f7824ULL, 0x000fe200078e0234ULL, 0x0000003cff7e79a7ULL, 0x0002a60008500005ULL,
0x01a6683c3f3c79a7ULL, 0x0022e6000850003fULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x01a6683d3f0075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x0000003634417210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000004136367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a6683d3f0075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000805b347824ULL, 0x000fe400078e0208ULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff7a7224ULL, 0x000fe200078e0085ULL,
0x0000018069357810ULL, 0x000fca0007ffe034ULL, 0x000000016e357824ULL, 0x000fca00078e0235ULL,
0x01a0000035347984ULL, 0x000ee80000000800ULL, 0x01a2000035377984ULL, 0x000b620000000800ULL,
0x000000853400720bULL, 0x008fda0003f1d000ULL, 0x00000000003d7806ULL, 0x000fc800000e0100ULL,
0x000000ff3d00720cULL, 0x000fda0003f05270ULL, 0x0000000400948947ULL, 0x026fea0003800000ULL,
0x000000035b367836ULL, 0x000fe20000000000ULL, 0x000000853400720bULL, 0x0c0fe40003f14000ULL,
0x00000085347a7209ULL, 0x000fe40007810000ULL, 0x000000773600720cULL, 0x000fd20003f45270ULL,
0x0000000000367806ULL, 0x000fc800000e0100ULL, 0x000000807735a824ULL, 0x000fe200078e0208ULL,
0x000000ff3600720cULL, 0x000fc80003f05270ULL, 0x000000356e35a210ULL, 0x000fca0007ffe069ULL,
0x01a4007a3500a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x000000857a357221ULL, 0x002fe20000010100ULL, 0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0036ff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b35357820ULL, 0x000fe20000410000ULL,
0x00ff000036ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000036ff7812ULL, 0x000fe2000788c0ffULL,
0x00000035003f7308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff3c7819ULL, 0x000fca0000011609ULL, 0x00001f3c3f357589ULL, 0x006e6400000e0000ULL,
0x0000005435547220ULL, 0x042fe20000410000ULL, 0x0000005535557220ULL, 0x040fe20000410000ULL,
0x0000004835487220ULL, 0x040fe20000410000ULL, 0x0000004935497220ULL, 0x040fe20000410000ULL,
0x0000004c354c7220ULL, 0x040fe20000410000ULL, 0x0000004d354d7220ULL, 0x040fe20000410000ULL,
0x0000005035507220ULL, 0x040fe20000410000ULL, 0x0000005135517220ULL, 0x040fe20000410000ULL,
0x0000003035307220ULL, 0x040fe20000410000ULL, 0x0000003135317220ULL, 0x040fe20000410000ULL,
0x0000002c352c7220ULL, 0x040fe20000410000ULL, 0x0000002d352d7220ULL, 0x040fe20000410000ULL,
0x0000002835287220ULL, 0x040fe20000410000ULL, 0x0000002935297220ULL, 0x040fe20000410000ULL,
0x0000002435247220ULL, 0x040fe20000410000ULL, 0x0000002535257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x00000008093c7811ULL, 0x000fca00078ff0ffULL,
0x00001f3c3f357589ULL, 0x006e6400000e0000ULL, 0x0000005635567220ULL, 0x042fe20000410000ULL,
0x0000005735577220ULL, 0x040fe20000410000ULL, 0x0000004a354a7220ULL, 0x040fe20000410000ULL,
0x0000004b354b7220ULL, 0x040fe20000410000ULL, 0x0000004e354e7220ULL, 0x040fe20000410000ULL,
0x0000004f354f7220ULL, 0x040fe20000410000ULL, 0x0000005235527220ULL, 0x040fe20000410000ULL,
0x0000005335537220ULL, 0x040fe20000410000ULL, 0x0000003235327220ULL, 0x040fe20000410000ULL,
0x0000003335337220ULL, 0x040fe20000410000ULL, 0x0000002e352e7220ULL, 0x040fe20000410000ULL,
0x0000002f352f7220ULL, 0x040fe20000410000ULL, 0x0000002a352a7220ULL, 0x040fe20000410000ULL,
0x0000002b352b7220ULL, 0x040fe20000410000ULL, 0x0000002635267220ULL, 0x040fe20000410000ULL,
0x0000002735277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x00000010093c7811ULL, 0x000fca00078ff0ffULL, 0x00001f3c3f357589ULL, 0x006e6400000e0000ULL,
0x0000000c350c7220ULL, 0x042fe20000410000ULL, 0x0000000d350d7220ULL, 0x040fe20000410000ULL,
0x0000001035107220ULL, 0x040fe20000410000ULL, 0x0000001135117220ULL, 0x040fe20000410000ULL,
0x0000001435147220ULL, 0x040fe20000410000ULL, 0x0000001535157220ULL, 0x040fe20000410000ULL,
0x0000001835187220ULL, 0x040fe20000410000ULL, 0x0000001935197220ULL, 0x040fe20000410000ULL,
0x0000001c351c7220ULL, 0x040fe20000410000ULL, 0x0000001d351d7220ULL, 0x040fe20000410000ULL,
0x0000002035207220ULL, 0x040fe20000410000ULL, 0x0000002135217220ULL, 0x040fe20000410000ULL,
0x0000003835387220ULL, 0x040fe20000410000ULL, 0x0000003935397220ULL, 0x040fe20000410000ULL,
0x0000004435447220ULL, 0x040fe20000410000ULL, 0x0000004535457220ULL, 0x000fce0000410000ULL,
0x0000003f84847220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x00000018093c7811ULL, 0x000fca00078ff0ffULL, 0x00001f3c3f357589ULL, 0x002e6400000e0000ULL,
0x0000000e350e7220ULL, 0x042fe20000410000ULL, 0x0000000f350f7220ULL, 0x040fe20000410000ULL,
0x0000001235127220ULL, 0x040fe20000410000ULL, 0x0000001335137220ULL, 0x040fe20000410000ULL,
0x0000001635167220ULL, 0x040fe20000410000ULL, 0x0000001735177220ULL, 0x040fe20000410000ULL,
0x0000001a351a7220ULL, 0x040fe20000410000ULL, 0x0000001b351b7220ULL, 0x040fe20000410000ULL,
0x0000001e351e7220ULL, 0x040fe20000410000ULL, 0x0000001f351f7220ULL, 0x040fe20000410000ULL,
0x0000002235227220ULL, 0x040fe20000410000ULL, 0x0000002335237220ULL, 0x040fe20000410000ULL,
0x0000003a353a7220ULL, 0x040fe20000410000ULL, 0x0000003b353b7220ULL, 0x040fe20000410000ULL,
0x0000004635467220ULL, 0x040fe20000410000ULL, 0x0000004735477220ULL, 0x000fce0000410000ULL,
0x000000363dff7212ULL, 0x000fe200078030ffULL, 0x00000001ff3c7424ULL, 0x000fd800078e00ffULL,
0x000000347a340221ULL, 0x000fe20000010100ULL, 0x00007610ff3c0816ULL, 0x000fc6000000003cULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400040308ULL, 0x000ea40000000800ULL,
0x0000000437370220ULL, 0x004fce0000410000ULL, 0x0000008437847221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x0000000877367824ULL, 0x000fca00078e00ffULL,
0xfffffff036377812ULL, 0x000fca00078ec0ffULL, 0x00000001083f7824ULL, 0x000fc800078e0237ULL,
0x01a6b0873f0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a6b0873f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000004ff367819ULL, 0x000fe20000011609ULL,
0x00000008683d7824ULL, 0x000fe200078e00ffULL, 0x000099103c347816ULL, 0x000fe200000000ffULL,
0x00000008783c7824ULL, 0x000fe400078e00ffULL, 0x0000000459357824ULL, 0x000fe200078e0236ULL,
0x000000ff3400720cULL, 0x000fe20003f05270ULL, 0x0000000477377824ULL, 0x000fe400078e00ffULL,
0x0000000168347824ULL, 0x100fe400078e0235ULL, 0x0000000178357824ULL, 0x000fe200078e0235ULL,
0x0000000437377812ULL, 0x000fe200078ec0ffULL, 0x000010005b367824ULL, 0x000fe200078e0208ULL,
0xfffffff83d347812ULL, 0x000fc400078ee234ULL, 0xfffffff83c357812ULL, 0x000fe200078ee235ULL,
0x00015000367c7836ULL, 0x000fe20000000000ULL, 0x00000002373c7812ULL, 0x000fe200078efcffULL,
0x000000106c367824ULL, 0x000fe400078e027bULL, 0x0000001034347824ULL, 0x100fe400078e027cULL,
0x0000001035357824ULL, 0x000fe200078e027cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x000000083e027836ULL, 0x000fe20000000000ULL, 0x0000541000377816ULL, 0x000fe20000000000ULL,
0x000000103e407836ULL, 0x000fe40000000000ULL, 0x000000183e427836ULL, 0x000fe40000000000ULL,
0x00001f0237027589ULL, 0x0002a800000e0000ULL, 0x00001f4037057589ULL, 0x0002e800000e0000ULL,
0x00001f3e37037589ULL, 0x00026800000e0000ULL, 0x00001f4237007589ULL, 0x00026400000e0000ULL,
0x00000000345c783bULL, 0x0006a80000000200ULL, 0x000000003540783bULL, 0x0026620000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000035c5c7232ULL, 0x084fe40000200000ULL,
0x000000035e5e7232ULL, 0x000fe40000200000ULL, 0x000000025d5d7232ULL, 0x080fe40000200000ULL,
0x000000025f5f7232ULL, 0x000fe40000200000ULL, 0x0000000540407232ULL, 0x08afe40000200000ULL,
0x0000000542427232ULL, 0x000fc40000200000ULL, 0x0000000041417232ULL, 0x080fe40000200000ULL,
0x0000000043437232ULL, 0x000fce0000200000ULL, 0x0000003c09837211ULL, 0x000fe200078fe0ffULL,
0x00000008683d7824ULL, 0x040fe200078e00ffULL, 0x000000003634783bULL, 0x008ee20000004200ULL,
0x000000106d7e7824ULL, 0x100fe400078e027cULL, 0x0000000168687824ULL, 0x000fe400078e0283ULL,
0x000000106f7c7824ULL, 0x000fc600078e027cULL, 0xfffffff83d687812ULL, 0x000fca00078ee268ULL,
0x00000010683c7824ULL, 0x000fcc00078e027bULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x00000010ff897819ULL, 0x008fe40000011634ULL, 0x00000018ff627819ULL, 0x100fe40000011635ULL,
0x00000010ff677819ULL, 0x000fe40000011636ULL, 0x000000ff89897812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fe40000011635ULL, 0x000000ff35637812ULL, 0x000fc400078ec0ffULL,
0x0000ffff35877812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe40000011637ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000018ff607819ULL, 0x000fe40000011634ULL,
0x000000ff36647812ULL, 0x000fe200078ec0ffULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x00000018ff357819ULL, 0x000fc40000011636ULL, 0x0000ffff366e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x000000ff378a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff367819ULL, 0x000fe40000011637ULL, 0x0000ffff37867812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c8b7812ULL, 0x024fc400078ec0ffULL, 0x000000ff3d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000010ff6d7819ULL, 0x100fe4000001163cULL,
0x00000018ff377819ULL, 0x000fe4000001163cULL, 0x0000ffff3c807812ULL, 0x000fe400078ec0ffULL,
0x000000ff34617812ULL, 0x000fc400078ec0ffULL, 0x00000010ff737819ULL, 0x100fe4000001163dULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x100fe4000001163eULL, 0x000000ff3e8e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8d7819ULL, 0x000fc4000001163eULL, 0x0000ffff3e667812ULL, 0x000fe400078ec0ffULL,
0x000000ff72727812ULL, 0x000fe400078ec0ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff3d7819ULL, 0x100fe4000001163fULL, 0x000000ff3f3e7812ULL, 0x000fe200078ec0ffULL,
0x20000060ff697230ULL, 0x000fe20000004100ULL, 0x00000018ff8f7819ULL, 0x000fc4000001163fULL,
0x0000ffff3f6f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6e7819ULL, 0x000fe4000001166eULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000008bff62723eULL, 0x000fe400020006ffULL,
0x0000008cff3f723eULL, 0x000fe200020006ffULL, 0x20000089ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8b7819ULL, 0x000fe20000011687ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fc400078ec0ffULL, 0x00000072ff89723eULL, 0x000fe200020006ffULL,
0x20000061ff6c7230ULL, 0x000fe20000004100ULL, 0x00000035ff35723eULL, 0x000fe400020006ffULL,
0x00000008ff867819ULL, 0x000fe20000011686ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x0000006eff72723eULL, 0x000fe200020006ffULL, 0x20000067ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x20000035ff617230ULL, 0x000fe20000004100ULL,
0x0000008aff60723eULL, 0x000fc400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x000000ff82677812ULL, 0x000fe200078ec0ffULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000088ff8a723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x000000ff3d3d7812ULL, 0x000fe200078ec0ffULL, 0x2000008aff877230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000086ff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fc4000001166fULL, 0x0000008dff35723eULL, 0x000fe200020006ffULL,
0x2000008bff8d7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000072ff8b7230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000080ff867230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x000fe20000011666ULL,
0x20000067ff807230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006fff72723eULL, 0x000fe200020006ffULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff6f7819ULL, 0x000fe4000001168cULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000066ff67723eULL, 0x000fe200020006ffULL, 0x2000003dff667230ULL, 0x000fe20000004100ULL,
0x0000ffff34347812ULL, 0x000fe200078ec0ffULL, 0x20000072ff3d7230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x20000063ff687230ULL, 0x000fe20000004100ULL,
0x000000ff73737812ULL, 0x000fe200078ec0ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000010546f727816ULL, 0x000fe2000000006cULL, 0x20000036ff637230ULL, 0x000fe20000004100ULL,
0x000000ff6d6d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6c7819ULL, 0x000fe40000011665ULL,
0x00000010ff6f7819ULL, 0x000fe4000001168dULL, 0x00000008ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff657819ULL, 0x000fe4000001166eULL,
0x00000037ff37723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x000010546c6f7816ULL, 0x000fe2000000006fULL,
0x20000073ff827230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000034ff88723eULL, 0x000fe400020006ffULL,
0x00000008ff857819ULL, 0x000fc40000011685ULL, 0x00001054656c7816ULL, 0x000fe20000000064ULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe40000011662ULL,
0x0000003eff36723eULL, 0x000fe200020006ffULL, 0x20000037ff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff617819ULL, 0x000fe20000011661ULL, 0x2000008eff377230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011663ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fc4000001168bULL, 0x00000010ff637819ULL, 0x000fe4000001168aULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000010ff687819ULL, 0x000fe20000011668ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe20000011687ULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x0000105461627816ULL, 0x000fe40000000062ULL,
0x0000105464637816ULL, 0x000fe20000000063ULL, 0x2000008fff347230ULL, 0x000fe20000004100ULL,
0x00000010ff617819ULL, 0x000fe4000001163fULL, 0x0000105473737816ULL, 0x000fe40000000068ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x000000624018723cULL, 0x002fe20000041818ULL,
0x00000010ff897819ULL, 0x000fc40000011689ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163eULL,
0x00000010ff647819ULL, 0x000fe20000011686ULL, 0x00000072400c723cULL, 0x000fe2000004180cULL,
0x00000010ff687819ULL, 0x000fe4000001166dULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff887819ULL, 0x000fe20000011688ULL, 0x000000725c54723cULL, 0x000fe20000041854ULL,
0x00000010ff377819ULL, 0x000fc40000011637ULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x00001054896d7816ULL, 0x000fe20000000060ULL, 0x000000625c50723cULL, 0x000fe20000041850ULL,
0x000010543f647816ULL, 0x000fe40000000064ULL, 0x0000105468607816ULL, 0x000fe40000000065ULL,
0x00000010ff3f7819ULL, 0x000fe20000011666ULL, 0x0000006c4014723cULL, 0x000fe20000041814ULL,
0x00001054696e7816ULL, 0x000fc40000000088ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff3c7819ULL, 0x000fe2000001163cULL, 0x0000006c5c4c723cULL, 0x000fe2000004184cULL,
0x00000010ff657819ULL, 0x000fe40000011685ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x0000105480667816ULL, 0x000fe20000000037ULL, 0x0000006e4010723cULL, 0x000fe20000041810ULL,
0x00000010ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff687819ULL, 0x000fe40000011667ULL,
0x00000010ff807819ULL, 0x000fe20000011634ULL, 0x0000006e5c48723cULL, 0x000fe20000041848ULL,
0x00000010ff697819ULL, 0x000fe4000001163dULL, 0x0000105482617816ULL, 0x000fe40000000061ULL,
0x000010543c657816ULL, 0x000fe40000000065ULL, 0x000010543f677816ULL, 0x000fc40000000036ULL,
0x0000105435687816ULL, 0x000fe20000000068ULL, 0x00000060401c723cULL, 0x000fe2000004181cULL,
0x0000105480697816ULL, 0x000fe20000000069ULL, 0x000000007e3c783bULL, 0x0002680000000200ULL,
0x000000644020723cULL, 0x000fe20000041820ULL, 0x000000007c34783bULL, 0x0002ea0000000200ULL,
0x000000664038723cULL, 0x000fec0000041838ULL, 0x000000605c30723cULL, 0x000fec0000041830ULL,
0x000000645c2c723cULL, 0x000fec000004182cULL, 0x000000665c28723cULL, 0x000fec0000041828ULL,
0x000000685c24723cULL, 0x000fec0000041824ULL, 0x000000684040723cULL, 0x000fe20000041844ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x002fde0003800000ULL,
0x000000033c3c7232ULL, 0x080fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x0000000178837824ULL, 0x040fe200078e0283ULL, 0x000000007d44783bULL, 0x000e620000004200ULL,
0x00000008785c7824ULL, 0x000fe400078e00ffULL, 0x0000000158587836ULL, 0x000fc60000000000ULL,
0xfffffff85c5c7812ULL, 0x000fca00078ee283ULL, 0x000000105c5c7824ULL, 0x000fcc00078e027bULL,
0x000000005c5c783bULL, 0x000ea20000004200ULL, 0x000000ff44617812ULL, 0x042fe400078ec0ffULL,
0x00000018ff607819ULL, 0x100fe40000011644ULL, 0x00000010ff7e7819ULL, 0x000fe40000011644ULL,
0x0000ffff44857812ULL, 0x000fe400078ec0ffULL, 0x000000ff467c7812ULL, 0x000fe400078ec0ffULL,
0x00000061ff68723eULL, 0x000fc400020006ffULL, 0x00000010ff807819ULL, 0x100fe40000011645ULL,
0x000000ff45447812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011645ULL,
0x0000ffff45877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011646ULL,
0x00000060ff73723eULL, 0x000fc400020006ffULL, 0x00000010ff697819ULL, 0x104fe4000001165cULL,
0x000000ff5c6e7812ULL, 0x040fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000018ff457819ULL, 0x000fe4000001165cULL, 0x0000ffff5c667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe40000011646ULL, 0x0000ffff467b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7d7819ULL, 0x100fe40000011647ULL, 0x000000ff47837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe40000011647ULL, 0x0000ffff47787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x000fe4000001165dULL, 0x000000ff5d5c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe4000001165dULL, 0x0000ffff5d657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f477812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe4000001165fULL, 0x0000ffff5f617812ULL, 0x000fe200078ec0ffULL,
0x20000068ff5f7230ULL, 0x000fe20000004100ULL, 0x0000007cff5d723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000044ff6d723eULL, 0x000fe400020006ffULL,
0x0000006fff68723eULL, 0x000fe200020006ffULL, 0x2000005dff6f7230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x2000006cff7c7230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fe200078ec0ffULL, 0x20000068ff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe2000001165eULL, 0x20000082ff687230ULL, 0x000fe20000004100ULL,
0x000000ff5e447812ULL, 0x000fc400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe4000001165eULL,
0x0000ffff5e637812ULL, 0x000fe200078ec0ffULL, 0x2000006dff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff5d7819ULL, 0x000fe40000011685ULL, 0x00000083ff6d723eULL, 0x000fe400020006ffULL,
0x00000008ff837819ULL, 0x000fe40000011687ULL, 0x00000080ff82723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff86867812ULL, 0x000fe400078ec0ffULL,
0x00000083ff85723eULL, 0x000fe200020006ffULL, 0x20000082ff837230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000005dff827230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000000ff7d5d7812ULL, 0x000fe200078ec0ffULL,
0x2000007eff807230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fe20000011678ULL,
0x20000086ff7d7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000085ff7e7230ULL, 0x000fe20000004100ULL, 0x0000006eff86723eULL, 0x000fc400020006ffULL,
0x00000078ff85723eULL, 0x000fe200020006ffULL, 0x2000005dff787230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe2000001167bULL, 0x20000086ff5d7230ULL, 0x000fe20000004100ULL,
0x00000060ff86723eULL, 0x000fe200020006ffULL, 0x20000085ff6e7230ULL, 0x000fe20000004100ULL,
0x00000045ff85723eULL, 0x000fe400020006ffULL, 0x00000010ff607819ULL, 0x000fe40000011683ULL,
0x00000010ff457819ULL, 0x000fe2000001165eULL, 0x20000085ff5e7230ULL, 0x000fe20000004100ULL,
0x00000044ff83723eULL, 0x000fc400020006ffULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x0000105460457816ULL, 0x000fe20000000045ULL,
0x20000083ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff837819ULL, 0x000fe4000001167cULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000105480447816ULL, 0x000fe2000000005fULL, 0x20000086ff5f7230ULL, 0x000fe20000004100ULL,
0x00000047ff7c723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000046ff80723eULL, 0x000fe400020006ffULL, 0x0000105473467816ULL, 0x000fe20000000082ULL,
0x000000443c54723cULL, 0x000fe20000041854ULL, 0x0000105483477816ULL, 0x000fe2000000007eULL,
0x2000007cff737230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fe2000001167dULL, 0x00000044340c723cULL, 0x008fe2000004180cULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x000000463c48723cULL, 0x000fe20000041848ULL,
0x00000010ff447819ULL, 0x000fe4000001166fULL, 0x00000010ff457819ULL, 0x000fc4000001166dULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x000000463410723cULL, 0x000fe20000041810ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff477819ULL, 0x000fe4000001166eULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x000010547d447816ULL, 0x000fe20000000044ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000105478457816ULL, 0x000fe20000000045ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000000ff69697812ULL, 0x000fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010546c467816ULL, 0x000fe2000000007bULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000105468477816ULL, 0x000fe20000000047ULL, 0x000000443c4c723cULL, 0x000fe2000004184cULL,
0x00000008ff637819ULL, 0x000fc40000011663ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe20000011661ULL, 0x000000443414723cULL, 0x000fe20000041814ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x000000463c50723cULL, 0x000fe20000041850ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000072ff6f7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000080ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff457819ULL, 0x000fe2000001165cULL, 0x000000463418723cULL, 0x000fe20000041818ULL,
0x00000010ff447819ULL, 0x000fe2000001165dULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe2000001165fULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff607819ULL, 0x000fe20000011660ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe2000001165eULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fc40000011667ULL, 0x00000010ff5e7819ULL, 0x000fe40000011666ULL,
0x00000010ff5f7819ULL, 0x000fe40000011665ULL, 0x00000010ff5d7819ULL, 0x000fe40000011662ULL,
0x0000105446457816ULL, 0x000fe40000000045ULL, 0x00001054475e7816ULL, 0x000fe4000000005eULL,
0x000010545c5f7816ULL, 0x000fc4000000005fULL, 0x000010545d467816ULL, 0x000fe40000000060ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff6f7819ULL, 0x000fe2000001166fULL,
0x0000005e3c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff477819ULL, 0x000fe40000011673ULL,
0x00000010ff5c7819ULL, 0x000fe40000011663ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x0000005e3420723cULL, 0x000fe20000041820ULL, 0x00000010ff727819ULL, 0x000fc40000011672ULL,
0x00000010ff5d7819ULL, 0x000fe40000011661ULL, 0x0000105469447816ULL, 0x000fe40000000044ULL,
0x000010546f5c7816ULL, 0x000fe4000000005cULL, 0x0000105464477816ULL, 0x000fe40000000047ULL,
0x00001054725d7816ULL, 0x000fe2000000005dULL, 0x000000443c30723cULL, 0x000fec0000041830ULL,
0x000000463c28723cULL, 0x000fec0000041828ULL, 0x0000005c3c24723cULL, 0x000fec0000041824ULL,
0x00000044341c723cULL, 0x000fe2000004181cULL, 0x00000001ff3f7424ULL, 0x000fc800078e00ffULL,
0x0000003f063c79a7ULL, 0x0002a2000850003fULL, 0x000000463438723cULL, 0x000fec0000041838ULL,
0x0000005c3434723cULL, 0x000fe20000041840ULL, 0x000000085b067824ULL, 0x002fc800078e0208ULL,
0x01a6a03f06ff79a7ULL, 0x0003e4000850003fULL, 0x000000ffff407224ULL, 0x004fe200078e003dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff4000909947ULL, 0x002fde000383ffffULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x0000000400648947ULL, 0x000fea0003800000ULL,
0x0180000084007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000df1000047802ULL, 0x000fce0000000f00ULL,
0x000000b8006c7944ULL, 0x016fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000008400037308ULL, 0x002e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000084ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009a00ff027b82ULL, 0x000f640000000a00ULL,
0x0000000602037981ULL, 0x02aee2000c1e9900ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x0000000806057811ULL, 0x042fe400078ff0ffULL, 0x0000001806077811ULL, 0x040fe400078ff0ffULL,
0x00000002ff097819ULL, 0x000fe40000011606ULL, 0x00000010063d7811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x00cfca0000410000ULL, 0x00001f0900047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea800000e0000ULL, 0x00001f3d00067589ULL, 0x000ee800000e0000ULL,
0x00001f0700077589ULL, 0x000f6200000e0000ULL, 0x0000005404547220ULL, 0x042fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000004804487220ULL, 0x040fe20000410000ULL,
0x0000004904497220ULL, 0x040fe20000410000ULL, 0x0000004c044c7220ULL, 0x040fe20000410000ULL,
0x0000004d044d7220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x000fe20000410000ULL, 0x0000005605567220ULL, 0x044fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000004a054a7220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004e054e7220ULL, 0x040fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x0000000c060c7220ULL, 0x048fe20000410000ULL,
0x0000000d060d7220ULL, 0x040fe20000410000ULL, 0x0000001006107220ULL, 0x040fe20000410000ULL,
0x0000001106117220ULL, 0x040fe20000410000ULL, 0x0000001406147220ULL, 0x040fe20000410000ULL,
0x0000001506157220ULL, 0x040fe20000410000ULL, 0x0000001806187220ULL, 0x040fe20000410000ULL,
0x0000001906197220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x040fe20000410000ULL,
0x0000001d061d7220ULL, 0x040fe20000410000ULL, 0x0000002006207220ULL, 0x040fe20000410000ULL,
0x0000002106217220ULL, 0x040fe20000410000ULL, 0x0000003806387220ULL, 0x040fe20000410000ULL,
0x0000003906397220ULL, 0x040fe20000410000ULL, 0x0000003406347220ULL, 0x040fe20000410000ULL,
0x0000003506357220ULL, 0x000fe20000410000ULL, 0x0000000e070e7220ULL, 0x060fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001e071e7220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000002207227220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000003a073a7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000003707377220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000000177777812ULL, 0x000fe400078ec0ffULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000200077087824ULL, 0x000fe200078e0208ULL,
0x0000002c2d2c723eULL, 0x000fc400000010ffULL, 0x000000282928723eULL, 0x000fe400000010ffULL,
0x000000242524723eULL, 0x000fe400000010ffULL, 0x000000565756723eULL, 0x000fe400000010ffULL,
0x0000004a4b4a723eULL, 0x000fe400000010ffULL, 0x0000004e4f4e723eULL, 0x000fe400000010ffULL,
0x000000525352723eULL, 0x000fc400000010ffULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe200000010ffULL, 0x000000016b6b7824ULL, 0x008fe200078e0200ULL,
0x0000000800057811ULL, 0x040fe400078ff0ffULL, 0x0000000200027812ULL, 0x002fe200078ec0ffULL,
0x000000106b6b7824ULL, 0x000fe200078e0208ULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x0000000805407824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fc400078ff8ffULL,
0x0000001000057811ULL, 0x040fe200078ff0ffULL, 0x00000008073c7824ULL, 0x040fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee203ULL, 0x00000008073e7824ULL, 0x000fe200078e00ffULL,
0x0000001800097811ULL, 0x000fe200078ff0ffULL, 0x00000008053d7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x040fe400078ff8ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x0000000809447824ULL, 0x000fe200078e00ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0xfffffff83d427812ULL, 0x000fe200078ee204ULL,
0x0000000203027836ULL, 0x000fe20000000000ULL, 0xfffffff844447812ULL, 0x000fe200078ee205ULL,
0x0000000403057836ULL, 0x000fe20000000000ULL, 0x0000000c0d0c723eULL, 0x000fe200000010ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff809067812ULL, 0x000fe200078ee202ULL,
0x0000000807027824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0x0000000804057812ULL, 0x000fc400078ec0ffULL,
0xfffffff802027812ULL, 0x000fe200078ee203ULL, 0x0000100071037824ULL, 0x000fe200078e0208ULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee207ULL, 0x000000141514723eULL, 0x000fe200000010ffULL,
0x0000001002047824ULL, 0x100fe200078e0203ULL, 0x000000545502723eULL, 0x000fe200000010ffULL,
0x0000001040407824ULL, 0x100fe200078e0203ULL, 0x000000181918723eULL, 0x000fe200000010ffULL,
0x0000001042427824ULL, 0x100fe200078e0203ULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x0000001044447824ULL, 0x100fe200078e0203ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x000000383938723eULL, 0x000fe200000010ffULL,
0x000000103c3c7824ULL, 0x100fe200078e0203ULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x000000103e3e7824ULL, 0x000fe200078e0203ULL, 0x000000484903723eULL, 0x000fe200000010ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x0000000e0f0e723eULL, 0x000fe200000010ffULL,
0x0000000105407824ULL, 0x040fe200078e0240ULL, 0x0000541002467816ULL, 0x140fe20000000003ULL,
0x0000000105427824ULL, 0x040fe200078e0242ULL, 0x0000763202477816ULL, 0x000fe20000000003ULL,
0x0000000105447824ULL, 0x000fe200078e0244ULL, 0x0000004c4d02723eULL, 0x000fe200000010ffULL,
0x0000000105097824ULL, 0x000fe200078e0206ULL, 0x000000505103723eULL, 0x000fe200000010ffULL,
0x0000004604007388ULL, 0x0003e20000000a00ULL, 0x00000001053c7824ULL, 0x000fe200078e023cULL,
0x000000101106723eULL, 0x000fe200000010ffULL, 0x00000001053e7824ULL, 0x000fe200078e023eULL,
0x0000763202057816ULL, 0x000fc40000000003ULL, 0x000000121307723eULL, 0x000fe400000010ffULL,
0x000000161716723eULL, 0x000fe400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe400000010ffULL,
0x0000541002047816ULL, 0x002fe40000000003ULL, 0x0000541030027816ULL, 0x140fe4000000002cULL,
0x0000763230037816ULL, 0x000fe2000000002cULL, 0x0000000409007388ULL, 0x000fe20000000a00ULL,
0x0000001e1f1e723eULL, 0x000fc400000010ffULL, 0x00000022230f723eULL, 0x000fe200000010ffULL,
0x000000023c007388ULL, 0x0003e20000000a00ULL, 0x0000003a3b3a723eULL, 0x000fe400000010ffULL,
0x00000036371d723eULL, 0x000fe400000010ffULL, 0x000000ff7100720cULL, 0x000fe40003f05270ULL,
0x000076323a297816ULL, 0x000fe4000000001dULL, 0x0000541028027816ULL, 0x002fc40000000024ULL,
0x0000763228037816ULL, 0x000fe40000000024ULL, 0x000054103a287816ULL, 0x000fc6000000001dULL,
0x000000023e007388ULL, 0x0003e40000000a00ULL, 0x0000541056027816ULL, 0x142fe4000000004aULL,
0x0000763256037816ULL, 0x000fca000000004aULL, 0x0000000240007388ULL, 0x0003e40000000a00ULL,
0x000054104e027816ULL, 0x142fe40000000052ULL, 0x000076324e037816ULL, 0x000fca0000000052ULL,
0x0004000209007388ULL, 0x0003e40000000a00ULL, 0x0000541032027816ULL, 0x142fe4000000002eULL,
0x0000763232037816ULL, 0x000fca000000002eULL, 0x000400023c007388ULL, 0x0003e40000000a00ULL,
0x000054102a027816ULL, 0x142fe40000000026ULL, 0x000076322a037816ULL, 0x000fca0000000026ULL,
0x000400023e007388ULL, 0x0003e40000000a00ULL, 0x000054100c027816ULL, 0x142fe40000000006ULL,
0x000076320c037816ULL, 0x000fe40000000006ULL, 0x000054100e067816ULL, 0x140fe40000000007ULL,
0x000076320e077816ULL, 0x000fe20000000007ULL, 0x0000000242007388ULL, 0x0003e40000000a00ULL,
0x0000541014027816ULL, 0x002fc40000000018ULL, 0x0000763214037816ULL, 0x000fca0000000018ULL,
0x0008000209007388ULL, 0x0003e40000000a00ULL, 0x000054101c027816ULL, 0x142fe40000000020ULL,
0x000076321c037816ULL, 0x000fca0000000020ULL, 0x000800023c007388ULL, 0x0003e40000000a00ULL,
0x0000541038027816ULL, 0x142fe40000000034ULL, 0x0000763238037816ULL, 0x000fca0000000034ULL,
0x000800023e007388ULL, 0x0003e80000000a00ULL, 0x0000000644007388ULL, 0x000fe20000000a00ULL,
0x0000541016027816ULL, 0x142fe4000000001aULL, 0x0000763216037816ULL, 0x000fca000000001aULL,
0x000c000209007388ULL, 0x0003e40000000a00ULL, 0x000054101e027816ULL, 0x142fe4000000000fULL,
0x000076321e037816ULL, 0x000fca000000000fULL, 0x000c00023c007388ULL, 0x0003e80000000a00ULL,
0x000c00283e007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff00027306ULL, 0x002e620000202400ULL, 0x000000006b047984ULL, 0x000e680000000c00ULL,
0x000400006b107984ULL, 0x000ee80000000c00ULL, 0x000800006b187984ULL, 0x000f680000000c00ULL,
0x000c00006b207984ULL, 0x000f680000000c00ULL, 0x001000006b0c7984ULL, 0x000f680000000c00ULL,
0x001400006b147984ULL, 0x000f680000000c00ULL, 0x001800006b1c7984ULL, 0x000f680000000c00ULL,
0x001c00006b247984ULL, 0x000f620000000c00ULL, 0x0000000702077230ULL, 0x002fc40000200800ULL,
0x0000000602067230ULL, 0x040fe40000200800ULL, 0x0000000502057230ULL, 0x040fe40000200800ULL,
0x0000000402047230ULL, 0x040fe40000200800ULL, 0x0000001302137230ULL, 0x048fe40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x000fc40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001b021b7230ULL, 0x064fe40000200800ULL,
0x0000001a021a7230ULL, 0x040fe40000200800ULL, 0x0000001902197230ULL, 0x040fe40000200800ULL,
0x0000001802187230ULL, 0x040fe40000200800ULL, 0x0000002302237230ULL, 0x000fc40000200800ULL,
0x0000002202227230ULL, 0x040fe40000200800ULL, 0x0000002102217230ULL, 0x040fe40000200800ULL,
0x0000002002027230ULL, 0x000fe40000200800ULL, 0x0000000f07077230ULL, 0x000fe40000200000ULL,
0x0000000e06067230ULL, 0x000fe40000200000ULL, 0x0000000d05057230ULL, 0x000fc40000200000ULL,
0x0000000c04047230ULL, 0x000fe40000200000ULL, 0x0000001713137230ULL, 0x000fe40000200000ULL,
0x0000001612127230ULL, 0x000fe20000200000ULL, 0x000000046b007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000200000ULL,
0x000400106b007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000200000ULL,
0x0000001c18187230ULL, 0x000fe40000200000ULL, 0x0000002723237230ULL, 0x000fe40000200000ULL,
0x0000002622227230ULL, 0x000fe20000200000ULL, 0x000800186b007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000200000ULL, 0x0000002402207230ULL, 0x000fca0000200000ULL,
0x000c00206b007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x0000000b0900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x0000000176047824ULL, 0x002fe200078e0209ULL,
0x0000000800067d06ULL, 0x000e620008209000ULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000700127812ULL, 0x000fca00078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06027836ULL, 0x002fcc0000000000ULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000000805057c24ULL, 0x000fc8000f8e02ffULL,
0x0000000503037227ULL, 0x000fc800078e0002ULL, 0x0000000109027824ULL, 0x000fe400078e0200ULL,
0x0000000403077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x0000000107070836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000805007c0cULL, 0x000fe4000bf26070ULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00000008ff027c12ULL, 0x000fe4000f8e33ffULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0208ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x00000000060c7984ULL, 0x0002a40000000c00ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0212ULL, 0x00000003ff097819ULL, 0x000fc40000011606ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4410ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000004000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x0000006000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000008000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x000000a000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000176047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x000000c000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000877077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000176047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x000000e000007836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef809ULL, 0x0000001005067824ULL, 0x000fca00078e0208ULL,
0x00000000060c7984ULL, 0x000e620000000c00ULL, 0x0000000107072836ULL, 0x000fca0000000000ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011600ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000877077824ULL, 0x000fe400078e0210ULL,
0x0000000176767824ULL, 0x000fe200078e0209ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4412ULL, 0x0000000b0900720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0023ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007603037227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x002fe400078e0a03ULL, 0x0000000100097824ULL, 0x000fe400078e0209ULL,
0x0000000805047c24ULL, 0x000fc6000f8e0276ULL, 0x0000000709097812ULL, 0x000fe400078ec0ffULL,
0x0000000804007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff809097812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe400078e0208ULL,
0x0000000877777824ULL, 0x000fc800078e0200ULL, 0x8000000804041c36ULL, 0x000fe40008000000ULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf46070ULL,
0x0000000009047984ULL, 0x000e760000000c00ULL, 0x0000000103032836ULL, 0x000fca0000000000ULL,
0x0000000302027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000000902037c24ULL, 0x000fe4000f8e0279ULL, 0x000000080b767c24ULL, 0x000fc8000f8e0276ULL,
0x0000000803037c24ULL, 0x000fca000f8e0276ULL, 0x000000030a037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8040ffULL,
0x0000000503037c11ULL, 0x000fc600080f4408ULL, 0x0000001077027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff7a7819ULL, 0x000fe20000011677ULL, 0x00009a00ff6c7b82ULL, 0x000e620000000a00ULL,
0xffffffffff077424ULL, 0x000fe400078e00ffULL, 0x000000757a00720cULL, 0x000fe20003f06070ULL,
0x00000001ff0b7424ULL, 0x000fd800078e00ffULL, 0x00009600ff048b82ULL, 0x000ea20000000800ULL,
0x0000000272058824ULL, 0x000fce00078e00ffULL, 0x00009200ff0e8b82ULL, 0x000ee20000000a00ULL,
0x000000066c6c7981ULL, 0x002322000c1e9900ULL, 0x0000000405058224ULL, 0x004fc800078e027aULL,
0x00000004050e8825ULL, 0x008fe400078e000eULL, 0x01a6000b080479a7ULL, 0x000466000850003fULL,
0x000000060e078981ULL, 0x000ee2000c1e1900ULL, 0x00009000ff0a7b82ULL, 0x004ea20000000a00ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000008000007824ULL, 0x000fe400078e00ffULL,
0x0000008079797824ULL, 0x000fc400078e00ffULL, 0x0000004077787824ULL, 0x000fca00078e00ffULL,
0x00000040790c7812ULL, 0x000fe200078ef878ULL, 0x0000000700077224ULL, 0x008fc800078e02ffULL,
0x00000080070a7825ULL, 0x004fe200078e000aULL, 0x0000000c00200947ULL, 0x002fec0003800000ULL,
0x00000003ff307819ULL, 0x000fe40000011609ULL, 0x0000007874077248ULL, 0x000fc60007fe0000ULL,
0x0000000830127836ULL, 0x000fe40000000000ULL, 0x0000000430107836ULL, 0x000fe40000000000ULL,
0x0000000107077824ULL, 0x000fe400078e0a78ULL, 0x00000001120f7824ULL, 0x040fe400078e0209ULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0x000000071000720cULL, 0x000fe20003fa6070ULL,
0x000000010c0e7824ULL, 0x000fc400078e0230ULL, 0x00000001100d7824ULL, 0x040fe200078e0209ULL,
0xfffffff816257812ULL, 0x000fe200078ee20fULL, 0x0000000810147824ULL, 0x000fe400078e00ffULL,
0x000000010c107824ULL, 0x000fe400078e0210ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff814237812ULL, 0x000fc600078ee20dULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e1d7812ULL, 0x000fc600078ef802ULL, 0x0000001030147836ULL, 0x000fe20000000000ULL,
0x0000007010137812ULL, 0x000fe200078ef802ULL, 0x0000000c30167836ULL, 0x000fe20000000000ULL,
0x0000001d0a1c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001140e7824ULL, 0x040fe200078e0209ULL,
0x000000130a107210ULL, 0x000fe20007f3e0ffULL, 0x0000000814297824ULL, 0x000fe200078e00ffULL,
0x000000071600720cULL, 0x080fe20003f46070ULL, 0x000000010b1d7824ULL, 0x040fe200000e060fULL,
0x000000071400720cULL, 0x080fe20003f06070ULL, 0x000000010b117824ULL, 0x000fe200008e0611ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x000000010c0e7824ULL, 0x000fe200078e0212ULL,
0x000000071200720cULL, 0x000fe20003f26070ULL, 0x000000010c127824ULL, 0x000fc400078e0216ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x000000010c147824ULL, 0x000fe200078e0214ULL,
0x000000700e197812ULL, 0x000fe200078ef802ULL, 0x00000001160d7824ULL, 0x040fe400078e0209ULL,
0x0000000816187824ULL, 0x000fe400078e00ffULL, 0x0000001430207836ULL, 0x000fe40000000000ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff818277812ULL, 0x000fe400078ee20dULL,
0x000000190a187210ULL, 0x000fe20007f7e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000070121f7812ULL, 0x000fc600078ef802ULL, 0x0000001830227836ULL, 0x000fe20000000000ULL,
0x00000070140d7812ULL, 0x000fe200078ef802ULL, 0x000000010c167824ULL, 0x040fe200078e0220ULL,
0x0000001f0a1e7210ULL, 0x000fe20007f9e0ffULL, 0x000000010c1a7824ULL, 0x000fe400078e0222ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000010b197824ULL, 0x000fe200018e060fULL,
0x0000000d0a127210ULL, 0x000fe20007f7e0ffULL, 0x0000001c30267836ULL, 0x000fe20000000000ULL,
0x00000070160f7812ULL, 0x000fe200078ef802ULL, 0x000000801a1a7825ULL, 0x000fc800078e00ffULL,
0x000000010c0e7824ULL, 0x000fe200078e0226ULL, 0x000000701a0d7812ULL, 0x000fe200078ef802ULL,
0x000000010b1f7824ULL, 0x040fe400020e0613ULL, 0x000000010b137824ULL, 0x000fe200018e0615ULL,
0x0000000f0a147210ULL, 0x000fe20007f7e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000d0a167210ULL, 0x000fc60007f9e0ffULL, 0x00004000770d7824ULL, 0x000fe200078e0208ULL,
0x000000700e217812ULL, 0x000fe200078ef802ULL, 0x00000001301a7824ULL, 0x000fe400078e0209ULL,
0x000000010b157824ULL, 0x040fe200018e0617ULL, 0x000000072000720cULL, 0x080fe20003f66070ULL,
0x000020000d247836ULL, 0x000fe20000000000ULL, 0x000000071a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000002030287836ULL, 0x000fe40000000000ULL, 0x000000010b177824ULL, 0x000fe200020e061bULL,
0x000000073000720cULL, 0x000fe20003f86070ULL, 0x00000001200d7824ULL, 0x040fe200078e0209ULL,
0x0ffffff81a1b7812ULL, 0x000fe200078ef809ULL, 0x00000008202a7824ULL, 0x000fe200078e00ffULL,
0x000000210a207210ULL, 0x000fe20007fde0ffULL, 0x000000010c0e7824ULL, 0x000fc400078e0228ULL,
0x00000028302c7836ULL, 0x000fe20000000000ULL, 0xfffffff82a2b7812ULL, 0x000fe200078ee20dULL,
0x000000010b217824ULL, 0x000fe400030e060fULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000101b0d7824ULL, 0x000fe200078e0224ULL, 0x000000700e1b7812ULL, 0x000fe200078ef802ULL,
0x00000024302a7836ULL, 0x000fe40000000000ULL, 0x00000001220e7824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c0d7faeULL, 0x0003e2000e101c46ULL,
0x000000010c1a7824ULL, 0x000fe200078e022aULL, 0x000000072200720cULL, 0x040fe20003f86070ULL,
0x00000008222d7824ULL, 0x000fe200078e00ffULL, 0x0000001b0a227210ULL, 0x000fe20007fde0ffULL,
0x000000801a1a7825ULL, 0x000fc600078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL,
0x000000010c2e7824ULL, 0x000fe400078e022cULL, 0x0000001025257824ULL, 0x100fe200078e0224ULL,
0x000000701a1d7812ULL, 0x002fe200078ef802ULL, 0x00000010230d7824ULL, 0x000fe400078e0224ULL,
0x000000010b237824ULL, 0x000fe200030e060fULL, 0x0000001d0a1a7210ULL, 0x000fe20007fde0ffULL,
0x000000802e0e7825ULL, 0x000fe200078e00ffULL, 0x00000000100d7faeULL, 0x0003e2000e901c46ULL,
0x000000072600720cULL, 0x000fc40003fa6070ULL, 0x00000001261c7824ULL, 0x140fe200078e0209ULL,
0x0000000018257faeULL, 0x0005e2000c901c46ULL, 0x00000008262f7824ULL, 0x000fe200078e00ffULL,
0x000000700e1d7812ULL, 0x000fe200078ef802ULL, 0x0000002c30267836ULL, 0x000fe20000000000ULL,
0x000000072800720cULL, 0x0c0fe20003f26070ULL, 0x0000001027277824ULL, 0x100fe400078e0224ULL,
0x0000001029297824ULL, 0x000fe400078e0224ULL, 0x00000001280d7824ULL, 0x042fe200078e0209ULL,
0x000000001e277faeULL, 0x000fe2000d101c46ULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x000000072a00720cULL, 0x000fe20003f46070ULL, 0x000000010c107824ULL, 0x000fe200078e0226ULL,
0x0000000012297faeULL, 0x0003e2000c101c46ULL, 0x000000010b1b7824ULL, 0x000fe200030e061bULL,
0x0000001d0a0e7210ULL, 0x000fe20007fde0ffULL, 0x0000003030187836ULL, 0x004fe20000000000ULL,
0xfffffff82f1d7812ULL, 0x000fe200078ee21cULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff8280d7812ULL, 0x000fc600078ee20dULL, 0x000000012a1c7824ULL, 0x040fe200078e0209ULL,
0x00000070102f7812ULL, 0x000fe200078ef802ULL, 0x000000082a317824ULL, 0x000fe400078e00ffULL,
0x000000102b2b7824ULL, 0x000fe400078e0224ULL, 0x000000010c127824ULL, 0x002fe200078e0218ULL,
0xfffffff831197812ULL, 0x000fe200078ee21cULL, 0x000000102d2d7824ULL, 0x100fe200078e0224ULL,
0x00000000142b7faeULL, 0x0003e2000d901c46ULL, 0x000000101d1d7824ULL, 0x100fe200078e0224ULL,
0x000000071800720cULL, 0x080fe20003f66070ULL, 0x000000100d0d7824ULL, 0x000fe200078e0224ULL,
0x00000000162d7faeULL, 0x0005e2000e101c46ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000072600720cULL, 0x000fc40003f86070ULL, 0x00000000201d7faeULL, 0x000fe2000e901c46ULL,
0x000000010b0f7824ULL, 0x000fe200030e060fULL, 0x0000002f0a107210ULL, 0x000fe20007fde0ffULL,
0x00000034301c7836ULL, 0x000fe20000000000ULL, 0x00000000220d7faeULL, 0x0007e2000c901c46ULL,
0x0000001019197824ULL, 0x000fe200078e0224ULL, 0x000000072c00720cULL, 0x080fe20003fa6070ULL,
0x000000010c147824ULL, 0x002fe400078e021cULL, 0x00000038301e7836ULL, 0x000fe20000000000ULL,
0x000000001a197faeULL, 0x0003e2000d101c46ULL, 0x0000003c30287836ULL, 0x000fe20000000000ULL,
0x000000071c00720cULL, 0x080fe20003f46070ULL, 0x000000012c177824ULL, 0x004fe200078e0209ULL,
0x000000071e00720cULL, 0x080fe20003f26070ULL, 0x000000010b117824ULL, 0x000fe200030e0611ULL,
0x00000070120d7812ULL, 0x008fe200078ef802ULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x000000072800720cULL, 0x000fe20003f06070ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000d0a167210ULL, 0x000fc40007fde0ffULL, 0xfffffff82c077812ULL, 0x000fe200078ee217ULL,
0x0000000118127824ULL, 0x040fe400078e0209ULL, 0x000000010b177824ULL, 0x000fe200030e0613ULL,
0x0000007014137812ULL, 0x000fe200078ef802ULL, 0x00000008181b7824ULL, 0x002fe400078e00ffULL,
0x00000001260d7824ULL, 0x000fe200078e0209ULL, 0x000000130a147210ULL, 0x000fe20007fde0ffULL,
0x000000010c137824ULL, 0x000fe200078e021eULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL,
0x0000000826267824ULL, 0x000fc400078e00ffULL, 0x0000008013127825ULL, 0x000fc600078e00ffULL,
0xfffffff826197812ULL, 0x000fe200078ee20dULL, 0x000000010c0c7824ULL, 0x000fe200078e0228ULL,
0x00000070121d7812ULL, 0x000fe200078ef802ULL, 0x000000011e1a7824ULL, 0x040fe400078e0209ULL,
0x000000081e217824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010b157824ULL, 0x040fe200030e0615ULL, 0x0000001d0a127210ULL, 0x000fe20007fde0ffULL,
0x000000011c187824ULL, 0x140fe200078e0209ULL, 0xfffffff8211d7812ULL, 0x000fe200078ee21aULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0x000000700c217812ULL, 0x000fe200078ef802ULL,
0x00000001281c7824ULL, 0x040fe400078e0209ULL, 0x0000000828237824ULL, 0x000fe200078e00ffULL,
0xfffffff81f097812ULL, 0x000fe200078ee218ULL, 0x000000010b137824ULL, 0x000fe200030e0613ULL,
0x000000210a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001007077824ULL, 0x100fe200078e0224ULL,
0xfffffff8231f7812ULL, 0x000fe200078ee21cULL, 0x0000001019197824ULL, 0x000fc400078e0224ULL,
0x000000101b1b7824ULL, 0x100fe200078e0224ULL, 0x000000000e077faeULL, 0x0003e2000e901c46ULL,
0x0000001009097824ULL, 0x100fe400078e0224ULL, 0x000000101d1d7824ULL, 0x100fe200078e0224ULL,
0x0000000010197faeULL, 0x0003e2000e101c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0224ULL,
0x000000010b0b7824ULL, 0x000fe200030e060dULL, 0x00000000161b7faeULL, 0x0003e8000d901c46ULL,
0x0000000014097faeULL, 0x0003e8000d101c46ULL, 0x00000000121d7faeULL, 0x0003e8000c901c46ULL,
0x000000000a1f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000809107811ULL, 0x040fe400078fe8ffULL, 0x00000004090f7811ULL, 0x040fe400078fe8ffULL,
0x0000000c09117811ULL, 0x040fe200078fe8ffULL, 0x00000001100d7824ULL, 0x140fe200078e0209ULL,
0x00000018091a7811ULL, 0x040fe200078fe8ffULL, 0x0000000810187824ULL, 0x000fe200078e00ffULL,
0x0000001009167811ULL, 0x000fe200078fe8ffULL, 0x000000010f077824ULL, 0x100fe200078e0209ULL,
0x0000001c091c7811ULL, 0x000fe200078fe8ffULL, 0x000000080f127824ULL, 0x000fe200078e00ffULL,
0xfffffff818137812ULL, 0x000fe200078ee20dULL, 0x00000001110e7824ULL, 0x100fe200078e0209ULL,
0x0000001409187811ULL, 0x000fe200078fe8ffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000011a0d7824ULL, 0x100fe200078e0209ULL,
0x00000020091e7811ULL, 0x040fe200078fe8ffULL, 0x0000000118077824ULL, 0x140fe200078e0209ULL,
0xfffffff815157812ULL, 0x000fe200078ee20eULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0x0000002c09287811ULL, 0x040fe200078fe8ffULL, 0x000000081a227824ULL, 0x000fe200078e00ffULL,
0x0000002809237811ULL, 0x040fe200078fe8ffULL, 0x0000000116147824ULL, 0x140fe200078e0209ULL,
0xfffffff820197812ULL, 0x000fe200078ee207ULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0x0000002409207811ULL, 0x040fe200078fe8ffULL, 0x000000011c0e7824ULL, 0x140fe200078e0209ULL,
0xfffffff8221b7812ULL, 0x000fe200078ee20dULL, 0x000000081c1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee214ULL, 0x0000000120077824ULL, 0x140fe200078e0209ULL,
0x00000030092a7811ULL, 0x040fe200078fe8ffULL, 0x0000000820227824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee20eULL, 0x000000011e147824ULL, 0x140fe200078e0209ULL,
0x00000034092d7811ULL, 0x040fe200078fe8ffULL, 0x000000081e1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee207ULL, 0x00000001280e7824ULL, 0x140fe200078e0209ULL,
0x0000000909077211ULL, 0x000fe200078fe8ffULL, 0x0000000828297824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee214ULL, 0x00000001230d7824ULL, 0x100fe200078e0209ULL,
0x00000038092f7811ULL, 0x000fe200078fe8ffULL, 0x0000000823247824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x000000012a147824ULL, 0x040fe200078e0209ULL,
0x00000007070e7812ULL, 0x000fe200078ec0ffULL, 0x000000082a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff824277812ULL, 0x000fe200078ee20dULL, 0x000000010c247824ULL, 0x040fe200078e021eULL,
0x0000003c09317811ULL, 0x040fe200078fe8ffULL, 0x000000010c0f7824ULL, 0x040fe200078e020fULL,
0x0000000c090d7211ULL, 0x000fe200078fe8ffULL, 0x000000010c257824ULL, 0x040fe200078e0220ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee214ULL, 0x000000010c147824ULL, 0x000fe200078e0211ULL,
0x0ffffff80e077812ULL, 0x000fe200078ef809ULL, 0x00004000770e7824ULL, 0x000fc400078e0208ULL,
0x000000012d117824ULL, 0x100fe400078e0209ULL, 0x000000012f1e7824ULL, 0x000fe400078e0209ULL,
0x000000010c107824ULL, 0x040fe400078e0210ULL, 0x000000010c167824ULL, 0x040fe400078e0216ULL,
0x000000010c187824ULL, 0x040fe400078e0218ULL, 0x000000010c1a7824ULL, 0x000fc400078e021aULL,
0x000000010c217824ULL, 0x040fe400078e021cULL, 0x000000010c267824ULL, 0x040fe400078e0223ULL,
0x000000010c287824ULL, 0x040fe400078e0228ULL, 0x000000010c2c7824ULL, 0x040fe400078e022aULL,
0x000000010c2e7824ULL, 0x040fe400078e022dULL, 0x000000010c307824ULL, 0x000fc400078e022fULL,
0x000000010c327824ULL, 0x000fe400078e0231ULL, 0x0000000131097824ULL, 0x040fe400078e0209ULL,
0x0000000831207824ULL, 0x000fe400078e00ffULL, 0x000000082d1c7824ULL, 0x000fe400078e00ffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe400078ee209ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL, 0x000020000e2a7836ULL, 0x000fe20000000000ULL,
0x000000700c097812ULL, 0x000fe200078ef802ULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0x000000090a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x00000010132d7824ULL, 0x100fe200078e022aULL, 0x000000700e137812ULL, 0x000fe200078ef802ULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x0000001017317824ULL, 0x100fe200078e022aULL,
0x000000130a0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001012097824ULL, 0x000fe200078e022aULL,
0x0000007010177812ULL, 0x000fe200078ef802ULL, 0x0000008014127825ULL, 0x000fe200078e00ffULL,
0xfffffff82f1e7812ULL, 0x000fc600078ee21eULL, 0x000000010b0d7824ULL, 0x000fe200000e060dULL,
0x000000170a107210ULL, 0x000fe20007f1e0ffULL, 0x00000010152f7824ULL, 0x100fe400078e022aULL,
0x000000101d377824ULL, 0x000fe200078e022aULL, 0x00000070121d7812ULL, 0x000fe200078ef802ULL,
0x0000008016147825ULL, 0x000fc800078e00ffULL, 0x0000008018167825ULL, 0x000fc800078e00ffULL,
0x000000101f397824ULL, 0x100fe200078e022aULL, 0x00000070141f7812ULL, 0x000fe200078ef802ULL,
0x000000101c437824ULL, 0x100fe400078e022aULL, 0x000000010b117824ULL, 0x000fe200000e0611ULL,
0x0000001d0a1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001019337824ULL, 0x100fe400078e022aULL,
0x000000101b357824ULL, 0x000fe200078e022aULL, 0x00000070161b7812ULL, 0x000fe200078ef802ULL,
0x000000801a187825ULL, 0x000fc800078e00ffULL, 0x000000101e457824ULL, 0x100fe200078e022aULL,
0x0000007018237812ULL, 0x000fe200078ef802ULL, 0x000000010b0f7824ULL, 0x040fe200008e060fULL,
0x0000001f0a1e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001020477824ULL, 0x000fe400078e022aULL,
0x000000010b1d7824ULL, 0x000fe200000e0613ULL, 0x0000001b0a207210ULL, 0x000fe20007f1e0ffULL,
0x0000008021127825ULL, 0x000fc800078e00ffULL, 0x000000010b1f7824ULL, 0x000fe400008e0615ULL,
0x00000010223b7824ULL, 0x000fe200078e022aULL, 0x000000230a227210ULL, 0x000fe20007f5e0ffULL,
0x0000008024147825ULL, 0x000fc800078e00ffULL, 0x000000010b217824ULL, 0x000fe400000e0617ULL,
0x0000008025167825ULL, 0x000fe200078e00ffULL, 0x0000007012257812ULL, 0x000fc600078ef802ULL,
0x00000010273d7824ULL, 0x000fe200078e022aULL, 0x0000007014277812ULL, 0x000fe200078ef802ULL,
0x000000010b237824ULL, 0x000fe200010e0619ULL, 0x000000250a247210ULL, 0x000fe20007f1e0ffULL,
0x0000008026187825ULL, 0x000fe200078e00ffULL, 0x000000270a267210ULL, 0x000fc60007f3e0ffULL,
0x00000010293f7824ULL, 0x000fe200078e022aULL, 0x0000007016297812ULL, 0x000fe200078ef802ULL,
0x00000080281a7825ULL, 0x000fc800078e00ffULL, 0x000000102b417824ULL, 0x100fe200078e022aULL,
0x00000070182b7812ULL, 0x000fe200078ef802ULL, 0x000000010b257824ULL, 0x040fe200000e0613ULL,
0x000000290a287210ULL, 0x000fe20007f1e0ffULL, 0x000000010b277824ULL, 0x000fe200008e0615ULL,
0x000000701a157812ULL, 0x000fe200078ef802ULL, 0x0000001007077824ULL, 0x000fe200078e022aULL,
0x0000002b0a2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b297824ULL, 0x040fe200000e0617ULL,
0x000000150a1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000802c127825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e6000b901c46ULL,
0x000000802e147825ULL, 0x000fe200078e00ffULL, 0x00000070124f7812ULL, 0x000fe200078ef802ULL,
0x000000000e097faeULL, 0x0003e4000b901c46ULL, 0x000000010b2b7824ULL, 0x040fe200010e0619ULL,
0x00000070144d7812ULL, 0x000fe200078ef802ULL, 0x0000008030167825ULL, 0x000fe200078e00ffULL,
0x00000000102d7faeULL, 0x0003e4000b901c46ULL, 0x0000004d0a147210ULL, 0x000fe20007f3e0ffULL,
0x0000008032187825ULL, 0x000fe200078e00ffULL, 0x00000070164b7812ULL, 0x000fe200078ef802ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x000000010b1b7824ULL, 0x040fe200000e061bULL,
0x0000007018497812ULL, 0x000fe200078ef802ULL, 0x000000001e317faeULL, 0x0003e2000b901c46ULL,
0x0000004f0a127210ULL, 0x000fe20007f1e0ffULL, 0x000000010b157824ULL, 0x040fe200008e0615ULL,
0x0000004b0a167210ULL, 0x000fe20007f5e0ffULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x000000490a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b137824ULL, 0x000fc400000e0613ULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x000000010b177824ULL, 0x040fe400010e0617ULL,
0x000000010b0b7824ULL, 0x000fe200018e0619ULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x00000000283b7faeULL, 0x0003e8000b901c46ULL,
0x000000002a3d7faeULL, 0x0003e8000b901c46ULL, 0x000000001a3f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012417faeULL, 0x0003e8000b901c46ULL, 0x0000000014437faeULL, 0x0003e8000b901c46ULL,
0x0000000016457faeULL, 0x0003e8000b901c46ULL, 0x000000000a477faeULL, 0x0003e4000b901c46ULL,
0x000000027a7a7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff737424ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x000000757a00720cULL, 0x000fda0003f06070ULL, 0x00009600ff028b82ULL, 0x000ea20000000800ULL,
0x0000000272078824ULL, 0x002fce00078e00ffULL, 0x00009200ff0a8b82ULL, 0x000e620000000a00ULL,
0x0000000207078224ULL, 0x004fc800078e027aULL, 0x00000004070a8825ULL, 0x002fca00078e000aULL,
0x000000060a738981ULL, 0x000322000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fd80008011604ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01a60005080075a7ULL, 0x000e62000800017fULL, 0x00000001745b7824ULL, 0x000fe400078e0a03ULL,
0x0000000406077c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff5b7819ULL, 0x000fe2000001165bULL,
0x00008e00ff907b82ULL, 0x000ea40000000a00ULL, 0x0000000407907825ULL, 0x004fe200078e0090ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x000000060a097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e0bULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000902027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01a60005080075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000002077027824ULL, 0x002fc800078e0202ULL,
0x0000000102067836ULL, 0x000fe20000000000ULL, 0x00000004ff047819ULL, 0x000fc80000011602ULL,
0x0ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000001f02047812ULL, 0x000fc600078ec0ffULL,
0x0000000105097824ULL, 0x000fe400078e0206ULL, 0x0000000102077824ULL, 0x000fe400078e0205ULL,
0x00000010040c7824ULL, 0x040fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x00000010040a7824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000805057836ULL, 0x000fe20000000000ULL, 0x000001f00c097812ULL, 0x000fe200078ee209ULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x000001f00a077812ULL, 0x000fe200078ee207ULL,
0x0000000102027824ULL, 0x000fc400078e0205ULL, 0x0000001009097824ULL, 0x100fe400078e0208ULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x0000000f02027812ULL, 0x000fe200078ec0ffULL,
0x0000000106057824ULL, 0x000fe200078e0205ULL, 0x00000000090c7984ULL, 0x000e620000000c00ULL,
0x0000001004157824ULL, 0x000fc600078e00ffULL, 0x0000000007107984ULL, 0x000ea20000000c00ULL,
0x0000000f05047812ULL, 0x000fe400078ec0ffULL, 0x000001f00b057812ULL, 0x000fe400078ee202ULL,
0x000001f0150b7812ULL, 0x000fc600078ee204ULL, 0x0000001005057824ULL, 0x100fe400078e0208ULL,
0x000000100b027824ULL, 0x000fe400078e0208ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x004fc400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001407007388ULL, 0x000fe20000000c00ULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x0000001809007388ULL, 0x000fe80000000c00ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x0000000005107984ULL, 0x000ea20000000c00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c05007388ULL, 0x0003e80000000c00ULL,
0x0000000c02007388ULL, 0x0003e20000000c00ULL, 0x01a6000b080a79a7ULL, 0x0002a4000850003fULL,
0x0000000000047805ULL, 0x002fce0000015200ULL, 0x01a6000b080075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000902027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x01a6000b080075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00009600ff057b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x0000010078787836ULL, 0x000fe40000000000ULL, 0x3db504f36c6c7820ULL, 0x010fe20000410000ULL,
0x0000000877027824ULL, 0x140fe200078e0208ULL, 0x00000000006e7805ULL, 0x000fe2000001ff00ULL,
0xffffffff035a7836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x00000009030a7836ULL, 0x000fe40000000000ULL, 0x0000002077717824ULL, 0x000fc400078e0208ULL,
0x0000000572727224ULL, 0x002fce00078e02ffULL, 0x00009000ff047b82ULL, 0x002e620000000a00ULL,
0x000000026f077836ULL, 0x000fe20000000000ULL, 0x000000016e587812ULL, 0x000fe200078e0cffULL,
0x000001006f0b7824ULL, 0x000fe400078e0278ULL, 0x0000007300737224ULL, 0x010fe200078e02ffULL,
0x000000700700720cULL, 0x000fe40003f06070ULL, 0x000000400b0c7812ULL, 0x000fca00078ec0ffULL,
0x00000001790c7824ULL, 0x000fe400078e020cULL, 0x0000008073047825ULL, 0x002fc800078e0004ULL,
0x0000000c002c8947ULL, 0x000fea0003800000ULL, 0x00000003ff2b7819ULL, 0x004fe20000011609ULL,
0x0000400077597824ULL, 0x000fe200078e0208ULL, 0x0000000b741c7248ULL, 0x000fc60007fe0000ULL,
0x000000042b077836ULL, 0x000fe40000000000ULL, 0x000000082b137836ULL, 0x000fe40000000000ULL,
0x0000000107067824ULL, 0x040fe400078e0209ULL, 0x00000008070d7824ULL, 0x000fe400078e00ffULL,
0x000000011c1c7824ULL, 0x000fe400078e0a0bULL, 0x00000001130f7824ULL, 0x040fe200078e0209ULL,
0xfffffff80d247812ULL, 0x000fe200078ee206ULL, 0x0000000813267824ULL, 0x000fe200078e00ffULL,
0x0000001c0700720cULL, 0x000fe20003fa6070ULL, 0x00000010090d7824ULL, 0x000fc400078e00ffULL,
0x000000012b067824ULL, 0x100fe200078e020cULL, 0xfffffff826267812ULL, 0x000fe200078ee20fULL,
0x00000001070e7824ULL, 0x000fe200078e020cULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000d06197212ULL, 0x000fc600078efcffULL, 0x000000102b177836ULL, 0x000fe20000000000ULL,
0x0000000d0e117212ULL, 0x000fe200078efcffULL, 0x0000000c2b157836ULL, 0x000fe20000000000ULL,
0x0000001904187210ULL, 0x000fe20007f1e0ffULL, 0x00000001170e7824ULL, 0x140fe200078e0209ULL,
0x0000001104067210ULL, 0x000fe20007f3e0ffULL, 0x00000008171d7824ULL, 0x000fe200078e00ffULL,
0x0000001c1500720cULL, 0x040fe20003f46070ULL, 0x0000000115107824ULL, 0x040fe400078e0209ULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d2a7812ULL, 0x000fe200078ee20eULL,
0x00000001130e7824ULL, 0x000fc400078e020cULL, 0x0000000105197824ULL, 0x040fe200000e0607ULL,
0xfffffff81b287812ULL, 0x000fe200078ee210ULL, 0x0000000105077824ULL, 0x000fe200008e060fULL,
0x0000001c1300720cULL, 0x080fe20003f26070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001c1700720cULL, 0x000fc60003f06070ULL, 0x0000000115107824ULL, 0x100fe200078e020cULL,
0x0000000d0e157212ULL, 0x000fe200078efcffULL, 0x0000000117127824ULL, 0x000fe400078e020cULL,
0x000000142b217836ULL, 0x000fe20000000000ULL, 0x00000015040e7210ULL, 0x000fe20007f7e0ffULL,
0x000000182b257836ULL, 0x000fe40000000000ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000d101d7212ULL, 0x000fc600078efcffULL,
0x0000000121167824ULL, 0x100fe200078e020cULL, 0x0000000d12157212ULL, 0x000fe200078efcffULL,
0x00000001251a7824ULL, 0x000fe200078e020cULL, 0x0000001d04147210ULL, 0x000fe20007f9e0ffULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000d161f7212ULL, 0x000fc600078efcffULL, 0x00000001050f7824ULL, 0x040fe200018e060fULL,
0x0000001504107210ULL, 0x000fe20007f7e0ffULL, 0x0000000105157824ULL, 0x040fe200020e0611ULL,
0x0000000d1a1d7212ULL, 0x000fe200078efcffULL, 0x0000001c2b297836ULL, 0x000fe20000000000ULL,
0x0000001f04127210ULL, 0x000fe20007f9e0ffULL, 0x0000000105117824ULL, 0x000fe200018e0613ULL,
0x0000001d04167210ULL, 0x000fe20007f7e0ffULL, 0x00000001291a7824ULL, 0x000fe400078e020cULL,
0x000000012b1e7824ULL, 0x000fc400078e0209ULL, 0x0000000105137824ULL, 0x000fe200020e0617ULL,
0x0000001c2b00720cULL, 0x080fe20003f86070ULL, 0x0000000105177824ULL, 0x000fe200018e061bULL,
0x000000071e1e7812ULL, 0x000fe200078ec0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000001c2100720cULL, 0x000fe40003f66070ULL, 0x0ffffff81e207812ULL, 0x000fe200078ef809ULL,
0x000000202b2d7836ULL, 0x000fe20000000000ULL, 0x0000000d1a1f7212ULL, 0x000fe200078efcffULL,
0x00002000581d7824ULL, 0x000fc400078e0259ULL, 0x000000012d1e7824ULL, 0x000fe200078e020cULL,
0x0000001f041a7210ULL, 0x000fe20007fde0ffULL, 0x0000000121227824ULL, 0x040fe400078e0209ULL,
0x0000000821217824ULL, 0x000fe400078e00ffULL, 0x000000801e1e7825ULL, 0x000fc600078e00ffULL,
0xfffffff8212c7812ULL, 0x000fe200078ee222ULL, 0x000020001d1d7836ULL, 0x000fe20000000000ULL,
0x0000000d1e217212ULL, 0x000fe200078efcffULL, 0x000000242b2f7836ULL, 0x000fe40000000000ULL,
0x0000001020237824ULL, 0x000fe400078e021dULL, 0x000000012f207824ULL, 0x000fe400078e020cULL,
0x00000001051b7824ULL, 0x000fe200030e061bULL, 0x00000021041e7210ULL, 0x000fe20007fde0ffULL,
0x000000282b317836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000e101c46ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000001c2500720cULL, 0x000fc60003f86070ULL, 0x0000000131227824ULL, 0x000fe400078e020cULL,
0x0000000125277824ULL, 0x040fe400078e0209ULL, 0x00000008252e7824ULL, 0x000fe200078e00ffULL,
0x0000000d20257212ULL, 0x080fe200078efcffULL, 0x00000001051f7824ULL, 0x040fe400030e061fULL,
0x0000008022187825ULL, 0x002fe200078e00ffULL, 0x0000002504207210ULL, 0x000fe40007fde0ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee227ULL, 0x0000001024237824ULL, 0x000fe200078e021dULL,
0x0000000d18257212ULL, 0x000fe200078efcffULL, 0x0000000105217824ULL, 0x000fc400030e0621ULL,
0x000000012d247824ULL, 0x000fe200078e0209ULL, 0x0000002504187210ULL, 0x000fe20007fde0ffULL,
0x0000001026257824ULL, 0x000fe200078e021dULL, 0x0000000006237faeULL, 0x0003e2000e901c46ULL,
0x0000002c2b337836ULL, 0x000fe20000000000ULL, 0x0000001c2900720cULL, 0x080fe20003fa6070ULL,
0x000000012f267824ULL, 0x100fe200078e0209ULL, 0x000000000e257faeULL, 0x0005e2000c901c46ULL,
0x0000001c2d00720cULL, 0x040fe20003f26070ULL, 0x000000082d2d7824ULL, 0x000fe400078e00ffULL,
0x0000000129227824ULL, 0x000fc400078e0209ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff82d247812ULL, 0x000fe200078ee224ULL, 0x0000001028237824ULL, 0x002fe400078e021dULL,
0x0000000133067824ULL, 0x000fe200078e020cULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x000000302b2d7836ULL, 0x000fe20000000000ULL, 0x0000000014237faeULL, 0x0003e2000d101c46ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000001c2f00720cULL, 0x000fc60003f46070ULL,
0x000000102a0f7824ULL, 0x004fe200078e021dULL, 0x0000000d06277212ULL, 0x000fe200078efcffULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x000000012d0e7824ULL, 0x000fe200078e020cULL,
0x00000000100f7faeULL, 0x0005e2000c101c46ULL, 0x0000000105197824ULL, 0x000fe200030e0619ULL,
0xfffffff82f267812ULL, 0x000fe200078ee226ULL, 0x000000102c157824ULL, 0x002fe200078e021dULL,
0x0000002704067210ULL, 0x000fe20007fde0ffULL, 0x000000342b2f7836ULL, 0x000fc40000000000ULL,
0x000000102e237824ULL, 0x000fe200078e021dULL, 0x0000000012157faeULL, 0x0003e2000d901c46ULL,
0x0000000105077824ULL, 0x000fe200030e0607ULL, 0x0000001c2d00720cULL, 0x080fe20003f66070ULL,
0x0000001022257824ULL, 0x000fe200078e021dULL, 0x0000000016237faeULL, 0x000fe2000e101c46ULL,
0x000000800e0e7825ULL, 0x004fe200078e00ffULL, 0x0000001c3300720cULL, 0x080fe40003f86070ULL,
0x000000001a257faeULL, 0x0005e2000e901c46ULL, 0x000000012f107824ULL, 0x000fe200078e020cULL,
0x0000001c3100720cULL, 0x000fe20003fa6070ULL, 0x000000382b357836ULL, 0x000fe20000000000ULL,
0x0000000d0e137212ULL, 0x002fe200078efcffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000001304127210ULL, 0x000fe20007fde0ffULL, 0x0000001024277824ULL, 0x000fe200078e021dULL,
0x0000000d10157212ULL, 0x000fe200078efcffULL, 0x0000000131147824ULL, 0x000fe400078e0209ULL,
0x0000000105137824ULL, 0x000fe200030e060fULL, 0x000000001e277faeULL, 0x000fe2000c901c46ULL,
0x0000001026297824ULL, 0x000fe200078e021dULL, 0x0000001c3500720cULL, 0x080fe20003f26070ULL,
0x0000000831317824ULL, 0x000fe400078e00ffULL, 0x00000001330f7824ULL, 0x140fe200078e0209ULL,
0x0000000020297faeULL, 0x0003e2000d101c46ULL, 0x00000008331a7824ULL, 0x004fe200078e00ffULL,
0xfffffff831167812ULL, 0x000fe200078ee214ULL, 0x0000003c2b2b7836ULL, 0x000fe20000000000ULL,
0x0000001c2f00720cULL, 0x080fe20003f46070ULL, 0x000000012d107824ULL, 0x140fe200078e0209ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x0000001c2b00720cULL, 0x000fe20003f06070ULL, 0x00000001350e7824ULL, 0x000fe200078e020cULL,
0x0000001504147210ULL, 0x000fe20007fde0ffULL, 0x000000012f1b7824ULL, 0x000fe200078e0209ULL,
0xfffffff82d1c7812ULL, 0x000fe200078ee210ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000012b107824ULL, 0x000fe200078e020cULL, 0x0000000d0e177212ULL, 0x000fe200078efcffULL,
0x000000082f207824ULL, 0x002fe400078e00ffULL, 0x0000000105157824ULL, 0x000fe200030e0611ULL,
0x00000017040e7210ULL, 0x000fe20007fde0ffULL, 0x000000012b1f7824ULL, 0x040fe200078e0209ULL,
0xfffffff8200c7812ULL, 0x000fe200078ee21bULL, 0x000000082b227824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff822207812ULL, 0x000fe200078ee21fULL,
0x00000001351e7824ULL, 0x040fe200078e0209ULL, 0x0000000d101f7212ULL, 0x000fe200078efcffULL,
0x0000000835357824ULL, 0x000fe400078e00ffULL, 0x00000001050f7824ULL, 0x000fe200030e060fULL,
0x0000001f04047210ULL, 0x000fe20007fde0ffULL, 0x00000010160d7824ULL, 0x100fe200078e021dULL,
0xfffffff8351e7812ULL, 0x000fe200078ee21eULL, 0x000000101a177824ULL, 0x100fe400078e021dULL,
0x000000101c1b7824ULL, 0x100fe200078e021dULL, 0x00000000180d7faeULL, 0x0003e2000e901c46ULL,
0x000000100c1f7824ULL, 0x000fc400078e021dULL, 0x000000101e217824ULL, 0x100fe200078e021dULL,
0x0000000006177faeULL, 0x0003e2000e101c46ULL, 0x00000010201d7824ULL, 0x000fe400078e021dULL,
0x0000000105057824ULL, 0x000fe200030e0611ULL, 0x00000000121b7faeULL, 0x0003e8000d901c46ULL,
0x00000000141f7faeULL, 0x0003e8000d101c46ULL, 0x000000000e217faeULL, 0x0003e8000c901c46ULL,
0x00000000041d7faeULL, 0x0003e2000c101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x00000004090d7811ULL, 0x004fe200078fe8ffULL, 0x0000400077597824ULL, 0x000fe200078e0208ULL,
0x00000008090e7811ULL, 0x040fe400078fe8ffULL, 0x0000001809167811ULL, 0x000fe200078fe8ffULL,
0x000000010d067824ULL, 0x100fe200078e0209ULL, 0x0000000c09107811ULL, 0x000fe200078fe8ffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0x0000001009127811ULL, 0x040fe200078fe8ffULL,
0x000000010e077824ULL, 0x140fe200078e0209ULL, 0x0000001409147811ULL, 0x040fe200078fe8ffULL,
0x000000080e267824ULL, 0x000fe200078e00ffULL, 0xfffffff80f247812ULL, 0x000fe200078ee206ULL,
0x0000000116117824ULL, 0x140fe200078e0209ULL, 0x00000028091e7811ULL, 0x040fe200078fe8ffULL,
0x0000000816367824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee207ULL,
0x0000000110067824ULL, 0x140fe200078e0209ULL, 0x0000001c09187811ULL, 0x040fe200078fe8ffULL,
0x0000000810137824ULL, 0x000fe200078e00ffULL, 0x00000020091a7811ULL, 0x040fe200078fe8ffULL,
0x0000000112077824ULL, 0x140fe200078e0209ULL, 0x00000024091c7811ULL, 0x040fe200078fe8ffULL,
0x0000000812327824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee211ULL,
0x00000001140f7824ULL, 0x140fe200078e0209ULL, 0xfffffff813287812ULL, 0x000fe200078ee206ULL,
0x0000000814347824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee207ULL,
0x000000011e117824ULL, 0x140fe200078e0209ULL, 0x00000038092e7811ULL, 0x040fe200078fe8ffULL,
0x000000081e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee20fULL,
0x0000000118067824ULL, 0x140fe200078e0209ULL, 0x0000002c09207811ULL, 0x040fe200078fe8ffULL,
0x0000000818137824ULL, 0x000fe200078e00ffULL, 0x00000030092a7811ULL, 0x040fe200078fe8ffULL,
0x000000011a077824ULL, 0x140fe200078e0209ULL, 0x00000034092c7811ULL, 0x000fe200078fe8ffULL,
0x000000081a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee211ULL,
0x000000011c0f7824ULL, 0x140fe200078e0209ULL, 0xfffffff813387812ULL, 0x000fe200078ee206ULL,
0x000000081c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee207ULL,
0x000000012e117824ULL, 0x000fc400078e0209ULL, 0x000000082e467824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20fULL, 0x0000000120067824ULL, 0x140fe400078e0209ULL,
0x0000000820137824ULL, 0x000fe200078e00ffULL, 0xfffffff846467812ULL, 0x000fe200078ee211ULL,
0x000000012a077824ULL, 0x140fe200078e0209ULL, 0x0000003c09117811ULL, 0x040fe200078fe8ffULL,
0x000000082a427824ULL, 0x000fe200078e00ffULL, 0xfffffff813407812ULL, 0x000fe200078ee206ULL,
0x000000012c0f7824ULL, 0x040fe200078e0209ULL, 0x0000000c09067211ULL, 0x000fe200078fe8ffULL,
0x000000082c447824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee207ULL,
0x000000010d0d7824ULL, 0x100fe200078e020cULL, 0x0000000909077211ULL, 0x040fe200078fe8ffULL,
0x000000010e0e7824ULL, 0x100fe200078e020cULL, 0xfffffff844447812ULL, 0x000fe200078ee20fULL,
0x00000010090f7824ULL, 0x000fe200078e00ffULL, 0x0000000707227812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fc400078e020cULL, 0x0000000112127824ULL, 0x100fe200078e020cULL,
0x000000700f4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000114147824ULL, 0x100fe200078e020cULL,
0x0ffffff822227812ULL, 0x000fe200078ef809ULL, 0x0000000116167824ULL, 0x100fe400078e020cULL,
0x0000000118187824ULL, 0x100fe400078e020cULL, 0x000000011a1a7824ULL, 0x100fe400078e020cULL,
0x000000011c1c7824ULL, 0x000fc400078e020cULL, 0x000000011e1e7824ULL, 0x100fe400078e020cULL,
0x0000000120207824ULL, 0x100fe400078e020cULL, 0x000000012a2a7824ULL, 0x100fe400078e020cULL,
0x000000012c2c7824ULL, 0x100fe400078e020cULL, 0x000000012e2e7824ULL, 0x100fe400078e020cULL,
0x0000000111307824ULL, 0x000fc400078e020cULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x00002000580c7824ULL, 0x000fe400078e0259ULL, 0x0000000111137824ULL, 0x040fe400078e0209ULL,
0x0000000811487824ULL, 0x000fe200078e00ffULL, 0x0000004b06117212ULL, 0x080fe200078efcffULL,
0x000020000c497836ULL, 0x000fe40000000000ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000001104067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff848487812ULL, 0x000fe200078ee213ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000004b0c117212ULL, 0x000fc600078efcffULL,
0x0000000105077824ULL, 0x000fe200000e0607ULL, 0x00000011040c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000004b0e157212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000015040e7210ULL, 0x000fe40007f1e0ffULL,
0x0000004b10197212ULL, 0x000fe200078efcffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x00000001050f7824ULL, 0x040fe200000e060fULL, 0x0000001904107210ULL, 0x000fe20007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004b16197212ULL, 0x080fe400078efcffULL,
0x0000004b141b7212ULL, 0x080fe200078efcffULL, 0x0000000105117824ULL, 0x000fe200000e0611ULL,
0x0000001904167210ULL, 0x000fe20007f5e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004b121d7212ULL, 0x080fe400078efcffULL, 0x0000001b04147210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004b18237212ULL, 0x000fc600078efcffULL,
0x00000001050d7824ULL, 0x000fe200008e060dULL, 0x0000001d04127210ULL, 0x000fe20007f3e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000004b1a257212ULL, 0x000fc600078efcffULL,
0x00000010222b7824ULL, 0x000fe200078e0249ULL, 0x0000004b1c277212ULL, 0x080fe200078efcffULL,
0x0000000105157824ULL, 0x040fe200000e0615ULL, 0x0000002304227210ULL, 0x000fe20007f1e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000062b7faeULL, 0x0003e6000b901c46ULL, 0x00000010242d7824ULL, 0x000fe200078e0249ULL,
0x0000004b1e297212ULL, 0x000fe200078efcffULL, 0x0000000105137824ULL, 0x000fe200008e0613ULL,
0x0000002504247210ULL, 0x000fe20007f3e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000000c2d7faeULL, 0x0003e6000b901c46ULL, 0x00000010262f7824ULL, 0x000fc400078e0249ULL,
0x0000000105237824ULL, 0x040fe200000e0619ULL, 0x0000002704267210ULL, 0x000fe20007f1e0ffULL,
0x0000000105257824ULL, 0x040fe200008e061bULL, 0x0000004b201b7212ULL, 0x080fe200078efcffULL,
0x0000001028317824ULL, 0x000fe200078e0249ULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000105177824ULL, 0x040fe200010e0617ULL, 0x0000002904287210ULL, 0x000fe20007f5e0ffULL,
0x0000000105277824ULL, 0x000fe200000e061dULL, 0x0000001b04207210ULL, 0x000fe20007f1e0ffULL,
0x000000802a187825ULL, 0x000fe200078e00ffULL, 0x0000000010317faeULL, 0x0003e6000b901c46ULL,
0x000000802c1a7825ULL, 0x000fe200078e00ffULL, 0x0000004b18517212ULL, 0x000fc600078efcffULL,
0x0000000105297824ULL, 0x000fe200010e061fULL, 0x0000004b1a4f7212ULL, 0x000fe200078efcffULL,
0x000000802e1c7825ULL, 0x000fc600078e00ffULL, 0x0000004f041a7210ULL, 0x000fe20007f3e0ffULL,
0x00000080301e7825ULL, 0x000fe200078e00ffULL, 0x0000004b1c4d7212ULL, 0x000fc600078efcffULL,
0x0000001032337824ULL, 0x100fe200078e0249ULL, 0x0000004b1e4b7212ULL, 0x000fe200078efcffULL,
0x0000001034357824ULL, 0x100fe200078e0249ULL, 0x0000004d041c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001036377824ULL, 0x000fe200078e0249ULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x0000000105217824ULL, 0x000fe200000e0621ULL, 0x0000005104187210ULL, 0x000fe20007f1e0ffULL,
0x0000001038397824ULL, 0x100fe200078e0249ULL, 0x0000004b04047210ULL, 0x000fe20007f7e0ffULL,
0x000000103a3b7824ULL, 0x100fe200078e0249ULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x000000103c3d7824ULL, 0x000fc400078e0249ULL, 0x000000103e3f7824ULL, 0x100fe200078e0249ULL,
0x0000000016377faeULL, 0x0003e2000b901c46ULL, 0x0000001040417824ULL, 0x100fe400078e0249ULL,
0x0000001042437824ULL, 0x000fe200078e0249ULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x0000000105197824ULL, 0x040fe400000e0619ULL, 0x0000001044457824ULL, 0x000fe200078e0249ULL,
0x00000000243b7faeULL, 0x0003e2000b901c46ULL, 0x00000001051b7824ULL, 0x000fc400008e061bULL,
0x0000001046477824ULL, 0x000fe200078e0249ULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x00000001051d7824ULL, 0x040fe400010e061dULL, 0x0000001048497824ULL, 0x000fe200078e0249ULL,
0x00000000283f7faeULL, 0x0003e2000b901c46ULL, 0x0000000105057824ULL, 0x000fc600018e061fULL,
0x0000000020417faeULL, 0x0003e8000b901c46ULL, 0x0000000018437faeULL, 0x0003e8000b901c46ULL,
0x000000001a457faeULL, 0x0003e8000b901c46ULL, 0x000000001c477faeULL, 0x0003e8000b901c46ULL,
0x0000000004497faeULL, 0x0003e4000b901c46ULL, 0x000000027a7a7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff737424ULL, 0x000fc600078e00ffULL,
0x000000757a00720cULL, 0x000fda0003f06070ULL, 0x00009200ff048b82ULL, 0x002e620000000a00ULL,
0x0000000272078824ULL, 0x000fe200078e027aULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff6d7224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000407048825ULL, 0x002fe200078e0004ULL,
0x0000000000067805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000604738981ULL, 0x000322000c1e1900ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fc4000001ff00ULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000047805ULL, 0x002fce000001ff00ULL, 0xfffffff809107812ULL, 0x040fe200078ec0ffULL,
0x000020006e6a7824ULL, 0x000fe200078e0259ULL, 0x0000000809147812ULL, 0x000fe200078ec0ffULL,
0x000000016d6b7836ULL, 0x000fe20000000000ULL, 0x0000000710127812ULL, 0x000fe200078ef809ULL,
0x000020006a6a7836ULL, 0x000fe20000000000ULL, 0x0000000714177812ULL, 0x000fe200078ef809ULL,
0x00000020097c7836ULL, 0x000fe40000000000ULL, 0x0000000112107824ULL, 0x040fe200078e026dULL,
0x0000001017657812ULL, 0x000fe200078efcffULL, 0x0000000812117824ULL, 0x000fe200078e00ffULL,
0xfffffff87c7c7812ULL, 0x000fe200078ec0ffULL, 0x0000000812137824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x000fe200078e026bULL, 0xfffffff811117812ULL, 0x000fe200078ee210ULL,
0x0000001017147824ULL, 0x040fe200078e00ffULL, 0x00000004ff107819ULL, 0x000fe20000011609ULL,
0x0000001017677824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee212ULL,
0x00000010115c7824ULL, 0x000fe200078e026aULL, 0x000000077c7c7812ULL, 0x000fe200078ef809ULL,
0x000000026d107824ULL, 0x000fe400078e0210ULL, 0x0000001013607824ULL, 0x000fc400078e026aULL,
0x000000005c5c783bULL, 0x000e620000000200ULL, 0x0000000117117824ULL, 0x100fe400078e0210ULL,
0x000000087c157824ULL, 0x040fe200078e00ffULL, 0x000000006060783bULL, 0x000ea20000000200ULL,
0x0000000165127824ULL, 0x040fe200078e0210ULL, 0xfffffff014117812ULL, 0x000fe200078ee211ULL,
0x000000017c147824ULL, 0x040fe400078e026dULL, 0x0000001065137824ULL, 0x000fe400078e00ffULL,
0x0000001011117824ULL, 0x000fe200078e0208ULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x0000000210147836ULL, 0x000fe20000000000ULL, 0xfffffff013137812ULL, 0x000fe200078ee212ULL,
0x000000017c6b7824ULL, 0x000fe200078e026bULL, 0x000000001154783bULL, 0x000ee20000000200ULL,
0x0000000117167824ULL, 0x000fc400078e0214ULL, 0x0000001013137824ULL, 0x000fe400078e0208ULL,
0x0000000165147824ULL, 0x040fe200078e0214ULL, 0xfffffff067177812ULL, 0x000fe200078ee216ULL,
0x0000001065657824ULL, 0x000fe200078e00ffULL, 0x000000001318783bULL, 0x000ae20000000200ULL,
0x000000087c7c7824ULL, 0x000fe400078e00ffULL, 0x0000001017177824ULL, 0x000fe400078e0208ULL,
0x0000001015647824ULL, 0x000fe200078e026aULL, 0xfffffff87c6b7812ULL, 0x000fe200078ee26bULL,
0x000000026d6d7836ULL, 0x000fe20000000000ULL, 0xfffffff065137812ULL, 0x020fc600078ee214ULL,
0x000000106b6b7824ULL, 0x000fe200078e026aULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x0000001013137824ULL, 0x000fe200078e0208ULL, 0x000000086d00780cULL, 0x000fe40003f05270ULL,
0x00000010ff107819ULL, 0x102fe4000001165fULL, 0x0000ffff5f167812ULL, 0x000fe400078ec0ffULL,
0x000000ff10107812ULL, 0x000fe400078ec0ffULL, 0x00000018ff127819ULL, 0x000fc4000001165fULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000012ff12723eULL, 0x000fe200020006ffULL, 0x20000010ff117230ULL, 0x000fe20000004100ULL,
0x00000008ff107819ULL, 0x000fe40000011616ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000012ff127230ULL, 0x000fe20000004100ULL, 0x00000010ff10723eULL, 0x000fe200020006ffULL,
0x000000001714783bULL, 0x000e620000000200ULL, 0x0000ffff637e7812ULL, 0x004fe200078ec0ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff127819ULL, 0x000fe20000011612ULL,
0x20000010ff107230ULL, 0x000fe20000004100ULL, 0x00000010ff117819ULL, 0x000fc40000011611ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff687819ULL, 0x000fe40000011610ULL,
0x0000105412697816ULL, 0x000fe40000000011ULL, 0x0000105468687816ULL, 0x000fe2000000005fULL,
0x000000001310783bULL, 0x000ea20000000200ULL, 0x00000018ff5f7819ULL, 0x000fe40000011663ULL,
0x00000018ff807819ULL, 0x000fc40000011660ULL, 0x0000005fff7b723eULL, 0x000fe200020006ffULL,
0x00000068540c723cULL, 0x008fe2000004180cULL, 0x00000010ff5f7819ULL, 0x000fe40000011663ULL,
0x000000ff63637812ULL, 0x000fe200078ec0ffULL, 0x2000007bff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff5f7b7812ULL, 0x000fe200078ec0ffULL, 0x000000681804723cULL, 0x000fe20000041804ULL,
0x00000008ff5f7819ULL, 0x000fe4000001167eULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe2000001167dULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000000ff607e7812ULL, 0x000fe200078ec0ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe4000001167bULL,
0x00000010ff687819ULL, 0x000fc4000001165fULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x000010547c7d7816ULL, 0x000fe4000000007bULL, 0x00001054687c7816ULL, 0x000fe40000000063ULL,
0x000000006b68783bULL, 0x000ee20000000200ULL, 0x00000080ffa0723eULL, 0x000fe400020006ffULL,
0x00000018ff997819ULL, 0x000fe40000011662ULL, 0x0000007c140c723cULL, 0x002fe2000004180cULL,
0x00000010ff9d7819ULL, 0x000fc40000011664ULL, 0x00000018ff5f7819ULL, 0x000fe40000011664ULL,
0x000000ff64837812ULL, 0x040fe200078ec0ffULL, 0x0000007c1004723cULL, 0x004fe20000041804ULL,
0x0000ffff649e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff629f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff957819ULL, 0x000fe40000011662ULL, 0x000000ff5c7d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001165cULL, 0x0000007dff7f723eULL, 0x000fe400020006ffULL,
0x0000ffff62647812ULL, 0x000fe400078ec0ffULL, 0x0000007cff62723eULL, 0x000fe400020006ffULL,
0x000000ff65937812ULL, 0x000fe400078ec0ffULL, 0x00000010ff967819ULL, 0x100fe20000011665ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000018ff927819ULL, 0x000fc40000011665ULL,
0x0000ffff65987812ULL, 0x000fe400078ec0ffULL, 0x000000ff66947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff9b7819ULL, 0x000fe40000011667ULL, 0x00000010ff867819ULL, 0x108fe40000011668ULL,
0x00000018ff8c7819ULL, 0x000fe40000011668ULL, 0x000000ff688b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff68807812ULL, 0x000fe400078ec0ffULL, 0x0000007eff68723eULL, 0x000fe200020006ffULL,
0x200000a0ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff817819ULL, 0x100fe40000011669ULL,
0x00000018ff8e7819ULL, 0x000fe40000011669ULL, 0x000000ff698d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff69847812ULL, 0x000fe200078ec0ffULL, 0x2000007fff697230ULL, 0x000fe20000004100ULL,
0x00000099ffa0723eULL, 0x000fe200020006ffULL, 0x20000068ff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fc4000001165cULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff857819ULL, 0x100fe4000001166aULL, 0x00000018ff887819ULL, 0x000fe4000001166aULL,
0x000000ff6a877812ULL, 0x000fc400078ec0ffULL, 0x0000ffff6a7c7812ULL, 0x000fe400078ec0ffULL,
0x0000009fff6a723eULL, 0x000fe400020006ffULL, 0x00000018ff657819ULL, 0x000fe40000011667ULL,
0x000000ff67827812ULL, 0x040fe400078ec0ffULL, 0x0000ffff679c7812ULL, 0x000fe400078ec0ffULL,
0x00000068ff68723eULL, 0x000fc400020006ffULL, 0x00000010ff677819ULL, 0x000fe40000011660ULL,
0x0000ffff608f7812ULL, 0x000fe400078ec0ffULL, 0x0000005cff9f723eULL, 0x000fe200020006ffULL,
0x200000a0ff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe40000011661ULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x2000009fff9f7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fc40000011666ULL, 0x00000018ff977819ULL, 0x000fe40000011666ULL,
0x0000ffff669a7812ULL, 0x000fe400078ec0ffULL, 0x0000005fff99723eULL, 0x000fe200020006ffULL,
0x2000006aff5f7230ULL, 0x000fe20000004100ULL, 0x00000094ffa0723eULL, 0x000fe200020006ffULL,
0x20000068ff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff667819ULL, 0x000fe20000011661ULL,
0x20000093ff947230ULL, 0x000fe20000004100ULL, 0x000000ff617b7812ULL, 0x040fe200078ec0ffULL,
0x200000a0ff937230ULL, 0x000fe20000004100ULL, 0x0000ffff61617812ULL, 0x000fe200078ec0ffULL,
0x20000099ff997230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fc400078ec0ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x000000ff60607812ULL, 0x000fe400078ec0ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000008ff8f7819ULL, 0x000fe4000001168fULL,
0x00000092ff68723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x00000008ffa07819ULL, 0x000fe20000011661ULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x00000097ff92723eULL, 0x000fe200020006ffULL, 0x20000083ff977230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fe4000001166aULL,
0x0000008fff83723eULL, 0x000fe200020006ffULL, 0x20000082ff8f7230ULL, 0x000fe20000004100ULL,
0x00000008ff9e7819ULL, 0x000fe2000001169eULL, 0x20000067ff827230ULL, 0x000fe20000004100ULL,
0x000000ff9d9d7812ULL, 0x000fe200078ec0ffULL, 0x20000060ff677230ULL, 0x000fe20000004100ULL,
0x0000105462617816ULL, 0x000fe20000000061ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x000000ff96627812ULL, 0x000fc400078ec0ffULL, 0x00000010ff607819ULL, 0x000fe40000011669ULL,
0x00000010ff9f7819ULL, 0x000fe4000001169fULL, 0x0000009eff9e723eULL, 0x000fe400020006ffULL,
0x0000009dff69723eULL, 0x000fe400020006ffULL, 0x00000062ff9d723eULL, 0x000fe200020006ffULL,
0x2000009eff967230ULL, 0x000fe20000004100ULL, 0x000010549f607816ULL, 0x000fe20000000060ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fc400078ec0ffULL,
0x00000008ff9e7819ULL, 0x000fe20000011698ULL, 0x2000009dff987230ULL, 0x000fe20000004100ULL,
0x00000063ff9d723eULL, 0x000fe200020006ffULL, 0x000000605450723cULL, 0x000fe20000041850ULL,
0x000000ff5d637812ULL, 0x000fe400078ec0ffULL, 0x000000ff5ea17812ULL, 0x000fe400078ec0ffULL,
0x000000a0ffa0723eULL, 0x000fe200020006ffULL, 0x00000060184c723cULL, 0x000fe2000004184cULL,
0x00000063ff9f723eULL, 0x000fc400020006ffULL, 0x00000018ff627819ULL, 0x100fe2000001165dULL,
0x200000a0ff6a7230ULL, 0x000fe20000004100ULL, 0x000000a1ff63723eULL, 0x000fe400020006ffULL,
0x00000010ff617819ULL, 0x000fe4000001165dULL, 0x0000ffff5d607812ULL, 0x000fe400078ec0ffULL,
0x000000ff61a17812ULL, 0x000fe200078ec0ffULL, 0x2000009fff617230ULL, 0x000fe20000004100ULL,
0x00000008ff607819ULL, 0x000fc40000011660ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x100fe4000001165eULL, 0x00000018ffa07819ULL, 0x000fe2000001165eULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000ffff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x000000a1ffa1723eULL, 0x000fe400020006ffULL, 0x00000060ff9f723eULL, 0x000fe200020006ffULL,
0x20000063ff607230ULL, 0x000fe20000004100ULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x200000a1ffa17230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x2000009fff9f7230ULL, 0x000fe20000004100ULL, 0x0000005effa2723eULL, 0x000fc400020006ffULL,
0x000000a0ffa0723eULL, 0x000fe400020006ffULL, 0x0000005dffa3723eULL, 0x000fe400020006ffULL,
0x00000010ff5e7819ULL, 0x000fe20000011662ULL, 0x200000a0ffa07230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe20000011661ULL, 0x200000a3ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe400000116a1ULL, 0x00000010ff5d7819ULL, 0x000fe2000001169fULL,
0x200000a2ff9f7230ULL, 0x000fe20000004100ULL, 0x000010545e637816ULL, 0x000fc40000000063ULL,
0x000010545d627816ULL, 0x000fe40000000062ULL, 0x000000ff9b5d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ffa07819ULL, 0x000fe400000116a0ULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x000000625448723cULL, 0x000fe20000041848ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff9f7819ULL, 0x000fc4000001169fULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x000000621844723cULL, 0x000fe20000041844ULL, 0x00000008ff5e7819ULL, 0x000fe2000001169aULL,
0x2000009dff9a7230ULL, 0x000fe20000004100ULL, 0x00001054a0617816ULL, 0x000fe40000000061ULL,
0x000010549f607816ULL, 0x000fe40000000060ULL, 0x000000ff95637812ULL, 0x000fe200078ec0ffULL,
0x2000005dff957230ULL, 0x000fe20000004100ULL, 0x00000008ff9c7819ULL, 0x000fc4000001169cULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x000000605440723cULL, 0x000fe20000041840ULL,
0x00000063ff5d723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000005eff627230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe20000011668ULL,
0x00000060183c723cULL, 0x000fe2000004183cULL, 0x00000010ff987819ULL, 0x000fe20000011698ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000009eff9e723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000009cff9c723eULL, 0x000fc400020006ffULL,
0x0000105463617816ULL, 0x000fe20000000098ULL, 0x2000009eff9b7230ULL, 0x000fe20000004100ULL,
0x00000010ff927819ULL, 0x000fe20000011692ULL, 0x2000009cff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe4000001169aULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff627819ULL, 0x000fe40000011662ULL, 0x0000105492637816ULL, 0x000fc40000000063ULL,
0x00000010ff927819ULL, 0x000fe40000011665ULL, 0x00000010ff997819ULL, 0x000fe40000011699ULL,
0x00000010ff977819ULL, 0x000fe40000011697ULL, 0x00000010ff9c7819ULL, 0x000fe40000011669ULL,
0x00000010ff687819ULL, 0x000fe40000011696ULL, 0x00000010ff607819ULL, 0x000fc40000011694ULL,
0x00000010ff9b7819ULL, 0x000fe4000001169bULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff657819ULL, 0x000fe40000011695ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x0000105462627816ULL, 0x000fe40000000093ULL, 0x00000008ff937819ULL, 0x000fc40000011664ULL,
0x0000105499697816ULL, 0x000fe4000000009cULL, 0x0000105468687816ULL, 0x000fe20000000097ULL,
0x000000625430723cULL, 0x000fe20000041830ULL, 0x000010549b607816ULL, 0x000fe40000000060ULL,
0x0000105492657816ULL, 0x000fe40000000065ULL, 0x000010545e647816ULL, 0x000fe2000000008fULL,
0x000000685438723cULL, 0x000fe20000041838ULL, 0x00000008ff807819ULL, 0x000fc40000011680ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x000000605434723cULL, 0x000fe20000041834ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x00000064542c723cULL, 0x000fe2000004182cULL, 0x000000ff81817812ULL, 0x000fc400078ec0ffULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff7d7819ULL, 0x100fe2000001166bULL,
0x000000621820723cULL, 0x000fe20000041820ULL, 0x00000087ff57723eULL, 0x000fe400020006ffULL,
0x000000ff86567812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001166bULL,
0x20000057ff867230ULL, 0x000fe20000004100ULL, 0x00000056ff57723eULL, 0x000fe200020006ffULL,
0x000000681828723cULL, 0x000fe20000041828ULL, 0x00000080ff56723eULL, 0x000fc400020006ffULL,
0x000000ff6b897812ULL, 0x000fe200078ec0ffULL, 0x20000057ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe20000011682ULL, 0x20000056ff637230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fe2000001167fULL, 0x000000601824723cULL, 0x000fe20000041824ULL,
0x000010547e577816ULL, 0x000fe40000000057ULL, 0x0000105483567816ULL, 0x000fe40000000056ULL,
0x0000008cff8f723eULL, 0x000fe200020006ffULL, 0x00000064181c723cULL, 0x000fe2000004181cULL,
0x0000ffff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x20000093ff8c7230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x000000561450723cULL, 0x000fe20000041850ULL, 0x00000010ff1a7819ULL, 0x000fe2000001167bULL,
0x2000008eff547230ULL, 0x000fe20000004100ULL, 0x00000010ff1b7819ULL, 0x000fe20000011667ULL,
0x2000008dff557230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x000fe2000001166aULL,
0x00000056104c723cULL, 0x000fe2000004184cULL, 0x00000081ff61723eULL, 0x000fe400020006ffULL,
0x00001054661b7816ULL, 0x000fc4000000001bULL, 0x00001054191a7816ULL, 0x000fe2000000001aULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe40000011684ULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x000000ff85857812ULL, 0x000fe200078ec0ffULL,
0x0000001a1448723cULL, 0x000fe20000041848ULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff5c7819ULL, 0x000fe2000001165cULL,
0x0000001a1044723cULL, 0x000fe20000041844ULL, 0x00000010ff567819ULL, 0x000fe4000001165fULL,
0x00000010ff577819ULL, 0x000fe4000001165dULL, 0x00000010ff197819ULL, 0x000fe4000001168cULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x0000008bff5e723eULL, 0x000fe200020006ffULL, 0x20000084ff627230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x2000007cff647230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000008fff8b7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000085ff60723eULL, 0x000fe200020006ffULL, 0x20000088ff877230ULL, 0x000fe20000004100ULL,
0x0000007dff65723eULL, 0x000fe200020006ffULL, 0x2000008aff687230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000089ff697230ULL, 0x000fe20000004100ULL,
0x000010545c577816ULL, 0x000fe20000000057ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000105419567816ULL, 0x000fe20000000056ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff1a7819ULL, 0x000fe20000011654ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff547819ULL, 0x000fc40000011655ULL, 0x00000010ff557819ULL, 0x000fe20000011661ULL,
0x000000561440723cULL, 0x000fe20000041840ULL, 0x00000010ff1b7819ULL, 0x000fe40000011662ULL,
0x000010541a557816ULL, 0x000fe40000000055ULL, 0x00000010ff1a7819ULL, 0x000fe20000011686ULL,
0x00000056103c723cULL, 0x000fe2000004183cULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000010ff187819ULL, 0x000fe4000001165eULL,
0x00000010ff577819ULL, 0x000fe40000011664ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff687819ULL, 0x000fc40000011668ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff567819ULL, 0x000fe40000011669ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x000010541b547816ULL, 0x000fe40000000054ULL, 0x00001054571a7816ULL, 0x000fe4000000001aULL,
0x000010548b197816ULL, 0x000fc40000000080ULL, 0x0000105463187816ULL, 0x000fe20000000018ULL,
0x000000541434723cULL, 0x000fe20000041834ULL, 0x00001054871b7816ULL, 0x000fe40000000060ULL,
0x0000105468577816ULL, 0x000fe40000000065ULL, 0x000010546b567816ULL, 0x000fe20000000056ULL,
0x000000181438723cULL, 0x000fec0000041838ULL, 0x0000001a1430723cULL, 0x000fec0000041830ULL,
0x00000056142c723cULL, 0x000fec000004182cULL, 0x000000181028723cULL, 0x000fec0000041828ULL,
0x000000541024723cULL, 0x000fec0000041824ULL, 0x0000001a1020723cULL, 0x000fec0000041820ULL,
0x00000056101c723cULL, 0x000fe2000004181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe400980947ULL, 0x000fde000383ffffULL, 0x00000001ff177424ULL, 0x000fe400078e00ffULL,
0x0000006c04107220ULL, 0x080fe20000410000ULL, 0x0000006c05127220ULL, 0x080fe20000410000ULL,
0x0000006c50117220ULL, 0x080fe20000410000ULL, 0x01a68817020479a7ULL, 0x000262000850003fULL,
0x0000006c51517220ULL, 0x080fe20000410000ULL, 0x0000006c52527220ULL, 0x080fe20000410000ULL,
0x0000006c53537220ULL, 0x080fe20000410000ULL, 0x0000006c48487220ULL, 0x080fe20000410000ULL,
0x0000006c49497220ULL, 0x080fe20000410000ULL, 0x0000006c4a4a7220ULL, 0x080fe20000410000ULL,
0x0000006c4b4b7220ULL, 0x080fe20000410000ULL, 0x0000006c40407220ULL, 0x080fe20000410000ULL,
0x0000006c41417220ULL, 0x080fe20000410000ULL, 0x0000006c42427220ULL, 0x080fe20000410000ULL,
0x0000006c43437220ULL, 0x080fe20000410000ULL, 0x0000006c0c0c7220ULL, 0x080fe20000410000ULL,
0x0000006c0d0d7220ULL, 0x080fe20000410000ULL, 0x0000006c0e0e7220ULL, 0x080fe20000410000ULL,
0x0000006c0f0f7220ULL, 0x080fe20000410000ULL, 0x0000006c38387220ULL, 0x080fe20000410000ULL,
0x0000006c39397220ULL, 0x080fe20000410000ULL, 0x0000006c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000006c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000006c34347220ULL, 0x080fe20000410000ULL,
0x0000006c35357220ULL, 0x080fe20000410000ULL, 0x0000006c36367220ULL, 0x080fe20000410000ULL,
0x0000006c37377220ULL, 0x080fe20000410000ULL, 0x0000006c30307220ULL, 0x080fe20000410000ULL,
0x0000006c31317220ULL, 0x080fe20000410000ULL, 0x0000006c32327220ULL, 0x080fe20000410000ULL,
0x0000006c33337220ULL, 0x080fe20000410000ULL, 0x0000006c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000006c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000006c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000006c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000006c4c137220ULL, 0x080fe20000410000ULL,
0x0000006c4d4d7220ULL, 0x080fe20000410000ULL, 0x0000006c4e4e7220ULL, 0x080fe20000410000ULL,
0x0000006c4f4f7220ULL, 0x080fe20000410000ULL, 0x0000006c44447220ULL, 0x080fe20000410000ULL,
0x0000006c45457220ULL, 0x080fe20000410000ULL, 0x0000006c46467220ULL, 0x080fe20000410000ULL,
0x0000006c47477220ULL, 0x080fe20000410000ULL, 0x0000006c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000006c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000006c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000006c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000006c06147220ULL, 0x080fe20000410000ULL,
0x0000006c07157220ULL, 0x080fe20000410000ULL, 0x0000006c28287220ULL, 0x080fe20000410000ULL,
0x0000006c29297220ULL, 0x080fe20000410000ULL, 0x0000006c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000006c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000006c24247220ULL, 0x080fe20000410000ULL,
0x0000006c25257220ULL, 0x080fe20000410000ULL, 0x0000006c26267220ULL, 0x080fe20000410000ULL,
0x0000006c27277220ULL, 0x080fe20000410000ULL, 0x0000006c20207220ULL, 0x080fe20000410000ULL,
0x0000006c21217220ULL, 0x080fe20000410000ULL, 0x0000006c22227220ULL, 0x080fe20000410000ULL,
0x0000006c23237220ULL, 0x080fe20000410000ULL, 0x0000006c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000006c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000006c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000006c1f1f7220ULL, 0x000fe20000410000ULL, 0x0000000709167812ULL, 0x002fce00078ec0ffULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x01a68805020075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1a7224ULL, 0x000fce00078e00ffULL,
0x000000101a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fce0000015200ULL, 0x0000000618177210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e19ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001706067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011a1a7836ULL, 0x000fce0000000000ULL,
0x01a68805020075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000409047824ULL, 0x000fe200078e00ffULL, 0x0000005b6f00720cULL, 0x000fe20003f06070ULL,
0x0000008077177824ULL, 0x000fc600078e0208ULL, 0xfffffff004047812ULL, 0x000fca00078ec0ffULL,
0x0000000117177824ULL, 0x000fca00078e0204ULL, 0x01a4000017047984ULL, 0x0002a20000000c00ULL,
0x0000002000648947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x00000076091a7211ULL, 0x040fe200078ff0ffULL, 0x00000004004c7d06ULL, 0x000ee20008209000ULL,
0xffffff000b0b7836ULL, 0x000fe40000000000ULL, 0x0000000209ae7824ULL, 0x000fe400078e00ffULL,
0x000000181a547836ULL, 0x000fe20000000000ULL, 0x0000000b74b07248ULL, 0x000fe40007fe0000ULL,
0x00000006aeae7812ULL, 0x000fc600078ec0ffULL, 0x00000001b0b07824ULL, 0x000fe400078e0a0bULL,
0x00000001aeaf7824ULL, 0x000fe200078e0203ULL, 0x0000004c004c7308ULL, 0x008ee20000001000ULL,
0x000000ffff877224ULL, 0x000fca00078e0ab0ULL, 0x00000087af9f7246ULL, 0x000fe2000380005aULL,
0x0ffffffe4c187836ULL, 0x008fe40000000000ULL, 0x000000101a4c7836ULL, 0x000fe40000000000ULL,
0x0000001800197305ULL, 0x000764000021f000ULL, 0x000000ffff187224ULL, 0x008fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x022fc800078e0a19ULL, 0x000000041b1b7c24ULL, 0x000fc8000f8e02ffULL,
0x0000001b19557227ULL, 0x000fc800078e0018ULL, 0x000000081a197836ULL, 0x000fe40000000000ULL,
0x0000001a55187227ULL, 0x000fc800078e00ffULL, 0x00000019551b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff567224ULL, 0x000fe400078e0a1bULL, 0x000000ffff577224ULL, 0x000fe400078e0a18ULL,
0x0000000456197c24ULL, 0x000fe4000f8e0219ULL, 0x00000004571a7c24ULL, 0x000fe4000f8e021aULL,
0x0000004c55507227ULL, 0x000fe200078e00ffULL, 0x0000000419007c0cULL, 0x000fe4000bf06070ULL,
0x000000041a007c0cULL, 0x000fe2000bfa6070ULL, 0x0000005455557227ULL, 0x000fc800078e00ffULL,
0x000000ffff597224ULL, 0x000fe400078e0a50ULL, 0x000000ffff577224ULL, 0x000fe400078e0a55ULL,
0x00000004594c7c24ULL, 0x000fe4000f8e024cULL, 0x0000000457547c24ULL, 0x000fe4000f8e0254ULL,
0x8000000419190c36ULL, 0x000fe20008000000ULL, 0x000000044c007c0cULL, 0x000fe2000bf46070ULL,
0x800000041a1a5c36ULL, 0x000fe20008000000ULL, 0x0000000454007c0cULL, 0x000fe2000bf66070ULL,
0x000000011b1b0836ULL, 0x000fe20000000000ULL, 0x0000000419007c0cULL, 0x000fe2000bfc6070ULL,
0x0000000118185836ULL, 0x000fe20000000000ULL, 0x000000041a007c0cULL, 0x000fe2000bf86070ULL,
0x000000010a197824ULL, 0x000fca00078e02aeULL, 0x000000b01900720cULL, 0x000fe20003fa6070ULL,
0x800000044c4c2c36ULL, 0x000fe20008000000ULL, 0x0000008719197246ULL, 0x000fe2000380005aULL,
0x8000000454543c36ULL, 0x000fe40008000000ULL, 0x000000011b1b6836ULL, 0x000fe20000000000ULL,
0x000000044c007c0cULL, 0x000fe2000bf26070ULL, 0x0000000118184836ULL, 0x000fe20000000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL, 0x0000000150502836ULL, 0x000fe20000000000ULL,
0x00000004ff4c7c12ULL, 0x000fe2000f8e33ffULL, 0x0000000155553836ULL, 0x000fe20000000000ULL,
0x0000000454007c0cULL, 0x000fc4000bf06070ULL, 0x000000184c0b7207ULL, 0x040fe40007000000ULL,
0x000000b0af00720cULL, 0x000fe40003f86070ULL, 0x0000000b5a0b7248ULL, 0x000fe20003fe0000ULL,
0x0000000150501836ULL, 0x000fe20000000000ULL, 0x00000004ff197819ULL, 0x000fe40000011619ULL,
0x0000001b4c1b7207ULL, 0x000fe20007000000ULL, 0x000000050b667c24ULL, 0x000fe2000f8e02ffULL,
0x000000ff9f9f7207ULL, 0x000fe20002000000ULL, 0x0000000155550836ULL, 0x000fe20000000000ULL,
0x000000ff190b7207ULL, 0x000fc40002800000ULL, 0x0000001b5a1a7248ULL, 0x000fe40003fe0000ULL,
0x000000504c1b7207ULL, 0x000fe20007000000ULL, 0x00000001665d7824ULL, 0x000fe200078e020bULL,
0x000000669f197211ULL, 0x000fe200078fe0ffULL, 0x000000051a1a7c24ULL, 0x000fe2000f8e02ffULL,
0x000000554c557207ULL, 0x000fe20007000000ULL, 0x000000025d5c7825ULL, 0x100fe200078e0090ULL,
0x0000001b5a1b7248ULL, 0x000fe40003fe0000ULL, 0x000000555a557248ULL, 0x000fe20003fe0000ULL,
0x0000000219187825ULL, 0x000fe200078e0090ULL, 0x000000065cad7981ULL, 0x000ee6000c1e9500ULL,
0x000000051b687c24ULL, 0x000fe2000f8e02ffULL, 0x0000000618ac7981ULL, 0x0002e2000c1e9500ULL,
0x0000000555567c24ULL, 0x000fe2000f8e02ffULL, 0x0000001a9f557211ULL, 0x000fe200078fe0ffULL,
0x000000010b617824ULL, 0x000fe200078e021aULL, 0x000000689f897211ULL, 0x000fe200078fe0ffULL,
0x000000010b5f7824ULL, 0x040fe200078e0268ULL, 0x00000010ae7d7812ULL, 0x000fe200078efcffULL,
0x000000010b1b7824ULL, 0x000fe200078e0256ULL, 0x000000569f0b7211ULL, 0x000fe200078fe0ffULL,
0x0000000255547825ULL, 0x000fc800078e0090ULL, 0x0000000289887825ULL, 0x100fe400078e0090ULL,
0x0000000654547981ULL, 0x000ae4000c1e9500ULL, 0x0000000261607825ULL, 0x100fe400078e0090ULL,
0x0000000688887981ULL, 0x000ee4000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fe400078e0090ULL,
0x0000000660577981ULL, 0x000ee4000c1e9500ULL, 0x000000010a597824ULL, 0x000fc400078e027dULL,
0x000000020b187825ULL, 0x006fe400078e0090ULL, 0x000000065e0b7981ULL, 0x000ea2000c1e9500ULL,
0x00000087594c7246ULL, 0x000fe2000380005aULL, 0x000000017d7f7824ULL, 0x000fe200078e0203ULL,
0x000000b05900720cULL, 0x080fe20003f26070ULL, 0x000000021b5c7825ULL, 0x000fe200078e0090ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x0000000618507981ULL, 0x000ea2000c1e9500ULL,
0x000000b07f00720cULL, 0x000fe40003f06070ULL, 0x000000877f9d7246ULL, 0x000fe2000380005aULL,
0x000000065c1b7981ULL, 0x0002a2000c1e9500ULL, 0x000000ff4c557207ULL, 0x020fc40000800000ULL,
0x000000ff9d9d7207ULL, 0x000fc60000000000ULL, 0x00000001558f7824ULL, 0x000fe200078e021aULL,
0x000000669d937211ULL, 0x040fe200078fe0ffULL, 0x00000001665d7824ULL, 0x002fe200078e0255ULL,
0x0000001a9d637211ULL, 0x000fe200078fe0ffULL, 0x0000000155197824ULL, 0x000fe400078e0268ULL,
0x000000025d5c7825ULL, 0x000fe200078e0090ULL, 0x00000020ae677812ULL, 0x000fc600078efcffULL,
0x00000001555f7824ULL, 0x000fe200078e0256ULL, 0x000000569d557211ULL, 0x000fe200078fe0ffULL,
0x0000000293927825ULL, 0x100fe200078e0090ULL, 0x000000065c7b7981ULL, 0x000366000c1e9500ULL,
0x000000028f8e7825ULL, 0x100fe400078e0090ULL, 0x0000000692927981ULL, 0x000f64000c1e9500ULL,
0x0000000263627825ULL, 0x000fc400078e0090ULL, 0x000000068e8e7981ULL, 0x000f64000c1e9500ULL,
0x00000002555c7825ULL, 0x002fe400078e0090ULL, 0x0000000662857981ULL, 0x000f64000c1e9500ULL,
0x000000010a557824ULL, 0x000fe200078e0267ULL, 0x000000689d617211ULL, 0x000fe200078fe0ffULL,
0x0000000167697824ULL, 0x000fe200078e0203ULL, 0x000000065c817981ULL, 0x000364000c1e9500ULL,
0x0000008755597246ULL, 0x000fe2000380005aULL, 0x0000000219187825ULL, 0x000fe200078e0090ULL,
0x000000b06900720cULL, 0x000fc40003f06070ULL, 0x00000087699b7246ULL, 0x000fe2000380005aULL,
0x0000000261607825ULL, 0x000fe200078e0090ULL, 0x000000b05500720cULL, 0x000fe20003f26070ULL,
0x0000000618187981ULL, 0x000f62000c1e9500ULL, 0x00000004ff597819ULL, 0x000fe20000011659ULL,
0x000000025f5e7825ULL, 0x000fe200078e0090ULL, 0x000000ff9b9b7207ULL, 0x000fe20000000000ULL,
0x0000000660837981ULL, 0x000f62000c1e9500ULL, 0x000000ff59597207ULL, 0x000fc60000800000ULL,
0x000000065e4c7981ULL, 0x000362000c1e9500ULL, 0x0000001a9b6b7211ULL, 0x000fe200078fe0ffULL,
0x00000001595d7824ULL, 0x002fc800078e021aULL, 0x000000026b6a7825ULL, 0x000fc800078e0090ULL,
0x000000025d5c7825ULL, 0x000fe200078e0090ULL, 0x000000669b5f7211ULL, 0x000fe200078fe0ffULL,
0x000000066a6b7981ULL, 0x000f64000c1e9500ULL, 0x0000000166617824ULL, 0x000fe400078e0259ULL,
0x000000065c807981ULL, 0x000f62000c1e9500ULL, 0x0000000159657824ULL, 0x000fe400078e0268ULL,
0x0000000261607825ULL, 0x000fe200078e0090ULL, 0x000000689b637211ULL, 0x000fc400078fe0ffULL,
0x000000569b197211ULL, 0x000fe200078fe0ffULL, 0x000000025f5e7825ULL, 0x000fe200078e0090ULL,
0x0000000660827981ULL, 0x000366000c1e9500ULL, 0x0000000159597824ULL, 0x000fe200078e0256ULL,
0x000000065e6d7981ULL, 0x000362000c1e9500ULL, 0x0000000265647825ULL, 0x000fc800078e0090ULL,
0x0000000259607825ULL, 0x002fe200078e0090ULL, 0x00000030ae597812ULL, 0x000fc600078efcffULL,
0x0000000263627825ULL, 0x100fe200078e0090ULL, 0x0000000660557981ULL, 0x000366000c1e9500ULL,
0x00000002195e7825ULL, 0x000fe200078e0090ULL, 0x00000006627e7981ULL, 0x000f66000c1e9500ULL,
0x000000010a897824ULL, 0x000fe200078e0259ULL, 0x0000000664197981ULL, 0x000f62000c1e9500ULL,
0x00000001595d7824ULL, 0x000fc600078e0203ULL, 0x000000065e7c7981ULL, 0x000362000c1e9500ULL,
0x00000087895c7246ULL, 0x000fe4000380005aULL, 0x000000b05d00720cULL, 0x080fe40003f06070ULL,
0x000000875d997246ULL, 0x000fe4000380005aULL, 0x000000b08900720cULL, 0x000fe40003f26070ULL,
0x00000004ff5c7819ULL, 0x000fe4000001165cULL, 0x000000ff99997207ULL, 0x000fc40000000000ULL,
0x000000ff5c897207ULL, 0x000fe40000800000ULL, 0x0000006899617211ULL, 0x042fe400078fe0ffULL,
0x00000066995f7211ULL, 0x000fe200078fe0ffULL, 0x0000000166637824ULL, 0x000fe400078e0289ULL,
0x0000000189877824ULL, 0x000fe400078e0268ULL, 0x0000000261607825ULL, 0x000fc800078e0090ULL,
0x0000000263627825ULL, 0x100fe200078e0090ULL, 0x0000001a998b7211ULL, 0x000fe200078fe0ffULL,
0x0000000660617981ULL, 0x000f64000c1e9500ULL, 0x000000025f5e7825ULL, 0x100fe400078e0090ULL,
0x0000000662667981ULL, 0x000364000c1e9500ULL, 0x0000000287867825ULL, 0x000fe400078e0090ULL,
0x000000065e657981ULL, 0x000364000c1e9500ULL, 0x00000001898d7824ULL, 0x000fc400078e021aULL,
0x00000006861a7981ULL, 0x000f62000c1e9500ULL, 0x000000028b8a7825ULL, 0x000fc800078e0090ULL,
0x000000028d8c7825ULL, 0x000fe200078e0090ULL, 0x000000068a637981ULL, 0x002f62000c1e9500ULL,
0x00000056995f7211ULL, 0x000fc600078fe0ffULL, 0x000000068c647981ULL, 0x000362000c1e9500ULL,
0x0000000189957824ULL, 0x000fe400078e0256ULL, 0x000000025f5e7825ULL, 0x000fc800078e0090ULL,
0x0000000295947825ULL, 0x000fe400078e0090ULL, 0x000000065e5f7981ULL, 0x000368000c1e9500ULL,
0x0000000694627981ULL, 0x000362000c1e9500ULL, 0xfffffff09f9f7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff567424ULL, 0x000fc800078e00ffULL, 0x00000001b09e7824ULL, 0x000fc800078e029fULL,
0x00000001afab7824ULL, 0x000fe200078e0a9eULL, 0x00000001aeaa7812ULL, 0x000fc800078efcffULL,
0x000000ab56ab7219ULL, 0x000fe200000006ffULL, 0x00000001aaa97824ULL, 0x000fc800078e0203ULL,
0x00000001a9a77824ULL, 0x000fe200078e0a9eULL, 0x00000008aea87812ULL, 0x040fe400078efcffULL,
0x00000009ae8c7812ULL, 0x002fe400078efcffULL, 0x000000a756a77219ULL, 0x000fe200000006ffULL,
0x00000001a8a67824ULL, 0x100fe200078e0203ULL, 0x00000021ae6e7812ULL, 0x000fe200078efcffULL,
0x000000018c877824ULL, 0x000fe200078e0203ULL, 0x00000028ae6a7812ULL, 0x040fe400078efcffULL,
0x00000029ae687812ULL, 0x000fc400078efcffULL, 0x00000031ae607812ULL, 0x040fe400078efcffULL,
0x00000038ae5e7812ULL, 0x040fe400078efcffULL, 0x00000039ae5c7812ULL, 0x000fe400078efcffULL,
0xfffffff09b9b7812ULL, 0x000fe400078ec0ffULL, 0xfffffff099997812ULL, 0x000fe200078ec0ffULL,
0x000000016e8f7824ULL, 0x100fe400078e0203ULL, 0x000000016a937824ULL, 0x000fc400078e0203ULL,
0x0000000168947824ULL, 0x100fe400078e0203ULL, 0x0000000160957824ULL, 0x100fe400078e0203ULL,
0x000000015e967824ULL, 0x100fe400078e0203ULL, 0x000000015c977824ULL, 0x000fe400078e0203ULL,
0x00000001b09a7824ULL, 0x040fe400078e029bULL, 0x00000001b0987824ULL, 0x000fc400078e0299ULL,
0x00000001a6bd7824ULL, 0x100fe400078e0a9eULL, 0x0000000187bb7824ULL, 0x000fe200078e0a9eULL,
0x00000011ae8a7812ULL, 0x000fe200078efcffULL, 0x00000001699f7824ULL, 0x100fe200078e0a9aULL,
0xfffffff09d9d7812ULL, 0x000fe200078ec0ffULL, 0x000000018fb57824ULL, 0x100fe400078e0a9aULL,
0x0000000193a17824ULL, 0x000fe200078e0a9aULL, 0x00005410acac7816ULL, 0x008fc800000000adULL,
0x000000acabff7212ULL, 0x000fc800078ac0ffULL, 0x000000b0af00720cULL, 0x000fc80002fa1470ULL,
0x000000b0ae00720cULL, 0x000fe40002fa1070ULL, 0x000000aca7ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x0000541054547816ULL, 0x000fe40000000057ULL,
0x00005410880b7816ULL, 0x004fe4000000000bULL, 0x00000054abff7212ULL, 0x000fc4000784c0ffULL,
0x0000000babff7212ULL, 0x000fe4000788c0ffULL, 0x00000054a7ff7212ULL, 0x000fe400078ac0ffULL,
0x000000b0af00720cULL, 0x0c0fe40001741470ULL, 0x000000b0af00720cULL, 0x080fe40002781470ULL,
0x000000b0a900720cULL, 0x0c0fe40000f21470ULL, 0x000000b0a900720cULL, 0x080fe20002fa1470ULL,
0x0000000194b37824ULL, 0x000fe200078e0a9aULL, 0x000000b0ae00720cULL, 0x0c0fe20001741070ULL,
0x000000015da37824ULL, 0x100fe200078e0a98ULL, 0x000000b0ae00720cULL, 0x080fe20002781070ULL,
0x0000000195b17824ULL, 0x100fe200078e0a98ULL, 0x000000b0aa00720cULL, 0x080fe20000f21070ULL,
0x0000000196a57824ULL, 0x100fe200078e0a98ULL, 0x000000b0aa00720cULL, 0x000fe20002fa1070ULL,
0x0000000197997824ULL, 0x000fe200078e0a98ULL, 0x000000bd56987219ULL, 0x000fc400000006ffULL,
0x000000bb569a7219ULL, 0x000fe400000006ffULL, 0x00005410501b7816ULL, 0x000fe2000000001bULL,
0x000000018a897824ULL, 0x000fe200078e0203ULL, 0x00000018ae867812ULL, 0x000fe200078efcffULL,
0x00000001b09c7824ULL, 0x000fe200078e029dULL, 0x00000019ae847812ULL, 0x000fe400078efcffULL,
0xff80000052527808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fc40002000000ULL,
0xff80000051517808ULL, 0x000fe40000800000ULL, 0xff80000053537808ULL, 0x000fe40002800000ULL,
0x000000ac98ff7212ULL, 0x000fe4000786c0ffULL, 0x0000001babff7212ULL, 0x000fe4000780c0ffULL,
0x0000000ba7ff7212ULL, 0x040fe4000784c0ffULL, 0x0000001ba7ff7212ULL, 0x000fc4000788c0ffULL,
0x000000549aff7212ULL, 0x000fe4000782c0ffULL, 0x0000000b98ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001868b7824ULL, 0x100fe200078e0203ULL, 0x000000b0af00720cULL, 0x080fe20000701470ULL,
0x00000001848d7824ULL, 0x000fe200078e0203ULL, 0x000000b0a900720cULL, 0x080fe20001741470ULL,
0x000000017f9b7824ULL, 0x100fe200078e0a9cULL, 0x000000b0a900720cULL, 0x080fe20002781470ULL,
0x0000000189b97824ULL, 0x000fe200078e0a9cULL, 0x000000b0a600720cULL, 0x000fc40001f61470ULL,
0x000000b0a600720cULL, 0x080fe40002fa1470ULL, 0x000000b08700720cULL, 0x080fe20000f21470ULL,
0x000000018b9d7824ULL, 0x100fe200078e0a9cULL, 0x000000b0ae00720cULL, 0x080fe20000701070ULL,
0x000000018db77824ULL, 0x000fe200078e0a9cULL, 0x000000b0aa00720cULL, 0x0c0fe40001741070ULL,
0x000000b0aa00720cULL, 0x080fe40002781070ULL, 0x000000b0a800720cULL, 0x000fc40001f61070ULL,
0x000000b0a800720cULL, 0x080fe40002fa1070ULL, 0x000000b08c00720cULL, 0x000fe40000f21070ULL,
0x0000009b569b7219ULL, 0x040fe400000006ffULL, 0x000000b9569c7219ULL, 0x000fe400000006ffULL,
0x00005410927b7816ULL, 0x020fe4000000007bULL, 0x0000541085857816ULL, 0x000fc4000000008eULL,
0xff8000004e4e7808ULL, 0x000fe40000000000ULL, 0xff8000004d4d7808ULL, 0x000fe40001000000ULL,
0xff8000004f4f7808ULL, 0x000fe40002000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fe40002800000ULL, 0xff8000004b4b7808ULL, 0x000fc40000800000ULL,
0x0000005498ff7212ULL, 0x000fe4000780c0ffULL, 0x0000000b9aff7212ULL, 0x000fe4000784c0ffULL,
0x0000001b98ff7212ULL, 0x080fe4000788c0ffULL, 0x0000001b9aff7212ULL, 0x000fe4000786c0ffULL,
0x0000007b9cff7212ULL, 0x000fe400078ac0ffULL, 0x000000859bff7212ULL, 0x000fc4000782c0ffULL,
0x000000b0a600720cULL, 0x0c0fe40000701470ULL, 0x000000b0a600720cULL, 0x080fe40002781470ULL,
0x000000b08700720cULL, 0x0c0fe40001741470ULL, 0x000000b08700720cULL, 0x080fe40001f61470ULL,
0x000000b07f00720cULL, 0x080fe40000f21470ULL, 0x000000b08900720cULL, 0x000fc40002fa1470ULL,
0x000000b0a800720cULL, 0x0c0fe40000701070ULL, 0x000000b0a800720cULL, 0x080fe40002781070ULL,
0x000000b08c00720cULL, 0x0c0fe40001741070ULL, 0x000000b08c00720cULL, 0x080fe40001f61070ULL,
0x000000b07d00720cULL, 0x080fe40000f21070ULL, 0x000000b08a00720cULL, 0x000fc40002fa1070ULL,
0x0000009d569d7219ULL, 0x040fe400000006ffULL, 0x000000b7569e7219ULL, 0x000fe400000006ffULL,
0x0000541083187816ULL, 0x000fe40000000018ULL, 0x00005410814c7816ULL, 0x000fe4000000004cULL,
0xff8000004a4a7808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fc40002000000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000047477808ULL, 0x000fe40001800000ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0x0000007b9bff7212ULL, 0x080fe4000780c0ffULL, 0x0000007b9dff7212ULL, 0x000fc4000788c0ffULL,
0x000000189bff7212ULL, 0x040fe4000784c0ffULL, 0x0000004c9bff7212ULL, 0x000fe4000786c0ffULL,
0x000000189cff7212ULL, 0x000fe4000782c0ffULL, 0x000000859eff7212ULL, 0x000fe400078ac0ffULL,
0x000000b07f00720cULL, 0x0c0fe40000701470ULL, 0x000000b07f00720cULL, 0x000fc40001741470ULL,
0x000000b07f00720cULL, 0x080fe40001f61470ULL, 0x000000b08900720cULL, 0x080fe40000f21470ULL,
0x000000b08b00720cULL, 0x080fe40002781470ULL, 0x000000b08d00720cULL, 0x080fe40002fa1470ULL,
0x000000b07d00720cULL, 0x0c0fe40000701070ULL, 0x000000b07d00720cULL, 0x000fc40001741070ULL,
0x000000b07d00720cULL, 0x080fe40001f61070ULL, 0x000000b08a00720cULL, 0x080fe40000f21070ULL,
0x000000b08600720cULL, 0x080fe40002781070ULL, 0x000000b08400720cULL, 0x000fe40002fa1070ULL,
0x0000009f569f7219ULL, 0x000fe400000006ffULL, 0x000054106b6b7816ULL, 0x000fc40000000080ULL,
0xff80000040407808ULL, 0x000fe40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000003e3e7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000000c0c7808ULL, 0x000fe40002000000ULL, 0xff8000000f0f7808ULL, 0x000fc40002800000ULL,
0x000000859cff7212ULL, 0x0c0fe4000780c0ffULL, 0x0000004c9cff7212ULL, 0x000fe4000784c0ffULL,
0x000000859dff7212ULL, 0x000fe4000786c0ffULL, 0x000000189eff7212ULL, 0x040fe4000782c0ffULL,
0x0000004c9eff7212ULL, 0x000fe4000788c0ffULL, 0x0000006b9fff7212ULL, 0x000fc400078ac0ffULL,
0x000000b08900720cULL, 0x0c0fe40000701470ULL, 0x000000b08900720cULL, 0x080fe40001741470ULL,
0x000000b08b00720cULL, 0x080fe40001f61470ULL, 0x000000b08d00720cULL, 0x0c0fe40000f21470ULL,
0x000000b08d00720cULL, 0x080fe40002781470ULL, 0x000000b06900720cULL, 0x000fc40002fa1470ULL,
0x000000b08a00720cULL, 0x0c0fe40000701070ULL, 0x000000b08a00720cULL, 0x080fe40001741070ULL,
0x000000b08600720cULL, 0x080fe40001f61070ULL, 0x000000b08400720cULL, 0x0c0fe40000f21070ULL,
0x000000b08400720cULL, 0x080fe40002781070ULL, 0x000000b06700720cULL, 0x000fc40002fa1070ULL,
0x000000b556a07219ULL, 0x000fe400000006ffULL, 0x000054106d6d7816ULL, 0x000fe40000000082ULL,
0x000054107e197816ULL, 0x000fe40000000019ULL, 0x000054107c557816ULL, 0x000fe40000000055ULL,
0xff80000043437808ULL, 0x000fe40000000000ULL, 0xff8000003f3f7808ULL, 0x000fc40001000000ULL,
0xff8000000e0e7808ULL, 0x000fe40001800000ULL, 0xff80000012127808ULL, 0x000fe40000800000ULL,
0xff80000015157808ULL, 0x000fe40002000000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0x000000ac9aff7212ULL, 0x000fe400078cc0ffULL, 0x000000189dff7212ULL, 0x000fc4000780c0ffULL,
0x0000004c9dff7212ULL, 0x000fe4000784c0ffULL, 0x0000006d9fff7212ULL, 0x040fe4000786c0ffULL,
0x000000199fff7212ULL, 0x040fe4000782c0ffULL, 0x000000559fff7212ULL, 0x000fe4000788c0ffULL,
0x00000019a0ff7212ULL, 0x000fe400078ac0ffULL, 0x000000b08700720cULL, 0x000fc400037c1470ULL,
0x000000b08b00720cULL, 0x0c0fe40000701470ULL, 0x000000b08b00720cULL, 0x080fe40001741470ULL,
0x000000b06900720cULL, 0x0c0fe40001f61470ULL, 0x000000b06900720cULL, 0x0c0fe40000f21470ULL,
0x000000b06900720cULL, 0x080fe40002781470ULL, 0x000000b08f00720cULL, 0x000fc40002fa1470ULL,
0x000000b08c00720cULL, 0x080fe400037c1070ULL, 0x000000b08600720cULL, 0x0c0fe40000701070ULL,
0x000000b08600720cULL, 0x080fe40001741070ULL, 0x000000b06700720cULL, 0x0c0fe40001f61070ULL,
0x000000b06700720cULL, 0x0c0fe40000f21070ULL, 0x000000b06700720cULL, 0x000fc40002781070ULL,
0x000000b06e00720cULL, 0x000fe40002fa1070ULL, 0x000000a156a17219ULL, 0x040fe400000006ffULL,
0x000000b356a27219ULL, 0x000fe400000006ffULL, 0xff80000049497808ULL, 0x000fe40003000000ULL,
0xff80000010107808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fc40001000000ULL,
0xff80000038387808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fe40000800000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x0000007b9eff7212ULL, 0x000fe400078cc0ffULL, 0x0000006da0ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006da1ff7212ULL, 0x040fe4000784c0ffULL, 0x0000006ba0ff7212ULL, 0x040fe4000786c0ffULL,
0x00000055a0ff7212ULL, 0x000fe4000782c0ffULL, 0x0000006ba1ff7212ULL, 0x000fe4000788c0ffULL,
0x00000019a2ff7212ULL, 0x000fe400078ac0ffULL, 0x000000b08d00720cULL, 0x000fc400037c1470ULL,
0x000000b08f00720cULL, 0x0c0fe40000701470ULL, 0x000000b08f00720cULL, 0x0c0fe40001f61470ULL,
0x000000b08f00720cULL, 0x080fe40000f21470ULL, 0x000000b09300720cULL, 0x0c0fe40001741470ULL,
0x000000b09300720cULL, 0x080fe40002781470ULL, 0x000000b09400720cULL, 0x000fc40002fa1470ULL,
0x000000b08400720cULL, 0x080fe400037c1070ULL, 0x000000b06e00720cULL, 0x0c0fe40000701070ULL,
0x000000b06e00720cULL, 0x0c0fe40001f61070ULL, 0x000000b06e00720cULL, 0x080fe40000f21070ULL,
0x000000b06a00720cULL, 0x0c0fe40001741070ULL, 0x000000b06a00720cULL, 0x000fc40002781070ULL,
0x000000b06800720cULL, 0x000fe40002fa1070ULL, 0x000000a356a37219ULL, 0x000fe400000006ffULL,
0x0000541065667816ULL, 0x000fe40000000066ULL, 0x00005410611a7816ULL, 0x000fe4000000001aULL,
0xff8000000d0d7808ULL, 0x000fe40003000000ULL, 0xff80000039397808ULL, 0x000fc40000000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001800000ULL, 0xff8000002b2b7808ULL, 0x000fe40000800000ULL,
0xff80000034347808ULL, 0x000fe40001000000ULL, 0xff80000036367808ULL, 0x000fe40002000000ULL,
0xff80000025257808ULL, 0x000fe40002800000ULL, 0x0000006da2ff7212ULL, 0x000fc400078cc0ffULL,
0x0000006ba2ff7212ULL, 0x040fe4000780c0ffULL, 0x00000019a1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000055a1ff7212ULL, 0x080fe4000782c0ffULL, 0x00000055a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000066a3ff7212ULL, 0x040fe4000788c0ffULL, 0x0000001aa3ff7212ULL, 0x000fc400078ac0ffULL,
0x000000b09300720cULL, 0x0c0fe40001f61470ULL, 0x000000b09300720cULL, 0x080fe40000f21470ULL,
0x000000b09400720cULL, 0x0c0fe400037c1470ULL, 0x000000b09400720cULL, 0x0c0fe40000701470ULL,
0x000000b09400720cULL, 0x080fe40001741470ULL, 0x000000b05d00720cULL, 0x000fc40002781470ULL,
0x000000b05d00720cULL, 0x080fe40002fa1470ULL, 0x000000b06a00720cULL, 0x0c0fe40001f61070ULL,
0x000000b06a00720cULL, 0x080fe40000f21070ULL, 0x000000b06800720cULL, 0x0c0fe400037c1070ULL,
0x000000b06800720cULL, 0x0c0fe40000701070ULL, 0x000000b06800720cULL, 0x000fc40001741070ULL,
0x000000b05900720cULL, 0x0c0fe40002781070ULL, 0x000000b05900720cULL, 0x000fe40002fa1070ULL,
0x000000b156a47219ULL, 0x040fe400000006ffULL, 0x000000a556a57219ULL, 0x040fe400000006ffULL,
0x0000009956997219ULL, 0x000fe400000006ffULL, 0x0000541063647816ULL, 0x000fc40000000064ULL,
0xff80000024247808ULL, 0x000fe40001800000ULL, 0xff80000026267808ULL, 0x000fe40000800000ULL,
0xff80000035357808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fc40002000000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0x00000066a4ff7212ULL, 0x0c0fe4000786c0ffULL,
0x00000066a5ff7212ULL, 0x080fe4000782c0ffULL, 0x0000006699ff7212ULL, 0x000fe400078cc0ffULL,
0x00000064a3ff7212ULL, 0x080fe4000780c0ffULL, 0x00000064a4ff7212ULL, 0x000fc4000784c0ffULL,
0x00000064a5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001aa4ff7212ULL, 0x000fe400078ac0ffULL,
0x000000b05d00720cULL, 0x080fe40000701470ULL, 0x000000b09500720cULL, 0x0c0fe40001f61470ULL,
0x000000b09500720cULL, 0x0c0fe40001741470ULL, 0x000000b09500720cULL, 0x000fc40002fa1470ULL,
0x000000b09600720cULL, 0x0c0fe40000f21470ULL, 0x000000b09700720cULL, 0x080fe400037c1470ULL,
0x000000b09600720cULL, 0x080fe40002781470ULL, 0x000000b05900720cULL, 0x080fe40000701070ULL,
0x000000b06000720cULL, 0x0c0fe40001f61070ULL, 0x000000b06000720cULL, 0x000fc40001741070ULL,
0x000000b06000720cULL, 0x080fe40002fa1070ULL, 0x000000b05e00720cULL, 0x080fe40000f21070ULL,
0x000000b05c00720cULL, 0x080fe400037c1070ULL, 0x000000b05e00720cULL, 0x000fe40002781070ULL,
0x000054105f627816ULL, 0x000fe40000000062ULL, 0xff80000032327808ULL, 0x000fc40000000000ULL,
0xff80000031317808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff8000002d2d7808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fc40002000000ULL,
0x0000006499ff7212ULL, 0x000fe4000780c0ffULL, 0x0000001aa5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000001a99ff7212ULL, 0x000fe4000784c0ffULL, 0x00000062a3ff7212ULL, 0x080fe400078ac0ffULL,
0x00000062a4ff7212ULL, 0x080fe4000782c0ffULL, 0x00000062a5ff7212ULL, 0x000fc400078cc0ffULL,
0x0000006299ff7212ULL, 0x000fe4000788c0ffULL, 0x000000b05d00720cULL, 0x080fe40002fa1470ULL,
0x000000b09500720cULL, 0x080fe40000f21470ULL, 0x000000b09600720cULL, 0x0c0fe40001f61470ULL,
0x000000b09600720cULL, 0x080fe400037c1470ULL, 0x000000b09700720cULL, 0x000fc40000701470ULL,
0x000000b09700720cULL, 0x0c0fe40001741470ULL, 0x000000b09700720cULL, 0x080fe40002781470ULL,
0x000000b05900720cULL, 0x080fe40002fa1070ULL, 0x000000b06000720cULL, 0x080fe40000f21070ULL,
0x000000b05c00720cULL, 0x080fe40000701070ULL, 0x000000b05e00720cULL, 0x000fc40001f61070ULL,
0x000000b05e00720cULL, 0x080fe400037c1070ULL, 0x000000b05c00720cULL, 0x0c0fe40001741070ULL,
0x000000b05c00720cULL, 0x000fe40002781070ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff8000001c1c7808ULL, 0x000fe40001800000ULL, 0xff8000001d1d7808ULL, 0x000fc40001000000ULL,
0xff80000022227808ULL, 0x000fe40002800000ULL, 0xff80000023237808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fe40003000000ULL, 0xff8000001f1f7808ULL, 0x000fce0002000000ULL,
0x000000110400720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x000000016f6f7836ULL, 0x000fe40000000000ULL, 0x0000000411047208ULL, 0x000fe20004000000ULL,
0x000000ffff6e7224ULL, 0x000fc600078e0058ULL, 0x000000510400720bULL, 0x000fc80003f1e000ULL,
0x00000004510b7208ULL, 0x000fc80004000000ULL, 0x000000480b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b48047208ULL, 0x000fc80004000000ULL, 0x000000490400720bULL, 0x000fc80003f1e000ULL,
0x00000004490b7208ULL, 0x000fc80004000000ULL, 0x000000400b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b40047208ULL, 0x000fc80004000000ULL, 0x000000410400720bULL, 0x000fc80003f1e000ULL,
0x00000004410b7208ULL, 0x000fc80004000000ULL, 0x0000000c0b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b0c047208ULL, 0x000fc80004000000ULL, 0x0000000d0400720bULL, 0x000fc80003f1e000ULL,
0x000000040d0b7208ULL, 0x000fc80004000000ULL, 0x000000380b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b38047208ULL, 0x000fc80004000000ULL, 0x000000390400720bULL, 0x000fc80003f1e000ULL,
0x00000004390b7208ULL, 0x000fc80004000000ULL, 0x000000340b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b34047208ULL, 0x000fc80004000000ULL, 0x000000350400720bULL, 0x000fc80003f1e000ULL,
0x00000004350b7208ULL, 0x000fc80004000000ULL, 0x000000300b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b30047208ULL, 0x000fc80004000000ULL, 0x000000310400720bULL, 0x000fc80003f1e000ULL,
0x00000004310b7208ULL, 0x000fc80004000000ULL, 0x0000002c0b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b2c047208ULL, 0x000fe40004000000ULL, 0x000000520500720bULL, 0x000fe40003f1e000ULL,
0x0000002d0400720bULL, 0x000fc80003f3e000ULL, 0x000000042d0b7208ULL, 0x000fe40004800000ULL,
0x0000000552047208ULL, 0x000fc60004000000ULL, 0x0c401f000b187f89ULL, 0x000ea200000e0000ULL,
0x000000530400720bULL, 0x000fc80003f1e000ULL, 0x0000000453057208ULL, 0x000fc80004000000ULL,
0x0000004a0500720bULL, 0x000fc80003f1e000ULL, 0x000000054a047208ULL, 0x000fc80004000000ULL,
0x0000004b0400720bULL, 0x000fc80003f1e000ULL, 0x000000044b057208ULL, 0x000fe40004000000ULL,
0x000000180b00720bULL, 0x004fe40003f3e000ULL, 0x000000420500720bULL, 0x000fe40003f1e000ULL,
0x0000000b18197208ULL, 0x000fe40004800000ULL, 0x0000000542047208ULL, 0x000fc60004000000ULL,
0x0c201f0019187f89ULL, 0x000ea200000e0000ULL, 0x000000430400720bULL, 0x000fc80003f1e000ULL,
0x0000000443057208ULL, 0x000fc80004000000ULL, 0x0000000e0500720bULL, 0x000fc80003f1e000ULL,
0x000000050e047208ULL, 0x000fc80004000000ULL, 0x0000000f0400720bULL, 0x000fc80003f1e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x000000181900720bULL, 0x004fe40003f3e000ULL,
0x0000003a0500720bULL, 0x000fe40003f1e000ULL, 0x0000001918047208ULL, 0x000fe40004800000ULL,
0x000000053a187208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b04547820ULL, 0x000fe20000410000ULL,
0x0000003b1800720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b48197823ULL, 0x100fe20000010854ULL,
0x000000183b057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b401b7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b0d507823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b414c7823ULL, 0x100fe20000010854ULL,
0x000000360500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b38417823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b2d387823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b51187823ULL, 0x100fe20000010854ULL,
0x00000005361a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b30307823ULL, 0x000fe20000010854ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000371a00720bULL, 0x000fc80003f1e000ULL, 0x0000001a37057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b491a7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b0c497823ULL, 0x000fe20000010854ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x000000320500720bULL, 0x000fc80003f1e000ULL,
0x0000000532487208ULL, 0x000fc60004000000ULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x000000334800720bULL, 0x000fc80003f1e000ULL, 0x0000004833057208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b39487823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b34397823ULL, 0x000fe20000010854ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000002e0500720bULL, 0x000fc80003f1e000ULL,
0x000000052e407208ULL, 0x000fc60004000000ULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x0000002f4000720bULL, 0x000fc80003f1e000ULL, 0x000000402f407208ULL, 0x000fe40004000000ULL,
0x000000130600720bULL, 0x000fe20003f1e000ULL, 0x0000004c004c7308ULL, 0x000fe40000000800ULL,
0x0c401f00400b7f89ULL, 0x000ea200000e0000ULL, 0x0000000613067208ULL, 0x000fc80004000000ULL,
0x0000004d0600720bULL, 0x000fe20003f1e000ULL, 0x0000004900497308ULL, 0x000fe60000000800ULL,
0x000000064d057208ULL, 0x000fc80004000000ULL, 0x000000440500720bULL, 0x000fe20003f1e000ULL,
0x0000005000507308ULL, 0x000fe60000000800ULL, 0x0000000544067208ULL, 0x000fc80004000000ULL,
0x000000450600720bULL, 0x000fe20003f1e000ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x0000000b4000720bULL, 0x004fe40003f3e000ULL, 0x0000000645057208ULL, 0x000fe40004000000ULL,
0x000000400b0c7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b35407823ULL, 0x100fe20000010854ULL,
0x0000003c0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b310b7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b2c317823ULL, 0x000fe20000010854ULL, 0x0c201f000c357f89ULL, 0x000ea200000e0000ULL,
0x000000053c067208ULL, 0x000fe20004000000ULL, 0x0000004800487308ULL, 0x000fe60000000800ULL,
0x0000003d0600720bULL, 0x000fc80003f1e000ULL, 0x000000063d057208ULL, 0x000fe20004000000ULL,
0x0000003900397308ULL, 0x000fe60000000800ULL, 0x000000100500720bULL, 0x000fc80003f1e000ULL,
0x0000000510057208ULL, 0x000fe20004000000ULL, 0x0000004000407308ULL, 0x000fe60000000800ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000350c00720bULL, 0x004fe40003f3e000ULL,
0x00000005120d7208ULL, 0x000fe20004000000ULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x0000000c35057208ULL, 0x000fc40004800000ULL, 0x000000280d00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b05517820ULL, 0x000fe20000410000ULL, 0x0000000d28067208ULL, 0x000fe20004000000ULL,
0x0000003800387308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b4b347823ULL, 0x100fe20000010851ULL,
0x000000290600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b520d7823ULL, 0x100fe20000010851ULL,
0x3fb8aa3b43527823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b0f547823ULL, 0x100fe20000010851ULL,
0x00000006292d7208ULL, 0x000fe20004000000ULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b532c7823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b3b3b7823ULL, 0x000fe20000010851ULL,
0x000000242d00720bULL, 0x000fc80003f1e000ULL, 0x0000002d24067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4a2d7823ULL, 0x100fe20000010851ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b374a7823ULL, 0x100fe20000010851ULL, 0x000000250600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b33377823ULL, 0x100fe20000010851ULL, 0x3fb8aa3b2e337823ULL, 0x000fe40000010851ULL,
0x0000000625357208ULL, 0x000fe40004000000ULL, 0x0000004e0700720bULL, 0x000fe20003f1e000ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x000000203500720bULL, 0x000fc40003f3e000ULL,
0x000000074e067208ULL, 0x000fe40004000000ULL, 0x00000035200c7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b42357823ULL, 0x100fe20000010851ULL, 0x0000004f0600720bULL, 0x000fe20003f1e000ULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x000000210c00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b3a427823ULL, 0x100fe20000010851ULL, 0x000000064f077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2f3a7823ULL, 0x000fe20000010851ULL, 0x0000000c214b7208ULL, 0x000fc40004800000ULL,
0x000000460700720bULL, 0x000fe20003f1e000ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x0000001c4b00720bULL, 0x000fe40003f3e000ULL, 0x0000000746067208ULL, 0x000fe40004000000ULL,
0x0000004b1c0c7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b0e4b7823ULL, 0x100fe20000010851ULL,
0x000000470600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b360e7823ULL, 0x100fe20000010851ULL,
0x0000001d0c00720bULL, 0x000fe20003f3e000ULL, 0x0000002c002c7308ULL, 0x000ea20000000800ULL,
0x0000000647077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b32367823ULL, 0x000fe20000010851ULL,
0x0000000c1d0c7208ULL, 0x000fc40004800000ULL, 0x0000003e0700720bULL, 0x000fc60003f1e000ULL,
0x0c401f000c437f89ULL, 0x000ee200000e0000ULL, 0x000000073e067208ULL, 0x000fe20004000000ULL,
0x0000004b004b7308ULL, 0x000fe60000000800ULL, 0x0000003f0600720bULL, 0x000fe40003f1e000ULL,
0x0000000d2c0d723eULL, 0x004fe400000010ffULL, 0x000000063f077208ULL, 0x000fe20004000000ULL,
0x0000005400547308ULL, 0x000ea60000000800ULL, 0x000000140700720bULL, 0x000fc80003f1e000ULL,
0x0000000714067208ULL, 0x000fe20004000000ULL, 0x0000004200427308ULL, 0x000fe60000000800ULL,
0x000000150600720bULL, 0x000fe40003f1e000ULL, 0x000000430c00720bULL, 0x008fe40003f3e000ULL,
0x0000000615077208ULL, 0x000fe20004000000ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000000c430c7208ULL, 0x000fc40004800000ULL, 0x0000002a0700720bULL, 0x000fc60003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000ee200000e0000ULL, 0x000000072a067208ULL, 0x000fe20004000000ULL,
0x0000000e00437308ULL, 0x000be60000000800ULL, 0x0000002b0600720bULL, 0x000fc80003f1e000ULL,
0x000000062b077208ULL, 0x000fe20004000000ULL, 0x0000004a004a7308ULL, 0x000fe60000000800ULL,
0x000000260700720bULL, 0x000fc80003f1e000ULL, 0x0000000726067208ULL, 0x000fe20004000000ULL,
0x0000003600367308ULL, 0x000fe60000000800ULL, 0x000000270600720bULL, 0x000fe40003f1e000ULL,
0x0000000f0c00720bULL, 0x008fe40003f3e000ULL, 0x0000000627077208ULL, 0x000fe20004000000ULL,
0x0000003700377308ULL, 0x000fe20000000800ULL, 0x0000000c0f067208ULL, 0x000fc40004800000ULL,
0x000000220700720bULL, 0x000fe40003f1e000ULL, 0x0000002d340f723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b060e7820ULL, 0x022fe20000410000ULL, 0x00000007220c7208ULL, 0x000fe20004000000ULL,
0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b44447823ULL, 0x100fe2000001080eULL, 0x000000230c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001080eULL, 0x0000000c23077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3c327823ULL, 0x100fe2000001080eULL, 0x0000004400577308ULL, 0x0003e20000000800ULL,
0x3f8000003434783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b3d537823ULL, 0x100fe2000001080eULL,
0x0000001e0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b10557823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b125e7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b28517823ULL, 0x100fe2000001080eULL,
0x000000071e0c7208ULL, 0x000fe20004000000ULL, 0x00000013002e7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b1c447823ULL, 0x102fe2000001080eULL, 0x3fb8aa3b295c7823ULL, 0x100fe2000001080eULL,
0x0000001f0c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b25567823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b203c7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b213d7823ULL, 0x000fe2000001080eULL,
0x0000000c1f0c7208ULL, 0x000fe20004000000ULL, 0x0000004d002f7308ULL, 0x0003e20000000800ULL,
0x0000001b4c10723eULL, 0x000fc400000010ffULL, 0x000000495012723eULL, 0x000fe200000010ffULL,
0x0c401f000c077f89ULL, 0x000ee200000e0000ULL, 0xfffffff8ff507812ULL, 0x000fe400078ee216ULL,
0x0000004b5413723eULL, 0x004fe200000010ffULL, 0x0000004500607308ULL, 0x0005620000000800ULL,
0x3fb8aa3b244d7823ULL, 0x002fe2000001080eULL, 0x0000001050547836ULL, 0x000fcc0000000000ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d457823ULL, 0x004fe2000001080eULL,
0x000000191a0e723eULL, 0x000fe400000010ffULL, 0x00000057601a723eULL, 0x020fc800000010ffULL,
0x0000005300537308ULL, 0x000fe20000000800ULL, 0x00000003ff607819ULL, 0x000fe20000011609ULL,
0x0000001850577836ULL, 0x000fe20000000000ULL, 0x000000070c00720bULL, 0x008fe40003f1e000ULL,
0x0000000409167810ULL, 0x000fe20007ffe060ULL, 0x0000000857627824ULL, 0x000fe200078e00ffULL,
0x0000000c07077208ULL, 0x000fe20004000000ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x0000000857577824ULL, 0x000fc600078e00ffULL, 0x0c201f00070c7f89ULL, 0x000e6800000e0000ULL,
0x0000005e005e7308ULL, 0x000eb00000000800ULL, 0x0000004d004d7308ULL, 0x000ff00000000800ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x0000000c0700720bULL, 0x002fc80003f1e000ULL,
0x000000070c077208ULL, 0x000fc60004000000ULL, 0x0000005100517308ULL, 0x000fe20000000800ULL,
0x00000011180c723eULL, 0x000fe400000010ffULL, 0x000000355211723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b071c7820ULL, 0x000fe20000410000ULL, 0x000000ffff357224ULL, 0x000fe200078e0034ULL,
0x0000002e2f18723eULL, 0x000fe200000010ffULL, 0x0000000850527836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b46467823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b47477823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x000000340c2c723cULL, 0x000fe200000418ffULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2b207823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL,
0x0000004700477308ULL, 0x000e620000000800ULL, 0x3fb8aa3b23497823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b1e4b7823ULL, 0x000fe2000001081cULL, 0x000000555e1e723eULL, 0x004fc400000010ffULL,
0x000000434a23723eULL, 0x000fe200000010ffULL, 0x000000ffff437224ULL, 0x000fe200078e0034ULL,
0x0000000309ff7812ULL, 0x000fe2000780c0ffULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x00000046471b723eULL, 0x002fce00000010ffULL, 0x0000004f004f7308ULL, 0x000e620000000800ULL,
0x0000000716477812ULL, 0x000fe200078ec0ffULL, 0x0000000852167824ULL, 0x000fe200078e00ffULL,
0x00000034102c723cULL, 0x000fe8000004182cULL, 0xfffffff816167812ULL, 0x000fe200078ee247ULL,
0x0000001400217308ULL, 0x0005e20000000800ULL, 0x0000004e4f19723eULL, 0x002fce00000010ffULL,
0x0000001500467308ULL, 0x0002e20000000800ULL, 0x000000ffff147224ULL, 0x004fe400078e0034ULL,
0x3fb8aa3b1f4f7823ULL, 0x000fe2000001081cULL, 0x00000008544e7824ULL, 0x000fc800078e00ffULL,
0x0000002a00257308ULL, 0x0005e20000000800ULL, 0x000000ffff157224ULL, 0x002fe200078e0034ULL,
0x00000021461f723eULL, 0x008fcc00000010ffULL, 0x0000003e001d7308ULL, 0x0003e20000000800ULL,
0x000000141828723cULL, 0x004fe200000418ffULL, 0x000000423b21723eULL, 0x000fe200000010ffULL,
0x000000ffff427224ULL, 0x000fca00078e0034ULL, 0x0000003f00247308ULL, 0x000ea20000000800ULL,
0x00000008503e7824ULL, 0x002fe200078e00ffULL, 0xfffffff84e157812ULL, 0x000fe400078ee247ULL,
0xfffffff862147812ULL, 0x000fe400078ee247ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee247ULL,
0x3fb8aa3b22477823ULL, 0x000fe2000001081cULL, 0x00000032531c723eULL, 0x000fe200000010ffULL,
0x00000020004c7308ULL, 0x0002e20000000800ULL, 0x000000394022723eULL, 0x000fe200000010ffULL,
0x0000000852397824ULL, 0x000fe200078e00ffULL, 0x0000000360327812ULL, 0x000fc400078ec0ffULL,
0x0000001d241d723eULL, 0x004fc600000010ffULL, 0x0000005c005c7308ULL, 0x000ea20000000800ULL,
0x000000414820723eULL, 0x002fe200000010ffULL, 0x0000000132327824ULL, 0x000fe400078e0209ULL,
0x000000341c28723cULL, 0x000fe20000041828ULL, 0x000000254c25723eULL, 0x008fc600000010ffULL,
0x00000026003f7308ULL, 0x0003e40000000800ULL, 0x000000ffff4c7224ULL, 0x100fe200078e0034ULL,
0x0000000732327812ULL, 0x000fe200078ec0ffULL, 0x00000042202c723cULL, 0x000fe2000004182cULL,
0x0000000850357824ULL, 0x000fe400078e00ffULL, 0xfffffff839467812ULL, 0x000fe200078ee232ULL,
0x00000027004e7308ULL, 0x000ee20000000800ULL, 0x0000004d5626723eULL, 0x002fe200000010ffULL,
0x000000ffff4d7224ULL, 0x000fe200078e0034ULL, 0x000000515c24723eULL, 0x004fc400000010ffULL,
0xfffffff835357812ULL, 0x000fe400078ee232ULL, 0xfffffff8574a7812ULL, 0x000fe200078ee232ULL,
0x0000000b000b7308ULL, 0x000e620000000800ULL, 0x0000003f4e27723eULL, 0x008fce00000010ffULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x00000008543f7824ULL, 0x000fe200078e00ffULL,
0x0000004c2428723cULL, 0x000fe80000041828ULL, 0xfffffff83f487812ULL, 0x000fe400078ee232ULL,
0x0000003a003a7308ULL, 0x000ea20000000800ULL, 0x000000313832723eULL, 0x000fe200000010ffULL,
0x000000ffff3f7224ULL, 0x000fe200078e0012ULL, 0x000000363731723eULL, 0x000fe200000010ffULL,
0x000000ffff367224ULL, 0x100fe200078e0034ULL, 0x000000300b30723eULL, 0x002fe200000010ffULL,
0x000000ffff377224ULL, 0x000fc400078e0034ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x00001000770b7824ULL, 0x000fe400078e0208ULL, 0x000000ffff347224ULL, 0x000fe400078e0020ULL,
0x000120000b0b7836ULL, 0x000fe20000000000ULL, 0x000000333a33723eULL, 0x004fe400000010ffULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x0000001046467824ULL, 0x100fe400078e020bULL,
0x0000001016167824ULL, 0x000fc400078e020bULL, 0x000000ffff127224ULL, 0x000fe200078e0031ULL,
0x00000036302c723cULL, 0x000fe2000004182cULL, 0x0000001048487824ULL, 0x000fe200078e020bULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x000000ffff207224ULL, 0x000fe400078e0018ULL,
0x000000ffff187224ULL, 0x000fe400078e0019ULL, 0x000000ffff317224ULL, 0x000fe200078e0026ULL,
0x0000003c3d38723eULL, 0x002fe400000010ffULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0x000000ffff3c7224ULL, 0x000fc400078e000cULL, 0x000000ffff3d7224ULL, 0x000fe400078e000eULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff0d7224ULL, 0x000fe200078e000fULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0011ULL,
0x000000103e2d7824ULL, 0x100fe400078e020bULL, 0x00000010152f7824ULL, 0x000fe200078e020bULL,
0x00000044453a723eULL, 0x002fc400000010ffULL, 0x0000004900407308ULL, 0x000e620000000800ULL,
0x0000001035157824ULL, 0x000fe400078e020bULL, 0x000000ffff3e7224ULL, 0x000fe400078e0010ULL,
0x000000ffff357224ULL, 0x000fe400078e0022ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0013ULL,
0x0000004b003b7308ULL, 0x000fe20000000800ULL, 0x000000ffff107224ULL, 0x000fe200078e0021ULL,
0x0000003c15007844ULL, 0x000fe20000000200ULL, 0x000000ffff117224ULL, 0x000fc400078e0023ULL,
0x000000ffff137224ULL, 0x000fe200078e0033ULL, 0x000000474039723eULL, 0x002fe400000010ffULL,
0x0000004f00427308ULL, 0x000e620000000800ULL, 0x000000ffff217224ULL, 0x000fe400078e001aULL,
0x000000ffff227224ULL, 0x000fe400078e001cULL, 0x000000ffff237224ULL, 0x000fe400078e001eULL,
0x000000ffff337224ULL, 0x000fc400078e003aULL, 0x000000ffff197224ULL, 0x000fe400078e001bULL,
0x000000104a4a7824ULL, 0x000fe400078e020bULL, 0x000000ffff1a7224ULL, 0x000fe200078e001dULL,
0x0000003b423b723eULL, 0x002fe200000010ffULL, 0x000000ffff1b7224ULL, 0x000fe400078e001fULL,
0x0000001014147824ULL, 0x000fe400078e020bULL, 0x000000ffff1c7224ULL, 0x000fc400078e0025ULL,
0x000000363828723cULL, 0x000fe20000041828ULL, 0x000000ffff1d7224ULL, 0x000fca00078e0027ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0039ULL, 0x000000ffff1f7224ULL, 0x000fe400078e003bULL,
0x000000ffff367224ULL, 0x000fe400078e0030ULL, 0x000000ffff377224ULL, 0x000fe400078e0032ULL,
0x000000ffff307224ULL, 0x000fe400078e0024ULL, 0x000000ffff327224ULL, 0x000fe200078e0038ULL,
0x000000342d007844ULL, 0x0003e80000000200ULL, 0x0000000c46007844ULL, 0x0005e80000000200ULL,
0x0000001016007844ULL, 0x000fe80000000200ULL, 0x0000002048007844ULL, 0x000fe80000000200ULL,
0x000000302f007844ULL, 0x0007e20000000200ULL, 0x000000ffff2d7224ULL, 0x002fc400078e002eULL,
0x000000ffff2e7224ULL, 0x000fe200078e0028ULL, 0x000000184a007844ULL, 0x0003e20000000200ULL,
0x00000001ff0c7424ULL, 0x004fc600078e00ffULL, 0x0000001c14007844ULL, 0x0003e80000000200ULL,
0x01a0000417008388ULL, 0x0003e20000000c00ULL, 0x000000ffff2f7224ULL, 0x008fca00078e002aULL,
0x01a2002c17008388ULL, 0x0003e20000000c00ULL, 0x000000706f00720cULL, 0x000fe20003f06070ULL,
0x01a6080c71ff79a7ULL, 0x0003e2000850003fULL, 0x01a6100c71ff79a7ULL, 0x0003e2000850003fULL,
0x01a6180c71ff79a7ULL, 0x0003e2000850003fULL, 0x01a6200c71ff79a7ULL, 0x0003f2000850003fULL,
0xffffff8800208947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000084007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000008400008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff84ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000084027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000008400007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe6402707950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004ebULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL, 0x0000000000000228ULL,
0x0000001500000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000890ULL, 0x00000000000000e0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000009c4ULL, 0x0000000000000710ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000019b00ULL,
0x0000001500000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ac80ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001acc0ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000001acc0ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x000000000001b2b8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001b2b8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001120ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000019b00ULL, 0x0000000000019b00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x000000000001ac80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001acc0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 111624;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
