/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c3c0ULL, 0x000000000001c040ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001a450ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001a5d0ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001a610ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001a660ULL, 0x0000000000000120ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001a780ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001a45000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0067800400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001a45000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL,
0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a508288080a2ULL,
0xaa08288080a80828ULL, 0x288080c108288080ULL, 0x80f208288080f108ULL, 0x1628808088082880ULL,
0x0000031028808280ULL, 0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x0001a5d000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8808288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a508288080a2ULL, 0xaa08288080a90828ULL,
0x288080c108288080ULL, 0x80f208288080f108ULL, 0x16288080a8082880ULL, 0x0000031028808280ULL,
0xa892000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000001a800000000ULL,
0x0001a61000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL, 0x80aa288080a80900ULL,
0x0000000000002880ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8808288080830828ULL,
0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a508288080a2ULL,
0xaa08288080a80828ULL, 0x288080c108288080ULL, 0x80f208288080f108ULL, 0x16288080a9082880ULL,
0x0000031028808280ULL, 0xa992000000000000ULL, 0x0000002200288080ULL, 0x0000002cffffffffULL,
0x0000027000000000ULL, 0x0001a66000000000ULL, 0x0000012000000000ULL, 0x0000080400000000ULL,
0x80aa288080a90900ULL, 0x0000000000002880ULL, 0x0000001900082f04ULL, 0x00082304000000deULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL,
0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL, 0x0000001600080a04ULL,
0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL, 0x00000000000c1704ULL,
0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x019c290400000eb0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x019c2804ffffffffULL, 0x0000032000000150ULL, 0x00002c40000005a0ULL, 0x00002e0000002cf0ULL,
0x000030e000002f70ULL, 0x000036c000003240ULL, 0x0000371000003700ULL, 0x0000611000003740ULL,
0x000062c0000061a0ULL, 0x000065a000006430ULL, 0x00006b8000006700ULL, 0x00006bd000006bc0ULL,
0x000093a000006c00ULL, 0x0000956000009440ULL, 0x00009840000096d0ULL, 0x00009e00000099a0ULL,
0x00009e5000009e40ULL, 0x0000c5f000009e80ULL, 0x0000c7a00000c690ULL, 0x0000ca800000c910ULL,
0x0000d0600000cbe0ULL, 0x0000d0b00000d0a0ULL, 0x0000ed400000d0e0ULL, 0x0000ed600000ed50ULL,
0x000180d00000ed70ULL, 0x0001812000018110ULL, 0x0001818000018130ULL, 0x000181c0000181a0ULL,
0x000195c0000181d0ULL, 0x0001966000019610ULL, 0x000196e0000196a0ULL, 0x0001977000019720ULL,
0x00019810000197c0ULL, 0x000198b000019860ULL, 0x0001995000019900ULL, 0x000199d000019990ULL,
0x00019a6000019a10ULL, 0x00019b0000019ab0ULL, 0x00019ba000019b50ULL, 0x00019c4000019bf0ULL,
0x00019cc000019c80ULL, 0x00019d5000019d00ULL, 0x00019df000019da0ULL, 0x00019e9000019e40ULL,
0x00019f3000019ee0ULL, 0x00019fb000019f70ULL, 0x0001a04000019ff0ULL, 0x0001a0e00001a090ULL,
0x0001a1900001a130ULL, 0x0001a2500001a1f0ULL, 0x0001a3100001a2b0ULL, 0x0001a3d00001a370ULL,
0x044039040001a430ULL, 0x000000ff00000410ULL, 0x003f010000012600ULL, 0x0000000f00000450ULL,
0x003f012000012608ULL, 0x0000000f000004e0ULL, 0x003f012000012688ULL, 0x0000000f00000510ULL,
0x003f0120000126a8ULL, 0x0000000f00000530ULL, 0x003f0120000126c8ULL, 0x000000ff00000ed0ULL,
0x003f010700012600ULL, 0x00000003000010c0ULL, 0x003f010200000004ULL, 0x0000000300001180ULL,
0x003f010100000000ULL, 0x000000ff00001ac0ULL, 0x0004010700000000ULL, 0x000000ff00001b40ULL,
0x0004010100000000ULL, 0x0000000600001ba0ULL, 0x003f0101000126c8ULL, 0x0000000800001d30ULL,
0x003f0105000126ccULL, 0x0000000800001f10ULL, 0x003f0105000126ccULL, 0x0000000a00002830ULL,
0x003f0107000126b0ULL, 0x0000000a000028e0ULL, 0x003f0101000126b0ULL, 0x0000002200002940ULL,
0x003f010100012608ULL, 0x0000002200002960ULL, 0x003f01050001260cULL, 0x0000002200002b30ULL,
0x003f01050001260cULL, 0x0000000a000033f0ULL, 0x003f0105000126acULL, 0x0000000a000035e0ULL,
0x003f0105000126acULL, 0x0000006c000052f0ULL, 0x003f010100000000ULL, 0x0000002500005350ULL,
0x003f010100012688ULL, 0x0000001300005380ULL, 0x003f010500000004ULL, 0x0000001300005540ULL,
0x003f010500000004ULL, 0x0000001000005d10ULL, 0x003f010700000000ULL, 0x0000001000005df0ULL,
0x003f010100000000ULL, 0x0000002200005e50ULL, 0x003f010100012628ULL, 0x0000002200005e70ULL,
0x003f01050001262cULL, 0x0000002200006040ULL, 0x003f01050001262cULL, 0x00000070000068f0ULL,
0x003f0105000126b4ULL, 0x0000007000006ac0ULL, 0x003f0105000126b4ULL, 0x0000002a00008580ULL,
0x003f010100000000ULL, 0x00000026000085e0ULL, 0x003f010100012690ULL, 0x0000001300008610ULL,
0x003f010500000004ULL, 0x00000013000087d0ULL, 0x003f010500000004ULL, 0x000000ff00008f90ULL,
0x0004010700000008ULL, 0x0000002a00009080ULL, 0x003f0101000126b0ULL, 0x00000022000090e0ULL,
0x003f010100012648ULL, 0x0000002200009100ULL, 0x003f01050001264cULL, 0x00000022000092d0ULL,
0x003f01050001264cULL, 0x0000001000009b70ULL, 0x003f010500000004ULL, 0x0000001000009d40ULL,
0x003f010500000004ULL, 0x000000130000b7c0ULL, 0x003f010100000000ULL, 0x000000020000b820ULL,
0x003f010100012698ULL, 0x000000130000b850ULL, 0x003f010500000004ULL, 0x000000130000ba10ULL,
0x003f010500000004ULL, 0x000000ff0000c250ULL, 0x0004010700000000ULL, 0x000000100000c2e0ULL,
0x003f010100000000ULL, 0x000000060000c340ULL, 0x003f010100012668ULL, 0x000000060000c370ULL,
0x003f01050001266cULL, 0x000000060000c540ULL, 0x003f01050001266cULL, 0x0000000a0000cdc0ULL,
0x003f0105000126b4ULL, 0x0000000a0000cf90ULL, 0x003f0105000126b4ULL, 0x000000130000eaf0ULL,
0x003f010100000000ULL, 0x000000060000eb70ULL, 0x003f010100000000ULL, 0x000000ff00010df0ULL,
0x003f010100012600ULL, 0x000000ff00011a30ULL, 0x003f010500012604ULL, 0x000000ff00011c40ULL,
0x003f010500012604ULL, 0x000000ff00011fc0ULL, 0x003f010100012600ULL, 0x000000ff00011ff0ULL,
0x003f010500012604ULL, 0x000000ff000121b0ULL, 0x003f010500012604ULL, 0x0000006a00015340ULL,
0x003f010100000000ULL, 0x0000006a00015430ULL, 0x003f010500000004ULL, 0x0000006a00015600ULL,
0x003f010500000004ULL, 0x0000006e00019420ULL, 0x003f010100000000ULL, 0x0000006e00019480ULL,
0x003f010100000008ULL, 0x0000006e000194e0ULL, 0x003f010100000010ULL, 0x0000006e00019550ULL,
0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000fd000000fcd0ULL, 0x000101900000ffa0ULL,
0x0001057000010380ULL, 0x0001095000010760ULL, 0x00010d0000010b50ULL, 0x0001959000012210ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000314ULL, 0x0000001900000002ULL,
0x000000000000024cULL, 0x0000001900000002ULL, 0x0000000000000194ULL, 0x0000001900000002ULL,
0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x00000000000002eeULL, 0x0000001900000002ULL, 0x0000000000000226ULL, 0x0000001900000002ULL,
0x000000000000016eULL, 0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL,
0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x0000000104060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0003ULL,
0x00005c0004020625ULL, 0x000fe200078e0003ULL, 0x0000000606000981ULL, 0x0002aa000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000057b06ULL, 0x000f220000209000ULL,
0x00005900ff657624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000001e7919ULL, 0x000e680000002600ULL, 0x00000000000e7919ULL, 0x000e680000002300ULL,
0x00000000000a7919ULL, 0x000e620000002100ULL, 0x0000000500057308ULL, 0x010f240000001000ULL,
0x0ffffffe05087810ULL, 0x010fc40007ffe0ffULL, 0x00000005ff1f7819ULL, 0x002fc8000001160aULL,
0x0000000800097305ULL, 0x000324000021f000ULL, 0x00001fff1f1f7589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x010fc800078e0a09ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fcc00078e0008ULL,
0x00000400090b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x008fc800078e0a0bULL,
0x0000040002027624ULL, 0x000fca00078e0265ULL, 0x0000590002007a0cULL, 0x000fda0003f26070ULL,
0x8000590002021a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590002007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00027306ULL, 0x000e620000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003f85070ULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000070b057224ULL, 0x008fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a05ULL, 0x0000000507077227ULL, 0x000fe400078e0006ULL,
0x0000000000057919ULL, 0x000e680000002200ULL, 0x0000001e07207227ULL, 0x000fc800078e00ffULL,
0x000000ffff027224ULL, 0x000fc800078e0a20ULL, 0x000000020b027224ULL, 0x000fca00078e021eULL,
0x0000000b0200720cULL, 0x000fe20003fa6070ULL, 0x000001000e057a24ULL, 0x002fe400078e0205ULL,
0x00001fff0e0e7589ULL, 0x000e6400000e0000ULL, 0x00000000050f7a24ULL, 0x000fd000078e020aULL,
0x0000000102025824ULL, 0x000fe200078e0a0bULL, 0x0000000120205810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x0000000b0200720cULL, 0x000fe40003fc6070ULL,
0x0000000f0f00780cULL, 0x040fe40003f24070ULL, 0x0000007f0f00780cULL, 0x040fe40003f44070ULL,
0x000000030f00780cULL, 0x000fca0003fa4070ULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000120206810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x0000000bff20c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x01260006ff00b388ULL, 0x0007e20000000a00ULL,
0x000000ffff027224ULL, 0x000fe200078e0a20ULL, 0x000000010f00780cULL, 0x000fe20003f64070ULL,
0xff317217ff10a424ULL, 0x000fe200078e00ffULL, 0x012608080f009388ULL, 0x000fe20000008a00ULL,
0x000000020b1e7224ULL, 0x000fc400078e021eULL, 0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL,
0x012400100f00a388ULL, 0x0009e20000004800ULL, 0x000000201e1e7824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff06d424ULL, 0x008fe400078e00ffULL, 0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL,
0x012688060f00d388ULL, 0x000fe20000008a00ULL, 0x00005a00ff107624ULL, 0x010fc400078e00ffULL,
0x7fffffc0ff0db424ULL, 0x000fe200078e00ffULL, 0x0126a80a0f00d388ULL, 0x000fe20000008a00ULL,
0x0000590010107a24ULL, 0x000fc600078e02ffULL, 0x0126c80c0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000100190824ULL, 0x004fe400078e0a03ULL, 0x00005800ff198624ULL, 0x000fe400078e00ffULL,
0x0000580004038a24ULL, 0x000fe400078e02ffULL, 0x00005a0019057a24ULL, 0x000fe400078e02ffULL,
0x0000001003777224ULL, 0x000fe400078e02ffULL, 0x0000000105007824ULL, 0x040fe200078e0a1eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001e0500720cULL, 0x000fe20003f26070ULL,
0x00005a0020117a24ULL, 0x000fe200078e0277ULL, 0x0000002000007817ULL, 0x000fc80003800000ULL,
0x000000ff00767207ULL, 0x000fe20000800000ULL, 0x000000040e007824ULL, 0x002fc600078e021fULL,
0x000000207600780cULL, 0x000fe20003f05270ULL, 0x0000000400007824ULL, 0x000fd800078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000057b06ULL, 0x000e620000209000ULL,
0x00000000001d7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000500057308ULL, 0x002e620000001000ULL, 0x00000004ff027819ULL, 0x004fc8000001161dULL,
0x0000000202097810ULL, 0x000fe20007ffe0ffULL, 0x00000001000a7824ULL, 0x000fe200078e0202ULL,
0x0ffffffe05077810ULL, 0x002fc60007ffe0ffULL, 0x00000001000b7824ULL, 0x000fc600078e0209ULL,
0x0000000700077305ULL, 0x000e62000021f000ULL, 0x000000011e0c7824ULL, 0x000fe400078e020bULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07057227ULL, 0x000fc800078e0006ULL, 0x000000011e067824ULL, 0x000fe400078e020aULL,
0x0000000c050d7227ULL, 0x000fc800078e00ffULL, 0x0000000605077227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a07ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0dULL,
0x00005a0005057a24ULL, 0x000fe400078e0206ULL, 0x00005a000f087a24ULL, 0x000fc600078e020cULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff087a12ULL, 0x000fe400078e33ffULL,
0x0000000076057217ULL, 0x000fe40007800000ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0d3810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a00ULL,
0x0000000708077207ULL, 0x000fe20004000000ULL, 0x000000010a007824ULL, 0x000fe200078e021dULL,
0x0000000d08087207ULL, 0x000fc40004000000ULL, 0x000000050200720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a07ULL, 0x000000050900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a08ULL, 0x00005a000d067a24ULL, 0x000fe400078e0206ULL,
0x00005a000f0c7a24ULL, 0x000fe400078e020cULL, 0x0000000111067824ULL, 0x040fe400078e0206ULL,
0x00000001110d7824ULL, 0x000fc400078e020cULL, 0x0000001007067224ULL, 0x080fe400078e0206ULL,
0x000000101d027824ULL, 0x000fe400078e00ffULL, 0x0000001008087224ULL, 0x000fe400078e020dULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x000000f002057812ULL, 0x000fc600078ec0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000506067212ULL, 0x000fc600078efcffULL,
0x000000100a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000508057212ULL, 0x000fe200078efcffULL,
0x000000010b0a7824ULL, 0x040fe200078e021dULL, 0x0000600006067a10ULL, 0x000fe20007f5e0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d007812ULL, 0x000fe400078ee200ULL,
0x0000600005087a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc400017fe4ffULL,
0x0000610009097a10ULL, 0x000fe20001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000c101c46ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000027b06ULL, 0x000e620000209000ULL, 0x00000000001d7919ULL, 0x000eae0000000000ULL,
0x0000000200027308ULL, 0x002e620000001000ULL, 0x000000001d007211ULL, 0x004fc800078fe0ffULL,
0x00000002000a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe02067810ULL, 0x002fe20007ffe0ffULL,
0x000000011e027824ULL, 0x000fc600078e0200ULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x0000000507087227ULL, 0x000fc800078e0006ULL,
0x000000011e077824ULL, 0x000fe400078e020aULL, 0x0000000208057227ULL, 0x000fc800078e00ffULL,
0x0000000708087227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x00005a0009067a24ULL, 0x000fe400078e0202ULL,
0x00005a000c097a24ULL, 0x000fe400078e0207ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00005a0006007a0cULL, 0x000fe40003f06070ULL, 0x00005a0009007a0cULL, 0x000fd60003f46070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a0009007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000108083810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000806087207ULL, 0x000fc60004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a05ULL, 0x000000ffff067224ULL, 0x000fe400078e0a08ULL,
0x00005a0009027a24ULL, 0x000fe400078e0202ULL, 0x00005a0006077a24ULL, 0x000fe400078e0207ULL,
0x0000000111067824ULL, 0x040fe400078e0202ULL, 0x0000000111077824ULL, 0x000fc400078e0207ULL,
0x000000101d027824ULL, 0x000fe400078e00ffULL, 0x0000001005067224ULL, 0x080fe400078e0206ULL,
0x0000001008087224ULL, 0x000fe200078e0207ULL, 0x000000f0020b7812ULL, 0x000fe200078ec0ffULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000b06067212ULL, 0x000fc600078efcffULL, 0x0000000100057824ULL, 0x100fe200078e021dULL,
0x0000000b08087212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x000fe200078e021dULL,
0x0000600006067a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00c057812ULL, 0x000fe400078ee205ULL, 0x0000600008087a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b007812ULL, 0x000fe200078ee200ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc400007fe4ffULL, 0x0000610009097a10ULL, 0x000fe20000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000080b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fe200038e0000ULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000057300ULL, 0x000e7000000e0000ULL, 0x0000000000077309ULL, 0x000ea20000000000ULL,
0x000000060500720cULL, 0x002fe20003f02070ULL, 0x000000ffff057224ULL, 0x004fc400078e0a07ULL,
0x0000680004067625ULL, 0x000fd400078e0035ULL, 0x01260405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006061c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x0000007f1c1b7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1c057810ULL, 0x002fc40007ffe0ffULL,
0x00000007ff1b7819ULL, 0x000fe4000001161bULL, 0x00000008ff1a7819ULL, 0x000fca0000011605ULL,
0x0000fd0000008947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe2000001161fULL,
0x00000003ff087424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x01ffffff19197812ULL, 0x000fc800078ec0ffULL, 0x0000001b1900720cULL, 0x000fda0003f06070ULL,
0x0000000204008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff038624ULL, 0x000fc800078e00ffULL,
0x00006a0000008624ULL, 0x000fe200078e0203ULL, 0x000126881f037811ULL, 0x000fc600078e18ffULL,
0x0000000119008824ULL, 0x000fe200078e0200ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040803ff738cULL, 0x0003e20000000000ULL, 0x0000660000068625ULL, 0x000fe200078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606278981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x0000008020177824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001161fULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000003ff7f8cULL, 0x0007e6000c80043fULL, 0x0000002018807824ULL, 0x000fca00078e00ffULL,
0x0000006017057812ULL, 0x000fe200078ef880ULL, 0x0000590027007a24ULL, 0x004fc800078e02ffULL,
0x00000080000e7824ULL, 0x000fe200078e00ffULL, 0x000000011f007812ULL, 0x000fc600078ec0ffULL,
0x000064000e0e7625ULL, 0x000fe200078e000fULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x000000801c037217ULL, 0x00afe20007800000ULL, 0x0000001000007824ULL, 0x000fe200078e00ffULL,
0x00000003ff067819ULL, 0x000fc6000001161dULL, 0x0000000103037824ULL, 0x000fe200078e0a80ULL,
0x0000000406097810ULL, 0x000fe20007ffe0ffULL, 0x0000000100087824ULL, 0x000fe200078e0206ULL,
0x0000000c060b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000003037217ULL, 0x000fe20007800000ULL,
0x0000000108077824ULL, 0x040fe400078e021dULL, 0x0000000808107824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fc400078e0a00ULL, 0x00000001000c7824ULL, 0x000fe200078e020bULL,
0xfffffff810107812ULL, 0x000fe400078ee207ULL, 0x0000000806077810ULL, 0x040fe40007ffe0ffULL,
0x000000030600720cULL, 0x080fe20003f66070ULL, 0x0000000105067824ULL, 0x000fe200078e0208ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x00000001000a7824ULL, 0x000fe200078e0207ULL,
0x000000030900720cULL, 0x080fe20003f46070ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000030b00720cULL, 0x000fc60003f06070ULL, 0x0000000100087824ULL, 0x000fe200078e0209ULL,
0x00000070060d7812ULL, 0x000fe200078ef802ULL, 0x00000001050b7824ULL, 0x040fe400078e020cULL,
0x000000010c067824ULL, 0x140fe400078e021dULL, 0x000000080c097824ULL, 0x000fe200078e00ffULL,
0x0000000d0e0c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000105007824ULL, 0x000fe400078e0208ULL,
0x0000000108037824ULL, 0x040fe200078e021dULL, 0xfffffff809167812ULL, 0x000fe200078ee206ULL,
0x0000000808127824ULL, 0x000fc400078e00ffULL, 0x0000000105087824ULL, 0x000fe400078e020aULL,
0x000000010f0d7824ULL, 0x000fe200020e0607ULL, 0xfffffff812127812ULL, 0x000fe200078ee203ULL,
0x0000008000067825ULL, 0x000fe200078e00ffULL, 0x0000e00018037811ULL, 0x000fc600078e68ffULL,
0x000000010a057824ULL, 0x000fe200078e021dULL, 0x0000007006237812ULL, 0x000fe200078ef802ULL,
0x000000080a147824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008217812ULL, 0x000fc600078ef802ULL, 0x0000001010057824ULL, 0x100fe200078e0203ULL,
0x000000700a157812ULL, 0x000fe200078ef802ULL, 0x0000001012117824ULL, 0x100fe200078e0203ULL,
0x000000230e027210ULL, 0x000fe20007f9e0ffULL, 0x0000001014137824ULL, 0x100fe200078e0203ULL,
0x000000210e067210ULL, 0x040fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c057faeULL, 0x0003e2000d901c46ULL, 0x000000150e087210ULL, 0x000fe20007fde0ffULL,
0x0000001016157824ULL, 0x000fe400078e0203ULL, 0x000000010f037824ULL, 0x000fc400020e0607ULL,
0x000000010f077824ULL, 0x040fe400028e0609ULL, 0x000000010f097824ULL, 0x000fe200030e060bULL,
0x0000000002117faeULL, 0x0003e8000d101c46ULL, 0x0000000006137faeULL, 0x0003e8000c901c46ULL,
0x0000000008157faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001000007824ULL, 0x008fe200078e00ffULL, 0x0000e00018237811ULL, 0x000fc800078e68ffULL,
0x000000001d007211ULL, 0x000fc800078fe8ffULL, 0x0000000c000c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105067824ULL, 0x000fe200078e0200ULL, 0x0000000400087810ULL, 0x042fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e021dULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x00000008000a7824ULL, 0x000fe200078e00ffULL, 0x00000070060d7812ULL, 0x000fe200078ef802ULL,
0x00000001050b7824ULL, 0x000fe400078e020cULL, 0x000000010c067824ULL, 0x000fe200078e021dULL,
0xfffffff80a037812ULL, 0x000fe200078ee203ULL, 0x000000080c117824ULL, 0x000fe200078e00ffULL,
0x00000008000a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108097824ULL, 0x000fe200078e021dULL,
0x0000000d0e0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000808107824ULL, 0x000fe200078e00ffULL,
0xfffffff811147812ULL, 0x000fe200078ee206ULL, 0x0000000105007824ULL, 0x000fc400078e0208ULL,
0x0000000105087824ULL, 0x000fe200078e020aULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x000000010f0d7824ULL, 0x000fe400000e0607ULL, 0x000000010a057824ULL, 0x040fe400078e021dULL,
0x000000080a127824ULL, 0x000fe400078e00ffULL, 0x0000008000067825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000007006217812ULL, 0x000fc600078ef802ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008157812ULL, 0x000fc600078ef802ULL, 0x0000001003057824ULL, 0x100fe200078e0223ULL,
0x000000700a037812ULL, 0x000fe200078ef802ULL, 0x0000001010117824ULL, 0x100fe200078e0223ULL,
0x000000210e027210ULL, 0x000fe20007f1e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0223ULL,
0x000000150e067210ULL, 0x000fe20007f3e0ffULL, 0x0000001014157824ULL, 0x000fe200078e0223ULL,
0x000000030e087210ULL, 0x000fe20007f5e0ffULL, 0x000000010f037824ULL, 0x040fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c057faeULL, 0x0003e2000b901c46ULL,
0x000000010f077824ULL, 0x000fc400008e0609ULL, 0x000000010f097824ULL, 0x000fe200010e060bULL,
0x0000000002117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000008157faeULL, 0x0003e4000b901c46ULL, 0x00000000180473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1a00720cULL, 0x000fe20003f05270ULL, 0x0000000818067824ULL, 0x002fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3d7224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff027f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126c80006067f8cULL, 0x000ea2000c80043fULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000cf6000008947ULL, 0x000fea0003800000ULL, 0x0000000204167824ULL, 0x000fe200078e00ffULL,
0x00000002ff157819ULL, 0x000fe2000001161fULL, 0x00006a00ff057624ULL, 0x000fe200078e00ffULL,
0x0000000118757812ULL, 0x000fe200078ec0ffULL, 0x000000ffff007224ULL, 0x002fc400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0x00006a0016167624ULL, 0x000fe400078e0205ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x0000000000047805ULL, 0x01afca0000015200ULL,
0x000000041f067824ULL, 0x000fca00078e00ffULL, 0xfffffff806087812ULL, 0x000fc800078ec0ffULL,
0x000126c808137810ULL, 0x000fe20007ffe0ffULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101f037824ULL, 0x000fe200078e00ffULL,
0x0000000114077810ULL, 0x000fe20007ffe0ffULL, 0x0000590027277a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008027047824ULL, 0x000fe200078e00ffULL,
0x0000001a0700720cULL, 0x000fc60003f46070ULL, 0x0000010014057824ULL, 0x000fca00078e0205ULL,
0x0000004005077810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff057424ULL, 0x000fc600078e00ffULL,
0x0000006007067812ULL, 0x000fe200078ec0ffULL, 0x0000640004047625ULL, 0x000fc800078e0005ULL,
0x0000000117257824ULL, 0x000fe200078e0206ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x0000001003087812ULL, 0x000fe200078ec0ffULL, 0x000000101d0a7824ULL, 0x000fe200078e00ffULL,
0x000000071c037217ULL, 0x000fe40007800000ULL, 0x00000003ff097819ULL, 0x000fe4000001161dULL,
0x000000700a277812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a07ULL,
0x0000000409127810ULL, 0x040fe20007ffe0ffULL, 0x0000000109067824ULL, 0x040fe200078e0208ULL,
0x00000008090a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000803037217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe200078e021dULL, 0x0000000c09227810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe400078e00ffULL, 0x0000000125067824ULL, 0x000fe400078e0206ULL,
0x0000000103037824ULL, 0x000fe200078e0a08ULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0x000000031200720cULL, 0x0c0fe20003f86070ULL,
0x0000000112127824ULL, 0x100fe200078e0208ULL, 0x000000030900720cULL, 0x000fe20003fa6070ULL,
0x0000000122267824ULL, 0x000fe200078e0208ULL, 0x00000027060b7212ULL, 0x000fe200078efcffULL,
0x0000000125097824ULL, 0x000fe200078e0212ULL, 0x000000030a00720cULL, 0x040fe20003f66070ULL,
0x000000010a067824ULL, 0x000fe200078e0208ULL, 0x0000000b040a7210ULL, 0x000fe20007fde0ffULL,
0x0000008009087825ULL, 0x000fe200078e00ffULL, 0x000000032200720cULL, 0x000fc60003f06070ULL,
0x00000001050b7824ULL, 0x000fe200030e0607ULL, 0x0000002708237212ULL, 0x000fe200078efcffULL,
0x0000000125077824ULL, 0x000fe400078e0206ULL, 0x0000000112037824ULL, 0x100fe200078e021dULL,
0x0000002304227210ULL, 0x000fe20007fde0ffULL, 0x0000000812127824ULL, 0x000fe400078e00ffULL,
0x0000000106087824ULL, 0x040fe400078e021dULL, 0x0000000806297824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x0000008007067825ULL, 0x000fc600078e00ffULL,
0xfffffff829247812ULL, 0x000fe200078ee208ULL, 0x0000000125257824ULL, 0x000fe200078e0226ULL,
0x0000002706037212ULL, 0x000fe200078efcffULL, 0x0000000105237824ULL, 0x000fe400030e0609ULL,
0x0000008025087825ULL, 0x000fe200078e00ffULL, 0x0000000304067210ULL, 0x000fe40007fde0ffULL,
0x0000f00018037811ULL, 0x000fe200078e68ffULL, 0x0000000126257824ULL, 0x000fe200078e021dULL,
0x0000002708277212ULL, 0x000fe200078efcffULL, 0x0000000826267824ULL, 0x000fc400078e00ffULL,
0x0000000105077824ULL, 0x040fe200030e0607ULL, 0x0000002704047210ULL, 0x000fe20007fde0ffULL,
0x0000001012277824ULL, 0x000fe200078e0203ULL, 0xfffffff826087812ULL, 0x000fe200078ee225ULL,
0x0000001010257824ULL, 0x100fe400078e0203ULL, 0x0000001024297824ULL, 0x100fe400078e0203ULL,
0x0000001008037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a257faeULL, 0x0003e2000e901c46ULL, 0x0000000105057824ULL, 0x000fc600030e0609ULL,
0x0000000022277faeULL, 0x0003e8000e101c46ULL, 0x0000000006297faeULL, 0x0003e8000d901c46ULL,
0x0000000004037faeULL, 0x0003e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001003067812ULL, 0x000fe200078ec0ffULL, 0x000000101d077824ULL, 0x000fe200078e00ffULL,
0x0000f000186f7811ULL, 0x000fc400078e68ffULL, 0x000000061d067211ULL, 0x000fe400078fe8ffULL,
0x0000007007297812ULL, 0x000fe400078ec0ffULL, 0x0000000806107810ULL, 0x040fe20007ffe0ffULL,
0x0000000106037824ULL, 0x040fe200078e021dULL, 0x0000000c06127810ULL, 0x040fe20007ffe0ffULL,
0x0000000806087824ULL, 0x000fe400078e00ffULL, 0x0000000125077824ULL, 0x040fe400078e0206ULL,
0x0000000125247824ULL, 0x000fe200078e0212ULL, 0xfffffff808037812ULL, 0x000fe200078ee203ULL,
0x00000001100b7824ULL, 0x000fe200078e021dULL, 0x0000000406087810ULL, 0x000fe20007ffe0ffULL,
0x0000008007067825ULL, 0x000fc800078e00ffULL, 0x0000000125097824ULL, 0x040fe200078e0208ULL,
0x0000002906237212ULL, 0x000fe200078efcffULL, 0x00000001080a7824ULL, 0x140fe400078e021dULL,
0x0000000808277824ULL, 0x000fe200078e00ffULL, 0x0000002304227210ULL, 0x000fe20007f1e0ffULL,
0x0000000125087824ULL, 0x000fe400078e0210ULL, 0x0000000810267824ULL, 0x000fe200078e00ffULL,
0xfffffff827107812ULL, 0x000fe200078ee20aULL, 0x0000000112067824ULL, 0x000fc400078e021dULL,
0x0000000812257824ULL, 0x000fe200078e00ffULL, 0xfffffff826127812ULL, 0x000fe200078ee20bULL,
0x0000000105237824ULL, 0x000fe400000e0607ULL, 0x00000080240a7825ULL, 0x000fe200078e00ffULL,
0xfffffff825267812ULL, 0x000fc600078ee206ULL, 0x0000008009067825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000029066d7212ULL, 0x000fc600078efcffULL,
0x0000001003037824ULL, 0x100fe200078e026fULL, 0x00000029082b7212ULL, 0x080fe200078efcffULL,
0x0000001010257824ULL, 0x100fe200078e026fULL, 0x000000290a297212ULL, 0x000fe200078efcffULL,
0x0000001012277824ULL, 0x000fe200078e026fULL, 0x0000006d04067210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022037faeULL, 0x0003e2000b901c46ULL,
0x0000002b04087210ULL, 0x040fe40007f7e0ffULL, 0x0000002904047210ULL, 0x000fe20007f9e0ffULL,
0x0000000105077824ULL, 0x000fc400000e0607ULL, 0x0000000105097824ULL, 0x040fe400018e0609ULL,
0x0000001026297824ULL, 0x000fe200078e026fULL, 0x0000000006257faeULL, 0x0003e2000b901c46ULL,
0x0000000105057824ULL, 0x000fc600020e060bULL, 0x0000000008277faeULL, 0x0003e8000b901c46ULL,
0x0000000004297faeULL, 0x0003e4000b901c46ULL, 0x000000081f037824ULL, 0x002fe200078e00ffULL,
0x0000000119047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001b0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003227812ULL, 0x040fe400078ec0ffULL,
0x0000001003077812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000116048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002203227210ULL, 0x000fe40007ffe007ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000660004048625ULL, 0x000fca00078e0005ULL, 0x0000000604248981ULL, 0x000522000c1e1900ULL,
0x000126b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080022087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01260c0022037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0022037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101d127824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe2000001161dULL,
0x000000201f037824ULL, 0x000fe400078e00ffULL, 0xffffffffff817424ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ec0ffULL, 0xffffff8003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c74747812ULL, 0x000fc800078ec0ffULL, 0x0000000374037210ULL, 0x000fca0007ffe012ULL,
0x0120000003057984ULL, 0x000e680000000800ULL, 0x0122000003047984ULL, 0x0006a20000000800ULL,
0x000000020500720bULL, 0x002fe20003f1d000ULL, 0x000169627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x008fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e0002ULL, 0x0000001fff837424ULL, 0x000fe400078e00ffULL,
0xffffffffff827424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001f1500720cULL, 0x000fe40003f05270ULL, 0x000000020500720bULL, 0x000fe20003f74000ULL,
0x000169027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x000000801f078824ULL, 0x000fe200078e0212ULL, 0x0000000205237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174108824ULL, 0x000fca00078e0207ULL,
0x0124002310008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000000223027221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL, 0x0000000200027308ULL, 0x000e640000000800ULL,
0x0000000221217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x000168427f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x000167127f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x000165e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x000164c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fda00078030ffULL, 0x8000002305050221ULL, 0x000fe20000010000ULL,
0x00007610ff060816ULL, 0x000fc60000000006ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500110308ULL, 0x000e640000000800ULL, 0x0000001104040220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002104217221ULL, 0x004fc20000010000ULL,
0x0000000000027805ULL, 0x008fcc0000015200ULL, 0x0126ac000a057984ULL, 0x000e620000000800ULL,
0x000126a80a107810ULL, 0x000fe40007ffe0ffULL, 0x8000000005ff7812ULL, 0x002fe20007804800ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991006007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe4000001161dULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000160827f007947ULL, 0x000fea000b800000ULL,
0x00001f03000f7589ULL, 0x0002a400000e0000ULL, 0x0000000803297810ULL, 0x000fe20007ffe0ffULL,
0x000160b27f007947ULL, 0x000fea000b800000ULL, 0x00000010030d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f29000e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d000d7589ULL, 0x0006a400000e0000ULL,
0x0000001803297810ULL, 0x008fe20007ffe0ffULL, 0x000161027f007947ULL, 0x000fea000b800000ULL,
0x00001f29000c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021f257824ULL, 0x000fe200078e00ffULL, 0x000000081d027812ULL, 0x000fe200078ec0ffULL,
0x000000041f067824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x0000000425007812ULL, 0x00afc400078ec0ffULL,
0x00000007020b7812ULL, 0x000fe200078ef81dULL, 0x000004001f027824ULL, 0x000fe200078e00ffULL,
0x000000001d047211ULL, 0x000fe400078fe0ffULL, 0x000000100b097812ULL, 0x040fe200078efcffULL,
0x000000080b037824ULL, 0x040fe200078e00ffULL, 0x0000000406067812ULL, 0x000fe200078ec0ffULL,
0x000000010b0a7824ULL, 0x000fe200078e0204ULL, 0xfffff000027d7812ULL, 0x000fe200078ec0ffULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x000000061d027211ULL, 0x000fe200078fe0ffULL,
0x0000000809077824ULL, 0x000fe200078e00ffULL, 0xfffffff8030a7812ULL, 0x000fe200078ee20aULL,
0x000010001f037824ULL, 0x000fe200078e00ffULL, 0x0000a0007d7d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fc400078ee208ULL,
0xffffe00003057812ULL, 0x000fe200078ec0ffULL, 0x000000010b037824ULL, 0x000fe400078e0202ULL,
0x000000100a6c7824ULL, 0x100fe200078e027dULL, 0x0000e00005057810ULL, 0x000fe20007ffe0ffULL,
0x0000001008287824ULL, 0x000fe200078e027dULL, 0xfffffff804077812ULL, 0x000fc600078ee203ULL,
0x000000006c6c783bULL, 0x000e640000000200ULL, 0x0000001007707824ULL, 0x000fe400078e0205ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7231ULL, 0x086fe400003400ffULL, 0x0000000f6e6e7231ULL, 0x000fe400003400ffULL,
0x0000000e6d6d7231ULL, 0x080fe400003400ffULL, 0x0000000e6f6f7231ULL, 0x000fc400003400ffULL,
0x0000000d28287231ULL, 0x088fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000080b797824ULL, 0x000fe200078e00ffULL,
0x0000000203067810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x0000000200007812ULL, 0x000fe200078efcffULL, 0x00000ce000007945ULL, 0x000fe20003800000ULL,
0xfffffff879067812ULL, 0x000fc400078ee206ULL, 0x000000001d007211ULL, 0x000fc600078fe0ffULL,
0x0000001006787824ULL, 0x000fcc00078e0205ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x00000018ff047819ULL, 0x108fe40000011670ULL, 0x00000010ff037819ULL, 0x000fe40000011670ULL,
0x00000004ff04723eULL, 0x000fe400020006ffULL, 0x000000ff70057812ULL, 0x040fe400078ec0ffULL,
0x0000ffff70967812ULL, 0x000fe400078ec0ffULL, 0x000000ff73867812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7e7819ULL, 0x100fe40000011671ULL, 0x000000ff717c7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe40000011671ULL, 0x0000ffff71987812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x000fe40000011672ULL, 0x000000ff72847812ULL, 0x000fc400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011672ULL, 0x0000ffff72997812ULL, 0x000fe200078ec0ffULL,
0x20000004ff727230ULL, 0x000fe20000004100ULL, 0x00000086ff04723eULL, 0x000fe400020006ffULL,
0x00000018ff8e7819ULL, 0x004fe40000011679ULL, 0x00000018ff857819ULL, 0x000fe20000011673ULL,
0x20000004ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fc40000011679ULL,
0x000000ff79907812ULL, 0x040fe400078ec0ffULL, 0x0000ffff799c7812ULL, 0x000fe400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000010ff937819ULL, 0x100fe4000001167aULL,
0x000000ff7a917812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fc4000001167aULL,
0x0000ffff7a9d7812ULL, 0x000fe400078ec0ffULL, 0x0000008eff04723eULL, 0x000fe400020006ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001167bULL, 0x00000010ff8b7819ULL, 0x100fe20000011678ULL,
0x20000004ff957230ULL, 0x000fe20000004100ULL, 0x000000ff788c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fc40000011678ULL, 0x0000ffff789b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff03037812ULL, 0x000fe400078ec0ffULL, 0x00000085ff78723eULL, 0x000fe200020006ffULL,
0x20000070ff857230ULL, 0x000fe20000004100ULL, 0x0000007aff70723eULL, 0x000fe400020006ffULL,
0x00000003ff04723eULL, 0x000fe200020006ffULL, 0x20000078ff8d7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000070ff037230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x20000004ff707230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000071ff897230ULL, 0x000fe20000004100ULL,
0x00000008ff047819ULL, 0x000fc40000011696ULL, 0x00000010ff877819ULL, 0x000fe40000011673ULL,
0x0000ffff739a7812ULL, 0x000fe200078ec0ffULL, 0x2000007cff737230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000008ff717819ULL, 0x000fe40000011698ULL,
0x00000091ff7c723eULL, 0x000fe200020006ffULL, 0x20000088ff917230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff7a7230ULL, 0x000fe20000004100ULL,
0x00000004ff04723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000071ff78723eULL, 0x000fc400020006ffULL, 0x000000ff87887812ULL, 0x000fe200078ec0ffULL,
0x20000004ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe40000011699ULL,
0x0000007fff79723eULL, 0x000fe200020006ffULL, 0x20000078ff7f7230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000087ff04723eULL, 0x000fe200020006ffULL,
0x20000079ff877230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fc4000001169aULL,
0x000000ff8b797812ULL, 0x000fe200078ec0ffULL, 0x20000088ff8b7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000004ff887230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x2000008cff8e7230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000090ff927230ULL, 0x000fe20000004100ULL, 0x00000005ff05723eULL, 0x000fc400020006ffULL,
0x00000008ff047819ULL, 0x000fe2000001169bULL, 0x20000078ff8c7230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000005ff057230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000084ff867230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x000000ff7b947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff907819ULL, 0x000fe2000001169cULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000004ff04723eULL, 0x000fe400020006ffULL,
0x0000008fff78723eULL, 0x000fe200020006ffULL, 0x20000079ff8f7230ULL, 0x000fe20000004100ULL,
0x00000094ff84723eULL, 0x000fe400020006ffULL, 0x000000ff93797812ULL, 0x000fe200078ec0ffULL,
0x20000078ff937230ULL, 0x000fe20000004100ULL, 0x00000090ff94723eULL, 0x000fe200020006ffULL,
0x20000004ff907230ULL, 0x000fe20000004100ULL, 0x00000010ff047819ULL, 0x000fe20000011605ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000079ff96723eULL, 0x000fe200020006ffULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fc40000011673ULL,
0x00000010ff057819ULL, 0x000fe20000011670ULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe40000011672ULL, 0x00000010ff797819ULL, 0x000fe4000001167eULL,
0x00000010ff707819ULL, 0x000fe40000011671ULL, 0x00000010ff977819ULL, 0x000fe4000001167bULL,
0x0000ffff7b7b7812ULL, 0x000fc400078ec0ffULL, 0x0000105405047816ULL, 0x000fe40000000004ULL,
0x0000105479057816ULL, 0x000fe40000000078ULL, 0x0000105473707816ULL, 0x000fe40000000070ULL,
0x00000010ff737819ULL, 0x000fe4000001168aULL, 0x00000010ff787819ULL, 0x000fe2000001168bULL,
0x000000046c2c723cULL, 0x002f62000004182cULL, 0x00000010ff717819ULL, 0x000fc4000001167fULL,
0x000000ff97977812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fe4000001169dULL,
0x00000008ff7b7819ULL, 0x000fe2000001167bULL, 0x00000004284c723cULL, 0x000b62000004184cULL,
0x0000105478737816ULL, 0x000fe40000000073ULL, 0x00000010ff727819ULL, 0x000fe40000011685ULL,
0x00000010ff787819ULL, 0x000fc40000011688ULL, 0x00000010ff867819ULL, 0x000fe20000011686ULL,
0x000000010b057824ULL, 0x120fe200078e0200ULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x0000000109047824ULL, 0x040fe200078e0200ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x0000000109007824ULL, 0x000fe200078e0202ULL, 0x0000007fff85723eULL, 0x000fe400020006ffULL,
0x0000007bff88723eULL, 0x000fe200020006ffULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x0000105472717816ULL, 0x000fc40000000071ULL, 0x0000105487727816ULL, 0x000fe20000000086ULL,
0x20000085ff877230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001168dULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe2000001168cULL,
0x000000706c30723cULL, 0x000f620000041830ULL, 0x00000010ff7f7819ULL, 0x000fe40000011692ULL,
0x00000010ff867819ULL, 0x000fe40000011693ULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x00000010ff7b7819ULL, 0x000fe20000011696ULL, 0x000000726c34723cULL, 0x000f620000041834ULL,
0x00000010ff857819ULL, 0x000fe40000011684ULL, 0x000010547e797816ULL, 0x000fe40000000079ULL,
0x00001054867f7816ULL, 0x000fe4000000007fULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x000000702850723cULL, 0x000f620000041850ULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x000010547b847816ULL, 0x000fe4000000007cULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff7e7819ULL, 0x000fe2000001168eULL, 0x000000722854723cULL, 0x000f620000041854ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff947819ULL, 0x000fc40000011694ULL, 0x00000010ff867819ULL, 0x000fe40000011697ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff7c7819ULL, 0x000fe20000011603ULL, 0x0000000809037824ULL, 0x000fe200078e00ffULL,
0x00000010ff7b7819ULL, 0x000fe40000011688ULL, 0x0000105491907816ULL, 0x000fc40000000090ULL,
0x0000105489787816ULL, 0x000fe40000000078ULL, 0x000010548f7e7816ULL, 0x000fe4000000007eULL,
0x0000105495917816ULL, 0x000fe40000000094ULL, 0x0000105486857816ULL, 0x000fe20000000085ULL,
0x000000786c38723cULL, 0x000f620000041838ULL, 0x000010547a7a7816ULL, 0x000fe40000000087ULL,
0x000010547c7b7816ULL, 0x000fc4000000007bULL, 0xfffffff803047812ULL, 0x000fe400078ee204ULL,
0x0000e00018037811ULL, 0x000fe200078e68ffULL, 0x0000007e6c3c723cULL, 0x040f70000004183cULL,
0x000000906c40723cULL, 0x040f700000041840ULL, 0x000000846c44723cULL, 0x040f700000041844ULL,
0x0000007a6c48723cULL, 0x000b6e0000041848ULL, 0x000000080b6c7824ULL, 0x020fe200078e00ffULL,
0x000000782858723cULL, 0x000f620000041858ULL, 0x00000008096d7824ULL, 0x000fc600078e00ffULL,
0xfffffff86c057812ULL, 0x000fe400078ee205ULL, 0xfffffff86d027812ULL, 0x000fe400078ee200ULL,
0x0000007e285c723cULL, 0x040f62000004185cULL, 0x00000010056c7824ULL, 0x100fe400078e027dULL,
0x00000010047d7824ULL, 0x000fe400078e027dULL, 0x0000001002707824ULL, 0x000fe400078e0203ULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x000000902860723cULL, 0x040f700000041860ULL,
0x000000842864723cULL, 0x040f700000041864ULL, 0x0000007a2868723cULL, 0x000b640000041868ULL,
0x000000007d28783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f6c6c7231ULL, 0x082fe400003400ffULL,
0x0000000f6e6e7231ULL, 0x000fc400003400ffULL, 0x0000000e6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000e6f6f7231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x088fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fe400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809797824ULL, 0x000fe200078e00ffULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff879007812ULL, 0x000fca00078ee200ULL, 0x0000001000787824ULL, 0x000fcc00078e0203ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000010ff7d7819ULL, 0x104fe40000011670ULL,
0x000000ff707e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011670ULL,
0x0000ffff70997812ULL, 0x000fe400078ec0ffULL, 0x000000ff71707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7f7819ULL, 0x000fc40000011671ULL, 0x00000018ff847819ULL, 0x000fe40000011671ULL,
0x0000ffff719a7812ULL, 0x000fe400078ec0ffULL, 0x00000070ff71723eULL, 0x000fe400020006ffULL,
0x0000007cff70723eULL, 0x000fe400020006ffULL, 0x00000018ff917819ULL, 0x008fe40000011679ULL,
0x00000010ff867819ULL, 0x000fc40000011672ULL, 0x000000ff72877812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011672ULL, 0x0000ffff729b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x100fe40000011673ULL, 0x000000ff73887812ULL, 0x000fe400078ec0ffULL,
0x00000018ff727819ULL, 0x000fc40000011673ULL, 0x0000ffff739c7812ULL, 0x000fe200078ec0ffULL,
0x20000070ff737230ULL, 0x000fe20000004100ULL, 0x00000091ff70723eULL, 0x000fe400020006ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fe20000011678ULL,
0x20000070ff957230ULL, 0x000fe20000004100ULL, 0x0000007dff70723eULL, 0x000fe400020006ffULL,
0x000000ff788f7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe40000011678ULL,
0x0000ffff789d7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fe20000011679ULL, 0x20000070ff717230ULL, 0x000fe20000004100ULL,
0x000000ff79927812ULL, 0x040fe400078ec0ffULL, 0x0000ffff799e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fc4000001167aULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000008ff707819ULL, 0x000fe40000011699ULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000072ff8d7230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000008ff727819ULL, 0x000fe4000001169aULL, 0x00000070ff70723eULL, 0x000fc400020006ffULL,
0x00000010ff967819ULL, 0x000fe4000001167aULL, 0x000000ff7a937812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7a9f7812ULL, 0x000fe200078ec0ffULL, 0x20000084ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff7f7f7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff847230ULL, 0x000fe20000004100ULL,
0x00000072ff79723eULL, 0x000fe200020006ffULL, 0x20000070ff727230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00000008ff707819ULL, 0x000fe2000001169cULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x000000ff86867812ULL, 0x000fe200078ec0ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff917230ULL, 0x000fe20000004100ULL,
0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000018ff947819ULL, 0x000fe2000001167bULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fc400020006ffULL, 0x0000008cff8e723eULL, 0x000fe200020006ffULL,
0x20000070ff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe2000001167eULL,
0x20000088ff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011673ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff977819ULL, 0x000fc4000001167bULL, 0x000000ff7b987812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7b7c7812ULL, 0x000fe400078ec0ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x20000094ff7d7230ULL, 0x000fe20000004100ULL, 0x00000008ff7b7819ULL, 0x000fc4000001169bULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000105471707816ULL, 0x000fe40000000070ULL,
0x0000105473727816ULL, 0x000fe20000000072ULL, 0x20000085ff897230ULL, 0x000fe20000004100ULL,
0x000010547f717816ULL, 0x000fe40000000078ULL, 0x00000010ff737819ULL, 0x000fe40000011679ULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x00000010ff787819ULL, 0x000fe20000011687ULL,
0x00000070284c723cULL, 0x080f62000004184cULL, 0x00000010ff797819ULL, 0x000fe20000011686ULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000008ff947819ULL, 0x000fe4000001169eULL,
0x000000ff96967812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x000fe2000001168bULL,
0x000000706c2c723cULL, 0x002f62000004182cULL, 0x00000010ff8a7819ULL, 0x000fc4000001168aULL,
0x00000093ff85723eULL, 0x000fe400020006ffULL, 0x0000105479787816ULL, 0x000fe40000000078ULL,
0x000000ff90937812ULL, 0x000fe200078ec0ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x00000010ff7a7819ULL, 0x000fe2000001167aULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x000010548a797816ULL, 0x000fe2000000008bULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x00000008ff907819ULL, 0x000fc4000001169dULL, 0x000000ff97977812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7f7819ULL, 0x000fe2000001169fULL, 0x000000782854723cULL, 0x080f620000041854ULL,
0x00000008ff8a7819ULL, 0x000fe4000001167cULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x000010547a737816ULL, 0x000fe40000000073ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000098ff88723eULL, 0x000fe200020006ffULL,
0x000000786c34723cULL, 0x000f620000041834ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x000fe20000011689ULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe2000001167bULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x000000722850723cULL, 0x000f620000041850ULL, 0x0000007fff86723eULL, 0x000fc400020006ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe4000001168dULL, 0x00000010ff7b7819ULL, 0x000fe2000001168cULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00001054897a7816ULL, 0x000fe2000000007aULL,
0x20000086ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fe20000011695ULL,
0x000000726c30723cULL, 0x000f620000041830ULL, 0x00000010ff877819ULL, 0x000fc40000011694ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x000010547e7b7816ULL, 0x000fe4000000007bULL, 0x00000010ff7e7819ULL, 0x000fe4000001168fULL,
0x00000010ff7f7819ULL, 0x000fe4000001168eULL, 0x000010547c877816ULL, 0x000fe20000000087ULL,
0x0000007a2858723cULL, 0x000f620000041858ULL, 0x0000105496967816ULL, 0x000fc40000000085ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff917819ULL, 0x000fe20000011691ULL, 0x0000007a6c38723cULL, 0x000f620000041838ULL,
0x00000010ff867819ULL, 0x000fe40000011690ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff977819ULL, 0x000fc40000011697ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167dULL,
0x00000010ff857819ULL, 0x000fe4000001168aULL, 0x000010547f7e7816ULL, 0x000fe4000000007eULL,
0x00001054937f7816ULL, 0x000fc40000000092ULL, 0x0000105491867816ULL, 0x000fe40000000086ULL,
0x0000105497977816ULL, 0x000fe40000000088ULL, 0x0000105484847816ULL, 0x000fe20000000089ULL,
0x0000007e285c723cULL, 0x000f62000004185cULL, 0x000010547c857816ULL, 0x000fce0000000085ULL,
0x000000862860723cULL, 0x040f700000041860ULL, 0x000000962864723cULL, 0x040f700000041864ULL,
0x000000842868723cULL, 0x000f700000041868ULL, 0x0000007e6c3c723cULL, 0x040f70000004183cULL,
0x000000866c40723cULL, 0x040f700000041840ULL, 0x000000966c44723cULL, 0x040f700000041844ULL,
0x000000846c48723cULL, 0x000b6e0000041848ULL, 0x000126c8186c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6e7224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x0000040013257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040013257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101f287824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fe400078e02ffULL, 0x00000080ff6f7424ULL, 0x000fe200078e00ffULL,
0xffffffe028257812ULL, 0x000fe200078ec0ffULL, 0x00000080246e7824ULL, 0x000fc800078e00ffULL,
0x0000010014257824ULL, 0x000fe400078e0225ULL, 0x000064006e6e7625ULL, 0x000fc600078e006fULL,
0x0000008025257810ULL, 0x000fc80007ffe0ffULL, 0x0000006025247812ULL, 0x000fca00078ec0ffULL,
0x0000000117717824ULL, 0x000fe200078e0224ULL, 0x000003d00000a947ULL, 0x000fea0003800000ULL,
0x000000251c247217ULL, 0x000fe40007800000ULL, 0x00000010286d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff297819ULL, 0x000fe2000001161dULL, 0x0000000124247824ULL, 0x000fc600078e0a25ULL,
0x00000004296c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000129287824ULL, 0x100fe200078e026dULL,
0x000000246d247217ULL, 0x000fe40007800000ULL, 0x0000000829737810ULL, 0x040fe20007ffe0ffULL,
0x000000016c787824ULL, 0x000fe200078e026dULL, 0x0000000c29797810ULL, 0x000fe20007ffe0ffULL,
0x0000000128257824ULL, 0x000fe400078e0271ULL, 0x0000000124707824ULL, 0x000fe400078e0a6dULL,
0x00000001282a7824ULL, 0x000fc400078e021dULL, 0x00000008282b7824ULL, 0x000fe200078e00ffULL,
0x000000702900720cULL, 0x080fe20003f06070ULL, 0x0000000178287824ULL, 0x000fe200078e0271ULL,
0x000000706c00720cULL, 0x080fe20003f86070ULL, 0x0000008025247825ULL, 0x000fe200078e00ffULL,
0xfffffff82b727812ULL, 0x000fe400078ee22aULL, 0x000000707300720cULL, 0x040fe20003f66070ULL,
0x00000001737a7824ULL, 0x000fe200078e026dULL, 0x00000012242b7212ULL, 0x000fe200078efcffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0x0000002b6e6c7210ULL, 0x000fe20007fbe0ffULL,
0x000000017a2a7824ULL, 0x000fe400078e0271ULL, 0x00000001797c7824ULL, 0x000fe200078e026dULL,
0x00000012286d7212ULL, 0x000fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0x0000006d6e287210ULL, 0x000fe20007fde0ffULL, 0x000000016f6d7824ULL, 0x000fe200028e0625ULL,
0x000000122a257212ULL, 0x000fe200078efcffULL, 0x000000017c247824ULL, 0x000fe200078e0271ULL,
0x000000707900720cULL, 0x000fe20003fa6070ULL, 0x000000016f297824ULL, 0x000fe200030e0629ULL,
0x000000256e2a7210ULL, 0x000fe20007fde0ffULL, 0x0000000178717824ULL, 0x040fe400078e021dULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff878707812ULL, 0x000fe200078ee271ULL, 0x000000017a737824ULL, 0x100fe200078e021dULL,
0x0000001224717212ULL, 0x000fe200078efcffULL, 0x000000087a787824ULL, 0x000fe400078e00ffULL,
0x000000017c797824ULL, 0x040fe400078e021dULL, 0x000000087c7c7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee273ULL, 0x000000016f2b7824ULL, 0x000fe200030e062bULL,
0x000000716e247210ULL, 0x000fe20007fde0ffULL, 0x0000001072717824ULL, 0x000fe200078e0203ULL,
0xfffffff87c727812ULL, 0x000fe200078ee279ULL, 0x0000001070737824ULL, 0x000fc400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c717faeULL, 0x0003e2000c101c46ULL, 0x000000016f257824ULL, 0x000fe400030e0625ULL,
0x00000010727b7824ULL, 0x000fe200078e0203ULL, 0x0000000028737faeULL, 0x0003e8000e101c46ULL,
0x000000002a797faeULL, 0x0003e8000d901c46ULL, 0x00000000247b7faeULL, 0x0003e2000e901c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001028287812ULL, 0x000fc800078ec0ffULL,
0x000000281d287211ULL, 0x000fc800078fe8ffULL, 0x00000004282a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000128247824ULL, 0x140fe200078e021dULL, 0x00000008286c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008282b7824ULL, 0x040fe200078e00ffULL, 0x0000000c287a7810ULL, 0x000fe20007ffe0ffULL,
0x000000012a257824ULL, 0x040fe400078e021dULL, 0x000000082a727824ULL, 0x000fe200078e00ffULL,
0xfffffff82b707812ULL, 0x000fe200078ee224ULL, 0x0000000128247824ULL, 0x000fe400078e0271ULL,
0x000000016c297824ULL, 0x000fe200078e021dULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000086c787824ULL, 0x000fc400078e00ffULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee229ULL, 0x000000012a287824ULL, 0x100fe400078e0271ULL,
0x000000016c2a7824ULL, 0x100fe400078e0271ULL, 0x000000017a6c7824ULL, 0x000fe200078e0271ULL,
0x0000001224717212ULL, 0x000fe200078efcffULL, 0x000000017a737824ULL, 0x040fe400078e021dULL,
0x000000087a7a7824ULL, 0x000fe200078e00ffULL, 0x000000716e247210ULL, 0x000fe20007f1e0ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee273ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001228797212ULL, 0x000fc600078efcffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000122a737212ULL, 0x080fe400078efcffULL,
0x000000796e287210ULL, 0x000fe20007f7e0ffULL, 0x000000016f257824ULL, 0x040fe200000e0625ULL,
0x000000126c717212ULL, 0x000fe200078efcffULL, 0x0000001078797824ULL, 0x000fe200078e0203ULL,
0x000000736e2a7210ULL, 0x040fe20007f1e0ffULL, 0x000000016f297824ULL, 0x000fe200018e0629ULL,
0x000000716e6c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000001072737824ULL, 0x000fe400078e0203ULL, 0x000000016f2b7824ULL, 0x040fe200000e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024717faeULL, 0x0003e2000b901c46ULL,
0x000000016f6d7824ULL, 0x000fe400020e066dULL, 0x000000107a7b7824ULL, 0x000fe200078e0203ULL,
0x0000000028737faeULL, 0x0003e8000b901c46ULL, 0x000000002a797faeULL, 0x0003e8000b901c46ULL,
0x000000006c7b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000100503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000106c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01262800222a7f8cULL, 0x000664000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x01262c0022297984ULL, 0x000f240000000800ULL,
0x8000000029ff7812ULL, 0x012fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002824717210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e25ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000007128287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c0022297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201f247824ULL, 0x000fca00078e00ffULL,
0xffffff8024257812ULL, 0x000fc800078ec0ffULL, 0x0000008012257810ULL, 0x000fca0007ffe025ULL,
0x0000000174257824ULL, 0x000fca00078e0225ULL, 0x0120000025247984ULL, 0x000e680000000800ULL,
0x0122000025707984ULL, 0x0006a20000000800ULL, 0x000000232400720bULL, 0x002fe20003f1d000ULL,
0x000137827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2a7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000115287810ULL, 0x000fe40007ffe0ffULL, 0x000000232400720bULL, 0x000fe40003f74000ULL,
0x0000001f2800720cULL, 0x000fe20003f05270ULL, 0x000137427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000727806ULL, 0x000fc400018e0100ULL, 0x000000801f298824ULL, 0x000fe200078e0212ULL,
0x0000002324288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002324287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff72ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x000136727f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x000135427f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x000134127f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x000132f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007225ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff2a7424ULL, 0x000fe200078e00ffULL,
0x0000002324237209ULL, 0x000fd60007810000ULL, 0x8000002324240221ULL, 0x000fe20000010000ULL,
0x00007610ff2a0816ULL, 0x000fc6000000002aULL, 0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL,
0x0000002400110308ULL, 0x000e640000000800ULL, 0x0000001170700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002170217221ULL, 0x004fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x000000081f287824ULL, 0x000fca00078e00ffULL,
0xfffffff028707812ULL, 0x000fca00078ec0ffULL, 0x0126b40070297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000002b28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b40070297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099102a247816ULL, 0x000fc800000000ffULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff257819ULL, 0x000fe4000001161dULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x00012eb27f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x00012ee27f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x00012f327f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x000004001f247824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000010001f257824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00024247812ULL, 0x000fc400078ec0ffULL,
0xffffe00025257812ULL, 0x000fe400078ec0ffULL, 0x0000b000247d7810ULL, 0x000fe40007ffe0ffULL,
0x0000f00025787810ULL, 0x008fc60007ffe0ffULL, 0x000000100a247824ULL, 0x100fe400078e027dULL,
0x0000001008287824ULL, 0x000fe400078e027dULL, 0x0000001007707824ULL, 0x000fe400078e0278ULL,
0x000000002424783bULL, 0x000ee80000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f24247231ULL, 0x08cfe400003400ffULL,
0x0000000f26267231ULL, 0x000fc400003400ffULL, 0x0000000e25257231ULL, 0x080fe400003400ffULL,
0x0000000e27277231ULL, 0x000fe400003400ffULL, 0x0000000d28287231ULL, 0x082fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fe400003400ffULL, 0x0000000c29297231ULL, 0x080fe400003400ffULL,
0x0000000c2b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007070783bULL, 0x000f220000004200ULL, 0x0000001006787824ULL, 0x000fe200078e0278ULL,
0x00000c2000007945ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x00000018ff7c7819ULL, 0x010fc40000011670ULL, 0x00000010ff7e7819ULL, 0x000fe40000011670ULL,
0x000000ff707f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff70977812ULL, 0x000fe400078ec0ffULL,
0x0000007cff70723eULL, 0x000fe400020006ffULL, 0x000000ff738a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x000fc40000011671ULL, 0x000000ff71867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011671ULL, 0x0000ffff719a7812ULL, 0x000fe200078ec0ffULL,
0x20000070ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x100fe40000011672ULL,
0x000000ff72887812ULL, 0x000fe400078ec0ffULL, 0x00000018ff877819ULL, 0x000fc40000011672ULL,
0x0000ffff729b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe40000011673ULL,
0x0000008aff70723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x00000010ff8f7819ULL, 0x008fe20000011678ULL, 0x20000070ff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff84707812ULL, 0x000fe200078ec0ffULL, 0x20000072ff907230ULL, 0x000fe20000004100ULL,
0x000000ff78917812ULL, 0x000fc400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe40000011678ULL,
0x0000ffff789d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff927819ULL, 0x100fe40000011679ULL,
0x000000ff79937812ULL, 0x040fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fe40000011679ULL,
0x0000ffff799e7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff797819ULL, 0x000fe4000001167aULL,
0x00000070ff72723eULL, 0x000fe400020006ffULL, 0x00000008ff707819ULL, 0x000fe40000011697ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fc400020006ffULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000088ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff987819ULL, 0x000fe2000001167aULL,
0x20000078ff887230ULL, 0x000fe20000004100ULL, 0x000000ff7a947812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7a9f7812ULL, 0x000fe400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000010ff997819ULL, 0x000fc4000001167bULL, 0x000000ff7b967812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001167bULL, 0x0000ffff7b7c7812ULL, 0x000fe200078ec0ffULL,
0x20000085ff7b7230ULL, 0x000fe20000004100ULL, 0x0000ffff739c7812ULL, 0x000fe200078ec0ffULL,
0x20000079ff857230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fe2000001169aULL,
0x20000072ff797230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000070ff727230ULL, 0x000fe20000004100ULL, 0x00000008ff707819ULL, 0x000fc4000001169cULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000093ff957230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL, 0x2000007aff847230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000087ff8c7230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000078ff7a7230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000010ff8b7819ULL, 0x000fe20000011673ULL, 0x20000086ff737230ULL, 0x000fe20000004100ULL,
0x000000ff92937812ULL, 0x000fe400078ec0ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fc400020006ffULL, 0x00000008ff927819ULL, 0x000fe2000001169dULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000094ff86723eULL, 0x000fe200020006ffULL,
0x2000008eff947230ULL, 0x000fe20000004100ULL, 0x00000096ff87723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x0000008fff78723eULL, 0x000fe200020006ffULL,
0x20000070ff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x000000ff8b8e7812ULL, 0x000fe200078ec0ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000008ff967819ULL, 0x000fc4000001169eULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000008ff8b7819ULL, 0x000fe4000001169bULL,
0x00000092ff70723eULL, 0x000fe200020006ffULL, 0x20000078ff927230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000096ff97723eULL, 0x000fe200020006ffULL,
0x20000093ff967230ULL, 0x000fe20000004100ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x20000070ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe20000011673ULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe20000011671ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff707819ULL, 0x000fe2000001167fULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fc4000001167eULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x000000ff98987812ULL, 0x000fe400078ec0ffULL, 0x0000105471707816ULL, 0x000fe40000000070ULL,
0x0000105479717816ULL, 0x000fe40000000078ULL, 0x0000105473727816ULL, 0x000fc40000000072ULL,
0x00000010ff787819ULL, 0x000fe4000001167bULL, 0x00000010ff737819ULL, 0x000fe2000001167aULL,
0x00000070242c723cULL, 0x080f62000004182cULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000008ff7e7819ULL, 0x000fe2000001169fULL, 0x00000070284c723cULL, 0x002b62000004184cULL,
0x00000010ff7a7819ULL, 0x000fe2000001168bULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x000000ff99997812ULL, 0x000fc400078ec0ffULL, 0x00000008ff8b7819ULL, 0x000fe4000001167cULL,
0x0000105478737816ULL, 0x000fe20000000073ULL, 0x0000001005707824ULL, 0x120fe200078e027dULL,
0x0000105489787816ULL, 0x000fe2000000008aULL, 0x00000010047d7824ULL, 0x000fe200078e027dULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000010ff7b7819ULL, 0x000fe2000001168cULL,
0x000000722430723cULL, 0x000f620000041830ULL, 0x0000007eff89723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fc400020006ffULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x20000089ff8a7230ULL, 0x000fe20000004100ULL,
0x0000008bff8c723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe20000011688ULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011697ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fe20000011686ULL, 0x000000722850723cULL, 0x000b620000041850ULL,
0x00000010ff8b7819ULL, 0x000fe20000011698ULL, 0x000000007070783bULL, 0x020e620000000200ULL,
0x00000010ff7e7819ULL, 0x000fc40000011691ULL, 0x00000010ff7f7819ULL, 0x000fe40000011692ULL,
0x000010547c897816ULL, 0x000fe40000000089ULL, 0x000010548b867816ULL, 0x000fe40000000086ULL,
0x00000010ff797819ULL, 0x000fe4000001168dULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff877819ULL, 0x000fc40000011687ULL, 0x00000010ff7c7819ULL, 0x000fe40000011699ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168cULL,
0x000010547b7a7816ULL, 0x000fc4000000007aULL, 0x000010547f7e7816ULL, 0x000fe4000000007eULL,
0x000010548e797816ULL, 0x000fe40000000079ULL, 0x00001054907b7816ULL, 0x000fe4000000008fULL,
0x00001054967f7816ULL, 0x000fe40000000095ULL, 0x0000105494887816ULL, 0x000fe20000000093ULL,
0x000000782434723cULL, 0x000f620000041834ULL, 0x000010547c877816ULL, 0x000fc40000000087ULL,
0x00001054858a7816ULL, 0x000fe4000000008aULL, 0x00001054848b7816ULL, 0x000fc6000000008bULL,
0x0000007a2438723cULL, 0x040f700000041838ULL, 0x0000007e243c723cULL, 0x040f70000004183cULL,
0x000000882440723cULL, 0x040f700000041840ULL, 0x000000862444723cULL, 0x040f700000041844ULL,
0x0000008a2448723cULL, 0x000b6e0000041848ULL, 0x0000100003247810ULL, 0x020fe20007ffe0ffULL,
0x000000782854723cULL, 0x000f680000041854ULL, 0x0000001002257824ULL, 0x000fc800078e0224ULL,
0x0000007a2858723cULL, 0x040f700000041858ULL, 0x0000007e285c723cULL, 0x040f70000004185cULL,
0x000000882860723cULL, 0x040f700000041860ULL, 0x000000862864723cULL, 0x040f700000041864ULL,
0x0000008a2868723cULL, 0x000b640000041868ULL, 0x000000007d28783bULL, 0x0206a20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707231ULL, 0x086fe400003400ffULL, 0x0000000f72727231ULL, 0x000fc400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d28287231ULL, 0x080fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x000000002578783bULL, 0x000e620000004200ULL,
0x00000010007c7824ULL, 0x000fcc00078e0224ULL, 0x000000007c7c783bULL, 0x008ee20000004200ULL,
0x00000018ff277819ULL, 0x102fe40000011678ULL, 0x00000010ff267819ULL, 0x000fe40000011678ULL,
0x00000018ff877819ULL, 0x000fe4000001167aULL, 0x00000027ff27723eULL, 0x000fe400020006ffULL,
0x000000ff7d927812ULL, 0x008fe400078ec0ffULL, 0x000000ff78847812ULL, 0x000fc400078ec0ffULL,
0x0000ffff78977812ULL, 0x000fe400078ec0ffULL, 0x000000ff26267812ULL, 0x000fe400078ec0ffULL,
0x00000010ff787819ULL, 0x100fe40000011679ULL, 0x000000ff79867812ULL, 0x040fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe40000011679ULL, 0x0000ffff799a7812ULL, 0x000fe200078ec0ffULL,
0x20000027ff797230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x000000ff7e957812ULL, 0x000fe400078ec0ffULL, 0x00000092ff27723eULL, 0x000fe200020006ffULL,
0x20000087ff8d7230ULL, 0x000fe20000004100ULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x100fe4000001167bULL, 0x000000ff7b8a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fc4000001167bULL, 0x0000ffff7b9c7812ULL, 0x000fe400078ec0ffULL,
0x00000095ff87723eULL, 0x000fe200020006ffULL, 0x20000027ff957230ULL, 0x000fe20000004100ULL,
0x00000018ff7b7819ULL, 0x000fe2000001167cULL, 0x20000026ff277230ULL, 0x000fe20000004100ULL,
0x000000ff78787812ULL, 0x000fe200078ec0ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000008ff267819ULL, 0x000fe40000011697ULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000089ff917230ULL, 0x000fe20000004100ULL, 0x000000ff7a887812ULL, 0x000fe200078ec0ffULL,
0x2000007bff897230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe2000001167cULL,
0x20000078ff7b7230ULL, 0x000fe20000004100ULL, 0x000000ff7c8f7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7c9d7812ULL, 0x000fc400078ec0ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001167dULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x20000026ff787230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000008ff267819ULL, 0x000fc4000001169cULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x000fe4000001167aULL,
0x00000010ff947819ULL, 0x000fe2000001167dULL, 0x2000008fff927230ULL, 0x000fe20000004100ULL,
0x0000ffff7d9e7812ULL, 0x000fe200078ec0ffULL, 0x20000088ff7d7230ULL, 0x000fe20000004100ULL,
0x00000018ff937819ULL, 0x000fe2000001167eULL, 0x2000007cff887230ULL, 0x000fe20000004100ULL,
0x000000ff90907812ULL, 0x000fc400078ec0ffULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x0000ffff7a9b7812ULL, 0x000fe200078ec0ffULL, 0x20000086ff7a7230ULL, 0x000fe20000004100ULL,
0x00000008ff7c7819ULL, 0x000fe4000001169aULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x00000093ff86723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x000000ff8c8f7812ULL, 0x000fc400078ec0ffULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000090ff93723eULL, 0x000fe200020006ffULL, 0x20000026ff907230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x2000008aff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff7f967812ULL, 0x000fe200078ec0ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x000fc40000011684ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff987819ULL, 0x000fe4000001167eULL,
0x0000ffff7e9f7812ULL, 0x000fe400078ec0ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000010ff997819ULL, 0x000fc4000001167fULL,
0x00000018ff7e7819ULL, 0x000fe4000001167fULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000096ff8a723eULL, 0x000fe400020006ffULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x0000105427267816ULL, 0x000fc40000000026ULL, 0x000000ff94967812ULL, 0x000fe400078ec0ffULL,
0x000010547b277816ULL, 0x000fe4000000007aULL, 0x00000008ff8c7819ULL, 0x000fe4000001169bULL,
0x00000008ff947819ULL, 0x000fe4000001169dULL, 0x000000ff98987812ULL, 0x000fe200078ec0ffULL,
0x00000026702c723cULL, 0x000f62000004182cULL, 0x00000010ff7a7819ULL, 0x000fc40000011685ULL,
0x00000008ff977819ULL, 0x000fe4000001169eULL, 0x000000ff99997812ULL, 0x000fe400078ec0ffULL,
0x00000008ff857819ULL, 0x000fe2000001169fULL, 0x00000026284c723cULL, 0x004b62000004184cULL,
0x00000008ff7f7819ULL, 0x000fe4000001167fULL, 0x0000105479787816ULL, 0x000fe40000000078ULL,
0x00000010ff797819ULL, 0x000fc4000001167cULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x000000021f267824ULL, 0x020fe200078e00ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000098ff98723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe2000001168bULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x00000097ff97723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe2000001167dULL,
0x20000096ff967230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fe2000001168eULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe4000001168fULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000085ff8b723eULL, 0x000fc400020006ffULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x000010547a797816ULL, 0x000fe20000000079ULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x000010547c7a7816ULL, 0x000fe2000000007dULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00001054847b7816ULL, 0x000fe4000000007bULL, 0x00000010ff847819ULL, 0x000fe20000011691ULL,
0x000000787030723cULL, 0x000f620000041830ULL, 0x00000010ff7d7819ULL, 0x000fc40000011690ULL,
0x00000010ff7c7819ULL, 0x000fe4000001168cULL, 0x00001054847d7816ULL, 0x000fe4000000007dULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x0000007a7034723cULL, 0x000f620000041834ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff987819ULL, 0x000fc40000011698ULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x000000782850723cULL, 0x040f620000041850ULL, 0x00000010ff847819ULL, 0x000fe40000011692ULL,
0x00000010ff857819ULL, 0x000fe40000011695ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff967819ULL, 0x000fe20000011696ULL, 0x0000007a2854723cULL, 0x000f620000041854ULL,
0x00000010ff8c7819ULL, 0x000fc40000011688ULL, 0x00000010ff977819ULL, 0x000fe40000011697ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff997819ULL, 0x000fe40000011699ULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x0000105489887816ULL, 0x000fe40000000094ULL, 0x0000105498987816ULL, 0x000fe40000000087ULL,
0x000010548d7c7816ULL, 0x000fe4000000007cULL, 0x0000105493847816ULL, 0x000fe40000000084ULL,
0x0000105496857816ULL, 0x000fc40000000085ULL, 0x000010548c897816ULL, 0x000fe20000000097ULL,
0x0000007c7038723cULL, 0x040f620000041838ULL, 0x0000105499997816ULL, 0x000fe4000000008aULL,
0x0000105486867816ULL, 0x000fe4000000008bULL, 0x000010547e877816ULL, 0x000fe4000000007fULL,
0xfffffff826267812ULL, 0x000fe200078ec0ffULL, 0x00000084703c723cULL, 0x040f70000004183cULL,
0x000000887040723cULL, 0x040f700000041840ULL, 0x000000987044723cULL, 0x040f700000041844ULL,
0x000000867048723cULL, 0x000f700000041848ULL, 0x0000007c2858723cULL, 0x040f700000041858ULL,
0x00000084285c723cULL, 0x040f70000004185cULL, 0x000000882860723cULL, 0x040f700000041860ULL,
0x000000982864723cULL, 0x040f700000041864ULL, 0x000000862868723cULL, 0x000b6e0000041868ULL,
0x000126c8182a7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000002a2a7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff707224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x0000040013297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826717210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000007128287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040013297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010014267824ULL, 0x000fca00078e0280ULL, 0x000000c026297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000117787824ULL, 0x000fe200078e0228ULL,
0x000003e00000a947ULL, 0x000fea0003800000ULL, 0x000000101f287824ULL, 0x000fe200078e00ffULL,
0x000000291c277217ULL, 0x000fe40007800000ULL, 0x00000003ff707819ULL, 0x000fe4000001161dULL,
0x00000010287a7812ULL, 0x000fe200078ec0ffULL, 0x0000000127277824ULL, 0x000fe200078e0a29ULL,
0x00000004702b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000870727810ULL, 0x040fe20007ffe0ffULL,
0x0000000170797824ULL, 0x100fe200078e027aULL, 0x000000277a277217ULL, 0x000fe20007800000ULL,
0x000000012b7b7824ULL, 0x000fe200078e027aULL, 0x0000000c707d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000179287824ULL, 0x000fc400078e0278ULL, 0x0000000127277824ULL, 0x000fe400078e0a7aULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0x000000272b00720cULL, 0x080fe20003f66070ULL,
0x000000017b2a7824ULL, 0x000fe200078e0278ULL, 0x0000001228717212ULL, 0x080fe200078efcffULL,
0x00000001727c7824ULL, 0x000fe200078e027aULL, 0x000000277000720cULL, 0x000fe20003f86070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000716e707210ULL, 0x000fe40007fbe0ffULL,
0x000000277200720cULL, 0x000fe20003f06070ULL, 0x000000017c287824ULL, 0x000fe200078e0278ULL,
0x000000122a737212ULL, 0x000fe200078efcffULL, 0x000000017d7e7824ULL, 0x000fc400078e027aULL,
0x000000016f717824ULL, 0x000fe200028e0629ULL, 0x000000736e727210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000277d00720cULL, 0x000fc60003fa6070ULL,
0x000000017e2a7824ULL, 0x000fe200078e0278ULL, 0x0000001228277212ULL, 0x000fe200078efcffULL,
0x000000016f737824ULL, 0x000fe400030e062bULL, 0x0000000179787824ULL, 0x140fe200078e021dULL,
0x000000276e287210ULL, 0x000fe20007fde0ffULL, 0x0000000879797824ULL, 0x000fe400078e00ffULL,
0x000000017b7a7824ULL, 0x000fe400078e021dULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fc600078ee278ULL, 0x000000087b7b7824ULL, 0x000fe200078e00ffULL,
0x000000122a277212ULL, 0x000fe200078efcffULL, 0x000000017c787824ULL, 0x140fe400078e021dULL,
0x000000087c7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee27aULL,
0x000000017e7a7824ULL, 0x040fe400078e021dULL, 0x000000087e7f7824ULL, 0x000fe200078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee278ULL, 0x000000016f297824ULL, 0x000fe200030e0629ULL,
0x000000276e2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001079277824ULL, 0x000fe200078e0224ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee27aULL, 0x000000107d797824ULL, 0x000fc400078e0224ULL,
0x000000016f2b7824ULL, 0x000fe200030e062bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070277faeULL, 0x0003e2000e101c46ULL, 0x000000107b6f7824ULL, 0x100fe400078e0224ULL,
0x000000107f7b7824ULL, 0x000fc600078e0224ULL, 0x00000000726f7faeULL, 0x0003e8000d901c46ULL,
0x0000000028797faeULL, 0x0003e8000c101c46ULL, 0x000000002a7b7faeULL, 0x0003e2000e901c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000101f277824ULL, 0x000fca00078e00ffULL,
0x0000001027287812ULL, 0x000fc800078ec0ffULL, 0x000000281d277211ULL, 0x000fc800078fe8ffULL,
0x00000004272a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000127287824ULL, 0x140fe200078e021dULL,
0x0000000827707810ULL, 0x040fe20007ffe0ffULL, 0x00000008277d7824ULL, 0x000fe400078e00ffULL,
0x000000012a297824ULL, 0x140fe400078e021dULL, 0x000000082a727824ULL, 0x000fe200078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee228ULL, 0x0000000127287824ULL, 0x040fe200078e0278ULL,
0x0000000c27277810ULL, 0x000fe20007ffe0ffULL, 0x00000001702b7824ULL, 0x000fe200078e021dULL,
0xfffffff8727f7812ULL, 0x000fe200078ee229ULL, 0x00000008707a7824ULL, 0x000fc400078e00ffULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87a857812ULL, 0x000fe200078ee22bULL,
0x000000012a2a7824ULL, 0x100fe400078e0278ULL, 0x0000000170707824ULL, 0x100fe400078e0278ULL,
0x0000000127727824ULL, 0x040fe400078e0278ULL, 0x0000000127787824ULL, 0x040fe400078e021dULL,
0x0000000827877824ULL, 0x000fe200078e00ffULL, 0x0000001228277212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x000000276e287210ULL, 0x000fe20007f1e0ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000122a7b7212ULL, 0x080fe400078efcffULL,
0xfffffff887877812ULL, 0x000fe200078ee278ULL, 0x0000008072727825ULL, 0x000fe200078e00ffULL,
0x0000001270797212ULL, 0x080fe400078efcffULL, 0x0000007b6e2a7210ULL, 0x000fe20007f7e0ffULL,
0x000000016f297824ULL, 0x000fe200000e0629ULL, 0x0000001272277212ULL, 0x000fe200078efcffULL,
0x00000010877b7824ULL, 0x100fe200078e0224ULL, 0x000000796e707210ULL, 0x040fe20007f1e0ffULL,
0x000000016f2b7824ULL, 0x000fe200018e062bULL, 0x000000276e6e7210ULL, 0x000fe20007f9e0ffULL,
0x000000107d277824ULL, 0x000fc400078e0224ULL, 0x000000016f717824ULL, 0x040fe400000e0671ULL,
0x000000016f6f7824ULL, 0x000fe200020e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028277faeULL, 0x0003e2000b901c46ULL, 0x000000107f737824ULL, 0x100fe400078e0224ULL,
0x0000001085797824ULL, 0x000fc600078e0224ULL, 0x000000002a737faeULL, 0x0003e8000b901c46ULL,
0x0000000070797faeULL, 0x0003e8000b901c46ULL, 0x000000006e7b7faeULL, 0x0003e4000b901c46ULL,
0x0000000219197810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff277424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001b1900720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x0000000119288824ULL, 0x000fe400078e0216ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000660028288625ULL, 0x000fca00078e0029ULL, 0x0000000628278981ULL, 0x000322000c1e1900ULL,
0x000000081f2a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0002a6e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480022707f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x002fc40000015200ULL,
0x01264c00222b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x006fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28737210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000732a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c00222b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201f227824ULL, 0x000fca00078e00ffULL, 0xffffff8022297812ULL, 0x000fc800078ec0ffULL,
0x0000010012297810ULL, 0x000fca0007ffe029ULL, 0x0000000174297824ULL, 0x000fca00078e0229ULL,
0x0120000029707984ULL, 0x000e680000000800ULL, 0x0122000029727984ULL, 0x0004e20000000800ULL,
0x000000237000720bULL, 0x002fe20003f1d000ULL, 0x000107e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000717806ULL, 0x004fc800000e0100ULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff737424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000215227810ULL, 0x000fe40007ffe0ffULL, 0x000000237000720bULL, 0x000fe40003f74000ULL,
0x0000001f2200720cULL, 0x000fe20003f05270ULL, 0x000107927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400018e0100ULL, 0x000000801f298824ULL, 0x000fe200078e0212ULL,
0x0000002370288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000174298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002370287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x000106c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x000105927f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000022ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x000104627f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x000103427f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002271ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff737424ULL, 0x000fe200078e00ffULL,
0x0000002370227209ULL, 0x000fd60007810000ULL, 0x8000002270700221ULL, 0x000fe20000010000ULL,
0x00007610ff730816ULL, 0x000fc60000000073ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000110308ULL, 0x000e640000000800ULL, 0x0000001172720220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002172217221ULL, 0x008fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000040010237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142bULL, 0x0000002a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000223237819ULL, 0x000fc8000000122aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040010237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991073237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000010ffULL, 0x00000002ff237819ULL, 0x000fe4000001161dULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x0000ff227f007947ULL, 0x000fea000b800000ULL,
0x00001f230c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000823297810ULL, 0x000fe20007ffe0ffULL,
0x0000ff527f007947ULL, 0x000fea000b800000ULL, 0x00000010230d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL,
0x0000001823297810ULL, 0x008fe20007ffe0ffULL, 0x0000ffa27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0022e400000e0000ULL, 0x000004001f237824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000001007787824ULL, 0x000fc400078e0203ULL, 0xfffff00023237812ULL, 0x000fc800078ec0ffULL,
0x0000c00023237810ULL, 0x000fca0007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e0223ULL,
0x0000001008087824ULL, 0x000fc600078e0223ULL, 0x000000000a70783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707231ULL, 0x08cfe400003400ffULL, 0x0000000f72727231ULL, 0x000fe400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fc400003400ffULL,
0x0000000d28287231ULL, 0x080fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010067c7824ULL, 0x000fe200078e0203ULL,
0x000000007878783bULL, 0x000e620000004200ULL, 0x00000c1000007945ULL, 0x000fe80003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x000000ff780a7812ULL, 0x002fc400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe4000001167bULL, 0x000000ff7b8a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001167bULL, 0x0000ffff7b9a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x008fe4000001167cULL, 0x000000ff796c7812ULL, 0x000fc400078ec0ffULL,
0x0000000aff0a723eULL, 0x000fe400020006ffULL, 0x000000ff7e907812ULL, 0x000fe400078ec0ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000010ff067819ULL, 0x100fe40000011678ULL,
0x00000018ff087819ULL, 0x000fe40000011678ULL, 0x0000ffff78977812ULL, 0x000fc400078ec0ffULL,
0x0000ffff79987812ULL, 0x000fe400078ec0ffULL, 0x0000006cff78723eULL, 0x000fe200020006ffULL,
0x2000000aff6c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe4000001167cULL,
0x000000ff7c8d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7c9b7812ULL, 0x000fe400078ec0ffULL,
0x00000090ff0a723eULL, 0x000fe200020006ffULL, 0x2000007bff907230ULL, 0x000fe20000004100ULL,
0x00000018ff6d7819ULL, 0x000fc40000011679ULL, 0x00000018ff7c7819ULL, 0x000fe2000001167dULL,
0x2000000aff0a7230ULL, 0x000fe20000004100ULL, 0x00000008ff7b7819ULL, 0x000fe40000011698ULL,
0x00000010ff847819ULL, 0x000fe40000011679ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000010ff857819ULL, 0x000fc4000001167aULL,
0x000000ff7a877812ULL, 0x040fe200078ec0ffULL, 0x2000007cff947230ULL, 0x000fe20000004100ULL,
0x00000018ff867819ULL, 0x000fe4000001167aULL, 0x0000ffff7a997812ULL, 0x000fe200078ec0ffULL,
0x20000078ff7a7230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x000000ff06067812ULL, 0x000fe400078ec0ffULL, 0x000000ff84847812ULL, 0x000fe200078ec0ffULL,
0x2000007bff7c7230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fc40000011697ULL,
0x00000010ff8f7819ULL, 0x000fe4000001167dULL, 0x000000ff7d8e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7d9c7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff957819ULL, 0x100fe4000001167eULL, 0x00000018ff927819ULL, 0x000fe4000001167eULL,
0x0000ffff7e9d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001167fULL,
0x00000006ff6d723eULL, 0x000fe400020006ffULL, 0x00000008ff08723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000008ff797230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe2000001169aULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x000000ff89897812ULL, 0x000fe200078ec0ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000008eff917230ULL, 0x000fe20000004100ULL,
0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000007eff067230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x0000008bff8e723eULL, 0x000fe200020006ffULL,
0x2000007bff8b7230ULL, 0x000fe20000004100ULL, 0x00000008ff7e7819ULL, 0x000fe20000011699ULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe2000001166cULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe2000001166dULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fc4000001167aULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff7b7819ULL, 0x000fe40000011684ULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000088ff08723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x000010546d6c7816ULL, 0x000fe2000000006cULL,
0x20000008ff8c7230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x000010547b6d7816ULL, 0x000fc4000000007aULL,
0x0000105479787816ULL, 0x000fe20000000078ULL, 0x20000086ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167dULL, 0x00000010ff7b7819ULL, 0x000fe2000001168aULL,
0x0000006c702c723cULL, 0x000f62000004182cULL, 0x00000010ff797819ULL, 0x000fe4000001167cULL,
0x00000010ff847819ULL, 0x000fe40000011689ULL, 0x00000010ff967819ULL, 0x000fc4000001167fULL,
0x000000ff7f937812ULL, 0x040fe200078ec0ffULL, 0x0000006c284c723cULL, 0x004f62000004184cULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff7c7819ULL, 0x000fe40000011685ULL,
0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x00000092ff08723eULL, 0x000fe400020006ffULL,
0x000000ff8f927812ULL, 0x000fc400078ec0ffULL, 0x000010547a797816ULL, 0x000fe20000000079ULL,
0x20000008ff087230ULL, 0x000fe20000004100ULL, 0x00001054847b7816ULL, 0x000fe4000000007bULL,
0x00000093ff86723eULL, 0x000fe400020006ffULL, 0x00000008ff8f7819ULL, 0x000fe2000001169bULL,
0x000000787030723cULL, 0x000f620000041830ULL, 0x000010547c7a7816ULL, 0x000fe20000000087ULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fc4000001169dULL,
0x00000008ff937819ULL, 0x000fe4000001169cULL, 0x000000ff95957812ULL, 0x000fe200078ec0ffULL,
0x0000007a7034723cULL, 0x000f620000041834ULL, 0x000000ff96967812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe4000001167fULL, 0x00000010ff7c7819ULL, 0x000fe4000001167eULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x000000782850723cULL, 0x000b620000041850ULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x00000084ff7e723eULL, 0x000fe200020006ffULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x0000007a2854723cULL, 0x000f620000041854ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000096ff96723eULL, 0x000fe200020006ffULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000087ff89723eULL, 0x000fe200020006ffULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe20000011688ULL,
0x2000007eff887230ULL, 0x000fe20000004100ULL, 0x00000010ff8c7819ULL, 0x000fe2000001168cULL,
0x20000096ff967230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe2000001168bULL,
0x20000089ff8a7230ULL, 0x000fe20000004100ULL, 0x000010547d7c7816ULL, 0x000fe2000000007cULL,
0x0000001002787824ULL, 0x020fe200078e0203ULL, 0x000010548c7d7816ULL, 0x000fc4000000008bULL,
0x00000010ff847819ULL, 0x000fe4000001168dULL, 0x00000010ff857819ULL, 0x000fe4000001168eULL,
0x00000010ff7f7819ULL, 0x000fe20000011690ULL, 0x0000007c7038723cULL, 0x000f620000041838ULL,
0x00000010ff7e7819ULL, 0x000fe4000001168fULL, 0x00000010ff897819ULL, 0x000fe40000011608ULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000010ff917819ULL, 0x000fe20000011691ULL,
0x0000007c2858723cULL, 0x000f620000041858ULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff0a7819ULL, 0x000fe4000001160aULL, 0x00000010ff957819ULL, 0x000fc40000011695ULL,
0x00000010ff877819ULL, 0x000fe40000011686ULL, 0x00000010ff967819ULL, 0x000fe40000011696ULL,
0x00000010ff8b7819ULL, 0x000fe40000011606ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x0000105485847816ULL, 0x000fe40000000084ULL, 0x000010547f7e7816ULL, 0x000fc4000000007eULL,
0x0000105489887816ULL, 0x000fe40000000088ULL, 0x0000105492857816ULL, 0x000fe40000000091ULL,
0x00001054947f7816ULL, 0x000fe40000000093ULL, 0x0000105495867816ULL, 0x000fe4000000000aULL,
0x0000105496877816ULL, 0x000fe20000000087ULL, 0x00000084703c723cULL, 0x000f62000004183cULL,
0x000010548b897816ULL, 0x000fce000000008aULL, 0x0000007e7040723cULL, 0x040f700000041840ULL,
0x000000867044723cULL, 0x040f700000041844ULL, 0x000000887048723cULL, 0x000b6e0000041848ULL,
0x0000001005707824ULL, 0x120fe200078e0223ULL, 0x00000084285c723cULL, 0x000f62000004185cULL,
0x0000001004237824ULL, 0x000fc800078e0223ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007e2860723cULL, 0x040f700000041860ULL, 0x000000862864723cULL, 0x040f700000041864ULL,
0x000000882828723cULL, 0x000b640000041868ULL, 0x000000002368783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707231ULL, 0x082fe400003400ffULL, 0x0000000f72727231ULL, 0x000fc400003400ffULL,
0x0000000e71717231ULL, 0x080fe400003400ffULL, 0x0000000e73737231ULL, 0x000fe400003400ffULL,
0x0000000d68687231ULL, 0x088fe400003400ffULL, 0x0000000d6a6a7231ULL, 0x000fe400003400ffULL,
0x0000000c69697231ULL, 0x080fe400003400ffULL, 0x0000000c6b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010007c7824ULL, 0x000fe200078e0203ULL,
0x000000007878783bULL, 0x000eaa0000004200ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x000000ff79087812ULL, 0x004fc400078ec0ffULL, 0x00000018ff027819ULL, 0x000fe40000011678ULL,
0x00000010ff237819ULL, 0x100fe40000011679ULL, 0x00000018ff0a7819ULL, 0x000fe40000011679ULL,
0x0000ffff79967812ULL, 0x000fe400078ec0ffULL, 0x00000018ff797819ULL, 0x000fe4000001167aULL,
0x00000008ff6c723eULL, 0x000fc400020006ffULL, 0x00000002ff02723eULL, 0x000fe400020006ffULL,
0x00000010ff907819ULL, 0x108fe4000001167eULL, 0x000000ff7e8e7812ULL, 0x040fe200078ec0ffULL,
0x20000002ff6d7230ULL, 0x000fe20000004100ULL, 0x00000018ff8d7819ULL, 0x000fe4000001167eULL,
0x0000ffff7e9b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff007819ULL, 0x000fc40000011678ULL,
0x00000018ff7e7819ULL, 0x000fe4000001167fULL, 0x000000ff23237812ULL, 0x000fe400078ec0ffULL,
0x000000ff78067812ULL, 0x040fe400078ec0ffULL, 0x0000ffff78937812ULL, 0x000fe200078ec0ffULL,
0x2000006cff787230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe4000001167aULL,
0x000000ff7a857812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7a977812ULL, 0x000fe400078ec0ffULL,
0x00000018ff867819ULL, 0x100fe4000001167bULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000010ff7a7819ULL, 0x000fe4000001167bULL, 0x000000ff7b877812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7b987812ULL, 0x000fc400078ec0ffULL, 0x0000000aff0a723eULL, 0x000fe400020006ffULL,
0x00000018ff7b7819ULL, 0x000fe4000001167cULL, 0x000000ff00007812ULL, 0x000fe400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000023ff6c723eULL, 0x000fe400020006ffULL,
0x00000006ff06723eULL, 0x000fc400020006ffULL, 0x00000010ff887819ULL, 0x000fe4000001167cULL,
0x000000ff7c897812ULL, 0x040fe200078ec0ffULL, 0x20000006ff087230ULL, 0x000fe20000004100ULL,
0x0000ffff7c997812ULL, 0x000fe400078ec0ffULL, 0x00000086ff02723eULL, 0x000fe200020006ffULL,
0x20000079ff867230ULL, 0x000fe20000004100ULL, 0x00000008ff237819ULL, 0x000fe40000011693ULL,
0x00000010ff8c7819ULL, 0x000fe2000001167dULL, 0x20000002ff8a7230ULL, 0x000fe20000004100ULL,
0x000000ff7d8b7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001167dULL,
0x0000ffff7d9a7812ULL, 0x000fe200078ec0ffULL, 0x2000000aff7d7230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000008ff797819ULL, 0x000fe40000011696ULL,
0x00000000ff0a723eULL, 0x000fe200020006ffULL, 0x2000007eff007230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fc400020006ffULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x2000000aff0a7230ULL, 0x000fe20000004100ULL, 0x000000ff7a7e7812ULL, 0x000fe400078ec0ffULL,
0x0000008eff06723eULL, 0x000fe200020006ffULL, 0x2000007bff8e7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x2000006cff7b7230ULL, 0x000fe20000004100ULL,
0x00000008ff7a7819ULL, 0x000fe20000011697ULL, 0x20000023ff6c7230ULL, 0x000fe20000004100ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000007cff927230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000079ff7c7230ULL, 0x000fe20000004100ULL,
0x00000008ff237819ULL, 0x000fe20000011698ULL, 0x20000006ff067230ULL, 0x000fe20000004100ULL,
0x000000ff88797812ULL, 0x000fe200078ec0ffULL, 0x2000007eff887230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000007aff7e7230ULL, 0x000fe20000004100ULL,
0x0000008bff02723eULL, 0x000fc400020006ffULL, 0x000000ff7f917812ULL, 0x000fe200078ec0ffULL,
0x20000089ff8b7230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe200020006ffULL,
0x20000002ff8f7230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL, 0x20000023ff897230ULL, 0x000fe20000004100ULL,
0x00000008ff7a7819ULL, 0x000fe40000011699ULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x0000008dff02723eULL, 0x000fe400020006ffULL, 0x00000008ff8d7819ULL, 0x000fe2000001169aULL,
0x20000091ff957230ULL, 0x000fe20000004100ULL, 0x0000008cff23723eULL, 0x000fe200020006ffULL,
0x20000079ff8c7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x20000002ff027230ULL, 0x000fe20000004100ULL, 0x000000ff84847812ULL, 0x000fe400078ec0ffULL,
0x000000ff90797812ULL, 0x000fe200078ec0ffULL, 0x20000023ff907230ULL, 0x000fe20000004100ULL,
0x0000008dff91723eULL, 0x000fe200020006ffULL, 0x2000007aff8d7230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fc400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000091ff917230ULL, 0x000fe20000004100ULL, 0x00000079ff93723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe20000011678ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff087819ULL, 0x000fe20000011608ULL,
0x20000093ff937230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe4000001166dULL,
0x00000010ff237819ULL, 0x000fc4000001160aULL, 0x00000010ff787819ULL, 0x000fe4000001166cULL,
0x00000010ff6d7819ULL, 0x000fe4000001167bULL, 0x00001054236c7816ULL, 0x000fe40000000008ULL,
0x0000105479787816ULL, 0x000fe40000000078ULL, 0x00000010ff947819ULL, 0x000fe4000001167fULL,
0x00000010ff087819ULL, 0x000fc4000001167dULL, 0x00000010ff797819ULL, 0x000fe4000001167cULL,
0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x000010546d6d7816ULL, 0x000fe4000000007aULL,
0x00000010ff7a7819ULL, 0x000fe40000011685ULL, 0x00000010ff237819ULL, 0x000fe40000011684ULL,
0x0000105408797816ULL, 0x000fe20000000079ULL, 0x0000006c684c723cULL, 0x000b62000004184cULL,
0x000000ff94947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff087819ULL, 0x000fe4000001169bULL,
0x00000008ff7f7819ULL, 0x000fe4000001167fULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x000000786850723cULL, 0x000b620000041850ULL, 0x00001054237a7816ULL, 0x000fe4000000007aULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fc40000011686ULL, 0x00000010ff7c7819ULL, 0x000fe2000001167eULL,
0x20000094ff947230ULL, 0x000fe20000004100ULL, 0x00000008ff08723eULL, 0x000fe200020006ffULL,
0x0000006c702c723cULL, 0x042b62000004182cULL, 0x0000007fff0a723eULL, 0x000fe400020006ffULL,
0x00001054237c7816ULL, 0x000fe2000000007cULL, 0x20000008ff087230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fe2000001168bULL, 0x2000000aff0a7230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fe2000001168cULL, 0x000000787030723cULL, 0x000b620000041830ULL,
0x00000010ff857819ULL, 0x000fc4000001168fULL, 0x00000010ff7b7819ULL, 0x000fe40000011687ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff7d7819ULL, 0x000fe40000011689ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x0000105423847816ULL, 0x000fc40000000084ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff927819ULL, 0x000fe40000011692ULL,
0x00000010ff8f7819ULL, 0x000fe40000011691ULL, 0x00000010ff067819ULL, 0x000fe40000011606ULL,
0x00000010ff937819ULL, 0x000fc40000011693ULL, 0x00000010ff7f7819ULL, 0x000fe40000011695ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00000010ff237819ULL, 0x000fe40000011602ULL,
0x00000010ff087819ULL, 0x000fe40000011608ULL, 0x00000010ff877819ULL, 0x000fe20000011600ULL,
0x000000021f007824ULL, 0x000fe200078e00ffULL, 0x00000010ff0a7819ULL, 0x000fc4000001160aULL,
0x00001054887b7816ULL, 0x000fe4000000007bULL, 0x000010548a7d7816ULL, 0x000fe4000000007dULL,
0x0000105490857816ULL, 0x000fe40000000085ULL, 0x000010548e8e7816ULL, 0x000fe2000000008dULL,
0x0000007a6854723cULL, 0x000b620000041854ULL, 0x00001054928f7816ULL, 0x000fe4000000008fULL,
0x00001054937e7816ULL, 0x000fc40000000006ULL, 0x00001054947f7816ULL, 0x000fe4000000007fULL,
0x0000105423867816ULL, 0x000fe20000000008ULL, 0x0000007c6858723cULL, 0x000b620000041858ULL,
0x0000105487877816ULL, 0x000fe4000000000aULL, 0xfffffff800027812ULL, 0x000fca00078ec0ffULL,
0x00000084685c723cULL, 0x040b70000004185cULL, 0x0000008e6860723cULL, 0x040b700000041860ULL,
0x0000007e6864723cULL, 0x000b700000041864ULL, 0x0000007a7034723cULL, 0x040b700000041834ULL,
0x0000007c7038723cULL, 0x040b700000041838ULL, 0x00000084703c723cULL, 0x040b70000004183cULL,
0x0000008e7040723cULL, 0x040b700000041840ULL, 0x0000007e7044723cULL, 0x040b700000041844ULL,
0x000000867048723cULL, 0x080b700000041848ULL, 0x000000866868723cULL, 0x000b620000041828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000136c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126980002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x0000040013237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28237210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x008fc8000001142aULL,
0x0000002302027211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e062aULL,
0x0000000202027819ULL, 0x000fc80000001223ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040013237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000114237810ULL, 0x000fc80007ffe0ffULL, 0x0000001a2300720cULL, 0x000fda0003f06070ULL,
0x0000079000000947ULL, 0x000fea0003800000ULL, 0x0000000214237810ULL, 0x000fe20007ffe0ffULL,
0x0000590027007a24ULL, 0x010fe200078e02ffULL, 0x00000100262b7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff297424ULL, 0x000fe200078e00ffULL, 0x0000001a2300720cULL, 0x000fe20003f06070ULL,
0x0000008000287824ULL, 0x000fe200078e00ffULL, 0x000000602b007812ULL, 0x000fc600078ec0ffULL,
0x0000640028287625ULL, 0x000fc800078e0029ULL, 0x0000000117027824ULL, 0x008fc800078e0200ULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x0000002b1c007217ULL, 0x000fe20007800000ULL,
0x000000101f067824ULL, 0x000fc800078e00ffULL, 0x0000000100007824ULL, 0x000fe200078e0a2bULL,
0x0000001006237812ULL, 0x000fe400078ec0ffULL, 0x00000003ff067819ULL, 0x000fe4000001161dULL,
0x0000000023007217ULL, 0x000fe40007800000ULL, 0x00000004060a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106087824ULL, 0x140fe200078e0223ULL, 0x0000000806267810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fc400078e0a23ULL, 0x00000001082a7824ULL, 0x000fc600078e0202ULL,
0x000000000a00720cULL, 0x0c0fe20003f86070ULL, 0x000000010a0a7824ULL, 0x100fe200078e0223ULL,
0x000000002600720cULL, 0x080fe20003f66070ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x000000000600720cULL, 0x040fe40003fa6070ULL, 0x0000000c06067810ULL, 0x000fe20007ffe0ffULL,
0x000000010a6c7824ULL, 0x000fe200078e0202ULL, 0x000000122a717212ULL, 0x000fe200078efcffULL,
0x0000000126267824ULL, 0x000fe200078e0223ULL, 0x000000000600720cULL, 0x000fe20003f06070ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000007128707210ULL, 0x000fc60007fde0ffULL,
0x00000001262a7824ULL, 0x000fe200078e0202ULL, 0x000000126c737212ULL, 0x000fe200078efcffULL,
0x0000000106787824ULL, 0x000fe400078e0223ULL, 0x0000000108007824ULL, 0x040fe400078e021dULL,
0x0000000808237824ULL, 0x000fe400078e00ffULL, 0x0000000129717824ULL, 0x000fe200030e062bULL,
0x0000007328727210ULL, 0x000fe20007fde0ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff823007812ULL, 0x000fc600078ee200ULL, 0x00000001786c7824ULL, 0x000fe200078e0202ULL,
0x000000122a237212ULL, 0x000fe200078efcffULL, 0x000000010a067824ULL, 0x040fe400078e021dULL,
0x000000080a797824ULL, 0x000fe400078e00ffULL, 0x0000000129737824ULL, 0x000fe200030e066dULL,
0x00000023282a7210ULL, 0x000fe20007fde0ffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff879067812ULL, 0x000fc600078ee206ULL, 0x0000000126027824ULL, 0x100fe200078e021dULL,
0x000000126c237212ULL, 0x000fe200078efcffULL, 0x0000000826797824ULL, 0x000fe400078e00ffULL,
0x00000001780a7824ULL, 0x040fe400078e021dULL, 0x00000008787b7824ULL, 0x000fe200078e00ffULL,
0xfffffff879087812ULL, 0x000fe200078ee202ULL, 0x00000001292b7824ULL, 0x000fe200030e062bULL,
0x0000002328027210ULL, 0x000fe20007fde0ffULL, 0x0000001000797824ULL, 0x100fe200078e0203ULL,
0xfffffff87b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001006237824ULL, 0x000fc400078e0203ULL,
0x00000010087b7824ULL, 0x100fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070797faeULL, 0x0003e2000e901c46ULL, 0x000000100a7d7824ULL, 0x000fe400078e0203ULL,
0x0000000129037824ULL, 0x000fe200030e066dULL, 0x0000000072237faeULL, 0x0003e8000e101c46ULL,
0x000000002a7b7faeULL, 0x0003e8000d901c46ULL, 0x00000000027d7faeULL, 0x0003e2000c101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000101f007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001d007211ULL, 0x000fc800078fe8ffULL,
0x0000000400087810ULL, 0x040fe20007ffe0ffULL, 0x00000001002a7824ULL, 0x040fe200078e0202ULL,
0x0000000c00267810ULL, 0x040fe20007ffe0ffULL, 0x0000000100067824ULL, 0x040fe400078e021dULL,
0x0000000800237824ULL, 0x000fe400078e00ffULL, 0x000000802a2a7825ULL, 0x000fc600078e00ffULL,
0xfffffff823067812ULL, 0x000fe200078ee206ULL, 0x00000001080a7824ULL, 0x100fe200078e021dULL,
0x000000122a737212ULL, 0x000fe200078efcffULL, 0x00000008086d7824ULL, 0x000fe200078e00ffULL,
0x0000000800237810ULL, 0x000fe20007ffe0ffULL, 0x0000000108007824ULL, 0x100fe200078e0202ULL,
0x0000007328727210ULL, 0x000fe20007f1e0ffULL, 0x0000000126707824ULL, 0x040fe200078e0202ULL,
0xfffffff86d0a7812ULL, 0x000fe200078ee20aULL, 0x00000001236c7824ULL, 0x000fe400078e0202ULL,
0x0000000126087824ULL, 0x000fc400078e021dULL, 0x0000000826717824ULL, 0x000fe400078e00ffULL,
0x0000000123027824ULL, 0x040fe400078e021dULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0xfffffff871087812ULL, 0x000fe200078ee208ULL, 0x0000000129737824ULL, 0x000fe400000e062bULL,
0x00000080002a7825ULL, 0x000fe200078e00ffULL, 0xfffffff823027812ULL, 0x000fc600078ee202ULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x000000122a7b7212ULL, 0x000fc600078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000126c797212ULL, 0x000fc600078efcffULL,
0x0000001002857824ULL, 0x100fe200078e0203ULL, 0x0000001270237212ULL, 0x000fe200078efcffULL,
0x00000010067d7824ULL, 0x100fe200078e0203ULL, 0x0000007b28027210ULL, 0x000fe20007f1e0ffULL,
0x000000100a7f7824ULL, 0x100fe200078e0203ULL, 0x00000079282a7210ULL, 0x040fe40007f7e0ffULL,
0x0000002328287210ULL, 0x000fe20007f9e0ffULL, 0x0000001008237824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000727d7faeULL, 0x0003e2000b901c46ULL,
0x0000000129037824ULL, 0x000fc400000e062bULL, 0x00000001292b7824ULL, 0x040fe400018e066dULL,
0x0000000129297824ULL, 0x000fe200020e0671ULL, 0x00000000027f7faeULL, 0x0003e8000b901c46ULL,
0x000000002a857faeULL, 0x0003e8000b901c46ULL, 0x0000000028237faeULL, 0x0003e4000b901c46ULL,
0x000000081f007824ULL, 0x000fe400078e00ffULL, 0x0000000215067824ULL, 0x000fc600078e0275ULL,
0x0000000800037812ULL, 0x002fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000001006067824ULL, 0x000fe200078e0003ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010027f8cULL, 0x0082a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01266800062a7f8cULL, 0x000662000c80043fULL, 0x000000ffff007224ULL, 0x004fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01266c0006237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002802237210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011428ULL, 0x0000002308087211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0628ULL, 0x0000000208087819ULL, 0x000fc80000001223ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c0006237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018015037811ULL, 0x000fc800078e38ffULL,
0x0000000374037210ULL, 0x000fca0007ffe012ULL, 0x0120000003237984ULL, 0x000e680000000800ULL,
0x0122000003067984ULL, 0x0084e20000000800ULL, 0x000000222300720bULL, 0x002fe20003f1d000ULL,
0x0000d8827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x004fc800000e0100ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0022ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000315027810ULL, 0x000fe40007ffe0ffULL,
0x000000222300720bULL, 0x000fe40003f74000ULL, 0x0000001f0200720cULL, 0x000fe20003f05270ULL,
0x0000d8327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x000000801f298824ULL, 0x000fe200078e0212ULL, 0x0000002223027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000174298824ULL, 0x000fca00078e0229ULL,
0x0124000229008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000022020a7221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000e640000000800ULL,
0x0000000a21217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161dULL, 0x0000d7727f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081d297811ULL, 0x000fe200078ff0ffULL,
0x0000d6427f007947ULL, 0x000fea000b800000ULL, 0x00001f290a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101d297811ULL, 0x000fe200078ff0ffULL, 0x0000d5127f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181d297811ULL, 0x000fe200078ff0ffULL, 0x0000d3f27f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff087424ULL, 0x000fd800078e00ffULL,
0x0000002302230221ULL, 0x000fe20000010100ULL, 0x00007610ff080816ULL, 0x000fc60000000008ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300110308ULL, 0x000e640000000800ULL,
0x0000001106060220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002106217221ULL, 0x008fc20000010000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x000000081f037824ULL, 0x000fca00078e00ffULL, 0xfffffff0030a7812ULL, 0x000fca00078ec0ffULL,
0x0126b4000a037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002822067210ULL, 0x000fca0007f1e1ffULL,
0x0000000129287824ULL, 0x000fe200000e0e23ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011428ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0628ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4000a037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991008037816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff03723eULL, 0x000fe400000010ffULL, 0x00000002ff067819ULL, 0x000fe4000001161dULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000cfb27f007947ULL, 0x000fea000b800000ULL,
0x00001f06030f7589ULL, 0x0002a400000e0000ULL, 0x0000000806297810ULL, 0x000fe20007ffe0ffULL,
0x0000cfe27f007947ULL, 0x000fea000b800000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x00001f29030e7589ULL, 0x00066800000e0000ULL, 0x00001f08030d7589ULL, 0x0006a400000e0000ULL,
0x0000001806297810ULL, 0x008fe20007ffe0ffULL, 0x0000d0327f007947ULL, 0x000fea000b800000ULL,
0x00001f29030c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff067819ULL, 0x002fe2000001161dULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000809237824ULL, 0x000fe200078e00ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000475067824ULL, 0x000fc400078e0206ULL,
0x0000001007707824ULL, 0x000fe400078e0224ULL, 0x000000010b037824ULL, 0x108fe400078e0206ULL,
0x0000000109087824ULL, 0x000fc600078e0206ULL, 0xfffffff80a067812ULL, 0x000fe200078ee203ULL,
0x000000041f0a7824ULL, 0x000fe200078e00ffULL, 0x0000d00015037811ULL, 0x000fe400078e60ffULL,
0xfffffff823087812ULL, 0x000fe400078ee208ULL, 0x000000040a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x100fe400078e0203ULL, 0x0000001008087824ULL, 0x000fe200078e0203ULL,
0x000000020a0a7812ULL, 0x000fc400078efcffULL, 0x00000000066c783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7231ULL, 0x08cfe400003400ffULL, 0x0000000f6e6e7231ULL, 0x000fe400003400ffULL,
0x0000000e6d6d7231ULL, 0x080fe400003400ffULL, 0x0000000e6f6f7231ULL, 0x000fc400003400ffULL,
0x0000000d28287231ULL, 0x080fe400003400ffULL, 0x0000000d2a2a7231ULL, 0x000fe400003400ffULL,
0x0000000c29297231ULL, 0x080fe400003400ffULL, 0x0000000c2b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000a1d087211ULL, 0x002fe200078fe0ffULL,
0x000000080b067824ULL, 0x040fe200078e00ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x0000001004047824ULL, 0x000fe200078e0203ULL, 0x00000c2000007945ULL, 0x000fe20003800000ULL,
0x000000010b0b7824ULL, 0x000fca00078e0208ULL, 0xfffffff8060b7812ULL, 0x000fca00078ee20bULL,
0x000000100b0b7824ULL, 0x000fca00078e0224ULL, 0x000000000b78783bULL, 0x0006a20000004200ULL,
0x000000ff71107812ULL, 0x002fe400078ec0ffULL, 0x00000018ff077819ULL, 0x100fe40000011670ULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x00000007ff07723eULL, 0x000fe400020006ffULL,
0x00000010ff067819ULL, 0x000fe20000011670ULL, 0x20000010ff237230ULL, 0x000fe20000004100ULL,
0x000000ff700a7812ULL, 0x040fe200078ec0ffULL, 0x20000007ff107230ULL, 0x000fe20000004100ULL,
0x0000ffff708d7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff0b7819ULL, 0x108fe40000011672ULL,
0x000000ff72707812ULL, 0x040fe400078ec0ffULL, 0x00000010ff267819ULL, 0x000fe40000011672ULL,
0x0000ffff728f7812ULL, 0x000fe400078ec0ffULL, 0x0000000bff0b723eULL, 0x000fe400020006ffULL,
0x000000ff73727812ULL, 0x000fc400078ec0ffULL, 0x00000070ff07723eULL, 0x000fe400020006ffULL,
0x00000010ff127819ULL, 0x100fe40000011671ULL, 0x000000ff7a867812ULL, 0x004fe400078ec0ffULL,
0x00000018ff227819ULL, 0x000fe40000011671ULL, 0x0000ffff718e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fc40000011679ULL, 0x00000010ff747819ULL, 0x100fe40000011673ULL,
0x00000018ff717819ULL, 0x000fe40000011673ULL, 0x0000ffff73907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x100fe40000011678ULL, 0x000000ff787f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fc40000011678ULL, 0x0000ffff78917812ULL, 0x000fe200078ec0ffULL,
0x2000000bff787230ULL, 0x000fe20000004100ULL, 0x000000ff06067812ULL, 0x000fe400078ec0ffULL,
0x00000072ff73723eULL, 0x000fe200020006ffULL, 0x20000007ff727230ULL, 0x000fe20000004100ULL,
0x00000086ff0b723eULL, 0x000fe400020006ffULL, 0x000000ff12127812ULL, 0x000fe400078ec0ffULL,
0x00000082ff07723eULL, 0x000fe200020006ffULL, 0x2000000bff877230ULL, 0x000fe20000004100ULL,
0x00000006ff06723eULL, 0x000fc400020006ffULL, 0x00000022ff22723eULL, 0x000fe200020006ffULL,
0x20000007ff867230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe200020006ffULL,
0x20000006ff077230ULL, 0x000fe20000004100ULL, 0x00000008ff0b7819ULL, 0x000fe2000001168eULL,
0x20000022ff707230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x20000012ff227230ULL, 0x000fe20000004100ULL, 0x00000008ff067819ULL, 0x000fe4000001168dULL,
0x000000ff26267812ULL, 0x000fe200078ec0ffULL, 0x20000071ff7d7230ULL, 0x000fe20000004100ULL,
0x0000000bff12723eULL, 0x000fc400020006ffULL, 0x00000010ff847819ULL, 0x100fe4000001167aULL,
0x00000018ff857819ULL, 0x000fe4000001167aULL, 0x0000ffff7a937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff817819ULL, 0x000fe40000011679ULL, 0x000000ff79837812ULL, 0x040fe400078ec0ffULL,
0x0000ffff79927812ULL, 0x000fe200078ec0ffULL, 0x20000073ff797230ULL, 0x000fe20000004100ULL,
0x00000018ff7a7819ULL, 0x000fc4000001167bULL, 0x00000006ff06723eULL, 0x000fe400020006ffULL,
0x000000ff74747812ULL, 0x000fe400078ec0ffULL, 0x00000026ff71723eULL, 0x000fe200020006ffULL,
0x20000012ff267230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe2000001168fULL,
0x20000006ff0b7230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fc400020006ffULL, 0x00000008ff127819ULL, 0x000fe20000011690ULL,
0x2000007eff827230ULL, 0x000fe20000004100ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x2000007aff8c7230ULL, 0x000fe20000004100ULL, 0x00000073ff06723eULL, 0x000fe200020006ffULL,
0x20000071ff737230ULL, 0x000fe20000004100ULL, 0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL,
0x20000074ff7a7230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe200020006ffULL,
0x20000006ff747230ULL, 0x000fe20000004100ULL, 0x00000008ff7e7819ULL, 0x000fc40000011692ULL,
0x0000007cff06723eULL, 0x000fe200020006ffULL, 0x20000012ff7c7230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x0000007eff12723eULL, 0x000fe200020006ffULL,
0x20000006ff7e7230ULL, 0x000fe20000004100ULL, 0x000000ff7b887812ULL, 0x000fe200078ec0ffULL,
0x20000085ff8a7230ULL, 0x000fe20000004100ULL, 0x0000000aff0a723eULL, 0x000fe200020006ffULL,
0x20000012ff857230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fc400078ec0ffULL,
0x00000008ff717819ULL, 0x000fe20000011691ULL, 0x2000000aff0a7230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe4000001167bULL, 0x0000ffff7b7b7812ULL, 0x000fe400078ec0ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x00000010ff127819ULL, 0x000fe20000011623ULL, 0x20000088ff8b7230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x000000ff84067812ULL, 0x000fe200078ec0ffULL, 0x20000081ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fe20000011610ULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000071ff817230ULL, 0x000fe20000004100ULL,
0x00000008ff107819ULL, 0x000fe40000011693ULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff7b7819ULL, 0x000fc4000001167bULL,
0x00000006ff88723eULL, 0x000fe400020006ffULL, 0x00000010ff067819ULL, 0x000fe4000001160aULL,
0x00000010ff077819ULL, 0x000fe20000011607ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011622ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000010ff107230ULL, 0x000fe20000004100ULL,
0x0000007bff7b723eULL, 0x000fc400020006ffULL, 0x00000010ff0a7819ULL, 0x000fe4000001160bULL,
0x0000105407067816ULL, 0x000fe20000000006ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x0000105471077816ULL, 0x000fe20000000012ULL, 0x20000089ff127230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff227819ULL, 0x000fe40000011672ULL,
0x00000010ff0b7819ULL, 0x000fe20000011626ULL, 0x000000066c2c723cULL, 0x000f62000004182cULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff837819ULL, 0x000fe20000011683ULL,
0x00000006284c723cULL, 0x000f62000004184cULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00001054700b7816ULL, 0x000fe4000000000bULL, 0x0000105473227816ULL, 0x000fc40000000022ULL,
0x000010547e7e7816ULL, 0x000fe4000000007fULL, 0x00001054230a7816ULL, 0x000fe4000000000aULL,
0x00000010ff717819ULL, 0x000fe40000011678ULL, 0x00000010ff707819ULL, 0x000fe40000011674ULL,
0x00001054847f7816ULL, 0x000fe20000000083ULL, 0x0000000a6c30723cULL, 0x000f620000041830ULL,
0x00000010ff737819ULL, 0x000fc4000001168aULL, 0x00000010ff107819ULL, 0x000fe40000011610ULL,
0x00000010ff237819ULL, 0x000fe40000011679ULL, 0x00000010ff7a7819ULL, 0x000fe2000001167aULL,
0x0000000a2850723cULL, 0x000b620000041850ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff827819ULL, 0x000fc40000011682ULL,
0x00000010ff817819ULL, 0x000fe20000011681ULL, 0x00000010050a7824ULL, 0x020fe200078e0203ULL,
0x00000010ff867819ULL, 0x000fe20000011686ULL, 0x0000007e285c723cULL, 0x080f62000004185cULL,
0x00000010ff837819ULL, 0x000fe20000011685ULL, 0x000000000404783bULL, 0x000e620000000200ULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff897819ULL, 0x000fe2000001168bULL, 0x0000007e6c3c723cULL, 0x000f62000004183cULL,
0x00000010ff127819ULL, 0x000fc40000011612ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x0000105471707816ULL, 0x000fe40000000070ULL,
0x0000105473727816ULL, 0x000fe40000000010ULL, 0x000010547a237816ULL, 0x000fe40000000023ULL,
0x000010547d717816ULL, 0x000fc4000000007cULL, 0x0000105482827816ULL, 0x000fe40000000081ULL,
0x0000105486837816ULL, 0x000fe20000000083ULL, 0x000000222854723cULL, 0x000f620000041854ULL,
0x0000105488887816ULL, 0x000fe40000000087ULL, 0x0000105412897816ULL, 0x000fe40000000089ULL,
0x000010548c737816ULL, 0x000fc6000000007bULL, 0x000000702858723cULL, 0x040f700000041858ULL,
0x000000822860723cULL, 0x040f700000041860ULL, 0x000000882864723cULL, 0x040f700000041864ULL,
0x000000722868723cULL, 0x000b640000041868ULL, 0x000000000a28783bULL, 0x0204ec0000000200ULL,
0x000000226c34723cULL, 0x040b700000041834ULL, 0x000000706c38723cULL, 0x040b700000041838ULL,
0x000000826c40723cULL, 0x040b700000041840ULL, 0x000000886c44723cULL, 0x040b700000041844ULL,
0x000000726c48723cULL, 0x000b620000041848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f28287231ULL, 0x08efe400003400ffULL,
0x0000000f2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000e29297231ULL, 0x080fe400003400ffULL,
0x0000000e2b2b7231ULL, 0x000fe400003400ffULL, 0x0000000d04047231ULL, 0x080fe400003400ffULL,
0x0000000d06067231ULL, 0x000fe400003400ffULL, 0x0000000c05057231ULL, 0x080fe400003400ffULL,
0x0000000c07077231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000000809037824ULL, 0x040fe200078e00ffULL, 0x00000000256c783bULL, 0x020e620000004200ULL,
0x0000000109087824ULL, 0x000fca00078e0208ULL, 0xfffffff803037812ULL, 0x000fca00078ee208ULL,
0x0000001003037824ULL, 0x000fca00078e0224ULL, 0x000000000308783bULL, 0x0002a40000004200ULL,
0x00000018ff037819ULL, 0x002fe4000001166eULL, 0x00000010ff107819ULL, 0x100fe4000001166cULL,
0x00000003ff03723eULL, 0x000fe400020006ffULL, 0x000000ff6c227812ULL, 0x000fe400078ec0ffULL,
0x00000018ff127819ULL, 0x000fc4000001166cULL, 0x0000ffff6c867812ULL, 0x000fe400078ec0ffULL,
0x00000010ff237819ULL, 0x100fe4000001166dULL, 0x000000ff6d257812ULL, 0x040fe400078ec0ffULL,
0x000000ff0a7b7812ULL, 0x004fe400078ec0ffULL, 0x00000018ff247819ULL, 0x000fe4000001166dULL,
0x0000ffff6d877812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6c7819ULL, 0x000fe4000001166eULL,
0x000000ff6e267812ULL, 0x040fe400078ec0ffULL, 0x0000ffff6e887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6e7819ULL, 0x100fe4000001166fULL, 0x000000ff6f707812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fc4000001166fULL, 0x0000ffff6f897812ULL, 0x000fe200078ec0ffULL,
0x20000003ff6f7230ULL, 0x000fe20000004100ULL, 0x0000007bff03723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x100fe40000011608ULL, 0x000000ff08747812ULL, 0x040fe200078ec0ffULL,
0x20000003ff7f7230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe40000011608ULL,
0x0000ffff088a7812ULL, 0x000fc400078ec0ffULL, 0x00000026ff08723eULL, 0x000fe400020006ffULL,
0x00000010ff787819ULL, 0x100fe40000011609ULL, 0x000000ff097a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe40000011609ULL, 0x0000ffff098b7812ULL, 0x000fe400078ec0ffULL,
0x0000006dff09723eULL, 0x000fe200020006ffULL, 0x20000008ff6d7230ULL, 0x000fe20000004100ULL,
0x00000008ff037819ULL, 0x000fc40000011686ULL, 0x00000008ff087819ULL, 0x000fe20000011687ULL,
0x20000009ff737230ULL, 0x000fe20000004100ULL, 0x00000003ff03723eULL, 0x000fe400020006ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000008ff08723eULL, 0x000fe200020006ffULL,
0x20000003ff097230ULL, 0x000fe20000004100ULL, 0x00000008ff037819ULL, 0x000fe20000011689ULL,
0x20000024ff267230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x20000008ff247230ULL, 0x000fe20000004100ULL, 0x000000ff71087812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7c7819ULL, 0x100fe2000001160aULL, 0x2000007aff7b7230ULL, 0x000fe20000004100ULL,
0x00000018ff7d7819ULL, 0x000fe4000001160aULL, 0x0000ffff0a8c7812ULL, 0x000fe400078ec0ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x000000ff10107812ULL, 0x000fe400078ec0ffULL,
0x00000018ff0a7819ULL, 0x000fe2000001160bULL, 0x20000072ff7a7230ULL, 0x000fe20000004100ULL,
0x00000003ff03723eULL, 0x000fc400020006ffULL, 0x000000ff0b817812ULL, 0x000fe400078ec0ffULL,
0x00000008ff08723eULL, 0x000fe200020006ffULL, 0x20000003ff727230ULL, 0x000fe20000004100ULL,
0x000000ff78787812ULL, 0x000fe400078ec0ffULL, 0x00000022ff22723eULL, 0x000fe400020006ffULL,
0x00000010ff10723eULL, 0x000fe400020006ffULL, 0x0000000aff0a723eULL, 0x000fe200020006ffULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL,
0x20000010ff107230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x2000000aff857230ULL, 0x000fe20000004100ULL, 0x00000078ff03723eULL, 0x000fe200020006ffULL,
0x20000008ff787230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000081ff847230ULL, 0x000fe20000004100ULL, 0x000000ff7c087812ULL, 0x000fe200078ec0ffULL,
0x20000003ff7c7230ULL, 0x000fe20000004100ULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000008ff0a7819ULL, 0x000fc40000011688ULL,
0x00000008ff81723eULL, 0x000fe400020006ffULL, 0x000000ff23237812ULL, 0x000fe400078ec0ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff087819ULL, 0x000fe40000011622ULL, 0x00000010ff037819ULL, 0x000fe20000011610ULL,
0x2000006eff717230ULL, 0x000fe20000004100ULL, 0x0000000aff0a723eULL, 0x000fc400020006ffULL,
0x00000010ff837819ULL, 0x000fe4000001160bULL, 0x0000ffff0b8d7812ULL, 0x000fe200078ec0ffULL,
0x2000000aff6e7230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe400020006ffULL,
0x00000008ff0b7819ULL, 0x000fe4000001168bULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x20000012ff127230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fc400020006ffULL,
0x0000105403087816ULL, 0x000fe20000000008ULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000023ff237230ULL, 0x000fe20000004100ULL,
0x00000010ff227819ULL, 0x000fe4000001166dULL, 0x00000010ff037819ULL, 0x000fe2000001166cULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000008ff0a7819ULL, 0x000fc4000001168aULL, 0x0000000bff0b723eULL, 0x000fe200020006ffULL,
0x2000007dff827230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000105403227816ULL, 0x000fe20000000022ULL, 0x2000000bff7d7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff037819ULL, 0x000fe4000001168cULL, 0x0000000aff0a723eULL, 0x000fe200020006ffULL,
0x20000079ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff0b7819ULL, 0x000fc40000011612ULL,
0x00000010ff257819ULL, 0x000fe20000011625ULL, 0x2000000aff797230ULL, 0x000fe20000004100ULL,
0x00000010ff107819ULL, 0x000fe40000011623ULL, 0x00000003ff12723eULL, 0x000fe400020006ffULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff037819ULL, 0x000fe20000011678ULL,
0x20000012ff127230ULL, 0x000fe20000004100ULL, 0x00000010ff0a7819ULL, 0x000fc40000011609ULL,
0x0000105410097816ULL, 0x000fe40000000025ULL, 0x00000010ff237819ULL, 0x000fe40000011670ULL,
0x00000010ff107819ULL, 0x000fe40000011671ULL, 0x00001054036c7816ULL, 0x000fe20000000074ULL,
0x00000008282c723cULL, 0x008b62000004182cULL, 0x000000ff83837812ULL, 0x000fe400078ec0ffULL,
0x00000008ff037819ULL, 0x000fc4000001168dULL, 0x0000105410237816ULL, 0x000fe40000000023ULL,
0x00000010ff107819ULL, 0x000fe20000011673ULL, 0x00000008044c723cULL, 0x000b62000004184cULL,
0x00000010ff257819ULL, 0x000fe40000011672ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000003ff03723eULL, 0x000fe400020006ffULL, 0x000010540b0a7816ULL, 0x000fe2000000000aULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff0b7819ULL, 0x000fe20000011624ULL,
0x20000003ff707230ULL, 0x000fe20000004100ULL, 0x0000105410257816ULL, 0x000fe20000000025ULL,
0x000000222834723cULL, 0x000b620000041834ULL, 0x00000010ff267819ULL, 0x000fc40000011626ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff247819ULL, 0x000fe4000001166eULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x000000220454723cULL, 0x000b620000041854ULL,
0x00000010ff107819ULL, 0x000fe40000011681ULL, 0x00001054260b7816ULL, 0x000fe4000000000bULL,
0x000010546f247816ULL, 0x000fc40000000024ULL, 0x00000010ff6d7819ULL, 0x000fe4000001167bULL,
0x00001054106e7816ULL, 0x000fe2000000007fULL, 0x0000000a2830723cULL, 0x040b620000041830ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff7a7819ULL, 0x000fe4000001167aULL,
0x00000010ff797819ULL, 0x000fe40000011679ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x000000242838723cULL, 0x000b620000041838ULL, 0x00000010ff7b7819ULL, 0x000fc4000001167dULL,
0x00000010ff6f7819ULL, 0x000fe40000011684ULL, 0x00000010ff267819ULL, 0x000fe40000011683ULL,
0x00000010ff037819ULL, 0x000fe20000011682ULL, 0x0000000a0450723cULL, 0x000b620000041850ULL,
0x00000010ff127819ULL, 0x000fe40000011612ULL, 0x00000010ff107819ULL, 0x000fe40000011685ULL,
0x00000010ff717819ULL, 0x000fc40000011670ULL, 0x000010547c6d7816ULL, 0x000fe2000000006dULL,
0x000000240458723cULL, 0x000b620000041858ULL, 0x000010547a7a7816ULL, 0x000fe40000000079ULL,
0x000010547e7b7816ULL, 0x000fe4000000007bULL, 0x00001054266f7816ULL, 0x000fe4000000006fULL,
0x0000105403707816ULL, 0x000fe20000000012ULL, 0x0000006c283c723cULL, 0x000b62000004183cULL,
0x0000105410717816ULL, 0x000fce0000000071ULL, 0x0000007a2840723cULL, 0x040b700000041840ULL,
0x0000006e2844723cULL, 0x040b700000041844ULL, 0x000000702848723cULL, 0x000b700000041848ULL,
0x0000006c045c723cULL, 0x040b70000004185cULL, 0x0000007a0460723cULL, 0x040b700000041860ULL,
0x0000006e0464723cULL, 0x040b700000041864ULL, 0x000000700468723cULL, 0x000b620000041868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000013047f8cULL, 0x0202a2000c80043fULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x000126a015067811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff037224ULL, 0x004fe200078e0005ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff314000007947ULL, 0x000fea000383ffffULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000ec4000047802ULL, 0x000fc40000000f00ULL, 0x0000b81000007944ULL, 0x01efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002100007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc80000000021ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000001808057811ULL, 0x042fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x042fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000004400447220ULL, 0x040fe20000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004e054e7220ULL, 0x044fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000005a055a7220ULL, 0x040fe20000410000ULL, 0x0000005b055b7220ULL, 0x040fe20000410000ULL,
0x0000005e055e7220ULL, 0x040fe20000410000ULL, 0x0000005f055f7220ULL, 0x040fe20000410000ULL,
0x0000006205627220ULL, 0x040fe20000410000ULL, 0x0000006305637220ULL, 0x040fe20000410000ULL,
0x0000006605667220ULL, 0x040fe20000410000ULL, 0x0000006705677220ULL, 0x040fe20000410000ULL,
0x0000006a056a7220ULL, 0x040fe20000410000ULL, 0x0000006b056b7220ULL, 0x000fe20000410000ULL,
0x000000042e2e7220ULL, 0x088fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x000000043e3e7220ULL, 0x080fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000442427220ULL, 0x080fe20000410000ULL, 0x0000000443437220ULL, 0x080fe20000410000ULL,
0x0000000446467220ULL, 0x080fe20000410000ULL, 0x0000000447477220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x000000024c4c7220ULL, 0x080fe20000410000ULL, 0x000000024d4d7220ULL, 0x080fe20000410000ULL,
0x0000000250507220ULL, 0x080fe20000410000ULL, 0x0000000251517220ULL, 0x080fe20000410000ULL,
0x0000000254547220ULL, 0x080fe20000410000ULL, 0x0000000255557220ULL, 0x080fe20000410000ULL,
0x0000000258587220ULL, 0x080fe20000410000ULL, 0x0000000259597220ULL, 0x080fe20000410000ULL,
0x000000025c5c7220ULL, 0x080fe20000410000ULL, 0x000000025d5d7220ULL, 0x080fe20000410000ULL,
0x0000000260607220ULL, 0x080fe20000410000ULL, 0x0000000261617220ULL, 0x080fe20000410000ULL,
0x0000000264647220ULL, 0x080fe20000410000ULL, 0x0000000265657220ULL, 0x080fe20000410000ULL,
0x0000000268687220ULL, 0x080fe20000410000ULL, 0x0000000269697220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000002e2f2e723eULL, 0x000fc400000010ffULL,
0x000000323317723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fe400000010ffULL, 0x0000003a3b1b723eULL, 0x000fe400000010ffULL,
0x0000003e3f3e723eULL, 0x000fc400000010ffULL, 0x000000424342723eULL, 0x000fe400000010ffULL,
0x000054102e167816ULL, 0x140fe40000000017ULL, 0x000076322e177816ULL, 0x000fe40000000017ULL,
0x00005410361a7816ULL, 0x000fe4000000001bULL, 0x0000000803057811ULL, 0x042fe200078ff0ffULL,
0x0000000180807824ULL, 0x000fe200078e0203ULL, 0x0000000203007812ULL, 0x000fc400078ec0ffULL,
0x0000001803097811ULL, 0x000fe200078ff0ffULL, 0x0000000805077824ULL, 0x004fe200078e00ffULL,
0x0000000500027211ULL, 0x040fe400078ff8ffULL, 0x0000001003057811ULL, 0x000fe200078ff0ffULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0xfffffff8070c7812ULL, 0x000fe400078ee202ULL,
0x00000002ff077819ULL, 0x000fe20000011603ULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0x0000000500047211ULL, 0x000fc400078ff8ffULL, 0x0000000700027211ULL, 0x040fe200078ff8ffULL,
0x00000008070a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b107812ULL, 0x000fe200078ee204ULL,
0x000020001f047824ULL, 0x000fe200078e00ffULL, 0x0000000900057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe20007ffe0ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe400078ee205ULL,
0x0000200004057812ULL, 0x000fc400078ee2ffULL, 0xfffffff809067812ULL, 0x048fe400078ee200ULL,
0xfffffff809007812ULL, 0x000fe200078ee202ULL, 0x0000100018077824ULL, 0x100fe200078e0205ULL,
0x0000000402047810ULL, 0x000fe20007ffe0ffULL, 0x0000001080807824ULL, 0x000fe200078e0205ULL,
0x0000000602097810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff80b087812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e0207ULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL, 0x000000100c0e7824ULL, 0x100fe200078e0207ULL,
0x0000000802097812ULL, 0x000fe200078ec0ffULL, 0x0000001010107824ULL, 0x100fe200078e0207ULL,
0x0000002c2d00723eULL, 0x000fe200000010ffULL, 0x0000001012127824ULL, 0x100fe200078e0207ULL,
0x000000303102723eULL, 0x000fe200000010ffULL, 0x0000001006067824ULL, 0x000fe200078e0207ULL,
0x00007632361b7816ULL, 0x000fe2000000001bULL, 0x0000001008087824ULL, 0x100fe200078e0207ULL,
0x0000541000147816ULL, 0x100fe20000000002ULL, 0x000000100a0c7824ULL, 0x000fe200078e0207ULL,
0x0000763200157816ULL, 0x000fe20000000002ULL, 0x0000000104077824ULL, 0x000fe200078e0209ULL,
0x000000343500723eULL, 0x000fe200000010ffULL, 0x00000001090a7824ULL, 0x000fe200078e0206ULL,
0x000000383902723eULL, 0x000fe200000010ffULL, 0x00000001090b7824ULL, 0x000fe200078e0208ULL,
0x0000001407007388ULL, 0x0003e20000000a00ULL, 0x0000003c3d04723eULL, 0x000fe200000010ffULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x000000404106723eULL, 0x000fe200000010ffULL,
0x00000001090e7824ULL, 0x000fe200078e020eULL, 0x000000484908723eULL, 0x000fe200000010ffULL,
0x0000000109107824ULL, 0x000fe200078e0210ULL, 0x000000464746723eULL, 0x000fe200000010ffULL,
0x0000000109127824ULL, 0x000fe200078e0212ULL, 0x0000004a4b23723eULL, 0x000fc400000010ffULL,
0x0000004c4d4c723eULL, 0x000fe400000010ffULL, 0x0000541000147816ULL, 0x142fe40000000002ULL,
0x0000763200157816ULL, 0x000fe40000000002ULL, 0x000000444507723eULL, 0x000fe400000010ffULL,
0x000000505126723eULL, 0x000fe200000010ffULL, 0x000000140a007388ULL, 0x0003e20000000a00ULL,
0x000000545554723eULL, 0x000fc400000010ffULL, 0x00000058592a723eULL, 0x000fe400000010ffULL,
0x0000541046227816ULL, 0x140fe40000000023ULL, 0x0000763246237816ULL, 0x000fe40000000023ULL,
0x0000763254097816ULL, 0x000fe4000000002aULL, 0x0000005c5d5c723eULL, 0x000fe400000010ffULL,
0x0000541004147816ULL, 0x002fc40000000006ULL, 0x0000763204157816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000140b007388ULL, 0x000fe20000000a00ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x000000606160723eULL, 0x000fe200000010ffULL, 0x000000060c007388ULL, 0x0003e20000000a00ULL,
0x000000646564723eULL, 0x000fc400000010ffULL, 0x000000686932723eULL, 0x000fe200000010ffULL,
0x000000160e007388ULL, 0x000fe20000000a00ULL, 0x0000004e4f00723eULL, 0x000fe400000010ffULL,
0x000000525302723eULL, 0x000fe200000010ffULL, 0x0004001a0a007388ULL, 0x000fe20000000a00ULL,
0x000000565704723eULL, 0x000fe400000010ffULL, 0x000054103e067816ULL, 0x142fe40000000042ULL,
0x000076323e077816ULL, 0x000fca0000000042ULL, 0x000400060b007388ULL, 0x0003e80000000a00ULL,
0x000400220c007388ULL, 0x000fe20000000a00ULL, 0x000054104c067816ULL, 0x142fe40000000026ULL,
0x000076324c077816ULL, 0x000fca0000000026ULL, 0x0000000610007388ULL, 0x0003e80000000a00ULL,
0x000800080a007388ULL, 0x0005e20000000a00ULL, 0x0000005a5b06723eULL, 0x002fe200000010ffULL,
0x000000ff00077306ULL, 0x000fe20000209400ULL, 0x000054105c087816ULL, 0x144fe40000000060ULL,
0x000076325c097816ULL, 0x000fca0000000060ULL, 0x000800080b007388ULL, 0x0003e40000000a00ULL,
0x0000541064087816ULL, 0x142fe40000000032ULL, 0x0000763264097816ULL, 0x000fca0000000032ULL,
0x000800080c007388ULL, 0x0003e40000000a00ULL, 0x0000541000087816ULL, 0x142fe40000000002ULL,
0x0000763200097816ULL, 0x000fe40000000002ULL, 0x0000005e5f00723eULL, 0x000fe400000010ffULL,
0x000000626302723eULL, 0x000fe200000010ffULL, 0x0000000812007388ULL, 0x0003e40000000a00ULL,
0x0000541004087816ULL, 0x002fc40000000006ULL, 0x0000763204097816ULL, 0x000fe40000000006ULL,
0x000000666704723eULL, 0x000fe400000010ffULL, 0x0000006a6b06723eULL, 0x000fe200000010ffULL,
0x000c00080a007388ULL, 0x0003e60000000a00ULL, 0x00005410040e7816ULL, 0x140fe40000000006ULL,
0x00007632040f7816ULL, 0x000fc40000000006ULL, 0x0000541000087816ULL, 0x142fe40000000002ULL,
0x0000763200097816ULL, 0x000fe40000000002ULL, 0x000000ff00007306ULL, 0x000e660000205400ULL,
0x000c00080b007388ULL, 0x000fe80000000a00ULL, 0x000c000e0c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000080107984ULL, 0x000ea20000000c00ULL,
0x000000000700720bULL, 0x002fc40003f1d000ULL, 0x000000ff00007245ULL, 0x000fe2000020d400ULL,
0x0004000080087984ULL, 0x000e680000000c00ULL, 0x0008000080287984ULL, 0x000ee80000000c00ULL,
0x000c000080307984ULL, 0x000ee40000000c00ULL, 0x0000000100000812ULL, 0x000fc400078efcffULL,
0x0010000080147984ULL, 0x000ee20000000c00ULL, 0x000000ff1800720cULL, 0x000fe40003f05270ULL,
0x000000000004723eULL, 0x000fe200000010ffULL, 0x0014000080247984ULL, 0x010ee80000000c00ULL,
0x00180000802c7984ULL, 0x000ee80000000c00ULL, 0x001c0000800c7984ULL, 0x000ee20000000c00ULL,
0x3f803f8004137831ULL, 0x004fc40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x042fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x000fc40000200009ULL, 0x3f803f8004087831ULL, 0x040fe40000200008ULL,
0x3f803f80042b7831ULL, 0x048fe4000020002bULL, 0x3f803f80042a7831ULL, 0x040fe4000020002aULL,
0x3f803f8004297831ULL, 0x040fe40000200029ULL, 0x3f803f8004287831ULL, 0x040fe40000200028ULL,
0x3f803f8004337831ULL, 0x000fc40000200033ULL, 0x3f803f8004327831ULL, 0x040fe40000200032ULL,
0x3f803f8004317831ULL, 0x040fe40000200031ULL, 0x3f803f8004307831ULL, 0x000fe40000200030ULL,
0x3f803f8013137831ULL, 0x000fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fc40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f800b0b7831ULL, 0x000fe40000200027ULL, 0x3f803f800a0a7831ULL, 0x000fe20000200026ULL,
0x0000001080007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200025ULL,
0x3f803f8008087831ULL, 0x000fe40000200024ULL, 0x3f803f802b2b7831ULL, 0x000fc4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020002eULL, 0x0004000880007388ULL, 0x000fe20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fe4000020002cULL,
0x3f803f8033337831ULL, 0x000fe4000020000fULL, 0x3f803f8032327831ULL, 0x000fe2000020000eULL,
0x0008002880007388ULL, 0x000fe20000000c00ULL, 0x3f803f8031317831ULL, 0x000fc4000020000dULL,
0x3f803f8030307831ULL, 0x000fca000020000cULL, 0x000c003080007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011603ULL, 0x000000760900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000027b06ULL, 0x000e620000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff137a12ULL, 0x000fe200078e33ffULL,
0x000000011e007824ULL, 0x000fe200078e0209ULL, 0x000000011f1f7812ULL, 0x000fc800078ec0ffULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe02087810ULL, 0x002fe20007ffe0ffULL,
0x0000000109027824ULL, 0x000fca00078e0203ULL, 0x0000000800077305ULL, 0x000e62000021f000ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802027812ULL, 0x000fca00078ef803ULL,
0x0000001002027824ULL, 0x000fe400078e0205ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07117227ULL, 0x000fe400078e0006ULL,
0x0000000002087984ULL, 0x0002a80000000c00ULL, 0x0000000011047227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fe200078e0a04ULL, 0x0000000703027812ULL, 0x002fc600078ec0ffULL,
0x00005a0007067a24ULL, 0x000fca00078e0200ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x0000000413077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x000000081f0d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077047210ULL, 0x000fe40007f3e0ffULL,
0x0000002003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0004067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0004077a11ULL, 0x000fe400008f4407ULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000211067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x000000081f0d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277077210ULL, 0x000fe40007f3e0ffULL, 0x0000004003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000011067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x000000081f0d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077077210ULL, 0x000fe40007f3e0ffULL,
0x0000006003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e027824ULL, 0x100fe400078e020fULL,
0x00000001000f7824ULL, 0x000fe400078e020fULL, 0x0000000211067227ULL, 0x002fc600078e00ffULL,
0x000000070f0f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000106061810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80f047812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x000000081f0d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277077210ULL, 0x000fe40007f3e0ffULL, 0x0000008003027810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x040fe400078240ffULL,
0x00000003ff0f7819ULL, 0x000fe40000011602ULL, 0x00005f0007077a11ULL, 0x000fe400008f440cULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e007824ULL, 0x100fe400078e020fULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000000011067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001004047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fe400078e0200ULL, 0x000000081f0d7824ULL, 0x000fe400078e0202ULL,
0x00005a0007007a24ULL, 0x000fca00078e0200ULL, 0x0000000077077210ULL, 0x000fe40007f3e0ffULL,
0x000000a003007810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x040fe400078240ffULL, 0x00000003ff0f7819ULL, 0x000fe40000011600ULL,
0x00005f0007077a11ULL, 0x000fe400008f440cULL, 0x000000760f00720cULL, 0x000fc60003f26070ULL,
0x000000100d067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000011e027824ULL, 0x100fe200078e020fULL,
0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001000f7824ULL, 0x000fe400078e020fULL,
0x0000000211067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f047812ULL, 0x000fe400078ef800ULL, 0x00000003ff0f7819ULL, 0x000fe4000001160cULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fca00078e0205ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000106062810ULL, 0x000fc80007ffe0ffULL,
0x0000000613077207ULL, 0x000fca0004000000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0220ULL, 0x00005a000d027a24ULL, 0x000fe400078e0202ULL,
0x000000081f0d7824ULL, 0x000fe400078e0200ULL, 0x00005a0007027a24ULL, 0x000fca00078e0202ULL,
0x0000000277027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0002067a11ULL, 0x000fc800078240ffULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x000000760f00720cULL, 0x000fc60003f26070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000011e007824ULL, 0x100fe400078e020fULL, 0x000000010c0f7824ULL, 0x000fe400078e020fULL,
0x0000000011067227ULL, 0x002fc600078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007027a24ULL, 0x000fca00078e0200ULL,
0x00005a0002007a0cULL, 0x000fda0003f26070ULL, 0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a0002007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80f027812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001002047824ULL, 0x000fca00078e0205ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000106062810ULL, 0x000fc80007ffe0ffULL, 0x0000000613077207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0220ULL,
0x00005a000d007a24ULL, 0x000fc800078e0200ULL, 0x00005a0007007a24ULL, 0x000fca00078e0200ULL,
0x0000000077067210ULL, 0x000fe40007f3e0ffULL, 0x000000e003007810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0006027a11ULL, 0x040fe400078240ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011600ULL, 0x00005f0006037a11ULL, 0x000fe200008f4407ULL,
0x000000081f077824ULL, 0x000fe200078e020cULL, 0x000000760d00720cULL, 0x000fe20003f26070ULL,
0x000000011e1e7824ULL, 0x000fe400078e020dULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000001e11037227ULL, 0x002fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a03ULL,
0x00000001000d7824ULL, 0x000fe400078e020dULL, 0x00005a0007027a24ULL, 0x000fc600078e021eULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0002007a0cULL, 0x000fda0003f26070ULL,
0x80005a0002021a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0002007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d027812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001002057824ULL, 0x000fca00078e0205ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x0000000313037207ULL, 0x000fe20004000000ULL, 0x000000081f057824ULL, 0x002fc800078e0200ULL,
0x000000ffff077224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0220ULL,
0x00005a00071e7a24ULL, 0x000fc800078e021eULL, 0x00005a00031e7a24ULL, 0x000fca00078e021eULL,
0x0000001e771e7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e001e027a11ULL, 0x000fc800078040ffULL, 0x00005f001e037a11ULL, 0x000fca00000f4403ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x004fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe2000001161fULL,
0xffffffffff187424ULL, 0x000fc600078e00ffULL, 0x0000001b0000720cULL, 0x000fda0003f06070ULL,
0x0000000204078824ULL, 0x000fc800078e00ffULL, 0x00006a0007088a24ULL, 0x000fc800078e0200ULL,
0x0000660008088625ULL, 0x000fe200078e0035ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000608188981ULL, 0x000ea2000c1e1900ULL, 0x00006e00ff687624ULL, 0x000fe400078e00ffULL,
0x00006f00ff697624ULL, 0x000fe200078e00ffULL, 0x01260000ff067f8cULL, 0x000e68000c80043fULL,
0x0000000668687981ULL, 0x000722000c1e9900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x00005800ff667624ULL, 0x000fc400078e00ffULL, 0x0000008065657824ULL, 0x000fe400078e00ffULL,
0x0000008020647824ULL, 0x000fe200078e00ffULL, 0x0000001f66667810ULL, 0x000fe20007ffe0ffULL,
0x000000401f677824ULL, 0x000fe400078e00ffULL, 0x00000080ff057424ULL, 0x000fe200078e00ffULL,
0x00000005ff667819ULL, 0x000fe40000011666ULL, 0x0000004064207812ULL, 0x000fe200078ef867ULL,
0x0000006518087224ULL, 0x004fc800078e02ffULL, 0x0000640008087625ULL, 0x000fe200078e0005ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x00afe4000001161dULL,
0x0000001d1d147211ULL, 0x000fe400078fe8ffULL, 0x0000000827167810ULL, 0x040fe20007ffe0ffULL,
0x00000001200a7824ULL, 0x000fe200078e0227ULL, 0x0000001027287810ULL, 0x040fe40007ffe0ffULL,
0x0000001827297810ULL, 0x040fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002027237810ULL, 0x000fc40007ffe0ffULL, 0x0000002827257810ULL, 0x000fe20007ffe0ffULL,
0x00000001200c7824ULL, 0x000fe200078e0216ULL, 0x000000300a137812ULL, 0x000fe200078ef802ULL,
0x00000001200e7824ULL, 0x000fe200078e0228ULL, 0x000000671c0a7217ULL, 0x000fe20007800000ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001308127210ULL, 0x000fe40007f1e0ffULL,
0x0000000314227812ULL, 0x000fe200078ec0ffULL, 0x0000000120107824ULL, 0x000fe200078e0229ULL,
0x000000300c057812ULL, 0x000fe200078ef802ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000020001f247811ULL, 0x000fc400078e68ffULL, 0x00000005080c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0ffffffc221d7812ULL, 0x000fe400078ef81dULL,
0x0000003027267810ULL, 0x000fe20007ffe0ffULL, 0x0000000109137824ULL, 0x040fe200000e060bULL,
0x000000300e0b7812ULL, 0x100fe200078ef802ULL, 0x00000001090d7824ULL, 0x000fe200008e060dULL,
0x0000003010057812ULL, 0x000fe200078ef802ULL, 0x0000000416177824ULL, 0x000fe200078e00ffULL,
0x0000000b080e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001200b7824ULL, 0x000fe200078e0223ULL,
0x0000000508107210ULL, 0x000fe20007f3e0ffULL, 0x000000010a057824ULL, 0x000fe200078e0a67ULL,
0xfffffffc17177812ULL, 0x000fe200078ee222ULL, 0x000000800b0a7825ULL, 0x000fc600078e00ffULL,
0x000000052800720cULL, 0x080fe20003fa6070ULL, 0x00000001090f7824ULL, 0x000fe200000e060fULL,
0x000000300a157812ULL, 0x000fe200078ef802ULL, 0x00000001200a7824ULL, 0x000fe200078e0225ULL,
0x000000052700720cULL, 0x000fe20003f06070ULL, 0x0000000109117824ULL, 0x000fe200008e0611ULL,
0x0000001508147210ULL, 0x000fe20007f5e0ffULL, 0x0000001017217824ULL, 0x100fe200078e0224ULL,
0x000000051600720cULL, 0x080fe20003f26070ULL, 0x000000101d1d7824ULL, 0x000fe200078e0224ULL,
0x0000003827277810ULL, 0x000fe20007ffe0ffULL, 0x0000000109157824ULL, 0x000fe200010e060bULL,
0x000000052500720cULL, 0x080fe20003f46070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000052900720cULL, 0x000fc40003f86070ULL, 0x000000052300720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121d7faeULL, 0x0003e2000c101c46ULL,
0x000000300a177812ULL, 0x000fe200078ef802ULL, 0x00000001200a7824ULL, 0x000fe200078e0226ULL,
0x000000052700720cULL, 0x000fe20003f06070ULL, 0x000000000c217faeULL, 0x0005e2000c901c46ULL,
0x0000001708167210ULL, 0x000fe20007fde0ffULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x000000052600720cULL, 0x000fe20003f26070ULL, 0x0000000428057824ULL, 0x000fe400078e00ffULL,
0x0000000109177824ULL, 0x000fc400030e060bULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc05057812ULL, 0x000fc600078ee222ULL, 0x00000001200c7824ULL, 0x004fe200078e0227ULL,
0x000000300a217812ULL, 0x000fe200078ef802ULL, 0x0000000427277824ULL, 0x000fe400078e00ffULL,
0x0000000429137824ULL, 0x002fe200078e00ffULL, 0x00000021080a7210ULL, 0x000fe20007fde0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc25217812ULL, 0x100fe400078ee222ULL,
0xfffffffc27257812ULL, 0x100fe200078ee222ULL, 0x00000004231d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc13137812ULL, 0x000fe200078ee222ULL, 0x0000000426237824ULL, 0x000fe200078e00ffULL,
0x000000300c277812ULL, 0x000fe200078ef802ULL, 0x00000001090b7824ULL, 0x000fe200030e060bULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee222ULL, 0x0000001005057824ULL, 0x000fe200078e0224ULL,
0xfffffffc23237812ULL, 0x000fe200078ee222ULL, 0x0000001013137824ULL, 0x100fe200078e0224ULL,
0x0000002708087210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0224ULL,
0x000000000e057faeULL, 0x0003e2000e901c46ULL, 0x0000001021217824ULL, 0x000fc400078e0224ULL,
0x0000001023237824ULL, 0x100fe200078e0224ULL, 0x0000000010137faeULL, 0x0003e2000e101c46ULL,
0x0000001025257824ULL, 0x000fe400078e0224ULL, 0x0000000109097824ULL, 0x000fe200030e060dULL,
0x00000000141d7faeULL, 0x0003e8000d901c46ULL, 0x0000000016217faeULL, 0x0003e8000d101c46ULL,
0x000000000a237faeULL, 0x0003e8000c901c46ULL, 0x0000000008257faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x000000101d137811ULL, 0x04afe400078ff0ffULL,
0x000000181d157811ULL, 0x000fc400078ff0ffULL, 0x0000001d1d0c7211ULL, 0x040fe200078fe8ffULL,
0x00000001200e7824ULL, 0x040fe200078e0213ULL, 0x000000201d057811ULL, 0x000fe200078ff0ffULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0x000000301d0d7811ULL, 0x040fe200078ff0ffULL,
0x0000000120107824ULL, 0x000fe200078e0215ULL, 0x000000381d0f7811ULL, 0x000fe200078ff0ffULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x000000081d117811ULL, 0x000fe200078ff0ffULL,
0x0000000405177824ULL, 0x000fe200078e00ffULL, 0x000000030c147812ULL, 0x000fe200078ec0ffULL,
0x0000000120267824ULL, 0x040fe200078e020dULL, 0x000000281d0b7811ULL, 0x000fe200078ff0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0x000000201d0a7211ULL, 0x000fe200078ff0ffULL,
0x0000000120287824ULL, 0x040fe200078e020fULL, 0xfffffffc13127812ULL, 0x100fe200078ee214ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc15137812ULL, 0x100fe200078ee214ULL,
0x00000001200c7824ULL, 0x040fe200078e0211ULL, 0xfffffffc17157812ULL, 0x100fe200078ee214ULL,
0x0000000120247824ULL, 0x040fe200078e020bULL, 0xfffffffc0d177812ULL, 0x100fe200078ee214ULL,
0x000000040b237824ULL, 0x000fe200078e00ffULL, 0x000020001f2a7811ULL, 0x000fe200078e68ffULL,
0x0000000120227824ULL, 0x000fe200078e0205ULL, 0x0ffffffc14217812ULL, 0x000fe200078ef81dULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc0f207812ULL, 0x000fc400078ee214ULL,
0xfffffffc23167812ULL, 0x000fe200078ee214ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a1d7812ULL, 0x000fc600078ef802ULL, 0x0000000411117824ULL, 0x000fe400078e00ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffffc11057812ULL, 0x000fe200078ee214ULL,
0x0000001013237824ULL, 0x000fe200078e022aULL, 0x000000300c137812ULL, 0x000fe200078ef802ULL,
0x0000001021377824ULL, 0x000fe200078e022aULL, 0x000000300e217812ULL, 0x000fe200078ef802ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001d08147210ULL, 0x000fc60007f1e0ffULL,
0x0000001016277824ULL, 0x100fe200078e022aULL, 0x0000001308167210ULL, 0x000fe20007f3e0ffULL,
0x00000010202b7824ULL, 0x100fe200078e022aULL, 0x0000002108207210ULL, 0x000fe20007f5e0ffULL,
0x0000001015257824ULL, 0x000fe200078e022aULL, 0x0000003010137812ULL, 0x000fe200078ef802ULL,
0x0000001017297824ULL, 0x000fe400078e022aULL, 0x0000000109157824ULL, 0x040fe200000e060bULL,
0x0000001308107210ULL, 0x000fe20007f1e0ffULL, 0x0000000109177824ULL, 0x000fc400008e060dULL,
0x00000080220a7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014377faeULL, 0x0003e6000b901c46ULL, 0x0000000109217824ULL, 0x000fe200010e060fULL,
0x000000300a337812ULL, 0x000fe200078ef802ULL, 0x00000080240c7825ULL, 0x000fc800078e00ffULL,
0x00000010121d7824ULL, 0x000fe200078e022aULL, 0x000000300c317812ULL, 0x000fe200078ef802ULL,
0x00000080260e7825ULL, 0x000fc600078e00ffULL, 0x00000031080c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008028127825ULL, 0x000fe200078e00ffULL, 0x000000300e2f7812ULL, 0x000fc600078ef802ULL,
0x0000000109117824ULL, 0x000fe200000e0611ULL, 0x00000030122d7812ULL, 0x000fe200078ef802ULL,
0x0000001005057824ULL, 0x000fe200078e022aULL, 0x00000033080a7210ULL, 0x040fe20007f1e0ffULL,
0x00000001090d7824ULL, 0x040fe200008e060dULL, 0x0000002f080e7210ULL, 0x040fe40007f5e0ffULL,
0x0000002d08087210ULL, 0x000fe20007f7e0ffULL, 0x00000001090b7824ULL, 0x040fe200000e060bULL,
0x0000000016057faeULL, 0x0003e2000b901c46ULL, 0x00000001090f7824ULL, 0x000fc400010e060fULL,
0x0000000109097824ULL, 0x000fe200018e0613ULL, 0x00000000201d7faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x000000000a257faeULL, 0x0003e8000b901c46ULL,
0x000000000c277faeULL, 0x0003e8000b901c46ULL, 0x000000000e297faeULL, 0x0003e8000b901c46ULL,
0x00000000082b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01260400ff057984ULL, 0x000e620000000800ULL,
0x0000006603037224ULL, 0x000fc400078e02ffULL, 0x000000011c1d7824ULL, 0x000fe400078e0a19ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x8000000005ff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620003027625ULL, 0x000fe200078e0035ULL, 0x00000008ff1d7819ULL, 0x000fe2000001161dULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e640000000000ULL,
0x000000201f057824ULL, 0x002fca00078e0206ULL, 0x00000004ff067819ULL, 0x000fe40000011605ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000001f05067812ULL, 0x000fc600078ec0ffULL, 0x00000001080a7824ULL, 0x040fe400078e0207ULL,
0x0000000105097824ULL, 0x000fe200078e0208ULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0x00000010060b7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000010060c7824ULL, 0x000fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x000fe200078e0208ULL, 0x000001f00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000000105057824ULL, 0x000fe200078e0208ULL, 0x000001f00c097812ULL, 0x000fe200078ee209ULL,
0x0000001006087824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x000000000a0c7984ULL, 0x000e62000000cc00ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fc400078ec0ffULL, 0x0000000009107984ULL, 0x000ea4000000cc00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x000001f008057812ULL, 0x000fe200078ee205ULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x004fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x0000001409007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fca00078e0013ULL, 0x000000200a007388ULL, 0x000fe8000000cc00ULL,
0x00000000070c7984ULL, 0x000e68000000cc00ULL, 0x0000000005107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x004fe400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002405007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x002fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011409ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000697919ULL, 0x000e620000000000ULL, 0x00006a00046b7a24ULL, 0x000fe200078e02ffULL,
0x3db504f368687820ULL, 0x010fe20000410000ULL, 0x0000000266667824ULL, 0x000fe200078e00ffULL,
0x000126881f6a7811ULL, 0x000fe200078e18ffULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0xffffffff196c7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x00000009196d7810ULL, 0x000fe40007ffe0ffULL, 0x000126081f6e7811ULL, 0x000fc400078e28ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff787224ULL, 0x000fe200078e0072ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x000000ffff6f7224ULL, 0x000fe200078e00ffULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x008fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x014fc4000001ff00ULL, 0x000000016f00780cULL, 0x040fe20003f25270ULL,
0x0000006518107224ULL, 0x030fe200078e02ffULL, 0x00000001700c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x000000016f0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000bc000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e006fULL,
0x0000000178727812ULL, 0x000fc400078e0cffULL, 0x000000020d00780cULL, 0x040fe20003f06070ULL,
0x000000ffff6f7224ULL, 0x000fe200078e000dULL, 0x000000ff0d0e7207ULL, 0x000fe40000800000ULL,
0x000000ffff0c1224ULL, 0x000fc800078e0270ULL, 0x000001000c587824ULL, 0x040fe200078e0267ULL,
0x000000010c0f7810ULL, 0x000fe20007ffe0ffULL, 0x00006400100c7625ULL, 0x000fc600078e0011ULL,
0x0000001a0f00720cULL, 0x000fe40003f46070ULL, 0x00000040580f7812ULL, 0x000fca00078ec0ffULL,
0x0000000164607824ULL, 0x000fcc00078e020fULL, 0x000005d00000a947ULL, 0x000fea0003800000ULL,
0x00000010690f7824ULL, 0x002fe200078e00ffULL, 0x00000002ff627819ULL, 0x000fe20000011669ULL,
0x000000021f5e7824ULL, 0x000fc600078e0272ULL, 0x000000300f117812ULL, 0x000fe200078ec0ffULL,
0x0000000162137824ULL, 0x140fe200078e0260ULL, 0x0000001862737810ULL, 0x040fe40007ffe0ffULL,
0x00000008625c7810ULL, 0x000fe20007ffe0ffULL, 0x000000400e107824ULL, 0x000fe200078e0211ULL,
0x000000581c0f7217ULL, 0x000fe20007800000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x00000010625d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000173597824ULL, 0x000fe200078e0260ULL,
0x0000002062757810ULL, 0x000fe20007ffe0ffULL, 0x0000008013127825ULL, 0x000fe200078e0010ULL,
0x000020005e5e7811ULL, 0x000fc400078e60ffULL, 0x0000002862767810ULL, 0x000fe20007ffe0ffULL,
0x000000015c557824ULL, 0x000fe200078e0260ULL, 0x000000120c5a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f0f7824ULL, 0x000fe200078e0a58ULL, 0x0000006969127211ULL, 0x000fe200078fe8ffULL,
0x0000008059587825ULL, 0x000fe200078e0010ULL, 0x0000003062777810ULL, 0x000fe40007ffe0ffULL,
0x0000000312747812ULL, 0x000fe200078ec0ffULL, 0x0000000160577824ULL, 0x000fe200078e025dULL,
0x0000000f7300720cULL, 0x000fe20003fa6070ULL, 0x0000008055547825ULL, 0x000fe200078e0010ULL,
0x0ffffffc745f7812ULL, 0x000fc600078ef869ULL, 0x000000010d5b7824ULL, 0x000fe200008e0613ULL,
0x000000580c587210ULL, 0x040fe20007f3e0ffULL, 0x0000000175137824ULL, 0x000fe200078e0260ULL,
0x000000540c547210ULL, 0x000fe20007f5e0ffULL, 0x0000008057567825ULL, 0x000fc800078e0010ULL,
0x0000008013127825ULL, 0x000fe200078e0010ULL, 0x000000560c567210ULL, 0x000fc60007f7e0ffULL,
0x000000010d597824ULL, 0x040fe200008e0659ULL, 0x0000000f6200720cULL, 0x080fe20003f26070ULL,
0x000000010d557824ULL, 0x000fe200010e0655ULL, 0x0000000f5c00720cULL, 0x0c0fe20003f46070ULL,
0x000000045c617824ULL, 0x000fe200078e00ffULL, 0x000000120c5c7210ULL, 0x000fe20007f9e0ffULL,
0x000000045d637824ULL, 0x000fe200078e00ffULL, 0x0000003862627810ULL, 0x000fe20007ffe0ffULL,
0x000000010d577824ULL, 0x000fe200018e0657ULL, 0x0000000f5d00720cULL, 0x080fe20003f66070ULL,
0x000000010d5d7824ULL, 0x000fe200020e0613ULL, 0xfffffffc61617812ULL, 0x000fe200078ee274ULL,
0x000000105f5f7824ULL, 0x000fe200078e025eULL, 0xfffffffc63637812ULL, 0x000fe200078ee274ULL,
0x0000000176137824ULL, 0x000fe200078e0260ULL, 0x0000000f7500720cULL, 0x080fe20003f86070ULL,
0x0000001061617824ULL, 0x000fe200078e025eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005a5f7faeULL, 0x0003e2000c901c46ULL, 0x0000008013127825ULL, 0x000fe200078e0010ULL,
0x0000000f6200720cULL, 0x000fc40003f26070ULL, 0x0000000054617faeULL, 0x0005e2000d101c46ULL,
0x0000001063637824ULL, 0x000fe200078e025eULL, 0x000000120c127210ULL, 0x000fe40007fde0ffULL,
0x0000000f7700720cULL, 0x0c0fe40003f46070ULL, 0x0000000056637faeULL, 0x0007e2000d901c46ULL,
0x0000000f7600720cULL, 0x000fe20003f66070ULL, 0x00000001775b7824ULL, 0x102fe400078e0260ULL,
0x00000001625f7824ULL, 0x000fc400078e0260ULL, 0x000000805b547825ULL, 0x004fc800078e0010ULL,
0x00000004730f7824ULL, 0x000fe400078e00ffULL, 0x0000000475577824ULL, 0x008fe400078e00ffULL,
0x000000805f107825ULL, 0x000fe200078e0010ULL, 0xfffffffc0f0f7812ULL, 0x100fe400078ee274ULL,
0xfffffffc57577812ULL, 0x000fe200078ee274ULL, 0x000000010d137824ULL, 0x000fe200030e0613ULL,
0x000000540c547210ULL, 0x000fe20007fde0ffULL, 0x00000004765b7824ULL, 0x000fc400078e00ffULL,
0x00000004775f7824ULL, 0x000fe400078e00ffULL, 0x0000000462617824ULL, 0x000fe200078e00ffULL,
0xfffffffc5b5b7812ULL, 0x100fe200078ee274ULL, 0x000000010d557824ULL, 0x000fe200030e0655ULL,
0xfffffffc5f5f7812ULL, 0x000fe200078ee274ULL, 0x000000100f0f7824ULL, 0x000fe200078e025eULL,
0xfffffffc61617812ULL, 0x000fe200078ee274ULL, 0x0000001057577824ULL, 0x100fe200078e025eULL,
0x000000100c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000105b5b7824ULL, 0x100fe200078e025eULL,
0x00000000580f7faeULL, 0x0003e2000e901c46ULL, 0x000000105f5f7824ULL, 0x000fc400078e025eULL,
0x0000001061617824ULL, 0x000fe200078e025eULL, 0x000000005c577faeULL, 0x0003e2000e101c46ULL,
0x000000010d0d7824ULL, 0x000fc600030e0611ULL, 0x00000000125b7faeULL, 0x0003e8000d901c46ULL,
0x00000000545f7faeULL, 0x0003e8000d101c46ULL, 0x000000000c617faeULL, 0x0003e2000c901c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x000000021f117824ULL, 0x000fe200078e0272ULL,
0x0000000869557811ULL, 0x042fe200078ff0ffULL, 0x00000010690f7824ULL, 0x040fe200078e00ffULL,
0x0000001069577811ULL, 0x000fc400078ff0ffULL, 0x0000001869597811ULL, 0x000fe200078ff0ffULL,
0x0000000155137824ULL, 0x100fe200078e0260ULL, 0x00000020695b7811ULL, 0x000fe200078ff0ffULL,
0x0000000457617824ULL, 0x000fe200078e00ffULL, 0x00000028695d7811ULL, 0x000fe200078ff0ffULL,
0x0000000459637824ULL, 0x000fe200078e00ffULL, 0x00002000117b7811ULL, 0x000fe200078e60ffULL,
0x0000000455117824ULL, 0x000fe200078e00ffULL, 0x00000030695f7811ULL, 0x000fe200078ff0ffULL,
0x0000000157557824ULL, 0x100fe200078e0260ULL, 0x0000003869797811ULL, 0x000fe200078ff0ffULL,
0x0000000159577824ULL, 0x100fe200078e0260ULL, 0x0000006969107211ULL, 0x000fe200078fe8ffULL,
0x000000015b597824ULL, 0x100fe200078e0260ULL, 0x000000300f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000045b737824ULL, 0x000fe200078e00ffULL, 0x0000000310107812ULL, 0x000fe200078ec0ffULL,
0x000000015d5b7824ULL, 0x000fc400078e0260ULL, 0x000000045d757824ULL, 0x000fe200078e00ffULL,
0xfffffffc11127812ULL, 0x000fe200078ee210ULL, 0x000000015f5d7824ULL, 0x000fe200078e0260ULL,
0xfffffffc61547812ULL, 0x100fe200078ee210ULL, 0x000000045f5f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc63567812ULL, 0x100fe200078ee210ULL, 0x0000000479777824ULL, 0x000fe200078e00ffULL,
0xfffffffc73587812ULL, 0x100fe200078ee210ULL, 0x000000400e5e7824ULL, 0x000fe200078e020fULL,
0xfffffffc755a7812ULL, 0x100fe200078ee210ULL, 0x00000010120f7824ULL, 0x100fe200078e027bULL,
0xfffffffc5f5c7812ULL, 0x100fe200078ee210ULL, 0x000000ffff5f7224ULL, 0x000fe200078e00ffULL,
0xfffffffc77627812ULL, 0x000fe200078ee210ULL, 0x0000001054617824ULL, 0x000fe200078e027bULL,
0x0ffffffc10107812ULL, 0x000fe200078ef869ULL, 0x0000008013127825ULL, 0x000fe200078e005eULL,
0x0000006069117211ULL, 0x000fc600078ff0ffULL, 0x00000010107d7824ULL, 0x000fe200078e027bULL,
0x000000120c127210ULL, 0x000fe20007f5e0ffULL, 0x0000008011107825ULL, 0x000fc800078e005eULL,
0x0000001056637824ULL, 0x000fe200078e027bULL, 0x000000100c107210ULL, 0x000fe20007f3e0ffULL,
0x0000008055547825ULL, 0x000fc800078e005eULL, 0x0000008057567825ULL, 0x000fe200078e005eULL,
0x000000540c547210ULL, 0x000fc60007f7e0ffULL, 0x0000000179797824ULL, 0x000fe200078e0260ULL,
0x000000560c567210ULL, 0x000fe20007f9e0ffULL, 0x0000001058737824ULL, 0x100fe400078e027bULL,
0x000000105a757824ULL, 0x000fe400078e027bULL, 0x0000008059587825ULL, 0x000fc800078e005eULL,
0x000000105c777824ULL, 0x000fe400078e027bULL, 0x000000805b5a7825ULL, 0x000fc800078e005eULL,
0x000000805d5c7825ULL, 0x000fc800078e005eULL, 0x00000080795e7825ULL, 0x000fc800078e005eULL,
0x000000010d117824ULL, 0x040fe200008e0611ULL, 0x000000580c587210ULL, 0x040fe20007f3e0ffULL,
0x000000010d137824ULL, 0x040fe200010e0613ULL, 0x0000005a0c5a7210ULL, 0x040fe20007f5e0ffULL,
0x000000010d557824ULL, 0x040fe200018e0655ULL, 0x0000005c0c5c7210ULL, 0x040fe20007f7e0ffULL,
0x000000010d577824ULL, 0x040fe200020e0657ULL, 0x0000005e0c0c7210ULL, 0x000fe20007f9e0ffULL,
0x000000010d597824ULL, 0x040fe200008e0659ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000107d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d5b7824ULL, 0x000fc400010e065bULL,
0x000000010d5d7824ULL, 0x040fe200018e065dULL, 0x00000000120f7faeULL, 0x0003e2000b901c46ULL,
0x00000010627b7824ULL, 0x000fe400078e027bULL, 0x000000010d0d7824ULL, 0x000fe200020e065fULL,
0x0000000054617faeULL, 0x0003e8000b901c46ULL, 0x0000000056637faeULL, 0x0003e8000b901c46ULL,
0x0000000058737faeULL, 0x0003e8000b901c46ULL, 0x000000005a757faeULL, 0x0003e8000b901c46ULL,
0x000000005c777faeULL, 0x0003e8000b901c46ULL, 0x000000000c7b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010e00780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000200007810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff187424ULL, 0x000fc600078e00ffULL,
0x0000001b0000720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000026b0c7824ULL, 0x002fe400078e0200ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000066000c0c7625ULL, 0x000fca00078e000dULL, 0x000000060c187981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008717b7824ULL, 0x002fe400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x00000010ff7a7424ULL, 0x000fe200078e00ffULL, 0x000000127b797810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff737224ULL, 0x000fe200078e00ffULL, 0x000000027b7b7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff8690e7812ULL, 0x000fe200078ec0ffULL,
0x000000021f607824ULL, 0x000fe200078e0278ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000869547812ULL, 0x000fc400078ec0ffULL, 0x000000070e0f7812ULL, 0x000fe400078ef869ULL,
0x0000200060607811ULL, 0x000fe400078e60ffULL, 0x00000001ff127819ULL, 0x020fe2000001160fULL,
0x000000040f0e7824ULL, 0x000fe200078e00ffULL, 0x0000000769107812ULL, 0x000fe200078ec0ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000173837810ULL, 0x000fe20007ffe0ffULL,
0x00000001120d7824ULL, 0x000fc800078e0273ULL, 0x0000000112127824ULL, 0x000fe200078e0283ULL,
0xfffffffc0e0d7812ULL, 0x000fe200078ee20dULL, 0x00000008710e7824ULL, 0x000fc600078e020cULL,
0xfffffffc0f0f7812ULL, 0x000fe200078ee212ULL, 0x000000100d5c7824ULL, 0x100fe200078e0260ULL,
0x00000054690d7211ULL, 0x000fe400078fe0ffULL, 0x0000000754547812ULL, 0x000fe200078ef869ULL,
0x000000100f0f7824ULL, 0x000fe400078e0260ULL, 0x000000005c5c783bULL, 0x000e620000000200ULL,
0x00000001100d7824ULL, 0x000fe200078e020dULL, 0x0000001054137812ULL, 0x040fe200078efcffULL,
0x0000000871107824ULL, 0x000fe200078e027aULL, 0x000000000f74783bULL, 0x000ea20000000200ULL,
0x000000010d0e7824ULL, 0x040fe200078e020eULL, 0x0000007b0d117210ULL, 0x040fe20007ffe00cULL,
0x000000010d107824ULL, 0x040fe200078e0210ULL, 0x000000790d0d7210ULL, 0x000fe20007ffe00cULL,
0x0000001054557824ULL, 0x040fe200078e00ffULL, 0x00000020690c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001054127824ULL, 0x000fc400078e00ffULL, 0x0000001013547824ULL, 0x040fe200078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000001013577824ULL, 0x000fe200078e00ffULL,
0xfffffff0550e7812ULL, 0x000fe400078ee20eULL, 0x000000070c617812ULL, 0x000fe400078ef869ULL,
0xfffffff012127812ULL, 0x000fe200078ee211ULL, 0x000000100e0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff054137812ULL, 0x000fe200078ee20dULL, 0x0000000461637824ULL, 0x000fe200078e00ffULL,
0x00000001ff627819ULL, 0x000fc40000011661ULL, 0x000000000e58783bULL, 0x0007e20000000200ULL,
0xfffffff057107812ULL, 0x000fe200078ee210ULL, 0x0000001013137824ULL, 0x000fc800078e00ffULL,
0x0000001010107824ULL, 0x000fca00078e00ffULL, 0x000000001054783bULL, 0x000fe20000000200ULL,
0x00000018ff0c7819ULL, 0x102fe4000001165fULL, 0x0000ffff5f0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000cff11723eULL, 0x000fe400020006ffULL, 0x00000010ff0c7819ULL, 0x000fe4000001165fULL,
0x00000008ff0d7819ULL, 0x000fe2000001160dULL, 0x20000011ff117230ULL, 0x000fe20000004100ULL,
0x000000ff0c0e7812ULL, 0x008fe200078ec0ffULL, 0x00000001620c7824ULL, 0x040fe200078e0273ULL,
0x00000018ff8e7819ULL, 0x000fe2000001165cULL, 0x0000000162627824ULL, 0x000fe200078e0283ULL,
0x0000000eff0f723eULL, 0x000fc400020006ffULL, 0x0000000dff0e723eULL, 0x000fe400020006ffULL,
0xfffffffc630d7812ULL, 0x000fe200078ee20cULL, 0x2000000fff0f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe2000001165cULL, 0x2000000eff0e7230ULL, 0x000fe20000004100ULL,
0x0000ffff5c977812ULL, 0x000fe200078ec0ffULL, 0x000000100d7c7824ULL, 0x000fe200078e0260ULL,
0x00000018ff8f7819ULL, 0x004fe20000011674ULL, 0x0000001012637824ULL, 0x000fe200078e00ffULL,
0x0000008eff95723eULL, 0x000fc400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL,
0x000000007c7c783bULL, 0x000e620000000200ULL, 0x000000ff8c8e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8c7819ULL, 0x000fe20000011697ULL, 0x20000095ff977230ULL, 0x000fe20000004100ULL,
0x0000008fffa2723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000008eff8f723eULL, 0x000fc400020006ffULL, 0x0000008cff8e723eULL, 0x000fe200020006ffULL,
0x2000005cff8c7230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x2000008fff957230ULL, 0x000fe20000004100ULL, 0x000000ff749a7812ULL, 0x000fe200078ec0ffULL,
0x200000a2ff5c7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x2000008eff8f7230ULL, 0x000fe20000004100ULL, 0x0000009affa2723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fe2000001168cULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff0e7819ULL, 0x000fe2000001160eULL, 0x200000a2ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff0c7819ULL, 0x000fc40000011611ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x000000001310783bULL, 0x000fe20000000200ULL, 0x00000010ff0f7819ULL, 0x000fe4000001160fULL,
0x000010540e807816ULL, 0x000fe4000000005fULL, 0x00000018ff827819ULL, 0x100fe40000011677ULL,
0x000000ff77837812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5f7819ULL, 0x000fc40000011677ULL,
0x0000ffff77777812ULL, 0x000fe400078ec0ffULL, 0x00000018ff987819ULL, 0x002fe4000001167cULL,
0x00000018ff9b7819ULL, 0x000fe4000001167dULL, 0x00000098ff9a723eULL, 0x000fe400020006ffULL,
0x00000010ff987819ULL, 0x000fe40000011697ULL, 0x00000010ff977819ULL, 0x000fe20000011695ULL,
0x2000009aff9a7230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fc4000001168fULL,
0x00001054988f7816ULL, 0x000fe40000000097ULL, 0x00001054958e7816ULL, 0x000fe4000000008eULL,
0x000000ff7c997812ULL, 0x000fe400078ec0ffULL, 0x0000009bff95723eULL, 0x000fe400020006ffULL,
0x000000ff7e9e7812ULL, 0x000fe200078ec0ffULL, 0x0000008e5814723cULL, 0x000fe20000041814ULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x20000095ffa37230ULL, 0x000fe20000004100ULL,
0x000000ff7d9c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001167eULL,
0x20000099ff977230ULL, 0x000fe20000004100ULL, 0x0000009eff98723eULL, 0x000fe200020006ffULL,
0x0000008e5438723cULL, 0x000be20000041838ULL, 0x00000018ff957819ULL, 0x000fe4000001165dULL,
0x0000ffff5d9e7812ULL, 0x040fe200078ec0ffULL, 0x20000098ff987230ULL, 0x000fe20000004100ULL,
0x000010540c817816ULL, 0x000fe4000000000fULL, 0x00000010ff8e7819ULL, 0x020fe2000001165dULL,
0x00000000630c783bULL, 0x0002a20000000200ULL, 0x000000ff5d8f7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5d7819ULL, 0x100fe2000001165eULL, 0x000000805804723cULL, 0x080f620000041804ULL,
0x0000009cff9b723eULL, 0x000fe400020006ffULL, 0x0000009dff99723eULL, 0x000fe400020006ffULL,
0x000000ff5f637812ULL, 0x002fe200078ec0ffULL, 0x2000009bff9b7230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fe20000011677ULL, 0x0000000461777824ULL, 0x000fe200078e00ffULL,
0x00000010ff9c7819ULL, 0x000fe2000001165eULL, 0x000000805408723cULL, 0x000b620000041808ULL,
0x000000ff5e9d7812ULL, 0x040fe200078ec0ffULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x0000ffff5ea47812ULL, 0x000fc400078ec0ffULL, 0x0000005dff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff5d7819ULL, 0x000fe4000001169eULL, 0x0000005fff61723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0xfffffffc775f7812ULL, 0x000fe200078ee262ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL,
0x000000105f607824ULL, 0x000fe200078e0260ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00000018ff9f7819ULL, 0x000fc4000001167fULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe400020006ffULL, 0x000000ff9c9e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff9c7819ULL, 0x000fe200000116a4ULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x0000009fffa2723eULL, 0x000fe200020006ffULL, 0x2000005eff9f7230ULL, 0x000fe20000004100ULL,
0x00000010ff817819ULL, 0x020fe20000011663ULL, 0x2000008eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fc40000011661ULL, 0x00000010ffa07819ULL, 0x000fe2000001167cULL,
0x000000006060783bULL, 0x000e620000000200ULL, 0x0000009dff9d723eULL, 0x000fe400020006ffULL,
0x0000009eff9e723eULL, 0x000fe400020006ffULL, 0x0000009cff9c723eULL, 0x000fe200020006ffULL,
0x2000009dff9d7230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x000fe2000001168fULL,
0x2000009eff9e7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x2000009cff9c7230ULL, 0x000fe20000004100ULL, 0x0000ffff7ca57812ULL, 0x000fc400078ec0ffULL,
0x000000ff7fa17812ULL, 0x000fe400078ec0ffULL, 0x000010545d8e7816ULL, 0x000fe4000000008eULL,
0x000000ffa0a07812ULL, 0x000fe400078ec0ffULL, 0x00000010ff947819ULL, 0x000fe4000001167dULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x00000008ff5d7819ULL, 0x000fe200000116a5ULL, 0x200000a2ffa57230ULL, 0x000fe20000004100ULL,
0x000000a1ffa4723eULL, 0x000fe400020006ffULL, 0x0000ffff7d967812ULL, 0x000fe400078ec0ffULL,
0x000000a0ffa1723eULL, 0x000fe200020006ffULL, 0x200000a4ffa47230ULL, 0x000fe20000004100ULL,
0x0000ffff7e927812ULL, 0x000fe400078ec0ffULL, 0x00001054958f7816ULL, 0x000fe2000000005eULL,
0x200000a1ffa17230ULL, 0x000fe20000004100ULL, 0x0000005dffa0723eULL, 0x000fc400020006ffULL,
0x000000ff94a27812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fe2000001169fULL,
0x200000a0ffa07230ULL, 0x000fe20000004100ULL, 0x00000010ff957819ULL, 0x000fe2000001169eULL,
0x0000008e5820723cULL, 0x000fe20000041820ULL, 0x00000010ff947819ULL, 0x000fe4000001169dULL,
0x00000010ff5d7819ULL, 0x000fe4000001169cULL, 0x00000010ff937819ULL, 0x000fc4000001167fULL,
0x00000008ff967819ULL, 0x000fe20000011696ULL, 0x0000008e543c723cULL, 0x000be2000004183cULL,
0x00000010ff917819ULL, 0x000fe4000001167eULL, 0x00000008ff927819ULL, 0x000fe40000011692ULL,
0x000010545e957816ULL, 0x000fe40000000095ULL, 0x000010545d947816ULL, 0x000fe40000000094ULL,
0x00000096ff96723eULL, 0x000fc400020006ffULL, 0x000000ff93937812ULL, 0x000fe400078ec0ffULL,
0x000000a2ffa2723eULL, 0x000fe200020006ffULL, 0x000000945824723cULL, 0x080f620000041824ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x200000a2ffa27230ULL, 0x000fe20000004100ULL,
0x0000ffff7f907812ULL, 0x000fe400078ec0ffULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x000000945440723cULL, 0x000b620000041840ULL, 0x00000083ff83723eULL, 0x000fc400020006ffULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x020fe20000011697ULL, 0x20000092ff947230ULL, 0x000fe20000004100ULL,
0x00000008ff927819ULL, 0x000fe20000011690ULL, 0x20000093ff9c7230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fe20000011696ULL, 0x20000091ff957230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc400000116a3ULL, 0x00000010ff5d7819ULL, 0x000fe400000116a0ULL,
0x00000010ff907819ULL, 0x000fe4000001169bULL, 0x00000010ff917819ULL, 0x000fe400000116a2ULL,
0x00000092ff96723eULL, 0x000fe400020006ffULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff837819ULL, 0x000fe20000011683ULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fc40000011676ULL, 0x0000ffff76897812ULL, 0x000fe400078ec0ffULL,
0x000010545d8e7816ULL, 0x000fe4000000008eULL, 0x000010545e917816ULL, 0x000fe40000000091ULL,
0x0000105493907816ULL, 0x000fe40000000090ULL, 0x00000010ff5e7819ULL, 0x000fe40000011699ULL,
0x00000010ff927819ULL, 0x000fc40000011698ULL, 0x00000010ff937819ULL, 0x000fe20000011695ULL,
0x00000090582c723cULL, 0x080fe2000004182cULL, 0x00000010ff5d7819ULL, 0x000fe40000011694ULL,
0x0000105482817816ULL, 0x000fe40000000081ULL, 0x0000105480807816ULL, 0x000fe40000000083ULL,
0x00000018ff8d7819ULL, 0x000fe20000011676ULL, 0x000000905448723cULL, 0x000fe20000041848ULL,
0x000000ff768b7812ULL, 0x000fc400078ec0ffULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x00000008ff897819ULL, 0x000fe40000011689ULL, 0x000010545e937816ULL, 0x000fe20000000093ULL,
0x000000800c04723cULL, 0x004fe20000041804ULL, 0x000010545d927816ULL, 0x000fe40000000092ULL,
0x00000010ff9a7819ULL, 0x000fe4000001169aULL, 0x00000010ff8f7819ULL, 0x000fc400000116a1ULL,
0x00000010ff5e7819ULL, 0x000fe200000116a5ULL, 0x000000801008723cULL, 0x000be20000041808ULL,
0x00000010ff947819ULL, 0x000fe400000116a4ULL, 0x00000010ff957819ULL, 0x000fe4000001169cULL,
0x00000010ff5d7819ULL, 0x000fe40000011696ULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x000000925830723cULL, 0x000fe20000041830ULL, 0x0000008bff8b723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x2000008dff967230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fe20000011674ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000ffff74877812ULL, 0x000fe200078ec0ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x100fe20000011675ULL, 0x00000092544c723cULL, 0x000fe2000004184cULL,
0x00000018ff777819ULL, 0x000fc40000011675ULL, 0x000000ff75747812ULL, 0x040fe400078ec0ffULL,
0x0000ffff757c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x102fe40000011660ULL,
0x00000018ff847819ULL, 0x000fe40000011660ULL, 0x000000ff60837812ULL, 0x040fe400078ec0ffULL,
0x0000ffff607e7812ULL, 0x000fc400078ec0ffULL, 0x000010549a8f7816ULL, 0x000fe4000000008fULL,
0x000010545e957816ULL, 0x000fe40000000095ULL, 0x000010545d947816ULL, 0x000fe40000000094ULL,
0x00000010ff7d7819ULL, 0x100fe20000011661ULL, 0x0000008e5828723cULL, 0x000f620000041828ULL,
0x00000018ff857819ULL, 0x000fe40000011661ULL, 0x000000ff61867812ULL, 0x000fc400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe40000011662ULL, 0x00000018ff817819ULL, 0x020fe20000011662ULL,
0x000000945834723cULL, 0x000f620000041834ULL, 0x000000ff62827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff757819ULL, 0x100fe40000011663ULL, 0x00000018ff807819ULL, 0x000fe40000011663ULL,
0x000000ff637f7812ULL, 0x000fe200078ec0ffULL, 0x0000008e5444723cULL, 0x000f620000041844ULL,
0x0000ffff61617812ULL, 0x000fc400078ec0ffULL, 0x0000ffff62627812ULL, 0x000fe400078ec0ffULL,
0x0000ffff63637812ULL, 0x000fe400078ec0ffULL, 0x00000008ff877819ULL, 0x000fe20000011687ULL,
0x000000945450723cULL, 0x000b620000041850ULL, 0x00000008ff7e7819ULL, 0x000fe4000001167eULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x000000ff76767812ULL, 0x000fe400078ec0ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000008ff627819ULL, 0x000fc40000011662ULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x00000008ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff967819ULL, 0x000fe40000011696ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff557819ULL, 0x020fe40000011688ULL, 0x00000010ff547819ULL, 0x000fc40000011689ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000105496557816ULL, 0x000fe20000000055ULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000105454547816ULL, 0x000fe2000000008bULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff8d7819ULL, 0x000fe2000001165cULL,
0x2000007fff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8c7819ULL, 0x000fc4000001168cULL,
0x00000010ff877819ULL, 0x000fe20000011687ULL, 0x000000540c24723cULL, 0x080f620000041824ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff587819ULL, 0x000fe20000011677ULL,
0x000000541040723cULL, 0x000b620000041840ULL, 0x00000010ff5b7819ULL, 0x000fc4000001165fULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff597819ULL, 0x000fe4000001167cULL,
0x00000010ff7f7819ULL, 0x000fe40000011684ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff547819ULL, 0x020fe40000011685ULL, 0x00000010ff7d7819ULL, 0x000fc4000001167dULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff557819ULL, 0x000fc40000011662ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff5d7819ULL, 0x000fe40000011675ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00001054878c7816ULL, 0x000fe4000000008cULL, 0x000010547e7e7816ULL, 0x000fc40000000083ULL,
0x000010548d8d7816ULL, 0x000fe4000000008aULL, 0x00001054585b7816ULL, 0x000fe4000000005bULL,
0x00001054595a7816ULL, 0x000fe40000000074ULL, 0x000010547f7f7816ULL, 0x000fe20000000076ULL,
0x0000008c0c14723cULL, 0x000f620000041814ULL, 0x0000105454877816ULL, 0x000fe4000000007dULL,
0x0000105461867816ULL, 0x000fc40000000086ULL, 0x0000105481837816ULL, 0x000fe40000000060ULL,
0x0000105455827816ULL, 0x000fe20000000082ULL, 0x0000005a0c20723cULL, 0x000f620000041820ULL,
0x00001054805d7816ULL, 0x000fe4000000005dULL, 0x00001054635c7816ULL, 0x000fe4000000005cULL,
0x0000000273737810ULL, 0x000fc60007ffe0ffULL, 0x0000007e0c28723cULL, 0x040f700000041828ULL,
0x000000860c2c723cULL, 0x040f70000004182cULL, 0x000000820c30723cULL, 0x040f700000041830ULL,
0x0000005c0c34723cULL, 0x000b6e0000041834ULL, 0x000000047a0d7810ULL, 0x060fe20007ffe0ffULL,
0x0000008c1038723cULL, 0x000b620000041838ULL, 0xfffffff47a0c7810ULL, 0x000fc40007ffe0ffULL,
0x000000180d00780cULL, 0x000fe20003f25270ULL, 0x000000ffff7a7224ULL, 0x000fc800078e000dULL,
0x0000005a103c723cULL, 0x040b70000004183cULL, 0x0000007e1044723cULL, 0x040b700000041844ULL,
0x000000861048723cULL, 0x040b700000041848ULL, 0x00000082104c723cULL, 0x040b70000004184cULL,
0x0000005c1050723cULL, 0x000b620000041850ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe5e000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff787224ULL, 0x000fe200078e0072ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd84000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000068145d7220ULL, 0x0a0fe20000410000ULL, 0x0000006825577220ULL, 0x080fe20000410000ULL,
0x000000682e2e7220ULL, 0x080fe20000410000ULL, 0x000000682f2f7220ULL, 0x080fe20000410000ULL,
0x0000006831317220ULL, 0x080fe20000410000ULL, 0x00000068045a7220ULL, 0x080fe20000410000ULL,
0x0000006805587220ULL, 0x080fe20000410000ULL, 0x0000006830307220ULL, 0x080fe20000410000ULL,
0x0000006832327220ULL, 0x080fe20000410000ULL, 0x0000006833337220ULL, 0x080fe20000410000ULL,
0x0000006834347220ULL, 0x080fe20000410000ULL, 0x0000006835357220ULL, 0x080fe20000410000ULL,
0x0000006836367220ULL, 0x080fe20000410000ULL, 0x0000006837377220ULL, 0x080fe20000410000ULL,
0x0000006838387220ULL, 0x080fe20000410000ULL, 0x0000006839397220ULL, 0x080fe20000410000ULL,
0x000000683d3d7220ULL, 0x080fe20000410000ULL, 0x000000680a147220ULL, 0x080fe20000410000ULL,
0x000000680b257220ULL, 0x080fe20000410000ULL, 0x0000006816167220ULL, 0x080fe20000410000ULL,
0x0000006817177220ULL, 0x080fe20000410000ULL, 0x00000068205c7220ULL, 0x080fe20000410000ULL,
0x0000006822227220ULL, 0x080fe20000410000ULL, 0x0000006823237220ULL, 0x080fe20000410000ULL,
0x0000006826267220ULL, 0x080fe20000410000ULL, 0x0000006827277220ULL, 0x080fe20000410000ULL,
0x0000006806067220ULL, 0x080fe20000410000ULL, 0x0000006807077220ULL, 0x080fe20000410000ULL,
0x000000682a2a7220ULL, 0x080fe20000410000ULL, 0x000000682b2b7220ULL, 0x080fe20000410000ULL,
0x000000682c2c7220ULL, 0x080fe20000410000ULL, 0x000000682d2d7220ULL, 0x080fe20000410000ULL,
0x000000683b117220ULL, 0x080fe20000410000ULL, 0x000000683c3c7220ULL, 0x080fe20000410000ULL,
0x0000006840047220ULL, 0x080fe20000410000ULL, 0x0000006841057220ULL, 0x080fe20000410000ULL,
0x0000006808087220ULL, 0x080fe20000410000ULL, 0x0000006809097220ULL, 0x080fe20000410000ULL,
0x00000068440a7220ULL, 0x080fe20000410000ULL, 0x00000068450b7220ULL, 0x080fe20000410000ULL,
0x00000068480c7220ULL, 0x080fe20000410000ULL, 0x00000068490d7220ULL, 0x080fe20000410000ULL,
0x000000684c0e7220ULL, 0x080fe20000410000ULL, 0x000000684a207220ULL, 0x080fe20000410000ULL,
0x00000068503b7220ULL, 0x080fe20000410000ULL, 0x0000006815557220ULL, 0x080fe20000410000ULL,
0x0000006821567220ULL, 0x080fe20000410000ULL, 0x00000068245b7220ULL, 0x080fe20000410000ULL,
0x0000006828597220ULL, 0x080fe20000410000ULL, 0x0000006829547220ULL, 0x080fe20000410000ULL,
0x000000683a107220ULL, 0x080fe20000410000ULL, 0x000000683e127220ULL, 0x080fe20000410000ULL,
0x000000683f137220ULL, 0x080fe20000410000ULL, 0x000000684e5e7220ULL, 0x080fe20000410000ULL,
0x000000684f5f7220ULL, 0x080fe20000410000ULL, 0x00000068510f7220ULL, 0x080fe20000410000ULL,
0x000000ffff507224ULL, 0x000fe200078e0031ULL, 0x0000006842297220ULL, 0x080fe20000410000ULL,
0x000000ffff487224ULL, 0x000fe200078e002eULL, 0x0000006843287220ULL, 0x080fe20000410000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e002fULL, 0x0000006846157220ULL, 0x080fe20000410000ULL,
0x0000006847247220ULL, 0x080fe20000410000ULL, 0x000000684b217220ULL, 0x080fe20000410000ULL,
0x000000684d3a7220ULL, 0x080fe20000410000ULL, 0x0000006852607220ULL, 0x080fe20000410000ULL,
0x0000006853617220ULL, 0x000fe20000410000ULL, 0x000000ffff517224ULL, 0x000fc400078e0030ULL,
0x000000ffff4f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff4e7224ULL, 0x000fe400078e0035ULL,
0x000000ffff497224ULL, 0x000fe400078e0032ULL, 0x000000ffff407224ULL, 0x000fe400078e0033ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0036ULL, 0x000000ffff3e7224ULL, 0x000fc400078e0037ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0038ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0039ULL,
0x000000ffff317224ULL, 0x000fe400078e003dULL, 0x000000ffff537224ULL, 0x000fe400078e002cULL,
0x000000ffff527224ULL, 0x000fe400078e002dULL, 0x000000ffff427224ULL, 0x000fc400078e0016ULL,
0x000000ffff4d7224ULL, 0x000fe400078e0017ULL, 0x000000ffff417224ULL, 0x000fe400078e0022ULL,
0x000000ffff447224ULL, 0x000fe400078e0023ULL, 0x000000ffff437224ULL, 0x000fe400078e0026ULL,
0x000000ffff4b7224ULL, 0x000fe400078e0027ULL, 0x000000ffff457224ULL, 0x000fc400078e0006ULL,
0x000000ffff477224ULL, 0x000fe400078e0007ULL, 0x000000ffff467224ULL, 0x000fe400078e002aULL,
0x000000ffff4c7224ULL, 0x000fe400078e002bULL, 0x000000ffff307224ULL, 0x000fe400078e003cULL,
0x000000ffff327224ULL, 0x000fe400078e0004ULL, 0x000000ffff337224ULL, 0x000fc400078e0005ULL,
0x000000ffff347224ULL, 0x000fe400078e0008ULL, 0x000000ffff357224ULL, 0x000fe400078e0009ULL,
0x000000ffff367224ULL, 0x000fe400078e000aULL, 0x000000ffff377224ULL, 0x000fe400078e000bULL,
0x000000ffff387224ULL, 0x000fe400078e000cULL, 0x000000ffff397224ULL, 0x000fc400078e000dULL,
0x000000ffff3d7224ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000006a087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff237224ULL, 0x000fe400078e0020ULL,
0x000000ffff227224ULL, 0x000fe400078e0021ULL, 0x000000ffff3c7224ULL, 0x000fe400078e000fULL,
0x000000ffff2c7224ULL, 0x000fe400078e0010ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0011ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0012ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0013ULL,
0x000000ffff277224ULL, 0x000fe400078e0014ULL, 0x000000ffff267224ULL, 0x000fe400078e0015ULL,
0x000000ffff217224ULL, 0x000fe400078e005eULL, 0x000000ffff207224ULL, 0x000fc400078e005fULL,
0x000000ffff177224ULL, 0x000fe400078e0060ULL, 0x000000ffff167224ULL, 0x000fc400078e0061ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004006a077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004006a077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000469157824ULL, 0x000fe200078e00ffULL,
0x0000001d7000720cULL, 0x000fc80003f06070ULL, 0xfffffff015147812ULL, 0x000fca00078ec0ffULL,
0x000000801f147824ULL, 0x000fca00078e0214ULL, 0x0124000014047984ULL, 0x0002a20000000c00ULL,
0x000021f000008947ULL, 0x000fea0003800000ULL, 0x00005a00000b7b06ULL, 0x000ee20000209000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x0000001e690a7211ULL, 0x040fe200078ff0ffULL,
0x00000002695f7824ULL, 0x000fe200078e00ffULL, 0x00005a00ff137a12ULL, 0x000fe400078e33ffULL,
0x000000100a0e7810ULL, 0x000fe40007ffe0ffULL, 0x000000065f5f7812ULL, 0x000fca00078ec0ffULL,
0x000000015f617824ULL, 0x000fe200078e0219ULL, 0x0000000b000b7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0b0d7810ULL, 0x008fcc0007ffe0ffULL, 0x0000000d00097305ULL, 0x000ee4000021f000ULL,
0x000000ffff0f7224ULL, 0x008fc800078e0a09ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f090f7227ULL, 0x000fe200078e0008ULL, 0x000000080a097810ULL, 0x000fca0007ffe0ffULL,
0x000000090f0c7227ULL, 0x000fc800078e00ffULL, 0x0000000a0f087227ULL, 0x000fc800078e00ffULL,
0x000000ffff127224ULL, 0x000fe400078e0a0cULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL,
0x00005a00120d7a24ULL, 0x000fe400078e0209ULL, 0x00005a000b0b7a24ULL, 0x000fe200078e020aULL,
0x000000180a0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000e0f107227ULL, 0x000fe200078e00ffULL,
0x00005a000d007a0cULL, 0x000fe40003fa6070ULL, 0x00005a000b007a0cULL, 0x000fe20003f06070ULL,
0x0000000a0f127227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a10ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a12ULL, 0x00005a00090e7a24ULL, 0x000fe400078e020eULL,
0x00005a000f0a7a24ULL, 0x000fe200078e020aULL, 0x80005a000d0d5a10ULL, 0x000fe20007ffe0ffULL,
0x0000010070097824ULL, 0x000fe200078e0267ULL, 0x00005a000e007a0cULL, 0x000fe40003f26070ULL,
0x80005a000b0b0a10ULL, 0x000fc40007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fe40003f66070ULL,
0x00005a000d007a0cULL, 0x000fe40003fc6070ULL, 0x000000091c5e7217ULL, 0x000fe40007800000ULL,
0x00005a000b007a0cULL, 0x000fe20003f46070ULL, 0x000000016d0b7824ULL, 0x000fe200078e025fULL,
0x000000010c0c5810ULL, 0x000fe20007ffe0ffULL, 0x000000015e5e7824ULL, 0x000fe200078e0a09ULL,
0x80005a000e0e1a10ULL, 0x000fc40007ffe0ffULL, 0x0000000108080810ULL, 0x000fe20007ffe0ffULL,
0x0000000161097824ULL, 0x100fe200078e0a5eULL, 0x0000005e0b00720cULL, 0x040fe20003f06070ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a5eULL, 0x80005a000a0a3a10ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x000000010c0c6810ULL, 0x000fe40007ffe0ffULL,
0x00005a000e007a0cULL, 0x000fc40003f86070ULL, 0x0000000108082810ULL, 0x000fe40007ffe0ffULL,
0x00005a000a007a0cULL, 0x000fe40003f46070ULL, 0x000000096c7d7217ULL, 0x040fe40003800000ULL,
0x0000000b6c0b7217ULL, 0x000fe40003800000ULL, 0x0000000c130d7207ULL, 0x040fe40006800000ULL,
0x0000000813097207ULL, 0x000fc40006800000ULL, 0x00000004ff0b7819ULL, 0x000fe4000001160bULL,
0x0000000d6c0f7217ULL, 0x040fe40003800000ULL, 0x000000096c097217ULL, 0x000fe40003800000ULL,
0x0000000110101810ULL, 0x000fe20007ffe0ffULL, 0x0000000f668c7224ULL, 0x040fe200078e02ffULL,
0x0000005e6100720cULL, 0x000fe20003fc6070ULL, 0x0000000966887224ULL, 0x000fe200078e02ffULL,
0x0000000112123810ULL, 0x000fc40007ffe0ffULL, 0x000000ff0b0d7207ULL, 0x000fe40000000000ULL,
0x0000000110104810ULL, 0x000fe40007ffe0ffULL, 0x000000ff7d7d7207ULL, 0x000fe20003000000ULL,
0x000000010d0f7824ULL, 0x000fe200078e028cULL, 0x0000000112122810ULL, 0x000fe20007ffe0ffULL,
0x00000001880b7824ULL, 0x000fe200078e020dULL, 0x0000001013117207ULL, 0x000fe20006800000ULL,
0x000000020f0e7825ULL, 0x000fe200078e0002ULL, 0x000000105f777812ULL, 0x000fc400078efcffULL,
0x000000887d097211ULL, 0x000fe200078fe0ffULL, 0x000000020b0a7825ULL, 0x000fe200078e0002ULL,
0x0000001213137207ULL, 0x000fe20006800000ULL, 0x000000060e627981ULL, 0x0046a2000c1e9500ULL,
0x000000116c117217ULL, 0x040fe20003800000ULL, 0x000000016d797824ULL, 0x000fe200078e0277ULL,
0x000000136c137217ULL, 0x000fe20003800000ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x000000060a607981ULL, 0x0002a6000c1e9500ULL, 0x00000011668e7224ULL, 0x040fe200078e02ffULL,
0x0000000608637981ULL, 0x0002a2000c1e9500ULL, 0x00000001790f7824ULL, 0x008fe200078e0a5eULL,
0x0000008c7d117211ULL, 0x040fe200078fe0ffULL, 0x0000001366907224ULL, 0x000fe200078e02ffULL,
0x0000008e7d137211ULL, 0x000fe200078fe0ffULL, 0x000000010d6f7824ULL, 0x040fe200078e028eULL,
0x0000000f6c0e7217ULL, 0x000fe20003800000ULL, 0x000000010d737824ULL, 0x000fc400078e0290ULL,
0x00000002110c7825ULL, 0x100fe200078e0002ULL, 0x000000907d717211ULL, 0x000fe400078fe0ffULL,
0x0000005e7900720cULL, 0x000fe20003f26070ULL, 0x000000026f107825ULL, 0x000fe200078e0002ULL,
0x00000004ff0e7819ULL, 0x000fe2000001160eULL, 0x000000060c6f7981ULL, 0x0006a4000c1e9500ULL,
0x00000002130a7825ULL, 0x002fc800078e0002ULL, 0x0000000271087825ULL, 0x000fe200078e0002ULL,
0x000000060a747981ULL, 0x0002a2000c1e9500ULL, 0x000000ff0e0d7207ULL, 0x008fe40000800000ULL,
0x0000000177757824ULL, 0x000fe200078e0219ULL, 0x0000000610717981ULL, 0x0006a6000c1e9500ULL,
0x00000001750f7824ULL, 0x040fe200078e0a5eULL, 0x0000000608767981ULL, 0x0006a2000c1e9500ULL,
0x00000001880b7824ULL, 0x002fe200078e020dULL, 0x0000005e7500720cULL, 0x000fe20003f06070ULL,
0x0000000273127825ULL, 0x000fe200078e0002ULL, 0x0000000f6c0f7217ULL, 0x000fc60003800000ULL,
0x000000020b0a7825ULL, 0x000fe200078e0002ULL, 0x000000ff0f827207ULL, 0x000fe20000000000ULL,
0x0000000612737981ULL, 0x0002a4000c1e9500ULL, 0x000000010d817824ULL, 0x040fe400078e0290ULL,
0x000000060a787981ULL, 0x0002a2000c1e9500ULL, 0x000000010d7b7824ULL, 0x000fe200078e028cULL,
0x0000008882097211ULL, 0x048fe400078fe0ffULL, 0x0000008c820f7211ULL, 0x000fc400078fe0ffULL,
0x0000008e82137211ULL, 0x002fe200078fe0ffULL, 0x00000002810a7825ULL, 0x000fe200078e0002ULL,
0x000000205f817812ULL, 0x000fc600078efcffULL, 0x000000027b7a7825ULL, 0x000fc800078e0002ULL,
0x000000010d117824ULL, 0x000fe200078e028eULL, 0x00000090827f7211ULL, 0x000fe200078fe0ffULL,
0x000000016d877824ULL, 0x000fe200078e0281ULL, 0x000000067a7a7981ULL, 0x0002e2000c1e9500ULL,
0x0000000209087825ULL, 0x000fc600078e0002ULL, 0x000000060a7e7981ULL, 0x0002e2000c1e9500ULL,
0x000000020f0c7825ULL, 0x000fc600078e0002ULL, 0x0000000608797981ULL, 0x0002e2000c1e9500ULL,
0x00000002130e7825ULL, 0x000fc600078e0002ULL, 0x000000060c7b7981ULL, 0x0022e2000c1e9500ULL,
0x0000000187137824ULL, 0x000fe400078e0a5eULL, 0x0000000181837824ULL, 0x000fc600078e0219ULL,
0x000000136c127217ULL, 0x040fe20003800000ULL, 0x0000000183137824ULL, 0x000fe200078e0a5eULL,
0x0000005e8700720cULL, 0x080fe40003f26070ULL, 0x00000004ff127819ULL, 0x000fe20000011612ULL,
0x0000000211107825ULL, 0x100fe200078e0002ULL, 0x0000005e8300720cULL, 0x000fe40003f06070ULL,
0x000000136c137217ULL, 0x000fe20003800000ULL, 0x000000027f087825ULL, 0x000fe200078e0002ULL,
0x000000ff120b7207ULL, 0x000fe20000800000ULL, 0x00000006107c7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff13977207ULL, 0x000fc60000000000ULL, 0x000000060e7f7981ULL, 0x0002e2000c1e9500ULL,
0x000000010b877824ULL, 0x000fc600078e028cULL, 0x0000000608857981ULL, 0x0002e4000c1e9500ULL,
0x0000008c97117211ULL, 0x002fe200078fe0ffULL, 0x0000000287867825ULL, 0x000fe200078e0002ULL,
0x00000090978b7211ULL, 0x000fc600078fe0ffULL, 0x0000000188097824ULL, 0x000fe200078e020bULL,
0x0000008897137211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x100fe200078e0002ULL,
0x0000000686867981ULL, 0x0002e6000c1e9500ULL, 0x0000000209087825ULL, 0x000fe200078e0002ULL,
0x0000008e970d7211ULL, 0x000fc800078fe0ffULL, 0x0000000608807981ULL, 0x0002e2000c1e9500ULL,
0x000000010b0f7824ULL, 0x000fc600078e028eULL, 0x0000000610877981ULL, 0x0022e2000c1e9500ULL,
0x0000000213127825ULL, 0x000fc800078e0002ULL, 0x000000028b087825ULL, 0x000fe200078e0002ULL,
0x000000305f8b7812ULL, 0x000fe200078efcffULL, 0x0000000612897981ULL, 0x0002e4000c1e9500ULL,
0x000000010b0b7824ULL, 0x000fe400078e0290ULL, 0x000000016d917824ULL, 0x000fe200078e028bULL,
0x0000000608d97981ULL, 0x0002e2000c1e9500ULL, 0x000000020f0e7825ULL, 0x000fc800078e0002ULL,
0x000000020d0c7825ULL, 0x100fe200078e0002ULL, 0x000000060e847981ULL, 0x0002e6000c1e9500ULL,
0x000000020b0a7825ULL, 0x000fe200078e0002ULL, 0x000000060c8f7981ULL, 0x0002e6000c1e9500ULL,
0x0000000191137824ULL, 0x002fe200078e0a5eULL, 0x000000060a987981ULL, 0x0002e2000c1e9500ULL,
0x000000018b8d7824ULL, 0x000fc600078e0219ULL, 0x000000136c127217ULL, 0x040fe20003800000ULL,
0x000000018d137824ULL, 0x000fe200078e0a5eULL, 0x0000005e9100720cULL, 0x080fe40003f26070ULL,
0x0000005e8d00720cULL, 0x000fe40003f06070ULL, 0x00000004ff127819ULL, 0x000fe40000011612ULL,
0x000000136c137217ULL, 0x000fe40003800000ULL, 0x000000ff12917207ULL, 0x000fc40000800000ULL,
0x000000ff139d7207ULL, 0x000fc60000000000ULL, 0x0000000188117824ULL, 0x000fe200078e0291ULL,
0x000000889d137211ULL, 0x000fe200078fe0ffULL, 0x00000001910d7824ULL, 0x000fe200078e028eULL,
0x0000008e9d0f7211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x000fc800078e0002ULL,
0x0000000213127825ULL, 0x100fe200078e0002ULL, 0x00000006108a7981ULL, 0x0002e6000c1e9500ULL,
0x000000020d0c7825ULL, 0x100fe200078e0002ULL, 0x0000000612bf7981ULL, 0x0002e6000c1e9500ULL,
0x000000020f0e7825ULL, 0x000fe200078e0002ULL, 0x000000060c967981ULL, 0x0002e4000c1e9500ULL,
0x0000008c9d0b7211ULL, 0x002fc400078fe0ffULL, 0x000000060ed77981ULL, 0x0002e2000c1e9500ULL,
0x0000000191097824ULL, 0x000fe400078e028cULL, 0x000000020b0a7825ULL, 0x000fc800078e0002ULL,
0x0000000209087825ULL, 0x000fe200078e0002ULL, 0x000000060ad57981ULL, 0x0002e2000c1e9500ULL,
0x000000909d117211ULL, 0x000fc600078fe0ffULL, 0x0000000608947981ULL, 0x0002e2000c1e9500ULL,
0x0000000191137824ULL, 0x000fe400078e0290ULL, 0x0000000211107825ULL, 0x000fc800078e0002ULL,
0x0000000213127825ULL, 0x000fe200078e0002ULL, 0x0000000610db7981ULL, 0x0002e8000c1e9500ULL,
0x00000006129a7981ULL, 0x0002e2000c1e9500ULL, 0xfffffff07d7d7812ULL, 0x000fe200078ec0ffULL,
0x00000001ffd37424ULL, 0x000fc800078e00ffULL, 0x000000015e087824ULL, 0x002fc800078e027dULL,
0x0000000161097824ULL, 0x000fe200078e0a08ULL, 0x000000015f917812ULL, 0x000fc800078efcffULL,
0x00000009d3097219ULL, 0x000fe200000006ffULL, 0x00000001910b7824ULL, 0x000fe200078e0219ULL,
0xfffffff0820d7812ULL, 0x000fc600078ec0ffULL, 0x000000010b0a7824ULL, 0x100fe200078e0a08ULL,
0x000000085f937812ULL, 0x040fe200078efcffULL, 0x000000015e0e7824ULL, 0x000fe200078e020dULL,
0x000000095f957812ULL, 0x000fe400078efcffULL, 0x0000000ad30d7219ULL, 0x000fe200000006ffULL,
0x00000001930f7824ULL, 0x100fe400078e0219ULL, 0x0000000195137824ULL, 0x000fe400078e0219ULL,
0x000000010f0c7824ULL, 0x000fc400078e0a08ULL, 0x0000000113087824ULL, 0x000fe200078e0a08ULL,
0x000000115f997812ULL, 0x000fe400078efcffULL, 0x0000000cd3117219ULL, 0x040fe400000006ffULL,
0x00000008d37d7219ULL, 0x000fe200000006ffULL, 0x00000001999b7824ULL, 0x000fe200078e0219ULL,
0xfffffff097977812ULL, 0x000fe200078ec0ffULL, 0x0000000175087824ULL, 0x100fe200078e0a0eULL,
0xfffffff09d9d7812ULL, 0x000fe200078ec0ffULL, 0x000000019b0a7824ULL, 0x000fe200078e0a0eULL,
0x000000185f9f7812ULL, 0x000fe200078efcffULL, 0x000000015e107824ULL, 0x000fe200078e0297ULL,
0x0000541063607816ULL, 0x004fc80000000060ULL, 0x0000006009ff7212ULL, 0x000fc800078ac0ffULL,
0x0000005e6100720cULL, 0x000fc80002fa1470ULL, 0x0000005e5f00720cULL, 0x000fe40002fa1070ULL,
0x000054106f627816ULL, 0x000fe40000000062ULL, 0xff8000005d5d7808ULL, 0x000fe40002800000ULL,
0x000000600dff7212ULL, 0x000fe4000782c0ffULL, 0x0000006209ff7212ULL, 0x080fe4000784c0ffULL,
0x000000620dff7212ULL, 0x000fc400078ac0ffULL, 0x0000541074747816ULL, 0x000fc80000000071ULL,
0x0000007409ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005e6100720cULL, 0x0c0fe40001741470ULL,
0x0000005e6100720cULL, 0x080fe40002781470ULL, 0x0000005e0b00720cULL, 0x0c0fe40000f21470ULL,
0x0000005e0b00720cULL, 0x080fe40002fa1470ULL, 0x0000005e5f00720cULL, 0x000fc40001741070ULL,
0x0000005e5f00720cULL, 0x080fe40002781070ULL, 0x0000005e9100720cULL, 0x0c0fe40000f21070ULL,
0x0000005e9100720cULL, 0x000fe40002fa1070ULL, 0x0000541076767816ULL, 0x000fe40000000073ULL,
0xff80000042427808ULL, 0x000fe40001000000ULL, 0xff8000002f2f7808ULL, 0x000fc40002000000ULL,
0xff80000055557808ULL, 0x000fe40000800000ULL, 0xff8000004d4d7808ULL, 0x000fe40002800000ULL,
0x0000006011ff7212ULL, 0x000fe4000786c0ffULL, 0x0000007609ff7212ULL, 0x000fe4000780c0ffULL,
0x000000740dff7212ULL, 0x040fe4000784c0ffULL, 0x000000760dff7212ULL, 0x000fc4000788c0ffULL,
0x000000627dff7212ULL, 0x000fe4000782c0ffULL, 0x0000007411ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005e6100720cULL, 0x080fe40000701470ULL, 0x0000005e0b00720cULL, 0x0c0fe40001741470ULL,
0x0000005e0b00720cULL, 0x080fe40002781470ULL, 0x0000005e0f00720cULL, 0x000fc40001f61470ULL,
0x0000005e0f00720cULL, 0x080fe40002fa1470ULL, 0x0000005e1300720cULL, 0x080fe20000f21470ULL,
0x000000015e8c7824ULL, 0x000fe200078e029dULL, 0x000000195fa57812ULL, 0x040fe400078efcffULL,
0x0000005e5f00720cULL, 0x080fe40000701070ULL, 0x0000005e9100720cULL, 0x0c0fe40001741070ULL,
0x0000005e9100720cULL, 0x000fc40002781070ULL, 0x0000005e9300720cULL, 0x0c0fe40001f61070ULL,
0x0000005e9300720cULL, 0x080fe40002fa1070ULL, 0x0000005e9500720cULL, 0x000fe40000f21070ULL,
0x00000008d3977219ULL, 0x040fe400000006ffULL, 0x0000000ad39d7219ULL, 0x000fe400000006ffULL,
0x0000541079787816ULL, 0x008fc40000000078ULL, 0x000054107b7a7816ULL, 0x000fe2000000007aULL,
0x000000019fa17824ULL, 0x100fe200078e0219ULL, 0xff8000002c2c7808ULL, 0x000fe20000000000ULL,
0x00000001a5a77824ULL, 0x000fe200078e0219ULL, 0xff8000002e2e7808ULL, 0x000fe40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff8000005c5c7808ULL, 0x000fe40001800000ULL,
0xff80000030307808ULL, 0x000fc40002800000ULL, 0xff80000044447808ULL, 0x000fe40000800000ULL,
0x0000006211ff7212ULL, 0x000fe4000780c0ffULL, 0x000000747dff7212ULL, 0x000fe4000784c0ffULL,
0x0000007611ff7212ULL, 0x080fe4000788c0ffULL, 0x000000767dff7212ULL, 0x000fe4000786c0ffULL,
0x000000789dff7212ULL, 0x000fc400078ac0ffULL, 0x0000007a97ff7212ULL, 0x000fe2000782c0ffULL,
0x00000001a10c7824ULL, 0x100fe200078e0a0eULL, 0x0000005e0f00720cULL, 0x080fe20000701470ULL,
0x00000001a70e7824ULL, 0x000fe200078e0a0eULL, 0x0000005e0f00720cULL, 0x080fe40002781470ULL,
0x0000005e1300720cULL, 0x0c0fe40001741470ULL, 0x0000005e1300720cULL, 0x080fe40001f61470ULL,
0x0000005e7500720cULL, 0x000fc40000f21470ULL, 0x0000005e9b00720cULL, 0x080fe40002fa1470ULL,
0x0000005e9300720cULL, 0x0c0fe40000701070ULL, 0x0000005e9300720cULL, 0x080fe40002781070ULL,
0x0000005e9500720cULL, 0x0c0fe40001741070ULL, 0x0000005e9500720cULL, 0x080fe40001f61070ULL,
0x0000005e7700720cULL, 0x000fc40000f21070ULL, 0x0000005e9900720cULL, 0x000fe40002fa1070ULL,
0x0000000cd3a37219ULL, 0x040fe400000006ffULL, 0x0000000ed3a97219ULL, 0x000fe400000006ffULL,
0x000054107f7c7816ULL, 0x000fe4000000007cULL, 0x00005410857e7816ULL, 0x000fe4000000007eULL,
0xff80000041417808ULL, 0x000fc40000000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000057577808ULL, 0x000fe40002800000ULL,
0x0000007897ff7212ULL, 0x000fc4000780c0ffULL, 0x00000078a3ff7212ULL, 0x000fe4000788c0ffULL,
0x0000007c97ff7212ULL, 0x040fe4000784c0ffULL, 0x0000007e97ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007c9dff7212ULL, 0x000fe4000782c0ffULL, 0x0000007aa9ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000183127824ULL, 0x000fe200078e0a10ULL, 0x0000005e7500720cULL, 0x000fc40000701470ULL,
0x0000005e7500720cULL, 0x0c0fe40001741470ULL, 0x0000005e7500720cULL, 0x080fe40001f61470ULL,
0x0000005e9b00720cULL, 0x080fe40000f21470ULL, 0x0000005ea100720cULL, 0x080fe40002781470ULL,
0x0000005ea700720cULL, 0x000fe40002fa1470ULL, 0x000000215fad7812ULL, 0x000fc400078efcffULL,
0x0000005e7700720cULL, 0x0c0fe40000701070ULL, 0x0000005e7700720cULL, 0x0c0fe40001741070ULL,
0x0000005e7700720cULL, 0x080fe40001f61070ULL, 0x0000005e9900720cULL, 0x080fe40000f21070ULL,
0x0000005e9f00720cULL, 0x080fe40002781070ULL, 0x0000005ea500720cULL, 0x000fc40002fa1070ULL,
0x00000012d3ab7219ULL, 0x000fe400000006ffULL, 0x0000541087867816ULL, 0x000fe20000000086ULL,
0x00000001adaf7824ULL, 0x000fe200078e0219ULL, 0xff8000005b5b7808ULL, 0x000fe40000000000ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fc40000800000ULL, 0xff8000005a5a7808ULL, 0x000fe40002000000ULL,
0xff80000047477808ULL, 0x000fe40002800000ULL, 0x0000007a9dff7212ULL, 0x040fe4000780c0ffULL,
0x0000007e9dff7212ULL, 0x000fe4000784c0ffULL, 0x0000007aa3ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007ca9ff7212ULL, 0x000fc4000782c0ffULL, 0x0000007ea9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000086abff7212ULL, 0x000fe200078ac0ffULL, 0x00000001af827824ULL, 0x000fe200078e0a10ULL,
0x0000005e9b00720cULL, 0x0c0fe40000701470ULL, 0x0000005e9b00720cULL, 0x080fe40001741470ULL,
0x0000005ea100720cULL, 0x080fe40001f61470ULL, 0x0000005ea700720cULL, 0x000fc40000f21470ULL,
0x0000005ea700720cULL, 0x080fe40002781470ULL, 0x0000005e8300720cULL, 0x080fe40002fa1470ULL,
0x000000285fb37812ULL, 0x040fe400078efcffULL, 0x000000295fb97812ULL, 0x000fe400078efcffULL,
0x0000005e9900720cULL, 0x0c0fe40000701070ULL, 0x0000005e9900720cULL, 0x000fc40001741070ULL,
0x0000005e9f00720cULL, 0x080fe40001f61070ULL, 0x0000005ea500720cULL, 0x0c0fe40000f21070ULL,
0x0000005ea500720cULL, 0x080fe40002781070ULL, 0x0000005e8100720cULL, 0x000fe40002fa1070ULL,
0x00000082d3b17219ULL, 0x000fe400000006ffULL, 0x0000541089807816ULL, 0x000fc40000000080ULL,
0x000054108f847816ULL, 0x000fe40000000084ULL, 0x00005410d9987816ULL, 0x000fe20000000098ULL,
0x00000001b3b57824ULL, 0x100fe200078e0219ULL, 0xff8000004b4b7808ULL, 0x000fe20000000000ULL,
0x00000001b9bb7824ULL, 0x000fe200078e0219ULL, 0xff80000028287808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40001800000ULL, 0xff80000035357808ULL, 0x000fc40000800000ULL,
0xff80000025257808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fe40002800000ULL,
0x000000607dff7212ULL, 0x000fe400078cc0ffULL, 0x0000007ca3ff7212ULL, 0x040fe4000780c0ffULL,
0x0000007ea3ff7212ULL, 0x000fe4000784c0ffULL, 0x00000080abff7212ULL, 0x000fc4000786c0ffULL,
0x00000084abff7212ULL, 0x040fe4000782c0ffULL, 0x00000098abff7212ULL, 0x000fe4000788c0ffULL,
0x00000084b1ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b5887824ULL, 0x100fe200078e0a10ULL,
0x0000005e1300720cULL, 0x080fe200037c1470ULL, 0x00000001bb107824ULL, 0x000fe200078e0a10ULL,
0x0000005ea100720cULL, 0x0c0fe40000701470ULL, 0x0000005ea100720cULL, 0x000fc40001741470ULL,
0x0000005e8300720cULL, 0x0c0fe40001f61470ULL, 0x0000005e8300720cULL, 0x0c0fe40000f21470ULL,
0x0000005e8300720cULL, 0x080fe40002781470ULL, 0x0000005eaf00720cULL, 0x080fe40002fa1470ULL,
0x0000005e9500720cULL, 0x080fe400037c1070ULL, 0x0000005e9f00720cULL, 0x000fc40000701070ULL,
0x0000005e9f00720cULL, 0x080fe40001741070ULL, 0x0000005e8100720cULL, 0x0c0fe40001f61070ULL,
0x0000005e8100720cULL, 0x0c0fe40000f21070ULL, 0x0000005e8100720cULL, 0x080fe40002781070ULL,
0x0000005ead00720cULL, 0x000fe40002fa1070ULL, 0x00000088d3b77219ULL, 0x000fc400000006ffULL,
0x00000010d3bd7219ULL, 0x000fe400000006ffULL, 0xff80000056567808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40000000000ULL, 0xff80000027277808ULL, 0x000fe40001000000ULL,
0xff80000059597808ULL, 0x000fe40001800000ULL, 0xff80000036367808ULL, 0x000fc40000800000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x00000078a9ff7212ULL, 0x000fe400078cc0ffULL, 0x00000080b1ff7212ULL, 0x080fe4000780c0ffULL,
0x00000080b7ff7212ULL, 0x000fe4000784c0ffULL, 0x00000086b1ff7212ULL, 0x000fc4000786c0ffULL,
0x00000098b1ff7212ULL, 0x000fe4000782c0ffULL, 0x00000086b7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084bdff7212ULL, 0x000fe200078ac0ffULL, 0x000000018d8e7824ULL, 0x000fe200078e0a8cULL,
0x0000005ea700720cULL, 0x080fe400037c1470ULL, 0x0000005eaf00720cULL, 0x0c0fe40000701470ULL,
0x0000005eaf00720cULL, 0x000fc40001f61470ULL, 0x0000005eaf00720cULL, 0x080fe40000f21470ULL,
0x0000005eb500720cULL, 0x0c0fe40001741470ULL, 0x0000005eb500720cULL, 0x080fe40002781470ULL,
0x0000005ebb00720cULL, 0x000fe40002fa1470ULL, 0x000000315fc37812ULL, 0x040fe400078efcffULL,
0x000000385fc97812ULL, 0x000fc400078efcffULL, 0x000000395fcf7812ULL, 0x000fe400078efcffULL,
0x0000005ea500720cULL, 0x080fe400037c1070ULL, 0x0000005ead00720cULL, 0x0c0fe40000701070ULL,
0x0000005ead00720cULL, 0x0c0fe40001f61070ULL, 0x0000005ead00720cULL, 0x080fe40000f21070ULL,
0x0000005eb300720cULL, 0x000fc40001741070ULL, 0x0000005eb300720cULL, 0x080fe40002781070ULL,
0x0000005eb900720cULL, 0x000fe40002fa1070ULL, 0x0000008ed3c17219ULL, 0x000fe400000006ffULL,
0x00005410bf8a7816ULL, 0x000fe4000000008aULL, 0x00005410d7967816ULL, 0x000fe20000000096ULL,
0x00000001c3c57824ULL, 0x100fe200078e0219ULL, 0xff80000058587808ULL, 0x000fe20003000000ULL,
0x00000001c9cb7824ULL, 0x100fe200078e0219ULL, 0xff80000054547808ULL, 0x000fe20000000000ULL,
0x00000001cfd17824ULL, 0x000fe200078e0219ULL, 0xff8000004c4c7808ULL, 0x000fc40001800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000053537808ULL, 0x000fe40001000000ULL,
0xff80000048487808ULL, 0x000fe40002000000ULL, 0xff80000039397808ULL, 0x000fe40002800000ULL,
0x00000080bdff7212ULL, 0x040fe400078cc0ffULL, 0x00000086bdff7212ULL, 0x000fc4000780c0ffULL,
0x00000084b7ff7212ULL, 0x040fe4000786c0ffULL, 0x00000098b7ff7212ULL, 0x080fe4000782c0ffULL,
0x00000098bdff7212ULL, 0x000fe4000784c0ffULL, 0x0000008ac1ff7212ULL, 0x040fe4000788c0ffULL,
0x00000096c1ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c5907824ULL, 0x100fe200078e0a8cULL,
0x0000005eb500720cULL, 0x080fe20001f61470ULL, 0x00000001cb927824ULL, 0x100fe200078e0a8cULL,
0x0000005eb500720cULL, 0x080fe20000f21470ULL, 0x00000001d18c7824ULL, 0x000fe200078e0a8cULL,
0x0000005ebb00720cULL, 0x000fc400037c1470ULL, 0x0000005ebb00720cULL, 0x0c0fe40000701470ULL,
0x0000005ebb00720cULL, 0x080fe40001741470ULL, 0x0000005e8d00720cULL, 0x0c0fe40002781470ULL,
0x0000005e8d00720cULL, 0x000fe40002fa1470ULL, 0x00000090d3c77219ULL, 0x040fe400000006ffULL,
0x00000092d3cd7219ULL, 0x000fc400000006ffULL, 0x0000005eb300720cULL, 0x0c0fe40001f61070ULL,
0x0000005eb300720cULL, 0x080fe40000f21070ULL, 0x0000005eb900720cULL, 0x0c0fe400037c1070ULL,
0x0000005eb900720cULL, 0x0c0fe40000701070ULL, 0x0000005eb900720cULL, 0x080fe40001741070ULL,
0x0000005e8b00720cULL, 0x000fc40002781070ULL, 0x0000005e8b00720cULL, 0x000fe40002fa1070ULL,
0x0000008cd3d37219ULL, 0x000fe400000006ffULL, 0x00005410d5947816ULL, 0x000fe40000000094ULL,
0xff80000038387808ULL, 0x000fe40001800000ULL, 0xff80000023237808ULL, 0x000fe40000800000ULL,
0xff80000052527808ULL, 0x000fc40003000000ULL, 0xff8000004a4a7808ULL, 0x000fe40000000000ULL,
0xff80000022227808ULL, 0x000fe40001000000ULL, 0xff80000051517808ULL, 0x000fe40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x0000008ac7ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008acdff7212ULL, 0x000fc4000782c0ffULL, 0x0000008ad3ff7212ULL, 0x000fe400078cc0ffULL,
0x00000094c1ff7212ULL, 0x080fe4000780c0ffULL, 0x00000094c7ff7212ULL, 0x080fe4000784c0ffULL,
0x00000094cdff7212ULL, 0x000fe4000788c0ffULL, 0x00000096c7ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005e8d00720cULL, 0x000fc40000701470ULL, 0x0000005ec500720cULL, 0x0c0fe40001f61470ULL,
0x0000005ec500720cULL, 0x0c0fe40001741470ULL, 0x0000005ec500720cULL, 0x080fe40002fa1470ULL,
0x0000005ecb00720cULL, 0x080fe40000f21470ULL, 0x0000005ed100720cULL, 0x080fe400037c1470ULL,
0x0000005ecb00720cULL, 0x000fc40002781470ULL, 0x0000005e8b00720cULL, 0x080fe40000701070ULL,
0x0000005ec300720cULL, 0x0c0fe40001f61070ULL, 0x0000005ec300720cULL, 0x0c0fe40001741070ULL,
0x0000005ec300720cULL, 0x080fe40002fa1070ULL, 0x0000005ec900720cULL, 0x080fe40000f21070ULL,
0x0000005ecf00720cULL, 0x000fc400037c1070ULL, 0x0000005ec900720cULL, 0x000fe40002781070ULL,
0x00005410db9a7816ULL, 0x000fe4000000009aULL, 0xff80000049497808ULL, 0x000fe40000000000ULL,
0xff80000050507808ULL, 0x000fe40001800000ULL, 0xff80000040407808ULL, 0x000fe40001000000ULL,
0xff8000003a3a7808ULL, 0x000fc40002800000ULL, 0xff8000004f4f7808ULL, 0x000fe40000800000ULL,
0xff8000004e4e7808ULL, 0x000fe40003000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002000000ULL,
0x00000094d3ff7212ULL, 0x000fe4000780c0ffULL, 0x00000096cdff7212ULL, 0x080fe4000786c0ffULL,
0x00000096d3ff7212ULL, 0x000fc4000784c0ffULL, 0x0000009ac1ff7212ULL, 0x080fe400078ac0ffULL,
0x0000009ac7ff7212ULL, 0x080fe4000782c0ffULL, 0x0000009acdff7212ULL, 0x080fe400078cc0ffULL,
0x0000009ad3ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005e8d00720cULL, 0x080fe40002fa1470ULL,
0x0000005ec500720cULL, 0x000fc40000f21470ULL, 0x0000005ecb00720cULL, 0x0c0fe40001f61470ULL,
0x0000005ecb00720cULL, 0x080fe400037c1470ULL, 0x0000005ed100720cULL, 0x0c0fe40000701470ULL,
0x0000005ed100720cULL, 0x0c0fe40001741470ULL, 0x0000005ed100720cULL, 0x080fe40002781470ULL,
0x0000005e8b00720cULL, 0x000fc40002fa1070ULL, 0x0000005ec300720cULL, 0x080fe40000f21070ULL,
0x0000005ecf00720cULL, 0x080fe40000701070ULL, 0x0000005ec900720cULL, 0x0c0fe40001f61070ULL,
0x0000005ec900720cULL, 0x080fe400037c1070ULL, 0x0000005ecf00720cULL, 0x0c0fe40001741070ULL,
0x0000005ecf00720cULL, 0x000fc40002781070ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001800000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0xff80000020207808ULL, 0x000fe40000800000ULL,
0xff80000017177808ULL, 0x000fc40003000000ULL, 0xff80000016167808ULL, 0x000fc40002000000ULL,
0x0000005d0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff107424ULL, 0x000fe200078e00ffULL,
0x000000420500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x0000002f0600720bULL, 0x000fe40003f5e000ULL, 0x0000002c0700720bULL, 0x000fe40003f7e000ULL,
0x000000045d047208ULL, 0x000fe40004000000ULL, 0x0000000542087208ULL, 0x000fc40004800000ULL,
0x000000062f057208ULL, 0x000fe40005000000ULL, 0x000000072c077208ULL, 0x000fe40005800000ULL,
0x000000550400720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fe40003f5e000ULL,
0x0000004d0800720bULL, 0x000fe40003f3e000ULL, 0x0000002a0700720bULL, 0x000fc40003f7e000ULL,
0x0000000455097208ULL, 0x000fe40004000000ULL, 0x000000052e057208ULL, 0x000fe40005000000ULL,
0x000000084d087208ULL, 0x000fe40004800000ULL, 0x000000072a047208ULL, 0x000fe40005800000ULL,
0x0000005c0900720bULL, 0x000fe40003f1e000ULL, 0x000000300500720bULL, 0x000fc40003f5e000ULL,
0x000000410800720bULL, 0x000fe40003f3e000ULL, 0x0000002b0400720bULL, 0x000fe40003f7e000ULL,
0x000000095c097208ULL, 0x000fe40004000000ULL, 0x0000000530067208ULL, 0x000fe40005000000ULL,
0x0000000841077208ULL, 0x000fe40004800000ULL, 0x000000042b047208ULL, 0x000fc40005800000ULL,
0x000000560900720bULL, 0x000fe40003f1e000ULL, 0x000000310600720bULL, 0x000fe40003f5e000ULL,
0x000000440700720bULL, 0x000fe40003f3e000ULL, 0x0000002d0400720bULL, 0x000fe40003f7e000ULL,
0x0000000956087208ULL, 0x000fe40004000000ULL, 0x0000000631057208ULL, 0x000fc40005000000ULL,
0x00000007440a7208ULL, 0x000fe40004800000ULL, 0x000000042d047208ULL, 0x000fe40005800000ULL,
0x0000005b0800720bULL, 0x000fe40003f1e000ULL, 0x000000320500720bULL, 0x000fe40003f5e000ULL,
0x000000430a00720bULL, 0x000fe40003f3e000ULL, 0x000000290400720bULL, 0x000fc40003f7e000ULL,
0x000000085b087208ULL, 0x000fe40004000000ULL, 0x0000000532067208ULL, 0x000fe40005000000ULL,
0x0000000a430a7208ULL, 0x000fe40004800000ULL, 0x0000000429057208ULL, 0x000fe40005800000ULL,
0x000000570800720bULL, 0x000fe40003f1e000ULL, 0x000000330600720bULL, 0x000fc40003f5e000ULL,
0x0000004b0a00720bULL, 0x000fe40003f3e000ULL, 0x000000280500720bULL, 0x000fe40003f7e000ULL,
0x0000000857077208ULL, 0x000fe40004000000ULL, 0x0000000633097208ULL, 0x000fe40005000000ULL,
0x0000000a4b0a7208ULL, 0x000fe40004800000ULL, 0x0000000528047208ULL, 0x000fc40005800000ULL,
0x0000005a0700720bULL, 0x000fe40003f1e000ULL, 0x000000340900720bULL, 0x000fe40003f5e000ULL,
0x000000450a00720bULL, 0x000fe40003f3e000ULL, 0x000000270400720bULL, 0x000fe40003f7e000ULL,
0x000000075a077208ULL, 0x000fe40004000000ULL, 0x0000000934067208ULL, 0x000fc40005000000ULL,
0x0000000a450a7208ULL, 0x000fe40004800000ULL, 0x0000000427047208ULL, 0x000fe40005800000ULL,
0x000000580700720bULL, 0x000fe40003f1e000ULL, 0x000000350600720bULL, 0x000fe40003f5e000ULL,
0x000000470a00720bULL, 0x000fe40003f3e000ULL, 0x000000250400720bULL, 0x000fc40003f7e000ULL,
0x0000000758087208ULL, 0x000fe40004000000ULL, 0x0000000635077208ULL, 0x000fe40005000000ULL,
0x0000000a47057208ULL, 0x000fe40004800000ULL, 0x0000000425097208ULL, 0x000fe40005800000ULL,
0x000000590800720bULL, 0x000fe40003f1e000ULL, 0x000000360700720bULL, 0x000fc40003f5e000ULL,
0x000000460500720bULL, 0x000fe40003f3e000ULL, 0x000000260900720bULL, 0x000fe40003f7e000ULL,
0x00000008590b7208ULL, 0x000fe40004000000ULL, 0x0000000736047208ULL, 0x000fe40005000000ULL,
0x0000000546057208ULL, 0x000fe40004800000ULL, 0x0000000926097208ULL, 0x000fc40005800000ULL,
0x000000540b00720bULL, 0x000fe40003f1e000ULL, 0x000000370400720bULL, 0x000fe40003f5e000ULL,
0x0000004c0500720bULL, 0x000fe40003f3e000ULL, 0x000000240900720bULL, 0x000fe40003f7e000ULL,
0x0000000b54067208ULL, 0x000fe40004000000ULL, 0x0000000437077208ULL, 0x000fc40005000000ULL,
0x000000054c057208ULL, 0x000fe40004800000ULL, 0x0000000924047208ULL, 0x000fe40005800000ULL,
0x000000530600720bULL, 0x000fe40003f1e000ULL, 0x000000380700720bULL, 0x000fe40003f5e000ULL,
0x000000480500720bULL, 0x000fe40003f3e000ULL, 0x000000230400720bULL, 0x000fc40003f7e000ULL,
0x0000000653097208ULL, 0x000fe40004000000ULL, 0x0000000738067208ULL, 0x000fe40005000000ULL,
0x0000000548057208ULL, 0x000fe40004800000ULL, 0x0000000423077208ULL, 0x000fe40005800000ULL,
0x000000520900720bULL, 0x000fe40003f1e000ULL, 0x0000004a0500720bULL, 0x000fc40003f3e000ULL,
0x000000390600720bULL, 0x000fe40003f5e000ULL, 0x000000220700720bULL, 0x000fe40003f7e000ULL,
0x0000000952047208ULL, 0x000fe40004000000ULL, 0x000000054a087208ULL, 0x000fe40004800000ULL,
0x0000000639067208ULL, 0x000fe40005000000ULL, 0x00000007220a7208ULL, 0x000fc40005800000ULL,
0x000000510400720bULL, 0x000fe40003f1e000ULL, 0x000000490800720bULL, 0x000fe40003f3e000ULL,
0x0000003d0600720bULL, 0x000fe40003f5e000ULL, 0x000000210a00720bULL, 0x000fe40003f7e000ULL,
0x0000000451057208ULL, 0x000fe40004000000ULL, 0x0000000849077208ULL, 0x000fc40004800000ULL,
0x000000063d097208ULL, 0x000fe40005000000ULL, 0x0000000a210b7208ULL, 0x000fe40005800000ULL,
0x000000500500720bULL, 0x000fe40003f1e000ULL, 0x000000400700720bULL, 0x000fe40003f3e000ULL,
0x0000003a0900720bULL, 0x000fe40003f5e000ULL, 0x000000200b00720bULL, 0x000fc40003f7e000ULL,
0x0000000550047208ULL, 0x000fe40004000000ULL, 0x0000000740067208ULL, 0x000fe40004800000ULL,
0x000000093a087208ULL, 0x000fe40005000000ULL, 0x0000000b200a7208ULL, 0x000fe40005800000ULL,
0x0000004f0400720bULL, 0x000fe40003f1e000ULL, 0x0000003f0600720bULL, 0x000fc40003f3e000ULL,
0x0000003b0800720bULL, 0x000fe40003f5e000ULL, 0x000000170a00720bULL, 0x000fe40003f7e000ULL,
0x000000044f057208ULL, 0x000fe40004000000ULL, 0x000000063f077208ULL, 0x000fe40004800000ULL,
0x000000083b097208ULL, 0x000fe40005000000ULL, 0x0000000a170b7208ULL, 0x000fc40005800000ULL,
0x0000004e0500720bULL, 0x000fe40003f1e000ULL, 0x0000003e0700720bULL, 0x000fe40003f3e000ULL,
0x0000003c0900720bULL, 0x000fe40003f5e000ULL, 0x000000160b00720bULL, 0x000fe40003f7e000ULL,
0x000000054e057208ULL, 0x000fe40004000000ULL, 0x000000073e0a7208ULL, 0x000fc40004800000ULL,
0x000000093c0e7208ULL, 0x000fe40005000000ULL, 0x0000000b160d7208ULL, 0x000fe20005800000ULL,
0x000020927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x000000040500720bULL, 0x008fc80003f1e000ULL, 0x00000005040f7208ULL, 0x000fe20004000000ULL,
0x000020b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f000a047f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e057f89ULL, 0x004ea800000e0000ULL, 0x0c401f000d067f89ULL, 0x000e6200000e0000ULL,
0x000000040a00720bULL, 0x008fc40003f1e000ULL, 0x000000050e00720bULL, 0x004fe40003f3e000ULL,
0x0000000a04077208ULL, 0x002fe40004000000ULL, 0x0000000e05087208ULL, 0x000fe20004800000ULL,
0x0c201f000f047f89ULL, 0x000e6200000e0000ULL, 0x000000060d00720bULL, 0x000fc60003f1e000ULL,
0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL, 0x0000000d060a7208ULL, 0x000fc60004000000ULL,
0x0c201f0008097f89ULL, 0x000ee800000e0000ULL, 0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL,
0x000000040f00720bULL, 0x002fe40003f1e000ULL, 0x0000000c0700720bULL, 0x004fe40003f3e000ULL,
0x0000000f04047208ULL, 0x000fc40004000000ULL, 0x000000090800720bULL, 0x008fe40003f5e000ULL,
0x000000070c057208ULL, 0x000fe40004800000ULL, 0x0000000809067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x00000002ff5e7819ULL, 0x000fe20000011669ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b5d5d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b5c5c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL,
0x0000005500097308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b5b5b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b59557823ULL, 0x102fe20000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4e4e7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x0000005a000e7308ULL, 0x000fe20000000800ULL, 0x000000085e5f7824ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL, 0x0000004100107308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b49417823ULL, 0x102fe20000010807ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3e3e7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL,
0x0000005d00087308ULL, 0x0002a20000000800ULL, 0x000000085e637824ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3c3c7823ULL, 0x000fe20000010807ULL,
0x0000000a0b077208ULL, 0x000fe20004000000ULL, 0x0000005c005c7308ULL, 0x000fe20000000800ULL,
0x000000035e0b7810ULL, 0x040fe20007ffe0ffULL, 0x000000085e5d7824ULL, 0x042fe200078e00ffULL,
0x000000015e0a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b075a7820ULL, 0x000fe20000410000ULL,
0x000000080908723eULL, 0x004fc400000010ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee20aULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001085aULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001085aULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001085aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001085aULL,
0x00000056000d7308ULL, 0x000e620000000800ULL, 0x000000025e0a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001085aULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001085aULL,
0x3fb8aa3b25257823ULL, 0x000fe2000001085aULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee20aULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001085aULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001085aULL,
0x0000004400117308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001085aULL,
0x3fb8aa3b23237823ULL, 0x000fe2000001085aULL, 0x0000000369ff7812ULL, 0x000fca000780c0ffULL,
0x0000003400497308ULL, 0x0007e20000000800ULL, 0x0000005c0d0a723eULL, 0x002fce00000010ffULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x000000085e347824ULL, 0x008fca00078e00ffULL,
0xfffffff834617812ULL, 0x000fe200078ee20bULL, 0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL,
0x0000004d004d7308ULL, 0x000e620000000800ULL, 0x00000010110b723eULL, 0x004fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x3f8000003434783eULL, 0x000fc800000010ffULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x000000ffff747224ULL, 0x100fe400078e0034ULL,
0x000000ffff757224ULL, 0x000fca00078e0034ULL, 0x0000004b00127308ULL, 0x000ea20000000800ULL,
0x000000424d09723eULL, 0x002fe200000010ffULL, 0x000000085e427824ULL, 0x000fcc00078e00ffULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000002a00137308ULL, 0x000e620000000800ULL,
0x00000043120d723eULL, 0x004fe200000010ffULL, 0x000000085e437824ULL, 0x000fca00078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee25eULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000002e002e7308ULL, 0x000ea20000000800ULL, 0x0000002c1311723eULL, 0x002fce00000010ffULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x0000002f2e10723eULL, 0x004fce00000010ffULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002d002a7308ULL, 0x000ea20000000800ULL, 0x000000303112723eULL, 0x002fce00000010ffULL,
0x0000004a004b7308ULL, 0x000ff00000000800ULL, 0x00000035004a7308ULL, 0x0003e20000000800ULL,
0x0000002b2a13723eULL, 0x004fe400000010ffULL, 0x000000065e2b7810ULL, 0x000fc40007ffe0ffULL,
0x000000055e2a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8424d7812ULL, 0x000fe200078ee22bULL,
0x00000058000f7308ULL, 0x000ea20000000800ULL, 0x000000ffff357224ULL, 0x002fe200078e0034ULL,
0x3fb8aa3b17427823ULL, 0x000fcc000001085aULL, 0x0000005b000c7308ULL, 0x000fe20000000800ULL,
0x00000034082c723cULL, 0x000f6e00000418ffULL, 0x0000005700577308ULL, 0x000e620000000800ULL,
0x0000000e0f0e723eULL, 0x004fce00000010ffULL, 0x0000004500457308ULL, 0x000ff00000000800ULL,
0x0000004700567308ULL, 0x000ea20000000800ULL, 0x0000000c570c723eULL, 0x002fe200000010ffULL,
0x000000085e577824ULL, 0x000fcc00078e00ffULL, 0x0000003200447308ULL, 0x0003f00000000800ULL,
0x0000003c005b7308ULL, 0x000fe20000000800ULL, 0x000000045e327810ULL, 0x002fe40007ffe0ffULL,
0x00000045560f723eULL, 0x004fe200000010ffULL, 0x000000085e457824ULL, 0x000fe200078e00ffULL,
0xfffffff863637812ULL, 0x000fc600078ee232ULL, 0x0000004c00597308ULL, 0x000fe20000000800ULL,
0xfffffff845457812ULL, 0x000fe200078ee22aULL, 0x000000740c2c723cULL, 0x020fe2000004182cULL,
0x000000494a2a723eULL, 0x000fe400000010ffULL, 0x000000105e497810ULL, 0x000fc60007ffe0ffULL,
0x0000003300477308ULL, 0x0003f00000000800ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000341030723cULL, 0x002f6e00000418ffULL, 0x00000025003c7308ULL, 0x0002b00000000800ULL,
0x0000003a004c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22257823ULL, 0x002fce000001085aULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x000000273c2b723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b203c7823ULL, 0x000fe2000001085aULL, 0x000000ffff207224ULL, 0x000fca00078e0034ULL,
0x00000028003a7308ULL, 0x0002b00000000800ULL, 0x0000003b00587308ULL, 0x0007e20000000800ULL,
0xffffffff5e287810ULL, 0x002fc80007ffe0ffULL, 0xfffffff857577812ULL, 0x000fe400078ee228ULL,
0x000000444728723eULL, 0x000fe200000010ffULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b213b7823ULL, 0x008fe2000001085aULL, 0x000000293a29723eULL, 0x004fe200000010ffULL,
0x000000ffff217224ULL, 0x000fe200078e0034ULL, 0x3fb8aa3b165a7823ULL, 0x000fe2000001085aULL,
0x000000085e477810ULL, 0x040fe40007ffe0ffULL, 0x000000185e5e7810ULL, 0x000fe20007ffe0ffULL,
0x0000005400547308ULL, 0x000e640000000800ULL, 0x000000202830723cULL, 0x020b620000041830ULL,
0x0000000847447824ULL, 0x000fca00078e00ffULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0xfffffff844477812ULL, 0x000fce00078ee247ULL, 0x0000005200527308ULL, 0x000ea20000000800ULL,
0x000000555420723eULL, 0x022fe200000010ffULL, 0x000000ffff547224ULL, 0x100fe400078e0034ULL,
0x000000ffff557224ULL, 0x000fc800078e0034ULL, 0x0000004600467308ULL, 0x000e700000000800ULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x000000535222723eULL, 0x004fe200000010ffULL,
0x000000085e537824ULL, 0x000fcc00078e00ffULL, 0x0000002600357308ULL, 0x0005e20000000800ULL,
0x000000465921723eULL, 0x002fce00000010ffULL, 0x00000024003a7308ULL, 0x000fe20000000800ULL,
0x0000000849267824ULL, 0x004fca00078e00ffULL, 0xfffffff826497812ULL, 0x000fe400078ee249ULL,
0x0000003600367308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000e700000000800ULL,
0x0000003800387308ULL, 0x000ff00000000800ULL, 0x0000003900397308ULL, 0x000ea20000000800ULL,
0x000000363724723eULL, 0x002fce00000010ffULL, 0x0000002300277308ULL, 0x0003f00000000800ULL,
0x0000002500167308ULL, 0x0006e20000000800ULL, 0x000000484b23723eULL, 0x002fe400000010ffULL,
0x000000383926723eULL, 0x004fc400000010ffULL, 0xfffffff8534b7812ULL, 0x000fc600078ee25eULL,
0x0000003f003f7308ULL, 0x000fe20000000800ULL, 0x000000353a25723eULL, 0x008fe200000010ffULL,
0x000000ffff357224ULL, 0x000fe200078e0034ULL, 0x00000054202c723cULL, 0x000f6a000004182cULL,
0x0000003e003e7308ULL, 0x000e620000000800ULL, 0x000000271627723eULL, 0x000fe400000010ffULL,
0x0000a0001f167811ULL, 0x000fca00078e60ffULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x000000342430723cULL, 0x000fe20000041830ULL, 0x0000001043437824ULL, 0x100fe400078e0216ULL,
0x000000105d5d7824ULL, 0x100fe400078e0216ULL, 0x000000105f5f7824ULL, 0x100fe400078e0216ULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x0000001061617824ULL, 0x100fe400078e0216ULL,
0x0000001063637824ULL, 0x000fc400078e0216ULL, 0x0000001045457824ULL, 0x100fe400078e0216ULL,
0x000000104d4d7824ULL, 0x100fe200078e0216ULL, 0x0000003b00177308ULL, 0x0003e20000000800ULL,
0x0000001057577824ULL, 0x100fe400078e0216ULL, 0x0000001047477824ULL, 0x100fe400078e0216ULL,
0x0000001049497824ULL, 0x100fe400078e0216ULL, 0x000000104b4b7824ULL, 0x000fe200078e0216ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x0000003f3e3b723eULL, 0x002fc400000010ffULL,
0x000000414039723eULL, 0x004fe400000010ffULL, 0x0000000c15407812ULL, 0x000fe400078ec0ffULL,
0x000000585b3e723eULL, 0x000fe200000010ffULL, 0x0000005000507308ULL, 0x000e640000000800ULL,
0x0000000143437824ULL, 0x000fe400078e0240ULL, 0x00000001405d7824ULL, 0x040fe400078e025dULL,
0x00000001405f7824ULL, 0x040fe200078e025fULL, 0x0000000843007388ULL, 0x0005e20000000800ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000000140617824ULL, 0x000fc400078e0261ULL,
0x0000000140637824ULL, 0x040fe200078e0263ULL, 0x0000000a5d007388ULL, 0x0007e20000000800ULL,
0x0000000140457824ULL, 0x040fe400078e0245ULL, 0x00000001404d7824ULL, 0x000fe200078e024dULL,
0x0000004e004e7308ULL, 0x000ee20000000800ULL, 0x000000515038723eULL, 0x002fe200000010ffULL,
0x0000000140577824ULL, 0x040fe200078e0257ULL, 0x0000000c5f007388ULL, 0x0003e20000000800ULL,
0x0000000140087824ULL, 0x044fe400078e0247ULL, 0x0000000140497824ULL, 0x040fe200078e0249ULL,
0x0000000e61007388ULL, 0x0003e20000000800ULL, 0x0000003d003d7308ULL, 0x000ea20000000800ULL,
0x0000000140407824ULL, 0x000fc400078e024bULL, 0x0000002063007388ULL, 0x0003e80000000800ULL,
0x0000002245007388ULL, 0x0003e20000000800ULL, 0x0000003c00367308ULL, 0x0004620000000800ULL,
0x0000004f4e3a723eULL, 0x008fe400000010ffULL, 0x000000384d007388ULL, 0x0007e80000000800ULL,
0x0000003a57007388ULL, 0x0007e20000000800ULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x0000003d4c3c723eULL, 0x004fe200000010ffULL, 0x00000034382c723cULL, 0x020f62000004182cULL,
0x0000000908007388ULL, 0x0007e80000000800ULL, 0x0004000b5d007388ULL, 0x0007e20000000800ULL,
0x0000005a003f7308ULL, 0x000ea20000000800ULL, 0x00000017363d723eULL, 0x002fc400000010ffULL,
0x0004000d5f007388ULL, 0x0007e80000000800ULL, 0x0004000f61007388ULL, 0x0007e80000000800ULL,
0x0004002163007388ULL, 0x0007e80000000800ULL, 0x0004002345007388ULL, 0x0007e20000000800ULL,
0x000000423f3f723eULL, 0x004fc400000010ffULL, 0x000000ffff2d7224ULL, 0x020fe200078e002eULL,
0x000400394d007388ULL, 0x0007e80000000800ULL, 0x000000343c30723cULL, 0x000f620000041830ULL,
0x0004003b57007388ULL, 0x0007e80000000800ULL, 0x0000001049007388ULL, 0x0007e80000000800ULL,
0x000800125d007388ULL, 0x0007e80000000800ULL, 0x000800285f007388ULL, 0x0007e80000000800ULL,
0x0008002a61007388ULL, 0x0007e80000000800ULL, 0x0008002463007388ULL, 0x0007e60000000800ULL,
0x000000ffff2e7224ULL, 0x020fe200078e0030ULL, 0x0008002645007388ULL, 0x0007e20000000800ULL,
0x000000ffff2f7224ULL, 0x000fc600078e0032ULL, 0x0008003c4d007388ULL, 0x0007e80000000800ULL,
0x0008003e57007388ULL, 0x0007e80000000800ULL, 0x0000001140007388ULL, 0x0007e80000000800ULL,
0x000c00135d007388ULL, 0x0007e80000000800ULL, 0x000c00295f007388ULL, 0x0007e80000000800ULL,
0x000c002b61007388ULL, 0x0007e80000000800ULL, 0x000c002563007388ULL, 0x0007e80000000800ULL,
0x000c002745007388ULL, 0x0007e80000000800ULL, 0x000c003d4d007388ULL, 0x0007e80000000800ULL,
0x000c003f57007388ULL, 0x0007e80000000800ULL, 0x0120000414008388ULL, 0x0007e80000000c00ULL,
0x0122002c14008388ULL, 0x0007e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000006eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008006eff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010006eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000170707810ULL, 0x000fe20007ffe0ffULL, 0x000018006eff7f8cULL, 0x0003e6000c80043fULL,
0x0000001a7000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff8d3000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff287807ULL, 0x008fe40004000000ULL, 0x000195d000297802ULL, 0x000fc40000000f00ULL,
0x0000109000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0028ULL,
0xfffe966000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x0001962000297802ULL, 0x000fc40000000f00ULL, 0x0000104000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0xfffe96c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001967000287802ULL, 0x000fc40000000f00ULL,
0x00000fa000007944ULL, 0x014fea0003c00000ULL, 0xfffe979000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x000196b000287802ULL, 0x000fc40000000f00ULL,
0x00000f6000007944ULL, 0x016fea0003c00000ULL, 0xfffe98c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x000196f000287802ULL, 0x000fc40000000f00ULL,
0x00000f2000007944ULL, 0x01efea0003c00000ULL, 0xfffe99f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0002ULL, 0x0001973000287802ULL, 0x000fc40000000f00ULL,
0x00000ee000007944ULL, 0x01efea0003c00000ULL, 0xfffe9b1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001978000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0003ULL, 0x00000e9000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffe9f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x000197d000287802ULL, 0x000fc40000000f00ULL,
0x00000e4000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001003297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001982000287802ULL, 0x000fc40000000f00ULL, 0x00000df000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffe9ee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001987000287802ULL, 0x000fc40000000f00ULL,
0x00000da000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffe9ec000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x008fe40004000000ULL,
0x000198c000297802ULL, 0x000fc40000000f00ULL, 0x00000da000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0028ULL, 0xfffec84000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x0001991000297802ULL, 0x000fc40000000f00ULL,
0x00000d5000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0028ULL,
0xfffec88000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001996000287802ULL, 0x000fc40000000f00ULL, 0x00000cb000007944ULL, 0x004fea0003c00000ULL,
0xfffec96000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x000199a000287802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x006fea0003c00000ULL,
0xfffeca9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x000199e000287802ULL, 0x000fc40000000f00ULL, 0x00000c3000007944ULL, 0x00efea0003c00000ULL,
0xfffecbc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x00019a2000287802ULL, 0x000fc40000000f00ULL, 0x00000bf000007944ULL, 0x00efea0003c00000ULL,
0xfffecce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00019a7000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0025ULL,
0x00000ba000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffed10000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00019ac000287802ULL, 0x000fc40000000f00ULL, 0x00000b5000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001025297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00019b1000287802ULL, 0x000fc40000000f00ULL,
0x00000b0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffed0b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00019b6000287802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffed09000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe40004000000ULL, 0x00019bb000297802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0028ULL,
0xfffef7e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x00019c0000297802ULL, 0x000fc40000000f00ULL, 0x00000a6000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff227224ULL, 0x000fe200078e0028ULL, 0xfffef83000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x00019c5000287802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x018fea0003c00000ULL, 0xfffef91000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x00019c9000287802ULL, 0x000fc40000000f00ULL,
0x0000098000007944ULL, 0x01afea0003c00000ULL, 0xfffefa4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x00019cd000287802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x01afea0003c00000ULL, 0xfffefb7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x00019d1000287802ULL, 0x000fc40000000f00ULL,
0x0000090000007944ULL, 0x01afea0003c00000ULL, 0xfffefc9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00019d6000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0023ULL, 0x000008b000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xffff009000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00019db000287802ULL, 0x000fc40000000f00ULL,
0x0000086000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001023297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00019e0000287802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xffff004000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00019e5000287802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xffff002000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe40004000000ULL,
0x00019ea000297802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0028ULL, 0xffff274000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x00019ef000297802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xffff279000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x00019f4000287802ULL, 0x000fc40000000f00ULL, 0x000006d000007944ULL, 0x018fea0003c00000ULL,
0xffff286000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x00019f8000287802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x01afea0003c00000ULL,
0xffff299000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x00019fc000287802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x01afea0003c00000ULL,
0xffff2ac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000aULL,
0x0001a00000287802ULL, 0x000fc40000000f00ULL, 0x0000061000007944ULL, 0x01afea0003c00000ULL,
0xffff2be000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x0001a05000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0006ULL,
0x000005c000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xffff300000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x0001a0a000287802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001006297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001a0f000287802ULL, 0x000fc40000000f00ULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xffff2fb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x0001a14000287802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xffff2f9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x0001a1a000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000bULL, 0xffffdf2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x0001a20000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x014fea0003c00000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x0001a26000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000a0b067208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000dULL,
0x0001a2c000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000fULL,
0x0001a32000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000d0b0a7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001a38000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000f0b047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x0001a3e000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000060b057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x0001a44000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffddf000007947ULL, 0x000fea000383ffffULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff21ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000021027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe5a3002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000001100007348ULL, 0x000fe80003800000ULL, 0x0c00000c070b7389ULL, 0x0002a200000e0010ULL,
0xfffe59f008007950ULL, 0x000fea0003c3ffffULL, 0x0000008200007348ULL, 0x000fe80003800000ULL,
0x000000292a297389ULL, 0x0002a200000e0083ULL, 0x00000000ff2b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff2a7224ULL, 0x002fc800078e0028ULL, 0xfffe59a02a007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f65070ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0029ULL,
0x0000008100007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fce00078e00ffULL,
0x0000000000287806ULL, 0x000fc800058e0100ULL, 0x0000008128287212ULL, 0x000fe200078ec0ffULL,
0xfffe59302a007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000338ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c70ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d30ULL,
0x00000000000008acULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001680ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001684ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001a780ULL, 0xde00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c000ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c040ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c3c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001a980ULL,
0x000000000001a980ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c3c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_32_sm_89_cubin_len = 115872;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
