/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017048ULL, 0x0000000000016cc8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x0000000000015620ULL, 0x0000000000000260ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000015880ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001562000000000ULL, 0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001562000000000ULL, 0x0000026000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x000823040000007fULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000039000942804ULL, 0x000009f0000004b0ULL, 0x00002b5000002ad0ULL, 0x00002d6000002c20ULL,
0x000032b0000032a0ULL, 0x000056d000005670ULL, 0x00005910000057d0ULL, 0x00005d2000005d10ULL,
0x0000806000008000ULL, 0x000082a000008160ULL, 0x000086b0000086a0ULL, 0x0000aa400000a9e0ULL,
0x0000ac800000ab40ULL, 0x0000b1900000b180ULL, 0x0000caf00000cae0ULL, 0x00014ab000014a00ULL,
0x00014d2000014c90ULL, 0x0001504000014fe0ULL, 0x00015350000151c0ULL, 0x0000053004303904ULL,
0x00017600000000ffULL, 0x0000061000040100ULL, 0x0001760800000006ULL, 0x00000720003f0100ULL,
0x0001768800000006ULL, 0x00000860003f0100ULL, 0x000176a800000002ULL, 0x00000960003f0100ULL,
0x000176c800000004ULL, 0x000010b0003f0100ULL, 0x00017600000000ffULL, 0x0000123000080107ULL,
0x0001768800000003ULL, 0x00001b20003f0101ULL, 0x00000000000000ffULL, 0x00001b5000040107ULL,
0x00000000000000ffULL, 0x00001bd000040101ULL, 0x0000002000000002ULL, 0x00001d20003f0101ULL,
0x000176c800000017ULL, 0x00001eb000080109ULL, 0x000176c800000035ULL, 0x00002780003f0109ULL,
0x000176b000000034ULL, 0x0000285000080107ULL, 0x000176b000000058ULL, 0x00002860003f0101ULL,
0x000176080000004dULL, 0x00002880003f0101ULL, 0x000176080000004dULL, 0x000029f0003f0109ULL,
0x000176080000004dULL, 0x00002f20003f0109ULL, 0x000176a80000003cULL, 0x000030a000080109ULL,
0x000176a800000036ULL, 0x00004a20003f0109ULL, 0x000176c800000036ULL, 0x00004a40003f0101ULL,
0x0001768800000053ULL, 0x00004a7000080101ULL, 0x0000000000000046ULL, 0x00004be0003f0109ULL,
0x0000000000000046ULL, 0x000053d0003f0109ULL, 0x000176a800000014ULL, 0x0000542000080107ULL,
0x000176a800000054ULL, 0x00005430003f0101ULL, 0x000176280000004dULL, 0x00005450003f0101ULL,
0x000176280000004dULL, 0x000055c0003f0109ULL, 0x000176280000004dULL, 0x00005ae0003f0109ULL,
0x000176b000000017ULL, 0x00005c6000080109ULL, 0x000176b000000037ULL, 0x000073b0003f0109ULL,
0x000176c800000036ULL, 0x000073c0003f0101ULL, 0x000176900000003cULL, 0x000073f000080101ULL,
0x0000000000000046ULL, 0x00007560003f0109ULL, 0x0000000000000046ULL, 0x00007cf0003f0109ULL,
0x00000008000000ffULL, 0x00007db000040107ULL, 0x0000000800000056ULL, 0x00007dc0003f0101ULL,
0x000176480000004dULL, 0x00007de0003f0101ULL, 0x000176480000004dULL, 0x00007f50003f0109ULL,
0x000176480000004dULL, 0x00008470003f0109ULL, 0x000176a800000017ULL, 0x000085f000080109ULL,
0x000176a800000037ULL, 0x00009db0003f0109ULL, 0x000176c800000034ULL, 0x00009dd0003f0101ULL,
0x0001769800000036ULL, 0x00009e00003f0101ULL, 0x0000000000000046ULL, 0x00009f70003f0109ULL,
0x0000000000000046ULL, 0x0000a760003f0109ULL, 0x00000000000000ffULL, 0x0000a7b000040107ULL,
0x000176a80000004aULL, 0x0000a7c0003f0101ULL, 0x0001766800000006ULL, 0x0000a7e0003f0101ULL,
0x0001766800000006ULL, 0x0000a950003f0109ULL, 0x0001766800000006ULL, 0x0000ae40003f0109ULL,
0x000176b00000003dULL, 0x0000b000003f0109ULL, 0x000176b00000003dULL, 0x0000c800003f0109ULL,
0x000176a800000014ULL, 0x0000c900003f0101ULL, 0x000176a000000014ULL, 0x0000dc50003f0101ULL,
0x00017600000000ffULL, 0x0000f60000080101ULL, 0x00017600000000ffULL, 0x0000f7c000080109ULL,
0x00017600000000ffULL, 0x0000f9a000080109ULL, 0x00017600000000ffULL, 0x0000f9c000080101ULL,
0x00017600000000ffULL, 0x0000fb3000080109ULL, 0x00017600000000ffULL, 0x00012ed000080109ULL,
0x000176880000000aULL, 0x000130a0003f0101ULL, 0x000176880000000aULL, 0x00013210003f0109ULL,
0x000176880000000aULL, 0x000155c0003f0109ULL, 0x0001760800000042ULL, 0x000155d0003f0101ULL,
0x0001761000000042ULL, 0x000155e0003f0101ULL, 0x0001761800000042ULL, 0x000155f0003f0101ULL,
0x0001762000000042ULL, 0x00053803003f0101ULL, 0x0000d36000201c04ULL, 0x0000d6500000d390ULL,
0x0000da400000d840ULL, 0x0000fb600000dbf0ULL, 0x000c050400015610ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0068190300000000ULL, 0x0000001800080a04ULL, 0x0000000000680210ULL,
0x00000000000000bcULL, 0x0000001700000002ULL, 0x0000000000015620ULL, 0x0000000000000044ULL,
0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000147919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff007b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000114052836ULL, 0x008fe40000000000ULL, 0x0000000414082825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x0000000608082981ULL, 0x0004e8000c1e1900ULL,
0x0000000602072981ULL, 0x000ae2000c1e1900ULL, 0x0000000000067306ULL, 0x010f220000209000ULL,
0x00000400ff0a7b82ULL, 0x000f620000000800ULL, 0x000000ff0000720cULL, 0x000fe20003f65070ULL,
0x00000000000c7919ULL, 0x000f620000002200ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x0000000000097919ULL, 0x004ea20000002300ULL,
0x0000000000407919ULL, 0x000ea20000002100ULL, 0x0000000600067308ULL, 0x010f240000001000ULL,
0x0ffffffe06047836ULL, 0x010fcc0000000000ULL, 0x0000000400057305ULL, 0x0008a4000021f000ULL,
0x000000ffff047224ULL, 0x010fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x006fc800078e0a05ULL,
0x000000000b0b7224ULL, 0x000fc800078e02ffULL, 0x0000000b05057227ULL, 0x000fcc00078e0004ULL,
0x0000000a05057227ULL, 0x020fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a05ULL,
0x0000000300037224ULL, 0x000fe400078e020aULL, 0x00000000000a7919ULL, 0x000e660000002600ULL,
0x000000000300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a00ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000000300720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000000ff05b212ULL, 0x000fc800078e33ffULL,
0x0000000500047306ULL, 0x000ea20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000400047308ULL, 0x004ea40000001000ULL, 0x0ffffffe04027836ULL, 0x004fcc0000000000ULL,
0x0000000200037305ULL, 0x000524000021f000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x0000000305067224ULL, 0x010fc800078e02ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a06ULL,
0x0000000b03037227ULL, 0x000fe400078e0002ULL, 0x00008400ff0bab82ULL, 0x000e680000000800ULL,
0x0000000a03437227ULL, 0x002fc800078e00ffULL, 0x0000000409037c24ULL, 0x000fe2000f8e020cULL,
0x0000000000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe400078e0a43ULL,
0x0000000403047c24ULL, 0x100fe2000f8e0240ULL, 0x00000005ff407819ULL, 0x000fe20000011640ULL,
0x0000000205027224ULL, 0x000fc600078e020aULL, 0x0000007f0400780cULL, 0x000fe40003fa4070ULL,
0x000000050200720cULL, 0x000fe20003f06070ULL, 0x00001fff40407589ULL, 0x000e6200000e0000ULL,
0x000000030400780cULL, 0x000fd20003f84070ULL, 0x00000000000dd919ULL, 0x000ea40000008800ULL,
0x0000000102020824ULL, 0x000fe400078e0a05ULL, 0x0000000143430836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000050200720cULL, 0x000fe40003f26070ULL,
0x000004000002d802ULL, 0x000fd60000000f00ULL, 0x0000000143431836ULL, 0x000fe20000000000ULL,
0x00000005ff43b212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x000000010400780cULL, 0x000fe20003f64070ULL, 0x000000ffff417224ULL, 0x000fc800078e0a43ULL,
0x0000004105417224ULL, 0x000fe200078e020aULL, 0x000006540d0dd816ULL, 0x004fe20000000002ULL,
0xff317217ff05d424ULL, 0x000fc800078e00ffULL, 0x000000040402d824ULL, 0x000fe400078e020dULL,
0x0000000107032824ULL, 0x008fe400078e0a08ULL, 0x00001fff09077589ULL, 0x00266800000e0000ULL,
0x00008400ff03ab82ULL, 0x002e640000000800ULL, 0x0000000000240947ULL, 0x002fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x01760008043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x00cfe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404067c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x008fca0000000000ULL,
0x00000000060812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01760804083f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404067c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x008fca0000000000ULL, 0x00000000060812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01768804083f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400050200d388ULL, 0x0005e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000001041417824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404027c11ULL, 0x004fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176a804093f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x010fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176c804093f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000803027c24ULL, 0x006fe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a41ULL, 0x000000410200720cULL, 0x000fe20003f06070ULL,
0x0000000b1408a224ULL, 0x000fc400078e02ffULL, 0x0000000800117c24ULL, 0x000fe2000f8e02ffULL,
0x00000010020f7446ULL, 0x000fe2000380000fULL, 0x0000000407027824ULL, 0x000fe400078e0240ULL,
0x00000011080e7224ULL, 0x000fe200078e02ffULL, 0x000000ff0f0f7207ULL, 0x000fe20000000000ULL,
0x0000000202067824ULL, 0x000fe400078e00ffULL, 0x0000000843137c24ULL, 0x000fe2000f8e020eULL,
0x000000100f00780cULL, 0x000fda0003f05270ULL, 0x0000000000c48947ULL, 0x000fea0003800000ULL,
0x0000000800027d06ULL, 0x000e620008209000ULL, 0x00000000000d7919ULL, 0x000ea20000000000ULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000157919ULL, 0x000f280000008800ULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02047836ULL, 0x002fe20000000000ULL, 0x00000004ff097819ULL, 0x00cfca000001160dULL,
0x0000000400057305ULL, 0x0002a2000021f000ULL, 0x00000001060a7824ULL, 0x000fc800078e0209ULL,
0x0000000141027824ULL, 0x000fe400078e020aULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x004fc800078e0a05ULL, 0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000b05057227ULL, 0x000fcc00078e0004ULL, 0x00000002050b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0bULL, 0x0000000805047c24ULL, 0x000fca000f8e0202ULL,
0x0000000804007c0cULL, 0x000fda000bf06070ULL, 0x8000000804040c36ULL, 0x000fe40008000000ULL,
0x000000010b0b0836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0x0000040000047802ULL, 0x000fc80000000f00ULL, 0x0000065415157816ULL, 0x010fce0000000004ULL,
0x000000010b0b1836ULL, 0x000fe20000000000ULL, 0x00000008ff0bac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0bULL, 0x0000000805027c24ULL, 0x000fe2000f8e0202ULL,
0x000000060f057248ULL, 0x000fe40007fe0000ULL, 0x00000000150872caULL, 0x000fe200000e0000ULL,
0x0000000113027824ULL, 0x000fe400078e0202ULL, 0x0000000105067824ULL, 0x000fe400078e0a06ULL,
0x000000110b047224ULL, 0x000fe400078e0202ULL, 0x000000100d027824ULL, 0x000fe200078e00ffULL,
0x000000060900720cULL, 0x000fe20003f06070ULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x000000f0020b7812ULL, 0x000fe200078ec0ffULL, 0x000000010a067824ULL, 0x040fe400078e020dULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x0000000b040b7212ULL, 0x000fc800078efcffULL,
0x000000040b047c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff009067812ULL, 0x000fe400078ee206ULL,
0x0000000505057c10ULL, 0x000fe40008ffe4ffULL, 0x0000000806097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000c101c46ULL,
0x0000000000b07947ULL, 0x000fea0003800000ULL, 0x0000000800097d06ULL, 0x008e620008209000ULL,
0x00000000000d7919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000900097308ULL, 0x002e640000001000ULL, 0x0ffffffe090a7836ULL, 0x002fe20000000000ULL,
0x0000040000097802ULL, 0x000fe40000000f00ULL, 0x000000060d067211ULL, 0x004fc600078fe0ffULL,
0x0000000a00057305ULL, 0x0002a4000021f000ULL, 0x0000000141027824ULL, 0x000fe200078e0206ULL,
0x00000000000a7919ULL, 0x002e620000008800ULL, 0x000000ffff0b7224ULL, 0x004fc800078e0a05ULL,
0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000b050b7227ULL, 0x000fcc00078e0004ULL,
0x000000020b047227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000805057c24ULL, 0x000fe2000f8e0202ULL, 0x000006540a097816ULL, 0x002fc80000000009ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000104040836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x0000000104041836ULL, 0x000fe20000000000ULL, 0x00000008ff04ac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000805027c24ULL, 0x000fe2000f8e0202ULL,
0x00000000090872caULL, 0x000fe200000e0000ULL, 0x0000000106097824ULL, 0x000fe400078e020dULL,
0x0000000113057824ULL, 0x000fe400078e0202ULL, 0x000000100d027824ULL, 0x000fe400078e00ffULL,
0x0000001104057224ULL, 0x000fe400078e0205ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x000000f0020b7812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fc600078e00ffULL,
0xfffffff006097812ULL, 0x000fe400078ee209ULL, 0x0000000b04047212ULL, 0x000fe400078efcffULL,
0x0000000809097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000404047c10ULL, 0x000fc8000ff1e0ffULL,
0x0000000505057c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c46ULL, 0x0001760008047890ULL, 0x000fe2000fffe03fULL,
0x00009400ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000414047825ULL, 0x002fe200078e0004ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000006043a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000007f3a3b7836ULL, 0x004fe40000000000ULL, 0x000000ff3a097836ULL, 0x000fc60000000000ULL,
0x00000007ff3b7819ULL, 0x000fe4000001163bULL, 0x00000008ff387819ULL, 0x000fca0000011609ULL,
0x000000c800a48947ULL, 0x000fea0003800000ULL, 0x00000003ff0c7819ULL, 0x000fe20000011640ULL,
0xffffffffff4f7424ULL, 0x000fc600078e00ffULL, 0x01ffffff0c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000003b0c00720cULL, 0x000fda0003f06070ULL, 0x00009600ff048b82ULL, 0x000e620000000800ULL,
0x0000000214038824ULL, 0x000fce00078e00ffULL, 0x00009200ff068b82ULL, 0x000ea20000000a00ULL,
0x0000000403038224ULL, 0x002fe400078e0204ULL, 0x00000004ff047424ULL, 0x000fe400078e00ffULL,
0x000000010c058824ULL, 0x000fe200078e0203ULL, 0x0000000840037c11ULL, 0x000fc6000f8e18ffULL,
0x0000000405068825ULL, 0x004fe200078e0006ULL, 0x0176880403ff79a7ULL, 0x0003e8000850003fULL,
0x00000006064f8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0900780cULL, 0x000fe20003f04070ULL,
0x00000080430a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff397819ULL, 0x000fe40000011640ULL,
0x0000000140097812ULL, 0x000fc600078ec0ffULL, 0x00000020390b7824ULL, 0x000fe200078e00ffULL,
0x00009000ff047b82ULL, 0x002e620000000a00ULL, 0x000000004f007224ULL, 0x004fc800078e02ffULL,
0x0000008000037824ULL, 0x000fe200078e00ffULL, 0x000000600a007812ULL, 0x000fc600078ef80bULL,
0x0000008003047825ULL, 0x002fe200078e0004ULL, 0x0000000000fc0947ULL, 0x000fec0003800000ULL,
0x0000000b3a067248ULL, 0x000fe20007fe0000ULL, 0x0000001009037824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fc6000001160dULL, 0x0000000106067824ULL, 0x000fe400078e0a0bULL,
0x0000000103087824ULL, 0x000fe400078e0207ULL, 0x0000000407117836ULL, 0x000fe20000000000ULL,
0x0000000306067248ULL, 0x000fe20007fe0000ULL, 0x0000000108107824ULL, 0x040fe400078e020dULL,
0x0000000808157824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fc400078e0a03ULL,
0x0000000c07127836ULL, 0x000fe20000000000ULL, 0xfffffff815157812ULL, 0x000fe200078ee210ULL,
0x0000000807107836ULL, 0x000fe20000000000ULL, 0x000000061100720cULL, 0x080fe20003f46070ULL,
0x0000000103117824ULL, 0x000fe200078e0211ULL, 0x000000060700720cULL, 0x080fe20003f66070ULL,
0x0000000100077824ULL, 0x000fe200078e0208ULL, 0x000000061000720cULL, 0x080fe20003f26070ULL,
0x0000000111087824ULL, 0x040fe200078e020dULL, 0x000000061200720cULL, 0x000fe20003f06070ULL,
0x0000000811177824ULL, 0x000fc400078e00ffULL, 0x0000008007067825ULL, 0x000fc800078e00ffULL,
0x0000000103107824ULL, 0x040fe400078e0210ULL, 0x0000000103137824ULL, 0x000fe200078e0212ULL,
0xfffffff817037812ULL, 0x000fe200078ee208ULL, 0x0000000100117824ULL, 0x040fe200078e0211ULL,
0x0000007006177812ULL, 0x000fe200078ef802ULL, 0x0000000113067824ULL, 0x040fe400078e020dULL,
0x00000008131d7824ULL, 0x000fe200078e00ffULL, 0x0000001704167210ULL, 0x000fe20007f9e0ffULL,
0x0000000100087824ULL, 0x000fc400078e0210ULL, 0x0000000100187824ULL, 0x000fe200078e0213ULL,
0x0000000839007c11ULL, 0x000fe2000f8e68ffULL, 0x0000000110127824ULL, 0x040fe200078e020dULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x00000008101b7824ULL, 0x000fe400078e00ffULL,
0x0000000105177824ULL, 0x000fe400020e0607ULL, 0x0000008011067825ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fc600078ee212ULL, 0x0000008008107825ULL, 0x000fe200078e00ffULL,
0x0000007006217812ULL, 0x000fc600078ef802ULL, 0x0001300000007836ULL, 0x000fe20000000000ULL,
0x00000070101f7812ULL, 0x000fe200078ef802ULL, 0x0000008018127825ULL, 0x000fc600078e00ffULL,
0x0000001f04067210ULL, 0x000fe20007fbe0ffULL, 0x0000001003197824ULL, 0x100fe200078e0200ULL,
0x0000007012037812ULL, 0x000fe200078ef802ULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x0000002104027210ULL, 0x000fe20007f9e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x0000000304047210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000d901c46ULL,
0x0000000105037824ULL, 0x040fe400020e0607ULL, 0x0000000105077824ULL, 0x000fc400028e0611ULL,
0x0000000105057824ULL, 0x000fe200030e0613ULL, 0x0000000002197faeULL, 0x0003e8000d101c46ULL,
0x00000000061b7faeULL, 0x0003e8000c901c46ULL, 0x00000000041d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x0000001009067824ULL, 0x000fca00078e00ffULL,
0x000000060d037211ULL, 0x000fca00078fe8ffULL, 0x0000000403107836ULL, 0x000fe40000000000ULL,
0x0000000103077824ULL, 0x040fe400078e020dULL, 0x0000000803087824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe400078e0203ULL, 0x0000000110117824ULL, 0x040fe200078e020dULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000000810187824ULL, 0x000fc400078e00ffULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee211ULL,
0x0000000803117836ULL, 0x000fe20000000000ULL, 0x0000007006177812ULL, 0x000fe200078ef802ULL,
0x0000000c03127836ULL, 0x000fe40000000000ULL, 0x0000000100107824ULL, 0x040fe200078e0210ULL,
0x0000001704167210ULL, 0x000fe20007f1e0ffULL, 0x0000000100037824ULL, 0x040fe400078e0211ULL,
0x0000000100137824ULL, 0x000fe400078e0212ULL, 0x0000000111007824ULL, 0x000fc400078e020dULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0x0000000839117c11ULL, 0x000fe2000f8e68ffULL,
0x0000000112067824ULL, 0x040fe400078e020dULL, 0x0000000812197824ULL, 0x000fe200078e00ffULL,
0xfffffff815007812ULL, 0x000fe200078ee200ULL, 0x0000000105177824ULL, 0x000fe400000e0607ULL,
0x0001300011217836ULL, 0x000fe20000000000ULL, 0xfffffff8191a7812ULL, 0x000fe200078ee206ULL,
0x0000008010067825ULL, 0x000fc800078e00ffULL, 0x0000008003107825ULL, 0x000fe200078e00ffULL,
0x00000070061f7812ULL, 0x000fc600078ef802ULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x00000070101d7812ULL, 0x000fc600078ef802ULL, 0x0000001008157824ULL, 0x100fe200078e0221ULL,
0x0000007012037812ULL, 0x000fe200078ef802ULL, 0x0000001018197824ULL, 0x100fe200078e0221ULL,
0x0000001f04027210ULL, 0x000fe20007f1e0ffULL, 0x00000010001b7824ULL, 0x100fe200078e0221ULL,
0x0000001d04067210ULL, 0x000fe20007f3e0ffULL, 0x000000101a1d7824ULL, 0x000fe200078e0221ULL,
0x0000000304047210ULL, 0x000fe20007f5e0ffULL, 0x0000000105037824ULL, 0x040fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000b901c46ULL,
0x0000000105077824ULL, 0x000fc400008e0611ULL, 0x0000000105057824ULL, 0x000fe200010e0613ULL,
0x0000000002197faeULL, 0x0003e8000b901c46ULL, 0x00000000061b7faeULL, 0x0003e8000b901c46ULL,
0x00000000041d7faeULL, 0x0003e4000b901c46ULL, 0x00000008ff087e24ULL, 0x000fe2000f8e00ffULL,
0x00000000390472caULL, 0x000fe200000e0000ULL, 0x00000001ff037424ULL, 0x002fe200078e00ffULL,
0x000000ff3800720cULL, 0x000fe20003f05270ULL, 0x000176a808087836ULL, 0x000fe20000000000ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff507224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000080572caULL, 0x000fc400000e0000ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x0000000839027824ULL, 0x000fe400078e0208ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000003ff4a79a7ULL, 0x0002a20008500004ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00002003020279a7ULL, 0x002e62000850003fULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ac004c8947ULL, 0x000fec0003800000ULL, 0x00009600ff137b82ULL, 0x000ee20000000800ULL,
0x00000002ff077819ULL, 0x000fe20000011640ULL, 0x0000000840027824ULL, 0x002fe200078e00ffULL,
0x0000000139007812ULL, 0x000fe200078ec0ffULL, 0x0000000214147824ULL, 0x000fe200078e00ffULL,
0x0000000807057c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff347224ULL, 0x000fe200078e0003ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0xff317217ff517424ULL, 0x000fe400078e00ffULL,
0x0000001000057824ULL, 0x000fc400078e0205ULL, 0x000000ffff047224ULL, 0x000fe400078e00ffULL,
0x0000000102067824ULL, 0x000fe400078e0205ULL, 0x0000001314057224ULL, 0x008fe400078e0213ULL,
0x000000ffff137224ULL, 0x000fce00078e00ffULL, 0x0000000000147805ULL, 0x012fce0000015200ULL,
0x0000000440167824ULL, 0x000fca00078e00ffULL, 0xfffffff816177812ULL, 0x000fc800078ec0ffULL,
0x0176c834170075a7ULL, 0x000e620008000148ULL, 0x0000000817357c36ULL, 0x000fc80008000000ULL,
0x000176c835467836ULL, 0x000fe20000000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176c834350075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009000ff147b82ULL, 0x000e620000000a00ULL,
0x0000001040167824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x0000000104357836ULL, 0x000fe40000000000ULL, 0x000000054f4f7c24ULL, 0x000fe2000f8e02ffULL,
0xffffffe016177812ULL, 0x000fe400078ec0ffULL, 0x000000383500720cULL, 0x000fe20003f26070ULL,
0x000000804f4f7824ULL, 0x000fe400078e00ffULL, 0x0000010004177824ULL, 0x000fc800078e0217ULL,
0x0000004017377836ULL, 0x000fca0000000000ULL, 0x0000006037177812ULL, 0x000fe200078ec0ffULL,
0x000000804f147825ULL, 0x002fc800078e0014ULL, 0x000000010a3d7824ULL, 0x000fe200078e0217ULL,
0x0000000400049947ULL, 0x000fec0003800000ULL, 0x0000001016177812ULL, 0x000fe400078ec0ffULL,
0x000000373a167248ULL, 0x000fe40007fe0000ULL, 0x00000003ff367819ULL, 0x000fc6000001160dULL,
0x0000000116167824ULL, 0x000fe400078e0a37ULL, 0x0000000136347824ULL, 0x000fe400078e0217ULL,
0x00000008363c7836ULL, 0x000fe20000000000ULL, 0x0000001716167248ULL, 0x000fe20007fe0000ULL,
0x0000000134357824ULL, 0x040fe400078e020dULL, 0x00000008343e7824ULL, 0x000fe400078e00ffULL,
0x0000000116167824ULL, 0x000fc400078e0a17ULL, 0x000000100d377824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee235ULL, 0x0000000436357836ULL, 0x000fe20000000000ULL,
0x000000163600720cULL, 0x080fe20003f86070ULL, 0x0000000c363f7836ULL, 0x000fe20000000000ULL,
0x000000163c00720cULL, 0x0c0fe20003f46070ULL, 0x0000000135367824ULL, 0x100fe200078e0217ULL,
0x0000007037497812ULL, 0x000fe200078ec0ffULL, 0x000000013c3c7824ULL, 0x100fe200078e0217ULL,
0x000000163500720cULL, 0x080fe20003f66070ULL, 0x000000013f427824ULL, 0x040fe200078e0217ULL,
0x000000163f00720cULL, 0x000fe20003f06070ULL, 0x000000013d377824ULL, 0x000fc400078e0236ULL,
0x000000013d167824ULL, 0x040fe400078e0234ULL, 0x000000013d357824ULL, 0x040fe400078e023cULL,
0x000000013d3f7824ULL, 0x000fe400078e0242ULL, 0x0000000136347824ULL, 0x140fe400078e020dULL,
0x0000000836457824ULL, 0x000fe400078e00ffULL, 0x000000013c3d7824ULL, 0x000fc400078e020dULL,
0x000000083c447824ULL, 0x000fe400078e00ffULL, 0x0000008037367825ULL, 0x000fc600078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee23dULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00000049363d7212ULL, 0x000fc600078efcffULL, 0x00000001423c7824ULL, 0x040fe200078e020dULL,
0x0000003d14367210ULL, 0x000fe20007fde0ffULL, 0x0000000842477824ULL, 0x000fe200078e00ffULL,
0xfffffff845427812ULL, 0x000fe200078ee234ULL, 0x0000008035347825ULL, 0x000fe200078e00ffULL,
0x0000004916457212ULL, 0x080fe400078efcffULL, 0xfffffff847487812ULL, 0x000fe200078ee23cULL,
0x000000803f3c7825ULL, 0x000fe200078e00ffULL, 0x0000000839477c11ULL, 0x000fe4000f8e68ffULL,
0x0000004514167210ULL, 0x000fe20007fbe0ffULL, 0x0000000115377824ULL, 0x040fe200030e0637ULL,
0x00000049344d7212ULL, 0x080fe200078efcffULL, 0x00014000473f7836ULL, 0x000fe20000000000ULL,
0x000000493c497212ULL, 0x000fe200078efcffULL, 0x0000000115177824ULL, 0x000fe200028e0617ULL,
0x0000004d14347210ULL, 0x000fe20007fbe0ffULL, 0x000000103e457824ULL, 0x100fe200078e023fULL,
0x0000004914147210ULL, 0x000fe20007fde0ffULL, 0x0000001042477824ULL, 0x000fc400078e023fULL,
0x0000001044497824ULL, 0x000fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016457faeULL, 0x0003e2000e101c46ULL, 0x0000000115357824ULL, 0x040fe400028e0635ULL,
0x00000010483f7824ULL, 0x000fe200078e023fULL, 0x0000000036477faeULL, 0x0003e2000d901c46ULL,
0x0000000115157824ULL, 0x000fc600030e063dULL, 0x0000000034497faeULL, 0x0003e8000d101c46ULL,
0x00000000143f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x0000001016167812ULL, 0x000fe200078ec0ffULL, 0x000000100d367824ULL, 0x000fc600078e00ffULL,
0x000000160d167211ULL, 0x000fe400078fe8ffULL, 0x0000007036497812ULL, 0x000fc600078ec0ffULL,
0x0000000416347836ULL, 0x000fe40000000000ULL, 0x0000000116177824ULL, 0x140fe400078e020dULL,
0x00000008163e7824ULL, 0x000fe400078e00ffULL, 0x0000000134357824ULL, 0x040fe400078e020dULL,
0x0000000834427824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee217ULL,
0x000000013d177824ULL, 0x000fc400078e0216ULL, 0x0000000816367836ULL, 0x000fe20000000000ULL,
0xfffffff842427812ULL, 0x000fe200078ee235ULL, 0x0000000c163c7836ULL, 0x000fe40000000000ULL,
0x0000008017167825ULL, 0x000fc800078e00ffULL, 0x000000013d347824ULL, 0x040fe200078e0234ULL,
0x00000049163f7212ULL, 0x000fe200078efcffULL, 0x000000013d377824ULL, 0x040fe400078e0236ULL,
0x0000000136357824ULL, 0x140fe200078e020dULL, 0x0000003f14167210ULL, 0x000fe20007f1e0ffULL,
0x0000000836447824ULL, 0x000fe400078e00ffULL, 0x000000013d3d7824ULL, 0x000fe400078e023cULL,
0x000000013c367824ULL, 0x040fe200078e020dULL, 0xfffffff844447812ULL, 0x000fe200078ee235ULL,
0x000000083c457824ULL, 0x000fe200078e00ffULL, 0x00000008393c7c11ULL, 0x000fe2000f8e68ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff845487812ULL, 0x000fe200078ee236ULL,
0x000140003c537836ULL, 0x000fe20000000000ULL, 0x00000049344f7212ULL, 0x000fe200078efcffULL,
0x0000008037367825ULL, 0x000fc800078e00ffULL, 0x000000803d3c7825ULL, 0x000fe200078e00ffULL,
0x00000049364d7212ULL, 0x000fc600078efcffULL, 0x0000000115177824ULL, 0x040fe200000e0617ULL,
0x000000493c497212ULL, 0x000fe200078efcffULL, 0x000000103e3f7824ULL, 0x100fe200078e0253ULL,
0x0000004f14347210ULL, 0x000fe20007f1e0ffULL, 0x0000001042457824ULL, 0x100fe200078e0253ULL,
0x0000004d14367210ULL, 0x000fe20007f5e0ffULL, 0x0000001044477824ULL, 0x000fe200078e0253ULL,
0x0000004914147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115357824ULL, 0x040fe200000e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000163f7faeULL, 0x0003e2000b901c46ULL,
0x0000000115377824ULL, 0x000fc400010e0637ULL, 0x0000001048497824ULL, 0x000fe200078e0253ULL,
0x0000000034457faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600018e063dULL,
0x0000000036477faeULL, 0x0003e8000b901c46ULL, 0x0000000014497faeULL, 0x0003e4000b901c46ULL,
0x000000010c167836ULL, 0x002fe40000000000ULL, 0xffffffffff527424ULL, 0x000fc600078e00ffULL,
0x0000003b1600720cULL, 0x000fe20003f06070ULL, 0x00000008403c7824ULL, 0x000fca00078e00ffULL,
0xfffffff03c347812ULL, 0x000fca00078ec0ffULL, 0x0000000834587c36ULL, 0x000fe40008000000ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x0000000105178824ULL, 0x000fe200078e0216ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000580572caULL, 0x000fda00000e0000ULL,
0x000176b005057890ULL, 0x000fe2000fffe03fULL, 0x0000000417148825ULL, 0x002fd000078e0014ULL,
0x00000000ff0079b0ULL, 0x000fe80008000a45ULL, 0x0000000614528981ULL, 0x000322000c1e1900ULL,
0xffffffe03c167812ULL, 0x040fe200078ec0ffULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x000000103c177812ULL, 0x040fe400078ec0ffULL, 0x000000083c4d7812ULL, 0x000fe400078ec0ffULL,
0x0000000817167c10ULL, 0x000fca000fffe016ULL, 0x00000001164d7824ULL, 0x000fe200078e024dULL,
0x0000000000007918ULL, 0x002fcc0000000000ULL, 0x0176b035585879a7ULL, 0x0002e4000850003fULL,
0x017608354d3479a7ULL, 0x0022a4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x017608354d0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017608354d0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000100d427824ULL, 0x000fe200078e00ffULL,
0x00000001ff457819ULL, 0x000fe2000001160dULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000007042427812ULL, 0x000fe400078ec0ffULL,
0xffffff8014157812ULL, 0x000fe400078ec0ffULL, 0x0000000c45457812ULL, 0x000fe400078ec0ffULL,
0x0000000842147c10ULL, 0x000fca000fffe015ULL, 0x0000000114147824ULL, 0x000fca00078e0245ULL,
0x0170000014167984ULL, 0x000ea80000000800ULL, 0x0172000014177984ULL, 0x000b620000000800ULL,
0x000000511600720bULL, 0x004fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000000fc8947ULL, 0x02afea0003800000ULL,
0x000000400700720cULL, 0x000fe40003f45270ULL, 0x000000511600720bULL, 0x000fd60003f14000ULL,
0x000000084015ac11ULL, 0x000fe4000f8e38ffULL, 0x000000511614a209ULL, 0x000fe40007810000ULL,
0x000000154515a210ULL, 0x000fe40007ffe042ULL, 0x0000000000367806ULL, 0x000fc600000e0100ULL,
0x017400141500a388ULL, 0x0003e20000000800ULL, 0x0000991036347816ULL, 0x000fc800000000ffULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0036ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001418187220ULL, 0x082fe20000410000ULL,
0x0000001419197220ULL, 0x080fe20000410000ULL, 0x0000001428287220ULL, 0x080fe20000410000ULL,
0x0000001429297220ULL, 0x080fe20000410000ULL, 0x000000142c2c7220ULL, 0x080fe20000410000ULL,
0x000000142d2d7220ULL, 0x080fe20000410000ULL, 0x0000001430307220ULL, 0x080fe20000410000ULL,
0x0000001431317220ULL, 0x080fe20000410000ULL, 0x0000001424247220ULL, 0x080fe20000410000ULL,
0x0000001425257220ULL, 0x080fe20000410000ULL, 0x0000001420207220ULL, 0x080fe20000410000ULL,
0x0000001421217220ULL, 0x080fe20000410000ULL, 0x000000141c1c7220ULL, 0x080fe20000410000ULL,
0x000000141d1d7220ULL, 0x080fe20000410000ULL, 0x0000001410107220ULL, 0x080fe20000410000ULL,
0x0000001411117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x000000141a1a7220ULL, 0x082fe20000410000ULL,
0x000000141b1b7220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x0000001427277220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x000000141e1e7220ULL, 0x080fe20000410000ULL,
0x000000141f1f7220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806036ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0xfffffff03c3c7812ULL, 0x000fc800078ec0ffULL,
0x0176a84b3c0075a7ULL, 0x000e620008000148ULL, 0x000000083c367c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff377224ULL, 0x000fce00078e00ffULL,
0x000000103700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000137377836ULL, 0x000fce0000000000ULL,
0x0176a84b360075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x0000000240537824ULL, 0x040fe200078e00ffULL,
0x000000070d577812ULL, 0x000fe200078ec0ffULL, 0x0000020040157824ULL, 0x000fe200078e00ffULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x0000000440557824ULL, 0x000fe200078e00ffULL,
0x0000000453147812ULL, 0x000fe400078ec0ffULL, 0xfffff800154f7812ULL, 0x000fe400078ec0ffULL,
0x00000008574a7812ULL, 0x000fc400078ef80dULL, 0x000000140d157211ULL, 0x040fe200078fe0ffULL,
0x000000084f4f7c36ULL, 0x000fe20008000000ULL, 0x000000080d487812ULL, 0x000fe200078ec0ffULL,
0x000000084a177824ULL, 0x040fe200078e00ffULL, 0x00000004ff547819ULL, 0x000fe2000001160dULL,
0x000000014a447824ULL, 0x000fe200078e0215ULL, 0x0000000455557812ULL, 0x000fe400078ec0ffULL,
0x00000057483c7212ULL, 0x000fe400078efcffULL, 0x0000000839497c11ULL, 0x000fe2000f8e68ffULL,
0x0000000154557824ULL, 0x000fe200078e0255ULL, 0xfffffff817147812ULL, 0x000fe200078ee244ULL,
0x000000083c4e7824ULL, 0x000fc400078e00ffULL, 0x000000013c3d7824ULL, 0x000fe400078e0255ULL,
0x0001300049477836ULL, 0x000fe40000000000ULL, 0x00000010144b7824ULL, 0x000fe200078e024fULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee23dULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x011000004b14783bULL, 0x0022e20000000200ULL, 0x000000104e347824ULL, 0x000fe200078e0247ULL,
0x0000000000100947ULL, 0x000fec0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000083c3f7824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000023d4c7836ULL, 0x000fe20000000000ULL,
0x0000001048487812ULL, 0x000fe200078efe57ULL, 0x00000004395b7824ULL, 0x000fc600078e0254ULL,
0xfffffff83f4c7812ULL, 0x000fe200078ee24cULL, 0x0000000155557824ULL, 0x000fe200078e0248ULL,
0x000000025b5b7810ULL, 0x000fe20007ffe04aULL, 0x000000084a4a7824ULL, 0x000fe400078e00ffULL,
0x000000104c3c7824ULL, 0x000fc600078e0247ULL, 0xfffffff84a4a7812ULL, 0x000fc600078ee25bULL,
0x000000003c3c783bULL, 0x000f640000004200ULL, 0x000000104a4f7824ULL, 0x000fe200078e024fULL,
0x000000ff35637812ULL, 0x022fe400078ec0ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011635ULL,
0x000000ff345b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff577819ULL, 0x000fe40000011634ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff627819ULL, 0x100fe40000011637ULL, 0x000000ff37657812ULL, 0x040fe400078ec0ffULL,
0x00000018ff547819ULL, 0x000fe40000011637ULL, 0x0000ffff375a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c6f7812ULL, 0x008fc400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001163cULL,
0x00000010ff687819ULL, 0x000fe40000011634ULL, 0x0000ffff346b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe40000011635ULL, 0x0000ffff356d7812ULL, 0x000fe400078ec0ffULL,
0x0000005bff37723eULL, 0x000fc400020006ffULL, 0x00000010ff697819ULL, 0x000fe4000001163cULL,
0x0000ffff3c667812ULL, 0x000fe200078ec0ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x000000ff3d707812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x100fe40000011636ULL,
0x000000ff36647812ULL, 0x000fe400078ec0ffULL, 0x00000018ff567819ULL, 0x000fc40000011636ULL,
0x0000ffff36347812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x100fe4000001163dULL,
0x00000018ff5b7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d6a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x000fe4000001163eULL, 0x000000ff3e5c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e607812ULL, 0x000fe400078ec0ffULL,
0x00000057ff35723eULL, 0x000fe200020006ffULL, 0x20000063ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x100fe2000001163fULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x000000ff3f3e7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000018ff3d7819ULL, 0x000fc4000001163fULL, 0x0000ffff3f5d7812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x0000005eff3f723eULL, 0x000fe400020006ffULL,
0x00000070ff5f723eULL, 0x000fe200020006ffULL, 0x2000006fff5e7230ULL, 0x000fe20000004100ULL,
0x0000005bff70723eULL, 0x000fe200020006ffULL, 0x2000003fff5b7230ULL, 0x000fe20000004100ULL,
0x0000005cff3f723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000003eff6f723eULL, 0x000fe200020006ffULL, 0x20000070ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL, 0x0000003dff70723eULL, 0x000fe200020006ffULL,
0x2000006fff3d7230ULL, 0x000fe20000004100ULL, 0x0000003cff3e723eULL, 0x000fe200020006ffULL,
0x2000003fff3c7230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000054ff3f723eULL, 0x000fe200020006ffULL, 0x20000070ff547230ULL, 0x000fe20000004100ULL,
0x00000008ff6f7819ULL, 0x000fc4000001166dULL, 0x000000ff69697812ULL, 0x000fe200078ec0ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff6e707812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6e7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000006fff6c723eULL, 0x000fe400020006ffULL, 0x000000ff68687812ULL, 0x000fe400078ec0ffULL,
0x00000069ff6f723eULL, 0x000fe200020006ffULL, 0x20000062ff697230ULL, 0x000fe20000004100ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff6a7819ULL, 0x000fc4000001166aULL, 0x00000008ff6b7819ULL, 0x000fe4000001166bULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000066ff62723eULL, 0x000fe200020006ffULL,
0x2000006fff667230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000068ff6d7230ULL, 0x000fe20000004100ULL, 0x000000ff616f7812ULL, 0x000fe200078ec0ffULL,
0x20000062ff617230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000006aff627230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x000000ff366a7812ULL, 0x000fe200078ec0ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe40000011637ULL, 0x00000010ff377819ULL, 0x000fe20000011657ULL,
0x2000006fff577230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x00000070ff68723eULL, 0x000fe400020006ffULL, 0x0000006aff6f723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000008ff6a7819ULL, 0x000fe40000011634ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000010546d367816ULL, 0x000fc40000000036ULL, 0x000010546e377816ULL, 0x000fe40000000037ULL,
0x00000010ff357819ULL, 0x000fe40000011635ULL, 0x00000010ff347819ULL, 0x000fe4000001166bULL,
0x00000010ff6d7819ULL, 0x000fe20000011663ULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166cULL, 0x2000006fff637230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010546d357816ULL, 0x000fe2000000006cULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe40000011664ULL, 0x00000010ff377819ULL, 0x000fe40000011668ULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff647819ULL, 0x000fc40000011669ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105464377816ULL, 0x000fe40000000065ULL, 0x00000010ff347819ULL, 0x000fe4000001165eULL,
0x00000010ff357819ULL, 0x000fe40000011666ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff5e7819ULL, 0x000fc40000011667ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x000010545e357816ULL, 0x000fe4000000005fULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00000008ff6b7819ULL, 0x000fe20000011660ULL, 0x2000006aff607230ULL, 0x000fe20000004100ULL,
0x00000008ff647819ULL, 0x000fe2000001165dULL, 0x000000341424723cULL, 0x000fe20000041824ULL,
0x00000010ff5b7819ULL, 0x000fc4000001165bULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff367819ULL, 0x000fe40000011661ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000010545b367816ULL, 0x000fe20000000036ULL, 0x2000006bff5d7230ULL, 0x000fe20000004100ULL,
0x000010545c377816ULL, 0x000fe20000000037ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc40000011656ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff3d7819ULL, 0x000fe2000001163dULL, 0x000000361420723cULL, 0x000fe20000041820ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff567819ULL, 0x000fe40000011663ULL,
0x00000010ff347819ULL, 0x000fe40000011660ULL, 0x00001054573c7816ULL, 0x000fc4000000003cULL,
0x00001054563d7816ULL, 0x000fe4000000003dULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x00000010ff367819ULL, 0x000fe4000001163fULL, 0x00000010ff357819ULL, 0x000fe2000001165aULL,
0x0000003c141c723cULL, 0x000fe2000004181cULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff377819ULL, 0x000fe20000011664ULL, 0x00000008483c7824ULL, 0x000fe200078e00ffULL,
0x0000105436357816ULL, 0x000fe40000000035ULL, 0x000010543e367816ULL, 0x000fe4000000005dULL,
0x0000105454377816ULL, 0x000fe40000000037ULL, 0xfffffff83c4a7812ULL, 0x000fe200078ee255ULL,
0x000000341430723cULL, 0x000fec0000041830ULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x000000104a347824ULL, 0x000fe200078e0247ULL, 0x011000004f14783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x00000008483d7824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x0000000255487836ULL, 0x000fe20000000000ULL, 0xfffffff853537812ULL, 0x000fc800078ec0ffULL,
0xfffffff83d487812ULL, 0x000fca00078ee248ULL, 0x00000010483c7824ULL, 0x000fcc00078e0247ULL,
0x000000003c3c783bULL, 0x000f640000004200ULL, 0x00000010ff6d7819ULL, 0x122fe40000011634ULL,
0x000000ff34557812ULL, 0x040fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fe40000011634ULL,
0x0000ffff346a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff365e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff35567812ULL, 0x000fe400078ec0ffULL, 0x00000018ff347819ULL, 0x000fe40000011635ULL,
0x00000018ff5a7819ULL, 0x000fe40000011636ULL, 0x000000ff37607812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c6f7812ULL, 0x008fe400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x00000010ff6c7819ULL, 0x000fe40000011635ULL, 0x00000010ff657819ULL, 0x000fe40000011636ULL,
0x0000ffff36667812ULL, 0x000fe400078ec0ffULL, 0x00000056ff69723eULL, 0x000fe400020006ffULL,
0x00000034ff63723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000054ff62723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fc4000001163cULL,
0x00000018ff567819ULL, 0x000fe2000001163cULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x0000ffff3c347812ULL, 0x000fe400078ec0ffULL, 0x000000ff3d577812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000010ff677819ULL, 0x100fe40000011637ULL,
0x00000018ff5f7819ULL, 0x000fc40000011637ULL, 0x00000018ff5b7819ULL, 0x000fe4000001163dULL,
0x00000010ff5c7819ULL, 0x100fe4000001163eULL, 0x000000ff3e6e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e547812ULL, 0x000fe400078ec0ffULL,
0x0000ffff35647812ULL, 0x000fc400078ec0ffULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL, 0x00000060ff61723eULL, 0x000fe200020006ffULL,
0x2000005eff607230ULL, 0x000fe20000004100ULL, 0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL,
0x2000005aff5e7230ULL, 0x000fe20000004100ULL, 0x00000055ff6b723eULL, 0x000fe200020006ffULL,
0x2000006fff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe2000001163dULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x0000ffff3d357812ULL, 0x000fe200078ec0ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5d7819ULL, 0x100fe4000001163fULL, 0x00000018ff3d7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f557812ULL, 0x000fe400078ec0ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x0000005bff3f723eULL, 0x000fe200020006ffULL,
0x20000057ff5b7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x000000ff65657812ULL, 0x000fe200078ec0ffULL, 0x2000003fff577230ULL, 0x000fe20000004100ULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x0000003eff6f723eULL, 0x000fe200020006ffULL,
0x2000006eff3e7230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe20000011664ULL, 0x2000006fff3f7230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x2000006dff6e7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fc400020006ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006cff6f7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000006aff6d7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000065ff6c7230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x20000067ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff36367812ULL, 0x000fe200078ec0ffULL, 0x20000064ff707230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x20000037ff677230ULL, 0x000fe20000004100ULL,
0x00000036ff65723eULL, 0x000fc400020006ffULL, 0x00000068ff64723eULL, 0x000fe400020006ffULL,
0x00000010ff367819ULL, 0x000fe2000001166bULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe2000001166eULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff687819ULL, 0x000fe4000001166fULL,
0x0000105437367816ULL, 0x000fc40000000036ULL, 0x0000105468377816ULL, 0x000fe40000000069ULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x00000008ff687819ULL, 0x000fe40000011634ULL,
0x00000008ff697819ULL, 0x000fe20000011635ULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff357819ULL, 0x000fe40000011662ULL, 0x00000010ff347819ULL, 0x000fc4000001166dULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000105463357816ULL, 0x000fe20000000070ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc40000011660ULL, 0x00000010ff377819ULL, 0x000fe4000001166cULL,
0x00000010ff627819ULL, 0x000fe20000011661ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff637819ULL, 0x000fe4000001166aULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105463377816ULL, 0x000fe40000000062ULL, 0x000000ff5c627812ULL, 0x000fc400078ec0ffULL,
0x00000010ff357819ULL, 0x000fe4000001165eULL, 0x00000010ff347819ULL, 0x000fe20000011666ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff5c7819ULL, 0x000fe4000001165fULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fc400020006ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x20000068ff607230ULL, 0x000fe20000004100ULL, 0x0000105435347816ULL, 0x000fe20000000034ULL,
0x20000069ff617230ULL, 0x000fe20000004100ULL, 0x000010545c357816ULL, 0x000fe40000000067ULL,
0x00000010ff367819ULL, 0x000fe4000001165aULL, 0x00000010ff377819ULL, 0x000fc4000001165bULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000105465367816ULL, 0x000fe20000000036ULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000105464377816ULL, 0x000fe20000000037ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000008ff5a7819ULL, 0x000fc40000011654ULL,
0x00000008ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff357819ULL, 0x000fe20000011656ULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x00000010ff347819ULL, 0x000fe40000011660ULL,
0x00000010ff547819ULL, 0x000fe40000011657ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x0000003cff3c723eULL, 0x000fc400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe2000001163eULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc40000011662ULL, 0x0000105454357816ULL, 0x000fe40000000061ULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff3e7819ULL, 0x000fe4000001165dULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x000010543e377816ULL, 0x000fe4000000003fULL, 0x00000010ff557819ULL, 0x000fc80000011655ULL,
0x00000010ff357819ULL, 0x000fe2000001163cULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x00000010ff347819ULL, 0x000fe4000001165aULL, 0x00000010ff3c7819ULL, 0x000fe4000001163dULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x0000000839367c11ULL, 0x000fe4000f8e18ffULL,
0x000010543c357816ULL, 0x000fe20000000055ULL, 0x00000001ff3c7424ULL, 0x000fc800078e00ffULL,
0x0176c83c363679a7ULL, 0x0002e4000850003fULL, 0x000000341410723cULL, 0x000fe20000041810ULL,
0x0176883c53ff79a7ULL, 0x0003de0008500008ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000037460075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff347224ULL, 0x000fce00078e00ffULL,
0x000000103400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000134347836ULL, 0x000fce0000000000ULL,
0x00000037460075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00009000ff567b82ULL, 0x000ee20000000a00ULL, 0x0000001040147824ULL, 0x000fe200078e00ffULL,
0x0000850000057ab9ULL, 0x000fe40000000800ULL, 0x0000000552527c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe014157812ULL, 0x000fe400078ec0ffULL, 0x0000008052177824ULL, 0x000fc600078e00ffULL,
0x0000010004157824ULL, 0x000fc800078e0215ULL, 0x0000008015357836ULL, 0x000fca0000000000ULL,
0x0000006035157812ULL, 0x000fe200078ec0ffULL, 0x0000008017567825ULL, 0x008fc800078e0056ULL,
0x000000010a167824ULL, 0x000fe200078e0215ULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x0000001014177812ULL, 0x000fe400078ec0ffULL, 0x000000353a147248ULL, 0x000fe40007fe0000ULL,
0x00000003ff157819ULL, 0x000fc6000001160dULL, 0x0000000114147824ULL, 0x000fe400078e0a35ULL,
0x0000000115347824ULL, 0x000fe400078e0217ULL, 0x0000000415367836ULL, 0x000fe20000000000ULL,
0x0000001417147248ULL, 0x000fe20007fe0000ULL, 0x0000000134357824ULL, 0x040fe400078e020dULL,
0x00000008343c7824ULL, 0x002fe400078e00ffULL, 0x0000000114147824ULL, 0x000fc400078e0a17ULL,
0x0000000c15377836ULL, 0x000fe20000000000ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee235ULL,
0x0000000815357836ULL, 0x000fe20000000000ULL, 0x000000143600720cULL, 0x0c0fe20003f66070ULL,
0x0000000136367824ULL, 0x100fe200078e0217ULL, 0x000000141500720cULL, 0x080fe20003f86070ULL,
0x0000000134157824ULL, 0x000fe200078e0216ULL, 0x000000143700720cULL, 0x080fe20003f06070ULL,
0x0000000135347824ULL, 0x140fe200078e0217ULL, 0x000000143500720cULL, 0x000fe20003f46070ULL,
0x00000001373f7824ULL, 0x000fc400078e0217ULL, 0x0000000136177824ULL, 0x140fe400078e020dULL,
0x00000008363e7824ULL, 0x040fe400078e00ffULL, 0x0000000136367824ULL, 0x000fe400078e0216ULL,
0x0000000134357824ULL, 0x000fe200078e020dULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee217ULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x0000000834527824ULL, 0x000fe200078e00ffULL,
0x0000004236177212ULL, 0x000fe200078efcffULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0xfffffff852527812ULL, 0x000fe200078ee235ULL, 0x0000000134347824ULL, 0x100fe200078e0216ULL,
0x00000042143d7212ULL, 0x000fe200078efcffULL, 0x000000013f167824ULL, 0x040fe200078e0216ULL,
0x0000001756367210ULL, 0x000fe20007fde0ffULL, 0x000000013f537824ULL, 0x040fe200078e020dULL,
0x0000003d56147210ULL, 0x000fe20007fbe0ffULL, 0x000000083f547824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff854547812ULL, 0x000fe200078ee253ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004234557212ULL, 0x000fc600078efcffULL,
0x0000000157157824ULL, 0x040fe200028e0615ULL, 0x0000004216537212ULL, 0x000fe200078efcffULL,
0x0000000157377824ULL, 0x040fe200030e0637ULL, 0x0000005556347210ULL, 0x000fe20007fbe0ffULL,
0x000000103c3d7824ULL, 0x100fe200078e0247ULL, 0x0000005356167210ULL, 0x000fe20007fde0ffULL,
0x000000103e3f7824ULL, 0x100fe400078e0247ULL, 0x0000001052537824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000e101c46ULL,
0x0000000157357824ULL, 0x000fc400028e0635ULL, 0x0000001054477824ULL, 0x000fe200078e0247ULL,
0x00000000363f7faeULL, 0x0003e2000d901c46ULL, 0x0000000157177824ULL, 0x000fc600030e0617ULL,
0x0000000034537faeULL, 0x0003e8000d101c46ULL, 0x0000000016477faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x0000001014147812ULL, 0x000fc800078ec0ffULL,
0x000000140d157211ULL, 0x000fca00078fe8ffULL, 0x0000000115147824ULL, 0x040fe400078e0216ULL,
0x0000000415357836ULL, 0x000fe40000000000ULL, 0x00000008153d7836ULL, 0x000fe40000000000ULL,
0x0000000115177824ULL, 0x040fe400078e020dULL, 0x00000008153c7824ULL, 0x002fe400078e00ffULL,
0x0000000c153e7836ULL, 0x000fc40000000000ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fc600078ee217ULL, 0x0000000135347824ULL, 0x140fe200078e0216ULL,
0x0000004214177212ULL, 0x000fe200078efcffULL, 0x0000000135377824ULL, 0x140fe400078e020dULL,
0x0000000835527824ULL, 0x000fe200078e00ffULL, 0x0000001756147210ULL, 0x000fe20007f1e0ffULL,
0x000000013d357824ULL, 0x040fe400078e020dULL, 0x000000083d547824ULL, 0x040fe400078e00ffULL,
0x000000013d367824ULL, 0x000fc400078e0216ULL, 0x000000013e167824ULL, 0x040fe400078e0216ULL,
0x000000013e3d7824ULL, 0x040fe400078e020dULL, 0x000000083e5a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8523e7812ULL, 0x000fe200078ee237ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff854527812ULL, 0x000fe400078ee235ULL, 0xfffffff85a547812ULL, 0x000fe200078ee23dULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x00000042365b7212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000042345d7212ULL, 0x080fe400078efcffULL,
0x0000005b56367210ULL, 0x000fe20007f5e0ffULL, 0x0000000157157824ULL, 0x040fe200000e0615ULL,
0x0000004216557212ULL, 0x000fe200078efcffULL, 0x000000103c3d7824ULL, 0x100fe200078e0247ULL,
0x0000005d56347210ULL, 0x000fe20007f1e0ffULL, 0x000000103e3f7824ULL, 0x100fe200078e0247ULL,
0x0000005556167210ULL, 0x000fe20007f7e0ffULL, 0x0000001052537824ULL, 0x000fe200078e0247ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000143d7faeULL, 0x0003e2000b901c46ULL,
0x0000000157357824ULL, 0x000fc400000e0635ULL, 0x0000000157377824ULL, 0x040fe400010e0637ULL,
0x0000001054477824ULL, 0x000fe200078e0247ULL, 0x00000000343f7faeULL, 0x0003e2000b901c46ULL,
0x0000000157177824ULL, 0x000fc600018e0617ULL, 0x0000000036537faeULL, 0x0003e8000b901c46ULL,
0x0000000016477faeULL, 0x0003e4000b901c46ULL, 0x0000000840147824ULL, 0x002fe400078e00ffULL,
0x00000001ff167424ULL, 0x000fc600078e00ffULL, 0xfffffff014147812ULL, 0x000fca00078ec0ffULL,
0x0000000814547c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000000540572caULL, 0x000fda00000e0000ULL, 0x000176a805057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a816545479a7ULL, 0x0002e4000850003fULL, 0x017628164d1679a7ULL, 0x0022a4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x017628174d0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000003414377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017628174d0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000002040147824ULL, 0x000fe400078e00ffULL, 0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000008015147810ULL, 0x000fc80007ffe014ULL, 0x0000001445147210ULL, 0x000fca0007ffe042ULL,
0x0170000014167984ULL, 0x000ea80000000800ULL, 0x0172000014177984ULL, 0x0009220000000800ULL,
0x000000511600720bULL, 0x004fda0003f1d000ULL, 0x0000000000157806ULL, 0x000fc800000e0100ULL,
0x0000ffff15357812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x01afea0003800000ULL,
0x0000000107157836ULL, 0x000fe20000000000ULL, 0x000000511600720bULL, 0x000fc80003f14000ULL,
0x000000401500720cULL, 0x000fd20003f45270ULL, 0x0000000000347806ULL, 0x000fc800000e0100ULL,
0x000000084015ac11ULL, 0x000fe4000f8e38ffULL, 0x000000511614a209ULL, 0x000fe40007810000ULL,
0x000000154537a210ULL, 0x000fe40007ffe042ULL, 0x0000991034157816ULL, 0x000fc600000000ffULL,
0x017400143700a388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005116147209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x0000005114147221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400157308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc000001160dULL, 0x00001f1415147589ULL, 0x004e6400000e0000ULL,
0x0000001814187220ULL, 0x042fe20000410000ULL, 0x0000001914197220ULL, 0x040fe20000410000ULL,
0x0000002814287220ULL, 0x040fe20000410000ULL, 0x0000002914297220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000002414247220ULL, 0x040fe20000410000ULL, 0x0000002514257220ULL, 0x040fe20000410000ULL,
0x0000002014207220ULL, 0x040fe20000410000ULL, 0x0000002114217220ULL, 0x040fe20000410000ULL,
0x0000001c141c7220ULL, 0x040fe20000410000ULL, 0x0000001d141d7220ULL, 0x040fe20000410000ULL,
0x0000001014107220ULL, 0x040fe20000410000ULL, 0x0000001114117220ULL, 0x000fce0000410000ULL,
0x0000001550507220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080d147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1415147589ULL, 0x000e6400000e0000ULL,
0x0000001a141a7220ULL, 0x042fe20000410000ULL, 0x0000001b141b7220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002614267220ULL, 0x040fe20000410000ULL, 0x0000002714277220ULL, 0x040fe20000410000ULL,
0x0000002214227220ULL, 0x040fe20000410000ULL, 0x0000002314237220ULL, 0x040fe20000410000ULL,
0x0000001e141e7220ULL, 0x040fe20000410000ULL, 0x0000001f141f7220ULL, 0x040fe20000410000ULL,
0x0000001214127220ULL, 0x040fe20000410000ULL, 0x0000001314137220ULL, 0x000fce0000410000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000005116517209ULL, 0x000fd60007810000ULL, 0x8000005116160221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL,
0x0000001600020308ULL, 0x000ea40000000800ULL, 0x0000000217170220ULL, 0x004fce0000410000ULL,
0x0000005017507221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x002fe20000015200ULL,
0x0000000840167824ULL, 0x000fca00078e00ffULL, 0xfffffff016177812ULL, 0x000fc800078ec0ffULL,
0x0176b059170075a7ULL, 0x000ea20008000148ULL, 0x0000000817377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b059370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991034147816ULL, 0x000fe200000000ffULL, 0x0001400049477836ULL, 0x000fc60000000000ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x000000104e347824ULL, 0x000fd800078e0247ULL,
0x0000000000180947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000147816ULL, 0x000fca0000000000ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514007589ULL, 0x0002e400000e0000ULL, 0x011800004b14783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000015157232ULL, 0x080fe40000200000ULL,
0x0000000017177232ULL, 0x000fce0000200000ULL, 0x000000104c3c7824ULL, 0x000fe200078e0247ULL,
0x000000003434783bULL, 0x000f2a0000004200ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x000000ff355a7812ULL, 0x010fe400078ec0ffULL, 0x00000010ff537819ULL, 0x000fe40000011634ULL,
0x0000005aff64723eULL, 0x000fc400020006ffULL, 0x000000ff3c5a7812ULL, 0x022fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe2000001163dULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x000000ff3d6f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001163dULL,
0x0000ffff3d657812ULL, 0x000fe400078ec0ffULL, 0x000000ff3e3d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff34597812ULL, 0x040fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011634ULL,
0x0000ffff34677812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x100fe4000001163fULL,
0x000000ff3f6c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fc4000001163fULL,
0x0000ffff3f607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001163cULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000006eff3f723eULL, 0x000fe400020006ffULL,
0x00000010ff6b7819ULL, 0x100fe40000011637ULL, 0x000000ff37717812ULL, 0x000fe200078ec0ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000018ff707819ULL, 0x000fc40000011637ULL,
0x0000ffff37667812ULL, 0x000fe400078ec0ffULL, 0x0000003dff6e723eULL, 0x000fe400020006ffULL,
0x00000010ff697819ULL, 0x100fe40000011636ULL, 0x000000ff36627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe40000011636ULL, 0x0000ffff366a7812ULL, 0x000fc400078ec0ffULL,
0x00000058ff37723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x100fe2000001163eULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x00000018ff587819ULL, 0x000fe2000001163eULL, 0x2000006fff3d7230ULL, 0x000fe20000004100ULL,
0x0000ffff3e367812ULL, 0x000fe400078ec0ffULL, 0x0000005cff3e723eULL, 0x000fe200020006ffULL,
0x2000005aff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe20000011635ULL,
0x2000006eff5a7230ULL, 0x000fe20000004100ULL, 0x0000006cff6e723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000006dff6f723eULL, 0x000fc400020006ffULL,
0x000000ff526d7812ULL, 0x000fe200078ec0ffULL, 0x2000006eff527230ULL, 0x000fe20000004100ULL,
0x0000ffff35687812ULL, 0x000fe400078ec0ffULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x000000ff696e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff53537812ULL, 0x000fe200078ec0ffULL, 0x2000006dff697230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe4000001163cULL, 0x00000053ff6c723eULL, 0x000fe200020006ffULL,
0x20000058ff537230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166aULL,
0x2000006fff587230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000067ff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff5b7819ULL, 0x000fe20000011635ULL,
0x2000006eff677230ULL, 0x000fe20000004100ULL, 0x0000ffff3c5f7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff6b6f7812ULL, 0x000fe200078ec0ffULL,
0x20000068ff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff667819ULL, 0x000fc40000011666ULL,
0x00000059ff35723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x000000ff636e7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff637230ULL, 0x000fe20000004100ULL,
0x0000006fff68723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x00000008ff5f7819ULL, 0x000fe2000001165fULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000008ff6f7819ULL, 0x000fe20000011665ULL,
0x20000066ff657230ULL, 0x000fe20000004100ULL, 0x0000005eff6d723eULL, 0x000fe200020006ffULL,
0x2000006eff667230ULL, 0x000fe20000004100ULL, 0x0000005fff5e723eULL, 0x000fe400020006ffULL,
0x0000005bff59723eULL, 0x000fc400020006ffULL, 0x0000006fff5f723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff346f7812ULL, 0x000fe200078ec0ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x000000ff5d6e7812ULL, 0x000fe200078ec0ffULL,
0x2000006dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe20000011635ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe4000001166cULL,
0x00000010ff6d7819ULL, 0x000fc40000011664ULL, 0x00000010ff6c7819ULL, 0x000fe40000011669ULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x000010546c357816ULL, 0x000fe4000000006dULL,
0x00000008ff697819ULL, 0x000fc40000011636ULL, 0x00000061ff3c723eULL, 0x000fe200020006ffULL,
0x20000062ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011637ULL,
0x20000071ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe2000001166aULL,
0x000000341418723cULL, 0x008fe20000041818ULL, 0x00000010ff6c7819ULL, 0x000fe20000011659ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000070ff5b723eULL, 0x000fc400020006ffULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010546c377816ULL, 0x000fe2000000006bULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fe40000011661ULL, 0x00000010ff357819ULL, 0x000fe40000011662ULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x000000361428723cULL, 0x000fe20000041828ULL,
0x00000010ff687819ULL, 0x000fc40000011668ULL, 0x0000105467347816ULL, 0x000fe40000000034ULL,
0x0000105468357816ULL, 0x000fe40000000035ULL, 0x00000008ff6a7819ULL, 0x000fe40000011660ULL,
0x00000010ff377819ULL, 0x000fe4000001163cULL, 0x00000010ff367819ULL, 0x000fe20000011663ULL,
0x00000034142c723cULL, 0x000fe2000004182cULL, 0x00000010ff3c7819ULL, 0x000fc4000001165bULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x2000006eff647230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000006fff597230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000069ff607230ULL, 0x000fe20000004100ULL, 0x000010543c377816ULL, 0x000fe20000000065ULL,
0x2000006aff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fc4000001163eULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff617819ULL, 0x000fe20000011666ULL,
0x000000361430723cULL, 0x000fe20000041830ULL, 0x00000010ff3e7819ULL, 0x000fe4000001165eULL,
0x00001054613c7816ULL, 0x000fe4000000005cULL, 0x00001054353e7816ULL, 0x000fe4000000003eULL,
0x00000010ff3d7819ULL, 0x000fc4000001163dULL, 0x00000010ff5c7819ULL, 0x000fe4000001163fULL,
0x00000010ff347819ULL, 0x000fe4000001165dULL, 0x00000010ff357819ULL, 0x000fe40000011652ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff3f7819ULL, 0x000fe4000001165fULL,
0x00000010ff5d7819ULL, 0x000fc40000011664ULL, 0x00000010ff537819ULL, 0x000fe40000011653ULL,
0x00000010ff527819ULL, 0x000fe40000011659ULL, 0x00000010ff367819ULL, 0x000fe40000011660ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff377819ULL, 0x000fe4000001165bULL,
0x00001054343d7816ULL, 0x000fc4000000003dULL, 0x000010545c3f7816ULL, 0x000fe4000000003fULL,
0x000010545d347816ULL, 0x000fe4000000005aULL, 0x0000105452357816ULL, 0x000fe20000000035ULL,
0x0000003c1424723cULL, 0x000fe20000041824ULL, 0x0000105453367816ULL, 0x000fe40000000036ULL,
0x0000105458377816ULL, 0x000fc60000000037ULL, 0x0000003e1420723cULL, 0x000fec0000041820ULL,
0x00000034141c723cULL, 0x000fec000004181cULL, 0x000000361410723cULL, 0x000fe20000041810ULL,
0x000000104a347824ULL, 0x000fe200078e0247ULL, 0x011800004f14783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x00000010483c7824ULL, 0x000fe200078e0247ULL, 0x000000003434783bULL, 0x000f2a0000004200ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000ff365d7812ULL, 0x010fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe40000011635ULL, 0x00000018ff597819ULL, 0x000fc40000011636ULL,
0x00000018ff4f7819ULL, 0x102fe40000011634ULL, 0x000000ff3c6d7812ULL, 0x020fe400078ec0ffULL,
0x00000010ff6c7819ULL, 0x000fe40000011634ULL, 0x000000ff35587812ULL, 0x000fe400078ec0ffULL,
0x000000ff375f7812ULL, 0x000fe400078ec0ffULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x000000ff34527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff346a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6b7819ULL, 0x000fe40000011635ULL, 0x00000010ff627819ULL, 0x000fe40000011636ULL,
0x0000ffff36617812ULL, 0x000fe400078ec0ffULL, 0x00000053ff64723eULL, 0x000fc400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000ffff35657812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000004fff63723eULL, 0x000fe400020006ffULL,
0x00000010ff367819ULL, 0x100fe4000001163cULL, 0x00000018ff537819ULL, 0x000fe2000001163cULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000ffff3c347812ULL, 0x000fc400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fe400020006ffULL, 0x00000010ff5b7819ULL, 0x100fe4000001163eULL,
0x000000ff3e5a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e4f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff677819ULL, 0x000fc40000011637ULL,
0x00000018ff5e7819ULL, 0x000fe40000011637ULL, 0x0000ffff37667812ULL, 0x000fe400078ec0ffULL,
0x00000058ff68723eULL, 0x000fe400020006ffULL, 0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL,
0x0000005fff60723eULL, 0x000fe200020006ffULL, 0x2000005dff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff5d7230ULL, 0x000fe20000004100ULL,
0x00000052ff69723eULL, 0x000fe200020006ffULL, 0x2000006dff597230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x100fe2000001163dULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x000000ff3d6e7812ULL, 0x040fe200078ec0ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff587819ULL, 0x000fe2000001163dULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x0000ffff3d357812ULL, 0x000fc400078ec0ffULL, 0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5c7819ULL, 0x100fe4000001163fULL, 0x00000018ff3d7819ULL, 0x000fe4000001163fULL,
0x0000ffff3f527812ULL, 0x000fe400078ec0ffULL, 0x00000008ff6a7819ULL, 0x000fe4000001166aULL,
0x00000008ff657819ULL, 0x000fc40000011665ULL, 0x0000005aff3f723eULL, 0x000fe400020006ffULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x0000003eff6d723eULL, 0x000fe200020006ffULL, 0x2000003fff3e7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe200020006ffULL,
0x2000006dff3f7230ULL, 0x000fe20000004100ULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000006eff5a7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000006bff6d7230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000006aff6b7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000065ff6e7230ULL, 0x000fe20000004100ULL, 0x000000ff36367812ULL, 0x000fe200078ec0ffULL,
0x20000062ff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff37377812ULL, 0x000fe200078ec0ffULL,
0x20000061ff657230ULL, 0x000fe20000004100ULL, 0x00000036ff62723eULL, 0x000fc400020006ffULL,
0x00000037ff61723eULL, 0x000fe400020006ffULL, 0x000000ff67677812ULL, 0x000fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011669ULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe4000001166cULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff6d7819ULL, 0x000fc4000001166dULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010546d377816ULL, 0x000fe20000000068ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe40000011634ULL, 0x00000008ff697819ULL, 0x000fe40000011635ULL,
0x00000008ff667819ULL, 0x000fe20000011666ULL, 0x000000361418723cULL, 0x008fe20000041818ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff347819ULL, 0x000fe4000001166bULL, 0x00000010ff357819ULL, 0x000fe4000001166eULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x0000105463347816ULL, 0x000fe20000000034ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000105464357816ULL, 0x000fe20000000035ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc4000001165fULL, 0x00000010ff377819ULL, 0x000fe4000001166aULL,
0x00000010ff637819ULL, 0x000fe20000011660ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff647819ULL, 0x000fe40000011667ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105464377816ULL, 0x000fe40000000063ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff347819ULL, 0x000fe20000011665ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff357819ULL, 0x000fe40000011666ULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x000000ff5b5b7812ULL, 0x000fe200078ec0ffULL, 0x20000068ff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff5c5c7812ULL, 0x000fe200078ec0ffULL, 0x20000069ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc40000011659ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x000010545d347816ULL, 0x000fe40000000034ULL, 0x000010545e357816ULL, 0x000fe40000000035ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x0000005cff5c723eULL, 0x000fc400020006ffULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000105461377816ULL, 0x000fe2000000005aULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff4f7819ULL, 0x000fe4000001164fULL,
0x00000008ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff537819ULL, 0x000fe20000011653ULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x00000010ff587819ULL, 0x000fc40000011658ULL,
0x00000010ff347819ULL, 0x000fe4000001165fULL, 0x00000010ff357819ULL, 0x000fe40000011660ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000105453347816ULL, 0x000fe20000000034ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x0000105458357816ULL, 0x000fe20000000035ULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc4000001163eULL, 0x00000010ff377819ULL, 0x000fe4000001163fULL,
0x00000010ff5b7819ULL, 0x000fe2000001165bULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x000010545b367816ULL, 0x000fe40000000036ULL,
0x000010545c377816ULL, 0x000fe40000000037ULL, 0x00000010ff357819ULL, 0x000fe2000001163cULL,
0x00000002403c7824ULL, 0x000fe200078e00ffULL, 0x00000010ff347819ULL, 0x000fc4000001164fULL,
0x00000010ff3d7819ULL, 0x000fe2000001163dULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010543d357816ULL, 0x000fe20000000052ULL, 0x00000001ff3d7424ULL, 0x000fe200078e00ffULL,
0x0000000839367c11ULL, 0x000fe4000f8e18ffULL, 0xfffffff83c3c7812ULL, 0x000fc600078ec0ffULL,
0x000000341410723cULL, 0x000fe20000041810ULL, 0x0176c83d363679a7ULL, 0x0002e2000850003fULL,
0x0176903d3cff79a7ULL, 0x0003de0008500008ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000037460075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff347224ULL, 0x000fce00078e00ffULL,
0x000000103400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000134347836ULL, 0x000fce0000000000ULL,
0x00000037460075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000010004527824ULL, 0x000fc800078e020bULL, 0x000000c052177836ULL, 0x000fca0000000000ULL,
0x0000006017157812ULL, 0x000fca00078ec0ffULL, 0x000000010a357824ULL, 0x000fe200078e0215ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x000000173a147248ULL, 0x000fe20007fe0000ULL,
0x0000001040157824ULL, 0x000fc800078e00ffULL, 0x0000000114147824ULL, 0x000fe200078e0a17ULL,
0x0000001015177812ULL, 0x000fe400078ec0ffULL, 0x00000003ff157819ULL, 0x000fe4000001160dULL,
0x0000001417147248ULL, 0x000fc60007fe0000ULL, 0x0000000415347836ULL, 0x000fe40000000000ULL,
0x0000000114147824ULL, 0x100fe400078e0a17ULL, 0x0000000815377836ULL, 0x000fe40000000000ULL,
0x0000000115167824ULL, 0x140fe200078e0217ULL, 0x000000141500720cULL, 0x080fe20003f86070ULL,
0x0000000c153c7836ULL, 0x002fe20000000000ULL, 0x000000143400720cULL, 0x0c0fe20003f66070ULL,
0x0000000134367824ULL, 0x100fe200078e0217ULL, 0x000000143700720cULL, 0x0c0fe20003f46070ULL,
0x0000000137587824ULL, 0x000fe200078e0217ULL, 0x000000143c00720cULL, 0x000fe20003f06070ULL,
0x0000000116157824ULL, 0x000fc400078e0235ULL, 0x0000000116347824ULL, 0x140fe400078e020dULL,
0x0000000816377824ULL, 0x000fe400078e00ffULL, 0x0000000136167824ULL, 0x040fe400078e020dULL,
0x00000008363d7824ULL, 0x000fe400078e00ffULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0xfffffff83d3e7812ULL, 0x000fe200078ee216ULL, 0x0000000136367824ULL, 0x000fe400078e0235ULL,
0x000000013c5a7824ULL, 0x000fe200078e0217ULL, 0xfffffff8373c7812ULL, 0x000fe200078ee234ULL,
0x0000000158167824ULL, 0x000fe200078e0235ULL, 0x0000004214177212ULL, 0x000fe200078efcffULL,
0x00000001583d7824ULL, 0x040fe400078e020dULL, 0x0000000858587824ULL, 0x000fe200078e00ffULL,
0x0000001756147210ULL, 0x000fe20007fbe0ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff858587812ULL, 0x000fe200078ee23dULL, 0x000000015a347824ULL, 0x000fe200078e0235ULL,
0x00000042363d7212ULL, 0x000fe200078efcffULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x00000042163f7212ULL, 0x000fc600078efcffULL,
0x0000000157157824ULL, 0x040fe200028e0615ULL, 0x0000003d56367210ULL, 0x000fe20007fbe0ffULL,
0x000000015a4f7824ULL, 0x000fe200078e020dULL, 0x00000042343d7212ULL, 0x000fe200078efcffULL,
0x000000085a5a7824ULL, 0x000fe400078e00ffULL, 0x0000000157377824ULL, 0x040fe200028e0637ULL,
0x0000003f56167210ULL, 0x000fe20007fbe0ffULL, 0x000000103e3f7824ULL, 0x100fe200078e0247ULL,
0x0000003d56347210ULL, 0x000fe20007fde0ffULL, 0x000000103c3d7824ULL, 0x000fe200078e0247ULL,
0xfffffff85a567812ULL, 0x000fe200078ee24fULL, 0x0000000157177824ULL, 0x000fc400028e0617ULL,
0x00000010584f7824ULL, 0x000fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000e101c46ULL, 0x0000000157357824ULL, 0x000fe400030e0635ULL,
0x0000001056537824ULL, 0x000fe200078e0247ULL, 0x00000000363f7faeULL, 0x0003e8000d901c46ULL,
0x00000000164f7faeULL, 0x0003e8000d101c46ULL, 0x0000000034537faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001040147824ULL, 0x000fca00078e00ffULL,
0x0000001014147812ULL, 0x000fc800078ec0ffULL, 0x000000140d167211ULL, 0x000fca00078fe8ffULL,
0x0000000416347836ULL, 0x000fe40000000000ULL, 0x0000000116147824ULL, 0x140fe400078e020dULL,
0x0000000816377824ULL, 0x000fe400078e00ffULL, 0x0000000134157824ULL, 0x040fe400078e020dULL,
0x00000008343e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8373c7812ULL, 0x002fe200078ee214ULL,
0x0000000816367836ULL, 0x000fc40000000000ULL, 0x0000000116147824ULL, 0x000fe200078e0235ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee215ULL, 0x0000000136177824ULL, 0x040fe400078e020dULL,
0x0000000836587824ULL, 0x000fe400078e00ffULL, 0x0000000c165a7836ULL, 0x000fe40000000000ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fc600078ee217ULL,
0x0000000134167824ULL, 0x100fe200078e0235ULL, 0x00000042143d7212ULL, 0x000fe200078efcffULL,
0x0000000136347824ULL, 0x100fe400078e0235ULL, 0x000000015a367824ULL, 0x040fe200078e0235ULL,
0x0000003d56147210ULL, 0x000fe20007f1e0ffULL, 0x000000015a3f7824ULL, 0x040fe400078e020dULL,
0x000000085a5a7824ULL, 0x000fe400078e00ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee23fULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x00000042164f7212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000042343f7212ULL, 0x080fe400078efcffULL, 0x0000004f56167210ULL, 0x000fe20007f5e0ffULL,
0x0000000157157824ULL, 0x040fe200000e0615ULL, 0x00000042363d7212ULL, 0x000fe200078efcffULL,
0x00000010584f7824ULL, 0x000fe200078e0247ULL, 0x0000003f56347210ULL, 0x000fe20007f1e0ffULL,
0x0000000157177824ULL, 0x000fe200010e0617ULL, 0x0000003d56367210ULL, 0x000fe20007f7e0ffULL,
0x000000103c3d7824ULL, 0x000fc400078e0247ULL, 0x000000103e3f7824ULL, 0x000fe400078e0247ULL,
0x0000000157357824ULL, 0x040fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e2000b901c46ULL, 0x0000000157377824ULL, 0x000fe400018e0637ULL,
0x000000105a537824ULL, 0x000fe200078e0247ULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x00000000344f7faeULL, 0x0003e8000b901c46ULL, 0x0000000036537faeULL, 0x0003e4000b901c46ULL,
0x000000020c0c7836ULL, 0x000fe20000000000ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff4f7424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000003b0c00720cULL, 0x000fca0003f06070ULL, 0x00000000ff0079b0ULL, 0x000ff00008000a45ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x000000010c178824ULL, 0x000fe400078e0205ULL,
0x0000000840167824ULL, 0x000fc400078e00ffULL, 0x0000000417148825ULL, 0x002fca00078e0014ULL,
0x00000006144f8981ULL, 0x000322000c1e1900ULL, 0xfffffff016177812ULL, 0x000fe200078ec0ffULL,
0x00000001ff167424ULL, 0x000fc800078e00ffULL, 0x0000000108567824ULL, 0x000fe200078e0217ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000816565679a7ULL, 0x000764000850003fULL,
0x017648164d1479a7ULL, 0x022664000850003fULL, 0x0000000000167805ULL, 0x008fce0000015200ULL,
0x017648154d0075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003416377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x017648154d0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002040147824ULL, 0x000fe400078e00ffULL,
0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010015147810ULL, 0x000fc80007ffe014ULL,
0x0000001445147210ULL, 0x000fca0007ffe042ULL, 0x0170000014167984ULL, 0x000e680000000800ULL,
0x0172000014177984ULL, 0x0006e20000000800ULL, 0x000000511600720bULL, 0x002fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x00cfea0003800000ULL, 0x0000000207157836ULL, 0x000fe20000000000ULL,
0x000000511600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000084015ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154537a210ULL, 0x000fe40007ffe042ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x0000000840167824ULL, 0x000fca00078e00ffULL,
0xfffffff016177812ULL, 0x000fc800078ec0ffULL, 0x0176a855170075a7ULL, 0x000e620008000148ULL,
0x0000000817377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176a855370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034147816ULL, 0x000fe200000000ffULL,
0x00013000494d7836ULL, 0x000fc60000000000ULL, 0x000000ff1400720cULL, 0x000fe20003f05270ULL,
0x000000104e347824ULL, 0x000fd800078e024dULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541000147816ULL, 0x000fca0000000000ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514007589ULL, 0x0002e400000e0000ULL,
0x012000004b14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000104c3c7824ULL, 0x000fe200078e024dULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000070d4c7812ULL, 0x000fe200078ec0ffULL, 0x0000000244497836ULL, 0x000fc60000000000ULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000084c4c7812ULL, 0x000fca00078ef80dULL,
0x000000084c4c7824ULL, 0x000fca00078e00ffULL, 0xfffffff84c497812ULL, 0x000fe400078ee249ULL,
0x00000010ff697819ULL, 0x022fe40000011635ULL, 0x0000ffff35667812ULL, 0x040fe400078ec0ffULL,
0x000000ff35557812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe40000011636ULL,
0x000000ff365c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011636ULL,
0x0000ffff365b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x000fe40000011634ULL,
0x00000010ff5a7819ULL, 0x100fe40000011637ULL, 0x000000ff375d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fc40000011637ULL, 0x0000ffff375f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x108fe4000001163cULL, 0x000000ff3c6d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001163cULL, 0x0000ffff3c367812ULL, 0x000fe400078ec0ffULL,
0x000000ff69697812ULL, 0x000fc400078ec0ffULL, 0x0000ffff34677812ULL, 0x000fe400078ec0ffULL,
0x00000010ff627819ULL, 0x100fe4000001163dULL, 0x000000ff3d6e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001163dULL, 0x0000ffff3d377812ULL, 0x000fe400078ec0ffULL,
0x00000008ff667819ULL, 0x000fc40000011666ULL, 0x00000018ff3d7819ULL, 0x000fe4000001163eULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001163fULL, 0x20000055ff657230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x00000069ff69723eULL, 0x000fc400020006ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000008ff677819ULL, 0x000fe40000011667ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x00000018ff537819ULL, 0x000fe40000011635ULL,
0x0000006bff55723eULL, 0x000fe200020006ffULL, 0x20000069ff6b7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x20000066ff697230ULL, 0x000fe20000004100ULL,
0x000000ff344b7812ULL, 0x000fe200078ec0ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe2000001163fULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000000ff3f4c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff3f597812ULL, 0x000fe200078ec0ffULL,
0x2000003cff3f7230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x2000003dff3c7230ULL, 0x000fe20000004100ULL, 0x00000008ff5f7819ULL, 0x000fe2000001165fULL,
0x2000006aff3d7230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000068ff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff687230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe2000001165bULL,
0x2000005aff677230ULL, 0x000fe20000004100ULL, 0x000000ff62637812ULL, 0x000fc400078ec0ffULL,
0x0000004bff64723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff4e7819ULL, 0x000fe40000011634ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000063ff5a723eULL, 0x000fe200020006ffULL, 0x2000005fff637230ULL, 0x000fe20000004100ULL,
0x00000008ff367819ULL, 0x000fe20000011636ULL, 0x2000005eff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x2000005bff627230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x2000005aff5e7230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000036ff5a723eULL, 0x000fe200020006ffULL,
0x2000004eff607230ULL, 0x000fe20000004100ULL, 0x00000037ff5b723eULL, 0x000fe200020006ffULL,
0x20000053ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011664ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe2000001166aULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff647819ULL, 0x000fc4000001166bULL, 0x00000010ff347819ULL, 0x000fe4000001163eULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000105464377816ULL, 0x000fe40000000065ULL, 0x000000ff34647812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff35657812ULL, 0x000fc400078ec0ffULL,
0x00000010ff357819ULL, 0x000fe20000011660ULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff347819ULL, 0x000fe40000011668ULL, 0x00000010ff607819ULL, 0x000fe40000011661ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fc40000000034ULL, 0x0000105460357816ULL, 0x000fe20000000069ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe4000001165cULL,
0x00000010ff377819ULL, 0x000fe40000011666ULL, 0x00000010ff607819ULL, 0x000fe2000001165dULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x0000ffff3e547812ULL, 0x000fc400078ec0ffULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x0000105467377816ULL, 0x000fe40000000060ULL, 0x00000008ff607819ULL, 0x000fe40000011654ULL,
0x00000010ff357819ULL, 0x000fe40000011658ULL, 0x00000010ff347819ULL, 0x000fe20000011662ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x000000ff3e4b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff547819ULL, 0x000fe40000011655ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x0000006dff4e723eULL, 0x000fe400020006ffULL, 0x0000006eff53723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x0000105454357816ULL, 0x000fe20000000063ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000006cff3e723eULL, 0x000fe200020006ffULL,
0x20000064ff5d7230ULL, 0x000fe20000004100ULL, 0x00000008ff597819ULL, 0x000fe40000011659ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000010ff367819ULL, 0x000fe2000001164eULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe20000011653ULL, 0x20000065ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fc4000001165fULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff347819ULL, 0x000fe4000001163fULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001164cULL, 0x00000010ff3f7819ULL, 0x000fe2000001165bULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff4c7819ULL, 0x000fe2000001165dULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x000010545f367816ULL, 0x000fe40000000036ULL,
0x000010545e377816ULL, 0x000fe40000000037ULL, 0x00001054343f7816ULL, 0x000fe4000000003fULL,
0x000010544c347816ULL, 0x000fe2000000004bULL, 0x00000200404b7824ULL, 0x000fe200078e00ffULL,
0x00000010ff357819ULL, 0x000fe2000001163eULL, 0x000000361424723cULL, 0x000fe20000041824ULL,
0x00000010ff3e7819ULL, 0x000fc4000001165aULL, 0x00000010ff537819ULL, 0x000fe4000001165cULL,
0x00001054353e7816ULL, 0x000fe4000000003eULL, 0x00000010ff377819ULL, 0x000fe4000001163cULL,
0x00000010ff367819ULL, 0x000fe40000011660ULL, 0x00000010ff3c7819ULL, 0x000fe2000001163dULL,
0x0000003e1420723cULL, 0x000fe20000041820ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0xfffff8004b4b7812ULL, 0x000fe400078ec0ffULL, 0x0000105453357816ULL, 0x000fe4000000004eULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x000010543c377816ULL, 0x000fe20000000059ULL,
0x000000084b3c7c36ULL, 0x000fe40008000000ULL, 0x00000034141c723cULL, 0x000fec000004181cULL,
0x000000361410723cULL, 0x000fe20000041810ULL, 0x0000001049347824ULL, 0x000fc400078e023cULL,
0x000000104a357824ULL, 0x000fc600078e024dULL, 0x012000003414783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x080fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000003534783bULL, 0x002e620000004200ULL, 0x00000010483c7824ULL, 0x000fcc00078e024dULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x00000010ff677819ULL, 0x002fe40000011634ULL,
0x0000ffff34657812ULL, 0x040fe400078ec0ffULL, 0x00000010ff667819ULL, 0x000fe40000011635ULL,
0x000000ff354b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fe40000011636ULL,
0x000000ff344a7812ULL, 0x000fc400078ec0ffULL, 0x000000ff36537812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011636ULL, 0x00000010ff607819ULL, 0x100fe40000011637ULL,
0x000000ff37597812ULL, 0x000fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011637ULL,
0x0000ffff36367812ULL, 0x000fc400078ec0ffULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff355d7812ULL, 0x000fe200078ec0ffULL,
0x2000004bff647230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe400020006ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000018ff687819ULL, 0x028fe2000001163cULL,
0x2000004aff637230ULL, 0x000fe20000004100ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000008ff367819ULL, 0x000fc40000011636ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x00000018ff487819ULL, 0x000fe40000011634ULL, 0x00000018ff697819ULL, 0x000fe4000001163dULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000018ff347819ULL, 0x000fc40000011635ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000008ff5d7819ULL, 0x000fe4000001165dULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000010ff617819ULL, 0x000fe4000001163cULL, 0x00000068ff4b723eULL, 0x000fe200020006ffULL,
0x20000067ff687230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x20000065ff677230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe200020006ffULL,
0x2000005cff657230ULL, 0x000fe20000004100ULL, 0x000000ff3c5a7812ULL, 0x000fe200078ec0ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000069ff4a723eULL, 0x000fe200020006ffULL, 0x20000066ff697230ULL, 0x000fe20000004100ULL,
0x00000034ff5e723eULL, 0x000fe200020006ffULL, 0x20000060ff667230ULL, 0x000fe20000004100ULL,
0x00000048ff5f723eULL, 0x000fe200020006ffULL, 0x20000036ff607230ULL, 0x000fe20000004100ULL,
0x0000ffff3c347812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe2000001163dULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff3d6a7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fc400020006ffULL, 0x00000010ff547819ULL, 0x100fe4000001163eULL,
0x000000ff3e6b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e487812ULL, 0x000fe400078ec0ffULL, 0x000000ff615c7812ULL, 0x000fe200078ec0ffULL,
0x20000037ff617230ULL, 0x000fe20000004100ULL, 0x0000005aff3e723eULL, 0x000fe200020006ffULL,
0x20000053ff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fc40000011663ULL,
0x00000010ff377819ULL, 0x000fe40000011668ULL, 0x0000006aff53723eULL, 0x000fe200020006ffULL,
0x2000005dff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x0000ffff3d357812ULL, 0x000fc400078ec0ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x00000062ff5d723eULL, 0x000fe200020006ffULL, 0x20000059ff5b7230ULL, 0x000fe20000004100ULL,
0x0000105469377816ULL, 0x000fe40000000064ULL, 0x00000008ff627819ULL, 0x000fe20000011634ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000008ff637819ULL, 0x000fc40000011635ULL,
0x00000010ff5f7819ULL, 0x000fe2000001165fULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff347819ULL, 0x000fe40000011667ULL,
0x00000010ff357819ULL, 0x000fe4000001166aULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fc400020006ffULL, 0x000010545f347816ULL, 0x000fe20000000034ULL,
0x2000004eff597230ULL, 0x000fe20000004100ULL, 0x000010545e357816ULL, 0x000fe20000000035ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe2000001165aULL,
0x2000003eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe4000001165bULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000105465367816ULL, 0x000fe40000000036ULL, 0x0000105466377816ULL, 0x000fe20000000037ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff347819ULL, 0x000fe20000011660ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff357819ULL, 0x000fc40000011661ULL,
0x00000010ff557819ULL, 0x000fe4000001163fULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000105459347816ULL, 0x000fe20000000034ULL,
0x20000062ff5b7230ULL, 0x000fe20000004100ULL, 0x0000105458357816ULL, 0x000fe20000000035ULL,
0x20000063ff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff54547812ULL, 0x000fc400078ec0ffULL,
0x000000ff3f6c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff55557812ULL, 0x000fe200078ec0ffULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000010ff367819ULL, 0x000fe4000001164eULL,
0x00000010ff377819ULL, 0x000fe4000001165cULL, 0x0000ffff3f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x000fc40000011653ULL, 0x00000010ff4e7819ULL, 0x000fe4000001165dULL,
0x00000018ff3d7819ULL, 0x000fe4000001163fULL, 0x0000006bff3e723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000006cff3f723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000010544e377816ULL, 0x000fe20000000053ULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000008ff4c7819ULL, 0x000fc4000001164cULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff4a7819ULL, 0x000fe2000001164aULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x00000010ff347819ULL, 0x000fe4000001165bULL,
0x00000010ff357819ULL, 0x000fe4000001165aULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000008ff487819ULL, 0x000fc40000011648ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x000010544b347816ULL, 0x000fe40000000034ULL,
0x000010544a357816ULL, 0x000fe20000000035ULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x00000010ff367819ULL, 0x000fe2000001163eULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe20000011654ULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff3f7819ULL, 0x000fe2000001163fULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff3e7819ULL, 0x000fc40000011655ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010543e377816ULL, 0x000fe4000000003fULL, 0x00000010ff347819ULL, 0x000fe4000001163dULL,
0x00000010ff3d7819ULL, 0x000fe4000001164cULL, 0x00000010ff357819ULL, 0x000fe2000001163cULL,
0x00000036141c723cULL, 0x000fe2000004181cULL, 0x00000010ff487819ULL, 0x000fc40000011648ULL,
0x00001054343d7816ULL, 0x000fe4000000003dULL, 0x0000000839347c11ULL, 0x000fe4000f8e18ffULL,
0x00001054353c7816ULL, 0x000fe20000000048ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000807367c11ULL, 0x000fc6000f8e18ffULL, 0x0176c837343479a7ULL, 0x0002e4000850003fULL,
0x0000003c1410723cULL, 0x000fe20000041810ULL, 0x0176983736ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035460075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035460075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000104157836ULL, 0x000fca0000000000ULL,
0x000000381500720cULL, 0x000fda0003f06070ULL, 0x0000000400e80947ULL, 0x000fea0003800000ULL,
0x00009000ff147b82ULL, 0x000ee20000000a00ULL, 0x0000000204177836ULL, 0x000fe20000000000ULL,
0x0000850000057ab9ULL, 0x000fe20000000800ULL, 0x0000010052357836ULL, 0x000fe40000000000ULL,
0x000000054f167c24ULL, 0x010fe2000f8e02ffULL, 0x000000381700720cULL, 0x000fe40003f06070ULL,
0x0000006035177812ULL, 0x000fe200078ec0ffULL, 0x0000008016377824ULL, 0x002fc800078e00ffULL,
0x000000010a3c7824ULL, 0x000fe400078e0217ULL, 0x0000008037147825ULL, 0x008fc800078e0014ULL,
0x0000000000f88947ULL, 0x000fea0003800000ULL, 0x000000353a167248ULL, 0x000fe20007fe0000ULL,
0x0000001040177824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc6000001160dULL,
0x0000000116167824ULL, 0x000fe200078e0a35ULL, 0x0000001017177812ULL, 0x000fe200078ec0ffULL,
0x0000000434367836ULL, 0x000fe40000000000ULL, 0x0000000834377836ULL, 0x000fe20000000000ULL,
0x0000001617167248ULL, 0x000fe20007fe0000ULL, 0x0000000c343e7836ULL, 0x000fe40000000000ULL,
0x0000000134357824ULL, 0x100fe400078e0217ULL, 0x0000000116167824ULL, 0x000fc400078e0a17ULL,
0x00000001373d7824ULL, 0x100fe400078e0217ULL, 0x000000013e4a7824ULL, 0x100fe200078e0217ULL,
0x000000163600720cULL, 0x0c0fe20003f66070ULL, 0x0000000136367824ULL, 0x000fe200078e0217ULL,
0x000000163400720cULL, 0x080fe20003f86070ULL, 0x0000000135347824ULL, 0x000fe200078e023cULL,
0x000000163700720cULL, 0x080fe20003f46070ULL, 0x0000000835377824ULL, 0x040fe200078e00ffULL,
0x000000163e00720cULL, 0x000fe20003f06070ULL, 0x0000000135167824ULL, 0x000fc400078e020dULL,
0x0000000136177824ULL, 0x140fe400078e020dULL, 0x0000000836467824ULL, 0x040fe200078e00ffULL,
0xfffffff8373e7812ULL, 0x000fe200078ee216ULL, 0x0000000136367824ULL, 0x000fe400078e023cULL,
0x000000013d357824ULL, 0x040fe200078e020dULL, 0xfffffff846467812ULL, 0x000fe200078ee217ULL,
0x000000083d487824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee235ULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000013d167824ULL, 0x100fe200078e023cULL, 0x00000042363d7212ULL, 0x080fe200078efcffULL,
0x000000014a3c7824ULL, 0x000fe200078e023cULL, 0x00000042343f7212ULL, 0x000fe200078efcffULL,
0x000000014a4b7824ULL, 0x040fe200078e020dULL, 0x0000003d14367210ULL, 0x000fe20007fde0ffULL,
0x000000084a4a7824ULL, 0x000fe200078e00ffULL, 0x0000003f14347210ULL, 0x000fe20007fbe0ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee24bULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x00000042164b7212ULL, 0x000fc600078efcffULL,
0x0000000115357824ULL, 0x040fe200028e0635ULL, 0x000000423c3f7212ULL, 0x000fe200078efcffULL,
0x0000000115377824ULL, 0x040fe200030e0637ULL, 0x0000004b14167210ULL, 0x000fe20007fbe0ffULL,
0x000000103e537824ULL, 0x100fe200078e024dULL, 0x0000003f14147210ULL, 0x000fe20007fde0ffULL,
0x0000001046557824ULL, 0x100fe400078e024dULL, 0x00000010483f7824ULL, 0x000fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034537faeULL, 0x0003e2000e101c46ULL,
0x0000000115177824ULL, 0x000fc400028e0617ULL, 0x000000104a4d7824ULL, 0x000fe200078e024dULL,
0x0000000036557faeULL, 0x0003e2000d901c46ULL, 0x0000000115157824ULL, 0x000fc600030e063dULL,
0x00000000163f7faeULL, 0x0003e8000d101c46ULL, 0x00000000144d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001040167824ULL, 0x000fca00078e00ffULL,
0x0000001016167812ULL, 0x000fc800078ec0ffULL, 0x000000160d177211ULL, 0x000fca00078fe8ffULL,
0x0000000117167824ULL, 0x040fe400078e023cULL, 0x0000000117347824ULL, 0x040fe400078e020dULL,
0x0000000817377824ULL, 0x000fe400078e00ffULL, 0x0000000417357836ULL, 0x000fe40000000000ULL,
0x00000008173d7836ULL, 0x000fe20000000000ULL, 0xfffffff8373e7812ULL, 0x000fe200078ee234ULL,
0x0000000c17467836ULL, 0x000fc40000000000ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000000135347824ULL, 0x140fe400078e023cULL, 0x0000000135377824ULL, 0x140fe400078e020dULL,
0x0000000835487824ULL, 0x000fe200078e00ffULL, 0x0000004216357212ULL, 0x000fe200078efcffULL,
0x000000013d367824ULL, 0x040fe400078e023cULL, 0x000000013d3f7824ULL, 0x040fe200078e020dULL,
0x0000003514167210ULL, 0x000fe20007f1e0ffULL, 0x000000083d4a7824ULL, 0x000fc400078e00ffULL,
0x00000001463d7824ULL, 0x040fe400078e020dULL, 0x00000008464c7824ULL, 0x040fe400078e00ffULL,
0x00000001463c7824ULL, 0x000fe200078e023cULL, 0xfffffff848467812ULL, 0x000fe200078ee237ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff84a487812ULL, 0x000fe400078ee23fULL,
0xfffffff84c4a7812ULL, 0x000fe200078ee23dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004234537212ULL, 0x000fc600078efcffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x00000042364b7212ULL, 0x000fc600078efcffULL, 0x0000000115177824ULL, 0x040fe200000e0617ULL,
0x000000423c3f7212ULL, 0x000fe200078efcffULL, 0x000000103e557824ULL, 0x100fe200078e024dULL,
0x0000005314347210ULL, 0x000fe20007f1e0ffULL, 0x0000001046597824ULL, 0x100fe200078e024dULL,
0x0000004b14367210ULL, 0x000fe20007f5e0ffULL, 0x00000010485b7824ULL, 0x000fe200078e024dULL,
0x0000003f14147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115357824ULL, 0x040fe200000e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016557faeULL, 0x0003e2000b901c46ULL,
0x0000000115377824ULL, 0x000fc400010e0637ULL, 0x000000104a4d7824ULL, 0x000fe200078e024dULL,
0x0000000034597faeULL, 0x0003e2000b901c46ULL, 0x0000000115157824ULL, 0x000fc600018e063dULL,
0x00000000365b7faeULL, 0x0003e8000b901c46ULL, 0x00000000144d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000008394a7c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x0176a8354a4a79a7ULL, 0x0002e4000850003fULL,
0x01766835063479a7ULL, 0x0022a4000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x01766835060075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01766835060075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000000807157c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fc600078e00ffULL, 0x0000018042147810ULL, 0x000fca0007ffe015ULL,
0x0000000145147824ULL, 0x000fca00078e0214ULL, 0x0170000014167984ULL, 0x000ea80000000800ULL,
0x0172000014177984ULL, 0x000b620000000800ULL, 0x000000511600720bULL, 0x004fda0003f1d000ULL,
0x0000000000157806ULL, 0x000fc800000e0100ULL, 0x0000ffff15357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x02afea0003800000ULL, 0x0000000307157836ULL, 0x000fe20000000000ULL,
0x000000511600720bULL, 0x000fc80003f14000ULL, 0x000000401500720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000084015ac11ULL, 0x000fe4000f8e38ffULL,
0x000000511614a209ULL, 0x000fe40007810000ULL, 0x000000154545a210ULL, 0x000fe40007ffe042ULL,
0x0000991034157816ULL, 0x000fc600000000ffULL, 0x017400144500a388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005116147209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005114147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400157308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1415147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000001550507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1415147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005116517209ULL, 0x000fd60007810000ULL,
0x8000005116160221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b16160820ULL, 0x000fc80000410000ULL, 0x0000001600020308ULL, 0x000ea40000000800ULL,
0x0000000217170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fe20000010000ULL,
0x00000008393d7c11ULL, 0x000fce000f8e20ffULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x0176b0573d0075a7ULL, 0x000e62000800017fULL, 0x0000000440167824ULL, 0x000fe400078e00ffULL,
0x0000000409357824ULL, 0x000fc600078e00ffULL, 0x0000000416167812ULL, 0x000fca00078ec0ffULL,
0x0000000216367836ULL, 0x000fc80000000000ULL, 0x000000ffff427224ULL, 0x000fe200078e0036ULL,
0x0000000000600947ULL, 0x002fec0003800000ULL, 0x000000ffff3c7224ULL, 0x000fce00078e00ffULL,
0x000000103c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013c3c7836ULL, 0x000fce0000000000ULL,
0x0176b0573d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ffff427224ULL, 0x000fce00078e0036ULL, 0x000000070d467812ULL, 0x040fe200078ec0ffULL,
0x0000000307167836ULL, 0x000fe20000000000ULL, 0x000000080d457812ULL, 0x040fe400078ec0ffULL,
0x0000991034157816ULL, 0x000fe400000000ffULL, 0x0000000846147812ULL, 0x000fe400078ef80dULL,
0x000000350d487211ULL, 0x000fe400078fe0ffULL, 0x00000046453d7212ULL, 0x000fe200078efcffULL,
0x0000000814177824ULL, 0x000fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fc60003f05270ULL,
0x000000013d147824ULL, 0x040fe200078e0248ULL, 0xfffffff817157812ULL, 0x000fe200078ee244ULL,
0x000000083d357824ULL, 0x000fe200078e00ffULL, 0x0000000816447c11ULL, 0x000fc8000f8e58ffULL,
0xfffffff835167812ULL, 0x000fe200078ee214ULL, 0x0000001015147824ULL, 0x000fc800078e0244ULL,
0x0000001016347824ULL, 0x000fe200078e0247ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff167819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000010ffULL,
0x0000000816367836ULL, 0x000fe20000000000ULL, 0x0000541000157816ULL, 0x000fca0000000000ULL,
0x00001f1615037589ULL, 0x0002a800000e0000ULL, 0x00001f3615007589ULL, 0x0002e400000e0000ULL,
0x011000001414783bULL, 0x002e620000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x086fe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000015157232ULL, 0x088fe40000200000ULL, 0x0000000017177232ULL, 0x000fce0000200000ULL,
0x000000420d427211ULL, 0x000fe200078fe0ffULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x0000001049497824ULL, 0x000fc600078e0244ULL, 0x000000013d3c7824ULL, 0x040fe400078e0242ULL,
0x000000083d3d7824ULL, 0x000fca00078e00ffULL, 0xfffffff83d3c7812ULL, 0x000fca00078ee23cULL,
0x000000103c3c7824ULL, 0x000fcc00078e0247ULL, 0x000000003c3c783bULL, 0x000f640000004200ULL,
0x00000018ff4c7819ULL, 0x128fe40000011634ULL, 0x000000ff36547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x000fe40000011634ULL, 0x000000ff344d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff34617812ULL, 0x000fc400078ec0ffULL, 0x000000ff37597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x100fe40000011635ULL, 0x000000ff35347812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011635ULL, 0x0000ffff35627812ULL, 0x000fe400078ec0ffULL,
0x0000004cff35723eULL, 0x000fc400020006ffULL, 0x00000018ff557819ULL, 0x000fe40000011637ULL,
0x00000010ff5a7819ULL, 0x104fe2000001163cULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x000000ff3c647812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001163cULL,
0x0000ffff3c5d7812ULL, 0x000fe400078ec0ffULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x00000059ff3c723eULL, 0x000fe400020006ffULL, 0x00000010ff607819ULL, 0x100fe40000011636ULL,
0x00000018ff527819ULL, 0x000fe40000011636ULL, 0x0000ffff36577812ULL, 0x000fe400078ec0ffULL,
0x000000ff3d667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x000fc4000001163fULL,
0x000000ff3f687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe4000001163fULL,
0x0000ffff3f537812ULL, 0x000fe400078ec0ffULL, 0x00000055ff3f723eULL, 0x000fe200020006ffULL,
0x20000054ff557230ULL, 0x000fe20000004100ULL, 0x00000008ff577819ULL, 0x000fe20000011657ULL,
0x2000003cff547230ULL, 0x000fe20000004100ULL, 0x00000066ff3c723eULL, 0x000fc400020006ffULL,
0x00000010ff587819ULL, 0x000fe40000011637ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL,
0x00000063ff66723eULL, 0x000fe200020006ffULL, 0x2000004eff597230ULL, 0x000fe20000004100ULL,
0x0000ffff37377812ULL, 0x000fe200078ec0ffULL, 0x2000003fff4e7230ULL, 0x000fe20000004100ULL,
0x00000034ff5c723eULL, 0x000fc400020006ffULL, 0x00000010ff5e7819ULL, 0x100fe4000001163dULL,
0x00000018ff657819ULL, 0x000fe2000001163dULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000ffff3d5f7812ULL, 0x000fe400078ec0ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000010ff567819ULL, 0x000fe4000001163eULL, 0x000000ff3e677812ULL, 0x000fc400078ec0ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001163eULL, 0x0000ffff3e347812ULL, 0x000fe400078ec0ffULL,
0x00000052ff3e723eULL, 0x000fe400020006ffULL, 0x0000004aff63723eULL, 0x000fe200020006ffULL,
0x20000066ff4a7230ULL, 0x000fe20000004100ULL, 0x00000064ff52723eULL, 0x000fe200020006ffULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000008ff377819ULL, 0x000fe20000011637ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff44647812ULL, 0x000fe200078ec0ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x000000ff5a667812ULL, 0x000fe200078ec0ffULL,
0x20000057ff5a7230ULL, 0x000fe20000004100ULL, 0x0000004cff3f723eULL, 0x000fc400020006ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x00000065ff4c723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff58587812ULL, 0x000fe400078ec0ffULL,
0x00000008ff577819ULL, 0x000fe2000001165dULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x0000003dff65723eULL, 0x000fe400020006ffULL, 0x00000037ff37723eULL, 0x000fc400020006ffULL,
0x00000008ff5f7819ULL, 0x000fe2000001165fULL, 0x20000065ff447230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000037ff5d7230ULL, 0x000fe20000004100ULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000064ff657230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000004dff5b7230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000061ff647230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000058ff617230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff627819ULL, 0x000fe40000011662ULL,
0x000000ff56377812ULL, 0x000fe200078ec0ffULL, 0x20000057ff567230ULL, 0x000fe20000004100ULL,
0x0000005eff58723eULL, 0x000fe200020006ffULL, 0x2000005fff577230ULL, 0x000fe20000004100ULL,
0x000000ff60607812ULL, 0x000fe200078ec0ffULL, 0x20000066ff5e7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000037ff5f723eULL, 0x000fc400020006ffULL, 0x000000ff36667812ULL, 0x000fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe4000001165cULL,
0x00000010ff367819ULL, 0x000fe2000001165bULL, 0x2000005fff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff5c7819ULL, 0x000fe40000011665ULL,
0x00000060ff60723eULL, 0x000fc400020006ffULL, 0x0000105463367816ULL, 0x000fe40000000036ULL,
0x000010545c377816ULL, 0x000fe20000000037ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000008ff5c7819ULL, 0x000fe40000011634ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff347819ULL, 0x000fe20000011664ULL, 0x000000361418723cULL, 0x002fe20000041818ULL,
0x00000010ff5f7819ULL, 0x000fc40000011659ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x000010545f357816ULL, 0x000fe40000000062ULL,
0x00000010ff367819ULL, 0x000fe40000011655ULL, 0x00000010ff377819ULL, 0x000fe40000011660ULL,
0x00000008ff5f7819ULL, 0x000fe20000011653ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff547819ULL, 0x000fc40000011654ULL, 0x00000010ff617819ULL, 0x000fe40000011661ULL,
0x00000067ff4d723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe20000000036ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x2000005cff537230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000068ff3d7230ULL, 0x000fe20000004100ULL, 0x0000105461377816ULL, 0x000fe20000000054ULL,
0x20000066ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe2000001163eULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe4000001165aULL,
0x00000010ff4e7819ULL, 0x000fe2000001164eULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff3e7819ULL, 0x000fc40000011652ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff557819ULL, 0x000fe4000001165eULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010544e357816ULL, 0x000fe4000000005dULL, 0x00001054553e7816ULL, 0x000fe4000000003eULL,
0x00000010ff377819ULL, 0x000fc4000001163fULL, 0x00000010ff3c7819ULL, 0x000fe2000001163cULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000010ff367819ULL, 0x000fe4000001164cULL,
0x00000010ff4e7819ULL, 0x000fe4000001164dULL, 0x00000010ff3f7819ULL, 0x000fe40000011658ULL,
0x00000010ff557819ULL, 0x000fe40000011644ULL, 0x00000010ff527819ULL, 0x000fc40000011653ULL,
0x00000010ff4c7819ULL, 0x000fe40000011656ULL, 0x00000010ff4d7819ULL, 0x000fe40000011657ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff447819ULL, 0x000fe40000011659ULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff537819ULL, 0x000fe4000001165fULL, 0x000010543f3f7816ULL, 0x000fe4000000003cULL,
0x00001054374c7816ULL, 0x000fe4000000004cULL, 0x00001054364d7816ULL, 0x000fe4000000004dULL,
0x000010545b3c7816ULL, 0x000fe2000000004eULL, 0x011000004934783bULL, 0x0002a20000000200ULL,
0x00001054443d7816ULL, 0x000fe2000000003dULL, 0x0000003e1424723cULL, 0x000fe20000041824ULL,
0x0000105455527816ULL, 0x000fc40000000052ULL, 0x000010544a537816ULL, 0x000fc60000000053ULL,
0x0000004c1420723cULL, 0x000fec0000041820ULL, 0x0000003c141c723cULL, 0x000fec000004181cULL,
0x000000521410723cULL, 0x000fe20000041810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000100947ULL, 0x002fde0003800000ULL, 0x0000000334347232ULL, 0x084fe40000200000ULL,
0x0000000336367232ULL, 0x000fe40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x0000001045457812ULL, 0x000fe200078efe46ULL,
0x0000000104047836ULL, 0x000fc80000000000ULL, 0x0000000145487824ULL, 0x040fe400078e0248ULL,
0x0000000845157824ULL, 0x040fe400078e00ffULL, 0x0000000145427824ULL, 0x040fe400078e0242ULL,
0x0000000845457824ULL, 0x000fe200078e00ffULL, 0xfffffff815487812ULL, 0x000fc800078ee248ULL,
0xfffffff845427812ULL, 0x000fe200078ee242ULL, 0x0000001048147824ULL, 0x000fc800078e0247ULL,
0x00000010423c7824ULL, 0x000fe400078e0247ULL, 0x000000001414783bULL, 0x000e680000004200ULL,
0x000000003c3c783bULL, 0x000ee20000004200ULL, 0x00000010ff5d7819ULL, 0x002fe40000011614ULL,
0x0000ffff145b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5e7819ULL, 0x000fc40000011615ULL,
0x00000018ff447819ULL, 0x000fe40000011614ULL, 0x00000010ff5a7819ULL, 0x100fe40000011616ULL,
0x000000ff16487812ULL, 0x000fe400078ec0ffULL, 0x00000018ff477819ULL, 0x000fe40000011616ULL,
0x000000ff14427812ULL, 0x000fe400078ec0ffULL, 0x0000ffff16167812ULL, 0x000fc400078ec0ffULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x100fe40000011617ULL,
0x000000ff174d7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4c7819ULL, 0x000fe40000011617ULL,
0x000000ff15147812ULL, 0x040fe400078ec0ffULL, 0x0000ffff155c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff17177812ULL, 0x000fe400078ec0ffULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x00000018ff457819ULL, 0x000fe40000011615ULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x00000042ff57723eULL, 0x000fe200020006ffULL, 0x20000044ff547230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff167819ULL, 0x000fe20000011616ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000018ff5f7819ULL, 0x008fe2000001163cULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000014ff58723eULL, 0x000fc400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff5c7819ULL, 0x000fe2000001165cULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff177819ULL, 0x000fe40000011617ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fc400020006ffULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x20000045ff557230ULL, 0x000fe20000004100ULL, 0x00000018ff607819ULL, 0x000fe4000001163dULL,
0x0000005fff44723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005cff5f723eULL, 0x000fe200020006ffULL, 0x2000005bff5c7230ULL, 0x000fe20000004100ULL,
0x00000017ff17723eULL, 0x000fe200020006ffULL, 0x2000005aff5b7230ULL, 0x000fe20000004100ULL,
0x0000ffff3c157812ULL, 0x000fe200078ec0ffULL, 0x20000016ff5a7230ULL, 0x000fe20000004100ULL,
0x00000060ff45723eULL, 0x000fe200020006ffULL, 0x20000059ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe20000011657ULL, 0x20000017ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000ffff3d147812ULL, 0x000fe200078ec0ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000008ff157819ULL, 0x000fe20000011615ULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fc4000001163cULL, 0x00000010ff177819ULL, 0x000fe40000011658ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x000000ff3c527812ULL, 0x000fe400078ec0ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x000010545d167816ULL, 0x000fe20000000016ULL, 0x20000048ff4e7230ULL, 0x000fe20000004100ULL,
0x00000015ff57723eULL, 0x000fc400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe40000011614ULL,
0x000000ff56567812ULL, 0x000fe400078ec0ffULL, 0x000010545e177816ULL, 0x000fe40000000017ULL,
0x00000010ff157819ULL, 0x000fe20000011654ULL, 0x20000057ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe4000001165cULL, 0x00000010ff537819ULL, 0x000fe2000001163dULL,
0x000000163418723cULL, 0x004fe20000041818ULL, 0x000000ff3d617812ULL, 0x000fc400078ec0ffULL,
0x00000010ff587819ULL, 0x000fe40000011655ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x00000052ff3d723eULL, 0x000fe200020006ffULL, 0x2000004dff527230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe400020006ffULL, 0x0000004cff3c723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000047ff4c7230ULL, 0x000fe20000004100ULL,
0x0000105415147816ULL, 0x000fe20000000014ULL, 0x2000003cff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe2000001163eULL, 0x2000003dff477230ULL, 0x000fe20000004100ULL,
0x00000061ff48723eULL, 0x000fc400020006ffULL, 0x0000105458157816ULL, 0x000fe4000000005fULL,
0x000000ff53617812ULL, 0x000fe200078ec0ffULL, 0x20000056ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe2000001164eULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe20000011652ULL, 0x000000143428723cULL, 0x000fe20000041828ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x00000061ff56723eULL, 0x000fe400020006ffULL,
0x000010545b167816ULL, 0x000fe40000000016ULL, 0x0000105460177816ULL, 0x000fe20000000017ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000004aff4e723eULL, 0x000fe400020006ffULL,
0x00000010ff157819ULL, 0x000fc4000001164cULL, 0x00000010ff147819ULL, 0x000fe2000001165aULL,
0x00000016342c723cULL, 0x000fe2000004182cULL, 0x00000010ff4a7819ULL, 0x000fe2000001164dULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x000000ff3e637812ULL, 0x000fe200078ec0ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000018ff627819ULL, 0x000fc4000001163eULL, 0x0000ffff3e467812ULL, 0x000fe400078ec0ffULL,
0x00000010ff497819ULL, 0x000fe4000001163fULL, 0x000010544a157816ULL, 0x000fe40000000059ULL,
0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff167819ULL, 0x000fe40000011647ULL,
0x00000010ff177819ULL, 0x000fe20000011648ULL, 0x000000143430723cULL, 0x000fe20000041830ULL,
0x00000010ff537819ULL, 0x000fc40000011653ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000018ff647819ULL, 0x000fe4000001163fULL, 0x0000ffff3f427812ULL, 0x000fe400078ec0ffULL,
0x00000063ff3f723eULL, 0x000fe400020006ffULL, 0x000000ff49497812ULL, 0x000fe400078ec0ffULL,
0x0000003eff3e723eULL, 0x000fe200020006ffULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x0000105453167816ULL, 0x000fc40000000016ULL, 0x0000105456177816ULL, 0x000fe20000000017ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe400020006ffULL,
0x00000008ff477819ULL, 0x000fe40000011642ULL, 0x00000010ff157819ULL, 0x000fe20000011644ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000010ff147819ULL, 0x000fe20000011654ULL,
0x000000163424723cULL, 0x000fe20000041824ULL, 0x00000010ff427819ULL, 0x000fc40000011645ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x0000105415147816ULL, 0x000fe40000000014ULL,
0x0000105442157816ULL, 0x000fe4000000005dULL, 0x00000010ff167819ULL, 0x000fe4000001163fULL,
0x00000010ff3f7819ULL, 0x000fe2000001163eULL, 0x00000004393e7836ULL, 0x000fe20000000000ULL,
0x00000010ff177819ULL, 0x000fe2000001164eULL, 0x000000143420723cULL, 0x000fe20000041820ULL,
0x00000010ff427819ULL, 0x000fc40000011649ULL, 0x0000105417167816ULL, 0x000fe40000000016ULL,
0x0000105442177816ULL, 0x000fe2000000003fULL, 0x00000001ff3f7424ULL, 0x000fe200078e00ffULL,
0x000000083e147c11ULL, 0x000fe4000f8e18ffULL, 0x00000008ff467819ULL, 0x000fe40000011646ULL,
0x00000062ff3d723eULL, 0x000fe200020006ffULL, 0x00000016341c723cULL, 0x000fe2000004181cULL,
0x0176a83f141479a7ULL, 0x000e62000850003fULL, 0x00000064ff3c723eULL, 0x000fc400020006ffULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe40000004100ULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x000fe2000001163dULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff467819ULL, 0x000fc40000011646ULL, 0x00000010ff477819ULL, 0x000fe40000011647ULL,
0x000010543d467816ULL, 0x000fe40000000046ULL, 0x000010543c477816ULL, 0x000fe40000000047ULL,
0x0000000807147c11ULL, 0x002fca000f8e18ffULL, 0x000000463410723cULL, 0x000fe20000041810ULL,
0x0176a03f14ff79a7ULL, 0x0003ec000850003fULL, 0x000000ffff347224ULL, 0x000fe200078e0015ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0xffffff5000ec9947ULL, 0x000fde000383ffffULL,
0x000000ff3800720cULL, 0x000fe20003f05270ULL, 0x000000ffff167224ULL, 0x000fe400078e0025ULL,
0x000000ffff357224ULL, 0x000fe400078e0024ULL, 0x000000ffff257224ULL, 0x000fe400078e001bULL,
0x000000ffff247224ULL, 0x000fe400078e001aULL, 0x000000ffff1b7224ULL, 0x000fc800078e0019ULL,
0x0000000000d48947ULL, 0x000fea0003800000ULL, 0x0180000050007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000ca2000047802ULL, 0x000fce0000000f00ULL, 0x0000008c00007944ULL, 0x016fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005000037308ULL, 0x002e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000050ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009a00ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f0700047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea200000e0000ULL,
0x0000001804187220ULL, 0x042fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x000fe20000410000ULL,
0x0000002405247220ULL, 0x044fe20000410000ULL, 0x0000002505257220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001305137220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x000000202120723eULL, 0x000fe400000010ffULL,
0x0000001c1d1c723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000101110723eULL, 0x000fc400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fe400000010ffULL,
0x000000ff3900720cULL, 0x000fc40003f05270ULL, 0x00000002ff057819ULL, 0x108fe20000011600ULL,
0x000000010b0b7824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x042fe400078ec0ffULL,
0x0000000800077811ULL, 0x000fe200078ff0ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x040fe400078ff8ffULL, 0x0000000702047211ULL, 0x000fe200078ff8ffULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000000805077824ULL, 0x000fc400078e00ffULL,
0x0000000203027836ULL, 0x000fe20000000000ULL, 0xfffffff80d147812ULL, 0x000fe200078ee204ULL,
0x0000000805047824ULL, 0x040fe400078e00ffULL, 0x00000008050d7824ULL, 0x000fe200078e00ffULL,
0xfffffff807087812ULL, 0x000fe200078ee202ULL, 0x0000000403067836ULL, 0x000fe20000000000ULL,
0x0000000809027c11ULL, 0x000fe2000f8e60ffULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x0000000800057824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee206ULL, 0x0000080039037824ULL, 0x100fe200078e0202ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x0000000805067812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x100fe200078e0203ULL,
0x000000282904723eULL, 0x000fe200000010ffULL, 0x0000001014197824ULL, 0x000fc400078e0203ULL,
0x00000010080d7824ULL, 0x100fe400078e0203ULL, 0x000000100a157824ULL, 0x100fe400078e0203ULL,
0x000000100c177824ULL, 0x000fe200078e0203ULL, 0x000000181b03723eULL, 0x000fe200000010ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x000000351605723eULL, 0x000fe200000010ffULL,
0x0000000106197824ULL, 0x040fe200078e0219ULL, 0x00005410031a7816ULL, 0x140fe20000000004ULL,
0x00000001060d7824ULL, 0x040fe200078e020dULL, 0x00007632031b7816ULL, 0x000fe20000000004ULL,
0x0000000106157824ULL, 0x040fe200078e0215ULL, 0x0000002c2d03723eULL, 0x000fe200000010ffULL,
0x0000000106067824ULL, 0x000fe200078e0217ULL, 0x000000303104723eULL, 0x000fe200000010ffULL,
0x0000001a07007388ULL, 0x0003e20000000a00ULL, 0x000054101e0c7816ULL, 0x000fc40000000012ULL,
0x0000541003167816ULL, 0x140fe40000000004ULL, 0x0000763203177816ULL, 0x000fe40000000004ULL,
0x000000242503723eULL, 0x000fe400000010ffULL, 0x0000002a2b04723eULL, 0x000fe200000010ffULL,
0x000000160d007388ULL, 0x0007e20000000a00ULL, 0x00005410051a7816ULL, 0x142fe40000000020ULL,
0x00007632051b7816ULL, 0x000fc40000000020ULL, 0x0000763203117816ULL, 0x000fe40000000004ULL,
0x0000763226057816ULL, 0x000fe20000000022ULL, 0x0000001a15007388ULL, 0x0003e20000000a00ULL,
0x000000323317723eULL, 0x008fc800000010ffULL, 0x000054102e167816ULL, 0x140fe40000000017ULL,
0x000076322e177816ULL, 0x000fe40000000017ULL, 0x000054101c1a7816ULL, 0x142fe40000000010ULL,
0x000076321c1b7816ULL, 0x000fe40000000010ULL, 0x0000541003107816ULL, 0x000fe40000000004ULL,
0x0000541026047816ULL, 0x000fe20000000022ULL, 0x0000001a06007388ULL, 0x000fe20000000a00ULL,
0x000000ff00037306ULL, 0x000e660000202400ULL, 0x0000001019007388ULL, 0x000fe80000000a00ULL,
0x000400160d007388ULL, 0x0007e80000000a00ULL, 0x0004000415007388ULL, 0x000fe20000000a00ULL,
0x000076321e0d7816ULL, 0x008fca0000000012ULL, 0x0004000c06007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000b107984ULL, 0x000e680000000c00ULL,
0x000400000b1c7984ULL, 0x000ee80000000c00ULL, 0x000800000b187984ULL, 0x000f680000000c00ULL,
0x000c00000b207984ULL, 0x000f620000000c00ULL, 0x0000001303137230ULL, 0x002fc40000200800ULL,
0x0000001203127230ULL, 0x040fe40000200800ULL, 0x0000001103117230ULL, 0x040fe40000200800ULL,
0x0000001003107230ULL, 0x040fe40000200800ULL, 0x0000001f031f7230ULL, 0x048fe40000200800ULL,
0x0000001e031e7230ULL, 0x040fe40000200800ULL, 0x0000001d031d7230ULL, 0x000fc40000200800ULL,
0x0000001c03037230ULL, 0x000fe40000200800ULL, 0x0000001b13137230ULL, 0x024fe40000200000ULL,
0x0000001a12127230ULL, 0x000fe40000200000ULL, 0x0000001911117230ULL, 0x000fe40000200000ULL,
0x0000001810107230ULL, 0x000fe40000200000ULL, 0x000000231f1f7230ULL, 0x000fc40000200000ULL,
0x000000221e1e7230ULL, 0x000fe20000200000ULL, 0x000000100b007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000200000ULL, 0x00000020031c7230ULL, 0x000fca0000200000ULL,
0x0004001c0b007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x0000000f0600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000800087d06ULL, 0x000ea20008209000ULL, 0x00000008ff0b7c12ULL, 0x002fe2000f8e33ffULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x004e640000001000ULL, 0x0ffffffe080a7836ULL, 0x002fcc0000000000ULL,
0x0000000a00057305ULL, 0x0002a4000021f000ULL, 0x00000007000a7812ULL, 0x002fe200078ec0ffULL,
0x000000ffff037224ULL, 0x004fc800078e0a05ULL, 0x0000000803037c24ULL, 0x000fc8000f8e02ffULL,
0x00000003050c7227ULL, 0x000fc800078e0004ULL, 0x0000000141037824ULL, 0x000fc800078e0206ULL,
0x000000030c077227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a07ULL,
0x0000000804057c24ULL, 0x000fe4000f8e0203ULL, 0x0000000106047824ULL, 0x000fc600078e0200ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000107070836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000006107984ULL, 0x0002a40000000c00ULL,
0x000000070b047207ULL, 0x000fca0004000000ULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x0000000904047c24ULL, 0x000fe4000f8e0243ULL, 0x0000000808037c24ULL, 0x000fe4000f8e0203ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000804037c24ULL, 0x000fca000f8e0203ULL,
0x000000030e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x0000000403047c11ULL, 0x000fc8000f8240ffULL, 0x0000000503057c11ULL, 0x000fe200088f4408ULL,
0x0000000809037824ULL, 0x000fe200078e020aULL, 0x00000003ff087819ULL, 0x000fc60000011606ULL,
0x0000001003047825ULL, 0x000fe200078e0004ULL, 0x0000000f0800720cULL, 0x000fc80003f26070ULL,
0x0000001004007986ULL, 0x0043f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000141037824ULL, 0x100fe400078e0208ULL, 0x0000000106087824ULL, 0x000fe400078e0208ULL,
0x000000030c047227ULL, 0x002fc800078e00ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e0a04ULL,
0x000000080a057c24ULL, 0x000fca000f8e0203ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000104041836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0000000708057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef806ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001005077824ULL, 0x000fe400078e0202ULL, 0x0000000104042836ULL, 0x000fc60000000000ULL,
0x0000000007107984ULL, 0x0002a40000000c00ULL, 0x000000040b047207ULL, 0x000fca0004000000ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x0000000904047c24ULL, 0x000fe4000f8e0243ULL,
0x0000000808037c24ULL, 0x000fe4000f8e0203ULL, 0x0000004000077836ULL, 0x002fe40000000000ULL,
0x0000000804037c24ULL, 0x000fca000f8e0203ULL, 0x000000030e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x0000000403047c11ULL, 0x000fc8000f8240ffULL,
0x0000000503057c11ULL, 0x000fe200088f4408ULL, 0x0000000809037824ULL, 0x000fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fc60000011607ULL, 0x0000001003047825ULL, 0x000fe200078e0004ULL,
0x0000000f0600720cULL, 0x000fc80003f26070ULL, 0x0000001004007986ULL, 0x0043f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000141037824ULL, 0x100fe400078e0206ULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x000000030c047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x0000006000007836ULL, 0x000fe40000000000ULL, 0x0000000808057c24ULL, 0x000fca000f8e0203ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000104041836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006107984ULL, 0x0002a20000000c00ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x000000040b047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011600ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x0000000904047c24ULL, 0x000fe4000f8e0243ULL,
0x0000000808037c24ULL, 0x000fe2000f8e0203ULL, 0x0000000707087812ULL, 0x000fe200078ec0ffULL,
0x0000000141417824ULL, 0x000fe400078e0206ULL, 0x0000000804037c24ULL, 0x000fca000f8e0203ULL,
0x000000030e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000403047c11ULL, 0x000fc8000f8240ffULL, 0x0000000503057c11ULL, 0x000fe200088f440aULL,
0x0000000809037824ULL, 0x000fe200078e0208ULL, 0x0000000f0600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000001004007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000410c087227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x002fe400078e0a08ULL, 0x0000000100067824ULL, 0x000fe400078e0206ULL,
0x0000000804037c24ULL, 0x000fca000f8e0241ULL, 0x0000000803007c0cULL, 0x000fda000bf26070ULL,
0x8000000803031c36ULL, 0x000fe40008000000ULL, 0x0000000108081836ULL, 0x000fc60000000000ULL,
0x0000000803007c0cULL, 0x000fe4000bf46070ULL, 0x0000000706037812ULL, 0x000fc800078ec0ffULL,
0xfffffff803037812ULL, 0x000fe400078ef800ULL, 0x0000000700007812ULL, 0x000fc600078ec0ffULL,
0x0000001003047824ULL, 0x000fe400078e0202ULL, 0x0000000108082836ULL, 0x000fe40000000000ULL,
0x0000000809097824ULL, 0x000fe400078e0200ULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x000000080b087207ULL, 0x000fca0004000000ULL, 0x000000ffff027224ULL, 0x000fe400078e0a08ULL,
0x0000000908087c24ULL, 0x000fe4000f8e0243ULL, 0x0000000802417c24ULL, 0x000fc8000f8e0241ULL,
0x0000000808417c24ULL, 0x000fca000f8e0241ULL, 0x000000410e417210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000441027c11ULL, 0x000fc8000f8040ffULL,
0x0000000541037c11ULL, 0x000fc600080f4408ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0c7819ULL, 0x000fe20000011640ULL, 0x00009a00ff0a7b82ULL, 0x000e620000000a00ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x0000003b0c00720cULL, 0x000fe20003f06070ULL,
0xffffffffff0f7424ULL, 0x000fc600078e00ffULL, 0x01760006ff0679a7ULL, 0x000eb20008500008ULL,
0x00009600ff048b82ULL, 0x000ee20000000800ULL, 0x0000000214058824ULL, 0x000fce00078e00ffULL,
0x00009200ff108b82ULL, 0x000f620000000a00ULL, 0x000000060a0a7981ULL, 0x002522000c1e9900ULL,
0x0000000405058224ULL, 0x008fc800078e020cULL, 0x0000000405108825ULL, 0x020fe400078e0010ULL,
0x00009000ff047b82ULL, 0x000e660000000a00ULL, 0x00000006100f8981ULL, 0x000ee2000c1e1900ULL,
0x000001ff0900780cULL, 0x000fe20003f04070ULL, 0x0000008000007824ULL, 0x000fe400078e00ffULL,
0x0000008043437824ULL, 0x000fe400078e00ffULL, 0x0000004040097824ULL, 0x000fca00078e00ffULL,
0x00000040430e7812ULL, 0x000fe200078ef809ULL, 0x0000000f000f7224ULL, 0x008fc800078e02ffULL,
0x000000800f047825ULL, 0x002fe200078e0004ULL, 0x0000000c00200947ULL, 0x004fec0003800000ULL,
0x00000003ff247819ULL, 0x000fe4000001160dULL, 0x000000093a107248ULL, 0x000fc60007fe0000ULL,
0x0000000824167836ULL, 0x000fe40000000000ULL, 0x0000000424127836ULL, 0x000fe40000000000ULL,
0x00000001100b7824ULL, 0x000fe400078e0a09ULL, 0x0000000116117824ULL, 0x040fe400078e020dULL,
0x00000008162c7824ULL, 0x000fe200078e00ffULL, 0x0000000b1200720cULL, 0x000fe20003fa6070ULL,
0x000000010e107824ULL, 0x000fc400078e0224ULL, 0x00000001120f7824ULL, 0x040fe200078e020dULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee211ULL, 0x00000008122a7824ULL, 0x000fe400078e00ffULL,
0x000000010e127824ULL, 0x000fe400078e0212ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fc600078ee20fULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000007010237812ULL, 0x000fc600078ef802ULL, 0x0000001024187836ULL, 0x000fe20000000000ULL,
0x0000007012157812ULL, 0x000fe200078ef802ULL, 0x0000000c241a7836ULL, 0x000fe20000000000ULL,
0x0000002304227210ULL, 0x000fe20007f1e0ffULL, 0x0000000118287824ULL, 0x040fe200078e020dULL,
0x0000001504107210ULL, 0x000fe20007f3e0ffULL, 0x0000000818177824ULL, 0x000fe200078e00ffULL,
0x0000000b1a00720cULL, 0x080fe20003f46070ULL, 0x0000000105237824ULL, 0x040fe200000e0611ULL,
0x0000000b1800720cULL, 0x080fe20003f06070ULL, 0x0000000105117824ULL, 0x000fe200008e0613ULL,
0x0000000b1600720cULL, 0x000fe20003f26070ULL, 0x000000010e127824ULL, 0x040fe200078e0216ULL,
0xfffffff817287812ULL, 0x000fe200078ee228ULL, 0x000000010e167824ULL, 0x000fc400078e021aULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000010e187824ULL, 0x000fe200078e0218ULL,
0x00000070121f7812ULL, 0x000fe200078ef802ULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0x0000001f041e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001424267836ULL, 0x000fe20000000000ULL,
0x00000070161d7812ULL, 0x000fe200078ef802ULL, 0x000000011a0f7824ULL, 0x040fe400078e020dULL,
0x000000081a2e7824ULL, 0x000fe200078e00ffULL, 0x0000001d041c7210ULL, 0x000fe20007f9e0ffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x0000001824327836ULL, 0x000fe20000000000ULL, 0x00000070180f7812ULL, 0x000fe200078ef802ULL,
0x000000010e1a7824ULL, 0x040fe400078e0226ULL, 0x000000010e207824ULL, 0x000fe400078e0232ULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x00000001051f7824ULL, 0x000fe200018e0613ULL,
0x0000000f04187210ULL, 0x000fe20007f7e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x00000008400f7c11ULL, 0x000fc6000f8e70ffULL, 0x00000001051d7824ULL, 0x040fe200020e0617ULL,
0x000000701a177812ULL, 0x000fe200078ef802ULL, 0x0000001c24347836ULL, 0x000fe20000000000ULL,
0x0000007020137812ULL, 0x000fe200078ef802ULL, 0x0000000105197824ULL, 0x040fe200018e0619ULL,
0x0000001704167210ULL, 0x000fe20007f7e0ffULL, 0x000000010e1a7824ULL, 0x000fe200078e0234ULL,
0x0000001304127210ULL, 0x000fe20007f9e0ffULL, 0x0000000124157824ULL, 0x000fe400078e020dULL,
0x0000000105177824ULL, 0x000fe200018e061bULL, 0x0000000b2600720cULL, 0x000fe20003f66070ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000715207812ULL, 0x000fc600078ec0ffULL,
0x0000002024367836ULL, 0x000fe40000000000ULL, 0x0000000105137824ULL, 0x000fe200020e0621ULL,
0x0000000b2400720cULL, 0x000fe20003f86070ULL, 0x0000000126157824ULL, 0x040fe200078e020dULL,
0x000000701a217812ULL, 0x000fe200078ef802ULL, 0x0000000826307824ULL, 0x000fe200078e00ffULL,
0x0ffffff820267812ULL, 0x000fe200078ef80dULL, 0x000000010e207824ULL, 0x000fe200078e0236ULL,
0x00000021041a7210ULL, 0x000fe20007fde0ffULL, 0x000010000f0f7836ULL, 0x000fe20000000000ULL,
0xfffffff830307812ULL, 0x000fe200078ee215ULL, 0x0000008020207825ULL, 0x000fc800078e00ffULL,
0x0000001026157824ULL, 0x000fe200078e020fULL, 0x0000007020277812ULL, 0x000fe200078ef802ULL,
0x00000024243c7836ULL, 0x000fe40000000000ULL, 0x00000001051b7824ULL, 0x000fe200030e061bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022157faeULL, 0x0003e2000e101c46ULL,
0x000000010e267824ULL, 0x000fe200078e023cULL, 0x0000000b3200720cULL, 0x040fe20003f86070ULL,
0x0000000132257824ULL, 0x040fe200078e020dULL, 0x0000002704207210ULL, 0x000fe20007fde0ffULL,
0x0000000832327824ULL, 0x000fc400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee225ULL, 0x00000028243e7836ULL, 0x000fe20000000000ULL,
0x0000007026257812ULL, 0x000fe200078ef802ULL, 0x0000000105217824ULL, 0x000fe400030e0621ULL,
0x000000010e297824ULL, 0x000fe200078e023eULL, 0x0000002504267210ULL, 0x000fe20007fde0ffULL,
0x000000102a157824ULL, 0x002fe400078e020fULL, 0x0000000134257824ULL, 0x040fe400078e020dULL,
0x00000008342a7824ULL, 0x040fe200078e00ffULL, 0x0000000010157faeULL, 0x0003e2000e901c46ULL,
0x0000008029227825ULL, 0x000fe200078e00ffULL, 0x0000000b3400720cULL, 0x000fc40003fa6070ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee225ULL, 0x000000102c257824ULL, 0x000fe200078e020fULL,
0x0000007022297812ULL, 0x000fe200078ef802ULL, 0x0000000105277824ULL, 0x000fe400030e0627ULL,
0x0000002c24347836ULL, 0x000fe20000000000ULL, 0x0000002904227210ULL, 0x000fe20007fde0ffULL,
0x000000001e257faeULL, 0x0005e2000c901c46ULL, 0x0000000b3600720cULL, 0x040fe20003f26070ULL,
0x0000000136297824ULL, 0x040fe400078e020dULL, 0x0000000836367824ULL, 0x000fc400078e00ffULL,
0x000000102e157824ULL, 0x002fe400078e020fULL, 0x000000010e107824ULL, 0x000fe400078e0234ULL,
0x0000000105237824ULL, 0x000fe200030e0623ULL, 0x000000001c157faeULL, 0x0003e2000d101c46ULL,
0xfffffff8361e7812ULL, 0x004fe200078ee229ULL, 0x00000010281f7824ULL, 0x000fe200078e020fULL,
0x0000000b3c00720cULL, 0x000fe20003f46070ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000000181f7faeULL, 0x0005e2000c101c46ULL, 0x000000101e297824ULL, 0x100fe200078e020fULL,
0x00000070102d7812ULL, 0x000fe200078ef802ULL, 0x00000030241e7836ULL, 0x000fe40000000000ULL,
0x0000001030157824ULL, 0x102fe200078e020fULL, 0x0000002d04107210ULL, 0x000fe20007fde0ffULL,
0x00000010321d7824ULL, 0x000fe400078e020fULL, 0x0000003424287836ULL, 0x000fe20000000000ULL,
0x0000000016157faeULL, 0x0003e2000d901c46ULL, 0x000000013c2b7824ULL, 0x000fe200078e020dULL,
0x0000000b1e00720cULL, 0x080fe20003f66070ULL, 0x000000010e187824ULL, 0x004fe200078e021eULL,
0x00000000121d7faeULL, 0x0005e2000e101c46ULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x0000000b3400720cULL, 0x000fe20003f86070ULL, 0x0000000105117824ULL, 0x000fc400030e0611ULL,
0x000000102a257824ULL, 0x100fe200078e020fULL, 0xfffffff83c1c7812ULL, 0x000fe200078ee22bULL,
0x00000038242a7836ULL, 0x000fe40000000000ULL, 0x000000010e167824ULL, 0x002fe200078e0228ULL,
0x000000001a257faeULL, 0x0003e2000e901c46ULL, 0x000000101c2b7824ULL, 0x000fe200078e020fULL,
0x0000000b3e00720cULL, 0x080fe20003fa6070ULL, 0x0000008018127825ULL, 0x004fe200078e00ffULL,
0x0000000020297faeULL, 0x0005e2000c901c46ULL, 0x0000000b2a00720cULL, 0x000fc40003f26070ULL,
0x0000003c24247836ULL, 0x000fe20000000000ULL, 0x0000007012177812ULL, 0x000fe200078ef802ULL,
0x000000013e157824ULL, 0x040fe200078e020dULL, 0x00000000262b7faeULL, 0x0007e2000d101c46ULL,
0x000000083e1c7824ULL, 0x000fe200078e00ffULL, 0x0000001704127210ULL, 0x000fe20007fde0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000b2800720cULL, 0x080fe40003f46070ULL,
0x0000000b2400720cULL, 0x000fe20003f06070ULL, 0x0000000105137824ULL, 0x000fe200030e0613ULL,
0x00000070161b7812ULL, 0x002fe200078ef802ULL, 0x000000010e167824ULL, 0x000fe200078e022aULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL, 0x00000001340b7824ULL, 0x040fe200078e020dULL,
0x0000001b041a7210ULL, 0x000fe20007fde0ffULL, 0x0000000834347824ULL, 0x000fc400078e00ffULL,
0x000000011e157824ULL, 0x000fe400078e020dULL, 0x00000001051b7824ULL, 0x000fe400030e0617ULL,
0x0000008016167825ULL, 0x000fc800078e00ffULL, 0x000000081e207824ULL, 0x004fe200078e00ffULL,
0x00000070161d7812ULL, 0x000fe200078ef802ULL, 0x000000010e187824ULL, 0x000fe200078e0224ULL,
0xfffffff8341e7812ULL, 0x000fe200078ee20bULL, 0x00000001280b7824ULL, 0x000fe200078e020dULL,
0xfffffff820207812ULL, 0x000fe200078ee215ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000001d04167210ULL, 0x000fc60007fde0ffULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x00000070181d7812ULL, 0x000fe200078ef802ULL, 0x000000012a157824ULL, 0x140fe400078e020dULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8280e7812ULL, 0x000fe200078ee20bULL,
0x00000001240d7824ULL, 0x040fe400078e020dULL, 0x0000000824267824ULL, 0x008fe200078e00ffULL,
0xfffffff82a247812ULL, 0x000fe200078ee215ULL, 0x0000000105177824ULL, 0x000fe200030e0617ULL,
0x0000001d04047210ULL, 0x000fe20007fde0ffULL, 0x000000101c0b7824ULL, 0x100fe200078e020fULL,
0xfffffff826267812ULL, 0x000fe200078ee20dULL, 0x000000101e0d7824ULL, 0x000fc400078e020fULL,
0x0000001020157824ULL, 0x100fe200078e020fULL, 0x00000000220b7faeULL, 0x0003e2000e901c46ULL,
0x000000100e1d7824ULL, 0x100fe400078e020fULL, 0x00000010241f7824ULL, 0x100fe200078e020fULL,
0x00000000100d7faeULL, 0x0003e2000e101c46ULL, 0x00000010260f7824ULL, 0x000fe400078e020fULL,
0x0000000105057824ULL, 0x000fe200030e0619ULL, 0x0000000012157faeULL, 0x0003e8000d901c46ULL,
0x000000001a1d7faeULL, 0x0003e8000d101c46ULL, 0x00000000161f7faeULL, 0x0003e8000c901c46ULL,
0x00000000040f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x000000100d157811ULL, 0x040fe400078fe8ffULL, 0x000000040d117811ULL, 0x040fe400078fe8ffULL,
0x0000000c0d137811ULL, 0x000fe200078fe8ffULL, 0x0000000115167824ULL, 0x100fe200078e020dULL,
0x000000080d127811ULL, 0x000fe200078fe8ffULL, 0x0000000815297824ULL, 0x000fe200078e00ffULL,
0x0000001c0d1b7811ULL, 0x000fe200078fe8ffULL, 0x00000001110b7824ULL, 0x100fe200078e020dULL,
0x000000240d1e7811ULL, 0x000fe200078fe8ffULL, 0x0000000811187824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee216ULL, 0x0000000113107824ULL, 0x100fe200078e020dULL,
0x000000140d167811ULL, 0x000fe200078fe8ffULL, 0x0000000813257824ULL, 0x000fe200078e00ffULL,
0xfffffff8181f7812ULL, 0x000fe200078ee20bULL, 0x00000001120f7824ULL, 0x100fe200078e020dULL,
0x000000180d197811ULL, 0x040fe200078fe8ffULL, 0x00000001160b7824ULL, 0x140fe200078e020dULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0x000000200d1d7811ULL, 0x040fe200078fe8ffULL, 0x00000008121a7824ULL, 0x000fe200078e00ffULL,
0x0000002c0d237811ULL, 0x000fe200078fe8ffULL, 0x000000011b107824ULL, 0x140fe200078e020dULL,
0xfffffff8182d7812ULL, 0x000fe200078ee20bULL, 0x000000081b317824ULL, 0x000fe200078e00ffULL,
0xfffffff81a217812ULL, 0x000fe200078ee20fULL, 0x000000011e0b7824ULL, 0x140fe200078e020dULL,
0x000000280d207811ULL, 0x000fe200078fe8ffULL, 0x000000081e187824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee210ULL, 0x00000001190f7824ULL, 0x100fe200078e020dULL,
0x000000300d277811ULL, 0x000fe200078fe8ffULL, 0x00000008191a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818357812ULL, 0x000fe200078ee20bULL, 0x000000011d177824ULL, 0x100fe200078e020dULL,
0x0000000d0d0b7211ULL, 0x000fe200078fe8ffULL, 0x000000081d1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a2f7812ULL, 0x000fe200078ee20fULL, 0x0000000123107824ULL, 0x100fe200078e020dULL,
0x000000380d2e7811ULL, 0x000fe200078fe8ffULL, 0x00000008232b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c337812ULL, 0x000fe200078ee217ULL, 0x00000001200f7824ULL, 0x140fe200078e020dULL,
0x0000003c0d307811ULL, 0x000fe200078fe8ffULL, 0x0000000820247824ULL, 0x000fe200078e00ffULL,
0xfffffff82b287812ULL, 0x000fe200078ee210ULL, 0x0000000127177824ULL, 0x000fe200078e020dULL,
0x000000070b107812ULL, 0x000fe200078ec0ffULL, 0x00000008272c7824ULL, 0x000fe200078e00ffULL,
0x000000340d2b7811ULL, 0x040fe200078fe8ffULL, 0x000000010e1a7824ULL, 0x040fe200078e0216ULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x000000010e1c7824ULL, 0x000fe200078e0219ULL,
0x0ffffff810167812ULL, 0x000fe200078ef80dULL, 0x000000012e197824ULL, 0x040fe200078e020dULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee217ULL, 0x000000082e347824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0f7211ULL, 0x000fe200078fe8ffULL, 0x000000010e177824ULL, 0x000fe200078e0213ULL,
0x0000000840107c11ULL, 0x000fe2000f8e70ffULL, 0x000000010e117824ULL, 0x000fe200078e0211ULL,
0xfffffff834197812ULL, 0x000fe200078ee219ULL, 0x000000012b137824ULL, 0x000fc400078e020dULL,
0x000000010e187824ULL, 0x040fe400078e0215ULL, 0x000000010e2a7824ULL, 0x040fe400078e021eULL,
0x000000010e367824ULL, 0x040fe400078e0220ULL, 0x000000082b327824ULL, 0x000fe400078e00ffULL,
0x000000010e0b7824ULL, 0x000fe400078e0230ULL, 0x00000001300d7824ULL, 0x000fc400078e020dULL,
0x000000010e127824ULL, 0x040fe400078e0212ULL, 0x000000010e227824ULL, 0x040fe400078e021bULL,
0x000000010e267824ULL, 0x040fe400078e021dULL, 0x000000010e3c7824ULL, 0x040fe400078e0223ULL,
0x000000010e207824ULL, 0x040fe400078e0227ULL, 0x000000010e1e7824ULL, 0x000fc400078e022bULL,
0x000000010e157824ULL, 0x000fe200078e022eULL, 0xfffffff8322e7812ULL, 0x000fe200078ee213ULL,
0x0000000830307824ULL, 0x000fe400078e00ffULL, 0x000000800f0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff830327812ULL, 0x000fe200078ee20dULL, 0x0000100010347836ULL, 0x000fe20000000000ULL,
0x000000700e0d7812ULL, 0x000fe200078ef802ULL, 0x0000008011107825ULL, 0x000fc600078e00ffULL,
0x0000000d040e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00000070101b7812ULL, 0x000fc600078ef802ULL, 0x00000010160d7824ULL, 0x000fe200078e0234ULL,
0x0000001b04107210ULL, 0x000fe20007f3e0ffULL, 0x0000008017167825ULL, 0x000fe200078e00ffULL,
0x00000070121b7812ULL, 0x000fc600078ef802ULL, 0x00000001050f7824ULL, 0x040fe200000e060fULL,
0x0000001b04127210ULL, 0x000fe20007f1e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000007016237812ULL, 0x000fe400078ef802ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e2000b901c46ULL, 0x0000000105137824ULL, 0x000fe200000e0613ULL,
0x0000002304167210ULL, 0x000fe20007f1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000701c237812ULL, 0x000fc600078ef802ULL, 0x0000001019307824ULL, 0x000fe200078e0234ULL,
0x000000701a277812ULL, 0x000fe200078ef802ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x00000023041c7210ULL, 0x000fc60007f5e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x00000070182b7812ULL, 0x000fc600078ef802ULL, 0x0000000105177824ULL, 0x000fe200000e0617ULL,
0x00000027041a7210ULL, 0x000fe20007f1e0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000007022397812ULL, 0x000fc600078ef802ULL, 0x0000000105117824ULL, 0x000fe200008e0611ULL,
0x0000002b04187210ULL, 0x000fe20007f3e0ffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000007036497812ULL, 0x000fc600078ef802ULL, 0x00000001051b7824ULL, 0x000fe200000e061bULL,
0x0000003904227210ULL, 0x000fe20007f1e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x000000702a397812ULL, 0x000fc600078ef802ULL, 0x00000001051d7824ULL, 0x000fe200010e061dULL,
0x0000004904487210ULL, 0x000fe20007f5e0ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x00000070263f7812ULL, 0x000fc600078ef802ULL, 0x0000000105237824ULL, 0x040fe200000e0623ULL,
0x00000039042a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000105197824ULL, 0x040fe200008e0619ULL,
0x000000703c397812ULL, 0x000fe200078ef802ULL, 0x0000000105497824ULL, 0x000fe200010e0637ULL,
0x0000003f04267210ULL, 0x000fe20007f3e0ffULL, 0x0000008020367825ULL, 0x000fc800078e00ffULL,
0x000000801e3e7825ULL, 0x000fe200078e00ffULL, 0x00000070364b7812ULL, 0x000fc600078ef802ULL,
0x00000001052b7824ULL, 0x000fe200000e062bULL, 0x00000039043c7210ULL, 0x000fe20007f1e0ffULL,
0x0000008015447825ULL, 0x000fe200078e00ffULL, 0x000000703e397812ULL, 0x000fc600078ef802ULL,
0x000000101f1f7824ULL, 0x000fe200078e0234ULL, 0x0000007044157812ULL, 0x000fe200078ef802ULL,
0x000000800b467825ULL, 0x000fc600078e00ffULL, 0x00000000101f7faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x100fe200078e0234ULL, 0x00000070460b7812ULL, 0x000fe200078ef802ULL,
0x0000001025257824ULL, 0x100fe200078e0234ULL, 0x0000001504447210ULL, 0x000fe20007f5e0ffULL,
0x0000001029297824ULL, 0x100fe200078e0234ULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x000000102d2d7824ULL, 0x100fe400078e0234ULL, 0x000000102f2f7824ULL, 0x100fe200078e0234ULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x00000001053d7824ULL, 0x000fe200000e063dULL,
0x0000004b04367210ULL, 0x000fe20007f1e0ffULL, 0x0000001031317824ULL, 0x100fe200078e0234ULL,
0x0000000018297faeULL, 0x0003e2000b901c46ULL, 0x0000000105277824ULL, 0x000fe200008e0627ULL,
0x00000039043e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001033337824ULL, 0x100fe200078e0234ULL,
0x0000000b04047210ULL, 0x000fe20007f7e0ffULL, 0x0000001035357824ULL, 0x100fe200078e0234ULL,
0x000000001a2d7faeULL, 0x0003e2000b901c46ULL, 0x0000001024247824ULL, 0x000fc400078e0234ULL,
0x0000001028287824ULL, 0x100fe200078e0234ULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x000000102c2c7824ULL, 0x100fe400078e0234ULL, 0x0000000105377824ULL, 0x040fe200000e0637ULL,
0x0000000022317faeULL, 0x0003e2000b901c46ULL, 0x000000102e2e7824ULL, 0x000fe400078e0234ULL,
0x00000001053f7824ULL, 0x040fe200008e063fULL, 0x0000000026337faeULL, 0x0003e2000b901c46ULL,
0x0000000105457824ULL, 0x000fc400010e0645ULL, 0x0000001032327824ULL, 0x000fe200078e0234ULL,
0x000000002a357faeULL, 0x0003e2000b901c46ULL, 0x0000000105057824ULL, 0x000fc600018e0647ULL,
0x0000000048247faeULL, 0x0003e8000b901c46ULL, 0x000000003c287faeULL, 0x0003e8000b901c46ULL,
0x00000000362c7faeULL, 0x0003e8000b901c46ULL, 0x000000003e2e7faeULL, 0x0003e8000b901c46ULL,
0x0000000044307faeULL, 0x0003e8000b901c46ULL, 0x0000000004327faeULL, 0x0003e4000b901c46ULL,
0x000000020c027836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff057424ULL, 0x002fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000003b0200720cULL, 0x000fda0003f06070ULL, 0x00009600ff048b82ULL, 0x000e620000000800ULL,
0x00000002140b8824ULL, 0x000fce00078e00ffULL, 0x00009200ff0c8b82ULL, 0x000ea20000000a00ULL,
0x000000040b0b8224ULL, 0x002fc800078e0202ULL, 0x000000040b0c8825ULL, 0x004fca00078e000cULL,
0x000000060c058981ULL, 0x000322000c1e1900ULL, 0x0000001f04047890ULL, 0x000fc8000fffe03fULL,
0x000000053f047899ULL, 0x000fd80008011604ULL, 0x00000000000c7805ULL, 0x002fce0000015200ULL,
0x01760007ff0075a7ULL, 0x000e620008000148ULL, 0x000000013a047824ULL, 0x000fe400078e0a03ULL,
0x00000004080b7c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff047819ULL, 0x000fe20000011604ULL,
0x00008e00ff447b82ULL, 0x000ea40000000a00ULL, 0x000000040b447825ULL, 0x004fe200078e0044ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff107224ULL, 0x000fce00078e00ffULL,
0x000000101000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fce0000015200ULL, 0x0000000e0c0b7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0e7824ULL, 0x000fe200000e0e0dULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0e00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0e00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc8000001140eULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060eULL,
0x0000000208087819ULL, 0x000fc8000000120bULL, 0x000000080000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000110107836ULL, 0x000fce0000000000ULL,
0x01760007ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x0000002040067824ULL, 0x002fca00078e0207ULL,
0x00000003ff077819ULL, 0x000fc80000011606ULL, 0x1ffffffe070b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f06077812ULL, 0x000fc600078ec0ffULL, 0x00000001060b7824ULL, 0x000fe400078e020bULL,
0x0000001007087824ULL, 0x000fe400078e00ffULL, 0x000000010b067836ULL, 0x000fe20000000000ULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x000fc600078e00ffULL,
0x0000000f06067812ULL, 0x000fe400078ec0ffULL, 0x000000f0080b7812ULL, 0x000fe400078ee20bULL,
0x000000f007067812ULL, 0x000fe400078ee206ULL, 0x000000080b0b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000806067c11ULL, 0x000fc6000f8e20ffULL, 0x000000000b107984ULL, 0x000e680000000c00ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x000000180b007388ULL, 0x0003e20000000c00ULL,
0x00000001ff0e7424ULL, 0x000fc600078e00ffULL, 0x0000001006007388ULL, 0x0003e60000000c00ULL,
0x0176000eff0e79a7ULL, 0x000ea40008500008ULL, 0x0000000000067805ULL, 0x002fce0000015200ULL,
0x0176000fff0075a7ULL, 0x004e640008000148ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff107224ULL, 0x000fce00078e00ffULL, 0x000000101000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fce0000015200ULL,
0x0000000c060b7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc8000001140cULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060cULL, 0x0000000208087819ULL, 0x000fc8000000120bULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000110107836ULL, 0x000fce0000000000ULL, 0x0176000fff0075a7ULL, 0x000e640008000148ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff3800720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009600ff0b7b82ULL, 0x000e620000000800ULL,
0x0000000000067919ULL, 0x000ea20000000000ULL, 0x0000010009077836ULL, 0x000fe40000000000ULL,
0x3db504f30a087820ULL, 0x010fe20000410000ULL, 0x00000008400a7c11ULL, 0x040fe2000f8e18ffULL,
0x0000000903397836ULL, 0x000fe20000000000ULL, 0x0000000840427c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x000000ffff227224ULL, 0x000fc400078e00ffULL, 0x0000000b14097224ULL, 0x002fe400078e02ffULL,
0xffffffff030b7836ULL, 0x000fce0000000000ULL, 0x00009000ff0c7b82ULL, 0x004e620000000a00ULL,
0x00000002470f7836ULL, 0x000fe20000000000ULL, 0x0000000122467812ULL, 0x000fe200078e0cffULL,
0x0000010047497824ULL, 0x000fe400078e0207ULL, 0x0000000500057224ULL, 0x010fe200078e02ffULL,
0x000000380f00720cULL, 0x000fe40003f06070ULL, 0x00000040490e7812ULL, 0x000fe200078ec0ffULL,
0x00000080050c7825ULL, 0x002fc800078e000cULL, 0x0000000143057824ULL, 0x000fcc00078e020eULL,
0x0000000c002c8947ULL, 0x000fea0003800000ULL, 0x00000003ff207819ULL, 0x104fe20000011606ULL,
0x00000010061a7824ULL, 0x000fe200078e00ffULL, 0x000000493a0e7248ULL, 0x000fe40007fe0000ULL,
0x0000000840237c11ULL, 0x000fe2000f8e70ffULL, 0x0000000420107836ULL, 0x000fe20000000000ULL,
0x000000701a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000820127836ULL, 0x000fe40000000000ULL,
0x00000001100f7824ULL, 0x040fe400078e0206ULL, 0x00000008102e7824ULL, 0x000fc400078e00ffULL,
0x000000010e1b7824ULL, 0x000fe400078e0a49ULL, 0x00000001122a7824ULL, 0x040fe200078e0206ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL, 0x00000008120f7824ULL, 0x000fe200078e00ffULL,
0x0000001b1000720cULL, 0x000fe20003fa6070ULL, 0x00000001200e7824ULL, 0x100fe400078e0205ULL,
0x0000000110107824ULL, 0x000fe200078e0205ULL, 0xfffffff80f2a7812ULL, 0x000fe200078ee22aULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001a0e197212ULL, 0x000fc600078efcffULL, 0x0000000c20167836ULL, 0x000fe20000000000ULL,
0x0000001a10157212ULL, 0x000fe200078efcffULL, 0x00000001120e7824ULL, 0x100fe200078e0205ULL,
0x000000190c187210ULL, 0x000fe20007f1e0ffULL, 0x00000010201c7836ULL, 0x000fe20000000000ULL,
0x000000150c147210ULL, 0x000fe20007f3e0ffULL, 0x0000000116107824ULL, 0x040fe200078e0205ULL,
0x0000001b1600720cULL, 0x080fe20003f46070ULL, 0x000000010d197824ULL, 0x000fe200000e060fULL,
0x0000001b1c00720cULL, 0x000fe20003f06070ULL, 0x00000001162c7824ULL, 0x000fc400078e0206ULL,
0x0000000816137824ULL, 0x000fe400078e00ffULL, 0x000000010d157824ULL, 0x000fe200008e0611ULL,
0x0000001b1200720cULL, 0x000fe20003f26070ULL, 0x0000001420267836ULL, 0x000fe20000000000ULL,
0xfffffff8132c7812ULL, 0x000fe200078ee22cULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000011c287824ULL, 0x000fe200078e0206ULL, 0x0000001a0e1f7212ULL, 0x000fe200078efcffULL,
0x000000081c177824ULL, 0x040fe400078e00ffULL, 0x000000011c127824ULL, 0x000fe200078e0205ULL,
0x0000001f0c167210ULL, 0x000fe20007f7e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff817287812ULL, 0x000fc600078ee228ULL, 0x00000001261c7824ULL, 0x000fe200078e0205ULL,
0x0000001a10177212ULL, 0x000fe200078efcffULL, 0x0000001820327836ULL, 0x000fe40000000000ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000170c1e7210ULL, 0x000fc60007f9e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000001a121f7212ULL, 0x000fc600078efcffULL,
0x0000000132247824ULL, 0x000fe200078e0205ULL, 0x0000001a1c217212ULL, 0x000fe200078efcffULL,
0x000000010d177824ULL, 0x000fe200018e060fULL, 0x0000001f0c127210ULL, 0x000fe20007f7e0ffULL,
0x0000008024247825ULL, 0x000fc800078e00ffULL, 0x0000001c20347836ULL, 0x000fe20000000000ULL,
0x0000001a240f7212ULL, 0x000fe200078efcffULL, 0x000000010d1f7824ULL, 0x040fe200020e0611ULL,
0x000000210c107210ULL, 0x000fe20007f9e0ffULL, 0x00000001341c7824ULL, 0x000fe400078e0205ULL,
0x000000010d137824ULL, 0x040fe200018e0613ULL, 0x0000000f0c0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d117824ULL, 0x000fe200020e061dULL, 0x0000001b2000720cULL, 0x040fe20003f86070ULL,
0x0000000120247824ULL, 0x000fc400078e0206ULL, 0x000000801c1c7825ULL, 0x000fc600078e00ffULL,
0x0000000724277812ULL, 0x000fe200078ec0ffULL, 0x0000002020367836ULL, 0x000fe40000000000ULL,
0x000000010d0f7824ULL, 0x000fe200018e0625ULL, 0x0000001a1c257212ULL, 0x000fe200078efcffULL,
0x0000000136247824ULL, 0x000fe200078e0205ULL, 0x0000001b2600720cULL, 0x000fe20003f66070ULL,
0x0000200046217824ULL, 0x000fe200078e0223ULL, 0x000000250c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000126297824ULL, 0x040fe400078e0206ULL, 0x0000000826307824ULL, 0x000fe200078e00ffULL,
0x0ffffff827267812ULL, 0x000fe200078ef806ULL, 0x0000008024247825ULL, 0x000fc600078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee229ULL, 0x0000100021217836ULL, 0x000fe20000000000ULL,
0x0000001a24277212ULL, 0x000fe200078efcffULL, 0x00000024203c7836ULL, 0x000fe40000000000ULL,
0x0000001026297824ULL, 0x000fe400078e0221ULL, 0x00000028203e7836ULL, 0x000fe40000000000ULL,
0x000000013c267824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018297faeULL, 0x0003e2000e101c46ULL, 0x000000010d1d7824ULL, 0x000fe200030e061dULL,
0x000000270c247210ULL, 0x000fe20007fde0ffULL, 0x000000013e2b7824ULL, 0x000fe200078e0205ULL,
0x0000001b3200720cULL, 0x000fe20003f86070ULL, 0x0000008026267825ULL, 0x000fc800078e00ffULL,
0x000000010d257824ULL, 0x000fe400030e0625ULL, 0x00000001322d7824ULL, 0x000fe400078e0206ULL,
0x000000802b187825ULL, 0x002fe200078e00ffULL, 0x0000001a262b7212ULL, 0x000fc600078efcffULL,
0x0000000832327824ULL, 0x000fe200078e00ffULL, 0x0000002b0c267210ULL, 0x000fe20007fde0ffULL,
0x000000102e297824ULL, 0x000fe200078e0221ULL, 0x0000001a182b7212ULL, 0x000fe200078efcffULL,
0x00000008342e7824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee22dULL,
0x000000010d277824ULL, 0x000fe200030e0627ULL, 0x0000002b0c187210ULL, 0x000fe20007fde0ffULL,
0x0000000014297faeULL, 0x0003e2000e901c46ULL, 0x000000102a2b7824ULL, 0x000fe200078e0221ULL,
0x0000001b3400720cULL, 0x040fe20003fa6070ULL, 0x00000001342d7824ULL, 0x000fc400078e0206ULL,
0x0000002c20347836ULL, 0x000fe20000000000ULL, 0x00000000162b7faeULL, 0x0005e2000c901c46ULL,
0x00000001362a7824ULL, 0x040fe200078e0206ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee22dULL,
0x00000008362f7824ULL, 0x040fe200078e00ffULL, 0x0000001b3600720cULL, 0x000fe20003f26070ULL,
0x000000083c317824ULL, 0x000fe400078e00ffULL, 0x000000102c297824ULL, 0x002fe200078e0221ULL,
0xfffffff82f2a7812ULL, 0x000fe200078ee22aULL, 0x0000000134147824ULL, 0x000fc400078e0205ULL,
0x000000013c2c7824ULL, 0x000fe200078e0206ULL, 0x000000001e297faeULL, 0x0003e2000d101c46ULL,
0x0000001028177824ULL, 0x004fe200078e0221ULL, 0x0000001b3c00720cULL, 0x000fe20003f46070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x000fe400078ee22cULL,
0x0000000012177faeULL, 0x0005e2000c101c46ULL, 0x000000010d197824ULL, 0x000fe200030e0619ULL,
0x0000001a142d7212ULL, 0x000fe200078efcffULL, 0x0000003420287836ULL, 0x000fc40000000000ULL,
0x000000102e2b7824ULL, 0x100fe200078e0221ULL, 0x0000002d0c147210ULL, 0x000fe20007fde0ffULL,
0x00000030201e7836ULL, 0x002fe40000000000ULL, 0x00000010301f7824ULL, 0x100fe400078e0221ULL,
0x0000001032297824ULL, 0x000fe400078e0221ULL, 0x000000011e127824ULL, 0x044fe200078e0205ULL,
0x00000000101f7faeULL, 0x0003e2000d901c46ULL, 0x000000010d157824ULL, 0x000fe200030e0615ULL,
0x0000001b1e00720cULL, 0x080fe20003f66070ULL, 0x000000102a2d7824ULL, 0x100fe200078e0221ULL,
0x000000000e297faeULL, 0x0005e2000e101c46ULL, 0x000000102c2f7824ULL, 0x000fe200078e0221ULL,
0x0000001b3400720cULL, 0x080fe20003f86070ULL, 0x000000083e137824ULL, 0x040fe200078e00ffULL,
0x000000001c2b7faeULL, 0x0007e2000e901c46ULL, 0x00000038202a7836ULL, 0x000fe20000000000ULL,
0x0000001b3e00720cULL, 0x080fe20003fa6070ULL, 0x0000003c202c7836ULL, 0x000fe20000000000ULL,
0x00000000242d7faeULL, 0x0009e2000c901c46ULL, 0x0000000128107824ULL, 0x002fe200078e0205ULL,
0x0000001b2a00720cULL, 0x080fe20003f26070ULL, 0x0000000134167824ULL, 0x000fe200078e0206ULL,
0x00000000262f7faeULL, 0x0003e2000d101c46ULL, 0x00000080120e7825ULL, 0x004fe200078e00ffULL,
0x0000001b2800720cULL, 0x000fc40003f46070ULL, 0x0000001b2c00720cULL, 0x000fe20003f06070ULL,
0x000000013e127824ULL, 0x100fe200078e0206ULL, 0x0000001a0e117212ULL, 0x000fe200078efcffULL,
0x00000008341b7824ULL, 0x000fe400078e00ffULL, 0x000000011e177824ULL, 0x000fe200078e0206ULL,
0x000000110c0e7210ULL, 0x000fe20007fde0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff8131c7812ULL, 0x008fc600078ee212ULL, 0x000000012a127824ULL, 0x000fe200078e0205ULL,
0x0000001a10137212ULL, 0x080fe200078efcffULL, 0x000000010d0f7824ULL, 0x000fe400030e060fULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0x000000130c107210ULL, 0x000fe20007fde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff81b1e7812ULL, 0x000fe400078ee216ULL,
0xfffffff820207812ULL, 0x000fe200078ee217ULL, 0x000000012c167824ULL, 0x000fe200078e0205ULL,
0x0000001a12057212ULL, 0x000fe200078efcffULL, 0x00000001281b7824ULL, 0x000fc400078e0206ULL,
0x0000000828247824ULL, 0x010fe400078e00ffULL, 0x000000012c1f7824ULL, 0x040fe400078e0206ULL,
0x000000082c287824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee21bULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee21fULL,
0x000000010d117824ULL, 0x040fe200030e0611ULL, 0x000000050c127210ULL, 0x000fe20007fde0ffULL,
0x000000012a1d7824ULL, 0x000fe200078e0206ULL, 0x0000001a161f7212ULL, 0x000fe200078efcffULL,
0x000000082a267824ULL, 0x002fe400078e00ffULL, 0x000000010d137824ULL, 0x000fe200030e0613ULL,
0x0000001f0c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000101c057824ULL, 0x100fe200078e0221ULL,
0xfffffff826267812ULL, 0x000fe200078ee21dULL, 0x000000101e1b7824ULL, 0x000fc400078e0221ULL,
0x00000010201d7824ULL, 0x100fe200078e0221ULL, 0x0000000018057faeULL, 0x0003e2000e901c46ULL,
0x00000010241f7824ULL, 0x100fe400078e0221ULL, 0x0000001026257824ULL, 0x100fe200078e0221ULL,
0x00000000141b7faeULL, 0x0003e2000e101c46ULL, 0x0000001028217824ULL, 0x000fe400078e0221ULL,
0x000000010d0d7824ULL, 0x000fe200030e0617ULL, 0x000000000e1d7faeULL, 0x0003e8000d901c46ULL,
0x00000000101f7faeULL, 0x0003e8000d101c46ULL, 0x0000000012257faeULL, 0x0003e8000c901c46ULL,
0x000000000c217faeULL, 0x0003e2000c101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x0000000806127811ULL, 0x044fe200078fe8ffULL, 0x00000010065b7824ULL, 0x040fe200078e00ffULL,
0x00000018061a7811ULL, 0x040fe400078fe8ffULL, 0x0000000406107811ULL, 0x000fe200078fe8ffULL,
0x00000001120f7824ULL, 0x100fe200078e0206ULL, 0x0000001406187811ULL, 0x000fe200078fe8ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0x00000010061c7811ULL, 0x000fe200078fe8ffULL,
0x000000011a137824ULL, 0x100fe200078e0206ULL, 0x0000002806267811ULL, 0x000fe200078fe8ffULL,
0x000000081a207824ULL, 0x000fe200078e00ffULL, 0x0000000c06147811ULL, 0x000fe200078fe8ffULL,
0x00000001100e7824ULL, 0x100fe200078e0206ULL, 0x0000002406247811ULL, 0x000fe200078fe8ffULL,
0x0000000810577824ULL, 0x000fe200078e00ffULL, 0xfffffff816557812ULL, 0x000fe200078ee20fULL,
0x0000000118117824ULL, 0x140fe200078e0206ULL, 0xfffffff8204d7812ULL, 0x000fe200078ee213ULL,
0x00000008181e7824ULL, 0x000fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe200078ee20eULL,
0x000000011c0f7824ULL, 0x100fe200078e0206ULL, 0x0000002006207811ULL, 0x000fe200078fe8ffULL,
0x000000081c167824ULL, 0x000fe200078e00ffULL, 0xfffffff81e4f7812ULL, 0x000fe200078ee211ULL,
0x0000000126137824ULL, 0x100fe200078e0206ULL, 0x0000001c061f7811ULL, 0x000fe200078fe8ffULL,
0x0000000826287824ULL, 0x000fe200078e00ffULL, 0xfffffff816517812ULL, 0x000fe200078ee20fULL,
0x00000001140e7824ULL, 0x100fe200078e0206ULL, 0x00000038062c7811ULL, 0x000fe200078fe8ffULL,
0x0000000814537824ULL, 0x000fe200078e00ffULL, 0xfffffff828377812ULL, 0x000fe200078ee213ULL,
0x0000000124117824ULL, 0x100fe200078e0206ULL, 0x0000003006287811ULL, 0x000fe200078fe8ffULL,
0x00000008241e7824ULL, 0x000fe200078e00ffULL, 0xfffffff853537812ULL, 0x000fe200078ee20eULL,
0x00000001200f7824ULL, 0x100fe200078e0206ULL, 0x00000034062e7811ULL, 0x000fe200078fe8ffULL,
0x0000000820167824ULL, 0x000fe200078e00ffULL, 0xfffffff81e3d7812ULL, 0x000fe200078ee211ULL,
0x000000011f0e7824ULL, 0x140fe200078e0206ULL, 0x0000002c061e7811ULL, 0x000fe200078fe8ffULL,
0x000000081f4b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8163f7812ULL, 0x000fe200078ee20fULL,
0x00000001280f7824ULL, 0x100fe200078e0206ULL, 0x0000000840237c11ULL, 0x000fe2000f8e70ffULL,
0x0000000828167824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee20eULL,
0x000000012c137824ULL, 0x140fe200078e0206ULL, 0x000000705b5b7812ULL, 0x000fe200078ec0ffULL,
0x000000082c307824ULL, 0x000fe200078e00ffULL, 0xfffffff816337812ULL, 0x000fe200078ee20fULL,
0x000000011e0e7824ULL, 0x100fe200078e0206ULL, 0x00000006060f7211ULL, 0x000fe200078fe8ffULL,
0x000000081e357824ULL, 0x000fe200078e00ffULL, 0xfffffff830177812ULL, 0x000fe200078ee213ULL,
0x000000012e117824ULL, 0x000fe200078e0206ULL, 0x0000003c06137811ULL, 0x000fe200078fe8ffULL,
0x000000082e2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20eULL,
0x0000000110107824ULL, 0x100fe200078e0205ULL, 0x00000005060e7211ULL, 0x000fe200078fe8ffULL,
0x0000000112127824ULL, 0x100fe200078e0205ULL, 0xfffffff82a317812ULL, 0x000fe200078ee211ULL,
0x0000000114147824ULL, 0x100fe200078e0205ULL, 0x000000070f117812ULL, 0x000fe200078ec0ffULL,
0x000000011c1c7824ULL, 0x000fc400078e0205ULL, 0x0000000118187824ULL, 0x100fe200078e0205ULL,
0x0ffffff811597812ULL, 0x000fe200078ef806ULL, 0x000000011a1a7824ULL, 0x100fe400078e0205ULL,
0x000000011f1f7824ULL, 0x100fe400078e0205ULL, 0x0000000120207824ULL, 0x100fe400078e0205ULL,
0x0000000124247824ULL, 0x100fe400078e0205ULL, 0x0000000126267824ULL, 0x000fc400078e0205ULL,
0x000000011e1e7824ULL, 0x100fe400078e0205ULL, 0x0000000128287824ULL, 0x100fe400078e0205ULL,
0x000000012e2e7824ULL, 0x100fe400078e0205ULL, 0x000000012c2c7824ULL, 0x100fe400078e0205ULL,
0x00000001132a7824ULL, 0x040fe400078e0205ULL, 0x0000000113057824ULL, 0x000fc400078e0206ULL,
0x0000000813167824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff816197812ULL, 0x000fe200078ee205ULL, 0x0000200046137824ULL, 0x000fe200078e0223ULL,
0x0000005b0e057212ULL, 0x000fe200078efcffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x000000050c0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000100013167836ULL, 0x000fe20000000000ULL,
0x0000005b10157212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x000000150c107210ULL, 0x000fe20007f3e0ffULL, 0x0000001017307824ULL, 0x000fe200078e0216ULL,
0x0000005b12177212ULL, 0x000fe200078efcffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000005b14217212ULL, 0x000fc600078efcffULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x000000170c127210ULL, 0x000fe20007f1e0ffULL,
0x0000001059597824ULL, 0x100fe200078e0216ULL, 0x0000005b1c177212ULL, 0x000fe200078efcffULL,
0x0000001057577824ULL, 0x100fe400078e0216ULL, 0x0000001055557824ULL, 0x100fe200078e0216ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e597faeULL, 0x0003e2000b901c46ULL,
0x0000001053537824ULL, 0x100fe400078e0216ULL, 0x0000001051517824ULL, 0x000fc400078e0216ULL,
0x000000104f4f7824ULL, 0x100fe400078e0216ULL, 0x000000104d4d7824ULL, 0x100fe400078e0216ULL,
0x000000104b4b7824ULL, 0x100fe400078e0216ULL, 0x000000103f3f7824ULL, 0x100fe400078e0216ULL,
0x000000103d3d7824ULL, 0x100fe400078e0216ULL, 0x0000001037377824ULL, 0x000fc400078e0216ULL,
0x0000001035357824ULL, 0x100fe400078e0216ULL, 0x0000001033337824ULL, 0x100fe400078e0216ULL,
0x0000001031317824ULL, 0x100fe400078e0216ULL, 0x0000001019057824ULL, 0x000fe400078e0216ULL,
0x000000010d137824ULL, 0x040fe200000e0613ULL, 0x000000210c167210ULL, 0x000fe20007f1e0ffULL,
0x000000010d117824ULL, 0x000fe200008e0611ULL, 0x000000170c147210ULL, 0x000fe20007f3e0ffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x0000000010577faeULL, 0x0003e2000b901c46ULL,
0x000000010d177824ULL, 0x040fe200000e0615ULL, 0x0000005b18257212ULL, 0x080fe200078efcffULL,
0x000000010d157824ULL, 0x000fe200008e061dULL, 0x0000000012557faeULL, 0x0003e2000b901c46ULL,
0x000000801f1c7825ULL, 0x000fe200078e00ffULL, 0x000000250c187210ULL, 0x000fe40007f1e0ffULL,
0x0000000016537faeULL, 0x0003e2000b901c46ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000005b1c297212ULL, 0x000fc400078efcffULL, 0x0000000014517faeULL, 0x0003e2000b901c46ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000005b1a217212ULL, 0x000fc600078efcffULL,
0x000000010d197824ULL, 0x000fe200000e0619ULL, 0x000000290c1c7210ULL, 0x000fe20007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x000000210c1a7210ULL, 0x000fe40007f5e0ffULL,
0x0000005b242b7212ULL, 0x080fe200078efcffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000005b26297212ULL, 0x080fe200078efcffULL, 0x00000000184f7faeULL, 0x0003e4000b901c46ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000005b202d7212ULL, 0x000fc600078efcffULL,
0x000000010d1d7824ULL, 0x040fe200000e061dULL, 0x0000002b0c247210ULL, 0x000fe20007f1e0ffULL,
0x000000010d1b7824ULL, 0x040fe200010e061bULL, 0x0000005b1e2b7212ULL, 0x080fe200078efcffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000290c267210ULL, 0x000fe40007f5e0ffULL,
0x0000002d0c207210ULL, 0x000fe20007f3e0ffULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000005b2e5f7212ULL, 0x080fe200078efcffULL, 0x000000001a4d7faeULL, 0x0003e4000b901c46ULL,
0x000000010d257824ULL, 0x000fe200000e0625ULL, 0x0000002b0c1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000802c2c7825ULL, 0x000fe200078e00ffULL, 0x0000005b28617212ULL, 0x080fe200078efcffULL,
0x000000001c4b7faeULL, 0x0003e4000b901c46ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000005b2c5d7212ULL, 0x000fc600078efcffULL, 0x000000010d1f7824ULL, 0x040fe200000e061fULL,
0x0000005b2a5b7212ULL, 0x000fe200078efcffULL, 0x000000010d217824ULL, 0x040fe200008e0621ULL,
0x000000610c287210ULL, 0x000fe20007f1e0ffULL, 0x000000010d277824ULL, 0x040fe200010e0627ULL,
0x0000005f0c2e7210ULL, 0x000fe40007f3e0ffULL, 0x0000005d0c2c7210ULL, 0x000fe20007f5e0ffULL,
0x000000010d297824ULL, 0x040fe200000e0629ULL, 0x0000005b0c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d2f7824ULL, 0x040fe200008e062fULL, 0x00000000203f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d2d7824ULL, 0x000fc400010e062dULL, 0x000000010d0d7824ULL, 0x000fe200018e062bULL,
0x00000000243d7faeULL, 0x0003e8000b901c46ULL, 0x0000000026377faeULL, 0x0003e8000b901c46ULL,
0x000000001e357faeULL, 0x0003e8000b901c46ULL, 0x0000000028337faeULL, 0x0003e8000b901c46ULL,
0x000000002e317faeULL, 0x0003e8000b901c46ULL, 0x000000002c307faeULL, 0x0003e8000b901c46ULL,
0x000000000c057faeULL, 0x0003e4000b901c46ULL, 0x0000000202027836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff057424ULL, 0x002fc600078e00ffULL,
0x0000003b0200720cULL, 0x000fda0003f06070ULL, 0x00009200ff108b82ULL, 0x000e620000000a00ULL,
0x00000002090d8824ULL, 0x000fe400078e0202ULL, 0x0000002006127836ULL, 0x000fe20000000000ULL,
0xfffffff8064d7812ULL, 0x000fe200078ec0ffULL, 0x00002000224c7824ULL, 0x000fe200078e0223ULL,
0x00000007064b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4f7224ULL, 0x000fe200078e00ffULL,
0x00000004ff4a7819ULL, 0x000fe40000011606ULL, 0x00000000000e7805ULL, 0x000fc4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000040d108825ULL, 0x002fe200078e0010ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000610058981ULL, 0x000322000c1e1900ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x000010004c4c7836ULL, 0x000fe20000000000ULL, 0x000000074d4d7812ULL, 0x000fe400078ef806ULL,
0x000000084b4e7812ULL, 0x000fe400078ef806ULL, 0xfffffff812117812ULL, 0x002fc800078ec0ffULL,
0x0000000711487812ULL, 0x000fce00078ef806ULL, 0x000000014d107824ULL, 0x040fe400078e024fULL,
0x000000084d117824ULL, 0x000fe400078e00ffULL, 0x000000024f157824ULL, 0x000fe400078e024aULL,
0x000000104e357824ULL, 0x040fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee210ULL,
0x000000014e147824ULL, 0x140fe200078e0215ULL, 0x000000024e507810ULL, 0x000fe20007ffe015ULL,
0x0000000148167824ULL, 0x000fc400078e024fULL, 0x0000001011117824ULL, 0x000fe200078e024cULL,
0xfffffff035147812ULL, 0x000fe200078ee214ULL, 0x0000000848177824ULL, 0x040fe400078e00ffULL,
0x000000014f157836ULL, 0x000fe40000000000ULL, 0x000000001110783bULL, 0x000e620000000200ULL,
0x000000084d367824ULL, 0x040fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee216ULL,
0x000000014d357824ULL, 0x100fe400078e0215ULL, 0x0000000148537824ULL, 0x000fc400078e0215ULL,
0x000000104e377824ULL, 0x000fe200078e00ffULL, 0xfffffff836157812ULL, 0x000fe200078ee235ULL,
0x00000008483c7824ULL, 0x000fe400078e00ffULL, 0x0000001017177824ULL, 0x100fe200078e024cULL,
0xfffffff037507812ULL, 0x000fe200078ee250ULL, 0x00000010155e7824ULL, 0x000fe200078e024cULL,
0xfffffff83c537812ULL, 0x000fe200078ee253ULL, 0x000000024f4f7836ULL, 0x000fca0000000000ULL,
0x000000084f00780cULL, 0x000fe40003f05270ULL, 0x00000018ff167819ULL, 0x102fe40000011610ULL,
0x000000ff10347812ULL, 0x040fe400078ec0ffULL, 0x00000016ff35723eULL, 0x000fe400020006ffULL,
0x00000010ff167819ULL, 0x000fe40000011610ULL, 0x0000ffff10587812ULL, 0x000fe200078ec0ffULL,
0x20000035ff3f7230ULL, 0x000fe20000004100ULL, 0x00000018ff107819ULL, 0x000fc40000011611ULL,
0x00000010ff367819ULL, 0x000fe40000011611ULL, 0x00000010ff10723eULL, 0x000fe400020006ffULL,
0x000000ff11377812ULL, 0x040fe400078ec0ffULL, 0x0000ffff11597812ULL, 0x000fe200078ec0ffULL,
0x20000010ff567230ULL, 0x000fe20000004100ULL, 0x00000018ff117819ULL, 0x000fe40000011612ULL,
0x00000034ff34723eULL, 0x000fc400020006ffULL, 0x00000010ff5a7819ULL, 0x000fe40000011612ULL,
0x000000ff12517812ULL, 0x040fe200078ec0ffULL, 0x20000034ff3e7230ULL, 0x000fe20000004100ULL,
0x0000ffff125c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff127819ULL, 0x000fe40000011613ULL,
0x00000011ff11723eULL, 0x000fe400020006ffULL, 0x0000000814107c11ULL, 0x000fc4000f8e20ffULL,
0x00000010ff3c7819ULL, 0x000fe20000011613ULL, 0x20000011ff547230ULL, 0x000fe20000004100ULL,
0x000000ff13527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff133d7812ULL, 0x000fe400078ec0ffULL,
0x00000012ff34723eULL, 0x000fe400020006ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000052ff14723eULL, 0x000fe200020006ffULL,
0x20000034ff527230ULL, 0x000fe20000004100ULL, 0x000000ff16167812ULL, 0x000fe200078ec0ffULL,
0x20000051ff557230ULL, 0x000fe20000004100ULL, 0x000000ff36367812ULL, 0x000fe200078ec0ffULL,
0x20000014ff517230ULL, 0x000fe20000004100ULL, 0x00000008ff147819ULL, 0x000fc40000011658ULL,
0x00000008ff587819ULL, 0x000fe40000011659ULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x00000016ff16723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe200020006ffULL,
0x20000037ff577230ULL, 0x000fe20000004100ULL, 0x00000036ff59723eULL, 0x000fe200020006ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000014ff147230ULL, 0x000fe20000004100ULL, 0x000000ff5a5b7812ULL, 0x000fe200078ec0ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000008ff5a7819ULL, 0x000fe2000001165cULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x000000ff3c5d7812ULL, 0x000fe200078ec0ffULL,
0x000000001734783bULL, 0x000ea20000000200ULL, 0x00000010ff3f7819ULL, 0x000fc4000001163fULL,
0x00000010ff3e7819ULL, 0x000fe4000001163eULL, 0x00000010ff167819ULL, 0x000fe40000011616ULL,
0x00000010ff157819ULL, 0x000fe40000011614ULL, 0x00000008ff5c7819ULL, 0x000fe4000001163dULL,
0x00000010ff3c7819ULL, 0x000fe40000011657ULL, 0x00000010ff567819ULL, 0x000fc40000011656ULL,
0x00000010ff3d7819ULL, 0x000fe40000011659ULL, 0x00000010ff577819ULL, 0x000fe40000011658ULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x000010543f3f7816ULL, 0x000fe20000000016ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00001054153e7816ULL, 0x000fe2000000003eULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00001054563d7816ULL, 0x000fe2000000003dULL, 0x000000005e14783bULL, 0x000ee20000000200ULL,
0x00001054573c7816ULL, 0x000fc4000000003cULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x0000003e1030723cULL, 0x002fe20000041830ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x2000005dff5d7230ULL, 0x000fe40000004100ULL,
0x0000003c102c723cULL, 0x000fe2000004182cULL, 0x00000010ff3e7819ULL, 0x000fe20000011654ULL,
0x2000005cff587230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fc40000011655ULL,
0x00000010ff3f7819ULL, 0x000fe4000001165aULL, 0x00000010533c7824ULL, 0x000fe200078e024cULL,
0x00000010ff557819ULL, 0x000fe4000001165bULL, 0x000010543f547816ULL, 0x000fe40000000054ULL,
0x000010543e557816ULL, 0x000fe40000000055ULL, 0x000000003c3c783bULL, 0x000e620000000200ULL,
0x00000010ff6a7819ULL, 0x004fc40000011634ULL, 0x00000018ff757819ULL, 0x000fe40000011634ULL,
0x000000ff34737812ULL, 0x040fe200078ec0ffULL, 0x000000541028723cULL, 0x000fe20000041828ULL,
0x0000ffff34667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x000fe40000011652ULL,
0x00000010ff537819ULL, 0x000fe4000001165dULL, 0x00000010ff527819ULL, 0x000fc40000011658ULL,
0x00000018ff5a7819ULL, 0x000fe40000011635ULL, 0x0000ffff375d7812ULL, 0x000fe400078ec0ffULL,
0x0000105434537816ULL, 0x000fe40000000053ULL, 0x0000105452527816ULL, 0x000fe40000000051ULL,
0x000000ff14697812ULL, 0x008fe400078ec0ffULL, 0x00000010ff577819ULL, 0x000fc40000011636ULL,
0x00000018ff707819ULL, 0x000fe20000011636ULL, 0x000000521024723cULL, 0x000fe20000041824ULL,
0x000000ff366f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff365c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff567819ULL, 0x100fe40000011637ULL, 0x00000018ff6d7819ULL, 0x000fe40000011637ULL,
0x00000010ff367819ULL, 0x000fc40000011616ULL, 0x00000018ff627819ULL, 0x000fe40000011616ULL,
0x000000ff165e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff16547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x000fe40000011635ULL, 0x0000005aff16723eULL, 0x000fe400020006ffULL,
0x00000008ff5d7819ULL, 0x000fc4000001165dULL, 0x0000ffff35637812ULL, 0x000fe200078ec0ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x00000018ff677819ULL, 0x000fe40000011615ULL,
0x00000010ff5a7819ULL, 0x102fe4000001163dULL, 0x00000018ff797819ULL, 0x000fe4000001163dULL,
0x000000ff3d787812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3d6e7812ULL, 0x000fc400078ec0ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x000000ff3e3d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x000000ff376b7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff14587812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x000000ff56567812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x000fe40000011615ULL,
0x000000ff15647812ULL, 0x000fe400078ec0ffULL, 0x000000ff61527812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000018ff5f7819ULL, 0x000fc40000011617ULL,
0x00000008ff537819ULL, 0x000fe40000011663ULL, 0x00000067ff61723eULL, 0x000fe200020006ffULL,
0x20000069ff677230ULL, 0x000fe20000004100ULL, 0x000000ff6a767812ULL, 0x000fe400078ec0ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x0000003dff63723eULL, 0x000fe400020006ffULL, 0x00000018ff6c7819ULL, 0x000fe20000011614ULL,
0x2000005cff727230ULL, 0x000fe20000004100ULL, 0x000000ff3f687812ULL, 0x000fc400078ec0ffULL,
0x0000006bff6a723eULL, 0x000fe200020006ffULL, 0x2000006dff6b7230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x2000005dff6d7230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe20000011658ULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x000000ff34587812ULL, 0x000fe200078ec0ffULL,
0x20000063ff347230ULL, 0x000fe20000004100ULL, 0x000000ff17557812ULL, 0x000fc400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x000000ff35597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff377819ULL, 0x000fe40000011614ULL, 0x00000010ff517819ULL, 0x100fe4000001163eULL,
0x00000018ff777819ULL, 0x000fe4000001163eULL, 0x0000ffff3e657812ULL, 0x000fc400078ec0ffULL,
0x00000008ff747819ULL, 0x000fe40000011666ULL, 0x0000005eff5d723eULL, 0x000fe400020006ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001163fULL, 0x0000006cff66723eULL, 0x000fe200020006ffULL,
0x20000056ff6c7230ULL, 0x000fe20000004100ULL, 0x00000068ff5e723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000ffff15357812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000062ff5c723eULL, 0x000fe200020006ffULL,
0x20000064ff627230ULL, 0x000fe20000004100ULL, 0x00000058ff63723eULL, 0x000fc400020006ffULL,
0x00000010ff157819ULL, 0x000fe20000011617ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000ffff17147812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000055ff56723eULL, 0x000fe200020006ffULL, 0x2000005fff557230ULL, 0x000fe20000004100ULL,
0x000000ff36587812ULL, 0x000fe200078ec0ffULL, 0x2000005eff367230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000059ff17723eULL, 0x000fc400020006ffULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x000000ff37647812ULL, 0x000fe200078ec0ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fe2000001163cULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x0000003eff5f723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fc400020006ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001163cULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff3c7a7812ULL, 0x040fe200078ec0ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000058ff5e723eULL, 0x000fe400020006ffULL, 0x0000ffff3c3c7812ULL, 0x000fe400078ec0ffULL,
0x00000064ff68723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x000000ff15587812ULL, 0x000fc400078ec0ffULL, 0x00000008ff147819ULL, 0x000fe20000011614ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000008ff647819ULL, 0x000fe20000011635ULL,
0x2000005fff357230ULL, 0x000fe20000004100ULL, 0x000000ff59157812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5f7819ULL, 0x000fe40000011654ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x00000014ff59723eULL, 0x000fc400020006ffULL, 0x00000008ff547819ULL, 0x000fe2000001163cULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000015ff14723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x000000ff5a3c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x000fe40000011675ULL, 0x00000010ff157819ULL, 0x000fe40000011676ULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff747819ULL, 0x000fe20000011674ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x000010545a157816ULL, 0x000fe20000000015ULL, 0x20000014ff5a7230ULL, 0x000fe20000004100ULL,
0x0000105474147816ULL, 0x000fe40000000073ULL, 0x00000010ff757819ULL, 0x000fe40000011616ULL,
0x00000010ff167819ULL, 0x000fc40000011652ULL, 0x0000000850747c11ULL, 0x000fe2000f8e20ffULL,
0x000000141020723cULL, 0x000fe20000041820ULL, 0x00000010ff737819ULL, 0x000fe40000011653ULL,
0x000000ff57717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff527819ULL, 0x000fe40000011617ULL,
0x0000105475537816ULL, 0x000fe40000000016ULL, 0x000000007414783bULL, 0x000e620000000200ULL,
0x00000010ff607819ULL, 0x000fc4000001163fULL, 0x0000ffff3f5b7812ULL, 0x000fe400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000006fff3f723eULL, 0x000fe200020006ffULL, 0x20000070ff6f7230ULL, 0x000fe20000004100ULL,
0x0000105473527816ULL, 0x000fe20000000052ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe2000001166eULL, 0x2000003fff707230ULL, 0x000fe20000004100ULL,
0x000000ff51757812ULL, 0x000fc400078ec0ffULL, 0x00000010ff6e7819ULL, 0x000fe2000001166fULL,
0x00000052101c723cULL, 0x000fe2000004181cULL, 0x00000010ff517819ULL, 0x000fe40000011671ULL,
0x00000010ff507819ULL, 0x000fe40000011670ULL, 0x00000010ff6f7819ULL, 0x000fe40000011672ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x000010546e517816ULL, 0x000fc40000000051ULL,
0x000010546f507816ULL, 0x000fe20000000050ULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fe4000001166bULL, 0x00000010ff527819ULL, 0x000fe4000001166aULL,
0x00000010ff537819ULL, 0x000fe2000001166cULL, 0x000000501018723cULL, 0x000fe20000041818ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x000010546e537816ULL, 0x000fe40000000053ULL, 0x000010546d527816ULL, 0x000fe20000000052ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe40000011666ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x00000052100c723cULL, 0x000fe2000004180cULL, 0x00000010ff507819ULL, 0x000fc40000011669ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000105451137816ULL, 0x000fe20000000068ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000105450127816ULL, 0x000fe20000000067ULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff507819ULL, 0x000fe40000011661ULL, 0x00000010ff107819ULL, 0x000fc40000011662ULL,
0x00000010ff117819ULL, 0x000fe20000011663ULL, 0x000000121430723cULL, 0x002fe20000041830ULL,
0x00000010ff517819ULL, 0x000fe40000011664ULL, 0x0000105450117816ULL, 0x000fe40000000011ULL,
0x0000105451107816ULL, 0x000fe40000000010ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fc400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x00000010142c723cULL, 0x000fe2000004182cULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x2000007aff3d7230ULL, 0x000fe20000004100ULL, 0x00000008ff657819ULL, 0x000fe20000011665ULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff60607812ULL, 0x000fe200078ec0ffULL,
0x20000078ff377230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe2000001165bULL,
0x20000073ff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x00000010ff127819ULL, 0x000fe4000001165dULL, 0x00000010ff137819ULL, 0x000fe4000001165eULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff107819ULL, 0x000fe40000011655ULL,
0x00000010ff517819ULL, 0x000fe40000011658ULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x0000007bff57723eULL, 0x000fe400020006ffULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000077ff3f723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000079ff3e7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000060ff53723eULL, 0x000fe200020006ffULL,
0x20000075ff6a7230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe200020006ffULL,
0x20000065ff527230ULL, 0x000fe20000004100ULL, 0x000010545c137816ULL, 0x000fe20000000013ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x000010545f127816ULL, 0x000fe20000000012ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000105410517816ULL, 0x000fc40000000051ULL,
0x00000010ff107819ULL, 0x000fe4000001163dULL, 0x00000010ff3d7819ULL, 0x000fe2000001163cULL,
0x000000121428723cULL, 0x000fe20000041828ULL, 0x00000010ff377819ULL, 0x000fe40000011637ULL,
0x00000010ff3c7819ULL, 0x000fe4000001166bULL, 0x00000010ff507819ULL, 0x000fe40000011656ULL,
0x00000010ff127819ULL, 0x000fc40000011634ULL, 0x00000010ff137819ULL, 0x000fe40000011654ULL,
0x000010543c3c7816ULL, 0x000fe40000000037ULL, 0x00000010ff347819ULL, 0x000fe40000011635ULL,
0x00000010ff567819ULL, 0x000fe40000011657ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff117819ULL, 0x000fc4000001165aULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x00000010ff3f7819ULL, 0x000fe4000001163fULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff357819ULL, 0x000fe40000011652ULL, 0x00000010ff377819ULL, 0x000fe40000011653ULL,
0x00000010ff367819ULL, 0x000fc40000011636ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x0000105413107816ULL, 0x000fe40000000010ULL, 0x0000105459507816ULL, 0x000fe40000000050ULL,
0x0000105456117816ULL, 0x000fe40000000011ULL, 0x000010543e3d7816ULL, 0x000fe4000000003dULL,
0x000010543f137816ULL, 0x000fe2000000006aULL, 0x000000501424723cULL, 0x000fe20000041824ULL,
0x0000105435127816ULL, 0x000fc40000000012ULL, 0x0000105434377816ULL, 0x000fe40000000037ULL,
0x000010545b367816ULL, 0x000fe20000000036ULL, 0x000000101420723cULL, 0x000fec0000041820ULL,
0x0000003c141c723cULL, 0x000fec000004181cULL, 0x000000121418723cULL, 0x000fec0000041818ULL,
0x00000036140c723cULL, 0x000fe2000004180cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe800300947ULL, 0x000fde000383ffffULL, 0x00000001ff117424ULL, 0x000fe400078e00ffULL,
0x0000000830137220ULL, 0x080fe20000410000ULL, 0x000000081c307220ULL, 0x080fe20000410000ULL,
0x000000081d347220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000832327220ULL, 0x080fe20000410000ULL, 0x017688110a1079a7ULL, 0x000262000850003fULL,
0x0000000833337220ULL, 0x080fe20000410000ULL, 0x000000082c127220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x000000082e2e7220ULL, 0x080fe20000410000ULL,
0x000000082f2f7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x000000082a2a7220ULL, 0x080fe20000410000ULL,
0x000000082b2b7220ULL, 0x080fe20000410000ULL, 0x0000000824247220ULL, 0x080fe20000410000ULL,
0x0000000825257220ULL, 0x080fe20000410000ULL, 0x0000000826267220ULL, 0x080fe20000410000ULL,
0x0000000827277220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x080fe20000410000ULL, 0x0000000822227220ULL, 0x080fe20000410000ULL,
0x0000000823237220ULL, 0x080fe20000410000ULL, 0x000000081e1e7220ULL, 0x080fe20000410000ULL,
0x000000081f1f7220ULL, 0x080fe20000410000ULL, 0x0000000818357220ULL, 0x080fe20000410000ULL,
0x0000000819367220ULL, 0x080fe20000410000ULL, 0x000000081a1c7220ULL, 0x080fe20000410000ULL,
0x000000081b177220ULL, 0x080fe20000410000ULL, 0x000000080c377220ULL, 0x080fe20000410000ULL,
0x000000080d3c7220ULL, 0x080fe20000410000ULL, 0x000000080e167220ULL, 0x080fe20000410000ULL,
0x000000080f1d7220ULL, 0x002fce0000410000ULL, 0x00000000000c7805ULL, 0x000fce0000015200ULL,
0x017688110a0075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff147224ULL, 0x000fce00078e00ffULL, 0x000000101400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fce0000015200ULL,
0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000114147836ULL, 0x000fce0000000000ULL, 0x017688110a0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000004060c7824ULL, 0x000fe200078e00ffULL,
0x00000008400d7c11ULL, 0x000fe4000f8e38ffULL, 0x000000044700720cULL, 0x000fe40003f06070ULL,
0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL, 0x000000010d2c7824ULL, 0x000fca00078e020cULL,
0x017400002c187984ULL, 0x0002a20000000c00ULL, 0x0000001400248947ULL, 0x000fea0003800000ULL,
0x0000860000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x00000004000e7d06ULL, 0x000ee20008209000ULL, 0xffffff00493d7836ULL, 0x000fe20000000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bf85070ULL, 0x00000002063e7824ULL, 0x000fe200078e00ffULL,
0x00000004ff147c12ULL, 0x000fc8000f8e33ffULL, 0x000000063e3e7812ULL, 0x000fca00078ec0ffULL,
0x000000013e487824ULL, 0x000fe200078e0203ULL, 0x0000000e000e7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0e107836ULL, 0x008fcc0000000000ULL, 0x00000010000d7305ULL, 0x000ee4000021f000ULL,
0x000000ffff0f7224ULL, 0x008fc800078e0a0dULL, 0x000000040f0f7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000f0d117227ULL, 0x000fe200078e000cULL, 0x00000041060c7211ULL, 0x000fca00078ff0ffULL,
0x0000000c110d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fc800078e0a0dULL,
0x000000040f0e7c24ULL, 0x000fe4000f8e020cULL, 0x000000080c0c7836ULL, 0x000fc60000000000ULL,
0x000000040e007c0cULL, 0x000fe2000bf06070ULL, 0x0000000c11107227ULL, 0x000fc800078e00ffULL,
0x000000ffff0f7224ULL, 0x000fc800078e0a10ULL, 0x000000040f0f7c24ULL, 0x000fe2000f8e020cULL,
0x0000003d3a0c7248ULL, 0x000fc60007fe0000ULL, 0x800000040e0e0c36ULL, 0x000fe20008000000ULL,
0x000000040f007c0cULL, 0x000fe2000bf46070ULL, 0x000000010c3d7824ULL, 0x000fe400078e0a3dULL,
0x000000010d0d0836ULL, 0x000fe20000000000ULL, 0x000000040e007c0cULL, 0x000fe2000bf26070ULL,
0x00000001390e7824ULL, 0x000fe400078e023eULL, 0x000000ffff607224ULL, 0x000fc600078e0a3dULL,
0x0000003d0e00720cULL, 0x000fe40003f66070ULL, 0x000000600e0e7246ULL, 0x000fe2000380000bULL,
0x800000040f0f2c36ULL, 0x000fe20008000000ULL, 0x0000006048577246ULL, 0x000fe2000380000bULL,
0x0000000110102836ULL, 0x000fe20000000000ULL, 0x00000004ff0e7819ULL, 0x000fe2000001160eULL,
0x000000010d0d1836ULL, 0x000fe20000000000ULL, 0x000000040f007c0cULL, 0x000fe4000bf06070ULL,
0x000000ff0e117207ULL, 0x000fc40001800000ULL, 0x0000000d140c7207ULL, 0x000fe40006000000ULL,
0x0000003d4800720cULL, 0x000fe40003f26070ULL, 0x0000000c0b0c7248ULL, 0x000fe40003fe0000ULL,
0x000000ff57577207ULL, 0x000fc60000800000ULL, 0x000000050c627c24ULL, 0x000fe4000f8e02ffULL,
0x0000000110100836ULL, 0x000fe40000000000ULL, 0x00000001620d7824ULL, 0x000fe200078e0211ULL,
0x00000062570f7211ULL, 0x000fe400078fe0ffULL, 0x000000103e4c7812ULL, 0x000fe200078efcffULL,
0x000000020d0c7825ULL, 0x000fe200078e0044ULL, 0x0000001014107207ULL, 0x000fc60006000000ULL,
0x000000020f0e7825ULL, 0x000fe200078e0044ULL, 0x000000060c5b7981ULL, 0x0044e2000c1e9500ULL,
0x000000100b107248ULL, 0x000fc60003fe0000ULL, 0x000000060e5e7981ULL, 0x000ae4000c1e9500ULL,
0x0000000510647c24ULL, 0x000fe4000f8e02ffULL, 0x00000001390c7824ULL, 0x004fc600078e024cULL,
0x0000006457157211ULL, 0x000fe200078fe0ffULL, 0x0000000111117824ULL, 0x000fe200078e0264ULL,
0x000000600c0d7246ULL, 0x000fc6000380000bULL, 0x0000000211107825ULL, 0x000fe200078e0044ULL,
0x0000003d0c00720cULL, 0x080fe40003f26070ULL, 0x00000004ff0d7819ULL, 0x000fe2000001160dULL,
0x0000000215147825ULL, 0x000fe200078e0044ULL, 0x000000203e507812ULL, 0x000fe200078efcffULL,
0x0000000610557981ULL, 0x0004e2000c1e9500ULL, 0x000000ff0d4d7207ULL, 0x000fe20000800000ULL,
0x000000014c4a7824ULL, 0x000fe400078e0203ULL, 0x0000000139547824ULL, 0x000fe200078e0250ULL,
0x0000000614667981ULL, 0x0004e2000c1e9500ULL, 0x00000001620d7824ULL, 0x000fe200078e024dULL,
0x0000003d4a00720cULL, 0x000fc40003f06070ULL, 0x000000604a3f7246ULL, 0x000fe2000380000bULL,
0x000000020d0c7825ULL, 0x000fe200078e0044ULL, 0x00000060544f7246ULL, 0x000fe4000380000bULL,
0x000000ff3f3f7207ULL, 0x000fe40000000000ULL, 0x000000060c497981ULL, 0x0004e2000c1e9500ULL,
0x0000003d5400720cULL, 0x000fe20003f26070ULL, 0x0000000150527824ULL, 0x000fe200078e0203ULL,
0x000000623f0f7211ULL, 0x022fe200078fe0ffULL, 0x000000014d117824ULL, 0x004fe200078e0264ULL,
0x000000643f157211ULL, 0x000fc400078fe0ffULL, 0x00000004ff0c7819ULL, 0x000fe2000001164fULL,
0x000000020f0e7825ULL, 0x100fe200078e0044ULL, 0x000000303e567812ULL, 0x000fe400078efcffULL,
0x000000ff0c537207ULL, 0x000fe20000800000ULL, 0x0000000211107825ULL, 0x100fe200078e0044ULL,
0x0000003d5200720cULL, 0x000fe20003f06070ULL, 0x000000060e4e7981ULL, 0x0002a2000c1e9500ULL,
0x00000060524f7246ULL, 0x000fe2000380000bULL, 0x0000000215147825ULL, 0x000fe400078e0044ULL,
0x00000006104d7981ULL, 0x000aa4000c1e9500ULL, 0x00000001620d7824ULL, 0x000fc400078e0253ULL,
0x0000000139687824ULL, 0x000fe200078e0256ULL, 0x000000ff4f4f7207ULL, 0x000fe20000000000ULL,
0x0000000614547981ULL, 0x000aa2000c1e9500ULL, 0x000000020d0c7825ULL, 0x000fe400078e0044ULL,
0x0000006068597246ULL, 0x000fe4000380000bULL, 0x00000001565a7824ULL, 0x000fe200078e0203ULL,
0x000000624f0f7211ULL, 0x002fe200078fe0ffULL, 0x0000000153117824ULL, 0x020fe200078e0264ULL,
0x000000060c517981ULL, 0x000362000c1e9500ULL, 0x000000644f157211ULL, 0x000fc400078fe0ffULL,
0x000000020f0e7825ULL, 0x100fe200078e0044ULL, 0x0000003d6800720cULL, 0x080fe40003f26070ULL,
0x0000003d5a00720cULL, 0x000fe20003f06070ULL, 0x0000000211107825ULL, 0x000fe200078e0044ULL,
0x000000060e587981ULL, 0x000364000c1e9500ULL, 0x00000004ff0c7819ULL, 0x002fe20000011659ULL,
0x0000000215147825ULL, 0x000fe200078e0044ULL, 0x000000605a597246ULL, 0x000fe2000380000bULL,
0x0000000610537981ULL, 0x000362000c1e9500ULL, 0x000000ff0c5d7207ULL, 0x000fc40000800000ULL,
0x000000ff59597207ULL, 0x000fe20000000000ULL, 0x00000006145c7981ULL, 0x000364000c1e9500ULL,
0x00000001620d7824ULL, 0x000fe200078e025dULL, 0x00000062590f7211ULL, 0x000fc600078fe0ffULL,
0x000000020d0c7825ULL, 0x000fc800078e0044ULL, 0x000000020f0e7825ULL, 0x000fe400078e0044ULL,
0x000000060c0c7981ULL, 0x000364000c1e9500ULL, 0x0000006459117211ULL, 0x002fe400078fe0ffULL,
0x000000060e0f7981ULL, 0x000362000c1e9500ULL, 0x000000015d157824ULL, 0x000fe400078e0264ULL,
0x0000000211107825ULL, 0x000fc800078e0044ULL, 0x0000000215147825ULL, 0x000fe400078e0044ULL,
0x0000000610107981ULL, 0x000f68000c1e9500ULL, 0x0000000614157981ULL, 0x000362000c1e9500ULL,
0xfffffff057627812ULL, 0x000fe200078ec0ffULL, 0x00000001ff577424ULL, 0x000fc800078e00ffULL,
0x000000013d0d7824ULL, 0x000fc800078e0262ULL, 0x0000000148687824ULL, 0x000fe200078e0a0dULL,
0x000000013e607812ULL, 0x040fe400078efcffULL, 0x000000093e0e7812ULL, 0x002fe400078efcffULL,
0x0000006857687219ULL, 0x000fe200000006ffULL, 0x0000000160647824ULL, 0x100fe400078e0203ULL,
0x000000010e147824ULL, 0x000fe400078e0203ULL, 0x00000001646a7824ULL, 0x000fc400078e0a0dULL,
0x00000001146e7824ULL, 0x000fc600078e0a0dULL, 0x0000006a576a7219ULL, 0x040fe400000006ffULL,
0x0000006e576e7219ULL, 0x000fe400000006ffULL, 0x000000113e7a7812ULL, 0x040fe400078efcffULL,
0x000000183e787812ULL, 0x040fe400078efcffULL, 0xfffffff04f4f7812ULL, 0x000fe400078ec0ffULL,
0x000000193e767812ULL, 0x000fc400078efcffULL, 0xfffffff059597812ULL, 0x000fe200078ec0ffULL,
0x000000017a117824ULL, 0x000fe400078e0203ULL, 0x000000013d717824ULL, 0x040fe400078e024fULL,
0x00000001767c7824ULL, 0x000fe400078e0203ULL, 0x000000013d657824ULL, 0x000fe400078e0259ULL,
0x0000000152737824ULL, 0x000fe200078e0a71ULL, 0x000000213e707812ULL, 0x000fca00078efcffULL,
0x0000000170747824ULL, 0x000fe400078e0203ULL, 0x000000015a6b7824ULL, 0x000fe400078e0a65ULL,
0x00000001746d7824ULL, 0x000fc600078e0a71ULL, 0x0000006b576b7219ULL, 0x040fe400000006ffULL,
0x0000006d576d7219ULL, 0x000fe400000006ffULL, 0x000054105e5b7816ULL, 0x008fe4000000005bULL,
0x000000083e5e7812ULL, 0x000fe400078efcffULL, 0x0000005b68ff7212ULL, 0x000fc6000780c0ffULL,
0x000000015e627824ULL, 0x000fe200078e0203ULL, 0x0000003d4800720cULL, 0x000fc60000701470ULL,
0x00000001626c7824ULL, 0x000fe200078e0a0dULL, 0x0000003d3e00720cULL, 0x000fc800007a1070ULL,
0x0000006c576c7219ULL, 0x000fe400000006ffULL, 0xff80000013137808ULL, 0x000fe40002800000ULL,
0x0000541066557816ULL, 0x000fc80000000055ULL, 0x0000005568ff7212ULL, 0x080fe4000784c0ffULL,
0x000000556aff7212ULL, 0x080fe4000780c0ffULL, 0x000000556cff7212ULL, 0x080fe400078cc0ffULL,
0x000000556eff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff03f557812ULL, 0x000fe200078ec0ffULL,
0x00000001780d7824ULL, 0x000fc800078e0203ULL, 0x000000013d557824ULL, 0x000fe200078e0255ULL,
0x0000005b6aff7212ULL, 0x080fe4000782c0ffULL, 0x0000005b6cff7212ULL, 0x080fe2000786c0ffULL,
0x000000014a4f7824ULL, 0x100fe200078e0a55ULL, 0x0000005b6eff7212ULL, 0x000fe2000788c0ffULL,
0x0000000111597824ULL, 0x100fe200078e0a55ULL, 0x0000003d4800720cULL, 0x080fe20001741470ULL,
0x000000010d5b7824ULL, 0x100fe200078e0a55ULL, 0x0000003d6200720cULL, 0x080fe400037c1470ULL,
0x0000003d1400720cULL, 0x000fe20002fa1470ULL, 0x000000017c637824ULL, 0x000fe200078e0a55ULL,
0x0000004f57557219ULL, 0x000fc400000006ffULL, 0x00000059574f7219ULL, 0x040fe400000006ffULL,
0x0000003d3e00720cULL, 0x080fe40001741070ULL, 0x0000003d5e00720cULL, 0x080fe400037c1070ULL,
0x0000003d0e00720cULL, 0x000fe40002fa1070ULL, 0x0000005b57597219ULL, 0x000fe400000006ffULL,
0x000054104e4e7816ULL, 0x004fc40000000049ULL, 0x0000541054547816ULL, 0x000fe4000000004dULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002800000ULL, 0x0000004e55ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005455ff7212ULL, 0x000fc400078cc0ffULL, 0x0000005459ff7212ULL, 0x000fe400078ac0ffULL,
0x0000003d6400720cULL, 0x0c0fe40000f21470ULL, 0x0000003d6400720cULL, 0x080fe40000701470ULL,
0x0000003d6200720cULL, 0x080fe40001f61470ULL, 0x0000003d1400720cULL, 0x080fe40002781470ULL,
0x0000003d4a00720cULL, 0x000fc40001741470ULL, 0x0000003d4a00720cULL, 0x080fe400037c1470ULL,
0x0000003d0d00720cULL, 0x080fe40002fa1470ULL, 0x000000283e6e7812ULL, 0x040fe400078efcffULL,
0x000000293e6c7812ULL, 0x000fe400078efcffULL, 0x0000003d6000720cULL, 0x0c0fe40000f21070ULL,
0x0000003d6000720cULL, 0x000fc40000701070ULL, 0x0000003d5e00720cULL, 0x080fe40001f61070ULL,
0x0000003d0e00720cULL, 0x080fe40002781070ULL, 0x0000003d4c00720cULL, 0x0c0fe40001741070ULL,
0x0000003d4c00720cULL, 0x080fe400037c1070ULL, 0x0000003d7800720cULL, 0x000fe40002fa1070ULL,
0x0000006357637219ULL, 0x000fc400000006ffULL, 0x00000073575b7219ULL, 0x000fe400000006ffULL,
0x0000541058587816ULL, 0x020fe40000000051ULL, 0x000054105c5c7816ULL, 0x000fe20000000053ULL,
0x000000016e727824ULL, 0x100fe200078e0203ULL, 0xff80000031317808ULL, 0x000fe20000800000ULL,
0x000000016c3f7824ULL, 0x000fe200078e0203ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff80000012127808ULL, 0x000fc40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0x0000004e4fff7212ULL, 0x080fe4000782c0ffULL,
0x0000004e59ff7212ULL, 0x000fc4000780c0ffULL, 0x0000004e63ff7212ULL, 0x000fe4000786c0ffULL,
0x000000544fff7212ULL, 0x080fe4000788c0ffULL, 0x0000005463ff7212ULL, 0x000fe4000784c0ffULL,
0x000000585bff7212ULL, 0x040fe400078cc0ffULL, 0x0000005c5bff7212ULL, 0x000fe200078ac0ffULL,
0x00000001726f7824ULL, 0x100fe200078e0a71ULL, 0x0000003d1100720cULL, 0x080fe20000f21470ULL,
0x000000013f717824ULL, 0x000fe200078e0a71ULL, 0x0000003d1100720cULL, 0x000fc40002781470ULL,
0x0000003d0d00720cULL, 0x080fe40000701470ULL, 0x0000003d7c00720cULL, 0x0c0fe40001f61470ULL,
0x0000003d7c00720cULL, 0x080fe40001741470ULL, 0x0000003d5200720cULL, 0x0c0fe400037c1470ULL,
0x0000003d5200720cULL, 0x000fe40002fa1470ULL, 0x000000313e6a7812ULL, 0x000fc400078efcffULL,
0x000000383e687812ULL, 0x040fe400078efcffULL, 0x000000393e667812ULL, 0x000fe400078efcffULL,
0x0000003d7a00720cULL, 0x0c0fe40000f21070ULL, 0x0000003d7a00720cULL, 0x080fe40002781070ULL,
0x0000003d7800720cULL, 0x080fe40000701070ULL, 0x0000003d7600720cULL, 0x000fc40001f61070ULL,
0x0000003d7600720cULL, 0x080fe40001741070ULL, 0x0000003d5000720cULL, 0x0c0fe400037c1070ULL,
0x0000003d5000720cULL, 0x000fe40002fa1070ULL, 0x0000006f576f7219ULL, 0x040fe400000006ffULL,
0x0000007157717219ULL, 0x000fe400000006ffULL, 0x000054100f0c7816ULL, 0x000fe2000000000cULL,
0x000000016a617824ULL, 0x100fe200078e0203ULL, 0xff80000029297808ULL, 0x000fe20000800000ULL,
0x00000001685f7824ULL, 0x100fe200078e0203ULL, 0xff8000002b2b7808ULL, 0x000fe20002000000ULL,
0x00000001665d7824ULL, 0x000fe200078e0203ULL, 0xff80000024247808ULL, 0x000fc40000000000ULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000027277808ULL, 0x000fe40001000000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000022227808ULL, 0x000fe40002800000ULL,
0x000000586dff7212ULL, 0x080fe4000782c0ffULL, 0x000000586fff7212ULL, 0x000fc4000788c0ffULL,
0x0000005871ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005c6dff7212ULL, 0x080fe4000786c0ffULL,
0x0000005c6fff7212ULL, 0x080fe4000784c0ffULL, 0x0000005c71ff7212ULL, 0x000fe400078cc0ffULL,
0x0000000c6bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000161697824ULL, 0x100fe200078e0a65ULL,
0x0000003d7400720cULL, 0x0c0fe20000f21470ULL, 0x000000015f677824ULL, 0x100fe200078e0a65ULL,
0x0000003d7400720cULL, 0x080fe20001f61470ULL, 0x000000015d657824ULL, 0x000fe200078e0a65ULL,
0x0000003d7200720cULL, 0x000fc40002781470ULL, 0x0000003d7200720cULL, 0x080fe40001741470ULL,
0x0000003d3f00720cULL, 0x0c0fe40000701470ULL, 0x0000003d3f00720cULL, 0x080fe400037c1470ULL,
0x0000003d5a00720cULL, 0x080fe40002fa1470ULL, 0x0000003d7000720cULL, 0x0c0fe40000f21070ULL,
0x0000003d7000720cULL, 0x000fc40001f61070ULL, 0x0000003d6e00720cULL, 0x0c0fe40002781070ULL,
0x0000003d6e00720cULL, 0x080fe40001741070ULL, 0x0000003d6c00720cULL, 0x0c0fe40000701070ULL,
0x0000003d6c00720cULL, 0x080fe400037c1070ULL, 0x0000003d5600720cULL, 0x000fe40002fa1070ULL,
0x0000006957697219ULL, 0x000fc400000006ffULL, 0x0000006757677219ULL, 0x040fe400000006ffULL,
0x0000006557657219ULL, 0x000fe400000006ffULL, 0x0000541010107816ULL, 0x000fe40000000015ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000023237808ULL, 0x000fe40001800000ULL,
0xff80000030307808ULL, 0x000fc40002000000ULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff80000034347808ULL, 0x000fe40000000000ULL, 0xff8000001f1f7808ULL, 0x000fe40003000000ULL,
0xff80000035357808ULL, 0x000fe40002800000ULL, 0x0000000c69ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000c67ff7212ULL, 0x000fc4000786c0ffULL, 0x0000000c65ff7212ULL, 0x000fe4000788c0ffULL,
0x000000106bff7212ULL, 0x080fe4000784c0ffULL, 0x0000001069ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001067ff7212ULL, 0x080fe400078cc0ffULL, 0x0000001065ff7212ULL, 0x000fe400078ac0ffULL,
0x0000003d5a00720cULL, 0x000fc40001741470ULL, 0x0000003d6100720cULL, 0x0c0fe40000f21470ULL,
0x0000003d6100720cULL, 0x080fe40000701470ULL, 0x0000003d5f00720cULL, 0x0c0fe40001f61470ULL,
0x0000003d5f00720cULL, 0x080fe400037c1470ULL, 0x0000003d5d00720cULL, 0x0c0fe40002781470ULL,
0x0000003d5d00720cULL, 0x000fc40002fa1470ULL, 0x0000003d5600720cULL, 0x080fe40001741070ULL,
0x0000003d6a00720cULL, 0x0c0fe40000f21070ULL, 0x0000003d6a00720cULL, 0x080fe40000701070ULL,
0x0000003d6800720cULL, 0x0c0fe40001f61070ULL, 0x0000003d6800720cULL, 0x080fe400037c1070ULL,
0x0000003d6600720cULL, 0x000fc40002781070ULL, 0x0000003d6600720cULL, 0x000fe40002fa1070ULL,
0xff80000036367808ULL, 0x000fe40000800000ULL, 0xff80000037377808ULL, 0x000fe40001800000ULL,
0xff8000003c3c7808ULL, 0x000fe40002000000ULL, 0xff8000001c1c7808ULL, 0x000fe40001000000ULL,
0xff80000017177808ULL, 0x000fc40000000000ULL, 0xff80000016167808ULL, 0x000fe40003000000ULL,
0xff8000001d1d7808ULL, 0x000fce0002800000ULL, 0x000000131800720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000147477836ULL, 0x000fe40000000000ULL,
0x0000001813187208ULL, 0x000fc80004000000ULL, 0x000000311800720bULL, 0x000fc80003f1e000ULL,
0x00000018310d7208ULL, 0x000fc80004000000ULL, 0x000000120d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d120c7208ULL, 0x000fc80004000000ULL, 0x0000002d0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c2d0d7208ULL, 0x000fc80004000000ULL, 0x000000280d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d280c7208ULL, 0x000fc80004000000ULL, 0x000000290c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c290d7208ULL, 0x000fc80004000000ULL, 0x000000240d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d240c7208ULL, 0x000fc80004000000ULL, 0x000000250c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c250d7208ULL, 0x000fc80004000000ULL, 0x000000200d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d200c7208ULL, 0x000fc80004000000ULL, 0x000000210c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c210d7208ULL, 0x000fc80004000000ULL, 0x000000300d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d300d7208ULL, 0x000fe40004000000ULL, 0x000000321900720bULL, 0x000fe40003f1e000ULL,
0x000000340d00720bULL, 0x000fe40003f3e000ULL, 0x00000019320c7208ULL, 0x000fe40004000000ULL,
0x0000000d340e7208ULL, 0x000fe40004800000ULL, 0x000000330c00720bULL, 0x000fc40003f1e000ULL,
0x000000350e00720bULL, 0x000fe40003f3e000ULL, 0x0000000c330d7208ULL, 0x000fe40004000000ULL,
0x0000000e350f7208ULL, 0x000fe40004800000ULL, 0x0000002e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000360f00720bULL, 0x000fe40003f3e000ULL, 0x0000000d2e0c7208ULL, 0x000fc40004000000ULL,
0x0000000f360e7208ULL, 0x000fe40004800000ULL, 0x0000002f0c00720bULL, 0x000fe40003f1e000ULL,
0x000000370e00720bULL, 0x000fe40003f3e000ULL, 0x0000000c2f0d7208ULL, 0x000fe40004000000ULL,
0x0000000e370f7208ULL, 0x000fe40004800000ULL, 0x0000002a0d00720bULL, 0x000fc40003f1e000ULL,
0x0000003c0f00720bULL, 0x000fe40003f3e000ULL, 0x0000000d2a0c7208ULL, 0x000fe40004000000ULL,
0x0000000f3c0f7208ULL, 0x000fe40004800000ULL, 0x0000002b0c00720bULL, 0x000fc60003f1e000ULL,
0x0c401f000f0e7f89ULL, 0x000ea200000e0000ULL, 0x0000000c2b0d7208ULL, 0x000fc80004000000ULL,
0x000000260d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d260c7208ULL, 0x000fc80004000000ULL,
0x000000270c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c270d7208ULL, 0x000fc80004000000ULL,
0x000000220d00720bULL, 0x000fe40003f1e000ULL, 0x0000000e0f00720bULL, 0x004fe40003f3e000ULL,
0x0000000d220c7208ULL, 0x000fe40004000000ULL, 0x0000000f0e0e7208ULL, 0x000fe40004800000ULL,
0x000000230c00720bULL, 0x000fc60003f1e000ULL, 0x0c201f000e0f7f89ULL, 0x000ea200000e0000ULL,
0x0000000c230d7208ULL, 0x000fc80004000000ULL, 0x0000001e0d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d1e0c7208ULL, 0x000fc80004000000ULL, 0x0000001f0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c1f0d7208ULL, 0x000fc80004000000ULL, 0x0000001c0d00720bULL, 0x000fe40003f1e000ULL,
0x0000000f0e00720bULL, 0x004fe40003f3e000ULL, 0x0000000d1c0c7208ULL, 0x000fe40004000000ULL,
0x0000000e0f187208ULL, 0x000fe40004800000ULL, 0x000000170c00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b180e7820ULL, 0x000fe20000410000ULL, 0x0000000c170d7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080eULL, 0x000000160d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080eULL,
0x0000002800117308ULL, 0x0005e20000000800ULL, 0x0000000d160c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b20147823ULL, 0x100fe2000001080eULL, 0x0000001d0c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001080eULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000000c1d0c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b35287823ULL, 0x104fe2000001080eULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b21157823ULL, 0x000fc4000001080eULL, 0x0c401f000c0d7f89ULL, 0x000ea400000e0000ULL,
0x0000002d000f7308ULL, 0x0007700000000800ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b362d7823ULL, 0x008fce000001080eULL, 0x0000003100107308ULL, 0x0007e20000000800ULL,
0x0000000d0c00720bULL, 0x004fce0003f1e000ULL, 0x00000024003d7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b37317823ULL, 0x008fe2000001080eULL, 0x0000000c0d0c7208ULL, 0x000fca0004000000ULL,
0x0c201f000c197f89ULL, 0x000ee200000e0000ULL, 0x00000029003e7308ULL, 0x000be20000000800ULL,
0x00000004ff247e24ULL, 0x004fca000f8e00ffULL, 0x3f8000002424783eULL, 0x000fe400000010ffULL,
0x0000002500487308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b30297823ULL, 0x122fe2000001080eULL,
0x3fb8aa3b34307823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b3c347823ULL, 0x000fe2000001080eULL,
0x000000120f0e723eULL, 0x000fc800000010ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x000000ffff257224ULL, 0x004fe200078e0024ULL, 0x000000190c00720bULL, 0x008fcc0003f1e000ULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x0000003d4812723eULL, 0x000fe400000010ffULL,
0x0000000c19197208ULL, 0x000fe40004000000ULL, 0x00000013100c723eULL, 0x000fe400000010ffULL,
0x000000113e10723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b19357820ULL, 0x000fe20000410000ULL,
0x0000002900297308ULL, 0x000fe60000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL, 0x00000032000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b23137823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe20000010835ULL, 0x000000141514723eULL, 0x002fc400000010ffULL,
0x0000003300207308ULL, 0x000e700000000800ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000000d200d723eULL, 0x002fce00000010ffULL, 0x0000002f002f7308ULL, 0x000e700000000800ULL,
0x0000002200327308ULL, 0x0005e20000000800ULL, 0x0000002e2f0f723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000ffff2e7224ULL, 0x100fe400078e0024ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0024ULL, 0x000000240c20723cULL, 0x004fe800000418ffULL,
0x0000002b002b7308ULL, 0x000e660000000800ULL, 0x3fb8aa3b1f257823ULL, 0x000fc40000010835ULL,
0x0c401f001a1f7f89ULL, 0x000ea600000e0000ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x0000002a2b11723eULL, 0x002fce00000010ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1c2a7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b162b7823ULL, 0x000fe20000010835ULL,
0x0c401f001b1c7f89ULL, 0x000eea00000e0000ULL, 0x0000001300337308ULL, 0x0003620000000800ULL,
0x0000001f1a00720bULL, 0x004fce0003f1e000ULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x000000262713723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b17267823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1d357823ULL, 0x000fe20000010835ULL, 0x0000001a1f1a7208ULL, 0x000fe40004000000ULL,
0x000000323315723eULL, 0x020fe400000010ffULL, 0x0000002e1020723cULL, 0x000fe20000041820ULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x0000001c1b00720bULL, 0x008fc80003f3e000ULL,
0x0000001b1c1b7208ULL, 0x000fc60004800000ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000001e2517723eULL, 0x002fe200000010ffULL, 0x000000ffff257224ULL, 0x000fcc00078e0024ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x000000293016723eULL, 0x004fce00000010ffULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x000000241420723cULL, 0x000fee0000041820ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x00000003ff257819ULL, 0x000fe40000011606ULL,
0x000000282d1c723eULL, 0x002fca00000010ffULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0x0c201f001a2d7f89ULL, 0x000ea200000e0000ULL, 0x0000000325257812ULL, 0x000fcc00078ec0ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x00000031341e723eULL, 0x002fce00000010ffULL,
0x0000002600277308ULL, 0x0002e20000000800ULL, 0x000000ffff347224ULL, 0x000fce00078e0024ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0xfffffff8ff267812ULL, 0x002fe400078ee24bULL,
0x0000002d1a00720bULL, 0x004fc60003f1e000ULL, 0x0000000826287836ULL, 0x000fe20000000000ULL,
0x0000002a271d723eULL, 0x008fe200000010ffULL, 0x00000035002e7308ULL, 0x0002a20000000800ULL,
0x0000000826307824ULL, 0x000fe200078e00ffULL, 0x0000000840277c11ULL, 0x000fe2000f8e58ffULL,
0x0000000125297824ULL, 0x000fe200078e0228ULL, 0x0000001a2d1a7208ULL, 0x000fe20004000000ULL,
0x0000000828327824ULL, 0x000fe200078e00ffULL, 0x0000000306ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000828317824ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x002fe200078e0024ULL,
0xfffffff832287812ULL, 0x000fe200078ee229ULL, 0x00011000272f7836ULL, 0x000fc40000000000ULL,
0x000000ffff277224ULL, 0x000fe200078e0012ULL, 0x0000002b2e1f723eULL, 0x004fe200000010ffULL,
0x00000008262b7824ULL, 0x000fe200078e00ffULL, 0x0c201f001b2e7f89ULL, 0x000e6200000e0000ULL,
0x0000000125267824ULL, 0x000fe400078e0226ULL, 0x000000ffff297224ULL, 0x000fe400078e0016ULL,
0x000000341c20723cULL, 0x000fe20000041820ULL, 0x0000000426257836ULL, 0x000fe20000000000ULL,
0xfffffff82b247812ULL, 0x000fe200078ee226ULL, 0x0000000c262a7836ULL, 0x000fc60000000000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e001eULL, 0xfffffff830267812ULL, 0x000fe200078ee225ULL,
0x000000ffff257224ULL, 0x000fe200078e000eULL, 0xfffffff831327812ULL, 0x000fe200078ee22aULL,
0x0000001028307824ULL, 0x000fe400078e022fULL, 0x000000ffff287224ULL, 0x000fe400078e0014ULL,
0x000000ffff2a7224ULL, 0x000fe400078e001cULL, 0x000000ffff0e7224ULL, 0x000fc400078e0011ULL,
0x0000001032327824ULL, 0x100fe200078e022fULL, 0x0000002e1b00720bULL, 0x002fe20003f3e000ULL,
0x0000001024217824ULL, 0x100fe400078e022fULL, 0x0000001026237824ULL, 0x000fe200078e022fULL,
0x0000001b2e1b7208ULL, 0x000fe20004800000ULL, 0x000000ffff247224ULL, 0x000fe400078e000cULL,
0x000000ffff267224ULL, 0x000fe400078e0010ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000dULL,
0x000000ffff0d7224ULL, 0x000fe200078e000fULL, 0x0000002421007844ULL, 0x0003e20000000200ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0013ULL, 0x000000ffff107224ULL, 0x000fe200078e0015ULL,
0x0000002823007844ULL, 0x0005e20000000200ULL, 0x000000ffff117224ULL, 0x000fe400078e0017ULL,
0x000000ffff127224ULL, 0x000fe200078e001dULL, 0x0000000c30007844ULL, 0x0005e20000000200ULL,
0x000000ffff137224ULL, 0x000fc400078e001fULL, 0x00000001ff157424ULL, 0x000fc600078e00ffULL,
0x0000001032007844ULL, 0x0005e20000000200ULL, 0x000000ffff217224ULL, 0x002fc600078e0022ULL,
0x017000182c008388ULL, 0x0005e20000000c00ULL, 0x000000ffff227224ULL, 0x000fc600078e0046ULL,
0x017200202c008388ULL, 0x0005e20000000a00ULL, 0x000000384700720cULL, 0x000fe20003f06070ULL,
0x0176081542ff79a7ULL, 0x0005e2000850003fULL, 0x0176101542ff79a7ULL, 0x0005e2000850003fULL,
0x0176181542ff79a7ULL, 0x0005e2000850003fULL, 0x0176201542ff79a7ULL, 0x0005f2000850003fULL,
0xffffffa400888947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000050007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005000008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff50ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000050027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005000007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffea802187950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x000000000000057fULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000700ULL, 0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000958ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a38ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a8cULL, 0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001100ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001100ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000001148ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001180ULL, 0x0000000000015880ULL, 0x0000001700000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000016a00ULL, 0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000016a50ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000016a50ULL, 0x0000000000000278ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000017048ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000017048ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000001148ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015880ULL, 0x0000000000015880ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016a00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000016a50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000278ULL, 0x0000000000000278ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 94616;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
