/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015e90ULL, 0x0000000000015a10ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000014050ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000141c0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000014200ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000014240ULL,
0x0000000000000140ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000014380ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001405000000000ULL, 0x0000040400000000ULL, 0x810c000001340400ULL,
0x004ed00400288080ULL, 0x0000000000000000ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9808288080900828ULL, 0x2880809908288080ULL, 0x809d082880809a08ULL, 0x082880809e082880ULL,
0x8080a0082880809fULL, 0xa408288080a20828ULL, 0x288080a508288080ULL, 0x80a708288080a608ULL,
0x08288080a8082880ULL, 0x8080aa08288080a9ULL, 0xb208288080af0828ULL, 0x288080b508288080ULL,
0x80b908288080b708ULL, 0x08288080c0082880ULL, 0x8080cf08288080c9ULL, 0xd408288080d20828ULL,
0x288080e308288080ULL, 0x8280162880808608ULL, 0x0000000003102880ULL, 0x8080869200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001405000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x000000ccffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8a08288080840828ULL, 0x2880808b08288080ULL, 0x8090082880808e08ULL, 0x0828808098082880ULL,
0x80809a0828808099ULL, 0x9e082880809d0828ULL, 0x2880809f08288080ULL, 0x80a208288080a008ULL,
0x08288080a4082880ULL, 0x8080a608288080a5ULL, 0xa808288080a70828ULL, 0x288080a908288080ULL,
0x80b208288080af08ULL, 0x08288080b5082880ULL, 0x8080c908288080c0ULL, 0xd208288080cf0828ULL,
0x288080d408288080ULL, 0x808808288080e308ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080889200ULL, 0x0000001cffffffffULL, 0x0000017000000000ULL, 0x000141c000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000d4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8808288080840828ULL, 0x2880808a08288080ULL, 0x808e082880808b08ULL, 0x0828808090082880ULL,
0x8080990828808098ULL, 0x9d082880809a0828ULL, 0x2880809e08288080ULL, 0x80a0082880809f08ULL,
0x08288080a2082880ULL, 0x8080a608288080a5ULL, 0xa808288080a70828ULL, 0x288080a908288080ULL,
0x80af08288080aa08ULL, 0x08288080b2082880ULL, 0x8080c008288080b5ULL, 0xcf08288080c90828ULL,
0x288080d208288080ULL, 0x80e308288080d408ULL, 0x16288080a4082880ULL, 0x0000031028808280ULL,
0xa492000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000027000000000ULL,
0x0001420000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x000000ccffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880808a08288080ULL, 0x808e082880808b08ULL,
0x0828808090082880ULL, 0x8080990828808098ULL, 0x9d082880809a0828ULL, 0x2880809e08288080ULL,
0x80a0082880809f08ULL, 0x08288080a2082880ULL, 0x8080a508288080a4ULL, 0xa708288080a60828ULL,
0x288080a808288080ULL, 0x80b208288080af08ULL, 0x08288080b5082880ULL, 0x8080c908288080c0ULL,
0xd208288080cf0828ULL, 0x288080d408288080ULL, 0x80a908288080e308ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080a99200ULL, 0x0000002cffffffffULL, 0x0000037800000000ULL,
0x0001424000000000ULL, 0x0000014000000000ULL, 0x0000180400000000ULL, 0x80a4288080a90900ULL,
0x0000000000002880ULL, 0x0000001200082f04ULL, 0x00081204000000a7ULL, 0x000000000000000dULL,
0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL,
0x0000000e00080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL, 0x0021f00000480007ULL,
0x00000000000c1704ULL, 0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL,
0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x001c310400ff1b03ULL, 0x000127f000000020ULL,
0x00012a1000012a00ULL, 0x00012b9000012b80ULL, 0x0160290400012ba0ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001d0500001dULL,
0x0500001d0500001dULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001602804ULL,
0x000016d000000120ULL, 0x0000182000001760ULL, 0x00001c2000001850ULL, 0x00001cb000001c50ULL,
0x00003f5000001d10ULL, 0x000040b000003fe0ULL, 0x000044f0000041d0ULL, 0x0000457000004510ULL,
0x000063e0000045d0ULL, 0x0000654000006470ULL, 0x0000697000006660ULL, 0x000069f000006990ULL,
0x000088a000006a50ULL, 0x00008a0000008930ULL, 0x00008e4000008b20ULL, 0x00008ec000008e60ULL,
0x0000a90000008f20ULL, 0x0000cf000000a910ULL, 0x0000d7b00000cfe0ULL, 0x000124200000d7e0ULL,
0x0001246000012450ULL, 0x0001249000012470ULL, 0x000124d0000124b0ULL, 0x00012b70000124e0ULL,
0x00012be000012bd0ULL, 0x0001330000012bf0ULL, 0x000133c000013350ULL, 0x000134a000013430ULL,
0x0001356000013510ULL, 0x00013610000135b0ULL, 0x000136e000013680ULL, 0x000137a000013750ULL,
0x00013850000137f0ULL, 0x00013920000138c0ULL, 0x000139e000013990ULL, 0x00013a9000013a30ULL,
0x00013b6000013b00ULL, 0x00013c3000013bd0ULL, 0x00013ce000013c90ULL, 0x00013d8000013d30ULL,
0x00013e2000013dd0ULL, 0x00013ee000013e70ULL, 0x00013fc000013f60ULL, 0x04c0390400014020ULL,
0x000000ff00000220ULL, 0x003f01000000f600ULL, 0x0000000b00000290ULL, 0x003f01200000f608ULL,
0x0000000b000002d0ULL, 0x003f01200000f688ULL, 0x0000000b00000360ULL, 0x003f01200000f6a8ULL,
0x0000000b000003a0ULL, 0x003f01200000f6c8ULL, 0x000000ff00000460ULL, 0x003f01070000f600ULL,
0x0000003500000740ULL, 0x003f01020000f68cULL, 0x0000003500000a00ULL, 0x003f01010000f688ULL,
0x000000ff00000b20ULL, 0x0004010700000000ULL, 0x000000ff00000bd0ULL, 0x0004010100000000ULL,
0x0000003000000c30ULL, 0x003f010100000020ULL, 0x0000006000000d60ULL, 0x003f010500000004ULL,
0x0000003000000dc0ULL, 0x003f010500000024ULL, 0x0000003000000e40ULL, 0x003f010500000024ULL,
0x00000044000013a0ULL, 0x003f010700000000ULL, 0x0000004400001470ULL, 0x003f010100000000ULL,
0x0000004000001480ULL, 0x003f010500000004ULL, 0x0000003b000014f0ULL, 0x003f01010000f608ULL,
0x0000003b00001510ULL, 0x003f01050000f60cULL, 0x00000026000015d0ULL, 0x003f01050000f60cULL,
0x0000004000001b10ULL, 0x003f010500000004ULL, 0x0000004000001b90ULL, 0x003f010500000004ULL,
0x00000030000035e0ULL, 0x003f010100000020ULL, 0x0000004d00003660ULL, 0x003f01010000f688ULL,
0x00000060000036b0ULL, 0x003f010500000004ULL, 0x0000003000003700ULL, 0x003f010500000024ULL,
0x0000003000003780ULL, 0x003f010500000024ULL, 0x0000005800003ca0ULL, 0x003f010700000000ULL,
0x0000005800003d20ULL, 0x003f010100000000ULL, 0x0000005d00003d30ULL, 0x003f010500000004ULL,
0x0000003b00003da0ULL, 0x003f01010000f628ULL, 0x0000003b00003dc0ULL, 0x003f01050000f62cULL,
0x0000002400003ea0ULL, 0x003f01050000f62cULL, 0x00000024000043c0ULL, 0x003f01050000f6acULL,
0x0000002400004440ULL, 0x003f01050000f6acULL, 0x0000003000005cf0ULL, 0x003f010100000020ULL,
0x0000004d00005d60ULL, 0x003f01010000f690ULL, 0x0000006000005da0ULL, 0x003f010500000004ULL,
0x0000003000005df0ULL, 0x003f010500000024ULL, 0x0000003000005e70ULL, 0x003f010500000024ULL,
0x0000005d00006180ULL, 0x003f010700000000ULL, 0x0000005d00006200ULL, 0x003f010100000000ULL,
0x0000005800006210ULL, 0x003f010500000004ULL, 0x0000003b00006280ULL, 0x003f01010000f648ULL,
0x0000003b000062a0ULL, 0x003f01050000f64cULL, 0x0000003b00006330ULL, 0x003f01050000f64cULL,
0x0000002500006840ULL, 0x003f01050000f6acULL, 0x00000025000068c0ULL, 0x003f01050000f6acULL,
0x0000003000008160ULL, 0x003f010100000020ULL, 0x0000004d000081d0ULL, 0x003f01010000f698ULL,
0x0000006000008220ULL, 0x003f010500000004ULL, 0x0000003000008270ULL, 0x003f010500000024ULL,
0x00000030000082f0ULL, 0x003f010500000024ULL, 0x0000005800008630ULL, 0x003f010700000000ULL,
0x0000004f000086b0ULL, 0x003f010100000000ULL, 0x0000005d000086c0ULL, 0x003f010500000004ULL,
0x0000003b00008730ULL, 0x003f01010000f668ULL, 0x0000003b00008750ULL, 0x003f01050000f66cULL,
0x0000003b000087f0ULL, 0x003f01050000f66cULL, 0x0000002400008d10ULL, 0x003f01050000f6acULL,
0x0000002400008d90ULL, 0x003f01050000f6acULL, 0x000000300000a5a0ULL, 0x003f010100000020ULL,
0x0000004d0000a600ULL, 0x003f01010000f6a0ULL, 0x000000ff0000e4f0ULL, 0x003f01010000f600ULL,
0x000000ff0000efe0ULL, 0x003f01050000f604ULL, 0x000000ff0000f080ULL, 0x003f01050000f604ULL,
0x000000ff0000f290ULL, 0x003f01010000f600ULL, 0x000000ff0000f2a0ULL, 0x003f01050000f604ULL,
0x000000ff0000f330ULL, 0x003f01050000f604ULL, 0x00000032000118d0ULL, 0x003f010100000000ULL,
0x0000003200011910ULL, 0x003f010500000004ULL, 0x0000003200011d20ULL, 0x003f010500000004ULL,
0x0000003300013160ULL, 0x003f010100000000ULL, 0x00000033000131c0ULL, 0x003f010100000008ULL,
0x0000003300013220ULL, 0x003f010100000010ULL, 0x0000003300013290ULL, 0x003f010100000018ULL,
0x00141c0400053803ULL, 0x0000e4400000e1f0ULL, 0x0000f4300000f390ULL, 0x00000401000132d0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL,
0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000464ULL, 0x0000001200000002ULL, 0x0000000000000364ULL,
0x0000001200000002ULL, 0x000000000000025cULL, 0x0000001200000002ULL, 0x000000000000015cULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000441ULL,
0x0000001200000002ULL, 0x000000000000033eULL, 0x0000001200000002ULL, 0x0000000000000239ULL,
0x0000001200000002ULL, 0x0000000000000134ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000a7919ULL, 0x000ea20000002300ULL,
0x0000001000047300ULL, 0x000ee200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x00000100ff137424ULL, 0x000fc600078e00ffULL,
0x0000000000397919ULL, 0x000f220000000000ULL, 0x0000001000107309ULL, 0x000f660000000000ULL,
0x00000000002f7919ULL, 0x000ee80000002600ULL, 0x0000000000057919ULL, 0x000f620000000000ULL,
0x00000005ff2d7819ULL, 0x002fc6000001160bULL, 0x0000000000377919ULL, 0x000e680000002700ULL,
0x00001fff2d2d7589ULL, 0x000fe200000e0000ULL, 0x000000010a007824ULL, 0x004fc600078e0203ULL,
0x00001fff0a0a7589ULL, 0x000ea200000e0000ULL, 0x00000080000b7824ULL, 0x000fe200078e020bULL,
0x00000004ff0d7819ULL, 0x010fe20000011639ULL, 0x00000010390c7824ULL, 0x000fe400078e00ffULL,
0x000000082f007824ULL, 0x008fe200078e00ffULL, 0x000000ff0b00720cULL, 0x040fe40003f45270ULL,
0x0000000f0b00780cULL, 0x040fe40003f64070ULL, 0x000000030b00780cULL, 0x000fc40003f24070ULL,
0x0000007f0b00780cULL, 0x000fe40003f84070ULL, 0x000000050400720cULL, 0x020fe20003f02070ULL,
0x0000003707007224ULL, 0x002fe200078e0200ULL, 0x000000f00c117812ULL, 0x000fc600078ec0ffULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040a067824ULL, 0x004fe400078e022dULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010b00780cULL, 0x000fe20003f44070ULL,
0x0000000206087824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0x00000001080f7824ULL, 0x040fe200078e020dULL, 0x0000000808097817ULL, 0x000fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608040b00b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x0000000100027824ULL, 0x002fe400078e020fULL,
0x0000000109007824ULL, 0x000fe200078e0a08ULL, 0x00f688060b009388ULL, 0x0003e20000008a00ULL,
0xff317217ff0ec424ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff08a424ULL, 0x000fe200078e00ffULL,
0x000000000d00720cULL, 0x000fe20003f66070ULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x00f4000e0b00c388ULL, 0x0007e20000004800ULL, 0x3fffff80ff049424ULL, 0x004fe400078e00ffULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0013ULL,
0x00f6a8040b009388ULL, 0x0005e20000008a00ULL, 0x000000ffff067224ULL, 0x002fe200078e0a10ULL,
0x000000070f0e7812ULL, 0x008fe200078ec0ffULL, 0x00000004ff007424ULL, 0x000fe200078e00ffULL,
0x00f6c8080b00a388ULL, 0x0003e80000008a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000f0e0e7812ULL, 0x000fe400078e7839ULL, 0x0000001102027210ULL, 0x000fe20007f9e0ffULL,
0x0000600037047625ULL, 0x004fc800078e0000ULL, 0x000000100f0e7824ULL, 0x000fe400078e020eULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000100e077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006042c7981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x00000004ff037e24ULL, 0x00afe2000f8e00ffULL,
0x000000ff2c027810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff027819ULL, 0x000fce0000011602ULL,
0x0000df0000008947ULL, 0x000fea0003800000ULL, 0x000000102d367824ULL, 0x000fe200078e00ffULL,
0x00000003ff117819ULL, 0x000fe20000011639ULL, 0x0000000237377824ULL, 0x000fe200078e00ffULL,
0x000058002f007a10ULL, 0x000fe20007ffe0ffULL, 0x000000082d357824ULL, 0x000fe200078e00ffULL,
0x0000001036367812ULL, 0x000fe200078ec0ffULL, 0x00000003ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000103057810ULL, 0x000fe20007ffe0ffULL, 0x0000580037377a24ULL, 0x000fe200078e0200ULL,
0x00000001ff387819ULL, 0x000fe2000001162dULL, 0x0000000136047824ULL, 0x000fe200078e0211ULL,
0x000000020500720cULL, 0x000fc40003f06070ULL, 0x0000000411157810ULL, 0x000fe20007ffe0ffULL,
0x0000000803057824ULL, 0x000fe200078e0238ULL, 0x0000003904007212ULL, 0x040fe200078e3cffULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0xfffffff807077812ULL, 0x000fe200078ee200ULL, 0x0000000136087824ULL, 0x000fe200078e0215ULL,
0x0000000c111d7810ULL, 0x000fe20007ffe0ffULL, 0x0000002005007824ULL, 0x000fe200078e00ffULL,
0x0000000811197810ULL, 0x000fe20007ffe0ffULL, 0x0000000808097824ULL, 0x040fe200078e00ffULL,
0x0000003908067212ULL, 0x080fe200078e3cffULL, 0x00000001360b7824ULL, 0x000fe200078e021dULL,
0x000000002c057217ULL, 0x000fe20007800000ULL, 0x00000001360a7824ULL, 0x000fe200078e0219ULL,
0xfffffff809097812ULL, 0x000fe200078ee206ULL, 0x0000200038347824ULL, 0x000fe200078e00ffULL,
0x000000390b0d7212ULL, 0x080fe200078e3cffULL, 0x0000000105067824ULL, 0x100fe200078e0a00ULL,
0x00f68c0e35ff738cULL, 0x0003e20000000000ULL, 0x0000620037007a24ULL, 0x000fe200078e0200ULL,
0x000000390a057212ULL, 0x040fe200078e3cffULL, 0x000000080b127824ULL, 0x000fe200078e00ffULL,
0x00000000380473c2ULL, 0x0004e200000e0000ULL, 0x000000080a107824ULL, 0x000fe200078e00ffULL,
0x000000700c0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000100047824ULL, 0x000fe200078e0204ULL,
0xfffffff8120d7812ULL, 0x000fe200078ee20dULL, 0x0000000100087824ULL, 0x000fc400078e0208ULL,
0x00000001000a7824ULL, 0x040fe400078e020aULL, 0x00000001000e7824ULL, 0x002fe200078e020bULL,
0x0000b00034007810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0xfffffff8100b7812ULL, 0x000fc600078ee205ULL, 0x00005e0004047625ULL, 0x000fc800078e0021ULL,
0x000000100d1f7824ULL, 0x100fe200078e0200ULL, 0x00000020060d7807ULL, 0x000fe20000000000ULL,
0x0000001007137824ULL, 0x100fe200078e0200ULL, 0x0000000f04047210ULL, 0x000fe20007f1e0ffULL,
0x0000001009177824ULL, 0x000fe200078e0200ULL, 0x000000360d0d7217ULL, 0x000fe20007800000ULL,
0x00005e0008067625ULL, 0x000fc800078e0021ULL, 0x000000100b1b7824ULL, 0x000fe400078e0200ULL,
0x00005e000a087625ULL, 0x000fc800078e0021ULL, 0x00005e000e0a7625ULL, 0x000fe200078e0021ULL,
0x0000000f08087210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000f060c7210ULL, 0x080fe20007f1e0ffULL, 0x000000010d007824ULL, 0x000fe200078e0a36ULL,
0x0000000f0a0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe400008e0609ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0607ULL, 0x000000001100720cULL, 0x080fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x000fe200010e060bULL, 0x000000001500720cULL, 0x080fe40003f26070ULL,
0x000000001900720cULL, 0x000fc40003f46070ULL, 0x000000001d00720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f6a804047891ULL, 0x000fe2000f8e203fULL,
0x00f6880035ff7f8cULL, 0x0003e2000c80043fULL, 0x000000012d337812ULL, 0x000fe200078ec0ffULL,
0xff317217ff327424ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004137faeULL, 0x0005e2000c101c46ULL,
0x000000020300720cULL, 0x000fe20003f06070ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x000000000c177faeULL, 0x0007e2000c901c46ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000f6a838307811ULL, 0x000fc400078e18ffULL,
0x00000000081b7faeULL, 0x0009e8000d101c46ULL, 0x000000000e1f7faeULL, 0x000be2000d901c46ULL,
0x0000000000047805ULL, 0x004fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000087805ULL, 0x010fe2000001ff00ULL,
0x00000000000e7805ULL, 0x020fe4000001ff00ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x00000000ff247f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200030267f8cULL, 0x0004e2000c80043fULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000002030607810ULL, 0x000fe20007ffe0ffULL, 0x0000998000000947ULL, 0x000fea0003800000ULL,
0x000000ffff617224ULL, 0x006fe400078e0025ULL, 0x000000ffff257224ULL, 0x008fc400078e0027ULL,
0xff317217ff327424ULL, 0x000fe400078e00ffULL, 0x000000ffff517224ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x0000010003277824ULL, 0x000fca00078e00ffULL,
0x0000002c2700720cULL, 0x000fda0003f06070ULL, 0x000098c000000947ULL, 0x006fea0003800000ULL,
0x0000040060007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0051ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240030007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x0000240030247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000100051007824ULL, 0x000fe200078e00ffULL,
0x00000001ff387819ULL, 0x000fe2000001162dULL, 0x0000010003437824ULL, 0x000fe200078e00ffULL,
0x00000003ff3d7819ULL, 0x000fe20000011639ULL, 0x0000001039417824ULL, 0x000fe200078e00ffULL,
0x0000100000277812ULL, 0x000fe200078e0cffULL, 0x0000002038007824ULL, 0x000fe200078e0243ULL,
0x0000000103257810ULL, 0x000fe20007ffe0ffULL, 0x0000000136247824ULL, 0x000fe200078e023dULL,
0x000000083d4d7810ULL, 0x000fe20007ffe0ffULL, 0x0000200038277824ULL, 0x000fe200078e0227ULL,
0x0000004000007810ULL, 0x000fe20007ffe0ffULL, 0x0000000824497824ULL, 0x040fe200078e00ffULL,
0x0000003924267212ULL, 0x080fe200078e3cffULL, 0x00000001363a7824ULL, 0x000fe200078e024dULL,
0x000000022500720cULL, 0x000fe20003f06070ULL, 0x00000080ff3f7424ULL, 0x000fe200078e00ffULL,
0x000000043d477810ULL, 0x000fe20007ffe0ffULL, 0x000000083a3c7824ULL, 0x000fe200078e00ffULL,
0x000000002c257217ULL, 0x000fe20007800000ULL, 0x00000008513e7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee226ULL, 0x0000000136267824ULL, 0x000fe200078e0247ULL,
0x0000000c3d4f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125257824ULL, 0x100fe200078e0a00ULL,
0x000000393a297212ULL, 0x080fe200078e3cffULL, 0x0000620037007a24ULL, 0x000fe200078e0200ULL,
0x0000003926287212ULL, 0x0c0fe200078e3cffULL, 0x00000008262b7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c4b7812ULL, 0x000fe200078ee229ULL, 0x00000001362a7824ULL, 0x000fe200078e024fULL,
0x0000002025297807ULL, 0x000fe20000000000ULL, 0x0000000124247824ULL, 0x000fe200078e0200ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee228ULL, 0x0000000126267824ULL, 0x000fe200078e0200ULL,
0x000000392a287212ULL, 0x040fe200078e3cffULL, 0x000000082a537824ULL, 0x000fe200078e00ffULL,
0x0000b000274c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x000fe200078e003fULL,
0x0000007041457812ULL, 0x000fe200078ec0ffULL, 0x0000032000007945ULL, 0x000fe20003800000ULL,
0x0000002936297217ULL, 0x000fe20007800000ULL, 0x00005e0026267625ULL, 0x000fe200078e003fULL,
0xfffffff853537812ULL, 0x000fc400078ee228ULL, 0x0000004524287210ULL, 0x080fe20007f1e0ffULL,
0x000000013a3a7824ULL, 0x100fe200078e0200ULL, 0x00000008353c7812ULL, 0x000fe200078ec0ffULL,
0x000000012a3b7824ULL, 0x000fe200078e0200ULL, 0x00000045262a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000129007824ULL, 0x000fe400078e0a36ULL, 0x000000102b4a7824ULL, 0x000fe400078e024cULL,
0x000000ffff297224ULL, 0x000fe200000e0625ULL, 0x000000003d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff2b7224ULL, 0x000fe200010e0627ULL, 0x000000004700720cULL, 0x080fe20003f46070ULL,
0x00005e003a247625ULL, 0x000fe200078e003fULL, 0x000000004d00720cULL, 0x000fc40003f66070ULL,
0x000000004f00720cULL, 0x000fe20003f86070ULL, 0x00005e003b267625ULL, 0x000fe200078e003fULL,
0x0000004524247210ULL, 0x080fe40007fbe0ffULL, 0x000000083e007812ULL, 0x000fe200078e0cffULL,
0x00000010383a7824ULL, 0x000fe200078e00ffULL, 0x0000004526267210ULL, 0x000fe20007fde0ffULL,
0x0000001049497824ULL, 0x100fe400078e024cULL, 0x000000104b4b7824ULL, 0x100fe200078e024cULL,
0x0000f6a83a3d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028497faeULL, 0x0003e2000c101c46ULL,
0x00000010534c7824ULL, 0x000fe200078e024cULL, 0x000000103a3b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000002a4a7faeULL, 0x0003e2000d101c46ULL,
0x000000013d447824ULL, 0x000fe200078e0200ULL, 0xffffffe035007812ULL, 0x000fc400078ec0ffULL,
0x00000000244b7faeULL, 0x0003e2000d901c46ULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x000000003c3b7210ULL, 0x000fe20007ffe03bULL, 0x00000000264c7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fec0000000000ULL, 0x00000000440403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000013d407824ULL, 0x000fe200078e023eULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000044447f8cULL, 0x000ea8000c80043fULL,
0x0000040040267984ULL, 0x0022e20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f608003b247f8cULL, 0x000fe2000c80043fULL,
0x8000000026ff7812ULL, 0x008fc60007844861ULL, 0x00f60c003b277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x008fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000b000000947ULL, 0x000fea0003800000ULL,
0x0000001035277812ULL, 0x000fca00078ec0ffULL, 0x0000000100267824ULL, 0x000fe400078e0227ULL,
0x3e000000ff007424ULL, 0x000fe400078e00ffULL, 0x0000000833267824ULL, 0x000fe400078e0226ULL,
0x0000000000277305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000270000735dULL, 0x010fe40003800000ULL, 0x00f60c0026277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x008fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000202d3d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff3e7819ULL, 0x000fe20000011639ULL,
0xffffffffff3f7424ULL, 0x000fe200078e00ffULL, 0x00000070413c7812ULL, 0x000fe400078ec0ffULL,
0xffffff803d3d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c3e3e7812ULL, 0x000fc800078ec0ffULL,
0x0000003d3e007210ULL, 0x000fca0007ffe03cULL, 0x00f0000000277984ULL, 0x000ee80000000800ULL,
0x00f2000000267984ULL, 0x0008620000000800ULL, 0x000000322700720bULL, 0x008fe20003f1d000ULL,
0x00011c127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x010fc800000e0100ULL,
0x0000ffff002a7812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3a7424ULL, 0x000fd600078e00ffULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x000fe4000001162dULL, 0x000000322700720bULL, 0x000fe40003f14000ULL,
0x0000002d0000720cULL, 0x000fe20003f65270ULL, 0x00011bd27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000007806ULL, 0x000fe400000e0100ULL, 0x000000802d25b824ULL, 0x000fe200078e023cULL,
0x0000002732427209ULL, 0x000fe40007810000ULL, 0x0000ffff00297812ULL, 0x000fe200078e3cffULL,
0x000000013e25b824ULL, 0x000fe200078e0225ULL, 0x00000002ff007819ULL, 0x000fe20000011639ULL,
0x8000004232247221ULL, 0x000fe20000010000ULL, 0x000000292aff7212ULL, 0x000fc4000780c0ffULL,
0x00f400422500b388ULL, 0x0007e20000000800ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024002b7308ULL, 0x0007220000000800ULL, 0x00011b627f007947ULL, 0x000fea000b800000ULL,
0x00001f002b287589ULL, 0x0108e400000e0000ULL, 0x0000000800007810ULL, 0x010fe20007ffe0ffULL,
0x00011ba27f007947ULL, 0x000fea000b800000ULL, 0x00001f002b007589ULL, 0x0008e400000e0000ULL,
0x8000004227270221ULL, 0x100fe20000010000ULL, 0x0000002b31317220ULL, 0x000fe20000410000ULL,
0x0000000007077220ULL, 0x088fe20000410000ULL, 0x0000000006067220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x00000027002e0308ULL, 0x000ee20000000800ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x000fe20000410000ULL,
0x00000001ff3a7807ULL, 0x000fe20000000000ULL, 0x0000002805057220ULL, 0x080fe20000410000ULL,
0x0000002804047220ULL, 0x080fe20000410000ULL, 0x0000002809097220ULL, 0x080fe20000410000ULL,
0x0000002808087220ULL, 0x080fe20000410000ULL, 0x000000280d0d7220ULL, 0x080fe20000410000ULL,
0x000000280c0c7220ULL, 0x080fe20000410000ULL, 0x0000002811117220ULL, 0x080fe20000410000ULL,
0x0000002810107220ULL, 0x080fe20000410000ULL, 0x0000002815157220ULL, 0x080fe20000410000ULL,
0x0000002814147220ULL, 0x080fe20000410000ULL, 0x0000002819197220ULL, 0x080fe20000410000ULL,
0x0000002818187220ULL, 0x080fe20000410000ULL, 0x000000281d1d7220ULL, 0x080fe20000410000ULL,
0x000000281c1c7220ULL, 0x080fe20000410000ULL, 0x0000002821217220ULL, 0x080fe20000410000ULL,
0x0000002820207220ULL, 0x000fe20000410000ULL, 0x000000ffff327224ULL, 0x000fe200078e0042ULL,
0x0000002e26260220ULL, 0x00afc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003126317221ULL, 0x002fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0000040040007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000040040247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002eff00723eULL, 0x000fe400000010ffULL, 0x00000002ff267819ULL, 0x000fc40000011639ULL,
0x00005410002b7816ULL, 0x010fe20000000000ULL, 0x000118427f007947ULL, 0x000fea000b800000ULL,
0x00001f262b4f7589ULL, 0x0002e400000e0000ULL, 0x0000000826407810ULL, 0x000fe20007ffe0ffULL,
0x000118827f007947ULL, 0x000fea000b800000ULL, 0x00001f402b007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001026527810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff537424ULL, 0x000fe200078e00ffULL, 0x00001cc000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0001254000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x0000001826527810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff537424ULL, 0x000fe200078e00ffULL, 0x00001d2000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x000124e000007944ULL, 0x01cfea0003c00000ULL,
0x000000022d4d7824ULL, 0x000fe200078e00ffULL, 0x0000000739247812ULL, 0x000fe200078ec0ffULL,
0x000002002d277824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000044d267812ULL, 0x002fc400078ec0ffULL, 0x0000000824257812ULL, 0x000fe400078ef839ULL,
0x0000002639267211ULL, 0x000fe400078fe0ffULL, 0xfffff800274e7812ULL, 0x000fe400078ec0ffULL,
0x0000000726247812ULL, 0x000fca00078e7825ULL, 0x0000000825417824ULL, 0x000fe200078e0224ULL,
0x0000000839247812ULL, 0x000fc600078ec0ffULL, 0x0000001041417824ULL, 0x000fe400078e024eULL,
0x000000042d277824ULL, 0x040fe200078e00ffULL, 0x0000000226267810ULL, 0x000fe20007ffe0ffULL,
0x000010002d297824ULL, 0x000fe200078e00ffULL, 0x000099103a3a7816ULL, 0x000fe200000000ffULL,
0x0000100051427824ULL, 0x000fe200078e0234ULL, 0x0000000427287812ULL, 0x000fe400078ec0ffULL,
0x0000000724277812ULL, 0x000fe400078ec839ULL, 0x0000002839287211ULL, 0x000fe400078fe0ffULL,
0xffffe000292a7812ULL, 0x004fc400078ec0ffULL, 0x0000002827537212ULL, 0x000fe400078e3cffULL,
0x0000000228287810ULL, 0x000fe20007ffe0ffULL, 0x00001000512a7824ULL, 0x000fe200078e022aULL,
0x0000000724247812ULL, 0x000fe400078ef839ULL, 0x0000002827277212ULL, 0x000fe400078e3cffULL,
0x0000b0002a2a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000824487824ULL, 0x000fe200078e0253ULL,
0x0000b000425d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000824477824ULL, 0x040fe200078e0227ULL,
0x0000008024247811ULL, 0x000fe200078e18ffULL, 0x0000001048587824ULL, 0x100fe200078e022aULL,
0x0000000726267812ULL, 0x000fe200078e7825ULL, 0x00000010472a7824ULL, 0x000fe200078e022aULL,
0x000000ff3a00720cULL, 0x000fe20003f05270ULL, 0x0000000153467824ULL, 0x000fc400078e0224ULL,
0x0000000127427824ULL, 0x000fe200078e0224ULL, 0x000000005858783bULL, 0x000e620000004200ULL,
0x0000001046547824ULL, 0x100fe400078e025dULL, 0x0000000825257824ULL, 0x000fe200078e0226ULL,
0x000000002a28783bULL, 0x010ea20000004200ULL, 0x0000001042247824ULL, 0x000fe400078e025dULL,
0x00000010253a7824ULL, 0x000fe200078e024eULL, 0x000000005454783bULL, 0x000f280000004200ULL,
0x000000002424783bULL, 0x000f620000004200ULL, 0x00000010ff5e7819ULL, 0x002fc40000011658ULL,
0x000000ff585f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011658ULL,
0x0000ffff587c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x104fe40000011628ULL,
0x000000ff28697812ULL, 0x000fe400078ec0ffULL, 0x00000018ff677819ULL, 0x000fc40000011628ULL,
0x0000ffff28807812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x100fe40000011659ULL,
0x000000ff59627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff587819ULL, 0x000fe40000011659ULL,
0x0000ffff597e7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff287819ULL, 0x010fc40000011654ULL,
0x00000010ff637819ULL, 0x100fe4000001165aULL, 0x000000ff5a647812ULL, 0x040fe400078ec0ffULL,
0x00000018ff597819ULL, 0x000fe4000001165aULL, 0x0000ffff5a837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff657819ULL, 0x000fe4000001165bULL, 0x000000ff5b667812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001165bULL, 0x0000ffff5b847812ULL, 0x000fe400078ec0ffULL,
0x00000010ff707819ULL, 0x100fe40000011655ULL, 0x000000ff555b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff767819ULL, 0x000fe40000011655ULL, 0x0000ffff55977812ULL, 0x000fc400078ec0ffULL,
0x00000018ff557819ULL, 0x000fe40000011656ULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff507819ULL, 0x120fe40000011626ULL, 0x000000ff26937812ULL, 0x040fe400078ec0ffULL,
0x00000018ff927819ULL, 0x000fe40000011626ULL, 0x0000ffff26537812ULL, 0x000fc400078ec0ffULL,
0x00000059ff26723eULL, 0x000fe400020006ffULL, 0x00000055ff59723eULL, 0x000fe200020006ffULL,
0x20000028ff557230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x100fe20000011629ULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x000000ff296b7812ULL, 0x040fe200078ec0ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000018ff6a7819ULL, 0x000fe40000011629ULL,
0x0000ffff29817812ULL, 0x000fc400078ec0ffULL, 0x000000ff54297812ULL, 0x000fe400078ec0ffULL,
0x00000008ff287819ULL, 0x000fe4000001167cULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x2000005cff747230ULL, 0x000fe20000004100ULL, 0x0000005bff5c723eULL, 0x000fe200020006ffULL,
0x20000029ff5b7230ULL, 0x000fe20000004100ULL, 0x00000008ff297819ULL, 0x000fe2000001167eULL,
0x20000028ff867230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fe20000011683ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000029ff29723eULL, 0x000fc400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x0000ffff54967812ULL, 0x000fe200078ec0ffULL,
0x20000029ff887230ULL, 0x000fe20000004100ULL, 0x000000ff2a6e7812ULL, 0x040fe200078ec0ffULL,
0x20000028ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x100fe4000001162aULL,
0x00000018ff6c7819ULL, 0x000fe4000001162aULL, 0x0000ffff2a737812ULL, 0x000fc400078ec0ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001162bULL, 0x00000008ff297819ULL, 0x000fe40000011684ULL,
0x00000008ff287819ULL, 0x000fe40000011696ULL, 0x000000ff56777812ULL, 0x000fe400078ec0ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fc400020006ffULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x000000ff70707812ULL, 0x000fe200078ec0ffULL,
0x2000006bff837230ULL, 0x000fe20000004100ULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000029ff847230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x00000010ff797819ULL, 0x000fe4000001162bULL, 0x000000ff2b6f7812ULL, 0x040fe200078ec0ffULL,
0x20000028ff6b7230ULL, 0x000fe20000004100ULL, 0x0000ffff2b727812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8d7819ULL, 0x100fe40000011657ULL, 0x000000ff577b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fe40000011657ULL, 0x0000ffff57997812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2b7819ULL, 0x000fe40000011654ULL, 0x0000ffff56987812ULL, 0x000fc400078ec0ffULL,
0x00000077ff57723eULL, 0x000fe200020006ffULL, 0x2000006eff777230ULL, 0x000fe20000004100ULL,
0x00000070ff6e723eULL, 0x000fe200020006ffULL, 0x2000002aff707230ULL, 0x000fe20000004100ULL,
0x000000ff61617812ULL, 0x000fe200078ec0ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x000000ff2b2b7812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff287819ULL, 0x000fe40000011697ULL, 0x00000008ff297819ULL, 0x000fc40000011698ULL,
0x00000008ff2a7819ULL, 0x000fe40000011699ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x20000061ff877230ULL, 0x000fe20000004100ULL, 0x0000002bff2b723eULL, 0x000fe200020006ffULL,
0x20000067ff7c7230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fc400020006ffULL,
0x00000029ff29723eULL, 0x000fe400020006ffULL, 0x0000002aff2a723eULL, 0x000fe200020006ffULL,
0x20000028ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff8c7819ULL, 0x000fe40000011656ULL,
0x00000010ff527819ULL, 0x100fe20000011627ULL, 0x2000002aff617230ULL, 0x000fe20000004100ULL,
0x000000ff27957812ULL, 0x000fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fc40000011627ULL,
0x0000ffff27547812ULL, 0x000fe400078ec0ffULL, 0x00000076ff56723eULL, 0x000fe200020006ffULL,
0x2000006fff767230ULL, 0x000fe20000004100ULL, 0x00000064ff27723eULL, 0x000fe200020006ffULL,
0x2000002bff6f7230ULL, 0x000fe20000004100ULL, 0x000000ff65657812ULL, 0x000fe200078ec0ffULL,
0x20000029ff647230ULL, 0x000fe20000004100ULL, 0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL,
0x009000004128783bULL, 0x000e620000000200ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL,
0x20000065ff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff79797812ULL, 0x000fc400078ec0ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x2000005fff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL, 0x20000062ff7f7230ULL, 0x000fe20000004100ULL,
0x00000063ff63723eULL, 0x000fe200020006ffULL, 0x2000005eff857230ULL, 0x000fe20000004100ULL,
0x0000008dff65723eULL, 0x000fc400020006ffULL, 0x00000018ff8e7819ULL, 0x000fe20000011624ULL,
0x20000063ff897230ULL, 0x000fe20000004100ULL, 0x00000079ff8d723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000000ff248f7812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x2000007aff797230ULL, 0x000fe20000004100ULL,
0x0000008eff62723eULL, 0x000fe200020006ffULL, 0x2000008dff8e7230ULL, 0x000fe20000004100ULL,
0x0000008fff63723eULL, 0x000fc400020006ffULL, 0x00000073ff8d723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000072ff8f723eULL, 0x000fe200020006ffULL,
0x0000004f28288231ULL, 0x08afe200003400ffULL, 0x00000010ff727819ULL, 0x000fe2000001167dULL,
0x0000004f2a2a8231ULL, 0x000fe200003400ffULL, 0x00000010ff737819ULL, 0x000fe2000001167fULL,
0x0000000029298231ULL, 0x080fe200003400ffULL, 0x00000010ff857819ULL, 0x000fe20000011685ULL,
0x000000002b2b8231ULL, 0x000fe200003400ffULL, 0x00000010ff7a7819ULL, 0x000fe20000011687ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x0000105485727816ULL, 0x000fe20000000072ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000010547a737816ULL, 0x000fe20000000073ULL,
0x20000058ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fc40000011624ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000ffff245d7812ULL, 0x000fe200078ec0ffULL,
0x000000722820723cULL, 0x000fe20000041820ULL, 0x000000ff6d7a7812ULL, 0x000fe200078ec0ffULL,
0x20000066ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x100fe40000011625ULL,
0x000000ff25917812ULL, 0x000fe400078ec0ffULL, 0x00000018ff907819ULL, 0x000fc40000011625ULL,
0x0000ffff254e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6d7819ULL, 0x000fe40000011674ULL,
0x0000005aff25723eULL, 0x000fe400020006ffULL, 0x00000010ff747819ULL, 0x000fe40000011675ULL,
0x00000010ff877819ULL, 0x000fe20000011688ULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x00000010ff277819ULL, 0x000fc40000011627ULL, 0x00000010ff727819ULL, 0x000fe40000011689ULL,
0x0000105474877816ULL, 0x000fe40000000087ULL, 0x0000105472727816ULL, 0x000fe40000000027ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff747819ULL, 0x000fe4000001168bULL,
0x000000ff24247812ULL, 0x000fc400078ec0ffULL, 0x00000010ff277819ULL, 0x000fe40000011626ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x0000105474737816ULL, 0x000fe40000000071ULL,
0x00000024ff71723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x000fe40000011625ULL,
0x00001054278a7816ULL, 0x000fe2000000008aULL, 0x000000722818723cULL, 0x000fe20000041818ULL,
0x009000003a24783bULL, 0x000e620000000200ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000078ff5a723eULL, 0x000fc400020006ffULL,
0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL, 0x2000006cff787230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fe20000011681ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff686c7812ULL, 0x000fe400078ec0ffULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000008cff66723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fc400020006ffULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000006cff8c723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x000000ff82827812ULL, 0x000fe200078ec0ffULL, 0x20000069ff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe20000011680ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000007bff58723eULL, 0x000fe200020006ffULL, 0x2000006aff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x000010546d867816ULL, 0x000fe20000000086ULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe2000001165dULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe4000001167bULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x00000086281c723cULL, 0x000fe2000004181cULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x0000000025258231ULL, 0x082fe200003400ffULL, 0x00000010ff5d7819ULL, 0x000fe2000001168cULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x0000105472817816ULL, 0x000fe20000000081ULL,
0x0000004f24248231ULL, 0x080fe200003400ffULL, 0x000010545d7e7816ULL, 0x000fe2000000007eULL,
0x0000004f26268231ULL, 0x000fe200003400ffULL, 0x00000010ff727819ULL, 0x000fc40000011679ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff7f7819ULL, 0x000fe40000011683ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff5d7819ULL, 0x000fe4000001167cULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff777819ULL, 0x000fc40000011677ULL,
0x00000010ff737819ULL, 0x000fe40000011676ULL, 0x00000010ff8e7819ULL, 0x000fe4000001168eULL,
0x00000010ff787819ULL, 0x000fe40000011678ULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff797819ULL, 0x000fc4000001168fULL,
0x000010548b8b7816ULL, 0x000fe40000000084ULL, 0x00001054827f7816ULL, 0x000fe4000000007fULL,
0x000010545d807816ULL, 0x000fe40000000080ULL, 0x0000105472727816ULL, 0x000fe20000000077ULL,
0x0000008a2814723cULL, 0x000fe20000041814ULL, 0x000010548e737816ULL, 0x000fe40000000073ULL,
0x0000105478787816ULL, 0x000fc4000000008dULL, 0x0000105470797816ULL, 0x000fe40000000079ULL,
0x000000ff50507812ULL, 0x000fe200078ec0ffULL, 0x0000007e2810723cULL, 0x040fe20000041810ULL,
0x00000010ff007819ULL, 0x000fe40000011655ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000093ff6a723eULL, 0x000fe200020006ffULL,
0x00000080280c723cULL, 0x000fe2000004180cULL, 0x00000050ff50723eULL, 0x000fc400020006ffULL,
0x00000008ff4e7819ULL, 0x000fe2000001164eULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff52527812ULL, 0x000fe200078ec0ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000008ff537819ULL, 0x000fe20000011653ULL, 0x000000722808723cULL, 0x000fe20000041808ULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000091ff5e723eULL, 0x000fc400020006ffULL, 0x00000090ff5f723eULL, 0x000fe200020006ffULL,
0x000000782804723cULL, 0x000fe20000041804ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000092ff69723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe20000011667ULL,
0x20000095ff687230ULL, 0x000fe20000004100ULL, 0x0000105400287816ULL, 0x000fe2000000006bULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x0000105456297816ULL, 0x000fe20000000029ULL,
0x20000094ff6c7230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fc400020006ffULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x00000028241c723cULL, 0x000fe2000004181cULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166aULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff297819ULL, 0x000fe20000011650ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165cULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fc40000011658ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00001054296a7816ULL, 0x000fe4000000006aULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5c7819ULL, 0x000fc4000001166fULL,
0x00000010ff6e7819ULL, 0x000fe4000001166eULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff6b7819ULL, 0x000fe40000011652ULL, 0x00000010ff007819ULL, 0x000fe40000011669ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff297819ULL, 0x000fe40000011654ULL, 0x0000105465677816ULL, 0x000fe40000000058ULL,
0x000010547a7a7816ULL, 0x000fe40000000063ULL, 0x000010545c5c7816ULL, 0x000fe4000000005bULL,
0x000010546e5d7816ULL, 0x000fe4000000005dULL, 0x0000105466667816ULL, 0x000fc40000000057ULL,
0x0000105459647816ULL, 0x000fe40000000064ULL, 0x000010545a657816ULL, 0x000fe20000000061ULL,
0x0000005c2420723cULL, 0x040fe20000041820ULL, 0x00001054717b7816ULL, 0x000fe4000000005eULL,
0x0000105462627816ULL, 0x000fe4000000006dULL, 0x000010545f637816ULL, 0x000fe4000000004eULL,
0x000010546b6b7816ULL, 0x000fe20000000068ULL, 0x000000662418723cULL, 0x000fe20000041818ULL,
0x0000105400287816ULL, 0x000fc40000000053ULL, 0x000010546c297816ULL, 0x000fca0000000029ULL,
0x000000642414723cULL, 0x040ff00000041814ULL, 0x0000007a2410723cULL, 0x040ff00000041810ULL,
0x00000062240c723cULL, 0x040ff0000004180cULL, 0x0000006a2408723cULL, 0x040ff00000041808ULL,
0x000000282404723cULL, 0x000fe20000041804ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200030247f8cULL, 0x0002a2000c80043fULL, 0xfffffff84d4d7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004043277810ULL, 0x000fe20007ffe0ffULL,
0x00f688004dff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff617224ULL, 0x000fe200078e0045ULL,
0x0000000151517812ULL, 0x000fc400078e0cffULL, 0x0000002c2700720cULL, 0x000fda0003f06070ULL,
0x00006f7000000947ULL, 0x000fea0003800000ULL, 0x0000040060007984ULL, 0x008ee40000000800ULL,
0x8000000000ff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000240030007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0000240030247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000439257811ULL, 0x000fe200078fe8ffULL,
0x00000080ff557424ULL, 0x000fe200078e00ffULL, 0x00000001ff387819ULL, 0x000fe2000001162dULL,
0x000000082f4e7824ULL, 0x000fe200078e00ffULL, 0x0000003639007211ULL, 0x000fe200078fe8ffULL,
0x0000000136247824ULL, 0x000fe200078e0225ULL, 0x0000000103277810ULL, 0x000fe20007ffe0ffULL,
0x0000002038267824ULL, 0x000fe200078e0243ULL, 0x0000003900257212ULL, 0x0c0fe200078e3cffULL,
0x0000000800287824ULL, 0x000fe200078e00ffULL, 0x0000003924007212ULL, 0x040fe200078e3cffULL,
0x0000000824297824ULL, 0x000fe200078e00ffULL, 0x0000008026247810ULL, 0x000fe20007ffe0ffULL,
0x000010002f627824ULL, 0x000fe200078e00ffULL, 0xfffffff828597812ULL, 0x000fc400078ee225ULL,
0xfffffff8295a7812ULL, 0x000fe200078ee200ULL, 0x0000620037517a24ULL, 0x100fe200078e0224ULL,
0x000000242c297217ULL, 0x000fe40007800000ULL, 0x00000003ff537819ULL, 0x000fe40000011639ULL,
0x000000022700720cULL, 0x000fe20003f06070ULL, 0x0000000129297824ULL, 0x000fe200078e0a24ULL,
0x0000000839257811ULL, 0x040fe400078fe8ffULL, 0x0000000c39277811ULL, 0x000fc400078fe8ffULL,
0x00000004534f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000136007824ULL, 0x040fe200078e0225ULL,
0x0000002029297807ULL, 0x000fe20000000000ULL, 0x0000000136267824ULL, 0x000fe200078e0227ULL,
0x0000004f51277210ULL, 0x100fe20007ffe036ULL, 0x00000008005b7824ULL, 0x040fe200078e00ffULL,
0x0000003900287212ULL, 0x080fe200078e3cffULL, 0x00000008262b7824ULL, 0x040fe200078e00ffULL,
0x0000003926007212ULL, 0x000fe200078e3cffULL, 0x00005e0027267625ULL, 0x000fe200078e0055ULL,
0x0000005351247210ULL, 0x000fc40007ffe036ULL, 0x0000002936297217ULL, 0x000fe40007800000ULL,
0x0000003c262a7210ULL, 0x080fe20007f5e0ffULL, 0x00005e0024247625ULL, 0x000fe200078e0055ULL,
0xfffffff85b5b7812ULL, 0x000fe400078ee228ULL, 0xfffffff82b007812ULL, 0x000fe200078ee200ULL,
0x0000000129507824ULL, 0x000fe200078e0a36ULL, 0x0000003c24287210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e0627ULL, 0x000000084e527812ULL, 0x000fc400078ec0ffULL,
0x000000504f00720cULL, 0x080fe20003f46070ULL, 0x000000ffff297224ULL, 0x000fe200000e0625ULL,
0x0000f6a8384f7811ULL, 0x000fe400078e20ffULL, 0x0000100062257812ULL, 0x000fe400078ec0ffULL,
0x0000000853277810ULL, 0x000fe20007ffe0ffULL, 0x000000014f587824ULL, 0x000fe200078e0252ULL,
0x000000505300720cULL, 0x040fe20003f06070ULL, 0x0000200038257824ULL, 0x000fe200078e0225ULL,
0x0000000c53537810ULL, 0x000fe20007ffe0ffULL, 0x00000000580473c2ULL, 0x000ea200000e0000ULL,
0x0000002751247210ULL, 0x000fc40007ffe036ULL, 0x0000005351267210ULL, 0x000fe40007ffe036ULL,
0x0000b000255c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x080fe200078e0055ULL,
0x000000502700720cULL, 0x080fe40003f66070ULL, 0x000000505300720cULL, 0x000fe20003f86070ULL,
0x00005e0026267625ULL, 0x000fe200078e0055ULL, 0x0000003c24247210ULL, 0x000fc60007fbe0ffULL,
0x0000001059597824ULL, 0x100fe200078e025cULL, 0x0000003c26267210ULL, 0x000fe20007fde0ffULL,
0x000000105a5a7824ULL, 0x100fe400078e025cULL, 0x000000105b5b7824ULL, 0x100fe200078e025cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028597faeULL, 0x0007e2000c101c46ULL,
0x00000010005c7824ULL, 0x000fe200078e025cULL, 0x0000000852007812ULL, 0x000fe200078e3cffULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x000000002a5a7faeULL, 0x0007e2000d101c46ULL,
0x000000ffff277224ULL, 0x000fc400030e0627ULL, 0x000000014f5d7824ULL, 0x000fe200078e0200ULL,
0x00000000245b7faeULL, 0x0007e8000d901c46ULL, 0x00000000265c7faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000058247f8cULL, 0x0084e8000c80043fULL, 0x000004005d297984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628003b267f8cULL, 0x000fe2000c80043fULL, 0x8000000029ff7812ULL, 0x010fc60007844845ULL,
0x00f62c003b2b7984ULL, 0x000f240000000800ULL, 0x800000002bff7812ULL, 0x010fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff617224ULL, 0x008fe200078e0025ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe035247812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff007424ULL, 0x000fe200078e00ffULL,
0x0000001035257812ULL, 0x040fe400078ec0ffULL, 0x0000000835287812ULL, 0x000fc800078ec0ffULL,
0x0000002428247210ULL, 0x000fe40007ffe025ULL, 0x0000000000257305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000250000735dULL, 0x010fe40003800000ULL,
0x00f62c0024257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x008fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000803c257810ULL, 0x000fca0007ffe03dULL,
0x000000013e257824ULL, 0x000fca00078e0225ULL, 0x00f0000025277984ULL, 0x000ee80000000800ULL,
0x00f2000025007984ULL, 0x0008620000000800ULL, 0x000000322700720bULL, 0x008fe20003f1d000ULL,
0x0000f5f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000247806ULL, 0x010fc800000e0100ULL,
0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff507424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x000000012d247811ULL, 0x000fe400078ff0ffULL, 0x000000322700720bULL, 0x000fe40003f14000ULL,
0x0000002d2400720cULL, 0x000fe20003f65270ULL, 0x0000f5b27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000247806ULL, 0x000fe400000e0100ULL, 0x0000002732257209ULL, 0x000fe20007810000ULL,
0x000000802d29b824ULL, 0x000fe200078e023cULL, 0x00000002ff527819ULL, 0x000fc60000011639ULL,
0x000000013e28b824ULL, 0x000fe200078e0229ULL, 0x8000002532267221ULL, 0x000fe20000010000ULL,
0x0000ffff24297812ULL, 0x000fc600078e3cffULL, 0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL,
0x00f400252800b388ULL, 0x0007e20000000800ULL, 0x000000292aff7212ULL, 0x000fe4000780c0ffULL,
0x00000026002b7308ULL, 0x000f240000000800ULL, 0x0000002b31317220ULL, 0x010fe20000410000ULL,
0x0000f5327f007947ULL, 0x000fec000b800000ULL, 0x00001f522b247589ULL, 0x00872400000e0000ULL,
0x0000002420207220ULL, 0x090fe20000410000ULL, 0x0000002421217220ULL, 0x080fe20000410000ULL,
0x000000241c1c7220ULL, 0x080fe20000410000ULL, 0x000000241d1d7220ULL, 0x080fe20000410000ULL,
0x0000002418187220ULL, 0x080fe20000410000ULL, 0x0000002419197220ULL, 0x080fe20000410000ULL,
0x0000002414147220ULL, 0x080fe20000410000ULL, 0x0000002415157220ULL, 0x080fe20000410000ULL,
0x0000002410107220ULL, 0x080fe20000410000ULL, 0x0000002411117220ULL, 0x080fe20000410000ULL,
0x000000240c0c7220ULL, 0x080fe20000410000ULL, 0x000000240d0d7220ULL, 0x080fe20000410000ULL,
0x0000002408087220ULL, 0x080fe20000410000ULL, 0x0000002409097220ULL, 0x080fe20000410000ULL,
0x0000002404047220ULL, 0x080fe20000410000ULL, 0x0000002405057220ULL, 0x000fe20000410000ULL,
0x0000f4727f007947ULL, 0x000fea000b800000ULL, 0x00001f402b247589ULL, 0x0008a400000e0000ULL,
0x0000002732327209ULL, 0x000fe20007810000ULL, 0x0000002422227220ULL, 0x084fe20000410000ULL,
0x00000001ff507807ULL, 0x000fe20000000000ULL, 0x0000002423237220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x8000003227270221ULL, 0x000fe20000010000ULL,
0x000000241f1f7220ULL, 0x080fe20000410000ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x0000002416167220ULL, 0x080fe20000410000ULL, 0x0000002417177220ULL, 0x080fe20000410000ULL,
0x0000002412127220ULL, 0x080fe20000410000ULL, 0x00000027002e0308ULL, 0x000ea20000000800ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x000000002e000220ULL, 0x006fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0000003100317221ULL, 0x002fe20000010000ULL, 0x0000010000002947ULL, 0x000fea0003800000ULL,
0x000000082f007824ULL, 0x000fe200078e00ffULL, 0xfffffff035257812ULL, 0x000fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fca00078e0cffULL, 0x0000000100247824ULL, 0x000fca00078e0225ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x000364000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x020fe40003800000ULL,
0x00f6ac0024257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff527819ULL, 0x008fe40000011639ULL,
0x0000002eff00723eULL, 0x000fe400000010ffULL, 0x0000001852267810ULL, 0x040fe40007ffe0ffULL,
0x0000001052277810ULL, 0x000fe40007ffe0ffULL, 0x00005410002b7816ULL, 0x010fe20000000000ULL,
0x0000f1c27f007947ULL, 0x000fea000b800000ULL, 0x00001f522b637589ULL, 0x0002e400000e0000ULL,
0x0000f2027f007947ULL, 0x000fea000b800000ULL, 0x00001f402b007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff527224ULL, 0x002fe200078e0027ULL,
0x0000458000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fc400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000fc8000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff527224ULL, 0x002fe200078e0026ULL,
0x000045e000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000fc2000007944ULL, 0x01cfea0003c00000ULL,
0x000010002f517824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000010002d247824ULL, 0x000fe200078e00ffULL, 0x0000991050547816ULL, 0x002fe400000000ffULL,
0x0000100051517812ULL, 0x000fe400078e0cffULL, 0xffffe00024247812ULL, 0x000fc400078ec0ffULL,
0x0000b000345f7810ULL, 0x100fe40007ffe051ULL, 0x0000b00024457810ULL, 0x000fe40007ffe051ULL,
0x000000ff5400720cULL, 0x000fe20003f05270ULL, 0x00000010465e7824ULL, 0x000fe400078e025fULL,
0x0000001048447824ULL, 0x100fe400078e0245ULL, 0x0000001047457824ULL, 0x000fe200078e0245ULL,
0x000000005e50783bULL, 0x000e620000004200ULL, 0x00000010425f7824ULL, 0x000fc600078e025fULL,
0x000000004528783bULL, 0x014ea80000004200ULL, 0x000000004424783bULL, 0x000f280000004200ULL,
0x000000005f54783bULL, 0x000f620000004200ULL, 0x000000ff508e7812ULL, 0x002fe400078ec0ffULL,
0x00000018ff8f7819ULL, 0x000fc40000011651ULL, 0x00000010ff937819ULL, 0x104fe40000011628ULL,
0x000000ff286d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011628ULL,
0x0000ffff28a47812ULL, 0x000fe400078ec0ffULL, 0x00000010ff967819ULL, 0x000fe40000011629ULL,
0x000000ff29717812ULL, 0x000fc400078ec0ffULL, 0x00000018ff287819ULL, 0x000fe40000011629ULL,
0x0000ffff298c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff297819ULL, 0x000fe4000001162aULL,
0x00000010ff707819ULL, 0x010fe40000011624ULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x0000ffff24a07812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8a7819ULL, 0x000fe2000001162aULL,
0x20000029ff747230ULL, 0x000fe20000004100ULL, 0x000000ff2a727812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2a897812ULL, 0x000fe400078ec0ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001162bULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000018ff6a7819ULL, 0x000fc40000011627ULL,
0x00000010ff8b7819ULL, 0x000fe2000001162bULL, 0x20000028ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff2b737812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2b877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8d7819ULL, 0x000fe40000011625ULL, 0x00000018ff2b7819ULL, 0x000fe40000011650ULL,
0x000000ff70707812ULL, 0x000fc400078ec0ffULL, 0x00000008ff297819ULL, 0x000fe400000116a0ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x20000072ff767230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x20000071ff7b7230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x2000002aff727230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000006aff797230ULL, 0x000fe20000004100ULL,
0x00000070ff28723eULL, 0x000fe200020006ffULL, 0x2000002bff6a7230ULL, 0x000fe20000004100ULL,
0x00000029ff29723eULL, 0x000fc400020006ffULL, 0x00000010ff927819ULL, 0x000fe40000011627ULL,
0x0000ffff25a17812ULL, 0x000fe400078ec0ffULL, 0x0000ffff26a27812ULL, 0x000fe400078ec0ffULL,
0x0000ffff27a37812ULL, 0x000fe400078ec0ffULL, 0x000000ff25677812ULL, 0x000fe400078ec0ffULL,
0x000000ff276b7812ULL, 0x000fc400078ec0ffULL, 0x0000008eff71723eULL, 0x000fe200020006ffULL,
0x20000029ff8e7230ULL, 0x000fe20000004100ULL, 0x0000008dff2a723eULL, 0x000fe200020006ffULL,
0x20000028ff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000ff24657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011624ULL, 0x00000008ff2b7819ULL, 0x000fc400000116a1ULL,
0x00000008ff287819ULL, 0x000fe400000116a2ULL, 0x00000008ff297819ULL, 0x000fe400000116a3ULL,
0x00000010ff247819ULL, 0x100fe40000011652ULL, 0x000000ff52957812ULL, 0x040fe400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe40000011652ULL, 0x0000ffff527d7812ULL, 0x000fc400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000067ff887230ULL, 0x000fe20000004100ULL,
0x0000008fff52723eULL, 0x000fe200020006ffULL, 0x2000002aff8f7230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x2000006bff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff51907812ULL, 0x000fe200078ec0ffULL, 0x20000073ff757230ULL, 0x000fe20000004100ULL,
0x0000002bff2b723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x00000028ff28723eULL, 0x000fc400020006ffULL, 0x00000029ff29723eULL, 0x000fe400020006ffULL,
0x000000ff932a7812ULL, 0x000fe200078ec0ffULL, 0x20000092ff937230ULL, 0x000fe20000004100ULL,
0x00000090ff73723eULL, 0x000fe200020006ffULL, 0x2000002bff907230ULL, 0x000fe20000004100ULL,
0x00000095ff6b723eULL, 0x000fe200020006ffULL, 0x20000028ff927230ULL, 0x000fe20000004100ULL,
0x00000094ff67723eULL, 0x000fe200020006ffULL, 0x20000029ff947230ULL, 0x000fe20000004100ULL,
0x0000002aff95723eULL, 0x000fe200020006ffULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x009800004128783bULL, 0x000e620000000200ULL, 0x00000018ff667819ULL, 0x000fe20000011625ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff857819ULL, 0x000fe20000011650ULL,
0x20000095ff957230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe20000011651ULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fc400020006ffULL,
0x00000018ff997819ULL, 0x020fe40000011654ULL, 0x000000ff85857812ULL, 0x000fe200078ec0ffULL,
0x20000066ff827230ULL, 0x000fe20000004100ULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fc40000011689ULL, 0x00000099ff66723eULL, 0x000fe200020006ffULL,
0x20000065ff847230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x000000ff53987812ULL, 0x000fe200078ec0ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000086ff99723eULL, 0x000fe200020006ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000010ff917819ULL, 0x100fe20000011626ULL, 0x20000099ff857230ULL, 0x000fe20000004100ULL,
0x000000ff26697812ULL, 0x000fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe40000011626ULL,
0x0000ffff51257812ULL, 0x000fe200078ec0ffULL, 0x0000006328288231ULL, 0x08afe200003400ffULL,
0x00000010ff7e7819ULL, 0x100fe20000011653ULL, 0x000000632a2a8231ULL, 0x000fe200003400ffULL,
0x00000018ff977819ULL, 0x000fe20000011653ULL, 0x0000000029298231ULL, 0x080fe200003400ffULL,
0x0000ffff53267812ULL, 0x000fe200078ec0ffULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x00000098ff53723eULL, 0x000fe200020006ffULL, 0x2000008bff987230ULL, 0x000fe20000004100ULL,
0x000000ff24997812ULL, 0x000fe200078ec0ffULL, 0x20000089ff8b7230ULL, 0x000fe20000004100ULL,
0x00000008ff897819ULL, 0x000fe20000011625ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fc40000011684ULL, 0x00000010ff257819ULL, 0x000fe40000011688ULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff847819ULL, 0x000fe4000001168fULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x000010548d247816ULL, 0x000fe40000000024ULL,
0x0000105484257816ULL, 0x000fe20000000025ULL, 0x20000064ff817230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fc400078ec0ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff847819ULL, 0x000fe2000001167dULL, 0x000000242820723cULL, 0x000fe20000041820ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x000000ff7e887812ULL, 0x000fe200078ec0ffULL,
0x20000089ff7e7230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000069ff807230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe20000011681ULL, 0x20000084ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff247819ULL, 0x000fe4000001168eULL, 0x00000010ff897819ULL, 0x000fe20000011682ULL,
0x20000088ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff277819ULL, 0x000fc40000011654ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x0000105425247816ULL, 0x000fe40000000024ULL, 0x0000105489257816ULL, 0x000fe20000000090ULL,
0x20000068ff787230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe40000011626ULL,
0x000000ff27887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff267819ULL, 0x000fe20000011680ULL,
0x00000024281c723cULL, 0x000fe2000004181cULL, 0x00000010ff277819ULL, 0x000fc4000001167fULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff807819ULL, 0x000fe40000011693ULL,
0x0000105491267816ULL, 0x000fe40000000026ULL, 0x0000105480277816ULL, 0x000fe40000000027ULL,
0x00000010ff257819ULL, 0x000fe40000011678ULL, 0x00000010ff247819ULL, 0x000fc40000011679ULL,
0x00000010ff787819ULL, 0x000fe20000011692ULL, 0x000000262818723cULL, 0x000fe20000041818ULL,
0x00000010ff797819ULL, 0x000fe40000011694ULL, 0x00000097ff69723eULL, 0x000fe400020006ffULL,
0x000000ff96977812ULL, 0x000fe400078ec0ffULL, 0x0000105425787816ULL, 0x000fe20000000078ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x0000105424797816ULL, 0x000fc40000000079ULL,
0x009800003a24783bULL, 0x000e620000000200ULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000008ff967819ULL, 0x000fe200000116a4ULL,
0x2000006dff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff6e7819ULL, 0x000fe20000011655ULL,
0x20000097ff977230ULL, 0x000fe20000004100ULL, 0x0000ffff546f7812ULL, 0x000fe200078ec0ffULL,
0x000000782814723cULL, 0x000fe20000041814ULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000008ff8c7819ULL, 0x000fe2000001168cULL,
0x2000006cff777230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL,
0x20000096ff967230ULL, 0x000fe20000004100ULL, 0x00000008ff877819ULL, 0x000fe40000011687ULL,
0x000000ff6e807812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fc4000001166fULL,
0x00000010ff6e7819ULL, 0x000fe4000001167cULL, 0x00000010ff6f7819ULL, 0x000fe4000001167bULL,
0x00000010ff957819ULL, 0x000fe40000011695ULL, 0x00000010ff7c7819ULL, 0x000fe40000011697ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00001054956e7816ULL, 0x000fe2000000006eULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x000010547c6f7816ULL, 0x000fe2000000006fULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000ffff50837812ULL, 0x000fe200078ec0ffULL, 0x0000006324248231ULL, 0x082fe200003400ffULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x0000006326268231ULL, 0x000fe200003400ffULL,
0x00000010ff967819ULL, 0x000fe20000011696ULL, 0x0000006e2810723cULL, 0x000fe20000041810ULL,
0x00000010ff757819ULL, 0x000fe20000011675ULL, 0x0000000025258231ULL, 0x080fe200003400ffULL,
0x00000010ff987819ULL, 0x000fe20000011698ULL, 0x0000000027278231ULL, 0x000fe200003400ffULL,
0x00000008ff837819ULL, 0x000fc40000011683ULL, 0x0000105477967816ULL, 0x000fe40000000096ULL,
0x0000105498777816ULL, 0x000fe40000000075ULL, 0x00000010ff977819ULL, 0x000fe4000001167aULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff6f7819ULL, 0x000fc4000001168aULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff757819ULL, 0x000fe40000011687ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000105497977816ULL, 0x000fc4000000008cULL, 0x000010546f767816ULL, 0x000fe20000000076ULL,
0x20000083ff837230ULL, 0x000fe20000004100ULL, 0x0000105474747816ULL, 0x000fe4000000008bULL,
0x0000105472757816ULL, 0x000fe20000000075ULL, 0x00000096280c723cULL, 0x040fe2000004180cULL,
0x00000099ff99723eULL, 0x000fe400020006ffULL, 0x00000010ff507819ULL, 0x000fe40000011656ULL,
0x00000010ff6a7819ULL, 0x000fe2000001166aULL, 0x20000099ff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x000fe20000011652ULL, 0x000000762808723cULL, 0x000fe20000041808ULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x000000ff50507812ULL, 0x000fe400078ec0ffULL, 0x000000ff549a7812ULL, 0x000fe200078ec0ffULL,
0x000000742804723cULL, 0x000fe20000041804ULL, 0x000000ff55547812ULL, 0x000fe200078ec0ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000018ff9b7819ULL, 0x000fe40000011655ULL,
0x000000ff569d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff297819ULL, 0x000fe4000001167eULL,
0x000010546a287816ULL, 0x000fe40000000083ULL, 0x0000105452297816ULL, 0x000fe40000000029ULL,
0x00000018ff9c7819ULL, 0x000fe40000011656ULL, 0x00000010ff517819ULL, 0x100fe40000011657ULL,
0x000000ff579f7812ULL, 0x000fe200078ec0ffULL, 0x00000028241c723cULL, 0x000fe2000004181cULL,
0x00000018ff9e7819ULL, 0x000fc40000011657ULL, 0x0000ffff55557812ULL, 0x000fe400078ec0ffULL,
0x0000ffff56567812ULL, 0x000fe400078ec0ffULL, 0x0000ffff57577812ULL, 0x000fe400078ec0ffULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff007819ULL, 0x000fe2000001167dULL, 0x20000050ff527230ULL, 0x000fe20000004100ULL,
0x00000008ff557819ULL, 0x000fc40000011655ULL, 0x000000ff51517812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000008ff577819ULL, 0x000fe40000011657ULL,
0x00001054002a7816ULL, 0x000fe4000000006bULL, 0x00000010ff2b7819ULL, 0x000fe40000011653ULL,
0x00000010ff827819ULL, 0x000fc40000011682ULL, 0x00000010ff007819ULL, 0x000fe40000011667ULL,
0x00000010ff507819ULL, 0x000fe40000011669ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff297819ULL, 0x000fe40000011684ULL, 0x0000009aff68723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000009bff64723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x0000009dff6d723eULL, 0x000fe200020006ffULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000009fff65723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000009cff6c723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000009eff9e723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x2000009eff707230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00001054822b7816ULL, 0x000fe2000000002bULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x0000105400287816ULL, 0x000fe20000000081ULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000105450297816ULL, 0x000fc40000000029ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x0000002a2418723cULL, 0x040fe20000041818ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff6e7819ULL, 0x000fe40000011685ULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x000000282414723cULL, 0x000fe20000041814ULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x00000010ff2b7819ULL, 0x000fe40000011688ULL, 0x00000010ff697819ULL, 0x000fe40000011680ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff557819ULL, 0x000fc40000011655ULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff537819ULL, 0x000fe40000011665ULL, 0x00000010ff007819ULL, 0x000fe40000011651ULL,
0x00000010ff297819ULL, 0x000fe4000001166cULL, 0x00000010ff567819ULL, 0x000fc40000011656ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x0000105486867816ULL, 0x000fe40000000071ULL, 0x000010546e877816ULL, 0x000fe40000000073ULL,
0x000010542b687816ULL, 0x000fe40000000068ULL, 0x0000105469697816ULL, 0x000fc40000000054ULL,
0x0000105466667816ULL, 0x000fe2000000007fULL, 0x000000862420723cULL, 0x040fe20000041820ULL,
0x0000105464677816ULL, 0x000fe40000000055ULL, 0x0000105452527816ULL, 0x000fe4000000006dULL,
0x0000105400537816ULL, 0x000fe40000000053ULL, 0x0000105429567816ULL, 0x000fe20000000056ULL,
0x000000682410723cULL, 0x000fe20000041810ULL, 0x0000105470577816ULL, 0x000fce0000000057ULL,
0x00000066240c723cULL, 0x040ff0000004180cULL, 0x000000522408723cULL, 0x040ff00000041808ULL,
0x000000562404723cULL, 0x000fe20000041804ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000200030247f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008043277810ULL, 0x000fe20007ffe0ffULL,
0x00f690004dff7f8cULL, 0x0007e2000c80043fULL, 0x000000012f517812ULL, 0x000fc400078ec0ffULL,
0x0000002c2700720cULL, 0x000fda0003f06070ULL, 0x0000488000000947ULL, 0x000fea0003800000ULL,
0x0000040060007984ULL, 0x008ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240030007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240030247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff387819ULL, 0x000fe2000001162dULL, 0x00000080ff637424ULL, 0x000fe200078e00ffULL,
0x00000003ff517819ULL, 0x000fe20000011639ULL, 0x000000005d0473c2ULL, 0x000ea200000e0000ULL,
0x0000000103297810ULL, 0x000fe20007ffe0ffULL, 0x0000002038007824ULL, 0x000fe200078e0243ULL,
0x0000000451557810ULL, 0x000fe40007ffe0ffULL, 0x000000022900720cULL, 0x000fe40003f06070ULL,
0x000000c000007810ULL, 0x000fc40007ffe0ffULL, 0x0000000851577810ULL, 0x000fe40007ffe0ffULL,
0x000000002c257217ULL, 0x000fe20007800000ULL, 0x0000620037277a24ULL, 0x000fe200078e0200ULL,
0x0000000c51537810ULL, 0x000fc60007ffe0ffULL, 0x0000000125007824ULL, 0x000fe200078e0a00ULL,
0x0000005127247210ULL, 0x140fe40007ffe036ULL, 0x0000005727267210ULL, 0x140fe40007ffe036ULL,
0x0000002000297807ULL, 0x000fe20000000000ULL, 0x00005e0024247625ULL, 0x000fe200078e0063ULL,
0x0000005327287210ULL, 0x000fe40007ffe036ULL, 0x0000002936297217ULL, 0x000fe40007800000ULL,
0x0000003c242a7210ULL, 0x000fc40007f1e0ffULL, 0x0000005527247210ULL, 0x100fe20007ffe036ULL,
0x0000000129007824ULL, 0x000fe400078e0a36ULL, 0x000000ffff2b7224ULL, 0x000fe400000e0625ULL,
0x00005e0024247625ULL, 0x080fe200078e0063ULL, 0x000000005100720cULL, 0x080fe40003f46070ULL,
0x000000005500720cULL, 0x000fe20003f06070ULL, 0x00005e0026267625ULL, 0x000fe200078e0063ULL,
0x0000003c24247210ULL, 0x000fc40007f7e0ffULL, 0x000000005300720cULL, 0x000fe20003f86070ULL,
0x00005e0028287625ULL, 0x000fe200078e0063ULL, 0x0000003c26267210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200018e0625ULL, 0x000000005700720cULL, 0x000fe20003f66070ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x0000003c28287210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a497faeULL, 0x0007e8000d101c46ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x00000000244a7faeULL, 0x0007ea000c101c46ULL,
0x00000000264b7faeULL, 0x0007e8000d901c46ULL, 0x00000000284c7faeULL, 0x0007e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x004fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000005d4a7f8cULL, 0x0084e8000c80043fULL, 0x0000040058007984ULL, 0x0005220000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648003b247f8cULL, 0x000fe2000c80043fULL, 0x8000000000ff7812ULL, 0x010fc60007844861ULL,
0x00f64c003b277984ULL, 0x000f240000000800ULL, 0x8000000027ff7812ULL, 0x010fe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x000964000021f000ULL, 0x3fa0000000007823ULL, 0x010fe200000100ffULL,
0x000000260000735dULL, 0x020fe20003800000ULL, 0x00f64c003b277984ULL, 0x000f240000000800ULL,
0x8000000027ff7812ULL, 0x010fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001003c257810ULL, 0x000fca0007ffe03dULL, 0x000000013e257824ULL, 0x000fca00078e0225ULL,
0x00f0000025277984ULL, 0x000f280000000800ULL, 0x00f2000025007984ULL, 0x0002a20000000800ULL,
0x000000322700720bULL, 0x010fe20003f1d000ULL, 0x0000d3a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x002fc800000e0100ULL, 0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff267424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x000000022d247811ULL, 0x000fe400078ff0ffULL,
0x000000322700720bULL, 0x000fe40003f14000ULL, 0x0000002d2400720cULL, 0x000fe20003f65270ULL,
0x0000d3627f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x0000002732257209ULL, 0x000fe20007810000ULL, 0x000000802d29b824ULL, 0x000fe200078e023cULL,
0x00000002ff527819ULL, 0x000fc60000011639ULL, 0x000000013e28b824ULL, 0x000fe200078e0229ULL,
0x8000002532267221ULL, 0x000fe20000010000ULL, 0x0000ffff24297812ULL, 0x000fc600078e3cffULL,
0x3fb8aa3b26267820ULL, 0x000fe20000410000ULL, 0x00f400252800b388ULL, 0x0003e20000000800ULL,
0x000000292aff7212ULL, 0x000fe4000780c0ffULL, 0x00000026002b7308ULL, 0x000f240000000800ULL,
0x0000002b31317220ULL, 0x010fe20000410000ULL, 0x0000d2e27f007947ULL, 0x000fec000b800000ULL,
0x00001f522b247589ULL, 0x00232400000e0000ULL, 0x0000002420207220ULL, 0x090fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x0000d2227f007947ULL, 0x000fea000b800000ULL,
0x00001f402b247589ULL, 0x00086400000e0000ULL, 0x0000002732327209ULL, 0x000fe20007810000ULL,
0x0000002422227220ULL, 0x082fe20000410000ULL, 0x00000001ff267807ULL, 0x000fe20000000000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x000000241e1e7220ULL, 0x080fe20000410000ULL,
0x8000003227270221ULL, 0x000fe20000010000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x00000027002e0308ULL, 0x000e620000000800ULL, 0x0000002413137220ULL, 0x080fe20000410000ULL,
0x000000240e0e7220ULL, 0x080fe20000410000ULL, 0x000000240f0f7220ULL, 0x080fe20000410000ULL,
0x000000240a0a7220ULL, 0x080fe20000410000ULL, 0x000000240b0b7220ULL, 0x080fe20000410000ULL,
0x0000002406067220ULL, 0x080fe20000410000ULL, 0x0000002407077220ULL, 0x000fe20000410000ULL,
0x000000002e000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0000003100317221ULL, 0x004fe20000010000ULL,
0x000000f000002947ULL, 0x000fea0003800000ULL, 0x000000084e257812ULL, 0x000fe400078ec0ffULL,
0xfffffff035007812ULL, 0x000fca00078ec0ffULL, 0x0000000100257824ULL, 0x000fca00078e0225ULL,
0x00f6ac0025007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000240000735dULL, 0x004fe40003800000ULL,
0x00f6ac0025247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fc40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002ff527819ULL, 0x000fe40000011639ULL,
0x0000002eff00723eULL, 0x000fe400000010ffULL, 0x0000001852277810ULL, 0x040fe40007ffe0ffULL,
0x0000001052287810ULL, 0x000fe40007ffe0ffULL, 0x00005410002b7816ULL, 0x010fe20000000000ULL,
0x0000cf827f007947ULL, 0x000fea000b800000ULL, 0x00001f522b497589ULL, 0x0002a400000e0000ULL,
0x0000cfc27f007947ULL, 0x000fea000b800000ULL, 0x00001f402b007589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff527224ULL, 0x002fe200078e0028ULL,
0x00006a0000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fc400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000d80000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff527224ULL, 0x002fe200078e0027ULL,
0x00006a6000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000d7a000007944ULL, 0x01cfea0003c00000ULL,
0x000010002d247824ULL, 0x000fe200078e00ffULL, 0x0000100062257812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0xffffe00024247812ULL, 0x000fc800078ec0ffULL,
0x0000b00024247810ULL, 0x100fe40007ffe025ULL, 0x0000b00034257810ULL, 0x000fc60007ffe025ULL,
0x0000001047507824ULL, 0x100fe400078e0224ULL, 0x0000001046287824ULL, 0x100fe400078e0225ULL,
0x0000001048547824ULL, 0x002fe200078e0224ULL, 0x0000991026247816ULL, 0x000fe200000000ffULL,
0x000000005050783bULL, 0x000e620000004200ULL, 0x0000001042257824ULL, 0x000fe400078e0225ULL,
0x000000ff2400720cULL, 0x000fe20003f05270ULL, 0x000000002828783bULL, 0x014ea80000004200ULL,
0x000000005454783bULL, 0x000f280000004200ULL, 0x000000002524783bULL, 0x000f620000004200ULL,
0x000000ff51787812ULL, 0x002fc400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011651ULL,
0x00000010ff8d7819ULL, 0x104fe40000011628ULL, 0x000000ff28427812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011628ULL, 0x0000ffff28937812ULL, 0x000fe400078ec0ffULL,
0x00000018ff287819ULL, 0x000fc40000011629ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x00000018ff797819ULL, 0x000fe20000011652ULL,
0x2000004cff637230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000028ff4c7230ULL, 0x000fe20000004100ULL, 0x000000ff537b7812ULL, 0x000fe400078ec0ffULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000078ff7e7230ULL, 0x000fe20000004100ULL,
0x00000079ff28723eULL, 0x000fc400020006ffULL, 0x00000010ff827819ULL, 0x100fe40000011650ULL,
0x000000ff50767812ULL, 0x040fe400078ec0ffULL, 0x00000018ff757819ULL, 0x000fe40000011650ULL,
0x0000ffff50817812ULL, 0x000fe400078ec0ffULL, 0x0000ffff29947812ULL, 0x000fe400078ec0ffULL,
0x00000010ff837819ULL, 0x000fc40000011651ULL, 0x0000ffff51807812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7c7819ULL, 0x000fe40000011652ULL, 0x000000ff527a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff52697812ULL, 0x000fe400078ec0ffULL, 0x00000010ff917819ULL, 0x000fe40000011629ULL,
0x000000ff29507812ULL, 0x000fc400078ec0ffULL, 0x0000007bff78723eULL, 0x000fe200020006ffULL,
0x20000077ff7b7230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x110fe20000011654ULL,
0x20000028ff777230ULL, 0x000fe20000004100ULL, 0x000000ff546c7812ULL, 0x040fe200078ec0ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe40000011654ULL,
0x0000ffff54737812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x000fc40000011653ULL,
0x00000018ff8c7819ULL, 0x000fe40000011653ULL, 0x0000ffff536a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff297819ULL, 0x100fe4000001162aULL, 0x000000ff2a527812ULL, 0x040fe400078ec0ffULL,
0x00000018ff517819ULL, 0x000fe4000001162aULL, 0x0000ffff2a957812ULL, 0x000fc400078ec0ffULL,
0x00000010ff727819ULL, 0x100fe40000011655ULL, 0x000000ff556e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011655ULL, 0x0000ffff55887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x000fe40000011657ULL, 0x000000ff57747812ULL, 0x000fc400078ec0ffULL,
0x00000018ff717819ULL, 0x000fe40000011657ULL, 0x0000ffff57857812ULL, 0x000fe400078ec0ffULL,
0x00000010ff2a7819ULL, 0x100fe4000001162bULL, 0x000000ff2b547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff537819ULL, 0x000fe4000001162bULL, 0x0000ffff2b967812ULL, 0x000fc400078ec0ffULL,
0x00000042ff67723eULL, 0x000fe400020006ffULL, 0x00000010ff2b7819ULL, 0x120fe40000011624ULL,
0x000000ff24577812ULL, 0x040fe200078ec0ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000018ff557819ULL, 0x000fe40000011624ULL, 0x0000ffff24977812ULL, 0x000fe400078ec0ffULL,
0x00000008ff287819ULL, 0x000fc40000011694ULL, 0x00000010ff927819ULL, 0x100fe40000011625ULL,
0x000000ff25627812ULL, 0x040fe400078ec0ffULL, 0x00000018ff247819ULL, 0x000fe40000011625ULL,
0x0000ffff25427812ULL, 0x000fe400078ec0ffULL, 0x000000ff26657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff257819ULL, 0x000fc40000011626ULL, 0x00000050ff50723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe400020006ffULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x20000050ff687230ULL, 0x000fe20000004100ULL, 0x00000028ff28723eULL, 0x000fe200020006ffULL,
0x20000054ff507230ULL, 0x000fe20000004100ULL, 0x000000ff27667812ULL, 0x000fe200078ec0ffULL,
0x2000006dff8e7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000028ff6d7230ULL, 0x000fe20000004100ULL, 0x00000025ff25723eULL, 0x000fc400020006ffULL,
0x00000010ff467819ULL, 0x000fe40000011626ULL, 0x0000ffff26487812ULL, 0x000fe400078ec0ffULL,
0x00000018ff267819ULL, 0x000fe40000011627ULL, 0x000000ff56707812ULL, 0x000fe400078ec0ffULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000066ff54723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x000000ff29297812ULL, 0x000fe200078ec0ffULL,
0x20000025ff657230ULL, 0x000fe20000004100ULL, 0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL,
0x20000052ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fe20000011696ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fc400020006ffULL,
0x00000053ff53723eULL, 0x000fe400020006ffULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x0000007aff25723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000025ff797230ULL, 0x000fe20000004100ULL, 0x00000018ff6f7819ULL, 0x000fc40000011656ULL,
0x00000029ff29723eULL, 0x000fe200020006ffULL, 0x20000070ff8f7230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL, 0x00000057ff61723eULL, 0x000fe200020006ffULL,
0x20000051ff577230ULL, 0x000fe20000004100ULL, 0x00000062ff52723eULL, 0x000fe200020006ffULL,
0x20000053ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe20000011656ULL,
0x20000024ff537230ULL, 0x000fe20000004100ULL, 0x0000ffff56847812ULL, 0x000fe200078ec0ffULL,
0x20000026ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe20000011627ULL,
0x2000006cff247230ULL, 0x000fe20000004100ULL, 0x0000ffff27567812ULL, 0x000fe200078ec0ffULL,
0x20000028ff6c7230ULL, 0x000fe20000004100ULL, 0x0000006fff26723eULL, 0x000fe200020006ffULL,
0x2000002aff6f7230ULL, 0x000fe20000004100ULL, 0x00000071ff27723eULL, 0x000fe200020006ffULL,
0x20000029ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe20000011693ULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x0000002bff70723eULL, 0x000fe200020006ffULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x00a000004128783bULL, 0x000e620000000200ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006bff8a7230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000025ff6b7230ULL, 0x000fe20000004100ULL,
0x00000008ff257819ULL, 0x000fe20000011695ULL, 0x2000006eff8b7230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000076ff7f7230ULL, 0x000fe20000004100ULL,
0x00000025ff25723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x20000075ff7a7230ULL, 0x000fe20000004100ULL,
0x00000008ff737819ULL, 0x000fe20000011673ULL, 0x20000025ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff257819ULL, 0x000fc40000011697ULL, 0x0000008cff76723eULL, 0x000fe400020006ffULL,
0x0000008dff75723eULL, 0x000fe400020006ffULL, 0x00000025ff8d723eULL, 0x000fe200020006ffULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x000000ff728c7812ULL, 0x000fe400078ec0ffULL,
0x00000073ff25723eULL, 0x000fe200020006ffULL, 0x2000008dff737230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff8d7819ULL, 0x000fe20000011688ULL, 0x20000025ff887230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x20000074ff907230ULL, 0x000fe20000004100ULL,
0x00000085ff25723eULL, 0x000fe200020006ffULL, 0x0000004928288231ULL, 0x082fe200003400ffULL,
0x00000091ff74723eULL, 0x000fe200020006ffULL, 0x000000492a2a8231ULL, 0x000fe200003400ffULL,
0x00000010ff247819ULL, 0x000fe20000011624ULL, 0x20000025ff917230ULL, 0x000fe20000004100ULL,
0x00000010ff257819ULL, 0x000fe2000001168bULL, 0x0000000029298231ULL, 0x080fe200003400ffULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x000000002b2b8231ULL, 0x000fe200003400ffULL,
0x00000010ff8c7819ULL, 0x000fe2000001168cULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x0000008dff8d723eULL, 0x000fc400020006ffULL, 0x0000105489247816ULL, 0x000fe40000000024ULL,
0x000010548c257816ULL, 0x000fe20000000025ULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x00000008ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff8e7819ULL, 0x000fe2000001168eULL, 0x000000242820723cULL, 0x000fe20000041820ULL,
0x00000010ff8d7819ULL, 0x000fc4000001168dULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff257819ULL, 0x000fe2000001168aULL,
0x20000087ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe20000011688ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x000000ff7c887812ULL, 0x000fe400078ec0ffULL,
0x0000105425247816ULL, 0x000fc40000000024ULL, 0x000010548e257816ULL, 0x000fe4000000008dULL,
0x00000010ff7c7819ULL, 0x000fe40000011685ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe20000011691ULL, 0x00000024281c723cULL, 0x000fe2000004181cULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x00000008ff807819ULL, 0x000fc40000011680ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000010ff257819ULL, 0x000fe40000011626ULL,
0x00000010ff247819ULL, 0x000fe20000011627ULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x0000105425847816ULL, 0x000fe40000000084ULL, 0x0000105424857816ULL, 0x000fe40000000085ULL,
0x00a000003a24783bULL, 0x000e620000000200ULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe20000011690ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe200020006ffULL,
0x000000842814723cULL, 0x000fe20000041814ULL, 0x000000ff82827812ULL, 0x000fe400078ec0ffULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fc40000011681ULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff867819ULL, 0x000fe40000011686ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x000010547c877816ULL, 0x000fc40000000087ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x0000006aff7c723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x0000105486867816ULL, 0x000fe2000000008fULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff6a7819ULL, 0x000fe2000001167bULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fe20000011680ULL, 0x0000000025258231ULL, 0x082fe200003400ffULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x000000862818723cULL, 0x000fe20000041818ULL,
0x00000010ff887819ULL, 0x000fe20000011688ULL, 0x0000000027278231ULL, 0x000fe200003400ffULL,
0x000010546a7b7816ULL, 0x000fe2000000007bULL, 0x0000004924248231ULL, 0x080fe200003400ffULL,
0x00000010ff787819ULL, 0x000fe20000011678ULL, 0x0000004926268231ULL, 0x000fe200003400ffULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x0000105488887816ULL, 0x000fe40000000079ULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff7a7819ULL, 0x000fc4000001167aULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff6a7819ULL, 0x000fe40000011677ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff797819ULL, 0x000fe4000001167cULL,
0x000010547d897816ULL, 0x000fc40000000078ULL, 0x0000105482827816ULL, 0x000fe4000000007fULL,
0x0000105483837816ULL, 0x000fe4000000007eULL, 0x000010547a7a7816ULL, 0x000fe20000000081ULL,
0x000000882808723cULL, 0x000fe20000041808ULL, 0x000010546a787816ULL, 0x000fe40000000069ULL,
0x0000105476797816ULL, 0x000fe40000000079ULL, 0x00000010ff007819ULL, 0x000fc40000011663ULL,
0x00000010ff6b7819ULL, 0x000fe2000001166bULL, 0x000000822810723cULL, 0x040fe20000041810ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000008ff427819ULL, 0x000fe20000011642ULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000000ff46467812ULL, 0x000fe200078ec0ffULL, 0x0000007a280c723cULL, 0x000fe2000004180cULL,
0x000000ff47477812ULL, 0x000fc400078ec0ffULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff4c7819ULL, 0x000fe2000001164cULL,
0x000000782804723cULL, 0x000fe20000041804ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000092ff92723eULL, 0x000fc400020006ffULL,
0x00000010ff297819ULL, 0x000fe4000001166dULL, 0x0000105400287816ULL, 0x000fe2000000006bULL,
0x20000092ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff2b7819ULL, 0x000fe40000011650ULL,
0x00000010ff007819ULL, 0x000fe4000001166fULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000056ff56723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x000010544c297816ULL, 0x000fe20000000029ULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00001054712a7816ULL, 0x000fe20000000064ULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00001054002b7816ULL, 0x000fc4000000002bULL,
0x00000010ff007819ULL, 0x000fe20000011655ULL, 0x00000028241c723cULL, 0x040fe2000004181cULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff697819ULL, 0x000fe40000011668ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff687819ULL, 0x000fe20000011675ULL,
0x0000002a2418723cULL, 0x000fe20000041818ULL, 0x0000105400287816ULL, 0x000fc40000000073ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff6f7819ULL, 0x000fe40000011662ULL, 0x00000010ff6e7819ULL, 0x000fe4000001166eULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x00000010ff617819ULL, 0x000fc40000011661ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff717819ULL, 0x000fe40000011672ULL, 0x00000010ff2a7819ULL, 0x000fe40000011653ULL,
0x00000010ff297819ULL, 0x000fe40000011642ULL, 0x00000010ff667819ULL, 0x000fc40000011666ULL,
0x00000010ff2b7819ULL, 0x000fe40000011646ULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff007819ULL, 0x000fc40000011651ULL,
0x00000010ff497819ULL, 0x000fe40000011656ULL, 0x0000105468687816ULL, 0x000fe40000000067ULL,
0x0000105474697816ULL, 0x000fe40000000069ULL, 0x00001054576e7816ULL, 0x000fe4000000006eULL,
0x000010546f6f7816ULL, 0x000fe4000000006cULL, 0x0000105470707816ULL, 0x000fe20000000061ULL,
0x000000682420723cULL, 0x000fe20000041820ULL, 0x0000105471717816ULL, 0x000fc40000000052ULL,
0x000010542a297816ULL, 0x000fe40000000029ULL, 0x000010542b667816ULL, 0x000fe40000000066ULL,
0x0000105447677816ULL, 0x000fe20000000054ULL, 0x0000006e2414723cULL, 0x000fe20000041814ULL,
0x0000105465487816ULL, 0x000fe40000000048ULL, 0x0000105400497816ULL, 0x000fca0000000049ULL,
0x000000702410723cULL, 0x040ff00000041810ULL, 0x00000028240c723cULL, 0x040ff0000004180cULL,
0x000000662408723cULL, 0x040ff00000041808ULL, 0x000000482404723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200030247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c043437810ULL, 0x000fe20007ffe0ffULL, 0x00f698004dff7f8cULL, 0x0009e2000c80043fULL,
0x000000012f517812ULL, 0x000fe200078e0cffULL, 0x000000ffff617224ULL, 0x008fe200078e004bULL,
0x0000002c4300720cULL, 0x000fda0003f06070ULL, 0x0000240000000947ULL, 0x000fea0003800000ULL,
0x0000040060007984ULL, 0x010ee40000000800ULL, 0x8000000000ff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000240030007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000240000735dULL, 0x008fe40003800000ULL, 0x0000240030247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff387819ULL, 0x000fe2000001162dULL, 0x00000080ff477424ULL, 0x000fe200078e00ffULL,
0x0000030003257a10ULL, 0x000fe20007ffe0ffULL, 0x00000000580473c2ULL, 0x0004e200000e0000ULL,
0x00000003ff427819ULL, 0x000fe40000011639ULL, 0x0000000125277810ULL, 0x040fe20007ffe0ffULL,
0x0000000825007824ULL, 0x000fe200078e0238ULL, 0x0000000442467810ULL, 0x000fe40007ffe0ffULL,
0x000000022700720cULL, 0x000fe20003f06070ULL, 0x0000002000007824ULL, 0x000fe200078e00ffULL,
0x0000000c42487810ULL, 0x000fc40007ffe0ffULL, 0x000000084e4e7812ULL, 0x000fe200078ec0ffULL,
0x00006200372b7a24ULL, 0x000fe200078e0200ULL, 0x000000002c297217ULL, 0x000fc60007800000ULL,
0x000000014f4f7824ULL, 0x000fe200078e024eULL, 0x000000422b247210ULL, 0x000fe20007ffe036ULL,
0x0000000129297824ULL, 0x000fe200078e0a00ULL, 0x000000462b267210ULL, 0x000fe40007ffe036ULL,
0x0000000842007810ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x000fe200078e0047ULL,
0x0000002029437807ULL, 0x000fc60000000000ULL, 0x00005e0026267625ULL, 0x000fe200078e0047ULL,
0x0000004336437217ULL, 0x000fe40007800000ULL, 0x0000003c24287210ULL, 0x080fe40007f5e0ffULL,
0x0000003c262a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000143437824ULL, 0x100fe200078e0a36ULL,
0x000000002b247210ULL, 0x140fe20007ffe036ULL, 0x000000ffff297224ULL, 0x000fe200010e0625ULL,
0x000000482b267210ULL, 0x000fe20007ffe036ULL, 0x000000ffff2b7224ULL, 0x000fe200000e0627ULL,
0x000000434200720cULL, 0x000fe20003f06070ULL, 0x00005e0024247625ULL, 0x000fe200078e0047ULL,
0x000000434600720cULL, 0x000fc40003f46070ULL, 0x000000430000720cULL, 0x000fe20003f66070ULL,
0x00005e0026267625ULL, 0x000fe200078e0047ULL, 0x000000434800720cULL, 0x000fe40003f86070ULL,
0x0000003c24247210ULL, 0x080fe40007fbe0ffULL, 0x0000003c26267210ULL, 0x000fc60007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028597faeULL, 0x0009e2000c101c46ULL, 0x000000ffff277224ULL, 0x000fc600030e0627ULL,
0x000000002a5a7faeULL, 0x0009e8000d101c46ULL, 0x00000000245b7faeULL, 0x0009e8000d901c46ULL,
0x00000000265c7faeULL, 0x0009e8000e101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x008fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000004f247f8cULL, 0x0104e8000c80043fULL,
0x000004005d5d7984ULL, 0x000f220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f668003b267f8cULL, 0x000fe2000c80043fULL,
0x800000005dff7812ULL, 0x010fc6000784484bULL, 0x00f66c003b297984ULL, 0x000f240000000800ULL,
0x8000000029ff7812ULL, 0x010fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x000000ffff617224ULL, 0x008fe200078e0025ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe20003800000ULL, 0x00f66c003b257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x008fc40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001803c3d7810ULL, 0x000fca0007ffe03dULL, 0x000000013e3d7824ULL, 0x000fca00078e023dULL,
0x00f000003d277984ULL, 0x000ee80000000800ULL, 0x00f200003d007984ULL, 0x0008620000000800ULL,
0x000000322700720bULL, 0x008fe20003f1d000ULL, 0x0000b1227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x010fc800000e0100ULL, 0x0000ffff242a7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff267424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x000000032d247811ULL, 0x000fe400078ff0ffULL,
0x000000322700720bULL, 0x000fe40003f14000ULL, 0x0000002d2400720cULL, 0x000fe20003f65270ULL,
0x0000b0e27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000247806ULL, 0x000fe400000e0100ULL,
0x0000002732287209ULL, 0x000fe20007810000ULL, 0x000000802d29b824ULL, 0x000fe200078e023cULL,
0x00000002ff527819ULL, 0x000fc60000011639ULL, 0x000000013e3bb824ULL, 0x000fe200078e0229ULL,
0x8000002832257221ULL, 0x000fe20000010000ULL, 0x0000ffff24297812ULL, 0x000fc600078e3cffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00f400283b00b388ULL, 0x0007e20000000800ULL,
0x000000292aff7212ULL, 0x000fe4000780c0ffULL, 0x00000025002b7308ULL, 0x000f240000000800ULL,
0x0000002b31317220ULL, 0x010fe20000410000ULL, 0x0000b0627f007947ULL, 0x000fec000b800000ULL,
0x00001f522b247589ULL, 0x00872400000e0000ULL, 0x0000002420207220ULL, 0x090fe20000410000ULL,
0x0000002421217220ULL, 0x080fe20000410000ULL, 0x000000241c1c7220ULL, 0x080fe20000410000ULL,
0x000000241d1d7220ULL, 0x080fe20000410000ULL, 0x0000002418187220ULL, 0x080fe20000410000ULL,
0x0000002419197220ULL, 0x080fe20000410000ULL, 0x0000002414147220ULL, 0x080fe20000410000ULL,
0x0000002415157220ULL, 0x080fe20000410000ULL, 0x0000002410107220ULL, 0x080fe20000410000ULL,
0x0000002411117220ULL, 0x080fe20000410000ULL, 0x000000240c0c7220ULL, 0x080fe20000410000ULL,
0x000000240d0d7220ULL, 0x080fe20000410000ULL, 0x0000002408087220ULL, 0x080fe20000410000ULL,
0x0000002409097220ULL, 0x080fe20000410000ULL, 0x0000002404047220ULL, 0x080fe20000410000ULL,
0x0000002405057220ULL, 0x000fe20000410000ULL, 0x0000afa27f007947ULL, 0x000fea000b800000ULL,
0x00001f402b247589ULL, 0x0008a400000e0000ULL, 0x8000002827270221ULL, 0x100fe20000010000ULL,
0x00000001ff267807ULL, 0x000fe20000000000ULL, 0x0000002422227220ULL, 0x084fe20000410000ULL,
0x0000002423237220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b27270820ULL, 0x000fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x000000241a1a7220ULL, 0x080fe20000410000ULL, 0x00000027002e0308ULL, 0x000ea20000000800ULL,
0x000000241b1b7220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x000fe20000410000ULL, 0x000000ffff327224ULL, 0x000fe200078e0028ULL,
0x000000002e000220ULL, 0x006fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0000003100317221ULL, 0x002fe20000010000ULL,
0x0000010000002947ULL, 0x000fea0003800000ULL, 0x000000082f007824ULL, 0x000fe200078e00ffULL,
0xfffffff035257812ULL, 0x000fc800078ec0ffULL, 0x0000000800007812ULL, 0x000fca00078e0cffULL,
0x0000000100247824ULL, 0x000fca00078e0225ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x000364000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x020fe40003800000ULL, 0x00f6ac0024257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc4000780484bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002ff527819ULL, 0x008fe40000011639ULL, 0x0000002eff00723eULL, 0x000fe400000010ffULL,
0x0000001852277810ULL, 0x040fe40007ffe0ffULL, 0x0000001052287810ULL, 0x000fe40007ffe0ffULL,
0x00005410002b7816ULL, 0x010fe20000000000ULL, 0x0000acf27f007947ULL, 0x000fea000b800000ULL,
0x00001f522b297589ULL, 0x0002e400000e0000ULL, 0x0000ad327f007947ULL, 0x000fea000b800000ULL,
0x00001f402b007589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff527224ULL, 0x002fe200078e0028ULL, 0x00008ed000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff537424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000b33000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff527224ULL, 0x002fe200078e0027ULL, 0x00008f3000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff537424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000b2d000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004450783bULL, 0x002e620000004200ULL, 0x0000991026247816ULL, 0x000fc600000000ffULL,
0x000000005e3c783bULL, 0x000f620000004200ULL, 0x000000ff2400720cULL, 0x000fc60003f05270ULL,
0x000000004548783bULL, 0x000f280000004200ULL, 0x000000005f24783bULL, 0x000ee20000004200ULL,
0x00000010ff407819ULL, 0x012fe40000011650ULL, 0x000000ff502a7812ULL, 0x004fe400078ec0ffULL,
0x000000ff40407812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x020fc4000001163dULL,
0x000000ff3d567812ULL, 0x040fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe4000001163dULL,
0x0000ffff3d847812ULL, 0x000fe400078ec0ffULL, 0x0000002aff3d723eULL, 0x000fe400020006ffULL,
0x00000018ff437819ULL, 0x000fe40000011651ULL, 0x00000010ff6d7819ULL, 0x000fe20000011648ULL,
0x2000003dff637230ULL, 0x000fe20000004100ULL, 0x000000ff484e7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011648ULL, 0x0000ffff487f7812ULL, 0x000fe400078ec0ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000010ff667819ULL, 0x100fe40000011652ULL,
0x000000ff52457812ULL, 0x000fe400078ec0ffULL, 0x00000018ff447819ULL, 0x000fc40000011652ULL,
0x0000ffff527d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6e7819ULL, 0x100fe40000011649ULL,
0x000000ff494f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011649ULL,
0x0000ffff49807812ULL, 0x000fe400078ec0ffULL, 0x0000ffff507b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff427819ULL, 0x000fe40000011651ULL, 0x00000010ff727819ULL, 0x100fe4000001164aULL,
0x000000ff4a527812ULL, 0x040fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x0000ffff4a817812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4a7819ULL, 0x000fc4000001164bULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000064ff3d723eULL, 0x000fe200020006ffULL,
0x20000040ff647230ULL, 0x000fe20000004100ULL, 0x0000ffff517c7812ULL, 0x000fe200078ec0ffULL,
0x20000043ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe20000011653ULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe400020006ffULL,
0x000000ff42427812ULL, 0x000fc400078ec0ffULL, 0x00000008ff407819ULL, 0x000fe2000001167bULL,
0x20000052ff557230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x000000ff3e6a7812ULL, 0x000fe200078ec0ffULL,
0x20000048ff597230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fe2000001163fULL,
0x2000004aff527230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x00000008ff437819ULL, 0x000fe4000001167cULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff67677812ULL, 0x000fe400078ec0ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000018ff287819ULL, 0x000fe40000011650ULL, 0x0000ffff537e7812ULL, 0x000fc400078ec0ffULL,
0x000000ff512b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff467819ULL, 0x000fe40000011653ULL,
0x0000006aff4a723eULL, 0x000fe400020006ffULL, 0x0000006bff48723eULL, 0x000fe400020006ffULL,
0x00000018ff687819ULL, 0x100fe2000001163eULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000043ff43723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000066ff6a723eULL, 0x000fe200020006ffULL, 0x20000040ff667230ULL, 0x000fe20000004100ULL,
0x00000067ff6b723eULL, 0x000fe200020006ffULL, 0x20000042ff677230ULL, 0x000fe20000004100ULL,
0x00000028ff62723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fc4000001163eULL, 0x0000ffff3e5e7812ULL, 0x000fe200078ec0ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x108fe40000011625ULL,
0x000000ff25717812ULL, 0x040fe400078ec0ffULL, 0x00000018ff707819ULL, 0x000fe40000011625ULL,
0x0000ffff25287812ULL, 0x000fe400078ec0ffULL, 0x00000008ff407819ULL, 0x000fc4000001167dULL,
0x00000008ff427819ULL, 0x000fe4000001167eULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x0000002bff3e723eULL, 0x000fe400020006ffULL, 0x00000046ff25723eULL, 0x000fe400020006ffULL,
0x00000068ff46723eULL, 0x000fe200020006ffULL, 0x20000043ff687230ULL, 0x000fe20000004100ULL,
0x000000ff3f6c7812ULL, 0x040fe200078ec0ffULL, 0x2000003eff657230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fe2000001163fULL, 0x20000025ff257230ULL, 0x000fe20000004100ULL,
0x0000ffff3f5c7812ULL, 0x000fe200078ec0ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000000ff6e6e7812ULL, 0x000fc400078ec0ffULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000006dff43723eULL, 0x000fe400020006ffULL,
0x00000010ff5d7819ULL, 0x100fe20000011624ULL, 0x20000042ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff246f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3f7819ULL, 0x000fc40000011624ULL,
0x0000ffff24507812ULL, 0x000fe400078ec0ffULL, 0x00000044ff24723eULL, 0x000fe400020006ffULL,
0x0000006cff3e723eULL, 0x000fe200020006ffULL, 0x2000006bff6c7230ULL, 0x000fe20000004100ULL,
0x00000070ff44723eULL, 0x000fe200020006ffULL, 0x20000040ff6b7230ULL, 0x000fe20000004100ULL,
0x0000006eff70723eULL, 0x000fe200020006ffULL, 0x20000043ff6e7230ULL, 0x000fe20000004100ULL,
0x0000004eff4e723eULL, 0x000fe200020006ffULL, 0x00a800004140783bULL, 0x000e620000000200ULL,
0x00000018ff787819ULL, 0x000fe20000011627ULL, 0x20000024ff247230ULL, 0x000fe20000004100ULL,
0x0000ffff3c837812ULL, 0x000fe200078ec0ffULL, 0x2000004eff5a7230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff27797812ULL, 0x000fe200078ec0ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000078ff4e723eULL, 0x000fe200020006ffULL, 0x2000004cff587230ULL, 0x000fe20000004100ULL,
0x000000ff77787812ULL, 0x000fe200078ec0ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x00000008ff777819ULL, 0x000fe20000011683ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000079ff4c723eULL, 0x000fc400020006ffULL, 0x00000008ff797819ULL, 0x000fe40000011684ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x000000ff7a7b7812ULL, 0x000fe400078ec0ffULL,
0x00000079ff7a723eULL, 0x000fe200020006ffULL, 0x20000078ff797230ULL, 0x000fe20000004100ULL,
0x000000ff53477812ULL, 0x000fe200078ec0ffULL, 0x20000077ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x000fe2000001164bULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff4b537812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4b827812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f777812ULL, 0x000fe400078ec0ffULL, 0x00000010ff767819ULL, 0x100fe4000001163cULL,
0x000000ff3c547812ULL, 0x000fe200078ec0ffULL, 0x0000002940408231ULL, 0x082fe200003400ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001163cULL, 0x0000002942428231ULL, 0x000fe200003400ffULL,
0x00000008ff5f7819ULL, 0x000fe2000001165eULL, 0x0000000041418231ULL, 0x080fe200003400ffULL,
0x00000010ff2b7819ULL, 0x000fe20000011627ULL, 0x0000000043438231ULL, 0x000fe200003400ffULL,
0x0000ffff273c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff5e7819ULL, 0x000fe40000011667ULL, 0x00000010ff2a7819ULL, 0x100fe40000011626ULL,
0x000000ff26757812ULL, 0x040fe400078ec0ffULL, 0x00000018ff747819ULL, 0x000fe40000011626ULL,
0x0000ffff263b7812ULL, 0x000fc400078ec0ffULL, 0x00000047ff27723eULL, 0x000fe400020006ffULL,
0x00000045ff26723eULL, 0x000fe400020006ffULL, 0x000010545e657816ULL, 0x000fe20000000065ULL,
0x20000027ff277230ULL, 0x000fe20000004100ULL, 0x00000010ff5e7819ULL, 0x000fe20000011669ULL,
0x20000026ff267230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe40000011668ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x000010545e677816ULL, 0x000fe40000000067ULL, 0x00000008ff5e7819ULL, 0x000fe4000001165cULL,
0x0000105464647816ULL, 0x000fe40000000063ULL, 0x00000010ff5c7819ULL, 0x000fe40000011627ULL,
0x000000ff5d637812ULL, 0x000fc400078ec0ffULL, 0x00000010ff267819ULL, 0x000fe20000011626ULL,
0x000000644020723cULL, 0x000fe20000041820ULL, 0x00000010ff277819ULL, 0x000fe4000001166aULL,
0x00000010ff5d7819ULL, 0x000fe4000001166cULL, 0x00000077ff7c723eULL, 0x000fe400020006ffULL,
0x0000105427267816ULL, 0x000fe40000000026ULL, 0x0000005fff77723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x000010545d277816ULL, 0x000fc4000000005cULL,
0x00000010ff5f7819ULL, 0x000fe20000011662ULL, 0x20000077ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff247819ULL, 0x000fe20000011624ULL,
0x000000264018723cULL, 0x000fe20000041818ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x000010545f667816ULL, 0x000fe40000000066ULL, 0x0000005eff5f723eULL, 0x000fc400020006ffULL,
0x00000010ff5e7819ULL, 0x000fe40000011625ULL, 0x00001054245c7816ULL, 0x000fe2000000006bULL,
0x00000066401c723cULL, 0x000fe2000004181cULL, 0x00a800003a24783bULL, 0x000e620000000200ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x0000003fff45723eULL, 0x000fe200020006ffULL,
0x20000071ff3f7230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x2000004fff5b7230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fe20000011680ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000053ff577230ULL, 0x000fe20000004100ULL, 0x00000074ff4f723eULL, 0x000fc400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x000000ff73747812ULL, 0x000fe200078ec0ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000054ff53723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000008ff737819ULL, 0x000fe40000011681ULL,
0x00000056ff54723eULL, 0x000fe200020006ffULL, 0x20000049ff567230ULL, 0x000fe20000004100ULL,
0x0000004bff49723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fe2000001166dULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x0000006fff47723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000075ff4b723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000008ff6f7819ULL, 0x000fe2000001167fULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff72727812ULL, 0x000fe200078ec0ffULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fe20000011682ULL,
0x0000000025258231ULL, 0x082fe200003400ffULL, 0x000010545e5d7816ULL, 0x000fe2000000005dULL,
0x0000000027278231ULL, 0x000fe200003400ffULL, 0x000000ff515e7812ULL, 0x000fe200078ec0ffULL,
0x0000002924248231ULL, 0x080fe200003400ffULL, 0x00000008ff507819ULL, 0x000fe20000011650ULL,
0x0000002926268231ULL, 0x000fe200003400ffULL, 0x00000010ff3a7819ULL, 0x000fe20000011659ULL,
0x0000005c4014723cULL, 0x000fe20000041814ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe2000001165aULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fe2000001166eULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fc40000011671ULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00001054515a7816ULL, 0x000fe4000000005aULL,
0x000010543a597816ULL, 0x000fe20000000059ULL, 0x20000050ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe40000011656ULL, 0x00000010ff3a7819ULL, 0x000fe40000011673ULL,
0x00000010ff5b7819ULL, 0x000fc4000001165bULL, 0x0000105451507816ULL, 0x000fe4000000003aULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff577819ULL, 0x000fc40000011657ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff517819ULL, 0x000fe40000011675ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00001054705b7816ULL, 0x000fc4000000005bULL, 0x0000105458587816ULL, 0x000fe2000000006fULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x0000105472727816ULL, 0x000fe40000000055ULL,
0x0000105474737816ULL, 0x000fe20000000057ULL, 0x0000005a4010723cULL, 0x000fe20000041810ULL,
0x0000105452517816ULL, 0x000fe40000000051ULL, 0x00000008ff287819ULL, 0x000fe40000011628ULL,
0x00000010ff777819ULL, 0x000fc40000011679ULL, 0x00000010ff007819ULL, 0x000fe2000001163dULL,
0x00000058400c723cULL, 0x040fe2000004180cULL, 0x00000010ff797819ULL, 0x000fe4000001167aULL,
0x00000028ff28723eULL, 0x000fe400020006ffULL, 0x000000ff76767812ULL, 0x000fe400078ec0ffULL,
0x000000ff2a2a7812ULL, 0x000fe200078ec0ffULL, 0x000000724008723cULL, 0x000fe20000041808ULL,
0x000000ff2b3a7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff3b7819ULL, 0x000fe4000001163bULL,
0x00000008ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff4a7819ULL, 0x000fe2000001164aULL,
0x000000504004723cULL, 0x000fe20000041804ULL, 0x00000010ff297819ULL, 0x000fe4000001163eULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x0000105400797816ULL, 0x000fe20000000079ULL, 0x20000028ff007230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x0000002aff2a723eULL, 0x000fe200020006ffULL, 0x20000063ff647230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000003bff3b723eULL, 0x000fe200020006ffULL, 0x2000002aff2a7230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x000010547b287816ULL, 0x000fe2000000004aULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x000010547c297816ULL, 0x000fe20000000029ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff2b7819ULL, 0x000fc40000011646ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff5d7819ULL, 0x000fe20000011644ULL, 0x000000282418723cULL, 0x000fe20000041818ULL,
0x00000010ff007819ULL, 0x000fe40000011600ULL, 0x000010542b627816ULL, 0x000fe40000000062ULL,
0x000010545d5d7816ULL, 0x000fe40000000000ULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x00000010ff4b7819ULL, 0x000fe4000001164bULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff2b7819ULL, 0x000fe4000001164cULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff007819ULL, 0x000fe4000001164fULL, 0x00000010ff3b7819ULL, 0x000fc4000001163bULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff297819ULL, 0x000fe4000001163cULL,
0x0000105476767816ULL, 0x000fe40000000053ULL, 0x0000105477777816ULL, 0x000fe40000000054ULL,
0x0000105449787816ULL, 0x000fe40000000078ULL, 0x0000105448637816ULL, 0x000fc4000000005fULL,
0x0000105464647816ULL, 0x000fe20000000047ULL, 0x000000762420723cULL, 0x040fe20000041820ULL,
0x000010545e657816ULL, 0x000fe4000000003fULL, 0x00001054455c7816ULL, 0x000fe4000000005cULL,
0x000010542a2a7816ULL, 0x000fe4000000004bULL, 0x000010543a2b7816ULL, 0x000fe2000000002bULL,
0x00000078241c723cULL, 0x000fe2000004181cULL, 0x0000105400287816ULL, 0x000fc4000000003bULL,
0x000010544e297816ULL, 0x000fca0000000029ULL, 0x000000622414723cULL, 0x040ff00000041814ULL,
0x000000642410723cULL, 0x040ff00000041810ULL, 0x0000005c240c723cULL, 0x040ff0000004180cULL,
0x0000002a2408723cULL, 0x040ff00000041808ULL, 0x000000282404723cULL, 0x000fe20000041804ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000200030247f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a0004dff7f8cULL, 0x0007e2000c80043fULL, 0x000000012f517812ULL, 0x000fc600078ec0ffULL,
0x0000030003037a10ULL, 0x018fc80007ffe0ffULL, 0x000000020300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff66d000007947ULL, 0x000fea000383ffffULL,
0x00000000000479c3ULL, 0x004ea20000002500ULL, 0x000000ffff2f7224ULL, 0x000fe400078e000eULL,
0x000000ffff0e7224ULL, 0x000fe400078e0017ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0007ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0006ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0005ULL,
0x000000ffff397224ULL, 0x000fc400078e0004ULL, 0x000000ffff2a7224ULL, 0x000fe400078e000bULL,
0x000000ffff377224ULL, 0x000fe400078e000aULL, 0x000000ffff287224ULL, 0x000fe400078e0009ULL,
0x000000ffff357224ULL, 0x000fe400078e0008ULL, 0x000000ffff267224ULL, 0x008fe400078e000fULL,
0x000000ffff247224ULL, 0x002fe200078e000dULL, 0x0000000402007c0cULL, 0x004fe2000bf03070ULL,
0x000000ffff2b7224ULL, 0x000fc400078e000cULL, 0x000000ffff297224ULL, 0x000fe400078e0013ULL,
0x000000ffff277224ULL, 0x000fe400078e0011ULL, 0x000000ffff257224ULL, 0x000fe400078e0016ULL,
0x000000ffff177224ULL, 0x000fc800078e0015ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000031007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000a81000067802ULL, 0x000fe40000000f00ULL,
0x0000984000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003100007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000031ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000077919ULL, 0x000f220000000000ULL, 0x00000002ff067819ULL, 0x008fe40000011604ULL,
0x0000000807047811ULL, 0x010fe200078ff0ffULL, 0x0000000003057220ULL, 0x004fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000002000207220ULL, 0x044fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001700177220ULL, 0x040fe20000410000ULL,
0x0000001000107220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002b002b7220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x000fe20000410000ULL,
0x0000002204227220ULL, 0x048fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x000fe20000410000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000203007812ULL, 0x004fc400078ec0ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x0000000200047811ULL, 0x040fe400078ff8ffULL, 0x0000000400067811ULL, 0x000fe400078ff8ffULL,
0x0000000803157811ULL, 0x000fe400078ff0ffULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000704057812ULL, 0x000fc400078e780dULL, 0x0000000706087812ULL, 0x040fe400078e780dULL,
0x0000000706067812ULL, 0x000fe200078e7815ULL, 0x000000080d097824ULL, 0x000fe200078e0205ULL,
0x00000006000a7811ULL, 0x000fe200078ff8ffULL, 0x0000100033057824ULL, 0x000fe200078e00ffULL,
0x0000000702007812ULL, 0x100fe200078e780dULL, 0x0000000815137824ULL, 0x000fe200078e0206ULL,
0x000000070a0c7812ULL, 0x000fe200078e780dULL, 0x0000000803067824ULL, 0x000fe200078e00ffULL,
0x0000000702027812ULL, 0x100fe200078e7815ULL, 0x000000080d077824ULL, 0x040fe200078e0200ULL,
0x0000000704047812ULL, 0x000fe200078e7815ULL, 0x0000080038007824ULL, 0x000fe200078e0205ULL,
0x000000070a0a7812ULL, 0x000fe200078e7815ULL, 0x000000080d0b7824ULL, 0x000fe200078e0208ULL,
0x0000000806067812ULL, 0x000fe200078ec0ffULL, 0x00000008150f7824ULL, 0x000fe200078e0202ULL,
0x000000202102723eULL, 0x000fe200000010ffULL, 0x0000000815117824ULL, 0x000fe200078e0204ULL,
0x0000001c1d04723eULL, 0x000fe200000010ffULL, 0x000000080d0d7824ULL, 0x000fc400078e020cULL,
0x0000000815157824ULL, 0x000fe200078e020aULL, 0x0000541002167816ULL, 0x000fe20000000004ULL,
0x0000001007077824ULL, 0x100fe400078e0200ULL, 0x0000001009097824ULL, 0x100fe400078e0200ULL,
0x000000100b0b7824ULL, 0x100fe400078e0200ULL, 0x000000100f0f7824ULL, 0x100fe400078e0200ULL,
0x0000001011117824ULL, 0x000fc400078e0200ULL, 0x000000100d0d7824ULL, 0x100fe400078e0200ULL,
0x0000001013137824ULL, 0x100fe400078e0200ULL, 0x0000001015157824ULL, 0x000fe400078e0200ULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x000000141707723eULL, 0x000fe200000010ffULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0x0000763202177816ULL, 0x000fe20000000004ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x000000102702723eULL, 0x000fe200000010ffULL,
0x00000001060f7824ULL, 0x000fe200078e020fULL, 0x0000002b2404723eULL, 0x000fe200000010ffULL,
0x0000000106117824ULL, 0x040fe200078e0211ULL, 0x0000001608007388ULL, 0x0005e20000000a00ULL,
0x00000001060d7824ULL, 0x000fc400078e020dULL, 0x0000000106137824ULL, 0x040fe400078e0213ULL,
0x0000000106157824ULL, 0x000fe200078e0215ULL, 0x000000181906723eULL, 0x000fe200000010ffULL,
0x00000020380a7824ULL, 0x000fc600078e0203ULL, 0x0000541006167816ULL, 0x144fe40000000007ULL,
0x0000763206177816ULL, 0x000fe40000000007ULL, 0x0000541002087816ULL, 0x100fe40000000004ULL,
0x000000352806723eULL, 0x000fe200000010ffULL, 0x0000001609007388ULL, 0x0005e20000000a00ULL,
0x000000392c07723eULL, 0x000fe400000010ffULL, 0x0000763202097816ULL, 0x004fc40000000004ULL,
0x000000222302723eULL, 0x000fe400000010ffULL, 0x0000001e1f04723eULL, 0x000fe200000010ffULL,
0x000000080b007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x004fe20000000007ULL,
0x000000100a0b7824ULL, 0x000fe200078e0205ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x0000001a1b06723eULL, 0x000fe400000010ffULL, 0x000000250e07723eULL, 0x000fe200000010ffULL,
0x000000080d007388ULL, 0x0005e40000000a00ULL, 0x0000541002087816ULL, 0x004fc40000000004ULL,
0x0000763202097816ULL, 0x000fe40000000004ULL, 0x000000122902723eULL, 0x000fe400000010ffULL,
0x0000002f2604723eULL, 0x000fe200000010ffULL, 0x000000080f007388ULL, 0x0005e40000000a00ULL,
0x0000541006087816ULL, 0x144fe40000000007ULL, 0x0000763206097816ULL, 0x000fe40000000007ULL,
0x000000372a06723eULL, 0x000fc400000010ffULL, 0x0000003b2e07723eULL, 0x000fe200000010ffULL,
0x0000000811007388ULL, 0x0005e40000000a00ULL, 0x0000541002087816ULL, 0x144fe40000000004ULL,
0x0000763202097816ULL, 0x000fe40000000004ULL, 0x000000ff00027306ULL, 0x000fe60000205400ULL,
0x0000000813007388ULL, 0x0005e40000000a00ULL, 0x0000541006087816ULL, 0x004fc40000000007ULL,
0x0000763206097816ULL, 0x000fe40000000007ULL, 0x000000ff00077306ULL, 0x000ea60000209400ULL,
0x0000000815007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000020700720bULL, 0x004fc40003f1d000ULL, 0x000000ff00027245ULL, 0x000fd6000020d400ULL,
0x0000000102020812ULL, 0x000fe200078efcffULL, 0x000400000b1c7984ULL, 0x000ea60000000c00ULL,
0x000000020206723eULL, 0x000fe200000010ffULL, 0x000c00000b107984ULL, 0x000ee80000000c00ULL,
0x000000000b0c7984ULL, 0x000f280000000c00ULL, 0x000800000b187984ULL, 0x000f620000000c00ULL,
0x3f803f80061d7831ULL, 0x004fc4000020001dULL, 0x3f803f80061f7831ULL, 0x040fe4000020001fULL,
0x3f803f801d1d7831ULL, 0x008fe20000200011ULL, 0x00000300ff117624ULL, 0x000fe200078e00ffULL,
0x3f803f80061e7831ULL, 0x040fe4000020001eULL, 0x3f803f80060f7831ULL, 0x050fe4000020000fULL,
0x000000011100780cULL, 0x000fe20003f05270ULL, 0x3f803f80060e7831ULL, 0x040fe4000020000eULL,
0x3f803f80060d7831ULL, 0x000fc4000020000dULL, 0x3f803f80060c7831ULL, 0x040fe4000020000cULL,
0x3f803f80061c7831ULL, 0x000fe4000020001cULL, 0x3f803f800f0f7831ULL, 0x020fe4000020001bULL,
0x3f803f800e0e7831ULL, 0x000fe4000020001aULL, 0x3f803f800d0d7831ULL, 0x000fe40000200019ULL,
0x3f803f800c0c7831ULL, 0x000fc40000200018ULL, 0x3f803f801f1f7831ULL, 0x000fe40000200013ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200012ULL, 0x0000000c0b007388ULL, 0x0005e20000000c00ULL,
0x3f803f801c1c7831ULL, 0x000fca0000200010ULL, 0x0004001c0b007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f4000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ee20000002700ULL, 0x0000580011047a24ULL, 0x000fe200078e02ffULL,
0x0000000138ff7812ULL, 0x000fe2000780f82dULL, 0x00000800ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ee20000002600ULL, 0x00006400040c7a24ULL, 0x004fe200078e02ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x0000040033067824ULL, 0x000fe200078e00ffULL,
0x000000000b147984ULL, 0x0005220000000c00ULL, 0x000000ff0300720cULL, 0x000fc40000725670ULL,
0x000007ff0c047811ULL, 0x000fe200078e40ffULL, 0x0000580010107a24ULL, 0x008fc800078e0207ULL,
0x0000030010077a24ULL, 0x000fca00078e02ffULL, 0x00000004070d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000000d04087211ULL, 0x000fca00078fa8ffULL, 0x00006a0008087625ULL, 0x000fca00078e0009ULL,
0x00000006080e7210ULL, 0x000fe40007f5e0ffULL, 0x01ffffff0c087812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fc800010e0609ULL, 0x000000100a0e7825ULL, 0x000fe200078e000eULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x014fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x000000010d0c7824ULL, 0x000fe200078e0208ULL, 0x000000700a137812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b127812ULL, 0x000fe200078ec0ffULL, 0x00006a000d0a7625ULL, 0x000fc800078e0009ULL,
0x00006a000c0c7625ULL, 0x000fe200078e0009ULL, 0x0000000a120a7210ULL, 0x000fc80007a1e013ULL,
0x0000000c120c7210ULL, 0x000fe40007c7e013ULL, 0x0000000bff0b7210ULL, 0x000fe400007e44ffULL,
0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL, 0x000000320a007986ULL, 0x0005e8000c101906ULL,
0x000000310c007986ULL, 0x0005e4000c101906ULL, 0x0000000000007941ULL, 0x014fea0003800000ULL,
0x000000140e007986ULL, 0x0005e2000c101d06ULL, 0x0000011000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff11097810ULL, 0x000fc60007ffe0ffULL,
0x00006800100a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x000000090a0a79a8ULL, 0x000ee400099ee1c6ULL,
0x000000090a00720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000000000ULL, 0x0000000cff007388ULL, 0x0007e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff097984ULL, 0x000f240000000000ULL, 0x000000ff0900720cULL, 0x010fda0003f05270ULL,
0x00002b9000008947ULL, 0x000fea0003800000ULL, 0x000000ff2d00720cULL, 0x000fda0003f05270ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011603ULL,
0x0000001003097824ULL, 0x000fe200078e00ffULL, 0x00000001070c7810ULL, 0x008fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x004fe200078e00ffULL, 0x0000000c0a157812ULL, 0x000fe400078ec0ffULL,
0x0000007009137812ULL, 0x000fe200078ec0ffULL, 0x00006a00070a7625ULL, 0x000fc800078e000fULL,
0x00006a000c0c7625ULL, 0x000fe200078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000c150c7210ULL, 0x000fe40007b5e013ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a097981ULL, 0x000568000c1e1900ULL,
0x000000060c0e7981ULL, 0x000562000c1e1900ULL, 0x000000021100780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002070a7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a107981ULL, 0x000562000c1e1900ULL,
0x000000041100780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003070a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a127981ULL, 0x000562000c1e1900ULL, 0x000000041100780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004070a7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a147981ULL, 0x000562000c1e1900ULL,
0x000000061100780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005070a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a167981ULL, 0x000562000c1e1900ULL, 0x000000061100780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081100780cULL, 0x004fe40003f06070ULL,
0x00000006070a7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a150a7210ULL, 0x000fe40007a3e013ULL, 0x00000007070c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006a000c0c0625ULL, 0x000fe400078e000fULL,
0x000000060a187981ULL, 0x000566000c1e1900ULL, 0x0000000c150c0210ULL, 0x000fc80007c7e013ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c0c0981ULL, 0x000568000c1e1900ULL,
0x00000007110a7810ULL, 0x004fc80007ffe0ffULL, 0x00000003ff0d7819ULL, 0x000fc8000001160aULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1c7224ULL, 0x020fe400078e0009ULL,
0x000000081a0f7824ULL, 0x040fe200078e00ffULL, 0x000000011a1a7810ULL, 0x000fc80007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000000d1a00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x024fea0003800000ULL, 0x000000080f0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000010f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001c09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1c7981ULL, 0x000568000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090f0a7810ULL, 0x044fe40007ffe0ffULL, 0x000000020f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000e09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0e7981ULL, 0x000568000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0f0a7810ULL, 0x044fe40007ffe0ffULL,
0x000000030f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001009097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003107824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a107981ULL, 0x000568000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0f0a7810ULL, 0x044fe40007ffe0ffULL, 0x000000040f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001209097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a127981ULL, 0x000568000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0f0a7810ULL, 0x044fe40007ffe0ffULL,
0x000000050f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001409097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a147981ULL, 0x000568000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0f0a7810ULL, 0x044fe40007ffe0ffULL, 0x000000060f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001609097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001003117824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a167981ULL, 0x000568000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0f0a7810ULL, 0x044fe40007ffe0ffULL,
0x000000070f0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001809097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x00000001ff137819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a187981ULL, 0x000568000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0f0a7810ULL, 0x004fe40007ffe0ffULL, 0x0000000c09097209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030c7824ULL, 0x008fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007a3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0c7981ULL, 0x000568000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x00000010030a7824ULL, 0x014fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc80000011603ULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL,
0x000000010b0a7824ULL, 0x000fca00078e020aULL, 0x000000090a007388ULL, 0x0205e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000001003097824ULL, 0x004fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011603ULL, 0x0000000138137824ULL, 0x000fe200078e0207ULL,
0x00000002ff0d7819ULL, 0x000fe2000001162dULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x00000800ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000c0b0c7812ULL, 0x008fe200078ec0ffULL, 0x000002002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000013040a7211ULL, 0x000fe200078fa8ffULL, 0x0000000134347824ULL, 0x000fe200078e0205ULL,
0x000010d000007945ULL, 0x000fe20003800000ULL, 0x000000010c297824ULL, 0x000fe200078e0209ULL,
0x000000010d097812ULL, 0x000fe200078ec0ffULL, 0x00000002380c8824ULL, 0x140fe200078e0233ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000238108824ULL, 0x000fe200078e0233ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00006a000a0a7625ULL, 0x000fe200078e000fULL,
0x00000020030f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000020c0e8824ULL, 0x100fe200078e0209ULL,
0x000000060a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000210148824ULL, 0x000fe200078e0209ULL,
0x000008002d097812ULL, 0x000fe200078ec0ffULL, 0x0000000108108824ULL, 0x000fe200078e0213ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000029297984ULL, 0x000ea20000000800ULL, 0x00000080ff128424ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000001340c7824ULL, 0x000fe200078e0209ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000030038007a0cULL, 0x000fe20003f26070ULL, 0x00006a0010108625ULL, 0x000fc800078e0011ULL,
0x00006a0013128625ULL, 0x000fc800078e0012ULL, 0x000000080e178824ULL, 0x100fe400078e0203ULL,
0x0000000814148824ULL, 0x000fe400078e0203ULL, 0x0000001003157824ULL, 0x000fe200078e020cULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x00000010030c7825ULL, 0x000fe200078e000aULL,
0x00004180141f8811ULL, 0x000fc600078e20ffULL, 0x000000100f0e7825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c157faeULL, 0x0007e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000001003108825ULL, 0x040fe200078e0010ULL,
0x003800000e157faeULL, 0x0009e6000b901c46ULL, 0x0000001003128825ULL, 0x000fe200078e0012ULL,
0x0000000010178faeULL, 0x000be6000b901c46ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00000000121f8faeULL, 0x0003e2000b901c46ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff287224ULL, 0x000fc400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x020fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x002fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000d5000001947ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x004fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fca00078e0038ULL,
0x0000000235367810ULL, 0x000fe20007ffe0ffULL, 0x0000029000017945ULL, 0x000fe60003800000ULL,
0x0000030036007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f24070ULL, 0x0000000107317824ULL, 0x100fe200078e0236ULL,
0x00000001ff2a7819ULL, 0x000fe20000011636ULL, 0x00000800ff307424ULL, 0x000fe200078e00ffULL,
0x00000020033b7810ULL, 0x000fe20007ffe0ffULL, 0x00000400362c7824ULL, 0x000fe200078e00ffULL,
0x00000031042b7211ULL, 0x000fe400078fa8ffULL, 0x000000012a2e7812ULL, 0x000fc600078ec0ffULL,
0x00006a002b2a7625ULL, 0x000fc800078e0030ULL, 0x00000002382f9824ULL, 0x000fe200078e0233ULL,
0x000000062a2a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001082d9824ULL, 0x000fe400078e0231ULL,
0x000000022f3a9824ULL, 0x100fe200078e022eULL, 0x000008002c2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000238379824ULL, 0x000fe400078e0233ULL, 0x00000080ff309424ULL, 0x000fe400078e00ffULL,
0x00000002373e9824ULL, 0x000fc400078e022eULL, 0x00006a002d2c9625ULL, 0x000fc800078e0030ULL,
0x00000080ff3c9424ULL, 0x000fe400078e00ffULL, 0x00000001342e7824ULL, 0x000fe400078e022fULL,
0x000000ffff2b7224ULL, 0x000fe400000e062bULL, 0x00006a0031309625ULL, 0x000fc800078e003cULL,
0x0000001003377824ULL, 0x040fe400078e022eULL, 0x000000083a399824ULL, 0x000fe400078e0203ULL,
0x00000010032e9825ULL, 0x000fc600078e002cULL, 0x0000458039399811ULL, 0x000fe200078e20ffULL,
0x000000083e3e9824ULL, 0x000fe400078e0203ULL, 0x000000103b2c7825ULL, 0x000fc600078e002aULL,
0x000041803e3b9811ULL, 0x000fe200078e20ffULL, 0x00000010032a7825ULL, 0x000fc800078e002aULL,
0x0000001003309825ULL, 0x000fe200078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002a377faeULL, 0x0003e8000b901c46ULL, 0x003800002c377faeULL, 0x0003e8000b901c46ULL,
0x000000002e399faeULL, 0x0003e8000b901c46ULL, 0x00000000303b9faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000040352a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff2c7819ULL, 0x000fe20000011603ULL,
0x00000002382d7824ULL, 0x000fe200078e0233ULL, 0x00000002ff547819ULL, 0x000fe20000011603ULL,
0x00000010032b7824ULL, 0x000fe200078e00ffULL, 0x000000802a2a7812ULL, 0x000fc400078ec0ffULL,
0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL, 0x00000008542f7824ULL, 0x040fe200078e00ffULL,
0x000000702b2b7812ULL, 0x000fe200078ec0ffULL, 0x000001002d2a7824ULL, 0x000fe200078e002aULL,
0x0000000754447812ULL, 0x040fe200078ec0ffULL, 0x00000008542d7824ULL, 0x040fe200078e00ffULL,
0x0000000854567810ULL, 0x000fe40007ffe0ffULL, 0x0000002a2c2c7210ULL, 0x000fe20007ffe02bULL,
0x00000008542b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2a7812ULL, 0x100fe200078ee244ULL,
0x00000008562d7824ULL, 0x040fe200078e00ffULL, 0x00000056ff507212ULL, 0x000fe200078e33ffULL,
0x0000000856467824ULL, 0x000fe200078e00ffULL, 0x000000012b2e7812ULL, 0x000fe200078ef644ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002c407984ULL, 0x000e620000000800ULL,
0x000000022b307812ULL, 0x140fe400078ef644ULL, 0x000000032b3a7812ULL, 0x140fe200078ef644ULL,
0x004580002c527984ULL, 0x0002a20000000800ULL, 0x000000042b3c7812ULL, 0x140fe400078ef644ULL,
0x000000052b3e7812ULL, 0x000fe400078ef644ULL, 0x00000054ff427212ULL, 0x000fe400078e33ffULL,
0xfffffff82d507812ULL, 0x000fc400078ee250ULL, 0xfffffff82f427812ULL, 0x000fe400078ee242ULL,
0x00000007562f7812ULL, 0x000fe200078ec0ffULL, 0x00000040292c7221ULL, 0x002fe20000010100ULL,
0x000000062b407812ULL, 0x000fe200078ef644ULL, 0x00000400352b7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b2c317820ULL, 0x000fe20000410000ULL, 0x00000004032c7824ULL, 0x000fe400078e00ffULL,
0x000008002b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000856447824ULL, 0x000fc400078e00ffULL,
0x0000000c2c2d7812ULL, 0x000fe200078ec0ffULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x00000180342b7810ULL, 0x000fe20007ffe02bULL, 0x000000ffff357224ULL, 0x000fe200078e0036ULL,
0xfffffff8462c7812ULL, 0x100fe400078ee22fULL, 0x0000000144467812ULL, 0x000fe200078ef62fULL,
0x000000102a2a7824ULL, 0x000fe200078e022bULL, 0x0000000244487812ULL, 0x000fe200078ef62fULL,
0x0000001042427824ULL, 0x000fe200078e022bULL, 0x00000003444a7812ULL, 0x000fe200078ef62fULL,
0x000000012a2a7824ULL, 0x000fe200078e022dULL, 0x00000004444c7812ULL, 0x140fe200078ef62fULL,
0x000000012d427824ULL, 0x040fe200078e0242ULL, 0x00000005444e7812ULL, 0x000fe200078ef62fULL,
0x000000102e2e7824ULL, 0x000fe200078e022bULL, 0x0000000644447812ULL, 0x000fe200078ef62fULL,
0x0000001030307824ULL, 0x100fe200078e022bULL, 0x000000002a2f7984ULL, 0x000e620000000800ULL,
0x000000012d2e7824ULL, 0x000fe200078e022eULL, 0x0000005231317220ULL, 0x004fe20000410000ULL,
0x000000012d307824ULL, 0x000fe200078e0230ULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x000000103a3a7824ULL, 0x100fe200078e022bULL, 0x0000030035007a0cULL, 0x000fe20003f06070ULL,
0x000000103c3c7824ULL, 0x100fe200078e022bULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x000000012d3a7824ULL, 0x000fe200078e023aULL, 0x0000003231327221ULL, 0x000fe20000010000ULL,
0x000000012d3c7824ULL, 0x000fe200078e023cULL, 0x0000000030307984ULL, 0x000fe20000000800ULL,
0x000000103e3e7824ULL, 0x000fc400078e022bULL, 0x0000001040407824ULL, 0x100fe200078e022bULL,
0x00001f54312a7589ULL, 0x000ea200000e0000ULL, 0x000000012d3e7824ULL, 0x000fe400078e023eULL,
0x000000102c2c7824ULL, 0x100fe200078e022bULL, 0x000000003a3a7984ULL, 0x000ee20000000800ULL,
0x0000001046467824ULL, 0x100fe400078e022bULL, 0x0000001048487824ULL, 0x100fe200078e022bULL,
0x000000003c3c7984ULL, 0x000f220000000800ULL, 0x000000104a4a7824ULL, 0x000fc400078e022bULL,
0x000000104c4c7824ULL, 0x100fe200078e022bULL, 0x000000003e3e7984ULL, 0x000f620000000800ULL,
0x000000104e4e7824ULL, 0x100fe400078e022bULL, 0x0000001044447824ULL, 0x100fe400078e022bULL,
0x0000001050507824ULL, 0x000fe400078e022bULL, 0x000000012d407824ULL, 0x040fe200078e0240ULL,
0x00001f56312b7589ULL, 0x000fe200000e0000ULL, 0x000000012d2c7824ULL, 0x000fc400078e022cULL,
0x000000012d467824ULL, 0x040fe200078e0246ULL, 0x00007610ff527816ULL, 0x002fe2000000002fULL,
0x000000012d487824ULL, 0x040fe200078e0248ULL, 0x0000000040407984ULL, 0x000e620000000800ULL,
0x000000012d4a7824ULL, 0x040fe400078e024aULL, 0x000000012d4c7824ULL, 0x040fe200078e024cULL,
0x000000002c2c7984ULL, 0x000e620000000800ULL, 0x000000012d4e7824ULL, 0x040fe200078e024eULL,
0x0000002a52277223ULL, 0x004fe20000010027ULL, 0x000000012d447824ULL, 0x040fe200078e0244ULL,
0x0000000046467984ULL, 0x000ea20000000800ULL, 0x000000012d507824ULL, 0x000fe200078e0250ULL,
0x00005410ff2d7816ULL, 0x000fc4000000002fULL, 0x0000000048487984ULL, 0x000e660000000800ULL,
0x0000002a2d287223ULL, 0x000fe20000010028ULL, 0x00005410ff2d7816ULL, 0x100fe20000000042ULL,
0x000000004a4a7984ULL, 0x000ea20000000800ULL, 0x00007610ff427816ULL, 0x000fc60000000042ULL,
0x0000002a2d1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff2d7816ULL, 0x100fe2000000002eULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x00007610ff2e7816ULL, 0x000fe2000000002eULL,
0x0000002a42197223ULL, 0x080fe40000010019ULL, 0x0000002a2d267223ULL, 0x080fe20000010026ULL,
0x00005410ff2d7816ULL, 0x100fe20000000030ULL, 0x000000004e4e7984ULL, 0x000ea20000000800ULL,
0x00007610ff307816ULL, 0x000fe20000000030ULL, 0x0000002a2e257223ULL, 0x000fc40000010025ULL,
0x0000002a2d247223ULL, 0x080fe20000010024ULL, 0x00005410ff2d7816ULL, 0x108fe2000000003aULL,
0x0000000044447984ULL, 0x000ee20000000800ULL, 0x00007610ff3a7816ULL, 0x000fe2000000003aULL,
0x0000002a30237223ULL, 0x080fe40000010023ULL, 0x0000002a2d227223ULL, 0x080fe20000010022ULL,
0x00005410ff2d7816ULL, 0x110fe2000000003cULL, 0x0000000050507984ULL, 0x000f220000000800ULL,
0x00007610ff3c7816ULL, 0x000fe2000000003cULL, 0x0000002a3a217223ULL, 0x000fc40000010021ULL,
0x0000002a2d207223ULL, 0x080fe20000010020ULL, 0x00005410ff2d7816ULL, 0x120fe2000000003eULL,
0x0000002a3c1f7223ULL, 0x000fe2000001001fULL, 0x00007610ff3e7816ULL, 0x000fc6000000003eULL,
0x0000002a2d1e7223ULL, 0x080fe2000001001eULL, 0x00005410ff2d7816ULL, 0x102fe20000000040ULL,
0x0000002a3e1d7223ULL, 0x000fe2000001001dULL, 0x00007610ff407816ULL, 0x000fc60000000040ULL,
0x0000002a2d1c7223ULL, 0x080fe2000001001cULL, 0x00005410ff2d7816ULL, 0x100fe2000000002cULL,
0x0000002a401b7223ULL, 0x000fe2000001001bULL, 0x00007610ff2c7816ULL, 0x000fc6000000002cULL,
0x0000002b2d187223ULL, 0x080fe20000010018ULL, 0x00005410ff2d7816ULL, 0x104fe20000000046ULL,
0x0000002b2c177223ULL, 0x000fe20000010017ULL, 0x00007610ff467816ULL, 0x000fc60000000046ULL,
0x0000002b2d167223ULL, 0x080fe20000010016ULL, 0x00005410ff2d7816ULL, 0x100fe20000000048ULL,
0x0000002b46157223ULL, 0x000fe20000010015ULL, 0x00007610ff487816ULL, 0x000fc60000000048ULL,
0x0000002b2d147223ULL, 0x080fe20000010014ULL, 0x00005410ff2d7816ULL, 0x100fe2000000004aULL,
0x0000002b48137223ULL, 0x000fe20000010013ULL, 0x00007610ff4a7816ULL, 0x000fc6000000004aULL,
0x0000002b2d127223ULL, 0x080fe20000010012ULL, 0x00005410ff2d7816ULL, 0x100fe2000000004cULL,
0x0000002b4a117223ULL, 0x000fe20000010011ULL, 0x00007610ff4c7816ULL, 0x000fc6000000004cULL,
0x0000002b2d107223ULL, 0x080fe20000010010ULL, 0x00005410ff2d7816ULL, 0x100fe2000000004eULL,
0x0000002b4c0f7223ULL, 0x000fe2000001000fULL, 0x00007610ff4e7816ULL, 0x000fc6000000004eULL,
0x0000002b2d0e7223ULL, 0x080fe2000001000eULL, 0x00005410ff2d7816ULL, 0x108fe20000000044ULL,
0x0000002b4e0d7223ULL, 0x000fe2000001000dULL, 0x00007610ff447816ULL, 0x000fc60000000044ULL,
0x0000002b2d0c7223ULL, 0x080fe2000001000cULL, 0x00005410ff2d7816ULL, 0x110fe20000000050ULL,
0x0000002b440b7223ULL, 0x000fe2000001000bULL, 0x00007610ff507816ULL, 0x000fc60000000050ULL,
0x0000002b2d0a7223ULL, 0x080fe4000001000aULL, 0x0000002b50097223ULL, 0x000fe20000010009ULL,
0xfffff2d000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x004fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000000ff3300720cULL, 0x000fe20003f05270ULL,
0x0000001003047824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000103077824ULL, 0x000fe200078e0204ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011603ULL, 0x0000007004037812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc600078ec0ffULL, 0x0000008038037824ULL, 0x000fc800078e0203ULL,
0x0000000106037824ULL, 0x000fca00078e0203ULL, 0x0049803203007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800007037984ULL, 0x002e680000000800ULL, 0x004a000007047984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000403037221ULL, 0x004fca0000010000ULL,
0x0180000003047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff317224ULL, 0x000fe200078e0003ULL,
0x0000d70000067802ULL, 0x000fe40000000f00ULL, 0x0000695000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300047308ULL, 0x000e640000001000ULL, 0xbf80000003067423ULL, 0x002fc80000000004ULL,
0x800000ff06077221ULL, 0x000fc80000010100ULL, 0x0000000704047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff357819ULL, 0x004fe40000011603ULL,
0x0000000803437811ULL, 0x000fc600078ff0ffULL, 0x00001f3504067589ULL, 0x000ea200000e0000ULL,
0x00000043ff457212ULL, 0x000fe200078e33ffULL, 0x0000000835477824ULL, 0x000fe400078e00ffULL,
0x00001f4304077589ULL, 0x00072400000e0000ULL, 0x00000035ff047212ULL, 0x008fc800078e33ffULL,
0xfffffff847477812ULL, 0x000fe400078ee204ULL, 0x0000000735047812ULL, 0x000fe200078ec0ffULL,
0x0000002806287220ULL, 0x044fe20000410000ULL, 0x0000002706277220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000001a061a7220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x000fe20000410000ULL,
0x0000000843067824ULL, 0x000fe200078e00ffULL, 0x0000001807187220ULL, 0x050fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000b070b7220ULL, 0x040fe20000410000ULL, 0x0000000a070a7220ULL, 0x040fe20000410000ULL,
0xfffffff806457812ULL, 0x000fe200078ee245ULL, 0x0000000907077220ULL, 0x000fe20000410000ULL,
0x0000000835067824ULL, 0x000fe200078e00ffULL, 0x0000000e0d0d723eULL, 0x000fc400000010ffULL,
0x0000000c0b0b723eULL, 0x000fe200000010ffULL, 0x0000001045457824ULL, 0x100fe200078e0200ULL,
0x0000000a0707723eULL, 0x000fe400000010ffULL, 0xfffffff806097812ULL, 0x000fe400078ee235ULL,
0x0000000104067812ULL, 0x040fe400078e3cffULL, 0x0000000204087812ULL, 0x040fe200078e3cffULL,
0x0000001009097824ULL, 0x000fe200078e0200ULL, 0x00000003040a7812ULL, 0x040fe200078e3cffULL,
0x0000000835297824ULL, 0x040fe200078e0206ULL, 0x00000004040c7812ULL, 0x040fe200078e3cffULL,
0x00000008352b7824ULL, 0x040fe200078e0208ULL, 0x00000005040e7812ULL, 0x040fe200078e3cffULL,
0x00000008352d7824ULL, 0x040fe200078e020aULL, 0x0000000604047812ULL, 0x000fe200078e3cffULL,
0x00000008352f7824ULL, 0x000fe200078e020cULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000000835317824ULL, 0x002fe200078e020eULL, 0x0000000743127812ULL, 0x000fe200078ec0ffULL,
0x0000000835357824ULL, 0x000fe200078e0204ULL, 0x000000141313723eULL, 0x000fe200000010ffULL,
0x0000000843147824ULL, 0x000fe200078e00ffULL, 0x000000100f0f723eULL, 0x000fe200000010ffULL,
0x0000000403107824ULL, 0x000fe200078e00ffULL, 0x0000000112047812ULL, 0x040fe200078e3cffULL,
0x0000001029297824ULL, 0x100fe200078e0200ULL, 0x0000000212067812ULL, 0x040fe200078e3cffULL,
0x000000102b2b7824ULL, 0x000fe200078e0200ULL, 0x0000000312087812ULL, 0x040fe200078e3cffULL,
0x0000000843397824ULL, 0x040fe200078e0204ULL, 0x00000004120a7812ULL, 0x040fe200078e3cffULL,
0x00000008433b7824ULL, 0x040fe200078e0206ULL, 0x00000005120c7812ULL, 0x040fe200078e3cffULL,
0x00000008433d7824ULL, 0x040fe200078e0208ULL, 0x00000006120e7812ULL, 0x000fe200078e3cffULL,
0x00000008433f7824ULL, 0x000fe200078e020aULL, 0x0000001c1b1b723eULL, 0x000fe200000010ffULL,
0x0000000843417824ULL, 0x040fe200078e020cULL, 0xfffffff814377812ULL, 0x000fe200078ee243ULL,
0x0000000843437824ULL, 0x000fe200078e020eULL, 0x0000000c101c7812ULL, 0x000fe200078ec0ffULL,
0x0000001047067824ULL, 0x100fe200078e0200ULL, 0x000000282727723eULL, 0x000fe200000010ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0200ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x0000001037377824ULL, 0x100fe200078e0200ULL, 0x000000242323723eULL, 0x000fe200000010ffULL,
0x000000011c047824ULL, 0x000fe200078e0209ULL, 0x000000222121723eULL, 0x000fe200000010ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0200ULL, 0x000000201f1f723eULL, 0x000fe200000010ffULL,
0x0000001031317824ULL, 0x100fe200078e0200ULL, 0x0000001e1d1d723eULL, 0x000fe200000010ffULL,
0x0000001035357824ULL, 0x100fe200078e0200ULL, 0x0000002704007388ULL, 0x0003e20000000800ULL,
0x0000001039397824ULL, 0x100fe200078e0200ULL, 0x0000001a1919723eULL, 0x000fe200000010ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0200ULL, 0x000000181717723eULL, 0x000fe200000010ffULL,
0x000000103d3d7824ULL, 0x100fe200078e0200ULL, 0x000000161515723eULL, 0x000fe200000010ffULL,
0x000000103f3f7824ULL, 0x000fc400078e0200ULL, 0x0000001041417824ULL, 0x100fe400078e0200ULL,
0x0000001043437824ULL, 0x000fe400078e0200ULL, 0x000000011c107824ULL, 0x040fe400078e0206ULL,
0x000000011c007824ULL, 0x040fe400078e0229ULL, 0x000000011c067824ULL, 0x040fe400078e022bULL,
0x000000011c087824ULL, 0x040fe200078e022dULL, 0x0000002500007388ULL, 0x0005e20000000800ULL,
0x000000011c0a7824ULL, 0x000fc400078e022fULL, 0x000000011c0c7824ULL, 0x040fe200078e0231ULL,
0x0000002306007388ULL, 0x000fe20000000800ULL, 0x000000011c0e7824ULL, 0x040fe400078e0235ULL,
0x000000011c127824ULL, 0x040fe200078e0237ULL, 0x0000002108007388ULL, 0x000fe20000000800ULL,
0x000000011c147824ULL, 0x040fe400078e0239ULL, 0x000000011c047824ULL, 0x042fe200078e023bULL,
0x0000001f0a007388ULL, 0x000fe20000000800ULL, 0x000000011c167824ULL, 0x000fc400078e023dULL,
0x000000011c187824ULL, 0x040fe200078e023fULL, 0x0000001d0c007388ULL, 0x000fe20000000800ULL,
0x000000011c1e7824ULL, 0x040fe400078e0245ULL, 0x000000011c1a7824ULL, 0x040fe200078e0241ULL,
0x0000001b0e007388ULL, 0x000fe20000000800ULL, 0x000000011c1c7824ULL, 0x000fe400078e0243ULL,
0x0000002038207824ULL, 0x000fe200078e0203ULL, 0x0000001910007388ULL, 0x0003e60000000800ULL,
0x0000001020007824ULL, 0x004fe200078e0205ULL, 0x0000001712007388ULL, 0x000fe80000000800ULL,
0x0000001514007388ULL, 0x000fe20000000800ULL, 0x000000020210723eULL, 0x002fc600000010ffULL,
0x0000001304007388ULL, 0x000fe80000000800ULL, 0x0000001116007388ULL, 0x000fe80000000800ULL,
0x0000000f18007388ULL, 0x000fe80000000800ULL, 0x0000000d1a007388ULL, 0x000fe80000000800ULL,
0x0000000b1c007388ULL, 0x000fe80000000800ULL, 0x000000071e007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000207984ULL, 0x000e680000000c00ULL,
0x0004000000287984ULL, 0x000ea80000000c00ULL, 0x0008000000247984ULL, 0x000ee80000000c00ULL,
0x000c0000002c7984ULL, 0x000f220000000c00ULL, 0x3f803f8010237831ULL, 0x002fc40000200023ULL,
0x3f803f8010227831ULL, 0x040fe40000200022ULL, 0x3f803f8010217831ULL, 0x040fe40000200021ULL,
0x3f803f8010207831ULL, 0x040fe40000200020ULL, 0x3f803f80102b7831ULL, 0x044fe4000020002bULL,
0x3f803f80102a7831ULL, 0x040fe4000020002aULL, 0x3f803f8010297831ULL, 0x000fc40000200029ULL,
0x3f803f8010287831ULL, 0x000fe40000200028ULL, 0x3f803f8023237831ULL, 0x008fe40000200027ULL,
0x3f803f8022227831ULL, 0x000fe40000200026ULL, 0x3f803f8021217831ULL, 0x000fe40000200025ULL,
0x3f803f8020207831ULL, 0x000fe40000200024ULL, 0x3f803f802b2b7831ULL, 0x010fc4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020002eULL, 0x0000002000007388ULL, 0x0003e20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fca000020002cULL,
0x0004002800007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff3800720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002003117810ULL, 0x000fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000f220000002600ULL,
0x00000003ff107819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000f620000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000710007812ULL, 0x002fe200078e4803ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704027812ULL, 0x000fe200078e4811ULL, 0x0000000833127824ULL, 0x000fe200078e00ffULL,
0x0ffffff800007812ULL, 0x000fc400078ef803ULL, 0x0ffffff802027812ULL, 0x100fe400078ef811ULL,
0xfffffff812117812ULL, 0x000fe200078ee211ULL, 0x0000001000007824ULL, 0x100fe400078e0205ULL,
0x0000001002057824ULL, 0x000fc600078e0205ULL, 0x0000000000087984ULL, 0x0042a80000000c00ULL,
0x00000000050c7984ULL, 0x0086a20000000c00ULL, 0x0000000806077824ULL, 0x050fe400078e00ffULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x020fe2000f8e023fULL,
0x0000000833007824ULL, 0x002fe200078e00ffULL, 0xfffffff807027812ULL, 0x000fc400078ee210ULL,
0xfffffff813047812ULL, 0x000fe400078ee204ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404027c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x008fe200000e06ffULL, 0x00005a0010047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0002067a11ULL, 0x000fc400078240ffULL,
0x00005b0010057a11ULL, 0x000fe400000f4405ULL, 0x00005b0002077a11ULL, 0x000fc600008f4407ULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x004fe8000c101d06ULL, 0x0000000c04007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604317981ULL, 0x000362000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000103077810ULL, 0x000fe20007ffe0ffULL,
0x0000000237007824ULL, 0x000fe200078e00ffULL, 0x00f60000ff047f8cULL, 0x002e62000c80043fULL,
0x000000402d2e7824ULL, 0x000fe200078e00ffULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x00005800002f7a24ULL, 0x000fe400078e022fULL, 0x00000100030b7824ULL, 0x000fc800078e022eULL,
0x000062002f1a7a24ULL, 0x000fcc00078e020bULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x000fe20000011639ULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0x000000300c1f7812ULL, 0x000fe400078ec0ffULL, 0x000000081d117810ULL, 0x040fe20007ffe0ffULL,
0x000000011d067824ULL, 0x140fe200078e021aULL, 0x000000101d237810ULL, 0x040fe40007ffe0ffULL,
0x000000181d257810ULL, 0x000fe20007ffe0ffULL, 0x0000000111087824ULL, 0x000fe200078e021aULL,
0x000000201d177810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000000b2c007217ULL, 0x000fc40007800000ULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0x0000001f060e7210ULL, 0x080fe40007f1e0ffULL,
0x00000003ff147819ULL, 0x100fe20000011639ULL, 0x00000001230a7824ULL, 0x100fe200078e021aULL,
0x0000001f08087210ULL, 0x000fe20007f3e0ffULL, 0x00000001250c7824ULL, 0x000fe200078e021aULL,
0x0000000314147812ULL, 0x000fe200078e4839ULL, 0x000000011a067824ULL, 0x000fe200078e0217ULL,
0x000010002d167811ULL, 0x000fe200078e68ffULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x0ffffffc14397812ULL, 0x000fe200078ef839ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0021ULL,
0x000000301d1b7810ULL, 0x000fc40007ffe0ffULL, 0x000000001700720cULL, 0x080fe20003f66070ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0x000000002300720cULL, 0x080fe40003fa6070ULL,
0x000000002500720cULL, 0x000fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0607ULL,
0x0000001f0a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0006067625ULL, 0x000fc800078e0021ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000001f0c0c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000001f06107210ULL, 0x000fe20007f5e0ffULL,
0x000000011a067824ULL, 0x000fe200078e0219ULL, 0x000000001d00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000001100720cULL, 0x0c0fe20003f26070ULL,
0x0000000411137824ULL, 0x000fe200078e00ffULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0607ULL, 0x000000001900720cULL, 0x000fe20003f46070ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0xfffffffc13137812ULL, 0x000fc600078ee214ULL,
0x0000001039397824ULL, 0x100fe200078e0216ULL, 0x0000001f06127210ULL, 0x000fe20007fde0ffULL,
0x0000001013157824ULL, 0x000fe400078e0216ULL, 0x000000011a067824ULL, 0x000fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e397faeULL, 0x0005e2000c101c46ULL,
0x000000ffff137224ULL, 0x000fe200030e0607ULL, 0x000000001d00720cULL, 0x080fe20003f06070ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x0000000008157faeULL, 0x0007e2000c901c46ULL,
0x000000001b00720cULL, 0x000fc40003f26070ULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x0000001f06067210ULL, 0x000fe20007fde0ffULL, 0x0000000419197824ULL, 0x000fe400078e00ffULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x100fe200078ee214ULL,
0x00000004230f7824ULL, 0x004fe200078e00ffULL, 0xfffffffc19197812ULL, 0x100fe200078ee214ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0xfffffffc1b1b7812ULL, 0x100fe200078ee214ULL,
0x0000000425157824ULL, 0x008fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee214ULL,
0x000000011a087824ULL, 0x000fc400078e021dULL, 0x000000041d1d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc15157812ULL, 0x000fe200078ee214ULL, 0x00005e0008087625ULL, 0x000fc600078e0021ULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee214ULL, 0x000000100f0f7824ULL, 0x100fe200078e0216ULL,
0x0000001f08087210ULL, 0x000fe20007fde0ffULL, 0x0000001015157824ULL, 0x100fe400078e0216ULL,
0x0000001017177824ULL, 0x100fe200078e0216ULL, 0x000000000a0f7faeULL, 0x0005e2000e901c46ULL,
0x0000001019197824ULL, 0x100fe400078e0216ULL, 0x000000101b1b7824ULL, 0x100fe200078e0216ULL,
0x000000000c157faeULL, 0x0005e2000e101c46ULL, 0x000000101d1d7824ULL, 0x000fc400078e0216ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000000010177faeULL, 0x0005e8000d901c46ULL,
0x0000000012197faeULL, 0x0005e8000d101c46ULL, 0x00000000061b7faeULL, 0x0005e8000c901c46ULL,
0x00000000081d7faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x0000001039077811ULL, 0x040fe200078ff0ffULL, 0x00000080ff257424ULL, 0x000fe200078e00ffULL,
0x0000001a39067211ULL, 0x000fc400078ff0ffULL, 0x00000003ff007819ULL, 0x000fe20000011639ULL,
0x000000011a087824ULL, 0x000fe200078e0207ULL, 0x00000008390f7811ULL, 0x000fe200078ff0ffULL,
0x0000000407137824ULL, 0x000fe200078e00ffULL, 0x00000020390b7811ULL, 0x040fe200078ff0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0x000000300c277812ULL, 0x000fe400078ec0ffULL,
0x0000001839097811ULL, 0x000fe200078ff0ffULL, 0x000000040f117824ULL, 0x040fe200078e00ffULL,
0x00000003001c7812ULL, 0x000fe200078e4839ULL, 0x000000010f007824ULL, 0x000fe200078e021aULL,
0x00000028390c7811ULL, 0x040fe200078ff0ffULL, 0x000000011a0f7824ULL, 0x000fe200078e020bULL,
0x00000030390d7811ULL, 0x000fe200078ff0ffULL, 0x000000040b0b7824ULL, 0x000fe200078e00ffULL,
0x0000002706107210ULL, 0x000fe20007f1e0ffULL, 0x000000011a0a7824ULL, 0x040fe200078e0209ULL,
0x00000038390e7811ULL, 0x000fe200078ff0ffULL, 0x0000000409097824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b127812ULL, 0x000fe200078ee21cULL, 0x000000011a167824ULL, 0x000fe200078e020cULL,
0x000010002d237811ULL, 0x000fe200078e68ffULL, 0x000000040c157824ULL, 0x000fe200078e00ffULL,
0xfffffffc110c7812ULL, 0x000fe200078ee21cULL, 0x000000011a187824ULL, 0x000fe200078e020dULL,
0x0ffffffc1c397812ULL, 0x000fe200078ef839ULL, 0x000000ffff117224ULL, 0x000fc400000e0607ULL,
0x000000011a1a7824ULL, 0x000fe400078e020eULL, 0x000000040e197824ULL, 0x000fe200078e00ffULL,
0xfffffffc090e7812ULL, 0x000fe200078ee21cULL, 0x00005e0000067625ULL, 0x000fc800078e0025ULL,
0x000000040d177824ULL, 0x000fe200078e00ffULL, 0xfffffffc130d7812ULL, 0x100fe200078ee21cULL,
0x00005e0008087625ULL, 0x000fe200078e0025ULL, 0xfffffffc15137812ULL, 0x100fe400078ee21cULL,
0xfffffffc17157812ULL, 0x100fe200078ee21cULL, 0x00000010121d7824ULL, 0x100fe200078e0223ULL,
0x0000002706127210ULL, 0x000fe20007f1e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0025ULL,
0x0000002708147210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc191c7812ULL, 0x000fe200078ee21cULL,
0x00000010131f7824ULL, 0x000fc400078e0223ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x000000270a0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001015217824ULL, 0x000fe400078e0223ULL,
0x000000ffff157224ULL, 0x000fe400008e0609ULL, 0x00005e000f067625ULL, 0x000fc800078e0025ULL,
0x000000100c177824ULL, 0x100fe400078e0223ULL, 0x000000100d197824ULL, 0x000fe400078e0223ULL,
0x00005e0016087625ULL, 0x000fc800078e0025ULL, 0x000000100e1b7824ULL, 0x000fe200078e0223ULL,
0x0000002708087210ULL, 0x000fe20007f3e0ffULL, 0x00005e00180c7625ULL, 0x000fc800078e0025ULL,
0x00005e001a0e7625ULL, 0x000fe200078e0025ULL, 0x000000270c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002706067210ULL, 0x080fe20007f1e0ffULL,
0x0000001039397824ULL, 0x000fe200078e0223ULL, 0x000000270e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0609ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010397faeULL, 0x0005e2000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fe400010e060dULL, 0x000000101c237824ULL, 0x000fe200078e0223ULL,
0x0000000012177faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x0000000014197faeULL, 0x0005e8000b901c46ULL, 0x000000000a1b7faeULL, 0x0005e8000b901c46ULL,
0x00000000061d7faeULL, 0x0005e8000b901c46ULL, 0x00000000081f7faeULL, 0x0005e8000b901c46ULL,
0x000000000c217faeULL, 0x0005e8000b901c46ULL, 0x000000000e237faeULL, 0x0005e4000b901c46ULL,
0x00f60400ff077984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000007ff7812ULL, 0x006fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe20003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x000000202d007824ULL, 0x002fc800078e0200ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x000000f006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105077812ULL, 0x040fe400078efcffULL,
0x0000000705057812ULL, 0x100fe400078e7800ULL, 0x0000000707077812ULL, 0x000fc600078e7800ULL,
0x0000000105057824ULL, 0x000fe400078e0206ULL, 0x0000000106077824ULL, 0x000fc600078e0207ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001005007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff047f8cULL, 0x002fe8000c80043fULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000020300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000307919ULL, 0x000e620000000000ULL, 0x3db504f331317820ULL, 0x020fe20000410000ULL,
0x0000f6882d327811ULL, 0x040fe200078e18ffULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0xffffffff02347810ULL, 0x000fe40007ffe0ffULL, 0x0000f6082d337811ULL, 0x000fe400078e28ffULL,
0x0000010003357824ULL, 0x000fe200078e022eULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000352c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff007224ULL, 0x000fe200078e0036ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fc4000001ff00ULL,
0x0000000137247810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e0037ULL, 0x0000000100367812ULL, 0x000fc400078e0cffULL,
0x00000001ff267819ULL, 0x100fe20000011624ULL, 0x000000ffff377224ULL, 0x000fe200078e0024ULL,
0x000000022400780cULL, 0x000fc60003f06070ULL, 0x0000030026257a24ULL, 0x000fca00078e0203ULL,
0x0000000125277810ULL, 0x000fc80007ffe0ffULL, 0x000000022700720cULL, 0x000fe20003f26070ULL,
0x0000010025277824ULL, 0x000fe200078e022eULL, 0x0000000124257812ULL, 0x000fc600078ec0ffULL,
0x000062002f397a24ULL, 0x000fd000078e0227ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x00000004253d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x002fe20000011630ULL,
0x000000022d3c7824ULL, 0x000fe200078e0236ULL, 0x000000272c247217ULL, 0x000fe20007800000ULL,
0x00000080ff3b7424ULL, 0x000fe200078e00ffULL, 0x00000002ff2a7819ULL, 0x100fe40000011630ULL,
0x00000003253f7812ULL, 0x100fe200078e4830ULL, 0x0000000124287824ULL, 0x000fe200078e0a27ULL,
0x000000082a257810ULL, 0x040fe20007ffe0ffULL, 0x000000012a247824ULL, 0x000fe200078e0239ULL,
0xfffffffc3d3d7812ULL, 0x000fc400078ee230ULL, 0x000000282a00720cULL, 0x080fe20003f26070ULL,
0x0000000125267824ULL, 0x040fe200078e0239ULL, 0x000000282500720cULL, 0x040fe20003f46070ULL,
0x0000000425387824ULL, 0x000fe200078e00ffULL, 0x000010003c3c7811ULL, 0x000fe200078e60ffULL,
0x00005e0024247625ULL, 0x080fe200078e003bULL, 0x0ffffffc3f297812ULL, 0x000fe400078ef830ULL,
0xfffffffc382b7812ULL, 0x000fe200078ee23fULL, 0x00005e0026267625ULL, 0x000fe200078e003bULL,
0x000000102a387810ULL, 0x000fc40007ffe0ffULL, 0x000000182a3a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e023cULL, 0x000000202a3e7810ULL, 0x040fe20007ffe0ffULL,
0x000000103d247825ULL, 0x000fe200078e0024ULL, 0x000000282a417810ULL, 0x040fe40007ffe0ffULL,
0x000000302a427810ULL, 0x040fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e023cULL,
0x000000382a437810ULL, 0x000fe20007ffe0ffULL, 0x000000103d267825ULL, 0x000fe200078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e2000c901c46ULL,
0x000000283800720cULL, 0x000fc40003f26070ULL, 0x000000283e00720cULL, 0x080fe20003f66070ULL,
0x00000000262b7faeULL, 0x0005e2000d101c46ULL, 0x000000283a00720cULL, 0x080fe20003f46070ULL,
0x0000000438447824ULL, 0x000fe200078e00ffULL, 0x000000284100720cULL, 0x0c0fe20003f86070ULL,
0x000000043a467824ULL, 0x000fe200078e00ffULL, 0x000000284200720cULL, 0x080fe20003fa6070ULL,
0x00000001412a7824ULL, 0x100fe200078e0239ULL, 0x000000284300720cULL, 0x000fe20003fc6070ULL,
0x0000000138247824ULL, 0x102fe400078e0239ULL, 0x000000013e287824ULL, 0x000fc400078e0239ULL,
0x000000013a267824ULL, 0x104fe400078e0239ULL, 0x0000000142387824ULL, 0x100fe400078e0239ULL,
0x00000001433a7824ULL, 0x000fe400078e0239ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x00005e0024247625ULL, 0x000fc600078e003bULL, 0xfffffffc3e457812ULL, 0x000fe200078ee23fULL,
0x00005e0026267625ULL, 0x000fc800078e003bULL, 0x00005e0028287625ULL, 0x000fc800078e003bULL,
0x00005e002a2a7625ULL, 0x000fc800078e003bULL, 0x00005e0038387625ULL, 0x000fc800078e003bULL,
0x0000000441487824ULL, 0x000fe200078e00ffULL, 0xfffffffc44417812ULL, 0x000fe200078ee23fULL,
0x00005e003a3a7625ULL, 0x000fc600078e003bULL, 0xfffffffc48477812ULL, 0x100fe200078ee23fULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x00000004434a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc46437812ULL, 0x000fe200078ee23fULL, 0x000000103d247825ULL, 0x040fe200078e0024ULL,
0xfffffffc42497812ULL, 0x100fe400078ee23fULL, 0xfffffffc4a4b7812ULL, 0x000fe200078ee23fULL,
0x000000103d267825ULL, 0x000fc800078e0026ULL, 0x000000103d287825ULL, 0x000fc800078e0028ULL,
0x000000103d2a7825ULL, 0x000fc800078e002aULL, 0x000000103d387825ULL, 0x000fc800078e0038ULL,
0x000000103d3a7825ULL, 0x000fc800078e003aULL, 0x00000010413d7824ULL, 0x100fe400078e023cULL,
0x00000010433f7824ULL, 0x100fe400078e023cULL, 0x0000001045417824ULL, 0x100fe200078e023cULL,
0x00000000243d7faeULL, 0x0003e2000c901c46ULL, 0x0000001047437824ULL, 0x100fe400078e023cULL,
0x0000001049457824ULL, 0x100fe200078e023cULL, 0x00000000263f7faeULL, 0x0003e2000d101c46ULL,
0x000000104b477824ULL, 0x000fc600078e023cULL, 0x0000000028417faeULL, 0x0003e8000d901c46ULL,
0x000000002a437faeULL, 0x0003e8000e101c46ULL, 0x0000000038457faeULL, 0x0003e8000e901c46ULL,
0x000000003a477faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x000000022d267824ULL, 0x000fe200078e0236ULL, 0x0000000830287811ULL, 0x042fe200078ff0ffULL,
0x0000000425417824ULL, 0x000fe200078e00ffULL, 0x00000010302a7811ULL, 0x040fe200078ff0ffULL,
0x00000080ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001830387811ULL, 0x000fe200078ff0ffULL,
0x0000000428447824ULL, 0x000fe200078e00ffULL, 0x00000020303a7811ULL, 0x000fe200078ff0ffULL,
0x000000042a467824ULL, 0x000fe200078e00ffULL, 0x00000028303c7811ULL, 0x000fe200078ff0ffULL,
0x0000000438487824ULL, 0x000fe200078e00ffULL, 0x00000030303e7811ULL, 0x000fe200078ff0ffULL,
0x000000043a4a7824ULL, 0x000fe200078e00ffULL, 0x0000003830427811ULL, 0x000fe200078ff0ffULL,
0x000000043c4c7824ULL, 0x000fe200078e00ffULL, 0x00001000264d7811ULL, 0x000fe200078e60ffULL,
0x0000000128267824ULL, 0x100fe200078e0239ULL, 0x00000003ff257819ULL, 0x100fe20000011630ULL,
0x000000012a287824ULL, 0x100fe200078e0239ULL, 0x0000003930247211ULL, 0x000fe200078ff0ffULL,
0x00000001382a7824ULL, 0x100fe200078e0239ULL, 0x0000000325277812ULL, 0x100fe200078e4830ULL,
0x000000013a387824ULL, 0x000fe200078e0239ULL, 0xfffffffc41417812ULL, 0x000fe200078ee230ULL,
0x000000043e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee227ULL,
0x0000000442507824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x000fe200078ee227ULL,
0x000000013c3a7824ULL, 0x000fe200078e0239ULL, 0xfffffffc48487812ULL, 0x000fe200078ee227ULL,
0x000000013e3c7824ULL, 0x000fe200078e0239ULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee227ULL,
0x00000001423e7824ULL, 0x000fe200078e0239ULL, 0xfffffffc4c4c7812ULL, 0x100fe200078ee227ULL,
0x00005e0024247625ULL, 0x000fe200078e003fULL, 0xfffffffc4e4e7812ULL, 0x000fc400078ee227ULL,
0xfffffffc50507812ULL, 0x000fe200078ee227ULL, 0x00005e0028287625ULL, 0x000fe200078e003fULL,
0x0ffffffc27427812ULL, 0x000fc600078ef830ULL, 0x00005e0026267625ULL, 0x000fc800078e003fULL,
0x00005e002a2a7625ULL, 0x000fc800078e003fULL, 0x00005e0038387625ULL, 0x000fc800078e003fULL,
0x00005e003a3a7625ULL, 0x000fc800078e003fULL, 0x00005e003c3c7625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x0000001041247825ULL, 0x000fc800078e0024ULL,
0x0000001041267825ULL, 0x000fc800078e0026ULL, 0x0000001041287825ULL, 0x000fc800078e0028ULL,
0x00000010412a7825ULL, 0x000fc800078e002aULL, 0x0000001041387825ULL, 0x000fc800078e0038ULL,
0x00000010413a7825ULL, 0x000fc800078e003aULL, 0x00000010413c7825ULL, 0x000fc800078e003cULL,
0x00000010413e7825ULL, 0x000fc800078e003eULL, 0x00000010424f7824ULL, 0x100fe400078e024dULL,
0x0000001044417824ULL, 0x100fe400078e024dULL, 0x0000001046437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000244f7faeULL, 0x0003e2000b901c46ULL,
0x0000001048457824ULL, 0x100fe400078e024dULL, 0x000000104a477824ULL, 0x100fe200078e024dULL,
0x0000000026417faeULL, 0x0003e2000b901c46ULL, 0x000000104c497824ULL, 0x000fc400078e024dULL,
0x000000104e4b7824ULL, 0x100fe200078e024dULL, 0x0000000028437faeULL, 0x0003e2000b901c46ULL,
0x00000010504d7824ULL, 0x000fc600078e024dULL, 0x000000002a457faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e8000b901c46ULL, 0x000000003a497faeULL, 0x0003e8000b901c46ULL,
0x000000003c4b7faeULL, 0x0003e8000b901c46ULL, 0x000000003e4d7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000840397824ULL, 0x002fc400078e00ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff830257812ULL, 0x040fe200078ec0ffULL,
0x000000022d297824ULL, 0x000fe200078e0200ULL, 0x00000020302b7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000725257812ULL, 0x100fe400078ef830ULL,
0xfffffff82b2b7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff247819ULL, 0x000fe40000011625ULL,
0x000000072b2b7812ULL, 0x000fc400078ef830ULL, 0x0000000324277812ULL, 0x000fe400078ec0ffULL,
0x00000001ff267819ULL, 0x000fe4000001162bULL, 0x0000003827247212ULL, 0x000fe400078e3cffULL,
0x0000100029297811ULL, 0x000fe400078e60ffULL, 0x00000003263b7812ULL, 0x000fe200078ec0ffULL,
0x0000000425247824ULL, 0x000fe200078e0224ULL, 0x0000000138267810ULL, 0x000fc60007ffe0ffULL,
0x0000001024447824ULL, 0x000fe200078e0229ULL, 0x000000383b247212ULL, 0x000fe400078e3cffULL,
0x0000000238387810ULL, 0x000fc60007ffe0ffULL, 0x000000042b247824ULL, 0x000fe200078e0224ULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x000000043800780cULL, 0x000fe40003f25270ULL,
0x00000010243c7824ULL, 0x100fe200078e0229ULL, 0x0000002627247212ULL, 0x080fe400078e3cffULL,
0x000000263b267212ULL, 0x000fe400078e3cffULL, 0x0000000730277812ULL, 0x040fe200078ec0ffULL,
0x0000000425287824ULL, 0x000fe200078e0224ULL, 0x0000003930247211ULL, 0x000fe200078fe0ffULL,
0x000000042b267824ULL, 0x000fe200078e0226ULL, 0x0000000827277812ULL, 0x000fe200078ef830ULL,
0x0000001028407824ULL, 0x100fe200078e0229ULL, 0x0000000224257810ULL, 0x000fe20007ffe0ffULL,
0x0000001026267824ULL, 0x000fe200078e0229ULL, 0x0000000724247812ULL, 0x100fe200078e7827ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000000725257812ULL, 0x000fc400078e7827ULL,
0x0000000439397810ULL, 0x000fe20007ffe0ffULL, 0x000000004040783bULL, 0x000ea20000000200ULL,
0x0000001027497824ULL, 0x040fe400078e0224ULL, 0x0000001027287824ULL, 0x000fe400078e0225ULL,
0x000000002624783bULL, 0x000ee40000000200ULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x00000010ff4a7819ULL, 0x102fe40000011644ULL, 0x00000018ff297819ULL, 0x000fc40000011644ULL,
0x000000ff44487812ULL, 0x040fe400078ec0ffULL, 0x0000ffff446a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4b7819ULL, 0x100fe40000011645ULL, 0x00000018ff447819ULL, 0x000fe40000011645ULL,
0x000000ff454c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff456b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff4d7819ULL, 0x100fe40000011646ULL, 0x00000018ff457819ULL, 0x000fe40000011646ULL,
0x000000ff464e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff466c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe40000011647ULL, 0x00000018ff467819ULL, 0x000fc40000011647ULL,
0x000000ff47507812ULL, 0x040fe400078ec0ffULL, 0x0000ffff476e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6f7819ULL, 0x104fe40000011641ULL, 0x00000018ff5a7819ULL, 0x000fe40000011641ULL,
0x000000ff41627812ULL, 0x040fe400078ec0ffULL, 0x0000ffff41837812ULL, 0x000fc400078ec0ffULL,
0x00000010ff607819ULL, 0x100fe40000011640ULL, 0x00000018ff477819ULL, 0x000fe40000011640ULL,
0x000000ff40597812ULL, 0x040fe400078ec0ffULL, 0x0000ffff40827812ULL, 0x000fe400078ec0ffULL,
0x00000029ff41723eULL, 0x000fe400020006ffULL, 0x00000010ff297819ULL, 0x008fc40000011624ULL,
0x00000018ff787819ULL, 0x000fe20000011624ULL, 0x20000041ff647230ULL, 0x000fe20000004100ULL,
0x000000ff24797812ULL, 0x040fe400078ec0ffULL, 0x0000ffff24407812ULL, 0x000fe400078ec0ffULL,
0x00000008ff247819ULL, 0x000fe4000001166aULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000024ff24723eULL, 0x000fc400020006ffULL, 0x00000010ff2b7819ULL, 0x100fe2000001163fULL,
0x20000046ff5b7230ULL, 0x000fe20000004100ULL, 0x00000018ff577819ULL, 0x000fe4000001163fULL,
0x000000ff3f587812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3f2a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3f7819ULL, 0x100fe40000011625ULL, 0x00000018ff7a7819ULL, 0x000fc40000011625ULL,
0x000000ff257b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff253b7812ULL, 0x000fe400078ec0ffULL,
0x00000062ff46723eULL, 0x000fe200020006ffULL, 0x20000024ff627230ULL, 0x000fe20000004100ULL,
0x00000008ff257819ULL, 0x000fe4000001166bULL, 0x00000008ff247819ULL, 0x000fe2000001166cULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fc400020006ffULL,
0x000000ff42667812ULL, 0x000fe400078ec0ffULL, 0x00000025ff25723eULL, 0x000fe200020006ffULL,
0x20000044ff687230ULL, 0x000fe20000004100ULL, 0x000000ff43697812ULL, 0x000fe400078ec0ffULL,
0x00000024ff24723eULL, 0x000fe400020006ffULL, 0x00000066ff41723eULL, 0x000fe200020006ffULL,
0x20000025ff667230ULL, 0x000fe20000004100ULL, 0x00000069ff44723eULL, 0x000fe200020006ffULL,
0x20000024ff697230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe2000001166eULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff247819ULL, 0x000fe20000011682ULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000048ff48723eULL, 0x000fc400020006ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x20000048ff617230ULL, 0x000fe20000004100ULL, 0x00000018ff557819ULL, 0x000fe2000001163eULL,
0x20000025ff6b7230ULL, 0x000fe20000004100ULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x0000ffff42847812ULL, 0x000fc400078ec0ffULL,
0x00000059ff48723eULL, 0x000fe200020006ffULL, 0x20000057ff597230ULL, 0x000fe20000004100ULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x20000024ff577230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x100fe2000001163cULL, 0x20000055ff767230ULL, 0x000fe20000004100ULL,
0x00000018ff517819ULL, 0x000fe4000001163cULL, 0x000000ff3c527812ULL, 0x000fc400078ec0ffULL,
0x0000ffff3c807812ULL, 0x000fe400078ec0ffULL, 0x00000060ff25723eULL, 0x000fe200020006ffULL,
0x20000058ff607230ULL, 0x000fe20000004100ULL, 0x000000ff3d547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3a7819ULL, 0x100fe20000011626ULL, 0x20000025ff587230ULL, 0x000fe20000004100ULL,
0x00000018ff7c7819ULL, 0x000fe40000011626ULL, 0x000000ff267d7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff263c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff247819ULL, 0x000fe40000011684ULL,
0x0000ffff43857812ULL, 0x000fe400078ec0ffULL, 0x00000008ff267819ULL, 0x000fe40000011683ULL,
0x00000052ff52723eULL, 0x000fe400020006ffULL, 0x00000054ff54723eULL, 0x000fc400020006ffULL,
0x00000024ff55723eULL, 0x000fe200020006ffULL, 0x0000001049247824ULL, 0x000fe200078e00ffULL,
0x00000026ff26723eULL, 0x000fe200020006ffULL, 0x20000052ff6e7230ULL, 0x000fe20000004100ULL,
0x00000008ff257819ULL, 0x000fe20000011685ULL, 0x20000054ff727230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x100fe2000001163dULL, 0x20000026ff547230ULL, 0x000fe20000004100ULL,
0x00000018ff537819ULL, 0x000fe2000001163dULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x0000ffff3d817812ULL, 0x000fc400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fe4000001163eULL,
0x000000ff3e567812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3e5d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff3d7819ULL, 0x100fe40000011627ULL, 0x00000018ff7e7819ULL, 0x000fe40000011627ULL,
0x000000ff277f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff273e7812ULL, 0x000fe400078ec0ffULL,
0x00000025ff52723eULL, 0x000fe400020006ffULL, 0x000000002424783bULL, 0x000e620000000200ULL,
0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d4d7812ULL, 0x000fe200078ec0ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff637819ULL, 0x100fe20000011642ULL,
0x20000045ff5f7230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x2000004eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fe40000011642ULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x2000004dff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000063ff42723eULL, 0x000fe200020006ffULL,
0x2000004aff637230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x0000105462627816ULL, 0x000fe20000000061ULL, 0x2000005cff617230ULL, 0x000fe20000004100ULL,
0x00000010ff5c7819ULL, 0x000fe2000001165fULL, 0x2000004fff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011664ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff5f7819ULL, 0x000fe4000001166aULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000050ff50723eULL, 0x000fe400020006ffULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x000000ff2b2b7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff777819ULL, 0x100fe20000011643ULL,
0x20000056ff757230ULL, 0x000fe20000004100ULL, 0x00000018ff677819ULL, 0x000fe40000011643ULL,
0x0000105464637816ULL, 0x000fe40000000063ULL, 0x000010545c5f7816ULL, 0x000fe4000000005fULL,
0x00001054695e7816ULL, 0x000fe4000000005eULL, 0x0000005aff43723eULL, 0x000fe200020006ffULL,
0x20000050ff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff73737812ULL, 0x000fe200078ec0ffULL,
0x000000622418723cULL, 0x002fe20000041818ULL, 0x00000010ff5c7819ULL, 0x000fe2000001165bULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe2000001166cULL,
0x0000005e2410723cULL, 0x000fe20000041810ULL, 0x00000008ff2a7819ULL, 0x000fe2000001162aULL,
0x20000053ff747230ULL, 0x000fe20000004100ULL, 0x000000ff29297812ULL, 0x000fe200078ec0ffULL,
0x2000002bff627230ULL, 0x000fe20000004100ULL, 0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL,
0x00000073ff56723eULL, 0x000fc400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe4000001165dULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x000000ff71737812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b4b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4e7819ULL, 0x000fe40000011680ULL, 0x00000008ff717819ULL, 0x000fc40000011681ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x000010545c5b7816ULL, 0x000fe4000000005bULL, 0x0000002aff5c723eULL, 0x000fe400020006ffULL,
0x00000029ff5e723eULL, 0x000fe400020006ffULL, 0x0000006fff53723eULL, 0x000fe200020006ffULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000006dff6f723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000004cff4c723eULL, 0x000fe200020006ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x2000004cff657230ULL, 0x000fe20000004100ULL, 0x0000004eff6d723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe200020006ffULL,
0x20000051ff707230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x000010546b5a7816ULL, 0x000fe2000000005aULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x00000067ff45723eULL, 0x000fe200020006ffULL,
0x2000004bff677230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x000000ff3f5f7812ULL, 0x000fe200078ec0ffULL,
0x0000005a240c723cULL, 0x000fe2000004180cULL, 0x00000010ff687819ULL, 0x000fe20000011668ULL,
0x20000047ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fc40000011667ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165dULL, 0x00000010ff5b7819ULL, 0x000fe40000011661ULL,
0x00000008ff5d7819ULL, 0x000fe40000011640ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff707819ULL, 0x000fe40000011670ULL, 0x00000010ff6e7819ULL, 0x000fc4000001166eULL,
0x00000010ff6f7819ULL, 0x000fe4000001166fULL, 0x00000010ff6d7819ULL, 0x000fe4000001166dULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff407819ULL, 0x000fe40000011659ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff617819ULL, 0x000fe40000011662ULL, 0x00000010ff3f7819ULL, 0x000fc4000001165cULL,
0x0000105468677816ULL, 0x000fe40000000067ULL, 0x0000105466667816ULL, 0x000fe40000000065ULL,
0x00001054706f7816ULL, 0x000fe4000000006fULL, 0x000010546d6e7816ULL, 0x000fe4000000006eULL,
0x0000105474737816ULL, 0x000fe20000000073ULL, 0x000000662414723cULL, 0x000fe20000041814ULL,
0x0000105471727816ULL, 0x000fc40000000072ULL, 0x00001054765b7816ULL, 0x000fe4000000005bULL,
0x000010545a5a7816ULL, 0x000fe40000000075ULL, 0x0000105440617816ULL, 0x000fe20000000061ULL,
0x0000006e2408723cULL, 0x000fe20000041808ULL, 0x000010543f607816ULL, 0x000fe40000000060ULL,
0x00000010ff477819ULL, 0x000fe40000011647ULL, 0x00000010ff587819ULL, 0x000fc40000011658ULL,
0x000000ff77777812ULL, 0x000fe200078ec0ffULL, 0x000000722404723cULL, 0x040fe20000041804ULL,
0x0000105447597816ULL, 0x000fe40000000058ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff477819ULL, 0x000fe40000011653ULL, 0x00000077ff4d723eULL, 0x000fe200020006ffULL,
0x0000005a2420723cULL, 0x000fe20000041820ULL, 0x00000010ff427819ULL, 0x000fc40000011642ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x00000078ff49723eULL, 0x000fe400020006ffULL, 0x00000079ff51723eULL, 0x000fe200020006ffULL,
0x00000060241c723cULL, 0x000fe2000004181cULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x00000008ff3b7819ULL, 0x000fe2000001163bULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x000000ff3a3a7812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fc40000011643ULL,
0x00000010ff257819ULL, 0x000fe40000011654ULL, 0x0000105424477816ULL, 0x000fe40000000047ULL,
0x0000105425467816ULL, 0x000fe40000000046ULL, 0x00000010ff257819ULL, 0x000fe40000011656ULL,
0x00000010ff247819ULL, 0x000fe40000011655ULL, 0x0000105442257816ULL, 0x000fe20000000025ULL,
0x000000462814723cULL, 0x002fe20000041814ULL, 0x0000105424247816ULL, 0x000fc40000000041ULL,
0x00000010ff267819ULL, 0x000fe40000011645ULL, 0x00000010ff457819ULL, 0x000fe4000001164dULL,
0x00000008ff3c7819ULL, 0x000fe2000001163cULL, 0x000000242810723cULL, 0x000fe20000041810ULL,
0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3e7819ULL, 0x000fe4000001163eULL,
0x0000105426457816ULL, 0x000fc40000000045ULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x00000010ff267819ULL, 0x000fe40000011649ULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x2000003bff3b7230ULL, 0x000fe20000004100ULL, 0x00000010ff257819ULL, 0x000fe4000001165eULL,
0x00000010ff247819ULL, 0x000fe4000001165dULL, 0x0000007cff4c723eULL, 0x000fc400020006ffULL,
0x0000003aff3a723eULL, 0x000fe400020006ffULL, 0x0000007aff4a723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000007bff4b723eULL, 0x000fe200020006ffULL,
0x2000003aff3a7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000007eff50723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000007fff4f723eULL, 0x000fe200020006ffULL,
0x2000007dff4e7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000050ff507230ULL, 0x000fe20000004100ULL, 0x0000003cff3c723eULL, 0x000fe200020006ffULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000105426257816ULL, 0x000fe20000000025ULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000105424247816ULL, 0x000fe20000000051ULL,
0x2000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fc40000011644ULL,
0x00000010ff277819ULL, 0x000fe40000011652ULL, 0x00000010ff267819ULL, 0x000fe2000001163bULL,
0x000000242808723cULL, 0x040fe20000041808ULL, 0x0000105427447816ULL, 0x000fe40000000044ULL,
0x00000010ff3b7819ULL, 0x000fe4000001164cULL, 0x00000010ff3a7819ULL, 0x000fe4000001163aULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x00000044280c723cULL, 0x000fe2000004180cULL,
0x00000010ff577819ULL, 0x000fc40000011657ULL, 0x00000010ff4a7819ULL, 0x000fe4000001164aULL,
0x00000010ff277819ULL, 0x000fe4000001165fULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff4e7819ULL, 0x000fe4000001164eULL, 0x00000010ff257819ULL, 0x000fe4000001163cULL,
0x00000010ff507819ULL, 0x000fc40000011650ULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x00000010ff3e7819ULL, 0x000fe4000001163eULL,
0x000010543b3b7816ULL, 0x000fe4000000003aULL, 0x0000105457587816ULL, 0x000fe40000000048ULL,
0x000010544a277816ULL, 0x000fc40000000027ULL, 0x0000105426267816ULL, 0x000fe4000000004bULL,
0x00001054253a7816ULL, 0x000fe2000000004eULL, 0x000000582818723cULL, 0x000fe20000041818ULL,
0x00001054503f7816ULL, 0x000fe4000000003dULL, 0x000010543e3e7816ULL, 0x000fca000000004fULL,
0x000000262804723cULL, 0x040ff00000041804ULL, 0x0000003a2820723cULL, 0x040ff00000041820ULL,
0x0000003e281c723cULL, 0x000fe2000004181cULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff007224ULL, 0x000fe200078e0036ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdcf000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000032247f8cULL, 0x000fe2000c80043fULL,
0x0000001931197220ULL, 0x040fe20000410000ULL, 0x0000001131117220ULL, 0x040fe20000410000ULL,
0x0000001231297220ULL, 0x040fe20000410000ULL, 0x0000040032277984ULL, 0x000e620000000800ULL,
0x00000013312a7220ULL, 0x040fe20000410000ULL, 0x0000001d311d7220ULL, 0x040fe20000410000ULL,
0x0000001831187220ULL, 0x040fe20000410000ULL, 0x0000001431147220ULL, 0x040fe20000410000ULL,
0x0000001531157220ULL, 0x040fe20000410000ULL, 0x0000001631267220ULL, 0x040fe20000410000ULL,
0x0000001731287220ULL, 0x040fe20000410000ULL, 0x0000001031107220ULL, 0x040fe20000410000ULL,
0x0000000d31127220ULL, 0x040fe20000410000ULL, 0x0000000931137220ULL, 0x040fe20000410000ULL,
0x0000000c31007220ULL, 0x040fe20000410000ULL, 0x0000000e312b7220ULL, 0x040fe20000410000ULL,
0x0000000f31377220ULL, 0x040fe20000410000ULL, 0x0000000831087220ULL, 0x040fe20000410000ULL,
0x0000000a31097220ULL, 0x040fe20000410000ULL, 0x0000000b31387220ULL, 0x040fe20000410000ULL,
0x0000000431047220ULL, 0x040fe20000410000ULL, 0x0000000531057220ULL, 0x040fe20000410000ULL,
0x0000000631067220ULL, 0x040fe20000410000ULL, 0x0000000731077220ULL, 0x040fe20000410000ULL,
0x0000002231397220ULL, 0x040fe20000410000ULL, 0x00000023313a7220ULL, 0x040fe20000410000ULL,
0x0000001c311c7220ULL, 0x040fe20000410000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0019ULL,
0x0000002031167220ULL, 0x040fe20000410000ULL, 0x0000001e313b7220ULL, 0x040fe20000410000ULL,
0x0000001f313c7220ULL, 0x040fe20000410000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0011ULL,
0x0000002131177220ULL, 0x040fe20000410000ULL, 0x000000ffff197224ULL, 0x000fe200078e001dULL,
0x0000001a311a7220ULL, 0x040fe20000410000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e0018ULL,
0x0000001b311b7220ULL, 0x000fe20000410000ULL, 0x000000ffff0c7224ULL, 0x000fc400078e0014ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0015ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0010ULL,
0x8000000027ff7812ULL, 0x002fe20007804825ULL, 0x000000ffff117224ULL, 0x000fe400078e0012ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0026ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0028ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0029ULL, 0x000000ffff207224ULL, 0x000fe400078e002aULL,
0x000000ffff107224ULL, 0x000fe400078e0000ULL, 0x000000ffff127224ULL, 0x000fe400078e0008ULL,
0x000000ffff147224ULL, 0x000fe400078e0004ULL, 0x000000ffff157224ULL, 0x000fe400078e0005ULL,
0x000000ffff187224ULL, 0x000fc400078e001cULL, 0x000000ffff217224ULL, 0x000fe400078e002bULL,
0x000000ffff227224ULL, 0x000fe400078e0037ULL, 0x000000ffff237224ULL, 0x000fe400078e0009ULL,
0x000000ffff267224ULL, 0x000fe400078e0038ULL, 0x000000ffff277224ULL, 0x000fe400078e0006ULL,
0x000000ffff287224ULL, 0x000fc400078e0007ULL, 0x000000ffff297224ULL, 0x000fe400078e0039ULL,
0x000000ffff2a7224ULL, 0x000fe200078e003aULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fe400078e003bULL,
0x000000ffff377224ULL, 0x000fe200078e003cULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x0000040032057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004301c7824ULL, 0x000fe200078e00ffULL,
0x000000340300720cULL, 0x000fc80003f05270ULL, 0xfffffff01c007812ULL, 0x000fca00078ec0ffULL,
0x000000802d007824ULL, 0x000fca00078e0200ULL, 0x00f4000000047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000230087824ULL, 0x000fe400078e00ffULL,
0x000000012c357824ULL, 0x000fc600078e0a35ULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108247812ULL, 0x040fe400078efcffULL, 0x0000000808387812ULL, 0x000fe400078efcffULL,
0x000000352400720cULL, 0x080fe40003f26070ULL, 0x0000001008247812ULL, 0x000fe400078efcffULL,
0x000000353800720cULL, 0x080fe40003f06070ULL, 0x000000352400720cULL, 0x000fc40003fc6070ULL,
0x0000001108387812ULL, 0x040fe400078efcffULL, 0x0000001808247812ULL, 0x040fe400078efcffULL,
0x000000350800720cULL, 0x080fe40003f46070ULL, 0x000000353800720cULL, 0x080fe40003fa6070ULL,
0x000000352400720cULL, 0x000fe40003f66070ULL, 0x00000009083a7812ULL, 0x000fc400078efcffULL,
0x0000001908387812ULL, 0x040fe400078efcffULL, 0x0000002008247812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x000000353a00720cULL, 0x080fe40003f86070ULL, 0x000000353800720cULL, 0x080fe40003f46070ULL,
0x000000352400720cULL, 0x000fe40003f26070ULL, 0x0000002108387812ULL, 0x040fe400078efcffULL,
0x0000002808247812ULL, 0x000fe400078efcffULL, 0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x000000353800720cULL, 0x080fe40003f06070ULL,
0x000000352400720cULL, 0x000fe40003f86070ULL, 0x0000002908387812ULL, 0x000fc400078efcffULL,
0x0000003008247812ULL, 0x000fe400078efcffULL, 0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x000000353800720cULL, 0x000fc40003fc6070ULL,
0x000000352400720cULL, 0x000fe40003fa6070ULL, 0x0000003108387812ULL, 0x040fe400078efcffULL,
0x0000003808247812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff23237808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x000000353800720cULL, 0x080fe40003f66070ULL, 0x000000352400720cULL, 0x000fc40003f46070ULL,
0x000000350800720cULL, 0x000fe40003f26070ULL, 0xff7fffff26267808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff27277808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff28287808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff29297808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff2b2b7808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff37377808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000000b04097209ULL, 0x004fe20007810000ULL,
0x0000001fff3b7424ULL, 0x000fe200078e00ffULL, 0x0000001a05047209ULL, 0x000fe20007810000ULL,
0xffffffffff3c7424ULL, 0x000fe200078e00ffULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fc40007810000ULL, 0x0000000c09087209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000000d08097209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fc40007810000ULL, 0x0000000f08097209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x0000001009087209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x0000001108097209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fc40007810000ULL, 0x0000001209087209ULL, 0x000fe40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002704057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000002805047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000002a05047209ULL, 0x000fc40007810000ULL, 0x0000001809087209ULL, 0x000fe40007810000ULL,
0x0000002b04047209ULL, 0x000fe40007810000ULL, 0x0000001908057209ULL, 0x000fe40007810000ULL,
0x0000003704357209ULL, 0x000fe20007810000ULL, 0x000017e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x0000000405397209ULL, 0x008fe20007810000ULL,
0x000018127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0035047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0007247f89ULL, 0x000f2200000e0000ULL,
0x0000000435087209ULL, 0x008fc60007810000ULL, 0x0c201f0039047f89ULL, 0x000ee200000e0000ULL,
0x0000000506097209ULL, 0x004fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ea200000e0000ULL,
0x0000002407247209ULL, 0x010fc60007810000ULL, 0x0c201f0009387f89ULL, 0x002e6800000e0000ULL,
0x0c201f0024257f89ULL, 0x00092200000e0000ULL, 0x0000000439047209ULL, 0x008fe40007810000ULL,
0x0000000508057209ULL, 0x004fe40007810000ULL, 0x0000003809067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05387820ULL, 0x002fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010838ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x00000004ff3a7e24ULL, 0x000fe2000f8e00ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3f8000003a3a783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010838ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b21217823ULL, 0x000fe20000010838ULL,
0x000000ffff3b7224ULL, 0x000fe200078e003aULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010838ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010838ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b37377823ULL, 0x000fe20000010838ULL, 0x0000000000057886ULL, 0x000fcc00038e0100ULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x0000000c0d0a723eULL, 0x008fce00000010ffULL,
0x0000001d000b7308ULL, 0x0007f00000000800ULL, 0x0000001e001e7308ULL, 0x000f620000000800ULL,
0x0000001a1b09723eULL, 0x002fe200000010ffULL, 0x0000000fff1d7424ULL, 0x008fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x020fce00000010ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000003a083c723cULL, 0x000fee00000418ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000010ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000010ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000010ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000010ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000003a0c3c723cULL, 0x000fee000004183cULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe400000010ffULL, 0xfffffffc30147812ULL, 0x000fc800078ec0ffULL,
0x000000141d1d7219ULL, 0x000fe200000006ffULL, 0x0000002700277308ULL, 0x000fe60000000800ULL,
0x000000001d1e73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f680000004000ULL,
0x0000002800287308ULL, 0x000f220000000800ULL, 0x000000232611723eULL, 0x002fce00000010ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000272813723eULL, 0x010fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000051dff7c12ULL, 0x008fe2000f80401eULL,
0x0000003a103c723cULL, 0x000fec000004183cULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000000700077308ULL, 0x000ee20000000800ULL, 0x000000161714723eULL, 0x002fce00000010ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000180716723eULL, 0x008fe400000010ffULL, 0x0000002425077209ULL, 0x004fca0007810000ULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x00000037001a7308ULL, 0x000ea20000000800ULL,
0x000000292a15723eULL, 0x002fe400000010ffULL, 0x0000002b1a17723eULL, 0x004fce00000010ffULL,
0x0000003a143c723cULL, 0x000fe2000004183cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000132204008947ULL, 0x020fde000b800000ULL, 0x001c1fff3c187589ULL, 0x0002a400000e0000ULL,
0x000000001d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000001d0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051dff7c12ULL, 0x008fda000f80401aULL,
0x0000134204008947ULL, 0x010fea000b800000ULL, 0x001c1fff3e197589ULL, 0x00072800000e0000ULL,
0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL, 0x001c1fff001b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1d7819ULL, 0x00afe40000011630ULL, 0x0000000c1c3d7812ULL, 0x000fc400078ec0ffULL,
0x000000071d1e7812ULL, 0x040fe200078ec0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x0000001dff217212ULL, 0x000fe200078e33ffULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0x0000000330ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081d3a7824ULL, 0x040fe200078e00ffULL,
0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee21eULL,
0x000000011f227812ULL, 0x100fe200078ef61eULL, 0x000000081d4a7824ULL, 0x000fe200078e00ffULL,
0x000000021f247812ULL, 0x100fe200078ef61eULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x000000031f267812ULL, 0x000fc400078ef61eULL, 0x000000041f287812ULL, 0x140fe400078ef61eULL,
0x000000051f2a7812ULL, 0x140fe400078ef61eULL, 0x000000061f387812ULL, 0x000fe200078ef61eULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee221ULL,
0x0000001dff217212ULL, 0x000fe400078e33ffULL, 0x000000071d1e7812ULL, 0x000fc400078ec0ffULL,
0x000090002d1d7811ULL, 0x000fe400078e58ffULL, 0xfffffff8233c7812ULL, 0x100fe400078ee21eULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee221ULL, 0x00000010201c7824ULL, 0x100fe200078e021dULL,
0x000000011f3e7812ULL, 0x140fe200078ef61eULL, 0x0000001024207824ULL, 0x100fe200078e021dULL,
0x000000021f407812ULL, 0x140fe200078ef61eULL, 0x0000001028247824ULL, 0x100fe200078e021dULL,
0x000000031f427812ULL, 0x140fe200078ef61eULL, 0x0000001038287824ULL, 0x100fe200078e021dULL,
0x000000041f447812ULL, 0x140fe200078ef61eULL, 0x000000103e357824ULL, 0x100fe200078e021dULL,
0x000000051f467812ULL, 0x140fe200078ef61eULL, 0x0000001040377824ULL, 0x100fe200078e021dULL,
0x000000061f487812ULL, 0x000fe200078ef61eULL, 0x00000010221e7824ULL, 0x000fc400078e021dULL,
0x0000001026227824ULL, 0x100fe400078e021dULL, 0x000000102a267824ULL, 0x100fe400078e021dULL,
0x000000013d1f7824ULL, 0x000fe400078e021cULL, 0x000000103a2a7824ULL, 0x100fe400078e021dULL,
0x000000103c1c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x0000001042387824ULL, 0x000fc400078e021dULL, 0x0000001044397824ULL, 0x100fe400078e021dULL,
0x00000010463a7824ULL, 0x100fe400078e021dULL, 0x00000010483b7824ULL, 0x100fe400078e021dULL,
0x000000104a3c7824ULL, 0x000fe400078e021dULL, 0x000000013d1d7824ULL, 0x040fe400078e021eULL,
0x000000013d217824ULL, 0x000fc400078e0220ULL, 0x000000013d237824ULL, 0x040fe200078e0222ULL,
0x0000000a1d007388ULL, 0x0007e20000000800ULL, 0x000000013d257824ULL, 0x040fe400078e0224ULL,
0x000000013d277824ULL, 0x040fe200078e0226ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x000000013d297824ULL, 0x040fe400078e0228ULL, 0x000000013d2b7824ULL, 0x040fe200078e022aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x000000013d1c7824ULL, 0x000fc400078e021cULL,
0x000000013d1e7824ULL, 0x040fe200078e0235ULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x000000013d207824ULL, 0x040fe400078e0237ULL, 0x000000013d387824ULL, 0x040fe200078e0238ULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x000000013d087824ULL, 0x042fe400078e0239ULL,
0x000000013d3a7824ULL, 0x040fe200078e023aULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x000000013d227824ULL, 0x000fc400078e023bULL, 0x000000013d3c7824ULL, 0x000fe200078e023cULL,
0x000000162b007388ULL, 0x0007e80000000800ULL, 0x000000091c007388ULL, 0x0007e80000000800ULL,
0x0000000b1e007388ULL, 0x0007e80000000800ULL, 0x0000000d20007388ULL, 0x0007e80000000800ULL,
0x0000000f38007388ULL, 0x0007e80000000800ULL, 0x0000001108007388ULL, 0x0007e80000000800ULL,
0x000000133a007388ULL, 0x0007e80000000800ULL, 0x0000001522007388ULL, 0x0007e80000000800ULL,
0x000000173c007388ULL, 0x0007e80000000800ULL, 0x00f0000400008388ULL, 0x0007e80000000c00ULL,
0x00f2001800008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000033ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080033ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100033ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030003037a10ULL, 0x000fe20007ffe0ffULL, 0x0000180033ff7f8cULL, 0x0003e6000c80043fULL,
0x000000020300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc13000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff247807ULL, 0x010fe40004000000ULL, 0x0001331000297802ULL, 0x000fe40000000f00ULL,
0x00000f3000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0028ULL,
0xfffee3b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004000000ULL,
0x0001336000297802ULL, 0x000fe40000000f00ULL, 0x00000ee000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0028ULL, 0xfffee3f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0000ULL, 0x000133d000247802ULL, 0x008fe20000000f00ULL,
0x0000001fff537424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fc400078e00ffULL,
0x00000e3000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e002aULL,
0xfffee44000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x002fe200078e0000ULL,
0x0001344000247802ULL, 0x008fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fc400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000dc000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xfffee40000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x000fe200078e0026ULL, 0x000134b000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff537424ULL, 0x000fe400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x00000d5000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff4f7224ULL, 0x004fe200078e002aULL,
0xfffee76000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x002fe200078e0040ULL,
0x0001352000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fc400078e00ffULL, 0x00000ce000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xfffee72000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x010fe40004000000ULL, 0x0001357000297802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff09d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004000000ULL,
0x000135c000297802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff0a1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff537424ULL, 0x008fe200078e00ffULL, 0x0001362000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff547424ULL, 0x000fc400078e00ffULL, 0x00000be000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff0a8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x00afe200078e0040ULL, 0x0001369000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff537424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x00000b7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xffff0b3000007947ULL, 0x000fea000383ffffULL, 0x0000001fff537424ULL, 0x000fe200078e00ffULL,
0x000136f000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x00000b1000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff637224ULL, 0x004fe200078e002aULL,
0xffff0df000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x002fe200078e0040ULL,
0x0001376000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x00000aa000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xffff0da000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x002fe40004000000ULL, 0x000137b000297802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff2c2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004000000ULL,
0x0001380000297802ULL, 0x000fc40000000f00ULL, 0x00000a4000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff2c6000007947ULL, 0x000fea000383ffffULL,
0x0000001fff537424ULL, 0x002fe200078e00ffULL, 0x0001386000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff547424ULL, 0x000fc400078e00ffULL, 0x000009a000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff2cd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x002fe200078e0040ULL, 0x000138d000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff537424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000093000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xffff2d8000007947ULL, 0x000fea000383ffffULL, 0x0000001fff537424ULL, 0x000fe200078e00ffULL,
0x0001393000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x000008d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff497224ULL, 0x004fe200078e002aULL,
0xffff303000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x002fe200078e0040ULL,
0x000139a000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000086000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xffff2fe000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x010fe40004000000ULL, 0x000139f000297802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0xffff4ea000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004000000ULL,
0x00013a4000297802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0028ULL, 0xffff4ee000007947ULL, 0x000fea000383ffffULL,
0x0000001fff537424ULL, 0x008fe200078e00ffULL, 0x00013aa000247802ULL, 0x000fe20000000f00ULL,
0xffffffffff547424ULL, 0x000fc400078e00ffULL, 0x0000076000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e002aULL, 0xffff4f5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff527224ULL, 0x00afe200078e0040ULL, 0x00013b1000247802ULL, 0x000fe20000000f00ULL,
0x0000001fff537424ULL, 0x000fc400078e00ffULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x000006f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e002aULL,
0xffff500000007947ULL, 0x000fea000383ffffULL, 0x0000001fff537424ULL, 0x000fe200078e00ffULL,
0x00013b7000247802ULL, 0x000fe20000000f00ULL, 0xffffffffff547424ULL, 0x000fe400078e00ffULL,
0x0000069000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e002aULL,
0xffff52c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff527224ULL, 0x002fe200078e0040ULL,
0x00013be000247802ULL, 0x000fe20000000f00ULL, 0x0000001fff537424ULL, 0x000fe400078e00ffULL,
0xffffffffff547424ULL, 0x000fe400078e00ffULL, 0x0000062000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e002aULL, 0xffff527000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0005ULL, 0x00013c4000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x000fc400078e00ffULL, 0x0000058000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0025ULL, 0xffffe7d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0035ULL, 0x00013ca000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x002fc400078e00ffULL, 0x0000052000007944ULL, 0x004fea0003c00000ULL,
0x00000025353a7209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x00013cf000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x002fc400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0007ULL, 0x00013d4000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x002fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002507247209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0039ULL,
0x00013d9000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002539047209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e003aULL, 0x00013de000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x000000253a057209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x00013e3000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x00013e8000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffe69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e003cULL,
0x00013ef000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff527224ULL, 0x000fc400078e00ffULL,
0x00001c1fff537424ULL, 0x000fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fe400078e001dULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e002aULL,
0xffffec7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x002fe200078e003eULL,
0x00013f7000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff527224ULL, 0x000fe400078e00ffULL,
0x00001c1fff537424ULL, 0x000fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fe400078e001dULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff527224ULL, 0x002fe200078e00ffULL,
0x00013fd000247802ULL, 0x000fe20000000f00ULL, 0x00001c1fff537424ULL, 0x000fc400078e00ffULL,
0x000000ffff547224ULL, 0x000fe400078e001dULL, 0x000000ffff197224ULL, 0x004fe400078e002aULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff547224ULL, 0x002fe200078e001dULL,
0x0001403000247802ULL, 0x000fe20000000f00ULL, 0x000000ffff527224ULL, 0x000fe400078e00ffULL,
0x00001c1fff537424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e002aULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e002aULL,
0xffffebb000007947ULL, 0x000fea000383ffffULL, 0x0180000031037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000003100038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000304ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff31ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000304ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000031047812ULL, 0x000fd600078ec0ffULL, 0x0080000004030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003100037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffebe4006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x0c00003825257389ULL, 0x0002a200000e003bULL, 0xfffebe0008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff257424ULL, 0x000fe200078e00ffULL, 0x0000005400007348ULL, 0x000fe80003800000ULL,
0x000000522b2a7389ULL, 0x0002a200000e0053ULL, 0xfffebdc024007950ULL, 0x000fea0003c3ffffULL,
0x000000012400780cULL, 0x000fe20003f05070ULL, 0x0000003f00007348ULL, 0x000fe80003800000ULL,
0x00000000ff257424ULL, 0x000fd000078e00ffULL, 0x0000000000247806ULL, 0x000fc800040e0100ULL,
0x0000003f24287212ULL, 0x000fe200078ec0ffULL, 0x000000ffff247224ULL, 0x000fc800078e0029ULL,
0xfffebd5024007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000488ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a68ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000af8ULL, 0x0000000000000880ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001378ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001398ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013a8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000013c8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001458ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001460ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001470ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000014380ULL, 0xa700001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015a00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000015a10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015a10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015e90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001458ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000145a8ULL, 0x00000000000145a8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015e90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_8_m_8_sm_89_cubin_len = 89968;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
