/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000014c90ULL, 0x0000000000014810ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x00000000000133c0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000013530ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000013570ULL, 0x0000000000000110ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000013680ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000133c000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x004c4c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808c92ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000133c000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0xad08288080900828ULL, 0x288080b608288080ULL, 0x80ae08288080ba08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080ae9200ULL, 0x0000001cffffffffULL,
0x000000e000000000ULL, 0x0001353000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0xad08288080900828ULL, 0x288080ae08288080ULL,
0x80b608288080ba08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b69200ULL,
0x0000001cffffffffULL, 0x0000016800000000ULL, 0x0001357000000000ULL, 0x0000011000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x000812040000009fULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0050190300500160ULL, 0x00000000000c1704ULL,
0x0021f00000480007ULL, 0x00000000000c1704ULL, 0x0021f00000400006ULL, 0x00000000000c1704ULL,
0x0021f00000380005ULL, 0x00000000000c1704ULL, 0x0011f00000300004ULL, 0x00000000000c1704ULL,
0x0061f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL,
0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0018310400ff1b03ULL,
0x000127b000012460ULL, 0x00012830000127c0ULL, 0x0001285000012840ULL, 0xffffffff00e82904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500000fffffffffULL,
0x0500000f0500000fULL, 0xffffffff0500000fULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x00e82804ffffffffULL, 0x000000f000000090ULL, 0x000016c000001610ULL, 0x0000177000001740ULL,
0x000026a000002670ULL, 0x00003e4000003da0ULL, 0x00003ef000003ec0ULL, 0x00004d8000004d40ULL,
0x0000620000006160ULL, 0x000062b000006280ULL, 0x000071d000007190ULL, 0x00008570000084e0ULL,
0x00008620000085e0ULL, 0x00008e4000008a30ULL, 0x0000a3600000a350ULL, 0x0000ce400000ce20ULL,
0x0000d3400000d320ULL, 0x000120d0000120a0ULL, 0x000120f0000120e0ULL, 0x0001213000012110ULL,
0x0001216000012150ULL, 0x0001288000012820ULL, 0x000128a000012890ULL, 0x00012f4000012ed0ULL,
0x0001300000012fa0ULL, 0x000130a000013050ULL, 0x00013140000130f0ULL, 0x000131e000013190ULL,
0x000132d000013250ULL, 0x0001339000013330ULL, 0x0000016003e03904ULL, 0x0000f600000000ffULL,
0x000001a0003f0100ULL, 0x0000f6080000000fULL, 0x000001d0003f0130ULL, 0x0000f6100000000fULL,
0x00000200003f0130ULL, 0x0000f6480000000fULL, 0x00000230003f0120ULL, 0x0000f6680000000fULL,
0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000730003f0107ULL, 0x0000f61400000004ULL,
0x00000a40003f0102ULL, 0x0000f61000000004ULL, 0x00000b80003f0101ULL, 0x00000000000000ffULL,
0x00000c1000040107ULL, 0x000000200000000fULL, 0x00000d60003f0101ULL, 0x000000240000000fULL,
0x00000e00003f0106ULL, 0x000000240000000fULL, 0x00000e90003f0106ULL, 0x000000240000000fULL,
0x000013b0003f0106ULL, 0x000000000000005fULL, 0x0000142000060107ULL, 0x000000040000001eULL,
0x0000144000060106ULL, 0x0000f60c00000013ULL, 0x00001540003f0106ULL, 0x0000f60c00000013ULL,
0x000019f0003f0106ULL, 0x000000040000001eULL, 0x00001a9000060106ULL, 0x000000040000001eULL,
0x0000343000060106ULL, 0x000000200000000fULL, 0x000034b0003f0101ULL, 0x000000000000001bULL,
0x00003560003f0101ULL, 0x000000240000000fULL, 0x000035b0003f0106ULL, 0x000000240000000fULL,
0x00003640003f0106ULL, 0x000000240000000fULL, 0x00003b60003f0106ULL, 0x00000000000000ffULL,
0x00003bd000050107ULL, 0x0000000400000054ULL, 0x00003bf0003f0106ULL, 0x0000f61c00000013ULL,
0x00003d00003f0106ULL, 0x0000f61c00000013ULL, 0x000041c0003f0106ULL, 0x0000f64c0000001dULL,
0x00004250003f0106ULL, 0x0000f64c0000001dULL, 0x000059f0003f0106ULL, 0x000000200000000fULL,
0x00005a70003f0101ULL, 0x000000000000001cULL, 0x00005b10003f0101ULL, 0x000000240000000fULL,
0x00005b70003f0106ULL, 0x000000240000000fULL, 0x00005c00003f0106ULL, 0x000000240000000fULL,
0x00005f10003f0106ULL, 0x000000000000005fULL, 0x00005f8000060107ULL, 0x0000f64c00000048ULL,
0x00005fa0003f0106ULL, 0x0000f62c00000013ULL, 0x000060c0003f0106ULL, 0x0000f62c00000013ULL,
0x00006590003f0106ULL, 0x0000f64c0000001eULL, 0x00006640003f0106ULL, 0x0000f64c0000001eULL,
0x00007dd0003f0106ULL, 0x000000200000000fULL, 0x00007e50003f0101ULL, 0x000000000000001cULL,
0x00007ef0003f0101ULL, 0x000000240000000fULL, 0x00007f40003f0106ULL, 0x000000240000000fULL,
0x00007fd0003f0106ULL, 0x000000240000000fULL, 0x000082d0003f0106ULL, 0x00000000000000ffULL,
0x0000834000050107ULL, 0x0000000400000054ULL, 0x00008360003f0106ULL, 0x0000f63c00000013ULL,
0x00008440003f0106ULL, 0x0000f63c00000013ULL, 0x00008900003f0106ULL, 0x0000f64c00000015ULL,
0x00008990003f0106ULL, 0x0000f64c00000015ULL, 0x0000a080003f0106ULL, 0x000000200000000fULL,
0x0000a0e0003f0101ULL, 0x0000f64000000013ULL, 0x0000ed20003f0101ULL, 0x0000f604000000ffULL,
0x0000edb0003f0106ULL, 0x0000f604000000ffULL, 0x0000efd0003f0106ULL, 0x0000f600000000ffULL,
0x0000efe0003f0101ULL, 0x0000f604000000ffULL, 0x0000f060003f0106ULL, 0x0000f604000000ffULL,
0x000115a0003f0106ULL, 0x0000f61400000032ULL, 0x00011980003f0106ULL, 0x0000f61400000032ULL,
0x00012e20003f0106ULL, 0x0000f60800000032ULL, 0x00053803003f0101ULL, 0x0000dd5000141c04ULL,
0x0000f0b00000e1a0ULL, 0x00012e800000f150ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001dcULL, 0x0000001100000002ULL, 0x0000000000000154ULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001b9ULL, 0x0000001100000002ULL, 0x0000000000000131ULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000000000077919ULL, 0x000ea80000002100ULL,
0x0000000000107919ULL, 0x000ee80000002700ULL, 0x00000000001b7919ULL, 0x000f220000002600ULL,
0x000000010e007824ULL, 0x002fc600078e0203ULL, 0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL,
0x00000080000f7824ULL, 0x104fe200078e0207ULL, 0x00000005ff1a7819ULL, 0x000fe20000011607ULL,
0x0000600010067625ULL, 0x008fc600078e0011ULL, 0x000000ff0f00720cULL, 0x040fe40003f05270ULL,
0x000000030f00780cULL, 0x040fe20003f44070ULL, 0x00001fff1a1a7589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe40003f24070ULL, 0x000000010f00780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff05a424ULL, 0x000fe200078e00ffULL,
0x00f60002ff008388ULL, 0x0007e20000000a00ULL, 0x000000ff0e00720cULL, 0x002fe20003f05270ULL,
0x3fffff80ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f608040f00a388ULL, 0x0007e2000000ca00ULL, 0x3fffffc0ff08a424ULL, 0x000fc400078e00ffULL,
0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL, 0x00f6100a0f00a388ULL, 0x0007e2000000ca00ULL,
0xff317217ff009424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0cb424ULL, 0x000fe200078e00ffULL,
0x00f648080f00a388ULL, 0x0007e20000008a00ULL, 0x7fffffc0ff0db424ULL, 0x000fc600078e00ffULL,
0x00f400000f009388ULL, 0x0007e80000004800ULL, 0x00f6680c0f00b388ULL, 0x0007e80000008a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000027000000947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x01ce620000000000ULL, 0x000000041a027824ULL, 0x000fc400078e00ffULL,
0x00005800ff007624ULL, 0x000fe400078e00ffULL, 0x000000101b037824ULL, 0x000fe400078e00ffULL,
0x0000001000007824ULL, 0x000fe400078e00ffULL, 0x00000100ff057424ULL, 0x000fe400078e00ffULL,
0x0000001000007224ULL, 0x000fe200078e0203ULL, 0x000000020d097211ULL, 0x042fe200078fe0ffULL,
0x000000100d037824ULL, 0x000fc600078e00ffULL, 0x00000002090b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100027824ULL, 0x040fe200078e0209ULL, 0x000000f0030f7812ULL, 0x000fe400078ec0ffULL,
0x000000070b087812ULL, 0x000fe200078ec0ffULL, 0x0000000100047824ULL, 0x000fe200078e020bULL,
0x0000000709007812ULL, 0x000fe200078ec0ffULL, 0x00005c0002027625ULL, 0x080fe200078e0005ULL,
0x0000000f08087812ULL, 0x100fe400078e780dULL, 0x0000000f00007812ULL, 0x000fe200078e780dULL,
0x00005c0004047625ULL, 0x000fe200078e0005ULL, 0x0000000f02027210ULL, 0x000fc60007f1e0ffULL,
0x0000001009007824ULL, 0x000fe200078e0200ULL, 0x0000000f04047210ULL, 0x000fe20007f3e0ffULL,
0x000000100b087824ULL, 0x000fe400078e0208ULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001000097824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x00000010080b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e8000b901c48ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806007981ULL, 0x01cea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x00000004ff197e24ULL, 0x008fe2000f8e00ffULL, 0x000000ff00027810ULL, 0x006fc80007ffe0ffULL,
0x00000008ff027819ULL, 0x000fce0000011602ULL, 0x0000dc7000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x000058001b067a10ULL, 0x000fe20007ffe0ffULL,
0x0000000210057824ULL, 0x000fe200078e00ffULL, 0x0000000119077810ULL, 0x000fe20007ffe0ffULL,
0x000000101a047824ULL, 0x000fe400078e00ffULL, 0x0000580005057a24ULL, 0x000fe200078e0206ULL,
0x00000001ff067819ULL, 0x000fe2000001161aULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000001004087812ULL, 0x000fe400078ec0ffULL, 0x000000020700720cULL, 0x000fe20003f06070ULL,
0x0000000819077824ULL, 0x000fe200078e0206ULL, 0x00000003ff147819ULL, 0x002fc80000011603ULL,
0x0000000414167810ULL, 0x000fe20007ffe0ffULL, 0x00000001080e7824ULL, 0x000fe200078e0214ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000080e0a7824ULL, 0x040fe200078e00ffULL,
0x000000030e097212ULL, 0x080fe200078e3cffULL, 0x0000000108107824ULL, 0x000fe200078e0216ULL,
0x0000000814187810ULL, 0x000fe20007ffe0ffULL, 0x0000002007077824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0b7812ULL, 0x000fe200078ee209ULL, 0x00000008100f7824ULL, 0x040fe200078e00ffULL,
0x00000003100c7212ULL, 0x000fe200078e3cffULL, 0x0000620005097a24ULL, 0x100fe200078e0207ULL,
0x00000007000a7217ULL, 0x000fe20007800000ULL, 0x0000000108127824ULL, 0x000fe200078e0218ULL,
0x0000000c141c7810ULL, 0x000fe20007ffe0ffULL, 0x00f6140d04ff738cULL, 0x0003e20000000000ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL, 0x000000010a0c7824ULL, 0x000fe200078e0a07ULL,
0x00000000060473c2ULL, 0x0004e200000e0000ULL, 0x00000001081e7824ULL, 0x000fc400078e021cULL,
0x0000200006077824ULL, 0x000fe400078e00ffULL, 0x00000001090a7824ULL, 0x040fe400078e020eULL,
0x00000001090d7824ULL, 0x002fe200078e0210ULL, 0x0000b000070e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109107824ULL, 0x040fe400078e0212ULL, 0x0000000109117824ULL, 0x000fe200078e021eULL,
0x0000000312097212ULL, 0x0c0fe200078e3cffULL, 0x0000000812227824ULL, 0x000fe200078e00ffULL,
0x000000031e127212ULL, 0x040fe200078e3cffULL, 0x000000081e137824ULL, 0x000fc400078e00ffULL,
0x00000080ff207424ULL, 0x000fe200078e00ffULL, 0xfffffff822097812ULL, 0x000fe200078ee209ULL,
0x00000010031f7824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee212ULL,
0x000000100b157824ULL, 0x000fe400078e020eULL, 0x00005e000a0a7625ULL, 0x000fe200078e0020ULL,
0x000000701f1f7812ULL, 0x000fc600078ec0ffULL, 0x00000010091b7824ULL, 0x100fe200078e020eULL,
0x000000200c097807ULL, 0x000fe20000000000ULL, 0x000000100f177824ULL, 0x100fe200078e020eULL,
0x0000001f0a127210ULL, 0x000fe20007f1e0ffULL, 0x00000010131d7824ULL, 0x000fe200078e020eULL,
0x0000000809097217ULL, 0x000fe20007800000ULL, 0x00005e00100e7625ULL, 0x000fc800078e0020ULL,
0x00005e000d0c7625ULL, 0x000fe200078e0020ULL, 0x0000001f0e0e7210ULL, 0x000fc60007f3e0ffULL,
0x00005e0011107625ULL, 0x000fc800078e0020ULL, 0x000000ffff137224ULL, 0x000fe200000e060bULL,
0x0000001f0c0c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a08ULL,
0x0000001f10107210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe400008e060fULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000091400720cULL, 0x080fe20003f06070ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000091600720cULL, 0x080fe40003f26070ULL,
0x000000091800720cULL, 0x000fc40003f46070ULL, 0x000000091c00720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x00cfec0000008000ULL, 0x0000f64804047891ULL, 0x000fe2000f8e203fULL,
0x00f6100004ff7f8cULL, 0x0003e2000c80043fULL, 0x000000011a097812ULL, 0x000fe200078ec0ffULL,
0xff317217ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012157faeULL, 0x0003e2000c101c48ULL,
0x000000021900720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000000c177faeULL, 0x0003e2000c901c48ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000000e1b7faeULL, 0x0005e2000d101c48ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x00000000101d7faeULL, 0x0003e8000d901c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000f648060f7811ULL, 0x004fe200078e18ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000020000fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000094f000000947ULL, 0x000fea0003800000ULL,
0xff317217ff0a7424ULL, 0x004fe200078e00ffULL, 0x00007610ff4d7816ULL, 0x000fe2000000004dULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x00007610ff4e7816ULL, 0x000fe2000000004eULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x00007610ff107816ULL, 0x002fc40000000010ULL,
0xffffffc0040c7812ULL, 0x000fca00078ec0ffULL, 0x00000100190d7824ULL, 0x000fca00078e020cULL,
0x000000000d00720cULL, 0x000fda0003f06070ULL, 0x000093f000000947ULL, 0x002fea0003800000ULL,
0x000024000f0d7984ULL, 0x000e620000000800ULL, 0x0000ffff4d067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fc600078e004cULL, 0x00008880060c7816ULL, 0x000fca00000000ffULL,
0x800000000c067824ULL, 0x000fca00078e00ffULL, 0x800000000dff7812ULL, 0x002fe20007804806ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000076104e627816ULL, 0x000fe40000000062ULL,
0x000076104d127816ULL, 0x000fe20000000012ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x000024000f0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000c0d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x00000006000c7305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x0000000c0000735dULL, 0x004fe40003800000ULL, 0x000024000f0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fc4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000003ff177819ULL, 0x000fe20000011603ULL,
0x00000100195d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fe2000001161aULL,
0x0000001003207824ULL, 0x000fe200078e00ffULL, 0x0000000417217810ULL, 0x040fe20007ffe0ffULL,
0x00000001080e7824ULL, 0x000fe200078e0217ULL, 0x0000000817227810ULL, 0x000fe20007ffe0ffULL,
0x00000020060c7824ULL, 0x000fe200078e025dULL, 0x00000001190d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108147824ULL, 0x000fe200078e0221ULL, 0x000000030e137212ULL, 0x0c0fe200078e3cffULL,
0x000000080e167824ULL, 0x000fe200078e00ffULL, 0x000000400c0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008141c7824ULL, 0x040fe200078e00ffULL, 0x0000000314157212ULL, 0x000fe200078e3cffULL,
0x00000000060673c2ULL, 0x000e6200000e0000ULL, 0xfffffff8165b7812ULL, 0x000fe200078ee213ULL,
0x000010004c137824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1d7812ULL, 0x000fe200078ee215ULL,
0x0000000108157824ULL, 0x000fe200078e0222ULL, 0x000000020d00720cULL, 0x000fc40003f06070ULL,
0x0000000c000d7217ULL, 0x000fe20007800000ULL, 0x00000008151e7824ULL, 0x000fe200078e00ffULL,
0x0000000c17237810ULL, 0x000fe40007ffe0ffULL, 0x0000100013137812ULL, 0x000fe200078e0cffULL,
0x000000010d0d7824ULL, 0x100fe200078e0a0cULL, 0x00000003151b7212ULL, 0x000fe200078e3cffULL,
0x00006200050c7a24ULL, 0x000fe200078e020cULL, 0x00000070201f7812ULL, 0x000fe200078ec0ffULL,
0x0000000108167824ULL, 0x000fe200078e0223ULL, 0xfffffff81e597812ULL, 0x000fe200078ee21bULL,
0x0000200006137824ULL, 0x000fc400078e0213ULL, 0x000000084c1e7824ULL, 0x000fe200078e00ffULL,
0x00000003161c7212ULL, 0x000fe200078e3cffULL, 0x000000010e0e7824ULL, 0x100fe200078e020cULL,
0x0000b00013587810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff1b7424ULL, 0x000fe200078e00ffULL,
0x000000200d137807ULL, 0x000fe20000000000ULL, 0x0000000816457824ULL, 0x000fe200078e00ffULL,
0x000000081e5f7812ULL, 0x000fe200078e0cffULL, 0x0000000114147824ULL, 0x100fe200078e020cULL,
0x0000001308137217ULL, 0x000fe20007800000ULL, 0x0000000115157824ULL, 0x000fe200078e020cULL,
0xfffffff845457812ULL, 0x000fe200078ee21cULL, 0x0000000116167824ULL, 0x000fe200078e020cULL,
0x000000005f0473c2ULL, 0x000ea200000e0000ULL, 0x00005e000e0c7625ULL, 0x000fe200078e001bULL,
0x0000f64806067891ULL, 0x002fc6000f8e203fULL, 0x000000101d5a7824ULL, 0x000fe200078e0258ULL,
0x0000001f0c1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000113137824ULL, 0x000fe400078e0a08ULL,
0x000000105b5b7824ULL, 0x000fe400078e0258ULL, 0x000000ffff1d7224ULL, 0x000fe200000e060dULL,
0x000000131700720cULL, 0x000fe20003f06070ULL, 0x00005e00140c7625ULL, 0x000fe200078e001bULL,
0x000000132100720cULL, 0x080fe40003f26070ULL, 0x000000132200720cULL, 0x000fe20003f46070ULL,
0x00005e0015147625ULL, 0x000fe200078e001bULL, 0x0000001f0c0c7210ULL, 0x000fc60007f7e0ffULL,
0x00005e0016167625ULL, 0x000fe200078e001bULL, 0x0000001f14147210ULL, 0x000fe20007f9e0ffULL,
0x0000000406047290ULL, 0x004fe4000fffe03fULL, 0x000000ffff0d7224ULL, 0x000fe200018e060dULL,
0x000000132300720cULL, 0x000fe20003f66070ULL, 0x0000001059597824ULL, 0x100fe200078e0258ULL,
0x0000001f16167210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200020e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c5b7faeULL, 0x0003e2000c101c48ULL,
0x0000001045587824ULL, 0x000fc400078e0258ULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x000000000c5a7faeULL, 0x0003e2000c901c48ULL, 0x000000041a137824ULL, 0x000fc600078e00ffULL,
0x0000000014597faeULL, 0x0003e4000d101c48ULL, 0xfffffff013137812ULL, 0x000fe400078ec0ffULL,
0x0000000016587faeULL, 0x0003e8000d901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004061e157984ULL, 0x0022a20008000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f60c00130e7984ULL, 0x000ee20000000800ULL, 0x0000ffff4e0c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff100d7812ULL, 0x000fe400078ec0ffULL, 0x000088800c1f7816ULL, 0x000fe400000000ffULL,
0x000088800d147816ULL, 0x000fc600000000ffULL, 0x800000001f0c7824ULL, 0x000fe400078e00ffULL,
0x80000000140d7824ULL, 0x000fc600078e00ffULL, 0x8000000015ff7812ULL, 0x004fe4000780480cULL,
0x800000000eff7812ULL, 0x008fe2000782480dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fe400078e00ffULL,
0x80000000140e7824ULL, 0x000fe400078e00ffULL, 0x0000000c000d7305ULL, 0x0004e4000021f000ULL,
0x3fa000000c0c7823ULL, 0x004fe200000100ffULL, 0x0000000d0000735dULL, 0x008fe40003800000ULL,
0x00f60c00130d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fc4000782480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000201a167824ULL, 0x000fe200078e00ffULL, 0x00000001ff177819ULL, 0x000fe40000011603ULL,
0x0000007020157812ULL, 0x000fe400078ec0ffULL, 0xffffff8016167812ULL, 0x000fe400078ec0ffULL,
0x0000000c17177812ULL, 0x000fc800078ec0ffULL, 0x00000016170c7210ULL, 0x000fca0007ffe015ULL,
0x00f000000c0d7984ULL, 0x000ea80000000800ULL, 0x00f200000c0e7984ULL, 0x0007220000000800ULL,
0x0000000a0d00720bULL, 0x004fda0003f3d000ULL, 0x00000000001b7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1b207812ULL, 0x000fe2000782c0ffULL, 0x00000001ff1b7424ULL, 0x000fd800078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x0000000a0d00720bULL, 0x018fe40003f34000ULL,
0x0000000d0a237209ULL, 0x040fe40007810000ULL, 0x00000002ff1c7819ULL, 0x000fe40000011603ULL,
0x00000002ff1b7819ULL, 0x000fe2000001161aULL, 0x800000230a0c7221ULL, 0x000fe20000010000ULL,
0x000000081c1d7810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL,
0x00000000000a7806ULL, 0x000fe400008e0100ULL, 0x0000001a1b00720cULL, 0x000fe40003f25270ULL,
0x0000ffff0a217812ULL, 0x000fe200078e3cffULL, 0x0000000c000c7308ULL, 0x000ea60000000800ULL,
0x0000002120ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff1b7807ULL, 0x000fc60001000000ULL,
0x000000801a0a9824ULL, 0x000fc800078e0215ULL, 0x00000001170a9824ULL, 0x000fe200078e020aULL,
0x00001f1d0c1d7589ULL, 0x004ea200000e0000ULL, 0x800000230d0d2221ULL, 0x000fe20000010000ULL,
0x0000000c0b0b7220ULL, 0x000fe40000410000ULL, 0x00001f1c0c1c7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b0d0d2820ULL, 0x000fc60000410000ULL, 0x00f400230a009388ULL, 0x0009e20000000800ULL,
0x0000000d00182308ULL, 0x000f620000000800ULL, 0x000000ffff0a7224ULL, 0x010fe200078e0023ULL,
0x0000001d27277220ULL, 0x084fe20000410000ULL, 0x0000001d26267220ULL, 0x080fe20000410000ULL,
0x0000001d43437220ULL, 0x080fe20000410000ULL, 0x0000001d42427220ULL, 0x080fe20000410000ULL,
0x0000001d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001d37377220ULL, 0x080fe20000410000ULL, 0x0000001d36367220ULL, 0x080fe20000410000ULL,
0x0000001d33337220ULL, 0x080fe20000410000ULL, 0x0000001d32327220ULL, 0x080fe20000410000ULL,
0x0000001d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001d2a2a7220ULL, 0x000fe20000410000ULL,
0x0000001c25257220ULL, 0x088fe20000410000ULL, 0x0000001c24247220ULL, 0x080fe20000410000ULL,
0x0000001c41417220ULL, 0x080fe20000410000ULL, 0x0000001c40407220ULL, 0x080fe20000410000ULL,
0x0000001c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001c39397220ULL, 0x080fe20000410000ULL, 0x0000001c38387220ULL, 0x080fe20000410000ULL,
0x0000001c35357220ULL, 0x080fe20000410000ULL, 0x0000001c34347220ULL, 0x080fe20000410000ULL,
0x0000001c31317220ULL, 0x080fe20000410000ULL, 0x0000001c30307220ULL, 0x080fe20000410000ULL,
0x0000001c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001c29297220ULL, 0x080fe20000410000ULL, 0x0000001c28287220ULL, 0x000fe20000410000ULL,
0x000000180e0e2220ULL, 0x020fc80000410000ULL, 0x0000000b0e0b7221ULL, 0x018fe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x000004061e0c7984ULL, 0x000ea20008000800ULL,
0x800000001f0d7824ULL, 0x000fca00078e00ffULL, 0x800000000cff7812ULL, 0x004fe2000780480dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000001f0e7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0004e4000021f000ULL, 0x3fa000000c0c7823ULL, 0x004fe200000100ffULL,
0x0000000d0000735dULL, 0x008fe40003800000ULL, 0x000004061e0d7984ULL, 0x000ea40008000800ULL,
0x800000000dff7812ULL, 0x004fc4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000041a0e7824ULL, 0x040fe200078e00ffULL,
0x00000008030c7812ULL, 0x000fe200078ec0ffULL, 0x000010001a0d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b723eULL, 0x000fe400000010ffULL, 0x000000040e0e7812ULL, 0x000fe400078ec0ffULL,
0xffffe0000d1d7812ULL, 0x000fe400078ec0ffULL, 0x000000070c0d7812ULL, 0x140fe400078ec803ULL,
0x000000070c5e7812ULL, 0x000fe200078ef803ULL, 0x000010004c0c7824ULL, 0x040fe200078e0207ULL,
0x0000000e030e7211ULL, 0x000fe200078fe0ffULL, 0x000010004c1d7824ULL, 0x000fe200078e021dULL,
0x000000805e1e7811ULL, 0x002fc400078e18ffULL, 0x000000020e1c7810ULL, 0x000fe40007ffe0ffULL,
0x0000b0000c1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000021a0c7824ULL, 0x000fe200078e00ffULL,
0x0000001c0d557212ULL, 0x000fe400078e3cffULL, 0x0000b0001d1c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000e0d1d7212ULL, 0x000fe200078e3cffULL, 0x000000085e577824ULL, 0x000fe200078e0255ULL,
0x000000040c0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000155557824ULL, 0x100fe200078e021eULL,
0x00000007030c7812ULL, 0x000fe200078ec0ffULL, 0x000000011d567824ULL, 0x000fe200078e021eULL,
0x0000000e030d7211ULL, 0x000fe200078fe0ffULL, 0x000000085e5e7824ULL, 0x000fe200078e021dULL,
0x000000080c0c7812ULL, 0x000fe200078ef803ULL, 0x0000001057207824ULL, 0x000fe200078e021cULL,
0x000000020d1d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001056447824ULL, 0x100fe200078e021fULL,
0x000000070d0d7812ULL, 0x100fe200078e780cULL, 0x0000001055487824ULL, 0x000fe200078e021fULL,
0x000000071d1d7812ULL, 0x000fe200078e780cULL, 0x000000105e1c7824ULL, 0x000fe200078e021cULL,
0x000099101b1e7816ULL, 0x000fe200000000ffULL, 0x000000002020783bULL, 0x000e620000004200ULL,
0x000000080c0d7824ULL, 0x040fe200078e020dULL, 0x00000002ff8e7819ULL, 0x000fe20000011603ULL,
0x000000080c1b7824ULL, 0x000fe200078e021dULL, 0x000000004444783bULL, 0x000ea20000004200ULL,
0x000000ffff0c7224ULL, 0x000fe200078e001eULL, 0x000054108b8b7816ULL, 0x000fe2000000008bULL,
0x000002001a0e7824ULL, 0x000fe200078e00ffULL, 0x000000004848783bULL, 0x000ee40000004200ULL,
0x000000ff0c00720cULL, 0x000fc40003f05270ULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0xfffff8000e0e7812ULL, 0x000fca00078ec0ffULL, 0x000000100d0c7824ULL, 0x100fe400078e020eULL,
0x000000101b0d7824ULL, 0x000fe200078e020eULL, 0x00000010ff6d7819ULL, 0x102fe40000011620ULL,
0x000000ff20767812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011620ULL,
0x0000ffff207c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7d7819ULL, 0x000fc40000011621ULL,
0x000000ff21757812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011621ULL,
0x0000ffff21817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff607819ULL, 0x104fe40000011646ULL,
0x000000ff46777812ULL, 0x000fe400078ec0ffULL, 0x00000018ff547819ULL, 0x000fc40000011646ULL,
0x0000ffff46617812ULL, 0x000fe400078ec0ffULL, 0x00000010ff707819ULL, 0x108fe40000011648ULL,
0x000000ff48217812ULL, 0x040fe400078ec0ffULL, 0x00000018ff207819ULL, 0x000fe40000011648ULL,
0x0000ffff48467812ULL, 0x000fe400078ec0ffULL, 0x00000010ff487819ULL, 0x000fc4000001164bULL,
0x000000ff4b6b7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001164bULL,
0x0000ffff4b507812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4b7819ULL, 0x010fe4000001161fULL,
0x000000ff44517812ULL, 0x000fe400078ec0ffULL, 0x0000004bff4b723eULL, 0x000fc400020006ffULL,
0x00000018ff527819ULL, 0x000fe40000011645ULL, 0x00000018ff787819ULL, 0x100fe20000011647ULL,
0x2000004bff837230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000052ff4b723eULL, 0x000fe400020006ffULL, 0x00000077ff77723eULL, 0x000fe200020006ffULL,
0x20000051ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe20000011647ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff477a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff47647812ULL, 0x000fe400078ec0ffULL, 0x00000078ff52723eULL, 0x000fe400020006ffULL,
0x00000018ff477819ULL, 0x000fe4000001161eULL, 0x0000ffff1e787812ULL, 0x000fe200078ec0ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000054ff51723eULL, 0x000fe200020006ffULL,
0x20000077ff547230ULL, 0x000fe20000004100ULL, 0x00000047ff47723eULL, 0x000fc400020006ffULL,
0x00000010ff777819ULL, 0x000fe2000001161dULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe20000011678ULL, 0x20000047ff857230ULL, 0x000fe20000004100ULL,
0x000000ff22737812ULL, 0x000fe400078ec0ffULL, 0x00000018ff657819ULL, 0x100fe40000011623ULL,
0x00000010ff667819ULL, 0x000fe40000011644ULL, 0x00000010ff877819ULL, 0x000fc40000011623ULL,
0x000000ff23747812ULL, 0x040fe400078ec0ffULL, 0x0000ffff23887812ULL, 0x000fe400078ec0ffULL,
0x0000ffff45237812ULL, 0x000fe400078ec0ffULL, 0x000000ff77777812ULL, 0x000fe400078ec0ffULL,
0x00000078ff78723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fc400020006ffULL,
0x00000010ff477819ULL, 0x000fe2000001161cULL, 0x20000078ff827230ULL, 0x000fe20000004100ULL,
0x000000ff66667812ULL, 0x000fe200078ec0ffULL, 0x20000073ff787230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x000000ff45537812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe20000011644ULL, 0x20000065ff737230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fc400020006ffULL, 0x00000008ff237819ULL, 0x000fe40000011623ULL,
0x0000ffff44687812ULL, 0x000fe200078ec0ffULL, 0x20000077ff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe40000011645ULL, 0x00000074ff74723eULL, 0x000fe400020006ffULL,
0x000000ff47477812ULL, 0x000fe400078ec0ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000074ff777230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fc400020006ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011622ULL, 0x20000066ff747230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fe200020006ffULL, 0x20000053ff727230ULL, 0x000fe20000004100ULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x000000ff63657812ULL, 0x000fe200078ec0ffULL,
0x2000004fff537230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fc400078ec0ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x00000008ff637819ULL, 0x000fe40000011661ULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x20000047ff897230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000076ff477230ULL, 0x000fe20000004100ULL,
0x00000060ff61723eULL, 0x000fe200020006ffULL, 0x20000023ff607230ULL, 0x000fe20000004100ULL,
0x00000065ff66723eULL, 0x000fe200020006ffULL, 0x20000075ff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fe20000011622ULL, 0x2000005cff767230ULL, 0x000fe20000004100ULL,
0x0000ffff22867812ULL, 0x000fe200078ec0ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000063ff65723eULL, 0x000fe200020006ffULL, 0x20000067ff757230ULL, 0x000fe20000004100ULL,
0x000000ff49227812ULL, 0x000fe200078ec0ffULL, 0x20000068ff5c7230ULL, 0x000fe20000004100ULL,
0x0000007aff4f723eULL, 0x000fe200020006ffULL, 0x20000066ff637230ULL, 0x000fe20000004100ULL,
0x00000064ff23723eULL, 0x000fe200020006ffULL, 0x20000065ff647230ULL, 0x000fe20000004100ULL,
0x0000ffff1f7a7812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000021ff66723eULL, 0x000fe200020006ffULL, 0x20000023ff657230ULL, 0x000fe20000004100ULL,
0x00000008ff7a7819ULL, 0x000fc4000001167aULL, 0x00000022ff67723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000020ff68723eULL, 0x000fe400020006ffULL,
0x009000000c20783bULL, 0x000fe20000000200ULL, 0x00000018ff0e7819ULL, 0x000fe20000011649ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x2000007aff807230ULL, 0x000fe20000004100ULL,
0x000000ff4a697812ULL, 0x000fe200078ec0ffULL, 0x2000006cff7b7230ULL, 0x000fe20000004100ULL,
0x0000000eff0e723eULL, 0x000fe200020006ffULL, 0x2000006fff7a7230ULL, 0x000fe20000004100ULL,
0x00000018ff6a7819ULL, 0x000fc4000001164aULL, 0x00000069ff6c723eULL, 0x000fe200020006ffULL,
0x2000000eff697230ULL, 0x000fe20000004100ULL, 0x0000006aff6f723eULL, 0x000fe400020006ffULL,
0x000000088e0e7810ULL, 0x000fe20007ffe0ffULL, 0x2000006cff6a7230ULL, 0x000fe20000004100ULL,
0x0000006eff8d723eULL, 0x000fe200020006ffULL, 0x2000006fff6c7230ULL, 0x000fe20000004100ULL,
0x000000ff1d457812ULL, 0x000fe200078ec0ffULL, 0x00001f8e8b6f7589ULL, 0x000e6200000e0000ULL,
0x000000ff1c447812ULL, 0x000fc400078ec0ffULL, 0x000000ff7d7d7812ULL, 0x000fe200078ec0ffULL,
0x00001f0e8b6e7589ULL, 0x000ea200000e0000ULL, 0x00000045ff45723eULL, 0x000fe400020006ffULL,
0x00000008ff817819ULL, 0x000fe40000011681ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000081ff8c723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x2000007dff817230ULL, 0x000fe20000004100ULL,
0x000000ff79797812ULL, 0x000fe200078ec0ffULL, 0x2000008cff7d7230ULL, 0x000fe20000004100ULL,
0x0000006dff84723eULL, 0x000fe200020006ffULL, 0x2000008dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fc40000011645ULL, 0x00000010ff447819ULL, 0x000fe20000011644ULL,
0x0000006f20208231ULL, 0x082fe200003400ffULL, 0x00000010ff457819ULL, 0x000fe20000011689ULL,
0x0000006f22228231ULL, 0x000fe200003400ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001168aULL,
0x0000006e21218231ULL, 0x084fe200003400ffULL, 0x0000105445447816ULL, 0x000fe20000000044ULL,
0x0000006e23238231ULL, 0x000fe200003400ffULL, 0x000010548d457816ULL, 0x000fe2000000008cULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000008ff8a7819ULL, 0x000fc40000011686ULL,
0x00000008ff8c7819ULL, 0x000fe40000011688ULL, 0x00000079ff86723eULL, 0x000fe200020006ffULL,
0x000000442028723cULL, 0x000fe20000041828ULL, 0x0000008aff88723eULL, 0x000fe400020006ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001161cULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x0000008cff79723eULL, 0x000fe200020006ffULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000ffff1c8a7812ULL, 0x000fc400078ec0ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001161dULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x0000ffff1d8c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e1d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff1f8e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x000fe4000001161eULL, 0x00000010ff457819ULL, 0x000fc4000001161fULL,
0x0000001cff1e723eULL, 0x000fe400020006ffULL, 0x0000001dff1f723eULL, 0x000fe400020006ffULL,
0x00000008ff1c7819ULL, 0x000fe2000001168aULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x00000008ff1d7819ULL, 0x000fe2000001168cULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x0000001cff1c723eULL, 0x000fc400020006ffULL,
0x0000001dff1d723eULL, 0x000fe200020006ffULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff44447812ULL, 0x000fe200078ec0ffULL, 0x2000001cff1c7230ULL, 0x000fe20000004100ULL,
0x000000ff45457812ULL, 0x000fe200078ec0ffULL, 0x2000001dff1d7230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff1e7819ULL, 0x000fe4000001161eULL,
0x00000010ff1c7819ULL, 0x000fc4000001161cULL, 0x00000010ff1d7819ULL, 0x000fe4000001161dULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x0000008eff89723eULL, 0x000fe400020006ffULL,
0x00000045ff45723eULL, 0x000fe200020006ffULL, 0x20000044ff447230ULL, 0x000fe20000004100ULL,
0x000010548b1c7816ULL, 0x000fe2000000001cULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000010541e1d7816ULL, 0x000fe2000000001dULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x000fc40000011649ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff1e7819ULL, 0x000fe20000011645ULL, 0x0000001c202c723cULL, 0x000fe2000004182cULL,
0x00000008ff7c7819ULL, 0x000fe4000001167cULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff1c7819ULL, 0x000fc4000001161fULL,
0x00000010ff1d7819ULL, 0x000fe40000011644ULL, 0x00000010ff447819ULL, 0x000fe40000011682ULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x000010541e1d7816ULL, 0x000fe40000000089ULL,
0x00000010ff827819ULL, 0x000fe40000011683ULL, 0x00000010ff457819ULL, 0x000fc40000011680ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x0000001c2030723cULL, 0x000fe20000041830ULL,
0x009000000d1c783bULL, 0x000e620000000200ULL, 0x0000007fff89723eULL, 0x000fe400020006ffULL,
0x0000105485447816ULL, 0x000fe20000000044ULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x0000105482457816ULL, 0x000fe40000000045ULL, 0x00000008ff7f7819ULL, 0x000fe40000011646ULL,
0x00000010ff467819ULL, 0x000fc40000011647ULL, 0x00000010ff477819ULL, 0x000fe20000011684ULL,
0x000000442034723cULL, 0x000fe20000041834ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x0000105447467816ULL, 0x000fe40000000046ULL, 0x0000105481477816ULL, 0x000fc4000000007eULL,
0x00000010ff457819ULL, 0x000fe4000001167aULL, 0x00000010ff447819ULL, 0x000fe4000001167cULL,
0x00000010ff7e7819ULL, 0x000fe2000001167bULL, 0x000000462038723cULL, 0x000fe20000041838ULL,
0x00000010ff7d7819ULL, 0x000fe2000001167dULL, 0x20000089ff7b7230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000105445447816ULL, 0x000fc40000000044ULL,
0x000010547e457816ULL, 0x000fe2000000007dULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff467819ULL, 0x000fe40000011678ULL, 0x00000010ff787819ULL, 0x000fe20000011677ULL,
0x0000006f1c1c8231ULL, 0x082fe200003400ffULL, 0x00000010ff777819ULL, 0x000fe20000011676ULL,
0x00000044203c723cULL, 0x000fe2000004183cULL, 0x00000010ff477819ULL, 0x000fe20000011686ULL,
0x0000006f1e1e8231ULL, 0x000fe200003400ffULL, 0x00000010ff767819ULL, 0x000fe20000011672ULL,
0x0000006e1d1d8231ULL, 0x080fe200003400ffULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x0000006e1f1f8231ULL, 0x000fe200003400ffULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff727819ULL, 0x000fe40000011673ULL, 0x00000010ff457819ULL, 0x000fe40000011679ULL,
0x0000105447467816ULL, 0x000fe40000000046ULL, 0x0000105487477816ULL, 0x000fe40000000078ULL,
0x0000105477447816ULL, 0x000fe40000000088ULL, 0x0000105472457816ULL, 0x000fc40000000045ULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x000000462040723cULL, 0x040fe20000041840ULL,
0x00000010ff1b7819ULL, 0x000fe4000001164aULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x0000ffff49497812ULL, 0x000fe400078ec0ffULL, 0x00000010ff617819ULL, 0x000fe20000011661ULL,
0x000000442024723cULL, 0x000fe20000041824ULL, 0x00000070ff70723eULL, 0x000fc400020006ffULL,
0x000000ff1b1b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff497819ULL, 0x000fe20000011649ULL,
0x20000070ff707230ULL, 0x000fe20000004100ULL, 0x00000010ff227819ULL, 0x000fe4000001164bULL,
0x00000010ff207819ULL, 0x000fe4000001165cULL, 0x00000010ff217819ULL, 0x000fe40000011660ULL,
0x0000105453207816ULL, 0x000fc40000000020ULL, 0x0000105422217816ULL, 0x000fe40000000021ULL,
0x00000010ff227819ULL, 0x000fe40000011654ULL, 0x00000010ff237819ULL, 0x000fe4000001164fULL,
0x00000010ff447819ULL, 0x000fe20000011663ULL, 0x000000201c2c723cULL, 0x000fe2000004182cULL,
0x0000ffff4a4a7812ULL, 0x000fe400078ec0ffULL, 0x0000105461227816ULL, 0x000fc40000000022ULL,
0x0000105444237816ULL, 0x000fe40000000023ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff207819ULL, 0x000fe20000011664ULL,
0x000000221c30723cULL, 0x000fe20000041830ULL, 0x00000010ff217819ULL, 0x000fe40000011665ULL,
0x0000001bff1b723eULL, 0x000fc400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000049ff49723eULL, 0x000fe200020006ffULL, 0x2000001bff457230ULL, 0x000fe20000004100ULL,
0x000000ff48487812ULL, 0x000fe200078ec0ffULL, 0x2000007fff7a7230ULL, 0x000fe20000004100ULL,
0x00000008ff4a7819ULL, 0x000fe2000001164aULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x00000008ff507819ULL, 0x000fe40000011650ULL, 0x0000105451207816ULL, 0x000fc40000000020ULL,
0x0000105452217816ULL, 0x000fe40000000021ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x000000201c34723cULL, 0x000fe20000041834ULL, 0x00000010ff227819ULL, 0x000fe20000011666ULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x00000010ff1b7819ULL, 0x000fe20000011670ULL,
0x20000048ff487230ULL, 0x000fe20000004100ULL, 0x00000050ff50723eULL, 0x000fe200020006ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x000010541b227816ULL, 0x000fc40000000022ULL,
0x00000010ff1b7819ULL, 0x000fe20000011668ULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff207819ULL, 0x000fe40000011669ULL,
0x00000010ff497819ULL, 0x000fe40000011649ULL, 0x00000010ff447819ULL, 0x000fe4000001167bULL,
0x000010541b7a7816ULL, 0x000fc4000000007aULL, 0x00001054207b7816ULL, 0x000fe40000000049ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff757819ULL, 0x000fe20000011675ULL, 0x0000007a1c3c723cULL, 0x000fe2000004183cULL,
0x00000010ff237819ULL, 0x000fe40000011667ULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff487819ULL, 0x000fe40000011648ULL, 0x00000010ff1b7819ULL, 0x000fe4000001166cULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff207819ULL, 0x000fc4000001166dULL,
0x00000010ff4b7819ULL, 0x000fe40000011650ULL, 0x0000105474467816ULL, 0x000fe40000000071ULL,
0x0000105475477816ULL, 0x000fe40000000076ULL, 0x0000105444237816ULL, 0x000fe20000000023ULL,
0x0000010019447824ULL, 0x000fe200078e00ffULL, 0x00001054456a7816ULL, 0x000fe4000000006aULL,
0x00001054486b7816ULL, 0x000fe2000000006bULL, 0x000000461c28723cULL, 0x000fe20000041828ULL,
0x000010541b4a7816ULL, 0x000fc4000000004aULL, 0x00001054204b7816ULL, 0x000fe4000000004bULL,
0x00000002ff217819ULL, 0x000fc6000001161aULL, 0x000000221c38723cULL, 0x000fe20000041838ULL,
0x0000f610211b7811ULL, 0x000fce00078e20ffULL, 0x0000006a1c40723cULL, 0x040ff00000041840ULL,
0x0000004a1c24723cULL, 0x000fe20000041824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000020000fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040211c7824ULL, 0x000fe200078e0244ULL,
0x000000ff4eff7812ULL, 0x000fe2000782c0ffULL, 0x000000001bff7f8cULL, 0x0005e2000c80043fULL,
0x000000ff4dff7812ULL, 0x000fc4000784c0ffULL, 0x000000401c1d7810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff477807ULL, 0x000fe40000800000ULL, 0x000000001d00720cULL, 0x000fe40003f26070ULL,
0x000000014c00780cULL, 0x040fe40003f05270ULL, 0x00000001ff5c7807ULL, 0x000fe40001000000ULL,
0x000000014c4c7812ULL, 0x000fc400078e0cffULL, 0x0000004e474e7207ULL, 0x000fe40004000000ULL,
0x000076105c4d7816ULL, 0x000fc6000000004dULL, 0x00006bf000001947ULL, 0x000fea0003800000ULL,
0x000024000f1b7984ULL, 0x004ea20000000800ULL, 0x800000005c067824ULL, 0x000fca00078e00ffULL,
0x800000001bff7812ULL, 0x004fe20007824806ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x000024000f1b7984ULL, 0x000ea40000000800ULL,
0x800000001bff7812ULL, 0x004fe40007824806ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fe400078e00ffULL,
0x800000005c1c7824ULL, 0x000fe400078e00ffULL, 0x00000006001b7305ULL, 0x0004e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x0000001b0000735dULL, 0x008fe40003800000ULL,
0x000024000f1b7984ULL, 0x000ea40000000800ULL, 0x800000001bff7812ULL, 0x004fc4000782481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000803067211ULL, 0x000fe200078fe8ffULL, 0x0000000811607824ULL, 0x000fe200078e00ffULL,
0x00000001191b7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff497424ULL, 0x000fe200078e00ffULL,
0x00000003061c7212ULL, 0x040fe200078e3cffULL, 0x0000000806537824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fe2000001161aULL, 0x0000100011617824ULL, 0x000fe200078e00ffULL,
0x000000021b00720cULL, 0x000fe40003f26070ULL, 0x00000004031b7811ULL, 0x000fe200078fe8ffULL,
0x00000020061e7824ULL, 0x000fe200078e025dULL, 0xfffffff853537812ULL, 0x000fc400078ee21cULL,
0x00000008601d7812ULL, 0x000fe200078ec0ffULL, 0x00000001081c7824ULL, 0x000fe200078e021bULL,
0x000000801e1e7810ULL, 0x000fe40007ffe0ffULL, 0x0000f64806237811ULL, 0x000fe200078e20ffULL,
0x000000081c527824ULL, 0x000fe200078e00ffULL, 0x0000001e001f7217ULL, 0x000fe20007800000ULL,
0x000000001d0773c2ULL, 0x0004e200000e0000ULL, 0x000000031c1b7212ULL, 0x000fe200078e3cffULL,
0x0000620005217a24ULL, 0x100fe200078e021eULL, 0x0000000860547812ULL, 0x000fe200078e0cffULL,
0x000000011f227824ULL, 0x000fe200078e0a1eULL, 0xfffffff852527812ULL, 0x000fc400078ee21bULL,
0x00000003ff467819ULL, 0x000fe20000011603ULL, 0x0000000123547824ULL, 0x000fe200078e0254ULL,
0x0000000c031d7811ULL, 0x044fe200078fe8ffULL, 0x00000000230573c2ULL, 0x0004e200000e0000ULL,
0x00000008031b7811ULL, 0x000fe400078fe8ffULL, 0x00000004464a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001081e7824ULL, 0x040fe200078e021dULL, 0x00000046211d7210ULL, 0x140fe20007ffe008ULL,
0x00000001081c7824ULL, 0x000fe200078e021bULL, 0x0000004a211f7210ULL, 0x000fe20007ffe008ULL,
0x000000081e487824ULL, 0x000fe200078e00ffULL, 0x0000002022237807ULL, 0x004fe20000800000ULL,
0x000000081c517824ULL, 0x000fe200078e00ffULL, 0x000000031e1b7212ULL, 0x000fe200078e3cffULL,
0x00005e001f1e7625ULL, 0x000fe200078e0049ULL, 0x0000002308237217ULL, 0x000fc40007800000ULL,
0x000000031c207212ULL, 0x000fe200078e3cffULL, 0x00005e001d1c7625ULL, 0x000fe200078e0049ULL,
0xfffffff8481b7812ULL, 0x000fe400078ee21bULL, 0x00000008464c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000123457824ULL, 0x000fe200078e0a08ULL, 0x0000100061237812ULL, 0x000fe400078ec0ffULL,
0x0000000c46487810ULL, 0x000fe20007ffe0ffULL, 0x0000000705057290ULL, 0x008fe2000fffe03fULL,
0xfffffff851517812ULL, 0x000fe200078ee220ULL, 0x0000200006237824ULL, 0x000fe200078e0223ULL,
0x000000151c1c7210ULL, 0x000fc40007f3e0ffULL, 0x000000151e1e7210ULL, 0x000fe40007f5e0ffULL,
0x0000004c21207210ULL, 0x140fe20007ffe008ULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000004821227210ULL, 0x000fe20007ffe008ULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x000000454600720cULL, 0x000fe20003f26070ULL, 0x00005e0020207625ULL, 0x000fe200078e0049ULL,
0x0000b00023507810ULL, 0x000fe40007ffe0ffULL, 0x000000454a00720cULL, 0x000fe20003f46070ULL,
0x00005e0022227625ULL, 0x000fe200078e0049ULL, 0x000000454c00720cULL, 0x000fc40003f66070ULL,
0x000000454800720cULL, 0x000fe20003f86070ULL, 0x0000001053537824ULL, 0x100fe200078e0250ULL,
0x0000001520207210ULL, 0x080fe20007fbe0ffULL, 0x0000001052527824ULL, 0x100fe200078e0250ULL,
0x0000001522227210ULL, 0x000fe20007fde0ffULL, 0x0000001051517824ULL, 0x100fe200078e0250ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c537faeULL, 0x0005e2000c901c48ULL,
0x000000ffff217224ULL, 0x000fe400028e0621ULL, 0x000000101b507824ULL, 0x000fe200078e0250ULL,
0x000000001e527faeULL, 0x0005e2000d101c48ULL, 0x000000ffff237224ULL, 0x000fc600030e0623ULL,
0x0000000020517faeULL, 0x0005e8000d901c48ULL, 0x0000000022507faeULL, 0x0005e8000e101c48ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000400541c7984ULL, 0x0044e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00f61c00131d7984ULL, 0x000f220000000800ULL,
0x0000006247627207ULL, 0x000fe20004000000ULL, 0x80000000141e7824ULL, 0x000fc600078e00ffULL,
0x0000ffff621b7812ULL, 0x000fc800078ec0ffULL, 0x000088801b227816ULL, 0x000fca00000000ffULL,
0x80000000221b7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x008fe4000780481bULL,
0x800000001dff7812ULL, 0x010fe2000782481eULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x000000041a137824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1b7424ULL, 0x000fe400078e00ffULL, 0x80000000141d7824ULL, 0x000fe200078e00ffULL,
0xfffffff013137812ULL, 0x000fe400078ec0ffULL, 0x0000001b001c7305ULL, 0x000724000021f000ULL,
0x3fa000001b1b7823ULL, 0x008fe200000100ffULL, 0x0000001c0000735dULL, 0x010fe40003800000ULL,
0x00f61c00131c7984ULL, 0x000ee40000000800ULL, 0x800000001cff7812ULL, 0x008fc4000782481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000080151c7810ULL, 0x000fe20007ffe016ULL, 0x00000001ff487424ULL, 0x000fc800078e00ffULL,
0x00000001171c7824ULL, 0x000fca00078e021cULL, 0x00f000001c1b7984ULL, 0x000ee80000000800ULL,
0x00f200001c1d7984ULL, 0x0008620000000800ULL, 0x0000000a1b00720bULL, 0x008fda0003f3d000ULL,
0x00000000001e7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1e217812ULL, 0x000fda000782c0ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x0000000a1b00720bULL, 0x012fe40003f34000ULL,
0x0000001b0a1e7209ULL, 0x080fe40007810000ULL, 0x000000011a1f7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff457819ULL, 0x000fe20000011603ULL, 0x8000001e0a1c7221ULL, 0x040fe20000010000ULL,
0x0000001b0a0a7209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b1c207820ULL, 0x000fe40000410000ULL,
0x00000000001c7806ULL, 0x000fe400008e0100ULL, 0x0000001a1f00720cULL, 0x000fe40003f25270ULL,
0x0000ffff1c467812ULL, 0x000fe200078e3cffULL, 0x0000002000207308ULL, 0x000e660000000800ULL,
0x0000004621ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff487807ULL, 0x000fc60001000000ULL,
0x000000801a469824ULL, 0x000fc800078e0215ULL, 0x0000000117239824ULL, 0x000fe200078e0246ULL,
0x00001f45201c7589ULL, 0x002e6200000e0000ULL, 0x8000001e1b212221ULL, 0x000fe20000010000ULL,
0x000000200b0b7220ULL, 0x000fe40000410000ULL, 0x00001f0e201f7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b21212820ULL, 0x000fc60000410000ULL, 0x00f4001e23009388ULL, 0x0009e20000000800ULL,
0x0000002100182308ULL, 0x000f620000000800ULL, 0x0000001c28287220ULL, 0x082fe20000410000ULL,
0x0000001c29297220ULL, 0x080fe20000410000ULL, 0x0000001c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001c30307220ULL, 0x080fe20000410000ULL,
0x0000001c31317220ULL, 0x080fe20000410000ULL, 0x0000001c34347220ULL, 0x080fe20000410000ULL,
0x0000001c35357220ULL, 0x080fe20000410000ULL, 0x0000001c38387220ULL, 0x080fe20000410000ULL,
0x0000001c39397220ULL, 0x080fe20000410000ULL, 0x0000001c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001c40407220ULL, 0x080fe20000410000ULL,
0x0000001c41417220ULL, 0x080fe20000410000ULL, 0x0000001c24247220ULL, 0x080fe20000410000ULL,
0x0000001c25257220ULL, 0x000fe20000410000ULL, 0x0000001f2a2a7220ULL, 0x088fe20000410000ULL,
0x0000001f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001f32327220ULL, 0x080fe20000410000ULL,
0x0000001f33337220ULL, 0x080fe20000410000ULL, 0x0000001f36367220ULL, 0x080fe20000410000ULL,
0x0000001f37377220ULL, 0x080fe20000410000ULL, 0x0000001f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001f3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001f3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001f42427220ULL, 0x080fe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f26267220ULL, 0x080fe20000410000ULL,
0x0000001f27277220ULL, 0x000fe20000410000ULL, 0x0000001d181d2220ULL, 0x020fc80000410000ULL,
0x0000000b1d0b7221ULL, 0x012fe20000010000ULL, 0x0000013000000947ULL, 0x000fea0003800000ULL,
0x00000008111b7824ULL, 0x000fe400078e00ffULL, 0x000000081a1c7824ULL, 0x000fc600078e00ffULL,
0x000000081b1b7812ULL, 0x000fe400078e0cffULL, 0xfffffff01c1c7812ULL, 0x000fca00078ec0ffULL,
0x000000011b1d7824ULL, 0x000fe400078e021cULL, 0x80000000221c7824ULL, 0x000fc600078e00ffULL,
0x00f64c001d1b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fe4000780481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x80000000221f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff1b7424ULL, 0x000fc800078e00ffULL,
0x0000001b001c7305ULL, 0x0002e4000021f000ULL, 0x3fa000001b1b7823ULL, 0x002fe200000100ffULL,
0x0000001c0000735dULL, 0x008fe40003800000ULL, 0x00f64c001d1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fc4000780481fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00001000114a7824ULL, 0x000fe200078e00ffULL,
0x00009910484c7816ULL, 0x000fe200000000ffULL, 0x000010001a1b7824ULL, 0x000fe200078e00ffULL,
0x00000002ff9c7819ULL, 0x000fe40000011603ULL, 0x000010004a4a7812ULL, 0x000fe400078e0cffULL,
0xffffe0001b1b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c00720cULL, 0x000fe40003f05270ULL,
0x0000b0001b467810ULL, 0x000fc40007ffe04aULL, 0x0000b000071b7810ULL, 0x000fc60007ffe04aULL,
0x000000105e477824ULL, 0x100fe400078e0246ULL, 0x0000001057467824ULL, 0x000fe400078e0246ULL,
0x0000001056457824ULL, 0x100fe200078e021bULL, 0x00000000471c783bULL, 0x000e620000004200ULL,
0x00000010551b7824ULL, 0x000fc600078e021bULL, 0x000000004620783bULL, 0x000ee80000004200ULL,
0x000000004548783bULL, 0x000f280000004200ULL, 0x000000001b4c783bULL, 0x000f620000004200ULL,
0x00000010ff687819ULL, 0x002fe4000001161cULL, 0x000000ff1c987812ULL, 0x000fc400078ec0ffULL,
0x000000ff22847812ULL, 0x008fe400078ec0ffULL, 0x00000018ff717819ULL, 0x000fe40000011622ULL,
0x000000ff23837812ULL, 0x000fe400078ec0ffULL, 0x000000ff4b6f7812ULL, 0x010fe400078ec0ffULL,
0x00000018ff967819ULL, 0x000fe4000001161cULL, 0x0000ffff1c657812ULL, 0x000fc400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe40000011623ULL, 0x00000010ff807819ULL, 0x100fe40000011648ULL,
0x000000ff487e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe40000011648ULL,
0x0000ffff48817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff827819ULL, 0x000fc40000011649ULL,
0x000000ff497f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff487819ULL, 0x000fe40000011649ULL,
0x0000ffff491c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4a6b7812ULL, 0x000fe400078ec0ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x000000ff21857812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001164aULL, 0x00000083ff49723eULL, 0x000fe200020006ffULL,
0x20000084ff837230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x000000ff4c667812ULL, 0x020fe200078ec0ffULL, 0x20000049ff847230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000010ff7b7819ULL, 0x000fc40000011622ULL,
0x0000ffff22867812ULL, 0x000fe400078ec0ffULL, 0x00000010ff877819ULL, 0x000fe40000011623ULL,
0x0000ffff23787812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d677812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000018ff697819ULL, 0x000fc4000001164dULL,
0x00000010ff637819ULL, 0x100fe4000001164fULL, 0x000000ff4f237812ULL, 0x040fe400078ec0ffULL,
0x00000018ff227819ULL, 0x000fe4000001164fULL, 0x0000ffff4f6a7812ULL, 0x000fe400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x000000ff4e6e7812ULL, 0x000fc400078ec0ffULL,
0x00000085ff4f723eULL, 0x000fe200020006ffULL, 0x20000071ff857230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000006fff717230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000007dff49723eULL, 0x000fe200020006ffULL, 0x20000073ff7d7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000006bff737230ULL, 0x000fe20000004100ULL,
0x00000069ff6f723eULL, 0x000fe200020006ffULL, 0x2000006cff6b7230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x20000066ff6c7230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x100fe20000011621ULL, 0x20000067ff667230ULL, 0x000fe20000004100ULL,
0x00000018ff7c7819ULL, 0x000fe20000011621ULL, 0x2000006fff677230ULL, 0x000fe20000004100ULL,
0x0000ffff217a7812ULL, 0x000fe200078ec0ffULL, 0x2000006eff6f7230ULL, 0x000fe20000004100ULL,
0x00000018ff217819ULL, 0x000fe2000001164eULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x000000ff20977812ULL, 0x000fc400078ec0ffULL, 0x00000021ff6e723eULL, 0x000fe400020006ffULL,
0x000000ff68217812ULL, 0x000fe400078ec0ffULL, 0x00000010ff727819ULL, 0x000fe2000001161eULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000010ff757819ULL, 0x000fe4000001164eULL, 0x0000ffff4e647812ULL, 0x000fc400078ec0ffULL,
0x000000ff1e927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x100fe4000001164bULL,
0x00000018ff6d7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b8f7812ULL, 0x000fe400078ec0ffULL,
0x00000097ff4e723eULL, 0x000fe200020006ffULL, 0x20000021ff977230ULL, 0x000fe20000004100ULL,
0x000000ff1f937812ULL, 0x000fc400078ec0ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001164cULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x000000ff72217812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fe4000001161eULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fc400020006ffULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe2000001161fULL,
0x2000004bff697230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe4000001164cULL,
0x0000ffff4c8c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff777819ULL, 0x100fe40000011620ULL,
0x00000091ff4c723eULL, 0x000fe200020006ffULL, 0x20000092ff917230ULL, 0x000fe20000004100ULL,
0x00000018ff797819ULL, 0x000fe20000011620ULL, 0x20000093ff927230ULL, 0x000fe20000004100ULL,
0x00000022ff4b723eULL, 0x000fe200020006ffULL, 0x20000021ff937230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x0000ffff1f897812ULL, 0x000fc400078ec0ffULL, 0x0000ffff20207812ULL, 0x000fe400078ec0ffULL,
0x00000008ff227819ULL, 0x000fe20000011665ULL, 0x2000004bff657230ULL, 0x000fe20000004100ULL,
0x000000ff77217812ULL, 0x000fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fe4000001161fULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000023ff23723eULL, 0x000fc400020006ffULL,
0x00000022ff22723eULL, 0x000fe400020006ffULL, 0x00000008ff897819ULL, 0x000fe20000011689ULL,
0x20000023ff687230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe200020006ffULL,
0x20000022ff4b7230ULL, 0x000fe20000004100ULL, 0x00000008ff207819ULL, 0x000fe40000011620ULL,
0x00000010ff8b7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d707812ULL, 0x000fc400078ec0ffULL,
0x00000094ff4d723eULL, 0x000fe200020006ffULL, 0x2000008dff947230ULL, 0x000fe20000004100ULL,
0x00000089ff77723eULL, 0x000fe200020006ffULL, 0x20000021ff8d7230ULL, 0x000fe20000004100ULL,
0x00000020ff89723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x009800000c20783bULL, 0x000fe20000000200ULL, 0x00000010ff8a7819ULL, 0x000fe2000001161dULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000ffff1d8e7812ULL, 0x000fe200078ec0ffULL,
0x20000089ff897230ULL, 0x000fe20000004100ULL, 0x000000ff88887812ULL, 0x000fc400078ec0ffULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff1d997812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7a7819ULL, 0x000fe4000001167aULL, 0x000000ff7b7b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff1f723eULL, 0x000fe400000010ffULL, 0x00000018ff957819ULL, 0x000fc4000001161dULL,
0x0000ffff1e767812ULL, 0x000fe400078ec0ffULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000096ff1e723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x00000099ff96723eULL, 0x000fe200020006ffULL, 0x2000001eff1e7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x20000096ff967230ULL, 0x000fe20000004100ULL, 0x000054101f997816ULL, 0x000fe4000000001fULL,
0x00000095ff1f723eULL, 0x000fe200020006ffULL, 0x20000098ff957230ULL, 0x000fe20000004100ULL,
0x0000008eff72723eULL, 0x000fe200020006ffULL, 0x20000088ff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff887819ULL, 0x000fe20000011686ULL, 0x2000008aff987230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe20000011678ULL, 0x2000007aff8a7230ULL, 0x000fe20000004100ULL,
0x000000ff829a7812ULL, 0x000fe200078ec0ffULL, 0x2000007bff867230ULL, 0x000fe20000004100ULL,
0x00001f0e997a7589ULL, 0x000e6200000e0000ULL, 0x00000008ff827819ULL, 0x000fe20000011681ULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x00001f9c997b7589ULL, 0x00072200000e0000ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000072ff727230ULL, 0x000fe20000004100ULL, 0x0000009aff9b723eULL, 0x000fc400020006ffULL,
0x00000082ff9a723eULL, 0x000fe400020006ffULL, 0x00000010ff1d7819ULL, 0x000fe2000001164aULL,
0x2000009bff827230ULL, 0x000fe20000004100ULL, 0x00000080ff81723eULL, 0x000fe200020006ffULL,
0x20000078ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff997819ULL, 0x008fe2000001161cULL,
0x2000009aff787230ULL, 0x000fe20000004100ULL, 0x000000ff1d9a7812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fc40000011695ULL,
0x00000010ff1d7819ULL, 0x000fe40000011696ULL, 0x00000010ff977819ULL, 0x000fe20000011697ULL,
0x0000007a21218231ULL, 0x082fe200003400ffULL, 0x00000010ff987819ULL, 0x000fe20000011698ULL,
0x0000007a23238231ULL, 0x000fe200003400ffULL, 0x00001054971c7816ULL, 0x000fe2000000001cULL,
0x0000007b20208231ULL, 0x090fe200003400ffULL, 0x00001054981d7816ULL, 0x000fe2000000001dULL,
0x0000007b22228231ULL, 0x000fe200003400ffULL, 0x00000008ff767819ULL, 0x000fc40000011676ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x0000001c2028723cULL, 0x000fe20000041828ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x20000076ff767230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x00000008ff8f7819ULL, 0x000fc4000001168fULL, 0x00000010ff1d7819ULL, 0x000fe2000001161eULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff1c7819ULL, 0x000fe4000001161fULL,
0x00000010ff1e7819ULL, 0x000fe4000001164bULL, 0x00000010ff1f7819ULL, 0x000fe40000011672ULL,
0x000010541d1e7816ULL, 0x000fe4000000001eULL, 0x000010541c1f7816ULL, 0x000fc4000000001fULL,
0x00000010ff1c7819ULL, 0x000fe40000011691ULL, 0x00000010ff1d7819ULL, 0x000fe40000011692ULL,
0x00001054931c7816ULL, 0x000fe2000000001cULL, 0x0000001e202c723cULL, 0x000fe2000004182cULL,
0x00001054941d7816ULL, 0x000fe4000000001dULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000000ff87877812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1f7819ULL, 0x000fe2000001164cULL,
0x0000001c2030723cULL, 0x000fe20000041830ULL, 0x00000010ff1e7819ULL, 0x000fe2000001164dULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fe40000011676ULL,
0x00000010ff4d7819ULL, 0x000fe40000011677ULL, 0x000010541f4c7816ULL, 0x000fe4000000004cULL,
0x000010541e4d7816ULL, 0x000fc4000000004dULL, 0x009800000d1c783bULL, 0x000e620000000200ULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff4f7819ULL, 0x000fe2000001164fULL, 0x2000008fff767230ULL, 0x000fe20000004100ULL,
0x00000010ff8d7819ULL, 0x000fe2000001168dULL, 0x0000004c2034723cULL, 0x000fe20000041834ULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x000000ff8b8b7812ULL, 0x000fc400078ec0ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x000010548d4e7816ULL, 0x000fe4000000004eULL,
0x000010548e4f7816ULL, 0x000fe2000000004fULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x0000008bff8f723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fe40000011679ULL,
0x00000010ff4c7819ULL, 0x000fe20000011689ULL, 0x0000004e2038723cULL, 0x000fe20000041838ULL,
0x00000010ff8b7819ULL, 0x000fe2000001167cULL, 0x2000008fff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000010544d4c7816ULL, 0x000fe4000000004cULL, 0x000010548b4d7816ULL, 0x000fe2000000008aULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fe40000011683ULL,
0x00000010ff4f7819ULL, 0x000fe40000011686ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x0000004c203c723cULL, 0x000fe2000004183cULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x0000007b1c1c8231ULL, 0x082fe200003400ffULL, 0x000010544f4e7816ULL, 0x000fe2000000004eULL,
0x0000007b1e1e8231ULL, 0x000fe200003400ffULL, 0x00001054874f7816ULL, 0x000fe20000000084ULL,
0x0000007a1d1d8231ULL, 0x080fe200003400ffULL, 0x00000010ff857819ULL, 0x000fe20000011685ULL,
0x0000007a1f1f8231ULL, 0x000fe200003400ffULL, 0x00000010ff887819ULL, 0x000fc40000011688ULL,
0x00000010ff847819ULL, 0x000fe2000001167dULL, 0x0000004e2040723cULL, 0x000fe20000041840ULL,
0x00000010ff4d7819ULL, 0x000fe40000011680ULL, 0x0000ffff4a4a7812ULL, 0x000fe400078ec0ffULL,
0x00000048ff48723eULL, 0x000fe400020006ffULL, 0x00000099ff99723eULL, 0x000fe400020006ffULL,
0x00001054854c7816ULL, 0x000fe20000000088ULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00001054844d7816ULL, 0x000fc4000000004dULL, 0x000000ff74967812ULL, 0x000fe400078ec0ffULL,
0x00000008ff957819ULL, 0x000fe2000001164aULL, 0x20000099ff4a7230ULL, 0x000fe20000004100ULL,
0x0000009aff9a723eULL, 0x000fe200020006ffULL, 0x0000004c2024723cULL, 0x000fe20000041824ULL,
0x00000096ff96723eULL, 0x000fe400020006ffULL, 0x00000010ff497819ULL, 0x000fe20000011649ULL,
0x2000009aff747230ULL, 0x000fe20000004100ULL, 0x00000010ff487819ULL, 0x000fe20000011648ULL,
0x20000096ff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fc40000011678ULL,
0x00000010ff217819ULL, 0x000fe4000001164aULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000095ff95723eULL, 0x000fe400020006ffULL, 0x0000105449207816ULL, 0x000fe20000000020ULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000105448217816ULL, 0x000fe20000000021ULL,
0x20000095ff727230ULL, 0x000fe20000004100ULL, 0x00000010ff227819ULL, 0x000fc40000011673ULL,
0x00000010ff237819ULL, 0x000fe40000011674ULL, 0x00000010ff717819ULL, 0x000fe20000011671ULL,
0x000000201c2c723cULL, 0x000fe2000004182cULL, 0x00000010ff487819ULL, 0x000fe4000001164bULL,
0x00000008ff8c7819ULL, 0x000fe4000001168cULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x0000105423227816ULL, 0x000fc40000000022ULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x0000105448237816ULL, 0x000fe40000000071ULL, 0x00000010ff6b7819ULL, 0x000fe4000001166bULL,
0x00000010ff487819ULL, 0x000fe4000001166dULL, 0x00000010ff207819ULL, 0x000fe20000011672ULL,
0x000000221c30723cULL, 0x000fe20000041830ULL, 0x00000010ff217819ULL, 0x000fc40000011676ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x2000008cff797230ULL, 0x000fe20000004100ULL,
0x000010546b207816ULL, 0x000fe20000000020ULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x0000105448217816ULL, 0x000fe20000000021ULL, 0x20000090ff777230ULL, 0x000fe20000004100ULL,
0x000000ff75757812ULL, 0x000fc400078ec0ffULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff647819ULL, 0x000fe20000011664ULL, 0x000000201c34723cULL, 0x000fe20000041834ULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff487819ULL, 0x000fe40000011667ULL, 0x00000010ff207819ULL, 0x000fc40000011679ULL,
0x00000010ff217819ULL, 0x000fe40000011670ULL, 0x00000010ff227819ULL, 0x000fe4000001166cULL,
0x00000010ff237819ULL, 0x000fe40000011666ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x0000007eff7e723eULL, 0x000fc400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000075ff757230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000105469207816ULL, 0x000fe20000000020ULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000105448217816ULL, 0x000fe20000000021ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000105477227816ULL, 0x000fc40000000022ULL,
0x000010547c237816ULL, 0x000fe40000000023ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x000000201c3c723cULL, 0x040fe2000004183cULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff207819ULL, 0x000fe20000011665ULL, 0x000000221c38723cULL, 0x000fe20000041838ULL,
0x00000010ff757819ULL, 0x000fc40000011675ULL, 0x00000010ff487819ULL, 0x000fe40000011663ULL,
0x00000010ff217819ULL, 0x000fe4000001166eULL, 0x00000010ff227819ULL, 0x000fe4000001166fULL,
0x00000010ff237819ULL, 0x000fe40000011668ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff657819ULL, 0x000fc4000001166aULL, 0x00001054814e7816ULL, 0x000fe4000000007eULL,
0x00001054824f7816ULL, 0x000fe4000000007fULL, 0x0000105475227816ULL, 0x000fe40000000022ULL,
0x0000105448237816ULL, 0x000fe40000000023ULL, 0x0000105421647816ULL, 0x000fe20000000064ULL,
0x0000004e1c28723cULL, 0x000fe20000041828ULL, 0x0000105420657816ULL, 0x000fc40000000065ULL,
0x00000002ff207819ULL, 0x000fca000001161aULL, 0x000000221c40723cULL, 0x040ff00000041840ULL,
0x000000641c24723cULL, 0x000fee0000041824ULL, 0x0000f620201c7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff20000008000ULL, 0x000020000fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000004191d7824ULL, 0x000fe200078e0220ULL,
0x000000ff62ff7812ULL, 0x000fe2000784c0ffULL, 0x000000001cff7f8cULL, 0x0007e2000c80043fULL,
0x0000000111ff7812ULL, 0x000fc4000782c0ffULL, 0x000000801d1d7811ULL, 0x000fe400078e30ffULL,
0x00000001ff637807ULL, 0x000fe40001000000ULL, 0x000000001d00720cULL, 0x000fe40003f46070ULL,
0x000000ff12ff7812ULL, 0x000fe4000780c0ffULL, 0x00000062634e7207ULL, 0x000fe40004800000ULL,
0x00000001ff4d7807ULL, 0x000fc40004000000ULL, 0x00000001114c7812ULL, 0x000fca00078ec0ffULL,
0x0000464000002947ULL, 0x000fea0003800000ULL, 0x000024000f1d7984ULL, 0x008ee20000000800ULL,
0x00000001ff1c7807ULL, 0x000fca0004000000ULL, 0x800000001c067824ULL, 0x000fca00078e00ffULL,
0x800000001dff7812ULL, 0x008fe20007824806ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x000024000f1d7984ULL, 0x000ee40000000800ULL,
0x800000001dff7812ULL, 0x008fe40007824806ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000001c1d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x00000006001c7305ULL, 0x000724000021f000ULL,
0x3fa0000006067823ULL, 0x008fe200000100ffULL, 0x0000001c0000735dULL, 0x010fe40003800000ULL,
0x000024000f1c7984ULL, 0x000ee40000000800ULL, 0x800000001cff7812ULL, 0x008fc4000782481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff067819ULL, 0x000fe4000001161aULL, 0x00000001191f7810ULL, 0x000fe40007ffe0ffULL,
0x00000003ff497819ULL, 0x000fe20000011603ULL, 0x00000020061c7824ULL, 0x000fe200078e025dULL,
0x000000021f00720cULL, 0x000fe20003f26070ULL, 0x00000080ff5d7424ULL, 0x000fe200078e00ffULL,
0x00000004494f7810ULL, 0x000fe40007ffe0ffULL, 0x000000c01c1c7810ULL, 0x000fc40007ffe0ffULL,
0x00000008494d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001c001d7217ULL, 0x000fe20007800000ULL,
0x0000620005217a24ULL, 0x000fe200078e021cULL, 0x0000000c494b7810ULL, 0x000fc60007ffe0ffULL,
0x000000011d1d7824ULL, 0x000fe200078e0a1cULL, 0x00000049211c7210ULL, 0x140fe40007ffe008ULL,
0x0000004f211e7210ULL, 0x100fe40007ffe008ULL, 0x000000201d1f7807ULL, 0x000fe20000800000ULL,
0x00005e001c1c7625ULL, 0x000fe200078e005dULL, 0x0000004d21207210ULL, 0x000fe40007ffe008ULL,
0x0000001f08237217ULL, 0x000fe20007800000ULL, 0x00005e001e1e7625ULL, 0x000fe200078e005dULL,
0x000000151c1c7210ULL, 0x000fc40007f3e0ffULL, 0x0000004b21227210ULL, 0x100fe20007ffe008ULL,
0x0000000123487824ULL, 0x000fe200078e0a08ULL, 0x000000151e1e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe400008e061dULL, 0x00005e0020207625ULL, 0x080fe200078e005dULL,
0x000000484900720cULL, 0x080fe40003f46070ULL, 0x000000484f00720cULL, 0x080fe20003f26070ULL,
0x00005e0022227625ULL, 0x000fe200078e005dULL, 0x000000484b00720cULL, 0x000fc40003f86070ULL,
0x0000001520207210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x000000484d00720cULL, 0x000fe40003f66070ULL, 0x0000001522227210ULL, 0x000fe20007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200028e0621ULL, 0x0000000860497812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c5b7faeULL, 0x0007e4000d101c48ULL,
0x000000ffff237224ULL, 0x000fe400030e0623ULL, 0x000000001e5a7faeULL, 0x0007e2000c901c48ULL,
0x0000001006487824ULL, 0x000fc600078e0249ULL, 0x0000000020597faeULL, 0x0007e8000d901c48ULL,
0x0000000022587faeULL, 0x0007e8000e101c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f64c00481d7984ULL, 0x0087220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f62c00131e7984ULL, 0x000f620000000800ULL, 0x0000000111ff7812ULL, 0x000fe2000782c0ffULL,
0x80000000141f7824ULL, 0x000fc600078e00ffULL, 0x0000006263587207ULL, 0x000fc80004800000ULL,
0x0000ffff581c7812ULL, 0x000fc800078ec0ffULL, 0x000088801c1c7816ULL, 0x000fca00000000ffULL,
0x800000001c1c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x010fe4000784481cULL,
0x800000001eff7812ULL, 0x020fe2000786481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000003947ULL, 0x000fea0003800000ULL, 0x000000041a137824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000141e7824ULL, 0x000fe200078e00ffULL,
0xfffffff013137812ULL, 0x000fe400078ec0ffULL, 0x0000001c001d7305ULL, 0x000964000021f000ULL,
0x3fa000001c1c7823ULL, 0x010fe200000100ffULL, 0x0000001d0000735dULL, 0x020fe40003800000ULL,
0x00f62c00131d7984ULL, 0x000f240000000800ULL, 0x800000001dff7812ULL, 0x010fc4000786481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x00000100151c7810ULL, 0x000fe20007ffe016ULL, 0x00000001ff487424ULL, 0x008fc800078e00ffULL,
0x00000001171c7824ULL, 0x000fca00078e021cULL, 0x00f000001c1d7984ULL, 0x000ee80000000800ULL,
0x00f200001c1e7984ULL, 0x0008620000000800ULL, 0x0000000a1d00720bULL, 0x008fda0003f7d000ULL,
0x00000000001f7806ULL, 0x000fc800018e0100ULL, 0x0000ffff1f227812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x0000000a1d00720bULL, 0x012fe40003f74000ULL,
0x0000001d0a207209ULL, 0x080fe40007810000ULL, 0x000000021a1f7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff4a7819ULL, 0x000fe20000011603ULL, 0x800000200a1c7221ULL, 0x040fe20000010000ULL,
0x0000001d0a0a7209ULL, 0x000fc60007810000ULL, 0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL,
0x00000000001c7806ULL, 0x000fe400018e0100ULL, 0x0000001a1f00720cULL, 0x000fe40003f65270ULL,
0x0000ffff1c237812ULL, 0x000fe200078e3cffULL, 0x0000002100217308ULL, 0x000e660000000800ULL,
0x0000002322ff7212ULL, 0x000fce000788c0ffULL, 0x000000801a48b824ULL, 0x000fc800078e0215ULL,
0x000000011723b824ULL, 0x000fe200078e0248ULL, 0x00000001ff487807ULL, 0x000fe20002000000ULL,
0x00001f4a211c7589ULL, 0x002e6200000e0000ULL, 0x800000201d224221ULL, 0x000fe20000010000ULL,
0x000000210b0b7220ULL, 0x000fe40000410000ULL, 0x00001f0e211f7589ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b22224820ULL, 0x000fc60000410000ULL, 0x00f400202300b388ULL, 0x0009e20000000800ULL,
0x0000002200184308ULL, 0x000f620000000800ULL, 0x0000001c28287220ULL, 0x082fe20000410000ULL,
0x0000001c29297220ULL, 0x080fe20000410000ULL, 0x0000001c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001c30307220ULL, 0x080fe20000410000ULL,
0x0000001c31317220ULL, 0x080fe20000410000ULL, 0x0000001c34347220ULL, 0x080fe20000410000ULL,
0x0000001c35357220ULL, 0x080fe20000410000ULL, 0x0000001c38387220ULL, 0x080fe20000410000ULL,
0x0000001c39397220ULL, 0x080fe20000410000ULL, 0x0000001c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001c40407220ULL, 0x080fe20000410000ULL,
0x0000001c41417220ULL, 0x080fe20000410000ULL, 0x0000001c24247220ULL, 0x080fe20000410000ULL,
0x0000001c25257220ULL, 0x000fe20000410000ULL, 0x0000001f2a2a7220ULL, 0x088fe20000410000ULL,
0x0000001f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001f32327220ULL, 0x080fe20000410000ULL,
0x0000001f33337220ULL, 0x080fe20000410000ULL, 0x0000001f36367220ULL, 0x080fe20000410000ULL,
0x0000001f37377220ULL, 0x080fe20000410000ULL, 0x0000001f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001f3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001f3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001f42427220ULL, 0x080fe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f26267220ULL, 0x080fe20000410000ULL,
0x0000001f27277220ULL, 0x000fe20000410000ULL, 0x0000001e181e4220ULL, 0x020fc80000410000ULL,
0x0000000b1e0b7221ULL, 0x012fe20000010000ULL, 0x0000016000002947ULL, 0x000fea0003800000ULL,
0x000000081a1c7824ULL, 0x000fe200078e00ffULL, 0x00000008601e7812ULL, 0x000fc400078ec0ffULL,
0x0000000111ff7812ULL, 0x000fe4000784c0ffULL, 0xfffffff01c1d7812ULL, 0x000fe400078ec0ffULL,
0x00000062631c7207ULL, 0x000fc60005000000ULL, 0x000000011e1e7824ULL, 0x000fe200078e021dULL,
0x0000ffff1c1c7812ULL, 0x000fc800078ec0ffULL, 0x00f64c001e1d7984ULL, 0x000e620000000800ULL,
0x000088801c1f7816ULL, 0x000fca00000000ffULL, 0x800000001f1c7824ULL, 0x000fca00078e00ffULL,
0x800000001dff7812ULL, 0x002fe2000784481cULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000001f207824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002e4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x008fe40003800000ULL,
0x00f64c001e1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc40007844820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000010001a1c7824ULL, 0x000fe200078e00ffULL, 0x00001000614c7812ULL, 0x000fe400078ec0ffULL,
0x00009910484d7816ULL, 0x000fe400000000ffULL, 0xffffe0001c1d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d00720cULL, 0x000fe40003f45270ULL, 0x0000b0001d207810ULL, 0x100fe40007ffe04cULL,
0x0000b000074c7810ULL, 0x000fc40007ffe04cULL, 0x00000018ff8b723eULL, 0x000fe200000010ffULL,
0x000000105e1c7824ULL, 0x100fe200078e0220ULL, 0x00000002ff907819ULL, 0x000fe20000011603ULL,
0x0000001057207824ULL, 0x000fe200078e0220ULL, 0x000054108b8b7816ULL, 0x000fe2000000008bULL,
0x0000001056497824ULL, 0x100fe400078e024cULL, 0x00000010554c7824ULL, 0x000fe200078e024cULL,
0x000000001c1c783bULL, 0x000e680000004200ULL, 0x000000002020783bULL, 0x000ee80000004200ULL,
0x000000004948783bULL, 0x000f280000004200ULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x00000010ff707819ULL, 0x002fc4000001161dULL, 0x000000ff1d557812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7e7819ULL, 0x108fe40000011622ULL, 0x000000ff22797812ULL, 0x040fe400078ec0ffULL,
0x00000018ff697819ULL, 0x000fe40000011622ULL, 0x0000ffff227a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x010fc4000001164aULL, 0x000000ff4a5e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a227812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001164bULL, 0x00000018ff897819ULL, 0x000fe4000001161dULL,
0x0000ffff1d867812ULL, 0x000fc400078ec0ffULL, 0x00000010ff747819ULL, 0x100fe40000011649ULL,
0x000000ff495a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff597819ULL, 0x000fe40000011649ULL,
0x0000ffff496a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe4000001161cULL,
0x000000ff1c877812ULL, 0x000fc400078ec0ffULL, 0x00000018ff617819ULL, 0x000fe4000001161cULL,
0x0000ffff1c717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x100fe4000001161eULL,
0x000000ff1e887812ULL, 0x040fe400078ec0ffULL, 0x00000018ff807819ULL, 0x000fe4000001161eULL,
0x0000ffff1e827812ULL, 0x000fc400078ec0ffULL, 0x00000010ff837819ULL, 0x100fe4000001161fULL,
0x000000ff1f817812ULL, 0x040fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001161fULL,
0x0000ffff1f857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x000fe40000011623ULL,
0x000000ff23757812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011623ULL,
0x0000ffff237b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff48577812ULL, 0x000fe400078ec0ffULL,
0x000000ff4b5f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff497819ULL, 0x020fe4000001164eULL,
0x0000004aff4a723eULL, 0x000fc400020006ffULL, 0x00000010ff1c7819ULL, 0x100fe40000011620ULL,
0x000000ff207c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe40000011620ULL,
0x0000ffff201e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff847819ULL, 0x000fe40000011621ULL,
0x000000ff21787812ULL, 0x000fc400078ec0ffULL, 0x00000018ff777819ULL, 0x000fe40000011621ULL,
0x0000ffff211f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6f7819ULL, 0x100fe40000011648ULL,
0x00000018ff567819ULL, 0x000fe40000011648ULL, 0x0000ffff48657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x000fc4000001164bULL, 0x0000ffff4b237812ULL, 0x000fe400078ec0ffULL,
0x00000010ff217819ULL, 0x100fe4000001164cULL, 0x000000ff4c627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001164cULL, 0x0000ffff4c207812ULL, 0x000fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fc4000001164fULL, 0x00000010ff4c7819ULL, 0x000fe4000001164fULL,
0x000000ff4f8e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4f5b7812ULL, 0x000fe400078ec0ffULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x0000005fff4f723eULL, 0x000fe200020006ffULL,
0x2000004aff5f7230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000057ff727230ULL, 0x000fe20000004100ULL, 0x00000018ff8a7819ULL, 0x000fe2000001164dULL,
0x2000004fff4f7230ULL, 0x000fe20000004100ULL, 0x00000048ff4a723eULL, 0x000fc400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000061ff48723eULL, 0x000fe200020006ffULL, 0x20000049ff617230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fe200020006ffULL, 0x2000005aff737230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe40000011665ULL, 0x0000008aff57723eULL, 0x000fe200020006ffULL,
0x20000087ff8a7230ULL, 0x000fe20000004100ULL, 0x00000055ff49723eULL, 0x000fe200020006ffULL,
0x20000048ff877230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x2000004bff5a7230ULL, 0x000fe20000004100ULL, 0x000000ff66667812ULL, 0x000fe200078ec0ffULL,
0x2000004aff557230ULL, 0x000fe20000004100ULL, 0x000000ff68687812ULL, 0x000fe200078ec0ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fc400020006ffULL,
0x00000089ff48723eULL, 0x000fe200020006ffULL, 0x20000049ff897230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x00000080ff4a723eULL, 0x000fe400020006ffULL,
0x00000078ff4b723eULL, 0x000fe200020006ffULL, 0x20000075ff787230ULL, 0x000fe20000004100ULL,
0x000000ff6f6f7812ULL, 0x000fe400078ec0ffULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x00000008ff6a7819ULL, 0x000fc4000001166aULL,
0x00000068ff68723eULL, 0x000fe400020006ffULL, 0x00000088ff49723eULL, 0x000fe200020006ffULL,
0x20000048ff887230ULL, 0x000fe20000004100ULL, 0x00000076ff76723eULL, 0x000fe200020006ffULL,
0x2000004aff487230ULL, 0x000fe20000004100ULL, 0x000000ff74757812ULL, 0x000fe200078ec0ffULL,
0x2000006eff747230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe2000001164dULL,
0x20000065ff6e7230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000066ff657230ULL, 0x000fe20000004100ULL, 0x00000008ff227819ULL, 0x000fe20000011622ULL,
0x20000068ff667230ULL, 0x000fe20000004100ULL, 0x00000008ff237819ULL, 0x000fe20000011623ULL,
0x20000049ff807230ULL, 0x000fe20000004100ULL, 0x000000ff21217812ULL, 0x000fe200078ec0ffULL,
0x2000007dff497230ULL, 0x000fe20000004100ULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x2000005eff607230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000077ff7d7230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x0000007cff4a723eULL, 0x000fe200020006ffULL, 0x20000076ff7c7230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000079ff777230ULL, 0x000fe20000004100ULL,
0x000000ff4e8d7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x00000022ff22723eULL, 0x000fe200020006ffULL, 0x20000069ff797230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fc400020006ffULL, 0x000000ff67687812ULL, 0x000fe200078ec0ffULL,
0x20000022ff677230ULL, 0x000fe20000004100ULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x00000008ff207819ULL, 0x000fe40000011620ULL, 0x00000075ff76723eULL, 0x000fe200020006ffULL,
0x2000006fff757230ULL, 0x000fe20000004100ULL, 0x00000062ff5e723eULL, 0x000fe200020006ffULL,
0x2000006aff6f7230ULL, 0x000fe20000004100ULL, 0x0000008dff62723eULL, 0x000fe200020006ffULL,
0x20000021ff697230ULL, 0x000fe20000004100ULL, 0x00000068ff6a723eULL, 0x000fe200020006ffULL,
0x20000023ff687230ULL, 0x000fe20000004100ULL, 0x00000020ff8d723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x00a000000c20783bULL, 0x000fe20000000200ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff717819ULL, 0x000fe20000011671ULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x000000ff70707812ULL, 0x000fe200078ec0ffULL, 0x20000056ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff4d8c7812ULL, 0x000fe200078ec0ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fc400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x0000008cff56723eULL, 0x000fe400020006ffULL, 0x000000ff6b8c7812ULL, 0x000fe200078ec0ffULL,
0x2000008dff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff8d7819ULL, 0x000fe20000011686ULL,
0x20000071ff867230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x20000070ff8f7230ULL, 0x000fe20000004100ULL, 0x00001f908b717589ULL, 0x000e6200000e0000ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x00001f0e8b707589ULL, 0x00072200000e0000ULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x20000059ff6c7230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fc400020006ffULL, 0x000000ff1d1d7812ULL, 0x000fe400078ec0ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe200020006ffULL, 0x20000083ff8b7230ULL, 0x008fe20000004100ULL,
0x0000008eff59723eULL, 0x000fe200020006ffULL, 0x2000008cff8e7230ULL, 0x000fe20000004100ULL,
0x0000001dff1d723eULL, 0x000fe200020006ffULL, 0x20000082ff837230ULL, 0x000fe20000004100ULL,
0x000000ff84907812ULL, 0x000fe200078ec0ffULL, 0x20000085ff827230ULL, 0x000fe20000004100ULL,
0x000000ff1c857812ULL, 0x000fe200078ec0ffULL, 0x2000001dff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fe2000001168aULL, 0x000000712020a231ULL, 0x082fe200003400ffULL,
0x00000010ff1d7819ULL, 0x000fe2000001168eULL, 0x000000712222a231ULL, 0x000fe200003400ffULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x000000702121a231ULL, 0x090fe200003400ffULL,
0x00000010ff847819ULL, 0x000fe2000001168fULL, 0x000000702323a231ULL, 0x000fe200003400ffULL,
0x0000008dff8d723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000010541d1c7816ULL, 0x000fc4000000001cULL, 0x00001054841d7816ULL, 0x000fe20000000089ULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff1e7819ULL, 0x000fe4000001161eULL,
0x00000008ff1f7819ULL, 0x000fe4000001161fULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x0000001c2028723cULL, 0x000fe20000041828ULL, 0x0000001eff89723eULL, 0x000fe400020006ffULL,
0x0000001fff8a723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000010ff1d7819ULL, 0x000fe20000011687ULL,
0x2000008aff877230ULL, 0x000fe20000004100ULL, 0x00000010ff1e7819ULL, 0x000fe20000011686ULL,
0x20000089ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff1f7819ULL, 0x000fe4000001168dULL,
0x000010541d1e7816ULL, 0x000fe4000000001eULL, 0x00001054881f7816ULL, 0x000fe4000000001fULL,
0x000000ff7e887812ULL, 0x000fc400078ec0ffULL, 0x00000010ff1c7819ULL, 0x000fe40000011680ULL,
0x00000010ff1d7819ULL, 0x000fe2000001168cULL, 0x0000001e202c723cULL, 0x000fe2000004182cULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff7e7819ULL, 0x000fe4000001168bULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x000010547e1d7816ULL, 0x000fc40000000081ULL,
0x00000010ff1f7819ULL, 0x000fe40000011648ULL, 0x00000010ff1e7819ULL, 0x000fe40000011649ULL,
0x00000010ff487819ULL, 0x000fe20000011683ULL, 0x0000001c2030723cULL, 0x000fe20000041830ULL,
0x00000010ff497819ULL, 0x000fe40000011682ULL, 0x000010541f487816ULL, 0x000fe40000000048ULL,
0x000010541e497816ULL, 0x000fc40000000049ULL, 0x00a000000d1c783bULL, 0x000e620000000200ULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000008ff7a7819ULL, 0x000fe2000001167aULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x000000ff7f897812ULL, 0x000fe200078ec0ffULL, 0x20000090ff847230ULL, 0x000fe20000004100ULL,
0x00000008ff807819ULL, 0x000fe2000001167bULL, 0x000000482034723cULL, 0x000fe20000041834ULL,
0x00000010ff4a7819ULL, 0x000fc4000001164aULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x0000007aff7b723eULL, 0x000fe400020006ffULL, 0x00000010ff497819ULL, 0x000fe4000001167cULL,
0x00000010ff487819ULL, 0x000fe20000011686ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fc4000001167dULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000088ff7f723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00001054854a7816ULL, 0x000fe2000000004aULL, 0x20000089ff7e7230ULL, 0x000fe20000004100ULL,
0x00001054844b7816ULL, 0x000fe2000000004bULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x0000105449487816ULL, 0x000fe20000000048ULL, 0x000000711c1ca231ULL, 0x082fe200003400ffULL,
0x000010547a497816ULL, 0x000fe20000000087ULL, 0x000000711e1ea231ULL, 0x000fe200003400ffULL,
0x00000010ff7f7819ULL, 0x000fe2000001167fULL, 0x0000004a2038723cULL, 0x000fe20000041838ULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x000000701d1da231ULL, 0x080fe200003400ffULL,
0x00000010ff7b7819ULL, 0x000fe2000001167bULL, 0x000000701f1fa231ULL, 0x000fe200003400ffULL,
0x00000010ff747819ULL, 0x000fc40000011674ULL, 0x00000010ff4b7819ULL, 0x000fe20000011678ULL,
0x00000048203c723cULL, 0x000fe2000004183cULL, 0x00000010ff4a7819ULL, 0x000fe40000011677ULL,
0x00000010ff787819ULL, 0x000fe40000011679ULL, 0x000010547f4a7816ULL, 0x000fe4000000004aULL,
0x00000010ff497819ULL, 0x000fe40000011680ULL, 0x000010547e4b7816ULL, 0x000fc4000000004bULL,
0x0000105478487816ULL, 0x000fe4000000007bULL, 0x0000105474497816ULL, 0x000fe40000000049ULL,
0x00000010ff6d7819ULL, 0x000fe2000001166dULL, 0x0000004a2040723cULL, 0x000fe20000041840ULL,
0x00000010ff6c7819ULL, 0x000fe4000001166cULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x0000ffff4d4d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff647819ULL, 0x000fe2000001164eULL,
0x000000482024723cULL, 0x000fe20000041824ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff207819ULL, 0x000fe4000001166eULL,
0x00000010ff217819ULL, 0x000fc4000001166fULL, 0x000010546d207816ULL, 0x000fe40000000020ULL,
0x000010546c217816ULL, 0x000fe40000000021ULL, 0x00000010ff227819ULL, 0x000fe40000011660ULL,
0x00000010ff237819ULL, 0x000fe4000001164fULL, 0x000000ff64647812ULL, 0x000fe200078ec0ffULL,
0x000000201c2c723cULL, 0x000fe2000004182cULL, 0x0000ffff4e4e7812ULL, 0x000fc400078ec0ffULL,
0x0000105465227816ULL, 0x000fe40000000022ULL, 0x0000105466237816ULL, 0x000fe40000000023ULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff487819ULL, 0x000fe2000001165fULL, 0x000000221c30723cULL, 0x000fe20000041830ULL,
0x00000010ff207819ULL, 0x000fc40000011667ULL, 0x00000010ff217819ULL, 0x000fe40000011668ULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000008ff4e7819ULL, 0x000fe2000001164eULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000004cff4c723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x000010545d207816ULL, 0x000fc40000000020ULL, 0x0000105448217816ULL, 0x000fe20000000021ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fe4000001165bULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000005bff22723eULL, 0x000fe200020006ffULL,
0x000000201c34723cULL, 0x000fe20000041834ULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x00000010ff207819ULL, 0x000fe40000011657ULL, 0x00000010ff217819ULL, 0x000fe40000011664ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00001054205b7816ULL, 0x000fe4000000004dULL,
0x0000105421207816ULL, 0x000fe40000000062ULL, 0x00000010ff727819ULL, 0x000fc40000011672ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff5f7819ULL, 0x000fe4000001166aULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x000010544c217816ULL, 0x000fe40000000059ULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000010ff4e7819ULL, 0x000fc4000001164eULL,
0x00000010ff4f7819ULL, 0x000fe20000011655ULL, 0x000000201c40723cULL, 0x000fe20000041840ULL,
0x00000010ff227819ULL, 0x000fe40000011622ULL, 0x00001054754a7816ULL, 0x000fe40000000072ULL,
0x00001054764b7816ULL, 0x000fe40000000073ULL, 0x00001054695e7816ULL, 0x000fe4000000005eULL,
0x000010545f5f7816ULL, 0x000fc40000000056ULL, 0x000010545a5a7816ULL, 0x000fe2000000006bULL,
0x0000004a1c28723cULL, 0x000fe20000041828ULL, 0x00001054614e7816ULL, 0x000fe4000000004eULL,
0x000010544f4f7816ULL, 0x000fe40000000022ULL, 0x00000002ff217819ULL, 0x000fc6000001161aULL,
0x0000005e1c38723cULL, 0x040ff00000041838ULL, 0x0000005a1c3c723cULL, 0x040ff0000004183cULL,
0x0000004e1c24723cULL, 0x000fee0000041824ULL, 0x0000f630211c7811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff20000008000ULL, 0x000020000fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000040211d7824ULL, 0x000fe200078e0244ULL,
0x000000ff58ff7812ULL, 0x000fe2000784c0ffULL, 0x000000001cff7f8cULL, 0x0007e2000c80043fULL,
0x000000ff12ff7812ULL, 0x000fc4000786c0ffULL, 0x000000c01d1d7810ULL, 0x000fe40007ffe0ffULL,
0x00000001ff207807ULL, 0x000fe40001000000ULL, 0x000000001d00720cULL, 0x000fe40003f46070ULL,
0x00000001114c7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff4d7807ULL, 0x000fe40001800000ULL,
0x00000020634e7207ULL, 0x000fc40004800000ULL, 0x000000014c4c7812ULL, 0x000fca00078e3cffULL,
0x0000226000002947ULL, 0x000fea0003800000ULL, 0x000024000f067984ULL, 0x008ee20000000800ULL,
0x800000005c1d7824ULL, 0x000fca00078e00ffULL, 0x8000000006ff7812ULL, 0x008fe2000784481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x000024000f067984ULL, 0x000ee40000000800ULL, 0x8000000006ff7812ULL, 0x008fe4000784481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000005c1d7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600127305ULL, 0x000724000021f000ULL, 0x3fa0000006067823ULL, 0x008fe200000100ffULL,
0x000000120000735dULL, 0x010fe40003800000ULL, 0x000024000f127984ULL, 0x000ee40000000800ULL,
0x8000000012ff7812ULL, 0x008fc4000784481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x00000001ff067819ULL, 0x000fe2000001161aULL,
0x00000080ff577424ULL, 0x000fe200078e00ffULL, 0x00000300191d7a10ULL, 0x000fe40007ffe0ffULL,
0x00000003ff4b7819ULL, 0x000fc60000011603ULL, 0x000000081d127824ULL, 0x040fe200078e0206ULL,
0x000000011d1d7810ULL, 0x000fe40007ffe0ffULL, 0x000000044b4d7810ULL, 0x000fe20007ffe0ffULL,
0x0000002012127824ULL, 0x000fe200078e00ffULL, 0x000000021d00720cULL, 0x000fe40003f46070ULL,
0x000000084b4f7810ULL, 0x000fe20007ffe0ffULL, 0x0000620005217a24ULL, 0x000fe200078e0212ULL,
0x00000012001f7217ULL, 0x000fe40007800000ULL, 0x0000000c4b557810ULL, 0x000fc40007ffe0ffULL,
0x0000004b211c7210ULL, 0x000fe20007ffe008ULL, 0x000000011f1f7824ULL, 0x000fe200078e0a12ULL,
0x0000004d211e7210ULL, 0x140fe40007ffe008ULL, 0x0000004f21227210ULL, 0x000fe20007ffe008ULL,
0x00005e001c1c7625ULL, 0x000fe200078e0057ULL, 0x000000201f1f7807ULL, 0x000fc80001000000ULL,
0x0000001f08237217ULL, 0x000fe20007800000ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0057ULL,
0x000000151c487210ULL, 0x000fe40007f5e0ffULL, 0x00000055211c7210ULL, 0x100fe20007ffe008ULL,
0x0000000123127824ULL, 0x000fe200078e0a08ULL, 0x000000151e1e7210ULL, 0x000fe20007f9e0ffULL,
0x00005e0022227625ULL, 0x000fc600078e0057ULL, 0x000000124d00720cULL, 0x080fe20003f66070ULL,
0x000000ffff497224ULL, 0x000fe200010e061dULL, 0x0000001522227210ULL, 0x000fe20007fbe0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0057ULL, 0x000000124b00720cULL, 0x000fc60003f46070ULL,
0x000000ffff1f7224ULL, 0x000fe200020e061fULL, 0x000000124f00720cULL, 0x080fe20003f86070ULL,
0x000000ffff237224ULL, 0x000fe200028e0623ULL, 0x000000125500720cULL, 0x000fe40003fa6070ULL,
0x000000151c1c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000048537faeULL, 0x0007e8000d101c48ULL,
0x000000001e527faeULL, 0x0007e8000d901c48ULL, 0x0000000022517faeULL, 0x0007e8000e101c48ULL,
0x000000001c507faeULL, 0x0007e8000e901c48ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000400541d7984ULL, 0x0087220000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00f63c00131c7984ULL, 0x000f620000000800ULL, 0x0000002063637207ULL, 0x000fe20004800000ULL,
0x80000000141f7824ULL, 0x000fc600078e00ffULL, 0x0000ffff631e7812ULL, 0x000fca00078ec0ffULL,
0x800000001e127824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x010fe40007844812ULL,
0x800000001cff7812ULL, 0x020fe2000786481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000003947ULL, 0x000fea0003800000ULL, 0x80000000141d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200147305ULL, 0x000964000021f000ULL,
0x3fa0000012127823ULL, 0x010fe200000100ffULL, 0x000000140000735dULL, 0x020fe40003800000ULL,
0x00f63c0013147984ULL, 0x000f240000000800ULL, 0x8000000014ff7812ULL, 0x010fc4000786481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000b947ULL, 0x000fea000383ffffULL,
0x0000018015167810ULL, 0x000fe20007ffe016ULL, 0x00000001ff217424ULL, 0x000fc800078e00ffULL,
0x0000000117167824ULL, 0x000fca00078e0216ULL, 0x00f00000161d7984ULL, 0x000f280000000800ULL,
0x00f2000016127984ULL, 0x0002a20000000800ULL, 0x0000000a1d00720bULL, 0x010fda0003f7d000ULL,
0x0000000000147806ULL, 0x000fc800018e0100ULL, 0x0000ffff141c7812ULL, 0x000fda000786c0ffULL,
0x000003700000b947ULL, 0x000fea0003800000ULL, 0x0000000a1d00720bULL, 0x006fe40003f74000ULL,
0x0000001d0a167209ULL, 0x000fe40007810000ULL, 0x000000031a1f7811ULL, 0x000fe400078ff0ffULL,
0x00000002ff237819ULL, 0x000fe20000011603ULL, 0x800000160a147221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b14147820ULL, 0x000fe40000410000ULL, 0x00000000000a7806ULL, 0x000fe400018e0100ULL,
0x0000001a1f00720cULL, 0x000fe20003f65270ULL, 0x0000001400227308ULL, 0x000e620000000800ULL,
0x0000ffff0a217812ULL, 0x000fc800078e3cffULL, 0x000000211cff7212ULL, 0x000fc8000788c0ffULL,
0x00000001ff217807ULL, 0x000fc60002000000ULL, 0x000000801a1cb824ULL, 0x000fe200078e0215ULL,
0x00001f23220a7589ULL, 0x002e6600000e0000ULL, 0x000000011717b824ULL, 0x000fe400078e021cULL,
0x800000161d1d4221ULL, 0x000fe20000010000ULL, 0x000000220b0b7220ULL, 0x000fe20000410000ULL,
0x00001f0e22147589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b1d1d4820ULL, 0x000fc40000410000ULL,
0x00f400161700b388ULL, 0x0009e40000000800ULL, 0x0000001d00184308ULL, 0x000f620000000800ULL,
0x0000000a28287220ULL, 0x082fe20000410000ULL, 0x0000000a29297220ULL, 0x080fe20000410000ULL,
0x0000000a2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000a2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000a30307220ULL, 0x080fe20000410000ULL, 0x0000000a31317220ULL, 0x080fe20000410000ULL,
0x0000000a34347220ULL, 0x080fe20000410000ULL, 0x0000000a35357220ULL, 0x080fe20000410000ULL,
0x0000000a38387220ULL, 0x080fe20000410000ULL, 0x0000000a39397220ULL, 0x080fe20000410000ULL,
0x0000000a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000a3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000a40407220ULL, 0x080fe20000410000ULL, 0x0000000a41417220ULL, 0x080fe20000410000ULL,
0x0000000a24247220ULL, 0x080fe20000410000ULL, 0x0000000a25257220ULL, 0x000fe20000410000ULL,
0x000000142a2a7220ULL, 0x084fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x080fe20000410000ULL,
0x000000143a3a7220ULL, 0x080fe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x000000143e3e7220ULL, 0x080fe20000410000ULL, 0x000000143f3f7220ULL, 0x080fe20000410000ULL,
0x0000001442427220ULL, 0x080fe20000410000ULL, 0x0000001443437220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x000fe20000410000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0016ULL, 0x0000001218124220ULL, 0x020fc80000410000ULL,
0x0000000b120b7221ULL, 0x016fe20000010000ULL, 0x0000013000002947ULL, 0x000fea0003800000ULL,
0x0000000811127824ULL, 0x000fe400078e00ffULL, 0x000000081a147824ULL, 0x000fc400078e00ffULL,
0x800000001e177824ULL, 0x000fe200078e00ffULL, 0x0000000812127812ULL, 0x000fe400078e0cffULL,
0xfffffff014157812ULL, 0x000fca00078ec0ffULL, 0x0000000112157824ULL, 0x000fca00078e0215ULL,
0x00f64c0015127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007844817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001e177824ULL, 0x000fe400078e00ffULL, 0x3e000000ff127424ULL, 0x000fc800078e00ffULL,
0x0000001200147305ULL, 0x0002a4000021f000ULL, 0x3fa0000012127823ULL, 0x002fe200000100ffULL,
0x000000140000735dULL, 0x004fe40003800000ULL, 0x00f64c0015147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fc40007844817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000004648783bULL, 0x000e620000004200ULL,
0x00000018ff56723eULL, 0x000fc600000010ffULL, 0x00000000451c783bULL, 0x000ea20000004200ULL,
0x0000541056627816ULL, 0x000fc60000000056ULL, 0x00000000474c783bULL, 0x000f280000004200ULL,
0x000000001b14783bULL, 0x000f680000004200ULL, 0x00001f0e62567589ULL, 0x0007e200000e0000ULL,
0x00000010ff707819ULL, 0x002fe4000001164aULL, 0x000000ff4a7c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe4000001164aULL, 0x0000ffff4a657812ULL, 0x000fe400078ec0ffULL,
0x00000010ff667819ULL, 0x100fe4000001164bULL, 0x000000ff4b7e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001164bULL, 0x0000ffff4b677812ULL, 0x000fc400078ec0ffULL,
0x00000010ff647819ULL, 0x104fe4000001161cULL, 0x000000ff1c7f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff547819ULL, 0x008fe4000001161cULL, 0x0000ffff1c5f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x010fe4000001164cULL, 0x000000ff4c237812ULL, 0x000fc400078ec0ffULL,
0x00000018ff227819ULL, 0x000fe4000001164cULL, 0x0000ffff4c797812ULL, 0x000fe400078ec0ffULL,
0x00000010ff537819ULL, 0x100fe4000001164dULL, 0x000000ff4d557812ULL, 0x040fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe4000001164dULL, 0x0000ffff4d787812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1c7819ULL, 0x100fe4000001161fULL, 0x000000ff1f4b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001161fULL, 0x0000ffff1f6c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff777819ULL, 0x000fe4000001164eULL, 0x000000ff4e597812ULL, 0x000fc400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe4000001164eULL, 0x0000ffff4e717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7a7819ULL, 0x100fe4000001164fULL, 0x000000ff4f5b7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001164fULL, 0x0000ffff4f727812ULL, 0x000fc400078ec0ffULL,
0x00009910211f7816ULL, 0x000fe400000000ffULL, 0x00000010ff6d7819ULL, 0x120fe40000011614ULL,
0x000000ff144c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011614ULL,
0x0000ffff14447812ULL, 0x000fe400078ec0ffULL, 0x00000010ff757819ULL, 0x000fc40000011649ULL,
0x000000ff49617812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5e7819ULL, 0x000fe40000011649ULL,
0x0000ffff49697812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x100fe40000011615ULL,
0x000000ff15507812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fc40000011615ULL,
0x0000ffff15127812ULL, 0x000fe400078ec0ffULL, 0x00000010ff1b7819ULL, 0x100fe40000011616ULL,
0x000000ff164f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff147819ULL, 0x000fe40000011616ULL,
0x0000ffff16217812ULL, 0x000fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fc4000001161dULL,
0x00000010ff467819ULL, 0x100fe40000011617ULL, 0x000000ff17167812ULL, 0x040fe400078ec0ffULL,
0x00000018ff157819ULL, 0x000fe40000011617ULL, 0x0000ffff17477812ULL, 0x000fe400078ec0ffULL,
0x000000ff1e527812ULL, 0x000fe400078ec0ffULL, 0x00000002ff177819ULL, 0x000fc40000011603ULL,
0x00000010ff737819ULL, 0x100fe40000011648ULL, 0x000000ff485d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011648ULL, 0x0000ffff48767812ULL, 0x000fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe4000001161eULL, 0x00000049ff49723eULL, 0x000fc400020006ffULL,
0x00000055ff74723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x00001f1762557589ULL, 0x0003e200000e0000ULL, 0x00000054ff0e723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000050ff54723eULL, 0x000fe400020006ffULL,
0x0000004dff50723eULL, 0x000fe200020006ffULL, 0x2000000eff0e7230ULL, 0x000fe20000004100ULL,
0x00000008ff797819ULL, 0x000fc40000011679ULL, 0x00000015ff15723eULL, 0x000fe400020006ffULL,
0x0000004bff17723eULL, 0x002fe400020006ffULL, 0x00000048ff4b723eULL, 0x000fe200020006ffULL,
0x20000049ff487230ULL, 0x000fe20000004100ULL, 0x00000008ff787819ULL, 0x000fe20000011678ULL,
0x20000052ff497230ULL, 0x000fe20000004100ULL, 0x0000004aff52723eULL, 0x000fe200020006ffULL,
0x20000017ff4a7230ULL, 0x000fe20000004100ULL, 0x0000004cff17723eULL, 0x000fe200020006ffULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x000000ff77777812ULL, 0x000fe200078ec0ffULL,
0x20000052ff4c7230ULL, 0x000fe20000004100ULL, 0x0000004eff52723eULL, 0x000fe200020006ffULL,
0x20000017ff4d7230ULL, 0x000fe20000004100ULL, 0x0000004fff17723eULL, 0x000fe200020006ffULL,
0x20000050ff4f7230ULL, 0x000fe20000004100ULL, 0x000000ff7a7a7812ULL, 0x000fe200078ec0ffULL,
0x20000052ff507230ULL, 0x000fe20000004100ULL, 0x00000016ff52723eULL, 0x000fe200020006ffULL,
0x20000054ff4e7230ULL, 0x000fe20000004100ULL, 0x000000ff51167812ULL, 0x000fe200078ec0ffULL,
0x20000017ff517230ULL, 0x000fe20000004100ULL, 0x00000014ff17723eULL, 0x000fe200020006ffULL,
0x20000015ff547230ULL, 0x000fe20000004100ULL, 0x000000ff53147812ULL, 0x000fe200078ec0ffULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x20000017ff537230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fc400020006ffULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400020006ffULL,
0x0000007aff15723eULL, 0x000fe200020006ffULL, 0x20000079ff7a7230ULL, 0x000fe20000004100ULL,
0x000000ff1f00720cULL, 0x000fe20003f45270ULL, 0x20000078ff797230ULL, 0x000fe20000004100ULL,
0x00000008ff717819ULL, 0x000fe20000011671ULL, 0x20000077ff787230ULL, 0x000fe20000004100ULL,
0x00000008ff727819ULL, 0x000fe20000011672ULL, 0x20000015ff777230ULL, 0x000fe20000004100ULL,
0x00000023ff1f723eULL, 0x000fc400020006ffULL, 0x000000ff75757812ULL, 0x000fe400078ec0ffULL,
0x0000005aff23723eULL, 0x000fe200020006ffULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000023ff237230ULL, 0x000fe20000004100ULL, 0x0000007cff5a723eULL, 0x000fe200020006ffULL,
0x20000014ff7c7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000005dff627230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x00000016ff16723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000075ff15723eULL, 0x000fe200020006ffULL,
0x20000071ff757230ULL, 0x000fe20000004100ULL, 0x00000008ff147819ULL, 0x000fe20000011676ULL,
0x20000072ff767230ULL, 0x000fe20000004100ULL, 0x0000007bff5c723eULL, 0x000fe200020006ffULL,
0x20000016ff7b7230ULL, 0x000fe20000004100ULL, 0x00000014ff71723eULL, 0x000fe200020006ffULL,
0x20000015ff727230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fe200020006ffULL,
0x00a800000c14783bULL, 0x0002a20000000200ULL, 0x00000008ff697819ULL, 0x000fe20000011669ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000ffff1d687812ULL, 0x000fe200078ec0ffULL,
0x20000057ff6a7230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fc400020006ffULL,
0x00000010ff607819ULL, 0x000fe4000001161dULL, 0x000000ff1d807812ULL, 0x000fe400078ec0ffULL,
0x000000ff640c7812ULL, 0x002fe400078ec0ffULL, 0x00000010ff1d7819ULL, 0x000fe4000001161eULL,
0x0000007dff57723eULL, 0x000fe400020006ffULL, 0x00000008ff5f7819ULL, 0x000fc4000001165fULL,
0x000000ff707d7812ULL, 0x000fe200078ec0ffULL, 0x20000071ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe20000011668ULL, 0x20000069ff717230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x000000ff1d697812ULL, 0x000fe200078ec0ffULL,
0x2000005bff6f7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fc400020006ffULL,
0x00000068ff1d723eULL, 0x000fe200020006ffULL, 0x2000000cff687230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x2000005fff0c7230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x2000001dff5f7230ULL, 0x000fe20000004100ULL,
0x0000ffff1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000007eff5b723eULL, 0x000fe200020006ffULL,
0x000000551414a231ULL, 0x084fe200003400ffULL, 0x000000ff60607812ULL, 0x000fe200078ec0ffULL,
0x000000551616a231ULL, 0x000fe200003400ffULL, 0x00000008ff7e7819ULL, 0x000fe20000011667ULL,
0x000000561515a231ULL, 0x080fe200003400ffULL, 0x00000022ff22723eULL, 0x000fe200020006ffULL,
0x000000561717a231ULL, 0x000fe200003400ffULL, 0x00000065ff67723eULL, 0x000fe200020006ffULL,
0x2000007dff657230ULL, 0x000fe20000004100ULL, 0x000000ff1c1d7812ULL, 0x000fe200078ec0ffULL,
0x20000022ff6b7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000008ff1c7819ULL, 0x000fe2000001161eULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fc400020006ffULL,
0x00000069ff7d723eULL, 0x000fe200020006ffULL, 0x20000060ff697230ULL, 0x000fe20000004100ULL,
0x00000010ff1e7819ULL, 0x000fe2000001161fULL, 0x2000007eff647230ULL, 0x000fe20000004100ULL,
0x00000010ff1f7819ULL, 0x000fe20000011674ULL, 0x2000007dff607230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff7c7819ULL, 0x000fe4000001167cULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x000010547b1e7816ULL, 0x000fe4000000001eULL,
0x000010547c1f7816ULL, 0x000fe2000000001fULL, 0x20000059ff6e7230ULL, 0x000fe20000004100ULL,
0x0000001dff7e723eULL, 0x000fe400020006ffULL, 0x0000001cff7d723eULL, 0x000fe400020006ffULL,
0x00000010ff1d7819ULL, 0x000fe2000001166bULL, 0x0000001e1428723cULL, 0x000fe20000041828ULL,
0x00000010ff1c7819ULL, 0x000fe2000001167aULL, 0x2000007eff6b7230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe2000001166aULL, 0x2000007dff6a7230ULL, 0x000fe20000004100ULL,
0x00000010ff797819ULL, 0x000fc40000011679ULL, 0x00000058ff22723eULL, 0x000fe400020006ffULL,
0x000010541d1c7816ULL, 0x000fe4000000001cULL, 0x00001054741d7816ULL, 0x000fe20000000079ULL,
0x20000022ff227230ULL, 0x000fe20000004100ULL, 0x00000008ff747819ULL, 0x000fe4000001166cULL,
0x00000010ff1e7819ULL, 0x000fe4000001166eULL, 0x00000010ff1f7819ULL, 0x000fe20000011678ULL,
0x0000001c142c723cULL, 0x000fe2000004182cULL, 0x00000010ff6f7819ULL, 0x000fc4000001166fULL,
0x00000010ff6c7819ULL, 0x000fe40000011677ULL, 0x000010541f1e7816ULL, 0x000fe4000000001eULL,
0x000010546c1f7816ULL, 0x000fe4000000006fULL, 0x00000010ff1d7819ULL, 0x000fe40000011622ULL,
0x00000010ff1c7819ULL, 0x000fe40000011623ULL, 0x00000010ff227819ULL, 0x000fe20000011675ULL,
0x0000001e1430723cULL, 0x000fe20000041830ULL, 0x00000010ff237819ULL, 0x000fc40000011676ULL,
0x000000ff73737812ULL, 0x000fe400078ec0ffULL, 0x000010541d227816ULL, 0x000fe40000000022ULL,
0x000010541c237816ULL, 0x000fe40000000023ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x00a800000d1c783bULL, 0x000e620000000200ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x000000ff66667812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x000000ff456f7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff6e7819ULL, 0x000fe20000011644ULL, 0x000000221434723cULL, 0x000fe20000041834ULL,
0x00000010ff447819ULL, 0x000fc40000011662ULL, 0x00000010ff457819ULL, 0x000fe40000011661ULL,
0x00000010ff737819ULL, 0x000fe40000011673ULL, 0x00000010ff727819ULL, 0x000fe40000011672ULL,
0x00000010ff237819ULL, 0x000fe4000001165dULL, 0x00000010ff227819ULL, 0x000fe40000011670ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x0000105473447816ULL, 0x000fe40000000044ULL,
0x0000105472457816ULL, 0x000fe20000000045ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000105423227816ULL, 0x000fe40000000022ULL, 0x000010545e237816ULL, 0x000fc40000000071ULL,
0x00000010ff657819ULL, 0x000fe20000011665ULL, 0x000000441438723cULL, 0x040fe20000041838ULL,
0x00000010ff667819ULL, 0x000fe20000011666ULL, 0x000000551c1ca231ULL, 0x082fe200003400ffULL,
0x00000010ff5c7819ULL, 0x000fe2000001165cULL, 0x000000551e1ea231ULL, 0x000fe200003400ffULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x000000561d1da231ULL, 0x080fe200003400ffULL,
0x00000010ff447819ULL, 0x000fe2000001165aULL, 0x00000022143c723cULL, 0x000fe2000004183cULL,
0x00000010ff457819ULL, 0x000fe2000001165bULL, 0x000000561f1fa231ULL, 0x000fe200003400ffULL,
0x00000010ff5a7819ULL, 0x000fc40000011657ULL, 0x0000105465447816ULL, 0x000fe40000000044ULL,
0x00000010ff237819ULL, 0x000fe40000011664ULL, 0x0000105466457816ULL, 0x000fe40000000045ULL,
0x000010545c227816ULL, 0x000fe40000000067ULL, 0x000010545a237816ULL, 0x000fe40000000023ULL,
0x000000ff6d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000441440723cULL, 0x000fe20000041840ULL,
0x00000010ff0c7819ULL, 0x000fc4000001160cULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000008ff127819ULL, 0x000fe40000011612ULL, 0x00000010ff487819ULL, 0x000fe20000011648ULL,
0x000000221424723cULL, 0x000fe20000041824ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x2000006dff6d7230ULL, 0x000fe20000004100ULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fc400020006ffULL, 0x00000010ff157819ULL, 0x000fe2000001160eULL,
0x2000006eff0d7230ULL, 0x000fe20000004100ULL, 0x00000012ff12723eULL, 0x000fe200020006ffULL,
0x2000006fff5d7230ULL, 0x000fe20000004100ULL, 0x0000105415147816ULL, 0x000fe4000000000cULL,
0x0000105448157816ULL, 0x000fe2000000005fULL, 0x20000012ff127230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff0c7819ULL, 0x000fc4000001166dULL,
0x000000ff1b1b7812ULL, 0x000fe200078ec0ffULL, 0x000000141c2c723cULL, 0x000fe2000004182cULL,
0x000000ff46467812ULL, 0x000fe400078ec0ffULL, 0x00000008ff217819ULL, 0x000fe40000011621ULL,
0x00000008ff477819ULL, 0x000fe40000011647ULL, 0x000010540c147816ULL, 0x000fe4000000004dULL,
0x00000010ff0c7819ULL, 0x000fc4000001164fULL, 0x00000010ff0d7819ULL, 0x000fe4000001160dULL,
0x00000010ff157819ULL, 0x000fe4000001164eULL, 0x00000010ff0e7819ULL, 0x000fe4000001165dULL,
0x00000010ff177819ULL, 0x000fe40000011650ULL, 0x00000010ff127819ULL, 0x000fe40000011612ULL,
0x0000007fff58723eULL, 0x000fc400020006ffULL, 0x00000080ff59723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000001bff1b723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000074ff6c7230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x2000001bff1b7230ULL, 0x000fe20000004100ULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000010540c0c7816ULL, 0x000fe2000000000dULL, 0x20000021ff217230ULL, 0x000fe20000004100ULL,
0x000010540e157816ULL, 0x000fe20000000015ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00001054170d7816ULL, 0x000fc40000000012ULL, 0x00000010ff617819ULL, 0x000fe4000001166bULL,
0x00000010ff587819ULL, 0x000fe20000011658ULL, 0x000000141c38723cULL, 0x040fe20000041838ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff577819ULL, 0x000fe40000011668ULL,
0x00000010ff5c7819ULL, 0x000fe40000011669ULL, 0x00000010ff497819ULL, 0x000fe20000011649ULL,
0x0000000c1c3c723cULL, 0x000fe2000004183cULL, 0x00000010ff4a7819ULL, 0x000fc4000001164aULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff6a7819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166cULL, 0x00000010ff517819ULL, 0x000fc40000011651ULL,
0x00000010ff0e7819ULL, 0x000fe4000001161bULL, 0x00000010ff157819ULL, 0x000fe40000011652ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff0c7819ULL, 0x000fe40000011653ULL,
0x00000010ff217819ULL, 0x000fe40000011621ULL, 0x00000010ff547819ULL, 0x000fc40000011654ULL,
0x00000010ff0d7819ULL, 0x000fe40000011647ULL, 0x0000105457447816ULL, 0x000fe40000000058ULL,
0x000010545c457816ULL, 0x000fe40000000059ULL, 0x0000105460607816ULL, 0x000fe40000000049ULL,
0x0000105461617816ULL, 0x000fe4000000004aULL, 0x000010544b6a7816ULL, 0x000fe2000000006aULL,
0x000000441c28723cULL, 0x000fe20000041828ULL, 0x000010544c6b7816ULL, 0x000fc4000000006bULL,
0x000010540e147816ULL, 0x000fe40000000051ULL, 0x0000105446157816ULL, 0x000fe40000000015ULL,
0x000010540c0c7816ULL, 0x000fe20000000021ULL, 0x000000601c30723cULL, 0x000fe20000041830ULL,
0x00001054540d7816ULL, 0x000fce000000000dULL, 0x0000006a1c34723cULL, 0x040ff00000041834ULL,
0x000000141c40723cULL, 0x040ff00000041840ULL, 0x0000000c1c24723cULL, 0x000fe20000041824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x000020000fff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6400013ff7f8cULL, 0x0005e2000c80043fULL, 0x00009910630c7816ULL, 0x000fc400000000ffULL,
0x00000001ff4d7807ULL, 0x000fe40004000000ULL, 0x000000ff0c00720cULL, 0x000fe40003f45270ULL,
0x00000001114c7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff209807ULL, 0x000fc80001000000ULL,
0x00007610204e7816ULL, 0x000fe4000000004eULL, 0x0000030019197a10ULL, 0x00cfe40007ffe0ffULL,
0x000000ff10ff7812ULL, 0x000fe4000780c0ffULL, 0x000000021900720cULL, 0x000fe40003f26070ULL,
0x00000001ff107807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff6b7000007947ULL, 0x000fea000383ffffULL, 0x00000000000479c3ULL, 0x004ea40000002500ULL,
0x0000000402007c0cULL, 0x004fda000bf03070ULL, 0x0000039000000947ULL, 0x000fea0003800000ULL,
0x018000000b007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e000bULL,
0x0000a260000c7802ULL, 0x002fe40000000f00ULL, 0x0000916000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000b00007308ULL, 0x000ea40000001000ULL, 0xbf80000000027423ULL, 0x004fc8000000000bULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000047919ULL, 0x002e680000000000ULL, 0x00000000000c7919ULL, 0x000ee20000000000ULL,
0x00000002ff087819ULL, 0x002fe40000011604ULL, 0x000000080c047811ULL, 0x008fe200078ff0ffULL,
0x0000000003057220ULL, 0x004fca0000410000ULL, 0x00001f0805007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000002800287220ULL, 0x042fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003800387220ULL, 0x040fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000003c003c7220ULL, 0x040fe20000410000ULL,
0x0000003d003d7220ULL, 0x040fe20000410000ULL, 0x0000004000407220ULL, 0x040fe20000410000ULL,
0x0000004100417220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002500257220ULL, 0x000fe20000410000ULL, 0x0000002a042a7220ULL, 0x044fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003a043a7220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000003e043e7220ULL, 0x040fe20000410000ULL,
0x0000003f043f7220ULL, 0x040fe20000410000ULL, 0x0000004204427220ULL, 0x040fe20000410000ULL,
0x0000004304437220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x000fc80000410000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000262726723eULL, 0x000fc600000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000203007812ULL, 0x044fe400078ec0ffULL, 0x00000002ff137819ULL, 0x002fe40000011603ULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000400087811ULL, 0x040fe400078ff8ffULL,
0x00000008031b7811ULL, 0x000fe400078ff0ffULL, 0x0000000200047811ULL, 0x000fc400078ff8ffULL,
0x00000006000e7811ULL, 0x000fe400078ff8ffULL, 0x0000000702007812ULL, 0x100fe400078e7813ULL,
0x00000007080c7812ULL, 0x040fe400078e7813ULL, 0x0000000708087812ULL, 0x000fe200078e781bULL,
0x00000008130d7824ULL, 0x000fe200078e0200ULL, 0x0000000704057812ULL, 0x000fe200078e7813ULL,
0x0000100009007824ULL, 0x000fe200078e00ffULL, 0x0000000702027812ULL, 0x000fe200078e781bULL,
0x000000081b197824ULL, 0x000fe200078e0208ULL, 0x000000070e107812ULL, 0x000fe200078e7813ULL,
0x0000000803087824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x100fe200078e781bULL,
0x000000081b157824ULL, 0x000fe200078e0202ULL, 0x000000070e0e7812ULL, 0x000fe200078e781bULL,
0x00000008130f7824ULL, 0x040fe200078e0205ULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000000813117824ULL, 0x000fe200078e020cULL, 0x0000002c2d05723eULL, 0x000fe200000010ffULL,
0x000000081b177824ULL, 0x000fe200078e0204ULL, 0x000000282904723eULL, 0x000fe200000010ffULL,
0x0000080006027824ULL, 0x000fe200078e0200ULL, 0x00000034350c723eULL, 0x000fe200000010ffULL,
0x0000000813137824ULL, 0x000fe200078e0210ULL, 0x00005410041c7816ULL, 0x140fe20000000005ULL,
0x000000081b1b7824ULL, 0x000fe200078e020eULL, 0x00007632041d7816ULL, 0x000fe20000000005ULL,
0x000000100d0d7824ULL, 0x100fe200078e0202ULL, 0x000000383904723eULL, 0x000fe200000010ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0202ULL, 0x0000003c3d05723eULL, 0x000fe200000010ffULL,
0x0000001011117824ULL, 0x000fc400078e0202ULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x00005410040e7816ULL, 0x000fe20000000005ULL, 0x0000001017177824ULL, 0x100fe400078e0202ULL,
0x0000001013137824ULL, 0x100fe400078e0202ULL, 0x0000001019197824ULL, 0x100fe400078e0202ULL,
0x000000101b1b7824ULL, 0x000fe400078e0202ULL, 0x000000010d0d7824ULL, 0x000fc400078e0208ULL,
0x00000001080f7824ULL, 0x040fe400078e020fULL, 0x0000000108117824ULL, 0x040fe200078e0211ULL,
0x0000001c0d007388ULL, 0x0003e20000000a00ULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x0000000108177824ULL, 0x040fe400078e0217ULL, 0x0000000108137824ULL, 0x040fe400078e0213ULL,
0x0000000108197824ULL, 0x000fc400078e0219ULL, 0x00000001081b7824ULL, 0x000fe200078e021bULL,
0x000000303108723eULL, 0x000fe200000010ffULL, 0x00000020060d7824ULL, 0x002fc600078e0203ULL,
0x00005410081c7816ULL, 0x140fe4000000000cULL, 0x00007632081d7816ULL, 0x000fe2000000000cULL,
0x000000100d147824ULL, 0x000fe200078e0200ULL, 0x000000404108723eULL, 0x000fe400000010ffULL,
0x00000024250c723eULL, 0x000fe200000010ffULL, 0x0000001c0f007388ULL, 0x0003e40000000a00ULL,
0x00007632040f7816ULL, 0x002fe40000000005ULL, 0x0000002a2b04723eULL, 0x000fc400000010ffULL,
0x0000002e2f05723eULL, 0x000fe200000010ffULL, 0x0000000e11007388ULL, 0x0003e40000000a00ULL,
0x00005410080e7816ULL, 0x142fe4000000000cULL, 0x00007632080f7816ULL, 0x000fe4000000000cULL,
0x000000323308723eULL, 0x000fe400000010ffULL, 0x00000036370c723eULL, 0x000fe200000010ffULL,
0x0000000e13007388ULL, 0x0003e40000000a00ULL, 0x00005410040e7816ULL, 0x002fc40000000005ULL,
0x00007632040f7816ULL, 0x000fe40000000005ULL, 0x0000003a3b04723eULL, 0x000fe400000010ffULL,
0x0000003e3f05723eULL, 0x000fe200000010ffULL, 0x0000000e15007388ULL, 0x0003e40000000a00ULL,
0x00005410080e7816ULL, 0x142fe4000000000cULL, 0x00007632080f7816ULL, 0x000fe4000000000cULL,
0x000000424308723eULL, 0x000fc600000010ffULL, 0x0000000e17007388ULL, 0x0003e40000000a00ULL,
0x00005410040e7816ULL, 0x142fe40000000005ULL, 0x00007632040f7816ULL, 0x000fe40000000005ULL,
0x000000ff00047306ULL, 0x000fe60000205400ULL, 0x0000000e19007388ULL, 0x0003ea0000000a00ULL,
0x000000ff00057306ULL, 0x000ea20000209400ULL, 0x00005410080e7816ULL, 0x002fc40000000026ULL,
0x00007632080f7816ULL, 0x000fca0000000026ULL, 0x0000000e1b007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000040500720bULL, 0x004fe40003f1d000ULL,
0x000000ff00047245ULL, 0x000fd6000020d400ULL, 0x0000000104040812ULL, 0x000fc800078efcffULL,
0x000000040408723eULL, 0x000fe200000010ffULL, 0x0000000014107984ULL, 0x000e680000000c00ULL,
0x00080000141c7984ULL, 0x000ea80000000c00ULL, 0x0004000014207984ULL, 0x000ee80000000c00ULL,
0x000c000014247984ULL, 0x000f220000000c00ULL, 0x3f803f8008117831ULL, 0x002fc40000200011ULL,
0x3f803f8008137831ULL, 0x040fe40000200013ULL, 0x3f803f8011117831ULL, 0x004fe2000020001dULL,
0x00000300ff1d7624ULL, 0x000fe200078e00ffULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008107831ULL, 0x040fe40000200010ULL, 0x000000011d00780cULL, 0x000fe20003f05270ULL,
0x3f803f8008237831ULL, 0x048fe40000200023ULL, 0x3f803f8008227831ULL, 0x000fc40000200022ULL,
0x3f803f8008217831ULL, 0x040fe40000200021ULL, 0x3f803f8008207831ULL, 0x000fe40000200020ULL,
0x3f803f8013137831ULL, 0x000fe4000020001fULL, 0x3f803f8012127831ULL, 0x000fe4000020001eULL,
0x3f803f8010107831ULL, 0x000fe4000020001cULL, 0x3f803f8023237831ULL, 0x010fc40000200027ULL,
0x3f803f8022227831ULL, 0x000fe20000200026ULL, 0x0000001014007388ULL, 0x0003e20000000c00ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fca0000200024ULL,
0x0004002014007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000305000008947ULL, 0x000fea0003800000ULL, 0x00000000001b7919ULL, 0x000ea20000002700ULL,
0x000058001d057a24ULL, 0x000fe200078e02ffULL, 0x0000000106ff7812ULL, 0x000fe2000780f81aULL,
0x00001000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000087919ULL, 0x000ea20000002600ULL,
0x0000640005157a24ULL, 0x000fe200078e02ffULL, 0x000000400d197810ULL, 0x000fe20007ffe0ffULL,
0x00000800090c7824ULL, 0x000fe200078e00ffULL, 0x0000000014107984ULL, 0x0022e80000000c00ULL,
0x0004000014207984ULL, 0x0003220000000c00ULL, 0x000058001b1b7a24ULL, 0x004fe200078e0208ULL,
0x00000fff15087811ULL, 0x000fc600078e40ffULL, 0x000003001b057a24ULL, 0x000fca00078e02ffULL,
0x00000004051c7c10ULL, 0x000fc8000fffe0ffULL, 0x0000001c080e7211ULL, 0x000fca00078fa0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e000fULL, 0x0000000c0e0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x000000100d167825ULL, 0x000fe200078e000eULL, 0x01ffffff150d7812ULL, 0x000fc600078ec0ffULL,
0x0000001019187825ULL, 0x000fe200078e000eULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030e7824ULL, 0x01afe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011603ULL,
0x00000080ff157424ULL, 0x000fe400078e00ffULL, 0x000000011c147824ULL, 0x000fe200078e020dULL,
0x000000700e1f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0f1e7812ULL, 0x000fe200078ec0ffULL,
0x00006a001c0e7625ULL, 0x000fc800078e0015ULL, 0x00006a0014147625ULL, 0x000fe200078e0015ULL,
0x0000000e1e0e7210ULL, 0x000fc80007a1e01fULL, 0x000000141e147210ULL, 0x000fe40007c7e01fULL,
0x0000000fff0f7210ULL, 0x000fe400007e44ffULL, 0x00000015ff157210ULL, 0x000fc60001fe84ffULL,
0x0000000a0e007986ULL, 0x0003e8000c101908ULL, 0x0000000b14007986ULL, 0x0003e4000c101908ULL,
0x0000001016007986ULL, 0x01a3e2000c101d08ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000002018007986ULL, 0x0003e8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0a7424ULL, 0x000fe200078e00ffULL,
0xffffffff1d0f7810ULL, 0x000fc60007ffe0ffULL, 0x000068001b0a7625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000f0a0a79a8ULL, 0x000ea400099ee1c8ULL, 0x0000000f0a00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0e7807ULL, 0x000fca0000000000ULL,
0x0000000eff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0a7984ULL, 0x000ee40000000000ULL,
0x000000ff0a00720cULL, 0x008fda0003f05270ULL, 0x00002c8000008947ULL, 0x000fea0003800000ULL,
0x000000ff1a00720cULL, 0x000fda0003f05270ULL, 0x00000d1000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000010030a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x002fe200078e00ffULL, 0x00000001050e7810ULL, 0x004fe40007ffe0ffULL,
0x000000700a1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b127812ULL, 0x000fe200078ec0ffULL,
0x00006a00050a7625ULL, 0x000fc800078e0011ULL, 0x00006a000e0e7625ULL, 0x000fe200078e0011ULL,
0x0000000a120a7210ULL, 0x000fc8000791e01bULL, 0x0000000e120e7210ULL, 0x000fe40007b5e01bULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000fff0f7210ULL, 0x000fc600017e64ffULL,
0x000000080a0a7981ULL, 0x000368000c1e1900ULL, 0x000000080e137981ULL, 0x000362000c1e1900ULL,
0x000000021d00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002050e7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0011ULL,
0x0000000e120e7210ULL, 0x000fc8000791e01bULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e0b7981ULL, 0x000362000c1e1900ULL, 0x000000041d00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003050e7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0011ULL, 0x0000000e120e7210ULL, 0x000fc8000791e01bULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000080e157981ULL, 0x000362000c1e1900ULL,
0x000000041d00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004050e7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0011ULL,
0x0000000e120e7210ULL, 0x000fc8000791e01bULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e177981ULL, 0x000362000c1e1900ULL, 0x000000061d00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005050e7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0011ULL, 0x0000000e120e7210ULL, 0x000fc8000791e01bULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000080e197981ULL, 0x000362000c1e1900ULL,
0x000000061d00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081d00780cULL, 0x002fe40003f06070ULL, 0x00000006050e7810ULL, 0x000fca0007ffe0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e0011ULL, 0x0000000e120e7210ULL, 0x000fe40007a3e01bULL,
0x0000000705100810ULL, 0x000fe40007ffe0ffULL, 0x0000000fff0f7210ULL, 0x000fc60000fe44ffULL,
0x00006a0010100625ULL, 0x000fca00078e0011ULL, 0x0000001012100210ULL, 0x000fe40007c7e01bULL,
0x000000080e1b7981ULL, 0x000364000c1e1900ULL, 0x00000011ff110210ULL, 0x000fcc0001fe84ffULL,
0x0000000810110981ULL, 0x000366000c1e1900ULL, 0x000000071d0e7810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff107819ULL, 0x000fc8000001160eULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x020fe400078e000aULL, 0x000000081d127824ULL, 0x040fe200078e00ffULL,
0x000000011d1d7810ULL, 0x000fc80007ffe0ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x000000101d00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008120e7810ULL, 0x040fe40007ffe0ffULL, 0x00000001120f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000001f0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050e7824ULL, 0x000fe200078e020eULL, 0x00000001ff167819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x00000070141f7812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e01fULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e1f7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000002120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000130a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050e7824ULL, 0x000fe200078e020eULL,
0x00000001ff147819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000e140e7210ULL, 0x000fc80007b3e013ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e137981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a120e7810ULL, 0x042fe40007ffe0ffULL, 0x00000003120f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000000b0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050e7824ULL, 0x000fe200078e020eULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007b3e00bULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e0b7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000004120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000150a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050e7824ULL, 0x000fe200078e020eULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007014157812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e157981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c120e7810ULL, 0x042fe40007ffe0ffULL, 0x00000005120f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x000000170a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050e7824ULL, 0x000fe200078e020eULL, 0x00000001ff167819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007014177812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e017ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e177981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d120e7810ULL, 0x042fe40007ffe0ffULL,
0x00000006120f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050e7824ULL, 0x000fe200078e020eULL,
0x00000001ff167819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007014197812ULL, 0x000fc800078ec0ffULL,
0x0000000e160e7210ULL, 0x000fc80007b3e019ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000080e197981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e120e7810ULL, 0x042fe40007ffe0ffULL, 0x00000007120f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000001b0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050e7824ULL, 0x000fe200078e020eULL, 0x00000001ff167819ULL, 0x000fe20000011603ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001003147824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x00000070141b7812ULL, 0x000fc800078ec0ffULL, 0x0000000e160e7210ULL, 0x000fc80007b3e01bULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000080e1b7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f120e7810ULL, 0x002fe40007ffe0ffULL,
0x000000110a0a7209ULL, 0x000fe40007810000ULL, 0x000003000e007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050e7824ULL, 0x000fe200078e020eULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x00000080ff0f7424ULL, 0x000fe400078e00ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x00006a000e0e7625ULL, 0x000fc600078e000fULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000e120e7210ULL, 0x000fc80007a3e011ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL,
0x000000080e117981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x00000010030b7824ULL, 0x024fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x002fc80000011603ULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010e0b7824ULL, 0x000fca00078e020bULL,
0x0000000a0b007388ULL, 0x0003e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x00000010030b7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x004fe20000011603ULL,
0x00000001061b7824ULL, 0x000fe200078e0205ULL, 0x00000002ff0f7819ULL, 0x000fe2000001161aULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000700b107812ULL, 0x000fe200078ec0ffULL,
0x00001000ff137424ULL, 0x000fe200078e00ffULL, 0x0000000c0e117812ULL, 0x000fe200078ec0ffULL,
0x000002001a1a7824ULL, 0x000fe200078e00ffULL, 0x0000001b080a7211ULL, 0x000fe200078fa0ffULL,
0x0000000107077824ULL, 0x000fe200078e0200ULL, 0x000000010f0e7812ULL, 0x000fe200078ec0ffULL,
0x00000001111c7824ULL, 0x000fe200078e0210ULL, 0x0000004003157810ULL, 0x040fe20007ffe0ffULL,
0x00000002060f8824ULL, 0x140fe200078e0209ULL, 0x0000006003177810ULL, 0x000fe20007ffe0ffULL,
0x0000000206118824ULL, 0x000fe200078e0209ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00006a000a0a7625ULL, 0x000fe200078e0013ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000020f188824ULL, 0x100fe200078e020eULL, 0x0000000c0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000002111e8824ULL, 0x000fe200078e020eULL, 0x000008001a0e7812ULL, 0x000fe200078ec0ffULL,
0x000000010d128824ULL, 0x000fe200078e021bULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000001070e7824ULL, 0x000fc400078e020eULL, 0x00000080ff1a8424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000030006007a0cULL, 0x000fe20003f26070ULL,
0x00006a0012128625ULL, 0x000fc800078e0013ULL, 0x00000010031d7824ULL, 0x000fe400078e020eULL,
0x00006a001b1a8625ULL, 0x000fc800078e001aULL, 0x0000000818218824ULL, 0x000fe400078e0203ULL,
0x00000010030e7825ULL, 0x000fc600078e000aULL, 0x0000458021218811ULL, 0x000fe200078e20ffULL,
0x000000081e258824ULL, 0x000fe400078e0203ULL, 0x0000001011107825ULL, 0x000fc600078e000aULL,
0x0000418025258811ULL, 0x000fe200078e20ffULL, 0x0000001015147825ULL, 0x000fc800078e000aULL,
0x0000001017167825ULL, 0x000fe400078e000aULL, 0x000000001c0a7984ULL, 0x0002a40000000800ULL,
0x0000001003188825ULL, 0x040fe400078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e1d7faeULL, 0x0007e2000b901c48ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000010031e8825ULL, 0x000fe400078e001aULL, 0x00380000101d7faeULL, 0x0009e2000b901c48ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0b7224ULL, 0x000fc400078e00ffULL,
0x00580000141d7faeULL, 0x000be8000b901c48ULL, 0x00780000161d7faeULL, 0x0003e2000b901c48ULL,
0x00000000000e7805ULL, 0x008fc6000001ff00ULL, 0x0000000018218faeULL, 0x0007e2000b901c48ULL,
0x0000000000107805ULL, 0x010fc6000001ff00ULL, 0x000000001e258faeULL, 0x0009e2000b901c48ULL,
0x0000000000147805ULL, 0x020fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001c7805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x008fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x010fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000e0000001947ULL, 0x000fea0003800000ULL, 0x00000df000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff317224ULL, 0x000fca00078e0006ULL,
0x0000000231307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff457224ULL, 0x000fe200078e0031ULL,
0x00000002ff2f7819ULL, 0x000fe20000011603ULL, 0x0000000206327824ULL, 0x000fe200078e0209ULL,
0x0000030030007a0cULL, 0x000fe20003f06070ULL, 0x0000004045317824ULL, 0x000fe200078e00ffULL,
0x000000072f337812ULL, 0x040fe200078ec0ffULL, 0x000000082f2e7824ULL, 0x040fe200078e00ffULL,
0x0000002fff4c7212ULL, 0x000fe200078e33ffULL, 0x000000082f3e7824ULL, 0x000fe200078e00ffULL,
0x0000008031317812ULL, 0x000fe200078ec0ffULL, 0x000000082f357824ULL, 0x000fe200078e00ffULL,
0x0000039000017945ULL, 0x000fe20003800000ULL, 0x000000012e407812ULL, 0x140fe200078ef633ULL,
0x0000001003477824ULL, 0x000fe200078e00ffULL, 0x000000022e427812ULL, 0x000fe200078ef633ULL,
0x0000010032437824ULL, 0x000fe200078e0031ULL, 0x000000032e447812ULL, 0x000fc400078ef633ULL,
0x000000042e467812ULL, 0x140fe400078ef633ULL, 0x000000052e487812ULL, 0x140fe400078ef633ULL,
0x000000062e4a7812ULL, 0x100fe400078ef633ULL, 0xfffffff83e3e7812ULL, 0x000fe400078ee233ULL,
0xfffffff8354c7812ULL, 0x000fe400078ee24cULL, 0x000000082f2e7810ULL, 0x000fe20007ffe0ffULL,
0x000002c000000947ULL, 0x00afea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x00000001053c7824ULL, 0x100fe200078e0230ULL, 0x00000001ff317819ULL, 0x000fe20000011630ULL,
0x00001000ff337424ULL, 0x000fe200078e00ffULL, 0x0000004003397810ULL, 0x000fc40007ffe0ffULL,
0x0000003c08327211ULL, 0x000fe400078fa0ffULL, 0x0000000131347812ULL, 0x000fe200078ec0ffULL,
0x0000040030317824ULL, 0x000fe200078e00ffULL, 0x00000060033f7810ULL, 0x000fe20007ffe0ffULL,
0x00006a0032327625ULL, 0x000fc800078e0033ULL, 0x0000000206359824ULL, 0x100fe200078e0209ULL,
0x0000000c32327210ULL, 0x000fe20007f1e0ffULL, 0x0000000206379824ULL, 0x000fe400078e0209ULL,
0x00000002354e9824ULL, 0x100fe400078e0234ULL, 0x0000000237509824ULL, 0x000fe200078e0234ULL,
0x0000080031347812ULL, 0x000fe200078ec0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000002003377810ULL, 0x000fe20007ffe0ffULL, 0x000000010d3a9824ULL, 0x000fc400078e023cULL,
0x0000000107347824ULL, 0x000fe400078e0234ULL, 0x00000080ff3b9424ULL, 0x000fe400078e00ffULL,
0x00000080ff3d9424ULL, 0x000fe400078e00ffULL, 0x0000001003317824ULL, 0x040fe400078e0234ULL,
0x0000001003347825ULL, 0x000fc800078e0032ULL, 0x0000001037367825ULL, 0x100fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000034317faeULL, 0x0003e6000b901c48ULL,
0x0000001039387825ULL, 0x100fe200078e0032ULL, 0x0038000036317faeULL, 0x0003e6000b901c48ULL,
0x00006a003a3a9625ULL, 0x000fe200078e003bULL, 0x0058000038317faeULL, 0x0003e6000b901c48ULL,
0x000000103f327825ULL, 0x000fc800078e0032ULL, 0x00006a003c3c9625ULL, 0x000fe200078e003dULL,
0x0078000032317faeULL, 0x0003e6000b901c48ULL, 0x000000084e3f9824ULL, 0x100fe400078e0203ULL,
0x0000000850419824ULL, 0x000fe400078e0203ULL, 0x00000010033a9825ULL, 0x000fe200078e003aULL,
0x000045803f3f9811ULL, 0x000fe400078e20ffULL, 0x0000418041419811ULL, 0x000fe200078e20ffULL,
0x00000010033c9825ULL, 0x000fc400078e003cULL, 0x000000003a3f9faeULL, 0x0003e8000b901c48ULL,
0x000000003c419faeULL, 0x0003e4000b901c48ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff347819ULL, 0x002fe20000011603ULL,
0x000000082e377824ULL, 0x040fe200078e00ffULL, 0x0000007047527812ULL, 0x000fe200078ec0ffULL,
0x000000082e337824ULL, 0x000fe200078e00ffULL, 0x0000000c34357812ULL, 0x000fe200078ec0ffULL,
0x0000040045317824ULL, 0x000fe200078e00ffULL, 0x000000072e327812ULL, 0x000fc400078ec0ffULL,
0x0000004335437210ULL, 0x000fe20007ffe052ULL, 0x000000082e527824ULL, 0x000fe200078e00ffULL,
0xfffffff837347812ULL, 0x100fe400078ee232ULL, 0x0000000133367812ULL, 0x140fe400078ef632ULL,
0x0000000233387812ULL, 0x140fe400078ef632ULL, 0x00000003333a7812ULL, 0x140fe400078ef632ULL,
0x00000004333c7812ULL, 0x000fc400078ef632ULL, 0x00000005334e7812ULL, 0x140fe400078ef632ULL,
0x0000000633507812ULL, 0x000fe200078ef632ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800043357984ULL, 0x000e620000000800ULL, 0x0000080031327812ULL, 0x000fe200078ec0ffULL,
0x0000000403337824ULL, 0x000fe200078e00ffULL, 0x0000002eff377212ULL, 0x000fe400078e33ffULL,
0x0000018007317810ULL, 0x000fe40007ffe032ULL, 0xfffffff852327812ULL, 0x000fe400078ee237ULL,
0x0000000c33337812ULL, 0x000fe200078ec0ffULL, 0x0000001044447824ULL, 0x100fe200078e0231ULL,
0x0045800043527984ULL, 0x000ee20000000800ULL, 0x0000001048487824ULL, 0x000fc400078e0231ULL,
0x000000104e4e7824ULL, 0x100fe400078e0231ULL, 0x000000103e3e7824ULL, 0x100fe400078e0231ULL,
0x0000001040407824ULL, 0x100fe400078e0231ULL, 0x0000001042427824ULL, 0x100fe400078e0231ULL,
0x0000001046467824ULL, 0x100fe400078e0231ULL, 0x000000104a4a7824ULL, 0x000fc400078e0231ULL,
0x0000001034347824ULL, 0x100fe400078e0231ULL, 0x0000001050507824ULL, 0x100fe400078e0231ULL,
0x000000104c4c7824ULL, 0x100fe400078e0231ULL, 0x0000001032327824ULL, 0x100fe400078e0231ULL,
0x0000001036367824ULL, 0x100fe400078e0231ULL, 0x0000001038387824ULL, 0x000fc400078e0231ULL,
0x000000103a3a7824ULL, 0x100fe400078e0231ULL, 0x000000103c3c7824ULL, 0x000fe200078e0231ULL,
0x000000350a357221ULL, 0x006fe20000010100ULL, 0x0000000133447824ULL, 0x040fe400078e0244ULL,
0x0000000133487824ULL, 0x000fe200078e0248ULL, 0x3fb8aa3b35357820ULL, 0x000fe20000410000ULL,
0x00000001334e7824ULL, 0x040fe400078e024eULL, 0x000000013e3e7824ULL, 0x000fe200078e0233ULL,
0x0000000044447984ULL, 0x000e620000000800ULL, 0x0000000133407824ULL, 0x040fe200078e0240ULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0x0000000133427824ULL, 0x040fe200078e0242ULL,
0x0000000048487984ULL, 0x000ea20000000800ULL, 0x0000000133467824ULL, 0x000fc400078e0246ULL,
0x00000001334a7824ULL, 0x040fe200078e024aULL, 0x000000004e4e7984ULL, 0x000f220000000800ULL,
0x00000001334c7824ULL, 0x040fe400078e024cULL, 0x0000000133347824ULL, 0x040fe200078e0234ULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x0000000133507824ULL, 0x040fe400078e0250ULL,
0x0000000133327824ULL, 0x040fe200078e0232ULL, 0x0000000040407984ULL, 0x000f620000000800ULL,
0x0000000133367824ULL, 0x000fe200078e0236ULL, 0x0000005235397220ULL, 0x008fe20000410000ULL,
0x0000000133387824ULL, 0x040fe200078e0238ULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x00000001333a7824ULL, 0x000fe200078e023aULL, 0x0000002d392d7221ULL, 0x000fe20000010000ULL,
0x00000001333c7824ULL, 0x000fe200078e023cULL, 0x0000000046467984ULL, 0x000ee20000000800ULL,
0x000000ffff317224ULL, 0x000fc600078e0030ULL, 0x000000004a4a7984ULL, 0x000ee40000000800ULL,
0x0000030031007a0cULL, 0x000fe40003f06070ULL, 0x000000004c4c7984ULL, 0x000ee80000000800ULL,
0x0000000034347984ULL, 0x000ee80000000800ULL, 0x0000000050507984ULL, 0x000ee20000000800ULL,
0x00005410ff3f7816ULL, 0x002fc40000000044ULL, 0x00007610ff417816ULL, 0x000fe20000000044ULL,
0x0000000032327984ULL, 0x000e620000000800ULL, 0x00005410ff307816ULL, 0x104fe40000000048ULL,
0x00007610ff457816ULL, 0x000fe20000000048ULL, 0x0000000036367984ULL, 0x000ea20000000800ULL,
0x00005410ff537816ULL, 0x110fe4000000004eULL, 0x00007610ff557816ULL, 0x000fe2000000004eULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x00005410ff337816ULL, 0x020fc4000000003eULL,
0x00007610ff3e7816ULL, 0x000fe2000000003eULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x00005410ff357816ULL, 0x100fe40000000040ULL, 0x00007610ff407816ULL, 0x000fe20000000040ULL,
0x000000003c3c7984ULL, 0x000f620000000800ULL, 0x00005410ff3d7816ULL, 0x108fe40000000042ULL,
0x00007610ff427816ULL, 0x000fe40000000042ULL, 0x00005410ff437816ULL, 0x000fc40000000046ULL,
0x00007610ff467816ULL, 0x000fe40000000046ULL, 0x00005410ff477816ULL, 0x100fe4000000004aULL,
0x00007610ff4a7816ULL, 0x000fe4000000004aULL, 0x00005410ff447816ULL, 0x100fe4000000004cULL,
0x00007610ff497816ULL, 0x000fe4000000004cULL, 0x00005410ff487816ULL, 0x000fc40000000034ULL,
0x00007610ff347816ULL, 0x000fe40000000034ULL, 0x00005410ff4e7816ULL, 0x100fe40000000050ULL,
0x00007610ff507816ULL, 0x000fe40000000050ULL, 0x00005410ff577816ULL, 0x102fe40000000032ULL,
0x00007610ff327816ULL, 0x000fe40000000032ULL, 0x00005410ff4c7816ULL, 0x004fc40000000036ULL,
0x00007610ff4b7816ULL, 0x000fe40000000036ULL, 0x00005410ff4d7816ULL, 0x110fe40000000038ULL,
0x00007610ff527816ULL, 0x000fe40000000038ULL, 0x00005410ff547816ULL, 0x120fe4000000003aULL,
0x00007610ff4f7816ULL, 0x000fe4000000003aULL, 0x00005410ff517816ULL, 0x000fc4000000003cULL,
0x00007610ff567816ULL, 0x000fe2000000003cULL, 0x000060727f007947ULL, 0x000fea000b800000ULL,
0x00001f2f392f7589ULL, 0x0002a400000e0000ULL, 0x000060c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2e392e7589ULL, 0x00072400000e0000ULL, 0x0000002f332c7223ULL, 0x084fe2000001002cULL,
0x0000002f3e2b7223ULL, 0x080fe2000001002bULL, 0x0000002f352a7223ULL, 0x080fe2000001002aULL,
0x0000002f40297223ULL, 0x080fe20000010029ULL, 0x0000002f3d287223ULL, 0x080fe20000010028ULL,
0x0000002f42277223ULL, 0x080fe20000010027ULL, 0x0000002f3f1a7223ULL, 0x080fe2000001001aULL,
0x0000002f41267223ULL, 0x080fe20000010026ULL, 0x0000002f430e7223ULL, 0x080fe2000001000eULL,
0x0000002f46257223ULL, 0x080fe20000010025ULL, 0x0000002f30157223ULL, 0x080fe20000010015ULL,
0x0000002f45247223ULL, 0x080fe20000010024ULL, 0x0000002f47107223ULL, 0x080fe20000010010ULL,
0x0000002f4a237223ULL, 0x080fe20000010023ULL, 0x0000002f440f7223ULL, 0x080fe2000001000fULL,
0x0000002f49227223ULL, 0x000fe20000010022ULL, 0x0000002e48117223ULL, 0x090fe20000010011ULL,
0x0000002e34217223ULL, 0x080fe20000010021ULL, 0x0000002e4c197223ULL, 0x080fe20000010019ULL,
0x0000002e4b207223ULL, 0x080fe20000010020ULL, 0x0000002e4d187223ULL, 0x080fe20000010018ULL,
0x0000002e521f7223ULL, 0x080fe2000001001fULL, 0x0000002e54177223ULL, 0x080fe20000010017ULL,
0x0000002e4f1e7223ULL, 0x080fe2000001001eULL, 0x0000002e51167223ULL, 0x080fe20000010016ULL,
0x0000002e561d7223ULL, 0x080fe2000001001dULL, 0x0000002e53147223ULL, 0x080fe20000010014ULL,
0x0000002e551c7223ULL, 0x080fe2000001001cULL, 0x0000002e4e137223ULL, 0x080fe20000010013ULL,
0x0000002e501b7223ULL, 0x080fe2000001001bULL, 0x0000002e57127223ULL, 0x080fe20000010012ULL,
0x0000002e320b7223ULL, 0x000fe2000001000bULL, 0xfffff24000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000f220000000000ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x0000001003057824ULL, 0x010fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c03087812ULL, 0x000fca00078ec0ffULL, 0x00000001080a7824ULL, 0x004fe200078e0205ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003057824ULL, 0x004fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007005037812ULL, 0x000fe400078ec0ffULL, 0x0000000c07087812ULL, 0x000fc600078ec0ffULL,
0x0000008006037824ULL, 0x000fc800078e0203ULL, 0x0000000108087824ULL, 0x000fca00078e0203ULL,
0x0049802d08007388ULL, 0x0005e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x004980000a037984ULL, 0x000f280000000800ULL, 0x004a00000a087984ULL, 0x004ea20000000800ULL,
0x00000003ff037221ULL, 0x010fc80000010000ULL, 0x0000000803037221ULL, 0x004fca0000010000ULL,
0x0180000003057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e0003ULL,
0x0000d260000c7802ULL, 0x000fe40000000f00ULL, 0x0000616000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff057224ULL, 0x00efe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300087308ULL, 0x000ea40000001000ULL, 0xbf80000003057423ULL, 0x004fc80000000008ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000508057223ULL, 0x000fe40000000008ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000803357811ULL, 0x004fe400078ff0ffULL,
0x00000002ff2e7819ULL, 0x000fe40000011603ULL, 0x00000035ff377212ULL, 0x000fe200078e33ffULL,
0x00001f3505087589ULL, 0x000ea200000e0000ULL, 0x0000000835307824ULL, 0x000fc600078e00ffULL,
0x00001f2e05077589ULL, 0x000f2400000e0000ULL, 0xfffffff830377812ULL, 0x000fca00078ee237ULL,
0x0000001037377824ULL, 0x000fe200078e0202ULL, 0x0000001208127220ULL, 0x044fe20000410000ULL,
0x0000000b080b7220ULL, 0x040fe20000410000ULL, 0x0000001708177220ULL, 0x040fe20000410000ULL,
0x0000001e081e7220ULL, 0x000fe20000410000ULL, 0x00000026070d7220ULL, 0x050fe20000410000ULL,
0x0000002c072c7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002907297220ULL, 0x040fe20000410000ULL,
0x0000002807287220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000002507257220ULL, 0x040fe20000410000ULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x000fe20000410000ULL, 0x000000082e267824ULL, 0x000fe200078e00ffULL,
0x0000002eff077212ULL, 0x000fe200078e33ffULL, 0x0000001108117220ULL, 0x040fe20000410000ULL,
0x00000021080a7220ULL, 0x040fe20000410000ULL, 0x0000001908197220ULL, 0x040fe20000410000ULL,
0x0000002008207220ULL, 0x040fe20000410000ULL, 0x0000001808187220ULL, 0x040fe20000410000ULL,
0x0000001f081f7220ULL, 0x040fe20000410000ULL, 0x0000001608167220ULL, 0x040fe20000410000ULL,
0x0000001d081d7220ULL, 0x040fe20000410000ULL, 0x0000001408147220ULL, 0x040fe20000410000ULL,
0x0000001c08057220ULL, 0x040fe20000410000ULL, 0x0000001308137220ULL, 0x040fe20000410000ULL,
0x0000001b080c7220ULL, 0x000fe20000410000ULL, 0x000000120b0b723eULL, 0x000fe200000010ffULL,
0x0000000835127824ULL, 0x000fe200078e00ffULL, 0x000000072e087812ULL, 0x000fc400078ec0ffULL,
0xfffffff826397812ULL, 0x00afe200078ee207ULL, 0x000000082e077824ULL, 0x000fe200078e00ffULL,
0x000000171e17723eULL, 0x000fe400000010ffULL, 0x00000007351e7812ULL, 0x000fe400078ec0ffULL,
0x000000110a0a723eULL, 0x000fe400000010ffULL, 0x000000102310723eULL, 0x000fe400000010ffULL,
0x000000181f18723eULL, 0x000fc400000010ffULL, 0x000000161d16723eULL, 0x000fe400000010ffULL,
0x000000130c0c723eULL, 0x000fe400000010ffULL, 0x0000000108117812ULL, 0x000fe400078e3cffULL,
0x0000001a0d0d723eULL, 0x000fe400000010ffULL, 0x000000192019723eULL, 0x000fe200000010ffULL,
0x0000000403207824ULL, 0x000fe200078e00ffULL, 0x000000140505723eULL, 0x000fe200000010ffULL,
0x000000082e117824ULL, 0x000fe200078e0211ULL, 0x0000000208137812ULL, 0x000fc400078e3cffULL,
0x00000003081b7812ULL, 0x040fe200078e3cffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x00000004081d7812ULL, 0x000fe200078e3cffULL, 0x000000082e137824ULL, 0x000fe200078e0213ULL,
0x00000005081f7812ULL, 0x000fe200078e3cffULL, 0x000000082e1b7824ULL, 0x000fe200078e021bULL,
0x0000000608217812ULL, 0x000fe200078e3cffULL, 0x000000082e1d7824ULL, 0x000fe200078e021dULL,
0xfffffff812237812ULL, 0x000fe200078ee235ULL, 0x000000082e1f7824ULL, 0x000fe200078e021fULL,
0x000000011e087812ULL, 0x000fe200078e3cffULL, 0x000000082e217824ULL, 0x000fe200078e0221ULL,
0x000000021e127812ULL, 0x040fe200078e3cffULL, 0x0000001013137824ULL, 0x100fe200078e0202ULL,
0x000000031e147812ULL, 0x040fe200078e3cffULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0x000000041e1a7812ULL, 0x040fe200078e3cffULL, 0x00000008352d7824ULL, 0x040fe200078e0212ULL,
0x000000051e1c7812ULL, 0x040fe200078e3cffULL, 0x00000008352f7824ULL, 0x000fe200078e0214ULL,
0xfffffff807077812ULL, 0x000fe200078ee22eULL, 0x0000000835317824ULL, 0x040fe200078e021aULL,
0x000000061e1e7812ULL, 0x000fe200078e3cffULL, 0x0000000835337824ULL, 0x000fe200078e021cULL,
0x0000000e250e723eULL, 0x000fe200000010ffULL, 0x0000000835257824ULL, 0x040fe200078e0208ULL,
0x000000152415723eULL, 0x000fe200000010ffULL, 0x0000000835357824ULL, 0x000fe200078e021eULL,
0x0000000c20247812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x0000002c2b2b723eULL, 0x000fe200000010ffULL, 0x0000001039127824ULL, 0x100fe200078e0202ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x0000000124087824ULL, 0x000fe200078e0207ULL,
0x0000000f220f723eULL, 0x000fe200000010ffULL, 0x000000101d1d7824ULL, 0x000fc400078e0202ULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x0000002b08007388ULL, 0x0003e20000000800ULL,
0x0000001021217824ULL, 0x100fe400078e0202ULL, 0x0000001025257824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe400078e0202ULL, 0x000000102f2f7824ULL, 0x100fe400078e0202ULL,
0x0000001031317824ULL, 0x000fc400078e0202ULL, 0x0000001033337824ULL, 0x100fe400078e0202ULL,
0x0000001035357824ULL, 0x000fe400078e0202ULL, 0x00000001241c7824ULL, 0x040fe400078e0212ULL,
0x0000000124027824ULL, 0x040fe400078e0211ULL, 0x0000000124127824ULL, 0x040fe400078e0213ULL,
0x0000000124147824ULL, 0x040fe200078e021bULL, 0x0000002902007388ULL, 0x000fe20000000800ULL,
0x00000001241d7824ULL, 0x000fc400078e021dULL, 0x00000001241a7824ULL, 0x040fe200078e021fULL,
0x0000002712007388ULL, 0x000fe20000000800ULL, 0x0000000124217824ULL, 0x040fe400078e0221ULL,
0x0000000124237824ULL, 0x040fe200078e0223ULL, 0x0000000d14007388ULL, 0x000fe20000000800ULL,
0x00000001241e7824ULL, 0x040fe400078e0225ULL, 0x00000001242d7824ULL, 0x040fe200078e022dULL,
0x0000000e1d007388ULL, 0x000fe20000000800ULL, 0x0000000124087824ULL, 0x002fc400078e022fULL,
0x0000000124317824ULL, 0x040fe200078e0231ULL, 0x000000151a007388ULL, 0x000fe20000000800ULL,
0x0000000124207824ULL, 0x040fe400078e0233ULL, 0x0000000124357824ULL, 0x040fe200078e0235ULL,
0x0000001021007388ULL, 0x000fe20000000800ULL, 0x0000000124227824ULL, 0x000fe400078e0237ULL,
0x0000002006077824ULL, 0x000fe200078e0203ULL, 0x0000000f1c007388ULL, 0x000fe60000000800ULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000000a23007388ULL, 0x000fe80000000800ULL,
0x000000191e007388ULL, 0x000fe80000000800ULL, 0x000000182d007388ULL, 0x000fe80000000800ULL,
0x0000001708007388ULL, 0x0003e80000000800ULL, 0x0000001631007388ULL, 0x000fe80000000800ULL,
0x0000000520007388ULL, 0x000fe20000000800ULL, 0x000000040408723eULL, 0x002fc600000010ffULL,
0x0000000c35007388ULL, 0x000fe80000000800ULL, 0x0000000b22007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000007107984ULL, 0x000e680000000c00ULL,
0x0004000007247984ULL, 0x000ea80000000c00ULL, 0x00080000071c7984ULL, 0x000ee80000000c00ULL,
0x000c000007187984ULL, 0x000f220000000c00ULL, 0x3f803f8008137831ULL, 0x002fc40000200013ULL,
0x3f803f8008127831ULL, 0x040fe40000200012ULL, 0x3f803f8008117831ULL, 0x040fe40000200011ULL,
0x3f803f8008107831ULL, 0x040fe40000200010ULL, 0x3f803f8008277831ULL, 0x044fe40000200027ULL,
0x3f803f8008267831ULL, 0x040fe40000200026ULL, 0x3f803f8008257831ULL, 0x000fc40000200025ULL,
0x3f803f8008247831ULL, 0x000fe40000200024ULL, 0x3f803f8013137831ULL, 0x008fe4000020001fULL,
0x3f803f8012127831ULL, 0x000fe4000020001eULL, 0x3f803f8011117831ULL, 0x000fe4000020001dULL,
0x3f803f8010107831ULL, 0x000fe4000020001cULL, 0x3f803f8027277831ULL, 0x010fc4000020001bULL,
0x3f803f8026267831ULL, 0x000fe2000020001aULL, 0x0000001007007388ULL, 0x0003e20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200019ULL, 0x3f803f8024247831ULL, 0x000fca0000200018ULL,
0x0004002407007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x002e620000002600ULL, 0x00000020031d7810ULL, 0x040fe20007ffe0ffULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x00000040031f7810ULL, 0x040fe20007ffe0ffULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x00000003ff027819ULL, 0x000fe20000011603ULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x0000006003217810ULL, 0x000fe20007ffe0ffULL,
0x00000008091a7824ULL, 0x040fe200078e00ffULL, 0x00000003ff0a7819ULL, 0x000fe2000001161dULL,
0x00000008091e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0b7819ULL, 0x000fc4000001161fULL,
0x00000003ff187819ULL, 0x000fe40000011621ULL, 0x000000070a047812ULL, 0x000fe400078e481dULL,
0x000000070b067812ULL, 0x000fe400078e481fULL, 0x00000007180c7812ULL, 0x000fe400078e4821ULL,
0x0ffffff804077812ULL, 0x000fe400078ef81dULL, 0x0ffffff8060d7812ULL, 0x000fe200078ef81fULL,
0x0000001019057824ULL, 0x002fe200078e00ffULL, 0x0ffffff80c0f7812ULL, 0x000fe200078ef821ULL,
0x00000010070c7824ULL, 0x100fe200078e0200ULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x000000100d107824ULL, 0x000fe200078e0200ULL, 0xfffffff005087812ULL, 0x000fe200078ee202ULL,
0x000000100f147824ULL, 0x000fe200078e0200ULL, 0x0000000702027812ULL, 0x100fe200078e4803ULL,
0x000000000c0c7984ULL, 0x004fe20000000c00ULL, 0x0000000408087c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001019237824ULL, 0x000fe200078e00ffULL, 0x0ffffff802057812ULL, 0x000fe200078ef803ULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x0000000809027824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1f7812ULL, 0x000fc400078ee21fULL, 0x0000001005057824ULL, 0x000fe200078e0200ULL,
0x0000000014147984ULL, 0x000fe20000000c00ULL, 0x0000000809007824ULL, 0x000fe200078e00ffULL,
0xfffffff8021d7812ULL, 0x000fe400078ee21dULL, 0xfffffff0230a7812ULL, 0x000fe200078ee20aULL,
0x0000000005047984ULL, 0x000e620000000c00ULL, 0xfffffff8001b7812ULL, 0x000fe200078ee203ULL,
0x0000001019007824ULL, 0x040fe200078e00ffULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x0000001019197824ULL, 0x000fc400078e00ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0008027a11ULL, 0x000fe400078040ffULL, 0xfffffff0000b7812ULL, 0x000fe400078ee20bULL,
0xfffffff019187812ULL, 0x000fe400078ee218ULL, 0x00005b0008037a11ULL, 0x000fe400000f4403ULL,
0x000000040a1c7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040b0b7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x0000000418007c10ULL, 0x000fc6000ff5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005a001c087a11ULL, 0x000fe200078040ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005a000b0a7a11ULL, 0x040fe200078240ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a0000187a11ULL, 0x000fe400078440ffULL,
0x00005b001c097a11ULL, 0x000fe400000f4409ULL, 0x00005b000b0b7a11ULL, 0x000fe400008f441aULL,
0x00005b0000197a11ULL, 0x000fe200010f4419ULL, 0x000000101d087825ULL, 0x000fc800078e0008ULL,
0x000000101f0a7825ULL, 0x000fe200078e000aULL, 0x0000000402007986ULL, 0x002fe6000c101d08ULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000c08007986ULL, 0x000fe8000c101d08ULL,
0x000000100a007986ULL, 0x000fe8000c101d08ULL, 0x0000001418007986ULL, 0x000fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x0000000804317981ULL, 0x000362000c1e9900ULL,
0x0000000119037810ULL, 0x000fe20007ffe0ffULL, 0x0000000210107824ULL, 0x000fe400078e00ffULL,
0x000000401a187824ULL, 0x000fe200078e00ffULL, 0x000000020300720cULL, 0x000fe20003f06070ULL,
0x00005800101b7a24ULL, 0x000fe400078e021bULL, 0x00000100190c7824ULL, 0x000fc800078e0218ULL,
0x000062001b177a24ULL, 0x000fcc00078e020cULL, 0x000005c000008947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x002e620000000000ULL, 0x00000080ff217424ULL, 0x000fe200078e00ffULL,
0x0000000c00037217ULL, 0x000fe40007800000ULL, 0x000010001a147811ULL, 0x000fc600078e68ffULL,
0x0000000103037824ULL, 0x000fe200078e0a0cULL, 0x00000002ff207819ULL, 0x102fe2000001160fULL,
0x000000100f1f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fe4000001160fULL,
0x00000008200e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000120047824ULL, 0x140fe200078e0217ULL,
0x0000001820247810ULL, 0x040fe40007ffe0ffULL, 0x0000001020227810ULL, 0x000fe20007ffe0ffULL,
0x000000010e067824ULL, 0x000fe200078e0217ULL, 0x000000301f1f7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x0000002020167810ULL, 0x000fc40007ffe0ffULL,
0x0000000312127812ULL, 0x000fe200078e480fULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000001f040c7210ULL, 0x080fe40007f1e0ffULL, 0x00000028201c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001240a7824ULL, 0x100fe200078e0217ULL, 0x0000001f06067210ULL, 0x000fe20007f3e0ffULL,
0x0000000122087824ULL, 0x000fe200078e0217ULL, 0x0ffffffc120f7812ULL, 0x000fe200078ef80fULL,
0x00005e000a0a7625ULL, 0x000fe200078e0021ULL, 0x00000030201e7810ULL, 0x000fc40007ffe0ffULL,
0x000000032200720cULL, 0x000fe20003fa6070ULL, 0x00005e0008087625ULL, 0x000fe200078e0021ULL,
0x000000032400720cULL, 0x080fe40003f86070ULL, 0x000000031600720cULL, 0x000fe20003f66070ULL,
0x0000000117047824ULL, 0x000fe400078e0216ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000001f0a0a7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x0000001f08087210ULL, 0x000fe20007f1e0ffULL, 0x00005e0004047625ULL, 0x000fc800078e0021ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000030e00720cULL, 0x040fe20003f26070ULL,
0x000000040e117824ULL, 0x000fe200078e00ffULL, 0x0000001f040e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000032000720cULL, 0x0c0fe20003f06070ULL,
0x0000000117047824ULL, 0x000fe200078e021cULL, 0xfffffffc11117812ULL, 0x000fe200078ee212ULL,
0x000000100f137824ULL, 0x000fe200078e0214ULL, 0x0000003820207810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e0605ULL, 0x000000031c00720cULL, 0x000fe20003f46070ULL,
0x00005e0004047625ULL, 0x000fc800078e0021ULL, 0x0000001011157824ULL, 0x000fe200078e0214ULL,
0x0000001f04107210ULL, 0x000fe20007fde0ffULL, 0x0000000117047824ULL, 0x000fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c137faeULL, 0x0003e2000c101c48ULL,
0x000000032000720cULL, 0x0c0fe20003f06070ULL, 0x00000004201d7824ULL, 0x000fe400078e00ffULL,
0x0000000006157faeULL, 0x0005e2000c901c48ULL, 0x000000ffff117224ULL, 0x000fe200030e0605ULL,
0x000000031e00720cULL, 0x000fe20003f26070ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0xfffffffc1d1d7812ULL, 0x000fc600078ee212ULL, 0x0000000422037824ULL, 0x000fe200078e00ffULL,
0x0000001f04047210ULL, 0x000fe20007fde0ffULL, 0x00000004240d7824ULL, 0x002fe400078e00ffULL,
0x0000000416137824ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x100fe200078ee212ULL,
0x000000041e077824ULL, 0x004fe200078e00ffULL, 0xfffffffc0d0d7812ULL, 0x000fe200078ee212ULL,
0x0000000117067824ULL, 0x000fe200078e0220ULL, 0xfffffffc13137812ULL, 0x100fe200078ee212ULL,
0x000000041c157824ULL, 0x000fe200078e00ffULL, 0xfffffffc07177812ULL, 0x000fe200078ee212ULL,
0x00005e0006067625ULL, 0x000fc600078e0021ULL, 0xfffffffc15157812ULL, 0x000fe200078ee212ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000001f06067210ULL, 0x000fe20007fde0ffULL,
0x0000001003037824ULL, 0x100fe400078e0214ULL, 0x000000100d0d7824ULL, 0x100fe400078e0214ULL,
0x0000001013137824ULL, 0x100fe200078e0214ULL, 0x0000000008037faeULL, 0x0003e2000e901c48ULL,
0x0000001015157824ULL, 0x100fe400078e0214ULL, 0x0000001017177824ULL, 0x100fe200078e0214ULL,
0x000000000a0d7faeULL, 0x0003e2000e101c48ULL, 0x000000101d1d7824ULL, 0x000fc400078e0214ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000000e137faeULL, 0x0003e8000d901c48ULL,
0x0000000010157faeULL, 0x0003e8000d101c48ULL, 0x0000000004177faeULL, 0x0003e8000c901c48ULL,
0x00000000061d7faeULL, 0x0003e2000c101c48ULL, 0x0000050000007947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x002e620000000000ULL, 0x00000080ff257424ULL, 0x000fe200078e00ffULL,
0x000010001a237811ULL, 0x000fe200078e68ffULL, 0x000000100e067824ULL, 0x042fe200078e00ffULL,
0x000000100e057811ULL, 0x000fc400078ff0ffULL, 0x000000170e047211ULL, 0x040fe400078ff0ffULL,
0x00000003ff037819ULL, 0x000fe2000001160eULL, 0x00000004051e7824ULL, 0x000fe200078e00ffULL,
0x000000080e087811ULL, 0x000fe400078ff0ffULL, 0x0000003006277812ULL, 0x000fe200078ec0ffULL,
0x0000000117067824ULL, 0x000fe200078e0205ULL, 0x000000180e077811ULL, 0x000fe200078ff0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0025ULL, 0x000000200e097811ULL, 0x000fc400078ff0ffULL,
0x000000280e0a7811ULL, 0x000fe200078ff0ffULL, 0x0000000408107824ULL, 0x000fe200078e00ffULL,
0x000000300e0b7811ULL, 0x040fe200078ff0ffULL, 0x0000000407207824ULL, 0x000fe200078e00ffULL,
0x000000380e0c7811ULL, 0x000fe200078ff0ffULL, 0x0000000409227824ULL, 0x000fe200078e00ffULL,
0x00000003030f7812ULL, 0x100fe200078e480eULL, 0x000000040a247824ULL, 0x000fe400078e00ffULL,
0x000000040b267824ULL, 0x000fe200078e00ffULL, 0x0ffffffc0f127812ULL, 0x000fe200078ef80eULL,
0x000000040c287824ULL, 0x000fe200078e00ffULL, 0x00000027040e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000108037824ULL, 0x000fe200078e0217ULL, 0xfffffffc24117812ULL, 0x100fe200078ee20fULL,
0x0000000117147824ULL, 0x040fe200078e020aULL, 0xfffffffc100a7812ULL, 0x000fe200078ee20fULL,
0x0000000117167824ULL, 0x040fe200078e020bULL, 0xfffffffc1e0b7812ULL, 0x100fe200078ee20fULL,
0x00000001171c7824ULL, 0x040fe200078e020cULL, 0xfffffffc200c7812ULL, 0x000fe200078ee20fULL,
0x0000000117087824ULL, 0x000fe200078e0207ULL, 0xfffffffc22107812ULL, 0x100fe200078ee20fULL,
0x00005e0006067625ULL, 0x000fe200078e0025ULL, 0xfffffffc26137812ULL, 0x000fc400078ee20fULL,
0xfffffffc281e7812ULL, 0x000fe200078ee20fULL, 0x000000ffff0f7224ULL, 0x000fe400000e0605ULL,
0x00005e0003047625ULL, 0x000fc800078e0025ULL, 0x00000010101d7824ULL, 0x000fe200078e0223ULL,
0x0000002704107210ULL, 0x000fe20007f1e0ffULL, 0x00000001170d7824ULL, 0x000fe400078e0209ULL,
0x00005e0008087625ULL, 0x000fc800078e0025ULL, 0x0000001012297824ULL, 0x100fe200078e0223ULL,
0x0000002706127210ULL, 0x080fe20007f3e0ffULL, 0x00000010111f7824ULL, 0x000fe400078e0223ULL,
0x000000ffff117224ULL, 0x000fe200000e0605ULL, 0x0000002708087210ULL, 0x000fe20007f1e0ffULL,
0x0000001013217824ULL, 0x000fe200078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e297faeULL, 0x0003e2000b901c48ULL, 0x000000ffff137224ULL, 0x000fe400008e0607ULL,
0x00005e000d047625ULL, 0x000fc800078e0025ULL, 0x000000100a037824ULL, 0x100fe400078e0223ULL,
0x000000100b157824ULL, 0x100fe400078e0223ULL, 0x00005e0014067625ULL, 0x000fe200078e0025ULL,
0x0000000010037faeULL, 0x0003e6000b901c48ULL, 0x000000100c177824ULL, 0x000fe200078e0223ULL,
0x0000002706067210ULL, 0x000fe20007f3e0ffULL, 0x00005e00160a7625ULL, 0x080fe200078e0025ULL,
0x0000000012157faeULL, 0x0003e6000b901c48ULL, 0x00005e001c0c7625ULL, 0x000fe200078e0025ULL,
0x000000270a0a7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000002704047210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000270c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000008177faeULL, 0x0003e2000b901c48ULL, 0x000000ffff057224ULL, 0x000fe400000e0605ULL,
0x000000101e237824ULL, 0x000fe400078e0223ULL, 0x000000ffff0d7224ULL, 0x000fe200018e060dULL,
0x00000000041d7faeULL, 0x0003e8000b901c48ULL, 0x00000000061f7faeULL, 0x0003e8000b901c48ULL,
0x000000000a217faeULL, 0x0003e8000b901c48ULL, 0x000000000c237faeULL, 0x0003e4000b901c48ULL,
0x00f60400ff037984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000003ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x00f60400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000031a00780cULL, 0x000fda0003f04070ULL,
0x0000017000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x000000201a037824ULL, 0x002fc800078e0203ULL, 0x0000001003057824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x000000f005057812ULL, 0x000fe400078ec0ffULL, 0x0000000104067812ULL, 0x040fe400078efcffULL,
0x0000000704047812ULL, 0x100fe400078e7803ULL, 0x0000000706067812ULL, 0x000fc600078e7803ULL,
0x0000000104047824ULL, 0x000fe400078e0205ULL, 0x0000000105067824ULL, 0x000fc600078e0206ULL,
0x00000000040c7984ULL, 0x000e68000000cc00ULL, 0x0000000006087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fc400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001004007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x00f60400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0022a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f60400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000021900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000307919ULL, 0x000ea20000000000ULL, 0x3db504f331317820ULL, 0x020fe20000410000ULL,
0x000000101a327824ULL, 0x000fe200078e00ffULL, 0xffffffff02347810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff337224ULL, 0x000fe200078e00ffULL, 0x00007610ff357816ULL, 0x000fe40000000035ULL,
0x0000010019377824ULL, 0x000fe200078e0218ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000370000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe200078e0033ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x002fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fc4000001ff00ULL,
0x0000000136257810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x0000000103337812ULL, 0x000fc400078e0cffULL, 0x00000001ff247819ULL, 0x000fe40000011625ULL,
0x000000022500780cULL, 0x040fe40003f06070ULL, 0x0000000125267812ULL, 0x000fe200078ec0ffULL,
0x0000030024277a24ULL, 0x000fe400078e0219ULL, 0x000000ffff247224ULL, 0x000fe400078e0036ULL,
0x00000100272c7824ULL, 0x040fe200078e0218ULL, 0x00000001272d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff367224ULL, 0x000fc400078e0025ULL, 0x000062001b3b7a24ULL, 0x000fe200078e022cULL,
0x000000022d00720cULL, 0x000fda0003f26070ULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x0000002c00257217ULL, 0x000fe20007800000ULL, 0x00000004263f7824ULL, 0x000fe200078e00ffULL,
0x00000002ff2e7819ULL, 0x104fe20000011630ULL, 0x000000021a3e7824ULL, 0x000fe200078e0233ULL,
0x00000003ff277819ULL, 0x000fe20000011630ULL, 0x0000000125257824ULL, 0x000fe200078e0a2cULL,
0x000000082e387810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff3d7424ULL, 0x000fe200078e00ffULL,
0x0000000327417812ULL, 0x100fe200078e4830ULL, 0x000000012e267824ULL, 0x100fe200078e023bULL,
0x000000253800720cULL, 0x0c0fe20003f46070ULL, 0x00000001382c7824ULL, 0x000fe200078e023bULL,
0x000000252e00720cULL, 0x000fe20003f26070ULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0xfffffffc3f3f7812ULL, 0x000fe200078ee230ULL, 0x00005e0026267625ULL, 0x000fe200078e003dULL,
0x000010003e3e7811ULL, 0x000fc400078e60ffULL, 0x0ffffffc412f7812ULL, 0x000fe200078ef830ULL,
0x00005e002c2c7625ULL, 0x000fe200078e003dULL, 0xfffffffc38397812ULL, 0x000fe400078ee241ULL,
0x000000102e387810ULL, 0x040fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e023eULL,
0x000000182e3a7810ULL, 0x040fe20007ffe0ffULL, 0x000000103f267825ULL, 0x000fe200078e0026ULL,
0x000000202e3c7810ULL, 0x040fe40007ffe0ffULL, 0x000000282e407810ULL, 0x040fe20007ffe0ffULL,
0x0000001039397824ULL, 0x000fe200078e023eULL, 0x000000302e427810ULL, 0x040fe20007ffe0ffULL,
0x000000103f2c7825ULL, 0x000fe200078e002cULL, 0x000000382e447810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c901c48ULL,
0x000000253800720cULL, 0x0c0fe20003f26070ULL, 0x0000000438467824ULL, 0x000fe200078e00ffULL,
0x000000253c00720cULL, 0x080fe20003f66070ULL, 0x000000002c397faeULL, 0x0005e2000d101c48ULL,
0x000000253a00720cULL, 0x0c0fe20003f46070ULL, 0x000000043a487824ULL, 0x000fe200078e00ffULL,
0x000000254000720cULL, 0x080fe20003f86070ULL, 0x000000013c2e7824ULL, 0x100fe200078e023bULL,
0x000000254200720cULL, 0x080fe20003fa6070ULL, 0x000000043c4a7824ULL, 0x000fe200078e00ffULL,
0x000000254400720cULL, 0x000fe20003fc6070ULL, 0x0000000138267824ULL, 0x002fe200078e023bULL,
0xfffffffc46257812ULL, 0x000fe200078ee241ULL, 0x0000000140387824ULL, 0x000fe200078e023bULL,
0xfffffffc48437812ULL, 0x000fe200078ee241ULL, 0x000000013a2c7824ULL, 0x004fe200078e023bULL,
0xfffffffc4a457812ULL, 0x000fe200078ee241ULL, 0x00000001423a7824ULL, 0x000fc400078e023bULL,
0x00000001443c7824ULL, 0x000fe400078e023bULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x00005e0026267625ULL, 0x000fc600078e003dULL, 0xfffffffc40477812ULL, 0x000fe200078ee241ULL,
0x00005e002c2c7625ULL, 0x000fc800078e003dULL, 0x00005e002e2e7625ULL, 0x000fc800078e003dULL,
0x00005e0038387625ULL, 0x000fc800078e003dULL, 0x00005e003a3a7625ULL, 0x000fc800078e003dULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x00005e003c3c7625ULL, 0x000fc600078e003dULL,
0xfffffffc42497812ULL, 0x000fe200078ee241ULL, 0x0000000444447824ULL, 0x000fe400078e00ffULL,
0x000000103f267825ULL, 0x000fc600078e0026ULL, 0xfffffffc444b7812ULL, 0x000fe200078ee241ULL,
0x000000103f2c7825ULL, 0x000fc800078e002cULL, 0x000000103f2e7825ULL, 0x000fc800078e002eULL,
0x000000103f387825ULL, 0x000fc800078e0038ULL, 0x000000103f3a7825ULL, 0x000fc800078e003aULL,
0x000000103f3c7825ULL, 0x000fc800078e003cULL, 0x0000001025257824ULL, 0x100fe400078e023eULL,
0x00000010433f7824ULL, 0x100fe400078e023eULL, 0x0000001045417824ULL, 0x100fe200078e023eULL,
0x0000000026257faeULL, 0x0003e2000c901c48ULL, 0x0000001047437824ULL, 0x100fe400078e023eULL,
0x0000001049457824ULL, 0x100fe200078e023eULL, 0x000000002c3f7faeULL, 0x0003e2000d101c48ULL,
0x000000104b477824ULL, 0x000fc600078e023eULL, 0x000000002e417faeULL, 0x0003e8000d901c48ULL,
0x0000000038437faeULL, 0x0003e8000e101c48ULL, 0x000000003a457faeULL, 0x0003e8000e901c48ULL,
0x000000003c477faeULL, 0x0003e2000f101c48ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x000000021a2c7824ULL, 0x000fe200078e0233ULL, 0x00000008302e7811ULL, 0x004fe200078ff0ffULL,
0x0000000426257824ULL, 0x000fe200078e00ffULL, 0x0000001030387811ULL, 0x040fe200078ff0ffULL,
0x00000080ff417424ULL, 0x000fe200078e00ffULL, 0x00000018303a7811ULL, 0x000fe200078ff0ffULL,
0x000000042e447824ULL, 0x000fe200078e00ffULL, 0x00000020303c7811ULL, 0x000fe200078ff0ffULL,
0x0000000438467824ULL, 0x000fe200078e00ffULL, 0x00000028303e7811ULL, 0x000fe200078ff0ffULL,
0x000000043a487824ULL, 0x000fe200078e00ffULL, 0x0000003030407811ULL, 0x000fe200078ff0ffULL,
0x000000043c4a7824ULL, 0x000fe200078e00ffULL, 0x0000003830427811ULL, 0x000fe200078ff0ffULL,
0x000000043e4c7824ULL, 0x000fe200078e00ffULL, 0x000010002c4d7811ULL, 0x000fe200078e60ffULL,
0x000000012e2c7824ULL, 0x100fe200078e023bULL, 0x00000003ff277819ULL, 0x100fe20000011630ULL,
0x00000001382e7824ULL, 0x100fe200078e023bULL, 0x0000003b30267211ULL, 0x000fe200078ff0ffULL,
0x000000013a387824ULL, 0x100fe200078e023bULL, 0x00000003272d7812ULL, 0x100fe200078e4830ULL,
0x000000013c3a7824ULL, 0x000fe200078e023bULL, 0xfffffffc25257812ULL, 0x000fe200078ee230ULL,
0x00000004404e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44447812ULL, 0x100fe200078ee22dULL,
0x0000000442507824ULL, 0x000fe200078e00ffULL, 0xfffffffc46467812ULL, 0x000fe200078ee22dULL,
0x000000013e3c7824ULL, 0x000fe200078e023bULL, 0xfffffffc48487812ULL, 0x000fe200078ee22dULL,
0x00000001403e7824ULL, 0x000fe200078e023bULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee22dULL,
0x0000000142407824ULL, 0x000fe200078e023bULL, 0xfffffffc4c4c7812ULL, 0x100fe200078ee22dULL,
0x00005e0026267625ULL, 0x000fe200078e0041ULL, 0xfffffffc4e4e7812ULL, 0x000fc400078ee22dULL,
0xfffffffc50507812ULL, 0x000fe200078ee22dULL, 0x00005e002e2e7625ULL, 0x000fe200078e0041ULL,
0x0ffffffc2d427812ULL, 0x000fc600078ef830ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0041ULL,
0x00005e0038387625ULL, 0x000fc800078e0041ULL, 0x00005e003a3a7625ULL, 0x000fc800078e0041ULL,
0x00005e003c3c7625ULL, 0x000fc800078e0041ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0041ULL,
0x00005e0040407625ULL, 0x000fc800078e0041ULL, 0x0000001025267825ULL, 0x000fc800078e0026ULL,
0x00000010252c7825ULL, 0x000fc800078e002cULL, 0x00000010252e7825ULL, 0x000fc800078e002eULL,
0x0000001025387825ULL, 0x000fc800078e0038ULL, 0x00000010253a7825ULL, 0x000fc800078e003aULL,
0x00000010253c7825ULL, 0x000fc800078e003cULL, 0x00000010253e7825ULL, 0x000fc800078e003eULL,
0x0000001025407825ULL, 0x000fc800078e0040ULL, 0x00000010424f7824ULL, 0x100fe400078e024dULL,
0x0000001044257824ULL, 0x100fe400078e024dULL, 0x0000001046437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000264f7faeULL, 0x0003e2000b901c48ULL,
0x0000001048457824ULL, 0x100fe400078e024dULL, 0x000000104a477824ULL, 0x100fe200078e024dULL,
0x000000002c257faeULL, 0x0003e2000b901c48ULL, 0x000000104c497824ULL, 0x000fc400078e024dULL,
0x000000104e4b7824ULL, 0x100fe200078e024dULL, 0x000000002e437faeULL, 0x0003e2000b901c48ULL,
0x00000010504d7824ULL, 0x000fc600078e024dULL, 0x0000000038457faeULL, 0x0003e8000b901c48ULL,
0x000000003a477faeULL, 0x0003e8000b901c48ULL, 0x000000003c497faeULL, 0x0003e8000b901c48ULL,
0x000000003e4b7faeULL, 0x0003e8000b901c48ULL, 0x00000000404d7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000824397824ULL, 0x002fc400078e00ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff830257812ULL, 0x000fe200078ec0ffULL,
0x000000021a3b7824ULL, 0x000fe200078e0203ULL, 0x00000020302d7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000725257812ULL, 0x100fe400078ef830ULL,
0xfffffff82d2d7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff247819ULL, 0x000fe40000011625ULL,
0x000000072d267812ULL, 0x000fc400078ef830ULL, 0x0000000324277812ULL, 0x000fe400078ec0ffULL,
0x00000001ff2c7819ULL, 0x000fe40000011626ULL, 0x0000003827247212ULL, 0x080fe400078e3cffULL,
0x000000032c2d7812ULL, 0x000fe400078ec0ffULL, 0x000010003b3b7811ULL, 0x000fe200078e60ffULL,
0x0000000425247824ULL, 0x000fe200078e0224ULL, 0x000000382d2f7212ULL, 0x000fc400078e3cffULL,
0x00000001382c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001024407824ULL, 0x000fe200078e023bULL,
0x0000000238387810ULL, 0x000fe20007ffe0ffULL, 0x0000000426247824ULL, 0x000fc600078e022fULL,
0x000000043800780cULL, 0x000fe20003f25270ULL, 0x00000010243c7824ULL, 0x000fe200078e023bULL,
0x0000002c27247212ULL, 0x000fe200078e3cffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000000730277812ULL, 0x000fc600078ec0ffULL, 0x00000004252e7824ULL, 0x000fe200078e0224ULL,
0x00000008273a7812ULL, 0x000fe200078ef830ULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x0000002c2d277212ULL, 0x000fe200078e3cffULL, 0x000000102e2e7824ULL, 0x000fe200078e023bULL,
0x0000003930247211ULL, 0x000fe400078fe0ffULL, 0x0000000439397810ULL, 0x000fe20007ffe0ffULL,
0x0000000426267824ULL, 0x000fe200078e0227ULL, 0x0000000224257810ULL, 0x040fe20007ffe0ffULL,
0x000000002e2c783bULL, 0x000ee20000000200ULL, 0x0000000724477812ULL, 0x100fe200078e783aULL,
0x0000001026267824ULL, 0x000fe200078e023bULL, 0x0000000725257812ULL, 0x000fc600078e783aULL,
0x000000103a477824ULL, 0x040fe400078e0247ULL, 0x000000103a4b7824ULL, 0x000fe400078e0225ULL,
0x000000002624783bULL, 0x000f220000000200ULL, 0x0000ffff407c7812ULL, 0x002fe400078ec0ffULL,
0x000000ff414c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff417d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x004fc4000001163fULL, 0x00000018ff617819ULL, 0x000fe4000001163fULL,
0x000000ff3f457812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3f557812ULL, 0x000fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x008fe4000001162cULL, 0x00000018ff767819ULL, 0x000fe4000001162dULL,
0x0000003fff3f723eULL, 0x000fc400020006ffULL, 0x00000076ff76723eULL, 0x000fe400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011640ULL, 0x00000010ff567819ULL, 0x110fe40000011624ULL,
0x00000018ff587819ULL, 0x000fe40000011624ULL, 0x000000ff24597812ULL, 0x040fe400078ec0ffULL,
0x0000ffff24507812ULL, 0x000fc400078ec0ffULL, 0x00000008ff247819ULL, 0x000fe4000001167cULL,
0x00000010ff747819ULL, 0x000fe40000011641ULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000010ff497819ULL, 0x100fe4000001162fULL, 0x00000018ff7a7819ULL, 0x000fe4000001162fULL,
0x000000ff2f7b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff2f4a7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff426f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x100fe40000011625ULL,
0x00000018ff5a7819ULL, 0x000fe40000011625ULL, 0x000000ff255b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff253b7812ULL, 0x000fc400078ec0ffULL, 0x0000004cff2f723eULL, 0x000fe200020006ffULL,
0x2000003fff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff717819ULL, 0x000fe20000011642ULL,
0x20000076ff3f7230ULL, 0x000fe20000004100ULL, 0x00000008ff257819ULL, 0x000fe2000001167dULL,
0x20000024ff767230ULL, 0x000fe20000004100ULL, 0x00000018ff3a7819ULL, 0x000fe20000011640ULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x000000ff40447812ULL, 0x000fe400078ec0ffULL,
0x000000ff73737812ULL, 0x000fc400078ec0ffULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x00000010ff6e7819ULL, 0x000fe40000011643ULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x000000ff424d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff247819ULL, 0x000fc4000001166fULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x000000ff43657812ULL, 0x040fe400078ec0ffULL, 0x0000ffff436d7812ULL, 0x000fe400078ec0ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x000000ff71717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fc4000001162cULL, 0x000000ff2c437812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2c4f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff2d777812ULL, 0x000fe400078ec0ffULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000010ff5d7819ULL, 0x100fe4000001163cULL,
0x00000018ff637819ULL, 0x000fc4000001163cULL, 0x000000ff3c627812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3c5e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff577819ULL, 0x000fe4000001162dULL,
0x0000ffff2d757812ULL, 0x000fe400078ec0ffULL, 0x0000003aff2c723eULL, 0x000fe400020006ffULL,
0x00000074ff74723eULL, 0x000fc400020006ffULL, 0x000000ff6e6e7812ULL, 0x000fe200078ec0ffULL,
0x2000002cff2c7230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x100fe4000001162eULL,
0x00000018ff787819ULL, 0x000fe4000001162eULL, 0x000000ff2e797812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2e487812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3a7819ULL, 0x000fc40000011626ULL,
0x00000018ff5c7819ULL, 0x000fe40000011626ULL, 0x000000ff262d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff263c7812ULL, 0x000fe400078ec0ffULL, 0x00000024ff24723eULL, 0x000fe400020006ffULL,
0x00000018ff537819ULL, 0x000fe4000001163dULL, 0x00000040ff2e723eULL, 0x000fc400020006ffULL,
0x00000071ff26723eULL, 0x000fe200020006ffULL, 0x20000025ff717230ULL, 0x000fe20000004100ULL,
0x00000018ff607819ULL, 0x000fe2000001163eULL, 0x2000002eff2e7230ULL, 0x000fe20000004100ULL,
0x00000077ff40723eULL, 0x000fe200020006ffULL, 0x20000073ff777230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe2000001166dULL, 0x20000074ff737230ULL, 0x000fe20000004100ULL,
0x0000006eff25723eULL, 0x000fe200020006ffULL, 0x20000024ff747230ULL, 0x000fe20000004100ULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000026ff6f7230ULL, 0x000fe20000004100ULL,
0x00000060ff24723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000006dff6e723eULL, 0x000fe200020006ffULL, 0x20000025ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fc400078ec0ffULL, 0x00000061ff25723eULL, 0x000fe200020006ffULL,
0x20000053ff617230ULL, 0x000fe20000004100ULL, 0x000000ff3d527812ULL, 0x000fe200078ec0ffULL,
0x20000024ff537230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000057ff24723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x20000045ff577230ULL, 0x000fe20000004100ULL,
0x00000063ff26723eULL, 0x000fe200020006ffULL, 0x20000024ff457230ULL, 0x000fe20000004100ULL,
0x000000ff46247812ULL, 0x000fe200078ec0ffULL, 0x20000052ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe2000001163dULL, 0x20000025ff527230ULL, 0x000fe20000004100ULL,
0x00000024ff25723eULL, 0x000fe200020006ffULL, 0x0000001047247824ULL, 0x000fe200078e00ffULL,
0x0000ffff3d6c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff677819ULL, 0x000fe2000001163eULL,
0x20000025ff477230ULL, 0x000fe20000004100ULL, 0x000000ff3e547812ULL, 0x040fe400078ec0ffULL,
0x0000ffff3e687812ULL, 0x000fe400078ec0ffULL, 0x00000062ff63723eULL, 0x000fe200020006ffULL,
0x20000026ff627230ULL, 0x000fe20000004100ULL, 0x00000010ff3d7819ULL, 0x100fe40000011627ULL,
0x00000018ff707819ULL, 0x000fe20000011627ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x000000ff275f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff273e7812ULL, 0x000fe400078ec0ffULL,
0x000000002424783bULL, 0x000e620000000200ULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000008ff757819ULL, 0x000fe20000011675ULL,
0x20000041ff6b7230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000065ff66723eULL, 0x000fe200020006ffULL, 0x20000042ff657230ULL, 0x000fe20000004100ULL,
0x00000078ff41723eULL, 0x000fe200020006ffULL, 0x20000044ff727230ULL, 0x000fe20000004100ULL,
0x00000079ff42723eULL, 0x000fe200020006ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000005fff78723eULL, 0x000fe200020006ffULL, 0x20000075ff467230ULL, 0x000fe20000004100ULL,
0x00000070ff79723eULL, 0x000fc400020006ffULL, 0x0000002dff2d723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff5f7230ULL, 0x000fe20000004100ULL,
0x0000005eff70723eULL, 0x000fe200020006ffULL, 0x20000078ff5e7230ULL, 0x000fe20000004100ULL,
0x0000005dff75723eULL, 0x000fe200020006ffULL, 0x2000002dff5d7230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe2000001166cULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000000ff69797812ULL, 0x000fe200078ec0ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fc4000001162cULL, 0x00000010ff2c7819ULL, 0x000fe40000011672ULL,
0x00000010ff2d7819ULL, 0x000fe40000011677ULL, 0x00000010ff697819ULL, 0x000fe40000011676ULL,
0x000010546c2d7816ULL, 0x000fe4000000002dULL, 0x00001054692c7816ULL, 0x000fe4000000002cULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x0000002c2428723cULL, 0x002fe20000041828ULL,
0x2000004dff6a7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000008ff697819ULL, 0x000fe20000011668ULL, 0x20000079ff687230ULL, 0x000fe20000004100ULL,
0x000000ff676c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff2c7819ULL, 0x000fc4000001162eULL,
0x00000010ff2e7819ULL, 0x000fe4000001162fULL, 0x00000010ff2f7819ULL, 0x000fe40000011673ULL,
0x00001054712e7816ULL, 0x000fe4000000002eULL, 0x000010542c2f7816ULL, 0x000fe4000000002fULL,
0x000000ff64717812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fc4000001166bULL,
0x00000010ff2d7819ULL, 0x000fe2000001166fULL, 0x0000002e2404723cULL, 0x000fe20000041804ULL,
0x00000010ff2c7819ULL, 0x000fe4000001166aULL, 0x00000010ff6b7819ULL, 0x000fe40000011674ULL,
0x00001054642d7816ULL, 0x000fe4000000002dULL, 0x000010546b2c7816ULL, 0x000fe4000000002cULL,
0x00000010ff647819ULL, 0x000fc40000011665ULL, 0x00000010ff2f7819ULL, 0x000fe4000001166dULL,
0x00000010ff2e7819ULL, 0x000fe20000011666ULL, 0x0000002c2420723cULL, 0x000fe20000041820ULL,
0x00000010ff657819ULL, 0x000fe4000001166eULL, 0x00001054642f7816ULL, 0x000fe4000000002fULL,
0x00001054652e7816ULL, 0x000fe4000000002eULL, 0x00000008ff647819ULL, 0x000fc40000011655ULL,
0x00000010ff2c7819ULL, 0x000fe40000011663ULL, 0x00000010ff2d7819ULL, 0x000fe20000011675ULL,
0x0000002e241c723cULL, 0x000fe2000004181cULL, 0x00000010ff557819ULL, 0x000fe40000011670ULL,
0x00001054622d7816ULL, 0x000fe4000000002dULL, 0x00001054552c7816ULL, 0x000fe4000000002cULL,
0x00000010ff2e7819ULL, 0x000fe20000011661ULL, 0x000000104b2f7824ULL, 0x000fe200078e00ffULL,
0x00000010ff617819ULL, 0x000fc40000011668ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x0000002c2414723cULL, 0x000fe20000041814ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe200020006ffULL, 0x20000078ff677230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x000010542e617816ULL, 0x000fe20000000061ULL, 0x20000071ff717230ULL, 0x000fe20000004100ULL,
0x000000002f2c783bULL, 0x000e620000000200ULL, 0x000000ff56567812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fc40000011660ULL,
0x00000056ff4b723eULL, 0x000fe400020006ffULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff567819ULL, 0x000fe20000011653ULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff557819ULL, 0x000fe4000001166cULL,
0x00000010ff697819ULL, 0x000fc40000011669ULL, 0x00000010ff527819ULL, 0x000fe40000011652ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff657819ULL, 0x000fe40000011671ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff487819ULL, 0x000fe40000011648ULL,
0x0000105467607816ULL, 0x000fc40000000060ULL, 0x0000105456557816ULL, 0x000fe40000000055ULL,
0x0000105469547816ULL, 0x000fe40000000054ULL, 0x0000105452657816ULL, 0x000fe20000000065ULL,
0x00000060240c723cULL, 0x000fe2000004180cULL, 0x0000105464647816ULL, 0x000fe40000000057ULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x00000048ff48723eULL, 0x000fc400020006ffULL,
0x000000ff49497812ULL, 0x000fe200078ec0ffULL, 0x000000542410723cULL, 0x040fe20000041810ULL,
0x00000008ff4a7819ULL, 0x000fe2000001164aULL, 0x20000043ff4d7230ULL, 0x000fe20000004100ULL,
0x00000008ff3b7819ULL, 0x000fe2000001163bULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x0000007aff43723eULL, 0x000fe400020006ffULL, 0x0000007bff44723eULL, 0x000fe200020006ffULL,
0x000000642408723cULL, 0x000fe20000041808ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000010ff407819ULL, 0x000fe20000011640ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x000000ff3a267812ULL, 0x000fe200078ec0ffULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fc4000001163fULL,
0x00000010ff277819ULL, 0x000fe40000011645ULL, 0x00000010ff257819ULL, 0x000fe40000011646ULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x0000003bff3a723eULL, 0x000fe400020006ffULL,
0x00000026ff45723eULL, 0x000fe400020006ffULL, 0x0000105424277816ULL, 0x000fe20000000027ULL,
0x2000003aff3f7230ULL, 0x000fe20000004100ULL, 0x0000105425267816ULL, 0x000fe20000000040ULL,
0x20000045ff407230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fc400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000051ff53723eULL, 0x000fe200020006ffULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff247819ULL, 0x000fe20000011641ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe20000011647ULL,
0x000000262c04723cULL, 0x002fe20000041804ULL, 0x00000010ff257819ULL, 0x000fc40000011648ULL,
0x00001054243b7816ULL, 0x000fe4000000003bULL, 0x00001054253a7816ULL, 0x000fe40000000042ULL,
0x00000010ff247819ULL, 0x000fe40000011643ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff457819ULL, 0x000fe20000011649ULL, 0x0000003a2c20723cULL, 0x000fe20000041820ULL,
0x00000010ff257819ULL, 0x000fc4000001164aULL, 0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff4f7819ULL, 0x000fe4000001164fULL, 0x00000008ff507819ULL, 0x000fe40000011650ULL,
0x00000008ff3c7819ULL, 0x000fe4000001163cULL, 0x000000ff3d3d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff3e7819ULL, 0x000fc4000001163eULL, 0x0000105424457816ULL, 0x000fe40000000045ULL,
0x0000105425447816ULL, 0x000fe40000000044ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff257819ULL, 0x000fe40000011653ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x000000442c1c723cULL, 0x000fe2000004181cULL, 0x00000010ff247819ULL, 0x000fc4000001163fULL,
0x0000004eff4e723eULL, 0x000fe400020006ffULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe200020006ffULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x00000050ff50723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe200020006ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x20000050ff507230ULL, 0x000fe20000004100ULL,
0x0000003eff3e723eULL, 0x000fe200020006ffULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x000010545a257816ULL, 0x000fe20000000025ULL, 0x2000003dff267230ULL, 0x000fe20000004100ULL,
0x0000105424247816ULL, 0x000fe2000000005bULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fc4000001164cULL, 0x00000010ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff4d7819ULL, 0x000fe2000001164dULL, 0x000000242c0c723cULL, 0x000fe2000004180cULL,
0x00000010ff4c7819ULL, 0x000fe4000001164fULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000010ff4b7819ULL, 0x000fc4000001164bULL,
0x00000010ff507819ULL, 0x000fe40000011650ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff3d7819ULL, 0x000fe40000011640ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff5f7819ULL, 0x000fc4000001165fULL,
0x00000010ff267819ULL, 0x000fe40000011626ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff257819ULL, 0x000fe4000001163eULL, 0x00001054514f7816ULL, 0x000fe4000000004eULL,
0x000010544c4e7816ULL, 0x000fe4000000004dULL, 0x0000105458517816ULL, 0x000fc4000000004bULL,
0x0000105450507816ULL, 0x000fe40000000059ULL, 0x000010545c3d7816ULL, 0x000fe2000000003dULL,
0x0000004e2c28723cULL, 0x000fe20000041828ULL, 0x000010543c3c7816ULL, 0x000fe4000000005dULL,
0x000010545f5f7816ULL, 0x000fe40000000026ULL, 0x00001054255e7816ULL, 0x000fc6000000005eULL,
0x000000502c14723cULL, 0x040ff00000041814ULL, 0x0000003c2c10723cULL, 0x040ff00000041810ULL,
0x0000005e2c08723cULL, 0x000fe20000041808ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe82000007947ULL, 0x000fec000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff037224ULL, 0x000fe200078e0033ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdcf000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00f6140032247984ULL, 0x000e620000000800ULL, 0x0000ffff35037812ULL, 0x000fe200078ec0ffULL,
0x0000002831397220ULL, 0x040fe20000410000ULL, 0x0000002a31287220ULL, 0x040fe20000410000ULL,
0x00000005312a7220ULL, 0x000fe20000410000ULL, 0x00008880033b7816ULL, 0x000fe200000000ffULL,
0x0000002b312d7220ULL, 0x040fe20000410000ULL, 0x0000002331057220ULL, 0x040fe20000410000ULL,
0x00000004312b7220ULL, 0x040fe20000410000ULL, 0x0000001531237220ULL, 0x000fe20000410000ULL,
0x800000003b037824ULL, 0x000fe200078e00ffULL, 0x0000002131277220ULL, 0x040fe20000410000ULL,
0x0000002231047220ULL, 0x040fe20000410000ULL, 0x0000001631157220ULL, 0x040fe20000410000ULL,
0x0000001431147220ULL, 0x040fe20000410000ULL, 0x0000000c31227220ULL, 0x040fe20000410000ULL,
0x0000000d31217220ULL, 0x040fe20000410000ULL, 0x0000000f310f7220ULL, 0x040fe20000410000ULL,
0x0000000631067220ULL, 0x040fe20000410000ULL, 0x0000000731077220ULL, 0x040fe20000410000ULL,
0x0000001e312e7220ULL, 0x040fe20000410000ULL, 0x0000001f312f7220ULL, 0x040fe20000410000ULL,
0x0000001731367220ULL, 0x040fe20000410000ULL, 0x0000000e310e7220ULL, 0x040fe20000410000ULL,
0x00000012310c7220ULL, 0x040fe20000410000ULL, 0x00000013310d7220ULL, 0x040fe20000410000ULL,
0x00000029312c7220ULL, 0x040fe20000410000ULL, 0x0000002031297220ULL, 0x040fe20000410000ULL,
0x0000001d31257220ULL, 0x040fe20000410000ULL, 0x000000ffff127224ULL, 0x000fe200078e0015ULL,
0x0000001c31267220ULL, 0x040fe20000410000ULL, 0x0000001031207220ULL, 0x040fe20000410000ULL,
0x00000011311f7220ULL, 0x040fe20000410000ULL, 0x00000008311e7220ULL, 0x040fe20000410000ULL,
0x00000009311d7220ULL, 0x040fe20000410000ULL, 0x0000000a31387220ULL, 0x040fe20000410000ULL,
0x0000000b313a7220ULL, 0x000fe20000410000ULL, 0x000000ffff157224ULL, 0x000fc400078e000fULL,
0x000000ffff1c7224ULL, 0x000fe200078e0028ULL, 0x8000000024ff7812ULL, 0x002fe20007804803ULL,
0x000000ffff247224ULL, 0x000fe400078e0014ULL, 0x000000ffff177224ULL, 0x000fe400078e002dULL,
0x000000ffff167224ULL, 0x000fe400078e0006ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0007ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0004ULL, 0x000000ffff097224ULL, 0x000fe400078e0005ULL,
0x000000ffff087224ULL, 0x000fe400078e002eULL, 0x000000ffff137224ULL, 0x000fe400078e002fULL,
0x000000ffff107224ULL, 0x000fe400078e0036ULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x000fc400078e000cULL, 0x000000ffff0f7224ULL, 0x000fe200078e000dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0038ULL, 0x000000ffff0d7224ULL, 0x000fe200078e003aULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000003b3b7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0002a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x00f6140032047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fc4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000430037824ULL, 0x000fe200078e00ffULL,
0x000000341900720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff003057812ULL, 0x000fca00078ec0ffULL, 0x000000801a0c7824ULL, 0x000fca00078e0205ULL,
0x00f400000c047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000230287824ULL, 0x000fe400078e00ffULL, 0x0000000100377824ULL, 0x000fc600078e0a37ULL,
0x0000000628287812ULL, 0x000fc800078ec0ffULL, 0x00000001282e7812ULL, 0x040fe400078efcffULL,
0x0000000828367812ULL, 0x000fe400078efcffULL, 0x000000372e00720cULL, 0x080fe40003f26070ULL,
0x00000010282e7812ULL, 0x000fe400078efcffULL, 0x000000373600720cULL, 0x080fe40003f06070ULL,
0x000000372e00720cULL, 0x000fc40003fc6070ULL, 0x0000001128367812ULL, 0x040fe400078efcffULL,
0x00000018282e7812ULL, 0x040fe400078efcffULL, 0x000000372800720cULL, 0x080fe40003f46070ULL,
0x000000373600720cULL, 0x080fe40003fa6070ULL, 0x000000372e00720cULL, 0x000fe40003f66070ULL,
0x0000000928387812ULL, 0x000fc400078efcffULL, 0x0000001928367812ULL, 0x040fe400078efcffULL,
0x00000020282e7812ULL, 0x000fe400078efcffULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff39397808ULL, 0x000fe40005000000ULL, 0xff7fffff17177808ULL, 0x000fe40004800000ULL,
0xff7fffff2c2c7808ULL, 0x000fc40004800000ULL, 0x000000373800720cULL, 0x080fe40003f86070ULL,
0x000000373600720cULL, 0x080fe40003f46070ULL, 0x000000372e00720cULL, 0x000fe40003f26070ULL,
0x0000002128367812ULL, 0x040fe400078efcffULL, 0x00000028282e7812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fc40004000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40006000000ULL,
0x000000373600720cULL, 0x080fe40003f06070ULL, 0x000000372e00720cULL, 0x000fe40003f86070ULL,
0x0000002928367812ULL, 0x000fc400078efcffULL, 0x00000030282e7812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff29297808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff27277808ULL, 0x000fe40006800000ULL,
0x000000373600720cULL, 0x000fc40003fc6070ULL, 0x000000372e00720cULL, 0x000fe40003fa6070ULL,
0x0000003128367812ULL, 0x040fe400078efcffULL, 0x00000038282e7812ULL, 0x040fe400078efcffULL,
0x0000003928287812ULL, 0x000fe400078efcffULL, 0xff7fffff08087808ULL, 0x000fe40005800000ULL,
0xff7fffff26267808ULL, 0x000fc40005800000ULL, 0xff7fffff13137808ULL, 0x000fe40005000000ULL,
0xff7fffff25257808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff24247808ULL, 0x000fe40004800000ULL, 0x000000373600720cULL, 0x080fe40003f66070ULL,
0x000000372e00720cULL, 0x000fc40003f46070ULL, 0x000000372800720cULL, 0x000fe40003f26070ULL,
0xff7fffff10107808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40004000000ULL,
0xff7fffff11117808ULL, 0x000fe40006000000ULL, 0xff7fffff22227808ULL, 0x000fe40006000000ULL,
0xff7fffff15157808ULL, 0x000fc40007000000ULL, 0xff7fffff21217808ULL, 0x000fe40007000000ULL,
0xff7fffff14147808ULL, 0x000fe40006800000ULL, 0xff7fffff20207808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL,
0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000039042d7209ULL, 0x004fe20007810000ULL,
0x0000001fff3b7424ULL, 0x000fe200078e00ffULL, 0x0000001c05287209ULL, 0x000fe20007810000ULL,
0xffffffffff3c7424ULL, 0x000fe200078e00ffULL, 0x0000002c2d047209ULL, 0x000fe40007810000ULL,
0x0000001728057209ULL, 0x000fc40007810000ULL, 0x0000002b042d7209ULL, 0x000fe40007810000ULL,
0x0000001605047209ULL, 0x000fe40007810000ULL, 0x0000002a2d287209ULL, 0x000fe40007810000ULL,
0x0000000b04057209ULL, 0x000fe40007810000ULL, 0x0000002928287209ULL, 0x000fe40007810000ULL,
0x0000000a05047209ULL, 0x000fc40007810000ULL, 0x0000002728057209ULL, 0x000fe40007810000ULL,
0x00000009042d7209ULL, 0x000fe40007810000ULL, 0x0000002605047209ULL, 0x000fe40007810000ULL,
0x000000082d287209ULL, 0x000fe40007810000ULL, 0x0000002504057209ULL, 0x000fe40007810000ULL,
0x00000013282d7209ULL, 0x000fc40007810000ULL, 0x0000002405047209ULL, 0x000fe40007810000ULL,
0x000000122d2d7209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x000000102d047209ULL, 0x000fe40007810000ULL, 0x0000002205287209ULL, 0x000fe40007810000ULL,
0x0000001104047209ULL, 0x000fc40007810000ULL, 0x0000002128057209ULL, 0x000fe40007810000ULL,
0x00000015042d7209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x000000142d287209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fe40007810000ULL,
0x0000000f282d7209ULL, 0x000fc40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e2d287209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d28377209ULL, 0x000fe20007810000ULL, 0x00000ed27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x0000000405387209ULL, 0x008fe20007810000ULL,
0x00000f027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0037047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0007287f89ULL, 0x000f2200000e0000ULL,
0x00000004372e7209ULL, 0x008fc60007810000ULL, 0x0c201f0038047f89ULL, 0x000ee200000e0000ULL,
0x00000005062f7209ULL, 0x004fc60007810000ULL, 0x0c201f002e057f89ULL, 0x000ea200000e0000ULL,
0x0000002807287209ULL, 0x010fc60007810000ULL, 0x0c201f002f367f89ULL, 0x002e6800000e0000ULL,
0x0c201f00282d7f89ULL, 0x00092200000e0000ULL, 0x0000000438047209ULL, 0x008fe40007810000ULL,
0x000000052e057209ULL, 0x004fe40007810000ULL, 0x000000362f067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b042e7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b05377820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082eULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082eULL,
0x0000002c002c7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1f1f7823ULL, 0x000fe2000001082eULL, 0x3fb8aa3b083c7823ULL, 0x102fe20000010837ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010837ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b0d0d7823ULL, 0x000fcc0000010837ULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000392c08723eULL, 0x008fce00000010ffULL, 0x0000001c001c7308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ff00000000800ULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000e700000000800ULL, 0x0000002700367308ULL, 0x000ff00000000800ULL,
0x0000002000277308ULL, 0x0007e20000000800ULL, 0x000000160b0b723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b12167823ULL, 0x000fcc0000010837ULL, 0x0000001e002f7308ULL, 0x0003e20000000800ULL,
0x00000004ff207e24ULL, 0x008fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fc600038e0100ULL, 0x3f8000002020783eULL, 0x000fe400000010ffULL,
0x0000001d002e7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b0a1e7823ULL, 0x002fe20000010837ULL,
0x0000002b2a0a723eULL, 0x000fcc00000010ffULL, 0x0000002100077308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b091d7823ULL, 0x008fe20000010837ULL, 0x0000001c1709723eULL, 0x000fcc00000010ffULL,
0x0000002900297308ULL, 0x000ee20000000800ULL, 0x000000ffff217224ULL, 0x002fce00078e0020ULL,
0x0000001f00387308ULL, 0x000ff00000000800ULL, 0x0000001e003a7308ULL, 0x000ff00000000800ULL,
0x0000001d003b7308ULL, 0x0003700000000800ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x00000020081c723cULL, 0x002fee00000418ffULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x3fb8aa3b10217823ULL, 0x100fe20000010837ULL, 0x000000293610723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b11297823ULL, 0x000fe20000010837ULL, 0x0000003a3b11723eULL, 0x020fc800000010ffULL,
0x0000003c003c7308ULL, 0x000ff00000000800ULL, 0x0000001300137308ULL, 0x000ee20000000800ULL,
0x000000262512723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b15257823ULL, 0x000fcc0000010837ULL,
0x00000021002a7308ULL, 0x0003e20000000800ULL, 0x0000003c1313723eULL, 0x008fe200000010ffULL,
0x000000ffff217224ULL, 0x002fcc00078e0020ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x00000020101c723cULL, 0x000fee000004181cULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x3fb8aa3b14217823ULL, 0x000fce0000010837ULL, 0x0000002200227308ULL, 0x000ef00000000800ULL,
0x0000001600177308ULL, 0x0007620000000800ULL, 0x000000242314723eULL, 0x002fe200000010ffULL,
0x000000ffff237224ULL, 0x000fcc00078e0020ULL, 0x0000002900297308ULL, 0x000fe20000000800ULL,
0x000000220716723eULL, 0x008fe200000010ffULL, 0x000000ffff227224ULL, 0x000fe200078e0020ULL,
0xfffffffc30077812ULL, 0x000fca00078ec0ffULL, 0x0000002500267308ULL, 0x000e620000000800ULL,
0x000000172a15723eULL, 0x020fce00000010ffULL, 0x0000000f002c7308ULL, 0x000fe20000000800ULL,
0x000000292617723eULL, 0x002fce00000010ffULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x00000022143c723cULL, 0x000fee000004181cULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000fff1c7424ULL, 0x000fe200078e00ffULL, 0x0000002f2e1e723eULL, 0x000fcc00000010ffULL,
0x0000000d000d7308ULL, 0x000ee20000000800ULL, 0x000000212c1d723eULL, 0x002fe200000010ffULL,
0x000000ffff217224ULL, 0x000fe200078e0020ULL, 0x000000071c0f7219ULL, 0x000fe400000006ffULL,
0x00000027381c723eULL, 0x000fe400000010ffULL, 0x000000000f2273a1ULL, 0x000e6200000e8000ULL,
0x000000000f0473c4ULL, 0x000f620000004000ULL, 0x000000282d077209ULL, 0x014fe40007810000ULL,
0x0000000e0d1f723eULL, 0x008fce00000010ffULL, 0x000000201c3c723cULL, 0x000fe2000004183cULL,
0x000000050fff7c12ULL, 0x002fda000f804022ULL, 0x000009e204008947ULL, 0x020ff4000b800000ULL,
0x001c1fff3c207589ULL, 0x0002a400000e0000ULL, 0x000000000f0e73a1ULL, 0x000ee200000e8000ULL,
0x000000000f0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000050fff7c12ULL, 0x008fda000f80400eULL, 0x00000a0204008947ULL, 0x010fea000b800000ULL,
0x001c1fff3e217589ULL, 0x00072800000e0000ULL, 0x001c1fff22227589ULL, 0x00066800000e0000ULL,
0x001c1fff00237589ULL, 0x0006a400000e0000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011630ULL,
0x0000000c033d7812ULL, 0x000fc400078ec0ffULL, 0x000000070d0e7812ULL, 0x040fe200078ec0ffULL,
0x000000080d277824ULL, 0x040fe200078e00ffULL, 0x0000000dff257212ULL, 0x000fe200078e33ffULL,
0x000000080d0f7824ULL, 0x04afe200078e00ffULL, 0x0000000330ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080d387824ULL, 0x040fe200078e00ffULL, 0x000000080d0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff827247812ULL, 0x100fe400078ee20eULL, 0x000000010f267812ULL, 0x100fe200078ef60eULL,
0x000000080d277824ULL, 0x000fe200078e00ffULL, 0x000000020f287812ULL, 0x100fe200078ef60eULL,
0x000000080d487824ULL, 0x000fe200078e00ffULL, 0x000000030f2a7812ULL, 0x000fc400078ef60eULL,
0x000000040f2c7812ULL, 0x140fe400078ef60eULL, 0x000000050f2e7812ULL, 0x140fe400078ef60eULL,
0x000000060f367812ULL, 0x000fe200078ef60eULL, 0x000000080d0f7824ULL, 0x040fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe400078ee225ULL, 0x0000000dff257212ULL, 0x000fe400078e33ffULL,
0x000000070d0e7812ULL, 0x000fc400078ec0ffULL, 0x000090001a0d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8273a7812ULL, 0x100fe400078ee20eULL, 0xfffffff848487812ULL, 0x000fe200078ee225ULL,
0x0000001024037824ULL, 0x100fe200078e020dULL, 0x000000010f3c7812ULL, 0x140fe200078ef60eULL,
0x000000102a247824ULL, 0x100fe200078e020dULL, 0x000000020f3e7812ULL, 0x140fe200078ef60eULL,
0x00000010362a7824ULL, 0x000fe200078e020dULL, 0x000000030f407812ULL, 0x100fe200078ef60eULL,
0x000000013d037824ULL, 0x000fe200078e0203ULL, 0x000000040f427812ULL, 0x140fe200078ef60eULL,
0x000000103c2f7824ULL, 0x100fe200078e020dULL, 0x000000050f447812ULL, 0x140fe200078ef60eULL,
0x000000103e367824ULL, 0x100fe200078e020dULL, 0x000000060f467812ULL, 0x000fe200078ef60eULL,
0x00000010260e7824ULL, 0x100fe200078e020dULL, 0x0000000803007388ULL, 0x0003e20000000800ULL,
0x00000010280f7824ULL, 0x000fc400078e020dULL, 0x000000102c267824ULL, 0x100fe400078e020dULL,
0x000000102e287824ULL, 0x100fe400078e020dULL, 0x00000010382c7824ULL, 0x100fe400078e020dULL,
0x000000103a2e7824ULL, 0x100fe400078e020dULL, 0x0000001040377824ULL, 0x100fe400078e020dULL,
0x0000001042387824ULL, 0x000fc400078e020dULL, 0x0000001044397824ULL, 0x100fe400078e020dULL,
0x00000010463a7824ULL, 0x100fe400078e020dULL, 0x00000010483b7824ULL, 0x000fe400078e020dULL,
0x000000013d0d7824ULL, 0x040fe400078e020eULL, 0x000000013d0f7824ULL, 0x040fe400078e020fULL,
0x000000013d257824ULL, 0x040fe200078e0224ULL, 0x0000000a0d007388ULL, 0x0007e20000000800ULL,
0x000000013d277824ULL, 0x000fc400078e0226ULL, 0x000000013d297824ULL, 0x040fe200078e0228ULL,
0x000000100f007388ULL, 0x0007e20000000800ULL, 0x000000013d2b7824ULL, 0x040fe400078e022aULL,
0x000000013d2d7824ULL, 0x040fe200078e022cULL, 0x0000001225007388ULL, 0x0007e20000000800ULL,
0x000000013d2e7824ULL, 0x040fe400078e022eULL, 0x000000013d0e7824ULL, 0x040fe200078e022fULL,
0x0000001427007388ULL, 0x0007e20000000800ULL, 0x000000013d367824ULL, 0x000fc400078e0236ULL,
0x000000013d087824ULL, 0x042fe200078e0237ULL, 0x0000001629007388ULL, 0x0007e20000000800ULL,
0x000000013d387824ULL, 0x040fe400078e0238ULL, 0x000000013d247824ULL, 0x040fe200078e0239ULL,
0x0000001c2b007388ULL, 0x0007e20000000800ULL, 0x000000013d3a7824ULL, 0x040fe400078e023aULL,
0x000000013d267824ULL, 0x000fe200078e023bULL, 0x0000001e2d007388ULL, 0x0007e80000000800ULL,
0x000000092e007388ULL, 0x0007e80000000800ULL, 0x0000000b0e007388ULL, 0x0007e80000000800ULL,
0x0000001136007388ULL, 0x0007e80000000800ULL, 0x0000001308007388ULL, 0x0007e80000000800ULL,
0x0000001538007388ULL, 0x0007e80000000800ULL, 0x0000001724007388ULL, 0x0007e80000000800ULL,
0x0000001d3a007388ULL, 0x0007e80000000800ULL, 0x0000001f26007388ULL, 0x0007e80000000800ULL,
0x00f000040c008388ULL, 0x0007e80000000c00ULL, 0x00f200200c008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030019197a10ULL, 0x000fe20007ffe0ffULL,
0x00f6080032ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff35ff7812ULL, 0x000fc4000780c0ffULL,
0x000000021900720cULL, 0x000fe40003f26070ULL, 0x00000001ff357807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffc2a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fe200078e002fULL,
0x00012ee000367802ULL, 0x000fe20000000f00ULL, 0x0000001fff3b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x0000069000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e0038ULL, 0xffff9f3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x002fe200078e002eULL, 0x00012f5000367802ULL, 0x000fe20000000f00ULL,
0x0000001fff3b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0038ULL,
0xffff9ee000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0005ULL,
0x00012fb0002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002dULL,
0xfffff0e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0037ULL,
0x00013010002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x002fc400078e00ffULL,
0x0000052000007944ULL, 0x004fea0003c00000ULL, 0x0000002d373a7209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0006ULL, 0x00013060002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x002fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0007ULL,
0x000130b0002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x002fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x0000002d07287209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0038ULL, 0x00013100002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x002fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x0000002d38047209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e003aULL,
0x00013150002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x002fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000002d3a057209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0006ULL, 0x000131a0002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x002fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0028ULL,
0x000131f0002e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x002fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffefa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff397224ULL, 0x000fe200078e003cULL, 0x0001326000367802ULL, 0x000fe20000000f00ULL,
0x000000ffff3a7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe400078e000fULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff207224ULL, 0x004fe200078e0038ULL, 0xfffff5b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff397224ULL, 0x002fe200078e003eULL, 0x000132e000367802ULL, 0x000fe20000000f00ULL,
0x000000ffff3a7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe400078e000fULL, 0x0000029000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff3a7224ULL, 0x002fe200078e00ffULL, 0x0001334000367802ULL, 0x000fe20000000f00ULL,
0x00001c1fff3b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fe400078e000fULL,
0x000000ffff217224ULL, 0x004fe400078e0038ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x002fe200078e000fULL, 0x000133a000367802ULL, 0x000fe20000000f00ULL,
0x000000ffff3a7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff3b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e0038ULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e0038ULL, 0xfffff4f000007947ULL, 0x000fea000383ffffULL,
0x0180000005037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003087812ULL, 0x000fc800078ec0ffULL, 0x018000000800780cULL, 0x000fda0003f05070ULL,
0x0000000500038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0800720cULL, 0x040fe40003f25070ULL, 0x008000000800780cULL, 0x000fe40003f02070ULL,
0x00000001ff087807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000308ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005057812ULL, 0x002fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000308ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffecad00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0c0000362d2d7389ULL, 0x0002a200000e003bULL,
0xfffeca902e007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff377424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0000003a39387389ULL, 0x0002a200000e003bULL,
0xfffeca5036007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000000f680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001f0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000788ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000800ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eacULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ed0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ee0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f70ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f78ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f88ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000013680ULL, 0x9f00001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014810ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014c90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f70ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013890ULL, 0x0000000000013890ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014c90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_16_m_16_sm_89_cubin_len = 85360;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
