/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b0b0ULL, 0x000000000001ad30ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL,
0x2400000000000000ULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000b00010000020cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000299ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000b000100000383ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b0001000003d1ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00220000042cULL, 0x00000000000196a0ULL,
0x0000000000000260ULL, 0x00040003000004a2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000019900ULL, 0x000d0003000004d2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000196a000000000ULL,
0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL,
0x0000006000000000ULL, 0x000196a000000000ULL, 0x0000026000000000ULL, 0x0000580400000000ULL,
0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000baULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000a00000000ULL, 0x000c17040021f000ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000002d000dc2804ULL, 0x000009f000000370ULL, 0x00002dc000002d50ULL, 0x00002fd000002ea0ULL,
0x0000324000003100ULL, 0x000037b0000037a0ULL, 0x000037d0000037c0ULL, 0x00005d7000005d00ULL,
0x00005f9000005e60ULL, 0x00006200000060c0ULL, 0x000066d0000066c0ULL, 0x000066f0000066e0ULL,
0x00008d1000008ca0ULL, 0x00008f3000008e00ULL, 0x000091a000009060ULL, 0x0000968000009670ULL,
0x000096a000009690ULL, 0x0000bb200000bab0ULL, 0x0000bd400000bc10ULL, 0x0000bfb00000be70ULL,
0x0000c4b00000c4a0ULL, 0x0000c4d00000c4c0ULL, 0x0000df500000df40ULL, 0x0000df700000df60ULL,
0x00017ea000017df0ULL, 0x0001828000018180ULL, 0x0001876000018660ULL, 0x00018ae0000189e0ULL,
0x0000053004303904ULL, 0x0001a600000000ffULL, 0x0000061000040100ULL, 0x0001a60800000009ULL,
0x00000720003f0100ULL, 0x0001a68800000009ULL, 0x00000860003f0100ULL, 0x0001a6a800000000ULL,
0x00000960003f0100ULL, 0x0001a6c800000004ULL, 0x000013d0003f0100ULL, 0x0001a60000000008ULL,
0x00001530003f0107ULL, 0x0001a68800000002ULL, 0x00001e40003f0101ULL, 0x00000000000000ffULL,
0x00001ec000040107ULL, 0x00000000000000ffULL, 0x00001f4000040101ULL, 0x0000002000000002ULL,
0x00002060003f0101ULL, 0x0001a6c800000041ULL, 0x000021e0003f0109ULL, 0x0001a6c800000041ULL,
0x00002a40003f0109ULL, 0x0001a6b000000042ULL, 0x00002aa0003f0107ULL, 0x0001a6b000000042ULL,
0x00002ab0003f0101ULL, 0x0001a60800000040ULL, 0x00002af0003f0101ULL, 0x0001a60800000071ULL,
0x00002c60003f0109ULL, 0x0001a60800000071ULL, 0x000033d0003f0109ULL, 0x0001a6a800000042ULL,
0x00003560003f0109ULL, 0x0001a6a800000042ULL, 0x000050f0003f0109ULL, 0x0001a6c80000003cULL,
0x00005120003f0101ULL, 0x0001a6880000003eULL, 0x00005170003f0101ULL, 0x0000000000000006ULL,
0x000052e0003f0109ULL, 0x0000000000000006ULL, 0x00005a30003f0109ULL, 0x00000000000000ffULL,
0x00005a7000050107ULL, 0x00000000000000ffULL, 0x00005a8000050101ULL, 0x0001a62800000071ULL,
0x00005ae0003f0101ULL, 0x0001a62800000041ULL, 0x00005c50003f0109ULL, 0x0001a62800000041ULL,
0x000063c0003f0109ULL, 0x0001a6b00000003fULL, 0x00006530003f0109ULL, 0x0001a6b00000003fULL,
0x00008040003f0109ULL, 0x0001a6c80000003cULL, 0x00008060003f0101ULL, 0x0001a6900000003eULL,
0x000080c0003f0101ULL, 0x0000000000000006ULL, 0x00008230003f0109ULL, 0x0000000000000006ULL,
0x000089b0003f0109ULL, 0x00000008000000ffULL, 0x00008a1000040107ULL, 0x0000000800000084ULL,
0x00008a20003f0101ULL, 0x0001a64800000071ULL, 0x00008a90003f0101ULL, 0x0001a64800000041ULL,
0x00008c00003f0109ULL, 0x0001a64800000041ULL, 0x00009360003f0109ULL, 0x00000000000000ffULL,
0x000094d000050109ULL, 0x00000000000000ffULL, 0x0000aea000050109ULL, 0x0001a6c80000003cULL,
0x0000aec0003f0101ULL, 0x0001a69800000071ULL, 0x0000af20003f0101ULL, 0x0000000000000006ULL,
0x0000b090003f0109ULL, 0x0000000000000006ULL, 0x0000b830003f0109ULL, 0x00000000000000ffULL,
0x0000b87000040107ULL, 0x00000000000000ffULL, 0x0000b88000050101ULL, 0x0001a66800000007ULL,
0x0000b8a0003f0101ULL, 0x0001a66800000007ULL, 0x0000ba10003f0109ULL, 0x0001a66800000007ULL,
0x0000c160003f0109ULL, 0x0001a6b00000003fULL, 0x0000c2d0003f0109ULL, 0x0001a6b00000003fULL,
0x0000dd50003f0109ULL, 0x0000000000000006ULL, 0x0000dd90003f0101ULL, 0x0001a6a000000006ULL,
0x0000ff80003f0101ULL, 0x0001a60000000008ULL, 0x000117c0003f0101ULL, 0x0001a60000000008ULL,
0x00011980003f0109ULL, 0x0001a60000000008ULL, 0x00011ce0003f0109ULL, 0x0001a60000000008ULL,
0x00011d00003f0101ULL, 0x0001a60000000008ULL, 0x00011e70003f0109ULL, 0x0001a60000000008ULL,
0x00015410003f0109ULL, 0x0001a6880000006cULL, 0x00015810003f0101ULL, 0x0001a6880000006cULL,
0x00015980003f0109ULL, 0x0001a6880000006cULL, 0x00019640003f0109ULL, 0x0001a60800000062ULL,
0x00019650003f0101ULL, 0x0001a61000000062ULL, 0x00019660003f0101ULL, 0x0001a61800000062ULL,
0x00019670003f0101ULL, 0x0001a62000000062ULL, 0x00053803003f0101ULL, 0x0000ee8000301c04ULL,
0x0000f1700000eeb0ULL, 0x0000f5500000f360ULL, 0x0000f9300000f740ULL, 0x0000fd200000fb20ULL,
0x00011ea00000fed0ULL, 0x000c050400019690ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0060190300000000ULL, 0x0000001600080a04ULL, 0x0000000000600210ULL, 0x00000000000000bcULL,
0x0000001500000002ULL, 0x00000000000196a0ULL, 0x0000000000000044ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL, 0x0000000000000000ULL,
0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000077919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff0c7b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff042b82ULL, 0x000ea20000000a00ULL,
0x0000000107092836ULL, 0x008fe40000000000ULL, 0x0000000407022825ULL, 0x004fc800078e0004ULL,
0x0000000409042825ULL, 0x000fe400078e0004ULL, 0x0000000602022981ULL, 0x0004e8000c1e1900ULL,
0x00000006040b2981ULL, 0x000ae2000c1e1900ULL, 0x0000000c00007306ULL, 0x010f220000209000ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x000000ff0c00720cULL, 0x000fe20003f65070ULL,
0x0000000000067919ULL, 0x000ea20000002300ULL, 0x0000010000057ab9ULL, 0x000fe20000000800ULL,
0x0000045000007945ULL, 0x000fe20003800000ULL, 0x0000000000777919ULL, 0x000ea40000002100ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00087836ULL, 0x010fcc0000000000ULL,
0x0000000800097305ULL, 0x0008a4000021f000ULL, 0x000000ffff087224ULL, 0x010fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x006fc800078e0a09ULL, 0x0000000c0d0d7224ULL, 0x000fc800078e02ffULL,
0x0000000d09097227ULL, 0x000fe400078e0008ULL, 0x00000000000d7919ULL, 0x000e680000002200ULL,
0x0000000409097c27ULL, 0x000fc8000f8e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a09ULL,
0x000000040c037e24ULL, 0x000fe2000f8e0203ULL, 0x00000000000479c3ULL, 0x000ea80000002600ULL,
0x0000000c0300720cULL, 0x000fda0003f06070ULL, 0x0000000103030824ULL, 0x000fe400078e0a0cULL,
0x0000000109090836ULL, 0x000fc60000000000ULL, 0x0000000c0300720cULL, 0x000fda0003f26070ULL,
0x0000000109091836ULL, 0x000fe20000000000ULL, 0x0000000cff09b212ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000f220000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x010f640000001000ULL, 0x0ffffffe00047836ULL, 0x020fe40000000000ULL,
0x0000000506007c24ULL, 0x002fe2000f8e020dULL, 0x0000000000057ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x000322000021f000ULL, 0x00001fff06067589ULL, 0x000f6200000e0000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x0000000509037224ULL, 0x010fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000305057227ULL, 0x000fc800078e0004ULL,
0x0000000500047c24ULL, 0x100fe2000f8e0277ULL, 0x00000005ff777819ULL, 0x000fe20000011677ULL,
0x0000000405797c27ULL, 0x004fc6000f8e00ffULL, 0x0000007f0400780cULL, 0x040fe20003fa4070ULL,
0x000000ffff087224ULL, 0x000fe200078e0a79ULL, 0x00001fff77777589ULL, 0x000f6200000e0000ULL,
0x000000030400780cULL, 0x000fe40003f84070ULL, 0x0000000409007e24ULL, 0x000fe4000f8e0208ULL,
0x00008400ff08ab82ULL, 0x000f660000000800ULL, 0x000000090000720cULL, 0x000fc60003f06070ULL,
0x000000000005d919ULL, 0x000e740000008800ULL, 0x0000000100000824ULL, 0x000fc400078e0a09ULL,
0x0000000179790836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000090000720cULL, 0x000fe40003f26070ULL, 0x000004000000d802ULL, 0x000fd60000000f00ULL,
0x0000000179791836ULL, 0x000fe20000000000ULL, 0x00000009ff79b212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000010400780cULL, 0x000fe20003f64070ULL,
0x000000ffff727224ULL, 0x000fc800078e0a79ULL, 0x0000000409727e24ULL, 0x000fe4000f8e0272ULL,
0x000000010b032824ULL, 0x008fe200078e0a02ULL, 0x00000654050bd816ULL, 0x002fe20000000000ULL,
0xff317217ff05d424ULL, 0x000fc800078e00ffULL, 0x00008400ff03ab82ULL, 0x000ee20000000800ULL,
0x000000040400d824ULL, 0x000fe200078e020bULL, 0x0000000000240947ULL, 0x020fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404097c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000090812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404097c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000090812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400050000d388ULL, 0x0003e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x0000002072727824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x002fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6a804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804093f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000803057c24ULL, 0x00afe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff007224ULL, 0x000fe200078e0a72ULL, 0x000000720500720cULL, 0x000fe20003f06070ULL,
0x000000080702a224ULL, 0x000fc400078e02ffULL, 0x000000080c157c24ULL, 0x000fe2000f8e02ffULL,
0x00000020050b7446ULL, 0x000fe20003800000ULL, 0x0000000406007824ULL, 0x000fe400078e0277ULL,
0x00000015020a7224ULL, 0x000fe200078e02ffULL, 0x000000ff0b0b7207ULL, 0x000fe20000000000ULL,
0x0000000400007824ULL, 0x000fe400078e00ffULL, 0x0000000879197c24ULL, 0x000fe2000f8e020aULL,
0x000000200b00780cULL, 0x000fda0003f05270ULL, 0x00000004002c8947ULL, 0x000fea0003800000ULL,
0x0000000800087d06ULL, 0x000e620008209000ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00008c0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x00000004ff0d7819ULL, 0x004fca0000011609ULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x000000020d117836ULL, 0x000fe40000000000ULL, 0x0000000100107824ULL, 0x040fe400078e020dULL,
0x0000000100127824ULL, 0x000fc800078e0211ULL, 0x0000000172147824ULL, 0x000fe400078e0212ULL,
0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL, 0x000000080f0f7c24ULL, 0x000fc8000f8e02ffULL,
0x0000000f050f7227ULL, 0x000fc800078e0004ULL, 0x0000000172047824ULL, 0x000fc800078e0210ULL,
0x000000040f057227ULL, 0x000fc800078e00ffULL, 0x000000140f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e0a05ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0fULL,
0x0000000813087c24ULL, 0x000fe4000f8e0204ULL, 0x00000008170e7c24ULL, 0x000fe4000f8e0214ULL,
0x0000000000177919ULL, 0x000e620000008800ULL, 0x0000000808007c0cULL, 0x000fe4000bf06070ULL,
0x000000080e007c0cULL, 0x000fd6000bf46070ULL, 0x8000000808080c36ULL, 0x000fe40008000000ULL,
0x800000080e0e2c36ULL, 0x000fe40008000000ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x0000000808007c0cULL, 0x000fe2000bf26070ULL, 0x000000010f0f2836ULL, 0x000fe20000000000ULL,
0x000000080e007c0cULL, 0x000fe4000bf66070ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x00000008ff087c12ULL, 0x000fce000f8e33ffULL, 0x0000000105051836ULL, 0x000fe40000000000ULL,
0x000000010f0f3836ULL, 0x000fc60000000000ULL, 0x00000005080e7207ULL, 0x040fe40004000000ULL,
0x0000000f08137207ULL, 0x000fe40004000000ULL, 0x0000040000087802ULL, 0x000fe20000000f00ULL,
0x000000ffff057224ULL, 0x000fe400078e0a0eULL, 0x000000ffff0f7224ULL, 0x000fe200078e0a13ULL,
0x0000065417087816ULL, 0x002fe20000000008ULL, 0x0000000805047c24ULL, 0x000fe2000f8e0204ULL,
0x000000000b057248ULL, 0x000fe20007fe0000ULL, 0x000000080f147c24ULL, 0x000fc4000f8e0214ULL,
0x00000001190f7824ULL, 0x040fe400078e0204ULL, 0x0000000119147824ULL, 0x000fe400078e0214ULL,
0x0000000105057824ULL, 0x000fe400078e0a00ULL, 0x000000150e047224ULL, 0x000fe400078e020fULL,
0x0000001009007824ULL, 0x000fe200078e00ffULL, 0x000000050d00720cULL, 0x000fe20003f06070ULL,
0x00000015130e7224ULL, 0x000fe200078e0214ULL, 0x000000051100720cULL, 0x000fe20003f26070ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000f0000d7812ULL, 0x000fc600078ec0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000d04047212ULL, 0x000fc600078efcffULL,
0x0000000110117824ULL, 0x100fe200078e0209ULL, 0x0000000d0e0d7212ULL, 0x000fe200078efcffULL,
0x0000001010147824ULL, 0x000fe200078e00ffULL, 0x0000000404047c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000112107824ULL, 0x040fe200078e0209ULL, 0x000000040d0e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001012137824ULL, 0x000fe200078e00ffULL, 0xfffffff014117812ULL, 0x000fe400078ee211ULL,
0x0000000505057c10ULL, 0x000fe400097fe4ffULL, 0xfffffff0130d7812ULL, 0x000fe200078ee210ULL,
0x0000001011117824ULL, 0x000fe200078e0208ULL, 0x000000050f0f7c10ULL, 0x000fc60009ffe4ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004117faeULL, 0x0003e8000c101c46ULL, 0x000000000e0d7faeULL, 0x0003e2000c901c46ULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x0000000800087d06ULL, 0x000e620008209000ULL,
0x0000000000097919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00008c0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000137919ULL, 0x000ee80000008800ULL,
0x0000000800087308ULL, 0x002e640000001000ULL, 0x0ffffffe08057836ULL, 0x002fe20000000000ULL,
0x00000000090d7211ULL, 0x004fca00078fe0ffULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x000000020d117836ULL, 0x000fe40000000000ULL, 0x0000000172007824ULL, 0x040fe400078e020dULL,
0x0000000172087824ULL, 0x000fe400078e0211ULL, 0x000000010d107824ULL, 0x140fe400078e0209ULL,
0x000000100d0d7824ULL, 0x000fe400078e00ffULL, 0x0000000111127824ULL, 0x000fc400078e0209ULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fe200078ee210ULL,
0x000000ffff0f7224ULL, 0x002fc600078e0a05ULL, 0xfffffff011117812ULL, 0x000fe200078ee212ULL,
0x000000080f0f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f050f7227ULL, 0x000fcc00078e0004ULL,
0x000000000f047227ULL, 0x000fc800078e00ffULL, 0x000000080f0e7227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0eULL,
0x0000000805057c24ULL, 0x000fe4000f8e0200ULL, 0x000000080f0f7c24ULL, 0x000fc6000f8e0208ULL,
0x0000000805007c0cULL, 0x000fe4000bf06070ULL, 0x000000080f007c0cULL, 0x000fd6000bf46070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x800000080f0f2c36ULL, 0x000fe40008000000ULL,
0x0000000104040836ULL, 0x000fe20000000000ULL, 0x0000000805007c0cULL, 0x000fe2000bf26070ULL,
0x000000010e0e2836ULL, 0x000fe20000000000ULL, 0x000000080f007c0cULL, 0x000fe4000bf66070ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x00000008ff057c12ULL, 0x000fce000f8e33ffULL,
0x0000000104041836ULL, 0x000fe40000000000ULL, 0x000000010e0e3836ULL, 0x000fc60000000000ULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000e050e7207ULL, 0x000fc60004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0eULL,
0x0000000805007c24ULL, 0x000fe4000f8e0200ULL, 0x000000080f087c24ULL, 0x000fe4000f8e0208ULL,
0x0000000119057824ULL, 0x040fe400078e0200ULL, 0x00000001190f7824ULL, 0x000fe200078e0208ULL,
0x0000040000087802ULL, 0x000fe20000000f00ULL, 0x0000001009007824ULL, 0x000fc400078e00ffULL,
0x0000001504057224ULL, 0x080fe200078e0205ULL, 0x0000065413087816ULL, 0x008fe20000000008ULL,
0x000000150e0f7224ULL, 0x000fe200078e020fULL, 0x000000f000137812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x000001000f0e7825ULL, 0x000fe200078e00ffULL,
0x0000001304047212ULL, 0x000fc600078efcffULL, 0x000000100d0d7824ULL, 0x100fe200078e0208ULL,
0x000000130e0e7212ULL, 0x000fe200078efcffULL, 0x0000001011117824ULL, 0x000fe200078e0208ULL,
0x0000000404047c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040e0e7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000505057c10ULL, 0x000fe400087fe4ffULL, 0x000000050f0f7c10ULL, 0x000fc60008ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000b901c46ULL,
0x000000000e117faeULL, 0x0003e4000b901c46ULL, 0x00000000080472caULL, 0x000fe200000e0000ULL,
0x00009200ff6e7b82ULL, 0x000ea20000000a00ULL, 0x0000000000007918ULL, 0x002fd60000000000ULL,
0x0001a60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x00000004076e7825ULL, 0x004fe200078e006eULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x000000066e6e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x000000ff6e0d7836ULL, 0x004fca0000000000ULL,
0x00000008ff607819ULL, 0x000fce000001160dULL, 0x000000e800988947ULL, 0x000fea0003800000ULL,
0x0000000207077824ULL, 0x000fe200078e00ffULL, 0x000001ff0d00780cULL, 0x000fe20003f04070ULL,
0x00000008776f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff617819ULL, 0x000fe20000011677ULL,
0x0000000c075a7224ULL, 0x000fe200078e020cULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x0000000177737812ULL, 0x000fe200078ec0ffULL,
0x0000000108027824ULL, 0x000fe400078e026fULL, 0x00000020615b7824ULL, 0x000fc400078e00ffULL,
0x00000001795a7824ULL, 0x000fe200078e025aULL, 0x01a6880302ff79a7ULL, 0x0003e6000850003fULL,
0x000000045a047c24ULL, 0x000fe2000f8e025bULL, 0x0000000400000947ULL, 0x000fec0003800000ULL,
0x0000005b6e027248ULL, 0x002fe20007fe0000ULL, 0x0000001073037824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe20000011609ULL, 0x0000900000047ab9ULL, 0x000fe40000000a00ULL,
0x0000000102027824ULL, 0x000fe400078e0a5bULL, 0x0000000103067824ULL, 0x000fe400078e0205ULL,
0x00000004050c7836ULL, 0x000fe20000000000ULL, 0x0000000302027248ULL, 0x000fe20007fe0000ULL,
0x0000000106077824ULL, 0x000fc400078e0209ULL, 0x00000008060e7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0a03ULL, 0x0000000c050d7836ULL, 0x000fe20000000000ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x000000020c00720cULL, 0x080fe20003f46070ULL, 0x00000001030c7824ULL, 0x000fe200078e020cULL,
0x000000020500720cULL, 0x080fe20003f66070ULL, 0x0000000104067824ULL, 0x000fe200078e0206ULL,
0x000000020700720cULL, 0x080fe20003f26070ULL, 0x000000010c057824ULL, 0x040fe200078e0209ULL,
0x000000020d00720cULL, 0x000fe20003f06070ULL, 0x000000080c107824ULL, 0x000fc400078e00ffULL,
0x0000000103077824ULL, 0x040fe400078e0207ULL, 0x00000001030f7824ULL, 0x000fe200078e020dULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x0000008006027825ULL, 0x000fc800078e00ffULL,
0x0000000104057824ULL, 0x040fe200078e020cULL, 0x00000070020c7812ULL, 0x000fe200078ef800ULL,
0x0000000104067824ULL, 0x040fe400078e0207ULL, 0x0000000104117824ULL, 0x000fe200078e020fULL,
0x000000040c0c7c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000107047824ULL, 0x040fe400078e0209ULL,
0x00000008070d7824ULL, 0x000fe400078e00ffULL, 0x0000200061027824ULL, 0x000fc400078e0208ULL,
0x000000010f077824ULL, 0x040fe200078e0209ULL, 0xfffffff80d127812ULL, 0x000fe200078ee204ULL,
0x000000080f147824ULL, 0x000fe200078e00ffULL, 0x00000005030d7c10ULL, 0x000fe2000a7fe4ffULL,
0x00016000020f7836ULL, 0x000fe40000000000ULL, 0x0000008005027825ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fc600078ee207ULL, 0x0000008006047825ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc600078ef800ULL, 0x0000008011067825ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fe400078ef800ULL, 0x0000000402027c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100e117824ULL, 0x100fe200078e020fULL, 0x0000007006007812ULL, 0x000fe200078ef800ULL,
0x0000001010137824ULL, 0x100fe200078e020fULL, 0x0000000404047c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001012157824ULL, 0x100fe200078e020fULL, 0x0000000400067c10ULL, 0x000fe2000ffde0ffULL,
0x00000010140f7824ULL, 0x000fe200078e020fULL, 0x0000000503037c10ULL, 0x000fe2000a7fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e2000d901c46ULL,
0x0000000505057c10ULL, 0x000fc4000affe4ffULL, 0x0000000507077c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000002137faeULL, 0x0003e8000d101c46ULL, 0x0000000004157faeULL, 0x0003e8000c901c46ULL,
0x00000000060f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000001073027824ULL, 0x002fe200078e00ffULL, 0x0000900000047ab9ULL, 0x000fc80000000a00ULL,
0x0000000209027211ULL, 0x000fca00078fe8ffULL, 0x0000000402057836ULL, 0x000fe40000000000ULL,
0x0000000102037824ULL, 0x140fe400078e0209ULL, 0x00000008020e7824ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x040fe400078e0209ULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000000104037824ULL, 0x000fc400078e0202ULL,
0x0000000c020c7836ULL, 0x000fe20000000000ULL, 0xfffffff807107812ULL, 0x000fe200078ee206ULL,
0x0000000802067836ULL, 0x000fe40000000000ULL, 0x0000008003027825ULL, 0x000fc800078e00ffULL,
0x0000000104057824ULL, 0x040fe200078e0205ULL, 0x00000070020d7812ULL, 0x000fe200078ef800ULL,
0x0000000104077824ULL, 0x040fe400078e0206ULL, 0x00000001040f7824ULL, 0x000fe400078e020cULL,
0x000000010c027824ULL, 0x140fe400078e0209ULL, 0x000000080c137824ULL, 0x000fe200078e00ffULL,
0x000000040d0c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000106047824ULL, 0x000fc400078e0209ULL,
0x0000000806117824ULL, 0x000fe200078e00ffULL, 0xfffffff813147812ULL, 0x000fe200078ee202ULL,
0x0000200061067824ULL, 0x000fe200078e0208ULL, 0x00000005030d7c10ULL, 0x000fe200087fe4ffULL,
0x0000008005027825ULL, 0x000fe200078e00ffULL, 0xfffffff811127812ULL, 0x000fc600078ee204ULL,
0x0001600006157836ULL, 0x000fe20000000000ULL, 0x0000007002027812ULL, 0x000fe200078ef800ULL,
0x0000008007047825ULL, 0x000fc600078e00ffULL, 0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL,
0x000000800f067825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fe400078ef800ULL,
0x0000000503037c10ULL, 0x000fe200087fe4ffULL, 0x000000100e0f7824ULL, 0x100fe200078e0215ULL,
0x0000007006007812ULL, 0x000fe200078ef800ULL, 0x0000001010117824ULL, 0x100fe200078e0215ULL,
0x0000000404047c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0215ULL,
0x0000000400067c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001014157824ULL, 0x000fe200078e0215ULL,
0x0000000505057c10ULL, 0x000fe20008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000b901c46ULL, 0x0000000507077c10ULL, 0x000fc600097fe4ffULL,
0x0000000002117faeULL, 0x0003e8000b901c46ULL, 0x0000000004137faeULL, 0x0003e8000b901c46ULL,
0x0000000006157faeULL, 0x0003e4000b901c46ULL, 0x0001a6a808007836ULL, 0x000fe20000000000ULL,
0x00000000610472caULL, 0x000fe200000e0000ULL, 0x00000001ff037424ULL, 0x002fe200078e00ffULL,
0x000000ff6000720cULL, 0x000fe20003f05270ULL, 0x000000ffff7d7224ULL, 0x000fe200078e00ffULL,
0x00000000000572caULL, 0x000fe400000e0000ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000ffff317224ULL, 0x000fe400078e00ffULL,
0x0000000861027824ULL, 0x000fe200078e0200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000003ff8079a7ULL, 0x0002a20008500004ULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00002003020279a7ULL, 0x002e62000850003fULL, 0x0000000000567805ULL, 0x000fc4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x000000bc00948947ULL, 0x000fec0003800000ULL,
0x00000002ff597819ULL, 0x000fe20000011677ULL, 0x000000ffff407224ULL, 0x002fe200078e0003ULL,
0x0000000161007812ULL, 0x000fe200078ec0ffULL, 0xff317217ff7c7424ULL, 0x000fe200078e00ffULL,
0x000000086f077812ULL, 0x000fe200078ec0ffULL, 0x0000002059057824ULL, 0x000fe400078e0208ULL,
0x000000ffff587224ULL, 0x000fe400078e00ffULL, 0x0000001000007824ULL, 0x000fe400078e0205ULL,
0x000000ffff377224ULL, 0x000fc400078e00ffULL, 0x0000000107077824ULL, 0x000fce00078e0200ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000000477067824ULL, 0x000fca00078e00ffULL,
0xfffffff8063f7812ULL, 0x000fca00078ec0ffULL, 0x0000000108417824ULL, 0x000fc800078e023fULL,
0x01a6c840410075a7ULL, 0x000e62000800017fULL, 0x0001a6c841067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff427224ULL, 0x000fce00078e00ffULL,
0x000000104200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000142427836ULL, 0x000fce0000000000ULL,
0x01a6c840410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000001583d7836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x0000010058707824ULL, 0x000fc600078e025bULL, 0x000000603d00720cULL, 0x000fe20003f26070ULL,
0x00000040703d7836ULL, 0x000fc80000000000ULL, 0x000000055a427c24ULL, 0x000fd0000f8e023dULL,
0x0000000400089947ULL, 0x000fea0003800000ULL, 0x0000003d6e3c7248ULL, 0x000fe20007fe0000ULL,
0x00000010733f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff3e7819ULL, 0x000fe20000011609ULL,
0x0000900000087ab9ULL, 0x000fe40000000a00ULL, 0x000000013c3c7824ULL, 0x000fe400078e0a3dULL,
0x000000013f3d7824ULL, 0x000fe400078e023eULL, 0x000000043e417836ULL, 0x000fe20000000000ULL,
0x0000003c3f3c7248ULL, 0x000fe20007fe0000ULL, 0x000000013d407824ULL, 0x000fc400078e0209ULL,
0x000000083d477824ULL, 0x000fe400078e00ffULL, 0x000000013c3c7824ULL, 0x000fe400078e0a3fULL,
0x000000013f437824ULL, 0x000fe200078e0241ULL, 0xfffffff847477812ULL, 0x000fe200078ee240ULL,
0x000000083e407836ULL, 0x000fe20000000000ULL, 0x0000003c3e00720cULL, 0x080fe20003f86070ULL,
0x0000000c3e447836ULL, 0x000fe20000000000ULL, 0x0000003c4100720cULL, 0x080fe20003f66070ULL,
0x00000001433e7824ULL, 0x040fe200078e0209ULL, 0x0000003c4000720cULL, 0x080fe20003f46070ULL,
0x00000008435d7824ULL, 0x000fe200078e00ffULL, 0x0000003c4400720cULL, 0x000fe20003f06070ULL,
0x000000013f417824ULL, 0x000fc400078e0240ULL, 0x000000013f457824ULL, 0x000fe200078e0244ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee23eULL, 0x00000010093f7824ULL, 0x000fe400078e00ffULL,
0x000000013d3c7824ULL, 0x100fe400078e0242ULL, 0x00000001433e7824ULL, 0x100fe400078e0242ULL,
0x0000000141407824ULL, 0x040fe400078e0242ULL, 0x0000000141437824ULL, 0x000fc400078e0209ULL,
0x0000000841447824ULL, 0x000fe400078e00ffULL, 0x0000000145427824ULL, 0x040fe400078e0242ULL,
0x0000000145417824ULL, 0x040fe200078e0209ULL, 0xfffffff8445f7812ULL, 0x000fe200078ee243ULL,
0x0000000845467824ULL, 0x000fe200078e00ffULL, 0x000000703f457812ULL, 0x000fe200078ec0ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff846637812ULL, 0x000fe200078ee241ULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000453c3c7212ULL, 0x000fc600078efcffULL,
0x0000008040407825ULL, 0x000fe200078e00ffULL, 0x000000453e3e7212ULL, 0x080fe400078efcffULL,
0x000000083c3c7c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0x000000083e3e7c10ULL, 0x000fe4000ffde0ffULL, 0x0000004540407212ULL, 0x080fe200078efcffULL,
0x0000200061447824ULL, 0x000fe200078e0208ULL, 0x0000004542427212ULL, 0x000fe400078efcffULL,
0x000000093d3d7c10ULL, 0x000fe2000affe4ffULL, 0x0001700044447836ULL, 0x000fe20000000000ULL,
0x000000093f3f7c10ULL, 0x000fc4000b7fe4ffULL, 0x0000000840407c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001047457824ULL, 0x100fe200078e0244ULL, 0x0000000842427c10ULL, 0x000fe2000ffde0ffULL,
0x000000105d477824ULL, 0x100fe200078e0244ULL, 0x0000000941417c10ULL, 0x000fe2000affe4ffULL,
0x000000105f5d7824ULL, 0x100fe200078e0244ULL, 0x0000000943437c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010635f7824ULL, 0x000fe200078e0244ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000e101c46ULL, 0x000000003e477faeULL, 0x0003e8000d901c46ULL,
0x00000000405d7faeULL, 0x0003e8000d101c46ULL, 0x00000000425f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x00000010733c7824ULL, 0x000fe200078e00ffULL,
0x0000900000087ab9ULL, 0x000fe20000000a00ULL, 0x00000010093e7824ULL, 0x000fc600078e00ffULL,
0x0000003c093d7211ULL, 0x000fe400078fe8ffULL, 0x000000703e5d7812ULL, 0x000fc600078ec0ffULL,
0x000000043d3f7836ULL, 0x000fe40000000000ULL, 0x000000013d3c7824ULL, 0x140fe400078e0209ULL,
0x000000083d457824ULL, 0x000fe400078e00ffULL, 0x000000013f407824ULL, 0x040fe400078e0209ULL,
0x000000083f477824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee23cULL,
0x000000083d417836ULL, 0x000fc40000000000ULL, 0x0000000c3d447836ULL, 0x000fe20000000000ULL,
0xfffffff847477812ULL, 0x000fe200078ee240ULL, 0x000000013d3c7824ULL, 0x100fe400078e0242ULL,
0x000000013f3e7824ULL, 0x100fe400078e0242ULL, 0x0000000141407824ULL, 0x040fe400078e0242ULL,
0x0000000141437824ULL, 0x040fe400078e0209ULL, 0x0000000841467824ULL, 0x000fc400078e00ffULL,
0x0000000144427824ULL, 0x040fe400078e0242ULL, 0x0000000144417824ULL, 0x040fe200078e0209ULL,
0xfffffff8465f7812ULL, 0x000fe200078ee243ULL, 0x0000000844447824ULL, 0x000fe400078e00ffULL,
0x000000803c3c7825ULL, 0x000fc600078e00ffULL, 0xfffffff844637812ULL, 0x000fe200078ee241ULL,
0x00002000613f7824ULL, 0x000fe200078e0208ULL, 0x0000005d3c3c7212ULL, 0x000fe200078efcffULL,
0x0000008040407825ULL, 0x000fc600078e00ffULL, 0x000000083c3c7c10ULL, 0x000fe2000ff1e0ffULL,
0x000170003f447836ULL, 0x000fe20000000000ULL, 0x0000005d40407212ULL, 0x080fe200078efcffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000000093d3d7c10ULL, 0x000fe400087fe4ffULL,
0x0000000840407c10ULL, 0x000fe2000ff5e0ffULL, 0x0000008042427825ULL, 0x000fe200078e00ffULL,
0x0000005d3e3e7212ULL, 0x080fe400078efcffULL, 0x0000000941417c10ULL, 0x000fe200097fe4ffULL,
0x0000001045457824ULL, 0x100fe200078e0244ULL, 0x0000005d42427212ULL, 0x000fe200078efcffULL,
0x0000001047477824ULL, 0x100fe200078e0244ULL, 0x000000083e3e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000105f5d7824ULL, 0x100fe200078e0244ULL, 0x0000000842427c10ULL, 0x000fe2000ff7e0ffULL,
0x00000010635f7824ULL, 0x000fe200078e0244ULL, 0x000000093f3f7c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e2000b901c46ULL,
0x0000000943437c10ULL, 0x000fc60009ffe4ffULL, 0x000000003e477faeULL, 0x0003e8000b901c46ULL,
0x00000000405d7faeULL, 0x0003e8000b901c46ULL, 0x00000000425f7faeULL, 0x0003e4000b901c46ULL,
0xfffffff06f3d7812ULL, 0x042fe200078ec0ffULL, 0x00000001ff417424ULL, 0x000fe200078e00ffULL,
0x000000106f3c7812ULL, 0x000fc600078ec0ffULL, 0x0000000108427824ULL, 0x000fe200078e023dULL,
0xffffffe06f3d7812ULL, 0x000fc800078ec0ffULL, 0x00000000420572caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000083c3e7210ULL, 0x000fca0007ffe03dULL,
0x0000000873407824ULL, 0x000fcc00078e023eULL, 0x0001a6b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01a6b041428479a7ULL, 0x0002e4000850003fULL, 0x01a60841404079a7ULL, 0x002e64000850003fULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x000000086f717812ULL, 0x000fca00078ec0ffULL,
0x000000013e717824ULL, 0x000fc800078e0271ULL, 0x01a60841710075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fce0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a60841710075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000010096d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff747819ULL, 0x000fe20000011609ULL,
0x00000020773c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff407424ULL, 0x000fe200078e00ffULL,
0x000000706d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff7a7224ULL, 0x000fe200078e007cULL,
0xffffff803c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c74747812ULL, 0x000fe400078ec0ffULL,
0x000000086d3d7210ULL, 0x000fca0007ffe03cULL, 0x000000013d3d7824ULL, 0x000fca00078e0274ULL,
0x01a000003d3f7984ULL, 0x000e680000000800ULL, 0x01a200003d3c7984ULL, 0x0009220000000800ULL,
0x0000007c3f00720bULL, 0x002fda0003f1d000ULL, 0x00000000003e7806ULL, 0x000fc800000e0100ULL,
0x000000ff3e00720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x01cfea0003800000ULL,
0x000000775900720cULL, 0x000fe40003f45270ULL, 0x0000007c3f00720bULL, 0x0c0fe40003f14000ULL,
0x0000007c3f7a7209ULL, 0x000fd20007810000ULL, 0x00000080773da824ULL, 0x000fe400078e0208ULL,
0x0000000000417806ULL, 0x000fc600000e0100ULL, 0x0000003d743da210ULL, 0x000fe40007ffe06dULL,
0x000000ff4100720cULL, 0x000fc60003f05270ULL, 0x01a4007a3d00a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007c7a3d7221ULL, 0x000fe20000010100ULL,
0x000000ff41ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0041ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b3d3d7820ULL, 0x000fe20000410000ULL, 0x00ff000041ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000041ff7812ULL, 0x000fe2000788c0ffULL, 0x0000003d00447308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff3d7819ULL, 0x002fcc0000011609ULL,
0x00001f3d443d7589ULL, 0x004e6400000e0000ULL, 0x0000003d54547220ULL, 0x082fe20000410000ULL,
0x0000003d55557220ULL, 0x080fe20000410000ULL, 0x0000003d48487220ULL, 0x080fe20000410000ULL,
0x0000003d49497220ULL, 0x080fe20000410000ULL, 0x0000003d4c4c7220ULL, 0x080fe20000410000ULL,
0x0000003d4d4d7220ULL, 0x080fe20000410000ULL, 0x0000003d50507220ULL, 0x080fe20000410000ULL,
0x0000003d51517220ULL, 0x080fe20000410000ULL, 0x0000003d30307220ULL, 0x080fe20000410000ULL,
0x0000003d31317220ULL, 0x080fe20000410000ULL, 0x0000003d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003d28287220ULL, 0x080fe20000410000ULL,
0x0000003d29297220ULL, 0x080fe20000410000ULL, 0x0000003d24247220ULL, 0x080fe20000410000ULL,
0x0000003d25257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008093d7811ULL, 0x002fcc00078ff0ffULL, 0x00001f3d443d7589ULL, 0x004e6400000e0000ULL,
0x0000003d56567220ULL, 0x082fe20000410000ULL, 0x0000003d57577220ULL, 0x080fe20000410000ULL,
0x0000003d4a4a7220ULL, 0x080fe20000410000ULL, 0x0000003d4b4b7220ULL, 0x080fe20000410000ULL,
0x0000003d4e4e7220ULL, 0x080fe20000410000ULL, 0x0000003d4f4f7220ULL, 0x080fe20000410000ULL,
0x0000003d52527220ULL, 0x080fe20000410000ULL, 0x0000003d53537220ULL, 0x080fe20000410000ULL,
0x0000003d32327220ULL, 0x080fe20000410000ULL, 0x0000003d33337220ULL, 0x080fe20000410000ULL,
0x0000003d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000003d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003d26267220ULL, 0x080fe20000410000ULL, 0x0000003d27277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010093d7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3d443d7589ULL, 0x004e6400000e0000ULL, 0x0000003d0c0c7220ULL, 0x082fe20000410000ULL,
0x0000003d0d0d7220ULL, 0x080fe20000410000ULL, 0x0000003d10107220ULL, 0x080fe20000410000ULL,
0x0000003d11117220ULL, 0x080fe20000410000ULL, 0x0000003d14147220ULL, 0x080fe20000410000ULL,
0x0000003d15157220ULL, 0x080fe20000410000ULL, 0x0000003d18187220ULL, 0x080fe20000410000ULL,
0x0000003d19197220ULL, 0x080fe20000410000ULL, 0x0000003d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000003d20207220ULL, 0x080fe20000410000ULL,
0x0000003d21217220ULL, 0x080fe20000410000ULL, 0x0000003d38387220ULL, 0x080fe20000410000ULL,
0x0000003d39397220ULL, 0x080fe20000410000ULL, 0x0000003d34347220ULL, 0x080fe20000410000ULL,
0x0000003d35357220ULL, 0x000fce0000410000ULL, 0x000000447d7d7220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018093d7811ULL, 0x002fcc00078ff0ffULL,
0x00001f3d443d7589ULL, 0x000e6400000e0000ULL, 0x0000003d0e0e7220ULL, 0x082fe20000410000ULL,
0x0000003d0f0f7220ULL, 0x080fe20000410000ULL, 0x0000003d12127220ULL, 0x080fe20000410000ULL,
0x0000003d13137220ULL, 0x080fe20000410000ULL, 0x0000003d16167220ULL, 0x080fe20000410000ULL,
0x0000003d17177220ULL, 0x080fe20000410000ULL, 0x0000003d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000003d22227220ULL, 0x080fe20000410000ULL,
0x0000003d23237220ULL, 0x080fe20000410000ULL, 0x0000003d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000003d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003d36367220ULL, 0x080fe20000410000ULL,
0x0000003d37377220ULL, 0x000fce0000410000ULL, 0x000000413eff7212ULL, 0x000fda00078030ffULL,
0x8000007a3f3f0221ULL, 0x000fe20000010000ULL, 0x00007610ff400816ULL, 0x000fc60000000040ULL,
0x3fb8aa3b3f3f0820ULL, 0x000fc80000410000ULL, 0x0000003f00040308ULL, 0x000ea40000000800ULL,
0x000000043c3c0220ULL, 0x004fce0000410000ULL, 0x0000007d3c7d7221ULL, 0x000fe20000010000ULL,
0x00000000003c7805ULL, 0x002fe20000015200ULL, 0x01a6a881420075a7ULL, 0x000ea2000800017fULL,
0x0001a6a842417836ULL, 0x000fca0000000000ULL, 0x00000000410572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x006fdc0003800000ULL, 0x000000ffff447224ULL, 0x000fce00078e00ffULL,
0x000000104400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x000fcc0000015200ULL, 0x0000003e3c437210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x000000433e3e7211ULL, 0x000fca00078110ffULL, 0x000000ffff3f7224ULL, 0x000fca00000e063fULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000144447836ULL, 0x000fce0000000000ULL,
0x01a6a881420075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000410572caULL, 0x000fde00000e0000ULL, 0x00000004617e7824ULL, 0x000fe200078e00ffULL,
0x00000008096a7812ULL, 0x000fe200078ec0ffULL, 0x00002000616c7824ULL, 0x000fe200078e0208ULL,
0x00009910403c7816ULL, 0x000fe400000000ffULL, 0x000000047e7e7812ULL, 0x000fe200078ec0ffULL,
0x000160006c6b7836ULL, 0x000fe20000000000ULL, 0x000000076a6a7812ULL, 0x000fe400078ef809ULL,
0x00000004ff7c7819ULL, 0x000fe40000011609ULL, 0x0000007e093d7211ULL, 0x000fe200078fe0ffULL,
0x000000086a3f7824ULL, 0x000fe200078e00ffULL, 0x000000ff3c00720cULL, 0x000fe20003f05270ULL,
0x00000400773c7824ULL, 0x000fe200078e00ffULL, 0x000000106a767812ULL, 0x000fe200078efcffULL,
0x00000004737f7824ULL, 0x000fc400078e027cULL, 0x000000016a787824ULL, 0x000fe200078e023dULL,
0xfffff0003c7b7812ULL, 0x000fe200078ec0ffULL, 0x000000016a5c7824ULL, 0x000fe400078e027fULL,
0x000000013d757824ULL, 0x000fe200078e0276ULL, 0xfffffff83f787812ULL, 0x000fe200078ee278ULL,
0x00000008763e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3c7812ULL, 0x000fe400078ee25cULL,
0x00012000087b7810ULL, 0x000fe40007ffe07bULL, 0xfffffff83e757812ULL, 0x000fe200078ee275ULL,
0x000000103c407824ULL, 0x000fc400078e026bULL, 0x00000010783e7824ULL, 0x100fe400078e027bULL,
0x0000001075447824ULL, 0x000fe200078e027bULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000001003057836ULL, 0x000fe20000000000ULL, 0x00005410003c7816ULL, 0x000fe20000000000ULL,
0x00000008033d7836ULL, 0x000fe40000000000ULL, 0x00000018033f7836ULL, 0x000fe40000000000ULL,
0x00001f053c057589ULL, 0x0002a800000e0000ULL, 0x00001f3d3c027589ULL, 0x0002e800000e0000ULL,
0x00001f033c037589ULL, 0x00026800000e0000ULL, 0x00001f3f3c007589ULL, 0x00026400000e0000ULL,
0x000000003e3c783bULL, 0x002e680000000200ULL, 0x000000004444783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x088fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000544447232ULL, 0x084fe40000200000ULL,
0x0000000546467232ULL, 0x000fc40000200000ULL, 0x0000000045457232ULL, 0x080fe40000200000ULL,
0x0000000047477232ULL, 0x000fce0000200000ULL, 0x000000086a5d7824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x000000025c5c7836ULL, 0x000fe40000000000ULL,
0x00000001767f7824ULL, 0x000fc600078e027fULL, 0xfffffff85d5c7812ULL, 0x000fca00078ee25cULL,
0x000000105c5c7824ULL, 0x000fcc00078e026bULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000ff40627812ULL, 0x050fe400078ec0ffULL, 0x00000010ff917819ULL, 0x000fe40000011641ULL,
0x00000062ff66723eULL, 0x000fe400020006ffULL, 0x0000ffff418e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff907819ULL, 0x000fe20000011640ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000ffff408f7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff8d7819ULL, 0x000fe40000011642ULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x128fe4000001165cULL, 0x000000ff5c947812ULL, 0x000fe400078ec0ffULL,
0x00000018ff937819ULL, 0x000fc4000001165cULL, 0x0000ffff5c867812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x100fe4000001165dULL, 0x000000ff5e627812ULL, 0x000fe400078ec0ffULL,
0x000000ff5f637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8c7819ULL, 0x000fe4000001165dULL,
0x000000ff5d957812ULL, 0x000fc400078ec0ffULL, 0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL,
0x00000018ff927819ULL, 0x100fe4000001165fULL, 0x00000018ff5d7819ULL, 0x000fe4000001165eULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000010ff827819ULL, 0x000fe4000001165fULL,
0x0000ffff5f817812ULL, 0x000fc400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000063ff5f723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000005dff63723eULL, 0x000fe200020006ffULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x0000008eff8e723eULL, 0x000fe200020006ffULL, 0x20000062ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000005fff627230ULL, 0x000fe20000004100ULL,
0x0000ffff42887812ULL, 0x000fe200078ec0ffULL, 0x20000092ff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff91927812ULL, 0x000fe200078ec0ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff917819ULL, 0x000fc4000001168fULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000010ff897819ULL, 0x000fe40000011643ULL, 0x00000090ff8f723eULL, 0x000fe400020006ffULL,
0x0000ffff438b7812ULL, 0x000fe400078ec0ffULL, 0x00000091ff90723eULL, 0x000fe200020006ffULL,
0x20000092ff917230ULL, 0x000fe20000004100ULL, 0x00000018ff647819ULL, 0x000fe20000011640ULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff42677812ULL, 0x000fe200078ec0ffULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x0000008dff92723eULL, 0x000fe200020006ffULL,
0x2000008eff8d7230ULL, 0x000fe20000004100ULL, 0x000000ff89897812ULL, 0x000fc400078ec0ffULL,
0x00000008ff887819ULL, 0x000fe40000011688ULL, 0x00000008ff8e7819ULL, 0x000fe2000001168bULL,
0x20000092ff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff41657812ULL, 0x000fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x000000ff43687812ULL, 0x000fe400078ec0ffULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x0000008eff92723eULL, 0x000fe200020006ffULL, 0x20000088ff8e7230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fc4000001165eULL, 0x0000ffff5e837812ULL, 0x000fe200078ec0ffULL,
0x20000092ff887230ULL, 0x000fe20000004100ULL, 0x00000068ff43723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fe200078ec0ffULL,
0x20000067ff647230ULL, 0x000fe20000004100ULL, 0x00000008ff867819ULL, 0x000fe40000011686ULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000093ff5e723eULL, 0x000fc400020006ffULL,
0x00000094ff94723eULL, 0x000fe200020006ffULL, 0x20000041ff677230ULL, 0x000fe20000004100ULL,
0x000000ff8c937812ULL, 0x000fe200078ec0ffULL, 0x20000089ff8c7230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000094ff417230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000008aff89723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x20000065ff697230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fe200078ec0ffULL, 0x20000043ff657230ULL, 0x000fe20000004100ULL,
0x000000ff82927812ULL, 0x000fc400078ec0ffULL, 0x00000008ff827819ULL, 0x000fe20000011683ULL,
0x20000086ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000093ff8a723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000092ff93723eULL, 0x000fe200020006ffULL, 0x20000087ff867230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000080ff877230ULL, 0x000fe20000004100ULL,
0x00000082ff92723eULL, 0x000fe200020006ffULL, 0x20000093ff827230ULL, 0x000fe20000004100ULL,
0x00000095ff43723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x20000092ff807230ULL, 0x000fe20000004100ULL,
0x000010548b647816ULL, 0x000fe20000000064ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe20000011641ULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fc40000011642ULL, 0x00000010ff417819ULL, 0x000fe40000011688ULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff887819ULL, 0x000fe40000011689ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff837819ULL, 0x000fc40000011683ULL, 0x00000010ff937819ULL, 0x000fe40000011668ULL,
0x0000105442417816ULL, 0x000fe40000000041ULL, 0x00000010ff897819ULL, 0x000fe4000001165cULL,
0x000010548f687816ULL, 0x000fe40000000066ULL, 0x0000105488427816ULL, 0x000fe4000000008bULL,
0x000010545e5c7816ULL, 0x000fc40000000083ULL, 0x00000010ff8f7819ULL, 0x000fe40000011667ULL,
0x00000010ff887819ULL, 0x000fe4000001165dULL, 0x00000010ff837819ULL, 0x000fe40000011662ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff677819ULL, 0x000fe4000001168dULL,
0x00000010ff5d7819ULL, 0x000fc40000011686ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff627819ULL, 0x000fe40000011680ULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff927819ULL, 0x000fe40000011691ULL, 0x00000010ff907819ULL, 0x000fe40000011690ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff867819ULL, 0x000fe40000011687ULL,
0x00000010ff827819ULL, 0x000fc40000011682ULL, 0x00000010ff807819ULL, 0x000fe4000001165fULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x0000105440677816ULL, 0x000fe40000000067ULL,
0x0000105463627816ULL, 0x000fe40000000062ULL, 0x0000105492697816ULL, 0x000fe40000000069ULL,
0x0000105493667816ULL, 0x000fc40000000090ULL, 0x000010548c657816ULL, 0x000fe40000000065ULL,
0x000010548f407816ULL, 0x000fe2000000008eULL, 0x000000683c54723cULL, 0x002fe20000041854ULL,
0x000010548a437816ULL, 0x000fe40000000043ULL, 0x00001054885d7816ULL, 0x000fe4000000005dULL,
0x00001054865e7816ULL, 0x000fe20000000089ULL, 0x000000663c48723cULL, 0x000fe20000041848ULL,
0x00001054825f7816ULL, 0x000fc40000000083ULL, 0x0000105480637816ULL, 0x000fc60000000081ULL,
0x000000643c4c723cULL, 0x000fec000004184cULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005c3c2c723cULL, 0x000fec000004182cULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000623c24723cULL, 0x000fec0000041824ULL,
0x000000404418723cULL, 0x000fe20000041818ULL, 0x000000027e3d7812ULL, 0x000fe200078efcffULL,
0x000000086a3f7824ULL, 0x000fc400078e00ffULL, 0x00000008763e7824ULL, 0x000fe400078e00ffULL,
0x000000017c3d7824ULL, 0x000fe200078e023dULL, 0x00000068440c723cULL, 0x000fe2000004180cULL,
0x0000000876407824ULL, 0x000fe400078e00ffULL, 0x000000016a3c7824ULL, 0x100fe400078e023dULL,
0x00000001763d7824ULL, 0x000fe200078e023dULL, 0x000000664410723cULL, 0x000fe20000041810ULL,
0xfffffff840407812ULL, 0x000fc400078ee27fULL, 0xfffffff83f3c7812ULL, 0x000fe400078ee23cULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23dULL, 0x000000644414723cULL, 0x000fe20000041814ULL,
0x0000001040407824ULL, 0x000fe400078e026bULL, 0x000000103c3c7824ULL, 0x100fe400078e027bULL,
0x000000103e7b7824ULL, 0x000fe200078e027bULL, 0x00000042441c723cULL, 0x000fe6000004181cULL,
0x000000003c3c783bULL, 0x000e660000000200ULL, 0x0000005c4420723cULL, 0x000fec0000041820ULL,
0x0000005e4438723cULL, 0x000fec0000041838ULL, 0x000000624444723cULL, 0x000fe20000041834ULL,
0x000000007b34783bULL, 0x0006a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x080fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x084fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000008765c7824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x000000027f7f7836ULL, 0x000fca0000000000ULL,
0xfffffff85c5c7812ULL, 0x000fca00078ee27fULL, 0x000000105c5c7824ULL, 0x000fcc00078e026bULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000ff40627812ULL, 0x050fe400078ec0ffULL,
0x00000018ff637819ULL, 0x100fe40000011640ULL, 0x00000062ff66723eULL, 0x000fe400020006ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000ffff418a7812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff8d7819ULL, 0x000fe20000011640ULL,
0x20000063ff807230ULL, 0x000fe20000004100ULL, 0x0000ffff408b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff41647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff897819ULL, 0x000fe40000011642ULL,
0x00000010ff867819ULL, 0x128fe4000001165cULL, 0x000000ff5c8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff8e7819ULL, 0x000fe4000001165cULL, 0x0000ffff5c7f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff887819ULL, 0x100fe4000001165dULL, 0x000000ff5d917812ULL, 0x040fe400078ec0ffULL,
0x00000018ff907819ULL, 0x000fe4000001165dULL, 0x0000ffff5d817812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001165eULL, 0x00000018ff5d7819ULL, 0x000fc4000001165fULL,
0x00000010ff687819ULL, 0x000fe4000001165eULL, 0x000000ff5e927812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5e7b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7c7819ULL, 0x000fe4000001165fULL,
0x000000ff5f627812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f697812ULL, 0x000fc400078ec0ffULL,
0x0000008eff5e723eULL, 0x000fe400020006ffULL, 0x0000005cff5f723eULL, 0x000fe400020006ffULL,
0x0000005dff8e723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000062ff63723eULL, 0x000fe200020006ffULL, 0x2000005fff627230ULL, 0x000fe20000004100ULL,
0x00000018ff407819ULL, 0x000fe20000011641ULL, 0x2000008eff5f7230ULL, 0x000fe20000004100ULL,
0x00000008ff8e7819ULL, 0x000fe2000001168aULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x000000ff89897812ULL, 0x000fe200078ec0ffULL,
0x20000064ff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff837819ULL, 0x000fe40000011643ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000010ff8c7819ULL, 0x000fc40000011641ULL,
0x0000ffff43877812ULL, 0x000fe200078ec0ffULL, 0x20000040ff647230ULL, 0x000fe20000004100ULL,
0x000000ff42657812ULL, 0x040fe400078ec0ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x0000ffff42827812ULL, 0x000fe400078ec0ffULL, 0x0000008dff8a723eULL, 0x000fe400020006ffULL,
0x00000018ff427819ULL, 0x000fc40000011643ULL, 0x00000089ff8d723eULL, 0x000fe200020006ffULL,
0x2000008eff897230ULL, 0x000fe20000004100ULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe20000011687ULL,
0x2000008dff877230ULL, 0x000fe20000004100ULL, 0x00000041ff40723eULL, 0x000fe400020006ffULL,
0x00000008ff8b7819ULL, 0x000fe4000001168bULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000042ff41723eULL, 0x000fc400020006ffULL,
0x000000ff68687812ULL, 0x000fe400078ec0ffULL, 0x0000008fff42723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x0000008eff8f723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fe200020006ffULL, 0x20000083ff8e7230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x2000008fff837230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fe2000001167bULL, 0x2000008bff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff7c7c7812ULL, 0x000fe200078ec0ffULL, 0x20000082ff8d7230ULL, 0x000fe20000004100ULL,
0x00000068ff68723eULL, 0x000fc400020006ffULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x20000068ff827230ULL, 0x000fe20000004100ULL,
0x000000ff43677812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x0000007cff8f723eULL, 0x000fe200020006ffULL, 0x2000007bff7c7230ULL, 0x000fe20000004100ULL,
0x00000008ff7f7819ULL, 0x000fc4000001167fULL, 0x00000069ff68723eULL, 0x000fe200020006ffULL,
0x2000008fff7b7230ULL, 0x000fe20000004100ULL, 0x00000067ff43723eULL, 0x000fe200020006ffULL,
0x20000065ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff697819ULL, 0x000fe2000001168aULL, 0x20000043ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff8b7819ULL, 0x000fc4000001168bULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000010ff8f7819ULL, 0x000fe2000001167eULL,
0x20000068ff7e7230ULL, 0x000fe20000004100ULL, 0x0000105469687816ULL, 0x000fe20000000066ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x0000105480667816ULL, 0x000fe2000000008bULL,
0x20000092ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x00000008ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff807819ULL, 0x000fe40000011667ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff677819ULL, 0x000fe40000011689ULL, 0x00000091ff43723eULL, 0x000fc400020006ffULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000090ff5d7230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000105464677816ULL, 0x000fe20000000067ULL, 0x20000088ff887230ULL, 0x000fe20000004100ULL,
0x0000105487647816ULL, 0x000fe20000000080ULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x000000663c48723cULL, 0x002fe20000041848ULL, 0x00000010ff807819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fe40000011683ULL, 0x00000010ff837819ULL, 0x000fe2000001165cULL,
0x000000663410723cULL, 0x004fe20000041810ULL, 0x000010545e5c7816ULL, 0x000fe4000000007fULL,
0x00000010ff7f7819ULL, 0x000fc40000011662ULL, 0x00000010ff877819ULL, 0x000fe40000011643ULL,
0x0000105480417816ULL, 0x000fe40000000041ULL, 0x00000010ff627819ULL, 0x000fe4000001167cULL,
0x00000010ff8b7819ULL, 0x000fe40000011640ULL, 0x00000010ff427819ULL, 0x000fe40000011642ULL,
0x00000010ff437819ULL, 0x000fc40000011686ULL, 0x00000010ff807819ULL, 0x000fe4000001165dULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff7c7819ULL, 0x000fe4000001167bULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff8e7819ULL, 0x000fc4000001168eULL, 0x00000010ff407819ULL, 0x000fe4000001168dULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff5d7819ULL, 0x000fe40000011681ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff7b7819ULL, 0x000fe4000001165fULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x0000105443427816ULL, 0x000fe40000000042ULL,
0x000010547c5f7816ULL, 0x000fe40000000063ULL, 0x000010548c697816ULL, 0x000fe4000000008fULL,
0x000010548e657816ULL, 0x000fe40000000065ULL, 0x000010548b407816ULL, 0x000fe40000000040ULL,
0x0000105488437816ULL, 0x000fe20000000087ULL, 0x000000683c54723cULL, 0x000fe20000041854ULL,
0x00001054805d7816ULL, 0x000fc4000000005dULL, 0x00001054825e7816ULL, 0x000fe40000000083ULL,
0x000010547f627816ULL, 0x000fe20000000062ULL, 0x000000643c4c723cULL, 0x000fe2000004184cULL,
0x000010547b637816ULL, 0x000fca000000007eULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005c3c2c723cULL, 0x000fec000004182cULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000623c24723cULL, 0x000fec0000041824ULL,
0x00000068340c723cULL, 0x000fe2000004180cULL, 0x00000002773c7824ULL, 0x000fc400078e00ffULL,
0x00000001ff3f7424ULL, 0x000fc600078e00ffULL, 0xfffffff83c3d7812ULL, 0x000fe200078ec0ffULL,
0x00000008613c7824ULL, 0x000fe200078e0208ULL, 0x000000643414723cULL, 0x000fe60000041814ULL,
0x00000001083e7824ULL, 0x000fe400078e023dULL, 0x01a6c83f3c3c79a7ULL, 0x000e62000850003fULL,
0x000000403418723cULL, 0x000fec0000041818ULL, 0x00000042341c723cULL, 0x000fe2000004181cULL,
0x01a6883f3eff79a7ULL, 0x0005ea000850003fULL, 0x0000005c3420723cULL, 0x000fec0000041820ULL,
0x0000005e3438723cULL, 0x000fec0000041838ULL, 0x000000623444723cULL, 0x000fee0000041844ULL,
0x0000000000347805ULL, 0x000fe20000015200ULL, 0x0000003d060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x006fdc0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x00000036343f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x0000003d060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000008070357836ULL, 0x000fe20000000000ULL, 0x0000940000087ab9ULL, 0x000fc60000000800ULL,
0x000000085a3d7c24ULL, 0x000fe2000f8e0235ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x000000356e347248ULL, 0x000fe20007fe0000ULL, 0x0000001073377824ULL, 0x000fe200078e00ffULL,
0x00000003ff367819ULL, 0x000fe20000011609ULL, 0x0000900000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000134347824ULL, 0x000fe400078e0a35ULL, 0x00000004363e7836ULL, 0x000fe40000000000ULL,
0x00000001373c7824ULL, 0x000fe200078e0236ULL, 0x0000003437347248ULL, 0x000fe20007fe0000ULL,
0x00000008363f7836ULL, 0x000fc40000000000ULL, 0x000000013c357824ULL, 0x000fe400078e0209ULL,
0x0000000134347824ULL, 0x000fe400078e0a37ULL, 0x000000083c407824ULL, 0x000fe400078e00ffULL,
0x0000000c36417836ULL, 0x000fe20000000000ULL, 0x000000343e00720cULL, 0x080fe20003f66070ULL,
0x00000001373e7824ULL, 0x040fe200078e023eULL, 0x000000343600720cULL, 0x080fe20003f86070ULL,
0x00000001375c7824ULL, 0x000fe200078e023fULL, 0xfffffff840407812ULL, 0x000fe200078ee235ULL,
0x000000013e367824ULL, 0x040fe200078e0209ULL, 0x000000343f00720cULL, 0x080fe20003f46070ULL,
0x000000083e437824ULL, 0x000fe200078e00ffULL, 0x000000344100720cULL, 0x000fe20003f06070ULL,
0x000000013c357824ULL, 0x000fc400078e023dULL, 0x00000001375e7824ULL, 0x000fe200078e0241ULL,
0xfffffff843427812ULL, 0x000fe200078ee236ULL, 0x0000008035347825ULL, 0x000fc800078e00ffULL,
0x000000013e367824ULL, 0x100fe200078e023dULL, 0x0000006d34347212ULL, 0x080fe200078efcffULL,
0x000000015c3c7824ULL, 0x040fe400078e023dULL, 0x000000015c3f7824ULL, 0x040fe200078e0209ULL,
0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL, 0x000000085c5c7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000935357c10ULL, 0x000fe4000affe4ffULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee23fULL, 0x000000015e3e7824ULL, 0x000fe200078e023dULL,
0x0000006d36367212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0x0000000836367c10ULL, 0x000fe2000ffbe0ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000006d3c3c7212ULL, 0x080fe400078efcffULL, 0x0000000937377c10ULL, 0x000fe2000affe4ffULL,
0x000000015e417824ULL, 0x000fe200078e0209ULL, 0x0000006d3e3e7212ULL, 0x000fe200078efcffULL,
0x000000085e5e7824ULL, 0x000fe200078e00ffULL, 0x000000083c3c7c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001042437824ULL, 0x100fe200078e026bULL, 0x000000083e3e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee241ULL,
0x0000001040417824ULL, 0x000fe200078e026bULL, 0x000000093d3d7c10ULL, 0x000fc4000affe4ffULL,
0x000000093f3f7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000105e5f7824ULL, 0x000fe200078e026bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034417faeULL, 0x0003e8000e101c46ULL,
0x0000000036437faeULL, 0x0003e8000d901c46ULL, 0x000000003c5d7faeULL, 0x0003e8000d101c46ULL,
0x000000003e5f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001073347824ULL, 0x000fe200078e00ffULL, 0x0000900000087ab9ULL, 0x000fc80000000a00ULL,
0x0000003409367211ULL, 0x000fca00078fe8ffULL, 0x00000004363c7836ULL, 0x000fe40000000000ULL,
0x0000000136357824ULL, 0x040fe400078e0209ULL, 0x0000000836407824ULL, 0x040fe400078e00ffULL,
0x0000000c365c7836ULL, 0x000fe40000000000ULL, 0x0000000836427836ULL, 0x000fe20000000000ULL,
0xfffffff840407812ULL, 0x000fe200078ee235ULL, 0x0000000136347824ULL, 0x000fc400078e023dULL,
0x000000013c377824ULL, 0x040fe400078e0209ULL, 0x000000083c5e7824ULL, 0x040fe400078e00ffULL,
0x000000013c3e7824ULL, 0x000fe400078e023dULL, 0x000000015c3f7824ULL, 0x040fe400078e0209ULL,
0x000000085c647824ULL, 0x000fe400078e00ffULL, 0x0000000142367824ULL, 0x000fc400078e023dULL,
0x000000015c3c7824ULL, 0x000fe400078e023dULL, 0x00000001423d7824ULL, 0x040fe400078e0209ULL,
0x0000000842627824ULL, 0x000fe200078e00ffULL, 0xfffffff85e427812ULL, 0x000fe200078ee237ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff8645e7812ULL, 0x000fe400078ee23fULL,
0xfffffff8625c7812ULL, 0x000fe200078ee23dULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000006d34347212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006d3e3e7212ULL, 0x080fe400078efcffULL, 0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36367212ULL, 0x080fe400078efcffULL,
0x000000083e3e7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001040417824ULL, 0x100fe200078e026bULL,
0x0000006d3c3c7212ULL, 0x000fe200078efcffULL, 0x0000001042437824ULL, 0x100fe200078e026bULL,
0x0000000935357c10ULL, 0x000fe200087fe4ffULL, 0x000000105c5d7824ULL, 0x100fe200078e026bULL,
0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL, 0x000000105e5f7824ULL, 0x000fe200078e026bULL,
0x000000083c3c7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e2000b901c46ULL, 0x000000093f3f7c10ULL, 0x000fc400097fe4ffULL,
0x0000000937377c10ULL, 0x000fe400087fe4ffULL, 0x000000093d3d7c10ULL, 0x000fe20009ffe4ffULL,
0x000000003e437faeULL, 0x0003e8000b901c46ULL, 0x00000000365d7faeULL, 0x0003e8000b901c46ULL,
0x000000003c5f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000036ff8279a7ULL, 0x0002a40008500005ULL,
0x01a62836713679a7ULL, 0x0022e4000850003fULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0xffffffe06f3d7812ULL, 0x040fe400078ec0ffULL, 0x000000106f3c7812ULL, 0x000fc800078ec0ffULL,
0x000000083c3c7210ULL, 0x000fca0007ffe03dULL, 0x0000000873417824ULL, 0x000fc800078e023cULL,
0x01a62837410075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fce0000015200ULL,
0x0000003c343f7210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3d7824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3c7819ULL, 0x000fc8000001143dULL, 0x0000003f3c3c7211ULL, 0x000fca00078110ffULL,
0x000000ffff3d7224ULL, 0x000fca00000e063dULL, 0x000000023c3c7819ULL, 0x000fc8000000123dULL,
0x0000003c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a62837410075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000002077347824ULL, 0x000fe400078e00ffULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff7f7224ULL, 0x000fe200078e007aULL,
0xffffff8034357812ULL, 0x000fc800078ec0ffULL, 0x0000008008347810ULL, 0x000fc80007ffe035ULL,
0x0000003474347210ULL, 0x000fca0007ffe06dULL, 0x01a0000034357984ULL, 0x000ee80000000800ULL,
0x01a2000034367984ULL, 0x0009220000000800ULL, 0x0000007a3500720bULL, 0x008fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x0000000400948947ULL, 0x016fea0003800000ULL, 0x0000000159347836ULL, 0x000fe20000000000ULL,
0x0000007a3500720bULL, 0x0c0fe40003f14000ULL, 0x0000007a357f7209ULL, 0x000fe40007810000ULL,
0x000000773400720cULL, 0x000fd20003f45270ULL, 0x00000000003c7806ULL, 0x000fc800000e0100ULL,
0x000000807734a824ULL, 0x000fe200078e0208ULL, 0x000000ff3c00720cULL, 0x000fc80003f05270ULL,
0x000000347434a210ULL, 0x000fca0007ffe06dULL, 0x01a4007f3400a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x0000007a7f347221ULL, 0x002fe20000010100ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003e7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff3d7819ULL, 0x000fca0000011609ULL,
0x00001f3d3e347589ULL, 0x006e6400000e0000ULL, 0x0000005434547220ULL, 0x042fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002434247220ULL, 0x040fe20000410000ULL,
0x0000002534257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008093d7811ULL, 0x000fca00078ff0ffULL, 0x00001f3d3e347589ULL, 0x006e6400000e0000ULL,
0x0000005634567220ULL, 0x042fe20000410000ULL, 0x0000005734577220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004e344e7220ULL, 0x040fe20000410000ULL, 0x0000004f344f7220ULL, 0x040fe20000410000ULL,
0x0000005234527220ULL, 0x040fe20000410000ULL, 0x0000005334537220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002634267220ULL, 0x040fe20000410000ULL, 0x0000002734277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010093d7811ULL, 0x000fca00078ff0ffULL,
0x00001f3d3e347589ULL, 0x006e6400000e0000ULL, 0x0000000c340c7220ULL, 0x042fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x000fce0000410000ULL, 0x0000003e7d7d7220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018093d7811ULL, 0x000fca00078ff0ffULL,
0x00001f3d3e347589ULL, 0x002e6400000e0000ULL, 0x0000000e340e7220ULL, 0x042fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x040fe20000410000ULL, 0x0000003a343a7220ULL, 0x040fe20000410000ULL,
0x0000003b343b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x000fce0000410000ULL, 0x0000003c37ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff3c7424ULL, 0x000fd800078e00ffULL, 0x8000007f35350221ULL, 0x000fe20000010000ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL,
0x0000003500040308ULL, 0x000ea40000000800ULL, 0x0000000436360220ULL, 0x004fce0000410000ULL,
0x0000007d367d7221ULL, 0x000fe20000010000ULL, 0x0000000000347805ULL, 0x002fe40000015200ULL,
0xfffffff06f377812ULL, 0x000fca00078ec0ffULL, 0x00000001083f7824ULL, 0x000fc800078e0237ULL,
0x01a6b0853f0075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a6b0853f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000099103c367816ULL, 0x000fe200000000ffULL,
0x0000000477347824ULL, 0x040fe400078e00ffULL, 0x0000040077377824ULL, 0x040fe200078e00ffULL,
0x000000ff3600720cULL, 0x000fe20003f05270ULL, 0x0000100077357824ULL, 0x000fe200078e00ffULL,
0x0000000434347812ULL, 0x000fe400078ec0ffULL, 0xfffff00037377812ULL, 0x000fe400078ec0ffULL,
0x0000003409817211ULL, 0x000fc400078fe0ffULL, 0x00013000087c7810ULL, 0x000fe20007ffe037ULL,
0x000000086a377824ULL, 0x040fe200078e00ffULL, 0xffffe00035357812ULL, 0x000fe200078ec0ffULL,
0x000000016a5c7824ULL, 0x000fe400078e0281ULL, 0x00000010783c7824ULL, 0x100fe200078e027cULL,
0x00017000085d7810ULL, 0x000fe20007ffe035ULL, 0x0000001075347824ULL, 0x000fe200078e027cULL,
0xfffffff8377a7812ULL, 0x000fe200078ee25cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x0000000836027836ULL, 0x000fe20000000000ULL, 0x0000541000357816ULL, 0x000fe20000000000ULL,
0x00000010363e7836ULL, 0x000fe40000000000ULL, 0x0000001836407836ULL, 0x000fe40000000000ULL,
0x00001f0235027589ULL, 0x0002a800000e0000ULL, 0x00001f3e35057589ULL, 0x0002e800000e0000ULL,
0x00001f3635037589ULL, 0x00026800000e0000ULL, 0x00001f4035007589ULL, 0x00026400000e0000ULL,
0x000000003c3c783bULL, 0x002e620000000200ULL, 0x000000107a407824ULL, 0x000fc600078e025dULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x084fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x000000086a5f7824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x000000025c7e7836ULL, 0x000fe40000000000ULL, 0x0000000176817824ULL, 0x000fc600078e0281ULL,
0xfffffff85f7e7812ULL, 0x000fca00078ee27eULL, 0x000000107e5d7824ULL, 0x000fcc00078e025dULL,
0x000000005d5c783bULL, 0x000f620000004200ULL, 0x000000ff40627812ULL, 0x050fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe40000011641ULL, 0x00000062ff69723eULL, 0x000fe400020006ffULL,
0x0000ffff408c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff418d7812ULL, 0x000fe200078ec0ffULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fc40000011640ULL,
0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff8b7819ULL, 0x000fe40000011642ULL, 0x00000010ff897819ULL, 0x128fe4000001165cULL,
0x000000ff5c927812ULL, 0x000fe400078ec0ffULL, 0x00000018ff917819ULL, 0x000fc4000001165cULL,
0x0000ffff5c847812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x100fe4000001165dULL,
0x000000ff5e627812ULL, 0x000fe400078ec0ffULL, 0x000000ff5f637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x000fe4000001165dULL, 0x000000ff5d937812ULL, 0x000fc400078ec0ffULL,
0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff907819ULL, 0x100fe4000001165fULL,
0x00000018ff5d7819ULL, 0x000fe4000001165eULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff7b7819ULL, 0x000fe4000001165fULL, 0x0000ffff5f787812ULL, 0x000fc400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000063ff5f723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x0000005dff63723eULL, 0x000fe200020006ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x000000ff8f8f7812ULL, 0x000fe200078ec0ffULL,
0x20000062ff5c7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000090ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff907819ULL, 0x000fe2000001168dULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x0000ffff42857812ULL, 0x000fc400078ec0ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8d723eULL, 0x000fe200020006ffULL, 0x2000008eff8f7230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fe20000011685ULL, 0x2000008cff8e7230ULL, 0x000fe20000004100ULL,
0x0000008bff8c723eULL, 0x000fe200020006ffULL, 0x20000090ff8b7230ULL, 0x000fe20000004100ULL,
0x000000ff89907812ULL, 0x000fe200078ec0ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff867819ULL, 0x000fe20000011643ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000ffff43887812ULL, 0x000fc400078ec0ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000010ff757819ULL, 0x000fe4000001165eULL, 0x0000ffff5e807812ULL, 0x000fe400078ec0ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000091ff5e723eULL, 0x000fe400020006ffULL,
0x000000ff86867812ULL, 0x000fc400078ec0ffULL, 0x000000ff41657812ULL, 0x000fe200078ec0ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x000000ff8a917812ULL, 0x000fe200078ec0ffULL, 0x20000085ff8a7230ULL, 0x000fe20000004100ULL,
0x00000018ff647819ULL, 0x000fe40000011640ULL, 0x000000ff43687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff847819ULL, 0x000fc40000011684ULL, 0x00000008ff857819ULL, 0x000fe20000011687ULL,
0x20000090ff877230ULL, 0x000fe20000004100ULL, 0x00000018ff407819ULL, 0x000fe40000011641ULL,
0x000000ff42667812ULL, 0x000fe400078ec0ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000086ff897230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fc400020006ffULL,
0x000000ff75757812ULL, 0x000fe400078ec0ffULL, 0x000000ff7b907812ULL, 0x000fe200078ec0ffULL,
0x20000088ff867230ULL, 0x000fe20000004100ULL, 0x00000018ff677819ULL, 0x000fe40000011643ULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000008ff7b7819ULL, 0x000fe40000011680ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x20000091ff887230ULL, 0x000fe20000004100ULL,
0x00000068ff43723eULL, 0x000fc400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x00000066ff42723eULL, 0x000fe200020006ffULL,
0x20000065ff667230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x20000043ff657230ULL, 0x000fe20000004100ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000084ff807230ULL, 0x000fe20000004100ULL, 0x00000075ff75723eULL, 0x000fe200020006ffULL,
0x20000042ff647230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fe200020006ffULL,
0x20000085ff847230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x20000075ff857230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x00000008ff917819ULL, 0x000fe20000011678ULL, 0x20000090ff787230ULL, 0x000fe20000004100ULL,
0x00000067ff43723eULL, 0x000fe200020006ffULL, 0x20000041ff677230ULL, 0x000fe20000004100ULL,
0x00000093ff42723eULL, 0x000fe200020006ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fe20000011666ULL, 0x2000007bff757230ULL, 0x000fe20000004100ULL,
0x00000091ff7b723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff667819ULL, 0x000fe2000001168eULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fc40000011668ULL, 0x00000010ff8e7819ULL, 0x000fe20000011665ULL,
0x20000092ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff687819ULL, 0x000fe4000001168dULL,
0x00000010ff647819ULL, 0x000fe40000011664ULL, 0x00000010ff657819ULL, 0x000fe4000001168cULL,
0x00000010ff8d7819ULL, 0x000fe40000011667ULL, 0x00000010ff897819ULL, 0x000fc40000011689ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff677819ULL, 0x000fe4000001168bULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x0000105465647816ULL, 0x000fe40000000064ULL,
0x0000105489657816ULL, 0x000fe4000000008eULL, 0x0000105440677816ULL, 0x000fc40000000067ULL,
0x00000010ff897819ULL, 0x000fe40000011642ULL, 0x000010548d407816ULL, 0x000fe2000000008aULL,
0x000000643c4c723cULL, 0x002fe2000004184cULL, 0x00000010ff427819ULL, 0x000fe40000011687ULL,
0x00000010ff8a7819ULL, 0x000fe40000011643ULL, 0x00000010ff877819ULL, 0x000fe2000001165eULL,
0x000000643414723cULL, 0x000fe20000041814ULL, 0x00000010ff437819ULL, 0x000fc40000011641ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165dULL, 0x00000010ff417819ULL, 0x000fe40000011686ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff5d7819ULL, 0x000fe40000011684ULL,
0x00000010ff867819ULL, 0x000fe4000001165cULL, 0x00000010ff857819ULL, 0x000fc40000011685ULL,
0x00001054875c7816ULL, 0x000fe40000000080ULL, 0x000010545e5d7816ULL, 0x000fe4000000005dULL,
0x00001054855e7816ULL, 0x000fe40000000086ULL, 0x00000010ff807819ULL, 0x000fe40000011662ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff637819ULL, 0x000fc40000011663ULL, 0x00000010ff857819ULL, 0x000fe40000011678ULL,
0x00000010ff627819ULL, 0x000fe20000011675ULL, 0x0000005c3420723cULL, 0x000fe20000041820ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff787819ULL, 0x000fe4000001165fULL, 0x00000010ff7b7819ULL, 0x000fe2000001167bULL,
0x000170006c5d7836ULL, 0x000fe20000000000ULL, 0x0000105468687816ULL, 0x000fc40000000069ULL,
0x0000105442427816ULL, 0x000fe40000000043ULL, 0x0000105463627816ULL, 0x000fe40000000062ULL,
0x000010548f697816ULL, 0x000fe40000000090ULL, 0x0000105491667816ULL, 0x000fe40000000066ULL,
0x000010548a417816ULL, 0x000fe40000000041ULL, 0x0000105488437816ULL, 0x000fe20000000089ULL,
0x000000683c54723cULL, 0x000fe20000041854ULL, 0x00001054855f7816ULL, 0x000fe20000000080ULL,
0x0000000277807824ULL, 0x000fe200078e00ffULL, 0x0000105478637816ULL, 0x000fe2000000007bULL,
0x0000000876787824ULL, 0x000fc400078e00ffULL, 0x000000663c48723cULL, 0x000fe60000041848ULL,
0xfffffff878787812ULL, 0x000fc600078ee281ULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000623c24723cULL, 0x000fec0000041824ULL, 0x00000068340c723cULL, 0x000fe2000004180cULL,
0x00000004803c7812ULL, 0x000fe200078ec0ffULL, 0x00000008763e7824ULL, 0x000fc600078e00ffULL,
0x000000023c3c7812ULL, 0x000fe200078efcffULL, 0x000000663410723cULL, 0x000fe60000041810ULL,
0x0000003c093d7211ULL, 0x000fe200078fe0ffULL, 0x000000086a3c7824ULL, 0x040fe400078e00ffULL,
0x000000403418723cULL, 0x000fe40000041818ULL, 0x000000016a7b7824ULL, 0x100fe400078e023dULL,
0x0000000176757824ULL, 0x000fc400078e023dULL, 0x00000042341c723cULL, 0x000fe2000004181cULL,
0xfffffff83c7b7812ULL, 0x000fe200078ee27bULL, 0x0000001078407824ULL, 0x000fe200078e025dULL,
0xfffffff83e757812ULL, 0x000fc600078ee275ULL, 0x000000107b3c7824ULL, 0x100fe200078e027cULL,
0x0000005e3438723cULL, 0x000fe20000041838ULL, 0x00000010757c7824ULL, 0x000fc800078e027cULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000623444723cULL, 0x000fe60000041844ULL,
0x000000007c34783bULL, 0x0006a20000000200ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000033c3c7232ULL, 0x082fe40000200000ULL,
0x000000033e3e7232ULL, 0x000fe40000200000ULL, 0x000000023d3d7232ULL, 0x084fe40000200000ULL,
0x000000023f3f7232ULL, 0x000fe40000200000ULL, 0x0000000534347232ULL, 0x080fe40000200000ULL,
0x0000000536367232ULL, 0x000fc40000200000ULL, 0x0000000035357232ULL, 0x080fe40000200000ULL,
0x0000000037377232ULL, 0x000fce0000200000ULL, 0x00000008765f7824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x00000002817c7836ULL, 0x008fca0000000000ULL,
0xfffffff85f7c7812ULL, 0x000fca00078ee27cULL, 0x000000107c5c7824ULL, 0x000fcc00078e025dULL,
0x000000005c5c783bULL, 0x000ee20000004200ULL, 0x000000ff40627812ULL, 0x050fe400078ec0ffULL,
0x00000010ff927819ULL, 0x000fe40000011641ULL, 0x00000062ff66723eULL, 0x000fe400020006ffULL,
0x0000ffff41907812ULL, 0x000fe400078ec0ffULL, 0x0000ffff40917812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe40000011642ULL, 0x00000008ff917819ULL, 0x000fe40000011691ULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000010ff8b7819ULL, 0x108fe4000001165cULL,
0x000000ff5c957812ULL, 0x000fe400078ec0ffULL, 0x00000018ff947819ULL, 0x000fc4000001165cULL,
0x0000ffff5c877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001165dULL,
0x000000ff5e637812ULL, 0x040fe400078ec0ffULL, 0x00000010ff817819ULL, 0x100fe4000001165eULL,
0x00000018ff627819ULL, 0x000fe4000001165eULL, 0x0000ffff5e857812ULL, 0x000fc400078ec0ffULL,
0x000000ff5f5e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff937819ULL, 0x100fe4000001165fULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000010ff867819ULL, 0x000fe4000001165fULL, 0x0000ffff5f847812ULL, 0x000fc400078ec0ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000005eff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000093ff93723eULL, 0x000fe200020006ffULL,
0x20000063ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL,
0x20000062ff637230ULL, 0x000fe20000004100ULL, 0x0000ffff42897812ULL, 0x000fe200078ec0ffULL,
0x2000005fff627230ULL, 0x000fe20000004100ULL, 0x0000ffff438c7812ULL, 0x000fe200078ec0ffULL,
0x20000093ff5f7230ULL, 0x000fe20000004100ULL, 0x00000008ff937819ULL, 0x000fc40000011690ULL,
0x00000091ff90723eULL, 0x000fe200020006ffULL, 0x20000092ff917230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x0000008eff92723eULL, 0x000fe200020006ffULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000008ff897819ULL, 0x000fe20000011689ULL,
0x20000093ff8e7230ULL, 0x000fe20000004100ULL, 0x00000008ff937819ULL, 0x000fe2000001168cULL,
0x20000092ff8c7230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fc40000011640ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000ffff5d887812ULL, 0x000fe400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe200020006ffULL, 0x20000089ff927230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe20000011640ULL,
0x20000093ff897230ULL, 0x000fe20000004100ULL, 0x00000010ff8a7819ULL, 0x000fc40000011643ULL,
0x00000008ff877819ULL, 0x000fe40000011687ULL, 0x000000ff41657812ULL, 0x000fe400078ec0ffULL,
0x00000008ff887819ULL, 0x000fe40000011688ULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x000000ff81817812ULL, 0x000fe400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x000000ff8a8a7812ULL, 0x000fc400078ec0ffULL,
0x000000ff86937812ULL, 0x000fe200078ec0ffULL, 0x20000064ff697230ULL, 0x000fe20000004100ULL,
0x000000ff43687812ULL, 0x000fe400078ec0ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00000018ff407819ULL, 0x000fe40000011641ULL, 0x000000ff42677812ULL, 0x000fe200078ec0ffULL,
0x20000087ff867230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000018ff417819ULL, 0x000fe40000011642ULL,
0x00000010ff8d7819ULL, 0x000fe2000001165dULL, 0x20000088ff877230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000081ff887230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fc400020006ffULL, 0x000000ff5d967812ULL, 0x000fe400078ec0ffULL,
0x00000068ff43723eULL, 0x000fe200020006ffULL, 0x20000065ff687230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000093ff817230ULL, 0x000fe20000004100ULL,
0x00000094ff5d723eULL, 0x000fe200020006ffULL, 0x20000043ff657230ULL, 0x000fe20000004100ULL,
0x000000ff8b8b7812ULL, 0x000fe200078ec0ffULL, 0x20000067ff647230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x000000ff8d947812ULL, 0x000fe200078ec0ffULL, 0x2000008aff8d7230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x20000041ff677230ULL, 0x000fe20000004100ULL,
0x00000008ff857819ULL, 0x000fc40000011685ULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x20000095ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x0000008bff8a723eULL, 0x000fe400020006ffULL, 0x00000008ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff937819ULL, 0x000fe20000011669ULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fc40000011690ULL, 0x00000094ff8b723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x00000096ff43723eULL, 0x000fe200020006ffULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff947819ULL, 0x000fe20000011668ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000040ff40723eULL, 0x000fe200020006ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fc400020006ffULL,
0x000010548f687816ULL, 0x000fe20000000066ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x0000105493667816ULL, 0x000fe40000000090ULL, 0x00000010ff907819ULL, 0x000fe20000011665ULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff657819ULL, 0x000fc4000001168cULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff867819ULL, 0x000fe40000011686ULL,
0x00000010ff8c7819ULL, 0x000fe40000011641ULL, 0x00000010ff417819ULL, 0x000fe40000011689ULL,
0x0000105465647816ULL, 0x000fc40000000064ULL, 0x00000010ff897819ULL, 0x000fe4000001165cULL,
0x000010548d657816ULL, 0x000fe40000000090ULL, 0x000010545d5c7816ULL, 0x000fe40000000086ULL,
0x00000010ff8f7819ULL, 0x000fe40000011667ULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x000000643c4c723cULL, 0x002fe2000004184cULL, 0x00000010ff8d7819ULL, 0x000fc40000011643ULL,
0x00000010ff867819ULL, 0x000fe40000011662ULL, 0x00000010ff407819ULL, 0x000fe20000011640ULL,
0x000000643414723cULL, 0x004fe20000041814ULL, 0x00000010ff677819ULL, 0x000fe4000001168eULL,
0x00000010ff437819ULL, 0x000fe4000001168aULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff877819ULL, 0x000fc40000011687ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff627819ULL, 0x000fe40000011685ULL, 0x00000010ff697819ULL, 0x000fe40000011691ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff8a7819ULL, 0x000fe4000001168bULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff857819ULL, 0x000fe4000001165fULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x0000105442417816ULL, 0x000fe40000000041ULL, 0x0000105440677816ULL, 0x000fe40000000067ULL,
0x0000105443427816ULL, 0x000fc4000000008cULL, 0x000010545e5d7816ULL, 0x000fe40000000087ULL,
0x0000105463627816ULL, 0x000fe20000000062ULL, 0x000000663c48723cULL, 0x000fe20000041848ULL,
0x0000105469697816ULL, 0x000fe40000000094ULL, 0x000010548f407816ULL, 0x000fe40000000092ULL,
0x000010548a437816ULL, 0x000fe2000000008dULL, 0x0000005c3c2c723cULL, 0x000fe2000004182cULL,
0x00001054885e7816ULL, 0x000fc40000000089ULL, 0x00001054815f7816ULL, 0x000fe40000000086ULL,
0x0000105485637816ULL, 0x000fe20000000084ULL, 0x000000683c54723cULL, 0x000fec0000041854ULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000623c24723cULL, 0x000fec0000041824ULL,
0x00000068340c723cULL, 0x000fe2000004180cULL, 0xfffffff8803d7812ULL, 0x000fe200078ec0ffULL,
0x00000008613c7824ULL, 0x000fc400078e0208ULL, 0x00000001ff3f7424ULL, 0x000fe400078e00ffULL,
0x00000001083e7824ULL, 0x000fe200078e023dULL, 0x000000663410723cULL, 0x000fe20000041810ULL,
0x01a6c83f3c3c79a7ULL, 0x000e6a000850003fULL, 0x000000403418723cULL, 0x000fe20000041818ULL,
0x01a6903f3eff79a7ULL, 0x0005ea000850003fULL, 0x00000042341c723cULL, 0x000fec000004181cULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000623444723cULL, 0x000fee0000041844ULL, 0x0000000000347805ULL, 0x000fe20000015200ULL,
0x0000003d060075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x006fdc0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000c070357836ULL, 0x000fe20000000000ULL,
0x0000940000087ab9ULL, 0x000fc60000000800ULL, 0x000000085a3e7c24ULL, 0x000fe2000f8e0235ULL,
0x0000000000fc9947ULL, 0x000fec0003800000ULL, 0x000000356e347248ULL, 0x000fe20007fe0000ULL,
0x0000001073377824ULL, 0x000fe200078e00ffULL, 0x00000003ff367819ULL, 0x000fe20000011609ULL,
0x0000900000087ab9ULL, 0x000fe40000000a00ULL, 0x0000000134347824ULL, 0x000fe400078e0a35ULL,
0x0000000137357824ULL, 0x000fe400078e0236ULL, 0x00000008363f7836ULL, 0x000fe20000000000ULL,
0x0000003437347248ULL, 0x000fe20007fe0000ULL, 0x00000001353c7824ULL, 0x000fc400078e0209ULL,
0x0000000835417824ULL, 0x000fe400078e00ffULL, 0x0000000134347824ULL, 0x000fe400078e0a37ULL,
0x00000004363d7836ULL, 0x000fe20000000000ULL, 0xfffffff841417812ULL, 0x000fe400078ee23cULL,
0x000000343600720cULL, 0x080fe20003f86070ULL, 0x0000000c36367836ULL, 0x000fe20000000000ULL,
0x000000343f00720cULL, 0x080fe20003f46070ULL, 0x00000001373c7824ULL, 0x000fe200078e023dULL,
0x000000343d00720cULL, 0x080fe20003f66070ULL, 0x00000001373f7824ULL, 0x040fe200078e023fULL,
0x000000343600720cULL, 0x000fe20003f06070ULL, 0x0000000137407824ULL, 0x000fc400078e0236ULL,
0x000000013c367824ULL, 0x140fe400078e0209ULL, 0x000000083c437824ULL, 0x040fe400078e00ffULL,
0x000000013f377824ULL, 0x040fe400078e0209ULL, 0x000000083f427824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee236ULL, 0x0000000135347824ULL, 0x100fe400078e023eULL,
0x000000013c3c7824ULL, 0x100fe200078e023eULL, 0xfffffff8425d7812ULL, 0x000fe200078ee237ULL,
0x000000013f367824ULL, 0x000fc400078e023eULL, 0x00000001403e7824ULL, 0x040fe400078e023eULL,
0x0000000140377824ULL, 0x040fe400078e0209ULL, 0x0000000840407824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff8405f7812ULL, 0x000fe200078ee237ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000006d34347212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006d3c3c7212ULL, 0x080fe400078efcffULL,
0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x000000083c3c7c10ULL, 0x000fe4000ffde0ffULL, 0x0000006d36367212ULL, 0x080fe200078efcffULL,
0x000170006c407836ULL, 0x000fe20000000000ULL, 0x0000006d3e3e7212ULL, 0x000fe400078efcffULL,
0x0000000935357c10ULL, 0x000fe2000affe4ffULL, 0x0000001041417824ULL, 0x100fe200078e0240ULL,
0x000000093d3d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001043437824ULL, 0x100fe200078e0240ULL,
0x0000000836367c10ULL, 0x000fe2000ffbe0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0240ULL,
0x000000083e3e7c10ULL, 0x000fe2000ffde0ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0240ULL,
0x0000000937377c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e2000e101c46ULL, 0x000000093f3f7c10ULL, 0x000fc6000b7fe4ffULL,
0x000000003c437faeULL, 0x0003e8000d901c46ULL, 0x00000000365d7faeULL, 0x0003e8000d101c46ULL,
0x000000003e5f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x0000001073347824ULL, 0x000fe200078e00ffULL, 0x0000900000087ab9ULL, 0x000fc80000000a00ULL,
0x0000003409357211ULL, 0x000fca00078fe8ffULL, 0x0000000135367824ULL, 0x040fe400078e0209ULL,
0x0000000835417824ULL, 0x040fe400078e00ffULL, 0x0000000435377836ULL, 0x000fe40000000000ULL,
0x00000008353f7836ULL, 0x000fe20000000000ULL, 0xfffffff841417812ULL, 0x000fe200078ee236ULL,
0x0000000135347824ULL, 0x000fe400078e023eULL, 0x0000000c35407836ULL, 0x000fc40000000000ULL,
0x0000000137367824ULL, 0x140fe400078e023eULL, 0x00000001373d7824ULL, 0x140fe400078e0209ULL,
0x0000000837427824ULL, 0x000fe400078e00ffULL, 0x000000013f3c7824ULL, 0x040fe400078e023eULL,
0x000000013f377824ULL, 0x040fe200078e0209ULL, 0xfffffff842437812ULL, 0x000fe200078ee23dULL,
0x000000083f5c7824ULL, 0x000fc400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee237ULL, 0x00000001403e7824ULL, 0x000fe200078e023eULL,
0x0000006d34347212ULL, 0x000fe200078efcffULL, 0x00000001403f7824ULL, 0x040fe400078e0209ULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff8405f7812ULL, 0x000fe200078ee23fULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36367212ULL, 0x080fe400078efcffULL,
0x0000000935357c10ULL, 0x000fe200087fe4ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000006d3c3c7212ULL, 0x080fe400078efcffULL, 0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL,
0x000170006c407836ULL, 0x000fe20000000000ULL, 0x0000006d3e3e7212ULL, 0x000fc400078efcffULL,
0x000000083c3c7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0240ULL,
0x000000083e3e7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001043437824ULL, 0x100fe200078e0240ULL,
0x0000000937377c10ULL, 0x000fe200087fe4ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0240ULL,
0x000000093d3d7c10ULL, 0x000fe200097fe4ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0240ULL,
0x000000093f3f7c10ULL, 0x000fe20009ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e8000b901c46ULL, 0x0000000036437faeULL, 0x0003e8000b901c46ULL,
0x000000003c5d7faeULL, 0x0003e8000b901c46ULL, 0x000000003e5f7faeULL, 0x0003e4000b901c46ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0xfffffff06f357812ULL, 0x000fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0x0001a6a835847810ULL, 0x000fc60007ffe008ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a48ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000834848479a7ULL, 0x0002a4000850003fULL,
0x01a64834713479a7ULL, 0x0022e4000850003fULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0xffffffe06f3d7812ULL, 0x040fe400078ec0ffULL, 0x000000106f3c7812ULL, 0x040fe400078ec0ffULL,
0x000000086f3e7812ULL, 0x000fe400078ec0ffULL, 0x000000083c3d7210ULL, 0x000fca0007ffe03dULL,
0x000000013d417824ULL, 0x000fc800078e023eULL, 0x01a64835410075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fce00078e00ffULL,
0x000000103e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x0000003c363f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013d3d7824ULL, 0x000fe200000e0e37ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3c7819ULL, 0x000fc8000001143dULL,
0x0000003f3c3c7211ULL, 0x000fca00078110ffULL, 0x000000ffff3d7224ULL, 0x000fca00000e063dULL,
0x000000023c3c7819ULL, 0x000fc8000000123dULL, 0x0000003c0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013e3e7836ULL, 0x000fce0000000000ULL,
0x01a64835410075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000002077347824ULL, 0x000fe400078e00ffULL, 0x00000001ff3c7424ULL, 0x000fc600078e00ffULL,
0xffffff8034357812ULL, 0x000fc800078ec0ffULL, 0x0000010008347810ULL, 0x000fc80007ffe035ULL,
0x0000003474347210ULL, 0x000fca0007ffe06dULL, 0x01a0000034367984ULL, 0x000ee80000000800ULL,
0x01a2000034357984ULL, 0x0009220000000800ULL, 0x0000007f3600720bULL, 0x008fda0003f1d000ULL,
0x0000000000377806ULL, 0x000fc800000e0100ULL, 0x000000ff3700720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x016fea0003800000ULL, 0x0000000259347836ULL, 0x000fe20000000000ULL,
0x0000007f3600720bULL, 0x0c0fe40003f14000ULL, 0x0000007f363d7209ULL, 0x000fe40007810000ULL,
0x000000773400720cULL, 0x000fd20003f45270ULL, 0x00000000003c7806ULL, 0x000fc800000e0100ULL,
0x000000807734a824ULL, 0x000fe200078e0208ULL, 0x000000ff3c00720cULL, 0x000fc80003f05270ULL,
0x000000347434a210ULL, 0x000fca0007ffe06dULL, 0x01a4003d3400a388ULL, 0x0003e80000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x8000003d7f7f7221ULL, 0x000fe20000010000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b7f7f7820ULL, 0x000fe20000410000ULL, 0x00ff00003cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000003cff7812ULL, 0x000fe2000788c0ffULL, 0x0000007f003e7308ULL, 0x0004ec0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff3f7819ULL, 0x000fca0000011609ULL,
0x00001f3f3e347589ULL, 0x00ae6400000e0000ULL, 0x0000005434547220ULL, 0x042fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000003034307220ULL, 0x040fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000002434247220ULL, 0x040fe20000410000ULL,
0x0000002534257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x00000008093f7811ULL, 0x000fca00078ff0ffULL, 0x00001f3f3e347589ULL, 0x00ae6400000e0000ULL,
0x0000005634567220ULL, 0x042fe20000410000ULL, 0x0000005734577220ULL, 0x040fe20000410000ULL,
0x0000004a344a7220ULL, 0x040fe20000410000ULL, 0x0000004b344b7220ULL, 0x040fe20000410000ULL,
0x0000004e344e7220ULL, 0x040fe20000410000ULL, 0x0000004f344f7220ULL, 0x040fe20000410000ULL,
0x0000005234527220ULL, 0x040fe20000410000ULL, 0x0000005334537220ULL, 0x040fe20000410000ULL,
0x0000003234327220ULL, 0x040fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000002634267220ULL, 0x040fe20000410000ULL, 0x0000002734277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x00000010093f7811ULL, 0x000fca00078ff0ffULL,
0x00001f3f3e347589ULL, 0x00ae6400000e0000ULL, 0x0000000c340c7220ULL, 0x042fe20000410000ULL,
0x0000000d340d7220ULL, 0x040fe20000410000ULL, 0x0000001034107220ULL, 0x040fe20000410000ULL,
0x0000001134117220ULL, 0x040fe20000410000ULL, 0x0000001434147220ULL, 0x040fe20000410000ULL,
0x0000001534157220ULL, 0x040fe20000410000ULL, 0x0000001834187220ULL, 0x040fe20000410000ULL,
0x0000001934197220ULL, 0x040fe20000410000ULL, 0x0000001c341c7220ULL, 0x040fe20000410000ULL,
0x0000001d341d7220ULL, 0x040fe20000410000ULL, 0x0000002034207220ULL, 0x040fe20000410000ULL,
0x0000002134217220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x000fce0000410000ULL, 0x0000003e7d7d7220ULL, 0x008fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x00000018093f7811ULL, 0x000fca00078ff0ffULL,
0x00001f3f3e347589ULL, 0x002e6400000e0000ULL, 0x0000000e340e7220ULL, 0x042fe20000410000ULL,
0x0000000f340f7220ULL, 0x040fe20000410000ULL, 0x0000001234127220ULL, 0x040fe20000410000ULL,
0x0000001334137220ULL, 0x040fe20000410000ULL, 0x0000001634167220ULL, 0x040fe20000410000ULL,
0x0000001734177220ULL, 0x040fe20000410000ULL, 0x0000001a341a7220ULL, 0x040fe20000410000ULL,
0x0000001b341b7220ULL, 0x040fe20000410000ULL, 0x0000001e341e7220ULL, 0x040fe20000410000ULL,
0x0000001f341f7220ULL, 0x040fe20000410000ULL, 0x0000002234227220ULL, 0x040fe20000410000ULL,
0x0000002334237220ULL, 0x040fe20000410000ULL, 0x0000003a343a7220ULL, 0x040fe20000410000ULL,
0x0000003b343b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x000fce0000410000ULL, 0x0000003c37ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff7f7224ULL, 0x004fd400078e003dULL,
0x8000003d36360221ULL, 0x100fe20000010000ULL, 0x000000ffff7f0224ULL, 0x000fe200078e003dULL,
0x00007610ff3c0816ULL, 0x000fe4000000003cULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x004fce0000410000ULL,
0x0000007d357d7221ULL, 0x000fe20000010000ULL, 0x0000000000347805ULL, 0x002fe20000015200ULL,
0x00000083ff0075a7ULL, 0x000ea40008000145ULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x00000083ff0075a7ULL, 0x000e640008000145ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000277717824ULL, 0x040fe200078e00ffULL,
0x000099103c377816ULL, 0x000fe200000000ffULL, 0x0000040077367824ULL, 0x000fe400078e00ffULL,
0x000000086a3f7824ULL, 0x000fe200078e00ffULL, 0x0000000471347812ULL, 0x000fe200078ec0ffULL,
0x0000000876417824ULL, 0x000fe200078e00ffULL, 0x000000ff3700720cULL, 0x000fe20003f05270ULL,
0x000000107a407824ULL, 0x000fe200078e026bULL, 0x0000003409357211ULL, 0x000fe400078fe0ffULL,
0xfffff000363d7812ULL, 0x000fc600078ec0ffULL, 0x000000016a347824ULL, 0x000fe200078e0235ULL,
0x0001400008807810ULL, 0x000fe20007ffe03dULL, 0x0000000176367824ULL, 0x000fc600078e0235ULL,
0xfffffff83f357812ULL, 0x000fe400078ee234ULL, 0xfffffff841377812ULL, 0x000fc600078ee236ULL,
0x00000010353c7824ULL, 0x100fe400078e0280ULL, 0x0000001037377824ULL, 0x000fe200078e0280ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011609ULL,
0x00000004ff00723eULL, 0x000fc600000010ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000347816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x00000018033d7836ULL, 0x000fe40000000000ULL, 0x00001f0534057589ULL, 0x0002a800000e0000ULL,
0x00001f3534027589ULL, 0x0002e800000e0000ULL, 0x00001f0334037589ULL, 0x00026800000e0000ULL,
0x00001f3d34007589ULL, 0x00026400000e0000ULL, 0x000000003c3c783bULL, 0x002e680000000200ULL,
0x000000003734783bULL, 0x000ee20000000200ULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x088fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x084fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x000000107e5c7824ULL, 0x000fe200078e026bULL, 0x000000004040783bULL, 0x000f2a0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x000000ff40627812ULL, 0x010fe400078ec0ffULL,
0x00000010ff897819ULL, 0x000fe40000011643ULL, 0x000000ff43697812ULL, 0x000fc400078ec0ffULL,
0x00000018ff937819ULL, 0x000fe40000011643ULL, 0x0000ffff438b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8a7819ULL, 0x128fe4000001165cULL, 0x000000ff5c947812ULL, 0x040fe400078ec0ffULL,
0x00000018ff437819ULL, 0x000fe4000001165cULL, 0x0000ffff5c867812ULL, 0x000fc400078ec0ffULL,
0x00000062ff66723eULL, 0x000fe400020006ffULL, 0x00000018ff5c7819ULL, 0x100fe4000001165dULL,
0x00000010ff8c7819ULL, 0x000fe2000001165dULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x000000ff5d957812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e627812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001165eULL,
0x00000018ff927819ULL, 0x100fe4000001165fULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff837819ULL, 0x000fe4000001165fULL, 0x000000ff5f637812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f817812ULL, 0x000fc400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005dff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000062ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fe20000011641ULL, 0x2000005fff627230ULL, 0x000fe20000004100ULL,
0x0000ffff418e7812ULL, 0x000fe200078ec0ffULL, 0x20000092ff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fc40000011640ULL, 0x0000ffff408f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff91927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8d7819ULL, 0x000fe40000011642ULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000008ff917819ULL, 0x000fc4000001168fULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000018ff647819ULL, 0x000fe40000011640ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff42687812ULL, 0x040fe400078ec0ffULL,
0x0000ffff42887812ULL, 0x000fc400078ec0ffULL, 0x00000090ff8f723eULL, 0x000fe400020006ffULL,
0x00000091ff90723eULL, 0x000fe200020006ffULL, 0x20000092ff917230ULL, 0x000fe20000004100ULL,
0x000000ff41677812ULL, 0x000fe200078ec0ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000018ff657819ULL, 0x000fe20000011641ULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x0000008dff92723eULL, 0x000fe200020006ffULL, 0x2000008eff8d7230ULL, 0x000fe20000004100ULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x00000068ff42723eULL, 0x000fe200020006ffULL,
0x20000064ff687230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x00000008ff8e7819ULL, 0x000fe2000001168bULL, 0x20000092ff8b7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000042ff647230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fc400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000008eff92723eULL, 0x000fe200020006ffULL, 0x20000088ff8e7230ULL, 0x000fe20000004100ULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fe20000011686ULL,
0x20000092ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe4000001165eULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x00000093ff42723eULL, 0x000fe400020006ffULL,
0x0000ffff5e827812ULL, 0x000fe400078ec0ffULL, 0x00000094ff94723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff8c937812ULL, 0x000fe200078ec0ffULL,
0x20000089ff8c7230ULL, 0x000fe20000004100ULL, 0x00000065ff40723eULL, 0x000fe400020006ffULL,
0x00000069ff65723eULL, 0x000fe200020006ffULL, 0x20000067ff697230ULL, 0x000fe20000004100ULL,
0x00000043ff5e723eULL, 0x000fe200020006ffULL, 0x20000041ff677230ULL, 0x000fe20000004100ULL,
0x0000008aff89723eULL, 0x000fe200020006ffULL, 0x20000094ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff877819ULL, 0x000fe20000011687ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe200020006ffULL, 0x20000089ff897230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000000ff83927812ULL, 0x000fe200078ec0ffULL, 0x20000086ff837230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fc40000011681ULL, 0x00000010ff647819ULL, 0x000fe40000011664ULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000087ff867230ULL, 0x000fe20000004100ULL, 0x00000082ff82723eULL, 0x000fe200020006ffULL,
0x2000007eff877230ULL, 0x000fe20000004100ULL, 0x00000092ff92723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000095ff95723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000093ff8a723eULL, 0x000fe200020006ffULL,
0x20000092ff7e7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000095ff437230ULL, 0x000fe20000004100ULL, 0x000010548b647816ULL, 0x000fe20000000064ULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8b7819ULL, 0x000fe20000011641ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff427819ULL, 0x000fc40000011642ULL,
0x00000010ff417819ULL, 0x000fe40000011688ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff887819ULL, 0x000fe40000011689ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff837819ULL, 0x000fc40000011683ULL,
0x00000010ff937819ULL, 0x000fe40000011668ULL, 0x0000105442417816ULL, 0x000fe40000000041ULL,
0x00000010ff897819ULL, 0x000fe4000001165cULL, 0x000010548f687816ULL, 0x000fe40000000066ULL,
0x0000105488427816ULL, 0x000fe4000000008bULL, 0x000010545e5c7816ULL, 0x000fc40000000083ULL,
0x00000010ff8f7819ULL, 0x000fe40000011667ULL, 0x00000010ff887819ULL, 0x000fe4000001165dULL,
0x00000010ff837819ULL, 0x000fe40000011662ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff677819ULL, 0x000fe4000001168dULL, 0x00000010ff5d7819ULL, 0x000fc40000011686ULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fe40000011682ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff697819ULL, 0x000fe40000011669ULL,
0x00000010ff927819ULL, 0x000fe40000011691ULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff867819ULL, 0x000fc40000011687ULL,
0x00000010ff827819ULL, 0x000fe4000001165fULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x0000105440677816ULL, 0x000fe40000000067ULL, 0x000010547e5f7816ULL, 0x000fe40000000063ULL,
0x0000105492697816ULL, 0x000fe40000000069ULL, 0x0000105493667816ULL, 0x000fc40000000090ULL,
0x000010548c657816ULL, 0x000fe40000000065ULL, 0x000010548f407816ULL, 0x000fe2000000008eULL,
0x000000683c54723cULL, 0x002fe20000041854ULL, 0x000010548a437816ULL, 0x000fe40000000043ULL,
0x00001054885d7816ULL, 0x000fe4000000005dULL, 0x00001054865e7816ULL, 0x000fe20000000089ULL,
0x000000663c48723cULL, 0x000fe20000041848ULL, 0x0000105483627816ULL, 0x000fc40000000062ULL,
0x0000105482637816ULL, 0x000fc60000000081ULL, 0x000000643c4c723cULL, 0x000fec000004184cULL,
0x000000403c50723cULL, 0x000fec0000041850ULL, 0x000000423c30723cULL, 0x000fec0000041830ULL,
0x0000005c3c2c723cULL, 0x000fec000004182cULL, 0x0000005e3c28723cULL, 0x000fec0000041828ULL,
0x000000623c24723cULL, 0x000fec0000041824ULL, 0x00000068340c723cULL, 0x000fe2000004180cULL,
0x000000107b3c7824ULL, 0x000fc400078e0280ULL, 0x0000001075807824ULL, 0x000fc600078e0280ULL,
0x000000663410723cULL, 0x000fe20000041810ULL, 0x000000003c3c783bULL, 0x000e6a0000000200ULL,
0x000000643414723cULL, 0x000fec0000041814ULL, 0x000000403418723cULL, 0x000fec0000041818ULL,
0x00000042341c723cULL, 0x000fe2000004181cULL, 0x0000001078407824ULL, 0x000fca00078e026bULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000623444723cULL, 0x000fe20000041844ULL, 0x000000008034783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x000000033c3c7232ULL, 0x082fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x084fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x000000107c5c7824ULL, 0x000fe200078e026bULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0xfffffff871717812ULL, 0x000fc800078ec0ffULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x0000000108717824ULL, 0x000fe200078e0271ULL, 0x000000ff40627812ULL, 0x010fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x100fe40000011641ULL, 0x000000ff41667812ULL, 0x040fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fe40000011641ULL, 0x0000ffff418c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff8b7819ULL, 0x100fe40000011642ULL, 0x000000ff42677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011642ULL, 0x0000ffff42837812ULL, 0x000fe400078ec0ffULL,
0x00000010ff867819ULL, 0x000fe40000011643ULL, 0x000000ff43687812ULL, 0x000fc400078ec0ffULL,
0x00000018ff427819ULL, 0x000fe40000011643ULL, 0x0000ffff43887812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x128fe4000001165cULL, 0x000000ff5c917812ULL, 0x040fe400078ec0ffULL,
0x00000018ff437819ULL, 0x000fe4000001165cULL, 0x0000ffff5c827812ULL, 0x000fc400078ec0ffULL,
0x00000062ff69723eULL, 0x000fe400020006ffULL, 0x00000018ff5c7819ULL, 0x100fe4000001165dULL,
0x00000010ff8a7819ULL, 0x000fe2000001165dULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x000000ff5d927812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5d877812ULL, 0x000fe400078ec0ffULL,
0x000000ff5e627812ULL, 0x000fc400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001165eULL,
0x00000018ff907819ULL, 0x100fe4000001165fULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000010ff817819ULL, 0x000fe4000001165fULL, 0x000000ff5f637812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f7e7812ULL, 0x000fc400078ec0ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x0000005dff5f723eULL, 0x000fe200020006ffULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000062ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff8f7819ULL, 0x000fe20000011640ULL, 0x2000005fff627230ULL, 0x000fe20000004100ULL,
0x0000ffff408d7812ULL, 0x000fe200078ec0ffULL, 0x20000090ff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL, 0x000000ff8e907812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8c7819ULL, 0x000fe4000001168cULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168dULL, 0x0000008fff8d723eULL, 0x000fe400020006ffULL,
0x00000018ff647819ULL, 0x000fc40000011640ULL, 0x00000090ff8f723eULL, 0x000fe200020006ffULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x0000008bff90723eULL, 0x000fe200020006ffULL, 0x2000008fff8f7230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000008cff8b7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x20000090ff8c7230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fc40000011683ULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000065ff40723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x000000ff89907812ULL, 0x000fe200078ec0ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000068ff65723eULL, 0x000fe200020006ffULL, 0x20000064ff687230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000067ff647230ULL, 0x000fe20000004100ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x20000041ff677230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe2000001165eULL, 0x20000091ff417230ULL, 0x000fe20000004100ULL,
0x000000ff8a917812ULL, 0x000fe200078ec0ffULL, 0x20000083ff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x00000008ff837819ULL, 0x000fe20000011687ULL, 0x20000090ff877230ULL, 0x000fe20000004100ULL,
0x000000ff7c7c7812ULL, 0x000fc400078ec0ffULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x000000ff81907812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000082ff817230ULL, 0x000fe20000004100ULL, 0x00000008ff887819ULL, 0x000fe20000011688ULL,
0x20000083ff827230ULL, 0x000fe20000004100ULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x2000007cff837230ULL, 0x000fe20000004100ULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x0000ffff5e807812ULL, 0x000fe200078ec0ffULL, 0x20000086ff897230ULL, 0x000fe20000004100ULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x20000090ff7c7230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000008ff807819ULL, 0x000fe20000011680ULL,
0x20000088ff867230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x20000091ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fc40000011666ULL,
0x00000010ff667819ULL, 0x000fe2000001168eULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe40000011665ULL, 0x00000043ff5e723eULL, 0x000fe400020006ffULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fc4000001168cULL,
0x00000010ff897819ULL, 0x000fe40000011689ULL, 0x00000008ff917819ULL, 0x000fe2000001167eULL,
0x20000080ff7e7230ULL, 0x000fe20000004100ULL, 0x0000105465647816ULL, 0x000fe40000000064ULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000105489657816ULL, 0x000fe4000000008eULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000091ff80723eULL, 0x000fc400020006ffULL, 0x00000010ff897819ULL, 0x000fe20000011641ULL,
0x20000092ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe20000011686ULL,
0x000000643c4c723cULL, 0x002fe2000004184cULL, 0x00000010ff867819ULL, 0x000fe40000011687ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x000000643414723cULL, 0x004fe20000041814ULL, 0x0000105442417816ULL, 0x000fc40000000041ULL,
0x00000010ff917819ULL, 0x000fe40000011668ULL, 0x0000105486427816ULL, 0x000fe40000000089ULL,
0x00000010ff687819ULL, 0x000fe4000001168dULL, 0x00000010ff867819ULL, 0x000fe4000001165dULL,
0x00000010ff877819ULL, 0x000fe4000001165cULL, 0x00000010ff8d7819ULL, 0x000fc40000011667ULL,
0x00000010ff5d7819ULL, 0x000fe40000011682ULL, 0x000010545e5c7816ULL, 0x000fe40000000081ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff407819ULL, 0x000fe40000011640ULL,
0x00000010ff677819ULL, 0x000fe4000001168bULL, 0x00000010ff827819ULL, 0x000fc40000011683ULL,
0x00000010ff817819ULL, 0x000fe40000011662ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff437819ULL, 0x000fc40000011643ULL,
0x00000010ff887819ULL, 0x000fe40000011688ULL, 0x00000010ff627819ULL, 0x000fe4000001167eULL,
0x00000010ff837819ULL, 0x000fe4000001165fULL, 0x00000010ff807819ULL, 0x000fe40000011680ULL,
0x0000105468687816ULL, 0x000fe40000000069ULL, 0x0000105440677816ULL, 0x000fc40000000067ULL,
0x000010547c5f7816ULL, 0x000fe40000000063ULL, 0x000010548f697816ULL, 0x000fe40000000090ULL,
0x0000105491667816ULL, 0x000fe40000000066ULL, 0x000010548d407816ULL, 0x000fe4000000008aULL,
0x0000105488437816ULL, 0x000fe20000000043ULL, 0x000000683c54723cULL, 0x000fe20000041854ULL,
0x00001054865d7816ULL, 0x000fc4000000005dULL, 0x00001054825e7816ULL, 0x000fe40000000087ULL,
0x0000105481627816ULL, 0x000fe20000000062ULL, 0x000000663c48723cULL, 0x000fe20000041848ULL,
0x0000105483637816ULL, 0x000fca0000000080ULL, 0x000000403c50723cULL, 0x000fec0000041850ULL,
0x000000423c30723cULL, 0x000fec0000041830ULL, 0x0000005c3c2c723cULL, 0x000fec000004182cULL,
0x0000005e3c28723cULL, 0x000fec0000041828ULL, 0x000000623c24723cULL, 0x000fec0000041824ULL,
0x00000068340c723cULL, 0x000fe2000004180cULL, 0x00000008613c7824ULL, 0x000fc400078e0208ULL,
0x00000001ff3e7424ULL, 0x000fc600078e00ffULL, 0x000000663410723cULL, 0x000fe20000041810ULL,
0x01a6c83e3c3c79a7ULL, 0x000e6a000850003fULL, 0x000000403418723cULL, 0x000fe20000041818ULL,
0x01a6983e71ff79a7ULL, 0x0005ea000850003fULL, 0x00000042341c723cULL, 0x000fec000004181cULL,
0x0000005c3420723cULL, 0x000fec0000041820ULL, 0x0000005e3438723cULL, 0x000fec0000041838ULL,
0x000000623444723cULL, 0x000fee0000041844ULL, 0x0000000000347805ULL, 0x000fe20000015200ULL,
0x0000003d060075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x006fdc0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x0000003d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000158357836ULL, 0x000fca0000000000ULL,
0x000000603500720cULL, 0x000fda0003f06070ULL, 0x0000000400d40947ULL, 0x000fea0003800000ULL,
0x0000000258357836ULL, 0x000fe20000000000ULL, 0x0000940000087ab9ULL, 0x000fc80000000800ULL,
0x000000603500720cULL, 0x000fe20003f06070ULL, 0x0000010070357836ULL, 0x000fc80000000000ULL,
0x000000085a3f7c24ULL, 0x000fd0000f8e0235ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x000000356e347248ULL, 0x000fe20007fe0000ULL, 0x0000001073377824ULL, 0x000fe200078e00ffULL,
0x00000003ff367819ULL, 0x000fe20000011609ULL, 0x0000900000087ab9ULL, 0x000fe40000000a00ULL,
0x0000000134347824ULL, 0x000fe400078e0a35ULL, 0x00000001373c7824ULL, 0x000fe400078e0236ULL,
0x00000004363d7836ULL, 0x000fe20000000000ULL, 0x0000003437347248ULL, 0x000fe20007fe0000ULL,
0x000000013c357824ULL, 0x000fc400078e0209ULL, 0x000000083c407824ULL, 0x000fe400078e00ffULL,
0x0000000134347824ULL, 0x000fe400078e0a37ULL, 0x00000001373e7824ULL, 0x000fe200078e023dULL,
0xfffffff840407812ULL, 0x000fe200078ee235ULL, 0x0000000836357836ULL, 0x000fe20000000000ULL,
0x000000343600720cULL, 0x080fe20003f86070ULL, 0x0000000c36367836ULL, 0x000fe20000000000ULL,
0x000000343d00720cULL, 0x080fe20003f66070ULL, 0x00000001375c7824ULL, 0x000fe200078e0235ULL,
0x000000343500720cULL, 0x080fe20003f46070ULL, 0x0000000137627824ULL, 0x000fe200078e0236ULL,
0x000000343600720cULL, 0x000fe20003f06070ULL, 0x000000013e347824ULL, 0x000fc400078e0209ULL,
0x000000083e377824ULL, 0x000fe400078e00ffULL, 0x000000013c367824ULL, 0x100fe400078e023fULL,
0x000000013e3c7824ULL, 0x000fe200078e023fULL, 0xfffffff837427812ULL, 0x000fe200078ee234ULL,
0x000000015c357824ULL, 0x040fe400078e0209ULL, 0x000000085c5e7824ULL, 0x000fe400078e00ffULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff85e5e7812ULL, 0x000fe200078ee235ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x0000006d36367212ULL, 0x000fc600078efcffULL,
0x000000015c347824ULL, 0x100fe200078e023fULL, 0x0000006d3c3c7212ULL, 0x080fe200078efcffULL,
0x00000001623e7824ULL, 0x000fe200078e023fULL, 0x0000000836367c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000000083c3c7c10ULL, 0x000fe4000ffde0ffULL,
0x0000000937377c10ULL, 0x000fe2000affe4ffULL, 0x000000803e3e7825ULL, 0x000fe200078e00ffULL,
0x0000006d34347212ULL, 0x080fe400078efcffULL, 0x000000093d3d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000162417824ULL, 0x000fe200078e0209ULL, 0x0000006d3e3e7212ULL, 0x000fe200078efcffULL,
0x00000008625c7824ULL, 0x000fe200078e00ffULL, 0x0000000834347c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001042437824ULL, 0x100fe200078e026bULL, 0x000000083e3e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000105e5d7824ULL, 0x100fe200078e026bULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee241ULL,
0x0000001040417824ULL, 0x000fe200078e026bULL, 0x0000000935357c10ULL, 0x000fc4000affe4ffULL,
0x000000093f3f7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000105c6b7824ULL, 0x000fe200078e026bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036417faeULL, 0x0003e8000e101c46ULL,
0x000000003c437faeULL, 0x0003e8000d901c46ULL, 0x00000000345d7faeULL, 0x0003e8000d101c46ULL,
0x000000003e6b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001073347824ULL, 0x000fe200078e00ffULL, 0x0000900000087ab9ULL, 0x000fc80000000a00ULL,
0x0000003409367211ULL, 0x000fca00078fe8ffULL, 0x0000000136357824ULL, 0x040fe400078e0209ULL,
0x0000000836407824ULL, 0x040fe400078e00ffULL, 0x00000004363c7836ULL, 0x000fe40000000000ULL,
0x0000000836427836ULL, 0x000fe20000000000ULL, 0xfffffff840407812ULL, 0x000fe200078ee235ULL,
0x0000000c365c7836ULL, 0x000fe40000000000ULL, 0x0000000136347824ULL, 0x000fc400078e023fULL,
0x000000013c367824ULL, 0x040fe400078e023fULL, 0x000000013c377824ULL, 0x040fe400078e0209ULL,
0x000000083c5e7824ULL, 0x000fe400078e00ffULL, 0x00000001423e7824ULL, 0x100fe400078e023fULL,
0x000000015c3c7824ULL, 0x000fe400078e023fULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x000000015c3f7824ULL, 0x100fe200078e0209ULL, 0x0000006d34347212ULL, 0x080fe200078efcffULL,
0x000000085c647824ULL, 0x000fe400078e00ffULL, 0x00000001423d7824ULL, 0x040fe200078e0209ULL,
0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000842627824ULL, 0x000fe200078e00ffULL,
0xfffffff85e427812ULL, 0x000fe200078ee237ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff8645e7812ULL, 0x000fe400078ee23fULL, 0xfffffff8625c7812ULL, 0x000fe200078ee23dULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x0000006d36367212ULL, 0x000fc400078efcffULL,
0x0000000935357c10ULL, 0x000fe200087fe4ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000006d3e3e7212ULL, 0x080fe400078efcffULL, 0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001040417824ULL, 0x100fe200078e026bULL, 0x0000006d3c3c7212ULL, 0x000fe200078efcffULL,
0x0000001042437824ULL, 0x100fe200078e026bULL, 0x000000083e3e7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0x000000083c3c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000105e6b7824ULL, 0x000fe200078e026bULL, 0x0000000937377c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x000000093f3f7c10ULL, 0x000fc400097fe4ffULL, 0x000000093d3d7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000036437faeULL, 0x0003e8000b901c46ULL, 0x000000003e5d7faeULL, 0x0003e8000b901c46ULL,
0x000000003c6b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000003cff8079a7ULL, 0x0002a40008500005ULL,
0x01a6683c073c79a7ULL, 0x0022e4000850003fULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x01a6683d070075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x00000036343f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003f36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a6683d070075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x0000008059347824ULL, 0x000fe400078e0208ULL,
0x00000001ff3c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff7c7224ULL, 0x000fe200078e007fULL,
0x000001806d357810ULL, 0x000fca0007ffe034ULL, 0x0000000174357824ULL, 0x000fca00078e0235ULL,
0x01a0000035347984ULL, 0x000ee80000000800ULL, 0x01a2000035367984ULL, 0x0009220000000800ULL,
0x0000007f3400720bULL, 0x008fda0003f1d000ULL, 0x0000000000377806ULL, 0x000fc800000e0100ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x0000000400908947ULL, 0x016fea0003800000ULL,
0x00000003593e7836ULL, 0x000fe20000000000ULL, 0x0000007f3400720bULL, 0x0c0fe40003f14000ULL,
0x0000007f347c7209ULL, 0x000fe40007810000ULL, 0x000000773e00720cULL, 0x000fd20003f45270ULL,
0x00000000003e7806ULL, 0x000fc800000e0100ULL, 0x000000807735a824ULL, 0x000fe200078e0208ULL,
0x000000ff3e00720cULL, 0x000fc80003f05270ULL, 0x000000357435a210ULL, 0x000fca0007ffe06dULL,
0x01a4007c3500a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x0000007f7c357221ULL, 0x002fe20000010100ULL, 0x000000ff3eff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff003eff7812ULL, 0x040fe2000784c0ffULL, 0x3fb8aa3b35357820ULL, 0x000fe20000410000ULL,
0x00ff00003eff7812ULL, 0x040fe4000786c0ffULL, 0xff0000003eff7812ULL, 0x000fe2000788c0ffULL,
0x0000003500407308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff357819ULL, 0x002fcc0000011609ULL, 0x00001f3540357589ULL, 0x004e6400000e0000ULL,
0x0000005435547220ULL, 0x042fe20000410000ULL, 0x0000005535557220ULL, 0x040fe20000410000ULL,
0x0000004835487220ULL, 0x040fe20000410000ULL, 0x0000004935497220ULL, 0x040fe20000410000ULL,
0x0000004c354c7220ULL, 0x040fe20000410000ULL, 0x0000004d354d7220ULL, 0x040fe20000410000ULL,
0x0000005035507220ULL, 0x040fe20000410000ULL, 0x0000005135517220ULL, 0x040fe20000410000ULL,
0x0000003035307220ULL, 0x040fe20000410000ULL, 0x0000003135317220ULL, 0x040fe20000410000ULL,
0x0000002c352c7220ULL, 0x040fe20000410000ULL, 0x0000002d352d7220ULL, 0x040fe20000410000ULL,
0x0000002835287220ULL, 0x040fe20000410000ULL, 0x0000002935297220ULL, 0x040fe20000410000ULL,
0x0000002435247220ULL, 0x040fe20000410000ULL, 0x0000002535257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000000809357811ULL, 0x002fcc00078ff0ffULL,
0x00001f3540357589ULL, 0x004e6400000e0000ULL, 0x0000005635567220ULL, 0x042fe20000410000ULL,
0x0000005735577220ULL, 0x040fe20000410000ULL, 0x0000004a354a7220ULL, 0x040fe20000410000ULL,
0x0000004b354b7220ULL, 0x040fe20000410000ULL, 0x0000004e354e7220ULL, 0x040fe20000410000ULL,
0x0000004f354f7220ULL, 0x040fe20000410000ULL, 0x0000005235527220ULL, 0x040fe20000410000ULL,
0x0000005335537220ULL, 0x040fe20000410000ULL, 0x0000003235327220ULL, 0x040fe20000410000ULL,
0x0000003335337220ULL, 0x040fe20000410000ULL, 0x0000002e352e7220ULL, 0x040fe20000410000ULL,
0x0000002f352f7220ULL, 0x040fe20000410000ULL, 0x0000002a352a7220ULL, 0x040fe20000410000ULL,
0x0000002b352b7220ULL, 0x040fe20000410000ULL, 0x0000002635267220ULL, 0x040fe20000410000ULL,
0x0000002735277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x0000001009357811ULL, 0x002fcc00078ff0ffULL, 0x00001f3540357589ULL, 0x004e6400000e0000ULL,
0x0000000c350c7220ULL, 0x042fe20000410000ULL, 0x0000000d350d7220ULL, 0x040fe20000410000ULL,
0x0000001035107220ULL, 0x040fe20000410000ULL, 0x0000001135117220ULL, 0x040fe20000410000ULL,
0x0000001435147220ULL, 0x040fe20000410000ULL, 0x0000001535157220ULL, 0x040fe20000410000ULL,
0x0000001835187220ULL, 0x040fe20000410000ULL, 0x0000001935197220ULL, 0x040fe20000410000ULL,
0x0000001c351c7220ULL, 0x040fe20000410000ULL, 0x0000001d351d7220ULL, 0x040fe20000410000ULL,
0x0000002035207220ULL, 0x040fe20000410000ULL, 0x0000002135217220ULL, 0x040fe20000410000ULL,
0x0000003835387220ULL, 0x040fe20000410000ULL, 0x0000003935397220ULL, 0x040fe20000410000ULL,
0x0000004435447220ULL, 0x040fe20000410000ULL, 0x0000004535457220ULL, 0x000fce0000410000ULL,
0x000000407d7d7220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x0000001809357811ULL, 0x002fcc00078ff0ffULL, 0x00001f3540357589ULL, 0x000e6400000e0000ULL,
0x0000000e350e7220ULL, 0x042fe20000410000ULL, 0x0000000f350f7220ULL, 0x040fe20000410000ULL,
0x0000001235127220ULL, 0x040fe20000410000ULL, 0x0000001335137220ULL, 0x040fe20000410000ULL,
0x0000001635167220ULL, 0x040fe20000410000ULL, 0x0000001735177220ULL, 0x040fe20000410000ULL,
0x0000001a351a7220ULL, 0x040fe20000410000ULL, 0x0000001b351b7220ULL, 0x040fe20000410000ULL,
0x0000001e351e7220ULL, 0x040fe20000410000ULL, 0x0000001f351f7220ULL, 0x040fe20000410000ULL,
0x0000002235227220ULL, 0x040fe20000410000ULL, 0x0000002335237220ULL, 0x040fe20000410000ULL,
0x0000003a353a7220ULL, 0x040fe20000410000ULL, 0x0000003b353b7220ULL, 0x040fe20000410000ULL,
0x0000004635467220ULL, 0x040fe20000410000ULL, 0x0000004735477220ULL, 0x000fce0000410000ULL,
0x0000003e37ff7212ULL, 0x000fda00078030ffULL, 0x000000347c340221ULL, 0x000fe20000010100ULL,
0x00007610ff3c0816ULL, 0x000fc6000000003cULL, 0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL,
0x0000003400040308ULL, 0x000ea40000000800ULL, 0x0000000436360220ULL, 0x004fce0000410000ULL,
0x0000007d367d7221ULL, 0x000fe20000010000ULL, 0x0000000000347805ULL, 0x002fe40000015200ULL,
0xfffffff06f377812ULL, 0x000fca00078ec0ffULL, 0x00000001083f7824ULL, 0x000fc800078e0237ULL,
0x01a6b0853f0075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff3e7224ULL, 0x000fce00078e00ffULL, 0x000000103e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x00000036343d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff367819ULL, 0x000fc80000011437ULL, 0x0000003d36367211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000236367819ULL, 0x000fc80000001237ULL,
0x000000360000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013e3e7836ULL, 0x000fce0000000000ULL, 0x01a6b0853f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000161357812ULL, 0x000fe200078ec0ffULL,
0x000000086a377824ULL, 0x000fe200078e00ffULL, 0x00000004ff347819ULL, 0x000fe20000011609ULL,
0x000170006c7f7836ULL, 0x000fe20000000000ULL, 0x000099103c367816ULL, 0x000fe200000000ffULL,
0x00000008763c7824ULL, 0x000fe400078e00ffULL, 0x0000000435357824ULL, 0x000fe200078e0234ULL,
0x000000ff3600720cULL, 0x000fe20003f05270ULL, 0x0000100059367824ULL, 0x000fe400078e0208ULL,
0x000000016a347824ULL, 0x000fc400078e0235ULL, 0x0000000176357824ULL, 0x000fe400078e0235ULL,
0x0001500036627836ULL, 0x000fe20000000000ULL, 0xfffffff837347812ULL, 0x000fe200078ee234ULL,
0x0000000477377824ULL, 0x000fe200078e00ffULL, 0xfffffff83c357812ULL, 0x000fe200078ee235ULL,
0x000000107a367824ULL, 0x000fe400078e027fULL, 0x0000001034347824ULL, 0x100fe200078e0262ULL,
0x0000000437377812ULL, 0x000fe200078ec0ffULL, 0x0000001035357824ULL, 0x000fc600078e0262ULL,
0x00000002373c7812ULL, 0x000fe200078efcffULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe40000011609ULL, 0x00000004ff00723eULL, 0x000fc600000010ffULL,
0x000000083e027836ULL, 0x000fe20000000000ULL, 0x0000541000377816ULL, 0x000fe20000000000ULL,
0x000000103e407836ULL, 0x000fe40000000000ULL, 0x000000183e427836ULL, 0x000fe40000000000ULL,
0x00001f0237027589ULL, 0x0002a800000e0000ULL, 0x00001f4037057589ULL, 0x0002e800000e0000ULL,
0x00001f3e37037589ULL, 0x00026800000e0000ULL, 0x00001f4237007589ULL, 0x00026400000e0000ULL,
0x00000000345c783bULL, 0x0006a80000000200ULL, 0x000000003540783bULL, 0x0026620000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x000000035c5c7232ULL, 0x084fe40000200000ULL,
0x000000035e5e7232ULL, 0x000fe40000200000ULL, 0x000000025d5d7232ULL, 0x080fe40000200000ULL,
0x000000025f5f7232ULL, 0x000fe40000200000ULL, 0x0000000540407232ULL, 0x08afe40000200000ULL,
0x0000000542427232ULL, 0x000fc40000200000ULL, 0x0000000041417232ULL, 0x080fe40000200000ULL,
0x0000000043437232ULL, 0x000fce0000200000ULL, 0x0000003c09837211ULL, 0x000fe200078fe0ffULL,
0x000000086a3d7824ULL, 0x040fe200078e00ffULL, 0x000000003634783bULL, 0x008ee20000004200ULL,
0x000000107b7b7824ULL, 0x100fe400078e0262ULL, 0x000000016a6a7824ULL, 0x000fe400078e0283ULL,
0x00000010757a7824ULL, 0x000fc600078e0262ULL, 0xfffffff83d6a7812ULL, 0x000fca00078ee26aULL,
0x000000106a3c7824ULL, 0x000fcc00078e027fULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x00000018ff647819ULL, 0x108fe40000011635ULL, 0x000000ff34637812ULL, 0x000fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011634ULL, 0x00000010ff867819ULL, 0x000fe40000011635ULL,
0x000000ff35657812ULL, 0x040fe400078ec0ffULL, 0x0000ffff35857812ULL, 0x000fc400078ec0ffULL,
0x00000010ff877819ULL, 0x000fe40000011634ULL, 0x00000018ff357819ULL, 0x100fe40000011636ULL,
0x00000010ff807819ULL, 0x000fe40000011637ULL, 0x00000010ff7e7819ULL, 0x000fe40000011636ULL,
0x00000010ff6c7819ULL, 0x010fe4000001163cULL, 0x000000ff36667812ULL, 0x000fc400078ec0ffULL,
0x0000ffff36827812ULL, 0x000fe400078ec0ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x00000010ff707819ULL, 0x000fe4000001163dULL, 0x0000ffff34347812ULL, 0x000fe200078ec0ffULL,
0x20000064ff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff37887812ULL, 0x000fe400078ec0ffULL,
0x00000018ff367819ULL, 0x000fc40000011637ULL, 0x0000ffff37847812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000018ff8d7819ULL, 0x000fe2000001163fULL, 0x20000063ff697230ULL, 0x000fe20000004100ULL,
0x000000ff3c897812ULL, 0x000fe200078ec0ffULL, 0x20000062ff6a7230ULL, 0x000fe20000004100ULL,
0x00000018ff377819ULL, 0x000fc4000001163cULL, 0x0000ffff3c717812ULL, 0x000fe400078ec0ffULL,
0x00000035ff35723eULL, 0x000fe400020006ffULL, 0x000000ff87877812ULL, 0x000fe400078ec0ffULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000035ff637230ULL, 0x000fe20000004100ULL,
0x000000ff3d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001163dULL,
0x0000ffff3d757812ULL, 0x000fe400078ec0ffULL, 0x00000010ff747819ULL, 0x100fe4000001163eULL,
0x000000ff3e8c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e687812ULL, 0x000fe400078ec0ffULL, 0x000000ff80807812ULL, 0x000fc400078ec0ffULL,
0x00000010ff3d7819ULL, 0x000fe4000001163fULL, 0x000000ff3f3e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x000000ff70707812ULL, 0x000fe400078ec0ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000008ff347819ULL, 0x000fc40000011634ULL,
0x0000ffff3f6d7812ULL, 0x000fe400078ec0ffULL, 0x00000089ff64723eULL, 0x000fe400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000088ff62723eULL, 0x000fc400020006ffULL, 0x00000037ff37723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe20000011685ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x000000ff74747812ULL, 0x000fe400078ec0ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000003eff35723eULL, 0x000fe200020006ffULL,
0x20000037ff3e7230ULL, 0x000fe20000004100ULL, 0x00000086ff88723eULL, 0x000fe200020006ffULL,
0x20000065ff677230ULL, 0x000fe20000004100ULL, 0x00000008ff827819ULL, 0x000fe20000011682ULL,
0x20000035ff377230ULL, 0x000fe20000004100ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000088ff857230ULL, 0x000fe20000004100ULL, 0x000000ff3d3d7812ULL, 0x000fc400078ec0ffULL,
0x00000036ff36723eULL, 0x000fe400020006ffULL, 0x00000034ff86723eULL, 0x000fe200020006ffULL,
0x2000008dff347230ULL, 0x000fe20000004100ULL, 0x00000008ff757819ULL, 0x000fe20000011675ULL,
0x2000006cff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fe20000011668ULL,
0x20000036ff657230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x0000008aff3f723eULL, 0x000fe200020006ffULL,
0x20000087ff8a7230ULL, 0x000fe20000004100ULL, 0x00000008ff847819ULL, 0x000fe20000011684ULL,
0x20000080ff877230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000070ff807230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000089ff89723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000008ff717819ULL, 0x000fc40000011671ULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x0000003dff6c723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000068ff3d723eULL, 0x000fe200020006ffULL, 0x2000006cff687230ULL, 0x000fe20000004100ULL,
0x0000008bff35723eULL, 0x000fe200020006ffULL, 0x2000007eff8b7230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000074ff7e7230ULL, 0x000fe20000004100ULL,
0x0000006dff70723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x0000008cff36723eULL, 0x000fe200020006ffULL, 0x20000089ff8c7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000082ff897230ULL, 0x000fe20000004100ULL,
0x00000010ff747819ULL, 0x000fe20000011669ULL, 0x20000075ff827230ULL, 0x000fe20000004100ULL,
0x00000010ff757819ULL, 0x000fe20000011667ULL, 0x2000003dff697230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe2000001168aULL, 0x20000084ff887230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe2000001166aULL, 0x20000070ff3d7230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe20000011666ULL, 0x20000071ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe20000011686ULL, 0x20000036ff367230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fc400020006ffULL, 0x00000010ff6a7819ULL, 0x000fe4000001166bULL,
0x00000010ff667819ULL, 0x000fe20000011685ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe4000001168cULL, 0x000010546d747816ULL, 0x000fe40000000074ULL,
0x0000105467707816ULL, 0x000fe40000000070ULL, 0x0000105466757816ULL, 0x000fc40000000075ULL,
0x000010546a717816ULL, 0x000fe40000000071ULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff677819ULL, 0x000fe20000011664ULL, 0x00000074400c723cULL, 0x002fe2000004180cULL,
0x00000010ff6d7819ULL, 0x000fe40000011687ULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff667819ULL, 0x000fe20000011665ULL, 0x000000704010723cULL, 0x000fe20000041810ULL,
0x00000010ff647819ULL, 0x000fc40000011689ULL, 0x00000010ff6a7819ULL, 0x000fe4000001168dULL,
0x00000010ff657819ULL, 0x000fe20000011688ULL, 0x000000745c54723cULL, 0x004fe20000041854ULL,
0x000010546d6d7816ULL, 0x000fe40000000062ULL, 0x0000105463647816ULL, 0x000fe40000000064ULL,
0x000010546a627816ULL, 0x000fe20000000067ULL, 0x000000705c48723cULL, 0x000fe20000041848ULL,
0x0000105466657816ULL, 0x000fc40000000065ULL, 0x00000010ff637819ULL, 0x000fe4000001163fULL,
0x00000010ff3c7819ULL, 0x000fe4000001163cULL, 0x00000010ff677819ULL, 0x000fe20000011682ULL,
0x000000644018723cULL, 0x000fe20000041818ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163eULL,
0x00000010ff667819ULL, 0x000fe40000011684ULL, 0x000010543c677816ULL, 0x000fe20000000067ULL,
0x000000645c50723cULL, 0x000fe20000041850ULL, 0x000010543f667816ULL, 0x000fc40000000066ULL,
0x00000010ff3c7819ULL, 0x000fe40000011637ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff807819ULL, 0x000fe20000011680ULL, 0x000000664020723cULL, 0x000fe20000041820ULL,
0x00000010ff367819ULL, 0x000fe40000011636ULL, 0x00000010ff377819ULL, 0x000fe4000001167eULL,
0x00000010ff3f7819ULL, 0x000fe20000011668ULL, 0x000000665c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff6a7819ULL, 0x000fe40000011669ULL,
0x00000010ff7e7819ULL, 0x000fe40000011634ULL, 0x00000010ff6b7819ULL, 0x000fe4000001163dULL,
0x000010548b6c7816ULL, 0x000fe4000000006cULL, 0x0000105480637816ULL, 0x000fe40000000063ULL,
0x0000105437687816ULL, 0x000fc40000000036ULL, 0x000010543f697816ULL, 0x000fe2000000003cULL,
0x0000006c4014723cULL, 0x000fe20000041814ULL, 0x00001054356a7816ULL, 0x000fe2000000006aULL,
0x000000007b3c783bULL, 0x0002620000000200ULL, 0x000010547e6b7816ULL, 0x000fc6000000006bULL,
0x00000062401c723cULL, 0x000fe2000004181cULL, 0x000000007a34783bULL, 0x0002ea0000000200ULL,
0x000000684038723cULL, 0x000fec0000041838ULL, 0x0000006c5c4c723cULL, 0x000fec000004184cULL,
0x000000625c30723cULL, 0x000fec0000041830ULL, 0x000000685c28723cULL, 0x000fec0000041828ULL,
0x0000006a5c24723cULL, 0x000fec0000041824ULL, 0x0000006a4040723cULL, 0x000fe20000041844ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x002fde0003800000ULL,
0x000000033c3c7232ULL, 0x080fe40000200000ULL, 0x000000033e3e7232ULL, 0x000fe40000200000ULL,
0x000000023d3d7232ULL, 0x080fe40000200000ULL, 0x000000023f3f7232ULL, 0x000fe40000200000ULL,
0x0000000534347232ULL, 0x088fe40000200000ULL, 0x0000000536367232ULL, 0x000fc40000200000ULL,
0x0000000035357232ULL, 0x080fe40000200000ULL, 0x0000000037377232ULL, 0x000fce0000200000ULL,
0x0000000176837824ULL, 0x040fe400078e0283ULL, 0x00000008765c7824ULL, 0x000fe400078e00ffULL,
0x0000001078447824ULL, 0x000fe400078e027fULL, 0x0000000158587836ULL, 0x000fe20000000000ULL,
0xfffffff85c5c7812ULL, 0x000fc600078ee283ULL, 0x000000004444783bULL, 0x000e640000004200ULL,
0x000000105c5c7824ULL, 0x000fcc00078e027fULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x00000018ff747819ULL, 0x102fe40000011645ULL, 0x000000ff46787812ULL, 0x000fe400078ec0ffULL,
0x00000010ff757819ULL, 0x000fe40000011645ULL, 0x000000ff45767812ULL, 0x040fe400078ec0ffULL,
0x0000ffff45857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff457819ULL, 0x004fc4000001165cULL,
0x000000ff5c677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe4000001165cULL,
0x0000ffff5c697812ULL, 0x000fe400078ec0ffULL, 0x000000ff44717812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6d7819ULL, 0x000fe4000001165dULL, 0x000000ff5d5c7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165dULL, 0x0000ffff5d6a7812ULL, 0x000fe400078ec0ffULL,
0x00000074ff74723eULL, 0x000fe400020006ffULL, 0x00000078ff5d723eULL, 0x000fe400020006ffULL,
0x00000010ff6b7819ULL, 0x000fe20000011644ULL, 0x20000074ff787230ULL, 0x000fe20000004100ULL,
0x00000010ff7f7819ULL, 0x100fe20000011646ULL, 0x2000005dff747230ULL, 0x000fe20000004100ULL,
0x00000018ff7a7819ULL, 0x000fc40000011646ULL, 0x0000ffff46867812ULL, 0x000fe400078ec0ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011644ULL,
0x000000ff47837812ULL, 0x000fe200078ec0ffULL, 0x20000071ff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fe4000001165eULL, 0x000000ff5e667812ULL, 0x000fc400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe4000001165eULL, 0x0000ffff5e647812ULL, 0x000fe400078ec0ffULL,
0x000000ff755e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff6b5d7812ULL, 0x000fe400078ec0ffULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x20000076ff7b7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x2000006cff767230ULL, 0x000fe20000004100ULL,
0x0000ffff44847812ULL, 0x000fe200078ec0ffULL, 0x20000083ff757230ULL, 0x000fe20000004100ULL,
0x0000005eff71723eULL, 0x000fe200020006ffULL, 0x2000007aff6b7230ULL, 0x000fe20000004100ULL,
0x00000018ff807819ULL, 0x100fe40000011647ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000071ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x000fc40000011647ULL,
0x00000008ff5e7819ULL, 0x000fe40000011684ULL, 0x00000080ff6c723eULL, 0x000fe200020006ffULL,
0x2000005dff807230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe40000011685ULL,
0x000000ff82717812ULL, 0x000fe200078ec0ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff5d7819ULL, 0x000fe40000011686ULL, 0x0000005eff5e723eULL, 0x000fc400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x2000005eff827230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe200020006ffULL,
0x2000007aff847230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x20000071ff7a7230ULL, 0x000fe20000004100ULL, 0x0000ffff47707812ULL, 0x000fe200078ec0ffULL,
0x20000068ff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff5f477812ULL, 0x000fe200078ec0ffULL,
0x2000005dff717230ULL, 0x000fe20000004100ULL, 0x00000066ff68723eULL, 0x000fc400020006ffULL,
0x00000067ff5d723eULL, 0x000fe400020006ffULL, 0x00000010ff667819ULL, 0x000fe20000011683ULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fe2000001167eULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe40000011680ULL,
0x00000047ff83723eULL, 0x000fe400020006ffULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x00000046ff80723eULL, 0x000fe400020006ffULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff707819ULL, 0x000fe40000011670ULL, 0x0000105467467816ULL, 0x000fe2000000007eULL,
0x20000083ff677230ULL, 0x000fe20000004100ULL, 0x00000018ff447819ULL, 0x000fe4000001165fULL,
0x0000105466477816ULL, 0x000fe2000000007bULL, 0x20000080ff667230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fc40000011676ULL, 0x00000010ff837819ULL, 0x000fe40000011678ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x000000463c54723cULL, 0x000fe20000041854ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x00000046340c723cULL, 0x008fe2000004180cULL,
0x00000044ff76723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x000000ff45787812ULL, 0x000fe200078ec0ffULL, 0x20000070ff707230ULL, 0x000fe20000004100ULL,
0x000010547b447816ULL, 0x000fe20000000082ULL, 0x20000076ff767230ULL, 0x000fe20000004100ULL,
0x0000105483457816ULL, 0x000fc40000000084ULL, 0x00000008ff697819ULL, 0x000fe40000011669ULL,
0x00000008ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff657819ULL, 0x000fe2000001165fULL,
0x000000443c48723cULL, 0x000fe20000041848ULL, 0x00000010ff467819ULL, 0x000fe40000011674ULL,
0x00000010ff477819ULL, 0x000fe40000011675ULL, 0x00000010ff7f7819ULL, 0x000fe2000001167fULL,
0x000000443410723cULL, 0x000fe20000041810ULL, 0x00000010ff7a7819ULL, 0x000fc4000001167aULL,
0x00000010ff6b7819ULL, 0x000fe4000001166bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000010ff447819ULL, 0x000fe40000011671ULL, 0x00000010ff457819ULL, 0x000fe40000011670ULL,
0x0000ffff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x000010547f467816ULL, 0x000fe20000000046ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x000010547a477816ULL, 0x000fe20000000047ULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x000010546b447816ULL, 0x000fe40000000044ULL,
0x000010546c457816ULL, 0x000fc40000000045ULL, 0x00000008ff647819ULL, 0x000fe20000011664ULL,
0x000000463c4c723cULL, 0x000fe2000004184cULL, 0x000000ff6d747812ULL, 0x000fe400078ec0ffULL,
0x000000ff63637812ULL, 0x000fe400078ec0ffULL, 0x000000ff65657812ULL, 0x000fe200078ec0ffULL,
0x000000463414723cULL, 0x000fe20000041814ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x000000443c50723cULL, 0x000fe20000041850ULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000078ff6d7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x000000443418723cULL, 0x000fe20000041818ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000074ff747230ULL, 0x000fe20000004100ULL, 0x00000010ff477819ULL, 0x000fe20000011662ULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000010ff467819ULL, 0x000fe20000011669ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000010ff447819ULL, 0x000fe2000001165dULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fc4000001165cULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x0000105447467816ULL, 0x000fe40000000046ULL,
0x00000010ff457819ULL, 0x000fe4000001165eULL, 0x000010545d477816ULL, 0x000fe4000000006aULL,
0x00000010ff5d7819ULL, 0x000fe40000011666ULL, 0x00000010ff5e7819ULL, 0x000fc40000011664ULL,
0x00000010ff6d7819ULL, 0x000fe2000001166dULL, 0x000000463c2c723cULL, 0x000fe2000004182cULL,
0x00000010ff5c7819ULL, 0x000fe40000011668ULL, 0x00000010ff747819ULL, 0x000fe40000011674ULL,
0x00000010ff637819ULL, 0x000fe20000011663ULL, 0x000000463420723cULL, 0x000fe20000041820ULL,
0x00000010ff677819ULL, 0x000fe40000011667ULL, 0x00000010ff627819ULL, 0x000fc40000011665ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00000010ff5f7819ULL, 0x000fe4000001165fULL,
0x000010545d5e7816ULL, 0x000fe4000000005eULL, 0x000010546d447816ULL, 0x000fe40000000044ULL,
0x0000105474457816ULL, 0x000fe40000000045ULL, 0x00001054635c7816ULL, 0x000fc4000000005cULL,
0x00001054625d7816ULL, 0x000fe40000000067ULL, 0x00001054765f7816ULL, 0x000fe2000000005fULL,
0x000000443c30723cULL, 0x000fec0000041830ULL, 0x0000005c3c28723cULL, 0x000fec0000041828ULL,
0x0000005e3c24723cULL, 0x000fec0000041824ULL, 0x00000044341c723cULL, 0x000fe2000004181cULL,
0x00000001ff3f7424ULL, 0x000fc800078e00ffULL, 0x0000003f063c79a7ULL, 0x0002a2000850003fULL,
0x0000005c3438723cULL, 0x000fec0000041838ULL, 0x0000005e3434723cULL, 0x000fe20000041840ULL,
0x0000000859067824ULL, 0x002fc800078e0208ULL, 0x01a6a03f06ff79a7ULL, 0x0003e4000850003fULL,
0x000000ffff407224ULL, 0x004fe200078e003dULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0xffffff4000949947ULL, 0x002fde000383ffffULL, 0x000000ff6000720cULL, 0x000fda0003f05270ULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x018000007d007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000de6000047802ULL, 0x000fce0000000f00ULL, 0x000000b800107944ULL, 0x006fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000007d00007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc8000000007dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f240000000a00ULL, 0x0000000602037981ULL, 0x010f22000c1e9900ULL,
0x0000000000057919ULL, 0x000f640000000000ULL, 0x0000001805077811ULL, 0x062fe400078ff0ffULL,
0x00000002ff097819ULL, 0x000fe40000011605ULL, 0x00000008053d7811ULL, 0x040fe400078ff0ffULL,
0x00000010053f7811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x01cfca0000410000ULL,
0x00001f0900047589ULL, 0x000e6800000e0000ULL, 0x00001f3d00067589ULL, 0x000ea800000e0000ULL,
0x00001f3f00057589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f2200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000004c044c7220ULL, 0x040fe20000410000ULL, 0x0000004d044d7220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005606567220ULL, 0x044fe20000410000ULL, 0x0000005706577220ULL, 0x040fe20000410000ULL,
0x0000004a064a7220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000004e064e7220ULL, 0x040fe20000410000ULL, 0x0000004f064f7220ULL, 0x040fe20000410000ULL,
0x0000005206527220ULL, 0x040fe20000410000ULL, 0x0000005306537220ULL, 0x040fe20000410000ULL,
0x0000003206327220ULL, 0x040fe20000410000ULL, 0x0000003306337220ULL, 0x040fe20000410000ULL,
0x0000002e062e7220ULL, 0x040fe20000410000ULL, 0x0000002f062f7220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x000fe20000410000ULL,
0x0000000c050c7220ULL, 0x048fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000003805387220ULL, 0x040fe20000410000ULL, 0x0000003905397220ULL, 0x040fe20000410000ULL,
0x0000003405347220ULL, 0x040fe20000410000ULL, 0x0000003505357220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x050fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003a073a7220ULL, 0x040fe20000410000ULL, 0x0000003b073b7220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000200073087824ULL, 0x000fe200078e0208ULL,
0x000000303130723eULL, 0x000fe400000010ffULL, 0x0000002c2d2c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fc400000010ffULL,
0x000000242524723eULL, 0x000fe400000010ffULL, 0x000000565757723eULL, 0x000fe400000010ffULL,
0x0000004a4b4a723eULL, 0x000fe400000010ffULL, 0x0000004e4f4e723eULL, 0x000fe400000010ffULL,
0x000000525352723eULL, 0x000fe400000010ffULL, 0x0000541057567816ULL, 0x000fc4000000004aULL,
0x0000763257577816ULL, 0x000fe4000000004aULL, 0x000000323332723eULL, 0x000fe400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe200000010ffULL,
0x000000015b5b7824ULL, 0x008fe200078e0200ULL, 0x0000000800037811ULL, 0x042fe400078ff0ffULL,
0x0000000200027812ULL, 0x040fe200078ec0ffULL, 0x000000105b5b7824ULL, 0x000fe200078e0208ULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x00000008033f7824ULL, 0x000fe200078e00ffULL,
0x0000001000097811ULL, 0x000fc400078ff0ffULL, 0x00000018003d7811ULL, 0x000fe200078ff0ffULL,
0x00000008073c7824ULL, 0x000fe200078e00ffULL, 0x0000000302047211ULL, 0x040fe200078ff8ffULL,
0x0000000809427824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe200078ff8ffULL,
0x00000008073e7824ULL, 0x000fe200078e00ffULL, 0x0000003d02067211ULL, 0x040fe200078ff8ffULL,
0x000000083d3d7824ULL, 0x000fe200078e00ffULL, 0x0000000902057211ULL, 0x000fe200078ff8ffULL,
0x0000000807097824ULL, 0x040fe200078e00ffULL, 0xfffffff83f407812ULL, 0x000fe200078ee204ULL,
0x0000000203027836ULL, 0x000fe20000000000ULL, 0xfffffff83d447812ULL, 0x000fe200078ee206ULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee205ULL,
0x0000000403057836ULL, 0x000fe20000000000ULL, 0xfffffff809067812ULL, 0x000fe200078ee202ULL,
0x0000000807027824ULL, 0x000fe200078e00ffULL, 0x000000262726723eULL, 0x000fe200000010ffULL,
0x0000000603077836ULL, 0x000fe20000000000ULL, 0xfffffff83c3c7812ULL, 0x000fc400078ee205ULL,
0xfffffff802027812ULL, 0x000fe200078ee203ULL, 0x0000100061037824ULL, 0x000fe200078e0208ULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee207ULL, 0x0000000804057812ULL, 0x000fe200078ec0ffULL,
0x0000001002047824ULL, 0x100fe200078e0203ULL, 0x000000545502723eULL, 0x000fe200000010ffULL,
0x0000001040407824ULL, 0x100fe200078e0203ULL, 0x0000000c0d0c723eULL, 0x000fe200000010ffULL,
0x0000001042427824ULL, 0x100fe200078e0203ULL, 0x000000141514723eULL, 0x000fe200000010ffULL,
0x0000001044447824ULL, 0x100fe200078e0203ULL, 0x000000181918723eULL, 0x000fe200000010ffULL,
0x0000001006067824ULL, 0x100fe200078e0203ULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x000000103c3c7824ULL, 0x100fe200078e0203ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x000000103e3e7824ULL, 0x000fe200078e0203ULL, 0x000000484903723eULL, 0x000fe200000010ffULL,
0x0000000104047824ULL, 0x000fe200078e0205ULL, 0x000000383938723eULL, 0x000fe200000010ffULL,
0x0000000105407824ULL, 0x040fe200078e0240ULL, 0x0000541002467816ULL, 0x140fe20000000003ULL,
0x0000000105427824ULL, 0x040fe200078e0242ULL, 0x0000763202477816ULL, 0x000fe20000000003ULL,
0x0000000105447824ULL, 0x000fe200078e0244ULL, 0x0000004c4d02723eULL, 0x000fe200000010ffULL,
0x0000000105097824ULL, 0x000fe200078e0206ULL, 0x000000505103723eULL, 0x000fe200000010ffULL,
0x0000004604007388ULL, 0x0003e20000000a00ULL, 0x00000001053c7824ULL, 0x000fe200078e023cULL,
0x000000101106723eULL, 0x000fe200000010ffULL, 0x00000001053e7824ULL, 0x000fe200078e023eULL,
0x0000763202057816ULL, 0x000fc40000000003ULL, 0x000000343534723eULL, 0x000fe400000010ffULL,
0x0000000e0f0e723eULL, 0x000fe400000010ffULL, 0x000000121307723eULL, 0x000fe400000010ffULL,
0x0000541002047816ULL, 0x002fe40000000003ULL, 0x0000541030027816ULL, 0x140fe4000000002cULL,
0x0000763230037816ULL, 0x000fe2000000002cULL, 0x0000000409007388ULL, 0x000fe20000000a00ULL,
0x000000161716723eULL, 0x000fc400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe200000010ffULL,
0x000000023c007388ULL, 0x0003e20000000a00ULL, 0x0000001e1f1e723eULL, 0x000fe400000010ffULL,
0x00000022230f723eULL, 0x000fe400000010ffULL, 0x0000003a3b3a723eULL, 0x000fe400000010ffULL,
0x00000036371d723eULL, 0x000fe400000010ffULL, 0x000000ff6100720cULL, 0x000fc40003f05270ULL,
0x000076323a297816ULL, 0x100fe4000000001dULL, 0x0000541028027816ULL, 0x142fe40000000024ULL,
0x0000763228037816ULL, 0x000fe40000000024ULL, 0x000054103a287816ULL, 0x000fc6000000001dULL,
0x000000023e007388ULL, 0x0003e80000000a00ULL, 0x0000005640007388ULL, 0x000fe20000000a00ULL,
0x000054104e027816ULL, 0x142fe40000000052ULL, 0x000076324e037816ULL, 0x000fca0000000052ULL,
0x0004000209007388ULL, 0x0003e40000000a00ULL, 0x0000541032027816ULL, 0x142fe4000000002eULL,
0x0000763232037816ULL, 0x000fca000000002eULL, 0x000400023c007388ULL, 0x0003e40000000a00ULL,
0x000054102a027816ULL, 0x142fe40000000026ULL, 0x000076322a037816ULL, 0x000fca0000000026ULL,
0x000400023e007388ULL, 0x0003e40000000a00ULL, 0x000054100c027816ULL, 0x142fe40000000006ULL,
0x000076320c037816ULL, 0x000fe40000000006ULL, 0x000054100e067816ULL, 0x140fe40000000007ULL,
0x000076320e077816ULL, 0x000fe20000000007ULL, 0x0000000242007388ULL, 0x0003e40000000a00ULL,
0x0000541014027816ULL, 0x002fc40000000018ULL, 0x0000763214037816ULL, 0x000fca0000000018ULL,
0x0008000209007388ULL, 0x0003e40000000a00ULL, 0x000054101c027816ULL, 0x142fe40000000020ULL,
0x000076321c037816ULL, 0x000fca0000000020ULL, 0x000800023c007388ULL, 0x0003e40000000a00ULL,
0x0000541038027816ULL, 0x142fe40000000034ULL, 0x0000763238037816ULL, 0x000fca0000000034ULL,
0x000800023e007388ULL, 0x0003e80000000a00ULL, 0x0000000644007388ULL, 0x000fe20000000a00ULL,
0x0000541016027816ULL, 0x142fe4000000001aULL, 0x0000763216037816ULL, 0x000fca000000001aULL,
0x000c000209007388ULL, 0x0003e40000000a00ULL, 0x000054101e027816ULL, 0x142fe4000000000fULL,
0x000076321e037816ULL, 0x000fca000000000fULL, 0x000c00023c007388ULL, 0x0003e80000000a00ULL,
0x000c00283e007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff00027306ULL, 0x002e620000202400ULL, 0x000000005b047984ULL, 0x000e680000000c00ULL,
0x000400005b107984ULL, 0x000ee80000000c00ULL, 0x000800005b187984ULL, 0x000f280000000c00ULL,
0x000c00005b207984ULL, 0x000f680000000c00ULL, 0x001000005b0c7984ULL, 0x000f280000000c00ULL,
0x001400005b147984ULL, 0x000f680000000c00ULL, 0x001800005b1c7984ULL, 0x000f680000000c00ULL,
0x001c00005b247984ULL, 0x000f620000000c00ULL, 0x0000000702077230ULL, 0x002fc40000200800ULL,
0x0000000602067230ULL, 0x040fe40000200800ULL, 0x0000000502057230ULL, 0x040fe40000200800ULL,
0x0000000402047230ULL, 0x040fe40000200800ULL, 0x0000001302137230ULL, 0x048fe40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x000fc40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001b021b7230ULL, 0x050fe40000200800ULL,
0x0000001a021a7230ULL, 0x040fe40000200800ULL, 0x0000001902197230ULL, 0x040fe40000200800ULL,
0x0000001802187230ULL, 0x040fe40000200800ULL, 0x0000002302237230ULL, 0x024fc40000200800ULL,
0x0000002202227230ULL, 0x040fe40000200800ULL, 0x0000002102217230ULL, 0x040fe40000200800ULL,
0x0000002002027230ULL, 0x000fe40000200800ULL, 0x0000000f07077230ULL, 0x000fe40000200000ULL,
0x0000000e06067230ULL, 0x000fe40000200000ULL, 0x0000000d05057230ULL, 0x000fc40000200000ULL,
0x0000000c04047230ULL, 0x000fe40000200000ULL, 0x0000001713137230ULL, 0x000fe40000200000ULL,
0x0000001612127230ULL, 0x000fe20000200000ULL, 0x000000045b007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000200000ULL, 0x0000001410107230ULL, 0x000fe40000200000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000200000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000200000ULL,
0x000400105b007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000200000ULL,
0x0000001c18187230ULL, 0x000fe40000200000ULL, 0x0000002723237230ULL, 0x000fe40000200000ULL,
0x0000002622227230ULL, 0x000fe20000200000ULL, 0x000800185b007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000200000ULL, 0x0000002402207230ULL, 0x000fca0000200000ULL,
0x000c00205b007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x0000000b0900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x0000000172047824ULL, 0x002fe200078e0209ULL,
0x0000000800067d06ULL, 0x000e620008209000ULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000700127812ULL, 0x000fca00078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06027836ULL, 0x002fcc0000000000ULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000000805057c24ULL, 0x000fc8000f8e02ffULL,
0x0000000503037227ULL, 0x000fc800078e0002ULL, 0x0000000109027824ULL, 0x000fe400078e0200ULL,
0x0000000403077227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf06070ULL,
0x8000000805050c36ULL, 0x000fe40008000000ULL, 0x0000000107070836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000805007c0cULL, 0x000fe4000bf26070ULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x00000008ff027c12ULL, 0x000fe4000f8e33ffULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0208ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x00000000060c7984ULL, 0x0002a40000000c00ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000805057c24ULL, 0x000fe4000f8e0204ULL,
0x0000000873077824ULL, 0x000fe200078e0212ULL, 0x00000003ff097819ULL, 0x000fc40000011606ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4410ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000172047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000004000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000873077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000172047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x0000006000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000873077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000172047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x0000008000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000873077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000172047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a07ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x8000000805051c36ULL, 0x000fe40008000000ULL, 0x0000000107071836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef809ULL,
0x0000001005067824ULL, 0x000fca00078e0208ULL, 0x00000000060c7984ULL, 0x0002a20000000c00ULL,
0x0000000107072836ULL, 0x000fca0000000000ULL, 0x0000000702107207ULL, 0x000fe20004000000ULL,
0x000000a000067836ULL, 0x002fc80000000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011606ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000873077824ULL, 0x000fc600078e0210ULL,
0x000000050a057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4412ULL,
0x0000000b0900720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000172047824ULL, 0x102fe400078e0209ULL, 0x0000000106097824ULL, 0x000fe400078e0209ULL,
0x0000000403057227ULL, 0x000fc600078e00ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff809097812ULL, 0x000fe200078ef806ULL,
0x0000000807077c24ULL, 0x000fe2000f8e0204ULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0x0000000807007c0cULL, 0x000fc8000bf26070ULL,
0x00000000090c7984ULL, 0x0002a40000000c00ULL, 0x000000c000097836ULL, 0x002fce0000000000ULL,
0x8000000807071c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000807007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000502107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe4000f8e0279ULL, 0x0000000807047c24ULL, 0x000fe4000f8e0204ULL,
0x0000000873077824ULL, 0x000fe200078e0206ULL, 0x00000003ff067819ULL, 0x000fe20000011609ULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4410ULL, 0x0000000b0600720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000172047824ULL, 0x102fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0206ULL, 0x0000000403077227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x000000e000007836ULL, 0x000fe40000000000ULL, 0x0000000805057c24ULL, 0x000fca000f8e0204ULL,
0x0000000805007c0cULL, 0x000fda000bf26070ULL, 0x8000000805051c36ULL, 0x000fe40008000000ULL,
0x0000000107071836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef809ULL, 0x0000001005067824ULL, 0x000fca00078e0208ULL,
0x00000000060c7984ULL, 0x000e620000000c00ULL, 0x0000000107072836ULL, 0x000fca0000000000ULL,
0x0000000702107207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a10ULL,
0x0000000910057c24ULL, 0x000fe2000f8e0279ULL, 0x0000000709107812ULL, 0x000fe200078ec0ffULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x00000003ff097819ULL, 0x000fc60000011600ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000873077824ULL, 0x000fe400078e0210ULL,
0x0000000172727824ULL, 0x000fe200078e0209ULL, 0x000000050a057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4412ULL, 0x0000000b0900720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0023ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007203037227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x002fe400078e0a03ULL, 0x0000000100097824ULL, 0x000fe400078e0209ULL,
0x0000000805047c24ULL, 0x000fc6000f8e0272ULL, 0x0000000709097812ULL, 0x000fe400078ec0ffULL,
0x0000000804007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff809097812ULL, 0x000fe400078ef800ULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x0000001009097824ULL, 0x000fe400078e0208ULL,
0x0000000873737824ULL, 0x000fc800078e0200ULL, 0x8000000804041c36ULL, 0x000fe40008000000ULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf46070ULL,
0x0000000009047984ULL, 0x000e760000000c00ULL, 0x0000000103032836ULL, 0x000fca0000000000ULL,
0x0000000302027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000000902037c24ULL, 0x000fe4000f8e0279ULL, 0x000000080b727c24ULL, 0x000fc8000f8e0272ULL,
0x0000000803037c24ULL, 0x000fca000f8e0272ULL, 0x000000030a037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8040ffULL,
0x0000000503037c11ULL, 0x000fc600080f4408ULL, 0x0000001073027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009800ff0a7b82ULL, 0x000e620000000a00ULL, 0x000001ff0d00780cULL, 0x000fe20003f04070ULL,
0x0000000207077824ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000001ff057424ULL, 0x000fe200078e00ffULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x0000004077707824ULL, 0x000fe200078e00ffULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x0000000c07797224ULL, 0x000fe200078e0279ULL, 0x000000053f047899ULL, 0x000fe20008011604ULL,
0x01a60005080479a7ULL, 0x0004a2000850003fULL, 0x000000060a067981ULL, 0x002324000c1e9900ULL,
0x00000005790a7c24ULL, 0x002fe2000f8e0270ULL, 0x0000000c00240947ULL, 0x004fee0003800000ULL,
0x00000003ff2e7819ULL, 0x000fe20000011609ULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x000000706e077248ULL, 0x000fc60007fe0000ULL, 0x000000042e0e7836ULL, 0x000fe40000000000ULL,
0x000000082e127836ULL, 0x000fe40000000000ULL, 0x000000010e0b7824ULL, 0x140fe400078e0209ULL,
0x000000080e0c7824ULL, 0x000fe400078e00ffULL, 0x00000001120d7824ULL, 0x040fe400078e0209ULL,
0x0000000812107824ULL, 0x000fe200078e00ffULL, 0xfffffff80c217812ULL, 0x000fe200078ee20bULL,
0x0000000107077824ULL, 0x000fc400078e0a70ULL, 0x000000010a0c7824ULL, 0x000fe200078e022eULL,
0xfffffff810237812ULL, 0x000fe200078ee20dULL, 0x000000102e107836ULL, 0x000fe20000000000ULL,
0x000000070e00720cULL, 0x000fe20003fa6070ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010a0e7824ULL, 0x000fe200078e020eULL, 0x000000700c167812ULL, 0x000fe200078ef800ULL,
0x00000001100c7824ULL, 0x000fe400078e0209ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000816167c10ULL, 0x000fc6000ff1e0ffULL, 0x0000000810277824ULL, 0x000fe200078e00ffULL,
0x000000700e187812ULL, 0x000fe200078ef800ULL, 0x0000000c2e147836ULL, 0x000fe20000000000ULL,
0x000000090d177c10ULL, 0x000fe200087fe4ffULL, 0x000000142e1e7836ULL, 0x000fe20000000000ULL,
0xfffffff827277812ULL, 0x000fe200078ee20cULL, 0x000000010a0c7824ULL, 0x000fe200078e0212ULL,
0x0000000818187c10ULL, 0x000fe2000ff3e0ffULL, 0x00000001140b7824ULL, 0x000fe200078e0209ULL,
0x000000071000720cULL, 0x080fe20003f06070ULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x000000090f197c10ULL, 0x000fe20008ffe4ffULL, 0x000000010a0e7824ULL, 0x000fe200078e0214ULL,
0x000000071200720cULL, 0x000fe20003f26070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff81a257812ULL, 0x000fc400078ee20bULL, 0x000000071400720cULL, 0x000fe20003f46070ULL,
0x000000010a107824ULL, 0x000fe200078e0210ULL, 0x000000700c1a7812ULL, 0x000fe200078ef800ULL,
0x000000182e207836ULL, 0x000fe40000000000ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000081a1a7c10ULL, 0x000fc6000ff7e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e1c7812ULL, 0x000fe400078ef800ULL, 0x000000090d1b7c10ULL, 0x000fe20009ffe4ffULL,
0x000000010a127824ULL, 0x040fe200078e021eULL, 0x00000070100e7812ULL, 0x000fe200078ef800ULL,
0x000000010a147824ULL, 0x000fe200078e0220ULL, 0x000000081c1c7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000001c2e247836ULL, 0x000fe20000000000ULL, 0x000000080e0e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x000000090f1d7c10ULL, 0x000fc4000a7fe4ffULL,
0x00000009110f7c10ULL, 0x000fe20009ffe4ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007012107812ULL, 0x000fc600078ef800ULL, 0x000000010a0c7824ULL, 0x000fe200078e0224ULL,
0x0000007014147812ULL, 0x000fe200078ef800ULL, 0x000000012e127824ULL, 0x100fe200078e0209ULL,
0x0000000810107c10ULL, 0x000fe2000ff7e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000814147c10ULL, 0x000fe4000ff9e0ffULL, 0x0000000913117c10ULL, 0x000fe20009ffe4ffULL,
0x00004000770b7824ULL, 0x000fe200078e0208ULL, 0x000000700c1f7812ULL, 0x000fe200078ef800ULL,
0x000000202e267836ULL, 0x000fe20000000000ULL, 0x0000000915157c10ULL, 0x000fe2000a7fe4ffULL,
0x000020000b227836ULL, 0x000fe20000000000ULL, 0x0000000712127812ULL, 0x000fe200078ec0ffULL,
0x000000011e0b7824ULL, 0x000fe200078e0209ULL, 0x000000072e00720cULL, 0x080fe20003f86070ULL,
0x000000081e287824ULL, 0x040fe200078e00ffULL, 0x000000071e00720cULL, 0x000fe20003f66070ULL,
0x000000010a0c7824ULL, 0x000fe200078e0226ULL, 0x000000081f1e7c10ULL, 0x000fe2000ffde0ffULL,
0x00000008202b7824ULL, 0x000fe200078e00ffULL, 0x0ffffff812137812ULL, 0x000fe200078ef809ULL,
0x000000282e2a7836ULL, 0x000fe20000000000ULL, 0x000000090d1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff828297812ULL, 0x000fc600078ee20bULL,
0x00000010130b7824ULL, 0x000fe200078e0222ULL, 0x000000700c137812ULL, 0x000fe200078ef800ULL,
0x000000242e287836ULL, 0x000fe40000000000ULL, 0x00000001200c7824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000160b7faeULL, 0x0003e2000e101c46ULL,
0x000000010a127824ULL, 0x000fe200078e0228ULL, 0x000000072000720cULL, 0x000fe20003f86070ULL,
0x00000008242d7824ULL, 0x000fe200078e00ffULL, 0x0000000813207c10ULL, 0x000fe2000ffde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fc600078ee20cULL,
0x000000010a2c7824ULL, 0x000fe400078e022aULL, 0x0000001023237824ULL, 0x100fe200078e0222ULL,
0x0000007012167812ULL, 0x002fe200078ef800ULL, 0x00000010210b7824ULL, 0x100fe200078e0222ULL,
0x000000090d217c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000124127824ULL, 0x040fe200078e0209ULL,
0x0000000816167c10ULL, 0x000fe2000ffde0ffULL, 0x0000001025257824ULL, 0x000fe200078e0222ULL,
0x00000000180b7faeULL, 0x0003e2000e901c46ULL, 0x000000072400720cULL, 0x080fe20003fa6070ULL,
0x0000002c2e247836ULL, 0x000fe20000000000ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL,
0x000000802c0c7825ULL, 0x000fe200078e00ffULL, 0x000000001a237faeULL, 0x000fe2000c901c46ULL,
0x000000072600720cULL, 0x000fc40003f26070ULL, 0x0000001027277824ULL, 0x000fe200078e0222ULL,
0x0000000913177c10ULL, 0x000fe2000b7fe4ffULL, 0x000000010a127824ULL, 0x000fe200078e0224ULL,
0x000000001c257faeULL, 0x000fe2000d101c46ULL, 0x0000000128187824ULL, 0x142fe200078e0209ULL,
0x000000700c0c7812ULL, 0x000fe200078ef800ULL, 0x0000000828197824ULL, 0x000fe200078e00ffULL,
0x000000000e277faeULL, 0x0003e2000c101c46ULL, 0x00000001260b7824ULL, 0x000fe200078e0209ULL,
0x000000072800720cULL, 0x000fe20003f46070ULL, 0x0000000826267824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee218ULL, 0x000000302e187836ULL, 0x000fe20000000000ULL,
0x000000080c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff8260b7812ULL, 0x000fc400078ee20bULL, 0x000000090d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001029297824ULL, 0x000fe200078e0222ULL, 0x0000007012127812ULL, 0x000fe200078ef800ULL,
0x000000010a0e7824ULL, 0x002fe400078e0218ULL, 0x000000102b2b7824ULL, 0x100fe200078e0222ULL,
0x0000000010297faeULL, 0x000fe2000d901c46ULL, 0x000000102d2d7824ULL, 0x000fe200078e0222ULL,
0x0000000812127c10ULL, 0x000fe2000ffde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000142b7faeULL, 0x0003e2000e101c46ULL, 0x000000072400720cULL, 0x000fc40003f86070ULL,
0x000000100b0b7824ULL, 0x100fe200078e0222ULL, 0x000000001e2d7faeULL, 0x000fe2000e901c46ULL,
0x0000001019197824ULL, 0x000fe200078e0222ULL, 0x000000072a00720cULL, 0x0c0fe20003fa6070ULL,
0x000000342e1a7836ULL, 0x000fe20000000000ULL, 0x0000000913137c10ULL, 0x000fe2000b7fe4ffULL,
0x000000382e1c7836ULL, 0x000fe20000000000ULL, 0x00000000200b7faeULL, 0x0005e2000c901c46ULL,
0x0000003c2e267836ULL, 0x000fe20000000000ULL, 0x000000700e147812ULL, 0x002fe200078ef800ULL,
0x000000012a157824ULL, 0x140fe200078e0209ULL, 0x0000000016197faeULL, 0x0003e2000d101c46ULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000814147c10ULL, 0x000fe2000ffde0ffULL,
0x000000010a107824ULL, 0x000fe200078e021aULL, 0x000000071800720cULL, 0x0c0fe20003f66070ULL,
0x00000001180e7824ULL, 0x000fe200078e0209ULL, 0x000000071a00720cULL, 0x080fe20003f46070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000071c00720cULL, 0x000fc40003f26070ULL,
0x000000072600720cULL, 0x000fe20003f06070ULL, 0x00000001240b7824ULL, 0x004fe200078e0209ULL,
0xfffffff82a077812ULL, 0x000fe200078ee215ULL, 0x0000000818197824ULL, 0x002fe200078e00ffULL,
0x000000090f157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000010a0f7824ULL, 0x000fe200078e021cULL,
0x0000007010107812ULL, 0x000fe200078ef800ULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee20eULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x0000000810107c10ULL, 0x000fc4000ffde0ffULL, 0xfffffff824177812ULL, 0x000fe200078ee20bULL,
0x000000010a0a7824ULL, 0x000fe200078e0226ULL, 0x000000700e0e7812ULL, 0x000fe200078ef800ULL,
0x000000011a167824ULL, 0x000fe200078e0209ULL, 0x0000000911117c10ULL, 0x000fe2000b7fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000080e0e7c10ULL, 0x000fc6000ffde0ffULL,
0x000000081a1b7824ULL, 0x000fe200078e00ffULL, 0x000000700a007812ULL, 0x000fe200078ef800ULL,
0x000000011c187824ULL, 0x140fe200078e0209ULL, 0x000000090f0f7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000081c1d7824ULL, 0x000fe200078e00ffULL, 0x00000008000a7c10ULL, 0x000fe2000ffde0ffULL,
0x00000001261a7824ULL, 0x040fe200078e0209ULL, 0xfffffff81b097812ULL, 0x000fe200078ee216ULL,
0x00000008261f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1b7812ULL, 0x000fe200078ee218ULL,
0x0000001007077824ULL, 0x100fe200078e0222ULL, 0x000000090b0b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001017177824ULL, 0x100fe200078e0222ULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee21aULL,
0x0000001019197824ULL, 0x100fe200078e0222ULL, 0x000000000c077faeULL, 0x0003e2000e901c46ULL,
0x0000001009097824ULL, 0x000fc400078e0222ULL, 0x000000101b1b7824ULL, 0x100fe200078e0222ULL,
0x0000000012177faeULL, 0x0003e2000e101c46ULL, 0x000000101d1d7824ULL, 0x000fc600078e0222ULL,
0x0000000014197faeULL, 0x0003e8000d901c46ULL, 0x0000000010097faeULL, 0x0003e8000d101c46ULL,
0x000000000e1b7faeULL, 0x0003e8000c901c46ULL, 0x000000000a1d7faeULL, 0x0003e2000c101c46ULL,
0x0000000800d47947ULL, 0x000fea0003800000ULL, 0x00000004090d7811ULL, 0x040fe200078fe8ffULL,
0x0000900000087ab9ULL, 0x000fe20000000a00ULL, 0x00000008090e7811ULL, 0x040fe400078fe8ffULL,
0x0000000c090f7811ULL, 0x000fe200078fe8ffULL, 0x000000010d077824ULL, 0x100fe200078e0209ULL,
0x0000001009147811ULL, 0x000fe200078fe8ffULL, 0x000000080d107824ULL, 0x000fe200078e00ffULL,
0x0000001409167811ULL, 0x040fe200078fe8ffULL, 0x000000080e187824ULL, 0x040fe200078e00ffULL,
0x00000020091d7811ULL, 0x000fe200078fe8ffULL, 0x000000010f0b7824ULL, 0x100fe200078e0209ULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x000000010e077824ULL, 0x100fe200078e0209ULL,
0x0000001c091b7811ULL, 0x000fe200078fe8ffULL, 0x000000080f1a7824ULL, 0x000fe200078e00ffULL,
0x0000002809247811ULL, 0x040fe200078fe8ffULL, 0x00000001140c7824ULL, 0x140fe200078e0209ULL,
0xfffffff818117812ULL, 0x000fe200078ee207ULL, 0x0000000814157824ULL, 0x000fe200078e00ffULL,
0x0000001809187811ULL, 0x040fe200078fe8ffULL, 0x0000000116127824ULL, 0x140fe200078e0209ULL,
0xfffffff81a137812ULL, 0x000fe200078ee20bULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0x0000002409207811ULL, 0x040fe200078fe8ffULL, 0x0000000118077824ULL, 0x140fe200078e0209ULL,
0xfffffff815157812ULL, 0x000fe200078ee20cULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0x0000003009287811ULL, 0x000fe200078fe8ffULL, 0x000000011d0c7824ULL, 0x140fe200078e0209ULL,
0xfffffff817177812ULL, 0x000fe200078ee212ULL, 0x000000081d197824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL, 0x000000011b0b7824ULL, 0x100fe200078e0209ULL,
0x0000002c09267811ULL, 0x000fe200078fe8ffULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0x00000034092b7811ULL, 0x040fe200078fe8ffULL, 0x0000000124077824ULL, 0x140fe200078e0209ULL,
0xfffffff8191e7812ULL, 0x000fe200078ee20cULL, 0x0000000824227824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x0000000120127824ULL, 0x140fe200078e0209ULL,
0x00000038092d7811ULL, 0x040fe200078fe8ffULL, 0x0000000820217824ULL, 0x000fe200078e00ffULL,
0xfffffff822257812ULL, 0x000fe200078ee207ULL, 0x00000001280c7824ULL, 0x140fe200078e0209ULL,
0x0000000909077211ULL, 0x040fe200078fe8ffULL, 0x0000000828297824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee212ULL, 0x00000001260b7824ULL, 0x140fe200078e0209ULL,
0x0000003c092f7811ULL, 0x000fe200078fe8ffULL, 0x00000008262a7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x000000012b127824ULL, 0x000fe200078e0209ULL,
0x00000007070c7812ULL, 0x000fe200078ec0ffULL, 0x000000082b197824ULL, 0x000fe200078e00ffULL,
0xfffffff82a277812ULL, 0x000fe200078ee20bULL, 0x000000010a237824ULL, 0x040fe200078e0220ULL,
0x0000000a090b7211ULL, 0x000fe200078fe8ffULL, 0x000000010a0d7824ULL, 0x040fe200078e020dULL,
0xfffffff8192e7812ULL, 0x000fe200078ee212ULL, 0x000000010a127824ULL, 0x040fe200078e020fULL,
0x0ffffff80c077812ULL, 0x000fe200078ef809ULL, 0x000000010a197824ULL, 0x000fc400078e0218ULL,
0x000000012d0f7824ULL, 0x000fe400078e0209ULL, 0x000000010a0e7824ULL, 0x040fe400078e020eULL,
0x000000010a147824ULL, 0x040fe400078e0214ULL, 0x000000010a167824ULL, 0x040fe400078e0216ULL,
0x000000010a1f7824ULL, 0x040fe400078e021bULL, 0x000000010a227824ULL, 0x000fc400078e021dULL,
0x000000010a247824ULL, 0x040fe400078e0224ULL, 0x000000010a267824ULL, 0x040fe400078e0226ULL,
0x000000010a2a7824ULL, 0x040fe400078e0228ULL, 0x000000010a2c7824ULL, 0x040fe400078e022bULL,
0x000000010a307824ULL, 0x000fe400078e022dULL, 0x000000082d187824ULL, 0x000fc400078e00ffULL,
0x000000010a327824ULL, 0x000fe400078e022fULL, 0x000000012f097824ULL, 0x040fe200078e0209ULL,
0xfffffff818187812ULL, 0x000fe200078ee20fULL, 0x000000082f207824ULL, 0x000fe400078e00ffULL,
0x000000800b0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff8201b7812ULL, 0x000fe200078ee209ULL,
0x00004000770c7824ULL, 0x000fe200078e0208ULL, 0x000000700a0a7812ULL, 0x000fe200078ef800ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x000000080a0a7c10ULL, 0x000fe2000ff1e0ffULL,
0x000020000c207836ULL, 0x000fe40000000000ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000000090b0b7c10ULL, 0x000fc600087fe4ffULL, 0x0000001010097824ULL, 0x100fe200078e0220ULL,
0x000000700c0c7812ULL, 0x000fe200078ef800ULL, 0x00000010112b7824ULL, 0x100fe400078e0220ULL,
0x0000001018437824ULL, 0x100fe200078e0220ULL, 0x000000700e187812ULL, 0x000fe200078ef800ULL,
0x0000008012107825ULL, 0x000fe200078e00ffULL, 0x000000080c0c7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000818187c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010132d7824ULL, 0x100fe200078e0220ULL,
0x000000090d0d7c10ULL, 0x000fe20008ffe4ffULL, 0x00000010152f7824ULL, 0x000fc400078e0220ULL,
0x000000101a337824ULL, 0x000fe200078e0220ULL, 0x00000070101a7812ULL, 0x000fe200078ef800ULL,
0x0000008014127825ULL, 0x000fc800078e00ffULL, 0x0000008016147825ULL, 0x000fc800078e00ffULL,
0x0000001017317824ULL, 0x100fe400078e0220ULL, 0x0000008019167825ULL, 0x000fe200078e00ffULL,
0x000000090f197c10ULL, 0x000fe400087fe4ffULL, 0x000000081a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000101c357824ULL, 0x100fe200078e0220ULL, 0x00000070121c7812ULL, 0x000fe200078ef800ULL,
0x000000101e377824ULL, 0x100fe200078e0220ULL, 0x00000070141e7812ULL, 0x000fe200078ef800ULL,
0x0000001007077824ULL, 0x100fe200078e0220ULL, 0x000000081c1c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001021397824ULL, 0x000fc400078e0220ULL, 0x00000010253b7824ULL, 0x100fe200078e0220ULL,
0x00000009131d7c10ULL, 0x000fe20008ffe4ffULL, 0x00000010273d7824ULL, 0x100fe200078e0220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a077faeULL, 0x0003e2000b901c46ULL,
0x00000010293f7824ULL, 0x100fe400078e0220ULL, 0x000000102e417824ULL, 0x100fe200078e0220ULL,
0x000000000c097faeULL, 0x0003e2000b901c46ULL, 0x000000101b457824ULL, 0x000fe200078e0220ULL,
0x0000007016207812ULL, 0x000fe200078ef800ULL, 0x000000801f0e7825ULL, 0x000fe200078e00ffULL,
0x00000009111b7c10ULL, 0x000fe200087fe4ffULL, 0x00000000182b7faeULL, 0x0003e2000b901c46ULL,
0x000000081e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008022107825ULL, 0x000fe200078e00ffULL,
0x0000000820207c10ULL, 0x000fe2000ff5e0ffULL, 0x000000001a2d7faeULL, 0x0003e2000b901c46ULL,
0x00000009151f7c10ULL, 0x000fe200087fe4ffULL, 0x0000008023127825ULL, 0x000fe200078e00ffULL,
0x000000700e227812ULL, 0x000fe200078ef800ULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000917217c10ULL, 0x000fe200097fe4ffULL, 0x0000008024147825ULL, 0x000fe200078e00ffULL,
0x0000007010247812ULL, 0x000fe200078ef800ULL, 0x000000001e317faeULL, 0x0003e2000b901c46ULL,
0x0000000822227c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008026167825ULL, 0x000fe200078e00ffULL,
0x0000007012267812ULL, 0x000fe200078ef800ULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x0000007014287812ULL, 0x000fc400078ef800ULL, 0x0000000824247c10ULL, 0x000fe4000ff3e0ffULL,
0x000000090f237c10ULL, 0x000fe200087fe4ffULL, 0x000000802a0e7825ULL, 0x000fe200078e00ffULL,
0x0000000826267c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000828287c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x0000000911257c10ULL, 0x000fe20008ffe4ffULL,
0x000000802c107825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x000fc400078ef800ULL,
0x0000000913277c10ULL, 0x000fe200087fe4ffULL, 0x0000008030127825ULL, 0x000fe200078e00ffULL,
0x0000000915297c10ULL, 0x000fe200097fe4ffULL, 0x0000000024377faeULL, 0x0003e2000b901c46ULL,
0x0000000816167c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008032147825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fe200078ef800ULL, 0x0000000026397faeULL, 0x0003e2000b901c46ULL,
0x0000007010107812ULL, 0x000fe400078ef800ULL, 0x0000007012127812ULL, 0x000fe200078ef800ULL,
0x00000000283b7faeULL, 0x0003e2000b901c46ULL, 0x0000000917177c10ULL, 0x000fc400087fe4ffULL,
0x0000007014007812ULL, 0x000fe400078ef800ULL, 0x000000080e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000163d7faeULL, 0x0003e2000b901c46ULL, 0x0000000810107c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000812127c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000800147c10ULL, 0x000fe4000ff7e0ffULL,
0x000000090f0f7c10ULL, 0x000fc400087fe4ffULL, 0x0000000911117c10ULL, 0x000fe40008ffe4ffULL,
0x0000000913137c10ULL, 0x000fe200097fe4ffULL, 0x000000000e3f7faeULL, 0x0003e2000b901c46ULL,
0x0000000915157c10ULL, 0x000fc60009ffe4ffULL, 0x0000000010417faeULL, 0x0003e8000b901c46ULL,
0x0000000012437faeULL, 0x0003e8000b901c46ULL, 0x0000000014457faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01a60005080075a7ULL, 0x000e62000800017fULL, 0x000000016e007824ULL, 0x000fe400078e0a03ULL,
0x0000000402077c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff007819ULL, 0x000fe20000011600ULL,
0x00008e00ff8c7b82ULL, 0x000ea40000000a00ULL, 0x00000004078c7825ULL, 0x004fe200078e008cULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff097224ULL, 0x000fce00078e00ffULL,
0x000000100900780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a077210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e0bULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140cULL,
0x0000000702027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e060cULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000109097836ULL, 0x000fce0000000000ULL,
0x01a60005080075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000002077027824ULL, 0x002fc800078e0202ULL,
0x00000001020a7836ULL, 0x000fe20000000000ULL, 0x00000004ff047819ULL, 0x000fc80000011602ULL,
0x0ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000001f02047812ULL, 0x000fc600078ec0ffULL,
0x0000000105097824ULL, 0x000fe400078e020aULL, 0x0000000102077824ULL, 0x000fe400078e0205ULL,
0x00000010040e7824ULL, 0x040fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x00000010040c7824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000805057836ULL, 0x000fe20000000000ULL, 0x000001f00e097812ULL, 0x000fe200078ee209ULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x000001f00c077812ULL, 0x000fe200078ee207ULL,
0x0000000102027824ULL, 0x000fc400078e0205ULL, 0x0000001009097824ULL, 0x100fe400078e0208ULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x0000000f02027812ULL, 0x000fe200078ec0ffULL,
0x000000010a057824ULL, 0x000fe200078e0205ULL, 0x00000000090c7984ULL, 0x000e620000000c00ULL,
0x0000001004157824ULL, 0x000fc600078e00ffULL, 0x0000000007107984ULL, 0x000ea20000000c00ULL,
0x0000000f05047812ULL, 0x000fe400078ec0ffULL, 0x000001f00b057812ULL, 0x000fe400078ee202ULL,
0x000001f0150b7812ULL, 0x000fc600078ee204ULL, 0x0000001005057824ULL, 0x100fe400078e0208ULL,
0x000000100b0b7824ULL, 0x000fe400078e0208ULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001809007388ULL, 0x000fe80000000c00ULL, 0x000000000b0c7984ULL, 0x000e680000000c00ULL,
0x0000000005107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1e7224ULL, 0x002fe400078e000cULL,
0x000000ffff1f7224ULL, 0x000fc400078e000eULL, 0x000000ffff227224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff237224ULL, 0x000fe400078e000fULL, 0x000000ffff207224ULL, 0x000fe200078e0011ULL,
0x0000001c05007388ULL, 0x0003e20000000c00ULL, 0x000000ffff217224ULL, 0x000fc400078e0013ULL,
0x00000001ff0d7424ULL, 0x000fc600078e00ffULL, 0x000000200b007388ULL, 0x0003e60000000c00ULL,
0x01a6000d080c79a7ULL, 0x0002a4000850003fULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x01a6000d080075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff097224ULL, 0x000fce00078e00ffULL, 0x000000100900780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a04077210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e05ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001140aULL, 0x0000000702027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e060aULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000109097836ULL, 0x000fce0000000000ULL, 0x01a6000d080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6000720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x3db504f306027820ULL, 0x010fe20000410000ULL, 0x0000010070707836ULL, 0x000fe20000000000ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0x00000008776c7824ULL, 0x140fe400078e0208ULL,
0xffffffff03047836ULL, 0x000fe40000000000ULL, 0x0000000903067836ULL, 0x000fe40000000000ULL,
0x0000002077627824ULL, 0x000fc400078e0208ULL, 0x000000ffff637224ULL, 0x000fe400078e00ffULL,
0x000000ffff617224ULL, 0x000fce00078e00ffULL, 0x0000000263077836ULL, 0x004fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x0000000161097812ULL, 0x000fc600078e0cffULL,
0x000000600700720cULL, 0x000fe20003f06070ULL, 0x0000010063077824ULL, 0x000fc800078e0270ULL,
0x00000004790e7c24ULL, 0x000fd0000f8e0207ULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x00000003ff267819ULL, 0x002fe20000011605ULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x000000076e0a7248ULL, 0x000fc60007fe0000ULL, 0x0000000426107836ULL, 0x000fe40000000000ULL,
0x0000000826127836ULL, 0x000fe40000000000ULL, 0x00000001100b7824ULL, 0x140fe400078e0205ULL,
0x0000000810147824ULL, 0x000fe400078e00ffULL, 0x00000001120c7824ULL, 0x040fe400078e0205ULL,
0x0000000812277824ULL, 0x000fe200078e00ffULL, 0xfffffff814237812ULL, 0x000fe200078ee20bULL,
0x000000010a0f7824ULL, 0x000fc400078e0a07ULL, 0x00000010050b7824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20cULL, 0x00000001260c7824ULL, 0x100fe200078e020eULL,
0x0000000f1000720cULL, 0x040fe20003fa6070ULL, 0x0000000110107824ULL, 0x000fe200078e020eULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000b0c207212ULL, 0x000fc600078efcffULL,
0x0000001026147836ULL, 0x000fe20000000000ULL, 0x0000000b100c7212ULL, 0x000fe200078efcffULL,
0x0000000c260a7836ULL, 0x000fe20000000000ULL, 0x0000000820207c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000114107824ULL, 0x140fe200078e0205ULL, 0x000000080c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008142b7824ULL, 0x000fe200078e00ffULL, 0x000000090d217c10ULL, 0x000fe200087fe4ffULL,
0x000000010a137824ULL, 0x040fe200078e0205ULL, 0x00000009110d7c10ULL, 0x000fe20008ffe4ffULL,
0x000000080a167824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL,
0x0000000112107824ULL, 0x140fe200078e020eULL, 0x0000000f1200720cULL, 0x080fe20003f26070ULL,
0x000000010a127824ULL, 0x000fe200078e020eULL, 0x0000000f1400720cULL, 0x000fe20003f06070ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff816297812ULL, 0x000fc400078ee213ULL,
0x0000000f0a00720cULL, 0x000fe20003f46070ULL, 0x0000000114147824ULL, 0x000fe200078e020eULL,
0x0000000b10167212ULL, 0x000fe200078efcffULL, 0x0000001426227836ULL, 0x000fe40000000000ULL,
0x0000001826287836ULL, 0x000fe20000000000ULL, 0x0000000816167c10ULL, 0x000fe2000ff7e0ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0x0000000911177c10ULL, 0x000fe20009ffe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000b121a7212ULL, 0x000fc600078efcffULL,
0x0000000122187824ULL, 0x100fe200078e020eULL, 0x0000000b14107212ULL, 0x080fe200078efcffULL,
0x00000001281c7824ULL, 0x000fe200078e020eULL, 0x000000081a1a7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000810107c10ULL, 0x000fe4000ff7e0ffULL,
0x00000009131b7c10ULL, 0x000fe2000a7fe4ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000b18127212ULL, 0x080fe400078efcffULL, 0x0000000915117c10ULL, 0x000fe20009ffe4ffULL,
0x0000001c262c7836ULL, 0x000fe20000000000ULL, 0x0000000b1c147212ULL, 0x000fe200078efcffULL,
0x00004000770a7824ULL, 0x000fe200078e0208ULL, 0x0000000812127c10ULL, 0x000fe2000ff9e0ffULL,
0x000000012c187824ULL, 0x000fe200078e020eULL, 0x0000000814147c10ULL, 0x000fe2000ff7e0ffULL,
0x00002000091c7824ULL, 0x000fe200078e020aULL, 0x0000000919137c10ULL, 0x000fe2000a7fe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000091d157c10ULL, 0x000fc40009ffe4ffULL,
0x0000000f2200720cULL, 0x080fe20003f66070ULL, 0x00000001261d7824ULL, 0x140fe200078e0205ULL,
0x0000000f2600720cULL, 0x000fe20003f86070ULL, 0x000020001c247836ULL, 0x000fe20000000000ULL,
0x0000000b181c7212ULL, 0x000fe200078efcffULL, 0x00000020262e7836ULL, 0x000fe20000000000ULL,
0x000000071d1e7812ULL, 0x000fe200078ec0ffULL, 0x00000001221d7824ULL, 0x040fe200078e0205ULL,
0x000000081c1c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x0ffffff81e257812ULL, 0x000fe200078ef805ULL, 0x000000012e187824ULL, 0x000fc400078e020eULL,
0x0000002426307836ULL, 0x000fe20000000000ULL, 0xfffffff8222d7812ULL, 0x000fe200078ee21dULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0x00000009191d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e2000e101c46ULL, 0x00000001301e7824ULL, 0x000fe200078e020eULL,
0x0000000b18227212ULL, 0x000fe200078efcffULL, 0x00000001282a7824ULL, 0x040fe200078e0205ULL,
0x0000000f2800720cULL, 0x040fe20003f86070ULL, 0x00000008282f7824ULL, 0x000fe200078e00ffULL,
0x0000000822227c10ULL, 0x000fe2000ffde0ffULL, 0x0000002826327836ULL, 0x000fe40000000000ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fc600078ee22aULL,
0x0000001023217824ULL, 0x102fe200078e0224ULL, 0x0000000919237c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001027257824ULL, 0x000fe200078e0224ULL, 0x0000000b1e1e7212ULL, 0x000fe200078efcffULL,
0x0000000132187824ULL, 0x000fe200078e020eULL, 0x000000000c217faeULL, 0x0003e2000e901c46ULL,
0x0000002c262a7836ULL, 0x000fe20000000000ULL, 0x0000000f2c00720cULL, 0x000fe20003fa6070ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000000016257faeULL, 0x0005e2000c901c46ULL,
0x000000081e1e7c10ULL, 0x000fc4000ffde0ffULL, 0x000000012c207824ULL, 0x000fe200078e0205ULL,
0x0000000b18187212ULL, 0x000fe200078efcffULL, 0x000000082c317824ULL, 0x000fe200078e00ffULL,
0x000000091f1f7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000082e277824ULL, 0x000fe200078e00ffULL,
0x0000000818187c10ULL, 0x000fe2000ffde0ffULL, 0x0000001029217824ULL, 0x002fe200078e0224ULL,
0xfffffff831317812ULL, 0x000fe200078ee220ULL, 0x000000012a0c7824ULL, 0x000fe200078e020eULL,
0x0000000919197c10ULL, 0x000fe2000b7fe4ffULL, 0x000000102b177824ULL, 0x004fe200078e0224ULL,
0x000000001a217faeULL, 0x0003e2000d101c46ULL, 0x0000003026167836ULL, 0x000fe20000000000ULL,
0x0000000f2e00720cULL, 0x080fe20003f26070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000010177faeULL, 0x0005e2000c101c46ULL, 0x0000000f3000720cULL, 0x000fc40003f46070ULL,
0x0000001031257824ULL, 0x100fe200078e0224ULL, 0x0000000b0c0c7212ULL, 0x000fe200078efcffULL,
0x000000012e207824ULL, 0x100fe400078e0205ULL, 0x0000000130287824ULL, 0x000fe200078e0205ULL,
0x000000080c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x000000102d1b7824ULL, 0x102fe200078e0224ULL,
0xfffffff827277812ULL, 0x000fe200078ee220ULL, 0x000000102f217824ULL, 0x000fe200078e0224ULL,
0x000000090d0d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000116107824ULL, 0x004fe200078e020eULL,
0x00000000121b7faeULL, 0x000fe2000d901c46ULL, 0x0000000830297824ULL, 0x000fe200078e00ffULL,
0x0000000f1600720cULL, 0x080fe20003f66070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000014217faeULL, 0x0003e2000e101c46ULL, 0x0000000f2a00720cULL, 0x000fc40003f86070ULL,
0xfffffff829297812ULL, 0x000fe200078ee228ULL, 0x000000001c257faeULL, 0x0005e2000e901c46ULL,
0x0000000f3200720cULL, 0x000fe20003fa6070ULL, 0x00000034261a7836ULL, 0x000fe40000000000ULL,
0x0000001027277824ULL, 0x100fe400078e0224ULL, 0x0000001029297824ULL, 0x000fe200078e0224ULL,
0x0000000b10147212ULL, 0x002fe200078efcffULL, 0x0000000132157824ULL, 0x140fe200078e0205ULL,
0x0000000022277faeULL, 0x000fe2000c901c46ULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0x0000000814147c10ULL, 0x000fe2000ffde0ffULL, 0x0000003826207836ULL, 0x000fe20000000000ULL,
0x000000001e297faeULL, 0x0003e2000d101c46ULL, 0x000000011a127824ULL, 0x000fe200078e020eULL,
0xfffffff832177812ULL, 0x000fe200078ee215ULL, 0x0000003c26267836ULL, 0x000fe20000000000ULL,
0x0000000911157c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000116117824ULL, 0x000fe200078e0205ULL,
0x0000000f1a00720cULL, 0x080fe20003f46070ULL, 0x0000000816167824ULL, 0x000fe200078e00ffULL,
0x0000000f2000720cULL, 0x080fe20003f26070ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000f2600720cULL, 0x000fc40003f06070ULL, 0xfffffff8161d7812ULL, 0x004fe200078ee211ULL,
0x0000000120107824ULL, 0x000fe200078e020eULL, 0x0000000b12127212ULL, 0x000fe200078efcffULL,
0x000000012a0f7824ULL, 0x040fe400078e0205ULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x0000000812127c10ULL, 0x000fe2000ffde0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff82a1b7812ULL, 0x000fe200078ee20fULL, 0x00000001260e7824ULL, 0x000fe200078e020eULL,
0x0000000b10107212ULL, 0x000fe200078efcffULL, 0x000000011a167824ULL, 0x000fe200078e0205ULL,
0x0000000913137c10ULL, 0x000fe2000b7fe4ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000810107c10ULL, 0x000fc6000ffde0ffULL, 0x000000081a1f7824ULL, 0x002fe200078e00ffULL,
0x0000000b0e0e7212ULL, 0x000fe200078efcffULL, 0x00000001201a7824ULL, 0x140fe200078e0205ULL,
0x0000000911117c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000820217824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL, 0x00000001261c7824ULL, 0x040fe200078e0205ULL,
0x000000080e0e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000826237824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21aULL, 0x00000010170b7824ULL, 0x100fe200078e0224ULL,
0x000000090f0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000101b177824ULL, 0x100fe200078e0224ULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x000000101d1b7824ULL, 0x100fe200078e0224ULL,
0x00000000180b7faeULL, 0x0003e2000e901c46ULL, 0x000000101f1d7824ULL, 0x000fc400078e0224ULL,
0x00000010211f7824ULL, 0x100fe200078e0224ULL, 0x000000000c177faeULL, 0x0003e2000e101c46ULL,
0x0000001023217824ULL, 0x000fc600078e0224ULL, 0x00000000141b7faeULL, 0x0003e8000d901c46ULL,
0x00000000121d7faeULL, 0x0003e8000d101c46ULL, 0x00000000101f7faeULL, 0x0003e8000c901c46ULL,
0x000000000e217faeULL, 0x0003e2000c101c46ULL, 0x0000000800e07947ULL, 0x000fea0003800000ULL,
0x0000000805107811ULL, 0x042fe200078fe8ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x0000001805187811ULL, 0x040fe400078fe8ffULL, 0x00000004050f7811ULL, 0x040fe200078fe8ffULL,
0x00000001100b7824ULL, 0x140fe200078e0205ULL, 0x0000001005147811ULL, 0x040fe200078fe8ffULL,
0x00000008100c7824ULL, 0x000fe200078e00ffULL, 0x0000000c05127811ULL, 0x040fe200078fe8ffULL,
0x00000001180d7824ULL, 0x140fe200078e0205ULL, 0x0000001405167811ULL, 0x000fe200078fe8ffULL,
0x00000008181c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c2f7812ULL, 0x000fe200078ee20bULL,
0x000000010f0a7824ULL, 0x100fe200078e0205ULL, 0x00000024051d7811ULL, 0x000fe200078fe8ffULL,
0x000000080f2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c377812ULL, 0x000fe200078ee20dULL,
0x00000001140b7824ULL, 0x140fe200078e0205ULL, 0x00000020051c7811ULL, 0x040fe200078fe8ffULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL,
0x00000001120a7824ULL, 0x140fe200078e0205ULL, 0x00000028051e7811ULL, 0x040fe200078fe8ffULL,
0x0000000812317824ULL, 0x000fe200078e00ffULL, 0xfffffff81a337812ULL, 0x000fe200078ee20bULL,
0x000000011c0b7824ULL, 0x140fe200078e0205ULL, 0x0000001c051a7811ULL, 0x040fe200078fe8ffULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20aULL,
0x00000001160c7824ULL, 0x140fe200078e0205ULL, 0x00000034052e7811ULL, 0x040fe200078fe8ffULL,
0x0000000816357824ULL, 0x000fe200078e00ffULL, 0xfffffff8203b7812ULL, 0x000fe200078ee20bULL,
0x000000011a0a7824ULL, 0x140fe200078e0205ULL, 0x0000002c05207811ULL, 0x000fe200078fe8ffULL,
0x000000081a397824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20cULL,
0x000000011d0c7824ULL, 0x100fe200078e0205ULL, 0x0000003805307811ULL, 0x000fe200078fe8ffULL,
0x000000081d3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee20aULL,
0x000000011e0d7824ULL, 0x140fe200078e0205ULL, 0x00000030052c7811ULL, 0x040fe200078fe8ffULL,
0x000000081e227824ULL, 0x000fe200078e00ffULL, 0x0000003c05327811ULL, 0x000fe200078fe8ffULL,
0x00000001200a7824ULL, 0x140fe200078e0205ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL,
0x0000000820417824ULL, 0x000fe200078e00ffULL, 0xfffffff8223f7812ULL, 0x000fe200078ee20dULL,
0x000000012e0c7824ULL, 0x000fc400078e0205ULL, 0x000000082e457824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee20aULL, 0x00000001300d7824ULL, 0x140fe400078e0205ULL,
0x0000000830247824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20cULL,
0x000000012c0b7824ULL, 0x140fe200078e0205ULL, 0x0000000e050c7211ULL, 0x040fe200078fe8ffULL,
0x000000082c227824ULL, 0x000fe200078e00ffULL, 0xfffffff824477812ULL, 0x000fe200078ee20dULL,
0x00000001320a7824ULL, 0x040fe200078e0205ULL, 0x00000005050d7211ULL, 0x040fe200078fe8ffULL,
0x0000000832497824ULL, 0x000fe200078e00ffULL, 0xfffffff822437812ULL, 0x000fe200078ee20bULL,
0x00000010050b7824ULL, 0x000fc400078e00ffULL, 0x000000010f0f7824ULL, 0x000fe200078e020eULL,
0xfffffff849497812ULL, 0x000fe200078ee20aULL, 0x00004000770a7824ULL, 0x000fe200078e0208ULL,
0x000000700b4b7812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x100fe400078e020eULL,
0x0000000112127824ULL, 0x100fe400078e020eULL, 0x0000000114147824ULL, 0x100fe400078e020eULL,
0x0000000116167824ULL, 0x000fc400078e020eULL, 0x0000000118187824ULL, 0x100fe400078e020eULL,
0x000000011a1a7824ULL, 0x100fe400078e020eULL, 0x000000011c1c7824ULL, 0x100fe400078e020eULL,
0x000000011d1d7824ULL, 0x100fe400078e020eULL, 0x000000011e1e7824ULL, 0x100fe400078e020eULL,
0x0000000120207824ULL, 0x000fc400078e020eULL, 0x000000012c2c7824ULL, 0x100fe400078e020eULL,
0x000000012e2e7824ULL, 0x100fe400078e020eULL, 0x0000000130307824ULL, 0x100fe400078e020eULL,
0x0000000132327824ULL, 0x000fe200078e020eULL, 0x000000070d0e7812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0x0ffffff80e0b7812ULL, 0x000fe200078ef805ULL,
0x0000200009117824ULL, 0x000fe200078e020aULL, 0x0000004b0c0c7212ULL, 0x000fe200078efcffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x000000080c0c7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000200011227836ULL, 0x000fe40000000000ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000090d0d7c10ULL, 0x000fc600087fe4ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004b10107212ULL, 0x000fc600078efcffULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x0000000810107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000004b12127212ULL, 0x080fe200078efcffULL,
0x000000100b0b7824ULL, 0x100fe200078e0222ULL, 0x0000004b0e0e7212ULL, 0x000fe200078efcffULL,
0x000000102d2d7824ULL, 0x100fe200078e0222ULL, 0x0000000911117c10ULL, 0x000fe200087fe4ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0222ULL, 0x0000000812127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001031317824ULL, 0x100fe200078e0222ULL, 0x000000080e0e7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001033337824ULL, 0x100fe200078e0222ULL, 0x0000000913137c10ULL, 0x000fe200087fe4ffULL,
0x0000001035357824ULL, 0x100fe200078e0222ULL, 0x000000090f0f7c10ULL, 0x000fe20008ffe4ffULL,
0x0000001037377824ULL, 0x100fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000b901c46ULL, 0x0000001039397824ULL, 0x000fc400078e0222ULL,
0x000000103b3b7824ULL, 0x100fe200078e0222ULL, 0x000000000e2d7faeULL, 0x0003e2000b901c46ULL,
0x000000103d3d7824ULL, 0x100fe400078e0222ULL, 0x000000103f3f7824ULL, 0x100fe200078e0222ULL,
0x00000000102f7faeULL, 0x0003e2000b901c46ULL, 0x0000001041417824ULL, 0x100fe400078e0222ULL,
0x0000001043437824ULL, 0x100fe200078e0222ULL, 0x0000000012317faeULL, 0x0003e2000b901c46ULL,
0x0000001045457824ULL, 0x000fc400078e0222ULL, 0x0000001047477824ULL, 0x100fe400078e0222ULL,
0x0000001049497824ULL, 0x000fe200078e0222ULL, 0x0000004b18227212ULL, 0x000fe200078efcffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000000822227c10ULL, 0x000fe2000ff5e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004b16167212ULL, 0x080fe400078efcffULL,
0x0000000919237c10ULL, 0x000fe200097fe4ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004b14147212ULL, 0x080fe400078efcffULL, 0x0000000816167c10ULL, 0x000fe2000ff1e0ffULL,
0x000000801c187825ULL, 0x000fe200078e00ffULL, 0x0000004b1a247212ULL, 0x000fc400078efcffULL,
0x0000000814147c10ULL, 0x000fe2000ff3e0ffULL, 0x000000801d1c7825ULL, 0x000fe200078e00ffULL,
0x0000000917177c10ULL, 0x000fe400087fe4ffULL, 0x0000004b18267212ULL, 0x080fe200078efcffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000824247c10ULL, 0x000fe4000ff1e0ffULL,
0x0000004b1c287212ULL, 0x000fe200078efcffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000915157c10ULL, 0x000fc40008ffe4ffULL, 0x0000004b1e2a7212ULL, 0x080fe400078efcffULL,
0x0000000826267c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000014337faeULL, 0x0003e2000b901c46ULL,
0x000000091b257c10ULL, 0x000fe200087fe4ffULL, 0x000000802e1a7825ULL, 0x000fe200078e00ffULL,
0x0000000828287c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000016357faeULL, 0x0003e2000b901c46ULL,
0x000000082a2a7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000919277c10ULL, 0x000fe20008ffe4ffULL,
0x000000802c187825ULL, 0x000fe200078e00ffULL, 0x0000004b20207212ULL, 0x080fe200078efcffULL,
0x0000000022377faeULL, 0x0003e2000b901c46ULL, 0x000000091d297c10ULL, 0x000fe200087fe4ffULL,
0x00000080301c7825ULL, 0x000fe200078e00ffULL, 0x000000091f2b7c10ULL, 0x000fe200097fe4ffULL,
0x0000000024397faeULL, 0x0003e2000b901c46ULL, 0x0000000820207c10ULL, 0x000fe2000ff1e0ffULL,
0x00000080321e7825ULL, 0x000fe200078e00ffULL, 0x0000004b18187212ULL, 0x080fe200078efcffULL,
0x00000000263b7faeULL, 0x0003e2000b901c46ULL, 0x0000004b1a1a7212ULL, 0x000fc400078efcffULL,
0x0000004b1c1c7212ULL, 0x080fe200078efcffULL, 0x00000000283d7faeULL, 0x0003e2000b901c46ULL,
0x0000000921217c10ULL, 0x000fe400087fe4ffULL, 0x0000004b1e1e7212ULL, 0x000fe200078efcffULL,
0x000000002a3f7faeULL, 0x0003e2000b901c46ULL, 0x0000000818187c10ULL, 0x000fe4000ff1e0ffULL,
0x000000081a1a7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000020417faeULL, 0x0003e2000b901c46ULL,
0x000000081c1c7c10ULL, 0x000fc4000ff5e0ffULL, 0x000000081e1e7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000919197c10ULL, 0x000fe400087fe4ffULL, 0x000000091b1b7c10ULL, 0x000fe40008ffe4ffULL,
0x000000091d1d7c10ULL, 0x000fe200097fe4ffULL, 0x0000000018437faeULL, 0x0003e2000b901c46ULL,
0x000000091f1f7c10ULL, 0x000fc60009ffe4ffULL, 0x000000001a457faeULL, 0x0003e8000b901c46ULL,
0x000000001c477faeULL, 0x0003e8000b901c46ULL, 0x000000001e497faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fc4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fc4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fcc0000000000ULL, 0xfffffff805147812ULL, 0x000fe200078ec0ffULL,
0x00002000616d7824ULL, 0x000fe200078e020aULL, 0x0000000805187812ULL, 0x000fe200078ec0ffULL,
0x000000010b6f7836ULL, 0x000fe20000000000ULL, 0x0000000714167812ULL, 0x000fe200078ef805ULL,
0x000020006d6d7836ULL, 0x000fe20000000000ULL, 0x00000007181a7812ULL, 0x000fe200078ef805ULL,
0x0000002005767836ULL, 0x000fe40000000000ULL, 0x0000000116147824ULL, 0x000fe200078e020bULL,
0x000000101a687812ULL, 0x000fe200078efcffULL, 0x0000000816157824ULL, 0x000fe200078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ec0ffULL, 0x0000000816177824ULL, 0x000fc400078e00ffULL,
0x0000000116167824ULL, 0x000fe200078e026fULL, 0xfffffff815147812ULL, 0x000fe200078ee214ULL,
0x000000101a187824ULL, 0x040fe200078e00ffULL, 0x0000000776767812ULL, 0x000fe200078ef805ULL,
0x000000101a1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff817167812ULL, 0x000fe200078ee216ULL,
0x00000010145c7824ULL, 0x000fe200078e026dULL, 0x00000004ff147819ULL, 0x000fe20000011605ULL,
0x0000001068177824ULL, 0x000fe400078e00ffULL, 0x0000001016647824ULL, 0x000fc400078e026dULL,
0x000000005c5c783bULL, 0x000e620000000200ULL, 0x000000020b147824ULL, 0x000fe400078e0214ULL,
0x0000000876197824ULL, 0x000fe200078e00ffULL, 0x000000006464783bULL, 0x000ea20000000200ULL,
0x000000011a157824ULL, 0x100fe400078e0214ULL, 0x0000000168167824ULL, 0x000fe400078e0214ULL,
0x00000001766f7824ULL, 0x040fe200078e026fULL, 0xfffffff018157812ULL, 0x000fe200078ee215ULL,
0x0000000176187824ULL, 0x000fe200078e020bULL, 0xfffffff017177812ULL, 0x000fe200078ee216ULL,
0x000000020b0b7836ULL, 0x000fc40000000000ULL, 0x0000001015157824ULL, 0x100fe200078e0208ULL,
0xfffffff819187812ULL, 0x000fe200078ee218ULL, 0x0000000214197836ULL, 0x000fe20000000000ULL,
0x000000080b00780cULL, 0x000fe20003f05270ULL, 0x0000001017177824ULL, 0x000fe200078e0208ULL,
0x000000001558783bULL, 0x0007220000000200ULL, 0x000000011a1a7824ULL, 0x100fe400078e0219ULL,
0x0000000168197824ULL, 0x040fe200078e0219ULL, 0x00000000171c783bULL, 0x000f620000000200ULL,
0x0000001068687824ULL, 0x000fe200078e00ffULL, 0xfffffff01b1b7812ULL, 0x000fc800078ee21aULL,
0xfffffff068197812ULL, 0x000fe200078ee219ULL, 0x000000101b1b7824ULL, 0x000fe400078e0208ULL,
0x0000001018687824ULL, 0x000fcc00078e026dULL, 0x000000006868783bULL, 0x000f220000000200ULL,
0x00000010ff147819ULL, 0x102fe4000001165fULL, 0x00000018ff167819ULL, 0x000fe4000001165fULL,
0x000000ff14147812ULL, 0x000fe400078ec0ffULL, 0x00000016ff16723eULL, 0x000fe400020006ffULL,
0x00000014ff14723eULL, 0x000fe400020006ffULL, 0x0000ffff5f1a7812ULL, 0x040fe200078ec0ffULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x20000014ff157230ULL, 0x008fe20000004100ULL, 0x00000008ff147819ULL, 0x000fc4000001161aULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fe400020006ffULL,
0x00000010ff167819ULL, 0x000fe20000011616ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff157819ULL, 0x000fe20000011615ULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x0000ffff67787812ULL, 0x004fe400078ec0ffULL, 0x0000105416757816ULL, 0x000fe20000000015ULL,
0x0000001019157824ULL, 0x000fe200078e0208ULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x000000001b18783bULL, 0x000e620000000200ULL, 0x00000010ff747819ULL, 0x000fc40000011614ULL,
0x000000ff64927812ULL, 0x000fe200078ec0ffULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x0000105474747816ULL, 0x000fe4000000005fULL, 0x00000018ff5f7819ULL, 0x000fe40000011667ULL,
0x00000018ff9a7819ULL, 0x000fe40000011665ULL, 0x0000005fff71723eULL, 0x000fe200020006ffULL,
0x000000745810723cULL, 0x010fe20000041810ULL, 0x00000010ff5f7819ULL, 0x000fc40000011667ULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000071ff737230ULL, 0x000fe20000004100ULL,
0x000000ff5f717812ULL, 0x000fe200078ec0ffULL, 0x000000741c0c723cULL, 0x020fe2000004180cULL,
0x00000008ff5f7819ULL, 0x000fe40000011678ULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff787819ULL, 0x000fe20000011673ULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff907819ULL, 0x000fe20000011669ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe20000011667ULL,
0x0000000876747824ULL, 0x000fe200078e00ffULL, 0x00000010ff717819ULL, 0x000fc40000011671ULL,
0x00000010ff767819ULL, 0x000fe4000001165fULL, 0xfffffff874747812ULL, 0x000fe400078ee26fULL,
0x00001054787b7816ULL, 0x000fe40000000071ULL, 0x00001054767a7816ULL, 0x000fe20000000067ULL,
0x0000001074747824ULL, 0x000fe200078e026dULL, 0x000000ff5c6f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff717819ULL, 0x000fc40000011664ULL, 0x0000006fff6f723eULL, 0x000fe200020006ffULL,
0x0000007a1810723cULL, 0x002fe20000041810ULL, 0x00000071ff94723eULL, 0x000fe200020006ffULL,
0x00000000747c783bULL, 0x0002e20000000200ULL, 0x00000092ff71723eULL, 0x000fe200020006ffULL,
0x2000006fff997230ULL, 0x000fe20000004100ULL, 0x00000010ff927819ULL, 0x000fe2000001165cULL,
0x0000007a140c723cULL, 0x004fe2000004180cULL, 0x000000ff698a7812ULL, 0x040fe200078ec0ffULL,
0x20000094ff6f7230ULL, 0x000fe20000004100ULL, 0x0000ffff69987812ULL, 0x000fe200078ec0ffULL,
0x20000071ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fc4000001166aULL,
0x00000018ff7b7819ULL, 0x000fe40000011669ULL, 0x00000018ff8e7819ULL, 0x000fe4000001166aULL,
0x000000ff6a8b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff6a957812ULL, 0x000fe400078ec0ffULL,
0x0000ffff5c9b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff967819ULL, 0x000fc4000001166bULL,
0x00000018ff697819ULL, 0x000fe4000001166bULL, 0x000000ff6b6a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff6b977812ULL, 0x000fe400078ec0ffULL, 0x0000009aff9a723eULL, 0x000fe400020006ffULL,
0x00000010ff6b7819ULL, 0x000fe40000011664ULL, 0x0000ffff64787812ULL, 0x000fc400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011666ULL, 0x000000ff92947812ULL, 0x000fe400078ec0ffULL,
0x000000ff668f7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff927819ULL, 0x000fe4000001169bULL,
0x00000018ff5f7819ULL, 0x000fe40000011668ULL, 0x00000018ff6d7819ULL, 0x000fe2000001165cULL,
0x2000009aff5c7230ULL, 0x000fe20000004100ULL, 0x000000ff68757812ULL, 0x000fc400078ec0ffULL,
0x00000064ff9a723eULL, 0x000fe400020006ffULL, 0x00000010ff767819ULL, 0x000fe40000011665ULL,
0x0000008fff64723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x000000ff6b6b7812ULL, 0x000fe200078ec0ffULL, 0x20000094ff9b7230ULL, 0x000fe20000004100ULL,
0x0000005fff8f723eULL, 0x000fe200020006ffULL, 0x2000009aff5f7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x20000092ff9a7230ULL, 0x000fe20000004100ULL,
0x0000008eff9c723eULL, 0x000fe200020006ffULL, 0x2000008fff947230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe200020006ffULL, 0x2000008aff8f7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x00000010ff917819ULL, 0x000fe20000011668ULL,
0x20000075ff927230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe20000011666ULL,
0x2000006aff8a7230ULL, 0x000fe20000004100ULL, 0x0000ffff66747812ULL, 0x002fe400078ec0ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x000000ff76767812ULL, 0x000fe400078ec0ffULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x20000069ff757230ULL, 0x000fe20000004100ULL,
0x0000ffff68687812ULL, 0x000fc400078ec0ffULL, 0x000000ff65677812ULL, 0x040fe400078ec0ffULL,
0x0000006dff66723eULL, 0x000fe400020006ffULL, 0x0000ffff65657812ULL, 0x000fe400078ec0ffULL,
0x0000008bff8e723eULL, 0x000fe200020006ffULL, 0x2000009cff8b7230ULL, 0x000fe20000004100ULL,
0x00000076ff9c723eULL, 0x000fe200020006ffULL, 0x2000006bff767230ULL, 0x000fe20000004100ULL,
0x000000ff91917812ULL, 0x000fe200078ec0ffULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x00000008ff6a7819ULL, 0x000fe20000011668ULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe20000011665ULL, 0x2000009cff657230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fc40000011699ULL, 0x00000010ff6b7819ULL, 0x000fe4000001169aULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000069ff9c723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x000010546b687816ULL, 0x000fe40000000068ULL,
0x00000010ff667819ULL, 0x000fc40000011666ULL, 0x00000010ff697819ULL, 0x000fe4000001169bULL,
0x000000ff906b7812ULL, 0x000fe200078ec0ffULL, 0x20000091ff907230ULL, 0x000fe20000004100ULL,
0x0000105466697816ULL, 0x000fe20000000069ULL, 0x2000006aff917230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000009cff667230ULL, 0x000fe20000004100ULL,
0x00000018ff6a7819ULL, 0x000fe4000001165dULL, 0x00000008ff997819ULL, 0x000fe20000011698ULL,
0x000000685854723cULL, 0x000fe20000041854ULL, 0x000000ff93987812ULL, 0x000fe200078ec0ffULL,
0x2000006bff937230ULL, 0x000fe20000004100ULL, 0x0000006aff9b723eULL, 0x000fc400020006ffULL,
0x00000010ff6b7819ULL, 0x000fe2000001165dULL, 0x000000681c50723cULL, 0x000fe20000041850ULL,
0x000000ff5d9a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5d9d7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff5d7819ULL, 0x100fe4000001165eULL, 0x00000010ff6a7819ULL, 0x000fe2000001165eULL,
0x2000009bff687230ULL, 0x000fe20000004100ULL, 0x0000ffff5e697812ULL, 0x000fc400078ec0ffULL,
0x000000ff5e9c7812ULL, 0x000fe400078ec0ffULL, 0x0000009aff9a723eULL, 0x000fe400020006ffULL,
0x0000005dff5e723eULL, 0x000fe400020006ffULL, 0x000000ff6b9b7812ULL, 0x000fe200078ec0ffULL,
0x2000009aff6b7230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fe2000001169dULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x000000ff6a6a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff697819ULL, 0x000fe40000011669ULL, 0x0000009cff9c723eULL, 0x000fe400020006ffULL,
0x0000009bff9b723eULL, 0x000fe400020006ffULL, 0x0000005dff9a723eULL, 0x000fe200020006ffULL,
0x2000009cff5d7230ULL, 0x000fe20000004100ULL, 0x0000006aff9e723eULL, 0x000fe200020006ffULL,
0x2000009bff9b7230ULL, 0x000fe20000004100ULL, 0x00000069ff9d723eULL, 0x000fe200020006ffULL,
0x2000009aff9a7230ULL, 0x000fe20000004100ULL, 0x00000010ff9c7819ULL, 0x000fe20000011668ULL,
0x2000009eff697230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fe2000001166bULL,
0x2000009dff687230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fc4000001169bULL,
0x00000010ff9b7819ULL, 0x000fe4000001169aULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000099ff99723eULL, 0x000fc400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x00000098ff98723eULL, 0x000fe400020006ffULL,
0x00000008ff9a7819ULL, 0x000fe20000011695ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x000010549c6b7816ULL, 0x000fe2000000006bULL, 0x20000098ff957230ULL, 0x000fe20000004100ULL,
0x000010549b6a7816ULL, 0x000fe4000000006aULL, 0x000010545e697816ULL, 0x000fc40000000069ULL,
0x0000105468687816ULL, 0x000fe4000000005dULL, 0x000000ff969b7812ULL, 0x000fe200078ec0ffULL,
0x20000099ff967230ULL, 0x000fe20000004100ULL, 0x00000008ff977819ULL, 0x000fe20000011697ULL,
0x0000006a584c723cULL, 0x000fe2000004184cULL, 0x0000009aff99723eULL, 0x000fe400020006ffULL,
0x0000009bff98723eULL, 0x000fe400020006ffULL, 0x00000097ff9a723eULL, 0x000fe200020006ffULL,
0x0000006a1c48723cULL, 0x000fe20000041848ULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000010ff937819ULL, 0x000fe20000011693ULL, 0x20000098ff977230ULL, 0x000fe20000004100ULL,
0x00000010ff737819ULL, 0x008fe2000001167dULL, 0x2000009aff5e7230ULL, 0x000fe20000004100ULL,
0x000000685844723cULL, 0x000fe20000041844ULL, 0x00000010ff6a7819ULL, 0x000fc4000001167bULL,
0x00000010ff6b7819ULL, 0x000fe40000011696ULL, 0x00000010ff7b7819ULL, 0x000fe20000011690ULL,
0x000000681c40723cULL, 0x000fe20000041840ULL, 0x00000010ff807819ULL, 0x000fe4000001167eULL,
0x00000010ff907819ULL, 0x000fe4000001168bULL, 0x00000010ff957819ULL, 0x000fe40000011695ULL,
0x00000010ff687819ULL, 0x000fc4000001168fULL, 0x000010546a697816ULL, 0x000fe40000000093ULL,
0x000010546b687816ULL, 0x000fe40000000068ULL, 0x00000010ff6a7819ULL, 0x000fe4000001168eULL,
0x00000010ff997819ULL, 0x000fe40000011699ULL, 0x000000ff7a5d7812ULL, 0x000fe200078ec0ffULL,
0x000000685838723cULL, 0x000fe20000041838ULL, 0x00000010ff8e7819ULL, 0x000fc40000011675ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00000010ff7a7819ULL, 0x000fe20000011692ULL,
0x000000681c28723cULL, 0x000fe20000041828ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff8a7819ULL, 0x000fe4000001168aULL, 0x00000010ff757819ULL, 0x000fe40000011697ULL,
0x00000010ff8b7819ULL, 0x000fc4000001165eULL, 0x000000ff73737812ULL, 0x000fe400078ec0ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00001054906b7816ULL, 0x000fe40000000095ULL,
0x00001054996a7816ULL, 0x000fe2000000006aULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5e7819ULL, 0x000fc40000011674ULL,
0x00001054947b7816ULL, 0x000fe2000000007bULL, 0x0000006a5834723cULL, 0x000fe20000041834ULL,
0x00001054917a7816ULL, 0x000fe4000000007aULL, 0x000010548e757816ULL, 0x000fe40000000075ULL,
0x000010548b747816ULL, 0x000fe2000000008aULL, 0x0000006a1c24723cULL, 0x000fe20000041824ULL,
0x00000010ff817819ULL, 0x100fe4000001167cULL, 0x00000018ff877819ULL, 0x000fc4000001167cULL,
0x000000ff7c867812ULL, 0x040fe200078ec0ffULL, 0x0000007a1c2c723cULL, 0x000fe2000004182cULL,
0x00000073ff68723eULL, 0x000fe400020006ffULL, 0x0000ffff7c7c7812ULL, 0x000fe400078ec0ffULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000068ff6b7230ULL, 0x000fe20000004100ULL,
0x00000018ff897819ULL, 0x000fe2000001167dULL, 0x000000741c20723cULL, 0x000fe20000041820ULL,
0x000000ff7d887812ULL, 0x000fe200078ec0ffULL, 0x20000080ff6a7230ULL, 0x000fe20000004100ULL,
0x00000018ff837819ULL, 0x000fc4000001167eULL, 0x000000ff7e827812ULL, 0x040fe200078ec0ffULL,
0x0000007a583c723cULL, 0x000fe2000004183cULL, 0x00000010ff6d7819ULL, 0x100fe4000001167fULL,
0x00000018ff857819ULL, 0x000fe4000001167fULL, 0x000000ff7f847812ULL, 0x000fe200078ec0ffULL,
0x000000745830723cULL, 0x000fe20000041830ULL, 0x0000ffff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7e7e7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff7c7819ULL, 0x000fe2000001167cULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff687819ULL, 0x000fe40000011671ULL, 0x00000008ff787819ULL, 0x000fc40000011678ULL,
0x000000ff81817812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7d7819ULL, 0x000fe4000001167dULL,
0x00000008ff807819ULL, 0x000fe4000001167eULL, 0x000000ff6d717812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x00000010ff1e7819ULL, 0x000fe40000011667ULL, 0x00000010ff1f7819ULL, 0x000fe40000011665ULL,
0x00000010ff1d7819ULL, 0x000fe40000011666ULL, 0x00000086ff8a723eULL, 0x000fe200020006ffULL,
0x2000005eff867230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe200020006ffULL, 0x2000008aff587230ULL, 0x000fe20000004100ULL,
0x00000083ff83723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x20000088ff597230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x20000083ff7b7230ULL, 0x000fe20000004100ULL,
0x00000089ff89723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x00000082ff5b723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000085ff5e723eULL, 0x000fe200020006ffULL, 0x20000089ff5a7230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000007dff73723eULL, 0x000fe200020006ffULL, 0x20000084ff7a7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000081ff7d7230ULL, 0x000fe20000004100ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000080ff6d7230ULL, 0x000fe20000004100ULL,
0x000010545c1f7816ULL, 0x000fe2000000001fULL, 0x20000071ff657230ULL, 0x000fe20000004100ULL,
0x000010541d1e7816ULL, 0x000fe2000000001eULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000010ff1c7819ULL, 0x000fc4000001165fULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff7e7819ULL, 0x000fe2000001166fULL, 0x0000001e184c723cULL, 0x000fe2000004184cULL,
0x000010541c5d7816ULL, 0x000fe4000000005dULL, 0x00000010ff1c7819ULL, 0x000fe40000011658ULL,
0x00000010ff5c7819ULL, 0x000fe20000011664ULL, 0x0000001e1448723cULL, 0x000fe20000041848ULL,
0x00000010ff1d7819ULL, 0x000fc40000011686ULL, 0x00000010ff587819ULL, 0x000fe40000011659ULL,
0x00000010ff7b7819ULL, 0x000fe4000001167bULL, 0x00000010ff1f7819ULL, 0x000fe4000001167cULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff697819ULL, 0x000fe40000011676ULL,
0x00000010ff6f7819ULL, 0x000fc40000011678ULL, 0x00000010ff647819ULL, 0x000fe40000011687ULL,
0x00000010ff7d7819ULL, 0x000fe4000001167dULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff597819ULL, 0x000fe4000001166bULL, 0x00000010ff737819ULL, 0x000fe40000011673ULL,
0x00000010ff1e7819ULL, 0x000fc4000001165bULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff6d7819ULL, 0x000fe4000001166dULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x000010541f1c7816ULL, 0x000fc4000000001cULL, 0x000010541d5c7816ULL, 0x000fe4000000005cULL,
0x000010547b1f7816ULL, 0x000fe4000000006aULL, 0x000010547e697816ULL, 0x000fe40000000069ULL,
0x000010546f687816ULL, 0x000fe20000000068ULL, 0x0000005c1844723cULL, 0x000fe20000041844ULL,
0x00001054641d7816ULL, 0x000fe4000000007dULL, 0x000010545a597816ULL, 0x000fc40000000059ULL,
0x0000105473587816ULL, 0x000fe20000000058ULL, 0x000000681854723cULL, 0x000fe20000041854ULL,
0x000010546d1e7816ULL, 0x000fe4000000001eULL, 0x000010545e7b7816ULL, 0x000fe40000000065ULL,
0x000010547f7a7816ULL, 0x000fe2000000007aULL, 0x000000681450723cULL, 0x000fec0000041850ULL,
0x0000005c1440723cULL, 0x000fec0000041840ULL, 0x0000001c183c723cULL, 0x000fec000004183cULL,
0x000000581838723cULL, 0x000fec0000041838ULL, 0x0000001e1834723cULL, 0x000fec0000041834ULL,
0x0000007a1830723cULL, 0x000fec0000041830ULL, 0x0000001c142c723cULL, 0x000fec000004182cULL,
0x000000581428723cULL, 0x000fec0000041828ULL, 0x0000001e1424723cULL, 0x000fec0000041824ULL,
0x0000007a1420723cULL, 0x000fe20000041820ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffe400980947ULL, 0x000fde000383ffffULL, 0x00000001ff197424ULL, 0x000fe400078e00ffULL,
0x000000020c0a7220ULL, 0x080fe20000410000ULL, 0x000000020d147220ULL, 0x080fe20000410000ULL,
0x00000002540b7220ULL, 0x080fe20000410000ULL, 0x01a688196c0c79a7ULL, 0x000e62000850003fULL,
0x0000000255557220ULL, 0x080fe20000410000ULL, 0x0000000256567220ULL, 0x080fe20000410000ULL,
0x0000000257577220ULL, 0x080fe20000410000ULL, 0x000000024c4c7220ULL, 0x080fe20000410000ULL,
0x000000024d4d7220ULL, 0x080fe20000410000ULL, 0x000000024e4e7220ULL, 0x080fe20000410000ULL,
0x000000024f4f7220ULL, 0x080fe20000410000ULL, 0x0000000244447220ULL, 0x080fe20000410000ULL,
0x0000000245457220ULL, 0x080fe20000410000ULL, 0x0000000246467220ULL, 0x080fe20000410000ULL,
0x0000000247477220ULL, 0x080fe20000410000ULL, 0x0000000210107220ULL, 0x080fe20000410000ULL,
0x0000000211117220ULL, 0x080fe20000410000ULL, 0x0000000212127220ULL, 0x080fe20000410000ULL,
0x0000000213137220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x000000023e3e7220ULL, 0x080fe20000410000ULL,
0x000000023f3f7220ULL, 0x080fe20000410000ULL, 0x0000000238387220ULL, 0x080fe20000410000ULL,
0x0000000239397220ULL, 0x080fe20000410000ULL, 0x000000023a3a7220ULL, 0x080fe20000410000ULL,
0x000000023b3b7220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000236367220ULL, 0x080fe20000410000ULL,
0x0000000237377220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x0000000232327220ULL, 0x080fe20000410000ULL,
0x0000000233337220ULL, 0x080fe20000410000ULL, 0x0000000250157220ULL, 0x080fe20000410000ULL,
0x0000000251517220ULL, 0x080fe20000410000ULL, 0x0000000252527220ULL, 0x080fe20000410000ULL,
0x0000000253537220ULL, 0x080fe20000410000ULL, 0x0000000248487220ULL, 0x080fe20000410000ULL,
0x0000000249497220ULL, 0x080fe20000410000ULL, 0x000000024a4a7220ULL, 0x080fe20000410000ULL,
0x000000024b4b7220ULL, 0x080fe20000410000ULL, 0x0000000240407220ULL, 0x080fe20000410000ULL,
0x0000000241417220ULL, 0x080fe20000410000ULL, 0x0000000242427220ULL, 0x080fe20000410000ULL,
0x0000000243437220ULL, 0x080fe20000410000ULL, 0x000000020e167220ULL, 0x080fe20000410000ULL,
0x000000020f177220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x080fe20000410000ULL, 0x000000022e2e7220ULL, 0x080fe20000410000ULL,
0x000000022f2f7220ULL, 0x080fe20000410000ULL, 0x0000000228287220ULL, 0x080fe20000410000ULL,
0x0000000229297220ULL, 0x080fe20000410000ULL, 0x000000022a2a7220ULL, 0x080fe20000410000ULL,
0x000000022b2b7220ULL, 0x080fe20000410000ULL, 0x0000000224247220ULL, 0x080fe20000410000ULL,
0x0000000225257220ULL, 0x080fe20000410000ULL, 0x0000000226267220ULL, 0x080fe20000410000ULL,
0x0000000227277220ULL, 0x080fe20000410000ULL, 0x0000000220207220ULL, 0x080fe20000410000ULL,
0x0000000221217220ULL, 0x080fe20000410000ULL, 0x0000000222227220ULL, 0x080fe20000410000ULL,
0x0000000223237220ULL, 0x000fe20000410000ULL, 0x0000000705187812ULL, 0x000fc400078ec0ffULL,
0x00000000001a7805ULL, 0x000fe20000015200ULL, 0x01a6880d6c0075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e1a197210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e1bULL, 0x003d09001900780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401900780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000190e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01a6880d6c0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004050c7824ULL, 0x000fe200078e00ffULL, 0x000000006300720cULL, 0x000fe20003f06070ULL,
0x0000008077197824ULL, 0x000fc600078e0208ULL, 0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL,
0x0000000119197824ULL, 0x000fca00078e020cULL, 0x01a40000190c7984ULL, 0x0002a20000000c00ULL,
0x0000002000648947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x00000072051c7211ULL, 0x040fe200078ff0ffULL, 0x00000004001e7d06ULL, 0x000ee20008209000ULL,
0xffffff0007077836ULL, 0x000fe40000000000ULL, 0x0000000205aa7824ULL, 0x000fe400078e00ffULL,
0x000000181c507836ULL, 0x000fe20000000000ULL, 0x000000076eac7248ULL, 0x000fe40007fe0000ULL,
0x00000006aaaa7812ULL, 0x000fc600078ec0ffULL, 0x00000001acac7824ULL, 0x000fe400078e0a07ULL,
0x00000001aaa97824ULL, 0x000fe200078e0203ULL, 0x0000001e001e7308ULL, 0x008ee20000001000ULL,
0x000000ffff617224ULL, 0x000fca00078e0aacULL, 0x00000061a99a7246ULL, 0x000fe20003800004ULL,
0x0ffffffe1e1a7836ULL, 0x008fe40000000000ULL, 0x000000101c1e7836ULL, 0x000fe40000000000ULL,
0x0000001a001b7305ULL, 0x000724000021f000ULL, 0x000000ffff1a7224ULL, 0x008fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x010fc800078e0a1bULL, 0x000000041d1d7c24ULL, 0x000fc8000f8e02ffULL,
0x0000001d1b5b7227ULL, 0x000fc800078e001aULL, 0x000000081c1b7836ULL, 0x000fe40000000000ULL,
0x0000001c5b1a7227ULL, 0x000fc800078e00ffULL, 0x0000001b5b1d7227ULL, 0x000fc800078e00ffULL,
0x000000ffff547224ULL, 0x000fe400078e0a1dULL, 0x000000ffff597224ULL, 0x000fe400078e0a1aULL,
0x00000004541b7c24ULL, 0x000fe4000f8e021bULL, 0x00000004591c7c24ULL, 0x000fe4000f8e021cULL,
0x0000001e5b1f7227ULL, 0x000fe200078e00ffULL, 0x000000041b007c0cULL, 0x000fe4000bf06070ULL,
0x000000041c007c0cULL, 0x000fe2000bfa6070ULL, 0x000000505b547227ULL, 0x000fc800078e00ffULL,
0x000000ffff5b7224ULL, 0x000fe400078e0a1fULL, 0x000000ffff597224ULL, 0x000fe400078e0a54ULL,
0x000000045b1e7c24ULL, 0x000fe4000f8e021eULL, 0x0000000459507c24ULL, 0x000fe2000f8e0250ULL,
0x00000004ff597c12ULL, 0x000fe2000f8e33ffULL, 0x800000041b1b0c36ULL, 0x000fe20008000000ULL,
0x000000041e007c0cULL, 0x000fe2000bf46070ULL, 0x800000041c1c5c36ULL, 0x000fe20008000000ULL,
0x0000000450007c0cULL, 0x000fe2000bf66070ULL, 0x000000011d1d0836ULL, 0x000fe20000000000ULL,
0x000000041b007c0cULL, 0x000fe2000bfc6070ULL, 0x000000011a1a5836ULL, 0x000fe20000000000ULL,
0x000000041c007c0cULL, 0x000fe2000bf86070ULL, 0x00000001061b7824ULL, 0x000fca00078e02aaULL,
0x000000ac1b00720cULL, 0x000fe20003fa6070ULL, 0x800000041e1e2c36ULL, 0x000fe20008000000ULL,
0x000000611b1b7246ULL, 0x000fe20003800004ULL, 0x8000000450503c36ULL, 0x000fe40008000000ULL,
0x000000011d1d6836ULL, 0x000fe20000000000ULL, 0x000000041e007c0cULL, 0x000fe2000bf26070ULL,
0x000000011a1a4836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x000000011f1f2836ULL, 0x000fe20000000000ULL, 0x0000000450007c0cULL, 0x000fe2000bf06070ULL,
0x0000000154543836ULL, 0x000fe20000000000ULL, 0x0000001a59077207ULL, 0x000fc40007000000ULL,
0x0000001d591d7207ULL, 0x000fe40007000000ULL, 0x0000000704077248ULL, 0x000fe40003fe0000ULL,
0x000000aca900720cULL, 0x000fe20003f86070ULL, 0x000000011f1f1836ULL, 0x000fe20000000000ULL,
0x00000004ff1b7819ULL, 0x000fe2000001161bULL, 0x00000005077c7c24ULL, 0x000fe2000f8e02ffULL,
0x0000001d041d7248ULL, 0x000fe20003fe0000ULL, 0x0000000154540836ULL, 0x000fe20000000000ULL,
0x000000ff9a9a7207ULL, 0x000fc40002000000ULL, 0x000000ff1b077207ULL, 0x000fe20002800000ULL,
0x000000051d6a7c24ULL, 0x000fe2000f8e02ffULL, 0x0000001f591f7207ULL, 0x040fe40007000000ULL,
0x0000007c9a1b7211ULL, 0x000fe200078fe0ffULL, 0x000000017c1d7824ULL, 0x000fe200078e0207ULL,
0x0000005459597207ULL, 0x000fe20007000000ULL, 0x0000000107977824ULL, 0x000fe200078e026aULL,
0x0000001f041f7248ULL, 0x000fe20003fe0000ULL, 0x000000021d1c7825ULL, 0x000fe200078e008cULL,
0x0000005904547248ULL, 0x000fc60003fe0000ULL, 0x000000021b1a7825ULL, 0x000fe200078e008cULL,
0x000000061ca87981ULL, 0x000726000c1e9500ULL, 0x000000051f747c24ULL, 0x000fe2000f8e02ffULL,
0x000000061aa77981ULL, 0x000b22000c1e9500ULL, 0x0000000554547c24ULL, 0x000fe2000f8e02ffULL,
0x0000006a9a5b7211ULL, 0x040fe200078fe0ffULL, 0x0000000107597824ULL, 0x040fe200078e0274ULL,
0x000000749a1f7211ULL, 0x000fe200078fe0ffULL, 0x00000001075d7824ULL, 0x000fe200078e0254ULL,
0x00000010aa837812ULL, 0x000fe200078efcffULL, 0x0000000297967825ULL, 0x000fe200078e008cULL,
0x000000549a077211ULL, 0x000fc600078fe0ffULL, 0x000000025b5a7825ULL, 0x100fe400078e008cULL,
0x0000000696967981ULL, 0x000f24000c1e9500ULL, 0x0000000259587825ULL, 0x100fe400078e008cULL,
0x000000065a957981ULL, 0x000b24000c1e9500ULL, 0x000000021f1c7825ULL, 0x008fc800078e008cULL,
0x000000025d1e7825ULL, 0x000fe200078e008cULL, 0x000000061c947981ULL, 0x000ee6000c1e9500ULL,
0x00000001065d7824ULL, 0x000fe400078e0283ULL, 0x00000002071a7825ULL, 0x022fe200078e008cULL,
0x000000061e1e7981ULL, 0x000f64000c1e9500ULL, 0x000000615d507246ULL, 0x000fe40003800004ULL,
0x0000000658077981ULL, 0x0002e2000c1e9500ULL, 0x0000000183857824ULL, 0x000fe200078e0203ULL,
0x000000ac5d00720cULL, 0x000fc40003f26070ULL, 0x00000004ff507819ULL, 0x000fe20000011650ULL,
0x000000061a937981ULL, 0x000362000c1e9500ULL, 0x000000ac8500720cULL, 0x000fe40003f06070ULL,
0x0000006185997246ULL, 0x000fe40003800004ULL, 0x000000ff505b7207ULL, 0x000fe40000800000ULL,
0x000000ff99997207ULL, 0x000fc60000000000ULL, 0x000000015b5f7824ULL, 0x000fe200078e026aULL,
0x0000007c99597211ULL, 0x042fe200078fe0ffULL, 0x000000017c1d7824ULL, 0x000fe200078e025bULL,
0x0000006a995d7211ULL, 0x000fe200078fe0ffULL, 0x000000025f5e7825ULL, 0x000fe200078e008cULL,
0x00000020aa717812ULL, 0x000fc600078efcffULL, 0x000000021d1c7825ULL, 0x100fe200078e008cULL,
0x000000065e897981ULL, 0x000366000c1e9500ULL, 0x0000000259587825ULL, 0x100fe200078e008cULL,
0x000000061c8b7981ULL, 0x000366000c1e9500ULL, 0x000000025d5c7825ULL, 0x000fe200078e008cULL,
0x0000000658887981ULL, 0x000366000c1e9500ULL, 0x000000015b1b7824ULL, 0x000fe200078e0274ULL,
0x000000065c867981ULL, 0x000f62000c1e9500ULL, 0x00000001065f7824ULL, 0x002fc400078e0271ULL,
0x000000021b1a7825ULL, 0x000fe200078e008cULL, 0x00000074991f7211ULL, 0x040fe400078fe0ffULL,
0x0000005499657211ULL, 0x000fe200078fe0ffULL, 0x000000015b677824ULL, 0x000fe200078e0254ULL,
0x000000615f507246ULL, 0x000fe20003800004ULL, 0x0000000171737824ULL, 0x000fe200078e0203ULL,
0x000000061a1a7981ULL, 0x000362000c1e9500ULL, 0x00000002671c7825ULL, 0x104fe200078e008cULL,
0x000000ac5f00720cULL, 0x080fe40003f26070ULL, 0x000000ac7300720cULL, 0x000fe20003f06070ULL,
0x000000021f5a7825ULL, 0x000fe200078e008cULL, 0x00000004ff507819ULL, 0x000fe20000011650ULL,
0x000000061c1f7981ULL, 0x000564000c1e9500ULL, 0x0000000265587825ULL, 0x000fe200078e008cULL,
0x00000061731b7246ULL, 0x002fe20003800004ULL, 0x000000065a877981ULL, 0x000f62000c1e9500ULL,
0x000000ff505f7207ULL, 0x000fc60000800000ULL, 0x0000000658847981ULL, 0x000362000c1e9500ULL,
0x000000ff1b1d7207ULL, 0x004fc80000000000ULL, 0x0000006a1d697211ULL, 0x000fe200078fe0ffULL,
0x000000015f597824ULL, 0x002fc800078e026aULL, 0x0000000269687825ULL, 0x000fe200078e008cULL,
0x0000007c1d5b7211ULL, 0x000fc600078fe0ffULL, 0x0000000259587825ULL, 0x000fe200078e008cULL,
0x0000000668787981ULL, 0x000ea6000c1e9500ULL, 0x000000017c5d7824ULL, 0x000fe200078e025fULL,
0x00000006587b7981ULL, 0x0002a2000c1e9500ULL, 0x000000025b5a7825ULL, 0x100fe200078e008cULL,
0x000000741d657211ULL, 0x040fe400078fe0ffULL, 0x000000541d1b7211ULL, 0x000fe200078fe0ffULL,
0x000000025d5c7825ULL, 0x000fe200078e008cULL, 0x000000065a7a7981ULL, 0x000ea6000c1e9500ULL,
0x000000015f677824ULL, 0x040fe200078e0274ULL, 0x000000065c7d7981ULL, 0x0002a2000c1e9500ULL,
0x000000015f5f7824ULL, 0x000fe200078e0254ULL, 0x00000030aa597812ULL, 0x002fe200078efcffULL,
0x0000000267667825ULL, 0x000fc800078e008cULL, 0x0000000265647825ULL, 0x000fc800078e008cULL,
0x000000025f5c7825ULL, 0x100fe200078e008cULL, 0x0000000664767981ULL, 0x000ea6000c1e9500ULL,
0x000000021b5a7825ULL, 0x000fe200078e008cULL, 0x000000065c507981ULL, 0x0002a6000c1e9500ULL,
0x00000001066b7824ULL, 0x000fe200078e0259ULL, 0x00000006661b7981ULL, 0x000ea2000c1e9500ULL,
0x00000001595f7824ULL, 0x000fc600078e0203ULL, 0x000000065a757981ULL, 0x0002a2000c1e9500ULL,
0x000000616b1c7246ULL, 0x000fe40003800004ULL, 0x000000ac6b00720cULL, 0x080fe40003f26070ULL,
0x000000ac5f00720cULL, 0x000fe40003f06070ULL, 0x00000004ff1c7819ULL, 0x000fe4000001161cULL,
0x000000615f977246ULL, 0x000fe40003800004ULL, 0x000000ff1c617207ULL, 0x000fc40000800000ULL,
0x000000ff97977207ULL, 0x000fc60000000000ULL, 0x000000017c5d7824ULL, 0x002fe200078e0261ULL,
0x0000007c975b7211ULL, 0x000fe200078fe0ffULL, 0x00000001617f7824ULL, 0x000fe200078e0274ULL,
0x00000074976b7211ULL, 0x000fe200078fe0ffULL, 0x00000001618f7824ULL, 0x000fe200078e026aULL,
0x0000006a97817211ULL, 0x000fe200078fe0ffULL, 0x000000025d5c7825ULL, 0x000fc800078e008cULL,
0x000000025b5a7825ULL, 0x100fe200078e008cULL, 0x000000065c697981ULL, 0x0002a6000c1e9500ULL,
0x000000027f7e7825ULL, 0x100fe200078e008cULL, 0x000000065a667981ULL, 0x0002a6000c1e9500ULL,
0x000000026b6a7825ULL, 0x100fe200078e008cULL, 0x000000067e1c7981ULL, 0x000ea8000c1e9500ULL,
0x000000066a657981ULL, 0x000ea2000c1e9500ULL, 0x000000028f8e7825ULL, 0x000fc800078e008cULL,
0x0000000281807825ULL, 0x000fe200078e008cULL, 0x000000068e677981ULL, 0x0002a4000c1e9500ULL,
0x00000054975d7211ULL, 0x002fe400078fe0ffULL, 0x0000000680647981ULL, 0x000ea2000c1e9500ULL,
0x00000001615b7824ULL, 0x000fe400078e0254ULL, 0x000000025d5c7825ULL, 0x000fc800078e008cULL,
0x000000025b5a7825ULL, 0x000fe200078e008cULL, 0x000000065c5e7981ULL, 0x000ea8000c1e9500ULL,
0x000000065a617981ULL, 0x0002a2000c1e9500ULL, 0xfffffff09a9b7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff987424ULL, 0x000fc800078e00ffULL, 0x00000001aca07824ULL, 0x000fc800078e029bULL,
0x00000001a9b77824ULL, 0x100fe200078e0aa0ULL, 0x00000001aa927812ULL, 0x000fe400078efcffULL,
0xfffffff097977812ULL, 0x000fe400078ec0ffULL, 0x000000b798a67219ULL, 0x000fe200000006ffULL,
0x0000000192917824ULL, 0x000fe400078e0203ULL, 0x00000001ac9a7824ULL, 0x000fe400078e0297ULL,
0x0000000191977824ULL, 0x000fe200078e0aa0ULL, 0x00000008aa8e7812ULL, 0x000fc400078efcffULL,
0x00000009aa8a7812ULL, 0x000fe400078efcffULL, 0x0000009798977219ULL, 0x000fe400000006ffULL,
0xfffffff099997812ULL, 0x000fe200078ec0ffULL, 0x000000018e907824ULL, 0x100fe200078e0203ULL,
0x00000031aa5a7812ULL, 0x002fe200078efcffULL, 0x000000018a8f7824ULL, 0x000fe200078e0203ULL,
0x00000038aa587812ULL, 0x040fe400078efcffULL, 0x00000039aa547812ULL, 0x000fe200078efcffULL,
0x00000001ac9e7824ULL, 0x000fe200078e0299ULL, 0xfffffff01d1d7812ULL, 0x000fe200078ec0ffULL,
0x000000015a5d7824ULL, 0x000fc400078e0203ULL, 0x00000001585c7824ULL, 0x100fe400078e0203ULL,
0x00000001545b7824ULL, 0x000fe400078e0203ULL, 0x0000000190997824ULL, 0x100fe400078e0aa0ULL,
0x000000018fb57824ULL, 0x000fe200078e0aa0ULL, 0x00000011aa827812ULL, 0x000fe200078efcffULL,
0x00000001ac9c7824ULL, 0x000fe200078e021dULL, 0x0000009998997219ULL, 0x000fe200000006ffULL,
0x000000015fa37824ULL, 0x000fc400078e0a9aULL, 0x000000015dab7824ULL, 0x100fe400078e0a9aULL,
0x000000015ca57824ULL, 0x100fe400078e0a9aULL, 0x000000015b1d7824ULL, 0x000fe200078e0a9aULL,
0x000000b5989a7219ULL, 0x000fe200000006ffULL, 0x0000000182817824ULL, 0x000fe200078e0203ULL,
0x00000021aa747812ULL, 0x040fe400078efcffULL, 0x00000028aa6a7812ULL, 0x000fe400078efcffULL,
0x00005410a7a77816ULL, 0x010fc800000000a8ULL, 0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL,
0x000000aca900720cULL, 0x000fc80002fa1470ULL, 0x000000acaa00720cULL, 0x000fe40002fa1070ULL,
0x0000541095957816ULL, 0x000fe40000000096ULL, 0xff8000000b0b7808ULL, 0x000fe40002800000ULL,
0x000000a797ff7212ULL, 0x040fe4000782c0ffULL, 0x00000095a6ff7212ULL, 0x080fe4000784c0ffULL,
0x0000009597ff7212ULL, 0x000fc400078ac0ffULL, 0x0000541094077816ULL, 0x008fc80000000007ULL,
0x00000007a6ff7212ULL, 0x000fe4000788c0ffULL, 0x000000aca900720cULL, 0x0c0fe40001741470ULL,
0x000000aca900720cULL, 0x080fe40002781470ULL, 0x000000ac9100720cULL, 0x0c0fe40000f21470ULL,
0x000000ac9100720cULL, 0x080fe40002fa1470ULL, 0x000000acaa00720cULL, 0x000fc40001741070ULL,
0x000000acaa00720cULL, 0x080fe40002781070ULL, 0x000000ac9200720cULL, 0x0c0fe40000f21070ULL,
0x000000ac9200720cULL, 0x000fe40002fa1070ULL, 0x00005410931e7816ULL, 0x020fe4000000001eULL,
0x00000029aa687812ULL, 0x000fe400078efcffULL, 0xff80000056567808ULL, 0x000fc40001000000ULL,
0xff80000015157808ULL, 0x000fe40002000000ULL, 0xff80000055557808ULL, 0x000fe40000800000ULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x000000a799ff7212ULL, 0x000fe4000786c0ffULL,
0x0000001ea6ff7212ULL, 0x000fe4000780c0ffULL, 0x0000000797ff7212ULL, 0x000fc4000784c0ffULL,
0x0000001e97ff7212ULL, 0x000fe4000788c0ffULL, 0x000000959aff7212ULL, 0x000fe4000782c0ffULL,
0x0000000799ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001746f7824ULL, 0x100fe200078e0203ULL,
0x000000aca900720cULL, 0x080fe20000701470ULL, 0x000000016a6d7824ULL, 0x100fe200078e0203ULL,
0x000000ac9100720cULL, 0x0c0fe20001741470ULL, 0x00000001686b7824ULL, 0x000fe200078e0203ULL,
0x000000ac9100720cULL, 0x080fe20002781470ULL, 0x00000001859b7824ULL, 0x100fe200078e0a9eULL,
0x000000ac9000720cULL, 0x0c0fe20001f61470ULL, 0x0000000181b37824ULL, 0x000fe200078e0a9eULL,
0x000000ac9000720cULL, 0x000fc40002fa1470ULL, 0x000000ac8f00720cULL, 0x080fe20000f21470ULL,
0x00000001739f7824ULL, 0x100fe200078e0a9cULL, 0x00000018aa7e7812ULL, 0x040fe200078efcffULL,
0x000000016faf7824ULL, 0x100fe200078e0a9cULL, 0x00000019aa7c7812ULL, 0x040fe200078efcffULL,
0x000000016da17824ULL, 0x100fe200078e0a9cULL, 0x000000acaa00720cULL, 0x080fe20000701070ULL,
0x000000016bad7824ULL, 0x000fe200078e0a9cULL, 0x000000ac9200720cULL, 0x0c0fe40001741070ULL,
0x000000ac9200720cULL, 0x000fc40002781070ULL, 0x000000ac8e00720cULL, 0x0c0fe40001f61070ULL,
0x000000ac8e00720cULL, 0x080fe40002fa1070ULL, 0x000000ac8a00720cULL, 0x000fe40000f21070ULL,
0x0000009b989b7219ULL, 0x040fe400000006ffULL, 0x000000b3989c7219ULL, 0x000fe400000006ffULL,
0x0000541088887816ULL, 0x000fc4000000008bULL, 0x0000541086867816ULL, 0x000fe20000000089ULL,
0x000000017e807824ULL, 0x100fe200078e0203ULL, 0xff80000052527808ULL, 0x000fe20000000000ULL,
0x000000017c7f7824ULL, 0x000fe200078e0203ULL, 0xff80000051517808ULL, 0x000fe40001000000ULL,
0xff80000053537808ULL, 0x000fe40002000000ULL, 0xff8000004c4c7808ULL, 0x000fe40001800000ULL,
0xff80000048487808ULL, 0x000fc40002800000ULL, 0xff8000004f4f7808ULL, 0x000fe40000800000ULL,
0x0000009599ff7212ULL, 0x040fe4000780c0ffULL, 0x000000079aff7212ULL, 0x040fe4000784c0ffULL,
0x0000001e99ff7212ULL, 0x080fe4000788c0ffULL, 0x0000001e9aff7212ULL, 0x000fe4000786c0ffULL,
0x000000889cff7212ULL, 0x000fc400078ac0ffULL, 0x000000869bff7212ULL, 0x000fe2000782c0ffULL,
0x00000001809d7824ULL, 0x100fe200078e0a9eULL, 0x000000ac9000720cULL, 0x0c0fe20000701470ULL,
0x000000017fb17824ULL, 0x000fe200078e0a9eULL, 0x000000ac9000720cULL, 0x080fe40002781470ULL,
0x000000ac8f00720cULL, 0x0c0fe40001741470ULL, 0x000000ac8f00720cULL, 0x080fe40001f61470ULL,
0x000000ac8500720cULL, 0x000fc40000f21470ULL, 0x000000ac8100720cULL, 0x080fe40002fa1470ULL,
0x000000ac8e00720cULL, 0x0c0fe40000701070ULL, 0x000000ac8e00720cULL, 0x080fe40002781070ULL,
0x000000ac8a00720cULL, 0x0c0fe40001741070ULL, 0x000000ac8a00720cULL, 0x080fe40001f61070ULL,
0x000000ac8300720cULL, 0x000fc40000f21070ULL, 0x000000ac8200720cULL, 0x000fe40002fa1070ULL,
0x0000009d989d7219ULL, 0x040fe400000006ffULL, 0x000000b1989e7219ULL, 0x000fe400000006ffULL,
0x00005410871a7816ULL, 0x000fe4000000001aULL, 0x00005410841f7816ULL, 0x000fe4000000001fULL,
0xff8000004e4e7808ULL, 0x000fc40000000000ULL, 0xff8000004a4a7808ULL, 0x000fe40002000000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40001800000ULL,
0xff80000046467808ULL, 0x000fe40000800000ULL, 0xff80000045457808ULL, 0x000fe40002800000ULL,
0x000000889bff7212ULL, 0x000fc4000780c0ffULL, 0x000000889dff7212ULL, 0x000fe4000788c0ffULL,
0x0000001a9bff7212ULL, 0x0c0fe4000784c0ffULL, 0x0000001f9bff7212ULL, 0x000fe4000786c0ffULL,
0x0000001a9cff7212ULL, 0x000fe4000782c0ffULL, 0x000000869eff7212ULL, 0x000fe400078ac0ffULL,
0x000000ac8500720cULL, 0x000fc40000701470ULL, 0x000000ac8500720cULL, 0x0c0fe40001741470ULL,
0x000000ac8500720cULL, 0x080fe40001f61470ULL, 0x000000ac8100720cULL, 0x080fe40000f21470ULL,
0x000000ac8000720cULL, 0x080fe40002781470ULL, 0x000000ac7f00720cULL, 0x080fe40002fa1470ULL,
0x000000ac8300720cULL, 0x000fc40000701070ULL, 0x000000ac8300720cULL, 0x0c0fe40001741070ULL,
0x000000ac8300720cULL, 0x080fe40001f61070ULL, 0x000000ac8200720cULL, 0x080fe40000f21070ULL,
0x000000ac7e00720cULL, 0x080fe40002781070ULL, 0x000000ac7c00720cULL, 0x000fe40002fa1070ULL,
0x0000009f989f7219ULL, 0x000fc400000006ffULL, 0x0000541078787816ULL, 0x004fe4000000007bULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff80000040407808ULL, 0x000fe40001000000ULL,
0xff80000042427808ULL, 0x000fe40001800000ULL, 0xff80000041417808ULL, 0x000fe40000800000ULL,
0xff80000010107808ULL, 0x000fc40002000000ULL, 0xff80000013137808ULL, 0x000fe40002800000ULL,
0x000000869cff7212ULL, 0x0c0fe4000780c0ffULL, 0x0000001f9cff7212ULL, 0x080fe4000784c0ffULL,
0x000000869dff7212ULL, 0x000fe4000786c0ffULL, 0x0000001a9eff7212ULL, 0x040fe4000782c0ffULL,
0x0000001f9eff7212ULL, 0x000fc4000788c0ffULL, 0x000000789fff7212ULL, 0x000fe400078ac0ffULL,
0x000000ac8100720cULL, 0x0c0fe40000701470ULL, 0x000000ac8100720cULL, 0x080fe40001741470ULL,
0x000000ac8000720cULL, 0x080fe40001f61470ULL, 0x000000ac7f00720cULL, 0x0c0fe40000f21470ULL,
0x000000ac7f00720cULL, 0x000fc40002781470ULL, 0x000000ac7300720cULL, 0x080fe40002fa1470ULL,
0x000000ac8200720cULL, 0x0c0fe40000701070ULL, 0x000000ac8200720cULL, 0x080fe40001741070ULL,
0x000000ac7e00720cULL, 0x080fe40001f61070ULL, 0x000000ac7c00720cULL, 0x0c0fe40000f21070ULL,
0x000000ac7c00720cULL, 0x000fc40002781070ULL, 0x000000ac7100720cULL, 0x000fe40002fa1070ULL,
0x000000af98a07219ULL, 0x000fe400000006ffULL, 0x000054107a7a7816ULL, 0x000fe4000000007dULL,
0x00005410761b7816ULL, 0x000fe4000000001bULL, 0x0000541075507816ULL, 0x000fe40000000050ULL,
0xff80000047477808ULL, 0x000fc40000000000ULL, 0xff80000043437808ULL, 0x000fe40001000000ULL,
0xff80000012127808ULL, 0x000fe40001800000ULL, 0xff80000014147808ULL, 0x000fe40000800000ULL,
0xff80000017177808ULL, 0x000fe40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x000000a79aff7212ULL, 0x000fc400078cc0ffULL, 0x0000001a9dff7212ULL, 0x040fe4000780c0ffULL,
0x0000001f9dff7212ULL, 0x000fe4000784c0ffULL, 0x0000007a9fff7212ULL, 0x040fe4000786c0ffULL,
0x0000001b9fff7212ULL, 0x0c0fe4000782c0ffULL, 0x000000509fff7212ULL, 0x000fe4000788c0ffULL,
0x0000001ba0ff7212ULL, 0x000fc400078ac0ffULL, 0x000000ac8f00720cULL, 0x080fe400037c1470ULL,
0x000000ac8000720cULL, 0x0c0fe40000701470ULL, 0x000000ac8000720cULL, 0x080fe40001741470ULL,
0x000000ac7300720cULL, 0x0c0fe40001f61470ULL, 0x000000ac7300720cULL, 0x0c0fe40000f21470ULL,
0x000000ac7300720cULL, 0x000fc40002781470ULL, 0x000000ac6f00720cULL, 0x080fe40002fa1470ULL,
0x000000ac8a00720cULL, 0x080fe400037c1070ULL, 0x000000ac7e00720cULL, 0x0c0fe40000701070ULL,
0x000000ac7e00720cULL, 0x080fe40001741070ULL, 0x000000ac7100720cULL, 0x0c0fe40001f61070ULL,
0x000000ac7100720cULL, 0x000fc40000f21070ULL, 0x000000ac7100720cULL, 0x080fe40002781070ULL,
0x000000ac7400720cULL, 0x000fe40002fa1070ULL, 0x000000a198a17219ULL, 0x040fe400000006ffULL,
0x000000ad98a27219ULL, 0x000fe400000006ffULL, 0xff8000004d4d7808ULL, 0x000fe40003000000ULL,
0xff8000000a0a7808ULL, 0x000fc40000000000ULL, 0xff80000016167808ULL, 0x000fe40001000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0x000000889eff7212ULL, 0x000fc400078cc0ffULL, 0x0000007aa0ff7212ULL, 0x0c0fe4000780c0ffULL,
0x0000007aa1ff7212ULL, 0x040fe4000784c0ffULL, 0x00000078a0ff7212ULL, 0x040fe4000786c0ffULL,
0x00000050a0ff7212ULL, 0x000fe4000782c0ffULL, 0x00000078a1ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001ba2ff7212ULL, 0x000fc400078ac0ffULL, 0x000000ac7f00720cULL, 0x080fe400037c1470ULL,
0x000000ac6f00720cULL, 0x0c0fe40000701470ULL, 0x000000ac6f00720cULL, 0x0c0fe40001f61470ULL,
0x000000ac6f00720cULL, 0x080fe40000f21470ULL, 0x000000ac6d00720cULL, 0x0c0fe40001741470ULL,
0x000000ac6d00720cULL, 0x000fc40002781470ULL, 0x000000ac6b00720cULL, 0x080fe40002fa1470ULL,
0x000000ac7c00720cULL, 0x080fe400037c1070ULL, 0x000000ac7400720cULL, 0x0c0fe40000701070ULL,
0x000000ac7400720cULL, 0x0c0fe40001f61070ULL, 0x000000ac7400720cULL, 0x080fe40000f21070ULL,
0x000000ac6a00720cULL, 0x000fc40001741070ULL, 0x000000ac6a00720cULL, 0x080fe40002781070ULL,
0x000000ac6800720cULL, 0x000fe40002fa1070ULL, 0x000000a398a37219ULL, 0x000fe400000006ffULL,
0x0000541066667816ULL, 0x000fe40000000069ULL, 0x00005410651c7816ULL, 0x000fe4000000001cULL,
0xff80000011117808ULL, 0x000fc40003000000ULL, 0xff8000003d3d7808ULL, 0x000fe40000000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001800000ULL, 0xff8000002f2f7808ULL, 0x000fe40000800000ULL,
0xff80000038387808ULL, 0x000fe40001000000ULL, 0xff8000003a3a7808ULL, 0x000fe40002000000ULL,
0xff80000029297808ULL, 0x000fc40002800000ULL, 0x0000007aa2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000078a2ff7212ULL, 0x040fe4000780c0ffULL, 0x0000001ba1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000050a1ff7212ULL, 0x080fe4000782c0ffULL, 0x00000050a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000066a3ff7212ULL, 0x000fc4000788c0ffULL, 0x0000001ca3ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ac6d00720cULL, 0x0c0fe40001f61470ULL, 0x000000ac6d00720cULL, 0x080fe40000f21470ULL,
0x000000ac6b00720cULL, 0x0c0fe400037c1470ULL, 0x000000ac6b00720cULL, 0x0c0fe40000701470ULL,
0x000000ac6b00720cULL, 0x000fc40001741470ULL, 0x000000ac5f00720cULL, 0x0c0fe40002781470ULL,
0x000000ac5f00720cULL, 0x080fe40002fa1470ULL, 0x000000ac6a00720cULL, 0x0c0fe40001f61070ULL,
0x000000ac6a00720cULL, 0x080fe40000f21070ULL, 0x000000ac6800720cULL, 0x0c0fe400037c1070ULL,
0x000000ac6800720cULL, 0x000fc40000701070ULL, 0x000000ac6800720cULL, 0x080fe40001741070ULL,
0x000000ac5900720cULL, 0x0c0fe40002781070ULL, 0x000000ac5900720cULL, 0x000fe40002fa1070ULL,
0x000000ab98a47219ULL, 0x040fe400000006ffULL, 0x000000a598a57219ULL, 0x040fe400000006ffULL,
0x0000001d981d7219ULL, 0x000fc400000006ffULL, 0x0000541064647816ULL, 0x000fe40000000067ULL,
0xff80000028287808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000039397808ULL, 0x000fe40003000000ULL, 0xff8000003b3b7808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fc40001000000ULL, 0xff80000034347808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fe40002800000ULL, 0x00000066a4ff7212ULL, 0x080fe4000786c0ffULL,
0x00000066a5ff7212ULL, 0x080fe4000782c0ffULL, 0x000000661dff7212ULL, 0x000fe400078cc0ffULL,
0x00000064a3ff7212ULL, 0x000fc4000780c0ffULL, 0x00000064a4ff7212ULL, 0x0c0fe4000784c0ffULL,
0x00000064a5ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001ca4ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ac5f00720cULL, 0x080fe40000701470ULL, 0x000000ac5d00720cULL, 0x0c0fe40001f61470ULL,
0x000000ac5d00720cULL, 0x000fc40001741470ULL, 0x000000ac5d00720cULL, 0x080fe40002fa1470ULL,
0x000000ac5c00720cULL, 0x0c0fe40000f21470ULL, 0x000000ac5b00720cULL, 0x080fe400037c1470ULL,
0x000000ac5c00720cULL, 0x080fe40002781470ULL, 0x000000ac5900720cULL, 0x080fe40000701070ULL,
0x000000ac5a00720cULL, 0x000fc40001f61070ULL, 0x000000ac5a00720cULL, 0x0c0fe40001741070ULL,
0x000000ac5a00720cULL, 0x080fe40002fa1070ULL, 0x000000ac5800720cULL, 0x080fe40000f21070ULL,
0x000000ac5400720cULL, 0x080fe400037c1070ULL, 0x000000ac5800720cULL, 0x000fe40002781070ULL,
0x000054105e5e7816ULL, 0x000fc40000000061ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40002800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fc40003000000ULL, 0xff80000032327808ULL, 0x000fe40002000000ULL,
0x000000641dff7212ULL, 0x000fe4000780c0ffULL, 0x0000001ca5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000001c1dff7212ULL, 0x000fe4000784c0ffULL, 0x0000005ea3ff7212ULL, 0x080fe400078ac0ffULL,
0x0000005ea4ff7212ULL, 0x000fc4000782c0ffULL, 0x0000005ea5ff7212ULL, 0x080fe400078cc0ffULL,
0x0000005e1dff7212ULL, 0x000fe4000788c0ffULL, 0x000000ac5f00720cULL, 0x080fe40002fa1470ULL,
0x000000ac5d00720cULL, 0x080fe40000f21470ULL, 0x000000ac5c00720cULL, 0x0c0fe40001f61470ULL,
0x000000ac5c00720cULL, 0x000fc400037c1470ULL, 0x000000ac5b00720cULL, 0x0c0fe40000701470ULL,
0x000000ac5b00720cULL, 0x0c0fe40001741470ULL, 0x000000ac5b00720cULL, 0x080fe40002781470ULL,
0x000000ac5900720cULL, 0x080fe40002fa1070ULL, 0x000000ac5a00720cULL, 0x080fe40000f21070ULL,
0x000000ac5400720cULL, 0x000fc40000701070ULL, 0x000000ac5800720cULL, 0x0c0fe40001f61070ULL,
0x000000ac5800720cULL, 0x080fe400037c1070ULL, 0x000000ac5400720cULL, 0x0c0fe40001741070ULL,
0x000000ac5400720cULL, 0x000fe40002781070ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff80000020207808ULL, 0x000fc40001800000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0xff80000027277808ULL, 0x000fe40000800000ULL,
0xff80000022227808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fce0002000000ULL,
0x0000000b0c00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000163637836ULL, 0x000fe40000000000ULL, 0x0000000c0b0c7208ULL, 0x000fe20004000000ULL,
0x000000ffff617224ULL, 0x000fc600078e0009ULL, 0x000000550c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c55077208ULL, 0x000fc80004000000ULL, 0x0000004c0700720bULL, 0x000fc80003f1e000ULL,
0x000000074c0c7208ULL, 0x000fc80004000000ULL, 0x0000004d0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c4d077208ULL, 0x000fc80004000000ULL, 0x000000440700720bULL, 0x000fc80003f1e000ULL,
0x00000007440c7208ULL, 0x000fc80004000000ULL, 0x000000450c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c45077208ULL, 0x000fc80004000000ULL, 0x000000100700720bULL, 0x000fc80003f1e000ULL,
0x00000007100c7208ULL, 0x000fc80004000000ULL, 0x000000110c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c11077208ULL, 0x000fc80004000000ULL, 0x0000003c0700720bULL, 0x000fc80003f1e000ULL,
0x000000073c0c7208ULL, 0x000fc80004000000ULL, 0x0000003d0c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c3d077208ULL, 0x000fc80004000000ULL, 0x000000380700720bULL, 0x000fc80003f1e000ULL,
0x00000007380c7208ULL, 0x000fc80004000000ULL, 0x000000390c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c39077208ULL, 0x000fc80004000000ULL, 0x000000340700720bULL, 0x000fc80003f1e000ULL,
0x00000007340c7208ULL, 0x000fc80004000000ULL, 0x000000350c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c35077208ULL, 0x000fc80004000000ULL, 0x000000300700720bULL, 0x000fc80003f1e000ULL,
0x00000007300c7208ULL, 0x000fe40004000000ULL, 0x000000560d00720bULL, 0x000fe40003f1e000ULL,
0x000000310c00720bULL, 0x000fc80003f3e000ULL, 0x0000000c311a7208ULL, 0x000fe40004800000ULL,
0x0000000d560c7208ULL, 0x000fc60004000000ULL, 0x0c401f001a0d7f89ULL, 0x000ea200000e0000ULL,
0x000000570c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c57077208ULL, 0x000fc80004000000ULL,
0x0000004e0700720bULL, 0x000fc80003f1e000ULL, 0x000000074e0c7208ULL, 0x000fc80004000000ULL,
0x0000004f0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c4f077208ULL, 0x000fe40004000000ULL,
0x0000000d1a00720bULL, 0x004fe40003f3e000ULL, 0x000000460700720bULL, 0x000fe40003f1e000ULL,
0x0000001a0d0d7208ULL, 0x000fe40004800000ULL, 0x00000007460c7208ULL, 0x000fc60004000000ULL,
0x0c201f000d1a7f89ULL, 0x000ea200000e0000ULL, 0x000000470c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c47077208ULL, 0x000fc80004000000ULL, 0x000000120700720bULL, 0x000fc80003f1e000ULL,
0x00000007120c7208ULL, 0x000fc80004000000ULL, 0x000000130c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c13077208ULL, 0x000fe40004000000ULL, 0x0000001a0d00720bULL, 0x004fe40003f3e000ULL,
0x0000003e0700720bULL, 0x000fe40003f1e000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004800000ULL,
0x000000073e1a7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b0c507820ULL, 0x000fe20000410000ULL,
0x0000003f1a00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b441f7823ULL, 0x100fe20000010850ULL,
0x0000001a3f077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b45447823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b10457823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b4c1d7823ULL, 0x100fe20000010850ULL,
0x0000003a0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b114c7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b551c7823ULL, 0x100fe20000010850ULL,
0x000000073a1a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4d1e7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010850ULL,
0x0000003b1a00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010850ULL,
0x0000001a3b077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b34347823ULL, 0x000fe20000010850ULL,
0x0000000b000b7308ULL, 0x000fe40000000800ULL, 0x000000360700720bULL, 0x000fc80003f1e000ULL,
0x00000007361a7208ULL, 0x000fe40004000000ULL, 0x0000001c001c7308ULL, 0x000fe40000000800ULL,
0x000000371a00720bULL, 0x000fc80003f1e000ULL, 0x0000001a37077208ULL, 0x000fe40004000000ULL,
0x0000001d001d7308ULL, 0x000fe40000000800ULL, 0x000000320700720bULL, 0x000fc80003f1e000ULL,
0x00000007321a7208ULL, 0x000fe40004000000ULL, 0x0000001e001e7308ULL, 0x000fe40000000800ULL,
0x000000331a00720bULL, 0x000fc80003f1e000ULL, 0x0000001a331a7208ULL, 0x000fe40004000000ULL,
0x000000150e00720bULL, 0x000fe20003f1e000ULL, 0x0000001f001f7308ULL, 0x000fe40000000800ULL,
0x0c401f001a0d7f89ULL, 0x000ea200000e0000ULL, 0x0000000e150e7208ULL, 0x000fc80004000000ULL,
0x000000510e00720bULL, 0x000fe20003f1e000ULL, 0x0000004400447308ULL, 0x000fe60000000800ULL,
0x0000000e51077208ULL, 0x000fc80004000000ULL, 0x000000480700720bULL, 0x000fe20003f1e000ULL,
0x0000004500457308ULL, 0x000fe60000000800ULL, 0x00000007480e7208ULL, 0x000fc80004000000ULL,
0x000000490e00720bULL, 0x000fe20003f1e000ULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x0000000d1a00720bULL, 0x004fe40003f3e000ULL, 0x0000000e49077208ULL, 0x000fe40004000000ULL,
0x0000001a0d107208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b301a7823ULL, 0x000fe20000010850ULL,
0x000000400700720bULL, 0x000fe20003f1e000ULL, 0x0000003c003c7308ULL, 0x000fe40000000800ULL,
0x0c201f00101b7f89ULL, 0x000ea200000e0000ULL, 0x00000007400e7208ULL, 0x000fc80004000000ULL,
0x000000410e00720bULL, 0x000fe20003f1e000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x0000000e41077208ULL, 0x000fc80004000000ULL, 0x0000000a0700720bULL, 0x000fe20003f1e000ULL,
0x0000003800387308ULL, 0x000fe60000000800ULL, 0x000000070a0d7208ULL, 0x000fc80004000000ULL,
0x000000140d00720bULL, 0x000fe20003f1e000ULL, 0x0000003500077308ULL, 0x0007e20000000800ULL,
0x0000001b1000720bULL, 0x004fe40003f3e000ULL, 0x0000000d14117208ULL, 0x000fe40004000000ULL,
0x000000101b0d7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b311b7823ULL, 0x000fe20000010850ULL,
0x0000002c1100720bULL, 0x000fe20003f1e000ULL, 0x0000003900397308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b0d557820ULL, 0x000fe20000410000ULL, 0x000000112c0e7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b56117823ULL, 0x100fe20000010855ULL, 0x0000002d0e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b13567823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b47547823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b12477823ULL, 0x100fe20000010855ULL, 0x0000000e2d317208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b464d7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b3a467823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b373a7823ULL, 0x100fe20000010855ULL, 0x000000283100720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b57307823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b4f507823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010855ULL, 0x00000031280e7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4e317823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010855ULL, 0x000000290e00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b32377823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b334e7823ULL, 0x000fe20000010855ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x0000000e29357208ULL, 0x008fc40004000000ULL,
0x000000520f00720bULL, 0x000fe40003f1e000ULL, 0x000000243500720bULL, 0x000fe40003f3e000ULL,
0x0000000f520e7208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000003524107208ULL, 0x000fe40004800000ULL, 0x000000530e00720bULL, 0x000fe40003f1e000ULL,
0x000000251000720bULL, 0x000fc40003f3e000ULL, 0x0000000e530f7208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x0000001025357208ULL, 0x000fe40004800000ULL,
0x0000004a0f00720bULL, 0x000fe40003f1e000ULL, 0x000000203500720bULL, 0x000fe40003f3e000ULL,
0x0000000f4a0e7208ULL, 0x000fe20004000000ULL, 0x0000005000507308ULL, 0x000ee20000000800ULL,
0x0000003520107208ULL, 0x000fc40004800000ULL, 0x0000004b0e00720bULL, 0x000fe40003f1e000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000000e4b0f7208ULL, 0x000fe20004000000ULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x0000001021107208ULL, 0x000fe40004800000ULL,
0x000000420f00720bULL, 0x000fe40003f1e000ULL, 0x000000113011723eULL, 0x004fe200000010ffULL,
0x0c401f0010357f89ULL, 0x000ea200000e0000ULL, 0x0000000f420e7208ULL, 0x000fe20004000000ULL,
0x0000005600567308ULL, 0x000fe60000000800ULL, 0x000000430e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e430f7208ULL, 0x000fe20004000000ULL, 0x0000004d004d7308ULL, 0x000fe60000000800ULL,
0x000000160f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f160e7208ULL, 0x000fe20004000000ULL,
0x0000005400547308ULL, 0x000fe60000000800ULL, 0x000000170e00720bULL, 0x000fe40003f1e000ULL,
0x000000351000720bULL, 0x004fe40003f3e000ULL, 0x0000000e170f7208ULL, 0x000fe20004000000ULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x0000001035107208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b36357823ULL, 0x000fe20000010855ULL, 0x0000002e0f00720bULL, 0x000fc60003f1e000ULL,
0x0c201f0010137f89ULL, 0x000ea200000e0000ULL, 0x0000000f2e0e7208ULL, 0x000fe20004000000ULL,
0x0000003f003f7308ULL, 0x000fe60000000800ULL, 0x0000002f0e00720bULL, 0x000fc80003f1e000ULL,
0x0000000e2f0f7208ULL, 0x000fe20004000000ULL, 0x0000004600467308ULL, 0x000fe60000000800ULL,
0x0000002a0f00720bULL, 0x000fc80003f1e000ULL, 0x0000000f2a0e7208ULL, 0x000fe20004000000ULL,
0x0000003b003b7308ULL, 0x000fe60000000800ULL, 0x0000002b0e00720bULL, 0x000fe40003f1e000ULL,
0x000000131000720bULL, 0x004fe40003f3e000ULL, 0x0000000e2b0f7208ULL, 0x000fe20004000000ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x00000010130e7208ULL, 0x000fc40004800000ULL,
0x000000260f00720bULL, 0x000fe40003f1e000ULL, 0x000000315013723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b0e127820ULL, 0x000fe20000410000ULL, 0x0000000f26107208ULL, 0x000fe20004000000ULL,
0x0000001b001b7308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b0a557823ULL, 0x100fe20000010812ULL,
0x000000271000720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b40367823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b24407823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010812ULL,
0x00000010270f7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010812ULL,
0x000000220f00720bULL, 0x000fe20003f1e000ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b414f7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b145a7823ULL, 0x100fe20000010812ULL,
0x0000000f22107208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2c577823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b2d5c7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b29587823ULL, 0x100fe20000010812ULL,
0x000000231000720bULL, 0x000fe20003f1e000ULL, 0x0000005100327308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b25417823ULL, 0x000fc40000010812ULL, 0x0000001023107208ULL, 0x000fca0004000000ULL,
0x0c401f00100f7f89ULL, 0x000f2200000e0000ULL, 0x0000004800337308ULL, 0x000be20000000800ULL,
0x3fb8aa3b28517823ULL, 0x004fe20000010812ULL, 0x000000153214723eULL, 0x008fcc00000010ffULL,
0x00000049005e7308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b20487823ULL, 0x022fce0000010812ULL,
0x0000003600367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21497823ULL, 0x004fe20000010812ULL,
0x0000001d1e12723eULL, 0x000fe400000010ffULL, 0x000000454c1e723eULL, 0x000fe400000010ffULL,
0x0000004d541d723eULL, 0x000fe400000010ffULL, 0x0000000f1000720bULL, 0x010fe20003f1e000ULL,
0x0000004f004f7308ULL, 0x000fe60000000800ULL, 0x000000100f0f7208ULL, 0x000fc40004000000ULL,
0x0000000b1c10723eULL, 0x000fe400000010ffULL, 0x0000001f441c723eULL, 0x000fe200000010ffULL,
0x0c201f000f0a7f89ULL, 0x000e6200000e0000ULL, 0x00000047561f723eULL, 0x000fe200000010ffULL,
0x0000005500557308ULL, 0x000ff00000000800ULL, 0x0000005a005a7308ULL, 0x000ff00000000800ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x0000000a0f00720bULL, 0x002fce0003f1e000ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x0000000f0a0f7208ULL, 0x000fe20004000000ULL,
0x00000004ff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x0000000305ff7812ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b0f247820ULL, 0x000fe20000410000ULL, 0x3f8000000a0a783eULL, 0x000fe200000010ffULL,
0x0000005700577308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b53537823ULL, 0x000fe20000010824ULL, 0x000000ffff0b7224ULL, 0x000fe400078e000aULL,
0x3fb8aa3b16207823ULL, 0x100fe20000010824ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17217823ULL, 0x100fe20000010824ULL, 0x000000335e16723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010824ULL,
0x0000000a1030723cULL, 0x000fe200000418ffULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b2f477823ULL, 0x100fe20000010824ULL, 0x0000004b004b7308ULL, 0x000e620000000800ULL,
0x00000003ff5e7819ULL, 0x000fe20000011605ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fca0000010824ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x0000004a4b17723eULL, 0x002fce00000010ffULL, 0x0000005300537308ULL, 0x000e6a0000000800ULL,
0x0000000a1c30723cULL, 0x000fe60000041830ULL, 0x0000002000297308ULL, 0x0005e80000000800ULL,
0x3fb8aa3b260b7823ULL, 0x000fe20000010824ULL, 0x000000383926723eULL, 0x000fe200000010ffULL,
0x000000ffff387224ULL, 0x100fe200078e000aULL, 0x000000525315723eULL, 0x002fe200000010ffULL,
0x00000021004a7308ULL, 0x0002e20000000800ULL, 0x000000ffff207224ULL, 0x004fe200078e000aULL,
0xfffffff8ff537812ULL, 0x000fe200078ee218ULL, 0x3fb8aa3b23527823ULL, 0x000fe20000010824ULL,
0x0000000405187810ULL, 0x000fe20007ffe05eULL, 0x000000ffff397224ULL, 0x000fc400078e000aULL,
0x0000001053567836ULL, 0x000fe20000000000ULL, 0x0000002e00457308ULL, 0x0005e20000000800ULL,
0x000000ffff217224ULL, 0x002fe200078e000aULL, 0x0000000718187812ULL, 0x000fe200078ec0ffULL,
0x00000008564d7824ULL, 0x000fe400078e00ffULL, 0x0000000853547836ULL, 0x000fe20000000000ULL,
0x000000294a23723eULL, 0x008fe400000010ffULL, 0x0000004200257308ULL, 0x0003e20000000800ULL,
0x00000020142c723cULL, 0x004fe200000418ffULL, 0x00000008544b7824ULL, 0x000fc400078e00ffULL,
0x0000001853597836ULL, 0x000fc80000000000ULL, 0x0000004300287308ULL, 0x0004e20000000800ULL,
0x000000364f20723eULL, 0x000fe200000010ffULL, 0x00000008595b7824ULL, 0x040fe200078e00ffULL,
0xfffffff84b427812ULL, 0x002fe200078ee218ULL, 0x0000000859597824ULL, 0x000fe200078e00ffULL,
0x000000035e367812ULL, 0x000fc600078ec0ffULL, 0x00000047004c7308ULL, 0x0003220000000800ULL,
0x0000000853437824ULL, 0x004fe400078e00ffULL, 0x0000000136367824ULL, 0x000fc600078e0205ULL,
0xfffffff843447812ULL, 0x000fe400078ee218ULL, 0xfffffff84d437812ULL, 0x000fe200078ee218ULL,
0x3fb8aa3b27477823ULL, 0x102fe20000010824ULL, 0x3fb8aa3b224d7823ULL, 0x000fe20000010824ULL,
0x0000003c3d24723eULL, 0x000fe200000010ffULL, 0x000000ffff3c7224ULL, 0x100fe200078e000aULL,
0x000000555a22723eULL, 0x000fe200000010ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e000aULL,
0x000000252821723eULL, 0x008fe200000010ffULL, 0x0000002a004b7308ULL, 0x0003e20000000800ULL,
0x0000003e3f25723eULL, 0x000fe200000010ffULL, 0x00000008563f7824ULL, 0x000fe200078e00ffULL,
0x000000463b27723eULL, 0x000fe200000010ffULL, 0x000000ffff3e7224ULL, 0x000fe200078e001cULL,
0x000000454c29723eULL, 0x010fe200000010ffULL, 0x0000003c202c723cULL, 0x000fe2000004182cULL,
0x0000000736367812ULL, 0x000fe200078ec0ffULL, 0x0000002b00507308ULL, 0x000ea20000000800ULL,
0x00000051582a723eULL, 0x002fe200000010ffULL, 0x000000ffff517224ULL, 0x000fe200078e000aULL,
0xfffffff83f4a7812ULL, 0x000fe200078ee236ULL, 0x000000382430723cULL, 0x000fe20000041830ULL,
0x00000008533d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8594c7812ULL, 0x000fe200078ee236ULL,
0x000000ffff3f7224ULL, 0x000fe200078e001eULL, 0x0000005c005c7308ULL, 0x000e620000000800ULL,
0xfffffff85b187812ULL, 0x000fe200078ee218ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0025ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee236ULL, 0x0000000854397824ULL, 0x000fc400078e00ffULL,
0x000000ffff257224ULL, 0x000fe200078e0016ULL, 0x0000004b502b723eULL, 0x004fe200000010ffULL,
0x000000ffff507224ULL, 0x100fe200078e000aULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0xfffffff839467812ULL, 0x000fe200078ee236ULL, 0x000000ffff167224ULL, 0x000fe200078e0021ULL,
0x0000001a1b36723eULL, 0x000fe200000010ffULL, 0x000000ffff1a7224ULL, 0x100fe200078e000aULL,
0x000000575c28723eULL, 0x002fe200000010ffULL, 0x000000ffff1b7224ULL, 0x000fe400078e000aULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x000000ffff217224ULL, 0x000fc600078e002bULL,
0x00000050282c723cULL, 0x000fe2000004182cULL, 0x000000340734723eULL, 0x004fc600000010ffULL,
0x0000003a003a7308ULL, 0x000e620000000800ULL, 0x0000100077077824ULL, 0x000fc800078e0208ULL,
0x0001200007077836ULL, 0x000fc60000000000ULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x0000001044447824ULL, 0x100fe400078e0207ULL, 0x0000001046467824ULL, 0x100fe400078e0207ULL,
0x000000104a4a7824ULL, 0x100fe200078e0207ULL, 0x000000353a35723eULL, 0x002fe400000010ffULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x000000104c4c7824ULL, 0x100fe400078e0207ULL,
0x0000001018187824ULL, 0x000fc400078e0207ULL, 0x000000ffff1e7224ULL, 0x000fc600078e0035ULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x000000374e37723eULL, 0x002fce00000010ffULL,
0x0000004100417308ULL, 0x000e620000000800ULL, 0x0000001a3430723cULL, 0x000fee0000041830ULL,
0x0000004800487308ULL, 0x000fe20000000800ULL, 0x00000010431a7824ULL, 0x000fe200078e0207ULL,
0x000000404138723eULL, 0x002fcc00000010ffULL, 0x0000004900497308ULL, 0x000e620000000800ULL,
0x000000ffff407224ULL, 0x100fe400078e000aULL, 0x000000ffff417224ULL, 0x000fe400078e000aULL,
0x000000103d0a7824ULL, 0x000fe400078e0207ULL, 0x000000ffff3d7224ULL, 0x000fe200078e0012ULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x000000ffff437224ULL, 0x000fe400078e0036ULL,
0x000000ffff127224ULL, 0x000fc400078e001dULL, 0x000000ffff1d7224ULL, 0x000fe200078e0027ULL,
0x00000048493a723eULL, 0x002fe400000010ffULL, 0x00000047003c7308ULL, 0x000e620000000800ULL,
0x000000ffff277224ULL, 0x000fe400078e0022ULL, 0x000000ffff357224ULL, 0x000fe400078e002aULL,
0x000000ffff367224ULL, 0x000fe400078e0038ULL, 0x000000ffff317224ULL, 0x000fe200078e0032ULL,
0x0000004d003b7308ULL, 0x000fe20000000800ULL, 0x0000000b3c39723eULL, 0x002fce00000010ffULL,
0x0000005200527308ULL, 0x000e620000000800ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0010ULL,
0x00000010420b7824ULL, 0x000fe400078e0207ULL, 0x000000ffff107224ULL, 0x000fe200078e0011ULL,
0x0000003c0a007844ULL, 0x0005e20000000200ULL, 0x000000ffff427224ULL, 0x000fe400078e0034ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff137224ULL, 0x000fc400078e001fULL,
0x000000ffff1f7224ULL, 0x000fe200078e0037ULL, 0x0000003b523b723eULL, 0x002fe200000010ffULL,
0x000000ffff347224ULL, 0x000fe400078e0028ULL, 0x000000ffff377224ULL, 0x000fe400078e003aULL,
0x000000ffff227224ULL, 0x000fe400078e0039ULL, 0x00000040382c723cULL, 0x000fe2000004182cULL,
0x00000001ff077424ULL, 0x000fcc00078e00ffULL, 0x000000ffff407224ULL, 0x000fe400078e0024ULL,
0x000000ffff417224ULL, 0x000fe400078e0026ULL, 0x000000ffff247224ULL, 0x000fe400078e0014ULL,
0x000000ffff267224ULL, 0x000fe200078e0020ULL, 0x0000004044007844ULL, 0x0005e20000000200ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff157224ULL, 0x000fe200078e0017ULL,
0x0000001046007844ULL, 0x0005e20000000200ULL, 0x000000ffff177224ULL, 0x000fc400078e0023ULL,
0x000000ffff207224ULL, 0x000fe200078e0029ULL, 0x0000001c0b007844ULL, 0x0005e20000000200ULL,
0x000000ffff237224ULL, 0x000fe400078e003bULL, 0x000000ffff327224ULL, 0x000fe200078e002cULL,
0x000000244a007844ULL, 0x0005e20000000200ULL, 0x000000ffff337224ULL, 0x000fc600078e002eULL,
0x000000341a007844ULL, 0x0005e80000000200ULL, 0x000000144c007844ULL, 0x0005e80000000200ULL,
0x0000002018007844ULL, 0x0005e80000000200ULL, 0x01a0000c19008388ULL, 0x0005e80000000c00ULL,
0x01a2003019008388ULL, 0x0005e20000000c00ULL, 0x000000606300720cULL, 0x000fe20003f06070ULL,
0x01a6080762ff79a7ULL, 0x0005e2000850003fULL, 0x01a6100762ff79a7ULL, 0x0005e2000850003fULL,
0x01a6180762ff79a7ULL, 0x0005e2000850003fULL, 0x01a6200762ff79a7ULL, 0x0005f2000850003fULL,
0xffffff8800308947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x018000007d007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000007d00008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff7dff7812ULL, 0x040fe4000780c0ffULL, 0x800000007d027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000007d00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffe6402f87950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004ebULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000668ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c4ULL, 0x0000000000000710ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010d8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000019900ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001aa80ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001aac0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000001aac0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x000000000001b0b0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001b0b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001120ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019900ULL,
0x0000000000019900ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001aa80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001aac0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_90_cubin_len = 111104;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
