/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001bfc0ULL, 0x000000000001bc40ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL,
0x326d735f61647563ULL, 0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL,
0x746e695f5f240068ULL, 0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL,
0x66625f636e79736cULL, 0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL,
0x5f30376d735f6164ULL, 0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL,
0x5f5f245f335f6c61ULL, 0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL,
0x2e616c65722e0074ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL,
0x6c656e72656b2e74ULL, 0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL,
0x766e2e0066754265ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL,
0x65642e006d617261ULL, 0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL,
0x616c65722e00656dULL, 0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL,
0x00000000006e6f69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000030ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c00010000037fULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000003cdULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b002200000413ULL,
0x000000000001a040ULL, 0x0000000000000180ULL, 0x000b002200000446ULL, 0x000000000001a1c0ULL,
0x0000000000000040ULL, 0x000b002200000471ULL, 0x000000000001a200ULL, 0x0000000000000050ULL,
0x000b00220000049bULL, 0x000000000001a250ULL, 0x0000000000000130ULL, 0x000a000300000509ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000529ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000559ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001a380ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001a04000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x00667c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0001a04000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL, 0x80809f082880809eULL,
0xa308288080a10828ULL, 0x288080a508288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL,
0x8080d208288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080d292ULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001a1c000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL, 0x80809f082880809eULL,
0xa308288080a10828ULL, 0x288080a608288080ULL, 0x80ec08288080ea08ULL, 0x08288080f0082880ULL,
0x8080a508288080f2ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080a592ULL,
0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001a20000000000ULL, 0x0000005000000000ULL,
0x0000040400000000ULL, 0x80ea288080a50900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL,
0x082880809d082880ULL, 0x80809f082880809eULL, 0xa308288080a10828ULL, 0x288080a508288080ULL,
0x80ec08288080ea08ULL, 0x08288080f0082880ULL, 0x8080a608288080f2ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080a692ULL, 0x0000001cffffffffULL, 0x0000028000000000ULL,
0x0001a25000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL,
0x00082304000000dcULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL,
0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL,
0x0000001600080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL, 0x0021f0000058000aULL,
0x00000000000c1704ULL, 0x0021f00000500009ULL, 0x00000000000c1704ULL, 0x0011f00000480008ULL,
0x00000000000c1704ULL, 0x0061f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x019c290400000eb0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x019c2804ffffffffULL, 0x00000360000002f0ULL, 0x00002a80000005a0ULL,
0x00002c4000002b30ULL, 0x00002f2000002db0ULL, 0x0000350000003080ULL, 0x0000355000003540ULL,
0x00005ee000003580ULL, 0x0000609000005f80ULL, 0x0000637000006200ULL, 0x00006940000064d0ULL,
0x0000699000006980ULL, 0x00009290000069c0ULL, 0x0000944000009330ULL, 0x00009720000095b0ULL,
0x00009cf000009880ULL, 0x00009d4000009d30ULL, 0x0000c4e000009d70ULL, 0x0000c6900000c580ULL,
0x0000c9700000c800ULL, 0x0000cf300000cad0ULL, 0x0000cf800000cf70ULL, 0x0000eca00000cfb0ULL,
0x0000ecc00000ecb0ULL, 0x00017e900000ecd0ULL, 0x00017ee000017ed0ULL, 0x00017f4000017ef0ULL,
0x00017f8000017f60ULL, 0x000193c000017f90ULL, 0x0001945000019410ULL, 0x000194b000019480ULL,
0x00019520000194e0ULL, 0x000195a000019560ULL, 0x00019630000195e0ULL, 0x000196c000019680ULL,
0x00019720000196f0ULL, 0x0001979000019750ULL, 0x00019810000197d0ULL, 0x000198a000019850ULL,
0x00019930000198f0ULL, 0x0001999000019960ULL, 0x00019a00000199c0ULL, 0x00019a8000019a40ULL,
0x00019b1000019ac0ULL, 0x00019ba000019b60ULL, 0x00019c0000019bd0ULL, 0x00019c7000019c30ULL,
0x00019cf000019cb0ULL, 0x00019d8000019d30ULL, 0x00019e4000019de0ULL, 0x00019f0000019ea0ULL,
0x00019fc000019f60ULL, 0x044039040001a020ULL, 0x000000ff00000410ULL, 0x003f010000012600ULL,
0x0000000f00000440ULL, 0x003f012000012608ULL, 0x0000000f000004c0ULL, 0x003f012000012688ULL,
0x0000000f00000520ULL, 0x003f0120000126a8ULL, 0x0000000f00000530ULL, 0x003f0120000126c8ULL,
0x000000ff00000ed0ULL, 0x003f010700012600ULL, 0x0000001400001020ULL, 0x003f01020001268cULL,
0x00000014000010b0ULL, 0x003f010100012688ULL, 0x000000ff000019e0ULL, 0x0004010700000000ULL,
0x000000ff00001a60ULL, 0x0004010100000000ULL, 0x0000000200001ac0ULL, 0x003f010100000020ULL,
0x0000000c00001c30ULL, 0x003f0105000126ccULL, 0x0000000c00001e00ULL, 0x003f0105000126ccULL,
0x0000001f00002620ULL, 0x003f0107000126b0ULL, 0x0000001f000026e0ULL, 0x003f0101000126b0ULL,
0x0000001c00002740ULL, 0x003f010100012608ULL, 0x0000002300002780ULL, 0x003f01050001260cULL,
0x0000002300002960ULL, 0x003f01050001260cULL, 0x0000001f00003230ULL, 0x003f0105000126acULL,
0x0000001f00003420ULL, 0x003f0105000126acULL, 0x0000006800005100ULL, 0x003f010100000000ULL,
0x0000001f00005160ULL, 0x003f010100012688ULL, 0x0000000d00005190ULL, 0x003f010500000004ULL,
0x0000000d00005350ULL, 0x003f010500000004ULL, 0x0000000800005aa0ULL, 0x003f010700000000ULL,
0x0000000800005b80ULL, 0x003f010100000000ULL, 0x0000002300005be0ULL, 0x003f010100012628ULL,
0x0000006a00005c40ULL, 0x003f01050001262cULL, 0x0000006a00005e10ULL, 0x003f01050001262cULL,
0x0000006a000066a0ULL, 0x003f0105000126b4ULL, 0x0000006a00006870ULL, 0x003f0105000126b4ULL,
0x0000006a000084d0ULL, 0x003f010100000000ULL, 0x0000002600008530ULL, 0x003f010100012690ULL,
0x0000000d00008560ULL, 0x003f010500000004ULL, 0x0000000d00008720ULL, 0x003f010500000004ULL,
0x000000ff00008ea0ULL, 0x0004010700000008ULL, 0x0000006800008f30ULL, 0x003f0101000126b0ULL,
0x0000002300008f90ULL, 0x003f010100012648ULL, 0x0000002300008ff0ULL, 0x003f01050001264cULL,
0x00000023000091c0ULL, 0x003f01050001264cULL, 0x0000000800009a50ULL, 0x003f010500000004ULL,
0x0000000800009c20ULL, 0x003f010500000004ULL, 0x000000260000b740ULL, 0x003f010100000000ULL,
0x000000200000b7a0ULL, 0x003f010100012698ULL, 0x0000000d0000b7d0ULL, 0x003f010500000004ULL,
0x0000000d0000b990ULL, 0x003f010500000004ULL, 0x000000ff0000c130ULL, 0x0004010700000000ULL,
0x000000080000c1e0ULL, 0x003f010100000000ULL, 0x0000000c0000c240ULL, 0x003f010100012668ULL,
0x0000000c0000c260ULL, 0x003f01050001266cULL, 0x0000000c0000c430ULL, 0x003f01050001266cULL,
0x000000260000cc90ULL, 0x003f0105000126b4ULL, 0x000000260000ce60ULL, 0x003f0105000126b4ULL,
0x0000000d0000e9f0ULL, 0x003f010100000000ULL, 0x0000000a0000ea70ULL, 0x003f010100000000ULL,
0x000000ff00010cf0ULL, 0x003f010100012600ULL, 0x000000ff000118d0ULL, 0x003f010500012604ULL,
0x000000ff00011ae0ULL, 0x003f010500012604ULL, 0x000000ff00011e60ULL, 0x003f010100012600ULL,
0x000000ff00011e90ULL, 0x003f010500012604ULL, 0x000000ff00012050ULL, 0x003f010500012604ULL,
0x0000006a00015100ULL, 0x003f010100000000ULL, 0x0000006a000151f0ULL, 0x003f010500000004ULL,
0x0000006a000153c0ULL, 0x003f010500000004ULL, 0x0000001800019220ULL, 0x003f010100000000ULL,
0x0000001800019280ULL, 0x003f010100000008ULL, 0x00000018000192e0ULL, 0x003f010100000010ULL,
0x0000001800019350ULL, 0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000fc500000fc20ULL,
0x000100d00000fee0ULL, 0x000104b0000102c0ULL, 0x00010890000106a0ULL, 0x00010c4000010a90ULL,
0x00019390000120b0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL,
0x0000001900000002ULL, 0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x0000000000000308ULL, 0x0000001900000002ULL, 0x0000000000000238ULL,
0x0000001900000002ULL, 0x0000000000000178ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x000000010e040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0003ULL,
0x00005c000e020625ULL, 0x000fe200078e0003ULL, 0x0000000604690981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000087919ULL, 0x000e620000002600ULL, 0x00005a00ff117624ULL, 0x000fc600078e00ffULL,
0x00000000000d7919ULL, 0x000e620000002300ULL, 0x0000590011117a24ULL, 0x000fc600078e02ffULL,
0x00000000001a7919ULL, 0x000e620000002100ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000864000021f000ULL,
0x000000ffff067224ULL, 0x010fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002200ULL, 0x0000040007097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x008fc800078e0a09ULL, 0x0000040003007624ULL, 0x000fca00078e0210ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000ee20000209000ULL, 0x000000ff0900720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047810ULL, 0x008fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000724000021f000ULL, 0x000000ffff047224ULL, 0x008fe400078e00ffULL,
0x0000000509037224ULL, 0x010fc800078e02ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a03ULL,
0x0000000305057227ULL, 0x000fc800078e0004ULL, 0x000001000d037a24ULL, 0x002fe400078e0206ULL,
0x00000008051b7227ULL, 0x000fe200078e00ffULL, 0x00001fff0d0d7589ULL, 0x000fe600000e0000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a1bULL, 0x00000000030f7a24ULL, 0x100fe200078e021aULL,
0x00000005ff1a7819ULL, 0x000fe2000001161aULL, 0x0000000009007224ULL, 0x000fc600078e0208ULL,
0x000000ff0f00720cULL, 0x040fe40003f65270ULL, 0x000000090000720cULL, 0x000fe20003fa6070ULL,
0x00001fff1a1a7589ULL, 0x000e6200000e0000ULL, 0x0000000f0f00780cULL, 0x040fe40003f24070ULL,
0x0000007f0f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff04b424ULL, 0x000fe400078e00ffULL,
0x0000000100005824ULL, 0x000fe200078e0a09ULL, 0x000000011b1b5810ULL, 0x000fe20007ffe0ffULL,
0x7fffff80ff05b424ULL, 0x000fe200078e00ffULL, 0x000000030f00780cULL, 0x040fe20003fa4070ULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x000000090000720cULL, 0x000fe20003fc6070ULL,
0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL, 0x01260004ff00b388ULL, 0x0007e20000000a00ULL,
0x000000010f00780cULL, 0x000fe20003f64070ULL, 0xff317217ff0ca424ULL, 0x000fc400078e00ffULL,
0x012608060f009388ULL, 0x000fe80000008a00ULL, 0x0124000c0f00a388ULL, 0x000fe20000004800ULL,
0x3fffff60ff04d424ULL, 0x008fe400078e00ffULL, 0x000000011b1b6810ULL, 0x000fe20007ffe0ffULL,
0x7fffff60ff05d424ULL, 0x000fe200078e00ffULL, 0x00000009ff1bc212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff0ab424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff0bb424ULL, 0x000fe200078e00ffULL,
0x012688040f00d388ULL, 0x000fe20000008a00ULL, 0x000000ffff197224ULL, 0x000fc800078e0a1bULL,
0x0000001909197224ULL, 0x000fe400078e0208ULL, 0x3fffff80ff08d424ULL, 0x000fe400078e00ffULL,
0x0000002019197824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff09d424ULL, 0x000fca00078e00ffULL,
0x0126a8080f00d388ULL, 0x000fe80000008a00ULL, 0x0126c80a0f00b388ULL, 0x000fe20000008a00ULL,
0x0000000169690824ULL, 0x004fe400078e0a02ULL, 0x00005800ff698624ULL, 0x000fe400078e00ffULL,
0x000058000e028a24ULL, 0x000fe400078e02ffULL, 0x00005a0069007a24ULL, 0x000fc400078e02ffULL,
0x00000011026e7224ULL, 0x000fe400078e02ffULL, 0x0000000100037824ULL, 0x040fe200078e0a19ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000190000720cULL, 0x000fe20003f26070ULL,
0x000000040d007824ULL, 0x002fe200078e021aULL, 0x0000002003037817ULL, 0x000fe20003800000ULL,
0x00005a001b137a24ULL, 0x000fc400078e026eULL, 0x0000000400007824ULL, 0x000fe200078e00ffULL,
0x000000ff03187207ULL, 0x000fc80000800000ULL, 0x000000201800780cULL, 0x000fda0003f05270ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00005a0000037b06ULL, 0x000e620000209000ULL,
0x0000000000177919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fcc00078e00ffULL,
0x0000000300037308ULL, 0x002e620000001000ULL, 0x00000004ff077819ULL, 0x004fc80000011617ULL,
0x0000000207097810ULL, 0x000fe20007ffe0ffULL, 0x0000000100087824ULL, 0x000fe200078e0207ULL,
0x0ffffffe03057810ULL, 0x002fc60007ffe0ffULL, 0x00000001000a7824ULL, 0x000fc600078e0209ULL,
0x0000000500057305ULL, 0x000e62000021f000ULL, 0x00000001190c7824ULL, 0x000fe400078e020aULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a05ULL, 0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b05037227ULL, 0x000fc800078e0004ULL, 0x0000000119047824ULL, 0x000fe400078e0208ULL,
0x0000000c030b7227ULL, 0x000fc800078e00ffULL, 0x0000000403057227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a05ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a0bULL,
0x00005a0003037a24ULL, 0x000fe400078e0204ULL, 0x00005a000f067a24ULL, 0x000fc600078e020cULL,
0x00005a0003007a0cULL, 0x000fe40003f06070ULL, 0x00005a0006007a0cULL, 0x000fd60003f46070ULL,
0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0006062a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0x00005a0006007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b2810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fe400078e33ffULL,
0x0000000018037217ULL, 0x000fe40007800000ULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x000000010b0b3810ULL, 0x000fe20007ffe0ffULL, 0x0000000103007824ULL, 0x000fe200078e0a00ULL,
0x0000000506057207ULL, 0x040fe20004000000ULL, 0x0000001017037824ULL, 0x000fe200078e00ffULL,
0x0000000b06067207ULL, 0x000fc40004000000ULL, 0x000000000700720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0a05ULL, 0x000000000900720cULL, 0x000fe20003f26070ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0a06ULL, 0x000000f003097812ULL, 0x000fe200078ec0ffULL,
0x00005a000b047a24ULL, 0x000fe400078e0204ULL, 0x00005a000f0c7a24ULL, 0x000fe400078e020cULL,
0x0000000113047824ULL, 0x040fe400078e0204ULL, 0x00000001130b7824ULL, 0x000fc400078e020cULL,
0x0000001105047224ULL, 0x080fe400078e0204ULL, 0x0000001106067224ULL, 0x000fe400078e020bULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x0000000108007824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010a087824ULL, 0x000fe200078e0217ULL,
0x0000600006067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0xfffffff00b007812ULL, 0x000fe400078ee200ULL, 0x0000610005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff009087812ULL, 0x000fe200078ee208ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc60001ffe4ffULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000c101c46ULL,
0x00000000060b7faeULL, 0x0003e2000c901c46ULL, 0x0000040000007947ULL, 0x000fea0003800000ULL,
0x00005a0000037b06ULL, 0x000e620000209000ULL, 0x0000000000177919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fcc00078e00ffULL, 0x0000000300037308ULL, 0x002e620000001000ULL,
0x0000000017007211ULL, 0x004fc800078fe0ffULL, 0x00000002000a7810ULL, 0x040fe20007ffe0ffULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x0ffffffe03057810ULL, 0x002fe20007ffe0ffULL,
0x0000000119037824ULL, 0x040fe400078e0200ULL, 0x0000000119067824ULL, 0x000fc600078e020aULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705077227ULL, 0x000fcc00078e0004ULL,
0x0000000307047227ULL, 0x000fc800078e00ffULL, 0x0000000607077227ULL, 0x000fc800078e00ffULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x00005a0008057a24ULL, 0x000fe400078e0203ULL, 0x00005a0009087a24ULL, 0x000fc600078e0206ULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x0000000107072810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff057a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x0000000107073810ULL, 0x000fe40007ffe0ffULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000705077207ULL, 0x000fc60004000000ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x00005a0008037a24ULL, 0x000fe400078e0203ULL, 0x00005a0005067a24ULL, 0x000fe400078e0206ULL,
0x0000000113057824ULL, 0x040fe400078e0203ULL, 0x0000000113067824ULL, 0x000fc400078e0206ULL,
0x0000001017037824ULL, 0x000fe400078e00ffULL, 0x0000001104057224ULL, 0x080fe400078e0205ULL,
0x0000001107067224ULL, 0x000fe200078e0206ULL, 0x000000f003097812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x0000000100087824ULL, 0x100fe200078e0217ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x000fe200078e0217ULL,
0x0000600004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a097824ULL, 0x000fe200078e00ffULL,
0xfffffff00b087812ULL, 0x000fe400078ee208ULL, 0x0000600006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff009007812ULL, 0x000fe200078ee200ULL, 0x0000001008097824ULL, 0x000fe200078e00ffULL,
0x0000610005057a10ULL, 0x000fc400007fe4ffULL, 0x0000610007077a10ULL, 0x000fe20000ffe4ffULL,
0x00000010000b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c46ULL, 0x00000000060b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000007806ULL, 0x000fe200038e0000ULL,
0x00000004ff297424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000047300ULL, 0x000e7000000e0000ULL, 0x0000000000067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x000066000e047625ULL, 0x000fc800078e0029ULL,
0x000000ffff067224ULL, 0x004fd000078e0a06ULL, 0x01260406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01260000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604167981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x000000ff16007810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff157819ULL, 0x000fce0000011600ULL,
0x0000fc6000008947ULL, 0x000fea0003800000ULL, 0x000000081a147824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01268c0514ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x000000020e027824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe2000001161aULL, 0x0126880014ff7f8cULL, 0x0007e2000c80043fULL,
0x000000011a117812ULL, 0x000fe200078ec0ffULL, 0x0000590002027624ULL, 0x000fe400078e0210ULL,
0x00000020136f7824ULL, 0x000fc400078e00ffULL, 0x000000011b127824ULL, 0x000fc800078e0202ULL,
0x0000680012007a24ULL, 0x000fe200078e026fULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x0000006f16027217ULL, 0x008fe20007800000ULL, 0x0000001011057824ULL, 0x004fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc60000011617ULL, 0x0000000102027824ULL, 0x000fe200078e0a6fULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x002fe200078e0204ULL,
0x0000000c04097810ULL, 0x000fe40007ffe0ffULL, 0x0000000502027217ULL, 0x000fe20007800000ULL,
0x0000000106077824ULL, 0x040fe400078e0217ULL, 0x00000008060c7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc400078e0a05ULL, 0x00000001050a7824ULL, 0x040fe200078e0209ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL, 0x0000000804077810ULL, 0x000fe20007ffe0ffULL,
0x00000001000f7824ULL, 0x000fe200078e020aULL, 0x000000020400720cULL, 0x080fe20003f66070ULL,
0x0000000100047824ULL, 0x000fe200078e0206ULL, 0x000000020800720cULL, 0x080fe20003f46070ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x000000020700720cULL, 0x080fe20003f26070ULL,
0x0000000105077824ULL, 0x000fe200078e0207ULL, 0x000000020900720cULL, 0x000fe20003f06070ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000100027824ULL, 0x000fe200078e0208ULL,
0x00000070040b7812ULL, 0x000fe200078ef803ULL, 0x0000000108067824ULL, 0x040fe400078e0217ULL,
0x00000008080d7824ULL, 0x000fe400078e00ffULL, 0x0000000100087824ULL, 0x000fe400078e0207ULL,
0x0000000107097824ULL, 0x100fe200078e0217ULL, 0xfffffff80d007812ULL, 0x000fe200078ee206ULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000e000130d7811ULL, 0x000fe200078e68ffULL,
0x000000010a047824ULL, 0x000fc400078e0217ULL, 0x000000080a077824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f9e0ffULL, 0x00000010001d7824ULL, 0x000fe200078e020dULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee209ULL, 0xfffffff807107812ULL, 0x000fe200078ee204ULL,
0x0000008008067825ULL, 0x000fe200078e00ffULL, 0x00006500050b7a10ULL, 0x000fc600027fe4ffULL,
0x0000008002047825ULL, 0x000fc800078e00ffULL, 0x000000800f087825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x100fe400078ef803ULL, 0x0000007006047812ULL, 0x000fe200078ef803ULL,
0x000000100c0f7824ULL, 0x000fe200078e020dULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x000000100e1f7824ULL, 0x100fe200078e020dULL, 0x0000640002027a10ULL, 0x000fe20007f9e0ffULL,
0x00000010100d7824ULL, 0x000fe200078e020dULL, 0x0000640004047a10ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000d901c46ULL,
0x0000640003067a10ULL, 0x000fc40007fde0ffULL, 0x0000650005037a10ULL, 0x000fe400027fe4ffULL,
0x0000650007057a10ULL, 0x000fe40002ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200037fe4ffULL,
0x00000000021d7faeULL, 0x0003e8000d101c46ULL, 0x00000000041f7faeULL, 0x0003e8000c901c46ULL,
0x00000000060d7faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011027824ULL, 0x008fe200078e00ffULL, 0x0000e000131f7811ULL, 0x000fc800078e68ffULL,
0x0000000217027211ULL, 0x000fc800078fe8ffULL, 0x0000000402067810ULL, 0x042fe20007ffe0ffULL,
0x0000000102057824ULL, 0x044fe200078e0217ULL, 0x0000000c020a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008020c7824ULL, 0x040fe200078e00ffULL, 0x0000000802087810ULL, 0x000fe20007ffe0ffULL,
0x0000000100047824ULL, 0x040fe400078e0202ULL, 0x0000000100027824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000106077824ULL, 0x000fe200078e0217ULL, 0x00000070040b7812ULL, 0x000fe200078ef803ULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x00000001000d7824ULL, 0x000fe400078e020aULL,
0x000000010a047824ULL, 0x040fe400078e0217ULL, 0x000000080a0f7824ULL, 0x000fe200078e00ffULL,
0x000064000b0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x000fe200078e0208ULL,
0xfffffff80e007812ULL, 0x000fe200078ee207ULL, 0x0000000108097824ULL, 0x040fe200078e0217ULL,
0xfffffff80f107812ULL, 0x000fe200078ee204ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0x00006500050b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008002047825ULL, 0x000fc600078e00ffULL,
0xfffffff8080e7812ULL, 0x000fe200078ee209ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007004027812ULL, 0x000fc600078ef803ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0x0000007006047812ULL, 0x000fe400078ef803ULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100c0d7824ULL, 0x000fe200078e021fULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x00000010000f7824ULL, 0x100fe200078e021fULL, 0x0000640004047a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e1d7824ULL, 0x100fe200078e021fULL, 0x0000640003067a10ULL, 0x000fe20007f5e0ffULL,
0x00000010101f7824ULL, 0x000fe200078e021fULL, 0x0000650005037a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e2000b901c46ULL,
0x0000650007057a10ULL, 0x000fc40000ffe4ffULL, 0x0000650009077a10ULL, 0x000fe200017fe4ffULL,
0x00000000020f7faeULL, 0x0003e8000b901c46ULL, 0x00000000041d7faeULL, 0x0003e8000b901c46ULL,
0x00000000061f7faeULL, 0x0003e4000b901c46ULL, 0x00000000130473c2ULL, 0x000ea200000e0000ULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000126a813027811ULL, 0x002fe200078e18ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x000126a804047891ULL, 0x004fe2000f8e203fULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x000000ffff557224ULL, 0x000fca00078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff6c7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000cf4000008947ULL, 0x000fea0003800000ULL, 0x00000010130e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff107819ULL, 0x000fe2000001161aULL, 0x000000ffff007224ULL, 0x004fc400078e0003ULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x000000100e0e7812ULL, 0x000fe200078ee2ffULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff1c7224ULL, 0x00afca00078e00ffULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x000000041a0a7824ULL, 0x000fca00078e00ffULL, 0xfffffff80a0c7812ULL, 0x000fc800078ec0ffULL,
0x000126c80c0d7810ULL, 0x000fe20007ffe0ffULL, 0x0126cc000c0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000001d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126cc000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f007810ULL, 0x040fe20007ffe0ffULL, 0x000001000f0c7824ULL, 0x000fc600078e026fULL,
0x000000150000720cULL, 0x000fe40003f46070ULL, 0x000000400c037810ULL, 0x000fca0007ffe0ffULL,
0x00006800121f7a24ULL, 0x000fcc00078e0203ULL, 0x000004000000a947ULL, 0x000fea0003800000ULL,
0x00000003ff0a7819ULL, 0x000fe20000011617ULL, 0x00000010110b7824ULL, 0x000fe200078e00ffULL,
0x0000000316007217ULL, 0x000fe40007800000ULL, 0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b027824ULL, 0x040fe200078e020aULL, 0x0000000c0a247810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe400078e0a03ULL, 0x00000001021c7824ULL, 0x040fe400078e0217ULL,
0x0000000802237824ULL, 0x000fe200078e00ffULL, 0x000000000b007217ULL, 0x000fe20007800000ULL,
0x0000001017037824ULL, 0x000fc400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e021fULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x0000000100007824ULL, 0x000fe200078e0a0bULL,
0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b207824ULL, 0x000fe200078e021dULL,
0x0000007003217812ULL, 0x000fe200078ec0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x000000000a00720cULL, 0x080fe40003fa6070ULL, 0x000000001c00720cULL, 0x080fe20003f86070ULL,
0x000000010b1e7824ULL, 0x040fe200078e021cULL, 0x00000021021c7212ULL, 0x000fe200078efcffULL,
0x000000010b267824ULL, 0x000fe200078e0224ULL, 0x000000001d00720cULL, 0x080fe20003f66070ULL,
0x000000011e0a7824ULL, 0x000fe200078e021fULL, 0x000000002400720cULL, 0x000fe20003f06070ULL,
0x000000011e007824ULL, 0x000fe200078e0217ULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x00006500031d7a10ULL, 0x000fe200037fe4ffULL,
0x000000081e257824ULL, 0x000fe200078e00ffULL, 0x000000210a1e7212ULL, 0x080fe200078efcffULL,
0x0000000120027824ULL, 0x100fe400078e021fULL, 0x00000001260a7824ULL, 0x000fe200078e021fULL,
0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe400078ee200ULL, 0x000065000b1f7a10ULL, 0x000fe200037fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002102027212ULL, 0x000fc400078efcffULL,
0x0000f00013007811ULL, 0x000fe200078e68ffULL, 0x0000000120247824ULL, 0x100fe200078e0217ULL,
0x0000640002027a10ULL, 0x000fe20007fde0ffULL, 0x0000000820277824ULL, 0x000fe200078e00ffULL,
0x000000210a0a7212ULL, 0x000fe200078efcffULL, 0x0000000126207824ULL, 0x040fe200078e0217ULL,
0x0000650003037a10ULL, 0x000fe200037fe4ffULL, 0x0000000826697824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee224ULL, 0x0000001023217824ULL, 0x100fe200078e0200ULL,
0x000064000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001025237824ULL, 0x000fe200078e0200ULL,
0xfffffff869697812ULL, 0x000fe200078ee220ULL, 0x0000001027257824ULL, 0x100fe200078e0200ULL,
0x000065000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0005e4000e901c46ULL, 0x0000001069277824ULL, 0x000fc400078e0200ULL,
0x000000001e237faeULL, 0x0005e8000e101c46ULL, 0x0000000002257faeULL, 0x0005e8000d901c46ULL,
0x000000000a277faeULL, 0x0005e2000c101c46ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001011007824ULL, 0x000fe400078e00ffULL, 0x0000001017027824ULL, 0x000fc600078e00ffULL,
0x0000000017007211ULL, 0x000fe400078fe8ffULL, 0x0000007002257812ULL, 0x000fe400078ec0ffULL,
0x0000000c00247810ULL, 0x040fe20007ffe0ffULL, 0x0000000100037824ULL, 0x040fe200078e0217ULL,
0x0000000800207810ULL, 0x040fe20007ffe0ffULL, 0x00000008000a7824ULL, 0x040fe400078e00ffULL,
0x0000000100027824ULL, 0x000fe400078e021fULL, 0x0000000824697824ULL, 0x000fe200078e00ffULL,
0xfffffff80a217812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fe200078e00ffULL,
0x00000004000a7810ULL, 0x000fc60007ffe0ffULL, 0x00000001201d7824ULL, 0x000fe200078e0217ULL,
0x00000025021e7212ULL, 0x000fe200078efcffULL, 0x000000010a007824ULL, 0x040fe400078e021fULL,
0x000000010a0b7824ULL, 0x100fe200078e0217ULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000080a267824ULL, 0x000fe400078e00ffULL, 0x0000000124027824ULL, 0x000fe400078e0217ULL,
0x00000001200a7824ULL, 0x000fe200078e021fULL, 0xfffffff826237812ULL, 0x000fe200078ee20bULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe200078ee202ULL,
0x00000001241c7824ULL, 0x000fe200078e021fULL, 0x00006500031f7a10ULL, 0x000fe200007fe4ffULL,
0x0000008000027825ULL, 0x000fe200078e00ffULL, 0xfffffff820277812ULL, 0x000fc400078ee21dULL,
0x0000f00013207811ULL, 0x000fe200078e68ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002502027212ULL, 0x000fc600078efcffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000250a0a7212ULL, 0x080fe400078efcffULL, 0x0000640002027a10ULL, 0x000fe20007f1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0220ULL, 0x000000251c1c7212ULL, 0x000fe200078efcffULL,
0x0000001023237824ULL, 0x100fe200078e0220ULL, 0x000064000a0a7a10ULL, 0x000fe20007f7e0ffULL,
0x0000001027257824ULL, 0x100fe200078e0220ULL, 0x000064001c1c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001069277824ULL, 0x000fe200078e0220ULL, 0x0000650003037a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e217faeULL, 0x0005e2000b901c46ULL,
0x000065000b0b7a10ULL, 0x000fc40001ffe4ffULL, 0x000065001d1d7a10ULL, 0x000fe200027fe4ffULL,
0x0000000002237faeULL, 0x0005e8000b901c46ULL, 0x000000000a257faeULL, 0x0005e8000b901c46ULL,
0x000000001c277faeULL, 0x0005e4000b901c46ULL, 0xfffffff0141f7812ULL, 0x044fe400078ec0ffULL,
0xffffffe014007812ULL, 0x000fc400078ec0ffULL, 0x000000001f0573c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000001014037812ULL, 0x000fca00078ec0ffULL,
0x0000000100007824ULL, 0x000fc800078e0203ULL, 0x00000008111c7824ULL, 0x000fe200078e0200ULL,
0x000126b005057890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0001f207f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012608001c1c7f8cULL, 0x000ea4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x00000008140b7812ULL, 0x000fca00078ec0ffULL, 0x0000000100237824ULL, 0x000fca00078e020bULL,
0x01260c00230b7984ULL, 0x000f240000000800ULL, 0x800000000bff7812ULL, 0x014fe4000780481dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a02257210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140bULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01260c00230b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe4000780481dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010170b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011617ULL,
0x000000201a007824ULL, 0x000fe400078e00ffULL, 0xffffffffff747424ULL, 0x000fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fc400078ec0ffULL, 0xffffff8000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a007210ULL, 0x000fca0007ffe00bULL,
0x0120000000037984ULL, 0x000ea80000000800ULL, 0x0122000000027984ULL, 0x0006620000000800ULL,
0x000000080300720bULL, 0x004fe20003f1d000ULL, 0x000169227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800000e0100ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x0000001fff767424ULL, 0x000fe400078e00ffULL,
0xffffffffff757424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001a1000720cULL, 0x000fe40003f05270ULL, 0x000000080300720bULL, 0x000fe20003f74000ULL,
0x000168c27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x00000008031e7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x0124001e25008388ULL, 0x0005e20000000800ULL, 0x000000ff1d00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000081e087221ULL, 0x004fe20000010100ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800277308ULL, 0x000ea40000000800ULL,
0x0000002722227220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x000168027f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x000166c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000165827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x000164527f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000001d00ff7212ULL, 0x000fda00078030ffULL, 0x8000001e03030221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL,
0x0000000300090308ULL, 0x000ea40000000800ULL, 0x0000000902020220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002202227221ULL, 0x002fc40000010000ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0126ac001f007984ULL, 0x000e620000000800ULL,
0x000126a81f087810ULL, 0x000fe40007ffe0ffULL, 0x8000000000ff7812ULL, 0x002fe2000780486dULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c02257210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001141dULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff1d7224ULL, 0x000fca00000e061dULL, 0x0000000200007819ULL, 0x000fc8000000121dULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac001f007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991024007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff027819ULL, 0x000fe40000011617ULL,
0x0000541000277816ULL, 0x000fe20000000000ULL, 0x000160027f007947ULL, 0x000fea000b800000ULL,
0x00001f0227077589ULL, 0x0002a400000e0000ULL, 0x0000000802267810ULL, 0x000fe20007ffe0ffULL,
0x000160227f007947ULL, 0x000fea000b800000ULL, 0x0000001002007810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0027057589ULL, 0x0006a400000e0000ULL,
0x0000001802267810ULL, 0x008fe20007ffe0ffULL, 0x000160527f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004136c7824ULL, 0x000fe200078e00ffULL, 0x0000000817007812ULL, 0x000fe200078ec0ffULL,
0x000004001a1d7824ULL, 0x000fe200078e00ffULL, 0x00000004ff7c7819ULL, 0x100fe20000011617ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000046c6c7812ULL, 0x000fe200078ec0ffULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000000700037812ULL, 0x000fc400078ef817ULL,
0x0000006c17007211ULL, 0x000fe400078fe0ffULL, 0x0000001003027812ULL, 0x042fe200078efcffULL,
0x00000008031f7824ULL, 0x000fe200078e00ffULL, 0xfffff0001d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000001031c7824ULL, 0x000fe400078e0200ULL, 0x0000000100007824ULL, 0x000fe200078e0202ULL,
0x0000a0001d6d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000802257824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL, 0x00000004111f7824ULL, 0x000fc400078e027cULL,
0x0000000803247824ULL, 0x000fe200078e00ffULL, 0xfffffff8251d7812ULL, 0x000fe200078ee200ULL,
0x0000000103777824ULL, 0x000fe200078e021fULL, 0x0000e00013007811ULL, 0x000fe200078e68ffULL,
0x000000101c687824ULL, 0x000fc600078e026dULL, 0xfffffff824257812ULL, 0x000fe200078ee277ULL,
0x000000101d247824ULL, 0x000fe400078e026dULL, 0x000000006868783bULL, 0x000e640000000200ULL,
0x0000001025707824ULL, 0x000fe400078e0200ULL, 0x000000002424783bULL, 0x008ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000768687231ULL, 0x086fe400003400ffULL,
0x000000076a6a7231ULL, 0x000fc400003400ffULL, 0x0000000669697231ULL, 0x080fe400003400ffULL,
0x000000066b6b7231ULL, 0x000fe400003400ffULL, 0x0000000524247231ULL, 0x088fe400003400ffULL,
0x0000000526267231ULL, 0x000fe400003400ffULL, 0x0000000425257231ULL, 0x080fe400003400ffULL,
0x0000000427277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000803787824ULL, 0x000fe200078e00ffULL, 0x0000000277777810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000f220000004200ULL, 0x00000001021f7824ULL, 0x000fe200078e021fULL,
0x00000cd000007945ULL, 0x000fe20003800000ULL, 0xfffffff878777812ULL, 0x000fca00078ee277ULL,
0x0000001077777824ULL, 0x000fca00078e0200ULL, 0x000000007778783bULL, 0x000ee20000004200ULL,
0x00000010ff7d7819ULL, 0x110fe40000011670ULL, 0x000000ff707f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011670ULL, 0x0000ffff70907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff807819ULL, 0x000fe40000011671ULL, 0x000000ff71817812ULL, 0x000fc400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe40000011671ULL, 0x0000ffff71957812ULL, 0x000fe400078ec0ffULL,
0x000000ff73857812ULL, 0x000fe400078ec0ffULL, 0x00000018ff717819ULL, 0x100fe40000011672ULL,
0x00000010ff827819ULL, 0x000fe40000011672ULL, 0x000000ff72837812ULL, 0x000fc400078ec0ffULL,
0x0000ffff72967812ULL, 0x000fe400078ec0ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000018ff727819ULL, 0x000fe40000011673ULL, 0x00000070ff70723eULL, 0x000fe200020006ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000010ff887819ULL, 0x008fc40000011678ULL, 0x000000ff788a7812ULL, 0x040fe200078ec0ffULL,
0x20000071ff857230ULL, 0x000fe20000004100ULL, 0x00000018ff877819ULL, 0x000fe40000011678ULL,
0x0000ffff78987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe40000011679ULL,
0x000000ff798c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fc40000011679ULL,
0x0000ffff79997812ULL, 0x000fe400078ec0ffULL, 0x000000ff7d7d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff927819ULL, 0x100fe4000001167aULL, 0x000000ff7a8d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fe4000001167aULL, 0x0000ffff7a9a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff937819ULL, 0x100fe4000001167bULL, 0x000000ff7b8f7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001167bULL, 0x0000ffff7b777812ULL, 0x000fe200078ec0ffULL,
0x20000070ff7b7230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x0000007dff70723eULL, 0x000fc400020006ffULL, 0x000000ff80717812ULL, 0x000fe200078ec0ffULL,
0x20000072ff897230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe400020006ffULL,
0x00000071ff72723eULL, 0x000fe200020006ffULL, 0x20000070ff717230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fe20000011690ULL, 0x20000078ff917230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000070ff70723eULL, 0x000fc400020006ffULL,
0x0000ffff73977812ULL, 0x000fe200078ec0ffULL, 0x20000079ff807230ULL, 0x000fe20000004100ULL,
0x00000008ff787819ULL, 0x000fe20000011695ULL, 0x20000072ff797230ULL, 0x000fe20000004100ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x20000070ff727230ULL, 0x000fe20000004100ULL,
0x00000008ff707819ULL, 0x000fe40000011697ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000008cff8e7230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fc400020006ffULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x2000007aff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff88887812ULL, 0x000fe200078ec0ffULL, 0x20000078ff7a7230ULL, 0x000fe20000004100ULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000008fff947230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x000000ff8b8c7812ULL, 0x000fe400078ec0ffULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x00000008ff8b7819ULL, 0x000fe40000011698ULL,
0x0000007eff7e723eULL, 0x000fe200020006ffULL, 0x2000007fff7f7230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000088ff78723eULL, 0x000fe200020006ffULL,
0x20000070ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff847819ULL, 0x000fe20000011673ULL,
0x20000081ff737230ULL, 0x000fe20000004100ULL, 0x000000ff82827812ULL, 0x000fe200078ec0ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000008ff8f7819ULL, 0x000fc40000011699ULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x0000008bff70723eULL, 0x000fe200020006ffULL,
0x20000078ff8b7230ULL, 0x000fe20000004100ULL, 0x0000008dff81723eULL, 0x000fe200020006ffULL,
0x20000087ff8d7230ULL, 0x000fe20000004100ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x000000ff84877812ULL, 0x000fe200078ec0ffULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x0000008fff90723eULL, 0x000fe200020006ffULL, 0x2000008cff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fe20000011673ULL, 0x20000070ff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff707819ULL, 0x000fe2000001167fULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fe20000011671ULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fc400020006ffULL, 0x00000010ff737819ULL, 0x000fe4000001167eULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000008ff847819ULL, 0x000fe40000011696ULL,
0x0000105471707816ULL, 0x000fe40000000070ULL, 0x0000105479717816ULL, 0x000fc40000000078ULL,
0x0000105473727816ULL, 0x000fe40000000072ULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000010ff787819ULL, 0x000fe2000001167bULL, 0x000000706864723cULL, 0x002f620000041864ULL,
0x00000010ff737819ULL, 0x000fe2000001167aULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x000fc40000011683ULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x000000702444723cULL, 0x000f620000041844ULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7f7819ULL, 0x000fe4000001169aULL,
0x00000008ff777819ULL, 0x000fe40000011677ULL, 0x0000105478737816ULL, 0x000fe40000000073ULL,
0x00000092ff92723eULL, 0x000fc400020006ffULL, 0x00000010ff797819ULL, 0x000fe40000011686ULL,
0x00000010ff7a7819ULL, 0x000fe20000011687ULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x0000105482787816ULL, 0x000fe20000000083ULL, 0x000000726860723cULL, 0x080f620000041860ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000093ff93723eULL, 0x000fe400020006ffULL,
0x0000007fff83723eULL, 0x000fe200020006ffULL, 0x2000008aff8a7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x000000722440723cULL, 0x000f620000041840ULL,
0x000010547a797816ULL, 0x000fe20000000079ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe20000011684ULL, 0x20000093ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe20000011689ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff7b7819ULL, 0x000fe20000011688ULL, 0x00000078685c723cULL, 0x000f62000004185cULL,
0x00000010ff7f7819ULL, 0x000fc4000001168eULL, 0x00000010ff827819ULL, 0x000fe4000001168fULL,
0x000010547e7b7816ULL, 0x000fe4000000007bULL, 0x00001054827f7816ULL, 0x000fe2000000007fULL,
0x00000078243c723cULL, 0x000f62000004183cULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff8c7819ULL, 0x000fe4000001168cULL, 0x00000010ff817819ULL, 0x000fc40000011681ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff857819ULL, 0x000fe40000011685ULL,
0x00000010ff7e7819ULL, 0x000fe4000001168aULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x00000010ff917819ULL, 0x000fe40000011691ULL, 0x00000010ff907819ULL, 0x000fc40000011690ULL,
0x00000010ff937819ULL, 0x000fe40000011694ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff827819ULL, 0x000fe4000001167dULL, 0x00000010ff777819ULL, 0x000fc40000011677ULL,
0x000010548d8c7816ULL, 0x000fe4000000008cULL, 0x0000105492927816ULL, 0x000fe40000000081ULL,
0x00001054857a7816ULL, 0x000fe4000000007aULL, 0x000010548b7e7816ULL, 0x000fe4000000007eULL,
0x00001054918d7816ULL, 0x000fe40000000090ULL, 0x0000105484937816ULL, 0x000fe20000000093ULL,
0x0000007a6858723cULL, 0x000f620000041858ULL, 0x0000105480807816ULL, 0x000fc40000000083ULL,
0x0000105482817816ULL, 0x000fca0000000077ULL, 0x0000007e6854723cULL, 0x040f700000041854ULL,
0x0000008c6850723cULL, 0x040f700000041850ULL, 0x00000092684c723cULL, 0x040f70000004184cULL,
0x000000806848723cULL, 0x000b6e0000041848ULL, 0x000000026c697812ULL, 0x020fe200078efcffULL,
0x00000008036b7824ULL, 0x000fe200078e00ffULL, 0x0000007a2438723cULL, 0x000f620000041838ULL,
0x00000008026a7824ULL, 0x000fc400078e00ffULL, 0x000000017c697824ULL, 0x000fe400078e0269ULL,
0x00000008026c7824ULL, 0x040fe400078e00ffULL, 0x0000000103687824ULL, 0x100fe200078e0269ULL,
0x0000007e2434723cULL, 0x000f620000041834ULL, 0x0000000102697824ULL, 0x000fc600078e0269ULL,
0xfffffff86b687812ULL, 0x000fe400078ee268ULL, 0xfffffff86a6a7812ULL, 0x000fe400078ee269ULL,
0xfffffff86c697812ULL, 0x000fe200078ee21fULL, 0x0000001068687824ULL, 0x100fe200078e026dULL,
0x0000008c2430723cULL, 0x040f620000041830ULL, 0x000000106a6d7824ULL, 0x000fe400078e026dULL,
0x0000001069707824ULL, 0x000fe400078e0200ULL, 0x000000006868783bULL, 0x000e660000000200ULL,
0x00000092242c723cULL, 0x040f70000004182cULL, 0x000000802428723cULL, 0x000b640000041828ULL,
0x000000006d24783bULL, 0x0206a20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000768687231ULL, 0x086fe400003400ffULL,
0x000000076a6a7231ULL, 0x000fc400003400ffULL, 0x0000000669697231ULL, 0x080fe400003400ffULL,
0x000000066b6b7231ULL, 0x000fe400003400ffULL, 0x0000000524247231ULL, 0x080fe400003400ffULL,
0x0000000526267231ULL, 0x000fe400003400ffULL, 0x0000000425257231ULL, 0x080fe400003400ffULL,
0x0000000427277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008026c7824ULL, 0x000fe200078e00ffULL, 0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000f260000004200ULL, 0xfffffff86c1f7812ULL, 0x000fca00078ee21fULL,
0x000000101f1f7824ULL, 0x000fca00078e0200ULL, 0x000000001f78783bULL, 0x0006a20000004200ULL,
0x00000010ff6c7819ULL, 0x110fe40000011670ULL, 0x000000ff70777812ULL, 0x040fe400078ec0ffULL,
0x00000018ff6d7819ULL, 0x008fe40000011670ULL, 0x0000ffff70917812ULL, 0x000fe400078ec0ffULL,
0x00000018ff707819ULL, 0x000fe40000011671ULL, 0x000000ff6c6c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff7c7819ULL, 0x000fe40000011671ULL, 0x000000ff717d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff71927812ULL, 0x000fe400078ec0ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000018ff717819ULL, 0x000fe40000011672ULL, 0x0000006dff1f723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff817819ULL, 0x100fe40000011673ULL,
0x000000ff73827812ULL, 0x040fe400078ec0ffULL, 0x00000018ff807819ULL, 0x000fe40000011673ULL,
0x0000ffff73947812ULL, 0x000fe400078ec0ffULL, 0x00000010ff837819ULL, 0x004fc40000011678ULL,
0x000000ff78857812ULL, 0x040fe400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe40000011678ULL,
0x0000ffff78957812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x100fe40000011679ULL,
0x000000ff79877812ULL, 0x000fe400078ec0ffULL, 0x00000018ff787819ULL, 0x000fc40000011679ULL,
0x0000ffff79967812ULL, 0x000fe200078ec0ffULL, 0x20000070ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe20000011672ULL, 0x2000006cff707230ULL, 0x000fe20000004100ULL,
0x000000ff727f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff72937812ULL, 0x000fe200078ec0ffULL,
0x2000001fff727230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000080ff1f723eULL, 0x000fc400020006ffULL, 0x00000008ff6c7819ULL, 0x000fe20000011691ULL,
0x20000071ff807230ULL, 0x000fe20000004100ULL, 0x000000ff7a887812ULL, 0x000fe200078ec0ffULL,
0x2000001fff847230ULL, 0x000fe20000004100ULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000008ff717819ULL, 0x000fe40000011692ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000088ff1f723eULL, 0x000fe200020006ffULL, 0x20000073ff887230ULL, 0x000fe20000004100ULL,
0x00000071ff73723eULL, 0x000fe200020006ffULL, 0x2000006cff717230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x2000001fff8e7230ULL, 0x000fe20000004100ULL,
0x00000008ff6c7819ULL, 0x000fc40000011694ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000087ff897230ULL, 0x000fe20000004100ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x000000ff7b8b7812ULL, 0x000fe200078ec0ffULL, 0x20000078ff8c7230ULL, 0x000fe20000004100ULL,
0x00000018ff8a7819ULL, 0x000fe2000001167aULL, 0x20000077ff6d7230ULL, 0x000fe20000004100ULL,
0x000000ff83837812ULL, 0x000fe200078ec0ffULL, 0x20000073ff787230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fc400020006ffULL, 0x000000ff86877812ULL, 0x000fe400078ec0ffULL,
0x000000ff7c7c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff867819ULL, 0x000fe40000011695ULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x00000010ff8d7819ULL, 0x000fe4000001167aULL,
0x0000ffff7a977812ULL, 0x000fe200078ec0ffULL, 0x2000008bff907230ULL, 0x000fe20000004100ULL,
0x0000008aff77723eULL, 0x000fc400020006ffULL, 0x00000083ff73723eULL, 0x000fe200020006ffULL,
0x2000006cff837230ULL, 0x000fe20000004100ULL, 0x00000018ff7a7819ULL, 0x000fe2000001167bULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x000000ff81817812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe40000011696ULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fc400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000000ff7e7e7812ULL, 0x000fe200078ec0ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000086ff6c723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000073ff867230ULL, 0x000fe20000004100ULL,
0x0000007aff1f723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000008aff8b723eULL, 0x000fe200020006ffULL,
0x20000087ff8a7230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000006cff877230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000008ff7a7819ULL, 0x000fe20000011693ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe2000001167bULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x00000010ff6c7819ULL, 0x000fe2000001166dULL,
0x2000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000010ff6d7819ULL, 0x000fe20000011670ULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x00000010ff737819ULL, 0x000fe40000011672ULL, 0x00000010ff707819ULL, 0x000fe20000011671ULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff7b7b7812ULL, 0x000fc400078ec0ffULL, 0x0000105473707816ULL, 0x000fe40000000070ULL,
0x00000010ff717819ULL, 0x000fe40000011678ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x000010546d6c7816ULL, 0x000fe4000000006cULL, 0x00000010ff727819ULL, 0x000fe20000011679ULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x00000010ff737819ULL, 0x000fc40000011682ULL,
0x00000010ff787819ULL, 0x000fe40000011681ULL, 0x000010547c6d7816ULL, 0x000fe4000000007dULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x0000006c2444723cULL, 0x000f620000041844ULL,
0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe40000011697ULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x0000105472717816ULL, 0x000fe20000000071ULL,
0x0000006c6864723cULL, 0x002f620000041864ULL, 0x0000105478737816ULL, 0x000fe40000000073ULL,
0x000010547e727816ULL, 0x000fe2000000007fULL, 0x2000008fff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff787819ULL, 0x000fc4000001167aULL, 0x0000008dff8d723eULL, 0x000fe200020006ffULL,
0x000000702440723cULL, 0x040f620000041840ULL, 0x0000007cff7a723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe200020006ffULL, 0x2000008dff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe20000011685ULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x000fe20000011686ULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x00000072243c723cULL, 0x000f62000004183cULL,
0x00000010ff8a7819ULL, 0x000fc4000001168aULL, 0x00000010ff8f7819ULL, 0x000fe40000011690ULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x000010547d7c7816ULL, 0x000fe2000000007cULL,
0x000000706860723cULL, 0x000f620000041860ULL, 0x00000010ff797819ULL, 0x000fe40000011680ULL,
0x000010548a7d7816ULL, 0x000fe40000000089ULL, 0x000010547e8f7816ULL, 0x000fc4000000008fULL,
0x00000010ff847819ULL, 0x000fe20000011684ULL, 0x00000072685c723cULL, 0x000f62000004185cULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff8c7819ULL, 0x000fe2000001168cULL,
0x0000007c2434723cULL, 0x000f620000041834ULL, 0x00000010ff897819ULL, 0x000fc4000001168bULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x0000007c6854723cULL, 0x000f620000041854ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff7e7819ULL, 0x000fe2000001161fULL,
0x000000021a1f7824ULL, 0x000fe200078e00ffULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x0000105479787816ULL, 0x000fe40000000078ULL, 0x0000105484797816ULL, 0x000fe40000000083ULL,
0x0000105488887816ULL, 0x000fe40000000087ULL, 0x000010548c897816ULL, 0x000fe40000000089ULL,
0x000010548d8e7816ULL, 0x000fe2000000008eULL, 0x000000782438723cULL, 0x000f620000041838ULL,
0x00001054777a7816ULL, 0x000fc4000000007aULL, 0x000010547e7b7816ULL, 0x000fe4000000007bULL,
0xfffffff81f1f7812ULL, 0x000fc600078ec0ffULL, 0x000000882430723cULL, 0x040f700000041830ULL,
0x0000008e242c723cULL, 0x040f70000004182cULL, 0x0000007a2428723cULL, 0x000f700000041828ULL,
0x000000786858723cULL, 0x040f700000041858ULL, 0x000000886850723cULL, 0x040f700000041850ULL,
0x0000008e684c723cULL, 0x040f70000004184cULL, 0x0000007a6848723cULL, 0x000b6e0000041848ULL,
0x000126c813687811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012688001fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6a7224ULL, 0x000fc600078e00ffULL,
0x0000000000247805ULL, 0x000fc80000015200ULL, 0x000004000d1f7984ULL, 0x004ea40000000800ULL,
0x800000001fff7812ULL, 0x006fc40007804869ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800c257810ULL, 0x000fca0007ffe0ffULL, 0x00006800126c7a24ULL, 0x000fe200078e0225ULL,
0x000003d00000a947ULL, 0x000fea0003800000ULL, 0x00000025161f7217ULL, 0x000fe20007800000ULL,
0x0000001011707824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fc60000011617ULL,
0x000000011f1f7824ULL, 0x000fe200078e0a25ULL, 0x0000000427697810ULL, 0x040fe20007ffe0ffULL,
0x0000000170247824ULL, 0x040fe200078e0227ULL, 0x00000008276b7810ULL, 0x040fe40007ffe0ffULL,
0x0000001f701f7217ULL, 0x000fe20007800000ULL, 0x0000000124257824ULL, 0x040fe200078e0217ULL,
0x0000000c27737810ULL, 0x000fe20007ffe0ffULL, 0x0000000824267824ULL, 0x000fe400078e00ffULL,
0x0000000170717824ULL, 0x000fc400078e0269ULL, 0x0000000124247824ULL, 0x000fe200078e026cULL,
0xfffffff8266d7812ULL, 0x000fe200078ee225ULL, 0x000000011f1f7824ULL, 0x000fe400078e0a70ULL,
0x0000000171267824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000001f2700720cULL, 0x080fe40003f06070ULL, 0x0000001f6900720cULL, 0x000fe20003f86070ULL,
0x0000000170727824ULL, 0x000fe200078e026bULL, 0x0000000b246a7212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000001f6b00720cULL, 0x000fc40003f66070ULL,
0x000064006a6a7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000170707824ULL, 0x000fe200078e0273ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000000172687824ULL, 0x100fe200078e026cULL,
0x00006500256b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000000170247824ULL, 0x000fe200078e026cULL,
0x0000640026267a10ULL, 0x000fe20007fde0ffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x0000001f7300720cULL, 0x000fe40003fa6070ULL, 0x0000650027277a10ULL, 0x000fe200037fe4ffULL,
0x00000001716c7824ULL, 0x040fe200078e0217ULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x0000000871717824ULL, 0x000fc400078e00ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000640068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff8711f7812ULL, 0x000fe200078ee26cULL,
0x00000001726c7824ULL, 0x100fe200078e0217ULL, 0x0000000b24247212ULL, 0x000fe200078efcffULL,
0x0000000872717824ULL, 0x000fe200078e00ffULL, 0x0000650069697a10ULL, 0x000fe200037fe4ffULL,
0x0000000170727824ULL, 0x000fe200078e0217ULL, 0x0000640024247a10ULL, 0x000fe20007fde0ffULL,
0x0000000870737824ULL, 0x000fe200078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee26cULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x0000650025257a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0xfffffff873737812ULL, 0x000fe200078ee272ULL,
0x0000001071717824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a6d7faeULL, 0x0003e6000c101c46ULL, 0x0000001073737824ULL, 0x000fe200078e0200ULL,
0x00000000261f7faeULL, 0x0003e8000e101c46ULL, 0x0000000068717faeULL, 0x0003e8000d901c46ULL,
0x0000000024737faeULL, 0x0003e2000e901c46ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001011247824ULL, 0x000fca00078e00ffULL, 0x00000024171f7211ULL, 0x000fc800078fe8ffULL,
0x000000041f267810ULL, 0x040fe20007ffe0ffULL, 0x000000011f247824ULL, 0x140fe200078e0217ULL,
0x000000081f687810ULL, 0x040fe20007ffe0ffULL, 0x000000081f6d7824ULL, 0x000fe400078e00ffULL,
0x0000000126257824ULL, 0x140fe400078e0217ULL, 0x00000008266a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee224ULL, 0x000000011f247824ULL, 0x040fe200078e026cULL,
0x0000000c1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000168277824ULL, 0x000fe200078e0217ULL,
0xfffffff86a717812ULL, 0x000fe200078ee225ULL, 0x0000000868707824ULL, 0x000fc400078e00ffULL,
0x0000000126267824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0xfffffff870737812ULL, 0x000fc600078ee227ULL, 0x0000000168687824ULL, 0x100fe200078e026cULL,
0x0000000b24247212ULL, 0x000fe200078efcffULL, 0x000000011f6a7824ULL, 0x000fe400078e026cULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640024247a10ULL, 0x000fc60007f1e0ffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000650025257a10ULL, 0x000fe200007fe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x080fe400078efcffULL, 0x0000640026267a10ULL, 0x000fe20007f7e0ffULL,
0x000000011f6c7824ULL, 0x040fe200078e0217ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x0000640068687a10ULL, 0x000fe20007f1e0ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x0000650027277a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000246d7faeULL, 0x0003e2000b901c46ULL,
0x0000650069697a10ULL, 0x000fe200007fe4ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026717faeULL, 0x0003e8000b901c46ULL,
0x0000000068737faeULL, 0x0003e8000b901c46ULL, 0x000000006a1f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000080503c2ULL, 0x000e640000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x002fe20008000a05ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000086c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126280023687f8cULL, 0x000664000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL, 0x0000001014267812ULL, 0x000fca00078ec0ffULL,
0x000000011f267824ULL, 0x000fc800078e0226ULL, 0x00000008116a7824ULL, 0x000fca00078e0226ULL,
0x01262c006a1f7984ULL, 0x000f240000000800ULL, 0x800000001fff7812ULL, 0x012fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016b6b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01262c006a1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a1f7824ULL, 0x000fca00078e00ffULL, 0xffffff801f247812ULL, 0x000fc800078ec0ffULL,
0x000000800b1f7810ULL, 0x000fca0007ffe024ULL, 0x000000010a1f7824ULL, 0x000fca00078e021fULL,
0x012000001f697984ULL, 0x000e680000000800ULL, 0x012200001f687984ULL, 0x0006a20000000800ULL,
0x0000001e6900720bULL, 0x002fe20003f1d000ULL, 0x000137327f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x008fc800000e0100ULL, 0x000000ff1f00720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e001eULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000000110257810ULL, 0x000fe40007ffe0ffULL, 0x0000001e6900720bULL, 0x000fe40003f74000ULL,
0x0000001a2500720cULL, 0x000fe20003f05270ULL, 0x000136e27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000707806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x0000001e69247209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x0124002425008388ULL, 0x0003e20000000800ULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000001e241e7221ULL, 0x002fe20000010100ULL, 0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00277308ULL, 0x000e640000000800ULL, 0x0000002722227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000136227f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000134e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x0000002666667220ULL, 0x086fe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000133a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000070ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000132727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000701fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fd800078e00ffULL, 0x8000002469690221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL,
0x0000006900090308ULL, 0x000e640000000800ULL, 0x0000000968680220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002268227221ULL, 0x004fc20000010000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL,
0x0126b4006a277984ULL, 0x008e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x000000261e697210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e1fULL, 0x003d09006900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000168687810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b4006a277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910251e7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff1e7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x00012e327f007947ULL, 0x000fea000b800000ULL,
0x00001f1e27077589ULL, 0x0002a400000e0000ULL, 0x000000081e267810ULL, 0x000fe20007ffe0ffULL,
0x00012e527f007947ULL, 0x000fea000b800000ULL, 0x000000101e047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000181e267810ULL, 0x008fe20007ffe0ffULL, 0x00012e827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000041a1e7824ULL, 0x042fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a207824ULL, 0x040fe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000010001a1f7824ULL, 0x000fe200078e00ffULL, 0x000000041e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000803267824ULL, 0x008fe200078e00ffULL, 0xfffff00020207812ULL, 0x000fc400078ec0ffULL,
0x0000001e171e7211ULL, 0x000fe400078fe0ffULL, 0x0000b00020207810ULL, 0x000fe40007ffe0ffULL,
0xffffe0001f217812ULL, 0x000fe200078ec0ffULL, 0x00000001031f7824ULL, 0x000fe400078e021eULL,
0x000000101c707824ULL, 0x100fe200078e0220ULL, 0x0000f00021257810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0220ULL, 0xfffffff8261c7812ULL, 0x000fc600078ee21fULL,
0x000000007070783bULL, 0x000e640000000200ULL, 0x000000101c787824ULL, 0x000fe400078e0225ULL,
0x000000001d68783bULL, 0x0006a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707231ULL, 0x086fe400003400ffULL, 0x0000000772727231ULL, 0x000fe400003400ffULL,
0x0000000671717231ULL, 0x080fe400003400ffULL, 0x0000000673737231ULL, 0x000fc400003400ffULL,
0x0000000568687231ULL, 0x080fe400003400ffULL, 0x000000056a6a7231ULL, 0x000fe400003400ffULL,
0x0000000469697231ULL, 0x080fe400003400ffULL, 0x000000046b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803267824ULL, 0x000fe200078e00ffULL,
0x000000021f217810ULL, 0x000fe20007ffe0ffULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000d1000007945ULL, 0x000fe40003800000ULL, 0xfffffff826217812ULL, 0x000fca00078ee221ULL,
0x00000010217c7824ULL, 0x000fcc00078e0225ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000010ff807819ULL, 0x110fe4000001167aULL, 0x000000ff7a827812ULL, 0x040fe400078ec0ffULL,
0x00000018ff817819ULL, 0x000fe4000001167aULL, 0x0000ffff7a937812ULL, 0x000fe400078ec0ffULL,
0x000000ff79267812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7a7819ULL, 0x000fc4000001167bULL,
0x00000018ff1f7819ULL, 0x000fe40000011678ULL, 0x00000018ff277819ULL, 0x100fe40000011679ULL,
0x00000010ff777819ULL, 0x000fe40000011679ULL, 0x00000010ff837819ULL, 0x000fe4000001167bULL,
0x000000ff7b847812ULL, 0x040fe400078ec0ffULL, 0x0000ffff7b947812ULL, 0x000fc400078ec0ffULL,
0x00000010ff1d7819ULL, 0x008fe40000011678ULL, 0x000000ff78257812ULL, 0x040fe400078ec0ffULL,
0x0000ffff78917812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7b7819ULL, 0x000fe4000001167cULL,
0x00000026ff78723eULL, 0x000fe400020006ffULL, 0x0000007aff7a723eULL, 0x000fc400020006ffULL,
0x0000001fff1f723eULL, 0x000fe400020006ffULL, 0x00000027ff27723eULL, 0x000fe200020006ffULL,
0x2000007aff857230ULL, 0x000fe20000004100ULL, 0x000000ff77777812ULL, 0x000fe400078ec0ffULL,
0x00000018ff897819ULL, 0x000fe4000001167dULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x000000ff1d1d7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff79927812ULL, 0x000fe200078ec0ffULL,
0x20000078ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fe2000001167cULL,
0x2000001fff787230ULL, 0x000fe20000004100ULL, 0x000000ff7c877812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7c957812ULL, 0x000fe200078ec0ffULL, 0x20000027ff7c7230ULL, 0x000fe20000004100ULL,
0x00000010ff887819ULL, 0x000fe4000001167dULL, 0x000000ff7d8a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff7d967812ULL, 0x000fe400078ec0ffULL, 0x00000077ff7a723eULL, 0x000fe400020006ffULL,
0x00000025ff25723eULL, 0x000fe400020006ffULL, 0x00000010ff8e7819ULL, 0x100fe2000001167eULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x000000ff7e8b7812ULL, 0x000fe200078ec0ffULL,
0x20000025ff267230ULL, 0x000fe20000004100ULL, 0x00000018ff7d7819ULL, 0x000fc4000001167eULL,
0x0000ffff7e977812ULL, 0x000fe400078ec0ffULL, 0x00000089ff1f723eULL, 0x000fe200020006ffULL,
0x2000007bff897230ULL, 0x000fe20000004100ULL, 0x0000001dff27723eULL, 0x000fe400020006ffULL,
0x00000008ff777819ULL, 0x000fe20000011691ULL, 0x2000001fff8d7230ULL, 0x000fe20000004100ULL,
0x00000018ff7e7819ULL, 0x000fe2000001167fULL, 0x20000027ff277230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fc40000011692ULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x000000ff80807812ULL, 0x000fe200078ec0ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x0000007dff1f723eULL, 0x000fe200020006ffULL,
0x2000007eff1d7230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000008ff7d7819ULL, 0x000fe20000011693ULL, 0x2000001fff1f7230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x2000007bff7b7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fc400020006ffULL, 0x00000010ff267819ULL, 0x000fe20000011626ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff277819ULL, 0x000fe20000011627ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000008bff25723eULL, 0x000fe400020006ffULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000025ff257230ULL, 0x000fe20000004100ULL, 0x00000008ff7e7819ULL, 0x000fc40000011694ULL,
0x00000010ff797819ULL, 0x000fe20000011679ULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x000000ff888b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8f7819ULL, 0x000fe4000001167fULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff7f8c7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x0000105427267816ULL, 0x000fe40000000026ULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x000010547a277816ULL, 0x000fe20000000079ULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x0000008bff8b723eULL, 0x000fc400020006ffULL, 0x00000010ff7c7819ULL, 0x000fe2000001167cULL,
0x2000008aff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe2000001167bULL,
0x2000008bff8b7230ULL, 0x000fe20000004100ULL, 0x0000008eff8e723eULL, 0x000fe200020006ffULL,
0x000000267064723cULL, 0x002f620000041864ULL, 0x000000ff8f8f7812ULL, 0x000fe400078ec0ffULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x2000008eff8e7230ULL, 0x000fe20000004100ULL,
0x0000105478787816ULL, 0x000fc40000000077ULL, 0x00000010ff7a7819ULL, 0x000fe20000011682ULL,
0x2000008cff907230ULL, 0x000fe20000004100ULL, 0x00000010ff777819ULL, 0x000fe20000011680ULL,
0x000000266844723cULL, 0x004b620000041844ULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x000010547c797816ULL, 0x000fe40000000079ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff7c7819ULL, 0x000fe2000001167dULL, 0x0000000102277824ULL, 0x020fe200078e021eULL,
0x0000008fff8f723eULL, 0x000fe200020006ffULL, 0x000000787060723cULL, 0x000f620000041860ULL,
0x00000008ff887819ULL, 0x000fc40000011695ULL, 0x00001054777a7816ULL, 0x000fe4000000007aULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe20000011696ULL,
0x000000786840723cULL, 0x000f620000041840ULL, 0x00000008ff777819ULL, 0x000fe40000011697ULL,
0x00000008ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff7b7819ULL, 0x000fe20000011683ULL,
0x2000008fff837230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fc4000001167eULL,
0x00001054817c7816ULL, 0x000fe4000000007cULL, 0x00000010ff817819ULL, 0x000fe4000001168aULL,
0x00000010ff7e7819ULL, 0x000fe4000001168bULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000010ff257819ULL, 0x000fe40000011625ULL, 0x00000010ff8e7819ULL, 0x000fe2000001168eULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000087ff877230ULL, 0x000fe20000004100ULL, 0x00000077ff82723eULL, 0x000fe200020006ffULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x2000008cff8c7230ULL, 0x000fe20000004100ULL, 0x000010547e817816ULL, 0x000fe20000000081ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff8f7819ULL, 0x000fe20000011690ULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000010ff7e7819ULL, 0x000fc40000011683ULL,
0x000010548e8e7816ULL, 0x000fe20000000025ULL, 0x000000021a257824ULL, 0x000fe200078e00ffULL,
0x00000010ff807819ULL, 0x000fe40000011685ULL, 0x000010547e8f7816ULL, 0x000fe4000000008fULL,
0x00000010ff7e7819ULL, 0x000fe4000001161dULL, 0x00001054807d7816ULL, 0x000fe4000000007dULL,
0x00000010ff897819ULL, 0x000fe20000011689ULL, 0x0000008e704c723cULL, 0x000f62000004184cULL,
0x00000010ff887819ULL, 0x000fc40000011688ULL, 0x00000004251d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff807819ULL, 0x000fe20000011687ULL,
0x0000007c7058723cULL, 0x000f620000041858ULL, 0x00000010ff777819ULL, 0x000fe40000011686ULL,
0x00000010ff8d7819ULL, 0x000fe4000001168dULL, 0x00000010ff8c7819ULL, 0x000fc4000001168cULL,
0x00000010ff1f7819ULL, 0x000fe2000001161fULL, 0x0000007c6838723cULL, 0x040f620000041838ULL,
0x00000010ff827819ULL, 0x000fe40000011682ULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x0000105489887816ULL, 0x000fe40000000088ULL, 0x000000021d267812ULL, 0x000fe200078efcffULL,
0x0000008e682c723cULL, 0x000f62000004182cULL, 0x000010547b7b7816ULL, 0x000fc40000000084ULL,
0x0000105477807816ULL, 0x000fe40000000080ULL, 0x000010548d897816ULL, 0x000fe4000000008cULL,
0x000010541f827816ULL, 0x000fe20000000082ULL, 0x0000007a705c723cULL, 0x000f62000004185cULL,
0x000010547e837816ULL, 0x000fe2000000007fULL, 0x00000008021f7824ULL, 0x000fe200078e00ffULL,
0x0000002617267211ULL, 0x000fca00078fe0ffULL, 0x000000807054723cULL, 0x000f620000041854ULL,
0x00000001031d7824ULL, 0x100fe400078e0226ULL, 0x0000000102267824ULL, 0x000fca00078e0226ULL,
0x000000887050723cULL, 0x000f620000041850ULL, 0xfffffff81f1e7812ULL, 0x000fe400078ee226ULL,
0x0000100000267810ULL, 0x000fca0007ffe0ffULL, 0x000000827048723cULL, 0x000b6e0000041848ULL,
0x0000000803707824ULL, 0x020fe200078e00ffULL, 0x0000007a683c723cULL, 0x000f62000004183cULL,
0x0000000802727824ULL, 0x000fc600078e00ffULL, 0xfffffff8701d7812ULL, 0x000fe400078ee21dULL,
0xfffffff8721f7812ULL, 0x000fe400078ee227ULL, 0x000000806834723cULL, 0x040f620000041834ULL,
0x000000101d707824ULL, 0x100fe400078e0220ULL, 0x000000101e207824ULL, 0x000fe400078e0220ULL,
0x000000101f787824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x000000886830723cULL, 0x040f700000041830ULL, 0x000000826828723cULL, 0x000b640000041828ULL,
0x000000002068783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000770707231ULL, 0x082fe400003400ffULL,
0x0000000772727231ULL, 0x000fc400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fe400003400ffULL, 0x0000000568687231ULL, 0x088fe400003400ffULL,
0x000000056a6a7231ULL, 0x000fe400003400ffULL, 0x0000000469697231ULL, 0x080fe400003400ffULL,
0x000000046b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000802777824ULL, 0x000fe200078e00ffULL, 0x0000000227207810ULL, 0x004fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ea60000004200ULL, 0xfffffff877207812ULL, 0x000fca00078ee220ULL,
0x00000010207c7824ULL, 0x000fcc00078e0226ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x00000010ff267819ULL, 0x104fe40000011678ULL, 0x000000ff78777812ULL, 0x040fe400078ec0ffULL,
0x00000018ff277819ULL, 0x000fe40000011678ULL, 0x0000ffff78947812ULL, 0x000fe400078ec0ffULL,
0x000000ff79787812ULL, 0x000fe400078ec0ffULL, 0x00000010ff807819ULL, 0x000fc40000011679ULL,
0x00000018ff817819ULL, 0x000fe40000011679ULL, 0x0000ffff79977812ULL, 0x000fe400078ec0ffULL,
0x00000078ff79723eULL, 0x000fe400020006ffULL, 0x00000027ff78723eULL, 0x000fe400020006ffULL,
0x00000018ff857819ULL, 0x000fe4000001167bULL, 0x000000ff26267812ULL, 0x000fc400078ec0ffULL,
0x00000010ff847819ULL, 0x100fe4000001167aULL, 0x000000ff7a837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff827819ULL, 0x000fe4000001167aULL, 0x0000ffff7a987812ULL, 0x000fe200078ec0ffULL,
0x20000078ff7a7230ULL, 0x000fe20000004100ULL, 0x00000085ff78723eULL, 0x000fe400020006ffULL,
0x00000077ff77723eULL, 0x000fc400020006ffULL, 0x00000026ff26723eULL, 0x000fe200020006ffULL,
0x20000078ff8b7230ULL, 0x000fe20000004100ULL, 0x00000010ff897819ULL, 0x110fe2000001167cULL,
0x20000077ff277230ULL, 0x000fe20000004100ULL, 0x000000ff7c8c7812ULL, 0x040fe200078ec0ffULL,
0x20000026ff787230ULL, 0x000fe20000004100ULL, 0x00000018ff8a7819ULL, 0x000fe4000001167cULL,
0x0000ffff7c9a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001167dULL,
0x00000010ff8d7819ULL, 0x000fe4000001167dULL, 0x000000ff7d8e7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff7d9b7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001167eULL,
0x00000010ff867819ULL, 0x000fe4000001167bULL, 0x000000ff7b877812ULL, 0x000fc400078ec0ffULL,
0x0000ffff7b997812ULL, 0x000fe200078ec0ffULL, 0x20000079ff7b7230ULL, 0x000fe20000004100ULL,
0x00000083ff77723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x00000008ff267819ULL, 0x000fe20000011694ULL, 0x20000077ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fe2000001167eULL, 0x2000007cff937230ULL, 0x000fe20000004100ULL,
0x000000ff7e8f7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7e9c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001167fULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x00000008ff797819ULL, 0x000fe40000011697ULL, 0x00000026ff26723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fc400020006ffULL, 0x0000007eff77723eULL, 0x000fe200020006ffULL,
0x2000007dff7e7230ULL, 0x000fe20000004100ULL, 0x00000079ff7c723eULL, 0x000fe200020006ffULL,
0x20000026ff797230ULL, 0x000fe20000004100ULL, 0x000000ff86867812ULL, 0x000fe200078ec0ffULL,
0x20000081ff837230ULL, 0x000fe20000004100ULL, 0x00000008ff7d7819ULL, 0x000fe20000011698ULL,
0x2000007cff817230ULL, 0x000fe20000004100ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000008ff267819ULL, 0x000fc40000011699ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000087ff887230ULL, 0x000fe20000004100ULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000082ff877230ULL, 0x000fe20000004100ULL, 0x000000ff897c7812ULL, 0x000fe200078ec0ffULL,
0x20000086ff897230ULL, 0x000fe20000004100ULL, 0x0000008aff8a723eULL, 0x000fe200020006ffULL,
0x2000007dff867230ULL, 0x000fe20000004100ULL, 0x000000ff80807812ULL, 0x000fc400078ec0ffULL,
0x00000026ff26723eULL, 0x000fe400020006ffULL, 0x000000ff7f927812ULL, 0x000fe400078ec0ffULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x000000ff8d8d7812ULL, 0x000fe200078ec0ffULL, 0x2000008eff907230ULL, 0x000fe20000004100ULL,
0x0000008fff82723eULL, 0x000fe200020006ffULL, 0x2000008aff8f7230ULL, 0x000fe20000004100ULL,
0x00000080ff80723eULL, 0x000fe200020006ffULL, 0x20000026ff8a7230ULL, 0x000fe20000004100ULL,
0x00000008ff7d7819ULL, 0x000fe2000001169aULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x00000092ff92723eULL, 0x000fe200020006ffULL, 0x20000080ff807230ULL, 0x000fe20000004100ULL,
0x000000ff84847812ULL, 0x000fc400078ec0ffULL, 0x0000008dff26723eULL, 0x000fe200020006ffULL,
0x2000007cff8d7230ULL, 0x000fe20000004100ULL, 0x00000008ff8e7819ULL, 0x000fe2000001169bULL,
0x20000092ff967230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x000000ff917c7812ULL, 0x000fe200078ec0ffULL, 0x20000026ff917230ULL, 0x000fe20000004100ULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000010ff957819ULL, 0x000fc4000001167fULL,
0x0000008eff92723eULL, 0x000fe200020006ffULL, 0x2000007dff8e7230ULL, 0x000fe20000004100ULL,
0x0000007cff94723eULL, 0x000fe200020006ffULL, 0x20000084ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff267819ULL, 0x000fe20000011627ULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe2000001167bULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000010ff277819ULL, 0x000fe40000011678ULL, 0x00000010ff7b7819ULL, 0x000fc4000001167aULL,
0x00000010ff7d7819ULL, 0x000fe40000011680ULL, 0x00000010ff787819ULL, 0x000fe40000011679ULL,
0x000000ff95957812ULL, 0x000fe400078ec0ffULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x0000105427267816ULL, 0x000fe40000000026ULL, 0x000010547d277816ULL, 0x000fc4000000007cULL,
0x000010547b787816ULL, 0x000fe40000000078ULL, 0x00000010ff7a7819ULL, 0x000fe40000011683ULL,
0x00000010ff7b7819ULL, 0x000fe20000011688ULL, 0x000000267064723cULL, 0x002f620000041864ULL,
0x00000010ff797819ULL, 0x000fe40000011681ULL, 0x00000010ff7c7819ULL, 0x000fe40000011689ULL,
0x00000010ff857819ULL, 0x000fc40000011685ULL, 0x00000010ff847819ULL, 0x000fe20000011684ULL,
0x000000266844723cULL, 0x008b620000041844ULL, 0x00000008ff817819ULL, 0x000fe4000001169cULL,
0x00000095ff95723eULL, 0x000fe400020006ffULL, 0x00000008ff7f7819ULL, 0x000fe4000001167fULL,
0x000010547a797816ULL, 0x000fe20000000079ULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x000010547c7b7816ULL, 0x000fc4000000007bULL, 0x00001054847a7816ULL, 0x000fe40000000085ULL,
0x00000010ff7c7819ULL, 0x000fe20000011686ULL, 0x000000787060723cULL, 0x040f620000041860ULL,
0x00000081ff83723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff817819ULL, 0x000fe20000011690ULL, 0x20000083ff857230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fe20000011691ULL, 0x2000008cff8c7230ULL, 0x000fe20000004100ULL,
0x0000007fff86723eULL, 0x000fe200020006ffULL, 0x0000007a705c723cULL, 0x000f62000004185cULL,
0x0000105484817816ULL, 0x000fc40000000081ULL, 0x00000010ff807819ULL, 0x000fe2000001168bULL,
0x20000086ff867230ULL, 0x000fe20000004100ULL, 0x00000010ff7d7819ULL, 0x000fe4000001168aULL,
0x00000010ff827819ULL, 0x000fe20000011682ULL, 0x000000786840723cULL, 0x000f620000041840ULL,
0x00000010ff7f7819ULL, 0x000fe40000011694ULL, 0x00000010ff837819ULL, 0x000fe40000011696ULL,
0x00000010ff847819ULL, 0x000fc40000011695ULL, 0x00001054807d7816ULL, 0x000fe2000000007dULL,
0x0000007a683c723cULL, 0x000f62000004183cULL, 0x00000010ff8f7819ULL, 0x000fe4000001168fULL,
0x00000010ff8e7819ULL, 0x000fe4000001168eULL, 0x000010547f827816ULL, 0x000fe40000000082ULL,
0x0000105484837816ULL, 0x000fe40000000083ULL, 0x00000010ff877819ULL, 0x000fc40000011687ULL,
0x00000010ff807819ULL, 0x000fe4000001168cULL, 0x00000010ff8d7819ULL, 0x000fe2000001168dULL,
0x00000082704c723cULL, 0x080f62000004184cULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff857819ULL, 0x000fe20000011685ULL, 0x00000082682c723cULL, 0x000f62000004182cULL,
0x00000010ff847819ULL, 0x000fc40000011677ULL, 0x00000010ff7f7819ULL, 0x000fe40000011686ULL,
0x000010548f8e7816ULL, 0x000fe4000000008eULL, 0x00001054877c7816ULL, 0x000fe4000000007cULL,
0x000010548d807816ULL, 0x000fe40000000080ULL, 0x00001054938f7816ULL, 0x000fe40000000092ULL,
0x000010547e7e7816ULL, 0x000fe20000000085ULL, 0x0000007c7058723cULL, 0x000f620000041858ULL,
0x00001054847f7816ULL, 0x000fc4000000007fULL, 0xfffffff825267812ULL, 0x020fca00078ec0ffULL,
0x000000807054723cULL, 0x040f700000041854ULL, 0x0000008e7050723cULL, 0x040f700000041850ULL,
0x0000007e7048723cULL, 0x000f700000041848ULL, 0x0000007c6838723cULL, 0x040f700000041838ULL,
0x000000806834723cULL, 0x040f700000041834ULL, 0x0000008e6830723cULL, 0x040f700000041830ULL,
0x0000007e6828723cULL, 0x000b6e0000041828ULL, 0x000126c8136a7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126900026ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x004fc80000015200ULL,
0x000004000d697984ULL, 0x000ea40000000800ULL, 0x8000000069ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000687805ULL, 0x000fcc0000015200ULL,
0x0000006826717210ULL, 0x000fca0007f1e1ffULL, 0x0000000169697824ULL, 0x000fe200000e0e27ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff687819ULL, 0x000fc80000011469ULL, 0x0000007168687211ULL, 0x000fca00078110ffULL,
0x000000ffff697224ULL, 0x000fca00000e0669ULL, 0x0000000268687819ULL, 0x000fc80000001269ULL,
0x000000680000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d697984ULL, 0x000e640000000800ULL, 0x8000000069ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00c277810ULL, 0x000fca0007ffe0ffULL,
0x0000680012717a24ULL, 0x000fe200078e0227ULL, 0x000003e00000a947ULL, 0x000fea0003800000ULL,
0x0000002716257217ULL, 0x000fe20007800000ULL, 0x0000001011707824ULL, 0x000fe200078e00ffULL,
0x00000003ff687819ULL, 0x000fe40000011617ULL, 0x0000100000797810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a27ULL, 0x0000000468697810ULL, 0x000fe20007ffe0ffULL,
0x0000000170267824ULL, 0x000fe200078e0268ULL, 0x00000008686b7810ULL, 0x000fe40007ffe0ffULL,
0x0000002570257217ULL, 0x000fe20007800000ULL, 0x0000000126277824ULL, 0x000fc400078e0217ULL,
0x0000000826727824ULL, 0x040fe400078e00ffULL, 0x0000000125257824ULL, 0x000fe400078e0a70ULL,
0x0000000126267824ULL, 0x000fe200078e0271ULL, 0xfffffff872727812ULL, 0x000fe200078ee227ULL,
0x0000000170787824ULL, 0x000fe200078e0269ULL, 0x000000256900720cULL, 0x080fe20003f86070ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c68697810ULL, 0x040fe40007ffe0ffULL,
0x000000256800720cULL, 0x080fe20003fa6070ULL, 0x0000000178687824ULL, 0x000fe200078e0271ULL,
0x000000256900720cULL, 0x000fe20003f06070ULL, 0x00000001707c7824ULL, 0x000fe200078e0269ULL,
0x0000000b266a7212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x000000256b00720cULL, 0x000fc40003f66070ULL, 0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x00000001707a7824ULL, 0x000fe200078e026bULL, 0x0000000b68707212ULL, 0x000fe200078efcffULL,
0x0000000178257824ULL, 0x000fe200078e0217ULL, 0x00006500276b7a10ULL, 0x000fe200037fe4ffULL,
0x000000017a267824ULL, 0x000fe200078e0271ULL, 0x0000640070707a10ULL, 0x000fe20007fde0ffULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee225ULL, 0x000000017c687824ULL, 0x000fe200078e0271ULL,
0x0000650069717a10ULL, 0x000fe200037fe4ffULL, 0x000000017a737824ULL, 0x000fe200078e0217ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fc600078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007fde0ffULL, 0x000000087a7a7824ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x000000017c257824ULL, 0x040fe200078e0217ULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x000000087c7c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee273ULL, 0x0000001078737824ULL, 0x000fe200078e0279ULL,
0x0000640068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee225ULL,
0x0000001072257824ULL, 0x100fe200078e0279ULL, 0x0000650069697a10ULL, 0x000fe200037fe4ffULL,
0x000000107a777824ULL, 0x000fc400078e0279ULL, 0x000000107c797824ULL, 0x000fe200078e0279ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a257faeULL, 0x0003e8000e901c46ULL,
0x0000000070737faeULL, 0x0003e8000e101c46ULL, 0x0000000026777faeULL, 0x0003e8000d901c46ULL,
0x0000000068797faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fe200078e00ffULL, 0x0000100000797810ULL, 0x000fc80007ffe0ffULL,
0x0000002617687211ULL, 0x000fc800078fe8ffULL, 0x00000004686a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000168267824ULL, 0x040fe200078e0271ULL, 0x0000000868787810ULL, 0x040fe20007ffe0ffULL,
0x0000000168257824ULL, 0x040fe200078e0217ULL, 0x0000000c687a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000868727824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee225ULL, 0x000000016a257824ULL, 0x000fe200078e0271ULL,
0x0000000b26707212ULL, 0x000fe200078efcffULL, 0x000000016a697824ULL, 0x040fe400078e0217ULL,
0x000000086a7c7824ULL, 0x000fe200078e00ffULL, 0x0000640070707a10ULL, 0x000fe20007f1e0ffULL,
0x0000000178687824ULL, 0x100fe400078e0271ULL, 0x000000017a6a7824ULL, 0x040fe400078e0271ULL,
0x000000017a267824ULL, 0x000fc400078e0217ULL, 0x000000087a717824ULL, 0x000fe400078e00ffULL,
0x00000001786b7824ULL, 0x040fe400078e0217ULL, 0x00000008787e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87c787812ULL, 0x000fe200078ee269ULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0xfffffff8717c7812ULL, 0x000fe400078ee226ULL, 0x0000650027717a10ULL, 0x000fe200007fe4ffULL,
0x0000008025267825ULL, 0x000fe200078e00ffULL, 0xfffffff87e7a7812ULL, 0x000fc400078ee26bULL,
0x0000000b68687212ULL, 0x080fe200078efcffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000640068687a10ULL, 0x000fe20007f7e0ffULL,
0x0000001072257824ULL, 0x100fe200078e0279ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000001078737824ULL, 0x100fe200078e0279ULL, 0x0000640026267a10ULL, 0x000fe20007f1e0ffULL,
0x000000107a777824ULL, 0x100fe200078e0279ULL, 0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x000000107c797824ULL, 0x000fe200078e0279ULL, 0x0000650027277a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000070257faeULL, 0x0003e2000b901c46ULL,
0x0000650069697a10ULL, 0x000fc40001ffe4ffULL, 0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026737faeULL, 0x0003e8000b901c46ULL, 0x0000000068777faeULL, 0x0003e8000b901c46ULL,
0x000000006a797faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff014687812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126b00068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126480023707f8cULL, 0x0004e4000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0xffffffe014237812ULL, 0x044fe400078ec0ffULL,
0x00000010146a7812ULL, 0x040fe400078ec0ffULL, 0x0000000814257812ULL, 0x000fc800078ec0ffULL,
0x0000002325237210ULL, 0x000fca0007ffe06aULL, 0x01264c0023257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x00cfe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006a7805ULL, 0x000fcc0000015200ULL,
0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL, 0x000000016b6b7824ULL, 0x000fe200000e0e27ULL,
0x003d09006a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146bULL, 0x0000006a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6a7224ULL, 0x000fca00000e066bULL, 0x0000000225257819ULL, 0x000fc8000000126aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01264c0023257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a237824ULL, 0x000fca00078e00ffULL,
0xffffff8023267812ULL, 0x000fc800078ec0ffULL, 0x000001000b237810ULL, 0x000fca0007ffe026ULL,
0x000000010a237824ULL, 0x000fca00078e0223ULL, 0x0120000023717984ULL, 0x000ea80000000800ULL,
0x0122000023707984ULL, 0x0006620000000800ULL, 0x000000247100720bULL, 0x004fe20003f1d000ULL,
0x000105f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000727806ULL, 0x008fc800000e0100ULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0024ULL,
0x0000073000008947ULL, 0x000fea0003800000ULL, 0x0000000210237810ULL, 0x000fe40007ffe0ffULL,
0x000000247100720bULL, 0x000fe40003f74000ULL, 0x0000001a2300720cULL, 0x000fe20003f05270ULL,
0x000105a27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000237806ULL, 0x000fc400018e0100ULL,
0x000000801a278824ULL, 0x000fe200078e020bULL, 0x0000002471257209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a268824ULL, 0x000fca00078e0227ULL,
0x0124002526008388ULL, 0x0005e20000000800ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x8000002524257221ULL, 0x004fe20000010000ULL,
0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x0000002500277308ULL, 0x000ea40000000800ULL,
0x0000002722227220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x000104e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe20000410000ULL,
0x0000002665657220ULL, 0x080fe20000410000ULL, 0x0000002660607220ULL, 0x080fe20000410000ULL,
0x0000002661617220ULL, 0x080fe20000410000ULL, 0x000000265c5c7220ULL, 0x080fe20000410000ULL,
0x000000265d5d7220ULL, 0x080fe20000410000ULL, 0x0000002658587220ULL, 0x080fe20000410000ULL,
0x0000002659597220ULL, 0x080fe20000410000ULL, 0x0000002654547220ULL, 0x080fe20000410000ULL,
0x0000002655557220ULL, 0x080fe20000410000ULL, 0x0000002650507220ULL, 0x080fe20000410000ULL,
0x0000002651517220ULL, 0x080fe20000410000ULL, 0x000000264c4c7220ULL, 0x080fe20000410000ULL,
0x000000264d4d7220ULL, 0x080fe20000410000ULL, 0x0000002648487220ULL, 0x080fe20000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x000103a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe20000410000ULL, 0x0000002667677220ULL, 0x080fe20000410000ULL,
0x0000002662627220ULL, 0x080fe20000410000ULL, 0x0000002663637220ULL, 0x080fe20000410000ULL,
0x000000265e5e7220ULL, 0x080fe20000410000ULL, 0x000000265f5f7220ULL, 0x080fe20000410000ULL,
0x000000265a5a7220ULL, 0x080fe20000410000ULL, 0x000000265b5b7220ULL, 0x080fe20000410000ULL,
0x0000002656567220ULL, 0x080fe20000410000ULL, 0x0000002657577220ULL, 0x080fe20000410000ULL,
0x0000002652527220ULL, 0x080fe20000410000ULL, 0x0000002653537220ULL, 0x080fe20000410000ULL,
0x000000264e4e7220ULL, 0x080fe20000410000ULL, 0x000000264f4f7220ULL, 0x080fe20000410000ULL,
0x000000264a4a7220ULL, 0x080fe20000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x000102627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe20000410000ULL,
0x0000002645457220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x0000002638387220ULL, 0x080fe20000410000ULL,
0x0000002639397220ULL, 0x080fe20000410000ULL, 0x0000002634347220ULL, 0x080fe20000410000ULL,
0x0000002635357220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x0000002628287220ULL, 0x080fe20000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x000101327f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe20000410000ULL,
0x0000002647477220ULL, 0x080fe20000410000ULL, 0x0000002642427220ULL, 0x080fe20000410000ULL,
0x0000002643437220ULL, 0x080fe20000410000ULL, 0x000000263e3e7220ULL, 0x080fe20000410000ULL,
0x000000263f3f7220ULL, 0x080fe20000410000ULL, 0x000000263a3a7220ULL, 0x080fe20000410000ULL,
0x000000263b3b7220ULL, 0x080fe20000410000ULL, 0x0000002636367220ULL, 0x080fe20000410000ULL,
0x0000002637377220ULL, 0x080fe20000410000ULL, 0x0000002632327220ULL, 0x080fe20000410000ULL,
0x0000002633337220ULL, 0x080fe20000410000ULL, 0x000000262e2e7220ULL, 0x080fe20000410000ULL,
0x000000262f2f7220ULL, 0x080fe20000410000ULL, 0x000000262a2a7220ULL, 0x080fe20000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000002372ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6a7424ULL, 0x000fe200078e00ffULL,
0x0000002471237209ULL, 0x000fd60007810000ULL, 0x8000002371710221ULL, 0x000fe20000010000ULL,
0x00007610ff6a0816ULL, 0x000fc6000000006aULL, 0x3fb8aa3b71710820ULL, 0x000fc80000410000ULL,
0x0000007100090308ULL, 0x000ea40000000800ULL, 0x0000000970700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002270227221ULL, 0x002fc20000010000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000040008277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026246b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106a247816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff247819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x0000fcf27f007947ULL, 0x000fea000b800000ULL, 0x00001f2427077589ULL, 0x0002a400000e0000ULL,
0x0000000824267810ULL, 0x000fe20007ffe0ffULL, 0x0000fd127f007947ULL, 0x000fea000b800000ULL,
0x0000001024047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x0000001824267810ULL, 0x008fe20007ffe0ffULL,
0x0000fd427f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021a6a7824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a267824ULL, 0x008fe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000008036c7824ULL, 0x000fe200078e00ffULL,
0x000000046a247812ULL, 0x002fe200078ec0ffULL, 0x0000000802277824ULL, 0x000fe200078e00ffULL,
0xfffff000266b7812ULL, 0x000fe200078ec0ffULL, 0x000000101c787824ULL, 0x000fe200078e0200ULL,
0x0000002417247211ULL, 0x000fc400078fe0ffULL, 0x0000c0006b6b7810ULL, 0x000fc60007ffe0ffULL,
0x0000000103257824ULL, 0x100fe400078e0224ULL, 0x0000000102267824ULL, 0x000fc600078e0224ULL,
0xfffffff86c247812ULL, 0x000fe400078ee225ULL, 0xfffffff827267812ULL, 0x000fc600078ee226ULL,
0x0000001024707824ULL, 0x100fe400078e026bULL, 0x0000001026267824ULL, 0x000fc800078e026bULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002624783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707231ULL, 0x086fe400003400ffULL,
0x0000000772727231ULL, 0x000fe400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fc400003400ffULL, 0x0000000524247231ULL, 0x088fe400003400ffULL,
0x0000000526267231ULL, 0x000fe400003400ffULL, 0x0000000425257231ULL, 0x080fe400003400ffULL,
0x0000000427277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000010217c7824ULL, 0x000fe200078e0200ULL,
0x00000c1000007945ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x00000018ff6c7819ULL, 0x010fc40000011678ULL, 0x00000018ff837819ULL, 0x000fe4000001167bULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000010ff217819ULL, 0x000fe40000011678ULL,
0x000000ff786d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff78957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff777819ULL, 0x000fc40000011679ULL, 0x000000ff79817812ULL, 0x040fe400078ec0ffULL,
0x00000018ff807819ULL, 0x000fe40000011679ULL, 0x0000ffff79967812ULL, 0x000fe400078ec0ffULL,
0x00000010ff827819ULL, 0x100fe4000001167aULL, 0x000000ff7a797812ULL, 0x000fe400078ec0ffULL,
0x00000018ff787819ULL, 0x000fc4000001167aULL, 0x0000ffff7a977812ULL, 0x000fe200078ec0ffULL,
0x2000006cff7a7230ULL, 0x000fe20000004100ULL, 0x00000083ff6c723eULL, 0x000fe400020006ffULL,
0x000000ff7b857812ULL, 0x000fe400078ec0ffULL, 0x000000ff7d8a7812ULL, 0x008fe200078ec0ffULL,
0x2000006cff897230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fc400020006ffULL, 0x0000008aff6c723eULL, 0x000fe200020006ffULL,
0x20000085ff867230ULL, 0x000fe20000004100ULL, 0x000000ff21217812ULL, 0x000fe200078ec0ffULL,
0x20000078ff857230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x2000006cff8e7230ULL, 0x000fe20000004100ULL, 0x00000021ff6c723eULL, 0x000fe400020006ffULL,
0x000000ff77787812ULL, 0x000fe200078ec0ffULL, 0x20000079ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff847819ULL, 0x000fc4000001167bULL, 0x0000ffff7b987812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x100fe4000001167cULL, 0x000000ff7c877812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fe4000001167cULL, 0x0000ffff7c997812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001167dULL, 0x00000078ff79723eULL, 0x000fe200020006ffULL,
0x2000006cff787230ULL, 0x000fe20000004100ULL, 0x00000008ff6c7819ULL, 0x000fe40000011695ULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x2000007bff8d7230ULL, 0x000fe20000004100ULL,
0x00000010ff8b7819ULL, 0x000fe2000001167dULL, 0x2000007cff917230ULL, 0x000fe20000004100ULL,
0x0000ffff7d9a7812ULL, 0x000fe200078ec0ffULL, 0x20000079ff7c7230ULL, 0x000fe20000004100ULL,
0x00000018ff7d7819ULL, 0x000fe2000001167eULL, 0x2000006cff797230ULL, 0x000fe20000004100ULL,
0x00000008ff7b7819ULL, 0x000fc40000011696ULL, 0x00000018ff8f7819ULL, 0x000fe4000001167fULL,
0x000000ff7e8c7812ULL, 0x040fe400078ec0ffULL, 0x00000008ff6c7819ULL, 0x000fe40000011698ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000010ff927819ULL, 0x000fe2000001167eULL, 0x2000007dff777230ULL, 0x000fe20000004100ULL,
0x0000ffff7e9b7812ULL, 0x000fe200078ec0ffULL, 0x2000007bff7d7230ULL, 0x000fe20000004100ULL,
0x000000ff7f907812ULL, 0x000fc400078ec0ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x0000008cff7e723eULL, 0x000fe400020006ffULL, 0x000000ff88887812ULL, 0x000fe200078ec0ffULL,
0x2000008fff217230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x000000ff8b8c7812ULL, 0x000fe400078ec0ffULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x00000008ff8b7819ULL, 0x000fe40000011699ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000088ff7b723eULL, 0x000fe200020006ffULL,
0x2000006cff887230ULL, 0x000fe20000004100ULL, 0x00000008ff8f7819ULL, 0x000fe2000001169aULL,
0x20000090ff947230ULL, 0x000fe20000004100ULL, 0x0000008cff8c723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000008bff6c723eULL, 0x000fe200020006ffULL,
0x2000007bff8b7230ULL, 0x000fe20000004100ULL, 0x000000ff82827812ULL, 0x000fc400078ec0ffULL,
0x0000008fff90723eULL, 0x000fe200020006ffULL, 0x2000008cff8f7230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x2000006cff8c7230ULL, 0x000fe20000004100ULL,
0x00000010ff6c7819ULL, 0x000fe2000001166dULL, 0x20000090ff907230ULL, 0x000fe20000004100ULL,
0x00000082ff82723eULL, 0x000fe200020006ffULL, 0x20000087ff8a7230ULL, 0x000fe20000004100ULL,
0x00000010ff6d7819ULL, 0x000fe40000011678ULL, 0x00000010ff817819ULL, 0x000fe20000011681ULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff7c7819ULL, 0x000fc4000001167cULL,
0x000010546d6c7816ULL, 0x000fe4000000006cULL, 0x000000ff84877812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7b7819ULL, 0x000fe4000001167aULL, 0x00000010ff787819ULL, 0x000fe40000011679ULL,
0x000010547c6d7816ULL, 0x000fe40000000081ULL, 0x00000080ff80723eULL, 0x000fc400020006ffULL,
0x00000008ff847819ULL, 0x000fe40000011697ULL, 0x00000008ff817819ULL, 0x000fe2000001169bULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff937819ULL, 0x000fe2000001167fULL,
0x0000006c7064723cULL, 0x002f620000041864ULL, 0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x000010547b787816ULL, 0x000fe40000000078ULL, 0x00000010ff7a7819ULL, 0x000fc40000011683ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x0000006c2444723cULL, 0x000f620000041844ULL,
0x00000010ff7b7819ULL, 0x000fe40000011682ULL, 0x00000081ff83723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x000000ff92927812ULL, 0x000fe400078ec0ffULL,
0x00000010ff817819ULL, 0x000fe2000001168eULL, 0x20000083ff837230ULL, 0x000fe20000004100ULL,
0x00000010ff827819ULL, 0x000fc4000001168fULL, 0x000000ff93937812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7f7819ULL, 0x000fe4000001167fULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x0000105482817816ULL, 0x000fe40000000081ULL, 0x00000087ff87723eULL, 0x000fe200020006ffULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000010ff807819ULL, 0x000fc40000011680ULL,
0x00000010ff797819ULL, 0x000fe2000001167dULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x0000007fff82723eULL, 0x000fe400020006ffULL,
0x0000105480797816ULL, 0x000fe20000000079ULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe20000011684ULL, 0x20000082ff847230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fc40000011689ULL, 0x00000010ff7d7819ULL, 0x000fe20000011688ULL,
0x000000787060723cULL, 0x080f620000041860ULL, 0x00000010ff8d7819ULL, 0x000fe4000001168dULL,
0x00001054807d7816ULL, 0x000fe4000000007dULL, 0x00000010ff8c7819ULL, 0x000fe4000001168cULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x000000782440723cULL, 0x000b620000041840ULL,
0x00000010ff7f7819ULL, 0x000fc40000011692ULL, 0x00000010ff827819ULL, 0x000fe40000011677ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff867819ULL, 0x000fe20000011686ULL,
0x000000101f787824ULL, 0x020fe200078e0200ULL, 0x00000010ff877819ULL, 0x000fe40000011687ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff807819ULL, 0x000fc4000001168aULL,
0x00000010ff8b7819ULL, 0x000fe4000001168bULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff907819ULL, 0x000fe40000011690ULL, 0x00000010ff947819ULL, 0x000fe40000011694ULL,
0x00000010ff937819ULL, 0x000fe40000011693ULL, 0x00000010ff217819ULL, 0x000fc40000011621ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x000010547b7a7816ULL, 0x000fe4000000007aULL,
0x000010548d8c7816ULL, 0x000fe4000000008cULL, 0x000010547f7e7816ULL, 0x000fe4000000007eULL,
0x0000105482827816ULL, 0x000fe40000000083ULL, 0x00001054877b7816ULL, 0x000fc40000000086ULL,
0x00001054857c7816ULL, 0x000fe4000000007cULL, 0x000010548b807816ULL, 0x000fe40000000080ULL,
0x00001054918d7816ULL, 0x000fe20000000090ULL, 0x0000007a705c723cULL, 0x000f62000004185cULL,
0x00001054937f7816ULL, 0x000fe40000000094ULL, 0x0000105421837816ULL, 0x000fca0000000084ULL,
0x0000007c7058723cULL, 0x040f700000041858ULL, 0x000000807054723cULL, 0x040f700000041854ULL,
0x0000008c7050723cULL, 0x040f700000041850ULL, 0x0000007e704c723cULL, 0x040f70000004184cULL,
0x000000827048723cULL, 0x000b6e0000041848ULL, 0x000000101d707824ULL, 0x120fe200078e026bULL,
0x0000007a243c723cULL, 0x000f62000004183cULL, 0x000000101e6b7824ULL, 0x000fc800078e026bULL,
0x000000007070783bULL, 0x000e660000000200ULL, 0x0000007c2438723cULL, 0x040f700000041838ULL,
0x000000802434723cULL, 0x040f700000041834ULL, 0x0000008c2430723cULL, 0x040f700000041830ULL,
0x0000007e242c723cULL, 0x040f70000004182cULL, 0x000000822428723cULL, 0x000b640000041828ULL,
0x000000006b24783bULL, 0x0206a20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000770707231ULL, 0x086fe400003400ffULL,
0x0000000772727231ULL, 0x000fc400003400ffULL, 0x0000000671717231ULL, 0x080fe400003400ffULL,
0x0000000673737231ULL, 0x000fe400003400ffULL, 0x0000000524247231ULL, 0x080fe400003400ffULL,
0x0000000526267231ULL, 0x000fe400003400ffULL, 0x0000000425257231ULL, 0x080fe400003400ffULL,
0x0000000427277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000010207c7824ULL, 0x000fcc00078e0200ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000010ff207819ULL, 0x110fe40000011678ULL,
0x000000ff796c7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff217819ULL, 0x000fe40000011678ULL,
0x000000ff20207812ULL, 0x000fe400078ec0ffULL, 0x000000ff786b7812ULL, 0x048fe400078ec0ffULL,
0x0000ffff78937812ULL, 0x000fc400078ec0ffULL, 0x0000006cff78723eULL, 0x000fe400020006ffULL,
0x00000021ff6c723eULL, 0x000fe400020006ffULL, 0x00000020ff20723eULL, 0x000fe400020006ffULL,
0x00000010ff6d7819ULL, 0x100fe40000011679ULL, 0x00000018ff777819ULL, 0x000fe40000011679ULL,
0x0000ffff79947812ULL, 0x000fe200078ec0ffULL, 0x20000078ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x100fe2000001167aULL, 0x2000006cff787230ULL, 0x000fe20000004100ULL,
0x000000ff7a827812ULL, 0x000fe200078ec0ffULL, 0x20000020ff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff817819ULL, 0x000fc4000001167aULL, 0x0000ffff7a957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff847819ULL, 0x100fe4000001167bULL, 0x000000ff7b837812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001167bULL, 0x0000ffff7b967812ULL, 0x000fe400078ec0ffULL,
0x00000018ff7b7819ULL, 0x000fc4000001167cULL, 0x000000ff6d6d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff207819ULL, 0x000fe40000011693ULL, 0x000000ff7e8b7812ULL, 0x000fe400078ec0ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000007aff877230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fc400020006ffULL, 0x000000ff7d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff907819ULL, 0x100fe4000001167eULL, 0x00000018ff8d7819ULL, 0x000fe4000001167eULL,
0x0000ffff7e997812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fe4000001167cULL,
0x000000ff7c887812ULL, 0x000fc400078ec0ffULL, 0x0000ffff7c977812ULL, 0x000fe400078ec0ffULL,
0x0000008bff7e723eULL, 0x000fe200020006ffULL, 0x2000007bff8b7230ULL, 0x000fe20000004100ULL,
0x00000018ff7c7819ULL, 0x000fe2000001167dULL, 0x2000006dff7b7230ULL, 0x000fe20000004100ULL,
0x00000008ff7a7819ULL, 0x000fe20000011694ULL, 0x20000020ff6d7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000007eff7e7230ULL, 0x000fe20000004100ULL,
0x00000008ff207819ULL, 0x000fc40000011696ULL, 0x00000010ff897819ULL, 0x000fe2000001167dULL,
0x2000008aff8c7230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe400020006ffULL,
0x0000006bff6b723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x2000007cff8f7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000006bff217230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x20000083ff857230ULL, 0x000fe20000004100ULL, 0x000000ff86867812ULL, 0x000fe200078ec0ffULL,
0x2000007aff7c7230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe200020006ffULL,
0x20000081ff837230ULL, 0x000fe20000004100ULL, 0x0000ffff7d987812ULL, 0x000fc400078ec0ffULL,
0x000000ff898a7812ULL, 0x000fe400078ec0ffULL, 0x00000077ff77723eULL, 0x000fe400020006ffULL,
0x00000008ff897819ULL, 0x000fe40000011697ULL, 0x00000018ff8e7819ULL, 0x000fe2000001167fULL,
0x20000077ff7d7230ULL, 0x000fe20000004100ULL, 0x0000008dff6b723eULL, 0x000fe400020006ffULL,
0x00000086ff7a723eULL, 0x000fe200020006ffULL, 0x20000020ff867230ULL, 0x000fe20000004100ULL,
0x00000008ff817819ULL, 0x000fe20000011695ULL, 0x2000006bff6b7230ULL, 0x000fe20000004100ULL,
0x00000008ff8d7819ULL, 0x000fc40000011698ULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff80807812ULL, 0x000fe400078ec0ffULL, 0x00000089ff20723eULL, 0x000fe200020006ffULL,
0x2000007aff897230ULL, 0x000fe20000004100ULL, 0x0000008eff77723eULL, 0x000fe400020006ffULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x0000008dff8e723eULL, 0x000fe200020006ffULL,
0x2000008aff8d7230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x20000020ff8a7230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fe20000011621ULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x00000010ff7a7819ULL, 0x000fe20000011679ULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x00000010ff217819ULL, 0x000fe2000001166cULL,
0x20000077ff777230ULL, 0x000fe20000004100ULL, 0x00000010ff797819ULL, 0x000fe20000011678ULL,
0x2000008eff8e7230ULL, 0x000fe20000004100ULL, 0x00000010ff7b7819ULL, 0x000fc4000001167bULL,
0x00000010ff6c7819ULL, 0x000fe4000001166dULL, 0x00000010ff787819ULL, 0x000fe4000001167dULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000008ff7d7819ULL, 0x000fe40000011699ULL,
0x00000010ff917819ULL, 0x000fe2000001167fULL, 0x20000082ff827230ULL, 0x000fe20000004100ULL,
0x000000ff7f927812ULL, 0x000fc400078ec0ffULL, 0x0000105421207816ULL, 0x000fe40000000020ULL,
0x0000ffff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x000010547b217816ULL, 0x000fe4000000007aULL,
0x00001054796c7816ULL, 0x000fe4000000006cULL, 0x00000010ff7a7819ULL, 0x000fe40000011681ULL,
0x00000010ff797819ULL, 0x000fe20000011680ULL, 0x000000207064723cULL, 0x002f620000041864ULL,
0x0000007dff81723eULL, 0x000fc400020006ffULL, 0x000000ff90907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff7d7819ULL, 0x000fe2000001168cULL, 0x20000081ff817230ULL, 0x000fe20000004100ULL,
0x00000010ff807819ULL, 0x000fe2000001168dULL, 0x000000202444723cULL, 0x004b620000041844ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x000000ff91917812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7f7819ULL, 0x000fc4000001167fULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff6d7819ULL, 0x000fe4000001167cULL, 0x00001054807d7816ULL, 0x000fe2000000007dULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe200020006ffULL,
0x20000088ff887230ULL, 0x000fe20000004100ULL, 0x00000010ff827819ULL, 0x000fe20000011682ULL,
0x20000092ff927230ULL, 0x000fe20000004100ULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x0000007fff80723eULL, 0x000fc400020006ffULL,
0x00001054786d7816ULL, 0x000fe2000000006dULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x0000105479787816ULL, 0x000fe20000000082ULL, 0x20000080ff827230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe40000011687ULL, 0x00000010ff7b7819ULL, 0x000fe20000011686ULL,
0x0000006c7060723cULL, 0x000f620000041860ULL, 0x00000010ff8b7819ULL, 0x000fe4000001168bULL,
0x000010547c7b7816ULL, 0x000fc4000000007bULL, 0x00000010ff8a7819ULL, 0x000fe4000001168aULL,
0x00000010ff7e7819ULL, 0x000fe2000001167eULL, 0x0000006c2440723cULL, 0x000f620000041840ULL,
0x00000010ff7f7819ULL, 0x000fe40000011690ULL, 0x00000010ff807819ULL, 0x000fe4000001166bULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff857819ULL, 0x000fc40000011685ULL,
0x00000010ff847819ULL, 0x000fe40000011684ULL, 0x00000010ff837819ULL, 0x000fe40000011683ULL,
0x00000010ff7c7819ULL, 0x000fe40000011688ULL, 0x00000010ff897819ULL, 0x000fe40000011689ULL,
0x00000010ff8f7819ULL, 0x000fe4000001168fULL, 0x00000010ff8e7819ULL, 0x000fc4000001168eULL,
0x00000010ff927819ULL, 0x000fe40000011692ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x000010548b8a7816ULL, 0x000fe4000000008aULL, 0x000010547f7e7816ULL, 0x000fc4000000007eULL,
0x0000105480807816ULL, 0x000fe40000000081ULL, 0x0000105484797816ULL, 0x000fe40000000085ULL,
0x00001054837a7816ULL, 0x000fe4000000007aULL, 0x00001054897c7816ULL, 0x000fe4000000007cULL,
0x000010548f8b7816ULL, 0x000fe2000000008eULL, 0x00000078705c723cULL, 0x000f62000004185cULL,
0x00001054917f7816ULL, 0x000fc40000000092ULL, 0x0000105477817816ULL, 0x000fe40000000082ULL,
0xfffffff86a207812ULL, 0x020fc600078ec0ffULL, 0x0000007a7058723cULL, 0x040f700000041858ULL,
0x0000007c7054723cULL, 0x040f700000041854ULL, 0x0000008a7050723cULL, 0x040f700000041850ULL,
0x0000007e704c723cULL, 0x040f70000004184cULL, 0x000000807048723cULL, 0x000f700000041848ULL,
0x00000078243c723cULL, 0x040f70000004183cULL, 0x0000007a2438723cULL, 0x040f700000041838ULL,
0x0000007c2434723cULL, 0x040f700000041834ULL, 0x0000008a2430723cULL, 0x040f700000041830ULL,
0x0000007e242c723cULL, 0x040f70000004182cULL, 0x000000802428723cULL, 0x000b6e0000041828ULL,
0x000126c813267811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000026267f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126980020ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6a7224ULL, 0x000fc600078e00ffULL,
0x0000000000207805ULL, 0x004fc80000015200ULL, 0x000004000d257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x006fc40007804827ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00000024206b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e21ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011425ULL,
0x0000006b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x0000000224247819ULL, 0x000fc80000001225ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010f207810ULL, 0x000fc80007ffe0ffULL, 0x000000152000720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x000000020f207810ULL, 0x000fe40007ffe0ffULL,
0x000001000c217810ULL, 0x000fe40007ffe0ffULL, 0x000000152000720cULL, 0x000fc60003f06070ULL,
0x00006800126c7a24ULL, 0x000fd400078e0221ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x00000021160c7217ULL, 0x000fe20007800000ULL, 0x0000001011277824ULL, 0x000fe200078e00ffULL,
0x00000003ff257819ULL, 0x000fc60000011617ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a21ULL,
0x00000004256b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127207824ULL, 0x000fe200078e0225ULL,
0x0000000825717810ULL, 0x000fe40007ffe0ffULL, 0x0000000c270c7217ULL, 0x000fe20007800000ULL,
0x0000000120217824ULL, 0x040fe200078e0217ULL, 0x0000000c25737810ULL, 0x000fe20007ffe0ffULL,
0x0000000820247824ULL, 0x000fe400078e00ffULL, 0x0000000127707824ULL, 0x000fc400078e026bULL,
0x0000000120207824ULL, 0x100fe200078e026cULL, 0xfffffff8246d7812ULL, 0x000fe200078ee221ULL,
0x000000010c0c7824ULL, 0x000fe400078e0a27ULL, 0x0000000170247824ULL, 0x000fe400078e026cULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000000c2500720cULL, 0x080fe40003f06070ULL,
0x0000000c7100720cULL, 0x080fe20003f66070ULL, 0x0000000127727824ULL, 0x000fe200078e0271ULL,
0x0000000b206a7212ULL, 0x000fe200078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000000c6b00720cULL, 0x000fc40003f86070ULL, 0x000064006a6a7a10ULL, 0x000fe20007fbe0ffULL,
0x0000000172267824ULL, 0x100fe200078e026cULL, 0x0000000b24247212ULL, 0x080fe200078efcffULL,
0x0000000127777824ULL, 0x000fe200078e0273ULL, 0x00006500216b7a10ULL, 0x000fe20002ffe4ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000640024247a10ULL, 0x000fe40007fde0ffULL,
0x0000000c7300720cULL, 0x000fe20003fa6070ULL, 0x0000000177207824ULL, 0x000fe200078e026cULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x00000001706c7824ULL, 0x040fe200078e0217ULL,
0x0000650025257a10ULL, 0x000fe200037fe4ffULL, 0x0000000870717824ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007fde0ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee26cULL, 0x00000001720c7824ULL, 0x100fe200078e0217ULL,
0x0000000b20207212ULL, 0x000fe200078efcffULL, 0x0000000872737824ULL, 0x000fe200078e00ffULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x00000001776c7824ULL, 0x040fe200078e0217ULL,
0x0000640020207a10ULL, 0x000fe20007fde0ffULL, 0x0000000877777824ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee20cULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x0000650021217a10ULL, 0x000fe200037fe4ffULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0xfffffff877777812ULL, 0x000fe200078ee26cULL, 0x0000001073737824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a6d7faeULL, 0x0003e6000c101c46ULL,
0x0000001077777824ULL, 0x000fe200078e0200ULL, 0x0000000024717faeULL, 0x0003e8000e101c46ULL,
0x0000000026737faeULL, 0x0003e8000d901c46ULL, 0x0000000020777faeULL, 0x0003e2000e901c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x00000010110c7824ULL, 0x000fca00078e00ffULL,
0x0000000c170c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c247810ULL, 0x040fe20007ffe0ffULL,
0x000000010c207824ULL, 0x140fe200078e0217ULL, 0x000000080c267810ULL, 0x040fe20007ffe0ffULL,
0x000000080c6d7824ULL, 0x000fe400078e00ffULL, 0x0000000124217824ULL, 0x140fe400078e0217ULL,
0x00000008246a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee220ULL,
0x000000010c207824ULL, 0x040fe200078e026cULL, 0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000126257824ULL, 0x000fe200078e0217ULL, 0xfffffff86a717812ULL, 0x000fe200078ee221ULL,
0x0000000826707824ULL, 0x000fc400078e00ffULL, 0x0000000124247824ULL, 0x000fe400078e026cULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0xfffffff870737812ULL, 0x000fc600078ee225ULL,
0x0000000126267824ULL, 0x100fe200078e026cULL, 0x0000000b20207212ULL, 0x000fe200078efcffULL,
0x000000010c6a7824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000640020207a10ULL, 0x000fc60007f1e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000b24247212ULL, 0x080fe400078efcffULL, 0x0000650021217a10ULL, 0x000fe200007fe4ffULL,
0x000000806a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000640024247a10ULL, 0x000fe20007f7e0ffULL, 0x000000010c6c7824ULL, 0x000fe200078e0217ULL,
0x0000000b6a6a7212ULL, 0x000fe200078efcffULL, 0x000000080c777824ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007f1e0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0200ULL,
0x000064006a6a7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001071717824ULL, 0x000fe200078e0200ULL,
0xfffffff877777812ULL, 0x000fe200078ee26cULL, 0x0000001073737824ULL, 0x100fe200078e0200ULL,
0x0000650025257a10ULL, 0x000fe20001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000206d7faeULL, 0x0003e2000b901c46ULL, 0x0000650027277a10ULL, 0x000fe200007fe4ffULL,
0x0000001077777824ULL, 0x000fe200078e0200ULL, 0x000065006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000024717faeULL, 0x0003e8000b901c46ULL, 0x0000000026737faeULL, 0x0003e8000b901c46ULL,
0x000000006a777faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000814217812ULL, 0x000fe200078ec0ffULL, 0x00000020100c7824ULL, 0x000fc400078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x00000001210c7824ULL, 0x000fe200078e020cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000086c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x012668000c267f8cULL, 0x000664000c80043fULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x01266c000c257984ULL, 0x000f240000000800ULL, 0x8000000025ff7812ULL, 0x012fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00000024206b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e21ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011425ULL,
0x0000006b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x0000000208087819ULL, 0x000fc80000001225ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01266c000c257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018010087811ULL, 0x000fc800078e38ffULL, 0x000000080a087210ULL, 0x000fca0007ffe00bULL,
0x01200000080c7984ULL, 0x008e680000000800ULL, 0x0122000008207984ULL, 0x0006a20000000800ULL,
0x000000230c00720bULL, 0x002fe20003f1d000ULL, 0x0000d6127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000217806ULL, 0x008fc800000e0100ULL, 0x000000ff2100720cULL, 0x000fe20003f05270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fd200078e0023ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x0000000310257810ULL, 0x000fe40007ffe0ffULL, 0x000000230c00720bULL, 0x000fe40003f74000ULL,
0x0000001a2500720cULL, 0x000fe20003f05270ULL, 0x0000d5c27f007947ULL, 0x000fd4000b800000ULL,
0x00000000006c7806ULL, 0x004fc400018e0100ULL, 0x000000801a0b8824ULL, 0x000fe200078e020bULL,
0x000000230c087209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a0b8824ULL, 0x000fca00078e020bULL, 0x012400080b008388ULL, 0x0003e20000000800ULL,
0x000000ff6c00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x00000023080a7221ULL, 0x002fe20000010100ULL, 0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a00277308ULL, 0x000e640000000800ULL, 0x0000002722227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x0000d5027f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002a400000e0000ULL,
0x0000002664647220ULL, 0x084fe20000410000ULL, 0x0000002665657220ULL, 0x080fe20000410000ULL,
0x0000002660607220ULL, 0x080fe20000410000ULL, 0x0000002661617220ULL, 0x080fe20000410000ULL,
0x000000265c5c7220ULL, 0x080fe20000410000ULL, 0x000000265d5d7220ULL, 0x080fe20000410000ULL,
0x0000002658587220ULL, 0x080fe20000410000ULL, 0x0000002659597220ULL, 0x080fe20000410000ULL,
0x0000002654547220ULL, 0x080fe20000410000ULL, 0x0000002655557220ULL, 0x080fe20000410000ULL,
0x0000002650507220ULL, 0x080fe20000410000ULL, 0x0000002651517220ULL, 0x080fe20000410000ULL,
0x000000264c4c7220ULL, 0x080fe20000410000ULL, 0x000000264d4d7220ULL, 0x080fe20000410000ULL,
0x0000002648487220ULL, 0x080fe20000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x0000d3c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002666667220ULL, 0x08cfe20000410000ULL,
0x0000002667677220ULL, 0x080fe20000410000ULL, 0x0000002662627220ULL, 0x080fe20000410000ULL,
0x0000002663637220ULL, 0x080fe20000410000ULL, 0x000000265e5e7220ULL, 0x080fe20000410000ULL,
0x000000265f5f7220ULL, 0x080fe20000410000ULL, 0x000000265a5a7220ULL, 0x080fe20000410000ULL,
0x000000265b5b7220ULL, 0x080fe20000410000ULL, 0x0000002656567220ULL, 0x080fe20000410000ULL,
0x0000002657577220ULL, 0x080fe20000410000ULL, 0x0000002652527220ULL, 0x080fe20000410000ULL,
0x0000002653537220ULL, 0x080fe20000410000ULL, 0x000000264e4e7220ULL, 0x080fe20000410000ULL,
0x000000264f4f7220ULL, 0x080fe20000410000ULL, 0x000000264a4a7220ULL, 0x080fe20000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x0000d2827f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe20000410000ULL, 0x0000002645457220ULL, 0x080fe20000410000ULL,
0x0000002640407220ULL, 0x080fe20000410000ULL, 0x0000002641417220ULL, 0x080fe20000410000ULL,
0x000000263c3c7220ULL, 0x080fe20000410000ULL, 0x000000263d3d7220ULL, 0x080fe20000410000ULL,
0x0000002638387220ULL, 0x080fe20000410000ULL, 0x0000002639397220ULL, 0x080fe20000410000ULL,
0x0000002634347220ULL, 0x080fe20000410000ULL, 0x0000002635357220ULL, 0x080fe20000410000ULL,
0x0000002630307220ULL, 0x080fe20000410000ULL, 0x0000002631317220ULL, 0x080fe20000410000ULL,
0x000000262c2c7220ULL, 0x080fe20000410000ULL, 0x000000262d2d7220ULL, 0x080fe20000410000ULL,
0x0000002628287220ULL, 0x080fe20000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x0000d1527f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe20000410000ULL, 0x0000002647477220ULL, 0x080fe20000410000ULL,
0x0000002642427220ULL, 0x080fe20000410000ULL, 0x0000002643437220ULL, 0x080fe20000410000ULL,
0x000000263e3e7220ULL, 0x080fe20000410000ULL, 0x000000263f3f7220ULL, 0x080fe20000410000ULL,
0x000000263a3a7220ULL, 0x080fe20000410000ULL, 0x000000263b3b7220ULL, 0x080fe20000410000ULL,
0x0000002636367220ULL, 0x080fe20000410000ULL, 0x0000002637377220ULL, 0x080fe20000410000ULL,
0x0000002632327220ULL, 0x080fe20000410000ULL, 0x0000002633337220ULL, 0x080fe20000410000ULL,
0x000000262e2e7220ULL, 0x080fe20000410000ULL, 0x000000262f2f7220ULL, 0x080fe20000410000ULL,
0x000000262a2a7220ULL, 0x080fe20000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006c21ff7212ULL, 0x000fda00078030ffULL,
0x0000000c080c0221ULL, 0x000fe20000010100ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL, 0x0000000c00090308ULL, 0x000e640000000800ULL,
0x0000000920200220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002220227221ULL, 0x004fc20000010000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0xfffffff014267812ULL, 0x000fca00078ec0ffULL, 0x0126b40026217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000200a237210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e0bULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011421ULL, 0x000000230c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x000000020c0c7819ULL, 0x000fc80000001221ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b40026217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910240a7816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff0a7819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x0000cd227f007947ULL, 0x000fea000b800000ULL, 0x00001f0a27077589ULL, 0x0002a400000e0000ULL,
0x000000080a267810ULL, 0x000fe20007ffe0ffULL, 0x0000cd427f007947ULL, 0x000fea000b800000ULL,
0x000000100a047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x000000180a267810ULL, 0x008fe20007ffe0ffULL,
0x0000cd727f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001130a7812ULL, 0x002fe200078ec0ffULL,
0x0000000803207824ULL, 0x000fe200078e00ffULL, 0x00000004ff0b7819ULL, 0x000fe20000011617ULL,
0x0000000802217824ULL, 0x000fe200078e00ffULL, 0x0000100000007810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x000000040a0a7824ULL, 0x000fc400078e020bULL, 0x000000101c707824ULL, 0x000fe400078e0200ULL,
0x00000001030b7824ULL, 0x100fe400078e020aULL, 0x00000001020c7824ULL, 0x000fc600078e020aULL,
0xfffffff8200a7812ULL, 0x000fe200078ee20bULL, 0x000000041a207824ULL, 0x000fe200078e00ffULL,
0x0000d000100b7811ULL, 0x000fe400078e60ffULL, 0xfffffff8210c7812ULL, 0x000fe400078ee20cULL,
0x0000000420207812ULL, 0x000fe200078ec0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e020bULL,
0x000000100c0c7824ULL, 0x000fe200078e020bULL, 0x00000002201c7812ULL, 0x000fc400078efcffULL,
0x000000000a68783bULL, 0x0002e80000000200ULL, 0x000000000c24783bULL, 0x0082e20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000768687231ULL, 0x084fe400003400ffULL,
0x000000076a6a7231ULL, 0x000fe400003400ffULL, 0x0000000669697231ULL, 0x080fe400003400ffULL,
0x000000066b6b7231ULL, 0x000fc400003400ffULL, 0x0000000524247231ULL, 0x088fe400003400ffULL,
0x0000000526267231ULL, 0x000fe400003400ffULL, 0x0000000425257231ULL, 0x080fe400003400ffULL,
0x0000000427277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001c170a7211ULL, 0x002fe200078fe0ffULL, 0x00000008030c7824ULL, 0x040fe200078e00ffULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x000000101e1e7824ULL, 0x000fe200078e020bULL,
0x00000c3000007945ULL, 0x000fe20003800000ULL, 0x0000000103037824ULL, 0x000fca00078e020aULL,
0xfffffff80c037812ULL, 0x000fca00078ee203ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000374783bULL, 0x0003240000004200ULL, 0x00000018ff037819ULL, 0x002fe40000011672ULL,
0x000000ff71217812ULL, 0x000fe400078ec0ffULL, 0x00000018ff1c7819ULL, 0x000fe40000011670ULL,
0x00000010ff237819ULL, 0x100fe40000011671ULL, 0x00000018ff6c7819ULL, 0x000fc40000011671ULL,
0x0000ffff718b7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff03723eULL, 0x000fe400020006ffULL,
0x00000010ff717819ULL, 0x000fe40000011672ULL, 0x000000ff72787812ULL, 0x040fe400078ec0ffULL,
0x0000ffff728c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff797819ULL, 0x000fc40000011673ULL,
0x000000ff737a7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff727819ULL, 0x000fe40000011673ULL,
0x0000ffff738d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff76807812ULL, 0x010fe400078ec0ffULL,
0x00000021ff21723eULL, 0x000fe400020006ffULL, 0x00000010ff7c7819ULL, 0x000fc40000011674ULL,
0x000000ff747d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe40000011674ULL,
0x0000ffff748e7812ULL, 0x000fe400078ec0ffULL, 0x0000001cff1c723eULL, 0x000fe400020006ffULL,
0x00000010ff7e7819ULL, 0x000fe40000011675ULL, 0x000000ff757f7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff747819ULL, 0x000fe40000011675ULL, 0x0000ffff758f7812ULL, 0x000fe200078ec0ffULL,
0x20000003ff757230ULL, 0x000fe20000004100ULL, 0x00000080ff03723eULL, 0x000fe400020006ffULL,
0x00000010ff0c7819ULL, 0x000fe40000011670ULL, 0x000000ff70207812ULL, 0x040fe200078ec0ffULL,
0x20000003ff847230ULL, 0x000fe20000004100ULL, 0x0000ffff708a7812ULL, 0x000fe200078ec0ffULL,
0x20000021ff707230ULL, 0x000fe20000004100ULL, 0x000000ff23237812ULL, 0x000fe200078ec0ffULL,
0x2000001cff217230ULL, 0x000fe20000004100ULL, 0x00000072ff1c723eULL, 0x000fc400020006ffULL,
0x00000008ff037819ULL, 0x000fe4000001168aULL, 0x0000006cff6c723eULL, 0x000fe200020006ffULL,
0x2000001cff7b7230ULL, 0x000fe20000004100ULL, 0x00000023ff23723eULL, 0x000fe400020006ffULL,
0x00000008ff1c7819ULL, 0x000fe2000001168bULL, 0x2000006cff727230ULL, 0x000fe20000004100ULL,
0x00000003ff03723eULL, 0x000fe200020006ffULL, 0x20000023ff6c7230ULL, 0x000fe20000004100ULL,
0x00000018ff817819ULL, 0x000fc40000011676ULL, 0x00000010ff827819ULL, 0x000fe40000011676ULL,
0x0000ffff76907812ULL, 0x000fe400078ec0ffULL, 0x0000001cff23723eULL, 0x000fe200020006ffULL,
0x20000003ff1c7230ULL, 0x000fe20000004100ULL, 0x00000018ff767819ULL, 0x000fe40000011677ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x00000008ff037819ULL, 0x000fc4000001168dULL,
0x000000ff0c0c7812ULL, 0x000fe200078ec0ffULL, 0x20000081ff867230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe400020006ffULL, 0x000000ff77857812ULL, 0x000fe400078ec0ffULL,
0x00000003ff03723eULL, 0x000fe200020006ffULL, 0x20000076ff897230ULL, 0x000fe20000004100ULL,
0x00000020ff20723eULL, 0x000fe400020006ffULL, 0x0000000cff0c723eULL, 0x000fe200020006ffULL,
0x20000003ff767230ULL, 0x000fe20000004100ULL, 0x00000008ff817819ULL, 0x000fe2000001168fULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x00000085ff85723eULL, 0x000fe200020006ffULL,
0x2000000cff0c7230ULL, 0x000fe20000004100ULL, 0x00000081ff03723eULL, 0x000fc400020006ffULL,
0x0000007fff7f723eULL, 0x000fe200020006ffULL, 0x20000085ff887230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe400020006ffULL, 0x00000074ff74723eULL, 0x000fe200020006ffULL,
0x2000007fff807230ULL, 0x000fe20000004100ULL, 0x000000ff71717812ULL, 0x000fe200078ec0ffULL,
0x20000073ff7f7230ULL, 0x000fe20000004100ULL, 0x000000ff82857812ULL, 0x000fe200078ec0ffULL,
0x20000003ff827230ULL, 0x000fe20000004100ULL, 0x00000010ff877819ULL, 0x000fe20000011677ULL,
0x20000074ff837230ULL, 0x000fe20000004100ULL, 0x00000010ff207819ULL, 0x000fc40000011620ULL,
0x00000010ff037819ULL, 0x000fe4000001160cULL, 0x0000ffff77777812ULL, 0x000fe400078ec0ffULL,
0x00000071ff73723eULL, 0x000fe200020006ffULL, 0x20000023ff717230ULL, 0x000fe20000004100ULL,
0x000000ff7e7e7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff747819ULL, 0x000fe2000001168cULL,
0x20000073ff737230ULL, 0x000fe20000004100ULL, 0x000000ff7c7c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff237819ULL, 0x000fe4000001168eULL, 0x0000105403207816ULL, 0x000fe40000000020ULL,
0x000000ff87877812ULL, 0x000fe400078ec0ffULL, 0x000000ff79797812ULL, 0x000fe400078ec0ffULL,
0x00000008ff037819ULL, 0x000fe40000011690ULL, 0x00000008ff777819ULL, 0x000fc40000011677ULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000078ff78723eULL, 0x000fe200020006ffULL, 0x2000007eff817230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe200020006ffULL, 0x20000085ff857230ULL, 0x000fe20000004100ULL,
0x00000074ff74723eULL, 0x000fe200020006ffULL, 0x20000078ff787230ULL, 0x000fe20000004100ULL,
0x0000007cff7c723eULL, 0x000fe200020006ffULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000023ff23723eULL, 0x000fe200020006ffULL, 0x20000074ff747230ULL, 0x000fe20000004100ULL,
0x00000087ff87723eULL, 0x000fe200020006ffULL, 0x2000007cff7c7230ULL, 0x000fe20000004100ULL,
0x0000007aff7a723eULL, 0x000fe200020006ffULL, 0x20000023ff7e7230ULL, 0x000fe20000004100ULL,
0x00000079ff79723eULL, 0x000fe200020006ffULL, 0x20000087ff877230ULL, 0x000fe20000004100ULL,
0x00000003ff03723eULL, 0x000fe200020006ffULL, 0x2000007aff7a7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x20000079ff797230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fe20000011621ULL, 0x20000003ff037230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff717819ULL, 0x000fc40000011671ULL, 0x00000010ff847819ULL, 0x000fe40000011684ULL,
0x00000010ff857819ULL, 0x000fe40000011685ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff217819ULL, 0x000fe4000001166cULL, 0x00000010ff787819ULL, 0x000fe40000011678ULL,
0x00000010ff737819ULL, 0x000fc40000011673ULL, 0x00000010ff757819ULL, 0x000fe40000011675ULL,
0x00000010ff747819ULL, 0x000fe40000011674ULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff7f7819ULL, 0x000fe4000001167fULL,
0x00000010ff7e7819ULL, 0x000fc4000001167eULL, 0x00000010ff887819ULL, 0x000fe40000011688ULL,
0x00000010ff877819ULL, 0x000fe40000011687ULL, 0x00000010ff1c7819ULL, 0x000fe4000001161cULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff7b7819ULL, 0x000fc4000001167bULL, 0x00000010ff767819ULL, 0x000fe40000011676ULL,
0x00000010ff807819ULL, 0x000fe40000011680ULL, 0x00000010ff817819ULL, 0x000fe40000011681ULL,
0x00000010ff837819ULL, 0x000fe40000011683ULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x00000010ff867819ULL, 0x000fc40000011686ULL, 0x00000010ff037819ULL, 0x000fe40000011603ULL,
0x00000010ff0c7819ULL, 0x000fe40000011689ULL, 0x00000010ff777819ULL, 0x000fe40000011677ULL,
0x0000105472717816ULL, 0x000fe40000000071ULL, 0x0000105485847816ULL, 0x000fe40000000084ULL,
0x0000105421217816ULL, 0x000fc40000000070ULL, 0x0000105473727816ULL, 0x000fe40000000078ULL,
0x0000105475747816ULL, 0x000fe40000000074ULL, 0x000010547c7c7816ULL, 0x000fe2000000007dULL,
0x000000206864723cULL, 0x000f620000041864ULL, 0x000010547f7e7816ULL, 0x000fe4000000007eULL,
0x0000105487857816ULL, 0x000fe40000000088ULL, 0x0000105423707816ULL, 0x000fc4000000001cULL,
0x0000105479737816ULL, 0x000fe2000000007aULL, 0x000000202444723cULL, 0x008f620000041844ULL,
0x000010547b757816ULL, 0x000fe40000000076ULL, 0x00001054817d7816ULL, 0x000fe40000000080ULL,
0x00001054837f7816ULL, 0x000fe40000000082ULL, 0x0000105486867816ULL, 0x000fe20000000003ULL,
0x000000101d037824ULL, 0x000fe200078e020bULL, 0x000010540c877816ULL, 0x000fe20000000077ULL,
0x000000706860723cULL, 0x040f700000041860ULL, 0x00000072685c723cULL, 0x040f70000004185cULL,
0x000000746858723cULL, 0x040f700000041858ULL, 0x0000007c6854723cULL, 0x040f700000041854ULL,
0x0000007e6850723cULL, 0x040f700000041850ULL, 0x00000084684c723cULL, 0x040f70000004184cULL,
0x000000866848723cULL, 0x000b6e0000041848ULL, 0x000000101f687824ULL, 0x020fe200078e0200ULL,
0x000000702440723cULL, 0x040f620000041840ULL, 0x000000001e1c783bULL, 0x000e6e0000000200ULL,
0x00000072243c723cULL, 0x040f70000004183cULL, 0x000000742438723cULL, 0x040f700000041838ULL,
0x0000007c2434723cULL, 0x040f700000041834ULL, 0x0000007e2430723cULL, 0x040f700000041830ULL,
0x00000084242c723cULL, 0x040f70000004182cULL, 0x000000862428723cULL, 0x000b640000041828ULL,
0x000000000324783bULL, 0x0206a20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000724247231ULL, 0x086fe400003400ffULL,
0x0000000726267231ULL, 0x000fc400003400ffULL, 0x0000000625257231ULL, 0x080fe400003400ffULL,
0x0000000627277231ULL, 0x000fe400003400ffULL, 0x000000051c1c7231ULL, 0x080fe400003400ffULL,
0x000000051e1e7231ULL, 0x000fe400003400ffULL, 0x000000041d1d7231ULL, 0x080fe400003400ffULL,
0x000000041f1f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000000802037824ULL, 0x048fe200078e00ffULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x0000000102027824ULL, 0x000fca00078e020aULL, 0xfffffff803037812ULL, 0x000fca00078ee202ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000370783bULL, 0x0007220000004200ULL,
0x00000018ff027819ULL, 0x102fe40000011668ULL, 0x00000010ff007819ULL, 0x000fe40000011668ULL,
0x000000ff680a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff68837812ULL, 0x000fe400078ec0ffULL,
0x00000002ff02723eULL, 0x000fe400020006ffULL, 0x00000010ff237819ULL, 0x000fc4000001166aULL,
0x000000ff6a687812ULL, 0x040fe200078ec0ffULL, 0x20000002ff037230ULL, 0x008fe20000004100ULL,
0x00000018ff217819ULL, 0x000fe4000001166aULL, 0x0000ffff6a857812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b6a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff0c7819ULL, 0x000fe40000011669ULL,
0x0000006aff02723eULL, 0x000fc400020006ffULL, 0x00000018ff787819ULL, 0x010fe40000011671ULL,
0x00000010ff0b7819ULL, 0x000fe40000011669ULL, 0x000000ff69207812ULL, 0x040fe400078ec0ffULL,
0x0000ffff69847812ULL, 0x000fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe4000001166bULL,
0x00000010ff797819ULL, 0x000fc40000011671ULL, 0x000000ff717a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff71887812ULL, 0x000fe200078ec0ffULL, 0x20000002ff717230ULL, 0x000fe20000004100ULL,
0x0000000cff0c723eULL, 0x000fe400020006ffULL, 0x000000ff727c7812ULL, 0x000fe400078ec0ffULL,
0x00000078ff02723eULL, 0x000fe400020006ffULL, 0x00000010ff6c7819ULL, 0x000fc4000001166bULL,
0x0000ffff6b867812ULL, 0x000fe400078ec0ffULL, 0x000000ff73807812ULL, 0x000fe400078ec0ffULL,
0x00000069ff6b723eULL, 0x000fe200020006ffULL, 0x2000000cff697230ULL, 0x000fe20000004100ULL,
0x0000007cff0c723eULL, 0x000fe200020006ffULL, 0x20000002ff7c7230ULL, 0x000fe20000004100ULL,
0x00000080ff02723eULL, 0x000fe200020006ffULL, 0x2000006bff747230ULL, 0x000fe20000004100ULL,
0x00000021ff21723eULL, 0x000fe200020006ffULL, 0x2000000cff7e7230ULL, 0x000fe20000004100ULL,
0x00000010ff757819ULL, 0x000fe20000011670ULL, 0x20000002ff817230ULL, 0x000fe20000004100ULL,
0x000000ff70777812ULL, 0x000fc400078ec0ffULL, 0x00000018ff767819ULL, 0x000fe40000011670ULL,
0x0000ffff70877812ULL, 0x000fe200078ec0ffULL, 0x20000021ff707230ULL, 0x000fe20000004100ULL,
0x000000ff0b0b7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff027819ULL, 0x000fe40000011683ULL,
0x00000008ff217819ULL, 0x000fe40000011684ULL, 0x00000010ff7b7819ULL, 0x000fc40000011672ULL,
0x00000018ff7d7819ULL, 0x000fe40000011672ULL, 0x0000ffff72897812ULL, 0x000fe400078ec0ffULL,
0x0000000bff0b723eULL, 0x000fe400020006ffULL, 0x00000018ff727819ULL, 0x000fe40000011673ULL,
0x00000068ff68723eULL, 0x000fe200020006ffULL, 0x2000000bff0c7230ULL, 0x000fe20000004100ULL,
0x00000002ff02723eULL, 0x000fc400020006ffULL, 0x00000021ff21723eULL, 0x000fe200020006ffULL,
0x20000068ff6a7230ULL, 0x000fe20000004100ULL, 0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL,
0x20000002ff0b7230ULL, 0x000fe20000004100ULL, 0x00000008ff6b7819ULL, 0x000fe20000011685ULL,
0x20000021ff687230ULL, 0x000fe20000004100ULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006bff02723eULL, 0x000fe200020006ffULL,
0x20000072ff827230ULL, 0x000fe20000004100ULL, 0x000000ff23237812ULL, 0x000fe200078ec0ffULL,
0x2000006cff727230ULL, 0x000fe20000004100ULL, 0x00000008ff217819ULL, 0x000fe20000011686ULL,
0x20000002ff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff00007812ULL, 0x000fc400078ec0ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x00000021ff21723eULL, 0x000fe400020006ffULL,
0x0000000aff0a723eULL, 0x000fe200020006ffULL, 0x20000023ff6b7230ULL, 0x000fe20000004100ULL,
0x00000008ff027819ULL, 0x000fe40000011687ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x2000000aff0a7230ULL, 0x000fe20000004100ULL, 0x00000010ff7f7819ULL, 0x000fc40000011673ULL,
0x0000ffff738a7812ULL, 0x000fe200078ec0ffULL, 0x20000021ff737230ULL, 0x000fe20000004100ULL,
0x00000076ff76723eULL, 0x000fe200020006ffULL, 0x20000000ff007230ULL, 0x000fe20000004100ULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000002ff02723eULL, 0x000fe200020006ffULL,
0x20000076ff787230ULL, 0x000fe20000004100ULL, 0x00000020ff20723eULL, 0x000fe200020006ffULL,
0x2000007dff807230ULL, 0x000fe20000004100ULL, 0x00000008ff237819ULL, 0x000fe20000011688ULL,
0x20000002ff767230ULL, 0x000fe20000004100ULL, 0x000000ff7b217812ULL, 0x000fe200078ec0ffULL,
0x20000020ff207230ULL, 0x000fe20000004100ULL, 0x000000ff75757812ULL, 0x000fc400078ec0ffULL,
0x00000023ff23723eULL, 0x000fe400020006ffULL, 0x00000021ff7d723eULL, 0x000fe400020006ffULL,
0x00000010ff027819ULL, 0x000fe2000001160aULL, 0x20000023ff7b7230ULL, 0x000fe20000004100ULL,
0x00000010ff217819ULL, 0x000fe20000011603ULL, 0x2000007dff7d7230ULL, 0x000fe20000004100ULL,
0x00000010ff037819ULL, 0x000fe40000011600ULL, 0x00000010ff0a7819ULL, 0x000fc4000001160bULL,
0x00000010ff007819ULL, 0x000fe40000011669ULL, 0x00000010ff0b7819ULL, 0x000fe40000011668ULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x00000075ff75723eULL, 0x000fe400020006ffULL,
0x00000010ff207819ULL, 0x000fe20000011620ULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff237819ULL, 0x000fe2000001160cULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00001054000b7816ULL, 0x000fc4000000000bULL, 0x00000008ff007819ULL, 0x000fe40000011689ULL,
0x0000105403027816ULL, 0x000fe40000000002ULL, 0x0000105423037816ULL, 0x000fe40000000020ULL,
0x00000010ff207819ULL, 0x000fe4000001166aULL, 0x00000000ff6a723eULL, 0x000fe400020006ffULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x000000022464723cULL, 0x004b620000041864ULL,
0x00000010ff007819ULL, 0x000fc40000011675ULL, 0x00000010ff687819ULL, 0x000fe2000001166cULL,
0x2000006aff6c7230ULL, 0x000fe20000004100ULL, 0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL,
0x00001054006a7816ULL, 0x000fe20000000077ULL, 0x000000021c44723cULL, 0x000b620000041844ULL,
0x000000ff79797812ULL, 0x000fe400078ec0ffULL, 0x00000008ff007819ULL, 0x000fe4000001168aULL,
0x0000007fff7f723eULL, 0x000fc400020006ffULL, 0x0000007aff7a723eULL, 0x000fe400020006ffULL,
0x00000079ff79723eULL, 0x000fe400020006ffULL, 0x00000010ff237819ULL, 0x000fe20000011670ULL,
0x2000007fff707230ULL, 0x000fe20000004100ULL, 0x00000000ff00723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x0000105423687816ULL, 0x000fe20000000068ULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x20000000ff007230ULL, 0x000fe20000004100ULL, 0x00000010ff237819ULL, 0x000fc40000011678ULL,
0x00000010ff767819ULL, 0x000fe40000011676ULL, 0x00001054210a7816ULL, 0x000fe4000000000aULL,
0x00000010ff217819ULL, 0x000fe40000011671ULL, 0x000010546b207816ULL, 0x000fe40000000020ULL,
0x0000105423767816ULL, 0x000fe20000000076ULL, 0x0000000a2460723cULL, 0x000b620000041860ULL,
0x00000010ff7f7819ULL, 0x000fc40000011681ULL, 0x00000010ff707819ULL, 0x000fe40000011670ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000010ff747819ULL, 0x000fe20000011674ULL,
0x0000000a1c40723cULL, 0x000b620000041840ULL, 0x00000010ff697819ULL, 0x000fe40000011673ULL,
0x00000010ff6b7819ULL, 0x000fe4000001167aULL, 0x00000010ff0c7819ULL, 0x000fc40000011679ULL,
0x00000010ff7c7819ULL, 0x000fe4000001167cULL, 0x00000010ff777819ULL, 0x000fe4000001167bULL,
0x00000010ff7e7819ULL, 0x000fe4000001167eULL, 0x00000010ff7d7819ULL, 0x000fe4000001167dULL,
0x00000010ff237819ULL, 0x000fe40000011680ULL, 0x00000010ff6c7819ULL, 0x000fc4000001166cULL,
0x00000010ff717819ULL, 0x000fe40000011682ULL, 0x00000010ff007819ULL, 0x000fe40000011600ULL,
0x00001054707f7816ULL, 0x000fe4000000007fULL, 0x0000105472217816ULL, 0x000fe40000000021ULL,
0x0000105474697816ULL, 0x000fe40000000069ULL, 0x000010540c6b7816ULL, 0x000fc4000000006bULL,
0x000010547c777816ULL, 0x000fe20000000077ULL, 0x00000020245c723cULL, 0x000b62000004185cULL,
0x000010547d7e7816ULL, 0x000fe4000000007eULL, 0x0000105423707816ULL, 0x000fe4000000006cULL,
0x0000105471717816ULL, 0x000fc60000000000ULL, 0x000000682458723cULL, 0x040b700000041858ULL,
0x0000006a2454723cULL, 0x040b700000041854ULL, 0x000000762450723cULL, 0x040b700000041850ULL,
0x0000007e244c723cULL, 0x040b70000004184cULL, 0x000000702448723cULL, 0x000b700000041848ULL,
0x000000201c3c723cULL, 0x040b70000004183cULL, 0x000000681c38723cULL, 0x040b700000041838ULL,
0x0000006a1c34723cULL, 0x040b700000041834ULL, 0x000000761c30723cULL, 0x040b700000041830ULL,
0x0000007e1c2c723cULL, 0x040b70000004182cULL, 0x000000701c28723cULL, 0x000b620000041828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x000000000d027f8cULL, 0x0202a2000c80043fULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x000126a0100a7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x004fe200078e0003ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff313000007947ULL, 0x000fea000383ffffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff237224ULL, 0x000fe400078e002bULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff217224ULL, 0x000fe400078e002fULL, 0x000000ffff207224ULL, 0x000fc400078e002eULL,
0x000000ffff1f7224ULL, 0x000fe400078e0033ULL, 0x000000ffff147224ULL, 0x000fe400078e0032ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000eba000047802ULL, 0x000fc40000000f00ULL, 0x0000b4a000007944ULL, 0x00efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000087919ULL, 0x000ee80000000000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000001808057811ULL, 0x048fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x010fca0000410000ULL,
0x00001f0706007589ULL, 0x000ea800000e0000ULL, 0x00001f0506057589ULL, 0x000ee800000e0000ULL,
0x00001f0906047589ULL, 0x000f2800000e0000ULL, 0x00001f0b06027589ULL, 0x000e6200000e0000ULL,
0x0000006400647220ULL, 0x044fe20000410000ULL, 0x0000006500657220ULL, 0x040fe20000410000ULL,
0x0000006000607220ULL, 0x040fe20000410000ULL, 0x0000006100617220ULL, 0x040fe20000410000ULL,
0x0000005c005c7220ULL, 0x040fe20000410000ULL, 0x0000005d005d7220ULL, 0x040fe20000410000ULL,
0x0000005800587220ULL, 0x040fe20000410000ULL, 0x0000005900597220ULL, 0x040fe20000410000ULL,
0x0000005400547220ULL, 0x040fe20000410000ULL, 0x0000005500557220ULL, 0x040fe20000410000ULL,
0x0000005000507220ULL, 0x040fe20000410000ULL, 0x0000005100517220ULL, 0x040fe20000410000ULL,
0x0000004c004c7220ULL, 0x040fe20000410000ULL, 0x0000004d004d7220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004605467220ULL, 0x048fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x000fe20000410000ULL,
0x0000000466667220ULL, 0x090fe20000410000ULL, 0x0000000467677220ULL, 0x080fe20000410000ULL,
0x0000000462627220ULL, 0x080fe20000410000ULL, 0x0000000463637220ULL, 0x080fe20000410000ULL,
0x000000045e5e7220ULL, 0x080fe20000410000ULL, 0x000000045f5f7220ULL, 0x080fe20000410000ULL,
0x000000045a5a7220ULL, 0x080fe20000410000ULL, 0x000000045b5b7220ULL, 0x080fe20000410000ULL,
0x0000000456567220ULL, 0x080fe20000410000ULL, 0x0000000457577220ULL, 0x080fe20000410000ULL,
0x0000000452527220ULL, 0x080fe20000410000ULL, 0x0000000453537220ULL, 0x080fe20000410000ULL,
0x000000044e4e7220ULL, 0x080fe20000410000ULL, 0x000000044f4f7220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x0000000244447220ULL, 0x082fe20000410000ULL, 0x0000000245457220ULL, 0x080fe20000410000ULL,
0x0000000240407220ULL, 0x080fe20000410000ULL, 0x0000000241417220ULL, 0x080fe20000410000ULL,
0x000000023c3c7220ULL, 0x080fe20000410000ULL, 0x000000023d3d7220ULL, 0x080fe20000410000ULL,
0x0000000238387220ULL, 0x080fe20000410000ULL, 0x0000000239397220ULL, 0x080fe20000410000ULL,
0x0000000234347220ULL, 0x080fe20000410000ULL, 0x0000000235357220ULL, 0x080fe20000410000ULL,
0x0000000230307220ULL, 0x080fe20000410000ULL, 0x0000000231317220ULL, 0x080fe20000410000ULL,
0x000000022c2c7220ULL, 0x080fe20000410000ULL, 0x000000022d2d7220ULL, 0x080fe20000410000ULL,
0x0000000228287220ULL, 0x080fe20000410000ULL, 0x0000000229297220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000f220000000000ULL, 0x000000666766723eULL, 0x000fc400000010ffULL,
0x000000626333723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000005e5f5e723eULL, 0x000fe400000010ffULL, 0x0000005a5b2f723eULL, 0x000fe400000010ffULL,
0x000000565756723eULL, 0x000fc400000010ffULL, 0x00000052532b723eULL, 0x000fe400000010ffULL,
0x0000004e4f4e723eULL, 0x000fe400000010ffULL, 0x0000004a4b27723eULL, 0x000fe400000010ffULL,
0x0000541066327816ULL, 0x000fe40000000033ULL, 0x0000000800037811ULL, 0x054fe200078ff0ffULL,
0x000000016f6f7824ULL, 0x000fe200078e0200ULL, 0x0000000200027812ULL, 0x000fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x00000008030d7824ULL, 0x002fe200078e00ffULL,
0x0000001000097811ULL, 0x040fe400078ff0ffULL, 0x00000018000b7811ULL, 0x000fe200078ff0ffULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0x0000000302047211ULL, 0x040fe200078ff8ffULL,
0x0000000809107824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x040fe400078ff8ffULL,
0x0000000b02067211ULL, 0x040fe200078ff8ffULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80d0e7812ULL, 0x000fe200078ee204ULL,
0x0000000807047824ULL, 0x000fe200078e00ffULL, 0xfffffff80b127812ULL, 0x000fe400078ee206ULL,
0xfffffff809087812ULL, 0x000fe200078ee202ULL, 0x0000200011027824ULL, 0x000fe200078e00ffULL,
0x0000000403067810ULL, 0x040fe40007ffe0ffULL, 0x0000000603077810ULL, 0x000fe20007ffe0ffULL,
0x000000106f6f7824ULL, 0x100fe200078e0202ULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000100013037824ULL, 0x000fe200078e0202ULL, 0xfffffff8090a7812ULL, 0x008fc400078ee206ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x000000100e0f7824ULL, 0x100fe200078e0203ULL,
0x0000000805067812ULL, 0x000fe200078ec0ffULL, 0x0000001004057824ULL, 0x100fe200078e0203ULL,
0x000000606104723eULL, 0x000fe200000010ffULL, 0x0000001010157824ULL, 0x000fe200078e0203ULL,
0x0000763266337816ULL, 0x000fe20000000033ULL, 0x0000001012177824ULL, 0x100fe200078e0203ULL,
0x000000444544723eULL, 0x000fe200000010ffULL, 0x0000001008097824ULL, 0x100fe200078e0203ULL,
0x000000484908723eULL, 0x000fe200000010ffULL, 0x000000100a0b7824ULL, 0x100fe200078e0203ULL,
0x000000404122723eULL, 0x000fe200000010ffULL, 0x000000100c0d7824ULL, 0x000fe200078e0203ULL,
0x000000646503723eULL, 0x000fe200000010ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x000000545505723eULL, 0x000fe200000010ffULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x00005410031c7816ULL, 0x140fe20000000004ULL, 0x0000000106157824ULL, 0x040fe200078e0215ULL,
0x00007632031d7816ULL, 0x000fe20000000004ULL, 0x0000000106177824ULL, 0x040fe200078e0217ULL,
0x0000005c5d03723eULL, 0x000fe200000010ffULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x000000585904723eULL, 0x000fe200000010ffULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x0000001c07007388ULL, 0x0003e20000000a00ULL, 0x00000001060d7824ULL, 0x000fe200078e020dULL,
0x000000505106723eULL, 0x000fc400000010ffULL, 0x000054105e2e7816ULL, 0x140fe4000000002fULL,
0x0000003c3d3c723eULL, 0x000fe400000010ffULL, 0x00000038391e723eULL, 0x000fe400000010ffULL,
0x000076325e2f7816ULL, 0x000fe4000000002fULL, 0x0000004c4d07723eULL, 0x002fe400000010ffULL,
0x00005410031c7816ULL, 0x000fc40000000004ULL, 0x00007632031d7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001c09007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040b007388ULL, 0x000fe20000000a00ULL,
0x00005410562a7816ULL, 0x000fc4000000002bULL, 0x00007632562b7816ULL, 0x000fe2000000002bULL,
0x000000060d007388ULL, 0x0003e20000000a00ULL, 0x000054104e267816ULL, 0x140fe40000000027ULL,
0x000076324e277816ULL, 0x000fe20000000027ULL, 0x000000320f007388ULL, 0x0005e20000000a00ULL,
0x000054103c0e7816ULL, 0x000fe4000000001eULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x0004002e09007388ULL, 0x000fe20000000a00ULL, 0x00000030311a723eULL, 0x000fc400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x0004002a0b007388ULL, 0x000fe20000000a00ULL,
0x0000541044067816ULL, 0x142fe40000000022ULL, 0x0000763244077816ULL, 0x000fe20000000022ULL,
0x000400260d007388ULL, 0x000fe20000000a00ULL, 0x000076323c0f7816ULL, 0x004fe4000000001eULL,
0x000000282916723eULL, 0x000fe200000010ffULL, 0x0000000615007388ULL, 0x0003e20000000a00ULL,
0x000000464703723eULL, 0x000fc400000010ffULL, 0x000000424304723eULL, 0x000fe200000010ffULL,
0x0008000e09007388ULL, 0x0005e20000000a00ULL, 0x0000003e3f05723eULL, 0x000fe400000010ffULL,
0x0000003a3b06723eULL, 0x002fe400000010ffULL, 0x00005410340e7816ULL, 0x144fe4000000001aULL,
0x00007632340f7816ULL, 0x000fca000000001aULL, 0x0008000e0b007388ULL, 0x0003e40000000a00ULL,
0x000054102c0e7816ULL, 0x142fe40000000016ULL, 0x000076322c0f7816ULL, 0x000fca0000000016ULL,
0x0008000e0d007388ULL, 0x0003e40000000a00ULL, 0x00005410030e7816ULL, 0x142fe40000000004ULL,
0x00007632030f7816ULL, 0x000fe40000000004ULL, 0x000000363703723eULL, 0x000fe400000010ffULL,
0x000000141f04723eULL, 0x000fe200000010ffULL, 0x0000000e17007388ULL, 0x0003e60000000a00ULL,
0x0000541003087816ULL, 0x000fc40000000004ULL, 0x00005410050e7816ULL, 0x142fe40000000006ULL,
0x00007632050f7816ULL, 0x000fe40000000006ULL, 0x000000202105723eULL, 0x000fe400000010ffULL,
0x000000242306723eULL, 0x000fe200000010ffULL, 0x000c000e09007388ULL, 0x0003e40000000a00ULL,
0x0000763203097816ULL, 0x002fe40000000004ULL, 0x000000ff00037306ULL, 0x000fe20000205400ULL,
0x00005410050e7816ULL, 0x000fc40000000006ULL, 0x00007632050f7816ULL, 0x000fe20000000006ULL,
0x000c00080b007388ULL, 0x000fe80000000a00ULL, 0x000000ff00047306ULL, 0x000e620000209400ULL,
0x000c000e0d007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000006f147984ULL, 0x000ea80000000c00ULL, 0x000400006f087984ULL, 0x000ee20000000c00ULL,
0x000000030400720bULL, 0x002fc40003f1d000ULL, 0x000000ff00037245ULL, 0x000fe2000020d400ULL,
0x000800006f247984ULL, 0x000e680000000c00ULL, 0x000c00006f287984ULL, 0x000f280000000c00ULL,
0x001000006f1c7984ULL, 0x000e640000000c00ULL, 0x0000000103030812ULL, 0x000fc400078efcffULL,
0x001400006f207984ULL, 0x000f220000000c00ULL, 0x000000ff1300720cULL, 0x000fe40003f05270ULL,
0x000000030312723eULL, 0x000fe200000010ffULL, 0x001800006f047984ULL, 0x000f280000000c00ULL,
0x001c00006f0c7984ULL, 0x000f220000000c00ULL, 0x3f803f8012177831ULL, 0x044fe40000200017ULL,
0x3f803f8012167831ULL, 0x000fc40000200016ULL, 0x3f803f8012157831ULL, 0x040fe40000200015ULL,
0x3f803f8012147831ULL, 0x040fe40000200014ULL, 0x3f803f80120b7831ULL, 0x048fe4000020000bULL,
0x3f803f80120a7831ULL, 0x040fe4000020000aULL, 0x3f803f8012097831ULL, 0x040fe40000200009ULL,
0x3f803f8012087831ULL, 0x000fc40000200008ULL, 0x3f803f8012277831ULL, 0x042fe40000200027ULL,
0x3f803f8012267831ULL, 0x040fe40000200026ULL, 0x3f803f8012257831ULL, 0x040fe40000200025ULL,
0x3f803f8012247831ULL, 0x040fe40000200024ULL, 0x3f803f80122b7831ULL, 0x050fe4000020002bULL,
0x3f803f80122a7831ULL, 0x000fc4000020002aULL, 0x3f803f8012297831ULL, 0x040fe40000200029ULL,
0x3f803f8012287831ULL, 0x000fe40000200028ULL, 0x3f803f8017177831ULL, 0x000fe4000020001fULL,
0x3f803f8016167831ULL, 0x000fe4000020001eULL, 0x3f803f8015157831ULL, 0x000fe4000020001dULL,
0x3f803f8014147831ULL, 0x000fc4000020001cULL, 0x3f803f800b0b7831ULL, 0x000fe40000200023ULL,
0x3f803f800a0a7831ULL, 0x000fe20000200022ULL, 0x000000146f007388ULL, 0x000fe20000000c00ULL,
0x3f803f8009097831ULL, 0x000fe40000200021ULL, 0x3f803f8008087831ULL, 0x000fe40000200020ULL,
0x3f803f8027277831ULL, 0x000fe40000200007ULL, 0x3f803f8026267831ULL, 0x000fe20000200006ULL,
0x000400086f007388ULL, 0x000fe20000000c00ULL, 0x3f803f8025257831ULL, 0x000fc40000200005ULL,
0x3f803f8024247831ULL, 0x000fe40000200004ULL, 0x3f803f802b2b7831ULL, 0x000fe4000020000fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020000eULL, 0x000800246f007388ULL, 0x000fe20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020000dULL, 0x3f803f8028287831ULL, 0x000fca000020000cULL,
0x000c00286f007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x000000180900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000e620000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0f7a12ULL, 0x000fe400078e33ffULL, 0x00000007000e7812ULL, 0x000fc800078ec0ffULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL,
0x0000000800057305ULL, 0x000e64000021f000ULL, 0x000000ffff037224ULL, 0x002fc800078e0a05ULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x0000000305107227ULL, 0x000fc800078e0004ULL,
0x0000000119037824ULL, 0x000fc800078e0209ULL, 0x0000000310077227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fc800078e0a07ULL, 0x00005a0004057a24ULL, 0x000fe400078e0203ULL,
0x0000000109047824ULL, 0x000fc600078e0200ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x0ffffff805057812ULL, 0x000fca00078ef800ULL,
0x0000001005067824ULL, 0x000fe400078e0202ULL, 0x0000000107071810ULL, 0x000fc60007ffe0ffULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x000000070f047207ULL, 0x000fe40004000000ULL,
0x0000002000077810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe200078e021bULL, 0x00000003ff067819ULL, 0x002fe20000011607ULL,
0x00005a000c037a24ULL, 0x000fc800078e0203ULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440cULL,
0x0000000811037824ULL, 0x000fe200078e020eULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x00000040000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x0000006000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x000000070d0c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x00000080000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000a000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f047207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL,
0x0000590004047a24ULL, 0x000fe400078e021bULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x000000070d0c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x000000036e037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x0000000811037824ULL, 0x000fe200078e020cULL, 0x000000180600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000119037824ULL, 0x100fe200078e0206ULL,
0x000000c0000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef807ULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe200078e0203ULL, 0x00000007070c7812ULL, 0x000fc600078ec0ffULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440eULL, 0x0000000811037824ULL, 0x000fe200078e020cULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000119037824ULL, 0x100fe200078e0206ULL, 0x000000e000077810ULL, 0x000fe20007ffe0ffULL,
0x000000010d067824ULL, 0x040fe200078e0206ULL, 0x000000070d007812ULL, 0x000fe200078ec0ffULL,
0x0000000310047227ULL, 0x002fc600078e00ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0a04ULL, 0x00005a0008057a24ULL, 0x000fca00078e0203ULL,
0x00005a0005007a0cULL, 0x000fda0003f26070ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff806057812ULL, 0x000fca00078ef80dULL, 0x0000001005067824ULL, 0x000fca00078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000104042810ULL, 0x000fc80007ffe0ffULL,
0x000000040f047207ULL, 0x000fe40004000000ULL, 0x00000003ff067819ULL, 0x002fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a04ULL, 0x0000590004047a24ULL, 0x000fe400078e021bULL,
0x00005a000c037a24ULL, 0x000fe400078e0203ULL, 0x0000000119197824ULL, 0x000fe400078e0206ULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x000000036e037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440cULL, 0x0000000811037824ULL, 0x000fe200078e0200ULL,
0x000000180600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000001910007227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x002fe400078e0a00ULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x00005a0004037a24ULL, 0x000fc600078e0219ULL,
0x0000000706067812ULL, 0x000fe400078ec0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000100001810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f46070ULL, 0xfffffff806037812ULL, 0x000fca00078ef807ULL,
0x0000001003047824ULL, 0x000fca00078e0202ULL, 0x0000000004087984ULL, 0x000e620000000c00ULL,
0x0000000100002810ULL, 0x000fc80007ffe0ffULL, 0x000000000f007207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a00ULL, 0x0000590000007a24ULL, 0x000fe400078e021bULL,
0x00005a0002197a24ULL, 0x000fc800078e0219ULL, 0x00005a0000197a24ULL, 0x000fe200078e0219ULL,
0x0000000707007812ULL, 0x000fc800078ec0ffULL, 0x000000196e197210ULL, 0x000fe20007f1e0ffULL,
0x0000000811117824ULL, 0x000fc800078e0200ULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e0019027a11ULL, 0x000fc800078040ffULL, 0x00005f0019037a11ULL, 0x000fca00000f4406ULL,
0x0000001011027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006c00ff6c7624ULL, 0x000fe400078e00ffULL,
0x00006d00ff6d7624ULL, 0x000fca00078e00ffULL, 0x000000066c6c7981ULL, 0x000522000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000001fff6d7424ULL, 0x004fe200078e00ffULL, 0x01260000ff047f8cULL, 0x000ea2000c80043fULL,
0x000000020e0e7824ULL, 0x000fe400078e00ffULL, 0x000000401a6b7824ULL, 0x000fe200078e00ffULL,
0x000058006d6d7a10ULL, 0x000fe20007ffe0ffULL, 0x000059000e007a24ULL, 0x000fc600078e021bULL,
0x00000005ff6d7819ULL, 0x000fe2000001166dULL, 0x0000680000147a24ULL, 0x000fe400078e026bULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff207819ULL, 0x000fe40000011617ULL,
0x0000001717107211ULL, 0x000fe400078fe8ffULL, 0x0000000820117810ULL, 0x000fe20007ffe0ffULL,
0x0000000114067824ULL, 0x002fe200078e0220ULL, 0x0000001020217810ULL, 0x040fe40007ffe0ffULL,
0x0000001820227810ULL, 0x000fe20007ffe0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000020201d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000310187812ULL, 0x000fe200078ec0ffULL,
0x0000000114087824ULL, 0x000fe200078e0211ULL, 0x00000030060e7812ULL, 0x000fe200078ef803ULL,
0x00000001140a7824ULL, 0x000fe200078e0221ULL, 0x0000006b16067217ULL, 0x000fe20007800000ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe40007f1e0ffULL,
0x00000028201e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001140c7824ULL, 0x040fe200078e0222ULL,
0x00006500070f7a10ULL, 0x000fe200007fe4ffULL, 0x0000000114077824ULL, 0x000fe200078e021dULL,
0x0000003008087812ULL, 0x000fe200078ef803ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000020001a1c7811ULL, 0x000fc400078e68ffULL, 0x0000640008087a10ULL, 0x000fe20007f3e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fe400078ef803ULL,
0x0000650009097a10ULL, 0x000fe20000ffe4ffULL, 0x0000000106137824ULL, 0x000fe200078e0a6bULL,
0x000000300c0c7812ULL, 0x100fe200078ef803ULL, 0x0000008007067825ULL, 0x000fe200078e00ffULL,
0x000064000a0a7a10ULL, 0x000fe40007f1e0ffULL, 0x000064000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x00000004111b7824ULL, 0x000fe200078e00ffULL, 0x0000003006107812ULL, 0x000fe200078ef803ULL,
0x0000000114067824ULL, 0x000fe200078e021eULL, 0x000065000b0b7a10ULL, 0x000fc400007fe4ffULL,
0x0000640010107a10ULL, 0x000fe40007f5e0ffULL, 0x000065000d0d7a10ULL, 0x000fe40000ffe4ffULL,
0x000000132000720cULL, 0x080fe40003f06070ULL, 0x000000131100720cULL, 0x000fe40003f26070ULL,
0x0000650007117a10ULL, 0x000fe200017fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0ffffffc18177812ULL, 0x000fc400078ef817ULL, 0xfffffffc1b1b7812ULL, 0x000fe400078ee218ULL,
0x00000030201f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x100fe200078e021cULL,
0x0000003006127812ULL, 0x000fe200078ef803ULL, 0x000000101b1b7824ULL, 0x000fe200078e021cULL,
0x0000003820207810ULL, 0x000fe20007ffe0ffULL, 0x0000000114067824ULL, 0x000fe200078e021fULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e177faeULL, 0x0003e2000c101c46ULL, 0x000000132100720cULL, 0x000fc40003fa6070ULL,
0x000000132200720cULL, 0x080fe20003f86070ULL, 0x00000000081b7faeULL, 0x0007e2000c901c46ULL,
0x000000131d00720cULL, 0x080fe40003f66070ULL, 0x000000131e00720cULL, 0x080fe40003f46070ULL,
0x000000131f00720cULL, 0x0c0fe20003f26070ULL, 0x000000041f1f7824ULL, 0x000fe200078e00ffULL,
0x000000132000720cULL, 0x000fe20003f06070ULL, 0x00000004210f7824ULL, 0x002fe200078e00ffULL,
0x0000650007137a10ULL, 0x000fe200037fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0xfffffffc1f1f7812ULL, 0x000fc400078ee218ULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee218ULL,
0x0000000114087824ULL, 0x008fe200078e0220ULL, 0x0000003006067812ULL, 0x100fe200078ef803ULL,
0x0000000422177824ULL, 0x000fe400078e00ffULL, 0x000000041d1b7824ULL, 0x000fe200078e00ffULL,
0x0000640006067a10ULL, 0x000fe20007fde0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc17177812ULL, 0x100fe400078ee218ULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee218ULL,
0x000000041e1d7824ULL, 0x000fe200078e00ffULL, 0x0000003008037812ULL, 0x000fe200078ef803ULL,
0x0000000420217824ULL, 0x000fe200078e00ffULL, 0x0000650007077a10ULL, 0x000fe200037fe4ffULL,
0x000000100f0f7824ULL, 0x000fe200078e021cULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee218ULL,
0x0000001017177824ULL, 0x000fe200078e021cULL, 0xfffffffc21217812ULL, 0x000fe200078ee218ULL,
0x000000101b1b7824ULL, 0x100fe200078e021cULL, 0x0000640003087a10ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021cULL, 0x000000000a0f7faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x100fe200078e021cULL, 0x0000650009097a10ULL, 0x000fe200037fe4ffULL,
0x0000001021217824ULL, 0x000fe200078e021cULL, 0x000000000c177faeULL, 0x0003e8000e101c46ULL,
0x00000000101b7faeULL, 0x0003e8000d901c46ULL, 0x00000000121d7faeULL, 0x0003e8000d101c46ULL,
0x00000000061f7faeULL, 0x0003e8000c901c46ULL, 0x0000000008217faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000001717087211ULL, 0x040fe400078fe8ffULL,
0x00000008170f7811ULL, 0x000fc400078ff0ffULL, 0x0000001017117811ULL, 0x040fe400078ff0ffULL,
0x0000001817137811ULL, 0x040fe400078ff0ffULL, 0x0000002817097811ULL, 0x040fe200078ff0ffULL,
0x00000001140a7824ULL, 0x040fe200078e0211ULL, 0x0000002017077811ULL, 0x000fe200078ff0ffULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0x00000030170b7811ULL, 0x040fe200078ff0ffULL,
0x00000001140c7824ULL, 0x000fe200078e0213ULL, 0x00000003081c7812ULL, 0x000fe200078ec0ffULL,
0x0000000114087824ULL, 0x000fe200078e020fULL, 0x00000038170d7811ULL, 0x000fe200078ff0ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000001417067211ULL, 0x002fe200078ff0ffULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0x000020001a277811ULL, 0x000fe200078e68ffULL,
0x00000001141e7824ULL, 0x040fe200078e0209ULL, 0xfffffffc0f0e7812ULL, 0x100fe200078ee21cULL,
0x00000004071b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc110f7812ULL, 0x100fe200078ee21cULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc13117812ULL, 0x100fe200078ee21cULL,
0x0000000114207824ULL, 0x040fe200078e020bULL, 0xfffffffc1b127812ULL, 0x100fe200078ee21cULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09137812ULL, 0x100fe200078ee21cULL,
0x0000000114187824ULL, 0x000fe200078e0207ULL, 0x0ffffffc1c177812ULL, 0x000fe200078ef817ULL,
0x0000000114227824ULL, 0x000fe200078e020dULL, 0xfffffffc0b147812ULL, 0x000fe200078ee21cULL,
0x000000040d0d7824ULL, 0x000fc400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffffc0d1c7812ULL, 0x000fe200078ee21cULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000003006107812ULL, 0x000fc600078ef803ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fc60007f1e0ffULL, 0x0000001012217824ULL, 0x000fe200078e0227ULL,
0x0000003008127812ULL, 0x000fe200078ef803ULL, 0x00000010172b7824ULL, 0x000fe200078e0227ULL,
0x000000300a1d7812ULL, 0x000fe200078ef803ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fc60007f3e0ffULL, 0x000000100e177824ULL, 0x000fe200078e0227ULL,
0x000000300c0c7812ULL, 0x000fe200078ef803ULL, 0x000000100f1b7824ULL, 0x100fe400078e0227ULL,
0x00000010111f7824ULL, 0x100fe200078e0227ULL, 0x0000650007117a10ULL, 0x000fe200007fe4ffULL,
0x0000001013237824ULL, 0x100fe200078e0227ULL, 0x0000650009137a10ULL, 0x000fe20000ffe4ffULL,
0x0000001014257824ULL, 0x100fe200078e0227ULL, 0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000101c277824ULL, 0x000fe200078e0227ULL, 0x000064001d1c7a10ULL, 0x000fe20007f5e0ffULL,
0x0000008018067825ULL, 0x000fe200078e00ffULL, 0x000065000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x000065000b1d7a10ULL, 0x000fe200017fe4ffULL, 0x000000801e087825ULL, 0x000fe200078e00ffULL,
0x0000003006067812ULL, 0x100fe200078ef803ULL, 0x0000000012177faeULL, 0x0003e4000b901c46ULL,
0x00000080200a7825ULL, 0x000fe200078e00ffULL, 0x0000003008087812ULL, 0x100fe200078ef803ULL,
0x000000001c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000640006067a10ULL, 0x000fe20007f1e0ffULL,
0x00000080220e7825ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fe200078ef803ULL,
0x000000000c1f7faeULL, 0x0003e2000b901c46ULL, 0x0000640008087a10ULL, 0x000fc40007f3e0ffULL,
0x000000300e037812ULL, 0x000fe400078ef803ULL, 0x000064000a0a7a10ULL, 0x000fe40007f5e0ffULL,
0x00006400030e7a10ULL, 0x000fe40007f7e0ffULL, 0x0000650007077a10ULL, 0x000fe400007fe4ffULL,
0x0000650009097a10ULL, 0x000fe40000ffe4ffULL, 0x000065000b0b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000006217faeULL, 0x0003e2000b901c46ULL, 0x000065000f0f7a10ULL, 0x000fc60001ffe4ffULL,
0x0000000008237faeULL, 0x0003e8000b901c46ULL, 0x000000000a257faeULL, 0x0003e8000b901c46ULL,
0x000000000e277faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01260400ff037984ULL, 0x000e620000000800ULL,
0x0000006d02027224ULL, 0x000fe400078e02ffULL, 0x00000001166f7824ULL, 0x000fc400078e0a69ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x006fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620002027625ULL, 0x000fe200078e0029ULL, 0x00000008ff6f7819ULL, 0x000fe2000001166fULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x000000201a047824ULL, 0x002fca00078e0205ULL, 0x00000004ff057819ULL, 0x000fe40000011604ULL,
0x0000000104067810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe05077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04057812ULL, 0x000fc600078ec0ffULL, 0x0000000107097824ULL, 0x040fe400078e0206ULL,
0x0000000104087824ULL, 0x000fe200078e0207ULL, 0x0000000807077810ULL, 0x000fe20007ffe0ffULL,
0x00000010050a7824ULL, 0x000fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x00000010050b7824ULL, 0x000fe200078e00ffULL, 0x0000000f08087812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000001f00a097812ULL, 0x000fe200078ee209ULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x000001f00b087812ULL, 0x000fe200078ee208ULL,
0x0000001005077824ULL, 0x040fe200078e00ffULL, 0x0000000f06067812ULL, 0x000fe200078ec0ffULL,
0x00000000090c7984ULL, 0x000e62000000cc00ULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x0000000f04047812ULL, 0x000fc400078ec0ffULL, 0x0000000008107984ULL, 0x000ea4000000cc00ULL,
0x000001f005067812ULL, 0x000fe400078ee206ULL, 0x000001f007047812ULL, 0x000fe200078ee204ULL,
0x000000ffff1e7224ULL, 0x002fe400078e000cULL, 0x000000ffff1f7224ULL, 0x000fe400078e000eULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x0000001c08007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fca00078e0013ULL, 0x0000002009007388ULL, 0x000fe8000000cc00ULL,
0x00000000060c7984ULL, 0x000e68000000cc00ULL, 0x0000000004107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x004fe400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002404007388ULL, 0x0003e8000000cc00ULL,
0x0000000c06007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x01260400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000000006e7919ULL, 0x000e620000000000ULL, 0x000000026d6d7824ULL, 0x000fe200078e00ffULL,
0x3db504f36c6c7820ULL, 0x010fe20000410000ULL, 0x000126881a6a7811ULL, 0x040fe200078e18ffULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0xffffffff69687810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0x00000009691b7810ULL, 0x000fe40007ffe0ffULL,
0x000126081a187811ULL, 0x000fc400078e28ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x000fe200078e0017ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff707224ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x00cfc4000001ff00ULL,
0x000000017000780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x00000001140c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff727224ULL, 0x000fe200078e0070ULL,
0x00000001700d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000171177812ULL, 0x000fe400078e0cffULL,
0x000000020d00780cULL, 0x000fe20003f06070ULL, 0x000000ffff707224ULL, 0x000fc800078e000dULL,
0x000000ffff0c1224ULL, 0x000fc800078e0214ULL, 0x000001000c1f7824ULL, 0x040fe200078e026bULL,
0x000000010c0e7810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0d0c7207ULL, 0x000fe20000800000ULL,
0x0000680000637a24ULL, 0x020fe200078e021fULL, 0x000000150e00720cULL, 0x000fda0003f46070ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x000000106e0d7824ULL, 0x002fe200078e00ffULL,
0x00000002ff5c7819ULL, 0x000fe2000001166eULL, 0x000000021a5b7824ULL, 0x000fe200078e0217ULL,
0x0000001f161c7217ULL, 0x000fe40007800000ULL, 0x000000300d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000015c0f7824ULL, 0x040fe200078e0263ULL, 0x000000185c607810ULL, 0x000fe20007ffe0ffULL,
0x000000011c5a7824ULL, 0x000fe200078e0a1fULL, 0x000000085c587810ULL, 0x000fe20007ffe0ffULL,
0x000000400c0c7824ULL, 0x000fe200078e020dULL, 0x000000105c597810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000000205c627810ULL, 0x000fe20007ffe0ffULL,
0x00000001601d7824ULL, 0x040fe200078e0263ULL, 0x000020005b5b7811ULL, 0x000fe200078e60ffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x0000005a6000720cULL, 0x000fc60003fa6070ULL,
0x0000000158117824ULL, 0x000fe200078e0263ULL, 0x000064000e1e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000163137824ULL, 0x000fe200078e0259ULL, 0x0000006e6e0e7211ULL, 0x000fe200078fe8ffULL,
0x000000801d1c7825ULL, 0x100fe200078e000cULL, 0x000065000f1f7a10ULL, 0x000fe40000ffe4ffULL,
0x000000030e657812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e000cULL,
0x000064001c1c7a10ULL, 0x000fe40007f3e0ffULL, 0x0ffffffc655e7812ULL, 0x000fe200078ef86eULL,
0x0000000459667824ULL, 0x000fe200078e00ffULL, 0x0000640010107a10ULL, 0x000fe20007f5e0ffULL,
0x0000008013127825ULL, 0x000fe200078e000cULL, 0x000065001d1d7a10ULL, 0x000fc40000ffe4ffULL,
0x0000005a5c00720cULL, 0x080fe20003f26070ULL, 0x00000001620f7824ULL, 0x000fe200078e0263ULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x000000105e5d7824ULL, 0x000fe200078e025bULL,
0xfffffffc665e7812ULL, 0x000fe200078ee265ULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x0000650011117a10ULL, 0x000fe400017fe4ffULL, 0x0000650013137a10ULL, 0x000fe20001ffe4ffULL,
0x0000000458647824ULL, 0x040fe200078e00ffULL, 0x0000005a5800720cULL, 0x080fe20003f46070ULL,
0x000000105e617824ULL, 0x000fe200078e025bULL, 0x0000005a5900720cULL, 0x000fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e5d7faeULL, 0x0003e2000c901c46ULL,
0x000064000e587a10ULL, 0x000fc40007f9e0ffULL, 0x000000285c5e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc640e7812ULL, 0x000fe400078ee265ULL, 0x000065000f597a10ULL, 0x000fe200027fe4ffULL,
0x000000015e0f7824ULL, 0x000fe200078e0263ULL, 0x000000305c647810ULL, 0x000fe20007ffe0ffULL,
0x000000100e5f7824ULL, 0x000fe200078e025bULL, 0x000000385c5c7810ULL, 0x000fe20007ffe0ffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x0000005a6200720cULL, 0x000fc40003f86070ULL,
0x00000000105f7faeULL, 0x0005e2000d101c46ULL, 0x00000001641f7824ULL, 0x102fe200078e0263ULL,
0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x000000015c5d7824ULL, 0x000fe200078e0263ULL,
0x0000000012617faeULL, 0x0003e2000d901c46ULL, 0x0000005a5e00720cULL, 0x080fe20003f66070ULL,
0x00000004621e7824ULL, 0x000fe200078e00ffULL, 0x0000005a6400720cULL, 0x0c0fe20003f46070ULL,
0x0000000464647824ULL, 0x000fe200078e00ffULL, 0x0000005a5c00720cULL, 0x000fe20003f26070ULL,
0x000000045e5a7824ULL, 0x000fe200078e00ffULL, 0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x000000801f107825ULL, 0x004fe200078e000cULL, 0xfffffffc1e1e7812ULL, 0x000fc400078ee265ULL,
0xfffffffc5a5a7812ULL, 0x100fe200078ee265ULL, 0x0000000460127824ULL, 0x002fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe20007fde0ffULL, 0x000000045c5e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc645c7812ULL, 0x000fe200078ee265ULL, 0x000000805d0c7825ULL, 0x000fe200078e000cULL,
0xfffffffc12127812ULL, 0x100fe400078ee265ULL, 0xfffffffc5e5e7812ULL, 0x000fe200078ee265ULL,
0x000000101e1f7824ULL, 0x100fe200078e025bULL, 0x0000650011117a10ULL, 0x000fe200037fe4ffULL,
0x0000001012137824ULL, 0x100fe200078e025bULL, 0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x000000105a5d7824ULL, 0x000fc400078e025bULL, 0x000000105c5f7824ULL, 0x100fe200078e025bULL,
0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x000000105e5b7824ULL, 0x000fe200078e025bULL,
0x000000001c137faeULL, 0x0003e8000e901c46ULL, 0x00000000581f7faeULL, 0x0003e8000e101c46ULL,
0x000000000e5d7faeULL, 0x0003e8000d901c46ULL, 0x00000000105f7faeULL, 0x0003e8000d101c46ULL,
0x000000000c5b7faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x000000106e0d7824ULL, 0x042fe200078e00ffULL, 0x000000106e107811ULL, 0x000fe200078ff0ffULL,
0x000000021a0f7824ULL, 0x000fe200078e0217ULL, 0x000000186e127811ULL, 0x000fe200078ff0ffULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0x000000300d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000110117824ULL, 0x100fe200078e0263ULL, 0x000000206e1c7811ULL, 0x000fe200078ff0ffULL,
0x0000000112137824ULL, 0x000fe200078e0263ULL, 0x000000286e1e7811ULL, 0x000fe200078ff0ffULL,
0x000000400c5a7824ULL, 0x000fe200078e020dULL, 0x0000006e6e0e7211ULL, 0x000fe200078fe8ffULL,
0x000000011c1d7824ULL, 0x100fe200078e0263ULL, 0x000000086e0c7811ULL, 0x000fe200078ff0ffULL,
0x000000011e1f7824ULL, 0x000fe200078e0263ULL, 0x000000306e587811ULL, 0x000fe200078ff0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x000000386e5e7811ULL, 0x000fe200078ff0ffULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x000000030e0d7812ULL, 0x000fe200078ec0ffULL,
0x000000040c0e7824ULL, 0x000fe200078e00ffULL, 0x000020000f757811ULL, 0x000fe200078e60ffULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc10107812ULL, 0x100fe200078ee20dULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e0e7812ULL, 0x100fe200078ee20dULL,
0x00000004585c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x100fe200078ee20dULL,
0x000000045e607824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee20dULL,
0x000000010c0f7824ULL, 0x000fe200078e0263ULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee20dULL,
0x000000100e5d7824ULL, 0x000fe200078e0275ULL, 0xfffffffc5c5c7812ULL, 0x000fe200078ee20dULL,
0x00000010105f7824ULL, 0x000fe200078e0275ULL, 0xfffffffc60607812ULL, 0x000fe200078ee20dULL,
0x000000800f0e7825ULL, 0x000fe200078e005aULL, 0x0ffffffc0d0c7812ULL, 0x000fc400078ef86eULL,
0x000000636e0d7211ULL, 0x000fe200078ff0ffULL, 0x0000001012617824ULL, 0x100fe200078e0275ULL,
0x000064000e0e7a10ULL, 0x000fe20007f5e0ffULL, 0x000000100c777824ULL, 0x000fe400078e0275ULL,
0x000000800d0c7825ULL, 0x000fe200078e005aULL, 0x000065000f0f7a10ULL, 0x000fc600017fe4ffULL,
0x0000008011107825ULL, 0x000fe200078e005aULL, 0x000064000c0c7a10ULL, 0x000fc60007f3e0ffULL,
0x0000000158597824ULL, 0x100fe200078e0263ULL, 0x0000640010107a10ULL, 0x000fe20007f7e0ffULL,
0x000000015e737824ULL, 0x000fe200078e0263ULL, 0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000008013127825ULL, 0x000fe200078e005aULL, 0x0000650011117a10ULL, 0x000fc60001ffe4ffULL,
0x000000101c637824ULL, 0x100fe200078e0275ULL, 0x0000640012127a10ULL, 0x000fe20007f9e0ffULL,
0x000000101e657824ULL, 0x000fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c777faeULL, 0x0003e2000b901c46ULL, 0x000000801d1c7825ULL, 0x100fe200078e005aULL,
0x0000650013137a10ULL, 0x000fe400027fe4ffULL, 0x000000000e5d7faeULL, 0x0003e2000b901c46ULL,
0x000000801f1e7825ULL, 0x100fe200078e005aULL, 0x000064001c1c7a10ULL, 0x000fe40007f3e0ffULL,
0x00000000105f7faeULL, 0x0003e2000b901c46ULL, 0x0000008059587825ULL, 0x000fe200078e005aULL,
0x000064001e1e7a10ULL, 0x000fc40007f5e0ffULL, 0x000065001d1d7a10ULL, 0x000fe20000ffe4ffULL,
0x00000080735a7825ULL, 0x000fe200078e005aULL, 0x0000640058587a10ULL, 0x000fe20007f7e0ffULL,
0x0000000012617faeULL, 0x0003e2000b901c46ULL, 0x000065001f1f7a10ULL, 0x000fe200017fe4ffULL,
0x000000105c677824ULL, 0x100fe200078e0275ULL, 0x000064005a5a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001060757824ULL, 0x000fe200078e0275ULL, 0x0000650059597a10ULL, 0x000fe20001ffe4ffULL,
0x000000001c637faeULL, 0x0003e2000b901c46ULL, 0x000065005b5b7a10ULL, 0x000fc600027fe4ffULL,
0x000000001e657faeULL, 0x0003e8000b901c46ULL, 0x0000000058677faeULL, 0x0003e8000b901c46ULL,
0x000000005a757faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000872767824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x002fc400078e00ffULL, 0x00000010ff757424ULL, 0x000fe200078e00ffULL,
0x0000001276747810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0x0000000276767810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff86e0f7812ULL, 0x000fe200078ec0ffULL, 0x000000021a617824ULL, 0x000fe200078e0271ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000086e137812ULL, 0x020fe400078ec0ffULL,
0x000000070f0e7812ULL, 0x000fe400078ef86eULL, 0x0000200061617811ULL, 0x000fc400078e60ffULL,
0x00000001ff107819ULL, 0x000fe2000001160eULL, 0x000000040e0f7824ULL, 0x000fe200078e00ffULL,
0x000000076e117812ULL, 0x000fe200078ec0ffULL, 0x000000040e1d7824ULL, 0x000fe200078e00ffULL,
0x0000000173637810ULL, 0x000fe20007ffe0ffULL, 0x00000001100c7824ULL, 0x000fe200078e0273ULL,
0x00000007131c7812ULL, 0x000fc600078ef86eULL, 0x0000000110107824ULL, 0x000fe200078e0263ULL,
0xfffffffc0f0c7812ULL, 0x000fe200078ee20cULL, 0x00000008720f7824ULL, 0x000fe400078e020dULL,
0x000000101c0e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1d107812ULL, 0x000fe200078ee210ULL,
0x000000100c5c7824ULL, 0x000fe200078e0261ULL, 0x000000136e0c7211ULL, 0x000fc600078fe0ffULL,
0x0000001010647824ULL, 0x000fe400078e0261ULL, 0x000000005c5c783bULL, 0x000e620000000200ULL,
0x00000001110c7824ULL, 0x000fe400078e020cULL, 0x0000000872117824ULL, 0x000fe200078e0275ULL,
0x000000006464783bULL, 0x000ea20000000200ULL, 0x000000010c0f7824ULL, 0x040fe200078e020fULL,
0x000000760c127210ULL, 0x040fe20007ffe00dULL, 0x000000010c117824ULL, 0x040fe200078e0211ULL,
0x000000740c137210ULL, 0x000fc40007ffe00dULL, 0x000000206e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000101c0c7812ULL, 0x000fe400078efcffULL, 0xfffffff80d0d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff00e0f7812ULL, 0x000fe200078ee20fULL, 0x000000100c1e7824ULL, 0x040fe200078e00ffULL,
0x000000070d607812ULL, 0x000fe200078ef86eULL, 0x000000100c0e7824ULL, 0x000fe400078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff627819ULL, 0x000fe20000011660ULL,
0x0000000460777824ULL, 0x000fe200078e00ffULL, 0xfffffff00e137812ULL, 0x000fe200078ee213ULL,
0x000000101c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff01e117812ULL, 0x000fe200078ee211ULL,
0x000000000f58783bULL, 0x000ee20000000200ULL, 0x00000004607f7824ULL, 0x000fc400078e00ffULL,
0xfffffff00d127812ULL, 0x000fe200078ee212ULL, 0x0000001011117824ULL, 0x000fc800078e00ffULL,
0x0000001012127824ULL, 0x000fe200078e00ffULL, 0x00000000111c783bULL, 0x000fe20000000200ULL,
0x00000018ff0c7819ULL, 0x102fe4000001165fULL, 0x00000018ff8e7819ULL, 0x100fe4000001165cULL,
0x0000000cff10723eULL, 0x000fe400020006ffULL, 0x00000010ff0c7819ULL, 0x000fe4000001165fULL,
0x00000010ff877819ULL, 0x000fe2000001165cULL, 0x20000010ff107230ULL, 0x000fe20000004100ULL,
0x000000ff0c0e7812ULL, 0x000fe200078ec0ffULL, 0x00000001620c7824ULL, 0x000fe200078e0273ULL,
0x0000ffff5c917812ULL, 0x000fe200078ec0ffULL, 0x0000000162627824ULL, 0x000fe200078e0263ULL,
0x00000018ff8f7819ULL, 0x004fc40000011664ULL, 0xfffffffc770c7812ULL, 0x000fe400078ee20cULL,
0x0000008eff90723eULL, 0x000fe400020006ffULL, 0x000000ff878e7812ULL, 0x000fe200078ec0ffULL,
0x000000100c787824ULL, 0x000fe200078e0261ULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff877819ULL, 0x000fe20000011691ULL, 0x20000090ff917230ULL, 0x000fe20000004100ULL,
0x0000008fff95723eULL, 0x000fe200020006ffULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0x0000008eff8f723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000087ff8e723eULL, 0x000fe200020006ffULL, 0x2000008fff907230ULL, 0x000fe20000004100ULL,
0x0000ffff5f0d7812ULL, 0x040fe200078ec0ffULL, 0x2000005cff877230ULL, 0x000fe20000004100ULL,
0x000000ff64937812ULL, 0x000fe200078ec0ffULL, 0x2000008eff8f7230ULL, 0x000fe20000004100ULL,
0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL, 0x20000095ff5c7230ULL, 0x000fe20000004100ULL,
0x00000008ff0d7819ULL, 0x000fc4000001160dULL, 0x0000000eff0e723eULL, 0x000fe400020006ffULL,
0x00000093ff9a723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x2000000eff0e7230ULL, 0x000fe20000004100ULL, 0x0000000dff0d723eULL, 0x000fe400020006ffULL,
0x00000010ff937819ULL, 0x000fe20000011691ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000010ff8e7819ULL, 0x000fe20000011687ULL, 0x2000000dff0d7230ULL, 0x000fe20000004100ULL,
0x00000010ff907819ULL, 0x000fe20000011690ULL, 0x2000009aff877230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fc4000001168fULL, 0x00001054938f7816ULL, 0x000fe40000000090ULL,
0x00001054918e7816ULL, 0x000fe4000000008eULL, 0x00000010ff7d7819ULL, 0x000fe4000001160eULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff0e7819ULL, 0x000fe2000001160dULL,
0x0000008e5850723cULL, 0x008fe20000041850ULL, 0x00000018ff967819ULL, 0x002fe20000011679ULL,
0x00000010130d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fc40000011678ULL,
0x000000ff79977812ULL, 0x000fe400078ec0ffULL, 0x00000096ff96723eULL, 0x000fe200020006ffULL,
0x0000008e1c54723cULL, 0x000be20000041854ULL, 0x000000ff7a9c7812ULL, 0x000fe400078ec0ffULL,
0x00000092ff95723eULL, 0x000fe200020006ffULL, 0x20000096ff9d7230ULL, 0x000fe20000004100ULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x00000018ff907819ULL, 0x100fe2000001165dULL,
0x20000095ff9a7230ULL, 0x000fe20000004100ULL, 0x00000010ff8e7819ULL, 0x020fc4000001165dULL,
0x000000ff5d8f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5d967812ULL, 0x000fe400078ec0ffULL,
0x000010540e7c7816ULL, 0x000fe4000000005fULL, 0x00000018ff637819ULL, 0x100fe20000011667ULL,
0x000000000d0c783bULL, 0x000fe20000000200ULL, 0x00000018ff5d7819ULL, 0x000fe4000001165eULL,
0x00000010ff5f7819ULL, 0x000fc40000011667ULL, 0x0000009cff93723eULL, 0x000fe200020006ffULL,
0x20000097ff9c7230ULL, 0x000fe20000004100ULL, 0x000000ff67777812ULL, 0x040fe400078ec0ffULL,
0x0000ffff677e7812ULL, 0x000fe200078ec0ffULL, 0x20000093ff937230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fe4000001165eULL, 0x000000ff5e957812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5e977812ULL, 0x000fc400078ec0ffULL, 0x00000063ff67723eULL, 0x000fe400020006ffULL,
0x0000005dff5e723eULL, 0x000fe400020006ffULL, 0x000000ff5f637812ULL, 0x000fe200078ec0ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fe40000011696ULL,
0x00000010ff107819ULL, 0x000fe40000011610ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0xfffffffc7f627812ULL, 0x000fe400078ee262ULL, 0x0000008fff8f723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x000000ff8e8e7812ULL, 0x000fe200078ec0ffULL,
0x0000001062627824ULL, 0x000fe200078e0261ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x2000008fff8f7230ULL, 0x000fe20000004100ULL, 0x00001054107d7816ULL, 0x000fe4000000007dULL,
0x000000ff78947812ULL, 0x000fe200078ec0ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000018ff987819ULL, 0x000fe2000001167aULL, 0x000000001210783bULL, 0x000e620000000200ULL,
0x00000090ff90723eULL, 0x000fe200020006ffULL, 0x0000007c5808723cULL, 0x000f620000041808ULL,
0x0000008eff8e723eULL, 0x000fc400020006ffULL, 0x000000ff91967812ULL, 0x000fe200078ec0ffULL,
0x20000090ff907230ULL, 0x000fe20000004100ULL, 0x00000094ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff917819ULL, 0x000fe20000011697ULL, 0x0000007c1c04723cULL, 0x000b620000041804ULL,
0x00000098ff94723eULL, 0x000fe200020006ffULL, 0x2000005eff987230ULL, 0x000fe20000004100ULL,
0x00000096ff97723eULL, 0x000fe200020006ffULL, 0x2000008eff5e7230ULL, 0x000fe20000004100ULL,
0x00000095ff95723eULL, 0x000fe200020006ffULL, 0x20000092ff927230ULL, 0x000fe20000004100ULL,
0x00000010ff7d7819ULL, 0x020fe20000011663ULL, 0x20000097ff977230ULL, 0x000fe20000004100ULL,
0x00000091ff96723eULL, 0x000fe200020006ffULL, 0x000000006260783bULL, 0x000ea20000000200ULL,
0x00000010ff8e7819ULL, 0x000fe2000001168fULL, 0x20000095ff957230ULL, 0x000fe20000004100ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x20000096ff967230ULL, 0x000fe20000004100ULL,
0x0000ffff78a07812ULL, 0x000fe200078ec0ffULL, 0x20000094ff947230ULL, 0x000fe20000004100ULL,
0x00000010ff917819ULL, 0x000fc40000011690ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x000010545d8e7816ULL, 0x000fe4000000008eULL, 0x00000008ff5d7819ULL, 0x000fe400000116a0ULL,
0x00001054918f7816ULL, 0x000fe4000000005eULL, 0x0000005dff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff987819ULL, 0x000fc40000011698ULL, 0x00000010ff917819ULL, 0x000fe20000011697ULL,
0x0000008e583c723cULL, 0x080f62000004183cULL, 0x00000010ff907819ULL, 0x000fe20000011695ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe40000011696ULL,
0x00000008ff5f7819ULL, 0x000fe4000001167eULL, 0x00000010ff9b7819ULL, 0x000fe20000011679ULL,
0x0000008e1c28723cULL, 0x000f620000041828ULL, 0x0000ffff798d7812ULL, 0x000fc400078ec0ffULL,
0x0000105498917816ULL, 0x000fe40000000091ULL, 0x000010545d907816ULL, 0x000fe40000000090ULL,
0x00000077ff77723eULL, 0x000fe400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000ffff7a8b7812ULL, 0x000fe200078ec0ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x00000010ff8c7819ULL, 0x000fe2000001167bULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff9b9b7812ULL, 0x000fe200078ec0ffULL, 0x000000905848723cULL, 0x000fe20000041848ULL,
0x00000008ff8d7819ULL, 0x000fc4000001168dULL, 0x00000010ff997819ULL, 0x000fe40000011678ULL,
0x00000010ff8a7819ULL, 0x000fe4000001167aULL, 0x0000ffff7b897812ULL, 0x000fe200078ec0ffULL,
0x000000901c34723cULL, 0x000b620000041834ULL, 0x0000009bff9b723eULL, 0x000fe400020006ffULL,
0x0000008dff8d723eULL, 0x000fe400020006ffULL, 0x00000008ff8b7819ULL, 0x000fe2000001168bULL,
0x2000009bff9b7230ULL, 0x000fe20000004100ULL, 0x000000ff8c8c7812ULL, 0x000fe200078ec0ffULL,
0x2000008dff8d7230ULL, 0x000fe20000004100ULL, 0x00000018ff9e7819ULL, 0x000fc4000001167bULL,
0x000000ff7b9f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff99997812ULL, 0x000fe400078ec0ffULL,
0x000000ff8a8a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff917819ULL, 0x020fe40000011689ULL,
0x0000008bff5d723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x00000010ff777819ULL, 0x000fe20000011677ULL, 0x2000005dff8f7230ULL, 0x000fe20000004100ULL,
0x00000010ff7c7819ULL, 0x000fe2000001165fULL, 0x2000008cff957230ULL, 0x000fe20000004100ULL,
0x0000009eff9e723eULL, 0x000fe400020006ffULL, 0x0000009fff9f723eULL, 0x000fe400020006ffULL,
0x00000099ff99723eULL, 0x000fe200020006ffULL, 0x2000009eff9e7230ULL, 0x000fe20000004100ULL,
0x0000008aff8a723eULL, 0x000fe200020006ffULL, 0x2000009fff9f7230ULL, 0x000fe20000004100ULL,
0x00000091ff91723eULL, 0x000fe200020006ffULL, 0x20000099ff997230ULL, 0x000fe20000004100ULL,
0x00000010ff7e7819ULL, 0x000fe20000011667ULL, 0x2000008aff907230ULL, 0x000fe20000004100ULL,
0x000010547c7c7816ULL, 0x000fe20000000077ULL, 0x20000091ff917230ULL, 0x000fe20000004100ULL,
0x00000010ff5f7819ULL, 0x000fc40000011665ULL, 0x0000ffff65777812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fe4000001169dULL, 0x00000010ff8c7819ULL, 0x000fe4000001169cULL,
0x00000010ff9b7819ULL, 0x000fe4000001169bULL, 0x00000010ff897819ULL, 0x000fe4000001168dULL,
0x000010547e7d7816ULL, 0x000fc4000000007dULL, 0x00000010ff857819ULL, 0x000fe40000011664ULL,
0x0000ffff64827812ULL, 0x000fe400078ec0ffULL, 0x00000018ff677819ULL, 0x000fe20000011665ULL,
0x0000007c1008723cULL, 0x002fe20000041808ULL, 0x00000010ff8a7819ULL, 0x000fe40000011692ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165eULL, 0x000000ff5f5f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff65647812ULL, 0x000fe200078ec0ffULL, 0x0000007c0c04723cULL, 0x000be20000041804ULL,
0x00000018ff887819ULL, 0x000fe40000011666ULL, 0x000010548e8d7816ULL, 0x000fe4000000009bULL,
0x00001054898c7816ULL, 0x000fe4000000008cULL, 0x00000010ff5e7819ULL, 0x000fe4000001168fULL,
0x00000008ff777819ULL, 0x000fc40000011677ULL, 0x00000010ff9a7819ULL, 0x000fe2000001169aULL,
0x0000008c5840723cULL, 0x080fe20000041840ULL, 0x00000010ff8b7819ULL, 0x000fe40000011699ULL,
0x00000010ff947819ULL, 0x000fe40000011694ULL, 0x00000010ff937819ULL, 0x000fe40000011693ULL,
0x00000010ff897819ULL, 0x000fe20000011690ULL, 0x0000008c1c44723cULL, 0x000fe20000041844ULL,
0x00000010ff9e7819ULL, 0x000fc4000001169eULL, 0x00000010ff8e7819ULL, 0x000fe4000001169fULL,
0x00000010ff8f7819ULL, 0x000fe40000011695ULL, 0x00000010ff917819ULL, 0x000fe40000011691ULL,
0x0000ffff66847812ULL, 0x000fe400078ec0ffULL, 0x000010545d8a7816ULL, 0x000fe4000000008aULL,
0x00000067ff67723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000088ff5d723eULL, 0x000fe200020006ffULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000077ff77723eULL, 0x000fe200020006ffULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff837819ULL, 0x000fe20000011666ULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x000000ff66867812ULL, 0x000fe200078ec0ffULL, 0x20000077ff777230ULL, 0x000fe20000004100ULL,
0x000010549a8b7816ULL, 0x000fc4000000008bULL, 0x0000105494897816ULL, 0x000fe40000000089ULL,
0x000010545e887816ULL, 0x000fe40000000093ULL, 0x000010549e8f7816ULL, 0x000fe2000000008fULL,
0x0000008a5824723cULL, 0x000fe20000041824ULL, 0x00001054918e7816ULL, 0x000fe4000000008eULL,
0x00000010ff667819ULL, 0x104fe40000011660ULL, 0x00000018ff7f7819ULL, 0x000fc40000011660ULL,
0x000000ff607e7812ULL, 0x040fe200078ec0ffULL, 0x000000885830723cULL, 0x040fe20000041830ULL,
0x0000ffff60797812ULL, 0x000fe400078ec0ffULL, 0x00000010ff787819ULL, 0x100fe40000011661ULL,
0x00000018ff807819ULL, 0x000fe40000011661ULL, 0x000000ff61817812ULL, 0x000fe200078ec0ffULL,
0x0000008e5838723cULL, 0x000be20000041838ULL, 0x00000010ff607819ULL, 0x000fc40000011662ULL,
0x00000018ff7c7819ULL, 0x020fe40000011662ULL, 0x000000ff627d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff657819ULL, 0x100fe20000011663ULL, 0x0000008a1c2c723cULL, 0x000f62000004182cULL,
0x00000018ff7b7819ULL, 0x000fe40000011663ULL, 0x000000ff637a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff847819ULL, 0x000fc40000011684ULL, 0x0000ffff61617812ULL, 0x000fe200078ec0ffULL,
0x000000881c4c723cULL, 0x040f62000004184cULL, 0x0000ffff62627812ULL, 0x000fe400078ec0ffULL,
0x0000ffff63637812ULL, 0x000fe400078ec0ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x00000008ff827819ULL, 0x000fe20000011682ULL, 0x0000008e1c20723cULL, 0x000b620000041820ULL,
0x00000084ff84723eULL, 0x000fe200020006ffULL, 0x20000086ff867230ULL, 0x000fe20000004100ULL,
0x000000ff85857812ULL, 0x000fc400078ec0ffULL, 0x000000ff83837812ULL, 0x000fe200078ec0ffULL,
0x20000084ff847230ULL, 0x000fe20000004100ULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x00000008ff797819ULL, 0x000fe40000011679ULL, 0x000000ff78787812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x000000ff60607812ULL, 0x000fc400078ec0ffULL,
0x00000008ff627819ULL, 0x000fe40000011662ULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff587819ULL, 0x000fe40000011667ULL,
0x00000010ff597819ULL, 0x000fe4000001165fULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff777819ULL, 0x000fe40000011677ULL, 0x00000082ff82723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x20000082ff827230ULL, 0x000fe20000004100ULL, 0x0000007fff7f723eULL, 0x000fe200020006ffULL,
0x20000085ff857230ULL, 0x000fe20000004100ULL, 0x0000007eff7e723eULL, 0x000fe200020006ffULL,
0x20000083ff5a7230ULL, 0x000fe20000004100ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x2000007fff7f7230ULL, 0x000fe20000004100ULL, 0x00000081ff81723eULL, 0x000fe200020006ffULL,
0x2000007eff7e7230ULL, 0x000fe20000004100ULL, 0x0000007cff7c723eULL, 0x000fe200020006ffULL,
0x20000080ff807230ULL, 0x000fe20000004100ULL, 0x0000007dff7d723eULL, 0x000fe200020006ffULL,
0x20000081ff817230ULL, 0x000fe20000004100ULL, 0x0000007bff7b723eULL, 0x000fe200020006ffULL,
0x2000007cff7c7230ULL, 0x000fe20000004100ULL, 0x0000007aff7a723eULL, 0x000fe200020006ffULL,
0x2000007dff7d7230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x2000007bff7b7230ULL, 0x000fe20000004100ULL, 0x00000079ff79723eULL, 0x000fe200020006ffULL,
0x2000007aff7a7230ULL, 0x000fe20000004100ULL, 0x00000078ff78723eULL, 0x000fe200020006ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000079ff797230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000078ff787230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000063ff1e723eULL, 0x020fe200020006ffULL,
0x20000062ff627230ULL, 0x000fe20000004100ULL, 0x0000105458597816ULL, 0x000fe20000000059ULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x0000105477587816ULL, 0x000fe20000000064ULL,
0x2000001eff1e7230ULL, 0x000fe20000004100ULL, 0x00000010ff867819ULL, 0x000fc40000011686ULL,
0x00000010ff1d7819ULL, 0x000fe40000011684ULL, 0x00000010ff877819ULL, 0x000fe20000011687ULL,
0x00000058103c723cULL, 0x080f62000004183cULL, 0x00000010ff827819ULL, 0x000fe40000011682ULL,
0x000010541d867816ULL, 0x000fe40000000086ULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff837819ULL, 0x000fe20000011685ULL, 0x000000580c28723cULL, 0x000b620000041828ULL,
0x00000010ff5d7819ULL, 0x000fc4000001165dULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff7f7819ULL, 0x000fe4000001167fULL, 0x00000010ff7e7819ULL, 0x000fe4000001167eULL,
0x00000010ff667819ULL, 0x000fe40000011666ULL, 0x00000010ff797819ULL, 0x000fe40000011679ULL,
0x00000010ff807819ULL, 0x000fc40000011680ULL, 0x00000010ff1d7819ULL, 0x000fe40000011678ULL,
0x00000010ff817819ULL, 0x000fe40000011681ULL, 0x00000010ff1c7819ULL, 0x000fe40000011661ULL,
0x00000010ff637819ULL, 0x000fe4000001167cULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000010ff7d7819ULL, 0x000fc4000001167dULL, 0x00000010ff627819ULL, 0x000fe40000011662ULL,
0x00000010ff587819ULL, 0x020fe4000001167bULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x00000010ff7a7819ULL, 0x000fe4000001167aULL, 0x00000010ff1f7819ULL, 0x000fe4000001161eULL,
0x0000105482827816ULL, 0x000fc40000000087ULL, 0x000010545c837816ULL, 0x000fe40000000083ULL,
0x000010545d877816ULL, 0x000fe4000000005aULL, 0x000010547f7f7816ULL, 0x000fe40000000066ULL,
0x00001054797e7816ULL, 0x000fe2000000007eULL, 0x000000820c54723cULL, 0x000f620000041854ULL,
0x00001054801d7816ULL, 0x000fe4000000001dULL, 0x000010541c1c7816ULL, 0x000fc40000000081ULL,
0x0000105463637816ULL, 0x000fe40000000060ULL, 0x0000105462627816ULL, 0x000fe2000000007dULL,
0x000000860c34723cULL, 0x000f620000041834ULL, 0x00001054587b7816ULL, 0x000fe40000000065ULL,
0x000010541f7a7816ULL, 0x000fe4000000007aULL, 0x0000000273737810ULL, 0x000fc60007ffe0ffULL,
0x0000007e0c2c723cULL, 0x040f70000004182cULL, 0x0000001c0c44723cULL, 0x040f700000041844ULL,
0x000000620c4c723cULL, 0x040f70000004184cULL, 0x0000007a0c20723cULL, 0x000b6e0000041820ULL,
0x00000004750c7810ULL, 0x060fe20007ffe0ffULL, 0x000000821050723cULL, 0x000b620000041850ULL,
0xfffffff4750d7810ULL, 0x000fc40007ffe0ffULL, 0x000000180c00780cULL, 0x000fe20003f25270ULL,
0x000000ffff757224ULL, 0x000fc800078e000cULL, 0x000000861048723cULL, 0x040b700000041848ULL,
0x0000007e1024723cULL, 0x040b700000041824ULL, 0x0000001c1040723cULL, 0x040b700000041840ULL,
0x000000621030723cULL, 0x040b700000041830ULL, 0x0000007a1038723cULL, 0x000b620000041838ULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffe5e000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff717224ULL, 0x000fe200078e0017ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd94000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000006c51517220ULL, 0x0a0fe20000410000ULL,
0x0000006c48487220ULL, 0x080fe20000410000ULL, 0x0000006c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000006c24247220ULL, 0x080fe20000410000ULL, 0x0000006c25257220ULL, 0x080fe20000410000ULL,
0x0000006c40407220ULL, 0x080fe20000410000ULL, 0x0000006c50507220ULL, 0x080fe20000410000ULL,
0x0000006c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000006c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000006c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000006c49497220ULL, 0x080fe20000410000ULL,
0x0000006c26267220ULL, 0x080fe20000410000ULL, 0x0000006c27277220ULL, 0x080fe20000410000ULL,
0x0000006c41417220ULL, 0x080fe20000410000ULL, 0x0000006c31317220ULL, 0x080fe20000410000ULL,
0x0000006c32327220ULL, 0x080fe20000410000ULL, 0x0000006c28287220ULL, 0x080fe20000410000ULL,
0x0000006c29297220ULL, 0x080fe20000410000ULL, 0x0000006c06587220ULL, 0x080fe20000410000ULL,
0x0000006c52527220ULL, 0x080fe20000410000ULL, 0x0000006c53537220ULL, 0x080fe20000410000ULL,
0x0000006c4a0c7220ULL, 0x080fe20000410000ULL, 0x0000006c4b0d7220ULL, 0x080fe20000410000ULL,
0x0000006c08087220ULL, 0x080fe20000410000ULL, 0x0000006c09097220ULL, 0x080fe20000410000ULL,
0x0000006c0a0a7220ULL, 0x080fe20000410000ULL, 0x0000006c0b0b7220ULL, 0x080fe20000410000ULL,
0x0000006c420e7220ULL, 0x080fe20000410000ULL, 0x0000006c430f7220ULL, 0x080fe20000410000ULL,
0x0000006c30307220ULL, 0x080fe20000410000ULL, 0x0000006c3a107220ULL, 0x080fe20000410000ULL,
0x0000006c3b117220ULL, 0x080fe20000410000ULL, 0x0000006c54547220ULL, 0x080fe20000410000ULL,
0x0000006c55557220ULL, 0x080fe20000410000ULL, 0x0000006c2a1e7220ULL, 0x080fe20000410000ULL,
0x0000006c34127220ULL, 0x080fe20000410000ULL, 0x0000006c35137220ULL, 0x080fe20000410000ULL,
0x0000006c04047220ULL, 0x080fe20000410000ULL, 0x0000006c05057220ULL, 0x080fe20000410000ULL,
0x0000006c4c067220ULL, 0x080fe20000410000ULL, 0x0000006c4e5e7220ULL, 0x080fe20000410000ULL,
0x0000006c2b1f7220ULL, 0x080fe20000410000ULL, 0x0000006c371c7220ULL, 0x080fe20000410000ULL,
0x0000006c2c2a7220ULL, 0x080fe20000410000ULL, 0x0000006c2e5a7220ULL, 0x080fe20000410000ULL,
0x0000006c475d7220ULL, 0x080fe20000410000ULL, 0x000000ffff4e7224ULL, 0x000fe200078e0051ULL,
0x0000006c361d7220ULL, 0x080fe20000410000ULL, 0x000000ffff4b7224ULL, 0x000fe200078e0048ULL,
0x0000006c07597220ULL, 0x080fe20000410000ULL, 0x0000006c2d2b7220ULL, 0x080fe20000410000ULL,
0x0000006c442c7220ULL, 0x080fe20000410000ULL, 0x0000006c465c7220ULL, 0x080fe20000410000ULL,
0x0000006c4d2e7220ULL, 0x080fe20000410000ULL, 0x0000006c4f5f7220ULL, 0x080fe20000410000ULL,
0x000000ffff517224ULL, 0x000fe200078e0024ULL, 0x0000006c38437220ULL, 0x080fe20000410000ULL,
0x000000ffff487224ULL, 0x000fe200078e0025ULL, 0x0000006c39427220ULL, 0x080fe20000410000ULL,
0x000000ffff477224ULL, 0x000fe200078e0040ULL, 0x0000006c2f5b7220ULL, 0x080fe20000410000ULL,
0x000000ffff377224ULL, 0x000fe200078e003eULL, 0x0000006c452d7220ULL, 0x080fe20000410000ULL,
0x0000006c21077220ULL, 0x080fe20000410000ULL, 0x0000006c23617220ULL, 0x080fe20000410000ULL,
0x000000ffff4f7224ULL, 0x000fe200078e0050ULL, 0x0000006c33337220ULL, 0x080fe20000410000ULL,
0x000000ffff4d7224ULL, 0x000fe200078e003cULL, 0x0000006c56567220ULL, 0x080fe20000410000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e003dULL, 0x0000006c57577220ULL, 0x080fe20000410000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0049ULL, 0x0000006c202f7220ULL, 0x080fe20000410000ULL,
0x000000ffff467224ULL, 0x000fe200078e0041ULL, 0x0000006c22607220ULL, 0x000fe20000410000ULL,
0x000000ffff447224ULL, 0x000fc400078e0031ULL, 0x000000ffff367224ULL, 0x000fe400078e003fULL,
0x000000ffff3b7224ULL, 0x000fe400078e0026ULL, 0x000000ffff407224ULL, 0x000fe400078e0027ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0032ULL, 0x000000ffff247224ULL, 0x000fe400078e0028ULL,
0x000000ffff257224ULL, 0x000fc400078e0029ULL, 0x000000ffff497224ULL, 0x000fe400078e0008ULL,
0x000000ffff507224ULL, 0x000fe400078e0009ULL, 0x000000ffff457224ULL, 0x000fe400078e0030ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0052ULL, 0x000000ffff387224ULL, 0x000fe400078e0053ULL,
0x000000ffff357224ULL, 0x000fc400078e000cULL, 0x000000ffff417224ULL, 0x000fe400078e000dULL,
0x000000ffff397224ULL, 0x000fe400078e000aULL, 0x000000ffff3c7224ULL, 0x000fe400078e000bULL,
0x000000ffff3d7224ULL, 0x000fe400078e000eULL, 0x000000ffff3f7224ULL, 0x000fe400078e000fULL,
0x000000ffff347224ULL, 0x000fc400078e0010ULL, 0x000000ffff317224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fe400078e0054ULL, 0x000000ffff237224ULL, 0x000fe400078e0055ULL,
0x000000ffff267224ULL, 0x000fe400078e0012ULL, 0x000000ffff277224ULL, 0x000fe400078e0013ULL,
0x000000ffff287224ULL, 0x000fc400078e0004ULL, 0x000000ffff297224ULL, 0x000fe400078e0005ULL,
0x000000ffff327224ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000006a087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff307224ULL, 0x000fe400078e0007ULL,
0x000000ffff227224ULL, 0x000fe400078e0056ULL, 0x000000ffff207224ULL, 0x000fe400078e0057ULL,
0x000000ffff137224ULL, 0x000fc400078e0058ULL, 0x000000ffff117224ULL, 0x000fe400078e0059ULL,
0x000000ffff127224ULL, 0x000fe400078e005aULL, 0x000000ffff107224ULL, 0x000fe400078e005bULL,
0x000000ffff0a7224ULL, 0x000fe400078e005cULL, 0x000000ffff0b7224ULL, 0x000fe400078e005dULL,
0x000000ffff0c7224ULL, 0x000fc400078e005eULL, 0x000000ffff0d7224ULL, 0x000fe400078e005fULL,
0x000000ffff0e7224ULL, 0x000fe400078e0060ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0061ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004006a077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000105200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604537210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09005300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c405300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000005306067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000152527810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004006a077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000046e097824ULL, 0x000fe200078e00ffULL,
0x0000006f1400720cULL, 0x000fc80003f06070ULL, 0xfffffff009057812ULL, 0x000fca00078ec0ffULL,
0x000000801a087824ULL, 0x000fca00078e0205ULL, 0x0124000008047984ULL, 0x0002a20000000c00ULL,
0x000021f000008947ULL, 0x000fea0003800000ULL, 0x00005a0000557b06ULL, 0x000ee20000209000ULL,
0x000000ffff527224ULL, 0x000fe200078e00ffULL, 0x000000196e547211ULL, 0x000fe400078ff0ffULL,
0x00005a00ff5f7a12ULL, 0x000fc800078e33ffULL, 0x0000005500557308ULL, 0x008ee40000001000ULL,
0x0ffffffe55577810ULL, 0x008fcc0007ffe0ffULL, 0x0000005700537305ULL, 0x000ee4000021f000ULL,
0x000000ffff597224ULL, 0x008fc800078e0a53ULL, 0x00005a0059597a24ULL, 0x000fc800078e02ffULL,
0x00000059535c7227ULL, 0x000fe200078e0052ULL, 0x0000000854527810ULL, 0x040fe40007ffe0ffULL,
0x0000001054537810ULL, 0x040fe40007ffe0ffULL, 0x0000001854597810ULL, 0x000fe20007ffe0ffULL,
0x000000525c587227ULL, 0x000fc800078e00ffULL, 0x000000545c567227ULL, 0x000fc800078e00ffULL,
0x000000ffff577224ULL, 0x000fe400078e0a58ULL, 0x000000ffff557224ULL, 0x000fe400078e0a56ULL,
0x000000535c5a7227ULL, 0x000fc800078e00ffULL, 0x00005a0057577a24ULL, 0x000fe400078e0252ULL,
0x00005a0055557a24ULL, 0x000fe400078e0254ULL, 0x000000ffff527224ULL, 0x000fe200078e0a5aULL,
0x00005a0057007a0cULL, 0x000fe20003fa6070ULL, 0x000000595c5c7227ULL, 0x000fe200078e00ffULL,
0x00005a0055007a0cULL, 0x000fc60003f06070ULL, 0x00005a0052547a24ULL, 0x000fe400078e0253ULL,
0x0000010014537824ULL, 0x000fe400078e026bULL, 0x000000ffff5e7224ULL, 0x000fe200078e0a5cULL,
0x00005a0054007a0cULL, 0x000fe40003f26070ULL, 0x0000005316527217ULL, 0x000fe20007800000ULL,
0x00005a005e5b7a24ULL, 0x000fe200078e0259ULL, 0x80005a0057575a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0055550a10ULL, 0x000fe20007ffe0ffULL, 0x0000000152527824ULL, 0x000fe200078e0a53ULL,
0x00005a005b007a0cULL, 0x000fe20003f66070ULL, 0x000000026e537824ULL, 0x000fe200078e00ffULL,
0x00005a0057007a0cULL, 0x000fc40003fc6070ULL, 0x00005a0055007a0cULL, 0x000fe40003f46070ULL,
0x0000000653537812ULL, 0x000fe400078ec0ffULL, 0x80005a0054541a10ULL, 0x000fe40007ffe0ffULL,
0x0000000158585810ULL, 0x000fe20007ffe0ffULL, 0x000000011b597824ULL, 0x000fe200078e0253ULL,
0x0000000156560810ULL, 0x000fe20007ffe0ffULL, 0x0000000153557824ULL, 0x000fe200078e0269ULL,
0x00005a0054007a0cULL, 0x000fc40003f86070ULL, 0x000000525900720cULL, 0x000fe20003f06070ULL,
0x0000000155577824ULL, 0x100fe200078e0a52ULL, 0x80005a005b5b3a10ULL, 0x000fe20007ffe0ffULL,
0x0000000159597824ULL, 0x000fe200078e0a52ULL, 0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL,
0x0000000158586810ULL, 0x000fe40007ffe0ffULL, 0x0000000156562810ULL, 0x000fe40007ffe0ffULL,
0x0000005768607217ULL, 0x000fc40003800000ULL, 0x00005a005b007a0cULL, 0x000fe40003f46070ULL,
0x000000565f577207ULL, 0x040fe40006800000ULL, 0x0000005968597217ULL, 0x040fe40003800000ULL,
0x000000585f5b7207ULL, 0x000fe40006800000ULL, 0x0000005768547217ULL, 0x000fe40003800000ULL,
0x00000004ff597819ULL, 0x000fc40000011659ULL, 0x000000015a5a1810ULL, 0x000fe20007ffe0ffULL,
0x000000546d857224ULL, 0x000fe200078e02ffULL, 0x0000005b68567217ULL, 0x000fe40003800000ULL,
0x000000525500720cULL, 0x000fe40003fc6070ULL, 0x000000015c5c3810ULL, 0x000fe20007ffe0ffULL,
0x000000566d897224ULL, 0x000fe200078e02ffULL, 0x000000ff595e7207ULL, 0x000fe40000000000ULL,
0x000000015a5a4810ULL, 0x000fc40007ffe0ffULL, 0x000000ff60607207ULL, 0x000fe20003000000ULL,
0x000000015e5d7824ULL, 0x000fe200078e0289ULL, 0x000000015c5c2810ULL, 0x000fe20007ffe0ffULL,
0x00000001855b7824ULL, 0x000fe200078e025eULL, 0x0000005a5f577207ULL, 0x000fe40006800000ULL,
0x0000008560597211ULL, 0x000fe200078fe0ffULL, 0x000000025b5a7825ULL, 0x100fe200078e0002ULL,
0x0000005c5f5f7207ULL, 0x000fe40006800000ULL, 0x0000005768567217ULL, 0x040fe20003800000ULL,
0x000000025d5c7825ULL, 0x000fe200078e0002ULL, 0x000000065a547981ULL, 0x000722000c1e9500ULL,
0x0000005f68627217ULL, 0x000fc40003800000ULL, 0x0000000259587825ULL, 0x000fc800078e0002ULL,
0x000000566d8b7224ULL, 0x000fe200078e02ffULL, 0x0000000658577981ULL, 0x000328000c1e9500ULL,
0x000000065c567981ULL, 0x000522000c1e9500ULL, 0x0000008960637211ULL, 0x000fe200078fe0ffULL,
0x000000015e677824ULL, 0x000fe200078e028bULL, 0x0000008b60657211ULL, 0x000fe400078fe0ffULL,
0x00000010535d7812ULL, 0x004fe200078efcffULL, 0x000000626d8d7224ULL, 0x000fc800078e02ffULL,
0x000000011b777824ULL, 0x000fe400078e025dULL, 0x0000000263627825ULL, 0x000fc800078e0002ULL,
0x0000000267667825ULL, 0x100fe200078e0002ULL, 0x0000000662597981ULL, 0x0022a6000c1e9500ULL,
0x0000000265647825ULL, 0x000fe200078e0002ULL, 0x0000000666587981ULL, 0x0002a6000c1e9500ULL,
0x0000000177757824ULL, 0x000fe200078e0a52ULL, 0x00000006645b7981ULL, 0x0086a2000c1e9500ULL,
0x000000015d5f7824ULL, 0x000fe200078e0269ULL, 0x0000008d60717211ULL, 0x000fc400078fe0ffULL,
0x00000075685c7217ULL, 0x000fe20003800000ULL, 0x000000015f757824ULL, 0x000fe200078e0a52ULL,
0x000000527700720cULL, 0x080fe20003f26070ULL, 0x000000015e737824ULL, 0x000fe200078e028dULL,
0x00000004ff5c7819ULL, 0x000fe2000001165cULL, 0x0000000271707825ULL, 0x100fe200078e0002ULL,
0x000000525f00720cULL, 0x000fe40003f06070ULL, 0x0000007568757217ULL, 0x000fe20003800000ULL,
0x0000000273727825ULL, 0x000fe200078e0002ULL, 0x000000ff5c667207ULL, 0x002fe20000800000ULL,
0x0000000670617981ULL, 0x0002a2000c1e9500ULL, 0x000000ff757a7207ULL, 0x000fc40000000000ULL,
0x0000002053797812ULL, 0x000fe200078efcffULL, 0x00000006725a7981ULL, 0x0002a2000c1e9500ULL,
0x000000857a637211ULL, 0x040fe200078fe0ffULL, 0x0000000185657824ULL, 0x008fe200078e0266ULL,
0x000000897a677211ULL, 0x000fe200078fe0ffULL, 0x0000000166717824ULL, 0x002fe400078e0289ULL,
0x000000011b817824ULL, 0x000fe400078e0279ULL, 0x0000000271707825ULL, 0x000fc800078e0002ULL,
0x0000000265647825ULL, 0x100fe200078e0002ULL, 0x00000006705e7981ULL, 0x0002e6000c1e9500ULL,
0x0000000263627825ULL, 0x000fe200078e0002ULL, 0x00000006645c7981ULL, 0x0002e6000c1e9500ULL,
0x0000000166757824ULL, 0x040fe400078e028bULL, 0x00000001667f7824ULL, 0x000fe200078e028dULL,
0x0000000662637981ULL, 0x0002e2000c1e9500ULL, 0x0000000267667825ULL, 0x000fe200078e0002ULL,
0x0000008d7a7d7211ULL, 0x000fc600078fe0ffULL, 0x0000000181717824ULL, 0x102fe200078e0a52ULL,
0x0000000666657981ULL, 0x0002e2000c1e9500ULL, 0x00000001797b7824ULL, 0x000fe200078e0269ULL,
0x0000008b7a737211ULL, 0x000fe400078fe0ffULL, 0x0000007168707217ULL, 0x000fe20003800000ULL,
0x000000017b717824ULL, 0x000fe400078e0a52ULL, 0x000000027d7c7825ULL, 0x000fe200078e0002ULL,
0x000000528100720cULL, 0x000fc60003f26070ULL, 0x0000000273727825ULL, 0x000fe200078e0002ULL,
0x000000527b00720cULL, 0x000fe20003f06070ULL, 0x000000067c7d7981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff707819ULL, 0x000fe20000011670ULL, 0x0000000275747825ULL, 0x100fe200078e0002ULL,
0x0000007168717217ULL, 0x000fe20003800000ULL, 0x0000000672777981ULL, 0x0002e4000c1e9500ULL,
0x000000027f7e7825ULL, 0x000fe400078e0002ULL, 0x0000000674627981ULL, 0x0002e4000c1e9500ULL,
0x000000ff717c7207ULL, 0x002fc40000000000ULL, 0x000000067e647981ULL, 0x0002e2000c1e9500ULL,
0x000000ff70727207ULL, 0x000fe40000800000ULL, 0x000000897c737211ULL, 0x000fc600078fe0ffULL,
0x0000000172817824ULL, 0x000fe200078e0289ULL, 0x000000857c677211ULL, 0x000fe200078fe0ffULL,
0x0000000185717824ULL, 0x000fe400078e0272ULL, 0x0000000172757824ULL, 0x040fe400078e028bULL,
0x00000001728f7824ULL, 0x000fe400078e028dULL, 0x0000000281807825ULL, 0x000fc800078e0002ULL,
0x0000000273727825ULL, 0x100fe200078e0002ULL, 0x0000000680787981ULL, 0x0002e2000c1e9500ULL,
0x0000008d7c877211ULL, 0x040fe400078fe0ffULL, 0x0000000267667825ULL, 0x100fe200078e0002ULL,
0x0000000672cf7981ULL, 0x0002e2000c1e9500ULL, 0x0000003053b57812ULL, 0x000fe400078efcffULL,
0x0000000271707825ULL, 0x100fe200078e0002ULL, 0x0000008b7c7f7211ULL, 0x002fe200078fe0ffULL,
0x0000000666837981ULL, 0x0002e4000c1e9500ULL, 0x0000000275747825ULL, 0x000fc400078e0002ULL,
0x0000000670767981ULL, 0x0002e4000c1e9500ULL, 0x000000027f7e7825ULL, 0x100fe400078e0002ULL,
0x00000006748c7981ULL, 0x0002e4000c1e9500ULL, 0x0000000287667825ULL, 0x002fe400078e0002ULL,
0x000000067ed37981ULL, 0x0002e4000c1e9500ULL, 0x000000011b877824ULL, 0x000fc400078e02b5ULL,
0x000000028f707825ULL, 0x000fe200078e0002ULL, 0x0000000666d77981ULL, 0x0002e6000c1e9500ULL,
0x0000000187817824ULL, 0x000fe200078e0a52ULL, 0x0000000670907981ULL, 0x0002e2000c1e9500ULL,
0x00000001b5b77824ULL, 0x000fc600078e0269ULL, 0x0000008168807217ULL, 0x040fe20003800000ULL,
0x00000001b7817824ULL, 0x000fe200078e0a52ULL, 0x000000528700720cULL, 0x080fe40003f26070ULL,
0x00000052b700720cULL, 0x000fe40003f06070ULL, 0x00000004ff807819ULL, 0x000fe40000011680ULL,
0x0000008168817217ULL, 0x000fe40003800000ULL, 0x000000ff80847207ULL, 0x000fc40000800000ULL,
0x000000ff81827207ULL, 0x000fc60000000000ULL, 0x00000001857f7824ULL, 0x002fe200078e0284ULL,
0x0000008582817211ULL, 0x000fe200078fe0ffULL, 0x0000000184737824ULL, 0x000fe200078e028bULL,
0x0000008b82757211ULL, 0x000fe200078fe0ffULL, 0x000000027f7e7825ULL, 0x000fc800078e0002ULL,
0x0000000281807825ULL, 0x100fe200078e0002ULL, 0x000000067e867981ULL, 0x0002e6000c1e9500ULL,
0x0000000273727825ULL, 0x100fe200078e0002ULL, 0x0000000680b97981ULL, 0x0002e6000c1e9500ULL,
0x0000000275747825ULL, 0x000fe200078e0002ULL, 0x00000006728e7981ULL, 0x0002e2000c1e9500ULL,
0x0000008982717211ULL, 0x000fc600078fe0ffULL, 0x0000000674d57981ULL, 0x0002e2000c1e9500ULL,
0x0000000184677824ULL, 0x000fe400078e0289ULL, 0x0000000271707825ULL, 0x000fc800078e0002ULL,
0x0000000267667825ULL, 0x000fe200078e0002ULL, 0x0000000670d17981ULL, 0x0002e4000c1e9500ULL,
0x0000008d827f7211ULL, 0x002fe400078fe0ffULL, 0x00000006668a7981ULL, 0x0002e2000c1e9500ULL,
0x0000000184817824ULL, 0x000fe400078e028dULL, 0x000000027f7e7825ULL, 0x000fc800078e0002ULL,
0x0000000281807825ULL, 0x000fe200078e0002ULL, 0x000000067ed97981ULL, 0x0002e8000c1e9500ULL,
0x0000000680927981ULL, 0x0002e4000c1e9500ULL, 0xfffffff060677812ULL, 0x002fe200078ec0ffULL,
0x00000001ffcd7424ULL, 0x000fc800078e00ffULL, 0x0000000152607824ULL, 0x000fe200078e0267ULL,
0xfffffff07a677812ULL, 0x000fc600078ec0ffULL, 0x0000000155667824ULL, 0x000fe200078e0a60ULL,
0x0000000153857812ULL, 0x000fe200078efcffULL, 0x0000000152747824ULL, 0x000fc600078e0267ULL,
0x00000066cd677219ULL, 0x000fe200000006ffULL, 0x0000000185717824ULL, 0x000fe200078e0269ULL,
0xfffffff07c737812ULL, 0x000fc600078ec0ffULL, 0x0000000171707824ULL, 0x100fe200078e0a60ULL,
0x0000000853877812ULL, 0x040fe200078efcffULL, 0x00000001527a7824ULL, 0x000fe200078e0273ULL,
0x0000000953897812ULL, 0x000fe400078efcffULL, 0x00000070cd737219ULL, 0x000fe200000006ffULL,
0x0000000187757824ULL, 0x100fe400078e0269ULL, 0x0000000189817824ULL, 0x000fe200078e0269ULL,
0xfffffff0827f7812ULL, 0x000fe200078ec0ffULL, 0x0000000175727824ULL, 0x000fc400078e0a60ULL,
0x0000000181607824ULL, 0x000fe200078e0a60ULL, 0x00000011538f7812ULL, 0x000fe200078efcffULL,
0x0000000152807824ULL, 0x000fe200078e027fULL, 0x00000072cd7f7219ULL, 0x040fe400000006ffULL,
0x00000060cd8b7219ULL, 0x000fe200000006ffULL, 0x000000018f917824ULL, 0x000fe400078e0269ULL,
0x000000015f607824ULL, 0x100fe400078e0a74ULL, 0x0000000191667824ULL, 0x000fe200078e0a74ULL,
0x0000541057547816ULL, 0x010fc80000000054ULL, 0x0000005467ff7212ULL, 0x000fc800078ac0ffULL,
0x000000525500720cULL, 0x000fc80002fa1470ULL, 0x000000525300720cULL, 0x000fe40002fa1070ULL,
0x0000005473ff7212ULL, 0x000fe4000782c0ffULL, 0xff8000004f4f7808ULL, 0x000fe40002800000ULL,
0x000000527100720cULL, 0x000fe40000f21470ULL, 0x0000541059567816ULL, 0x004fc80000000056ULL,
0x0000005667ff7212ULL, 0x080fe4000784c0ffULL, 0x000054105b587816ULL, 0x000fe40000000058ULL,
0x0000005673ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005867ff7212ULL, 0x000fe4000788c0ffULL,
0x000000525500720cULL, 0x0c0fe40001741470ULL, 0x000000525500720cULL, 0x000fc40002781470ULL,
0x000000527100720cULL, 0x080fe40002fa1470ULL, 0x000000525300720cULL, 0x0c0fe40001741070ULL,
0x000000525300720cULL, 0x080fe40002781070ULL, 0x000000528500720cULL, 0x0c0fe40000f21070ULL,
0x000000528500720cULL, 0x000fe40002fa1070ULL, 0x00005410615a7816ULL, 0x000fc4000000005aULL,
0xff8000003a3a7808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fe40002000000ULL,
0xff8000004e4e7808ULL, 0x000fe40000800000ULL, 0xff80000038387808ULL, 0x000fe40002800000ULL,
0x000000547fff7212ULL, 0x000fe4000786c0ffULL, 0x0000005a67ff7212ULL, 0x000fc4000780c0ffULL,
0x0000005873ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005a73ff7212ULL, 0x000fe4000788c0ffULL,
0x000000568bff7212ULL, 0x000fe4000782c0ffULL, 0x000000587fff7212ULL, 0x000fe400078ac0ffULL,
0x000000525500720cULL, 0x080fe40000701470ULL, 0x000000527100720cULL, 0x000fc40001741470ULL,
0x000000527100720cULL, 0x080fe40002781470ULL, 0x000000527500720cULL, 0x0c0fe40001f61470ULL,
0x000000527500720cULL, 0x080fe40002fa1470ULL, 0x000000528100720cULL, 0x000fe40000f21470ULL,
0x0000001853957812ULL, 0x040fe400078efcffULL, 0x00000019539b7812ULL, 0x000fc400078efcffULL,
0x000000525300720cULL, 0x080fe40000701070ULL, 0x000000528500720cULL, 0x0c0fe40001741070ULL,
0x000000528500720cULL, 0x080fe40002781070ULL, 0x000000528700720cULL, 0x0c0fe40001f61070ULL,
0x000000528700720cULL, 0x080fe40002fa1070ULL, 0x000000528900720cULL, 0x000fc40000f21070ULL,
0x00000060cd8d7219ULL, 0x040fe400000006ffULL, 0x00000066cd937219ULL, 0x000fe400000006ffULL,
0x00005410635c7816ULL, 0x008fe4000000005cULL, 0x00005410655e7816ULL, 0x000fe2000000005eULL,
0x0000000195977824ULL, 0x100fe200078e0269ULL, 0xff80000022227808ULL, 0x000fe20000000000ULL,
0x000000019b9d7824ULL, 0x000fe200078e0269ULL, 0xff80000023237808ULL, 0x000fc40001000000ULL,
0xff80000020207808ULL, 0x000fe40002000000ULL, 0xff8000004d4d7808ULL, 0x000fe40001800000ULL,
0xff80000024247808ULL, 0x000fe40002800000ULL, 0xff80000036367808ULL, 0x000fe40000800000ULL,
0x000000567fff7212ULL, 0x000fe4000780c0ffULL, 0x000000588bff7212ULL, 0x000fc4000784c0ffULL,
0x0000005a7fff7212ULL, 0x080fe4000788c0ffULL, 0x0000005a8bff7212ULL, 0x000fe4000786c0ffULL,
0x0000005c93ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005e8dff7212ULL, 0x000fe2000782c0ffULL,
0x0000000197707824ULL, 0x100fe200078e0a74ULL, 0x000000527500720cULL, 0x080fe20000701470ULL,
0x000000019d747824ULL, 0x000fe200078e0a74ULL, 0x000000527500720cULL, 0x000fc40002781470ULL,
0x000000528100720cULL, 0x0c0fe40001741470ULL, 0x000000528100720cULL, 0x080fe40001f61470ULL,
0x000000525f00720cULL, 0x080fe40000f21470ULL, 0x000000529100720cULL, 0x080fe40002fa1470ULL,
0x000000528700720cULL, 0x0c0fe40000701070ULL, 0x000000528700720cULL, 0x000fc40002781070ULL,
0x000000528900720cULL, 0x0c0fe40001741070ULL, 0x000000528900720cULL, 0x080fe40001f61070ULL,
0x000000525d00720cULL, 0x080fe40000f21070ULL, 0x000000528f00720cULL, 0x000fe40002fa1070ULL,
0x00000070cd997219ULL, 0x040fe400000006ffULL, 0x00000074cd9f7219ULL, 0x000fc400000006ffULL,
0x0000541077627816ULL, 0x000fe40000000062ULL, 0x000054107d647816ULL, 0x000fe40000000064ULL,
0xff80000037377808ULL, 0x000fe40000000000ULL, 0xff8000001e1e7808ULL, 0x000fe40002000000ULL,
0xff80000025257808ULL, 0x000fe40001000000ULL, 0xff8000001f1f7808ULL, 0x000fc40001800000ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fe40002800000ULL,
0x0000005c8dff7212ULL, 0x080fe4000780c0ffULL, 0x0000005c99ff7212ULL, 0x000fe4000788c0ffULL,
0x000000628dff7212ULL, 0x040fe4000784c0ffULL, 0x000000648dff7212ULL, 0x000fc4000786c0ffULL,
0x0000006293ff7212ULL, 0x000fe4000782c0ffULL, 0x0000005e9fff7212ULL, 0x000fe200078ac0ffULL,
0x000000017b727824ULL, 0x000fe200078e0a7aULL, 0x000000525f00720cULL, 0x0c0fe40000701470ULL,
0x000000525f00720cULL, 0x0c0fe40001741470ULL, 0x000000525f00720cULL, 0x080fe40001f61470ULL,
0x000000529100720cULL, 0x000fc40000f21470ULL, 0x000000529700720cULL, 0x080fe40002781470ULL,
0x000000529d00720cULL, 0x080fe40002fa1470ULL, 0x0000002153a37812ULL, 0x000fe400078efcffULL,
0x000000525d00720cULL, 0x0c0fe40000701070ULL, 0x000000525d00720cULL, 0x0c0fe40001741070ULL,
0x000000525d00720cULL, 0x000fc40001f61070ULL, 0x000000528f00720cULL, 0x080fe40000f21070ULL,
0x000000529500720cULL, 0x080fe40002781070ULL, 0x000000529b00720cULL, 0x000fe40002fa1070ULL,
0x00000072cda17219ULL, 0x000fe400000006ffULL, 0x00005410cf787816ULL, 0x000fe20000000078ULL,
0x00000001a3a57824ULL, 0x000fe200078e0269ULL, 0xff8000004b4b7808ULL, 0x000fc40000000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40000800000ULL, 0xff80000049497808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fe40002800000ULL, 0x0000005e93ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006493ff7212ULL, 0x000fe4000784c0ffULL, 0x0000005e99ff7212ULL, 0x000fe4000786c0ffULL,
0x000000629fff7212ULL, 0x040fe4000782c0ffULL, 0x000000649fff7212ULL, 0x000fe4000788c0ffULL,
0x00000078a1ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a57c7824ULL, 0x000fe200078e0a7aULL,
0x000000529100720cULL, 0x000fc40000701470ULL, 0x000000529100720cULL, 0x080fe40001741470ULL,
0x000000529700720cULL, 0x080fe40001f61470ULL, 0x000000529d00720cULL, 0x0c0fe40000f21470ULL,
0x000000529d00720cULL, 0x080fe40002781470ULL, 0x000000527b00720cULL, 0x000fe40002fa1470ULL,
0x0000002853a97812ULL, 0x000fc400078efcffULL, 0x0000002953af7812ULL, 0x000fe400078efcffULL,
0x000000528f00720cULL, 0x0c0fe40000701070ULL, 0x000000528f00720cULL, 0x080fe40001741070ULL,
0x000000529500720cULL, 0x080fe40001f61070ULL, 0x000000529b00720cULL, 0x0c0fe40000f21070ULL,
0x000000529b00720cULL, 0x000fc40002781070ULL, 0x000000527900720cULL, 0x000fe40002fa1070ULL,
0x0000007ccda77219ULL, 0x000fe400000006ffULL, 0x0000541083767816ULL, 0x000fe40000000076ULL,
0x00005410d38c7816ULL, 0x000fe4000000008cULL, 0x00005410d7907816ULL, 0x000fe20000000090ULL,
0x00000001a9ab7824ULL, 0x100fe200078e0269ULL, 0xff80000041417808ULL, 0x000fe20000000000ULL,
0x00000001afb17824ULL, 0x000fe200078e0269ULL, 0xff8000001c1c7808ULL, 0x000fc40001000000ULL,
0xff80000039397808ULL, 0x000fe40001800000ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40002800000ULL,
0x000000548bff7212ULL, 0x000fe400078cc0ffULL, 0x0000006299ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006499ff7212ULL, 0x000fe4000784c0ffULL, 0x00000076a1ff7212ULL, 0x040fe4000786c0ffULL,
0x0000008ca1ff7212ULL, 0x040fe4000782c0ffULL, 0x00000090a1ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008ca7ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ab7e7824ULL, 0x100fe200078e0a7aULL,
0x000000528100720cULL, 0x080fe200037c1470ULL, 0x00000001b17a7824ULL, 0x000fe200078e0a7aULL,
0x000000529700720cULL, 0x000fc40000701470ULL, 0x000000529700720cULL, 0x080fe40001741470ULL,
0x000000527b00720cULL, 0x0c0fe40001f61470ULL, 0x000000527b00720cULL, 0x0c0fe40000f21470ULL,
0x000000527b00720cULL, 0x080fe40002781470ULL, 0x00000052a500720cULL, 0x080fe40002fa1470ULL,
0x000000528900720cULL, 0x000fc400037c1070ULL, 0x000000529500720cULL, 0x0c0fe40000701070ULL,
0x000000529500720cULL, 0x080fe40001741070ULL, 0x000000527900720cULL, 0x0c0fe40001f61070ULL,
0x000000527900720cULL, 0x0c0fe40000f21070ULL, 0x000000527900720cULL, 0x080fe40002781070ULL,
0x00000052a300720cULL, 0x000fc40002fa1070ULL, 0x0000007ecdad7219ULL, 0x040fe400000006ffULL,
0x0000007acdb37219ULL, 0x000fe400000006ffULL, 0xff8000004c4c7808ULL, 0x000fe40003000000ULL,
0xff80000028287808ULL, 0x000fe40000000000ULL, 0xff80000013137808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fc40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000012127808ULL, 0x000fe40002000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002800000ULL,
0x0000005c9fff7212ULL, 0x000fe400078cc0ffULL, 0x00000076a7ff7212ULL, 0x080fe4000780c0ffULL,
0x00000076adff7212ULL, 0x000fc4000784c0ffULL, 0x00000078a7ff7212ULL, 0x040fe4000786c0ffULL,
0x00000090a7ff7212ULL, 0x000fe4000782c0ffULL, 0x00000078adff7212ULL, 0x000fe4000788c0ffULL,
0x0000008cb3ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b7827824ULL, 0x000fe200078e0a80ULL,
0x000000529d00720cULL, 0x080fe400037c1470ULL, 0x00000052a500720cULL, 0x000fc40000701470ULL,
0x00000052a500720cULL, 0x0c0fe40001f61470ULL, 0x00000052a500720cULL, 0x080fe40000f21470ULL,
0x00000052ab00720cULL, 0x0c0fe40001741470ULL, 0x00000052ab00720cULL, 0x080fe40002781470ULL,
0x00000052b100720cULL, 0x000fe40002fa1470ULL, 0x0000003153bd7812ULL, 0x000fc400078efcffULL,
0x0000003853c37812ULL, 0x040fe400078efcffULL, 0x0000003953c97812ULL, 0x000fe400078efcffULL,
0x000000529b00720cULL, 0x080fe400037c1070ULL, 0x00000052a300720cULL, 0x0c0fe40000701070ULL,
0x00000052a300720cULL, 0x0c0fe40001f61070ULL, 0x00000052a300720cULL, 0x000fc40000f21070ULL,
0x00000052a900720cULL, 0x0c0fe40001741070ULL, 0x00000052a900720cULL, 0x080fe40002781070ULL,
0x00000052af00720cULL, 0x000fe40002fa1070ULL, 0x00000082cdbb7219ULL, 0x000fe400000006ffULL,
0x00005410b9867816ULL, 0x000fe40000000086ULL, 0x00005410d58e7816ULL, 0x000fe2000000008eULL,
0x00000001bdbf7824ULL, 0x100fe200078e0269ULL, 0xff80000050507808ULL, 0x000fe20003000000ULL,
0x00000001c3c57824ULL, 0x100fe200078e0269ULL, 0xff80000048487808ULL, 0x000fe20000000000ULL,
0x00000001c9cb7824ULL, 0x000fe200078e0269ULL, 0xff80000040407808ULL, 0x000fc40001800000ULL,
0xff80000010107808ULL, 0x000fe40000800000ULL, 0xff80000047477808ULL, 0x000fe40001000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0x00000076b3ff7212ULL, 0x040fe400078cc0ffULL, 0x00000078b3ff7212ULL, 0x000fc4000780c0ffULL,
0x0000008cadff7212ULL, 0x040fe4000786c0ffULL, 0x00000090adff7212ULL, 0x080fe4000782c0ffULL,
0x00000090b3ff7212ULL, 0x000fe4000784c0ffULL, 0x00000086bbff7212ULL, 0x040fe4000788c0ffULL,
0x0000008ebbff7212ULL, 0x000fe200078ac0ffULL, 0x00000001bf847824ULL, 0x100fe200078e0a80ULL,
0x00000052ab00720cULL, 0x080fe20001f61470ULL, 0x00000001c5887824ULL, 0x100fe200078e0a80ULL,
0x00000052ab00720cULL, 0x080fe20000f21470ULL, 0x00000001cb807824ULL, 0x000fe200078e0a80ULL,
0x00000052b100720cULL, 0x000fc400037c1470ULL, 0x00000052b100720cULL, 0x0c0fe40000701470ULL,
0x00000052b100720cULL, 0x080fe40001741470ULL, 0x00000052b700720cULL, 0x0c0fe40002781470ULL,
0x00000052b700720cULL, 0x000fe40002fa1470ULL, 0x00000084cdc17219ULL, 0x040fe400000006ffULL,
0x00000088cdc77219ULL, 0x000fc400000006ffULL, 0x00000052a900720cULL, 0x0c0fe40001f61070ULL,
0x00000052a900720cULL, 0x080fe40000f21070ULL, 0x00000052af00720cULL, 0x0c0fe400037c1070ULL,
0x00000052af00720cULL, 0x0c0fe40000701070ULL, 0x00000052af00720cULL, 0x080fe40001741070ULL,
0x00000052b500720cULL, 0x000fc40002781070ULL, 0x00000052b500720cULL, 0x000fe40002fa1070ULL,
0x00000080cdcd7219ULL, 0x000fe400000006ffULL, 0x00005410d18a7816ULL, 0x000fe4000000008aULL,
0xff8000002c2c7808ULL, 0x000fe40001800000ULL, 0xff8000000a0a7808ULL, 0x000fe40000800000ULL,
0xff80000046467808ULL, 0x000fc40003000000ULL, 0xff8000003f3f7808ULL, 0x000fe40000000000ULL,
0xff8000000b0b7808ULL, 0x000fe40001000000ULL, 0xff80000045457808ULL, 0x000fe40002000000ULL,
0xff80000032327808ULL, 0x000fe40002800000ULL, 0x00000086c1ff7212ULL, 0x080fe4000786c0ffULL,
0x00000086c7ff7212ULL, 0x000fc4000782c0ffULL, 0x00000086cdff7212ULL, 0x000fe400078cc0ffULL,
0x0000008abbff7212ULL, 0x080fe4000780c0ffULL, 0x0000008ac1ff7212ULL, 0x080fe4000784c0ffULL,
0x0000008ac7ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008ec1ff7212ULL, 0x000fe400078ac0ffULL,
0x00000052b700720cULL, 0x000fc40000701470ULL, 0x00000052bf00720cULL, 0x0c0fe40001f61470ULL,
0x00000052bf00720cULL, 0x0c0fe40001741470ULL, 0x00000052bf00720cULL, 0x080fe40002fa1470ULL,
0x00000052c500720cULL, 0x080fe40000f21470ULL, 0x00000052cb00720cULL, 0x080fe400037c1470ULL,
0x00000052c500720cULL, 0x000fc40002781470ULL, 0x00000052b500720cULL, 0x080fe40000701070ULL,
0x00000052bd00720cULL, 0x0c0fe40001f61070ULL, 0x00000052bd00720cULL, 0x0c0fe40001741070ULL,
0x00000052bd00720cULL, 0x080fe40002fa1070ULL, 0x00000052c300720cULL, 0x080fe40000f21070ULL,
0x00000052c900720cULL, 0x000fc400037c1070ULL, 0x00000052c300720cULL, 0x000fe40002781070ULL,
0x00005410d9927816ULL, 0x000fe40000000092ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff80000044447808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fc40002800000ULL, 0xff80000043437808ULL, 0x000fe40000800000ULL,
0xff80000042427808ULL, 0x000fe40003000000ULL, 0xff80000034347808ULL, 0x000fe40002000000ULL,
0x0000008acdff7212ULL, 0x000fe4000780c0ffULL, 0x0000008ec7ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008ecdff7212ULL, 0x000fc4000784c0ffULL, 0x00000092bbff7212ULL, 0x080fe400078ac0ffULL,
0x00000092c1ff7212ULL, 0x080fe4000782c0ffULL, 0x00000092c7ff7212ULL, 0x080fe400078cc0ffULL,
0x00000092cdff7212ULL, 0x000fe4000788c0ffULL, 0x00000052b700720cULL, 0x080fe40002fa1470ULL,
0x00000052bf00720cULL, 0x000fc40000f21470ULL, 0x00000052c500720cULL, 0x0c0fe40001f61470ULL,
0x00000052c500720cULL, 0x080fe400037c1470ULL, 0x00000052cb00720cULL, 0x0c0fe40000701470ULL,
0x00000052cb00720cULL, 0x0c0fe40001741470ULL, 0x00000052cb00720cULL, 0x080fe40002781470ULL,
0x00000052b500720cULL, 0x000fc40002fa1070ULL, 0x00000052bd00720cULL, 0x080fe40000f21070ULL,
0x00000052c900720cULL, 0x080fe40000701070ULL, 0x00000052c300720cULL, 0x0c0fe40001f61070ULL,
0x00000052c300720cULL, 0x080fe400037c1070ULL, 0x00000052c900720cULL, 0x0c0fe40001741070ULL,
0x00000052c900720cULL, 0x000fc40002781070ULL, 0xff80000031317808ULL, 0x000fe40000000000ULL,
0xff8000002f2f7808ULL, 0x000fe40001800000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff8000000c0c7808ULL, 0x000fe40002800000ULL, 0xff8000000d0d7808ULL, 0x000fe40000800000ULL,
0xff8000000e0e7808ULL, 0x000fc40003000000ULL, 0xff8000000f0f7808ULL, 0x000fc40002000000ULL,
0x0000004f0400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff5a7424ULL, 0x000fe200078e00ffULL,
0x0000003a0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff5b7424ULL, 0x000fe200078e00ffULL,
0x000000210600720bULL, 0x000fe40003f5e000ULL, 0x000000220700720bULL, 0x000fe40003f7e000ULL,
0x000000044f537208ULL, 0x000fe40004000000ULL, 0x000000053a057208ULL, 0x000fc40004800000ULL,
0x0000000621067208ULL, 0x000fe40005000000ULL, 0x0000000722077208ULL, 0x000fe40005800000ULL,
0x0000004e5300720bULL, 0x000fe40003f1e000ULL, 0x000000380500720bULL, 0x000fe40003f3e000ULL,
0x000000230600720bULL, 0x000fe40003f5e000ULL, 0x000000200700720bULL, 0x000fc40003f7e000ULL,
0x000000534e047208ULL, 0x000fe40004000000ULL, 0x0000000538527208ULL, 0x000fe40004800000ULL,
0x0000000623057208ULL, 0x000fe40005000000ULL, 0x0000000720077208ULL, 0x000fe40005800000ULL,
0x0000004d0400720bULL, 0x000fe40003f1e000ULL, 0x000000375200720bULL, 0x000fc40003f3e000ULL,
0x000000240500720bULL, 0x000fe40003f5e000ULL, 0x0000001e0700720bULL, 0x000fe40003f7e000ULL,
0x000000044d537208ULL, 0x000fe40004000000ULL, 0x0000005237557208ULL, 0x000fe40004800000ULL,
0x0000000524047208ULL, 0x000fe40005000000ULL, 0x000000071e067208ULL, 0x000fc40005800000ULL,
0x0000004c5300720bULL, 0x000fe40003f1e000ULL, 0x000000365500720bULL, 0x000fe40003f3e000ULL,
0x000000250400720bULL, 0x000fe40003f5e000ULL, 0x0000001f0600720bULL, 0x000fe40003f7e000ULL,
0x000000534c527208ULL, 0x000fe40004000000ULL, 0x0000005536547208ULL, 0x000fc40004800000ULL,
0x0000000425057208ULL, 0x000fe40005000000ULL, 0x000000061f067208ULL, 0x000fe40005800000ULL,
0x0000004b5200720bULL, 0x000fe40003f1e000ULL, 0x000000355400720bULL, 0x000fe40003f3e000ULL,
0x000000260500720bULL, 0x000fe40003f5e000ULL, 0x0000001d0600720bULL, 0x000fc40003f7e000ULL,
0x000000524b077208ULL, 0x000fe40004000000ULL, 0x0000005435547208ULL, 0x000fe40004800000ULL,
0x0000000526047208ULL, 0x000fe40005000000ULL, 0x000000061d057208ULL, 0x000fe40005800000ULL,
0x0000004a0700720bULL, 0x000fe40003f1e000ULL, 0x000000415400720bULL, 0x000fc40003f3e000ULL,
0x000000270400720bULL, 0x000fe40003f5e000ULL, 0x0000001c0500720bULL, 0x000fe40003f7e000ULL,
0x000000074a067208ULL, 0x000fe40004000000ULL, 0x0000005441547208ULL, 0x000fe40004800000ULL,
0x0000000427077208ULL, 0x000fe40005000000ULL, 0x000000051c047208ULL, 0x000fc40005800000ULL,
0x000000490600720bULL, 0x000fe40003f1e000ULL, 0x000000395400720bULL, 0x000fe40003f3e000ULL,
0x000000280700720bULL, 0x000fe40003f5e000ULL, 0x000000130400720bULL, 0x000fe40003f7e000ULL,
0x0000000649057208ULL, 0x000fe40004000000ULL, 0x0000005439537208ULL, 0x000fc40004800000ULL,
0x0000000728067208ULL, 0x000fe40005000000ULL, 0x0000000413047208ULL, 0x000fe40005800000ULL,
0x000000500500720bULL, 0x000fe40003f1e000ULL, 0x0000003c5300720bULL, 0x000fe40003f3e000ULL,
0x000000290600720bULL, 0x000fe40003f5e000ULL, 0x000000110400720bULL, 0x000fc40003f7e000ULL,
0x0000000550527208ULL, 0x000fe40004000000ULL, 0x000000533c547208ULL, 0x000fe40004800000ULL,
0x0000000629057208ULL, 0x000fe40005000000ULL, 0x0000000411077208ULL, 0x000fe40005800000ULL,
0x0000003b5400720bULL, 0x000fe40003f3e000ULL, 0x000000515200720bULL, 0x000fc40003f1e000ULL,
0x0000002a0500720bULL, 0x000fe40003f5e000ULL, 0x000000120700720bULL, 0x000fe40003f7e000ULL,
0x000000543b557208ULL, 0x000fe40004800000ULL, 0x0000005251537208ULL, 0x000fe40004000000ULL,
0x000000052a047208ULL, 0x000fe40005000000ULL, 0x0000000712077208ULL, 0x000fc40005800000ULL,
0x000000405500720bULL, 0x000fe40003f3e000ULL, 0x000000485300720bULL, 0x000fe40003f1e000ULL,
0x0000002b0400720bULL, 0x000fe40003f5e000ULL, 0x000000100700720bULL, 0x000fe40003f7e000ULL,
0x0000005540527208ULL, 0x000fe40004800000ULL, 0x0000005348067208ULL, 0x000fc40004000000ULL,
0x000000042b057208ULL, 0x000fe40005000000ULL, 0x0000000710077208ULL, 0x000fe40005800000ULL,
0x0000003d5200720bULL, 0x000fe40003f3e000ULL, 0x000000470600720bULL, 0x000fe40003f1e000ULL,
0x0000002c0500720bULL, 0x000fe40003f5e000ULL, 0x0000000a0700720bULL, 0x000fc40003f7e000ULL,
0x000000523d527208ULL, 0x000fe40004800000ULL, 0x0000000647537208ULL, 0x000fe40004000000ULL,
0x000000052c047208ULL, 0x000fe40005000000ULL, 0x000000070a067208ULL, 0x000fe40005800000ULL,
0x0000003f5200720bULL, 0x000fe40003f3e000ULL, 0x000000465300720bULL, 0x000fc40003f1e000ULL,
0x0000002d0400720bULL, 0x000fe40003f5e000ULL, 0x0000000b0600720bULL, 0x000fe40003f7e000ULL,
0x000000523f057208ULL, 0x000fe40004800000ULL, 0x0000005346547208ULL, 0x000fe40004000000ULL,
0x000000042d077208ULL, 0x000fe40005000000ULL, 0x000000060b537208ULL, 0x000fc40005800000ULL,
0x0000003e0500720bULL, 0x000fe40003f3e000ULL, 0x000000320700720bULL, 0x000fe40003f5e000ULL,
0x000000455400720bULL, 0x000fe40003f1e000ULL, 0x0000000c5300720bULL, 0x000fe40003f7e000ULL,
0x000000053e047208ULL, 0x000fe40004800000ULL, 0x0000000732077208ULL, 0x000fc40005000000ULL,
0x0000005445557208ULL, 0x000fe40004000000ULL, 0x000000530c067208ULL, 0x000fe40005800000ULL,
0x000000330400720bULL, 0x000fe40003f3e000ULL, 0x0000002e0700720bULL, 0x000fe40003f5e000ULL,
0x000000445500720bULL, 0x000fe40003f1e000ULL, 0x0000000d0600720bULL, 0x000fc40003f7e000ULL,
0x0000000433057208ULL, 0x000fe40004800000ULL, 0x000000072e047208ULL, 0x000fe40005000000ULL,
0x0000005544527208ULL, 0x000fe40004000000ULL, 0x000000060d077208ULL, 0x000fe40005800000ULL,
0x000000340500720bULL, 0x000fe40003f3e000ULL, 0x0000002f0400720bULL, 0x000fc40003f5e000ULL,
0x000000435200720bULL, 0x000fe40003f1e000ULL, 0x0000000e0700720bULL, 0x000fe40003f7e000ULL,
0x0000000534067208ULL, 0x000fe40004800000ULL, 0x000000042f057208ULL, 0x000fe40005000000ULL,
0x0000005243537208ULL, 0x000fe40004000000ULL, 0x000000070e047208ULL, 0x000fc40005800000ULL,
0x000000425300720bULL, 0x000fe40003f1e000ULL, 0x000000310600720bULL, 0x000fe40003f3e000ULL,
0x000000300500720bULL, 0x000fe40003f5e000ULL, 0x0000000f0400720bULL, 0x000fe40003f7e000ULL,
0x0000005342077208ULL, 0x000fe40004000000ULL, 0x0000000631547208ULL, 0x000fc40004800000ULL,
0x0000000530587208ULL, 0x000fe40005000000ULL, 0x000000040f577208ULL, 0x000fe20005800000ULL,
0x00001ed27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007047f89ULL, 0x0004e400000e0000ULL,
0x000000040700720bULL, 0x008fc80003f1e000ULL, 0x0000000704597208ULL, 0x000fe20004000000ULL,
0x00001ee27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0054047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0058057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0057067f89ULL, 0x000e6200000e0000ULL,
0x000000045400720bULL, 0x008fc40003f1e000ULL, 0x000000055800720bULL, 0x010fe40003f3e000ULL,
0x0000005404077208ULL, 0x006fe40004000000ULL, 0x0000005805527208ULL, 0x000fe20004800000ULL,
0x0c201f0059047f89ULL, 0x000e6200000e0000ULL, 0x000000065700720bULL, 0x000fc60003f1e000ULL,
0x0c201f0007567f89ULL, 0x000ea200000e0000ULL, 0x0000005706547208ULL, 0x000fc60004000000ULL,
0x0c201f0052537f89ULL, 0x000ee800000e0000ULL, 0x0c201f0054557f89ULL, 0x0002e400000e0000ULL,
0x000000045900720bULL, 0x002fe40003f1e000ULL, 0x000000560700720bULL, 0x004fe40003f3e000ULL,
0x0000005904047208ULL, 0x000fc40004000000ULL, 0x000000535200720bULL, 0x008fe40003f5e000ULL,
0x0000000756057208ULL, 0x000fe40004800000ULL, 0x0000005253067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x000000555400720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x00000002ff657819ULL, 0x000fe2000001166eULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b49527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL,
0x0000005000537308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b51497823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b42427823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05507820ULL, 0x002fe20000410000ULL,
0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x0000000865667824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b30307823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010850ULL, 0x0000005455077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010850ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b07557820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010855ULL,
0x0000004100587308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b31317823ULL, 0x000fe20000010850ULL, 0x0000000865707824ULL, 0x040fe200078e00ffULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x0000000865727824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010855ULL, 0x3fb8aa3b10107823ULL, 0x000fe20000010855ULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x0000000c09097812ULL, 0x000fc400078ec0ffULL,
0x000000036eff7812ULL, 0x000fca000780c0ffULL, 0x0000004c004c7308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003800517308ULL, 0x000e700000000800ULL,
0x0000003700567308ULL, 0x0005f00000000800ULL, 0x0000003600577308ULL, 0x0007220000000800ULL,
0x3fb8aa3b34377823ULL, 0x104fe20000010850ULL, 0x00000004ff347e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x3f8000003434783eULL, 0x000fe200000010ffULL,
0x0000003f00387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3e367823ULL, 0x008fce0000010850ULL,
0x00000021003f7308ULL, 0x0005f00000000800ULL, 0x0000003300417308ULL, 0x000fe20000000800ULL,
0x0000000165217810ULL, 0x004fc80007ffe0ffULL, 0xfffffff866667812ULL, 0x000fe400078ee221ULL,
0x0000000265217810ULL, 0x000fe20007ffe0ffULL, 0x00000025005a7308ULL, 0x0005e60000000800ULL,
0xfffffff870707812ULL, 0x000fe400078ee221ULL, 0x0000003a5121723eULL, 0x002fc600000010ffULL,
0x00000028005b7308ULL, 0x000fe20000000800ULL, 0x0000000865257824ULL, 0x004fce00078e00ffULL,
0x00000029005e7308ULL, 0x000ff00000000800ULL, 0x0000002a005d7308ULL, 0x000ff00000000800ULL,
0x0000002300507308ULL, 0x0003f00000000800ULL, 0x0000002400337308ULL, 0x000ea20000000800ULL,
0x0000000365237810ULL, 0x002fc80007ffe0ffULL, 0xfffffff872727812ULL, 0x000fe400078ee223ULL,
0x000000565723723eULL, 0x010fe200000010ffULL, 0x0000002200287308ULL, 0x0003e20000000800ULL,
0x0000000865567810ULL, 0x000fce0007ffe0ffULL, 0x0000002000297308ULL, 0x0007e20000000800ULL,
0x0000000465227810ULL, 0x002fc80007ffe0ffULL, 0xfffffff825747812ULL, 0x000fe400078ee222ULL,
0x000000355825723eULL, 0x000fe200000010ffULL, 0x0000001e002a7308ULL, 0x0005e20000000800ULL,
0x0000004f4e20723eULL, 0x008fe200000010ffULL, 0x000000ffff357224ULL, 0x000fe200078e0034ULL,
0x0000004d4c22723eULL, 0x000fe200000010ffULL, 0x00000008654c7824ULL, 0x040fe200078e00ffULL,
0x0000001065587810ULL, 0x000fc60007ffe0ffULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000335a1e723eULL, 0x004fe400000010ffULL, 0xfffffff84c4c7812ULL, 0x000fca00078ee265ULL,
0x0000003900397308ULL, 0x000ff00000000800ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x0000002a1f1f723eULL, 0x002fe400000010ffULL, 0xffffffff652a7810ULL, 0x000fca0007ffe0ffULL,
0x0000003000547308ULL, 0x0003f00000000800ULL, 0x0000002c005f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c307823ULL, 0x002fe20000010855ULL, 0x0000003f501c723eULL, 0x000fe200000010ffULL,
0x0000000865507824ULL, 0x000fca00078e00ffULL, 0x0000002d00627308ULL, 0x000ff00000000800ULL,
0x0000002e00647308ULL, 0x000ff00000000800ULL, 0x0000002f00637308ULL, 0x0003f00000000800ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x00000034202c723cULL, 0x002b6e00000418ffULL,
0x0000004a004a7308ULL, 0x000e620000000800ULL, 0x0000000865357824ULL, 0x020fce00078e00ffULL,
0x0000002b00607308ULL, 0x0005f00000000800ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d2b7823ULL, 0x004fe20000010855ULL, 0x00000028291d723eULL, 0x000fc400000010ffULL,
0x0000004b4a24723eULL, 0x002fe200000010ffULL, 0x000000ffff4a7224ULL, 0x100fe200078e0034ULL,
0x0000000665297810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff4b7224ULL, 0x000fe200078e0034ULL,
0x00000031003e7308ULL, 0x0003e20000000800ULL, 0x0000000565287810ULL, 0x000fe40007ffe0ffULL,
0xfffffff850507812ULL, 0x000fe400078ee229ULL, 0xfffffff8354e7812ULL, 0x000fc600078ee228ULL,
0x00000030003a7308ULL, 0x0005e20000000800ULL, 0x000000ffff317224ULL, 0x002fce00078e0034ULL,
0x00000027005c7308ULL, 0x0003e20000000800ULL, 0x000000ffff307224ULL, 0x004fce00078e0034ULL,
0x0000002b002b7308ULL, 0x000ea20000000800ULL, 0x000000393c27723eULL, 0x002fe200000010ffULL,
0x0000000865397824ULL, 0x040fe200078e00ffULL, 0x0000001865657810ULL, 0x000fca0007ffe0ffULL,
0x0000003200617308ULL, 0x0003f00000000800ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x000000301c30723cULL, 0x002f6200000418ffULL, 0x0000002b3a29723eULL, 0x004fcc00000010ffULL,
0x00000011003c7308ULL, 0x0002b00000000800ULL, 0x0000002600597308ULL, 0x0007220000000800ULL,
0x0000000856117824ULL, 0x002fca00078e00ffULL, 0xfffffff811567812ULL, 0x000fe400078ee256ULL,
0x000000133c2b723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b0c3c7823ULL, 0x000fe20000010855ULL,
0x000000525326723eULL, 0x008fe200000010ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0034ULL,
0xfffffff839527812ULL, 0x000fe200078ee22aULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x0000005b5e2a723eULL, 0x000fe200000010ffULL, 0x0000000858137824ULL, 0x000fe200078e00ffULL,
0x000000595c28723eULL, 0x010fe200000010ffULL, 0x0000004a242c723cULL, 0x000b62000004182cULL,
0x000000ffff397224ULL, 0x000fc400078e0034ULL, 0xfffffff813587812ULL, 0x000fe200078ee258ULL,
0x0000004900497308ULL, 0x000fe60000000800ULL, 0x3fb8aa3b0d4a7823ULL, 0x120fe20000010855ULL,
0x000000ffff0d7224ULL, 0x100fe200078e0034ULL, 0x3fb8aa3b0e4b7823ULL, 0x100fe20000010855ULL,
0x3fb8aa3b0f557823ULL, 0x000fe40000010855ULL, 0x0000004800487308ULL, 0x000ea20000000800ULL,
0x0000003d380f723eULL, 0x002fe200000010ffULL, 0x000000ffff387224ULL, 0x000fe200078e0034ULL,
0x0000000c2830723cULL, 0x000b6a0000041830ULL, 0x0000004700477308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000e620000000800ULL, 0x00000049480c723eULL, 0x024fce00000010ffULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000004000407308ULL, 0x000ea20000000800ULL,
0x00000047460e723eULL, 0x002fce00000010ffULL, 0x0000001200357308ULL, 0x0003f00000000800ULL,
0x00000010003a7308ULL, 0x0007220000000800ULL, 0x0000003b400d723eULL, 0x004fe200000010ffULL,
0x0000000865407824ULL, 0x000fe200078e00ffULL, 0x0000005f6212723eULL, 0x002fc800000010ffULL,
0xfffffff840407812ULL, 0x000fe200078ee265ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x0000005d6010723eULL, 0x008fce00000010ffULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0x000000353a11723eULL, 0x010fe200000010ffULL, 0x000000ffff357224ULL, 0x000fe200078e0034ULL,
0x000000380c38723cULL, 0x000b6a000004182cULL, 0x0000003600367308ULL, 0x000ea20000000800ULL,
0x0000000a0b13723eULL, 0x002fce00000010ffULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x0000a0001a0b7811ULL, 0x000fe200078e60ffULL, 0x000000341030723cULL, 0x000be80000041830ULL,
0x000000104c4c7824ULL, 0x100fe400078e020bULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x0000001066667824ULL, 0x100fe200078e020bULL, 0x00000036412d723eULL, 0x024fe200000010ffULL,
0x0000001070707824ULL, 0x000fc400078e020bULL, 0x0000001072727824ULL, 0x100fe400078e020bULL,
0x0000001074747824ULL, 0x000fe200078e020bULL, 0x0000004400447308ULL, 0x000ea20000000800ULL,
0x000000373e2f723eULL, 0x002fe200000010ffULL, 0x000000ffff367224ULL, 0x100fe200078e0034ULL,
0x00000063543e723eULL, 0x000fe200000010ffULL, 0x000000014c357824ULL, 0x000fe400078e0209ULL,
0x000000ffff377224ULL, 0x000fe400078e0034ULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x000000104e4e7824ULL, 0x000fe200078e020bULL, 0x0000002035007388ULL, 0x0003e20000000800ULL,
0x0000000109667824ULL, 0x000fc400078e0266ULL, 0x0000001050507824ULL, 0x100fe400078e020bULL,
0x0000000109707824ULL, 0x040fe200078e0270ULL, 0x0000004200427308ULL, 0x000ee20000000800ULL,
0x00000045442c723eULL, 0x004fe200000010ffULL, 0x0000001052527824ULL, 0x100fe200078e020bULL,
0x0000002266007388ULL, 0x0003e20000000800ULL, 0x0000000109727824ULL, 0x040fe400078e0272ULL,
0x0000001056567824ULL, 0x000fe200078e020bULL, 0x0000002470007388ULL, 0x0003e20000000800ULL,
0x0000003c003f7308ULL, 0x0005e20000000800ULL, 0x0000000109747824ULL, 0x000fc400078e0274ULL,
0x00000001094e7824ULL, 0x040fe200078e024eULL, 0x0000002672007388ULL, 0x0003e20000000800ULL,
0x0000000109507824ULL, 0x040fe400078e0250ULL, 0x0000000109527824ULL, 0x040fe200078e0252ULL,
0x0000004a004a7308ULL, 0x000f220000000800ULL, 0x00000043422e723eULL, 0x008fe200000010ffULL,
0x0000000109567824ULL, 0x000fe200078e0256ULL, 0x00000061643c723eULL, 0x004fe200000010ffULL,
0x0000000c74007388ULL, 0x0003e20000000800ULL, 0x0000001058587824ULL, 0x000fc400078e020bULL,
0x0000001040407824ULL, 0x000fe200078e020bULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x000000362c38723cULL, 0x000f620000041838ULL, 0x0000000e4e007388ULL, 0x0003e20000000800ULL,
0x00000001090b7824ULL, 0x040fe400078e0258ULL, 0x0000000109407824ULL, 0x000fe200078e0240ULL,
0x0000002c50007388ULL, 0x0003e40000000800ULL, 0x00000055000a7308ULL, 0x000ea20000000800ULL,
0x0000003f4a3d723eULL, 0x010fe200000010ffULL, 0x0000002e52007388ULL, 0x0003e80000000800ULL,
0x0000002156007388ULL, 0x0003e80000000800ULL, 0x0004002366007388ULL, 0x0003e80000000800ULL,
0x0004002570007388ULL, 0x0003e20000000800ULL, 0x0000004b0a3f723eULL, 0x004fc400000010ffULL,
0x000000ffff397224ULL, 0x020fe200078e003aULL, 0x0004002772007388ULL, 0x0003e80000000800ULL,
0x0004000d74007388ULL, 0x0003e20000000800ULL, 0x000000363c30723cULL, 0x000f660000041830ULL,
0x0004000f4e007388ULL, 0x0003e80000000800ULL, 0x0004002d50007388ULL, 0x0003e80000000800ULL,
0x0004002f52007388ULL, 0x0003e80000000800ULL, 0x0000001c0b007388ULL, 0x0003e80000000800ULL,
0x0008001e66007388ULL, 0x0003e80000000800ULL, 0x0008002870007388ULL, 0x0003e20000000800ULL,
0x000000ffff3a7224ULL, 0x020fc400078e0030ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0032ULL,
0x0008002a72007388ULL, 0x0003e80000000800ULL, 0x0008001074007388ULL, 0x0003e80000000800ULL,
0x000800124e007388ULL, 0x0003e80000000800ULL, 0x0008003c50007388ULL, 0x0003e80000000800ULL,
0x0008003e52007388ULL, 0x0003e80000000800ULL, 0x0000001d40007388ULL, 0x0003e80000000800ULL,
0x000c001f66007388ULL, 0x0003e80000000800ULL, 0x000c002970007388ULL, 0x0003e80000000800ULL,
0x000c002b72007388ULL, 0x0003e80000000800ULL, 0x000c001174007388ULL, 0x0003e80000000800ULL,
0x000c00134e007388ULL, 0x0003e80000000800ULL, 0x000c003d50007388ULL, 0x0003e80000000800ULL,
0x000c003f52007388ULL, 0x0003e80000000800ULL, 0x0120000408008388ULL, 0x0003e80000000c00ULL,
0x0122003808008388ULL, 0x0003e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000018ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080018ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100018ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000114147810ULL, 0x000fe20007ffe0ffULL, 0x0000180018ff7f8cULL, 0x0003e6000c80043fULL,
0x000000151400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff8dc000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x000193d000267802ULL, 0x000fc40000000f00ULL,
0x00000e8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0025ULL,
0xfffe96a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001942000267802ULL, 0x000fc40000000f00ULL, 0x00000e3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0025ULL, 0xfffe970000007947ULL, 0x000fea000383ffffULL,
0x0001946000257802ULL, 0x000fc40000000f00ULL, 0x00000da000007944ULL, 0x002fea0003c00000ULL,
0xfffe97e000007947ULL, 0x000fea000383ffffULL, 0x0001949000257802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x002fea0003c00000ULL, 0xfffe992000007947ULL, 0x000fea000383ffffULL,
0x000194c000257802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x002fea0003c00000ULL,
0xfffe9a6000007947ULL, 0x000fea000383ffffULL, 0x000194f000257802ULL, 0x000fc40000000f00ULL,
0x00000d1000007944ULL, 0x002fea0003c00000ULL, 0xfffe9b9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001953000257802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffe9fc000007947ULL, 0x000fea000383ffffULL, 0x0001957000257802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001002267810ULL, 0x000fe40007ffe0ffULL, 0x000195b000257802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffe9f9000007947ULL, 0x000fea000383ffffULL, 0x000195f000257802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffe9f8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x0001964000267802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0025ULL, 0xfffec89000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x0001969000267802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffec8e000007947ULL, 0x000fea000383ffffULL, 0x000196d000257802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x004fea0003c00000ULL, 0xfffec9c000007947ULL, 0x000fea000383ffffULL,
0x0001970000257802ULL, 0x000fc40000000f00ULL, 0x00000b0000007944ULL, 0x006fea0003c00000ULL,
0xfffecb0000007947ULL, 0x000fea000383ffffULL, 0x0001973000257802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x00efea0003c00000ULL, 0xfffecc4000007947ULL, 0x000fea000383ffffULL,
0x0001976000257802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x00efea0003c00000ULL,
0xfffecd7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001eULL,
0x000197a000257802ULL, 0x000fc40000000f00ULL, 0x00000a6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffed19000007947ULL, 0x000fea000383ffffULL,
0x000197e000257802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000101e267810ULL, 0x000fc40007ffe0ffULL,
0x0001982000257802ULL, 0x000fc40000000f00ULL, 0x000009e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffed16000007947ULL, 0x000fea000383ffffULL,
0x0001986000257802ULL, 0x000fc40000000f00ULL, 0x000009a000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffed15000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe40004000000ULL, 0x000198b000267802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff727224ULL, 0x000fe200078e0025ULL,
0xfffef9d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe40005800000ULL,
0x0001990000267802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff237224ULL, 0x000fe200078e0025ULL, 0xfffefa2000007947ULL, 0x000fea000383ffffULL,
0x0001994000257802ULL, 0x000fc40000000f00ULL, 0x000008c000007944ULL, 0x002fea0003c00000ULL,
0xfffefb0000007947ULL, 0x000fea000383ffffULL, 0x0001997000257802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x002fea0003c00000ULL, 0xfffefc4000007947ULL, 0x000fea000383ffffULL,
0x000199a000257802ULL, 0x000fc40000000f00ULL, 0x0000086000007944ULL, 0x002fea0003c00000ULL,
0xfffefd8000007947ULL, 0x000fea000383ffffULL, 0x000199d000257802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x002fea0003c00000ULL, 0xfffefeb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0024ULL, 0x00019a1000257802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff02d000007947ULL, 0x000fea000383ffffULL, 0x00019a5000257802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001024267810ULL, 0x000fc40007ffe0ffULL, 0x00019a9000257802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff02a000007947ULL, 0x000fea000383ffffULL, 0x00019ad000257802ULL, 0x000fc40000000f00ULL,
0x0000073000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff029000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe40004000000ULL,
0x00019b2000267802ULL, 0x000fc40000000f00ULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0025ULL, 0xffff29b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe40005800000ULL, 0x00019b7000267802ULL, 0x000fc40000000f00ULL,
0x000006e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x000fe200078e0025ULL,
0xffff2a0000007947ULL, 0x000fea000383ffffULL, 0x00019bb000257802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x000fea0003c00000ULL, 0xffff2ae000007947ULL, 0x000fea000383ffffULL,
0x00019be000257802ULL, 0x000fc40000000f00ULL, 0x0000062000007944ULL, 0x002fea0003c00000ULL,
0xffff2c2000007947ULL, 0x000fea000383ffffULL, 0x00019c1000257802ULL, 0x000fc40000000f00ULL,
0x000005f000007944ULL, 0x002fea0003c00000ULL, 0xffff2d6000007947ULL, 0x000fea000383ffffULL,
0x00019c4000257802ULL, 0x000fc40000000f00ULL, 0x000005c000007944ULL, 0x002fea0003c00000ULL,
0xffff2e9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000aULL,
0x00019c8000257802ULL, 0x000fc40000000f00ULL, 0x0000058000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff32a000007947ULL, 0x000fea000383ffffULL,
0x00019cc000257802ULL, 0x000fc40000000f00ULL, 0x0000054000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000100a267810ULL, 0x000fc40007ffe0ffULL,
0x00019d0000257802ULL, 0x000fc40000000f00ULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff327000007947ULL, 0x000fea000383ffffULL,
0x00019d4000257802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff326000007947ULL, 0x000fea000383ffffULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x00019d9000527802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0055ULL,
0xffffe0f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e0054ULL,
0x00019df000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x000000555400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0058ULL, 0x00019e5000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x0000005455067208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000555800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0057ULL, 0x00019eb000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe200078e00ffULL, 0x0000005855587208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000555700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0059ULL, 0x00019f1000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005755547208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000555900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x00019f7000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005955047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000550600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0058ULL, 0x00019fd000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000000655057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000555800720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001a03000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff567424ULL, 0x000fe200078e00ffULL, 0x0000005855067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffdfc000007947ULL, 0x000fea000383ffffULL,
0x0180000022007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000022027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe5e4002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005b00007348ULL, 0x000fe80003800000ULL,
0x0c00005607557389ULL, 0x0002a200000e005aULL, 0xfffe5e0052007950ULL, 0x000fea0003c3ffffULL,
0x000000ffff6a7224ULL, 0x000fe200078e0025ULL, 0x0000007500007348ULL, 0x000fe80003800000ULL,
0x00000000ff6b7424ULL, 0x000fe200078e00ffULL, 0x0000002627267389ULL, 0x0002a600000e0076ULL,
0xfffe5db06a007950ULL, 0x000fea0003c3ffffULL, 0x000000012500780cULL, 0x000fe20003f65070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000007400007348ULL, 0x000ff60003800000ULL,
0x0000000000257806ULL, 0x000fc800058e0100ULL, 0x0000007425257212ULL, 0x000fe200078ec0ffULL,
0xfffe5d5026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000568ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c78ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d38ULL,
0x00000000000008acULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001688ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000168cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x000000000001a380ULL, 0xdc00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001bc00ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001bc40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001bfc0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001688ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001a578ULL,
0x000000000001a578ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001bc00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001bfc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_32_sm_89_cubin_len = 114848;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
