/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016c40ULL, 0x00000000000168c0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL,
0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL,
0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL,
0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL,
0x45316a4c45346a4cULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x336a4c4545346a4cULL, 0x324545386a4c4532ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45326a4c4545326aULL, 0x7461324545316a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x6e695f5f24000000ULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x0000000000000061ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000038ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000001c6ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000020cULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b000100000253ULL, 0x0000000000000034ULL, 0x0000000000000004ULL, 0x000b000100000299ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000002e7ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000335ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b000100000383ULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000003d1ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000417ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000465ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000004c0ULL,
0x0000000000015200ULL, 0x0000000000000280ULL, 0x0004000300000536ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000015480ULL,
0x000d000300000566ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001520000000000ULL, 0x0001380400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL,
0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001520000000000ULL, 0x0000028000000000ULL,
0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL, 0x0000001700082f04ULL,
0x000823040000007fULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001700082304ULL, 0x0008120400000000ULL, 0x0000000000000017ULL,
0x0000001700081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000a00000000ULL,
0x000c17040021f000ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0xffffffff00942904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000037000942804ULL, 0x000009f0000003a0ULL, 0x00002940000028d0ULL, 0x00002b5000002a10ULL,
0x0000306000003050ULL, 0x00005460000053f0ULL, 0x0000568000005540ULL, 0x00005ba000005b90ULL,
0x00007f4000007ee0ULL, 0x0000818000008040ULL, 0x000085d0000085c0ULL, 0x0000a9400000a8d0ULL,
0x0000ab600000aa20ULL, 0x0000afe00000afd0ULL, 0x0000c8c00000c8b0ULL, 0x00014690000145e0ULL,
0x00014960000148c0ULL, 0x00014c8000014c10ULL, 0x00014ef000014ea0ULL, 0x0000053004303904ULL,
0x00017600000000ffULL, 0x0000061000040100ULL, 0x0001760800000008ULL, 0x00000720003f0100ULL,
0x0001768800000008ULL, 0x00000860003f0100ULL, 0x000176a800000002ULL, 0x00000960003f0100ULL,
0x000176c800000004ULL, 0x000010b0003f0100ULL, 0x00017600000000ffULL, 0x000011f000080107ULL,
0x000176880000000cULL, 0x00001a6000080101ULL, 0x00000000000000ffULL, 0x00001a9000040107ULL,
0x00000000000000ffULL, 0x00001b1000040101ULL, 0x0000002000000002ULL, 0x00001bd0003f0101ULL,
0x000176c800000017ULL, 0x00001d6000080109ULL, 0x000176c800000035ULL, 0x000025b0003f0109ULL,
0x000176b000000004ULL, 0x0000262000080107ULL, 0x000176b000000048ULL, 0x00002630003f0101ULL,
0x0001760800000034ULL, 0x00002670003f0101ULL, 0x000176080000004bULL, 0x000027e0003f0109ULL,
0x000176080000004bULL, 0x00002d00003f0109ULL, 0x000176a800000000ULL, 0x00002e8000080109ULL,
0x000176a800000004ULL, 0x000047d0003f0109ULL, 0x000176c800000035ULL, 0x000047e0003f0101ULL,
0x0001768800000036ULL, 0x0000481000080101ULL, 0x0000000000000006ULL, 0x00004980003f0109ULL,
0x0000000000000006ULL, 0x00005120003f0109ULL, 0x000176a800000014ULL, 0x000051a000080107ULL,
0x000176a800000056ULL, 0x000051b0003f0101ULL, 0x0001762800000015ULL, 0x000051d0003f0101ULL,
0x000176280000004bULL, 0x00005340003f0109ULL, 0x000176280000004bULL, 0x00005850003f0109ULL,
0x000176b000000017ULL, 0x000059d000080109ULL, 0x000176b000000037ULL, 0x000072b0003f0109ULL,
0x000176c800000036ULL, 0x000072d0003f0101ULL, 0x0001769000000053ULL, 0x0000730000080101ULL,
0x0000000000000006ULL, 0x00007470003f0109ULL, 0x0000000000000006ULL, 0x00007bd0003f0109ULL,
0x00000008000000ffULL, 0x00007c4000040107ULL, 0x0000000800000054ULL, 0x00007c50003f0101ULL,
0x000176480000004bULL, 0x00007cc0003f0101ULL, 0x0001764800000041ULL, 0x00007e30003f0109ULL,
0x0001764800000041ULL, 0x00008340003f0109ULL, 0x000176a800000017ULL, 0x000084c000080109ULL,
0x000176a800000037ULL, 0x00009c90003f0109ULL, 0x0000000000000006ULL, 0x00009cb0003f0101ULL,
0x0001769800000036ULL, 0x00009ce0003f0101ULL, 0x0000000000000006ULL, 0x00009e50003f0109ULL,
0x0000000000000006ULL, 0x0000a5f0003f0109ULL, 0x00000000000000ffULL, 0x0000a69000040107ULL,
0x000176a80000004eULL, 0x0000a6a0003f0101ULL, 0x0001766800000037ULL, 0x0000a6c0003f0101ULL,
0x0001766800000037ULL, 0x0000a830003f0109ULL, 0x0001766800000037ULL, 0x0000ad20003f0109ULL,
0x000176b000000017ULL, 0x0000aec000080109ULL, 0x000176b000000041ULL, 0x0000c680003f0109ULL,
0x0000000000000006ULL, 0x0000c710003f0101ULL, 0x000176a000000000ULL, 0x0000da50003f0101ULL,
0x00017600000000ffULL, 0x0000f2a000080101ULL, 0x00017600000000ffULL, 0x0000f46000080109ULL,
0x00017600000000ffULL, 0x0000f64000080109ULL, 0x00017600000000ffULL, 0x0000f66000080101ULL,
0x00017600000000ffULL, 0x0000f7d000080109ULL, 0x00017600000000ffULL, 0x00012ac000080109ULL,
0x0001768800000006ULL, 0x00012c90003f0101ULL, 0x0001768800000006ULL, 0x00012e00003f0109ULL,
0x0001768800000006ULL, 0x000151a0003f0109ULL, 0x0001760800000009ULL, 0x000151b0003f0101ULL,
0x0001761000000009ULL, 0x000151c0003f0101ULL, 0x0001761800000009ULL, 0x000151d0003f0101ULL,
0x0001762000000009ULL, 0x00053803003f0101ULL, 0x0000d12000201c04ULL, 0x0000d4100000d150ULL,
0x0000d8000000d600ULL, 0x0000f8000000d9b0ULL, 0x000c0504000151f0ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001800080a04ULL, 0x0000000000600210ULL,
0x00000000000000bcULL, 0x0000001700000002ULL, 0x0000000000015200ULL, 0x0000000000000044ULL,
0x0000001700000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001700000002ULL,
0x0000000000000000ULL, 0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000077919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff0a7b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff042b82ULL, 0x000ea20000000a00ULL,
0x0000000107092836ULL, 0x008fe20000000000ULL, 0x0000000a00067306ULL, 0x010ee20000209000ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x000000ff0a00720cULL, 0x000fe20003f65070ULL,
0x00000000003d7919ULL, 0x000f260000002100ULL, 0x00008400ff0cab82ULL, 0x000f620000000800ULL,
0x0000000407022825ULL, 0x004fc800078e0004ULL, 0x0000000409042825ULL, 0x000fe400078e0004ULL,
0x0000000602032981ULL, 0x000ea8000c1e1900ULL, 0x0000000604002981ULL, 0x0008a2000c1e1900ULL,
0x0000000600067308ULL, 0x008ee20000001000ULL, 0x0000010000057ab9ULL, 0x000fe20000000800ULL,
0x0000043000007945ULL, 0x000fe20003800000ULL, 0x0ffffffe06087836ULL, 0x008fca0000000000ULL,
0x0000000800097305ULL, 0x000724000021f000ULL, 0x000000ffff087224ULL, 0x008fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x012fc800078e0a09ULL, 0x0000000a0b0b7224ULL, 0x000fc800078e02ffULL,
0x0000000b09097227ULL, 0x000fe400078e0008ULL, 0x0000000000087919ULL, 0x000e680000002300ULL,
0x0000000409097c27ULL, 0x000fe2000f8e00ffULL, 0x00000000000b7919ULL, 0x000e660000002200ULL,
0x000000ffff057224ULL, 0x000fc800078e0a09ULL, 0x000000040a057e24ULL, 0x000fe2000f8e0205ULL,
0x00000000000479c3ULL, 0x000ee80000002600ULL, 0x0000000a0500720cULL, 0x000fda0003f06070ULL,
0x0000000105050824ULL, 0x000fe400078e0a0aULL, 0x0000000109090836ULL, 0x000fc60000000000ULL,
0x0000000a0500720cULL, 0x000fda0003f26070ULL, 0x0000000109091836ULL, 0x000fe20000000000ULL,
0x0000000aff09b212ULL, 0x000fc800078e33ffULL, 0x0000000900027306ULL, 0x000f220000209000ULL,
0x000000ff0900720cULL, 0x000fce0003f65070ULL, 0x0000000200027308ULL, 0x010f240000001000ULL,
0x0ffffffe02047836ULL, 0x010fe40000000000ULL, 0x0000000508027c24ULL, 0x002fe2000f8e020bULL,
0x0000000000057ab9ULL, 0x000fc60000000800ULL, 0x0000000400057305ULL, 0x000324000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x0000000509067224ULL, 0x010fc800078e02ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a06ULL, 0x0000000d05057227ULL, 0x000fc800078e0004ULL,
0x0000000502047c24ULL, 0x100fe2000f8e023dULL, 0x00000005ff3d7819ULL, 0x000fe2000001163dULL,
0x00000004053f7c27ULL, 0x008fc6000f8e00ffULL, 0x0000007f0400780cULL, 0x040fe20003fa4070ULL,
0x000000ffff067224ULL, 0x000fe200078e0a3fULL, 0x00001fff3d3d7589ULL, 0x000f6200000e0000ULL,
0x000000030400780cULL, 0x000fe40003f84070ULL, 0x0000000409027e24ULL, 0x000fe4000f8e0206ULL,
0x00001fff08067589ULL, 0x000b6600000e0000ULL, 0x000000090200720cULL, 0x000fc60003f06070ULL,
0x000000000005d919ULL, 0x000e740000008800ULL, 0x0000000102020824ULL, 0x000fc400078e0a09ULL,
0x000000013f3f0836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000090200720cULL, 0x000fe40003f26070ULL, 0x000004000002d802ULL, 0x000fd60000000f00ULL,
0x000000013f3f1836ULL, 0x000fe20000000000ULL, 0x00000009ff3fb212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x00000654050bd816ULL, 0x002fe20000000002ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0a3fULL, 0x000000010400780cULL, 0x000fe20003f64070ULL,
0xff317217ff05d424ULL, 0x000fe400078e00ffULL, 0x00000004093a7e24ULL, 0x000fc4000f8e023aULL,
0x000000040402d824ULL, 0x000fe400078e020bULL, 0x0000000100002824ULL, 0x004fcc00078e0a03ULL,
0x00008400ff00ab82ULL, 0x000e640000000800ULL, 0x0000000000240947ULL, 0x022fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x01760008043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404087c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000080812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01760804083f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404087c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000080812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01768804083f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x017400050200d388ULL, 0x0005e20000000800ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x0000011000007945ULL, 0x000fe20003800000ULL, 0x000000103a3a7824ULL, 0x000fc600078e00ffULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffc000000057882ULL, 0x000fc60000000000ULL,
0x0000000404027c11ULL, 0x004fe2000f8e18ffULL, 0x001fff0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176a804093f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000040912caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176c804093f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000800057c24ULL, 0x006fe2000f8e02ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ffff027224ULL, 0x000fe200078e0a3aULL, 0x0000003a0500720cULL, 0x000fe20003f06070ULL,
0x0000000c0703a224ULL, 0x000fc400078e02ffULL, 0x000000080a107c24ULL, 0x000fe2000f8e02ffULL,
0x00000010050f7446ULL, 0x000fe20003800002ULL, 0x0000000406027824ULL, 0x000fe400078e023dULL,
0x00000010030e7224ULL, 0x000fe200078e02ffULL, 0x000000ff0f0f7207ULL, 0x000fe20000000000ULL,
0x0000000202087824ULL, 0x000fe400078e00ffULL, 0x000000083f137c24ULL, 0x000fe2000f8e020eULL,
0x000000100f00780cULL, 0x000fda0003f05270ULL, 0x0000000000c48947ULL, 0x000fea0003800000ULL,
0x0000000800027d06ULL, 0x000e620008209000ULL, 0x00000000000d7919ULL, 0x000ea20000000000ULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000157919ULL, 0x000ee80000008800ULL, 0x0000000200027308ULL, 0x002e640000001000ULL,
0x0ffffffe02047836ULL, 0x002fe20000000000ULL, 0x00000004ff097819ULL, 0x004fca000001160dULL,
0x0000000400057305ULL, 0x0002a2000021f000ULL, 0x00000001080b7824ULL, 0x000fc800078e0209ULL,
0x000000013a027824ULL, 0x000fe400078e020bULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff117224ULL, 0x004fc800078e0a05ULL, 0x0000000811117c24ULL, 0x000fc8000f8e02ffULL,
0x0000001105057227ULL, 0x000fcc00078e0004ULL, 0x00000002050c7227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0cULL, 0x0000000805047c24ULL, 0x000fca000f8e0202ULL,
0x0000000804007c0cULL, 0x000fda000bf06070ULL, 0x8000000804040c36ULL, 0x000fe40008000000ULL,
0x000000010c0c0836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0x0000040000047802ULL, 0x000fc80000000f00ULL, 0x0000065415157816ULL, 0x008fce0000000004ULL,
0x000000010c0c1836ULL, 0x000fe20000000000ULL, 0x00000008ff0cac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a0cULL, 0x0000000805027c24ULL, 0x000fe2000f8e0202ULL,
0x000000080f057248ULL, 0x000fe40007fe0000ULL, 0x00000000150872caULL, 0x000fe200000e0000ULL,
0x0000000113117824ULL, 0x000fe400078e0202ULL, 0x000000100d027824ULL, 0x000fe400078e00ffULL,
0x000000100c047224ULL, 0x000fe400078e0211ULL, 0x0000000105087824ULL, 0x000fe200078e0a08ULL,
0x000000f002117812ULL, 0x000fe200078ec0ffULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x000000080900720cULL, 0x000fe20003f06070ULL, 0x000000010b087824ULL, 0x040fe200078e020dULL,
0x0000001104117212ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fc600078e00ffULL,
0x0000000411047c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff00b087812ULL, 0x000fe400078ee208ULL,
0x0000000505057c10ULL, 0x000fe40008ffe4ffULL, 0x0000000808097c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000c101c46ULL,
0x0000000000b07947ULL, 0x000fea0003800000ULL, 0x0000000800097d06ULL, 0x000e620008209000ULL,
0x00000000000d7919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00000008ff007c0cULL, 0x000fe2000bf45070ULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000000c7919ULL, 0x000ee60000008800ULL, 0x0000000900097308ULL, 0x002e640000001000ULL,
0x0ffffffe090b7836ULL, 0x002fe20000000000ULL, 0x0000040000097802ULL, 0x000fc40000000f00ULL,
0x000000080d087211ULL, 0x004fc600078fe0ffULL, 0x0000000b00057305ULL, 0x000e62000021f000ULL,
0x000006540c097816ULL, 0x008fe20000000009ULL, 0x000000013a027824ULL, 0x000fe400078e0208ULL,
0x000000ffff117224ULL, 0x002fc800078e0a05ULL, 0x0000000811117c24ULL, 0x000fc8000f8e02ffULL,
0x0000001105117227ULL, 0x000fcc00078e0004ULL, 0x0000000211047227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000805057c24ULL, 0x000fca000f8e0202ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000104040836ULL, 0x000fc60000000000ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x0000000104041836ULL, 0x000fe20000000000ULL, 0x00000008ff04ac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000805027c24ULL, 0x000fe2000f8e0202ULL,
0x00000000090872caULL, 0x000fe200000e0000ULL, 0x0000000108097824ULL, 0x000fe400078e020dULL,
0x0000000113057824ULL, 0x000fe400078e0202ULL, 0x000000100d027824ULL, 0x000fe400078e00ffULL,
0x0000001004057224ULL, 0x000fe400078e0205ULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x000000f0020b7812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fc600078e00ffULL,
0xfffffff008097812ULL, 0x000fe400078ee209ULL, 0x0000000b04047212ULL, 0x000fe400078efcffULL,
0x0000000809097c11ULL, 0x000fe4000f8e20ffULL, 0x0000000404047c10ULL, 0x000fc8000ff1e0ffULL,
0x0000000505057c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c46ULL, 0x0001760008047890ULL, 0x000fe2000fffe03fULL,
0x00009200ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000407047825ULL, 0x002fe200078e0004ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000006043b7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x000000ff3b087836ULL, 0x004fca0000000000ULL, 0x00000008ff397819ULL, 0x000fce0000011608ULL,
0x000000c8001c8947ULL, 0x000fea0003800000ULL, 0x0000000207077824ULL, 0x000fe200078e00ffULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x000000083d0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe2000001163dULL, 0x0000000a07007224ULL, 0x000fe200078e020aULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x000000013d387812ULL, 0x000fe200078ec0ffULL, 0x000000200b0a7824ULL, 0x000fe400078e00ffULL,
0x000000013f097824ULL, 0x000fe200078e0200ULL, 0x017688030cff79a7ULL, 0x0003e60008500008ULL,
0x0000000409007c24ULL, 0x000fe2000f8e020aULL, 0x0000000400000947ULL, 0x000fec0003800000ULL,
0x0000000a3b037248ULL, 0x002fe20007fe0000ULL, 0x0000001038047824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe2000001160dULL, 0x0000900000047ab9ULL, 0x000fe40000000a00ULL,
0x0000000103037824ULL, 0x000fe400078e0a0aULL, 0x0000000104067824ULL, 0x000fe400078e0205ULL,
0x0000000405107836ULL, 0x000fe20000000000ULL, 0x0000000403037248ULL, 0x000fe20007fe0000ULL,
0x0000000106077824ULL, 0x000fc400078e020dULL, 0x0000000806087824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a04ULL, 0x0000000c05117836ULL, 0x000fe20000000000ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x000000031000720cULL, 0x080fe20003f46070ULL, 0x0000000104107824ULL, 0x000fe200078e0210ULL,
0x000000030500720cULL, 0x080fe20003f66070ULL, 0x0000000100057824ULL, 0x000fe200078e0206ULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000110067824ULL, 0x040fe200078e020dULL,
0x000000031100720cULL, 0x000fe20003f06070ULL, 0x0000000810137824ULL, 0x000fc400078e00ffULL,
0x0000000104077824ULL, 0x040fe400078e0207ULL, 0x0000000104127824ULL, 0x000fe200078e0211ULL,
0xfffffff813147812ULL, 0x000fe200078ee206ULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x0000000100067824ULL, 0x040fe200078e0207ULL, 0x0000007004137812ULL, 0x000fe200078ef802ULL,
0x0000000107037824ULL, 0x140fe400078e020dULL, 0x0000000807167824ULL, 0x000fe400078e00ffULL,
0x0000000100117824ULL, 0x000fe400078e0212ULL, 0x0000000112047824ULL, 0x040fe200078e020dULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x0000000812077824ULL, 0x000fe200078e00ffULL,
0x0000000413127c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000100107824ULL, 0x000fe200078e0210ULL,
0x000000080b007c11ULL, 0x000fc4000f8e68ffULL, 0xfffffff807187812ULL, 0x000fe200078ee204ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000505137c10ULL, 0x000fc6000a7fe4ffULL,
0x0000008010047825ULL, 0x000fc800078e00ffULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x0001300000037836ULL, 0x000fe20000000000ULL, 0x0000007004007812ULL, 0x000fe400078ef802ULL,
0x0000007006047812ULL, 0x000fe200078ef802ULL, 0x0000001008157824ULL, 0x100fe200078e0203ULL,
0x0000007010067812ULL, 0x000fe200078ef802ULL, 0x0000001014177824ULL, 0x100fe200078e0203ULL,
0x0000000400027c10ULL, 0x000fe2000ff9e0ffULL, 0x0000001016197824ULL, 0x100fe200078e0203ULL,
0x0000000404047c10ULL, 0x000fe2000ffbe0ffULL, 0x00000010181b7824ULL, 0x000fe200078e0203ULL,
0x0000000406067c10ULL, 0x000fe2000ffde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000d901c46ULL, 0x0000000505037c10ULL, 0x000fc4000a7fe4ffULL,
0x0000000507057c10ULL, 0x000fe4000affe4ffULL, 0x0000000511077c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000002177faeULL, 0x0003e8000d101c46ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x00000000061b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000001038047824ULL, 0x000fe200078e00ffULL, 0x0000900000047ab9ULL, 0x000fc80000000a00ULL,
0x000000040d037211ULL, 0x002fca00078fe8ffULL, 0x0000000403067836ULL, 0x000fe40000000000ULL,
0x0000000103047824ULL, 0x140fe400078e020dULL, 0x0000000803077824ULL, 0x000fe400078e00ffULL,
0x0000000106057824ULL, 0x040fe400078e020dULL, 0x0000000806147824ULL, 0x000fe200078e00ffULL,
0xfffffff807087812ULL, 0x000fe200078ee204ULL, 0x0000000100047824ULL, 0x000fc400078e0203ULL,
0x0000000803077836ULL, 0x000fe20000000000ULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000c03107836ULL, 0x000fe20000000000ULL,
0x0000007004127812ULL, 0x000fe200078ef802ULL, 0x0000000100067824ULL, 0x040fe400078e0206ULL,
0x0000000100037824ULL, 0x040fe200078e0207ULL, 0x0000000412127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000100117824ULL, 0x000fe400078e0210ULL, 0x0000000107007824ULL, 0x140fe400078e020dULL,
0x0000000807137824ULL, 0x000fe200078e00ffULL, 0x000000080b077c11ULL, 0x000fe2000f8e68ffULL,
0x0000000110047824ULL, 0x000fc400078e020dULL, 0x0000000810157824ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fe200078ee200ULL, 0x00013000071b7836ULL, 0x000fe20000000000ULL,
0x0000000505137c10ULL, 0x000fe200087fe4ffULL, 0x0000008011107825ULL, 0x000fe200078e00ffULL,
0xfffffff815167812ULL, 0x000fc600078ee204ULL, 0x0000008006047825ULL, 0x000fc800078e00ffULL,
0x0000008003067825ULL, 0x000fe200078e00ffULL, 0x0000007004037812ULL, 0x000fc600078ef802ULL,
0x0000001008157824ULL, 0x100fe200078e021bULL, 0x0000007006047812ULL, 0x000fe200078ef802ULL,
0x0000001014177824ULL, 0x100fe200078e021bULL, 0x0000007010067812ULL, 0x000fe200078ef802ULL,
0x0000001000197824ULL, 0x100fe200078e021bULL, 0x0000000403027c10ULL, 0x000fe2000ff1e0ffULL,
0x00000010161b7824ULL, 0x000fe200078e021bULL, 0x0000000404047c10ULL, 0x000fe2000ff3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012157faeULL, 0x0003e2000b901c46ULL,
0x0000000406067c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000505037c10ULL, 0x000fc400087fe4ffULL,
0x0000000507057c10ULL, 0x000fe40008ffe4ffULL, 0x0000000511077c10ULL, 0x000fe200097fe4ffULL,
0x0000000002177faeULL, 0x0003e8000b901c46ULL, 0x0000000004197faeULL, 0x0003e8000b901c46ULL,
0x00000000061b7faeULL, 0x0003e4000b901c46ULL, 0x00000008ff007e24ULL, 0x000fe2000f8e00ffULL,
0x000000000b0472caULL, 0x000fe200000e0000ULL, 0x00000001ff037424ULL, 0x002fe200078e00ffULL,
0x000000ff3900720cULL, 0x000fe20003f05270ULL, 0x000176a800007836ULL, 0x000fe20000000000ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff507224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000000572caULL, 0x000fc400000e0000ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe400078e00ffULL,
0x000000080b027824ULL, 0x000fe400078e0200ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000003ff4e79a7ULL, 0x0002a20008500004ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00002003020279a7ULL, 0x002e62000850003fULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ac00048947ULL, 0x000fec0003800000ULL, 0x000000ffff007224ULL, 0x002fe200078e0003ULL,
0x00000002ff087819ULL, 0x000fe2000001163dULL, 0xff317217ff4d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fce00078e00ffULL,
0x0000000000147805ULL, 0x004fce0000015200ULL, 0x000000043d047824ULL, 0x000fca00078e00ffULL,
0xfffffff804177812ULL, 0x000fc800078ec0ffULL, 0x0176c800170075a7ULL, 0x000e620008000148ULL,
0x0000000817357c36ULL, 0x000fc80008000000ULL, 0x000176c835067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff347224ULL, 0x000fce00078e00ffULL,
0x000000103400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011417ULL,
0x0000003704047211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000204047819ULL, 0x000fc80000001217ULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000134347836ULL, 0x000fce0000000000ULL,
0x0176c800350075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000107007836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x0000010007447824ULL, 0x000fc600078e020aULL, 0x000000390000720cULL, 0x000fe20003f26070ULL,
0x0000004044047836ULL, 0x000fc80000000000ULL, 0x0000000509367c24ULL, 0x000fd0000f8e0204ULL,
0x0000000400089947ULL, 0x000fea0003800000ULL, 0x000000043b007248ULL, 0x000fe20007fe0000ULL,
0x0000001038157824ULL, 0x000fe200078e00ffULL, 0x00000003ff147819ULL, 0x100fe2000001160dULL,
0x00009000000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000100007824ULL, 0x000fe400078e0a04ULL,
0x0000000115047824ULL, 0x000fe400078e0214ULL, 0x0000000414177836ULL, 0x000fe20000000000ULL,
0x0000000015007248ULL, 0x000fe20007fe0000ULL, 0x0000000104167824ULL, 0x000fc400078e020dULL,
0x0000000804437824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a15ULL,
0x0000000115347824ULL, 0x000fe200078e0217ULL, 0xfffffff843437812ULL, 0x000fe200078ee216ULL,
0x0000000814167836ULL, 0x000fe20000000000ULL, 0x000000001400720cULL, 0x080fe20003f86070ULL,
0x0000000c14357836ULL, 0x000fe20000000000ULL, 0x000000001700720cULL, 0x080fe20003f66070ULL,
0x0000000134147824ULL, 0x000fe200078e020dULL, 0x000000001600720cULL, 0x080fe20003f46070ULL,
0x0000000834457824ULL, 0x000fe200078e00ffULL, 0x000000003500720cULL, 0x000fe20003f06070ULL,
0x0000000115177824ULL, 0x000fc400078e0216ULL, 0x0000000115157824ULL, 0x000fe200078e0235ULL,
0xfffffff845457812ULL, 0x000fe200078ee214ULL, 0x000000100d007824ULL, 0x000fe400078e00ffULL,
0x0000000104147824ULL, 0x100fe400078e0236ULL, 0x0000000134167824ULL, 0x100fe200078e0236ULL,
0x0000007000417812ULL, 0x000fe200078ec0ffULL, 0x0000000117347824ULL, 0x100fe200078e0236ULL,
0x000000080b007c11ULL, 0x000fe2000f8e68ffULL, 0x0000000115367824ULL, 0x000fc400078e0236ULL,
0x0000000115357824ULL, 0x140fe400078e020dULL, 0x00000008153c7824ULL, 0x000fe400078e00ffULL,
0x0000000117047824ULL, 0x040fe400078e020dULL, 0x0000000817477824ULL, 0x000fe200078e00ffULL,
0xfffffff83c497812ULL, 0x000fe200078ee235ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee204ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000004114147212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004116167212ULL, 0x080fe400078efcffULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fe4000ffde0ffULL,
0x0000004134347212ULL, 0x080fe200078efcffULL, 0x0001400000007836ULL, 0x000fe20000000000ULL,
0x0000004136367212ULL, 0x000fe400078efcffULL, 0x0000000b15157c10ULL, 0x000fe2000affe4ffULL,
0x0000001043417824ULL, 0x100fe200078e0200ULL, 0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001045437824ULL, 0x100fe200078e0200ULL, 0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001047457824ULL, 0x100fe200078e0200ULL, 0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL,
0x0000001049477824ULL, 0x000fe200078e0200ULL, 0x0000000b35357c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014417faeULL, 0x0003e2000e101c46ULL,
0x0000000b37377c10ULL, 0x000fc6000b7fe4ffULL, 0x0000000016437faeULL, 0x0003e8000d901c46ULL,
0x0000000034457faeULL, 0x0003e8000d101c46ULL, 0x0000000036477faeULL, 0x0003e2000c101c46ULL,
0x0000000000d47947ULL, 0x000fea0003800000ULL, 0x0000001038007824ULL, 0x000fe200078e00ffULL,
0x00009000000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000000d007211ULL, 0x000fca00078fe8ffULL,
0x0000000100047824ULL, 0x040fe400078e020dULL, 0x0000000800417824ULL, 0x000fe400078e00ffULL,
0x0000000400167836ULL, 0x000fc60000000000ULL, 0xfffffff841417812ULL, 0x000fe200078ee204ULL,
0x000000100d047824ULL, 0x000fe400078e00ffULL, 0x0000000116147824ULL, 0x040fe400078e020dULL,
0x0000000816437824ULL, 0x000fe200078e00ffULL, 0x0000007004457812ULL, 0x000fe200078ec0ffULL,
0x0000000800047836ULL, 0x000fe40000000000ULL, 0x0000000116167824ULL, 0x100fe200078e0236ULL,
0xfffffff843437812ULL, 0x000fe200078ee214ULL, 0x0000000100147824ULL, 0x000fc400078e0236ULL,
0x0000000c00007836ULL, 0x000fe40000000000ULL, 0x0000000104177824ULL, 0x040fe400078e020dULL,
0x00000008043c7824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee217ULL, 0x0000000104347824ULL, 0x100fe200078e0236ULL,
0x0000004514147212ULL, 0x000fe200078efcffULL, 0x0000000100367824ULL, 0x000fe400078e0236ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fc6000ff1e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000004516167212ULL, 0x080fe400078efcffULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000000100047824ULL, 0x000fe200078e020dULL,
0x0000004534347212ULL, 0x080fe200078efcffULL, 0x0000000800497824ULL, 0x000fe200078e00ffULL,
0x000000080b007c11ULL, 0x000fe2000f8e68ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff849497812ULL, 0x000fe200078ee204ULL,
0x0001400000007836ULL, 0x000fe20000000000ULL, 0x0000004536367212ULL, 0x000fc400078efcffULL,
0x0000000a34347c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0200ULL,
0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001043437824ULL, 0x100fe200078e0200ULL,
0x0000000b17177c10ULL, 0x000fe200087fe4ffULL, 0x0000001047457824ULL, 0x100fe200078e0200ULL,
0x0000000b35357c10ULL, 0x000fe200097fe4ffULL, 0x0000001049477824ULL, 0x000fe200078e0200ULL,
0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014417faeULL, 0x0003e8000b901c46ULL, 0x0000000016437faeULL, 0x0003e8000b901c46ULL,
0x0000000034457faeULL, 0x0003e8000b901c46ULL, 0x0000000036477faeULL, 0x0003e4000b901c46ULL,
0xfffffff00c047812ULL, 0x040fe200078ec0ffULL, 0x00000001ff357424ULL, 0x002fe200078e00ffULL,
0xffffffe00c007812ULL, 0x040fe400078ec0ffULL, 0x000000100c157812ULL, 0x000fe200078ec0ffULL,
0x0000000804487c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000815177c10ULL, 0x000fe4000fffe000ULL, 0x00000000480572caULL, 0x000fc600000e0000ULL,
0x0000000838347824ULL, 0x000fd400078e0217ULL, 0x000176b005057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176b035484879a7ULL, 0x0002e4000850003fULL, 0x01760835343479a7ULL, 0x002e64000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x000000080c007812ULL, 0x000fca00078ec0ffULL,
0x00000001174b7824ULL, 0x000fc800078e0200ULL, 0x017608354b0075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff047224ULL, 0x000fce00078e00ffULL,
0x000000100400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011417ULL,
0x0000003700007211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000200007819ULL, 0x000fc80000001217ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000104047836ULL, 0x000fce0000000000ULL,
0x017608354b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000100d3e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff457819ULL, 0x000fe2000001160dULL,
0x000000203d007824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000703e3e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff527224ULL, 0x000fe200078e004dULL,
0xffffff8000157812ULL, 0x000fe400078ec0ffULL, 0x0000000c45457812ULL, 0x000fe400078ec0ffULL,
0x000000083e007c10ULL, 0x000fca000fffe015ULL, 0x0000000100007824ULL, 0x000fca00078e0245ULL,
0x0170000000047984ULL, 0x000e680000000800ULL, 0x0172000000157984ULL, 0x0009220000000800ULL,
0x0000004d0400720bULL, 0x002fda0003f1d000ULL, 0x0000000000147806ULL, 0x000fc800000e0100ULL,
0x0000ffff14147812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x01cfea0003800000ULL,
0x0000003d0800720cULL, 0x000fe40003f45270ULL, 0x0000004d0400720bULL, 0x0c0fe40003f14000ULL,
0x0000004d04527209ULL, 0x000fd20007810000ULL, 0x000000083d00ac11ULL, 0x000fe4000f8e38ffULL,
0x0000000000357806ULL, 0x000fe400000e0100ULL, 0x000000004517a210ULL, 0x000fe40007ffe03eULL,
0x0000991035007816ULL, 0x000fc600000000ffULL, 0x017400521700a388ULL, 0x0003e20000000800ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000004d52007221ULL, 0x000fe20000010100ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b00007820ULL, 0x000fc80000410000ULL,
0x0000000000177308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff007819ULL, 0x002fcc000001160dULL, 0x00001f0017007589ULL, 0x004e6400000e0000ULL,
0x0000000018187220ULL, 0x082fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x0000000028287220ULL, 0x080fe20000410000ULL, 0x0000000029297220ULL, 0x080fe20000410000ULL,
0x000000002c2c7220ULL, 0x080fe20000410000ULL, 0x000000002d2d7220ULL, 0x080fe20000410000ULL,
0x0000000030307220ULL, 0x080fe20000410000ULL, 0x0000000031317220ULL, 0x080fe20000410000ULL,
0x0000000024247220ULL, 0x080fe20000410000ULL, 0x0000000025257220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x000fce0000410000ULL,
0x0000001750507220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080d007811ULL, 0x002fcc00078ff0ffULL, 0x00001f0017007589ULL, 0x000e6400000e0000ULL,
0x000000001a1a7220ULL, 0x082fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000002a2a7220ULL, 0x080fe20000410000ULL, 0x000000002b2b7220ULL, 0x080fe20000410000ULL,
0x000000002e2e7220ULL, 0x080fe20000410000ULL, 0x000000002f2f7220ULL, 0x080fe20000410000ULL,
0x0000000032327220ULL, 0x080fe20000410000ULL, 0x0000000033337220ULL, 0x080fe20000410000ULL,
0x0000000026267220ULL, 0x080fe20000410000ULL, 0x0000000027277220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x000fce0000410000ULL,
0x0000ffff14ff7812ULL, 0x000fe20007806035ULL, 0x00000001ff347424ULL, 0x000fd800078e00ffULL,
0x8000005204040221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b04040820ULL, 0x000fc80000410000ULL, 0x0000000400050308ULL, 0x000ea40000000800ULL,
0x0000000515150220ULL, 0x004fce0000410000ULL, 0x0000005015507221ULL, 0x000fce0000010000ULL,
0x0000000000147805ULL, 0x000fe40000015200ULL, 0xfffffff00c007812ULL, 0x002fc800078ec0ffULL,
0x0176a84f000075a7ULL, 0x000ea20008000148ULL, 0x0000000800047c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011417ULL,
0x0000003500007211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000200007819ULL, 0x000fc80000001217ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176a84f040075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000070d4a7812ULL, 0x000fe200078ec0ffULL, 0x000002003d007824ULL, 0x000fe200078e00ffULL,
0x00000004ff4d7819ULL, 0x000fe4000001160dULL, 0x0000991034047816ULL, 0x000fe400000000ffULL,
0x000000080d477812ULL, 0x000fe200078ec0ffULL, 0x000000040b157824ULL, 0x100fe200078e024dULL,
0x000000084a4c7812ULL, 0x000fe200078ef80dULL, 0x00000004384d7824ULL, 0x000fe200078e024dULL,
0x000000ff0400720cULL, 0x000fc40003f05270ULL, 0x0000004a47407212ULL, 0x000fe200078efcffULL,
0x000000014c4e7824ULL, 0x040fe200078e0215ULL, 0x000000080b047c11ULL, 0x000fe2000f8e68ffULL,
0x000000084c157824ULL, 0x000fe200078e00ffULL, 0xfffff80000007812ULL, 0x000fe200078ec0ffULL,
0x0000000140417824ULL, 0x040fe400078e024dULL, 0x0000000840147824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee24eULL, 0x00013000043c7836ULL, 0x000fe40000000000ULL,
0x0000000800467c36ULL, 0x000fe20008000000ULL, 0xfffffff814177812ULL, 0x000fc600078ee241ULL,
0x0000001015147824ULL, 0x000fe400078e0246ULL, 0x0000001017347824ULL, 0x000fe200078e023cULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000005ff00723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541000007816ULL, 0x000fca0000000000ULL, 0x00001f0300037589ULL, 0x0002a800000e0000ULL,
0x00001f1500027589ULL, 0x0002e400000e0000ULL, 0x011000001414783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x088fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x0000000241417836ULL, 0x000fe20000000000ULL,
0x0000001047007812ULL, 0x000fe200078efe4aULL, 0x000000084c4f7824ULL, 0x000fe400078e00ffULL,
0x000000024e4e7836ULL, 0x000fe20000000000ULL, 0xfffffff840417812ULL, 0x000fe200078ee241ULL,
0x000000014d4d7824ULL, 0x000fc600078e0200ULL, 0xfffffff84f477812ULL, 0x000fe200078ee24eULL,
0x0000001041417824ULL, 0x000fcc00078e023cULL, 0x000000004140783bULL, 0x000f620000004200ULL,
0x00000010ff647819ULL, 0x010fe40000011635ULL, 0x0000ffff34637812ULL, 0x000fe400078ec0ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fe40000011636ULL,
0x00000008ff637819ULL, 0x000fe40000011663ULL, 0x000000ff344c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff36517812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011636ULL,
0x0000ffff36547812ULL, 0x000fe400078ec0ffULL, 0x00000010ff367819ULL, 0x100fe40000011637ULL,
0x00000010ff657819ULL, 0x000fe40000011634ULL, 0x00000018ff667819ULL, 0x000fc40000011637ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011634ULL,
0x000000ff37537812ULL, 0x040fe400078ec0ffULL, 0x0000ffff37557812ULL, 0x000fe400078ec0ffULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff354f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff347819ULL, 0x000fe40000011635ULL,
0x0000ffff355d7812ULL, 0x000fe400078ec0ffULL, 0x0000004cff60723eULL, 0x000fe400020006ffULL,
0x00000010ff5f7819ULL, 0x128fe40000011640ULL, 0x000000ff40577812ULL, 0x000fe200078ec0ffULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x00000018ff567819ULL, 0x000fc40000011640ULL,
0x0000ffff40377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff627819ULL, 0x000fe40000011641ULL,
0x00000010ff357819ULL, 0x100fe40000011643ULL, 0x000000ff436a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011643ULL, 0x0000ffff434c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff36367812ULL, 0x000fe400078ec0ffULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x00000066ff43723eULL, 0x000fe200020006ffULL, 0x20000064ff667230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000063ff647230ULL, 0x000fe20000004100ULL,
0x00000008ff5d7819ULL, 0x000fe2000001165dULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fc400020006ffULL, 0x000000ff62637812ULL, 0x000fe200078ec0ffULL,
0x2000005cff627230ULL, 0x000fe20000004100ULL, 0x0000004fff4f723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000ffff415e7812ULL, 0x000fe200078ec0ffULL,
0x2000004fff617230ULL, 0x000fe20000004100ULL, 0x00000053ff53723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x00000018ff677819ULL, 0x000fc40000011641ULL,
0x0000005dff5d723eULL, 0x000fe200020006ffULL, 0x20000053ff597230ULL, 0x000fe20000004100ULL,
0x00000063ff5c723eULL, 0x000fe200020006ffULL, 0x20000036ff637230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe40000011637ULL, 0x00000008ff367819ULL, 0x000fe2000001165eULL,
0x2000005cff5e7230ULL, 0x000fe20000004100ULL, 0x00000067ff53723eULL, 0x000fe200020006ffULL,
0x2000005dff677230ULL, 0x000fe20000004100ULL, 0x0000004aff5b723eULL, 0x000fc400020006ffULL,
0x00000034ff5a723eULL, 0x000fe200020006ffULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000037ff5c723eULL, 0x000fe200020006ffULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000036ff5d723eULL, 0x000fe200020006ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011660ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe20000011661ULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x000000ff41587812ULL, 0x000fe400078ec0ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000010ff347819ULL, 0x000fe40000011642ULL, 0x0000105465367816ULL, 0x000fe40000000036ULL,
0x0000105466377816ULL, 0x000fc40000000037ULL, 0x000000ff42697812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe40000011642ULL, 0x0000ffff424a7812ULL, 0x000fe200078ec0ffULL,
0x000000361418723cULL, 0x002fe20000041818ULL, 0x00000058ff42723eULL, 0x000fe200020006ffULL,
0x20000051ff587230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x000000ff34607812ULL, 0x000fc400078ec0ffULL, 0x000000ff35617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff347819ULL, 0x000fe40000011664ULL, 0x00000010ff357819ULL, 0x000fe40000011667ULL,
0x00000057ff57723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x000010545b347816ULL, 0x000fe40000000034ULL, 0x000010545a357816ULL, 0x000fe20000000035ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe40000011658ULL,
0x00000010ff377819ULL, 0x000fe40000011662ULL, 0x00000056ff41723eULL, 0x000fe200020006ffULL,
0x20000057ff567230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fe20000011659ULL,
0x20000042ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000041ff517230ULL, 0x000fe20000004100ULL, 0x0000105463377816ULL, 0x000fc4000000005aULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000010ff347819ULL, 0x000fe40000011656ULL,
0x00000010ff357819ULL, 0x000fe20000011657ULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000006aff4f723eULL, 0x000fc400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000010545f347816ULL, 0x000fe20000000034ULL, 0x20000060ff597230ULL, 0x000fe20000004100ULL,
0x000010545e357816ULL, 0x000fe20000000035ULL, 0x20000061ff587230ULL, 0x000fe20000004100ULL,
0x00000008ff547819ULL, 0x000fe40000011654ULL, 0x00000010ff517819ULL, 0x000fc40000011651ULL,
0x00000010ff367819ULL, 0x000fe2000001165cULL, 0x000000341424723cULL, 0x000fe20000041824ULL,
0x0000004eff41723eULL, 0x000fe200020006ffULL, 0x20000069ff4e7230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fe40000011653ULL, 0x00000010ff377819ULL, 0x000fe2000001165dULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff557819ULL, 0x000fe40000011655ULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x0000105451367816ULL, 0x000fe40000000036ULL,
0x00000008ff4a7819ULL, 0x000fe2000001164aULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000008ff517819ULL, 0x000fe4000001164cULL, 0x0000105456377816ULL, 0x000fe40000000037ULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x00000010ff347819ULL, 0x000fc4000001164eULL,
0x00000010ff357819ULL, 0x000fe2000001164fULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x000000361420723cULL, 0x000fe20000041820ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000068ff42723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x0000004aff4c723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x0000105459347816ULL, 0x000fe20000000034ULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000105458357816ULL, 0x000fe20000000035ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff417819ULL, 0x000fc40000011641ULL,
0x00000010ff367819ULL, 0x000fe40000011654ULL, 0x00000010ff4a7819ULL, 0x000fe20000011643ULL,
0x00000034141c723cULL, 0x000fe2000004181cULL, 0x00000010ff377819ULL, 0x000fe40000011655ULL,
0x0000105441367816ULL, 0x000fe40000000036ULL, 0x00000010ff417819ULL, 0x000fe20000011642ULL,
0x0000000800427824ULL, 0x000fe200078e00ffULL, 0x00000010ff4c7819ULL, 0x000fc4000001164cULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff357819ULL, 0x000fe40000011651ULL,
0x000010544a377816ULL, 0x000fe40000000037ULL, 0x0000105441347816ULL, 0x000fe2000000004cULL,
0x00000010474c7824ULL, 0x000fe200078e0246ULL, 0x0000105440357816ULL, 0x000fc60000000035ULL,
0x000000361430723cULL, 0x000fec0000041830ULL, 0x000000341410723cULL, 0x000fe20000041810ULL,
0xfffffff842377812ULL, 0x000fe200078ee24dULL, 0x011000004c14783bULL, 0x0002e80000000200ULL,
0x0000001037377824ULL, 0x000fe200078e023cULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x080fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x0000000800407824ULL, 0x000fe200078e00ffULL,
0x000000003734783bULL, 0x000f220000004200ULL, 0x000000024d4d7836ULL, 0x000fca0000000000ULL,
0xfffffff8404d7812ULL, 0x000fca00078ee24dULL, 0x000000104d407824ULL, 0x000fcc00078e023cULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x00000010ff647819ULL, 0x010fe40000011634ULL,
0x0000ffff34627812ULL, 0x000fe400078ec0ffULL, 0x000000ff354d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x000fe40000011636ULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff627819ULL, 0x000fc40000011662ULL, 0x0000004dff4d723eULL, 0x000fe400020006ffULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff637819ULL, 0x000fe20000011635ULL,
0x2000004dff607230ULL, 0x000fe20000004100ULL, 0x00000018ff657819ULL, 0x022fe40000011640ULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000062ff62723eULL, 0x000fc400020006ffULL,
0x000000ff344a7812ULL, 0x000fe400078ec0ffULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000ffff355c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff36517812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4f7819ULL, 0x000fe40000011636ULL, 0x00000010ff5d7819ULL, 0x000fc40000011637ULL,
0x000000ff37567812ULL, 0x040fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011637ULL,
0x0000ffff36367812ULL, 0x000fe400078ec0ffULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x000fe40000011640ULL, 0x00000065ff4d723eULL, 0x000fe200020006ffULL,
0x20000064ff657230ULL, 0x000fe20000004100ULL, 0x000000ff63637812ULL, 0x000fe200078ec0ffULL,
0x20000062ff647230ULL, 0x000fe20000004100ULL, 0x00000018ff477819ULL, 0x000fe20000011634ULL,
0x2000005bff627230ULL, 0x000fe20000004100ULL, 0x00000010ff5f7819ULL, 0x000fe20000011641ULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000018ff347819ULL, 0x000fc40000011635ULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000008ff5c7819ULL, 0x000fe4000001165cULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x2000004aff617230ULL, 0x000fe20000004100ULL,
0x00000018ff667819ULL, 0x000fe40000011641ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000008ff367819ULL, 0x000fc40000011636ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x000000ff5e5b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff40577812ULL, 0x000fe400078ec0ffULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x00000047ff5a723eULL, 0x000fc400020006ffULL, 0x00000034ff59723eULL, 0x000fe400020006ffULL,
0x0000ffff40347812ULL, 0x000fe200078ec0ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff41677812ULL, 0x000fe200078ec0ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fc40000011642ULL, 0x000000ff42687812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff42477812ULL, 0x000fe400078ec0ffULL,
0x00000066ff4a723eULL, 0x000fe200020006ffULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x2000005dff637230ULL, 0x000fe20000004100ULL,
0x00000037ff37723eULL, 0x000fe200020006ffULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe200020006ffULL, 0x20000036ff5d7230ULL, 0x000fe20000004100ULL,
0x00000057ff42723eULL, 0x000fe200020006ffULL, 0x20000051ff577230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x20000037ff5e7230ULL, 0x000fe20000004100ULL,
0x0000ffff41357812ULL, 0x000fc400078ec0ffULL, 0x00000067ff51723eULL, 0x000fe200020006ffULL,
0x2000005cff677230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011661ULL,
0x2000005bff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011660ULL,
0x2000005fff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff657819ULL, 0x000fe20000011665ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000008ff5f7819ULL, 0x000fc40000011634ULL, 0x00000008ff607819ULL, 0x000fe40000011635ULL,
0x00000010ff357819ULL, 0x000fe4000001165aULL, 0x00000010ff347819ULL, 0x000fe40000011664ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000010ff5a7819ULL, 0x000fe40000011659ULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x20000056ff587230ULL, 0x000fe20000004100ULL,
0x0000105465367816ULL, 0x000fc40000000036ULL, 0x0000105466377816ULL, 0x000fe40000000037ULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x2000004fff567230ULL, 0x000fe20000004100ULL,
0x000010545a357816ULL, 0x000fe20000000067ULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000000361418723cULL, 0x008fe20000041818ULL, 0x00000010ff597819ULL, 0x000fe20000011658ULL,
0x20000042ff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fc40000011663ULL,
0x00000010ff557819ULL, 0x000fe20000011655ULL, 0x000000341428723cULL, 0x000fe20000041828ULL,
0x00000010ff367819ULL, 0x000fe40000011657ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165eULL, 0x00000010ff357819ULL, 0x000fe40000011656ULL,
0x00000010ff347819ULL, 0x000fc4000001165dULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x00000010ff547819ULL, 0x000fe40000011643ULL, 0x000010545a377816ULL, 0x000fe40000000059ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000060ff60723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x2000005fff577230ULL, 0x000fe20000004100ULL,
0x0000105455357816ULL, 0x000fe2000000005eULL, 0x20000060ff587230ULL, 0x000fe20000004100ULL,
0x000000ff54547812ULL, 0x000fe200078ec0ffULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x0000ffff434e7812ULL, 0x000fc400078ec0ffULL, 0x000000ff43697812ULL, 0x000fe400078ec0ffULL,
0x000000ff53537812ULL, 0x000fe200078ec0ffULL, 0x000000341430723cULL, 0x000fe20000041830ULL,
0x00000054ff56723eULL, 0x000fe400020006ffULL, 0x00000010ff367819ULL, 0x000fe4000001164fULL,
0x00000010ff377819ULL, 0x000fe2000001165cULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000018ff417819ULL, 0x000fc40000011643ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff547819ULL, 0x000fe4000001165bULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x00000068ff42723eULL, 0x000fe400020006ffULL, 0x00000069ff43723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff4d7819ULL, 0x000fe2000001164dULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x000fc40000011657ULL, 0x00000010ff357819ULL, 0x000fe40000011658ULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x0000105454377816ULL, 0x000fe40000000051ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000008ff477819ULL, 0x000fc40000011647ULL,
0x000010544d347816ULL, 0x000fe20000000034ULL, 0x2000004eff4e7230ULL, 0x000fe20000004100ULL,
0x000010544a357816ULL, 0x000fe20000000035ULL, 0x000000361424723cULL, 0x000fe20000041824ULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe400020006ffULL,
0x00000010ff537819ULL, 0x000fe20000011653ULL, 0x000000341420723cULL, 0x000fe20000041820ULL,
0x00000010ff367819ULL, 0x000fe20000011642ULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe20000011643ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fc40000011656ULL, 0x00000010ff347819ULL, 0x000fe40000011641ULL,
0x00000010ff417819ULL, 0x000fe4000001164eULL, 0x0000105453367816ULL, 0x000fe40000000036ULL,
0x0000105456377816ULL, 0x000fe40000000037ULL, 0x0000105434417816ULL, 0x000fe20000000041ULL,
0x000000023d347824ULL, 0x000fe200078e00ffULL, 0x00000010ff407819ULL, 0x000fc40000011640ULL,
0x00000010ff477819ULL, 0x000fe20000011647ULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x000000080b357c11ULL, 0x000fe4000f8e18ffULL, 0x0000105440407816ULL, 0x000fc80000000047ULL,
0x00000001ff377424ULL, 0x000fe200078e00ffULL, 0xfffffff834367812ULL, 0x000fe400078ec0ffULL,
0x000000401410723cULL, 0x000fe20000041810ULL, 0x0176c837353479a7ULL, 0x0002e2000850003fULL,
0x0176883736ff79a7ULL, 0x0003de0008500008ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x002fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000008044167836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fc60000000800ULL,
0x0000000509357c24ULL, 0x000fe2000f8e0216ULL, 0x0000000000f89947ULL, 0x000fec0003800000ULL,
0x000000163b147248ULL, 0x000fe20007fe0000ULL, 0x0000001038177824ULL, 0x000fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe2000001160dULL, 0x00009000000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000114147824ULL, 0x000fe400078e0a16ULL, 0x0000000117167824ULL, 0x000fe400078e0215ULL,
0x0000000415367836ULL, 0x002fe20000000000ULL, 0x0000001417147248ULL, 0x000fe20007fe0000ULL,
0x0000000116347824ULL, 0x000fc400078e020dULL, 0x0000000816417824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe400078e0a17ULL, 0x0000000c15377836ULL, 0x000fe20000000000ULL,
0xfffffff841417812ULL, 0x000fe200078ee234ULL, 0x0000000815347836ULL, 0x000fe20000000000ULL,
0x000000143600720cULL, 0x080fe20003f66070ULL, 0x0000000117367824ULL, 0x000fe200078e0236ULL,
0x000000141500720cULL, 0x080fe20003f86070ULL, 0x0000000116157824ULL, 0x000fe200078e0235ULL,
0x000000143400720cULL, 0x080fe20003f46070ULL, 0x0000000136167824ULL, 0x040fe200078e020dULL,
0x000000143700720cULL, 0x000fe20003f06070ULL, 0x0000000836437824ULL, 0x000fc400078e00ffULL,
0x0000000117407824ULL, 0x000fe400078e0234ULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fc600078ee216ULL, 0x0000000136167824ULL, 0x000fe200078e0235ULL,
0x0000003e14147212ULL, 0x000fe200078efcffULL, 0x0000000117427824ULL, 0x000fe400078e0237ULL,
0x0000000140347824ULL, 0x040fe200078e0235ULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x0000000140377824ULL, 0x040fe400078e020dULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x0000008016167825ULL, 0x000fc600078e00ffULL,
0xfffffff840477812ULL, 0x000fe200078ee237ULL, 0x0000000142367824ULL, 0x000fe200078e0235ULL,
0x0000003e16167212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003e34347212ULL, 0x080fe400078efcffULL, 0x0000000b17177c10ULL, 0x000fe2000affe4ffULL,
0x0000000142407824ULL, 0x000fe200078e020dULL, 0x0000003e36367212ULL, 0x000fe200078efcffULL,
0x00000008424d7824ULL, 0x000fe200078e00ffULL, 0x0000000a34347c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL,
0x0000001043437824ULL, 0x100fe200078e023cULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee240ULL,
0x0000001047477824ULL, 0x100fe200078e023cULL, 0x0000000b35357c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014417faeULL, 0x0003e2000e101c46ULL,
0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104d4d7824ULL, 0x000fc400078e023cULL,
0x0000000016437faeULL, 0x0003e8000d901c46ULL, 0x0000000034477faeULL, 0x0003e8000d101c46ULL,
0x00000000364d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001038147824ULL, 0x000fe200078e00ffULL, 0x00009000000a7ab9ULL, 0x000fc80000000a00ULL,
0x000000140d167211ULL, 0x000fca00078fe8ffULL, 0x0000000116157824ULL, 0x040fe400078e020dULL,
0x0000000816367824ULL, 0x042fe400078e00ffULL, 0x0000000416347836ULL, 0x000fe40000000000ULL,
0x0000000c16427836ULL, 0x000fe20000000000ULL, 0xfffffff836417812ULL, 0x000fe200078ee215ULL,
0x0000000816407836ULL, 0x000fe40000000000ULL, 0x0000000116147824ULL, 0x000fc400078e0235ULL,
0x0000000134367824ULL, 0x040fe400078e0235ULL, 0x0000000134177824ULL, 0x040fe400078e020dULL,
0x00000008344a7824ULL, 0x000fe400078e00ffULL, 0x0000000142347824ULL, 0x040fe400078e0235ULL,
0x0000000142377824ULL, 0x000fe200078e020dULL, 0xfffffff84a437812ULL, 0x000fe200078ee217ULL,
0x0000000140167824ULL, 0x000fc400078e0235ULL, 0x0000000842427824ULL, 0x000fe400078e00ffULL,
0x0000000140357824ULL, 0x040fe400078e020dULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0xfffffff8424d7812ULL, 0x000fe200078ee237ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff840477812ULL, 0x000fe200078ee235ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003e14147212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003e36367212ULL, 0x080fe400078efcffULL, 0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003e16167212ULL, 0x080fe400078efcffULL,
0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001041417824ULL, 0x100fe200078e023cULL,
0x0000003e34347212ULL, 0x000fe200078efcffULL, 0x0000001043437824ULL, 0x100fe200078e023cULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000001047477824ULL, 0x100fe200078e023cULL,
0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL, 0x000000104d4d7824ULL, 0x000fe200078e023cULL,
0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014417faeULL, 0x0003e2000b901c46ULL, 0x0000000b37377c10ULL, 0x000fc400097fe4ffULL,
0x0000000b17177c10ULL, 0x000fe400087fe4ffULL, 0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL,
0x0000000036437faeULL, 0x0003e8000b901c46ULL, 0x0000000016477faeULL, 0x0003e8000b901c46ULL,
0x00000000344d7faeULL, 0x0003e4000b901c46ULL, 0x000000100b147824ULL, 0x002fe200078e00ffULL,
0xffffffe00c167812ULL, 0x000fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x0000000814567c36ULL, 0x000fe20008000000ULL, 0x0000001014157812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000560572caULL, 0x000fe400000e0000ULL,
0x0000000815157c10ULL, 0x000fe4000fffe016ULL, 0x000000080c167812ULL, 0x000fca00078ec0ffULL,
0x0000000116157824ULL, 0x000fc800078e0215ULL, 0x000176a805057890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0176a834565679a7ULL, 0x0002e4000850003fULL, 0x01762834153479a7ULL, 0x0022a4000850003fULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x017628354b0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fce0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x017628354b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000203d147824ULL, 0x000fe400078e00ffULL, 0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000008015147810ULL, 0x000fc80007ffe014ULL, 0x0000001445147210ULL, 0x000fca0007ffe03eULL,
0x0170000014157984ULL, 0x000e680000000800ULL, 0x0172000014177984ULL, 0x0004a20000000800ULL,
0x000000521500720bULL, 0x002fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16167812ULL, 0x000fda000780c0ffULL, 0x0000000400008947ULL, 0x00cfea0003800000ULL,
0x0000000108147836ULL, 0x000fe20000000000ULL, 0x000000521500720bULL, 0x0c0fe40003f14000ULL,
0x0000005215367209ULL, 0x000fe40007810000ULL, 0x0000003d1400720cULL, 0x000fd20003f45270ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000083d14ac11ULL, 0x000fc8000f8e38ffULL,
0x000000144537a210ULL, 0x000fe40007ffe03eULL, 0x0000991035147816ULL, 0x000fc600000000ffULL,
0x017400363700a388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000003652527221ULL, 0x000fe20000010000ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b52527820ULL, 0x000fc80000410000ULL, 0x0000005200377308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x000fcc000001160dULL,
0x00001f1437147589ULL, 0x004ea400000e0000ULL, 0x0000001814187220ULL, 0x044fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000003750507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x000fcc00078ff0ffULL,
0x00001f1437147589ULL, 0x000ea400000e0000ULL, 0x0000001a141a7220ULL, 0x044fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007806035ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x002fd400078e0036ULL,
0x8000003615150221ULL, 0x100fe20000010000ULL, 0x000000ffff520224ULL, 0x000fe200078e0036ULL,
0x00007610ff340816ULL, 0x000fe40000000034ULL, 0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL,
0x0000001500050308ULL, 0x000e640000000800ULL, 0x0000000517170220ULL, 0x002fce0000410000ULL,
0x0000005017507221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x000fe40000015200ULL,
0xfffffff00c177812ULL, 0x000fc800078ec0ffULL, 0x0176b049170075a7ULL, 0x000e620008000148ULL,
0x0000000817377c36ULL, 0x000fe20008000000ULL, 0x00000000005c0947ULL, 0x002fec0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x0176b049370075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000991034357816ULL, 0x000fe200000000ffULL,
0x000000023d537824ULL, 0x000fe200078e00ffULL, 0x000000070d347812ULL, 0x000fe200078ec0ffULL,
0x000000043d167824ULL, 0x000fe200078e00ffULL, 0x000000080d157812ULL, 0x000fe200078ec0ffULL,
0x0001400004487836ULL, 0x000fe20000000000ULL, 0x0000000453147812ULL, 0x000fe400078ec0ffULL,
0x0000003415427212ULL, 0x000fe200078efcffULL, 0x000000ffff157224ULL, 0x000fe200078e0035ULL,
0x0000000834177812ULL, 0x000fc400078ef80dULL, 0x000000140d147211ULL, 0x000fe200078fe0ffULL,
0x0000000842497824ULL, 0x000fe200078e00ffULL, 0x000000ff1500720cULL, 0x000fe40003f05270ULL,
0x0000000416167812ULL, 0x000fe200078ec0ffULL, 0x00000001174a7824ULL, 0x040fe400078e0214ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x000000160d517211ULL, 0x000fc800078fe0ffULL,
0xfffffff817157812ULL, 0x000fe200078ee24aULL, 0x0000000142407824ULL, 0x000fc800078e0251ULL,
0x00000010154e7824ULL, 0x000fe200078e0246ULL, 0xfffffff849497812ULL, 0x000fe200078ee240ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000005ff02723eULL, 0x000fc600000010ffULL, 0x0000000803157836ULL, 0x000fe20000000000ULL,
0x0000541002147816ULL, 0x000fca0000000002ULL, 0x00001f0314037589ULL, 0x0002a800000e0000ULL,
0x00001f1514027589ULL, 0x0002e400000e0000ULL, 0x011800004e14783bULL, 0x0022e20000000200ULL,
0x0000001049497824ULL, 0x000fe200078e0248ULL, 0x0000000000100947ULL, 0x000fec0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000215157232ULL, 0x080fe40000200000ULL, 0x0000000217177232ULL, 0x000fce0000200000ULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0x000000004934783bULL, 0x000f220000004200ULL,
0x00000002404f7836ULL, 0x000fca0000000000ULL, 0xfffffff8424f7812ULL, 0x000fca00078ee24fULL,
0x000000104f407824ULL, 0x000fcc00078e0248ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x000000ff344d7812ULL, 0x010fe400078ec0ffULL, 0x00000010ff647819ULL, 0x100fe40000011637ULL,
0x000000ff376e7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011637ULL,
0x0000ffff375c7812ULL, 0x000fe400078ec0ffULL, 0x0000004dff66723eULL, 0x000fc400020006ffULL,
0x00000010ff697819ULL, 0x100fe40000011634ULL, 0x00000018ff597819ULL, 0x000fe20000011634ULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x0000ffff34477812ULL, 0x000fe400078ec0ffULL,
0x000000ff426c7812ULL, 0x022fe400078ec0ffULL, 0x00000018ff557819ULL, 0x000fe40000011642ULL,
0x0000006cff6c723eULL, 0x000fc400020006ffULL, 0x00000010ff607819ULL, 0x100fe40000011640ULL,
0x000000ff406f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff4d7819ULL, 0x000fe40000011640ULL,
0x0000ffff40377812ULL, 0x000fe400078ec0ffULL, 0x00000010ff347819ULL, 0x000fe40000011642ULL,
0x0000ffff42407812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011643ULL,
0x00000010ff6a7819ULL, 0x000fe40000011635ULL, 0x00000010ff5d7819ULL, 0x000fe40000011643ULL,
0x000000ff43427812ULL, 0x040fe400078ec0ffULL, 0x0000ffff43587812ULL, 0x000fe400078ec0ffULL,
0x00000055ff43723eULL, 0x000fe200020006ffULL, 0x2000006cff557230ULL, 0x000fe20000004100ULL,
0x000000ff355b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff35687812ULL, 0x000fe200078ec0ffULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000006bff6c723eULL, 0x000fe400020006ffULL,
0x0000ffff36617812ULL, 0x000fe400078ec0ffULL, 0x000000ff69697812ULL, 0x000fe400078ec0ffULL,
0x000000ff6a6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff657819ULL, 0x000fc40000011641ULL,
0x00000008ff6a7819ULL, 0x000fe20000011647ULL, 0x2000006cff477230ULL, 0x000fe20000004100ULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff687819ULL, 0x000fe40000011668ULL,
0x000000ff64647812ULL, 0x000fe200078ec0ffULL, 0x2000005bff637230ULL, 0x000fe20000004100ULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000008ff617819ULL, 0x000fc40000011661ULL,
0x00000018ff5a7819ULL, 0x000fe40000011635ULL, 0x0000006aff6a723eULL, 0x000fe400020006ffULL,
0x000000ff65657812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000008ff5c7819ULL, 0x000fc4000001165cULL,
0x00000059ff35723eULL, 0x000fe400020006ffULL, 0x0000006dff5b723eULL, 0x000fe400020006ffULL,
0x0000006bff6c723eULL, 0x000fe200020006ffULL, 0x20000069ff6b7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000006aff697230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000068ff6a7230ULL, 0x000fe20000004100ULL,
0x00000065ff6d723eULL, 0x000fe200020006ffULL, 0x20000064ff687230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x100fe20000011636ULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x000000ff365e7812ULL, 0x000fe200078ec0ffULL, 0x20000061ff647230ULL, 0x000fe20000004100ULL,
0x00000018ff5f7819ULL, 0x000fe20000011636ULL, 0x2000005aff627230ULL, 0x000fe20000004100ULL,
0x0000ffff41367812ULL, 0x000fe200078ec0ffULL, 0x2000006dff617230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x00000008ff377819ULL, 0x000fe20000011637ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000008ff6d7819ULL, 0x000fe20000011636ULL, 0x2000005cff657230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc40000011666ULL, 0x00000037ff5c723eULL, 0x000fe400020006ffULL,
0x000000ff34667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff377819ULL, 0x000fe20000011663ULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff357819ULL, 0x000fe40000011635ULL,
0x00000010ff347819ULL, 0x000fe40000011669ULL, 0x00000010ff637819ULL, 0x000fc40000011662ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x000000ff41707812ULL, 0x000fe400078ec0ffULL,
0x00000018ff547819ULL, 0x000fe40000011641ULL, 0x0000005fff41723eULL, 0x000fe400020006ffULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x0000105463357816ULL, 0x000fe2000000006aULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x000000ff67677812ULL, 0x000fc400078ec0ffULL,
0x000000ff60607812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6b7819ULL, 0x000fe2000001166bULL,
0x000000341428723cULL, 0x008fe20000041828ULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x0000006fff59723eULL, 0x000fe200020006ffULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000067ff67723eULL, 0x000fe200020006ffULL, 0x2000006eff5f7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x000010546b367816ULL, 0x000fe20000000036ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x000010546c377816ULL, 0x000fe20000000037ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x00000070ff5a723eULL, 0x000fc400020006ffULL, 0x00000008ff357819ULL, 0x000fe40000011640ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fe20000011664ULL, 0x000000361418723cULL, 0x000fe20000041818ULL,
0x00000010ff347819ULL, 0x000fe4000001165bULL, 0x00000010ff657819ULL, 0x000fe40000011665ULL,
0x0000004dff4d723eULL, 0x000fc400020006ffULL, 0x00000054ff54723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x2000004dff4d7230ULL, 0x000fe20000004100ULL,
0x0000105441407816ULL, 0x000fe20000000040ULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe2000001165eULL, 0x2000006dff627230ULL, 0x000fe20000004100ULL,
0x0000105434417816ULL, 0x000fe40000000065ULL, 0x000000ff5d637812ULL, 0x000fc400078ec0ffULL,
0x00000035ff5e723eULL, 0x000fe400020006ffULL, 0x00000008ff587819ULL, 0x000fe20000011658ULL,
0x000000401430723cULL, 0x000fe20000041830ULL, 0x00000010ff377819ULL, 0x000fe2000001165fULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000010ff687819ULL, 0x000fe40000011668ULL, 0x00000010ff347819ULL, 0x000fc40000011659ULL,
0x00000010ff357819ULL, 0x000fe40000011660ULL, 0x00000010ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000066ff5d7230ULL, 0x000fe20000004100ULL, 0x0000105467367816ULL, 0x000fe20000000036ULL,
0x20000063ff5b7230ULL, 0x000fe20000004100ULL, 0x0000105468377816ULL, 0x000fe20000000037ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x0000105435347816ULL, 0x000fc40000000034ULL,
0x0000105461357816ULL, 0x000fe4000000005aULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff547819ULL, 0x000fe40000011654ULL,
0x00000010ff407819ULL, 0x000fe4000001165cULL, 0x00000010ff417819ULL, 0x000fe20000011662ULL,
0x000000341424723cULL, 0x000fe20000041824ULL, 0x000010544d407816ULL, 0x000fc40000000040ULL,
0x0000105454417816ULL, 0x000fe40000000041ULL, 0x00000010ff377819ULL, 0x000fe40000011642ULL,
0x00000010ff367819ULL, 0x000fe40000011655ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x000000401420723cULL, 0x000fe20000041820ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff427819ULL, 0x000fc4000001165bULL, 0x00000010ff347819ULL, 0x000fe4000001165eULL,
0x00000010ff547819ULL, 0x000fe20000011647ULL, 0x0000000800477824ULL, 0x040fe200078e00ffULL,
0x00000010ff357819ULL, 0x000fe20000011658ULL, 0x0000000100407824ULL, 0x000fe200078e0251ULL,
0x000010545d367816ULL, 0x000fe40000000036ULL, 0x0000105442377816ULL, 0x000fe40000000037ULL,
0x0000105443347816ULL, 0x000fc40000000034ULL, 0x0000105454357816ULL, 0x000fe40000000035ULL,
0xfffffff847477812ULL, 0x000fe200078ee240ULL, 0x00000036141c723cULL, 0x000fec000004181cULL,
0x000000341410723cULL, 0x000fe20000041810ULL, 0x011800004c14783bULL, 0x0002ec0000000200ULL,
0x0000001047347824ULL, 0x000fe200078e0248ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x080fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x0000000800427824ULL, 0x000fe200078e00ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x00000002404d7836ULL, 0x000fe20000000000ULL,
0xfffffff853537812ULL, 0x000fc800078ec0ffULL, 0xfffffff8424d7812ULL, 0x000fca00078ee24dULL,
0x000000104d407824ULL, 0x000fcc00078e0248ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x00000010ff6c7819ULL, 0x110fe40000011634ULL, 0x000000ff34547812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4c7819ULL, 0x002fe40000011634ULL, 0x0000ffff346a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff365d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff35557812ULL, 0x000fc400078ec0ffULL,
0x00000018ff347819ULL, 0x100fe40000011635ULL, 0x00000018ff597819ULL, 0x000fe40000011636ULL,
0x000000ff375f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff406d7812ULL, 0x020fe400078ec0ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000010ff6b7819ULL, 0x000fc40000011635ULL,
0x00000010ff627819ULL, 0x000fe40000011636ULL, 0x0000ffff36617812ULL, 0x000fe400078ec0ffULL,
0x00000055ff68723eULL, 0x000fe400020006ffULL, 0x00000034ff64723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe200020006ffULL, 0x20000068ff687230ULL, 0x000fe20000004100ULL,
0x0000ffff35657812ULL, 0x000fe200078ec0ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000004cff63723eULL, 0x000fc400020006ffULL, 0x00000010ff367819ULL, 0x100fe40000011640ULL,
0x00000018ff557819ULL, 0x000fe20000011640ULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x0000ffff40347812ULL, 0x000fe400078ec0ffULL, 0x0000006dff6d723eULL, 0x000fe400020006ffULL,
0x00000010ff5b7819ULL, 0x000fe40000011642ULL, 0x000000ff425a7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff424c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff677819ULL, 0x100fe40000011637ULL, 0x00000018ff5e7819ULL, 0x000fe40000011637ULL,
0x0000ffff37667812ULL, 0x000fe400078ec0ffULL, 0x000000ff43427812ULL, 0x000fc400078ec0ffULL,
0x0000005fff60723eULL, 0x000fe200020006ffULL, 0x2000005dff5f7230ULL, 0x000fe20000004100ULL,
0x000000ff6c6c7812ULL, 0x000fe200078ec0ffULL, 0x20000059ff5d7230ULL, 0x000fe20000004100ULL,
0x00000054ff69723eULL, 0x000fe200020006ffULL, 0x2000006dff597230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x100fe20000011641ULL, 0x20000060ff607230ULL, 0x000fe20000004100ULL,
0x000000ff416e7812ULL, 0x000fe200078ec0ffULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff587819ULL, 0x000fc40000011641ULL, 0x0000ffff41357812ULL, 0x000fe400078ec0ffULL,
0x000000ff6b6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x100fe40000011643ULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000ffff43547812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fc4000001166aULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x0000005aff43723eULL, 0x000fe400020006ffULL, 0x000000ff62627812ULL, 0x000fe400078ec0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x00000042ff6d723eULL, 0x000fe200020006ffULL,
0x20000043ff427230ULL, 0x000fe20000004100ULL, 0x0000006cff6c723eULL, 0x000fc400020006ffULL,
0x0000006eff6e723eULL, 0x000fe200020006ffULL, 0x2000006dff437230ULL, 0x000fe20000004100ULL,
0x0000006bff6b723eULL, 0x000fe200020006ffULL, 0x2000006cff6c7230ULL, 0x000fe20000004100ULL,
0x0000006aff6a723eULL, 0x000fe200020006ffULL, 0x2000006eff5a7230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006bff6d7230ULL, 0x000fe20000004100ULL,
0x00000062ff62723eULL, 0x000fe200020006ffULL, 0x2000006aff6b7230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x20000065ff6e7230ULL, 0x000fe20000004100ULL,
0x000000ff36367812ULL, 0x000fe200078ec0ffULL, 0x20000062ff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff37377812ULL, 0x000fe200078ec0ffULL, 0x20000061ff657230ULL, 0x000fe20000004100ULL,
0x00000036ff62723eULL, 0x000fc400020006ffULL, 0x00000037ff61723eULL, 0x000fe400020006ffULL,
0x000000ff67677812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011669ULL, 0x20000061ff617230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe4000001166cULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff6d7819ULL, 0x000fc4000001166dULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x000010546d377816ULL, 0x000fe20000000068ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000008ff687819ULL, 0x000fe40000011634ULL,
0x00000008ff697819ULL, 0x000fe40000011635ULL, 0x00000010ff637819ULL, 0x000fe20000011663ULL,
0x000000361418723cULL, 0x008fe20000041818ULL, 0x00000010ff647819ULL, 0x000fc40000011664ULL,
0x00000010ff347819ULL, 0x000fe4000001166bULL, 0x00000010ff357819ULL, 0x000fe4000001166eULL,
0x00000008ff667819ULL, 0x000fe40000011666ULL, 0x0000105463347816ULL, 0x000fe40000000034ULL,
0x0000105464357816ULL, 0x000fe40000000035ULL, 0x00000010ff367819ULL, 0x000fc4000001165fULL,
0x00000010ff377819ULL, 0x000fe4000001166aULL, 0x0000005eff5e723eULL, 0x000fe200020006ffULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000066ff66723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe20000011660ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x000fe20000011667ULL, 0x20000066ff667230ULL, 0x000fe20000004100ULL,
0x0000105437367816ULL, 0x000fc40000000036ULL, 0x0000105464377816ULL, 0x000fe40000000063ULL,
0x00000010ff5d7819ULL, 0x000fe4000001165dULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff347819ULL, 0x000fe20000011665ULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff357819ULL, 0x000fe40000011666ULL, 0x000000ff5b5b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011659ULL,
0x20000068ff5f7230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011662ULL,
0x20000069ff607230ULL, 0x000fe20000004100ULL, 0x00000010ff5a7819ULL, 0x000fc4000001165aULL,
0x00000010ff617819ULL, 0x000fe40000011661ULL, 0x000010545d347816ULL, 0x000fe40000000034ULL,
0x000010545e357816ULL, 0x000fe40000000035ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000105461377816ULL, 0x000fe2000000005aULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff4c7819ULL, 0x000fe2000001164cULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000008ff547819ULL, 0x000fc40000011654ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x000000361424723cULL, 0x000fe20000041824ULL, 0x00000010ff347819ULL, 0x000fe4000001165fULL,
0x00000010ff357819ULL, 0x000fe40000011660ULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x0000004cff4c723eULL, 0x000fc400020006ffULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x00000054ff54723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe20000011642ULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x00000010ff377819ULL, 0x000fe20000011643ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000010ff5c7819ULL, 0x000fc4000001165cULL, 0x0000105455347816ULL, 0x000fe40000000034ULL,
0x0000105458357816ULL, 0x000fe40000000035ULL, 0x000010545b367816ULL, 0x000fe40000000036ULL,
0x000010545c377816ULL, 0x000fe40000000037ULL, 0x00000010ff417819ULL, 0x000fe20000011641ULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x00000010ff547819ULL, 0x000fca0000011654ULL,
0x00000036141c723cULL, 0x000fe2000004181cULL, 0x00000010ff357819ULL, 0x000fe20000011640ULL,
0x00000001ff407424ULL, 0x000fe200078e00ffULL, 0x00000010ff347819ULL, 0x000fc8000001164cULL,
0x000000080b367c11ULL, 0x000fe4000f8e18ffULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x0000105441357816ULL, 0x000fe40000000054ULL, 0x0176c840363679a7ULL, 0x0002ea000850003fULL,
0x000000341410723cULL, 0x000fe20000041810ULL, 0x0176904053ff79a7ULL, 0x0003de0008500008ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000037060075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x00000037060075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000c044167836ULL, 0x000fe20000000000ULL,
0x0000940000057ab9ULL, 0x000fc60000000800ULL, 0x0000000509177c24ULL, 0x000fe2000f8e0216ULL,
0x0000000000f89947ULL, 0x000fec0003800000ULL, 0x000000163b147248ULL, 0x000fe20007fe0000ULL,
0x0000001038357824ULL, 0x000fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe2000001160dULL,
0x00009000000a7ab9ULL, 0x000fe40000000a00ULL, 0x0000000114147824ULL, 0x000fe400078e0a16ULL,
0x0000000135167824ULL, 0x000fe400078e0215ULL, 0x0000000415367836ULL, 0x000fe20000000000ULL,
0x0000001435147248ULL, 0x000fe20007fe0000ULL, 0x0000000116347824ULL, 0x000fc400078e020dULL,
0x0000000816417824ULL, 0x000fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe400078e0a35ULL,
0x0000000c15377836ULL, 0x000fe20000000000ULL, 0xfffffff841417812ULL, 0x000fe200078ee234ULL,
0x0000000815347836ULL, 0x000fe20000000000ULL, 0x000000143600720cULL, 0x080fe20003f66070ULL,
0x0000000135367824ULL, 0x000fe200078e0236ULL, 0x000000141500720cULL, 0x080fe20003f86070ULL,
0x0000000116157824ULL, 0x000fe200078e0217ULL, 0x000000143400720cULL, 0x080fe20003f46070ULL,
0x0000000136167824ULL, 0x040fe200078e020dULL, 0x000000143700720cULL, 0x000fe20003f06070ULL,
0x0000000836437824ULL, 0x000fc400078e00ffULL, 0x0000008015147825ULL, 0x000fc600078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee216ULL, 0x0000000135347824ULL, 0x040fe200078e0234ULL,
0x0000003e14147212ULL, 0x000fe200078efcffULL, 0x0000000136367824ULL, 0x000fe400078e0217ULL,
0x0000000135407824ULL, 0x002fe200078e0237ULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x0000000134357824ULL, 0x040fe400078e020dULL, 0x0000000834427824ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe2000affe4ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff842537812ULL, 0x000fe200078ee235ULL, 0x0000000134167824ULL, 0x100fe200078e0217ULL,
0x0000003e36367212ULL, 0x000fe200078efcffULL, 0x0000000140347824ULL, 0x000fe400078e0217ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000000a36367c10ULL, 0x000fc6000ffbe0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003e16167212ULL, 0x080fe400078efcffULL,
0x0000000b37377c10ULL, 0x000fe2000affe4ffULL, 0x0000000140427824ULL, 0x000fe200078e020dULL,
0x0000003e34347212ULL, 0x000fe200078efcffULL, 0x0000000840557824ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL, 0x0000001041417824ULL, 0x100fe200078e0248ULL,
0x0000000a34347c10ULL, 0x000fe2000ffde0ffULL, 0x0000001043437824ULL, 0x100fe200078e0248ULL,
0xfffffff855557812ULL, 0x000fe200078ee242ULL, 0x0000001053537824ULL, 0x100fe200078e0248ULL,
0x0000000b17177c10ULL, 0x000fe2000affe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014417faeULL, 0x0003e2000e101c46ULL, 0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001055557824ULL, 0x000fc400078e0248ULL, 0x0000000036437faeULL, 0x0003e8000d901c46ULL,
0x0000000016537faeULL, 0x0003e8000d101c46ULL, 0x0000000034557faeULL, 0x0003e2000c101c46ULL,
0x0000000000c47947ULL, 0x000fea0003800000ULL, 0x0000001038147824ULL, 0x000fe200078e00ffULL,
0x00009000000a7ab9ULL, 0x000fc80000000a00ULL, 0x000000140d167211ULL, 0x000fca00078fe8ffULL,
0x0000000116157824ULL, 0x040fe400078e020dULL, 0x0000000816367824ULL, 0x040fe400078e00ffULL,
0x0000000416347836ULL, 0x000fe40000000000ULL, 0x0000000816407836ULL, 0x002fe20000000000ULL,
0xfffffff836417812ULL, 0x000fe200078ee215ULL, 0x0000000c16427836ULL, 0x000fe40000000000ULL,
0x0000000116147824ULL, 0x000fc400078e0217ULL, 0x0000000134167824ULL, 0x040fe400078e0217ULL,
0x0000000134357824ULL, 0x040fe400078e020dULL, 0x00000008344c7824ULL, 0x000fe400078e00ffULL,
0x0000000140347824ULL, 0x100fe400078e0217ULL, 0x0000000142367824ULL, 0x000fe200078e0217ULL,
0xfffffff84c437812ULL, 0x000fe200078ee235ULL, 0x0000000140177824ULL, 0x000fc400078e020dULL,
0x0000000840407824ULL, 0x000fe400078e00ffULL, 0x0000000142377824ULL, 0x040fe400078e020dULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0xfffffff840537812ULL, 0x000fe200078ee217ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff842557812ULL, 0x000fe200078ee237ULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000003e14147212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003e16167212ULL, 0x080fe400078efcffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003e34347212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001041417824ULL, 0x100fe200078e0248ULL, 0x0000003e36367212ULL, 0x000fe200078efcffULL,
0x0000001043437824ULL, 0x100fe200078e0248ULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x0000001053537824ULL, 0x100fe200078e0248ULL, 0x0000000a34347c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001055557824ULL, 0x000fe200078e0248ULL, 0x0000000a36367c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014417faeULL, 0x0003e2000b901c46ULL,
0x0000000b17177c10ULL, 0x000fc400097fe4ffULL, 0x0000000b35357c10ULL, 0x000fe400087fe4ffULL,
0x0000000b37377c10ULL, 0x000fe20009ffe4ffULL, 0x0000000016437faeULL, 0x0003e8000b901c46ULL,
0x0000000034537faeULL, 0x0003e8000b901c46ULL, 0x0000000036557faeULL, 0x0003e4000b901c46ULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000008ff157e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff00c547812ULL, 0x000fe200078ec0ffULL,
0x00000001ff167424ULL, 0x000fc600078e00ffULL, 0x000176a854547810ULL, 0x000fe40007ffe015ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x00000816545479a7ULL, 0x0002e4000850003fULL, 0x017648164b1679a7ULL, 0x0022a4000850003fULL,
0x0000000000147805ULL, 0x000fce0000015200ULL, 0xffffffe00c347812ULL, 0x040fe400078ec0ffULL,
0x000000100c357812ULL, 0x040fe400078ec0ffULL, 0x000000080c367812ULL, 0x000fe400078ec0ffULL,
0x0000000835357c10ULL, 0x000fca000fffe034ULL, 0x0000000135417824ULL, 0x000fc800078e0236ULL,
0x01764817410075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x0000003414377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01764817410075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000203d147824ULL, 0x000fe400078e00ffULL,
0x00000008ff157e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010015147810ULL, 0x000fc80007ffe014ULL,
0x0000001445147210ULL, 0x000fca0007ffe03eULL, 0x0170000014157984ULL, 0x000ea80000000800ULL,
0x0172000014177984ULL, 0x0009220000000800ULL, 0x000000521500720bULL, 0x004fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16357812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x01afea0003800000ULL, 0x0000000208147836ULL, 0x000fe20000000000ULL,
0x000000521500720bULL, 0x000fc80003f14000ULL, 0x0000003d1400720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x000000083d16ac11ULL, 0x000fe4000f8e38ffULL,
0x000000521514a209ULL, 0x000fe40007810000ULL, 0x000000164537a210ULL, 0x000fe40007ffe03eULL,
0x0000991034167816ULL, 0x000fc600000000ffULL, 0x017400143700a388ULL, 0x0003e20000000800ULL,
0x000000ff1600720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005215377209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x0000005237147221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400377308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1437147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000003750507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1437147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe20007806034ULL,
0x00000001ff347424ULL, 0x000fe200078e00ffULL, 0x0000005215527209ULL, 0x000fd60007810000ULL,
0x8000005215150221ULL, 0x000fe20000010000ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x0000001500050308ULL, 0x000ea40000000800ULL,
0x0000000517170220ULL, 0x004fce0000410000ULL, 0x0000005017507221ULL, 0x000fe20000010000ULL,
0x0000000000147805ULL, 0x002fe40000015200ULL, 0xfffffff00c177812ULL, 0x000fc800078ec0ffULL,
0x0176a857170075a7ULL, 0x000ea20008000148ULL, 0x0000000817377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614357210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003516167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176a857370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000080d147812ULL, 0x000fe400078ec0ffULL, 0x0000991034347816ULL, 0x000fe400000000ffULL,
0x0000000714167812ULL, 0x000fc600078ef80dULL, 0x000000ffff147224ULL, 0x000fe400078e0034ULL,
0x0000000116517824ULL, 0x040fe400078e0251ULL, 0x0000000816167824ULL, 0x000fe200078e00ffULL,
0x000000ff1400720cULL, 0x000fc80003f05270ULL, 0xfffffff816517812ULL, 0x000fca00078ee251ULL,
0x0000001051347824ULL, 0x000fc800078e023cULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000005ff02723eULL, 0x000fc600000010ffULL,
0x0000000803157836ULL, 0x000fe20000000000ULL, 0x0000541002147816ULL, 0x000fca0000000002ULL,
0x00001f0314037589ULL, 0x0002a800000e0000ULL, 0x00001f1514027589ULL, 0x0002e400000e0000ULL,
0x012000004e14783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000314147232ULL, 0x08cfe40000200000ULL, 0x0000000316167232ULL, 0x000fe40000200000ULL,
0x0000000215157232ULL, 0x080fe40000200000ULL, 0x0000000217177232ULL, 0x000fce0000200000ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000104f407824ULL, 0x000fcc00078e023cULL,
0x000000004040783bULL, 0x000f620000004200ULL, 0x00000018ff4f7819ULL, 0x010fe40000011635ULL,
0x000000ff344e7812ULL, 0x002fe400078ec0ffULL, 0x000000ff35517812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x000000ff40697812ULL, 0x020fe400078ec0ffULL,
0x000000ff42677812ULL, 0x000fe200078ec0ffULL, 0x2000004fff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff637819ULL, 0x000fc40000011637ULL, 0x000000ff375a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe40000011637ULL, 0x0000ffff375b7812ULL, 0x000fe400078ec0ffULL,
0x0000004eff5f723eULL, 0x000fe400020006ffULL, 0x000000ff43687812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x000fe20000011634ULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000051ff37723eULL, 0x000fc400020006ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011642ULL,
0x00000010ff627819ULL, 0x100fe20000011636ULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x000000ff36577812ULL, 0x040fe400078ec0ffULL, 0x00000018ff537819ULL, 0x000fe40000011636ULL,
0x0000ffff36597812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5c7819ULL, 0x000fc40000011640ULL,
0x00000018ff517819ULL, 0x000fe40000011640ULL, 0x0000ffff40617812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011634ULL, 0x0000ffff34647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff367819ULL, 0x000fe40000011642ULL, 0x0000ffff42407812ULL, 0x000fc400078ec0ffULL,
0x00000069ff4f723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011641ULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff347819ULL, 0x100fe40000011643ULL, 0x00000018ff427819ULL, 0x000fe40000011643ULL,
0x0000ffff43567812ULL, 0x000fc400078ec0ffULL, 0x00000068ff69723eULL, 0x000fe400020006ffULL,
0x0000004eff68723eULL, 0x000fe400020006ffULL, 0x000000ff4c437812ULL, 0x000fe200078ec0ffULL,
0x20000067ff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe20000011635ULL,
0x20000069ff4e7230ULL, 0x000fe20000004100ULL, 0x0000ffff35657812ULL, 0x000fe400078ec0ffULL,
0x0000004bff35723eULL, 0x000fc400020006ffULL, 0x0000006aff4b723eULL, 0x000fe400020006ffULL,
0x00000042ff6a723eULL, 0x000fe200020006ffULL, 0x20000068ff427230ULL, 0x000fe20000004100ULL,
0x00000043ff67723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x000000ff66687812ULL, 0x000fe200078ec0ffULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x2000006aff437230ULL, 0x000fe20000004100ULL,
0x000000ff63637812ULL, 0x000fc400078ec0ffULL, 0x00000008ff667819ULL, 0x000fe20000011664ULL,
0x20000067ff647230ULL, 0x000fe20000004100ULL, 0x00000068ff67723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x00000063ff68723eULL, 0x000fe200020006ffULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff607819ULL, 0x000fe20000011641ULL,
0x20000062ff637230ULL, 0x000fe20000004100ULL, 0x00000008ff597819ULL, 0x000fe20000011659ULL,
0x20000068ff627230ULL, 0x000fe20000004100ULL, 0x00000008ff5b7819ULL, 0x000fc4000001165bULL,
0x000000ff60687812ULL, 0x000fe400078ec0ffULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005bff5b723eULL, 0x000fe400020006ffULL, 0x00000008ff617819ULL, 0x000fe20000011661ULL,
0x20000059ff607230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000061ff59723eULL, 0x000fe200020006ffULL, 0x2000005bff617230ULL, 0x000fe20000004100ULL,
0x00000008ff697819ULL, 0x000fe20000011665ULL, 0x20000068ff5b7230ULL, 0x000fe20000004100ULL,
0x000000ff36687812ULL, 0x000fc400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe4000001165fULL,
0x00000010ff5f7819ULL, 0x000fe40000011637ULL, 0x00000010ff377819ULL, 0x000fe40000011664ULL,
0x00000066ff65723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x000fe40000011667ULL,
0x00000069ff66723eULL, 0x000fe200020006ffULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x000000ff416b7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff415d7812ULL, 0x000fe200078ec0ffULL,
0x20000066ff667230ULL, 0x000fe20000004100ULL, 0x00000057ff41723eULL, 0x000fe400020006ffULL,
0x0000105437367816ULL, 0x000fe40000000036ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000105464377816ULL, 0x000fe4000000005fULL,
0x000000ff34647812ULL, 0x000fe200078ec0ffULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff347819ULL, 0x000fe20000011665ULL,
0x000000361418723cULL, 0x008fe20000041818ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000010ff5f7819ULL, 0x000fe2000001165eULL,
0x20000053ff577230ULL, 0x000fe20000004100ULL, 0x00000010ff667819ULL, 0x000fe20000011666ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff367819ULL, 0x000fe40000011640ULL, 0x00000010ff407819ULL, 0x000fe40000011641ULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x00000010ff417819ULL, 0x000fe4000001165aULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff627819ULL, 0x000fc40000011662ULL,
0x000010545f357816ULL, 0x000fe40000000066ULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x0000105463407816ULL, 0x000fe20000000040ULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x0000105462417816ULL, 0x000fe40000000041ULL,
0x00000008ff697819ULL, 0x000fe2000001165dULL, 0x2000005cff5d7230ULL, 0x000fe20000004100ULL,
0x00000051ff53723eULL, 0x000fe200020006ffULL, 0x2000006bff517230ULL, 0x000fe20000004100ULL,
0x00000036ff5f723eULL, 0x000fe200020006ffULL, 0x20000059ff5c7230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe20000011657ULL, 0x00000040142c723cULL, 0x000fe2000004182cULL,
0x00000010ff587819ULL, 0x000fe20000011658ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc40000011660ULL, 0x00000010ff377819ULL, 0x000fe40000011661ULL,
0x00000069ff59723eULL, 0x000fe400020006ffULL, 0x00000008ff347819ULL, 0x000fe20000011656ULL,
0x2000005fff567230ULL, 0x000fe20000004100ULL, 0x00000068ff68723eULL, 0x000fe200020006ffULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x0000105457367816ULL, 0x000fe20000000036ULL, 0x20000068ff5e7230ULL, 0x000fe20000004100ULL,
0x0000105458377816ULL, 0x000fe20000000037ULL, 0x20000064ff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fc40000011651ULL, 0x00000010ff587819ULL, 0x000fe4000001165bULL,
0x00000034ff35723eULL, 0x000fe200020006ffULL, 0x000000361430723cULL, 0x000fe20000041830ULL,
0x0000105458417816ULL, 0x000fe40000000041ULL, 0x00000010ff407819ULL, 0x000fe2000001164fULL,
0x20000035ff4f7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x000000070d587812ULL, 0x000fc400078ec0ffULL, 0x00000010ff367819ULL, 0x000fe4000001164bULL,
0x00000010ff357819ULL, 0x000fe40000011659ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff377819ULL, 0x000fe4000001165eULL, 0x000010545d407816ULL, 0x000fe40000000040ULL,
0x00000010ff4e7819ULL, 0x000fc4000001164eULL, 0x00000010ff4b7819ULL, 0x000fe4000001165aULL,
0x0000000858587812ULL, 0x000fe200078ef80dULL, 0x000000401424723cULL, 0x000fe20000041824ULL,
0x0000105436357816ULL, 0x000fe40000000035ULL, 0x0000105437367816ULL, 0x000fe2000000004cULL,
0x0000000858587824ULL, 0x000fe200078e00ffULL, 0x000010544b377816ULL, 0x000fe2000000004eULL,
0x000000024a4b7836ULL, 0x000fe20000000000ULL, 0x00000010ff537819ULL, 0x000fc40000011653ULL,
0x00000010ff347819ULL, 0x000fe4000001165cULL, 0x00000010ff417819ULL, 0x000fe20000011642ULL,
0x00000036141c723cULL, 0x000fe2000004181cULL, 0x00000010ff407819ULL, 0x000fe40000011643ULL,
0x00000010ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164fULL,
0xfffffff8584b7812ULL, 0x000fc400078ee24bULL, 0x0000105453347816ULL, 0x000fe40000000034ULL,
0x0000105441567816ULL, 0x000fe20000000056ULL, 0x000000104b467824ULL, 0x000fe200078e0246ULL,
0x0000105440577816ULL, 0x000fc6000000004fULL, 0x000000341420723cULL, 0x000fec0000041820ULL,
0x000000561410723cULL, 0x000fe20000041810ULL, 0x0000001047347824ULL, 0x000fe200078e023cULL,
0x012000004614783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000314147232ULL, 0x08cfe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x080fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x000000104d407824ULL, 0x000fcc00078e023cULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x00000010ff667819ULL, 0x010fe40000011634ULL, 0x00000010ff657819ULL, 0x100fe40000011635ULL,
0x0000ffff34647812ULL, 0x040fe400078ec0ffULL, 0x000000ff344c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011635ULL, 0x00000010ff5d7819ULL, 0x000fc40000011636ULL,
0x000000ff36517812ULL, 0x000fe400078ec0ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011636ULL,
0x00000010ff5f7819ULL, 0x100fe40000011637ULL, 0x000000ff37587812ULL, 0x000fe400078ec0ffULL,
0x00000018ff577819ULL, 0x000fe40000011637ULL, 0x000000ff354e7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff36367812ULL, 0x000fe400078ec0ffULL, 0x0000ffff37377812ULL, 0x000fe400078ec0ffULL,
0x000000ff66667812ULL, 0x000fe400078ec0ffULL, 0x000000ff65657812ULL, 0x000fe400078ec0ffULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x0000004cff4c723eULL, 0x000fc400020006ffULL,
0x0000004dff4d723eULL, 0x000fe400020006ffULL, 0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL,
0x2000004cff637230ULL, 0x000fe20000004100ULL, 0x000000ff5f5f7812ULL, 0x000fe200078ec0ffULL,
0x2000004dff5b7230ULL, 0x000fe20000004100ULL, 0x0000ffff355e7812ULL, 0x000fe400078ec0ffULL,
0x0000004eff62723eULL, 0x000fe400020006ffULL, 0x00000018ff677819ULL, 0x022fc40000011640ULL,
0x00000018ff687819ULL, 0x000fe20000011641ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000008ff367819ULL, 0x000fe40000011636ULL, 0x00000008ff377819ULL, 0x000fe40000011637ULL,
0x00000064ff64723eULL, 0x000fc400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000018ff467819ULL, 0x000fe40000011634ULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x00000010ff607819ULL, 0x000fe40000011640ULL, 0x00000067ff4d723eULL, 0x000fe200020006ffULL,
0x20000066ff677230ULL, 0x000fe20000004100ULL, 0x00000068ff4c723eULL, 0x000fe200020006ffULL,
0x20000065ff687230ULL, 0x000fe20000004100ULL, 0x00000008ff5e7819ULL, 0x000fe2000001165eULL,
0x20000064ff667230ULL, 0x000fe20000004100ULL, 0x00000036ff36723eULL, 0x000fe200020006ffULL,
0x2000005dff647230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fe200020006ffULL,
0x2000005fff657230ULL, 0x000fe20000004100ULL, 0x000000ff40597812ULL, 0x000fe200078ec0ffULL,
0x20000036ff5f7230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x00000046ff5c723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff617819ULL, 0x000fc40000011641ULL,
0x000000ff41697812ULL, 0x040fe200078ec0ffULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000ffff41357812ULL, 0x000fe400078ec0ffULL, 0x0000005eff5e723eULL, 0x000fe400020006ffULL,
0x000000ff605d7812ULL, 0x000fe200078ec0ffULL, 0x20000037ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fe40000011643ULL, 0x000000ff436b7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff417819ULL, 0x000fe40000011643ULL, 0x0000ffff434e7812ULL, 0x000fe400078ec0ffULL,
0x00000059ff43723eULL, 0x000fe200020006ffULL, 0x20000051ff597230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe40000011663ULL, 0x00000010ff377819ULL, 0x000fe40000011662ULL,
0x00000010ff677819ULL, 0x000fc40000011667ULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x000000ff61617812ULL, 0x000fe400078ec0ffULL, 0x0000ffff40347812ULL, 0x000fe400078ec0ffULL,
0x00000069ff51723eULL, 0x000fe200020006ffULL, 0x2000005eff697230ULL, 0x000fe20000004100ULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x0000105467367816ULL, 0x000fe20000000036ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x0000105468377816ULL, 0x000fe20000000037ULL,
0x20000058ff5a7230ULL, 0x000fe20000004100ULL, 0x00000061ff5e723eULL, 0x000fc400020006ffULL,
0x00000008ff617819ULL, 0x000fe40000011634ULL, 0x00000008ff627819ULL, 0x000fe20000011635ULL,
0x000000361418723cULL, 0x008fe20000041818ULL, 0x00000010ff357819ULL, 0x000fe2000001165cULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fe40000011666ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165bULL, 0x00000010ff697819ULL, 0x000fc40000011669ULL,
0x00000010ff537819ULL, 0x100fe40000011642ULL, 0x000000ff426a7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011642ULL, 0x0000ffff42467812ULL, 0x000fe400078ec0ffULL,
0x0000004fff4f723eULL, 0x000fe400020006ffULL, 0x00000057ff42723eULL, 0x000fc400020006ffULL,
0x0000105435347816ULL, 0x000fe20000000034ULL, 0x2000004fff577230ULL, 0x000fe20000004100ULL,
0x000010545c357816ULL, 0x000fe20000000069ULL, 0x20000042ff587230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011659ULL, 0x20000043ff4f7230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fe40000011664ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165aULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff5c7819ULL, 0x000fc40000011665ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010545c377816ULL, 0x000fe2000000005bULL, 0x2000005dff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff347819ULL, 0x000fe2000001165fULL, 0x00000036142c723cULL, 0x000fe2000004182cULL,
0x00000010ff357819ULL, 0x000fc40000011660ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x000000ff53537812ULL, 0x000fe200078ec0ffULL,
0x20000061ff597230ULL, 0x000fe20000004100ULL, 0x000000ff56567812ULL, 0x000fe200078ec0ffULL,
0x20000062ff5a7230ULL, 0x000fe20000004100ULL, 0x0000105457347816ULL, 0x000fe40000000034ULL,
0x0000105458357816ULL, 0x000fc40000000035ULL, 0x00000010ff367819ULL, 0x000fe4000001164fULL,
0x00000010ff377819ULL, 0x000fe40000011651ULL, 0x00000010ff5d7819ULL, 0x000fe2000001165dULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x0000006aff42723eULL, 0x000fe400020006ffULL, 0x0000006bff43723eULL, 0x000fc400020006ffULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000010545d367816ULL, 0x000fe20000000036ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x000010545e377816ULL, 0x000fe20000000037ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000008ff4e7819ULL, 0x000fc4000001164eULL,
0x00000010ff4d7819ULL, 0x000fe2000001164dULL, 0x000000361424723cULL, 0x000fe20000041824ULL,
0x00000010ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff347819ULL, 0x000fe40000011659ULL,
0x00000010ff357819ULL, 0x000fe4000001165aULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x00000040ff40723eULL, 0x000fc400020006ffULL, 0x00000046ff46723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x000010544d347816ULL, 0x000fe20000000034ULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x000010544c357816ULL, 0x000fe20000000035ULL,
0x2000004eff4e7230ULL, 0x000fe20000004100ULL, 0x00000010ff367819ULL, 0x000fe40000011642ULL,
0x00000010ff377819ULL, 0x000fc40000011643ULL, 0x00000010ff537819ULL, 0x000fe20000011653ULL,
0x000000341420723cULL, 0x000fe20000041820ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x0000105453367816ULL, 0x000fe40000000036ULL, 0x0000105456377816ULL, 0x000fe40000000037ULL,
0x00000010ff347819ULL, 0x000fe40000011641ULL, 0x00000010ff357819ULL, 0x000fc40000011640ULL,
0x00000010ff467819ULL, 0x000fe20000011646ULL, 0x00000036141c723cULL, 0x000fe2000004181cULL,
0x00000010ff417819ULL, 0x000fe4000001164eULL, 0x0000105435407816ULL, 0x000fe40000000046ULL,
0x0000105434417816ULL, 0x000fe40000000041ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000000808367c11ULL, 0x000fc6000f8e18ffULL, 0x00000037063479a7ULL, 0x0002e2000850003fULL,
0x000000401410723cULL, 0x000fe20000041810ULL, 0x0176983736ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614377210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003716167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000107147836ULL, 0x000fca0000000000ULL,
0x000000391400720cULL, 0x000fda0003f06070ULL, 0x0000000400d40947ULL, 0x000fea0003800000ULL,
0x0000000207147836ULL, 0x000fe20000000000ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x0000010044447836ULL, 0x000fc60000000000ULL, 0x000000391400720cULL, 0x000fe20003f06070ULL,
0x0000000509377c24ULL, 0x002fd8000f8e0244ULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x000000443b147248ULL, 0x000fe20007fe0000ULL, 0x0000001038157824ULL, 0x000fe200078e00ffULL,
0x00000003ff167819ULL, 0x100fe2000001160dULL, 0x00009000000a7ab9ULL, 0x000fe40000000a00ULL,
0x0000000114147824ULL, 0x000fe400078e0a44ULL, 0x0000000115347824ULL, 0x000fe400078e0216ULL,
0x0000000416357836ULL, 0x000fe20000000000ULL, 0x0000001415147248ULL, 0x000fe20007fe0000ULL,
0x0000000134177824ULL, 0x000fc400078e020dULL, 0x0000000834367824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fc600078e0a15ULL, 0xfffffff836417812ULL, 0x000fe200078ee217ULL,
0x0000000816177836ULL, 0x000fe20000000000ULL, 0x000000141600720cULL, 0x080fe20003f86070ULL,
0x0000000c16167836ULL, 0x000fe20000000000ULL, 0x000000143500720cULL, 0x080fe20003f66070ULL,
0x0000000115367824ULL, 0x000fe200078e0235ULL, 0x000000141700720cULL, 0x080fe20003f46070ULL,
0x0000000115407824ULL, 0x040fe200078e0217ULL, 0x000000141600720cULL, 0x000fe20003f06070ULL,
0x0000000115427824ULL, 0x000fe400078e0216ULL, 0x0000000136147824ULL, 0x000fc400078e020dULL,
0x0000000836437824ULL, 0x000fe400078e00ffULL, 0x0000000134167824ULL, 0x100fe400078e0237ULL,
0x0000000136347824ULL, 0x000fe200078e0237ULL, 0xfffffff843437812ULL, 0x000fe200078ee214ULL,
0x0000000140157824ULL, 0x040fe400078e020dULL, 0x0000000840447824ULL, 0x000fe400078e00ffULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0xfffffff8444d7812ULL, 0x000fe200078ee215ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000003e16167212ULL, 0x000fc600078efcffULL,
0x0000000140147824ULL, 0x100fe200078e0237ULL, 0x0000003e34347212ULL, 0x080fe200078efcffULL,
0x0000000142367824ULL, 0x000fe200078e0237ULL, 0x0000000a16167c10ULL, 0x000fe2000ffbe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000a34347c10ULL, 0x000fe4000ffde0ffULL,
0x0000000b17177c10ULL, 0x000fe2000affe4ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000003e14147212ULL, 0x080fe400078efcffULL, 0x0000000b35357c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000142407824ULL, 0x000fe200078e020dULL, 0x0000003e36367212ULL, 0x000fe200078efcffULL,
0x00000008424f7824ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe2000ffbe0ffULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x0000000a36367c10ULL, 0x000fe2000ffde0ffULL,
0x0000001043437824ULL, 0x100fe200078e023cULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee240ULL,
0x000000104d4d7824ULL, 0x100fe200078e023cULL, 0x0000000b15157c10ULL, 0x000fe2000affe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016417faeULL, 0x0003e2000e101c46ULL,
0x0000000b37377c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104f4f7824ULL, 0x000fc400078e023cULL,
0x0000000034437faeULL, 0x0003e8000d901c46ULL, 0x00000000144d7faeULL, 0x0003e8000d101c46ULL,
0x00000000364f7faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x0000001038147824ULL, 0x000fe200078e00ffULL, 0x00009000000a7ab9ULL, 0x000fc80000000a00ULL,
0x000000140d167211ULL, 0x000fca00078fe8ffULL, 0x0000000116157824ULL, 0x040fe400078e020dULL,
0x0000000816347824ULL, 0x040fe400078e00ffULL, 0x0000000816407836ULL, 0x000fe40000000000ULL,
0x0000000c16427836ULL, 0x000fe20000000000ULL, 0xfffffff834417812ULL, 0x000fe200078ee215ULL,
0x0000000416347836ULL, 0x000fe40000000000ULL, 0x0000000116147824ULL, 0x000fc400078e0237ULL,
0x0000000134167824ULL, 0x040fe400078e0237ULL, 0x0000000134177824ULL, 0x040fe400078e020dULL,
0x0000000834447824ULL, 0x000fe400078e00ffULL, 0x0000000140367824ULL, 0x100fe400078e0237ULL,
0x0000000142347824ULL, 0x040fe200078e0237ULL, 0xfffffff844437812ULL, 0x000fe200078ee217ULL,
0x0000000142377824ULL, 0x000fc400078e020dULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000000140357824ULL, 0x000fe200078e020dULL, 0x0000003e14147212ULL, 0x080fe200078efcffULL,
0x0000000842427824ULL, 0x000fe400078e00ffULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff8424f7812ULL, 0x000fe400078ee237ULL, 0xfffffff8404d7812ULL, 0x000fe200078ee235ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000003e16167212ULL, 0x000fc400078efcffULL,
0x0000000b15157c10ULL, 0x000fe200087fe4ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000003e36367212ULL, 0x080fe400078efcffULL, 0x0000000a16167c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x0000003e34347212ULL, 0x000fe200078efcffULL,
0x0000001043437824ULL, 0x100fe200078e023cULL, 0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL,
0x000000104d4d7824ULL, 0x100fe200078e023cULL, 0x0000000a34347c10ULL, 0x000fe2000ff7e0ffULL,
0x000000104f4f7824ULL, 0x000fe200078e023cULL, 0x0000000b17177c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014417faeULL, 0x0003e2000b901c46ULL,
0x0000000b37377c10ULL, 0x000fc400097fe4ffULL, 0x0000000b35357c10ULL, 0x000fe20009ffe4ffULL,
0x0000000016437faeULL, 0x0003e8000b901c46ULL, 0x00000000364d7faeULL, 0x0003e8000b901c46ULL,
0x00000000344f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000010b147812ULL, 0x040fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x0000000808157c11ULL, 0x000fe2000f8e28ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x000000080c377812ULL, 0x000fe400078ec0ffULL, 0x000000080b4e7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001014147824ULL, 0x000fe200078e0215ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000137377824ULL, 0x000fe200078e0214ULL, 0x0176a8344e4e79a7ULL, 0x0002e6000850003fULL,
0x01766834373479a7ULL, 0x0022a6000850003fULL, 0x0000000000147805ULL, 0x000fce0000015200ULL,
0x01766835370075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614417210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000004116167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01766835370075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000000808157c11ULL, 0x000fe2000f8e38ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff4d7224ULL, 0x000fe200078e0052ULL,
0x000001803e147810ULL, 0x000fca0007ffe015ULL, 0x0000000145147824ULL, 0x000fca00078e0214ULL,
0x0170000014157984ULL, 0x000ea80000000800ULL, 0x0172000014177984ULL, 0x0009220000000800ULL,
0x000000521500720bULL, 0x004fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16167812ULL, 0x000fda000780c0ffULL, 0x0000000000f88947ULL, 0x01afea0003800000ULL,
0x0000000308147836ULL, 0x000fe20000000000ULL, 0x000000521500720bULL, 0x0c0fe40003f14000ULL,
0x00000052154d7209ULL, 0x000fe40007810000ULL, 0x0000003d1400720cULL, 0x000fd20003f45270ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000083d14ac11ULL, 0x000fc8000f8e38ffULL,
0x00000014453ea210ULL, 0x000fe40007ffe03eULL, 0x0000991035147816ULL, 0x000fc600000000ffULL,
0x0174004d3e00a388ULL, 0x0003e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x000000524d147221ULL, 0x000fe20000010100ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x0000001400377308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff147819ULL, 0x002fcc000001160dULL,
0x00001f1437147589ULL, 0x004e6400000e0000ULL, 0x0000001814187220ULL, 0x042fe20000410000ULL,
0x0000001914197220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000003014307220ULL, 0x040fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002414247220ULL, 0x040fe20000410000ULL,
0x0000002514257220ULL, 0x040fe20000410000ULL, 0x0000002014207220ULL, 0x040fe20000410000ULL,
0x0000002114217220ULL, 0x040fe20000410000ULL, 0x0000001c141c7220ULL, 0x040fe20000410000ULL,
0x0000001d141d7220ULL, 0x040fe20000410000ULL, 0x0000001014107220ULL, 0x040fe20000410000ULL,
0x0000001114117220ULL, 0x000fce0000410000ULL, 0x0000003750507220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080d147811ULL, 0x002fcc00078ff0ffULL,
0x00001f1437147589ULL, 0x000e6400000e0000ULL, 0x0000001a141a7220ULL, 0x042fe20000410000ULL,
0x0000001b141b7220ULL, 0x040fe20000410000ULL, 0x0000002a142a7220ULL, 0x040fe20000410000ULL,
0x0000002b142b7220ULL, 0x040fe20000410000ULL, 0x0000002e142e7220ULL, 0x040fe20000410000ULL,
0x0000002f142f7220ULL, 0x040fe20000410000ULL, 0x0000003214327220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000002614267220ULL, 0x040fe20000410000ULL,
0x0000002714277220ULL, 0x040fe20000410000ULL, 0x0000002214227220ULL, 0x040fe20000410000ULL,
0x0000002314237220ULL, 0x040fe20000410000ULL, 0x0000001e141e7220ULL, 0x040fe20000410000ULL,
0x0000001f141f7220ULL, 0x040fe20000410000ULL, 0x0000001214127220ULL, 0x040fe20000410000ULL,
0x0000001314137220ULL, 0x000fce0000410000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007806035ULL,
0x00000001ff347424ULL, 0x000fd800078e00ffULL, 0x000000154d150221ULL, 0x000fe20000010100ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL,
0x0000001500050308ULL, 0x000ea40000000800ULL, 0x0000000517170220ULL, 0x004fce0000410000ULL,
0x0000005017507221ULL, 0x000fe20000010000ULL, 0x0000000000147805ULL, 0x002fe40000015200ULL,
0xfffffff00c177812ULL, 0x000fe200078ec0ffULL, 0x000000043d167824ULL, 0x000fc600078e00ffULL,
0x0176b055170075a7ULL, 0x000ea20008000148ULL, 0x0000000817417c36ULL, 0x000fe20008000000ULL,
0x0000000416167812ULL, 0x000fc800078ec0ffULL, 0x0000000216357812ULL, 0x000fe200078efcffULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614377210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff167819ULL, 0x000fc80000011417ULL,
0x0000003716167211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000216167819ULL, 0x000fc80000001217ULL, 0x000000160000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176b055410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000070d3e7812ULL, 0x000fe400078ec0ffULL, 0x0000991034147816ULL, 0x000fe400000000ffULL,
0x000000083e157812ULL, 0x000fe400078ef80dULL, 0x000000ff1400720cULL, 0x000fe40003f05270ULL,
0x0000000808147c11ULL, 0x000fe2000f8e58ffULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x000000350d457211ULL, 0x000fc400078fe0ffULL, 0x000000080d3c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff815157812ULL, 0x000fca00078ee24aULL, 0x0000001015147824ULL, 0x000fe200078e0214ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff167819ULL, 0x000fe4000001160dULL,
0x00000005ff02723eULL, 0x000fc600000010ffULL, 0x0000000816347836ULL, 0x000fe20000000000ULL,
0x0000541002157816ULL, 0x000fca0000000002ULL, 0x00001f1615037589ULL, 0x0002a800000e0000ULL,
0x00001f3415027589ULL, 0x0002e400000e0000ULL, 0x012800001414783bULL, 0x002e620000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000314147232ULL, 0x086fe40000200000ULL,
0x0000000316167232ULL, 0x000fe40000200000ULL, 0x0000000215157232ULL, 0x088fe40000200000ULL,
0x0000000217177232ULL, 0x000fce0000200000ULL, 0x0000003e3c3e7212ULL, 0x000fe200078efcffULL,
0x000000004934783bULL, 0x000f280000004200ULL, 0x000000013e3c7824ULL, 0x040fe400078e0245ULL,
0x000000083e417824ULL, 0x000fca00078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee23cULL,
0x00000003083c7836ULL, 0x000fc80000000000ULL, 0x0000001041417824ULL, 0x000fe200078e0248ULL,
0x000000083c3c7c11ULL, 0x000fca000f8e58ffULL, 0x000000004140783bULL, 0x000f620000004200ULL,
0x000000104b4b7824ULL, 0x000fe200078e023cULL, 0x000000ff364c7812ULL, 0x010fe400078ec0ffULL,
0x00000010ff3e7819ULL, 0x100fe40000011634ULL, 0x000000ff34467812ULL, 0x040fe400078ec0ffULL,
0x00000018ff447819ULL, 0x000fe40000011634ULL, 0x0000ffff345c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff37547812ULL, 0x000fe400078ec0ffULL, 0x000000ff35347812ULL, 0x040fe400078ec0ffULL,
0x00000018ff4e7819ULL, 0x000fe40000011637ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000ffff355d7812ULL, 0x000fe400078ec0ffULL, 0x00000034ff56723eULL, 0x000fc400020006ffULL,
0x00000010ff527819ULL, 0x128fe40000011641ULL, 0x000000ff41607812ULL, 0x040fe200078ec0ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000018ff5f7819ULL, 0x000fe40000011641ULL,
0x0000ffff41587812ULL, 0x000fe400078ec0ffULL, 0x00000054ff41723eULL, 0x000fe400020006ffULL,
0x00000010ff517819ULL, 0x000fc40000011642ULL, 0x000000ff42627812ULL, 0x040fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe40000011642ULL, 0x0000ffff42347812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5b7819ULL, 0x000fe40000011636ULL, 0x0000004eff42723eULL, 0x000fe200020006ffULL,
0x2000004cff4e7230ULL, 0x000fe20000004100ULL, 0x00000008ff5c7819ULL, 0x000fe2000001165cULL,
0x20000041ff4c7230ULL, 0x000fe20000004100ULL, 0x00000008ff5d7819ULL, 0x000fc4000001165dULL,
0x00000010ff597819ULL, 0x000fe40000011637ULL, 0x00000060ff41723eULL, 0x000fe400020006ffULL,
0x0000ffff365a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff5b607812ULL, 0x000fe200078ec0ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5b723eULL, 0x000fc400020006ffULL, 0x000000ff59597812ULL, 0x000fe200078ec0ffULL,
0x2000005cff5d7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x2000005bff5c7230ULL, 0x000fe20000004100ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x00000010ff3c7819ULL, 0x100fe40000011635ULL, 0x00000018ff487819ULL, 0x000fe40000011635ULL,
0x0000ffff37377812ULL, 0x000fc400078ec0ffULL, 0x00000044ff35723eULL, 0x000fe400020006ffULL,
0x00000010ff577819ULL, 0x100fe40000011640ULL, 0x00000018ff447819ULL, 0x000fe20000011640ULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x00000059ff5b723eULL, 0x000fe400020006ffULL,
0x0000005aff59723eULL, 0x000fe200020006ffULL, 0x20000060ff5a7230ULL, 0x000fe20000004100ULL,
0x00000018ff497819ULL, 0x000fe20000011636ULL, 0x2000005bff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fc40000011643ULL, 0x000000ff43647812ULL, 0x040fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe40000011643ULL, 0x0000ffff434a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff377819ULL, 0x000fe40000011637ULL, 0x000000ff57607812ULL, 0x000fe200078ec0ffULL,
0x20000059ff577230ULL, 0x000fe20000004100ULL, 0x000000ff405e7812ULL, 0x000fc400078ec0ffULL,
0x00000044ff43723eULL, 0x000fe400020006ffULL, 0x0000ffff40537812ULL, 0x000fe400078ec0ffULL,
0x0000005fff44723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x000000ff3c5f7812ULL, 0x000fe200078ec0ffULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000049ff40723eULL, 0x000fc400020006ffULL,
0x00000037ff37723eULL, 0x000fe400020006ffULL, 0x00000060ff59723eULL, 0x000fe200020006ffULL,
0x20000040ff407230ULL, 0x000fe20000004100ULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x0000005eff49723eULL, 0x000fe200020006ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000008ff607819ULL, 0x000fe20000011658ULL, 0x20000037ff587230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000049ff497230ULL, 0x000fe20000004100ULL,
0x0000003eff5e723eULL, 0x000fc400020006ffULL, 0x00000008ff537819ULL, 0x000fe20000011653ULL,
0x20000046ff557230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe400020006ffULL,
0x00000052ff52723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000061ff3e7230ULL, 0x000fe20000004100ULL,
0x00000053ff37723eULL, 0x000fe200020006ffULL, 0x20000052ff537230ULL, 0x000fe20000004100ULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x20000060ff527230ULL, 0x000fe20000004100ULL,
0x000000ff51617812ULL, 0x000fe200078ec0ffULL, 0x20000037ff517230ULL, 0x000fe20000004100ULL,
0x000000ff36607812ULL, 0x000fe200078ec0ffULL, 0x20000048ff547230ULL, 0x000fe20000004100ULL,
0x00000010ff367819ULL, 0x000fe20000011655ULL, 0x20000042ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff377819ULL, 0x000fc4000001165eULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x000010545f377816ULL, 0x000fe40000000056ULL, 0x00000008ff567819ULL, 0x000fe40000011634ULL,
0x00000010ff357819ULL, 0x000fc40000011635ULL, 0x00000010ff347819ULL, 0x000fe2000001165dULL,
0x000000361418723cULL, 0x002fe20000041818ULL, 0x00000010ff5f7819ULL, 0x000fe40000011654ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010545f357816ULL, 0x000fe4000000005cULL, 0x00000008ff5c7819ULL, 0x000fc4000001164aULL,
0x00000010ff367819ULL, 0x000fe4000001164eULL, 0x00000010ff377819ULL, 0x000fe2000001165aULL,
0x000000341428723cULL, 0x000fe20000041828ULL, 0x00000010ff4c7819ULL, 0x000fe4000001164cULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000056ff56723eULL, 0x000fe400020006ffULL,
0x00000062ff46723eULL, 0x000fc400020006ffULL, 0x00000064ff64723eULL, 0x000fe200020006ffULL,
0x20000056ff4a7230ULL, 0x000fe20000004100ULL, 0x00000063ff42723eULL, 0x000fe200020006ffULL,
0x20000046ff467230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x20000064ff3c7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x0000005cff5c723eULL, 0x000fe200020006ffULL,
0x20000061ff557230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe20000000036ULL,
0x20000060ff547230ULL, 0x000fe20000004100ULL, 0x000010545b377816ULL, 0x000fe2000000004cULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x00000010ff5b7819ULL, 0x000fc40000011648ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff487819ULL, 0x000fe20000011651ULL,
0x00000036142c723cULL, 0x000fe2000004182cULL, 0x00000010ff357819ULL, 0x000fe40000011640ULL,
0x00000010ff347819ULL, 0x000fe40000011657ULL, 0x0000105443487816ULL, 0x000fe40000000048ULL,
0x00000010ff407819ULL, 0x000fc40000011649ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000010ff367819ULL, 0x000fe40000011653ULL, 0x00000010ff437819ULL, 0x000fe4000001163eULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff417819ULL, 0x000fc40000011641ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff497819ULL, 0x000fe40000011652ULL,
0x00000010ff557819ULL, 0x000fe40000011655ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff537819ULL, 0x000fc40000011654ULL, 0x00000010ff517819ULL, 0x000fe40000011642ULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x0000105435347816ULL, 0x000fe40000000034ULL,
0x000010545b357816ULL, 0x000fe40000000058ULL, 0x0000105443427816ULL, 0x000fe4000000004aULL,
0x0000105459407816ULL, 0x000fc40000000040ULL, 0x0000105436417816ULL, 0x000fe20000000041ULL,
0x000000341430723cULL, 0x000fe20000041830ULL, 0x0000105444497816ULL, 0x000fe20000000049ULL,
0x011000004b34783bULL, 0x0002e20000000200ULL, 0x0000105455527816ULL, 0x000fe40000000046ULL,
0x0000105453537816ULL, 0x000fe2000000003cULL, 0x000000401424723cULL, 0x000fe20000041824ULL,
0x0000105451437816ULL, 0x000fca000000005cULL, 0x000000481420723cULL, 0x000fec0000041820ULL,
0x00000052141c723cULL, 0x000fec000004181cULL, 0x000000421410723cULL, 0x000fe20000041810ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000100947ULL, 0x002fde0003800000ULL,
0x0000000334347232ULL, 0x08cfe40000200000ULL, 0x0000000336367232ULL, 0x000fe40000200000ULL,
0x0000000235357232ULL, 0x080fe40000200000ULL, 0x0000000237377232ULL, 0x000fce0000200000ULL,
0x0001400004047836ULL, 0x000fe40000000000ULL, 0x0000000100457824ULL, 0x040fe400078e0245ULL,
0x0000001047147824ULL, 0x000fe400078e0204ULL, 0x0000000800007824ULL, 0x000fe400078e00ffULL,
0x0000000107077836ULL, 0x000fe40000000000ULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0xfffffff800457812ULL, 0x000fca00078ee245ULL, 0x0000001045407824ULL, 0x000fcc00078e0204ULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x000000ff16517812ULL, 0x002fe400078ec0ffULL,
0x00000018ff457819ULL, 0x000fe40000011614ULL, 0x00000018ff4b7819ULL, 0x000fe40000011615ULL,
0x00000018ff4c7819ULL, 0x000fe40000011616ULL, 0x000000ff17527812ULL, 0x000fe400078ec0ffULL,
0x00000051ff54723eULL, 0x000fc400020006ffULL, 0x00000010ff4a7819ULL, 0x000fe40000011614ULL,
0x00000045ff45723eULL, 0x000fe400020006ffULL, 0x0000004bff4b723eULL, 0x000fe400020006ffULL,
0x0000ffff14587812ULL, 0x000fe200078ec0ffULL, 0x20000045ff517230ULL, 0x000fe20000004100ULL,
0x00000052ff57723eULL, 0x000fe200020006ffULL, 0x2000004bff527230ULL, 0x000fe20000004100ULL,
0x0000004cff55723eULL, 0x000fe200020006ffULL, 0x20000054ff4c7230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe20000011615ULL, 0x20000057ff4b7230ULL, 0x000fe20000004100ULL,
0x00000018ff567819ULL, 0x000fe20000011617ULL, 0x20000055ff457230ULL, 0x000fe20000004100ULL,
0x0000ffff15597812ULL, 0x000fc400078ec0ffULL, 0x000000ff4a4a7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff547819ULL, 0x000fe40000011658ULL, 0x00000056ff57723eULL, 0x000fe400020006ffULL,
0x000000ff53557812ULL, 0x000fe400078ec0ffULL, 0x00000008ff567819ULL, 0x000fe40000011659ULL,
0x0000004aff53723eULL, 0x000fe200020006ffULL, 0x20000057ff4a7230ULL, 0x000fe20000004100ULL,
0x00000054ff54723eULL, 0x000fc400020006ffULL, 0x00000010ff5b7819ULL, 0x000fe20000011616ULL,
0x20000053ff597230ULL, 0x000fe20000004100ULL, 0x0000ffff165d7812ULL, 0x000fe200078ec0ffULL,
0x20000054ff587230ULL, 0x000fe20000004100ULL, 0x0000ffff175e7812ULL, 0x000fe400078ec0ffULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff537819ULL, 0x000fe2000001165dULL, 0x20000056ff577230ULL, 0x000fe20000004100ULL,
0x00000008ff547819ULL, 0x000fc4000001165eULL, 0x00000010ff5c7819ULL, 0x000fe40000011617ULL,
0x000000ff14007812ULL, 0x000fe400078ec0ffULL, 0x000000ff15047812ULL, 0x000fe400078ec0ffULL,
0x00000055ff55723eULL, 0x000fe400020006ffULL, 0x0000005bff56723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fe200020006ffULL, 0x20000055ff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff41487812ULL, 0x010fe200078ec0ffULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000054ff5b723eULL, 0x000fe200020006ffULL, 0x20000053ff547230ULL, 0x000fe20000004100ULL,
0x00000018ff3c7819ULL, 0x000fc40000011640ULL, 0x00000018ff3e7819ULL, 0x000fe20000011641ULL,
0x2000005bff537230ULL, 0x000fe20000004100ULL, 0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff42497812ULL, 0x000fe400078ec0ffULL, 0x000000ff434e7812ULL, 0x000fe400078ec0ffULL,
0x00000000ff47723eULL, 0x000fe400020006ffULL, 0x00000004ff46723eULL, 0x000fc400020006ffULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x0000005cff55723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000049ff5b723eULL, 0x000fe400020006ffULL,
0x0000004eff5c723eULL, 0x000fe200020006ffULL, 0x20000048ff4e7230ULL, 0x000fe20000004100ULL,
0x00000018ff167819ULL, 0x000fe20000011642ULL, 0x2000003cff487230ULL, 0x000fe20000004100ULL,
0x00000018ff177819ULL, 0x000fe20000011643ULL, 0x2000003eff497230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x2000005bff3e7230ULL, 0x000fe20000004100ULL,
0x00000016ff5b723eULL, 0x000fe200020006ffULL, 0x2000005cff3c7230ULL, 0x000fe20000004100ULL,
0x00000017ff5c723eULL, 0x000fc400020006ffULL, 0x00000010ff167819ULL, 0x000fe40000011647ULL,
0x00000010ff177819ULL, 0x000fe20000011646ULL, 0x2000005bff467230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe2000001165aULL, 0x2000005cff477230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe40000011640ULL, 0x00000010ff157819ULL, 0x000fe40000011641ULL,
0x0000105459167816ULL, 0x000fc40000000016ULL, 0x000010545a177816ULL, 0x000fe40000000017ULL,
0x000000ff14597812ULL, 0x000fe400078ec0ffULL, 0x000000ff155a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff517819ULL, 0x000fe20000011651ULL, 0x000000163418723cULL, 0x008fe20000041818ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff147819ULL, 0x000fc40000011658ULL,
0x00000010ff157819ULL, 0x000fe40000011657ULL, 0x0000105451147816ULL, 0x000fe40000000014ULL,
0x0000105452157816ULL, 0x000fe40000000015ULL, 0x000000ff40447812ULL, 0x040fe400078ec0ffULL,
0x00000010ff457819ULL, 0x000fe40000011645ULL, 0x00000010ff4a7819ULL, 0x000fe2000001164aULL,
0x000000143428723cULL, 0x000fe20000041828ULL, 0x0000ffff40407812ULL, 0x000fc400078ec0ffULL,
0x0000ffff41417812ULL, 0x000fe400078ec0ffULL, 0x00000044ff44723eULL, 0x000fe400020006ffULL,
0x00000010ff147819ULL, 0x000fe40000011654ULL, 0x00000010ff157819ULL, 0x000fe20000011653ULL,
0x20000044ff447230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fc400020006ffULL, 0x00000010ff167819ULL, 0x000fe2000001164cULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff177819ULL, 0x000fe20000011656ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000105445147816ULL, 0x000fe40000000014ULL,
0x000010544a157816ULL, 0x000fe40000000015ULL, 0x00000010ff007819ULL, 0x000fe40000011642ULL,
0x00000010ff4b7819ULL, 0x000fc4000001164bULL, 0x00000010ff4c7819ULL, 0x000fe20000011655ULL,
0x000000143430723cULL, 0x000fe20000041830ULL, 0x00000008ff407819ULL, 0x000fe40000011640ULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x0000105417167816ULL, 0x000fe40000000016ULL,
0x00000010ff047819ULL, 0x000fe40000011643ULL, 0x000010544c177816ULL, 0x000fc4000000004bULL,
0x00000040ff40723eULL, 0x000fe400020006ffULL, 0x00000041ff41723eULL, 0x000fe400020006ffULL,
0x000000ff00007812ULL, 0x000fe200078ec0ffULL, 0x20000040ff407230ULL, 0x000fe20000004100ULL,
0x0000ffff42427812ULL, 0x000fe200078ec0ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000010ff147819ULL, 0x000fe20000011644ULL, 0x00000016342c723cULL, 0x000fe2000004182cULL,
0x00000010ff157819ULL, 0x000fc4000001164eULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x000000ff04047812ULL, 0x000fe400078ec0ffULL,
0x00000000ff00723eULL, 0x000fe400020006ffULL, 0x0000105459147816ULL, 0x000fe40000000014ULL,
0x000010545a157816ULL, 0x000fc40000000015ULL, 0x00000008ff427819ULL, 0x000fe40000011642ULL,
0x00000004ff16723eULL, 0x000fe200020006ffULL, 0x20000000ff047230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe20000011648ULL, 0x000000143424723cULL, 0x000fe20000041824ULL,
0x00000010ff007819ULL, 0x000fe20000011649ULL, 0x20000016ff167230ULL, 0x000fe20000004100ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff417819ULL, 0x000fc40000011641ULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000105417407816ULL, 0x000fe40000000040ULL,
0x0000105400417816ULL, 0x000fe20000000041ULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000010ff3e7819ULL, 0x000fe4000001163eULL, 0x00000010ff157819ULL, 0x000fe40000011604ULL,
0x0000ffff43437812ULL, 0x000fe200078ec0ffULL, 0x000000403420723cULL, 0x000fe20000041820ULL,
0x00000010ff007819ULL, 0x000fc40000011616ULL, 0x0000105415167816ULL, 0x000fe4000000003eULL,
0x00000010ff157819ULL, 0x000fe40000011646ULL, 0x00000010ff427819ULL, 0x000fe20000011642ULL,
0x00000001ff417424ULL, 0x000fe200078e00ffULL, 0x00000008ff437819ULL, 0x000fe40000011643ULL,
0x0000105415427816ULL, 0x000fe40000000042ULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x00000041061479a7ULL, 0x000e62000850003fULL, 0x00000010ff177819ULL, 0x000fc6000001163cULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000105400177816ULL, 0x000fe40000000017ULL,
0x00000010ff007819ULL, 0x000fe40000011647ULL, 0x00000010ff437819ULL, 0x000fc60000011643ULL,
0x00000016341c723cULL, 0x000fe2000004181cULL, 0x0000105400437816ULL, 0x000fe40000000043ULL,
0x0000000808007c11ULL, 0x000fc8000f8e18ffULL, 0x0176a04100ff79a7ULL, 0x0003e2000850003fULL,
0x000000423410723cULL, 0x000fe20000041810ULL, 0x000000ffff007224ULL, 0x002fe200078e0015ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0xffffff5400109947ULL, 0x000fde000383ffffULL,
0x000000ff3900720cULL, 0x000fda0003f05270ULL, 0x0000000000d48947ULL, 0x000fea0003800000ULL,
0x0180000050007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000c7f000047802ULL, 0x000fce0000000f00ULL,
0x0000008800847944ULL, 0x006fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005000037308ULL, 0x006e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000050ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fce0000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009800ff027b82ULL, 0x000f240000000a00ULL,
0x0000000602037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x00000002ff077819ULL, 0x022fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000001804187220ULL, 0x042fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000001a051a7220ULL, 0x044fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fce0000410000ULL, 0x0000000000037919ULL, 0x006e620000000000ULL,
0x000000202120723eULL, 0x000fe400000010ffULL, 0x0000001c1d1c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000101110723eULL, 0x000fc400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x000000323317723eULL, 0x000fe400000010ffULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000001e1f1e723eULL, 0x000fe400000010ffULL, 0x000000121312723eULL, 0x000fc400000010ffULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x00000002ff057819ULL, 0x002fe40000011603ULL,
0x0000000203007812ULL, 0x040fe400078ec0ffULL, 0x0000000803077811ULL, 0x000fe200078ff0ffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000000500027211ULL, 0x040fe200078ff8ffULL,
0x0000000805147824ULL, 0x000fe200078e00ffULL, 0x0000000700047211ULL, 0x000fe200078ff8ffULL,
0x0000000807077824ULL, 0x000fc400078e00ffULL, 0x0000000202007836ULL, 0x000fe40000000000ULL,
0x0000000402067836ULL, 0x000fe20000000000ULL, 0xfffffff807167812ULL, 0x000fe200078ee204ULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe400078ee200ULL,
0x0000000838007c11ULL, 0x000fe4000f8e60ffULL, 0xfffffff807047812ULL, 0x000fe200078ee202ULL,
0x0000000602077836ULL, 0x000fe20000000000ULL, 0xfffffff8090c7812ULL, 0x000fe200078ee206ULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0x000076321e097816ULL, 0x000fe20000000012ULL,
0x000008000b057824ULL, 0x000fe200078e0200ULL, 0xfffffff814147812ULL, 0x000fc400078ee207ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x0000001004067824ULL, 0x100fe200078e0205ULL,
0x000000181902723eULL, 0x000fe200000010ffULL, 0x0000001016167824ULL, 0x000fe200078e0205ULL,
0x000000282904723eULL, 0x000fe200000010ffULL, 0x0000000106067824ULL, 0x000fe400078e0207ULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x0000541002187816ULL, 0x100fe20000000004ULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x0000763202197816ULL, 0x000fe20000000004ULL,
0x0000001014147824ULL, 0x000fe200078e0205ULL, 0x0000002c2d02723eULL, 0x000fe200000010ffULL,
0x0000000107167824ULL, 0x000fe200078e0216ULL, 0x000000303104723eULL, 0x000fe200000010ffULL,
0x0000001806007388ULL, 0x0003e20000000a00ULL, 0x0000000107087824ULL, 0x000fe200078e0208ULL,
0x000000242505723eULL, 0x000fe200000010ffULL, 0x00000001070c7824ULL, 0x000fc400078e020cULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x0000763202077816ULL, 0x140fe40000000004ULL,
0x0000541002067816ULL, 0x002fe40000000004ULL, 0x0000001a1b02723eULL, 0x000fe400000010ffULL,
0x0000002a2b04723eULL, 0x000fe200000010ffULL, 0x0000000608007388ULL, 0x0003e40000000a00ULL,
0x0000541005067816ULL, 0x002fc40000000020ULL, 0x0000763205077816ULL, 0x000fe20000000020ULL,
0x000000010a057824ULL, 0x000fc800078e0203ULL, 0x000000060c007388ULL, 0x0003e20000000a00ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x000054101c067816ULL, 0x142fe40000000010ULL,
0x000076321c077816ULL, 0x000fca0000000010ULL, 0x0000000614007388ULL, 0x0003e40000000a00ULL,
0x0000541002067816ULL, 0x142fe40000000004ULL, 0x0000763202077816ULL, 0x000fe40000000004ULL,
0x000000ff00027306ULL, 0x000e660000202400ULL, 0x0000000616007388ULL, 0x0005e40000000a00ULL,
0x000054102e167816ULL, 0x004fc40000000017ULL, 0x000076322e177816ULL, 0x000fe40000000017ULL,
0x0000541026067816ULL, 0x140fe40000000022ULL, 0x0000763226077816ULL, 0x000fe20000000022ULL,
0x0004001608007388ULL, 0x0005e80000000a00ULL, 0x000400060c007388ULL, 0x000fe20000000a00ULL,
0x000054101e087816ULL, 0x004fca0000000012ULL, 0x0004000814007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000005107984ULL, 0x000e680000000c00ULL,
0x00040000051c7984ULL, 0x000ea80000000c00ULL, 0x0008000005187984ULL, 0x000ee80000000c00ULL,
0x000c000005207984ULL, 0x000f220000000c00ULL, 0x0000001302137230ULL, 0x002fc40000200800ULL,
0x0000001202127230ULL, 0x040fe40000200800ULL, 0x0000001102117230ULL, 0x040fe40000200800ULL,
0x0000001002107230ULL, 0x040fe40000200800ULL, 0x0000001f021f7230ULL, 0x044fe40000200800ULL,
0x0000001e021e7230ULL, 0x040fe40000200800ULL, 0x0000001d021d7230ULL, 0x000fc40000200800ULL,
0x0000001c02027230ULL, 0x000fe40000200800ULL, 0x0000001b13137230ULL, 0x008fe40000200000ULL,
0x0000001a12127230ULL, 0x000fe40000200000ULL, 0x0000001911117230ULL, 0x000fe40000200000ULL,
0x0000001810107230ULL, 0x000fe40000200000ULL, 0x000000231f1f7230ULL, 0x010fc40000200000ULL,
0x000000221e1e7230ULL, 0x000fe20000200000ULL, 0x0000001005007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000200000ULL, 0x00000020021c7230ULL, 0x000fca0000200000ULL,
0x0004001c05007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fc80000011603ULL,
0x0000000f0600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000013a027824ULL, 0x000fe200078e0206ULL,
0x0000000800087d06ULL, 0x000ea20008209000ULL, 0x00000008ff107c12ULL, 0x002fe2000f8e33ffULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fca0000000a00ULL,
0x0000000800087308ULL, 0x004e640000001000ULL, 0x0ffffffe08047836ULL, 0x002fcc0000000000ULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff077224ULL, 0x004fc800078e0a05ULL, 0x0000000807077c24ULL, 0x000fc8000f8e02ffULL,
0x0000000705117227ULL, 0x000fc800078e0004ULL, 0x0000000106047824ULL, 0x000fe400078e0203ULL,
0x0000000211077227ULL, 0x000fc600078e00ffULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a07ULL, 0x0000000805057c24ULL, 0x000fca000f8e0202ULL,
0x0000000805007c0cULL, 0x000fda000bf06070ULL, 0x8000000805050c36ULL, 0x000fe40008000000ULL,
0x0000000107070836ULL, 0x000fe20000000000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05070ULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x0ffffff804057812ULL, 0x000fca00078ef803ULL,
0x0000001005067824ULL, 0x000fca00078e0200ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000107071836ULL, 0x000fca0000000000ULL, 0x0000000710047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000000904057c24ULL, 0x000fe4000f8e023fULL,
0x0000000807027c24ULL, 0x000fe2000f8e0202ULL, 0x0000000703077812ULL, 0x000fc600078ec0ffULL,
0x0000000805057c24ULL, 0x000fe4000f8e0202ULL, 0x0000002003027836ULL, 0x000fe40000000000ULL,
0x0000000838077824ULL, 0x000fe200078e0207ULL, 0x000000050e057210ULL, 0x000fe40007f3e0ffULL,
0x00000003ff0d7819ULL, 0x000fc60000011602ULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f440cULL,
0x0000000f0d00720cULL, 0x000fe20003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000013a047824ULL, 0x102fe400078e020dULL, 0x00000001020d7824ULL, 0x000fe400078e020dULL,
0x0000000411057227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef802ULL,
0x0000000807067c24ULL, 0x000fc8000f8e0204ULL, 0x000000100d0d7824ULL, 0x000fe200078e0200ULL,
0x0000000806007c0cULL, 0x000fc8000bf26070ULL, 0x000000000d087984ULL, 0x0002b20000000c00ULL,
0x8000000806061c36ULL, 0x000fe40008000000ULL, 0x0000000105051836ULL, 0x000fc60000000000ULL,
0x0000000806007c0cULL, 0x000fda000bf46070ULL, 0x0000000105052836ULL, 0x000fca0000000000ULL,
0x0000000510067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000000906057c24ULL, 0x000fe4000f8e023fULL, 0x0000000807047c24ULL, 0x000fe2000f8e0204ULL,
0x0000000702077812ULL, 0x000fe200078ec0ffULL, 0x0000004003027836ULL, 0x000fe40000000000ULL,
0x0000000805057c24ULL, 0x000fe4000f8e0204ULL, 0x0000000838077824ULL, 0x000fe200078e0207ULL,
0x00000003ff0d7819ULL, 0x002fc40000011602ULL, 0x000000050e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe400088f4406ULL, 0x0000000f0d00720cULL, 0x000fe20003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000013a047824ULL, 0x102fe400078e020dULL,
0x00000001020d7824ULL, 0x000fe400078e020dULL, 0x0000000411057227ULL, 0x000fc600078e00ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef802ULL, 0x0000000807067c24ULL, 0x000fc8000f8e0204ULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x0000000806007c0cULL, 0x000fc8000bf26070ULL,
0x000000000d087984ULL, 0x000e720000000c00ULL, 0x8000000806061c36ULL, 0x000fe40008000000ULL,
0x0000000105051836ULL, 0x000fc60000000000ULL, 0x0000000806007c0cULL, 0x000fda000bf46070ULL,
0x0000000105052836ULL, 0x000fca0000000000ULL, 0x0000000510067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000000906057c24ULL, 0x000fe4000f8e023fULL,
0x0000000807047c24ULL, 0x000fe2000f8e0204ULL, 0x0000000702077812ULL, 0x000fc600078ec0ffULL,
0x0000000805057c24ULL, 0x000fca000f8e0204ULL, 0x000000050e057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe200088f4406ULL, 0x0000006003067836ULL, 0x000fe40000000000ULL,
0x0000000838037824ULL, 0x000fc600078e0207ULL, 0x00000003ff077819ULL, 0x000fe20000011606ULL,
0x0000001003027825ULL, 0x000fc600078e0004ULL, 0x0000000f0700720cULL, 0x000fe20003f26070ULL,
0x000000013a3a7824ULL, 0x000fe200078e0207ULL, 0x0000000802007986ULL, 0x0023f6000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000003a11027227ULL, 0x002fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x0000000106077824ULL, 0x000fe400078e0207ULL,
0x0000000803037c24ULL, 0x000fc6000f8e023aULL, 0x0000000707077812ULL, 0x000fe400078ec0ffULL,
0x0000000803007c0cULL, 0x000fe4000bf26070ULL, 0xfffffff807077812ULL, 0x000fca00078ef806ULL,
0x0000001007077824ULL, 0x000fca00078e0200ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x8000000803031c36ULL, 0x000fe40008000000ULL, 0x0000000102021836ULL, 0x000fc60000000000ULL,
0x0000000803007c0cULL, 0x000fda000bf46070ULL, 0x0000000102022836ULL, 0x000fca0000000000ULL,
0x0000000210027207ULL, 0x000fca0004000000ULL, 0x000000ffff057224ULL, 0x000fe400078e0a02ULL,
0x0000000902037c24ULL, 0x000fe4000f8e023fULL, 0x00000008053a7c24ULL, 0x000fe2000f8e023aULL,
0x0000000706057812ULL, 0x000fc600078ec0ffULL, 0x0000000803037c24ULL, 0x000fe4000f8e023aULL,
0x0000000838057824ULL, 0x000fc600078e0205ULL, 0x000000030e037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8040ffULL,
0x0000000503037c11ULL, 0x000fc600080f4400ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009800ff0e7b82ULL, 0x000e620000000a00ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x0000000207077824ULL, 0x000fe200078e00ffULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000001ff047424ULL, 0x000fe200078e00ffULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x000000060e067981ULL, 0x002322000c1e9900ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x000000403d087824ULL, 0x000fe400078e00ffULL, 0x01760004ff0479a7ULL, 0x000ea20008500008ULL,
0x0000000a073f7224ULL, 0x000fe200078e023fULL, 0x000000053f047899ULL, 0x000fc60008011604ULL,
0x000000053f0a7c24ULL, 0x000fe2000f8e0208ULL, 0x0000000c00240947ULL, 0x000ff00003800000ULL,
0x00000003ff0c7819ULL, 0x000fe2000001160dULL, 0x00009000000a7ab9ULL, 0x000fe20000000a00ULL,
0x000000083b077248ULL, 0x000fc60007fe0000ULL, 0x000000040c107836ULL, 0x000fe40000000000ULL,
0x0000000107077824ULL, 0x000fe400078e0a08ULL, 0x000000010a0e7824ULL, 0x002fe400078e020cULL,
0x0000000110097824ULL, 0x040fe200078e020dULL, 0x000000071000720cULL, 0x040fe20003fa6070ULL,
0x0000000810227824ULL, 0x000fe400078e00ffULL, 0x000000010a107824ULL, 0x000fc400078e0210ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fc600078ee209ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700e1c7812ULL, 0x000fc600078ef802ULL,
0x000000080c147836ULL, 0x000fe20000000000ULL, 0x0000007010167812ULL, 0x000fe200078ef802ULL,
0x0000000c0c187836ULL, 0x000fe20000000000ULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ff1e0ffULL,
0x00000001140b7824ULL, 0x140fe200078e020dULL, 0x0000000a16167c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000814247824ULL, 0x000fe200078e00ffULL, 0x0000000b0f1d7c10ULL, 0x000fe200087fe4ffULL,
0x000000100c127836ULL, 0x000fe20000000000ULL, 0x0000000b11177c10ULL, 0x000fe20008ffe4ffULL,
0x000000010a0e7824ULL, 0x040fe200078e0214ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x000000010a107824ULL, 0x000fe200078e0218ULL, 0x000000071200720cULL, 0x0c0fe20003f06070ULL,
0x00000001120b7824ULL, 0x000fe200078e020dULL, 0x000000071400720cULL, 0x080fe20003f26070ULL,
0x0000000812287824ULL, 0x000fe200078e00ffULL, 0x000000071800720cULL, 0x000fe20003f46070ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20bULL,
0x000000180c2c7836ULL, 0x000fe20000000000ULL, 0x000000700e1a7812ULL, 0x000fe200078ef802ULL,
0x000000010a127824ULL, 0x000fe400078e0212ULL, 0x000000140c207836ULL, 0x000fe20000000000ULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000000b0f1b7c10ULL, 0x000fe20009ffe4ffULL, 0x000000010a1e7824ULL, 0x000fe400078e022cULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x000000010a147824ULL, 0x000fe200078e0220ULL,
0x0000007012127812ULL, 0x000fe200078ef802ULL, 0x0000000118097824ULL, 0x040fe400078e020dULL,
0x0000000818267824ULL, 0x000fe200078e00ffULL, 0x0000007010187812ULL, 0x000fe200078ef802ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000a12127c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000a18187c10ULL, 0x000fe2000ff9e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x000000701e0e7812ULL, 0x000fc400078ef802ULL, 0x0000000b11197c10ULL, 0x000fe2000a7fe4ffULL,
0x000000010c0b7824ULL, 0x100fe200078e020dULL, 0x0000007014107812ULL, 0x000fe200078ef802ULL,
0x00000008202a7824ULL, 0x000fe200078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000012c237824ULL, 0x100fe200078e020dULL, 0x0000000b13137c10ULL, 0x000fe20009ffe4ffULL,
0x0000001c0c2e7836ULL, 0x000fe20000000000ULL, 0x0000000a10107c10ULL, 0x000fe2000ff7e0ffULL,
0x000000280c347836ULL, 0x000fe20000000000ULL, 0xfffffff826267812ULL, 0x000fe200078ee209ULL,
0x000000010a147824ULL, 0x000fe200078e022eULL, 0x000000083d097c11ULL, 0x000fe2000f8e70ffULL,
0x000000200c307836ULL, 0x000fe20000000000ULL, 0x0000000b1f0f7c10ULL, 0x000fe2000a7fe4ffULL,
0x000000240c327836ULL, 0x000fe20000000000ULL, 0x000000070b1e7812ULL, 0x000fe200078ec0ffULL,
0x00000001200b7824ULL, 0x000fe200078e020dULL, 0x000000070c00720cULL, 0x080fe20003f86070ULL,
0x0000100009097836ULL, 0x000fe20000000000ULL, 0x0000000b15117c10ULL, 0x000fe20009ffe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000072000720cULL, 0x000fc40003f66070ULL,
0x0ffffff81e207812ULL, 0x000fe200078ef80dULL, 0x000000010a257824ULL, 0x040fe200078e0234ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee20bULL, 0x000000010a1e7824ULL, 0x000fe200078e0230ULL,
0x0000007014147812ULL, 0x000fe200078ef802ULL, 0x00000010200b7824ULL, 0x000fe400078e0209ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe4000ffde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c0b7faeULL, 0x0003e2000e101c46ULL,
0x000000072c00720cULL, 0x040fe20003f86070ULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x000000701e1e7812ULL, 0x000fe200078ef802ULL, 0x000000010a207824ULL, 0x000fe200078e0232ULL,
0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000830277824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee223ULL, 0x000000082e237824ULL, 0x000fe200078e00ffULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0x0000000b1f1f7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000010220b7824ULL, 0x002fe200078e0209ULL,
0x0000007020207812ULL, 0x000fe200078ef802ULL, 0x000000012e227824ULL, 0x040fe400078e020dULL,
0x00000080251c7825ULL, 0x000fe200078e00ffULL, 0x00000000160b7faeULL, 0x0003e2000e901c46ULL,
0x000000072e00720cULL, 0x080fe40003fa6070ULL, 0xfffffff823227812ULL, 0x000fe200078ee222ULL,
0x0000001024237824ULL, 0x000fe200078e0209ULL, 0x0000000a20207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000132257824ULL, 0x100fe200078e020dULL, 0x000000701c1c7812ULL, 0x000fe200078ef802ULL,
0x0000000130247824ULL, 0x040fe200078e020dULL, 0x000000001a237faeULL, 0x0007e2000c901c46ULL,
0x0000002c0c2e7836ULL, 0x000fe20000000000ULL, 0x000000073000720cULL, 0x000fe20003f26070ULL,
0x00000010260b7824ULL, 0x002fe200078e0209ULL, 0xfffffff827247812ULL, 0x000fe200078ee224ULL,
0x000000010a167824ULL, 0x000fe200078e022eULL, 0x0000000b21217c10ULL, 0x000fc4000b7fe4ffULL,
0x00000000180b7faeULL, 0x0003e2000d101c46ULL, 0x000000073200720cULL, 0x0c0fe20003f46070ULL,
0x0000000832327824ULL, 0x000fe200078e00ffULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x00000010281b7824ULL, 0x108fe400078e0209ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000b1d1d7c10ULL, 0x000fe4000b7fe4ffULL, 0x00000000121b7faeULL, 0x0007e2000c101c46ULL,
0x0000001022237824ULL, 0x100fe200078e0209ULL, 0x0000007016167812ULL, 0x000fe200078ef802ULL,
0x000000102a0b7824ULL, 0x102fe200078e0209ULL, 0xfffffff832187812ULL, 0x000fe200078ee225ULL,
0x000000102c197824ULL, 0x100fe200078e0209ULL, 0x0000000a16167c10ULL, 0x000fe2000ffde0ffULL,
0x000000340c227836ULL, 0x000fe20000000000ULL, 0x00000000100b7faeULL, 0x0003e2000d901c46ULL,
0x0000001018277824ULL, 0x100fe200078e0209ULL, 0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL,
0x000000300c187836ULL, 0x000fe20000000000ULL, 0x000000000e197faeULL, 0x000be2000e101c46ULL,
0x0000001024257824ULL, 0x000fe200078e0209ULL, 0x000000072e00720cULL, 0x080fe20003f86070ULL,
0x000000010a127824ULL, 0x008fe200078e0218ULL, 0x0000000014237faeULL, 0x0007e2000e901c46ULL,
0x000000380c247836ULL, 0x000fe20000000000ULL, 0x000000073400720cULL, 0x080fe20003fa6070ULL,
0x0000003c0c0c7836ULL, 0x000fe20000000000ULL, 0x000000001e257faeULL, 0x0007e2000c901c46ULL,
0x000000010a107824ULL, 0x002fe200078e0222ULL, 0x000000071800720cULL, 0x080fe20003f66070ULL,
0x00000001340b7824ULL, 0x000fe200078e020dULL, 0x0000000020277faeULL, 0x0003e2000d101c46ULL,
0x00000080120e7825ULL, 0x024fe200078e00ffULL, 0x000000072200720cULL, 0x000fc40003f46070ULL,
0x000000072400720cULL, 0x080fe20003f26070ULL, 0x0000000834147824ULL, 0x008fe200078e00ffULL,
0x000000700e127812ULL, 0x000fe200078ef802ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000070c00720cULL, 0x000fe40003f06070ULL, 0x0000000a12127c10ULL, 0x000fe2000ffde0ffULL,
0x000000010a0e7824ULL, 0x000fe200078e0224ULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000012e077824ULL, 0x140fe200078e020dULL, 0x0000000b0f137c10ULL, 0x000fe2000b7fe4ffULL,
0x000000082e2e7824ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fe200078ef802ULL,
0x00000001180b7824ULL, 0x000fc400078e020dULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff82e187812ULL, 0x000fe400078ee207ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL,
0x000000010a0a7824ULL, 0x000fe200078e020cULL, 0x000000700e0e7812ULL, 0x000fe200078ef802ULL,
0x0000000122077824ULL, 0x000fe200078e020dULL, 0x0000000b11117c10ULL, 0x000fe2000b7fe4ffULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x000000700a027812ULL, 0x000fe200078ef802ULL, 0x0000000124157824ULL, 0x140fe400078e020dULL,
0x00000008241e7824ULL, 0x000fe400078e00ffULL, 0x000000010c0d7824ULL, 0x040fe400078e020dULL,
0x000000080c207824ULL, 0x002fe200078e00ffULL, 0x0000000a0e0c7c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff8220e7812ULL, 0x000fe200078ee207ULL, 0x0000001014077824ULL, 0x100fe200078e0209ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL, 0x000000101a157824ULL, 0x100fe200078e0209ULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x000000100e197824ULL, 0x100fe200078e0209ULL,
0x0000000b0f0d7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000010180f7824ULL, 0x100fe200078e0209ULL,
0x0000000a020a7c10ULL, 0x000fe2000ffde0ffULL, 0x000000101e1b7824ULL, 0x100fe200078e0209ULL,
0x000000001c077faeULL, 0x0003e2000e901c46ULL, 0x0000001020097824ULL, 0x000fe200078e0209ULL,
0x0000000b0b0b7c10ULL, 0x000fc4000b7fe4ffULL, 0x00000000160f7faeULL, 0x0003e8000e101c46ULL,
0x0000000012157faeULL, 0x0003e8000d901c46ULL, 0x0000000010197faeULL, 0x0003e8000d101c46ULL,
0x000000000c1b7faeULL, 0x0003e8000c901c46ULL, 0x000000000a097faeULL, 0x0003e2000c101c46ULL,
0x0000000800d47947ULL, 0x000fea0003800000ULL, 0x000000040d097811ULL, 0x040fe200078fe8ffULL,
0x00009000000a7ab9ULL, 0x000fe20000000a00ULL, 0x000000140d137811ULL, 0x040fe400078fe8ffULL,
0x000000080d0e7811ULL, 0x002fe200078fe8ffULL, 0x0000000109077824ULL, 0x100fe200078e020dULL,
0x000000100d127811ULL, 0x000fe200078fe8ffULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0x0000000c0d0f7811ULL, 0x000fe200078fe8ffULL, 0x0000000113117824ULL, 0x100fe200078e020dULL,
0x000000180d157811ULL, 0x000fe200078fe8ffULL, 0x0000000813187824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x000000010e077824ULL, 0x140fe200078e020dULL,
0x0000001c0d177811ULL, 0x040fe200078fe8ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff818217812ULL, 0x000fe200078ee211ULL, 0x00000001120c7824ULL, 0x140fe200078e020dULL,
0x000000200d187811ULL, 0x000fe200078fe8ffULL, 0x00000008121f7824ULL, 0x000fe200078e00ffULL,
0xfffffff814197812ULL, 0x000fe200078ee207ULL, 0x000000010f0b7824ULL, 0x100fe200078e020dULL,
0x000000280d1c7811ULL, 0x000fe200078fe8ffULL, 0x000000080f167824ULL, 0x000fe200078e00ffULL,
0x000000240d1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000115077824ULL, 0x140fe200078e020dULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0xfffffff8161d7812ULL, 0x000fe200078ee20bULL, 0x00000001180c7824ULL, 0x140fe200078e020dULL,
0x000000300d247811ULL, 0x000fe200078fe8ffULL, 0x0000000818277824ULL, 0x000fe200078e00ffULL,
0xfffffff814237812ULL, 0x000fe200078ee207ULL, 0x00000001170b7824ULL, 0x100fe200078e020dULL,
0x0000002c0d1e7811ULL, 0x000fe200078fe8ffULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0x000000340d2b7811ULL, 0x000fe200078fe8ffULL, 0x000000011c077824ULL, 0x140fe200078e020dULL,
0xfffffff827207812ULL, 0x000fe200078ee20cULL, 0x000000081c267824ULL, 0x000fe200078e00ffULL,
0xfffffff816257812ULL, 0x000fe200078ee20bULL, 0x000000011b117824ULL, 0x100fe200078e020dULL,
0x000000380d2f7811ULL, 0x000fe200078fe8ffULL, 0x000000081b227824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee207ULL, 0x00000001240c7824ULL, 0x140fe200078e020dULL,
0x0000000d0d077211ULL, 0x040fe200078fe8ffULL, 0x0000000824297824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x000000011e0b7824ULL, 0x140fe200078e020dULL,
0x0000003c0d307811ULL, 0x000fe200078fe8ffULL, 0x000000081e147824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x000000012b117824ULL, 0x000fe200078e020dULL,
0x00000007070c7812ULL, 0x000fe200078ec0ffULL, 0x000000082b167824ULL, 0x000fe200078e00ffULL,
0xfffffff814277812ULL, 0x000fe200078ee20bULL, 0x000000010a287824ULL, 0x040fe200078e0218ULL,
0x0000000a0d0b7211ULL, 0x000fe200078fe8ffULL, 0x000000010a2c7824ULL, 0x040fe200078e021cULL,
0xfffffff8162d7812ULL, 0x000fe200078ee211ULL, 0x000000010a117824ULL, 0x040fe200078e020fULL,
0x0ffffff80c077812ULL, 0x000fe200078ef80dULL, 0x000000012f0f7824ULL, 0x000fe200078e020dULL,
0x000000083d0c7c11ULL, 0x000fe2000f8e70ffULL, 0x000000010a2e7824ULL, 0x000fc400078e021eULL,
0x000000010a187824ULL, 0x000fe400078e0230ULL, 0x00000001300d7824ULL, 0x000fe400078e020dULL,
0x000000010a097824ULL, 0x040fe400078e0209ULL, 0x000000010a0e7824ULL, 0x040fe400078e020eULL,
0x000000010a127824ULL, 0x040fe400078e0212ULL, 0x000000010a147824ULL, 0x000fc400078e0213ULL,
0x000000010a167824ULL, 0x040fe400078e0215ULL, 0x000000010a1a7824ULL, 0x040fe400078e0217ULL,
0x000000010a2a7824ULL, 0x040fe400078e021bULL, 0x000000010a247824ULL, 0x040fe400078e0224ULL,
0x000000010a1e7824ULL, 0x040fe400078e022bULL, 0x000000010a1c7824ULL, 0x000fc400078e022fULL,
0x000000082f327824ULL, 0x000fe400078e00ffULL, 0x0000000830307824ULL, 0x000fe400078e00ffULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff832137812ULL, 0x000fe400078ee20fULL,
0xfffffff830157812ULL, 0x000fe200078ee20dULL, 0x000010000c307836ULL, 0x000fe20000000000ULL,
0x000000700a0a7812ULL, 0x000fe200078ef802ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000a0a0a7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000080090c7825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fe400078ef802ULL, 0x0000000b0b0b7c10ULL, 0x000fe200087fe4ffULL,
0x0000001010097824ULL, 0x100fe200078e0230ULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe400078ef802ULL,
0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL, 0x0000001015477824ULL, 0x000fe200078e0230ULL,
0x0000007010107812ULL, 0x000fe200078ef802ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000a0c0c7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001013457824ULL, 0x000fe200078e0230ULL, 0x0000007014147812ULL, 0x000fe200078ef802ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000b11117c10ULL, 0x000fe400087fe4ffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fe400078ef802ULL, 0x0000000b0d0d7c10ULL, 0x000fe20008ffe4ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x000000701a1a7812ULL, 0x000fc400078ef802ULL,
0x0000000a12127c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001029417824ULL, 0x100fe200078e0230ULL,
0x0000007016167812ULL, 0x000fe200078ef802ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe400087fe4ffULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000102d437824ULL, 0x000fe200078e0230ULL, 0x0000007028327812ULL, 0x000fe200078ef802ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000a16167c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000b13137c10ULL, 0x000fe20008ffe4ffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x000000702a347812ULL, 0x000fe400078ef802ULL, 0x0000000a32327c10ULL, 0x000fe2000ff3e0ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x000000702c367812ULL, 0x000fe400078ef802ULL,
0x0000000b1b1b7c10ULL, 0x000fe200087fe4ffULL, 0x0000001007077824ULL, 0x100fe200078e0230ULL,
0x0000000b17177c10ULL, 0x000fe200097fe4ffULL, 0x0000001019197824ULL, 0x100fe200078e0230ULL,
0x0000000a34347c10ULL, 0x000fe2000ff1e0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0230ULL,
0x0000000a36367c10ULL, 0x000fe2000ff5e0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0230ULL,
0x0000000b29337c10ULL, 0x000fe20008ffe4ffULL, 0x0000008024287825ULL, 0x000fe200078e00ffULL,
0x000000702e2e7812ULL, 0x000fe200078ef802ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e2000b901c46ULL, 0x0000000b2b357c10ULL, 0x000fe200087fe4ffULL,
0x000000801e2a7825ULL, 0x000fe200078e00ffULL, 0x0000000b2d377c10ULL, 0x000fe200097fe4ffULL,
0x000000000c097faeULL, 0x0003e2000b901c46ULL, 0x0000000a2e2e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001021217824ULL, 0x100fe200078e0230ULL, 0x0000007028287812ULL, 0x000fe200078ef802ULL,
0x0000001023237824ULL, 0x100fe200078e0230ULL, 0x000000702a2a7812ULL, 0x000fe200078ef802ULL,
0x0000001025257824ULL, 0x100fe200078e0230ULL, 0x0000000b2f2f7c10ULL, 0x000fe200087fe4ffULL,
0x0000001020207824ULL, 0x100fe200078e0230ULL, 0x000000000e197faeULL, 0x0003e2000b901c46ULL,
0x0000001022227824ULL, 0x100fe200078e0230ULL, 0x0000000a28287c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001026267824ULL, 0x100fe200078e0230ULL, 0x00000000101d7faeULL, 0x0003e2000b901c46ULL,
0x0000001027277824ULL, 0x000fe200078e0230ULL, 0x0000000a2a2a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000801c2c7825ULL, 0x000fe200078e00ffULL, 0x00000000121f7faeULL, 0x0003e2000b901c46ULL,
0x0000000b29297c10ULL, 0x000fc400087fe4ffULL, 0x0000008018307825ULL, 0x000fe200078e00ffULL,
0x000000702c2c7812ULL, 0x000fe200078ef802ULL, 0x0000000014217faeULL, 0x0003e2000b901c46ULL,
0x0000000b2b2b7c10ULL, 0x000fe40008ffe4ffULL, 0x0000007030027812ULL, 0x000fe200078ef802ULL,
0x0000000016237faeULL, 0x0003e2000b901c46ULL, 0x0000000a2c2c7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000a02307c10ULL, 0x000fe2000ff7e0ffULL, 0x000000001a257faeULL, 0x0003e2000b901c46ULL,
0x0000000b2d2d7c10ULL, 0x000fc400097fe4ffULL, 0x0000000b31317c10ULL, 0x000fe20009ffe4ffULL,
0x0000000032207faeULL, 0x0003e8000b901c46ULL, 0x0000000034227faeULL, 0x0003e8000b901c46ULL,
0x0000000036267faeULL, 0x0003e8000b901c46ULL, 0x000000002e277faeULL, 0x0003e8000b901c46ULL,
0x0000000028417faeULL, 0x0003e8000b901c46ULL, 0x000000002a437faeULL, 0x0003e8000b901c46ULL,
0x000000002c457faeULL, 0x0003e8000b901c46ULL, 0x0000000030477faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01760005ff0075a7ULL, 0x004e620008000148ULL, 0x000000013b027824ULL, 0x000fe400078e0a00ULL,
0x0000000403037c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff027819ULL, 0x000fe20000011602ULL,
0x00008e00ff487b82ULL, 0x000ea40000000a00ULL, 0x0000000403487825ULL, 0x004fe200078e0048ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff077224ULL, 0x000fce00078e00ffULL,
0x000000100700780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140dULL,
0x0000000c03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000203037819ULL, 0x000fc8000000120cULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000107077836ULL, 0x000fce0000000000ULL,
0x01760005ff0075a7ULL, 0x000e640008000148ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x000000203d037824ULL, 0x002fca00078e0204ULL,
0x00000003ff047819ULL, 0x000fc80000011603ULL, 0x1ffffffe040a7812ULL, 0x000fe400078ec0ffULL,
0x0000000f03047812ULL, 0x000fc600078ec0ffULL, 0x00000001030a7824ULL, 0x000fe400078e020aULL,
0x0000001004057824ULL, 0x000fe400078e00ffULL, 0x000000010a037836ULL, 0x000fe20000000000ULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fc600078e00ffULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x000000f0050a7812ULL, 0x000fe400078ee20aULL,
0x000000f004037812ULL, 0x000fe400078ee203ULL, 0x000000080a0a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000803037c11ULL, 0x000fc6000f8e20ffULL, 0x000000000a107984ULL, 0x000e680000000c00ULL,
0x00000000030c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fc400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fe200078e000fULL, 0x000000140a007388ULL, 0x0003e20000000c00ULL,
0x00000001ff0c7424ULL, 0x000fc600078e00ffULL, 0x0000001003007388ULL, 0x0003e60000000c00ULL,
0x0176000cff0c79a7ULL, 0x000ea40008500008ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x0176000dff0075a7ULL, 0x004ea40008000148ULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff077224ULL, 0x000fce00078e00ffULL, 0x000000100700780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x0000000a040a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e05ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140bULL, 0x0000000a03037211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000203037819ULL, 0x000fc8000000120aULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000107077836ULL, 0x000fce0000000000ULL, 0x0176000dff0075a7ULL, 0x000ea40008000148ULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000ff3900720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000010008047836ULL, 0x000fe40000000000ULL, 0x3db504f306057820ULL, 0x010fe20000410000ULL,
0x000000083d067c11ULL, 0x040fe2000f8e18ffULL, 0xffffffff00077836ULL, 0x000fe20000000000ULL,
0x000000083d097c11ULL, 0x000fe2000f8e28ffULL, 0x0000000900087836ULL, 0x000fe20000000000ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0x000000ffff0b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff127224ULL, 0x000fd200078e00ffULL, 0x000000020b0a7836ULL, 0x002fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x0000000112347812ULL, 0x000fc600078e0cffULL,
0x000000390a00720cULL, 0x000fe20003f06070ULL, 0x000001000b0a7824ULL, 0x000fc800078e0204ULL,
0x000000043f0c7c24ULL, 0x000fd0000f8e020aULL, 0x0000000c00308947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x002fe20000011603ULL, 0x00009000000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000000a3b0d7248ULL, 0x000fc60007fe0000ULL, 0x000000081f137836ULL, 0x000fe40000000000ULL,
0x000000041f0f7836ULL, 0x000fe40000000000ULL, 0x0000000113297824ULL, 0x140fe400078e0203ULL,
0x0000000813107824ULL, 0x000fe400078e00ffULL, 0x000000010d1e7824ULL, 0x000fe400078e0a0aULL,
0x00000010030d7824ULL, 0x000fe200078e00ffULL, 0xfffffff810297812ULL, 0x000fe200078ee229ULL,
0x000000010f107824ULL, 0x040fe200078e020cULL, 0x0000001e0f00720cULL, 0x000fe20003fa6070ULL,
0x0000000c1f157836ULL, 0x000fe20000000000ULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000010f0e7824ULL, 0x000fc400078e0203ULL, 0x000000080f2d7824ULL, 0x000fe200078e00ffULL,
0x0000001e1500720cULL, 0x000fe20003f46070ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x0000000115147824ULL, 0x140fe200078e0203ULL,
0x0000000d101a7212ULL, 0x000fe200078efcffULL, 0x00000008152f7824ULL, 0x000fe400078e00ffULL,
0x000000101f177836ULL, 0x000fe20000000000ULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000011f0e7824ULL, 0x100fe200078e020cULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee214ULL,
0x0000000117257824ULL, 0x040fe200078e0203ULL, 0x0000000b111b7c10ULL, 0x000fe20008ffe4ffULL,
0x0000000817107824ULL, 0x000fe200078e00ffULL, 0x0000001e1300720cULL, 0x000fe20003f26070ULL,
0x0000000115147824ULL, 0x000fc400078e020cULL, 0x000000141f277836ULL, 0x000fe20000000000ULL,
0xfffffff810257812ULL, 0x000fe200078ee225ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000000181f337836ULL, 0x000fe20000000000ULL, 0x0000000d0e0e7212ULL, 0x000fe200078efcffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000127207824ULL, 0x100fe200078e020cULL, 0x0000000d141c7212ULL, 0x080fe200078efcffULL,
0x0000000113107824ULL, 0x100fe200078e020cULL, 0x0000000b0f0f7c10ULL, 0x000fe200087fe4ffULL,
0x0000000133227824ULL, 0x000fe200078e020cULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000001e1700720cULL, 0x000fe40003f06070ULL,
0x0000000b151d7c10ULL, 0x000fe2000a7fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000d20147212ULL, 0x000fc400078efcffULL, 0x000000083d137c11ULL, 0x000fe2000f8e70ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000d10187212ULL, 0x080fe400078efcffULL,
0x0000000a14147c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000117167824ULL, 0x000fe200078e020cULL,
0x0000000d22107212ULL, 0x000fe200078efcffULL, 0x000000011f227824ULL, 0x000fe200078e0203ULL,
0x0000000a18187c10ULL, 0x000fe2000ff7e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000b21157c10ULL, 0x000fc4000a7fe4ffULL, 0x0000000722227812ULL, 0x000fe200078ec0ffULL,
0x0000200034247824ULL, 0x000fe200078e0213ULL, 0x0000000d16167212ULL, 0x000fe200078efcffULL,
0x000000281f437836ULL, 0x000fe20000000000ULL, 0x0000001e1f00720cULL, 0x000fe20003f86070ULL,
0x0000100024247836ULL, 0x000fe20000000000ULL, 0x0000000b11197c10ULL, 0x000fe20009ffe4ffULL,
0x0000001c1f357836ULL, 0x000fe20000000000ULL, 0x0ffffff8222b7812ULL, 0x000fe200078ef803ULL,
0x0000000143287824ULL, 0x100fe200078e020cULL, 0x0000000a16167c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000135207824ULL, 0x000fc400078e020cULL, 0x000000102b2b7824ULL, 0x000fe200078e0224ULL,
0x0000000b17177c10ULL, 0x000fe20009ffe4ffULL, 0x000000201f377836ULL, 0x000fe20000000000ULL,
0x0000000a10107c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000827267824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e2b7faeULL, 0x0003e2000e101c46ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000000b23117c10ULL, 0x000fe40009ffe4ffULL,
0x0000001e3300720cULL, 0x080fe20003f86070ULL, 0x0000000127237824ULL, 0x000fe200078e0203ULL,
0x0000000d20207212ULL, 0x000fe200078efcffULL, 0x0000000137227824ULL, 0x000fe200078e020cULL,
0x0000001e2700720cULL, 0x000fe20003f66070ULL, 0x000000241f417836ULL, 0x000fe20000000000ULL,
0xfffffff826317812ULL, 0x000fe200078ee223ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000000a20207c10ULL, 0x000fc6000ffde0ffULL, 0x000000102d2b7824ULL, 0x002fe200078e0224ULL,
0x0000000d22227212ULL, 0x080fe200078efcffULL, 0x00000080280e7825ULL, 0x000fe200078e00ffULL,
0x0000000b21217c10ULL, 0x000fe4000b7fe4ffULL, 0x000000001a2b7faeULL, 0x0003e2000e901c46ULL,
0x0000000135287824ULL, 0x140fe200078e0203ULL, 0x0000000a22227c10ULL, 0x000fe2000ffde0ffULL,
0x00000008352d7824ULL, 0x000fe200078e00ffULL, 0x0000000d0e0e7212ULL, 0x000fe200078efcffULL,
0x0000000141267824ULL, 0x000fe200078e020cULL, 0x0000000b23237c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001332a7824ULL, 0x100fe200078e0203ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee228ULL,
0x0000000137287824ULL, 0x000fe200078e0203ULL, 0x0000001e3500720cULL, 0x000fe20003fa6070ULL,
0x0000000833337824ULL, 0x000fc400078e00ffULL, 0x000000102f2b7824ULL, 0x102fe400078e0224ULL,
0x00000008372f7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee22aULL,
0x0000001029297824ULL, 0x100fe400078e0224ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee228ULL, 0x0000000018297faeULL, 0x0003e2000c901c46ULL,
0x0000002c1f457836ULL, 0x000fe20000000000ULL, 0x0000000d26267212ULL, 0x000fe200078efcffULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0x000000001c2b7faeULL, 0x0005e2000d101c46ULL,
0x00000001451a7824ULL, 0x000fe200078e020cULL, 0x0000000a26267c10ULL, 0x000fe2000ffde0ffULL,
0x00000001412a7824ULL, 0x000fe200078e0203ULL, 0x0000000016257faeULL, 0x0007e2000c101c46ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000b27277c10ULL, 0x000fc4000b7fe4ffULL,
0x0000000a0e0e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000001031197824ULL, 0x102fe200078e0224ULL,
0x0000000d1a1a7212ULL, 0x000fe200078efcffULL, 0x0000000841357824ULL, 0x000fe200078e00ffULL,
0x0000000b0f0f7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000102f2b7824ULL, 0x104fe200078e0224ULL,
0x0000000014197faeULL, 0x0003e2000d901c46ULL, 0x000000301f2f7836ULL, 0x000fe20000000000ULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x00000010331d7824ULL, 0x000fe200078e0224ULL,
0x0000001e3700720cULL, 0x080fe20003f26070ULL, 0x000000012f167824ULL, 0x108fe200078e020cULL,
0x0000000b1b1b7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000341f257836ULL, 0x000fe20000000000ULL,
0x00000000101d7faeULL, 0x0005e2000e101c46ULL, 0x0000001e4100720cULL, 0x080fe20003f46070ULL,
0x000000381f317836ULL, 0x000fe20000000000ULL, 0xfffffff835357812ULL, 0x000fe200078ee22aULL,
0x0000000125147824ULL, 0x002fe200078e020cULL, 0x0000001e4500720cULL, 0x080fe20003f86070ULL,
0x0000003c1f337836ULL, 0x000fe20000000000ULL, 0x0000001e2f00720cULL, 0x000fe20003f66070ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x0000001e3300720cULL, 0x000fe20003f06070ULL,
0x0000008016107825ULL, 0x004fe200078e00ffULL, 0x0000000d14187212ULL, 0x000fc600078efcffULL,
0x0000000143167824ULL, 0x140fe200078e0203ULL, 0x0000000d10107212ULL, 0x000fe200078efcffULL,
0x00000008431d7824ULL, 0x000fe400078e00ffULL, 0x00000008451f7824ULL, 0x000fe200078e00ffULL,
0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL, 0x0000000131147824ULL, 0x000fe200078e020cULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL, 0x0000000145167824ULL, 0x100fe200078e0203ULL,
0x0000000b11117c10ULL, 0x000fe2000b7fe4ffULL, 0x000000102d297824ULL, 0x100fe200078e0224ULL,
0x0000000a18187c10ULL, 0x000fe2000ffde0ffULL, 0x000000012f177824ULL, 0x040fe200078e0203ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL, 0x000000082f1c7824ULL, 0x000fe200078e00ffULL,
0x0000000b15197c10ULL, 0x000fe2000b7fe4ffULL, 0x00000010352d7824ULL, 0x000fe200078e0224ULL,
0x0000000020297faeULL, 0x0003e2000e901c46ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001e4300720cULL, 0x000fc40003fa6070ULL, 0x00000000222b7faeULL, 0x0005e2000c901c46ULL,
0x0000000133167824ULL, 0x000fe200078e020cULL, 0x0000000d14147212ULL, 0x080fe200078efcffULL,
0x00000001310c7824ULL, 0x100fe200078e0203ULL, 0x00000000262d7faeULL, 0x0007e2000d101c46ULL,
0x0000001e2500720cULL, 0x080fe20003f46070ULL, 0x000000101d1d7824ULL, 0x000fe200078e0224ULL,
0x0000001e3100720cULL, 0x000fe20003f26070ULL, 0x00000001331e7824ULL, 0x100fe200078e0203ULL,
0xfffffff81c217812ULL, 0x002fe200078ee217ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000a14147c10ULL, 0x000fe2000ffde0ffULL, 0x000000000e1d7faeULL, 0x0003e4000e901c46ULL,
0x00000001251c7824ULL, 0x040fe200078e0203ULL, 0x0000000d160d7212ULL, 0x000fe200078efcffULL,
0x0000000825237824ULL, 0x004fe200078e00ffULL, 0x0000000b15157c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000831257824ULL, 0x000fc400078e00ffULL, 0x0000000833277824ULL, 0x008fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x000000101f1f7824ULL, 0x100fe200078e0224ULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x0000001021217824ULL, 0x100fe200078e0224ULL,
0xfffffff827277812ULL, 0x000fe200078ee21eULL, 0x0000001023237824ULL, 0x100fe200078e0224ULL,
0x0000000a0d0c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000001025257824ULL, 0x100fe200078e0224ULL,
0x000000001a1f7faeULL, 0x0003e2000e101c46ULL, 0x0000001027277824ULL, 0x000fe200078e0224ULL,
0x0000000b170d7c10ULL, 0x000fc4000b7fe4ffULL, 0x0000000010217faeULL, 0x0003e8000d901c46ULL,
0x0000000018237faeULL, 0x0003e8000d101c46ULL, 0x0000000014257faeULL, 0x0003e8000c901c46ULL,
0x000000000c277faeULL, 0x0003e2000c101c46ULL, 0x0000000800e07947ULL, 0x000fea0003800000ULL,
0x0000000803107811ULL, 0x042fe200078fe8ffULL, 0x00000010034d7824ULL, 0x040fe200078e00ffULL,
0x00000004030e7811ULL, 0x040fe200078fe8ffULL, 0x00009000000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000001003167811ULL, 0x040fe200078fe8ffULL, 0x00000001100f7824ULL, 0x140fe200078e0203ULL,
0x0000000c03147811ULL, 0x040fe200078fe8ffULL, 0x0000000810327824ULL, 0x000fe200078e00ffULL,
0x00000018031a7811ULL, 0x040fe200078fe8ffULL, 0x000000010e0d7824ULL, 0x140fe200078e0203ULL,
0x0000001403187811ULL, 0x040fe200078fe8ffULL, 0x000000080e287824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee20fULL, 0x00000001160f7824ULL, 0x140fe200078e0203ULL,
0x00000020031e7811ULL, 0x040fe200078fe8ffULL, 0x0000000816387824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20dULL, 0x00000001140d7824ULL, 0x140fe200078e0203ULL,
0x0000001c031c7811ULL, 0x040fe200078fe8ffULL, 0x0000000814367824ULL, 0x000fe200078e00ffULL,
0x0000002803227811ULL, 0x040fe200078fe8ffULL, 0x000000011a137824ULL, 0x140fe200078e0203ULL,
0xfffffff838387812ULL, 0x000fe200078ee20fULL, 0x000000081a3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee20dULL, 0x0000000118117824ULL, 0x140fe200078e0203ULL,
0x0000002403207811ULL, 0x040fe200078fe8ffULL, 0x00000008183c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x000000011e0f7824ULL, 0x140fe200078e0203ULL,
0x0000003003307811ULL, 0x040fe200078fe8ffULL, 0x000000081e427824ULL, 0x000fe200078e00ffULL,
0x0000002c03247811ULL, 0x040fe200078fe8ffULL, 0x000000011c0d7824ULL, 0x140fe200078e0203ULL,
0x00000038032c7811ULL, 0x040fe200078fe8ffULL, 0x000000081c407824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x0000000122137824ULL, 0x140fe200078e0203ULL,
0xfffffff842427812ULL, 0x000fe200078ee20fULL, 0x0000000822467824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee20dULL, 0x0000000120117824ULL, 0x140fe200078e0203ULL,
0x00000034032e7811ULL, 0x040fe200078fe8ffULL, 0x0000000820447824ULL, 0x000fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee213ULL, 0x00000001300f7824ULL, 0x140fe200078e0203ULL,
0x0000003c032a7811ULL, 0x000fe200078fe8ffULL, 0x00000008304c7824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee211ULL, 0x00000001240d7824ULL, 0x140fe200078e0203ULL,
0x000000704d4d7812ULL, 0x000fe200078ec0ffULL, 0x00000008244a7824ULL, 0x000fe200078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee20fULL, 0x000000012c137824ULL, 0x000fc400078e0203ULL,
0x000000082c507824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee20dULL,
0x000000012e117824ULL, 0x140fe200078e0203ULL, 0x00000003030d7211ULL, 0x000fe200078fe8ffULL,
0x000000082e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee213ULL,
0x000000012a0f7824ULL, 0x040fe200078e0203ULL, 0x000000083d137c11ULL, 0x000fe2000f8e70ffULL,
0x000000082a527824ULL, 0x000fe200078e00ffULL, 0x000000070d267812ULL, 0x000fe200078ec0ffULL,
0x000000010e0e7824ULL, 0x100fe200078e020cULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee211ULL,
0x0000000110107824ULL, 0x100fe200078e020cULL, 0xfffffff852527812ULL, 0x000fe200078ee20fULL,
0x0000000114147824ULL, 0x100fe200078e020cULL, 0x0ffffff826267812ULL, 0x000fe200078ef803ULL,
0x0000000116167824ULL, 0x000fc400078e020cULL, 0x0000000118187824ULL, 0x100fe400078e020cULL,
0x000000011a1a7824ULL, 0x100fe400078e020cULL, 0x000000011c1c7824ULL, 0x100fe400078e020cULL,
0x000000011e1e7824ULL, 0x100fe400078e020cULL, 0x0000000120207824ULL, 0x100fe400078e020cULL,
0x0000000122227824ULL, 0x000fc400078e020cULL, 0x0000000124247824ULL, 0x100fe400078e020cULL,
0x0000000130307824ULL, 0x100fe400078e020cULL, 0x000000012e2e7824ULL, 0x100fe400078e020cULL,
0x000000012c2c7824ULL, 0x100fe400078e020cULL, 0x000000012a2a7824ULL, 0x000fe200078e020cULL,
0x0000000c030c7211ULL, 0x000fe200078fe8ffULL, 0x00002000340f7824ULL, 0x000fc400078e0213ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000004d10107212ULL, 0x000fc600078efcffULL, 0x000010000f157836ULL, 0x000fe20000000000ULL,
0x0000004d0c0c7212ULL, 0x000fe200078efcffULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0x0000000a0c0c7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010264b7824ULL, 0x100fe200078e0215ULL,
0x0000004d18187212ULL, 0x000fe200078efcffULL, 0x0000001028477824ULL, 0x100fe200078e0215ULL,
0x0000000b0d0d7c10ULL, 0x000fe200087fe4ffULL, 0x0000001032457824ULL, 0x100fe200078e0215ULL,
0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001036437824ULL, 0x100fe400078e0215ULL,
0x0000001038417824ULL, 0x100fe200078e0215ULL, 0x0000000b11117c10ULL, 0x000fe200087fe4ffULL,
0x000000103c377824ULL, 0x100fe200078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c4b7faeULL, 0x0003e2000b901c46ULL, 0x000000103e357824ULL, 0x000fc400078e0215ULL,
0x0000001040337824ULL, 0x100fe400078e0215ULL, 0x0000001042317824ULL, 0x100fe400078e0215ULL,
0x00000010442f7824ULL, 0x100fe400078e0215ULL, 0x00000010462d7824ULL, 0x100fe400078e0215ULL,
0x000000104a2b7824ULL, 0x100fe400078e0215ULL, 0x000000104c297824ULL, 0x000fc400078e0215ULL,
0x000000104e287824ULL, 0x100fe400078e0215ULL, 0x0000001050277824ULL, 0x100fe400078e0215ULL,
0x0000001052267824ULL, 0x000fe400078e0215ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000004d14147212ULL, 0x000fc600078efcffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000a14147c10ULL, 0x000fe4000ff1e0ffULL,
0x0000004d1c1c7212ULL, 0x080fe200078efcffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000b15157c10ULL, 0x000fe400087fe4ffULL, 0x0000000a18187c10ULL, 0x000fe2000ff1e0ffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000004d0e0e7212ULL, 0x000fe400078efcffULL,
0x0000000b19197c10ULL, 0x000fe200087fe4ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000a1c1c7c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000a0e0e7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000004d20207212ULL, 0x080fe400078efcffULL,
0x0000004d16167212ULL, 0x080fe200078efcffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000004d1a1a7212ULL, 0x000fe400078efcffULL, 0x0000000b1d1d7c10ULL, 0x000fe200087fe4ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000b0f0f7c10ULL, 0x000fc40008ffe4ffULL,
0x0000000a20207c10ULL, 0x000fe2000ff1e0ffULL, 0x00000080304e7825ULL, 0x000fe200078e00ffULL,
0x0000000a16167c10ULL, 0x000fe2000ff3e0ffULL, 0x000000000e477faeULL, 0x0003e2000b901c46ULL,
0x0000004d24247212ULL, 0x080fe200078efcffULL, 0x000000802e507825ULL, 0x000fe200078e00ffULL,
0x0000000a1a1a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000010457faeULL, 0x0003e2000b901c46ULL,
0x0000004d1e1e7212ULL, 0x080fe200078efcffULL, 0x000000802c527825ULL, 0x000fe200078e00ffULL,
0x0000004d22227212ULL, 0x000fe200078efcffULL, 0x0000000014437faeULL, 0x0003e2000b901c46ULL,
0x0000000b21217c10ULL, 0x000fe200087fe4ffULL, 0x000000802a547825ULL, 0x000fe200078e00ffULL,
0x0000000b17177c10ULL, 0x000fc40008ffe4ffULL, 0x0000000a24247c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000b1b1b7c10ULL, 0x000fe200097fe4ffULL, 0x0000000016417faeULL, 0x0003e2000b901c46ULL,
0x0000000a1e1e7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000004d4e4c7212ULL, 0x080fe200078efcffULL,
0x0000000018377faeULL, 0x0003e2000b901c46ULL, 0x0000000a22227c10ULL, 0x000fe4000ff5e0ffULL,
0x0000004d504e7212ULL, 0x080fe200078efcffULL, 0x000000001a357faeULL, 0x0003e2000b901c46ULL,
0x0000004d52507212ULL, 0x000fc400078efcffULL, 0x0000000b25257c10ULL, 0x000fe200087fe4ffULL,
0x000000001c337faeULL, 0x0003e2000b901c46ULL, 0x0000004d544d7212ULL, 0x000fe400078efcffULL,
0x0000000b1f1f7c10ULL, 0x000fe40008ffe4ffULL, 0x0000000a4c4c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000b23237c10ULL, 0x000fe200097fe4ffULL, 0x000000001e317faeULL, 0x0003e2000b901c46ULL,
0x0000000a4e4e7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000a50507c10ULL, 0x000fe2000ff5e0ffULL,
0x00000000202f7faeULL, 0x0003e2000b901c46ULL, 0x0000000a4d527c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000b4f4d7c10ULL, 0x000fe200087fe4ffULL, 0x00000000222d7faeULL, 0x0003e2000b901c46ULL,
0x0000000b514f7c10ULL, 0x000fe40008ffe4ffULL, 0x0000000b53517c10ULL, 0x000fe200097fe4ffULL,
0x00000000242b7faeULL, 0x0003e2000b901c46ULL, 0x0000000b55537c10ULL, 0x000fc60009ffe4ffULL,
0x000000004c297faeULL, 0x0003e8000b901c46ULL, 0x000000004e287faeULL, 0x0003e8000b901c46ULL,
0x0000000050277faeULL, 0x0003e8000b901c46ULL, 0x0000000052267faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003107836ULL, 0x002fe20000000000ULL,
0xfffffff8033c7812ULL, 0x040fe200078ec0ffULL, 0x0000200012377824ULL, 0x000fe200078e0213ULL,
0x0000000703387812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4b7224ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe400078ec0ffULL, 0x00000000000e7805ULL, 0x000fe4000001ff00ULL,
0x00000004ff367819ULL, 0x000fc40000011603ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000100037377836ULL, 0x000fe20000000000ULL, 0x000000073c3c7812ULL, 0x000fe200078ef803ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000008383e7812ULL, 0x000fe400078ef803ULL,
0x0000000710357812ULL, 0x000fce00078ef803ULL, 0x000000013c107824ULL, 0x140fe400078e024bULL,
0x000000083c117824ULL, 0x000fe400078e00ffULL, 0x000000103e137824ULL, 0x000fe400078e00ffULL,
0x0000000135127824ULL, 0x000fe200078e024bULL, 0xfffffff811107812ULL, 0x000fe200078ee210ULL,
0x000000024b117824ULL, 0x000fe400078e0236ULL, 0x0000000835417824ULL, 0x000fc400078e00ffULL,
0x0000001010147824ULL, 0x000fe200078e0237ULL, 0x000000023e507810ULL, 0x140fe20007ffe011ULL,
0x000000013e107824ULL, 0x040fe200078e0211ULL, 0xfffffff841407812ULL, 0x000fe200078ee212ULL,
0x000000014b117836ULL, 0x000fe40000000000ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0xfffffff013107812ULL, 0x000fe200078ee210ULL, 0x000000103e437824ULL, 0x000fe400078e00ffULL,
0x000000013c137824ULL, 0x100fe200078e0211ULL, 0x0000000810107c11ULL, 0x000fe2000f8e20ffULL,
0x0000000135427824ULL, 0x000fe200078e0211ULL, 0xfffffff043507812ULL, 0x000fe200078ee250ULL,
0x000000083c567824ULL, 0x000fc400078e00ffULL, 0x0000001040407824ULL, 0x000fe200078e0237ULL,
0xfffffff841427812ULL, 0x000fe200078ee242ULL, 0x000000024b4b7836ULL, 0x000fe20000000000ULL,
0xfffffff856567812ULL, 0x000fc600078ee213ULL, 0x0000001042427824ULL, 0x100fe200078e0237ULL,
0x000000084b00780cULL, 0x000fe20003f05270ULL, 0x0000001056557824ULL, 0x000fe200078e0237ULL,
0x00000018ff117819ULL, 0x102fe40000011614ULL, 0x000000ff14127812ULL, 0x000fe400078ec0ffULL,
0x00000011ff44723eULL, 0x000fe400020006ffULL, 0x00000012ff43723eULL, 0x000fe400020006ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x00000010ff417819ULL, 0x000fc40000011614ULL,
0x0000ffff144d7812ULL, 0x000fe200078ec0ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000018ff147819ULL, 0x000fe40000011615ULL, 0x00000010ff517819ULL, 0x100fe40000011617ULL,
0x00000018ff757819ULL, 0x000fe40000011617ULL, 0x000000ff17737812ULL, 0x040fe400078ec0ffULL,
0x0000ffff17547812ULL, 0x000fc400078ec0ffULL, 0x00000014ff17723eULL, 0x000fe400020006ffULL,
0x000000ff41417812ULL, 0x000fe400078ec0ffULL, 0x00000008ff147819ULL, 0x000fe2000001164dULL,
0x20000017ff4e7230ULL, 0x000fe20000004100ULL, 0x000000ff15457812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe400020006ffULL, 0x00000014ff14723eULL, 0x000fc400020006ffULL,
0x00000010ff4f7819ULL, 0x100fe20000011616ULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000018ff4a7819ULL, 0x000fe20000011616ULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x000000ff16527812ULL, 0x040fe400078ec0ffULL, 0x0000ffff16577812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x000fe40000011615ULL, 0x0000ffff15537812ULL, 0x000fe200078ec0ffULL,
0x20000044ff157230ULL, 0x000fe20000004100ULL, 0x00000045ff16723eULL, 0x000fc400020006ffULL,
0x00000008ff177819ULL, 0x000fe20000011653ULL, 0x000000004044783bULL, 0x0004e20000000200ULL,
0x000000ff4f4f7812ULL, 0x000fe200078ec0ffULL, 0x20000016ff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe40000011615ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff157819ULL, 0x000fe40000011614ULL, 0x00000010ff407819ULL, 0x004fc40000011643ULL,
0x00000017ff43723eULL, 0x000fe400020006ffULL, 0x0000004fff53723eULL, 0x000fe400020006ffULL,
0x0000105416417816ULL, 0x000fe20000000041ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x0000105415407816ULL, 0x000fe20000000040ULL, 0x20000053ff567230ULL, 0x000fe20000004100ULL,
0x00000008ff4f7819ULL, 0x000fe20000011657ULL, 0x000000005514783bULL, 0x000fe20000000200ULL,
0x000000ff4c4c7812ULL, 0x000fc400078ec0ffULL, 0x0000004fff53723eULL, 0x000fe200020006ffULL,
0x000000401030723cULL, 0x002fe20000041830ULL, 0x00000010ff4f7819ULL, 0x000fe4000001164eULL,
0x00000010ff4e7819ULL, 0x000fe20000011643ULL, 0x20000053ff537230ULL, 0x000fe20000004100ULL,
0x000000004240783bULL, 0x000e620000000200ULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x2000004cff4c7230ULL, 0x000fe20000004100ULL, 0x00000010ff4d7819ULL, 0x000fe2000001164dULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x000fe20000011653ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff4c7819ULL, 0x000fc4000001164cULL,
0x000010544e4e7816ULL, 0x000fe4000000004dULL, 0x000010544f4f7816ULL, 0x000fe4000000004cULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x00000010ff4c7819ULL, 0x000fe40000011652ULL,
0x00000010ff4d7819ULL, 0x000fe20000011656ULL, 0x0000004e102c723cULL, 0x000fe2000004182cULL,
0x00001054534c7816ULL, 0x000fc4000000004cULL, 0x000010544a4d7816ULL, 0x000fe4000000004dULL,
0x00000018ff6b7819ULL, 0x008fe40000011647ULL, 0x000000ff47667812ULL, 0x000fe400078ec0ffULL,
0x0000ffff465e7812ULL, 0x000fe200078ec0ffULL, 0x0000004c1028723cULL, 0x000fe20000041828ULL,
0x00000010ff657819ULL, 0x000fe40000011644ULL, 0x00000018ff6e7819ULL, 0x000fc40000011646ULL,
0x000000ff44707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff537819ULL, 0x102fe40000011641ULL, 0x00000018ff4d7819ULL, 0x000fe40000011641ULL,
0x000000ff41787812ULL, 0x040fe400078ec0ffULL, 0x0000ffff416a7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff697819ULL, 0x100fe40000011642ULL, 0x00000018ff777819ULL, 0x000fe40000011642ULL,
0x000000ff42417812ULL, 0x040fe400078ec0ffULL, 0x0000ffff42607812ULL, 0x000fe400078ec0ffULL,
0x0000006bff42723eULL, 0x000fe400020006ffULL, 0x00000010ff727819ULL, 0x000fc40000011640ULL,
0x00000018ff4c7819ULL, 0x000fe40000011640ULL, 0x000000ff40797812ULL, 0x040fe400078ec0ffULL,
0x0000ffff40527812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5b7819ULL, 0x100fe40000011643ULL,
0x00000018ff5f7819ULL, 0x000fe40000011643ULL, 0x000000ff43407812ULL, 0x000fc400078ec0ffULL,
0x0000ffff43567812ULL, 0x000fe400078ec0ffULL, 0x00000066ff43723eULL, 0x000fe200020006ffULL,
0x20000042ff667230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fe40000011647ULL,
0x000000ff65427812ULL, 0x000fe200078ec0ffULL, 0x20000043ff657230ULL, 0x000fe20000004100ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x000000ff456f7812ULL, 0x000fc400078ec0ffULL,
0x00000070ff70723eULL, 0x000fe200020006ffULL, 0x2000006eff6b7230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000018ff717819ULL, 0x000fe40000011644ULL,
0x0000ffff446d7812ULL, 0x000fe200078ec0ffULL, 0x2000005eff6e7230ULL, 0x000fe20000004100ULL,
0x0000ffff154f7812ULL, 0x000fe400078ec0ffULL, 0x00000042ff42723eULL, 0x000fc400020006ffULL,
0x000000ff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff687819ULL, 0x100fe40000011645ULL,
0x00000018ff557819ULL, 0x000fe40000011645ULL, 0x0000ffff45647812ULL, 0x000fe400078ec0ffULL,
0x00000010ff637819ULL, 0x000fe40000011646ULL, 0x000000ff466c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff5a7819ULL, 0x100fe40000011614ULL, 0x00000018ff677819ULL, 0x000fe40000011614ULL,
0x000000ff14627812ULL, 0x040fe400078ec0ffULL, 0x0000ffff14597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff447819ULL, 0x100fe40000011615ULL, 0x00000018ff617819ULL, 0x000fc40000011615ULL,
0x000000ff15587812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x000fe40000011616ULL,
0x00000010ff157819ULL, 0x100fe40000011617ULL, 0x00000018ff467819ULL, 0x000fe40000011617ULL,
0x000000ff17457812ULL, 0x040fe400078ec0ffULL, 0x0000ffff17147812ULL, 0x000fc400078ec0ffULL,
0x000000ff51517812ULL, 0x000fe400078ec0ffULL, 0x00000008ff547819ULL, 0x000fe40000011654ULL,
0x0000006fff17723eULL, 0x000fe200020006ffULL, 0x20000070ff6f7230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x20000042ff707230ULL, 0x000fe20000004100ULL,
0x00000008ff4f7819ULL, 0x000fe2000001164fULL, 0x20000017ff177230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x0000005fff5e723eULL, 0x000fe400020006ffULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000075ff75723eULL, 0x000fe400020006ffULL, 0x00000051ff51723eULL, 0x000fe400020006ffULL,
0x00000054ff54723eULL, 0x000fe200020006ffULL, 0x20000075ff757230ULL, 0x000fe20000004100ULL,
0x00000067ff42723eULL, 0x000fe200020006ffULL, 0x2000005cff677230ULL, 0x000fe20000004100ULL,
0x000000ff4e4e7812ULL, 0x000fe200078ec0ffULL, 0x20000051ff767230ULL, 0x000fe20000004100ULL,
0x00000040ff5f723eULL, 0x000fe200020006ffULL, 0x2000005eff407230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fe200020006ffULL, 0x20000054ff747230ULL, 0x000fe20000004100ULL,
0x0000004fff4f723eULL, 0x000fc400020006ffULL, 0x00000008ff647819ULL, 0x000fe40000011664ULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000061ff5c723eULL, 0x000fe200020006ffULL,
0x20000042ff617230ULL, 0x000fe20000004100ULL, 0x0000004eff4e723eULL, 0x000fe400020006ffULL,
0x00000008ff147819ULL, 0x000fe20000011614ULL, 0x2000005cff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff445e7812ULL, 0x000fe200078ec0ffULL, 0x2000005fff447230ULL, 0x000fe20000004100ULL,
0x000000ff15157812ULL, 0x000fe200078ec0ffULL, 0x2000004fff5f7230ULL, 0x000fe20000004100ULL,
0x0000004cff42723eULL, 0x000fe200020006ffULL, 0x20000046ff4c7230ULL, 0x000fe20000004100ULL,
0x00000064ff54723eULL, 0x000fe200020006ffULL, 0x20000059ff647230ULL, 0x000fe20000004100ULL,
0x00000077ff46723eULL, 0x000fe200020006ffULL, 0x2000004eff597230ULL, 0x000fe20000004100ULL,
0x00000014ff4f723eULL, 0x000fe200020006ffULL, 0x20000054ff547230ULL, 0x000fe20000004100ULL,
0x000000ff68687812ULL, 0x000fe200078ec0ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x00000015ff77723eULL, 0x000fc400020006ffULL, 0x00000010ff147819ULL, 0x000fe40000011673ULL,
0x0000ffff475d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4e7819ULL, 0x000fe40000011675ULL,
0x00000010ff157819ULL, 0x000fe40000011676ULL, 0x00000010ff737819ULL, 0x000fe40000011674ULL,
0x00000018ff577819ULL, 0x000fc40000011616ULL, 0x000000ff164a7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff16477812ULL, 0x000fe400078ec0ffULL, 0x00000055ff16723eULL, 0x000fe400020006ffULL,
0x00000068ff51723eULL, 0x000fe400020006ffULL, 0x000010544e157816ULL, 0x000fe20000000015ULL,
0x20000016ff167230ULL, 0x000fe20000004100ULL, 0x0000105473147816ULL, 0x000fe20000000014ULL,
0x20000051ff517230ULL, 0x000fe20000004100ULL, 0x00000008ff6d7819ULL, 0x000fe2000001166dULL,
0x2000004fff4e7230ULL, 0x000fe20000004100ULL, 0x00000071ff71723eULL, 0x000fc400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x000000141024723cULL, 0x000fe20000041824ULL,
0x000000ff72727812ULL, 0x000fe200078ec0ffULL, 0x20000071ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe20000011616ULL, 0x2000006dff717230ULL, 0x000fe20000004100ULL,
0x00000010ff177819ULL, 0x000fe40000011617ULL, 0x0000000850147c11ULL, 0x000fe4000f8e20ffULL,
0x00000010ff517819ULL, 0x000fc40000011651ULL, 0x00000010ff507819ULL, 0x000fe40000011654ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000105416517816ULL, 0x000fe40000000051ULL,
0x0000105450507816ULL, 0x000fe20000000017ULL, 0x20000072ff4f7230ULL, 0x000fe20000004100ULL,
0x000000001414783bULL, 0x000e620000000200ULL, 0x000000ff63637812ULL, 0x000fe400078ec0ffULL,
0x00000008ff737819ULL, 0x000fc40000011652ULL, 0x000000ff53747812ULL, 0x000fe200078ec0ffULL,
0x00000050101c723cULL, 0x000fe2000004181cULL, 0x00000010ff727819ULL, 0x000fe40000011655ULL,
0x00000010ff527819ULL, 0x000fe4000001166fULL, 0x00000010ff537819ULL, 0x000fe40000011670ULL,
0x00000010ff717819ULL, 0x000fe40000011671ULL, 0x00000063ff63723eULL, 0x000fc400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x00000008ff5d7819ULL, 0x000fe2000001165dULL,
0x20000063ff6d7230ULL, 0x000fe20000004100ULL, 0x0000105472537816ULL, 0x000fe20000000053ULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000105471527816ULL, 0x000fe40000000052ULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff6f7819ULL, 0x000fe2000001166aULL, 0x000000521020723cULL, 0x000fe20000041820ULL,
0x2000005dff687230ULL, 0x000fe20000004100ULL, 0x000000ff69707812ULL, 0x000fe400078ec0ffULL,
0x00000010ff6a7819ULL, 0x000fe4000001166bULL, 0x00000010ff697819ULL, 0x000fe4000001166eULL,
0x00000010ff537819ULL, 0x000fe4000001166dULL, 0x00000010ff527819ULL, 0x000fc4000001166cULL,
0x00000062ff62723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x000010546a537816ULL, 0x000fe20000000053ULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff517819ULL, 0x000fe20000011667ULL, 0x2000005aff637230ULL, 0x000fe20000004100ULL,
0x0000105469527816ULL, 0x000fe40000000052ULL, 0x00000010ff6a7819ULL, 0x000fc40000011666ULL,
0x00000010ff507819ULL, 0x000fe40000011665ULL, 0x00000010ff677819ULL, 0x000fe20000011668ULL,
0x000000521018723cULL, 0x000fe20000041818ULL, 0x000010546a517816ULL, 0x000fe40000000051ULL,
0x0000105467507816ULL, 0x000fe40000000050ULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fc400020006ffULL, 0x00000008ff477819ULL, 0x000fe20000011647ULL,
0x20000058ff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe20000011661ULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000010ff627819ULL, 0x000fe20000011662ULL,
0x00000050100c723cULL, 0x000fe2000004180cULL, 0x00000010ff637819ULL, 0x000fe40000011663ULL,
0x00000010ff537819ULL, 0x000fe40000011664ULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x0000004aff4a723eULL, 0x000fe400020006ffULL, 0x00000047ff47723eULL, 0x000fe200020006ffULL,
0x20000057ff577230ULL, 0x000fe20000004100ULL, 0x0000105452137816ULL, 0x000fe20000000063ULL,
0x2000004aff587230ULL, 0x000fe20000004100ULL, 0x0000105453127816ULL, 0x000fe20000000062ULL,
0x20000047ff5a7230ULL, 0x000fe20000004100ULL, 0x00000045ff45723eULL, 0x000fe200020006ffULL,
0x20000077ff477230ULL, 0x000fe20000004100ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x00000010ff107819ULL, 0x000fe2000001165dULL, 0x20000045ff4a7230ULL, 0x000fe20000004100ULL,
0x00000010ff117819ULL, 0x000fe2000001165eULL, 0x000000121430723cULL, 0x002fe20000041830ULL,
0x00000010ff5f7819ULL, 0x000fe4000001165fULL, 0x00000008ff607819ULL, 0x000fe40000011660ULL,
0x000010545c117816ULL, 0x000fe40000000011ULL, 0x000010545f107816ULL, 0x000fc40000000010ULL,
0x0000004dff45723eULL, 0x000fe200020006ffULL, 0x20000042ff4d7230ULL, 0x000fe20000004100ULL,
0x000000ff5b5b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff527819ULL, 0x000fe20000011657ULL,
0x00000010142c723cULL, 0x000fe2000004182cULL, 0x00000010ff127819ULL, 0x000fe20000011658ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x00000010ff137819ULL, 0x000fe40000011659ULL,
0x00000010ff537819ULL, 0x000fc4000001165aULL, 0x00000008ff567819ULL, 0x000fe40000011656ULL,
0x00000078ff42723eULL, 0x000fe400020006ffULL, 0x00000079ff43723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x0000006fff6f723eULL, 0x000fe200020006ffULL, 0x20000060ff507230ULL, 0x000fe20000004100ULL,
0x0000005bff51723eULL, 0x000fe200020006ffULL, 0x20000073ff547230ULL, 0x000fe20000004100ULL,
0x0000105452137816ULL, 0x000fe20000000013ULL, 0x2000006fff667230ULL, 0x000fe20000004100ULL,
0x0000105453127816ULL, 0x000fe20000000012ULL, 0x20000051ff517230ULL, 0x000fe20000004100ULL,
0x00000074ff55723eULL, 0x000fc400020006ffULL, 0x00000070ff70723eULL, 0x000fe400020006ffULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff4c7819ULL, 0x000fe2000001164cULL, 0x20000070ff657230ULL, 0x000fe20000004100ULL,
0x00000010ff477819ULL, 0x000fe20000011647ULL, 0x20000056ff567230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe2000001164aULL, 0x000000121428723cULL, 0x000fe20000041828ULL,
0x00000010ff117819ULL, 0x000fc4000001164eULL, 0x00000010ff107819ULL, 0x000fe4000001164dULL,
0x00000010ff4f7819ULL, 0x000fe4000001164fULL, 0x000010544c4d7816ULL, 0x000fe40000000047ULL,
0x00001054114c7816ULL, 0x000fe4000000004aULL, 0x0000105410117816ULL, 0x000fe4000000004fULL,
0x00000010ff127819ULL, 0x000fc40000011642ULL, 0x00000010ff107819ULL, 0x000fe20000011643ULL,
0x0000004c1424723cULL, 0x000fe20000041824ULL, 0x00000010ff417819ULL, 0x000fe40000011641ULL,
0x00000010ff427819ULL, 0x000fe40000011650ULL, 0x00000010ff4a7819ULL, 0x000fe40000011645ULL,
0x00000010ff137819ULL, 0x000fe40000011654ULL, 0x00000010ff437819ULL, 0x000fc40000011666ULL,
0x00000010ff407819ULL, 0x000fe40000011640ULL, 0x00000010ff517819ULL, 0x000fe40000011651ULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff447819ULL, 0x000fc40000011644ULL,
0x00000010ff457819ULL, 0x000fe40000011656ULL, 0x0000105442427816ULL, 0x000fe40000000041ULL,
0x0000105413107816ULL, 0x000fe40000000010ULL, 0x0000105443127816ULL, 0x000fe40000000012ULL,
0x0000105440417816ULL, 0x000fe40000000051ULL, 0x000010544a137816ULL, 0x000fe20000000055ULL,
0x000000101420723cULL, 0x000fe20000041820ULL, 0x0000105446437816ULL, 0x000fc40000000065ULL,
0x0000105445407816ULL, 0x000fc60000000044ULL, 0x00000012141c723cULL, 0x000fec000004181cULL,
0x000000421418723cULL, 0x000fec0000041818ULL, 0x00000040140c723cULL, 0x000fe2000004180cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffffe800340947ULL, 0x000fde000383ffffULL,
0x00000001ff117424ULL, 0x000fe400078e00ffULL, 0x0000000530357220ULL, 0x080fe20000410000ULL,
0x000000051c307220ULL, 0x080fe20000410000ULL, 0x0000000519377220ULL, 0x080fe20000410000ULL,
0x0000000531317220ULL, 0x080fe20000410000ULL, 0x0000000532327220ULL, 0x080fe20000410000ULL,
0x01768811061079a7ULL, 0x000e62000850003fULL, 0x0000000533337220ULL, 0x080fe20000410000ULL,
0x000000052c2c7220ULL, 0x080fe20000410000ULL, 0x000000052d2d7220ULL, 0x080fe20000410000ULL,
0x000000052e2e7220ULL, 0x080fe20000410000ULL, 0x000000052f2f7220ULL, 0x080fe20000410000ULL,
0x0000000528287220ULL, 0x080fe20000410000ULL, 0x0000000529297220ULL, 0x080fe20000410000ULL,
0x000000052a2a7220ULL, 0x080fe20000410000ULL, 0x000000052b2b7220ULL, 0x080fe20000410000ULL,
0x0000000524247220ULL, 0x080fe20000410000ULL, 0x0000000525257220ULL, 0x080fe20000410000ULL,
0x0000000526267220ULL, 0x080fe20000410000ULL, 0x0000000527277220ULL, 0x080fe20000410000ULL,
0x0000000520207220ULL, 0x080fe20000410000ULL, 0x0000000521217220ULL, 0x080fe20000410000ULL,
0x0000000522227220ULL, 0x080fe20000410000ULL, 0x0000000523237220ULL, 0x080fe20000410000ULL,
0x000000051d1d7220ULL, 0x080fe20000410000ULL, 0x000000051e1e7220ULL, 0x080fe20000410000ULL,
0x000000051f1f7220ULL, 0x080fe20000410000ULL, 0x0000000518367220ULL, 0x080fe20000410000ULL,
0x000000051a1a7220ULL, 0x080fe20000410000ULL, 0x000000051b1b7220ULL, 0x080fe20000410000ULL,
0x000000050c3c7220ULL, 0x080fe20000410000ULL, 0x000000050d3e7220ULL, 0x080fe20000410000ULL,
0x000000050e197220ULL, 0x080fe20000410000ULL, 0x000000050f1c7220ULL, 0x000fe20000410000ULL,
0x00000000000c7805ULL, 0x000fe20000015200ULL, 0x01768811060075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff127224ULL, 0x000fce00078e00ffULL,
0x000000101200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000130e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000112127836ULL, 0x000fce0000000000ULL,
0x01768811060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004030c7824ULL, 0x000fe200078e00ffULL, 0x000000083d0d7c11ULL, 0x000fe4000f8e38ffULL,
0x000000020b00720cULL, 0x000fe40003f06070ULL, 0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL,
0x000000010d187824ULL, 0x000fca00078e020cULL, 0x01740000180c7984ULL, 0x0002a20000000c00ULL,
0x0000001400248947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000000400127d06ULL, 0x000ee20008209000ULL,
0xffffff000a0a7836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bf85070ULL,
0x0000000203407824ULL, 0x000fe200078e00ffULL, 0x00000004ff427c12ULL, 0x000fe4000f8e33ffULL,
0x0000000a3b417248ULL, 0x000fe40007fe0000ULL, 0x0000000640407812ULL, 0x000fc600078ec0ffULL,
0x0000000141417824ULL, 0x000fe200078e0a0aULL, 0x0000001200127308ULL, 0x008ee60000001000ULL,
0x000000ffff5a7224ULL, 0x000fe200078e0a41ULL, 0x0000001040437812ULL, 0x040fe200078efcffULL,
0x00000001400a7824ULL, 0x000fe400078e0200ULL, 0x0ffffffe12147836ULL, 0x008fc60000000000ULL,
0x0000005a0a577246ULL, 0x000fe20003800007ULL, 0x0000001400117305ULL, 0x000ee4000021f000ULL,
0x000000ffff137224ULL, 0x008fc800078e0a11ULL, 0x0000000413137c24ULL, 0x000fc8000f8e02ffULL,
0x0000001311157227ULL, 0x000fe200078e0010ULL, 0x0000003a03107211ULL, 0x000fca00078ff0ffULL,
0x0000001015117227ULL, 0x000fc800078e00ffULL, 0x000000ffff137224ULL, 0x000fc800078e0a11ULL,
0x0000000413127c24ULL, 0x000fe4000f8e0210ULL, 0x0000000810107836ULL, 0x000fc60000000000ULL,
0x0000000412007c0cULL, 0x000fe2000bf06070ULL, 0x0000001015137227ULL, 0x000fc800078e00ffULL,
0x000000ffff157224ULL, 0x000fc800078e0a13ULL, 0x0000000415147c24ULL, 0x000fc8000f8e0210ULL,
0x8000000412120c36ULL, 0x000fe20008000000ULL, 0x0000000414007c0cULL, 0x000fe2000bf46070ULL,
0x0000000111110836ULL, 0x000fc60000000000ULL, 0x0000000412007c0cULL, 0x000fe2000bf26070ULL,
0x0000000108127824ULL, 0x000fca00078e0240ULL, 0x000000411200720cULL, 0x000fe40003f66070ULL,
0x0000005a12127246ULL, 0x000fe20003800007ULL, 0x8000000414142c36ULL, 0x000fe40008000000ULL,
0x0000000113132836ULL, 0x000fe20000000000ULL, 0x00000004ff127819ULL, 0x000fe20000011612ULL,
0x0000000111111836ULL, 0x000fe20000000000ULL, 0x0000000414007c0cULL, 0x000fe4000bf06070ULL,
0x000000ff12127207ULL, 0x000fc40001800000ULL, 0x0000001142107207ULL, 0x000fe20006000000ULL,
0x0000000143447824ULL, 0x000fe200078e0200ULL, 0x000000410a00720cULL, 0x000fe40003f26070ULL,
0x0000001007107248ULL, 0x000fe40003fe0000ULL, 0x000000ff57577207ULL, 0x000fc60000800000ULL,
0x00000005105b7c24ULL, 0x000fe4000f8e02ffULL, 0x0000000113130836ULL, 0x000fe40000000000ULL,
0x000000015b157824ULL, 0x000fe200078e0212ULL, 0x0000005b57177211ULL, 0x000fe400078fe0ffULL,
0x0000001342107207ULL, 0x000fe20006000000ULL, 0x0000000215147825ULL, 0x100fe200078e0048ULL,
0x000000414400720cULL, 0x000fe40003f06070ULL, 0x0000002040477812ULL, 0x000fe200078efcffULL,
0x0000000217167825ULL, 0x000fe200078e0048ULL, 0x0000000614587981ULL, 0x000722000c1e9500ULL,
0x0000001007107248ULL, 0x000fc40003fe0000ULL, 0x0000005a44427246ULL, 0x000fe20003800007ULL,
0x00000001084c7824ULL, 0x000fe200078e0247ULL, 0x0000000616597981ULL, 0x000b22000c1e9500ULL,
0x00000005105c7c24ULL, 0x000fe4000f8e02ffULL, 0x0000000108147824ULL, 0x008fe200078e0243ULL,
0x000000ff42427207ULL, 0x000fe20000000000ULL, 0x0000000112137824ULL, 0x000fe200078e025cULL,
0x0000005c57117211ULL, 0x000fe400078fe0ffULL, 0x0000005a14157246ULL, 0x000fe20003800007ULL,
0x0000000213127825ULL, 0x000fe200078e0048ULL, 0x000000411400720cULL, 0x000fc40003f26070ULL,
0x00000004ff157819ULL, 0x000fe20000011615ULL, 0x0000000211107825ULL, 0x000fe200078e0048ULL,
0x0000000612537981ULL, 0x0044e4000c1e9500ULL, 0x000000ff154a7207ULL, 0x000fe40000800000ULL,
0x0000005b42157211ULL, 0x000fe200078fe0ffULL, 0x0000000610567981ULL, 0x0004e2000c1e9500ULL,
0x000000414c00720cULL, 0x000fe20003f26070ULL, 0x000000015b177824ULL, 0x022fe400078e024aULL,
0x0000000215147825ULL, 0x000fe200078e0048ULL, 0x0000005a4c4c7246ULL, 0x000fc40003800007ULL,
0x0000005c42137211ULL, 0x004fe200078fe0ffULL, 0x0000000217167825ULL, 0x000fe200078e0048ULL,
0x0000000614467981ULL, 0x0002a6000c1e9500ULL, 0x000000014a117824ULL, 0x000fe200078e025cULL,
0x0000000616457981ULL, 0x000ea6000c1e9500ULL, 0x0000000211107825ULL, 0x000fe200078e0048ULL,
0x00000004ff147819ULL, 0x002fc6000001164cULL, 0x00000001474a7824ULL, 0x000fe200078e0200ULL,
0x00000006104b7981ULL, 0x000362000c1e9500ULL, 0x000000ff144f7207ULL, 0x000fca0000800000ULL,
0x000000015b157824ULL, 0x000fe400078e024fULL, 0x000000014f117824ULL, 0x002fe200078e025cULL,
0x00000030404f7812ULL, 0x000fe200078efcffULL, 0x0000000213127825ULL, 0x000fe200078e0048ULL,
0x000000414a00720cULL, 0x000fe40003f06070ULL, 0x0000005a4a4c7246ULL, 0x000fe20003800007ULL,
0x00000001085e7824ULL, 0x000fe200078e024fULL, 0x00000006124e7981ULL, 0x000362000c1e9500ULL,
0x0000000215147825ULL, 0x000fe200078e0048ULL, 0x000000ff4c4c7207ULL, 0x000fc40000000000ULL,
0x0000005a5e557246ULL, 0x000fe20003800007ULL, 0x000000014f527824ULL, 0x000fe200078e0200ULL,
0x0000005b4c177211ULL, 0x000fe200078fe0ffULL, 0x00000006144d7981ULL, 0x000362000c1e9500ULL,
0x000000415e00720cULL, 0x080fe40003f26070ULL, 0x0000005c4c137211ULL, 0x002fe200078fe0ffULL,
0x0000000217167825ULL, 0x000fe200078e0048ULL, 0x000000415200720cULL, 0x000fe40003f06070ULL,
0x00000004ff147819ULL, 0x000fe20000011655ULL, 0x0000000211107825ULL, 0x100fe200078e0048ULL,
0x0000005a52557246ULL, 0x000fe20003800007ULL, 0x0000000616507981ULL, 0x000f62000c1e9500ULL,
0x000000ff14147207ULL, 0x000fe20000800000ULL, 0x0000000213127825ULL, 0x000fe200078e0048ULL,
0x000000ff55557207ULL, 0x000fe20000000000ULL, 0x0000000610517981ULL, 0x000364000c1e9500ULL,
0x000000015b157824ULL, 0x000fc400078e0214ULL, 0x0000000612547981ULL, 0x000362000c1e9500ULL,
0x0000005b555b7211ULL, 0x000fe200078fe0ffULL, 0x0000000215107825ULL, 0x002fc800078e0048ULL,
0x000000025b127825ULL, 0x000fe400078e0048ULL, 0x0000000610107981ULL, 0x000362000c1e9500ULL,
0x0000005c55157211ULL, 0x000fc600078fe0ffULL, 0x0000000612137981ULL, 0x000362000c1e9500ULL,
0x0000000114177824ULL, 0x000fe400078e025cULL, 0x0000000215147825ULL, 0x000fc800078e0048ULL,
0x0000000217167825ULL, 0x000fe400078e0048ULL, 0x0000000614147981ULL, 0x000368000c1e9500ULL,
0x0000000616177981ULL, 0x000962000c1e9500ULL, 0xfffffff0575a7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff577424ULL, 0x000fc800078e00ffULL, 0x0000000141117824ULL, 0x002fc800078e025aULL,
0x000000010a627824ULL, 0x100fe200078e0a11ULL, 0x0000000840607812ULL, 0x040fe400078efcffULL,
0x00000009405e7812ULL, 0x000fe400078efcffULL, 0x0000006257627219ULL, 0x000fe200000006ffULL,
0x00000001605a7824ULL, 0x100fe400078e0200ULL, 0x000000015e127824ULL, 0x000fe400078e0200ULL,
0x000000015a647824ULL, 0x000fc400078e0a11ULL, 0x0000000112667824ULL, 0x000fe200078e0a11ULL,
0x0000001840747812ULL, 0x000fe400078efcffULL, 0x0000006457647219ULL, 0x040fe400000006ffULL,
0x0000006657667219ULL, 0x000fe400000006ffULL, 0xfffffff04c157812ULL, 0x000fe400078ec0ffULL,
0xfffffff055557812ULL, 0x000fe200078ec0ffULL, 0x00000001747a7824ULL, 0x000fe200078e0200ULL,
0x0000001140767812ULL, 0x000fc400078efcffULL, 0x0000001940727812ULL, 0x000fe200078efcffULL,
0x00000001415b7824ULL, 0x040fe400078e0215ULL, 0x0000000141637824ULL, 0x000fe400078e0255ULL,
0x00000001767c7824ULL, 0x100fe400078e0200ULL, 0x0000000172787824ULL, 0x000fe400078e0200ULL,
0x000000014a5d7824ULL, 0x000fe200078e0a5bULL, 0x00000021406a7812ULL, 0x000fc400078efcffULL,
0x0000002840687812ULL, 0x000fe400078efcffULL, 0x0000005d575d7219ULL, 0x040fe200000006ffULL,
0x000000016a707824ULL, 0x100fe400078e0200ULL, 0x00000001686e7824ULL, 0x000fe400078e0200ULL,
0x00000001705f7824ULL, 0x100fe400078e0a5bULL, 0x000000016e617824ULL, 0x000fe400078e0a5bULL,
0x0000000152657824ULL, 0x000fe200078e0a63ULL, 0x0000005f575f7219ULL, 0x000fc400000006ffULL,
0x0000006157617219ULL, 0x040fe400000006ffULL, 0x0000006557657219ULL, 0x000fe400000006ffULL,
0x0000541059597816ULL, 0x010fe40000000058ULL, 0x0000000140587812ULL, 0x000fe400078efcffULL,
0x0000005962ff7212ULL, 0x000fc6000780c0ffULL, 0x00000001585c7824ULL, 0x000fe200078e0200ULL,
0x000000410a00720cULL, 0x000fc60000701470ULL, 0x000000015c167824ULL, 0x000fe200078e0a11ULL,
0x000000414000720cULL, 0x000fe400007a1070ULL, 0xfffffff042117812ULL, 0x000fe400078ec0ffULL,
0xff80000035357808ULL, 0x000fe40002800000ULL, 0x0000541056537816ULL, 0x008fe20000000053ULL,
0x0000000141117824ULL, 0x000fc600078e0211ULL, 0x0000005362ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005364ff7212ULL, 0x080fe400078cc0ffULL, 0x0000005366ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000144157824ULL, 0x100fe200078e0a11ULL, 0x0000001657167219ULL, 0x000fe200000006ffULL,
0x000000017a557824ULL, 0x000fe200078e0a11ULL, 0x000000410a00720cULL, 0x080fe40001741470ULL,
0x000000415a00720cULL, 0x000fc400037c1470ULL, 0x000000411200720cULL, 0x000fe40002fa1470ULL,
0x0000005916ff7212ULL, 0x080fe4000782c0ffULL, 0x0000005964ff7212ULL, 0x080fe4000786c0ffULL,
0x0000005966ff7212ULL, 0x000fe2000788c0ffULL, 0x0000000178597824ULL, 0x100fe200078e0a11ULL,
0x0000005316ff7212ULL, 0x000fe2000780c0ffULL, 0x000000017c537824ULL, 0x000fe200078e0a11ULL,
0x000000414000720cULL, 0x000fc40001741070ULL, 0x000000416000720cULL, 0x080fe400037c1070ULL,
0x000000415e00720cULL, 0x000fe40002fa1070ULL, 0x0000001557117219ULL, 0x040fe400000006ffULL,
0x0000005557557219ULL, 0x000fe400000006ffULL, 0x0000541046467816ULL, 0x004fe40000000045ULL,
0x000054104e4e7816ULL, 0x020fc4000000004bULL, 0xff80000032327808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000004611ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004e11ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004e55ff7212ULL, 0x000fc400078ac0ffULL, 0x000000415c00720cULL, 0x0c0fe40000f21470ULL,
0x000000415c00720cULL, 0x080fe40000701470ULL, 0x000000415a00720cULL, 0x080fe40001f61470ULL,
0x000000411200720cULL, 0x080fe40002781470ULL, 0x000000414400720cULL, 0x0c0fe40001741470ULL,
0x000000414400720cULL, 0x000fc400037c1470ULL, 0x000000417a00720cULL, 0x080fe40002fa1470ULL,
0x0000002940667812ULL, 0x000fe400078efcffULL, 0x000000415800720cULL, 0x0c0fe40000f21070ULL,
0x000000415800720cULL, 0x080fe40000701070ULL, 0x000000416000720cULL, 0x080fe40001f61070ULL,
0x000000415e00720cULL, 0x000fc40002781070ULL, 0x000000414300720cULL, 0x0c0fe40001741070ULL,
0x000000414300720cULL, 0x080fe400037c1070ULL, 0x000000417400720cULL, 0x000fe40002fa1070ULL,
0x0000005357157219ULL, 0x040fe400000006ffULL, 0x0000005957597219ULL, 0x000fe400000006ffULL,
0x00005410504d7816ULL, 0x000fc4000000004dULL, 0x0000541054547816ULL, 0x000fe20000000051ULL,
0x00000001666c7824ULL, 0x000fe200078e0200ULL, 0xff80000031317808ULL, 0x000fe40000800000ULL,
0xff80000033337808ULL, 0x000fe40000000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40003000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x0000004615ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004655ff7212ULL, 0x080fe4000780c0ffULL,
0x0000004659ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004e15ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004e59ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004d5dff7212ULL, 0x040fe400078cc0ffULL,
0x000000545dff7212ULL, 0x000fe200078ac0ffULL, 0x000000016c5b7824ULL, 0x000fe200078e0a5bULL,
0x000000417c00720cULL, 0x0c0fe40000f21470ULL, 0x000000417c00720cULL, 0x080fe40002781470ULL,
0x000000417a00720cULL, 0x000fc40000701470ULL, 0x000000417800720cULL, 0x0c0fe40001f61470ULL,
0x000000417800720cULL, 0x080fe40001741470ULL, 0x000000414a00720cULL, 0x0c0fe400037c1470ULL,
0x000000414a00720cULL, 0x000fe40002fa1470ULL, 0x0000003140627812ULL, 0x040fe400078efcffULL,
0x0000003840567812ULL, 0x000fc400078efcffULL, 0x0000003940167812ULL, 0x000fe400078efcffULL,
0x000000417600720cULL, 0x0c0fe40000f21070ULL, 0x000000417600720cULL, 0x080fe40002781070ULL,
0x000000417400720cULL, 0x080fe40000701070ULL, 0x000000417200720cULL, 0x0c0fe40001f61070ULL,
0x000000417200720cULL, 0x000fc40001741070ULL, 0x000000414700720cULL, 0x0c0fe400037c1070ULL,
0x000000414700720cULL, 0x000fe40002fa1070ULL, 0x0000005b575b7219ULL, 0x000fe400000006ffULL,
0x0000541013107816ULL, 0x000fe20000000010ULL, 0x0000000162647824ULL, 0x100fe200078e0200ULL,
0xff80000029297808ULL, 0x000fe20000800000ULL, 0x0000000156427824ULL, 0x100fe200078e0200ULL,
0xff8000002b2b7808ULL, 0x000fe20002000000ULL, 0x00000001164c7824ULL, 0x000fe200078e0200ULL,
0xff80000024247808ULL, 0x000fc40000000000ULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fe40003000000ULL,
0xff80000022227808ULL, 0x000fe40002800000ULL, 0x0000004d5fff7212ULL, 0x080fe4000782c0ffULL,
0x0000004d61ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004d5bff7212ULL, 0x000fe4000780c0ffULL,
0x000000545fff7212ULL, 0x080fe4000786c0ffULL, 0x0000005461ff7212ULL, 0x080fe4000784c0ffULL,
0x000000545bff7212ULL, 0x000fe400078cc0ffULL, 0x0000001065ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000164677824ULL, 0x100fe200078e0a63ULL, 0x000000417000720cULL, 0x080fe20000f21470ULL,
0x0000000142697824ULL, 0x100fe200078e0a63ULL, 0x000000417000720cULL, 0x080fe20001f61470ULL,
0x000000014c637824ULL, 0x000fe200078e0a63ULL, 0x000000416e00720cULL, 0x000fc40002781470ULL,
0x000000416e00720cULL, 0x080fe40001741470ULL, 0x000000416c00720cULL, 0x0c0fe40000701470ULL,
0x000000416c00720cULL, 0x080fe400037c1470ULL, 0x000000415200720cULL, 0x080fe40002fa1470ULL,
0x000000416a00720cULL, 0x0c0fe40000f21070ULL, 0x000000416a00720cULL, 0x000fc40001f61070ULL,
0x000000416800720cULL, 0x0c0fe40002781070ULL, 0x000000416800720cULL, 0x080fe40001741070ULL,
0x000000416600720cULL, 0x0c0fe40000701070ULL, 0x000000416600720cULL, 0x080fe400037c1070ULL,
0x000000414f00720cULL, 0x000fe40002fa1070ULL, 0x0000006757677219ULL, 0x000fc400000006ffULL,
0x0000006957697219ULL, 0x040fe400000006ffULL, 0x0000006357637219ULL, 0x000fe400000006ffULL,
0x0000541014147816ULL, 0x000fe40000000017ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff80000030307808ULL, 0x000fc40002000000ULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000001d1d7808ULL, 0x000fe40000000000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40002800000ULL,
0x0000001067ff7212ULL, 0x080fe4000782c0ffULL, 0x0000001069ff7212ULL, 0x000fc4000786c0ffULL,
0x0000001063ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001465ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001467ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001469ff7212ULL, 0x080fe400078cc0ffULL,
0x0000001463ff7212ULL, 0x000fe400078ac0ffULL, 0x000000415200720cULL, 0x000fc40001741470ULL,
0x000000416400720cULL, 0x0c0fe40000f21470ULL, 0x000000416400720cULL, 0x080fe40000701470ULL,
0x000000414200720cULL, 0x0c0fe40001f61470ULL, 0x000000414200720cULL, 0x080fe400037c1470ULL,
0x000000414c00720cULL, 0x0c0fe40002781470ULL, 0x000000414c00720cULL, 0x000fc40002fa1470ULL,
0x000000414f00720cULL, 0x080fe40001741070ULL, 0x000000416200720cULL, 0x0c0fe40000f21070ULL,
0x000000416200720cULL, 0x080fe40000701070ULL, 0x000000415600720cULL, 0x0c0fe40001f61070ULL,
0x000000415600720cULL, 0x080fe400037c1070ULL, 0x000000411600720cULL, 0x000fc40002781070ULL,
0x000000411600720cULL, 0x000fe40002fa1070ULL, 0xff80000037377808ULL, 0x000fe40000800000ULL,
0xff8000003c3c7808ULL, 0x000fe40001800000ULL, 0xff8000003e3e7808ULL, 0x000fe40002000000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff8000001b1b7808ULL, 0x000fc40000000000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fce0002800000ULL,
0x000000350c00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x000000010b0b7836ULL, 0x000fe40000000000ULL, 0x0000000c350c7208ULL, 0x000fc80004000000ULL,
0x000000310c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c31117208ULL, 0x000fc80004000000ULL,
0x0000002c1100720bULL, 0x000fc80003f1e000ULL, 0x000000112c0a7208ULL, 0x000fc80004000000ULL,
0x0000002d0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a2d117208ULL, 0x000fc80004000000ULL,
0x000000281100720bULL, 0x000fc80003f1e000ULL, 0x00000011280a7208ULL, 0x000fc80004000000ULL,
0x000000290a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a29117208ULL, 0x000fc80004000000ULL,
0x000000241100720bULL, 0x000fc80003f1e000ULL, 0x00000011240a7208ULL, 0x000fc80004000000ULL,
0x000000250a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a25117208ULL, 0x000fc80004000000ULL,
0x000000201100720bULL, 0x000fc80003f1e000ULL, 0x00000011200a7208ULL, 0x000fc80004000000ULL,
0x000000210a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a21117208ULL, 0x000fc80004000000ULL,
0x000000301100720bULL, 0x000fc80003f1e000ULL, 0x00000011300a7208ULL, 0x000fe40004000000ULL,
0x000000320d00720bULL, 0x000fe40003f1e000ULL, 0x0000001d0a00720bULL, 0x000fc80003f3e000ULL,
0x0000000a1d117208ULL, 0x000fe40004800000ULL, 0x0000000d320a7208ULL, 0x000fe40004000000ULL,
0x000000361100720bULL, 0x000fe40003f3e000ULL, 0x000000330a00720bULL, 0x000fe40003f1e000ULL,
0x00000011360c7208ULL, 0x000fe40004800000ULL, 0x0000000a330d7208ULL, 0x000fc40004000000ULL,
0x000000370c00720bULL, 0x000fe40003f3e000ULL, 0x0000002e0d00720bULL, 0x000fe40003f1e000ULL,
0x0000000c37117208ULL, 0x000fe40004800000ULL, 0x0000000d2e0a7208ULL, 0x000fe40004000000ULL,
0x0000003c1100720bULL, 0x000fe40003f3e000ULL, 0x0000002f0a00720bULL, 0x000fc40003f1e000ULL,
0x000000113c117208ULL, 0x000fe40004800000ULL, 0x0000000a2f0d7208ULL, 0x000fe40004000000ULL,
0x0000003e1100720bULL, 0x000fe40003f3e000ULL, 0x0000002a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000113e117208ULL, 0x000fe40004800000ULL, 0x0000000d2a0a7208ULL, 0x000fc60004000000ULL,
0x0c401f00110c7f89ULL, 0x000ea200000e0000ULL, 0x0000002b0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a2b0d7208ULL, 0x000fc80004000000ULL, 0x000000260d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d260a7208ULL, 0x000fc80004000000ULL, 0x000000270a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a270d7208ULL, 0x000fe40004000000ULL, 0x0000000c1100720bULL, 0x004fe40003f3e000ULL,
0x000000220d00720bULL, 0x000fe40003f1e000ULL, 0x000000110c107208ULL, 0x000fe40004800000ULL,
0x0000000d220a7208ULL, 0x000fc60004000000ULL, 0x0c201f0010117f89ULL, 0x000ea200000e0000ULL,
0x000000230a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a230d7208ULL, 0x000fc80004000000ULL,
0x0000001e0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d1e0a7208ULL, 0x000fc80004000000ULL,
0x0000001f0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a1f0d7208ULL, 0x000fe40004000000ULL,
0x000000111000720bULL, 0x004fe40003f3e000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x00000010110c7208ULL, 0x000fe40004800000ULL, 0x0000000d1a0a7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b0c117820ULL, 0x000fe20000410000ULL, 0x0000001b0a00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010811ULL, 0x0000000a1b0a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010811ULL,
0x0000002400167308ULL, 0x0005e20000000800ULL, 0x000000190a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010811ULL, 0x0000000a190d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b25177823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010811ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x0000001c0d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b36247823ULL, 0x104fe20000010811ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b21257823ULL, 0x100fe20000010811ULL, 0x0000000d1c0d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010811ULL,
0x0000003100127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010811ULL,
0x0c401f000d0a7f89ULL, 0x000eac00000e0000ULL, 0x0000002c002c7308ULL, 0x000ff00000000800ULL,
0x0000002d00137308ULL, 0x0007f00000000800ULL, 0x0000002800147308ULL, 0x0009e20000000800ULL,
0x3fb8aa3b372d7823ULL, 0x108fe20000010811ULL, 0x0000000a0d00720bULL, 0x004fe20003f1e000ULL,
0x3fb8aa3b3e117823ULL, 0x000fc60000010811ULL, 0x0000000d0a0d7208ULL, 0x000fe40004000000ULL,
0x0000002900157308ULL, 0x0004e20000000800ULL, 0x00000004ff287e24ULL, 0x010fe4000f8e00ffULL,
0x0c201f000d107f89ULL, 0x000f2600000e0000ULL, 0x3f8000002828783eULL, 0x000fe400000010ffULL,
0x0000001100317308ULL, 0x000fe60000000800ULL, 0x000000ffff297224ULL, 0x004fe200078e0028ULL,
0x000000141514723eULL, 0x008fc800000010ffULL, 0x00000020000a7308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000100d00720bULL, 0x010fc80003f1e000ULL,
0x0000000d100d7208ULL, 0x000fc60004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000351210723eULL, 0x000fe400000010ffULL, 0x0000002c1312723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b0d367820ULL, 0x000fe20000410000ULL, 0x000000161716723eULL, 0x004fc600000010ffULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010836ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b23357823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010836ULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b19197823ULL, 0x000fce0000010836ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000323311723eULL, 0x004fce00000010ffULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x000000ffff327224ULL, 0x100fe400078e0028ULL,
0x000000ffff337224ULL, 0x000fca00078e0028ULL, 0x0000002200377308ULL, 0x0007e20000000800ULL,
0x0000002e2f13723eULL, 0x004fce00000010ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0028ULL, 0x000000281020723cULL, 0x008fec00000418ffULL,
0x0000002b002b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b1a297823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b1c367823ULL, 0x000fe20000010836ULL, 0x0c401f000f1a7f89ULL, 0x000eea00000e0000ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x0000002a2b15723eULL, 0x004fce00000010ffULL,
0x0000002700277308ULL, 0x000eb00000000800ULL, 0x0000001d001d7308ULL, 0x000f220000000800ULL,
0x000000262717723eULL, 0x004fce00000010ffULL, 0x0000001e002e7308ULL, 0x0009e20000000800ULL,
0x0c401f000e277f89ULL, 0x000ea200000e0000ULL, 0x0000001a0f00720bULL, 0x008fe20003f3e000ULL,
0x000000321420723cULL, 0x000fe60000041820ULL, 0x0000000f1a0f7208ULL, 0x000fe40004800000ULL,
0x0000001f001f7308ULL, 0x000ee20000000800ULL, 0x000000301d1e723eULL, 0x010fce00000010ffULL,
0x0000002500257308ULL, 0x000f220000000800ULL, 0x0000002e1f1f723eULL, 0x008fce00000010ffULL,
0x00000035002c7308ULL, 0x000ee20000000800ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0028ULL,
0x000000270e00720bULL, 0x004fc80003f1e000ULL, 0x0000000e270e7208ULL, 0x000fe40004000000ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0000000a251c723eULL, 0x010fe400000010ffULL,
0x00000003ff0a7819ULL, 0x000fe40000011603ULL, 0x000000372c1d723eULL, 0x008fc600000010ffULL,
0x0000003600367308ULL, 0x000ea20000000800ULL, 0x000000030a0a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2c7224ULL, 0x000fe400078e001cULL, 0x0000002e1c20723cULL, 0x000fe80000041820ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x000000193627723eULL, 0x004fce00000010ffULL,
0x0000001b002a7308ULL, 0x0004f00000000800ULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0xfffffff8ff1b7812ULL, 0x004fca00078ee238ULL, 0x000000081b197836ULL, 0x000fe20000000000ULL,
0x000000292a25723eULL, 0x008fe200000010ffULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x000000081b1a7824ULL, 0x000fe200078e00ffULL, 0x000000083d297c11ULL, 0x000fe2000f8e58ffULL,
0x000000010a2a7824ULL, 0x000fe400078e0219ULL, 0x00000008192f7824ULL, 0x040fe400078e00ffULL,
0x0000000819307824ULL, 0x000fe200078e00ffULL, 0x0000003c003c7308ULL, 0x000ee20000000800ULL,
0x0c201f000e197f89ULL, 0x000f2200000e0000ULL, 0xfffffff82f2a7812ULL, 0x000fc400078ee22aULL,
0x000000242d24723eULL, 0x004fe200000010ffULL, 0x000000081b2d7824ULL, 0x000fe400078e00ffULL,
0x000000010a1b7824ULL, 0x000fe400078e021bULL, 0x0c201f000f0a7f89ULL, 0x000ea200000e0000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0024ULL, 0x0000003c3126723eULL, 0x008fe200000010ffULL,
0x000000041b287836ULL, 0x000fe20000000000ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee21bULL,
0x0000000c1b2b7836ULL, 0x000fc40000000000ULL, 0x00011000291b7836ULL, 0x000fe20000000000ULL,
0xfffffff82d287812ULL, 0x000fe200078ee228ULL, 0x000000322420723cULL, 0x000fe20000041820ULL,
0xfffffff830307812ULL, 0x000fe200078ee22bULL, 0x000000101a1a7824ULL, 0x000fe200078e021bULL,
0x000000190e00720bULL, 0x010fe20003f1e000ULL, 0x000000ffff297224ULL, 0x000fe400078e0012ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0016ULL, 0x0000000e190e7208ULL, 0x000fe20004000000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e001eULL, 0x0000000303ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff2f7224ULL, 0x000fc400078e0026ULL, 0x000000ffff127224ULL, 0x000fe200078e0015ULL,
0x0000000a0f00720bULL, 0x004fe20003f3e000ULL, 0x0000001030307824ULL, 0x000fe400078e021bULL,
0x000000ffff157224ULL, 0x000fe200078e001fULL, 0x0000000f0a0f7208ULL, 0x000fe20004800000ULL,
0x000000ffff167224ULL, 0x000fe400078e0025ULL, 0x000000102a237824ULL, 0x100fe400078e021bULL,
0x0000001028217824ULL, 0x000fc400078e021bULL, 0x000000ffff287224ULL, 0x000fe400078e0010ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0014ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff117224ULL, 0x000fe200078e0013ULL, 0x000000281a007844ULL, 0x000fe20000000200ULL,
0x000000ffff137224ULL, 0x000fe400078e0017ULL, 0x000000ffff147224ULL, 0x000fe200078e001dULL,
0x0000002c21007844ULL, 0x0005e20000000200ULL, 0x000000ffff177224ULL, 0x000fc400078e0027ULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000001023007844ULL, 0x0007e80000000200ULL,
0x0000001430007844ULL, 0x0003e80000000200ULL, 0x0170000c18008388ULL, 0x0003e20000000c00ULL,
0x000000ffff217224ULL, 0x004fc400078e0022ULL, 0x000000ffff127224ULL, 0x008fc600078e0034ULL,
0x0172002018008388ULL, 0x0003e20000000a00ULL, 0x000000390b00720cULL, 0x000fe20003f06070ULL,
0x0176080a09ff79a7ULL, 0x0003e2000850003fULL, 0x0176100a09ff79a7ULL, 0x0003e2000850003fULL,
0x0176180a09ff79a7ULL, 0x0003e2000850003fULL, 0x0176200a09ff79a7ULL, 0x0003f2000850003fULL,
0xffffffa400b08947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000050007836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000005000008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff50ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000050027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005000007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffeac02207950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x000000000000057fULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000700ULL,
0x0000000000000258ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000958ULL,
0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a38ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000a8cULL,
0x0000000000000670ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001100ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001100ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001148ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL,
0x0000000000015480ULL, 0x0000001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016600ULL,
0x0000000000000048ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016650ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000016650ULL,
0x0000000000000270ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000016c40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000016c40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000001148ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015480ULL, 0x0000000000015480ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016600ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000016650ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000270ULL,
0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_90_cubin_len = 93584;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
