/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000173d0ULL, 0x0000000000017050ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL,
0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL,
0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL,
0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL,
0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL,
0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL,
0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL,
0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000100000096ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL,
0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL,
0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL,
0x000c000100000208ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000024fULL,
0x0000000000000034ULL, 0x0000000000000004ULL, 0x000c000100000295ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x000c0001000002e3ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000331ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000037fULL,
0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000003cdULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000413ULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000461ULL, 0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0022000004a7ULL,
0x0000000000015470ULL, 0x0000000000000180ULL, 0x000b0022000004daULL, 0x00000000000155f0ULL,
0x0000000000000040ULL, 0x000b002200000505ULL, 0x0000000000015630ULL, 0x0000000000000050ULL,
0x000b00220000052fULL, 0x0000000000015680ULL, 0x0000000000000100ULL, 0x000a00030000059dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005bdULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00070003000005edULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015780ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001547000000000ULL, 0x0000040400000000ULL, 0x810c000001880400ULL, 0x0053880400288080ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL,
0x2880808508288080ULL, 0x8090082880808808ULL, 0x0828808091082880ULL, 0x8080980828808092ULL,
0xa308288080a20828ULL, 0x2880808408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808084ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001547000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL,
0x2880808808288080ULL, 0x8092082880809008ULL, 0x0828808096082880ULL, 0x8080990828808098ULL,
0xa308288080a20828ULL, 0x2880809408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808094ULL, 0x0000001cffffffffULL, 0x0000013000000000ULL, 0x000155f000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080830828ULL, 0x2880808808288080ULL, 0x8091082880809008ULL, 0x0828808092082880ULL,
0x8080a20828808098ULL, 0x9908288080a30828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808099920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x000001d800000000ULL,
0x0001563000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8098288080990900ULL,
0x0000000000002880ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL,
0x2880808808288080ULL, 0x8092082880809008ULL, 0x0828808099082880ULL, 0x8080a308288080a2ULL,
0x8016288080980828ULL, 0x0000000310288082ULL, 0x8098920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000029000000000ULL, 0x0001568000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL,
0x000000000000001bULL, 0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0060190300600160ULL,
0x00000000000c1704ULL, 0x0021f0000058000aULL, 0x00000000000c1704ULL, 0x0021f00000500009ULL,
0x00000000000c1704ULL, 0x0011f00000480008ULL, 0x00000000000c1704ULL, 0x0061f00000300007ULL,
0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL, 0x0021f00000200005ULL,
0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL, 0x0021f00000100003ULL,
0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL, 0x0011f00000040001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL, 0x0134290400000b70ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x0000035000000150ULL,
0x00002630000005a0ULL, 0x00002800000026e0ULL, 0x00002dd000002960ULL, 0x00002e5000002e00ULL,
0x0000550000002ea0ULL, 0x000056b000005590ULL, 0x00005c9000005810ULL, 0x00005d1000005cc0ULL,
0x0000837000005d60ULL, 0x0000854000008410ULL, 0x00008b20000086a0ULL, 0x00008ba000008b50ULL,
0x0000b13000008bf0ULL, 0x0000b2f00000b1d0ULL, 0x0000b9100000b450ULL, 0x0000b9900000b940ULL,
0x0000d3c00000b9e0ULL, 0x00013d100000d3d0ULL, 0x00013d6000013d50ULL, 0x00013dc000013d70ULL,
0x00013e0000013de0ULL, 0x00014ab000013e10ULL, 0x00014b4000014af0ULL, 0x00014bd000014b80ULL,
0x00014c7000014c20ULL, 0x00014d0000014cb0ULL, 0x00014d9000014d40ULL, 0x00014e3000014de0ULL,
0x00014ec000014e70ULL, 0x00014f5000014f00ULL, 0x00014ff000014fa0ULL, 0x0001508000015030ULL,
0x00015110000150c0ULL, 0x000151b000015160ULL, 0x0001527000015210ULL, 0x00015330000152d0ULL,
0x000153f000015390ULL, 0x0440390400015450ULL, 0x000000ff00000430ULL, 0x003f01000000f600ULL,
0x0000001100000470ULL, 0x003f01200000f608ULL, 0x00000011000004f0ULL, 0x003f01200000f688ULL,
0x0000001100000510ULL, 0x003f01200000f6a8ULL, 0x0000001100000530ULL, 0x003f01200000f6c8ULL,
0x000000ff00000b90ULL, 0x003f01070000f600ULL, 0x0000000800000ce0ULL, 0x003f01020000f68cULL,
0x0000000800000d70ULL, 0x003f01010000f688ULL, 0x000000ff000015a0ULL, 0x0004010700000000ULL,
0x000000ff00001620ULL, 0x0004010100000000ULL, 0x0000000200001680ULL, 0x003f010100000020ULL,
0x00000005000017e0ULL, 0x003f01050000f6ccULL, 0x00000005000019b0ULL, 0x003f01050000f6ccULL,
0x0000001a000021f0ULL, 0x003f01070000f6b0ULL, 0x0000001a00002290ULL, 0x003f01010000f6b0ULL,
0x00000036000022f0ULL, 0x003f01010000f608ULL, 0x0000000500002330ULL, 0x003f01050000f60cULL,
0x0000000500002510ULL, 0x003f01050000f60cULL, 0x0000003400002b30ULL, 0x003f01050000f6acULL,
0x0000003400002d00ULL, 0x003f01050000f6acULL, 0x0000001800004770ULL, 0x003f010100000000ULL,
0x0000000f000047d0ULL, 0x003f01010000f688ULL, 0x0000000600004800ULL, 0x003f010500000004ULL,
0x00000006000049c0ULL, 0x003f010500000004ULL, 0x000000ff00005110ULL, 0x0004010700000000ULL,
0x000000ff000051e0ULL, 0x0004010100000000ULL, 0x0000000f00005240ULL, 0x003f01010000f628ULL,
0x0000000500005260ULL, 0x003f01050000f62cULL, 0x0000000500005430ULL, 0x003f01050000f62cULL,
0x0000003a000059f0ULL, 0x003f01050000f6b4ULL, 0x0000003a00005bc0ULL, 0x003f01050000f6b4ULL,
0x00000018000075d0ULL, 0x003f010100000000ULL, 0x0000001a00007630ULL, 0x003f01010000f690ULL,
0x0000000600007660ULL, 0x003f010500000004ULL, 0x0000000600007820ULL, 0x003f010500000004ULL,
0x000000ff00007f80ULL, 0x0004010700000008ULL, 0x0000001a00008010ULL, 0x003f01010000f6b0ULL,
0x0000000500008070ULL, 0x003f01010000f648ULL, 0x00000005000080d0ULL, 0x003f01050000f64cULL,
0x00000005000082a0ULL, 0x003f01050000f64cULL, 0x0000003700008880ULL, 0x003f01050000f6acULL,
0x0000003700008a50ULL, 0x003f01050000f6acULL, 0x000000060000a360ULL, 0x003f010100000000ULL,
0x000000120000a3c0ULL, 0x003f010100000000ULL, 0x000000060000a3f0ULL, 0x003f010500000004ULL,
0x000000060000a5b0ULL, 0x003f010500000004ULL, 0x000000ff0000ad50ULL, 0x0004010700000000ULL,
0x000000ff0000ae20ULL, 0x0004010100000000ULL, 0x0000003a0000ae80ULL, 0x003f01010000f668ULL,
0x0000003a0000aeb0ULL, 0x003f01050000f66cULL, 0x0000003a0000b080ULL, 0x003f01050000f66cULL,
0x0000003a0000b630ULL, 0x003f01050000f6b4ULL, 0x0000003a0000b830ULL, 0x003f01050000f6b4ULL,
0x000000060000d190ULL, 0x003f010100000000ULL, 0x000000050000d210ULL, 0x003f010100000000ULL,
0x000000ff0000e5a0ULL, 0x003f01010000f600ULL, 0x000000ff0000f180ULL, 0x003f01050000f604ULL,
0x000000ff0000f390ULL, 0x003f01050000f604ULL, 0x000000ff0000f5c0ULL, 0x003f01010000f600ULL,
0x000000ff0000f5f0ULL, 0x003f01050000f604ULL, 0x000000ff0000f7b0ULL, 0x003f01050000f604ULL,
0x00000007000120e0ULL, 0x003f010100000000ULL, 0x0000000700012170ULL, 0x003f010500000004ULL,
0x0000000700012340ULL, 0x003f010500000004ULL, 0x0000007500014910ULL, 0x003f010100000000ULL,
0x0000007500014970ULL, 0x003f010100000008ULL, 0x00000075000149d0ULL, 0x003f010100000010ULL,
0x0000007500014a40ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL, 0x0000dcc00000dc90ULL,
0x0000e1400000df50ULL, 0x0000e4f00000e340ULL, 0x00014a800000f810ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x000000000000031cULL, 0x0000001b00000002ULL, 0x000000000000026cULL,
0x0000001b00000002ULL, 0x00000000000001c4ULL, 0x0000001b00000002ULL, 0x0000000000000104ULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x00000000000002f5ULL,
0x0000001b00000002ULL, 0x0000000000000242ULL, 0x0000001b00000002ULL, 0x000000000000019fULL,
0x0000001b00000002ULL, 0x00000000000000dfULL, 0x0000001b00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x0000000105060810ULL, 0x002fca0007ffe0ffULL, 0x00005c0006060625ULL, 0x000fc800078e0002ULL,
0x00005c0005020625ULL, 0x000fe200078e0002ULL, 0x0000000606000981ULL, 0x0002aa000c1e1900ULL,
0x0000000602030981ULL, 0x0006a2000c1e1900ULL, 0x0000590000047b06ULL, 0x000f220000209000ULL,
0x00005900ff007a0cULL, 0x000fe40003f65070ULL, 0x0000000000747919ULL, 0x000e680000002600ULL,
0x0000000000107919ULL, 0x000e620000002300ULL, 0x00005900ff027624ULL, 0x008fc600078e00ffULL,
0x00000000000d7919ULL, 0x000ee20000002100ULL, 0x0000000400047308ULL, 0x010f240000001000ULL,
0x0ffffffe04087810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff0c7819ULL, 0x008fc8000001160dULL,
0x0000000800097305ULL, 0x000724000021f000ULL, 0x00001fff0c0c7589ULL, 0x000fe200000e0000ULL,
0x000000ffff087224ULL, 0x008fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x010fc800078e0a09ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b09097227ULL, 0x000fcc00078e0008ULL,
0x00000400090b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x002fc800078e0a0bULL,
0x0000040007047624ULL, 0x000fca00078e0202ULL, 0x0000590004007a0cULL, 0x000fda0003f26070ULL,
0x8000590004041a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590004007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00047306ULL, 0x000e620000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003f85070ULL, 0x0000000400047308ULL, 0x002e640000001000ULL,
0x0ffffffe04067810ULL, 0x002fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x0002e4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000070b087224ULL, 0x008fc800078e02ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a08ULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000097919ULL, 0x000e680000002200ULL, 0x0000007407707227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fc800078e0a70ULL, 0x000000040b047224ULL, 0x000fca00078e0274ULL,
0x0000000b0400720cULL, 0x000fe20003fa6070ULL, 0x0000010010067a24ULL, 0x002fc800078e0209ULL,
0x0000000006117a24ULL, 0x000fd000078e020dULL, 0x0000000104045824ULL, 0x000fe200078e0a0bULL,
0x0000000170705810ULL, 0x000fe20007ffe0ffULL, 0x00001fff100d7589ULL, 0x0002e200000e0000ULL,
0x000000ff1100720cULL, 0x040fe40003f65270ULL, 0x0000000b0400720cULL, 0x000fe40003fc6070ULL,
0x0000000f1100780cULL, 0x040fe40003f24070ULL, 0x000000031100780cULL, 0x040fe20003fa4070ULL,
0x00005a00ff107624ULL, 0x002fe200078e00ffULL, 0x0000007f1100780cULL, 0x000fc60003f44070ULL,
0x0000590010107a24ULL, 0x000fe400078e02ffULL, 0x3fffff80ff06b424ULL, 0x000fe400078e00ffULL,
0x0000000170706810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff07b424ULL, 0x000fe200078e00ffULL,
0x0000000bff70c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL, 0x00f60006ff00b388ULL, 0x0003e20000000a00ULL,
0x000000ffff047224ULL, 0x000fe200078e0a70ULL, 0x000000011100780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff0ad424ULL, 0x000fe200078e00ffULL, 0x00f6080811009388ULL, 0x0009e20000008a00ULL,
0x000000040b747224ULL, 0x000fc400078e0274ULL, 0x7fffff80ff0bd424ULL, 0x000fe400078e00ffULL,
0x0000001074747824ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06d424ULL, 0x002fe400078e00ffULL,
0x7fffff60ff07d424ULL, 0x000fe400078e00ffULL, 0xff317217ff12a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0eb424ULL, 0x000fe200078e00ffULL, 0x00f688061100d388ULL, 0x000fe20000008a00ULL,
0x7fffffc0ff0fb424ULL, 0x000fc600078e00ffULL, 0x00f6a80a1100d388ULL, 0x000fe80000008a00ULL,
0x00f400121100a388ULL, 0x000fe80000004800ULL, 0x00f6c80e1100b388ULL, 0x000fe20000008a00ULL,
0x0000000100000824ULL, 0x004fe400078e0a03ULL, 0x00005800ff008624ULL, 0x000fc400078e00ffULL,
0x0000580005038a24ULL, 0x000fe400078e02ffULL, 0x00005a0000097a24ULL, 0x010fe400078e02ffULL,
0x0000001003767224ULL, 0x000fe400078e02ffULL, 0x0000000109047824ULL, 0x040fe200078e0a74ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000740900720cULL, 0x000fe20003f26070ULL,
0x00005a0070117a24ULL, 0x000fe200078e0276ULL, 0x0000001004047817ULL, 0x000fc80003800000ULL,
0x000000ff04757207ULL, 0x000fe20000800000ULL, 0x000000040d047824ULL, 0x008fc600078e020cULL,
0x000000107500780cULL, 0x000fe20003f05270ULL, 0x0000000204087824ULL, 0x000fd800078e00ffULL,
0x000002c000008947ULL, 0x000fea0003800000ULL, 0x00005a0000047b06ULL, 0x000e620000209000ULL,
0x00000000000b7919ULL, 0x000ea20000000000ULL, 0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL,
0x0000000400047308ULL, 0x002e620000001000ULL, 0x00000004ff097819ULL, 0x004fca000001160bULL,
0x00000001080a7824ULL, 0x000fe200078e0209ULL, 0x0ffffffe04067810ULL, 0x002fc60007ffe0ffULL,
0x0000000174047824ULL, 0x000fe200078e020aULL, 0x0000000600077305ULL, 0x0002a4000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x004fc800078e0a07ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f07077227ULL, 0x000fcc00078e0006ULL,
0x00000004070e7227ULL, 0x000fc800078e00ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0eULL,
0x00005a0007067a24ULL, 0x000fca00078e0204ULL, 0x00005a0006007a0cULL, 0x000fda0003f06070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x000000010e0e0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f26070ULL, 0x000000010e0e1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0eaa12ULL, 0x000fca00078e33ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0eULL,
0x00005a0007047a24ULL, 0x000fe200078e0204ULL, 0x0000000875077217ULL, 0x000fc60007800000ULL,
0x00000001110f7824ULL, 0x000fe400078e0204ULL, 0x000000100b047824ULL, 0x000fe400078e00ffULL,
0x000000100e067224ULL, 0x000fe400078e020fULL, 0x0000000107087824ULL, 0x000fe200078e0a08ULL,
0x000000f0040f7812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fc600078e00ffULL,
0x000000080900720cULL, 0x000fe20003f06070ULL, 0x000000010a087824ULL, 0x000fe200078e020bULL,
0x0000000f060f7212ULL, 0x000fe200078efcffULL, 0x000000100a097824ULL, 0x000fc600078e00ffULL,
0x000060000f067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff009087812ULL, 0x000fe400078ee208ULL,
0x0000610007077a10ULL, 0x000fc60000ffe4ffULL, 0x0000001008097824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c46ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00005a0000097b06ULL, 0x000e620000209000ULL,
0x00000000000b7919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fca0003f45070ULL, 0x0000000900097308ULL, 0x002e620000001000ULL,
0x000000080b087211ULL, 0x004fca00078fe0ffULL, 0x0000000174047824ULL, 0x000fe200078e0208ULL,
0x0ffffffe090a7810ULL, 0x002fe20007ffe0ffULL, 0x0000000108097824ULL, 0x040fe400078e020bULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0x0000000a00077305ULL, 0x000e68000021f000ULL,
0xfffffff008097812ULL, 0x000fca00078ee209ULL, 0x0000001009097824ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x002fc800078e0a07ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f070f7227ULL, 0x000fcc00078e0006ULL, 0x000000040f067227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007077a24ULL, 0x000fca00078e0204ULL,
0x00005a0007007a0cULL, 0x000fda0003f06070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106060810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fda0003f26070ULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff06aa12ULL, 0x000fca00078e33ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007047a24ULL, 0x000fc800078e0204ULL,
0x0000000111077824ULL, 0x000fe400078e0204ULL, 0x000000100b047824ULL, 0x000fe400078e00ffULL,
0x0000001006077224ULL, 0x000fc600078e0207ULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x0000010007067825ULL, 0x000fca00078e00ffULL, 0x0000000f06067212ULL, 0x000fc800078efcffULL,
0x0000600006067a10ULL, 0x000fc80007f1e0ffULL, 0x0000610007077a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000b901c46ULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x0000000000087806ULL, 0x000fe200038e0000ULL,
0x00000004ff4a7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000800067300ULL, 0x000e7000000e0000ULL, 0x0000000800097309ULL, 0x000ea20000000000ULL,
0x000000070600720cULL, 0x002fe20003f02070ULL, 0x0000660005067625ULL, 0x000fc800078e004aULL,
0x000000ffff097224ULL, 0x004fd000078e0a09ULL, 0x00f60409ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006060a7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x000000ff0a0d7810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff097819ULL, 0x002fce000001160dULL,
0x0000d85000008947ULL, 0x000fea0003800000ULL, 0x000000080c087824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f68c0308ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0d00780cULL, 0x000fe20003f04070ULL, 0x0000000205057824ULL, 0x000fe200078e00ffULL,
0x00000001ff4d7819ULL, 0x000fe2000001160cULL, 0x00f6880008ff7f8cULL, 0x0005e2000c80043fULL,
0x000000010c4f7812ULL, 0x000fe200078ec0ffULL, 0x0000590005057624ULL, 0x000fe400078e0202ULL,
0x000000204d777824ULL, 0x000fc400078e00ffULL, 0x0000000170507824ULL, 0x000fc800078e0205ULL,
0x0000680050007a24ULL, 0x000fe200078e0277ULL, 0x000003e000000947ULL, 0x000fea0003800000ULL,
0x000000770a027217ULL, 0x004fe20007800000ULL, 0x000000104f037824ULL, 0x002fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc6000001160bULL, 0x0000000102027824ULL, 0x000fe200078e0a77ULL,
0x00000004050e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103067824ULL, 0x000fc600078e0205ULL,
0x0000000302027217ULL, 0x000fe20007800000ULL, 0x0000000106077824ULL, 0x040fe400078e020bULL,
0x0000000806107824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe400078e0a03ULL,
0x0000000100067824ULL, 0x000fe200078e0206ULL, 0xfffffff8100d7812ULL, 0x000fe400078ee207ULL,
0x0000000805077810ULL, 0x000fc40007ffe0ffULL, 0x000000020500720cULL, 0x0c0fe40003f66070ULL,
0x0000000c05057810ULL, 0x000fe40007ffe0ffULL, 0x000000020e00720cULL, 0x080fe20003f46070ULL,
0x00000001030e7824ULL, 0x000fe200078e020eULL, 0x000000020700720cULL, 0x080fe20003f26070ULL,
0x0000000103077824ULL, 0x000fe200078e0207ULL, 0x000000020500720cULL, 0x000fe20003f06070ULL,
0x00000001030f7824ULL, 0x000fe400078e0205ULL, 0x0000008006027825ULL, 0x000fc800078e00ffULL,
0x000000080f177824ULL, 0x040fe200078e00ffULL, 0x0000007002107812ULL, 0x000fe200078ef804ULL,
0x000000010f027824ULL, 0x100fe400078e020bULL, 0x000000010e067824ULL, 0x000fe200078e020bULL,
0x0000640010107a10ULL, 0x000fe20007f9e0ffULL, 0x000000080e137824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee202ULL, 0x0000000100057824ULL, 0x040fe200078e020eULL,
0x0000650003117a10ULL, 0x000fe200027fe4ffULL, 0x00000001000e7824ULL, 0x040fe200078e0207ULL,
0xfffffff813137812ULL, 0x000fe200078ee206ULL, 0x0000000100127824ULL, 0x000fc400078e020fULL,
0x0000000107007824ULL, 0x040fe400078e020bULL, 0x0000000807157824ULL, 0x000fe400078e00ffULL,
0x0000008005027825ULL, 0x000fc600078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee200ULL,
0x000000800e067825ULL, 0x000fe200078e00ffULL, 0x0000007002027812ULL, 0x100fe400078ef804ULL,
0x0000b0004d007811ULL, 0x000fe200078e68ffULL, 0x00000080120e7825ULL, 0x000fe200078e00ffULL,
0x0000007006057812ULL, 0x000fe400078ef804ULL, 0x0000640002027a10ULL, 0x000fe20007f9e0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x000000700e067812ULL, 0x000fe200078ef804ULL,
0x0000001013137824ULL, 0x100fe200078e0200ULL, 0x0000640005047a10ULL, 0x000fe20007fbe0ffULL,
0x0000001015157824ULL, 0x100fe200078e0200ULL, 0x0000640006067a10ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fe200078e0200ULL, 0x0000650003037a10ULL, 0x000fe200027fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0003e2000d901c46ULL,
0x0000650007057a10ULL, 0x000fc40002ffe4ffULL, 0x000065000f077a10ULL, 0x000fe200037fe4ffULL,
0x0000000002137faeULL, 0x0003e8000d101c46ULL, 0x0000000004157faeULL, 0x0003e8000c901c46ULL,
0x0000000006177faeULL, 0x0003e2000c101c46ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x000000104f027824ULL, 0x004fe200078e00ffULL, 0x0000b0004d177811ULL, 0x000fc800078e68ffULL,
0x000000020b027211ULL, 0x000fc800078fe8ffULL, 0x0000000402067810ULL, 0x040fe20007ffe0ffULL,
0x0000000102057824ULL, 0x040fe200078e020bULL, 0x0000000c02107810ULL, 0x040fe20007ffe0ffULL,
0x00000008020e7824ULL, 0x000fe400078e00ffULL, 0x0000000100037824ULL, 0x042fe400078e0202ULL,
0x0000000100077824ULL, 0x000fe200078e0206ULL, 0xfffffff80e057812ULL, 0x000fe200078ee205ULL,
0x00000001060d7824ULL, 0x000fe200078e020bULL, 0x00000008020e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008003027825ULL, 0x000fc800078e00ffULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x0000007002117812ULL, 0x000fe200078ef804ULL, 0x0000000100137824ULL, 0x000fe400078e0210ULL,
0x0000000110027824ULL, 0x040fe400078e020bULL, 0x0000000810157824ULL, 0x000fe200078e00ffULL,
0x0000640011107a10ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x000fe200078e020eULL,
0xfffffff812007812ULL, 0x000fe200078ee20dULL, 0x000000010e0f7824ULL, 0x040fe200078e020bULL,
0xfffffff815147812ULL, 0x000fe200078ee202ULL, 0x000000080e0e7824ULL, 0x000fe200078e00ffULL,
0x0000650003117a10ULL, 0x000fe200007fe4ffULL, 0x0000008007027825ULL, 0x000fc600078e00ffULL,
0xfffffff80e127812ULL, 0x000fe200078ee20fULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000007002027812ULL, 0x000fc600078ef804ULL, 0x00000080130e7825ULL, 0x000fe200078e00ffULL,
0x0000640002027a10ULL, 0x000fc60007f1e0ffULL, 0x00000010050d7824ULL, 0x100fe200078e0217ULL,
0x0000007006057812ULL, 0x100fe200078ef804ULL, 0x0000001000137824ULL, 0x100fe200078e0217ULL,
0x000000700e067812ULL, 0x000fe200078ef804ULL, 0x0000001012157824ULL, 0x100fe200078e0217ULL,
0x0000640005047a10ULL, 0x000fe20007f3e0ffULL, 0x0000001014177824ULL, 0x000fe200078e0217ULL,
0x0000640006067a10ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100d7faeULL, 0x0003e2000b901c46ULL, 0x0000650003037a10ULL, 0x000fe400007fe4ffULL,
0x0000650007057a10ULL, 0x000fc40000ffe4ffULL, 0x000065000f077a10ULL, 0x000fe200017fe4ffULL,
0x0000000002137faeULL, 0x0003e8000b901c46ULL, 0x0000000004157faeULL, 0x0003e8000b901c46ULL,
0x0000000006177faeULL, 0x0003e4000b901c46ULL, 0x000000004d0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x0000f6a84d027811ULL, 0x002fe200078e18ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff107f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200002027f8cULL, 0x000ea2000c80043fULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000bb2000008947ULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x002fe200078e0011ULL,
0x00000002ff667819ULL, 0x000fe2000001160cULL, 0x000000ffff007224ULL, 0x004fc400078e0003ULL,
0xff317217ff127424ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe400078e00ffULL,
0x000000ffff177224ULL, 0x000fc400078e00ffULL, 0x000000ffff0f7224ULL, 0x00afca00078e00ffULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0x000000040c057824ULL, 0x000fca00078e00ffULL,
0xfffffff805057812ULL, 0x000fc800078ec0ffULL, 0x0000f6c805067810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc00050d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001141bULL,
0x0000001a0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff1a7224ULL, 0x000fca00000e061bULL,
0x000000020d0d7819ULL, 0x000fc8000000121aULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc00050d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000107007810ULL, 0x040fe20007ffe0ffULL,
0x0000010007447824ULL, 0x000fc600078e0277ULL, 0x000000090000720cULL, 0x000fe40003f26070ULL,
0x0000004044057810ULL, 0x000fca0007ffe0ffULL, 0x0000680050367a24ULL, 0x000fcc00078e0205ULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x000000050a007217ULL, 0x000fe20007800000ULL,
0x000000104f0d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0f7819ULL, 0x000fc6000001160bULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000040f137810ULL, 0x000fe20007ffe0ffULL,
0x000000010d187824ULL, 0x000fe200078e020fULL, 0x000000080f197810ULL, 0x000fe40007ffe0ffULL,
0x000000000d007217ULL, 0x000fe20007800000ULL, 0x0000000118057824ULL, 0x040fe400078e020bULL,
0x00000008181a7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fc400078e0a0dULL,
0x000000010d1b7824ULL, 0x000fe200078e0219ULL, 0xfffffff81a117812ULL, 0x000fe200078ee205ULL,
0x000000100b057824ULL, 0x000fe200078e00ffULL, 0x000000001300720cULL, 0x080fe20003f66070ULL,
0x000000010d137824ULL, 0x000fe200078e0213ULL, 0x0000000c0f1a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000118187824ULL, 0x000fe200078e0236ULL, 0x000000000f00720cULL, 0x080fe20003f86070ULL,
0x00000001130f7824ULL, 0x040fe200078e020bULL, 0x000000001a00720cULL, 0x080fe20003f06070ULL,
0x0000000813347824ULL, 0x000fe200078e00ffULL, 0x000000001900720cULL, 0x000fe20003f46070ULL,
0x000000010d357824ULL, 0x000fe200078e021aULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x00000001131a7824ULL, 0x100fe200078e0236ULL, 0xfffffff8340d7812ULL, 0x000fe200078ee20fULL,
0x000000011b347824ULL, 0x000fc400078e0236ULL, 0x0000008018187825ULL, 0x000fc800078e00ffULL,
0x000000011b007824ULL, 0x140fe200078e020bULL, 0x0000000518187212ULL, 0x080fe200078efcffULL,
0x000000081b0f7824ULL, 0x000fe400078e00ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000640018187a10ULL, 0x000fe40007fbe0ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee200ULL,
0x0000000135367824ULL, 0x040fe200078e0236ULL, 0x000000051a1a7212ULL, 0x000fe200078efcffULL,
0x0000000135137824ULL, 0x000fe200078e020bULL, 0x0000c0004d007811ULL, 0x000fe200078e68ffULL,
0x00000008353c7824ULL, 0x000fe200078e00ffULL, 0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000650019197a10ULL, 0x000fc40002ffe4ffULL,
0xfffffff83c137812ULL, 0x000fe200078ee213ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000000534347212ULL, 0x080fe400078efcffULL, 0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0200ULL, 0x0000000536367212ULL, 0x000fe200078efcffULL,
0x0000001011057824ULL, 0x100fe200078e0200ULL, 0x0000640034347a10ULL, 0x000fe20007fbe0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0200ULL, 0x0000640036367a10ULL, 0x000fe20007fde0ffULL,
0x0000001013117824ULL, 0x000fe200078e0200ULL, 0x0000650035357a10ULL, 0x000fe20002ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018057faeULL, 0x0003e2000e101c46ULL,
0x0000650037377a10ULL, 0x000fc600037fe4ffULL, 0x000000001a0d7faeULL, 0x0003e8000d901c46ULL,
0x00000000340f7faeULL, 0x0003e8000d101c46ULL, 0x0000000036117faeULL, 0x0003e2000c101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000104f007824ULL, 0x000fe400078e00ffULL,
0x000000100b057824ULL, 0x000fc600078e00ffULL, 0x000000000b007211ULL, 0x000fe400078fe8ffULL,
0x00000070050f7812ULL, 0x000fe400078ec0ffULL, 0x0000000800117810ULL, 0x040fe20007ffe0ffULL,
0x00000001000d7824ULL, 0x040fe200078e020bULL, 0x0000000c001b7810ULL, 0x040fe20007ffe0ffULL,
0x00000008001a7824ULL, 0x040fe400078e00ffULL, 0x0000000100187824ULL, 0x100fe400078e0236ULL,
0x0000000111347824ULL, 0x000fe200078e0236ULL, 0xfffffff81a057812ULL, 0x000fe200078ee20dULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000004000d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000111137824ULL, 0x100fe200078e020bULL, 0x0000000f18187212ULL, 0x000fe200078efcffULL,
0x000000010d1a7824ULL, 0x100fe400078e0236ULL, 0x000000011b367824ULL, 0x000fe200078e0236ULL,
0x0000640018187a10ULL, 0x000fe20007f1e0ffULL, 0x00000008113c7824ULL, 0x000fe400078e00ffULL,
0x000000011b117824ULL, 0x000fe200078e020bULL, 0x0000650019197a10ULL, 0x000fe200007fe4ffULL,
0x000000081b3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c137812ULL, 0x000fe200078ee213ULL,
0x000000010d007824ULL, 0x000fc400078e020bULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0xfffffff83e117812ULL, 0x000fc600078ee211ULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0x0000000f1a1a7212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee200ULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000000f34347212ULL, 0x080fe400078efcffULL, 0x0000c0004d007811ULL, 0x000fe400078e68ffULL,
0x0000000f36367212ULL, 0x000fe400078efcffULL, 0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000001005057824ULL, 0x100fe200078e0200ULL, 0x0000640034347a10ULL, 0x000fe20007f5e0ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0200ULL, 0x0000640036367a10ULL, 0x000fe20007f7e0ffULL,
0x00000010130f7824ULL, 0x100fe200078e0200ULL, 0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL,
0x0000001011117824ULL, 0x000fe200078e0200ULL, 0x0000650035357a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018057faeULL, 0x0003e2000b901c46ULL,
0x0000650037377a10ULL, 0x000fc60001ffe4ffULL, 0x000000001a0d7faeULL, 0x0003e8000b901c46ULL,
0x00000000340f7faeULL, 0x0003e8000b901c46ULL, 0x0000000036117faeULL, 0x0003e4000b901c46ULL,
0xfffffff0081a7812ULL, 0x042fe400078ec0ffULL, 0xffffffe008007812ULL, 0x000fc400078ec0ffULL,
0x000000001a0573c2ULL, 0x000e6200000e0000ULL, 0x0000001008057812ULL, 0x000fca00078ec0ffULL,
0x0000000100007824ULL, 0x000fe400078e0205ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000084f367824ULL, 0x000fe200078e0200ULL, 0x0000f6b005057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b0001a1a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080036367f8cULL, 0x000ea4000c80043fULL,
0x0000000000187805ULL, 0x000fc40000015200ULL, 0x0000000808057812ULL, 0x000fca00078ec0ffULL,
0x0000000100057824ULL, 0x000fca00078e0205ULL, 0x00f60c00050d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x00000034180d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000135347824ULL, 0x000fe200000e0e19ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011434ULL,
0x0000000d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e0634ULL,
0x0000000200007819ULL, 0x000fc8000000120dULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f60c00050d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100b4e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff717819ULL, 0x000fe2000001160bULL, 0x000000200c007824ULL, 0x000fe400078e00ffULL,
0xffffffffff787424ULL, 0x000fe200078e00ffULL, 0x000000704e4e7812ULL, 0x000fc400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c71717812ULL, 0x000fc800078ec0ffULL,
0x0000000071007210ULL, 0x000fca0007ffe04eULL, 0x00f00000000f7984ULL, 0x000ea80000000800ULL,
0x00f2000000137984ULL, 0x0006620000000800ULL, 0x000000120f00720bULL, 0x004fe20003f1d000ULL,
0x000124627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x008fc800000e0100ULL,
0x0000ffff11357812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff007424ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc400078e0012ULL,
0x0000001fff7a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff797424ULL, 0x000fca00078e00ffULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x0000000c6600720cULL, 0x000fe40003f05270ULL,
0x000000120f00720bULL, 0x000fe20003f54000ULL, 0x000123f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fc400010e0100ULL, 0x000000800c188824ULL, 0x000fe200078e024eULL,
0x000000120f0d7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991000117816ULL, 0x000fe200000000ffULL, 0x0000000171188824ULL, 0x000fca00078e0218ULL,
0x00f4000d18008388ULL, 0x0005e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x000000120d117221ULL, 0x004fe20000010100ULL,
0x000000ff00ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100127308ULL, 0x000ea40000000800ULL,
0x000000120e0e7220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe2000001160bULL, 0x000123227f007947ULL, 0x000fea000b800000ULL,
0x00001f1112117589ULL, 0x0004e400000e0000ULL, 0x0000001138387220ULL, 0x08cfe20000410000ULL,
0x0000001139397220ULL, 0x080fe20000410000ULL, 0x000000111c1c7220ULL, 0x080fe20000410000ULL,
0x000000111d1d7220ULL, 0x080fe20000410000ULL, 0x0000001120207220ULL, 0x080fe20000410000ULL,
0x0000001121217220ULL, 0x080fe20000410000ULL, 0x0000001124247220ULL, 0x080fe20000410000ULL,
0x0000001125257220ULL, 0x080fe20000410000ULL, 0x0000001128287220ULL, 0x080fe20000410000ULL,
0x0000001129297220ULL, 0x080fe20000410000ULL, 0x000000112c2c7220ULL, 0x080fe20000410000ULL,
0x000000112d2d7220ULL, 0x080fe20000410000ULL, 0x0000001130307220ULL, 0x080fe20000410000ULL,
0x0000001131317220ULL, 0x080fe20000410000ULL, 0x0000001114147220ULL, 0x080fe20000410000ULL,
0x0000001115157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0000ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080b117811ULL, 0x000fe200078ff0ffULL, 0x000122027f007947ULL, 0x000fea000b800000ULL,
0x00001f1112117589ULL, 0x0004e400000e0000ULL, 0x000000113a3a7220ULL, 0x08cfe20000410000ULL,
0x000000113b3b7220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x080fe20000410000ULL, 0x000000112e2e7220ULL, 0x080fe20000410000ULL,
0x000000112f2f7220ULL, 0x080fe20000410000ULL, 0x0000001132327220ULL, 0x080fe20000410000ULL,
0x0000001133337220ULL, 0x080fe20000410000ULL, 0x0000001116167220ULL, 0x080fe20000410000ULL,
0x0000001117177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806000ULL, 0x00000001ff007424ULL, 0x000fd800078e00ffULL,
0x8000000d0f0f0221ULL, 0x000fe20000010000ULL, 0x00007610ff000816ULL, 0x000fc60000000000ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00040308ULL, 0x000ea40000000800ULL,
0x0000000413130220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e130e7221ULL, 0x002fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0xfffffff008347812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00340f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804810ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001812187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e13ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011419ULL, 0x000000180f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x000000020f0f7819ULL, 0x000fc80000001218ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00340f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991000007816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000004ff00723eULL, 0x000fe400000010ffULL,
0x00000002ff0f7819ULL, 0x000fe4000001160bULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x00011dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f0f00037589ULL, 0x0002a400000e0000ULL,
0x000000080f117810ULL, 0x000fe20007ffe0ffULL, 0x00011e027f007947ULL, 0x000fea000b800000ULL,
0x00001f1100027589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f117810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0000ULL,
0x00002e6000197802ULL, 0x000fc40000000f00ULL, 0x000127d000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f117810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0000ULL, 0x00002eb000197802ULL, 0x000fc40000000f00ULL,
0x0001278000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070b0f7812ULL, 0x002fe200078ec0ffULL, 0x000002000c457824ULL, 0x000fe200078e00ffULL,
0x00000004ff107819ULL, 0x100fe2000001160bULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000080f187812ULL, 0x000fc400078ef80bULL, 0xfffff80045457812ULL, 0x000fe200078ec0ffULL,
0x000000044d117824ULL, 0x00cfe200078e0210ULL, 0x000000080b007812ULL, 0x000fe200078ec0ffULL,
0x0000000818487824ULL, 0x040fe400078e00ffULL, 0x0000000118197824ULL, 0x000fca00078e0211ULL,
0xfffffff848487812ULL, 0x000fca00078ee219ULL, 0x0000001048487824ULL, 0x000fc400078e0245ULL,
0x000000044f3d7824ULL, 0x000fe200078e0210ULL, 0x0000000f00107212ULL, 0x000fe200078efcffULL,
0x0000000818187824ULL, 0x000fe200078e00ffULL, 0x0000b0004d527811ULL, 0x000fe400078e68ffULL,
0x0000001000007812ULL, 0x000fe200078efe0fULL, 0x0000000110117824ULL, 0x040fe200078e023dULL,
0x0000000219497810ULL, 0x000fe20007ffe0ffULL, 0x0000000810127824ULL, 0x040fe400078e00ffULL,
0x0000000810107824ULL, 0x000fe200078e00ffULL, 0xfffffff818497812ULL, 0x000fe200078ee249ULL,
0x000000013d3d7824ULL, 0x000fe200078e0200ULL, 0xfffffff812137812ULL, 0x000fe200078ee211ULL,
0x00000008003c7824ULL, 0x040fe200078e00ffULL, 0x0000000211117810ULL, 0x000fe20007ffe0ffULL,
0x00000008003e7824ULL, 0x000fe200078e00ffULL, 0x000000023d197810ULL, 0x000fe20007ffe0ffULL,
0x0000001013347824ULL, 0x000fe200078e0252ULL, 0xfffffff810117812ULL, 0x000fe200078ee211ULL,
0x0000001049497824ULL, 0x000fe200078e0245ULL, 0xfffffff83c3d7812ULL, 0x000fc400078ee23dULL,
0xfffffff83e197812ULL, 0x000fe200078ee219ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x0000001011117824ULL, 0x100fe400078e0252ULL, 0x000000103d3f7824ULL, 0x000fc800078e0252ULL,
0x000000001110783bULL, 0x000ea20000004200ULL, 0x00000010ff187819ULL, 0x102fe40000011634ULL,
0x000000ff340f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff427819ULL, 0x000fe40000011634ULL,
0x0000ffff34537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff4c7819ULL, 0x000fe40000011635ULL,
0x000000ff35517812ULL, 0x000fc400078ec0ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011635ULL,
0x0000ffff35687812ULL, 0x000fe400078ec0ffULL, 0x00000010ff6a7819ULL, 0x100fe40000011636ULL,
0x000000ff366f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011636ULL,
0x0000ffff36627812ULL, 0x000fc400078ec0ffULL, 0x00000010ff697819ULL, 0x100fe40000011637ULL,
0x000000ff376c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011637ULL,
0x0000ffff37647812ULL, 0x000fe400078ec0ffULL, 0x000000003f34783bULL, 0x0002e20000004200ULL,
0x00000010ff5a7819ULL, 0x004fe40000011610ULL, 0x000000ff10597812ULL, 0x000fc400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011610ULL, 0x0000ffff103c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff107819ULL, 0x000fe40000011653ULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x00000010ff10723eULL, 0x000fc400020006ffULL,
0x0000000fff43723eULL, 0x000fe200020006ffULL, 0x2000004cff567230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x100fe20000011611ULL, 0x20000010ff4c7230ULL, 0x000fe20000004100ULL,
0x000000ff11617812ULL, 0x040fe200078ec0ffULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000018ff417819ULL, 0x000fe40000011611ULL, 0x0000ffff113e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff0f7819ULL, 0x000fc40000011612ULL, 0x000000ff12467812ULL, 0x040fe400078ec0ffULL,
0x00000018ff3f7819ULL, 0x002fe40000011612ULL, 0x0000ffff12547812ULL, 0x000fe400078ec0ffULL,
0x00000010ff557819ULL, 0x100fe40000011613ULL, 0x000000ff13477812ULL, 0x000fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fc40000011613ULL, 0x0000ffff134b7812ULL, 0x000fe400078ec0ffULL,
0x000000ff18187812ULL, 0x000fe200078ec0ffULL, 0x009000004810783bULL, 0x000e620000000200ULL,
0x00000051ff51723eULL, 0x000fe400020006ffULL, 0x00000018ff18723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x20000051ff537230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fe20000011656ULL, 0x20000018ff187230ULL, 0x000fe20000004100ULL,
0x00000008ff687819ULL, 0x000fe20000011668ULL, 0x20000042ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff427819ULL, 0x000fc40000011643ULL, 0x00000010ff437819ULL, 0x000fe40000011618ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x0000105443427816ULL, 0x000fe40000000042ULL,
0x0000105456437816ULL, 0x000fe40000000053ULL, 0x00000010ff567819ULL, 0x008fe40000011635ULL,
0x000000ff35677812ULL, 0x000fc400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe40000011635ULL,
0x0000ffff35587812ULL, 0x000fe400078ec0ffULL, 0x00000068ff35723eULL, 0x000fe400020006ffULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000010ff187819ULL, 0x000fe2000001164cULL,
0x20000035ff357230ULL, 0x000fe20000004100ULL, 0x0000006dff6d723eULL, 0x000fe200020006ffULL,
0x2000006eff6e7230ULL, 0x000fe20000004100ULL, 0x00000010ff517819ULL, 0x000fc40000011651ULL,
0x00000010ff577819ULL, 0x100fe20000011636ULL, 0x0000000310108231ULL, 0x082fe200003400ffULL,
0x000000ff365b7812ULL, 0x040fe200078ec0ffULL, 0x0000000312128231ULL, 0x000fe200003400ffULL,
0x00000018ff4c7819ULL, 0x000fe20000011636ULL, 0x0000000211118231ULL, 0x080fe200003400ffULL,
0x0000ffff365e7812ULL, 0x000fe200078ec0ffULL, 0x0000000213138231ULL, 0x000fe200003400ffULL,
0x00000008ff367819ULL, 0x000fe20000011662ULL, 0x2000006dff627230ULL, 0x000fe20000004100ULL,
0x0000105451187816ULL, 0x000fc40000000018ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x00000010ff487819ULL, 0x100fe20000011634ULL, 0x000000421038723cULL, 0x000f620000041838ULL,
0x000000ff345f7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff607819ULL, 0x000fe40000011634ULL,
0x0000ffff34537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff5d7819ULL, 0x000fc40000011637ULL,
0x000000ff375c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff517819ULL, 0x000fe40000011637ULL,
0x0000ffff37637812ULL, 0x000fe400078ec0ffULL, 0x00000036ff6d723eULL, 0x000fe200020006ffULL,
0x0000001019367824ULL, 0x000fe200078e0252ULL, 0x0000006bff34723eULL, 0x000fe400020006ffULL,
0x000000ff69377812ULL, 0x000fe200078ec0ffULL, 0x2000006cff697230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe20000011635ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff6e7819ULL, 0x000fc4000001166eULL, 0x000000ff6a6b7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fe20000011664ULL, 0x20000034ff647230ULL, 0x000fe20000004100ULL,
0x00000037ff6c723eULL, 0x000fe400020006ffULL, 0x000010546e197816ULL, 0x000fe40000000035ULL,
0x000000003634783bULL, 0x000e620000004200ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x2000006cff6c7230ULL, 0x000fe20000004100ULL, 0x0000006fff6f723eULL, 0x000fc400020006ffULL,
0x00000018101c723cULL, 0x000be2000004181cULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x2000006fff687230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000006bff6b7230ULL, 0x000fe20000004100ULL, 0x000000ff3d187812ULL, 0x020fe200078ec0ffULL,
0x20000059ff3d7230ULL, 0x000fe20000004100ULL, 0x00000010ff437819ULL, 0x000fe20000011669ULL,
0x20000061ff597230ULL, 0x000fe20000004100ULL, 0x00000018ff18723eULL, 0x000fc400020006ffULL,
0x00000010ff197819ULL, 0x000fe40000011662ULL, 0x00000010ff697819ULL, 0x000fe20000011664ULL,
0x20000018ff617230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fe4000001166dULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000010ff427819ULL, 0x000fe40000011668ULL,
0x00000010ff6b7819ULL, 0x000fc4000001166bULL, 0x00000010ff6c7819ULL, 0x000fe4000001166cULL,
0x00000060ff60723eULL, 0x000fe400020006ffULL, 0x0000105419187816ULL, 0x000fe40000000018ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x000000ff5a5a7812ULL, 0x000fe400078ec0ffULL,
0x0000105469197816ULL, 0x000fc4000000006aULL, 0x000010546b427816ULL, 0x000fe40000000042ULL,
0x000010546c437816ULL, 0x000fe40000000043ULL, 0x0000005cff69723eULL, 0x000fe200020006ffULL,
0x000000181024723cULL, 0x040fe20000041824ULL, 0x0000005bff68723eULL, 0x000fe200020006ffULL,
0x20000060ff5b7230ULL, 0x000fe20000004100ULL, 0x0000004cff6a723eULL, 0x000fe200020006ffULL,
0x20000067ff607230ULL, 0x000fe20000004100ULL, 0x0000005aff5a723eULL, 0x000fe200020006ffULL,
0x20000068ff4c7230ULL, 0x000fe20000004100ULL, 0x00000051ff67723eULL, 0x000fe200020006ffULL,
0x20000069ff517230ULL, 0x000fe20000004100ULL, 0x0000003fff3f723eULL, 0x000fe200020006ffULL,
0x000000421020723cULL, 0x000b620000041820ULL, 0x00000046ff69723eULL, 0x000fe200020006ffULL,
0x2000006aff467230ULL, 0x000fe20000004100ULL, 0x00000008ff587819ULL, 0x000fe20000011658ULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff597819ULL, 0x000fe20000011659ULL,
0x20000069ff697230ULL, 0x000fe20000004100ULL, 0x00000010ff427819ULL, 0x020fc40000011661ULL,
0x00000047ff6a723eULL, 0x000fe200020006ffULL, 0x20000067ff477230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x2000003fff677230ULL, 0x000fe20000004100ULL,
0x00000065ff65723eULL, 0x000fe200020006ffULL, 0x2000006aff6a7230ULL, 0x000fe20000004100ULL,
0x00000058ff3f723eULL, 0x000fe200020006ffULL, 0x20000040ff687230ULL, 0x000fe20000004100ULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0x20000065ff5c7230ULL, 0x000fe20000004100ULL,
0x0000105442197816ULL, 0x000fc40000000059ULL, 0x00000010ff3d7819ULL, 0x000fe4000001163dULL,
0x00000010ff5a7819ULL, 0x000fe4000001165aULL, 0x00000018ff6b7819ULL, 0x002fe40000011634ULL,
0x00000010ff627819ULL, 0x100fe40000011635ULL, 0x000000ff356f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6c7819ULL, 0x000fc40000011635ULL, 0x0000ffff35597812ULL, 0x000fe400078ec0ffULL,
0x00000018ff357819ULL, 0x000fe40000011636ULL, 0x0000005eff40723eULL, 0x000fe200020006ffULL,
0x2000003fff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff3c7819ULL, 0x000fe4000001163cULL,
0x000000ff366d7812ULL, 0x000fe400078ec0ffULL, 0x000010545a187816ULL, 0x000fc4000000003dULL,
0x000000ff48657812ULL, 0x000fe400078ec0ffULL, 0x0000006bff3f723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x000fe20000011634ULL, 0x000000181028723cULL, 0x000b620000041828ULL,
0x000000ff346e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff34617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5a7819ULL, 0x000fc40000011636ULL, 0x0000ffff36437812ULL, 0x000fe400078ec0ffULL,
0x000000ff56487812ULL, 0x000fe400078ec0ffULL, 0x00000035ff6b723eULL, 0x000fe400020006ffULL,
0x00000010ff427819ULL, 0x100fe40000011637ULL, 0x000000ff37367812ULL, 0x000fe400078ec0ffULL,
0x00000018ff347819ULL, 0x000fc40000011637ULL, 0x0000ffff373d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe2000001163eULL, 0x2000003fff3e7230ULL, 0x000fe20000004100ULL,
0x0000003cff35723eULL, 0x000fe400020006ffULL, 0x0000004aff37723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x20000035ff357230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fe200020006ffULL, 0x20000037ff377230ULL, 0x000fe20000004100ULL,
0x000000ff0f0f7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff3c7230ULL, 0x000fe20000004100ULL,
0x00000041ff41723eULL, 0x000fc400020006ffULL, 0x000000ff556d7812ULL, 0x000fe400078ec0ffULL,
0x0000000fff55723eULL, 0x000fe200020006ffULL, 0x20000056ff0f7230ULL, 0x000fe20000004100ULL,
0x0000006cff6c723eULL, 0x000fe200020006ffULL, 0x20000041ff727230ULL, 0x000fe20000004100ULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe20000011635ULL, 0x2000006cff3f7230ULL, 0x000fe20000004100ULL,
0x00000010ff567819ULL, 0x000fc40000011637ULL, 0x00000008ff417819ULL, 0x000fe40000011653ULL,
0x000000ff57537812ULL, 0x000fe400078ec0ffULL, 0x00000010ff577819ULL, 0x000fe2000001160fULL,
0x20000036ff0f7230ULL, 0x000fe20000004100ULL, 0x00000034ff6c723eULL, 0x000fe400020006ffULL,
0x0000105456567816ULL, 0x000fe40000000035ULL, 0x009000004934783bULL, 0x000e620000000200ULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x00000008ff187819ULL, 0x020fe4000001164bULL,
0x000000ff64197812ULL, 0x000fe400078ec0ffULL, 0x00000008ff547819ULL, 0x000fe40000011654ULL,
0x00000018ff64723eULL, 0x000fe200020006ffULL, 0x2000006dff187230ULL, 0x000fe20000004100ULL,
0x00000010ff727819ULL, 0x000fe40000011672ULL, 0x00000054ff4b723eULL, 0x000fe200020006ffULL,
0x20000064ff647230ULL, 0x000fe20000004100ULL, 0x00000019ff6d723eULL, 0x000fe200020006ffULL,
0x2000006bff197230ULL, 0x000fe20000004100ULL, 0x00000010ff547819ULL, 0x000fe20000011669ULL,
0x2000004bff697230ULL, 0x000fe20000004100ULL, 0x00000010ff557819ULL, 0x000fe20000011655ULL,
0x2000006dff4b7230ULL, 0x000fe20000004100ULL, 0x00000010ff6a7819ULL, 0x000fc4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe20000011618ULL, 0x2000006cff187230ULL, 0x000fe20000004100ULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x00000065ff65723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000105472577816ULL, 0x000fe20000000057ULL, 0x20000065ff657230ULL, 0x000fe20000004100ULL,
0x0000105455547816ULL, 0x000fc40000000054ULL, 0x000010546b557816ULL, 0x000fe4000000006aULL,
0x00000008ff4a7819ULL, 0x000fe20000011663ULL, 0x20000048ff637230ULL, 0x000fe20000004100ULL,
0x000000ff62627812ULL, 0x000fe200078ec0ffULL, 0x00000056102c723cULL, 0x040b62000004182cULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x0000000334348231ULL, 0x082fe200003400ffULL,
0x00000010ff677819ULL, 0x000fe20000011667ULL, 0x0000000336368231ULL, 0x000fe200003400ffULL,
0x00000010ff687819ULL, 0x000fe20000011668ULL, 0x0000000235358231ULL, 0x080fe200003400ffULL,
0x00000010ff577819ULL, 0x020fe20000011664ULL, 0x000000541030723cULL, 0x000b620000041830ULL,
0x00000010ff567819ULL, 0x000fe20000011669ULL, 0x0000000237378231ULL, 0x000fe200003400ffULL,
0x00000062ff64723eULL, 0x000fe200020006ffULL, 0x20000040ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff657819ULL, 0x000fc40000011665ULL, 0x00000010ff547819ULL, 0x020fe4000001165fULL,
0x00000010ff557819ULL, 0x000fe20000011660ULL, 0x20000064ff607230ULL, 0x000fe20000004100ULL,
0x00000010ff627819ULL, 0x000fe40000011663ULL, 0x00000053ff53723eULL, 0x000fe400020006ffULL,
0x0000005dff58723eULL, 0x000fe400020006ffULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000105467567816ULL, 0x000fe20000000056ULL,
0x20000058ff587230ULL, 0x000fe20000004100ULL, 0x0000105468577816ULL, 0x000fe20000000057ULL,
0x2000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000105465547816ULL, 0x000fc40000000054ULL,
0x0000105462557816ULL, 0x000fe40000000055ULL, 0x00000041ff41723eULL, 0x000fe200020006ffULL,
0x000000561010723cULL, 0x000f620000041814ULL, 0x00000008ff617819ULL, 0x000fe40000011661ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x20000041ff5d7230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fe40000011653ULL, 0x00000010ff587819ULL, 0x000fe20000011658ULL,
0x000000543414723cULL, 0x000b620000041838ULL, 0x00000010ff477819ULL, 0x000fc40000011647ULL,
0x00000010ff4a7819ULL, 0x000fe4000001164aULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x00000010ff387819ULL, 0x020fe4000001164cULL, 0x00000010ff397819ULL, 0x000fe20000011651ULL,
0x2000006eff407230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe40000011646ULL,
0x00000010ff3a7819ULL, 0x000fc40000011648ULL, 0x0000006fff41723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000059ff59723eULL, 0x000fe200020006ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000105453387816ULL, 0x000fe20000000038ULL,
0x20000061ff5f7230ULL, 0x000fe20000004100ULL, 0x0000105458397816ULL, 0x000fe20000000039ULL,
0x20000059ff517230ULL, 0x000fe20000004100ULL, 0x000010543b3a7816ULL, 0x000fc4000000003aULL,
0x00001054473b7816ULL, 0x000fe4000000004aULL, 0x000000ff5a5a7812ULL, 0x000fe200078ec0ffULL,
0x000000383420723cULL, 0x040b620000041820ULL, 0x000000ff42427812ULL, 0x000fe400078ec0ffULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x00000010ff387819ULL, 0x020fe20000011640ULL, 0x0000003a3424723cULL, 0x000b620000041824ULL,
0x00000010ff397819ULL, 0x000fc40000011641ULL, 0x00000010ff607819ULL, 0x000fe40000011660ULL,
0x00000008ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff3b7819ULL, 0x020fe4000001163eULL,
0x00000010ff3a7819ULL, 0x000fe4000001165fULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x00000010ff3e7819ULL, 0x000fc4000001163fULL, 0x00000010ff517819ULL, 0x000fe20000011651ULL,
0x2000005aff4c7230ULL, 0x000fe20000004100ULL, 0x00000042ff42723eULL, 0x000fe400020006ffULL,
0x00000043ff43723eULL, 0x000fe400020006ffULL, 0x000010544b387816ULL, 0x000fe20000000038ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x0000105460397816ULL, 0x000fe20000000039ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x0000003dff3d723eULL, 0x000fc400020006ffULL,
0x000010543b3a7816ULL, 0x000fe4000000003aULL, 0x000010543e3b7816ULL, 0x000fe20000000051ULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x000000383428723cULL, 0x040b620000041828ULL,
0x00000010ff5b7819ULL, 0x000fe4000001165bULL, 0x00000010ff5c7819ULL, 0x000fe4000001165cULL,
0x00000010ff567819ULL, 0x000fe4000001165dULL, 0x00000010ff387819ULL, 0x020fe2000001163cULL,
0x0000003a342c723cULL, 0x000b62000004182cULL, 0x00000010ff397819ULL, 0x000fc4000001164cULL,
0x00000010ff577819ULL, 0x000fe4000001165eULL, 0x00000010ff0f7819ULL, 0x000fe4000001160fULL,
0x00000010ff427819ULL, 0x000fe40000011642ULL, 0x00000010ff3a7819ULL, 0x020fe40000011619ULL,
0x00000010ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff187819ULL, 0x000fc40000011618ULL,
0x00000010ff3b7819ULL, 0x000fe4000001163dULL, 0x0000105439387816ULL, 0x000fe40000000038ULL,
0x000010545b567816ULL, 0x000fe40000000056ULL, 0x000010545c577816ULL, 0x000fe40000000057ULL,
0x0000105442397816ULL, 0x000fe2000000000fULL, 0x000000020c0f7824ULL, 0x000fe200078e00ffULL,
0x000010543a3a7816ULL, 0x000fc40000000043ULL, 0x00001054183b7816ULL, 0x000fe2000000003bULL,
0x00000056341c723cULL, 0x000b62000004181cULL, 0x0000f6c84d187811ULL, 0x000fe400078e18ffULL,
0xfffffff80f0f7812ULL, 0x000fca00078ec0ffULL, 0x000000383430723cULL, 0x040b700000041830ULL,
0x0000003a3434723cULL, 0x000b620000041810ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000018187f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f688000fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff387224ULL, 0x020fc600078e00ffULL, 0x0000000000107805ULL, 0x000fc80000015200ULL,
0x00000400060f7984ULL, 0x004ea40000000800ULL, 0x800000000fff7812ULL, 0x006fc40007804819ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011413ULL, 0x000000120f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x000000020f0f7819ULL, 0x000fc80000001212ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400060f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008044117810ULL, 0x000fca0007ffe0ffULL,
0x0000680050197a24ULL, 0x000fe200078e0211ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x000000110a0f7217ULL, 0x000fe20007800000ULL, 0x000000104f127824ULL, 0x000fe200078e00ffULL,
0x00000003ff107819ULL, 0x000fc6000001160bULL, 0x000000010f0f7824ULL, 0x000fe200078e0a11ULL,
0x0000000410137810ULL, 0x000fe20007ffe0ffULL, 0x0000000112187824ULL, 0x000fe200078e0210ULL,
0x0000000810397810ULL, 0x000fe40007ffe0ffULL, 0x0000000f120f7217ULL, 0x000fe20007800000ULL,
0x0000000118117824ULL, 0x040fe400078e020bULL, 0x0000000818387824ULL, 0x000fe400078e00ffULL,
0x000000010f0f7824ULL, 0x000fc400078e0a12ULL, 0x00000001123a7824ULL, 0x000fe200078e0239ULL,
0xfffffff8383b7812ULL, 0x000fe200078ee211ULL, 0x0000000112387824ULL, 0x000fe200078e0213ULL,
0x0000000f1300720cULL, 0x080fe40003f66070ULL, 0x0000000f1000720cULL, 0x080fe20003f86070ULL,
0x0000000138117824ULL, 0x000fe200078e020bULL, 0x0000000c10137810ULL, 0x000fe20007ffe0ffULL,
0x0000000118107824ULL, 0x000fe200078e0219ULL, 0x0000000f3900720cULL, 0x080fe20003f46070ULL,
0x0000000838187824ULL, 0x000fe200078e00ffULL, 0x0000000f1300720cULL, 0x000fe20003f06070ULL,
0x00000001123c7824ULL, 0x000fc400078e0213ULL, 0x0000000138127824ULL, 0x000fe200078e0219ULL,
0xfffffff8180f7812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x000000013a187824ULL, 0x000fe200078e0219ULL, 0x0000004e10107212ULL, 0x000fe200078efcffULL,
0x000000013a397824ULL, 0x040fe400078e020bULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe20007fbe0ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff83a3d7812ULL, 0x000fe200078ee239ULL, 0x000000013c387824ULL, 0x000fe200078e0219ULL,
0x0000004e12127212ULL, 0x080fe200078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fe40002ffe4ffULL, 0x0000640012127a10ULL, 0x000fe20007fbe0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000004e18187212ULL, 0x080fe400078efcffULL,
0x0000650013137a10ULL, 0x000fe20002ffe4ffULL, 0x000000013c3a7824ULL, 0x000fe200078e020bULL,
0x0000004e38387212ULL, 0x000fe200078efcffULL, 0x000000083c3f7824ULL, 0x000fe200078e00ffULL,
0x0000640018187a10ULL, 0x000fe20007fbe0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0252ULL,
0x0000640038387a10ULL, 0x000fe20007fde0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0252ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee23aULL, 0x000000103d3d7824ULL, 0x100fe200078e0252ULL,
0x0000650019197a10ULL, 0x000fe20002ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103b7faeULL, 0x0003e2000e101c46ULL, 0x0000650039397a10ULL, 0x000fe200037fe4ffULL,
0x000000103f3f7824ULL, 0x000fc400078e0252ULL, 0x00000000120f7faeULL, 0x0003e8000d901c46ULL,
0x00000000183d7faeULL, 0x0003e8000d101c46ULL, 0x00000000383f7faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000104f107824ULL, 0x000fca00078e00ffULL,
0x000000100b127211ULL, 0x000fc800078fe8ffULL, 0x0000000412387810ULL, 0x040fe20007ffe0ffULL,
0x00000001120f7824ULL, 0x140fe200078e020bULL, 0x0000000812187810ULL, 0x040fe20007ffe0ffULL,
0x00000008123a7824ULL, 0x000fe400078e00ffULL, 0x0000000138107824ULL, 0x040fe400078e020bULL,
0x00000008383b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a0f7812ULL, 0x000fe200078ee20fULL,
0x0000000118117824ULL, 0x000fe200078e020bULL, 0x0000000c123a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008183c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x0000000112107824ULL, 0x000fc400078e0219ULL, 0x0000000138387824ULL, 0x000fe200078e0219ULL,
0xfffffff83c3d7812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000118127824ULL, 0x100fe200078e0219ULL, 0x0000004e10107212ULL, 0x000fe200078efcffULL,
0x000000013a187824ULL, 0x000fe400078e0219ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fc60007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004e38387212ULL, 0x080fe400078efcffULL, 0x0000650011117a10ULL, 0x000fe200007fe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004e12127212ULL, 0x080fe400078efcffULL,
0x0000640038387a10ULL, 0x000fe20007f5e0ffULL, 0x000000013a3c7824ULL, 0x000fe200078e020bULL,
0x0000004e18187212ULL, 0x000fe200078efcffULL, 0x000000083a3f7824ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe20007f1e0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0252ULL,
0x0000640018187a10ULL, 0x000fe20007f7e0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0252ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee23cULL, 0x000000103d3d7824ULL, 0x100fe200078e0252ULL,
0x0000650039397a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000b901c46ULL, 0x0000650013137a10ULL, 0x000fe200007fe4ffULL,
0x000000103f3f7824ULL, 0x000fe200078e0252ULL, 0x0000650019197a10ULL, 0x000fe20001ffe4ffULL,
0x00000000383b7faeULL, 0x0003e8000b901c46ULL, 0x00000000123d7faeULL, 0x0003e8000b901c46ULL,
0x00000000183f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000104d0f7824ULL, 0x000fe200078e00ffULL, 0xffffffe008107812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000808117812ULL, 0x000fe400078ec0ffULL,
0x000000100f0f7812ULL, 0x000fc800078ec0ffULL, 0x00000010110f7210ULL, 0x000fe20007ffe00fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff127f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628000f387f8cULL, 0x0004e4000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x00f62c00050f7984ULL, 0x004ea40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804839ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x0000001810187210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e11ULL, 0x003d09001800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011419ULL,
0x000000180f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff187224ULL, 0x000fca00000e0619ULL,
0x000000020f0f7819ULL, 0x000fc80000001218ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013a3a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c00050f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000200c0f7824ULL, 0x000fca00078e00ffULL, 0xffffff800f0f7812ULL, 0x000fc800078ec0ffULL,
0x000000804e107810ULL, 0x000fca0007ffe00fULL, 0x0000000171107824ULL, 0x000fca00078e0210ULL,
0x00f0000010387984ULL, 0x000ea80000000800ULL, 0x00f20000100f7984ULL, 0x0006620000000800ULL,
0x0000000d3800720bULL, 0x004fe20003f1d000ULL, 0x0000f7527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000117806ULL, 0x008fc800000e0100ULL, 0x0000ffff113b7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff397424ULL, 0x000fd600078e00ffULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x0000000166117810ULL, 0x000fe40007ffe0ffULL,
0x0000000d3800720bULL, 0x000fe40003f54000ULL, 0x0000000c1100720cULL, 0x000fe20003f05270ULL,
0x0000f7027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000107806ULL, 0x000fc400010e0100ULL,
0x000000800c3a8824ULL, 0x000fe200078e024eULL, 0x0000000d38187209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991010117816ULL, 0x000fe200000000ffULL,
0x0000000171198824ULL, 0x000fca00078e023aULL, 0x00f4001819008388ULL, 0x0005e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000180d117221ULL, 0x004fe20000010000ULL, 0x000000ff10ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x0000001100397308ULL, 0x000ea40000000800ULL, 0x000000390e0e7220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe2000001160bULL,
0x0000f6327f007947ULL, 0x000fea000b800000ULL, 0x00001f1139117589ULL, 0x0004e400000e0000ULL,
0x0000001114147220ULL, 0x08cfe20000410000ULL, 0x0000001115157220ULL, 0x080fe20000410000ULL,
0x000000111c1c7220ULL, 0x080fe20000410000ULL, 0x000000111d1d7220ULL, 0x080fe20000410000ULL,
0x0000001120207220ULL, 0x080fe20000410000ULL, 0x0000001121217220ULL, 0x080fe20000410000ULL,
0x0000001124247220ULL, 0x080fe20000410000ULL, 0x0000001125257220ULL, 0x080fe20000410000ULL,
0x0000001128287220ULL, 0x080fe20000410000ULL, 0x0000001129297220ULL, 0x080fe20000410000ULL,
0x000000112c2c7220ULL, 0x080fe20000410000ULL, 0x000000112d2d7220ULL, 0x080fe20000410000ULL,
0x0000001130307220ULL, 0x080fe20000410000ULL, 0x0000001131317220ULL, 0x080fe20000410000ULL,
0x0000001134347220ULL, 0x080fe20000410000ULL, 0x0000001135357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080b117811ULL, 0x000fe200078ff0ffULL,
0x0000f5127f007947ULL, 0x000fea000b800000ULL, 0x00001f1139117589ULL, 0x0004e400000e0000ULL,
0x0000001116167220ULL, 0x08cfe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x080fe20000410000ULL,
0x000000112e2e7220ULL, 0x080fe20000410000ULL, 0x000000112f2f7220ULL, 0x080fe20000410000ULL,
0x0000001132327220ULL, 0x080fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806010ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x0000000d380d7209ULL, 0x000fd60007810000ULL,
0x8000000d38380221ULL, 0x000fe20000010000ULL, 0x00007610ff390816ULL, 0x000fc60000000039ULL,
0x3fb8aa3b38380820ULL, 0x000fc80000410000ULL, 0x0000003800040308ULL, 0x000ea40000000800ULL,
0x000000040f0f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000e0f0e7221ULL, 0x002fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0xfffffff0083a7812ULL, 0x000fca00078ec0ffULL, 0x00f6b4003a0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780481bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x0000001810187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e11ULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011419ULL, 0x000000180f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x000000020f0f7819ULL, 0x000fc80000001218ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b4003a0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910390f7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000004ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff107819ULL, 0x000fe4000001160bULL, 0x00005410020f7816ULL, 0x000fe20000000002ULL,
0x0000f0d27f007947ULL, 0x000fea000b800000ULL, 0x00001f100f037589ULL, 0x0002a400000e0000ULL,
0x0000000810117810ULL, 0x000fe20007ffe0ffULL, 0x0000f1027f007947ULL, 0x000fea000b800000ULL,
0x00001f110f027589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001010117810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000fULL,
0x00005d2000197802ULL, 0x000fc40000000f00ULL, 0x0000f91000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001810117810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00005d7000197802ULL, 0x000fc40000000f00ULL,
0x0000f8c000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000020c117824ULL, 0x00cfe200078e00ffULL, 0x000000070b197812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000411107812ULL, 0x002fc400078ec0ffULL,
0x0000000819187812ULL, 0x000fe400078ef80bULL, 0x000000100b0f7211ULL, 0x000fc600078fe0ffULL,
0x0000000818487824ULL, 0x040fe400078e00ffULL, 0x00000001180f7824ULL, 0x000fe200078e020fULL,
0x000000080b187812ULL, 0x000fc800078ec0ffULL, 0xfffffff848487812ULL, 0x000fca00078ee20fULL,
0x0000001048487824ULL, 0x000fc400078e0245ULL, 0x000000040c107824ULL, 0x000fe200078e00ffULL,
0x00000019183d7212ULL, 0x000fe200078efcffULL, 0x00000008004c7824ULL, 0x000fe200078e00ffULL,
0x0000100052537810ULL, 0x000fe20007ffe0ffULL, 0x00000008003f7824ULL, 0x000fe200078e00ffULL,
0x0000000410107812ULL, 0x000fe200078ec0ffULL, 0x000000083d197824ULL, 0x040fe400078e00ffULL,
0x000000083d3c7824ULL, 0x000fe200078e00ffULL, 0x000000100b107211ULL, 0x000fca00078fe0ffULL,
0x000000013d387824ULL, 0x100fe400078e0210ULL, 0x00000001003b7824ULL, 0x000fc600078e0210ULL,
0xfffffff819187812ULL, 0x000fe400078ee238ULL, 0x0000000238477810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee23bULL, 0x0000001018517824ULL, 0x000fe200078e0253ULL,
0x000000023b467810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83c477812ULL, 0x000fe400078ee247ULL,
0x000000005140783bULL, 0x000e620000004200ULL, 0xfffffff83f467812ULL, 0x000fc400078ee246ULL,
0x00000018ff387819ULL, 0x102fe40000011640ULL, 0x000000ff413a7812ULL, 0x000fe400078ec0ffULL,
0x00000038ff38723eULL, 0x000fe400020006ffULL, 0x0000003aff3b723eULL, 0x000fe400020006ffULL,
0x00000018ff3a7819ULL, 0x000fe20000011641ULL, 0x20000038ff4b7230ULL, 0x000fe20000004100ULL,
0x000000ff40187812ULL, 0x000fe200078ec0ffULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fc40000011640ULL, 0x0000003aff55723eULL, 0x000fe400020006ffULL,
0x00000010ff3a7819ULL, 0x000fe40000011641ULL, 0x000000ff38387812ULL, 0x000fe200078ec0ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x00000018ff39723eULL, 0x000fe400020006ffULL,
0x009800004818783bULL, 0x000e620000000200ULL, 0x000000ff3a3a7812ULL, 0x000fe400078ec0ffULL,
0x00000038ff38723eULL, 0x000fe200020006ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fc400020006ffULL, 0x0000ffff40567812ULL, 0x000fe200078ec0ffULL,
0x20000038ff387230ULL, 0x000fe20000004100ULL, 0x000000ff423c7812ULL, 0x000fe200078ec0ffULL,
0x2000003aff407230ULL, 0x000fe20000004100ULL, 0x0000ffff41417812ULL, 0x000fe400078ec0ffULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x00000010ff387819ULL, 0x000fe40000011638ULL,
0x00000008ff3a7819ULL, 0x000fc40000011656ULL, 0x0000003cff3c723eULL, 0x000fe400020006ffULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x00000010ff567819ULL, 0x000fe20000011640ULL,
0x2000003cff547230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x000fe2000001163bULL,
0x00000010473c7824ULL, 0x000fe200078e0253ULL, 0x0000105438407816ULL, 0x000fe40000000039ULL,
0x000000ff433d7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff387819ULL, 0x100fe40000011642ULL,
0x00000010ff397819ULL, 0x000fe40000011643ULL, 0x00000041ff57723eULL, 0x000fe400020006ffULL,
0x0000105456417816ULL, 0x000fe2000000003bULL, 0x000000104c3b7824ULL, 0x000fe200078e0253ULL,
0x0000003dff3d723eULL, 0x000fe200020006ffULL, 0x0000000318188231ULL, 0x082fe200003400ffULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x000000031a1a8231ULL, 0x000fe200003400ffULL,
0x000000ff38387812ULL, 0x000fe200078ec0ffULL, 0x2000003dff4a7230ULL, 0x000fe20000004100ULL,
0x000000ff39397812ULL, 0x000fe200078ec0ffULL, 0x2000003aff567230ULL, 0x000fe20000004100ULL,
0x00000038ff59723eULL, 0x000fe200020006ffULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x00000039ff5a723eULL, 0x000fe200020006ffULL, 0x0000000219198231ULL, 0x080fe200003400ffULL,
0x00000010ff4b7819ULL, 0x000fe2000001164bULL, 0x000000003b38783bULL, 0x000ea20000004200ULL,
0x000000021b1b8231ULL, 0x000fe200003400ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000018ff6e7819ULL, 0x000fe20000011642ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff587819ULL, 0x000fe20000011655ULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x00000010ff597819ULL, 0x000fe20000011659ULL, 0x000000401814723cULL, 0x000be20000041814ULL,
0x00000010ff557819ULL, 0x000fc4000001165aULL, 0x00000018ff6d7819ULL, 0x000fe40000011643ULL,
0x0000006eff6e723eULL, 0x000fe400020006ffULL, 0x00000010ff407819ULL, 0x020fe40000011656ULL,
0x00000010ff417819ULL, 0x000fe20000011657ULL, 0x2000006eff6e7230ULL, 0x000fe20000004100ULL,
0x000010544b407816ULL, 0x000fe40000000040ULL, 0x0000ffff424b7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff427819ULL, 0x000fe40000011654ULL, 0x00000010ff547819ULL, 0x000fe4000001164aULL,
0x0000ffff434a7812ULL, 0x000fe400078ec0ffULL, 0x0000105459427816ULL, 0x000fe40000000042ULL,
0x0000105455437816ULL, 0x000fe40000000054ULL, 0x00000008ff4b7819ULL, 0x000fc4000001164bULL,
0x00000008ff4a7819ULL, 0x000fe4000001164aULL, 0x0000105458417816ULL, 0x000fe20000000041ULL,
0x000000421820723cULL, 0x040be20000041820ULL, 0x000000ff3d697812ULL, 0x002fe400078ec0ffULL,
0x00000010ff587819ULL, 0x104fe40000011638ULL, 0x000000ff38677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff637819ULL, 0x000fe20000011638ULL, 0x00000040181c723cULL, 0x000f64000004181cULL,
0x0000ffff38437812ULL, 0x020fc400078ec0ffULL, 0x00000010ff577819ULL, 0x100fe40000011639ULL,
0x000000ff39687812ULL, 0x040fe400078ec0ffULL, 0x00000018ff647819ULL, 0x000fe40000011639ULL,
0x0000ffff39427812ULL, 0x000fe400078ec0ffULL, 0x00000018ff657819ULL, 0x000fe4000001163dULL,
0x0000006dff6d723eULL, 0x000fc400020006ffULL, 0x0000004bff38723eULL, 0x000fe400020006ffULL,
0x0000004aff39723eULL, 0x000fe200020006ffULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000010ff547819ULL, 0x100fe2000001163aULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x000000ff3a5e7812ULL, 0x040fe200078ec0ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x00000018ff5d7819ULL, 0x000fe4000001163aULL, 0x0000ffff3a597812ULL, 0x000fc400078ec0ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000065ff3a723eULL, 0x000fe400020006ffULL,
0x00000010ff557819ULL, 0x000fe2000001163cULL, 0x20000069ff657230ULL, 0x000fe20000004100ULL,
0x000000ff3c567812ULL, 0x000fe200078ec0ffULL, 0x2000003aff697230ULL, 0x000fe20000004100ULL,
0x00000010ff5a7819ULL, 0x000fe4000001163bULL, 0x000000ff3b5f7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001163bULL, 0x0000ffff3b5b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001163eULL, 0x00000010ff3b7819ULL, 0x000fe4000001166eULL,
0x00000010ff387819ULL, 0x000fe40000011638ULL, 0x00000010ff3a7819ULL, 0x000fc4000001166dULL,
0x00000010ff397819ULL, 0x000fe40000011639ULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x00000010ff617819ULL, 0x000fe4000001163dULL, 0x00000056ff4b723eULL, 0x000fe400020006ffULL,
0x0000006aff56723eULL, 0x000fe400020006ffULL, 0x000010543b387816ULL, 0x000fe20000000038ULL,
0x00000010463b7824ULL, 0x000fe200078e0253ULL, 0x000010543a397816ULL, 0x000fe20000000039ULL,
0x2000004bff4b7230ULL, 0x000fe20000004100ULL, 0x0000ffff3c607812ULL, 0x000fe200078ec0ffULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000055ff6a723eULL, 0x000fc400020006ffULL,
0x000000ff613a7812ULL, 0x000fe200078ec0ffULL, 0x000000381824723cULL, 0x000b620000041824ULL,
0x00000008ff617819ULL, 0x000fe20000011660ULL, 0x2000006aff607230ULL, 0x000fe20000004100ULL,
0x0000003aff6a723eULL, 0x000fe400020006ffULL, 0x000000003b38783bULL, 0x020e620000004200ULL,
0x00000018ff407819ULL, 0x000fe4000001163cULL, 0x000000ff3f6c7812ULL, 0x000fe200078ec0ffULL,
0x2000006aff6a7230ULL, 0x000fe20000004100ULL, 0x0000ffff3d627812ULL, 0x000fc400078ec0ffULL,
0x000000ff3e6b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x000fe4000001163eULL,
0x00000010ff3d7819ULL, 0x000fe4000001163fULL, 0x00000040ff40723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x20000040ff4a7230ULL, 0x000fe20000004100ULL, 0x000000ff3c3c7812ULL, 0x000fe200078ec0ffULL,
0x2000006cff557230ULL, 0x000fe20000004100ULL, 0x000000ff3d3d7812ULL, 0x000fe200078ec0ffULL,
0x2000006bff407230ULL, 0x000fe20000004100ULL, 0x00000008ff627819ULL, 0x000fc40000011662ULL,
0x0000003cff6c723eULL, 0x000fe400020006ffULL, 0x0000003dff6d723eULL, 0x000fe400020006ffULL,
0x00000061ff61723eULL, 0x000fe400020006ffULL, 0x00000062ff6b723eULL, 0x000fe400020006ffULL,
0x00000010ff3c7819ULL, 0x000fe2000001164bULL, 0x20000061ff627230ULL, 0x000fe20000004100ULL,
0x00000010ff3d7819ULL, 0x000fe20000011660ULL, 0x2000006bff4b7230ULL, 0x000fe20000004100ULL,
0x0000ffff3e3e7812ULL, 0x000fe200078ec0ffULL, 0x2000006dff607230ULL, 0x000fe20000004100ULL,
0x000010543d3c7816ULL, 0x000fc4000000003cULL, 0x00000010ff3d7819ULL, 0x000fe40000011665ULL,
0x00000010ff6a7819ULL, 0x000fe4000001166aULL, 0x00000008ff3e7819ULL, 0x000fe4000001163eULL,
0x000010546a3d7816ULL, 0x000fe4000000003dULL, 0x00000010ff657819ULL, 0x000fe4000001164aULL,
0x00000010ff6a7819ULL, 0x000fc40000011669ULL, 0x00000010ff4a7819ULL, 0x000fe20000011662ULL,
0x0000003c1828723cULL, 0x000b620000041828ULL, 0x00000010ff4b7819ULL, 0x000fe4000001164bULL,
0x0000003eff61723eULL, 0x000fe200020006ffULL, 0x2000006cff3e7230ULL, 0x000fe20000004100ULL,
0x00001054654a7816ULL, 0x000fe4000000004aULL, 0x000010546a4b7816ULL, 0x000fe2000000004bULL,
0x20000061ff617230ULL, 0x000fe20000004100ULL, 0x00000018ff417819ULL, 0x000fc4000001163fULL,
0x0000ffff3f3f7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3c7819ULL, 0x020fe20000011640ULL,
0x0000004a182c723cULL, 0x000b62000004182cULL, 0x00000010ff3d7819ULL, 0x000fe4000001163eULL,
0x00000010ff407819ULL, 0x000fe40000011655ULL, 0x00000010ff657819ULL, 0x000fe40000011660ULL,
0x00000008ff3f7819ULL, 0x000fc4000001163fULL, 0x00000010ff3e7819ULL, 0x000fe40000011661ULL,
0x000010543d3c7816ULL, 0x000fe4000000003cULL, 0x00001054653d7816ULL, 0x000fe40000000040ULL,
0x00000010ff4b7819ULL, 0x122fe40000011639ULL, 0x000000ff396f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6b7819ULL, 0x000fc40000011639ULL, 0x0000ffff39617812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4a7819ULL, 0x100fe40000011638ULL, 0x000000ff386e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fe40000011638ULL, 0x0000ffff38657812ULL, 0x000fe400078ec0ffULL,
0x0000005cff39723eULL, 0x000fc400020006ffULL, 0x000000ff58387812ULL, 0x000fe400078ec0ffULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000039ff587230ULL, 0x000fe20000004100ULL,
0x0000003fff3f723eULL, 0x000fe400020006ffULL, 0x00000010ff557819ULL, 0x000fe20000011656ULL,
0x20000041ff397230ULL, 0x000fe20000004100ULL, 0x00000038ff38723eULL, 0x000fe200020006ffULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff54547812ULL, 0x000fc400078ec0ffULL,
0x00001054553e7816ULL, 0x000fe4000000003eULL, 0x00000010ff627819ULL, 0x100fe4000001163aULL,
0x000000ff3a6c7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff697819ULL, 0x000fe4000001163aULL,
0x0000ffff3a567812ULL, 0x000fe400078ec0ffULL, 0x00000010ff557819ULL, 0x000fc4000001163bULL,
0x000000ff3b6d7812ULL, 0x040fe400078ec0ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001163bULL,
0x0000ffff3b407812ULL, 0x000fe400078ec0ffULL, 0x00000054ff41723eULL, 0x000fe200020006ffULL,
0x20000038ff547230ULL, 0x000fe20000004100ULL, 0x0000005eff3b723eULL, 0x000fe400020006ffULL,
0x0000005dff3a723eULL, 0x000fc400020006ffULL, 0x00000010ff387819ULL, 0x000fe20000011639ULL,
0x2000003bff5d7230ULL, 0x000fe20000004100ULL, 0x00000010ff3f7819ULL, 0x000fe4000001163fULL,
0x000000ff575c7812ULL, 0x000fe200078ec0ffULL, 0x2000003aff577230ULL, 0x000fe20000004100ULL,
0x00001054383f7816ULL, 0x000fe4000000003fULL, 0x0000003c1838723cULL, 0x000b620000041830ULL,
0x00000008ff727819ULL, 0x000fe20000011643ULL, 0x009800004930783bULL, 0x020e620000000200ULL,
0x00000008ff737819ULL, 0x000fc40000011642ULL, 0x00000063ff63723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe200020006ffULL, 0x0000003e1818723cULL, 0x000b620000041834ULL,
0x00000072ff72723eULL, 0x000fe200020006ffULL, 0x20000063ff637230ULL, 0x000fe20000004100ULL,
0x00000073ff73723eULL, 0x000fe200020006ffULL, 0x20000064ff647230ULL, 0x000fe20000004100ULL,
0x0000005fff5e723eULL, 0x000fe200020006ffULL, 0x20000072ff727230ULL, 0x000fe20000004100ULL,
0x000000ff5a427812ULL, 0x000fe200078ec0ffULL, 0x20000073ff737230ULL, 0x000fe20000004100ULL,
0x00000008ff5f7819ULL, 0x000fe20000011659ULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000008ff5b7819ULL, 0x000fc4000001165bULL, 0x00000067ff67723eULL, 0x000fe400020006ffULL,
0x00000010ff637819ULL, 0x000fe40000011663ULL, 0x00000010ff647819ULL, 0x000fe20000011664ULL,
0x20000067ff677230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x020fe40000011672ULL,
0x00000010ff357819ULL, 0x000fe40000011673ULL, 0x00000068ff68723eULL, 0x000fc400020006ffULL,
0x0000005cff5c723eULL, 0x000fe400020006ffULL, 0x00000042ff42723eULL, 0x000fe200020006ffULL,
0x20000068ff687230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x2000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x0000006eff59723eULL, 0x000fe200020006ffULL, 0x0000000330308231ULL, 0x082fe200003400ffULL,
0x0000105463347816ULL, 0x000fe20000000034ULL, 0x0000000332328231ULL, 0x000fe200003400ffULL,
0x0000105464357816ULL, 0x000fe20000000035ULL, 0x0000000231318231ULL, 0x080fe200003400ffULL,
0x20000041ff6e7230ULL, 0x000fe20000004100ULL, 0x0000000233338231ULL, 0x000fe200003400ffULL,
0x0000006fff5a723eULL, 0x000fe200020006ffULL, 0x20000042ff6f7230ULL, 0x000fe20000004100ULL,
0x00000060ff43723eULL, 0x000fe200020006ffULL, 0x2000005fff5f7230ULL, 0x000fe20000004100ULL,
0x00000069ff3c723eULL, 0x000fe200020006ffULL, 0x2000005bff607230ULL, 0x000fe20000004100ULL,
0x000000ff4a5b7812ULL, 0x000fe200078ec0ffULL, 0x00000034301c723cULL, 0x000b62000004181cULL,
0x000000ff4b697812ULL, 0x000fe200078ec0ffULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x00000008ff657819ULL, 0x000fe20000011665ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x00000010ff4a7819ULL, 0x000fe20000011667ULL, 0x20000043ff437230ULL, 0x000fe20000004100ULL,
0x00000010ff4b7819ULL, 0x000fe20000011654ULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000008ff617819ULL, 0x000fc40000011661ULL, 0x00000010ff367819ULL, 0x000fe4000001165dULL,
0x00000010ff377819ULL, 0x000fe4000001166eULL, 0x00000010ff687819ULL, 0x000fe40000011668ULL,
0x00000010ff677819ULL, 0x000fe4000001165cULL, 0x00000010ff5e7819ULL, 0x000fe4000001165eULL,
0x00000010ff6f7819ULL, 0x000fc4000001166fULL, 0x00000010ff577819ULL, 0x000fe40000011657ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff347819ULL, 0x020fe4000001165fULL,
0x00000010ff357819ULL, 0x000fe40000011660ULL, 0x0000005bff5b723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe200020006ffULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x20000069ff5c7230ULL, 0x000fe20000004100ULL, 0x000010544b4a7816ULL, 0x000fe2000000004aULL,
0x2000006bff497230ULL, 0x000fe20000004100ULL, 0x00000061ff3f723eULL, 0x000fe200020006ffULL,
0x20000065ff547230ULL, 0x000fe20000004100ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x00001054674b7816ULL, 0x000fe20000000068ULL, 0x2000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000010546f377816ULL, 0x000fc4000000005eULL, 0x0000105457347816ULL, 0x000fe40000000034ULL,
0x0000105458357816ULL, 0x000fe20000000035ULL, 0x0000004a3014723cULL, 0x040b620000041814ULL,
0x000000ff62627812ULL, 0x000fe400078ec0ffULL, 0x000000ff55557812ULL, 0x000fe400078ec0ffULL,
0x00000008ff567819ULL, 0x000fe40000011656ULL, 0x00000010ff5b7819ULL, 0x000fe2000001165bULL,
0x000000363020723cULL, 0x000b620000041820ULL, 0x00000010ff5c7819ULL, 0x000fc4000001165cULL,
0x00000008ff4b7819ULL, 0x020fe40000011640ULL, 0x00000010ff437819ULL, 0x000fe40000011643ULL,
0x00000010ff367819ULL, 0x000fe20000011659ULL, 0x000000343024723cULL, 0x000b620000041824ULL,
0x00000010ff377819ULL, 0x000fe4000001165aULL, 0x00000010ff407819ULL, 0x000fe40000011649ULL,
0x0000006cff42723eULL, 0x000fc400020006ffULL, 0x00000010ff347819ULL, 0x020fe40000011654ULL,
0x00000010ff357819ULL, 0x000fe2000001163fULL, 0x20000042ff427230ULL, 0x000fe20000004100ULL,
0x00000062ff3e723eULL, 0x000fe400020006ffULL, 0x0000006dff41723eULL, 0x000fe400020006ffULL,
0x00000055ff55723eULL, 0x000fe200020006ffULL, 0x2000003eff3e7230ULL, 0x000fe20000004100ULL,
0x00000056ff4a723eULL, 0x000fe200020006ffULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x0000006aff3d723eULL, 0x000fe200020006ffULL, 0x20000055ff557230ULL, 0x000fe20000004100ULL,
0x000010545b367816ULL, 0x000fe20000000036ULL, 0x2000004aff4a7230ULL, 0x000fe20000004100ULL,
0x000010545c377816ULL, 0x000fe20000000037ULL, 0x2000003dff3d7230ULL, 0x000fe20000004100ULL,
0x0000004bff4b723eULL, 0x000fc400020006ffULL, 0x0000105443347816ULL, 0x000fe40000000034ULL,
0x0000105440357816ULL, 0x000fe20000000035ULL, 0x2000004bff4b7230ULL, 0x000fe20000004100ULL,
0x000000363028723cULL, 0x000b620000041828ULL, 0x00000010ff417819ULL, 0x000fc60000011641ULL,
0x00000010ff4b7819ULL, 0x000fc6000001164bULL, 0x00000010ff367819ULL, 0x020fe20000011642ULL,
0x00000034302c723cULL, 0x000b62000004182cULL, 0x00000010ff377819ULL, 0x000fe4000001163eULL,
0x00000010ff3e7819ULL, 0x000fe40000011655ULL, 0x0000105437367816ULL, 0x000fe40000000036ULL,
0x00000010ff357819ULL, 0x020fe4000001163cULL, 0x00000010ff347819ULL, 0x000fc4000001164aULL,
0x00000010ff3c7819ULL, 0x000fe4000001163dULL, 0x000010543e377816ULL, 0x000fe40000000041ULL,
0x0000105435347816ULL, 0x000fe40000000034ULL, 0x000010543c357816ULL, 0x000fc6000000004bULL,
0x000000363038723cULL, 0x040f700000041838ULL, 0x000000343030723cULL, 0x000b6e0000041818ULL,
0xfffffff8111a7812ULL, 0x020fc400078ec0ffULL, 0x0000f6c84d187811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000018187f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f690001aff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff117224ULL, 0x000fc600078e00ffULL, 0x00000000001a7805ULL, 0x004fc80000015200ULL,
0x0000040006357984ULL, 0x000ea40000000800ULL, 0x8000000035ff7812ULL, 0x006fe40007804819ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x000000341a377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e1bULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c044197810ULL, 0x000fca0007ffe0ffULL,
0x0000680050377a24ULL, 0x000fe200078e0219ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x000000190a117217ULL, 0x000fe20007800000ULL, 0x000000104f1a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff187819ULL, 0x000fc6000001160bULL, 0x0000000111117824ULL, 0x000fe200078e0a19ULL,
0x00000004181b7810ULL, 0x000fe20007ffe0ffULL, 0x000000011a347824ULL, 0x000fe200078e0218ULL,
0x0000000818357810ULL, 0x000fe40007ffe0ffULL, 0x000000111a117217ULL, 0x000fe20007800000ULL,
0x0000000134197824ULL, 0x040fe400078e020bULL, 0x00000008343c7824ULL, 0x000fe400078e00ffULL,
0x0000000111117824ULL, 0x000fc400078e0a1aULL, 0x000000011a367824ULL, 0x000fe200078e021bULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee219ULL, 0x000000011a407824ULL, 0x000fe200078e0235ULL,
0x000000111b00720cULL, 0x080fe20003f66070ULL, 0x0000000136197824ULL, 0x000fe200078e020bULL,
0x000000111800720cULL, 0x080fe20003f86070ULL, 0x00000008363e7824ULL, 0x000fe200078e00ffULL,
0x0000000c181b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000134187824ULL, 0x100fe200078e0237ULL,
0x000000113500720cULL, 0x080fe20003f46070ULL, 0x0000000136347824ULL, 0x000fe200078e0237ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee219ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000111b00720cULL, 0x000fc60003f06070ULL, 0x000000011a427824ULL, 0x000fe200078e021bULL,
0x0000004e18187212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0x0000640018187a10ULL, 0x000fe20007fbe0ffULL, 0x0000000140367824ULL, 0x000fe200078e0237ULL,
0x0000004e34347212ULL, 0x000fe200078efcffULL, 0x0000000140117824ULL, 0x040fe200078e020bULL,
0x0000650019197a10ULL, 0x000fe20002ffe4ffULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0x0000640034347a10ULL, 0x000fe20007fbe0ffULL, 0x00000001421a7824ULL, 0x000fe400078e0237ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fc400078ee211ULL,
0x0000650035357a10ULL, 0x000fe20002ffe4ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004e36367212ULL, 0x000fc600078efcffULL, 0x0000000142117824ULL, 0x000fe200078e020bULL,
0x0000004e1a1a7212ULL, 0x000fe200078efcffULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0x0000640036367a10ULL, 0x000fe20007fbe0ffULL, 0x000000103e3d7824ULL, 0x100fe200078e0253ULL,
0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL, 0x00000010403f7824ULL, 0x000fe200078e0253ULL,
0xfffffff842427812ULL, 0x000fe200078ee211ULL, 0x000000103c117824ULL, 0x100fe200078e0253ULL,
0x0000650037377a10ULL, 0x000fe40002ffe4ffULL, 0x000065001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001042417824ULL, 0x000fe200078e0253ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018117faeULL, 0x0003e8000e101c46ULL, 0x00000000343d7faeULL, 0x0003e8000d901c46ULL,
0x00000000363f7faeULL, 0x0003e8000d101c46ULL, 0x000000001a417faeULL, 0x0003e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000104f187824ULL, 0x000fca00078e00ffULL,
0x000000180b187211ULL, 0x000fc800078fe8ffULL, 0x0000000818367810ULL, 0x040fe20007ffe0ffULL,
0x00000001181a7824ULL, 0x040fe200078e0237ULL, 0x0000000418347810ULL, 0x040fe20007ffe0ffULL,
0x0000000118117824ULL, 0x140fe200078e020bULL, 0x0000000c18427810ULL, 0x000fe20007ffe0ffULL,
0x00000001361b7824ULL, 0x140fe400078e020bULL, 0x0000000836407824ULL, 0x000fe400078e00ffULL,
0x0000000134197824ULL, 0x040fe400078e020bULL, 0x00000008343e7824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee21bULL, 0x0000000134347824ULL, 0x000fc400078e0237ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fc600078ee219ULL,
0x00000008183c7824ULL, 0x000fe200078e00ffULL, 0x0000004e1a1a7212ULL, 0x000fe200078efcffULL,
0x0000000136367824ULL, 0x100fe400078e0237ULL, 0x0000000142187824ULL, 0x000fe200078e0237ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x000064001a1a7a10ULL, 0x000fc60007f1e0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000004e34347212ULL, 0x080fe400078efcffULL, 0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004e36367212ULL, 0x080fe400078efcffULL,
0x0000640034347a10ULL, 0x000fe20007f5e0ffULL, 0x0000000142117824ULL, 0x000fe200078e020bULL,
0x0000004e18187212ULL, 0x000fe200078efcffULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0x0000640036367a10ULL, 0x000fe20007f1e0ffULL, 0x000000103e3d7824ULL, 0x100fe200078e0253ULL,
0x0000640018187a10ULL, 0x000fe20007f7e0ffULL, 0x00000010403f7824ULL, 0x000fe200078e0253ULL,
0xfffffff842427812ULL, 0x000fe200078ee211ULL, 0x000000103c117824ULL, 0x000fe200078e0253ULL,
0x0000650035357a10ULL, 0x000fc400017fe4ffULL, 0x0000650037377a10ULL, 0x000fe200007fe4ffULL,
0x0000001042417824ULL, 0x000fe200078e0253ULL, 0x0000650019197a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a117faeULL, 0x0003e8000b901c46ULL,
0x00000000343d7faeULL, 0x0003e8000b901c46ULL, 0x00000000363f7faeULL, 0x0003e8000b901c46ULL,
0x0000000018417faeULL, 0x0003e4000b901c46ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff0081a7812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b0001a1a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480005187f8cULL, 0x0004e4000c80043fULL,
0x0000000000347805ULL, 0x000fc40000015200ULL, 0xffffffe008057812ULL, 0x044fe400078ec0ffULL,
0x0000001008367812ULL, 0x040fe400078ec0ffULL, 0x0000000808117812ULL, 0x000fc800078ec0ffULL,
0x0000000511057210ULL, 0x000fca0007ffe036ULL, 0x00f64c0005117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x00cfe40007804819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011437ULL, 0x0000003611117211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x0000000211117819ULL, 0x000fc80000001236ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c0005117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000200c057824ULL, 0x000fca00078e00ffULL,
0xffffff8005057812ULL, 0x000fc800078ec0ffULL, 0x000001004e187810ULL, 0x000fca0007ffe005ULL,
0x0000000171187824ULL, 0x000fca00078e0218ULL, 0x00f0000018347984ULL, 0x000ea80000000800ULL,
0x00f2000018357984ULL, 0x0006620000000800ULL, 0x0000000d3400720bULL, 0x004fe20003f1d000ULL,
0x0000caa27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x008fc800000e0100ULL,
0x0000ffff11367812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff117424ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fd200078e000dULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000266057810ULL, 0x000fe40007ffe0ffULL,
0x0000000d3400720bULL, 0x000fe40003f54000ULL, 0x0000000c0500720cULL, 0x000fe20003f05270ULL,
0x0000ca427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000057806ULL, 0x000fc400010e0100ULL,
0x000000800c188824ULL, 0x000fe200078e024eULL, 0x0000000d34118209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x00000001713c8824ULL, 0x000fe200078e0218ULL,
0x0000991005187816ULL, 0x000fc800000000ffULL, 0x00f400113c008388ULL, 0x0005e20000000800ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000d34187209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff05ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000d18117221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100377308ULL, 0x000ea40000000800ULL,
0x000000370e0e7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe2000001160bULL, 0x0000c9627f007947ULL, 0x000fea000b800000ULL,
0x00001f1137117589ULL, 0x0004e400000e0000ULL, 0x0000001114147220ULL, 0x08cfe20000410000ULL,
0x0000001115157220ULL, 0x080fe20000410000ULL, 0x000000111c1c7220ULL, 0x080fe20000410000ULL,
0x000000111d1d7220ULL, 0x080fe20000410000ULL, 0x0000001120207220ULL, 0x080fe20000410000ULL,
0x0000001121217220ULL, 0x080fe20000410000ULL, 0x0000001124247220ULL, 0x080fe20000410000ULL,
0x0000001125257220ULL, 0x080fe20000410000ULL, 0x0000001128287220ULL, 0x080fe20000410000ULL,
0x0000001129297220ULL, 0x080fe20000410000ULL, 0x000000112c2c7220ULL, 0x080fe20000410000ULL,
0x000000112d2d7220ULL, 0x080fe20000410000ULL, 0x0000001138387220ULL, 0x080fe20000410000ULL,
0x0000001139397220ULL, 0x080fe20000410000ULL, 0x0000001130307220ULL, 0x080fe20000410000ULL,
0x0000001131317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0005ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080b117811ULL, 0x000fe200078ff0ffULL, 0x0000c8427f007947ULL, 0x000fea000b800000ULL,
0x00001f1137117589ULL, 0x0004e400000e0000ULL, 0x0000001116167220ULL, 0x08cfe20000410000ULL,
0x0000001117177220ULL, 0x080fe20000410000ULL, 0x000000111e1e7220ULL, 0x080fe20000410000ULL,
0x000000111f1f7220ULL, 0x080fe20000410000ULL, 0x0000001122227220ULL, 0x080fe20000410000ULL,
0x0000001123237220ULL, 0x080fe20000410000ULL, 0x0000001126267220ULL, 0x080fe20000410000ULL,
0x0000001127277220ULL, 0x080fe20000410000ULL, 0x000000112a2a7220ULL, 0x080fe20000410000ULL,
0x000000112b2b7220ULL, 0x080fe20000410000ULL, 0x000000112e2e7220ULL, 0x080fe20000410000ULL,
0x000000112f2f7220ULL, 0x080fe20000410000ULL, 0x000000113a3a7220ULL, 0x080fe20000410000ULL,
0x000000113b3b7220ULL, 0x080fe20000410000ULL, 0x0000001132327220ULL, 0x080fe20000410000ULL,
0x0000001133337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff36ff7812ULL, 0x000fe20007806005ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000d34057209ULL, 0x000fd60007810000ULL, 0x8000000534340221ULL, 0x000fe20000010000ULL,
0x00007610ff110816ULL, 0x000fc60000000011ULL, 0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL,
0x0000003400040308ULL, 0x000ea40000000800ULL, 0x0000000435350220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e350e7221ULL, 0x002fc20000010000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0xfffffff008377812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00370d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003418347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e19ULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011435ULL,
0x000000340d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x000000020d0d7819ULL, 0x000fc80000001234ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00370d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910110d7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000004ff02723eULL, 0x000fe400000010ffULL, 0x00000002ff127819ULL, 0x000fe4000001160bULL,
0x00005410020d7816ULL, 0x000fe20000000002ULL, 0x0000c4027f007947ULL, 0x000fea000b800000ULL,
0x00001f120d037589ULL, 0x0002a400000e0000ULL, 0x0000000812117810ULL, 0x000fe20007ffe0ffULL,
0x0000c4327f007947ULL, 0x000fea000b800000ULL, 0x00001f110d027589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001012117810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x00008bb000197802ULL, 0x000fc40000000f00ULL,
0x0000ca8000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001812117810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x00008c0000197802ULL, 0x000fc40000000f00ULL, 0x0000ca3000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001047347824ULL, 0x100fe200078e0252ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000010463c7824ULL, 0x000fe200078e0252ULL,
0x000000080b127812ULL, 0x002fc400078ec0ffULL, 0x000000070b187812ULL, 0x000fe200078ec0ffULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x0000000712597812ULL, 0x100fe400078ef80bULL,
0x0000000818437812ULL, 0x000fe200078ef80bULL, 0x000000003c3c783bULL, 0x000f220000004200ULL,
0x000000020f0d7810ULL, 0x008fe20007ffe0ffULL, 0x0000000159107824ULL, 0x000fe200078e0210ULL,
0x00000010ff477819ULL, 0x002fe40000011634ULL, 0x000000ff34587812ULL, 0x000fc400078ec0ffULL,
0x00000018ff137819ULL, 0x000fe40000011634ULL, 0x0000ffff345c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011635ULL, 0x000000ff355d7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff5b7819ULL, 0x000fe40000011635ULL, 0x0000ffff355f7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff347819ULL, 0x100fe40000011636ULL, 0x000000ff36617812ULL, 0x040fe400078ec0ffULL,
0x00000018ff407819ULL, 0x000fe40000011636ULL, 0x0000ffff36427812ULL, 0x000fe400078ec0ffULL,
0x00000010ff357819ULL, 0x000fe40000011637ULL, 0x000000ff37557812ULL, 0x000fc400078ec0ffULL,
0x00000018ff367819ULL, 0x000fe40000011637ULL, 0x0000ffff375a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff3c377812ULL, 0x010fe400078ec0ffULL, 0x000000ff3d577812ULL, 0x000fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe4000001163cULL, 0x00000010ff197819ULL, 0x000fc4000001163dULL,
0x00000018ff497819ULL, 0x000fe4000001163dULL, 0x0000ffff3d117812ULL, 0x004fe200078ec0ffULL,
0x00000008593d7824ULL, 0x000fe200078e00ffULL, 0x000000ff3e4b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff4a7819ULL, 0x000fe4000001163eULL, 0x00000036ff36723eULL, 0x000fe400020006ffULL,
0x00000037ff37723eULL, 0x000fc400020006ffULL, 0x00000010ff127819ULL, 0x000fe4000001163eULL,
0x0000ffff3e567812ULL, 0x000fe400078ec0ffULL, 0x00000057ff57723eULL, 0x000fe400020006ffULL,
0x00000010ff3e7819ULL, 0x100fe4000001163fULL, 0x000000ff3f547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff607819ULL, 0x000fc4000001163fULL, 0x0000ffff3f597812ULL, 0x000fe400078ec0ffULL,
0x00000058ff58723eULL, 0x000fe400020006ffULL, 0x00000046ff46723eULL, 0x000fe400020006ffULL,
0x00000010ff417819ULL, 0x000fe4000001163cULL, 0x0000ffff3c187812ULL, 0x000fe200078ec0ffULL,
0x00000008433c7824ULL, 0x000fe200078e00ffULL, 0x00000040ff3f723eULL, 0x000fe200020006ffULL,
0x20000036ff407230ULL, 0x000fe20000004100ULL, 0x00000049ff49723eULL, 0x000fe200020006ffULL,
0x20000037ff367230ULL, 0x000fe20000004100ULL, 0x0000004bff4b723eULL, 0x000fe200020006ffULL,
0x20000057ff377230ULL, 0x000fe20000004100ULL, 0x0000004aff4a723eULL, 0x000fe200020006ffULL,
0x20000046ff577230ULL, 0x000fe20000004100ULL, 0xfffffff83d437812ULL, 0x000fe200078ee210ULL,
0x2000003fff3f7230ULL, 0x000fe20000004100ULL, 0x0000005bff10723eULL, 0x000fe200020006ffULL,
0x20000058ff5b7230ULL, 0x000fe20000004100ULL, 0x00000055ff3d723eULL, 0x000fe200020006ffULL,
0x20000049ff587230ULL, 0x000fe20000004100ULL, 0x00000054ff55723eULL, 0x000fe200020006ffULL,
0x2000004bff547230ULL, 0x000fe20000004100ULL, 0x00000008ff5f7819ULL, 0x000fe2000001165fULL,
0x2000004aff467230ULL, 0x000fe20000004100ULL, 0x000000ff34347812ULL, 0x000fe200078ec0ffULL,
0x00a000004848783bULL, 0x000e620000000200ULL, 0x000000ff47477812ULL, 0x000fe200078ec0ffULL,
0x20000010ff107230ULL, 0x000fe20000004100ULL, 0x000000ff5e5e7812ULL, 0x000fe200078ec0ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000055ff557230ULL, 0x000fe20000004100ULL, 0x0000005dff5d723eULL, 0x000fc400020006ffULL,
0x00000008ff5c7819ULL, 0x000fe4000001165cULL, 0x000000ff35357812ULL, 0x000fe200078ec0ffULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x00000008ff427819ULL, 0x000fe40000011642ULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0xfffffff83c0d7812ULL, 0x000fc400078ee20dULL, 0x00000047ff62723eULL, 0x000fe400020006ffULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x000000100d0d7824ULL, 0x000fe200078e00ffULL,
0x000000ff41417812ULL, 0x000fe200078ec0ffULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000061ff3c723eULL, 0x000fe200020006ffULL, 0x2000005fff617230ULL, 0x000fe20000004100ULL,
0x00000060ff60723eULL, 0x000fe200020006ffULL, 0x20000034ff5f7230ULL, 0x000fe20000004100ULL,
0x0000005cff5c723eULL, 0x000fe200020006ffULL, 0x2000005eff637230ULL, 0x000fe20000004100ULL,
0x00000035ff35723eULL, 0x000fe200020006ffULL, 0x20000060ff477230ULL, 0x000fe20000004100ULL,
0x00000042ff42723eULL, 0x000fe200020006ffULL, 0x2000005cff607230ULL, 0x000fe20000004100ULL,
0x0000005aff5a723eULL, 0x000fe200020006ffULL, 0x20000035ff5e7230ULL, 0x000fe20000004100ULL,
0x00000041ff34723eULL, 0x000fe200020006ffULL, 0x20000042ff417230ULL, 0x000fe20000004100ULL,
0x00000013ff13723eULL, 0x000fe200020006ffULL, 0x2000005aff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff19197812ULL, 0x000fe200078ec0ffULL, 0x20000034ff427230ULL, 0x000fe20000004100ULL,
0x00000008ff187819ULL, 0x000fe20000011618ULL, 0x20000013ff137230ULL, 0x000fe20000004100ULL,
0x00000010ff357819ULL, 0x000fe2000001165dULL, 0x2000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000019ff64723eULL, 0x000fe200020006ffULL, 0x0000000348488231ULL, 0x082fe200003400ffULL,
0x00000018ff5a723eULL, 0x000fe200020006ffULL, 0x000000034a4a8231ULL, 0x000fe200003400ffULL,
0x00000008ff5d7819ULL, 0x000fe20000011611ULL, 0x0000000249498231ULL, 0x080fe200003400ffULL,
0x00000010ff347819ULL, 0x000fe2000001165bULL, 0x000000024b4b8231ULL, 0x000fe200003400ffULL,
0x00000010ff197819ULL, 0x000fe20000011662ULL, 0x20000064ff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x000fe20000011663ULL, 0x2000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000a00045117810ULL, 0x000fc40007ffe00dULL, 0x0000105419347816ULL, 0x000fe40000000034ULL,
0x0000105418357816ULL, 0x000fe40000000035ULL, 0x000000ff12637812ULL, 0x000fe400078ec0ffULL,
0x00000010ff197819ULL, 0x000fe40000011613ULL, 0x00000010ff627819ULL, 0x000fe20000011610ULL,
0x000000344828723cULL, 0x000b620000041828ULL, 0x00000010ff187819ULL, 0x000fe20000011660ULL,
0x000000001110783bULL, 0x000e620000000200ULL, 0x00000010ff617819ULL, 0x000fc40000011661ULL,
0x0000105419187816ULL, 0x000fe40000000018ULL, 0x0000105462197816ULL, 0x000fe20000000061ULL,
0x0000001043347824ULL, 0x020fe200078e0252ULL, 0x00000010ff3c7819ULL, 0x000fe4000001163cULL,
0x00000010ff3d7819ULL, 0x000fe4000001163dULL, 0x00000010ff5f7819ULL, 0x000fe2000001165fULL,
0x00000018482c723cULL, 0x000b62000004182cULL, 0x00000010ff5e7819ULL, 0x000fc4000001165eULL,
0x000010545f3c7816ULL, 0x000fe4000000003cULL, 0x000010545e3d7816ULL, 0x000fe4000000003dULL,
0x00000010ff187819ULL, 0x020fe40000011640ULL, 0x00000010ff407819ULL, 0x000fe40000011641ULL,
0x000000ff3e3e7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff3f7819ULL, 0x000fc4000001163fULL,
0x00000010ff417819ULL, 0x000fe2000001165cULL, 0x000000104c5c7824ULL, 0x000fe200078e0252ULL,
0x0000003eff35723eULL, 0x000fe400020006ffULL, 0x000010543f407816ULL, 0x000fe40000000040ULL,
0x0000003c483c723cULL, 0x000b620000041838ULL, 0x00000010ff197819ULL, 0x000fe20000011642ULL,
0x000000005c38783bULL, 0x020fe20000004200ULL, 0x0000105418417816ULL, 0x000fe40000000041ULL,
0x00000010ff427819ULL, 0x000fe2000001165bULL, 0x20000035ff5b7230ULL, 0x000fe20000004100ULL,
0x00000010ff187819ULL, 0x000fe20000011636ULL, 0x0000000310108231ULL, 0x082fe200003400ffULL,
0x00000010ff437819ULL, 0x000fe20000011637ULL, 0x0000000312128231ULL, 0x000fe200003400ffULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x0000005dff5d723eULL, 0x000fe200020006ffULL,
0x0000000211118231ULL, 0x080fe200003400ffULL, 0x00000063ff45723eULL, 0x000fe200020006ffULL,
0x0000000213138231ULL, 0x000fe200003400ffULL, 0x0000105419187816ULL, 0x000fe20000000018ULL,
0x2000005dff5d7230ULL, 0x000fe20000004100ULL, 0x00000008ff567819ULL, 0x000fe20000011656ULL,
0x20000045ff457230ULL, 0x000fe20000004100ULL, 0x0000105442197816ULL, 0x000fc40000000043ULL,
0x00000008ff597819ULL, 0x000fe20000011659ULL, 0x000000404840723cULL, 0x000b620000041830ULL,
0x00000010ff577819ULL, 0x000fe40000011657ULL, 0x00000010ff587819ULL, 0x000fe40000011658ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000010ff307819ULL, 0x020fe2000001165aULL,
0x000000181028723cULL, 0x000be20000041828ULL, 0x00000010ff317819ULL, 0x000fe2000001165dULL,
0x20000056ff567230ULL, 0x000fe20000004100ULL, 0x00000059ff59723eULL, 0x000fc400020006ffULL,
0x0000105457307816ULL, 0x000fe40000000030ULL, 0x0000105458317816ULL, 0x000fe20000000031ULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000010ff327819ULL, 0x000fe40000011654ULL,
0x00000010ff337819ULL, 0x000fe40000011655ULL, 0x00000010ff457819ULL, 0x000fe20000011645ULL,
0x00000030102c723cULL, 0x000be4000004182cULL, 0x00000010ff187819ULL, 0x020fc4000001165bULL,
0x0000105445327816ULL, 0x000fe40000000032ULL, 0x0000105418337816ULL, 0x000fe40000000033ULL,
0x00000010ff197819ULL, 0x000fe40000011646ULL, 0x00000010ff187819ULL, 0x000fe40000011656ULL,
0x00000010ff307819ULL, 0x000fe40000011647ULL, 0x00000010ff597819ULL, 0x000fc40000011659ULL,
0x0000105419187816ULL, 0x000fe40000000018ULL, 0x0000105430197816ULL, 0x000fe40000000059ULL,
0x000000321030723cULL, 0x000be2000004183cULL, 0x00000010ff5a7819ULL, 0x102fe40000011634ULL,
0x000000ff34457812ULL, 0x000fe400078ec0ffULL, 0x00000018ff637819ULL, 0x000fe40000011634ULL,
0x000000ff393d7812ULL, 0x020fc400078ec0ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001163bULL,
0x000000ff383c7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff345c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe40000011635ULL, 0x000000ff35687812ULL, 0x000fe400078ec0ffULL,
0x00000018ff657819ULL, 0x000fc40000011635ULL, 0x0000ffff355f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5d7819ULL, 0x100fe40000011636ULL, 0x000000ff36647812ULL, 0x040fe400078ec0ffULL,
0x00000018ff627819ULL, 0x000fe40000011636ULL, 0x0000ffff36597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff607819ULL, 0x000fc40000011637ULL, 0x000000ff37677812ULL, 0x040fe400078ec0ffULL,
0x00000018ff617819ULL, 0x000fe40000011637ULL, 0x0000ffff375b7812ULL, 0x000fe400078ec0ffULL,
0x0000003dff54723eULL, 0x000fe200020006ffULL, 0x000000181034723cULL, 0x000be20000041840ULL,
0x0000003eff3d723eULL, 0x000fe400020006ffULL, 0x00000018ff3e7819ULL, 0x000fe20000011639ULL,
0x20000054ff547230ULL, 0x000fe20000004100ULL, 0x0000003cff47723eULL, 0x000fe200020006ffULL,
0x2000003dff3d7230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x020fc40000011638ULL,
0x00000010ff407819ULL, 0x000fe20000011639ULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x0000ffff39397812ULL, 0x000fe400078ec0ffULL, 0x00000018ff3c7819ULL, 0x000fe40000011638ULL,
0x000000ff3a427812ULL, 0x000fe400078ec0ffULL, 0x000000ff3b437812ULL, 0x000fe400078ec0ffULL,
0x000000ff19197812ULL, 0x000fc400078ec0ffULL, 0x00000010ff187819ULL, 0x100fe4000001163aULL,
0x00000018ff3f7819ULL, 0x000fe4000001163aULL, 0x0000ffff3a587812ULL, 0x000fe400078ec0ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x00000008ff397819ULL, 0x000fe40000011639ULL,
0x0000003cff3c723eULL, 0x000fc400020006ffULL, 0x00000042ff3a723eULL, 0x000fe400020006ffULL,
0x0000ffff38387812ULL, 0x000fe200078ec0ffULL, 0x2000003cff427230ULL, 0x000fe20000004100ULL,
0x00000010ff577819ULL, 0x000fe4000001163bULL, 0x0000ffff3b417812ULL, 0x000fe400078ec0ffULL,
0x00000043ff3b723eULL, 0x000fe200020006ffULL, 0x2000003eff437230ULL, 0x000fe20000004100ULL,
0x00000019ff19723eULL, 0x000fe200020006ffULL, 0x2000003aff3e7230ULL, 0x000fe20000004100ULL,
0x00000039ff39723eULL, 0x000fc400020006ffULL, 0x00000008ff387819ULL, 0x000fe20000011638ULL,
0x20000019ff557230ULL, 0x000fe20000004100ULL, 0x0000003fff3c723eULL, 0x000fe200020006ffULL,
0x2000003bff3f7230ULL, 0x000fe20000004100ULL, 0x000000ff5a3a7812ULL, 0x000fe200078ec0ffULL,
0x20000039ff467230ULL, 0x000fe20000004100ULL, 0x000000ff40407812ULL, 0x000fe200078ec0ffULL,
0x2000003cff3c7230ULL, 0x000fe20000004100ULL, 0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff18197812ULL, 0x000fc400078ec0ffULL, 0x00000062ff3b723eULL, 0x000fe400020006ffULL,
0x00000038ff18723eULL, 0x000fe400020006ffULL, 0x00000068ff39723eULL, 0x000fe200020006ffULL,
0x2000003bff5a7230ULL, 0x000fe20000004100ULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x00000045ff38723eULL, 0x000fe200020006ffULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x0000003aff3a723eULL, 0x000fe200020006ffULL, 0x20000018ff457230ULL, 0x000fe20000004100ULL,
0x00000040ff40723eULL, 0x000fe200020006ffULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00000061ff61723eULL, 0x000fe200020006ffULL, 0x2000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000005eff5e723eULL, 0x000fe200020006ffULL, 0x20000040ff567230ULL, 0x000fe20000004100ULL,
0x00000019ff19723eULL, 0x000fc400020006ffULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x2000005eff5e7230ULL, 0x000fe20000004100ULL, 0x00000008ff3b7819ULL, 0x000fe2000001165cULL,
0x20000061ff5c7230ULL, 0x000fe20000004100ULL, 0x00000065ff18723eULL, 0x000fe200020006ffULL,
0x20000019ff407230ULL, 0x000fe20000004100ULL, 0x000000ff60617812ULL, 0x000fe200078ec0ffULL,
0x2000005fff607230ULL, 0x000fe20000004100ULL, 0x00000063ff19723eULL, 0x000fe200020006ffULL,
0x20000018ff187230ULL, 0x000fe20000004100ULL, 0x0000003bff3b723eULL, 0x000fc400020006ffULL,
0x00000010ff5f7819ULL, 0x000fe20000011639ULL, 0x20000019ff197230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x000fe20000011638ULL, 0x2000003bff3b7230ULL, 0x000fe20000004100ULL,
0x00000010ff397819ULL, 0x000fe4000001163aULL, 0x00000010ff3a7819ULL, 0x000fe4000001165eULL,
0x0000105439387816ULL, 0x000fe40000000038ULL, 0x000010543a397816ULL, 0x000fc4000000005fULL,
0x000000ff5d5d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff3a7819ULL, 0x000fe40000011659ULL,
0x00000008ff5f7819ULL, 0x000fe4000001165bULL, 0x00000010ff597819ULL, 0x000fe40000011618ULL,
0x00000010ff197819ULL, 0x000fe40000011619ULL, 0x00000010ff187819ULL, 0x000fc4000001163bULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000064ff63723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000067ff67723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000061ff61723eULL, 0x000fe200020006ffULL,
0x2000005dff5e7230ULL, 0x000fe20000004100ULL, 0x0000003aff5b723eULL, 0x000fe200020006ffULL,
0x20000067ff627230ULL, 0x000fe20000004100ULL, 0x0000005fff5f723eULL, 0x000fe200020006ffULL,
0x20000061ff5d7230ULL, 0x000fe20000004100ULL, 0x0000105419187816ULL, 0x000fe20000000018ULL,
0x2000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000105459197816ULL, 0x000fe20000000060ULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x000000384838723cULL, 0x000b620000041814ULL,
0x00000010ff627819ULL, 0x000fc40000011662ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x00000010ff5c7819ULL, 0x000fe4000001165cULL, 0x00000010ff147819ULL, 0x020fe20000011663ULL,
0x00000018481c723cULL, 0x000b62000004181cULL, 0x00000010ff157819ULL, 0x000fe4000001165eULL,
0x00000010ff177819ULL, 0x000fe4000001165aULL, 0x0000105415147816ULL, 0x000fc40000000014ULL,
0x00000010ff187819ULL, 0x020fe4000001165bULL, 0x00000010ff197819ULL, 0x000fe4000001165fULL,
0x000010545d157816ULL, 0x000fe40000000062ULL, 0x0000105417187816ULL, 0x000fe40000000018ULL,
0x000010545c197816ULL, 0x000fe40000000019ULL, 0x000000ff57577812ULL, 0x000fe200078ec0ffULL,
0x000000144814723cULL, 0x000b620000041820ULL, 0x00000008ff587819ULL, 0x000fc40000011658ULL,
0x00000008ff417819ULL, 0x000fe40000011641ULL, 0x00000010ff557819ULL, 0x000fe40000011655ULL,
0x00000010ff207819ULL, 0x020fe20000011647ULL, 0x000000184824723cULL, 0x000b620000041824ULL,
0x00000010ff217819ULL, 0x000fe40000011654ULL, 0x00000010ff567819ULL, 0x000fe40000011656ULL,
0x00000010ff437819ULL, 0x000fc40000011643ULL, 0x00000010ff197819ULL, 0x020fe40000011642ULL,
0x00000010ff187819ULL, 0x000fe40000011645ULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000057ff57723eULL, 0x000fe400020006ffULL, 0x00000058ff58723eULL, 0x000fe400020006ffULL,
0x00000041ff41723eULL, 0x000fe200020006ffULL, 0x20000057ff577230ULL, 0x000fe20000004100ULL,
0x0000105455207816ULL, 0x000fe20000000020ULL, 0x20000058ff587230ULL, 0x000fe20000004100ULL,
0x0000105456217816ULL, 0x000fe20000000021ULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x0000105419187816ULL, 0x000fc40000000018ULL, 0x0000105443197816ULL, 0x000fe40000000046ULL,
0x00000010ff3f7819ULL, 0x000fe2000001163fULL, 0x000000201020723cULL, 0x000b620000041838ULL,
0x00000010ff587819ULL, 0x000fe40000011658ULL, 0x00000010ff417819ULL, 0x000fc80000011641ULL,
0x00000010ff387819ULL, 0x020fe2000001163eULL, 0x00000018101c723cULL, 0x000b62000004181cULL,
0x00000010ff397819ULL, 0x000fe40000011640ULL, 0x00000010ff3a7819ULL, 0x000fe40000011657ULL,
0x0000105439387816ULL, 0x000fe40000000038ULL, 0x00000010ff197819ULL, 0x020fe4000001163cULL,
0x00000010ff187819ULL, 0x000fc4000001163dULL, 0x000010543a397816ULL, 0x000fe4000000003fULL,
0x0000105419587816ULL, 0x000fe40000000058ULL, 0x0000105418597816ULL, 0x000fc60000000041ULL,
0x000000381014723cULL, 0x040f700000041814ULL, 0x000000581024723cULL, 0x000b6e0000041824ULL,
0x0000f69866127811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000006107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000012ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff387224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x008fc80000015200ULL, 0x0000040006197984ULL, 0x000ee40000000800ULL,
0x8000000019ff7812ULL, 0x00cfc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0x0000001812397210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e13ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011419ULL,
0x0000003918187211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000218187819ULL, 0x000fc80000001219ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000107107810ULL, 0x000fc80007ffe0ffULL, 0x000000091000720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x0000000207107810ULL, 0x000fe40007ffe0ffULL,
0x0000010044117810ULL, 0x000fe40007ffe0ffULL, 0x000000091000720cULL, 0x000fc60003f06070ULL,
0x0000680050197a24ULL, 0x000fd400078e0211ULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x000000110a107217ULL, 0x000fe20007800000ULL, 0x000000104f137824ULL, 0x000fe200078e00ffULL,
0x00000003ff127819ULL, 0x000fc6000001160bULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000000412387810ULL, 0x040fe20007ffe0ffULL, 0x0000000113187824ULL, 0x040fe200078e0212ULL,
0x0000000812397810ULL, 0x000fe40007ffe0ffULL, 0x0000001013107217ULL, 0x000fe20007800000ULL,
0x0000000118117824ULL, 0x000fe200078e020bULL, 0x0000000c123c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008183a7824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fc400078e0a13ULL,
0x00000001133e7824ULL, 0x040fe200078e023cULL, 0xfffffff83a3b7812ULL, 0x000fe200078ee211ULL,
0x00000001133a7824ULL, 0x040fe200078e0239ULL, 0x000000103800720cULL, 0x080fe20003f66070ULL,
0x0000000113387824ULL, 0x000fe200078e0238ULL, 0x000000101200720cULL, 0x080fe20003f86070ULL,
0x0000000118127824ULL, 0x000fe200078e0219ULL, 0x000000103900720cULL, 0x080fe20003f46070ULL,
0x0000000138117824ULL, 0x000fe200078e020bULL, 0x000000103c00720cULL, 0x000fe20003f06070ULL,
0x0000000838187824ULL, 0x000fc400078e00ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff8183d7812ULL, 0x000fe200078ee211ULL, 0x0000000138107824ULL, 0x100fe200078e0219ULL,
0x0000004e12127212ULL, 0x000fe200078efcffULL, 0x000000013a187824ULL, 0x040fe400078e0219ULL,
0x000000013a397824ULL, 0x000fe200078e020bULL, 0x0000640012127a10ULL, 0x000fe20007fbe0ffULL,
0x000000083a3a7824ULL, 0x000fe400078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000650013137a10ULL, 0x000fc40002ffe4ffULL, 0xfffffff83a3f7812ULL, 0x000fe200078ee239ULL,
0x000000013e387824ULL, 0x000fe200078e0219ULL, 0x0000004e10107212ULL, 0x000fe200078efcffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x0000640010107a10ULL, 0x000fe20007fbe0ffULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x0000004e18187212ULL, 0x080fe400078efcffULL,
0x0000650011117a10ULL, 0x000fe20002ffe4ffULL, 0x000000013e3a7824ULL, 0x000fe200078e020bULL,
0x0000004e38387212ULL, 0x000fe200078efcffULL, 0x000000083e417824ULL, 0x000fe200078e00ffULL,
0x0000640018187a10ULL, 0x000fe20007fbe0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0252ULL,
0x0000640038387a10ULL, 0x000fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e0252ULL,
0xfffffff841417812ULL, 0x000fe200078ee23aULL, 0x000000103f3f7824ULL, 0x100fe200078e0252ULL,
0x0000650019197a10ULL, 0x000fe20002ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0005e2000e101c46ULL, 0x0000650039397a10ULL, 0x000fe200037fe4ffULL,
0x0000001041417824ULL, 0x000fc400078e0252ULL, 0x00000000103d7faeULL, 0x0005e8000d901c46ULL,
0x00000000183f7faeULL, 0x0005e8000d101c46ULL, 0x0000000038417faeULL, 0x0005e2000c101c46ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000104f107824ULL, 0x000fca00078e00ffULL,
0x000000100b127211ULL, 0x000fc800078fe8ffULL, 0x0000000412387810ULL, 0x040fe20007ffe0ffULL,
0x0000000112107824ULL, 0x140fe200078e020bULL, 0x0000000812187810ULL, 0x040fe20007ffe0ffULL,
0x00000008123b7824ULL, 0x000fe400078e00ffULL, 0x0000000138117824ULL, 0x040fe400078e020bULL,
0x00000008383a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x0000000112107824ULL, 0x000fe400078e0219ULL, 0x0000000118137824ULL, 0x000fe200078e020bULL,
0xfffffff83a3d7812ULL, 0x000fe200078ee211ULL, 0x00000008183c7824ULL, 0x000fe200078e00ffULL,
0x0000000c123a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000138387824ULL, 0x000fc400078e0219ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff83c3f7812ULL, 0x000fc600078ee213ULL,
0x0000000118187824ULL, 0x100fe200078e0219ULL, 0x0000004e10107212ULL, 0x000fe200078efcffULL,
0x000000013a127824ULL, 0x000fe400078e0219ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fc60007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000004e38387212ULL, 0x080fe400078efcffULL, 0x0000650011117a10ULL, 0x000fe200007fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000004e18187212ULL, 0x080fe400078efcffULL,
0x0000640038387a10ULL, 0x000fe20007f5e0ffULL, 0x000000013a3c7824ULL, 0x000fe200078e020bULL,
0x0000004e12127212ULL, 0x000fe200078efcffULL, 0x000000083a417824ULL, 0x000fe200078e00ffULL,
0x0000640018187a10ULL, 0x000fe20007f1e0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0252ULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e0252ULL,
0xfffffff841417812ULL, 0x000fe200078ee23cULL, 0x000000103f3f7824ULL, 0x100fe200078e0252ULL,
0x0000650039397a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103b7faeULL, 0x0005e2000b901c46ULL, 0x0000650019197a10ULL, 0x000fe200007fe4ffULL,
0x0000001041417824ULL, 0x000fe200078e0252ULL, 0x0000650013137a10ULL, 0x000fe20001ffe4ffULL,
0x00000000383d7faeULL, 0x0005e8000b901c46ULL, 0x00000000183f7faeULL, 0x0005e8000b901c46ULL,
0x0000000012417faeULL, 0x0005e4000b901c46ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x000000104d117824ULL, 0x000fe200078e00ffULL, 0x00000008083a7812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001011117812ULL, 0x000fca00078ee2ffULL,
0x0000002066117824ULL, 0x000fc800078e0211ULL, 0x000000013a3a7824ULL, 0x000fe200078e0211ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff107f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668003a127f8cULL, 0x000662000c80043fULL, 0x000000ffff107224ULL, 0x004fc600078e0011ULL,
0x0000000000187805ULL, 0x000fc80000015200ULL, 0x00f66c003a117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x006fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003818387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e19ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011439ULL, 0x0000003811117211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000211117819ULL, 0x000fc80000001238ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c003a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018066117811ULL, 0x000fc800078e38ffULL,
0x0000001171117210ULL, 0x000fca0007ffe04eULL, 0x00f0000011387984ULL, 0x000e680000000800ULL,
0x00f2000011137984ULL, 0x0004e20000000800ULL, 0x000000053800720bULL, 0x002fe20003f1d000ULL,
0x00009ea27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000117806ULL, 0x004fc800000e0100ULL,
0x0000ffff113a7812ULL, 0x008fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff117424ULL, 0x000fe400078e00ffULL, 0x000000ffff127224ULL, 0x000fd200078e0005ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x0000000366117810ULL, 0x000fe40007ffe0ffULL,
0x000000053800720bULL, 0x000fe40003f54000ULL, 0x0000000c1100720cULL, 0x000fe20003f05270ULL,
0x00009e427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000397806ULL, 0x000fc400010e0100ULL,
0x000000800c4e8824ULL, 0x000fe200078e024eULL, 0x0000000538127209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991039117816ULL, 0x000fe200000000ffULL,
0x0000000171718824ULL, 0x000fca00078e024eULL, 0x00f4001271008388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000512057221ULL, 0x002fe20000010100ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b05057820ULL, 0x000fcc0000410000ULL,
0x0000000500057308ULL, 0x000e640000000800ULL, 0x000000050e0e7220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe2000001160bULL,
0x00009d727f007947ULL, 0x000fea000b800000ULL, 0x00001f1105117589ULL, 0x0002a400000e0000ULL,
0x0000001120207220ULL, 0x084fe20000410000ULL, 0x0000001121217220ULL, 0x080fe20000410000ULL,
0x000000111c1c7220ULL, 0x080fe20000410000ULL, 0x000000111d1d7220ULL, 0x080fe20000410000ULL,
0x0000001114147220ULL, 0x080fe20000410000ULL, 0x0000001115157220ULL, 0x080fe20000410000ULL,
0x0000001124247220ULL, 0x080fe20000410000ULL, 0x0000001125257220ULL, 0x080fe20000410000ULL,
0x0000001128287220ULL, 0x080fe20000410000ULL, 0x0000001129297220ULL, 0x080fe20000410000ULL,
0x000000112c2c7220ULL, 0x080fe20000410000ULL, 0x000000112d2d7220ULL, 0x080fe20000410000ULL,
0x0000001130307220ULL, 0x080fe20000410000ULL, 0x0000001131317220ULL, 0x080fe20000410000ULL,
0x0000001134347220ULL, 0x080fe20000410000ULL, 0x0000001135357220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080b117811ULL, 0x000fe200078ff0ffULL,
0x00009c527f007947ULL, 0x000fea000b800000ULL, 0x00001f1105117589ULL, 0x0004e400000e0000ULL,
0x0000001122227220ULL, 0x08cfe20000410000ULL, 0x0000001123237220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x0000001126267220ULL, 0x080fe20000410000ULL, 0x0000001127277220ULL, 0x080fe20000410000ULL,
0x000000112a2a7220ULL, 0x080fe20000410000ULL, 0x000000112b2b7220ULL, 0x080fe20000410000ULL,
0x000000112e2e7220ULL, 0x080fe20000410000ULL, 0x000000112f2f7220ULL, 0x080fe20000410000ULL,
0x0000001132327220ULL, 0x080fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001136367220ULL, 0x080fe20000410000ULL, 0x0000001137377220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3aff7812ULL, 0x000fe20007806039ULL,
0x00000001ff117424ULL, 0x000fd800078e00ffULL, 0x0000003812380221ULL, 0x000fe20000010100ULL,
0x00007610ff110816ULL, 0x000fc60000000011ULL, 0x3fb8aa3b38380820ULL, 0x000fc80000410000ULL,
0x0000003800040308ULL, 0x000e640000000800ULL, 0x0000000413130220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000e130e7221ULL, 0x000fc20000010000ULL,
0x0000000000187805ULL, 0x000fcc0000015200ULL, 0xfffffff0083a7812ULL, 0x000fe200078ec0ffULL,
0x000000040c137824ULL, 0x000fc800078e00ffULL, 0x00f6b4003a057984ULL, 0x000e620000000800ULL,
0x0000000413137812ULL, 0x000fe400078ec0ffULL, 0x8000000005ff7812ULL, 0x002fe4000780481bULL,
0x0000000213057812ULL, 0x000fe200078efcffULL, 0x0000000000007918ULL, 0x000ff00000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3b7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003818387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e19ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011439ULL,
0x0000003813137211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x0000000213137819ULL, 0x000fc80000001238ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013b3b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6b4003a137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991011117816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000004ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff1a7819ULL, 0x000fe4000001160bULL, 0x0000541002137816ULL, 0x000fe20000000002ULL,
0x000097d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1a13037589ULL, 0x0002a400000e0000ULL,
0x000000081a117810ULL, 0x000fe20007ffe0ffULL, 0x000098027f007947ULL, 0x000fea000b800000ULL,
0x00001f1113027589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101a117810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff187224ULL, 0x000fe200078e0013ULL,
0x0000b9a000197802ULL, 0x000fc40000000f00ULL, 0x00009c9000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181a117810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x0000b9f000197802ULL, 0x000fc40000000f00ULL,
0x00009c4000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070b3c7812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000366407810ULL, 0x000fc40007ffe0ffULL, 0x000000083c117812ULL, 0x00cfca00078ef80bULL,
0x0000000811187824ULL, 0x000fca00078e00ffULL, 0xfffffff818497812ULL, 0x000fe400078ee20fULL,
0x000000080b0f7812ULL, 0x000fc600078ec0ffULL, 0x0000008066497824ULL, 0x000fca00078e0249ULL,
0x0000a80049497811ULL, 0x000fc400078e20ffULL, 0x000000050b057211ULL, 0x000fe200078fe0ffULL,
0x0000000800137824ULL, 0x002fe200078e00ffULL, 0x0000100052117810ULL, 0x000fe20007ffe0ffULL,
0x000000005118783bULL, 0x000e620000004200ULL, 0x0000003c0f427212ULL, 0x000fe200078efcffULL,
0x0000000100007824ULL, 0x000fe400078e0205ULL, 0x000000104c387824ULL, 0x000fe400078e0211ULL,
0x00000800400d7824ULL, 0x000fe200078e020dULL, 0xfffffff813007812ULL, 0x000fc600078ee200ULL,
0x000000003838783bULL, 0x000fe40000004200ULL, 0x00000010003c7824ULL, 0x000fe400078e0211ULL,
0x0000000142007824ULL, 0x040fe400078e0205ULL, 0x0000000842057824ULL, 0x000fe400078e00ffULL,
0x000000003c3c783bULL, 0x000ea60000004200ULL, 0xfffffff805007812ULL, 0x000fca00078ee200ULL,
0x00000010005b7824ULL, 0x000fe200078e0253ULL, 0x000000ff18057812ULL, 0x002fe400078ec0ffULL,
0x00000010ff447819ULL, 0x000fe40000011618ULL, 0x00000005ff53723eULL, 0x000fe400020006ffULL,
0x000000ff1b6a7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff547819ULL, 0x000fe2000001161aULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000006aff6a723eULL, 0x000fc400020006ffULL,
0x00000018ff647819ULL, 0x000fe4000001161aULL, 0x00000010ff5d7819ULL, 0x000fe4000001161bULL,
0x0000ffff18427812ULL, 0x000fe400078ec0ffULL, 0x00000010ff557819ULL, 0x104fe4000001163cULL,
0x000000ff3c057812ULL, 0x000fe400078ec0ffULL, 0x00000018ff407819ULL, 0x000fc4000001163cULL,
0x0000ffff3c4c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff443c7812ULL, 0x000fe200078ec0ffULL,
0x2000006aff447230ULL, 0x000fe20000004100ULL, 0x00000010ff0f7819ULL, 0x000fe40000011619ULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fe400020006ffULL,
0x000000ff5d5d7812ULL, 0x000fe200078ec0ffULL, 0x2000003cff6a7230ULL, 0x000fe20000004100ULL,
0x000000ff543c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff38597812ULL, 0x000fe400078ec0ffULL,
0x0000003cff3c723eULL, 0x000fe400020006ffULL, 0x00000010ff4b7819ULL, 0x100fe4000001163dULL,
0x000000ff3d677812ULL, 0x040fe400078ec0ffULL, 0x00000018ff627819ULL, 0x000fe4000001163dULL,
0x0000ffff3d477812ULL, 0x000fc400078ec0ffULL, 0x00000010ff4a7819ULL, 0x100fe4000001163eULL,
0x000000ff3e637812ULL, 0x040fe400078ec0ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001163eULL,
0x0000ffff3e137812ULL, 0x000fe400078ec0ffULL, 0x00000018ff457819ULL, 0x000fe40000011638ULL,
0x000000ff0f3e7812ULL, 0x000fe200078ec0ffULL, 0x20000064ff0f7230ULL, 0x000fe20000004100ULL,
0x00000008ff3d7819ULL, 0x000fe20000011642ULL, 0x2000003cff647230ULL, 0x000fe20000004100ULL,
0x00000018ff657819ULL, 0x000fc40000011619ULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000059ff59723eULL, 0x000fe400020006ffULL, 0x00000018ff417819ULL, 0x000fe40000011618ULL,
0x00000018ff607819ULL, 0x000fe4000001161bULL, 0x0000ffff1b5a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff1b7819ULL, 0x000fc40000011639ULL, 0x000000ff395e7812ULL, 0x040fe400078ec0ffULL,
0x00000018ff467819ULL, 0x000fe40000011639ULL, 0x0000ffff39187812ULL, 0x000fe400078ec0ffULL,
0x0000003eff3e723eULL, 0x000fe400020006ffULL, 0x0000003dff3d723eULL, 0x000fe400020006ffULL,
0x00000045ff3c723eULL, 0x000fe200020006ffULL, 0x2000003eff6b7230ULL, 0x000fe20000004100ULL,
0x00000065ff39723eULL, 0x000fe200020006ffULL, 0x2000005dff657230ULL, 0x000fe20000004100ULL,
0x00000010ff117819ULL, 0x100fe2000001163fULL, 0x20000059ff5d7230ULL, 0x000fe20000004100ULL,
0x00000046ff59723eULL, 0x000fe200020006ffULL, 0x2000003dff547230ULL, 0x000fe20000004100ULL,
0x000000ff3f617812ULL, 0x040fe200078ec0ffULL, 0x2000003cff467230ULL, 0x000fe20000004100ULL,
0x00000018ff567819ULL, 0x000fe2000001163fULL, 0x20000039ff397230ULL, 0x000fe20000004100ULL,
0x0000ffff3f007812ULL, 0x000fc400078ec0ffULL, 0x00000000493c783bULL, 0x000e620000000200ULL,
0x0000ffff195f7812ULL, 0x040fe400078ec0ffULL, 0x000000ff19687812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5f7819ULL, 0x000fe4000001165fULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x000000ff1a697812ULL, 0x000fe400078ec0ffULL, 0x00000068ff68723eULL, 0x000fc400020006ffULL,
0x0000ffff1a437812ULL, 0x000fe400078ec0ffULL, 0x0000005fff5f723eULL, 0x000fe400020006ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff517819ULL, 0x000fe40000011638ULL,
0x0000ffff381a7812ULL, 0x000fe200078ec0ffULL, 0x2000005aff457230ULL, 0x000fe20000004100ULL,
0x00000010ff197819ULL, 0x000fc4000001163aULL, 0x000000ff3a487812ULL, 0x040fe400078ec0ffULL,
0x000000ff3b587812ULL, 0x000fe400078ec0ffULL, 0x00000041ff38723eULL, 0x000fe400020006ffULL,
0x00000069ff41723eULL, 0x000fe200020006ffULL, 0x20000068ff697230ULL, 0x000fe20000004100ULL,
0x00000018ff577819ULL, 0x000fe2000001163aULL, 0x2000005fff687230ULL, 0x000fe20000004100ULL,
0x00000010ff4e7819ULL, 0x000fe2000001163bULL, 0x20000038ff387230ULL, 0x000fe20000004100ULL,
0x00000008ff1a7819ULL, 0x000fe2000001161aULL, 0x20000041ff417230ULL, 0x000fe20000004100ULL,
0x00000008ff187819ULL, 0x000fe20000011618ULL, 0x000000033c3c8231ULL, 0x082fe200003400ffULL,
0x000000ff19197812ULL, 0x000fe200078ec0ffULL, 0x000000033e3e8231ULL, 0x000fe200003400ffULL,
0x00000048ff5a723eULL, 0x000fe200020006ffULL, 0x20000059ff487230ULL, 0x000fe20000004100ULL,
0x00000058ff5f723eULL, 0x000fe200020006ffULL, 0x000000023d3d8231ULL, 0x080fe200003400ffULL,
0x0000ffff3a3a7812ULL, 0x000fe200078ec0ffULL, 0x2000005aff587230ULL, 0x000fe20000004100ULL,
0x00000057ff59723eULL, 0x000fe200020006ffULL, 0x2000005fff577230ULL, 0x000fe20000004100ULL,
0x000000ff51517812ULL, 0x000fe200078ec0ffULL, 0x000000023f3f8231ULL, 0x000fe200003400ffULL,
0x0000001aff1a723eULL, 0x000fc400020006ffULL, 0x000000ff4e4e7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff18723eULL, 0x000fe200020006ffULL, 0x2000001aff497230ULL, 0x000fe20000004100ULL,
0x00000019ff19723eULL, 0x000fe400020006ffULL, 0x00000018ff527819ULL, 0x000fe4000001163bULL,
0x0000ffff3b3b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff1b1b7812ULL, 0x000fc400078ec0ffULL,
0x00000008ff3a7819ULL, 0x000fe4000001163aULL, 0x00000051ff5f723eULL, 0x000fe200020006ffULL,
0x20000059ff517230ULL, 0x000fe20000004100ULL, 0x0000004eff5a723eULL, 0x000fe200020006ffULL,
0x20000018ff4e7230ULL, 0x000fe20000004100ULL, 0x00000060ff60723eULL, 0x000fe200020006ffULL,
0x20000019ff597230ULL, 0x000fe20000004100ULL, 0x0000001bff1b723eULL, 0x000fe200020006ffULL,
0x2000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000003aff1a723eULL, 0x000fe200020006ffULL,
0x20000060ff427230ULL, 0x000fe20000004100ULL, 0x00000008ff3b7819ULL, 0x000fe2000001163bULL,
0x2000001bff607230ULL, 0x000fe20000004100ULL, 0x00000010ff197819ULL, 0x000fe2000001166aULL,
0x2000005aff5a7230ULL, 0x000fe20000004100ULL, 0x00000010ff187819ULL, 0x000fc4000001166bULL,
0x00000010ff3a7819ULL, 0x000fe20000011653ULL, 0x2000001aff537230ULL, 0x000fe20000004100ULL,
0x00000010ff697819ULL, 0x000fe40000011669ULL, 0x0000003bff6b723eULL, 0x000fe400020006ffULL,
0x00001054193a7816ULL, 0x000fe4000000003aULL, 0x00001054183b7816ULL, 0x000fe40000000069ULL,
0x009000000d18783bULL, 0x0002a20000000200ULL, 0x00000010ff6a7819ULL, 0x000fc40000011639ULL,
0x00000008ff437819ULL, 0x000fe40000011643ULL, 0x00000010ff397819ULL, 0x000fe20000011668ULL,
0x0000003a3c20723cULL, 0x000b620000041820ULL, 0x00000010ff697819ULL, 0x000fe40000011638ULL,
0x00000067ff68723eULL, 0x000fe400020006ffULL, 0x00000010ff387819ULL, 0x000fe20000011654ULL,
0x2000006bff547230ULL, 0x000fe20000004100ULL, 0x00000040ff67723eULL, 0x000fc400020006ffULL,
0x00000010ff407819ULL, 0x000fe40000011641ULL, 0x00000043ff43723eULL, 0x000fe200020006ffULL,
0x20000067ff0d7230ULL, 0x002fe20000004100ULL, 0x00000010ff417819ULL, 0x000fe20000011644ULL,
0x20000068ff447230ULL, 0x000fe20000004100ULL, 0x00000010ff3b7819ULL, 0x020fe20000011664ULL,
0x20000043ff437230ULL, 0x000fe20000004100ULL, 0x00000010ff3a7819ULL, 0x000fe40000011665ULL,
0x0000105469387816ULL, 0x000fc40000000038ULL, 0x000010546a397816ULL, 0x000fe40000000039ULL,
0x000010543b407816ULL, 0x000fe40000000040ULL, 0x000010543a417816ULL, 0x000fe40000000041ULL,
0x00000010ff3b7819ULL, 0x000fe20000011642ULL, 0x000000383c1c723cULL, 0x000b62000004181cULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff3a7819ULL, 0x000fc40000011645ULL,
0x00000010ff5d7819ULL, 0x000fe2000001165dULL, 0x2000005eff5e7230ULL, 0x000fe20000004100ULL,
0x00000010ff387819ULL, 0x020fe20000011643ULL, 0x0000000318188231ULL, 0x084fe200003400ffULL,
0x000000403c40723cULL, 0x000b620000041814ULL, 0x00000010ff397819ULL, 0x000fe2000001160fULL,
0x000000005b14783bULL, 0x020e620000004200ULL, 0x00000010ff5e7819ULL, 0x000fe2000001165eULL,
0x000000031a1a8231ULL, 0x000fe200003400ffULL, 0x0000105439387816ULL, 0x000fe20000000038ULL,
0x0000000219198231ULL, 0x080fe200003400ffULL, 0x000010543b397816ULL, 0x000fe2000000003aULL,
0x000000021b1b8231ULL, 0x000fe200003400ffULL, 0x00000010ff3a7819ULL, 0x000fc4000001165fULL,
0x00000010ff3b7819ULL, 0x000fe40000011660ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x000000383c24723cULL, 0x000b620000041824ULL, 0x00000010ff597819ULL, 0x000fe40000011659ULL,
0x00000010ff5a7819ULL, 0x000fe2000001165aULL, 0x20000052ff527230ULL, 0x000fe20000004100ULL,
0x000000ff55557812ULL, 0x000fe400078ec0ffULL, 0x000010543a387816ULL, 0x020fc4000000005dULL,
0x000010543b397816ULL, 0x000fe4000000005eULL, 0x00000010ff3a7819ULL, 0x000fe40000011648ULL,
0x00000010ff487819ULL, 0x000fe40000011649ULL, 0x00000010ff3b7819ULL, 0x000fe40000011646ULL,
0x00000010ff497819ULL, 0x000fe4000001164eULL, 0x000010543b487816ULL, 0x000fc40000000048ULL,
0x000010543a497816ULL, 0x000fe40000000049ULL, 0x000000381838723cULL, 0x040be20000041820ULL,
0x00000056ff56723eULL, 0x000fe400020006ffULL, 0x00000055ff55723eULL, 0x000fe400020006ffULL,
0x00000008ff4c7819ULL, 0x000fe4000001164cULL, 0x00000010ff207819ULL, 0x020fe20000011658ULL,
0x00000048181c723cULL, 0x000be2000004181cULL, 0x00000010ff217819ULL, 0x000fc40000011657ULL,
0x0000105459207816ULL, 0x000fe40000000020ULL, 0x000010545a217816ULL, 0x000fe40000000021ULL,
0x00000010ff237819ULL, 0x000fe20000011651ULL, 0x20000056ff517230ULL, 0x000fe20000004100ULL,
0x00000010ff227819ULL, 0x000fe20000011652ULL, 0x20000055ff527230ULL, 0x000fe20000004100ULL,
0x00000010ff487819ULL, 0x020fe40000011653ULL, 0x00000010ff497819ULL, 0x000fc40000011654ULL,
0x0000105423487816ULL, 0x000fe40000000048ULL, 0x0000105422497816ULL, 0x000fe40000000049ULL,
0x000000201820723cULL, 0x040be20000041840ULL, 0x0000ffff14567812ULL, 0x042fe400078ec0ffULL,
0x00000018ff537819ULL, 0x100fe40000011616ULL, 0x00000010ff577819ULL, 0x000fe40000011616ULL,
0x000000ff14407812ULL, 0x020fe200078ec0ffULL, 0x000000481824723cULL, 0x000be20000041824ULL,
0x00000018ff417819ULL, 0x000fc40000011617ULL, 0x000000ff4b427812ULL, 0x000fe400078ec0ffULL,
0x00000040ff4b723eULL, 0x000fe400020006ffULL, 0x00000010ff407819ULL, 0x100fe40000011614ULL,
0x00000018ff437819ULL, 0x000fe40000011614ULL, 0x00000041ff55723eULL, 0x000fe400020006ffULL,
0x000000ff15147812ULL, 0x000fc400078ec0ffULL, 0x0000004cff41723eULL, 0x000fe400020006ffULL,
0x00000010ff4c7819ULL, 0x000fe40000011615ULL, 0x000000ff16497812ULL, 0x060fe200078ec0ffULL,
0x20000041ff417230ULL, 0x000fe20000004100ULL, 0x0000ffff165a7812ULL, 0x000fe200078ec0ffULL,
0x2000004bff167230ULL, 0x000fe20000004100ULL, 0x00000010ff587819ULL, 0x000fe40000011617ULL,
0x000000ff17547812ULL, 0x000fc400078ec0ffULL, 0x0000ffff175b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff487819ULL, 0x000fe40000011615ULL, 0x00000014ff17723eULL, 0x000fe400020006ffULL,
0x00000053ff4b723eULL, 0x000fe400020006ffULL, 0x00000043ff14723eULL, 0x000fe200020006ffULL,
0x20000017ff177230ULL, 0x000fe20000004100ULL, 0x0000ffff15597812ULL, 0x000fc400078ec0ffULL,
0x000000ff40437812ULL, 0x000fe200078ec0ffULL, 0x2000004bff407230ULL, 0x000fe20000004100ULL,
0x000000ff4c537812ULL, 0x000fe200078ec0ffULL, 0x20000014ff147230ULL, 0x000fe20000004100ULL,
0x00000048ff15723eULL, 0x000fe400020006ffULL, 0x00000054ff48723eULL, 0x000fe400020006ffULL,
0x00000008ff4c7819ULL, 0x000fe20000011656ULL, 0x20000015ff157230ULL, 0x000fe20000004100ULL,
0x00000043ff4b723eULL, 0x000fe200020006ffULL, 0x20000055ff437230ULL, 0x000fe20000004100ULL,
0x00000053ff54723eULL, 0x000fe200020006ffULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000008ff567819ULL, 0x000fe20000011659ULL, 0x2000004bff537230ULL, 0x000fe20000004100ULL,
0x000000ff57577812ULL, 0x000fe200078ec0ffULL, 0x20000054ff557230ULL, 0x000fe20000004100ULL,
0x00000056ff56723eULL, 0x000fc400020006ffULL, 0x0000004cff4c723eULL, 0x000fe400020006ffULL,
0x00000057ff4b723eULL, 0x000fe200020006ffULL, 0x20000056ff577230ULL, 0x000fe20000004100ULL,
0x000000ff58587812ULL, 0x000fe200078ec0ffULL, 0x2000004cff547230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x000fe40000011616ULL, 0x00000010ff177819ULL, 0x000fe40000011617ULL,
0x00000010ff537819ULL, 0x000fc40000011653ULL, 0x00000010ff567819ULL, 0x000fe40000011655ULL,
0x00000049ff49723eULL, 0x000fe400020006ffULL, 0x00000058ff59723eULL, 0x000fe200020006ffULL,
0x2000004bff587230ULL, 0x000fe20000004100ULL, 0x0000105453167816ULL, 0x000fe20000000016ULL,
0x20000049ff497230ULL, 0x000fe20000004100ULL, 0x0000105456177816ULL, 0x000fe20000000017ULL,
0x20000059ff597230ULL, 0x000fe20000004100ULL, 0x00000008ff4c7819ULL, 0x000fc4000001165aULL,
0x00000008ff5a7819ULL, 0x000fe4000001165bULL, 0x00000008ff537819ULL, 0x000fe20000011647ULL,
0x000000163c28723cULL, 0x000b620000041828ULL, 0x000000ff4a557812ULL, 0x000fe400078ec0ffULL,
0x00000010ff477819ULL, 0x000fe40000011614ULL, 0x00000010ff4a7819ULL, 0x000fe40000011615ULL,
0x00000010ff147819ULL, 0x000fc40000011654ULL, 0x00000010ff157819ULL, 0x000fe40000011657ULL,
0x0000004cff4c723eULL, 0x000fe400020006ffULL, 0x0000005aff5a723eULL, 0x000fe400020006ffULL,
0x0000105447147816ULL, 0x000fe20000000014ULL, 0x2000004cff4c7230ULL, 0x000fe20000004100ULL,
0x000010544a157816ULL, 0x000fe20000000015ULL, 0x2000005aff4b7230ULL, 0x000fe20000004100ULL,
0x00000010ff167819ULL, 0x020fc40000011649ULL, 0x00000010ff177819ULL, 0x000fe40000011658ULL,
0x00000010ff487819ULL, 0x000fe20000011648ULL, 0x000000143c2c723cULL, 0x000b62000004182cULL,
0x00000010ff597819ULL, 0x000fe40000011659ULL, 0x00000005ff05723eULL, 0x000fe400020006ffULL,
0x00000042ff42723eULL, 0x000fe400020006ffULL, 0x0000105417167816ULL, 0x000fe20000000016ULL,
0x20000005ff057230ULL, 0x000fe20000004100ULL, 0x0000105459177816ULL, 0x000fe20000000048ULL,
0x20000042ff427230ULL, 0x000fe20000004100ULL, 0x000000ff11487812ULL, 0x000fc400078ec0ffULL,
0x00000010ff117819ULL, 0x000fe40000011640ULL, 0x00000010ff407819ULL, 0x000fe20000011643ULL,
0x000000163c30723cULL, 0x000b640000041830ULL, 0x00000010ff147819ULL, 0x020fe4000001164cULL,
0x00000010ff157819ULL, 0x000fe4000001164bULL, 0x0000105411147816ULL, 0x000fe40000000014ULL,
0x0000105440157816ULL, 0x000fc40000000015ULL, 0x00000010ff057819ULL, 0x000fe40000011605ULL,
0x00000010ff527819ULL, 0x000fe40000011652ULL, 0x00000010ff437819ULL, 0x000fe40000011644ULL,
0x00000010ff167819ULL, 0x000fe40000011642ULL, 0x00000062ff62723eULL, 0x000fe400020006ffULL,
0x00000053ff53723eULL, 0x000fc400020006ffULL, 0x00000063ff63723eULL, 0x000fe200020006ffULL,
0x20000062ff457230ULL, 0x000fe20000004100ULL, 0x00000055ff55723eULL, 0x000fe200020006ffULL,
0x20000053ff537230ULL, 0x000fe20000004100ULL, 0x0000105452427816ULL, 0x000fe20000000005ULL,
0x20000063ff0f7230ULL, 0x000fe20000004100ULL, 0x00000008ff137819ULL, 0x000fe20000011613ULL,
0x20000055ff477230ULL, 0x000fe20000004100ULL, 0x0000105416437816ULL, 0x000fe40000000043ULL,
0x00000008ff057819ULL, 0x000fe20000011600ULL, 0x000000143c14723cULL, 0x000b620000041834ULL,
0x00000061ff61723eULL, 0x000fc400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe200020006ffULL, 0x20000061ff4e7230ULL, 0x000fe20000004100ULL,
0x00000013ff13723eULL, 0x000fe200020006ffULL, 0x2000005cff467230ULL, 0x000fe20000004100ULL,
0x00000010ff007819ULL, 0x000fe2000001160dULL, 0x20000048ff487230ULL, 0x000fe20000004100ULL,
0x00000010ff417819ULL, 0x000fe20000011641ULL, 0x20000013ff137230ULL, 0x000fe20000004100ULL,
0x00000005ff05723eULL, 0x000fe200020006ffULL, 0x000000421828723cULL, 0x000b640000041828ULL,
0x00000010ff367819ULL, 0x020fc40000011645ULL, 0x00000010ff357819ULL, 0x000fe20000011653ULL,
0x20000005ff057230ULL, 0x000fe20000004100ULL, 0x0000105400347816ULL, 0x000fe40000000041ULL,
0x00000010ff0f7819ULL, 0x000fe4000001160fULL, 0x00000010ff007819ULL, 0x000fe40000011647ULL,
0x0000105436357816ULL, 0x000fe40000000035ULL, 0x0000105400367816ULL, 0x000fc4000000000fULL,
0x00000010ff377819ULL, 0x000fe4000001164eULL, 0x00000010ff487819ULL, 0x000fe20000011648ULL,
0x00000034182c723cULL, 0x000b62000004182cULL, 0x00000010ff467819ULL, 0x000fe40000011646ULL,
0x00000010ff137819ULL, 0x000fe40000011613ULL, 0x00000010ff007819ULL, 0x000fe40000011651ULL,
0x00000010ff057819ULL, 0x000fc40000011605ULL, 0x0000105448377816ULL, 0x000fe40000000037ULL,
0x0000105446467816ULL, 0x000fe40000000013ULL, 0x0000105400477816ULL, 0x000fc60000000005ULL,
0x000000361830723cULL, 0x040b700000041830ULL, 0x000000461814723cULL, 0x000b620000041814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000006187f8cULL, 0x0202a2000c80043fULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000f6a066057811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000005ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x004fe200078e0019ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff454000007947ULL, 0x000fea000383ffffULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x018000000e007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000d2e000047802ULL, 0x000fc40000000f00ULL, 0x0000819000007944ULL, 0x00efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000e00037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc8000000000eULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x000ee80000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x00afe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x010fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000003800387220ULL, 0x042fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x040fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x000fe20000410000ULL,
0x0000003a043a7220ULL, 0x044fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000f220000000000ULL, 0x0000002c2d2c723eULL, 0x000fc400000010ffULL,
0x000000303130723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000141518723eULL, 0x000fe400000010ffULL, 0x000000222322723eULL, 0x000fe400000010ffULL,
0x0000002a2b2a723eULL, 0x000fc400000010ffULL, 0x0000002e2f15723eULL, 0x000fe400000010ffULL,
0x000000323332723eULL, 0x000fe400000010ffULL, 0x000000161719723eULL, 0x000fe400000010ffULL,
0x00000002ff057819ULL, 0x118fe20000011600ULL, 0x0000000177777824ULL, 0x000fe200078e0200ULL,
0x0000000200027812ULL, 0x044fe400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fc400078ff8ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000403067810ULL, 0x002fe40007ffe0ffULL, 0xfffffff8090e7812ULL, 0x000fe200078ee204ULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee202ULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000000603077810ULL, 0x000fe20007ffe0ffULL,
0x000010004f027824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x000008004d037824ULL, 0x100fe200078e0202ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000001077777824ULL, 0x000fe200078e0202ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x0000001c1d04723eULL, 0x000fe200000010ffULL,
0x000000100e0f7824ULL, 0x000fc400078e0203ULL, 0x0000001008097824ULL, 0x100fe400078e0203ULL,
0x000000100a0b7824ULL, 0x100fe400078e0203ULL, 0x000000100c0d7824ULL, 0x000fe200078e0203ULL,
0x000000383903723eULL, 0x000fe200000010ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x000000282905723eULL, 0x000fe200000010ffULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x0000541003107816ULL, 0x140fe20000000004ULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x0000763203117816ULL, 0x000fe20000000004ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x000000202103723eULL, 0x000fe200000010ffULL, 0x00000001060d7824ULL, 0x000fe200078e020dULL,
0x000000242504723eULL, 0x000fe200000010ffULL, 0x0000001007007388ULL, 0x0003e60000000a00ULL,
0x0000541003067816ULL, 0x000fc40000000004ULL, 0x0000763203077816ULL, 0x002fe40000000004ULL,
0x0000003a3b03723eULL, 0x000fe400000010ffULL, 0x0000001e1f04723eULL, 0x000fe200000010ffULL,
0x0000000609007388ULL, 0x0003e20000000a00ULL, 0x000000262711723eULL, 0x000fc800000010ffULL,
0x0000541022107816ULL, 0x140fe40000000011ULL, 0x0000763222117816ULL, 0x000fe40000000011ULL,
0x0000541005067816ULL, 0x142fe4000000002cULL, 0x0000763205077816ULL, 0x000fca000000002cULL,
0x000000060b007388ULL, 0x0003e40000000a00ULL, 0x0000541030067816ULL, 0x142fe40000000018ULL,
0x0000763230077816ULL, 0x000fca0000000018ULL, 0x000000060d007388ULL, 0x0003e40000000a00ULL,
0x0000541003067816ULL, 0x142fe40000000004ULL, 0x0000763203077816ULL, 0x000fe40000000004ULL,
0x000000ff00037306ULL, 0x000fe60000205400ULL, 0x000000060f007388ULL, 0x0003e80000000a00ULL,
0x0004001009007388ULL, 0x000fe20000000a00ULL, 0x000000ff00047306ULL, 0x000ea20000209400ULL,
0x000054102a067816ULL, 0x002fc40000000015ULL, 0x000076322a077816ULL, 0x000fca0000000015ULL,
0x000400060b007388ULL, 0x0003e20000000a00ULL, 0x000000030400720bULL, 0x004fe40003f1d000ULL,
0x000000ff00037245ULL, 0x000fe4000020d400ULL, 0x0000541032067816ULL, 0x142fe40000000019ULL,
0x0000763232077816ULL, 0x000fce0000000019ULL, 0x0000000103030812ULL, 0x000fe400078efcffULL,
0x000000ff4d00720cULL, 0x000fe20003f05270ULL, 0x000400060d007388ULL, 0x000fe20000000a00ULL,
0x000000030304723eULL, 0x000fc600000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000077107984ULL, 0x000e680000000c00ULL, 0x0004000077087984ULL, 0x000ea80000000c00ULL,
0x0008000077147984ULL, 0x000ee80000000c00ULL, 0x000c000077187984ULL, 0x000f220000000c00ULL,
0x3f803f8004137831ULL, 0x002fc40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x040fe40000200010ULL,
0x3f803f80040b7831ULL, 0x044fe4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x000fc40000200009ULL, 0x3f803f8004087831ULL, 0x000fe40000200008ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f800b0b7831ULL, 0x010fc4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe2000020001aULL,
0x0000001077007388ULL, 0x000fe20000000c00ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fca0000200018ULL, 0x0004000877007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fc80000011600ULL, 0x000000750900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff0f7a12ULL, 0x000fe400078e33ffULL,
0x00000007000e7812ULL, 0x000fc800078ec0ffULL, 0x0000000600067308ULL, 0x002e640000001000ULL,
0x0ffffffe06087810ULL, 0x002fcc0007ffe0ffULL, 0x0000000800057305ULL, 0x000e64000021f000ULL,
0x000000ffff037224ULL, 0x002fc800078e0a05ULL, 0x00005a0003037a24ULL, 0x000fc800078e02ffULL,
0x0000000305107227ULL, 0x000fc800078e0004ULL, 0x0000000174037824ULL, 0x000fc800078e0209ULL,
0x0000000310077227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fc800078e0a07ULL,
0x00005a0004057a24ULL, 0x000fe400078e0203ULL, 0x0000000109047824ULL, 0x000fc600078e0200ULL,
0x00005a0005007a0cULL, 0x000fda0003f06070ULL, 0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x0000000704057812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff805057812ULL, 0x000fca00078ef800ULL, 0x0000001005067824ULL, 0x000fe400078e0202ULL,
0x0000000107071810ULL, 0x000fc60007ffe0ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x000000070f077207ULL, 0x000fca0004000000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a07ULL,
0x0000590007047a24ULL, 0x000fe200078e0270ULL, 0x0000002000077810ULL, 0x000fe20007ffe0ffULL,
0x00005a000c037a24ULL, 0x000fc600078e0203ULL, 0x00000003ff067819ULL, 0x002fe20000011607ULL,
0x00005a0004037a24ULL, 0x000fca00078e0203ULL, 0x0000000376037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0003047a11ULL, 0x000fc800078240ffULL,
0x00005f0003057a11ULL, 0x000fe200008f440cULL, 0x000000084f037824ULL, 0x000fe200078e020eULL,
0x000000750600720cULL, 0x000fc60003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000174037824ULL, 0x100fe200078e0206ULL, 0x00000040000d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107067824ULL, 0x000fe400078e0206ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef807ULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f057207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc6000001160dULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a05ULL,
0x0000590005047a24ULL, 0x000fe400078e0270ULL, 0x00005a000c037a24ULL, 0x000fe200078e0203ULL,
0x00000007070c7812ULL, 0x000fc600078ec0ffULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000376037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440eULL,
0x000000084f037824ULL, 0x000fe200078e020cULL, 0x000000750600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000174037824ULL, 0x100fe200078e0206ULL,
0x0000006000077810ULL, 0x000fe20007ffe0ffULL, 0x000000010d067824ULL, 0x040fe200078e0206ULL,
0x000000070d007812ULL, 0x000fe200078ec0ffULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fc800078e0a04ULL,
0x00005a0008057a24ULL, 0x000fca00078e0203ULL, 0x00005a0005007a0cULL, 0x000fda0003f26070ULL,
0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff806057812ULL, 0x000fca00078ef80dULL,
0x0000001005067824ULL, 0x000fca00078e0202ULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x000000040f057207ULL, 0x000fe40004000000ULL,
0x00000003ff067819ULL, 0x002fc60000011607ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0a05ULL,
0x0000590005047a24ULL, 0x000fe400078e0270ULL, 0x00005a000c037a24ULL, 0x000fe400078e0203ULL,
0x0000000174747824ULL, 0x000fe400078e0206ULL, 0x00005a0004037a24ULL, 0x000fca00078e0203ULL,
0x0000000376037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0003047a11ULL, 0x000fc800078240ffULL, 0x00005f0003057a11ULL, 0x000fe200008f440cULL,
0x000000084f037824ULL, 0x000fe200078e0200ULL, 0x000000750600720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000007410007227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a00ULL, 0x0000000107067824ULL, 0x000fe400078e0206ULL,
0x00005a0003037a24ULL, 0x000fc600078e0274ULL, 0x0000000706067812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fda0003f26070ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000100001810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f46070ULL,
0xfffffff806037812ULL, 0x000fca00078ef807ULL, 0x0000001003047824ULL, 0x002fca00078e0202ULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000100002810ULL, 0x000fc80007ffe0ffULL,
0x000000000f037207ULL, 0x000fe40004000000ULL, 0x0000000707007812ULL, 0x000fc600078ec0ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a03ULL, 0x0000590003037a24ULL, 0x000fe400078e0270ULL,
0x00005a0005747a24ULL, 0x000fe400078e0274ULL, 0x000000084f4f7824ULL, 0x000fe400078e0200ULL,
0x00005a0003037a24ULL, 0x000fca00078e0274ULL, 0x0000000376037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078040ffULL,
0x00005f0003037a11ULL, 0x000fca00000f4406ULL, 0x000000104f027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006c00ff067624ULL, 0x000fe400078e00ffULL, 0x00006d00ff077624ULL, 0x000fca00078e00ffULL,
0x0000000606087981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0d00780cULL, 0x000fe20003f04070ULL, 0x0000001fff0e7424ULL, 0x000fe200078e00ffULL,
0x00f60000ff067f8cULL, 0x002e62000c80043fULL, 0x0000000205057824ULL, 0x000fe400078e00ffULL,
0x000000400c737824ULL, 0x000fe200078e00ffULL, 0x000058000e0e7a10ULL, 0x000fe20007ffe0ffULL,
0x0000590005027a24ULL, 0x000fc600078e0270ULL, 0x00000005ff0e7819ULL, 0x000fe2000001160eULL,
0x00006800021e7a24ULL, 0x000fe400078e0273ULL, 0x0000060000000947ULL, 0x000fea0003800000ULL,
0x00000002ff237819ULL, 0x000fe4000001160bULL, 0x0000000b0b0d7211ULL, 0x000fe400078fe8ffULL,
0x00000008231c7810ULL, 0x040fe20007ffe0ffULL, 0x000000011e107824ULL, 0x000fe200078e0223ULL,
0x0000001023247810ULL, 0x040fe40007ffe0ffULL, 0x0000001823257810ULL, 0x040fe20007ffe0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000020230f7810ULL, 0x000fc40007ffe0ffULL,
0x00000028231f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e127824ULL, 0x000fe200078e021cULL,
0x0000003010187812ULL, 0x000fe200078ef804ULL, 0x000000011e147824ULL, 0x000fe200078e0224ULL,
0x000000030d207812ULL, 0x000fe200078ec0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000640018187a10ULL, 0x000fe40007f1e0ffULL, 0x000010000c227811ULL, 0x000fe200078e68ffULL,
0x000000011e167824ULL, 0x000fe200078e0225ULL, 0x00000030121a7812ULL, 0x000fe200078ef804ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000650011197a10ULL, 0x000fc400007fe4ffULL,
0x000064001a1a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003014107812ULL, 0x100fe400078ef804ULL, 0x000000730a147217ULL, 0x000fe20007800000ULL,
0x000000041c0d7824ULL, 0x000fe200078e00ffULL, 0x0000003016127812ULL, 0x000fe200078ef804ULL,
0x000000011e167824ULL, 0x000fe200078e020fULL, 0x0000640010107a10ULL, 0x000fe20007f1e0ffULL,
0x0000000114057824ULL, 0x000fe200078e0a73ULL, 0x00006500131b7a10ULL, 0x000fc40000ffe4ffULL,
0x0000650015117a10ULL, 0x000fe200007fe4ffULL, 0x0000008016147825ULL, 0x000fe200078e00ffULL,
0x0000640012127a10ULL, 0x000fe40007f3e0ffULL, 0x000000052300720cULL, 0x080fe20003f06070ULL,
0x000000011e167824ULL, 0x000fe200078e021fULL, 0x0000650017137a10ULL, 0x000fe40000ffe4ffULL,
0x000000051c00720cULL, 0x000fe20003f26070ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0ffffffc200b7812ULL, 0x000fc400078ef80bULL, 0xfffffffc0d0d7812ULL, 0x000fe400078ee220ULL,
0x0000003023217810ULL, 0x000fe20007ffe0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0222ULL,
0x00000030161c7812ULL, 0x000fe200078ef804ULL, 0x000000100d0d7824ULL, 0x000fe200078e0222ULL,
0x0000003014147812ULL, 0x000fe200078ef804ULL, 0x000000011e167824ULL, 0x000fe200078e0221ULL,
0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000180b7faeULL, 0x0005e2000c101c46ULL, 0x0000003823237810ULL, 0x000fc40007ffe0ffULL,
0x0000640014147a10ULL, 0x000fe20007f5e0ffULL, 0x000000001a0d7faeULL, 0x0007e2000c901c46ULL,
0x00006500171d7a10ULL, 0x000fe200037fe4ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000650015157a10ULL, 0x000fe400017fe4ffULL, 0x000000052400720cULL, 0x080fe40003fa6070ULL,
0x000000052500720cULL, 0x080fe20003f86070ULL, 0x000000011e187824ULL, 0x004fe200078e0223ULL,
0x000000050f00720cULL, 0x0c0fe20003f66070ULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x000000051f00720cULL, 0x080fe20003f46070ULL, 0x00000004250d7824ULL, 0x008fe200078e00ffULL,
0x000000052100720cULL, 0x080fe20003f26070ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000052300720cULL, 0x000fc40003f06070ULL, 0x0000003016167812ULL, 0x000fe200078ef804ULL,
0x0000000424057824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d0d7812ULL, 0x100fe200078ee220ULL,
0x000000041f1b7824ULL, 0x000fe200078e00ffULL, 0x0000640016167a10ULL, 0x000fe20007fde0ffULL,
0x00000004211f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc05057812ULL, 0x100fe200078ee220ULL,
0x0000000423217824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee220ULL,
0x000000100d0d7824ULL, 0x000fe200078e0222ULL, 0x0000003018047812ULL, 0x000fe200078ef804ULL,
0x00000010050b7824ULL, 0x000fe200078e0222ULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee220ULL,
0x000000100f0f7824ULL, 0x000fe200078e0222ULL, 0xfffffffc1f1f7812ULL, 0x000fc400078ee220ULL,
0xfffffffc21217812ULL, 0x000fe200078ee220ULL, 0x000000101b1b7824ULL, 0x100fe200078e0222ULL,
0x0000650017177a10ULL, 0x000fe200037fe4ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0222ULL,
0x0000640004047a10ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x000fe200078e0222ULL,
0x00000000100b7faeULL, 0x0005e4000e901c46ULL, 0x0000650019057a10ULL, 0x000fe400037fe4ffULL,
0x00000000120d7faeULL, 0x0005e8000e101c46ULL, 0x00000000140f7faeULL, 0x0005e8000d901c46ULL,
0x000000001c1b7faeULL, 0x0005e8000d101c46ULL, 0x00000000161f7faeULL, 0x0005e8000c901c46ULL,
0x0000000004217faeULL, 0x0005e2000c101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000b0b127211ULL, 0x040fe400078fe8ffULL, 0x000000080b177811ULL, 0x000fc400078ff0ffULL,
0x000000100b057811ULL, 0x040fe400078ff0ffULL, 0x000000300b137811ULL, 0x040fe400078ff0ffULL,
0x000000200b0f7811ULL, 0x000fe200078ff0ffULL, 0x0000000405197824ULL, 0x000fe200078e00ffULL,
0x000000380b157811ULL, 0x040fe200078ff0ffULL, 0x000000011e227824ULL, 0x000fe200078e0213ULL,
0x000000180b0d7811ULL, 0x000fe200078ff0ffULL, 0x000000040f1d7824ULL, 0x000fe200078e00ffULL,
0x00000003121a7812ULL, 0x000fe200078ec0ffULL, 0x000000011e127824ULL, 0x000fe200078e0217ULL,
0x000000280b117811ULL, 0x000fe200078ff0ffULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x0000001e0b107211ULL, 0x000fe200078ff0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0x0ffffffc1a0b7812ULL, 0x000fe200078ef80bULL, 0x000000011e247824ULL, 0x000fe200078e0215ULL,
0x000010000c267811ULL, 0x000fe200078e68ffULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0xfffffffc131c7812ULL, 0x100fe200078ee21aULL, 0x000000011e147824ULL, 0x040fe200078e0205ULL,
0xfffffffc17057812ULL, 0x000fe200078ee21aULL, 0x000000011e167824ULL, 0x000fc400078e020dULL,
0x000000040d1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc190d7812ULL, 0x100fe200078ee21aULL,
0x000000011e207824ULL, 0x000fe200078e0211ULL, 0xfffffffc1d197812ULL, 0x100fe200078ee21aULL,
0x00000004111f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc151d7812ULL, 0x000fe200078ee21aULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000011e187824ULL, 0x000fe200078e020fULL, 0xfffffffc1b0f7812ULL, 0x100fe200078ee21aULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffffc1f1b7812ULL, 0x000fe400078ee21aULL,
0x00000030101a7812ULL, 0x000fe200078ef804ULL, 0x000000100b297824ULL, 0x000fe200078e0226ULL,
0x00000030141e7812ULL, 0x000fe200078ef804ULL, 0x00000010050b7824ULL, 0x000fe200078e0226ULL,
0x0000003012057812ULL, 0x000fe200078ef804ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000064001a1a7a10ULL, 0x000fc40007f1e0ffULL, 0x000064001e1e7a10ULL, 0x000fe20007f5e0ffULL,
0x000000101c257824ULL, 0x100fe200078e0226ULL, 0x00006400051c7a10ULL, 0x000fe20007f3e0ffULL,
0x000000101b237824ULL, 0x100fe200078e0226ULL, 0x00006500111b7a10ULL, 0x000fe200007fe4ffULL,
0x000000101d277824ULL, 0x000fe200078e0226ULL, 0x0000003016167812ULL, 0x100fe200078ef804ULL,
0x0000008018107825ULL, 0x000fe200078e00ffULL, 0x00006500131d7a10ULL, 0x000fe20000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a297faeULL, 0x0005e2000b901c46ULL,
0x00006500151f7a10ULL, 0x000fe200017fe4ffULL, 0x0000008020127825ULL, 0x000fe200078e00ffULL,
0x0000640016167a10ULL, 0x000fe20007f1e0ffULL, 0x000000001c0b7faeULL, 0x0005e2000b901c46ULL,
0x0000003010057812ULL, 0x000fe200078ef804ULL, 0x0000001019217824ULL, 0x000fe200078e0226ULL,
0x0000003012107812ULL, 0x000fe200078ef804ULL, 0x0000008022147825ULL, 0x000fe200078e00ffULL,
0x0000650017177a10ULL, 0x000fc400007fe4ffULL, 0x0000640010107a10ULL, 0x000fe20007f3e0ffULL,
0x0000008024187825ULL, 0x000fe200078e00ffULL, 0x0000003014127812ULL, 0x000fc600078ef804ULL,
0x000000100d0d7824ULL, 0x000fe200078e0226ULL, 0x0000003018147812ULL, 0x000fe200078ef804ULL,
0x000000100f0f7824ULL, 0x000fe200078e0226ULL, 0x0000640005047a10ULL, 0x000fe40007f1e0ffULL,
0x0000640012127a10ULL, 0x000fe20007f5e0ffULL, 0x000000001e0d7faeULL, 0x0005e2000b901c46ULL,
0x0000640014147a10ULL, 0x000fe40007f7e0ffULL, 0x0000650011057a10ULL, 0x000fe200007fe4ffULL,
0x00000000160f7faeULL, 0x0005e2000b901c46ULL, 0x0000650013117a10ULL, 0x000fc40000ffe4ffULL,
0x0000650015137a10ULL, 0x000fe200017fe4ffULL, 0x0000000004217faeULL, 0x0005e2000b901c46ULL,
0x0000650019157a10ULL, 0x000fc60001ffe4ffULL, 0x0000000010237faeULL, 0x0005e8000b901c46ULL,
0x0000000012257faeULL, 0x0005e8000b901c46ULL, 0x0000000014277faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x004fc40000015200ULL,
0x00f60400ff0b7984ULL, 0x000ea20000000800ULL, 0x0000000e034b7224ULL, 0x000fe400078e02ffULL,
0x000000010a037824ULL, 0x000fc400078e0a00ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x800000000bff7812ULL, 0x006fe20007804807ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000062004b4a7625ULL, 0x000fe200078e004aULL,
0x00000008ff037819ULL, 0x000fe20000011603ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000001004107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e05ULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011411ULL,
0x000000100b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x000000020b0b7819ULL, 0x000fc80000001210ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000200c047824ULL, 0x002fca00078e0205ULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05077812ULL, 0x000fe400078ec0ffULL,
0x0000000f04057812ULL, 0x000fc600078ec0ffULL, 0x0000000104077824ULL, 0x000fe400078e0207ULL,
0x00000010050b7824ULL, 0x040fe400078e00ffULL, 0x0000001005067824ULL, 0x000fe200078e00ffULL,
0x0000000f07047812ULL, 0x040fe400078ec0ffULL, 0x0000000107077810ULL, 0x000fe40007ffe0ffULL,
0x000000f00b047812ULL, 0x000fe400078ee204ULL, 0x0000000f07077812ULL, 0x000fc600078ec0ffULL,
0x0000000004147984ULL, 0x000e62000000cc00ULL, 0x000000f006077812ULL, 0x000fca00078ee207ULL,
0x0000000007107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001804007388ULL, 0x0003e8000000cc00ULL,
0x0000001407007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff107f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0d7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x000000020e057824ULL, 0x000fe200078e00ffULL,
0x3db504f308067820ULL, 0x010fe20000410000ULL, 0x0000f6880c077811ULL, 0x000fe200078e18ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xffffffff00087810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x00000009000b7810ULL, 0x000fe40007ffe0ffULL,
0x0000f6080c757811ULL, 0x000fc400078e28ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000eULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff487224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x00cfc4000001ff00ULL,
0x000000014800780cULL, 0x040fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x000000010d0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff497224ULL, 0x000fe200078e0048ULL,
0x0000000148287810ULL, 0x020fc80007ffe0ffULL, 0x000000022800780cULL, 0x040fe20003f06070ULL,
0x000000ffff487224ULL, 0x000fe200078e0028ULL, 0x000000ff28297207ULL, 0x000fc60000800000ULL,
0x000000ffff0e1224ULL, 0x000fc800078e020dULL, 0x000001000e2f7824ULL, 0x040fe200078e0273ULL,
0x000000010e2a7810ULL, 0x000fe40007ffe0ffULL, 0x000000010f0e7812ULL, 0x000fe200078e0cffULL,
0x0000680002357a24ULL, 0x000fe200078e022fULL, 0x000000092a00720cULL, 0x000fda0003f46070ULL,
0x000005d00000a947ULL, 0x000fea0003800000ULL, 0x0000001004287824ULL, 0x002fe200078e00ffULL,
0x00000002ff3a7819ULL, 0x000fe20000011604ULL, 0x000000020c387824ULL, 0x000fe200078e020eULL,
0x0000002f0a2e7217ULL, 0x000fe40007800000ULL, 0x0000003028287812ULL, 0x000fe200078ec0ffULL,
0x000000013a2b7824ULL, 0x040fe200078e0235ULL, 0x000000083a397810ULL, 0x000fe20007ffe0ffULL,
0x000000012e347824ULL, 0x000fe200078e0a2fULL, 0x000000183a447810ULL, 0x040fe20007ffe0ffULL,
0x0000004029287824ULL, 0x000fe200078e0228ULL, 0x000000103a3b7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000000203a467810ULL, 0x000fe20007ffe0ffULL,
0x00000001392d7824ULL, 0x000fe200078e0235ULL, 0x0000100038387811ULL, 0x000fe200078e60ffULL,
0x000000802b2a7825ULL, 0x000fe200078e0028ULL, 0x000000303a4d7810ULL, 0x000fc40007ffe0ffULL,
0x000000344400720cULL, 0x040fe20003fa6070ULL, 0x0000000144377824ULL, 0x000fe200078e0235ULL,
0x000064002a307a10ULL, 0x000fe20007f3e0ffULL, 0x000000802d2c7825ULL, 0x000fc600078e0028ULL,
0x000065002b317a10ULL, 0x000fe20000ffe4ffULL, 0x0000008037367825ULL, 0x000fe200078e0028ULL,
0x000064002c2e7a10ULL, 0x000fe40007f5e0ffULL, 0x00000004042c7211ULL, 0x000fe200078fe8ffULL,
0x000000013b337824ULL, 0x040fe200078e0235ULL, 0x00006400362a7a10ULL, 0x000fe20007f3e0ffULL,
0x000000043b4c7824ULL, 0x000fe200078e00ffULL, 0x000000032c477812ULL, 0x000fe200078ec0ffULL,
0x0000008033327825ULL, 0x000fe200078e0028ULL, 0x00006500372b7a10ULL, 0x000fc40000ffe4ffULL,
0x000000343a00720cULL, 0x080fe20003f26070ULL, 0x0000000439367824ULL, 0x000fe200078e00ffULL,
0x0000640032327a10ULL, 0x000fe20007f7e0ffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x000065002d2f7a10ULL, 0x000fe200017fe4ffULL, 0x00000001462d7824ULL, 0x000fe200078e0235ULL,
0x000000343900720cULL, 0x000fe40003f46070ULL, 0x0ffffffc47397812ULL, 0x000fe200078ef804ULL,
0x000000802d2c7825ULL, 0x000fe200078e0028ULL, 0xfffffffc4c457812ULL, 0x000fc400078ee247ULL,
0x0000650033337a10ULL, 0x000fe20001ffe4ffULL, 0x0000001039397824ULL, 0x100fe200078e0238ULL,
0x000000283a4c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001045457824ULL, 0x100fe200078e0238ULL,
0x000000343b00720cULL, 0x080fe40003f66070ULL, 0xfffffffc363b7812ULL, 0x000fe200078ee247ULL,
0x000000014c377824ULL, 0x000fe200078e0235ULL, 0x000064002c2c7a10ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030397faeULL, 0x0003e2000c901c46ULL,
0x000000383a3a7810ULL, 0x000fe20007ffe0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e0238ULL,
0x000065002d2d7a10ULL, 0x000fe200027fe4ffULL, 0x0000008037367825ULL, 0x000fe200078e0028ULL,
0x000000344600720cULL, 0x000fc40003f86070ULL, 0x000000002e3b7faeULL, 0x0005e2000d101c46ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x000000343a00720cULL, 0x080fe40003f26070ULL,
0x0000000032457faeULL, 0x0007e2000d901c46ULL, 0x000000014d317824ULL, 0x142fe200078e0235ULL,
0x000000344c00720cULL, 0x080fe20003f66070ULL, 0x000000013a357824ULL, 0x000fe200078e0235ULL,
0x000000344d00720cULL, 0x000fe20003f46070ULL, 0x0000008031307825ULL, 0x000fe200078e0028ULL,
0x00006400362e7a10ULL, 0x004fc60007fde0ffULL, 0x000000044c4c7824ULL, 0x000fe400078e00ffULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x00006500372f7a10ULL, 0x000fe200037fe4ffULL,
0x000000044d327824ULL, 0x008fe200078e00ffULL, 0xfffffffc44337812ULL, 0x000fe200078ee247ULL,
0x0000008035287825ULL, 0x000fe200078e0028ULL, 0x0000640030307a10ULL, 0x000fe40007fde0ffULL,
0xfffffffc46357812ULL, 0x100fe200078ee247ULL, 0x0000001033337824ULL, 0x000fe200078e0238ULL,
0xfffffffc4c377812ULL, 0x000fc400078ee247ULL, 0xfffffffc32397812ULL, 0x100fe200078ee247ULL,
0x0000001035357824ULL, 0x100fe200078e0238ULL, 0xfffffffc3a3b7812ULL, 0x000fe200078ee247ULL,
0x0000001037377824ULL, 0x100fe200078e0238ULL, 0x0000650031317a10ULL, 0x000fe200037fe4ffULL,
0x0000001039397824ULL, 0x100fe200078e0238ULL, 0x0000640028287a10ULL, 0x000fe20007fde0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e0238ULL, 0x000000002a337faeULL, 0x0003e4000e901c46ULL,
0x0000650029297a10ULL, 0x000fc400037fe4ffULL, 0x000000002c357faeULL, 0x0003e8000e101c46ULL,
0x000000002e377faeULL, 0x0003e8000d901c46ULL, 0x0000000030397faeULL, 0x0003e8000d101c46ULL,
0x00000000283b7faeULL, 0x0003e2000c901c46ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000001004287824ULL, 0x042fe200078e00ffULL, 0x00000008042c7811ULL, 0x000fe200078ff0ffULL,
0x000000020c2b7824ULL, 0x000fe200078e020eULL, 0x00000010042e7811ULL, 0x000fc400078ff0ffULL,
0x0000001804307811ULL, 0x000fe200078ff0ffULL, 0x000000012c2d7824ULL, 0x100fe200078e0235ULL,
0x0000002004327811ULL, 0x000fe200078ff0ffULL, 0x000000012e2f7824ULL, 0x100fe200078e0235ULL,
0x0000002804347811ULL, 0x000fe200078ff0ffULL, 0x0000000130317824ULL, 0x100fe200078e0235ULL,
0x0000003028287812ULL, 0x000fe200078ec0ffULL, 0x0000000132337824ULL, 0x100fe200078e0235ULL,
0x0000003004367811ULL, 0x000fe200078ff0ffULL, 0x0000000134377824ULL, 0x000fe200078e0235ULL,
0x0000003804387811ULL, 0x040fe200078ff0ffULL, 0x0000004029287824ULL, 0x000fe200078e0228ULL,
0x00000004042a7211ULL, 0x000fe200078fe8ffULL, 0x000000042c2c7824ULL, 0x000fc400078e00ffULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0x000000032a297812ULL, 0x000fe200078ec0ffULL,
0x0000000430307824ULL, 0x000fe200078e00ffULL, 0x000010002b2a7811ULL, 0x000fe200078e60ffULL,
0x0000000432327824ULL, 0x000fe200078e00ffULL, 0xfffffffc2c397812ULL, 0x100fe200078ee229ULL,
0x0000000434347824ULL, 0x000fe200078e00ffULL, 0xfffffffc2e3b7812ULL, 0x100fe200078ee229ULL,
0x00000004363a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc30457812ULL, 0x100fe200078ee229ULL,
0x0000000438447824ULL, 0x000fe200078e00ffULL, 0xfffffffc32477812ULL, 0x100fe200078ee229ULL,
0x0000001039397824ULL, 0x100fe200078e022aULL, 0xfffffffc344d7812ULL, 0x100fe200078ee229ULL,
0x000000103b3b7824ULL, 0x100fe200078e022aULL, 0xfffffffc3a517812ULL, 0x100fe200078ee229ULL,
0x0000001045457824ULL, 0x100fe200078e022aULL, 0xfffffffc44557812ULL, 0x000fe200078ee229ULL,
0x0000001047477824ULL, 0x000fe200078e022aULL, 0x0ffffffc29297812ULL, 0x000fe200078ef804ULL,
0x000000104d4d7824ULL, 0x100fe200078e022aULL, 0x00000035042b7211ULL, 0x000fe200078ff0ffULL,
0x0000001051517824ULL, 0x000fc400078e022aULL, 0x0000001029577824ULL, 0x100fe400078e022aULL,
0x000000ffff297224ULL, 0x000fe400078e00ffULL, 0x0000001055557824ULL, 0x000fe400078e022aULL,
0x000000802b2a7825ULL, 0x000fc800078e0028ULL, 0x000000802d2c7825ULL, 0x000fe200078e0028ULL,
0x000064002a2a7a10ULL, 0x000fc60007f3e0ffULL, 0x000000802f2e7825ULL, 0x000fe200078e0028ULL,
0x000064002c2c7a10ULL, 0x000fe40007f5e0ffULL, 0x000065002b2b7a10ULL, 0x000fe20000ffe4ffULL,
0x00000001364f7824ULL, 0x000fe200078e0235ULL, 0x000064002e2e7a10ULL, 0x000fe20007f7e0ffULL,
0x0000008031307825ULL, 0x000fe200078e0028ULL, 0x000065002d2d7a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a577faeULL, 0x0003e2000b901c46ULL,
0x000065002f2f7a10ULL, 0x000fe20001ffe4ffULL, 0x0000000138537824ULL, 0x000fe200078e0235ULL,
0x0000640030307a10ULL, 0x000fe20007f9e0ffULL, 0x0000008033327825ULL, 0x100fe200078e0028ULL,
0x000000002c397faeULL, 0x0003e4000b901c46ULL, 0x0000650031317a10ULL, 0x000fe200027fe4ffULL,
0x0000008037347825ULL, 0x100fe200078e0028ULL, 0x0000640032327a10ULL, 0x000fe20007f3e0ffULL,
0x000000002e3b7faeULL, 0x0003e4000b901c46ULL, 0x000000804f367825ULL, 0x100fe200078e0028ULL,
0x0000640034347a10ULL, 0x000fe20007f5e0ffULL, 0x0000000030457faeULL, 0x0003e2000b901c46ULL,
0x0000650033337a10ULL, 0x000fe20000ffe4ffULL, 0x0000008053287825ULL, 0x000fe200078e0028ULL,
0x0000640036367a10ULL, 0x000fc40007f7e0ffULL, 0x0000650035357a10ULL, 0x000fe200017fe4ffULL,
0x0000000032477faeULL, 0x0003e2000b901c46ULL, 0x0000640028287a10ULL, 0x000fe40007f9e0ffULL,
0x0000650037377a10ULL, 0x000fe20001ffe4ffULL, 0x00000000344d7faeULL, 0x0003e2000b901c46ULL,
0x0000650029297a10ULL, 0x000fc600027fe4ffULL, 0x0000000036517faeULL, 0x0003e8000b901c46ULL,
0x0000000028557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff804297812ULL, 0x022fe200078ec0ffULL,
0x000000020c447824ULL, 0x000fe200078e020fULL, 0x000000014c347810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000007292c7812ULL, 0x000fe200078ef804ULL,
0x0000000449317824ULL, 0x000fe200078e024cULL, 0x0000100044447811ULL, 0x000fc400078e60ffULL,
0x00000001ff2d7819ULL, 0x000fe2000001162cULL, 0x000000042c297824ULL, 0x000fe200078e00ffULL,
0x0000002004337810ULL, 0x000fe20007ffe0ffULL, 0x000000042c2c7824ULL, 0x000fe200078e00ffULL,
0x0000000704357812ULL, 0x000fe200078ec0ffULL, 0x000000012d287824ULL, 0x000fe200078e024cULL,
0xfffffff833337812ULL, 0x000fe200078ec0ffULL, 0x000000012d2d7824ULL, 0x000fe200078e0234ULL,
0x0000000835377812ULL, 0x000fe200078ef804ULL, 0x0000000231317824ULL, 0x000fe200078e00ffULL,
0xfffffffc29297812ULL, 0x000fc400078ee228ULL, 0xfffffffc2c2d7812ULL, 0x000fe200078ee22dULL,
0x0000001037397824ULL, 0x000fe200078e00ffULL, 0x0000003104307211ULL, 0x040fe200078fe0ffULL,
0x0000001029297824ULL, 0x000fe200078e0244ULL, 0x0000000733337812ULL, 0x000fe200078ef804ULL,
0x000000102d2d7824ULL, 0x000fe200078e0244ULL, 0x0000000231357810ULL, 0x000fe20007ffe0ffULL,
0x0000000137307824ULL, 0x000fe200078e0230ULL, 0x00000001ff317819ULL, 0x000fe20000011633ULL,
0x000000002928783bULL, 0x000e620000000200ULL, 0x0000003504357211ULL, 0x000fc400078fe0ffULL,
0xfffffff039307812ULL, 0x000fe200078ee230ULL, 0x000000002d2c783bULL, 0x000ea20000000200ULL,
0x0000000433397824ULL, 0x000fe400078e00ffULL, 0x0000000131327824ULL, 0x000fe200078e024cULL,
0x000000024c4c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000137367824ULL, 0x000fe400078e0235ULL,
0x0000000131457824ULL, 0x000fe200078e0234ULL, 0xfffffffc39357812ULL, 0x000fe200078ee232ULL,
0x0000001037377824ULL, 0x000fe200078e00ffULL, 0x000000044c00780cULL, 0x000fe20003f25270ULL,
0x0000001030307824ULL, 0x000fc400078e00ffULL, 0x0000001035357824ULL, 0x000fe200078e0244ULL,
0xfffffff037387812ULL, 0x000fe200078ee236ULL, 0x0000000433367824ULL, 0x000fc800078e00ffULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0xfffffffc36457812ULL, 0x000fca00078ee245ULL,
0x0000001045457824ULL, 0x000fe200078e0244ULL, 0x00000018ff317819ULL, 0x002fe40000011628ULL,
0x000000ff28327812ULL, 0x000fe400078ec0ffULL, 0x00000018ff347819ULL, 0x000fe4000001162bULL,
0x00000031ff31723eULL, 0x000fe400020006ffULL, 0x00000032ff32723eULL, 0x000fe400020006ffULL,
0x00000034ff34723eULL, 0x000fe200020006ffULL, 0x20000031ff4d7230ULL, 0x000fe20000004100ULL,
0x00000018ff377819ULL, 0x004fe2000001162fULL, 0x20000032ff4e7230ULL, 0x000fe20000004100ULL,
0x000000ff2b367812ULL, 0x000fe200078ec0ffULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x20000034ff507230ULL, 0x000fe20000004100ULL, 0x00000010ff347819ULL, 0x000fc4000001162bULL,
0x00000037ff3a723eULL, 0x000fe400020006ffULL, 0x000000ff34347812ULL, 0x000fe400078ec0ffULL,
0x00000036ff36723eULL, 0x000fe200020006ffULL, 0x2000003aff547230ULL, 0x000fe20000004100ULL,
0x00000034ff37723eULL, 0x000fe400020006ffULL, 0x0000ffff2b347812ULL, 0x000fe200078ec0ffULL,
0x20000036ff467230ULL, 0x000fe20000004100ULL, 0x00000010ff2b7819ULL, 0x000fe20000011628ULL,
0x20000037ff4f7230ULL, 0x000fe20000004100ULL, 0x00000008ff347819ULL, 0x000fc40000011634ULL,
0x0000ffff28287812ULL, 0x000fe400078ec0ffULL, 0x00000034ff34723eULL, 0x000fe400020006ffULL,
0x000000ff2b2b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff517819ULL, 0x000fe20000011650ULL,
0x20000034ff477230ULL, 0x000fe20000004100ULL, 0x00000008ff287819ULL, 0x000fe20000011628ULL,
0x000000003534783bULL, 0x000fe20000000200ULL, 0x00000010ff507819ULL, 0x000fc4000001164fULL,
0x00000010ff467819ULL, 0x000fe40000011646ULL, 0x00000010ff4f7819ULL, 0x000fe40000011647ULL,
0x0000002bff2b723eULL, 0x000fe400020006ffULL, 0x00000028ff28723eULL, 0x000fe400020006ffULL,
0x0000105451477816ULL, 0x000fe20000000050ULL, 0x2000002bff2b7230ULL, 0x000fe20000004100ULL,
0x000010544f467816ULL, 0x000fe20000000046ULL, 0x20000028ff287230ULL, 0x000fe20000004100ULL,
0x000000ff2f397812ULL, 0x000fc400078ec0ffULL, 0x00000010ff507819ULL, 0x000fe4000001164dULL,
0x00000039ff39723eULL, 0x000fe200020006ffULL, 0x00000046303c723cULL, 0x002b62000004183cULL,
0x00000010ff527819ULL, 0x000fe4000001162fULL, 0x0000ffff2f2f7812ULL, 0x000fe200078ec0ffULL,
0x20000039ff537230ULL, 0x000fe20000004100ULL, 0x000000ff52527812ULL, 0x000fe200078ec0ffULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x00000010ff477819ULL, 0x020fc4000001162bULL,
0x00000010ff467819ULL, 0x000fe4000001164eULL, 0x00000010ff2b7819ULL, 0x000fe40000011628ULL,
0x0000105450477816ULL, 0x000fe40000000047ULL, 0x000010542b467816ULL, 0x000fe40000000046ULL,
0x00000008ff2f7819ULL, 0x000fe4000001162fULL, 0x00000052ff52723eULL, 0x000fc400020006ffULL,
0x0000002fff2f723eULL, 0x000fe200020006ffULL, 0x000000463040723cULL, 0x000b620000041840ULL,
0x00000010ff547819ULL, 0x000fe20000011654ULL, 0x000000004544783bULL, 0x020ea20000000200ULL,
0x20000052ff527230ULL, 0x000fe20000004100ULL, 0x00000010ff4e7819ULL, 0x000fe20000011653ULL,
0x2000002fff2f7230ULL, 0x000fe20000004100ULL, 0x00000018ff5a7819ULL, 0x000fe4000001162aULL,
0x00000010ff4f7819ULL, 0x000fe40000011652ULL, 0x00000010ff2f7819ULL, 0x000fc4000001162fULL,
0x00001054544f7816ULL, 0x000fe4000000004fULL, 0x000010542f4e7816ULL, 0x000fe4000000004eULL,
0x00000010ff657819ULL, 0x100fe40000011629ULL, 0x00000018ff287819ULL, 0x000fe40000011629ULL,
0x000000ff292b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff29637812ULL, 0x000fe200078ec0ffULL,
0x0000004e383c723cULL, 0x002be2000004183cULL, 0x00000018ff697819ULL, 0x000fc4000001162cULL,
0x00000010ff297819ULL, 0x000fe4000001162aULL, 0x000000ff2a4d7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2a667812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x100fe40000011637ULL,
0x00000018ff587819ULL, 0x000fe40000011637ULL, 0x000000ff374e7812ULL, 0x020fc400078ec0ffULL,
0x0000ffff37507812ULL, 0x000fe400078ec0ffULL, 0x000000ff2c6a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe4000001162dULL, 0x00000018ff707819ULL, 0x000fe4000001162dULL,
0x000000ff2d5b7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2d5c7812ULL, 0x000fc400078ec0ffULL,
0x00000010ff377819ULL, 0x100fe4000001162eULL, 0x00000018ff6e7819ULL, 0x000fe4000001162eULL,
0x000000ff2e2a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff2e5d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5f7819ULL, 0x104fe40000011645ULL, 0x00000018ff2d7819ULL, 0x000fc40000011645ULL,
0x000000ff452e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff45567812ULL, 0x000fe400078ec0ffULL,
0x0000005aff5a723eULL, 0x000fe400020006ffULL, 0x00000010ff617819ULL, 0x000fe4000001162cULL,
0x0000ffff2c717812ULL, 0x000fe400078ec0ffULL, 0x0000002bff6d723eULL, 0x000fc400020006ffULL,
0x00000069ff45723eULL, 0x000fe200020006ffULL, 0x2000005aff697230ULL, 0x000fe20000004100ULL,
0x00000010ff647819ULL, 0x100fe20000011644ULL, 0x2000006dff6d7230ULL, 0x000fe20000004100ULL,
0x00000018ff2b7819ULL, 0x000fe20000011644ULL, 0x20000045ff5a7230ULL, 0x000fe20000004100ULL,
0x000000ff442c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff445e7812ULL, 0x000fe400078ec0ffULL,
0x0000006aff44723eULL, 0x000fc400020006ffULL, 0x0000005bff45723eULL, 0x000fe400020006ffULL,
0x000000ff65657812ULL, 0x000fe200078ec0ffULL, 0x20000044ff5b7230ULL, 0x000fe20000004100ULL,
0x0000006eff44723eULL, 0x000fe200020006ffULL, 0x20000045ff457230ULL, 0x000fe20000004100ULL,
0x0000002aff6e723eULL, 0x000fe400020006ffULL, 0x0000004dff4d723eULL, 0x000fe200020006ffULL,
0x20000044ff2a7230ULL, 0x000fe20000004100ULL, 0x000000ff29447812ULL, 0x000fe200078ec0ffULL,
0x2000006eff297230ULL, 0x000fe20000004100ULL, 0x00000065ff65723eULL, 0x000fe200020006ffULL,
0x2000004dff6a7230ULL, 0x000fe20000004100ULL, 0x00000018ff6b7819ULL, 0x000fc40000011634ULL,
0x00000044ff44723eULL, 0x000fe400020006ffULL, 0x00000008ff667819ULL, 0x000fe40000011666ULL,
0x000000ff346c7812ULL, 0x000fe400078ec0ffULL, 0x00000070ff4d723eULL, 0x000fe200020006ffULL,
0x20000065ff707230ULL, 0x000fe20000004100ULL, 0x0000006bff65723eULL, 0x000fe200020006ffULL,
0x20000044ff6b7230ULL, 0x000fe20000004100ULL, 0x00000066ff66723eULL, 0x000fe200020006ffULL,
0x2000004dff4d7230ULL, 0x000fe20000004100ULL, 0x0000006cff44723eULL, 0x000fe200020006ffULL,
0x20000065ff657230ULL, 0x000fe20000004100ULL, 0x000000ff36577812ULL, 0x000fe200078ec0ffULL,
0x20000066ff6c7230ULL, 0x000fe20000004100ULL, 0x00000058ff58723eULL, 0x000fe200020006ffULL,
0x20000044ff667230ULL, 0x000fe20000004100ULL, 0x00000057ff57723eULL, 0x000fc400020006ffULL,
0x000000ff61447812ULL, 0x000fe400078ec0ffULL, 0x0000004eff4e723eULL, 0x000fe200020006ffULL,
0x20000057ff617230ULL, 0x000fe20000004100ULL, 0x00000008ff637819ULL, 0x000fe20000011663ULL,
0x20000058ff577230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x2000004eff587230ULL, 0x000fe20000004100ULL, 0x00000018ff727819ULL, 0x000fe40000011635ULL,
0x00000063ff63723eULL, 0x000fc400020006ffULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x00000008ff4e7819ULL, 0x000fe2000001165cULL, 0x20000044ff5c7230ULL, 0x000fe20000004100ULL,
0x000000ff35547812ULL, 0x000fe200078ec0ffULL, 0x20000063ff6e7230ULL, 0x000fe20000004100ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x000000ff37447812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f4f7812ULL, 0x000fc400078ec0ffULL, 0x00000071ff71723eULL, 0x000fe400020006ffULL,
0x00000008ff377819ULL, 0x000fe4000001165dULL, 0x00000054ff63723eULL, 0x000fe200020006ffULL,
0x20000072ff547230ULL, 0x000fe20000004100ULL, 0x00000044ff44723eULL, 0x000fe200020006ffULL,
0x20000071ff5d7230ULL, 0x000fe20000004100ULL, 0x0000004fff72723eULL, 0x000fe200020006ffULL,
0x20000063ff637230ULL, 0x000fe20000004100ULL, 0x00000037ff37723eULL, 0x000fc400020006ffULL,
0x0000002bff71723eULL, 0x000fe200020006ffULL, 0x20000044ff2b7230ULL, 0x000fe20000004100ULL,
0x00000010ff677819ULL, 0x000fe40000011634ULL, 0x00000018ff2f7819ULL, 0x000fe40000011646ULL,
0x0000004eff4f723eULL, 0x000fe200020006ffULL, 0x20000072ff4e7230ULL, 0x000fe20000004100ULL,
0x0000002cff44723eULL, 0x000fe200020006ffULL, 0x20000037ff2c7230ULL, 0x000fe20000004100ULL,
0x0000ffff34627812ULL, 0x000fe200078ec0ffULL, 0x2000004fff4f7230ULL, 0x000fe20000004100ULL,
0x000000ff46347812ULL, 0x000fc400078ec0ffULL, 0x0000002dff72723eULL, 0x000fe200020006ffULL,
0x20000071ff2d7230ULL, 0x000fe20000004100ULL, 0x0000002eff37723eULL, 0x000fe200020006ffULL,
0x20000044ff2e7230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fe40000011635ULL,
0x0000ffff35517812ULL, 0x000fe400078ec0ffULL, 0x000000ff67677812ULL, 0x000fe400078ec0ffULL,
0x00000018ff357819ULL, 0x000fc40000011647ULL, 0x0000002fff71723eULL, 0x000fe200020006ffULL,
0x20000072ff2f7230ULL, 0x000fe20000004100ULL, 0x00000010ff537819ULL, 0x100fe40000011636ULL,
0x00000018ff607819ULL, 0x000fe40000011636ULL, 0x0000ffff36687812ULL, 0x000fe400078ec0ffULL,
0x000000ff47367812ULL, 0x000fe400078ec0ffULL, 0x00000034ff44723eULL, 0x000fe200020006ffULL,
0x20000037ff347230ULL, 0x000fe20000004100ULL, 0x00000008ff627819ULL, 0x000fc40000011662ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x000000ff52527812ULL, 0x000fe400078ec0ffULL,
0x00000008ff517819ULL, 0x000fe20000011651ULL, 0x20000067ff727230ULL, 0x000fe20000004100ULL,
0x00000035ff37723eULL, 0x000fe200020006ffULL, 0x20000071ff357230ULL, 0x000fe20000004100ULL,
0x00000028ff6f723eULL, 0x000fe400020006ffULL, 0x00000036ff71723eULL, 0x000fe200020006ffULL,
0x20000044ff367230ULL, 0x000fe20000004100ULL, 0x00000062ff62723eULL, 0x000fe200020006ffULL,
0x2000006fff6f7230ULL, 0x000fe20000004100ULL, 0x00000052ff52723eULL, 0x000fe200020006ffULL,
0x20000071ff447230ULL, 0x000fe20000004100ULL, 0x00000051ff51723eULL, 0x000fe200020006ffULL,
0x20000062ff767230ULL, 0x000fe20000004100ULL, 0x000000ff53677812ULL, 0x000fe200078ec0ffULL,
0x20000037ff377230ULL, 0x000fe20000004100ULL, 0x00000008ff537819ULL, 0x000fe20000011668ULL,
0x20000052ff687230ULL, 0x000fe20000004100ULL, 0x00000067ff62723eULL, 0x000fe200020006ffULL,
0x20000051ff717230ULL, 0x000fe20000004100ULL, 0x00000010ff527819ULL, 0x000fc4000001166dULL,
0x00000010ff517819ULL, 0x000fe2000001166eULL, 0x20000062ff627230ULL, 0x000fe20000004100ULL,
0x00000053ff67723eULL, 0x000fe400020006ffULL, 0x00000010ff787819ULL, 0x000fe4000001166fULL,
0x00000010ff537819ULL, 0x000fe20000011670ULL, 0x20000067ff677230ULL, 0x000fe20000004100ULL,
0x0000105451527816ULL, 0x000fe40000000052ULL, 0x00000008ff6d7819ULL, 0x000fc40000011650ULL,
0x00000010ff517819ULL, 0x000fe4000001166bULL, 0x0000105478537816ULL, 0x000fe40000000053ULL,
0x00000010ff6e7819ULL, 0x000fe40000011669ULL, 0x00000010ff507819ULL, 0x000fe4000001166aULL,
0x00000010ff6b7819ULL, 0x000fe2000001166cULL, 0x000000523010723cULL, 0x000be20000041810ULL,
0x000010546e517816ULL, 0x000fc40000000051ULL, 0x000010546b507816ULL, 0x000fe40000000050ULL,
0x00000010ff657819ULL, 0x000fe40000011665ULL, 0x00000010ff667819ULL, 0x000fe40000011666ULL,
0x00000010ff727819ULL, 0x000fe20000011672ULL, 0x000000503014723cULL, 0x000b640000041814ULL,
0x00000010ff537819ULL, 0x020fe40000011676ULL, 0x00000060ff60723eULL, 0x000fc400020006ffULL,
0x000000ff64647812ULL, 0x000fe400078ec0ffULL, 0x0000105465517816ULL, 0x000fe20000000072ULL,
0x20000060ff607230ULL, 0x000fe20000004100ULL, 0x0000105453507816ULL, 0x000fe40000000066ULL,
0x00000064ff6a723eULL, 0x000fe400020006ffULL, 0x000000ff59597812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x000fe20000011654ULL, 0x000000503018723cULL, 0x000b620000041818ULL,
0x00000010ff527819ULL, 0x000fe20000011663ULL, 0x2000006aff547230ULL, 0x000fe20000004100ULL,
0x00000010ff537819ULL, 0x000fc40000011668ULL, 0x00000010ff717819ULL, 0x000fe40000011671ULL,
0x00000010ff607819ULL, 0x000fe40000011660ULL, 0x00000010ff507819ULL, 0x020fe40000011661ULL,
0x00000010ff517819ULL, 0x000fe40000011662ULL, 0x00000010ff677819ULL, 0x000fe40000011667ULL,
0x00000059ff59723eULL, 0x000fc400020006ffULL, 0x0000006dff69723eULL, 0x000fe400020006ffULL,
0x0000105464537816ULL, 0x000fe20000000053ULL, 0x20000059ff597230ULL, 0x000fe20000004100ULL,
0x0000105471527816ULL, 0x000fe20000000052ULL, 0x20000069ff697230ULL, 0x000fe20000004100ULL,
0x0000105460517816ULL, 0x000fe40000000051ULL, 0x0000105467507816ULL, 0x000fe40000000050ULL,
0x00000010ff697819ULL, 0x000fe20000011669ULL, 0x00000052301c723cULL, 0x000b62000004181cULL,
0x00000008ff5e7819ULL, 0x000fc4000001165eULL, 0x00000010ff287819ULL, 0x000fe40000011647ULL,
0x000000ff5f637812ULL, 0x000fe400078ec0ffULL, 0x00000010ff537819ULL, 0x020fe2000001165cULL,
0x000000503020723cULL, 0x000b620000041820ULL, 0x00000008ff5c7819ULL, 0x000fe40000011656ULL,
0x00000010ff567819ULL, 0x000fe40000011657ULL, 0x0000005eff5f723eULL, 0x000fc400020006ffULL,
0x00000010ff507819ULL, 0x020fe40000011658ULL, 0x00000010ff517819ULL, 0x000fe40000011659ULL,
0x0000105469507816ULL, 0x000fe40000000050ULL, 0x0000105456517816ULL, 0x000fe40000000051ULL,
0x00000010ff557819ULL, 0x000fe40000011646ULL, 0x0000ffff46467812ULL, 0x000fc400078ec0ffULL,
0x0000ffff47477812ULL, 0x000fe200078ec0ffULL, 0x000000503024723cULL, 0x000b620000041824ULL,
0x00000010ff5e7819ULL, 0x000fe4000001165aULL, 0x00000010ff527819ULL, 0x000fe2000001165bULL,
0x2000005fff5b7230ULL, 0x000fe20000004100ULL, 0x00000010ff5d7819ULL, 0x000fe4000001165dULL,
0x000000ff28307812ULL, 0x020fe400078ec0ffULL, 0x00000010ff287819ULL, 0x000fc40000011629ULL,
0x00000010ff297819ULL, 0x000fe4000001162bULL, 0x00000010ff2a7819ULL, 0x000fe4000001162aULL,
0x00000010ff2b7819ULL, 0x000fe4000001162cULL, 0x000010545e537816ULL, 0x000fe40000000053ULL,
0x000010545d527816ULL, 0x000fe40000000052ULL, 0x000000ff55557812ULL, 0x000fc400078ec0ffULL,
0x00000008ff467819ULL, 0x000fe40000011646ULL, 0x00000008ff477819ULL, 0x000fe20000011647ULL,
0x000000523840723cULL, 0x000b620000041840ULL, 0x000010542a297816ULL, 0x000fe40000000029ULL,
0x000010542b287816ULL, 0x000fe40000000028ULL, 0x00000010ff2c7819ULL, 0x000fe4000001162dULL,
0x00000010ff2a7819ULL, 0x000fc4000001162eULL, 0x00000010ff2b7819ULL, 0x000fe20000011654ULL,
0x000000283814723cULL, 0x000b620000041814ULL, 0x00000010ff5b7819ULL, 0x000fe4000001165bULL,
0x00000063ff63723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x00000055ff57723eULL, 0x000fe200020006ffULL, 0x20000063ff5a7230ULL, 0x000fe20000004100ULL,
0x00000046ff46723eULL, 0x000fc400020006ffULL, 0x00000030ff30723eULL, 0x000fe400020006ffULL,
0x00000047ff47723eULL, 0x000fe200020006ffULL, 0x20000046ff467230ULL, 0x000fe20000004100ULL,
0x000010542c2b7816ULL, 0x000fe2000000002bULL, 0x20000030ff307230ULL, 0x000fe20000004100ULL,
0x000010545b2a7816ULL, 0x000fe2000000002aULL, 0x20000047ff477230ULL, 0x000fe20000004100ULL,
0x00000010ff557819ULL, 0x000fe2000001164dULL, 0x2000005cff4d7230ULL, 0x000fe20000004100ULL,
0x00000010ff527819ULL, 0x020fe20000011645ULL, 0x20000057ff457230ULL, 0x000fe20000004100ULL,
0x00000010ff4e7819ULL, 0x000fe2000001164eULL, 0x0000002a3818723cULL, 0x000b620000041818ULL,
0x00000010ff287819ULL, 0x000fc4000001162fULL, 0x00000010ff297819ULL, 0x000fe4000001165aULL,
0x00000010ff537819ULL, 0x000fe4000001164fULL, 0x00000010ff347819ULL, 0x000fe40000011634ULL,
0x00000010ff4d7819ULL, 0x000fe4000001164dULL, 0x00000010ff2a7819ULL, 0x020fe40000011635ULL,
0x00000010ff2d7819ULL, 0x000fc40000011645ULL, 0x00000010ff367819ULL, 0x000fe40000011636ULL,
0x00000010ff2b7819ULL, 0x000fe40000011646ULL, 0x00000010ff377819ULL, 0x000fe40000011637ULL,
0x00000010ff307819ULL, 0x000fe40000011630ULL, 0x00000010ff447819ULL, 0x000fe40000011644ULL,
0x00000010ff477819ULL, 0x000fc40000011647ULL, 0x00001054554f7816ULL, 0x000fe4000000004eULL,
0x0000105428297816ULL, 0x000fe40000000029ULL, 0x00001054534e7816ULL, 0x000fe40000000052ULL,
0x000010544d287816ULL, 0x000fe40000000034ULL, 0x000010542a2d7816ULL, 0x000fe4000000002dULL,
0x000010542b2c7816ULL, 0x000fe20000000036ULL, 0x0000004e3810723cULL, 0x000b620000041810ULL,
0x0000105437457816ULL, 0x000fc40000000030ULL, 0x0000105447447816ULL, 0x000fca0000000044ULL,
0x00000028381c723cULL, 0x040b70000004181cULL, 0x0000002c3820723cULL, 0x040b700000041820ULL,
0x000000443824723cULL, 0x000b620000041824ULL, 0x0000001000009944ULL, 0x000fe20003c00000ULL,
0xffffe7c000007947ULL, 0x000fcc000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000eULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdb7000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000000640407220ULL, 0x080fe20000410000ULL, 0x00000006242d7220ULL, 0x0a0fe20000410000ULL,
0x0000000612297220ULL, 0x080fe20000410000ULL, 0x000000063c317220ULL, 0x080fe20000410000ULL,
0x000000061d377220ULL, 0x080fe20000410000ULL, 0x0000000627247220ULL, 0x080fe20000410000ULL,
0x00000006412e7220ULL, 0x080fe20000410000ULL, 0x0000000642287220ULL, 0x080fe20000410000ULL,
0x0000000643437220ULL, 0x080fe20000410000ULL, 0x00000006102f7220ULL, 0x080fe20000410000ULL,
0x0000000611387220ULL, 0x080fe20000410000ULL, 0x0000000613397220ULL, 0x080fe20000410000ULL,
0x0000000614357220ULL, 0x080fe20000410000ULL, 0x0000000615307220ULL, 0x080fe20000410000ULL,
0x00000006162b7220ULL, 0x080fe20000410000ULL, 0x00000006172a7220ULL, 0x080fe20000410000ULL,
0x000000063d3c7220ULL, 0x080fe20000410000ULL, 0x000000063e2c7220ULL, 0x080fe20000410000ULL,
0x000000063f3b7220ULL, 0x080fe20000410000ULL, 0x00000006183a7220ULL, 0x080fe20000410000ULL,
0x0000000619327220ULL, 0x080fe20000410000ULL, 0x000000061a1a7220ULL, 0x080fe20000410000ULL,
0x000000061b1b7220ULL, 0x080fe20000410000ULL, 0x000000061c337220ULL, 0x080fe20000410000ULL,
0x000000061e1e7220ULL, 0x080fe20000410000ULL, 0x000000061f1f7220ULL, 0x080fe20000410000ULL,
0x0000000620367220ULL, 0x080fe20000410000ULL, 0x0000000621347220ULL, 0x080fe20000410000ULL,
0x00000006221d7220ULL, 0x080fe20000410000ULL, 0x00000006230f7220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000626127220ULL, 0x000fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007107f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fc400078e001eULL,
0x000000ffff217224ULL, 0x000fe400078e001fULL, 0x000000ffff267224ULL, 0x000fe400078e0043ULL,
0x000000ffff237224ULL, 0x000fe400078e001aULL, 0x000000ffff227224ULL, 0x000fe400078e001bULL,
0x000000ffff1e7224ULL, 0x000fe400078e000fULL, 0x000000ffff1f7224ULL, 0x000fc400078e0012ULL,
0x0000000000127805ULL, 0x002fca0000015200ULL, 0x00000400070f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fc40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011415ULL, 0x000000140f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x000000020f0f7819ULL, 0x000fc80000001214ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400070f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004041c7824ULL, 0x000fe200078e00ffULL,
0x000000030d00720cULL, 0x000fc80003f06070ULL, 0xfffffff01c0f7812ULL, 0x000fca00078ec0ffULL,
0x000000800c0f7824ULL, 0x000fca00078e020fULL, 0x00f400000f107984ULL, 0x0002a20000000c00ULL,
0x000014f000008947ULL, 0x000fea0003800000ULL, 0x00005a0000187b06ULL, 0x000ee20000209000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fe20003f85070ULL,
0x00000002043f7824ULL, 0x000fe200078e00ffULL, 0x00005a00ff417a12ULL, 0x000fc800078e33ffULL,
0x000000063f3f7812ULL, 0x000fca00078ec0ffULL, 0x000000013f3d7824ULL, 0x000fe200078e0200ULL,
0x0000001800187308ULL, 0x008ee40000001000ULL, 0x0ffffffe18157810ULL, 0x008fcc0007ffe0ffULL,
0x0000001500157305ULL, 0x000ee4000021f000ULL, 0x000000ffff177224ULL, 0x008fc800078e0a15ULL,
0x00005a0017177a24ULL, 0x000fc800078e02ffULL, 0x0000001715197227ULL, 0x000fe200078e0014ULL,
0x0000007404147211ULL, 0x000fca00078ff0ffULL, 0x0000001419167227ULL, 0x000fc800078e00ffULL,
0x000000ffff177224ULL, 0x000fc800078e0a16ULL, 0x00005a0017177a24ULL, 0x000fe200078e0214ULL,
0x0000000814147810ULL, 0x000fc80007ffe0ffULL, 0x00005a0017007a0cULL, 0x000fe20003f06070ULL,
0x0000001419407227ULL, 0x000fc800078e00ffULL, 0x000000ffff157224ULL, 0x000fc800078e0a40ULL,
0x00005a0015147a24ULL, 0x000fe400078e0214ULL, 0x000001000d157824ULL, 0x000fe400078e0273ULL,
0x80005a0017170a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0014007a0cULL, 0x000fe40003f46070ULL,
0x00005a0017007a0cULL, 0x000fe40003f26070ULL, 0x000000150a3e7217ULL, 0x000fc40007800000ULL,
0x0000000116160810ULL, 0x000fc60007ffe0ffULL, 0x000000013e3e7824ULL, 0x000fe400078e0a15ULL,
0x000000010b157824ULL, 0x000fe400078e023fULL, 0x80005a0014142a10ULL, 0x000fe40007ffe0ffULL,
0x0000000116161810ULL, 0x000fe20007ffe0ffULL, 0x0000000115177824ULL, 0x040fe200078e0a3eULL,
0x0000003e1500720cULL, 0x000fe40003f66070ULL, 0x0000001641157207ULL, 0x000fc40006000000ULL,
0x0000001708167217ULL, 0x000fe20003800000ULL, 0x000000013d177824ULL, 0x040fe200078e0a3eULL,
0x00005a0014007a0cULL, 0x000fe40003f06070ULL, 0x0000001508147217ULL, 0x040fe40003800000ULL,
0x00000004ff167819ULL, 0x000fe40000011616ULL, 0x0000003e3d00720cULL, 0x000fe20003f26070ULL,
0x00000014055b7224ULL, 0x000fe200078e02ffULL, 0x0000001708177217ULL, 0x000fc40003800000ULL,
0x000000ff16167207ULL, 0x000fe40001800000ULL, 0x000000ff17527207ULL, 0x000fe40000800000ULL,
0x0000000140402810ULL, 0x000fe20007ffe0ffULL, 0x000000015b197824ULL, 0x000fe200078e0216ULL,
0x0000005b521b7211ULL, 0x000fe400078fe0ffULL, 0x0000000140400810ULL, 0x000fe20007ffe0ffULL,
0x0000000219187825ULL, 0x000fe200078e004aULL, 0x000000103f437812ULL, 0x000fc400078efcffULL,
0x0000004041157207ULL, 0x000fe20006000000ULL, 0x000000021b1a7825ULL, 0x000fe200078e004aULL,
0x0000000618547981ULL, 0x000724000c1e9500ULL, 0x0000001508147217ULL, 0x000fe40003800000ULL,
0x000000061a597981ULL, 0x000326000c1e9500ULL, 0x00000014055d7224ULL, 0x000fe400078e02ffULL,
0x000000010b197824ULL, 0x008fc600078e0243ULL, 0x0000005d52157211ULL, 0x000fe400078fe0ffULL,
0x000000203f457812ULL, 0x000fe200078efcffULL, 0x00000001191b7824ULL, 0x042fe200078e0a3eULL,
0x0000003e1900720cULL, 0x000fe20003f26070ULL, 0x0000000215147825ULL, 0x000fc600078e004aULL,
0x0000001b081b7217ULL, 0x000fe20003800000ULL, 0x000000010b4d7824ULL, 0x000fe200078e0245ULL,
0x0000000614577981ULL, 0x0002e2000c1e9500ULL, 0x0000000143417824ULL, 0x000fe200078e0200ULL,
0x00000004ff1b7819ULL, 0x000fe2000001161bULL, 0x0000000116177824ULL, 0x000fc600078e025dULL,
0x000000ff1b187207ULL, 0x000fe20000800000ULL, 0x000000014d4f7824ULL, 0x100fe400078e0a3eULL,
0x0000000141197824ULL, 0x000fe400078e0a3eULL, 0x000000015b157824ULL, 0x002fe200078e0218ULL,
0x0000004f08467217ULL, 0x000fe20003800000ULL, 0x0000000145497824ULL, 0x000fe400078e0200ULL,
0x0000000215147825ULL, 0x000fe200078e004aULL, 0x0000003e4100720cULL, 0x000fc40003f06070ULL,
0x0000001908197217ULL, 0x000fe20003800000ULL, 0x0000000217167825ULL, 0x000fe200078e004aULL,
0x0000000614427981ULL, 0x0042a2000c1e9500ULL, 0x0000003e4d00720cULL, 0x080fe40003f26070ULL,
0x00000004ff467819ULL, 0x000fe20000011646ULL, 0x00000006164e7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff19407207ULL, 0x000fe20000000000ULL, 0x0000000149157824ULL, 0x042fe200078e0a3eULL,
0x0000003e4900720cULL, 0x000fe40003f06070ULL, 0x000000ff464c7207ULL, 0x000fc40000800000ULL,
0x0000001508157217ULL, 0x000fe40003800000ULL, 0x000000303f4d7812ULL, 0x000fe200078efcffULL,
0x0000000118197824ULL, 0x000fe200078e025dULL, 0x0000005b40177211ULL, 0x040fe400078fe0ffULL,
0x0000005d401b7211ULL, 0x000fe400078fe0ffULL, 0x000000ff15467207ULL, 0x000fe20000000000ULL,
0x000000015b157824ULL, 0x000fe400078e024cULL, 0x000000010b5f7824ULL, 0x000fc400078e024dULL,
0x0000000217167825ULL, 0x000fc800078e004aULL, 0x0000000219187825ULL, 0x100fe200078e004aULL,
0x0000000616477981ULL, 0x0002a6000c1e9500ULL, 0x000000021b1a7825ULL, 0x100fe200078e004aULL,
0x0000000618447981ULL, 0x0002a6000c1e9500ULL, 0x0000000215147825ULL, 0x000fe200078e004aULL,
0x000000061a4f7981ULL, 0x0002a6000c1e9500ULL, 0x000000015f557824ULL, 0x000fe200078e0a3eULL,
0x0000000614487981ULL, 0x0002a2000c1e9500ULL, 0x000000014d537824ULL, 0x000fe200078e0200ULL,
0x0000005b46177211ULL, 0x002fc400078fe0ffULL, 0x0000005508507217ULL, 0x000fe20003800000ULL,
0x000000014c197824ULL, 0x000fe200078e025dULL, 0x0000005d461b7211ULL, 0x000fe200078fe0ffULL,
0x0000000153157824ULL, 0x000fe200078e0a3eULL, 0x0000003e5f00720cULL, 0x080fe40003f26070ULL,
0x00000004ff507819ULL, 0x000fe20000011650ULL, 0x0000000217167825ULL, 0x100fe200078e004aULL,
0x0000003e5300720cULL, 0x000fe40003f06070ULL, 0x0000001508157217ULL, 0x000fe20003800000ULL,
0x0000000219187825ULL, 0x100fe200078e004aULL, 0x000000ff50567207ULL, 0x000fe20000800000ULL,
0x0000000616517981ULL, 0x0002a4000c1e9500ULL, 0x000000021b1a7825ULL, 0x000fe200078e004aULL,
0x000000ff15507207ULL, 0x000fe20000000000ULL, 0x00000006184c7981ULL, 0x0002a8000c1e9500ULL,
0x000000061a557981ULL, 0x0002a2000c1e9500ULL, 0x000000015b157824ULL, 0x000fe200078e0256ULL,
0x0000005b50177211ULL, 0x002fc600078fe0ffULL, 0x0000000215147825ULL, 0x000fc800078e004aULL,
0x0000000217167825ULL, 0x000fe400078e004aULL, 0x0000000614147981ULL, 0x0002a2000c1e9500ULL,
0x0000005d50197211ULL, 0x000fc600078fe0ffULL, 0x0000000616177981ULL, 0x0002a2000c1e9500ULL,
0x00000001561b7824ULL, 0x000fe400078e025dULL, 0x0000000219187825ULL, 0x000fc800078e004aULL,
0x000000021b1a7825ULL, 0x000fe400078e004aULL, 0x0000000618187981ULL, 0x0002a8000c1e9500ULL,
0x000000061a1b7981ULL, 0x0002a2000c1e9500ULL, 0xfffffff0525b7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff527424ULL, 0x000fc800078e00ffULL, 0x000000013e567824ULL, 0x000fe200078e025bULL,
0x000000013f157812ULL, 0x002fc600078efcffULL, 0x000000013d617824ULL, 0x000fe200078e0a56ULL,
0x000000093f5d7812ULL, 0x000fe200078efcffULL, 0x00000001155f7824ULL, 0x000fc600078e0200ULL,
0x0000006152617219ULL, 0x040fe200000006ffULL, 0x000000015d197824ULL, 0x000fe400078e0200ULL,
0x000000015f637824ULL, 0x100fe400078e0a56ULL, 0x0000000119677824ULL, 0x000fe200078e0a56ULL,
0x000000183f7b7812ULL, 0x000fe400078efcffULL, 0x0000006352637219ULL, 0x040fe400000006ffULL,
0x0000006752677219ULL, 0x000fc400000006ffULL, 0xfffffff040407812ULL, 0x000fe400078ec0ffULL,
0xfffffff050507812ULL, 0x000fe200078ec0ffULL, 0x000000017b1a7824ULL, 0x000fc800078e0200ULL,
0x000000013e5c7824ULL, 0x000fe200078e0250ULL, 0x000000193f797812ULL, 0x040fe400078efcffULL,
0x000000113f7d7812ULL, 0x040fe400078efcffULL, 0x000000213f6b7812ULL, 0x040fe400078efcffULL,
0x000000283f697812ULL, 0x000fe200078efcffULL, 0x0000000179167824ULL, 0x100fe400078e0200ULL,
0x000000016b717824ULL, 0x000fc400078e0200ULL, 0x00000001696f7824ULL, 0x000fe400078e0200ULL,
0x0000000153667824ULL, 0x000fca00078e0a5cULL, 0x0000006652667219ULL, 0x000fe400000006ffULL,
0x0000541059547816ULL, 0x010fe40000000054ULL, 0x000000083f597812ULL, 0x000fe400078efcffULL,
0x0000005461ff7212ULL, 0x000fc6000780c0ffULL, 0x00000001595b7824ULL, 0x000fe200078e0200ULL,
0x0000003e3d00720cULL, 0x000fc60000701470ULL, 0x000000015b657824ULL, 0x000fe200078e0a56ULL,
0x0000003e3f00720cULL, 0x000fc800007a1070ULL, 0x0000006552657219ULL, 0x000fe400000006ffULL,
0x0000005463ff7212ULL, 0x080fe4000782c0ffULL, 0x0000005465ff7212ULL, 0x080fe4000786c0ffULL,
0x0000005467ff7212ULL, 0x000fe4000788c0ffULL, 0xff80000027277808ULL, 0x000fe40002800000ULL,
0xfffffff046547812ULL, 0x000fe200078ec0ffULL, 0x000000013e467824ULL, 0x000fc800078e0240ULL,
0x0000000141507824ULL, 0x100fe400078e0a46ULL, 0x000000011a587824ULL, 0x000fe200078e0a46ULL,
0x00005410574e7816ULL, 0x008fc8000000004eULL, 0x0000004e61ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004e65ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004e67ff7212ULL, 0x000fe400078ac0ffULL,
0x0000003e3d00720cULL, 0x080fe40001741470ULL, 0x0000003e5b00720cULL, 0x080fe400037c1470ULL,
0x0000003e1900720cULL, 0x000fc40002fa1470ULL, 0x0000003e3f00720cULL, 0x080fe40001741070ULL,
0x0000003e5900720cULL, 0x080fe400037c1070ULL, 0x0000003e5d00720cULL, 0x000fe40002fa1070ULL,
0x0000005052507219ULL, 0x040fe400000006ffULL, 0x0000005852587219ULL, 0x000fe400000006ffULL,
0x0000004e63ff7212ULL, 0x000fc4000780c0ffULL, 0x000000293f677812ULL, 0x000fe400078efcffULL,
0x0000541047477816ULL, 0x004fe40000000042ULL, 0x000000313f637812ULL, 0x040fe400078efcffULL,
0x000000383f617812ULL, 0x000fe400078efcffULL, 0x000054104f4f7816ULL, 0x000fe40000000044ULL,
0x000000393f577812ULL, 0x000fe200078efcffULL, 0x000000017d4e7824ULL, 0x000fe200078e0200ULL,
0xff80000028287808ULL, 0x000fe20001000000ULL, 0x000000013e547824ULL, 0x000fe200078e0254ULL,
0xff80000029297808ULL, 0x000fc40003000000ULL, 0xff80000039397808ULL, 0x000fe40002800000ULL,
0x0000004750ff7212ULL, 0x040fe4000784c0ffULL, 0x0000004f50ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004f58ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001676d7824ULL, 0x100fe200078e0200ULL,
0x0000003e5f00720cULL, 0x080fe20000f21470ULL, 0x0000000163657824ULL, 0x100fe200078e0200ULL,
0x0000003e5f00720cULL, 0x080fe20000701470ULL, 0x0000000161777824ULL, 0x100fe200078e0200ULL,
0x0000003e5b00720cULL, 0x080fe20001f61470ULL, 0x0000000157407824ULL, 0x000fe200078e0200ULL,
0x0000003e1900720cULL, 0x080fe20002781470ULL, 0x00000001165a7824ULL, 0x100fe200078e0a46ULL,
0x0000003e4100720cULL, 0x0c0fe20001741470ULL, 0x000000014e567824ULL, 0x000fe200078e0a46ULL,
0x0000003e4100720cULL, 0x080fe200037c1470ULL, 0x00000001495e7824ULL, 0x100fe200078e0a54ULL,
0x0000003e1a00720cULL, 0x000fe20002fa1470ULL, 0x0000000171607824ULL, 0x000fc400078e0a54ULL,
0x000000016f627824ULL, 0x100fe400078e0a54ULL, 0x000000016d647824ULL, 0x000fe200078e0a54ULL,
0x0000003e1500720cULL, 0x080fe20000f21070ULL, 0x0000000165687824ULL, 0x100fe200078e0a5cULL,
0x0000003e1500720cULL, 0x080fe20000701070ULL, 0x0000000177467824ULL, 0x100fe200078e0a5cULL,
0x0000003e5900720cULL, 0x000fe20001f61070ULL, 0x0000000140547824ULL, 0x000fe200078e0a5cULL,
0x0000005a525c7219ULL, 0x000fe400000006ffULL, 0x0000003e5d00720cULL, 0x000fc40002781070ULL,
0x0000003e4300720cULL, 0x0c0fe40001741070ULL, 0x0000003e4300720cULL, 0x080fe400037c1070ULL,
0x0000003e7b00720cULL, 0x000fe40002fa1070ULL, 0x0000005652567219ULL, 0x040fe400000006ffULL,
0x0000005e525a7219ULL, 0x000fe400000006ffULL, 0x0000541051517816ULL, 0x000fc40000000048ULL,
0x0000541055557816ULL, 0x000fe4000000004cULL, 0xff8000002e2e7808ULL, 0x000fe40000800000ULL,
0xff80000026267808ULL, 0x000fe40000000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40002000000ULL, 0xff80000035357808ULL, 0x000fc40001000000ULL,
0xff8000002b2b7808ULL, 0x000fe40003000000ULL, 0xff8000002c2c7808ULL, 0x000fe40002800000ULL,
0x0000004756ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004758ff7212ULL, 0x080fe4000780c0ffULL,
0x000000475cff7212ULL, 0x000fe4000786c0ffULL, 0x0000004f56ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004f5cff7212ULL, 0x000fe4000784c0ffULL, 0x000000515aff7212ULL, 0x040fe400078cc0ffULL,
0x000000555aff7212ULL, 0x000fe400078ac0ffULL, 0x0000003e4e00720cULL, 0x0c0fe40000f21470ULL,
0x0000003e4e00720cULL, 0x080fe40002781470ULL, 0x0000003e1a00720cULL, 0x000fc40000701470ULL,
0x0000003e1600720cULL, 0x0c0fe40001f61470ULL, 0x0000003e1600720cULL, 0x080fe40001741470ULL,
0x0000003e4900720cULL, 0x0c0fe400037c1470ULL, 0x0000003e4900720cULL, 0x080fe40002fa1470ULL,
0x0000003e7d00720cULL, 0x0c0fe40000f21070ULL, 0x0000003e7d00720cULL, 0x000fc40002781070ULL,
0x0000003e7b00720cULL, 0x080fe40000701070ULL, 0x0000003e7900720cULL, 0x0c0fe40001f61070ULL,
0x0000003e7900720cULL, 0x080fe40001741070ULL, 0x0000003e4500720cULL, 0x0c0fe400037c1070ULL,
0x0000003e4500720cULL, 0x000fe40002fa1070ULL, 0x0000006052607219ULL, 0x000fc400000006ffULL,
0x0000006252627219ULL, 0x040fe400000006ffULL, 0x0000006452647219ULL, 0x000fe400000006ffULL,
0x0000541017147816ULL, 0x000fe40000000014ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff80000031317808ULL, 0x000fc40000000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff8000003a3a7808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fe40002800000ULL,
0x0000005160ff7212ULL, 0x080fe4000782c0ffULL, 0x0000005162ff7212ULL, 0x000fc4000788c0ffULL,
0x0000005164ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005560ff7212ULL, 0x080fe4000786c0ffULL,
0x0000005562ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005564ff7212ULL, 0x000fe400078cc0ffULL,
0x0000001466ff7212ULL, 0x000fe400078ac0ffULL, 0x0000003e7100720cULL, 0x000fc40000f21470ULL,
0x0000003e7100720cULL, 0x080fe40001f61470ULL, 0x0000003e6f00720cULL, 0x0c0fe40002781470ULL,
0x0000003e6f00720cULL, 0x080fe40001741470ULL, 0x0000003e6d00720cULL, 0x0c0fe40000701470ULL,
0x0000003e6d00720cULL, 0x080fe400037c1470ULL, 0x0000003e5300720cULL, 0x000fc40002fa1470ULL,
0x0000003e6b00720cULL, 0x0c0fe40000f21070ULL, 0x0000003e6b00720cULL, 0x080fe40001f61070ULL,
0x0000003e6900720cULL, 0x0c0fe40002781070ULL, 0x0000003e6900720cULL, 0x080fe40001741070ULL,
0x0000003e6700720cULL, 0x0c0fe40000701070ULL, 0x0000003e6700720cULL, 0x000fc400037c1070ULL,
0x0000003e4d00720cULL, 0x000fe40002fa1070ULL, 0x0000006852687219ULL, 0x040fe400000006ffULL,
0x0000004652467219ULL, 0x040fe400000006ffULL, 0x0000005452547219ULL, 0x000fe400000006ffULL,
0x00005410181b7816ULL, 0x000fe4000000001bULL, 0xff80000032327808ULL, 0x000fc40000800000ULL,
0xff80000022227808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40002000000ULL,
0xff80000020207808ULL, 0x000fe40001000000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000021217808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fc40002800000ULL,
0x0000001468ff7212ULL, 0x080fe4000782c0ffULL, 0x0000001446ff7212ULL, 0x080fe4000786c0ffULL,
0x0000001454ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001b66ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001b68ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001b46ff7212ULL, 0x000fc400078cc0ffULL,
0x0000001b54ff7212ULL, 0x000fe400078ac0ffULL, 0x0000003e5300720cULL, 0x080fe40001741470ULL,
0x0000003e6500720cULL, 0x0c0fe40000f21470ULL, 0x0000003e6500720cULL, 0x080fe40000701470ULL,
0x0000003e7700720cULL, 0x0c0fe40001f61470ULL, 0x0000003e7700720cULL, 0x000fc400037c1470ULL,
0x0000003e4000720cULL, 0x0c0fe40002781470ULL, 0x0000003e4000720cULL, 0x080fe40002fa1470ULL,
0x0000003e4d00720cULL, 0x080fe40001741070ULL, 0x0000003e6300720cULL, 0x0c0fe40000f21070ULL,
0x0000003e6300720cULL, 0x080fe40000701070ULL, 0x0000003e6100720cULL, 0x000fc40001f61070ULL,
0x0000003e6100720cULL, 0x080fe400037c1070ULL, 0x0000003e5700720cULL, 0x0c0fe40002781070ULL,
0x0000003e5700720cULL, 0x000fe40002fa1070ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff8000002d2d7808ULL, 0x000fe40001800000ULL, 0xff80000025257808ULL, 0x000fc40002000000ULL,
0xff8000001d1d7808ULL, 0x000fe40001000000ULL, 0xff8000001e1e7808ULL, 0x000fe40000000000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000024247808ULL, 0x000fc40002800000ULL,
0x000000271000720bULL, 0x004fe20003f1e000ULL, 0x0000001fff187424ULL, 0x000fe200078e00ffULL,
0x000000281100720bULL, 0x000fe20003f3e000ULL, 0xffffffffff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001027157208ULL, 0x000fc40004000000ULL, 0x0000001128117208ULL, 0x000fe40004800000ULL,
0x0000002e1500720bULL, 0x000fe40003f1e000ULL, 0x000000261100720bULL, 0x000fe40003f3e000ULL,
0x000000152e107208ULL, 0x000fe40004000000ULL, 0x0000001126147208ULL, 0x000fe40004800000ULL,
0x0000002f1000720bULL, 0x000fc40003f1e000ULL, 0x000000291400720bULL, 0x000fe40003f3e000ULL,
0x000000102f117208ULL, 0x000fe40004000000ULL, 0x0000001429147208ULL, 0x000fe40004800000ULL,
0x000000381100720bULL, 0x000fe40003f1e000ULL, 0x000000391400720bULL, 0x000fe40003f3e000ULL,
0x0000001138107208ULL, 0x000fc40004000000ULL, 0x0000001439147208ULL, 0x000fe40004800000ULL,
0x000000351000720bULL, 0x000fe40003f1e000ULL, 0x0000002b1400720bULL, 0x000fe40003f3e000ULL,
0x0000001035117208ULL, 0x000fe40004000000ULL, 0x000000142b157208ULL, 0x000fe40004800000ULL,
0x000000301100720bULL, 0x000fc40003f1e000ULL, 0x0000002a1500720bULL, 0x000fe40003f3e000ULL,
0x0000001130107208ULL, 0x000fe40004000000ULL, 0x000000152a157208ULL, 0x000fe40004800000ULL,
0x000000311000720bULL, 0x000fe40003f1e000ULL, 0x0000002c1500720bULL, 0x000fe40003f3e000ULL,
0x0000001031117208ULL, 0x000fc40004000000ULL, 0x000000152c107208ULL, 0x000fe40004800000ULL,
0x0000003c1100720bULL, 0x000fe40003f1e000ULL, 0x0000003b1000720bULL, 0x000fe40003f3e000ULL,
0x000000113c117208ULL, 0x000fe40004000000ULL, 0x000000103b107208ULL, 0x000fe40004800000ULL,
0x0000003a1100720bULL, 0x000fc40003f1e000ULL, 0x000000231000720bULL, 0x000fe40003f3e000ULL,
0x000000113a117208ULL, 0x000fe40004000000ULL, 0x0000001023157208ULL, 0x000fe40004800000ULL,
0x000000321100720bULL, 0x000fe40003f1e000ULL, 0x000000221500720bULL, 0x000fe40003f3e000ULL,
0x0000001132107208ULL, 0x000fc40004000000ULL, 0x0000001522157208ULL, 0x000fe40004800000ULL,
0x000000331000720bULL, 0x000fe40003f1e000ULL, 0x000000201500720bULL, 0x000fe40003f3e000ULL,
0x0000001033107208ULL, 0x000fe40004000000ULL, 0x0000001520147208ULL, 0x000fe40004800000ULL,
0x000000371000720bULL, 0x000fc40003f1e000ULL, 0x000000211400720bULL, 0x000fe40003f3e000ULL,
0x0000001037117208ULL, 0x000fe40004000000ULL, 0x0000001421147208ULL, 0x000fe40004800000ULL,
0x000000361100720bULL, 0x000fe40003f1e000ULL, 0x0000001d1400720bULL, 0x000fe40003f3e000ULL,
0x0000001136117208ULL, 0x000fc40004000000ULL, 0x000000141d157208ULL, 0x000fe40004800000ULL,
0x000000341100720bULL, 0x000fe40003f1e000ULL, 0x0000001e1500720bULL, 0x000fe40003f3e000ULL,
0x0000001134107208ULL, 0x000fe40004000000ULL, 0x000000151e147208ULL, 0x000fe40004800000ULL,
0x0000002d1000720bULL, 0x000fc40003f1e000ULL, 0x0000001f1400720bULL, 0x000fe40003f3e000ULL,
0x000000102d107208ULL, 0x000fe40004000000ULL, 0x000000141f117208ULL, 0x000fe40004800000ULL,
0x000000251000720bULL, 0x000fe40003f1e000ULL, 0x000000241100720bULL, 0x000fe40003f3e000ULL,
0x0000001025167208ULL, 0x000fc40004000000ULL, 0x0000001124197208ULL, 0x000fe20004800000ULL,
0x000014827f007947ULL, 0x000fec000b800000ULL, 0x0c401f0016107f89ULL, 0x0004e400000e0000ULL,
0x000000101600720bULL, 0x008fc80003f1e000ULL, 0x00000016101b7208ULL, 0x000fe20004000000ULL,
0x000014927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0019107f89ULL, 0x000ee800000e0000ULL,
0x0c401f0012117f89ULL, 0x000f2800000e0000ULL, 0x0c401f0013167f89ULL, 0x006e6200000e0000ULL,
0x000000101900720bULL, 0x008fc40003f1e000ULL, 0x000000111200720bULL, 0x010fe40003f3e000ULL,
0x0000001910147208ULL, 0x000fe40004000000ULL, 0x0000001211157208ULL, 0x000fe20004800000ULL,
0x0c201f001b107f89ULL, 0x000ea200000e0000ULL, 0x000000161300720bULL, 0x002fc60003f1e000ULL,
0x0c201f0014117f89ULL, 0x000e6200000e0000ULL, 0x00000013163d7208ULL, 0x000fc60004000000ULL,
0x0c201f0015187f89ULL, 0x000ee800000e0000ULL, 0x0c201f003d3e7f89ULL, 0x0002e200000e0000ULL,
0x000000101b00720bULL, 0x004fe40003f1e000ULL, 0x000000111400720bULL, 0x002fe40003f3e000ULL,
0x0000001b10107208ULL, 0x000fe40004000000ULL, 0x000000181500720bULL, 0x008fc40003f5e000ULL,
0x0000001411117208ULL, 0x000fe40004800000ULL, 0x0000001518127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b10137820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x0000000c1c1c7812ULL, 0x000fe400078ec0ffULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010813ULL, 0x0000002f00167308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010813ULL, 0x0000002700147308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b342f7823ULL, 0x002fe20000010813ULL, 0x3fb8aa3b11347820ULL, 0x000fe20000410000ULL,
0x0000000304ff7812ULL, 0x000fc4000780c0ffULL, 0x0000003e3d00720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010834ULL,
0x0000002e00157308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b2c1a7823ULL, 0x100fe20000010834ULL,
0x00000004ff2c7e24ULL, 0x000fe2000f8e00ffULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3f8000002c2c783eULL, 0x000fe200000010ffULL,
0x0000003800177308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b362e7823ULL, 0x102fe20000010813ULL,
0x3fb8aa3b23237823ULL, 0x000fe20000010834ULL, 0x3fb8aa3b3a277823ULL, 0x000fe20000010813ULL,
0x000000ffff3a7224ULL, 0x000fe200078e002cULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe20000010834ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x000000141514723eULL, 0x004fce00000010ffULL,
0x0000002600197308ULL, 0x0002a20000000800ULL, 0x000000161716723eULL, 0x008fce00000010ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22267823ULL, 0x002fce0000010834ULL,
0x0000003900187308ULL, 0x000e620000000800ULL, 0x000000281915723eULL, 0x004fce00000010ffULL,
0x0000003000407308ULL, 0x0005e20000000800ULL, 0x000000291817723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b2d307823ULL, 0x004fe20000010813ULL, 0x000000ffff2d7224ULL, 0x000fca00078e002cULL,
0x0000001a00367308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b25137823ULL, 0x000fce0000010813ULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x0000002c1418723cULL, 0x002b6e00000418ffULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x3fb8aa3b202d7823ULL, 0x020fce0000010834ULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000003c003c7308ULL, 0x000ea20000000800ULL,
0x000000354020723eULL, 0x002fce00000010ffULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000313c22723eULL, 0x004fce00000010ffULL,
0x0000003700387308ULL, 0x0005f00000000800ULL, 0x0000002300287308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b21377823ULL, 0x104fe20000010834ULL, 0x0000002b2a21723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b24347823ULL, 0x000fe20000010834ULL, 0x00000002ff2b7819ULL, 0x000fc80000011604ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000363b23723eULL, 0x008fe200000010ffULL,
0x000000ffff3b7224ULL, 0x000fe200078e002cULL, 0x000000012b257810ULL, 0x040fe20007ffe0ffULL,
0x000000082b367824ULL, 0x040fe200078e00ffULL, 0x000000082b417810ULL, 0x040fe20007ffe0ffULL,
0x000000082b397824ULL, 0x040fe400078e00ffULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x0000003a2018723cULL, 0x000f620000041818ULL, 0x000000082b3f7824ULL, 0x000fcc00078e00ffULL,
0x0000002d002d7308ULL, 0x000ff00000000800ULL, 0x00000037002a7308ULL, 0x0004e20000000800ULL,
0x000000273224723eULL, 0x002fe200000010ffULL, 0x000000082b327824ULL, 0x000fcc00078e00ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000082b377824ULL, 0x004fce00078e00ffULL,
0x0000002600297308ULL, 0x0005220000000800ULL, 0x0000002d2a27723eULL, 0x008fe200000010ffULL,
0x000000ffff2d7224ULL, 0x000fe200078e002cULL, 0x000000042b2a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff837377812ULL, 0x000fe200078ee22aULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x000000082b267824ULL, 0x044fe200078e00ffULL, 0xffffffff2b2a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff826317812ULL, 0x000fe400078ee225ULL, 0x000000333826723eULL, 0x002fe200000010ffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x000000282925723eULL, 0x010fe200000010ffULL,
0x000000082b337824ULL, 0x040fe200078e00ffULL, 0x000000032b297810ULL, 0x040fe40007ffe0ffULL,
0x000000022b287810ULL, 0x000fe40007ffe0ffULL, 0xfffffff832357812ULL, 0x000fe200078ee229ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x0000002c2418723cULL, 0x020b620000041818ULL,
0xfffffff833337812ULL, 0x000fc400078ee228ULL, 0x000000062b297810ULL, 0x040fe40007ffe0ffULL,
0x000000052b287810ULL, 0x000fe40007ffe0ffULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0xfffffff8322d7812ULL, 0x020fe200078ee22bULL, 0x0000000841327824ULL, 0x000fe200078e00ffULL,
0xfffffff8363b7812ULL, 0x000fe400078ee229ULL, 0xfffffff839397812ULL, 0x000fe400078ee228ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee22aULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x0000001d1e29723eULL, 0x002fe200000010ffULL, 0x000000ffff1e7224ULL, 0x000fe200078e002cULL,
0xfffffff832417812ULL, 0x000fca00078ee241ULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x0000001f342b723eULL, 0x004fe200000010ffULL, 0x000000ffff1f7224ULL, 0x000fcc00078e002cULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x0000002e2f28723eULL, 0x002fe400000010ffULL, 0x000090000c2e7811ULL, 0x000fca00078e58ffULL,
0x000000102d2d7824ULL, 0x100fe400078e022eULL, 0x0000001031317824ULL, 0x100fe400078e022eULL,
0x0000001033337824ULL, 0x100fe400078e022eULL, 0x0000001035357824ULL, 0x100fe200078e022eULL,
0x00000030132a723eULL, 0x004fe200000010ffULL, 0x0000001037377824ULL, 0x000fe200078e022eULL,
0x0000003d3e137208ULL, 0x000fe20004800000ULL, 0x000000012d2d7824ULL, 0x000fc400078e021cULL,
0x0000001039397824ULL, 0x100fe400078e022eULL, 0x0000001e2818723cULL, 0x000f620000041818ULL,
0x000000011c317824ULL, 0x040fe200078e0231ULL, 0x000000142d007388ULL, 0x0003e20000000800ULL,
0x000000103b3b7824ULL, 0x100fe400078e022eULL, 0x000000011c337824ULL, 0x040fe200078e0233ULL,
0x0000001631007388ULL, 0x0003e20000000800ULL, 0x000000103f3f7824ULL, 0x100fe400078e022eULL,
0x000000011c357824ULL, 0x000fe200078e0235ULL, 0x0000002033007388ULL, 0x0003e20000000800ULL,
0x0000001041417824ULL, 0x000fc400078e022eULL, 0x000000011c377824ULL, 0x040fe200078e0237ULL,
0x0000002235007388ULL, 0x0003e20000000800ULL, 0x000000011c397824ULL, 0x040fe400078e0239ULL,
0x000000011c3b7824ULL, 0x040fe200078e023bULL, 0x0000002437007388ULL, 0x0003e20000000800ULL,
0x000000011c3f7824ULL, 0x040fe400078e023fULL, 0x000000011c1c7824ULL, 0x000fe200078e0241ULL,
0x0000002639007388ULL, 0x0003e40000000800ULL, 0x000000ffff197224ULL, 0x020fc400078e001aULL,
0x000000283b007388ULL, 0x0003e80000000800ULL, 0x0000002a3f007388ULL, 0x0003e80000000800ULL,
0x000000151c007388ULL, 0x0003e80000000800ULL, 0x0004001731007388ULL, 0x0003e80000000800ULL,
0x0004002133007388ULL, 0x0003e80000000800ULL, 0x0004002335007388ULL, 0x0003e80000000800ULL,
0x0004002537007388ULL, 0x0003e80000000800ULL, 0x0004002739007388ULL, 0x0003e80000000800ULL,
0x000400293b007388ULL, 0x0003e80000000800ULL, 0x0004002b3f007388ULL, 0x0003e80000000800ULL,
0x00f000100f008388ULL, 0x0003e80000000c00ULL, 0x00f200180f008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000075ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080075ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100075ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000010d0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000180075ff7f8cULL, 0x0003e6000c80043fULL, 0x000000090d00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffae3000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff117807ULL, 0x008fe40004000000ULL,
0x00014ac000187802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x002fea0003c00000ULL,
0xfffedb7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40005000000ULL,
0x00014b0000187802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0011ULL, 0xfffedbd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0012ULL, 0x00014b5000197802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0xfffedcb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0012ULL, 0x00014b9000197802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x002fea0003c00000ULL, 0xfffeddd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0000ULL, 0x00014be000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff117224ULL, 0x000fc400078e000fULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0011ULL, 0xfffee1e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0000ULL, 0x00014c3000197802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0011ULL,
0xfffee1c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x008fe40004000000ULL,
0x00014c8000187802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x002fea0003c00000ULL,
0xffff088000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40005000000ULL,
0x00014cc000187802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0011ULL, 0xffff08c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014d1000197802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x002fea0003c00000ULL, 0xffff09a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0039ULL, 0x00014d5000197802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x002fea0003c00000ULL, 0xffff0ac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00014da000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff117224ULL, 0x000fc400078e0010ULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0011ULL, 0xffff0ee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000fULL, 0x00014df000197802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0011ULL,
0xffff0ec000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x008fe40004000000ULL,
0x00014e4000187802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x002fea0003c00000ULL,
0xffff353000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40005000000ULL,
0x00014e8000187802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e0011ULL, 0xffff358000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0037ULL, 0x00014ed000197802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x002fea0003c00000ULL, 0xffff367000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0037ULL, 0x00014f1000197802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x002fea0003c00000ULL, 0xffff379000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x00014f6000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff117224ULL, 0x000fc400078e0012ULL, 0x000006d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0011ULL, 0xffff3bb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e000dULL, 0x00014fb000197802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0011ULL,
0xffff3b9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x004fe40004000000ULL,
0x0001500000187802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x008fea0003c00000ULL,
0xffff613000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40005000000ULL,
0x0001504000187802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff397224ULL, 0x000fe200078e0011ULL, 0xffff618000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0005ULL, 0x0001509000197802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x000fea0003c00000ULL, 0xffff626000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0005ULL, 0x000150d000197802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x002fea0003c00000ULL, 0xffff638000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x0001512000197802ULL, 0x000fe20000000f00ULL,
0x000000ffff117224ULL, 0x000fc400078e001aULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0011ULL, 0xffff67e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x0001517000197802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0011ULL,
0xffff67c000007947ULL, 0x000fea000383ffffULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x000151c000147802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e003eULL, 0xffffeb4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x006fe200078e0019ULL, 0x0001522000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0012ULL,
0x0001528000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x000000193e117208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0013ULL,
0x000152e000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fe200078e00ffULL,
0x000000123e197208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e001bULL,
0x0001534000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x000000133e3d7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0011ULL,
0x000153a000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x0000001b3e107208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e0019ULL,
0x0001540000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x000000113e117208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000003e1900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff167224ULL, 0x002fe200078e003dULL,
0x0001546000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x000fe200078e00ffULL,
0x000000193e127208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea1000007947ULL, 0x000fea000383ffffULL, 0x018000000e007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000e00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0eff7812ULL, 0x040fe4000780c0ffULL,
0x800000000e027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000e00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffeaa1002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000003f00007348ULL, 0x000fe80003800000ULL, 0x0c000017163e7389ULL, 0x0002a200000e0018ULL,
0xfffea9d014007950ULL, 0x000fea0003c3ffffULL, 0x0000007900007348ULL, 0x000fe80003800000ULL,
0x0000001118117389ULL, 0x0002a400000e007aULL, 0x000000ffff187224ULL, 0x002fc400078e0019ULL,
0x00000000ff197424ULL, 0x000fc800078e00ffULL, 0xfffea98018007950ULL, 0x000fea0003c3ffffULL,
0x000000011100780cULL, 0x000fe20003f45070ULL, 0x00000000ff197424ULL, 0x000fe200078e00ffULL,
0x0000007800007348ULL, 0x000ff60003800000ULL, 0x0000000000117806ULL, 0x000fc800050e0100ULL,
0x0000007811117212ULL, 0x000fe200078ec0ffULL, 0xfffea92018007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005fcULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000758ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f8ULL, 0x0000000000000330ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d28ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000de8ULL, 0x00000000000007ccULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015b8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015c8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001658ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000165cULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000015780ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017000ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017050ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000173d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001658ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000159a8ULL, 0x00000000000159a8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000173d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_e4m3_nqpkv_0_m_16_sm_89_cubin_len = 95408;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
