/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000014f10ULL, 0x0000000000014a90ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000013580ULL, 0x0000000000000180ULL,
0x000e002200000106ULL, 0x0000000000013700ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000013740ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000013780ULL,
0x0000000000000100ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000013880ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001358000000000ULL, 0x0000040400000000ULL, 0x810c0000011c0400ULL,
0x004c380400288080ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8a08288080860828ULL, 0x2880809008288080ULL, 0x8098082880809408ULL, 0x16288080a5082880ULL,
0x0000031028808280ULL, 0xa592000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0001358000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x80852880808a0900ULL, 0x0900000010042880ULL, 0x2880808a288080a5ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0x9408288080900828ULL, 0x288080a508288080ULL, 0x8280162880809808ULL,
0x0000000003102880ULL, 0x8080989200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x0001370000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x9808288080900828ULL, 0x288080a508288080ULL,
0x8280162880809408ULL, 0x0000000003102880ULL, 0x8080949200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x000001a000000000ULL, 0x0001374000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x9808288080900828ULL,
0x288080a508288080ULL, 0x8280162880809408ULL, 0x0000000003102880ULL, 0x8080949200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000022800000000ULL, 0x0001378000000000ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x000812040000007dULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x0001211000011dd0ULL, 0x000121b000012130ULL, 0x000121d0000121c0ULL,
0xffffffff01702904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000029ffffffffULL, 0x0500002905000029ULL,
0xffffffff05000029ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01702804ffffffffULL, 0x0000012000000100ULL,
0x0000293000001780ULL, 0x00002a70000029b0ULL, 0x00002d9000002aa0ULL, 0x00002e0000002da0ULL,
0x000034c000002e60ULL, 0x00004670000045e0ULL, 0x0000486000004740ULL, 0x00004a6000004a50ULL,
0x00004b2000004ac0ULL, 0x0000607000004f50ULL, 0x000061d000006100ULL, 0x000064e0000062f0ULL,
0x00006550000064f0ULL, 0x000069b0000065b0ULL, 0x00007b3000007aa0ULL, 0x00007d2000007c00ULL,
0x00007f2000007f10ULL, 0x00007fe000007f80ULL, 0x0000848000008470ULL, 0x0000acd00000ac10ULL,
0x0000b4b00000b480ULL, 0x00011a4000011a10ULL, 0x00011a6000011a50ULL, 0x00011ab000011a90ULL,
0x00011ad000011ac0ULL, 0x00012200000121a0ULL, 0x0001222000012210ULL, 0x0001298000012930ULL,
0x00012a60000129f0ULL, 0x00012b3000012ac0ULL, 0x00012bd000012b80ULL, 0x00012c9000012c30ULL,
0x00012d4000012ce0ULL, 0x00012de000012d90ULL, 0x00012ea000012e40ULL, 0x00012f5000012ef0ULL,
0x00012ff000012fa0ULL, 0x000130b000013050ULL, 0x0001316000013100ULL, 0x00013210000131b0ULL,
0x000132b000013260ULL, 0x0001335000013300ULL, 0x000133f0000133a0ULL, 0x000134c000013450ULL,
0x0001356000013510ULL, 0x000001f002003904ULL, 0x00013600000000ffULL, 0x00000270003f0100ULL,
0x0001360800000003ULL, 0x00000330003f0120ULL, 0x0001368800000003ULL, 0x00000400003f0120ULL,
0x00013600000000ffULL, 0x000005d0003f0107ULL, 0x0001368c00000006ULL, 0x00000670003f0102ULL,
0x0001368800000006ULL, 0x00002770003f0101ULL, 0x0001360800000062ULL, 0x00002780003f0101ULL,
0x0001360c00000062ULL, 0x00002830003f0105ULL, 0x0001360c00000015ULL, 0x00003470003f0105ULL,
0x0001368800000063ULL, 0x00004470003f0101ULL, 0x0001362800000062ULL, 0x00004480003f0101ULL,
0x0001362c00000062ULL, 0x00004510003f0105ULL, 0x0001362c00000062ULL, 0x00004f00003f0105ULL,
0x0001369000000063ULL, 0x00005ec0003f0101ULL, 0x0001364800000062ULL, 0x00005ed0003f0101ULL,
0x0001364c00000062ULL, 0x00005fa0003f0105ULL, 0x0001364c00000062ULL, 0x00006950003f0105ULL,
0x0001369800000063ULL, 0x00007930003f0101ULL, 0x0001366800000062ULL, 0x00007940003f0101ULL,
0x0001366c00000062ULL, 0x000079d0003f0105ULL, 0x0001366c00000062ULL, 0x000082a0003f0105ULL,
0x000136a000000063ULL, 0x0000c1f0003f0101ULL, 0x00013600000000ffULL, 0x0000cfc0003f0101ULL,
0x00013604000000ffULL, 0x0000d060003f0105ULL, 0x00013604000000ffULL, 0x00011070003f0105ULL,
0x0000000000000056ULL, 0x000110b0003f0101ULL, 0x0000000400000056ULL, 0x00011310003f0105ULL,
0x0000000400000056ULL, 0x00012790003f0105ULL, 0x0001360800000008ULL, 0x000127f0003f0101ULL,
0x0001361000000008ULL, 0x00012850003f0101ULL, 0x0001361800000008ULL, 0x000128c0003f0101ULL,
0x0001362000000008ULL, 0x00033803003f0101ULL, 0x0000beb000141c04ULL, 0x0000d0c00000c100ULL,
0x000129000000d150ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000029cULL,
0x0000001200000002ULL, 0x0000000000000214ULL, 0x0000001200000002ULL, 0x000000000000018cULL,
0x0000001200000002ULL, 0x00000000000000ecULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x0000000000000274ULL, 0x0000001200000002ULL, 0x00000000000001ecULL,
0x0000001200000002ULL, 0x0000000000000164ULL, 0x0000001200000002ULL, 0x00000000000000c6ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff137624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000b7919ULL, 0x000ea20000002300ULL,
0x0000001400087300ULL, 0x000fe200000e0000ULL, 0x0000000813067824ULL, 0x000fe400078e00ffULL,
0x0000000000027919ULL, 0x000ea20000002200ULL, 0x00000100ff157424ULL, 0x000fc600078e00ffULL,
0x0000000000127919ULL, 0x000ee20000002600ULL, 0x0000001400147309ULL, 0x000f260000000000ULL,
0x0000000000097919ULL, 0x000f680000000000ULL, 0x0000000000647919ULL, 0x000f620000002700ULL,
0x00000005ff007819ULL, 0x002fe20000011603ULL, 0x000000ffff147224ULL, 0x010fca00078e0a14ULL,
0x00001fff00007589ULL, 0x000fe200000e0000ULL, 0x000000010b027824ULL, 0x004fc600078e0202ULL,
0x00001fff0b0b7589ULL, 0x000e6200000e0000ULL, 0x0000008002037824ULL, 0x000fc600078e0203ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x0000000812077824ULL, 0x008fe200078e00ffULL,
0x000000090800720cULL, 0x020fe40003f82070ULL, 0x000000ff0300720cULL, 0x040fe20003f05270ULL,
0x0000006406087224ULL, 0x000fe200078e0207ULL, 0x0000000f0300780cULL, 0x040fe40003f24070ULL,
0x0000007f0300780cULL, 0x000fd20003f44070ULL, 0x3fffff80ff048424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff058424ULL, 0x000fe400078e00ffULL, 0x000000040b067824ULL, 0x002fe400078e0200ULL,
0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL, 0x01360004ff008388ULL, 0x0003e20000000a00ULL,
0x000000030300780cULL, 0x000fe20003f04070ULL, 0x0000000206097824ULL, 0x000fe200078e00ffULL,
0x00000004ff0c7819ULL, 0x004fe20000011602ULL, 0x3fffffc0ff069424ULL, 0x000fc400078e00ffULL,
0xff317217ff0ea424ULL, 0x000fe200078e00ffULL, 0x00000008090a7817ULL, 0x040fe20007800000ULL,
0x00000001090d7824ULL, 0x000fe200078e020cULL, 0x0136080603009388ULL, 0x0005e20000008a00ULL,
0x0000001002107824ULL, 0x000fe400078e00ffULL, 0x0000000108047824ULL, 0x002fe200078e020dULL,
0x0134000e0300a388ULL, 0x0003e20000004800ULL, 0x000000010a0a7824ULL, 0x000fe200078e0a09ULL,
0x000000070d0f7812ULL, 0x000fe200078ec0ffULL, 0x3fffff60ff088424ULL, 0x000fe200078e00ffULL,
0x000000f010117812ULL, 0x000fe200078ec0ffULL, 0x7fffff60ff098424ULL, 0x000fe200078e00ffULL,
0x0000000a0c00720cULL, 0x000fe20003f26070ULL, 0x00005c0004047625ULL, 0x000fe200078e0015ULL,
0x0000000f0f0a7812ULL, 0x000fc400078e7802ULL, 0x0136880803008388ULL, 0x0003e20000008a00ULL,
0x00000004ff0f7424ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001104047210ULL, 0x000fe20007f7e0ffULL, 0x000000100d0a7824ULL, 0x000fe400078e020aULL,
0x0000620064067625ULL, 0x004fc800078e000fULL, 0x000000ffff057224ULL, 0x000fe400018e0605ULL,
0x000000100a0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0a7224ULL, 0x000fc600078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000c901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0136040affff438cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000606037981ULL, 0x002ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x00000004ff547e24ULL, 0x002fe2000f8e00ffULL,
0x0000003f03047810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03057810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff047819ULL, 0x000fe40000011604ULL, 0x00000008ff057819ULL, 0x000fca0000011605ULL,
0x0000bc0000008947ULL, 0x000fea0003800000ULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0xffffffffff0b7424ULL, 0x000fc600078e00ffULL, 0x03ffffff070d7812ULL, 0x000fca00078ec0ffULL,
0x00000004540d7824ULL, 0x000fca00078e020dULL, 0x000000040d00720cULL, 0x000fda0003f06070ULL,
0x0000000264068824ULL, 0x000fe400078e00ffULL, 0x00006400ff098624ULL, 0x000fc800078e00ffULL,
0x0000640006088624ULL, 0x000fe400078e0209ULL, 0x0000000800067824ULL, 0x000fe400078e00ffULL,
0x00000003ff097424ULL, 0x000fe400078e00ffULL, 0x000000010d088824ULL, 0x000fe200078e0208ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01368c0906ff738cULL, 0x0003e20000000000ULL,
0x0000600008108625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006100b8981ULL, 0x000ea2000c1e1900ULL, 0x00000001540a7810ULL, 0x000fc40007ffe0ffULL,
0x00000001ff097819ULL, 0x002fe20000011600ULL, 0x0136880006ff7f8cULL, 0x0003e2000c80043fULL,
0x000000050a00720cULL, 0x000fe20003f06070ULL, 0x00000040120a7824ULL, 0x000fe200078e00ffULL,
0x00000001000c7812ULL, 0x000fe200078ec0ffULL, 0x0000002009087824ULL, 0x000fc800078e00ffULL,
0x0000010054147824ULL, 0x000fca00078e0208ULL, 0x000000200a1b7812ULL, 0x000fe200078ef814ULL,
0x000058000b0b7a24ULL, 0x004fc800078e02ffULL, 0x000000400b217824ULL, 0x000fe200078e00ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x00000003ff0e7819ULL, 0x002fe40000011602ULL,
0x00000014030b7217ULL, 0x000fe40007800000ULL, 0x000000040e117810ULL, 0x040fe40007ffe0ffULL,
0x000000080e127810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0a14ULL,
0x0000000211107212ULL, 0x0c0fe200078e3cffULL, 0x0000000811257824ULL, 0x000fe200078e00ffULL,
0x0000000212137212ULL, 0x040fe200078e3cffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0x000000200b0b7817ULL, 0x000fc40003800000ULL, 0xfffffff825257812ULL, 0x000fe200078ee210ULL,
0x000000011b107824ULL, 0x000fe200078e020eULL, 0xfffffff814277812ULL, 0x000fe400078ee213ULL,
0x0000000c0e1f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001021137210ULL, 0x000fe40007f5e0ffULL,
0x0000000b1100720cULL, 0x080fe20003f06070ULL, 0x000000011b117824ULL, 0x000fe200078e0211ULL,
0x0000000b1200720cULL, 0x000fe20003f26070ULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005e0013147a11ULL, 0x000fe200078440ffULL, 0x000000011b127824ULL, 0x000fe200078e0212ULL,
0x0000001121177210ULL, 0x000fe20007f7e0ffULL, 0x000000011b107824ULL, 0x000fe200078e021fULL,
0x00005f0013157a11ULL, 0x000fe200010f4416ULL, 0x000000081f297824ULL, 0x000fe200078e00ffULL,
0x0000001221137210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x0000001021117210ULL, 0x000fc40007fbe0ffULL, 0x000000100e227810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff1a7224ULL, 0x000fe200020e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078840ffULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x00005e0017167a11ULL, 0x000fe400078440ffULL,
0x000000140e247810ULL, 0x000fe40007ffe0ffULL, 0x00005f0011117a11ULL, 0x000fe200020f4418ULL,
0x000000011b187824ULL, 0x000fe200078e0222ULL, 0x00005f0017177a11ULL, 0x000fe200010f441cULL,
0x000000011b197824ULL, 0x000fe200078e0224ULL, 0x00005e0013127a11ULL, 0x000fc400078640ffULL,
0x000000180e267810ULL, 0x040fe40007ffe0ffULL, 0x00000018211c7210ULL, 0x000fe40007f5e0ffULL,
0x0000001c0e287810ULL, 0x000fe20007ffe0ffULL, 0x00000008262d7824ULL, 0x000fe200078e00ffULL,
0x00005f0013137a11ULL, 0x000fe200018f441aULL, 0x000000011b1a7824ULL, 0x000fe200078e0226ULL,
0x00005e001c187a11ULL, 0x000fe200078840ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e06ffULL,
0x00000019211e7210ULL, 0x000fe20007fbe0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0228ULL,
0x0000001a212c7210ULL, 0x000fc40007f7e0ffULL, 0x00005f001c197a11ULL, 0x000fe200020f441dULL,
0x00000002091c7824ULL, 0x000fe200078e020cULL, 0x0000001b212a7210ULL, 0x000fe20007f5e0ffULL,
0x000000080c217824ULL, 0x000fe200078e00ffULL, 0x000000070e1d7812ULL, 0x040fe200078e4802ULL,
0x000000ffff1b7224ULL, 0x000fe200028e06ffULL, 0x0000000b0e00720cULL, 0x000fe20003f86070ULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x00005e001e1a7a11ULL, 0x000fe400078a40ffULL,
0x0000b0001c0e7811ULL, 0x000fc400078e68ffULL, 0x0ffffff81d1d7812ULL, 0x100fe400078ef802ULL,
0xfffffff821217812ULL, 0x000fe200078ee202ULL, 0x0000001025257824ULL, 0x100fe200078e020eULL,
0x00005f001e1b7a11ULL, 0x000fe200028f441bULL, 0x000000101d237824ULL, 0x000fe200078e020eULL,
0x00005e002a1e7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x000000021f207212ULL, 0x000fe200078e3cffULL, 0x0000001021147825ULL, 0x000fe200078e0014ULL,
0x00005e002c1c7a11ULL, 0x000fc400078640ffULL, 0x0000000b1f00720cULL, 0x080fe20003f46070ULL,
0x0000001027277824ULL, 0x000fe200078e020eULL, 0x00005f002a1f7a11ULL, 0x000fe200028f442bULL,
0x00000008242b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014237faeULL, 0x0003e2000e101c46ULL,
0x00005f002c1d7a11ULL, 0x000fe200018f441dULL, 0x00000008222a7824ULL, 0x000fe200078e00ffULL,
0x0000000224207212ULL, 0x000fe200078e3cffULL, 0x0000001021127825ULL, 0x000fe200078e0012ULL,
0x0000000b2200720cULL, 0x000fc40003f66070ULL, 0x0000000b2400720cULL, 0x080fe20003f86070ULL,
0x0000001029297824ULL, 0x000fe200078e020eULL, 0x0000000b2600720cULL, 0x080fe20003fa6070ULL,
0x0000001021107825ULL, 0x000fe200078e0010ULL, 0x0000000b2800720cULL, 0x000fe40003fc6070ULL,
0x00000002220b7212ULL, 0x080fe200078e3cffULL, 0x0000000828237824ULL, 0x002fe200078e00ffULL,
0x0000000226227212ULL, 0x080fe400078e3cffULL, 0x0000000228147212ULL, 0x000fc400078e3cffULL,
0xfffffff82b157812ULL, 0x000fe400078ee220ULL, 0xfffffff82d2b7812ULL, 0x000fe400078ee222ULL,
0xfffffff82a0b7812ULL, 0x000fe400078ee20bULL, 0xfffffff8232d7812ULL, 0x000fe200078ee214ULL,
0x0000001015237824ULL, 0x000fe400078e020eULL, 0x0000001021147825ULL, 0x000fc800078e0016ULL,
0x000000100b0b7824ULL, 0x000fe200078e020eULL, 0x0000000014257faeULL, 0x0003e2000c101c46ULL,
0x0000001021167825ULL, 0x000fc600078e0018ULL, 0x0000000012277faeULL, 0x0003e2000c901c46ULL,
0x0000001021187825ULL, 0x000fc600078e001aULL, 0x0000000010297faeULL, 0x0003e2000d101c46ULL,
0x000000102b2b7824ULL, 0x000fe400078e020eULL, 0x00000010211a7825ULL, 0x000fe200078e001cULL,
0x00000000160b7faeULL, 0x0003e6000d901c46ULL, 0x000000102d2d7824ULL, 0x000fe200078e020eULL,
0x0000000018237faeULL, 0x0003e2000e101c46ULL, 0x00000010211c7825ULL, 0x000fc600078e001eULL,
0x000000001a2b7faeULL, 0x0003e8000e901c46ULL, 0x000000001c2d7faeULL, 0x0003e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0b7819ULL, 0x002fe20000011602ULL,
0x000000080c337824ULL, 0x000fc600078e00ffULL, 0x000000040b127810ULL, 0x040fe40007ffe0ffULL,
0x000000080b137810ULL, 0x000fe40007ffe0ffULL, 0x00000002120e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000812157824ULL, 0x000fe200078e00ffULL, 0x0000000213107212ULL, 0x040fe200078e3cffULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0x0000000c0b147810ULL, 0x000fe20007ffe0ffULL,
0x000000011b127824ULL, 0x000fe200078e0212ULL, 0xfffffff815157812ULL, 0x000fe200078ee20eULL,
0x000000011b0e7824ULL, 0x000fe200078e020bULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x00000008141d7824ULL, 0x000fe200078e00ffULL, 0x000000140b1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000e210e7210ULL, 0x000fe40007f1e0ffULL, 0x000000100b177810ULL, 0x000fe20007ffe0ffULL,
0x000000081a2b7824ULL, 0x000fe200078e00ffULL, 0x0000000214167212ULL, 0x080fe200078e3cffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e000e107a11ULL, 0x000fe200078040ffULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000021a1c7212ULL, 0x080fe200078e3cffULL,
0x000000011b147824ULL, 0x040fe200078e0214ULL, 0x00005f000e117a11ULL, 0x000fe200000f4411ULL,
0x000000011b0e7824ULL, 0x000fe200078e0213ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x000000011b167824ULL, 0x000fe200078e0217ULL, 0x0000000217187212ULL, 0x000fc400078e3cffULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee21cULL, 0x000000180b1c7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c0b247810ULL, 0x000fe40007ffe0ffULL, 0x0000000e21177210ULL, 0x000fe20007fbe0ffULL,
0x00000002090e7824ULL, 0x000fe200078e020cULL, 0x0000001221137210ULL, 0x000fe20007fde0ffULL,
0x000000011b1e7824ULL, 0x000fe200078e021cULL, 0x000000070b0b7812ULL, 0x000fe200078e4802ULL,
0x000000011b267824ULL, 0x000fe200078e0224ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL,
0x000000011b187824ULL, 0x000fe200078e021aULL, 0x000000021c237212ULL, 0x040fe200078e3cffULL,
0x000000081c1c7824ULL, 0x000fe200078e00ffULL, 0x00000014211a7210ULL, 0x040fe20007f9e0ffULL,
0x00000008242f7824ULL, 0x000fe200078e00ffULL, 0x00000016211b7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x0000b0000e0e7811ULL, 0x000fc400078e68ffULL,
0x0ffffff80b0b7812ULL, 0x000fe400078ef802ULL, 0x0000000224167212ULL, 0x000fe200078e3cffULL,
0x0000001019257824ULL, 0x100fe200078e020eULL, 0x00005e0013127a11ULL, 0x000fe200078c40ffULL,
0x000000101d277824ULL, 0x100fe200078e020eULL, 0x0000001821207210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x0000001e21227210ULL, 0x000fe20007f3e0ffULL,
0x000000101f297824ULL, 0x100fe200078e020eULL, 0x0000002621267210ULL, 0x000fe20007f5e0ffULL,
0x000000100b217824ULL, 0x000fe200078e020eULL, 0xfffffff81c2d7812ULL, 0x000fe200078ee223ULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee216ULL,
0x0000001015237824ULL, 0x000fe200078e020eULL, 0x00005f0013137a11ULL, 0x000fe200030f4414ULL,
0x000000102b2b7824ULL, 0x100fe200078e020eULL, 0x00005e0017147a11ULL, 0x000fe200078a40ffULL,
0x000000102d2d7824ULL, 0x100fe200078e020eULL, 0x00005e001a167a11ULL, 0x040fe200078840ffULL,
0x000000102f317824ULL, 0x000fe200078e020eULL, 0x00005f0017157a11ULL, 0x000fe200028f4418ULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x00005f001a177a11ULL, 0x000fe200020f440bULL,
0x000000ffff1d7224ULL, 0x000fe200000e06ffULL, 0xfffffff8330b7812ULL, 0x000fe200078ee202ULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x00005e001b187a11ULL, 0x000fe200078640ffULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0x00005e00201a7a11ULL, 0x000fe200078040ffULL,
0x000000100b107825ULL, 0x000fe200078e0010ULL, 0x00005e00221c7a11ULL, 0x000fc400078240ffULL,
0x00005e00261e7a11ULL, 0x000fe200078440ffULL, 0x000000100b127825ULL, 0x000fe200078e0012ULL,
0x00005f001b197a11ULL, 0x000fe200018f440eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x00005f00201b7a11ULL, 0x000fe200000f441dULL,
0x000000100b147825ULL, 0x040fe200078e0014ULL, 0x00005f00221d7a11ULL, 0x000fe200008f441fULL,
0x0000000012237faeULL, 0x0003e2000b901c46ULL, 0x00005f00261f7a11ULL, 0x000fe200010f442fULL,
0x000000100b167825ULL, 0x040fe400078e0016ULL, 0x0000000014257faeULL, 0x0003e4000b901c46ULL,
0x000000100b187825ULL, 0x000fc400078e0018ULL, 0x0000000016277faeULL, 0x0003e4000b901c46ULL,
0x000000100b1a7825ULL, 0x040fe400078e001aULL, 0x0000000018297faeULL, 0x0003e4000b901c46ULL,
0x000000100b1c7825ULL, 0x040fe400078e001cULL, 0x000000001a2b7faeULL, 0x0003e4000b901c46ULL,
0x000000100b1e7825ULL, 0x000fc400078e001eULL, 0x000000001c2d7faeULL, 0x0003e8000b901c46ULL,
0x000000001e317faeULL, 0x0003e4000b901c46ULL, 0x00000003ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000030d107812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000003000f0b7a24ULL, 0x000fe200078e0a0eULL, 0x000000031000780cULL, 0x000fc80003f05270ULL,
0x000000010b0e7807ULL, 0x000fca0004000000ULL, 0x000000010d0d7824ULL, 0x000fca00078e020eULL,
0x000000040d00720cULL, 0x000fda0003f06070ULL, 0x00000002640e8824ULL, 0x000fe400078e00ffULL,
0x00006400ff118624ULL, 0x000fc800078e00ffULL, 0x000064000e0e8624ULL, 0x000fc800078e0211ULL,
0x000000010e128824ULL, 0x000fe400078e020dULL, 0xffffffffff0e7424ULL, 0x000fe400078e00ffULL,
0x0000600012128625ULL, 0x000fca00078e000fULL, 0x00000006120e8981ULL, 0x000362000c1e1900ULL,
0x000000055400720cULL, 0x000fe20003f06070ULL, 0xff317217ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00006c4000000947ULL, 0x000fea0003800000ULL,
0x0000000264127824ULL, 0x002fe400078e00ffULL, 0x00006400ff117624ULL, 0x000fc400078e00ffULL,
0xff317217ff0f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff787224ULL, 0x000fe400078e00ffULL,
0x0000640012127624ULL, 0x000fe400078e0211ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x0000010054147824ULL, 0x000fca00078e00ffULL, 0x000000031400720cULL, 0x000fda0003f06070ULL,
0x00006b7000000947ULL, 0x000fea0003800000ULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000154147810ULL, 0x000fe20007ffe0ffULL, 0x000058000e0e7a24ULL, 0x020fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000051400720cULL, 0x000fe20003f06070ULL,
0x000000400e2d7824ULL, 0x000fe200078e00ffULL, 0xffffffe011117812ULL, 0x000fca00078ec0ffULL,
0x0000010054117824ULL, 0x000fca00078e0211ULL, 0x0000004011177810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fc600078e0078ULL, 0x000000200a257812ULL, 0x000fe200078ef817ULL,
0x0000077000008947ULL, 0x000fea0003800000ULL, 0x00000003ff237819ULL, 0x000fe20000011602ULL,
0x0000200000157824ULL, 0x000fe200078e00ffULL, 0x00000017030e7217ULL, 0x000fe20007800000ULL,
0x000000080c297824ULL, 0x000fe200078e00ffULL, 0x00000004231d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000702147812ULL, 0x000fe200078ec0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a17ULL,
0x0000200015167812ULL, 0x000fe200078ec0ffULL, 0x000000081d1c7824ULL, 0x000fe200078e00ffULL,
0x0000000829297812ULL, 0x000fe200078ee214ULL, 0x0000100078177824ULL, 0x000fe200078e00ffULL,
0x000000021d157212ULL, 0x000fe200078e3cffULL, 0x0000000123147824ULL, 0x040fe200078e0225ULL,
0x00000008231f7810ULL, 0x000fe20007ffe0ffULL, 0x0000400009167824ULL, 0x000fe200078e0216ULL,
0xfffffff81c317812ULL, 0x000fc400078ee215ULL, 0x0000100017177812ULL, 0x000fe200078e0cffULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x000000142d157210ULL, 0x000fe20007f1e0ffULL,
0x000000011d147824ULL, 0x000fe200078e0225ULL, 0x0000b00016287810ULL, 0x000fe40007ffe017ULL,
0x000000021f177212ULL, 0x000fe200078e3cffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005e0015167a11ULL, 0x000fe400078040ffULL, 0xfffffff81e337812ULL, 0x000fc400078ee217ULL,
0x00005f0015177a11ULL, 0x000fe200000f441cULL, 0x000000011f157824ULL, 0x000fe200078e0225ULL,
0x000000200e0e7817ULL, 0x000fe40003800000ULL, 0x000000142d1e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001029167825ULL, 0x000fe200078e0016ULL, 0x0000000c23517810ULL, 0x040fe40007ffe0ffULL,
0x0000001023537810ULL, 0x000fe40007ffe0ffULL, 0x0000000e1f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200000e06ffULL, 0x0000000e1d00720cULL, 0x000fe20003f46070ULL,
0x00000001511c7824ULL, 0x100fe200078e0225ULL, 0x00005e001e147a11ULL, 0x040fe200078040ffULL,
0x00000001531d7824ULL, 0x000fe200078e0225ULL, 0x000000152d217210ULL, 0x000fe20007f7e0ffULL,
0x00000008512e7824ULL, 0x000fe200078e00ffULL, 0x00005f001e157a11ULL, 0x000fc400000f441fULL,
0x0000001c2d1f7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x0000001d2d1d7210ULL, 0x000fe20007fbe0ffULL, 0x0000001029147825ULL, 0x000fe200078e0014ULL,
0x0000001423557810ULL, 0x000fe40007ffe0ffULL, 0x00005e0021207a11ULL, 0x000fe200078040ffULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff227224ULL, 0x000fe200028e06ffULL, 0x00005e001f1e7a11ULL, 0x000fc400078640ffULL,
0x0000001823577810ULL, 0x000fe40007ffe0ffULL, 0x00005f001d1d7a11ULL, 0x000fe200020f4422ULL,
0x0000000155227824ULL, 0x000fe200078e0225ULL, 0x0000001c23597810ULL, 0x000fe40007ffe0ffULL,
0x00005f0021217a11ULL, 0x000fe200000f4426ULL, 0x00000010291c7825ULL, 0x000fe200078e001cULL,
0x00005f001f1f7a11ULL, 0x000fe400018f4424ULL, 0x0000000e2300720cULL, 0x000fe20003f66070ULL,
0x0000000159247824ULL, 0x000fe200078e0225ULL, 0x000000222d267210ULL, 0x000fe20007f1e0ffULL,
0x0000001029207825ULL, 0x000fe200078e0020ULL, 0x00000007232f7812ULL, 0x000fc400078e4802ULL,
0x0000000e5900720cULL, 0x000fe20003fc6070ULL, 0x0000000157237824ULL, 0x000fe200078e0225ULL,
0x000000242d257210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e06ffULL,
0x00005e0026227a11ULL, 0x040fe200078040ffULL, 0x00000010291e7825ULL, 0x000fe200078e001eULL,
0x000000232d277210ULL, 0x000fe40007f9e0ffULL, 0x0ffffff82f2f7812ULL, 0x000fe200078ef802ULL,
0x000000ffff2a7224ULL, 0x000fe200028e06ffULL, 0x00005f0026237a11ULL, 0x000fe200000f442bULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078840ffULL,
0x000000102f2b7824ULL, 0x000fe200078e0228ULL, 0x00005e0025247a11ULL, 0x000fe200078a40ffULL,
0x00000008532f7824ULL, 0x000fe200078e00ffULL, 0x00005f0027277a11ULL, 0x000fe200020f442cULL,
0x0000001029227825ULL, 0x000fe200078e0022ULL, 0x00005f0025257a11ULL, 0x000fe200028f442aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000162b7faeULL, 0x0003e2000d901c46ULL,
0x00000002512d7212ULL, 0x000fe200078e3cffULL, 0x0000001029267825ULL, 0x000fe200078e0026ULL,
0x0000000e5100720cULL, 0x000fc40003f06070ULL, 0x0000000e5300720cULL, 0x080fe20003f66070ULL,
0x0000000855517824ULL, 0x040fe200078e00ffULL, 0x0000000e5500720cULL, 0x080fe20003f86070ULL,
0x0000001029247825ULL, 0x000fe200078e0024ULL, 0x0000000e5700720cULL, 0x000fe40003fa6070ULL,
0x00000002530e7212ULL, 0x080fe200078e3cffULL, 0x0000000857537824ULL, 0x000fe200078e00ffULL,
0x00000002552a7212ULL, 0x080fe200078e3cffULL, 0x0000000859557824ULL, 0x000fe200078e00ffULL,
0x00000002572c7212ULL, 0x080fe200078e3cffULL, 0x0000001031177824ULL, 0x102fe200078e0228ULL,
0xfffffff82e2d7812ULL, 0x000fe200078ee22dULL, 0x00000010332b7824ULL, 0x000fe200078e0228ULL,
0x0000000259167212ULL, 0x000fc400078e3cffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL,
0x000000102d2d7824ULL, 0x000fe200078e0228ULL, 0xfffffff851517812ULL, 0x000fe200078ee22aULL,
0x0000000014177faeULL, 0x0003e2000d101c46ULL, 0xfffffff853537812ULL, 0x000fe200078ee22cULL,
0x000000102f2f7824ULL, 0x000fe200078e0228ULL, 0xfffffff855557812ULL, 0x000fe200078ee216ULL,
0x0000001051317824ULL, 0x100fe200078e0228ULL, 0x00000000202b7faeULL, 0x0003e2000c901c46ULL,
0x0000001053337824ULL, 0x100fe400078e0228ULL, 0x0000001055517824ULL, 0x000fe200078e0228ULL,
0x000000001e2d7faeULL, 0x0003e8000c101c46ULL, 0x000000001c2f7faeULL, 0x0003e8000d901c46ULL,
0x0000000022317faeULL, 0x0003e8000e101c46ULL, 0x0000000026337faeULL, 0x0003e8000e901c46ULL,
0x0000000024517faeULL, 0x0003e2000f101c46ULL, 0x000006b000007947ULL, 0x000fea0003800000ULL,
0x0000200000157824ULL, 0x000fe200078e00ffULL, 0x00000003ff0e7819ULL, 0x000fe20000011602ULL,
0x0000100078177824ULL, 0x000fe200078e00ffULL, 0x0000000702147812ULL, 0x000fe200078ec0ffULL,
0x000000080c297824ULL, 0x000fe200078e00ffULL, 0x0000200015167812ULL, 0x000fc400078ec0ffULL,
0x000000040e1c7810ULL, 0x040fe40007ffe0ffULL, 0x0000100017177812ULL, 0x000fe200078e0cffULL,
0x0000400009167824ULL, 0x000fe200078e0216ULL, 0x000000080e1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000081c1e7824ULL, 0x000fe200078e00ffULL, 0x0000000829297812ULL, 0x000fe200078ee214ULL,
0x000000010e147824ULL, 0x000fe200078e0225ULL, 0x0000b000161d7810ULL, 0x000fe20007ffe017ULL,
0x000000081f217824ULL, 0x000fe200078e00ffULL, 0x0000000c0e177810ULL, 0x000fc40007ffe0ffULL,
0x000000021c157212ULL, 0x0c0fe200078e3cffULL, 0x000000011c1c7824ULL, 0x000fe200078e0225ULL,
0x000000021f207212ULL, 0x000fe200078e3cffULL, 0x00000008172b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee215ULL, 0xfffffff821227812ULL, 0x000fe400078ee220ULL,
0x000000100e217810ULL, 0x000fe40007ffe0ffULL, 0x000000142d157210ULL, 0x000fc40007f1e0ffULL,
0x0000000217207212ULL, 0x080fe200078e3cffULL, 0x00000008212a7824ULL, 0x000fe200078e00ffULL,
0x000000140e277810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0xfffffff82b267812ULL, 0x000fe200078ee220ULL, 0x0000000121287824ULL, 0x100fe200078e0225ULL,
0x0000001c0e2b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008272f7824ULL, 0x000fe200078e00ffULL,
0x0000000221237212ULL, 0x080fe200078e3cffULL, 0x00000001272c7824ULL, 0x100fe200078e0225ULL,
0x00005e0015147a11ULL, 0x000fe200078040ffULL, 0x000000012b327824ULL, 0x000fe200078e0225ULL,
0x0000000227247212ULL, 0x000fe200078e3cffULL, 0x000000082b507824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee223ULL, 0x0000001026317824ULL, 0x000fe200078e021dULL,
0x00005f0015157a11ULL, 0x000fe200000f4416ULL, 0x000000011f167824ULL, 0x000fe200078e0225ULL,
0x000000180e237810ULL, 0x000fe20007ffe0ffULL, 0x000000102a337824ULL, 0x000fe200078e021dULL,
0x0000001c2d1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001029147825ULL, 0x000fe200078e0014ULL,
0xfffffff82f2e7812ULL, 0x000fc400078ee224ULL, 0x000000322d277210ULL, 0x000fe20007f5e0ffULL,
0x0000000117247824ULL, 0x100fe200078e0225ULL, 0x000000162d207210ULL, 0x000fe20007fbe0ffULL,
0x0000000123307824ULL, 0x040fe200078e0225ULL, 0x000000070e177812ULL, 0x000fe200078e4802ULL,
0x0000000823327824ULL, 0x040fe200078e00ffULL, 0x0000000223217212ULL, 0x080fe200078e3cffULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x000000022b237212ULL, 0x000fe200078e3cffULL,
0x00000010222f7824ULL, 0x100fe200078e021dULL, 0x00005e001c167a11ULL, 0x000fe200078c40ffULL,
0x000000102e517824ULL, 0x000fe200078e021dULL, 0x000000242d247210ULL, 0x000fc40007f9e0ffULL,
0x0ffffff8170e7812ULL, 0x000fe400078ef802ULL, 0xfffffff832327812ULL, 0x000fe200078ee221ULL,
0x000000ffff217224ULL, 0x000fe200020e06ffULL, 0xfffffff850507812ULL, 0x000fe200078ee223ULL,
0x000000100e2b7824ULL, 0x000fe200078e021dULL, 0x00005f001c177a11ULL, 0x000fe200030f441fULL,
0x000000ffff1f7224ULL, 0x000fe200028e06ffULL, 0x000000282d287210ULL, 0x040fe20007f7e0ffULL,
0x0000001032537824ULL, 0x100fe200078e021dULL, 0x0000002c2d2c7210ULL, 0x040fe20007f1e0ffULL,
0x0000001050557824ULL, 0x100fe200078e021dULL, 0x000000302d307210ULL, 0x000fe20007f3e0ffULL,
0x000000101e2d7824ULL, 0x000fe200078e021dULL, 0x00005e00201c7a11ULL, 0x000fe200078a40ffULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0x00005e00241e7a11ULL, 0x000fe200078840ffULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x00005f00201d7a11ULL, 0x000fe200028f441fULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x00005f00241f7a11ULL, 0x000fe200020f4421ULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x00005e0028207a11ULL, 0x000fe200078640ffULL,
0x0000001029167825ULL, 0x040fe200078e0016ULL, 0x00005e002c227a11ULL, 0x000fe200078040ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000142b7faeULL, 0x0003e2000b901c46ULL,
0x00005e0030247a11ULL, 0x000fe200078240ffULL, 0x00000010291c7825ULL, 0x000fe200078e001cULL,
0x00005e0027267a11ULL, 0x000fe200078440ffULL, 0x00000000162d7faeULL, 0x0003e2000b901c46ULL,
0x00005f0028217a11ULL, 0x000fe200018f4421ULL, 0x00000010291e7825ULL, 0x040fe200078e001eULL,
0x00005f002c237a11ULL, 0x000fe200000f4423ULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x00005f0030257a11ULL, 0x000fe200008f4425ULL, 0x0000001029207825ULL, 0x000fe200078e0020ULL,
0x00005f0027277a11ULL, 0x000fe200010f440eULL, 0x000000001e317faeULL, 0x0003e4000b901c46ULL,
0x0000001029227825ULL, 0x000fc400078e0022ULL, 0x0000000020337faeULL, 0x0003e4000b901c46ULL,
0x0000001029247825ULL, 0x040fe400078e0024ULL, 0x0000000022517faeULL, 0x0003e4000b901c46ULL,
0x0000001029267825ULL, 0x000fe400078e0026ULL, 0x0000000024537faeULL, 0x0003e8000b901c46ULL,
0x0000000026557faeULL, 0x0003e4000b901c46ULL, 0x000000030d0e7812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030e00780cULL, 0x000fc80003f05270ULL,
0x000000010b0e7807ULL, 0x000fca0004000000ULL, 0x000000010d0d7824ULL, 0x000fe400078e020eULL,
0xffffffffff0e7424ULL, 0x000fc600078e00ffULL, 0x000000040d00720cULL, 0x000fda0003f06070ULL,
0x0000000112148824ULL, 0x002fe400078e020dULL, 0x00000004ff158424ULL, 0x000fc800078e00ffULL,
0x0000600014148625ULL, 0x000fca00078e0015ULL, 0x00000006140e8981ULL, 0x000362000c1e1900ULL,
0xffffffe006627812ULL, 0x040fe400078ec0ffULL, 0x00000010061c7812ULL, 0x040fe400078ec0ffULL,
0x0000000806177812ULL, 0x000fc800078ec0ffULL, 0x0000006217627210ULL, 0x000fe20007ffe01cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080062167f8cULL, 0x002fe8000c80043fULL,
0x01360c0062157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000a000000947ULL, 0x000fea0003800000ULL, 0x0000002007157824ULL, 0x000fe400078e021cULL,
0x3e000000ff147424ULL, 0x000fc400078e00ffULL, 0x000000080c157824ULL, 0x000fe400078e0215ULL,
0x00000014001c7305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x0000001c0000735dULL, 0x004fe20003800000ULL, 0x01360c00151d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002617824ULL, 0x000fe200078e00ffULL, 0x00000001ff607819ULL, 0x000fe20000011602ULL,
0xffffffffff567424ULL, 0x000fc600078e00ffULL, 0x0000007061617812ULL, 0x000fe400078ec0ffULL,
0x0000000c60607812ULL, 0x000fc600078ec0ffULL, 0x0000008007157824ULL, 0x000fc800078e0261ULL,
0x0000000115157824ULL, 0x000fca00078e0260ULL, 0x0130000015167984ULL, 0x000e680000000800ULL,
0x0132000015177984ULL, 0x0004e20000000800ULL, 0x0000000f1600720bULL, 0x002fe20003f1d000ULL,
0x0000ffe27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff141d7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x000000000700720cULL, 0x000fe40003f05270ULL, 0x0000000f1600720bULL, 0x000fe20003f34000ULL,
0x0000ffb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x000000160f1e7209ULL, 0x040fe20007810000ULL, 0x0000008000158824ULL, 0x000fe200078e0261ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff1c7819ULL, 0x000fe20000011602ULL,
0x8000001e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000000160158824ULL, 0x000fc600078e0215ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fe40000410000ULL, 0x0134001e15008388ULL, 0x0003e20000000800ULL,
0x000000141dff7212ULL, 0x000fe2000780c0ffULL, 0x0000000f002b7308ULL, 0x0002a20000000800ULL,
0x0000ff427f007947ULL, 0x000ff2000b800000ULL, 0x00001f1c2b0f7589ULL, 0x0062a400000e0000ULL,
0x000000081c1c7810ULL, 0x002fe20007ffe0ffULL, 0x0000ff827f007947ULL, 0x000fea000b800000ULL,
0x00001f1c2b277589ULL, 0x00032400000e0000ULL, 0x8000001e16160221ULL, 0x100fe20000010000ULL,
0x0000000f19197220ULL, 0x084fe20000410000ULL, 0x0000000f18187220ULL, 0x080fe20000410000ULL,
0x0000000f35357220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe20000410000ULL,
0x0000000f34347220ULL, 0x080fe20000410000ULL, 0x0000000f39397220ULL, 0x080fe20000410000ULL,
0x0000000f38387220ULL, 0x080fe20000410000ULL, 0x0000001600130308ULL, 0x000ea20000000800ULL,
0x0000000f3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000f3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000f41417220ULL, 0x080fe20000410000ULL, 0x0000000f40407220ULL, 0x080fe20000410000ULL,
0x0000000f45457220ULL, 0x080fe20000410000ULL, 0x0000000f44447220ULL, 0x080fe20000410000ULL,
0x0000000f49497220ULL, 0x080fe20000410000ULL, 0x0000000f48487220ULL, 0x080fe20000410000ULL,
0x0000000f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000000f4c4c7220ULL, 0x000fe20000410000ULL,
0x0000002b10107220ULL, 0x000fe20000410000ULL, 0x000000271b1b7220ULL, 0x090fe20000410000ULL,
0x000000271a1a7220ULL, 0x080fe20000410000ULL, 0x0000002737377220ULL, 0x080fe20000410000ULL,
0x0000002736367220ULL, 0x080fe20000410000ULL, 0x000000273b3b7220ULL, 0x080fe20000410000ULL,
0x000000273a3a7220ULL, 0x080fe20000410000ULL, 0x000000273f3f7220ULL, 0x080fe20000410000ULL,
0x000000273e3e7220ULL, 0x080fe20000410000ULL, 0x0000002743437220ULL, 0x080fe20000410000ULL,
0x0000002742427220ULL, 0x080fe20000410000ULL, 0x0000002747477220ULL, 0x080fe20000410000ULL,
0x0000002746467220ULL, 0x080fe20000410000ULL, 0x000000274b4b7220ULL, 0x080fe20000410000ULL,
0x000000274a4a7220ULL, 0x080fe20000410000ULL, 0x000000274f4f7220ULL, 0x080fe20000410000ULL,
0x000000274e4e7220ULL, 0x000fe20000410000ULL, 0x00000001ff1c7807ULL, 0x002fe20000000000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e001eULL, 0x0000001317170220ULL, 0x00cfc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000013ff14723eULL, 0x000fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff167819ULL, 0x000fe40000011602ULL,
0x00005410142b7816ULL, 0x000fe20000000014ULL, 0x0000fd027f007947ULL, 0x000fea000b800000ULL,
0x0000000816577810ULL, 0x000fe20007ffe0ffULL, 0x00001f162b637589ULL, 0x0002a800000e0000ULL,
0x00001f572b667589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010162a7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x00002e1000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x0001093000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018162a7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x00002e7000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x000108d000007944ULL, 0x03cfea0003c00000ULL, 0x0000000200657824ULL, 0x000fe200078e00ffULL,
0x00000004ff1e7819ULL, 0x000fe20000011602ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000702557812ULL, 0x000fe200078ec0ffULL, 0x0000001017107221ULL, 0x008fe20000010000ULL,
0x0000000465157812ULL, 0x000fc400078ec0ffULL, 0x0000000855147812ULL, 0x000fc600078ef802ULL,
0x000000011e1d7824ULL, 0x000fca00078e0215ULL, 0x000000071d157812ULL, 0x000fca00078e7814ULL,
0x0000000814157824ULL, 0x000fc800078e0215ULL, 0x0000001015647824ULL, 0x000fe200078e00ffULL,
0x0000000802157812ULL, 0x000fc600078ec0ffULL, 0x00000800072c7824ULL, 0x000fc800078e0264ULL,
0x0000200000757824ULL, 0x000fe200078e00ffULL, 0x000000021d217810ULL, 0x000fe20007ffe0ffULL,
0x009000002c2c783bULL, 0x000ee20000000200ULL, 0x0000000715167812ULL, 0x002fe200078ec802ULL,
0x000020000c6e7824ULL, 0x000fe200078e00ffULL, 0xffffc00075757812ULL, 0x000fe400078ec0ffULL,
0x000000021e177810ULL, 0x040fe40007ffe0ffULL, 0x000000041e1d7810ULL, 0x000fe20007ffe0ffULL,
0x000020000c757824ULL, 0x000fe200078e0275ULL, 0x000000061e1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000001e161e7212ULL, 0x040fe400078e3cffULL, 0x00000017166a7212ULL, 0x040fe200078e3cffULL,
0x0000400009177824ULL, 0x000fe200078e026eULL, 0x0000001d16207212ULL, 0x040fe400078e3cffULL,
0x0000001f16227212ULL, 0x000fe200078e3cffULL, 0x0000100078167824ULL, 0x000fe200078e0275ULL,
0x0000000715157812ULL, 0x000fe400078ef802ULL, 0x0000000721217812ULL, 0x000fc400078e7814ULL,
0x0000b00016167810ULL, 0x000fe20007ffe0ffULL, 0x0000000815767824ULL, 0x040fe200078e021eULL,
0x000099101c1d7816ULL, 0x000fe200000000ffULL, 0x0000000815747824ULL, 0x040fe200078e026aULL,
0x0000008015677811ULL, 0x040fe200078e18ffULL, 0x0000000815737824ULL, 0x000fe200078e0220ULL,
0x000000ff1d00720cULL, 0x000fe20003f05270ULL, 0x0000000815717824ULL, 0x000fe400078e0222ULL,
0x00000010765c7824ULL, 0x100fe400078e0216ULL, 0x0000001074587824ULL, 0x000fc400078e0216ULL,
0x0000001073507824ULL, 0x100fe400078e0216ULL, 0x0000001071307824ULL, 0x000fe200078e0216ULL,
0x000000005c5c783bULL, 0x000e620000004200ULL, 0x0000000814217824ULL, 0x000fe400078e0221ULL,
0x00001000781c7824ULL, 0x000fe200078e0217ULL, 0x000000005858783bULL, 0x000f220000004200ULL,
0x00000010216c7824ULL, 0x000fe200078e00ffULL, 0x000000632c2c8231ULL, 0x08cfe200003400ffULL,
0x000000011e6b7824ULL, 0x100fe200078e0267ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000080007147824ULL, 0x000fe200078e026cULL, 0x0000b0001c1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000016a6a7824ULL, 0x100fe200078e0267ULL, 0x000000003030783bULL, 0x000fe20000004200ULL,
0x0000000120697824ULL, 0x100fe200078e0267ULL, 0x000000632e2e8231ULL, 0x000fe200003400ffULL,
0x0000000122677824ULL, 0x000fe200078e0267ULL, 0x009000001414783bULL, 0x000ea20000000200ULL,
0x000000106b287824ULL, 0x100fe200078e021cULL, 0x000000662d2d8231ULL, 0x090fe200003400ffULL,
0x000000106a247824ULL, 0x100fe200078e021cULL, 0x000000662f2f8231ULL, 0x000fe200003400ffULL,
0x0000001069207824ULL, 0x000fc400078e021cULL, 0x00000010671c7824ULL, 0x000fe200078e021cULL,
0x000000002828783bULL, 0x000ee80000004200ULL, 0x000000002424783bULL, 0x000f280000004200ULL,
0x000000002020783bULL, 0x000ee80000004200ULL, 0x000000001c1c783bULL, 0x000ee20000004200ULL,
0x0000005c2c4c723cULL, 0x042ff0000004184cULL, 0x0000005e2c48723cULL, 0x040ff00000041848ULL,
0x000000582c44723cULL, 0x000fe20000041844ULL, 0x0000006314148231ULL, 0x004fc400003400ffULL,
0x0000006316168231ULL, 0x000fe200003400ffULL, 0xfffffff865637812ULL, 0x000fe200078ec0ffULL,
0x0000006615158231ULL, 0x080fe400003400ffULL, 0x0000006617178231ULL, 0x000fe200003400ffULL,
0x0000005a2c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028144c723cULL, 0x048ff0000004184cULL,
0x0000002a1448723cULL, 0x040ff00000041848ULL, 0x000000241444723cULL, 0x050ff00000041844ULL,
0x000000261440723cULL, 0x040ff00000041840ULL, 0x00000020143c723cULL, 0x040ff0000004183cULL,
0x000000221438723cULL, 0x040ff00000041838ULL, 0x0000001c1434723cULL, 0x040ff00000041834ULL,
0x0000001e1418723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000004054147811ULL, 0x000fe200078e40ffULL, 0x0136880063ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000178787812ULL, 0x000fc400078e0cffULL, 0x000000031400720cULL, 0x000fda0003f06070ULL,
0x00004e1000000947ULL, 0x000fea0003800000ULL, 0x0000001000147824ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe014157812ULL, 0x000fe200078ec0ffULL,
0x000058000e0e7a24ULL, 0x020fe200078e02ffULL, 0x0000000154147810ULL, 0x000fc60007ffe0ffULL,
0x0000010054157824ULL, 0x000fe200078e0215ULL, 0x000000051400720cULL, 0x000fe20003f06070ULL,
0x000000400e0e7824ULL, 0x000fc600078e00ffULL, 0x0000008015167810ULL, 0x000fc80007ffe0ffULL,
0x000000200a277812ULL, 0x000fca00078ef816ULL, 0x0000076000008947ULL, 0x000fea0003800000ULL,
0x0000200000177824ULL, 0x000fe200078e00ffULL, 0x00000003ff2d7819ULL, 0x000fe20000011602ULL,
0x0000100011147824ULL, 0x000fe200078e00ffULL, 0x0000001603157217ULL, 0x000fe40007800000ULL,
0x00002000171c7812ULL, 0x000fe200078ec0ffULL, 0x000000012d177824ULL, 0x140fe200078e0227ULL,
0x000000042d1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115157824ULL, 0x000fe200078e0a16ULL,
0x0000100014147812ULL, 0x000fe200078ec0ffULL, 0x0000400009297824ULL, 0x000fe200078e021cULL,
0x000000170e177210ULL, 0x000fe20007f1e0ffULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x0000002015287817ULL, 0x000fe20003800000ULL, 0x000000011d157824ULL, 0x000fe200078e0227ULL,
0x0000b00029297810ULL, 0x000fe20007ffe014ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x000000021d167212ULL, 0x000fc400078e3cffULL, 0x000000082d1f7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0017247a11ULL, 0x000fe400078040ffULL, 0xfffffff8212c7812ULL, 0x000fe200078ee216ULL,
0x000000081f217824ULL, 0x000fe200078e00ffULL, 0x00005f0017257a11ULL, 0x000fe400000f4414ULL,
0x0000000c2d2f7810ULL, 0x000fe40007ffe0ffULL, 0x000000150e147210ULL, 0x000fe20007f1e0ffULL,
0x000000011f157824ULL, 0x140fe200078e0227ULL, 0x000000021f167212ULL, 0x000fe200078e3cffULL,
0x000000082f307824ULL, 0x000fe200078e00ffULL, 0x000000102d317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x000000281d00720cULL, 0x000fe20003f46070ULL,
0x000000012f1d7824ULL, 0x000fe200078e0227ULL, 0xfffffff8212e7812ULL, 0x000fc400078ee216ULL,
0x000000281f00720cULL, 0x000fe20003f26070ULL, 0x00000001311f7824ULL, 0x000fe200078e0227ULL,
0x00005e0014167a11ULL, 0x000fe400078040ffULL, 0x000000150e217210ULL, 0x000fe40007f7e0ffULL,
0x00005f0014177a11ULL, 0x000fe400000f4417ULL, 0x0000001d0e1d7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x0000001f0e147210ULL, 0x000fc40007fbe0ffULL,
0x00005e001d1e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x00005e00141c7a11ULL, 0x040fe200078840ffULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x000000142d337810ULL, 0x000fe40007ffe0ffULL, 0x00005f001d1f7a11ULL, 0x000fe400018f4420ULL,
0x00005f00141d7a11ULL, 0x000fe200020f4415ULL, 0x0000000133157824ULL, 0x000fe200078e0227ULL,
0x00005e0021227a11ULL, 0x000fc400078040ffULL, 0x000000182d537810ULL, 0x040fe40007ffe0ffULL,
0x0000001c2d597810ULL, 0x000fe40007ffe0ffULL, 0x00005f0021237a11ULL, 0x000fe200000f4426ULL,
0x000000080c267824ULL, 0x000fe200078e00ffULL, 0x000000150e207210ULL, 0x040fe20007f1e0ffULL,
0x0000000153157824ULL, 0x100fe200078e0227ULL, 0x000000282d00720cULL, 0x000fe20003f66070ULL,
0x0000000159217824ULL, 0x000fe200078e0227ULL, 0x000000072d2d7812ULL, 0x000fe200078e4802ULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x000000150e277210ULL, 0x000fc40007f9e0ffULL,
0x000000210e217210ULL, 0x000fe40007fbe0ffULL, 0x00005e0020147a11ULL, 0x000fe200078040ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x0ffffff82d0e7812ULL, 0x000fe400078ef802ULL,
0x0000000826517812ULL, 0x000fe400078ee255ULL, 0x00005f0020157a11ULL, 0x000fe200000f442bULL,
0x000000100e2b7824ULL, 0x000fe200078e0229ULL, 0x00005e0027267a11ULL, 0x000fe200078840ffULL,
0x000000ffff0e7224ULL, 0x000fe200028e06ffULL, 0x00005e0021207a11ULL, 0x000fe200078a40ffULL,
0x0000001051247825ULL, 0x000fe200078e0024ULL, 0x00005f0027277a11ULL, 0x000fc400020f442aULL,
0x00005f0021217a11ULL, 0x000fe200028f440eULL, 0x0000001051167825ULL, 0x000fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e2000d901c46ULL,
0x000000282f00720cULL, 0x080fe40003f06070ULL, 0x000000283100720cULL, 0x080fe20003f66070ULL,
0x0000001051227825ULL, 0x000fe200078e0022ULL, 0x000000283300720cULL, 0x080fe40003f86070ULL,
0x000000285300720cULL, 0x080fe20003fa6070ULL, 0x00000010511e7825ULL, 0x000fe200078e001eULL,
0x000000285900720cULL, 0x000fc40003fc6070ULL, 0x00000002310e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x000000022f2d7212ULL, 0x080fe200078e3cffULL,
0x000000102c257824ULL, 0x002fe200078e0229ULL, 0x0000000233287212ULL, 0x0c0fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x00000002532a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x0000000259247212ULL, 0x040fe200078e3cffULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee22dULL,
0x000000102e2b7824ULL, 0x000fe200078e0229ULL, 0xfffffff8310e7812ULL, 0x000fe200078ee20eULL,
0x00000010511c7825ULL, 0x000fe200078e001cULL, 0xfffffff833287812ULL, 0x000fe200078ee228ULL,
0x0000000016257faeULL, 0x0003e2000d101c46ULL, 0xfffffff8532a7812ULL, 0x000fe200078ee22aULL,
0x00000010302d7824ULL, 0x100fe200078e0229ULL, 0xfffffff859247812ULL, 0x000fe200078ee224ULL,
0x000000100e2f7824ULL, 0x100fe200078e0229ULL, 0x00000000222b7faeULL, 0x0003e2000c901c46ULL,
0x0000001028317824ULL, 0x000fc400078e0229ULL, 0x0000001051147825ULL, 0x040fe200078e0014ULL,
0x000000001e2d7faeULL, 0x0003e6000c101c46ULL, 0x000000102a337824ULL, 0x000fe200078e0229ULL,
0x000000001c2f7faeULL, 0x0003e2000d901c46ULL, 0x0000001051267825ULL, 0x000fc600078e0026ULL,
0x0000000014317faeULL, 0x0003e2000e101c46ULL, 0x0000001024297824ULL, 0x000fe400078e0229ULL,
0x0000001051207825ULL, 0x000fe200078e0020ULL, 0x0000000026337faeULL, 0x0003e8000e901c46ULL,
0x0000000020297faeULL, 0x0003e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x0000200000147824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe20000011602ULL,
0x0000100011157824ULL, 0x000fc400078e00ffULL, 0x000000080c327824ULL, 0x000fe200078e00ffULL,
0x00000008161f7810ULL, 0x000fe40007ffe0ffULL, 0x0000200014147812ULL, 0x000fe400078ec0ffULL,
0x0000000416177810ULL, 0x040fe20007ffe0ffULL, 0x000000081f237824ULL, 0x040fe200078e00ffULL,
0x000000021f207212ULL, 0x000fe200078e3cffULL, 0x0000400009147824ULL, 0x000fe200078e0214ULL,
0x0000001416287810ULL, 0x000fe20007ffe0ffULL, 0x0000000817217824ULL, 0x000fe200078e00ffULL,
0x0000100015157812ULL, 0x000fe200078ec0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0227ULL,
0xfffffff823227812ULL, 0x000fe200078ee220ULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0x0000b000141d7810ULL, 0x000fe20007ffe015ULL, 0x0000000116157824ULL, 0x040fe200078e0227ULL,
0x0000000c16207810ULL, 0x000fc40007ffe0ffULL, 0x0000001016237810ULL, 0x000fe20007ffe0ffULL,
0x00000010222f7824ULL, 0x000fe200078e021dULL, 0x00000002171c7212ULL, 0x080fe200078e3cffULL,
0x0000000820247824ULL, 0x000fe200078e00ffULL, 0x0000000228297212ULL, 0x000fe200078e3cffULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0xfffffff8211e7812ULL, 0x000fe200078ee21cULL,
0x0000000117177824ULL, 0x000fe200078e0227ULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee229ULL,
0x000000150e157210ULL, 0x000fc40007f1e0ffULL, 0x0000000220217212ULL, 0x080fe200078e3cffULL,
0x000000102a517824ULL, 0x000fe200078e021dULL, 0x0000000223257212ULL, 0x040fe200078e3cffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x0000001816297810ULL, 0x040fe20007ffe0ffULL,
0x0000000123237824ULL, 0x000fe200078e0227ULL, 0x0000001c162d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff824247812ULL, 0x000fe200078ee221ULL, 0x0000000120217824ULL, 0x000fe200078e0227ULL,
0xfffffff826267812ULL, 0x000fe200078ee225ULL, 0x0000000128257824ULL, 0x100fe200078e0227ULL,
0x00005e0015147a11ULL, 0x000fe200078040ffULL, 0x00000001292b7824ULL, 0x100fe200078e0227ULL,
0x0000001f0e207210ULL, 0x040fe20007fbe0ffULL, 0x000000012d277824ULL, 0x000fe200078e0227ULL,
0x00005f0015157a11ULL, 0x000fe200000f441cULL, 0x000000082d307824ULL, 0x000fe200078e00ffULL,
0x000000170e1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001024317824ULL, 0x100fe200078e021dULL,
0x000000210e217210ULL, 0x000fe20007f9e0ffULL, 0x0000001026337824ULL, 0x000fe200078e021dULL,
0x000000230e237210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x000000250e257210ULL, 0x000fc40007f1e0ffULL, 0x0000002b0e2c7210ULL, 0x040fe40007f3e0ffULL,
0x000000270e2e7210ULL, 0x000fe40007f5e0ffULL, 0x00000002290e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x0000000716177812ULL, 0x000fe200078e4802ULL,
0x000000ffff597224ULL, 0x000fe200010e06ffULL, 0x000000022d277212ULL, 0x000fe200078e3cffULL,
0x000000101e2d7824ULL, 0x000fe200078e021dULL, 0xfffffff829287812ULL, 0x000fc400078ee20eULL,
0x0ffffff8170e7812ULL, 0x000fe400078ef802ULL, 0x00005e001c167a11ULL, 0x000fe200078c40ffULL,
0x0000001028537824ULL, 0x000fe200078e021dULL, 0xfffffff830307812ULL, 0x000fe200078ee227ULL,
0x000000100e2b7824ULL, 0x000fe200078e021dULL, 0x00005f001c177a11ULL, 0x000fe200030f441fULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x00005e00211c7a11ULL, 0x040fe200078840ffULL,
0x000000ffff1f7224ULL, 0x000fe200028e06ffULL, 0x00005e00201e7a11ULL, 0x000fe200078a40ffULL,
0x00000010305b7824ULL, 0x000fe200078e021dULL, 0x00005f00211d7a11ULL, 0x000fe200020f440eULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x0000000832297812ULL, 0x000fe200078ee255ULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x00005e0023267a11ULL, 0x000fe200078640ffULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078040ffULL,
0x0000001029147825ULL, 0x000fe200078e0014ULL, 0x00005f00201f7a11ULL, 0x000fc400028f441fULL,
0x00005e002c227a11ULL, 0x000fe200078240ffULL, 0x0000001029167825ULL, 0x000fe200078e0016ULL,
0x00005e002e207a11ULL, 0x000fe200078440ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0023277a11ULL, 0x000fe200018f440eULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x00005f0025257a11ULL, 0x000fe200000f4428ULL,
0x00000000162d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002c237a11ULL, 0x000fe200008f4421ULL,
0x00000010291c7825ULL, 0x040fe200078e001cULL, 0x00005f002e217a11ULL, 0x000fe200010f4459ULL,
0x000000001e2f7faeULL, 0x0003e4000b901c46ULL, 0x0000001029267825ULL, 0x000fc400078e0026ULL,
0x000000001c317faeULL, 0x0003e4000b901c46ULL, 0x0000001029247825ULL, 0x040fe400078e0024ULL,
0x0000000026337faeULL, 0x0003e4000b901c46ULL, 0x0000001029227825ULL, 0x040fe400078e0022ULL,
0x0000000024517faeULL, 0x0003e4000b901c46ULL, 0x0000001029207825ULL, 0x000fc400078e0020ULL,
0x0000000022537faeULL, 0x0003e8000b901c46ULL, 0x00000000205b7faeULL, 0x0003e4000b901c46ULL,
0x000000030d0e7812ULL, 0x000fc800078ec0ffULL, 0x000000030e00780cULL, 0x000fc80003f05270ULL,
0x000000010b0e7807ULL, 0x000fca0004000000ULL, 0x000000010d0d7824ULL, 0x000fe400078e020eULL,
0xffffffffff0e7424ULL, 0x000fc600078e00ffULL, 0x000000040d00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000112147824ULL, 0x002fe400078e020dULL,
0x00000004ff157424ULL, 0x000fc800078e00ffULL, 0x0000600014147625ULL, 0x000fca00078e0015ULL,
0x00000006140e7981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136280062167f8cULL, 0x002fe8000c80043fULL,
0x01362c0062157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01362c0062157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000147824ULL, 0x000fca00078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000008061157810ULL, 0x000fca0007ffe014ULL, 0x0000000160157824ULL, 0x000fca00078e0215ULL,
0x0130000015167984ULL, 0x000e680000000800ULL, 0x0132000015177984ULL, 0x0004e20000000800ULL,
0x0000000f1600720bULL, 0x002fe20003f1d000ULL, 0x0000e5827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff141d7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000107157810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1600720bULL, 0x000fe40003f34000ULL, 0x000000001500720cULL, 0x000fe20003f05270ULL,
0x0000e5427f007947ULL, 0x000ff4000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x000000160f1e7209ULL, 0x040fe20007810000ULL, 0x0000008000158824ULL, 0x000fe200078e0261ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff2a7819ULL, 0x000fe20000011602ULL,
0x8000001e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000000160158824ULL, 0x000fc600078e0215ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fe40000410000ULL, 0x0134001e15008388ULL, 0x0003e20000000800ULL,
0x000000141dff7212ULL, 0x000fe2000780c0ffULL, 0x0000000f002b7308ULL, 0x000ea40000000800ULL,
0x0000002b10107220ULL, 0x004fe20000410000ULL, 0x0000e4c27f007947ULL, 0x000fee000b800000ULL,
0x00001f2a2b277589ULL, 0x0022a400000e0000ULL, 0x000000274c4c7220ULL, 0x084fe20000410000ULL,
0x000000274d4d7220ULL, 0x080fe20000410000ULL, 0x0000002748487220ULL, 0x080fe20000410000ULL,
0x0000002749497220ULL, 0x080fe20000410000ULL, 0x0000002744447220ULL, 0x080fe20000410000ULL,
0x0000002745457220ULL, 0x080fe20000410000ULL, 0x0000002740407220ULL, 0x080fe20000410000ULL,
0x0000002741417220ULL, 0x080fe20000410000ULL, 0x000000273c3c7220ULL, 0x080fe20000410000ULL,
0x000000273d3d7220ULL, 0x080fe20000410000ULL, 0x0000002738387220ULL, 0x080fe20000410000ULL,
0x0000002739397220ULL, 0x080fe20000410000ULL, 0x0000002734347220ULL, 0x080fe20000410000ULL,
0x0000002735357220ULL, 0x080fe20000410000ULL, 0x0000002718187220ULL, 0x080fe20000410000ULL,
0x0000002719197220ULL, 0x000fe20000410000ULL, 0x0000e3f27f007947ULL, 0x000fea000b800000ULL,
0x00001f572b277589ULL, 0x00052400000e0000ULL, 0x8000001e16160221ULL, 0x100fe20000010000ULL,
0x00000001ff1c7807ULL, 0x000fe20000000000ULL, 0x000000274e4e7220ULL, 0x094fe20000410000ULL,
0x000000274f4f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe20000410000ULL,
0x000000274a4a7220ULL, 0x080fe20000410000ULL, 0x000000274b4b7220ULL, 0x080fe20000410000ULL,
0x0000002746467220ULL, 0x080fe20000410000ULL, 0x0000001600130308ULL, 0x000ea20000000800ULL,
0x0000002747477220ULL, 0x080fe20000410000ULL, 0x0000002742427220ULL, 0x080fe20000410000ULL,
0x0000002743437220ULL, 0x080fe20000410000ULL, 0x000000273e3e7220ULL, 0x080fe20000410000ULL,
0x000000273f3f7220ULL, 0x080fe20000410000ULL, 0x000000273a3a7220ULL, 0x080fe20000410000ULL,
0x000000273b3b7220ULL, 0x080fe20000410000ULL, 0x0000002736367220ULL, 0x080fe20000410000ULL,
0x0000002737377220ULL, 0x080fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x000000271b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e001eULL,
0x0000001713170220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2a7819ULL, 0x002fe40000011602ULL, 0x00005410142b7816ULL, 0x000fe40000000014ULL,
0x000000182a167810ULL, 0x040fe40007ffe0ffULL, 0x000000102a1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000e2627f007947ULL, 0x000fea000b800000ULL, 0x00001f2a2b797589ULL, 0x0002a800000e0000ULL,
0x00001f572b787589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e001dULL, 0x00004ad000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000ec7000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0016ULL, 0x00004b3000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000ec1000007944ULL, 0x03cfea0003c00000ULL, 0x0000020000147824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001017107221ULL, 0x008fc60000010000ULL,
0xfffff80014157812ULL, 0x000fca00078ec0ffULL, 0x0000000164777824ULL, 0x000fc800078e0215ULL,
0x00001000117a7824ULL, 0x000fe200078e00ffULL, 0x00980000772c783bULL, 0x000ee20000000200ULL,
0x00004000091d7824ULL, 0x000fe200078e026eULL, 0x000099101c1c7816ULL, 0x000fe200000000ffULL,
0x000000016c6c7824ULL, 0x000fe200078e0215ULL, 0x000010007a7a7812ULL, 0x000fe400078e0cffULL,
0x000000ff1c00720cULL, 0x000fe40003f05270ULL, 0x0000b000756d7810ULL, 0x100fe20007ffe07aULL,
0x009800006c14783bULL, 0x000e620000000200ULL, 0x0000b0001d647810ULL, 0x000fc60007ffe07aULL,
0x0000001076727824ULL, 0x100fe400078e026dULL, 0x0000001074707824ULL, 0x100fe400078e026dULL,
0x00000010736f7824ULL, 0x100fe200078e026dULL, 0x00000000725c783bULL, 0x000f220000004200ULL,
0x00000010716d7824ULL, 0x000fe400078e026dULL, 0x000000106b687824ULL, 0x100fe200078e0264ULL,
0x000000007058783bULL, 0x000ea20000004200ULL, 0x000000106a667824ULL, 0x000fc400078e0264ULL,
0x0000001069657824ULL, 0x100fe200078e0264ULL, 0x000000006f50783bULL, 0x000ea20000004200ULL,
0x0000001067647824ULL, 0x000fc600078e0264ULL, 0x000000006d30783bULL, 0x000ea80000004200ULL,
0x000000006828783bULL, 0x002e680000004200ULL, 0x000000006624783bULL, 0x004ea20000004200ULL,
0x000000792c2c8231ULL, 0x008fc600003400ffULL, 0x000000006520783bULL, 0x000ee20000004200ULL,
0x000000792e2e8231ULL, 0x080fe400003400ffULL, 0x000000782d2d8231ULL, 0x090fe200003400ffULL,
0x00000000641c783bULL, 0x000f220000004200ULL, 0x000000782f2f8231ULL, 0x080fe400003400ffULL,
0x0000007914148231ULL, 0x080fe400003400ffULL, 0x0000007916168231ULL, 0x000fe400003400ffULL,
0x0000007815158231ULL, 0x000fc400003400ffULL, 0x0000007817178231ULL, 0x000fe200003400ffULL,
0x0000005c2c4c723cULL, 0x040ff0000004184cULL, 0x0000005e2c48723cULL, 0x040ff00000041848ULL,
0x000000582c44723cULL, 0x040ff00000041844ULL, 0x0000005a2c40723cULL, 0x040ff00000041840ULL,
0x000000502c3c723cULL, 0x040ff0000004183cULL, 0x000000522c38723cULL, 0x040ff00000041838ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x00000028144c723cULL, 0x042ff0000004184cULL, 0x0000002a1448723cULL, 0x040ff00000041848ULL,
0x000000241444723cULL, 0x044ff00000041844ULL, 0x000000261440723cULL, 0x040ff00000041840ULL,
0x00000020143c723cULL, 0x048ff0000004183cULL, 0x000000221438723cULL, 0x040ff00000041838ULL,
0x0000001c1434723cULL, 0x050ff00000041834ULL, 0x0000001e1418723cULL, 0x000fe20000041818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008054147811ULL, 0x000fe200078e40ffULL,
0x0136900063ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000111787812ULL, 0x000fc400078ec0ffULL,
0x000000031400720cULL, 0x000fda0003f06070ULL, 0x0000338000000947ULL, 0x000fea0003800000ULL,
0x0000001000147824ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe014157812ULL, 0x000fe200078ec0ffULL, 0x000058000e0e7a24ULL, 0x020fe200078e02ffULL,
0x0000000154147810ULL, 0x000fc60007ffe0ffULL, 0x0000010054157824ULL, 0x000fe200078e0215ULL,
0x000000051400720cULL, 0x000fe20003f06070ULL, 0x000000400e0e7824ULL, 0x000fc600078e00ffULL,
0x000000c015157810ULL, 0x000fc80007ffe0ffULL, 0x000000200a1c7812ULL, 0x000fca00078ef815ULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x0000200000167824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x000fe20000011602ULL, 0x000000080c2c7824ULL, 0x000fe200078e00ffULL,
0x0000001503147217ULL, 0x000fe40007800000ULL, 0x0000200016167812ULL, 0x000fe400078ec0ffULL,
0x00000004291d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a15ULL,
0x00000008291f7810ULL, 0x000fe20007ffe0ffULL, 0x0000400009177824ULL, 0x000fe200078e0216ULL,
0x000000021d167212ULL, 0x040fe200078e3cffULL, 0x000000081d2b7824ULL, 0x000fe200078e00ffULL,
0x0000002014287817ULL, 0x000fe20003800000ULL, 0x0000000129157824ULL, 0x000fe200078e021cULL,
0x0000b000177a7810ULL, 0x000fe20007ffe07aULL, 0x000000081f2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fc400078ee216ULL, 0x000000150e167210ULL, 0x000fe20007f1e0ffULL,
0x000000011d157824ULL, 0x000fe200078e021cULL, 0x000000021f147212ULL, 0x000fe400078e3cffULL,
0x0000000c292f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x00005e0016267a11ULL, 0x040fe400078040ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee214ULL,
0x000000082f5b7824ULL, 0x000fe200078e00ffULL, 0x00005f0016277a11ULL, 0x000fc400000f4417ULL,
0x000000150e147210ULL, 0x040fe20007f1e0ffULL, 0x000000011f157824ULL, 0x100fe200078e021cULL,
0x0000001029317810ULL, 0x000fe40007ffe0ffULL, 0x000000281d00720cULL, 0x080fe20003f46070ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x000000281f00720cULL, 0x000fe20003f26070ULL,
0x000000012f1d7824ULL, 0x100fe200078e021cULL, 0x000000150e157210ULL, 0x000fe20007f7e0ffULL,
0x00000001311f7824ULL, 0x000fe200078e021cULL, 0x00005e0014167a11ULL, 0x000fc400078040ffULL,
0x0000001d0e1d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005f0014177a11ULL, 0x000fe400000f4417ULL, 0x0000001f0e1f7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e0015247a11ULL, 0x000fe400078040ffULL,
0x0000001429337810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200028e06ffULL,
0x00005f0015257a11ULL, 0x000fc400000f442aULL, 0x00005e001f207a11ULL, 0x000fe200078840ffULL,
0x0000000133157824ULL, 0x000fe200078e021cULL, 0x0000001829537810ULL, 0x000fe40007ffe0ffULL,
0x00005e001d227a11ULL, 0x000fe400078640ffULL, 0x0000001c29597810ULL, 0x000fe40007ffe0ffULL,
0x00005f001f217a11ULL, 0x000fe400020f4414ULL, 0x000000150e147210ULL, 0x000fe20007f1e0ffULL,
0x0000000153157824ULL, 0x000fe200078e021cULL, 0x00005f001d237a11ULL, 0x000fe200018f441eULL,
0x00000001591d7824ULL, 0x000fe200078e021cULL, 0x000000282900720cULL, 0x040fe20003f66070ULL,
0x000000ffff1f7224ULL, 0x000fe200000e06ffULL, 0x0000000729297812ULL, 0x000fc400078e4802ULL,
0x000000150e2a7210ULL, 0x040fe40007f9e0ffULL, 0x0000001d0e0e7210ULL, 0x000fe40007fbe0ffULL,
0x0ffffff829297812ULL, 0x000fe200078ef802ULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x000000082c517812ULL, 0x000fe200078ee255ULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x00005e00141e7a11ULL, 0x000fe200078040ffULL, 0x0000001029297824ULL, 0x000fe200078e027aULL,
0x00005e002a1c7a11ULL, 0x000fe200078840ffULL, 0x0000001051267825ULL, 0x000fe200078e0026ULL,
0x00005f00141f7a11ULL, 0x000fc400000f441fULL, 0x00005e000e147a11ULL, 0x000fe200078a40ffULL,
0x0000001051167825ULL, 0x040fe200078e0016ULL, 0x00005f002a1d7a11ULL, 0x000fe200020f441dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e2000d901c46ULL,
0x00005f000e157a11ULL, 0x000fe200028f4415ULL, 0x0000001051247825ULL, 0x000fe200078e0024ULL,
0x000000282f00720cULL, 0x080fe40003f06070ULL, 0x000000283100720cULL, 0x080fe20003f66070ULL,
0x0000001051227825ULL, 0x000fe200078e0022ULL, 0x000000283300720cULL, 0x000fc40003f86070ULL,
0x000000285300720cULL, 0x080fe20003fa6070ULL, 0x0000001051207825ULL, 0x000fe200078e0020ULL,
0x000000285900720cULL, 0x000fe40003fc6070ULL, 0x00000002310e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x000000022f2c7212ULL, 0x080fe200078e3cffULL,
0x000000102b277824ULL, 0x002fe200078e027aULL, 0x0000000233287212ULL, 0x0c0fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x00000002532a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x0000000259267212ULL, 0x040fe200078e3cffULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0xfffffff85b2f7812ULL, 0x000fe200078ee22cULL,
0x000000102d297824ULL, 0x000fe200078e027aULL, 0xfffffff831317812ULL, 0x000fe200078ee20eULL,
0x00000010511e7825ULL, 0x000fe200078e001eULL, 0xfffffff833337812ULL, 0x000fe200078ee228ULL,
0x0000000016277faeULL, 0x0003e2000d101c46ULL, 0xfffffff853537812ULL, 0x000fe200078ee22aULL,
0x000000102f2b7824ULL, 0x000fe200078e027aULL, 0xfffffff859597812ULL, 0x000fe200078ee226ULL,
0x00000010312d7824ULL, 0x100fe200078e027aULL, 0x0000000024297faeULL, 0x0003e2000c901c46ULL,
0x00000010332f7824ULL, 0x000fc400078e027aULL, 0x0000001053317824ULL, 0x000fe200078e027aULL,
0x00000000222b7faeULL, 0x0003e2000c101c46ULL, 0x00000010511c7825ULL, 0x000fc600078e001cULL,
0x00000000202d7faeULL, 0x0003e2000d901c46ULL, 0x0000001059337824ULL, 0x000fe400078e027aULL,
0x0000001051147825ULL, 0x000fe200078e0014ULL, 0x000000001e2f7faeULL, 0x0003e8000e101c46ULL,
0x000000001c317faeULL, 0x0003e8000e901c46ULL, 0x0000000014337faeULL, 0x0003e2000f101c46ULL,
0x0000068000007947ULL, 0x000fea0003800000ULL, 0x0000200000147824ULL, 0x000fe200078e00ffULL,
0x00000003ff177819ULL, 0x000fe20000011602ULL, 0x000000080c327824ULL, 0x000fc600078e00ffULL,
0x0000200014147812ULL, 0x000fe400078ec0ffULL, 0x00000004171f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000817217810ULL, 0x000fe20007ffe0ffULL, 0x0000400009157824ULL, 0x000fe200078e0214ULL,
0x000000021f147212ULL, 0x0c0fe200078e3cffULL, 0x000000081f237824ULL, 0x000fe200078e00ffULL,
0x0000000221167212ULL, 0x040fe200078e3cffULL, 0x0000000821257824ULL, 0x000fe200078e00ffULL,
0x0000001417277810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e021cULL,
0xfffffff8231e7812ULL, 0x000fe200078ee214ULL, 0x0000000121217824ULL, 0x000fe200078e021cULL,
0x0000000c17237810ULL, 0x000fe20007ffe0ffULL, 0x00000008272d7824ULL, 0x000fe200078e00ffULL,
0x0000b000151d7810ULL, 0x000fe20007ffe07aULL, 0x0000000117157824ULL, 0x000fe200078e021cULL,
0xfffffff825207812ULL, 0x000fe200078ee216ULL, 0x0000000823297824ULL, 0x000fe200078e00ffULL,
0x0000001017257810ULL, 0x000fc40007ffe0ffULL, 0x0000000223227212ULL, 0x0c0fe200078e3cffULL,
0x0000000123237824ULL, 0x100fe200078e021cULL, 0x0000000227267212ULL, 0x080fe200078e3cffULL,
0x00000008252b7824ULL, 0x000fe200078e00ffULL, 0x000000150e157210ULL, 0x000fe20007f1e0ffULL,
0x0000000127277824ULL, 0x000fe200078e021cULL, 0xfffffff829227812ULL, 0x000fe400078ee222ULL,
0xfffffff82d267812ULL, 0x000fe200078ee226ULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000000225247212ULL, 0x040fe200078e3cffULL, 0x0000000125257824ULL, 0x000fe200078e021cULL,
0x0000001817297810ULL, 0x040fe20007ffe0ffULL, 0x0000001022317824ULL, 0x100fe200078e021dULL,
0x0000001c172d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001026517824ULL, 0x100fe200078e021dULL,
0xfffffff82b247812ULL, 0x000fe200078ee224ULL, 0x00000001292b7824ULL, 0x100fe200078e021cULL,
0x00005e0015147a11ULL, 0x000fe200078040ffULL, 0x000000012d2f7824ULL, 0x040fe200078e021cULL,
0x0000001f0e1f7210ULL, 0x000fe20007fde0ffULL, 0x000000082d307824ULL, 0x000fe200078e00ffULL,
0x00005f0015157a11ULL, 0x000fe200000f4416ULL, 0x0000001024337824ULL, 0x000fe200078e021dULL,
0x000000210e217210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x000000230e237210ULL, 0x000fc40007f9e0ffULL, 0x000000250e257210ULL, 0x040fe40007f7e0ffULL,
0x000000270e287210ULL, 0x040fe40007f1e0ffULL, 0x0000002b0e2a7210ULL, 0x040fe40007f3e0ffULL,
0x0000002f0e2e7210ULL, 0x000fe20007f5e0ffULL, 0x00000010202f7824ULL, 0x100fe200078e021dULL,
0x00000002290e7212ULL, 0x0c0fe200078e3cffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x0000000717177812ULL, 0x000fe200078e4802ULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x000000022d277212ULL, 0x000fe200078e3cffULL, 0x000000101e2d7824ULL, 0x000fe200078e021dULL,
0xfffffff8292c7812ULL, 0x000fe200078ee20eULL, 0x000000ffff597224ULL, 0x000fe200010e06ffULL,
0x0ffffff8170e7812ULL, 0x000fc400078ef802ULL, 0x00005e001f167a11ULL, 0x040fe200078c40ffULL,
0x000000102c537824ULL, 0x000fe200078e021dULL, 0xfffffff830307812ULL, 0x000fe200078ee227ULL,
0x000000100e2b7824ULL, 0x100fe200078e021dULL, 0x00005f001f177a11ULL, 0x000fe200030f441cULL,
0x000000ffff0e7224ULL, 0x000fe200028e06ffULL, 0x00005e00211e7a11ULL, 0x000fe200078a40ffULL,
0x00000010305b7824ULL, 0x000fe200078e021dULL, 0x00005e00231c7a11ULL, 0x000fe400078840ffULL,
0x00005f00211f7a11ULL, 0x000fe200028f440eULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x00005f00231d7a11ULL, 0x000fe200020f4420ULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x0000000832297812ULL, 0x000fe200078ee255ULL, 0x000000ffff237224ULL, 0x000fe200008e06ffULL,
0x00005e0025267a11ULL, 0x000fc400078640ffULL, 0x00005e0028247a11ULL, 0x000fe200078040ffULL,
0x0000001029147825ULL, 0x040fe200078e0014ULL, 0x00005e002a227a11ULL, 0x000fe400078240ffULL,
0x00005e002e207a11ULL, 0x000fe200078440ffULL, 0x0000001029167825ULL, 0x000fe200078e0016ULL,
0x00005f0025277a11ULL, 0x000fe200018f440eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0028257a11ULL, 0x000fe200000f4421ULL,
0x00000010291e7825ULL, 0x040fe200078e001eULL, 0x00005f002a237a11ULL, 0x000fe200008f4423ULL,
0x00000000162d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002e217a11ULL, 0x000fe200010f4459ULL,
0x00000010291c7825ULL, 0x000fc400078e001cULL, 0x000000001e2f7faeULL, 0x0003e4000b901c46ULL,
0x0000001029267825ULL, 0x040fe400078e0026ULL, 0x000000001c317faeULL, 0x0003e4000b901c46ULL,
0x0000001029247825ULL, 0x040fe400078e0024ULL, 0x0000000026337faeULL, 0x0003e4000b901c46ULL,
0x0000001029227825ULL, 0x000fc400078e0022ULL, 0x0000000024517faeULL, 0x0003e4000b901c46ULL,
0x0000001029207825ULL, 0x000fe400078e0020ULL, 0x0000000022537faeULL, 0x0003e8000b901c46ULL,
0x00000000205b7faeULL, 0x0003e4000b901c46ULL, 0x000000030d0e7812ULL, 0x000fc800078ec0ffULL,
0x000000030e00780cULL, 0x000fc80003f05270ULL, 0x000000010b0e7807ULL, 0x000fca0004000000ULL,
0x000000010d0d7824ULL, 0x000fe400078e020eULL, 0xffffffffff0e7424ULL, 0x000fc600078e00ffULL,
0x000000040d00720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000112147824ULL, 0x002fe400078e020dULL, 0x00000004ff157424ULL, 0x000fc800078e00ffULL,
0x0000600014147625ULL, 0x000fca00078e0015ULL, 0x00000006140e7981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136480062167f8cULL, 0x002fe8000c80043fULL, 0x01364c0062157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe006627812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff147424ULL, 0x000fe200078e00ffULL,
0x0000001006157812ULL, 0x000fc400078ec0ffULL, 0x00000008061c7812ULL, 0x000fc800078ec0ffULL,
0x000000621c627210ULL, 0x000fe40007ffe015ULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01364c0062157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000147824ULL, 0x000fca00078e00ffULL,
0xffffff8014147812ULL, 0x000fc800078ec0ffULL, 0x0000010061157810ULL, 0x000fca0007ffe014ULL,
0x0000000160157824ULL, 0x000fca00078e0215ULL, 0x0130000015167984ULL, 0x000e680000000800ULL,
0x0132000015177984ULL, 0x0004e20000000800ULL, 0x0000000f1600720bULL, 0x002fe20003f1d000ULL,
0x0000cd027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff141d7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000207157810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1600720bULL, 0x000fe40003f34000ULL,
0x000000001500720cULL, 0x000fe20003f05270ULL, 0x0000ccc27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x000000160f1c7209ULL, 0x040fe20007810000ULL,
0x00000080001f8824ULL, 0x000fe200078e0261ULL, 0x0000ffff14147812ULL, 0x000fe400078e3cffULL,
0x00000002ff2a7819ULL, 0x000fe20000011602ULL, 0x8000001c0f157221ULL, 0x000fe20000010000ULL,
0x00000001601f8824ULL, 0x000fc600078e021fULL, 0x3fb8aa3b15157820ULL, 0x000fe40000410000ULL,
0x0134001c1f008388ULL, 0x0003e20000000800ULL, 0x000000141dff7212ULL, 0x000fe2000780c0ffULL,
0x00000015002b7308ULL, 0x000ea40000000800ULL, 0x0000002b10107220ULL, 0x004fe20000410000ULL,
0x0000cc427f007947ULL, 0x000fee000b800000ULL, 0x00001f2a2b277589ULL, 0x0022a400000e0000ULL,
0x000000274c4c7220ULL, 0x084fe20000410000ULL, 0x000000274d4d7220ULL, 0x080fe20000410000ULL,
0x0000002748487220ULL, 0x080fe20000410000ULL, 0x0000002749497220ULL, 0x080fe20000410000ULL,
0x0000002744447220ULL, 0x080fe20000410000ULL, 0x0000002745457220ULL, 0x080fe20000410000ULL,
0x0000002740407220ULL, 0x080fe20000410000ULL, 0x0000002741417220ULL, 0x080fe20000410000ULL,
0x000000273c3c7220ULL, 0x080fe20000410000ULL, 0x000000273d3d7220ULL, 0x080fe20000410000ULL,
0x0000002738387220ULL, 0x080fe20000410000ULL, 0x0000002739397220ULL, 0x080fe20000410000ULL,
0x0000002734347220ULL, 0x080fe20000410000ULL, 0x0000002735357220ULL, 0x080fe20000410000ULL,
0x0000002718187220ULL, 0x080fe20000410000ULL, 0x0000002719197220ULL, 0x000fe20000410000ULL,
0x0000cb727f007947ULL, 0x000fea000b800000ULL, 0x00001f572b277589ULL, 0x00052400000e0000ULL,
0x000000160f0f7209ULL, 0x000fe20007810000ULL, 0x000000274e4e7220ULL, 0x094fe20000410000ULL,
0x00000001ff1c7807ULL, 0x000fe20000000000ULL, 0x000000274f4f7220ULL, 0x080fe20000410000ULL,
0x000000274a4a7220ULL, 0x080fe20000410000ULL, 0x8000000f16160221ULL, 0x000fe20000010000ULL,
0x000000274b4b7220ULL, 0x080fe20000410000ULL, 0x0000002746467220ULL, 0x080fe20000410000ULL,
0x0000002747477220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe20000410000ULL,
0x0000002742427220ULL, 0x080fe20000410000ULL, 0x0000002743437220ULL, 0x080fe20000410000ULL,
0x000000273e3e7220ULL, 0x080fe20000410000ULL, 0x0000001600130308ULL, 0x000ea20000000800ULL,
0x000000273f3f7220ULL, 0x080fe20000410000ULL, 0x000000273a3a7220ULL, 0x080fe20000410000ULL,
0x000000273b3b7220ULL, 0x080fe20000410000ULL, 0x0000002736367220ULL, 0x080fe20000410000ULL,
0x0000002737377220ULL, 0x080fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x000000271b1b7220ULL, 0x000fe20000410000ULL, 0x0000001713170220ULL, 0x00cfc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000013ff14723eULL, 0x000fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff2a7819ULL, 0x002fe40000011602ULL,
0x00005410142b7816ULL, 0x000fe40000000014ULL, 0x000000182a167810ULL, 0x040fe40007ffe0ffULL,
0x000000102a1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000c9e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2a2b797589ULL, 0x0002a800000e0000ULL, 0x00001f572b787589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e001dULL,
0x0000656000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000d1e000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e0016ULL,
0x000065c000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000d18000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001017107221ULL, 0x008fe20000010000ULL,
0x0000100011147824ULL, 0x000fe200078e00ffULL, 0x00a00000772c783bULL, 0x000ee20000000200ULL,
0x00004000091f7824ULL, 0x000fe200078e026eULL, 0x000099101c1d7816ULL, 0x000fe400000000ffULL,
0x00001000141e7812ULL, 0x000fc400078ec0ffULL, 0x00a000006c14783bULL, 0x000e620000000200ULL,
0x000000ff1d00720cULL, 0x000fe40003f05270ULL, 0x0000b00075757810ULL, 0x100fe40007ffe01eULL,
0x0000b0001f1c7810ULL, 0x000fc60007ffe01eULL, 0x00000010765c7824ULL, 0x100fe400078e0275ULL,
0x0000001074587824ULL, 0x100fe400078e0275ULL, 0x0000001073507824ULL, 0x100fe400078e0275ULL,
0x0000001071307824ULL, 0x000fe200078e0275ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x000000106b287824ULL, 0x102fe400078e021cULL, 0x000000106a247824ULL, 0x100fe200078e021cULL,
0x000000005858783bULL, 0x000e620000004200ULL, 0x0000001069207824ULL, 0x000fc400078e021cULL,
0x00000010671c7824ULL, 0x000fe200078e021cULL, 0x000000005050783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000e680000004200ULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x000000792c2c8231ULL, 0x00cfc600003400ffULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000792e2e8231ULL, 0x080fe400003400ffULL, 0x000000782d2d8231ULL, 0x090fe200003400ffULL,
0x000000002020783bULL, 0x000ee20000004200ULL, 0x000000782f2f8231ULL, 0x080fe400003400ffULL,
0x0000007914148231ULL, 0x080fe200003400ffULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0x0000007916168231ULL, 0x000fe400003400ffULL, 0x0000007815158231ULL, 0x000fc400003400ffULL,
0x0000007817178231ULL, 0x000fe200003400ffULL, 0x0000005c2c4c723cULL, 0x040ff0000004184cULL,
0x0000005e2c48723cULL, 0x040ff00000041848ULL, 0x000000582c44723cULL, 0x042ff00000041844ULL,
0x0000005a2c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028144c723cULL, 0x040ff0000004184cULL,
0x0000002a1448723cULL, 0x040ff00000041848ULL, 0x000000241444723cULL, 0x044ff00000041844ULL,
0x000000261440723cULL, 0x040ff00000041840ULL, 0x00000020143c723cULL, 0x048ff0000004183cULL,
0x000000221438723cULL, 0x040ff00000041838ULL, 0x0000001c1434723cULL, 0x050ff00000041834ULL,
0x0000001e1418723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000c054147811ULL, 0x000fe200078e40ffULL, 0x0136980063ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000111787812ULL, 0x000fc400078e0cffULL, 0x000000031400720cULL, 0x000fda0003f06070ULL,
0x0000193000000947ULL, 0x000fea0003800000ULL, 0x0000030054157a10ULL, 0x002fe20007ffe0ffULL,
0x000058000e0e7a24ULL, 0x020fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000115147810ULL, 0x040fe20007ffe0ffULL, 0x0000010015157824ULL, 0x000fe400078e0208ULL,
0x000000400e0e7824ULL, 0x000fe200078e00ffULL, 0x000000051400720cULL, 0x000fe40003f06070ULL,
0x000000200a227812ULL, 0x000fd600078ef815ULL, 0x0000076000008947ULL, 0x000fea0003800000ULL,
0x0000001503147217ULL, 0x000fe20007800000ULL, 0x0000200000167824ULL, 0x000fe200078e00ffULL,
0x00000003ff257819ULL, 0x000fe20000011602ULL, 0x000000080c1e7824ULL, 0x000fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe200078e0a15ULL, 0x00002000161c7812ULL, 0x000fe200078ec0ffULL,
0x0000100011157824ULL, 0x000fe200078e00ffULL, 0x00000004251d7810ULL, 0x040fe40007ffe0ffULL,
0x00000008251f7810ULL, 0x000fe20007ffe0ffULL, 0x0000400009177824ULL, 0x000fe200078e021cULL,
0x0000100015167812ULL, 0x000fe200078ec0ffULL, 0x0000000125157824ULL, 0x000fe200078e0222ULL,
0x000000021d1c7212ULL, 0x040fe200078e3cffULL, 0x000000081d2d7824ULL, 0x000fe200078e00ffULL,
0x0000b000172c7810ULL, 0x000fe20007ffe016ULL, 0x000000081f2f7824ULL, 0x000fe200078e00ffULL,
0x000000150e157210ULL, 0x000fe20007f1e0ffULL, 0x000000011d177824ULL, 0x000fe200078e0222ULL,
0xfffffff82d2d7812ULL, 0x000fc400078ee21cULL, 0x0000002014287817ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x000000021f1c7212ULL, 0x000fe200078e3cffULL,
0x000000102d2d7824ULL, 0x000fe200078e022cULL, 0x00005e0015147a11ULL, 0x000fe400078040ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee21cULL, 0x00005f0015157a11ULL, 0x000fe400000f4416ULL,
0x000000170e1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000011f177824ULL, 0x000fe200078e0222ULL,
0x0000000c25317810ULL, 0x000fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e022cULL,
0x000000281d00720cULL, 0x000fe20003f46070ULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x0000001025337810ULL, 0x000fe20007ffe0ffULL, 0x00000001311d7824ULL, 0x040fe200078e0222ULL,
0x00005e001c167a11ULL, 0x000fe200078040ffULL, 0x00000008312e7824ULL, 0x000fe200078e00ffULL,
0x000000170e217210ULL, 0x000fc40007f7e0ffULL, 0x000000281f00720cULL, 0x000fe20003f26070ULL,
0x00000001331f7824ULL, 0x000fe200078e0222ULL, 0x00005f001c177a11ULL, 0x000fe200000f4423ULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x0000001d0e237210ULL, 0x000fe40007f9e0ffULL,
0x000000081e557812ULL, 0x000fe400078ee255ULL, 0x0000001f0e1d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005e00231e7a11ULL, 0x000fe200078640ffULL,
0x0000001055147825ULL, 0x000fe200078e0014ULL, 0x0000001425517810ULL, 0x000fc40007ffe0ffULL,
0x00005f00231f7a11ULL, 0x000fe200018f4426ULL, 0x000000ffff247224ULL, 0x000fe200028e06ffULL,
0x00005e0021207a11ULL, 0x000fe200078040ffULL, 0x0000000151237824ULL, 0x000fe200078e0222ULL,
0x00005e001d1c7a11ULL, 0x000fe200078840ffULL, 0x0000001055167825ULL, 0x000fe200078e0016ULL,
0x0000001825537810ULL, 0x040fe40007ffe0ffULL, 0x0000001c25597810ULL, 0x000fe20007ffe0ffULL,
0x00000010551e7825ULL, 0x000fe200078e001eULL, 0x00005f0021217a11ULL, 0x000fc400000f442aULL,
0x00005f001d1d7a11ULL, 0x000fe400020f4424ULL, 0x000000282500720cULL, 0x080fe20003f66070ULL,
0x0000001055207825ULL, 0x000fe200078e0020ULL, 0x000000230e247210ULL, 0x040fe40007f1e0ffULL,
0x00000007252b7812ULL, 0x000fe200078e4802ULL, 0x0000000153237824ULL, 0x100fe200078e0222ULL,
0x000000285900720cULL, 0x040fe20003fc6070ULL, 0x0000000159257824ULL, 0x000fe200078e0222ULL,
0x0ffffff82b2b7812ULL, 0x000fe200078ef802ULL, 0x000000ffff297224ULL, 0x000fe200000e06ffULL,
0x000000230e277210ULL, 0x040fe20007f9e0ffULL, 0x00000010551c7825ULL, 0x000fe200078e001cULL,
0x000000250e257210ULL, 0x000fc40007fbe0ffULL, 0x00005e0024227a11ULL, 0x040fe200078040ffULL,
0x000000102b2b7824ULL, 0x000fe400078e022cULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005f0024237a11ULL, 0x000fe200000f4429ULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e2000d901c46ULL, 0x00005e0025247a11ULL, 0x000fe200078a40ffULL,
0x0000001055227825ULL, 0x000fe200078e0022ULL, 0x00005f0027277a11ULL, 0x000fe200020f442aULL,
0x00000000162d7faeULL, 0x0005e2000d101c46ULL, 0x00005f0025257a11ULL, 0x000fc400028f440eULL,
0x000000283100720cULL, 0x080fe20003f06070ULL, 0x0000001055267825ULL, 0x000fe200078e0026ULL,
0x000000283300720cULL, 0x080fe20003f66070ULL, 0x00000000202f7faeULL, 0x0005e2000c901c46ULL,
0x000000285100720cULL, 0x080fe20003f86070ULL, 0x0000001055247825ULL, 0x000fe200078e0024ULL,
0x000000285300720cULL, 0x000fe40003fa6070ULL, 0x00000002330e7212ULL, 0x0c0fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000000231297212ULL, 0x080fe200078e3cffULL,
0x0000000853317824ULL, 0x000fe200078e00ffULL, 0x0000000251287212ULL, 0x0c0fe200078e3cffULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x0000000259147212ULL, 0x0c2fe200078e3cffULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0x00000002532a7212ULL, 0x000fc400078e3cffULL,
0xfffffff82e297812ULL, 0x000fe400078ee229ULL, 0xfffffff833157812ULL, 0x000fe400078ee20eULL,
0xfffffff8512b7812ULL, 0x000fe200078ee228ULL, 0x0000001029297824ULL, 0x000fe200078e022cULL,
0xfffffff831317812ULL, 0x000fe200078ee22aULL, 0x0000001015157824ULL, 0x000fe200078e022cULL,
0xfffffff859337812ULL, 0x000fe200078ee214ULL, 0x000000102b2b7824ULL, 0x100fe200078e022cULL,
0x000000001e297faeULL, 0x0005e2000c101c46ULL, 0x0000001031317824ULL, 0x000fc400078e022cULL,
0x0000001033337824ULL, 0x000fe200078e022cULL, 0x000000001c157faeULL, 0x0005e8000d901c46ULL,
0x00000000222b7faeULL, 0x0005e8000e101c46ULL, 0x0000000026317faeULL, 0x0005e8000e901c46ULL,
0x0000000024337faeULL, 0x0005e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x0000200000157824ULL, 0x000fe200078e00ffULL, 0x00000003ff177819ULL, 0x000fe20000011602ULL,
0x000000080c1e7824ULL, 0x000fc400078e00ffULL, 0x0000100011147824ULL, 0x000fe200078e00ffULL,
0x0000200015167812ULL, 0x000fe400078ec0ffULL, 0x00000004171f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000817217810ULL, 0x000fe20007ffe0ffULL, 0x0000400009157824ULL, 0x000fe200078e0216ULL,
0x000000021f167212ULL, 0x0c0fe200078e3cffULL, 0x000000081f237824ULL, 0x000fe200078e00ffULL,
0x000000081e557812ULL, 0x000fe200078ee255ULL, 0x0000000821257824ULL, 0x040fe200078e00ffULL,
0x00000002211c7212ULL, 0x000fe200078e3cffULL, 0x000000011f1f7824ULL, 0x000fe200078e0222ULL,
0xfffffff8231e7812ULL, 0x000fe200078ee216ULL, 0x0000000121217824ULL, 0x000fe200078e0222ULL,
0x0000000c17237810ULL, 0x000fc40007ffe0ffULL, 0x0000100014147812ULL, 0x000fe400078ec0ffULL,
0x0000001417277810ULL, 0x000fe20007ffe0ffULL, 0x0000000823297824ULL, 0x000fe200078e00ffULL,
0xfffffff825207812ULL, 0x000fe400078ee21cULL, 0x0000b000151d7810ULL, 0x000fe20007ffe014ULL,
0x0000000117157824ULL, 0x140fe200078e0222ULL, 0x0000001017257810ULL, 0x000fe20007ffe0ffULL,
0x00000008272d7824ULL, 0x000fe200078e00ffULL, 0x00000002231c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000123237824ULL, 0x000fe200078e0222ULL, 0x0000000227287212ULL, 0x000fe200078e3cffULL,
0x00000008252b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829247812ULL, 0x000fe200078ee21cULL,
0x0000000127277824ULL, 0x000fe200078e0222ULL, 0x000000150e157210ULL, 0x000fc40007f1e0ffULL,
0x0000000225267212ULL, 0x040fe200078e3cffULL, 0x0000000125257824ULL, 0x000fe200078e0222ULL,
0xfffffff82d287812ULL, 0x000fe200078ee228ULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000001817297810ULL, 0x040fe40007ffe0ffULL, 0x0000001c172d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001028337824ULL, 0x100fe200078e021dULL, 0xfffffff82b267812ULL, 0x000fe200078ee226ULL,
0x00000001292b7824ULL, 0x100fe200078e0222ULL, 0x00005e0015147a11ULL, 0x000fe200078040ffULL,
0x000000012d2f7824ULL, 0x000fe200078e0222ULL, 0x0000000717177812ULL, 0x000fe200078e4802ULL,
0x000000082d2e7824ULL, 0x000fe200078e00ffULL, 0x00005f0015157a11ULL, 0x000fe200000f4416ULL,
0x0000001026317824ULL, 0x000fe200078e021dULL, 0x0000002b0e2a7210ULL, 0x040fe20007f3e0ffULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0x0000001f0e1f7210ULL, 0x040fe20007fde0ffULL,
0x0000001055147825ULL, 0x000fe200078e0014ULL, 0x000000210e217210ULL, 0x000fc40007fbe0ffULL,
0x000000230e237210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x000000250e257210ULL, 0x040fe40007f7e0ffULL, 0x000000270e277210ULL, 0x040fe40007f1e0ffULL,
0x0000002f0e2c7210ULL, 0x000fe20007f5e0ffULL, 0x00000010242f7824ULL, 0x100fe200078e021dULL,
0x0000000229227212ULL, 0x080fe200078e3cffULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x000000022d297212ULL, 0x000fe200078e3cffULL, 0x00000010202d7824ULL, 0x000fe200078e021dULL,
0x0ffffff8170e7812ULL, 0x000fe200078ef802ULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee229ULL, 0x000000ffff537224ULL, 0x000fe200010e06ffULL,
0xfffffff82b227812ULL, 0x000fe200078ee222ULL, 0x000000100e297824ULL, 0x100fe200078e021dULL,
0x00005e001f167a11ULL, 0x000fe200078c40ffULL, 0x000000101e2b7824ULL, 0x100fe200078e021dULL,
0x00005e0027247a11ULL, 0x000fe200078040ffULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x00005e00211e7a11ULL, 0x000fe200078a40ffULL, 0x0000001022517824ULL, 0x100fe200078e021dULL,
0x00005f001f177a11ULL, 0x000fe200030f441cULL, 0x000000102e597824ULL, 0x000fe200078e021dULL,
0x00005e00231c7a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014297faeULL, 0x0003e2000b901c46ULL, 0x00005f00211f7a11ULL, 0x000fe200028f440eULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x00005e0025227a11ULL, 0x000fe200078640ffULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x00005f00231d7a11ULL, 0x000fe200020f4420ULL,
0x0000001055167825ULL, 0x000fe200078e0016ULL, 0x00005e002a267a11ULL, 0x000fc400078240ffULL,
0x00005e002c207a11ULL, 0x000fe200078440ffULL, 0x00000010551e7825ULL, 0x000fe200078e001eULL,
0x00005f0025237a11ULL, 0x000fe200018f440eULL, 0x00000000162b7faeULL, 0x0003e2000b901c46ULL,
0x00005f0027257a11ULL, 0x000fe200000f4428ULL, 0x00000010551c7825ULL, 0x040fe200078e001cULL,
0x00005f002a277a11ULL, 0x000fe200008f4421ULL, 0x000000001e2d7faeULL, 0x0003e2000b901c46ULL,
0x00005f002c217a11ULL, 0x000fe200010f4453ULL, 0x0000001055227825ULL, 0x040fe400078e0022ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x0000001055247825ULL, 0x000fc400078e0024ULL,
0x0000000022317faeULL, 0x0003e4000b901c46ULL, 0x0000001055267825ULL, 0x040fe400078e0026ULL,
0x0000000024337faeULL, 0x0003e4000b901c46ULL, 0x0000001055207825ULL, 0x000fe400078e0020ULL,
0x0000000026517faeULL, 0x0003e8000b901c46ULL, 0x0000000020597faeULL, 0x0003e4000b901c46ULL,
0x000000030d0e7812ULL, 0x000fc800078ec0ffULL, 0x000000030e00780cULL, 0x000fc80003f05270ULL,
0x000000010b0e7807ULL, 0x000fca0004000000ULL, 0x000000010d0d7824ULL, 0x000fe400078e020eULL,
0xffffffffff0e7424ULL, 0x000fc600078e00ffULL, 0x000000040d00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000112147824ULL, 0x002fe400078e020dULL,
0x00000004ff157424ULL, 0x004fc800078e00ffULL, 0x0000600014147625ULL, 0x000fca00078e0015ULL,
0x00000006140e7981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136680062167f8cULL, 0x006fe8000c80043fULL,
0x01366c0062157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01366c0062157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000147824ULL, 0x000fca00078e00ffULL, 0xffffff8014147812ULL, 0x000fc800078ec0ffULL,
0x0000018061157810ULL, 0x000fca0007ffe014ULL, 0x0000000160157824ULL, 0x000fca00078e0215ULL,
0x0130000015167984ULL, 0x000e680000000800ULL, 0x0132000015177984ULL, 0x0004e20000000800ULL,
0x0000000f1600720bULL, 0x002fe20003f1d000ULL, 0x0000b4e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff141d7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000307157810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1600720bULL, 0x000fe40003f34000ULL, 0x000000001500720cULL, 0x000fe20003f05270ULL,
0x0000b4a27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x000000160f1e7209ULL, 0x040fe20007810000ULL, 0x0000008000618824ULL, 0x000fe200078e0261ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff2a7819ULL, 0x000fe20000011602ULL,
0x8000001e0f0f7221ULL, 0x000fe20000010000ULL, 0x0000000160618824ULL, 0x000fc600078e0261ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fe40000410000ULL, 0x0134001e61008388ULL, 0x0003e20000000800ULL,
0x000000141dff7212ULL, 0x000fe2000780c0ffULL, 0x0000000f002b7308ULL, 0x000ea40000000800ULL,
0x0000002b10107220ULL, 0x004fe20000410000ULL, 0x0000b4227f007947ULL, 0x000fee000b800000ULL,
0x00001f2a2b277589ULL, 0x0022a400000e0000ULL, 0x000000274c4c7220ULL, 0x084fe20000410000ULL,
0x000000274d4d7220ULL, 0x080fe20000410000ULL, 0x0000002748487220ULL, 0x080fe20000410000ULL,
0x0000002749497220ULL, 0x080fe20000410000ULL, 0x0000002744447220ULL, 0x080fe20000410000ULL,
0x0000002745457220ULL, 0x080fe20000410000ULL, 0x0000002740407220ULL, 0x080fe20000410000ULL,
0x0000002741417220ULL, 0x080fe20000410000ULL, 0x000000273c3c7220ULL, 0x080fe20000410000ULL,
0x000000273d3d7220ULL, 0x080fe20000410000ULL, 0x0000002738387220ULL, 0x080fe20000410000ULL,
0x0000002739397220ULL, 0x080fe20000410000ULL, 0x0000002734347220ULL, 0x080fe20000410000ULL,
0x0000002735357220ULL, 0x080fe20000410000ULL, 0x0000002718187220ULL, 0x080fe20000410000ULL,
0x0000002719197220ULL, 0x000fe20000410000ULL, 0x0000b3527f007947ULL, 0x000fea000b800000ULL,
0x00001f572b277589ULL, 0x00052400000e0000ULL, 0x8000001e16160221ULL, 0x100fe20000010000ULL,
0x00000001ff1c7807ULL, 0x000fe20000000000ULL, 0x000000274e4e7220ULL, 0x094fe20000410000ULL,
0x000000274f4f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b16160820ULL, 0x000fe20000410000ULL,
0x000000274a4a7220ULL, 0x080fe20000410000ULL, 0x000000274b4b7220ULL, 0x080fe20000410000ULL,
0x0000002746467220ULL, 0x080fe20000410000ULL, 0x0000001600130308ULL, 0x000ea20000000800ULL,
0x0000002747477220ULL, 0x080fe20000410000ULL, 0x0000002742427220ULL, 0x080fe20000410000ULL,
0x0000002743437220ULL, 0x080fe20000410000ULL, 0x000000273e3e7220ULL, 0x080fe20000410000ULL,
0x000000273f3f7220ULL, 0x080fe20000410000ULL, 0x000000273a3a7220ULL, 0x080fe20000410000ULL,
0x000000273b3b7220ULL, 0x080fe20000410000ULL, 0x0000002736367220ULL, 0x080fe20000410000ULL,
0x0000002737377220ULL, 0x080fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x000000271b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e001eULL,
0x0000001713170220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000013ff14723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2a7819ULL, 0x002fe40000011602ULL, 0x00005410142b7816ULL, 0x000fe40000000014ULL,
0x000000182a167810ULL, 0x040fe40007ffe0ffULL, 0x000000102a1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000b1c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2a2b557589ULL, 0x0002a800000e0000ULL,
0x00001f572b567589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e001dULL, 0x00007f9000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000b7b000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e0016ULL, 0x00007ff000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000b75000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001017107221ULL, 0x008fe20000010000ULL, 0x00a80000772c783bULL, 0x000ee20000000200ULL,
0x000099101c1c7816ULL, 0x000fc600000000ffULL, 0x00000000725c783bULL, 0x000e620000004200ULL,
0x000000ff1c00720cULL, 0x000fc60003f05270ULL, 0x000000007058783bULL, 0x000fe80000004200ULL,
0x000000006f50783bULL, 0x000fe80000004200ULL, 0x000000006d30783bULL, 0x000fe80000004200ULL,
0x00a800006c14783bULL, 0x000f280000000200ULL, 0x000000006828783bULL, 0x002e680000004200ULL,
0x000000006624783bULL, 0x004ea80000004200ULL, 0x000000006520783bULL, 0x000e680000004200ULL,
0x00000000641c783bULL, 0x000e620000004200ULL, 0x000000552c2c8231ULL, 0x008fc400003400ffULL,
0x000000552e2e8231ULL, 0x000fe400003400ffULL, 0x000000562d2d8231ULL, 0x090fe400003400ffULL,
0x000000562f2f8231ULL, 0x000fce00003400ffULL, 0x0000005c2c4c723cULL, 0x000fe2000004184cULL,
0x0000005514148231ULL, 0x000fce00003400ffULL, 0x0000005e2c48723cULL, 0x000fe20000041848ULL,
0x0000005516168231ULL, 0x000fe400003400ffULL, 0x0000005615158231ULL, 0x080fe400003400ffULL,
0x0000005617178231ULL, 0x000fc600003400ffULL, 0x000000582c44723cULL, 0x040ff00000041844ULL,
0x0000005a2c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028144c723cULL, 0x042ff0000004184cULL,
0x0000002a1448723cULL, 0x040ff00000041848ULL, 0x000000241444723cULL, 0x044ff00000041844ULL,
0x000000261440723cULL, 0x040ff00000041840ULL, 0x00000020143c723cULL, 0x040ff0000004183cULL,
0x000000221438723cULL, 0x040ff00000041838ULL, 0x0000001c1434723cULL, 0x040ff00000041834ULL,
0x0000001e1418723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0136a00063ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000111787812ULL, 0x000fce00078ec0ffULL,
0x0000030054547a10ULL, 0x002fc80007ffe0ffULL, 0x000000055400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff942000007947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x002e620000002500ULL, 0x000000ffff1c7224ULL, 0x000fe200078e001aULL,
0x000000050600720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000010027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0010ULL,
0x000083c000257802ULL, 0x000fe40000000f00ULL, 0x0000b1c000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff027224ULL, 0x008fe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001000037308ULL, 0x000e640000001000ULL, 0xbf80000003027423ULL, 0x002fc80000000010ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203027223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e680000000000ULL,
0x0000000000057919ULL, 0x000ea20000000000ULL, 0x00000002ff037819ULL, 0x002fe40000011603ULL,
0x0000000805057811ULL, 0x004fc800078ff0ffULL, 0x00001f0302037589ULL, 0x000e6800000e0000ULL,
0x00001f0502057589ULL, 0x000ea200000e0000ULL, 0x0000004c034c7220ULL, 0x042fe20000410000ULL,
0x0000004d034d7220ULL, 0x040fe20000410000ULL, 0x0000004803487220ULL, 0x040fe20000410000ULL,
0x0000004903497220ULL, 0x040fe20000410000ULL, 0x0000004403447220ULL, 0x040fe20000410000ULL,
0x0000004503457220ULL, 0x040fe20000410000ULL, 0x0000004003407220ULL, 0x040fe20000410000ULL,
0x0000004103417220ULL, 0x040fe20000410000ULL, 0x0000003c033c7220ULL, 0x040fe20000410000ULL,
0x0000003d033d7220ULL, 0x040fe20000410000ULL, 0x0000003803387220ULL, 0x040fe20000410000ULL,
0x0000003903397220ULL, 0x040fe20000410000ULL, 0x0000003403347220ULL, 0x040fe20000410000ULL,
0x0000003503357220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x000fe20000410000ULL, 0x0000004e054e7220ULL, 0x044fe20000410000ULL,
0x0000004f054f7220ULL, 0x040fe20000410000ULL, 0x0000004a054a7220ULL, 0x040fe20000410000ULL,
0x0000004b054b7220ULL, 0x040fe20000410000ULL, 0x0000004605467220ULL, 0x040fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x000fc40000410000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00000036371a723eULL, 0x000fc400000010ffULL, 0x000000383911723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001c1b1b723eULL, 0x000fe400000010ffULL,
0x0000004c4d04723eULL, 0x000fe400000010ffULL, 0x00000048490a723eULL, 0x000fe400000010ffULL,
0x00000044450b723eULL, 0x000fe400000010ffULL, 0x00000040410d723eULL, 0x000fc400000010ffULL,
0x0000003c3d0e723eULL, 0x020fe400000010ffULL, 0x000000343512723eULL, 0x000fe400000010ffULL,
0x000000181913723eULL, 0x000fe400000010ffULL, 0x0000004e4f14723eULL, 0x000fe400000010ffULL,
0x0000004a4b15723eULL, 0x000fe400000010ffULL, 0x00000002ff287819ULL, 0x002fc40000011605ULL,
0x0000000805367811ULL, 0x000fe400078ff0ffULL, 0x00000028ff2a7212ULL, 0x000fe200078e33ffULL,
0x00000008281d7824ULL, 0x000fe200078e00ffULL, 0x00000036ff387212ULL, 0x000fe200078e33ffULL,
0x00000008361f7824ULL, 0x000fe200078e00ffULL, 0x0000000728027812ULL, 0x040fe200078ec0ffULL,
0x0000000828037824ULL, 0x000fe200078e00ffULL, 0xfffffff81d2a7812ULL, 0x000fe400078ee22aULL,
0xfffffff81f387812ULL, 0x000fc400078ee238ULL, 0xfffffff8031c7812ULL, 0x000fe400078ee228ULL,
0x0000000102037812ULL, 0x040fe400078e3cffULL, 0x00000002021d7812ULL, 0x040fe400078e3cffULL,
0x00000003021f7812ULL, 0x000fe200078e3cffULL, 0x00000008281e7824ULL, 0x000fe200078e0203ULL,
0x0000000402217812ULL, 0x000fe200078e3cffULL, 0x0000000828207824ULL, 0x000fe200078e021dULL,
0x0000000502237812ULL, 0x000fe200078e3cffULL, 0x0000000828227824ULL, 0x000fe200078e021fULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x0000000828247824ULL, 0x000fe200078e0221ULL,
0x00000007361f7812ULL, 0x000fe200078ec0ffULL, 0x0000000828267824ULL, 0x040fe200078e0223ULL,
0x000000464716723eULL, 0x000fe200000010ffULL, 0x0000000828287824ULL, 0x000fe200078e0202ULL,
0x000000021f237812ULL, 0x040fe200078e3cffULL, 0x000010000c027824ULL, 0x000fe200078e00ffULL,
0x000000031f257812ULL, 0x000fe200078e3cffULL, 0x00000004051d7824ULL, 0x000fe200078e00ffULL,
0x000000041f277812ULL, 0x000fe200078e3cffULL, 0x0000080009037824ULL, 0x000fe200078e0202ULL,
0x000000051f297812ULL, 0x000fe200078e3cffULL, 0x0000000836217824ULL, 0x000fe200078e00ffULL,
0x0000000c1d1d7812ULL, 0x000fe200078ec0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e0203ULL,
0x000000061f2b7812ULL, 0x000fe200078e3cffULL, 0x000000101e1e7824ULL, 0x100fe200078e0203ULL,
0xfffffff8212c7812ULL, 0x000fe200078ee236ULL, 0x0000001020207824ULL, 0x000fe200078e0203ULL,
0x000000011f217812ULL, 0x000fe200078e3cffULL, 0x000000011c1f7824ULL, 0x000fe200078e021dULL,
0x000000424317723eULL, 0x000fe200000010ffULL, 0x0000001022227824ULL, 0x100fe200078e0203ULL,
0x0000003e3f18723eULL, 0x000fe200000010ffULL, 0x0000001024247824ULL, 0x000fe200078e0203ULL,
0x000000041f007388ULL, 0x0003e20000000800ULL, 0x00000008362e7824ULL, 0x000fe200078e0221ULL,
0x0000003a3b19723eULL, 0x000fe200000010ffULL, 0x0000001026267824ULL, 0x000fc400078e0203ULL,
0x0000000836307824ULL, 0x000fe400078e0223ULL, 0x0000001028287824ULL, 0x000fe400078e0203ULL,
0x000000011d207824ULL, 0x040fe200078e0220ULL, 0x000000ff00047306ULL, 0x002fe20000205400ULL,
0x000000011d1f7824ULL, 0x040fe400078e021eULL, 0x0000000836327824ULL, 0x000fe400078e0225ULL,
0x000000102a2a7824ULL, 0x000fe200078e0203ULL, 0x0000000a1f007388ULL, 0x000fe20000000800ULL,
0x000000011d227824ULL, 0x000fc400078e0222ULL, 0x00000008361c7824ULL, 0x000fe200078e0227ULL,
0x0000000b20007388ULL, 0x0003e20000000800ULL, 0x000000102c2c7824ULL, 0x000fe400078e0203ULL,
0x000000011d217824ULL, 0x040fe200078e0224ULL, 0x0000000d22007388ULL, 0x0005e20000000800ULL,
0x0000000836347824ULL, 0x000fe400078e0229ULL, 0x000000102e2e7824ULL, 0x000fe200078e0203ULL,
0x0000000e21007388ULL, 0x000fe20000000800ULL, 0x000000011d267824ULL, 0x000fe200078e0226ULL,
0x000000ff000b7306ULL, 0x002e620000209400ULL, 0x0000000836367824ULL, 0x000fc400078e022bULL,
0x0000001030307824ULL, 0x100fe200078e0203ULL, 0x0000001126007388ULL, 0x000fe20000000800ULL,
0x000000011d237824ULL, 0x040fe400078e0228ULL, 0x000000011d2a7824ULL, 0x040fe400078e022aULL,
0x0000001032327824ULL, 0x100fe200078e0203ULL, 0x0000001223007388ULL, 0x000fe20000000800ULL,
0x000000011d257824ULL, 0x000fe400078e022cULL, 0x000000101c1c7824ULL, 0x100fe200078e0203ULL,
0x000000132a007388ULL, 0x000fe20000000800ULL, 0x0000001038387824ULL, 0x100fe200078e0203ULL,
0x000000040b00720bULL, 0x002fe20003f1d000ULL, 0x0000001034347824ULL, 0x100fe200078e0203ULL,
0x0000001425007388ULL, 0x000fe20000000800ULL, 0x000000011d2e7824ULL, 0x000fe200078e022eULL,
0x000000ff00047245ULL, 0x000fe2000020d400ULL, 0x0000001036367824ULL, 0x000fc400078e0203ULL,
0x000000011d277824ULL, 0x040fe200078e0230ULL, 0x000000152e007388ULL, 0x000fe20000000800ULL,
0x000000011d327824ULL, 0x040fe400078e0232ULL, 0x000000011d297824ULL, 0x040fe200078e021cULL,
0x0000001627007388ULL, 0x000fe20000000800ULL, 0x000000011d387824ULL, 0x040fe200078e0238ULL,
0x0000000104040812ULL, 0x000fe200078efcffULL, 0x000000011d347824ULL, 0x040fe200078e0234ULL,
0x0000001732007388ULL, 0x000fe20000000800ULL, 0x000000011d1d7824ULL, 0x000fe200078e0236ULL,
0x00000004040a723eULL, 0x000fe200000010ffULL, 0x00000001082b7824ULL, 0x000fe200078e0205ULL,
0x0000001829007388ULL, 0x000fe60000000800ULL, 0x000000102b0d7824ULL, 0x004fe200078e0202ULL,
0x0000001934007388ULL, 0x000fe80000000800ULL, 0x0000001a1d007388ULL, 0x000fe80000000800ULL,
0x0000001b38007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000d207984ULL, 0x000e680000000c00ULL, 0x000400000d147984ULL, 0x000ea80000000c00ULL,
0x000800000d247984ULL, 0x000ee80000000c00ULL, 0x000c00000d2c7984ULL, 0x000f220000000c00ULL,
0x3f803f800a237831ULL, 0x002fc40000200023ULL, 0x3f803f800a227831ULL, 0x040fe40000200022ULL,
0x3f803f800a217831ULL, 0x040fe40000200021ULL, 0x3f803f800a207831ULL, 0x040fe40000200020ULL,
0x3f803f800a177831ULL, 0x044fe40000200017ULL, 0x3f803f800a167831ULL, 0x040fe40000200016ULL,
0x3f803f800a157831ULL, 0x000fc40000200015ULL, 0x3f803f800a147831ULL, 0x000fe20000200014ULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x3f803f8023237831ULL, 0x008fe40000200027ULL,
0x3f803f8022227831ULL, 0x000fe40000200026ULL, 0x000003000a007a0cULL, 0x000fe20003f05270ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fe40000200024ULL,
0x3f803f8017177831ULL, 0x010fc4000020002fULL, 0x3f803f8016167831ULL, 0x000fe2000020002eULL,
0x000000200d007388ULL, 0x0003e20000000c00ULL, 0x3f803f8015157831ULL, 0x000fe4000020002dULL,
0x3f803f8014147831ULL, 0x000fca000020002cULL, 0x000400140d007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00002f2000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000ea20000002700ULL, 0x00005800ff0a7624ULL, 0x000fe200078e00ffULL,
0x0000000109ff7812ULL, 0x000fe2000780f800ULL, 0x00000800ff137424ULL, 0x000fe200078e00ffULL,
0x00000000000b7919ULL, 0x000ea40000002600ULL, 0x000000ff0500720cULL, 0x000fc40000725670ULL,
0x000000000d187984ULL, 0x0007220000000c00ULL, 0x000058000e0e7a24ULL, 0x004fe400078e020bULL,
0x000003000a0b7a24ULL, 0x000fe400078e02ffULL, 0x000003000e0a7a24ULL, 0x000fe400078e02ffULL,
0x000066000b0b7a24ULL, 0x000fe400078e02ffULL, 0x000000010a117824ULL, 0x000fc600078e0206ULL,
0x000007ff0b067811ULL, 0x040fe400078e40ffULL, 0x01ffffff0b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000001106127211ULL, 0x000fca00078fa8ffULL, 0x00006c0012127625ULL, 0x000fcc00078e0013ULL,
0x000004000c127825ULL, 0x000fcc00078e0012ULL, 0x000000102b167825ULL, 0x002fe200078e0012ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000001ff127819ULL, 0x018fe20000011605ULL,
0x00000010050d7824ULL, 0x000fe400078e00ffULL, 0x00000080ff157424ULL, 0x000fe200078e00ffULL,
0x0000000c121c7812ULL, 0x000fe200078ec0ffULL, 0x0000000111147824ULL, 0x000fe200078e020bULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x00006c0011127625ULL, 0x000fc800078e0015ULL,
0x00006c0014147625ULL, 0x000fe200078e0015ULL, 0x000000121c127210ULL, 0x000fc80007a1e00dULL,
0x000000141c147210ULL, 0x000fe40007c7e00dULL, 0x00000013ff137210ULL, 0x000fe400007e44ffULL,
0x00000015ff157210ULL, 0x000fc60001fe84ffULL, 0x0000000f12007986ULL, 0x0003e8000c101906ULL,
0x0000001014007986ULL, 0x0003e4000c101906ULL, 0x0000001816007986ULL, 0x0185e2000c101d06ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x00000004ff0f7424ULL, 0x002fc600078e00ffULL, 0x000003000d0d7a10ULL, 0x000fe20007ffe1ffULL,
0x00006a000e0e7625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0e0e79a8ULL, 0x000ee400099ee1c6ULL,
0x0000000d0e00720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff107807ULL, 0x000fca0000000000ULL, 0x00000010ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff0d7984ULL, 0x000ee40000000000ULL, 0x000000ff0d00720cULL, 0x008fda0003f05270ULL,
0x00002b9000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000d6000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x000000010a107810ULL, 0x002fe20007ffe0ffULL,
0x0000001005007824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011605ULL,
0x00000080ff1b7424ULL, 0x004fc600078e00ffULL, 0x00000070001d7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0e7625ULL, 0x000fe200078e001bULL, 0x0000000c0d147812ULL, 0x000fc600078ec0ffULL,
0x00006c0010107625ULL, 0x000fe200078e001bULL, 0x0000000e140e7210ULL, 0x000fc8000791e01dULL,
0x0000001014107210ULL, 0x000fe40007b5e01dULL, 0x0000000fff0f7210ULL, 0x000fe400007e24ffULL,
0x00000011ff117210ULL, 0x000fc600017e64ffULL, 0x000000060e007981ULL, 0x000368000c1e1900ULL,
0x00000006100d7981ULL, 0x000362000c1e1900ULL, 0x00000300ff127624ULL, 0x000fca00078e00ffULL,
0x000000021200780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x000000020a0e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e001bULL,
0x0000000e140e7210ULL, 0x000fc8000791e01dULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e137981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x000000030a0e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e001bULL, 0x0000000e140e7210ULL, 0x000fc8000791e01dULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e157981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x000000040a0e7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000e0e7625ULL, 0x000fca00078e001bULL,
0x0000000e140e7210ULL, 0x000fc8000791e01dULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e177981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000000050a0e7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e001bULL, 0x0000000e140e7210ULL, 0x000fc8000791e01dULL,
0x0000000fff0f7210ULL, 0x000fca00007e24ffULL, 0x000000060e197981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081200780cULL, 0x002fe40003f06070ULL, 0x000000060a0e7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000e0e7625ULL, 0x000fca00078e001bULL, 0x0000000e140e7210ULL, 0x000fe40007a3e01dULL,
0x000000070a100810ULL, 0x000fe40007ffe0ffULL, 0x0000000fff0f7210ULL, 0x000fc60000fe44ffULL,
0x00006c0010100625ULL, 0x000fe400078e001bULL, 0x000000060e1b7981ULL, 0x000366000c1e1900ULL,
0x0000001014100210ULL, 0x000fc80007c7e01dULL, 0x00000011ff110210ULL, 0x000fcc0001fe84ffULL,
0x0000000610110981ULL, 0x000366000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff167224ULL, 0x004fe400078e00ffULL, 0x000000ffff107224ULL, 0x000fe400078e000aULL,
0x000000ffff1d7224ULL, 0x020fe400078e0000ULL, 0x000000ffff187224ULL, 0x000fc600078e00ffULL,
0x0000030016007a0cULL, 0x000fe40003f26070ULL, 0x0000000118187810ULL, 0x000fc80007ffe0ffULL,
0x0000000418007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008160e7810ULL, 0x040fe40007ffe0ffULL, 0x00000001160f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000001d00007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000008100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x0000001005127824ULL, 0x000fe400078e00ffULL,
0x00006c000e0e7625ULL, 0x000fe200078e000fULL, 0x0000000c14147812ULL, 0x000fe400078ec0ffULL,
0x00000070121d7812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007b3e01dULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e1d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009160e7810ULL, 0x042fe40007ffe0ffULL,
0x00000002160f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000000d00007209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000009100e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011605ULL,
0x00000010050d7824ULL, 0x000fe400078e00ffULL, 0x00006c000e0e7625ULL, 0x000fe200078e000fULL,
0x0000000c12127812ULL, 0x000fe400078ec0ffULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000e120e7210ULL, 0x000fc80007b3e00dULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e0d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a160e7810ULL, 0x042fe40007ffe0ffULL, 0x00000003160f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000001300007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x0000001005127824ULL, 0x000fe400078e00ffULL,
0x00006c000e0e7625ULL, 0x000fe200078e000fULL, 0x0000000c14147812ULL, 0x000fe400078ec0ffULL,
0x0000007012137812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007b3e013ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e137981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b160e7810ULL, 0x042fe40007ffe0ffULL,
0x00000004160f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001500007209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b100e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011605ULL,
0x0000001005127824ULL, 0x000fe400078e00ffULL, 0x00006c000e0e7625ULL, 0x000fe200078e000fULL,
0x0000000c14147812ULL, 0x000fe400078ec0ffULL, 0x0000007012157812ULL, 0x000fc800078ec0ffULL,
0x0000000e140e7210ULL, 0x000fc80007b3e015ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e157981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c160e7810ULL, 0x042fe40007ffe0ffULL, 0x00000005160f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000001700007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x0000001005127824ULL, 0x000fe400078e00ffULL,
0x00006c000e0e7625ULL, 0x000fe200078e000fULL, 0x0000000c14147812ULL, 0x000fe400078ec0ffULL,
0x0000007012177812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007b3e017ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e177981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d160e7810ULL, 0x042fe40007ffe0ffULL,
0x00000006160f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001900007209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d100e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011605ULL,
0x0000001005127824ULL, 0x000fe400078e00ffULL, 0x00006c000e0e7625ULL, 0x000fe200078e000fULL,
0x0000000c14147812ULL, 0x000fe400078ec0ffULL, 0x0000007012197812ULL, 0x000fc800078ec0ffULL,
0x0000000e140e7210ULL, 0x000fc80007b3e019ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL,
0x000000060e197981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e160e7810ULL, 0x042fe40007ffe0ffULL, 0x00000007160f7810ULL, 0x000fe40007ffe0ffULL,
0x000003000e007a0cULL, 0x000fe40003f26070ULL, 0x000003000f007a0cULL, 0x000fe40003f46070ULL,
0x0000001b00007209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e100e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x0000001005127824ULL, 0x000fe400078e00ffULL,
0x00006c000e0e7625ULL, 0x000fe200078e000fULL, 0x0000000c14147812ULL, 0x000fe400078ec0ffULL,
0x00000070121b7812ULL, 0x000fc800078ec0ffULL, 0x0000000e140e7210ULL, 0x000fc80007b3e01bULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e1b7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f160e7810ULL, 0x002fe40007ffe0ffULL,
0x0000001100007209ULL, 0x000fe40007810000ULL, 0x000003000e007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f100e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011605ULL,
0x0000001005117824ULL, 0x000fe400078e00ffULL, 0x00006c000e0e7625ULL, 0x000fe200078e000fULL,
0x0000000c12127812ULL, 0x000fe400078ec0ffULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000e120e7210ULL, 0x000fc80007a3e011ULL, 0x0000000fff0f7210ULL, 0x000fca0000fe44ffULL,
0x000000060e117981ULL, 0x000368000c1e1900ULL, 0x0000000816167810ULL, 0x000fe40007ffe0ffULL,
0x0000000810107810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000010050d7824ULL, 0x028fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x002fc80000011605ULL, 0x000000700d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010d0d7824ULL, 0x000fca00078e020eULL,
0x000000000d007388ULL, 0x0003e40000000800ULL, 0x000000070500780cULL, 0x040fe20003f04070ULL,
0x0000001005007824ULL, 0x002fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011605ULL,
0x0000000109147824ULL, 0x040fe200078e020aULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000800ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000200009257824ULL, 0x000fe200078e0202ULL, 0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000000001a7805ULL, 0x004fe2000001ff00ULL, 0x00000014060e7211ULL, 0x000fe200078fa8ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000030009007a0cULL, 0x000fe20003f26070ULL,
0x00000001000d7824ULL, 0x000fe200078e020dULL, 0x0000000107007812ULL, 0x000fe200078ec0ffULL,
0x0000000209118824ULL, 0x140fe200078e020cULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000209138824ULL, 0x000fe200078e020cULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000080007077824ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00006c000e0e7625ULL, 0x000fe200078e000fULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fc4000001ff00ULL, 0x0000000211108824ULL, 0x100fe200078e0200ULL,
0x0000002005117810ULL, 0x000fe20007ffe0ffULL, 0x0000000213168824ULL, 0x000fe200078e0200ULL,
0x0000080007007812ULL, 0x000fe200078ec0ffULL, 0x000000010b128824ULL, 0x000fe200078e0214ULL,
0x000000000d2c7984ULL, 0x0002a20000000800ULL, 0x00000080ff138424ULL, 0x000fe400078e00ffULL,
0x00000080ff158424ULL, 0x000fe400078e00ffULL, 0x000004000c0e7825ULL, 0x000fc800078e000eULL,
0x0000000125007824ULL, 0x000fe400078e0200ULL, 0x00006c0012128625ULL, 0x000fc800078e0013ULL,
0x00006c0014148625ULL, 0x000fc800078e0015ULL, 0x0000000810198824ULL, 0x100fe400078e0205ULL,
0x0000000816218824ULL, 0x000fe400078e0205ULL, 0x0000001011107825ULL, 0x000fe200078e000eULL,
0x0000458019198811ULL, 0x000fe400078e20ffULL, 0x0000418021218811ULL, 0x000fe200078e20ffULL,
0x0000001005077824ULL, 0x040fe400078e0200ULL, 0x00000010050e7825ULL, 0x000fc800078e000eULL,
0x0000001005128825ULL, 0x040fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e077faeULL, 0x0007e6000b901c46ULL, 0x0000001005168825ULL, 0x000fe200078e0014ULL,
0x0038000010077faeULL, 0x0009e2000b901c46ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x000000ffff007224ULL, 0x000fe200078e00ffULL, 0x0000000012198faeULL, 0x000be2000b901c46ULL,
0x000000ffff0d7224ULL, 0x002fc400078e00ffULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000016218faeULL, 0x0003e2000b901c46ULL, 0x00000000000e7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff2d7224ULL, 0x000fe400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x010fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x020fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000d3000001947ULL, 0x000fea0003800000ULL, 0x000000ffff007224ULL, 0x004fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x000fca00078e0009ULL, 0x000000022e2f7810ULL, 0x000fc80007ffe0ffULL,
0x000003002f007a0cULL, 0x000fda0003f06070ULL, 0x0000025000000947ULL, 0x000fea0003800000ULL,
0x000000070500780cULL, 0x000fe20003f04070ULL, 0x000000010a367824ULL, 0x100fe200078e022fULL,
0x00000001ff307819ULL, 0x000fe2000001162fULL, 0x000004002f317824ULL, 0x000fe200078e00ffULL,
0x00000020053b7810ULL, 0x000fe20007ffe0ffULL, 0x00000800ff357424ULL, 0x000fe200078e00ffULL,
0x0000000130337812ULL, 0x000fe400078ec0ffULL, 0x0000003606307211ULL, 0x000fe400078fa8ffULL,
0x0000080031347812ULL, 0x000fc600078ec0ffULL, 0x0000000209388824ULL, 0x140fe400078e020cULL,
0x00000002093a8824ULL, 0x000fe400078e020cULL, 0x00006c0030307625ULL, 0x000fc800078e0035ULL,
0x000000010b328824ULL, 0x000fe400078e0236ULL, 0x00000080ff378424ULL, 0x000fe400078e00ffULL,
0x0000000238388824ULL, 0x100fe400078e0233ULL, 0x000000023a3a8824ULL, 0x000fe400078e0233ULL,
0x00006c0032328625ULL, 0x000fc800078e0037ULL, 0x00000080ff358424ULL, 0x000fe400078e00ffULL,
0x0000000125347824ULL, 0x000fe400078e0234ULL, 0x000004000c307825ULL, 0x000fc800078e0030ULL,
0x00006c0036368625ULL, 0x000fc800078e0035ULL, 0x0000001005397824ULL, 0x040fe400078e0234ULL,
0x0000000838388824ULL, 0x000fe400078e0205ULL, 0x0000001005348825ULL, 0x000fc800078e0032ULL,
0x000000083a3a8824ULL, 0x000fe400078e0205ULL, 0x000000103b327825ULL, 0x100fe200078e0030ULL,
0x00004580383b8811ULL, 0x000fe400078e20ffULL, 0x000041803a3d8811ULL, 0x000fe200078e20ffULL,
0x0000001005307825ULL, 0x000fc800078e0030ULL, 0x0000001005368825ULL, 0x000fe200078e0036ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000030397faeULL, 0x0003e8000b901c46ULL,
0x0038000032397faeULL, 0x0003e8000b901c46ULL, 0x00000000343b8faeULL, 0x0003e8000b901c46ULL,
0x00000000363d8faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff357224ULL, 0x002fe200078e002eULL, 0x00000001ff327819ULL, 0x100fe20000011605ULL,
0x0000000209317824ULL, 0x000fe200078e020cULL, 0x00000002ff377819ULL, 0x000fe20000011605ULL,
0x00000040352e7824ULL, 0x000fe200078e00ffULL, 0x0000000c32327812ULL, 0x000fe200078ec0ffULL,
0x0000001005307824ULL, 0x000fe200078e00ffULL, 0x0000000737397812ULL, 0x040fe200078ec0ffULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0x000000802e2e7812ULL, 0x000fca00078ec0ffULL,
0x00000100312e7824ULL, 0x000fe200078e002eULL, 0x0000007030317812ULL, 0x000fe200078ec0ffULL,
0x0000000837307824ULL, 0x000fc600078e00ffULL, 0x0000002e32317210ULL, 0x000fe20007ffe031ULL,
0x0000000837327824ULL, 0x000fe200078e00ffULL, 0x00000037ff2e7212ULL, 0x000fe200078e33ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800031337984ULL, 0x000e620000000800ULL,
0xfffffff83b4a7812ULL, 0x000fe400078ee22eULL, 0x00000008373b7810ULL, 0x000fe20007ffe0ffULL,
0x00458000314e7984ULL, 0x0004e20000000800ULL, 0xfffffff8322e7812ULL, 0x100fe400078ee239ULL,
0x0000000130327812ULL, 0x140fe200078ef639ULL, 0x000000083b407824ULL, 0x040fe200078e00ffULL,
0x0000000230347812ULL, 0x140fe200078ef639ULL, 0x000000083b3e7824ULL, 0x040fe200078e00ffULL,
0x0000000330367812ULL, 0x140fe200078ef639ULL, 0x000000083b317824ULL, 0x004fe200078e00ffULL,
0x0000000430387812ULL, 0x000fc400078ef639ULL, 0x00000005303a7812ULL, 0x140fe400078ef639ULL,
0x0000003bff4c7212ULL, 0x000fe400078e33ffULL, 0x00000006303c7812ULL, 0x000fe200078ef639ULL,
0x0000040035307824ULL, 0x000fe200078e00ffULL, 0xfffffff8314c7812ULL, 0x000fe200078ee24cULL,
0x0000000405317824ULL, 0x000fc600078e00ffULL, 0x0000080030307812ULL, 0x000fe400078ec0ffULL,
0x0000000c31397812ULL, 0x000fe400078ec0ffULL, 0x0000018025317810ULL, 0x000fca0007ffe030ULL,
0x000000104a307824ULL, 0x100fe400078e0231ULL, 0x0000001032327824ULL, 0x000fe400078e0231ULL,
0x0000000139307824ULL, 0x040fe200078e0230ULL, 0x000000332c337221ULL, 0x002fe20000010100ULL,
0x0000000139327824ULL, 0x000fe400078e0232ULL, 0x0000001034347824ULL, 0x100fe200078e0231ULL,
0x3fb8aa3b33357820ULL, 0x000fe20000410000ULL, 0x0000001036367824ULL, 0x100fe200078e0231ULL,
0x000000073b337812ULL, 0x000fe200078ec0ffULL, 0x0000000139347824ULL, 0x040fe200078e0234ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000102e2e7824ULL, 0x000fe200078e0231ULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0x0000000139367824ULL, 0x040fe200078e0236ULL,
0x0000000140427812ULL, 0x000fe200078ef633ULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0x0000001038387824ULL, 0x000fe200078e0231ULL, 0x0000000240447812ULL, 0x140fe200078ef633ULL,
0x00000001392e7824ULL, 0x040fe200078e022eULL, 0x0000000340467812ULL, 0x140fe200078ef633ULL,
0x0000000139387824ULL, 0x000fe200078e0238ULL, 0x0000000440487812ULL, 0x140fe200078ef633ULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x00000005404a7812ULL, 0x000fe200078ef633ULL,
0x000000103a3a7824ULL, 0x000fe200078e0231ULL, 0xfffffff83e3e7812ULL, 0x100fe200078ee233ULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x0000000640407812ULL, 0x000fe200078ef633ULL,
0x0000004e354e7220ULL, 0x008fe20000410000ULL, 0x00000001393a7824ULL, 0x040fe200078e023aULL,
0x0000000030357984ULL, 0x000e620000000800ULL, 0x000000103c3c7824ULL, 0x000fe200078e0231ULL,
0x0000002d4e2d7221ULL, 0x000fe20000010000ULL, 0x000000103e3e7824ULL, 0x000fe200078e0231ULL,
0x000000002e337984ULL, 0x000ea20000000800ULL, 0x00000001393c7824ULL, 0x000fc400078e023cULL,
0x00000001393e7824ULL, 0x000fe200078e023eULL, 0x00001f374e2e7589ULL, 0x000ee200000e0000ULL,
0x0000001042427824ULL, 0x100fe400078e0231ULL, 0x0000001044447824ULL, 0x100fe200078e0231ULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x0000001046467824ULL, 0x100fe400078e0231ULL,
0x0000001048487824ULL, 0x100fe200078e0231ULL, 0x000000003c3c7984ULL, 0x000f620000000800ULL,
0x000000104a4a7824ULL, 0x000fc400078e0231ULL, 0x0000001040407824ULL, 0x100fe200078e0231ULL,
0x000000003e3e7984ULL, 0x000f220000000800ULL, 0x000000104c4c7824ULL, 0x000fe400078e0231ULL,
0x0000000139427824ULL, 0x040fe200078e0242ULL, 0x00001f3b4e307589ULL, 0x00052200000e0000ULL,
0x0000000139467824ULL, 0x040fe400078e0246ULL, 0x00000001394a7824ULL, 0x040fe400078e024aULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x0000000139447824ULL, 0x000fc400078e0244ULL,
0x0000000139407824ULL, 0x040fe200078e0240ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x0000000139487824ULL, 0x040fe400078e0248ULL, 0x00000001394c7824ULL, 0x000fe200078e024cULL,
0x000000004a4a7984ULL, 0x000fe20000000800ULL, 0x00005410ff317816ULL, 0x002fc60000000035ULL,
0x0000000044447984ULL, 0x000e620000000800ULL, 0x00005410ff4e7816ULL, 0x104fe20000000033ULL,
0x0000002e311c7223ULL, 0x088fe2000001001cULL, 0x00007610ff317816ULL, 0x000fe20000000032ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x00007610ff337816ULL, 0x000fe20000000033ULL,
0x0000002e4e2b7223ULL, 0x080fe2000001002bULL, 0x00007610ff4e7816ULL, 0x000fe20000000035ULL,
0x0000002e31287223ULL, 0x080fe20000010028ULL, 0x00007610ff317816ULL, 0x000fe20000000034ULL,
0x0000000048487984ULL, 0x000ea20000000800ULL, 0x0000002e332a7223ULL, 0x080fe2000001002aULL,
0x0000002e4e1b7223ULL, 0x080fe2000001001bULL, 0x00005410ff4e7816ULL, 0x000fe20000000032ULL,
0x0000002e31267223ULL, 0x080fe20000010026ULL, 0x00005410ff317816ULL, 0x000fe20000000036ULL,
0x000000004c4c7984ULL, 0x000ee20000000800ULL, 0x00005410ff327816ULL, 0x000fe20000000034ULL,
0x0000002e4e297223ULL, 0x080fe20000010029ULL, 0x00007610ff367816ULL, 0x000fe20000000036ULL,
0x0000002e31247223ULL, 0x080fe20000010024ULL, 0x00005410ff317816ULL, 0x100fe20000000038ULL,
0x0000002e32277223ULL, 0x080fe20000010027ULL, 0x00007610ff387816ULL, 0x000fe20000000038ULL,
0x0000002e36237223ULL, 0x000fc40000010023ULL, 0x0000002e31227223ULL, 0x080fe20000010022ULL,
0x00005410ff317816ULL, 0x110fe2000000003aULL, 0x0000002e38217223ULL, 0x000fe20000010021ULL,
0x00007610ff3a7816ULL, 0x000fc6000000003aULL, 0x0000002e31207223ULL, 0x080fe20000010020ULL,
0x00005410ff317816ULL, 0x120fe2000000003cULL, 0x0000002e3a1f7223ULL, 0x000fe2000001001fULL,
0x00007610ff3c7816ULL, 0x000fc6000000003cULL, 0x0000002e311e7223ULL, 0x080fe2000001001eULL,
0x00007610ff317816ULL, 0x100fe2000000003eULL, 0x0000002e3c1d7223ULL, 0x000fe2000001001dULL,
0x00005410ff2e7816ULL, 0x000fc6000000003eULL, 0x00000030311a7223ULL, 0x080fe2000001001aULL,
0x00005410ff317816ULL, 0x002fe20000000044ULL, 0x000000302e077223ULL, 0x080fe20000010007ULL,
0x00005410ff2e7816ULL, 0x100fe40000000042ULL, 0x00007610ff427816ULL, 0x000fe20000000042ULL,
0x0000003031127223ULL, 0x080fe20000010012ULL, 0x00007610ff317816ULL, 0x000fe20000000044ULL,
0x000000302e137223ULL, 0x080fe20000010013ULL, 0x00005410ff2e7816ULL, 0x100fe20000000046ULL,
0x0000003042197223ULL, 0x080fe20000010019ULL, 0x00007610ff467816ULL, 0x000fe20000000046ULL,
0x0000003031187223ULL, 0x080fe20000010018ULL, 0x00005410ff317816ULL, 0x004fe20000000048ULL,
0x000000302e117223ULL, 0x080fe20000010011ULL, 0x00005410ff2e7816ULL, 0x100fe2000000004aULL,
0x0000003046177223ULL, 0x080fe20000010017ULL, 0x00007610ff4a7816ULL, 0x000fe2000000004aULL,
0x0000003031107223ULL, 0x080fe20000010010ULL, 0x00007610ff317816ULL, 0x000fe20000000048ULL,
0x000000302e0f7223ULL, 0x080fe2000001000fULL, 0x000000ffff2e7224ULL, 0x000fe200078e002fULL,
0x00005410ff2f7816ULL, 0x000fe20000000040ULL, 0x000000304a157223ULL, 0x080fe20000010015ULL,
0x00005410ff327816ULL, 0x008fe2000000004cULL, 0x0000003031167223ULL, 0x080fe20000010016ULL,
0x000003002e007a0cULL, 0x000fe20003f06070ULL, 0x000000302f0e7223ULL, 0x080fe2000001000eULL,
0x00007610ff2f7816ULL, 0x000fe20000000040ULL, 0x00000030320d7223ULL, 0x000fc8000001000dULL,
0x000000302f147223ULL, 0x000fe20000010014ULL, 0x00007610ff2f7816ULL, 0x000fca000000004cULL,
0x000000302f007223ULL, 0x000fe20000010000ULL, 0xfffff2f000008947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x004e620000000000ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x0000001005067824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011605ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fca00078ec0ffULL,
0x00000001060b7824ULL, 0x000fe200078e0205ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000001005067824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011605ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c050a7812ULL, 0x000fc600078ec0ffULL, 0x0000008009057824ULL, 0x000fc800078e0206ULL,
0x000000010a067824ULL, 0x000fca00078e0205ULL, 0x0049802d06007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x004980000b057984ULL, 0x000ea80000000800ULL, 0x004a00000b067984ULL, 0x002e620000000800ULL,
0x00000005ff057221ULL, 0x004fc80000010000ULL, 0x0000000605057221ULL, 0x002fca0000010000ULL,
0x0180000005067810ULL, 0x000fc80007ffe0ffULL, 0x7f80000006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0600780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0005ULL,
0x0000b3c000257802ULL, 0x000fe40000000f00ULL, 0x000081c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x008fe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000500067308ULL, 0x000e640000001000ULL, 0xbf800000050a7423ULL, 0x002fc80000000006ULL,
0x800000ff0a0b7221ULL, 0x000fc80000010100ULL, 0x0000000b06067223ULL, 0x000fe40000000006ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff257819ULL, 0x002fe40000011605ULL,
0x00000008052d7811ULL, 0x000fe400078ff0ffULL, 0x00000025ff2c7212ULL, 0x000fe200078e33ffULL,
0x00001f25060a7589ULL, 0x000e6200000e0000ULL, 0x0000002dff2e7212ULL, 0x000fe200078e33ffULL,
0x000000082d317824ULL, 0x000fc400078e00ffULL, 0x00001f2d060b7589ULL, 0x000ea200000e0000ULL,
0x00000008252f7824ULL, 0x000fe400078e00ffULL, 0xfffffff831387812ULL, 0x000fc600078ee22eULL,
0xfffffff82f2c7812ULL, 0x000fe400078ee22cULL, 0x0000001038387824ULL, 0x000fc600078e0203ULL,
0x000000102c2c7824ULL, 0x000fe200078e0203ULL, 0x0000002b0a2b7220ULL, 0x042fe20000410000ULL,
0x0000002a0a2a7220ULL, 0x040fe20000410000ULL, 0x000000290a297220ULL, 0x040fe20000410000ULL,
0x000000280a287220ULL, 0x040fe20000410000ULL, 0x000000270a277220ULL, 0x040fe20000410000ULL,
0x000000260a267220ULL, 0x040fe20000410000ULL, 0x000000240a247220ULL, 0x040fe20000410000ULL,
0x000000230a237220ULL, 0x040fe20000410000ULL, 0x000000220a227220ULL, 0x040fe20000410000ULL,
0x000000210a217220ULL, 0x040fe20000410000ULL, 0x000000200a207220ULL, 0x040fe20000410000ULL,
0x0000001f0a1f7220ULL, 0x040fe20000410000ULL, 0x0000001e0a1e7220ULL, 0x040fe20000410000ULL,
0x0000001d0a1d7220ULL, 0x040fe20000410000ULL, 0x0000001c0a1c7220ULL, 0x040fe20000410000ULL,
0x0000001b0a1b7220ULL, 0x000fe20000410000ULL, 0x000000170b0a7220ULL, 0x044fe20000410000ULL,
0x000000160b177220ULL, 0x040fe20000410000ULL, 0x0000000d0b0d7220ULL, 0x040fe20000410000ULL,
0x000000000b007220ULL, 0x040fe20000410000ULL, 0x000000190b067220ULL, 0x040fe20000410000ULL,
0x0000000f0b0f7220ULL, 0x040fe20000410000ULL, 0x000000150b167220ULL, 0x040fe20000410000ULL,
0x000000070b077220ULL, 0x040fe20000410000ULL, 0x0000001a0b1a7220ULL, 0x040fe20000410000ULL,
0x000000130b137220ULL, 0x040fe20000410000ULL, 0x000000120b127220ULL, 0x040fe20000410000ULL,
0x000000180b197220ULL, 0x040fe20000410000ULL, 0x000000110b117220ULL, 0x040fe20000410000ULL,
0x000000100b107220ULL, 0x040fe20000410000ULL, 0x0000000e0b0e7220ULL, 0x040fe20000410000ULL,
0x000000140b157220ULL, 0x000fe20000410000ULL, 0x00000007250b7812ULL, 0x040fe200078ec0ffULL,
0x0000000825147824ULL, 0x000fe200078e00ffULL, 0x0000000d0000723eULL, 0x000fc400000010ffULL,
0x0000000f160f723eULL, 0x000fe400000010ffULL, 0x000000072d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000201f1f723eULL, 0x000fe400000010ffULL, 0x0000001e1d1d723eULL, 0x000fe400000010ffULL,
0x0000001c1b1b723eULL, 0x000fe400000010ffULL, 0x000000071a07723eULL, 0x000fc400000010ffULL,
0x000000010b167812ULL, 0x000fe400078e3cffULL, 0x000000222121723eULL, 0x000fe200000010ffULL,
0x000000082d227824ULL, 0x000fe200078e00ffULL, 0x000000020b187812ULL, 0x000fe200078e3cffULL,
0x0000000825167824ULL, 0x000fe200078e0216ULL, 0x000000030b1a7812ULL, 0x040fe400078e3cffULL,
0x000000040b1c7812ULL, 0x000fe200078e3cffULL, 0x0000000825187824ULL, 0x000fe200078e0218ULL,
0x000000050b1e7812ULL, 0x000fe200078e3cffULL, 0x00000008251a7824ULL, 0x000fe200078e021aULL,
0x000000060b207812ULL, 0x000fe200078e3cffULL, 0x00000004050b7824ULL, 0x000fe200078e00ffULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x00000008251c7824ULL, 0x040fe200078e021cULL,
0xfffffff814147812ULL, 0x000fe200078ee225ULL, 0x00000008251e7824ULL, 0x000fe200078e021eULL,
0x000000010d247812ULL, 0x000fe200078e3cffULL, 0x0000000825207824ULL, 0x000fe200078e0220ULL,
0x000000020d2e7812ULL, 0x040fe200078e3cffULL, 0x0000001014147824ULL, 0x000fe200078e0203ULL,
0x000000030d307812ULL, 0x000fe200078e3cffULL, 0x000000082d247824ULL, 0x000fe200078e0224ULL,
0x000000040d327812ULL, 0x000fe200078e3cffULL, 0x000000082d2e7824ULL, 0x000fe200078e022eULL,
0x000000050d347812ULL, 0x000fe200078e3cffULL, 0x000000082d307824ULL, 0x000fe200078e0230ULL,
0x000000060d367812ULL, 0x000fe200078e3cffULL, 0x000000082d327824ULL, 0x040fe200078e0232ULL,
0xfffffff822227812ULL, 0x000fe200078ee22dULL, 0x000000082d347824ULL, 0x000fe200078e0234ULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000082d367824ULL, 0x000fe200078e0236ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x0000001016167824ULL, 0x100fe200078e0203ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000001018187824ULL, 0x100fe200078e0203ULL,
0x000000110a0a723eULL, 0x000fe200000010ffULL, 0x000000101a1a7824ULL, 0x100fe200078e0203ULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x0000001022227824ULL, 0x000fe200078e0203ULL,
0x000000130606723eULL, 0x000fe200000010ffULL, 0x00000001140d7824ULL, 0x000fe200078e020bULL,
0x000000121912723eULL, 0x000fe200000010ffULL, 0x000000101c1c7824ULL, 0x100fe200078e0203ULL,
0x000000101710723eULL, 0x000fe200000010ffULL, 0x000000101e1e7824ULL, 0x100fe200078e0203ULL,
0x0000002a0d007388ULL, 0x0003e20000000800ULL, 0x0000001020207824ULL, 0x100fe200078e0203ULL,
0x0000000e150e723eULL, 0x000fe200000010ffULL, 0x0000001024247824ULL, 0x000fc400078e0203ULL,
0x000000102e2e7824ULL, 0x100fe400078e0203ULL, 0x0000001030307824ULL, 0x100fe400078e0203ULL,
0x0000001032327824ULL, 0x100fe400078e0203ULL, 0x0000001034347824ULL, 0x100fe400078e0203ULL,
0x0000001036367824ULL, 0x000fe400078e0203ULL, 0x000000010b037824ULL, 0x000fc400078e0216ULL,
0x000000010b117824ULL, 0x040fe400078e0218ULL, 0x000000010b1a7824ULL, 0x040fe200078e021aULL,
0x0000002803007388ULL, 0x0005e20000000800ULL, 0x000000010b1c7824ULL, 0x040fe400078e021cULL,
0x000000010b1e7824ULL, 0x040fe200078e021eULL, 0x0000002611007388ULL, 0x000fe20000000800ULL,
0x000000010b207824ULL, 0x040fe400078e0220ULL, 0x000000010b2c7824ULL, 0x040fe200078e022cULL,
0x000000231a007388ULL, 0x000fe20000000800ULL, 0x000000010b227824ULL, 0x000fc400078e0222ULL,
0x000000010b137824ULL, 0x040fe200078e0224ULL, 0x000000211c007388ULL, 0x000fe20000000800ULL,
0x000000010b0d7824ULL, 0x042fe400078e022eULL, 0x000000010b257824ULL, 0x040fe200078e0230ULL,
0x0000001f1e007388ULL, 0x000fe20000000800ULL, 0x000000010b277824ULL, 0x040fe400078e0232ULL,
0x000000010b297824ULL, 0x040fe200078e0238ULL, 0x0000001d20007388ULL, 0x000fe20000000800ULL,
0x000000010b347824ULL, 0x000fc400078e0234ULL, 0x000000010b0b7824ULL, 0x000fe200078e0236ULL,
0x0000001b2c007388ULL, 0x000fe20000000800ULL, 0x0000000108157824ULL, 0x000fc600078e0205ULL,
0x0000000722007388ULL, 0x000fe20000000800ULL, 0x0000001015037824ULL, 0x004fc600078e0202ULL,
0x0000000613007388ULL, 0x000fe80000000800ULL, 0x000000120d007388ULL, 0x000fe80000000800ULL,
0x0000000a25007388ULL, 0x0003e80000000800ULL, 0x0000001027007388ULL, 0x000fe80000000800ULL,
0x0000000f34007388ULL, 0x000fe20000000800ULL, 0x00000004040a723eULL, 0x002fc600000010ffULL,
0x0000000e0b007388ULL, 0x000fe80000000800ULL, 0x0000000029007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000003147984ULL, 0x000e680000000c00ULL,
0x00040000031c7984ULL, 0x000ea80000000c00ULL, 0x0008000003187984ULL, 0x000ee80000000c00ULL,
0x000c000003207984ULL, 0x000f220000000c00ULL, 0x3f803f800a177831ULL, 0x002fc40000200017ULL,
0x3f803f800a167831ULL, 0x040fe40000200016ULL, 0x3f803f800a157831ULL, 0x040fe40000200015ULL,
0x3f803f800a147831ULL, 0x040fe40000200014ULL, 0x3f803f800a1f7831ULL, 0x044fe4000020001fULL,
0x3f803f800a1e7831ULL, 0x040fe4000020001eULL, 0x3f803f800a1d7831ULL, 0x000fc4000020001dULL,
0x3f803f800a1c7831ULL, 0x000fe4000020001cULL, 0x3f803f8017177831ULL, 0x008fe4000020001bULL,
0x3f803f8016167831ULL, 0x000fe4000020001aULL, 0x3f803f8015157831ULL, 0x000fe40000200019ULL,
0x3f803f8014147831ULL, 0x000fe40000200018ULL, 0x3f803f801f1f7831ULL, 0x010fc40000200023ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200022ULL, 0x0000001403007388ULL, 0x0003e20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200021ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200020ULL,
0x0004001c03007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000020050e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000047919ULL, 0x000ee20000002600ULL,
0x00000003ff067819ULL, 0x100fe20000011605ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x00000003ff037819ULL, 0x102fe2000001160eULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000706087812ULL, 0x100fe200078e4805ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000703007812ULL, 0x100fe200078e480eULL, 0x000000080c147824ULL, 0x000fe200078e00ffULL,
0x0ffffff808097812ULL, 0x000fe200078ef805ULL, 0x000000080c0f7824ULL, 0x000fe200078e00ffULL,
0x0ffffff800077812ULL, 0x000fc600078ef80eULL, 0x0000001009007824ULL, 0x100fe400078e0202ULL,
0x0000001007077824ULL, 0x000fc600078e0202ULL, 0x0000000000087984ULL, 0x0003680000000c00ULL,
0x0000000007107984ULL, 0x0005620000000c00ULL, 0x00000008040d7824ULL, 0x048fe400078e00ffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x010fe4000f8e023fULL,
0xfffffff80d027812ULL, 0x000fc400078ee206ULL, 0xfffffff804037812ULL, 0x000fe400078ee203ULL,
0x00000004020d7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403067c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff007224ULL, 0x002fe200000e06ffULL, 0x00005a000d027a11ULL, 0x040fe200078040ffULL,
0x000000ffff077224ULL, 0x004fe200008e06ffULL, 0x00005a0006047a11ULL, 0x000fe400078240ffULL,
0x00005b000d037a11ULL, 0x000fe400000f4400ULL, 0xfffffff8140d7812ULL, 0x000fe400078ee205ULL,
0x00005b0006057a11ULL, 0x000fe400008f4407ULL, 0xfffffff80f077812ULL, 0x000fe200078ee20eULL,
0x000000100d027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x020fe8000c101d06ULL, 0x0000001004007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000454077824ULL, 0x000fe400078e0200ULL,
0xffffffffff6d7424ULL, 0x000fc600078e00ffULL, 0x000000040700720cULL, 0x000fda0003f06070ULL,
0x00000002640e8824ULL, 0x000fc800078e00ffULL, 0x000064000e0e8a24ULL, 0x000fc800078e0207ULL,
0x000060000e0e8625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060e6d8981ULL, 0x000ea2000c1e1900ULL, 0x0000000154067810ULL, 0x000fe20007ffe0ffULL,
0x0000004000097824ULL, 0x000fe400078e00ffULL, 0x01360000ff0c7f8cULL, 0x000e62000c80043fULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x0000004013067824ULL, 0x000fe400078e00ffULL,
0x00000040120b7824ULL, 0x000fe400078e00ffULL, 0x000000066d217224ULL, 0x004fd000078e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x102fe20000011602ULL,
0x0000010054087824ULL, 0x000fe200078e0209ULL, 0x00000003ff177819ULL, 0x100fe40000011602ULL,
0x0000003010277812ULL, 0x000fe200078ec0ffULL, 0x00000040120a7824ULL, 0x000fe200078e0225ULL,
0x00000008030f7217ULL, 0x000fe40007800000ULL, 0x0000000317177812ULL, 0x000fe400078e4802ULL,
0x000000080a0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000010f087824ULL, 0x000fe200078e0a08ULL,
0x000000100a0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000e210e7210ULL, 0x040fe40007f3e0ffULL,
0x0000000a21167210ULL, 0x040fe40007f1e0ffULL, 0x0000000f210f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x00005e000e1d7a11ULL, 0x000fe200078240ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e0016147a11ULL, 0x000fe200078040ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00005f000e1f7a11ULL, 0x000fc400008f441fULL,
0x00005e000f157a11ULL, 0x000fe400078440ffULL, 0x000000180a0e7810ULL, 0x000fe40007ffe0ffULL,
0x000000082500720cULL, 0x000fe40003f66070ULL, 0x00005f0016167a11ULL, 0x000fe400000f4411ULL,
0x00005f000f1c7a11ULL, 0x000fe400010f441cULL, 0x0000000e21127210ULL, 0x000fc40007f3e0ffULL,
0x0000100000197811ULL, 0x000fe400078e68ffULL, 0x0ffffffc17027812ULL, 0x000fe200078ef802ULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x000000200a0f7810ULL, 0x000fe40007ffe0ffULL,
0x00000014270e7210ULL, 0x000fe20007f1e0ffULL, 0x00000010021b7824ULL, 0x000fe200078e0219ULL,
0x0000000f211e7210ULL, 0x000fe40007f5e0ffULL, 0x000000280a107810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0616ULL, 0x000000300a117810ULL, 0x000fc40007ffe0ffULL,
0x000000380a0a7810ULL, 0x000fe40007ffe0ffULL, 0x00005e0012147a11ULL, 0x000fe200078840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1b7faeULL, 0x0003e2000d901c46ULL,
0x00000010211a7210ULL, 0x040fe40007fde0ffULL, 0x0000001121187210ULL, 0x040fe40007f1e0ffULL,
0x0000000a21167210ULL, 0x000fe40007f3e0ffULL, 0x0000000825217810ULL, 0x000fc40007ffe0ffULL,
0x000000271d107210ULL, 0x080fe40007f7e0ffULL, 0x00005f0012027a11ULL, 0x000fe200020f4413ULL,
0x00000004210a7824ULL, 0x000fe200078e00ffULL, 0x00000010251d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e061fULL, 0x0000002715127210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff1b7224ULL, 0x002fe200010e06ffULL, 0x0000001825237810ULL, 0x000fe20007ffe0ffULL,
0x000000041d0e7824ULL, 0x000fe200078e00ffULL, 0x0000002714147210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200020e061cULL, 0x000000082100720cULL, 0x080fe20003f66070ULL,
0x0000000423207824ULL, 0x000fe200078e00ffULL, 0x000000081d00720cULL, 0x080fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200028e0602ULL, 0x000000082300720cULL, 0x000fc40003fa6070ULL,
0xfffffffc0a027812ULL, 0x100fe400078ee217ULL, 0x00005e001e1c7a11ULL, 0x000fe400078440ffULL,
0xfffffffc0e0a7812ULL, 0x000fe200078ee217ULL, 0x00000010020f7824ULL, 0x000fe200078e0219ULL,
0xfffffffc200e7812ULL, 0x000fe400078ee217ULL, 0x00005f001e1e7a11ULL, 0x000fe200010f441bULL,
0x000000100a1b7824ULL, 0x100fe200078e0219ULL, 0x00000020251f7810ULL, 0x040fe20007ffe0ffULL,
0x000000100e1d7824ULL, 0x000fe200078e0219ULL, 0x0000002825217810ULL, 0x040fe20007ffe0ffULL,
0x00000000100f7faeULL, 0x0003e2000d901c46ULL, 0x0000003025237810ULL, 0x000fe20007ffe0ffULL,
0x000000041f027824ULL, 0x000fe200078e00ffULL, 0x0000003825257810ULL, 0x000fe20007ffe0ffULL,
0x00000000121b7faeULL, 0x0005e2000e101c46ULL, 0x000000081f00720cULL, 0x080fe20003f46070ULL,
0x00000004230a7824ULL, 0x000fe200078e00ffULL, 0x000000082100720cULL, 0x080fe20003f66070ULL,
0x00000000141d7faeULL, 0x0007e2000e901c46ULL, 0x000000082300720cULL, 0x080fe20003f86070ULL,
0x00000004250e7824ULL, 0x040fe200078e00ffULL, 0x000000082500720cULL, 0x000fe20003fa6070ULL,
0x0000000421087824ULL, 0x000fe200078e00ffULL, 0xfffffffc02027812ULL, 0x100fe200078ee217ULL,
0x000000ffff0f7224ULL, 0x002fe200030e06ffULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee217ULL,
0x000000ffff137224ULL, 0x004fe200000e06ffULL, 0xfffffffc08087812ULL, 0x100fe200078ee217ULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee217ULL,
0x0000001002177824ULL, 0x100fe200078e0219ULL, 0x00005e001a107a11ULL, 0x000fe200078c40ffULL,
0x00000010081b7824ULL, 0x100fe200078e0219ULL, 0x00005e0018127a11ULL, 0x000fe200078040ffULL,
0x000000100a1d7824ULL, 0x008fe200078e0219ULL, 0x00005f001a0a7a11ULL, 0x000fe200030f440fULL,
0x000000100e197824ULL, 0x000fe200078e0219ULL, 0x000000271c0e7210ULL, 0x000fc40007fde0ffULL,
0x0000002710107210ULL, 0x080fe40007f3e0ffULL, 0x00005f0018087a11ULL, 0x000fe200000f4413ULL,
0x000000ffff0f7224ULL, 0x000fe200030e061eULL, 0x00005e0016147a11ULL, 0x000fe400078c40ffULL,
0x0000002712127210ULL, 0x080fe40007f1e0ffULL, 0x00005f0016027a11ULL, 0x000fe200030f4411ULL,
0x000000ffff117224ULL, 0x000fe200008e060aULL, 0x0000002714147210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0608ULL, 0x000000000e177faeULL, 0x0003e6000d101c46ULL,
0x000000ffff157224ULL, 0x000fe200008e0602ULL, 0x00000000101b7faeULL, 0x0003e8000d901c46ULL,
0x00000000121d7faeULL, 0x0003e8000e101c46ULL, 0x0000000014197faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000b02087211ULL, 0x042fe400078ff0ffULL,
0x00000008021c7811ULL, 0x000fc400078ff0ffULL, 0x0000000821087210ULL, 0x000fe40007f1e0ffULL,
0x00000010020a7811ULL, 0x040fe400078ff0ffULL, 0x0000001802127811ULL, 0x000fe200078ff0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e0008227a11ULL, 0x000fe200078040ffULL,
0x000000010b0e7824ULL, 0x000fe200078e020aULL, 0x0000002002147811ULL, 0x040fe400078ff0ffULL,
0x0000002802167811ULL, 0x000fc400078ff0ffULL, 0x0000003002187811ULL, 0x040fe200078ff0ffULL,
0x000000010b117824ULL, 0x040fe200078e0214ULL, 0x00000038021a7811ULL, 0x000fe200078ff0ffULL,
0x000000010b137824ULL, 0x040fe200078e0216ULL, 0x00005f0008247a11ULL, 0x000fe200000f440fULL,
0x000000010b087824ULL, 0x040fe200078e021cULL, 0x00000003ff1f7819ULL, 0x000fe20000011602ULL,
0x000000010b0f7824ULL, 0x000fe200078e0212ULL, 0x0000000e211d7210ULL, 0x000fe20007fbe0ffULL,
0x000000010b157824ULL, 0x000fe200078e0218ULL, 0x0000000821207210ULL, 0x000fe20007fde0ffULL,
0x000000010b177824ULL, 0x000fe200078e021aULL, 0x0000000f211b7210ULL, 0x040fe20007f1e0ffULL,
0x000000040a087824ULL, 0x000fe200078e00ffULL, 0x0000001121197210ULL, 0x040fe20007f3e0ffULL,
0x00000004120a7824ULL, 0x000fe200078e00ffULL, 0x0000001321137210ULL, 0x040fe20007f5e0ffULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x0000001521157210ULL, 0x040fe20007f7e0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x0000001721177210ULL, 0x000fe20007f9e0ffULL,
0x00000004140e7824ULL, 0x000fe200078e00ffULL, 0x000000031f217812ULL, 0x100fe200078e4802ULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x00001000002b7811ULL, 0x000fe200078e68ffULL,
0x000000041a127824ULL, 0x000fe200078e00ffULL, 0xfffffffc08087812ULL, 0x000fe200078ee221ULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x0ffffffc21147812ULL, 0x000fc400078ef802ULL,
0xfffffffc0a0a7812ULL, 0x100fe400078ee221ULL, 0xfffffffc1c027812ULL, 0x000fe200078ee221ULL,
0x00000010142f7824ULL, 0x100fe200078e022bULL, 0x00005e00201e7a11ULL, 0x000fe200078c40ffULL,
0x000000100a237824ULL, 0x000fe200078e022bULL, 0xfffffffc18117812ULL, 0x100fe200078ee221ULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0xfffffffc0e0e7812ULL, 0x100fe400078ee221ULL,
0xfffffffc160f7812ULL, 0x000fe200078ee221ULL, 0x0000001011297824ULL, 0x000fe200078e022bULL,
0xfffffffc12127812ULL, 0x000fe200078ee221ULL, 0x0000001008217824ULL, 0x000fe200078e022bULL,
0x00005f0020207a11ULL, 0x000fe200030f441fULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e001b147a11ULL, 0x000fe200078040ffULL, 0x00000010021f7824ULL, 0x100fe200078e022bULL,
0x00005e001d117a11ULL, 0x000fe200078a40ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x00000030102d7812ULL, 0x000fe200078ec0ffULL, 0x000000100e257824ULL, 0x100fe200078e022bULL,
0x00005e0019167a11ULL, 0x000fe200078240ffULL, 0x000000100f277824ULL, 0x100fe200078e022bULL,
0x00005f001b1b7a11ULL, 0x000fe200000f4408ULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005f001d1d7a11ULL, 0x000fe200028f440aULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x000000222d0e7210ULL, 0x000fe20007f1e0ffULL, 0x00000010122b7824ULL, 0x000fe200078e022bULL,
0x00005f0019197a11ULL, 0x000fe200008f4402ULL, 0x000000ffff027224ULL, 0x000fe200020e06ffULL,
0x00005e0013187a11ULL, 0x000fe200078240ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0624ULL,
0x00005e00151a7a11ULL, 0x000fc400078440ffULL, 0x00005e00171c7a11ULL, 0x000fe400078640ffULL,
0x00005f00130a7a11ULL, 0x000fe200008f440aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2f7faeULL, 0x0003e2000b901c46ULL, 0x0000001e2d107210ULL, 0x000fe40007f1e0ffULL,
0x00005f0015087a11ULL, 0x000fe400010f4408ULL, 0x000000112d127210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0620ULL, 0x00005f0017027a11ULL, 0x000fc400018f4402ULL,
0x000000142d147210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e061dULL,
0x000000162d167210ULL, 0x040fe20007f7e0ffULL, 0x00000000101f7faeULL, 0x0003e2000b901c46ULL,
0x000000182d187210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200010e061bULL,
0x0000001a2d1a7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200018e0619ULL,
0x0000001c2d1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff197224ULL, 0x000fe200020e060aULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1b7224ULL, 0x000fc400028e0608ULL,
0x000000ffff1d7224ULL, 0x000fe200000e0602ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e8000b901c46ULL, 0x0000000018277faeULL, 0x0003e8000b901c46ULL,
0x000000001a297faeULL, 0x0003e8000b901c46ULL, 0x000000001c2b7faeULL, 0x0003e4000b901c46ULL,
0x01360400ff0f7984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x800000000fff7812ULL, 0x002fc6000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200087305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000080000735dULL, 0x004fe20003800000ULL,
0x01360400ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000055400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000640064647a24ULL, 0x000fe200078e02ffULL, 0x0001368800567811ULL, 0x040fe200078e18ffULL,
0x0000002000087824ULL, 0x000fe200078e00ffULL, 0xffffffff05577810ULL, 0x000fe40007ffe0ffULL,
0x00000100540a7824ULL, 0x008fe200078e0209ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000000a0300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x014fea0003800000ULL,
0x00000001540c7810ULL, 0x000fe20007ffe0ffULL, 0x0000006d066d7224ULL, 0x000fc600078e02ffULL,
0x000000050c00720cULL, 0x000fda0003f06070ULL, 0x000006a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1b7819ULL, 0x002fe40000011602ULL, 0x00000003026f7812ULL, 0x000fe400078ec0ffULL,
0x000000101b247810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0c7824ULL, 0x000fe200078e021bULL,
0x000000081b1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000181b267810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0224ULL, 0x0000000c6d0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000041d1e7824ULL, 0x000fe200078e00ffULL, 0x000000201b287810ULL, 0x000fe20007ffe0ffULL,
0x000000010b107824ULL, 0x000fe200078e0226ULL, 0x0000000e6d117210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x00005e000c127a11ULL, 0x040fe200078240ffULL,
0x000000010b147824ULL, 0x000fe200078e0228ULL, 0x000000106d107210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x00005f000c137a11ULL, 0x000fe200008f440dULL,
0x000000010b0c7824ULL, 0x000fe200078e021dULL, 0x00005e0011167a11ULL, 0x000fe200078640ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e06ffULL, 0x00005e0010187a11ULL, 0x000fc400078840ffULL,
0x0000000c6d157210ULL, 0x040fe40007f5e0ffULL, 0x000000146d0c7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0011177a11ULL, 0x000fe200018f441aULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x00000003ff117819ULL, 0x000fe20000011602ULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x00005e000c0e7a11ULL, 0x000fe400078240ffULL, 0x000000281b297810ULL, 0x000fc40007ffe0ffULL,
0x00005e0015147a11ULL, 0x000fe400078440ffULL, 0x00005f0010197a11ULL, 0x000fe200020f440fULL,
0x000000010b107824ULL, 0x000fe200078e0229ULL, 0x000000381b2b7810ULL, 0x000fe40007ffe0ffULL,
0x00005f000c0f7a11ULL, 0x000fe200008f440dULL, 0x00000001030c7824ULL, 0x000fe200078e0a0aULL,
0x000000301b2a7810ULL, 0x000fe40007ffe0ffULL, 0x00000002110d7212ULL, 0x000fc400078e3cffULL,
0x00005f0015157a11ULL, 0x000fe200010f441cULL, 0x000000010b1c7824ULL, 0x000fe200078e022bULL,
0x000000030d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b1a7824ULL, 0x000fe200078e022aULL,
0x0000000c1b00720cULL, 0x080fe40003f46070ULL, 0x0000000c1d00720cULL, 0x000fe40003f26070ULL,
0x000000106d1b7210ULL, 0x000fe40007f9e0ffULL, 0x0000200000237811ULL, 0x000fc400078e68ffULL,
0x000000046f217812ULL, 0x000fe200078efcffULL, 0x000000ffff227224ULL, 0x000fe200020e06ffULL,
0xfffffffc1e1e7812ULL, 0x000fe400078ee20dULL, 0x0ffffffc0d6c7812ULL, 0x000fe200078ef802ULL,
0x0000001021127825ULL, 0x000fe200078e0012ULL, 0x0000001c6d107210ULL, 0x040fe40007f7e0ffULL,
0x0000001a6d1d7210ULL, 0x000fe20007fbe0ffULL, 0x000000101e277824ULL, 0x100fe200078e0223ULL,
0x00005e001b1a7a11ULL, 0x000fe200078840ffULL, 0x000000106c257824ULL, 0x000fe200078e0223ULL,
0x0000000c2b00720cULL, 0x080fe20003fc6070ULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x00005e00101e7a11ULL, 0x040fe200078640ffULL, 0x000000ffff207224ULL, 0x000fe200028e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078a40ffULL, 0x0000001021147825ULL, 0x000fe200078e0014ULL,
0x00005f00101f7a11ULL, 0x000fe200018f441fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012257faeULL, 0x0003e2000d101c46ULL, 0x00005f001b1b7a11ULL, 0x000fe200020f4422ULL,
0x0000000426107824ULL, 0x000fe200078e00ffULL, 0x00005f001d1d7a11ULL, 0x000fe200028f4420ULL,
0x0000000014277faeULL, 0x0005e2000c901c46ULL, 0x0000000c2800720cULL, 0x0c0fe20003f66070ULL,
0x0000000428287824ULL, 0x000fe200078e00ffULL, 0x0000000c2400720cULL, 0x080fe20003f26070ULL,
0x0000000429207824ULL, 0x000fe200078e00ffULL, 0x0000000c2600720cULL, 0x080fe20003f46070ULL,
0x000000042b227824ULL, 0x000fe200078e00ffULL, 0x0000000c2900720cULL, 0x080fe20003f86070ULL,
0x00000010210e7825ULL, 0x000fe200078e000eULL, 0x0000000c2a00720cULL, 0x000fc40003fa6070ULL,
0xfffffffc28127812ULL, 0x102fe200078ee20dULL, 0x00000004240c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc20147812ULL, 0x104fe200078ee20dULL, 0x000000042a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc10107812ULL, 0x000fe200078ee20dULL, 0x0000001012297824ULL, 0x000fe200078e0223ULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee20dULL, 0x00000010142b7824ULL, 0x000fe200078e0223ULL,
0xfffffffc2a207812ULL, 0x000fe200078ee20dULL, 0x0000001021127825ULL, 0x000fe200078e0016ULL,
0xfffffffc22227812ULL, 0x000fc600078ee20dULL, 0x000000100c257824ULL, 0x100fe400078e0223ULL,
0x0000001010277824ULL, 0x000fe400078e0223ULL, 0x0000001021147825ULL, 0x040fe200078e0018ULL,
0x0000000012257faeULL, 0x0003e6000c901c46ULL, 0x0000001021167825ULL, 0x040fe200078e001aULL,
0x0000000014277faeULL, 0x0003e6000d101c46ULL, 0x00000010202d7824ULL, 0x000fe200078e0223ULL,
0x000000000e297faeULL, 0x0003e2000d901c46ULL, 0x0000001021187825ULL, 0x000fc600078e001cULL,
0x00000000162b7faeULL, 0x0003e2000e101c46ULL, 0x0000001022237824ULL, 0x000fe400078e0223ULL,
0x00000010211a7825ULL, 0x000fe200078e001eULL, 0x00000000182d7faeULL, 0x0003e8000e901c46ULL,
0x000000001a237faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000000802227811ULL, 0x042fe400078ff0ffULL, 0x0000001002247811ULL, 0x000fc400078ff0ffULL,
0x0000000b020c7211ULL, 0x040fe200078ff0ffULL, 0x000000010b0e7824ULL, 0x040fe200078e0222ULL,
0x0000001802267811ULL, 0x000fe200078ff0ffULL, 0x000000010b107824ULL, 0x000fe200078e0224ULL,
0x0000006d0c117210ULL, 0x080fe20007f3e0ffULL, 0x0000000422227824ULL, 0x000fe200078e00ffULL,
0x0000006d0e0f7210ULL, 0x080fe40007f5e0ffULL, 0x0000006d100c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x0000002002287811ULL, 0x000fe200078ff0ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005e000f147a11ULL, 0x000fe200078440ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x00005e000c0e7a11ULL, 0x000fc400078640ffULL,
0x00005e0011127a11ULL, 0x000fe400078240ffULL, 0x00000028022a7811ULL, 0x040fe400078ff0ffULL,
0x00000030022c7811ULL, 0x000fe400078ff0ffULL, 0x00005f000f157a11ULL, 0x000fe200010f4410ULL,
0x000000010b107824ULL, 0x040fe200078e0228ULL, 0x00005f000c0f7a11ULL, 0x000fe200018f440dULL,
0x000000010b0c7824ULL, 0x000fe200078e0226ULL, 0x00005f0011137a11ULL, 0x000fe200008f4416ULL,
0x000000010b167824ULL, 0x040fe200078e022aULL, 0x0000006d10197210ULL, 0x080fe20007f7e0ffULL,
0x000000010b187824ULL, 0x000fe200078e022cULL, 0x0000006d0c177210ULL, 0x080fe20007f5e0ffULL,
0x0000000426267824ULL, 0x000fe200078e00ffULL, 0x0000006d16107210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x0000006d180c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff207224ULL, 0x000fe200010e06ffULL, 0x00005e0019187a11ULL, 0x000fe200078640ffULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x00005e00101a7a11ULL, 0x000fe200078840ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x00005e000c1c7a11ULL, 0x000fe200078240ffULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x00005f00101b7a11ULL, 0x000fc400020f4411ULL,
0x00005f000c1d7a11ULL, 0x000fe400008f440dULL, 0x00000003ff117819ULL, 0x000fe40000011602ULL,
0x00000038020c7811ULL, 0x000fe400078ff0ffULL, 0x00000002110d7212ULL, 0x000fe400078e3cffULL,
0x00005e0017167a11ULL, 0x000fe200078440ffULL, 0x000000010b107824ULL, 0x000fe200078e020cULL,
0x00005f0019197a11ULL, 0x000fe200018f441eULL, 0x000000040c1e7824ULL, 0x000fe200078e00ffULL,
0x000000030d0d7812ULL, 0x000fc400078ec0ffULL, 0x00005f0017177a11ULL, 0x000fe200010f4420ULL,
0x0000000424207824ULL, 0x000fe200078e00ffULL, 0x00000003026f7812ULL, 0x000fe200078ec0ffULL,
0x0000000428247824ULL, 0x000fe200078e00ffULL, 0x0000006d100c7210ULL, 0x000fe20007f3e0ffULL,
0x000000042c287824ULL, 0x000fe200078e00ffULL, 0xfffffffc22107812ULL, 0x000fe400078ee20dULL,
0x00002000002d7811ULL, 0x000fe200078e68ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e06ffULL,
0x000000046f2f7812ULL, 0x000fc400078efcffULL, 0xfffffffc26227812ULL, 0x000fe200078ee20dULL,
0x0000001010217824ULL, 0x000fe200078e022dULL, 0x0ffffffc0d6c7812ULL, 0x000fe200078ef802ULL,
0x000000102f127825ULL, 0x040fe200078e0012ULL, 0xfffffffc2a267812ULL, 0x100fe400078ee20dULL,
0xfffffffc20207812ULL, 0x000fe200078ee20dULL, 0x000000106c317824ULL, 0x000fe200078e022dULL,
0xfffffffc1e2a7812ULL, 0x000fe200078ee20dULL, 0x000000102f147825ULL, 0x000fe200078e0014ULL,
0x00005e000c1e7a11ULL, 0x000fc400078240ffULL, 0xfffffffc24247812ULL, 0x000fe200078ee20dULL,
0x0000001020237824ULL, 0x000fe200078e022dULL, 0xfffffffc28287812ULL, 0x000fe200078ee20dULL,
0x000000102f0e7825ULL, 0x040fe200078e000eULL, 0x00005f000c1f7a11ULL, 0x000fe200008f441fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012317faeULL, 0x0003e4000b901c46ULL,
0x0000001022257824ULL, 0x000fe400078e022dULL, 0x000000102f167825ULL, 0x040fe200078e0016ULL,
0x0000000014217faeULL, 0x0003e6000b901c46ULL, 0x0000001024277824ULL, 0x000fe200078e022dULL,
0x000000000e237faeULL, 0x0003e2000b901c46ULL, 0x000000102f187825ULL, 0x000fc600078e0018ULL,
0x0000000016257faeULL, 0x0003e2000b901c46ULL, 0x0000001026297824ULL, 0x000fe400078e022dULL,
0x000000102f1a7825ULL, 0x040fe200078e001aULL, 0x0000000018277faeULL, 0x0003e6000b901c46ULL,
0x00000010282b7824ULL, 0x000fe200078e022dULL, 0x000000001a297faeULL, 0x0003e2000b901c46ULL,
0x000000102f1c7825ULL, 0x000fc800078e001cULL, 0x000000102a2d7824ULL, 0x000fe200078e022dULL,
0x000000001c2b7faeULL, 0x0003e2000b901c46ULL, 0x000000102f1e7825ULL, 0x000fca00078e001eULL,
0x000000001e2d7faeULL, 0x0003e4000b901c46ULL, 0x00000004ff0c7819ULL, 0x000fe20000011602ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000007020f7812ULL, 0x002fe200078ec0ffULL,
0x0000200000717824ULL, 0x000fe200078e00ffULL, 0x000000020c1c7810ULL, 0x040fe20007ffe0ffULL,
0x000000080c107824ULL, 0x000fc600078e00ffULL, 0x0000100071557810ULL, 0x000fe40007ffe0ffULL,
0xfffffff810107812ULL, 0x000fe400078ee20fULL, 0x000000080f0f7812ULL, 0x000fe400078ef802ULL,
0x0000002010157810ULL, 0x040fe20007ffe0ffULL, 0x0000000410137824ULL, 0x040fe200078e00ffULL,
0x0000001010147810ULL, 0x040fe40007ffe0ffULL, 0x0000003010177810ULL, 0x000fe20007ffe0ffULL,
0x00000004151b7824ULL, 0x000fe200078e00ffULL, 0x000000070c0e7812ULL, 0x000fe200078e780fULL,
0x0000000414197824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011610ULL,
0x00000004171d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011614ULL,
0x000000100f0e7824ULL, 0x000fe200078e020eULL, 0x00000001ff167819ULL, 0x000fe20000011615ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000001ff157819ULL, 0x000fe20000011617ULL,
0x000000100e147824ULL, 0x000fe200078e00ffULL, 0x0000000312127812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000310107812ULL, 0x000fe400078ec0ffULL,
0x0000000316187812ULL, 0x000fe400078ec0ffULL, 0x00000003151a7812ULL, 0x000fe400078ec0ffULL,
0x00000001120e7812ULL, 0x100fe200078e7811ULL, 0x000000001414783bULL, 0x000fe20000000200ULL,
0x0000000110467812ULL, 0x000fc400078e7811ULL, 0x0000000118447812ULL, 0x100fe400078e7811ULL,
0x000000011a487812ULL, 0x000fe400078e7811ULL, 0x000000130e0e7212ULL, 0x000fe400078efcffULL,
0x0000001946467212ULL, 0x000fe400078efcffULL, 0x0000001b44447212ULL, 0x000fe200078efcffULL,
0x000000100e6e7824ULL, 0x100fe200078e0255ULL, 0x0000001d48487212ULL, 0x000fe200078efcffULL,
0x00000010466b7824ULL, 0x100fe200078e0255ULL, 0x0000000111117812ULL, 0x000fe200078ec0ffULL,
0x00000010446a7824ULL, 0x100fe200078e0255ULL, 0x000000006e38783bULL, 0x000e620000000200ULL,
0x0000001048697824ULL, 0x000fe200078e0255ULL, 0x0000000212727812ULL, 0x000fc400078e1e11ULL,
0x000000006b34783bULL, 0x000ea20000000200ULL, 0x000000071c127812ULL, 0x000fe400078e780fULL,
0x0000000210427812ULL, 0x100fe200078e1e11ULL, 0x000000006a30783bULL, 0x000ee20000000200ULL,
0x0000000218407812ULL, 0x100fe200078e1e11ULL, 0x000000100f127824ULL, 0x000fe200078e0212ULL,
0x000000021a707812ULL, 0x000fe200078e1e11ULL, 0x00000000693c783bULL, 0x000f220000000200ULL,
0x0000001372727212ULL, 0x000fe200078efcffULL, 0x0000001012287824ULL, 0x000fe200078e00ffULL,
0x0000001942427212ULL, 0x000fc400078efcffULL, 0x0000001b40407212ULL, 0x000fe200078efcffULL,
0x0000001072687824ULL, 0x100fe200078e0255ULL, 0x0000001d70707212ULL, 0x000fe200078efcffULL,
0x0000001042677824ULL, 0x100fe200078e0255ULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x0000001040667824ULL, 0x100fe400078e0255ULL, 0x0000001070657824ULL, 0x000fe200078e0255ULL,
0x00000000685c783bULL, 0x000f680000000200ULL, 0x000000006718783bULL, 0x000f280000000200ULL,
0x000000006620783bULL, 0x000f280000000200ULL, 0x000000006510783bULL, 0x000f220000000200ULL,
0x00000038142c723cULL, 0x042ff000000418ffULL, 0x000000341458723cULL, 0x044ff000000418ffULL,
0x00000030141c723cULL, 0x048ff000000418ffULL, 0x0000003a1438723cULL, 0x040ff000000418ffULL,
0x000000361434723cULL, 0x040ff000000418ffULL, 0x000000321430723cULL, 0x040ff000000418ffULL,
0x0000003c1424723cULL, 0x050ff000000418ffULL, 0x0000003e1414723cULL, 0x000ff000000418ffULL,
0x0000005c282c723cULL, 0x060ff0000004182cULL, 0x000000182858723cULL, 0x040ff00000041858ULL,
0x00000020281c723cULL, 0x040ff0000004181cULL, 0x0000005e285c723cULL, 0x040ff00000041838ULL,
0x0000001a2818723cULL, 0x040ff00000041834ULL, 0x000000222820723cULL, 0x040ff00000041830ULL,
0x000000102824723cULL, 0x040ff00000041824ULL, 0x000000122828723cULL, 0x000fe20000041814ULL,
0x0000064000008947ULL, 0x000fee0003800000ULL, 0x00000002ff177819ULL, 0x000fe40000011602ULL,
0x000000086f3b7812ULL, 0x000fc400078efcffULL, 0x0000000817387810ULL, 0x000fe20007ffe0ffULL,
0x000000010b107824ULL, 0x000fe200078e0217ULL, 0x00000010173c7810ULL, 0x040fe40007ffe0ffULL,
0x00000018173e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b127824ULL, 0x000fe200078e0238ULL,
0x000000106d117210ULL, 0x000fe20007f5e0ffULL, 0x000000010b147824ULL, 0x000fe200078e023cULL,
0x0000002017417810ULL, 0x000fe20007ffe0ffULL, 0x000000010b167824ULL, 0x000fe200078e023eULL,
0x000000126d137210ULL, 0x000fc40007f7e0ffULL, 0x000000146d337210ULL, 0x040fe40007f9e0ffULL,
0x000000166d357210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x00005e0013147a11ULL, 0x000fe200078640ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005e0011307a11ULL, 0x000fe200078440ffULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x00005f0013157a11ULL, 0x000fe200018f4432ULL, 0x000000ffff367224ULL, 0x000fe200008e06ffULL,
0x00005e0033127a11ULL, 0x000fe200078840ffULL, 0x000000010b327824ULL, 0x000fe200078e0241ULL,
0x00005e0035107a11ULL, 0x000fe200078240ffULL, 0x000000103b147825ULL, 0x000fe200078e0014ULL,
0x0000002817437810ULL, 0x000fc40007ffe0ffULL, 0x0000003017457810ULL, 0x000fe40007ffe0ffULL,
0x00005f0011317a11ULL, 0x000fe200010f4416ULL, 0x0000000103167824ULL, 0x000fe200078e0a0aULL,
0x00005f0033137a11ULL, 0x000fe200020f4434ULL, 0x000000010b347824ULL, 0x000fe200078e0243ULL,
0x00005f0035117a11ULL, 0x000fe200008f4436ULL, 0x000000010b367824ULL, 0x000fe200078e0245ULL,
0x000000326d337210ULL, 0x000fe20007f5e0ffULL, 0x000000103b307825ULL, 0x000fe200078e0030ULL,
0x000000161700720cULL, 0x000fc40003f26070ULL, 0x0000003817477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x000000346d177210ULL, 0x000fe20007f7e0ffULL,
0x000000103b127825ULL, 0x000fe200078e0012ULL, 0x000000366d397210ULL, 0x000fe40007f9e0ffULL,
0x00005e0033367a11ULL, 0x000fe200078440ffULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x00005e0017347a11ULL, 0x000fe200078640ffULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f0033377a11ULL, 0x000fe200010f443aULL, 0x000000010b3a7824ULL, 0x000fe200078e0247ULL,
0x00005e0039327a11ULL, 0x000fe200078840ffULL, 0x000000103b107825ULL, 0x000fe200078e0010ULL,
0x000000163800720cULL, 0x000fc40003f46070ULL, 0x00005f0017357a11ULL, 0x000fe200018f444aULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x00005f0039337a11ULL, 0x000fe200020f444cULL,
0x000000106c177824ULL, 0x000fe200078e0255ULL, 0x0000003a6d397210ULL, 0x000fe20007f7e0ffULL,
0x000000103b367825ULL, 0x000fe200078e0036ULL, 0xfffffffc383a7812ULL, 0x000fe400078ee20dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030177faeULL, 0x0003e2000c901c46ULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x00005e0039387a11ULL, 0x040fe200078640ffULL,
0x000000103a3d7824ULL, 0x000fe200078e0255ULL, 0x000000163c00720cULL, 0x0c0fe20003f26070ULL,
0x000000043c3a7824ULL, 0x000fe200078e00ffULL, 0x00005f0039397a11ULL, 0x000fe200018f444aULL,
0x00000004473c7824ULL, 0x000fe200078e00ffULL, 0x00000000143d7faeULL, 0x0005e2000d101c46ULL,
0x000000163e00720cULL, 0x000fe20003f46070ULL, 0x000000103b347825ULL, 0x000fe200078e0034ULL,
0xfffffffc3a3a7812ULL, 0x000fc400078ee20dULL, 0x000000164100720cULL, 0x080fe20003f66070ULL,
0x0000000443307824ULL, 0x042fe200078e00ffULL, 0x000000164300720cULL, 0x080fe20003f86070ULL,
0x000000103a3f7824ULL, 0x000fe200078e0255ULL, 0x000000164500720cULL, 0x0c0fe20003fa6070ULL,
0x00000004453a7824ULL, 0x000fe200078e00ffULL, 0x000000164700720cULL, 0x000fe20003fc6070ULL,
0x000000043e147824ULL, 0x004fe200078e00ffULL, 0xfffffffc30307812ULL, 0x100fe200078ee20dULL,
0x0000000441167824ULL, 0x000fe200078e00ffULL, 0xfffffffc3a3a7812ULL, 0x100fe200078ee20dULL,
0x00000000123f7faeULL, 0x0003e2000c901c46ULL, 0xfffffffc14147812ULL, 0x000fe200078ee20dULL,
0x000000103b327825ULL, 0x000fe200078e0032ULL, 0xfffffffc16167812ULL, 0x000fc400078ee20dULL,
0xfffffffc3c3c7812ULL, 0x000fe200078ee20dULL, 0x000000103b387825ULL, 0x000fc800078e0038ULL,
0x0000001016157824ULL, 0x100fe400078e0255ULL, 0x0000001014137824ULL, 0x102fe400078e0255ULL,
0x0000001030317824ULL, 0x100fe400078e0255ULL, 0x000000103a3b7824ULL, 0x100fe200078e0255ULL,
0x0000000010137faeULL, 0x0003e2000d101c46ULL, 0x000000103c3d7824ULL, 0x000fc600078e0255ULL,
0x0000000036157faeULL, 0x0003e8000d901c46ULL, 0x0000000034317faeULL, 0x0003e8000e101c46ULL,
0x00000000323b7faeULL, 0x0003e8000e901c46ULL, 0x00000000383d7faeULL, 0x0003e2000f101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000802167811ULL, 0x040fe400078ff0ffULL,
0x0000000b02107211ULL, 0x000fc400078ff0ffULL, 0x0000001002367811ULL, 0x000fe200078ff0ffULL,
0x000000010b127824ULL, 0x000fe200078e0216ULL, 0x0000006d10117210ULL, 0x080fe20007f3e0ffULL,
0x0000000416527824ULL, 0x000fe200078e00ffULL, 0x00000018023c7811ULL, 0x000fe400078ff0ffULL,
0x0000006d12137210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e0011147a11ULL, 0x000fe400078240ffULL, 0x00000020023e7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e0013107a11ULL, 0x000fc400078440ffULL,
0x00005f0011157a11ULL, 0x000fe200008f4412ULL, 0x000000010b127824ULL, 0x000fe200078e0236ULL,
0x00005f0013117a11ULL, 0x000fe200010f4430ULL, 0x000000010b307824ULL, 0x040fe200078e023cULL,
0x00000028024a7811ULL, 0x000fe200078ff0ffULL, 0x000000010b387824ULL, 0x040fe200078e023eULL,
0x0000006d12137210ULL, 0x080fe40007f3e0ffULL, 0x0000006d30177210ULL, 0x080fe20007f5e0ffULL,
0x000000010b3a7824ULL, 0x000fe200078e024aULL, 0x0000006d38387210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x00005e0013307a11ULL, 0x000fe200078240ffULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e0017127a11ULL, 0x000fc400078440ffULL,
0x00005f0013317a11ULL, 0x000fe400008f4432ULL, 0x00005f0017137a11ULL, 0x000fe200010f4434ULL,
0x000000ffff177224ULL, 0x000fe200018e06ffULL, 0x0000006d3a3a7210ULL, 0x000fe40007f9e0ffULL,
0x00005e0038347a11ULL, 0x000fe400078240ffULL, 0x00000030024c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff337224ULL, 0x000fe200020e06ffULL, 0x00005f0038357a11ULL, 0x000fe200008f4417ULL,
0x000000106c177824ULL, 0x000fe200078e0255ULL, 0x00005e003a327a11ULL, 0x000fe200078440ffULL,
0x000000010b387824ULL, 0x000fe200078e024cULL, 0x00000038024e7811ULL, 0x000fc400078ff0ffULL,
0x00005f003a337a11ULL, 0x000fe400010f4433ULL, 0x0000006d38377210ULL, 0x080fe20007f3e0ffULL,
0x000000010b3a7824ULL, 0x000fe200078e024eULL, 0x000000086f3f7812ULL, 0x000fe200078efcffULL,
0x000000044e4e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000006d3a3b7210ULL, 0x000fe20007f5e0ffULL, 0x00000004363a7824ULL, 0x000fe200078e00ffULL,
0x00005e0037387a11ULL, 0x000fe200078240ffULL, 0x000000103f147825ULL, 0x000fc600078e0014ULL,
0x00005f0037397a11ULL, 0x000fe200008f4416ULL, 0x000000ffff507224ULL, 0x000fe200010e06ffULL,
0x00005e003b367a11ULL, 0x000fe200078440ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000b901c46ULL, 0xfffffffc52167812ULL, 0x000fe200078ee20dULL,
0x000000103f107825ULL, 0x000fe200078e0010ULL, 0xfffffffc3a3a7812ULL, 0x000fe400078ee20dULL,
0x00005f003b377a11ULL, 0x000fe200010f4450ULL, 0x00000010163b7824ULL, 0x100fe400078e0255ULL,
0x000000103a3d7824ULL, 0x000fc400078e0255ULL, 0x000000043e167824ULL, 0x000fe200078e00ffULL,
0x00000000103b7faeULL, 0x0005e2000b901c46ULL, 0x000000043c147824ULL, 0x002fe400078e00ffULL,
0x000000044a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc16167812ULL, 0x100fe200078ee20dULL,
0x000000044c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc14147812ULL, 0x000fe200078ee20dULL,
0x000000103f307825ULL, 0x040fe200078e0030ULL, 0xfffffffc3a3a7812ULL, 0x100fe400078ee20dULL,
0xfffffffc3c3c7812ULL, 0x000fe200078ee20dULL, 0x000000103f127825ULL, 0x000fe200078e0012ULL,
0xfffffffc4e107812ULL, 0x004fe200078ee20dULL, 0x00000000303d7faeULL, 0x0003e4000b901c46ULL,
0x0000001014117824ULL, 0x000fc400078e0255ULL, 0x000000103f347825ULL, 0x000fc600078e0034ULL,
0x0000000012117faeULL, 0x0005e2000b901c46ULL, 0x0000001016157824ULL, 0x000fe400078e0255ULL,
0x000000103f327825ULL, 0x000fc600078e0032ULL, 0x0000000034157faeULL, 0x0005e2000b901c46ULL,
0x000000103a317824ULL, 0x002fe400078e0255ULL, 0x000000103f387825ULL, 0x000fc600078e0038ULL,
0x0000000032317faeULL, 0x0005e2000b901c46ULL, 0x000000103c3b7824ULL, 0x000fe400078e0255ULL,
0x000000103f367825ULL, 0x000fc600078e0036ULL, 0x00000000383b7faeULL, 0x0005e2000b901c46ULL,
0x00000010103d7824ULL, 0x000fca00078e0255ULL, 0x00000000363d7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000040c107810ULL, 0x002fe40007ffe0ffULL,
0x0000200071717810ULL, 0x000fe40007ffe0ffULL, 0x0000000710107812ULL, 0x000fe400078e780fULL,
0x000000060c127810ULL, 0x004fe20007ffe0ffULL, 0x000000100e167824ULL, 0x000fe400078e0271ULL,
0x000000100f107824ULL, 0x000fe200078e0210ULL, 0x0000000712127812ULL, 0x000fe200078e780fULL,
0x00000010460e7824ULL, 0x000fc400078e0271ULL, 0x0000001010457824ULL, 0x000fe400078e00ffULL,
0x0000001044107824ULL, 0x100fe400078e0271ULL, 0x0000001048117824ULL, 0x100fe400078e0271ULL,
0x000000100f137824ULL, 0x000fe400078e0212ULL, 0x0000001072127824ULL, 0x000fe200078e0271ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001660783bULL, 0x000fe20000000200ULL,
0x0000001013307824ULL, 0x000fe400078e00ffULL, 0x0000001042137824ULL, 0x100fe200078e0271ULL,
0x000000004544783bULL, 0x000e620000000200ULL, 0x0000001040147824ULL, 0x100fe400078e0271ULL,
0x0000001070157824ULL, 0x000fe200078e0271ULL, 0x000000000e50783bULL, 0x000ea80000000200ULL,
0x00000000104c783bULL, 0x000ee80000000200ULL, 0x000000001148783bULL, 0x000f280000000200ULL,
0x000000001240783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000f680000000200ULL,
0x00000000133c783bULL, 0x000ee80000000200ULL, 0x000000001438783bULL, 0x000ee80000000200ULL,
0x000000001534783bULL, 0x000ee20000000200ULL, 0x00000060442c723cULL, 0x042ff0000004182cULL,
0x00000062445c723cULL, 0x040ff0000004185cULL, 0x000000504458723cULL, 0x044ff00000041858ULL,
0x000000524418723cULL, 0x040ff00000041818ULL, 0x0000004c441c723cULL, 0x048ff0000004181cULL,
0x0000004e4420723cULL, 0x040ff00000041820ULL, 0x000000484424723cULL, 0x050ff00000041824ULL,
0x0000004a4428723cULL, 0x000ff00000041828ULL, 0x00000040302c723cULL, 0x060ff0000004182cULL,
0x00000042305c723cULL, 0x040ff0000004185cULL, 0x0000003c3058723cULL, 0x040ff00000041858ULL,
0x0000003e3018723cULL, 0x040ff00000041818ULL, 0x00000038301c723cULL, 0x040ff0000004181cULL,
0x0000003a3020723cULL, 0x040ff00000041820ULL, 0x000000343024723cULL, 0x040ff00000041824ULL,
0x000000363030723cULL, 0x000fe20000041828ULL, 0x0000064000008947ULL, 0x000fee0003800000ULL,
0x00000002ff347819ULL, 0x000fe20000011602ULL, 0x0000000103407824ULL, 0x000fe200078e0a0aULL,
0x0000000c6f6f7812ULL, 0x000fe200078efcffULL, 0x000000106c417824ULL, 0x000fe200078e0271ULL,
0x0000001034437810ULL, 0x040fe20007ffe0ffULL, 0x000000010b287824ULL, 0x000fe200078e0234ULL,
0x0000000834427810ULL, 0x000fc40007ffe0ffULL, 0x0000001834447810ULL, 0x040fe20007ffe0ffULL,
0x000000010b367824ULL, 0x000fe200078e0243ULL, 0x000000286d297210ULL, 0x000fe20007f1e0ffULL,
0x000000010b2a7824ULL, 0x000fe200078e0242ULL, 0x0000002034457810ULL, 0x000fe40007ffe0ffULL,
0x000000366d357210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x0000002a6d2b7210ULL, 0x000fe40007f3e0ffULL, 0x00005e00293c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e0035287a11ULL, 0x000fe200078440ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005f00293d7a11ULL, 0x000fe200000f4436ULL,
0x000000010b367824ULL, 0x000fe200078e0244ULL, 0x00005e002b2a7a11ULL, 0x000fc400078240ffULL,
0x0000002834477810ULL, 0x040fe20007ffe0ffULL, 0x000000106f3c7825ULL, 0x000fe200078e003cULL,
0x0000003034497810ULL, 0x040fe40007ffe0ffULL, 0x00000038344b7810ULL, 0x040fe40007ffe0ffULL,
0x00005f002b2b7a11ULL, 0x000fe200008f4438ULL, 0x000000010b387824ULL, 0x040fe200078e0245ULL,
0x000000403400720cULL, 0x000fe20003f06070ULL, 0x000000010b3e7824ULL, 0x000fe200078e0249ULL,
0x00005f0035297a11ULL, 0x000fe200010f443aULL, 0x000000010b3a7824ULL, 0x000fe200078e0247ULL,
0x000000366d347210ULL, 0x000fe20007f3e0ffULL, 0x000000010b467824ULL, 0x000fe200078e024bULL,
0x000000386d397210ULL, 0x000fe20007f9e0ffULL, 0x000000106f2a7825ULL, 0x000fe200078e002aULL,
0x00005e0034367a11ULL, 0x000fc400078640ffULL, 0x0000003a6d3b7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff357224ULL, 0x000fe200008e06ffULL, 0x0000003e6d4a7210ULL, 0x040fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c417faeULL, 0x0003e2000c101c46ULL,
0x000000466d6d7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x00005f0034377a11ULL, 0x000fe200018f4435ULL, 0x000000ffff357224ULL, 0x000fe200010e06ffULL,
0x00005e00393e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff487224ULL, 0x000fe200028e06ffULL,
0x00005e004a387a11ULL, 0x000fe200078440ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078840ffULL, 0x000000106f287825ULL, 0x000fe200078e0028ULL,
0x00005e006d347a11ULL, 0x000fc400078240ffULL, 0x00005f00393f7a11ULL, 0x000fe200018f4446ULL,
0x0000000445467824ULL, 0x000fe200078e00ffULL, 0x00005f004a397a11ULL, 0x000fe200010f4435ULL,
0x00000004494a7824ULL, 0x000fe200078e00ffULL, 0x00005f003b3b7a11ULL, 0x000fe200020f4448ULL,
0x0000000447487824ULL, 0x000fe200078e00ffULL, 0x00005f006d357a11ULL, 0x000fe200008f444cULL,
0x000000044b4c7824ULL, 0x000fe200078e00ffULL, 0x000000404200720cULL, 0x0c0fe20003f06070ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x000000404300720cULL, 0x080fe20003f26070ULL,
0x000000106f367825ULL, 0x000fe200078e0036ULL, 0x000000404400720cULL, 0x000fc40003f46070ULL,
0x000000404500720cULL, 0x080fe20003f66070ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x000000404700720cULL, 0x080fe20003f86070ULL, 0x000000106f3e7825ULL, 0x000fe200078e003eULL,
0x000000404900720cULL, 0x080fe40003fa6070ULL, 0x000000404b00720cULL, 0x000fe20003fc6070ULL,
0x0000000443407824ULL, 0x000fe200078e00ffULL, 0xfffffffc423c7812ULL, 0x002fe200078ee20dULL,
0x000000106f3a7825ULL, 0x000fe200078e003aULL, 0xfffffffc44427812ULL, 0x000fc400078ee20dULL,
0xfffffffc40407812ULL, 0x000fe200078ee20dULL, 0x000000103c3d7824ULL, 0x000fe200078e0271ULL,
0xfffffffc46447812ULL, 0x000fe200078ee20dULL, 0x0000001042437824ULL, 0x000fe200078e0271ULL,
0xfffffffc48467812ULL, 0x000fe200078ee20dULL, 0x0000001040417824ULL, 0x000fe200078e0271ULL,
0xfffffffc4a487812ULL, 0x000fe200078ee20dULL, 0x0000001044457824ULL, 0x000fe200078e0271ULL,
0xfffffffc4c4a7812ULL, 0x000fe200078ee20dULL, 0x0000001046477824ULL, 0x100fe200078e0271ULL,
0x000000002a3d7faeULL, 0x0003e2000c101c46ULL, 0x0000001048497824ULL, 0x000fc400078e0271ULL,
0x000000106f387825ULL, 0x040fe200078e0038ULL, 0x0000000028417faeULL, 0x0003e6000c901c46ULL,
0x000000104a717824ULL, 0x000fe200078e0271ULL, 0x0000000036437faeULL, 0x0003e2000d101c46ULL,
0x000000106f347825ULL, 0x000fc600078e0034ULL, 0x000000003e457faeULL, 0x0003e8000d901c46ULL,
0x000000003a477faeULL, 0x0003e8000e101c46ULL, 0x0000000038497faeULL, 0x0003e8000e901c46ULL,
0x0000000034717faeULL, 0x0003e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000b02287211ULL, 0x000fe200078ff0ffULL, 0x000000106c4d7824ULL, 0x000fe200078e0271ULL,
0x0000000802347811ULL, 0x000fc400078ff0ffULL, 0x0000006d28297210ULL, 0x080fe40007f1e0ffULL,
0x0000001002387811ULL, 0x040fe400078ff0ffULL, 0x00000018023a7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00005e0029287a11ULL, 0x000fe200078040ffULL,
0x000000010b367824ULL, 0x040fe200078e0238ULL, 0x00000020023e7811ULL, 0x000fe200078ff0ffULL,
0x000000010b3c7824ULL, 0x000fe200078e023aULL, 0x00005f0029297a11ULL, 0x000fe200000f442aULL,
0x000000010b2a7824ULL, 0x040fe200078e0234ULL, 0x0000006d36357210ULL, 0x080fe20007f3e0ffULL,
0x0000000434347824ULL, 0x000fe200078e00ffULL, 0x0000002802427811ULL, 0x000fe200078ff0ffULL,
0x000000010b407824ULL, 0x000fe200078e023eULL, 0x0000006d2a2b7210ULL, 0x000fc40007f7e0ffULL,
0x0000003002467811ULL, 0x040fe200078ff0ffULL, 0x000000010b447824ULL, 0x000fe200078e0242ULL,
0x00005e002b2a7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x00000038024a7811ULL, 0x000fe200078ff0ffULL, 0x000000010b487824ULL, 0x000fe200078e0246ULL,
0x0000006d3c3c7210ULL, 0x080fe40007f1e0ffULL, 0x00005f002b2b7a11ULL, 0x000fe200030f4436ULL,
0x0000000438367824ULL, 0x000fe200078e00ffULL, 0xfffffffc34347812ULL, 0x100fe200078ee20dULL,
0x000000043a387824ULL, 0x000fe200078e00ffULL, 0x0000006d40407210ULL, 0x080fe20007f5e0ffULL,
0x000000043e3a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc36367812ULL, 0x100fe200078ee20dULL,
0x00000004423e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc38387812ULL, 0x000fe200078ee20dULL,
0x000000010b4c7824ULL, 0x000fe200078e024aULL, 0x0000006d44447210ULL, 0x080fe20007f7e0ffULL,
0x0000001036437824ULL, 0x000fe200078e0271ULL, 0xfffffffc3e3e7812ULL, 0x000fe200078ee20dULL,
0x0000001038457824ULL, 0x100fe200078e0271ULL, 0x0000006d48487210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0035367a11ULL, 0x040fe200078240ffULL,
0x0000001034417824ULL, 0x000fe200078e0271ULL, 0xfffffffc3a3a7812ULL, 0x000fe200078ee20dULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x00005e003c347a11ULL, 0x000fe200078040ffULL,
0x000000103e497824ULL, 0x000fe200078e0271ULL, 0x0000006d4c4c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200018e06ffULL, 0x00005f0035377a11ULL, 0x000fe200008f4438ULL,
0x0000000446427824ULL, 0x000fe200078e00ffULL, 0x00005f003c357a11ULL, 0x000fe200000f4439ULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0x0000000c6f6f7812ULL, 0x000fe200078efcffULL,
0x000000103a477824ULL, 0x000fe200078e0271ULL, 0x00005e00403c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff4f7224ULL, 0x000fe200028e06ffULL, 0x00005e00443e7a11ULL, 0x000fe200078240ffULL,
0x000000044a467824ULL, 0x000fe200078e00ffULL, 0x00005e00483a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff517224ULL, 0x000fe200020e06ffULL, 0x00005e004c387a11ULL, 0x000fe200078640ffULL,
0x000000106f287825ULL, 0x000fe200078e0028ULL, 0x00005f00403d7a11ULL, 0x000fc400000f4439ULL,
0x00005f00443f7a11ULL, 0x000fe200008f443bULL, 0x000000106f2a7825ULL, 0x040fe200078e002aULL,
0xfffffffc42427812ULL, 0x000fe200078ee20dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000284d7faeULL, 0x0003e2000b901c46ULL, 0x00005f00483b7a11ULL, 0x000fe200010f444fULL,
0x000000106f367825ULL, 0x040fe200078e0036ULL, 0xfffffffc46467812ULL, 0x000fe200078ee20dULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x00005f004c397a11ULL, 0x000fe200018f4451ULL,
0x000000106f347825ULL, 0x040fe400078e0034ULL, 0x0000000036437faeULL, 0x0003e4000b901c46ULL,
0x000000106f3c7825ULL, 0x000fc400078e003cULL, 0x0000000034457faeULL, 0x0003e4000b901c46ULL,
0x000000106f3e7825ULL, 0x040fe400078e003eULL, 0x000000003c477faeULL, 0x0003e4000b901c46ULL,
0x00000010424b7824ULL, 0x000fe400078e0271ULL, 0x000000106f3a7825ULL, 0x040fe200078e003aULL,
0x000000003e497faeULL, 0x0003e6000b901c46ULL, 0x0000001046717824ULL, 0x000fe200078e0271ULL,
0x000000003a4b7faeULL, 0x0003e2000b901c46ULL, 0x000000106f387825ULL, 0x000fca00078e0038ULL,
0x0000000038717faeULL, 0x0003e4000b901c46ULL, 0x00000004ff357424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000030035077a24ULL, 0x000fca00078e0207ULL, 0x000000040700720cULL, 0x000fda0003f06070ULL,
0x0000000264348824ULL, 0x000fe200078e0207ULL, 0x000000080c287810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600034348625ULL, 0x000fe200078e0035ULL,
0x0000000728287812ULL, 0x000fe200078e780fULL, 0x000000006b60783bULL, 0x000fe80000000200ULL,
0x00000006346d8981ULL, 0x0002a2000c1e1900ULL, 0x000000100f287824ULL, 0x000fc600078e0228ULL,
0x000000006a50783bULL, 0x000fe20000000200ULL, 0x0000001028487824ULL, 0x000fc600078e00ffULL,
0x000000006e28783bULL, 0x000fe20000000200ULL, 0x0000000a0c347810ULL, 0x002fc60007ffe0ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000000734347812ULL, 0x000fc600078e780fULL,
0x00000000694c783bULL, 0x000ee40000000200ULL, 0x000000100f347824ULL, 0x000fe400078e0234ULL,
0x000000006844783bULL, 0x000fe40000000200ULL, 0x0000001034347824ULL, 0x000fe400078e00ffULL,
0x000000006740783bULL, 0x000fe80000000200ULL, 0x00000000663c783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000f280000000200ULL, 0x000000006538783bULL, 0x000f620000000200ULL,
0x00000028482c723cULL, 0x042ff0000004182cULL, 0x0000002a485c723cULL, 0x040ff0000004185cULL,
0x000000604858723cULL, 0x040fee0000041858ULL, 0x0000030054607a10ULL, 0x000fe20007ffe0ffULL,
0x000000624818723cULL, 0x000fe60000041818ULL, 0x0000000160287810ULL, 0x000fc80007ffe0ffULL,
0x000000052800720cULL, 0x000fe20003f06070ULL, 0x00000050481c723cULL, 0x040ff0000004181cULL,
0x000000524820723cULL, 0x040ff00000041820ULL, 0x0000004c4824723cULL, 0x048ff00000041824ULL,
0x0000004e4830723cULL, 0x000ff00000041830ULL, 0x00000044342c723cULL, 0x050ff0000004182cULL,
0x00000046345c723cULL, 0x040ff0000004185cULL, 0x000000403458723cULL, 0x040ff00000041858ULL,
0x000000423418723cULL, 0x040ff00000041818ULL, 0x0000003c341c723cULL, 0x040ff0000004181cULL,
0x0000003e3420723cULL, 0x040ff00000041820ULL, 0x000000383424723cULL, 0x060ff00000041824ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x000000066d3c7224ULL, 0x004fe200078e02ffULL,
0x000006e000008947ULL, 0x000fec0003800000ULL, 0x00000002ff3d7819ULL, 0x000fe20000011602ULL,
0x0000010060287824ULL, 0x000fc400078e0209ULL, 0x00000010023e7824ULL, 0x000fe200078e00ffULL,
0x000000083d3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b3b7824ULL, 0x000fe200078e023dULL,
0x0000002803297217ULL, 0x000fe40007800000ULL, 0x000000103d407810ULL, 0x000fe20007ffe0ffULL,
0x000000010b2b7824ULL, 0x000fe200078e023fULL, 0x000000183d417810ULL, 0x000fe20007ffe0ffULL,
0x0000000129367824ULL, 0x000fe200078e0a28ULL, 0x0000003c3b3b7210ULL, 0x080fe20007f1e0ffULL,
0x000000010b357824ULL, 0x000fe200078e0240ULL, 0x0000003c2b2b7210ULL, 0x080fe20007f3e0ffULL,
0x000000010b297824ULL, 0x000fe200078e0241ULL, 0x000000303e3e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x00005e003b397a11ULL, 0x000fe200078040ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x0000003c35357210ULL, 0x000fc40007f5e0ffULL,
0x0000003c29387210ULL, 0x000fe40007f7e0ffULL, 0x00005f003b3b7a11ULL, 0x000fe200000f4428ULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078040ffULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0x00005e0035347a11ULL, 0x000fe400078240ffULL,
0x00005e0038377a11ULL, 0x000fe400078440ffULL, 0x00005f002b2b7a11ULL, 0x000fe200000f443aULL,
0x000000043f3a7824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fc400008f4428ULL,
0x00005f0038387a11ULL, 0x000fe400010f4429ULL, 0x0000003e39287210ULL, 0x000fe40007f7e0ffULL,
0x000000364000720cULL, 0x0c0fe20003f46070ULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0xfffffffc3a3a7812ULL, 0x000fe200078ee20dULL, 0x000000ffff297224ULL, 0x000fe200018e063bULL,
0x000000363d00720cULL, 0x040fe40003f06070ULL, 0xfffffffc40407812ULL, 0x000fe200078ee20dULL,
0x000000103a3b7824ULL, 0x000fe200078e0255ULL, 0x000000203d3a7810ULL, 0x000fc40007ffe0ffULL,
0x000000363f00720cULL, 0x000fe20003f26070ULL, 0x00000010403f7824ULL, 0x000fe200078e0255ULL,
0x0000003e2a2a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b397824ULL, 0x000fe200078e023aULL,
0x000000283d407810ULL, 0x040fe40007ffe0ffULL, 0x000000303d427810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028177faeULL, 0x0003e2000c101c46ULL,
0x000000383d437810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e062bULL,
0x0000003c39397210ULL, 0x000fe20007f1e0ffULL, 0x000000010b3d7824ULL, 0x000fe200078e0240ULL,
0x0000003e34347210ULL, 0x000fc40007f9e0ffULL, 0x000000002a3b7faeULL, 0x0005e2000c901c46ULL,
0x000000364200720cULL, 0x080fe40003f26070ULL, 0x000000ffff357224ULL, 0x000fe200020e0635ULL,
0x000000364100720cULL, 0x000fe20003f86070ULL, 0x000000ffff287224ULL, 0x002fe200000e06ffULL,
0x0000003c3d177210ULL, 0x000fe40007fbe0ffULL, 0x00000000343f7faeULL, 0x0003e2000d101c46ULL,
0x000000363a00720cULL, 0x0c0fe20003f66070ULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0x000000364000720cULL, 0x080fe20003f46070ULL, 0x000000ffff2a7224ULL, 0x004fe200028e06ffULL,
0x00005e00392b7a11ULL, 0x000fe200078c40ffULL, 0x000000010b3b7824ULL, 0x000fe200078e0243ULL,
0x000000364300720cULL, 0x000fc40003f06070ULL, 0x00005f0039397a11ULL, 0x000fe400030f4428ULL,
0x0000003e37287210ULL, 0x000fe20007fbe0ffULL, 0x000000010b377824ULL, 0x000fe200078e0242ULL,
0x00005e0017347a11ULL, 0x042fe200078c40ffULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0xfffffffc3a3a7812ULL, 0x000fe200078ee20dULL, 0x000000ffff297224ULL, 0x000fe200028e0638ULL,
0x00005f0017357a11ULL, 0x000fe200030f442aULL, 0x0000000441387824ULL, 0x000fe200078e00ffULL,
0x0000003c37377210ULL, 0x080fe20007fde0ffULL, 0x000000103a3d7824ULL, 0x000fe200078e0255ULL,
0x0000003c3b177210ULL, 0x000fe20007fbe0ffULL, 0x00000004403c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc38387812ULL, 0x100fe200078ee20dULL, 0x000000ffff2a7224ULL, 0x000fe200030e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078c40ffULL, 0x0000000443407824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c3c7812ULL, 0x000fe200078ee20dULL, 0x00000010383b7824ULL, 0x000fe200078e0255ULL,
0xfffffffc42387812ULL, 0x000fc400078ee20dULL, 0x00005f0037377a11ULL, 0x000fe200030f442aULL,
0x000000103c3f7824ULL, 0x100fe200078e0255ULL, 0x0000003e2b2a7210ULL, 0x080fe20007fde0ffULL,
0x0000001038417824ULL, 0x000fe200078e0255ULL, 0xfffffffc40407812ULL, 0x000fe200078ee20dULL,
0x00000000283b7faeULL, 0x0003e2000e101c46ULL, 0x000000ffff387224ULL, 0x000fe200028e06ffULL,
0x00005e00170d7a11ULL, 0x000fe200078840ffULL, 0x000000ffff2b7224ULL, 0x000fe200030e0639ULL,
0x0000003e34347210ULL, 0x080fe20007fde0ffULL, 0x0000001040557824ULL, 0x000fe200078e0255ULL,
0x0000003e36367210ULL, 0x000fc40007fbe0ffULL, 0x00005f0017177a11ULL, 0x000fe200020f4438ULL,
0x000000ffff357224ULL, 0x000fe200030e0635ULL, 0x000000002a3d7faeULL, 0x0005e2000d901c46ULL,
0x000000ffff377224ULL, 0x000fe200028e0637ULL, 0x0000003e0d287210ULL, 0x002fe40007f9e0ffULL,
0x00000000343f7faeULL, 0x0005e6000d101c46ULL, 0x000000ffff297224ULL, 0x000fe200020e0617ULL,
0x0000000036417faeULL, 0x0005e8000c901c46ULL, 0x0000000028557faeULL, 0x0005e2000c101c46ULL,
0x0000061000007947ULL, 0x000fea0003800000ULL, 0x0000000b02437211ULL, 0x040fe400078ff0ffULL,
0x0000001002347811ULL, 0x000fc400078ff0ffULL, 0x0000003c43437210ULL, 0x080fe40007f1e0ffULL,
0x00000008022a7811ULL, 0x040fe200078ff0ffULL, 0x000000010b297824ULL, 0x000fe200078e0234ULL,
0x0000002002367811ULL, 0x040fe200078ff0ffULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x00005e0043427a11ULL, 0x000fe200078040ffULL, 0x000000010b417824ULL, 0x040fe200078e022aULL,
0x0000002802387811ULL, 0x000fe200078ff0ffULL, 0x000000010b397824ULL, 0x000fe200078e0236ULL,
0x00005f0043437a11ULL, 0x000fe200000f4428ULL, 0x000000042a2a7824ULL, 0x000fe200078e00ffULL,
0x0000001802287811ULL, 0x040fe200078ff0ffULL, 0x000000010b3b7824ULL, 0x040fe200078e0238ULL,
0x00000030023a7811ULL, 0x000fe200078ff0ffULL, 0x0000000434347824ULL, 0x000fe200078e00ffULL,
0x00000038023e7811ULL, 0x000fe200078ff0ffULL, 0x000000010b3f7824ULL, 0x000fe200078e0228ULL,
0x0000003c29407210ULL, 0x080fe20007fbe0ffULL, 0x000000010b3d7824ULL, 0x000fe200078e023aULL,
0x0000003c41417210ULL, 0x080fe20007fde0ffULL, 0x000000010b2b7824ULL, 0x000fe200078e023eULL,
0x0000003c3f3f7210ULL, 0x080fe20007f1e0ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0x0000003c39397210ULL, 0x080fe20007f3e0ffULL, 0x0000000436367824ULL, 0x000fe200078e00ffULL,
0x0000003c3b3b7210ULL, 0x080fe20007f5e0ffULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0x0000003c3d3d7210ULL, 0x080fe20007f7e0ffULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x0000003c2b297210ULL, 0x000fe20007f9e0ffULL, 0x00000004283c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2a287812ULL, 0x000fc400078ee20dULL, 0xfffffffc342a7812ULL, 0x100fe400078ee20dULL,
0xfffffffc3c347812ULL, 0x000fe200078ee20dULL, 0x0000001028477824ULL, 0x000fe200078e0255ULL,
0xfffffffc38387812ULL, 0x000fe200078ee20dULL, 0x000000ffff287224ULL, 0x000fe200030e06ffULL,
0x00005e00412b7a11ULL, 0x040fe200078c40ffULL, 0x00000010344b7824ULL, 0x000fe200078e0255ULL,
0xfffffffc36367812ULL, 0x000fe200078ee20dULL, 0x0000001002347824ULL, 0x000fe200078e00ffULL,
0x00005f0041417a11ULL, 0x000fe200030f4428ULL, 0x000000102a497824ULL, 0x000fe200078e0255ULL,
0xfffffffc3a3a7812ULL, 0x000fe200078ee20dULL, 0x000000ffff2a7224ULL, 0x000fe200000e06ffULL,
0x00005e003f377a11ULL, 0x000fe200078040ffULL, 0x00000010384f7824ULL, 0x000fe200078e0255ULL,
0xfffffffc3e3c7812ULL, 0x000fe200078ee20dULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078240ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e06ffULL,
0x0000003034457812ULL, 0x000fe200078ec0ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x00005f003f3f7a11ULL, 0x000fe200000f442aULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005e0040357a11ULL, 0x000fe200078a40ffULL, 0x00000010364d7824ULL, 0x100fe200078e0255ULL,
0x00005f0039397a11ULL, 0x000fe200008f4428ULL, 0x000000103a517824ULL, 0x100fe200078e0255ULL,
0x00005e00293e7a11ULL, 0x000fe200078640ffULL, 0x000000103c557824ULL, 0x000fe200078e0255ULL,
0x0000004542287210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e003b3a7a11ULL, 0x000fc400078240ffULL, 0x00005e003d3c7a11ULL, 0x000fe400078440ffULL,
0x00005f0040407a11ULL, 0x000fe400028f440dULL, 0x00005f00290d7a11ULL, 0x000fe200018f442aULL,
0x000000ffff297224ULL, 0x000fe200000e0643ULL, 0x00005f003b3b7a11ULL, 0x000fe400008f4436ULL,
0x00005f003d3d7a11ULL, 0x000fe400010f4434ULL, 0x000000452b2a7210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028177faeULL, 0x0003e2000b901c46ULL,
0x0000004535347210ULL, 0x000fc40007f3e0ffULL, 0x0000004537367210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e0641ULL, 0x0000004538387210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff357224ULL, 0x000fe200008e0640ULL, 0x000000453a3a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff377224ULL, 0x000fe200010e063fULL, 0x000000453c3c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200018e0639ULL, 0x000000453e3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e063bULL, 0x000000002a477faeULL, 0x0003e2000b901c46ULL,
0x000000ffff3d7224ULL, 0x000fc400028e063dULL, 0x000000ffff3f7224ULL, 0x000fe200000e060dULL,
0x0000000034497faeULL, 0x0003e8000b901c46ULL, 0x00000000364b7faeULL, 0x0003e8000b901c46ULL,
0x00000000384d7faeULL, 0x0003e8000b901c46ULL, 0x000000003a4f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c517faeULL, 0x0003e8000b901c46ULL, 0x000000003e557faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000c0c287810ULL, 0x006fc40007ffe0ffULL,
0x0000000e0c0c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000728287812ULL, 0x100fe400078e780fULL,
0x000000070c0c7812ULL, 0x000fc600078e780fULL, 0x000000100f287824ULL, 0x040fe400078e0228ULL,
0x000000100f0c7824ULL, 0x000fe400078e020cULL, 0x0000001028347824ULL, 0x000fe400078e00ffULL,
0x000000100c447824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000000e38783bULL, 0x000e680000000200ULL,
0x00000000103c783bULL, 0x000ea80000000200ULL, 0x000000001140783bULL, 0x000ee80000000200ULL,
0x000000001628783bULL, 0x000f280000000200ULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x00000000134c783bULL, 0x000f680000000200ULL, 0x000000001450783bULL, 0x000f280000000200ULL,
0x00000000150c783bULL, 0x000f680000000200ULL, 0x000000001248783bULL, 0x0003640000000200ULL,
0x000000383458723cULL, 0x042ff00000041858ULL, 0x0000003c341c723cULL, 0x044ff0000004181cULL,
0x000000403424723cULL, 0x048ff00000041824ULL, 0x00000028342c723cULL, 0x050ff0000004182cULL,
0x0000002a345c723cULL, 0x040ff0000004185cULL, 0x0000003a3418723cULL, 0x040ff00000041818ULL,
0x0000003e3420723cULL, 0x040ff00000041820ULL, 0x000000423430723cULL, 0x000ff00000041830ULL,
0x0000004c4458723cULL, 0x060ff00000041858ULL, 0x000000504410723cULL, 0x040ff0000004181cULL,
0x0000000c4414723cULL, 0x040ff00000041824ULL, 0x00000048442c723cULL, 0x040ff0000004182cULL,
0x0000004a445c723cULL, 0x040ff0000004185cULL, 0x0000004e444c723cULL, 0x040ff00000041818ULL,
0x000000524450723cULL, 0x040ff00000041820ULL, 0x0000000e440c723cULL, 0x000fe20000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000000056187f8cULL, 0x000fe2000c80043fULL,
0x3db504f3102b7820ULL, 0x000fe20000410000ULL, 0x3db504f3112a7820ULL, 0x000fe20000410000ULL,
0x3db504f32c337820ULL, 0x000fe20000410000ULL, 0x0000040056357984ULL, 0x000e620000000800ULL,
0x3db504f32d327820ULL, 0x000fe20000410000ULL, 0x3db504f32e207820ULL, 0x000fe20000410000ULL,
0x3db504f32f1f7820ULL, 0x000fe20000410000ULL, 0x3db504f312227820ULL, 0x000fe20000410000ULL,
0x3db504f3131b7820ULL, 0x000fe20000410000ULL, 0x3db504f314107820ULL, 0x000fe20000410000ULL,
0x3db504f315117820ULL, 0x000fe20000410000ULL, 0x3db504f35c317820ULL, 0x000fe20000410000ULL,
0x3db504f35d307820ULL, 0x000fe20000410000ULL, 0x3db504f35e237820ULL, 0x000fe20000410000ULL,
0x3db504f35f247820ULL, 0x000fe20000410000ULL, 0x3db504f3582f7820ULL, 0x000fe20000410000ULL,
0x3db504f3592e7820ULL, 0x000fe20000410000ULL, 0x3db504f35a257820ULL, 0x000fe20000410000ULL,
0x3db504f35b267820ULL, 0x000fe20000410000ULL, 0x3db504f34c2d7820ULL, 0x000fe20000410000ULL,
0x3db504f34d2c7820ULL, 0x000fe20000410000ULL, 0x3db504f34e277820ULL, 0x000fe20000410000ULL,
0x3db504f34f217820ULL, 0x000fe20000410000ULL, 0x3db504f350297820ULL, 0x000fe20000410000ULL,
0x3db504f351287820ULL, 0x000fe20000410000ULL, 0x3db504f3521a7820ULL, 0x000fe20000410000ULL,
0x3db504f3531e7820ULL, 0x000fe20000410000ULL, 0x3db504f316157820ULL, 0x000fe20000410000ULL,
0x3db504f3171d7820ULL, 0x000fe20000410000ULL, 0x3db504f30c127820ULL, 0x000fe20000410000ULL,
0x3db504f30d137820ULL, 0x000fe20000410000ULL, 0x3db504f30e1c7820ULL, 0x000fe20000410000ULL,
0x3db504f30f147820ULL, 0x000fe20000410000ULL, 0x8000000035ff7812ULL, 0x002fe20007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL,
0x0000000c000d7305ULL, 0x0002a4000021f000ULL, 0x3fa000000c0c7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x004fe40003800000ULL, 0x00000400560d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000402167824ULL, 0x000fe200078e00ffULL, 0x000000575400720cULL, 0x000fc80003f05270ULL,
0xfffffff016177812ULL, 0x000fca00078ec0ffULL, 0x0000008000177824ULL, 0x000fca00078e0217ULL,
0x01340000170c7984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000202187824ULL, 0x000fe400078e00ffULL, 0x0000000103357824ULL, 0x000fc600078e0a0aULL,
0x0000000618187812ULL, 0x000fc800078ec0ffULL, 0x00000001180a7812ULL, 0x040fe400078efcffULL,
0x0000000818197812ULL, 0x000fe400078efcffULL, 0x000000350a00720cULL, 0x080fe40003f26070ULL,
0x00000010180a7812ULL, 0x000fe400078efcffULL, 0x000000351900720cULL, 0x080fe40003f06070ULL,
0x000000350a00720cULL, 0x000fc40003fc6070ULL, 0x0000001118197812ULL, 0x040fe400078efcffULL,
0x00000018180a7812ULL, 0x040fe400078efcffULL, 0x000000351800720cULL, 0x080fe40003f46070ULL,
0x000000351900720cULL, 0x080fe40003fa6070ULL, 0x000000350a00720cULL, 0x000fe40003f66070ULL,
0x0000000918347812ULL, 0x000fc400078efcffULL, 0x0000001918197812ULL, 0x040fe400078efcffULL,
0x00000020180a7812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40005000000ULL,
0xff7fffff33337808ULL, 0x000fe40005000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0xff7fffff32327808ULL, 0x000fc40004800000ULL, 0x000000353400720cULL, 0x080fe40003f86070ULL,
0x000000351900720cULL, 0x080fe40003f46070ULL, 0x000000350a00720cULL, 0x000fe40003f26070ULL,
0x0000002118197812ULL, 0x040fe400078efcffULL, 0x00000028180a7812ULL, 0x000fe400078efcffULL,
0xff7fffff23237808ULL, 0x000fc40004000000ULL, 0xff7fffff31317808ULL, 0x000fe40004000000ULL,
0xff7fffff24247808ULL, 0x000fe40006000000ULL, 0xff7fffff30307808ULL, 0x000fe40006000000ULL,
0x000000351900720cULL, 0x080fe40003f06070ULL, 0x000000350a00720cULL, 0x000fe40003f86070ULL,
0x0000002918197812ULL, 0x000fc400078efcffULL, 0x00000030180a7812ULL, 0x000fe400078efcffULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40007000000ULL,
0xff7fffff26267808ULL, 0x000fe40006800000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL,
0x000000351900720cULL, 0x000fc40003fc6070ULL, 0x000000350a00720cULL, 0x000fe40003fa6070ULL,
0x0000003118197812ULL, 0x040fe400078efcffULL, 0x00000038180a7812ULL, 0x040fe400078efcffULL,
0x0000003918187812ULL, 0x000fe400078efcffULL, 0xff7fffff27277808ULL, 0x000fe40005800000ULL,
0xff7fffff2d2d7808ULL, 0x000fc40005800000ULL, 0xff7fffff21217808ULL, 0x000fe40005000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40005000000ULL, 0xff7fffff22227808ULL, 0x000fe40004800000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40004800000ULL, 0x000000351900720cULL, 0x080fe40003f66070ULL,
0x000000350a00720cULL, 0x000fc40003f46070ULL, 0x000000351800720cULL, 0x000fe40003f26070ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006000000ULL, 0xff7fffff29297808ULL, 0x000fe40006000000ULL,
0xff7fffff1e1e7808ULL, 0x000fc40007000000ULL, 0xff7fffff28287808ULL, 0x000fe40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40006800000ULL, 0xff7fffff10107808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL, 0xff7fffff11117808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fc40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40005000000ULL,
0xff7fffff14147808ULL, 0x000fe40004800000ULL, 0xff7fffff13137808ULL, 0x000fe40004800000ULL,
0x000000330c197209ULL, 0x004fe20007810000ULL, 0x0000001fff377424ULL, 0x000fe200078e00ffULL,
0x000000200d0c7209ULL, 0x000fe20007810000ULL, 0xffffffffff3a7424ULL, 0x000fe200078e00ffULL,
0x00000032190a7209ULL, 0x000fe40007810000ULL, 0x0000001f0c0c7209ULL, 0x000fc40007810000ULL,
0x000000310a0d7209ULL, 0x000fe40007810000ULL, 0x000000230c197209ULL, 0x000fe40007810000ULL,
0x000000300d0a7209ULL, 0x000fe40007810000ULL, 0x00000024190c7209ULL, 0x000fe40007810000ULL,
0x0000002f0a0d7209ULL, 0x000fe40007810000ULL, 0x000000250c197209ULL, 0x000fc40007810000ULL,
0x0000002e0d0a7209ULL, 0x000fe40007810000ULL, 0x00000026190c7209ULL, 0x000fe40007810000ULL,
0x0000002d0a0d7209ULL, 0x000fe40007810000ULL, 0x000000270c0c7209ULL, 0x000fe40007810000ULL,
0x0000002c0d0a7209ULL, 0x000fe40007810000ULL, 0x000000210c0d7209ULL, 0x000fc40007810000ULL,
0x0000002b0a197209ULL, 0x000fe40007810000ULL, 0x000000220d0a7209ULL, 0x000fe40007810000ULL,
0x0000002a190c7209ULL, 0x000fe40007810000ULL, 0x0000001b0a0d7209ULL, 0x000fe40007810000ULL,
0x000000290c197209ULL, 0x000fe40007810000ULL, 0x0000001a0d0d7209ULL, 0x000fc40007810000ULL,
0x0000002819197209ULL, 0x000fe40007810000ULL, 0x0000001e0d0a7209ULL, 0x000fe40007810000ULL,
0x00000010190c7209ULL, 0x000fe40007810000ULL, 0x000000150a0a7209ULL, 0x000fe40007810000ULL,
0x000000110c0d7209ULL, 0x000fe40007810000ULL, 0x0000001d0a197209ULL, 0x000fc40007810000ULL,
0x000000120d0a7209ULL, 0x000fe40007810000ULL, 0x0000001c19197209ULL, 0x000fe40007810000ULL,
0x000000130a347209ULL, 0x000fe40007810000ULL, 0x0000001419367209ULL, 0x000fe20007810000ULL,
0x000017827f007947ULL, 0x000fea000b800000ULL, 0x0c401f00340a7f89ULL, 0x0004e400000e0000ULL,
0x0000000a34387209ULL, 0x008fe20007810000ULL, 0x000017a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f00360a7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f0c7f89ULL, 0x000f6200000e0000ULL, 0x0000000a36187209ULL, 0x008fc40007810000ULL,
0x0000000d0e197209ULL, 0x010fc60007810000ULL, 0x0c201f0018377f89ULL, 0x002fe200000e0000ULL,
0x0000000c0f0a7209ULL, 0x020fc60007810000ULL, 0x0c201f00380d7f89ULL, 0x000e6800000e0000ULL,
0x0c201f0019347f89ULL, 0x004ea800000e0000ULL, 0x0c201f000a357f89ULL, 0x00072200000e0000ULL,
0x0000000d380c7209ULL, 0x002fe40007810000ULL, 0x00000037180d7209ULL, 0x000fc40007810000ULL,
0x00000034190e7209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b0c0f7820ULL, 0x008fe20000410000ULL,
0x3fb8aa3b0d387820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b130f7823ULL, 0x000fe2000001080fULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fe20000010838ULL,
0x0000003200327308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ff00000000800ULL, 0x0000002300137308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000ef00000000800ULL, 0x0000002e00197308ULL, 0x000ff00000000800ULL,
0x00000028002e7308ULL, 0x000be20000000800ULL, 0x000000132413723eULL, 0x008fce00000010ffULL,
0x0000002f00187308ULL, 0x000ee20000000800ULL, 0x00000004ff287e24ULL, 0x020fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fc600038e0100ULL,
0x3f8000002828783eULL, 0x000fe400000010ffULL, 0x00000029002f7308ULL, 0x000bf00000000800ULL,
0x0000001000347308ULL, 0x0023e20000000800ULL, 0x000000ffff297224ULL, 0x020fe200078e0028ULL,
0x000000181918723eULL, 0x008fcc00000010ffULL, 0x0000001100377308ULL, 0x0007e20000000800ULL,
0x000000333210723eULL, 0x002fce00000010ffULL, 0x0000001200367308ULL, 0x0003e20000000800ULL,
0x000000201f11723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b211f7823ULL, 0x000fcc0000010838ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x000000313012723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b22307823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1a317823ULL, 0x000fca0000010838ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000281020723cULL, 0x000fee00000418ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b297823ULL, 0x000fce0000010838ULL,
0x0000001f00247308ULL, 0x0007620000000800ULL, 0x000000252619723eULL, 0x002fe200000010ffULL,
0x000000ffff257224ULL, 0x000fcc00078e0028ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c1f7823ULL, 0x008fe20000010838ULL, 0xfffffffc021c7812ULL, 0x000fcc00078ec0ffULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x00000027241b723eULL, 0x020fe200000010ffULL,
0x000000ffff247224ULL, 0x000fcc00078e0028ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000002d2c1a723eULL, 0x002fce00000010ffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0028ULL, 0x000000241824723cULL, 0x000fec0000041820ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x0000002f2e22723eULL, 0x000fce00000010ffULL,
0x0000002a002a7308ULL, 0x000ee20000000800ULL, 0x000000302921723eULL, 0x002fe200000010ffULL,
0x000000ffff297224ULL, 0x000fcc00078e0028ULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000002b2a20723eULL, 0x008fce00000010ffULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0x000000311e23723eULL, 0x002fce00000010ffULL,
0x0000001d002c7308ULL, 0x000e620000000800ULL, 0x000000282024723cULL, 0x000fee0000041824ULL,
0x0000000f000f7308ULL, 0x000ee20000000800ULL, 0x0000000fff297424ULL, 0x000fce00078e00ffULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000152c1d723eULL, 0x002fe200000010ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e0028ULL, 0x0000001c29297219ULL, 0x000fe400000006ffULL,
0x00000034371c723eULL, 0x000fe400000010ffULL, 0x00000000292a73a1ULL, 0x000e6200000e8000ULL,
0x0000001400147308ULL, 0x000f620000000800ULL, 0x00000000290473c4ULL, 0x000f220000004000ULL,
0x000000360f1e723eULL, 0x008fc400000010ffULL, 0x0000000a350f7209ULL, 0x014fe40007810000ULL,
0x0000001f141f723eULL, 0x020fce00000010ffULL, 0x0000002c1c2c723cULL, 0x000fe20000041824ULL,
0x0000000529ff7c12ULL, 0x002fda000f80402aULL, 0x0000127204008947ULL, 0x000ff4000b800000ULL,
0x001c1fff2c247589ULL, 0x0002a400000e0000ULL, 0x00000000290a73a1ULL, 0x000ee200000e8000ULL,
0x00000000290473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000529ff7c12ULL, 0x008fda000f80400aULL, 0x0000128204008947ULL, 0x010fea000b800000ULL,
0x001c1fff2e257589ULL, 0x00072800000e0000ULL, 0x001c1fff26267589ULL, 0x00066800000e0000ULL,
0x001c1fff00277589ULL, 0x0006a400000e0000ULL, 0x00000002ff0a7819ULL, 0x000fe40000011602ULL,
0x0000000c163d7812ULL, 0x000fc400078ec0ffULL, 0x000000070a147812ULL, 0x040fe200078ec0ffULL,
0x000000080a297824ULL, 0x04afe200078e00ffULL, 0x0000000aff287212ULL, 0x000fe200078e33ffULL,
0x000000080a157824ULL, 0x000fe200078e00ffULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080a357824ULL, 0x040fe200078e00ffULL, 0x000000080a0a7810ULL, 0x000fe40007ffe0ffULL,
0x00000001292b7812ULL, 0x140fe400078ef614ULL, 0x00000002292d7812ULL, 0x140fe200078ef614ULL,
0x000000080a497824ULL, 0x040fe200078e00ffULL, 0x00000003292f7812ULL, 0x140fe200078ef614ULL,
0x000000080a377824ULL, 0x040fe200078e00ffULL, 0x0000000429317812ULL, 0x140fe200078ef614ULL,
0x000000080a397824ULL, 0x000fe200078e00ffULL, 0x0000000529337812ULL, 0x000fc400078ef614ULL,
0xfffffff815157812ULL, 0x100fe400078ee214ULL, 0x0000000629297812ULL, 0x000fe400078ef614ULL,
0xfffffff835357812ULL, 0x000fe400078ee228ULL, 0x0000000aff287212ULL, 0x000fe400078e33ffULL,
0x000000070a147812ULL, 0x000fe400078ec0ffULL, 0x00009000000a7811ULL, 0x000fc400078e58ffULL,
0xfffffff837377812ULL, 0x100fe400078ee214ULL, 0x00000001393b7812ULL, 0x000fe200078ef614ULL,
0x000000102b167824ULL, 0x000fe200078e020aULL, 0x00000002393f7812ULL, 0x000fe200078ef614ULL,
0x000000102f2a7824ULL, 0x000fe200078e020aULL, 0x0000000339417812ULL, 0x000fe200078ef614ULL,
0x00000010312c7824ULL, 0x000fe200078e020aULL, 0x0000000439437812ULL, 0x000fe200078ef614ULL,
0x0000001029307824ULL, 0x000fe200078e020aULL, 0x0000000539457812ULL, 0x000fe200078ef614ULL,
0x00000010332e7824ULL, 0x000fe200078e020aULL, 0x0000000639477812ULL, 0x000fe200078ef614ULL,
0x0000001015147824ULL, 0x000fe200078e020aULL, 0xfffffff849497812ULL, 0x000fe200078ee228ULL,
0x000000102d287824ULL, 0x000fc400078e020aULL, 0x000000013d157824ULL, 0x040fe400078e0214ULL,
0x000000013d297824ULL, 0x040fe400078e0216ULL, 0x000000013d2b7824ULL, 0x000fe200078e0228ULL,
0x0000001015007388ULL, 0x0003e20000000800ULL, 0x0000001035327824ULL, 0x000fe400078e020aULL,
0x000000013d2d7824ULL, 0x000fe200078e022aULL, 0x0000001229007388ULL, 0x0007e20000000800ULL,
0x0000001037147824ULL, 0x000fc400078e020aULL, 0x000000013d2f7824ULL, 0x000fe200078e022cULL,
0x000000182b007388ULL, 0x0007e20000000800ULL, 0x000000103b347824ULL, 0x000fe400078e020aULL,
0x000000013d317824ULL, 0x000fe200078e022eULL, 0x0000001a2d007388ULL, 0x0007e20000000800ULL,
0x000000103f367824ULL, 0x000fe400078e020aULL, 0x000000013d337824ULL, 0x000fe200078e0230ULL,
0x000000202f007388ULL, 0x0007e20000000800ULL, 0x0000001041377824ULL, 0x000fc400078e020aULL,
0x000000013d357824ULL, 0x000fe200078e0232ULL, 0x0000002231007388ULL, 0x0007e20000000800ULL,
0x0000001043387824ULL, 0x000fe400078e020aULL, 0x000000013d147824ULL, 0x000fe200078e0214ULL,
0x0000001c33007388ULL, 0x0007e20000000800ULL, 0x0000001045397824ULL, 0x000fe400078e020aULL,
0x000000013d347824ULL, 0x000fe200078e0234ULL, 0x0000001e35007388ULL, 0x0007e20000000800ULL,
0x00000010473a7824ULL, 0x000fc400078e020aULL, 0x00000010493b7824ULL, 0x000fe200078e020aULL,
0x0000001114007388ULL, 0x0007e20000000800ULL, 0x000000013d367824ULL, 0x040fe400078e0236ULL,
0x000000013d0a7824ULL, 0x040fe200078e0237ULL, 0x0000001334007388ULL, 0x0007e20000000800ULL,
0x000000013d387824ULL, 0x040fe400078e0238ULL, 0x000000013d107824ULL, 0x042fe200078e0239ULL,
0x0000001936007388ULL, 0x0007e20000000800ULL, 0x000000013d3a7824ULL, 0x000fc400078e023aULL,
0x000000013d167824ULL, 0x000fe200078e023bULL, 0x0000001b0a007388ULL, 0x0007e80000000800ULL,
0x0000002138007388ULL, 0x0007e80000000800ULL, 0x0000002310007388ULL, 0x0007e80000000800ULL,
0x0000001d3a007388ULL, 0x0007e80000000800ULL, 0x0000001f16007388ULL, 0x0007e80000000800ULL,
0x0130000c17008388ULL, 0x0007e80000000c00ULL, 0x0132002417008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080008ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100008ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180008ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000056000720cULL, 0x000fe20003f06070ULL,
0x0136200008ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff547224ULL, 0x000fd600078e0060ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa82000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff157807ULL, 0x004fe40004000000ULL,
0x0001294000147802ULL, 0x000fe40000000f00ULL, 0x00000e4000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xfffeffe000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x0001299000147802ULL, 0x000fe40000000f00ULL,
0x00000df000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e001cULL,
0xffff001000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e001cULL,
0x00012a0000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x02efea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0027ULL, 0xffff006000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e001cULL, 0x00012a7000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x00000cd000007944ULL, 0x02cfea0003c00000ULL, 0xffff003000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x00012ad000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x00000c7000007944ULL, 0x028fea0003c00000ULL, 0x0000000816577810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff637224ULL, 0x004fe200078e0027ULL, 0x00012b4000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x002fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x000000ffff2a7224ULL, 0x000fc400078e0057ULL, 0x00000c0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff667224ULL, 0x004fe200078e0027ULL, 0xffff025000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x004fe40004000000ULL, 0x00012b9000147802ULL, 0x000fc40000000f00ULL,
0x00000bf000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e001cULL,
0xffff1a4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x000fe40004800000ULL,
0x00012be000147802ULL, 0x000fc40000000f00ULL, 0x00000ba000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xffff1a8000007947ULL, 0x000fea000383ffffULL,
0x0000001fff287424ULL, 0x002fe200078e00ffULL, 0x00012c4000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x00000b0000007944ULL, 0x028fea0003c00000ULL,
0xffff1b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x002fe200078e0057ULL,
0x00012ca000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x00000aa000007944ULL, 0x028fea0003c00000ULL,
0xffff1bc000007947ULL, 0x000fea000383ffffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x00012cf000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x00000a5000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff797224ULL, 0x004fe200078e0027ULL,
0x00012d5000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x002fe400078e0057ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x000009f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff787224ULL, 0x004fe200078e0027ULL,
0xffff1d0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x004fe40004000000ULL,
0x00012da000147802ULL, 0x000fc40000000f00ULL, 0x000009e000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xffff32c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x00012df000147802ULL, 0x000fc40000000f00ULL,
0x0000099000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e001cULL,
0xffff330000007947ULL, 0x000fea000383ffffULL, 0x0000001fff287424ULL, 0x002fe200078e00ffULL,
0x00012e5000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x000008f000007944ULL, 0x028fea0003c00000ULL, 0xffff338000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x002fe200078e0057ULL, 0x00012eb000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000089000007944ULL, 0x028fea0003c00000ULL, 0xffff344000007947ULL, 0x000fea000383ffffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x00012f0000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000084000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff797224ULL, 0x004fe200078e0027ULL, 0x00012f6000147802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x002fe400078e0057ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x000007e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff787224ULL, 0x004fe200078e0027ULL, 0xffff358000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x004fe40004000000ULL, 0x00012fb000147802ULL, 0x000fc40000000f00ULL,
0x000007d000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e001cULL,
0xffff4ae000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x000fe40004800000ULL,
0x0001300000147802ULL, 0x000fc40000000f00ULL, 0x0000078000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xffff4b2000007947ULL, 0x000fea000383ffffULL,
0x0000001fff287424ULL, 0x002fe200078e00ffULL, 0x0001306000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x000006e000007944ULL, 0x028fea0003c00000ULL,
0xffff4ba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x002fe200078e0057ULL,
0x000130c000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000068000007944ULL, 0x028fea0003c00000ULL,
0xffff4c6000007947ULL, 0x000fea000383ffffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x0001311000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff557224ULL, 0x004fe200078e0027ULL,
0x0001317000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x002fe400078e0057ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x000005d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff567224ULL, 0x004fe200078e0027ULL,
0xffff4da000007947ULL, 0x000fea000383ffffULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x000131c000187802ULL, 0x000fc40000000f00ULL, 0x0000054000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0035ULL, 0xffffe84000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x006fe200078e0036ULL, 0x0001322000187802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x000004e000007944ULL, 0x000fea0003c00000ULL,
0x0000003536367209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e000eULL,
0x0001327000187802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000350e0e7209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e000fULL, 0x000132c000187802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x000000350f0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e0038ULL,
0x0001331000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fc400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x00000035380c7209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e0036ULL, 0x0001336000187802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x00000035360d7209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e000eULL,
0x000133b000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fc400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x000000350e0e7209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e000aULL, 0x0001340000187802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0xffffe70000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2b7224ULL, 0x000fe200078e002cULL,
0x0001346000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff287424ULL, 0x000fe400078e00ffULL, 0x000002e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0027ULL, 0xffffed3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2b7224ULL, 0x002fe200078e002eULL, 0x000134d000147802ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff287424ULL, 0x000fe400078e00ffULL,
0x0000027000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2a7224ULL, 0x002fe200078e00ffULL,
0x0001352000147802ULL, 0x000fe20000000f00ULL, 0x00001c1fff287424ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x004fe400078e0027ULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2a7224ULL, 0x002fe200078e00ffULL, 0x0001357000147802ULL, 0x000fe20000000f00ULL,
0x00001c1fff287424ULL, 0x000fc400078e00ffULL, 0x000000ffff267224ULL, 0x004fe400078e0027ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0xffffecb000007947ULL, 0x000fea000383ffffULL,
0x018000000a057810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f800000050b7812ULL, 0x000fc800078ec0ffULL, 0x018000000b00780cULL, 0x000fda0003f05070ULL,
0x0000000a00058308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0b00720cULL, 0x040fe40003f25070ULL, 0x008000000b00780cULL, 0x000fe40003f02070ULL,
0x00000001ff2c7807ULL, 0x000fe40000800000ULL, 0x00000001ff057807ULL, 0x004fc80004000000ULL,
0x000000052cff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x040fe4000780c0ffULL, 0x800000000a0a7812ULL, 0x002fe400078ec0ffULL,
0x00000001ff057807ULL, 0x000fc80000000000ULL, 0x000000052cff7212ULL, 0x000fda000780c0ffULL,
0x008000000a050812ULL, 0x000fe200078efcffULL, 0x000000ffff058224ULL, 0x000fe200078e000aULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000a00057308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x006fe400078e0025ULL,
0x00000000ff0b7424ULL, 0x000fc800078e00ffULL, 0xfffec9000a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff197424ULL, 0x000fe200078e00ffULL, 0x0000003a00007348ULL, 0x000fe80003800000ULL,
0x0c00003534357389ULL, 0x0002a200000e0037ULL, 0xfffec8c018007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff157424ULL, 0x000fe200078e00ffULL, 0x0000002900007348ULL, 0x000fe80003800000ULL,
0x0000002a2b277389ULL, 0x0002a200000e0028ULL, 0xfffec88014007950ULL, 0x000fea0003c3ffffULL,
0x000000011500780cULL, 0x000fe20003f25070ULL, 0x0000005600007348ULL, 0x000fd80003800000ULL,
0x0000000000157806ULL, 0x000fc800048e0100ULL, 0x00000056151c7212ULL, 0x000fe200078ec0ffULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffec82014007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000002b0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000920ULL, 0x00000000000005e4ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f04ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f28ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f38ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f58ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000fe8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000ff0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001200ULL, 0x0000000000013880ULL, 0x7d00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014a80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014a90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014a90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014f10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000fe8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013a98ULL, 0x0000000000013a98ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014a80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014f10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin_len = 86000;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
