/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015c10ULL, 0x0000000000015790ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000014210ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000014380ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000143c0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000014400ULL,
0x0000000000000100ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000014500ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001421000000000ULL, 0x0000040400000000ULL, 0x810c000001180400ULL,
0x004f600400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x90082880808f0828ULL, 0x2880809c08288080ULL, 0x809e082880809d08ULL, 0x082880809f082880ULL,
0x8080b008288080a4ULL, 0xb608288080b10828ULL, 0x288080ac08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080acULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001421000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808c0828808081ULL, 0x90082880808f0828ULL, 0x2880809c08288080ULL, 0x809e082880809d08ULL,
0x082880809f082880ULL, 0x8080b008288080a4ULL, 0xb608288080b10828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080b6920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x0001438000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x90082880808f0828ULL, 0x2880809d08288080ULL,
0x809f082880809e08ULL, 0x08288080a4082880ULL, 0x8080b108288080b0ULL, 0x9c08288080b60828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809c920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x000001c000000000ULL, 0x000143c000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x90082880808f0828ULL,
0x2880809c08288080ULL, 0x809f082880809e08ULL, 0x08288080a4082880ULL, 0x8080b108288080b0ULL,
0x9d08288080b60828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809d920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000026800000000ULL, 0x0001440000000000ULL,
0x0000010000000000ULL, 0x0000140400000000ULL, 0x80902880809d0900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x00081204000000a0ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000eULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x00012b3000012850ULL,
0x00012c0000012b40ULL, 0x00012c2000012c10ULL, 0xffffffff01702904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x05000015ffffffffULL, 0x0500001505000015ULL, 0xffffffff05000015ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01702804ffffffffULL, 0x00000110000000f0ULL, 0x0000291000001750ULL, 0x00002a5000002990ULL,
0x00002d7000002a80ULL, 0x00002de000002d80ULL, 0x000034c000002e40ULL, 0x00004650000045c0ULL,
0x0000484000004720ULL, 0x00004a4000004a30ULL, 0x00004b0000004aa0ULL, 0x0000605000004f50ULL,
0x000061b0000060e0ULL, 0x000064c0000062d0ULL, 0x00006530000064d0ULL, 0x0000699000006590ULL,
0x00007b1000007a80ULL, 0x00007d0000007be0ULL, 0x00007f0000007ef0ULL, 0x00007fc000007f60ULL,
0x0000845000008440ULL, 0x0000ac200000ab90ULL, 0x0000b4900000b460ULL, 0x000124a000012470ULL,
0x000124c0000124b0ULL, 0x00012510000124f0ULL, 0x0001253000012520ULL, 0x00012c5000012bf0ULL,
0x00012c7000012c60ULL, 0x000133f000013390ULL, 0x000134f000013470ULL, 0x000135c000013550ULL,
0x0001368000013620ULL, 0x00013760000136f0ULL, 0x00013810000137b0ULL, 0x000138d000013870ULL,
0x000139c000013950ULL, 0x00013a7000013a10ULL, 0x00013b3000013ad0ULL, 0x00013bf000013b90ULL,
0x00013ca000013c40ULL, 0x00013da000013d20ULL, 0x00013e8000013e10ULL, 0x00013f6000013ef0ULL,
0x0001404000013fd0ULL, 0x00014130000140b0ULL, 0x000141f000014190ULL, 0x000001e002003904ULL,
0x0001b600000000ffULL, 0x00000260003f0100ULL, 0x0001b60800000005ULL, 0x00000320003f0120ULL,
0x0001b68800000005ULL, 0x000003f0003f0120ULL, 0x0001b600000000ffULL, 0x000005c0003f0107ULL,
0x0001b68c00000002ULL, 0x00000670003f0102ULL, 0x0001b68800000002ULL, 0x00002760003f0101ULL,
0x0001b6080000005eULL, 0x00002770003f0101ULL, 0x0001b60c0000005eULL, 0x00002820003f0105ULL,
0x0001b60c0000000fULL, 0x00003450003f0105ULL, 0x0001b68800000062ULL, 0x00004450003f0101ULL,
0x0001b6280000005eULL, 0x00004460003f0101ULL, 0x0001b62c0000005eULL, 0x000044f0003f0105ULL,
0x0001b62c0000005eULL, 0x00004ee0003f0105ULL, 0x0001b69000000062ULL, 0x00005ea0003f0101ULL,
0x0001b6480000005eULL, 0x00005eb0003f0101ULL, 0x0001b64c0000005eULL, 0x00005f80003f0105ULL,
0x0001b64c0000005eULL, 0x00006930003f0105ULL, 0x0001b69800000062ULL, 0x00007910003f0101ULL,
0x0001b6680000005eULL, 0x00007920003f0101ULL, 0x0001b66c0000005eULL, 0x000079b0003f0105ULL,
0x0001b66c0000005eULL, 0x00008280003f0105ULL, 0x0001b6a000000062ULL, 0x0000c1d0003f0101ULL,
0x0001b600000000ffULL, 0x0000dde0003f0101ULL, 0x0001b604000000ffULL, 0x0000de80003f0105ULL,
0x0001b604000000ffULL, 0x00011a90003f0105ULL, 0x000000000000000dULL, 0x00011ac0003f0101ULL,
0x000000040000000dULL, 0x00011d90003f0105ULL, 0x000000040000000dULL, 0x000131e0003f0105ULL,
0x0001b6080000000bULL, 0x00013240003f0101ULL, 0x0001b6100000000bULL, 0x000132a0003f0101ULL,
0x0001b6180000000bULL, 0x00013310003f0101ULL, 0x0001b6200000000bULL, 0x00033803003f0101ULL,
0x0000be9000141c04ULL, 0x0000dee00000c0e0ULL, 0x000133500000df70ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000002fcULL, 0x0000001200000002ULL, 0x0000000000000254ULL,
0x0000001200000002ULL, 0x00000000000001acULL, 0x0000001200000002ULL, 0x0000000000000104ULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x00000000000002d2ULL,
0x0000001200000002ULL, 0x000000000000022aULL, 0x0000001200000002ULL, 0x0000000000000182ULL,
0x0000001200000002ULL, 0x00000000000000dfULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff187624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ea20000002300ULL,
0x0000001200077300ULL, 0x000ee200000e0000ULL, 0x0000000818067824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea20000002200ULL, 0x00000100ff0d7424ULL, 0x000fc600078e00ffULL,
0x0000000000617919ULL, 0x000f220000002600ULL, 0x0000001200127309ULL, 0x000f660000000000ULL,
0x00000000000b7919ULL, 0x000ee80000002700ULL, 0x0000000000087919ULL, 0x000f620000000000ULL,
0x00000005ff607819ULL, 0x002fcc0000011605ULL, 0x00001fff60607589ULL, 0x000fe200000e0000ULL,
0x000000010f007824ULL, 0x004fc600078e0200ULL, 0x00001fff0f0f7589ULL, 0x000e6200000e0000ULL,
0x0000008000057824ULL, 0x000fc600078e0205ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000861047824ULL, 0x010fe200078e00ffULL, 0x000000ff0500720cULL, 0x000fc60003f05270ULL,
0x0000000b06067224ULL, 0x008fe200078e0204ULL, 0x0000000f0500780cULL, 0x000fe40003f24070ULL,
0x000000080700720cULL, 0x020fe40003f82070ULL, 0x0000007f0500780cULL, 0x000fca0003f44070ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe400078e00ffULL,
0x000000040f047824ULL, 0x002fe400078e0260ULL, 0x3fffffc0ff089424ULL, 0x000fe200078e00ffULL,
0x01b60002ff008388ULL, 0x0003e20000000a00ULL, 0x00000004ff0e7819ULL, 0x004fe20000011600ULL,
0x0000000204077824ULL, 0x000fe200078e00ffULL, 0x000000030500780cULL, 0x000fe20003f04070ULL,
0x7fffffc0ff099424ULL, 0x000fc400078e00ffULL, 0x0000000107117824ULL, 0x040fe200078e020eULL,
0x00000008070a7817ULL, 0x000fe20007800000ULL, 0xff317217ff10a424ULL, 0x000fe200078e00ffULL,
0x01b6080805009388ULL, 0x0005e20000008a00ULL, 0x0000000106027824ULL, 0x002fe400078e0211ULL,
0x000000010a0a7824ULL, 0x000fe200078e0a07ULL, 0x01b400100500a388ULL, 0x0003e20000004800ULL,
0x00005c0002027625ULL, 0x000fe200078e000dULL, 0x0000000711077812ULL, 0x000fe400078ec0ffULL,
0x0000000a0e00720cULL, 0x000fe20003f26070ULL, 0x3fffff60ff0c8424ULL, 0x000fe200078e00ffULL,
0x0000000f070a7812ULL, 0x000fe200078e7800ULL, 0x7fffff60ff0d8424ULL, 0x000fc400078e00ffULL,
0x0000001000047824ULL, 0x000fe400078e00ffULL, 0x00000010110a7824ULL, 0x000fe200078e020aULL,
0x01b6880c05008388ULL, 0x0003e20000008a00ULL, 0x000000ffff087224ULL, 0x004fe200078e0a12ULL,
0x000000f004137812ULL, 0x000fe200078ec0ffULL, 0x000000100a097824ULL, 0x000fe400078e00ffULL,
0x00000004ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001302067210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff077224ULL, 0x000fe400018e0603ULL,
0x000062000b027625ULL, 0x000fc600078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000c901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01b60408ffff438cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602177981ULL, 0x000ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x00000004ff157e24ULL, 0x008fe2000f8e00ffULL, 0x0000003f17167810ULL, 0x004fc40007ffe0ffULL,
0x000000ff17147810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff167819ULL, 0x000fe40000011616ULL,
0x00000008ff147819ULL, 0x000fca0000011614ULL, 0x0000bbf000008947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe20000011660ULL, 0xffffffffff067424ULL, 0x002fc600078e00ffULL,
0x03ffffff03027812ULL, 0x000fca00078ec0ffULL, 0x0000000415077824ULL, 0x000fca00078e0202ULL,
0x000000160700720cULL, 0x000fda0003f06070ULL, 0x000000020b028824ULL, 0x000fe400078e00ffULL,
0x00006400ff058624ULL, 0x000fc800078e00ffULL, 0x0000640002048624ULL, 0x000fe400078e0205ULL,
0x0000000860027824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x000fe400078e00ffULL,
0x0000000107098824ULL, 0x000fe200078e0204ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b68c0502ff738cULL, 0x0003e20000000000ULL, 0x0000600009088625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608068981ULL, 0x000ea2000c1e1900ULL,
0x00000001150d7810ULL, 0x000fe20007ffe0ffULL, 0x0000004061617824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x002fe20000011660ULL, 0x01b6880002ff7f8cULL, 0x0003e2000c80043fULL,
0x000000140d00720cULL, 0x000fc40003f06070ULL, 0x00000001600e7812ULL, 0x000fe200078ec0ffULL,
0x0000002005047824ULL, 0x000fc800078e00ffULL, 0x00000100150c7824ULL, 0x000fca00078e0204ULL,
0x0000002061247812ULL, 0x000fe200078ef80cULL, 0x0000580006067a24ULL, 0x004fc800078e02ffULL,
0x0000004006267824ULL, 0x000fe200078e00ffULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x00000003ff0f7819ULL, 0x002fe20000011600ULL, 0x0000000205217824ULL, 0x000fe200078e020eULL,
0x0000000c17067217ULL, 0x000fe40007800000ULL, 0x000000040f097810ULL, 0x040fe40007ffe0ffULL,
0x000000080f0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0cULL,
0x0000000009087212ULL, 0x0c0fe200078e3cffULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0x000000000d0c7212ULL, 0x040fe200078e3cffULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x0000002006067817ULL, 0x000fc40003800000ULL, 0xfffffff811207812ULL, 0x000fe200078ee208ULL,
0x0000000124087824ULL, 0x040fe200078e020fULL, 0x0000000c0f1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813227812ULL, 0x000fe400078ee20cULL, 0x000000060900720cULL, 0x000fe20003f06070ULL,
0x0000000124097824ULL, 0x000fe200078e0209ULL, 0x00000008260c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000124087824ULL, 0x040fe200078e021dULL, 0x000000060d00720cULL, 0x000fe20003f26070ULL,
0x00000001240d7824ULL, 0x000fe200078e020dULL, 0x0000000926137210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000000826097210ULL, 0x000fc40007fbe0ffULL,
0x0000000d260d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x00005e000c107a11ULL, 0x040fe200078440ffULL, 0x000000ffff187224ULL, 0x000fe200028e06ffULL,
0x000000100f257810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x00005e0009087a11ULL, 0x040fe400078840ffULL, 0x00005f000c117a11ULL, 0x000fe400010f4411ULL,
0x00005f0009097a11ULL, 0x000fe200020f4418ULL, 0x0000000124187824ULL, 0x000fe200078e0225ULL,
0x00005e0013127a11ULL, 0x000fc400078440ffULL, 0x000000140f277810ULL, 0x000fe40007ffe0ffULL,
0x00005e000d0c7a11ULL, 0x000fe400078640ffULL, 0x000000180f297810ULL, 0x000fe20007ffe0ffULL,
0x0000000124197824ULL, 0x000fe200078e0227ULL, 0x00005f0013137a11ULL, 0x000fe400010f441cULL,
0x0000001c0f2b7810ULL, 0x000fe40007ffe0ffULL, 0x00000018261e7210ULL, 0x000fc40007f5e0ffULL,
0x00005f000d0d7a11ULL, 0x000fe200018f441aULL, 0x00000001241a7824ULL, 0x000fe200078e0229ULL,
0x00000019261c7210ULL, 0x000fe20007fbe0ffULL, 0x00000001241b7824ULL, 0x000fe200078e022bULL,
0x00005e001e187a11ULL, 0x000fe200078840ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e06ffULL,
0x0000001a26287210ULL, 0x040fe20007f7e0ffULL, 0x000000081d247824ULL, 0x000fe200078e00ffULL,
0x0000001b26267210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e06ffULL,
0x00005f001e197a11ULL, 0x000fe200020f441fULL, 0x000000080e1f7824ULL, 0x000fe200078e00ffULL,
0x00005e001c1a7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff2f7224ULL, 0x000fe200018e06ffULL,
0x000000060f00720cULL, 0x040fe20003f86070ULL, 0x000000ffff2d7224ULL, 0x000fe200010e06ffULL,
0x000000070f0f7812ULL, 0x000fe200078e4800ULL, 0x000000082b2a7824ULL, 0x000fe200078e00ffULL,
0x00005f001c1b7a11ULL, 0x000fc400028f441bULL, 0x0ffffff80f1c7812ULL, 0x100fe400078ef800ULL,
0x0001300021217811ULL, 0x000fe400078e68ffULL, 0xfffffff81f0f7812ULL, 0x000fe400078ee200ULL,
0x000000001d1f7212ULL, 0x000fe200078e3cffULL, 0x000000101c237824ULL, 0x000fe200078e0221ULL,
0x00005e00281c7a11ULL, 0x000fe200078640ffULL, 0x000000100f107825ULL, 0x000fe200078e0010ULL,
0x00005e00261e7a11ULL, 0x000fc400078a40ffULL, 0x000000061d00720cULL, 0x080fe20003f46070ULL,
0x000000100f0c7825ULL, 0x000fe200078e000cULL, 0xfffffff824247812ULL, 0x000fe200078ee21fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010237faeULL, 0x0003e2000e101c46ULL,
0x00005f00281d7a11ULL, 0x000fe200018f442fULL, 0x0000000827287824ULL, 0x000fe200078e00ffULL,
0x00005f00261f7a11ULL, 0x000fe200028f442dULL, 0x00000008252d7824ULL, 0x040fe200078e00ffULL,
0x000000062500720cULL, 0x080fe20003f66070ULL, 0x000000100f087825ULL, 0x000fe200078e0008ULL,
0x000000062700720cULL, 0x000fc40003f86070ULL, 0x000000062900720cULL, 0x080fe40003fa6070ULL,
0x000000062b00720cULL, 0x000fe20003fc6070ULL, 0x0000001020237824ULL, 0x102fe200078e0221ULL,
0x0000000025067212ULL, 0x080fe400078e3cffULL, 0x0000000027257212ULL, 0x080fe200078e3cffULL,
0x0000001024277824ULL, 0x000fe200078e0221ULL, 0x0000000029267212ULL, 0x0c0fe200078e3cffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0xfffffff828107812ULL, 0x000fe200078ee225ULL,
0x0000001022257824ULL, 0x000fe200078e0221ULL, 0x000000002b117212ULL, 0x000fc400078e3cffULL,
0xfffffff82d067812ULL, 0x000fe200078ee206ULL, 0x00000010102b7824ULL, 0x000fe200078e0221ULL,
0xfffffff82a287812ULL, 0x000fe200078ee211ULL, 0x000000100f107825ULL, 0x000fe200078e0012ULL,
0xfffffff829267812ULL, 0x000fc600078ee226ULL, 0x0000001006297824ULL, 0x000fe200078e0221ULL,
0x0000000010237faeULL, 0x0003e2000c101c46ULL, 0x000000100f127825ULL, 0x000fc600078e0018ULL,
0x000000000c257faeULL, 0x0003e2000c901c46ULL, 0x000000100f187825ULL, 0x000fc600078e001aULL,
0x0000000008277faeULL, 0x0003e2000d101c46ULL, 0x00000010262d7824ULL, 0x000fe400078e0221ULL,
0x000000100f1a7825ULL, 0x040fe200078e001cULL, 0x0000000012297faeULL, 0x0003e6000d901c46ULL,
0x0000001028217824ULL, 0x000fe200078e0221ULL, 0x00000000182b7faeULL, 0x0003e2000e101c46ULL,
0x000000100f1c7825ULL, 0x000fc600078e001eULL, 0x000000001a2d7faeULL, 0x0003e8000e901c46ULL,
0x000000001c217faeULL, 0x0003e2000f101c46ULL, 0x0000066000007947ULL, 0x000fea0003800000ULL,
0x00000003ff0d7819ULL, 0x002fe20000011600ULL, 0x000000080e2f7824ULL, 0x000fc600078e00ffULL,
0x000000080d117810ULL, 0x040fe40007ffe0ffULL, 0x000000040d0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000011087212ULL, 0x0c0fe200078e3cffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0x000000000f067212ULL, 0x040fe200078e3cffULL, 0x000000080f097824ULL, 0x000fe200078e00ffULL,
0x000000100d1b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001240f7824ULL, 0x040fe200078e020fULL,
0xfffffff813187812ULL, 0x000fe200078ee208ULL, 0x0000000124117824ULL, 0x040fe200078e0211ULL,
0xfffffff809127812ULL, 0x000fe200078ee206ULL, 0x0000000124097824ULL, 0x000fe200078e020dULL,
0x0000000c0d137810ULL, 0x000fe20007ffe0ffULL, 0x000000081b217824ULL, 0x000fe200078e00ffULL,
0x000000140d1d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000926097210ULL, 0x000fe20007f1e0ffULL,
0x00000008131f7824ULL, 0x040fe200078e00ffULL, 0x00000000130c7212ULL, 0x080fe200078e3cffULL,
0x000000081d1e7824ULL, 0x000fe200078e00ffULL, 0x000000001b107212ULL, 0x000fe200078e3cffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee20cULL,
0x00000001241b7824ULL, 0x000fe200078e021bULL, 0x000000180d1f7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0009087a11ULL, 0x000fc400078040ffULL, 0x000000001d197212ULL, 0x080fe200078e3cffULL,
0x000000081f277824ULL, 0x000fe200078e00ffULL, 0x00005f0009097a11ULL, 0x000fe200000f4406ULL,
0x00000001241d7824ULL, 0x040fe200078e021dULL, 0x000000001f067212ULL, 0x000fe400078e3cffULL,
0xfffffff8211c7812ULL, 0x000fe200078ee210ULL, 0x0000000124217824ULL, 0x000fe200078e021fULL,
0xfffffff827207812ULL, 0x000fe200078ee206ULL, 0x0000000205067824ULL, 0x000fe200078e020eULL,
0x0000001c0d237810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee219ULL,
0x0000000124197824ULL, 0x000fe200078e0213ULL, 0x0000000f26107210ULL, 0x000fe20007fde0ffULL,
0x0000000823227824ULL, 0x000fe200078e00ffULL, 0x000000070d0d7812ULL, 0x100fe200078e4800ULL,
0x0000000124257824ULL, 0x000fe200078e0223ULL, 0x00000021261f7210ULL, 0x000fe40007f3e0ffULL,
0x00013000060f7811ULL, 0x000fe400078e68ffULL, 0x0000001126137210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x0000000023217212ULL, 0x000fe200078e3cffULL,
0x0000001012237824ULL, 0x100fe200078e020fULL, 0x0ffffff80d067812ULL, 0x000fe200078ef800ULL,
0x000000101a277824ULL, 0x100fe200078e020fULL, 0x0000001926197210ULL, 0x000fe20007f9e0ffULL,
0x000000101c297824ULL, 0x100fe200078e020fULL, 0x00005e00100c7a11ULL, 0x000fe200078c40ffULL,
0x000000101e2b7824ULL, 0x100fe200078e020fULL, 0x0000001b261b7210ULL, 0x000fe20007f7e0ffULL,
0x00000010202d7824ULL, 0x000fe200078e020fULL, 0x0000001d261d7210ULL, 0x000fc40007f1e0ffULL,
0xfffffff822227812ULL, 0x000fe200078ee221ULL, 0x0000001006217824ULL, 0x100fe200078e020fULL,
0x0000002526267210ULL, 0x000fe20007f5e0ffULL, 0x0000001018257824ULL, 0x000fe200078e020fULL,
0x00005f00100d7a11ULL, 0x000fe200030f4411ULL, 0x000000ffff067224ULL, 0x000fe200028e06ffULL,
0x00005e0013107a11ULL, 0x000fe200078a40ffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x00005e0019127a11ULL, 0x000fe200078840ffULL, 0x0000001022317824ULL, 0x000fe200078e020fULL,
0x00005f0013117a11ULL, 0x000fe200028f4406ULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x00005f0019137a11ULL, 0x000fe200020f4418ULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0xfffffff82f0f7812ULL, 0x000fe200078ee200ULL, 0x000000ffff227224ULL, 0x000fe200008e06ffULL,
0x00005e001b187a11ULL, 0x000fe200078640ffULL, 0x000000ffff2f7224ULL, 0x000fe200010e06ffULL,
0x00005e001d1a7a11ULL, 0x000fe200078040ffULL, 0x000000100f087825ULL, 0x000fe200078e0008ULL,
0x00005e001f1c7a11ULL, 0x000fc400078240ffULL, 0x00005e00261e7a11ULL, 0x040fe200078440ffULL,
0x000000100f0c7825ULL, 0x000fe200078e000cULL, 0x00005f001b197a11ULL, 0x000fe200018f4406ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008217faeULL, 0x0003e2000b901c46ULL,
0x00005f001d1b7a11ULL, 0x000fe200000f4420ULL, 0x000000100f107825ULL, 0x000fe200078e0010ULL,
0x00005f001f1d7a11ULL, 0x000fe200008f4422ULL, 0x000000000c237faeULL, 0x0003e2000b901c46ULL,
0x00005f00261f7a11ULL, 0x000fe200010f442fULL, 0x000000100f127825ULL, 0x040fe400078e0012ULL,
0x0000000010257faeULL, 0x0003e4000b901c46ULL, 0x000000100f187825ULL, 0x000fc400078e0018ULL,
0x0000000012277faeULL, 0x0003e4000b901c46ULL, 0x000000100f1a7825ULL, 0x040fe400078e001aULL,
0x0000000018297faeULL, 0x0003e4000b901c46ULL, 0x000000100f1c7825ULL, 0x040fe400078e001cULL,
0x000000001a2b7faeULL, 0x0003e4000b901c46ULL, 0x000000100f1e7825ULL, 0x000fc400078e001eULL,
0x000000001c2d7faeULL, 0x0003e8000b901c46ULL, 0x000000001e317faeULL, 0x0003e4000b901c46ULL,
0x00000003ff097424ULL, 0x002fe200078e00ffULL, 0x0000000307087812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000003000a067a24ULL, 0x000fe200078e0a09ULL,
0x000000030800780cULL, 0x000fc80003f05270ULL, 0x0000000106087807ULL, 0x000fca0004000000ULL,
0x0000000107077824ULL, 0x000fca00078e0208ULL, 0x000000160700720cULL, 0x000fda0003f06070ULL,
0x000000020b088824ULL, 0x000fe400078e00ffULL, 0x00006400ff098624ULL, 0x000fc800078e00ffULL,
0x0000640008088624ULL, 0x000fc800078e0209ULL, 0x00000001080d8824ULL, 0x000fe400078e0207ULL,
0xffffffffff087424ULL, 0x000fe400078e00ffULL, 0x000060000d0c8625ULL, 0x000fca00078e000aULL,
0x000000060c088981ULL, 0x000362000c1e1900ULL, 0x000000141500720cULL, 0x000fe20003f06070ULL,
0xff317217ff097424ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00006c3000000947ULL, 0x000fea0003800000ULL, 0x000000020b0c7824ULL, 0x002fe400078e00ffULL,
0x00006400ff0b7624ULL, 0x000fc400078e00ffULL, 0xff317217ff097424ULL, 0x000fe400078e00ffULL,
0x000000ffff777224ULL, 0x000fe400078e00ffULL, 0x000064000c0c7624ULL, 0x000fe400078e020bULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x0000010015107824ULL, 0x000fca00078e00ffULL,
0x000000171000720cULL, 0x000fda0003f06070ULL, 0x00006b6000000947ULL, 0x000fea0003800000ULL,
0x00000010600b7824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00b107812ULL, 0x000fe200078ec0ffULL, 0x0000580008087a24ULL, 0x020fe200078e02ffULL,
0x00000001150b7810ULL, 0x000fc60007ffe0ffULL, 0x0000010015107824ULL, 0x000fe200078e0210ULL,
0x000000140b00720cULL, 0x000fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0077ULL,
0x00000040082b7824ULL, 0x000fe200078e00ffULL, 0x0000004010127810ULL, 0x000fc80007ffe0ffULL,
0x0000002061257812ULL, 0x000fca00078ef812ULL, 0x0000077000008947ULL, 0x000fea0003800000ULL,
0x0000001217087217ULL, 0x000fe20007800000ULL, 0x0000200060107824ULL, 0x000fe200078e00ffULL,
0x00000007000f7812ULL, 0x000fe200078ec0ffULL, 0x0000100077117824ULL, 0x000fe200078e00ffULL,
0x00000003ff237819ULL, 0x000fe20000011600ULL, 0x0000000108087824ULL, 0x000fe200078e0a12ULL,
0x0000200010107812ULL, 0x000fe200078ec0ffULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x0000000423137810ULL, 0x040fe40007ffe0ffULL, 0x00000008231d7810ULL, 0x000fc40007ffe0ffULL,
0x00000008120f7812ULL, 0x000fe200078ee20fULL, 0x00000008132f7824ULL, 0x000fe200078e00ffULL,
0x0000100011127812ULL, 0x000fe200078e0cffULL, 0x0000400005117824ULL, 0x000fe200078e0210ULL,
0x00000000131c7212ULL, 0x000fe200078e3cffULL, 0x0000000123107824ULL, 0x100fe200078e0225ULL,
0x0000002008087817ULL, 0x000fe20003800000ULL, 0x000000081d317824ULL, 0x000fe200078e00ffULL,
0x0001300011287810ULL, 0x000fe40007ffe012ULL, 0x000000102b117210ULL, 0x000fe20007f1e0ffULL,
0x0000000113107824ULL, 0x000fe200078e0225ULL, 0xfffffff82f2f7812ULL, 0x000fc400078ee21cULL,
0x000000001d1e7212ULL, 0x000fe200078e3cffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005e0011127a11ULL, 0x000fe400078040ffULL, 0x000000081300720cULL, 0x000fe40003f46070ULL,
0xfffffff831317812ULL, 0x000fe400078ee21eULL, 0x00005f0011137a11ULL, 0x000fe200000f441cULL,
0x000000011d117824ULL, 0x000fe200078e0225ULL, 0x000000102b1e7210ULL, 0x000fc40007f1e0ffULL,
0x0000000c23337810ULL, 0x000fe20007ffe0ffULL, 0x000000100f127825ULL, 0x000fe200078e0012ULL,
0x0000001023517810ULL, 0x000fe40007ffe0ffULL, 0x000000081d00720cULL, 0x000fe20003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200000e06ffULL, 0x00005e001e107a11ULL, 0x040fe200078040ffULL,
0x00000001331c7824ULL, 0x100fe200078e0225ULL, 0x000000112b217210ULL, 0x000fe20007f7e0ffULL,
0x00000001511d7824ULL, 0x000fe200078e0225ULL, 0x00005f001e117a11ULL, 0x000fe200000f441fULL,
0x00000008332e7824ULL, 0x000fe200078e00ffULL, 0x0000001c2b1f7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x0000001d2b1d7210ULL, 0x000fe20007fbe0ffULL,
0x000000100f107825ULL, 0x000fe200078e0010ULL, 0x0000001423537810ULL, 0x000fc40007ffe0ffULL,
0x00005e0021207a11ULL, 0x000fe200078040ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff227224ULL, 0x000fe200028e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe400078640ffULL, 0x0000001823557810ULL, 0x000fe40007ffe0ffULL,
0x00005f001d1d7a11ULL, 0x000fe200020f4422ULL, 0x0000000153227824ULL, 0x000fe200078e0225ULL,
0x0000001c23577810ULL, 0x000fc40007ffe0ffULL, 0x00005f0021217a11ULL, 0x000fe200000f4426ULL,
0x000000100f1c7825ULL, 0x000fe200078e001cULL, 0x00005f001f1f7a11ULL, 0x000fe400018f4424ULL,
0x000000082300720cULL, 0x000fe20003f66070ULL, 0x0000000157247824ULL, 0x000fe200078e0225ULL,
0x000000222b267210ULL, 0x000fe20007f1e0ffULL, 0x000000100f207825ULL, 0x000fe200078e0020ULL,
0x00000007232d7812ULL, 0x000fe400078e4800ULL, 0x000000085700720cULL, 0x000fe20003fc6070ULL,
0x0000000155237824ULL, 0x000fe200078e0225ULL, 0x000000242b257210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe200000e06ffULL, 0x00005e0026227a11ULL, 0x000fe200078040ffULL,
0x000000100f1e7825ULL, 0x000fe200078e001eULL, 0x000000232b277210ULL, 0x000fc40007f9e0ffULL,
0x0ffffff82d2d7812ULL, 0x000fe200078ef800ULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005f0026237a11ULL, 0x000fe200000f4429ULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078840ffULL, 0x000000102d297824ULL, 0x000fe200078e0228ULL,
0x00005e0025247a11ULL, 0x000fe200078a40ffULL, 0x00000008512d7824ULL, 0x000fe200078e00ffULL,
0x00005f0027277a11ULL, 0x000fe200020f442cULL, 0x000000100f227825ULL, 0x000fe200078e0022ULL,
0x00005f0025257a11ULL, 0x000fe200028f442aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012297faeULL, 0x0003e2000d901c46ULL, 0x00000000332b7212ULL, 0x000fe200078e3cffULL,
0x000000100f267825ULL, 0x000fe200078e0026ULL, 0x000000083300720cULL, 0x000fc40003f06070ULL,
0x000000085100720cULL, 0x080fe20003f66070ULL, 0x0000000853337824ULL, 0x040fe200078e00ffULL,
0x000000085300720cULL, 0x080fe20003f86070ULL, 0x000000100f247825ULL, 0x000fe200078e0024ULL,
0x000000085500720cULL, 0x000fe40003fa6070ULL, 0x0000000051087212ULL, 0x080fe200078e3cffULL,
0x0000000855517824ULL, 0x000fe200078e00ffULL, 0x00000000532a7212ULL, 0x080fe200078e3cffULL,
0x0000000857537824ULL, 0x000fe200078e00ffULL, 0x00000000552c7212ULL, 0x080fe200078e3cffULL,
0x000000102f137824ULL, 0x102fe200078e0228ULL, 0xfffffff82e2b7812ULL, 0x000fe200078ee22bULL,
0x0000001031297824ULL, 0x000fe200078e0228ULL, 0x0000000057127212ULL, 0x000fc400078e3cffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL, 0x000000102b2b7824ULL, 0x000fe200078e0228ULL,
0xfffffff833337812ULL, 0x000fe200078ee22aULL, 0x0000000010137faeULL, 0x0003e2000d101c46ULL,
0xfffffff851517812ULL, 0x000fe200078ee22cULL, 0x000000102d2d7824ULL, 0x000fe200078e0228ULL,
0xfffffff853537812ULL, 0x000fe200078ee212ULL, 0x00000010332f7824ULL, 0x100fe200078e0228ULL,
0x0000000020297faeULL, 0x0003e2000c901c46ULL, 0x0000001051317824ULL, 0x100fe400078e0228ULL,
0x0000001053337824ULL, 0x000fe200078e0228ULL, 0x000000001e2b7faeULL, 0x0003e8000c101c46ULL,
0x000000001c2d7faeULL, 0x0003e8000d901c46ULL, 0x00000000222f7faeULL, 0x0003e8000e101c46ULL,
0x0000000026317faeULL, 0x0003e8000e901c46ULL, 0x0000000024337faeULL, 0x0003e2000f101c46ULL,
0x000006b000007947ULL, 0x000fea0003800000ULL, 0x0000200060107824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fe20000011600ULL, 0x0000100077117824ULL, 0x000fe200078e00ffULL,
0x00000007000f7812ULL, 0x000fe200078ec0ffULL, 0x000000080e1e7824ULL, 0x000fe200078e00ffULL,
0x0000200010107812ULL, 0x000fc400078ec0ffULL, 0x00000008081c7810ULL, 0x040fe40007ffe0ffULL,
0x0000100011117812ULL, 0x000fe200078e0cffULL, 0x0000400005107824ULL, 0x000fe200078e0210ULL,
0x0000000408137810ULL, 0x000fe20007ffe0ffULL, 0x000000081c227824ULL, 0x040fe200078e00ffULL,
0x000000001c1f7212ULL, 0x000fe400078e3cffULL, 0x00013000101d7810ULL, 0x000fe20007ffe011ULL,
0x0000000108107824ULL, 0x000fe200078e0225ULL, 0xfffffff822227812ULL, 0x000fe200078ee21fULL,
0x0000000813217824ULL, 0x000fe200078e00ffULL, 0x0000000c081f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000013127212ULL, 0x000fe400078e3cffULL, 0x000000102b117210ULL, 0x000fe20007f1e0ffULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0x000000081e0f7812ULL, 0x000fe400078ee20fULL,
0xfffffff8211e7812ULL, 0x000fe200078ee212ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x0000001008217810ULL, 0x000fe40007ffe0ffULL, 0x000000001f207212ULL, 0x000fc400078e3cffULL,
0x00005e0011107a11ULL, 0x000fe200078040ffULL, 0x00000008212a7824ULL, 0x040fe200078e00ffULL,
0x0000001408277810ULL, 0x000fe20007ffe0ffULL, 0x0000000121287824ULL, 0x100fe200078e0225ULL,
0xfffffff829267812ULL, 0x000fe200078ee220ULL, 0x000000011c207824ULL, 0x100fe200078e0225ULL,
0x00005f0011117a11ULL, 0x000fe200000f4412ULL, 0x0000000113127824ULL, 0x100fe200078e0225ULL,
0x0000001c08297810ULL, 0x000fe20007ffe0ffULL, 0x00000008272d7824ULL, 0x000fe200078e00ffULL,
0x0000000021237212ULL, 0x080fe200078e3cffULL, 0x00000001272c7824ULL, 0x140fe200078e0225ULL,
0x0000000027247212ULL, 0x000fe200078e3cffULL, 0x0000000129327824ULL, 0x040fe200078e0225ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee223ULL, 0x0000000829507824ULL, 0x000fe200078e00ffULL,
0x0000001808237810ULL, 0x000fe20007ffe0ffULL, 0x00000010262f7824ULL, 0x100fe200078e021dULL,
0x000000122b1c7210ULL, 0x000fe20007fde0ffULL, 0x000000102a317824ULL, 0x000fe200078e021dULL,
0xfffffff82d2e7812ULL, 0x000fe200078ee224ULL, 0x000000011f247824ULL, 0x100fe200078e0225ULL,
0x000000322b277210ULL, 0x000fe20007f5e0ffULL, 0x0000000123307824ULL, 0x040fe200078e0225ULL,
0x0000000708137812ULL, 0x000fe200078e4800ULL, 0x0000000823327824ULL, 0x040fe200078e00ffULL,
0x0000000023217212ULL, 0x000fe200078e3cffULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x000000202b207210ULL, 0x000fe20007fbe0ffULL, 0x00000010222d7824ULL, 0x100fe200078e021dULL,
0x0000000029237212ULL, 0x000fe200078e3cffULL, 0x000000102e337824ULL, 0x000fe200078e021dULL,
0x00005e001c127a11ULL, 0x000fe200078c40ffULL, 0x000000100f107825ULL, 0x000fe200078e0010ULL,
0x000000242b247210ULL, 0x000fc40007f9e0ffULL, 0x0ffffff813087812ULL, 0x000fe400078ef800ULL,
0xfffffff832327812ULL, 0x000fe200078ee221ULL, 0x000000ffff217224ULL, 0x000fe200020e06ffULL,
0xfffffff850507812ULL, 0x000fe200078ee223ULL, 0x0000001008297824ULL, 0x000fe200078e021dULL,
0x00005f001c137a11ULL, 0x000fe200030f441fULL, 0x000000ffff1f7224ULL, 0x000fe200028e06ffULL,
0x000000282b287210ULL, 0x040fe20007f7e0ffULL, 0x0000001032517824ULL, 0x100fe200078e021dULL,
0x0000002c2b2c7210ULL, 0x040fe20007f1e0ffULL, 0x0000001050537824ULL, 0x100fe200078e021dULL,
0x000000302b307210ULL, 0x000fe20007f3e0ffULL, 0x000000101e2b7824ULL, 0x000fe200078e021dULL,
0x00005e00201c7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e00241e7a11ULL, 0x000fe200078840ffULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x00005f00201d7a11ULL, 0x000fe200028f441fULL, 0x000000ffff087224ULL, 0x000fe200010e06ffULL,
0x00005f00241f7a11ULL, 0x000fe200020f4421ULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x00005e0028207a11ULL, 0x000fe200078640ffULL, 0x000000100f127825ULL, 0x040fe200078e0012ULL,
0x00005e002c227a11ULL, 0x000fe200078040ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010297faeULL, 0x0003e2000b901c46ULL, 0x00005e0030247a11ULL, 0x000fe200078240ffULL,
0x000000100f1c7825ULL, 0x000fe200078e001cULL, 0x00005e0027267a11ULL, 0x000fe200078440ffULL,
0x00000000122b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0028217a11ULL, 0x000fe200018f4421ULL,
0x000000100f1e7825ULL, 0x040fe200078e001eULL, 0x00005f002c237a11ULL, 0x000fe200000f4423ULL,
0x000000001c2d7faeULL, 0x0003e2000b901c46ULL, 0x00005f0030257a11ULL, 0x000fe200008f4425ULL,
0x000000100f207825ULL, 0x000fe200078e0020ULL, 0x00005f0027277a11ULL, 0x000fe200010f4408ULL,
0x000000001e2f7faeULL, 0x0003e4000b901c46ULL, 0x000000100f227825ULL, 0x000fc400078e0022ULL,
0x0000000020317faeULL, 0x0003e4000b901c46ULL, 0x000000100f247825ULL, 0x040fe400078e0024ULL,
0x0000000022337faeULL, 0x0003e4000b901c46ULL, 0x000000100f267825ULL, 0x000fe400078e0026ULL,
0x0000000024517faeULL, 0x0003e8000b901c46ULL, 0x0000000026537faeULL, 0x0003e4000b901c46ULL,
0x0000000307087812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030800780cULL, 0x000fc80003f05270ULL, 0x0000000106087807ULL, 0x000fca0004000000ULL,
0x0000000107077824ULL, 0x000fe400078e0208ULL, 0xffffffffff087424ULL, 0x000fc600078e00ffULL,
0x000000160700720cULL, 0x000fda0003f06070ULL, 0x000000010c108824ULL, 0x002fe400078e0207ULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000600010108625ULL, 0x000fca00078e0011ULL,
0x0000000610088981ULL, 0x000362000c1e1900ULL, 0xffffffe0025e7812ULL, 0x040fe400078ec0ffULL,
0x00000010020f7812ULL, 0x040fe400078ec0ffULL, 0x0000000802127812ULL, 0x000fc800078ec0ffULL,
0x0000005e125e7210ULL, 0x000fe20007ffe00fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b608005e107f8cULL, 0x002fe8000c80043fULL, 0x01b60c005e137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000a000000947ULL, 0x000fea0003800000ULL,
0x00000020030f7824ULL, 0x000fe400078e020fULL, 0x3e000000ff127424ULL, 0x000fc400078e00ffULL,
0x000000080e0f7824ULL, 0x000fe400078e020fULL, 0x0000001200137305ULL, 0x0002a4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x004fe40003800000ULL,
0x01b60c000f137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010005f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff5d7819ULL, 0x000fc80000011600ULL, 0x000000705f5f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c5d5d7812ULL, 0x000fc600078ec0ffULL, 0x0000008003107824ULL, 0x000fc800078e025fULL,
0x0000000110107824ULL, 0x000fca00078e025dULL, 0x01b0000010127984ULL, 0x000e680000000800ULL,
0x01b2000010137984ULL, 0x0004e20000000800ULL, 0x000000091200720bULL, 0x002fe20003f1d000ULL,
0x00010a527f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0f1e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x000000600300720cULL, 0x000fe40003f05270ULL, 0x000000091200720bULL, 0x000fe20003f34000ULL,
0x00010a327f007947ULL, 0x000fd8000b800000ULL, 0x00000000000f7806ULL, 0x000fe400008e0100ULL,
0x0000001209117209ULL, 0x000fe20007810000ULL, 0x0000008060108824ULL, 0x000fe200078e025fULL,
0x0000ffff0f0f7812ULL, 0x000fc600078e3cffULL, 0x8000001109097221ULL, 0x000fe40000010000ULL,
0x000000015d108824ULL, 0x000fe400078e0210ULL, 0x3fb8aa3b09097820ULL, 0x000fc60000410000ULL,
0x01b4001110008388ULL, 0x0003e20000000800ULL, 0x0000000900207308ULL, 0x0002a20000000800ULL,
0x0000000f1eff7212ULL, 0x000fe4000780c0ffULL, 0x00000002ff0f7819ULL, 0x000fe20000011600ULL,
0x000109d27f007947ULL, 0x000ff0000b800000ULL, 0x00001f0f20097589ULL, 0x0062a400000e0000ULL,
0x000000080f0f7810ULL, 0x002fe20007ffe0ffULL, 0x00010a227f007947ULL, 0x000fea000b800000ULL,
0x00001f0f202f7589ULL, 0x00032400000e0000ULL, 0x8000001112120221ULL, 0x000fe20000010000ULL,
0x00000001ff107807ULL, 0x000fe20000000000ULL, 0x0000000919197220ULL, 0x004fe40000410000ULL,
0x3fb8aa3b12120820ULL, 0x000fc40000410000ULL, 0x0000000918187220ULL, 0x080fe40000410000ULL,
0x00000012000d0308ULL, 0x000ea20000000800ULL, 0x0000000935357220ULL, 0x080fe40000410000ULL,
0x0000000934347220ULL, 0x080fe40000410000ULL, 0x0000000939397220ULL, 0x080fe40000410000ULL,
0x0000000938387220ULL, 0x080fe40000410000ULL, 0x000000093d3d7220ULL, 0x000fc40000410000ULL,
0x000000093c3c7220ULL, 0x080fe40000410000ULL, 0x0000000941417220ULL, 0x080fe40000410000ULL,
0x0000000940407220ULL, 0x080fe40000410000ULL, 0x0000000945457220ULL, 0x080fe40000410000ULL,
0x0000000944447220ULL, 0x080fe40000410000ULL, 0x0000000949497220ULL, 0x000fc40000410000ULL,
0x0000000948487220ULL, 0x080fe40000410000ULL, 0x000000094d4d7220ULL, 0x080fe40000410000ULL,
0x000000094c4c7220ULL, 0x000fe40000410000ULL, 0x000000200a0a7220ULL, 0x000fe40000410000ULL,
0x0000002f1b1b7220ULL, 0x090fe40000410000ULL, 0x0000002f1a1a7220ULL, 0x000fc40000410000ULL,
0x0000002f37377220ULL, 0x080fe40000410000ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f3b3b7220ULL, 0x080fe40000410000ULL, 0x0000002f3a3a7220ULL, 0x080fe40000410000ULL,
0x0000002f3f3f7220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x000fc40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f47477220ULL, 0x080fe40000410000ULL, 0x0000002f46467220ULL, 0x080fe40000410000ULL,
0x0000002f4b4b7220ULL, 0x080fe40000410000ULL, 0x0000002f4a4a7220ULL, 0x000fc40000410000ULL,
0x0000002f4f4f7220ULL, 0x080fe40000410000ULL, 0x0000002f4e4e7220ULL, 0x000fe40000410000ULL,
0x000000ffff097224ULL, 0x000fe400078e0011ULL, 0x0000000d13130220ULL, 0x00cfe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000dff0f723eULL, 0x002fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff117819ULL, 0x000fe40000011600ULL,
0x000054100f1e7816ULL, 0x000fe2000000000fULL, 0x000107b27f007947ULL, 0x000fea000b800000ULL,
0x00000008115c7810ULL, 0x000fe20007ffe0ffULL, 0x00001f111e637589ULL, 0x0002a800000e0000ULL,
0x00001f5c1e627589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000010111f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x00002df0001c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fc400078e00ffULL,
0x000115d000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x00000018111f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x00002e50001c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fc400078e00ffULL,
0x0001157000007944ULL, 0x03cfea0003c00000ULL, 0x0000000260657824ULL, 0x000fe200078e00ffULL,
0x00000004ff6a7819ULL, 0x000fe20000011600ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000007000f7812ULL, 0x000fe200078ec0ffULL, 0x0000000a130a7221ULL, 0x008fe20000010000ULL,
0x0000000465117812ULL, 0x002fc400078ec0ffULL, 0x000000080f127812ULL, 0x000fc600078ef800ULL,
0x000000016a1d7824ULL, 0x000fca00078e0211ULL, 0x000000071d117812ULL, 0x000fca00078e7812ULL,
0x0000000812117824ULL, 0x000fc800078e0211ULL, 0x0000001011767824ULL, 0x000fe200078e00ffULL,
0x0000000800117812ULL, 0x000fc600078ec0ffULL, 0x00000800032c7824ULL, 0x000fc600078e0276ULL,
0x000000021d1f7810ULL, 0x000fe20007ffe0ffULL, 0x00002000601d7824ULL, 0x000fe200078e00ffULL,
0x0000000711137812ULL, 0x000fe200078ec800ULL, 0x011000002c2c783bULL, 0x004e620000000200ULL,
0x000000026a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000020000e6c7824ULL, 0x000fe200078e00ffULL,
0xffffc0001d1d7812ULL, 0x000fe400078ec0ffULL, 0x000000046a1e7810ULL, 0x040fe40007ffe0ffULL,
0x000000066a207810ULL, 0x000fe20007ffe0ffULL, 0x000020000e747824ULL, 0x000fe200078e021dULL,
0x0000006a136a7212ULL, 0x000fc400078e3cffULL, 0x0000001c131c7212ULL, 0x040fe400078e3cffULL,
0x0000001e131e7212ULL, 0x040fe400078e3cffULL, 0x0000002013207212ULL, 0x000fe200078e3cffULL,
0x0000100077137824ULL, 0x000fe200078e0274ULL, 0x0000000711117812ULL, 0x000fe400078ef800ULL,
0x000000071f1f7812ULL, 0x000fe400078e7812ULL, 0x0001300013137810ULL, 0x000fe20007ffe0ffULL,
0x0000000811757824ULL, 0x040fe200078e026aULL, 0x00000080111d7811ULL, 0x040fe200078e18ffULL,
0x0000000811737824ULL, 0x040fe200078e021cULL, 0x0000991010217816ULL, 0x000fe200000000ffULL,
0x0000000811727824ULL, 0x000fc400078e021eULL, 0x0000000811707824ULL, 0x000fe200078e0220ULL,
0x000000ff2100720cULL, 0x000fe20003f05270ULL, 0x0000001075587824ULL, 0x100fe400078e0213ULL,
0x0000001073547824ULL, 0x100fe400078e0213ULL, 0x0000001072507824ULL, 0x100fe400078e0213ULL,
0x0000001070307824ULL, 0x000fe200078e0213ULL, 0x000000005858783bULL, 0x000ea20000004200ULL,
0x00000008121f7824ULL, 0x000fc400078e021fULL, 0x0000400005127824ULL, 0x000fe200078e026cULL,
0x000000005454783bULL, 0x000ee20000004200ULL, 0x000000101f647824ULL, 0x000fe200078e00ffULL,
0x000000632c2c8231ULL, 0x082fe200003400ffULL, 0x00001000771f7824ULL, 0x000fe200078e0212ULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x0000080003107824ULL, 0x000fe200078e0264ULL,
0x000000632e2e8231ULL, 0x000fe200003400ffULL, 0x000000016a6a7824ULL, 0x100fe200078e021dULL,
0x000000003030783bULL, 0x000fe20000004200ULL, 0x000130001f1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000011c697824ULL, 0x100fe200078e021dULL, 0x000000622d2d8231ULL, 0x090fe200003400ffULL,
0x000000011e687824ULL, 0x100fe200078e021dULL, 0x011000001010783bULL, 0x000e620000000200ULL,
0x0000000120667824ULL, 0x000fe200078e021dULL, 0x000000622f2f8231ULL, 0x000fe200003400ffULL,
0x000000106a287824ULL, 0x000fc400078e021fULL, 0x0000001069247824ULL, 0x100fe400078e021fULL,
0x0000001068207824ULL, 0x100fe400078e021fULL, 0x00000010661f7824ULL, 0x000fe200078e021fULL,
0x000000002828783bULL, 0x000f280000004200ULL, 0x000000002424783bULL, 0x000f280000004200ULL,
0x000000002020783bULL, 0x000f280000004200ULL, 0x000000001f1c783bULL, 0x000f220000004200ULL,
0x000000582c4c723cULL, 0x044ff0000004184cULL, 0x0000005a2c48723cULL, 0x040ff00000041848ULL,
0x000000542c44723cULL, 0x008fe20000041844ULL, 0x0000006310108231ULL, 0x002fc400003400ffULL,
0x0000006312128231ULL, 0x000fe400003400ffULL, 0x0000006211118231ULL, 0x080fe400003400ffULL,
0x0000006213138231ULL, 0x000fe200003400ffULL, 0x000000562c40723cULL, 0x000fe20000041840ULL,
0xfffffff865627812ULL, 0x000fce00078ec0ffULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028104c723cULL, 0x050ff0000004184cULL,
0x0000002a1048723cULL, 0x040ff00000041848ULL, 0x000000241044723cULL, 0x040ff00000041844ULL,
0x000000261040723cULL, 0x040ff00000041840ULL, 0x00000020103c723cULL, 0x040ff0000004183cULL,
0x000000221038723cULL, 0x040ff00000041838ULL, 0x0000001c1034723cULL, 0x040ff00000041834ULL,
0x0000001e1018723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000004015107811ULL, 0x000fe200078e40ffULL, 0x01b6880062ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000177777812ULL, 0x000fc400078e0cffULL, 0x000000171000720cULL, 0x000fda0003f06070ULL,
0x00004e1000000947ULL, 0x000fea0003800000ULL, 0x0000001060107824ULL, 0x002fe200078e00ffULL,
0x0000000115117810ULL, 0x000fe20007ffe0ffULL, 0x0000580008087a24ULL, 0x020fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000141100720cULL, 0x000fe20003f06070ULL,
0x0000004008087824ULL, 0x000fe200078e00ffULL, 0xffffffe010107812ULL, 0x000fca00078ec0ffULL,
0x0000010015107824ULL, 0x000fca00078e0210ULL, 0x0000008010127810ULL, 0x000fc80007ffe0ffULL,
0x0000002061257812ULL, 0x000fe200078ef812ULL, 0x0000076000008947ULL, 0x000fea0003800000ULL,
0x0000200060137824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fe20000011600ULL,
0x000010000b107824ULL, 0x000fe200078e00ffULL, 0x0000001217117217ULL, 0x000fe40007800000ULL,
0x00002000131c7812ULL, 0x000fe200078ec0ffULL, 0x0000000127137824ULL, 0x040fe200078e0225ULL,
0x00000004271d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111117824ULL, 0x000fe200078e0a12ULL,
0x0000100010107812ULL, 0x000fe200078ec0ffULL, 0x0000400005297824ULL, 0x000fe200078e021cULL,
0x000000001d127212ULL, 0x040fe200078e3cffULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x00000008271f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001308137210ULL, 0x000fe40007f1e0ffULL,
0x0001300029297810ULL, 0x000fe40007ffe010ULL, 0xfffffff8212c7812ULL, 0x000fe200078ee212ULL,
0x000000081f217824ULL, 0x000fe200078e00ffULL, 0x0000002011287817ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x000000001f127212ULL, 0x000fe200078e3cffULL,
0x000000011d117824ULL, 0x000fe200078e0225ULL, 0x00005e0013227a11ULL, 0x000fc400078040ffULL,
0x0000000c272f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8212e7812ULL, 0x000fe400078ee212ULL,
0x00005f0013237a11ULL, 0x000fe200000f4410ULL, 0x000000012f137824ULL, 0x100fe200078e0225ULL,
0x0000001108127210ULL, 0x040fe20007f1e0ffULL, 0x000000011f117824ULL, 0x040fe200078e0225ULL,
0x000000281f00720cULL, 0x000fe20003f26070ULL, 0x000000082f307824ULL, 0x000fe200078e00ffULL,
0x0000001308137210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x00000011081f7210ULL, 0x000fc40007f7e0ffULL, 0x00005e0012107a11ULL, 0x040fe200078040ffULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x0000001027317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x00005f0012117a11ULL, 0x000fe400000f4421ULL,
0x00005e001f207a11ULL, 0x000fe400078040ffULL, 0x000000281d00720cULL, 0x000fe20003f46070ULL,
0x00000001311d7824ULL, 0x000fe200078e0225ULL, 0x00005e00131e7a11ULL, 0x000fc400078640ffULL,
0x0000001427337810ULL, 0x000fe40007ffe0ffULL, 0x00005f001f217a11ULL, 0x000fe200000f4426ULL,
0x000000080e267824ULL, 0x000fe200078e00ffULL, 0x00005f00131f7a11ULL, 0x000fe200018f4424ULL,
0x0000000133137824ULL, 0x100fe200078e0225ULL, 0x0000001d081d7210ULL, 0x040fe40007fbe0ffULL,
0x0000001827537810ULL, 0x040fe40007ffe0ffULL, 0x0000001c27557810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200028e06ffULL, 0x0000001308247210ULL, 0x000fe20007f1e0ffULL,
0x0000000153137824ULL, 0x100fe200078e0225ULL, 0x00005e001d1c7a11ULL, 0x000fe200078840ffULL,
0x0000000155257824ULL, 0x000fe200078e0225ULL, 0x00000007272d7812ULL, 0x000fe200078e4800ULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x00005f001d1d7a11ULL, 0x000fc400020f4412ULL,
0x000000282700720cULL, 0x000fe40003f66070ULL, 0x0000001308277210ULL, 0x040fe40007f9e0ffULL,
0x0000002508257210ULL, 0x000fe40007fbe0ffULL, 0x00005e0024127a11ULL, 0x000fe200078040ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x0ffffff82d087812ULL, 0x000fe400078ef800ULL,
0x0000000826517812ULL, 0x000fc400078ee20fULL, 0x00005f0024137a11ULL, 0x000fe200000f442bULL,
0x00000010082b7824ULL, 0x000fe200078e0229ULL, 0x00005e0027267a11ULL, 0x000fe200078840ffULL,
0x000000ffff087224ULL, 0x000fe200028e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078a40ffULL,
0x0000001051227825ULL, 0x000fe200078e0022ULL, 0x00005f0027277a11ULL, 0x000fe400020f442aULL,
0x00005f0025257a11ULL, 0x000fe200028f4408ULL, 0x0000001051107825ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000222b7faeULL, 0x0003e2000d901c46ULL,
0x000000282f00720cULL, 0x000fc40003f06070ULL, 0x000000283100720cULL, 0x080fe20003f66070ULL,
0x0000001051207825ULL, 0x000fe200078e0020ULL, 0x000000283300720cULL, 0x080fe40003f86070ULL,
0x000000285300720cULL, 0x080fe20003fa6070ULL, 0x00000010511e7825ULL, 0x000fe200078e001eULL,
0x000000285500720cULL, 0x000fe40003fc6070ULL, 0x0000000031087212ULL, 0x0c0fe200078e3cffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x000000002f2d7212ULL, 0x080fe200078e3cffULL,
0x000000102c237824ULL, 0x002fe200078e0229ULL, 0x0000000033287212ULL, 0x0c0fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x00000000532a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x0000000055227212ULL, 0x040fe200078e3cffULL,
0x0000000855557824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee22dULL,
0x000000102e2b7824ULL, 0x000fe200078e0229ULL, 0xfffffff831087812ULL, 0x000fe200078ee208ULL,
0x00000010511c7825ULL, 0x000fe200078e001cULL, 0xfffffff833287812ULL, 0x000fe200078ee228ULL,
0x0000000010237faeULL, 0x0003e2000d101c46ULL, 0xfffffff8532a7812ULL, 0x000fe200078ee22aULL,
0x00000010302d7824ULL, 0x100fe200078e0229ULL, 0xfffffff855227812ULL, 0x000fe200078ee222ULL,
0x00000010082f7824ULL, 0x100fe200078e0229ULL, 0x00000000202b7faeULL, 0x0003e2000c901c46ULL,
0x0000001028317824ULL, 0x000fc400078e0229ULL, 0x0000001051127825ULL, 0x040fe200078e0012ULL,
0x000000001e2d7faeULL, 0x0003e6000c101c46ULL, 0x000000102a337824ULL, 0x000fe200078e0229ULL,
0x000000001c2f7faeULL, 0x0003e2000d901c46ULL, 0x0000001051267825ULL, 0x000fc600078e0026ULL,
0x0000000012317faeULL, 0x0003e2000e101c46ULL, 0x0000001022297824ULL, 0x000fe400078e0229ULL,
0x0000001051247825ULL, 0x000fe200078e0024ULL, 0x0000000026337faeULL, 0x0003e8000e901c46ULL,
0x0000000024297faeULL, 0x0003e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x00000003ff127819ULL, 0x000fe20000011600ULL, 0x0000200060107824ULL, 0x000fc400078e00ffULL,
0x000010000b117824ULL, 0x000fe200078e00ffULL, 0x00000008121f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e327824ULL, 0x000fe200078e00ffULL, 0x0000200010107812ULL, 0x000fe400078ec0ffULL,
0x000000001f207212ULL, 0x040fe200078e3cffULL, 0x000000081f237824ULL, 0x000fe200078e00ffULL,
0x0000000412137810ULL, 0x040fe20007ffe0ffULL, 0x0000400005107824ULL, 0x000fe200078e0210ULL,
0x0000100011117812ULL, 0x000fe200078ec0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0225ULL,
0xfffffff823227812ULL, 0x000fe200078ee220ULL, 0x0000000813217824ULL, 0x000fe200078e00ffULL,
0x0000001012237810ULL, 0x000fc40007ffe0ffULL, 0x00013000101d7810ULL, 0x000fe20007ffe011ULL,
0x0000000112117824ULL, 0x040fe200078e0225ULL, 0x0000000c12207810ULL, 0x040fe20007ffe0ffULL,
0x0000000823297824ULL, 0x000fe200078e00ffULL, 0x0000001412277810ULL, 0x000fe20007ffe0ffULL,
0x00000010222f7824ULL, 0x000fe200078e021dULL, 0x00000000131c7212ULL, 0x080fe200078e3cffULL,
0x0000000820247824ULL, 0x000fe200078e00ffULL, 0x0000000023267212ULL, 0x000fe200078e3cffULL,
0x00000008272b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8211e7812ULL, 0x000fe200078ee21cULL,
0x0000000113137824ULL, 0x100fe200078e0225ULL, 0x0000001108117210ULL, 0x000fe20007f1e0ffULL,
0x0000000123237824ULL, 0x000fe200078e0225ULL, 0xfffffff829267812ULL, 0x000fc400078ee226ULL,
0x0000000020217212ULL, 0x080fe200078e3cffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x0000000027287212ULL, 0x040fe200078e3cffULL, 0x0000000127277824ULL, 0x000fe200078e0225ULL,
0x0000001812297810ULL, 0x000fe20007ffe0ffULL, 0x0000001026337824ULL, 0x000fe200078e021dULL,
0x0000001c122c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824247812ULL, 0x000fe200078ee221ULL,
0x0000000120217824ULL, 0x100fe200078e0225ULL, 0xfffffff82b287812ULL, 0x000fe200078ee228ULL,
0x00000001292b7824ULL, 0x100fe200078e0225ULL, 0x00005e0011107a11ULL, 0x040fe200078040ffULL,
0x000000012c2d7824ULL, 0x000fe200078e0225ULL, 0x0000001f08207210ULL, 0x000fe20007fbe0ffULL,
0x000000082c307824ULL, 0x000fe200078e00ffULL, 0x00005f0011117a11ULL, 0x000fe200000f441cULL,
0x0000001024317824ULL, 0x100fe200078e021dULL, 0x00000013081c7210ULL, 0x000fe20007fde0ffULL,
0x0000001028517824ULL, 0x000fe200078e021dULL, 0x0000002108217210ULL, 0x000fc40007f9e0ffULL,
0x0000002308237210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x0000002708257210ULL, 0x040fe40007f1e0ffULL, 0x0000002b082a7210ULL, 0x040fe40007f3e0ffULL,
0x0000002d082e7210ULL, 0x000fe20007f5e0ffULL, 0x000000101e2d7824ULL, 0x000fe200078e021dULL,
0x0000000029087212ULL, 0x0c0fe200078e3cffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x0000000712137812ULL, 0x000fe200078e4800ULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x000000002c277212ULL, 0x000fe200078e3cffULL, 0x000000ffff557224ULL, 0x000fe200010e06ffULL,
0xfffffff8292c7812ULL, 0x000fc400078ee208ULL, 0x0ffffff813087812ULL, 0x000fe400078ef800ULL,
0x00005e001c127a11ULL, 0x000fe200078c40ffULL, 0x000000102c537824ULL, 0x000fe200078e021dULL,
0xfffffff830307812ULL, 0x000fe200078ee227ULL, 0x00000010082b7824ULL, 0x000fe200078e021dULL,
0x00005f001c137a11ULL, 0x000fe200030f441fULL, 0x000000ffff087224ULL, 0x000fe200020e06ffULL,
0x00005e00211c7a11ULL, 0x040fe200078840ffULL, 0x000000ffff1f7224ULL, 0x000fe200028e06ffULL,
0x00005e00201e7a11ULL, 0x000fe200078a40ffULL, 0x0000001030577824ULL, 0x000fe200078e021dULL,
0x00005f00211d7a11ULL, 0x000fe200020f4408ULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x0000000832297812ULL, 0x000fe200078ee20fULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x00005e0023267a11ULL, 0x000fc400078640ffULL, 0x00005e0025247a11ULL, 0x000fe200078040ffULL,
0x0000001029107825ULL, 0x040fe200078e0010ULL, 0x00005f00201f7a11ULL, 0x000fe400028f441fULL,
0x00005e002a227a11ULL, 0x000fe200078240ffULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00005e002e207a11ULL, 0x000fe200078440ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0023277a11ULL, 0x000fe200018f4408ULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x00005f0025257a11ULL, 0x000fe200000f4428ULL,
0x00000000122d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002a237a11ULL, 0x000fe200008f4421ULL,
0x00000010291c7825ULL, 0x040fe200078e001cULL, 0x00005f002e217a11ULL, 0x000fe200010f4455ULL,
0x000000001e2f7faeULL, 0x0003e4000b901c46ULL, 0x0000001029267825ULL, 0x000fc400078e0026ULL,
0x000000001c317faeULL, 0x0003e4000b901c46ULL, 0x0000001029247825ULL, 0x040fe400078e0024ULL,
0x0000000026337faeULL, 0x0003e4000b901c46ULL, 0x0000001029227825ULL, 0x040fe400078e0022ULL,
0x0000000024517faeULL, 0x0003e4000b901c46ULL, 0x0000001029207825ULL, 0x000fc400078e0020ULL,
0x0000000022537faeULL, 0x0003e8000b901c46ULL, 0x0000000020577faeULL, 0x0003e4000b901c46ULL,
0x0000000307087812ULL, 0x000fc800078ec0ffULL, 0x000000030800780cULL, 0x000fc80003f05270ULL,
0x0000000106087807ULL, 0x000fca0004000000ULL, 0x0000000107077824ULL, 0x000fe400078e0208ULL,
0xffffffffff087424ULL, 0x000fc600078e00ffULL, 0x000000160700720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010c107824ULL, 0x002fe400078e0207ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610087981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b628005e107f8cULL, 0x002fe8000c80043fULL,
0x01b62c005e137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff127424ULL, 0x000fc800078e00ffULL,
0x0000001200137305ULL, 0x0002a4000021f000ULL, 0x3fa0000012127823ULL, 0x002fe200000100ffULL,
0x000000130000735dULL, 0x004fe40003800000ULL, 0x01b62c005e137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fc40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002060107824ULL, 0x000fca00078e00ffULL, 0xffffff8010107812ULL, 0x000fc800078ec0ffULL,
0x000000805f107810ULL, 0x000fca0007ffe010ULL, 0x000000015d107824ULL, 0x000fca00078e0210ULL,
0x01b0000010127984ULL, 0x000e680000000800ULL, 0x01b2000010137984ULL, 0x0004e20000000800ULL,
0x000000091200720bULL, 0x002fe20003f1d000ULL, 0x0000f0327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff101e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000103117810ULL, 0x000fe40007ffe0ffULL,
0x000000091200720bULL, 0x000fe40003f34000ULL, 0x000000601100720cULL, 0x000fe20003f05270ULL,
0x0000f0027f007947ULL, 0x000ff4000b800000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x0000001209207209ULL, 0x040fe20007810000ULL, 0x00000080601c8824ULL, 0x000fe200078e025fULL,
0x0000ffff10117812ULL, 0x000fe400078e3cffULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x8000002009097221ULL, 0x000fc40000010000ULL, 0x000000015d1d8824ULL, 0x000fe400078e021cULL,
0x3fb8aa3b09097820ULL, 0x000fc60000410000ULL, 0x01b400201d008388ULL, 0x0003e20000000800ULL,
0x000000111eff7212ULL, 0x000fe4000780c0ffULL, 0x0000000900097308ULL, 0x000ea40000000800ULL,
0x000000090a0a7220ULL, 0x004fe20000410000ULL, 0x0000ef927f007947ULL, 0x000fec000b800000ULL,
0x00001f1f092f7589ULL, 0x0022a400000e0000ULL, 0x0000002f4c4c7220ULL, 0x084fe40000410000ULL,
0x0000002f4d4d7220ULL, 0x080fe40000410000ULL, 0x0000002f48487220ULL, 0x000fc40000410000ULL,
0x0000002f49497220ULL, 0x080fe40000410000ULL, 0x0000002f44447220ULL, 0x080fe40000410000ULL,
0x0000002f45457220ULL, 0x080fe40000410000ULL, 0x0000002f40407220ULL, 0x080fe40000410000ULL,
0x0000002f41417220ULL, 0x080fe40000410000ULL, 0x0000002f3c3c7220ULL, 0x000fc40000410000ULL,
0x0000002f3d3d7220ULL, 0x080fe40000410000ULL, 0x0000002f38387220ULL, 0x080fe40000410000ULL,
0x0000002f39397220ULL, 0x080fe40000410000ULL, 0x0000002f34347220ULL, 0x080fe40000410000ULL,
0x0000002f35357220ULL, 0x080fe40000410000ULL, 0x0000002f18187220ULL, 0x000fc40000410000ULL,
0x0000002f19197220ULL, 0x000fe20000410000ULL, 0x0000eed27f007947ULL, 0x000fea000b800000ULL,
0x00001f5c092f7589ULL, 0x00052400000e0000ULL, 0x8000002012120221ULL, 0x000fe20000010000ULL,
0x00000001ff107807ULL, 0x000fe20000000000ULL, 0x0000002f4e4e7220ULL, 0x094fe40000410000ULL,
0x3fb8aa3b12120820ULL, 0x000fe40000410000ULL, 0x0000002f4f4f7220ULL, 0x080fe40000410000ULL,
0x00000012000d0308ULL, 0x000ea20000000800ULL, 0x0000002f4a4a7220ULL, 0x000fc40000410000ULL,
0x0000002f4b4b7220ULL, 0x080fe40000410000ULL, 0x0000002f46467220ULL, 0x080fe40000410000ULL,
0x0000002f47477220ULL, 0x080fe40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x000fc40000410000ULL,
0x0000002f3f3f7220ULL, 0x080fe40000410000ULL, 0x0000002f3a3a7220ULL, 0x080fe40000410000ULL,
0x0000002f3b3b7220ULL, 0x080fe40000410000ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f37377220ULL, 0x080fe40000410000ULL, 0x0000002f1a1a7220ULL, 0x000fc40000410000ULL,
0x0000002f1b1b7220ULL, 0x000fe40000410000ULL, 0x000000ffff097224ULL, 0x002fe400078e0020ULL,
0x000000130d130220ULL, 0x00cfe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000dff1c723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff1f7819ULL, 0x000fe40000011600ULL, 0x000054101c1e7816ULL, 0x000fe4000000001cULL,
0x000000181f117810ULL, 0x040fe40007ffe0ffULL, 0x000000101f127810ULL, 0x000fe20007ffe0ffULL,
0x0000ed527f007947ULL, 0x000fea000b800000ULL, 0x00001f1f1e777589ULL, 0x0002a800000e0000ULL,
0x00001f5c1e787589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e0012ULL, 0x00004ab0001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000f91000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e0011ULL, 0x00004b10001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000f8b000007944ULL, 0x03cfea0003c00000ULL, 0x0000020060117824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000a130a7221ULL, 0x008fc60000010000ULL,
0xfffff80011117812ULL, 0x000fca00078ec0ffULL, 0x0000000176767824ULL, 0x000fc800078e0211ULL,
0x000010000b797824ULL, 0x000fe200078e00ffULL, 0x01180000762c783bULL, 0x004ea20000000200ULL,
0x00004000051e7824ULL, 0x002fe200078e026cULL, 0x00009910101c7816ULL, 0x000fe200000000ffULL,
0x00000001646b7824ULL, 0x000fe200078e0211ULL, 0x0000100079797812ULL, 0x000fe400078e0cffULL,
0x000000ff1c00720cULL, 0x000fe40003f05270ULL, 0x00013000746d7810ULL, 0x100fe20007ffe079ULL,
0x011800006b10783bULL, 0x000e620000000200ULL, 0x000130001e637810ULL, 0x000fc60007ffe079ULL,
0x0000001075717824ULL, 0x100fe400078e026dULL, 0x00000010736f7824ULL, 0x100fe400078e026dULL,
0x00000010726e7824ULL, 0x100fe200078e026dULL, 0x000000007158783bULL, 0x000ee20000004200ULL,
0x00000010706d7824ULL, 0x000fe400078e026dULL, 0x000000106a677824ULL, 0x100fe200078e0263ULL,
0x000000006f54783bULL, 0x000f220000004200ULL, 0x0000001069657824ULL, 0x000fc400078e0263ULL,
0x0000001068647824ULL, 0x100fe200078e0263ULL, 0x000000006e50783bULL, 0x000f220000004200ULL,
0x0000001066637824ULL, 0x000fc600078e0263ULL, 0x000000006d30783bULL, 0x000f280000004200ULL,
0x000000006728783bULL, 0x000f280000004200ULL, 0x000000006524783bULL, 0x000f220000004200ULL,
0x000000772c2c8231ULL, 0x004fc600003400ffULL, 0x000000006420783bULL, 0x000ea20000004200ULL,
0x000000772e2e8231ULL, 0x080fe400003400ffULL, 0x000000782d2d8231ULL, 0x090fe200003400ffULL,
0x00000000631c783bULL, 0x000f220000004200ULL, 0x000000782f2f8231ULL, 0x080fe400003400ffULL,
0x0000007710108231ULL, 0x082fe400003400ffULL, 0x0000007712128231ULL, 0x000fe400003400ffULL,
0x0000007811118231ULL, 0x000fc400003400ffULL, 0x0000007813138231ULL, 0x000fe200003400ffULL,
0x000000582c4c723cULL, 0x048ff0000004184cULL, 0x0000005a2c48723cULL, 0x040ff00000041848ULL,
0x000000542c44723cULL, 0x040ff00000041844ULL, 0x000000562c40723cULL, 0x040ff00000041840ULL,
0x000000502c3c723cULL, 0x040ff0000004183cULL, 0x000000522c38723cULL, 0x040ff00000041838ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x00000028104c723cULL, 0x040ff0000004184cULL, 0x0000002a1048723cULL, 0x040ff00000041848ULL,
0x000000241044723cULL, 0x040ff00000041844ULL, 0x000000261040723cULL, 0x040ff00000041840ULL,
0x00000020103c723cULL, 0x044ff0000004183cULL, 0x000000221038723cULL, 0x040ff00000041838ULL,
0x0000001c1034723cULL, 0x050ff00000041834ULL, 0x0000001e1018723cULL, 0x000fe20000041818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008015107811ULL, 0x000fe200078e40ffULL,
0x01b6900062ff7f8cULL, 0x0003e2000c80043fULL, 0x000000010b777812ULL, 0x000fc400078ec0ffULL,
0x000000171000720cULL, 0x000fda0003f06070ULL, 0x0000338000000947ULL, 0x000fea0003800000ULL,
0x0000001060107824ULL, 0x002fe200078e00ffULL, 0x0000000115117810ULL, 0x000fe20007ffe0ffULL,
0x0000580008087a24ULL, 0x020fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000141100720cULL, 0x000fe20003f06070ULL, 0x0000004008087824ULL, 0x000fe200078e00ffULL,
0xffffffe010107812ULL, 0x000fca00078ec0ffULL, 0x0000010015107824ULL, 0x000fca00078e0210ULL,
0x000000c010127810ULL, 0x000fc80007ffe0ffULL, 0x00000020611e7812ULL, 0x000fe200078ef812ULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x00000003ff297819ULL, 0x000fe20000011600ULL,
0x0000200060117824ULL, 0x000fe200078e00ffULL, 0x0000001217107217ULL, 0x000fe20007800000ULL,
0x000000080e307824ULL, 0x000fe200078e00ffULL, 0x00000004291d7810ULL, 0x000fe40007ffe0ffULL,
0x00002000111c7812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a12ULL,
0x000000001d127212ULL, 0x0c0fe200078e3cffULL, 0x000000081d137824ULL, 0x000fe200078e00ffULL,
0x00000008291f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000129117824ULL, 0x000fe200078e021eULL,
0x0000002010287817ULL, 0x000fe20003800000ULL, 0x00004000051c7824ULL, 0x000fe200078e021cULL,
0xfffffff8132c7812ULL, 0x000fe200078ee212ULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x0000001108127210ULL, 0x000fe20007f1e0ffULL, 0x000000011d117824ULL, 0x000fe200078e021eULL,
0x000000001f107212ULL, 0x000fc400078e3cffULL, 0x0000000c292b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x00005e0012267a11ULL, 0x040fe400078040ffULL,
0xfffffff8212e7812ULL, 0x000fe400078ee210ULL, 0x00005f0012277a11ULL, 0x000fe400000f4413ULL,
0x0000001108107210ULL, 0x000fe20007f1e0ffULL, 0x000000011f117824ULL, 0x000fe200078e021eULL,
0x00000010292f7810ULL, 0x000fc40007ffe0ffULL, 0x000000281d00720cULL, 0x080fe20003f46070ULL,
0x000000012b1d7824ULL, 0x100fe200078e021eULL, 0x000000281f00720cULL, 0x000fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x0000001108117210ULL, 0x000fe20007f7e0ffULL,
0x000000012f1f7824ULL, 0x000fe200078e021eULL, 0x00005e0010127a11ULL, 0x000fe400078040ffULL,
0x0000001d081d7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005f0010137a11ULL, 0x000fc400000f4413ULL, 0x0000001f081f7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x00005e0011247a11ULL, 0x000fe400078040ffULL,
0x0000001429317810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200028e06ffULL,
0x000130001c797810ULL, 0x000fe40007ffe079ULL, 0x00005e001d227a11ULL, 0x000fe400078640ffULL,
0x00005f0011257a11ULL, 0x000fe200000f442aULL, 0x0000000131117824ULL, 0x000fe200078e021eULL,
0x00005e001f1c7a11ULL, 0x000fc400078840ffULL, 0x00005f001d237a11ULL, 0x000fe400018f4420ULL,
0x00005f001f1d7a11ULL, 0x000fe400020f4410ULL, 0x0000001829517810ULL, 0x040fe40007ffe0ffULL,
0x0000001108107210ULL, 0x000fe40007f1e0ffULL, 0x0000001c29537810ULL, 0x000fe20007ffe0ffULL,
0x0000000151117824ULL, 0x100fe200078e021eULL, 0x000000282900720cULL, 0x000fe20003f66070ULL,
0x000000ffff217224ULL, 0x000fe200000e06ffULL, 0x00005e0010207a11ULL, 0x000fe200078040ffULL,
0x00000001531f7824ULL, 0x000fe200078e021eULL, 0x0000000729297812ULL, 0x000fc400078e4800ULL,
0x00000011082a7210ULL, 0x000fe40007f9e0ffULL, 0x00005f0010217a11ULL, 0x000fe400000f4421ULL,
0x0000001f08087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e06ffULL,
0x0ffffff829107812ULL, 0x000fe400078ef800ULL, 0x0000000830337812ULL, 0x000fe200078ee20fULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005e002a1e7a11ULL, 0x000fe200078840ffULL,
0x0000001010297824ULL, 0x000fe200078e0279ULL, 0x00005e0008107a11ULL, 0x000fe200078a40ffULL,
0x0000001033267825ULL, 0x000fe200078e0026ULL, 0x00005f002a1f7a11ULL, 0x000fc400020f441fULL,
0x00005f0008117a11ULL, 0x000fe200028f4411ULL, 0x000000082b307824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e2000d901c46ULL,
0x000000282b00720cULL, 0x080fe20003f06070ULL, 0x0000001033127825ULL, 0x000fe200078e0012ULL,
0x000000282f00720cULL, 0x080fe40003f66070ULL, 0x000000283100720cULL, 0x080fe20003f86070ULL,
0x0000001033247825ULL, 0x000fe200078e0024ULL, 0x000000285100720cULL, 0x080fe40003fa6070ULL,
0x000000285300720cULL, 0x000fe20003fc6070ULL, 0x0000001033227825ULL, 0x000fe200078e0022ULL,
0x000000002f087212ULL, 0x000fc400078e3cffULL, 0x000000002b2d7212ULL, 0x080fe200078e3cffULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x0000000031287212ULL, 0x0c0fe200078e3cffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x00000000512a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x0000000053267212ULL, 0x042fe200078e3cffULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee22dULL,
0x000000102c277824ULL, 0x100fe200078e0279ULL, 0xfffffff82f087812ULL, 0x000fe200078ee208ULL,
0x000000102e297824ULL, 0x100fe200078e0279ULL, 0xfffffff831287812ULL, 0x000fe200078ee228ULL,
0x00000010302b7824ULL, 0x100fe200078e0279ULL, 0xfffffff8512a7812ULL, 0x000fe200078ee22aULL,
0x00000010082d7824ULL, 0x000fe200078e0279ULL, 0xfffffff853267812ULL, 0x000fe200078ee226ULL,
0x00000010331c7825ULL, 0x040fe200078e001cULL, 0x0000000012277faeULL, 0x0003e6000d101c46ULL,
0x00000010282f7824ULL, 0x000fe200078e0279ULL, 0x0000000024297faeULL, 0x0003e2000c901c46ULL,
0x0000001033207825ULL, 0x000fc600078e0020ULL, 0x00000000222b7faeULL, 0x0003e2000c101c46ULL,
0x000000102a317824ULL, 0x000fe400078e0279ULL, 0x00000010331e7825ULL, 0x040fe200078e001eULL,
0x000000001c2d7faeULL, 0x0003e6000d901c46ULL, 0x0000001026797824ULL, 0x000fe200078e0279ULL,
0x00000000202f7faeULL, 0x0003e2000e101c46ULL, 0x0000001033107825ULL, 0x000fc600078e0010ULL,
0x000000001e317faeULL, 0x0003e8000e901c46ULL, 0x0000000010797faeULL, 0x0003e2000f101c46ULL,
0x0000068000007947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x0000200060107824ULL, 0x000fe400078e00ffULL, 0x000000080e327824ULL, 0x000fe200078e00ffULL,
0x00000008131f7810ULL, 0x040fe40007ffe0ffULL, 0x00000004131d7810ULL, 0x000fc40007ffe0ffULL,
0x000000001f127212ULL, 0x0c0fe200078e3cffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x000000001d117212ULL, 0x0c0fe200078e3cffULL, 0x000000081d207824ULL, 0x040fe200078e00ffULL,
0x0000200010107812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e021eULL,
0xfffffff821227812ULL, 0x000fe200078ee212ULL, 0x000000011f1f7824ULL, 0x000fe200078e021eULL,
0x0000000c13217810ULL, 0x000fe20007ffe0ffULL, 0x0000400005107824ULL, 0x000fe200078e0210ULL,
0xfffffff820207812ULL, 0x000fe200078ee211ULL, 0x0000000113117824ULL, 0x140fe200078e021eULL,
0x0000001413277810ULL, 0x000fe20007ffe0ffULL, 0x0000000821297824ULL, 0x040fe200078e00ffULL,
0x00000000211c7212ULL, 0x040fe200078e3cffULL, 0x0000000121217824ULL, 0x000fe200078e021eULL,
0x0000001013237810ULL, 0x000fe20007ffe0ffULL, 0x00000008272b7824ULL, 0x000fe200078e00ffULL,
0x0000001108117210ULL, 0x000fc40007f1e0ffULL, 0xfffffff829247812ULL, 0x000fe200078ee21cULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0x0000000027287212ULL, 0x080fe200078e3cffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x0000001813297810ULL, 0x000fe20007ffe0ffULL,
0x0000000127277824ULL, 0x100fe200078e021eULL, 0x0000001c132d7810ULL, 0x000fe40007ffe0ffULL,
0x0001300010797810ULL, 0x000fe40007ffe079ULL, 0x0000000023257212ULL, 0x040fe200078e3cffULL,
0x0000000123237824ULL, 0x000fe200078e021eULL, 0xfffffff82b287812ULL, 0x000fe200078ee228ULL,
0x00000001292b7824ULL, 0x100fe200078e021eULL, 0x00005e0011107a11ULL, 0x000fe200078040ffULL,
0x000000012d2f7824ULL, 0x000fe200078e021eULL, 0xfffffff826267812ULL, 0x000fe200078ee225ULL,
0x0000001028517824ULL, 0x100fe200078e0279ULL, 0x00005f0011117a11ULL, 0x000fe200000f4412ULL,
0x0000001024317824ULL, 0x100fe200078e0279ULL, 0x0000001d081d7210ULL, 0x000fe20007fde0ffULL,
0x0000001026337824ULL, 0x000fe200078e0279ULL, 0x0000001f081f7210ULL, 0x000fc40007fbe0ffULL,
0x0000002108217210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000002308237210ULL, 0x040fe40007f7e0ffULL, 0x0000002708257210ULL, 0x040fe40007f1e0ffULL,
0x0000002b082a7210ULL, 0x040fe40007f3e0ffULL, 0x0000002f082e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x0000000029087212ULL, 0x0c0fe200078e3cffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x0000000713137812ULL, 0x000fe200078e4800ULL,
0x00000010222f7824ULL, 0x000fe200078e0279ULL, 0x000000002d1e7212ULL, 0x040fe200078e3cffULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8292c7812ULL, 0x000fe200078ee208ULL,
0x000000ffff557224ULL, 0x000fe200010e06ffULL, 0x0ffffff813087812ULL, 0x000fc400078ef800ULL,
0x00005e001d127a11ULL, 0x000fe200078c40ffULL, 0x000000102c537824ULL, 0x100fe200078e0279ULL,
0xfffffff82d307812ULL, 0x000fe200078ee21eULL, 0x00000010082b7824ULL, 0x100fe200078e0279ULL,
0x00005f001d137a11ULL, 0x000fe200030f441cULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0x00005e001f1e7a11ULL, 0x000fe200078a40ffULL, 0x00000010202d7824ULL, 0x000fe200078e0279ULL,
0x0000000832297812ULL, 0x000fe200078ee20fULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x00005e00211c7a11ULL, 0x000fe200078840ffULL, 0x0000001030797824ULL, 0x000fe200078e0279ULL,
0x00005f001f1f7a11ULL, 0x000fe200028f4408ULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005f00211d7a11ULL, 0x000fe200020f4420ULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x00005e0023267a11ULL, 0x000fe200078640ffULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x00005e0025247a11ULL, 0x000fc400078040ffULL, 0x00005e002a227a11ULL, 0x000fe200078240ffULL,
0x0000001029127825ULL, 0x000fe200078e0012ULL, 0x00005e002e207a11ULL, 0x000fe200078440ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x00005f0023277a11ULL, 0x000fe200018f4408ULL, 0x00000010291e7825ULL, 0x000fe200078e001eULL,
0x00005f0025257a11ULL, 0x000fe200000f4428ULL, 0x00000000122d7faeULL, 0x0003e2000b901c46ULL,
0x00005f002a237a11ULL, 0x000fe200008f4421ULL, 0x00000010291c7825ULL, 0x040fe200078e001cULL,
0x00005f002e217a11ULL, 0x000fe200010f4455ULL, 0x000000001e2f7faeULL, 0x0003e4000b901c46ULL,
0x0000001029267825ULL, 0x000fc400078e0026ULL, 0x000000001c317faeULL, 0x0003e4000b901c46ULL,
0x0000001029247825ULL, 0x040fe400078e0024ULL, 0x0000000026337faeULL, 0x0003e4000b901c46ULL,
0x0000001029227825ULL, 0x040fe400078e0022ULL, 0x0000000024517faeULL, 0x0003e4000b901c46ULL,
0x0000001029207825ULL, 0x000fc400078e0020ULL, 0x0000000022537faeULL, 0x0003e8000b901c46ULL,
0x0000000020797faeULL, 0x0003e4000b901c46ULL, 0x0000000307087812ULL, 0x000fc800078ec0ffULL,
0x000000030800780cULL, 0x000fc80003f05270ULL, 0x0000000106087807ULL, 0x000fca0004000000ULL,
0x0000000107077824ULL, 0x000fe400078e0208ULL, 0xffffffffff087424ULL, 0x000fc600078e00ffULL,
0x000000160700720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000010c107824ULL, 0x002fe400078e0207ULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610087981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b648005e107f8cULL, 0x002fe8000c80043fULL, 0x01b64c005e137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe0025e7812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff127424ULL, 0x000fe200078e00ffULL,
0x0000001002137812ULL, 0x000fc400078ec0ffULL, 0x00000008021c7812ULL, 0x000fc800078ec0ffULL,
0x0000005e1c5e7210ULL, 0x000fe40007ffe013ULL, 0x0000001200137305ULL, 0x0002a4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x004fe40003800000ULL,
0x01b64c005e137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002060107824ULL, 0x000fca00078e00ffULL,
0xffffff8010107812ULL, 0x000fc800078ec0ffULL, 0x000001005f107810ULL, 0x000fca0007ffe010ULL,
0x000000015d107824ULL, 0x000fca00078e0210ULL, 0x01b0000010127984ULL, 0x000e680000000800ULL,
0x01b2000010137984ULL, 0x0004e20000000800ULL, 0x000000091200720bULL, 0x002fe20003f1d000ULL,
0x0000d7f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800000e0100ULL,
0x0000ffff101e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000203117810ULL, 0x000fe40007ffe0ffULL, 0x000000091200720bULL, 0x000fe40003f34000ULL,
0x000000601100720cULL, 0x000fe20003f05270ULL, 0x0000d7c27f007947ULL, 0x000ff4000b800000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x00000012091c7209ULL, 0x040fe20007810000ULL,
0x0000008060208824ULL, 0x000fe200078e025fULL, 0x0000ffff101d7812ULL, 0x000fe400078e3cffULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x8000001c09117221ULL, 0x000fc40000010000ULL,
0x000000015d1f8824ULL, 0x000fe400078e0220ULL, 0x3fb8aa3b11117820ULL, 0x000fc60000410000ULL,
0x01b4001c1f008388ULL, 0x0003e20000000800ULL, 0x0000001d1eff7212ULL, 0x000fe4000780c0ffULL,
0x0000001100117308ULL, 0x000ea40000000800ULL, 0x000000110a0a7220ULL, 0x004fe20000410000ULL,
0x0000d7527f007947ULL, 0x000fec000b800000ULL, 0x00001f10112f7589ULL, 0x0022a400000e0000ULL,
0x0000002f4c4c7220ULL, 0x084fe40000410000ULL, 0x0000002f4d4d7220ULL, 0x080fe40000410000ULL,
0x0000002f48487220ULL, 0x000fc40000410000ULL, 0x0000002f49497220ULL, 0x080fe40000410000ULL,
0x0000002f44447220ULL, 0x080fe40000410000ULL, 0x0000002f45457220ULL, 0x080fe40000410000ULL,
0x0000002f40407220ULL, 0x080fe40000410000ULL, 0x0000002f41417220ULL, 0x080fe40000410000ULL,
0x0000002f3c3c7220ULL, 0x000fc40000410000ULL, 0x0000002f3d3d7220ULL, 0x080fe40000410000ULL,
0x0000002f38387220ULL, 0x080fe40000410000ULL, 0x0000002f39397220ULL, 0x080fe40000410000ULL,
0x0000002f34347220ULL, 0x080fe40000410000ULL, 0x0000002f35357220ULL, 0x080fe40000410000ULL,
0x0000002f18187220ULL, 0x000fc40000410000ULL, 0x0000002f19197220ULL, 0x000fe20000410000ULL,
0x0000d6a27f007947ULL, 0x000fea000b800000ULL, 0x00001f5c112f7589ULL, 0x00052400000e0000ULL,
0x0000001209097209ULL, 0x000fe20007810000ULL, 0x0000002f4e4e7220ULL, 0x094fe20000410000ULL,
0x00000001ff107807ULL, 0x002fe20000000000ULL, 0x0000002f4f4f7220ULL, 0x080fe40000410000ULL,
0x8000000912120221ULL, 0x000fe40000010000ULL, 0x0000002f4a4a7220ULL, 0x000fe40000410000ULL,
0x3fb8aa3b12120820ULL, 0x000fc40000410000ULL, 0x0000002f4b4b7220ULL, 0x080fe40000410000ULL,
0x00000012000d0308ULL, 0x000e620000000800ULL, 0x0000002f46467220ULL, 0x080fe40000410000ULL,
0x0000002f47477220ULL, 0x080fe40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x000fc40000410000ULL,
0x0000002f3f3f7220ULL, 0x080fe40000410000ULL, 0x0000002f3a3a7220ULL, 0x080fe40000410000ULL,
0x0000002f3b3b7220ULL, 0x080fe40000410000ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f37377220ULL, 0x080fe40000410000ULL, 0x0000002f1a1a7220ULL, 0x000fc40000410000ULL,
0x0000002f1b1b7220ULL, 0x000fe40000410000ULL, 0x000000130d130220ULL, 0x00afe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000dff1c723eULL, 0x000fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff1f7819ULL, 0x000fe40000011600ULL,
0x000054101c1e7816ULL, 0x000fe4000000001cULL, 0x000000181f117810ULL, 0x040fe40007ffe0ffULL,
0x000000101f127810ULL, 0x000fe20007ffe0ffULL, 0x0000d5227f007947ULL, 0x000fea000b800000ULL,
0x00001f1f1e777589ULL, 0x0002a800000e0000ULL, 0x00001f5c1e787589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff1f7224ULL, 0x002fe200078e0012ULL,
0x00006540001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000de8000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff1f7224ULL, 0x002fe200078e0011ULL,
0x000065a0001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000de2000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000a130a7221ULL, 0x008fe40000010000ULL,
0x000010000b117824ULL, 0x000fe200078e00ffULL, 0x01200000762c783bULL, 0x004ea20000000200ULL,
0x00004000056c7824ULL, 0x000fe200078e026cULL, 0x00009910101c7816ULL, 0x000fe400000000ffULL,
0x00001000111d7812ULL, 0x000fc400078ec0ffULL, 0x012000006b10783bULL, 0x000ee20000000200ULL,
0x000000ff1c00720cULL, 0x000fe40003f05270ULL, 0x0001300074747810ULL, 0x100fe40007ffe01dULL,
0x000130006c1d7810ULL, 0x000fc60007ffe01dULL, 0x0000001075587824ULL, 0x100fe400078e0274ULL,
0x0000001073547824ULL, 0x100fe400078e0274ULL, 0x0000001072507824ULL, 0x100fe400078e0274ULL,
0x0000001070307824ULL, 0x002fe200078e0274ULL, 0x000000005858783bULL, 0x000e620000004200ULL,
0x000000106a287824ULL, 0x100fe400078e021dULL, 0x0000001069247824ULL, 0x100fe200078e021dULL,
0x000000005454783bULL, 0x000f220000004200ULL, 0x0000001068207824ULL, 0x000fc400078e021dULL,
0x00000010661d7824ULL, 0x000fe200078e021dULL, 0x000000005050783bULL, 0x000f280000004200ULL,
0x000000003030783bULL, 0x000f280000004200ULL, 0x000000002828783bULL, 0x000f220000004200ULL,
0x000000772c2c8231ULL, 0x004fc600003400ffULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000772e2e8231ULL, 0x080fe400003400ffULL, 0x000000782d2d8231ULL, 0x090fe200003400ffULL,
0x000000002020783bULL, 0x000f220000004200ULL, 0x000000782f2f8231ULL, 0x080fe400003400ffULL,
0x0000007710108231ULL, 0x088fe200003400ffULL, 0x000000001d1c783bULL, 0x000ee20000004200ULL,
0x0000007712128231ULL, 0x000fe400003400ffULL, 0x0000007811118231ULL, 0x000fc400003400ffULL,
0x0000007813138231ULL, 0x000fe200003400ffULL, 0x000000582c4c723cULL, 0x042ff0000004184cULL,
0x0000005a2c48723cULL, 0x040ff00000041848ULL, 0x000000542c44723cULL, 0x040ff00000041844ULL,
0x000000562c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028104c723cULL, 0x040ff0000004184cULL,
0x0000002a1048723cULL, 0x040ff00000041848ULL, 0x000000241044723cULL, 0x044ff00000041844ULL,
0x000000261040723cULL, 0x040ff00000041840ULL, 0x00000020103c723cULL, 0x050ff0000004183cULL,
0x000000221038723cULL, 0x040ff00000041838ULL, 0x0000001c1034723cULL, 0x048ff00000041834ULL,
0x0000001e1018723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000c015107811ULL, 0x000fe200078e40ffULL, 0x01b6980062ff7f8cULL, 0x0003e2000c80043fULL,
0x000000010b777812ULL, 0x000fc400078e0cffULL, 0x000000171000720cULL, 0x000fda0003f06070ULL,
0x0000193000000947ULL, 0x000fea0003800000ULL, 0x0000030015137a10ULL, 0x002fe20007ffe0ffULL,
0x0000580008087a24ULL, 0x020fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000113117810ULL, 0x040fe20007ffe0ffULL, 0x0000010013127824ULL, 0x000fe400078e0204ULL,
0x0000004008087824ULL, 0x000fe200078e00ffULL, 0x000000141100720cULL, 0x000fe40003f06070ULL,
0x0000002061227812ULL, 0x000fd600078ef812ULL, 0x0000076000008947ULL, 0x000fea0003800000ULL,
0x0000001217107217ULL, 0x000fe20007800000ULL, 0x0000200060137824ULL, 0x000fe200078e00ffULL,
0x00000003ff257819ULL, 0x000fe20000011600ULL, 0x000010000b117824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x000fe200078e0a12ULL, 0x00002000131c7812ULL, 0x000fe200078ec0ffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0x00000004251d7810ULL, 0x040fe40007ffe0ffULL,
0x00000008251f7810ULL, 0x000fe20007ffe0ffULL, 0x0000400005137824ULL, 0x000fe200078e021cULL,
0x00000008120f7812ULL, 0x000fe200078ee20fULL, 0x000000081d2d7824ULL, 0x000fe200078e00ffULL,
0x0000100011127812ULL, 0x000fe200078ec0ffULL, 0x0000000125117824ULL, 0x000fe200078e0222ULL,
0x000000001d1c7212ULL, 0x000fe200078e3cffULL, 0x000000081f2f7824ULL, 0x000fe200078e00ffULL,
0x00013000132c7810ULL, 0x000fe20007ffe012ULL, 0x000000011d137824ULL, 0x000fe200078e0222ULL,
0x0000001108117210ULL, 0x000fc40007f1e0ffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee21cULL,
0x0000002010287817ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x000000001f1c7212ULL, 0x000fe200078e3cffULL, 0x000000102d2d7824ULL, 0x000fe200078e022cULL,
0x00005e0011107a11ULL, 0x000fe400078040ffULL, 0xfffffff82f2f7812ULL, 0x000fe400078ee21cULL,
0x00005f0011117a11ULL, 0x000fc400000f4412ULL, 0x00000013081c7210ULL, 0x000fe20007f1e0ffULL,
0x000000011f137824ULL, 0x000fe200078e0222ULL, 0x0000000c25317810ULL, 0x000fe20007ffe0ffULL,
0x000000100f107825ULL, 0x000fe200078e0010ULL, 0x000000281d00720cULL, 0x080fe40003f46070ULL,
0x0000001025337810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e001c127a11ULL, 0x000fe200078040ffULL, 0x00000001311d7824ULL, 0x140fe200078e0222ULL,
0x0000001308217210ULL, 0x000fe20007f7e0ffULL, 0x00000008312e7824ULL, 0x000fe200078e00ffULL,
0x000000281f00720cULL, 0x000fe20003f26070ULL, 0x00000001331f7824ULL, 0x000fe200078e0222ULL,
0x00005f001c137a11ULL, 0x000fe200000f4423ULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x0000001d08237210ULL, 0x040fe20007f9e0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e022cULL,
0x0000001f081d7210ULL, 0x000fe20007fbe0ffULL, 0x000000100f127825ULL, 0x000fe200078e0012ULL,
0x00005e00231e7a11ULL, 0x000fc400078640ffULL, 0x0000001425517810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005e0021207a11ULL, 0x000fe200078040ffULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe400078840ffULL,
0x00005f00231f7a11ULL, 0x000fe200018f4426ULL, 0x0000000151237824ULL, 0x000fe200078e0222ULL,
0x0000001825537810ULL, 0x040fe40007ffe0ffULL, 0x0000001c25557810ULL, 0x000fe20007ffe0ffULL,
0x000000100f1e7825ULL, 0x000fe200078e001eULL, 0x00005f0021217a11ULL, 0x000fc400000f442aULL,
0x00005f001d1d7a11ULL, 0x000fe400020f4424ULL, 0x000000282500720cULL, 0x080fe20003f66070ULL,
0x000000100f207825ULL, 0x000fe200078e0020ULL, 0x0000002308247210ULL, 0x040fe40007f1e0ffULL,
0x00000007252b7812ULL, 0x000fe200078e4800ULL, 0x0000000153237824ULL, 0x100fe200078e0222ULL,
0x000000285500720cULL, 0x040fe20003fc6070ULL, 0x0000000155257824ULL, 0x000fe200078e0222ULL,
0x0ffffff82b2b7812ULL, 0x000fe200078ef800ULL, 0x000000ffff297224ULL, 0x000fe200000e06ffULL,
0x0000002308277210ULL, 0x040fe20007f9e0ffULL, 0x000000100f1c7825ULL, 0x000fe200078e001cULL,
0x0000002508257210ULL, 0x000fc40007fbe0ffULL, 0x00005e0024227a11ULL, 0x040fe200078040ffULL,
0x000000102b2b7824ULL, 0x000fe400078e022cULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x00005f0024237a11ULL, 0x000fe200000f4429ULL, 0x000000ffff087224ULL, 0x000fe200028e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e2000d901c46ULL, 0x00005e0025247a11ULL, 0x000fe200078a40ffULL,
0x000000100f227825ULL, 0x000fe200078e0022ULL, 0x00005f0027277a11ULL, 0x000fe200020f442aULL,
0x00000000122d7faeULL, 0x0005e2000d101c46ULL, 0x00005f0025257a11ULL, 0x000fc400028f4408ULL,
0x000000283100720cULL, 0x080fe20003f06070ULL, 0x000000100f267825ULL, 0x000fe200078e0026ULL,
0x000000283300720cULL, 0x080fe20003f66070ULL, 0x00000000202f7faeULL, 0x0005e2000c901c46ULL,
0x000000285100720cULL, 0x080fe20003f86070ULL, 0x000000100f247825ULL, 0x000fe200078e0024ULL,
0x000000285300720cULL, 0x000fe40003fa6070ULL, 0x0000000033087212ULL, 0x0c0fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000000031297212ULL, 0x080fe200078e3cffULL,
0x0000000853317824ULL, 0x000fe200078e00ffULL, 0x0000000051287212ULL, 0x0c0fe200078e3cffULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x0000000055107212ULL, 0x0c2fe200078e3cffULL,
0x0000000855557824ULL, 0x000fe200078e00ffULL, 0x00000000532a7212ULL, 0x000fc400078e3cffULL,
0xfffffff82e297812ULL, 0x000fe400078ee229ULL, 0xfffffff833117812ULL, 0x000fe400078ee208ULL,
0xfffffff8512b7812ULL, 0x000fe200078ee228ULL, 0x0000001029297824ULL, 0x000fe200078e022cULL,
0xfffffff831317812ULL, 0x000fe200078ee22aULL, 0x0000001011117824ULL, 0x000fe200078e022cULL,
0xfffffff855337812ULL, 0x000fe200078ee210ULL, 0x000000102b2b7824ULL, 0x100fe200078e022cULL,
0x000000001e297faeULL, 0x0005e2000c101c46ULL, 0x0000001031317824ULL, 0x000fc400078e022cULL,
0x0000001033337824ULL, 0x000fe200078e022cULL, 0x000000001c117faeULL, 0x0005e8000d901c46ULL,
0x00000000222b7faeULL, 0x0005e8000e101c46ULL, 0x0000000026317faeULL, 0x0005e8000e901c46ULL,
0x0000000024337faeULL, 0x0005e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x0000200060117824ULL, 0x000fe200078e00ffULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x000000080e1e7824ULL, 0x000fc400078e00ffULL, 0x000010000b107824ULL, 0x000fe200078e00ffULL,
0x0000200011127812ULL, 0x000fe400078ec0ffULL, 0x00000004131f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000813217810ULL, 0x000fe20007ffe0ffULL, 0x0000400005117824ULL, 0x000fe200078e0212ULL,
0x000000001f127212ULL, 0x0c0fe200078e3cffULL, 0x000000081f237824ULL, 0x000fe200078e00ffULL,
0x000000081e0f7812ULL, 0x000fe200078ee20fULL, 0x0000000821257824ULL, 0x040fe200078e00ffULL,
0x00000000211c7212ULL, 0x000fe200078e3cffULL, 0x000000011f1f7824ULL, 0x000fe200078e0222ULL,
0xfffffff8231e7812ULL, 0x000fe200078ee212ULL, 0x0000000121217824ULL, 0x000fe200078e0222ULL,
0x0000000c13237810ULL, 0x000fc40007ffe0ffULL, 0x0000100010107812ULL, 0x000fe400078ec0ffULL,
0x0000001413277810ULL, 0x000fe20007ffe0ffULL, 0x0000000823297824ULL, 0x000fe200078e00ffULL,
0xfffffff825207812ULL, 0x000fe400078ee21cULL, 0x00013000111d7810ULL, 0x000fe20007ffe010ULL,
0x0000000113117824ULL, 0x140fe200078e0222ULL, 0x0000001013257810ULL, 0x000fe20007ffe0ffULL,
0x00000008272d7824ULL, 0x000fe200078e00ffULL, 0x00000000231c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000123237824ULL, 0x000fe200078e0222ULL, 0x0000000027287212ULL, 0x000fe200078e3cffULL,
0x00000008252b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829247812ULL, 0x000fe200078ee21cULL,
0x0000000127277824ULL, 0x000fe200078e0222ULL, 0x0000001108117210ULL, 0x000fc40007f1e0ffULL,
0x0000000025267212ULL, 0x040fe200078e3cffULL, 0x0000000125257824ULL, 0x000fe200078e0222ULL,
0xfffffff82d287812ULL, 0x000fe200078ee228ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x0000001813297810ULL, 0x040fe40007ffe0ffULL, 0x0000001c132d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001028337824ULL, 0x100fe200078e021dULL, 0xfffffff82b267812ULL, 0x000fe200078ee226ULL,
0x00000001292b7824ULL, 0x100fe200078e0222ULL, 0x00005e0011107a11ULL, 0x000fe200078040ffULL,
0x000000012d2f7824ULL, 0x000fe200078e0222ULL, 0x0000000713137812ULL, 0x000fe200078e4800ULL,
0x000000082d2e7824ULL, 0x000fe200078e00ffULL, 0x0000001f081f7210ULL, 0x000fe20007fde0ffULL,
0x0000001026317824ULL, 0x000fe200078e021dULL, 0x00005f0011117a11ULL, 0x000fc400000f4412ULL,
0x0000002b082a7210ULL, 0x040fe20007f3e0ffULL, 0x00000008292b7824ULL, 0x000fe200078e00ffULL,
0x0000002108217210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000002308237210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff517224ULL, 0x000fe200008e06ffULL,
0x0000002508257210ULL, 0x040fe20007f7e0ffULL, 0x000000100f107825ULL, 0x000fe200078e0010ULL,
0x0000002708277210ULL, 0x040fe40007f1e0ffULL, 0x0000002f082c7210ULL, 0x000fe20007f5e0ffULL,
0x00000010242f7824ULL, 0x100fe200078e021dULL, 0x0000000029227212ULL, 0x080fe200078e3cffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x000000002d297212ULL, 0x000fe200078e3cffULL,
0x00000010202d7824ULL, 0x000fe200078e021dULL, 0x0ffffff813087812ULL, 0x000fe200078ef800ULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x00005e001f127a11ULL, 0x000fe200078c40ffULL,
0x000000ffff557224ULL, 0x000fe200010e06ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee229ULL,
0x0000001008297824ULL, 0x100fe200078e021dULL, 0xfffffff82b227812ULL, 0x000fe200078ee222ULL,
0x000000101e2b7824ULL, 0x100fe200078e021dULL, 0x00005f001f137a11ULL, 0x000fe200030f441cULL,
0x000000ffff087224ULL, 0x000fe200028e06ffULL, 0x00005e00211e7a11ULL, 0x000fe200078a40ffULL,
0x0000001022537824ULL, 0x100fe200078e021dULL, 0x00005e00231c7a11ULL, 0x000fe200078840ffULL,
0x000000102e577824ULL, 0x000fe200078e021dULL, 0x00005f00211f7a11ULL, 0x000fe200028f4408ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x00005f00231d7a11ULL, 0x000fe200020f4420ULL,
0x000000100f127825ULL, 0x000fe200078e0012ULL, 0x00005e0025207a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0003e2000b901c46ULL,
0x00005e0027227a11ULL, 0x000fe200078040ffULL, 0x000000100f1e7825ULL, 0x040fe200078e001eULL,
0x00005e002a247a11ULL, 0x000fe200078240ffULL, 0x00000000122b7faeULL, 0x0003e2000b901c46ULL,
0x00005e002c267a11ULL, 0x000fe200078440ffULL, 0x000000100f1c7825ULL, 0x000fe200078e001cULL,
0x00005f0025217a11ULL, 0x000fe200018f4408ULL, 0x000000001e2d7faeULL, 0x0003e2000b901c46ULL,
0x00005f0027237a11ULL, 0x000fc400000f4428ULL, 0x00005f002a257a11ULL, 0x000fe200008f4451ULL,
0x000000100f207825ULL, 0x040fe200078e0020ULL, 0x00005f002c277a11ULL, 0x000fe200010f4455ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x000000100f227825ULL, 0x040fe400078e0022ULL,
0x0000000020317faeULL, 0x0003e4000b901c46ULL, 0x000000100f247825ULL, 0x040fe400078e0024ULL,
0x0000000022337faeULL, 0x0003e4000b901c46ULL, 0x000000100f267825ULL, 0x000fc400078e0026ULL,
0x0000000024537faeULL, 0x0003e8000b901c46ULL, 0x0000000026577faeULL, 0x0003e4000b901c46ULL,
0x0000000307087812ULL, 0x000fc800078ec0ffULL, 0x000000030800780cULL, 0x000fc80003f05270ULL,
0x0000000106087807ULL, 0x000fca0004000000ULL, 0x0000000107077824ULL, 0x000fe400078e0208ULL,
0xffffffffff087424ULL, 0x000fc600078e00ffULL, 0x000000160700720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010c107824ULL, 0x002fe400078e0207ULL,
0x00000004ff117424ULL, 0x004fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610087981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b668005e107f8cULL, 0x006fe8000c80043fULL,
0x01b66c005e0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL,
0x0000000f00127305ULL, 0x0002a4000021f000ULL, 0x3fa000000f0f7823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe20003800000ULL, 0x01b66c005e137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fc40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020600f7824ULL, 0x000fca00078e00ffULL, 0xffffff800f107812ULL, 0x000fc800078ec0ffULL,
0x000001805f107810ULL, 0x000fca0007ffe010ULL, 0x000000015d107824ULL, 0x000fca00078e0210ULL,
0x01b0000010127984ULL, 0x000e680000000800ULL, 0x01b20000100f7984ULL, 0x0004e20000000800ULL,
0x000000091200720bULL, 0x002fe20003f1d000ULL, 0x0000c0227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff10137812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000303117810ULL, 0x000fe40007ffe0ffULL,
0x000000091200720bULL, 0x000fe40003f34000ULL, 0x000000601100720cULL, 0x000fe20003f05270ULL,
0x0000bff27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x0000001209117209ULL, 0x040fe20007810000ULL, 0x00000080601c8824ULL, 0x000fe200078e025fULL,
0x0000ffff10107812ULL, 0x000fe400078e3cffULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x8000001109097221ULL, 0x000fc40000010000ULL, 0x000000015d1c8824ULL, 0x000fe400078e021cULL,
0x3fb8aa3b09097820ULL, 0x000fc60000410000ULL, 0x01b400111c008388ULL, 0x0003e20000000800ULL,
0x00000009001e7308ULL, 0x000ea20000000800ULL, 0x0000001013ff7212ULL, 0x000fe2000780c0ffULL,
0x0000001e0a0a7220ULL, 0x004fe20000410000ULL, 0x0000bf827f007947ULL, 0x000ff2000b800000ULL,
0x00001f1f1e2f7589ULL, 0x0022a400000e0000ULL, 0x0000002f4c4c7220ULL, 0x084fe40000410000ULL,
0x0000002f4d4d7220ULL, 0x080fe40000410000ULL, 0x0000002f48487220ULL, 0x080fe40000410000ULL,
0x0000002f49497220ULL, 0x000fc40000410000ULL, 0x0000002f44447220ULL, 0x080fe40000410000ULL,
0x0000002f45457220ULL, 0x080fe40000410000ULL, 0x0000002f40407220ULL, 0x080fe40000410000ULL,
0x0000002f41417220ULL, 0x080fe40000410000ULL, 0x0000002f3c3c7220ULL, 0x080fe40000410000ULL,
0x0000002f3d3d7220ULL, 0x000fc40000410000ULL, 0x0000002f38387220ULL, 0x080fe40000410000ULL,
0x0000002f39397220ULL, 0x080fe40000410000ULL, 0x0000002f34347220ULL, 0x080fe40000410000ULL,
0x0000002f35357220ULL, 0x080fe40000410000ULL, 0x0000002f18187220ULL, 0x080fe40000410000ULL,
0x0000002f19197220ULL, 0x000fe20000410000ULL, 0x0000beb27f007947ULL, 0x000fea000b800000ULL,
0x00001f5c1e2f7589ULL, 0x00052400000e0000ULL, 0x8000001112120221ULL, 0x000fe20000010000ULL,
0x00000001ff107807ULL, 0x000fe20000000000ULL, 0x0000002f4e4e7220ULL, 0x014fc40000410000ULL,
0x3fb8aa3b12120820ULL, 0x000fe40000410000ULL, 0x0000002f4f4f7220ULL, 0x080fe40000410000ULL,
0x00000012000d0308ULL, 0x000ea20000000800ULL, 0x0000002f4a4a7220ULL, 0x080fe40000410000ULL,
0x0000002f4b4b7220ULL, 0x080fe40000410000ULL, 0x0000002f46467220ULL, 0x080fe40000410000ULL,
0x0000002f47477220ULL, 0x000fc40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x080fe40000410000ULL,
0x0000002f3f3f7220ULL, 0x080fe40000410000ULL, 0x0000002f3a3a7220ULL, 0x080fe40000410000ULL,
0x0000002f3b3b7220ULL, 0x000fc40000410000ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f37377220ULL, 0x080fe40000410000ULL, 0x0000002f1a1a7220ULL, 0x080fe40000410000ULL,
0x0000002f1b1b7220ULL, 0x000fe40000410000ULL, 0x000000ffff097224ULL, 0x000fe400078e0011ULL,
0x0000000f0d0f0220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000dff13723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff1f7819ULL, 0x002fe40000011600ULL, 0x00005410131e7816ULL, 0x000fe40000000013ULL,
0x000000181f117810ULL, 0x040fe40007ffe0ffULL, 0x000000101f127810ULL, 0x000fe20007ffe0ffULL,
0x0000bd227f007947ULL, 0x000fea000b800000ULL, 0x00001f1f1e5d7589ULL, 0x0002a800000e0000ULL,
0x00001f5c1e5c7589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e0012ULL, 0x00007f70001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000c45000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e0011ULL, 0x00007fd0001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000c3f000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000a0f0a7221ULL, 0x008fe40000010000ULL, 0x01280000762c783bULL, 0x004ea20000000200ULL,
0x00009910100f7816ULL, 0x000fc600000000ffULL, 0x000000007158783bULL, 0x000ee20000004200ULL,
0x000000ff0f00720cULL, 0x000fc60003f05270ULL, 0x000000006f54783bULL, 0x000fe80000004200ULL,
0x000000006e50783bULL, 0x000fe80000004200ULL, 0x000000006d30783bULL, 0x002fe80000004200ULL,
0x012800006b10783bULL, 0x000e680000000200ULL, 0x000000006728783bULL, 0x000f280000004200ULL,
0x000000006524783bULL, 0x000f280000004200ULL, 0x000000006420783bULL, 0x000f280000004200ULL,
0x00000000631c783bULL, 0x000f220000004200ULL, 0x0000005d2c2c8231ULL, 0x004fc400003400ffULL,
0x0000005d2e2e8231ULL, 0x000fe400003400ffULL, 0x0000005c2d2d8231ULL, 0x090fe400003400ffULL,
0x0000005c2f2f8231ULL, 0x000fce00003400ffULL, 0x000000582c4c723cULL, 0x008fe2000004184cULL,
0x0000005d10108231ULL, 0x002fce00003400ffULL, 0x0000005a2c48723cULL, 0x000fe20000041848ULL,
0x0000005d12128231ULL, 0x000fe400003400ffULL, 0x0000005c11118231ULL, 0x080fe400003400ffULL,
0x0000005c13138231ULL, 0x000fc600003400ffULL, 0x000000542c44723cULL, 0x040ff00000041844ULL,
0x000000562c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028104c723cULL, 0x040ff0000004184cULL,
0x0000002a1048723cULL, 0x040ff00000041848ULL, 0x000000241044723cULL, 0x040ff00000041844ULL,
0x000000261040723cULL, 0x040ff00000041840ULL, 0x00000020103c723cULL, 0x040ff0000004183cULL,
0x000000221038723cULL, 0x040ff00000041838ULL, 0x0000001c1034723cULL, 0x040ff00000041834ULL,
0x0000001e1018723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01b6a00062ff7f8cULL, 0x0003e2000c80043fULL, 0x000000010b777812ULL, 0x000fce00078ec0ffULL,
0x0000030015157a10ULL, 0x002fc80007ffe0ffULL, 0x000000141500720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff943000007947ULL, 0x000fea000383ffffULL,
0x00000000000b7919ULL, 0x002e640000002500ULL, 0x000000140b00720cULL, 0x002fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x018000000a007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x020fe200078e000aULL, 0x00008390002c7802ULL, 0x000fe40000000f00ULL,
0x0000be8000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000a00077308ULL, 0x000e640000001000ULL,
0xbf80000007007423ULL, 0x002fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000007007223ULL, 0x000fe40000000007ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000ea80000000000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000807077811ULL, 0x004fe400078ff0ffULL, 0x00000002ff0d7819ULL, 0x008fc80000011602ULL,
0x00001f0700077589ULL, 0x000ea800000e0000ULL, 0x00001f0d00027589ULL, 0x000ee200000e0000ULL,
0x0000004e074e7220ULL, 0x044fe40000410000ULL, 0x0000004f074f7220ULL, 0x000fe40000410000ULL,
0x0000004c024c7220ULL, 0x048fe40000410000ULL, 0x0000004d024d7220ULL, 0x000fc40000410000ULL,
0x0000004802487220ULL, 0x040fe40000410000ULL, 0x0000004902497220ULL, 0x040fe40000410000ULL,
0x0000004402447220ULL, 0x040fe40000410000ULL, 0x0000004502457220ULL, 0x040fe40000410000ULL,
0x0000004002407220ULL, 0x040fe40000410000ULL, 0x0000004102417220ULL, 0x000fc40000410000ULL,
0x0000003c023c7220ULL, 0x040fe40000410000ULL, 0x0000003d023d7220ULL, 0x040fe40000410000ULL,
0x0000003802387220ULL, 0x040fe40000410000ULL, 0x0000003902397220ULL, 0x040fe40000410000ULL,
0x0000003402347220ULL, 0x040fe40000410000ULL, 0x0000003502357220ULL, 0x000fc40000410000ULL,
0x0000001802187220ULL, 0x040fe40000410000ULL, 0x0000001902197220ULL, 0x000fe40000410000ULL,
0x0000004a074a7220ULL, 0x040fe40000410000ULL, 0x0000004b074b7220ULL, 0x040fe40000410000ULL,
0x0000004607467220ULL, 0x040fe40000410000ULL, 0x0000004707477220ULL, 0x000fc40000410000ULL,
0x0000004207427220ULL, 0x040fe40000410000ULL, 0x0000004307437220ULL, 0x040fe40000410000ULL,
0x0000003e073e7220ULL, 0x040fe40000410000ULL, 0x0000003f073f7220ULL, 0x040fe40000410000ULL,
0x0000003a073a7220ULL, 0x040fe40000410000ULL, 0x0000003b073b7220ULL, 0x000fc40000410000ULL,
0x0000003607367220ULL, 0x040fe40000410000ULL, 0x0000003707377220ULL, 0x040fe40000410000ULL,
0x0000001a071a7220ULL, 0x040fe40000410000ULL, 0x0000001b071b7220ULL, 0x000fe40000410000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x000000181912723eULL, 0x000fe400000010ffULL,
0x000000363719723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000383910723eULL, 0x000fc400000010ffULL, 0x0000001a1b1a723eULL, 0x000fe400000010ffULL,
0x0000004c4d06723eULL, 0x000fe400000010ffULL, 0x000000484908723eULL, 0x022fe400000010ffULL,
0x000000343511723eULL, 0x000fe400000010ffULL, 0x00000044450c723eULL, 0x000fe400000010ffULL,
0x00000040410d723eULL, 0x000fc400000010ffULL, 0x0000003c3d0f723eULL, 0x000fe400000010ffULL,
0x0000004e4f13723eULL, 0x000fe400000010ffULL, 0x0000004a4b14723eULL, 0x000fe400000010ffULL,
0x00000002ff277819ULL, 0x004fe40000011607ULL, 0x0000000807377811ULL, 0x000fe400078ff0ffULL,
0x00000027ff297212ULL, 0x000fe200078e33ffULL, 0x00000008271c7824ULL, 0x000fe200078e00ffULL,
0x00000037ff397212ULL, 0x000fe200078e33ffULL, 0x00000008371e7824ULL, 0x000fe200078e00ffULL,
0x0000000727007812ULL, 0x040fe200078ec0ffULL, 0x0000000827027824ULL, 0x000fe200078e00ffULL,
0xfffffff81c297812ULL, 0x000fc400078ee229ULL, 0xfffffff81e397812ULL, 0x000fe400078ee239ULL,
0xfffffff8021b7812ULL, 0x000fe400078ee227ULL, 0x0000000100027812ULL, 0x040fe400078e3cffULL,
0x00000002001c7812ULL, 0x040fe400078e3cffULL, 0x00000003001e7812ULL, 0x040fe200078e3cffULL,
0x00000008271d7824ULL, 0x040fe200078e0202ULL, 0x0000000400207812ULL, 0x040fe200078e3cffULL,
0x00000008271f7824ULL, 0x040fe200078e021cULL, 0x0000000500227812ULL, 0x040fe200078e3cffULL,
0x0000000827217824ULL, 0x040fe200078e021eULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x0000000827237824ULL, 0x000fe200078e0220ULL, 0x00000007371e7812ULL, 0x000fe200078ec0ffULL,
0x0000000827257824ULL, 0x000fe200078e0222ULL, 0x000000464715723eULL, 0x000fe200000010ffULL,
0x0000000827277824ULL, 0x000fe200078e0200ULL, 0x000000021e227812ULL, 0x000fe200078e3cffULL,
0x000010000e007824ULL, 0x000fe200078e00ffULL, 0x000000031e247812ULL, 0x040fe200078e3cffULL,
0x00000004071c7824ULL, 0x000fe200078e00ffULL, 0x000000041e267812ULL, 0x040fe200078e3cffULL,
0x0000080005027824ULL, 0x000fe200078e0200ULL, 0x000000051e287812ULL, 0x000fe200078e3cffULL,
0x0000000837207824ULL, 0x000fe200078e00ffULL, 0x0000000c1c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x000000424316723eULL, 0x000fe200000010ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0202ULL, 0xfffffff8202b7812ULL, 0x000fe200078ee237ULL,
0x000000011b1b7824ULL, 0x000fe200078e021cULL, 0x000000011e207812ULL, 0x040fe200078e3cffULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x000000061e1e7812ULL, 0x000fe200078e3cffULL,
0x0000001021217824ULL, 0x100fe200078e0202ULL, 0x000000061b007388ULL, 0x000fe20000000800ULL,
0x0000001023237824ULL, 0x000fe200078e0202ULL, 0x0000003e3f17723eULL, 0x000fe200000010ffULL,
0x00000008372d7824ULL, 0x000fe200078e0220ULL, 0x0000003a3b18723eULL, 0x000fe200000010ffULL,
0x0000001025257824ULL, 0x000fc400078e0202ULL, 0x000000011c1d7824ULL, 0x000fe400078e021dULL,
0x00000008372f7824ULL, 0x040fe400078e0222ULL, 0x0000000837317824ULL, 0x040fe200078e0224ULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x0000000837337824ULL, 0x040fe400078e0226ULL,
0x0000000837357824ULL, 0x000fe400078e0228ULL, 0x0000001027277824ULL, 0x000fc400078e0202ULL,
0x000000011c1f7824ULL, 0x040fe400078e021fULL, 0x0000000837377824ULL, 0x000fe200078e021eULL,
0x000000ff00087306ULL, 0x002fe20000205400ULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000000c1f007388ULL, 0x000fe20000000800ULL, 0x000000011c067824ULL, 0x040fe400078e0221ULL,
0x000000102b2b7824ULL, 0x100fe400078e0202ULL, 0x000000011c1e7824ULL, 0x000fe200078e0223ULL,
0x0000000d06007388ULL, 0x0003e20000000800ULL, 0x000000102d2d7824ULL, 0x000fc400078e0202ULL,
0x000000011c257824ULL, 0x040fe200078e0225ULL, 0x0000000f1e007388ULL, 0x0005e20000000800ULL,
0x000000102f2f7824ULL, 0x100fe400078e0202ULL, 0x000000011c207824ULL, 0x040fe200078e0227ULL,
0x0000001025007388ULL, 0x000fe20000000800ULL, 0x000000011c297824ULL, 0x040fe200078e0229ULL,
0x000000ff000d7306ULL, 0x002e620000209400ULL, 0x0000001031317824ULL, 0x000fe200078e0202ULL,
0x0000001120007388ULL, 0x000fe20000000800ULL, 0x000000011c227824ULL, 0x000fc400078e022bULL,
0x0000001033337824ULL, 0x100fe200078e0202ULL, 0x0000001229007388ULL, 0x000fe20000000800ULL,
0x0000001039397824ULL, 0x100fe200078e0202ULL, 0x000000ff00067306ULL, 0x000ee2000020d400ULL,
0x0000001035357824ULL, 0x100fe200078e0202ULL, 0x0000001322007388ULL, 0x000fe20000000800ULL,
0x000000011c2d7824ULL, 0x040fe400078e022dULL, 0x0000001037377824ULL, 0x000fe400078e0202ULL,
0x000000011c247824ULL, 0x040fe200078e022fULL, 0x000000142d007388ULL, 0x000fe20000000800ULL,
0x000000011c317824ULL, 0x040fe200078e0231ULL, 0x000000080d00720bULL, 0x002fe20003f1d000ULL,
0x000000011c267824ULL, 0x040fe200078e0233ULL, 0x0000001524007388ULL, 0x000fe20000000800ULL,
0x000000011c397824ULL, 0x000fc400078e0239ULL, 0x000000011c357824ULL, 0x040fe200078e0235ULL,
0x0000001631007388ULL, 0x000fe20000000800ULL, 0x000000011c1c7824ULL, 0x000fe400078e0237ULL,
0x00000001041b7824ULL, 0x000fe200078e0207ULL, 0x0000001726007388ULL, 0x000fe60000000800ULL,
0x000000101b0f7824ULL, 0x004fe200078e0200ULL, 0x0000001835007388ULL, 0x000fe20000000800ULL,
0x0000000106060812ULL, 0x008fc600078efcffULL, 0x000000191c007388ULL, 0x000fe20000000800ULL,
0x000000060608723eULL, 0x000fc600000010ffULL, 0x0000001a39007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000000f107984ULL, 0x000e680000000c00ULL,
0x000400000f287984ULL, 0x000ea80000000c00ULL, 0x000800000f207984ULL, 0x000ee80000000c00ULL,
0x000c00000f147984ULL, 0x000f220000000c00ULL, 0x3f803f8008137831ULL, 0x002fc40000200013ULL,
0x3f803f8008127831ULL, 0x040fe40000200012ULL, 0x3f803f8008117831ULL, 0x040fe40000200011ULL,
0x3f803f8008107831ULL, 0x040fe40000200010ULL, 0x3f803f80082b7831ULL, 0x044fe4000020002bULL,
0x3f803f80082a7831ULL, 0x040fe4000020002aULL, 0x3f803f8008297831ULL, 0x000fc40000200029ULL,
0x3f803f8008287831ULL, 0x000fe20000200028ULL, 0x00000001ff087424ULL, 0x000fe200078e00ffULL,
0x3f803f8013137831ULL, 0x008fe40000200023ULL, 0x3f803f8012127831ULL, 0x000fe40000200022ULL,
0x0000030008007a0cULL, 0x000fe20003f05270ULL, 0x3f803f8011117831ULL, 0x000fe40000200021ULL,
0x3f803f8010107831ULL, 0x000fe40000200020ULL, 0x3f803f802b2b7831ULL, 0x010fc40000200017ULL,
0x3f803f802a2a7831ULL, 0x000fe20000200016ULL, 0x000000100f007388ULL, 0x0003e20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe40000200015ULL, 0x3f803f8028287831ULL, 0x000fca0000200014ULL,
0x000400280f007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f3000008947ULL, 0x000fea0003800000ULL, 0x0000000000167919ULL, 0x000ea20000002700ULL,
0x00005800ff0c7624ULL, 0x000fe200078e00ffULL, 0x0000000105ff7812ULL, 0x000fc4000780f860ULL,
0x00000000000d7919ULL, 0x000ea20000002600ULL, 0x000003000c0c7a24ULL, 0x000fe200078e02ffULL,
0x000000ff0700720cULL, 0x000fe40000725670ULL, 0x000000000f1c7984ULL, 0x0007220000000c00ULL,
0x000066000c107a24ULL, 0x002fe400078e02ffULL, 0x0000580016167a24ULL, 0x004fe400078e020dULL,
0x00000800ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000030016087a24ULL, 0x000fc800078e02ffULL,
0x0000000108117824ULL, 0x000fe200078e020bULL, 0x000007ff100b7811ULL, 0x000fc800078e40ffULL,
0x000000110b0c7211ULL, 0x000fca00078fa8ffULL, 0x00006c000c0c7625ULL, 0x000fcc00078e000dULL,
0x000004000e0c7825ULL, 0x000fcc00078e000cULL, 0x000000101b147825ULL, 0x000fe200078e000cULL,
0x01ffffff100c7812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010070d7824ULL, 0x018fe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011607ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000000111127824ULL, 0x000fe200078e020cULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x00006c0011107625ULL, 0x000fe200078e0013ULL,
0x0000000c0f0f7812ULL, 0x000fc600078ec0ffULL, 0x00006c0012127625ULL, 0x000fe200078e0013ULL,
0x000000100f107210ULL, 0x000fc80007a1e00dULL, 0x000000120f127210ULL, 0x000fe40007c7e00dULL,
0x00000011ff117210ULL, 0x000fe400007e44ffULL, 0x00000013ff137210ULL, 0x000fc60001fe84ffULL,
0x0000000910007986ULL, 0x0003e8000c101906ULL, 0x0000000a12007986ULL, 0x0003e4000c101906ULL,
0x0000001c14007986ULL, 0x0185e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x00000001ff097424ULL, 0x002fe400078e00ffULL, 0x00000004ff117424ULL, 0x000fc600078e00ffULL,
0x0000030009097a10ULL, 0x000fe20007ffe1ffULL, 0x00006a0016107625ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000009101079a8ULL, 0x000ee400099ee1c6ULL, 0x000000091000720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff097984ULL, 0x002e640000000000ULL,
0x000000ff0900720cULL, 0x002fda0003f05270ULL, 0x00002ba000008947ULL, 0x000fea0003800000ULL,
0x000000ff6000720cULL, 0x000fda0003f05270ULL, 0x00000d6000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000000108127810ULL, 0x000fe20007ffe0ffULL, 0x0000001007097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011607ULL, 0x00000080ff0f7424ULL, 0x000fc600078e00ffULL,
0x0000007009157812ULL, 0x004fe200078ec0ffULL, 0x00006c0008107625ULL, 0x000fe200078e000fULL,
0x0000000c0a177812ULL, 0x000fc600078ec0ffULL, 0x00006c0012127625ULL, 0x000fe200078e000fULL,
0x0000001017107210ULL, 0x000fc8000791e015ULL, 0x0000001217127210ULL, 0x000fe40007b5e015ULL,
0x00000011ff117210ULL, 0x000fe400007e24ffULL, 0x00000013ff137210ULL, 0x000fc600017e64ffULL,
0x0000000610097981ULL, 0x000368000c1e1900ULL, 0x00000006120a7981ULL, 0x000362000c1e1900ULL,
0x00000300ff0d7624ULL, 0x000fca00078e00ffULL, 0x000000020d00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000208107810ULL, 0x002fca0007ffe0ffULL,
0x00006c0010107625ULL, 0x000fca00078e000fULL, 0x0000001017107210ULL, 0x000fc8000791e015ULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000610147981ULL, 0x000362000c1e1900ULL,
0x000000040d00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000308107810ULL, 0x002fca0007ffe0ffULL, 0x00006c0010107625ULL, 0x000fca00078e000fULL,
0x0000001017107210ULL, 0x000fc8000791e015ULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000610167981ULL, 0x000362000c1e1900ULL, 0x000000040d00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000408107810ULL, 0x002fca0007ffe0ffULL,
0x00006c0010107625ULL, 0x000fca00078e000fULL, 0x0000001017107210ULL, 0x000fc8000791e015ULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000610187981ULL, 0x000362000c1e1900ULL,
0x000000060d00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000508107810ULL, 0x002fca0007ffe0ffULL, 0x00006c0010107625ULL, 0x000fca00078e000fULL,
0x0000001017107210ULL, 0x000fc8000791e015ULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x00000006101a7981ULL, 0x000362000c1e1900ULL, 0x000000060d00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080d00780cULL, 0x002fe40003f06070ULL,
0x0000000608107810ULL, 0x000fca0007ffe0ffULL, 0x00006c0010107625ULL, 0x000fca00078e000fULL,
0x0000001017107210ULL, 0x000fe40007a3e015ULL, 0x0000000708120810ULL, 0x000fe40007ffe0ffULL,
0x00000011ff117210ULL, 0x000fc60000fe44ffULL, 0x00006c0012120625ULL, 0x000fe400078e000fULL,
0x00000006101c7981ULL, 0x000366000c1e1900ULL, 0x0000001217120210ULL, 0x000fc80007c7e015ULL,
0x00000013ff130210ULL, 0x000fca0001fe84ffULL, 0x00000006121e0981ULL, 0x000368000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff157224ULL, 0x004fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe400078e0008ULL, 0x000000ffff127224ULL, 0x020fe400078e0009ULL,
0x000000ffff177224ULL, 0x000fc600078e00ffULL, 0x0000030015007a0cULL, 0x000fe40003f26070ULL,
0x0000000117177810ULL, 0x000fc80007ffe0ffULL, 0x0000000417007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008150f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000115107810ULL, 0x000fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001209097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000080d107810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011607ULL,
0x00000010070f7824ULL, 0x000fe400078e00ffULL, 0x00006c0010107625ULL, 0x000fe200078e0011ULL,
0x0000000c12127812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000001012107210ULL, 0x000fc80007b3e00fULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610127981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009150f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000215107810ULL, 0x002fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x0000000a09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000090d107810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe20000011607ULL, 0x00000010070a7824ULL, 0x000fe400078e00ffULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000c13137812ULL, 0x000fe400078ec0ffULL,
0x000000700a0f7812ULL, 0x000fc800078ec0ffULL, 0x0000001013107210ULL, 0x000fc80007b3e00fULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x00000006100a7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a150f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000315107810ULL, 0x002fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001409097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a0d107810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011607ULL,
0x00000010070f7824ULL, 0x000fe400078e00ffULL, 0x00006c0010107625ULL, 0x000fe200078e0011ULL,
0x0000000c13137812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000001013107210ULL, 0x000fc80007b3e00fULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610147981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b150f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000415107810ULL, 0x002fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x0000001609097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b0d107810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe20000011607ULL, 0x00000010070f7824ULL, 0x000fe400078e00ffULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000c13137812ULL, 0x000fe400078ec0ffULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000001013107210ULL, 0x000fc80007b3e00fULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000610167981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c150f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000515107810ULL, 0x002fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001809097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c0d107810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011607ULL,
0x00000010070f7824ULL, 0x000fe400078e00ffULL, 0x00006c0010107625ULL, 0x000fe200078e0011ULL,
0x0000000c13137812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000001013107210ULL, 0x000fc80007b3e00fULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610187981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d150f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000615107810ULL, 0x002fe40007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000030010007a0cULL, 0x000fe40003f46070ULL,
0x0000001a09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d0d107810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe20000011607ULL, 0x00000010070f7824ULL, 0x000fe400078e00ffULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000c13137812ULL, 0x000fe400078ec0ffULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000001013107210ULL, 0x000fc80007b3e00fULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x00000006101a7981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e150f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000715107810ULL, 0x002fe40007ffe0ffULL, 0x000003000f007a0cULL, 0x000fe40003f26070ULL,
0x0000030010007a0cULL, 0x000fe40003f46070ULL, 0x0000001c09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e0d107810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011607ULL,
0x00000010070f7824ULL, 0x000fe400078e00ffULL, 0x00006c0010107625ULL, 0x000fe200078e0011ULL,
0x0000000c13137812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000001013107210ULL, 0x000fc80007b3e00fULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x00000006101c7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f150f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001e09097209ULL, 0x000fe40007810000ULL,
0x000003000f007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f0d107810ULL, 0x002fe20007ffe0ffULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe20000011607ULL, 0x00000010070f7824ULL, 0x000fe400078e00ffULL,
0x00006c0010107625ULL, 0x000fe200078e0011ULL, 0x0000000c13137812ULL, 0x000fe400078ec0ffULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000001013107210ULL, 0x000fc80007a3e00fULL,
0x00000011ff117210ULL, 0x000fca0000fe44ffULL, 0x00000006101e7981ULL, 0x000368000c1e1900ULL,
0x0000000815157810ULL, 0x000fe40007ffe0ffULL, 0x000000080d0d7810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000ee40000000000ULL,
0x00000010070a7824ULL, 0x028fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011607ULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d0d7812ULL, 0x000fca00078ec0ffULL,
0x000000010a0a7824ULL, 0x000fca00078e020dULL, 0x000000090a007388ULL, 0x0007e40000000800ULL,
0x000000070700780cULL, 0x040fe20003f04070ULL, 0x0000001007097824ULL, 0x008fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011607ULL, 0x0000000105187824ULL, 0x000fe200078e0208ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000800ff117424ULL, 0x002fe200078e00ffULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x0000200005257824ULL, 0x000fe200078e0200ULL,
0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000000001c7805ULL, 0x004fe2000001ff00ULL,
0x000000180b107211ULL, 0x000fe200078fa8ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000002007137810ULL, 0x000fe20007ffe0ffULL, 0x00000001092c7824ULL, 0x000fe200078e020aULL,
0x0000000103097812ULL, 0x000fe200078ec0ffULL, 0x00000002050a8824ULL, 0x140fe200078e020eULL,
0x0000030005007a0cULL, 0x000fe20003f26070ULL, 0x0000080003037824ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00006c0010107625ULL, 0x000fe200078e0011ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000205128824ULL, 0x000fe200078e020eULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000020a1a8824ULL, 0x000fe200078e0209ULL,
0x00000800030a7812ULL, 0x000fe200078ec0ffULL, 0x000000010c148824ULL, 0x000fe200078e0218ULL,
0x000000002c2c7984ULL, 0x000e620000000800ULL, 0x00000080ff158424ULL, 0x000fc400078e00ffULL,
0x0000000212128824ULL, 0x000fe400078e0209ULL, 0x00000080ff198424ULL, 0x000fe400078e00ffULL,
0x000004000e107825ULL, 0x000fc800078e0010ULL, 0x00000001250a7824ULL, 0x000fe400078e020aULL,
0x00006c0014148625ULL, 0x000fc800078e0015ULL, 0x00006c0018188625ULL, 0x000fc800078e0019ULL,
0x00000008120f8824ULL, 0x100fe400078e0207ULL, 0x000000081a1a8824ULL, 0x000fe400078e0207ULL,
0x0000001013127825ULL, 0x000fe200078e0010ULL, 0x000045800f0f8811ULL, 0x000fe400078e20ffULL,
0x000041801a218811ULL, 0x000fe200078e20ffULL, 0x0000001007097824ULL, 0x040fe200078e020aULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000001007107825ULL, 0x000fc800078e0010ULL,
0x0000001007168825ULL, 0x040fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000010097faeULL, 0x0005e2000b901c46ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000001007188825ULL, 0x000fe200078e0018ULL, 0x0038000012097faeULL, 0x0007e6000b901c46ULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x00000000160f8faeULL, 0x0009e2000b901c46ULL,
0x000000ffff0a7224ULL, 0x000fc400078e00ffULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x0000000018218faeULL, 0x000be2000b901c46ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x000000ffff2d7224ULL, 0x000fe400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000127805ULL, 0x008fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x010fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x020fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000d3000001947ULL, 0x000fea0003800000ULL, 0x000000ffff037224ULL, 0x002fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x000fca00078e0005ULL, 0x000000022e2f7810ULL, 0x000fc80007ffe0ffULL,
0x000003002f007a0cULL, 0x000fda0003f06070ULL, 0x0000025000000947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f04070ULL, 0x0000000108367824ULL, 0x100fe200078e022fULL,
0x00000001ff307819ULL, 0x000fe2000001162fULL, 0x000004002f317824ULL, 0x000fe200078e00ffULL,
0x00000020073b7810ULL, 0x000fe20007ffe0ffULL, 0x00000800ff357424ULL, 0x000fe200078e00ffULL,
0x0000000130337812ULL, 0x000fe400078ec0ffULL, 0x000000360b307211ULL, 0x000fe400078fa8ffULL,
0x0000080031347812ULL, 0x000fc600078ec0ffULL, 0x0000000205388824ULL, 0x140fe400078e020eULL,
0x00000002053a8824ULL, 0x000fe400078e020eULL, 0x00006c0030307625ULL, 0x000fc800078e0035ULL,
0x000000010c328824ULL, 0x000fe400078e0236ULL, 0x00000080ff378424ULL, 0x000fe400078e00ffULL,
0x0000000238388824ULL, 0x100fe400078e0233ULL, 0x000000023a3a8824ULL, 0x000fe400078e0233ULL,
0x00006c0032328625ULL, 0x000fc800078e0037ULL, 0x00000080ff358424ULL, 0x000fe400078e00ffULL,
0x0000000125347824ULL, 0x000fe400078e0234ULL, 0x000004000e307825ULL, 0x000fc800078e0030ULL,
0x00006c0036368625ULL, 0x000fc800078e0035ULL, 0x0000001007397824ULL, 0x040fe400078e0234ULL,
0x0000000838388824ULL, 0x000fe400078e0207ULL, 0x0000001007348825ULL, 0x000fc800078e0032ULL,
0x000000083a3a8824ULL, 0x000fe400078e0207ULL, 0x000000103b327825ULL, 0x100fe200078e0030ULL,
0x00004580383b8811ULL, 0x000fe400078e20ffULL, 0x000041803a3d8811ULL, 0x000fe200078e20ffULL,
0x0000001007307825ULL, 0x000fc800078e0030ULL, 0x0000001007368825ULL, 0x000fe200078e0036ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000030397faeULL, 0x0003e8000b901c46ULL,
0x0038000032397faeULL, 0x0003e8000b901c46ULL, 0x00000000343b8faeULL, 0x0003e8000b901c46ULL,
0x00000000363d8faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff357224ULL, 0x002fe200078e002eULL, 0x00000001ff327819ULL, 0x100fe20000011607ULL,
0x0000000205317824ULL, 0x000fe200078e020eULL, 0x00000002ff377819ULL, 0x000fe20000011607ULL,
0x00000040352e7824ULL, 0x000fe200078e00ffULL, 0x0000000c32327812ULL, 0x000fe200078ec0ffULL,
0x0000001007307824ULL, 0x000fe200078e00ffULL, 0x0000000737397812ULL, 0x040fe200078ec0ffULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0x000000802e2e7812ULL, 0x000fca00078ec0ffULL,
0x00000100312e7824ULL, 0x000fe200078e002eULL, 0x0000007030317812ULL, 0x000fe200078ec0ffULL,
0x0000000837307824ULL, 0x000fc600078e00ffULL, 0x0000002e32317210ULL, 0x000fe20007ffe031ULL,
0x0000000837327824ULL, 0x000fe200078e00ffULL, 0x00000037ff2e7212ULL, 0x000fe200078e33ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800031337984ULL, 0x000e620000000800ULL,
0xfffffff83b4a7812ULL, 0x000fe400078ee22eULL, 0x00000008373b7810ULL, 0x000fe20007ffe0ffULL,
0x00458000314e7984ULL, 0x0004e20000000800ULL, 0xfffffff8322e7812ULL, 0x100fe400078ee239ULL,
0x0000003bff4c7212ULL, 0x000fe200078e33ffULL, 0x000000083b407824ULL, 0x040fe200078e00ffULL,
0x0000000130327812ULL, 0x140fe200078ef639ULL, 0x000000083b3e7824ULL, 0x040fe200078e00ffULL,
0x0000000230347812ULL, 0x140fe200078ef639ULL, 0x000000083b317824ULL, 0x004fe200078e00ffULL,
0x0000000330367812ULL, 0x000fc400078ef639ULL, 0x0000000430387812ULL, 0x140fe400078ef639ULL,
0x00000005303a7812ULL, 0x140fe400078ef639ULL, 0x00000006303c7812ULL, 0x000fe200078ef639ULL,
0x0000040035307824ULL, 0x000fe200078e00ffULL, 0xfffffff8314c7812ULL, 0x000fe200078ee24cULL,
0x0000000407317824ULL, 0x000fc600078e00ffULL, 0x0000080030307812ULL, 0x000fe400078ec0ffULL,
0x0000000c31397812ULL, 0x000fe400078ec0ffULL, 0x0000018025317810ULL, 0x000fca0007ffe030ULL,
0x000000102e2e7824ULL, 0x100fe400078e0231ULL, 0x000000104a307824ULL, 0x000fe400078e0231ULL,
0x00000001392e7824ULL, 0x040fe400078e022eULL, 0x000000332c337221ULL, 0x002fe40000010100ULL,
0x0000000139307824ULL, 0x000fe400078e0230ULL, 0x3fb8aa3b33357820ULL, 0x000fe20000410000ULL,
0x000000073b337812ULL, 0x000fe200078ec0ffULL, 0x0000001032327824ULL, 0x000fc400078e0231ULL,
0x0000001034347824ULL, 0x000fe200078e0231ULL, 0x0000000140427812ULL, 0x140fe200078ef633ULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0x0000000240447812ULL, 0x140fe200078ef633ULL,
0x0000000139327824ULL, 0x040fe200078e0232ULL, 0x0000000340467812ULL, 0x140fe200078ef633ULL,
0x0000000139347824ULL, 0x040fe200078e0234ULL, 0x0000000440487812ULL, 0x000fe200078ef633ULL,
0x0000001036367824ULL, 0x000fe200078e0231ULL, 0x00000005404a7812ULL, 0x100fe200078ef633ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0xfffffff83e3e7812ULL, 0x100fe200078ee233ULL,
0x0000000139367824ULL, 0x000fe200078e0236ULL, 0x0000000640407812ULL, 0x000fe200078ef633ULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x0000001038387824ULL, 0x000fc400078e0231ULL,
0x000000103a3a7824ULL, 0x100fe200078e0231ULL, 0x000000002e337984ULL, 0x000e620000000800ULL,
0x0000004e354e7220ULL, 0x008fe40000410000ULL, 0x0000000139387824ULL, 0x000fe200078e0238ULL,
0x0000000030357984ULL, 0x000fe20000000800ULL, 0x000000103c3c7824ULL, 0x100fe400078e0231ULL,
0x000000103e3e7824ULL, 0x100fe200078e0231ULL, 0x00001f374e2e7589ULL, 0x000ea200000e0000ULL,
0x0000001042427824ULL, 0x000fc400078e0231ULL, 0x0000001044447824ULL, 0x100fe200078e0231ULL,
0x0000000036367984ULL, 0x000ee20000000800ULL, 0x0000001046467824ULL, 0x100fe400078e0231ULL,
0x0000001048487824ULL, 0x100fe200078e0231ULL, 0x0000000038387984ULL, 0x000f220000000800ULL,
0x000000104a4a7824ULL, 0x100fe400078e0231ULL, 0x0000001040407824ULL, 0x100fe200078e0231ULL,
0x00001f3b4e307589ULL, 0x000fe200000e0000ULL, 0x000000104c4c7824ULL, 0x000fc400078e0231ULL,
0x00000001393a7824ULL, 0x040fe400078e023aULL, 0x00000001393c7824ULL, 0x040fe400078e023cULL,
0x00000001393e7824ULL, 0x040fe400078e023eULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x0000000139427824ULL, 0x040fe400078e0242ULL, 0x0000000139467824ULL, 0x040fe200078e0246ULL,
0x000000003c3c7984ULL, 0x000ee20000000800ULL, 0x00000001394a7824ULL, 0x000fc400078e024aULL,
0x0000000139447824ULL, 0x040fe200078e0244ULL, 0x000000003e3e7984ULL, 0x000ee20000000800ULL,
0x0000000139407824ULL, 0x040fe200078e0240ULL, 0x00005410ff317816ULL, 0x102fe40000000033ULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x0000000139487824ULL, 0x040fe200078e0248ULL,
0x00007610ff337816ULL, 0x000fe20000000033ULL, 0x00000001394c7824ULL, 0x000fe200078e024cULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x0000002e312b7223ULL, 0x084fe2000001002bULL,
0x00005410ff317816ULL, 0x100fe20000000035ULL, 0x0000002e332a7223ULL, 0x000fe2000001002aULL,
0x000000004a4a7984ULL, 0x000fe20000000800ULL, 0x00007610ff357816ULL, 0x000fe20000000035ULL,
0x0000002d4e2d7221ULL, 0x000fc40000010000ULL, 0x0000002e311c7223ULL, 0x080fe2000001001cULL,
0x00005410ff317816ULL, 0x000fe20000000032ULL, 0x0000000044447984ULL, 0x000e620000000800ULL,
0x0000002e351b7223ULL, 0x000fc6000001001bULL, 0x0000002e31297223ULL, 0x080fe20000010029ULL,
0x00007610ff317816ULL, 0x000fe20000000032ULL, 0x0000000040407984ULL, 0x000fe80000000800ULL,
0x0000002e31287223ULL, 0x080fe20000010028ULL, 0x00005410ff317816ULL, 0x100fe20000000034ULL,
0x0000000048487984ULL, 0x000ea80000000800ULL, 0x0000002e31277223ULL, 0x080fe20000010027ULL,
0x00007610ff317816ULL, 0x000fe20000000034ULL, 0x000000004c4c7984ULL, 0x000ea80000000800ULL,
0x0000002e31267223ULL, 0x000fe20000010026ULL, 0x00005410ff317816ULL, 0x008fc40000000036ULL,
0x00007610ff367816ULL, 0x000fc60000000036ULL, 0x0000002e31247223ULL, 0x080fe20000010024ULL,
0x00005410ff317816ULL, 0x110fe20000000038ULL, 0x0000002e36237223ULL, 0x000fe20000010023ULL,
0x00007610ff387816ULL, 0x000fc60000000038ULL, 0x0000002e31227223ULL, 0x080fe20000010022ULL,
0x00005410ff317816ULL, 0x120fe2000000003aULL, 0x0000002e38217223ULL, 0x000fe20000010021ULL,
0x00007610ff3a7816ULL, 0x000fc6000000003aULL, 0x0000002e31207223ULL, 0x080fe20000010020ULL,
0x00005410ff317816ULL, 0x100fe2000000003cULL, 0x0000002e3a1f7223ULL, 0x000fe2000001001fULL,
0x00007610ff3c7816ULL, 0x000fc6000000003cULL, 0x0000002e311e7223ULL, 0x080fe2000001001eULL,
0x00007610ff317816ULL, 0x100fe2000000003eULL, 0x0000002e3c1d7223ULL, 0x000fe2000001001dULL,
0x00005410ff2e7816ULL, 0x000fc6000000003eULL, 0x00000030311a7223ULL, 0x080fe2000001001aULL,
0x00005410ff317816ULL, 0x002fe20000000044ULL, 0x000000302e097223ULL, 0x080fe20000010009ULL,
0x00005410ff2e7816ULL, 0x100fe40000000042ULL, 0x00007610ff427816ULL, 0x000fe20000000042ULL,
0x0000003031127223ULL, 0x080fe20000010012ULL, 0x00007610ff317816ULL, 0x000fe20000000044ULL,
0x000000302e137223ULL, 0x080fe20000010013ULL, 0x00005410ff2e7816ULL, 0x100fe20000000046ULL,
0x0000003042197223ULL, 0x080fe20000010019ULL, 0x00007610ff467816ULL, 0x000fe20000000046ULL,
0x0000003031187223ULL, 0x080fe20000010018ULL, 0x00005410ff317816ULL, 0x004fe20000000048ULL,
0x000000302e117223ULL, 0x080fe20000010011ULL, 0x00005410ff2e7816ULL, 0x100fe2000000004aULL,
0x0000003046177223ULL, 0x080fe20000010017ULL, 0x00007610ff4a7816ULL, 0x000fe2000000004aULL,
0x0000003031107223ULL, 0x080fe20000010010ULL, 0x00007610ff317816ULL, 0x000fe20000000048ULL,
0x000000302e0f7223ULL, 0x000fc4000001000fULL, 0x000000ffff2e7224ULL, 0x000fe200078e002fULL,
0x00005410ff2f7816ULL, 0x000fe20000000040ULL, 0x0000003031167223ULL, 0x080fe40000010016ULL,
0x000000304a157223ULL, 0x080fe20000010015ULL, 0x000003002e007a0cULL, 0x000fe20003f06070ULL,
0x000000302f0d7223ULL, 0x000fe2000001000dULL, 0x00007610ff2f7816ULL, 0x000fca0000000040ULL,
0x000000302f147223ULL, 0x000fe20000010014ULL, 0x00005410ff2f7816ULL, 0x100fe4000000004cULL,
0x00007610ff4c7816ULL, 0x000fc6000000004cULL, 0x000000302f0a7223ULL, 0x080fe4000001000aULL,
0x000000304c037223ULL, 0x000fe20000010003ULL, 0xfffff2f000008947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x0000001007087824ULL, 0x002fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011607ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x00000001080b7824ULL, 0x000fe200078e0207ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x0000001007087824ULL, 0x002fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011607ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c070c7812ULL, 0x000fc600078ec0ffULL, 0x0000008005077824ULL, 0x000fc800078e0208ULL,
0x000000010c087824ULL, 0x000fca00078e0207ULL, 0x0049802d08007388ULL, 0x0003e40000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x004980000b077984ULL, 0x000ea80000000800ULL, 0x004a00000b087984ULL, 0x002e620000000800ULL,
0x00000007ff077221ULL, 0x004fc80000010000ULL, 0x0000000807077221ULL, 0x002fca0000010000ULL,
0x0180000007087810ULL, 0x000fc80007ffe0ffULL, 0x7f80000008087812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0800780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0000b3a0002c7802ULL, 0x000fe40000000f00ULL, 0x00008e7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x00efe200078e0007ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700087308ULL, 0x000e640000001000ULL, 0xbf800000070b7423ULL, 0x002fc80000000008ULL,
0x800000ff0b0b7221ULL, 0x000fc80000010100ULL, 0x0000000b08087223ULL, 0x000fe40000000008ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008072d7811ULL, 0x002fe400078ff0ffULL,
0x00000002ff257819ULL, 0x000fe40000011607ULL, 0x0000002dff2c7212ULL, 0x000fe200078e33ffULL,
0x00001f2d080c7589ULL, 0x000e6200000e0000ULL, 0x000000082d397824ULL, 0x000fc400078e00ffULL,
0x00000008252e7824ULL, 0x000fe200078e00ffULL, 0x00001f25080b7589ULL, 0x0002a400000e0000ULL,
0xfffffff839397812ULL, 0x000fca00078ee22cULL, 0x0000001039397824ULL, 0x000fe400078e0202ULL,
0x000000190c087220ULL, 0x042fe40000410000ULL, 0x000000180c197220ULL, 0x040fe40000410000ULL,
0x0000000a0c0a7220ULL, 0x040fe40000410000ULL, 0x000000030c037220ULL, 0x040fe40000410000ULL,
0x000000170c187220ULL, 0x000fc40000410000ULL, 0x000000160c177220ULL, 0x040fe20000410000ULL,
0x0000000a0303723eULL, 0x000fe200000010ffULL, 0x000000090c097220ULL, 0x040fe20000410000ULL,
0x00000007250a7812ULL, 0x000fe200078ec0ffULL, 0x0000001a0c1a7220ULL, 0x040fe40000410000ULL,
0x000000130c137220ULL, 0x040fe40000410000ULL, 0x000000120c127220ULL, 0x000fe20000410000ULL,
0x000000091a09723eULL, 0x000fe200000010ffULL, 0x000000110c117220ULL, 0x000fe20000410000ULL,
0x000000130808723eULL, 0x000fe200000010ffULL, 0x000000100c107220ULL, 0x000fe20000410000ULL,
0x000000050a1a7812ULL, 0x000fe200078e3cffULL, 0x0000000f0c0f7220ULL, 0x000fe20000410000ULL,
0x000000111811723eULL, 0x000fe200000010ffULL, 0x000000150c167220ULL, 0x000fe20000410000ULL,
0x000000040a187812ULL, 0x000fe200078e3cffULL, 0x0000000d0c0d7220ULL, 0x040fe20000410000ULL,
0x000000121912723eULL, 0x000fe200000010ffULL, 0x000000140c147220ULL, 0x000fe20000410000ULL,
0x0000000f160f723eULL, 0x000fe200000010ffULL, 0x00000008250c7824ULL, 0x000fe200078e00ffULL,
0x000000030a167812ULL, 0x000fe200078e3cffULL, 0x0000002b0b2b7220ULL, 0x044fe20000410000ULL,
0x0000000d140d723eULL, 0x000fe200000010ffULL, 0x0000002a0b2a7220ULL, 0x040fe20000410000ULL,
0xfffffff80c137812ULL, 0x000fe200078ee225ULL, 0x000000290b297220ULL, 0x040fe20000410000ULL,
0x000000010a0c7812ULL, 0x040fe200078e3cffULL, 0x000000280b287220ULL, 0x040fe20000410000ULL,
0x000000020a147812ULL, 0x040fe200078e3cffULL, 0x000000270b277220ULL, 0x040fe20000410000ULL,
0x000000060a0a7812ULL, 0x000fe200078e3cffULL, 0x000000260b267220ULL, 0x000fe20000410000ULL,
0x000000101710723eULL, 0x000fe200000010ffULL, 0x000000240b247220ULL, 0x040fe20000410000ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x000000230b237220ULL, 0x040fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x000000220b227220ULL, 0x040fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x000000210b217220ULL, 0x000fe20000410000ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x000000200b207220ULL, 0x000fc40000410000ULL,
0x0000001f0b1f7220ULL, 0x000fe20000410000ULL, 0x000000222121723eULL, 0x000fe200000010ffULL,
0x0000001e0b1e7220ULL, 0x040fe40000410000ULL, 0x0000001d0b1d7220ULL, 0x000fe20000410000ULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x0000001c0b1c7220ULL, 0x040fe40000410000ULL,
0x0000001b0b0b7220ULL, 0x000fe20000410000ULL, 0x00000025ff1b7212ULL, 0x000fe200078e33ffULL,
0x0000000825157824ULL, 0x000fe200078e020cULL, 0x0000001e1d1d723eULL, 0x000fe200000010ffULL,
0x0000000825177824ULL, 0x040fe200078e0214ULL, 0xfffffff82e2f7812ULL, 0x000fe200078ee21bULL,
0x0000000825197824ULL, 0x000fe200078e0216ULL, 0x0000001c0b0b723eULL, 0x000fe200000010ffULL,
0x00000008251b7824ULL, 0x000fe200078e0218ULL, 0x000000072d1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000825277824ULL, 0x000fc400078e021aULL, 0x0000000825257824ULL, 0x000fe200078e020aULL,
0x000000011c0c7812ULL, 0x040fe200078e3cffULL, 0x00000004070a7824ULL, 0x000fe200078e00ffULL,
0x000000021c147812ULL, 0x040fe200078e3cffULL, 0x000000082d1e7824ULL, 0x000fe200078e00ffULL,
0x000000031c167812ULL, 0x040fe200078e3cffULL, 0x0000001013137824ULL, 0x000fe200078e0202ULL,
0x000000041c187812ULL, 0x040fe200078e3cffULL, 0x000000082d2b7824ULL, 0x040fe200078e020cULL,
0x000000051c1a7812ULL, 0x040fe200078e3cffULL, 0x000000082d317824ULL, 0x040fe200078e0214ULL,
0x000000061c1c7812ULL, 0x000fe200078e3cffULL, 0x000000082d337824ULL, 0x040fe200078e0216ULL,
0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000082d357824ULL, 0x040fe200078e0218ULL,
0xfffffff81e297812ULL, 0x000fe200078ee22dULL, 0x000000082d377824ULL, 0x000fc400078e021aULL,
0x0000001015157824ULL, 0x000fe400078e0202ULL, 0x000000082d2d7824ULL, 0x000fe400078e021cULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x0000001019197824ULL, 0x000fe400078e0202ULL,
0x0000000113137824ULL, 0x000fe400078e020aULL, 0x000000101b1b7824ULL, 0x000fc400078e0202ULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0x0000002a13007388ULL, 0x000fe20000000800ULL,
0x000000010a157824ULL, 0x000fe400078e0215ULL, 0x000000102f2f7824ULL, 0x100fe400078e0202ULL,
0x0000001029297824ULL, 0x100fe200078e0202ULL, 0x0000002815007388ULL, 0x000fe20000000800ULL,
0x0000001025257824ULL, 0x100fe400078e0202ULL, 0x000000102b2b7824ULL, 0x000fc400078e0202ULL,
0x0000001031317824ULL, 0x100fe400078e0202ULL, 0x0000001033337824ULL, 0x100fe400078e0202ULL,
0x0000001035357824ULL, 0x100fe400078e0202ULL, 0x0000001037377824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x000fe400078e0202ULL, 0x000000010a177824ULL, 0x000fc400078e0217ULL,
0x000000010a027824ULL, 0x040fe400078e0219ULL, 0x000000010a0c7824ULL, 0x040fe200078e021bULL,
0x0000002617007388ULL, 0x000fe20000000800ULL, 0x000000010a147824ULL, 0x040fe400078e0227ULL,
0x000000010a167824ULL, 0x040fe200078e0225ULL, 0x0000002302007388ULL, 0x000fe20000000800ULL,
0x000000010a187824ULL, 0x040fe400078e022fULL, 0x000000010a1a7824ULL, 0x040fe200078e0229ULL,
0x000000210c007388ULL, 0x0003e20000000800ULL, 0x000000010a2b7824ULL, 0x000fc400078e022bULL,
0x000000010a317824ULL, 0x040fe200078e0231ULL, 0x0000001f14007388ULL, 0x000fe20000000800ULL,
0x000000010a207824ULL, 0x040fe400078e0233ULL, 0x000000010a357824ULL, 0x040fe200078e0235ULL,
0x0000001d16007388ULL, 0x000fe20000000800ULL, 0x000000010a227824ULL, 0x000fe200078e0237ULL,
0x00000006060c723eULL, 0x002fe200000010ffULL, 0x000000010a247824ULL, 0x040fe200078e022dULL,
0x0000000b18007388ULL, 0x000fe20000000800ULL, 0x000000010a2c7824ULL, 0x000fc400078e0239ULL,
0x0000000104137824ULL, 0x000fe200078e0207ULL, 0x000000091a007388ULL, 0x000fe60000000800ULL,
0x0000001013137824ULL, 0x000fe200078e0200ULL, 0x000000082b007388ULL, 0x000fe80000000800ULL,
0x0000001231007388ULL, 0x000fe80000000800ULL, 0x0000001120007388ULL, 0x000fe80000000800ULL,
0x0000001035007388ULL, 0x000fe80000000800ULL, 0x0000000f22007388ULL, 0x000fe80000000800ULL,
0x0000000d24007388ULL, 0x000fe80000000800ULL, 0x000000032c007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000013147984ULL, 0x000e680000000c00ULL,
0x0004000013187984ULL, 0x000ea80000000c00ULL, 0x0008000013087984ULL, 0x000ee80000000c00ULL,
0x000c0000131c7984ULL, 0x000f220000000c00ULL, 0x3f803f800c177831ULL, 0x002fc40000200017ULL,
0x3f803f800c167831ULL, 0x040fe40000200016ULL, 0x3f803f800c157831ULL, 0x040fe40000200015ULL,
0x3f803f800c147831ULL, 0x040fe40000200014ULL, 0x3f803f800c1b7831ULL, 0x044fe4000020001bULL,
0x3f803f800c1a7831ULL, 0x040fe4000020001aULL, 0x3f803f800c197831ULL, 0x000fc40000200019ULL,
0x3f803f800c187831ULL, 0x000fe40000200018ULL, 0x3f803f8017177831ULL, 0x008fe4000020000bULL,
0x3f803f8016167831ULL, 0x000fe4000020000aULL, 0x3f803f8015157831ULL, 0x000fe40000200009ULL,
0x3f803f8014147831ULL, 0x000fe40000200008ULL, 0x3f803f801b1b7831ULL, 0x010fc4000020001fULL,
0x3f803f801a1a7831ULL, 0x000fe2000020001eULL, 0x0000001413007388ULL, 0x0003e20000000c00ULL,
0x3f803f8019197831ULL, 0x000fe4000020001dULL, 0x3f803f8018187831ULL, 0x000fca000020001cULL,
0x0004001813007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff0500720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000020070c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000047919ULL, 0x000ee20000002600ULL,
0x00000003ff067819ULL, 0x100fe20000011607ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x00000003ff037819ULL, 0x100fe2000001160cULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000706087812ULL, 0x100fe200078e4807ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000703027812ULL, 0x100fe200078e480cULL, 0x000000080e147824ULL, 0x006fe200078e00ffULL,
0x0ffffff808097812ULL, 0x000fe200078ef807ULL, 0x000000080e0f7824ULL, 0x000fe200078e00ffULL,
0x0ffffff802057812ULL, 0x000fc600078ef80cULL, 0x0000001009027824ULL, 0x100fe400078e0200ULL,
0x0000001005057824ULL, 0x000fc600078e0200ULL, 0x0000000002087984ULL, 0x0002a80000000c00ULL,
0x0000000005107984ULL, 0x000aa20000000c00ULL, 0x00000008040d7824ULL, 0x048fe400078e00ffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x010fe4000f8e023fULL,
0xfffffff80d007812ULL, 0x000fc400078ee206ULL, 0xfffffff804037812ULL, 0x000fe400078ee203ULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403007c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff8140d7812ULL, 0x000fe200078ee207ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0006027a11ULL, 0x002fe200078040ffULL, 0x000000ffff057224ULL, 0x020fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fc400078240ffULL, 0x00005b0006037a11ULL, 0x000fe400000f4403ULL,
0x00005b0000057a11ULL, 0x000fe400008f4405ULL, 0xfffffff80f077812ULL, 0x000fe200078ee20cULL,
0x000000100d027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x004fe8000c101d06ULL, 0x0000001004007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000415137824ULL, 0x000fe400078e0260ULL,
0xffffffffff127424ULL, 0x000fc600078e00ffULL, 0x000000161300720cULL, 0x000fda0003f06070ULL,
0x000000020b028824ULL, 0x000fc800078e00ffULL, 0x0000640002078a24ULL, 0x002fc800078e0213ULL,
0x0000600007068625ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000606128981ULL, 0x000ea2000c1e1900ULL, 0x0000000115057810ULL, 0x000fe20007ffe0ffULL,
0x0000004018117824ULL, 0x000fe400078e00ffULL, 0x01b60000ff027f8cULL, 0x000e62000c80043fULL,
0x000000140500720cULL, 0x000fe20003f06070ULL, 0x0000004060107824ULL, 0x000fe400078e00ffULL,
0x0000001112057224ULL, 0x004fd400078e02ffULL, 0x00000e8000008947ULL, 0x000fea0003800000ULL,
0x0000010015087824ULL, 0x002fe200078e0210ULL, 0x00000003ff097819ULL, 0x000fe40000011600ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000817077217ULL, 0x000fe40007800000ULL,
0x00000004090d7810ULL, 0x040fe40007ffe0ffULL, 0x00000010091b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107087824ULL, 0x000fe200078e0a08ULL, 0x0000000809077810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0x000000000d067212ULL, 0x080fe200078e3cffULL,
0x000000081b1d7824ULL, 0x000fe200078e00ffULL, 0x00000000070a7212ULL, 0x040fe200078e3cffULL,
0x0000000807197824ULL, 0x000fe200078e00ffULL, 0xfffffff80f1c7812ULL, 0x000fe200078ee206ULL,
0x0000004061067824ULL, 0x000fe200078e0209ULL, 0x000000080d00720cULL, 0x000fc40003f86070ULL,
0x0000000c090d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8191e7812ULL, 0x000fe400078ee20aULL,
0x00000004060a7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d207824ULL, 0x000fe200078e00ffULL,
0x000000080700720cULL, 0x000fe40003f66070ULL, 0x000000000d077212ULL, 0x000fe400078e3cffULL,
0x00000006050e7210ULL, 0x000fc40007f1e0ffULL, 0x0000000a050a7210ULL, 0x000fe40007fbe0ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x000000080d00720cULL, 0x000fe20003f46070ULL, 0x000000ffff077224ULL, 0x000fe200028e06ffULL,
0x000000001b0c7212ULL, 0x000fe400078e3cffULL, 0x00005e000e0d7a11ULL, 0x000fe400078240ffULL,
0x00005e000a0f7a11ULL, 0x000fc400078a40ffULL, 0xfffffff81d227812ULL, 0x000fe400078ee20cULL,
0x00005f000e0e7a11ULL, 0x000fe400008f4419ULL, 0x00005f000a187a11ULL, 0x000fe400028f4407ULL,
0x0000000d040c7210ULL, 0x000fe40007f3e0ffULL, 0x00000008060a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000709197812ULL, 0x000fe200078e4800ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060eULL,
0x0000000a050a7210ULL, 0x000fc40007fde0ffULL, 0x000000081b00720cULL, 0x080fe40003f06070ULL,
0x0000000f040e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x00000014091b7810ULL, 0x000fe40007ffe0ffULL, 0x0000100060077811ULL, 0x000fe200078e70ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0618ULL, 0x0ffffff8191a7812ULL, 0x000fe200078ef800ULL,
0x000000081b247824ULL, 0x000fe200078e00ffULL, 0x000000080900720cULL, 0x000fc40003fa6070ULL,
0x00005e000a197a11ULL, 0x000fe400078c40ffULL, 0x000000001b1f7212ULL, 0x040fe400078e3cffULL,
0x000000081b00720cULL, 0x000fe20003f26070ULL, 0x000000101a1b7824ULL, 0x000fe200078e0207ULL,
0x00005f000a1a7a11ULL, 0x000fe200030f441dULL, 0x000000101c1d7824ULL, 0x000fe200078e0207ULL,
0x0000000c060a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824247812ULL, 0x000fe200078ee21fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000e901c46ULL,
0x0000000a050a7210ULL, 0x000fc40007fde0ffULL, 0x0000001904187210ULL, 0x000fe20007fbe0ffULL,
0x000000000e1d7faeULL, 0x0005e2000e101c46ULL, 0x00000018091f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c09217810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200028e061aULL,
0x000000001f1c7212ULL, 0x040fe200078e3cffULL, 0x000000081f237824ULL, 0x040fe200078e00ffULL,
0x000000081f00720cULL, 0x000fe20003f86070ULL, 0x000000ffff1b7224ULL, 0x002fe200030e06ffULL,
0x00005e000a0d7a11ULL, 0x000fe200078c40ffULL, 0x0000000821287824ULL, 0x000fe200078e00ffULL,
0xfffffff823267812ULL, 0x000fe200078ee21cULL, 0x000000101e0f7824ULL, 0x004fe200078e0207ULL,
0x00005f000a0e7a11ULL, 0x000fe200030f441bULL, 0x00000010201b7824ULL, 0x000fe200078e0207ULL,
0x00000010060a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000d040c7210ULL, 0x000fe20007fde0ffULL,
0x00000000180f7faeULL, 0x0003e2000d901c46ULL, 0x0000000a051a7210ULL, 0x000fe40007f7e0ffULL,
0x00000014060a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e060eULL,
0x00000000211f7212ULL, 0x000fe400078e3cffULL, 0x0000000a051c7210ULL, 0x000fe40007fde0ffULL,
0x000000082100720cULL, 0x000fe20003fa6070ULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x00000020091d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x002fe200030e06ffULL,
0x00005e001c0f7a11ULL, 0x000fe200078c40ffULL, 0x000000000c1b7faeULL, 0x0003e2000d101c46ULL,
0xfffffff828287812ULL, 0x000fe200078ee21fULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x00005e001a1f7a11ULL, 0x000fc400078640ffULL, 0x00000018060a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001c187a11ULL, 0x000fe400030f4419ULL, 0x000000001d0e7212ULL, 0x040fe400078e3cffULL,
0x000000081d00720cULL, 0x000fe20003f46070ULL, 0x00000010221b7824ULL, 0x002fe200078e0207ULL,
0x0000002409197810ULL, 0x000fe40007ffe0ffULL, 0x00005f001a1d7a11ULL, 0x000fc400018f4421ULL,
0x0000001f040c7210ULL, 0x040fe20007f7e0ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x0000000a05207210ULL, 0x000fe40007fde0ffULL, 0x00000000190a7212ULL, 0x000fe200078e3cffULL,
0x000000ffff0d7224ULL, 0x000fe200018e061dULL, 0xfffffff8231a7812ULL, 0x000fe200078ee20eULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0x0000000f040e7210ULL, 0x000fe40007f7e0ffULL,
0x00005e0020237a11ULL, 0x000fe200078c40ffULL, 0x000000000c1b7faeULL, 0x0003e2000c101c46ULL,
0xfffffff81f1c7812ULL, 0x000fe200078ee20aULL, 0x000000ffff0f7224ULL, 0x000fe200018e0618ULL,
0x0000001c060a7810ULL, 0x000fc40007ffe0ffULL, 0x0000002c091f7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0020207a11ULL, 0x000fe200030f441dULL, 0x00000010241d7824ULL, 0x000fe200078e0207ULL,
0x000000081900720cULL, 0x000fe40003f66070ULL, 0x0000002809197810ULL, 0x000fe20007ffe0ffULL,
0x000000081f1b7824ULL, 0x002fe200078e00ffULL, 0x0000000a05217210ULL, 0x000fe20007fde0ffULL,
0x000000000e1d7faeULL, 0x0003e2000c901c46ULL, 0x0000002304187210ULL, 0x000fe20007f1e0ffULL,
0x0000000819257824ULL, 0x000fe200078e00ffULL, 0x000000001f0a7212ULL, 0x080fe200078e3cffULL,
0x000000ffff0c7224ULL, 0x000fe200030e06ffULL, 0x00000000191e7212ULL, 0x000fc400078e3cffULL,
0x000000081900720cULL, 0x000fe20003f26070ULL, 0x000000ffff197224ULL, 0x000fe200000e0620ULL,
0x00005e00210d7a11ULL, 0x000fe400078c40ffULL, 0xfffffff81b207812ULL, 0x000fe200078ee20aULL,
0x00000010260f7824ULL, 0x102fe200078e0207ULL, 0x00000020060a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010281b7824ULL, 0x000fe200078e0207ULL, 0x00005f00210e7a11ULL, 0x000fe400030f440cULL,
0x0000000d040c7210ULL, 0x000fe20007fde0ffULL, 0x00000000180f7faeULL, 0x0003e2000e101c46ULL,
0x0000000a05227210ULL, 0x000fc40007f9e0ffULL, 0x00000024060a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e060eULL, 0x000000081f00720cULL, 0x000fe20003f06070ULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0x0000000a051f7210ULL, 0x000fe40007fde0ffULL,
0x00000030091d7810ULL, 0x000fe20007ffe0ffULL, 0x000000000c1b7faeULL, 0x0005e2000e901c46ULL,
0x00005e0022217a11ULL, 0x000fe200078840ffULL, 0x000000ffff187224ULL, 0x002fe200030e06ffULL,
0xfffffff8251e7812ULL, 0x000fe200078ee21eULL, 0x000000081d257824ULL, 0x040fe200078e00ffULL,
0x000000001d0e7212ULL, 0x000fc400078e3cffULL, 0x000000081d00720cULL, 0x000fe40003fa6070ULL,
0x00005e001f0f7a11ULL, 0x040fe400078c40ffULL, 0x00005f00221d7a11ULL, 0x000fe400020f4423ULL,
0x00000028060a7810ULL, 0x000fe40007ffe0ffULL, 0x00000021040c7210ULL, 0x004fe40007f9e0ffULL,
0x00005f001f1b7a11ULL, 0x000fc400030f4418ULL, 0x0000000a05187210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e061dULL, 0xfffffff825227812ULL, 0x000fe400078ee20eULL,
0x0000003409197810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x0000000f040e7210ULL, 0x000fe40007f9e0ffULL, 0x00005e00181f7a11ULL, 0x000fe200078c40ffULL,
0x0000000819217824ULL, 0x040fe200078e00ffULL, 0x00000000190a7212ULL, 0x040fe200078e3cffULL,
0x000000ffff0f7224ULL, 0x000fe200020e061bULL, 0x000000081900720cULL, 0x000fe20003f86070ULL,
0x000000101a1b7824ULL, 0x000fe200078e0207ULL, 0x00005f0018197a11ULL, 0x000fe200030f441dULL,
0x000000101c1d7824ULL, 0x000fe200078e0207ULL, 0xfffffff821247812ULL, 0x000fc400078ee20aULL,
0x0000002c060a7810ULL, 0x000fe20007ffe0ffULL, 0x000000000c1b7faeULL, 0x0003e2000d101c46ULL,
0x0000001f04187210ULL, 0x000fe20007f5e0ffULL, 0x000000101e1f7824ULL, 0x000fe200078e0207ULL,
0x0000003809217810ULL, 0x000fe20007ffe0ffULL, 0x000000000e1d7faeULL, 0x0005e2000d901c46ULL,
0x0000000a050a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000003c09237810ULL, 0x000fe40007ffe0ffULL, 0x00005e000a257a11ULL, 0x000fe200078c40ffULL,
0x000000ffff097224ULL, 0x000fe200018e06ffULL, 0x000000082100720cULL, 0x080fe20003f66070ULL,
0x00000000181f7faeULL, 0x0007e2000c901c46ULL, 0x000000082300720cULL, 0x000fe20003f46070ULL,
0x00000008210c7824ULL, 0x002fe200078e00ffULL, 0x0000003006087810ULL, 0x000fe20007ffe0ffULL,
0x00000008230f7824ULL, 0x004fe200078e00ffULL, 0x00005f000a0a7a11ULL, 0x000fc400030f4409ULL,
0x00000008051a7210ULL, 0x000fe40007f3e0ffULL, 0x0000000021097212ULL, 0x080fe400078e3cffULL,
0x0000000023007212ULL, 0x000fe200078e3cffULL, 0x000000ffff0d7224ULL, 0x000fe200008e06ffULL,
0x00005e001a237a11ULL, 0x000fe200078c40ffULL, 0x0000001024197824ULL, 0x108fe200078e0207ULL,
0x0000002504087210ULL, 0x000fe40007f3e0ffULL, 0xfffffff80f0e7812ULL, 0x000fe200078ee200ULL,
0x00000010220f7824ULL, 0x000fe200078e0207ULL, 0x0000003406007810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x000000ffff097224ULL, 0x000fe200008e060aULL,
0x00005f001a1a7a11ULL, 0x000fe200030f440dULL, 0x00000010200d7824ULL, 0x100fe200078e0207ULL,
0x00000038060a7810ULL, 0x000fe20007ffe0ffULL, 0x000000100e1d7824ULL, 0x100fe200078e0207ULL,
0x0000003c06067810ULL, 0x000fe20007ffe0ffULL, 0x000000100c1b7824ULL, 0x000fe200078e0207ULL,
0x0000000005187210ULL, 0x040fe20007f3e0ffULL, 0x00000000080d7faeULL, 0x0003e2000c101c46ULL,
0x0000000a050a7210ULL, 0x000fc40007f1e0ffULL, 0x0000000605007210ULL, 0x000fe20007fde0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005e0018217a11ULL, 0x000fe200078240ffULL,
0x000000ffff1f7224ULL, 0x000fc600000e06ffULL, 0x00005f00180e7a11ULL, 0x000fe400008f4405ULL,
0x0000002304067210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x002fe200030e06ffULL,
0x00005e000a0d7a11ULL, 0x000fe400078040ffULL, 0x00005e0000057a11ULL, 0x000fe200078c40ffULL,
0x000000ffff077224ULL, 0x000fe200008e061aULL, 0x0000002104087210ULL, 0x000fe40007f3e0ffULL,
0x00005f000a0a7a11ULL, 0x000fc400000f441fULL, 0x00005f0000007a11ULL, 0x000fe200030f4409ULL,
0x000000ffff097224ULL, 0x000fe200008e060eULL, 0x0000000d040c7210ULL, 0x040fe20007f1e0ffULL,
0x00000000060f7faeULL, 0x0003e2000e901c46ULL, 0x0000000504047210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060aULL, 0x0000000008197faeULL, 0x0003e2000e101c46ULL,
0x000000ffff057224ULL, 0x000fc600008e0600ULL, 0x000000000c1b7faeULL, 0x0003e8000d901c46ULL,
0x00000000041d7faeULL, 0x0003e2000d101c46ULL, 0x00000d4000007947ULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x002fc80000011600ULL, 0x0000000406077810ULL, 0x040fe40007ffe0ffULL,
0x0000000806097810ULL, 0x040fe40007ffe0ffULL, 0x0000000c060d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000807197824ULL, 0x040fe200078e00ffULL, 0x0000000007087212ULL, 0x080fe200078e3cffULL,
0x00000008090c7824ULL, 0x040fe200078e00ffULL, 0x0000000009077212ULL, 0x080fe200078e3cffULL,
0x000000080d0e7824ULL, 0x040fe200078e00ffULL, 0x000000000d097212ULL, 0x000fc400078e3cffULL,
0x00000010060f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80c1b7812ULL, 0x000fe400078ee207ULL,
0xfffffff80e1f7812ULL, 0x000fe200078ee209ULL, 0x000000080f237824ULL, 0x000fe200078e00ffULL,
0x0000001406077810ULL, 0x040fe40007ffe0ffULL, 0x0000001806097810ULL, 0x040fe40007ffe0ffULL,
0x0000001c060d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008072d7824ULL, 0x000fe200078e00ffULL,
0x000000000f0a7212ULL, 0x080fe200078e3cffULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8190f7812ULL, 0x000fe200078ee208ULL, 0x000000080d0e7824ULL, 0x000fe200078e00ffULL,
0x0000000007087212ULL, 0x000fc400078e3cffULL, 0x0000000009077212ULL, 0x080fe400078e3cffULL,
0x000000000d097212ULL, 0x000fe400078e3cffULL, 0x0000002006197810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c357812ULL, 0x000fe400078ee207ULL, 0xfffffff80e377812ULL, 0x000fe200078ee209ULL,
0x0000000819397824ULL, 0x000fe200078e00ffULL, 0x0000002406077810ULL, 0x000fc40007ffe0ffULL,
0xfffffff823237812ULL, 0x000fe400078ee20aULL, 0x0000002806097810ULL, 0x040fe20007ffe0ffULL,
0x00000008073b7824ULL, 0x000fe200078e00ffULL, 0x00000000190a7212ULL, 0x080fe400078e3cffULL,
0x0000002c060d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0x0000003006197810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL,
0x000000080d0e7824ULL, 0x000fe200078e00ffULL, 0x0000000007087212ULL, 0x080fe200078e3cffULL,
0x0000000819417824ULL, 0x000fe200078e00ffULL, 0x0000000009077212ULL, 0x000fc400078e3cffULL,
0x000000000d097212ULL, 0x080fe400078e3cffULL, 0xfffffff839397812ULL, 0x000fe400078ee20aULL,
0x00000034060d7810ULL, 0x040fe40007ffe0ffULL, 0x00000000190a7212ULL, 0x000fe400078e3cffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee208ULL, 0x0000004061087824ULL, 0x000fe200078e0206ULL,
0x0000003806197810ULL, 0x000fe20007ffe0ffULL, 0x000000080d437824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fc400078ee20aULL, 0x0000003c061d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000819457824ULL, 0x000fe200078e00ffULL, 0x000000000d0a7212ULL, 0x000fe400078e3cffULL,
0xfffffff80c3d7812ULL, 0x000fe400078ee207ULL, 0xfffffff80e3f7812ULL, 0x000fe200078ee209ULL,
0x000000081d0e7824ULL, 0x000fe200078e00ffULL, 0x0000000706077812ULL, 0x000fe400078e4800ULL,
0x0000000805067210ULL, 0x000fc40007f1e0ffULL, 0x00000000190c7212ULL, 0x080fe400078e3cffULL,
0xfffffff843437812ULL, 0x000fe400078ee20aULL, 0x000000001d0d7212ULL, 0x000fe400078e3cffULL,
0x00000008080a7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff807097812ULL, 0x000fe200078ef800ULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0xfffffff845457812ULL, 0x000fc400078ee20cULL,
0xfffffff80e477812ULL, 0x000fe400078ee20dULL, 0x00000010081a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a050c7210ULL, 0x040fe40007f3e0ffULL, 0x00005e0006007a11ULL, 0x000fe400078040ffULL,
0x0000000c080e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x0000001a051c7210ULL, 0x000fc40007f7e0ffULL, 0x00005f0006077a11ULL, 0x000fe400000f4407ULL,
0x0000000e05187210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x0000000408067810ULL, 0x000fe40007ffe0ffULL, 0x00005e000c0e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e06ffULL, 0x0000000605067210ULL, 0x000fe40007f1e0ffULL,
0x00005e001c1e7a11ULL, 0x000fc400078640ffULL, 0x00005f000c197a11ULL, 0x000fe200008f4419ULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e00181a7a11ULL, 0x000fe400078440ffULL,
0x00000018080c7810ULL, 0x000fe40007ffe0ffULL, 0x00005f001c217a11ULL, 0x000fe400018f4421ULL,
0x00005f00181d7a11ULL, 0x000fe400010f441dULL, 0x00000020081c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c050c7210ULL, 0x040fe40007f3e0ffULL, 0x00005e00060a7a11ULL, 0x000fe400078040ffULL,
0x0000001c08187810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x0000001c05247210ULL, 0x040fe40007f7e0ffULL, 0x00005f00060d7a11ULL, 0x000fe400000f440dULL,
0x0000001805207210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x0000001408067810ULL, 0x000fc40007ffe0ffULL, 0x00005e000c1c7a11ULL, 0x000fe200078240ffULL,
0x000000ffff297224ULL, 0x000fe200010e06ffULL, 0x0000000605067210ULL, 0x000fe40007f1e0ffULL,
0x00005e00242a7a11ULL, 0x000fe400078640ffULL, 0x00005f000c267a11ULL, 0x000fe200008f4427ULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x00005e0020227a11ULL, 0x000fe400078440ffULL,
0x00000024080c7810ULL, 0x000fc40007ffe0ffULL, 0x00005f00242c7a11ULL, 0x000fe400018f442bULL,
0x00005f0020287a11ULL, 0x000fe400010f4429ULL, 0x0000000c050c7210ULL, 0x000fe40007f7e0ffULL,
0x00005e0006187a11ULL, 0x000fe400078040ffULL, 0x0000002808207810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x0000002c08247810ULL, 0x000fc40007ffe0ffULL,
0x00000030082e7810ULL, 0x040fe40007ffe0ffULL, 0x0000003408327810ULL, 0x040fe40007ffe0ffULL,
0x0000003808367810ULL, 0x040fe40007ffe0ffULL, 0x0000003c083a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0006257a11ULL, 0x000fe400000f4425ULL, 0x0000002005087210ULL, 0x000fc40007f5e0ffULL,
0x0000100060067811ULL, 0x000fe400078e70ffULL, 0x00005e000c207a11ULL, 0x040fe400078c40ffULL,
0x0000002405307210ULL, 0x000fe20007f1e0ffULL, 0x000000100f297824ULL, 0x100fe200078e0206ULL,
0x0000002e05347210ULL, 0x000fe20007f3e0ffULL, 0x0000001023317824ULL, 0x100fe200078e0206ULL,
0x0000003205387210ULL, 0x000fe20007f7e0ffULL, 0x000000102d337824ULL, 0x100fe200078e0206ULL,
0x00000036053c7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x0000003a05407210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x00005f000c2e7a11ULL, 0x000fe200030f4427ULL, 0x0000001009277824ULL, 0x100fe200078e0206ULL,
0x00005e0008247a11ULL, 0x000fe200078440ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0030327a11ULL, 0x000fe200078040ffULL, 0x000000101b2b7824ULL, 0x100fe200078e0206ULL,
0x00005e0034367a11ULL, 0x000fe200078240ffULL, 0x000000101f2f7824ULL, 0x100fe200078e0206ULL,
0x00005f0008237a11ULL, 0x000fe200010f4405ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x00005f0030307a11ULL, 0x000fe200000f4409ULL, 0x000000ffff097224ULL, 0x000fe200020e06ffULL,
0x00005f0034347a11ULL, 0x000fe200008f440fULL, 0x000000ffff0f7224ULL, 0x000fe200028e06ffULL,
0x00000070042d7812ULL, 0x000fe200078ec0ffULL, 0x0000001035357824ULL, 0x100fe200078e0206ULL,
0x00005e00383a7a11ULL, 0x000fe200078240ffULL, 0x0000001037377824ULL, 0x100fe200078e0206ULL,
0x00005e003c3e7a11ULL, 0x000fe200078440ffULL, 0x0000001039397824ULL, 0x100fe200078e0206ULL,
0x00005e0040427a11ULL, 0x000fe200078640ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0206ULL,
0x000000002d047210ULL, 0x000fe20007f1e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0206ULL,
0x00005f0038387a11ULL, 0x000fe200008f4405ULL, 0x000000103f3f7824ULL, 0x100fe200078e0206ULL,
0x00005f003c3c7a11ULL, 0x000fe200010f4409ULL, 0x0000001041417824ULL, 0x100fe200078e0206ULL,
0x00005f0040407a11ULL, 0x000fe200018f440fULL, 0x0000001043437824ULL, 0x100fe200078e0206ULL,
0x0000000e2d087210ULL, 0x000fe20007f5e0ffULL, 0x0000001045457824ULL, 0x100fe200078e0206ULL,
0x0000001a2d0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001047477824ULL, 0x000fe200078e0206ULL,
0x0000000a2d067210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0607ULL,
0x0000001e2d0e7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0619ULL,
0x000000182d187210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e060dULL,
0x0000001c2d1a7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200018e061dULL,
0x000000222d1c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e0621ULL,
0x0000002a2d1e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff197224ULL, 0x000fe200020e0625ULL,
0x000000202d207210ULL, 0x040fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004277faeULL, 0x0003e2000b901c46ULL, 0x000000242d227210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e0626ULL, 0x000000322d247210ULL, 0x040fe20007f9e0ffULL,
0x0000000006297faeULL, 0x0005e2000b901c46ULL, 0x000000362d267210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e0628ULL, 0x0000003a2d287210ULL, 0x040fe20007f3e0ffULL,
0x00000000082b7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200010e062cULL,
0x0000003e2d2a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e062eULL,
0x000000000c2f7faeULL, 0x0009e2000b901c46ULL, 0x000000422d2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff237224ULL, 0x000fc400028e0623ULL, 0x000000000e317faeULL, 0x0009e2000b901c46ULL,
0x000000ffff257224ULL, 0x000fe400020e0630ULL, 0x000000ffff277224ULL, 0x002fe200000e0634ULL,
0x0000000018337faeULL, 0x0009e2000b901c46ULL, 0x000000ffff297224ULL, 0x004fe400008e0638ULL,
0x000000ffff2b7224ULL, 0x008fe200010e063cULL, 0x000000001a357faeULL, 0x0009e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x000fc600018e0640ULL, 0x000000001c377faeULL, 0x0009e8000b901c46ULL,
0x000000001e397faeULL, 0x0009e8000b901c46ULL, 0x00000000203b7faeULL, 0x0009e8000b901c46ULL,
0x00000000223d7faeULL, 0x0009e8000b901c46ULL, 0x00000000243f7faeULL, 0x0009e8000b901c46ULL,
0x0000000026417faeULL, 0x0009e8000b901c46ULL, 0x0000000028437faeULL, 0x0009e8000b901c46ULL,
0x000000002a457faeULL, 0x0009e8000b901c46ULL, 0x000000002c477faeULL, 0x0009e4000b901c46ULL,
0x01b60400ff057984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000005ff7812ULL, 0x002fc60007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x01b60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000141500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x010e620000000000ULL,
0x000064000b0e7a24ULL, 0x000fe200078e02ffULL, 0x0001b688600d7811ULL, 0x040fe200078e18ffULL,
0x00000020600b7824ULL, 0x000fe200078e00ffULL, 0xffffffff140c7810ULL, 0x000fe40007ffe0ffULL,
0x00000100150a7824ULL, 0x000fe200078e0210ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000000a1700720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x014fea0003800000ULL,
0x0000000115037810ULL, 0x000fe20007ffe0ffULL, 0x0000001211127224ULL, 0x000fc600078e02ffULL,
0x000000140300720cULL, 0x000fda0003f06070ULL, 0x00000d8000008947ULL, 0x000fea0003800000ULL,
0x00000003ff9a7819ULL, 0x002fe2000001160fULL, 0x0000000117317824ULL, 0x000fc600078e0a0aULL,
0x000000049a967810ULL, 0x040fe20007ffe0ffULL, 0x0000004061987824ULL, 0x000fe200078e029aULL,
0x000000089a947810ULL, 0x000fe40007ffe0ffULL, 0x0000000f96937212ULL, 0x0c0fe200078e3cffULL,
0x0000000896007824ULL, 0x000fe200078e00ffULL, 0x0000000c9a907810ULL, 0x040fe40007ffe0ffULL,
0x000000109a8e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff800937812ULL, 0x000fe200078ee293ULL,
0x0000000894007824ULL, 0x040fe200078e00ffULL, 0x0000000f94917212ULL, 0x080fe200078e3cffULL,
0x0000000890027824ULL, 0x040fe200078e00ffULL, 0x0000000f908d7212ULL, 0x000fe200078e3cffULL,
0x000000088e047824ULL, 0x000fe200078e00ffULL, 0x000000149a8a7810ULL, 0x000fc40007ffe0ffULL,
0x000000189a887810ULL, 0x000fe40007ffe0ffULL, 0xfffffff800917812ULL, 0x000fe200078ee291ULL,
0x000000088a007824ULL, 0x000fe200078e00ffULL, 0xfffffff8028d7812ULL, 0x000fe200078ee28dULL,
0x0000000888027824ULL, 0x000fe200078e00ffULL, 0x0000000f8e8b7212ULL, 0x080fe400078e3cffULL,
0x0000001c9a847810ULL, 0x000fe40007ffe0ffULL, 0x0000000f8a877212ULL, 0x000fc400078e3cffULL,
0x0000000f88857212ULL, 0x000fe400078e3cffULL, 0x0000000498957810ULL, 0x040fe40007ffe0ffULL,
0x0000000898927810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8048b7812ULL, 0x000fe200078ee28bULL,
0x0000000884047824ULL, 0x000fe200078e00ffULL, 0xfffffff800877812ULL, 0x000fe400078ee287ULL,
0xfffffff802857812ULL, 0x000fc400078ee285ULL, 0x0000000f84817212ULL, 0x000fe400078e3cffULL,
0x0000001295027210ULL, 0x080fe40007f3e0ffULL, 0x0000001292007210ULL, 0x080fe40007f5e0ffULL,
0xfffffff804817812ULL, 0x000fe200078ee281ULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x000000209a827810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff037224ULL, 0x000fe200010e06ffULL,
0x0000001298047210ULL, 0x000fc40007f1e0ffULL, 0x00005e00022c7a11ULL, 0x000fe200078240ffULL,
0x0000000882067824ULL, 0x000fe200078e00ffULL, 0x00005e00002a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x0000001498897810ULL, 0x040fe40007ffe0ffULL,
0x0000001898867810ULL, 0x000fe40007ffe0ffULL, 0x00005f00022d7a11ULL, 0x000fe400008f4405ULL,
0x00005f00002b7a11ULL, 0x000fc400010f4403ULL, 0x0000000f827f7212ULL, 0x000fe400078e3cffULL,
0x00005e00042e7a11ULL, 0x000fe400078040ffULL, 0x0000001289027210ULL, 0x080fe40007f5e0ffULL,
0x0000001286007210ULL, 0x000fe40007f7e0ffULL, 0x0000000c988f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x00000010988c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff037224ULL, 0x000fe200018e06ffULL, 0xfffffff8067f7812ULL, 0x000fc400078ee27fULL,
0x00005f00042f7a11ULL, 0x000fe400000f4407ULL, 0x000000128f067210ULL, 0x080fe40007f1e0ffULL,
0x000000128c047210ULL, 0x000fe40007f3e0ffULL, 0x00005e0002247a11ULL, 0x000fe200078440ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e0000227a11ULL, 0x000fe200078640ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00000024987d7810ULL, 0x000fc40007ffe0ffULL,
0x00000028987a7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0002257a11ULL, 0x000fe400010f4405ULL,
0x00005f0000237a11ULL, 0x000fe400018f4403ULL, 0x00005e0006287a11ULL, 0x000fe400078040ffULL,
0x000000127d027210ULL, 0x080fe40007f5e0ffULL, 0x000000127a007210ULL, 0x000fc40007f7e0ffULL,
0x00005e0004267a11ULL, 0x000fe200078240ffULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x0000001c98837810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff037224ULL, 0x000fe200018e06ffULL,
0x0000002098807810ULL, 0x000fe40007ffe0ffULL, 0x00005f0006297a11ULL, 0x000fe400000f4409ULL,
0x00005f0004277a11ULL, 0x000fe400008f4407ULL, 0x0000001283067210ULL, 0x000fc40007f1e0ffULL,
0x0000001280047210ULL, 0x000fe40007f3e0ffULL, 0x00005e00021a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e00001c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000003498717810ULL, 0x000fe40007ffe0ffULL,
0x00005f00021b7a11ULL, 0x000fe400010f4405ULL, 0x00005f00001d7a11ULL, 0x000fc400018f4403ULL,
0x00005e0006207a11ULL, 0x000fe400078040ffULL, 0x00000038986e7810ULL, 0x000fe40007ffe0ffULL,
0x0000001271037210ULL, 0x000fe40007f5e0ffULL, 0x00005e00041e7a11ULL, 0x000fe400078240ffULL,
0x0000002c98777810ULL, 0x040fe40007ffe0ffULL, 0x0000003098747810ULL, 0x000fc40007ffe0ffULL,
0x00005f0006217a11ULL, 0x000fe200000f4409ULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0x000000126e007210ULL, 0x080fe40007f7e0ffULL, 0x00005f00041f7a11ULL, 0x000fe400008f4407ULL,
0x0000001277097210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x0000001274077210ULL, 0x000fe40007f3e0ffULL, 0x00005e0003027a11ULL, 0x040fe200078440ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005e0000047a11ULL, 0x000fe200078640ffULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x00005f0003037a11ULL, 0x000fc400010f4406ULL,
0x00005e0009187a11ULL, 0x000fe400078040ffULL, 0x0000000f9a067212ULL, 0x000fe400078e3cffULL,
0x00005e0007087a11ULL, 0x000fe400078240ffULL, 0x00005f0000057a11ULL, 0x000fe400018f4405ULL,
0x00005f0009197a11ULL, 0x000fe400000f4432ULL, 0x000000070f007812ULL, 0x000fc400078ec0ffULL,
0x0000000706067812ULL, 0x000fe400078ec0ffULL, 0x00005f0007097a11ULL, 0x000fe400008f4430ULL,
0x000000319a00720cULL, 0x080fe40003f06070ULL, 0x000000319600720cULL, 0x080fe40003f26070ULL,
0x000000319400720cULL, 0x000fe40003f46070ULL, 0x0000300060307811ULL, 0x000fc400078e70ffULL,
0x0000000800337812ULL, 0x000fe400078efcffULL, 0x0000003c986b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001093377824ULL, 0x000fe200078e0230ULL, 0x0ffffff806977812ULL, 0x000fe200078ef80fULL,
0x00000010332e7825ULL, 0x000fe200078e002eULL, 0x000000319000720cULL, 0x000fe40003f66070ULL,
0x000000126b127210ULL, 0x000fe20007f9e0ffULL, 0x0000001097357824ULL, 0x000fe200078e0230ULL,
0x000000249a7e7810ULL, 0x040fe20007ffe0ffULL, 0x00000010332c7825ULL, 0x000fe200078e002cULL,
0x000000289a7c7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e357faeULL, 0x0003e2000c101c46ULL, 0x0000001091397824ULL, 0x000fe200078e0230ULL,
0x000000318e00720cULL, 0x080fe20003f06070ULL, 0x00000010332a7825ULL, 0x000fe200078e002aULL,
0x000000002c377faeULL, 0x0005e2000c901c46ULL, 0x000000318a00720cULL, 0x080fe40003f26070ULL,
0x000000108d3b7824ULL, 0x000fe200078e0230ULL, 0x000000002a397faeULL, 0x0007e2000d101c46ULL,
0x0000001033287825ULL, 0x000fe200078e0028ULL, 0x000000318800720cULL, 0x000fc40003f46070ULL,
0x0000002c9a787810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0x00005e0012067a11ULL, 0x000fe200078840ffULL, 0x00000000283b7faeULL, 0x0009e2000d901c46ULL,
0x000000318400720cULL, 0x080fe20003f66070ULL, 0x000000108b3d7824ULL, 0x000fe200078e0230ULL,
0x00005f0012077a11ULL, 0x000fe200020f4407ULL, 0x0000001033267825ULL, 0x000fe200078e0026ULL,
0x000000318200720cULL, 0x000fe40003f86070ULL, 0x000000309a767810ULL, 0x000fe20007ffe0ffULL,
0x00000010873f7824ULL, 0x000fe200078e0230ULL, 0x00000000263d7faeULL, 0x000be2000c101c46ULL,
0x0000001033247825ULL, 0x000fe200078e0024ULL, 0x0000000f7e7b7212ULL, 0x000fc400078e3cffULL,
0x000000349a727810ULL, 0x040fe20007ffe0ffULL, 0x00000010852f7824ULL, 0x002fe200078e0230ULL,
0x00000000243f7faeULL, 0x0003e2000c901c46ULL, 0x0000001033227825ULL, 0x000fe200078e0022ULL,
0x0000003c9a6c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000f7c797212ULL, 0x000fe200078e3cffULL,
0x00000010812d7824ULL, 0x004fe200078e0230ULL, 0x00000000222f7faeULL, 0x0005e2000d101c46ULL,
0x0000001033207825ULL, 0x000fe200078e0020ULL, 0x000000389a707810ULL, 0x000fc40007ffe0ffULL,
0x0000000f78757212ULL, 0x000fe200078e3cffULL, 0x000000107f2b7824ULL, 0x008fe200078e0230ULL,
0x00000000202d7faeULL, 0x0007e2000d901c46ULL, 0x00000010331e7825ULL, 0x040fe200078e001eULL,
0x000000317e00720cULL, 0x080fe40003f06070ULL, 0x000000317c00720cULL, 0x080fe20003f26070ULL,
0x000000087e127824ULL, 0x000fe200078e00ffULL, 0x000000001e2b7faeULL, 0x0003e2000e101c46ULL,
0x000000317800720cULL, 0x000fe20003f46070ULL, 0x00000010331a7825ULL, 0x000fe200078e001aULL,
0x0000000f76737212ULL, 0x000fc400078e3cffULL, 0xfffffff8127b7812ULL, 0x000fe200078ee27bULL,
0x0000000878207824ULL, 0x008fe200078e00ffULL, 0x000000317600720cULL, 0x040fe20003f66070ULL,
0x0000000876127824ULL, 0x000fe200078e00ffULL, 0x0000000f726f7212ULL, 0x080fe200078e3cffULL,
0x00000010331c7825ULL, 0x040fe200078e001cULL, 0xfffffff820757812ULL, 0x000fe400078ee275ULL,
0x0000000f6c6a7212ULL, 0x000fe200078e3cffULL, 0x000000087c1e7824ULL, 0x002fe200078e00ffULL,
0x000000317200720cULL, 0x000fe20003f86070ULL, 0x000000086c1f7824ULL, 0x000fe200078e00ffULL,
0x0000000f706d7212ULL, 0x040fe200078e3cffULL, 0x0000000870207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e797812ULL, 0x000fe200078ee279ULL, 0x00000008721e7824ULL, 0x000fe200078e00ffULL,
0x000000317000720cULL, 0x080fe20003fa6070ULL, 0x0000001033187825ULL, 0x000fe200078e0018ULL,
0x000000316c00720cULL, 0x000fc40003fc6070ULL, 0xfffffff812737812ULL, 0x000fe200078ee273ULL,
0x0000001079217824ULL, 0x100fe200078e0230ULL, 0xfffffff81e6f7812ULL, 0x000fe200078ee26fULL,
0x0000001075237824ULL, 0x004fe200078e0230ULL, 0xfffffff81f6a7812ULL, 0x000fe200078ee26aULL,
0x000000107b1f7824ULL, 0x000fe200078e0230ULL, 0xfffffff8206d7812ULL, 0x000fe200078ee26dULL,
0x0000001033087825ULL, 0x000fc600078e0008ULL, 0x000000001a1f7faeULL, 0x0003e2000c101c46ULL,
0x0000001073257824ULL, 0x000fe400078e0230ULL, 0x0000001033027825ULL, 0x000fe200078e0002ULL,
0x000000001c217faeULL, 0x0003e6000c901c46ULL, 0x000000106f277824ULL, 0x020fe200078e0230ULL,
0x0000000018237faeULL, 0x0003e2000d101c46ULL, 0x0000001033047825ULL, 0x000fc600078e0004ULL,
0x0000000008257faeULL, 0x0003e2000d901c46ULL, 0x000000106d297824ULL, 0x010fe400078e0230ULL,
0x0000001033067825ULL, 0x000fe200078e0006ULL, 0x0000000002277faeULL, 0x0003e6000e101c46ULL,
0x000000106a2b7824ULL, 0x000fe200078e0230ULL, 0x0000000004297faeULL, 0x0003e8000e901c46ULL,
0x00000000062b7faeULL, 0x0003e2000f101c46ULL, 0x00000c6000007947ULL, 0x000fea0003800000ULL,
0x00000003ff9a7819ULL, 0x002fe4000001160fULL, 0x0000300060307811ULL, 0x000fc400078e70ffULL,
0x000000049a967810ULL, 0x040fe20007ffe0ffULL, 0x0000004061987824ULL, 0x000fe200078e029aULL,
0x0000000c9a907810ULL, 0x000fe40007ffe0ffULL, 0x0000000f96937212ULL, 0x0c0fe200078e3cffULL,
0x0000000896007824ULL, 0x000fe200078e00ffULL, 0x000000089a947810ULL, 0x000fe40007ffe0ffULL,
0x0000000f908d7212ULL, 0x080fe400078e3cffULL, 0xfffffff800937812ULL, 0x000fe200078ee293ULL,
0x0000000890007824ULL, 0x000fe200078e00ffULL, 0x000000149a8a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000894027824ULL, 0x040fe200078e00ffULL, 0x0000000f94917212ULL, 0x000fc400078e3cffULL,
0xfffffff8008d7812ULL, 0x000fe200078ee28dULL, 0x000000088a007824ULL, 0x000fe200078e00ffULL,
0x000000109a8e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000f8a877212ULL, 0x080fe400078e3cffULL,
0x0000001c9a847810ULL, 0x000fe40007ffe0ffULL, 0xfffffff802917812ULL, 0x000fe200078ee291ULL,
0x000000088e027824ULL, 0x000fe200078e00ffULL, 0xfffffff800877812ULL, 0x000fe200078ee287ULL,
0x0000000884007824ULL, 0x000fe200078e00ffULL, 0x0000000f8e8b7212ULL, 0x000fc400078e3cffULL,
0x000000189a887810ULL, 0x000fe20007ffe0ffULL, 0x0000001087377824ULL, 0x100fe200078e0230ULL,
0x0000000f84817212ULL, 0x080fe400078e3cffULL, 0x000000249a7e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8028b7812ULL, 0x000fe200078ee28bULL, 0x0000000888027824ULL, 0x000fe200078e00ffULL,
0xfffffff800817812ULL, 0x000fe200078ee281ULL, 0x000000087e007824ULL, 0x000fe200078e00ffULL,
0x0000000f88857212ULL, 0x080fe200078e3cffULL, 0x000000108b357824ULL, 0x100fe200078e0230ULL,
0x000000209a827810ULL, 0x000fe20007ffe0ffULL, 0x00000010813b7824ULL, 0x000fe200078e0230ULL,
0x0000000f7e7b7212ULL, 0x000fc400078e3cffULL, 0x0000002c9a787810ULL, 0x000fe40007ffe0ffULL,
0xfffffff802857812ULL, 0x000fe200078ee285ULL, 0x0000000882027824ULL, 0x000fe200078e00ffULL,
0xfffffff8007b7812ULL, 0x000fe200078ee27bULL, 0x0000000878007824ULL, 0x000fe200078e00ffULL,
0x0000000f827f7212ULL, 0x080fe200078e3cffULL, 0x0000001085397824ULL, 0x100fe200078e0230ULL,
0x000000289a7c7810ULL, 0x000fe20007ffe0ffULL, 0x000000107b3f7824ULL, 0x000fe200078e0230ULL,
0x0000000f78757212ULL, 0x000fc400078e3cffULL, 0x000000349a727810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8027f7812ULL, 0x000fe200078ee27fULL, 0x000000087c027824ULL, 0x000fe200078e00ffULL,
0xfffffff800757812ULL, 0x000fe200078ee275ULL, 0x0000000872007824ULL, 0x000fe200078e00ffULL,
0x0000000f7c797212ULL, 0x080fe200078e3cffULL, 0x000000107f3d7824ULL, 0x000fe200078e0230ULL,
0x000000309a767810ULL, 0x000fe40007ffe0ffULL, 0x0000000f726f7212ULL, 0x000fc400078e3cffULL,
0xfffffff802797812ULL, 0x000fe200078ee279ULL, 0x0000000876027824ULL, 0x000fe200078e00ffULL,
0xfffffff8006f7812ULL, 0x000fe400078ee26fULL, 0x0000000f76737212ULL, 0x080fe200078e3cffULL,
0x0000001079417824ULL, 0x000fe200078e0230ULL, 0x000000389a707810ULL, 0x000fe40007ffe0ffULL,
0x0000001298007210ULL, 0x000fe40007f1e0ffULL, 0xfffffff802737812ULL, 0x000fe200078ee273ULL,
0x0000000870027824ULL, 0x000fe200078e00ffULL, 0x0000003c9a6c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000f706d7212ULL, 0x000fc400078e3cffULL,
0x00005e00002e7a11ULL, 0x000fe200078040ffULL, 0x000000086c057824ULL, 0x000fe200078e00ffULL,
0x0000000498957810ULL, 0x040fe40007ffe0ffULL, 0x0000000898927810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8026d7812ULL, 0x000fe400078ee26dULL, 0x00005f00002f7a11ULL, 0x000fe400000f4403ULL,
0x0000000f6c6a7212ULL, 0x000fc400078e3cffULL, 0x0000001295027210ULL, 0x080fe40007f3e0ffULL,
0x0000001292007210ULL, 0x000fe40007f5e0ffULL, 0xfffffff8056a7812ULL, 0x000fe200078ee26aULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x00005e0000207a11ULL, 0x000fe200078240ffULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x00000010988c7810ULL, 0x000fe40007ffe0ffULL,
0x00005e00021e7a11ULL, 0x000fc400078040ffULL, 0x00005f0000217a11ULL, 0x000fe400008f4405ULL,
0x0000000c988f7810ULL, 0x000fe40007ffe0ffULL, 0x000000128c007210ULL, 0x080fe40007f3e0ffULL,
0x00005f00021f7a11ULL, 0x000fe400000f4403ULL, 0x000000128f027210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005e0000267a11ULL, 0x000fc400078240ffULL,
0x0000001898867810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e0002227a11ULL, 0x000fe400078040ffULL, 0x00005f0000277a11ULL, 0x000fe400008f4405ULL,
0x0000001498897810ULL, 0x000fe40007ffe0ffULL, 0x0000001286007210ULL, 0x000fe40007f3e0ffULL,
0x00005f0002237a11ULL, 0x000fc400000f4403ULL, 0x0000001289027210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x0000001c98837810ULL, 0x000fe40007ffe0ffULL,
0x00005e00002a7a11ULL, 0x000fe200078240ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0000002098807810ULL, 0x000fe40007ffe0ffULL, 0x00005e00022c7a11ULL, 0x000fe400078040ffULL,
0x0000001283047210ULL, 0x000fc40007f5e0ffULL, 0x00005f00002b7a11ULL, 0x000fe400008f4405ULL,
0x0000001280007210ULL, 0x000fe40007f3e0ffULL, 0x00005f00022d7a11ULL, 0x000fe200000f4403ULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x00005e0004287a11ULL, 0x000fe200078040ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00000024987d7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0000247a11ULL, 0x000fc400078240ffULL, 0x00000028987a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0004297a11ULL, 0x000fe400000f4403ULL, 0x000000127d037210ULL, 0x080fe40007f1e0ffULL,
0x00005f0000257a11ULL, 0x000fe400008f4405ULL, 0x0000002c98777810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x000000127a057210ULL, 0x000fc40007f3e0ffULL,
0x0000001277077210ULL, 0x000fe40007f5e0ffULL, 0x00005e0003027a11ULL, 0x000fe200078040ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078240ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005f0003037a11ULL, 0x000fe400000f4400ULL,
0x00005e0007067a11ULL, 0x000fe400078040ffULL, 0x00005f0005057a11ULL, 0x000fc400008f4408ULL,
0x0000000f9a087212ULL, 0x000fe400078e3cffULL, 0x0000003098747810ULL, 0x040fe40007ffe0ffULL,
0x0000003498717810ULL, 0x040fe40007ffe0ffULL, 0x00000038986e7810ULL, 0x040fe40007ffe0ffULL,
0x0000003c986b7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0007077a11ULL, 0x000fc400000f4418ULL,
0x000000070f007812ULL, 0x000fe400078ec0ffULL, 0x0000000708087812ULL, 0x000fe400078ec0ffULL,
0x0000001274097210ULL, 0x080fe40007f1e0ffULL, 0x0000001271197210ULL, 0x080fe40007f3e0ffULL,
0x000000126e1b7210ULL, 0x080fe40007f5e0ffULL, 0x000000126b1d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x0000000800317812ULL, 0x000fe200078efcffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x0ffffff808977812ULL, 0x000fe200078ef80fULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e0009087a11ULL, 0x000fe200078040ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x00005e0019187a11ULL, 0x000fe200078240ffULL,
0x0000001097337824ULL, 0x000fe200078e0230ULL, 0x00005e001b1a7a11ULL, 0x000fe200078440ffULL,
0x00000010312e7825ULL, 0x000fe200078e002eULL, 0x00005e001d1c7a11ULL, 0x000fc400078640ffULL,
0x00005f0009097a11ULL, 0x000fe200000f4412ULL, 0x00000010311e7825ULL, 0x000fe200078e001eULL,
0x00005f0019197a11ULL, 0x000fe200008f4432ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e2000b901c46ULL, 0x00005f001b1b7a11ULL, 0x000fe200010f4434ULL,
0x0000001031207825ULL, 0x000fe200078e0020ULL, 0x00005f001d1d7a11ULL, 0x000fc600018f4436ULL,
0x0000001031227825ULL, 0x000fc800078e0022ULL, 0x0000001031267825ULL, 0x000fc800078e0026ULL,
0x00000010312c7825ULL, 0x000fc800078e002cULL, 0x00000010312a7825ULL, 0x000fc800078e002aULL,
0x0000001031287825ULL, 0x000fc800078e0028ULL, 0x0000001031247825ULL, 0x000fc800078e0024ULL,
0x0000001031027825ULL, 0x000fc800078e0002ULL, 0x0000001031047825ULL, 0x000fc800078e0004ULL,
0x0000001031067825ULL, 0x000fc800078e0006ULL, 0x0000001031087825ULL, 0x000fc800078e0008ULL,
0x0000001031187825ULL, 0x000fc800078e0018ULL, 0x00000010311a7825ULL, 0x000fc800078e001aULL,
0x00000010311c7825ULL, 0x000fc800078e001cULL, 0x00000010932f7824ULL, 0x102fe400078e0230ULL,
0x0000001091317824ULL, 0x100fe400078e0230ULL, 0x000000108d337824ULL, 0x100fe200078e0230ULL,
0x000000001e2f7faeULL, 0x0003e8000b901c46ULL, 0x0000000020317faeULL, 0x0005e8000b901c46ULL,
0x0000000022337faeULL, 0x0007e8000b901c46ULL, 0x0000000026357faeULL, 0x0009e2000b901c46ULL,
0x00000010751f7824ULL, 0x002fc600078e0230ULL, 0x000000002c377faeULL, 0x0003e2000b901c46ULL,
0x0000001073217824ULL, 0x004fc600078e0230ULL, 0x000000002a397faeULL, 0x0005e2000b901c46ULL,
0x000000106f237824ULL, 0x008fc600078e0230ULL, 0x00000000283b7faeULL, 0x0005e2000b901c46ULL,
0x000000106d277824ULL, 0x010fc600078e0230ULL, 0x00000000243d7faeULL, 0x0005e2000b901c46ULL,
0x000000106a2d7824ULL, 0x002fc600078e0230ULL, 0x00000000023f7faeULL, 0x0005e8000b901c46ULL,
0x0000000004417faeULL, 0x0005e8000b901c46ULL, 0x00000000061f7faeULL, 0x0005e8000b901c46ULL,
0x0000000008217faeULL, 0x0005e8000b901c46ULL, 0x0000000018237faeULL, 0x0005e8000b901c46ULL,
0x000000001a277faeULL, 0x0005e8000b901c46ULL, 0x000000001c2d7faeULL, 0x0005e4000b901c46ULL,
0x00000004ff037424ULL, 0x006fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff127424ULL, 0x000fc400078e00ffULL, 0x0000030003137a24ULL, 0x000fca00078e0213ULL,
0x000000161300720cULL, 0x000fda0003f06070ULL, 0x000000020e028824ULL, 0x000fe200078e0213ULL,
0x00000004ff097819ULL, 0x100fe4000001160fULL, 0x0000000800087812ULL, 0x000fe200078ef80fULL,
0x0000600002028625ULL, 0x000fe200078e0003ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000602128981ULL, 0x000362000c1e1900ULL, 0x0000000709057812ULL, 0x000fe200078e7808ULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x0000001008057824ULL, 0x000fc800078e0205ULL,
0x0000001005057824ULL, 0x000fc800078e00ffULL, 0x0000000809037824ULL, 0x002fe200078e00ffULL,
0x000000000534783bULL, 0x000fe20000000200ULL, 0x0000400060997824ULL, 0x000fe200078e00ffULL,
0x000000019a407812ULL, 0x000fe400078ec0ffULL, 0xfffffff803007812ULL, 0x000fe400078ee200ULL,
0x00001000999c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000700477812ULL, 0x040fe200078ec0ffULL,
0x0000000800027824ULL, 0x000fe200078e00ffULL, 0x0000000209037810ULL, 0x000fc40007ffe0ffULL,
0x00000001479b7812ULL, 0x000fe400078e789aULL, 0x0000000703037812ULL, 0x000fe400078e7808ULL,
0x000000029b9b7212ULL, 0x000fe400078efcffULL, 0x0000001000637810ULL, 0x000fe20007ffe0ffULL,
0x0000001008037824ULL, 0x000fe200078e0203ULL, 0x0000002000627810ULL, 0x040fe20007ffe0ffULL,
0x000000109b1c7824ULL, 0x000fe200078e029cULL, 0x0000003000007810ULL, 0x000fe20007ffe0ffULL,
0x0000001003307824ULL, 0x000fe200078e00ffULL, 0x0000000763457812ULL, 0x040fe200078ec0ffULL,
0x0000000863637824ULL, 0x000fe200078e00ffULL, 0x0000000762437812ULL, 0x000fe200078ec0ffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x0000000700417812ULL, 0x000fe200078ec0ffULL,
0x0000000862627824ULL, 0x000fe200078e00ffULL, 0x0000000247077812ULL, 0x000fe200078e1e40ULL,
0x0000000800007824ULL, 0x000fe200078e00ffULL, 0x0000000145047812ULL, 0x100fe200078e789aULL,
0x000000003030783bULL, 0x000fe20000000200ULL, 0x0000000143037812ULL, 0x000fc400078e789aULL,
0x0000000141677812ULL, 0x000fe400078e789aULL, 0x0000000207667212ULL, 0x000fe400078efcffULL,
0x0000006304697212ULL, 0x000fe400078efcffULL, 0x0000006203687212ULL, 0x000fe200078efcffULL,
0x0000001066587824ULL, 0x100fe200078e029cULL, 0x0000000067677212ULL, 0x000fe200078efcffULL,
0x00000010693c7824ULL, 0x000fe200078e029cULL, 0x0000000243037812ULL, 0x000fe200078e1e40ULL,
0x0000001068187824ULL, 0x000fe200078e029cULL, 0x0000000245207812ULL, 0x000fe200078e1e40ULL,
0x0000001067047824ULL, 0x000fe200078e029cULL, 0x000000005858783bULL, 0x000ea20000000200ULL,
0x0000006203647212ULL, 0x000fc400078efcffULL, 0x0000006320657212ULL, 0x000fe200078efcffULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x0000000241037812ULL, 0x000fe200078e1e40ULL,
0x0000001064287824ULL, 0x100fe400078e029cULL, 0x000000001818783bULL, 0x000f220000000200ULL,
0x0000001065207824ULL, 0x000fc600078e029cULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000001c345c723cULL, 0x042fe600000418ffULL,
0x000000002020783bULL, 0x000e6a0000000200ULL, 0x0000001e341c723cULL, 0x000fde00000418ffULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000058305c723cULL, 0x044ff0000004185cULL,
0x0000005a3058723cULL, 0x000ff0000004181cULL, 0x0000003c341c723cULL, 0x048ff000000418ffULL,
0x000000183424723cULL, 0x050ff000000418ffULL, 0x0000003e343c723cULL, 0x040ff000000418ffULL,
0x0000001a3418723cULL, 0x040ff000000418ffULL, 0x00000004342c723cULL, 0x040fee00000418ffULL,
0x0000000447057812ULL, 0x100fe200078e1e40ULL, 0x000000063434723cULL, 0x000fe200000418ffULL,
0x0000000445047812ULL, 0x000fc400078e1e40ULL, 0x0000000647477812ULL, 0x000fc800078e1e40ULL,
0x0000000003077212ULL, 0x000fe200078efcffULL, 0x000000283024723cULL, 0x040fe20000041824ULL,
0x0000000409037810ULL, 0x000fe40007ffe0ffULL, 0x0000000205067212ULL, 0x080fe200078efcffULL,
0x0000001007387824ULL, 0x000fe200078e029cULL, 0x0000000703037812ULL, 0x000fe400078e7808ULL,
0x0000006304057212ULL, 0x000fe200078efcffULL, 0x0000002a3028723cULL, 0x000fe20000041818ULL,
0x0000000247027212ULL, 0x000fe200078efcffULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000001008037824ULL, 0x000fc400078e0203ULL, 0x0000001005547824ULL, 0x000fe400078e029cULL,
0x0000001003487824ULL, 0x000fe200078e00ffULL, 0x0000000443037812ULL, 0x000fe200078e1e40ULL,
0x0000001006187824ULL, 0x000fe200078e029cULL, 0x0000000441197812ULL, 0x100fe200078e1e40ULL,
0x000000005454783bULL, 0x000fe20000000200ULL, 0x0000006203047212ULL, 0x000fe200078efcffULL,
0x00000020301c723cULL, 0x042fe2000004181cULL, 0x0000000019037212ULL, 0x000fe200078efcffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000000643437812ULL, 0x000fe200078e1e40ULL,
0x0000001004507824ULL, 0x000fe200078e029cULL, 0x0000000641417812ULL, 0x000fe200078e1e40ULL,
0x00000010034c7824ULL, 0x100fe200078e029cULL, 0x000000001818783bULL, 0x000ee20000000200ULL,
0x000000223020723cULL, 0x000fe2000004183cULL, 0x0000006243627212ULL, 0x000fe200078efcffULL,
0x0000001002447824ULL, 0x000fe200078e029cULL, 0x000000005050783bULL, 0x000f220000000200ULL,
0x0000000041007212ULL, 0x000fc600078efcffULL, 0x000000004c4c783bULL, 0x000f220000000200ULL,
0x00000006093d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010623c7824ULL, 0x000fc600078e029cULL,
0x000000073d3d7812ULL, 0x000fca00078e7808ULL, 0x00000010083d7824ULL, 0x000fe200078e023dULL,
0x00000038302c723cULL, 0x044fe6000004182cULL, 0x000000103d9d7824ULL, 0x000fe400078e00ffULL,
0x000000003c3c783bULL, 0x000fe40000000200ULL, 0x0000000645387812ULL, 0x000fe200078e1e40ULL,
0x0000003a3030723cULL, 0x000fe20000041834ULL, 0x000000009d34783bULL, 0x000fe40000000200ULL,
0x0000006338637212ULL, 0x000fe200078efcffULL, 0x0000001000387824ULL, 0x100fe200078e029cULL,
0x000000004444783bULL, 0x000ea60000000200ULL, 0x0000001063407824ULL, 0x000fe200078e029cULL,
0x00000054481c723cULL, 0x042fe2000004181cULL, 0x000000003838783bULL, 0x000fe80000000200ULL,
0x000000004040783bULL, 0x000e660000000200ULL, 0x00000018485c723cULL, 0x048ff0000004185cULL,
0x0000001a4858723cULL, 0x040ff00000041858ULL, 0x000000564820723cULL, 0x040ff00000041820ULL,
0x000000504824723cULL, 0x050ff00000041824ULL, 0x000000524828723cULL, 0x040ff00000041828ULL,
0x0000004c482c723cULL, 0x040fee000004182cULL, 0x00000300154d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000004e4830723cULL, 0x000fe60000041830ULL, 0x000000014d197810ULL, 0x000fc80007ffe0ffULL,
0x000000141900720cULL, 0x000fe20003f06070ULL, 0x00000044345c723cULL, 0x044ff0000004185cULL,
0x000000463458723cULL, 0x040ff00000041858ULL, 0x00000040341c723cULL, 0x042ff0000004181cULL,
0x000000423420723cULL, 0x040ff00000041820ULL, 0x0000003c3424723cULL, 0x040ff00000041824ULL,
0x0000003e3428723cULL, 0x040ff00000041828ULL, 0x00000038342c723cULL, 0x040fee000004182cULL,
0x0000001112397224ULL, 0x020fe200078e02ffULL, 0x0000003a3434723cULL, 0x000fe20000041830ULL,
0x0000099000008947ULL, 0x000fee0003800000ULL, 0x0000003998197210ULL, 0x080fe20007f1e0ffULL,
0x000001004d187824ULL, 0x000fe200078e0210ULL, 0x00000039951b7210ULL, 0x080fe20007f3e0ffULL,
0x000000100f3a7824ULL, 0x000fe200078e00ffULL, 0x000000398f337210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00000018173b7217ULL, 0x000fe20007800000ULL,
0x0000001097977824ULL, 0x100fe200078e029cULL, 0x00005e00193d7a11ULL, 0x000fe200078040ffULL,
0x0000001093937824ULL, 0x000fe200078e029cULL, 0x000000398c387210ULL, 0x080fe20007f9e0ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0a18ULL, 0x00005f0019197a11ULL, 0x000fe200000f441aULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0000003992327210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x00005e001b577a11ULL, 0x040fe200078040ffULL,
0x000000ffff3f7224ULL, 0x000fe200020e06ffULL, 0x00005e0038517a11ULL, 0x040fe200078640ffULL,
0x000000ffff417224ULL, 0x000fe200010e06ffULL, 0x00005f001b1b7a11ULL, 0x000fe200000f441aULL,
0x0000001091917824ULL, 0x100fe200078e029cULL, 0x00005f0038387a11ULL, 0x000fe200018f443fULL,
0x000000108d8d7824ULL, 0x100fe200078e029cULL, 0x00005e0032317a11ULL, 0x000fe200078240ffULL,
0x000000108b8b7824ULL, 0x100fe200078e029cULL, 0x0000003989447210ULL, 0x080fe20007f1e0ffULL,
0x0000001087877824ULL, 0x100fe200078e029cULL, 0x00000039803e7210ULL, 0x080fe20007f7e0ffULL,
0x0000001085857824ULL, 0x100fe200078e029cULL, 0x00005f0032327a11ULL, 0x000fe200008f4441ULL,
0x000000ffff457224ULL, 0x000fe200000e06ffULL, 0x0000003986427210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e06ffULL, 0x00005e0033537a11ULL, 0x000fe200078440ffULL,
0x0000001081817824ULL, 0x100fe200078e029cULL, 0x00005e00444f7a11ULL, 0x000fe200078040ffULL,
0x000000ffff437224ULL, 0x000fe200008e06ffULL, 0x00005e003e477a11ULL, 0x000fe200078640ffULL,
0x000000107f7f7824ULL, 0x000fe200078e029cULL, 0x00005f0033337a11ULL, 0x000fe200010f4418ULL,
0x000000107b7b7824ULL, 0x100fe200078e029cULL, 0x00005f0044447a11ULL, 0x000fe200000f4445ULL,
0x0000001079797824ULL, 0x100fe200078e029cULL, 0x00005f003e3e7a11ULL, 0x000fe200018f443fULL,
0x0000001075757824ULL, 0x100fe200078e029cULL, 0x0000003983407210ULL, 0x080fe20007f5e0ffULL,
0x0000001073737824ULL, 0x100fe200078e029cULL, 0x00005e00424b7a11ULL, 0x040fe200078240ffULL,
0x000000106f6f7824ULL, 0x100fe200078e029cULL, 0x000000397d3f7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff417224ULL, 0x000fe200010e06ffULL, 0x00005f0042427a11ULL, 0x000fe200008f4443ULL,
0x000000106d6d7824ULL, 0x000fe200078e029cULL, 0x000000397a3c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000003977777210ULL, 0x000fc40007f9e0ffULL,
0x00005e0040497a11ULL, 0x000fe200078440ffULL, 0x000000ffff557224ULL, 0x000fe200008e06ffULL,
0x00005e003f457a11ULL, 0x040fe200078040ffULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x000000703a3a7812ULL, 0x000fe400078ec0ffULL, 0x00005f0040407a11ULL, 0x000fe400010f4441ULL,
0x00005f003f3f7a11ULL, 0x000fe400000f4418ULL, 0x00005e0077417a11ULL, 0x000fc400078840ffULL,
0x0000003d3a187210ULL, 0x000fe40007f3e0ffULL, 0x00005e003c437a11ULL, 0x000fe400078640ffULL,
0x0000003b9a00720cULL, 0x000fe20003f46070ULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x000000313a307210ULL, 0x000fe40007fbe0ffULL, 0x00005f00773d7a11ULL, 0x000fe400020f441aULL,
0x0000003b9600720cULL, 0x080fe20003f06070ULL, 0x000000ffff317224ULL, 0x000fe200028e0632ULL,
0x0000003b9400720cULL, 0x000fc40003f86070ULL, 0x00005f003c3c7a11ULL, 0x000fe400018f4455ULL,
0x0000003b9000720cULL, 0x000fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018977faeULL, 0x0003e2000d101c46ULL, 0x000000573a1a7210ULL, 0x040fe40007f7e0ffULL,
0x000000533a327210ULL, 0x000fe40007fbe0ffULL, 0x0000003b8e00720cULL, 0x080fe20003f46070ULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x0000003b8a00720cULL, 0x000fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x0000003974467210ULL, 0x000fc40007fbe0ffULL,
0x000000001a937faeULL, 0x0005e2000c101c46ULL, 0x000000396e6e7210ULL, 0x080fe40007f1e0ffULL,
0x000000ffff537224ULL, 0x000fe200028e06ffULL, 0x0000000030917faeULL, 0x0007e2000e101c46ULL,
0x0000003971717210ULL, 0x000fc60007f9e0ffULL, 0x00000000328d7faeULL, 0x0009e2000c901c46ULL,
0x000000513a187210ULL, 0x002fe40007f3e0ffULL, 0x00005e0046517a11ULL, 0x000fc600078a40ffULL,
0x000000ffff197224ULL, 0x000fe200008e0638ULL, 0x0000004f3a387210ULL, 0x000fe40007fde0ffULL,
0x000000396b6b7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0046467a11ULL, 0x000fe200028f4453ULL,
0x000000ffff397224ULL, 0x000fe200030e0644ULL, 0x0000004b3a1a7210ULL, 0x004fe20007fde0ffULL,
0x00000000188b7faeULL, 0x0003e2000d101c46ULL, 0x0000003b8800720cULL, 0x080fe40003fa6070ULL,
0x0000003b8400720cULL, 0x000fe20003f46070ULL, 0x000000ffff1b7224ULL, 0x000fe200030e0642ULL,
0x0000000038877faeULL, 0x0005e2000d901c46ULL, 0x000000ffff427224ULL, 0x000fe200020e06ffULL,
0x000000473a307210ULL, 0x008fe20007f9e0ffULL, 0x000000106a477824ULL, 0x000fe200078e029cULL,
0x0000003b8200720cULL, 0x000fc40003f66070ULL, 0x000000493a187210ULL, 0x002fe20007fde0ffULL,
0x000000ffff317224ULL, 0x000fe200020e063eULL, 0x0000003b7e00720cULL, 0x080fe20003f86070ULL,
0x000000001a857faeULL, 0x0003e2000e901c46ULL, 0x0000003b7c00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff197224ULL, 0x000fe200030e0640ULL, 0x00005e0071497a11ULL, 0x000fe200078c40ffULL,
0x000000ffff397224ULL, 0x004fc600000e06ffULL, 0x0000000018817faeULL, 0x0005e2000d101c46ULL,
0x000000453a327210ULL, 0x010fe40007f5e0ffULL, 0x00005f0071427a11ULL, 0x000fe200030f4442ULL,
0x00000000307f7faeULL, 0x0007e2000d901c46ULL, 0x00005e006e457a11ULL, 0x000fe200078040ffULL,
0x000000ffff337224ULL, 0x000fe200010e063fULL, 0x000000433a387210ULL, 0x000fe40007fde0ffULL,
0x0000003b7800720cULL, 0x000fe40003f46070ULL, 0x00005f006e407a11ULL, 0x000fe200000f4439ULL,
0x000000ffff397224ULL, 0x000fe200030e063cULL, 0x000000413a3e7210ULL, 0x000fe20007f7e0ffULL,
0x00000000327b7faeULL, 0x0009e2000e101c46ULL, 0x0000003b7600720cULL, 0x000fe20003f06070ULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x00005e006b317a11ULL, 0x008fe200078240ffULL,
0x0000000038797faeULL, 0x0007e2000e901c46ULL, 0x000000513a187210ULL, 0x004fe20007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200018e063dULL, 0x0000003b7200720cULL, 0x000fc40003f66070ULL,
0x0000003b7000720cULL, 0x080fe20003f86070ULL, 0x000000ffff197224ULL, 0x000fe200028e0646ULL,
0x000000003e757faeULL, 0x0007e2000d101c46ULL, 0x0000003b6c00720cULL, 0x000fe40003fa6070ULL,
0x000000493a1a7210ULL, 0x042fe20007f5e0ffULL, 0x0000000018737faeULL, 0x0007e2000c101c46ULL,
0x000000453a307210ULL, 0x040fe40007fde0ffULL, 0x00005f006b327a11ULL, 0x010fe200008f443cULL,
0x000000ffff1b7224ULL, 0x000fe200010e0642ULL, 0x000000313a3a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff317224ULL, 0x000fc600030e0640ULL, 0x000000001a6f7faeULL, 0x0007e2000d901c46ULL,
0x000000ffff3b7224ULL, 0x000fc600008e0632ULL, 0x00000000306d7faeULL, 0x0007e8000e101c46ULL,
0x000000003a477faeULL, 0x0007e2000e901c46ULL, 0x0000085000007947ULL, 0x000fea0003800000ULL,
0x000000398f337210ULL, 0x080fe20007f7e0ffULL, 0x0000001097977824ULL, 0x100fe200078e029cULL,
0x000000398c3b7210ULL, 0x080fe20007f9e0ffULL, 0x0000001093937824ULL, 0x000fe200078e029cULL,
0x0000003998197210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200018e06ffULL,
0x00000039951b7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff407224ULL, 0x000fe200020e06ffULL,
0x0000003992317210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x00005e003b387a11ULL, 0x000fe200078640ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078040ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe200018f4440ULL, 0x0000001091917824ULL, 0x000fe200078e029cULL,
0x00005f0019197a11ULL, 0x000fe200000f441aULL, 0x000000108d8d7824ULL, 0x100fe200078e029cULL,
0x00005e0031307a11ULL, 0x000fe200078240ffULL, 0x000000108b8b7824ULL, 0x100fe200078e029cULL,
0x00005e0033327a11ULL, 0x000fe200078440ffULL, 0x0000001087877824ULL, 0x100fe200078e029cULL,
0x0000003980417210ULL, 0x080fe20007f7e0ffULL, 0x0000001085857824ULL, 0x100fe200078e029cULL,
0x00005e001b1a7a11ULL, 0x000fe200078040ffULL, 0x0000001081817824ULL, 0x000fe200078e029cULL,
0x00005f0031317a11ULL, 0x000fe200008f443cULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00005f0033337a11ULL, 0x000fe200010f443eULL, 0x000000107f7f7824ULL, 0x000fe200078e029cULL,
0x00005f001b1b7a11ULL, 0x000fe200000f443aULL, 0x000000107b7b7824ULL, 0x100fe200078e029cULL,
0x00000039863d7210ULL, 0x080fe20007f3e0ffULL, 0x0000001079797824ULL, 0x100fe200078e029cULL,
0x00000039833f7210ULL, 0x080fe20007f5e0ffULL, 0x0000001075757824ULL, 0x000fe200078e029cULL,
0x0000003989437210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0x00005e0041407a11ULL, 0x000fe200078640ffULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff427224ULL, 0x000fe200000e06ffULL,
0x00005f0041417a11ULL, 0x000fe200018f4448ULL, 0x0000001073737824ULL, 0x100fe200078e029cULL,
0x00005e003f3e7a11ULL, 0x000fe200078440ffULL, 0x000000106f6f7824ULL, 0x100fe200078e029cULL,
0x000000397d457210ULL, 0x000fe20007f7e0ffULL, 0x000000106d6d7824ULL, 0x100fe200078e029cULL,
0x00005e00433a7a11ULL, 0x000fe200078040ffULL, 0x000000106a537824ULL, 0x000fe200078e029cULL,
0x00005f003d3d7a11ULL, 0x000fe200008f4444ULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005f003f3f7a11ULL, 0x000fc400010f4446ULL, 0x00005f0043437a11ULL, 0x000fe400000f4442ULL,
0x000000397a7a7210ULL, 0x080fe40007f5e0ffULL, 0x00005e0045427a11ULL, 0x000fe400078c40ffULL,
0x0000003977777210ULL, 0x080fe40007f1e0ffULL, 0x0000003974747210ULL, 0x080fe40007f3e0ffULL,
0x0000003971717210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff467224ULL, 0x000fe200000e06ffULL,
0x000000396e6e7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff477224ULL, 0x000fe200008e06ffULL,
0x000000396b6b7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x00005f0045457a11ULL, 0x000fc400030f4444ULL, 0x00005e007a447a11ULL, 0x000fe200078440ffULL,
0x000000ffff507224ULL, 0x000fe200028e06ffULL, 0x00005e00744a7a11ULL, 0x000fe400078240ffULL,
0x00005f007a7a7a11ULL, 0x000fe200010f4439ULL, 0x000000100f397824ULL, 0x000fe200078e00ffULL,
0x00005e0077487a11ULL, 0x000fe400078040ffULL, 0x00005f0074747a11ULL, 0x000fe200008f4447ULL,
0x000000ffff477224ULL, 0x000fe200020e06ffULL, 0x00005e006b527a11ULL, 0x000fc400078440ffULL,
0x00005f0077777a11ULL, 0x000fe200000f4446ULL, 0x000000ffff467224ULL, 0x000fe200018e06ffULL,
0x0000007039517812ULL, 0x000fe400078ec0ffULL, 0x00005e006e4e7a11ULL, 0x000fe400078240ffULL,
0x00005e00714c7a11ULL, 0x000fe400078040ffULL, 0x00005f006b6b7a11ULL, 0x000fe400010f4450ULL,
0x0000001851187210ULL, 0x000fc40007f5e0ffULL, 0x00005f006e6e7a11ULL, 0x000fe400008f4447ULL,
0x0000001a511a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x00005f0071717a11ULL, 0x000fe400000f4446ULL, 0x0000003051307210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200030e061bULL, 0x0000003251327210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018977faeULL, 0x0003e2000b901c46ULL,
0x0000003851387210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200008e0631ULL,
0x0000003a513a7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000003c513c7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe200028e063bULL,
0x0000003e513e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200020e0643ULL,
0x0000004051407210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e063dULL,
0x0000004251427210ULL, 0x040fe20007f1e0ffULL, 0x000000001a937faeULL, 0x0003e2000b901c46ULL,
0x0000004451447210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e063fULL,
0x0000004851467210ULL, 0x040fe20007f9e0ffULL, 0x0000000030917faeULL, 0x0003e2000b901c46ULL,
0x0000004a51487210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff417224ULL, 0x000fe200008e0641ULL,
0x0000004c514a7210ULL, 0x040fe20007f5e0ffULL, 0x00000000328d7faeULL, 0x0003e2000b901c46ULL,
0x0000004e514e7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff437224ULL, 0x000fe200000e0645ULL,
0x0000005251507210ULL, 0x000fe20007f1e0ffULL, 0x00000000388b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff457224ULL, 0x000fc400028e067aULL, 0x000000ffff477224ULL, 0x000fe200020e0677ULL,
0x000000003a877faeULL, 0x0003e2000b901c46ULL, 0x000000ffff497224ULL, 0x000fe400018e0674ULL,
0x000000ffff4b7224ULL, 0x000fe200010e0671ULL, 0x000000003c857faeULL, 0x0003e2000b901c46ULL,
0x000000ffff4f7224ULL, 0x000fe400008e066eULL, 0x000000ffff517224ULL, 0x000fe200000e066bULL,
0x000000003e817faeULL, 0x0003e8000b901c46ULL, 0x00000000407f7faeULL, 0x0003e8000b901c46ULL,
0x00000000427b7faeULL, 0x0003e8000b901c46ULL, 0x0000000044797faeULL, 0x0003e8000b901c46ULL,
0x0000000046757faeULL, 0x0003e8000b901c46ULL, 0x0000000048737faeULL, 0x0003e8000b901c46ULL,
0x000000004a6f7faeULL, 0x0003e8000b901c46ULL, 0x000000004e6d7faeULL, 0x0003e8000b901c46ULL,
0x0000000050537faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000809197810ULL, 0x00afc40007ffe0ffULL, 0x0000300099997810ULL, 0x000fe40007ffe0ffULL,
0x0000000719197812ULL, 0x100fe400078e7808ULL, 0x0000000a09317810ULL, 0x000fe20007ffe0ffULL,
0x000000109b187824ULL, 0x000fe400078e0299ULL, 0x0000001008197824ULL, 0x000fe200078e0219ULL,
0x0000000731317812ULL, 0x000fe200078e7808ULL, 0x0000001069387824ULL, 0x000fe400078e0299ULL,
0x0000001019447824ULL, 0x000fc400078e00ffULL, 0x0000001068307824ULL, 0x000fe400078e0299ULL,
0x0000001008317824ULL, 0x000fe400078e0231ULL, 0x0000001067487824ULL, 0x000fe400078e0299ULL,
0x00000010313c7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001818783bULL, 0x000fe20000000200ULL, 0x0000001066407824ULL, 0x100fe400078e0299ULL,
0x0000001006067824ULL, 0x100fe200078e0299ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000001063547824ULL, 0x100fe400078e0299ULL, 0x0000001002507824ULL, 0x100fe200078e0299ULL,
0x000000003838783bULL, 0x000ea80000000200ULL, 0x000000003030783bULL, 0x000ee80000000200ULL,
0x000000003c3c783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000f280000000200ULL,
0x000000004040783bULL, 0x000fe80000000200ULL, 0x000000005454783bULL, 0x000fe80000000200ULL,
0x000000005050783bULL, 0x000fe20000000200ULL, 0x00000018445c723cULL, 0x042fee000004185cULL,
0x0000001065187824ULL, 0x100fe200078e0299ULL, 0x00000038441c723cULL, 0x044fee000004181cULL,
0x0000001064387824ULL, 0x100fe200078e0299ULL, 0x0000001a4458723cULL, 0x040fe20000041858ULL,
0x000000001818783bULL, 0x000e6e0000000200ULL, 0x0000003a4420723cULL, 0x040fe20000041820ULL,
0x000000003838783bULL, 0x000eae0000000200ULL, 0x000000304424723cULL, 0x048fee0000041824ULL,
0x0000001007307824ULL, 0x000fe200078e0299ULL, 0x000000324428723cULL, 0x000fe20000041828ULL,
0x0000000c09077810ULL, 0x000fc40007ffe0ffULL, 0x0000000e09097810ULL, 0x000fe40007ffe0ffULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x0000000707077812ULL, 0x100fe400078e7808ULL,
0x00000048442c723cULL, 0x010fe2000004182cULL, 0x0000000709097812ULL, 0x000fe400078e7808ULL,
0x0000001008077824ULL, 0x000fc600078e0207ULL, 0x0000001008097824ULL, 0x000fe400078e0209ULL,
0x0000004a4434723cULL, 0x000fe20000041834ULL, 0x0000001000487824ULL, 0x000fe400078e0299ULL,
0x0000001009097824ULL, 0x000fc800078e00ffULL, 0x0000001004447824ULL, 0x100fe200078e0299ULL,
0x000000183c1c723cULL, 0x042fe2000004181cULL, 0x000000004848783bULL, 0x000fe80000000200ULL,
0x000000004444783bULL, 0x000fe40000000200ULL, 0x0000001007187824ULL, 0x000fe200078e00ffULL,
0x000000403c5c723cULL, 0x040fee000004185cULL, 0x0000001005407824ULL, 0x100fe200078e0299ULL,
0x000000383c24723cULL, 0x044fe20000041824ULL, 0x000000000604783bULL, 0x000fec0000000200ULL,
0x0000001003387824ULL, 0x100fe200078e0299ULL, 0x0000001a3c20723cULL, 0x040fe20000041820ULL,
0x000000001818783bULL, 0x000e6e0000000200ULL, 0x000000423c58723cULL, 0x040fe20000041858ULL,
0x000000004040783bULL, 0x000eae0000000200ULL, 0x0000003a3c28723cULL, 0x040fe20000041828ULL,
0x000000003838783bULL, 0x000f2e0000000200ULL, 0x000000303c2c723cULL, 0x048ff0000004182cULL,
0x000000323c34723cULL, 0x000fe20000041834ULL, 0x000000000930783bULL, 0x000eec0000000200ULL,
0x00000010623c7824ULL, 0x000fe200078e0299ULL, 0x00000004185c723cULL, 0x042fea000004185cULL,
0x000000003c3c783bULL, 0x000e660000000200ULL, 0x000000061858723cULL, 0x040ff00000041858ULL,
0x00000040181c723cULL, 0x044ff0000004181cULL, 0x000000441804723cULL, 0x040ff00000041824ULL,
0x000000421820723cULL, 0x040ff00000041820ULL, 0x000000461828723cULL, 0x040ff00000041828ULL,
0x00000038182c723cULL, 0x050ff0000004182cULL, 0x0000003a1834723cULL, 0x000ff00000041834ULL,
0x00000054301c723cULL, 0x048ff0000004181cULL, 0x0000003c3004723cULL, 0x042ff00000041804ULL,
0x00000050305c723cULL, 0x040ff0000004185cULL, 0x000000523058723cULL, 0x040ff00000041858ULL,
0x000000563054723cULL, 0x040ff00000041820ULL, 0x0000003e303c723cULL, 0x040ff00000041828ULL,
0x000000483018723cULL, 0x040ff0000004182cULL, 0x0000004a3030723cULL, 0x000fe20000041834ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff00000008000ULL, 0x000000000d027f8cULL, 0x000fe2000c80043fULL,
0x3db504f31d1d7820ULL, 0x000fc40000410000ULL, 0x3db504f358587820ULL, 0x000fe20000410000ULL,
0x000004000d377984ULL, 0x000e620000000800ULL, 0x3db504f359597820ULL, 0x000fe40000410000ULL,
0x3db504f31c1c7820ULL, 0x000fe40000410000ULL, 0x3db504f31b007820ULL, 0x000fe40000410000ULL,
0x3db504f31a097820ULL, 0x000fe40000410000ULL, 0x3db504f3042d7820ULL, 0x000fc40000410000ULL,
0x3db504f3301a7820ULL, 0x000fe40000410000ULL, 0x3db504f31e277820ULL, 0x000fe40000410000ULL,
0x3db504f31f287820ULL, 0x000fe40000410000ULL, 0x3db504f3311b7820ULL, 0x000fe40000410000ULL,
0x3db504f332047820ULL, 0x000fe40000410000ULL, 0x3db504f333087820ULL, 0x000fc40000410000ULL,
0x000000ffff307224ULL, 0x000fe400078e001dULL, 0x3db504f35c357820ULL, 0x000fe40000410000ULL,
0x3db504f35d347820ULL, 0x000fe40000410000ULL, 0x3db504f35e227820ULL, 0x000fe40000410000ULL,
0x3db504f35f217820ULL, 0x000fe40000410000ULL, 0x3db504f35a257820ULL, 0x000fc40000410000ULL,
0x3db504f35b267820ULL, 0x000fe40000410000ULL, 0x3db504f3542f7820ULL, 0x000fe40000410000ULL,
0x3db504f3552e7820ULL, 0x000fe20000410000ULL, 0x8000000037ff7812ULL, 0x002fe20007804803ULL,
0x3db504f356297820ULL, 0x000fe40000410000ULL, 0x3db504f357237820ULL, 0x000fe40000410000ULL,
0x3db504f3052c7820ULL, 0x000fc40000410000ULL, 0x3db504f306247820ULL, 0x000fe40000410000ULL,
0x3db504f307207820ULL, 0x000fe40000410000ULL, 0x3db504f33c2b7820ULL, 0x000fe40000410000ULL,
0x3db504f33d2a7820ULL, 0x000fe40000410000ULL, 0x3db504f33e1f7820ULL, 0x000fe40000410000ULL,
0x3db504f33f1e7820ULL, 0x000fc40000410000ULL, 0x3db504f318187820ULL, 0x000fe40000410000ULL,
0x3db504f319197820ULL, 0x000fe40000410000ULL, 0x000000ffff337224ULL, 0x000fe400078e0058ULL,
0x000000ffff327224ULL, 0x000fe400078e0059ULL, 0x000000ffff317224ULL, 0x000fe400078e001cULL,
0x000000ffff1d7224ULL, 0x000fe200078e0000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0004ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x000004000d057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000040f007824ULL, 0x000fe200078e00ffULL, 0x0000000c1500720cULL, 0x000fc80003f05270ULL,
0xfffffff000037812ULL, 0x000fca00078ec0ffULL, 0x0000008060027824ULL, 0x000fca00078e0203ULL,
0x01b4000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000020f037824ULL, 0x000fe400078e00ffULL, 0x0000000117377824ULL, 0x000fc600078e0a0aULL,
0x0000000603037812ULL, 0x000fc800078ec0ffULL, 0x00000001030a7812ULL, 0x040fe400078efcffULL,
0x0000000803157812ULL, 0x040fe400078efcffULL, 0x000000370a00720cULL, 0x080fe40003f26070ULL,
0x00000010030a7812ULL, 0x000fe400078efcffULL, 0x000000371500720cULL, 0x080fe40003f06070ULL,
0x000000370a00720cULL, 0x000fc40003fc6070ULL, 0x0000001103157812ULL, 0x040fe400078efcffULL,
0x00000018030a7812ULL, 0x040fe400078efcffULL, 0x000000370300720cULL, 0x080fe40003f46070ULL,
0x000000371500720cULL, 0x080fe40003fa6070ULL, 0x000000370a00720cULL, 0x000fe40003f66070ULL,
0x0000000903367812ULL, 0x000fc400078efcffULL, 0x0000001903157812ULL, 0x040fe400078efcffULL,
0x00000020030a7812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff35357808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0xff7fffff34347808ULL, 0x000fc40004800000ULL, 0x000000373600720cULL, 0x080fe40003f86070ULL,
0x000000371500720cULL, 0x080fe40003f46070ULL, 0x000000370a00720cULL, 0x000fe40003f26070ULL,
0x0000002103157812ULL, 0x040fe400078efcffULL, 0x00000028030a7812ULL, 0x000fe400078efcffULL,
0xff7fffff25257808ULL, 0x000fc40004000000ULL, 0xff7fffff33337808ULL, 0x000fe40004000000ULL,
0xff7fffff26267808ULL, 0x000fe40006000000ULL, 0xff7fffff32327808ULL, 0x000fe40006000000ULL,
0x000000371500720cULL, 0x080fe40003f06070ULL, 0x000000370a00720cULL, 0x000fe40003f86070ULL,
0x0000002903157812ULL, 0x000fc400078efcffULL, 0x00000030030a7812ULL, 0x000fe400078efcffULL,
0xff7fffff27277808ULL, 0x000fe40007000000ULL, 0xff7fffff31317808ULL, 0x000fe40007000000ULL,
0xff7fffff28287808ULL, 0x000fe40006800000ULL, 0xff7fffff30307808ULL, 0x000fe40006800000ULL,
0x000000371500720cULL, 0x000fc40003fc6070ULL, 0x000000370a00720cULL, 0x000fe40003fa6070ULL,
0x0000003103157812ULL, 0x040fe400078efcffULL, 0x00000038030a7812ULL, 0x040fe400078efcffULL,
0x0000003903037812ULL, 0x000fe400078efcffULL, 0xff7fffff29297808ULL, 0x000fe40005800000ULL,
0xff7fffff2f2f7808ULL, 0x000fc40005800000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40005000000ULL, 0xff7fffff24247808ULL, 0x000fe40004800000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL, 0x000000371500720cULL, 0x080fe40003f66070ULL,
0x000000370a00720cULL, 0x000fc40003f46070ULL, 0x000000370300720cULL, 0x000fe40003f26070ULL,
0xff7fffff20207808ULL, 0x000fe40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40006000000ULL,
0xff7fffff1e1e7808ULL, 0x000fc40007000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40007000000ULL,
0xff7fffff09097808ULL, 0x000fe40006800000ULL, 0xff7fffff18187808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL, 0xff7fffff19197808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff08087808ULL, 0x000fe40004800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0x0000003504037209ULL, 0x004fe40007810000ULL, 0x00000022050a7209ULL, 0x000fe40007810000ULL,
0x0000003403047209ULL, 0x000fe40007810000ULL, 0x000000210a0a7209ULL, 0x000fc40007810000ULL,
0x0000003304037209ULL, 0x000fe40007810000ULL, 0x000000250a057209ULL, 0x000fe40007810000ULL,
0x0000003203047209ULL, 0x000fe40007810000ULL, 0x00000026050a7209ULL, 0x000fe40007810000ULL,
0x0000003104037209ULL, 0x000fe40007810000ULL, 0x000000270a057209ULL, 0x000fc40007810000ULL,
0x0000003003047209ULL, 0x000fe40007810000ULL, 0x00000028050a7209ULL, 0x000fe40007810000ULL,
0x0000002f04037209ULL, 0x000fe40007810000ULL, 0x000000290a0a7209ULL, 0x000fe40007810000ULL,
0x0000002e03047209ULL, 0x000fe40007810000ULL, 0x000000230a037209ULL, 0x000fc40007810000ULL,
0x0000002d04057209ULL, 0x000fe40007810000ULL, 0x0000002403037209ULL, 0x000fe40007810000ULL,
0x0000002c05047209ULL, 0x000fe40007810000ULL, 0x00000020030a7209ULL, 0x000fe40007810000ULL,
0x0000002b04037209ULL, 0x000fe40007810000ULL, 0x0000001f0a057209ULL, 0x000fc40007810000ULL,
0x0000002a03037209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x00000018030a7209ULL, 0x000fe40007810000ULL, 0x0000000904047209ULL, 0x000fe40007810000ULL,
0x000000190a037209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fc40007810000ULL,
0x0000001a03047209ULL, 0x000fe40007810000ULL, 0x0000001c05057209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x0000000805397209ULL, 0x000fe20007810000ULL,
0x000018627f007947ULL, 0x000fea000b800000ULL, 0x0c401f0004037f89ULL, 0x0004e400000e0000ULL,
0x00000003043a7209ULL, 0x008fe20007810000ULL, 0x000018b27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0039037f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007047f89ULL, 0x004ea200000e0000ULL, 0x0000000339157209ULL, 0x00afc40007810000ULL,
0x0000000506367209ULL, 0x010fc60007810000ULL, 0x0c201f0015387f89ULL, 0x000fe200000e0000ULL,
0x0000000407037209ULL, 0x004fc60007810000ULL, 0x0c201f003a057f89ULL, 0x000e6800000e0000ULL,
0x0c201f0036377f89ULL, 0x000ea800000e0000ULL, 0x0c201f00030a7f89ULL, 0x00072200000e0000ULL,
0x000000053a047209ULL, 0x002fe40007810000ULL, 0x0000003815057209ULL, 0x000fc40007810000ULL,
0x0000003736067209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x008fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x3fb8aa3b053d7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b35357823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b32327823ULL, 0x000fe20000010807ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22227823ULL, 0x000fc4000001083dULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001083dULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001083dULL,
0x3fb8aa3b25257823ULL, 0x000fe2000001083dULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b30307823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b18187823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1b077823ULL, 0x000fe20000010807ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001083dULL,
0x3fb8aa3b29297823ULL, 0x100fe4000001083dULL, 0x3fb8aa3b27277823ULL, 0x000fc4000001083dULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001083dULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001083dULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001083dULL,
0x3fb8aa3b09097823ULL, 0x100fe4000001083dULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001083dULL,
0x00000025001b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fc4000001083dULL,
0x3fb8aa3b08087823ULL, 0x000fca000001083dULL, 0x0000002600267308ULL, 0x000ef00000000800ULL,
0x0000002c00367308ULL, 0x000bf00000000800ULL, 0x0000002d00157308ULL, 0x0023e20000000800ULL,
0x00000004ff2c7e24ULL, 0x020fe2000f8e00ffULL, 0x0000001b261b723eULL, 0x008fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x3f8000002c2c783eULL, 0x000fe400000010ffULL, 0x0000001800397308ULL, 0x0007e60000000800ULL,
0x000000ffff2d7224ULL, 0x002fca00078e002cULL, 0x00000019003a7308ULL, 0x0003e20000000800ULL,
0x000000353418723eULL, 0x008fce00000010ffULL, 0x0000001a003b7308ULL, 0x0007e20000000800ULL,
0x000000222119723eULL, 0x002fce00000010ffULL, 0x0000002b00377308ULL, 0x0003e20000000800ULL,
0x00000033321a723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b20327823ULL, 0x000fcc000001083dULL,
0x0000002a00387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b242b7823ULL, 0x002fce000001083dULL,
0x00000007003c7308ULL, 0x000ff00000000800ULL, 0x00000027002a7308ULL, 0x0003f00000000800ULL,
0x0000002800077308ULL, 0x000ee20000000800ULL, 0x0000002c1824723cULL, 0x002fee00000418ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002300287308ULL, 0x000e620000000800ULL,
0x0000002a0721723eULL, 0x008fce00000010ffULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ee20000000800ULL, 0x000000292823723eULL, 0x002fe200000010ffULL,
0x000000ffff287224ULL, 0x000fc400078e002cULL, 0x000000ffff297224ULL, 0x000fc800078e002cULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x000000313020723eULL, 0x008fce00000010ffULL, 0x0000002b002d7308ULL, 0x0007e20000000800ULL,
0x0000002f2e22723eULL, 0x002fce00000010ffULL, 0x0000003200327308ULL, 0x000e620000000800ULL,
0x000000282028723cULL, 0x008fee0000041824ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x000000153624723eULL, 0x000fe400000010ffULL, 0x000000373826723eULL, 0x000fca00000010ffULL,
0x0000001e001e7308ULL, 0x000ee20000000800ULL, 0x0000002d3225723eULL, 0x002fe200000010ffULL,
0x000000ffff2d7224ULL, 0x000fe200078e002cULL, 0xfffffffc0f157812ULL, 0x000fca00078ec0ffULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x0000001f1e27723eULL, 0x008fe200000010ffULL,
0x0000000fff1e7424ULL, 0x000fcc00078e00ffULL, 0x0000001d002e7308ULL, 0x000e620000000800ULL,
0x000000151e157219ULL, 0x000fe200000006ffULL, 0x0000002c2430723cULL, 0x000fec0000041828ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x00000000151e73a1ULL, 0x000ee200000e8000ULL,
0x00000000150473c4ULL, 0x000f620000004000ULL, 0x000000393a28723eULL, 0x000fc400000010ffULL,
0x0000003b3c2a723eULL, 0x000fc600000010ffULL, 0x0000000800077308ULL, 0x000f220000000800ULL,
0x000000092e29723eULL, 0x002fe400000010ffULL, 0x0000001c072b723eULL, 0x010fe400000010ffULL,
0x0000000515ff7c12ULL, 0x008fe4000f80401eULL, 0x000000030a077209ULL, 0x004fc60007810000ULL,
0x0000002c2830723cULL, 0x000ff00000041830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000147204008947ULL, 0x020fde000b800000ULL, 0x001c1fff302c7589ULL, 0x0002a400000e0000ULL,
0x00000000150873a1ULL, 0x000ee200000e8000ULL, 0x00000000150473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x0000000515ff7c12ULL, 0x008fda000f804008ULL,
0x0000149204008947ULL, 0x010fea000b800000ULL, 0x001c1fff322d7589ULL, 0x00072800000e0000ULL,
0x001c1fff2e2e7589ULL, 0x00066800000e0000ULL, 0x001c1fff002f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff037819ULL, 0x000fe4000001160fULL, 0x0000000c003d7812ULL, 0x000fc400078ec0ffULL,
0x0000000703087812ULL, 0x040fe200078ec0ffULL, 0x00000008031d7824ULL, 0x040fe200078e00ffULL,
0x00000003ff157212ULL, 0x00afe200078e33ffULL, 0x0000000803097824ULL, 0x000fe200078e00ffULL,
0x000000030fff7812ULL, 0x000fe2000780c0ffULL, 0x0000000803387824ULL, 0x040fe200078e00ffULL,
0x0000000803037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81d0a7812ULL, 0x100fe400078ee208ULL,
0x00000001091c7812ULL, 0x100fe200078ef608ULL, 0x0000000803487824ULL, 0x000fe200078e00ffULL,
0x00000002091e7812ULL, 0x100fe200078ef608ULL, 0x00000008031d7824ULL, 0x000fe200078e00ffULL,
0x0000000309307812ULL, 0x000fc400078ef608ULL, 0x0000000409327812ULL, 0x140fe400078ef608ULL,
0x0000000509347812ULL, 0x140fe400078ef608ULL, 0x0000000609367812ULL, 0x000fe200078ef608ULL,
0x0000000803097824ULL, 0x040fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe400078ee215ULL,
0x00000003ff157212ULL, 0x000fe400078e33ffULL, 0x0000000703087812ULL, 0x000fc400078ec0ffULL,
0x0001100060037811ULL, 0x000fe400078e58ffULL, 0xfffffff81d3a7812ULL, 0x100fe400078ee208ULL,
0x00000001093c7812ULL, 0x140fe200078ef608ULL, 0x000000100a007824ULL, 0x000fe200078e0203ULL,
0xfffffff848487812ULL, 0x000fe200078ee215ULL, 0x000000101e0a7824ULL, 0x100fe200078e0203ULL,
0x00000002093e7812ULL, 0x140fe200078ef608ULL, 0x00000010321e7824ULL, 0x100fe200078e0203ULL,
0x0000000309407812ULL, 0x140fe200078ef608ULL, 0x0000001036327824ULL, 0x100fe200078e0203ULL,
0x0000000409427812ULL, 0x140fe200078ef608ULL, 0x000000103c367824ULL, 0x100fe200078e0203ULL,
0x0000000509447812ULL, 0x140fe200078ef608ULL, 0x000000103e377824ULL, 0x100fe200078e0203ULL,
0x0000000609467812ULL, 0x000fe200078ef608ULL, 0x000000101c087824ULL, 0x000fc400078e0203ULL,
0x00000010301c7824ULL, 0x100fe400078e0203ULL, 0x0000001034307824ULL, 0x100fe400078e0203ULL,
0x000000013d097824ULL, 0x000fe400078e0200ULL, 0x0000001038347824ULL, 0x100fe400078e0203ULL,
0x000000103a007824ULL, 0x100fe200078e0203ULL, 0x0000001809007388ULL, 0x0003e20000000800ULL,
0x0000001040387824ULL, 0x000fc400078e0203ULL, 0x0000001042397824ULL, 0x100fe400078e0203ULL,
0x00000010443a7824ULL, 0x100fe400078e0203ULL, 0x00000010463b7824ULL, 0x100fe400078e0203ULL,
0x00000010483c7824ULL, 0x000fe400078e0203ULL, 0x000000013d037824ULL, 0x040fe400078e0208ULL,
0x000000013d157824ULL, 0x000fc400078e020aULL, 0x000000013d1d7824ULL, 0x040fe200078e021cULL,
0x0000001a03007388ULL, 0x0007e20000000800ULL, 0x000000013d1f7824ULL, 0x040fe400078e021eULL,
0x000000013d317824ULL, 0x040fe200078e0230ULL, 0x0000002015007388ULL, 0x0007e20000000800ULL,
0x000000013d337824ULL, 0x040fe400078e0232ULL, 0x000000013d357824ULL, 0x040fe200078e0234ULL,
0x000000221d007388ULL, 0x0007e20000000800ULL, 0x000000013d007824ULL, 0x000fc400078e0200ULL,
0x000000013d367824ULL, 0x040fe200078e0236ULL, 0x000000241f007388ULL, 0x0007e20000000800ULL,
0x000000013d087824ULL, 0x040fe400078e0237ULL, 0x000000013d387824ULL, 0x040fe200078e0238ULL,
0x0000002631007388ULL, 0x0007e20000000800ULL, 0x000000013d0a7824ULL, 0x040fe400078e0239ULL,
0x000000013d3a7824ULL, 0x040fe200078e023aULL, 0x0000002833007388ULL, 0x0007e20000000800ULL,
0x000000013d187824ULL, 0x002fc400078e023bULL, 0x000000013d3c7824ULL, 0x000fe200078e023cULL,
0x0000002a35007388ULL, 0x0007e80000000800ULL, 0x0000001900007388ULL, 0x0007e80000000800ULL,
0x0000001b36007388ULL, 0x0007e80000000800ULL, 0x0000002108007388ULL, 0x0007e80000000800ULL,
0x0000002338007388ULL, 0x0007e80000000800ULL, 0x000000250a007388ULL, 0x0007e80000000800ULL,
0x000000273a007388ULL, 0x0007e80000000800ULL, 0x0000002918007388ULL, 0x0007e80000000800ULL,
0x0000002b3c007388ULL, 0x0007e80000000800ULL, 0x01b0000402008388ULL, 0x0007e80000000c00ULL,
0x01b2002c02008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b608000bff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b610000bff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b618000bff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000144d00720cULL, 0x000fe20003f06070ULL, 0x01b620000bff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff157224ULL, 0x008fd600078e004dULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffabf000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff107807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x000133a0001d7802ULL, 0x000fe40000000f00ULL, 0x0000106000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e001cULL, 0xfffef56000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013400001d7802ULL, 0x000fe40000000f00ULL, 0x0000100000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e001cULL, 0xfffef58000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x004fe200078e0020ULL, 0x00013480001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000fULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000f4000007944ULL, 0x02afea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e002fULL, 0xfffef5c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1f7224ULL, 0x000fe200078e000fULL, 0x00013500001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0020ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000ec000007944ULL, 0x02cfea0003c00000ULL,
0xfffef58000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1f7224ULL, 0x000fe200078e0011ULL,
0x00013560001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x00000e6000007944ULL, 0x028fea0003c00000ULL,
0x00000008115c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff637224ULL, 0x004fe200078e002fULL,
0x000135d0001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x002fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e005cULL,
0x00000df000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff627224ULL, 0x004fe200078e002fULL,
0xfffef7a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00013630001d7802ULL, 0x000fe40000000f00ULL,
0x00000dd000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xffff0f8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004800000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00013690001d7802ULL, 0x000fe40000000f00ULL,
0x00000d7000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xffff0fb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x002fe200078e0009ULL,
0x00013700001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000cc000007944ULL, 0x028fea0003c00000ULL,
0xffff102000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x002fe200078e0009ULL,
0x00013770001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fe400078e005cULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x00000c5000007944ULL, 0x028fea0003c00000ULL, 0xffff10d000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x000fe200078e00ffULL, 0x000137c0001c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000c0000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff777224ULL, 0x004fe200078e002fULL, 0x00013820001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x002fc400078e005cULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000ba000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff787224ULL, 0x004fe200078e002fULL, 0xffff121000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013880001d7802ULL, 0x000fe40000000f00ULL, 0x00000b8000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xffff27c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x000138e0001d7802ULL, 0x000fe40000000f00ULL, 0x00000b2000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xffff27f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1f7224ULL, 0x002fe200078e0010ULL, 0x00013960001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0011ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000a6000007944ULL, 0x028fea0003c00000ULL,
0xffff285000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x002fe200078e0011ULL,
0x000139d0001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fe400078e005cULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x000009f000007944ULL, 0x028fea0003c00000ULL, 0xffff290000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x000fe200078e00ffULL, 0x00013a20001c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x000009a000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff777224ULL, 0x004fe200078e002fULL, 0x00013a80001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x002fc400078e005cULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000094000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff787224ULL, 0x004fe200078e002fULL, 0xffff2a4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013ae0001d7802ULL, 0x000fe40000000f00ULL, 0x0000092000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xffff3f9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013b40001d7802ULL, 0x000fe40000000f00ULL, 0x000008c000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xffff3fc000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x002fe200078e00ffULL, 0x00013ba0001c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x028fea0003c00000ULL,
0xffff404000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1f7224ULL, 0x002fe200078e005cULL,
0x00013c00001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x000007c000007944ULL, 0x028fea0003c00000ULL,
0xffff410000007947ULL, 0x000fea000383ffffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x00013c50001c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000077000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff5d7224ULL, 0x004fe200078e002fULL,
0x00013cb0001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e005cULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000071000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff5c7224ULL, 0x004fe200078e002fULL,
0xffff424000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0004ULL,
0x00013d3000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff157424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000065000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000aULL,
0xffffe73000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0039ULL,
0x00013db000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff157424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000005d000007944ULL, 0x004fea0003c00000ULL, 0x0000000a39057209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0006ULL, 0x00013e2000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff157424ULL, 0x002fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000056000007944ULL, 0x000fea0003c00000ULL,
0x0000000a06397209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0007ULL,
0x00013e9000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff157424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000004f000007944ULL, 0x000fea0003c00000ULL, 0x0000000a07037209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e003aULL, 0x00013f0000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff157424ULL, 0x002fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000000a3a047209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0005ULL,
0x00013f7000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff157424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x0000000a05057209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0039ULL, 0x00013fe000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff157424ULL, 0x002fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000000a39067209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0003ULL,
0x0001405000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff157424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000033000007944ULL, 0x000fea0003c00000ULL, 0xffffe51000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x000fe200078e0030ULL, 0x000140c0001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fe400078e0015ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e002fULL, 0xffffeb2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x002fe200078e0032ULL, 0x00014140001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fe400078e0015ULL, 0x0000028000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e00ffULL, 0x000141a0001c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff307424ULL, 0x000fc400078e00ffULL, 0x000000ffff317224ULL, 0x000fe400078e0015ULL,
0x000000ffff2d7224ULL, 0x004fe400078e002fULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff317224ULL, 0x002fe200078e0015ULL, 0x00014200001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x004fe400078e002fULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x0180000008077810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f800000070c7812ULL, 0x000fc800078ec0ffULL,
0x018000000c00780cULL, 0x000fda0003f05070ULL, 0x0000000800078308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0c00720cULL, 0x040fe40003f25070ULL,
0x008000000c00780cULL, 0x000fe40003f02070ULL, 0x00000001ff0c7807ULL, 0x000fe40000800000ULL,
0x00000001ff077807ULL, 0x004fc80004000000ULL, 0x000000070cff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff08ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000008087812ULL, 0x002fe400078ec0ffULL, 0x00000001ff077807ULL, 0x000fc80000000000ULL,
0x000000070cff7212ULL, 0x000fda000780c0ffULL, 0x0080000008070812ULL, 0x000fe200078efcffULL,
0x000000ffff078224ULL, 0x000fe200078e0008ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000800077308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff2d7424ULL, 0x000fc800078e00ffULL, 0xfffebc802c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff377424ULL, 0x000fe200078e00ffULL, 0x0000003b00007348ULL, 0x000fe80003800000ULL,
0x0c0000150a0a7389ULL, 0x0002a200000e0038ULL, 0xfffebc4036007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000003100007348ULL, 0x000fe80003800000ULL,
0x0000001f1e2f7389ULL, 0x0002a200000e0030ULL, 0xfffebc001c007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f25070ULL, 0x0000001100007348ULL, 0x000fd80003800000ULL,
0x0000000000107806ULL, 0x000fc800048e0100ULL, 0x00000011101c7212ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fe400078e001dULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffebb9010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000320ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000900ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000990ULL, 0x00000000000005e4ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f74ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f98ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000fa8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000fc8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001058ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001060ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001070ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000014500ULL, 0xa000001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015780ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000015790ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015790ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015c10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001058ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014728ULL, 0x0000000000014728ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015c10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 89328;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
