/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000013190ULL, 0x0000000000012d10ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000011bb0ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000011d20ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000011d60ULL, 0x0000000000000120ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000011e80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00011bb000000000ULL, 0x0000040400000000ULL, 0x810c0000007c0400ULL, 0x0046600400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080ac0828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080ac92ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00011bb000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080ac0828808081ULL, 0xb308288080ae0828ULL, 0x288080a808288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080a8ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL,
0x00011d2000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080a80828808081ULL, 0xb308288080ac0828ULL, 0x288080ae08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x00002200288080aeULL, 0x0000001cffffffffULL, 0x0000016000000000ULL,
0x00011d6000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL,
0x00081204000000a7ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000dULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00010b2000183104ULL, 0x00010e3000010e20ULL,
0x00010f0000010ef0ULL, 0x00c8290400010f10ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001e0500001eULL, 0x0500001e0500001eULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c000c82804ULL,
0x000020b0000000f0ULL, 0x0000392000003860ULL, 0x00003a00000039d0ULL, 0x00003ea000003e40ULL,
0x00005e6000004670ULL, 0x00005fc000005f00ULL, 0x0000638000006000ULL, 0x00006c00000063e0ULL,
0x00006f7000006c30ULL, 0x00009bc000006f80ULL, 0x0000a0d000009be0ULL, 0x000107500000a100ULL,
0x0001079000010780ULL, 0x000107c0000107a0ULL, 0x00010800000107e0ULL, 0x00010ee000010810ULL,
0x00010f5000010f40ULL, 0x000115a000010f60ULL, 0x000116a000011620ULL, 0x0001179000011720ULL,
0x0001187000011800ULL, 0x00011950000118e0ULL, 0x00011a40000119c0ULL, 0x00011b2000011ac0ULL,
0x0110390400011b80ULL, 0x000000ff00000160ULL, 0x003f010000023600ULL, 0x0000000d000001a0ULL,
0x003f013000023608ULL, 0x0000000d000001d0ULL, 0x003f013000023610ULL, 0x000000ff000003f0ULL,
0x003f010700023600ULL, 0x00000000000005f0ULL, 0x003f010200000004ULL, 0x00000000000006b0ULL,
0x003f010100000000ULL, 0x0000000900003620ULL, 0x003f01060002360cULL, 0x0000000900003790ULL,
0x003f01060002360cULL, 0x0000001400004610ULL, 0x003f010100000000ULL, 0x0000000900005c10ULL,
0x003f01060002362cULL, 0x0000000900005d80ULL, 0x003f01060002362cULL, 0x0000000e00006940ULL,
0x003f010100000000ULL, 0x000000ff0000c860ULL, 0x003f010600023604ULL, 0x000000ff0000c8f0ULL,
0x003f010600023604ULL, 0x000000870000fd10ULL, 0x003f010600023614ULL, 0x0000008700010050ULL,
0x003f010600023614ULL, 0x00000087000114e0ULL, 0x003f010100023608ULL, 0x00141c0400033803ULL,
0x0000af300000aaf0ULL, 0x0000c9f00000c940ULL, 0x0000040100011540ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001ccULL, 0x0000001100000002ULL, 0x000000000000014cULL, 0x0000001100000002ULL,
0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001a7ULL, 0x0000001100000002ULL, 0x0000000000000127ULL, 0x0000001100000002ULL,
0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x0000000400097802ULL, 0x000fe20000000f00ULL, 0x00000000000479c3ULL, 0x000ea20000002600ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x00005800ff107624ULL, 0x000fc600078e00ffULL, 0x00000000008f7919ULL, 0x000ee80000002100ULL,
0x0000000000887919ULL, 0x000f220000002700ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000d7824ULL, 0x108fe200078e028fULL, 0x00000005ff8f7819ULL, 0x000fe2000001168fULL,
0x00001fff06007589ULL, 0x00086600000e0000ULL, 0x000000ff0d00720cULL, 0x040fe40003f05270ULL,
0x000000030d00780cULL, 0x040fe20003f24070ULL, 0x00001fff8f8f7589ULL, 0x000ee200000e0000ULL,
0x0000007f0d00780cULL, 0x000fe20003f44070ULL, 0x0000620088067625ULL, 0x010fd000078e0009ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff049424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff059424ULL, 0x000fe200078e00ffULL,
0x02360002ff008388ULL, 0x0009e20000000a00ULL, 0x000000ff0000720cULL, 0x002fe20003f05270ULL,
0xff317217ff08a424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff0a9424ULL, 0x000fe200078e00ffULL,
0x023608040d009388ULL, 0x0009e2000000ca00ULL, 0x7fffffc0ff0b9424ULL, 0x000fc600078e00ffULL,
0x023400080d00a388ULL, 0x0009e80000004800ULL, 0x0236100a0d009388ULL, 0x0009e8000000ca00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000026000000947ULL, 0x004fea0003800000ULL,
0x00000000000e7919ULL, 0x008e620000000000ULL, 0x000000048f027824ULL, 0x010fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x0000001010037824ULL, 0x000fc400078e00ffULL,
0x00000100ff117424ULL, 0x000fc600078e00ffULL, 0x0000000503037e24ULL, 0x000fe2000f8e0288ULL,
0x000000020e087211ULL, 0x042fe200078fe0ffULL, 0x000000100e047824ULL, 0x000fc600078e00ffULL,
0x00000002080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103027824ULL, 0x040fe200078e0208ULL,
0x0000000708057812ULL, 0x000fe400078ec0ffULL, 0x000000070a0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001030c7824ULL, 0x000fe200078e020aULL, 0x000000f0040f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0002027625ULL, 0x080fe200078e0011ULL, 0x0000000f050b7812ULL, 0x100fe400078e780eULL,
0x0000000f0d0d7812ULL, 0x000fe200078e780eULL, 0x00005c000c047625ULL, 0x000fe200078e0011ULL,
0x0000000f02027210ULL, 0x000fc60007f1e0ffULL, 0x00000010080b7824ULL, 0x000fe200078e020bULL,
0x0000000f04047210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0d7824ULL, 0x000fe400078e020dULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x000000040b0b7819ULL, 0x000fe200000006ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100d0d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e8000b901c46ULL,
0x00000000040d7faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x02360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006068e7981ULL, 0x008ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000ee20000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000005ff917e24ULL, 0x008fe2000f8e00ffULL,
0x0000003f8e8c7810ULL, 0x004fc40007ffe0ffULL, 0x000000ff8e8a7810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff8c7819ULL, 0x000fe4000001168cULL, 0x00000008ff8a7819ULL, 0x000fca000001168aULL,
0x0000aa5000008947ULL, 0x000fea0003800000ULL, 0x00000001ff6e7819ULL, 0x000fe2000001168fULL,
0x00000001ff077424ULL, 0x000fe400078e00ffULL, 0xffffffffff047424ULL, 0x012fe200078e00ffULL,
0x03ffffff6e007812ULL, 0x000fca00078ec0ffULL, 0x0000000491057824ULL, 0x000fca00078e0200ULL,
0x0000008c0500720cULL, 0x000fda0003f06070ULL, 0x0000000288008824ULL, 0x000fe400078e00ffULL,
0x00006400ff038624ULL, 0x000fc800078e00ffULL, 0x0000640000028624ULL, 0x000fe200078e0203ULL,
0x000236108f007811ULL, 0x000fc600078e20ffULL, 0x0000000105028824ULL, 0x000fe200078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040700ff738cULL, 0x0003e20000000000ULL,
0x0000600002028625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000191077810ULL, 0x002fe20007ffe0ffULL, 0x0000000602048981ULL, 0x000362000c1e1900ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x00000040100d7824ULL, 0x000fe200078e00ffULL,
0x0000008a0700720cULL, 0x000fe20003f06070ULL, 0x0000000000ff7f8cULL, 0x0003e2000c80043fULL,
0x000000018f077812ULL, 0x000fd600078ec0ffULL, 0x00000c0000008947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x0000006e91037211ULL, 0x000fe200078e10ffULL,
0x000000040d047e24ULL, 0x020fe4000f8e0204ULL, 0x00000100ff2c7424ULL, 0x000fe400078e00ffULL,
0x0000004003037824ULL, 0x000fca00078e00ffULL, 0x000000038e007217ULL, 0x000fca0007800000ULL,
0x0000000100007824ULL, 0x000fca00078e0a03ULL, 0x0000004000007817ULL, 0x000fe40003800000ULL,
0x00000003ff0b7819ULL, 0x002fe40000011606ULL, 0x0ffffff806037812ULL, 0x000fe400078ec0ffULL,
0x000000040b0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000080b117810ULL, 0x000fe40007ffe0ffULL,
0x000000060d0a7212ULL, 0x0c0fe200078e3cffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x00000006110c7212ULL, 0x040fe200078e3cffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0x0000000c0b197810ULL, 0x000fc40007ffe0ffULL, 0x000000140b1d7810ULL, 0x040fe40007ffe0ffULL,
0x000000060b027212ULL, 0x0c0fe400078e3cffULL, 0x000000100b1b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80f0e7812ULL, 0x000fe200078ee20aULL, 0x00000008190f7824ULL, 0x000fe200078e00ffULL,
0xfffffff813107812ULL, 0x000fe200078ee20cULL, 0x000000081d137824ULL, 0x000fe200078e00ffULL,
0x0000000703087812ULL, 0x000fe200078ef802ULL, 0x000000081b167824ULL, 0x000fe200078e00ffULL,
0x0000000619027212ULL, 0x000fc400078e3cffULL, 0x000000061d0a7212ULL, 0x080fe400078e3cffULL,
0x000000180b217810ULL, 0x040fe40007ffe0ffULL, 0x000000200b297810ULL, 0x040fe40007ffe0ffULL,
0x0000001c0b257810ULL, 0x000fe40007ffe0ffULL, 0x000000061b037212ULL, 0x080fe400078e3cffULL,
0xfffffff80f127812ULL, 0x000fe200078ee202ULL, 0x00000008210f7824ULL, 0x000fe200078e00ffULL,
0xfffffff813187812ULL, 0x000fe200078ee20aULL, 0x0000000829137824ULL, 0x000fe200078e00ffULL,
0x0000000621027212ULL, 0x080fe200078e3cffULL, 0x00000008251c7824ULL, 0x000fe200078e00ffULL,
0x00000006290a7212ULL, 0x000fc400078e3cffULL, 0x0000002c0b357810ULL, 0x040fe40007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe400078ee203ULL, 0x000000240b2d7810ULL, 0x040fe40007ffe0ffULL,
0x000000280b317810ULL, 0x000fe40007ffe0ffULL, 0x0000000625037212ULL, 0x080fe400078e3cffULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee202ULL, 0x0000000831227824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee20aULL, 0x0000000835137824ULL, 0x000fe200078e00ffULL,
0x000000062d027212ULL, 0x000fc400078e3cffULL, 0x000000032d0f7819ULL, 0x000fe400000006ffULL,
0x000000340b3d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee203ULL,
0x00000006350a7212ULL, 0x080fe400078e3cffULL, 0x0000000631037212ULL, 0x000fe400078e3cffULL,
0x000000300b397810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80f207812ULL, 0x000fe200078ee202ULL,
0x000000083d0f7824ULL, 0x000fe200078e00ffULL, 0x000000380b417810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813247812ULL, 0x000fe400078ee20aULL, 0xfffffff822227812ULL, 0x000fe200078ee203ULL,
0x0000000839037824ULL, 0x000fe200078e00ffULL, 0x000000063d0a7212ULL, 0x080fe200078e3cffULL,
0x0000000841137824ULL, 0x000fe200078e00ffULL, 0x0000000639027212ULL, 0x000fc400078e3cffULL,
0x00000006410c7212ULL, 0x000fe400078e3cffULL, 0xfffffff80f287812ULL, 0x000fe400078ee20aULL,
0x0000003c0b457810ULL, 0x000fe40007ffe0ffULL, 0x0000003f0d0f7812ULL, 0x000fe400078ec0ffULL,
0xfffffff803267812ULL, 0x000fe200078ee202ULL, 0x0000000845497824ULL, 0x000fe200078e00ffULL,
0x0000003f19157812ULL, 0x000fe200078ec0ffULL, 0x00000001040a7824ULL, 0x000fe200078e020fULL,
0x0000003f0b037812ULL, 0x000fc400078ec0ffULL, 0x0000003f1b177812ULL, 0x000fe200078ec0ffULL,
0x00000001040f7824ULL, 0x040fe200078e0215ULL, 0xfffffff8132a7812ULL, 0x000fe200078ee20cULL,
0x0000000104037824ULL, 0x000fe200078e0203ULL, 0x0000003f11137812ULL, 0x000fe200078ec0ffULL,
0x000000026e157824ULL, 0x000fe200078e0207ULL, 0x0000003f1d1f7812ULL, 0x000fe400078ec0ffULL,
0x0000003f21237812ULL, 0x000fe200078ec0ffULL, 0x00000001040c7824ULL, 0x040fe200078e0213ULL,
0x0000003f25277812ULL, 0x000fe200078ec0ffULL, 0x00000001041f7824ULL, 0x040fe200078e021fULL,
0x0000003f292b7812ULL, 0x000fe200078ec0ffULL, 0x0000000104237824ULL, 0x040fe200078e0223ULL,
0x0000003f2d2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000104277824ULL, 0x040fe200078e0227ULL,
0x0000003f31337812ULL, 0x000fe200078ec0ffULL, 0x00000001042b7824ULL, 0x040fe200078e022bULL,
0x0000003f35377812ULL, 0x000fe200078ec0ffULL, 0x00000001042f7824ULL, 0x040fe200078e022fULL,
0x0000003f393b7812ULL, 0x000fe200078ec0ffULL, 0x0000000104337824ULL, 0x040fe200078e0233ULL,
0x0000003f3d3f7812ULL, 0x000fe200078ec0ffULL, 0x0000000104377824ULL, 0x040fe200078e0237ULL,
0x0000003f41437812ULL, 0x000fe200078ec0ffULL, 0x00000001043b7824ULL, 0x040fe200078e023bULL,
0x0000003f45477812ULL, 0x040fe200078ec0ffULL, 0x00000001043f7824ULL, 0x040fe200078e023fULL,
0x0000000645027212ULL, 0x000fe200078e3cffULL, 0x0000000104437824ULL, 0x040fe200078e0243ULL,
0x0000001704147210ULL, 0x040fe20007ffe0ffULL, 0x0000000807177824ULL, 0x000fe200078e00ffULL,
0x0000004704477210ULL, 0x000fc40007ffe0ffULL, 0x000000000b00720cULL, 0x000fe20003f46070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e002cULL, 0xfffffff849047812ULL, 0x000fe400078ee202ULL,
0x000000000d00720cULL, 0x000fe20003f26070ULL, 0x00005e0003027625ULL, 0x000fe200078e002cULL,
0x000000001100720cULL, 0x000fe40003f06070ULL, 0x0001300015157811ULL, 0x000fe200078e70ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e002cULL, 0xfffffff817177812ULL, 0x000fc400078ee206ULL,
0x000000001900720cULL, 0x080fe20003f86070ULL, 0x0000001008137824ULL, 0x000fe200078e0215ULL,
0x000000001b00720cULL, 0x080fe20003fc6070ULL, 0x0000001017027825ULL, 0x000fe200078e0002ULL,
0x000000001d00720cULL, 0x080fe40003fa6070ULL, 0x000000002100720cULL, 0x080fe20003f66070ULL,
0x000000100e197824ULL, 0x000fe200078e0215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002137faeULL, 0x0003e2000d101c46ULL, 0x00000010170a7825ULL, 0x000fe200078e000aULL,
0x000000002500720cULL, 0x000fc60003f46070ULL, 0x00005e000f0e7625ULL, 0x000fe200078e002cULL,
0x000000000a197faeULL, 0x0005e2000c901c46ULL, 0x000000002900720cULL, 0x000fe40003f26070ULL,
0x00000010101b7824ULL, 0x000fe400078e0215ULL, 0x00000010170c7825ULL, 0x000fc800078e000cULL,
0x00005e0014107625ULL, 0x000fe200078e002cULL, 0x000000000c1b7faeULL, 0x0007e2000c101c46ULL,
0x000000002d00720cULL, 0x000fe40003f06070ULL, 0x00005e001f027625ULL, 0x002fc800078e002cULL,
0x00000010121d7824ULL, 0x000fe400078e0215ULL, 0x00000010170e7825ULL, 0x000fe200078e000eULL,
0x000000151c1b7211ULL, 0x008fc600078e20ffULL, 0x00005e00230a7625ULL, 0x004fe200078e002cULL,
0x000000000e1d7faeULL, 0x0003e2000e101c46ULL, 0x000000003100720cULL, 0x000fe40003f86070ULL,
0x00005e00270c7625ULL, 0x000fc800078e002cULL, 0x00000010161f7824ULL, 0x000fe400078e0215ULL,
0x0000001017107825ULL, 0x000fc800078e0010ULL, 0x00005e002b127625ULL, 0x000fe200078e002cULL,
0x00000000101f7faeULL, 0x0005e2000f101c46ULL, 0x000000003500720cULL, 0x000fe40003fc6070ULL,
0x0000001018197824ULL, 0x000fe400078e0215ULL, 0x0000001017027825ULL, 0x000fc800078e0002ULL,
0x000000101a0f7824ULL, 0x002fe200078e0215ULL, 0x0000000002197faeULL, 0x0003e2000e901c46ULL,
0x00000010170a7825ULL, 0x000fe200078e000aULL, 0x000000003900720cULL, 0x000fc60003fa6070ULL,
0x00000010170c7825ULL, 0x000fe200078e000cULL, 0x000000000a0f7faeULL, 0x0007e2000d901c46ULL,
0x000000003d00720cULL, 0x080fe40003f66070ULL, 0x000000101e117824ULL, 0x004fe200078e0215ULL,
0x000000000c1b7faeULL, 0x0005e2000d101c46ULL, 0x0000001017127825ULL, 0x000fe200078e0012ULL,
0x000000004100720cULL, 0x000fc60003f46070ULL, 0x00005e002f027625ULL, 0x002fe200078e002cULL,
0x0000000012117faeULL, 0x0003e2000c901c46ULL, 0x000000004500720cULL, 0x000fe40003f26070ULL,
0x00005e00330a7625ULL, 0x008fc800078e002cULL, 0x00005e00370c7625ULL, 0x004fc800078e002cULL,
0x00005e003b0e7625ULL, 0x000fc800078e002cULL, 0x00005e003f107625ULL, 0x002fc800078e002cULL,
0x0000001020197824ULL, 0x100fe400078e0215ULL, 0x00000010221d7824ULL, 0x100fe400078e0215ULL,
0x00000010241f7824ULL, 0x100fe400078e0215ULL, 0x0000001026217824ULL, 0x100fe400078e0215ULL,
0x0000001028237824ULL, 0x100fe400078e0215ULL, 0x000000102a257824ULL, 0x000fc400078e0215ULL,
0x0000001004277824ULL, 0x000fe400078e0215ULL, 0x00005e0043127625ULL, 0x000fc800078e002cULL,
0x00005e0047147625ULL, 0x000fc800078e002cULL, 0x0000001017027825ULL, 0x000fc800078e0002ULL,
0x00000010170a7825ULL, 0x040fe200078e000aULL, 0x0000000002197faeULL, 0x0003e6000c101c46ULL,
0x00000010170c7825ULL, 0x040fe200078e000cULL, 0x000000000a1d7faeULL, 0x0003e6000e101c46ULL,
0x00000010170e7825ULL, 0x040fe200078e000eULL, 0x000000000c1f7faeULL, 0x0003e6000f101c46ULL,
0x0000001017107825ULL, 0x040fe200078e0010ULL, 0x000000000e217faeULL, 0x0003e6000e901c46ULL,
0x0000001017127825ULL, 0x040fe200078e0012ULL, 0x0000000010237faeULL, 0x0003e6000d901c46ULL,
0x0000001017147825ULL, 0x000fe200078e0014ULL, 0x0000000012257faeULL, 0x0003e8000d101c46ULL,
0x0000000014277faeULL, 0x0003e2000c901c46ULL, 0x00000aa000007947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x000000040d047e24ULL, 0x020fe2000f8e0204ULL,
0x00000003ff037819ULL, 0x002fc40000011606ULL, 0x0ffffff8060b7812ULL, 0x000fe400078ec0ffULL,
0x0000000803117810ULL, 0x040fe40007ffe0ffULL, 0x0000001803197810ULL, 0x000fe40007ffe0ffULL,
0x00000006110a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x00000004030f7810ULL, 0x000fe20007ffe0ffULL, 0x00000008191d7824ULL, 0x040fe200078e00ffULL,
0x00000006190c7212ULL, 0x000fc400078e3cffULL, 0xfffffff8150e7812ULL, 0x000fe200078ee20aULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x0000001003157810ULL, 0x000fe40007ffe0ffULL,
0x000000060f027212ULL, 0x080fe400078e3cffULL, 0x0000001403177810ULL, 0x000fe20007ffe0ffULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000000603007212ULL, 0x000fe400078e3cffULL,
0xfffffff81d1e7812ULL, 0x000fe200078ee20cULL, 0x00000008171a7824ULL, 0x000fe200078e00ffULL,
0xfffffff813087812ULL, 0x000fc400078ee202ULL, 0x00000006150a7212ULL, 0x080fe400078e3cffULL,
0x00000020031d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c03137810ULL, 0x000fe40007ffe0ffULL,
0x000000070b007812ULL, 0x000fe200078ef800ULL, 0x000000081d237824ULL, 0x000fe200078e00ffULL,
0x00000024031f7810ULL, 0x000fe40007ffe0ffULL, 0x00000006170b7212ULL, 0x000fc400078e3cffULL,
0xfffffff81b167812ULL, 0x000fe200078ee20aULL, 0x000000081f2a7824ULL, 0x000fe200078e00ffULL,
0x0000000613027212ULL, 0x0c0fe400078e3cffULL, 0x00000003130d7819ULL, 0x000fe400000006ffULL,
0x0000001c031b7810ULL, 0x000fe40007ffe0ffULL, 0x000000061d0a7212ULL, 0x000fe400078e3cffULL,
0xfffffff81a1a7812ULL, 0x000fc400078ee20bULL, 0x00000034032b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d127812ULL, 0x000fe200078ee202ULL, 0x000000081b0d7824ULL, 0x000fe200078e00ffULL,
0x000000061f0b7212ULL, 0x080fe200078e3cffULL, 0x000000082b3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff823267812ULL, 0x000fe400078ee20aULL, 0x000000061b027212ULL, 0x000fe400078e3cffULL,
0x0000002c03237810ULL, 0x000fc40007ffe0ffULL, 0x0000002803217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee20bULL, 0x000000062b0b7212ULL, 0x080fe200078e3cffULL,
0x0000000821257824ULL, 0x000fe200078e00ffULL, 0xfffffff80d227812ULL, 0x000fe200078ee202ULL,
0x00000008230d7824ULL, 0x040fe200078e00ffULL, 0x0000000623027212ULL, 0x080fe400078e3cffULL,
0x00000006210c7212ULL, 0x000fc400078e3cffULL, 0x0000003003297810ULL, 0x040fe40007ffe0ffULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee20bULL, 0x00000038032d7810ULL, 0x040fe40007ffe0ffULL,
0x0000003f030b7812ULL, 0x040fe400078ec0ffULL, 0x0000003c03037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d327812ULL, 0x000fe200078ee202ULL, 0x000000026e027824ULL, 0x000fe200078e0207ULL,
0xfffffff8252e7812ULL, 0x000fe200078ee20cULL, 0x0000000829257824ULL, 0x040fe200078e00ffULL,
0x00000006290a7212ULL, 0x080fe200078e3cffULL, 0x0000000803407824ULL, 0x000fe200078e00ffULL,
0x000000062d0c7212ULL, 0x000fc400078e3cffULL, 0x000000032d277819ULL, 0x000fe400000006ffULL,
0x0000003f0f0f7812ULL, 0x000fe400078ec0ffULL, 0x00000006032f7212ULL, 0x000fe400078e3cffULL,
0x00013000020d7811ULL, 0x000fe200078e70ffULL, 0x0000000104027824ULL, 0x040fe200078e020bULL,
0x0000003f11117812ULL, 0x000fe400078ec0ffULL, 0xfffffff825367812ULL, 0x000fe200078ee20aULL,
0x00000100ff257424ULL, 0x000fe200078e00ffULL, 0xfffffff8273e7812ULL, 0x000fe200078ee20cULL,
0x0000000807277824ULL, 0x000fe200078e00ffULL, 0x0000003f13137812ULL, 0x000fe200078ec0ffULL,
0x00000001040a7824ULL, 0x040fe200078e020fULL, 0x0000003f15157812ULL, 0x000fe200078ec0ffULL,
0x00000001040c7824ULL, 0x040fe200078e0211ULL, 0x0000003f17177812ULL, 0x000fe200078ec0ffULL,
0x0000000104107824ULL, 0x040fe200078e0213ULL, 0x0000003f1b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104147824ULL, 0x040fe200078e0215ULL, 0x0000003f1d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000104187824ULL, 0x040fe200078e0217ULL, 0x0000003f1f1f7812ULL, 0x000fe200078ec0ffULL,
0x0000000104207824ULL, 0x040fe200078e021bULL, 0x0000003f21217812ULL, 0x000fe200078ec0ffULL,
0x0000000104247824ULL, 0x040fe200078e021dULL, 0x0000003f23237812ULL, 0x000fe200078ec0ffULL,
0x0000000104287824ULL, 0x040fe200078e021fULL, 0x0000003f29297812ULL, 0x000fe200078ec0ffULL,
0x00000001042c7824ULL, 0x040fe200078e0221ULL, 0x0000003f2b2b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104307824ULL, 0x040fe200078e0223ULL, 0x0000003f2d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000104347824ULL, 0x040fe200078e0229ULL, 0x0000003f19197812ULL, 0x000fe200078ec0ffULL,
0x0000000104387824ULL, 0x000fe200078e022bULL, 0x0000003f030b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0025ULL, 0xfffffff840407812ULL, 0x000fc400078ee22fULL,
0x00000019041c7210ULL, 0x040fe20007ffe0ffULL, 0x00000001043c7824ULL, 0x040fe200078e022dULL,
0xfffffff827277812ULL, 0x000fe200078ee206ULL, 0x0000000104047824ULL, 0x000fe200078e020bULL,
0x0000000d08297211ULL, 0x080fe200078e20ffULL, 0x00000010001f7824ULL, 0x100fe200078e020dULL,
0x0000000d363f7211ULL, 0x000fe200078e20ffULL, 0x000000100e2b7824ULL, 0x100fe400078e020dULL,
0x00000010122d7824ULL, 0x100fe400078e020dULL, 0x00000010162f7824ULL, 0x000fc400078e020dULL,
0x000000101a317824ULL, 0x100fe400078e020dULL, 0x000000101e337824ULL, 0x100fe400078e020dULL,
0x0000001022357824ULL, 0x100fe400078e020dULL, 0x0000001026377824ULL, 0x100fe400078e020dULL,
0x000000102a397824ULL, 0x100fe400078e020dULL, 0x000000102e3b7824ULL, 0x000fc400078e020dULL,
0x00000010323d7824ULL, 0x100fe400078e020dULL, 0x000000103a417824ULL, 0x100fe400078e020dULL,
0x000000103e437824ULL, 0x100fe400078e020dULL, 0x0000001040457824ULL, 0x000fe400078e020dULL,
0x00005e000a0a7625ULL, 0x000fc800078e0025ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0025ULL,
0x00005e00100e7625ULL, 0x000fc800078e0025ULL, 0x00005e0014107625ULL, 0x000fc800078e0025ULL,
0x0000001027027825ULL, 0x000fc800078e0002ULL, 0x00005e0018127625ULL, 0x080fe200078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021f7faeULL, 0x0003e6000b901c46ULL,
0x00005e001c147625ULL, 0x000fc800078e0025ULL, 0x00005e0020167625ULL, 0x000fc800078e0025ULL,
0x00000010270a7825ULL, 0x000fc800078e000aULL, 0x00005e0024187625ULL, 0x000fe200078e0025ULL,
0x000000000a297faeULL, 0x0005e6000b901c46ULL, 0x00000010270c7825ULL, 0x000fc800078e000cULL,
0x00005e00281a7625ULL, 0x000fe200078e0025ULL, 0x000000000c2b7faeULL, 0x0005e6000b901c46ULL,
0x00000010270e7825ULL, 0x000fc800078e000eULL, 0x00005e002c1c7625ULL, 0x000fe200078e0025ULL,
0x000000000e2d7faeULL, 0x0005e6000b901c46ULL, 0x0000001027107825ULL, 0x000fc800078e0010ULL,
0x00005e0030027625ULL, 0x002fe200078e0025ULL, 0x00000000102f7faeULL, 0x0005e6000b901c46ULL,
0x0000001027127825ULL, 0x000fc800078e0012ULL, 0x00005e00341e7625ULL, 0x000fe200078e0025ULL,
0x0000000012317faeULL, 0x0005e6000b901c46ULL, 0x0000001027147825ULL, 0x000fc800078e0014ULL,
0x00005e0038207625ULL, 0x000fe200078e0025ULL, 0x0000000014337faeULL, 0x0005e6000b901c46ULL,
0x0000001027167825ULL, 0x000fc800078e0016ULL, 0x00005e003c227625ULL, 0x000fe200078e0025ULL,
0x0000000016357faeULL, 0x0005e6000b901c46ULL, 0x0000001027187825ULL, 0x000fc800078e0018ULL,
0x00005e0004247625ULL, 0x000fe200078e0025ULL, 0x0000000018377faeULL, 0x0005e6000b901c46ULL,
0x00000010271a7825ULL, 0x000fc800078e001aULL, 0x00000010271c7825ULL, 0x040fe200078e001cULL,
0x000000001a397faeULL, 0x0005e6000b901c46ULL, 0x0000001027027825ULL, 0x040fe200078e0002ULL,
0x000000001c3b7faeULL, 0x0005e6000b901c46ULL, 0x00000010271e7825ULL, 0x040fe200078e001eULL,
0x00000000023d7faeULL, 0x0005e6000b901c46ULL, 0x0000001027207825ULL, 0x040fe200078e0020ULL,
0x000000001e3f7faeULL, 0x0005e6000b901c46ULL, 0x0000001027227825ULL, 0x040fe200078e0022ULL,
0x0000000020417faeULL, 0x0005e6000b901c46ULL, 0x0000001027247825ULL, 0x000fe200078e0024ULL,
0x0000000022437faeULL, 0x0005e8000b901c46ULL, 0x0000000024457faeULL, 0x0005e4000b901c46ULL,
0x0000000305007812ULL, 0x000fe200078ec0ffULL, 0x00000300ff047624ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0xfffffffe09047424ULL, 0x000fc600078e0204ULL, 0x000000030000780cULL, 0x000fc80003f04070ULL,
0x0000000204007807ULL, 0x000fca0000000000ULL, 0x0000000105057824ULL, 0x000fca00078e0200ULL,
0x0000008c0500720cULL, 0x000fda0003f06070ULL, 0x0000000288008824ULL, 0x000fe400078e00ffULL,
0x00006400ff038624ULL, 0x006fc800078e00ffULL, 0x0000640000008624ULL, 0x000fe400078e0203ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000000100088824ULL, 0x000fc800078e0205ULL,
0x0000600008088625ULL, 0x000fca00078e0009ULL, 0x0000000608038981ULL, 0x000362000c1e1900ULL,
0x0000008a9100720cULL, 0x000fe20003f06070ULL, 0xff317217ff027424ULL, 0x000fe200078e00ffULL,
0x000000ff00007202ULL, 0x000fe20000000f00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00004a1000000947ULL, 0x000fea0003800000ULL,
0x00000002880a7824ULL, 0x002fe200078e00ffULL, 0x000000026e087810ULL, 0x000fe20007ffe0ffULL,
0x00006400ff0b7624ULL, 0x000fc400078e00ffULL, 0x000000106e097824ULL, 0x000fe400078e00ffULL,
0x000064000a0a7624ULL, 0x000fe200078e020bULL, 0x00007610ff0b7816ULL, 0x000fe2000000000bULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff6a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x000000208f0c7824ULL, 0x000fca00078e00ffULL,
0xffffffc00c0c7812ULL, 0x000fca00078ec0ffULL, 0x0000010091117824ULL, 0x000fca00078e020cULL,
0x0000008e1100720cULL, 0x000fda0003f06070ULL, 0x000048d000000947ULL, 0x000fea0003800000ULL,
0x00000001910f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000008a0f00720cULL, 0x000fe20003f06070ULL, 0x000000ffff0c7224ULL, 0x000fe200078e006aULL,
0x000000016a6a7812ULL, 0x000fd600078e0cffULL, 0x00000b3000008947ULL, 0x000fea0003800000ULL,
0x00000080110f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000807117824ULL, 0x000fe200078e00ffULL,
0x00000007060e7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff187819ULL, 0x000fe40000011606ULL,
0x0000000f8e107217ULL, 0x000fe40007800000ULL, 0x00000008110e7812ULL, 0x000fe400078ee20eULL,
0x0000580000117a02ULL, 0x000fe20000000f00ULL, 0x0000000110147824ULL, 0x000fe200078e0a0fULL,
0x00000008181c7810ULL, 0x000fc40007ffe0ffULL, 0x00000004181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004011107824ULL, 0x000fe200078e00ffULL, 0x000000061c117212ULL, 0x0c0fe200078e3cffULL,
0x000000081c167824ULL, 0x000fe200078e00ffULL, 0x0000001018387810ULL, 0x000fe20007ffe0ffULL,
0x000000081a127824ULL, 0x040fe200078e00ffULL, 0x000000061a0f7212ULL, 0x080fe200078e3cffULL,
0x0000000410157e24ULL, 0x020fe2000f8e0203ULL, 0x00000014183a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8163d7812ULL, 0x000fe200078ee211ULL, 0x0000000838167824ULL, 0x000fe200078e00ffULL,
0xfffffff8123b7812ULL, 0x000fe200078ee20fULL, 0x000000083a497824ULL, 0x000fe200078e00ffULL,
0x00000006380f7212ULL, 0x000fc400078e3cffULL, 0x0000001c183e7810ULL, 0x040fe40007ffe0ffULL,
0x0000002018407810ULL, 0x000fe40007ffe0ffULL, 0x000000063a107212ULL, 0x080fe400078e3cffULL,
0xfffffff816477812ULL, 0x000fe200078ee20fULL, 0x000000083e167824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee210ULL, 0x00000008404f7824ULL, 0x000fe200078e00ffULL,
0x000000063e0f7212ULL, 0x000fc400078e3cffULL, 0x0000002c18467810ULL, 0x000fe40007ffe0ffULL,
0x0000000640107212ULL, 0x000fe400078e3cffULL, 0x0000002418427810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8164d7812ULL, 0x000fe200078ee20fULL, 0x0000000846167824ULL, 0x000fe200078e00ffULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee210ULL, 0x0000003018487810ULL, 0x000fc40007ffe0ffULL,
0x0000000c181e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000642137212ULL, 0x080fe200078e3cffULL,
0x0000000848177824ULL, 0x000fe200078e00ffULL, 0x0000000342107819ULL, 0x000fe200000006ffULL,
0x000000081e127824ULL, 0x000fe200078e00ffULL, 0x0000000646117212ULL, 0x080fe400078e3cffULL,
0xfffffff810137812ULL, 0x000fe400078ee213ULL, 0xfffffff816117812ULL, 0x000fe200078ee211ULL,
0x000040008f167824ULL, 0x000fe200078e00ffULL, 0x0000000648107212ULL, 0x000fc400078e3cffULL,
0x000000061e037212ULL, 0x080fe400078e3cffULL, 0x00000018183c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff817107812ULL, 0x000fe400078ee210ULL, 0xfffffff8123f7812ULL, 0x000fe200078ee203ULL,
0x000000083c127824ULL, 0x000fe200078e00ffULL, 0x0000400016177812ULL, 0x000fe200078ec0ffULL,
0x00000100ff167424ULL, 0x000fe200078e00ffULL, 0x000000063c037212ULL, 0x000fc400078e3cffULL,
0x0000002818447810ULL, 0x000fe20007ffe0ffULL, 0x000080006e197824ULL, 0x000fe200078e0217ULL,
0x00000034184a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8124b7812ULL, 0x000fe200078ee203ULL,
0x0000000844037824ULL, 0x000fe200078e00ffULL, 0x00000007181b7812ULL, 0x000fe200078e4806ULL,
0x000000084a4e7824ULL, 0x000fe200078e00ffULL, 0x00000038184c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000644127212ULL, 0x000fc400078e3cffULL, 0x000000064a0f7212ULL, 0x000fe200078e3cffULL,
0x000000084c507824ULL, 0x000fe200078e00ffULL, 0x0000004014177817ULL, 0x000fe20003800000ULL,
0x000020006a147824ULL, 0x000fe200078e0219ULL, 0x0ffffff81b397812ULL, 0x000fe400078ef806ULL,
0x0000003f15197812ULL, 0x040fe400078ef818ULL, 0x0000003f151b7812ULL, 0x000fe400078ef81aULL,
0xfffffff803127812ULL, 0x000fc400078ee212ULL, 0xfffffff84e0f7812ULL, 0x000fe400078ee20fULL,
0x0000003f151d7812ULL, 0x000fe400078ef81cULL, 0x000000064c037212ULL, 0x000fe400078e3cffULL,
0x0000003c184e7810ULL, 0x040fe40007ffe0ffULL, 0x000000171800720cULL, 0x000fe20003f06070ULL,
0x00005e0019187625ULL, 0x000fe200078e0016ULL, 0x0000003f151f7812ULL, 0x000fc400078ef81eULL,
0x000000171a00720cULL, 0x080fe20003f26070ULL, 0x00005e001b1a7625ULL, 0x080fe200078e0016ULL,
0x000000171c00720cULL, 0x080fe40003f46070ULL, 0x000000171e00720cULL, 0x000fe20003f66070ULL,
0x00005e001d1c7625ULL, 0x000fe200078e0016ULL, 0xfffffff850037812ULL, 0x000fe400078ee203ULL,
0x0001300014147810ULL, 0x000fe20007ffe0ffULL, 0x000000084e507824ULL, 0x040fe200078e00ffULL,
0x000000064e417212ULL, 0x000fe200078e3cffULL, 0x00005e001f1e7625ULL, 0x000fe200078e0016ULL,
0x0000001439397211ULL, 0x000fc400078e20ffULL, 0xfffffff850517812ULL, 0x000fe200078ee241ULL,
0x000000100e187825ULL, 0x040fe200078e0018ULL, 0x0000003f15417812ULL, 0x040fe400078ef838ULL,
0x0000003f15437812ULL, 0x000fe200078ef83aULL, 0x000000103b3b7824ULL, 0x000fe200078e0214ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018397faeULL, 0x0003e2000c101c46ULL,
0x000000100e1a7825ULL, 0x000fe200078e001aULL, 0x0000003f15457812ULL, 0x000fe400078ef83cULL,
0x000000173800720cULL, 0x080fe20003f06070ULL, 0x000000103d3d7824ULL, 0x000fe200078e0214ULL,
0x000000001a3b7faeULL, 0x0005e2000c901c46ULL, 0x000000100e1c7825ULL, 0x000fe200078e001cULL,
0x000000173a00720cULL, 0x000fc40003f26070ULL, 0x000000174000720cULL, 0x080fe20003f86070ULL,
0x000000103f3f7824ULL, 0x000fe200078e0214ULL, 0x0000003f15397812ULL, 0x002fe200078ef83eULL,
0x000000100e1e7825ULL, 0x000fe200078e001eULL, 0x000000001c3d7faeULL, 0x0003e2000d101c46ULL,
0x000000173c00720cULL, 0x080fe40003f46070ULL, 0x00005e0041187625ULL, 0x080fe200078e0016ULL,
0x0000003f153b7812ULL, 0x004fe200078ef840ULL, 0x000000001e3f7faeULL, 0x0005e2000d901c46ULL,
0x000000173e00720cULL, 0x080fe20003f66070ULL, 0x00005e00431a7625ULL, 0x000fe200078e0016ULL,
0x000000174c00720cULL, 0x000fc40003fa6070ULL, 0x000000174e00720cULL, 0x000fe20003fc6070ULL,
0x000000100e187825ULL, 0x000fe200078e0018ULL, 0x0000001411117211ULL, 0x000fc600078e20ffULL,
0x00005e00451c7625ULL, 0x002fe200078e0016ULL, 0x0000003f15457812ULL, 0x000fc600078ef842ULL,
0x00005e00391e7625ULL, 0x004fc800078e0016ULL, 0x00005e003b387625ULL, 0x000fc800078e0016ULL,
0x00000010473b7824ULL, 0x000fe200078e0214ULL, 0x0000003f15477812ULL, 0x000fe200078ef844ULL,
0x00000010493d7824ULL, 0x000fe200078e0214ULL, 0x0000003f15497812ULL, 0x000fe200078ef846ULL,
0x000000100e1a7825ULL, 0x000fe200078e001aULL, 0x00000000183b7faeULL, 0x0003e2000c101c46ULL,
0x000000174200720cULL, 0x080fe40003f06070ULL, 0x000000104b3f7824ULL, 0x000fe200078e0214ULL,
0x000000001a3d7faeULL, 0x0005e2000c901c46ULL, 0x000000100e1c7825ULL, 0x000fe200078e001cULL,
0x000000174400720cULL, 0x000fc60003f26070ULL, 0x000000104d417824ULL, 0x000fe200078e0214ULL,
0x000000001c3f7faeULL, 0x0007e2000d101c46ULL, 0x000000100e1e7825ULL, 0x000fe200078e001eULL,
0x0000003f153b7812ULL, 0x002fe400078ef848ULL, 0x000000174600720cULL, 0x080fe20003f46070ULL,
0x000000104f437824ULL, 0x000fe200078e0214ULL, 0x0000003f153d7812ULL, 0x004fe200078ef84aULL,
0x000000100e387825ULL, 0x000fe200078e0038ULL, 0x000000001e417faeULL, 0x0003e2000d901c46ULL,
0x000000174800720cULL, 0x000fc40003f66070ULL, 0x00005e0045187625ULL, 0x080fe200078e0016ULL,
0x0000003f153f7812ULL, 0x048fe200078ef84cULL, 0x0000000038437faeULL, 0x0005e2000e101c46ULL,
0x0000003f15157812ULL, 0x000fe200078ef84eULL, 0x00005e00471a7625ULL, 0x000fe200078e0016ULL,
0x000000174a00720cULL, 0x000fc60003f86070ULL, 0x00005e00491c7625ULL, 0x000fc800078e0016ULL,
0x00005e003b1e7625ULL, 0x002fc800078e0016ULL, 0x00005e003d387625ULL, 0x004fc800078e0016ULL,
0x00005e003f3a7625ULL, 0x000fc800078e0016ULL, 0x00005e0015167625ULL, 0x000fc800078e0016ULL,
0x000000100e187825ULL, 0x000fc800078e0018ULL, 0x0000001013137824ULL, 0x000fe400078e0214ULL,
0x000000100e1a7825ULL, 0x000fc600078e001aULL, 0x0000000018137faeULL, 0x0003e2000c101c46ULL,
0x0000001012157824ULL, 0x000fe400078e0214ULL, 0x000000100e1c7825ULL, 0x000fc600078e001cULL,
0x000000001a157faeULL, 0x0003e2000c901c46ULL, 0x000000100e1e7825ULL, 0x000fc600078e001eULL,
0x000000001c117faeULL, 0x0003e2000d101c46ULL, 0x00000010103d7824ULL, 0x000fe400078e0214ULL,
0x000000100e387825ULL, 0x000fc600078e0038ULL, 0x000000001e3d7faeULL, 0x0003e2000d901c46ULL,
0x000000100f0f7824ULL, 0x000fe400078e0214ULL, 0x000000100e3a7825ULL, 0x000fc600078e003aULL,
0x00000000380f7faeULL, 0x0003e2000e101c46ULL, 0x0000001003037824ULL, 0x000fe400078e0214ULL,
0x000000100e167825ULL, 0x000fc600078e0016ULL, 0x000000003a037faeULL, 0x0003e2000e901c46ULL,
0x00000010513f7824ULL, 0x000fca00078e0214ULL, 0x00000000163f7faeULL, 0x0003e2000f101c46ULL,
0x000009e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff0f7819ULL, 0x000fe20000011606ULL,
0x0000000807107824ULL, 0x000fe200078e00ffULL, 0x0000000706457812ULL, 0x000fe200078ec0ffULL,
0x00005800ff0e7624ULL, 0x000fe200078e00ffULL, 0x000000100f1b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000810457812ULL, 0x000fe200078ee245ULL, 0x000000400e0e7824ULL, 0x000fe200078e00ffULL,
0x000000061b497212ULL, 0x040fe400078e3cffULL, 0x000000031b107819ULL, 0x000fe200000006ffULL,
0x000000040e0e7e24ULL, 0x020fe2000f8e0203ULL, 0x0000001c0f397810ULL, 0x000fc40007ffe0ffULL,
0x0000000c0f197810ULL, 0x040fe40007ffe0ffULL, 0x000000080f177810ULL, 0x000fe40007ffe0ffULL,
0xfffffff810497812ULL, 0x000fe200078ee249ULL, 0x0000000839107824ULL, 0x040fe200078e00ffULL,
0x00000006394b7212ULL, 0x080fe200078e3cffULL, 0x0000000819117824ULL, 0x000fe200078e00ffULL,
0x000000240f3d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000817037824ULL, 0x000fe200078e00ffULL,
0x0000000619467212ULL, 0x000fc400078e3cffULL, 0x000000180f1f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000617487212ULL, 0x080fe400078e3cffULL, 0x000000140f1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8104b7812ULL, 0x000fe200078ee24bULL, 0x000000083d107824ULL, 0x040fe200078e00ffULL,
0x000000063d437212ULL, 0x000fe400078e3cffULL, 0xfffffff811467812ULL, 0x000fe200078ee246ULL,
0x000000081f117824ULL, 0x000fe200078e00ffULL, 0x000000040f157810ULL, 0x000fc40007ffe0ffULL,
0xfffffff803487812ULL, 0x000fe200078ee248ULL, 0x000000081d037824ULL, 0x000fe200078e00ffULL,
0x000000061f4c7212ULL, 0x080fe200078e3cffULL, 0x0000000815127824ULL, 0x000fe200078e00ffULL,
0x000000280f3f7810ULL, 0x000fe40007ffe0ffULL, 0x000000061d4a7212ULL, 0x080fe400078e3cffULL,
0x000000200f3b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff810437812ULL, 0x000fe200078ee243ULL,
0x000040008f107824ULL, 0x000fe200078e00ffULL, 0xfffffff8114c7812ULL, 0x000fe200078ee24cULL,
0x000000083f117824ULL, 0x000fe200078e00ffULL, 0x0000000615477212ULL, 0x000fc400078e3cffULL,
0xfffffff8034a7812ULL, 0x000fe200078ee24aULL, 0x000000083b037824ULL, 0x000fe200078e00ffULL,
0x0000002c0f4d7810ULL, 0x000fe40007ffe0ffULL, 0x000000063f427212ULL, 0x080fe400078e3cffULL,
0x000000300f4f7810ULL, 0x040fe40007ffe0ffULL, 0x000000340f517810ULL, 0x000fe40007ffe0ffULL,
0x000000063b447212ULL, 0x000fc400078e3cffULL, 0x0000400010137812ULL, 0x000fe200078ec0ffULL,
0x0000000851147824ULL, 0x000fe200078e00ffULL, 0xfffffff812477812ULL, 0x000fe200078ee247ULL,
0x000000084d127824ULL, 0x000fe200078e00ffULL, 0xfffffff811427812ULL, 0x000fe200078ee242ULL,
0x000000084f117824ULL, 0x000fe200078e00ffULL, 0x0000003c0f5d7810ULL, 0x000fe20007ffe0ffULL,
0x000080006e137824ULL, 0x000fe200078e0213ULL, 0xfffffff803447812ULL, 0x000fe400078ee244ULL,
0x000000064d417212ULL, 0x080fe200078e3cffULL, 0x000000085d617824ULL, 0x000fe200078e00ffULL,
0x000000064f407212ULL, 0x080fe200078e3cffULL, 0x000020006a137824ULL, 0x000fe200078e0213ULL,
0x0000000651037212ULL, 0x000fc400078e3cffULL, 0x000000380f537810ULL, 0x000fe40007ffe0ffULL,
0xfffffff812417812ULL, 0x000fe400078ee241ULL, 0xfffffff811407812ULL, 0x000fe200078ee240ULL,
0x00000008535f7824ULL, 0x000fe200078e00ffULL, 0xfffffff814037812ULL, 0x000fe400078ee203ULL,
0x000000065d5e7212ULL, 0x000fe400078e3cffULL, 0x0000003f0e127812ULL, 0x000fc400078ef80fULL,
0x0000010000117802ULL, 0x000fe40000000f00ULL, 0x0000003f0e167812ULL, 0x040fe400078ef815ULL,
0x0000003f0e187812ULL, 0x040fe400078ef817ULL, 0x0000003f0e1a7812ULL, 0x000fe200078ef819ULL,
0x00005e0016167625ULL, 0x080fe200078e0011ULL, 0x0000003f0e1c7812ULL, 0x040fe400078ef81bULL,
0x0000003f0e1e7812ULL, 0x000fe200078ef81dULL, 0x00005e0018187625ULL, 0x000fe200078e0011ULL,
0x0000003f0e387812ULL, 0x000fc400078ef81fULL, 0x0000003f0e3a7812ULL, 0x000fe200078ef839ULL,
0x00005e001a1a7625ULL, 0x080fe200078e0011ULL, 0x0000003f0e3c7812ULL, 0x040fe400078ef83bULL,
0x0000003f0e3e7812ULL, 0x000fe200078ef83dULL, 0x00005e001c1c7625ULL, 0x080fe200078e0011ULL,
0x0000003f0e4e7812ULL, 0x040fe400078ef83fULL, 0x0000003f0e507812ULL, 0x000fe200078ef84dULL,
0x00005e001e1e7625ULL, 0x000fe200078e0011ULL, 0x0000003f0e527812ULL, 0x000fc400078ef84fULL,
0x0000003f0e147812ULL, 0x000fe200078ef851ULL, 0x00005e0038387625ULL, 0x080fe200078e0011ULL,
0x0000003f0e107812ULL, 0x000fe400078ef853ULL, 0x000000070f0f7812ULL, 0x000fe200078e4806ULL,
0x00005e003a3a7625ULL, 0x080fe200078e0011ULL, 0x0000003f0e607812ULL, 0x000fe400078ef85dULL,
0xfffffff8614d7812ULL, 0x000fe200078ee25eULL, 0x00005e003c3c7625ULL, 0x000fe200078e0011ULL,
0x00000006535c7212ULL, 0x000fc400078e3cffULL, 0x0ffffff80f5d7812ULL, 0x000fe200078ef806ULL,
0x00005e003e3e7625ULL, 0x080fe200078e0011ULL, 0x00013000135e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff85f5c7812ULL, 0x000fe200078ee25cULL, 0x00005e0012127625ULL, 0x000fe200078e0011ULL,
0x0000005e4c637211ULL, 0x000fc600078e20ffULL, 0x00005e004e4e7625ULL, 0x000fc800078e0011ULL,
0x00005e0050507625ULL, 0x000fc800078e0011ULL, 0x00005e0052527625ULL, 0x000fc800078e0011ULL,
0x00005e0014147625ULL, 0x000fc800078e0011ULL, 0x00005e00100e7625ULL, 0x000fc800078e0011ULL,
0x00005e0060107625ULL, 0x000fc800078e0011ULL, 0x0000001045127825ULL, 0x000fc800078e0012ULL,
0x000000105d5d7824ULL, 0x000fe400078e025eULL, 0x0000001045167825ULL, 0x000fc600078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000125d7faeULL, 0x0003e2000b901c46ULL,
0x0000001045187825ULL, 0x000fc800078e0018ULL, 0x00000010451a7825ULL, 0x000fc800078e001aULL,
0x00000010451c7825ULL, 0x000fc800078e001cULL, 0x00000010451e7825ULL, 0x000fc800078e001eULL,
0x0000001045387825ULL, 0x000fc800078e0038ULL, 0x00000010453a7825ULL, 0x000fc800078e003aULL,
0x00000010453c7825ULL, 0x000fc800078e003cULL, 0x00000010453e7825ULL, 0x000fc800078e003eULL,
0x00000010454e7825ULL, 0x000fc800078e004eULL, 0x0000001045507825ULL, 0x000fc800078e0050ULL,
0x0000001045527825ULL, 0x000fc800078e0052ULL, 0x0000001045147825ULL, 0x000fc800078e0014ULL,
0x00000010450e7825ULL, 0x000fc800078e000eULL, 0x0000001045107825ULL, 0x000fc800078e0010ULL,
0x0000001047477824ULL, 0x100fe400078e025eULL, 0x0000001048457824ULL, 0x100fe400078e025eULL,
0x00000010465f7824ULL, 0x100fe200078e025eULL, 0x0000000016477faeULL, 0x0003e2000b901c46ULL,
0x0000001049497824ULL, 0x100fe400078e025eULL, 0x000000104a617824ULL, 0x100fe200078e025eULL,
0x0000000018457faeULL, 0x0003e2000b901c46ULL, 0x000000104b4b7824ULL, 0x000fc400078e025eULL,
0x0000001044657824ULL, 0x100fe200078e025eULL, 0x000000001a5f7faeULL, 0x0003e2000b901c46ULL,
0x0000001043437824ULL, 0x100fe400078e025eULL, 0x0000001042677824ULL, 0x100fe200078e025eULL,
0x000000001c497faeULL, 0x0003e2000b901c46ULL, 0x0000001041417824ULL, 0x100fe400078e025eULL,
0x0000001040697824ULL, 0x100fe200078e025eULL, 0x000000001e617faeULL, 0x0003e2000b901c46ULL,
0x0000001003037824ULL, 0x000fc400078e025eULL, 0x000000105c6b7824ULL, 0x100fe200078e025eULL,
0x0000000038637faeULL, 0x0003e2000b901c46ULL, 0x000000104d4d7824ULL, 0x000fc600078e025eULL,
0x000000003a4b7faeULL, 0x0003e8000b901c46ULL, 0x000000003c657faeULL, 0x0003e8000b901c46ULL,
0x000000003e437faeULL, 0x0003e8000b901c46ULL, 0x000000004e677faeULL, 0x0003e8000b901c46ULL,
0x0000000050417faeULL, 0x0003e8000b901c46ULL, 0x0000000052697faeULL, 0x0003e8000b901c46ULL,
0x0000000014037faeULL, 0x0003e8000b901c46ULL, 0x000000000e6b7faeULL, 0x0003e8000b901c46ULL,
0x00000000104d7faeULL, 0x0003e4000b901c46ULL, 0x0000000305037812ULL, 0x002fe200078ec0ffULL,
0x02360c0009127984ULL, 0x000e660000000800ULL, 0x0000000203037810ULL, 0x000fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030300780cULL, 0x000fe20003f04070ULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x00000002040e7807ULL, 0x000fca0000000000ULL,
0x0000000105057824ULL, 0x000fca00078e020eULL, 0x0000008c0500720cULL, 0x000fda0003f06070ULL,
0x000000050a0e8210ULL, 0x000fe20007ffe0ffULL, 0x00000004ff0f8424ULL, 0x000fc800078e00ffULL,
0x000060000e0e8625ULL, 0x000fca00078e000fULL, 0x000000060e038981ULL, 0x000562000c1e1900ULL,
0x0000ffff0b107812ULL, 0x000fc800078ec0ffULL, 0x0000888010107816ULL, 0x000fca00000000ffULL,
0x8000000010117824ULL, 0x000fca00078e00ffULL, 0x8000000012ff7812ULL, 0x002fe20007804811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x004fea0003800000ULL,
0x8000000010107824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e000f7305ULL, 0x0002a4000021f000ULL, 0x3fa000000e0e7823ULL, 0x002fe200000100ffULL,
0x0000000f0000735dULL, 0x004fe40003800000ULL, 0x02360c00090f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007804810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000010060f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fc80000011606ULL, 0x000000700f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc600078ec0ffULL, 0x000000806e0f7824ULL, 0x000fc800078e020fULL,
0x000000010f0e7824ULL, 0x000fca00078e020eULL, 0x023000000e0f7984ULL, 0x000e680000000800ULL,
0x023200000e6d7984ULL, 0x0004e20000000800ULL, 0x000000020f00720bULL, 0x002fda0003f1d000ULL,
0x0000000000107806ULL, 0x000fc800000e0100ULL, 0x0000ffff10127812ULL, 0x000fe2000780c0ffULL,
0x00000001ff107424ULL, 0x000fd800078e00ffULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x0000000f02157209ULL, 0x00cfe40007810000ULL, 0x000000020f00720bULL, 0x000fe40003f34000ULL,
0x0000008f6e00720cULL, 0x000fe20003f05270ULL, 0x8000001502027221ULL, 0x000fe20000010000ULL,
0x00000002ff107819ULL, 0x000fc60000011606ULL, 0x3fb8aa3b020e7820ULL, 0x000fe20000410000ULL,
0x0000000810117810ULL, 0x000fc60007ffe0ffULL, 0x0000000e00177308ULL, 0x0002a40000000800ULL,
0x0000000000027806ULL, 0x000fc800008e0100ULL, 0x0000ffff02137812ULL, 0x000fe200078e3cffULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x002fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c02197812ULL, 0x000fe400078ec0ffULL, 0x0000000e8f027211ULL, 0x000fca00078e38ffULL,
0x0000000119027824ULL, 0x000fca00078e0202ULL, 0x0234001502007388ULL, 0x0003e40000000800ULL,
0x0000001312ff7212ULL, 0x000fe2000780c0ffULL, 0x00001f1017107589ULL, 0x004ea200000e0000ULL,
0x0000001700007220ULL, 0x000fe40000410000ULL, 0x00000001ff0e7807ULL, 0x002fe20000000000ULL,
0x00001f1117117589ULL, 0x000e6200000e0000ULL, 0x000000ffff027224ULL, 0x000fce00078e0015ULL,
0x800000150f0f0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f000d0308ULL, 0x000ee20000000800ULL, 0x0000001035357220ULL, 0x084fe40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001020207220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x000fc40000410000ULL, 0x0000001029297220ULL, 0x080fe40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x000fc40000410000ULL, 0x0000001055557220ULL, 0x080fe40000410000ULL,
0x0000001054547220ULL, 0x080fe40000410000ULL, 0x0000001059597220ULL, 0x080fe40000410000ULL,
0x0000001058587220ULL, 0x000fe20000410000ULL, 0x000076100e107816ULL, 0x000fe20000000010ULL,
0x0000001137377220ULL, 0x082fe40000410000ULL, 0x0000001136367220ULL, 0x000fc40000410000ULL,
0x0000001123237220ULL, 0x080fe40000410000ULL, 0x0000001122227220ULL, 0x080fe40000410000ULL,
0x0000001127277220ULL, 0x080fe40000410000ULL, 0x0000001126267220ULL, 0x080fe40000410000ULL,
0x000000112b2b7220ULL, 0x080fe40000410000ULL, 0x000000112a2a7220ULL, 0x000fc40000410000ULL,
0x000000112f2f7220ULL, 0x080fe40000410000ULL, 0x000000112e2e7220ULL, 0x080fe40000410000ULL,
0x0000001133337220ULL, 0x080fe40000410000ULL, 0x0000001132327220ULL, 0x080fe40000410000ULL,
0x0000001157577220ULL, 0x080fe40000410000ULL, 0x0000001156567220ULL, 0x000fc40000410000ULL,
0x000000115b5b7220ULL, 0x080fe40000410000ULL, 0x000000115a5a7220ULL, 0x000fe40000410000ULL,
0x0000000d6d6d0220ULL, 0x008fe40000410000ULL, 0x0000000706137812ULL, 0x00cfe200078ec0ffULL,
0x000000026e417824ULL, 0x000fe200078e0207ULL, 0x00000004ff0f7819ULL, 0x000fe20000011606ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000813427812ULL, 0x000fe200078ef806ULL,
0x0000000241417824ULL, 0x000fe200078e020cULL, 0x0000000806407812ULL, 0x000fe400078ec0ffULL,
0x000000070f117812ULL, 0x000fe400078e7842ULL, 0x0000000740187812ULL, 0x040fe400078ec813ULL,
0x0000001340407212ULL, 0x000fe200078efcffULL, 0x0000000842117824ULL, 0x000fe200078e0211ULL,
0x0000000f185f7212ULL, 0x000fc400078e3cffULL, 0x000000020f397810ULL, 0x000fe20007ffe0ffULL,
0x0000001011697824ULL, 0x000fe200078e00ffULL, 0x0001300041417811ULL, 0x000fe200078e68ffULL,
0x0000000840687824ULL, 0x000fe200078e025fULL, 0x00000039185e7212ULL, 0x000fe200078e3cffULL,
0x000008006e147824ULL, 0x000fe200078e0269ULL, 0x0000000dff0e723eULL, 0x000fe200000010ffULL,
0x00000010681c7824ULL, 0x000fe200078e0241ULL, 0x00000002ff6b7819ULL, 0x000fe20000011606ULL,
0x0000000840677824ULL, 0x000fe200078e025eULL, 0x000054100e1a7816ULL, 0x000fe2000000000eULL,
0x011000001414783bULL, 0x000fe20000000200ULL, 0x00009910100e7816ULL, 0x000fc400000000ffULL,
0x0000004167107211ULL, 0x000fe200078e20ffULL, 0x000000001c1c783bULL, 0x000fe20000004200ULL,
0x000000086b1b7810ULL, 0x000fe40007ffe0ffULL, 0x000000040f197810ULL, 0x040fe20007ffe0ffULL,
0x00001f6b1a6b7589ULL, 0x000e6200000e0000ULL, 0x000000ff0e00720cULL, 0x000fe40003f05270ULL,
0x00000019185c7212ULL, 0x000fe200078e3cffULL, 0x000000001010783bULL, 0x000fe20000004200ULL,
0x000000060f5d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000739397812ULL, 0x000fe200078e7842ULL,
0x00001f1b1a6c7589ULL, 0x000ea200000e0000ULL, 0x0000000840667824ULL, 0x000fe200078e025cULL,
0x0000005d185d7212ULL, 0x000fe400078e3cffULL, 0x0000000842397824ULL, 0x000fe200078e0239ULL,
0x0000008040607811ULL, 0x000fe200078e18ffULL, 0x0000001066197824ULL, 0x000fe200078e0241ULL,
0x00000004060f7811ULL, 0x000fe200078fe0ffULL, 0x0000000840647824ULL, 0x000fe400078e025dULL,
0x0000001039657824ULL, 0x000fe200078e00ffULL, 0x000000070f0f7812ULL, 0x000fe200078e7842ULL,
0x000000001918783bULL, 0x000ee20000004200ULL, 0x0000001064387824ULL, 0x000fc400078e0241ULL,
0x000000015e627824ULL, 0x100fe400078e0260ULL, 0x000000015c617824ULL, 0x100fe400078e0260ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x000000015f637824ULL, 0x100fe400078e0260ULL,
0x000000015d607824ULL, 0x000fe200078e0260ULL, 0x0000006b14148231ULL, 0x082fe200003400ffULL,
0x00000010633c7824ULL, 0x000fe200078e0241ULL, 0x0000006b16168231ULL, 0x000fe200003400ffULL,
0x00000008420f7824ULL, 0x000fe200078e020fULL, 0x0000006c15158231ULL, 0x004fc400003400ffULL,
0x0000006c17178231ULL, 0x000fe200003400ffULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x000000100f0f7824ULL, 0x000fc800078e00ffULL, 0x000008006e447824ULL, 0x040fe200078e020fULL,
0x0000001c1458723cULL, 0x040fea0000041858ULL, 0x011000004444783bULL, 0x000e640000000200ULL,
0x000008006e1c7824ULL, 0x000fe200078e0265ULL, 0x0000001e1454723cULL, 0x040fea0000041854ULL,
0x011000001c1c783bULL, 0x000ea60000000200ULL, 0x000000101430723cULL, 0x040fee0000041830ULL,
0x0000004162107211ULL, 0x000fe200078e20ffULL, 0x00000012142c723cULL, 0x040fea000004182cULL,
0x000000001010783bULL, 0x000f260000004200ULL, 0x000000181428723cULL, 0x048fee0000041828ULL,
0x0000001061187824ULL, 0x000fe200078e0241ULL, 0x0000001a1424723cULL, 0x000fea0000041824ULL,
0x000000001818783bULL, 0x000ee20000004200ULL, 0x0000006b44448231ULL, 0x002fc400003400ffULL,
0x000000381420723cULL, 0x040fe20000041820ULL, 0x0000006b46468231ULL, 0x080fe400003400ffULL,
0x0000006c45458231ULL, 0x080fe400003400ffULL, 0x0000006b1c1c8231ULL, 0x084fe400003400ffULL,
0x0000001060387824ULL, 0x000fe200078e0241ULL, 0x0000003a1434723cULL, 0x000fe20000041834ULL,
0x0000006b1e1e8231ULL, 0x000fe400003400ffULL, 0x0000006c1d1d8231ULL, 0x000fc400003400ffULL,
0x0000006c1f1f8231ULL, 0x080fe200003400ffULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000006c47478231ULL, 0x000fca00003400ffULL, 0x0000003c1c58723cULL, 0x040ff00000041858ULL,
0x000000101c30723cULL, 0x050fee0000041830ULL, 0x0000000606117811ULL, 0x000fe200078fe0ffULL,
0x000000121c2c723cULL, 0x040fee000004182cULL, 0x0000010040127811ULL, 0x000fe200078e18ffULL,
0x000000181c28723cULL, 0x008fe20000041828ULL, 0x0000000711137812ULL, 0x000fc400078e7842ULL,
0x0000018040407811ULL, 0x000fe200078e18ffULL, 0x000000015f0e7824ULL, 0x100fe400078e0212ULL,
0x000000015e107824ULL, 0x100fe400078e0212ULL, 0x000000015c117824ULL, 0x100fe200078e0212ULL,
0x000000410e147211ULL, 0x000fe200078e20ffULL, 0x000000015d127824ULL, 0x040fe200078e0212ULL,
0x000000405d5d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001010507824ULL, 0x100fe200078e0241ULL,
0x0000003e1c54723cULL, 0x000fe20000041854ULL, 0x0000001012487824ULL, 0x100fe200078e0241ULL,
0x000000001414783bULL, 0x000ea20000004200ULL, 0x00000010114c7824ULL, 0x000fc400078e0241ULL,
0x0000000842137824ULL, 0x000fe200078e0213ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x000000015f5f7824ULL, 0x100fe200078e0240ULL, 0x0000001a1c24723cULL, 0x040fe20000041824ULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0x000000004848783bULL, 0x000ee20000004200ULL,
0x000000015e5e7824ULL, 0x100fe400078e0240ULL, 0x000008006e187824ULL, 0x000fe200078e0213ULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x000000015c5c7824ULL, 0x000fe200078e0240ULL,
0x000000381c20723cULL, 0x002fe20000041820ULL, 0x000000105f407824ULL, 0x000fc400078e0241ULL,
0x011000001818783bULL, 0x000e620000000200ULL, 0x000000105e3c7824ULL, 0x100fe400078e0241ULL,
0x000000105d6e7824ULL, 0x100fe400078e0241ULL, 0x0000003a1c1c723cULL, 0x000fe20000041834ULL,
0x000000105c387824ULL, 0x000fe200078e0241ULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000006e34783bULL, 0x0008680000004200ULL, 0x000000004040783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x00000001ff6e7819ULL, 0x010fe2000001168fULL,
0x000000144458723cULL, 0x044fee0000041858ULL, 0x000236106e147811ULL, 0x000fe200078e20ffULL,
0x000000484420723cULL, 0x048ff00000041820ULL, 0x000000164454723cULL, 0x000fe20000041854ULL,
0x0000006b18188231ULL, 0x002fc400003400ffULL, 0x0000006b1a1a8231ULL, 0x000fe400003400ffULL,
0x0000006c19198231ULL, 0x080fe400003400ffULL, 0x0000006c1b1b8231ULL, 0x000fe200003400ffULL,
0x000000504430723cULL, 0x040ff00000041830ULL, 0x00000052442c723cULL, 0x040ff0000004182cULL,
0x0000004c4428723cULL, 0x040ff00000041828ULL, 0x0000004e4424723cULL, 0x040ff00000041824ULL,
0x0000004a441c723cULL, 0x000ff0000004181cULL, 0x000000341820723cULL, 0x040ff00000041820ULL,
0x000000401858723cULL, 0x040ff00000041858ULL, 0x000000421854723cULL, 0x040ff00000041854ULL,
0x0000003c1830723cULL, 0x040ff00000041830ULL, 0x0000003e182c723cULL, 0x040ff0000004182cULL,
0x000000381828723cULL, 0x040ff00000041828ULL, 0x0000003a1824723cULL, 0x040ff00000041824ULL,
0x000000361834723cULL, 0x000fe2000004181cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000000491157824ULL, 0x000fe200078e026eULL, 0x0000000014ff7f8cULL, 0x0003e2000c80043fULL,
0x000000006d007221ULL, 0x000fc60000010000ULL, 0x0000008015157811ULL, 0x000fc800078e30ffULL,
0x0000008e1500720cULL, 0x000fda0003f06070ULL, 0x0000231000000947ULL, 0x000fea0003800000ULL,
0x0000030091147a10ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000114157810ULL, 0x000fc80007ffe0ffULL, 0x0000008a1500720cULL, 0x000fda0003f06070ULL,
0x00000b6000008947ULL, 0x000fea0003800000ULL, 0x000000208f157824ULL, 0x040fe200078e00ffULL,
0x00000003ff177819ULL, 0x000fe20000011606ULL, 0x000040008f187824ULL, 0x000fe200078e00ffULL,
0x00000007061b7812ULL, 0x000fe200078ec0ffULL, 0x0000000807167824ULL, 0x000fe200078e00ffULL,
0xffffffc015157812ULL, 0x000fe200078ec0ffULL, 0x00000100ff397424ULL, 0x000fe200078e00ffULL,
0x0000400018197812ULL, 0x000fe400078ec0ffULL, 0x00000004171f7810ULL, 0x000fe20007ffe0ffULL,
0x0000010014157824ULL, 0x000fe200078e0215ULL, 0x0000000d0c147819ULL, 0x000fe200000006ffULL,
0x000080006e197824ULL, 0x000fe200078e0219ULL, 0x00000008161b7812ULL, 0x000fe200078ee21bULL,
0x00005800ff167624ULL, 0x000fe200078e00ffULL, 0x0000200014147812ULL, 0x000fe200078ec0ffULL,
0x000000081f517824ULL, 0x000fe200078e00ffULL, 0x0000000c173b7810ULL, 0x000fe20007ffe0ffULL,
0x0000004016167824ULL, 0x000fe200078e00ffULL, 0x0001300019407810ULL, 0x000fc40007ffe014ULL,
0x000000061f187212ULL, 0x080fe200078e3cffULL, 0x000000083b6b7824ULL, 0x000fe200078e00ffULL,
0x0000000817197810ULL, 0x040fe20007ffe0ffULL, 0x00000004163f7e24ULL, 0x020fe2000f8e0203ULL,
0x00000018174b7810ULL, 0x040fe40007ffe0ffULL, 0x00000010171d7810ULL, 0x000fe40007ffe0ffULL,
0x000000063b147212ULL, 0x080fe200078e3cffULL, 0x000000084b717824ULL, 0x000fe200078e00ffULL,
0xfffffff851517812ULL, 0x000fe200078ee218ULL, 0x0000000819187824ULL, 0x040fe200078e00ffULL,
0x0000000619037212ULL, 0x000fe200078e3cffULL, 0x000000081d6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee214ULL, 0x0000001051517824ULL, 0x000fe200078e0240ULL,
0x00000014173d7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c17497810ULL, 0x000fe20007ffe0ffULL,
0x000000106b6b7824ULL, 0x000fe200078e0240ULL, 0x000000064b147212ULL, 0x080fe400078e3cffULL,
0x000000061d167212ULL, 0x000fe200078e3cffULL, 0x0000000849737824ULL, 0x000fe200078e00ffULL,
0x0000002417427810ULL, 0x000fe40007ffe0ffULL, 0xfffffff818537812ULL, 0x000fe200078ee203ULL,
0x000000083d187824ULL, 0x000fe200078e00ffULL, 0xfffffff871717812ULL, 0x000fc400078ee214ULL,
0x0000003017447810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee216ULL,
0x0000001071717824ULL, 0x100fe200078e0240ULL, 0x000000063d037212ULL, 0x080fe200078e3cffULL,
0x00000008447d7824ULL, 0x000fe200078e00ffULL, 0x00000020174d7810ULL, 0x000fe20007ffe0ffULL,
0x000000106d6d7824ULL, 0x000fe200078e0240ULL, 0x0000002817417810ULL, 0x000fe40007ffe0ffULL,
0x0000000642147212ULL, 0x000fc400078e3cffULL, 0x0000000342777819ULL, 0x000fe200000006ffULL,
0x0000000841797824ULL, 0x000fe200078e00ffULL, 0x0000000649167212ULL, 0x000fe400078e3cffULL,
0xfffffff8186f7812ULL, 0x000fe200078ee203ULL, 0x000000084d187824ULL, 0x000fe200078e00ffULL,
0xfffffff877777812ULL, 0x000fe400078ee214ULL, 0xfffffff873737812ULL, 0x000fe200078ee216ULL,
0x000000106f6f7824ULL, 0x000fe200078e0240ULL, 0x0000003417457810ULL, 0x000fc40007ffe0ffULL,
0x0000000644147212ULL, 0x080fe200078e3cffULL, 0x0000001073737824ULL, 0x000fe200078e0240ULL,
0x000000064d037212ULL, 0x080fe200078e3cffULL, 0x00000008457f7824ULL, 0x000fe200078e00ffULL,
0x0000000641167212ULL, 0x000fe400078e3cffULL, 0x0000002c17437810ULL, 0x000fe40007ffe0ffULL,
0xfffffff87d7d7812ULL, 0x000fe400078ee214ULL, 0xfffffff818757812ULL, 0x000fe200078ee203ULL,
0x0000000843187824ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fc400078ee216ULL,
0x000000158e147217ULL, 0x000fe20007800000ULL, 0x0000001075757824ULL, 0x100fe200078e0240ULL,
0x0000000645167212ULL, 0x080fe200078e3cffULL, 0x00000010791a7824ULL, 0x000fe200078e0240ULL,
0x0000003817467810ULL, 0x000fe20007ffe0ffULL, 0x0000000114147824ULL, 0x000fe200078e0a15ULL,
0x0000000643037212ULL, 0x080fe400078e3cffULL, 0x0000003c17477810ULL, 0x000fe40007ffe0ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee216ULL, 0x0000000846167824ULL, 0x000fe200078e00ffULL,
0xfffffff8187b7812ULL, 0x000fe200078ee203ULL, 0x0000000847187824ULL, 0x000fe200078e00ffULL,
0x0000000646037212ULL, 0x000fc400078e3cffULL, 0x0000000647157212ULL, 0x000fe200078e3cffULL,
0x000000107b1e7824ULL, 0x100fe200078e0240ULL, 0x0000004014487817ULL, 0x000fe40003800000ULL,
0xfffffff816817812ULL, 0x000fe400078ee203ULL, 0x0000003f3f147812ULL, 0x000fe400078ef817ULL,
0xfffffff818837812ULL, 0x000fe200078ee215ULL, 0x00000010813e7824ULL, 0x000fe200078e0240ULL,
0x0000003f3f167812ULL, 0x000fe200078ef81fULL, 0x00005e0014147625ULL, 0x000fe200078e0039ULL,
0x0000000717037812ULL, 0x000fc400078e4806ULL, 0x0000003f3f187812ULL, 0x000fe400078ef819ULL,
0x000000481700720cULL, 0x080fe20003f06070ULL, 0x00005e0016167625ULL, 0x080fe200078e0039ULL,
0x000000481f00720cULL, 0x080fe40003f26070ULL, 0x000000481900720cULL, 0x000fe20003f46070ULL,
0x00005e0018187625ULL, 0x000fe200078e0039ULL, 0x0ffffff803037812ULL, 0x000fe400078ef806ULL,
0x0000004053537211ULL, 0x000fe200078e20ffULL, 0x000000101b147825ULL, 0x000fe200078e0014ULL,
0x0000003f3f3c7812ULL, 0x000fc400078ef83bULL, 0x0000003f3f1c7812ULL, 0x000fe200078ef81dULL,
0x00000010034f7824ULL, 0x000fe200078e0240ULL, 0x0000003f3f3a7812ULL, 0x000fe200078ef83dULL,
0x000000101b167825ULL, 0x000fe200078e0016ULL, 0x0000003f3f4a7812ULL, 0x000fe400078ef84bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000144f7faeULL, 0x0003e2000c101c46ULL,
0x000000101b187825ULL, 0x000fe200078e0018ULL, 0x000000483b00720cULL, 0x080fe40003f06070ULL,
0x0000000016517faeULL, 0x0005e2000c901c46ULL, 0x000000481d00720cULL, 0x080fe20003f26070ULL,
0x00005e001c1c7625ULL, 0x080fe200078e0039ULL, 0x000000484b00720cULL, 0x080fe20003f66070ULL,
0x0000000018537faeULL, 0x0007e2000d101c46ULL, 0x000000483d00720cULL, 0x080fe20003f46070ULL,
0x00005e003c3c7625ULL, 0x000fe200078e0039ULL, 0x000000484900720cULL, 0x000fc40003f86070ULL,
0x0000003f3f147812ULL, 0x002fe200078ef84dULL, 0x00005e003a3a7625ULL, 0x080fe200078e0039ULL,
0x000000484d00720cULL, 0x080fe40003fa6070ULL, 0x0000003f3f167812ULL, 0x004fe200078ef849ULL,
0x00005e0014147625ULL, 0x080fe200078e0039ULL, 0x000000484700720cULL, 0x000fe40003fc6070ULL,
0x000000407f387211ULL, 0x000fe200078e20ffULL, 0x00005e004a187625ULL, 0x008fe200078e0039ULL,
0x0000003f3f4a7812ULL, 0x000fc600078ef843ULL, 0x00005e0016167625ULL, 0x000fc800078e0039ULL,
0x000000101b3c7825ULL, 0x000fc800078e003cULL, 0x000000101b1c7825ULL, 0x040fe200078e001cULL,
0x000000003c6b7faeULL, 0x0003e2000c101c46ULL, 0x000000484200720cULL, 0x080fe40003f06070ULL,
0x000000101b3a7825ULL, 0x000fe200078e003aULL, 0x000000001c6d7faeULL, 0x0005e2000c901c46ULL,
0x0000003f3f427812ULL, 0x000fe400078ef842ULL, 0x000000101b187825ULL, 0x000fe200078e0018ULL,
0x000000003a6f7faeULL, 0x0007e2000d101c46ULL, 0x000000484100720cULL, 0x000fc40003f26070ULL,
0x000000101b167825ULL, 0x000fe200078e0016ULL, 0x0000000018717faeULL, 0x0009e2000d901c46ULL,
0x0000003f3f3c7812ULL, 0x002fe400078ef841ULL, 0x000000101b147825ULL, 0x000fe200078e0014ULL,
0x0000000016737faeULL, 0x0003e2000e101c46ULL, 0x0000003f3f1c7812ULL, 0x004fe400078ef844ULL,
0x000000484300720cULL, 0x080fe20003f46070ULL, 0x0000000014757faeULL, 0x0005e2000e901c46ULL,
0x0000003f3f3a7812ULL, 0x008fe200078ef845ULL, 0x00005e001c1c7625ULL, 0x000fe200078e0039ULL,
0x000000484600720cULL, 0x000fc40003fa6070ULL, 0x000000484400720cULL, 0x080fe20003f66070ULL,
0x00005e004a187625ULL, 0x090fe200078e0039ULL, 0x0000003f3f467812ULL, 0x040fe400078ef846ULL,
0x0000003f3f447812ULL, 0x000fe200078ef847ULL, 0x00005e003c167625ULL, 0x002fe200078e0039ULL,
0x000000484500720cULL, 0x000fc60003f86070ULL, 0x00005e0042147625ULL, 0x004fc800078e0039ULL,
0x00005e003a3a7625ULL, 0x000fc800078e0039ULL, 0x00005e00463c7625ULL, 0x000fc800078e0039ULL,
0x0000001077037824ULL, 0x000fe400078e0240ULL, 0x00005e0044427625ULL, 0x000fc800078e0039ULL,
0x000000101b147825ULL, 0x000fc800078e0014ULL, 0x000000101b167825ULL, 0x040fe200078e0016ULL,
0x0000000014037faeULL, 0x0003e6000c101c46ULL, 0x000000101b187825ULL, 0x000fe200078e0018ULL,
0x00000000161a7faeULL, 0x0003e6000c901c46ULL, 0x000000107d1f7824ULL, 0x000fe200078e0240ULL,
0x00000000181e7faeULL, 0x0003e2000d101c46ULL, 0x000000101b1c7825ULL, 0x000fc800078e001cULL,
0x000000101b3a7825ULL, 0x040fe200078e003aULL, 0x000000001c1f7faeULL, 0x0003e6000d901c46ULL,
0x000000101b3c7825ULL, 0x000fe200078e003cULL, 0x000000003a387faeULL, 0x0003e6000e101c46ULL,
0x0000001083407824ULL, 0x000fe200078e0240ULL, 0x000000003c3e7faeULL, 0x0003e2000e901c46ULL,
0x000000101b427825ULL, 0x000fca00078e0042ULL, 0x0000000042407faeULL, 0x0003e2000f101c46ULL,
0x000009f000007947ULL, 0x000fea0003800000ULL, 0x0000000807147824ULL, 0x000fe200078e00ffULL,
0x00000007064d7812ULL, 0x000fe200078ec0ffULL, 0x000040008f177824ULL, 0x000fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe20000011606ULL, 0x00005800ff167624ULL, 0x000fe200078e00ffULL,
0x00000008144d7812ULL, 0x000fe200078ee24dULL, 0x000020000c147824ULL, 0x000fe200078e00ffULL,
0x0000400017177812ULL, 0x000fe200078ec0ffULL, 0x0000004016167824ULL, 0x000fe200078e00ffULL,
0x0000000415197810ULL, 0x000fc40007ffe0ffULL, 0x0000200014147812ULL, 0x000fe200078ec0ffULL,
0x000080006e177824ULL, 0x000fe200078e0217ULL, 0x0000000619187212ULL, 0x040fe200078e3cffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0x00000010151d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000416167e24ULL, 0x020fe2000f8e0203ULL, 0x0001300017817810ULL, 0x000fe40007ffe014ULL,
0x0000000815177810ULL, 0x000fe20007ffe0ffULL, 0x000000081d3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b187812ULL, 0x000fc400078ee218ULL, 0x0000000c151b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008171a7824ULL, 0x000fe200078e00ffULL, 0x0000001415397810ULL, 0x000fe40007ffe0ffULL,
0x0000000617037212ULL, 0x080fe400078e3cffULL, 0x000000061d1e7212ULL, 0x080fe200078e3cffULL,
0x0000000839387824ULL, 0x000fe200078e00ffULL, 0x00000018153d7810ULL, 0x000fe40007ffe0ffULL,
0x000000061b147212ULL, 0x000fc400078e3cffULL, 0x000000031b1f7819ULL, 0x000fe400000006ffULL,
0x0000001c15417810ULL, 0x040fe40007ffe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee203ULL,
0x0000002015457810ULL, 0x000fe20007ffe0ffULL, 0x00000008413c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b1e7812ULL, 0x000fe200078ee21eULL, 0x000000083d3b7824ULL, 0x000fe200078e00ffULL,
0x0000000639037212ULL, 0x000fe200078e3cffULL, 0x00000008453e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1c7812ULL, 0x000fc400078ee214ULL, 0x000000063d147212ULL, 0x080fe400078e3cffULL,
0x00000024154f7810ULL, 0x040fe40007ffe0ffULL, 0x0000002815517810ULL, 0x000fe40007ffe0ffULL,
0x00000006411f7212ULL, 0x000fe400078e3cffULL, 0xfffffff838387812ULL, 0x000fe200078ee203ULL,
0x0000000851427824ULL, 0x000fe200078e00ffULL, 0x0000002c15537810ULL, 0x000fc40007ffe0ffULL,
0x0000000645037212ULL, 0x080fe400078e3cffULL, 0xfffffff83b3a7812ULL, 0x000fe200078ee214ULL,
0x000000084f3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee21fULL,
0x0000000853447824ULL, 0x000fe200078e00ffULL, 0x000000064f147212ULL, 0x000fe400078e3cffULL,
0x00000030156b7810ULL, 0x040fe40007ffe0ffULL, 0x00000034156d7810ULL, 0x000fc40007ffe0ffULL,
0x00000006511f7212ULL, 0x080fe400078e3cffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee203ULL,
0x000000086d487824ULL, 0x000fe200078e00ffULL, 0x0000000653037212ULL, 0x080fe400078e3cffULL,
0xfffffff83b407812ULL, 0x000fe200078ee214ULL, 0x000000086b3b7824ULL, 0x040fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe400078ee21fULL, 0x000000066b147212ULL, 0x000fc400078e3cffULL,
0x000000066d1f7212ULL, 0x000fe200078e3cffULL, 0x0000001042777824ULL, 0x000fe200078e0281ULL,
0xfffffff844447812ULL, 0x000fe400078ee203ULL, 0x0000000715037812ULL, 0x040fe400078e4806ULL,
0x00000038156f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001044797824ULL, 0x000fe200078e0281ULL,
0x0000003c15717810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83b467812ULL, 0x000fc400078ee214ULL,
0xfffffff848487812ULL, 0x000fe200078ee21fULL, 0x0000000871757824ULL, 0x000fe200078e00ffULL,
0x0000003f161f7812ULL, 0x000fe200078ef817ULL, 0x00000010467b7824ULL, 0x000fe200078e0281ULL,
0x0000003f163b7812ULL, 0x000fe200078ef81bULL, 0x00000010487d7824ULL, 0x000fe200078e0281ULL,
0x0000003f163f7812ULL, 0x040fe400078ef81dULL, 0x0000003f16437812ULL, 0x040fe400078ef839ULL,
0x0000003f16477812ULL, 0x000fc400078ef83dULL, 0x0000003f164b7812ULL, 0x040fe400078ef841ULL,
0x0000003f16497812ULL, 0x040fe400078ef845ULL, 0x0ffffff803147812ULL, 0x000fe400078ef806ULL,
0x0000003f16157812ULL, 0x040fe400078ef815ULL, 0x0000003f16197812ULL, 0x000fe200078ef819ULL,
0x0000001014037824ULL, 0x000fe200078e0281ULL, 0x0000003f16457812ULL, 0x000fe200078ef84fULL,
0x00000010184f7824ULL, 0x000fe200078e0281ULL, 0x0000003f16417812ULL, 0x000fe200078ef851ULL,
0x000000101a517824ULL, 0x000fe200078e0281ULL, 0x0000003f163d7812ULL, 0x000fe200078ef853ULL,
0x000000101c537824ULL, 0x000fe200078e0281ULL, 0x0000003f16397812ULL, 0x000fe200078ef86bULL,
0x000000101e6b7824ULL, 0x000fe200078e0281ULL, 0x0000003f161d7812ULL, 0x000fe200078ef86dULL,
0x00000010386d7824ULL, 0x000fe200078e0281ULL, 0x0000003f161b7812ULL, 0x000fc400078ef86fULL,
0x0000003f16177812ULL, 0x000fe200078ef871ULL, 0x00000100ff167424ULL, 0x000fe200078e00ffULL,
0x000000066f4a7212ULL, 0x040fe400078e3cffULL, 0x000000036f737819ULL, 0x000fe200000006ffULL,
0x00005e0015147625ULL, 0x000fe200078e0016ULL, 0x00000006714c7212ULL, 0x000fe400078e3cffULL,
0xfffffff8734a7812ULL, 0x000fe200078ee24aULL, 0x00005e0019187625ULL, 0x000fe200078e0016ULL,
0x000000813e737211ULL, 0x000fc400078e20ffULL, 0xfffffff8754c7812ULL, 0x000fe200078ee24cULL,
0x000000103a6f7824ULL, 0x000fe400078e0281ULL, 0x00005e001f1e7625ULL, 0x000fc800078e0016ULL,
0x00005e003b3a7625ULL, 0x000fc800078e0016ULL, 0x00005e003f3e7625ULL, 0x000fc800078e0016ULL,
0x00005e0043427625ULL, 0x000fc800078e0016ULL, 0x000000104a7f7824ULL, 0x000fe400078e0281ULL,
0x00005e0047467625ULL, 0x000fc800078e0016ULL, 0x000000104d147825ULL, 0x000fc800078e0014ULL,
0x00005e004b4a7625ULL, 0x000fe200078e0016ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014037faeULL, 0x0003e6000b901c46ULL, 0x000000104d187825ULL, 0x000fc800078e0018ULL,
0x00005e0049487625ULL, 0x000fe200078e0016ULL, 0x00000000184f7faeULL, 0x0003e6000b901c46ULL,
0x000000104d1e7825ULL, 0x000fc800078e001eULL, 0x0000001040757824ULL, 0x000fe200078e0281ULL,
0x000000001e517faeULL, 0x0003e2000b901c46ULL, 0x00005e0045447625ULL, 0x000fc800078e0016ULL,
0x000000104d3a7825ULL, 0x000fc800078e003aULL, 0x000000103c717824ULL, 0x000fe200078e0281ULL,
0x000000003a537faeULL, 0x0003e2000b901c46ULL, 0x00005e0041407625ULL, 0x000fc800078e0016ULL,
0x000000104d3e7825ULL, 0x000fc800078e003eULL, 0x00005e003d3c7625ULL, 0x000fe200078e0016ULL,
0x000000003e6b7faeULL, 0x0003e6000b901c46ULL, 0x000000104d427825ULL, 0x000fc800078e0042ULL,
0x00005e0039387625ULL, 0x000fe200078e0016ULL, 0x00000000426d7faeULL, 0x0003e6000b901c46ULL,
0x000000104d467825ULL, 0x000fc800078e0046ULL, 0x00005e001d1c7625ULL, 0x000fe200078e0016ULL,
0x00000000466f7faeULL, 0x0003e6000b901c46ULL, 0x000000104d4a7825ULL, 0x000fc800078e004aULL,
0x00005e001b1a7625ULL, 0x000fe200078e0016ULL, 0x000000004a717faeULL, 0x0003e6000b901c46ULL,
0x000000104d487825ULL, 0x000fc800078e0048ULL, 0x00005e0017167625ULL, 0x000fe200078e0016ULL,
0x0000000048737faeULL, 0x0003e6000b901c46ULL, 0x000000104d447825ULL, 0x000fc800078e0044ULL,
0x000000104d407825ULL, 0x040fe200078e0040ULL, 0x0000000044757faeULL, 0x0003e6000b901c46ULL,
0x000000104d3c7825ULL, 0x040fe200078e003cULL, 0x0000000040777faeULL, 0x0003e6000b901c46ULL,
0x000000104d387825ULL, 0x040fe200078e0038ULL, 0x000000003c797faeULL, 0x0003e6000b901c46ULL,
0x000000104d1c7825ULL, 0x040fe200078e001cULL, 0x00000000387b7faeULL, 0x0003e6000b901c46ULL,
0x000000104d1a7825ULL, 0x040fe200078e001aULL, 0x000000001c7d7faeULL, 0x0003e6000b901c46ULL,
0x000000104c817824ULL, 0x000fe200078e0281ULL, 0x000000001a7f7faeULL, 0x0003e2000b901c46ULL,
0x000000104d167825ULL, 0x000fca00078e0016ULL, 0x0000000016817faeULL, 0x0003e4000b901c46ULL,
0x0000000305037812ULL, 0x002fe200078ec0ffULL, 0x02362c0009167984ULL, 0x000e660000000800ULL,
0x0000000203037810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030300780cULL, 0x000fe40003f04070ULL, 0xffffffff00037802ULL, 0x000fc40000000f00ULL,
0x0000000204147807ULL, 0x000fca0000000000ULL, 0x0000000105057824ULL, 0x000fca00078e0214ULL,
0x0000008c0500720cULL, 0x000fda0003f06070ULL, 0x000000010a148824ULL, 0x000fe400078e0205ULL,
0x00000004ff158424ULL, 0x000fc800078e00ffULL, 0x0000600014148625ULL, 0x000fca00078e0015ULL,
0x0000000614038981ULL, 0x000562000c1e1900ULL, 0x0000ffff0b177812ULL, 0x000fc800078ec0ffULL,
0x0000888017177816ULL, 0x000fca00000000ffULL, 0x8000000017197824ULL, 0x000fca00078e00ffULL,
0x8000000016ff7812ULL, 0x002fe20007804819ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x004fea0003800000ULL, 0x8000000017157824ULL, 0x000fe400078e00ffULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400167305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000160000735dULL, 0x004fe40003800000ULL,
0x02362c0009167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000001006157824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011606ULL,
0x00000001ff1c7424ULL, 0x000fc600078e00ffULL, 0x0000007015177812ULL, 0x000fe400078ec0ffULL,
0x0000000c14157812ULL, 0x000fc600078ec0ffULL, 0x0000008008147824ULL, 0x000fc800078e0217ULL,
0x0000000115147824ULL, 0x000fca00078e0214ULL, 0x0230000014157984ULL, 0x000e680000000800ULL,
0x0232000014527984ULL, 0x0004e20000000800ULL, 0x000000021500720bULL, 0x002fda0003f1d000ULL,
0x0000000000167806ULL, 0x000fc800000e0100ULL, 0x0000ffff16177812ULL, 0x000fda000780c0ffULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000015021c7209ULL, 0x00cfe40007810000ULL,
0x000000021500720bULL, 0x000fe40003f34000ULL, 0x0000008f0800720cULL, 0x000fe20003f05270ULL,
0x8000001c02147221ULL, 0x000fe20000010000ULL, 0x00000002ff1e7819ULL, 0x000fc60000011606ULL,
0x3fb8aa3b14167820ULL, 0x000fc80000410000ULL, 0x0000001600197308ULL, 0x0002a40000000800ULL,
0x0000000000147806ULL, 0x000fc800008e0100ULL, 0x0000ffff14187812ULL, 0x000fe200078e3cffULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001006167824ULL, 0x002fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fc80000011606ULL, 0x00000070161a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c14167812ULL, 0x000fe400078ec0ffULL, 0x0000001502147209ULL, 0x000fe20007810000ULL,
0x000000808f1b7824ULL, 0x000fc800078e021aULL, 0x00000001161b7824ULL, 0x000fca00078e021bULL,
0x023400141b007388ULL, 0x0003e40000000800ULL, 0x0000001817ff7212ULL, 0x000fe2000780c0ffULL,
0x00001f1e19147589ULL, 0x006e6200000e0000ULL, 0x000000081e167810ULL, 0x000fe20007ffe0ffULL,
0x0000001900007220ULL, 0x000fe20000410000ULL, 0x0000001502027209ULL, 0x000fc80007810000ULL,
0x00001f1619167589ULL, 0x000eaa00000e0000ULL, 0x8000001c15170221ULL, 0x000fe20000010000ULL,
0x00000001ff1c7807ULL, 0x000fc60000000000ULL, 0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL,
0x00000017000d0308ULL, 0x000ee20000000800ULL, 0x0000001458587220ULL, 0x082fe40000410000ULL,
0x0000001459597220ULL, 0x080fe40000410000ULL, 0x0000001454547220ULL, 0x080fe40000410000ULL,
0x0000001455557220ULL, 0x080fe40000410000ULL, 0x0000001430307220ULL, 0x080fe40000410000ULL,
0x0000001431317220ULL, 0x000fc40000410000ULL, 0x000000142c2c7220ULL, 0x080fe40000410000ULL,
0x000000142d2d7220ULL, 0x080fe40000410000ULL, 0x0000001428287220ULL, 0x080fe40000410000ULL,
0x0000001429297220ULL, 0x080fe40000410000ULL, 0x0000001424247220ULL, 0x080fe40000410000ULL,
0x0000001425257220ULL, 0x000fc40000410000ULL, 0x0000001420207220ULL, 0x080fe40000410000ULL,
0x0000001421217220ULL, 0x080fe40000410000ULL, 0x0000001434347220ULL, 0x080fe40000410000ULL,
0x0000001435357220ULL, 0x000fe40000410000ULL, 0x000000165a5a7220ULL, 0x084fe40000410000ULL,
0x000000165b5b7220ULL, 0x000fc40000410000ULL, 0x0000001656567220ULL, 0x080fe40000410000ULL,
0x0000001657577220ULL, 0x080fe40000410000ULL, 0x0000001632327220ULL, 0x080fe40000410000ULL,
0x0000001633337220ULL, 0x080fe40000410000ULL, 0x000000162e2e7220ULL, 0x080fe40000410000ULL,
0x000000162f2f7220ULL, 0x000fc40000410000ULL, 0x000000162a2a7220ULL, 0x080fe40000410000ULL,
0x000000162b2b7220ULL, 0x080fe40000410000ULL, 0x0000001626267220ULL, 0x080fe40000410000ULL,
0x0000001627277220ULL, 0x080fe40000410000ULL, 0x0000001622227220ULL, 0x080fe40000410000ULL,
0x0000001623237220ULL, 0x000fc40000410000ULL, 0x0000001636367220ULL, 0x080fe40000410000ULL,
0x0000001637377220ULL, 0x000fe40000410000ULL, 0x000000520d520220ULL, 0x008fe40000410000ULL,
0x000000076e537211ULL, 0x00cfe200078e08ffULL, 0x0000080008187824ULL, 0x000fe200078e0269ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000253497824ULL, 0x000fe200078e026aULL,
0x011000001818783bULL, 0x000fe20000000200ULL, 0x00000002ff517819ULL, 0x000fe20000011606ULL,
0x0000080008407824ULL, 0x040fe200078e0265ULL, 0x0000000dff1d723eULL, 0x000fe200000010ffULL,
0x00000800080f7824ULL, 0x040fe200078e020fULL, 0x0001300049497811ULL, 0x000fe200078e68ffULL,
0x0000080008137824ULL, 0x000fe200078e0213ULL, 0x0000000851507810ULL, 0x000fe20007ffe0ffULL,
0x011000004040783bULL, 0x000fe20000000200ULL, 0x000054101d1d7816ULL, 0x000fe2000000001dULL,
0x00000010673c7824ULL, 0x100fe200078e0249ULL, 0x000099101c1c7816ULL, 0x000fe200000000ffULL,
0x0000001068147824ULL, 0x000fe200078e0249ULL, 0x00000001ff6e7819ULL, 0x000fe2000001168fULL,
0x00001f511d517589ULL, 0x000e6200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x0000001066387824ULL, 0x000fc400078e0249ULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x00000010641c7824ULL, 0x100fe400078e0249ULL, 0x0000001063447824ULL, 0x100fe200078e0249ULL,
0x00001f501d507589ULL, 0x000ea200000e0000ULL, 0x0000001011487824ULL, 0x100fe400078e0249ULL,
0x00000010124c7824ULL, 0x000fe200078e0249ULL, 0x000000001414783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000f280000004200ULL, 0x000000001c1c783bULL, 0x000ee80000004200ULL,
0x000000004444783bULL, 0x000fe20000004200ULL, 0x0000005118188231ULL, 0x002fc400003400ffULL,
0x000000511a1a8231ULL, 0x080fe200003400ffULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x0000005019198231ULL, 0x084fe400003400ffULL, 0x000000501b1b8231ULL, 0x080fe400003400ffULL,
0x0000005140408231ULL, 0x080fe400003400ffULL, 0x0000005142428231ULL, 0x000fe400003400ffULL,
0x0000005041418231ULL, 0x000fc400003400ffULL, 0x0000005043438231ULL, 0x000fe200003400ffULL,
0x0000003c1830723cULL, 0x040fee0000041830ULL, 0x00000010623c7824ULL, 0x100fe200078e0249ULL,
0x0000003e182c723cULL, 0x040fea000004182cULL, 0x000000003c3c783bULL, 0x000e660000004200ULL,
0x000000141858723cULL, 0x048ff00000041858ULL, 0x000000381828723cULL, 0x050fee0000041828ULL,
0x0000001061387824ULL, 0x100fe200078e0249ULL, 0x0000001c1820723cULL, 0x040fee0000041820ULL,
0x00000049601c7211ULL, 0x000fe200078e20ffULL, 0x000000161814723cULL, 0x040ff00000041854ULL,
0x0000003a1824723cULL, 0x040fe20000041824ULL, 0x000000003838783bULL, 0x000eae0000004200ULL,
0x0000001e1818723cULL, 0x000fe20000041834ULL, 0x000000001c1c783bULL, 0x000fee0000004200ULL,
0x0000003c4034723cULL, 0x042fe20000041830ULL, 0x011000000f30783bULL, 0x000e6c0000000200ULL,
0x000000100e3c7824ULL, 0x000fe200078e0249ULL, 0x000000444058723cULL, 0x000fe20000041858ULL,
0x000000010c0e7812ULL, 0x000fca00078e0cffULL, 0x00000002530e7824ULL, 0x000fe400078e020eULL,
0x0000001010447824ULL, 0x000fe200078e0249ULL, 0x000000464014723cULL, 0x000fe20000041814ULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x000130000e0e7811ULL, 0x000fc600078e68ffULL,
0x000000004444783bULL, 0x000ee40000004200ULL, 0x000000105f547824ULL, 0x100fe200078e020eULL,
0x0000003e402c723cULL, 0x040fe2000004182cULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x011000001310783bULL, 0x000f260000000200ULL, 0x000000384028723cULL, 0x044fe20000041828ULL,
0x000000005454783bULL, 0x000eac0000004200ULL, 0x000000105e387824ULL, 0x000fe200078e020eULL,
0x0000003a4024723cULL, 0x000fe20000041824ULL, 0x0000005130308231ULL, 0x002fc400003400ffULL,
0x0000005132328231ULL, 0x000fe400003400ffULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000005031318231ULL, 0x080fe400003400ffULL, 0x0000001c4020723cULL, 0x000fe20000041820ULL,
0x0000005033338231ULL, 0x000fcc00003400ffULL, 0x000000105c1c7824ULL, 0x000fe200078e020eULL,
0x0000001e4040723cULL, 0x000fe20000041818ULL, 0x0000000e5d0e7211ULL, 0x000fc800078e20ffULL,
0x000000001c1c783bULL, 0x000e660000004200ULL, 0x000000443034723cULL, 0x008fe20000041834ULL,
0x000000000e18783bULL, 0x0006620000004200ULL, 0x0000005110108231ULL, 0x090fe400003400ffULL,
0x0000005112128231ULL, 0x000fc800003400ffULL, 0x0000003c3058723cULL, 0x000fe20000041858ULL,
0x0000005011118231ULL, 0x080fe200003400ffULL, 0x000236306e0e7811ULL, 0x008fe200078e20ffULL,
0x0000005013138231ULL, 0x000fca00003400ffULL, 0x0000003e3014723cULL, 0x040ff00000041814ULL,
0x00000046302c723cULL, 0x040ff0000004182cULL, 0x000000483028723cULL, 0x040ff00000041828ULL,
0x0000004a3024723cULL, 0x040ff00000041824ULL, 0x0000004c3020723cULL, 0x040ff00000041820ULL,
0x0000004e3040723cULL, 0x000ff00000041840ULL, 0x000000541058723cULL, 0x044ff00000041858ULL,
0x000000381030723cULL, 0x042ff00000041834ULL, 0x000000561054723cULL, 0x040ff00000041814ULL,
0x0000003a102c723cULL, 0x040ff0000004182cULL, 0x0000001c1028723cULL, 0x040ff00000041828ULL,
0x0000001e1024723cULL, 0x040ff00000041824ULL, 0x000000181020723cULL, 0x040ff00000041820ULL,
0x0000001a1034723cULL, 0x000fe20000041840ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fdc0000008000ULL,
0x000000000eff7f8cULL, 0x0003e2000c80043fULL, 0x0000000052007221ULL, 0x000fe20000010000ULL,
0x000000010c6a7812ULL, 0x000fce00078ec0ffULL, 0x0000030091917a10ULL, 0x002fe40007ffe0ffULL,
0x000000ff0bff7812ULL, 0x000fc4000780c0ffULL, 0x0000008a9100720cULL, 0x000fe40003f26070ULL,
0x00000001ff0b7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffffb68000007947ULL, 0x000fea000383ffffULL, 0x00000000000c7919ULL, 0x002e620000000000ULL,
0x000000026e037824ULL, 0x020fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000203047812ULL, 0x000fe200078e0cffULL, 0x000000808f037824ULL, 0x000fc600078e00ffULL,
0x0000000104047812ULL, 0x000fe200078ef88fULL, 0x000000100c057824ULL, 0x002fe200078e00ffULL,
0x00000001ff067819ULL, 0x100fe4000001160cULL, 0x00000002ff117819ULL, 0x000fe4000001160cULL,
0x00000070050d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c060f7812ULL, 0x000fe200078ec0ffULL,
0x0000008004067824ULL, 0x000fe200078e00ffULL, 0x000230000d047810ULL, 0x000fc40007ffe003ULL,
0x000232000d037810ULL, 0x040fe40007ffe003ULL, 0x000230000d087810ULL, 0x000fe20007ffe006ULL,
0x000000010f057824ULL, 0x000fe200078e0204ULL, 0x000232000d067810ULL, 0x000fe20007ffe006ULL,
0x000000010f097824ULL, 0x040fe200078e0203ULL, 0x0000000000047919ULL, 0x000e620000002500ULL,
0x000000010f087824ULL, 0x040fe400078e0208ULL, 0x000000010f067824ULL, 0x000fe200078e0206ULL,
0x0000000205007388ULL, 0x000fe80000000800ULL, 0x0000000009007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000008a0400720cULL, 0x002fca0003f06070ULL,
0x0000000008087984ULL, 0x000e680000000800ULL, 0x0000000006067984ULL, 0x000ea20000000800ULL,
0x00000002080b7209ULL, 0x002fca0007810000ULL, 0x000000020b037221ULL, 0x000fe40000010100ULL,
0x8000000b08087221ULL, 0x000fe40000010000ULL, 0x3fb8aa3b030a7820ULL, 0x000fe40000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x3fb8aa3b08087820ULL, 0x000fe20000410000ULL,
0x0000000a000e7308ULL, 0x000ef00000000800ULL, 0x00000008000d7308ULL, 0x000ea20000000800ULL,
0x00001f110e027589ULL, 0x008ee200000e0000ULL, 0x0000000803057811ULL, 0x002fe200078ff0ffULL,
0x0000000d060d7220ULL, 0x004fc80000410000ULL, 0x00001f050e0c7589ULL, 0x000e6200000e0000ULL,
0x000000000e087223ULL, 0x000fe4000001000dULL, 0x0000005802587220ULL, 0x048fe40000410000ULL,
0x0000005902597220ULL, 0x040fe40000410000ULL, 0x0000005402547220ULL, 0x040fe40000410000ULL,
0x0000005502557220ULL, 0x040fe40000410000ULL, 0x0000003002307220ULL, 0x000fc40000410000ULL,
0x0000003102317220ULL, 0x040fe40000410000ULL, 0x0000002c02097220ULL, 0x040fe40000410000ULL,
0x0000002d020a7220ULL, 0x040fe40000410000ULL, 0x0000002802287220ULL, 0x040fe40000410000ULL,
0x0000002902297220ULL, 0x040fe40000410000ULL, 0x0000002402247220ULL, 0x000fc40000410000ULL,
0x0000002502257220ULL, 0x040fe40000410000ULL, 0x0000002002207220ULL, 0x040fe40000410000ULL,
0x0000002102217220ULL, 0x040fe40000410000ULL, 0x0000003402347220ULL, 0x040fe40000410000ULL,
0x0000003502357220ULL, 0x000fe40000410000ULL, 0x0000005a0c5a7220ULL, 0x002fc40000410000ULL,
0x0000005b0c5b7220ULL, 0x040fe40000410000ULL, 0x000000560c567220ULL, 0x040fe40000410000ULL,
0x000000570c577220ULL, 0x040fe40000410000ULL, 0x000000320c327220ULL, 0x040fe40000410000ULL,
0x000000330c337220ULL, 0x040fe40000410000ULL, 0x0000002e0c2e7220ULL, 0x000fc40000410000ULL,
0x0000002f0c2f7220ULL, 0x040fe40000410000ULL, 0x0000002a0c2a7220ULL, 0x040fe40000410000ULL,
0x0000002b0c2b7220ULL, 0x040fe40000410000ULL, 0x000000260c267220ULL, 0x040fe40000410000ULL,
0x000000270c277220ULL, 0x040fe40000410000ULL, 0x000000220c227220ULL, 0x000fc40000410000ULL,
0x000000230c237220ULL, 0x040fe40000410000ULL, 0x000000360c367220ULL, 0x040fe40000410000ULL,
0x000000370c377220ULL, 0x000fe20000410000ULL, 0x0000033000000947ULL, 0x000fea0003800000ULL,
0x0180000008007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00006ed0002c7802ULL, 0x000fe40000000f00ULL,
0x0000ace000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000800037308ULL, 0x000e640000001000ULL,
0xbf80000008007423ULL, 0x002fc80000000003ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x00000002ff0d7819ULL, 0x004fe40000011603ULL,
0x0000000803057811ULL, 0x000fc600078ff0ffULL, 0x00001f0d00027589ULL, 0x000ea800000e0000ULL,
0x00001f0500067589ULL, 0x000ee200000e0000ULL, 0x0000000258587220ULL, 0x084fe40000410000ULL,
0x0000000259597220ULL, 0x080fe40000410000ULL, 0x0000000254547220ULL, 0x080fe40000410000ULL,
0x0000000255557220ULL, 0x000fc40000410000ULL, 0x0000000230307220ULL, 0x080fe40000410000ULL,
0x0000000231317220ULL, 0x080fe40000410000ULL, 0x0000000209097220ULL, 0x080fe40000410000ULL,
0x000000020a0a7220ULL, 0x080fe40000410000ULL, 0x0000000228287220ULL, 0x080fe40000410000ULL,
0x0000000229297220ULL, 0x000fc40000410000ULL, 0x0000000224247220ULL, 0x080fe40000410000ULL,
0x0000000225257220ULL, 0x080fe40000410000ULL, 0x0000000220207220ULL, 0x080fe40000410000ULL,
0x0000000221217220ULL, 0x080fe40000410000ULL, 0x0000000234347220ULL, 0x080fe40000410000ULL,
0x0000000235357220ULL, 0x000fc40000410000ULL, 0x000000065a5a7220ULL, 0x088fe40000410000ULL,
0x000000065b5b7220ULL, 0x080fe40000410000ULL, 0x0000000656567220ULL, 0x080fe40000410000ULL,
0x0000000657577220ULL, 0x080fe40000410000ULL, 0x0000000632327220ULL, 0x080fe40000410000ULL,
0x0000000633337220ULL, 0x000fc40000410000ULL, 0x000000062e2e7220ULL, 0x080fe40000410000ULL,
0x000000062f2f7220ULL, 0x080fe40000410000ULL, 0x000000062a2a7220ULL, 0x080fe40000410000ULL,
0x000000062b2b7220ULL, 0x080fe40000410000ULL, 0x0000000626267220ULL, 0x080fe40000410000ULL,
0x0000000627277220ULL, 0x000fc40000410000ULL, 0x0000000622227220ULL, 0x080fe40000410000ULL,
0x0000000623237220ULL, 0x080fe40000410000ULL, 0x0000000636367220ULL, 0x080fe40000410000ULL,
0x0000000637377220ULL, 0x000fe40000410000ULL, 0x000000090a09723eULL, 0x000fe200000010ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000002a2b2a723eULL, 0x000fe200000010ffULL,
0x0000000805067824ULL, 0x040fe200078e00ffULL, 0x00000002ff197819ULL, 0x100fe20000011603ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000005ff2b7212ULL, 0x000fe200078e33ffULL,
0x000000206e147824ULL, 0x000fe200078e0203ULL, 0x0000000705007812ULL, 0x000fc400078ec0ffULL,
0x00000019ff1b7212ULL, 0x000fe400078e33ffULL, 0x0000000319027819ULL, 0x000fe400000006ffULL,
0xfffffff80a2b7812ULL, 0x000fe400078ee22bULL, 0x00000003000a7812ULL, 0x000fe400078e3cffULL,
0xfffffff8061d7812ULL, 0x000fe400078ee205ULL, 0xfffffff8021b7812ULL, 0x000fc400078ee21bULL,
0x0000000200067812ULL, 0x040fe400078e3cffULL, 0x0000000100027812ULL, 0x040fe400078e3cffULL,
0x00000004000c7812ULL, 0x040fe400078e3cffULL, 0x00000005000e7812ULL, 0x040fe200078e3cffULL,
0x00000008051f7824ULL, 0x000fe200078e0202ULL, 0x000000222322723eULL, 0x000fe200000010ffULL,
0x0000000805237824ULL, 0x000fe200078e020aULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x00000008190a7824ULL, 0x000fe200078e00ffULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x0000000805217824ULL, 0x000fe200078e0206ULL, 0x000000282928723eULL, 0x000fe200000010ffULL,
0x0000000805297824ULL, 0x000fe200078e0200ULL, 0x0000000719067812ULL, 0x000fe200078ec0ffULL,
0x0000000403007824ULL, 0x000fe200078e00ffULL, 0x000000242524723eULL, 0x000fe200000010ffULL,
0x0000000805257824ULL, 0x000fe200078e020cULL, 0x000000262726723eULL, 0x000fe200000010ffULL,
0x0000000805277824ULL, 0x000fe200078e020eULL, 0xfffffff80a0d7812ULL, 0x000fe200078ee219ULL,
0x0000100007057824ULL, 0x000fe200078e00ffULL, 0x00000001060a7812ULL, 0x000fc400078e3cffULL,
0x00000003060e7812ULL, 0x040fe400078e3cffULL, 0x00000002060c7812ULL, 0x000fe200078e3cffULL,
0x00000008190f7824ULL, 0x040fe200078e020aULL, 0x0000000c00027812ULL, 0x000fe200078ec0ffULL,
0x0000000819137824ULL, 0x040fe200078e020eULL, 0x000000056e007211ULL, 0x000fe200078e58ffULL,
0x0000000819117824ULL, 0x000fe200078e020cULL, 0x0000000406107812ULL, 0x000fe200078e3cffULL,
0x00000010140a7824ULL, 0x000fe200078e0205ULL, 0x0000000506127812ULL, 0x040fe200078e3cffULL,
0x000000100d0d7824ULL, 0x000fe200078e0200ULL, 0x0000000606067812ULL, 0x000fe200078e3cffULL,
0x0000000819157824ULL, 0x000fe200078e0210ULL, 0x0000000013137211ULL, 0x000fe200078e20ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0200ULL, 0x000000585958723eULL, 0x000fe200000010ffULL,
0x0000000819177824ULL, 0x000fe200078e0212ULL, 0x000000545554723eULL, 0x000fe200000010ffULL,
0x0000000819197824ULL, 0x000fe200078e0206ULL, 0x0000000f020f7210ULL, 0x040fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e0200ULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0202ULL, 0x000000001b1b7211ULL, 0x000fe200078e20ffULL,
0x0000001015157824ULL, 0x100fe200078e0200ULL, 0x000000343534723eULL, 0x000fe200000010ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x000000580d007388ULL, 0x000fe20000000800ULL,
0x0000001019197824ULL, 0x100fe200078e0200ULL, 0x0000005a5b5a723eULL, 0x000fe200000010ffULL,
0x0000000102117824ULL, 0x040fe200078e0211ULL, 0x000000540f007388ULL, 0x000fe20000000800ULL,
0x0000000102067824ULL, 0x040fe200078e0213ULL, 0x000000565756723eULL, 0x000fe200000010ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x0000003011007388ULL, 0x000fe20000000800ULL,
0x0000000102157824ULL, 0x040fe200078e0215ULL, 0x000000323332723eULL, 0x000fe200000010ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x0000000906007388ULL, 0x0005e20000000800ULL,
0x0000000102177824ULL, 0x040fe200078e0217ULL, 0x0000002e2f2e723eULL, 0x000fe200000010ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x0000002815007388ULL, 0x000fe20000000800ULL,
0x0000000102197824ULL, 0x040fe200078e0219ULL, 0x000000363736723eULL, 0x000fe200000010ffULL,
0x0000001023237824ULL, 0x100fe200078e0200ULL, 0x0000002417007388ULL, 0x000fe20000000800ULL,
0x00000001021b7824ULL, 0x040fe200078e021bULL, 0x000000ff00067306ULL, 0x004fe20000205400ULL,
0x00000001021d7824ULL, 0x000fe200078e021dULL, 0x0000002019007388ULL, 0x000fe20000000800ULL,
0x0000001025257824ULL, 0x000fc400078e0200ULL, 0x0000001027277824ULL, 0x100fe200078e0200ULL,
0x000000341b007388ULL, 0x000fe20000000800ULL, 0x00000001021f7824ULL, 0x040fe200078e021fULL,
0x000000ff00097306ULL, 0x000ea20000209400ULL, 0x0000001029297824ULL, 0x100fe200078e0200ULL,
0x0000005a1d007388ULL, 0x000fe20000000800ULL, 0x0000000102217824ULL, 0x040fe400078e0221ULL,
0x000000102b2b7824ULL, 0x000fe200078e0200ULL, 0x000000561f007388ULL, 0x000fe20000000800ULL,
0x0000000102237824ULL, 0x000fc400078e0223ULL, 0x0000000102257824ULL, 0x040fe200078e0225ULL,
0x0000003221007388ULL, 0x000fe20000000800ULL, 0x0000000102277824ULL, 0x040fe400078e0227ULL,
0x0000000102297824ULL, 0x040fe200078e0229ULL, 0x0000002e23007388ULL, 0x000fe20000000800ULL,
0x00000001022b7824ULL, 0x000fe200078e022bULL, 0x000000060900720bULL, 0x004fe20003f1d000ULL,
0x000000ff00027306ULL, 0x000ea2000020d400ULL, 0x0000002a25007388ULL, 0x000fe80000000800ULL,
0x0000002627007388ULL, 0x000fe80000000800ULL, 0x0000002229007388ULL, 0x000fe80000000800ULL,
0x000000362b007388ULL, 0x000fe20000000800ULL, 0x0000000102020812ULL, 0x004fc600078efcffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000020206723eULL, 0x000fca00000010ffULL,
0x000000000a0c7984ULL, 0x000ea80000000c00ULL, 0x000400000a187984ULL, 0x000ee80000000c00ULL,
0x000800000a107984ULL, 0x000f280000000c00ULL, 0x000c00000a1c7984ULL, 0x000f620000000c00ULL,
0x3f803f80060f7831ULL, 0x004fc4000020000fULL, 0x3f803f80060e7831ULL, 0x040fe4000020000eULL,
0x3f803f80060d7831ULL, 0x040fe4000020000dULL, 0x3f803f80060c7831ULL, 0x040fe4000020000cULL,
0x3f803f80061b7831ULL, 0x048fe4000020001bULL, 0x3f803f80061a7831ULL, 0x040fe4000020001aULL,
0x3f803f8006197831ULL, 0x000fc40000200019ULL, 0x3f803f8006187831ULL, 0x000fe20000200018ULL,
0x00000001ff067424ULL, 0x000fe200078e00ffULL, 0x3f803f800f0f7831ULL, 0x010fe40000200013ULL,
0x3f803f800e0e7831ULL, 0x000fe40000200012ULL, 0x0000030006007a0cULL, 0x000fe20003f05270ULL,
0x3f803f800d0d7831ULL, 0x000fe40000200011ULL, 0x3f803f800c0c7831ULL, 0x000fe40000200010ULL,
0x3f803f801b1b7831ULL, 0x020fc4000020001fULL, 0x3f803f801a1a7831ULL, 0x000fe2000020001eULL,
0x0000000c0a007388ULL, 0x0005e20000000c00ULL, 0x3f803f8019197831ULL, 0x000fe4000020001dULL,
0x3f803f8018187831ULL, 0x000fca000020001cULL, 0x000400180a007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000308000008947ULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x004ea20000002700ULL, 0x00005800ff067624ULL, 0x000fe200078e00ffULL,
0x0000100000117802ULL, 0x000fc40000000f00ULL, 0x0000000000097919ULL, 0x000ea20000002600ULL,
0x0000030006067a24ULL, 0x000fe200078e02ffULL, 0x000000016eff7812ULL, 0x000fe4000780f88fULL,
0x000000000a0c7984ULL, 0x0007220000000c00ULL, 0x0000660006067a24ULL, 0x000fe200078e02ffULL,
0x0000004014177810ULL, 0x000fe40007ffe0ffULL, 0x000400000a1c7984ULL, 0x0006620000000c00ULL,
0x000000ff0300720cULL, 0x000fe20000725670ULL, 0x0000580018187a24ULL, 0x004fc800078e0209ULL,
0x0000030018097a24ULL, 0x000fc800078e02ffULL, 0x0000000109137824ULL, 0x000fe200078e0204ULL,
0x00000fff06047811ULL, 0x040fe400078e40ffULL, 0x01ffffff06067812ULL, 0x000fe400078ec0ffULL,
0x0000001304107211ULL, 0x000fca00078fa0ffULL, 0x00006c0010107625ULL, 0x000fcc00078e0011ULL,
0x0000080007107825ULL, 0x000fcc00078e0010ULL, 0x0000001014147825ULL, 0x000fc800078e0010ULL,
0x0000001017167825ULL, 0x000fe200078e0010ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003107824ULL, 0x01afe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0a7424ULL, 0x000fe400078e00ffULL, 0x0000000113127824ULL, 0x000fe200078e0206ULL,
0x0000007010197812ULL, 0x000fe400078ec0ffULL, 0x0000000c111a7812ULL, 0x000fe200078ec0ffULL,
0x00006c0013107625ULL, 0x000fc800078e000aULL, 0x00006c0012127625ULL, 0x000fe200078e000aULL,
0x000000101a107210ULL, 0x000fc80007a1e019ULL, 0x000000121a127210ULL, 0x000fe40007c7e019ULL,
0x00000011ff117210ULL, 0x000fe400007e44ffULL, 0x00000013ff137210ULL, 0x000fc60001fe84ffULL,
0x0000000b10007986ULL, 0x0003e8000c101906ULL, 0x0000000812007986ULL, 0x0003e4000c101906ULL,
0x0000000c14007986ULL, 0x01a3e2000c101d06ULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x0000001c16007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000001ff0d7424ULL, 0x002fe400078e00ffULL,
0x00000004ff0b7424ULL, 0x000fc600078e00ffULL, 0x000003000d0d7a10ULL, 0x000fe20007ffe1ffULL,
0x00006a00180a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0a0a79a8ULL, 0x000ea400099ee1c6ULL,
0x0000000d0a00720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff087984ULL, 0x002e640000000000ULL, 0x000000ff0800720cULL, 0x002fda0003f05270ULL,
0x00002cb000008947ULL, 0x000fea0003800000ULL, 0x000000ff8f00720cULL, 0x000fda0003f05270ULL,
0x00000d6000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011603ULL,
0x0000001003087824ULL, 0x000fe200078e00ffULL, 0x00000001090c7810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff197424ULL, 0x000fe200078e00ffULL, 0x0000000c0a0e7812ULL, 0x000fe400078ec0ffULL,
0x00000070081b7812ULL, 0x000fe200078ec0ffULL, 0x00006c00090a7625ULL, 0x000fc800078e0019ULL,
0x00006c000c0c7625ULL, 0x000fe200078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000c0e0c7210ULL, 0x000fe40007b5e01bULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a087981ULL, 0x000368000c1e1900ULL,
0x000000060c0f7981ULL, 0x000362000c1e1900ULL, 0x00000300ff107624ULL, 0x000fca00078e00ffULL,
0x000000021000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002090a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000041000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003090a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000041000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004090a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000061000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005090a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a177981ULL, 0x000362000c1e1900ULL,
0x000000061000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081000780cULL, 0x002fe40003f06070ULL, 0x00000006090a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a0e0a7210ULL, 0x000fe40007a3e01bULL,
0x00000007090c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0019ULL, 0x000000060a197981ULL, 0x000366000c1e1900ULL,
0x0000000c0e0c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c1b0981ULL, 0x000368000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x00000008000d7202ULL, 0x020fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0009ULL, 0x000000ffff147224ULL, 0x000fc600078e00ffULL,
0x0000030012007a0cULL, 0x000fe40003f26070ULL, 0x0000000114147810ULL, 0x000fc80007ffe0ffULL,
0x0000000414007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008120a7810ULL, 0x040fe40007ffe0ffULL, 0x00000001120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000d08087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000080c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030d7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000002120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000f08087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000090c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0f7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000003120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001108087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000010030e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000004120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000005120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001508087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000004030e7819ULL, 0x000fe400000006ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x000000700e157812ULL, 0x000fe400078ec0ffULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000006120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000007120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001908087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000010030e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e197812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f120a7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b08087209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000010030e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e1b7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007a3e01bULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a1b7981ULL, 0x000368000c1e1900ULL, 0x0000000812127810ULL, 0x000fe40007ffe0ffULL,
0x000000080c0c7810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x00000010030a7824ULL, 0x006fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010a0b7824ULL, 0x000fca00078e020bULL,
0x000000080b007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003087824ULL, 0x042fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011603ULL,
0x000000016e157824ULL, 0x000fe200078e0209ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000004003117810ULL, 0x000fe20007ffe0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000070080a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000002ff087819ULL, 0x000fe2000001168fULL, 0x000002008f8f7824ULL, 0x000fe200078e00ffULL,
0x0000000b0a277210ULL, 0x000fe20007ffe0ffULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000015040a7211ULL, 0x000fe200078fa0ffULL, 0x000000026e0d8824ULL, 0x100fe200078e0207ULL,
0x0000000108087812ULL, 0x000fe200078ec0ffULL, 0x000000026e0f8824ULL, 0x000fe200078e0207ULL,
0x000008008f8f7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000006003137810ULL, 0x000fe20007ffe0ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000003006e007a0cULL, 0x040fe20003f26070ULL, 0x000000020d168824ULL, 0x100fe200078e0208ULL,
0x00000020030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000020f188824ULL, 0x000fe200078e0208ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000020006e087824ULL, 0x000fe200078e0205ULL,
0x0000000027277984ULL, 0x000e620000000800ULL, 0x00000800070a7825ULL, 0x000fc800078e000aULL,
0x00000001080c7824ULL, 0x000fe400078e028fULL, 0x00000001060e8824ULL, 0x000fe400078e0215ULL,
0x00000080ff0f8424ULL, 0x000fe200078e00ffULL, 0x0000000c031b7211ULL, 0x000fe200078e20ffULL,
0x00000080ff148424ULL, 0x000fe400078e00ffULL, 0x00006c000e0e8625ULL, 0x000fc800078e000fULL,
0x000000100d0c7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x0000001013127825ULL, 0x000fc800078e000aULL, 0x00006c0015148625ULL, 0x000fc800078e0014ULL,
0x00000008161f8824ULL, 0x000fe400078e0203ULL, 0x00000010030a7825ULL, 0x000fc600078e000aULL,
0x000045801f1f8811ULL, 0x000fe200078e20ffULL, 0x0000000818218824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a1b7faeULL, 0x0005e2000b901c46ULL,
0x0000001003168825ULL, 0x000fe400078e000eULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000418021218811ULL, 0x000fe200078e20ffULL, 0x0000001003188825ULL, 0x000fe200078e0014ULL,
0x003800000c1b7faeULL, 0x0007e2000b901c46ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x00580000101b7faeULL, 0x0009e2000b901c46ULL,
0x00000000000a7805ULL, 0x004fc6000001ff00ULL, 0x00780000121b7faeULL, 0x0005e8000b901c46ULL,
0x00000000161f8faeULL, 0x000be2000b901c46ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x0000000018218faeULL, 0x0007e2000b901c46ULL, 0x0000000000107805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x004fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x020fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000df000001947ULL, 0x000fea0003800000ULL,
0x00000de000007945ULL, 0x002fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff307224ULL, 0x000fca00078e006eULL, 0x00000002302e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff437224ULL, 0x000fe200078e0030ULL, 0x00000002ff2d7819ULL, 0x000fe20000011603ULL,
0x000000026e327824ULL, 0x002fe200078e0207ULL, 0x000003002e007a0cULL, 0x000fe20003f06070ULL,
0x00000040432f7824ULL, 0x000fe200078e00ffULL, 0x000000072d317812ULL, 0x040fe200078ec0ffULL,
0x000000082d2c7824ULL, 0x040fe200078e00ffULL, 0x000000032d3c7819ULL, 0x040fe200000006ffULL,
0x000000082d337824ULL, 0x000fe200078e00ffULL, 0x000000802f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000039000017945ULL, 0x000fe20003800000ULL, 0x0000002dff307212ULL, 0x000fe200078e33ffULL,
0x0000001003457824ULL, 0x000fe200078e00ffULL, 0x000000012c3e7812ULL, 0x000fe200078ef631ULL,
0x0000010032417824ULL, 0x000fe200078e002fULL, 0x000000022c407812ULL, 0x000fc400078ef631ULL,
0x000000032c427812ULL, 0x140fe400078ef631ULL, 0x000000042c447812ULL, 0x140fe400078ef631ULL,
0x000000052c467812ULL, 0x140fe400078ef631ULL, 0x000000062c487812ULL, 0x100fe400078ef631ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee231ULL, 0xfffffff833507812ULL, 0x000fc400078ee230ULL,
0x000000082d2c7810ULL, 0x000fe20007ffe0ffULL, 0x000002b000000947ULL, 0x008fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x00000001093b7824ULL, 0x100fe200078e022eULL,
0x00000001ff2f7819ULL, 0x000fe2000001162eULL, 0x00001000ff317424ULL, 0x000fe200078e00ffULL,
0x0000002003357810ULL, 0x000fe40007ffe0ffULL, 0x000000012f2f7812ULL, 0x000fe400078ec0ffULL,
0x0000003b04307211ULL, 0x000fe400078fa0ffULL, 0x0000004003377810ULL, 0x000fc40007ffe0ffULL,
0x00000060033d7810ULL, 0x000fe20007ffe0ffULL, 0x000000026e328824ULL, 0x140fe400078e0207ULL,
0x000000026e4a8824ULL, 0x000fe400078e0207ULL, 0x00006c0030307625ULL, 0x000fe200078e0031ULL,
0x0000002f324c8211ULL, 0x000fc600078e08ffULL, 0x000000024a4a8824ULL, 0x000fe400078e022fULL,
0x000004002e2f7824ULL, 0x000fe400078e00ffULL, 0x0000080007307825ULL, 0x000fc600078e0030ULL,
0x000008002f2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000106388824ULL, 0x000fe400078e023bULL,
0x00000080ff398424ULL, 0x000fe400078e00ffULL, 0x0000000108327824ULL, 0x000fe400078e022fULL,
0x00000080ff3a8424ULL, 0x000fe400078e00ffULL, 0x00000010032f7824ULL, 0x040fe400078e0232ULL,
0x0000001003327825ULL, 0x000fc800078e0030ULL, 0x0000001035347825ULL, 0x100fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000322f7faeULL, 0x0003e6000b901c46ULL,
0x0000001037367825ULL, 0x100fe200078e0030ULL, 0x00380000342f7faeULL, 0x0003e6000b901c46ULL,
0x00006c0038388625ULL, 0x000fe200078e0039ULL, 0x00580000362f7faeULL, 0x0003e6000b901c46ULL,
0x000000103d307825ULL, 0x000fc800078e0030ULL, 0x00006c003b3a8625ULL, 0x000fe200078e003aULL,
0x00780000302f7faeULL, 0x0003e6000b901c46ULL, 0x000000084a3d8824ULL, 0x100fe400078e0203ULL,
0x000000084c3f8824ULL, 0x000fe400078e0203ULL, 0x0000001003388825ULL, 0x000fe200078e0038ULL,
0x000045803d3d8811ULL, 0x000fe400078e20ffULL, 0x000041803f3f8811ULL, 0x000fe200078e20ffULL,
0x00000010033a8825ULL, 0x000fc400078e003aULL, 0x00000000383d8faeULL, 0x0003e8000b901c46ULL,
0x000000003a3f8faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff327819ULL, 0x002fe20000011603ULL,
0x00000400432f7824ULL, 0x000fe200078e00ffULL, 0x00000070454c7812ULL, 0x000fe200078ec0ffULL,
0x000000082c317824ULL, 0x000fe200078e00ffULL, 0x0000000c32337812ULL, 0x000fe400078ec0ffULL,
0x000000072c307812ULL, 0x000fc400078ec0ffULL, 0x0000004133417210ULL, 0x000fe20007ffe04cULL,
0x000000082c337824ULL, 0x040fe200078e00ffULL, 0x000000032c357819ULL, 0x000fe400000006ffULL,
0x000008002f2f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff835327812ULL, 0x100fe400078ee230ULL,
0x0000000131347812ULL, 0x140fe400078ef630ULL, 0x0000000231367812ULL, 0x000fc400078ef630ULL,
0x0000000331387812ULL, 0x140fe400078ef630ULL, 0x00000004313a7812ULL, 0x000fe200078ef630ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000414e7984ULL, 0x000fe20000000800ULL,
0x00000005314a7812ULL, 0x140fe400078ef630ULL, 0x0000000631307812ULL, 0x000fe200078ef630ULL,
0x0000000403317824ULL, 0x000fe200078e00ffULL, 0x0000002cff4c7212ULL, 0x000fe200078e33ffULL,
0x0045800041417984ULL, 0x000fe20000000800ULL, 0x00000180082f7810ULL, 0x000fe40007ffe02fULL,
0xfffffff8334c7812ULL, 0x000fe400078ee24cULL, 0x0000000c31337812ULL, 0x000fe200078ec0ffULL,
0x000000103c3c7824ULL, 0x100fe200078e022fULL, 0x0000002f48487211ULL, 0x000fe200078e20ffULL,
0x0000001036367824ULL, 0x000fc400078e022fULL, 0x0000001038387824ULL, 0x100fe200078e022fULL,
0x0000003c333c7210ULL, 0x040fe20007ffe0ffULL, 0x000000103e3e7824ULL, 0x100fe200078e022fULL,
0x0000003633367210ULL, 0x000fe20007ffe0ffULL, 0x0000001040407824ULL, 0x100fe400078e022fULL,
0x0000001042427824ULL, 0x100fe200078e022fULL, 0x000000003c3c7984ULL, 0x000e620000000800ULL,
0x0000001044447824ULL, 0x100fe400078e022fULL, 0x0000001046467824ULL, 0x100fe200078e022fULL,
0x0000000036367984ULL, 0x000ea20000000800ULL, 0x000000103a3a7824ULL, 0x000fc400078e022fULL,
0x000000104a4a7824ULL, 0x100fe400078e022fULL, 0x0000001032327824ULL, 0x100fe400078e022fULL,
0x0000001034347824ULL, 0x100fe400078e022fULL, 0x0000001030317824ULL, 0x100fe400078e022fULL,
0x000000104c4c7824ULL, 0x100fe400078e022fULL, 0x0000001050307824ULL, 0x000fc400078e022fULL,
0x0000000133387824ULL, 0x040fe400078e0238ULL, 0x00000001333e7824ULL, 0x040fe400078e023eULL,
0x0000000133407824ULL, 0x040fe400078e0240ULL, 0x0000000133427824ULL, 0x040fe200078e0242ULL,
0x0000000038387984ULL, 0x000ee20000000800ULL, 0x0000000133447824ULL, 0x040fe400078e0244ULL,
0x0000000133467824ULL, 0x040fe200078e0246ULL, 0x000000003e3e7984ULL, 0x000f220000000800ULL,
0x0000000133487824ULL, 0x000fc400078e0248ULL, 0x00000001333a7824ULL, 0x040fe200078e023aULL,
0x0000000040407984ULL, 0x000f620000000800ULL, 0x00000001334a7824ULL, 0x040fe400078e024aULL,
0x0000000133327824ULL, 0x040fe200078e0232ULL, 0x0000000042427984ULL, 0x000f620000000800ULL,
0x0000000133347824ULL, 0x040fe200078e0234ULL, 0x00005410ff377816ULL, 0x002fe2000000003cULL,
0x0000000133317824ULL, 0x040fe200078e0231ULL, 0x0000000044447984ULL, 0x000e620000000800ULL,
0x00000001334c7824ULL, 0x040fe200078e024cULL, 0x00005410ff477816ULL, 0x004fe20000000036ULL,
0x0000000133307824ULL, 0x000fe200078e0230ULL, 0x0000000046467984ULL, 0x000ea20000000800ULL,
0x0000004e274e7221ULL, 0x000fe20000010100ULL, 0x00007610ff3c7816ULL, 0x000fc4000000003cULL,
0x0000000048487984ULL, 0x000ea20000000800ULL, 0x3fb8aa3b4e4e7820ULL, 0x000fe20000410000ULL,
0x00007610ff367816ULL, 0x000fe40000000036ULL, 0x000000003a3a7984ULL, 0x000ea60000000800ULL,
0x0000004e004e7308ULL, 0x000f220000000800ULL, 0x000000004a4a7984ULL, 0x000ea80000000800ULL,
0x00000000302f7984ULL, 0x0008a80000000800ULL, 0x0000000032327984ULL, 0x000ea20000000800ULL,
0x00005410ff497816ULL, 0x008fc40000000038ULL, 0x00007610ff4b7816ULL, 0x000fe20000000038ULL,
0x0000000034347984ULL, 0x000ee20000000800ULL, 0x000000ffff307224ULL, 0x010fe200078e002eULL,
0x00005410ff397816ULL, 0x000fe2000000003eULL, 0x000000414e587220ULL, 0x000fe20000410000ULL,
0x0000000031317984ULL, 0x000f220000000800ULL, 0x00005410ff4e7816ULL, 0x020fe40000000040ULL,
0x0000030030007a0cULL, 0x000fe20003f06070ULL, 0x000000004c4c7984ULL, 0x000f620000000800ULL,
0x00005410ff507816ULL, 0x000fe20000000042ULL, 0x0000002b582b7221ULL, 0x000fe20000010000ULL,
0x00007610ff3e7816ULL, 0x000fc4000000003eULL, 0x00005410ff527816ULL, 0x002fe40000000044ULL,
0x00007610ff407816ULL, 0x000fe40000000040ULL, 0x00005410ff547816ULL, 0x004fe40000000046ULL,
0x00007610ff427816ULL, 0x000fe40000000042ULL, 0x00005410ff3b7816ULL, 0x000fe40000000048ULL,
0x00007610ff447816ULL, 0x000fc40000000044ULL, 0x00005410ff387816ULL, 0x000fe4000000003aULL,
0x00007610ff467816ULL, 0x000fe40000000046ULL, 0x00005410ff4d7816ULL, 0x100fe4000000004aULL,
0x00007610ff4f7816ULL, 0x000fe4000000004aULL, 0x00007610ff487816ULL, 0x000fe40000000048ULL,
0x00005410ff567816ULL, 0x000fc4000000002fULL, 0x00007610ff3d7816ULL, 0x000fe4000000002fULL,
0x00005410ff3f7816ULL, 0x100fe40000000032ULL, 0x00007610ff417816ULL, 0x000fe40000000032ULL,
0x00005410ff437816ULL, 0x108fe40000000034ULL, 0x00007610ff457816ULL, 0x000fe40000000034ULL,
0x00007610ff3a7816ULL, 0x000fc4000000003aULL, 0x00005410ff4a7816ULL, 0x110fe40000000031ULL,
0x00007610ff517816ULL, 0x000fe40000000031ULL, 0x00005410ff537816ULL, 0x120fe4000000004cULL,
0x00007610ff557816ULL, 0x000fe2000000004cULL, 0x000079927f007947ULL, 0x000fea000b800000ULL,
0x00001f2d582d7589ULL, 0x0002a400000e0000ULL, 0x000079f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2c582c7589ULL, 0x00072400000e0000ULL, 0x0000002d372a7223ULL, 0x084fe4000001002aULL,
0x0000002d3c297223ULL, 0x080fe40000010029ULL, 0x0000002d39287223ULL, 0x000fc40000010028ULL,
0x0000002d3e267223ULL, 0x080fe40000010026ULL, 0x0000002d4e257223ULL, 0x080fe40000010025ULL,
0x0000002d40247223ULL, 0x080fe40000010024ULL, 0x0000002d50237223ULL, 0x080fe40000010023ULL,
0x0000002d42227223ULL, 0x080fe40000010022ULL, 0x0000002d52217223ULL, 0x000fc40000010021ULL,
0x0000002d44207223ULL, 0x080fe40000010020ULL, 0x0000002d541f7223ULL, 0x080fe4000001001fULL,
0x0000002d461e7223ULL, 0x080fe4000001001eULL, 0x0000002d3b0c7223ULL, 0x080fe4000001000cULL,
0x0000002d481d7223ULL, 0x080fe4000001001dULL, 0x0000002d560b7223ULL, 0x000fc4000001000bULL,
0x0000002d3d1c7223ULL, 0x000fe4000001001cULL, 0x0000002c3f0d7223ULL, 0x090fe4000001000dULL,
0x0000002c411b7223ULL, 0x080fe4000001001bULL, 0x0000002c43147223ULL, 0x080fe40000010014ULL,
0x0000002c451a7223ULL, 0x080fe4000001001aULL, 0x0000002c47137223ULL, 0x000fc40000010013ULL,
0x0000002c36197223ULL, 0x080fe40000010019ULL, 0x0000002c49127223ULL, 0x080fe40000010012ULL,
0x0000002c4b187223ULL, 0x080fe40000010018ULL, 0x0000002c38117223ULL, 0x080fe40000010011ULL,
0x0000002c3a177223ULL, 0x080fe40000010017ULL, 0x0000002c4d107223ULL, 0x000fc40000010010ULL,
0x0000002c4f167223ULL, 0x080fe40000010016ULL, 0x0000002c4a0f7223ULL, 0x080fe4000001000fULL,
0x0000002c51157223ULL, 0x080fe40000010015ULL, 0x0000002c530e7223ULL, 0x080fe4000001000eULL,
0x0000002c550a7223ULL, 0x000fe2000001000aULL, 0xfffff25000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000104087824ULL, 0x000fe200078e0203ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000001003047824ULL, 0x002fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fc80000011603ULL,
0x0000007004037812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x000000036e037211ULL, 0x000fca00078e38ffULL, 0x0000000103067824ULL, 0x000fca00078e0206ULL,
0x0049802b06007388ULL, 0x0003e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0x0049800008037984ULL, 0x000ea80000000800ULL, 0x004a000008047984ULL, 0x000f220000000800ULL,
0x00000003ff037221ULL, 0x004fc80000010000ULL, 0x0000000403037221ULL, 0x010fca0000010000ULL,
0x0180000003047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e0003ULL,
0x0000a000002c7802ULL, 0x000fe40000000f00ULL, 0x00007bb000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300047308ULL, 0x000ea40000001000ULL, 0xbf80000003067423ULL, 0x006fc80000000004ULL,
0x800000ff06097221ULL, 0x000fc80000010100ULL, 0x0000000904047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000020202723eULL, 0x000fc600000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008032d7811ULL, 0x004fe400078ff0ffULL, 0x00000002ff2b7819ULL, 0x000fe40000011603ULL,
0x0000002dff2c7212ULL, 0x000fe200078e33ffULL, 0x00001f2d04067589ULL, 0x000ea200000e0000ULL,
0x000000082d337824ULL, 0x000fe400078e00ffULL, 0x000000082b2f7824ULL, 0x000fe200078e00ffULL,
0x00001f2b04097589ULL, 0x000f2400000e0000ULL, 0xfffffff833337812ULL, 0x000fca00078ee22cULL,
0x0000001033337824ULL, 0x000fe400078e0200ULL, 0x0000001906087220ULL, 0x046fe40000410000ULL,
0x0000001806197220ULL, 0x040fe40000410000ULL, 0x0000001706187220ULL, 0x040fe40000410000ULL,
0x0000001606177220ULL, 0x040fe40000410000ULL, 0x0000001506167220ULL, 0x000fc40000410000ULL,
0x0000002a092a7220ULL, 0x050fe40000410000ULL, 0x0000002909297220ULL, 0x040fe40000410000ULL,
0x0000002809287220ULL, 0x040fe40000410000ULL, 0x0000002609277220ULL, 0x040fe20000410000ULL,
0x0000002bff267212ULL, 0x000fe200078e33ffULL, 0x0000002509257220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000010ffULL, 0x0000002409247220ULL, 0x000fe20000410000ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee226ULL, 0x0000002309237220ULL, 0x000fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x0000002209227220ULL, 0x040fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000010ffULL, 0x0000002109217220ULL, 0x000fc40000410000ULL,
0x0000002009207220ULL, 0x040fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000001f091f7220ULL, 0x040fe40000410000ULL, 0x0000001e091e7220ULL, 0x040fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000000c090c7220ULL, 0x040fe40000410000ULL,
0x0000001d091d7220ULL, 0x040fe20000410000ULL, 0x0000001f1e1e723eULL, 0x000fe200000010ffULL,
0x0000000b090b7220ULL, 0x000fc40000410000ULL, 0x0000001c091c7220ULL, 0x000fe20000410000ULL,
0x0000000c1d0c723eULL, 0x000fe200000010ffULL, 0x0000000d060d7220ULL, 0x040fe40000410000ULL,
0x0000001b06047220ULL, 0x000fe20000410000ULL, 0x0000000b1c0b723eULL, 0x000fe200000010ffULL,
0x0000000a06157220ULL, 0x040fe20000410000ULL, 0x000000072d1c7812ULL, 0x000fe200078ec0ffULL,
0x0000001406147220ULL, 0x000fe20000410000ULL, 0x0000000d0404723eULL, 0x000fe200000010ffULL,
0x0000001a06097220ULL, 0x000fc40000410000ULL, 0x0000001106117220ULL, 0x040fe40000410000ULL,
0x0000000f060f7220ULL, 0x000fe20000410000ULL, 0x000000140909723eULL, 0x000fe200000010ffULL,
0x000000082b0a7824ULL, 0x040fe200078e00ffULL, 0x000000111811723eULL, 0x000fe200000010ffULL,
0x0000001306137220ULL, 0x000fe20000410000ULL, 0x0000000f160f723eULL, 0x000fe200000010ffULL,
0x0000001206127220ULL, 0x000fe20000410000ULL, 0xfffffff80a0d7812ULL, 0x000fe200078ee22bULL,
0x0000001006107220ULL, 0x000fe20000410000ULL, 0x000000130808723eULL, 0x000fe200000010ffULL,
0x0000000e060e7220ULL, 0x000fe20000410000ULL, 0x000000072b067812ULL, 0x000fe200078ec0ffULL,
0x000000082d267824ULL, 0x000fe200078e00ffULL, 0x000000121912723eULL, 0x000fe200000010ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0200ULL, 0x00000001060a7812ULL, 0x040fe200078e3cffULL,
0x000000102f2f7824ULL, 0x000fe200078e0200ULL, 0x0000000206147812ULL, 0x000fc400078e3cffULL,
0x0000000306167812ULL, 0x040fe200078e3cffULL, 0x000000082b137824ULL, 0x000fe200078e020aULL,
0x0000000406187812ULL, 0x040fe400078e3cffULL, 0x00000005061a7812ULL, 0x040fe200078e3cffULL,
0x0000001013137824ULL, 0x000fe200078e0200ULL, 0x0000000606067812ULL, 0x000fe200078e3cffULL,
0x000000082b197824ULL, 0x000fe200078e0218ULL, 0x000000101710723eULL, 0x000fe200000010ffULL,
0x000000082b1b7824ULL, 0x000fe200078e021aULL, 0x0000000e150e723eULL, 0x000fe200000010ffULL,
0x000000082b157824ULL, 0x040fe200078e0214ULL, 0x000000162b177211ULL, 0x040fe200078e18ffULL,
0x000000082b2b7824ULL, 0x000fe200078e0206ULL, 0x000000011c0a7812ULL, 0x040fe200078e3cffULL,
0x0000000403067824ULL, 0x000fe200078e00ffULL, 0x000000021c147812ULL, 0x040fe200078e3cffULL,
0x0000001015157824ULL, 0x000fe200078e0200ULL, 0x000000031c167812ULL, 0x040fe200078e3cffULL,
0x000000082d1f7824ULL, 0x040fe200078e020aULL, 0x000000041c187812ULL, 0x040fe200078e3cffULL,
0x000000082d217824ULL, 0x040fe200078e0214ULL, 0x000000051c1a7812ULL, 0x040fe200078e3cffULL,
0x000000082d237824ULL, 0x040fe200078e0216ULL, 0x000000061c1c7812ULL, 0x000fe200078e3cffULL,
0x000000082d257824ULL, 0x040fe200078e0218ULL, 0xfffffff8261d7812ULL, 0x000fe200078ee22dULL,
0x000000082d317824ULL, 0x040fe200078e021aULL, 0x0000001c2d2d7211ULL, 0x000fe200078e18ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x0000000c06067812ULL, 0x000fe200078ec0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x000000001b1b7211ULL, 0x000fe200078e20ffULL,
0x0000001019197824ULL, 0x000fe200078e0200ULL, 0x0000003306337210ULL, 0x000fe20007ffe0ffULL,
0x000000010d0a7824ULL, 0x000fc400078e0206ULL, 0x000000102b2b7824ULL, 0x100fe400078e0200ULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0x000000290a007388ULL, 0x0003e20000000800ULL,
0x0000001021217824ULL, 0x100fe400078e0200ULL, 0x0000001023237824ULL, 0x100fe400078e0200ULL,
0x0000001025257824ULL, 0x100fe400078e0200ULL, 0x0000001031317824ULL, 0x000fc400078e0200ULL,
0x000000102d2d7824ULL, 0x000fe200078e0200ULL, 0x0000002506267210ULL, 0x040fe20007ffe0ffULL,
0x0000000106007824ULL, 0x040fe400078e0213ULL, 0x0000000106157824ULL, 0x040fe400078e0215ULL,
0x0000000106177824ULL, 0x040fe200078e0217ULL, 0x0000002700007388ULL, 0x0005e20000000800ULL,
0x0000000106197824ULL, 0x040fe400078e0219ULL, 0x00000001061b7824ULL, 0x040fe200078e021bULL,
0x0000002415007388ULL, 0x000fe20000000800ULL, 0x00000001062b7824ULL, 0x000fc400078e022bULL,
0x0000000106147824ULL, 0x040fe200078e022fULL, 0x0000002217007388ULL, 0x000fe20000000800ULL,
0x00000001061d7824ULL, 0x040fe400078e021dULL, 0x0000000106187824ULL, 0x040fe200078e021fULL,
0x0000002019007388ULL, 0x000fe20000000800ULL, 0x0000000106217824ULL, 0x040fe400078e0221ULL,
0x0000000106237824ULL, 0x040fe200078e0223ULL, 0x0000001e1b007388ULL, 0x000fe20000000800ULL,
0x0000000106317824ULL, 0x000fc400078e0231ULL, 0x0000000106067824ULL, 0x000fe200078e022dULL,
0x0000000c2b007388ULL, 0x000fe20000000800ULL, 0x000000206e0a7824ULL, 0x002fc600078e0203ULL,
0x0000000b14007388ULL, 0x000fe20000000800ULL, 0x000000100a007824ULL, 0x004fc600078e0205ULL,
0x000000041d007388ULL, 0x000fe80000000800ULL, 0x0000000918007388ULL, 0x000fe80000000800ULL,
0x0000000821007388ULL, 0x000fe80000000800ULL, 0x0000001223007388ULL, 0x000fe80000000800ULL,
0x0000001126007388ULL, 0x000fe80000000800ULL, 0x0000001031007388ULL, 0x000fe80000000800ULL,
0x0000000f06007388ULL, 0x000fe80000000800ULL, 0x0000000e33007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000000147984ULL, 0x000e680000000c00ULL,
0x00040000001c7984ULL, 0x000ea80000000c00ULL, 0x0008000000187984ULL, 0x000f280000000c00ULL,
0x000c000000087984ULL, 0x000f620000000c00ULL, 0x3f803f8002177831ULL, 0x002fc40000200017ULL,
0x3f803f8002167831ULL, 0x040fe40000200016ULL, 0x3f803f8002157831ULL, 0x040fe40000200015ULL,
0x3f803f8002147831ULL, 0x040fe40000200014ULL, 0x3f803f80021f7831ULL, 0x044fe4000020001fULL,
0x3f803f80021e7831ULL, 0x040fe4000020001eULL, 0x3f803f80021d7831ULL, 0x000fc4000020001dULL,
0x3f803f80021c7831ULL, 0x000fe4000020001cULL, 0x3f803f8017177831ULL, 0x010fe4000020001bULL,
0x3f803f8016167831ULL, 0x000fe4000020001aULL, 0x3f803f8015157831ULL, 0x000fe40000200019ULL,
0x3f803f8014147831ULL, 0x000fe40000200018ULL, 0x3f803f801f1f7831ULL, 0x020fc4000020000bULL,
0x3f803f801e1e7831ULL, 0x000fe2000020000aULL, 0x0000001400007388ULL, 0x0003e20000000c00ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200009ULL, 0x3f803f801c1c7831ULL, 0x000fca0000200008ULL,
0x0004001c00007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x004ea20000002600ULL, 0x00000020031b7810ULL, 0x040fe20007ffe0ffULL,
0x00000000000479c3ULL, 0x000f220000002700ULL, 0x00000040031d7810ULL, 0x042fe20007ffe0ffULL,
0x0000580000057ab9ULL, 0x000fe20000000800ULL, 0x00000060031f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x00000003ff027819ULL, 0x000fe20000011603ULL,
0x00000008071c7824ULL, 0x040fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fe2000001161bULL,
0x00000008071e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc4000001161dULL,
0x00000003ff187819ULL, 0x000fe4000001161fULL, 0x00000007020a7812ULL, 0x000fe400078e4803ULL,
0x0000000706087812ULL, 0x000fe400078e481dULL, 0x0ffffff80a0e7812ULL, 0x000fe400078ef803ULL,
0x0ffffff8080a7812ULL, 0x100fe400078ef81dULL, 0x00000003071a7819ULL, 0x000fe200000006ffULL,
0x0000001019097824ULL, 0x004fe200078e00ffULL, 0xfffffff81e1d7812ULL, 0x000fe200078ee21dULL,
0x000000100e087824ULL, 0x100fe200078e0205ULL, 0x00000004050472a4ULL, 0x010fe2000f8e023fULL,
0x000000100a107824ULL, 0x000fe200078e0205ULL, 0xfffffff009007812ULL, 0x000fe200078ee202ULL,
0x0000001019237824ULL, 0x000fe200078e00ffULL, 0x0000000704027812ULL, 0x000fc400078e481bULL,
0x0000000718097812ULL, 0x000fe200078e481fULL, 0x0000000010107984ULL, 0x000fe20000000c00ULL,
0x0ffffff802027812ULL, 0x000fe400078ef81bULL, 0x0ffffff8090c7812ULL, 0x000fe400078ef81fULL,
0x0000000008087984ULL, 0x000e620000000c00ULL, 0x0000001002027824ULL, 0x100fe200078e0205ULL,
0x0000000400007c10ULL, 0x000fe2000ff1e0ffULL, 0x000000100c147824ULL, 0x000fe200078e0205ULL,
0xfffffff81a217812ULL, 0x000fe200078ee203ULL, 0x0000001019057824ULL, 0x040fe200078e00ffULL,
0x00000000020c7984ULL, 0x0005220000000c00ULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0xfffffff023067812ULL, 0x000fe200078ee206ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0000000014147984ULL, 0x000f620000000c00ULL, 0xfffffff005047812ULL, 0x000fc400078ee204ULL,
0xfffffff019187812ULL, 0x000fe400078ee218ULL, 0x00005a0000027a11ULL, 0x004fe400078040ffULL,
0x0000000406077c10ULL, 0x000fe4000ff3e0ffULL, 0x00005b0000037a11ULL, 0x000fe400000f4403ULL,
0x0000000404057c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000000418007c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001021027825ULL, 0x000fe200078e0002ULL,
0xfffffff81c1b7812ULL, 0x000fc400078ee21bULL, 0x00005a0007067a11ULL, 0x000fe200078240ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x00005a0005047a11ULL, 0x040fe200078040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a0000187a11ULL, 0x000fe400078440ffULL,
0x00005b0005057a11ULL, 0x000fe400000f441cULL, 0x00005b0007077a11ULL, 0x000fe400008f441aULL,
0xfffffff81e1f7812ULL, 0x000fe200078ee21fULL, 0x000000101b047825ULL, 0x000fe200078e0004ULL,
0x00005b0000197a11ULL, 0x000fe200010f4419ULL, 0x0000000802007986ULL, 0x002fe4000c101d06ULL,
0x000000101d067825ULL, 0x000fc800078e0006ULL, 0x000000101f187825ULL, 0x000fe200078e0018ULL,
0x0000000c04007986ULL, 0x010fe8000c101d06ULL, 0x0000001006007986ULL, 0x000fe8000c101d06ULL,
0x0000001418007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x03ffffff8f007812ULL, 0x000fe200078ec0ffULL, 0xffffffffff8b7424ULL, 0x000fc600078e00ffULL,
0x00000000918d7211ULL, 0x000fc800078e10ffULL, 0x0000008c8d00720cULL, 0x000fe40003f06070ULL,
0x0000000191057810ULL, 0x012fd60007ffe0ffULL, 0x0000000288028824ULL, 0x000fc800078e00ffULL,
0x0000640002028a24ULL, 0x000fc800078e028dULL, 0x0000600002028625ULL, 0x000fca00078e0009ULL,
0x00000006028b8981ULL, 0x000362000c1e1900ULL, 0x0000008a0500720cULL, 0x000fe20003f06070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x0000004010107824ULL, 0x000fe400078e00ffULL,
0x000000408f897824ULL, 0x000fd200078e00ffULL, 0x00000cc000008947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x002e620000000000ULL, 0x0000010091037824ULL, 0x000fe200078e0289ULL,
0x000010008f1a7811ULL, 0x000fe200078e70ffULL, 0x000000048b197e24ULL, 0x020fc6000f8e0210ULL,
0x000000038e027217ULL, 0x000fca0007800000ULL, 0x0000000102187824ULL, 0x000fe200078e0a03ULL,
0x00000003ff217819ULL, 0x002fc80000011600ULL, 0x0000000421057810ULL, 0x040fe40007ffe0ffULL,
0x0000000c21097810ULL, 0x000fe40007ffe0ffULL, 0x0000000005047212ULL, 0x040fe200078e3cffULL,
0x00000008051d7824ULL, 0x000fe200078e00ffULL, 0x00000010210b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809067824ULL, 0x000fe200078e00ffULL, 0x0000000821077810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81d1d7812ULL, 0x000fc400078ee204ULL, 0x0000000009037212ULL, 0x080fe200078e3cffULL,
0x00000008071f7824ULL, 0x000fe200078e00ffULL, 0x0000001421117810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0x000000000b047212ULL, 0x040fe400078e3cffULL,
0x000000030b257819ULL, 0x000fe400000006ffULL, 0xfffffff806237812ULL, 0x000fe200078ee203ULL,
0x0000000811067824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fc400078ee204ULL,
0x0000000007027212ULL, 0x080fe400078e3cffULL, 0x0000000011037212ULL, 0x000fe400078e3cffULL,
0x0000003f21047812ULL, 0x000fe400078ec0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee202ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0xfffffff806277812ULL, 0x000fe200078ee203ULL,
0x00000100ff037424ULL, 0x000fe200078e00ffULL, 0x0000003f07087812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0219ULL, 0x000000180500720cULL, 0x000fc40003f86070ULL,
0x0000003f05067812ULL, 0x000fe200078ec0ffULL, 0x00005e0004047625ULL, 0x080fe200078e0003ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000003f090a7812ULL, 0x040fe200078ec0ffULL,
0x0000000108087824ULL, 0x100fe200078e0219ULL, 0x000000180900720cULL, 0x000fe20003f06070ULL,
0x0000000106067824ULL, 0x000fe200078e0219ULL, 0x00000004020c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0003ULL, 0x0000003f0b0e7812ULL, 0x000fc400078ec0ffULL,
0x000000180700720cULL, 0x000fe20003fa6070ULL, 0x000000010a047824ULL, 0x000fe200078e0219ULL,
0x0000000802087210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e0605ULL,
0x000000180b00720cULL, 0x000fe20003f46070ULL, 0x00005e0004047625ULL, 0x080fe200078e0003ULL,
0x0000001821177810ULL, 0x040fe40007ffe0ffULL, 0x0000001c212b7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0003ULL, 0x0000000721137812ULL, 0x000fc400078e4800ULL,
0x0000003f2b147812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200018e0609ULL,
0x0000000402107210ULL, 0x000fe20007f7e0ffULL, 0x000000010e0a7824ULL, 0x100fe200078e0219ULL,
0x0000003f11047812ULL, 0x000fe200078ec0ffULL, 0x0000000817297824ULL, 0x040fe200078e00ffULL,
0x00000006020e7210ULL, 0x000fe20007f3e0ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0003ULL,
0x0000003f17067812ULL, 0x000fe400078ec0ffULL, 0x00000007ff0f7210ULL, 0x000fe20000ffe4ffULL,
0x0000000104047824ULL, 0x000fe200078e0219ULL, 0x000000181100720cULL, 0x000fe20003f26070ULL,
0x000000ffff117224ULL, 0x000fe200018e0605ULL, 0x0000000a020a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0003ULL, 0x00000020212d7810ULL, 0x000fc40007ffe0ffULL,
0x0ffffff8131b7812ULL, 0x000fe200078ef800ULL, 0x0000000106067824ULL, 0x000fe200078e0219ULL,
0x0000003f2d167812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x0000000402127210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0003ULL,
0x000000182100720cULL, 0x040fe40003f66070ULL, 0x00000024212f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114047824ULL, 0x000fe200078e0219ULL, 0x000000002d1c7212ULL, 0x000fe200078e3cffULL,
0x000000ffff137224ULL, 0x000fe200030e0605ULL, 0x0000000602147210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fc600078e0003ULL, 0x00000007ff157210ULL, 0x000fe200037fe4ffULL,
0x0000000116067824ULL, 0x000fe200078e0219ULL, 0x0000000402167210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x0000000017047212ULL, 0x000fe200078e3cffULL,
0x00005e0006067625ULL, 0x000fc600078e0003ULL, 0xfffffff829297812ULL, 0x000fe200078ee204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000d901c46ULL,
0x0000003f2f047812ULL, 0x000fe200078ec0ffULL, 0x000000082b1e7824ULL, 0x000fe200078e00ffULL,
0x000000181700720cULL, 0x000fe20003f66070ULL, 0x000000ffff177224ULL, 0x000fe200030e0605ULL,
0x0000000602067210ULL, 0x000fe20007fde0ffULL, 0x0000000104047824ULL, 0x000fe200078e0219ULL,
0x000000000e1d7faeULL, 0x0005e2000e101c46ULL, 0x000000182b00720cULL, 0x040fe40003f86070ULL,
0x00005e0004047625ULL, 0x000fe200078e0003ULL, 0x000000002b0d7212ULL, 0x002fc600078e3cffULL,
0x000000101f1b7824ULL, 0x100fe400078e021aULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x00000004020c7210ULL, 0x000fe20007fde0ffULL, 0x000000082d1f7824ULL, 0x040fe200078e00ffULL,
0x00000000081b7faeULL, 0x0003e2000e901c46ULL, 0x000000182d00720cULL, 0x000fe20003fa6070ULL,
0x00000010230f7824ULL, 0x004fe200078e021aULL, 0xfffffff81e1d7812ULL, 0x000fe400078ee20dULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee21cULL, 0x00000005ff0d7210ULL, 0x000fe200037fe4ffULL,
0x0000001025057824ULL, 0x100fe200078e021aULL, 0x00000000100f7faeULL, 0x0005e2000c101c46ULL,
0x000000101d1d7824ULL, 0x100fe200078e021aULL, 0x0000002821237810ULL, 0x000fe20007ffe0ffULL,
0x0000001027097824ULL, 0x102fe200078e021aULL, 0x000000000a057faeULL, 0x0003e2000d101c46ULL,
0x00000010291b7824ULL, 0x100fe200078e021aULL, 0x0000003021257810ULL, 0x000fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x0000000012097faeULL, 0x0007e2000c901c46ULL,
0x000000002f047212ULL, 0x000fc400078e3cffULL, 0x000000182f00720cULL, 0x000fe20003fc6070ULL,
0x00000000141b7faeULL, 0x0009e2000d901c46ULL, 0x0000002c210f7810ULL, 0x044fe40007ffe0ffULL,
0x0000003421277810ULL, 0x000fe20007ffe0ffULL, 0x00000000161d7faeULL, 0x0005e2000e101c46ULL,
0x000000082f0b7824ULL, 0x002fe200078e00ffULL, 0x0000000023057212ULL, 0x000fe200078e3cffULL,
0x000000080f087824ULL, 0x000fe200078e00ffULL, 0x00000000061f7faeULL, 0x0003e2000e901c46ULL,
0x0000003f250a7812ULL, 0x000fe200078ec0ffULL, 0x00000008270e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee204ULL, 0x0000000825157824ULL, 0x010fe200078e00ffULL,
0x0000003f23047812ULL, 0x000fc400078ec0ffULL, 0x0000001a0b0b7211ULL, 0x000fe400078e20ffULL,
0x0000000027097212ULL, 0x088fe200078e3cffULL, 0x0000000104047824ULL, 0x000fe200078e0219ULL,
0x0000003821297810ULL, 0x000fe20007ffe0ffULL, 0x0000000823067824ULL, 0x002fe200078e00ffULL,
0x000000000c0b7faeULL, 0x0003e2000f101c46ULL, 0xfffffff80e177812ULL, 0x004fe400078ee209ULL,
0x0000003f290e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff806117812ULL, 0x000fe200078ee205ULL,
0x0000001017177824ULL, 0x000fe200078e021aULL, 0x0000000025067212ULL, 0x000fc400078e3cffULL,
0x000000000f057212ULL, 0x000fe200078e3cffULL, 0x0000001011117824ULL, 0x000fe200078e021aULL,
0xfffffff815157812ULL, 0x000fe400078ee206ULL, 0x0000003f0f067812ULL, 0x000fe400078ec0ffULL,
0xfffffff808137812ULL, 0x000fe200078ee205ULL, 0x00005e0004047625ULL, 0x080fe200078e0003ULL,
0x0000003f270c7812ULL, 0x002fe400078ec0ffULL, 0x0000003c21217810ULL, 0x000fe20007ffe0ffULL,
0x0000000106067824ULL, 0x100fe200078e0219ULL, 0x0000000402087210ULL, 0x000fe20007fde0ffULL,
0x000000010a047824ULL, 0x000fe200078e0219ULL, 0x0000003f21107812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0003ULL, 0x000000182300720cULL, 0x000fc40003fa6070ULL,
0x000000180f00720cULL, 0x000fe20003f86070ULL, 0x000000ffff097224ULL, 0x000fe200030e0605ULL,
0x00000006020a7210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x080fe200078e0003ULL,
0x000000182500720cULL, 0x080fe40003f66070ULL, 0x000000182700720cULL, 0x000fe20003f46070ULL,
0x000000010c067824ULL, 0x000fe200078e0219ULL, 0x0000000029127212ULL, 0x040fe200078e3cffULL,
0x000000ffff0b7224ULL, 0x000fe200030e0607ULL, 0x00000004020c7210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0003ULL, 0x000000182900720cULL, 0x000fe20003f26070ULL,
0x0000000008117faeULL, 0x0003e2000e901c46ULL, 0x00000005ff0d7210ULL, 0x000fe200037fe4ffULL,
0x000000010e047824ULL, 0x100fe200078e0219ULL, 0x00000006020e7210ULL, 0x000fe20007fde0ffULL,
0x0000000110107824ULL, 0x000fe200078e0219ULL, 0x000000182100720cULL, 0x040fe20003f06070ULL,
0x00005e0004047625ULL, 0x000fe200078e0003ULL, 0x0000000021007212ULL, 0x000fc600078e3cffULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0x0000000402047210ULL, 0x000fe20007fde0ffULL,
0x0000000829197824ULL, 0x000fe400078e00ffULL, 0x00005e0010067625ULL, 0x000fc600078e0003ULL,
0xfffffff819197812ULL, 0x000fe200078ee212ULL, 0x00000008211b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000000602027210ULL, 0x000fe20007fde0ffULL,
0x0000001013137824ULL, 0x000fe200078e021aULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x0000001015157824ULL, 0x100fe400078e021aULL, 0x0000001019197824ULL, 0x000fe200078e021aULL,
0x0000001a1b1b7211ULL, 0x000fe200078e20ffULL, 0x000000ffff037224ULL, 0x000fe200030e0607ULL,
0x000000000a137faeULL, 0x0003e8000e101c46ULL, 0x000000000c157faeULL, 0x0003e8000d901c46ULL,
0x000000000e177faeULL, 0x0003e8000d101c46ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x00000000021b7faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x002e620000000000ULL, 0x000000048b107e24ULL, 0x020fc4000f8e0210ULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x00000003ff037819ULL, 0x002fc80000011600ULL,
0x0000001403197810ULL, 0x040fe40007ffe0ffULL, 0x0000000403097810ULL, 0x040fe40007ffe0ffULL,
0x00000008030d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819087824ULL, 0x000fe200078e00ffULL,
0x0000000c03117810ULL, 0x000fe20007ffe0ffULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0x0000000019057212ULL, 0x080fe200078e3cffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x0000000009027212ULL, 0x000fe200078e3cffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0x0000002403277810ULL, 0x000fc40007ffe0ffULL, 0x0000001003157810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8081b7812ULL, 0x000fe400078ee205ULL, 0x000000000d047212ULL, 0x080fe200078e3cffULL,
0x0000000815177824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fe400078ee202ULL,
0x0000001c03237810ULL, 0x000fe40007ffe0ffULL, 0x0000000027057212ULL, 0x000fc400078e3cffULL,
0x0000000327087819ULL, 0x000fe200000006ffULL, 0x0000000823337824ULL, 0x000fe200078e00ffULL,
0x00000034032f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000011027212ULL, 0x000fe400078e3cffULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee204ULL, 0x00000018031d7810ULL, 0x040fe40007ffe0ffULL,
0x0000002003257810ULL, 0x000fc40007ffe0ffULL, 0xfffffff808377812ULL, 0x000fe200078ee205ULL,
0x000000082f087824ULL, 0x000fe200078e00ffULL, 0x0000000015047212ULL, 0x080fe200078e3cffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee202ULL,
0x0000000825357824ULL, 0x000fe200078e00ffULL, 0x0000002c032b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000023027212ULL, 0x080fe400078e3cffULL, 0x000000002f057212ULL, 0x000fe200078e3cffULL,
0x000000082b3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fc400078ee204ULL,
0x0000002803297810ULL, 0x040fe40007ffe0ffULL, 0x00000030032d7810ULL, 0x000fe40007ffe0ffULL,
0x000000001d067212ULL, 0x080fe200078e3cffULL, 0x0000000829397824ULL, 0x000fe200078e00ffULL,
0x0000000025047212ULL, 0x000fe200078e3cffULL, 0x000000082d3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe400078ee202ULL, 0xfffffff8083f7812ULL, 0x000fc400078ee205ULL,
0x000000002b027212ULL, 0x000fe400078e3cffULL, 0x0000003f03057812ULL, 0x040fe400078ec0ffULL,
0x0000003803317810ULL, 0x040fe40007ffe0ffULL, 0x0000000703077812ULL, 0x040fe400078e4800ULL,
0x0000003c03037810ULL, 0x000fe20007ffe0ffULL, 0x0000000831417824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee206ULL, 0xfffffff835357812ULL, 0x000fe400078ee204ULL,
0x0000000029067212ULL, 0x080fe400078e3cffULL, 0x000000002d047212ULL, 0x080fe400078e3cffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee202ULL, 0x0000000105027824ULL, 0x000fe200078e0210ULL,
0x0000000003267212ULL, 0x040fe400078e3cffULL, 0x0000003f03057812ULL, 0x040fe200078ec0ffULL,
0x0000000803037824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fc400078ee206ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee204ULL, 0x0000001000047824ULL, 0x000fe200078e00ffULL,
0x0000003f23237812ULL, 0x000fe200078ec0ffULL, 0x0000000105247824ULL, 0x100fe200078e0210ULL,
0x0000000031067212ULL, 0x000fe400078e3cffULL, 0x0000003f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000123147824ULL, 0x000fe200078e0210ULL, 0xfffffff803057812ULL, 0x000fe200078ee226ULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0xfffffff841417812ULL, 0x000fc400078ee206ULL,
0x0ffffff807077812ULL, 0x000fe400078ef800ULL, 0x000010008f067811ULL, 0x000fe400078e70ffULL,
0x0000003f0d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000001009007210ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e0206ULL, 0x0000007004237812ULL, 0x000fe200078ec0ffULL,
0x000000010d087824ULL, 0x000fe200078e0210ULL, 0x0000003f11117812ULL, 0x000fe200078ec0ffULL,
0x0000001035357824ULL, 0x100fe200078e0206ULL, 0x0000003f15157812ULL, 0x000fe200078ec0ffULL,
0x0000001037377824ULL, 0x000fe200078e0206ULL, 0x0000003f25257812ULL, 0x000fe200078ec0ffULL,
0x00000001110a7824ULL, 0x100fe200078e0210ULL, 0x0000003f27277812ULL, 0x000fe200078ec0ffULL,
0x00000001150c7824ULL, 0x100fe200078e0210ULL, 0x0000003f29297812ULL, 0x000fe200078ec0ffULL,
0x0000000125167824ULL, 0x100fe200078e0210ULL, 0x0000003f2d2d7812ULL, 0x000fe200078ec0ffULL,
0x0000000127187824ULL, 0x100fe200078e0210ULL, 0x0000003f2f2f7812ULL, 0x000fe200078ec0ffULL,
0x00000001291a7824ULL, 0x100fe200078e0210ULL, 0x0000003f31317812ULL, 0x000fe200078ec0ffULL,
0x000000012d1e7824ULL, 0x100fe200078e0210ULL, 0x0000003f2b2b7812ULL, 0x000fe200078ec0ffULL,
0x000000012f207824ULL, 0x000fe200078e0210ULL, 0x0000000605437211ULL, 0x000fe200078e20ffULL,
0x00005e0000047625ULL, 0x000fe200078e0021ULL, 0x0000000223027210ULL, 0x000fc40007f1e0ffULL,
0x0000003f19197812ULL, 0x000fe200078ec0ffULL, 0x0000000131227824ULL, 0x000fe200078e0210ULL,
0x000000102b1c7210ULL, 0x000fe20007ffe0ffULL, 0x0000001007257824ULL, 0x100fe200078e0206ULL,
0x0000003f1d1d7812ULL, 0x000fe200078ec0ffULL, 0x000000100b277824ULL, 0x100fe200078e0206ULL,
0x000000061b2f7211ULL, 0x000fe200078e20ffULL, 0x000000100f297824ULL, 0x100fe400078e0206ULL,
0x00000010132b7824ULL, 0x100fe400078e0206ULL, 0x00000010172d7824ULL, 0x000fc400078e0206ULL,
0x000000101f317824ULL, 0x100fe400078e0206ULL, 0x0000001039397824ULL, 0x100fe400078e0206ULL,
0x000000103b3b7824ULL, 0x100fe400078e0206ULL, 0x000000103d3d7824ULL, 0x100fe400078e0206ULL,
0x000000103f3f7824ULL, 0x100fe400078e0206ULL, 0x0000001041417824ULL, 0x000fc400078e0206ULL,
0x00005e0008067625ULL, 0x000fc800078e0021ULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000000423047210ULL, 0x040fe20007f1e0ffULL, 0x00005e000a087625ULL, 0x080fe200078e0021ULL,
0x0000000623067210ULL, 0x040fe40007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002257faeULL, 0x0003e2000b901c46ULL, 0x00005e000c0a7625ULL, 0x000fe200078e0021ULL,
0x0000000823087210ULL, 0x000fc60007f5e0ffULL, 0x00000001190e7824ULL, 0x100fe400078e0210ULL,
0x000000011d127824ULL, 0x000fe400078e0210ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000a230a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e000e0c7625ULL, 0x000fc600078e0021ULL,
0x0000000004277faeULL, 0x0003e2000b901c46ULL, 0x00005e00120e7625ULL, 0x000fc800078e0021ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000e230e7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0607ULL, 0x0000000c230c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0016127625ULL, 0x000fc600078e0021ULL, 0x0000000006297faeULL, 0x0003e2000b901c46ULL,
0x00005e0014107625ULL, 0x000fc800078e0021ULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000001223127210ULL, 0x000fe20007f1e0ffULL, 0x00005e0018147625ULL, 0x000fc800078e0021ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000001023107210ULL, 0x000fe20007f3e0ffULL,
0x00005e001c187625ULL, 0x000fc800078e0021ULL, 0x00005e001a167625ULL, 0x000fc800078e0021ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000001823187210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000001623167210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000001423147210ULL, 0x040fe20007f3e0ffULL,
0x00005e001e1a7625ULL, 0x000fe200078e0021ULL, 0x00000000082b7faeULL, 0x0003e4000b901c46ULL,
0x00000015ff157210ULL, 0x000fe20000ffe4ffULL, 0x00005e00201c7625ULL, 0x080fe200078e0021ULL,
0x000000000a2d7faeULL, 0x0003e6000b901c46ULL, 0x00005e00221e7625ULL, 0x080fe200078e0021ULL,
0x0000001c231c7210ULL, 0x000fe20007f3e0ffULL, 0x000000000c2f7faeULL, 0x0003e4000b901c46ULL,
0x00005e0024207625ULL, 0x000fc400078e0021ULL, 0x000000000e317faeULL, 0x0003e4000b901c46ULL,
0x000000ffff197224ULL, 0x000fe200000e0619ULL, 0x0000001a231a7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000001e231e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000010337faeULL, 0x0003e2000b901c46ULL, 0x0000002023207210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1b7224ULL, 0x000fe400000e061bULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x0000000012357faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fc400010e061fULL,
0x000000ffff217224ULL, 0x000fe200018e0621ULL, 0x0000000014377faeULL, 0x0003e8000b901c46ULL,
0x0000000016397faeULL, 0x0003e8000b901c46ULL, 0x00000000183b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a3d7faeULL, 0x0003e8000b901c46ULL, 0x000000001c3f7faeULL, 0x0003e8000b901c46ULL,
0x000000001e417faeULL, 0x0003e8000b901c46ULL, 0x0000000020437faeULL, 0x0003e4000b901c46ULL,
0x02360400ff007984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0022a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x02360400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000008a9100720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000007d7919ULL, 0x000ea20000000000ULL,
0x00005800ff7e7624ULL, 0x000fe200078e00ffULL, 0xffffffff8a867810ULL, 0x000fe20007ffe0ffULL,
0x0000640088887a24ULL, 0x000fe200078e02ffULL, 0x00007610ff857816ULL, 0x000fe20000000085ULL,
0x000000108f877824ULL, 0x000fe200078e00ffULL, 0x000000067e7e7819ULL, 0x000fe400000006ffULL,
0x00000100917f7824ULL, 0x000fe200078e0289ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000007f8e00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x002fea0003800000ULL,
0x0000000191037810ULL, 0x002fe20007ffe0ffULL, 0x0000165000007945ULL, 0x000fe60003800000ULL,
0x0000008a0300720cULL, 0x000fda0003f06070ULL, 0x00000ba000008947ULL, 0x000fea0003800000ULL,
0x00000003ff7c7819ULL, 0x004fe2000001167dULL, 0x000000047e187e24ULL, 0x000fe2000f8e028bULL,
0x8000007f8e137210ULL, 0x000fe20007ffe0ffULL, 0x00000100ff7a7424ULL, 0x000fe200078e00ffULL,
0x000000087c757810ULL, 0x040fe40007ffe0ffULL, 0x0000000c7c727810ULL, 0x040fe40007ffe0ffULL,
0x000000047c787810ULL, 0x000fe20007ffe0ffULL, 0x0000000875007824ULL, 0x040fe200078e00ffULL,
0x0000007d75737212ULL, 0x000fe200078e3cffULL, 0x0000000872057824ULL, 0x000fe200078e00ffULL,
0x000000187c697810ULL, 0x000fe20007ffe0ffULL, 0x0000000878037824ULL, 0x000fe200078e00ffULL,
0x000000107c6f7810ULL, 0x000fc40007ffe0ffULL, 0x0000007d72707212ULL, 0x080fe200078e3cffULL,
0x0000000869047824ULL, 0x000fe200078e00ffULL, 0xfffffff800737812ULL, 0x000fe200078ee273ULL,
0x000000086f027824ULL, 0x000fe200078e00ffULL, 0x000000147c6c7810ULL, 0x040fe40007ffe0ffULL,
0x000000207c007810ULL, 0x000fe40007ffe0ffULL, 0x0000007d78767212ULL, 0x080fe400078e3cffULL,
0x0000007d69677212ULL, 0x000fe200078e3cffULL, 0x0000000800067824ULL, 0x000fe200078e00ffULL,
0xfffffff805707812ULL, 0x000fe200078ee270ULL, 0x000000086c057824ULL, 0x000fe200078e00ffULL,
0x0000001c7c667810ULL, 0x000fc40007ffe0ffULL, 0x0000007d6f6d7212ULL, 0x080fe400078e3cffULL,
0xfffffff803767812ULL, 0x000fe200078ee276ULL, 0x0000000866077824ULL, 0x000fe200078e00ffULL,
0x0000007d6c6a7212ULL, 0x080fe400078e3cffULL, 0x0000003f7c7b7812ULL, 0x000fe400078ec0ffULL,
0x0000007d00037212ULL, 0x000fe400078e3cffULL, 0xfffffff804677812ULL, 0x000fc400078ee267ULL,
0x0000007d7c047212ULL, 0x080fe400078e3cffULL, 0xfffffff8026d7812ULL, 0x000fe400078ee26dULL,
0x0000007d66027212ULL, 0x000fe400078e3cffULL, 0xfffffff8056a7812ULL, 0x000fe200078ee26aULL,
0x000000017b057824ULL, 0x000fe200078e0218ULL, 0x0000003f78777812ULL, 0x000fe400078ec0ffULL,
0xfffffff806037812ULL, 0x000fc400078ee203ULL, 0x0000003f75747812ULL, 0x000fe400078ec0ffULL,
0x000000077d367812ULL, 0x000fe400078ec0ffULL, 0x0000000704067812ULL, 0x000fe200078ec0ffULL,
0x00005e0005047625ULL, 0x000fe200078e007aULL, 0x000000137c00720cULL, 0x000fe40003f06070ULL,
0xfffffff807027812ULL, 0x000fe200078ee202ULL, 0x0000000177077824ULL, 0x100fe200078e0218ULL,
0x0000003f72717812ULL, 0x000fe200078ec0ffULL, 0x0000000174097824ULL, 0x000fe200078e0218ULL,
0x000030008f1c7811ULL, 0x000fc400078e70ffULL, 0x00000008361d7812ULL, 0x000fe200078efcffULL,
0x00000001710b7824ULL, 0x000fe200078e0218ULL, 0x0ffffff806797812ULL, 0x000fe200078ef87dULL,
0x00005e0007067625ULL, 0x080fe200078e007aULL, 0x000000137800720cULL, 0x080fe40003f26070ULL,
0x000000137500720cULL, 0x080fe20003f46070ULL, 0x00005e0009087625ULL, 0x000fe200078e007aULL,
0x0000003f6f6e7812ULL, 0x000fe400078ec0ffULL, 0x000000137200720cULL, 0x000fe20003f66070ULL,
0x000000101d047825ULL, 0x000fe200078e0004ULL, 0x0000003f6c6b7812ULL, 0x000fc400078ec0ffULL,
0x0000003f69687812ULL, 0x000fe200078ec0ffULL, 0x00000010790f7824ULL, 0x100fe200078e021cULL,
0x000000136f00720cULL, 0x080fe20003f86070ULL, 0x00005e000b0a7625ULL, 0x000fe200078e007aULL,
0x0000003f66657812ULL, 0x000fe400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e2000c101c46ULL, 0x0000001076117824ULL, 0x000fe200078e021cULL,
0x0000001c70177211ULL, 0x000fe200078e20ffULL, 0x000000101d067825ULL, 0x000fe200078e0006ULL,
0x000000136c00720cULL, 0x000fc60003f06070ULL, 0x000000016e0d7824ULL, 0x000fe200078e0218ULL,
0x0000000006117faeULL, 0x0005e2000c901c46ULL, 0x0000001073157824ULL, 0x000fe200078e021cULL,
0x000000136900720cULL, 0x000fe20003f26070ULL, 0x000000101d087825ULL, 0x000fe200078e0008ULL,
0x0000003f00047812ULL, 0x002fc600078ec0ffULL, 0x000000016b057824ULL, 0x000fe200078e0218ULL,
0x0000000008157faeULL, 0x0003e2000d101c46ULL, 0x00005e000d0c7625ULL, 0x000fe200078e007aULL,
0x000000136600720cULL, 0x000fc60003f46070ULL, 0x000000101d0a7825ULL, 0x000fc800078e000aULL,
0x00005e0005067625ULL, 0x004fe200078e007aULL, 0x000000000a177faeULL, 0x0005e2000d901c46ULL,
0x000000130000720cULL, 0x000fe40003f66070ULL, 0x0000000168097824ULL, 0x102fe400078e0218ULL,
0x00000001650f7824ULL, 0x100fe400078e0218ULL, 0x0000000104057824ULL, 0x000fe400078e0218ULL,
0x000000106d197824ULL, 0x000fc400078e021cULL, 0x000000101d0c7825ULL, 0x000fc800078e000cULL,
0x00005e0009087625ULL, 0x080fe200078e007aULL, 0x000000000c197faeULL, 0x0003e6000e101c46ULL,
0x00005e000f0e7625ULL, 0x000fc800078e007aULL, 0x000000101d0a7825ULL, 0x004fc800078e0006ULL,
0x00005e0005067625ULL, 0x000fe200078e007aULL, 0x000000247c057810ULL, 0x000fc60007ffe0ffULL,
0x000000106a157824ULL, 0x100fe400078e021cULL, 0x0000001067177824ULL, 0x000fe400078e021cULL,
0x000000101d0c7825ULL, 0x042fe200078e0008ULL, 0x000000000a157faeULL, 0x0003e2000c101c46ULL,
0x000000307c087810ULL, 0x000fe40007ffe0ffULL, 0x0000001002197824ULL, 0x000fe200078e021cULL,
0x000000000c177faeULL, 0x0005e2000c901c46ULL, 0x000000101d0e7825ULL, 0x000fe200078e000eULL,
0x000000347c097810ULL, 0x000fc40007ffe0ffULL, 0x000000130500720cULL, 0x000fe20003f06070ULL,
0x00000010031b7824ULL, 0x000fe200078e021cULL, 0x000000000e197faeULL, 0x0007e2000d101c46ULL,
0x000000101d107825ULL, 0x000fe200078e0006ULL, 0x000000287c067810ULL, 0x040fe40007ffe0ffULL,
0x0000002c7c077810ULL, 0x000fe20007ffe0ffULL, 0x0000000808147824ULL, 0x000fe200078e00ffULL,
0x00000000101b7faeULL, 0x0009e2000d901c46ULL, 0x000000387c0a7810ULL, 0x042fe40007ffe0ffULL,
0x0000003c7c0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000007d050c7212ULL, 0x0c4fe200078e3cffULL,
0x000000080a167824ULL, 0x000fe200078e00ffULL, 0x00000003050f7819ULL, 0x008fe200000006ffULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0x0000007d060d7212ULL, 0x0c0fe400078e3cffULL,
0x0000007d070e7212ULL, 0x040fe200078e3cffULL, 0x0000000806107824ULL, 0x050fe200078e00ffULL,
0x000000130600720cULL, 0x080fe20003f26070ULL, 0x0000000807117824ULL, 0x040fe200078e00ffULL,
0x000000130700720cULL, 0x000fc40003f46070ULL, 0x000000130800720cULL, 0x080fe40003f66070ULL,
0x000000130900720cULL, 0x080fe40003f86070ULL, 0x000000130a00720cULL, 0x080fe40003fa6070ULL,
0x000000130b00720cULL, 0x000fe20003fc6070ULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0c7812ULL, 0x000fe400078ee20cULL, 0xfffffff8100d7812ULL, 0x000fc400078ee20dULL,
0xfffffff8110e7812ULL, 0x000fe200078ee20eULL, 0x000000100c2d7824ULL, 0x100fe200078e021cULL,
0x0000007d080f7212ULL, 0x080fe200078e3cffULL, 0x000000100d2f7824ULL, 0x000fe200078e021cULL,
0x0000007d09107212ULL, 0x080fe400078e3cffULL, 0x0000007d0a117212ULL, 0x080fe400078e3cffULL,
0x0000007d0b127212ULL, 0x000fe400078e3cffULL, 0xfffffff8140f7812ULL, 0x000fc400078ee20fULL,
0xfffffff813107812ULL, 0x000fe400078ee210ULL, 0xfffffff816117812ULL, 0x000fe400078ee211ULL,
0xfffffff815127812ULL, 0x000fe400078ee212ULL, 0x0000003f05137812ULL, 0x000fe200078ec0ffULL,
0x0000001011317824ULL, 0x000fe200078e021cULL, 0x0000003f06147812ULL, 0x000fe400078ec0ffULL,
0x0000003f07157812ULL, 0x000fe200078ec0ffULL, 0x0000000113197824ULL, 0x100fe200078e0218ULL,
0x0000003f08167812ULL, 0x000fe200078ec0ffULL, 0x00000001141b7824ULL, 0x100fe200078e0218ULL,
0x0000003f09177812ULL, 0x000fe200078ec0ffULL, 0x0000000115237824ULL, 0x000fe200078e0218ULL,
0x0000003f0a607812ULL, 0x000fe200078ec0ffULL, 0x00005e001b1a7625ULL, 0x000fe200078e007aULL,
0x0000003f0b617812ULL, 0x000fc400078ec0ffULL, 0x0000001816257210ULL, 0x000fe20007ffe0ffULL,
0x0000000117277824ULL, 0x100fe200078e0218ULL, 0x0000001c12337211ULL, 0x000fe200078e20ffULL,
0x0000000160297824ULL, 0x100fe400078e0218ULL, 0x00000001612b7824ULL, 0x000fe400078e0218ULL,
0x00005e0019187625ULL, 0x000fc800078e007aULL, 0x00005e0023227625ULL, 0x000fc800078e007aULL,
0x00005e0025247625ULL, 0x000fc800078e007aULL, 0x00005e0027267625ULL, 0x000fc800078e007aULL,
0x00005e0029287625ULL, 0x000fc800078e007aULL, 0x00005e002b2a7625ULL, 0x000fc800078e007aULL,
0x000000101d1e7825ULL, 0x000fc800078e0018ULL, 0x000000101d207825ULL, 0x040fe200078e001aULL,
0x000000001e2d7faeULL, 0x0003e6000c101c46ULL, 0x000000101d187825ULL, 0x040fe200078e0022ULL,
0x00000000202f7faeULL, 0x0003e6000c901c46ULL, 0x000000101d1a7825ULL, 0x000fc800078e0024ULL,
0x000000101d267825ULL, 0x000fc800078e0026ULL, 0x000000101d287825ULL, 0x000fc800078e0028ULL,
0x000000101d2a7825ULL, 0x000fc800078e002aULL, 0x000000100e1d7824ULL, 0x100fe400078e021cULL,
0x000000100f237824ULL, 0x100fe400078e021cULL, 0x0000001010257824ULL, 0x000fe200078e021cULL,
0x00000000181d7faeULL, 0x0003e8000d101c46ULL, 0x000000001a237faeULL, 0x0003e8000d901c46ULL,
0x0000000026257faeULL, 0x0003e8000e101c46ULL, 0x0000000028317faeULL, 0x0003e8000e901c46ULL,
0x000000002a337faeULL, 0x0003e2000f101c46ULL, 0x00000a8000007947ULL, 0x000fea0003800000ULL,
0x00000003ff7c7819ULL, 0x004fe2000001167dULL, 0x000000047e187e24ULL, 0x000fe2000f8e028bULL,
0x000000077d367812ULL, 0x000fe200078ec0ffULL, 0x00000100ff7a7424ULL, 0x000fe200078e00ffULL,
0x000000087c757810ULL, 0x000fc40007ffe0ffULL, 0x000000047c787810ULL, 0x040fe40007ffe0ffULL,
0x0000007d75737212ULL, 0x0c0fe200078e3cffULL, 0x0000000875007824ULL, 0x000fe200078e00ffULL,
0x000000107c6f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000878037824ULL, 0x000fe200078e00ffULL,
0x0000000c7c727810ULL, 0x000fe40007ffe0ffULL, 0xfffffff800737812ULL, 0x000fe200078ee273ULL,
0x000000086f007824ULL, 0x000fe200078e00ffULL, 0x000000187c697810ULL, 0x000fe20007ffe0ffULL,
0x0000000872057824ULL, 0x000fe200078e00ffULL, 0x0000007d78767212ULL, 0x000fc400078e3cffULL,
0x000000147c6c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000869047824ULL, 0x000fe200078e00ffULL,
0x0000007d6f6d7212ULL, 0x080fe400078e3cffULL, 0x0000007d72707212ULL, 0x000fe400078e3cffULL,
0x0000001c7c667810ULL, 0x000fe40007ffe0ffULL, 0xfffffff803767812ULL, 0x000fe200078ee276ULL,
0x000000086c037824ULL, 0x000fe200078e00ffULL, 0xfffffff8006d7812ULL, 0x000fc400078ee26dULL,
0xfffffff805707812ULL, 0x000fe200078ee270ULL, 0x0000000866057824ULL, 0x000fe200078e00ffULL,
0x0000007d69677212ULL, 0x080fe400078e3cffULL, 0x000000207c007810ULL, 0x000fe40007ffe0ffULL,
0x0000007d6c6a7212ULL, 0x080fe400078e3cffULL, 0x0000007d66027212ULL, 0x000fe400078e3cffULL,
0xfffffff804677812ULL, 0x000fe200078ee267ULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8036a7812ULL, 0x000fc400078ee26aULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000007d00037212ULL, 0x080fe400078e3cffULL, 0x000000247c057810ULL, 0x040fe40007ffe0ffULL,
0x0000002c7c077810ULL, 0x040fe40007ffe0ffULL, 0x0000003f7c7b7812ULL, 0x040fe200078ec0ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x000000287c067810ULL, 0x000fe20007ffe0ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0xfffffff804037812ULL, 0x000fe200078ee203ULL,
0x000000017b117824ULL, 0x000fe200078e0218ULL, 0x0000007d7c047212ULL, 0x000fc400078e3cffULL,
0x0000007d050c7212ULL, 0x080fe200078e3cffULL, 0x00005e0011107625ULL, 0x000fe200078e007aULL,
0x0000007d060d7212ULL, 0x0c0fe400078e3cffULL, 0x0000000306087819ULL, 0x000fe400000006ffULL,
0x0000007d070e7212ULL, 0x000fe400078e3cffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0xfffffff8090c7812ULL, 0x000fc400078ee20cULL, 0xfffffff8080d7812ULL, 0x000fe400078ee20dULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x000000347c097810ULL, 0x000fe40007ffe0ffULL,
0x000030008f377811ULL, 0x000fe400078e70ffULL, 0x0000000836397812ULL, 0x000fe200078efcffULL,
0x0000000809197824ULL, 0x000fe200078e00ffULL, 0x000000307c087810ULL, 0x040fe20007ffe0ffULL,
0x00000010733b7824ULL, 0x000fe200078e0237ULL, 0x000000387c0a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001039167825ULL, 0x000fe200078e0010ULL, 0x0000003c7c0b7810ULL, 0x000fc40007ffe0ffULL,
0x0ffffff804797812ULL, 0x000fe200078ef87dULL, 0x0000000808147824ULL, 0x000fe200078e00ffULL,
0x0000007d09127212ULL, 0x080fe200078e3cffULL, 0x000000080a1a7824ULL, 0x000fe200078e00ffULL,
0x0000007d080f7212ULL, 0x080fe200078e3cffULL, 0x000000080b1b7824ULL, 0x000fe200078e00ffULL,
0x0000007d0a137212ULL, 0x080fe200078e3cffULL, 0x0000001079157824ULL, 0x100fe200078e0237ULL,
0x0000007d0b047212ULL, 0x000fe200078e3cffULL, 0x00000010703d7824ULL, 0x100fe200078e0237ULL,
0xfffffff819107812ULL, 0x000fe200078ee212ULL, 0x000000106d3f7824ULL, 0x000fe200078e0237ULL,
0xfffffff8140f7812ULL, 0x000fe200078ee20fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016157faeULL, 0x0003e2000b901c46ULL, 0xfffffff81a117812ULL, 0x000fe200078ee213ULL,
0x000000106a417824ULL, 0x100fe200078e0237ULL, 0xfffffff81b127812ULL, 0x000fe200078ee204ULL,
0x0000001067437824ULL, 0x100fe200078e0237ULL, 0x0000003f78777812ULL, 0x000fe200078ec0ffULL,
0x0000001003477824ULL, 0x100fe200078e0237ULL, 0x0000003f75747812ULL, 0x000fe200078ec0ffULL,
0x000000100c497824ULL, 0x100fe200078e0237ULL, 0x0000003f72717812ULL, 0x000fe200078ec0ffULL,
0x0000000177237824ULL, 0x100fe200078e0218ULL, 0x0000003f6f6e7812ULL, 0x000fe200078ec0ffULL,
0x000000100d4b7824ULL, 0x000fe200078e0237ULL, 0x0000003f6c6b7812ULL, 0x000fe200078ec0ffULL,
0x0000000171277824ULL, 0x100fe200078e0218ULL, 0x0000003f69687812ULL, 0x000fe200078ec0ffULL,
0x000000016e297824ULL, 0x100fe200078e0218ULL, 0x0000003f66657812ULL, 0x000fe200078ec0ffULL,
0x000000016b2b7824ULL, 0x100fe200078e0218ULL, 0x0000003f00047812ULL, 0x000fe200078ec0ffULL,
0x00000001682f7824ULL, 0x100fe200078e0218ULL, 0x0000003f05137812ULL, 0x000fe200078ec0ffULL,
0x0000000165337824ULL, 0x100fe200078e0218ULL, 0x0000003f06147812ULL, 0x000fe200078ec0ffULL,
0x0000000104357824ULL, 0x100fe200078e0218ULL, 0x0000003f07157812ULL, 0x002fe200078ec0ffULL,
0x0000000113317824ULL, 0x100fe200078e0218ULL, 0x0000003f08167812ULL, 0x000fe200078ec0ffULL,
0x00000001142d7824ULL, 0x100fe200078e0218ULL, 0x0000003f09177812ULL, 0x000fe200078ec0ffULL,
0x0000000115197824ULL, 0x000fe200078e0218ULL, 0x0000003f0a607812ULL, 0x000fe200078ec0ffULL,
0x00005e0023227625ULL, 0x000fe200078e007aULL, 0x0000003f0b617812ULL, 0x000fc400078ec0ffULL,
0x0000001874257210ULL, 0x080fe20007ffe0ffULL, 0x00000001171d7824ULL, 0x100fe200078e0218ULL,
0x00000018161b7210ULL, 0x000fe20007ffe0ffULL, 0x00000001601f7824ULL, 0x100fe200078e0218ULL,
0x0000003702457211ULL, 0x000fe200078e20ffULL, 0x0000000161217824ULL, 0x000fe400078e0218ULL,
0x00005e0025247625ULL, 0x000fc800078e007aULL, 0x00005e0027267625ULL, 0x000fc800078e007aULL,
0x00005e0029287625ULL, 0x000fc800078e007aULL, 0x00005e002b2a7625ULL, 0x000fc800078e007aULL,
0x00005e002f2e7625ULL, 0x000fc800078e007aULL, 0x00005e0033327625ULL, 0x000fc800078e007aULL,
0x00005e0035347625ULL, 0x000fc800078e007aULL, 0x00005e0031307625ULL, 0x000fc800078e007aULL,
0x00005e002d2c7625ULL, 0x000fc800078e007aULL, 0x00005e0019187625ULL, 0x000fc800078e007aULL,
0x00005e001b1a7625ULL, 0x000fc800078e007aULL, 0x00005e001d1c7625ULL, 0x000fc800078e007aULL,
0x00005e001f1e7625ULL, 0x000fc800078e007aULL, 0x00005e0021207625ULL, 0x000fc800078e007aULL,
0x0000001039227825ULL, 0x000fc800078e0022ULL, 0x0000001039247825ULL, 0x000fc800078e0024ULL,
0x0000001039267825ULL, 0x000fc800078e0026ULL, 0x0000001039287825ULL, 0x000fc800078e0028ULL,
0x00000010392a7825ULL, 0x000fc800078e002aULL, 0x00000010392e7825ULL, 0x000fc800078e002eULL,
0x0000001039327825ULL, 0x000fc800078e0032ULL, 0x0000001039347825ULL, 0x000fc800078e0034ULL,
0x0000001039307825ULL, 0x000fc800078e0030ULL, 0x00000010392c7825ULL, 0x000fc800078e002cULL,
0x0000001039187825ULL, 0x000fc800078e0018ULL, 0x00000010391a7825ULL, 0x000fc800078e001aULL,
0x00000010391c7825ULL, 0x000fc800078e001cULL, 0x00000010391e7825ULL, 0x000fc800078e001eULL,
0x0000001039207825ULL, 0x000fc800078e0020ULL, 0x0000001076397824ULL, 0x000fca00078e0237ULL,
0x0000000022397faeULL, 0x0003e8000b901c46ULL, 0x00000000243b7faeULL, 0x0005e8000b901c46ULL,
0x00000000263d7faeULL, 0x0007e8000b901c46ULL, 0x00000000283f7faeULL, 0x0009e2000b901c46ULL,
0x000000100e237824ULL, 0x002fc600078e0237ULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x000000100f257824ULL, 0x004fc600078e0237ULL, 0x000000002e437faeULL, 0x0003e2000b901c46ULL,
0x0000001010277824ULL, 0x008fc600078e0237ULL, 0x0000000032457faeULL, 0x0003e2000b901c46ULL,
0x0000001011297824ULL, 0x110fe400078e0237ULL, 0x0000001012377824ULL, 0x000fe200078e0237ULL,
0x0000000034477faeULL, 0x0003e8000b901c46ULL, 0x0000000030497faeULL, 0x0003e8000b901c46ULL,
0x000000002c4b7faeULL, 0x0003e8000b901c46ULL, 0x0000000018237faeULL, 0x0003e8000b901c46ULL,
0x000000001a257faeULL, 0x0003e8000b901c46ULL, 0x000000001c277faeULL, 0x0003e8000b901c46ULL,
0x000000001e297faeULL, 0x0003e8000b901c46ULL, 0x0000000020377faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff197424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff8b7424ULL, 0x000fc400078e00ffULL,
0x00000300198d7a24ULL, 0x000fca00078e028dULL, 0x0000008c8d00720cULL, 0x000fda0003f06070ULL,
0x0000008d88188211ULL, 0x000fe400078e08ffULL, 0x00000004ff627819ULL, 0x000fe2000001167dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600018188625ULL, 0x000fca00078e0019ULL,
0x00000006188b8981ULL, 0x000362000c1e1900ULL, 0x0000000836637812ULL, 0x000fe200078ef87dULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x00000007621a7812ULL, 0x000fca00078e7863ULL,
0x00000010631a7824ULL, 0x000fc800078e021aULL, 0x000000101a1a7824ULL, 0x000fe400078e00ffULL,
0x0000000862197824ULL, 0x042fe200078e00ffULL, 0x0000000262207810ULL, 0x000fe20007ffe0ffULL,
0x000040008f647824ULL, 0x000fe200078e00ffULL, 0x000000017c407812ULL, 0x000fe200078ec0ffULL,
0x0000162000007945ULL, 0x000fe20003800000ULL, 0xfffffff819187812ULL, 0x000fe400078ee236ULL,
0x0000100064837810ULL, 0x000fe20007ffe0ffULL, 0x000000001a34783bULL, 0x000fe20000000200ULL,
0x0000000718477812ULL, 0x040fe200078ec0ffULL, 0x0000000818987824ULL, 0x040fe200078e00ffULL,
0x0000001018937810ULL, 0x000fc40007ffe0ffULL, 0x0000000147197812ULL, 0x000fe400078e787cULL,
0x0000000793457812ULL, 0x040fe200078ec0ffULL, 0x0000000893937824ULL, 0x000fe200078e00ffULL,
0x0000009819847212ULL, 0x000fe400078efcffULL, 0x0000000720207812ULL, 0x000fe400078e7863ULL,
0x0000002018a47810ULL, 0x000fe20007ffe0ffULL, 0x00000010841c7824ULL, 0x000fe200078e0283ULL,
0x00000002471b7812ULL, 0x000fe200078e1e40ULL, 0x0000001063197824ULL, 0x000fe200078e0220ULL,
0x0000000145827812ULL, 0x000fc400078e787cULL, 0x00000007a4437812ULL, 0x040fe200078ec0ffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x000000981b807212ULL, 0x000fe200078efcffULL,
0x00000008a4a47824ULL, 0x000fe200078e00ffULL, 0x0000003018187810ULL, 0x000fe20007ffe0ffULL,
0x0000001019197824ULL, 0x000fe200078e00ffULL, 0x0000009382827212ULL, 0x000fe400078efcffULL,
0x0000000143817812ULL, 0x000fe200078e787cULL, 0x0000000818a27824ULL, 0x000fe200078e00ffULL,
0x0000008380587211ULL, 0x000fe200078e20ffULL, 0x00000010823c7824ULL, 0x000fe200078e0283ULL,
0x0000000718417812ULL, 0x000fe200078ec0ffULL, 0x000000001930783bULL, 0x0005e20000000200ULL,
0x000000a481817212ULL, 0x000fc400078efcffULL, 0x0000000245927812ULL, 0x100fe200078e1e40ULL,
0x000000005858783bULL, 0x000ee20000000200ULL, 0x0000000243257812ULL, 0x000fe200078e1e40ULL,
0x0000001081187824ULL, 0x100fe200078e0283ULL, 0x0000009392927212ULL, 0x000fe200078efcffULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x0000000141197812ULL, 0x004fe400078e787cULL,
0x000000a425947212ULL, 0x000fe200078efcffULL, 0x0000001092207824ULL, 0x000fe200078e0283ULL,
0x000000a219907212ULL, 0x000fc400078efcffULL, 0x000000001818783bULL, 0x000ea20000000200ULL,
0x0000001094287824ULL, 0x100fe200078e0283ULL, 0x00000004459e7812ULL, 0x000fe200078e1e40ULL,
0x0000001090387824ULL, 0x100fe200078e0283ULL, 0x000000002020783bULL, 0x000fe40000000200ULL,
0x000000939e9e7212ULL, 0x000fe400078efcffULL, 0x000000002828783bULL, 0x000fe60000000200ULL,
0x000000109e547824ULL, 0x000fe200078e0283ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000001c345c723cULL, 0x042fe800000418ffULL, 0x000000005454783bULL, 0x000fe80000000200ULL,
0x0000001e341c723cULL, 0x000fde00000418ffULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000058305c723cULL, 0x048ff0000004185cULL, 0x0000005a3058723cULL, 0x000ff0000004181cULL,
0x0000003c341c723cULL, 0x050ff000000418ffULL, 0x0000003e343c723cULL, 0x040ff000000418ffULL,
0x000000183424723cULL, 0x044ff000000418ffULL, 0x0000001a3418723cULL, 0x040ff000000418ffULL,
0x00000038342c723cULL, 0x000fee00000418ffULL, 0x0000000241397812ULL, 0x000fe200078e1e40ULL,
0x00000020301c723cULL, 0x000fe6000004181cULL, 0x000000a239967212ULL, 0x000fca00078efcffULL,
0x0000001096387824ULL, 0x000fe200078e0283ULL, 0x000000223020723cULL, 0x000fee000004183cULL,
0x00000004623c7810ULL, 0x040fe20007ffe0ffULL, 0x0000003a3434723cULL, 0x000fe200000418ffULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x00000006623e7810ULL, 0x000fc80007ffe0ffULL,
0x000000073e3e7812ULL, 0x000fe400078e7863ULL, 0x000000283024723cULL, 0x000fe60000041824ULL,
0x00000010633e7824ULL, 0x000fc800078e023eULL, 0x000000073c287812ULL, 0x000fe200078e7863ULL,
0x000000103e957824ULL, 0x000fc600078e00ffULL, 0x00000028633c7211ULL, 0x000fe400078e20ffULL,
0x0000002a3028723cULL, 0x000fe60000041818ULL, 0x000000103c3c7824ULL, 0x000fc800078e00ffULL,
0x0000000447197812ULL, 0x100fe200078e1e40ULL, 0x000000003c48783bULL, 0x0004e20000000200ULL,
0x00000004431b7812ULL, 0x100fe400078e1e40ULL, 0x0000009819a07212ULL, 0x000fe400078efcffULL,
0x0000000441197812ULL, 0x140fe400078e1e40ULL, 0x0000000641417812ULL, 0x000fe200078e1e40ULL,
0x00000010a0187824ULL, 0x000fe200078e0283ULL, 0x000000a2199a7212ULL, 0x000fc400078efcffULL,
0x000000a41b9c7212ULL, 0x000fe200078efcffULL, 0x00000038302c723cULL, 0x042fe2000004182cULL,
0x000000a241a27212ULL, 0x000fe200078efcffULL, 0x000000109a4c7824ULL, 0x100fe200078e0283ULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x000000109c507824ULL, 0x000fe200078e0283ULL,
0x0000000647477812ULL, 0x100fe400078e1e40ULL, 0x0000000645387812ULL, 0x100fe200078e1e40ULL,
0x000000004c4c783bULL, 0x000f220000000200ULL, 0x0000003a3030723cULL, 0x000fe20000041834ULL,
0x0000000643437812ULL, 0x000fc400078e1e40ULL, 0x0000009338937212ULL, 0x000fe200078efcffULL,
0x00000010a2387824ULL, 0x100fe200078e0283ULL, 0x000000005050783bULL, 0x000f220000000200ULL,
0x0000009847987212ULL, 0x000fe400078efcffULL, 0x000000a443a47212ULL, 0x000fe200078efcffULL,
0x000000009534783bULL, 0x000fe20000000200ULL, 0x0000001093407824ULL, 0x100fe400078e0283ULL,
0x0000001098447824ULL, 0x000fe200078e0283ULL, 0x000000003838783bULL, 0x000f220000000200ULL,
0x00000083a43c7211ULL, 0x004fc600078e20ffULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x00000054481c723cULL, 0x048fe6000004181cULL, 0x000000004444783bULL, 0x000ea80000000200ULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x000000564820723cULL, 0x040ff00000041820ULL,
0x00000018485c723cULL, 0x042ff0000004185cULL, 0x0000004c482c723cULL, 0x050ff0000004182cULL,
0x0000001a4858723cULL, 0x040ff00000041858ULL, 0x000000504824723cULL, 0x040ff00000041824ULL,
0x000000524828723cULL, 0x040ff00000041828ULL, 0x0000004e4830723cULL, 0x000ff00000041830ULL,
0x00000038342c723cULL, 0x040fee000004182cULL, 0x0000030091387a10ULL, 0x000fe20007ffe0ffULL,
0x00000044345c723cULL, 0x004fe6000004185cULL, 0x0000000138197810ULL, 0x000fc80007ffe0ffULL,
0x0000008a1900720cULL, 0x000fe20003f06070ULL, 0x000000463458723cULL, 0x040ff00000041858ULL,
0x00000040341c723cULL, 0x040ff0000004181cULL, 0x000000423420723cULL, 0x040ff00000041820ULL,
0x0000003c3424723cULL, 0x048ff00000041824ULL, 0x0000003e3428723cULL, 0x040ff00000041828ULL,
0x0000003a3430723cULL, 0x000fe20000041830ULL, 0x000007a000008947ULL, 0x000fee0003800000ULL,
0x000000100c1a7824ULL, 0x000fe200078e0283ULL, 0x0000008303187211ULL, 0x000fe200078e20ffULL,
0x000000048b0c7e24ULL, 0x020fc4000f8e027eULL, 0x0000010038417824ULL, 0x000fe400078e0289ULL,
0x00000010113d7824ULL, 0x100fe200078e0283ULL, 0x0000000c14537210ULL, 0x080fe20007ffe0ffULL,
0x0000000177117824ULL, 0x000fe400078e020cULL, 0x000000107d437824ULL, 0x000fe400078e00ffULL,
0x00000010021b7824ULL, 0x100fe200078e0283ULL, 0x000000418e027217ULL, 0x000fe20007800000ULL,
0x000000100d347824ULL, 0x100fe200078e0283ULL, 0x0000000c7b0d7210ULL, 0x000fe20007ffe0ffULL,
0x00000010103c7824ULL, 0x000fe200078e0283ULL, 0x0000007043437812ULL, 0x000fe200078ec0ffULL,
0x00005e0011107625ULL, 0x000fc800078e007aULL, 0x000000100f397824ULL, 0x000fe400078e0283ULL,
0x00000001740f7824ULL, 0x100fe400078e020cULL, 0x0000000171037824ULL, 0x100fe400078e020cULL,
0x000000016e377824ULL, 0x100fe400078e020cULL, 0x000000016b6b7824ULL, 0x100fe400078e020cULL,
0x00000001683b7824ULL, 0x000fc400078e020cULL, 0x0000000165657824ULL, 0x100fe400078e020cULL,
0x00000001044f7824ULL, 0x100fe400078e020cULL, 0x0000000113517824ULL, 0x100fe400078e020cULL,
0x00000001154d7824ULL, 0x100fe400078e020cULL, 0x00000001164b7824ULL, 0x100fe400078e020cULL,
0x0000000117497824ULL, 0x000fc400078e020cULL, 0x0000000160457824ULL, 0x100fe400078e020cULL,
0x0000000161617824ULL, 0x000fe400078e020cULL, 0x0000001079797824ULL, 0x100fe400078e0283ULL,
0x0000001076477824ULL, 0x100fe400078e0283ULL, 0x0000001073737824ULL, 0x100fe400078e0283ULL,
0x00000010703f7824ULL, 0x000fc400078e0283ULL, 0x000000106d6d7824ULL, 0x100fe400078e0283ULL,
0x000000106a197824ULL, 0x100fe400078e0283ULL, 0x0000001067677824ULL, 0x100fe400078e0283ULL,
0x000000100e357824ULL, 0x000fe400078e0283ULL, 0x0000000102417824ULL, 0x000fe400078e0a41ULL,
0x00005e000d0c7625ULL, 0x000fc600078e007aULL, 0x000000417c00720cULL, 0x080fe20003f46070ULL,
0x0000001012837824ULL, 0x000fe200078e0283ULL, 0x0000001043127210ULL, 0x000fe20007fde0ffULL,
0x00005e0003027625ULL, 0x000fe200078e007aULL, 0x0000000c430c7210ULL, 0x000fe40007f9e0ffULL,
0x000000417800720cULL, 0x080fe20003f66070ULL, 0x00005e000f0e7625ULL, 0x000fe200078e007aULL,
0x000000417500720cULL, 0x080fe40003f26070ULL, 0x000000417200720cULL, 0x080fe20003f06070ULL,
0x000000ffff137224ULL, 0x000fe200030e0611ULL, 0x0000000243027210ULL, 0x000fe20007fde0ffULL,
0x00005e006b147625ULL, 0x000fe200078e007aULL, 0x000000416f00720cULL, 0x000fc40003fa6070ULL,
0x00000003ff037210ULL, 0x000fe200037fe4ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000000e430e7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0037107625ULL, 0x000fe200078e007aULL,
0x0000001443147210ULL, 0x000fe40007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c797faeULL, 0x0003e2000d101c46ULL, 0x00005e003b367625ULL, 0x000fe200078e007aULL,
0x0000001043107210ULL, 0x000fe40007f5e0ffULL, 0x0000000012477faeULL, 0x0005e2000d901c46ULL,
0x000000ffff0f7224ULL, 0x000fe200020e060fULL, 0x000000416c00720cULL, 0x080fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000416900720cULL, 0x080fe20003f66070ULL,
0x00005e00653a7625ULL, 0x000fe200078e007aULL, 0x000000000e737faeULL, 0x0007e2000c901c46ULL,
0x000000410000720cULL, 0x000fc40003f26070ULL, 0x00000036430c7210ULL, 0x002fe20007fde0ffULL,
0x00005e004f167625ULL, 0x000fe200078e007aULL, 0x00000000023f7faeULL, 0x0003e2000c101c46ULL,
0x0000003a43127210ULL, 0x044fe40007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e0637ULL,
0x0000001643047210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000000416600720cULL, 0x080fe20003f46070ULL, 0x000000ffff137224ULL, 0x000fe200000e063bULL,
0x000000410500720cULL, 0x080fe20003f06070ULL, 0x00005e00510e7625ULL, 0x008fe200078e007aULL,
0x00000000106d7faeULL, 0x0005e6000e901c46ULL, 0x000000ffff057224ULL, 0x000fe200030e0617ULL,
0x0000000e43027210ULL, 0x002fe20007fbe0ffULL, 0x00005e0053167625ULL, 0x000fe200078e007aULL,
0x0000000014197faeULL, 0x0003e2000e101c46ULL, 0x000000410600720cULL, 0x000fc40003f86070ULL,
0x000000ffff037224ULL, 0x000fe200028e060fULL, 0x00000016430e7210ULL, 0x000fe20007fde0ffULL,
0x000000000c677faeULL, 0x0007e2000d901c46ULL, 0x000000410700720cULL, 0x080fe20003fa6070ULL,
0x00005e004d067625ULL, 0x000fe400078e007aULL, 0x00000000121b7faeULL, 0x0009e2000d101c46ULL,
0x000000410800720cULL, 0x080fe20003f46070ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0617ULL,
0x0000000643067210ULL, 0x000fe20007f7e0ffULL, 0x00005e004b167625ULL, 0x080fe200078e007aULL,
0x0000000004187faeULL, 0x0003e6000c901c46ULL, 0x00005e00450c7625ULL, 0x008fe200078e007aULL,
0x0000001643107210ULL, 0x004fe20007fde0ffULL, 0x00000000021a7faeULL, 0x0003e2000c101c46ULL,
0x000000410a00720cULL, 0x080fe20003f06070ULL, 0x00005e0049367625ULL, 0x000fe200078e007aULL,
0x0000000c430c7210ULL, 0x040fe20007f3e0ffULL, 0x000000000e347faeULL, 0x0003e4000e101c46ULL,
0x000000ffff077224ULL, 0x000fe200018e0607ULL, 0x0000003643087210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200030e0617ULL, 0x000000410900720cULL, 0x000fe20003fc6070ULL,
0x00005e00617a7625ULL, 0x000fe200078e007aULL, 0x00000037ff097210ULL, 0x000fe20001ffe4ffULL,
0x0000000006357faeULL, 0x0003e4000e901c46ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000410b00720cULL, 0x000fe20003f26070ULL, 0x0000000010397faeULL, 0x0003e2000d101c46ULL,
0x0000007a43127210ULL, 0x010fca0007f7e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e067bULL,
0x00000000083c7faeULL, 0x0003e8000f101c46ULL, 0x000000000c3d7faeULL, 0x0003e8000c101c46ULL,
0x0000000012837faeULL, 0x0003e2000c901c46ULL, 0x0000066000007947ULL, 0x000fea0003800000ULL,
0x000000048b007e24ULL, 0x020fe2000f8e027eULL, 0x0000008302417211ULL, 0x000fe200078e20ffULL,
0x0000001003457824ULL, 0x000fc400078e0283ULL, 0x000000107d3b7824ULL, 0x000fe200078e00ffULL,
0x000000007b037210ULL, 0x080fe20007ffe0ffULL, 0x0000000177057824ULL, 0x100fe200078e0200ULL,
0x0000000014357210ULL, 0x000fe20007ffe0ffULL, 0x0000000104197824ULL, 0x000fe200078e0200ULL,
0x000000703b3b7812ULL, 0x000fe200078ec0ffULL, 0x00005e0003027625ULL, 0x000fc800078e007aULL,
0x00005e0005047625ULL, 0x000fe200078e007aULL, 0x000000023b027210ULL, 0x000fc60007f1e0ffULL,
0x0000000174077824ULL, 0x100fe400078e0200ULL, 0x000000016e0b7824ULL, 0x000fe400078e0200ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x000000043b047210ULL, 0x000fe20007f1e0ffULL,
0x000000100f4d7824ULL, 0x000fe400078e0283ULL, 0x00005e0007067625ULL, 0x000fc800078e007aULL,
0x00005e000b0a7625ULL, 0x000fe200078e007aULL, 0x000000063b067210ULL, 0x000fc60007f3e0ffULL,
0x000000100d497824ULL, 0x100fe400078e0283ULL, 0x00000001680f7824ULL, 0x100fe400078e0200ULL,
0x000000016b0d7824ULL, 0x000fe400078e0200ULL, 0x000000100e477824ULL, 0x000fe400078e0283ULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000000a3b0a7210ULL, 0x000fe20007f1e0ffULL,
0x000000100c437824ULL, 0x000fc400078e0283ULL, 0x00005e000f0e7625ULL, 0x000fe200078e007aULL,
0x0000000bff0b7210ULL, 0x000fc600007fe4ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e007aULL,
0x0000000e3b0e7210ULL, 0x000fc60007f1e0ffULL, 0x00000010114f7824ULL, 0x100fe400078e0283ULL,
0x0000000165117824ULL, 0x000fe400078e0200ULL, 0x0000001079797824ULL, 0x100fe400078e0283ULL,
0x0000001076397824ULL, 0x100fe400078e0283ULL, 0x0000001073737824ULL, 0x100fe200078e0283ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002797faeULL, 0x0003e2000b901c46ULL,
0x00000010703d7824ULL, 0x000fc400078e0283ULL, 0x000000106d6d7824ULL, 0x100fe200078e0283ULL,
0x0000000004397faeULL, 0x0003e2000b901c46ULL, 0x000000106a3f7824ULL, 0x100fe400078e0283ULL,
0x0000001067677824ULL, 0x100fe400078e0283ULL, 0x00000010104b7824ULL, 0x100fe400078e0283ULL,
0x0000001012837824ULL, 0x000fe400078e0283ULL, 0x0000000171097824ULL, 0x000fc400078e0200ULL,
0x00000001131b7824ULL, 0x000fe400078e0200ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000c3b0c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0019127625ULL, 0x000fc600078e007aULL,
0x0000000006737faeULL, 0x0003e2000b901c46ULL, 0x00005e0011107625ULL, 0x000fc800078e007aULL,
0x0000000115377824ULL, 0x000fe400078e0200ULL, 0x00005e0009087625ULL, 0x000fc800078e007aULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x000000123b127210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000103b107210ULL, 0x000fe20007f3e0ffULL,
0x00005e0037187625ULL, 0x000fe200078e007aULL, 0x000000083b087210ULL, 0x000fc60007f5e0ffULL,
0x00005e001b147625ULL, 0x000fc800078e007aULL, 0x0000000116517824ULL, 0x100fe400078e0200ULL,
0x0000000117537824ULL, 0x000fe400078e0200ULL, 0x00005e0035167625ULL, 0x000fc800078e007aULL,
0x0000000160557824ULL, 0x100fe400078e0200ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x000000183b187210ULL, 0x000fe20007f1e0ffULL, 0x00000001617b7824ULL, 0x000fe400078e0200ULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000000143b147210ULL, 0x000fe20007f3e0ffULL,
0x00005e0051367625ULL, 0x000fc800078e007aULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x000000163b167210ULL, 0x000fe20007f5e0ffULL, 0x00005e0053347625ULL, 0x000fc600078e007aULL,
0x00000000083d7faeULL, 0x0003e2000b901c46ULL, 0x00005e00551a7625ULL, 0x000fc600078e007aULL,
0x000000000a6d7faeULL, 0x0003e2000b901c46ULL, 0x00005e007b7a7625ULL, 0x000fc600078e007aULL,
0x000000000c3f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x000000363b367210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x000000343b347210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000001a3b1a7210ULL, 0x040fe20007f5e0ffULL, 0x000000000e677faeULL, 0x0003e2000b901c46ULL,
0x0000007a3b3a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff377224ULL, 0x000fe200000e0637ULL,
0x0000001bff1b7210ULL, 0x000fe200017fe4ffULL, 0x0000000010417faeULL, 0x0003e2000b901c46ULL,
0x000000ffff357224ULL, 0x000fc400008e0635ULL, 0x000000ffff3b7224ULL, 0x000fe200018e067bULL,
0x0000000012457faeULL, 0x0003e8000b901c46ULL, 0x0000000014437faeULL, 0x0003e8000b901c46ULL,
0x0000000016497faeULL, 0x0003e8000b901c46ULL, 0x0000000018477faeULL, 0x0003e8000b901c46ULL,
0x00000000364d7faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a4f7faeULL, 0x0003e8000b901c46ULL, 0x000000003a837faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000862007810ULL, 0x000fc40007ffe0ffULL, 0x0000300064037810ULL, 0x002fe40007ffe0ffULL,
0x0000000700007812ULL, 0x000fe400078e7863ULL, 0x0000000a62027810ULL, 0x000fe20007ffe0ffULL,
0x00000010820c7824ULL, 0x000fe400078e0203ULL, 0x0000001063007824ULL, 0x000fe200078e0200ULL,
0x0000000702027812ULL, 0x000fe200078e7863ULL, 0x0000001084087824ULL, 0x000fe400078e0203ULL,
0x0000001000007824ULL, 0x000fc400078e00ffULL, 0x0000001081107824ULL, 0x100fe400078e0203ULL,
0x0000001090147824ULL, 0x100fe400078e0203ULL, 0x0000001063027824ULL, 0x000fe400078e0202ULL,
0x0000001094347824ULL, 0x000fe200078e0203ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000004783bULL, 0x0003e20000000200ULL, 0x0000000402027819ULL, 0x000fe200000006ffULL,
0x00000010a4407824ULL, 0x100fe400078e0203ULL, 0x000000000c0c783bULL, 0x000ea20000000200ULL,
0x00000010983c7824ULL, 0x000fc600078e0203ULL, 0x000000000808783bULL, 0x000ee20000000200ULL,
0x0000000c62007810ULL, 0x042fe40007ffe0ffULL, 0x0000000e62627810ULL, 0x000fe20007ffe0ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000000700007812ULL, 0x100fe400078e7863ULL,
0x0000000762627812ULL, 0x000fe200078e7863ULL, 0x000000001414783bULL, 0x000f240000000200ULL,
0x0000001063007824ULL, 0x040fe200078e0200ULL, 0x0000006263627211ULL, 0x000fe200078e20ffULL,
0x000000000218783bULL, 0x000fe40000000200ULL, 0x0000001000007824ULL, 0x000fc400078e00ffULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000fe80000000200ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000000c041c723cULL, 0x044fee000004181cULL,
0x00000010920c7824ULL, 0x100fe200078e0203ULL, 0x0000000e0420723cULL, 0x040fea0000041820ULL,
0x000000000c0c783bULL, 0x000ea60000000200ULL, 0x00000008045c723cULL, 0x048fee000004185cULL,
0x0000001080087824ULL, 0x100fe200078e0203ULL, 0x0000000a0458723cULL, 0x040fea0000041858ULL,
0x000000000808783bULL, 0x000ee60000000200ULL, 0x000000100424723cULL, 0x042fee0000041824ULL,
0x0000001096107824ULL, 0x100fe200078e0203ULL, 0x000000120428723cULL, 0x040fea0000041828ULL,
0x000000001010783bULL, 0x000e660000000200ULL, 0x00000014042c723cULL, 0x050ff0000004182cULL,
0x000000160430723cULL, 0x000fe20000041830ULL, 0x000000000014783bULL, 0x0009ec0000000200ULL,
0x00000010a0047824ULL, 0x000fe200078e0203ULL, 0x0000000c181c723cULL, 0x004fe2000004181cULL,
0x0000ffff85007812ULL, 0x010fc800078ec0ffULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0x0000888000027816ULL, 0x000fe200000000ffULL, 0x000000109c0c7824ULL, 0x100fe200078e0203ULL,
0x0000000e1820723cULL, 0x040fe60000041820ULL, 0x8000000002007824ULL, 0x000fe400078e00ffULL,
0x000000000c0c783bULL, 0x000f260000000200ULL, 0x00000008185c723cULL, 0x048fee000004185cULL,
0x000000109e087824ULL, 0x100fe200078e0203ULL, 0x000000341824723cULL, 0x040fee0000041824ULL,
0x000000109a347824ULL, 0x100fe200078e0203ULL, 0x0000000a1858723cULL, 0x040fe20000041858ULL,
0x000000000808783bULL, 0x000eee0000000200ULL, 0x000000361828723cULL, 0x040fe20000041828ULL,
0x000000003434783bULL, 0x000f6e0000000200ULL, 0x00000010182c723cULL, 0x042fee000004182cULL,
0x0000001062107824ULL, 0x000fe200078e00ffULL, 0x000000121830723cULL, 0x000fea0000041830ULL,
0x000000001010783bULL, 0x000e640000000200ULL, 0x0000001093187824ULL, 0x100fe200078e0203ULL,
0x00000004145c723cULL, 0x044fea000004185cULL, 0x000000001818783bULL, 0x000ea40000000200ULL,
0x00000010a2047824ULL, 0x000fe200078e0203ULL, 0x000000061458723cULL, 0x040fea0000041858ULL,
0x000000000404783bULL, 0x000e660000000200ULL, 0x0000000c1424723cULL, 0x050ff00000041824ULL,
0x0000000e1428723cULL, 0x040ff00000041828ULL, 0x00000008141c723cULL, 0x048ff0000004181cULL,
0x0000000a1420723cULL, 0x040ff00000041820ULL, 0x000000341408723cULL, 0x060ff0000004182cULL,
0x000000361430723cULL, 0x000ff00000041830ULL, 0x00000040100c723cULL, 0x042ff00000041824ULL,
0x000000421040723cULL, 0x040fe20000041828ULL, 0x0236140087297984ULL, 0x000e6e0000000800ULL,
0x000000181014723cULL, 0x044ff0000004181cULL, 0x0000001a1018723cULL, 0x000fe20000041820ULL,
0x3db504f30c1e7820ULL, 0x000fc40000410000ULL, 0x3db504f30d1d7820ULL, 0x000fca0000410000ULL,
0x000000041008723cULL, 0x000fe20000041808ULL, 0x3db504f3401c7820ULL, 0x000fce0000410000ULL,
0x0000003c105c723cULL, 0x040fe2000004185cULL, 0x3db504f315217820ULL, 0x000fe40000410000ULL,
0x3db504f316157820ULL, 0x000fe40000410000ULL, 0x3db504f317167820ULL, 0x000fe40000410000ULL,
0x3db504f314227820ULL, 0x000fe20000410000ULL, 0x0000003e1058723cULL, 0x000fe20000041858ULL,
0x3db504f31a177820ULL, 0x000fe20000410000ULL, 0x8000000029ff7812ULL, 0x002fe20007804800ULL,
0x3db504f318207820ULL, 0x000fc40000410000ULL, 0x3db504f3191f7820ULL, 0x000fc60000410000ULL,
0x000000061004723cULL, 0x000fe20000041830ULL, 0x3db504f3081a7820ULL, 0x000fe40000410000ULL,
0x3db504f309197820ULL, 0x000fe40000410000ULL, 0x3db504f30a0c7820ULL, 0x000fe40000410000ULL,
0x3db504f31b127820ULL, 0x000fe40000410000ULL, 0x3db504f30e137820ULL, 0x000fe40000410000ULL,
0x3db504f30f107820ULL, 0x000fc40000410000ULL, 0x3db504f35c277820ULL, 0x000fe40000410000ULL,
0x3db504f35d267820ULL, 0x000fe40000410000ULL, 0x3db504f35e5e7820ULL, 0x000fe40000410000ULL,
0x3db504f35f5f7820ULL, 0x000fe40000410000ULL, 0x3db504f358257820ULL, 0x000fe40000410000ULL,
0x3db504f359237820ULL, 0x000fc40000410000ULL, 0x3db504f35a5a7820ULL, 0x000fe40000410000ULL,
0x3db504f35b5b7820ULL, 0x000fe40000410000ULL, 0x3db504f3411b7820ULL, 0x000fe40000410000ULL,
0x3db504f342117820ULL, 0x000fe40000410000ULL, 0x3db504f3430f7820ULL, 0x000fe40000410000ULL,
0x3db504f30b0e7820ULL, 0x000fc40000410000ULL, 0x3db504f304187820ULL, 0x000fe40000410000ULL,
0x3db504f305087820ULL, 0x000fe40000410000ULL, 0x3db504f3060d7820ULL, 0x000fe40000410000ULL,
0x3db504f307037820ULL, 0x000fe20000410000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e005eULL,
0x0000005b00147202ULL, 0x000fe20000000f00ULL, 0x000000ffff097224ULL, 0x000fc400078e005fULL,
0x000000ffff0b7224ULL, 0x000fe200078e005aULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000002057824ULL, 0x000fe400078e00ffULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x0236140087027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000047d007824ULL, 0x000fe200078e00ffULL, 0x000000869100720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff000027812ULL, 0x000fca00078ec0ffULL,
0x000000808f027824ULL, 0x000fca00078e0202ULL, 0x0234000002047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000027d247824ULL, 0x000fe400078e00ffULL,
0x000000018e7f7824ULL, 0x000fc600078e0a7fULL, 0x0000000624247812ULL, 0x000fc800078ec0ffULL,
0x0000000124287812ULL, 0x040fe400078efcffULL, 0x0000000824297812ULL, 0x000fe400078efcffULL,
0x0000007f2800720cULL, 0x080fe40003f26070ULL, 0x0000001024287812ULL, 0x000fe400078efcffULL,
0x0000007f2900720cULL, 0x080fe40003f06070ULL, 0x0000007f2800720cULL, 0x000fc40003fc6070ULL,
0x0000001124297812ULL, 0x040fe400078efcffULL, 0x0000001824287812ULL, 0x040fe400078efcffULL,
0x0000007f2400720cULL, 0x080fe40003f46070ULL, 0x0000007f2900720cULL, 0x080fe40003fa6070ULL,
0x0000007f2800720cULL, 0x000fe40003f66070ULL, 0x00000009242a7812ULL, 0x000fc400078efcffULL,
0x0000001924297812ULL, 0x040fe400078efcffULL, 0x0000002024287812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL, 0xff7fffff27277808ULL, 0x000fe40005000000ULL,
0xff7fffff09097808ULL, 0x000fe40004800000ULL, 0xff7fffff26267808ULL, 0x000fc40004800000ULL,
0x0000007f2a00720cULL, 0x080fe40003f86070ULL, 0x0000007f2900720cULL, 0x080fe40003f46070ULL,
0x0000007f2800720cULL, 0x000fe40003f26070ULL, 0x0000002124297812ULL, 0x040fe400078efcffULL,
0x0000002824287812ULL, 0x000fe400078efcffULL, 0xff7fffff0b0b7808ULL, 0x000fc40004000000ULL,
0xff7fffff25257808ULL, 0x000fe40004000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff23237808ULL, 0x000fe40006000000ULL, 0x0000007f2900720cULL, 0x080fe40003f06070ULL,
0x0000007f2800720cULL, 0x000fe40003f86070ULL, 0x0000002924297812ULL, 0x000fc400078efcffULL,
0x0000003024287812ULL, 0x000fe400078efcffULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff22227808ULL, 0x000fe40007000000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0x0000007f2900720cULL, 0x000fc40003fc6070ULL,
0x0000007f2800720cULL, 0x000fe40003fa6070ULL, 0x0000003124297812ULL, 0x040fe400078efcffULL,
0x0000003824287812ULL, 0x040fe400078efcffULL, 0x0000003924247812ULL, 0x000fe400078efcffULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff20207808ULL, 0x000fc40005800000ULL,
0xff7fffff12127808ULL, 0x000fe40005000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL,
0xff7fffff13137808ULL, 0x000fe40004800000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40004800000ULL,
0x0000007f2900720cULL, 0x080fe40003f66070ULL, 0x0000007f2800720cULL, 0x000fc40003f46070ULL,
0x0000007f2400720cULL, 0x000fe40003f26070ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40007000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40007000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40006800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40005800000ULL,
0xff7fffff19197808ULL, 0x000fe40005800000ULL, 0xff7fffff0d0d7808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff03037808ULL, 0x000fe40004800000ULL,
0xff7fffff08087808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002704297209ULL, 0x004fe40007810000ULL, 0x0000000a05247209ULL, 0x000fe40007810000ULL,
0x0000002629047209ULL, 0x000fe40007810000ULL, 0x0000000924247209ULL, 0x000fc40007810000ULL,
0x0000002504047209ULL, 0x000fe40007810000ULL, 0x0000000b24057209ULL, 0x000fe40007810000ULL,
0x0000002304297209ULL, 0x000fe40007810000ULL, 0x0000001405047209ULL, 0x000fe40007810000ULL,
0x0000002229247209ULL, 0x000fe40007810000ULL, 0x0000001504057209ULL, 0x000fc40007810000ULL,
0x0000002124297209ULL, 0x000fe40007810000ULL, 0x0000001605047209ULL, 0x000fe40007810000ULL,
0x0000002029247209ULL, 0x000fe40007810000ULL, 0x0000001704057209ULL, 0x000fe40007810000ULL,
0x0000001f24297209ULL, 0x000fe40007810000ULL, 0x0000001205047209ULL, 0x000fc40007810000ULL,
0x0000001e29247209ULL, 0x000fe40007810000ULL, 0x0000001304057209ULL, 0x000fe40007810000ULL,
0x0000001d24297209ULL, 0x000fe40007810000ULL, 0x0000001005047209ULL, 0x000fe40007810000ULL,
0x0000001c29247209ULL, 0x000fe40007810000ULL, 0x0000001104047209ULL, 0x000fc40007810000ULL,
0x0000001b24057209ULL, 0x000fe40007810000ULL, 0x0000000f04297209ULL, 0x000fe40007810000ULL,
0x0000001a05047209ULL, 0x000fe40007810000ULL, 0x0000000c29297209ULL, 0x000fe40007810000ULL,
0x0000001904057209ULL, 0x000fe40007810000ULL, 0x0000000e29047209ULL, 0x000fc40007810000ULL,
0x0000001805057209ULL, 0x000fe40007810000ULL, 0x0000000d04047209ULL, 0x000fe40007810000ULL,
0x0000000805057209ULL, 0x000fe40007810000ULL, 0x00000003042d7209ULL, 0x000fe20007810000ULL,
0x00000f027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x00000004052f7209ULL, 0x008fe20007810000ULL, 0x00000f527f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x004ea800000e0000ULL,
0x0c401f0007247f89ULL, 0x000f2200000e0000ULL, 0x000000042d287209ULL, 0x008fc60007810000ULL,
0x0c201f002f047f89ULL, 0x000ee200000e0000ULL, 0x00000005062a7209ULL, 0x004fc60007810000ULL,
0x0c201f0028057f89ULL, 0x000ea200000e0000ULL, 0x0000002407247209ULL, 0x010fc60007810000ULL,
0x0c201f002a2b7f89ULL, 0x002e6800000e0000ULL, 0x0c201f0024297f89ULL, 0x00092200000e0000ULL,
0x000000042f047209ULL, 0x008fe40007810000ULL, 0x0000000528057209ULL, 0x004fe40007810000ULL,
0x0000002b2a067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3f80000000057882ULL, 0x000fe20000000000ULL, 0x3fb8aa3b052c7820ULL, 0x002fc40000410000ULL,
0x3fb8aa3b27277823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe2000001082cULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14147823ULL, 0x000fe4000001082cULL,
0x3fb8aa3b23237823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe4000001082cULL,
0x3fb8aa3b09097823ULL, 0x000fe2000001082cULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x3fb8aa3b18187823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b22227823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL, 0x0000002300287308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b08077823ULL, 0x000fe20000010807ULL,
0x0000000a002b7308ULL, 0x0005e20000000800ULL, 0x000000272608723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b15157823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001082cULL,
0x3fb8aa3b172f7823ULL, 0x100fe4000001082cULL, 0x00000009002e7308ULL, 0x000e620000000800ULL,
0x00000025280a723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b12257823ULL, 0x000fc4000001082cULL,
0x3fb8aa3b13277823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b03037823ULL, 0x000fe4000001082cULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000001400147308ULL, 0x000ea20000000800ULL,
0x0000002b2e09723eULL, 0x002fce00000010ffULL, 0x00000018002a7308ULL, 0x0003f00000000800ULL,
0x0000001900237308ULL, 0x0007e20000000800ULL, 0x00000005ff187e24ULL, 0x002fe2000f8e00ffULL,
0x0000000b140b723eULL, 0x004fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000087886ULL, 0x000fc400038e0100ULL, 0x3f8000001818783eULL, 0x000fe400000010ffULL,
0x0000002200227308ULL, 0x000fe60000000800ULL, 0x000000ffff197224ULL, 0x008fca00078e0018ULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x00000015002d7308ULL, 0x000ff00000000800ULL,
0x0000001600307308ULL, 0x0004f00000000800ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x000000180814723cULL, 0x004fee00000418ffULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b10197823ULL, 0x100fe2000001082cULL, 0x000000222110723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b11217823ULL, 0x100fe2000001082cULL, 0x0000002d3011723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b0e227823ULL, 0x000fc6000001082cULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000002500267308ULL, 0x000e620000000800ULL, 0x000000201f12723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b0f1f7823ULL, 0x000fcc000001082cULL, 0x0000001900287308ULL, 0x0005e20000000800ULL,
0x0000002f2613723eULL, 0x002fe200000010ffULL, 0x000000ffff197224ULL, 0x004fcc00078e0018ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x000000181014723cULL, 0x000fee0000041814ULL,
0x0000001d001d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b0c197823ULL, 0x000fce000001082cULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x0000001e1d0c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b0d1d7823ULL, 0x000fc4000001082cULL,
0x000000ffff1e7224ULL, 0x000fc800078e0018ULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000001c1b0e723eULL, 0x004fce00000010ffULL,
0x0000001f00207308ULL, 0x0004e20000000800ULL, 0x00000027280d723eULL, 0x002fce00000010ffULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0018ULL,
0x00000021200f723eULL, 0x008fcc00000010ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x0000001e0c2c723cULL, 0x000fee0000041814ULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x0000000fff157424ULL, 0x000fe200078e00ffULL, 0xfffffffc7d147812ULL, 0x000fcc00078ec0ffULL,
0x0000000700077308ULL, 0x000ee20000000800ULL, 0x00000014151e7219ULL, 0x000fe400000006ffULL,
0x000000192215723eULL, 0x002fe200000010ffULL, 0x000000ffff197224ULL, 0x000fe200078e0018ULL,
0x000000001e1b73a1ULL, 0x000e6200000e8000ULL, 0x000000001e0573c4ULL, 0x000f640000004000ULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x0000001a2314723eULL, 0x004fce00000010ffULL,
0x00000003001c7308ULL, 0x000ea20000000800ULL, 0x0000002a0716723eULL, 0x008fe400000010ffULL,
0x0000002429077209ULL, 0x010fe40007810000ULL, 0x000000081eff7c12ULL, 0x002fe4000f80401bULL,
0x0000001d1c17723eULL, 0x004fce00000010ffULL, 0x000000181420723cULL, 0x000fe8000004182cULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000b1205008947ULL, 0x020fde000b800000ULL,
0x001c1fff20187589ULL, 0x0002a400000e0000ULL, 0x000000001e0373a1ULL, 0x000ee200000e8000ULL,
0x000000001e0573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x000000081eff7c12ULL, 0x008fda000f804003ULL, 0x00000b3205008947ULL, 0x010fea000b800000ULL,
0x001c1fff22197589ULL, 0x00072800000e0000ULL, 0x001c1fff011a7589ULL, 0x00066800000e0000ULL,
0x001c1fff1b1b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x000fe4000001167dULL,
0x0000000c00317812ULL, 0x000fc400078ec0ffULL, 0x00000007031c7812ULL, 0x040fe200078ec0ffULL,
0x0000000803217824ULL, 0x040fe200078e00ffULL, 0x00000003ff1f7212ULL, 0x000fe200078e33ffULL,
0x00000008031d7824ULL, 0x000fe200078e00ffULL, 0x000000037dff7812ULL, 0x000fe2000780c0ffULL,
0x00000008032c7824ULL, 0x040fe200078e00ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8211e7812ULL, 0x10afe400078ee21cULL, 0x000000011d207812ULL, 0x100fe200078ef61cULL,
0x00000008033e7824ULL, 0x000fe200078e00ffULL, 0x000000021d227812ULL, 0x000fc400078ef61cULL,
0x000000031d247812ULL, 0x140fe400078ef61cULL, 0x000000041d267812ULL, 0x140fe400078ef61cULL,
0x000000051d287812ULL, 0x140fe400078ef61cULL, 0x000000061d2a7812ULL, 0x000fe200078ef61cULL,
0x00000008031d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe400078ee21fULL,
0x00000003ff1f7212ULL, 0x000fc400078e33ffULL, 0x00000007031c7812ULL, 0x040fe400078ec0ffULL,
0x0000000303217819ULL, 0x000fe400000006ffULL, 0x000110008f037811ULL, 0x000fe400078e58ffULL,
0xfffffff8212e7812ULL, 0x100fe400078ee21cULL, 0x000000011d307812ULL, 0x140fe200078ef61cULL,
0x000000101e007824ULL, 0x000fe200078e0203ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee21fULL,
0x00000010221e7824ULL, 0x100fe200078e0203ULL, 0x000000021d327812ULL, 0x140fe200078ef61cULL,
0x0000001026227824ULL, 0x100fe200078e0203ULL, 0x000000031d347812ULL, 0x140fe200078ef61cULL,
0x000000102a267824ULL, 0x100fe200078e0203ULL, 0x000000041d367812ULL, 0x140fe200078ef61cULL,
0x00000010302a7824ULL, 0x100fe200078e0203ULL, 0x000000051d3a7812ULL, 0x140fe200078ef61cULL,
0x00000010322b7824ULL, 0x100fe200078e0203ULL, 0x000000061d3c7812ULL, 0x000fe200078ef61cULL,
0x00000010201c7824ULL, 0x100fe200078e0203ULL, 0x00000000311d7210ULL, 0x040fe20007ffe0ffULL,
0x0000001024207824ULL, 0x100fe200078e0203ULL, 0x0000001e311f7210ULL, 0x000fe20007ffe0ffULL,
0x0000001028247824ULL, 0x000fc400078e0203ULL, 0x000000102c287824ULL, 0x100fe200078e0203ULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x000000102e007824ULL, 0x100fe400078e0203ULL,
0x00000010342c7824ULL, 0x100fe400078e0203ULL, 0x00000010362d7824ULL, 0x100fe400078e0203ULL,
0x000000103a2e7824ULL, 0x100fe400078e0203ULL, 0x000000103c2f7824ULL, 0x100fe200078e0203ULL,
0x0000002d31087210ULL, 0x002fe20007ffe0ffULL, 0x000000103e307824ULL, 0x000fc400078e0203ULL,
0x0000000131037824ULL, 0x040fe400078e021cULL, 0x0000000131217824ULL, 0x040fe400078e0220ULL,
0x0000000131237824ULL, 0x040fe200078e0222ULL, 0x0000000a03007388ULL, 0x0003e20000000800ULL,
0x0000000131257824ULL, 0x040fe400078e0224ULL, 0x0000000131277824ULL, 0x040fe200078e0226ULL,
0x000000101f007388ULL, 0x0003e20000000800ULL, 0x0000000131297824ULL, 0x000fc400078e0228ULL,
0x0000000131007824ULL, 0x040fe200078e0200ULL, 0x0000001221007388ULL, 0x0003e20000000800ULL,
0x00000001312a7824ULL, 0x040fe400078e022aULL, 0x00000001311c7824ULL, 0x040fe200078e022bULL,
0x0000000c23007388ULL, 0x0003e20000000800ULL, 0x00000001312c7824ULL, 0x040fe400078e022cULL,
0x00000001312e7824ULL, 0x040fe200078e022eULL, 0x0000000e25007388ULL, 0x0003e20000000800ULL,
0x00000001311e7824ULL, 0x000fc400078e022fULL, 0x0000000131307824ULL, 0x000fe200078e0230ULL,
0x0000001427007388ULL, 0x0003e80000000800ULL, 0x0000001629007388ULL, 0x0003e80000000800ULL,
0x0000000900007388ULL, 0x0003e80000000800ULL, 0x0000000b2a007388ULL, 0x0003e80000000800ULL,
0x000000111c007388ULL, 0x0003e80000000800ULL, 0x000000132c007388ULL, 0x0003e80000000800ULL,
0x0000000d08007388ULL, 0x0003e80000000800ULL, 0x0000000f2e007388ULL, 0x0003e80000000800ULL,
0x000000151e007388ULL, 0x0003e80000000800ULL, 0x0000001730007388ULL, 0x0003e80000000800ULL,
0x0230000402008388ULL, 0x0003e80000000c00ULL, 0x0232001802008388ULL, 0x0143e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008a3800720cULL, 0x000fe20003f26070ULL,
0x0236080087ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ff85ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff917224ULL, 0x000fc600078e0038ULL, 0x00000001ff857807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x004fe20003c00000ULL, 0xffffb48000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff337224ULL, 0x000fe200078e002dULL,
0xffffffff00357802ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe200078e0058ULL,
0x000115b0002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff347424ULL, 0x000fe400078e00ffULL,
0x000007b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x004fe200078e0031ULL,
0xffff860000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0058ULL,
0x00011630002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe400078e002cULL,
0x0000001fff347424ULL, 0x000fe400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x0000073000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2c7224ULL, 0x004fe200078e0031ULL,
0xffff85a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0005ULL,
0xffffffff00317802ULL, 0x000fe20000000f00ULL, 0x00000002ff2b7424ULL, 0x000fe200078e00ffULL,
0x000116b000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fc400078e00ffULL,
0x0000067000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002aULL,
0xfffff09000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e002dULL,
0x0001173000287802ULL, 0x000fe20000000f00ULL, 0x00000002ff2b7424ULL, 0x002fc400078e00ffULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x000005f000007944ULL, 0x004fea0003c00000ULL, 0x0000002a2d057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0006ULL, 0x000117a000287802ULL, 0x000fe20000000f00ULL,
0x00000002ff2b7424ULL, 0x002fe400078e00ffULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000058000007944ULL, 0x000fea0003c00000ULL,
0x0000002a062d7209ULL, 0x004fe20007810000ULL, 0x00000002ff2b7424ULL, 0x002fe200078e00ffULL,
0x00000007002a7202ULL, 0x000fe20000000f00ULL, 0x0000001fff2c7424ULL, 0x000fe200078e00ffULL,
0x0001181000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x0000002a07247209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e002fULL, 0x0001188000287802ULL, 0x000fe20000000f00ULL,
0x00000001ff2b7424ULL, 0x002fc400078e00ffULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000002a2f047209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0005ULL,
0x0000001f002c7802ULL, 0x002fe20000000f00ULL, 0x00000001ff2b7424ULL, 0x000fe200078e00ffULL,
0x000118f000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002a05057209ULL, 0x004fe20007810000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e002dULL, 0x0001196000287802ULL, 0x000fe20000000f00ULL,
0x00000001ff2b7424ULL, 0x002fc400078e00ffULL, 0x0000001fff2c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x0000002a2d067209ULL, 0x004fe20007810000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x000119d000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2b7424ULL, 0x002fe400078e00ffULL,
0x0000001fff2c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x0000002a00297202ULL, 0x004fe20000000f00ULL,
0xffffee6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x000fe200078e0020ULL,
0x00001c1f00347802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x00011a50002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff357224ULL, 0x000fc400078e001eULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0031ULL,
0xfffff48000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x002fe200078e0022ULL,
0x00011ad0002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fc400078e00ffULL,
0x00001c1fff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff357224ULL, 0x000fe400078e001eULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff337224ULL, 0x002fe200078e00ffULL,
0x0000003100197202ULL, 0x004fe20000000f00ULL, 0x00001c1fff347424ULL, 0x000fe200078e00ffULL,
0x00011b30002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff357224ULL, 0x000fe400078e001eULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff357224ULL, 0x002fe200078e001eULL,
0x00011b90002e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe400078e00ffULL,
0x00001c1fff347424ULL, 0x000fc400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e0031ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0031ULL,
0xfffff3c000007947ULL, 0x000fea000383ffffULL, 0x0180000008037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003067812ULL, 0x000fc800078ec0ffULL,
0x018000000600780cULL, 0x000fda0003f05070ULL, 0x0000000800038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x040fe40003f25070ULL,
0x008000000600780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff08ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000306ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000008067812ULL, 0x000fd600078ec0ffULL, 0x0080000006030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000800037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff2d7424ULL, 0x000fc800078e00ffULL, 0xfffee2e02c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff297424ULL, 0x000fe200078e00ffULL, 0x0000003100007348ULL, 0x000fe80003800000ULL,
0x0c00002b2a2a7389ULL, 0x0002a200000e002cULL, 0xfffee2a028007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000003500007348ULL, 0x000fe80003800000ULL,
0x0000003332317389ULL, 0x0002a200000e0034ULL, 0xfffee2602e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000023680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000778ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007f0ULL, 0x00000000000003a0ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b90ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000bb0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000bc0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000be0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c50ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c58ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000c68ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000011e80ULL, 0xa700001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012d00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012d10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012d10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000013190ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000c50ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000120b0ULL, 0x00000000000120b0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012d00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000013190ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_16_m_16_sm_80_cubin_len = 78448;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
