/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001bb40ULL, 0x000000000001b7c0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL,
0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL,
0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL,
0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL,
0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL,
0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b002200000377ULL, 0x0000000000019f90ULL, 0x0000000000000170ULL,
0x000b0022000003aaULL, 0x000000000001a100ULL, 0x0000000000000040ULL, 0x000b0022000003d5ULL,
0x000000000001a140ULL, 0x0000000000000040ULL, 0x000b0022000003ffULL, 0x000000000001a180ULL,
0x0000000000000100ULL, 0x000a00030000046dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000048dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001a280ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00019f9000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x0066640400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00019f9000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0xd208288080a00828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080d2920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001a10000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8016288080a00828ULL,
0x0000000310288082ULL, 0x80a0920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000016000000000ULL, 0x0001a14000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8016288080a00828ULL, 0x0000000310288082ULL,
0x80a0920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000001d800000000ULL,
0x0001a18000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001700082f04ULL,
0x00082304000000dfULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL,
0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001000082304ULL, 0x0008120400000000ULL,
0x0000000000000010ULL, 0x0000001000081104ULL, 0x0008230400000000ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0068016000000014ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000e6000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000031001cc2804ULL, 0x0000055000000380ULL, 0x0000325000002140ULL, 0x0000341000003300ULL,
0x000036f000003580ULL, 0x00003a6000003850ULL, 0x00003ab000003aa0ULL, 0x0000444000003ae0ULL,
0x000054e000005440ULL, 0x0000577000005600ULL, 0x00005a40000058e0ULL, 0x00005c8000005c40ULL,
0x00005cc000005c90ULL, 0x0000737000006370ULL, 0x0000751000007400ULL, 0x000077f000007680ULL,
0x00007b5000007950ULL, 0x00007ba000007b90ULL, 0x000081b000007bd0ULL, 0x0000931000009270ULL,
0x0000959000009420ULL, 0x0000986000009700ULL, 0x00009a9000009a50ULL, 0x00009ad000009aa0ULL,
0x0000a2300000a220ULL, 0x0000a2500000a240ULL, 0x0000d0900000d070ULL, 0x0000d0f00000d0c0ULL,
0x0000dce00000dcb0ULL, 0x0000dec00000dd10ULL, 0x00017c2000017be0ULL, 0x00017c4000017c30ULL,
0x00017cb000017c90ULL, 0x00017ce000017cd0ULL, 0x0001916000019110ULL, 0x000191f0000191b0ULL,
0x0001927000019230ULL, 0x00019310000192c0ULL, 0x000193b000019360ULL, 0x0001945000019400ULL,
0x000194e0000194a0ULL, 0x0001956000019520ULL, 0x00019600000195b0ULL, 0x000196a000019650ULL,
0x00019740000196f0ULL, 0x000197d000019790ULL, 0x0001985000019810ULL, 0x000198f0000198a0ULL,
0x0001999000019940ULL, 0x00019a30000199e0ULL, 0x00019ac000019a80ULL, 0x00019b4000019b00ULL,
0x00019be000019b90ULL, 0x00019c8000019c30ULL, 0x00019d3000019cd0ULL, 0x00019df000019d90ULL,
0x00019eb000019e50ULL, 0x00019f7000019f10ULL, 0x0000042002003904ULL, 0x00016600000000ffULL,
0x00000430003f0100ULL, 0x000166080000000dULL, 0x000004d0003f0120ULL, 0x000166880000000dULL,
0x00000e80003f0120ULL, 0x00016600000000ffULL, 0x00001080003f0107ULL, 0x0001668c0000007cULL,
0x00001120003f0102ULL, 0x000166880000007cULL, 0x00002f60003f0101ULL, 0x000166080000001bULL,
0x00002f80003f0101ULL, 0x0001660c0000001bULL, 0x00003150003f0105ULL, 0x0001660c0000001bULL,
0x000043c0003f0105ULL, 0x0001668800000018ULL, 0x00005140003f0101ULL, 0x000166280000001bULL,
0x000051a0003f0101ULL, 0x0001662c0000001bULL, 0x00005370003f0105ULL, 0x0001662c0000001bULL,
0x000062f0003f0105ULL, 0x0001669000000018ULL, 0x00007070003f0101ULL, 0x000166480000001bULL,
0x000070d0003f0101ULL, 0x0001664c0000001bULL, 0x000072a0003f0105ULL, 0x0001664c0000001bULL,
0x00008190003f0105ULL, 0x0001669800000018ULL, 0x00008f70003f0101ULL, 0x000166680000001bULL,
0x00008fd0003f0101ULL, 0x0001666c0000001fULL, 0x000091a0003f0105ULL, 0x0001666c0000001fULL,
0x0000a080003f0105ULL, 0x000166a000000018ULL, 0x0000fbe0003f0101ULL, 0x00016600000000ffULL,
0x000107d0003f0101ULL, 0x00016604000000ffULL, 0x000109e0003f0105ULL, 0x00016604000000ffULL,
0x00014e50003f0105ULL, 0x000000000000009dULL, 0x00014f50003f0101ULL, 0x000000040000009dULL,
0x00015120003f0105ULL, 0x000000040000009dULL, 0x00018f70003f0105ULL, 0x000166080000009fULL,
0x00018fd0003f0101ULL, 0x000166100000009fULL, 0x00019030003f0101ULL, 0x000166180000009fULL,
0x000190a0003f0101ULL, 0x000166200000009fULL, 0x00033803003f0101ULL, 0x0000eb2000301c04ULL,
0x0000edd00000eb50ULL, 0x0000f1900000efb0ULL, 0x0000f5500000f370ULL, 0x0000f9200000f730ULL,
0x00010a400000fac0ULL, 0x00000401000190e0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000023cULL,
0x0000001700000002ULL, 0x00000000000001c4ULL, 0x0000001700000002ULL, 0x000000000000014cULL,
0x0000001700000002ULL, 0x00000000000000ccULL, 0x0000001700000002ULL, 0x0000000000000044ULL,
0x0000001700000002ULL, 0x0000000000000215ULL, 0x0000001700000002ULL, 0x000000000000019dULL,
0x0000001700000002ULL, 0x0000000000000122ULL, 0x0000001700000002ULL, 0x00000000000000a8ULL,
0x0000001700000002ULL, 0x0000000000016700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000a37919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x00000001a3040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0002ULL,
0x00005c00a3020625ULL, 0x000fe200078e0002ULL, 0x00000006049b0981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ffa07624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000009e7919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff117624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000ee40000002300ULL,
0x0000590011117a24ULL, 0x000fe400078e02ffULL, 0x00000000009a7919ULL, 0x000ee20000002100ULL,
0x0000000000007308ULL, 0x010f220000001000ULL, 0x00000004ff957e24ULL, 0x002fe2000f8e00ffULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000324000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x010fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002200ULL, 0x0000040007097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x008fc800078e0a09ULL, 0x0000040003007624ULL, 0x000fca00078e02a0ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000ee20000209000ULL, 0x000000ff0900720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047810ULL, 0x008fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000724000021f000ULL, 0x000000ffff047224ULL, 0x008fe400078e00ffULL,
0x0000000509037224ULL, 0x010fc800078e02ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a03ULL,
0x0000000305057227ULL, 0x000fc800078e0004ULL, 0x000001000b037a24ULL, 0x002fe400078e0206ULL,
0x0000009e057f7227ULL, 0x000fe200078e00ffULL, 0x00001fff0b0b7589ULL, 0x000fe600000e0000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a7fULL, 0x00000000030d7a24ULL, 0x100fe200078e029aULL,
0x00000005ff9a7819ULL, 0x000fe2000001169aULL, 0x0000000009007224ULL, 0x000fc600078e029eULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x000000090000720cULL, 0x000fe20003f66070ULL,
0x00001fff9a9a7589ULL, 0x000e6200000e0000ULL, 0x0000000f0d00780cULL, 0x000fd20003f44070ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x0000000100003824ULL, 0x000fe200078e0a09ULL,
0x000000017f7f3810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff059424ULL, 0x000fe200078e00ffULL,
0x000000030d00780cULL, 0x000fe20003f64070ULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x000000090000720cULL, 0x000fe20003f86070ULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x01660004ff009388ULL, 0x000fe80000000a00ULL, 0x016608060d00a388ULL, 0x000fea0000008a00ULL,
0x3fffff60ff08b424ULL, 0x000fc400078e00ffULL, 0x000000017f7f4810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff7fd212ULL, 0x000fe400078e33ffULL, 0x0000007f0d00780cULL, 0x000fc60003f84070ULL,
0x000000ffff007224ULL, 0x000fc800078e0a7fULL, 0x00000000099e7224ULL, 0x000fe400078e029eULL,
0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL, 0x000000209e9e7824ULL, 0x000fe400078e00ffULL,
0xff317217ff0ac424ULL, 0x000fe200078e00ffULL, 0x016688080d00b388ULL, 0x000fe80000008a00ULL,
0x0164000a0d00c388ULL, 0x000fe20000004800ULL, 0x000000019b9b0824ULL, 0x004fc400078e0a02ULL,
0x00005800ff9b8624ULL, 0x000fe400078e00ffULL, 0x00005800a3028a24ULL, 0x000fe400078e02ffULL,
0x00005a009b037a24ULL, 0x000fe400078e02ffULL, 0x0000001102827224ULL, 0x000fe400078e02ffULL,
0x0000000103007824ULL, 0x040fe200078e0a9eULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000009e0300720cULL, 0x000fe20003f26070ULL, 0x00005a007f107a24ULL, 0x000fe200078e0282ULL,
0x0000002000007817ULL, 0x000fc80003800000ULL, 0x000000ff00817207ULL, 0x000fe40000800000ULL,
0x0000009a0b007211ULL, 0x002fe400078e10ffULL, 0x000000208100780cULL, 0x000fc60003f05270ULL,
0x0000000400037824ULL, 0x000fd400078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00005a0000077b06ULL, 0x000e620000209000ULL, 0x0000000000007919ULL, 0x000eae0000000000ULL,
0x0000000700077308ULL, 0x002e620000001000ULL, 0x00000004ff067819ULL, 0x004fc80000011600ULL,
0x00000002060a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103097824ULL, 0x000fe200078e0206ULL,
0x0ffffffe07047810ULL, 0x002fc60007ffe0ffULL, 0x00000001030d7824ULL, 0x000fe200078e020aULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x004fc800078e0a05ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f05087227ULL, 0x000fc800078e0004ULL, 0x000000019e057824ULL, 0x040fe400078e0209ULL,
0x000000019e0f7824ULL, 0x000fe400078e020dULL, 0x0000000508047227ULL, 0x000fc800078e00ffULL,
0x0000000f080c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a0cULL, 0x00005a0008077a24ULL, 0x000fe400078e0205ULL,
0x00005a000e087a24ULL, 0x000fc600078e020fULL, 0x00005a0007007a0cULL, 0x000fe40003f06070ULL,
0x00005a0008007a0cULL, 0x000fd60003f46070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fe40003f26070ULL,
0x00005a0008007a0cULL, 0x000fe40003f66070ULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff077a12ULL, 0x000fc600078e33ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c3810ULL, 0x000fe40007ffe0ffULL, 0x0000000407087207ULL, 0x040fe40004000000ULL,
0x0000000c07077207ULL, 0x000fe40004000000ULL, 0x0000000381047217ULL, 0x000fe20007800000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0a07ULL,
0x00005a000c057a24ULL, 0x000fe400078e0205ULL, 0x00005a000e0f7a24ULL, 0x000fe400078e020fULL,
0x0000000110057824ULL, 0x040fe400078e0205ULL, 0x00000001100c7824ULL, 0x000fe400078e020fULL,
0x0000000104047824ULL, 0x000fe400078e0a03ULL, 0x0000001108057224ULL, 0x000fc400078e0205ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x000000040600720cULL, 0x080fe20003f06070ULL,
0x0000001107077224ULL, 0x000fe200078e020cULL, 0x000000040a00720cULL, 0x000fe20003f26070ULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f008037812ULL, 0x000fc600078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000304047212ULL, 0x000fc600078efcffULL,
0x00000001090a7824ULL, 0x140fe200078e0200ULL, 0x0000000306037212ULL, 0x000fe200078efcffULL,
0x00000010090f7824ULL, 0x000fe200078e00ffULL, 0x0000600004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000010d097824ULL, 0x000fe200078e0200ULL, 0x0000600003067a10ULL, 0x000fe20007f7e0ffULL,
0x000000100d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff00f0a7812ULL, 0x000fe400078ee20aULL,
0x0000610005057a10ULL, 0x000fe400017fe4ffULL, 0xfffffff00c097812ULL, 0x000fe200078ee209ULL,
0x000000100a037824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc60001ffe4ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e8000c101c46ULL, 0x0000000006097faeULL, 0x0003e2000c901c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ff00047202ULL, 0x000fcc0000000f00ULL,
0x0000000600067308ULL, 0x002e620000001000ULL, 0x0000000300037211ULL, 0x004fc800078fe0ffULL,
0x00000002030d7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe06087810ULL, 0x002fc60007ffe0ffULL,
0x000000100d0c7824ULL, 0x000fe200078e00ffULL, 0x0000000800057305ULL, 0x000e64000021f000ULL,
0x000000ffff077224ULL, 0x002fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x0000000705097227ULL, 0x000fc800078e0004ULL, 0x000000019e047824ULL, 0x040fe400078e0203ULL,
0x000000019e077824ULL, 0x000fe400078e020dULL, 0x0000000409057227ULL, 0x000fc800078e00ffULL,
0x0000000709087227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0a08ULL, 0x00005a0009067a24ULL, 0x000fe400078e0204ULL,
0x00005a000a097a24ULL, 0x000fe400078e0207ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00005a0006007a0cULL, 0x000fe40003f06070ULL, 0x00005a0009007a0cULL, 0x000fd60003f46070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a0009007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000108083810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000806067207ULL, 0x000fc60004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a05ULL, 0x000000ffff087224ULL, 0x000fe400078e0a06ULL,
0x00005a0009047a24ULL, 0x000fe400078e0204ULL, 0x00005a0008077a24ULL, 0x000fe400078e0207ULL,
0x0000000110047824ULL, 0x040fe400078e0204ULL, 0x0000000110077824ULL, 0x000fc400078e0207ULL,
0x0000001000087824ULL, 0x000fe400078e00ffULL, 0x0000001105047224ULL, 0x080fe400078e0204ULL,
0x0000001106077224ULL, 0x000fe200078e0207ULL, 0x000000f0080f7812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000f04047212ULL, 0x000fc600078efcffULL, 0x0000000103097824ULL, 0x100fe200078e0200ULL,
0x0000000f06067212ULL, 0x000fe200078efcffULL, 0x000000010d037824ULL, 0x000fe200078e0200ULL,
0x0000600004047a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff00a097812ULL, 0x000fe400078ee209ULL,
0xfffffff00c037812ULL, 0x000fe400078ee203ULL, 0x0000600006067a10ULL, 0x000fe20007f3e0ffULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x0000610005057a10ULL, 0x000fe200007fe4ffULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc60000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000b901c46ULL,
0x0000000006037faeULL, 0x0003e4000b901c46ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fe200038e0000ULL, 0x00000004ff967424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000300047300ULL, 0x000e7000000e0000ULL,
0x0000000300067309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x00006800a3047625ULL, 0x000fc800078e0096ULL, 0x000000ffff067224ULL, 0x004fd000078e0a06ULL,
0x01660406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01660000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000604947981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000003f94237810ULL, 0x044fe40007ffe0ffULL,
0x000000ff94227810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff237819ULL, 0x000fe40000011623ULL,
0x00000008ff227819ULL, 0x000fca0000011622ULL, 0x0000eb1000008947ULL, 0x000fea0003800000ULL,
0x00000002ff7d7819ULL, 0x000fe2000001169aULL, 0x000000089a7c7824ULL, 0x000fe400078e00ffULL,
0x00000003ff077424ULL, 0x000fe200078e00ffULL, 0x03ffffff7d027812ULL, 0x000fca00078ec0ffULL,
0x00000004952b7824ULL, 0x000fca00078e0202ULL, 0x000000232b00720cULL, 0x000fda0003f06070ULL,
0x00000002a3028824ULL, 0x000fe400078e00ffULL, 0x00006a00ff038624ULL, 0x000fc800078e00ffULL,
0x00006a0002028624ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x000000022b058210ULL, 0x000fe20007ffe0ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01668c077cff738cULL, 0x0005e20000000000ULL, 0x0000660005048625ULL, 0x000fe200078e0096ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000604038981ULL, 0x000722000c1e1900ULL,
0x0000000195077810ULL, 0x004fe40007ffe0ffULL, 0x00000001ff027819ULL, 0x000fe2000001169aULL,
0x016688007cff7f8cULL, 0x0005e2000c80043fULL, 0x000000220700720cULL, 0x000fe20003f06070ULL,
0x00000100ff077424ULL, 0x000fe400078e00ffULL, 0x00000020027e7824ULL, 0x000fe200078e00ffULL,
0x000000019a047812ULL, 0x008fc600078ec0ffULL, 0x00000100950c7824ULL, 0x000fe400078e027eULL,
0x0000590003067a24ULL, 0x012fe400078e02ffULL, 0x000000407f037824ULL, 0x000fe400078e00ffULL,
0x0000004006067824ULL, 0x000fc600078e00ffULL, 0x0000002003297812ULL, 0x000fe200078ef80cULL,
0x0000640006067625ULL, 0x000fe200078e0007ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff167819ULL, 0x004fe40000011600ULL, 0x0000000c94057217ULL, 0x000fe40007800000ULL,
0x00000004160a7810ULL, 0x040fe40007ffe0ffULL, 0x00000008160e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a0cULL, 0x0000000c160f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a097824ULL, 0x100fe200078e0200ULL, 0x0000001016147810ULL, 0x000fe20007ffe0ffULL,
0x000000080a107824ULL, 0x000fe200078e00ffULL, 0x0000002005057817ULL, 0x000fe20003800000ULL,
0x000000010e0b7824ULL, 0x100fe200078e0200ULL, 0x00000014161a7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0xfffffff8101b7812ULL, 0x000fe200078ee209ULL,
0x000000010f0c7824ULL, 0x040fe200078e0200ULL, 0x0000007008097812ULL, 0x000fe200078ec0ffULL,
0x000000080f1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8121d7812ULL, 0x000fe200078ee20bULL,
0x00000001290b7824ULL, 0x000fe200078e0216ULL, 0x000000050a00720cULL, 0x080fe20003f86070ULL,
0x0000008004087824ULL, 0x000fe200078e0209ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000000050e00720cULL, 0x080fe20003f66070ULL,
0x00000001290d7824ULL, 0x000fe200078e020aULL, 0x000000050f00720cULL, 0x080fe20003f46070ULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x000000051600720cULL, 0x000fc60003fa6070ULL,
0x000001000d0c7825ULL, 0x000fe200078e0008ULL, 0x0000000a06107210ULL, 0x000fc60007f1e0ffULL,
0x0000000114117824ULL, 0x100fe200078e0200ULL, 0x0000000c06127210ULL, 0x000fe20007f3e0ffULL,
0x0000000814187824ULL, 0x000fe400078e00ffULL, 0x000000011a137824ULL, 0x040fe400078e0200ULL,
0x000000081a1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff818217812ULL, 0x000fe200078ee211ULL,
0x0000000107117824ULL, 0x000fe200000e060bULL, 0x0000000402187211ULL, 0x000fe200078e08ffULL,
0x00000001290b7824ULL, 0x000fe200078e020eULL, 0xfffffff81c257812ULL, 0x000fe200078ee213ULL,
0x0000000107137824ULL, 0x000fe200008e060dULL, 0x000000051400720cULL, 0x000fe20003f26070ULL,
0x00000001290d7824ULL, 0x000fe200078e020fULL, 0x0000e00018187811ULL, 0x000fe200078e68ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x0000001c161c7810ULL, 0x000fc60007ffe0ffULL,
0x00000001160e7824ULL, 0x000fe400078e0200ULL, 0x000001000d0c7825ULL, 0x000fc600078e0008ULL,
0x000000070e177812ULL, 0x000fe200078ec0ffULL, 0x00000001290f7824ULL, 0x000fe200078e0214ULL,
0x0000000a06147210ULL, 0x040fe20007f1e0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e0218ULL,
0x0000000c060c7210ULL, 0x000fe20007fde0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0008ULL,
0x0ffffff817177812ULL, 0x000fc600078ef800ULL, 0x0000000107157824ULL, 0x000fe200000e060bULL,
0x000000051a00720cULL, 0x000fe20003f06070ULL, 0x00000001290b7824ULL, 0x000fe200078e021aULL,
0x00000018161a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001070d7824ULL, 0x000fe200030e060dULL,
0x0000000e060e7210ULL, 0x000fe20007fde0ffULL, 0x000001000b0a7825ULL, 0x000fc800078e0008ULL,
0x00000001070f7824ULL, 0x000fe200030e060fULL, 0x0000000a06167210ULL, 0x000fe20007fde0ffULL,
0x0000001017197824ULL, 0x000fe400078e0218ULL, 0x0000000129277824ULL, 0x000fe400078e021aULL,
0x0000000107177824ULL, 0x000fe200030e060bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0003e2000e901c46ULL, 0x00000100270a7825ULL, 0x000fe200078e0008ULL,
0x000000051a00720cULL, 0x080fe40003fa6070ULL, 0x00000000121b7faeULL, 0x0005e2000e101c46ULL,
0x000000051c00720cULL, 0x000fe20003f86070ULL, 0x0000000129297824ULL, 0x000fe200078e021cULL,
0x0000000a060a7210ULL, 0x000fe20007fde0ffULL, 0x000000011a057824ULL, 0x000fc400078e0200ULL,
0x000000081a1a7824ULL, 0x000fe400078e00ffULL, 0x000000011c107824ULL, 0x042fe400078e0200ULL,
0x000000081c117824ULL, 0x000fe200078e00ffULL, 0xfffffff81a057812ULL, 0x000fe200078ee205ULL,
0x0000010029087825ULL, 0x000fc600078e0008ULL, 0xfffffff811117812ULL, 0x000fe200078ee210ULL,
0x00000001070b7824ULL, 0x000fe200030e060bULL, 0x0000000806067210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe400078e0218ULL, 0x000000101f1f7824ULL, 0x100fe200078e0218ULL,
0x0000000907077210ULL, 0x000fe200037fe4ffULL, 0x0000001021217824ULL, 0x100fe200078e0218ULL,
0x00000000141d7faeULL, 0x0005e2000d901c46ULL, 0x0000001025257824ULL, 0x100fe400078e0218ULL,
0x0000001005057824ULL, 0x100fe200078e0218ULL, 0x000000000c1f7faeULL, 0x0005e2000d101c46ULL,
0x0000001011117824ULL, 0x000fc600078e0218ULL, 0x000000000e217faeULL, 0x0005e8000c901c46ULL,
0x0000000016257faeULL, 0x0005e8000c101c46ULL, 0x000000000a057faeULL, 0x0005e8000e901c46ULL,
0x0000000006117faeULL, 0x0005e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x00000008000d7811ULL, 0x044fe400078fe8ffULL, 0x0000001400137811ULL, 0x000fc400078fe8ffULL,
0x0000001000117811ULL, 0x040fe200078fe8ffULL, 0x000000010d0a7824ULL, 0x040fe200078e0200ULL,
0x0000000400097811ULL, 0x040fe200078fe8ffULL, 0x000000080d0b7824ULL, 0x000fe200078e00ffULL,
0x0000001800157811ULL, 0x040fe200078fe8ffULL, 0x0000000813207824ULL, 0x000fe200078e00ffULL,
0x0000000c000f7811ULL, 0x000fe200078fe8ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0xfffffff80b1a7812ULL, 0x000fe200078ee20aULL, 0x00000001130b7824ULL, 0x100fe400078e0200ULL,
0x00000001110a7824ULL, 0x000fc400078e0200ULL, 0x0000000109057824ULL, 0x040fe200078e0200ULL,
0xfffffff820207812ULL, 0x000fe200078ee20bULL, 0x0000000809187824ULL, 0x000fe200078e00ffULL,
0xfffffff8171e7812ULL, 0x000fe200078ee20aULL, 0x00000001150c7824ULL, 0x140fe200078e0200ULL,
0x00000070080b7812ULL, 0x000fe200078ec0ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0x0000001c00177811ULL, 0x000fe200078fe8ffULL, 0x000000080f1c7824ULL, 0x040fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x000000010f057824ULL, 0x000fe200078e0200ULL,
0xfffffff819247812ULL, 0x000fe200078ee20cULL, 0x0000008004167824ULL, 0x000fc400078e020bULL,
0x00000001290b7824ULL, 0x000fe200078e0209ULL, 0x0000002900097211ULL, 0x000fe200078fe8ffULL,
0x0000000117087824ULL, 0x040fe200078e0200ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0x0000000000057211ULL, 0x000fe200078fe8ffULL,
0x0000000129197824ULL, 0x000fe200078e0217ULL, 0x000000ff00177202ULL, 0x000fe20000000f00ULL,
0x00000002020a7824ULL, 0x000fe200078e0204ULL, 0xfffffff81b267812ULL, 0x000fe200078ee208ULL,
0x00000001290d7824ULL, 0x000fe200078e020dULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x00000001290f7824ULL, 0x000fe200078e020fULL, 0x0000e0000a277811ULL, 0x000fe200078e68ffULL,
0x0000010009087825ULL, 0x000fe200078e0016ULL, 0x0ffffff805057812ULL, 0x000fc600078ef800ULL,
0x000001000b0a7825ULL, 0x000fe200078e0016ULL, 0x0000000806087210ULL, 0x000fc60007f1e0ffULL,
0x0000000129117824ULL, 0x000fe200078e0211ULL, 0x0000000a060a7210ULL, 0x000fe20007f3e0ffULL,
0x000001000d0c7825ULL, 0x000fc800078e0016ULL, 0x0000000129137824ULL, 0x000fe200078e0213ULL,
0x0000000c060c7210ULL, 0x000fe20007f5e0ffULL, 0x000001000f0e7825ULL, 0x000fc800078e0016ULL,
0x0000000129157824ULL, 0x000fe200078e0215ULL, 0x0000000e060e7210ULL, 0x000fe20007f7e0ffULL,
0x0000010011107825ULL, 0x000fc800078e0016ULL, 0x0000010013127825ULL, 0x000fc800078e0016ULL,
0x0000010015147825ULL, 0x000fc800078e0016ULL, 0x0000010019167825ULL, 0x000fc800078e0016ULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000001006107210ULL, 0x040fe20007f1e0ffULL,
0x00000001070b7824ULL, 0x000fe200008e060bULL, 0x0000001206127210ULL, 0x040fe20007f3e0ffULL,
0x0000001005057824ULL, 0x000fe400078e0227ULL, 0x00000001070d7824ULL, 0x040fe200010e060dULL,
0x0000001406147210ULL, 0x000fe20007f5e0ffULL, 0x0000001018197824ULL, 0x000fe200078e0227ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000b901c46ULL,
0x00000001070f7824ULL, 0x000fe200018e060fULL, 0x0000001606067210ULL, 0x000fe20007f7e0ffULL,
0x000000101a1b7824ULL, 0x100fe200078e0227ULL, 0x000000000a197faeULL, 0x0003e2000b901c46ULL,
0x000000101c1d7824ULL, 0x000fc400078e0227ULL, 0x000000101e1f7824ULL, 0x000fe200078e0227ULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000000107117824ULL, 0x040fe400000e0611ULL,
0x0000001020217824ULL, 0x000fe200078e0227ULL, 0x000000000e1d7faeULL, 0x0003e2000b901c46ULL,
0x0000000107137824ULL, 0x040fe400008e0613ULL, 0x0000001024257824ULL, 0x000fe200078e0227ULL,
0x00000000101f7faeULL, 0x0003e2000b901c46ULL, 0x0000000107157824ULL, 0x000fc400010e0615ULL,
0x0000001026277824ULL, 0x000fe200078e0227ULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x0000000107077824ULL, 0x000fc600018e0617ULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000006277faeULL, 0x0003e4000b901c46ULL, 0x00000300ff837624ULL, 0x000fe200078e00ffULL,
0x000000032b057812ULL, 0x006fe200078ec0ffULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffffd96837424ULL, 0x000fe200078e0283ULL,
0x000000030500780cULL, 0x000fc80003f05270ULL, 0x00000001831a7807ULL, 0x000fca0004000000ULL,
0x000000012b1a7824ULL, 0x000fca00078e021aULL, 0x000000231a00720cULL, 0x000fda0003f06070ULL,
0x00000002a3058824ULL, 0x000fe400078e00ffULL, 0x00006a00ff068624ULL, 0x000fc800078e00ffULL,
0x00006a0005058624ULL, 0x000fc800078e0206ULL, 0x0000000105978824ULL, 0x000fc800078e021aULL,
0x0000660097968625ULL, 0x000fca00078e0096ULL, 0x0000000696198981ULL, 0x000322000c1e1900ULL,
0x000000229500720cULL, 0x000fe20003f06070ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0xff31721700647802ULL, 0x000fe20000000f00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00007ff000000947ULL, 0x000fea0003800000ULL,
0x00000002a3057824ULL, 0x002fe400078e00ffULL, 0x00006a00ff067624ULL, 0x000fc400078e00ffULL,
0xff317217ff647424ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe400078e00ffULL,
0x00006a0005057624ULL, 0x000fc400078e0206ULL, 0x000000109a067824ULL, 0x000fe200078e00ffULL,
0x00000001950d7810ULL, 0x020fe20007ffe0ffULL, 0x0000590019197a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe006067812ULL, 0x000fe200078ec0ffULL,
0x00000040190c7824ULL, 0x000fe200078e00ffULL, 0x000000220d00720cULL, 0x000fe20003f06070ULL,
0x00000100ff0d7424ULL, 0x000fe400078e00ffULL, 0x0000010095067824ULL, 0x000fe400078e0206ULL,
0x000064000c0c7625ULL, 0x000fc600078e000dULL, 0x00000040060f7810ULL, 0x000fc80007ffe0ffULL,
0x000000200f067812ULL, 0x000fca00078ec0ffULL, 0x0000000103677824ULL, 0x000fe200078e0206ULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x0000000f94067217ULL, 0x000fe20007800000ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x00000003ff1f7819ULL, 0x100fe20000011600ULL,
0x000000809a0e7824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0fULL,
0x000000041f137810ULL, 0x040fe20007ffe0ffULL, 0x000020009a0f7824ULL, 0x000fe200078e00ffULL,
0x0000007010117812ULL, 0x000fe400078ec0ffULL, 0x000000081f157810ULL, 0x000fe20007ffe0ffULL,
0x0000000113107824ULL, 0x000fe200078e0200ULL, 0x000020000f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000813217824ULL, 0x000fe200078e00ffULL, 0x0000000c1f197810ULL, 0x000fe20007ffe0ffULL,
0x0000000815127824ULL, 0x000fe200078e00ffULL, 0x00000080110e7812ULL, 0x000fe200078ef80eULL,
0x0000400002027824ULL, 0x000fe200078e020fULL, 0x000000101f657810ULL, 0x000fe20007ffe0ffULL,
0x0000000115117824ULL, 0x000fe200078e0200ULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x00000001190f7824ULL, 0x100fe200078e0200ULL, 0x00000003656d7819ULL, 0x000fe200000006ffULL,
0x0000000819147824ULL, 0x000fe200078e00ffULL, 0xfffffff812697812ULL, 0x000fe200078ee211ULL,
0x0000000165107824ULL, 0x000fe200078e0200ULL, 0x000000141f6f7810ULL, 0x040fe20007ffe0ffULL,
0x000000011f117824ULL, 0x000fe200078e0267ULL, 0xfffffff8146b7812ULL, 0x000fe200078ee20fULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee210ULL,
0x000000016f127824ULL, 0x000fe200078e0200ULL, 0x0000002006067817ULL, 0x000fe20003800000ULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x0000f00002027810ULL, 0x000fc40007ffe0ffULL,
0x000000061300720cULL, 0x000fe20003f66070ULL, 0x000000086f717824ULL, 0x000fe200078e00ffULL,
0x000000100c167210ULL, 0x000fe20007f5e0ffULL, 0x0000000113137824ULL, 0x100fe200078e0267ULL,
0x000000061500720cULL, 0x0c0fe20003f06070ULL, 0x0000000115157824ULL, 0x000fe200078e0267ULL,
0xfffffff871717812ULL, 0x000fe200078ee212ULL, 0x000000011f127824ULL, 0x000fe200078e0200ULL,
0x000000061900720cULL, 0x080fe20003f26070ULL, 0x000000010d177824ULL, 0x000fe200010e0611ULL,
0x000000061f00720cULL, 0x000fe20003f86070ULL, 0x0000010013107825ULL, 0x000fe200078e000eULL,
0x00000007121b7812ULL, 0x000fc400078ec0ffULL, 0x000000181f737810ULL, 0x000fe20007ffe0ffULL,
0x0000010015127825ULL, 0x000fe200078e000eULL, 0x000000100c187210ULL, 0x040fe40007f5e0ffULL,
0x0ffffff81b1b7812ULL, 0x000fe200078ef800ULL, 0x0000000119197824ULL, 0x000fe200078e0267ULL,
0x000000120c1c7210ULL, 0x000fe40007fbe0ffULL, 0x0000001c1f757810ULL, 0x000fe20007ffe0ffULL,
0x0000010019147825ULL, 0x000fc800078e000eULL, 0x000000010d197824ULL, 0x000fe200010e0611ULL,
0x000000140c147210ULL, 0x000fe20007fde0ffULL, 0x0000000165117824ULL, 0x040fe200078e0267ULL,
0x000000066500720cULL, 0x080fe20003f46070ULL, 0x000000010d1d7824ULL, 0x000fe200028e0613ULL,
0x000000066f00720cULL, 0x000fe20003fa6070ULL, 0x000000101b137824ULL, 0x000fe400078e0202ULL,
0x0000010011107825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016137faeULL, 0x0003e2000e101c46ULL, 0x000000016f1f7824ULL, 0x000fe200078e0267ULL,
0x000000067300720cULL, 0x000fe20003f86070ULL, 0x000000010d157824ULL, 0x000fe200030e0615ULL,
0x000000100c207210ULL, 0x000fe20007fde0ffULL, 0x0000000173657824ULL, 0x000fe400078e0267ULL,
0x00000010211b7824ULL, 0x000fe400078e0202ULL, 0x000000010d217824ULL, 0x000fe400030e0611ULL,
0x0000010065107825ULL, 0x000fe200078e000eULL, 0x00000000181b7faeULL, 0x0005e2000d901c46ULL,
0x000000067500720cULL, 0x000fc40003f66070ULL, 0x000001001f127825ULL, 0x002fc800078e000eULL,
0x0000000175177824ULL, 0x000fe200078e0267ULL, 0x000000120c127210ULL, 0x040fe20007fde0ffULL,
0x0000000173067824ULL, 0x100fe200078e0200ULL, 0x0000000375677819ULL, 0x000fe200000006ffULL,
0x0000000873657824ULL, 0x000fe400078e00ffULL, 0x000000010d137824ULL, 0x000fe200030e0613ULL,
0x000000100c107210ULL, 0x000fe20007fde0ffULL, 0x0000000175167824ULL, 0x000fe200078e0200ULL,
0xfffffff865657812ULL, 0x000fe200078ee206ULL, 0x00000100170e7825ULL, 0x000fc600078e000eULL,
0xfffffff867677812ULL, 0x000fe200078ee216ULL, 0x000000010d117824ULL, 0x000fe200030e0611ULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001069177824ULL, 0x100fe400078e0202ULL,
0x000000106b197824ULL, 0x104fe400078e0202ULL, 0x000000106d1b7824ULL, 0x100fe200078e0202ULL,
0x000000001c177faeULL, 0x0003e2000c101c46ULL, 0x00000010711f7824ULL, 0x100fe400078e0202ULL,
0x0000001065657824ULL, 0x100fe200078e0202ULL, 0x0000000014197faeULL, 0x0003e2000c901c46ULL,
0x0000001067677824ULL, 0x000fc400078e0202ULL, 0x000000010d0d7824ULL, 0x000fe200030e060fULL,
0x00000000201b7faeULL, 0x0003e8000d101c46ULL, 0x00000000121f7faeULL, 0x0003e8000e901c46ULL,
0x0000000010657faeULL, 0x0003e8000e101c46ULL, 0x000000000c677faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x040fe200078e00ffULL,
0x0000000c00157811ULL, 0x000fe200078fe8ffULL, 0x000020009a0e7824ULL, 0x000fe200078e00ffULL,
0x0000000400117811ULL, 0x000fe200078fe8ffULL, 0x000000809a217824ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x0000000815107824ULL, 0x000fe200078e00ffULL,
0x000020000e0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000811657824ULL, 0x000fe200078e00ffULL,
0x0000008006207812ULL, 0x000fe200078ef821ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000000800137811ULL, 0x000fe200078fe8ffULL, 0x0000400002067824ULL, 0x000fe200078e020fULL,
0x00000018001d7811ULL, 0x040fe200078fe8ffULL, 0x00000001150f7824ULL, 0x100fe200078e0200ULL,
0x0000001000177811ULL, 0x040fe200078fe8ffULL, 0x0000000111027824ULL, 0x100fe200078e0200ULL,
0x0000001400197811ULL, 0x000fe200078fe8ffULL, 0x00000001130e7824ULL, 0x040fe200078e0200ULL,
0xfffffff8106b7812ULL, 0x000fe200078ee20fULL, 0x0000000813697824ULL, 0x000fe200078e00ffULL,
0xfffffff865657812ULL, 0x000fe200078ee202ULL, 0x000000011d0f7824ULL, 0x000fe200078e0200ULL,
0x00000003196f7819ULL, 0x000fe200000006ffULL, 0x000000081d107824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee20eULL, 0x0000000117027824ULL, 0x140fe200078e0200ULL,
0x0000001c001b7811ULL, 0x000fe200078fe8ffULL, 0x00000008176d7824ULL, 0x000fe200078e00ffULL,
0xfffffff810717812ULL, 0x000fe200078ee20fULL, 0x00000001190e7824ULL, 0x000fe200078e0200ULL,
0x00000067000f7211ULL, 0x040fe200078fe8ffULL, 0x0000000111117824ULL, 0x100fe200078e0267ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee202ULL, 0x0000000113137824ULL, 0x100fe200078e0267ULL,
0x0000000000027211ULL, 0x000fe200078fe8ffULL, 0x0000000115157824ULL, 0x000fe200078e0267ULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee20eULL, 0x000001000f0e7825ULL, 0x000fe200078e0020ULL,
0x00000007021f7812ULL, 0x000fc400078ec0ffULL, 0x0000f00006067810ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e0020ULL, 0x0000000e0c0e7210ULL, 0x040fe40007f1e0ffULL,
0x0ffffff81f1f7812ULL, 0x000fe200078ef800ULL, 0x0000000117177824ULL, 0x100fe200078e0267ULL,
0x000000100c107210ULL, 0x000fe20007f3e0ffULL, 0x0000000119197824ULL, 0x000fe400078e0267ULL,
0x0000010013127825ULL, 0x000fc800078e0020ULL, 0x0000010015147825ULL, 0x000fe200078e0020ULL,
0x000000120c127210ULL, 0x000fc60007f5e0ffULL, 0x000000011b027824ULL, 0x040fe200078e0200ULL,
0x000000140c147210ULL, 0x000fe20007f7e0ffULL, 0x000000081b737824ULL, 0x000fe200078e00ffULL,
0x000000130d137210ULL, 0x000fe200017fe4ffULL, 0x000000011d1d7824ULL, 0x100fe400078e0267ULL,
0x000000011b1b7824ULL, 0x000fe200078e0267ULL, 0xfffffff873737812ULL, 0x000fe200078ee202ULL,
0x0000010017167825ULL, 0x000fc800078e0020ULL, 0x0000010019187825ULL, 0x000fc800078e0020ULL,
0x000001001d1c7825ULL, 0x000fc800078e0020ULL, 0x000001001b207825ULL, 0x000fe200078e0020ULL,
0x0000001c0c1c7210ULL, 0x000fc60007f5e0ffULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x000000160c167210ULL, 0x040fe20007f1e0ffULL, 0x000000010d117824ULL, 0x000fe200008e0611ULL,
0x000000180c187210ULL, 0x040fe20007f3e0ffULL, 0x000000101f1b7824ULL, 0x100fe400078e0206ULL,
0x00000010651f7824ULL, 0x100fe400078e0206ULL, 0x000000010d157824ULL, 0x000fe200018e0615ULL,
0x000000200c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001069657824ULL, 0x100fe200078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1b7faeULL, 0x0003e2000b901c46ULL,
0x000000106b677824ULL, 0x000fc400078e0206ULL, 0x000000106d697824ULL, 0x100fe200078e0206ULL,
0x00000000101f7faeULL, 0x0003e2000b901c46ULL, 0x000000010d177824ULL, 0x000fe400000e0617ULL,
0x000000106f6b7824ULL, 0x100fe200078e0206ULL, 0x0000000012657faeULL, 0x0003e2000b901c46ULL,
0x000000010d197824ULL, 0x000fe400008e0619ULL, 0x00000010716d7824ULL, 0x000fe200078e0206ULL,
0x0000000014677faeULL, 0x0003e2000b901c46ULL, 0x000000010d1d7824ULL, 0x000fc400010e061dULL,
0x00000010736f7824ULL, 0x000fe200078e0206ULL, 0x0000000016697faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e0621ULL, 0x00000000186b7faeULL, 0x0003e8000b901c46ULL,
0x000000001c6d7faeULL, 0x0003e8000b901c46ULL, 0x000000000c6f7faeULL, 0x0003e4000b901c46ULL,
0x000000031a027812ULL, 0x000fe200078ec0ffULL, 0xffffffffff187424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000030200780cULL, 0x000fc80003f05270ULL,
0x00000001830d7807ULL, 0x000fca0004000000ULL, 0x000000010d1a7824ULL, 0x000fca00078e021aULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x00000001050c8824ULL, 0x000fe400078e021aULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000066000c0c8625ULL, 0x000fca00078e000dULL,
0x000000060c188981ULL, 0x000322000c1e1900ULL, 0xffffffe07c1b7812ULL, 0x040fe400078ec0ffULL,
0x000000107c027812ULL, 0x040fe400078ec0ffULL, 0x000000087c067812ULL, 0x000fc800078ec0ffULL,
0x0000001b061b7210ULL, 0x000fe20007ffe002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016608001b107f8cULL, 0x0022a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01660c001b0f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140fULL,
0x0000001302027211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x0000000202027819ULL, 0x000fc8000000120fULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01660c001b0f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff807819ULL, 0x000fe20000011600ULL,
0xffffffffff847424ULL, 0x000fc600078e00ffULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c80807812ULL, 0x000fc600078ec0ffULL, 0x000000807d0d7824ULL, 0x000fc800078e0206ULL,
0x000000010d0d7824ULL, 0x000fca00078e0280ULL, 0x016000000d0f7984ULL, 0x000ea80000000800ULL,
0x016200000d0c7984ULL, 0x0006620000000800ULL, 0x000000640f00720bULL, 0x004fe20003f1d000ULL,
0x00015ea27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x008fc800000e0100ULL,
0x000000ff0d00720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff027224ULL, 0x000fe400078e0064ULL,
0x0000001fff867424ULL, 0x000fc400078e00ffULL, 0xffffffffff857424ULL, 0x000fcc00078e00ffULL,
0x0000070000009947ULL, 0x000fea0003800000ULL, 0x0000009a7d00720cULL, 0x000fe40003f25270ULL,
0x000000640f00720bULL, 0x000fe20003f54000ULL, 0x00015e427f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x000fc400010e0100ULL, 0x000000809a119824ULL, 0x000fe200078e0206ULL,
0x000000640f027209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe60003800000ULL,
0x0000001180119210ULL, 0x000fca0007ffe0ffULL, 0x0164000211009388ULL, 0x0005e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f25270ULL, 0x000005e000009947ULL, 0x000fea0003800000ULL,
0x0000006402107221ULL, 0x004fe20000010100ULL, 0x000000ff0eff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fcc0000410000ULL,
0x0000001000107308ULL, 0x000ea40000000800ULL, 0x000000101e1e7220ULL, 0x004fe40000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x00015d827f007947ULL, 0x000fea000b800000ULL, 0x00001f1f101f7589ULL, 0x0004e400000e0000ULL,
0x0000001f60607220ULL, 0x08cfe20000410000ULL, 0x0000001f61617220ULL, 0x080fe20000410000ULL,
0x0000001f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000001f58587220ULL, 0x080fe20000410000ULL, 0x0000001f59597220ULL, 0x080fe20000410000ULL,
0x0000001f54547220ULL, 0x080fe20000410000ULL, 0x0000001f55557220ULL, 0x080fe20000410000ULL,
0x0000001f50507220ULL, 0x080fe20000410000ULL, 0x0000001f51517220ULL, 0x080fe20000410000ULL,
0x0000001f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001f48487220ULL, 0x080fe20000410000ULL, 0x0000001f49497220ULL, 0x080fe20000410000ULL,
0x0000001f44447220ULL, 0x080fe20000410000ULL, 0x0000001f45457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000eff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008001f7811ULL, 0x000fe200078ff0ffULL, 0x00015c527f007947ULL, 0x000fea000b800000ULL,
0x00001f1f101f7589ULL, 0x0004e400000e0000ULL, 0x0000001f62627220ULL, 0x08cfe20000410000ULL,
0x0000001f63637220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00000eff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000010001f7811ULL, 0x000fe200078ff0ffULL,
0x00015b227f007947ULL, 0x000fea000b800000ULL, 0x00001f1f101f7589ULL, 0x0004e400000e0000ULL,
0x0000001f40407220ULL, 0x08cfe20000410000ULL, 0x0000001f41417220ULL, 0x080fe20000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001f38387220ULL, 0x080fe20000410000ULL, 0x0000001f39397220ULL, 0x080fe20000410000ULL,
0x0000001f34347220ULL, 0x080fe20000410000ULL, 0x0000001f35357220ULL, 0x080fe20000410000ULL,
0x0000001f30307220ULL, 0x080fe20000410000ULL, 0x0000001f31317220ULL, 0x080fe20000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001f28287220ULL, 0x080fe20000410000ULL, 0x0000001f29297220ULL, 0x080fe20000410000ULL,
0x0000001f24247220ULL, 0x080fe20000410000ULL, 0x0000001f25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000000eff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000018001f7811ULL, 0x000fe200078ff0ffULL,
0x00015a027f007947ULL, 0x000fea000b800000ULL, 0x00001f1f101f7589ULL, 0x0004e400000e0000ULL,
0x0000001f42427220ULL, 0x08cfe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000000e0dff7212ULL, 0x000fda00078230ffULL,
0x800000020f0f1221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00071308ULL, 0x000ea40000000800ULL,
0x000000070c0c1220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000001e0c1e7221ULL, 0x002fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000010ffULL, 0x00000002ff0b7819ULL, 0x000fe40000011600ULL,
0x00005410080c7816ULL, 0x000fe20000000008ULL, 0x000158327f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0c087589ULL, 0x0002a400000e0000ULL, 0x000000080b1f7810ULL, 0x000fe20007ffe0ffULL,
0x000158627f007947ULL, 0x000fea000b800000ULL, 0x000000100b0d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1f0c097589ULL, 0x00066800000e0000ULL, 0x00001f0d0c0a7589ULL, 0x0006a400000e0000ULL,
0x000000180b1f7810ULL, 0x008fe20007ffe0ffULL, 0x000158b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f0c0b7589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000029a1c7824ULL, 0x000fe200078e00ffULL, 0x00000008000d7812ULL, 0x000fe200078ec0ffULL,
0x000020009a197824ULL, 0x000fe200078e00ffULL, 0x0000a0007d1f7811ULL, 0x002fe200078e60ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000041c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000029000007945ULL, 0x000fe20003800000ULL, 0x000000070d137812ULL, 0x000fc400078ef800ULL,
0x0000001d000c7211ULL, 0x040fe400078fe0ffULL, 0x0000001013217812ULL, 0x040fe200078efcffULL,
0x0000000813127824ULL, 0x040fe200078e00ffULL, 0x0000001300107211ULL, 0x000fe200078fe0ffULL,
0x00000001130d7824ULL, 0x040fe200078e020cULL, 0x0000000313167819ULL, 0x000fe200000006ffULL,
0x000000010c0e7824ULL, 0x000fe200078e0221ULL, 0x00000002100f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000821117824ULL, 0x000fe200078e00ffULL, 0xfffffff8120c7812ULL, 0x000fe200078ee20dULL,
0x0000000813147824ULL, 0x040fe200078e00ffULL, 0x0000000610157810ULL, 0x000fe20007ffe0ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0xfffffff8110d7812ULL, 0x000fe200078ee20eULL,
0x000000100c747824ULL, 0x000fe200078e021fULL, 0xffffc00019117812ULL, 0x000fc400078ec0ffULL,
0xfffffff8140e7812ULL, 0x000fe200078ee20fULL, 0x00000008130f7824ULL, 0x000fe200078e00ffULL,
0x0000000410147810ULL, 0x000fe20007ffe0ffULL, 0x0000200004127824ULL, 0x000fe200078e0211ULL,
0x000000007474783bULL, 0x000e620000000200ULL, 0x000000100d647824ULL, 0x000fe200078e021fULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee210ULL, 0xfffffff817107812ULL, 0x000fe400078ee214ULL,
0x0000e00012127810ULL, 0x000fe20007ffe0ffULL, 0x000000006464783bULL, 0x000ee20000000200ULL,
0xfffffff816117812ULL, 0x000fc600078ee215ULL, 0x000000100f707824ULL, 0x100fe400078e0212ULL,
0x000000100e6c7824ULL, 0x100fe400078e0212ULL, 0x0000001010147824ULL, 0x000fe200078e0212ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000874747231ULL, 0x086fe400003400ffULL,
0x0000000876767231ULL, 0x000fe400003400ffULL, 0x0000000975757231ULL, 0x080fe400003400ffULL,
0x0000000977777231ULL, 0x000fc400003400ffULL, 0x0000000a64647231ULL, 0x088fe400003400ffULL,
0x0000000a66667231ULL, 0x000fe400003400ffULL, 0x0000000b65657231ULL, 0x080fe400003400ffULL,
0x0000000b67677231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000001414783bULL, 0x000ee20000004200ULL, 0x0000001011687824ULL, 0x000fe200078e0212ULL,
0x000000021d1d7812ULL, 0x000fe200078efcffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x000000006c6c783bULL, 0x000fe20000004200ULL, 0x00000001ff877819ULL, 0x000fc4000001169aULL,
0x0000001d00127211ULL, 0x000fe200078fe0ffULL, 0x000000006868783bULL, 0x000ea40000004200ULL,
0x0000000287207824ULL, 0x000fe400078e0204ULL, 0x000000007070783bULL, 0x000e660000004200ULL,
0x0000e00020207811ULL, 0x000fe200078e68ffULL, 0x00000016744c723cULL, 0x08af70000004184cULL,
0x00000016642c723cULL, 0x000b6e000004182cULL, 0x0000000813167824ULL, 0x060fe200078e00ffULL,
0x000000147450723cULL, 0x000f620000041850ULL, 0x0000000113137824ULL, 0x000fce00078e0212ULL,
0x000000146430723cULL, 0x000b6e0000041830ULL, 0x0000000821157824ULL, 0x060fe200078e00ffULL,
0x000000687448723cULL, 0x004f620000041848ULL, 0x0000000121147824ULL, 0x000fe200078e0212ULL,
0xfffffff816127812ULL, 0x000fc800078ee213ULL, 0xfffffff815137812ULL, 0x000fe200078ee214ULL,
0x0000000821147824ULL, 0x000fe200078e00ffULL, 0x0000002100157211ULL, 0x000fe200078fe0ffULL,
0x000000686428723cULL, 0x000b620000041828ULL, 0x0000001012787824ULL, 0x100fe400078e021fULL,
0x0000000215167810ULL, 0x000fe20007ffe0ffULL, 0x00000010131f7824ULL, 0x000fe200078e021fULL,
0x0000000415177810ULL, 0x000fe40007ffe0ffULL, 0x0000000821697824ULL, 0x060fe200078e00ffULL,
0x0000006c7458723cULL, 0x000f620000041858ULL, 0x0000000821687824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee215ULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0x00000006151d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff869157812ULL, 0x000fe400078ee216ULL,
0x0000006c6438723cULL, 0x000b620000041838ULL, 0xfffffff868167812ULL, 0x000fcc00078ee217ULL,
0x00000008216c7824ULL, 0x020fe200078e00ffULL, 0x000000706440723cULL, 0x000f680000041840ULL,
0xfffffff86c177812ULL, 0x000fe200078ee21dULL, 0x00000010146c7824ULL, 0x000fc600078e0220ULL,
0x00000072643c723cULL, 0x040f70000004183cULL, 0x0000006e6434723cULL, 0x040f700000041834ULL,
0x0000006a6424723cULL, 0x000b640000041824ULL, 0x000000001f64783bULL, 0x0204ec0000000200ULL,
0x000000707460723cULL, 0x040b6e0000041860ULL, 0x0000001016707824ULL, 0x120fe200078e0220ULL,
0x00000072745c723cULL, 0x040f70000004185cULL, 0x0000006e7454723cULL, 0x040f700000041854ULL,
0x0000006a7444723cULL, 0x000b6e0000041844ULL, 0x0000001015747824ULL, 0x020fe200078e0220ULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000878787231ULL, 0x086fe400003400ffULL,
0x000000087a7a7231ULL, 0x000fc400003400ffULL, 0x0000000979797231ULL, 0x080fe400003400ffULL,
0x000000097b7b7231ULL, 0x000fe400003400ffULL, 0x0000000a64647231ULL, 0x088fe400003400ffULL,
0x0000000a66667231ULL, 0x000fe400003400ffULL, 0x0000000b65657231ULL, 0x080fe400003400ffULL,
0x0000000b67677231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000001017687824ULL, 0x000fe200078e0220ULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x00005900181d7a24ULL, 0x010fe200078e02ffULL, 0xfffffff81c187812ULL, 0x000fc400078ec0ffULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x00000087951c7211ULL, 0x000fc600078e18ffULL,
0x000000007070783bULL, 0x000ee80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x0000006c7860723cULL, 0x042b700000041860ULL, 0x0000006e785c723cULL, 0x040b70000004185cULL,
0x000000747858723cULL, 0x044b700000041858ULL, 0x000000767854723cULL, 0x040b700000041854ULL,
0x000000707850723cULL, 0x048b700000041850ULL, 0x00000072784c723cULL, 0x040b70000004184cULL,
0x000000687848723cULL, 0x040b700000041848ULL, 0x0000006a7844723cULL, 0x000b700000041844ULL,
0x000000746438723cULL, 0x040b700000041838ULL, 0x000000766434723cULL, 0x040b700000041834ULL,
0x000000706430723cULL, 0x040b700000041830ULL, 0x00000072642c723cULL, 0x040b70000004182cULL,
0x0000006c6440723cULL, 0x040b700000041840ULL, 0x0000006e643c723cULL, 0x040b70000004183cULL,
0x000000686428723cULL, 0x040b700000041828ULL, 0x0000006a6424723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000195217810ULL, 0x000fe20007ffe0ffULL,
0x0166880018ff7f8cULL, 0x0003e2000c80043fULL, 0x000000801c1f7811ULL, 0x000fe200078e28ffULL,
0x00000100ff1c7424ULL, 0x000fe200078e00ffULL, 0x000000222100720cULL, 0x000fe20003f06070ULL,
0x000000401d1d7824ULL, 0x000fe200078e00ffULL, 0x000000201f207812ULL, 0x000fc600078ec0ffULL,
0x000064001d1c7625ULL, 0x000fc800078e001cULL, 0x0000000103797824ULL, 0x020fe200078e0220ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff707819ULL, 0x002fe20000011600ULL, 0x000000809a217824ULL, 0x000fe200078e00ffULL,
0x0000200019207812ULL, 0x000fe400078ec0ffULL, 0x0000000470647810ULL, 0x040fe40007ffe0ffULL,
0x0000000870687810ULL, 0x000fe20007ffe0ffULL, 0x0000400087877824ULL, 0x000fe200078e0220ULL,
0x0000001f94197217ULL, 0x000fe20007800000ULL, 0x0000000164207824ULL, 0x100fe200078e0200ULL,
0x0000001470887810ULL, 0x000fe20007ffe0ffULL, 0x0000000864677824ULL, 0x000fe200078e00ffULL,
0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000168657824ULL, 0x000fe200078e0200ULL,
0x0000001070787810ULL, 0x000fe20007ffe0ffULL, 0x0000000868747824ULL, 0x000fe200078e00ffULL,
0xfffffff867727812ULL, 0x000fe200078ee220ULL, 0x0000000119197824ULL, 0x000fe200078e0a1fULL,
0x0000008006207812ULL, 0x000fe200078ef821ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0xfffffff874747812ULL, 0x000fe200078ee265ULL, 0x0000000170657824ULL, 0x100fe200078e0279ULL,
0x0000002019197817ULL, 0x000fe20003800000ULL, 0x0000000164677824ULL, 0x000fc400078e0279ULL,
0x00000001886b7824ULL, 0x000fe200078e0200ULL, 0x000000196400720cULL, 0x080fe20003f86070ULL,
0x0000010065647825ULL, 0x100fe200078e0020ULL, 0x000000196e00720cULL, 0x080fe40003f46070ULL,
0x000000196800720cULL, 0x080fe20003f66070ULL, 0x0000010067667825ULL, 0x000fe200078e0020ULL,
0x000000641c6a7210ULL, 0x000fe40007f1e0ffULL, 0x000000197000720cULL, 0x000fe20003fa6070ULL,
0x00000008888a7824ULL, 0x000fe200078e00ffULL, 0x000000661c6c7210ULL, 0x000fe20007f3e0ffULL,
0x000000016e1f7824ULL, 0x000fc400078e0200ULL, 0x000000086e767824ULL, 0x000fe200078e00ffULL,
0xfffffff88a8a7812ULL, 0x000fe200078ee26bULL, 0x000000011d6b7824ULL, 0x040fe400000e0665ULL,
0x0000000168657824ULL, 0x000fe200078e0279ULL, 0xfffffff876767812ULL, 0x000fe200078ee21fULL,
0x000000011d6d7824ULL, 0x000fe200008e0667ULL, 0x000000796e677210ULL, 0x000fe20007ffe0ffULL,
0x0000000178697824ULL, 0x040fe200078e0200ULL, 0x000000197800720cULL, 0x040fe20003f26070ULL,
0x00000008787a7824ULL, 0x000fc400078e00ffULL, 0x00000001701f7824ULL, 0x000fe400078e0200ULL,
0x0000010065647825ULL, 0x000fe200078e0020ULL, 0xfffffff87a7a7812ULL, 0x000fe400078ee269ULL,
0x000000071f717812ULL, 0x000fe200078ec0ffULL, 0x0000010067667825ULL, 0x000fe200078e0020ULL,
0x000000641c6e7210ULL, 0x000fe40007f1e0ffULL, 0x0000e000871f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000178697824ULL, 0x000fe200078e0279ULL, 0x000000661c667210ULL, 0x000fe20007fde0ffULL,
0x000000011d6f7824ULL, 0x000fe200000e0665ULL, 0x0ffffff871647812ULL, 0x000fe200078ef800ULL,
0x0000010069687825ULL, 0x000fe200078e0020ULL, 0x0000001c70787810ULL, 0x000fc40007ffe0ffULL,
0x000000198800720cULL, 0x040fe20003f06070ULL, 0x0000000188657824ULL, 0x000fe400078e0279ULL,
0x000000011d677824ULL, 0x000fe200030e0667ULL, 0x000000681c687210ULL, 0x000fe20007fde0ffULL,
0x0000001064737824ULL, 0x000fe400078e021fULL, 0x0000010065647825ULL, 0x000fc600078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a737faeULL, 0x0003e2000e901c46ULL,
0x0000001072757824ULL, 0x000fe200078e021fULL, 0x0000001870727810ULL, 0x000fe20007ffe0ffULL,
0x000000011d697824ULL, 0x040fe200030e0669ULL, 0x000000641c707210ULL, 0x000fe40007fde0ffULL,
0x000000006c757faeULL, 0x0005e2000e101c46ULL, 0x0000000172777824ULL, 0x040fe200078e0279ULL,
0x000000197200720cULL, 0x080fe20003fa6070ULL, 0x000000011d717824ULL, 0x000fe200030e0665ULL,
0x000000197800720cULL, 0x000fe20003f86070ULL, 0x0000010077647825ULL, 0x000fc800078e0020ULL,
0x0000000178197824ULL, 0x000fe200078e0279ULL, 0x000000641c647210ULL, 0x000fe20007fde0ffULL,
0x00000001726a7824ULL, 0x142fe400078e0200ULL, 0x0000000872737824ULL, 0x000fe400078e00ffULL,
0x00000001786b7824ULL, 0x040fe400078e0200ULL, 0x00000008786c7824ULL, 0x004fe200078e00ffULL,
0xfffffff8736a7812ULL, 0x000fe200078ee26aULL, 0x0000010019207825ULL, 0x000fc600078e0020ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee26bULL, 0x000000011d657824ULL, 0x040fe200030e0665ULL,
0x000000201c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001074197824ULL, 0x100fe400078e021fULL,
0x00000010766b7824ULL, 0x100fe200078e021fULL, 0x000000211d1d7210ULL, 0x000fe200037fe4ffULL,
0x000000107a6d7824ULL, 0x100fe200078e021fULL, 0x000000006e197faeULL, 0x0003e2000d901c46ULL,
0x000000108a737824ULL, 0x100fe400078e021fULL, 0x000000106a757824ULL, 0x100fe200078e021fULL,
0x00000000666b7faeULL, 0x0003e2000d101c46ULL, 0x000000106c1f7824ULL, 0x000fc600078e021fULL,
0x00000000686d7faeULL, 0x0003e8000c901c46ULL, 0x0000000070737faeULL, 0x0003e8000c101c46ULL,
0x0000000064757faeULL, 0x0003e8000e901c46ULL, 0x000000001c1f7faeULL, 0x0003e2000e101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000400657811ULL, 0x002fe200078fe8ffULL,
0x000000809a717824ULL, 0x000fe200078e00ffULL, 0x0000200019207812ULL, 0x000fc400078ec0ffULL,
0x0000000c00697811ULL, 0x040fe200078fe8ffULL, 0x0000000165197824ULL, 0x140fe200078e0200ULL,
0x00000010006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000865647824ULL, 0x000fe200078e00ffULL,
0x0000000800677811ULL, 0x040fe200078fe8ffULL, 0x0000000169217824ULL, 0x140fe200078e0200ULL,
0x00000018006f7811ULL, 0x000fe200078fe8ffULL, 0x0000000869687824ULL, 0x000fe200078e00ffULL,
0xfffffff864737812ULL, 0x000fe200078ee219ULL, 0x000000016b197824ULL, 0x140fe200078e0200ULL,
0x00000014006d7811ULL, 0x000fe200078fe8ffULL, 0x000000086b647824ULL, 0x000fe200078e00ffULL,
0xfffffff868777812ULL, 0x000fe200078ee221ULL, 0x00000001671f7824ULL, 0x140fe200078e0200ULL,
0x0000008006707812ULL, 0x000fe200078ef871ULL, 0x0000000867667824ULL, 0x000fe200078e00ffULL,
0xfffffff8647b7812ULL, 0x000fe200078ee219ULL, 0x000000016f217824ULL, 0x140fe200078e0200ULL,
0x0000000000197211ULL, 0x000fe200078fe8ffULL, 0x000000086f647824ULL, 0x000fe200078e00ffULL,
0xfffffff866757812ULL, 0x000fe200078ee21fULL, 0x000000016d1f7824ULL, 0x000fc400078e0200ULL,
0x000000086d667824ULL, 0x000fe200078e00ffULL, 0xfffffff864897812ULL, 0x000fe200078ee221ULL,
0x0000400087207824ULL, 0x000fe200078e0220ULL, 0x0000001c00217811ULL, 0x000fe200078fe8ffULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0xfffffff866877812ULL, 0x000fe200078ee21fULL,
0x0000000165657824ULL, 0x100fe200078e0279ULL, 0x00000007191f7812ULL, 0x000fe200078ec0ffULL,
0x0000000121647824ULL, 0x040fe200078e0200ULL, 0x0000007921197210ULL, 0x0c0fe20007ffe0ffULL,
0x00000008218b7824ULL, 0x000fe200078e00ffULL, 0x0000007900217211ULL, 0x000fe200078fe8ffULL,
0x0000000167677824ULL, 0x100fe200078e0279ULL, 0x0000e00020727810ULL, 0x000fe20007ffe0ffULL,
0x0000000169697824ULL, 0x000fe200078e0279ULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee264ULL,
0x0000010021207825ULL, 0x000fe200078e0070ULL, 0x0ffffff81f1f7812ULL, 0x000fc600078ef800ULL,
0x0000010065647825ULL, 0x000fe200078e0070ULL, 0x000000201c207210ULL, 0x000fc60007f1e0ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0279ULL, 0x000000641c647210ULL, 0x000fe20007f3e0ffULL,
0x0000010067667825ULL, 0x000fc800078e0070ULL, 0x000000016d6d7824ULL, 0x000fe200078e0279ULL,
0x000000661c667210ULL, 0x000fe20007f5e0ffULL, 0x0000010069687825ULL, 0x000fc800078e0070ULL,
0x000000016f6f7824ULL, 0x000fe200078e0279ULL, 0x000000681c687210ULL, 0x000fe20007f7e0ffULL,
0x000001006b6a7825ULL, 0x000fc800078e0070ULL, 0x000001006d6c7825ULL, 0x000fc800078e0070ULL,
0x000001006f6e7825ULL, 0x000fc800078e0070ULL, 0x0000010019707825ULL, 0x000fc800078e0070ULL,
0x000000011d217824ULL, 0x040fe200000e0621ULL, 0x0000006a1c6a7210ULL, 0x040fe20007f1e0ffULL,
0x000000011d657824ULL, 0x000fe200008e0665ULL, 0x0000006c1c6c7210ULL, 0x040fe20007f3e0ffULL,
0x000000101f197824ULL, 0x100fe400078e0272ULL, 0x000000011d677824ULL, 0x000fe200010e0667ULL,
0x0000006e1c6e7210ULL, 0x040fe20007f5e0ffULL, 0x00000010731f7824ULL, 0x100fe200078e0272ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020197faeULL, 0x0003e2000b901c46ULL,
0x000000011d697824ULL, 0x000fe200018e0669ULL, 0x000000701c1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001075737824ULL, 0x100fe200078e0272ULL, 0x00000000641f7faeULL, 0x0003e2000b901c46ULL,
0x0000001077757824ULL, 0x000fc400078e0272ULL, 0x000000107b777824ULL, 0x100fe200078e0272ULL,
0x0000000066737faeULL, 0x0003e2000b901c46ULL, 0x000000011d6b7824ULL, 0x000fe400000e066bULL,
0x0000001087797824ULL, 0x100fe200078e0272ULL, 0x0000000068757faeULL, 0x0003e2000b901c46ULL,
0x000000011d6d7824ULL, 0x000fe400008e066dULL, 0x00000010897b7824ULL, 0x000fe200078e0272ULL,
0x000000006a777faeULL, 0x0003e2000b901c46ULL, 0x000000011d6f7824ULL, 0x000fc400010e066fULL,
0x000000108b877824ULL, 0x000fe200078e0272ULL, 0x000000006c797faeULL, 0x0003e2000b901c46ULL,
0x000000011d1d7824ULL, 0x000fc600018e0671ULL, 0x000000006e7b7faeULL, 0x0003e8000b901c46ULL,
0x000000001c877faeULL, 0x0003e4000b901c46ULL, 0x000000031a197812ULL, 0x002fc800078ec0ffULL,
0x000000031900780cULL, 0x000fc80003f05270ULL, 0x0000000183197807ULL, 0x000fca0004000000ULL,
0x000000011a1a7824ULL, 0x000fe400078e0219ULL, 0xffffffffff197424ULL, 0x000fc600078e00ffULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001051c7824ULL, 0x000fe400078e021aULL, 0x00000004ff1d7424ULL, 0x000fc800078e00ffULL,
0x000066001c1c7625ULL, 0x000fca00078e001dULL, 0x000000061c197981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016628001b647f8cULL, 0x0004e4000c80043fULL, 0x00000000001c7805ULL, 0x002fc40000015200ULL,
0xffffffe07c1b7812ULL, 0x044fe400078ec0ffULL, 0x000000107c207812ULL, 0x040fe400078ec0ffULL,
0x000000087c1f7812ULL, 0x000fc800078ec0ffULL, 0x0000001b1f1b7210ULL, 0x000fca0007ffe020ULL,
0x01662c001b1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x00afe40007804865ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201c207210ULL, 0x000fc80007f1e1ffULL,
0x000000211d217210ULL, 0x000fe400007fe5ffULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011421ULL,
0x000000201f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x000000021f1f7819ULL, 0x000fc80000001220ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000166667810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01662c001b1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000209a1c7824ULL, 0x000fca00078e00ffULL, 0xffffff801c1d7812ULL, 0x000fc800078ec0ffULL,
0x00000080061d7810ULL, 0x000fca0007ffe01dULL, 0x00000001801d7824ULL, 0x000fca00078e021dULL,
0x016000001d657984ULL, 0x000e680000000800ULL, 0x016200001d647984ULL, 0x0004e20000000800ULL,
0x000000026500720bULL, 0x002fe20003f1d000ULL, 0x00013fa27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x004fc800000e0100ULL, 0x000000ff1d00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff1c7224ULL, 0x000fd400078e0002ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000017d1f7810ULL, 0x000fe40007ffe0ffULL, 0x000000026500720bULL, 0x000fe40003f34000ULL,
0x0000009a1f00720cULL, 0x000fe20003f05270ULL, 0x00013f527f007947ULL, 0x000fd4000b800000ULL,
0x00000000001c7806ULL, 0x000fc400008e0100ULL, 0x000000809a218824ULL, 0x000fe200078e0206ULL,
0x00000002651f8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000180208824ULL, 0x000fca00078e0221ULL, 0x0164001f20008388ULL, 0x0003e20000000800ULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x00000002651f7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff1cff7812ULL, 0x000fc6000780c0ffULL, 0x000000021f1f7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL, 0x0000001f00677308ULL, 0x000e640000000800ULL,
0x000000671e1e7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe20000011600ULL, 0x00013e827f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x0002a400000e0000ULL, 0x0000001f60607220ULL, 0x084fe20000410000ULL,
0x0000001f61617220ULL, 0x080fe20000410000ULL, 0x0000001f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000001f5d5d7220ULL, 0x080fe20000410000ULL, 0x0000001f58587220ULL, 0x080fe20000410000ULL,
0x0000001f59597220ULL, 0x080fe20000410000ULL, 0x0000001f54547220ULL, 0x080fe20000410000ULL,
0x0000001f55557220ULL, 0x080fe20000410000ULL, 0x0000001f50507220ULL, 0x080fe20000410000ULL,
0x0000001f51517220ULL, 0x080fe20000410000ULL, 0x0000001f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000001f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000001f48487220ULL, 0x080fe20000410000ULL,
0x0000001f49497220ULL, 0x080fe20000410000ULL, 0x0000001f44447220ULL, 0x080fe20000410000ULL,
0x0000001f45457220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x000fe200078ff0ffULL,
0x00013d527f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x00046400000e0000ULL,
0x0000001f62627220ULL, 0x086fe20000410000ULL, 0x0000001f63637220ULL, 0x080fe20000410000ULL,
0x0000001f5e5e7220ULL, 0x080fe20000410000ULL, 0x0000001f5f5f7220ULL, 0x080fe20000410000ULL,
0x0000001f5a5a7220ULL, 0x080fe20000410000ULL, 0x0000001f5b5b7220ULL, 0x080fe20000410000ULL,
0x0000001f56567220ULL, 0x080fe20000410000ULL, 0x0000001f57577220ULL, 0x080fe20000410000ULL,
0x0000001f52527220ULL, 0x080fe20000410000ULL, 0x0000001f53537220ULL, 0x080fe20000410000ULL,
0x0000001f4e4e7220ULL, 0x080fe20000410000ULL, 0x0000001f4f4f7220ULL, 0x080fe20000410000ULL,
0x0000001f4a4a7220ULL, 0x080fe20000410000ULL, 0x0000001f4b4b7220ULL, 0x080fe20000410000ULL,
0x0000001f46467220ULL, 0x080fe20000410000ULL, 0x0000001f47477220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001f7811ULL, 0x000fe200078ff0ffULL, 0x00013c227f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x00046400000e0000ULL, 0x0000001f40407220ULL, 0x086fe20000410000ULL,
0x0000001f41417220ULL, 0x080fe20000410000ULL, 0x0000001f3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001f3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001f38387220ULL, 0x080fe20000410000ULL,
0x0000001f39397220ULL, 0x080fe20000410000ULL, 0x0000001f34347220ULL, 0x080fe20000410000ULL,
0x0000001f35357220ULL, 0x080fe20000410000ULL, 0x0000001f30307220ULL, 0x080fe20000410000ULL,
0x0000001f31317220ULL, 0x080fe20000410000ULL, 0x0000001f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001f28287220ULL, 0x080fe20000410000ULL,
0x0000001f29297220ULL, 0x080fe20000410000ULL, 0x0000001f24247220ULL, 0x080fe20000410000ULL,
0x0000001f25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001f7811ULL, 0x000fe200078ff0ffULL, 0x00013b027f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x00046400000e0000ULL, 0x0000001f42427220ULL, 0x086fe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001f3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001f36367220ULL, 0x080fe20000410000ULL,
0x0000001f37377220ULL, 0x080fe20000410000ULL, 0x0000001f32327220ULL, 0x080fe20000410000ULL,
0x0000001f33337220ULL, 0x080fe20000410000ULL, 0x0000001f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001f26267220ULL, 0x080fe20000410000ULL,
0x0000001f27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001c1dff7212ULL, 0x000fe400078030ffULL, 0x00000002651c7209ULL, 0x000fd60007810000ULL,
0x8000001c65650221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b65650820ULL, 0x000fc80000410000ULL,
0x0000006500070308ULL, 0x000e640000000800ULL, 0x0000000764640220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001e641e7221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000007ff02723eULL, 0x000fe400000010ffULL, 0x00000002ff0b7819ULL, 0x000fe40000011600ULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x000139427f007947ULL, 0x000fea000b800000ULL,
0x00001f0b02087589ULL, 0x0002a400000e0000ULL, 0x000000080b1f7810ULL, 0x000fe20007ffe0ffULL,
0x000139727f007947ULL, 0x000fea000b800000ULL, 0x000000100b1d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1f02097589ULL, 0x00066800000e0000ULL, 0x00001f1d020a7589ULL, 0x0006a400000e0000ULL,
0x000000180b1f7810ULL, 0x008fe20007ffe0ffULL, 0x000139c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f020b7589ULL, 0x0022e400000e0000ULL, 0x000020009a1d7824ULL, 0x040fe200078e00ffULL,
0x0000000a9a027819ULL, 0x002fe200000006ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0xffffc0001d1f7812ULL, 0x000fc400078ec0ffULL,
0xfffff00002027812ULL, 0x000fc600078ec0ffULL, 0x0000200004207824ULL, 0x000fe200078e021fULL,
0x0000b000021f7810ULL, 0x000fc80007ffe0ffULL, 0x0000f00020027810ULL, 0x000fe20007ffe0ffULL,
0x000000100c787824ULL, 0x100fe400078e021fULL, 0x000000100d647824ULL, 0x000fe400078e021fULL,
0x000000100f747824ULL, 0x100fe400078e0202ULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0x000000100e707824ULL, 0x100fe400078e0202ULL, 0x00000010106c7824ULL, 0x000fe200078e0202ULL,
0x000000006464783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000878787231ULL, 0x086fe400003400ffULL, 0x000000087a7a7231ULL, 0x000fc400003400ffULL,
0x0000000979797231ULL, 0x080fe400003400ffULL, 0x000000097b7b7231ULL, 0x000fe400003400ffULL,
0x0000000a64647231ULL, 0x088fe400003400ffULL, 0x0000000a66667231ULL, 0x000fe400003400ffULL,
0x0000000b65657231ULL, 0x080fe400003400ffULL, 0x0000000b67677231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011687824ULL, 0x000fe200078e0202ULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x00000001ff027819ULL, 0x000fe2000001169aULL,
0x0000027000007945ULL, 0x000fe40003800000ULL, 0x000000007070783bULL, 0x000ea40000004200ULL,
0x0000000202207824ULL, 0x000fc400078e0204ULL, 0x000000006c6c783bULL, 0x000e660000004200ULL,
0x0000f00020207811ULL, 0x000fe200078e68ffULL, 0x000000006868783bULL, 0x000e640000004200ULL,
0x000000747860723cULL, 0x04af700000041860ULL, 0x00000076785c723cULL, 0x040f70000004185cULL,
0x000000707858723cULL, 0x044f700000041858ULL, 0x000000727854723cULL, 0x040f700000041854ULL,
0x0000006c7850723cULL, 0x040f700000041850ULL, 0x0000006e784c723cULL, 0x040f70000004184cULL,
0x000000687848723cULL, 0x040f700000041848ULL, 0x0000006a7844723cULL, 0x000b6e0000041844ULL,
0x0000001012787824ULL, 0x120fe200078e021fULL, 0x000000746440723cULL, 0x000b620000041840ULL,
0x00000010131f7824ULL, 0x000fc800078e021fULL, 0x000000007878783bULL, 0x000e640000000200ULL,
0x0000001014747824ULL, 0x120fe200078e0220ULL, 0x00000076643c723cULL, 0x040f70000004183cULL,
0x000000706438723cULL, 0x040b6e0000041838ULL, 0x0000001015707824ULL, 0x120fe200078e0220ULL,
0x000000726434723cULL, 0x040f700000041834ULL, 0x0000006c6430723cULL, 0x040b6e0000041830ULL,
0x00000010166c7824ULL, 0x020fe200078e0220ULL, 0x0000006e642c723cULL, 0x040f70000004182cULL,
0x000000686428723cULL, 0x040f700000041828ULL, 0x0000006a6424723cULL, 0x000b640000041824ULL,
0x000000001f64783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000000878787231ULL, 0x082fe400003400ffULL,
0x000000087a7a7231ULL, 0x000fc400003400ffULL, 0x0000000979797231ULL, 0x080fe400003400ffULL,
0x000000097b7b7231ULL, 0x000fe400003400ffULL, 0x0000000a64647231ULL, 0x088fe400003400ffULL,
0x0000000a66667231ULL, 0x000fe400003400ffULL, 0x0000000b65657231ULL, 0x080fe400003400ffULL,
0x0000000b67677231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000001017687824ULL, 0x000fe200078e0220ULL, 0x000000007474783bULL, 0x000e620000004200ULL,
0x0000590019197a24ULL, 0x010fc400078e02ffULL, 0x00000008951f7824ULL, 0x004fe200078e0202ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000006c6c783bULL, 0x000ee80000004200ULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x000000747860723cULL, 0x042b700000041860ULL,
0x00000076785c723cULL, 0x040b70000004185cULL, 0x000000707858723cULL, 0x044b700000041858ULL,
0x000000727854723cULL, 0x040b700000041854ULL, 0x0000006c7850723cULL, 0x048b700000041850ULL,
0x0000006e784c723cULL, 0x040b70000004184cULL, 0x000000687848723cULL, 0x040b700000041848ULL,
0x0000006a7844723cULL, 0x000b700000041844ULL, 0x000000746440723cULL, 0x040b700000041840ULL,
0x00000076643c723cULL, 0x040b70000004183cULL, 0x000000706438723cULL, 0x040b700000041838ULL,
0x000000726434723cULL, 0x040b700000041834ULL, 0x0000006c6430723cULL, 0x040b700000041830ULL,
0x0000006e642c723cULL, 0x040b70000004182cULL, 0x000000686428723cULL, 0x040b700000041828ULL,
0x0000006a6424723cULL, 0x000b620000041824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000195217810ULL, 0x000fe20007ffe0ffULL, 0x0166900018ff7f8cULL, 0x0003e2000c80043fULL,
0x000000c01f1f7811ULL, 0x000fe200078e28ffULL, 0x00000100ff207424ULL, 0x000fe200078e00ffULL,
0x000000222100720cULL, 0x000fe20003f06070ULL, 0x0000004019197824ULL, 0x000fe200078e00ffULL,
0x000000201f647812ULL, 0x020fc600078ec0ffULL, 0x0000640019207625ULL, 0x000fc800078e0020ULL,
0x0000000103757824ULL, 0x000fe200078e0264ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff727819ULL, 0x102fe20000011600ULL,
0x000000809a657824ULL, 0x000fe200078e00ffULL, 0x0000001f94197217ULL, 0x000fe40007800000ULL,
0x00000008726a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c72707810ULL, 0x000fe20007ffe0ffULL,
0x0000000119197824ULL, 0x000fe200078e0a1fULL, 0x000000036a797819ULL, 0x040fe200000006ffULL,
0x000000016a647824ULL, 0x100fe200078e0200ULL, 0x0000000472667810ULL, 0x000fe20007ffe0ffULL,
0x0000000170677824ULL, 0x040fe200078e0200ULL, 0x0000002019197817ULL, 0x000fe20003800000ULL,
0x00000008706c7824ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fe200078ee264ULL,
0x00000001661f7824ULL, 0x000fe200078e0200ULL, 0x0000008006647812ULL, 0x000fe200078ef865ULL,
0x0000000866687824ULL, 0x000fe200078e00ffULL, 0xfffffff86c7b7812ULL, 0x000fe200078ee267ULL,
0x0000000172677824ULL, 0x140fe200078e0275ULL, 0x0000001072747810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff657224ULL, 0x000fe200078e00ffULL, 0x000000196600720cULL, 0x040fe20003f86070ULL,
0x0000000166697824ULL, 0x000fe200078e0275ULL, 0xfffffff868737812ULL, 0x000fe200078ee21fULL,
0x0000010067667825ULL, 0x000fe200078e0064ULL, 0x0000001472767810ULL, 0x000fc40007ffe0ffULL,
0x000020001d1d7812ULL, 0x000fe200078ec0ffULL, 0x00000001741f7824ULL, 0x000fe200078e0200ULL,
0x00000066206c7210ULL, 0x000fe20007f1e0ffULL, 0x00000008746e7824ULL, 0x000fe200078e00ffULL,
0x000000197000720cULL, 0x080fe20003f46070ULL, 0x0000010069687825ULL, 0x000fe200078e0064ULL,
0x000000196a00720cULL, 0x080fe40003f66070ULL, 0xfffffff86e877812ULL, 0x000fe200078ee21fULL,
0x00000001216d7824ULL, 0x000fe200000e0667ULL, 0x00000068206e7210ULL, 0x000fe20007f3e0ffULL,
0x000000016a677824ULL, 0x000fe200078e0275ULL, 0x000000197200720cULL, 0x000fe20003fa6070ULL,
0x00000001766b7824ULL, 0x000fc400078e0200ULL, 0x00000001216f7824ULL, 0x000fe200008e0669ULL,
0x000000197400720cULL, 0x000fe20003f26070ULL, 0x0000000876787824ULL, 0x000fe400078e00ffULL,
0x0000000170697824ULL, 0x000fe400078e0275ULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0xfffffff878897812ULL, 0x000fe400078ee26bULL, 0x0000001c72787810ULL, 0x000fe20007ffe0ffULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x0000006620707210ULL, 0x000fc60007f1e0ffULL,
0x00004000021f7824ULL, 0x000fe200078e021dULL, 0x0000006820687210ULL, 0x000fe20007fde0ffULL,
0x00000001746b7824ULL, 0x000fe400078e0275ULL, 0x00000001721d7824ULL, 0x000fe200078e0200ULL,
0x0000f0001f747810ULL, 0x000fe20007ffe0ffULL, 0x000001006b6a7825ULL, 0x000fc600078e0064ULL,
0x000000071d1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000121717824ULL, 0x000fe200000e0667ULL,
0x000000197600720cULL, 0x040fe20003f06070ULL, 0x0000000176677824ULL, 0x000fe200078e0275ULL,
0x0ffffff81d1d7812ULL, 0x000fe200078ef800ULL, 0x0000000121697824ULL, 0x000fe200030e0669ULL,
0x0000006a206a7210ULL, 0x000fe20007fde0ffULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0x0000001872767810ULL, 0x000fe40007ffe0ffULL, 0x0000007473777211ULL, 0x000fe200078e20ffULL,
0x00000001216b7824ULL, 0x000fe200030e066bULL, 0x0000006620727210ULL, 0x000fe20007fde0ffULL,
0x000000101d1f7824ULL, 0x000fc400078e0274ULL, 0x00000001761d7824ULL, 0x040fe400078e0275ULL,
0x0000000121737824ULL, 0x000fe200030e0667ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c1f7faeULL, 0x0003e2000e901c46ULL, 0x000001001d667825ULL, 0x000fe200078e0064ULL,
0x000000197600720cULL, 0x080fe40003fa6070ULL, 0x000000006e777faeULL, 0x0005e2000e101c46ULL,
0x000000197800720cULL, 0x040fe20003f86070ULL, 0x0000000178197824ULL, 0x000fe200078e0275ULL,
0x0000006620667210ULL, 0x000fe20007fde0ffULL, 0x00000001761d7824ULL, 0x000fc400078e0200ULL,
0x0000000876767824ULL, 0x000fe400078e00ffULL, 0x00000001781f7824ULL, 0x042fe400078e0200ULL,
0x0000000878787824ULL, 0x000fe200078e00ffULL, 0xfffffff8761d7812ULL, 0x000fe200078ee21dULL,
0x0000010019647825ULL, 0x000fc600078e0064ULL, 0xfffffff8781f7812ULL, 0x000fe200078ee21fULL,
0x0000000121677824ULL, 0x000fe200030e0667ULL, 0x0000006420207210ULL, 0x000fe20007fde0ffULL,
0x0000001079797824ULL, 0x100fe400078e0274ULL, 0x000000107b7b7824ULL, 0x100fe400078e0274ULL,
0x0000001087877824ULL, 0x100fe200078e0274ULL, 0x0000000070797faeULL, 0x0005e2000d901c46ULL,
0x0000001089897824ULL, 0x100fe400078e0274ULL, 0x000000101d1d7824ULL, 0x100fe200078e0274ULL,
0x00000000687b7faeULL, 0x0005e2000d101c46ULL, 0x000000101f1f7824ULL, 0x000fc400078e0274ULL,
0x0000000121217824ULL, 0x000fe200030e0665ULL, 0x000000006a877faeULL, 0x0005e8000c901c46ULL,
0x0000000072897faeULL, 0x0005e8000c101c46ULL, 0x00000000661d7faeULL, 0x0005e8000e901c46ULL,
0x00000000201f7faeULL, 0x0005e2000e101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000400677811ULL, 0x002fe200078fe8ffULL, 0x000000809a737824ULL, 0x000fe200078e00ffULL,
0x0000000800697811ULL, 0x000fc400078fe8ffULL, 0x00000014006f7811ULL, 0x040fe200078fe8ffULL,
0x0000000167197824ULL, 0x140fe200078e0200ULL, 0x0000000c006b7811ULL, 0x040fe200078fe8ffULL,
0x0000000867647824ULL, 0x000fe200078e00ffULL, 0x00000010006d7811ULL, 0x040fe200078fe8ffULL,
0x00000001691f7824ULL, 0x140fe200078e0200ULL, 0x0000001800717811ULL, 0x000fe200078fe8ffULL,
0x0000000869667824ULL, 0x000fe200078e00ffULL, 0xfffffff864777812ULL, 0x000fe200078ee219ULL,
0x000000016f647824ULL, 0x100fe200078e0200ULL, 0x000000036d687819ULL, 0x000fe200000006ffULL,
0x000000086f897824ULL, 0x000fe200078e00ffULL, 0xfffffff866797812ULL, 0x000fe200078ee21fULL,
0x000000016b197824ULL, 0x000fe200078e0200ULL, 0x000020001d1d7812ULL, 0x000fe200078ec0ffULL,
0x000000086b667824ULL, 0x000fe200078e00ffULL, 0xfffffff889897812ULL, 0x000fe200078ee264ULL,
0x000000016d1f7824ULL, 0x100fe200078e0200ULL, 0x0000001c00647811ULL, 0x000fe200078fe8ffULL,
0x0000000171657824ULL, 0x140fe200078e0200ULL, 0xfffffff8667b7812ULL, 0x000fe200078ee219ULL,
0x00000008716a7824ULL, 0x000fe200078e00ffULL, 0x0000000000197211ULL, 0x000fe200078fe8ffULL,
0x0000000164667824ULL, 0x100fe200078e0200ULL, 0x0000008006727812ULL, 0x000fe200078ef873ULL,
0x0000000864737824ULL, 0x000fe200078e00ffULL, 0xfffffff868877812ULL, 0x000fe200078ee21fULL,
0x00004000021f7824ULL, 0x000fe200078e021dULL, 0xfffffff86a8b7812ULL, 0x000fe200078ee265ULL,
0x0000000167677824ULL, 0x100fe200078e0275ULL, 0x00000007191d7812ULL, 0x000fe200078ec0ffULL,
0x0000000169697824ULL, 0x100fe200078e0275ULL, 0x0000007500657211ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x100fe200078e0275ULL, 0x0000f0001f747810ULL, 0x000fe20007ffe0ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0275ULL, 0x0ffffff81d1d7812ULL, 0x000fe200078ef800ULL,
0x000000016f6f7824ULL, 0x100fe200078e0275ULL, 0x000000748b8b7211ULL, 0x000fe200078e20ffULL,
0x0000000171717824ULL, 0x000fc400078e0275ULL, 0x0000000164197824ULL, 0x000fe200078e0275ULL,
0xfffffff873757812ULL, 0x000fe200078ee266ULL, 0x000000ffff737224ULL, 0x000fe400078e00ffULL,
0x000000101d1d7824ULL, 0x000fe400078e0274ULL, 0x0000010065647825ULL, 0x000fc800078e0072ULL,
0x0000010067667825ULL, 0x000fe200078e0072ULL, 0x0000006420647210ULL, 0x000fc60007f1e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0072ULL, 0x0000006620667210ULL, 0x000fc60007f3e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0072ULL, 0x0000006820687210ULL, 0x000fc60007f5e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0072ULL, 0x0000006a206a7210ULL, 0x000fc60007f7e0ffULL,
0x000001006f6e7825ULL, 0x000fc800078e0072ULL, 0x0000010071707825ULL, 0x000fc800078e0072ULL,
0x0000010019727825ULL, 0x000fc800078e0072ULL, 0x0000000121657824ULL, 0x040fe200000e0665ULL,
0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000121677824ULL, 0x040fe200008e0667ULL,
0x0000006e206e7210ULL, 0x040fe20007f3e0ffULL, 0x0000000121697824ULL, 0x000fe200010e0669ULL,
0x0000007020707210ULL, 0x040fe20007f5e0ffULL, 0x0000001077777824ULL, 0x100fe200078e0274ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000641d7faeULL, 0x0003e2000b901c46ULL,
0x00000001216b7824ULL, 0x000fe200018e066bULL, 0x0000007220207210ULL, 0x000fe20007f7e0ffULL,
0x0000001079797824ULL, 0x100fe200078e0274ULL, 0x0000000066777faeULL, 0x0003e2000b901c46ULL,
0x000000107b7b7824ULL, 0x000fc400078e0274ULL, 0x0000001087877824ULL, 0x100fe200078e0274ULL,
0x0000000068797faeULL, 0x0003e2000b901c46ULL, 0x00000001216d7824ULL, 0x000fe400000e066dULL,
0x0000001089897824ULL, 0x100fe200078e0274ULL, 0x000000006a7b7faeULL, 0x0003e2000b901c46ULL,
0x00000001216f7824ULL, 0x040fe400008e066fULL, 0x0000000121717824ULL, 0x000fe200010e0671ULL,
0x000000006c877faeULL, 0x0003e2000b901c46ULL, 0x0000001075757824ULL, 0x000fc400078e0274ULL,
0x0000000121217824ULL, 0x000fe200018e0673ULL, 0x000000006e897faeULL, 0x0003e8000b901c46ULL,
0x00000000708b7faeULL, 0x0003e8000b901c46ULL, 0x0000000020757faeULL, 0x0003e4000b901c46ULL,
0x000000031a197812ULL, 0x000fc800078ec0ffULL, 0x000000031900780cULL, 0x000fc80003f05270ULL,
0x0000000183197807ULL, 0x000fca0004000000ULL, 0x000000011a1a7824ULL, 0x000fe400078e0219ULL,
0xffffffffff197424ULL, 0x000fc600078e00ffULL, 0x000000231a00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000105207824ULL, 0x006fe400078e021aULL,
0x00000004ff217424ULL, 0x000fc800078e00ffULL, 0x0000660020207625ULL, 0x000fca00078e0021ULL,
0x0000000620197981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016648001b667f8cULL, 0x0062a4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0xffffffe07c1b7812ULL, 0x042fe400078ec0ffULL,
0x000000107c647812ULL, 0x040fe400078ec0ffULL, 0x000000087c1d7812ULL, 0x000fc800078ec0ffULL,
0x0000001b1d1b7210ULL, 0x000fca0007ffe064ULL, 0x01664c001b1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x006fe40007804867ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000647805ULL, 0x000fcc0000015200ULL,
0x0000006420647210ULL, 0x000fca0007f1e1ffULL, 0x0000000165657824ULL, 0x000fe200000e0e21ULL,
0x003d09006400780cULL, 0x000fc80003f06070ULL, 0x000000ff6500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406400780cULL, 0x000fc80003f06070ULL,
0x000000ff6500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011465ULL, 0x000000641d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff647224ULL, 0x000fca00000e0665ULL, 0x000000021d1d7819ULL, 0x000fc80000001264ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01664c001b1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209a1d7824ULL, 0x000fca00078e00ffULL,
0xffffff801d1d7812ULL, 0x000fc800078ec0ffULL, 0x00000100061d7810ULL, 0x000fca0007ffe01dULL,
0x00000001801d7824ULL, 0x000fca00078e021dULL, 0x016000001d657984ULL, 0x000e680000000800ULL,
0x016200001d647984ULL, 0x0004e20000000800ULL, 0x0000001c6500720bULL, 0x002fe20003f1d000ULL,
0x000123627f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x004fc800000e0100ULL,
0x000000ff1d00720cULL, 0x000fe20003f25270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x000000027d1f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001c6500720bULL, 0x000fe40003f34000ULL,
0x0000009a1f00720cULL, 0x000fe20003f05270ULL, 0x000123227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000667806ULL, 0x000fc400008e0100ULL, 0x000000809a218824ULL, 0x000fe200078e0206ULL,
0x0000001c651f7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000180208824ULL, 0x000fca00078e0221ULL, 0x0164001f20008388ULL, 0x0003e20000000800ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x8000001f1c1f7221ULL, 0x002fe20000010000ULL, 0x000000ff66ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL,
0x0000001f00677308ULL, 0x000e640000000800ULL, 0x000000671e1e7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x000122627f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x0002a400000e0000ULL,
0x0000001f60607220ULL, 0x084fe20000410000ULL, 0x0000001f61617220ULL, 0x080fe20000410000ULL,
0x0000001f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000001f58587220ULL, 0x080fe20000410000ULL, 0x0000001f59597220ULL, 0x080fe20000410000ULL,
0x0000001f54547220ULL, 0x080fe20000410000ULL, 0x0000001f55557220ULL, 0x080fe20000410000ULL,
0x0000001f50507220ULL, 0x080fe20000410000ULL, 0x0000001f51517220ULL, 0x080fe20000410000ULL,
0x0000001f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001f48487220ULL, 0x080fe20000410000ULL, 0x0000001f49497220ULL, 0x080fe20000410000ULL,
0x0000001f44447220ULL, 0x080fe20000410000ULL, 0x0000001f45457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0066ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001f7811ULL, 0x000fe200078ff0ffULL, 0x000121327f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x00046400000e0000ULL, 0x0000001f62627220ULL, 0x086fe20000410000ULL,
0x0000001f63637220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000066ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000010001f7811ULL, 0x000fe200078ff0ffULL,
0x000120027f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x00046400000e0000ULL,
0x0000001f40407220ULL, 0x086fe20000410000ULL, 0x0000001f41417220ULL, 0x080fe20000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001f38387220ULL, 0x080fe20000410000ULL, 0x0000001f39397220ULL, 0x080fe20000410000ULL,
0x0000001f34347220ULL, 0x080fe20000410000ULL, 0x0000001f35357220ULL, 0x080fe20000410000ULL,
0x0000001f30307220ULL, 0x080fe20000410000ULL, 0x0000001f31317220ULL, 0x080fe20000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001f28287220ULL, 0x080fe20000410000ULL, 0x0000001f29297220ULL, 0x080fe20000410000ULL,
0x0000001f24247220ULL, 0x080fe20000410000ULL, 0x0000001f25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000066ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000018001f7811ULL, 0x000fe200078ff0ffULL,
0x00011ee27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x00046400000e0000ULL,
0x0000001f42427220ULL, 0x086fe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000661dff7212ULL, 0x000fe400078030ffULL,
0x0000001c651c7209ULL, 0x000fd60007810000ULL, 0x8000001c65650221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b65650820ULL, 0x000fc80000410000ULL, 0x0000006500070308ULL, 0x000e640000000800ULL,
0x0000000764640220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001e641e7221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000010ffULL,
0x00000002ff647819ULL, 0x000fe40000011600ULL, 0x00005410080b7816ULL, 0x000fe20000000008ULL,
0x00011d227f007947ULL, 0x000fea000b800000ULL, 0x00001f640b087589ULL, 0x0002a400000e0000ULL,
0x00000008641f7810ULL, 0x000fe20007ffe0ffULL, 0x00011d527f007947ULL, 0x000fea000b800000ULL,
0x00000010640a7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1f0b097589ULL, 0x00066a00000e0000ULL,
0x00001f0a0b0a7589ULL, 0x0006a400000e0000ULL, 0x00000018641f7810ULL, 0x008fe20007ffe0ffULL,
0x00011da27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f0b0b7589ULL, 0x0022e400000e0000ULL,
0x000004009a1d7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000202207824ULL, 0x000fe200078e0204ULL, 0x0000015000007945ULL, 0x000fe40003800000ULL,
0xfffff0001d1f7812ULL, 0x002fe200078ec0ffULL, 0x00002000201d7824ULL, 0x000fc600078e00ffULL,
0x0000c0001f1f7810ULL, 0x000fe40007ffe0ffULL, 0x0000e0001d207810ULL, 0x000fc60007ffe0ffULL,
0x000000100c687824ULL, 0x100fe400078e021fULL, 0x000000100d647824ULL, 0x000fe400078e021fULL,
0x000000100f6c7824ULL, 0x100fe400078e0220ULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x000000100e707824ULL, 0x100fe400078e0220ULL, 0x0000001010747824ULL, 0x000fe200078e0220ULL,
0x000000006464783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000868687231ULL, 0x086fe400003400ffULL, 0x000000086a6a7231ULL, 0x000fc400003400ffULL,
0x0000000969697231ULL, 0x080fe400003400ffULL, 0x000000096b6b7231ULL, 0x000fe400003400ffULL,
0x0000000a64647231ULL, 0x088fe400003400ffULL, 0x0000000a66667231ULL, 0x000fe400003400ffULL,
0x0000000b65657231ULL, 0x080fe400003400ffULL, 0x0000000b67677231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011787824ULL, 0x100fe200078e0220ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x0000024000007945ULL, 0x000fe60003800000ULL,
0x000000007070783bULL, 0x000fe80000004200ULL, 0x000000007878783bULL, 0x000ea80000004200ULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x0000006c6440723cULL, 0x008f700000041840ULL,
0x000000786848723cULL, 0x046f700000041848ULL, 0x0000007a6844723cULL, 0x000f700000041844ULL,
0x000000786428723cULL, 0x040f700000041828ULL, 0x0000006e643c723cULL, 0x040f70000004183cULL,
0x000000706438723cULL, 0x040f700000041838ULL, 0x000000726434723cULL, 0x040f700000041834ULL,
0x000000746430723cULL, 0x040f700000041830ULL, 0x00000076642c723cULL, 0x040f70000004182cULL,
0x0000007a6478723cULL, 0x000b6e0000041824ULL, 0x0000001012647824ULL, 0x020fe200078e021fULL,
0x0000001f131f7211ULL, 0x000fe200078e20ffULL, 0x0000006c6860723cULL, 0x040b680000041860ULL,
0x000000006464783bULL, 0x000e660000000200ULL, 0x00000010156c7824ULL, 0x120fe200078e0220ULL,
0x0000006e685c723cULL, 0x040f62000004185cULL, 0x000000001f24783bULL, 0x0004ee0000000200ULL,
0x000000706858723cULL, 0x040b6e0000041858ULL, 0x0000001016707824ULL, 0x120fe200078e0220ULL,
0x000000726854723cULL, 0x040f700000041854ULL, 0x000000746850723cULL, 0x040f700000041850ULL,
0x00000076684c723cULL, 0x000b6e000004184cULL, 0x0000001014687824ULL, 0x020fe200078e0220ULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000864647231ULL, 0x086fe400003400ffULL,
0x0000000866667231ULL, 0x000fc400003400ffULL, 0x0000000965657231ULL, 0x080fe400003400ffULL,
0x0000000967677231ULL, 0x000fe400003400ffULL, 0x0000000a24247231ULL, 0x088fe400003400ffULL,
0x0000000a26267231ULL, 0x000fe400003400ffULL, 0x0000000b25257231ULL, 0x080fe400003400ffULL,
0x0000000b27277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000001017747824ULL, 0x000fe200078e0220ULL, 0x000000006868783bULL, 0x000e680000004200ULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x000000682440723cULL, 0x04ab700000041840ULL,
0x0000006a243c723cULL, 0x040b70000004183cULL, 0x0000006c2438723cULL, 0x044b700000041838ULL,
0x0000006e2434723cULL, 0x040b700000041834ULL, 0x000000702430723cULL, 0x040b700000041830ULL,
0x00000072242c723cULL, 0x040b70000004182cULL, 0x000000742428723cULL, 0x000b700000041828ULL,
0x000000686460723cULL, 0x040b700000041860ULL, 0x0000006a645c723cULL, 0x040b70000004185cULL,
0x0000006c6458723cULL, 0x040b700000041858ULL, 0x0000006e6454723cULL, 0x040b700000041854ULL,
0x000000706450723cULL, 0x040b700000041850ULL, 0x00000072644c723cULL, 0x040b70000004184cULL,
0x000000746448723cULL, 0x040b700000041848ULL, 0x000000766444723cULL, 0x080b700000041844ULL,
0x000000762424723cULL, 0x000b620000041878ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030095957a10ULL, 0x000fe20007ffe0ffULL, 0x0166980018ff7f8cULL, 0x0003e6000c80043fULL,
0x000000229500720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000d4000000947ULL, 0x000fea0003800000ULL, 0x0000000195217810ULL, 0x042fe20007ffe0ffULL,
0x00000100951f7824ULL, 0x000fe400078e027eULL, 0x0000590019197a24ULL, 0x010fe200078e02ffULL,
0x000000222100720cULL, 0x000fe20003f06070ULL, 0x00000100ff647424ULL, 0x020fe200078e00ffULL,
0x000000201f207812ULL, 0x000fe200078ec0ffULL, 0x0000004019197824ULL, 0x000fc800078e00ffULL,
0x0000000103757824ULL, 0x000fe400078e0220ULL, 0x0000640019207625ULL, 0x000fc800078e0064ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff727819ULL, 0x100fe20000011600ULL,
0x000000809a657824ULL, 0x000fe200078e00ffULL, 0x0000001f94197217ULL, 0x000fe40007800000ULL,
0x00000008726a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000472667810ULL, 0x040fe20007ffe0ffULL,
0x0000000119197824ULL, 0x000fe200078e0a1fULL, 0x0000000c72707810ULL, 0x000fe20007ffe0ffULL,
0x000000016a647824ULL, 0x100fe200078e0200ULL, 0x0000001072747810ULL, 0x000fe20007ffe0ffULL,
0x000000086a7b7824ULL, 0x000fe200078e00ffULL, 0x0000002019197817ULL, 0x000fe20003800000ULL,
0x00000001661f7824ULL, 0x000fe200078e0200ULL, 0x0000001472767810ULL, 0x000fe20007ffe0ffULL,
0x0000000866687824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee264ULL,
0x0000000170677824ULL, 0x000fe200078e0200ULL, 0x0000008006647812ULL, 0x000fe200078ef865ULL,
0x00000008706c7824ULL, 0x000fe200078e00ffULL, 0xfffffff868737812ULL, 0x000fe200078ee21fULL,
0x0000000166697824ULL, 0x040fe200078e0275ULL, 0x000000196600720cULL, 0x080fe20003f86070ULL,
0x000000ffff657224ULL, 0x000fe200078e00ffULL, 0xfffffff86c877812ULL, 0x000fe200078ee267ULL,
0x0000000172677824ULL, 0x000fe200078e0275ULL, 0x00000003767a7819ULL, 0x000fe200000006ffULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x000000197000720cULL, 0x000fc40003f46070ULL,
0x000000196a00720cULL, 0x080fe20003f66070ULL, 0x00000001741f7824ULL, 0x000fe200078e0200ULL,
0x00000068206e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000874787824ULL, 0x000fe200078e00ffULL,
0x000000197200720cULL, 0x000fe20003fa6070ULL, 0x0000010067667825ULL, 0x000fc600078e0064ULL,
0xfffffff878897812ULL, 0x000fe200078ee21fULL, 0x000020009a1f7824ULL, 0x000fe200078e00ffULL,
0x00000066206c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001216f7824ULL, 0x000fe200008e0669ULL,
0x000000197400720cULL, 0x000fe20003f26070ULL, 0x0000000170697824ULL, 0x000fe200078e0275ULL,
0x000020001f717812ULL, 0x000fe200078ec0ffULL, 0x00000001766b7824ULL, 0x100fe200078e0200ULL,
0x0000001c72787810ULL, 0x040fe20007ffe0ffULL, 0x0000000172667824ULL, 0x000fe400078e0200ULL,
0x00000001216d7824ULL, 0x000fe200000e0667ULL, 0xfffffff87a8b7812ULL, 0x000fe200078ee26bULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x00000007661f7812ULL, 0x000fc600078ec0ffULL,
0x000000016a677824ULL, 0x000fe200078e0275ULL, 0x0000006820707210ULL, 0x000fe20007fde0ffULL,
0x0000400002717824ULL, 0x000fe200078e0271ULL, 0x0ffffff81f1f7812ULL, 0x000fe200078ef800ULL,
0x0000010067667825ULL, 0x000fc800078e0064ULL, 0x00000001746b7824ULL, 0x000fe200078e0275ULL,
0x0000e00071747810ULL, 0x000fe20007ffe0ffULL, 0x0000000121717824ULL, 0x000fe200030e0669ULL,
0x0000006620667210ULL, 0x000fe20007f1e0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0064ULL,
0x000000747b7b7211ULL, 0x000fc600078e20ffULL, 0x0000000176697824ULL, 0x000fe200078e0275ULL,
0x0000006a206a7210ULL, 0x000fe20007fde0ffULL, 0x0000000121677824ULL, 0x000fe200000e0667ULL,
0x000000197600720cULL, 0x000fe20003f06070ULL, 0x0000010069687825ULL, 0x000fe200078e0064ULL,
0x0000001872767810ULL, 0x000fc60007ffe0ffULL, 0x00000001216b7824ULL, 0x000fe200030e066bULL,
0x0000006820727210ULL, 0x000fe20007fde0ffULL, 0x000000101f777824ULL, 0x100fe400078e0274ULL,
0x0000001073797824ULL, 0x000fe400078e0274ULL, 0x00000001761f7824ULL, 0x040fe200078e0275ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c777faeULL, 0x0003e2000e901c46ULL,
0x0000000121737824ULL, 0x000fe200030e0669ULL, 0x000000197600720cULL, 0x080fe20003fa6070ULL,
0x000001001f687825ULL, 0x000fe200078e0064ULL, 0x000000006e797faeULL, 0x0005e2000e101c46ULL,
0x000000197800720cULL, 0x000fc40003f86070ULL, 0x0000000178197824ULL, 0x000fe200078e0275ULL,
0x0000006820687210ULL, 0x000fe20007fde0ffULL, 0x00000001761f7824ULL, 0x140fe200078e0200ULL,
0x00000000667b7faeULL, 0x0005e2000d901c46ULL, 0x0000000876767824ULL, 0x000fe400078e00ffULL,
0x00000001786c7824ULL, 0x042fe400078e0200ULL, 0x00000008786d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8761f7812ULL, 0x000fe200078ee21fULL, 0x0000010019647825ULL, 0x000fc600078e0064ULL,
0xfffffff86d197812ULL, 0x000fe200078ee26cULL, 0x0000000121697824ULL, 0x000fe200030e0669ULL,
0x0000006420207210ULL, 0x000fe20007fde0ffULL, 0x0000001087877824ULL, 0x100fe400078e0274ULL,
0x0000001089897824ULL, 0x100fe400078e0274ULL, 0x000000108b8b7824ULL, 0x100fe200078e0274ULL,
0x0000000070877faeULL, 0x0005e2000d101c46ULL, 0x000000101f1f7824ULL, 0x100fe400078e0274ULL,
0x0000001019197824ULL, 0x000fe200078e0274ULL, 0x000000006a897faeULL, 0x0005e2000c901c46ULL,
0x0000000121217824ULL, 0x000fc600030e0665ULL, 0x00000000728b7faeULL, 0x0005e8000c101c46ULL,
0x00000000681f7faeULL, 0x0005e8000e901c46ULL, 0x0000000020197faeULL, 0x0005e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000400677811ULL, 0x000fe200078fe8ffULL,
0x000000809a737824ULL, 0x000fe200078e00ffULL, 0x0000000800697811ULL, 0x000fc400078fe8ffULL,
0x00000014006f7811ULL, 0x040fe200078fe8ffULL, 0x0000000167197824ULL, 0x140fe200078e0200ULL,
0x0000000c006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000867647824ULL, 0x000fe200078e00ffULL,
0x0000001800717811ULL, 0x040fe200078fe8ffULL, 0x00000001691f7824ULL, 0x140fe200078e0200ULL,
0x00000010006d7811ULL, 0x000fe200078fe8ffULL, 0x0000000869667824ULL, 0x000fe200078e00ffULL,
0xfffffff864797812ULL, 0x000fe200078ee219ULL, 0x000000016f647824ULL, 0x140fe200078e0200ULL,
0x0000008006727812ULL, 0x000fe200078ef873ULL, 0x000000086f8b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8667b7812ULL, 0x000fe200078ee21fULL, 0x000000016b197824ULL, 0x000fc400078e0200ULL,
0x000000086b667824ULL, 0x000fe200078e00ffULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee264ULL,
0x0000000171657824ULL, 0x140fe200078e0200ULL, 0x0000001c00647811ULL, 0x000fe200078fe8ffULL,
0x00000008716a7824ULL, 0x000fe200078e00ffULL, 0xfffffff866877812ULL, 0x000fe200078ee219ULL,
0x000020009a197824ULL, 0x000fe200078e00ffULL, 0x000000756b6b7210ULL, 0x080fe20007ffe0ffULL,
0x0000000164667824ULL, 0x100fe200078e0200ULL, 0xfffffff86a8d7812ULL, 0x000fe200078ee265ULL,
0x0000000864737824ULL, 0x000fe200078e00ffULL, 0x0000200019777812ULL, 0x000fe200078ec0ffULL,
0x000000016d1f7824ULL, 0x040fe200078e0200ULL, 0x0000007500657211ULL, 0x000fe200078fe8ffULL,
0x000000086d687824ULL, 0x000fc400078e00ffULL, 0x0000000167677824ULL, 0x100fe400078e0275ULL,
0x0000000169697824ULL, 0x000fe200078e0275ULL, 0xfffffff868897812ULL, 0x000fe200078ee21fULL,
0x000000016d6d7824ULL, 0x100fe200078e0275ULL, 0x00000000001f7211ULL, 0x000fe200078fe8ffULL,
0x000000016f6f7824ULL, 0x100fe400078e0275ULL, 0x0000000171717824ULL, 0x100fe200078e0275ULL,
0x000000071f1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000164197824ULL, 0x000fe200078e0275ULL,
0xfffffff873757812ULL, 0x000fe200078ee266ULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0x0ffffff81f1f7812ULL, 0x000fe200078ef800ULL, 0x0000400002777824ULL, 0x000fc400078e0277ULL,
0x0000010065647825ULL, 0x000fc600078e0072ULL, 0x0000e00077747810ULL, 0x000fe20007ffe0ffULL,
0x0000010067667825ULL, 0x000fe200078e0072ULL, 0x0000006420647210ULL, 0x000fc60007f1e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0072ULL, 0x0000006620667210ULL, 0x000fc60007f3e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0072ULL, 0x0000006820687210ULL, 0x000fc60007f5e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0072ULL, 0x0000006a206a7210ULL, 0x000fc60007f7e0ffULL,
0x000001006f6e7825ULL, 0x000fc800078e0072ULL, 0x0000010071707825ULL, 0x000fc800078e0072ULL,
0x0000010019727825ULL, 0x000fc800078e0072ULL, 0x0000000121657824ULL, 0x040fe200000e0665ULL,
0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000121677824ULL, 0x000fe200008e0667ULL,
0x0000006e206e7210ULL, 0x040fe20007f3e0ffULL, 0x000000101f1f7824ULL, 0x100fe400078e0274ULL,
0x0000000121697824ULL, 0x000fe200010e0669ULL, 0x0000007020707210ULL, 0x040fe20007f5e0ffULL,
0x0000001079797824ULL, 0x100fe200078e0274ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000641f7faeULL, 0x0003e2000b901c46ULL, 0x00000001216b7824ULL, 0x000fe200018e066bULL,
0x0000007220207210ULL, 0x000fe20007f7e0ffULL, 0x000000107b7b7824ULL, 0x100fe200078e0274ULL,
0x0000007121717210ULL, 0x000fe200017fe4ffULL, 0x0000001087877824ULL, 0x100fe200078e0274ULL,
0x0000000066797faeULL, 0x0003e2000b901c46ULL, 0x0000001089897824ULL, 0x000fc400078e0274ULL,
0x00000001216d7824ULL, 0x000fe200000e066dULL, 0x00000000687b7faeULL, 0x0003e2000b901c46ULL,
0x000000108b8b7824ULL, 0x100fe400078e0274ULL, 0x00000001216f7824ULL, 0x000fe200008e066fULL,
0x000000006a877faeULL, 0x0003e2000b901c46ULL, 0x000000108d8d7824ULL, 0x100fe400078e0274ULL,
0x0000001075757824ULL, 0x000fe200078e0274ULL, 0x000000006c897faeULL, 0x0003e2000b901c46ULL,
0x0000000121217824ULL, 0x000fc600018e0673ULL, 0x000000006e8b7faeULL, 0x0003e8000b901c46ULL,
0x00000000708d7faeULL, 0x0003e8000b901c46ULL, 0x0000000020757faeULL, 0x0003e4000b901c46ULL,
0x000000031a197812ULL, 0x004fc800078ec0ffULL, 0x000000031900780cULL, 0x000fc80003f05270ULL,
0x0000000183197807ULL, 0x000fca0004000000ULL, 0x000000011a1a7824ULL, 0x000fe400078e0219ULL,
0xffffffffff197424ULL, 0x000fc600078e00ffULL, 0x000000231a00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000105207824ULL, 0x002fe400078e021aULL,
0x00000004ff217424ULL, 0x000fc800078e00ffULL, 0x0000660020207625ULL, 0x000fca00078e0021ULL,
0x0000000620197981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016668001b667f8cULL, 0x0202a4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0xffffffe07c1b7812ULL, 0x042fe400078ec0ffULL,
0x000000107c647812ULL, 0x040fe400078ec0ffULL, 0x000000087c1f7812ULL, 0x000fc800078ec0ffULL,
0x0000001b1f1f7210ULL, 0x000fca0007ffe064ULL, 0x01666c001f1b7984ULL, 0x000e640000000800ULL,
0x800000001bff7812ULL, 0x006fe40007804867ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000647805ULL, 0x000fcc0000015200ULL,
0x0000006420647210ULL, 0x000fca0007f1e1ffULL, 0x0000000165657824ULL, 0x000fe200000e0e21ULL,
0x003d09006400780cULL, 0x000fc80003f06070ULL, 0x000000ff6500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406400780cULL, 0x000fc80003f06070ULL,
0x000000ff6500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1b7819ULL, 0x000fc80000011465ULL, 0x000000641b1b7211ULL, 0x000fca00078110ffULL,
0x000000ffff647224ULL, 0x000fca00000e0665ULL, 0x000000021b1b7819ULL, 0x000fc80000001264ULL,
0x0000001b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01666c001f1b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209a1b7824ULL, 0x000fca00078e00ffULL,
0xffffff801b1b7812ULL, 0x000fc800078ec0ffULL, 0x00000180061b7810ULL, 0x000fca0007ffe01bULL,
0x00000001801b7824ULL, 0x000fca00078e021bULL, 0x016000001b657984ULL, 0x000e680000000800ULL,
0x016200001b667984ULL, 0x0004e20000000800ULL, 0x0000001c6500720bULL, 0x002fe20003f1d000ULL,
0x000107527f007947ULL, 0x000fd8000b800000ULL, 0x00000000001b7806ULL, 0x004fc800000e0100ULL,
0x000000ff1b00720cULL, 0x000fe20003f25270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff647224ULL, 0x000fd400078e001cULL,
0x0000070000009947ULL, 0x000fea0003800000ULL, 0x000000037d1f7810ULL, 0x000fe40007ffe0ffULL,
0x0000001c6500720bULL, 0x000fe40003f34000ULL, 0x0000009a1f00720cULL, 0x000fe20003f05270ULL,
0x000107027f007947ULL, 0x000fd4000b800000ULL, 0x0000000000687806ULL, 0x000fc400008e0100ULL,
0x000000809a1f8824ULL, 0x000fe200078e0206ULL, 0x0000001c65647209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x00000001801f8824ULL, 0x000fca00078e021fULL,
0x016400641f008388ULL, 0x0003e20000000800ULL, 0x000000ff6800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000001c64067221ULL, 0x002fe20000010100ULL,
0x000000ff68ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL, 0x0000000600677308ULL, 0x000e640000000800ULL,
0x000000671e1e7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe20000011600ULL, 0x000106427f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x0002a400000e0000ULL, 0x0000001f60607220ULL, 0x084fe20000410000ULL,
0x0000001f61617220ULL, 0x080fe20000410000ULL, 0x0000001f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000001f5d5d7220ULL, 0x080fe20000410000ULL, 0x0000001f58587220ULL, 0x080fe20000410000ULL,
0x0000001f59597220ULL, 0x080fe20000410000ULL, 0x0000001f54547220ULL, 0x080fe20000410000ULL,
0x0000001f55557220ULL, 0x080fe20000410000ULL, 0x0000001f50507220ULL, 0x080fe20000410000ULL,
0x0000001f51517220ULL, 0x080fe20000410000ULL, 0x0000001f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000001f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000001f48487220ULL, 0x080fe20000410000ULL,
0x0000001f49497220ULL, 0x080fe20000410000ULL, 0x0000001f44447220ULL, 0x080fe20000410000ULL,
0x0000001f45457220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0068ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x000fe200078ff0ffULL,
0x000105127f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x00046400000e0000ULL,
0x0000001f62627220ULL, 0x086fe20000410000ULL, 0x0000001f63637220ULL, 0x080fe20000410000ULL,
0x0000001f5e5e7220ULL, 0x080fe20000410000ULL, 0x0000001f5f5f7220ULL, 0x080fe20000410000ULL,
0x0000001f5a5a7220ULL, 0x080fe20000410000ULL, 0x0000001f5b5b7220ULL, 0x080fe20000410000ULL,
0x0000001f56567220ULL, 0x080fe20000410000ULL, 0x0000001f57577220ULL, 0x080fe20000410000ULL,
0x0000001f52527220ULL, 0x080fe20000410000ULL, 0x0000001f53537220ULL, 0x080fe20000410000ULL,
0x0000001f4e4e7220ULL, 0x080fe20000410000ULL, 0x0000001f4f4f7220ULL, 0x080fe20000410000ULL,
0x0000001f4a4a7220ULL, 0x080fe20000410000ULL, 0x0000001f4b4b7220ULL, 0x080fe20000410000ULL,
0x0000001f46467220ULL, 0x080fe20000410000ULL, 0x0000001f47477220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000068ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001f7811ULL, 0x000fe200078ff0ffULL, 0x000103e27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x00046400000e0000ULL, 0x0000001f40407220ULL, 0x086fe20000410000ULL,
0x0000001f41417220ULL, 0x080fe20000410000ULL, 0x0000001f3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001f3d3d7220ULL, 0x080fe20000410000ULL, 0x0000001f38387220ULL, 0x080fe20000410000ULL,
0x0000001f39397220ULL, 0x080fe20000410000ULL, 0x0000001f34347220ULL, 0x080fe20000410000ULL,
0x0000001f35357220ULL, 0x080fe20000410000ULL, 0x0000001f30307220ULL, 0x080fe20000410000ULL,
0x0000001f31317220ULL, 0x080fe20000410000ULL, 0x0000001f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001f28287220ULL, 0x080fe20000410000ULL,
0x0000001f29297220ULL, 0x080fe20000410000ULL, 0x0000001f24247220ULL, 0x080fe20000410000ULL,
0x0000001f25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000068ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001f7811ULL, 0x000fe200078ff0ffULL, 0x000102c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x00046400000e0000ULL, 0x0000001f42427220ULL, 0x086fe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001f3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001f3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001f3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001f36367220ULL, 0x080fe20000410000ULL,
0x0000001f37377220ULL, 0x080fe20000410000ULL, 0x0000001f32327220ULL, 0x080fe20000410000ULL,
0x0000001f33337220ULL, 0x080fe20000410000ULL, 0x0000001f2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001f2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001f2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001f2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001f26267220ULL, 0x080fe20000410000ULL,
0x0000001f27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000681bff7212ULL, 0x000fda00078030ffULL, 0x0000006564650221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b65650820ULL, 0x000fc80000410000ULL, 0x0000006500070308ULL, 0x000e640000000800ULL,
0x0000000766660220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001e661e7221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000007ff06723eULL, 0x000fe400000010ffULL,
0x00000002ff0b7819ULL, 0x000fe40000011600ULL, 0x0000541006067816ULL, 0x000fe20000000006ULL,
0x000101127f007947ULL, 0x000fea000b800000ULL, 0x00001f0b06087589ULL, 0x0002a400000e0000ULL,
0x000000080b1f7810ULL, 0x000fe20007ffe0ffULL, 0x000101427f007947ULL, 0x000fea000b800000ULL,
0x000000100b1b7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1f06097589ULL, 0x00066800000e0000ULL,
0x00001f1b060a7589ULL, 0x0006a400000e0000ULL, 0x000000180b1f7810ULL, 0x008fe20007ffe0ffULL,
0x000101927f007947ULL, 0x000fea000b800000ULL, 0x00001f1f060b7589ULL, 0x0022e400000e0000ULL,
0x000004009a067824ULL, 0x002fe200078e00ffULL, 0x0000f0001d1d7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00006067812ULL, 0x000fe200078ec0ffULL, 0x000000100f747824ULL, 0x000fc400078e021dULL,
0x000000100e707824ULL, 0x100fe200078e021dULL, 0x0000d00006067810ULL, 0x000fe20007ffe0ffULL,
0x00000010106c7824ULL, 0x000fc800078e021dULL, 0x000000100c787824ULL, 0x100fe400078e0206ULL,
0x000000100d0d7824ULL, 0x000fc800078e0206ULL, 0x000000007878783bULL, 0x000e680000000200ULL,
0x000000000d0c783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000878787231ULL, 0x086fe400003400ffULL, 0x000000087a7a7231ULL, 0x000fe400003400ffULL,
0x0000000979797231ULL, 0x080fe400003400ffULL, 0x000000097b7b7231ULL, 0x000fc400003400ffULL,
0x0000000a0c0c7231ULL, 0x088fe400003400ffULL, 0x0000000a0e0e7231ULL, 0x000fe400003400ffULL,
0x0000000b0d0d7231ULL, 0x080fe400003400ffULL, 0x0000000b0f0f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011687824ULL, 0x100fe200078e021dULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x0000001012127824ULL, 0x100fe200078e0206ULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x0000001013067824ULL, 0x000fe200078e0206ULL,
0x000000007070783bULL, 0x000fe20000004200ULL, 0x0000001016167824ULL, 0x000fc600078e021dULL,
0x000000006c6c783bULL, 0x000fe80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x000000740c40723cULL, 0x048f700000041840ULL, 0x000000760c3c723cULL, 0x000f70000004183cULL,
0x000000687848723cULL, 0x046f700000041848ULL, 0x0000006a7844723cULL, 0x000f700000041844ULL,
0x000000700c38723cULL, 0x040f700000041838ULL, 0x000000720c34723cULL, 0x040f700000041834ULL,
0x0000006c0c30723cULL, 0x040f700000041830ULL, 0x0000006e0c2c723cULL, 0x040f70000004182cULL,
0x000000680c28723cULL, 0x040f700000041828ULL, 0x0000006a0c24723cULL, 0x000b640000041824ULL,
0x000000001268783bULL, 0x0202a80000000200ULL, 0x00000000060c783bULL, 0x0002e40000000200ULL,
0x000000747860723cULL, 0x040f700000041860ULL, 0x00000076785c723cULL, 0x040f70000004185cULL,
0x000000707858723cULL, 0x040b6e0000041858ULL, 0x0000001015707824ULL, 0x120fe200078e021dULL,
0x000000727854723cULL, 0x040f700000041854ULL, 0x0000006c7850723cULL, 0x040b6e0000041850ULL,
0x00000010146c7824ULL, 0x020fe200078e021dULL, 0x0000006e784c723cULL, 0x000b62000004184cULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x0000000868687231ULL, 0x08efe400003400ffULL, 0x000000086a6a7231ULL, 0x000fc400003400ffULL,
0x0000000969697231ULL, 0x080fe400003400ffULL, 0x000000096b6b7231ULL, 0x000fe400003400ffULL,
0x0000000a0c0c7231ULL, 0x080fe400003400ffULL, 0x0000000a0e0e7231ULL, 0x000fe400003400ffULL,
0x0000000b0d0d7231ULL, 0x080fe400003400ffULL, 0x0000000b0f0f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x00efea0003800000ULL, 0x0000001017107824ULL, 0x000fe200078e021dULL,
0x000000006c6c783bULL, 0x020e680000004200ULL, 0x000000007070783bULL, 0x000ea80000004200ULL,
0x000000001614783bULL, 0x000ee80000004200ULL, 0x000000001010783bULL, 0x000ea20000004200ULL,
0x0000006c6860723cULL, 0x042b700000041860ULL, 0x0000006e685c723cULL, 0x040b70000004185cULL,
0x000000706858723cULL, 0x044b700000041858ULL, 0x000000726854723cULL, 0x040b700000041854ULL,
0x000000146850723cULL, 0x048b700000041850ULL, 0x00000016684c723cULL, 0x040b70000004184cULL,
0x000000106848723cULL, 0x040b700000041848ULL, 0x000000126844723cULL, 0x000b700000041844ULL,
0x0000006c0c40723cULL, 0x040b700000041840ULL, 0x0000006e0c3c723cULL, 0x040b70000004183cULL,
0x000000700c38723cULL, 0x040b700000041838ULL, 0x000000720c34723cULL, 0x040b700000041834ULL,
0x000000140c30723cULL, 0x040b700000041830ULL, 0x000000160c2c723cULL, 0x040b70000004182cULL,
0x000000100c28723cULL, 0x040b700000041828ULL, 0x000000120c24723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000229500720cULL, 0x000fe20003f06070ULL,
0x0166a00018ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff806000007947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x002e640000002500ULL,
0x000000220700720cULL, 0x002fda0003f06070ULL, 0x0000058000000947ULL, 0x000fea0003800000ULL,
0x018000001e007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e001eULL,
0x0000a16000087802ULL, 0x000fc40000000f00ULL, 0x0000fe3000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001e00037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc8000000001eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011605ULL, 0x00000018050d7811ULL, 0x060fe400078ff0ffULL,
0x0000000805097811ULL, 0x040fe400078ff0ffULL, 0x00000010050b7811ULL, 0x000fe200078ff0ffULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0d00087589ULL, 0x000ee800000e0000ULL,
0x00001f0900057589ULL, 0x000e6800000e0000ULL, 0x00001f0b00067589ULL, 0x002e6200000e0000ULL,
0x0000006003607220ULL, 0x044fe20000410000ULL, 0x0000006103617220ULL, 0x040fe20000410000ULL,
0x0000005c035c7220ULL, 0x040fe20000410000ULL, 0x0000005d035d7220ULL, 0x040fe20000410000ULL,
0x0000005803587220ULL, 0x040fe20000410000ULL, 0x0000005903597220ULL, 0x040fe20000410000ULL,
0x0000005403547220ULL, 0x040fe20000410000ULL, 0x0000005503557220ULL, 0x040fe20000410000ULL,
0x0000005003507220ULL, 0x040fe20000410000ULL, 0x0000005103517220ULL, 0x040fe20000410000ULL,
0x0000004c034c7220ULL, 0x040fe20000410000ULL, 0x0000004d034d7220ULL, 0x040fe20000410000ULL,
0x0000004803487220ULL, 0x040fe20000410000ULL, 0x0000004903497220ULL, 0x040fe20000410000ULL,
0x0000004403447220ULL, 0x040fe20000410000ULL, 0x0000004503457220ULL, 0x000fe20000410000ULL,
0x0000004208427220ULL, 0x048fe20000410000ULL, 0x0000004308437220ULL, 0x040fe20000410000ULL,
0x0000003e083e7220ULL, 0x040fe20000410000ULL, 0x0000003f083f7220ULL, 0x040fe20000410000ULL,
0x0000003a083a7220ULL, 0x040fe20000410000ULL, 0x0000003b083b7220ULL, 0x040fe20000410000ULL,
0x0000003608367220ULL, 0x040fe20000410000ULL, 0x0000003708377220ULL, 0x040fe20000410000ULL,
0x0000003208327220ULL, 0x040fe20000410000ULL, 0x0000003308337220ULL, 0x040fe20000410000ULL,
0x0000002e082e7220ULL, 0x040fe20000410000ULL, 0x0000002f082f7220ULL, 0x040fe20000410000ULL,
0x0000002a082a7220ULL, 0x040fe20000410000ULL, 0x0000002b082b7220ULL, 0x040fe20000410000ULL,
0x0000002608267220ULL, 0x040fe20000410000ULL, 0x0000002708277220ULL, 0x000fe20000410000ULL,
0x0000000562627220ULL, 0x080fe20000410000ULL, 0x0000000563637220ULL, 0x080fe20000410000ULL,
0x000000055e5e7220ULL, 0x080fe20000410000ULL, 0x000000055f5f7220ULL, 0x080fe20000410000ULL,
0x000000055a5a7220ULL, 0x080fe20000410000ULL, 0x000000055b5b7220ULL, 0x080fe20000410000ULL,
0x0000000556567220ULL, 0x080fe20000410000ULL, 0x0000000557577220ULL, 0x080fe20000410000ULL,
0x0000000552527220ULL, 0x080fe20000410000ULL, 0x0000000553537220ULL, 0x080fe20000410000ULL,
0x000000054e4e7220ULL, 0x080fe20000410000ULL, 0x000000054f4f7220ULL, 0x080fe20000410000ULL,
0x000000054a4a7220ULL, 0x080fe20000410000ULL, 0x000000054b4b7220ULL, 0x080fe20000410000ULL,
0x0000000546467220ULL, 0x080fe20000410000ULL, 0x0000000547477220ULL, 0x000fe20000410000ULL,
0x0000000640407220ULL, 0x082fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x000000063c3c7220ULL, 0x080fe20000410000ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000630307220ULL, 0x080fe20000410000ULL, 0x0000000631317220ULL, 0x080fe20000410000ULL,
0x000000062c2c7220ULL, 0x080fe20000410000ULL, 0x000000062d2d7220ULL, 0x080fe20000410000ULL,
0x0000000628287220ULL, 0x080fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000000040573c2ULL, 0x000ea200000e0000ULL,
0x000000262715723eULL, 0x020fc400000010ffULL, 0x000000242524723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fe400000010ffULL,
0x000000606105723eULL, 0x000fe400000010ffULL, 0x0000005c5d06723eULL, 0x000fc400000010ffULL,
0x000000585908723eULL, 0x000fe400000010ffULL, 0x000000545509723eULL, 0x000fe400000010ffULL,
0x00000050510a723eULL, 0x000fe400000010ffULL, 0x0000002a2b14723eULL, 0x000fe400000010ffULL,
0x00000002ff1a7819ULL, 0x002fe20000011603ULL, 0x0000000d05057899ULL, 0x004fe2000800063fULL,
0x0000000803277811ULL, 0x000fc400078ff0ffULL, 0x000000021a167810ULL, 0x040fe20007ffe0ffULL,
0x000000081a1b7824ULL, 0x040fe200078e00ffULL, 0x000000011a007810ULL, 0x040fe20007ffe0ffULL,
0x000000081a197824ULL, 0x050fe200078e00ffULL, 0x000000031a1d7819ULL, 0x040fe200000006ffULL,
0x000000081a1f7824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL,
0x000000081a1c7824ULL, 0x040fe200078e00ffULL, 0x000000041a167810ULL, 0x040fe20007ffe0ffULL,
0x000000081a257824ULL, 0x040fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee200ULL,
0x000000081a237824ULL, 0x040fe200078e00ffULL, 0x000000031a007810ULL, 0x000fc40007ffe0ffULL,
0x000000051a177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL,
0x0000000827167824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee200ULL,
0xfffffff81c217812ULL, 0x000fe200078ee217ULL, 0x000000081a177824ULL, 0x040fe200078e00ffULL,
0xffffffff1a007810ULL, 0x040fe20007ffe0ffULL, 0x00000300ff1c7624ULL, 0x000fe200078e00ffULL,
0x000000061a187810ULL, 0x000fc40007ffe0ffULL, 0x0000001003297811ULL, 0x040fe400078ff0ffULL,
0xfffffff816277812ULL, 0x000fe200078ee227ULL, 0x0000000403167824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe400078ee200ULL, 0xfffffff817177812ULL, 0x000fe400078ee21aULL,
0x0000000502007c11ULL, 0x000fe4000f8e60ffULL, 0xfffffff823237812ULL, 0x000fe200078ee218ULL,
0x0000000829187824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x0000004c4d0b723eULL, 0x000fe200000010ffULL,
0x0000001019197824ULL, 0x100fe200078e0200ULL, 0xfffffff818297812ULL, 0x000fe200078ee229ULL,
0x000000101b1b7824ULL, 0x100fe200078e0200ULL, 0x00000018032b7811ULL, 0x000fe200078ff0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x00000048490c723eULL, 0x000fe200000010ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0x0000001b161b7210ULL, 0x040fe20007ffe0ffULL,
0x0000000117187824ULL, 0x000fe200078e0216ULL, 0x00000044450d723eULL, 0x000fe200000010ffULL,
0x0000001021217824ULL, 0x100fe200078e0200ULL, 0x000000626362723eULL, 0x000fe200000010ffULL,
0x0000000116197824ULL, 0x040fe200078e0219ULL, 0x0000000518007388ULL, 0x0003e20000000800ULL,
0x0000001023237824ULL, 0x100fe200078e0200ULL, 0x0000005e5f5e723eULL, 0x000fe200000010ffULL,
0x0000001025257824ULL, 0x100fe200078e0200ULL, 0x0000000619007388ULL, 0x000fe20000000800ULL,
0x00000001161d7824ULL, 0x040fe200078e021dULL, 0x0000005a5b5a723eULL, 0x000fe200000010ffULL,
0x0000001027277824ULL, 0x100fe200078e0200ULL, 0x000000081b007388ULL, 0x000fe20000000800ULL,
0x00000001161f7824ULL, 0x040fe200078e021fULL, 0x000000565756723eULL, 0x000fe200000010ffULL,
0x0000000116217824ULL, 0x040fe200078e0221ULL, 0x000000091d007388ULL, 0x000fe20000000800ULL,
0x0000000116237824ULL, 0x040fe200078e0223ULL, 0x000000525352723eULL, 0x000fe200000010ffULL,
0x0000000116257824ULL, 0x040fe200078e0225ULL, 0x0000000a1f007388ULL, 0x000fe20000000800ULL,
0x0000000116277824ULL, 0x040fe200078e0227ULL, 0x0000004e4f4e723eULL, 0x000fe200000010ffULL,
0x000000082b1a7824ULL, 0x000fe200078e00ffULL, 0x0000000b21007388ULL, 0x0005e20000000800ULL,
0x0000001029297824ULL, 0x100fe200078e0200ULL, 0x0000004a4b4a723eULL, 0x000fe200000010ffULL,
0x000000ff00057306ULL, 0x002fe20000205400ULL, 0x0000000c23007388ULL, 0x000fe20000000800ULL,
0x000000464746723eULL, 0x000fe200000010ffULL, 0x0000000116297824ULL, 0x000fe200078e0229ULL,
0xfffffff81a2b7812ULL, 0x000fe200078ee22bULL, 0x0000000d25007388ULL, 0x000fe20000000800ULL,
0x000000404140723eULL, 0x000fe200000010ffULL, 0x000000017e0b7824ULL, 0x004fe200078e0203ULL,
0x0000003c3d3c723eULL, 0x000fe200000010ffULL, 0x0000006227007388ULL, 0x000fe20000000800ULL,
0x000000383938723eULL, 0x000fe200000010ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0200ULL,
0x000000343534723eULL, 0x000fe200000010ffULL, 0x0004005e19007388ULL, 0x000fe20000000800ULL,
0x000000303130723eULL, 0x000fe200000010ffULL, 0x00000001162b7824ULL, 0x000fe200078e022bULL,
0x0000002c2d2c723eULL, 0x000fe200000010ffULL, 0x0004005a1b007388ULL, 0x000fe20000000800ULL,
0x00000042430e723eULL, 0x000fe200000010ffULL, 0x000000ff00067306ULL, 0x000e620000209400ULL,
0x0000003e3f0f723eULL, 0x000fe200000010ffULL, 0x000400561d007388ULL, 0x000fe20000000800ULL,
0x0000003a3b10723eULL, 0x000fc400000010ffULL, 0x000000363711723eULL, 0x000fe200000010ffULL,
0x000400521f007388ULL, 0x000fe20000000800ULL, 0x000000323312723eULL, 0x000fe400000010ffULL,
0x0000002e2f13723eULL, 0x000fe200000010ffULL, 0x0004004e21007388ULL, 0x000fe80000000800ULL,
0x0004004a23007388ULL, 0x000fe20000000800ULL, 0x000000050600720bULL, 0x002fc60003f1d000ULL,
0x0004004625007388ULL, 0x000fe20000000800ULL, 0x000000ff00057245ULL, 0x000fc6000020d400ULL,
0x0000004029007388ULL, 0x000fe80000000800ULL, 0x0008003c19007388ULL, 0x000fe40000000800ULL,
0x0000000105050812ULL, 0x000fe400078efcffULL, 0x000800381b007388ULL, 0x000fe20000000800ULL,
0x000000011c00780cULL, 0x000fe40003f05270ULL, 0x000000050508723eULL, 0x000fe200000010ffULL,
0x000800341d007388ULL, 0x000fe80000000800ULL, 0x000800301f007388ULL, 0x000fe80000000800ULL,
0x0008002c21007388ULL, 0x000fe80000000800ULL, 0x0008002823007388ULL, 0x000fe80000000800ULL,
0x0008002425007388ULL, 0x000fe80000000800ULL, 0x0000000e2b007388ULL, 0x000fe80000000800ULL,
0x000c000f19007388ULL, 0x000fe80000000800ULL, 0x000c00101b007388ULL, 0x000fe80000000800ULL,
0x000c00111d007388ULL, 0x000fe80000000800ULL, 0x000c00121f007388ULL, 0x000fe80000000800ULL,
0x000c001321007388ULL, 0x000fe80000000800ULL, 0x000c001423007388ULL, 0x000fe80000000800ULL,
0x000c001525007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000050b287984ULL, 0x000e68000800cc00ULL, 0x000400050b187984ULL, 0x000ea8000800cc00ULL,
0x000800050b107984ULL, 0x000ee8000800cc00ULL, 0x000c00050b307984ULL, 0x000ee8000800cc00ULL,
0x001000050b0c7984ULL, 0x000ee8000800cc00ULL, 0x001400050b2c7984ULL, 0x000ee8000800cc00ULL,
0x001800050b207984ULL, 0x000ee8000800cc00ULL, 0x001c00050b147984ULL, 0x000ee2000800cc00ULL,
0x3f803f80082b7831ULL, 0x002fc4000020002bULL, 0x3f803f80082a7831ULL, 0x040fe4000020002aULL,
0x3f803f8008297831ULL, 0x040fe40000200029ULL, 0x3f803f8008287831ULL, 0x040fe40000200028ULL,
0x3f803f80081b7831ULL, 0x044fe4000020001bULL, 0x3f803f80081a7831ULL, 0x040fe4000020001aULL,
0x3f803f8008197831ULL, 0x000fc40000200019ULL, 0x3f803f8008187831ULL, 0x040fe40000200018ULL,
0x3f803f8008137831ULL, 0x048fe40000200013ULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x3f803f8008107831ULL, 0x040fe40000200010ULL,
0x3f803f8008337831ULL, 0x000fc40000200033ULL, 0x3f803f8008327831ULL, 0x040fe40000200032ULL,
0x3f803f8008317831ULL, 0x040fe40000200031ULL, 0x3f803f8008307831ULL, 0x000fe40000200030ULL,
0x3f803f802b2b7831ULL, 0x000fe4000020000fULL, 0x3f803f802a2a7831ULL, 0x000fe4000020000eULL,
0x3f803f8029297831ULL, 0x000fc4000020000dULL, 0x3f803f8028287831ULL, 0x000fe4000020000cULL,
0x3f803f801b1b7831ULL, 0x000fe4000020002fULL, 0x3f803f801a1a7831ULL, 0x000fe2000020002eULL,
0x000000280b007988ULL, 0x000fe2000800cc05ULL, 0x3f803f8019197831ULL, 0x000fe4000020002dULL,
0x3f803f8018187831ULL, 0x000fe4000020002cULL, 0x3f803f8013137831ULL, 0x000fc40000200023ULL,
0x3f803f8012127831ULL, 0x000fe20000200022ULL, 0x000400180b007988ULL, 0x000fe2000800cc05ULL,
0x3f803f8011117831ULL, 0x000fe40000200021ULL, 0x3f803f8010107831ULL, 0x000fe40000200020ULL,
0x3f803f8033337831ULL, 0x000fe40000200017ULL, 0x3f803f8032327831ULL, 0x000fe20000200016ULL,
0x000800100b007988ULL, 0x000fe2000800cc05ULL, 0x3f803f8031317831ULL, 0x000fc40000200015ULL,
0x3f803f8030307831ULL, 0x000fca0000200014ULL, 0x000c00300b007988ULL, 0x000fe8000800cc05ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000395000008947ULL, 0x000fea0003800000ULL,
0x00000400ff067624ULL, 0x000fe200078e00ffULL, 0x0000000000097919ULL, 0x000e620000002600ULL,
0x000000400b0d7810ULL, 0x000fc40007ffe0ffULL, 0x00006c0006067a24ULL, 0x000fe200078e02ffULL,
0x00000000000a7919ULL, 0x000e620000002700ULL, 0x000000800b0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000c00b117810ULL, 0x000fe20007ffe0ffULL, 0x000000050b187984ULL, 0x000ea2000800cc00ULL,
0x0000000f06087811ULL, 0x040fe200078e10ffULL, 0x0000030006067a24ULL, 0x000fe400078e02ffULL,
0x000400050b207984ULL, 0x000ee2000800cc00ULL, 0xfffffff0084d7812ULL, 0x000fc600078ec0ffULL,
0x000800050b247984ULL, 0x000ea4000800cc00ULL, 0x00000080061f7824ULL, 0x040fe400078e024dULL,
0x000c00050b287984ULL, 0x0008a4000800cc00ULL, 0x0000008006067824ULL, 0x000fca00078e021fULL,
0x0000007f06067810ULL, 0x000fe20007ffe0ffULL, 0x000004000a097a24ULL, 0x002fc600078e0209ULL,
0xffffff8006147812ULL, 0x000fe200078ec0ffULL, 0x0000030009087a24ULL, 0x000fc800078e02ffULL,
0x0000000108107824ULL, 0x000fe200078e0207ULL, 0x0000700014077a10ULL, 0x000fc80007f1e0ffULL,
0x0000000710067211ULL, 0x000fe200078268ffULL, 0x00007100ff077624ULL, 0x000fe200000e06ffULL,
0x0000000102ff7812ULL, 0x000fc8000780f89aULL, 0x0000000710077211ULL, 0x000fe400008f6cffULL,
0x000070004d157a10ULL, 0x000fc60007f3e0ffULL, 0x0000100004067825ULL, 0x000fc800078e0006ULL,
0x00007100ff167624ULL, 0x000fe400008e06ffULL, 0x000000100b0a7825ULL, 0x010fc800078e0006ULL,
0x000000100d0c7825ULL, 0x000fc800078e0006ULL, 0x000000100f0e7825ULL, 0x000fc800078e0006ULL,
0x0000001011067825ULL, 0x000fe200078e0006ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001003117824ULL, 0x00cfe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011603ULL,
0x0000008010127824ULL, 0x000fc600078e00ffULL, 0x00000070112c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c13177812ULL, 0x000fe400078ec0ffULL, 0x0000700012137a10ULL, 0x000fe40007ebe01fULL,
0x00000019ff117819ULL, 0x000fe40000011610ULL, 0x000000152c107210ULL, 0x000fe40007a3e012ULL,
0x0000001317127210ULL, 0x000fc40007c7e02cULL, 0x0000710011137a10ULL, 0x000fe40002fec4ffULL,
0x0000001017107210ULL, 0x000fe40007fbe0ffULL, 0x00000016ff117210ULL, 0x000fe40000fe4411ULL,
0x00000013ff137210ULL, 0x000fc60001fe84ffULL, 0x000000ffff117224ULL, 0x000fca00028e0611ULL,
0x0000006410007986ULL, 0x0003e8000c101906ULL, 0x0000001e12007986ULL, 0x0003e4000c101906ULL,
0x000000ff0300720cULL, 0x00cfe20000705670ULL, 0x000000180a007986ULL, 0x000fe2000c101d06ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000200c007986ULL, 0x000fe8000c101d06ULL,
0x000000240e007986ULL, 0x000fe8000c101d06ULL, 0x0000002806007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0xffffffff1c0b7810ULL, 0x000fc60007ffe0ffULL,
0x0000700009067625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000b060679a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0600720cULL, 0x004fc80003f05270ULL,
0x00000001ff097807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff067984ULL, 0x000ee40000000000ULL,
0x000000ff0600720cULL, 0x008fda0003f05270ULL, 0x0000345000008947ULL, 0x000fea0003800000ULL,
0x000000ff9a00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe40000011603ULL,
0x0000001508067211ULL, 0x000fe400078038ffULL, 0x0000007007097812ULL, 0x004fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000001608077211ULL, 0x000fe400000f3cffULL,
0x000000060a067210ULL, 0x000fc8000791e009ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x00000006060a7981ULL, 0x000528000c1e1900ULL, 0x00008006060b7981ULL, 0x000522000c1e1900ULL,
0x000000021c00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006060d7981ULL, 0x004522000c1e1900ULL, 0x000000041c00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018006060f7981ULL, 0x004522000c1e1900ULL,
0x000000041c00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000606117981ULL, 0x006322000c1e1900ULL, 0x000000061c00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800606137981ULL, 0x002322000c1e1900ULL,
0x000000061c00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081c00780cULL, 0x002fe20003f06070ULL, 0x0003000606157981ULL, 0x000318000c1e1900ULL,
0x0003800606170981ULL, 0x000324000c1e1900ULL, 0x000000071c067810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff097819ULL, 0x000fc80000011606ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000004d081b7211ULL, 0x040fe200078038ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000000a00197202ULL, 0x010fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000070001b1b7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff080c7211ULL, 0x000fe400000f3cffULL, 0x000007801b1b7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0c7a10ULL, 0x000fc400017e240cULL, 0x000003000e007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000409007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080e067810ULL, 0x040fe40007ffe0ffULL,
0x000000010e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffc800606197981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090e067810ULL, 0x042fe40007ffe0ffULL,
0x000000020e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000b0a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffd0006060b7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000030e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffd8006060d7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000040e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffe0006060f7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000050e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000110a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffe800606117981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000060e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000130a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xffff000606137981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000070e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000150a0a7209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xffff800606157981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e067810ULL, 0x002fe40007ffe0ffULL,
0x000000170a0a7209ULL, 0x000fe40007810000ULL, 0x0000030006007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0x0000000606177981ULL, 0x000326000c1e1900ULL,
0x000004001b1b7810ULL, 0x000fe40007f3e0ffULL, 0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e060cULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003067824ULL, 0x006fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fca00078ec0ffULL, 0x0000000106077824ULL, 0x000fca00078e0207ULL,
0x0000000a07007388ULL, 0x0103e40000000800ULL, 0x0000700014067a10ULL, 0x000fe20007f3e0ffULL,
0x0000000102217824ULL, 0x000fe200078e0208ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x0000100004097824ULL, 0x004fe200078e00ffULL, 0x000000017d0d7812ULL, 0x040fe200078ec0ffULL,
0x00007100ff077624ULL, 0x002fe200008e06ffULL, 0x00000001ff507819ULL, 0x000fe20000011603ULL,
0x000010007d7d7824ULL, 0x000fe200078e00ffULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x00002000210a7825ULL, 0x000fe200078e0006ULL, 0x0000004003137810ULL, 0x040fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000090a0c7210ULL, 0x000fe20007f3e0ffULL,
0x00000002020e8824ULL, 0x040fe200078e0204ULL, 0x0000000402228211ULL, 0x040fe200078e08ffULL,
0x0000001003517824ULL, 0x000fe200078e00ffULL, 0x00000005020a7c11ULL, 0x000fe2000f8e70ffULL,
0x000000020e248824ULL, 0x100fe200078e020dULL, 0x000010007d7d7812ULL, 0x000fe200078ec0ffULL,
0x0000000222228824ULL, 0x000fe200078e020dULL, 0x0000006003157810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x0000008003177810ULL, 0x040fe20007ffe0ffULL,
0x000000010a0e7824ULL, 0x000fe200078e027dULL, 0x000000a003197810ULL, 0x000fe20007ffe0ffULL,
0x0000001011107825ULL, 0x000fe200078e000cULL, 0x000000c0031b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000e0031d7810ULL, 0x040fe20007ffe0ffULL,
0x0000001003237824ULL, 0x000fe200078e020eULL, 0x0000007051517812ULL, 0x000fe200078ec0ffULL,
0x0000001013127825ULL, 0x100fe200078e000cULL, 0x0000000c50507812ULL, 0x000fe200078ec0ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x000070004d4d7a10ULL, 0x000fe20007f5e0ffULL,
0x0000001015147825ULL, 0x100fe200078e000cULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000001017167825ULL, 0x100fe200078e000cULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000001019187825ULL, 0x100fe200078e000cULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000101b1a7825ULL, 0x100fe200078e000cULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000cULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000010030e7825ULL, 0x000fe200078e000cULL, 0x000070001f0c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00000001510b7824ULL, 0x000fc400078e0250ULL, 0x00007100ff4e7624ULL, 0x000fe200008e06ffULL,
0x0000000c211e8211ULL, 0x040fe200078238ffULL, 0x00007100ff4f7624ULL, 0x000fe200010e06ffULL,
0x0000004d21208211ULL, 0x040fe200078438ffULL, 0x000000000b0b7984ULL, 0x000e620000000800ULL,
0x0000004e211f8211ULL, 0x040fe200008f3cffULL, 0x0000000824248824ULL, 0x000fe200078e0203ULL,
0x0000030002007a0cULL, 0x000fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e237faeULL, 0x0005e2000b901c46ULL, 0x0000004f21218211ULL, 0x000fe200010f3cffULL,
0x000000ffff0d7224ULL, 0x000fc400078e00ffULL, 0x0038000010237faeULL, 0x0007e2000b901c46ULL,
0x000000ffff4c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x0058000012237faeULL, 0x0009e2000b901c46ULL, 0x00000008220f8824ULL, 0x004fc600078e0203ULL,
0x0078000014237faeULL, 0x0005e2000b901c46ULL, 0x0000000000107805ULL, 0x008fc6000001ff00ULL,
0x0098000016237faeULL, 0x0007e2000b901c46ULL, 0x000085800f0f8811ULL, 0x000fe200078e20ffULL,
0x0000001003128825ULL, 0x050fe400078e001eULL, 0x00b8000018237faeULL, 0x0009e2000b901c46ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000001003148825ULL, 0x004fe400078e0020ULL,
0x00d800001a237faeULL, 0x0005e2000b901c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000818024178811ULL, 0x008fc400078e20ffULL, 0x00f800001c237faeULL, 0x0007e2000b901c46ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x010fe4000001ff00ULL,
0x00000000120f8faeULL, 0x0009e8000b901c46ULL, 0x0000000014178faeULL, 0x0003e2000b901c46ULL,
0x00000000001a7805ULL, 0x004fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001c7805ULL, 0x008fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000130000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff667224ULL, 0x000fca00078e0002ULL, 0x0000000266537810ULL, 0x000fc80007ffe0ffULL,
0x0000030053007a0cULL, 0x000fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x040fe20003f44070ULL, 0x0000000108657824ULL, 0x100fe200078e0253ULL,
0x00000001ff547819ULL, 0x000fe40000011653ULL, 0x0000002003577810ULL, 0x000fe20007ffe0ffULL,
0x0000200065507825ULL, 0x000fe200078e0006ULL, 0x0000000154557812ULL, 0x000fe400078ec0ffULL,
0x0000004003597810ULL, 0x000fe20007ffe0ffULL, 0x0000080053547824ULL, 0x000fe200078e00ffULL,
0x0000000950507210ULL, 0x000fc40007f1e0ffULL, 0x00000060035b7810ULL, 0x040fe20007ffe0ffULL,
0x000000020268a824ULL, 0x140fe200078e0204ULL, 0x00000080035d7810ULL, 0x040fe20007ffe0ffULL,
0x000000020256a824ULL, 0x000fe200078e0204ULL, 0x000000a0035f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff517224ULL, 0x000fe200000e0651ULL, 0x000000556868a211ULL, 0x000fe200078e08ffULL,
0x00000002566aa824ULL, 0x000fe200078e0255ULL, 0x0000100054557812ULL, 0x000fe200078ec0ffULL,
0x0000001057567825ULL, 0x000fe200078e0050ULL, 0x000000c003617810ULL, 0x000fc40007ffe0ffULL,
0x000000e003637810ULL, 0x000fe20007ffe0ffULL, 0x000000010a547824ULL, 0x000fe200078e0255ULL,
0x0000000c6562a211ULL, 0x000fe200078038ffULL, 0x0000001059587825ULL, 0x000fe200078e0050ULL,
0x0000004d6564a211ULL, 0x000fc600078238ffULL, 0x0000001003677824ULL, 0x040fe400078e0254ULL,
0x0000001003547825ULL, 0x000fc800078e0050ULL, 0x000000105b5a7825ULL, 0x100fe200078e0050ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000054677faeULL, 0x0003e6000b901c46ULL,
0x000000105d5c7825ULL, 0x100fe200078e0050ULL, 0x0038000056677faeULL, 0x0005e6000b901c46ULL,
0x000000105f5e7825ULL, 0x100fe200078e0050ULL, 0x0058000058677faeULL, 0x0007e6000b901c46ULL,
0x0000001061607825ULL, 0x100fe200078e0050ULL, 0x007800005a677faeULL, 0x0007e6000b901c46ULL,
0x0000001063507825ULL, 0x000fe200078e0050ULL, 0x0000004e6563a211ULL, 0x040fe200000f3cffULL,
0x009800005c677faeULL, 0x0007e2000b901c46ULL, 0x0000004f6565a211ULL, 0x000fe200008f3cffULL,
0x000000086868a824ULL, 0x000fc400078e0203ULL, 0x000000086a6aa824ULL, 0x000fe200078e0203ULL,
0x00b800005e677faeULL, 0x0007e2000b901c46ULL, 0x000000100362a825ULL, 0x040fe200078e0062ULL,
0x000085806869a811ULL, 0x000fe400078e20ffULL, 0x000081806a57a811ULL, 0x004fe200078e20ffULL,
0x000000100354a825ULL, 0x002fe200078e0064ULL, 0x00d8000060677faeULL, 0x0007e8000b901c46ULL,
0x00f8000050677faeULL, 0x0007e8000b901c46ULL, 0x000000006269afaeULL, 0x0007e8000b901c46ULL,
0x000000005457afaeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004066507824ULL, 0x008fe200078e00ffULL, 0x00000001ff567819ULL, 0x100fe20000011603ULL,
0x0000000202557824ULL, 0x000fe200078e0204ULL, 0x00000002ff607819ULL, 0x000fe20000011603ULL,
0x0000001003517824ULL, 0x000fe200078e00ffULL, 0x0000008050507812ULL, 0x000fc400078ec0ffULL,
0x0000000260577810ULL, 0x040fe20007ffe0ffULL, 0x0000000860627824ULL, 0x000fe200078e00ffULL,
0x0000007051517812ULL, 0x000fe200078ec0ffULL, 0x0000010055547824ULL, 0x000fe200078e0050ULL,
0x0000000c56507812ULL, 0x000fe200078ec0ffULL, 0x0000000860597824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ee257ULL, 0x0000000403577824ULL, 0x000fe200078e00ffULL,
0x0000005450557210ULL, 0x000fe20007ffe051ULL, 0x00000008605b7824ULL, 0x040fe200078e00ffULL,
0x0000000160547810ULL, 0x040fe20007ffe0ffULL, 0x00000008606c7824ULL, 0x040fe200078e00ffULL,
0x0000000c576b7812ULL, 0x000fe200078ec0ffULL, 0x0000000860577824ULL, 0x000fe200078e00ffULL,
0xfffffff8595e7812ULL, 0x000fe200078ee254ULL, 0x0000080066547824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0081800055567984ULL, 0x000e620000000800ULL,
0x00000008606e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000860667824ULL, 0x040fe200078e00ffULL,
0x0000001060707810ULL, 0x040fe20007ffe0ffULL, 0x00858000555c7984ULL, 0x0004e20000000800ULL,
0x0000001860727810ULL, 0x000fe20007ffe0ffULL, 0x000000086e597824ULL, 0x000fe200078e00ffULL,
0x0000000360587810ULL, 0x000fe20007ffe0ffULL, 0x00000008705f7824ULL, 0x000fe200078e00ffULL,
0x00000005605d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000872617824ULL, 0x000fe200078e00ffULL,
0xfffffff85b647812ULL, 0x000fe200078ee258ULL, 0x00000008606a7824ULL, 0x000fe200078e00ffULL,
0x0000100054557812ULL, 0x004fc400078ec0ffULL, 0xfffffff857547812ULL, 0x000fe400078ee260ULL,
0x000001800a557810ULL, 0x000fe40007ffe055ULL, 0xfffffff85f587812ULL, 0x000fe400078ee270ULL,
0xfffffff8615a7812ULL, 0x000fe200078ee272ULL, 0x0000001054547824ULL, 0x100fe200078e0255ULL,
0x00000004605b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001058587824ULL, 0x000fe200078e0255ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee25dULL, 0x000000016b547824ULL, 0x040fe200078e0254ULL,
0xfffffff866667812ULL, 0x000fe200078ee25bULL, 0x000000016b587824ULL, 0x040fe200078e0258ULL,
0x00000006605b7810ULL, 0x000fe20007ffe0ffULL, 0x000000105a5a7824ULL, 0x000fe200078e0255ULL,
0x0000000054617984ULL, 0x0005240000000800ULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee25bULL,
0x000000016b5a7824ULL, 0x000fe200078e025aULL, 0x0000000058687984ULL, 0x0007e80000000800ULL,
0x000000005a697984ULL, 0x0007e20000000800ULL, 0x000000560b577221ULL, 0x002fe20000010100ULL,
0xfffffff859567812ULL, 0x000fe200078ee26eULL, 0x0000001062547824ULL, 0x004fc400078e0255ULL,
0x3fb8aa3b57597820ULL, 0x000fe20000410000ULL, 0x0000005556567211ULL, 0x000fe200078e20ffULL,
0x000000016b547824ULL, 0x040fe400078e0254ULL, 0x0000001066587824ULL, 0x108fe400078e0255ULL,
0x0000005900597308ULL, 0x000e620000000800ULL, 0x000000016b577824ULL, 0x040fe200078e0256ULL,
0x0000000054637984ULL, 0x000fe20000000800ULL, 0x000000105e567824ULL, 0x100fe400078e0255ULL,
0x000000106c5a7824ULL, 0x000fe200078e0255ULL, 0x0000000057677984ULL, 0x0005e20000000800ULL,
0x000000016b567824ULL, 0x000fc400078e0256ULL, 0x000000016b587824ULL, 0x040fe400078e0258ULL,
0x000000016b5a7824ULL, 0x000fe200078e025aULL, 0x0000000056627984ULL, 0x000fe20000000800ULL,
0x0000001064577824ULL, 0x004fe200078e0255ULL, 0x0000005c595b7220ULL, 0x002fe20000410000ULL,
0x00000008605c7824ULL, 0x040fe200078e00ffULL, 0xffffffff60597810ULL, 0x000fe20007ffe0ffULL,
0x000000016b577824ULL, 0x000fe200078e0257ULL, 0x0000000058657984ULL, 0x000fe20000000800ULL,
0x000000525b527221ULL, 0x000fe20000010000ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee259ULL,
0x000000106a597824ULL, 0x100fe200078e0255ULL, 0x00001f605b5d7589ULL, 0x000e6600000e0000ULL,
0x000000105c557824ULL, 0x000fe200078e0255ULL, 0x00001f6e5b5e7589ULL, 0x000ea200000e0000ULL,
0x00007610ff5c7816ULL, 0x010fe20000000061ULL, 0x000000016b597824ULL, 0x000fc400078e0259ULL,
0x00001f705b5f7589ULL, 0x000ee200000e0000ULL, 0x000000016b557824ULL, 0x000fc600078e0255ULL,
0x0000000057647984ULL, 0x000fe80000000800ULL, 0x00001f725b607589ULL, 0x0008e800000e0000ULL,
0x0000000059667984ULL, 0x000ee20000000800ULL, 0x0000005d5c4b7223ULL, 0x002fe2000001004bULL,
0x00007610ff5c7816ULL, 0x000fc40000000067ULL, 0x00005410ff5b7816ULL, 0x010fe40000000061ULL,
0x000000005a617984ULL, 0x000e620000000800ULL, 0x0000005e5c417223ULL, 0x084fe20000010041ULL,
0x00005410ff5c7816ULL, 0x000fe20000000068ULL, 0x0000005d5b4c7223ULL, 0x000fe2000001004cULL,
0x00005410ff5b7816ULL, 0x000fe40000000067ULL, 0x0000000055677984ULL, 0x000ea20000000800ULL,
0x0000005f5c217223ULL, 0x088fe20000010021ULL, 0x00007610ff5c7816ULL, 0x000fe20000000068ULL,
0x0000005e5b167223ULL, 0x000fe20000010016ULL, 0x00005410ff5b7816ULL, 0x000fe20000000062ULL,
0x0004000056687984ULL, 0x000ee40000000800ULL, 0x0000005f5c397223ULL, 0x000fe20000010039ULL,
0x00005410ff5c7816ULL, 0x000fe20000000069ULL, 0x0000005d5b4a7223ULL, 0x000fe2000001004aULL,
0x00005410ff5b7816ULL, 0x000fc60000000063ULL, 0x000000605c1f7223ULL, 0x080fe2000001001fULL,
0x00007610ff5c7816ULL, 0x000fe20000000069ULL, 0x0000005d5b487223ULL, 0x080fe20000010048ULL,
0x0004000054697984ULL, 0x000fe20000000800ULL, 0x00005410ff5b7816ULL, 0x000fe40000000064ULL,
0x000000605c317223ULL, 0x000fe20000010031ULL, 0x00007610ff5c7816ULL, 0x000fe40000000062ULL,
0x0004000057627984ULL, 0x000f220000000800ULL, 0x0000005d5b467223ULL, 0x080fe20000010046ULL,
0x00005410ff5b7816ULL, 0x000fe20000000065ULL, 0x0000005d5c497223ULL, 0x000fe20000010049ULL,
0x00007610ff5c7816ULL, 0x000fc40000000063ULL, 0x0004000058637984ULL, 0x000f220000000800ULL,
0x0000005d5b447223ULL, 0x080fe20000010044ULL, 0x00007610ff5b7816ULL, 0x000fe20000000066ULL,
0x0000005d5c477223ULL, 0x080fe20000010047ULL, 0x00007610ff5c7816ULL, 0x000fe40000000064ULL,
0x0004000059647984ULL, 0x000fe20000000800ULL, 0x0000005d5b187223ULL, 0x080fe20000010018ULL,
0x00005410ff5b7816ULL, 0x002fe20000000061ULL, 0x0000005d5c457223ULL, 0x000fe20000010045ULL,
0x00007610ff5c7816ULL, 0x000fc40000000065ULL, 0x000400005a657984ULL, 0x000e620000000800ULL,
0x0000005d5b2a7223ULL, 0x080fe2000001002aULL, 0x00007610ff5b7816ULL, 0x004fe20000000067ULL,
0x0000005d5c0f7223ULL, 0x080fe2000001000fULL, 0x00005410ff5c7816ULL, 0x000fe40000000066ULL,
0x0004000055667984ULL, 0x000fe20000000800ULL, 0x0000005d5b427223ULL, 0x080fe20000010042ULL,
0x00005410ff5b7816ULL, 0x008fe20000000068ULL, 0x0000005d5c2b7223ULL, 0x000fe2000001002bULL,
0x00007610ff5c7816ULL, 0x000fc40000000061ULL, 0x0008000059617984ULL, 0x000fe20000000800ULL,
0x0000005e5b287223ULL, 0x080fe20000010028ULL, 0x00007610ff5b7816ULL, 0x000fe20000000068ULL,
0x0000005d5c437223ULL, 0x080fe20000010043ULL, 0x00005410ff5c7816ULL, 0x000fe20000000067ULL,
0x000c000054687984ULL, 0x000fe40000000800ULL, 0x0000005e5b407223ULL, 0x000fe40000010040ULL,
0x000c000056677984ULL, 0x000ea20000000800ULL, 0x0000005d5c297223ULL, 0x000fe20000010029ULL,
0x00005410ff5b7816ULL, 0x010fc40000000062ULL, 0x00080000565c7984ULL, 0x0007e60000000800ULL,
0x0000005e5b267223ULL, 0x080fe20000010026ULL, 0x00080000545d7984ULL, 0x0008a20000000800ULL,
0x00007610ff5b7816ULL, 0x000fe40000000062ULL, 0x00005410ff567816ULL, 0x008fe20000000069ULL,
0x000c000057627984ULL, 0x000fe40000000800ULL, 0x0000005e5b3e7223ULL, 0x080fe2000001003eULL,
0x00005410ff547816ULL, 0x010fe20000000063ULL, 0x0000005e56277223ULL, 0x080fe20000010027ULL,
0x00007610ff567816ULL, 0x000fe20000000069ULL, 0x00080000585b7984ULL, 0x000fe40000000800ULL,
0x0000005e54257223ULL, 0x080fe20000010025ULL, 0x00007610ff547816ULL, 0x000fe20000000063ULL,
0x0000005e563f7223ULL, 0x080fe2000001003fULL, 0x000c000058637984ULL, 0x000fe60000000800ULL,
0x0000005e543d7223ULL, 0x000fe2000001003dULL, 0x0008000057567984ULL, 0x0007220000000800ULL,
0x00005410ff547816ULL, 0x002fc60000000065ULL, 0x000800005a587984ULL, 0x000fe40000000800ULL,
0x0000005e54237223ULL, 0x000fe20000010023ULL, 0x00007610ff547816ULL, 0x000fe40000000065ULL,
0x00005410ff577816ULL, 0x008fc60000000064ULL, 0x0000005e543b7223ULL, 0x080fe2000001003bULL,
0x00005410ff547816ULL, 0x004fe20000000067ULL, 0x0000005e57247223ULL, 0x000fe20000010024ULL,
0x00007610ff577816ULL, 0x000fc60000000064ULL, 0x0000006054177223ULL, 0x000fe40000010017ULL,
0x0000005e573c7223ULL, 0x000fe2000001003cULL, 0x00005410ff577816ULL, 0x000fe40000000066ULL,
0x00007610ff547816ULL, 0x000fc6000000005dULL, 0x0000005e57227223ULL, 0x080fe20000010022ULL,
0x00007610ff577816ULL, 0x000fe20000000066ULL, 0x0000005f54377223ULL, 0x000fe20000010037ULL,
0x00005410ff547816ULL, 0x000fe40000000068ULL, 0x0000005300667202ULL, 0x000fe20000000f00ULL,
0x0000005e573a7223ULL, 0x000fe2000001003aULL, 0x00005410ff577816ULL, 0x000fe2000000005cULL,
0x000c0000595e7984ULL, 0x000e620000000800ULL, 0x0000006054157223ULL, 0x000fe20000010015ULL,
0x00007610ff547816ULL, 0x000fc40000000068ULL, 0x0000005f57207223ULL, 0x080fe20000010020ULL,
0x00007610ff577816ULL, 0x000fe2000000005cULL, 0x000c000055597984ULL, 0x000fe20000000800ULL,
0x00000060542f7223ULL, 0x000fe2000001002fULL, 0x00005410ff547816ULL, 0x010fe40000000056ULL,
0x0000005f57387223ULL, 0x080fe20000010038ULL, 0x00007610ff577816ULL, 0x000fe20000000067ULL,
0x000c00005a5c7984ULL, 0x000ea20000000800ULL, 0x0000005f541d7223ULL, 0x000fe2000001001dULL,
0x00007610ff547816ULL, 0x000fc4000000005bULL, 0x0000006057307223ULL, 0x080fe20000010030ULL,
0x00005410ff577816ULL, 0x000fe4000000005dULL, 0x0000005f54357223ULL, 0x080fe20000010035ULL,
0x00005410ff547816ULL, 0x000fe40000000063ULL, 0x0000005f571e7223ULL, 0x000fe2000001001eULL,
0x0000030066007a0cULL, 0x000fe20003f06070ULL, 0x0008000055577984ULL, 0x0007220000000800ULL,
0x0000006054137223ULL, 0x000fe20000010013ULL, 0x00007610ff547816ULL, 0x000fca0000000063ULL,
0x00000060542d7223ULL, 0x000fe2000001002dULL, 0x00007610ff557816ULL, 0x008fe40000000056ULL,
0x00005410ff547816ULL, 0x000fc60000000061ULL, 0x0000005f55367223ULL, 0x080fe20000010036ULL,
0x00005410ff557816ULL, 0x000fe20000000062ULL, 0x0000005f541b7223ULL, 0x000fe2000001001bULL,
0x00007610ff547816ULL, 0x002fc6000000005eULL, 0x0000006055147223ULL, 0x080fe20000010014ULL,
0x00007610ff557816ULL, 0x000fe20000000062ULL, 0x0000006054117223ULL, 0x000fe20000010011ULL,
0x00007610ff547816ULL, 0x000fc60000000058ULL, 0x00000060552e7223ULL, 0x000fe2000001002eULL,
0x00005410ff557816ULL, 0x000fe2000000005bULL, 0x0000005f54337223ULL, 0x000fe20000010033ULL,
0x00007610ff537816ULL, 0x004fc6000000005cULL, 0x0000005f551c7223ULL, 0x000fe2000001001cULL,
0x00007610ff557816ULL, 0x000fe20000000061ULL, 0x00000060532c7223ULL, 0x000fc8000001002cULL,
0x0000005f55347223ULL, 0x080fe20000010034ULL, 0x00005410ff557816ULL, 0x000fe4000000005eULL,
0x00005410ff547816ULL, 0x110fe40000000057ULL, 0x00007610ff537816ULL, 0x000fe20000000057ULL,
0x0000006055127223ULL, 0x080fe20000010012ULL, 0x00005410ff557816ULL, 0x000fe20000000058ULL,
0x0000005f54197223ULL, 0x080fe20000010019ULL, 0x00007610ff547816ULL, 0x100fe20000000059ULL,
0x0000005f53327223ULL, 0x080fe20000010032ULL, 0x00005410ff537816ULL, 0x000fe20000000059ULL,
0x0000005f551a7223ULL, 0x000fe2000001001aULL, 0x00005410ff557816ULL, 0x000fe2000000005cULL,
0x00000060540d7223ULL, 0x000fc4000001000dULL, 0x0000006053107223ULL, 0x080fe40000010010ULL,
0x00000060550e7223ULL, 0x000fe2000001000eULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffed2000007947ULL, 0x000fea000383ffffULL, 0x000000ff0400720cULL, 0x000fe20003f05270ULL,
0x0000017000007945ULL, 0x000fd80003800000ULL, 0x0000008002038824ULL, 0x000fc800078e0251ULL,
0x0000000150038824ULL, 0x000fe400078e0203ULL, 0x0000000151507824ULL, 0x000fc600078e0250ULL,
0x0089805203008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0089800050067984ULL, 0x000e680000000800ULL, 0x008a000050077984ULL, 0x000ea20000000800ULL,
0x00000006ff067221ULL, 0x002fc80000010000ULL, 0x0000000706067221ULL, 0x004fca0000010000ULL,
0x0180000006077810ULL, 0x000fc80007ffe0ffULL, 0x7f80000007077812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0700780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000dbd000087802ULL, 0x000fc40000000f00ULL,
0x0000c3c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000600077308ULL, 0x000e640000001000ULL,
0xbf80000006037423ULL, 0x002fc80000000007ULL, 0x800000ff03087221ULL, 0x000fc80000010100ULL,
0x0000000807077223ULL, 0x000fc40000000007ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000050505723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff4e7819ULL, 0x104fe20000011603ULL,
0x000000017e7e7824ULL, 0x000fe200078e0203ULL, 0x0000000803507811ULL, 0x040fe400078ff0ffULL,
0x0000001803547811ULL, 0x040fe200078ff0ffULL, 0x00001f4e07067589ULL, 0x002e6200000e0000ULL,
0x0000001003527811ULL, 0x000fe200078ff0ffULL, 0x000000084e4f7824ULL, 0x000fc400078e00ffULL,
0x00001f5007097589ULL, 0x000ea200000e0000ULL, 0x000000084e557824ULL, 0x040fe400078e00ffULL,
0x000000084e567824ULL, 0x040fe200078e00ffULL, 0x00001f52074d7589ULL, 0x000ee200000e0000ULL,
0x000000084e537824ULL, 0x000fe400078e00ffULL, 0x0000000852597824ULL, 0x000fe400078e00ffULL,
0x00000008545b7824ULL, 0x000fe400078e00ffULL, 0x0000000850577824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fc400078ee252ULL, 0xfffffff85b5b7812ULL, 0x000fe400078ee254ULL,
0xfffffff857577812ULL, 0x000fe200078ee250ULL, 0x0000001059597824ULL, 0x100fe400078e0200ULL,
0x000000105b5b7824ULL, 0x000fe200078e0200ULL, 0x0000004c064c7220ULL, 0x042fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000004a064a7220ULL, 0x040fe20000410000ULL,
0x0000004906497220ULL, 0x040fe20000410000ULL, 0x0000004806487220ULL, 0x040fe20000410000ULL,
0x0000004706477220ULL, 0x040fe20000410000ULL, 0x0000004606467220ULL, 0x040fe20000410000ULL,
0x0000004506457220ULL, 0x040fe20000410000ULL, 0x0000004406447220ULL, 0x040fe20000410000ULL,
0x0000000f060f7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000001806187220ULL, 0x040fe20000410000ULL, 0x0000002a062a7220ULL, 0x040fe20000410000ULL,
0x0000004306437220ULL, 0x040fe20000410000ULL, 0x0000002906297220ULL, 0x040fe20000410000ULL,
0x0000004206067220ULL, 0x000fe20000410000ULL, 0x0000003f09087220ULL, 0x044fe20000410000ULL,
0x00001f5407427589ULL, 0x0002a200000e0000ULL, 0x0000001609167220ULL, 0x040fe20000410000ULL,
0x0000004109417220ULL, 0x040fe20000410000ULL, 0x0000002809287220ULL, 0x040fe20000410000ULL,
0x00000040090b7220ULL, 0x040fe20000410000ULL, 0x0000002709277220ULL, 0x040fe20000410000ULL,
0x0000002609267220ULL, 0x040fe20000410000ULL, 0x0000003e093f7220ULL, 0x040fe20000410000ULL,
0x0000002509257220ULL, 0x040fe20000410000ULL, 0x0000003d090a7220ULL, 0x040fe20000410000ULL,
0x0000002409247220ULL, 0x040fe20000410000ULL, 0x0000003c09077220ULL, 0x042fe20000410000ULL,
0x0000002309237220ULL, 0x040fe20000410000ULL, 0x0000003b090c7220ULL, 0x040fe20000410000ULL,
0x0000002209227220ULL, 0x040fe20000410000ULL, 0x0000003a09097220ULL, 0x000fe20000410000ULL,
0x000000394d3a7220ULL, 0x048fe20000410000ULL, 0x000000214d217220ULL, 0x040fe20000410000ULL,
0x000000204d207220ULL, 0x040fe20000410000ULL, 0x000000384d397220ULL, 0x040fe20000410000ULL,
0x0000001e4d1e7220ULL, 0x040fe20000410000ULL, 0x000000374d377220ULL, 0x040fe20000410000ULL,
0x0000001d4d1d7220ULL, 0x040fe20000410000ULL, 0x000000364d367220ULL, 0x040fe20000410000ULL,
0x0000002f423c7220ULL, 0x044fe20000410000ULL, 0x0000002e422f7220ULL, 0x040fe20000410000ULL,
0x0000001c4d1c7220ULL, 0x040fe20000410000ULL, 0x000000354d357220ULL, 0x040fe20000410000ULL,
0x0000001b4d1b7220ULL, 0x040fe20000410000ULL, 0x000000344d347220ULL, 0x040fe20000410000ULL,
0x0000001a4d1a7220ULL, 0x040fe20000410000ULL, 0x000000334d337220ULL, 0x040fe20000410000ULL,
0x000000194d197220ULL, 0x040fe20000410000ULL, 0x000000324d327220ULL, 0x000fe20000410000ULL,
0x0000002d422e7220ULL, 0x000fe20000410000ULL, 0x000000084e4d7824ULL, 0x000fe200078e00ffULL,
0x0000002c422d7220ULL, 0x000fe20000410000ULL, 0x000000084e407824ULL, 0x040fe200078e00ffULL,
0x000000034e3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000003142387220ULL, 0x000fe20000410000ULL,
0x000000044e2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001042107220ULL, 0x000fe20000410000ULL,
0x000000054e317810ULL, 0x000fe20007ffe0ffULL, 0x0000000d420d7220ULL, 0x000fe20000410000ULL,
0x000000014e3b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001242127220ULL, 0x000fe20000410000ULL,
0x000000024e3d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001142117220ULL, 0x040fe20000410000ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee23eULL, 0x0000001f421f7220ULL, 0x040fe20000410000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee22cULL, 0x0000001742177220ULL, 0x000fe20000410000ULL,
0x000000220909723eULL, 0x000fe200000010ffULL, 0x0000000403227824ULL, 0x000fe200078e00ffULL,
0x000000064e3e7810ULL, 0x000fe20007ffe0ffULL, 0x000000104d4d7824ULL, 0x100fe200078e0200ULL,
0xfffffff840517812ULL, 0x000fe200078ee231ULL, 0x000000104f4f7824ULL, 0x000fe200078e0200ULL,
0xffffffff4e2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000003042307220ULL, 0x000fe20000410000ULL,
0xfffffff855317812ULL, 0x000fe200078ee24eULL, 0x0000001051517824ULL, 0x100fe200078e0200ULL,
0xfffffff8403b7812ULL, 0x000fe200078ee23bULL, 0x0000001542157220ULL, 0x000fe20000410000ULL,
0xfffffff8563d7812ULL, 0x000fe200078ee23dULL, 0x0000001031317824ULL, 0x000fe200078e0200ULL,
0xfffffff853537812ULL, 0x000fe200078ee23eULL, 0x000000103b3b7824ULL, 0x000fe200078e0200ULL,
0xfffffff855557812ULL, 0x000fe200078ee22cULL, 0x000000103d3d7824ULL, 0x100fe200078e0200ULL,
0x0000000c22227812ULL, 0x000fe200078ec0ffULL, 0x0000001053537824ULL, 0x100fe200078e0200ULL,
0x0000000057577211ULL, 0x000fe200078e20ffULL, 0x0000001055557824ULL, 0x000fe200078e0200ULL,
0x0000004c4b4b723eULL, 0x000fe200000010ffULL, 0x0000000131007824ULL, 0x000fe200078e0222ULL,
0x000000100d0d723eULL, 0x000fe200000010ffULL, 0x0000000122107824ULL, 0x040fe200078e023bULL,
0x0000004a4949723eULL, 0x000fe200000010ffULL, 0x00000001223d7824ULL, 0x040fe200078e023dULL,
0x000000484747723eULL, 0x000fe200000010ffULL, 0x00000001224d7824ULL, 0x040fe200078e024dULL,
0x000000464545723eULL, 0x000fe200000010ffULL, 0x00000001224f7824ULL, 0x040fe200078e024fULL,
0x000000440f0f723eULL, 0x000fe200000010ffULL, 0x0000004b00007388ULL, 0x000fe20000000800ULL,
0x000000121111723eULL, 0x000fe200000010ffULL, 0x0000000122127824ULL, 0x000fe200078e0251ULL,
0x0000002b1818723eULL, 0x000fe200000010ffULL, 0x0000000122537824ULL, 0x000fe200078e0253ULL,
0x0000002a432a723eULL, 0x000fe200000010ffULL, 0x0000004910007388ULL, 0x000fe20000000800ULL,
0x000000290606723eULL, 0x000fe200000010ffULL, 0x00000001222c7824ULL, 0x040fe200078e0255ULL,
0x000000164116723eULL, 0x000fe200000010ffULL, 0x000000473d007388ULL, 0x000fe20000000800ULL,
0x0000000122577824ULL, 0x000fe200078e0257ULL, 0x000000280b0b723eULL, 0x000fe200000010ffULL,
0x0000001442147220ULL, 0x000fe20000410000ULL, 0x000000454d007388ULL, 0x000fe20000000800ULL,
0x000000270808723eULL, 0x000fe200000010ffULL, 0x0000001342137220ULL, 0x000fe20000410000ULL,
0x000000263f26723eULL, 0x000fe200000010ffULL, 0x0000000f4f007388ULL, 0x000fe20000000800ULL,
0x000000250a0a723eULL, 0x000fe200000010ffULL, 0x0000000e420e7220ULL, 0x000fe20000410000ULL,
0x000000240707723eULL, 0x000fe200000010ffULL, 0x0000001812007388ULL, 0x000fe20000000800ULL,
0x000000230c0c723eULL, 0x000fe200000010ffULL, 0x0000000122247824ULL, 0x000fe200078e0259ULL,
0x000000213a21723eULL, 0x000fe200000010ffULL, 0x0000002a53007388ULL, 0x000fe20000000800ULL,
0x000000203920723eULL, 0x000fe200000010ffULL, 0x0000000122227824ULL, 0x000fe200078e025bULL,
0x0000001e371e723eULL, 0x000fe200000010ffULL, 0x000000062c007388ULL, 0x000fe20000000800ULL,
0x0000001d361d723eULL, 0x000fc400000010ffULL, 0x0000001c351c723eULL, 0x000fe200000010ffULL,
0x0000001657007388ULL, 0x000fe20000000800ULL, 0x0000001b341b723eULL, 0x000fe400000010ffULL,
0x0000001a331a723eULL, 0x000fe200000010ffULL, 0x0004000b10007388ULL, 0x000fe20000000800ULL,
0x000000193219723eULL, 0x000fe400000010ffULL, 0x0000001f381f723eULL, 0x000fe200000010ffULL,
0x000400083d007388ULL, 0x000fe20000000800ULL, 0x000000173017723eULL, 0x000fc400000010ffULL,
0x000000153c15723eULL, 0x000fe200000010ffULL, 0x000400264d007388ULL, 0x000fe20000000800ULL,
0x000000142f14723eULL, 0x000fe400000010ffULL, 0x000000132e13723eULL, 0x000fe200000010ffULL,
0x0004000a4f007388ULL, 0x000fe20000000800ULL, 0x0000000e2d0e723eULL, 0x000fc600000010ffULL,
0x0004000712007388ULL, 0x000fe80000000800ULL, 0x0004000c53007388ULL, 0x000fe80000000800ULL,
0x000400092c007388ULL, 0x000fe80000000800ULL, 0x0000002124007388ULL, 0x000fe80000000800ULL,
0x0008002010007388ULL, 0x000fe80000000800ULL, 0x0008001e3d007388ULL, 0x000fe80000000800ULL,
0x0008001d4d007388ULL, 0x000fe80000000800ULL, 0x0008001c4f007388ULL, 0x000fe80000000800ULL,
0x0008001b12007388ULL, 0x000fe80000000800ULL, 0x0008001a53007388ULL, 0x000fe80000000800ULL,
0x000800192c007388ULL, 0x000fe80000000800ULL, 0x0000001f22007388ULL, 0x000fe80000000800ULL,
0x000c001710007388ULL, 0x000fe80000000800ULL, 0x000c00153d007388ULL, 0x000fe80000000800ULL,
0x000c00144d007388ULL, 0x000fe80000000800ULL, 0x000c00134f007388ULL, 0x000fe80000000800ULL,
0x000c001112007388ULL, 0x000fe80000000800ULL, 0x000c000e53007388ULL, 0x000fe80000000800ULL,
0x000c000d2c007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000057e087984ULL, 0x000e68000800cc00ULL, 0x000400057e1c7984ULL, 0x000ea8000800cc00ULL,
0x000800057e147984ULL, 0x000ee8000800cc00ULL, 0x000c00057e107984ULL, 0x000f28000800cc00ULL,
0x001000057e187984ULL, 0x000ee8000800cc00ULL, 0x001400057e207984ULL, 0x000f28000800cc00ULL,
0x001800057e247984ULL, 0x000f28000800cc00ULL, 0x001c00057e287984ULL, 0x000f22000800cc00ULL,
0x3f803f80050b7831ULL, 0x002fc4000020000bULL, 0x3f803f80050a7831ULL, 0x040fe4000020000aULL,
0x3f803f8005097831ULL, 0x040fe40000200009ULL, 0x3f803f8005087831ULL, 0x040fe40000200008ULL,
0x3f803f80051f7831ULL, 0x044fe4000020001fULL, 0x3f803f80051e7831ULL, 0x040fe4000020001eULL,
0x3f803f80051d7831ULL, 0x000fc4000020001dULL, 0x3f803f80051c7831ULL, 0x040fe4000020001cULL,
0x3f803f8005177831ULL, 0x048fe40000200017ULL, 0x3f803f8005167831ULL, 0x040fe40000200016ULL,
0x3f803f8005157831ULL, 0x040fe40000200015ULL, 0x3f803f8005147831ULL, 0x040fe40000200014ULL,
0x3f803f8005137831ULL, 0x010fc40000200013ULL, 0x3f803f8005127831ULL, 0x040fe40000200012ULL,
0x3f803f8005117831ULL, 0x040fe40000200011ULL, 0x3f803f8005107831ULL, 0x000fe40000200010ULL,
0x3f803f800b0b7831ULL, 0x000fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe4000020001aULL,
0x3f803f8009097831ULL, 0x000fc40000200019ULL, 0x3f803f8008087831ULL, 0x000fe40000200018ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x000000087e007988ULL, 0x000fe2000800cc05ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fe40000200020ULL, 0x3f803f8017177831ULL, 0x000fc40000200027ULL,
0x3f803f8016167831ULL, 0x000fe20000200026ULL, 0x0004001c7e007988ULL, 0x000fe2000800cc05ULL,
0x3f803f8015157831ULL, 0x000fe40000200025ULL, 0x3f803f8014147831ULL, 0x000fe40000200024ULL,
0x3f803f8013137831ULL, 0x000fe4000020002bULL, 0x3f803f8012127831ULL, 0x000fe2000020002aULL,
0x000800147e007988ULL, 0x000fe2000800cc05ULL, 0x3f803f8011117831ULL, 0x000fc40000200029ULL,
0x3f803f8010107831ULL, 0x000fca0000200028ULL, 0x000c00107e007988ULL, 0x000fe8000800cc05ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fc80000011603ULL,
0x000000810800720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000097b06ULL, 0x004ea20000209000ULL, 0x000000019e007824ULL, 0x000fe200078e0208ULL,
0x00005a00ff0c7a12ULL, 0x000fe200078e33ffULL, 0x0000000108087824ULL, 0x000fe200078e0203ULL,
0x0000002003117810ULL, 0x042fe40007ffe0ffULL, 0x00000007030f7812ULL, 0x000fe400078ec0ffULL,
0x0000000708087812ULL, 0x000fc800078ec0ffULL, 0x0ffffff808087812ULL, 0x000fe200078ef803ULL,
0x0000000900097308ULL, 0x004e640000001000ULL, 0x0ffffffe09067810ULL, 0x002fc60007ffe0ffULL,
0x0000000508087984ULL, 0x000e66000800cc00ULL, 0x0000000600077305ULL, 0x0004e4000021f000ULL,
0x000000ffff067224ULL, 0x004fe400078e00ffULL, 0x000000ffff057224ULL, 0x008fc800078e0a07ULL,
0x00005a0005057a24ULL, 0x000fc800078e02ffULL, 0x00000005070d7227ULL, 0x000fcc00078e0006ULL,
0x000000000d027227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a02ULL,
0x00005a0005057a24ULL, 0x000fca00078e0200ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102020810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000102021810ULL, 0x000fc80007ffe0ffULL, 0x000000020c027207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a02ULL, 0x0000590002057a24ULL, 0x000fe400078e027fULL,
0x00005a0007007a24ULL, 0x000fc800078e0200ULL, 0x00005a0005057a24ULL, 0x000fca00078e0200ULL,
0x0000000582057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e0005067a11ULL, 0x000fc800078240ffULL, 0x00005f0005077a11ULL, 0x000fe200008f4400ULL,
0x0000000804057824ULL, 0x000fe200078e020fULL, 0x00000003ff007819ULL, 0x000fc60000011611ULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x000000810000720cULL, 0x000fc80003f26070ULL,
0x0000000806007986ULL, 0x0023f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000009e027210ULL, 0x000fe20007ffe0ffULL, 0x0000000111007824ULL, 0x000fe200078e0200ULL,
0x00000040030f7810ULL, 0x000fc60007ffe0ffULL, 0x000000020d057227ULL, 0x000fe200078e00ffULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x000000ffff077224ULL, 0x002fe200078e0a05ULL,
0x0ffffff800007812ULL, 0x000fc600078ef811ULL, 0x00005a0007067a24ULL, 0x000fe400078e0202ULL,
0x0000000500087984ULL, 0x0002a6000800cc00ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd6000001160fULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050c067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x0000000582027210ULL, 0x000fe40007f3e0ffULL, 0x0000000711057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fe200078240ffULL,
0x0000000804057824ULL, 0x000fc600078e0205ULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019e027824ULL, 0x100fe200078e0200ULL, 0x0000006003117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f007824ULL, 0x000fe400078e0200ULL, 0x000000020d057227ULL, 0x000fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a05ULL,
0x0ffffff800007812ULL, 0x000fe200078ef80fULL, 0x00005a0007067a24ULL, 0x000fc800078e0202ULL,
0x0000000500087984ULL, 0x0002a2000800cc00ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd60000011611ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050c067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x0000000582027210ULL, 0x000fe40007f3e0ffULL, 0x000000070f057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fe200078240ffULL,
0x0000000804057824ULL, 0x000fc600078e0205ULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019e027824ULL, 0x100fe200078e0200ULL, 0x00000080030f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111007824ULL, 0x000fe400078e0200ULL, 0x000000020d057227ULL, 0x000fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a05ULL,
0x0ffffff800007812ULL, 0x000fe200078ef811ULL, 0x00005a0007067a24ULL, 0x000fc800078e0202ULL,
0x0000000500087984ULL, 0x0002a2000800cc00ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd6000001160fULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050c067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x0000000582027210ULL, 0x000fe40007f3e0ffULL, 0x0000000711057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fe200078240ffULL,
0x0000000804057824ULL, 0x000fc600078e0205ULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019e027824ULL, 0x100fe200078e0200ULL, 0x000000a003117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f007824ULL, 0x000fe400078e0200ULL, 0x000000020d057227ULL, 0x000fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a05ULL,
0x0ffffff800007812ULL, 0x000fe200078ef80fULL, 0x00005a0007067a24ULL, 0x000fc800078e0202ULL,
0x0000000500087984ULL, 0x0002a2000800cc00ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd60000011611ULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050c067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x0000000582027210ULL, 0x000fe40007f3e0ffULL, 0x000000070f057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fe400078240ffULL,
0x0000000504057211ULL, 0x000fe400078e18ffULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019e027824ULL, 0x100fe200078e0200ULL, 0x000000c0030f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111007824ULL, 0x000fe400078e0200ULL, 0x000000020d057227ULL, 0x000fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a05ULL,
0x0ffffff800007812ULL, 0x000fe200078ef811ULL, 0x00005a0007067a24ULL, 0x000fc800078e0202ULL,
0x0000000500087984ULL, 0x0002a2000800cc00ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd6000001160fULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050c067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fca00078e0202ULL,
0x0000000582027210ULL, 0x000fe40007f3e0ffULL, 0x0000000711057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fe200078240ffULL,
0x0000000804057824ULL, 0x000fc600078e0205ULL, 0x00005f0002077a11ULL, 0x000fe400008f4407ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019e027824ULL, 0x100fe200078e0200ULL, 0x000000e003117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f007824ULL, 0x000fe400078e0200ULL, 0x000000020d057227ULL, 0x000fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x002fc600078e0a05ULL,
0x0ffffff800007812ULL, 0x000fe200078ef80fULL, 0x00005a0007067a24ULL, 0x000fc800078e0202ULL,
0x0000000500087984ULL, 0x0002a2000800cc00ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fca0000011611ULL, 0x000000019e9e7824ULL, 0x000fcc00078e0200ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050c067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe400078e027fULL, 0x00005a0007027a24ULL, 0x000fc800078e0202ULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x0000000582067210ULL, 0x000fe40007f3e0ffULL,
0x000000070f057812ULL, 0x000fc600078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0006027a11ULL, 0x000fe200078240ffULL, 0x0000000804057824ULL, 0x000fc600078e0205ULL,
0x00005f0006037a11ULL, 0x000fe400008f4407ULL, 0x000000810000720cULL, 0x000fc60003f26070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000009e0d027227ULL, 0x002fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x0000000111007824ULL, 0x000fe400078e0200ULL,
0x00005a0003037a24ULL, 0x000fc600078e029eULL, 0x0000000700007812ULL, 0x000fe400078ec0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f26070ULL, 0xfffffff800007812ULL, 0x000fca00078ef811ULL,
0x0000000500087984ULL, 0x000e6c000800cc00ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102021810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f46070ULL,
0x0000000102022810ULL, 0x000fc80007ffe0ffULL, 0x000000020c027207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e027fULL,
0x00005a00059e7a24ULL, 0x000fe200078e029eULL, 0x0000000711057812ULL, 0x000fc600078ec0ffULL,
0x00005a0003037a24ULL, 0x000fe400078e029eULL, 0x0000000804057824ULL, 0x000fc600078e0205ULL,
0x0000000382037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4406ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000495217824ULL, 0x000fe400078e029aULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x000000232100720cULL, 0x000fda0003f06070ULL,
0x00000002a3048824ULL, 0x000fc800078e00ffULL, 0x00006a0004078a24ULL, 0x000fc800078e0221ULL,
0x0000660007068625ULL, 0x002fe200078e0096ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000606098981ULL, 0x000ea2000c1e1900ULL, 0x0000000195037810ULL, 0x000fe20007ffe0ffULL,
0x00000040a0a07824ULL, 0x000fe200078e00ffULL, 0x00005800000a7a02ULL, 0x000fe20000000f00ULL,
0x00000100ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000220300720cULL, 0x000fe20003f06070ULL,
0x01660000ff047f8cULL, 0x000e62000c80043fULL, 0x0000001f0a0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000409aa17824ULL, 0x000fe400078e00ffULL, 0x000000407f207824ULL, 0x000fe200078e00ffULL,
0x00000005ff317819ULL, 0x000fe2000001160aULL, 0x000000a009037224ULL, 0x004fc800078e02ffULL,
0x0000640003067625ULL, 0x000fe400078e000cULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x002fe20000011600ULL, 0x0000010095037824ULL, 0x000fe200078e02a1ULL,
0x0000000000197211ULL, 0x000fe400078fe8ffULL, 0x000000081a147810ULL, 0x000fe20007ffe0ffULL,
0x000000407f7f7824ULL, 0x000fe200078e021aULL, 0x0000000319197812ULL, 0x000fe400078ec0ffULL,
0x000020009a1b7811ULL, 0x000fe200078e68ffULL, 0x000001007f0a7825ULL, 0x040fe200078e00ffULL,
0x000000087f0c7810ULL, 0x000fc40007ffe0ffULL, 0x000000107f0e7810ULL, 0x040fe40007ffe0ffULL,
0x000000300a157812ULL, 0x100fe200078ef808ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x00000003940a7217ULL, 0x000fe40007800000ULL, 0x0000001506107210ULL, 0x000fe20007f1e0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c137812ULL, 0x100fe400078ef808ULL,
0x000000207f0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a037824ULL, 0x000fe200078e0a03ULL,
0x000000300e117812ULL, 0x000fc400078ef808ULL, 0x0000001306127210ULL, 0x040fe40007f3e0ffULL,
0x000000187f0a7810ULL, 0x000fe40007ffe0ffULL, 0x00000011060e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000107117824ULL, 0x040fe200000e060bULL, 0x000000031a00720cULL, 0x080fe20003f06070ULL,
0x0000000107137824ULL, 0x000fe200008e060dULL, 0x000000031400720cULL, 0x000fe20003f26070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0ffffffc19007812ULL, 0x000fc400078ef800ULL,
0x000000101a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a157812ULL, 0x100fe400078ef808ULL, 0x000000181a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000004140a7824ULL, 0x000fe200078e00ffULL, 0x000000300c177812ULL, 0x000fe200078ef808ULL,
0x00000001070f7824ULL, 0x000fe200010e060fULL, 0x0000001506147210ULL, 0x000fe20007f5e0ffULL,
0x00000010001d7824ULL, 0x000fe200078e021bULL, 0x0000001706167210ULL, 0x000fc40007f7e0ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee219ULL, 0x0000000107157824ULL, 0x040fe200010e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0003e2000c101c46ULL,
0x0000000107177824ULL, 0x000fe200018e060dULL, 0x000000281a0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000100a0d7824ULL, 0x000fe200078e021bULL, 0x000000287f0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000201a007810ULL, 0x000fe20007ffe0ffULL, 0x000000040c247824ULL, 0x000fe200078e00ffULL,
0x000000301a187810ULL, 0x000fe20007ffe0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000120d7faeULL, 0x0005e2000c901c46ULL,
0x000000030c00720cULL, 0x000fe20003f46070ULL, 0x0000000418267824ULL, 0x000fe200078e00ffULL,
0x000000300a1f7812ULL, 0x000fe200078ef808ULL, 0x000000041a287824ULL, 0x000fe200078e00ffULL,
0x000000307f0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000001f06107210ULL, 0x002fe40007fde0ffULL,
0x000000387f0c7810ULL, 0x000fe40007ffe0ffULL, 0x000000031c00720cULL, 0x080fe20003fa6070ULL,
0x0000000107117824ULL, 0x000fe200030e060bULL, 0x000000031e00720cULL, 0x080fe20003f86070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000030000720cULL, 0x080fe40003f66070ULL,
0x000000031800720cULL, 0x080fe20003f26070ULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x000000031a00720cULL, 0x000fe20003f06070ULL, 0x000000041e127824ULL, 0x004fe200078e00ffULL,
0x000000300a037812ULL, 0x000fe200078ef808ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc241a7812ULL, 0x000fc400078ee219ULL, 0x00000003060a7210ULL, 0x000fe20007fde0ffULL,
0x00000004001e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c007812ULL, 0x100fe400078ee219ULL,
0xfffffffc12127812ULL, 0x000fe200078ee219ULL, 0x00000001070b7824ULL, 0x000fe200030e060bULL,
0x000000300c1d7812ULL, 0x000fe400078ef808ULL, 0xfffffffc1e187812ULL, 0x000fe200078ee219ULL,
0x0000001012137824ULL, 0x000fe200078e021bULL, 0xfffffffc261c7812ULL, 0x000fc400078ee219ULL,
0xfffffffc281e7812ULL, 0x000fe200078ee219ULL, 0x0000001018197824ULL, 0x100fe200078e021bULL,
0x0000001b00037211ULL, 0x000fe200078e20ffULL, 0x000000101c1f7824ULL, 0x100fe200078e021bULL,
0x0000001d06067210ULL, 0x000fe20007fde0ffULL, 0x000000101a1d7824ULL, 0x100fe400078e021bULL,
0x000000101e1b7824ULL, 0x000fe200078e021bULL, 0x000000000e037faeULL, 0x0003e2000e901c46ULL,
0x0000000107077824ULL, 0x000fc600030e060dULL, 0x0000000014137faeULL, 0x0003e8000e101c46ULL,
0x0000000016197faeULL, 0x0003e8000d901c46ULL, 0x00000000101d7faeULL, 0x0003e8000d101c46ULL,
0x000000000a1f7faeULL, 0x0003e8000c901c46ULL, 0x00000000061b7faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000001800197811ULL, 0x042fe400078ff0ffULL,
0x0000000000037211ULL, 0x000fc400078fe8ffULL, 0x00000008000d7811ULL, 0x040fe200078ff0ffULL,
0x00000004190e7824ULL, 0x000fe200078e00ffULL, 0x00000010000f7811ULL, 0x040fe400078ff0ffULL,
0x0000002000137811ULL, 0x040fe200078ff0ffULL, 0x000000040d0c7824ULL, 0x000fe200078e00ffULL,
0x0000002800257811ULL, 0x040fe200078ff0ffULL, 0x000000040f107824ULL, 0x000fe200078e00ffULL,
0x0000003000297811ULL, 0x040fe200078ff0ffULL, 0x0000000413127824ULL, 0x000fe200078e00ffULL,
0x00000038002d7811ULL, 0x040fe200078ff0ffULL, 0x0000000425147824ULL, 0x000fe200078e00ffULL,
0x00000020000a7211ULL, 0x000fe200078ff0ffULL, 0x0000000429167824ULL, 0x000fe200078e00ffULL,
0x0000000303037812ULL, 0x000fe200078ec0ffULL, 0x000000042d1a7824ULL, 0x000fe200078e00ffULL,
0x000020009a2f7811ULL, 0x000fe200078e68ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc0e117812ULL, 0x000fc400078ee203ULL, 0x0ffffffc03187812ULL, 0x000fe200078ef800ULL,
0x00000001200e7824ULL, 0x000fe200078e020fULL, 0xfffffffc0c007812ULL, 0x000fe200078ee203ULL,
0x00000001200c7824ULL, 0x000fe200078e020dULL, 0xfffffffc10107812ULL, 0x100fe200078ee203ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x100fe400078ee203ULL,
0xfffffffc14157812ULL, 0x100fe200078ee203ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc16167812ULL, 0x000fc400078ee203ULL, 0xfffffffc1a177812ULL, 0x000fe200078ee203ULL,
0x0000001018357824ULL, 0x000fe200078e022fULL, 0x000000300a037812ULL, 0x100fe200078ef808ULL,
0x00000001200a7824ULL, 0x000fe200078e0219ULL, 0x000000300e197812ULL, 0x100fe200078ef808ULL,
0x00000010111d7824ULL, 0x100fe200078e022fULL, 0x0000000306147210ULL, 0x000fe20007f1e0ffULL,
0x0000001015277824ULL, 0x000fe200078e022fULL, 0x000000300c117812ULL, 0x000fe200078ef808ULL,
0x00000001200c7824ULL, 0x000fe200078e0213ULL, 0x0000001906187210ULL, 0x000fe20007f5e0ffULL,
0x0000000107157824ULL, 0x000fe200000e060bULL, 0x0000002f162b7211ULL, 0x000fe200078e20ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001106167210ULL, 0x000fc40007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x0000000107197824ULL, 0x000fe200010e060fULL, 0x000000300a0f7812ULL, 0x000fe200078ef808ULL,
0x0000001000037824ULL, 0x100fe400078e022fULL, 0x00000010101b7824ULL, 0x100fe200078e022fULL,
0x0000000f060a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010121f7824ULL, 0x000fe400078e022fULL,
0x00000001200e7824ULL, 0x000fe400078e0225ULL, 0x00000010172f7824ULL, 0x000fc400078e022fULL,
0x0000000120107824ULL, 0x040fe400078e0229ULL, 0x0000000107177824ULL, 0x000fe400008e060dULL,
0x0000000120127824ULL, 0x000fe400078e022dULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000016037faeULL, 0x0003e6000b901c46ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c337812ULL, 0x100fe200078ef808ULL, 0x00000000181b7faeULL, 0x0003e4000b901c46ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000300e2d7812ULL, 0x000fc600078ef808ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000003010297812ULL, 0x100fe400078ef808ULL,
0x0000002d060e7210ULL, 0x000fe20007f3e0ffULL, 0x00000001070b7824ULL, 0x040fe200000e060bULL,
0x0000003012257812ULL, 0x000fe400078ef808ULL, 0x00000033060c7210ULL, 0x040fe20007f1e0ffULL,
0x00000001070f7824ULL, 0x040fe200008e060fULL, 0x0000002906107210ULL, 0x040fe20007f5e0ffULL,
0x000000000a1d7faeULL, 0x0003e2000b901c46ULL, 0x0000002506067210ULL, 0x000fe20007f7e0ffULL,
0x00000001070d7824ULL, 0x000fc400000e060dULL, 0x0000000107117824ULL, 0x040fe400010e0611ULL,
0x0000000107077824ULL, 0x000fe200018e0613ULL, 0x000000000c1f7faeULL, 0x0003e8000b901c46ULL,
0x000000000e277faeULL, 0x0003e8000b901c46ULL, 0x00000000102b7faeULL, 0x0003e8000b901c46ULL,
0x00000000062f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01660400ff037984ULL, 0x000e620000000800ULL,
0x0000003102977224ULL, 0x000fc400078e02ffULL, 0x00000001949c7824ULL, 0x000fe400078e0a9bULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620097967625ULL, 0x000fe200078e0096ULL, 0x00000008ff9c7819ULL, 0x000fe2000001169cULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x00000002060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000103037824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011403ULL, 0x0000000b00007211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x0000000200007819ULL, 0x000fc80000001203ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01660400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000229500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000001f7919ULL, 0x000e620000000000ULL,
0x00006a00a3a37a24ULL, 0x000fe200078e02ffULL, 0x000166889a9d7811ULL, 0x040fe200078e18ffULL,
0x00000002311e7824ULL, 0x000fe200078e00ffULL, 0xffffffff9b1d7810ULL, 0x040fe20007ffe0ffULL,
0x000000209a9f7824ULL, 0x000fe200078e00ffULL, 0x000000099b1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000195037810ULL, 0x008fe20007ffe0ffULL, 0x00000100ffa27424ULL, 0x000fe200078e00ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000009a0997224ULL, 0x000fe200078e02ffULL,
0x000000220300720cULL, 0x000fe20003f06070ULL, 0x00000100951b7824ULL, 0x000fc400078e02a1ULL,
0x0000640099987625ULL, 0x000fd400078e00a2ULL, 0x0000064000008947ULL, 0x004fea0003800000ULL,
0x00000002ff197819ULL, 0x002fe2000001161fULL, 0x000000101f1a7824ULL, 0x000fe200078e00ffULL,
0x0000001b94007217ULL, 0x000fe40007800000ULL, 0x0000001920027210ULL, 0x000fe40007ffe0ffULL,
0x000000301a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a1bULL,
0x0000000819157810ULL, 0x040fe20007ffe0ffULL, 0x0000010002027825ULL, 0x000fe200078e00ffULL,
0x0000001019177810ULL, 0x000fc40007ffe0ffULL, 0x000000401a117812ULL, 0x000fe200078efcffULL,
0x0000000120047824ULL, 0x040fe200078e0215ULL, 0x0000001819257810ULL, 0x040fe20007ffe0ffULL,
0x0000000120067824ULL, 0x000fe200078e0217ULL, 0x00000011020d7212ULL, 0x000fe200078efcffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000002019277810ULL, 0x000fe40007ffe0ffULL,
0x0000000d980c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000120087824ULL, 0x000fe200078e0225ULL,
0x0000001104137212ULL, 0x000fe200078efcffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000001f1f047211ULL, 0x000fc400078fe8ffULL, 0x0000002819297810ULL, 0x000fe20007ffe0ffULL,
0x00000001200a7824ULL, 0x000fe200078e0227ULL, 0x00000011060f7212ULL, 0x000fe200078efcffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000304107812ULL, 0x000fe400078ec0ffULL,
0x0000000f98067210ULL, 0x040fe20007f5e0ffULL, 0x00000001990d7824ULL, 0x000fe200008e0603ULL,
0x00000013980e7210ULL, 0x000fe20007f3e0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001108137212ULL, 0x000fc400078efcffULL, 0x000030009a027811ULL, 0x000fe200078e68ffULL,
0x00000001990f7824ULL, 0x040fe200008e0605ULL, 0x000000110a037212ULL, 0x000fe200078efcffULL,
0x0000000120047824ULL, 0x000fe200078e0229ULL, 0x0000001398087210ULL, 0x040fe20007f3e0ffULL,
0x0000000199077824ULL, 0x000fe200010e0607ULL, 0x00000003980a7210ULL, 0x000fe20007f7e0ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0ffffffc1f037812ULL, 0x000fe400078ec0ffULL,
0x000000001500720cULL, 0x080fe20003f46070ULL, 0x0000000199097824ULL, 0x000fe200008e0609ULL,
0x000000001900720cULL, 0x080fe20003f26070ULL, 0x00000001990b7824ULL, 0x000fe200018e060bULL,
0x0000000310137212ULL, 0x000fe200078efcffULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x000000001700720cULL, 0x040fe20003f66070ULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x00000030192b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001013137824ULL, 0x000fe200078e0202ULL,
0xfffffffc15157812ULL, 0x000fc400078ee210ULL, 0x00000038192d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffffc17177812ULL, 0x000fe200078ee210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000c901c46ULL, 0x0000001104197212ULL, 0x000fe200078efcffULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x000000002500720cULL, 0x080fe20003fa6070ULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0x000000002700720cULL, 0x080fe20003f86070ULL,
0x0000000120047824ULL, 0x000fe200078e022bULL, 0x000000000e157faeULL, 0x0005e2000d101c46ULL,
0x000000002b00720cULL, 0x000fc40003f46070ULL, 0x000000002d00720cULL, 0x080fe20003f26070ULL,
0x0000000006177faeULL, 0x0007e2000d901c46ULL, 0x00000019980c7210ULL, 0x002fe20007fde0ffULL,
0x0000000429197824ULL, 0x040fe200078e00ffULL, 0x000000002900720cULL, 0x000fc60003f66070ULL,
0x00000001990d7824ULL, 0x000fe200030e0605ULL, 0xfffffffc19197812ULL, 0x000fe200078ee210ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000002d20067210ULL, 0x008fc60007ffe0ffULL,
0x0000000425157824ULL, 0x004fe200078e00ffULL, 0x00000011040f7212ULL, 0x000fe200078efcffULL,
0x0000000427177824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000f98047210ULL, 0x000fe40007fde0ffULL, 0xfffffffc15157812ULL, 0x100fe200078ee210ULL,
0x000000042b257824ULL, 0x000fe200078e00ffULL, 0x0000001106137212ULL, 0x000fe200078efcffULL,
0x000000042d277824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x100fe200078ee210ULL,
0x0000000199057824ULL, 0x000fe200030e0605ULL, 0xfffffffc25257812ULL, 0x000fe200078ee210ULL,
0x00000010150f7824ULL, 0x000fe200078e0202ULL, 0xfffffffc27277812ULL, 0x000fe200078ee210ULL,
0x0000001017117824ULL, 0x100fe200078e0202ULL, 0x0000001398067210ULL, 0x000fe20007fde0ffULL,
0x0000001019137824ULL, 0x100fe200078e0202ULL, 0x00000000080f7faeULL, 0x0003e2000e901c46ULL,
0x0000001025157824ULL, 0x000fc400078e0202ULL, 0x0000001027177824ULL, 0x000fe200078e0202ULL,
0x000000000a117faeULL, 0x0003e2000e101c46ULL, 0x0000000199077824ULL, 0x000fc600030e0607ULL,
0x000000000c137faeULL, 0x0003e8000d901c46ULL, 0x0000000004157faeULL, 0x0003e8000d101c46ULL,
0x0000000006177faeULL, 0x0003e2000c901c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x000000181f097811ULL, 0x042fe200078ff0ffULL, 0x000000101f1a7824ULL, 0x040fe200078e00ffULL,
0x0000001f1f007211ULL, 0x000fc400078fe8ffULL, 0x000000101f077811ULL, 0x040fe200078ff0ffULL,
0x00000001200c7824ULL, 0x000fe200078e0209ULL, 0x000000081f057811ULL, 0x000fe200078ff0ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0x0000000300007812ULL, 0x000fe200078ec0ffULL,
0x0000000120087824ULL, 0x000fe200078e0207ULL, 0x000000301a1a7812ULL, 0x000fe200078ec0ffULL,
0x00000004050b7824ULL, 0x000fe200078e00ffULL, 0x000000281f137811ULL, 0x000fe200078ff0ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x000000381f317811ULL, 0x040fe200078ff0ffULL,
0x0000000120067824ULL, 0x000fe200078e0205ULL, 0x000000201f047211ULL, 0x000fe200078ff0ffULL,
0x00000004130f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc090e7812ULL, 0x000fe200078ee200ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000201f117811ULL, 0x000fc400078ff0ffULL,
0x000000401a2d7812ULL, 0x000fe200078efcffULL, 0x0000000431177824ULL, 0x000fe200078e00ffULL,
0x000030009a2b7811ULL, 0x000fe200078e68ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0xfffffffc0b027812ULL, 0x100fe400078ee200ULL, 0xfffffffc070a7812ULL, 0x100fe200078ee200ULL,
0x00000004110d7824ULL, 0x000fe200078e00ffULL, 0x0000002d080b7212ULL, 0x000fe200078efcffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0xfffffffc0f127812ULL, 0x000fc400078ee200ULL,
0xfffffffc17167812ULL, 0x100fe200078ee200ULL, 0x000000100a177824ULL, 0x100fe200078e022bULL,
0x0000002d040f7212ULL, 0x000fe200078efcffULL, 0x0000001012277824ULL, 0x000fe200078e022bULL,
0x0000000b98087210ULL, 0x000fe20007f7e0ffULL, 0x000001000c0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc0d107812ULL, 0x100fe400078ee200ULL, 0x000000301f2f7811ULL, 0x000fe200078ff0ffULL,
0x00000001200c7824ULL, 0x000fe200078e0211ULL, 0x0000000f98047210ULL, 0x000fe20007f3e0ffULL,
0x0000001010257824ULL, 0x000fe200078e022bULL, 0x0000002d060d7212ULL, 0x000fe200078efcffULL,
0x0000000120107824ULL, 0x000fe200078e022fULL, 0x0000002b0e197211ULL, 0x000fe200078e20ffULL,
0x00000001200e7824ULL, 0x000fe200078e0213ULL, 0x0000002d0a0f7212ULL, 0x000fe200078efcffULL,
0x000000042f157824ULL, 0x000fe200078e00ffULL, 0x0000000d98067210ULL, 0x040fe20007f5e0ffULL,
0x0000000105057824ULL, 0x000fe200008e0699ULL, 0x0000000f980a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000120127824ULL, 0x000fe200078e0231ULL, 0x0ffffffc1f037812ULL, 0x000fe200078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc15147812ULL, 0x000fc400078ee200ULL,
0x0000000300007212ULL, 0x000fe200078efcffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000002d0c337212ULL, 0x000fc600078efcffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000002d0e317212ULL, 0x000fc600078efcffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000002d102f7212ULL, 0x000fc600078efcffULL, 0x000000010b0b7824ULL, 0x100fe200008e0699ULL,
0x0000002d122d7212ULL, 0x000fe200078efcffULL, 0x0000000107077824ULL, 0x000fe200010e0699ULL,
0x00000033980c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001000357824ULL, 0x000fe200078e022bULL,
0x00000031980e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000109097824ULL, 0x000fe200018e0699ULL,
0x0000002f98107210ULL, 0x000fe20007f7e0ffULL, 0x0000001002157824ULL, 0x000fe200078e022bULL,
0x0000002d98127210ULL, 0x000fe20007f9e0ffULL, 0x000000010d0d7824ULL, 0x100fe200008e0699ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004357faeULL, 0x0003e2000b901c46ULL,
0x000000010f0f7824ULL, 0x000fc400010e0699ULL, 0x0000001014297824ULL, 0x000fe200078e022bULL,
0x0000000006157faeULL, 0x0003e2000b901c46ULL, 0x0000000111117824ULL, 0x000fe400018e0699ULL,
0x00000010162b7824ULL, 0x000fe200078e022bULL, 0x0000000008177faeULL, 0x0003e2000b901c46ULL,
0x0000000113137824ULL, 0x000fc600020e0699ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x000000000c257faeULL, 0x0003e8000b901c46ULL, 0x000000000e277faeULL, 0x0003e8000b901c46ULL,
0x0000000010297faeULL, 0x0003e8000b901c46ULL, 0x00000000122b7faeULL, 0x0003e4000b901c46ULL,
0x000000081f007812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff157819ULL, 0x102fe2000001161fULL, 0x000020009a717824ULL, 0x000fe200078e00ffULL,
0x0000000700197812ULL, 0x000fc400078ef81fULL, 0x000000071f057812ULL, 0x000fe200078ec0ffULL,
0x0000000815027824ULL, 0x040fe200078e00ffULL, 0x00000003ff0c7819ULL, 0x000fe2000001161fULL,
0x0000000115187824ULL, 0x000fe200078e0219ULL, 0x0000001019167812ULL, 0x040fe200078efcffULL,
0x0000001019077824ULL, 0x040fe200078e00ffULL, 0xfffffff802057812ULL, 0x000fe200078ee205ULL,
0x0000001019097824ULL, 0x000fe200078e00ffULL, 0x0000000218007810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200078e0216ULL, 0x000000010c047812ULL, 0x000fe200078ec0ffULL,
0x00000004050b7824ULL, 0x000fe200078e00ffULL, 0xfffffff0070e7812ULL, 0x000fe200078ee200ULL,
0x0000001016067824ULL, 0x040fe200078e00ffULL, 0x0000000405027211ULL, 0x040fe200078ff8ffULL,
0x0000001016257824ULL, 0x000fe200078e00ffULL, 0x0000001005077810ULL, 0x040fe20007ffe0ffULL,
0x000000100e347824ULL, 0x000fe200078e00ffULL, 0x00000020050d7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000030050f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000407767824ULL, 0x000fe200078e00ffULL, 0xfffffff009007812ULL, 0x000fe200078ee218ULL,
0x000000040d097824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b7a7812ULL, 0x000fe200078ee202ULL,
0x000000040f0b7824ULL, 0x000fe200078e00ffULL, 0x0000000202727810ULL, 0x000fe20007ffe0ffULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x0000000205277819ULL, 0x000fe200000006ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffff006027812ULL, 0x000fe200078ee215ULL,
0x000000003434783bULL, 0x000fe20000000200ULL, 0x0000000407057211ULL, 0x0c0fe200078ff8ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x000000040d067211ULL, 0x080fe200078ff8ffULL,
0x0000001002027824ULL, 0x000fe200078e00ffULL, 0x000000040f047211ULL, 0x000fe200078ff8ffULL,
0x000000000064783bULL, 0x0003e20000000200ULL, 0x0000200071177810ULL, 0x000fe20007ffe0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc76767812ULL, 0x000fe200078ee205ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09787812ULL, 0x000fe200078ee206ULL,
0x000000107a147824ULL, 0x100fe200078e0217ULL, 0xfffffffc0b747812ULL, 0x000fe200078ee204ULL,
0x0000001076137824ULL, 0x100fe200078e0217ULL, 0x000000000208783bULL, 0x0005e20000000200ULL,
0x0000001078127824ULL, 0x100fe200078e0217ULL, 0x0000000215107810ULL, 0x000fe20007ffe0ffULL,
0x0000001074117824ULL, 0x000fe200078e0217ULL, 0x000000001468783bULL, 0x000ee20000000200ULL,
0x0000000205707810ULL, 0x000fc40007ffe0ffULL, 0x0000000204007810ULL, 0x002fe20007ffe0ffULL,
0x000000001360783bULL, 0x000e620000000200ULL, 0x0000000206027810ULL, 0x004fe40007ffe0ffULL,
0xfffffff025247812ULL, 0x000fe200078ee210ULL, 0x00000000125c783bULL, 0x000ea20000000200ULL,
0xfffffffc27727812ULL, 0x000fe400078ee272ULL, 0xfffffffc07707812ULL, 0x000fe200078ee270ULL,
0x00000000116c783bULL, 0x000f220000000200ULL, 0xfffffffc0d027812ULL, 0x000fe200078ee202ULL,
0x0000001024547824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f007812ULL, 0x000fe200078ee200ULL,
0x0000001072107824ULL, 0x000fc400078e0217ULL, 0x00000010700f7824ULL, 0x100fe400078e0217ULL,
0x00000010020e7824ULL, 0x100fe200078e0217ULL, 0x00000000103c783bULL, 0x000e620000000200ULL,
0x00000010000d7824ULL, 0x000fc600078e0217ULL, 0x000000005454783bULL, 0x000ea80000000200ULL,
0x000000000f44783bULL, 0x000ea80000000200ULL, 0x000000000e4c783bULL, 0x000ea80000000200ULL,
0x000000000d04783bULL, 0x000ea20000000200ULL, 0x000000686458723cULL, 0x088f7000000418ffULL,
0x000000680838723cULL, 0x000f7000000418ffULL, 0x0000006a6424723cULL, 0x040f7000000418ffULL,
0x000000606428723cULL, 0x042f7000000418ffULL, 0x000000626490723cULL, 0x040f7000000418ffULL,
0x0000005c648c723cULL, 0x044f7000000418ffULL, 0x0000005e642c723cULL, 0x000f7000000418ffULL,
0x000000600840723cULL, 0x040f7000000418ffULL, 0x0000005c0848723cULL, 0x040f7000000418ffULL,
0x0000006a0868723cULL, 0x000f7000000418ffULL, 0x0000006c6430723cULL, 0x010f7000000418ffULL,
0x000000620860723cULL, 0x040f7000000418ffULL, 0x0000005e085c723cULL, 0x040f7000000418ffULL,
0x0000006c0850723cULL, 0x000f7000000418ffULL, 0x0000006e6464723cULL, 0x080f7000000418ffULL,
0x0000006e0808723cULL, 0x000f7000000418ffULL, 0x0000003c3458723cULL, 0x0a0b700000041858ULL,
0x0000003c5438723cULL, 0x000b700000041838ULL, 0x0000003e3424723cULL, 0x040b700000041824ULL,
0x000000443428723cULL, 0x040b700000041828ULL, 0x000000463490723cULL, 0x040b700000041890ULL,
0x0000004c348c723cULL, 0x040b70000004188cULL, 0x0000004e342c723cULL, 0x000b70000004182cULL,
0x000000445440723cULL, 0x040b700000041840ULL, 0x0000004c5448723cULL, 0x040b700000041848ULL,
0x0000003e543c723cULL, 0x000b700000041868ULL, 0x000000043430723cULL, 0x000b700000041830ULL,
0x000000465444723cULL, 0x040b700000041860ULL, 0x0000004e544c723cULL, 0x040b70000004185cULL,
0x000000045450723cULL, 0x000b700000041850ULL, 0x000000063434723cULL, 0x080b700000041864ULL,
0x000000065454723cULL, 0x000b620000041808ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x0000001b94067217ULL, 0x020fe20007800000ULL, 0x000000010c0c7824ULL, 0x100fe200078e021fULL,
0x00000002ff057819ULL, 0x000fc4000001161fULL, 0x000000801a047812ULL, 0x000fe200078efcffULL,
0x0000000106697824ULL, 0x000fe200078e0a1bULL, 0x0000000805667810ULL, 0x040fe40007ffe0ffULL,
0x0000001005677810ULL, 0x040fe40007ffe0ffULL, 0x0000000520077210ULL, 0x040fe20007ffe0ffULL,
0x0000000120097824ULL, 0x040fe200078e0266ULL, 0x00000018056a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001200b7824ULL, 0x000fe200078e0267ULL, 0x00000020056b7810ULL, 0x000fc40007ffe0ffULL,
0x00000028056c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001205d7824ULL, 0x040fe200078e026aULL,
0x00000030056d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001205f7824ULL, 0x040fe200078e026bULL,
0x000000690500720cULL, 0x0c0fe20003f26070ULL, 0x0000000120617824ULL, 0x000fe200078e026cULL,
0x00000038056e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000120637824ULL, 0x000fe200078e026dULL,
0x000000696d00720cULL, 0x080fe20003fa6070ULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x000000696e00720cULL, 0x000fc60003fc6070ULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000000898087210ULL, 0x000fc60007f7e0ffULL, 0x000001005f5e7825ULL, 0x000fe200078e0004ULL,
0x0000000a98647210ULL, 0x000fc60007f9e0ffULL, 0x0000000120657824ULL, 0x000fe400078e026eULL,
0x0000000199097824ULL, 0x000fe200018e0609ULL, 0x0000005e985e7210ULL, 0x000fe20007f7e0ffULL,
0x0000010007067825ULL, 0x000fc800078e0004ULL, 0x000001005d5c7825ULL, 0x000fe200078e0004ULL,
0x0000000698067210ULL, 0x000fc60007f5e0ffULL, 0x0000010061607825ULL, 0x000fc800078e0004ULL,
0x0000010063627825ULL, 0x000fc800078e0004ULL, 0x0000010065047825ULL, 0x000fc800078e0004ULL,
0x0000000199657824ULL, 0x040fe200020e060bULL, 0x000000030c0b7212ULL, 0x000fe200078efcffULL,
0x0000000466037824ULL, 0x000fe200078e00ffULL, 0x0000006098607210ULL, 0x000fe20007f9e0ffULL,
0x00000001995f7824ULL, 0x040fe200018e065fULL, 0x000000696600720cULL, 0x080fe20003f66070ULL,
0x0000000199077824ULL, 0x000fe200010e0607ULL, 0xfffffffc03667812ULL, 0x000fe200078ee20cULL,
0x0000000199617824ULL, 0x000fe200020e0661ULL, 0x000000696700720cULL, 0x040fe20003f86070ULL,
0x0000000467677824ULL, 0x000fe200078e00ffULL, 0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL,
0x000000100b0a7824ULL, 0x000fc400078e0217ULL, 0x0000001066037824ULL, 0x000fe200078e0217ULL,
0xfffffffc67687812ULL, 0x100fe200078ee20cULL, 0x000000046a6f7824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060a7faeULL, 0x0003e2000c901c46ULL,
0x000000696a00720cULL, 0x080fe20003f26070ULL, 0x00000001995d7824ULL, 0x000fe200010e065dULL,
0x0000006298627210ULL, 0x000fe20007f5e0ffULL, 0x0000000008037faeULL, 0x0005e2000d901c46ULL,
0x000000696b00720cULL, 0x040fe20003f66070ULL, 0x000000046b6b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc6f667812ULL, 0x000fe200078ee20cULL, 0x0000001068677824ULL, 0x000fc400078e0217ULL,
0x000000046d6d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc6b067812ULL, 0x102fe400078ee20cULL,
0x0000000064677faeULL, 0x0003e2000e101c46ULL, 0x000000696c00720cULL, 0x000fe20003f86070ULL,
0x0000000199637824ULL, 0x000fe200010e0663ULL, 0x0000001766077211ULL, 0x000fe200078e20ffULL,
0x000000046c037824ULL, 0x004fe200078e00ffULL, 0x0000000498047210ULL, 0x000fe20007f5e0ffULL,
0x000000046e097824ULL, 0x000fe400078e00ffULL, 0x000000005c077faeULL, 0x0005e2000c901c46ULL,
0xfffffffc03087812ULL, 0x100fe200078ee20cULL, 0x0000001006037824ULL, 0x000fe200078e0217ULL,
0xfffffffc6d067812ULL, 0x100fe200078ee20cULL, 0x0000000199057824ULL, 0x000fe200010e0605ULL,
0xfffffffc09647812ULL, 0x002fe200078ee20cULL, 0x0000001008097824ULL, 0x100fe200078e0217ULL,
0x000000005e037faeULL, 0x0003e8000d901c46ULL, 0x0000000060097faeULL, 0x0003e2000e101c46ULL,
0x0000001006077824ULL, 0x004fc400078e0217ULL, 0x00000010645d7824ULL, 0x000fc600078e0217ULL,
0x0000000062077faeULL, 0x0003e8000e901c46ULL, 0x00000000045d7faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000801a627812ULL, 0x020fe200078efcffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x000000201f057211ULL, 0x040fe200078ff0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e021fULL, 0x000000181f6b7811ULL, 0x040fe400078ff0ffULL,
0x000000081f677811ULL, 0x000fe200078ff0ffULL, 0x0000010005047825ULL, 0x000fe200078e0062ULL,
0x000000101f697811ULL, 0x000fc400078ff0ffULL, 0x000000201f6d7811ULL, 0x040fe200078ff0ffULL,
0x00000001200b7824ULL, 0x040fe200078e026bULL, 0x000000281f6f7811ULL, 0x040fe200078ff0ffULL,
0x0000000120077824ULL, 0x000fe200078e0267ULL, 0x000000301f737811ULL, 0x000fe200078ff0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0062ULL, 0x0000000498047210ULL, 0x000fe40007f3e0ffULL,
0x000000381f757811ULL, 0x000fe200078ff0ffULL, 0x0000000467677824ULL, 0x000fe200078e00ffULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000120097824ULL, 0x000fc400078e0269ULL,
0x00000001205d7824ULL, 0x040fe200078e026dULL, 0xfffffffc67667812ULL, 0x000fe200078ee20cULL,
0x00000001205f7824ULL, 0x040fe400078e026fULL, 0x0000000120617824ULL, 0x000fe400078e0273ULL,
0x0000000199057824ULL, 0x000fe200008e0605ULL, 0x0000000a98647210ULL, 0x000fe20007f3e0ffULL,
0x0000000120657824ULL, 0x000fe400078e0275ULL, 0x0000010007067825ULL, 0x000fc800078e0062ULL,
0x0000010009087825ULL, 0x000fe200078e0062ULL, 0x0000000698067210ULL, 0x000fc60007f5e0ffULL,
0x000001005d5c7825ULL, 0x000fe200078e0062ULL, 0x0000000898087210ULL, 0x000fc60007f7e0ffULL,
0x000001005f5e7825ULL, 0x000fc800078e0062ULL, 0x0000010061607825ULL, 0x000fc800078e0062ULL,
0x000000046b6b7824ULL, 0x000fe400078e00ffULL, 0x0000010065627825ULL, 0x000fc800078e0062ULL,
0x0000000199657824ULL, 0x000fe200008e060bULL, 0x000000030c0b7212ULL, 0x000fe200078efcffULL,
0x0000000469697824ULL, 0x000fe200078e00ffULL, 0x0000005e985e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001066037824ULL, 0x100fe200078e0217ULL, 0xfffffffc6b667812ULL, 0x100fe200078ee20cULL,
0x000000046d6d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc69687812ULL, 0x100fe200078ee20cULL,
0x000000100b0a7824ULL, 0x000fe400078e0217ULL, 0x0000000199077824ULL, 0x000fe200010e0607ULL,
0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001066697824ULL, 0x000fe200078e0217ULL,
0xfffffffc6d667812ULL, 0x000fe200078ee20cULL, 0x000000046f6f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040a7faeULL, 0x0003e2000b901c46ULL,
0x0000000473737824ULL, 0x000fe200078e00ffULL, 0x0000005d995d7210ULL, 0x000fe200017fe4ffULL,
0x0000000475757824ULL, 0x000fe200078e00ffULL, 0x0000000006037faeULL, 0x0005e2000b901c46ULL,
0x0000000199097824ULL, 0x040fe200018e0609ULL, 0x0000006098607210ULL, 0x040fe20007f5e0ffULL,
0x00000001995f7824ULL, 0x000fe200008e065fULL, 0x0000006298627210ULL, 0x000fe20007f3e0ffULL,
0x0000001068677824ULL, 0x000fc400078e0217ULL, 0x0000000199617824ULL, 0x000fe200010e0661ULL,
0xfffffffc6f047812ULL, 0x102fe200078ee20cULL, 0x0000001066057824ULL, 0x100fe200078e0217ULL,
0xfffffffc75667812ULL, 0x100fe200078ee20cULL, 0x0000000008677faeULL, 0x0003e2000b901c46ULL,
0xfffffffc73067812ULL, 0x004fe200078ee20cULL, 0x0000001004037824ULL, 0x000fe400078e0217ULL,
0x0000000199637824ULL, 0x000fe200008e0663ULL, 0x0000000064697faeULL, 0x0005e2000b901c46ULL,
0x0000001006077824ULL, 0x000fc600078e0217ULL, 0x000000005c057faeULL, 0x0005e2000b901c46ULL,
0x0000001066097824ULL, 0x002fc600078e0217ULL, 0x000000005e037faeULL, 0x0005e8000b901c46ULL,
0x0000000060077faeULL, 0x0005e8000b901c46ULL, 0x0000000062097faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001016057824ULL, 0x006fe200078e00ffULL,
0x0000000415047810ULL, 0x000fe20007ffe0ffULL, 0x0000001019067824ULL, 0x040fe200078e00ffULL,
0x0000000418037810ULL, 0x000fe20007ffe0ffULL, 0x00000010195d7824ULL, 0x000fe200078e00ffULL,
0x0000300071097810ULL, 0x000fe20007ffe0ffULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0xfffffff005047812ULL, 0x000fc400078ee204ULL, 0xfffffff006037812ULL, 0x000fe200078ee203ULL,
0x0000001074057824ULL, 0x100fe200078e0209ULL, 0x0000000976077211ULL, 0x000fe200078e20ffULL,
0x0000001004747824ULL, 0x000fe200078e00ffULL, 0x0000000618047810ULL, 0x000fe20007ffe0ffULL,
0x000000107a087824ULL, 0x100fe400078e0209ULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0xfffffff05d5c7812ULL, 0x000fe200078ee204ULL, 0x0000001078067824ULL, 0x100fe200078e0209ULL,
0x00000006155d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001072047824ULL, 0x000fc400078e0209ULL,
0x000000105c717824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000884783bULL, 0x000fe20000000200ULL, 0xfffffff05e5d7812ULL, 0x000fe200078ee25dULL,
0x0000001002027824ULL, 0x100fe400078e0209ULL, 0x000000000388783bULL, 0x0002a20000000200ULL,
0x0000001000007824ULL, 0x100fe400078e0209ULL, 0x000000105d5d7824ULL, 0x000fe200078e00ffULL,
0x000000000780783bULL, 0x000ee80000000200ULL, 0x00000000067c783bULL, 0x000f220000000200ULL,
0x0000001070037824ULL, 0x002fc600078e0209ULL, 0x000000000578783bULL, 0x000e680000000200ULL,
0x000000007474783bULL, 0x000e680000000200ULL, 0x00000000046c783bULL, 0x000fe80000000200ULL,
0x000000007170783bULL, 0x000e680000000200ULL, 0x000000000368783bULL, 0x000e680000000200ULL,
0x000000000264783bULL, 0x000e680000000200ULL, 0x000000000060783bULL, 0x000e680000000200ULL,
0x000000005d5c783bULL, 0x000e620000000200ULL, 0x000000848858723cULL, 0x044f700000041858ULL,
0x000000868824723cULL, 0x040f700000041824ULL, 0x000000808828723cULL, 0x048f700000041828ULL,
0x000000828890723cULL, 0x040f700000041890ULL, 0x0000007c888c723cULL, 0x050f70000004188cULL,
0x0000007e882c723cULL, 0x040f70000004182cULL, 0x000000788830723cULL, 0x042f700000041830ULL,
0x0000007a8834723cULL, 0x000f700000041834ULL, 0x000000847438723cULL, 0x040f700000041838ULL,
0x00000086743c723cULL, 0x040f70000004183cULL, 0x000000807440723cULL, 0x040f700000041840ULL,
0x000000827444723cULL, 0x040f700000041844ULL, 0x0000007c7448723cULL, 0x040f700000041848ULL,
0x0000007e744c723cULL, 0x040f70000004184cULL, 0x000000787450723cULL, 0x040f700000041850ULL,
0x0000007a7454723cULL, 0x000f700000041854ULL, 0x0000006c7058723cULL, 0x060b700000041858ULL,
0x0000006e7024723cULL, 0x040b700000041824ULL, 0x000000687028723cULL, 0x040b700000041828ULL,
0x0000006a7090723cULL, 0x040b700000041890ULL, 0x00000064708c723cULL, 0x040b70000004188cULL,
0x00000066702c723cULL, 0x040b70000004182cULL, 0x000000607030723cULL, 0x040b700000041830ULL,
0x000000627034723cULL, 0x000b700000041834ULL, 0x0000006c5c38723cULL, 0x040b700000041838ULL,
0x0000006e5c3c723cULL, 0x040b70000004183cULL, 0x000000685c40723cULL, 0x040b700000041840ULL,
0x0000006a5c44723cULL, 0x040b700000041844ULL, 0x000000645c48723cULL, 0x040b700000041848ULL,
0x000000665c4c723cULL, 0x040b70000004184cULL, 0x000000605c50723cULL, 0x040b700000041850ULL,
0x000000625c54723cULL, 0x000b620000041854ULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff6f7819ULL, 0x020fe2000001161fULL, 0x000000ffff637224ULL, 0x000fe200078e00ffULL,
0x000000c01a627812ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fe200078e0209ULL,
0x000000086f6b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001205d7824ULL, 0x000fe200078e026fULL,
0x000000106f717810ULL, 0x000fc40007ffe0ffULL, 0x000000186f737810ULL, 0x040fe20007ffe0ffULL,
0x00000001205f7824ULL, 0x000fe200078e026bULL, 0x000000286f777810ULL, 0x000fe20007ffe0ffULL,
0x000001005d5c7825ULL, 0x100fe200078e0062ULL, 0x000000206f757810ULL, 0x040fe40007ffe0ffULL,
0x000000306f797810ULL, 0x000fe20007ffe0ffULL, 0x000001005f5e7825ULL, 0x000fe200078e0062ULL,
0x0000005c98667210ULL, 0x000fc60007f1e0ffULL, 0x0000000120617824ULL, 0x000fe200078e0271ULL,
0x0000005e98687210ULL, 0x000fe20007f3e0ffULL, 0x0000000199677824ULL, 0x000fe200000e065dULL,
0x0000001b945e7217ULL, 0x000fe20007800000ULL, 0x00000100615c7825ULL, 0x000fc800078e0062ULL,
0x0000000199697824ULL, 0x000fe200008e065fULL, 0x0000005c985c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001205f7824ULL, 0x000fe400078e0273ULL, 0x000000015e6c7824ULL, 0x000fe400078e0a1bULL,
0x000001005f5e7825ULL, 0x000fc600078e0062ULL, 0x0000006c6b00720cULL, 0x080fe20003f66070ULL,
0x0000000120657824ULL, 0x000fe200078e0277ULL, 0x0000006c6f00720cULL, 0x000fe20003f46070ULL,
0x00000001995d7824ULL, 0x000fe200000e065dULL, 0x0000005e985e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010065647825ULL, 0x000fe200078e0062ULL, 0x000000026b6b7819ULL, 0x000fe400000006ffULL,
0x000000386f6f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000120617824ULL, 0x000fe200078e0275ULL,
0x0000006c7100720cULL, 0x000fe20003fa6070ULL, 0x00000001995f7824ULL, 0x000fe200000e065fULL,
0x00000064986a7210ULL, 0x040fe20007f1e0ffULL, 0x0000010061607825ULL, 0x000fe200078e0062ULL,
0xfffffffc6b647812ULL, 0x000fe200078ee20cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000660b7faeULL, 0x0003e2000d101c46ULL, 0x0000006c7300720cULL, 0x000fe20003f86070ULL,
0x00000001996b7824ULL, 0x000fe200000e0665ULL, 0x0000006098607210ULL, 0x000fe20007f3e0ffULL,
0x00000010646d7824ULL, 0x000fe200078e0209ULL, 0x0000006c7700720cULL, 0x080fe20003f46070ULL,
0x0000000120657824ULL, 0x000fe200078e0279ULL, 0x0000006c6f00720cULL, 0x080fe20003f06070ULL,
0x0000000471717824ULL, 0x000fe200078e00ffULL, 0x00000000686d7faeULL, 0x0005e2000d901c46ULL,
0x0000010065647825ULL, 0x000fe200078e0062ULL, 0x0000006c7500720cULL, 0x000fc40003f66070ULL,
0xfffffffc71667812ULL, 0x102fe200078ee20cULL, 0x00000001207b7824ULL, 0x000fe200078e026fULL,
0x0000006498647210ULL, 0x000fe20007fde0ffULL, 0x0000000473737824ULL, 0x000fe400078e00ffULL,
0x0000000199617824ULL, 0x000fe200008e0661ULL, 0x0000006c7900720cULL, 0x000fe20003f26070ULL,
0x0000000475757824ULL, 0x000fe200078e00ffULL, 0xfffffffc73687812ULL, 0x104fe200078ee20cULL,
0x0000000477777824ULL, 0x000fe400078e00ffULL, 0x0000000479797824ULL, 0x000fe200078e00ffULL,
0xfffffffc756c7812ULL, 0x000fe200078ee20cULL, 0x000001007b627825ULL, 0x000fe200078e0062ULL,
0xfffffffc776e7812ULL, 0x000fc400078ee20cULL, 0xfffffffc79707812ULL, 0x100fe200078ee20cULL,
0x000000046f6f7824ULL, 0x000fe400078e00ffULL, 0x0000000199657824ULL, 0x000fe200030e0665ULL,
0x0000006298627210ULL, 0x000fe20007fde0ffULL, 0x00000010660b7824ULL, 0x100fe200078e0209ULL,
0xfffffffc6f727812ULL, 0x000fe200078ee20cULL, 0x0000001068677824ULL, 0x100fe400078e0209ULL,
0x000000106c697824ULL, 0x100fe200078e0209ULL, 0x000000005c0b7faeULL, 0x0003e2000e901c46ULL,
0x000000106e6d7824ULL, 0x000fc400078e0209ULL, 0x00000010706f7824ULL, 0x100fe200078e0209ULL,
0x000000005e677faeULL, 0x0003e2000e101c46ULL, 0x0000001072097824ULL, 0x000fe400078e0209ULL,
0x0000000199637824ULL, 0x000fe200030e0663ULL, 0x0000000060697faeULL, 0x0003e8000d901c46ULL,
0x000000006a6d7faeULL, 0x0003e8000d101c46ULL, 0x00000000646f7faeULL, 0x0003e8000c901c46ULL,
0x0000000062097faeULL, 0x0003e2000c101c46ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x000000081f6d7811ULL, 0x060fe200078ff0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x000000101f6f7811ULL, 0x000fc400078ff0ffULL, 0x000000181f717811ULL, 0x040fe400078ff0ffULL,
0x000000c01a6a7812ULL, 0x000fe200078efcffULL, 0x0000000120677824ULL, 0x040fe200078e026fULL,
0x000000201f637211ULL, 0x040fe200078ff0ffULL, 0x0000000120697824ULL, 0x040fe200078e0271ULL,
0x000000201f737811ULL, 0x000fe200078ff0ffULL, 0x0000010067667825ULL, 0x100fe200078e006aULL,
0x0000006d20657210ULL, 0x000fe40007ffe0ffULL, 0x000000281f757811ULL, 0x000fe200078ff0ffULL,
0x0000010063627825ULL, 0x000fe200078e006aULL, 0x000000301f797811ULL, 0x000fc400078ff0ffULL,
0x000000381f7b7811ULL, 0x000fe200078ff0ffULL, 0x00000001205d7824ULL, 0x000fe200078e0273ULL,
0x0000006298627210ULL, 0x040fe20007f1e0ffULL, 0x0000010065647825ULL, 0x000fe200078e006aULL,
0x0000006698667210ULL, 0x000fc60007f5e0ffULL, 0x00000001205f7824ULL, 0x000fe200078e0275ULL,
0x0000006498647210ULL, 0x000fe20007f3e0ffULL, 0x0000010069687825ULL, 0x000fc600078e006aULL,
0x0000006599657210ULL, 0x000fe20000ffe4ffULL, 0x000000046d6d7824ULL, 0x000fe200078e00ffULL,
0x0000006898687210ULL, 0x000fe20007f7e0ffULL, 0x0000000120617824ULL, 0x040fe400078e0279ULL,
0x000000046f6f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc6d6c7812ULL, 0x100fe200078ee20cULL,
0x0000000120777824ULL, 0x000fe400078e027bULL, 0x0000000471717824ULL, 0x000fe200078e00ffULL,
0xfffffffc6f6e7812ULL, 0x000fe200078ee20cULL, 0x000001005d5c7825ULL, 0x000fc600078e006aULL,
0xfffffffc71707812ULL, 0x000fe200078ee20cULL, 0x0000000473737824ULL, 0x000fe400078e00ffULL,
0x000001005f5e7825ULL, 0x000fc600078e006aULL, 0xfffffffc73727812ULL, 0x000fe200078ee20cULL,
0x0000000475757824ULL, 0x000fe200078e00ffULL, 0x0000005e985e7210ULL, 0x000fe20007f3e0ffULL,
0x0000010061607825ULL, 0x000fc600078e006aULL, 0xfffffffc75747812ULL, 0x000fe200078ee20cULL,
0x0000000479797824ULL, 0x000fe400078e00ffULL, 0x00000100776a7825ULL, 0x000fc600078e006aULL,
0xfffffffc79767812ULL, 0x100fe200078ee20cULL, 0x000000047b7b7824ULL, 0x000fe400078e00ffULL,
0x0000000199637824ULL, 0x000fe200000e0663ULL, 0x0000005c985c7210ULL, 0x040fe20007f1e0ffULL,
0x000000100b777824ULL, 0x000fe200078e0209ULL, 0xfffffffc7b787812ULL, 0x000fe200078ee20cULL,
0x0000000199677824ULL, 0x040fe200010e0667ULL, 0x0000006098607210ULL, 0x000fe20007f5e0ffULL,
0x000000106c0b7824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062777faeULL, 0x0003e2000b901c46ULL, 0x0000000199697824ULL, 0x000fe200018e0669ULL,
0x0000006a986a7210ULL, 0x000fe20007f7e0ffULL, 0x000000106e6d7824ULL, 0x100fe200078e0209ULL,
0x00000000640b7faeULL, 0x0003e2000b901c46ULL, 0x00000010706f7824ULL, 0x000fc400078e0209ULL,
0x0000001072717824ULL, 0x000fe200078e0209ULL, 0x00000000666d7faeULL, 0x0003e2000b901c46ULL,
0x00000001995d7824ULL, 0x040fe400000e065dULL, 0x0000001074737824ULL, 0x000fe200078e0209ULL,
0x00000000686f7faeULL, 0x0003e2000b901c46ULL, 0x00000001995f7824ULL, 0x040fe400008e065fULL,
0x0000001076757824ULL, 0x000fe200078e0209ULL, 0x000000005c717faeULL, 0x0003e2000b901c46ULL,
0x0000000199617824ULL, 0x000fc400010e0661ULL, 0x0000001078097824ULL, 0x000fe200078e0209ULL,
0x000000005e737faeULL, 0x0003e2000b901c46ULL, 0x00000001996b7824ULL, 0x000fc600018e066bULL,
0x0000000060757faeULL, 0x0003e8000b901c46ULL, 0x000000006a097faeULL, 0x0003e4000b901c46ULL,
0x0000000421217810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000232100720cULL, 0x000fda0003f06070ULL,
0x00000002a3648824ULL, 0x000fe400078e0221ULL, 0x00000004ff658424ULL, 0x000fc800078e00ffULL,
0x0000660064648625ULL, 0x000fe200078e0065ULL, 0x00000008155c7810ULL, 0x000fe40007ffe0ffULL,
0x00000008180b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010165d7824ULL, 0x000fe200078e00ffULL,
0x0000000664098981ULL, 0x0002a2000c1e1900ULL, 0x00000010195e7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff05d687812ULL, 0x000fe200078ee25cULL,
0x000000001170783bULL, 0x000fe20000000200ULL, 0xfffffff05e0b7812ULL, 0x000fe200078ee20bULL,
0x0000001019757824ULL, 0x000fe200078e00ffULL, 0x0000000a18747810ULL, 0x000fe20007ffe0ffULL,
0x00000010686c7824ULL, 0x000fe200078e00ffULL, 0x00000000145c783bULL, 0x0007e20000000200ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff075747812ULL, 0x000fe400078ee274ULL,
0x000000001364783bULL, 0x002fe20000000200ULL, 0x0000000a15757810ULL, 0x000fc40007ffe0ffULL,
0x0000001074747824ULL, 0x000fe200078e00ffULL, 0x000000000b60783bULL, 0x0003220000000200ULL,
0x0000001016147824ULL, 0x008fc600078e00ffULL, 0x000000001268783bULL, 0x000ee80000000200ULL,
0x000000006c6c783bULL, 0x000ee20000000200ULL, 0xfffffff0140b7812ULL, 0x002fc600078ee275ULL,
0x000000001010783bULL, 0x000fe40000000200ULL, 0x000000100b0b7824ULL, 0x000fe400078e00ffULL,
0x000000007474783bULL, 0x000e680000000200ULL, 0x000000000f78783bULL, 0x000e680000000200ULL,
0x000000000e7c783bULL, 0x000e680000000200ULL, 0x000000000d84783bULL, 0x000e680000000200ULL,
0x000000000b80783bULL, 0x0008640000000200ULL, 0x0000005c6058723cULL, 0x010f620000041858ULL,
0x00000300950b7a10ULL, 0x000fc80007ffe0ffULL, 0x000000010b0d7810ULL, 0x000fc60007ffe0ffULL,
0x0000005e6024723cULL, 0x000f620000041824ULL, 0x000000220d00720cULL, 0x000fce0003f06070ULL,
0x000000646028723cULL, 0x040f700000041828ULL, 0x000000666090723cULL, 0x040f700000041890ULL,
0x00000068608c723cULL, 0x048f70000004188cULL, 0x0000006a602c723cULL, 0x040f70000004182cULL,
0x000000706030723cULL, 0x040f700000041830ULL, 0x000000726034723cULL, 0x000f700000041834ULL,
0x0000005c6c38723cULL, 0x040f700000041838ULL, 0x0000005e6c3c723cULL, 0x040f70000004183cULL,
0x000000646c40723cULL, 0x040f700000041840ULL, 0x000000666c44723cULL, 0x040f700000041844ULL,
0x000000686c48723cULL, 0x040f700000041848ULL, 0x0000006a6c4c723cULL, 0x040f70000004184cULL,
0x000000706c50723cULL, 0x040f700000041850ULL, 0x000000726c54723cULL, 0x000f700000041854ULL,
0x000000107458723cULL, 0x062b700000041858ULL, 0x000000127424723cULL, 0x040b700000041824ULL,
0x000000787428723cULL, 0x040b700000041828ULL, 0x0000007a7490723cULL, 0x040b700000041890ULL,
0x0000007c748c723cULL, 0x040b70000004188cULL, 0x0000007e742c723cULL, 0x040b70000004182cULL,
0x000000847430723cULL, 0x040b700000041830ULL, 0x000000867434723cULL, 0x000b700000041834ULL,
0x000000108038723cULL, 0x040b700000041838ULL, 0x00000012803c723cULL, 0x040b70000004183cULL,
0x000000788040723cULL, 0x040b700000041840ULL, 0x0000007a8044723cULL, 0x040b700000041844ULL,
0x0000007c8048723cULL, 0x040b700000041848ULL, 0x0000007e804c723cULL, 0x000b62000004184cULL,
0x000000a0090f7224ULL, 0x004fce00078e02ffULL, 0x000000848050723cULL, 0x000b620000041850ULL,
0x000064000f0e7625ULL, 0x000fce00078e00a2ULL, 0x000000868054723cULL, 0x000b620000041854ULL,
0x000005c000008947ULL, 0x000fce0003800000ULL, 0x00000002ff147819ULL, 0x000fe2000001161fULL,
0x000001000b0d7824ULL, 0x000fc600078e02a1ULL, 0x0000001014647810ULL, 0x000fe20007ffe0ffULL,
0x0000000120107824ULL, 0x020fe200078e0214ULL, 0x0000000814627810ULL, 0x000fe40007ffe0ffULL,
0x0000000d94127217ULL, 0x000fe20007800000ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000002014687810ULL, 0x040fe40007ffe0ffULL, 0x0000001814667810ULL, 0x000fe20007ffe0ffULL,
0x00000001205c7824ULL, 0x000fe200078e0264ULL, 0x0000001a105f7212ULL, 0x000fe200078efcffULL,
0x0000000120137824ULL, 0x040fe200078e0262ULL, 0x00000066205e7210ULL, 0x000fe20007ffe0ffULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x0000005f0e107210ULL, 0x000fc40007f1e0ffULL,
0x0000002814697810ULL, 0x000fe20007ffe0ffULL, 0x00000001120d7824ULL, 0x000fe200078e0a0dULL,
0x0000001a5c5f7212ULL, 0x080fe200078efcffULL, 0x0000010013127825ULL, 0x000fe200078e00ffULL,
0x00000030146a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000d6400720cULL, 0x000fe20003fa6070ULL,
0x0000000111117824ULL, 0x000fe200000e060fULL, 0x0000001a12617212ULL, 0x000fe200078efcffULL,
0x0000000120607824ULL, 0x000fe200078e0268ULL, 0x0000005f0e5c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000462677824ULL, 0x000fe200078e00ffULL, 0x000000610e127210ULL, 0x000fe20007f3e0ffULL,
0x0000010060607825ULL, 0x000fe200078e00ffULL, 0x0000000d6600720cULL, 0x000fc60003f86070ULL,
0x000000015d5d7824ULL, 0x100fe200000e060fULL, 0x0000000d1400720cULL, 0x080fe20003f06070ULL,
0x000001005e5e7825ULL, 0x000fe200078e00ffULL, 0x0000001a60637212ULL, 0x080fe400078efcffULL,
0x0000003814147810ULL, 0x000fe20007ffe0ffULL, 0x0000000113137824ULL, 0x000fe200008e060fULL,
0x0000000d6200720cULL, 0x000fe40003f26070ULL, 0xfffffffc67627812ULL, 0x000fe200078ee20cULL,
0x00000004146b7824ULL, 0x000fe200078e00ffULL, 0x0000001a5e657212ULL, 0x000fc400078efcffULL,
0x000000630e607210ULL, 0x000fe20007f7e0ffULL, 0x0000000120637824ULL, 0x000fe200078e0269ULL,
0x000000650e5e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001062677824ULL, 0x000fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100a7faeULL, 0x0003e2000c101c46ULL,
0x0000010063627825ULL, 0x000fe200078e00ffULL, 0x0000000d1400720cULL, 0x080fe40003f06070ULL,
0x0000000012677faeULL, 0x0005e2000c901c46ULL, 0x000000015f5f7824ULL, 0x100fe200010e060fULL,
0x0000000d6900720cULL, 0x080fe20003f46070ULL, 0x0000000161617824ULL, 0x000fe200018e060fULL,
0x0000000d6800720cULL, 0x080fe20003f66070ULL, 0x0000000469697824ULL, 0x000fe200078e00ffULL,
0x0000000d6a00720cULL, 0x000fe20003f26070ULL, 0x00000004640d7824ULL, 0x000fe200078e00ffULL,
0x0000001a62657212ULL, 0x000fe200078efcffULL, 0x0000000120107824ULL, 0x002fc400078e026aULL,
0x0000000466137824ULL, 0x004fe200078e00ffULL, 0x000000650e627210ULL, 0x000fe20007fde0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffffc0d0a7812ULL, 0x100fe400078ee20cULL,
0xfffffffc69667812ULL, 0x000fe200078ee20cULL, 0x0000000120127824ULL, 0x000fe200078e0214ULL,
0x0000001a100d7212ULL, 0x000fe200078efcffULL, 0x0000000468657824ULL, 0x000fe200078e00ffULL,
0xfffffffc13147812ULL, 0x000fe200078ee20cULL, 0x0000010012127825ULL, 0x000fc600078e00ffULL,
0xfffffffc65647812ULL, 0x100fe200078ee20cULL, 0x0000000163637824ULL, 0x000fe200030e060fULL,
0x0000000d0e107210ULL, 0x000fe20007fde0ffULL, 0x000000046a677824ULL, 0x000fe200078e00ffULL,
0x0000001a120d7212ULL, 0x000fe200078efcffULL, 0x000000100a657824ULL, 0x000fe200078e0217ULL,
0xfffffffc6b6a7812ULL, 0x100fe200078ee20cULL, 0x0000000111117824ULL, 0x000fe200030e060fULL,
0xfffffffc67687812ULL, 0x000fe200078ee20cULL, 0x0000001014677824ULL, 0x100fe200078e0217ULL,
0x0000000d0e0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001064697824ULL, 0x100fe200078e0217ULL,
0x00000017666b7211ULL, 0x000fe200078e20ffULL, 0x00000010686d7824ULL, 0x100fe200078e0217ULL,
0x000000005c657faeULL, 0x0003e2000e901c46ULL, 0x000000106a177824ULL, 0x000fc400078e0217ULL,
0x00000001130d7824ULL, 0x000fe200030e060fULL, 0x000000005e677faeULL, 0x0003e8000e101c46ULL,
0x0000000060697faeULL, 0x0003e8000d901c46ULL, 0x00000000626b7faeULL, 0x0003e8000d101c46ULL,
0x00000000106d7faeULL, 0x0003e8000c901c46ULL, 0x000000000c177faeULL, 0x0003e2000c101c46ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x000000081f0d7811ULL, 0x040fe400078ff0ffULL,
0x000000101f117811ULL, 0x020fc400078ff0ffULL, 0x000000201f107211ULL, 0x040fe200078ff0ffULL,
0x0000000120127824ULL, 0x040fe200078e020dULL, 0x000000181f137811ULL, 0x000fe200078ff0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0x000000201f617811ULL, 0x040fe200078ff0ffULL,
0x00000001205c7824ULL, 0x000fe200078e0211ULL, 0x000000281f637811ULL, 0x000fe200078ff0ffULL,
0x00000004115d7824ULL, 0x000fe200078e00ffULL, 0x000000301f657811ULL, 0x040fe200078ff0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000381f677811ULL, 0x000fc400078ff0ffULL,
0xfffffffc0d147812ULL, 0x100fe200078ee20cULL, 0x00000004135f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc5d5e7812ULL, 0x100fe200078ee20cULL, 0x0000000461697824ULL, 0x000fe200078e00ffULL,
0x0000001a100d7212ULL, 0x000fe200078efcffULL, 0x00000004636b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc5f627812ULL, 0x100fe200078ee20cULL, 0x00000004656d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc69647812ULL, 0x100fe200078ee20cULL, 0x00000004676f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc6b667812ULL, 0x100fe200078ee20cULL, 0x0000000120607824ULL, 0x000fe200078e0213ULL,
0xfffffffc6d687812ULL, 0x100fe200078ee20cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0xfffffffc6f6a7812ULL, 0x000fc400078ee20cULL, 0x0000000d0e0c7210ULL, 0x000fe20007f1e0ffULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x0000001a120d7212ULL, 0x000fc600078efcffULL,
0x000000105e6b7824ULL, 0x000fe200078e0217ULL, 0x0000001a5c5f7212ULL, 0x000fe200078efcffULL,
0x0000000120617824ULL, 0x000fe200078e0261ULL, 0x0000000d0e107210ULL, 0x040fe20007f3e0ffULL,
0x00000001110d7824ULL, 0x000fe200000e060fULL, 0x0000005f0e127210ULL, 0x000fe20007f5e0ffULL,
0x00000100605e7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0a7faeULL, 0x0003e2000b901c46ULL, 0x0000000113117824ULL, 0x000fe200008e060fULL,
0x0000000f5d137210ULL, 0x000fe200017fe4ffULL, 0x0000000120637824ULL, 0x000fe200078e0263ULL,
0x0000001a5e5d7212ULL, 0x000fe200078efcffULL, 0x0000000120657824ULL, 0x040fe400078e0265ULL,
0x0000000120677824ULL, 0x000fe200078e0267ULL, 0x0000005d0e5c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010626d7824ULL, 0x000fe400078e0217ULL, 0x0000010061607825ULL, 0x000fc800078e00ffULL,
0x00000010646f7824ULL, 0x000fe400078e0217ULL, 0x0000010063627825ULL, 0x000fc800078e00ffULL,
0x0000001066717824ULL, 0x000fe400078e0217ULL, 0x0000010065647825ULL, 0x000fc800078e00ffULL,
0x0000010067667825ULL, 0x000fe200078e00ffULL, 0x0000001a64737212ULL, 0x000fc600078efcffULL,
0x000000015f5d7824ULL, 0x000fe200000e060fULL, 0x0000001a605f7212ULL, 0x080fe200078efcffULL,
0x0000001014697824ULL, 0x100fe200078e0217ULL, 0x0000001a66777212ULL, 0x080fe200078efcffULL,
0x0000001068757824ULL, 0x100fe200078e0217ULL, 0x0000005f0e5e7210ULL, 0x000fe20007f1e0ffULL,
0x000000106a797824ULL, 0x000fe200078e0217ULL, 0x0000001a62177212ULL, 0x000fe200078efcffULL,
0x0000000010697faeULL, 0x0003e2000b901c46ULL, 0x000000730e627210ULL, 0x040fe20007f5e0ffULL,
0x00000001615f7824ULL, 0x000fe200000e060fULL, 0x000000170e607210ULL, 0x040fe20007f3e0ffULL,
0x00000000126b7faeULL, 0x0003e2000b901c46ULL, 0x000000770e0e7210ULL, 0x000fc60007f7e0ffULL,
0x0000000163617824ULL, 0x100fe200008e060fULL, 0x000000005c6d7faeULL, 0x0003e2000b901c46ULL,
0x0000000165637824ULL, 0x100fe400010e060fULL, 0x00000001670f7824ULL, 0x000fe200018e060fULL,
0x000000005e6f7faeULL, 0x0003e8000b901c46ULL, 0x0000000060717faeULL, 0x0003e8000b901c46ULL,
0x0000000062757faeULL, 0x0003e8000b901c46ULL, 0x000000000e797faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001016177824ULL, 0x002fe200078e00ffULL,
0x0000000c15147810ULL, 0x000fe20007ffe0ffULL, 0x00000010190d7824ULL, 0x000fe200078e00ffULL,
0x0000000c180a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001016167824ULL, 0x000fe200078e00ffULL,
0xfffffff017147812ULL, 0x000fe200078ee214ULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0a7812ULL, 0x000fc400078ee20aULL, 0x0000000e15157810ULL, 0x000fe20007ffe0ffULL,
0x0000001014647824ULL, 0x000fe200078e00ffULL, 0x0000000e18187810ULL, 0x000fe20007ffe0ffULL,
0x000000100a0a7824ULL, 0x000fc600078e00ffULL, 0xfffffff019187812ULL, 0x000fca00078ee218ULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000080c783bULL, 0x000fe80000000200ULL, 0x000000006464783bULL, 0x000e680000000200ULL,
0x000000000a10783bULL, 0x000ea80000000200ULL, 0x00000000075c783bULL, 0x0007e80000000200ULL,
0x000000000660783bULL, 0x000f280000000200ULL, 0x000000000568783bULL, 0x000ea20000000200ULL,
0xfffffff016077812ULL, 0x008fc600078ee215ULL, 0x00000000046c783bULL, 0x000fe40000000200ULL,
0x0000001007077824ULL, 0x000fe400078e00ffULL, 0x000000001870783bULL, 0x000fe80000000200ULL,
0x000000000778783bULL, 0x0006e80000000200ULL, 0x000000000314783bULL, 0x000fe80000000200ULL,
0x000000000274783bULL, 0x000ee80000000200ULL, 0x00000000007c783bULL, 0x0004e20000000200ULL,
0x0000000c6438723cULL, 0x042f700000041838ULL, 0x0000000e643c723cULL, 0x080f70000004183cULL,
0x0000000e1024723cULL, 0x044f700000041824ULL, 0x00000062102c723cULL, 0x010f70000004182cULL,
0x0000005c6440723cULL, 0x000ff00000041840ULL, 0x00000060108c723cULL, 0x000ff0000004188cULL,
0x0000005e6444723cULL, 0x040ff00000041844ULL, 0x000000606448723cULL, 0x000ff00000041848ULL,
0x0000005c1028723cULL, 0x040ff00000041828ULL, 0x000000681030723cULL, 0x000ff00000041830ULL,
0x00000062644c723cULL, 0x040ff0000004184cULL, 0x000000686404723cULL, 0x008ff00000041850ULL,
0x0000000c1058723cULL, 0x040ff00000041858ULL, 0x0000005e1090723cULL, 0x040ff00000041890ULL,
0x0000006a1034723cULL, 0x080ff00000041834ULL, 0x0000006a6454723cULL, 0x000ff00000041854ULL,
0x0000006c7838723cULL, 0x060f700000041838ULL, 0x0000006e783c723cULL, 0x080f70000004183cULL,
0x0000006e7024723cULL, 0x040f700000041824ULL, 0x00000076702c723cULL, 0x000f64000004182cULL,
0x3db504f338387820ULL, 0x020fcc0000410000ULL, 0x000000147840723cULL, 0x000f620000041840ULL,
0x3db504f33e507820ULL, 0x000fe20000410000ULL, 0x3db504f33f517820ULL, 0x000fcc0000410000ULL,
0x00000074708c723cULL, 0x000f62000004188cULL, 0x3db504f3240a7820ULL, 0x000fe20000410000ULL,
0x3db504f3250c7820ULL, 0x000fe20000410000ULL, 0x3db504f326247820ULL, 0x000fe20000410000ULL,
0x3db504f327257820ULL, 0x000fc80000410000ULL, 0x000000167844723cULL, 0x000f620000041844ULL,
0x3db504f32c137820ULL, 0x000fe20000410000ULL, 0x3db504f32e2e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f007820ULL, 0x000fca0000410000ULL, 0x000000747848723cULL, 0x000f640000041848ULL,
0x3db504f3432c7820ULL, 0x020fcc0000410000ULL, 0x000000147028723cULL, 0x000b620000041828ULL,
0x3db504f38c117820ULL, 0x000fe20000410000ULL, 0x3db504f38d127820ULL, 0x000fe20000410000ULL,
0x3db504f38f8f7820ULL, 0x000fc80000410000ULL, 0x3db504f32d147820ULL, 0x020fe20000410000ULL,
0x0000007c7030723cULL, 0x000f620000041830ULL, 0x3db504f345437820ULL, 0x000fe20000410000ULL,
0x3db504f3463e7820ULL, 0x000fe20000410000ULL, 0x3db504f3473f7820ULL, 0x000fca0000410000ULL,
0x000000767874723cULL, 0x000b62000004184cULL, 0x3db504f34b2d7820ULL, 0x000fe20000410000ULL,
0x3db504f349457820ULL, 0x000fca0000410000ULL, 0x3db504f33b4d7820ULL, 0x020fe20000410000ULL,
0x0000007c7804723cULL, 0x000f620000041804ULL, 0x3db504f33c3b7820ULL, 0x000fe20000410000ULL,
0x3db504f33d3c7820ULL, 0x000fe20000410000ULL, 0x3db504f3403d7820ULL, 0x000fe20000410000ULL,
0x3db504f3424f7820ULL, 0x000fe20000410000ULL, 0x3db504f341407820ULL, 0x000fe20000410000ULL,
0x3db504f344427820ULL, 0x000fe20000410000ULL, 0x3db504f3280d7820ULL, 0x000fe20000410000ULL,
0x0000006c7058723cULL, 0x040f620000041858ULL, 0x3db504f3290e7820ULL, 0x000fe20000410000ULL,
0x3db504f32a267820ULL, 0x000fe20000410000ULL, 0x3db504f32b277820ULL, 0x000fe20000410000ULL,
0x3db504f348447820ULL, 0x000fe20000410000ULL, 0x3db504f34a417820ULL, 0x000fe20000410000ULL,
0x3db504f38e2b7820ULL, 0x000fe20000410000ULL, 0x3db504f330157820ULL, 0x000fe20000410000ULL,
0x000000167090723cULL, 0x040b620000041890ULL, 0x3db504f332027820ULL, 0x000fe20000410000ULL,
0x3db504f333337820ULL, 0x000fe20000410000ULL, 0x3db504f3392a7820ULL, 0x000fe20000410000ULL,
0x3db504f33a4e7820ULL, 0x000fe20000410000ULL, 0x3db504f374467820ULL, 0x000fe20000410000ULL,
0x3db504f375477820ULL, 0x000fe20000410000ULL, 0x3db504f331167820ULL, 0x020fe20000410000ULL,
0x0000007e7034723cULL, 0x000f620000041834ULL, 0x3db504f376767820ULL, 0x000fe20000410000ULL,
0x3db504f377777820ULL, 0x000fe20000410000ULL, 0x3db504f304487820ULL, 0x000fe20000410000ULL,
0x3db504f3054a7820ULL, 0x000fe20000410000ULL, 0x3db504f306067820ULL, 0x000fe20000410000ULL,
0x3db504f307317820ULL, 0x000fc40000410000ULL, 0x0000007e7878723cULL, 0x000f620000041854ULL,
0x3db504f358037820ULL, 0x000fe20000410000ULL, 0x3db504f359087820ULL, 0x000fe20000410000ULL,
0x3db504f35a1a7820ULL, 0x000fe20000410000ULL, 0x3db504f35b197820ULL, 0x000fc80000410000ULL,
0x3db504f3900f7820ULL, 0x000fe20000410000ULL, 0x3db504f391107820ULL, 0x000fe20000410000ULL,
0x3db504f392287820ULL, 0x000fe20000410000ULL, 0x3db504f393297820ULL, 0x000fca0000410000ULL,
0x3db504f334177820ULL, 0x020fe20000410000ULL, 0x3db504f335187820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f337377820ULL, 0x000fca0000410000ULL,
0x3db504f3784b7820ULL, 0x000fe20000410000ULL, 0x3db504f3794c7820ULL, 0x000fe20000410000ULL,
0x3db504f37a7a7820ULL, 0x000fe20000410000ULL, 0x3db504f37b7b7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000009d527f8cULL, 0x0002a2000c80043fULL,
0x0000003700397202ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe400078e002eULL,
0x000000ffff357224ULL, 0x000fe400078e0033ULL, 0x000000ffff377224ULL, 0x000fc400078e0038ULL,
0x000000ffff3a7224ULL, 0x000fe400078e002aULL, 0x000000ffff497224ULL, 0x000fe400078e002cULL,
0x000000ffff2f7224ULL, 0x000fe400078e008fULL, 0x000000ffff327224ULL, 0x000fe400078e0000ULL,
0x000000ffff347224ULL, 0x000fe400078e0002ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0076ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0077ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff337224ULL, 0x000fe400078e007aULL, 0x000000ffff387224ULL, 0x000fc400078e007bULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004009d077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604557210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09005500780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c405500780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000005500007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000102027810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004009d077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000041f027824ULL, 0x000fe200078e00ffULL,
0x0000009c9500720cULL, 0x000fc80003f06070ULL, 0xfffffff002057812ULL, 0x000fca00078ec0ffULL,
0x000000809a007824ULL, 0x000fca00078e0205ULL, 0x0164000000047984ULL, 0x0002a20000000c00ULL,
0x000021e000008947ULL, 0x000fea0003800000ULL, 0x00005a0000567b06ULL, 0x000ee20000209000ULL,
0x000000ffff527224ULL, 0x000fe200078e00ffULL, 0x0000009e1f547211ULL, 0x000fe400078ff0ffULL,
0x00005a00ff5d7a12ULL, 0x000fe400078e33ffULL, 0x0000001054577810ULL, 0x000fe40007ffe0ffULL,
0x0000005600567308ULL, 0x008ee40000001000ULL, 0x0ffffffe56587810ULL, 0x008fcc0007ffe0ffULL,
0x0000005800537305ULL, 0x000ee4000021f000ULL, 0x000000ffff557224ULL, 0x008fc800078e0a53ULL,
0x00005a0055557a24ULL, 0x000fc800078e02ffULL, 0x00000055535b7227ULL, 0x000fe200078e0052ULL,
0x0000000854537810ULL, 0x000fca0007ffe0ffULL, 0x000000535b557227ULL, 0x000fc800078e00ffULL,
0x000000545b527227ULL, 0x000fc800078e00ffULL, 0x000000ffff567224ULL, 0x000fe400078e0a55ULL,
0x000000ffff597224ULL, 0x000fe400078e0a52ULL, 0x00005a0056567a24ULL, 0x000fe400078e0253ULL,
0x00005a0059537a24ULL, 0x000fe200078e0254ULL, 0x0000001854547810ULL, 0x000fe20007ffe0ffULL,
0x000000575b587227ULL, 0x000fe200078e00ffULL, 0x00005a0056007a0cULL, 0x000fe40003fa6070ULL,
0x00005a0053007a0cULL, 0x000fe20003f06070ULL, 0x000000545b597227ULL, 0x000fc800078e00ffULL,
0x000000ffff5a7224ULL, 0x000fe400078e0a58ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0a59ULL,
0x00005a005a577a24ULL, 0x000fe200078e0257ULL, 0x0000001b945a7217ULL, 0x000fe20007800000ULL,
0x00005a005b5b7a24ULL, 0x000fe200078e0254ULL, 0x80005a0056565a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0057007a0cULL, 0x000fe20003f26070ULL, 0x000000015a1b7824ULL, 0x000fe200078e0a1bULL,
0x80005a0053530a10ULL, 0x000fe20007ffe0ffULL, 0x000000021f5a7824ULL, 0x000fe200078e00ffULL,
0x00005a005b007a0cULL, 0x000fc40003f66070ULL, 0x00005a0053007a0cULL, 0x000fe40003f46070ULL,
0x000000065a5a7812ULL, 0x000fe400078ec0ffULL, 0x00005a0056007a0cULL, 0x000fe40003fc6070ULL,
0x0000000152520810ULL, 0x000fe20007ffe0ffULL, 0x000000015a5c7824ULL, 0x000fe200078e029bULL,
0x80005a0057571a10ULL, 0x000fe40007ffe0ffULL, 0x0000005a1c567210ULL, 0x000fe20007ffe0ffULL,
0x000000015c547824ULL, 0x000fe200078e0a1bULL, 0x0000000155555810ULL, 0x000fc40007ffe0ffULL,
0x80005a005b5b3a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0057007a0cULL, 0x000fe40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x0000000152522810ULL, 0x000fe40007ffe0ffULL,
0x0000001b5600720cULL, 0x040fe20003f06070ULL, 0x0000000156567824ULL, 0x000fe200078e0a1bULL,
0x00005a005b007a0cULL, 0x000fc40003f46070ULL, 0x000000525d527207ULL, 0x000fe40006800000ULL,
0x000000561d567217ULL, 0x000fe40003800000ULL, 0x0000000155556810ULL, 0x000fe40007ffe0ffULL,
0x000000521d537217ULL, 0x040fe40003800000ULL, 0x0000001b5c00720cULL, 0x000fe40003fc6070ULL,
0x000000541d547217ULL, 0x000fe20003800000ULL, 0x000000531e827224ULL, 0x000fe200078e02ffULL,
0x0000000158581810ULL, 0x000fc40007ffe0ffULL, 0x00000004ff567819ULL, 0x000fe40000011656ULL,
0x0000000159593810ULL, 0x000fe40007ffe0ffULL, 0x000000ff546b7207ULL, 0x000fe40003000000ULL,
0x0000000158584810ULL, 0x000fe40007ffe0ffULL, 0x000000555d547207ULL, 0x000fe40006800000ULL,
0x000000ff56557207ULL, 0x000fc40000000000ULL, 0x0000000159592810ULL, 0x000fe40007ffe0ffULL,
0x000000585d587207ULL, 0x000fe20006800000ULL, 0x0000000182537824ULL, 0x000fe200078e0255ULL,
0x000000541d577217ULL, 0x000fe40003800000ULL, 0x000000826b5f7211ULL, 0x000fe200078fe0ffULL,
0x0000000253527825ULL, 0x100fe200078e0096ULL, 0x000000595d547207ULL, 0x000fe40006800000ULL,
0x000000581d597217ULL, 0x040fe20003800000ULL, 0x000000571e867224ULL, 0x000fe200078e02ffULL,
0x000000541d5d7217ULL, 0x000fe20003800000ULL, 0x000000025f5e7825ULL, 0x000fe200078e0096ULL,
0x000000105a6a7812ULL, 0x000fe200078efcffULL, 0x00000006525b7981ULL, 0x000724000c1e9500ULL,
0x000000591e887224ULL, 0x000fc400078e02ffULL, 0x0000000155577824ULL, 0x000fe200078e0286ULL,
0x000000065e5e7981ULL, 0x000322000c1e9500ULL, 0x0000005d1e8a7224ULL, 0x000fe200078e02ffULL,
0x000000886b637211ULL, 0x000fe200078fe0ffULL, 0x0000000257567825ULL, 0x000fe200078e0096ULL,
0x000000866b597211ULL, 0x000fc600078fe0ffULL, 0x0000000155617824ULL, 0x040fe200078e0288ULL,
0x00000006565d7981ULL, 0x000522000c1e9500ULL, 0x000000011c647824ULL, 0x000fe400078e026aULL,
0x0000000155657824ULL, 0x000fe400078e028aULL, 0x0000000263627825ULL, 0x000fc800078e0096ULL,
0x0000000259547825ULL, 0x100fe400078e0096ULL, 0x0000000662627981ULL, 0x000324000c1e9500ULL,
0x0000000261527825ULL, 0x008fe400078e0096ULL, 0x0000000654607981ULL, 0x000724000c1e9500ULL,
0x0000000164567824ULL, 0x004fe400078e0a1bULL, 0x000000016a687824ULL, 0x000fe200078e029bULL,
0x00000006525f7981ULL, 0x0022a4000c1e9500ULL, 0x000000561d577217ULL, 0x000fe20003800000ULL,
0x0000000168567824ULL, 0x000fe200078e0a1bULL, 0x0000008a6b6d7211ULL, 0x000fc400078fe0ffULL,
0x0000001b6400720cULL, 0x080fe40003f26070ULL, 0x00000004ff577819ULL, 0x000fe20000011657ULL,
0x000000026d6c7825ULL, 0x100fe200078e0096ULL, 0x0000001b6800720cULL, 0x000fe40003f06070ULL,
0x000000561d567217ULL, 0x000fe20003800000ULL, 0x0000000265587825ULL, 0x000fe200078e0096ULL,
0x000000ff57577207ULL, 0x000fe20000800000ULL, 0x000000066c6c7981ULL, 0x0002a2000c1e9500ULL,
0x000000ff56757207ULL, 0x000fc40000000000ULL, 0x000000205a747812ULL, 0x000fe200078efcffULL,
0x0000000658617981ULL, 0x0002a2000c1e9500ULL, 0x0000000157557824ULL, 0x008fe200078e0286ULL,
0x00000082756f7211ULL, 0x040fe400078fe0ffULL, 0x0000008675717211ULL, 0x000fe200078fe0ffULL,
0x0000000182537824ULL, 0x002fe400078e0257ULL, 0x0000000255547825ULL, 0x000fc800078e0096ULL,
0x000000011c587824ULL, 0x000fe200078e0274ULL, 0x0000000654697981ULL, 0x0002e2000c1e9500ULL,
0x000000026f6e7825ULL, 0x000fc800078e0096ULL, 0x0000000271707825ULL, 0x100fe200078e0096ULL,
0x0000008a75797211ULL, 0x000fe200078fe0ffULL, 0x000000066e6e7981ULL, 0x0002e4000c1e9500ULL,
0x0000000253527825ULL, 0x000fe400078e0096ULL, 0x0000000670707981ULL, 0x0002e4000c1e9500ULL,
0x0000000158547824ULL, 0x002fe400078e0a1bULL, 0x0000000174767824ULL, 0x000fe200078e029bULL,
0x0000000652637981ULL, 0x0002e2000c1e9500ULL, 0x0000008875737211ULL, 0x000fe200078fe0ffULL,
0x0000000157657824ULL, 0x000fe200078e028aULL, 0x000000541d557217ULL, 0x000fe20003800000ULL,
0x0000000176547824ULL, 0x000fc400078e0a1bULL, 0x0000000157597824ULL, 0x000fe400078e0288ULL,
0x0000000279787825ULL, 0x000fe200078e0096ULL, 0x0000001b5800720cULL, 0x000fc60003f26070ULL,
0x0000000265527825ULL, 0x002fe200078e0096ULL, 0x0000001b7600720cULL, 0x000fe20003f06070ULL,
0x0000000678787981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff557819ULL, 0x000fe20000011655ULL,
0x0000000273727825ULL, 0x100fe200078e0096ULL, 0x000000541d547217ULL, 0x000fe20003800000ULL,
0x00000006526f7981ULL, 0x0002e4000c1e9500ULL, 0x0000000259567825ULL, 0x000fe400078e0096ULL,
0x0000000672727981ULL, 0x0002e4000c1e9500ULL, 0x000000ff54797207ULL, 0x002fc40000000000ULL,
0x00000006566d7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff55537207ULL, 0x000fe40000800000ULL,
0x0000008679657211ULL, 0x000fc600078fe0ffULL, 0x0000000153677824ULL, 0x000fe400078e0286ULL,
0x0000000265647825ULL, 0x000fc800078e0096ULL, 0x0000000267667825ULL, 0x000fe200078e0096ULL,
0x00000006647c7981ULL, 0x0002e6000c1e9500ULL, 0x0000000182557824ULL, 0x000fe200078e0253ULL,
0x0000000666737981ULL, 0x0002e2000c1e9500ULL, 0x000000305a7e7812ULL, 0x000fe400078efcffULL,
0x00000082797b7211ULL, 0x000fe200078fe0ffULL, 0x0000000255547825ULL, 0x000fe200078e0096ULL,
0x0000008879577211ULL, 0x002fc400078fe0ffULL, 0x0000008a79777211ULL, 0x000fe200078fe0ffULL,
0x0000000153597824ULL, 0x040fe200078e0288ULL, 0x0000007e1c847210ULL, 0x000fe20007ffe0ffULL,
0x00000001537d7824ULL, 0x000fe200078e028aULL, 0x0000000654717981ULL, 0x0002e2000c1e9500ULL,
0x000000027b7a7825ULL, 0x000fc800078e0096ULL, 0x0000000257527825ULL, 0x100fe400078e0096ULL,
0x000000067a7a7981ULL, 0x0002e4000c1e9500ULL, 0x0000000259587825ULL, 0x100fe400078e0096ULL,
0x0000000652d67981ULL, 0x0002e4000c1e9500ULL, 0x000000027d547825ULL, 0x002fc800078e0096ULL,
0x0000000277567825ULL, 0x000fe200078e0096ULL, 0x0000000654877981ULL, 0x0002e6000c1e9500ULL,
0x0000000184667824ULL, 0x000fe200078e0a1bULL, 0x0000000658777981ULL, 0x0002e2000c1e9500ULL,
0x000000017e807824ULL, 0x000fc600078e029bULL, 0x0000000656da7981ULL, 0x0002e2000c1e9500ULL,
0x000000661d677217ULL, 0x040fe20003800000ULL, 0x0000000180667824ULL, 0x000fe200078e0a1bULL,
0x0000001b8400720cULL, 0x080fe40003f26070ULL, 0x0000001b8000720cULL, 0x000fe40003f06070ULL,
0x00000004ff677819ULL, 0x000fe40000011667ULL, 0x000000661d667217ULL, 0x000fe40003800000ULL,
0x000000ff677d7207ULL, 0x000fc40000800000ULL, 0x000000ff667b7207ULL, 0x000fc60000000000ULL,
0x0000000182657824ULL, 0x000fe200078e027dULL, 0x000000827b677211ULL, 0x000fe200078fe0ffULL,
0x000000017d577824ULL, 0x002fe200078e0288ULL, 0x000000887b597211ULL, 0x000fe200078fe0ffULL,
0x0000000265647825ULL, 0x000fc800078e0096ULL, 0x0000000267667825ULL, 0x100fe200078e0096ULL,
0x00000006647f7981ULL, 0x0002e6000c1e9500ULL, 0x0000000257567825ULL, 0x100fe200078e0096ULL,
0x0000000666be7981ULL, 0x0002e6000c1e9500ULL, 0x0000000259587825ULL, 0x000fe200078e0096ULL,
0x0000000656857981ULL, 0x0002e2000c1e9500ULL, 0x000000867b557211ULL, 0x000fc600078fe0ffULL,
0x0000000658d87981ULL, 0x0002e2000c1e9500ULL, 0x000000017d537824ULL, 0x000fe400078e0286ULL,
0x0000000255547825ULL, 0x000fc800078e0096ULL, 0x0000000253527825ULL, 0x000fe200078e0096ULL,
0x0000000654d47981ULL, 0x0002e4000c1e9500ULL, 0x0000008a7b657211ULL, 0x002fe400078fe0ffULL,
0x0000000652837981ULL, 0x0002e2000c1e9500ULL, 0x000000017d677824ULL, 0x000fe400078e028aULL,
0x0000000265647825ULL, 0x000fc800078e0096ULL, 0x0000000267667825ULL, 0x000fe200078e0096ULL,
0x0000000664dc7981ULL, 0x0002e8000c1e9500ULL, 0x0000000666897981ULL, 0x0002e4000c1e9500ULL,
0xfffffff06b527812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd27424ULL, 0x000fc800078e00ffULL,
0x000000011b537824ULL, 0x000fc800078e0252ULL, 0x000000015c527824ULL, 0x000fe200078e0a53ULL,
0x000000015a827812ULL, 0x000fc800078efcffULL, 0x00000052d2527219ULL, 0x000fe200000006ffULL,
0x0000000182547824ULL, 0x100fe200078e029bULL, 0xfffffff075567812ULL, 0x000fe400078ec0ffULL,
0x000000085a847812ULL, 0x040fe400078efcffULL, 0x0000005453557210ULL, 0x000fe20007ffe1ffULL,
0x000000011b597824ULL, 0x000fe200078e0256ULL, 0x000000095a867812ULL, 0x000fe400078efcffULL,
0x00000055d2567219ULL, 0x000fe200000006ffULL, 0x0000000184587824ULL, 0x000fc400078e029bULL,
0x0000000186667824ULL, 0x000fe200078e029bULL, 0xfffffff079647812ULL, 0x000fe200078ec0ffULL,
0x0000000158577824ULL, 0x100fe200078e0a53ULL, 0xfffffff07b887812ULL, 0x000fe200078ec0ffULL,
0x0000000166537824ULL, 0x000fe200078e0a53ULL, 0x000000115a8c7812ULL, 0x000fe200078efcffULL,
0x000000011b657824ULL, 0x040fe200078e0264ULL, 0x00000057d2647219ULL, 0x040fe200000006ffULL,
0x000000011b797824ULL, 0x000fe200078e0288ULL, 0x00000053d2887219ULL, 0x000fe200000006ffULL,
0x000000018c8e7824ULL, 0x000fc400078e029bULL, 0x0000000168537824ULL, 0x100fe400078e0a59ULL,
0x000000018e557824ULL, 0x000fe200078e0a59ULL, 0x000000185a927812ULL, 0x040fe400078efcffULL,
0x000000195aa47812ULL, 0x000fe400078efcffULL, 0x000054105e5b7816ULL, 0x010fc8000000005bULL,
0x0000005b52ff7212ULL, 0x000fc800078ac0ffULL, 0x0000001b5c00720cULL, 0x000fc80002fa1470ULL,
0x0000001b5a00720cULL, 0x000fe40002fa1070ULL, 0x0000005b56ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000003037808ULL, 0x000fe40002800000ULL, 0x00005410605d7816ULL, 0x000fe4000000005dULL,
0x00005410625f7816ULL, 0x004fe4000000005fULL, 0x0000005d52ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005f52ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005d56ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001b5c00720cULL, 0x0c0fe40001741470ULL, 0x0000001b5c00720cULL, 0x080fe40002781470ULL,
0x0000001b5400720cULL, 0x0c0fe40000f21470ULL, 0x0000001b5400720cULL, 0x000fc40002fa1470ULL,
0x0000001b5a00720cULL, 0x0c0fe40001741070ULL, 0x0000001b5a00720cULL, 0x080fe40002781070ULL,
0x0000001b8200720cULL, 0x0c0fe40000f21070ULL, 0x0000001b8200720cULL, 0x000fe40002fa1070ULL,
0x000054106c617816ULL, 0x000fe40000000061ULL, 0xff8000001a1a7808ULL, 0x000fc40001000000ULL,
0xff80000037377808ULL, 0x000fe40002000000ULL, 0xff80000008087808ULL, 0x000fe40000800000ULL,
0xff80000019197808ULL, 0x000fe40002800000ULL, 0x0000005b64ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006152ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005f56ff7212ULL, 0x000fc4000784c0ffULL,
0x0000006156ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005d88ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005f64ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001b5c00720cULL, 0x080fe40000701470ULL,
0x0000001b5400720cULL, 0x0c0fe40001741470ULL, 0x0000001b5400720cULL, 0x000fc40002781470ULL,
0x0000001b5800720cULL, 0x0c0fe40001f61470ULL, 0x0000001b5800720cULL, 0x080fe40002fa1470ULL,
0x0000001b6600720cULL, 0x080fe40000f21470ULL, 0x0000001b5a00720cULL, 0x080fe40000701070ULL,
0x0000001b8200720cULL, 0x0c0fe40001741070ULL, 0x0000001b8200720cULL, 0x000fc40002781070ULL,
0x0000001b8400720cULL, 0x0c0fe40001f61070ULL, 0x0000001b8400720cULL, 0x080fe40002fa1070ULL,
0x0000001b8600720cULL, 0x000fe40000f21070ULL, 0x00000053d28a7219ULL, 0x040fe400000006ffULL,
0x00000055d2907219ULL, 0x000fe400000006ffULL, 0x000054106e637816ULL, 0x008fc40000000063ULL,
0x0000541070697816ULL, 0x000fe20000000069ULL, 0x0000000192987824ULL, 0x100fe200078e029bULL,
0xff8000004e4e7808ULL, 0x000fe20000000000ULL, 0x00000001a4a67824ULL, 0x000fe200078e029bULL,
0xff8000003a3a7808ULL, 0x000fe40001000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff8000000a0a7808ULL, 0x000fe40001800000ULL, 0xff8000003b3b7808ULL, 0x000fc40002800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0x0000005d64ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005f88ff7212ULL, 0x000fe4000784c0ffULL, 0x0000006164ff7212ULL, 0x080fe4000788c0ffULL,
0x0000006188ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006390ff7212ULL, 0x000fc400078ac0ffULL,
0x000000698aff7212ULL, 0x000fe2000782c0ffULL, 0x0000000198577824ULL, 0x100fe200078e0a59ULL,
0x0000001b5800720cULL, 0x080fe20000701470ULL, 0x00000001a6597824ULL, 0x000fe200078e0a59ULL,
0x0000001b5800720cULL, 0x080fe40002781470ULL, 0x0000001b6600720cULL, 0x0c0fe40001741470ULL,
0x0000001b6600720cULL, 0x080fe40001f61470ULL, 0x0000001b6800720cULL, 0x000fc40000f21470ULL,
0x0000001b8e00720cULL, 0x080fe40002fa1470ULL, 0x0000001b8400720cULL, 0x0c0fe40000701070ULL,
0x0000001b8400720cULL, 0x080fe40002781070ULL, 0x0000001b8600720cULL, 0x0c0fe40001741070ULL,
0x0000001b8600720cULL, 0x080fe40001f61070ULL, 0x0000001b6a00720cULL, 0x000fc40000f21070ULL,
0x0000001b8c00720cULL, 0x000fe40002fa1070ULL, 0x00000057d2a27219ULL, 0x040fe400000006ffULL,
0x00000059d2a87219ULL, 0x000fe400000006ffULL, 0x00005410726d7816ULL, 0x000fe4000000006dULL,
0x00005410786f7816ULL, 0x000fe4000000006fULL, 0xff80000024247808ULL, 0x000fc40000000000ULL,
0xff80000050507808ULL, 0x000fe40002000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff80000051517808ULL, 0x000fe40001800000ULL, 0xff80000026267808ULL, 0x000fe40000800000ULL,
0xff8000000e0e7808ULL, 0x000fe40002800000ULL, 0x000000638aff7212ULL, 0x000fc4000780c0ffULL,
0x00000063a2ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006d8aff7212ULL, 0x040fe4000784c0ffULL,
0x0000006f8aff7212ULL, 0x000fe4000786c0ffULL, 0x0000006d90ff7212ULL, 0x000fe4000782c0ffULL,
0x00000069a8ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000176677824ULL, 0x000fe200078e0a65ULL,
0x0000001b6800720cULL, 0x000fc40000701470ULL, 0x0000001b6800720cULL, 0x0c0fe40001741470ULL,
0x0000001b6800720cULL, 0x080fe40001f61470ULL, 0x0000001b8e00720cULL, 0x080fe40000f21470ULL,
0x0000001b9800720cULL, 0x080fe40002781470ULL, 0x0000001ba600720cULL, 0x000fe40002fa1470ULL,
0x000000215aac7812ULL, 0x000fc400078efcffULL, 0x0000001b6a00720cULL, 0x0c0fe40000701070ULL,
0x0000001b6a00720cULL, 0x0c0fe40001741070ULL, 0x0000001b6a00720cULL, 0x080fe40001f61070ULL,
0x0000001b8c00720cULL, 0x080fe40000f21070ULL, 0x0000001b9200720cULL, 0x080fe40002781070ULL,
0x0000001ba400720cULL, 0x000fc40002fa1070ULL, 0x00000067d2aa7219ULL, 0x000fe400000006ffULL,
0x000054107c737816ULL, 0x000fe20000000073ULL, 0x00000001acae7824ULL, 0x000fe200078e029bULL,
0xff8000000d0d7808ULL, 0x000fe40000000000ULL, 0xff8000003d3d7808ULL, 0x000fe40001000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001800000ULL, 0xff80000040407808ULL, 0x000fc40000800000ULL,
0xff8000000f0f7808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40002800000ULL,
0x0000006990ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006f90ff7212ULL, 0x000fe4000784c0ffULL,
0x00000069a2ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006da8ff7212ULL, 0x000fc4000782c0ffULL,
0x0000006fa8ff7212ULL, 0x000fe4000788c0ffULL, 0x00000073aaff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ae6b7824ULL, 0x000fe200078e0a65ULL, 0x0000001b8e00720cULL, 0x0c0fe40000701470ULL,
0x0000001b8e00720cULL, 0x080fe40001741470ULL, 0x0000001b9800720cULL, 0x080fe40001f61470ULL,
0x0000001ba600720cULL, 0x000fc40000f21470ULL, 0x0000001ba600720cULL, 0x080fe40002781470ULL,
0x0000001b7600720cULL, 0x080fe40002fa1470ULL, 0x000000285ab27812ULL, 0x040fe400078efcffULL,
0x000000295ab87812ULL, 0x000fe400078efcffULL, 0x0000001b8c00720cULL, 0x0c0fe40000701070ULL,
0x0000001b8c00720cULL, 0x000fc40001741070ULL, 0x0000001b9200720cULL, 0x080fe40001f61070ULL,
0x0000001ba400720cULL, 0x0c0fe40000f21070ULL, 0x0000001ba400720cULL, 0x080fe40002781070ULL,
0x0000001b7400720cULL, 0x000fe40002fa1070ULL, 0x0000006bd2b07219ULL, 0x000fe400000006ffULL,
0x000054107a717816ULL, 0x000fc40000000071ULL, 0x00005410d6777816ULL, 0x000fe40000000077ULL,
0x00005410da877816ULL, 0x000fe20000000087ULL, 0x00000001b2b47824ULL, 0x100fe200078e029bULL,
0xff80000027277808ULL, 0x000fe20000000000ULL, 0x00000001b8ba7824ULL, 0x000fe200078e029bULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fc40000800000ULL, 0xff8000003f3f7808ULL, 0x000fe40002000000ULL,
0xff8000002b2b7808ULL, 0x000fe40002800000ULL, 0x0000005b88ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006da2ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006fa2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000071aaff7212ULL, 0x000fc4000786c0ffULL, 0x00000077aaff7212ULL, 0x040fe4000782c0ffULL,
0x00000087aaff7212ULL, 0x000fe4000788c0ffULL, 0x00000077b0ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b4757824ULL, 0x100fe200078e0a65ULL, 0x0000001b6600720cULL, 0x080fe200037c1470ULL,
0x00000001ba657824ULL, 0x000fe200078e0a65ULL, 0x0000001b9800720cULL, 0x0c0fe40000701470ULL,
0x0000001b9800720cULL, 0x000fc40001741470ULL, 0x0000001b7600720cULL, 0x0c0fe40001f61470ULL,
0x0000001b7600720cULL, 0x0c0fe40000f21470ULL, 0x0000001b7600720cULL, 0x080fe40002781470ULL,
0x0000001bae00720cULL, 0x080fe40002fa1470ULL, 0x0000001b8600720cULL, 0x080fe400037c1070ULL,
0x0000001b9200720cULL, 0x000fc40000701070ULL, 0x0000001b9200720cULL, 0x080fe40001741070ULL,
0x0000001b7400720cULL, 0x0c0fe40001f61070ULL, 0x0000001b7400720cULL, 0x0c0fe40000f21070ULL,
0x0000001b7400720cULL, 0x080fe40002781070ULL, 0x0000001bac00720cULL, 0x000fe40002fa1070ULL,
0x00000075d2b67219ULL, 0x000fc400000006ffULL, 0x00000065d2bc7219ULL, 0x000fe400000006ffULL,
0xff8000000c0c7808ULL, 0x000fe40003000000ULL, 0xff80000042427808ULL, 0x000fe40000000000ULL,
0xff8000003e3e7808ULL, 0x000fe40001000000ULL, 0xff80000011117808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fc40000800000ULL, 0xff80000041417808ULL, 0x000fe40002000000ULL,
0xff80000045457808ULL, 0x000fe40002800000ULL, 0x00000063a8ff7212ULL, 0x000fe400078cc0ffULL,
0x00000071b0ff7212ULL, 0x080fe4000780c0ffULL, 0x00000071b6ff7212ULL, 0x000fe4000784c0ffULL,
0x00000073b0ff7212ULL, 0x000fc4000786c0ffULL, 0x00000087b0ff7212ULL, 0x000fe4000782c0ffULL,
0x00000073b6ff7212ULL, 0x000fe4000788c0ffULL, 0x00000077bcff7212ULL, 0x000fe200078ac0ffULL,
0x00000001807b7824ULL, 0x000fe200078e0a79ULL, 0x0000001ba600720cULL, 0x080fe400037c1470ULL,
0x0000001bae00720cULL, 0x0c0fe40000701470ULL, 0x0000001bae00720cULL, 0x000fc40001f61470ULL,
0x0000001bae00720cULL, 0x080fe40000f21470ULL, 0x0000001bb400720cULL, 0x0c0fe40001741470ULL,
0x0000001bb400720cULL, 0x080fe40002781470ULL, 0x0000001bba00720cULL, 0x000fe40002fa1470ULL,
0x000000315ac27812ULL, 0x040fe400078efcffULL, 0x000000385ac87812ULL, 0x000fc400078efcffULL,
0x000000395ace7812ULL, 0x000fe400078efcffULL, 0x0000001ba400720cULL, 0x080fe400037c1070ULL,
0x0000001bac00720cULL, 0x0c0fe40000701070ULL, 0x0000001bac00720cULL, 0x0c0fe40001f61070ULL,
0x0000001bac00720cULL, 0x080fe40000f21070ULL, 0x0000001bb200720cULL, 0x000fc40001741070ULL,
0x0000001bb200720cULL, 0x080fe40002781070ULL, 0x0000001bb800720cULL, 0x000fe40002fa1070ULL,
0x0000007bd2c07219ULL, 0x000fe400000006ffULL, 0x00005410be7f7816ULL, 0x000fe4000000007fULL,
0x00005410d8857816ULL, 0x000fe20000000085ULL, 0x00000001c2c47824ULL, 0x100fe200078e029bULL,
0xff80000010107808ULL, 0x000fe20003000000ULL, 0x00000001c8ca7824ULL, 0x100fe200078e029bULL,
0xff80000012127808ULL, 0x000fe20000000000ULL, 0x00000001ced07824ULL, 0x000fe200078e029bULL,
0xff8000002f2f7808ULL, 0x000fc40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40000800000ULL,
0xff80000013137808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40002000000ULL,
0xff80000047477808ULL, 0x000fe40002800000ULL, 0x00000071bcff7212ULL, 0x040fe400078cc0ffULL,
0x00000073bcff7212ULL, 0x000fc4000780c0ffULL, 0x00000077b6ff7212ULL, 0x040fe4000786c0ffULL,
0x00000087b6ff7212ULL, 0x080fe4000782c0ffULL, 0x00000087bcff7212ULL, 0x000fe4000784c0ffULL,
0x0000007fc0ff7212ULL, 0x040fe4000788c0ffULL, 0x00000085c0ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c47d7824ULL, 0x100fe200078e0a79ULL, 0x0000001bb400720cULL, 0x080fe20001f61470ULL,
0x00000001ca817824ULL, 0x100fe200078e0a79ULL, 0x0000001bb400720cULL, 0x080fe20000f21470ULL,
0x00000001d0797824ULL, 0x000fe200078e0a79ULL, 0x0000001bba00720cULL, 0x000fc400037c1470ULL,
0x0000001bba00720cULL, 0x0c0fe40000701470ULL, 0x0000001bba00720cULL, 0x080fe40001741470ULL,
0x0000001b8000720cULL, 0x0c0fe40002781470ULL, 0x0000001b8000720cULL, 0x000fe40002fa1470ULL,
0x0000007dd2c67219ULL, 0x040fe400000006ffULL, 0x00000081d2cc7219ULL, 0x000fc400000006ffULL,
0x0000001bb200720cULL, 0x0c0fe40001f61070ULL, 0x0000001bb200720cULL, 0x080fe40000f21070ULL,
0x0000001bb800720cULL, 0x0c0fe400037c1070ULL, 0x0000001bb800720cULL, 0x0c0fe40000701070ULL,
0x0000001bb800720cULL, 0x080fe40001741070ULL, 0x0000001b7e00720cULL, 0x000fc40002781070ULL,
0x0000001b7e00720cULL, 0x000fe40002fa1070ULL, 0x00000079d2d27219ULL, 0x000fe400000006ffULL,
0x00005410d4837816ULL, 0x000fe40000000083ULL, 0xff80000046467808ULL, 0x000fe40001800000ULL,
0xff8000002a2a7808ULL, 0x000fe40000800000ULL, 0xff80000014147808ULL, 0x000fc40003000000ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff8000002c2c7808ULL, 0x000fe40001000000ULL,
0xff80000015157808ULL, 0x000fe40002000000ULL, 0xff80000048487808ULL, 0x000fe40002800000ULL,
0x0000007fc6ff7212ULL, 0x080fe4000786c0ffULL, 0x0000007fccff7212ULL, 0x000fc4000782c0ffULL,
0x0000007fd2ff7212ULL, 0x000fe400078cc0ffULL, 0x00000083c0ff7212ULL, 0x080fe4000780c0ffULL,
0x00000083c6ff7212ULL, 0x080fe4000784c0ffULL, 0x00000083ccff7212ULL, 0x000fe4000788c0ffULL,
0x00000085c6ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001b8000720cULL, 0x000fc40000701470ULL,
0x0000001bc400720cULL, 0x0c0fe40001f61470ULL, 0x0000001bc400720cULL, 0x0c0fe40001741470ULL,
0x0000001bc400720cULL, 0x080fe40002fa1470ULL, 0x0000001bca00720cULL, 0x080fe40000f21470ULL,
0x0000001bd000720cULL, 0x080fe400037c1470ULL, 0x0000001bca00720cULL, 0x000fc40002781470ULL,
0x0000001b7e00720cULL, 0x080fe40000701070ULL, 0x0000001bc200720cULL, 0x0c0fe40001f61070ULL,
0x0000001bc200720cULL, 0x0c0fe40001741070ULL, 0x0000001bc200720cULL, 0x080fe40002fa1070ULL,
0x0000001bc800720cULL, 0x080fe40000f21070ULL, 0x0000001bce00720cULL, 0x000fc400037c1070ULL,
0x0000001bc800720cULL, 0x000fe40002781070ULL, 0x00005410dc897816ULL, 0x000fe40000000089ULL,
0xff80000034347808ULL, 0x000fe40000000000ULL, 0xff80000016167808ULL, 0x000fe40001800000ULL,
0xff80000035357808ULL, 0x000fe40001000000ULL, 0xff8000004a4a7808ULL, 0x000fc40002800000ULL,
0xff80000017177808ULL, 0x000fe40000800000ULL, 0xff80000018187808ULL, 0x000fe40003000000ULL,
0xff80000036367808ULL, 0x000fe40002000000ULL, 0x00000083d2ff7212ULL, 0x000fe4000780c0ffULL,
0x00000085ccff7212ULL, 0x080fe4000786c0ffULL, 0x00000085d2ff7212ULL, 0x000fc4000784c0ffULL,
0x00000089c0ff7212ULL, 0x080fe400078ac0ffULL, 0x00000089c6ff7212ULL, 0x080fe4000782c0ffULL,
0x00000089ccff7212ULL, 0x080fe400078cc0ffULL, 0x00000089d2ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001b8000720cULL, 0x080fe40002fa1470ULL, 0x0000001bc400720cULL, 0x000fc40000f21470ULL,
0x0000001bca00720cULL, 0x0c0fe40001f61470ULL, 0x0000001bca00720cULL, 0x080fe400037c1470ULL,
0x0000001bd000720cULL, 0x0c0fe40000701470ULL, 0x0000001bd000720cULL, 0x0c0fe40001741470ULL,
0x0000001bd000720cULL, 0x080fe40002781470ULL, 0x0000001b7e00720cULL, 0x000fc40002fa1070ULL,
0x0000001bc200720cULL, 0x080fe40000f21070ULL, 0x0000001bce00720cULL, 0x080fe40000701070ULL,
0x0000001bc800720cULL, 0x0c0fe40001f61070ULL, 0x0000001bc800720cULL, 0x080fe400037c1070ULL,
0x0000001bce00720cULL, 0x0c0fe40001741070ULL, 0x0000001bce00720cULL, 0x000fc40002781070ULL,
0xff80000039397808ULL, 0x000fe40000000000ULL, 0xff8000004b4b7808ULL, 0x000fe40001800000ULL,
0xff8000004c4c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0xff80000033337808ULL, 0x000fc40003000000ULL,
0xff80000038387808ULL, 0x000fc40002000000ULL, 0x000000030400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff597424ULL, 0x000fe200078e00ffULL, 0x0000001a0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff5c7424ULL, 0x000fe200078e00ffULL, 0x000000370600720bULL, 0x000fe40003f5e000ULL,
0x0000004e0700720bULL, 0x000fe40003f7e000ULL, 0x00000004031b7208ULL, 0x000fe40004000000ULL,
0x000000051a047208ULL, 0x000fc40004800000ULL, 0x0000000637057208ULL, 0x000fe40005000000ULL,
0x000000074e067208ULL, 0x000fe40005800000ULL, 0x000000081b00720bULL, 0x000fe40003f1e000ULL,
0x000000190400720bULL, 0x000fe40003f3e000ULL, 0x0000003a0500720bULL, 0x000fe40003f5e000ULL,
0x0000004d0600720bULL, 0x000fc40003f7e000ULL, 0x0000001b081b7208ULL, 0x000fe40004000000ULL,
0x0000000419077208ULL, 0x000fe40004800000ULL, 0x000000053a047208ULL, 0x000fe40005000000ULL,
0x000000064d057208ULL, 0x000fe40005800000ULL, 0x0000000a1b00720bULL, 0x000fe40003f1e000ULL,
0x000000240700720bULL, 0x000fc40003f3e000ULL, 0x0000003b0400720bULL, 0x000fe40003f5e000ULL,
0x000000500500720bULL, 0x000fe40003f7e000ULL, 0x0000001b0a1b7208ULL, 0x000fe40004000000ULL,
0x0000000724067208ULL, 0x000fe40004800000ULL, 0x000000043b077208ULL, 0x000fe40005000000ULL,
0x0000000550047208ULL, 0x000fc40005800000ULL, 0x0000000c1b00720bULL, 0x000fe40003f1e000ULL,
0x000000250600720bULL, 0x000fe40003f3e000ULL, 0x0000003c0700720bULL, 0x000fe40003f5e000ULL,
0x000000510400720bULL, 0x000fe40003f7e000ULL, 0x0000001b0c527208ULL, 0x000fe40004000000ULL,
0x0000000625057208ULL, 0x000fc40004800000ULL, 0x000000073c067208ULL, 0x000fe40005000000ULL,
0x0000000451047208ULL, 0x000fe40005800000ULL, 0x0000000d5200720bULL, 0x000fe40003f1e000ULL,
0x000000260500720bULL, 0x000fe40003f3e000ULL, 0x0000003d0600720bULL, 0x000fe40003f5e000ULL,
0x0000004f0400720bULL, 0x000fc40003f7e000ULL, 0x000000520d077208ULL, 0x000fe40004000000ULL,
0x0000000526527208ULL, 0x000fe40004800000ULL, 0x000000063d057208ULL, 0x000fe40005000000ULL,
0x000000044f047208ULL, 0x000fe40005800000ULL, 0x0000000e0700720bULL, 0x000fe40003f1e000ULL,
0x000000275200720bULL, 0x000fc40003f3e000ULL, 0x000000400500720bULL, 0x000fe40003f5e000ULL,
0x000000490400720bULL, 0x000fe40003f7e000ULL, 0x000000070e067208ULL, 0x000fe40004000000ULL,
0x0000005227077208ULL, 0x000fe40004800000ULL, 0x0000000540057208ULL, 0x000fe40005000000ULL,
0x00000004491b7208ULL, 0x000fc40005800000ULL, 0x0000000f0600720bULL, 0x000fe40003f1e000ULL,
0x000000280700720bULL, 0x000fe40003f3e000ULL, 0x000000420500720bULL, 0x000fe40003f5e000ULL,
0x0000003e1b00720bULL, 0x000fe40003f7e000ULL, 0x000000060f537208ULL, 0x000fe40004000000ULL,
0x0000000728047208ULL, 0x000fc40004800000ULL, 0x0000000542067208ULL, 0x000fe40005000000ULL,
0x0000001b3e527208ULL, 0x000fe40005800000ULL, 0x000000105300720bULL, 0x000fe40003f1e000ULL,
0x000000290400720bULL, 0x000fe40003f3e000ULL, 0x000000430600720bULL, 0x000fe40003f5e000ULL,
0x0000003f5200720bULL, 0x000fc40003f7e000ULL, 0x0000005310547208ULL, 0x000fe40004000000ULL,
0x0000000429047208ULL, 0x000fe40004800000ULL, 0x0000000643057208ULL, 0x000fe40005000000ULL,
0x000000523f527208ULL, 0x000fe40005800000ULL, 0x000000115400720bULL, 0x000fe40003f1e000ULL,
0x0000002b0400720bULL, 0x000fc40003f3e000ULL, 0x000000440500720bULL, 0x000fe40003f5e000ULL,
0x000000415200720bULL, 0x000fe40003f7e000ULL, 0x0000005411077208ULL, 0x000fe40004000000ULL,
0x000000042b047208ULL, 0x000fe40004800000ULL, 0x0000000544067208ULL, 0x000fe40005000000ULL,
0x0000005241527208ULL, 0x000fc40005800000ULL, 0x000000120700720bULL, 0x000fe40003f1e000ULL,
0x0000002f0400720bULL, 0x000fe40003f3e000ULL, 0x000000450600720bULL, 0x000fe40003f5e000ULL,
0x0000002d5200720bULL, 0x000fe40003f7e000ULL, 0x0000000712547208ULL, 0x000fe40004000000ULL,
0x000000042f057208ULL, 0x000fc40004800000ULL, 0x0000000645077208ULL, 0x000fe40005000000ULL,
0x000000522d1b7208ULL, 0x000fe40005800000ULL, 0x000000135400720bULL, 0x000fe40003f1e000ULL,
0x000000300500720bULL, 0x000fe40003f3e000ULL, 0x000000460700720bULL, 0x000fe40003f5e000ULL,
0x0000002a1b00720bULL, 0x000fc40003f7e000ULL, 0x0000005413537208ULL, 0x000fe40004000000ULL,
0x0000000530057208ULL, 0x000fe40004800000ULL, 0x0000000746047208ULL, 0x000fe40005000000ULL,
0x0000001b2a1b7208ULL, 0x000fe40005800000ULL, 0x000000145300720bULL, 0x000fe40003f1e000ULL,
0x000000320500720bULL, 0x000fc40003f3e000ULL, 0x000000470400720bULL, 0x000fe40003f5e000ULL,
0x0000002c1b00720bULL, 0x000fe40003f7e000ULL, 0x0000005314067208ULL, 0x000fe40004000000ULL,
0x0000000532057208ULL, 0x000fe40004800000ULL, 0x0000000447077208ULL, 0x000fe40005000000ULL,
0x0000001b2c1b7208ULL, 0x000fc40005800000ULL, 0x000000150600720bULL, 0x000fe40003f1e000ULL,
0x000000340500720bULL, 0x000fe40003f3e000ULL, 0x000000480700720bULL, 0x000fe40003f5e000ULL,
0x0000002e1b00720bULL, 0x000fe40003f7e000ULL, 0x0000000615537208ULL, 0x000fe40004000000ULL,
0x0000000534047208ULL, 0x000fc40004800000ULL, 0x0000000748077208ULL, 0x000fe40005000000ULL,
0x0000001b2e067208ULL, 0x000fe40005800000ULL, 0x000000165300720bULL, 0x000fe40003f1e000ULL,
0x000000350400720bULL, 0x000fe40003f3e000ULL, 0x0000004a0700720bULL, 0x000fe40003f5e000ULL,
0x000000310600720bULL, 0x000fc40003f7e000ULL, 0x0000005316527208ULL, 0x000fe40004000000ULL,
0x0000000435057208ULL, 0x000fe40004800000ULL, 0x000000074a047208ULL, 0x000fe40005000000ULL,
0x0000000631067208ULL, 0x000fe40005800000ULL, 0x000000175200720bULL, 0x000fe40003f1e000ULL,
0x000000360500720bULL, 0x000fc40003f3e000ULL, 0x0000004b0400720bULL, 0x000fe40003f5e000ULL,
0x000000330600720bULL, 0x000fe40003f7e000ULL, 0x0000005217077208ULL, 0x000fe40004000000ULL,
0x0000000536527208ULL, 0x000fe40004800000ULL, 0x000000044b057208ULL, 0x000fe40005000000ULL,
0x00000006331b7208ULL, 0x000fc40005800000ULL, 0x000000180700720bULL, 0x000fe40003f1e000ULL,
0x000000395200720bULL, 0x000fe40003f3e000ULL, 0x0000004c0500720bULL, 0x000fe40003f5e000ULL,
0x000000381b00720bULL, 0x000fe40003f7e000ULL, 0x0000000718077208ULL, 0x000fe40004000000ULL,
0x0000005239557208ULL, 0x000fc40004800000ULL, 0x000000054c567208ULL, 0x000fe40005000000ULL,
0x0000001b38577208ULL, 0x000fe20005800000ULL, 0x000020d27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704587208ULL, 0x000fe20004000000ULL, 0x000020e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0055047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0056057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0057067f89ULL, 0x000e6200000e0000ULL, 0x000000045500720bULL, 0x008fc40003f1e000ULL,
0x000000055600720bULL, 0x010fe40003f3e000ULL, 0x0000005504077208ULL, 0x006fe40004000000ULL,
0x00000056051b7208ULL, 0x000fe20004800000ULL, 0x0c201f0058047f89ULL, 0x000e6200000e0000ULL,
0x000000065700720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007527f89ULL, 0x000ea200000e0000ULL,
0x00000057065a7208ULL, 0x000fc60004000000ULL, 0x0c201f001b547f89ULL, 0x000ee800000e0000ULL,
0x0c201f005a5b7f89ULL, 0x0002e400000e0000ULL, 0x000000045800720bULL, 0x002fe40003f1e000ULL,
0x000000520700720bULL, 0x004fe40003f3e000ULL, 0x0000005804047208ULL, 0x000fc40004000000ULL,
0x000000541b00720bULL, 0x008fe40003f5e000ULL, 0x0000000752057208ULL, 0x000fe40004800000ULL,
0x0000001b54067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000005b5a00720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x00000003001b7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11527823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12557823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13547823ULL, 0x100fe20000010807ULL,
0x00000008005c7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b14577823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15037823ULL, 0x102fe20000010807ULL, 0x3fb8aa3b18537823ULL, 0x000fca0000010807ULL,
0x0000000a005d7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b16087823ULL, 0x004fce0000010807ULL,
0x0000000c005e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b170a7823ULL, 0x002fe20000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b34567823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b35597823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b36587823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b39397823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b06077820ULL, 0x000fe20000410000ULL,
0x0000002900167308ULL, 0x0003e60000000800ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x000fe20000010807ULL, 0x0000005a5b077208ULL, 0x000fe20004000000ULL,
0x0000002800137308ULL, 0x0004e20000000800ULL, 0x00000002ff297819ULL, 0x002fc4000001161fULL,
0x000000031fff7812ULL, 0x000fe4000780c0ffULL, 0x00000001290c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000829177824ULL, 0x000fe400078e00ffULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b07287820ULL, 0x004fe20000410000ULL, 0x0000000829357824ULL, 0x000fc600078e00ffULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010828ULL,
0x0000000e00607308ULL, 0x0002a20000000800ULL, 0x000000131613723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010828ULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x00000003290e7810ULL, 0x002fe20007ffe0ffULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fca0000010828ULL,
0x0000001000627308ULL, 0x0002f00000000800ULL, 0x0000004a00617308ULL, 0x0009e20000000800ULL,
0x0000000429107810ULL, 0x002fc80007ffe0ffULL, 0xfffffff835687812ULL, 0x000fe400078ee210ULL,
0x0000000d6010723eULL, 0x004fe200000010ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0xfffffff8174a7812ULL, 0x010fe400078ee20cULL, 0x00000002290c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f6212723eULL, 0x008fc600000010ffULL, 0x0000001900197308ULL, 0x000e700000000800ULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x0000001a190d723eULL, 0x002fc400000010ffULL, 0x00000006291a7810ULL, 0x000fca0007ffe0ffULL,
0x0000002600117308ULL, 0x000ff00000000800ULL, 0x0000002700147308ULL, 0x0002e20000000800ULL,
0x00000024250f723eULL, 0x004fce00000010ffULL, 0x00000032005f7308ULL, 0x000fe20000000800ULL,
0x0000000829277824ULL, 0x002fca00078e00ffULL, 0xfffffff8275a7812ULL, 0x000fe400078ee20cULL,
0x0000003b00157308ULL, 0x000fe20000000800ULL, 0x0000001b5c0c723eULL, 0x000fe400000010ffULL,
0x000000111411723eULL, 0x008fe400000010ffULL, 0x00000003295c7819ULL, 0x000fc600000006ffULL,
0x0000003c003c7308ULL, 0x000e700000000800ULL, 0x0000003700377308ULL, 0x000ff00000000800ULL,
0x0000003a00187308ULL, 0x0004e20000000800ULL, 0x000000153c16723eULL, 0x002fce00000010ffULL,
0x0000004e004e7308ULL, 0x000fe20000000800ULL, 0x00000004ff3a7e24ULL, 0x004fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe80003800000ULL, 0x3f8000003a3a783eULL, 0x000fe400000010ffULL,
0x0000004d004d7308ULL, 0x000e620000000800ULL, 0x000000371814723eULL, 0x008fe400000010ffULL,
0x000000ffff3b7224ULL, 0x100fe200078e003aULL, 0x0000000529187810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fc400078e003aULL, 0x000000ffff357224ULL, 0x100fe200078e003aULL,
0x0000005000177308ULL, 0x000fe20000000800ULL, 0x000000ffff627224ULL, 0x100fe400078e003aULL,
0x000000ffff637224ULL, 0x000fca00078e003aULL, 0x0000005100327308ULL, 0x000ea20000000800ULL,
0x0000004e4d15723eULL, 0x002fce00000010ffULL, 0x0000002f00647308ULL, 0x0003e20000000800ULL,
0x000000173217723eULL, 0x004fe200000010ffULL, 0x00000008292f7824ULL, 0x002fcc00078e00ffULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0xfffffff82f667812ULL, 0x000fe200078ee20eULL,
0x000000341434723cULL, 0x000fe200000418ffULL, 0x0000005d5e0e723eULL, 0x000fca00000010ffULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0xffffffff292f7810ULL, 0x000fe20007ffe0ffULL,
0x0000003a0c24723cULL, 0x000b6600000418ffULL, 0xfffffff85c5c7812ULL, 0x000fc600078ee22fULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x00000008293b7824ULL, 0x020fce00078e00ffULL,
0x0000004300437308ULL, 0x000ea20000000800ULL, 0xfffffff83b4e7812ULL, 0x000fe200078ee218ULL,
0x3fb8aa3b2e3b7823ULL, 0x100fe20000010828ULL, 0x0000003d4018723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b313d7823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b38407823ULL, 0x000fe20000010828ULL,
0x000000ffff317224ULL, 0x100fe400078e003aULL, 0x0000004f00197308ULL, 0x0003e40000000800ULL,
0x000000621024723cULL, 0x000f6c0000041824ULL, 0x00000049003c7308ULL, 0x0007220000000800ULL,
0x000000ffff4f7224ULL, 0x002fce00078e003aULL, 0x0000003e001b7308ULL, 0x0003e20000000800ULL,
0x0000000829497824ULL, 0x008fca00078e00ffULL, 0xfffffff849507812ULL, 0x000fe400078ee21aULL,
0x0000003f00327308ULL, 0x0006e20000000800ULL, 0x00000042431a723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b333e7823ULL, 0x002fe20000010828ULL, 0x000000193c19723eULL, 0x010fe200000010ffULL,
0x0000000829287824ULL, 0x040fe200078e00ffULL, 0x0000001029427810ULL, 0x040fe40007ffe0ffULL,
0x0000000c02497812ULL, 0x000fe200078ec0ffULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x00000008293f7810ULL, 0x008fe20007ffe0ffULL, 0x0000000842437824ULL, 0x000fc800078e00ffULL,
0x000000083f5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff843607812ULL, 0x000fe200078ee242ULL,
0x0000005500557308ULL, 0x000e620000000800ULL, 0x0000001b321b723eULL, 0x000fe400000010ffULL,
0xfffffff828427812ULL, 0x000fe400078ee229ULL, 0xfffffff85e5e7812ULL, 0x000fc600078ee23fULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000621834723cULL, 0x000f6e0000041834ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x000000525528723eULL, 0x002fce00000010ffULL,
0x0000005400547308ULL, 0x000ff00000000800ULL, 0x0000005700577308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000ff00000000800ULL, 0x0000004500457308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000ff00000000800ULL, 0x0000004700477308ULL, 0x000e700000000800ULL,
0x0000004100417308ULL, 0x000ff00000000800ULL, 0x0000002d003c7308ULL, 0x0004e20000000800ULL,
0x00000046472e723eULL, 0x002fce00000010ffULL, 0x0000002a002f7308ULL, 0x0003e20000000800ULL,
0x00000018292d7810ULL, 0x004fe40007ffe0ffULL, 0x0000002b6429723eULL, 0x000fe400000010ffULL,
0x000000305f2b723eULL, 0x000fe200000010ffULL, 0x000000082d527824ULL, 0x000fe400078e00ffULL,
0x0000002c00327308ULL, 0x0005220000000800ULL, 0x00000054572a723eULL, 0x002fe200000010ffULL,
0x000000ffff307224ULL, 0x000fe200078e003aULL, 0xfffffff852527812ULL, 0x000fc400078ee22dULL,
0x000000413c2d723eULL, 0x008fc600000010ffULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x00000044452c723eULL, 0x004fe200000010ffULL, 0x000000ffff447224ULL, 0x100fe400078e003aULL,
0x000000ffff457224ULL, 0x000fc800078e003aULL, 0x0000000800087308ULL, 0x000e620000000800ULL,
0x0000002f322f723eULL, 0x010fe400000010ffULL, 0x000000302830723cULL, 0x020b6a0000041824ULL,
0x0000000a000a7308ULL, 0x000fe60000000800ULL, 0x000000442c34723cULL, 0x000bea0000041834ULL,
0x0000005300537308ULL, 0x000ea20000000800ULL, 0x000000030824723eULL, 0x022fc400000010ffULL,
0x0000a0009a037811ULL, 0x000fc800078e60ffULL, 0x0000000360467211ULL, 0x000fe200078e20ffULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x0000001042027824ULL, 0x100fe400078e0203ULL,
0x000000104a087824ULL, 0x100fe400078e0203ULL, 0x0000001066417824ULL, 0x100fe400078e0203ULL,
0x000000104e437824ULL, 0x100fe200078e0203ULL, 0x0000003900397308ULL, 0x000e620000000800ULL,
0x0000000a5326723eULL, 0x004fe200000010ffULL, 0x000000105a0a7824ULL, 0x000fc400078e0203ULL,
0x0000001068427824ULL, 0x100fe400078e0203ULL, 0x000000ffff4e7224ULL, 0x000fe400078e003aULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x0000000149087824ULL, 0x040fe400078e0208ULL,
0x0000001050447824ULL, 0x100fe400078e0203ULL, 0x00000001490a7824ULL, 0x000fe400078e020aULL,
0x000000105c457824ULL, 0x000fe200078e0203ULL, 0x0000005900597308ULL, 0x000ea20000000800ULL,
0x000000583927723eULL, 0x002fe200000010ffULL, 0x0000000149397824ULL, 0x000fc400078e0202ULL,
0x0000000149417824ULL, 0x040fe400078e0241ULL, 0x000000105e027824ULL, 0x000fe200078e0203ULL,
0x0000000c39007388ULL, 0x0003e20000000800ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000000149427824ULL, 0x040fe400078e0242ULL, 0x0000000149437824ULL, 0x040fe200078e0243ULL,
0x0000000e08007388ULL, 0x0007e20000000800ULL, 0x0000000149447824ULL, 0x040fe400078e0244ULL,
0x0000000149457824ULL, 0x000fe200078e0245ULL, 0x0000003d00387308ULL, 0x000f220000000800ULL,
0x000000565925723eULL, 0x004fe200000010ffULL, 0x000000100a007388ULL, 0x0007e20000000800ULL,
0x0000000149027824ULL, 0x000fc400078e0202ULL, 0x0000001052477824ULL, 0x000fe200078e0203ULL,
0x0000001241007388ULL, 0x0007e20000000800ULL, 0x0000000149037824ULL, 0x040fe200078e0246ULL,
0x0000004800487308ULL, 0x000ea20000000800ULL, 0x0000004e2430723cULL, 0x000f620000041830ULL,
0x0000002842007388ULL, 0x0007e20000000800ULL, 0x00000001490c7824ULL, 0x002fc600078e0247ULL,
0x0000002a43007388ULL, 0x0007e40000000800ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x0000003b383d723eULL, 0x010fe200000010ffULL, 0x000000ffff3b7224ULL, 0x000fe200078e003aULL,
0x0000002444007388ULL, 0x0007e80000000800ULL, 0x0000002645007388ULL, 0x0007e20000000800ULL,
0x0000004c004c7308ULL, 0x000e620000000800ULL, 0x00000048613c723eULL, 0x004fc400000010ffULL,
0x0000000d02007388ULL, 0x0007e80000000800ULL, 0x0004000f08007388ULL, 0x0007e20000000800ULL,
0x0000003e003f7308ULL, 0x0003e20000000800ULL, 0x000000ffff317224ULL, 0x020fe400078e0032ULL,
0x000400110a007388ULL, 0x0007e80000000800ULL, 0x0004001341007388ULL, 0x0007e20000000800ULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x0000004b4c3e723eULL, 0x002fc400000010ffULL,
0x0004002942007388ULL, 0x0007e80000000800ULL, 0x0004002b43007388ULL, 0x0007e80000000800ULL,
0x0004002544007388ULL, 0x0007e80000000800ULL, 0x0004002745007388ULL, 0x0007e20000000800ULL,
0x0000003f403f723eULL, 0x004fc600000010ffULL, 0x0000001403007388ULL, 0x0007e80000000800ULL,
0x0000003a3c34723cULL, 0x000f620000041834ULL, 0x0008001608007388ULL, 0x0007e80000000800ULL,
0x000800180a007388ULL, 0x0007e80000000800ULL, 0x0008001a41007388ULL, 0x0007e80000000800ULL,
0x0008002c42007388ULL, 0x0007e80000000800ULL, 0x0008002e43007388ULL, 0x0007e80000000800ULL,
0x0008003c44007388ULL, 0x0007e60000000800ULL, 0x000000ffff327224ULL, 0x020fe200078e0034ULL,
0x0008003e45007388ULL, 0x0007e20000000800ULL, 0x000000ffff337224ULL, 0x000fc600078e0036ULL,
0x000000150c007388ULL, 0x0007e80000000800ULL, 0x000c001708007388ULL, 0x0007e80000000800ULL,
0x000c00190a007388ULL, 0x0007e80000000800ULL, 0x000c001b41007388ULL, 0x0007e80000000800ULL,
0x000c002d42007388ULL, 0x0007e80000000800ULL, 0x000c002f43007388ULL, 0x0007e80000000800ULL,
0x000c003d44007388ULL, 0x0007e80000000800ULL, 0x000c003f45007388ULL, 0x0007e80000000800ULL,
0x0160000400008388ULL, 0x0007e80000000c00ULL, 0x0162003000008388ULL, 0x0007e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016608009fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016610009fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016618009fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000220b00720cULL, 0x000fe20003f06070ULL,
0x016620009fff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff957224ULL, 0x000fd600078e000bULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff79e000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff1f7807ULL, 0x008fe40004000000ULL,
0x0001912000207802ULL, 0x000fc40000000f00ULL, 0x0000106000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e001fULL, 0xfffea12000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40005000000ULL, 0x0001917000207802ULL, 0x000fc40000000f00ULL,
0x0000101000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e001fULL,
0xfffea18000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0010ULL,
0x000191c000207802ULL, 0x000fc40000000f00ULL, 0x00000f8000007944ULL, 0x012fea0003c00000ULL,
0xfffea25000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0010ULL,
0x0001920000207802ULL, 0x000fc40000000f00ULL, 0x00000f4000007944ULL, 0x012fea0003c00000ULL,
0xfffea38000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0010ULL,
0x0001924000207802ULL, 0x000fc40000000f00ULL, 0x00000f0000007944ULL, 0x012fea0003c00000ULL,
0xfffea4b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0010ULL,
0x0001928000207802ULL, 0x000fc40000000f00ULL, 0x00000ec000007944ULL, 0x012fea0003c00000ULL,
0xfffea5d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000cULL,
0x000192d000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e000bULL,
0x00000e7000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e001fULL,
0xfffea78000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000cULL,
0x0001932000207802ULL, 0x000fc40000000f00ULL, 0x00000e2000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e001fULL, 0x000000100b1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200078e000cULL, 0x0001937000207802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e001fULL,
0xfffea73000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000cULL,
0x000193c000207802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e001fULL, 0xfffea71000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x004fe40004000000ULL, 0x0001941000207802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001fULL,
0xfffec02000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004800000ULL,
0x0001946000207802ULL, 0x000fc40000000f00ULL, 0x00000d2000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e001fULL, 0xfffec07000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x000194b000207802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x018fea0003c00000ULL, 0xfffec15000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x000194f000207802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x01afea0003c00000ULL, 0xfffec28000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x0001953000207802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x01afea0003c00000ULL, 0xfffec3b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x0001957000207802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x01afea0003c00000ULL, 0xfffec4d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0002ULL, 0x000195c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e000bULL, 0x00000b8000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e001fULL, 0xfffec67000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0002ULL, 0x0001961000207802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e001fULL,
0x000000100b1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fe200078e0002ULL,
0x0001966000207802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e001fULL, 0xfffec62000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0002ULL, 0x000196b000207802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e001fULL,
0xfffec60000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x004fe40004000000ULL,
0x0001970000207802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001fULL, 0xfffedc6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004800000ULL, 0x0001975000207802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff667224ULL, 0x000fe200078e001fULL,
0xfffedca000007947ULL, 0x000fea000383ffffULL, 0x0000006700217202ULL, 0x000fe40000000f00ULL,
0x000197a000207802ULL, 0x000fc40000000f00ULL, 0x000009a000007944ULL, 0x018fea0003c00000ULL,
0xfffedd7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0067ULL,
0x000197e000207802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x01afea0003c00000ULL,
0xfffedea000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0067ULL,
0x0001982000207802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x01afea0003c00000ULL,
0xfffedfd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0067ULL,
0x0001986000207802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x01afea0003c00000ULL,
0xfffee0f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000bULL,
0x000198b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0064ULL,
0x0000089000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e001fULL,
0xfffee29000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000bULL,
0x0001990000207802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e001fULL, 0x00000010641f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200078e000bULL, 0x0001995000207802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e001fULL,
0xfffee24000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000bULL,
0x000199a000207802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e001fULL, 0xfffee22000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x004fe40004000000ULL, 0x000199f000207802ULL, 0x000fc40000000f00ULL,
0x0000079000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e001fULL,
0xfffef87000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004800000ULL,
0x00019a4000207802ULL, 0x000fc40000000f00ULL, 0x0000074000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff687224ULL, 0x000fe200078e001fULL, 0xfffef8c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00019a9000207802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x018fea0003c00000ULL, 0xfffef99000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00019ad000207802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x01afea0003c00000ULL, 0xfffefac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00019b1000207802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x01afea0003c00000ULL, 0xfffefbf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00019b5000207802ULL, 0x000fc40000000f00ULL,
0x000005f000007944ULL, 0x01afea0003c00000ULL, 0xfffefd1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0006ULL, 0x00019ba000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e000bULL, 0x000005a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e001fULL, 0xfffefea000007947ULL, 0x000fea000383ffffULL,
0x0000000600217202ULL, 0x000fe40000000f00ULL, 0x00019bf000207802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e001fULL,
0x000000100b1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fe200078e0006ULL,
0x00019c4000207802ULL, 0x000fc40000000f00ULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e001fULL, 0xfffefe5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0006ULL, 0x00019c9000207802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e001fULL,
0xfffefe3000007947ULL, 0x000fea000383ffffULL, 0x00000002ff547424ULL, 0x000fe200078e00ffULL,
0x00019ce000527802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e005bULL, 0xffffdef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e0055ULL, 0x0000000200547802ULL, 0x000fc40000000f00ULL,
0x00019d4000527802ULL, 0x000fc40000000f00ULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0056ULL,
0x00019da000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe200078e00ffULL,
0x000000555b067208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0057ULL,
0x00019e0000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe200078e00ffULL,
0x000000565b567208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0058ULL,
0x00019e6000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x000000575b5a7208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x00019ec000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x000000585b047208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x0000005b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0056ULL,
0x00019f2000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x000000065b057208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e005aULL,
0x00019f8000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x000000565b067208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffddc000007947ULL, 0x000fea000383ffffULL, 0x0180000006037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000600038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff0c7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030cff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030cff7212ULL, 0x000fda000780c0ffULL, 0x0080000006030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe5f0008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005c00007348ULL, 0x000fe80003800000ULL,
0x0c000054075b7389ULL, 0x0002a200000e0059ULL, 0xfffe5ec052007950ULL, 0x000fea0003c3ffffULL,
0x0000008500007348ULL, 0x000fe80003800000ULL, 0x0000001f211f7389ULL, 0x0002a400000e0086ULL,
0x00000000ff217424ULL, 0x002fc800078e00ffULL, 0xfffe5e8020007950ULL, 0x000fea0003c3ffffULL,
0x000000011f00780cULL, 0x000fe20003f45070ULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000008400007348ULL, 0x000ff60003800000ULL, 0x00000000001f7806ULL, 0x000fc800050e0100ULL,
0x000000841f1f7212ULL, 0x000fe200078ec0ffULL, 0xfffe5e2020007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000200000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000868ULL,
0x0000000000000250ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ab8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b78ULL,
0x00000000000006d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001248ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001258ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012e8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012ecULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x000000000001a280ULL, 0xdf00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b780ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b7c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001bb40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012e8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001a498ULL,
0x000000000001a498ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001b780ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001bb40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_0_m_32_sm_86_cubin_len = 113696;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
