/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001d2c0ULL, 0x000000000001cf40ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL,
0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL,
0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL,
0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL,
0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL,
0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b002200000377ULL, 0x000000000001b6d0ULL, 0x0000000000000170ULL,
0x000b0022000003aaULL, 0x000000000001b840ULL, 0x0000000000000040ULL, 0x000b0022000003d5ULL,
0x000000000001b880ULL, 0x0000000000000050ULL, 0x000b0022000003ffULL, 0x000000000001b8d0ULL,
0x0000000000000130ULL, 0x000a00030000046dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000048dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001ba00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001b6d000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x006c300400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808a0828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808a92ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001b6d000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL, 0xa608288080a50828ULL,
0x288080d208288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080d2ULL,
0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001b84000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL, 0xa508288080a60828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a5920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000016000000000ULL, 0x0001b88000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x80a6288080a50900ULL, 0x0000000000002880ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808a0828808081ULL, 0xa608288080a50828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080a6920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL,
0x0001b8d000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001700082f04ULL,
0x00082304000000dfULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL,
0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001000082304ULL, 0x0008120400000000ULL,
0x0000000000000010ULL, 0x0000001000081104ULL, 0x0008230400000000ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0068016000000014ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000e6000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000038001cc2804ULL, 0x00000570000003a0ULL, 0x0000324000002140ULL, 0x000033e0000032d0ULL,
0x000036c000003550ULL, 0x00003a3000003820ULL, 0x00003a8000003a70ULL, 0x0000441000003ab0ULL,
0x000054b000005410ULL, 0x00005740000055d0ULL, 0x00005a10000058b0ULL, 0x00005c5000005c10ULL,
0x00005c9000005c60ULL, 0x0000733000006330ULL, 0x000074d0000073c0ULL, 0x000077b000007640ULL,
0x00007b1000007910ULL, 0x00007b6000007b50ULL, 0x0000817000007b90ULL, 0x000092d000009230ULL,
0x00009550000093e0ULL, 0x00009820000096c0ULL, 0x00009a5000009a10ULL, 0x00009a9000009a60ULL,
0x0000a1f00000a1e0ULL, 0x0000a2100000a200ULL, 0x0000cfb00000cf80ULL, 0x0000d0900000cfe0ULL,
0x0000dca00000dc70ULL, 0x0000def00000dce0ULL, 0x00018dd000018d90ULL, 0x00018df000018de0ULL,
0x00018e7000018e50ULL, 0x00018e9000018e80ULL, 0x0001a3400001a2e0ULL, 0x0001a4100001a3b0ULL,
0x0001a4d00001a470ULL, 0x0001a5b00001a540ULL, 0x0001a6900001a620ULL, 0x0001a7500001a6f0ULL,
0x0001a8200001a7c0ULL, 0x0001a8e00001a880ULL, 0x0001a9c00001a950ULL, 0x0001aaa00001aa30ULL,
0x0001ab600001ab00ULL, 0x0001ac300001abd0ULL, 0x0001acf00001ac90ULL, 0x0001add00001ad60ULL,
0x0001aeb00001ae40ULL, 0x0001af700001af10ULL, 0x0001b0400001afe0ULL, 0x0001b1000001b0a0ULL,
0x0001b1e00001b170ULL, 0x0001b2c00001b250ULL, 0x0001b3a00001b330ULL, 0x0001b4a00001b420ULL,
0x0001b5a00001b520ULL, 0x0001b6a00001b620ULL, 0x0000045002003904ULL, 0x0001e600000000ffULL,
0x000004a0003f0100ULL, 0x0001e60800000009ULL, 0x000004e0003f0120ULL, 0x0001e68800000009ULL,
0x00000ec0003f0120ULL, 0x0001e600000000ffULL, 0x00001080003f0107ULL, 0x0001e68c0000007cULL,
0x00001130003f0102ULL, 0x0001e6880000007cULL, 0x00002f60003f0101ULL, 0x0001e60800000020ULL,
0x00002f80003f0101ULL, 0x0001e60c00000020ULL, 0x00003150003f0105ULL, 0x0001e60c00000020ULL,
0x000043d0003f0105ULL, 0x0001e6880000001dULL, 0x00005110003f0101ULL, 0x0001e62800000020ULL,
0x00005170003f0101ULL, 0x0001e62c00000020ULL, 0x00005340003f0105ULL, 0x0001e62c00000020ULL,
0x000062b0003f0105ULL, 0x0001e6900000001dULL, 0x00007030003f0101ULL, 0x0001e64800000020ULL,
0x00007090003f0101ULL, 0x0001e64c00000020ULL, 0x00007260003f0105ULL, 0x0001e64c00000020ULL,
0x00008150003f0105ULL, 0x0001e6980000001dULL, 0x00008f30003f0101ULL, 0x0001e66800000020ULL,
0x00008f90003f0101ULL, 0x0001e66c0000004aULL, 0x00009160003f0105ULL, 0x0001e66c0000004aULL,
0x0000a040003f0105ULL, 0x0001e6a00000001dULL, 0x0000fbc0003f0101ULL, 0x0001e600000000ffULL,
0x00011410003f0101ULL, 0x0001e604000000ffULL, 0x00011620003f0105ULL, 0x0001e604000000ffULL,
0x00015f70003f0105ULL, 0x00000000000000a0ULL, 0x00016120003f0101ULL, 0x00000004000000a0ULL,
0x000162f0003f0105ULL, 0x00000004000000a0ULL, 0x0001a130003f0105ULL, 0x0001e608000000a1ULL,
0x0001a190003f0101ULL, 0x0001e610000000a1ULL, 0x0001a1f0003f0101ULL, 0x0001e618000000a1ULL,
0x0001a260003f0101ULL, 0x0001e620000000a1ULL, 0x00033803003f0101ULL, 0x0000eb0000301c04ULL,
0x0000edb00000eb30ULL, 0x0000f1700000ef90ULL, 0x0000f5300000f350ULL, 0x0000f9000000f710ULL,
0x000116800000faa0ULL, 0x000004010001a2a0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000025cULL,
0x0000001700000002ULL, 0x00000000000001ccULL, 0x0000001700000002ULL, 0x000000000000014cULL,
0x0000001700000002ULL, 0x00000000000000ccULL, 0x0000001700000002ULL, 0x0000000000000044ULL,
0x0000001700000002ULL, 0x0000000000000232ULL, 0x0000001700000002ULL, 0x00000000000001a2ULL,
0x0000001700000002ULL, 0x0000000000000127ULL, 0x0000001700000002ULL, 0x00000000000000a8ULL,
0x0000001700000002ULL, 0x000000000001e700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000a57919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x00000001a5020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c00a5040625ULL, 0x000fe200078e0004ULL, 0x00000006020a0981ULL, 0x0002a8000c1e1900ULL,
0x00000006040b0981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff137624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000000c7919ULL, 0x000e620000002300ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff147624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e640000002100ULL,
0x0000590014147a24ULL, 0x000fe200078e02ffULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000864000021f000ULL,
0x000000ffff067224ULL, 0x010fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002600ULL, 0x0000040007077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff027224ULL, 0x000fc800078e0a07ULL, 0x0000040002007624ULL, 0x000fca00078e0213ULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000107072810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07ba12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000f220000209000ULL, 0x000000ff0700720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00027810ULL, 0x010fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0008e4000021f000ULL, 0x000000ffff027224ULL, 0x010fe400078e00ffULL,
0x0000000307047224ULL, 0x008fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x00000006037f7227ULL, 0x002fe400078e00ffULL,
0x0000000000037919ULL, 0x000e640000002200ULL, 0x000000ffff007224ULL, 0x000fc800078e0a7fULL,
0x0000000007007224ULL, 0x000fca00078e0206ULL, 0x000000070000720cULL, 0x000fda0003f66070ULL,
0x0000000100003824ULL, 0x000fe200078e0a07ULL, 0x000000017f7f3810ULL, 0x000fe20007ffe0ffULL,
0x000001000c027a24ULL, 0x002fc600078e0203ULL, 0x000000070000720cULL, 0x000fe20003f86070ULL,
0x0000000002097a24ULL, 0x100fe200078e020dULL, 0x00000005ff007819ULL, 0x000fe4000001160dULL,
0x00001fff0c0d7589ULL, 0x000fe400000e0000ULL, 0x000000ff0900720cULL, 0x040fe40003f25270ULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x0000000f0900780cULL, 0x040fe40003f44070ULL,
0x000000030900780cULL, 0x000fc40003f64070ULL, 0x000000017f7f4810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff7fd212ULL, 0x000fe400078e33ffULL, 0x0000007f0900780cULL, 0x000fe40003f84070ULL,
0x3fffff8000029802ULL, 0x000fe20000000f00ULL, 0x000000ffff9f7224ULL, 0x000fe400078e0a7fULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x0000009f079f7224ULL, 0x000fc400078e0206ULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x01e60002ff009388ULL, 0x0003e20000000a00ULL,
0x000000209f9f7824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05a424ULL, 0x000fe400078e00ffULL,
0xff317217ff0ec424ULL, 0x000fe400078e00ffULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x01e608040900a388ULL, 0x000fe20000008a00ULL, 0x7fffff60ff07b424ULL, 0x000fc400078e00ffULL,
0x000000040d037824ULL, 0x002fe200078e0200ULL, 0x01e4000e0900c388ULL, 0x000fe80000004800ULL,
0x01e688060900b388ULL, 0x0003e40000008a00ULL, 0x0000000403067824ULL, 0x002fe400078e00ffULL,
0x000000010a0a0824ULL, 0x004fe400078e0a0bULL, 0x00005800ff0a8624ULL, 0x000fc400078e00ffULL,
0x00005800a50b8a24ULL, 0x000fe400078e02ffULL, 0x00005a000a087a24ULL, 0x000fe400078e02ffULL,
0x000000140b827224ULL, 0x000fc600078e02ffULL, 0x000000089f027210ULL, 0x000fe20007ffe1ffULL,
0x00005a007f177a24ULL, 0x000fe200078e0282ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000009f0800720cULL, 0x000fe40003f26070ULL, 0x0000002002027817ULL, 0x000fc80003800000ULL,
0x000000ff02817207ULL, 0x000fe20000800000ULL, 0x00000004ff027e24ULL, 0x000fc6000f8e00ffULL,
0x000000208100780cULL, 0x000fda0003f05270ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00005a0000097b06ULL, 0x000e620000209000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000ffff047224ULL, 0x000fcc00078e00ffULL, 0x0000000900097308ULL, 0x002e620000001000ULL,
0x00000004ff077819ULL, 0x004fc80000011603ULL, 0x00000002070e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x0ffffffe09057810ULL, 0x002fc60007ffe0ffULL,
0x0000000106107824ULL, 0x000fc600078e020eULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x000000019f127824ULL, 0x000fe400078e0210ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f05097227ULL, 0x000fc800078e0004ULL,
0x000000019f047824ULL, 0x000fe400078e0208ULL, 0x00000012090f7227ULL, 0x000fc800078e00ffULL,
0x0000000409057227ULL, 0x000fc800078e00ffULL, 0x000000ffff117224ULL, 0x000fe200078e0a0fULL,
0x000000ff05097210ULL, 0x000fc60007ffe1ffULL, 0x00005a00110c7a24ULL, 0x000fe400078e0212ULL,
0x00005a0009097a24ULL, 0x000fc600078e0204ULL, 0x00005a000c007a0cULL, 0x000fe40003f46070ULL,
0x00005a0009007a0cULL, 0x000fd60003f06070ULL, 0x80005a000c0c2a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009090a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000c007a0cULL, 0x000fe40003f66070ULL,
0x00005a0009007a0cULL, 0x000fe40003f26070ULL, 0x0000000105050810ULL, 0x000fe40007ffe0ffULL,
0x000000010f0f2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff0c7a12ULL, 0x000fc600078e33ffULL, 0x000000010f0f3810ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000f0c0f7207ULL, 0x040fe40004000000ULL,
0x000000050c097207ULL, 0x000fe20004000000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0000000681057217ULL, 0x000fe20007800000ULL, 0x000000ffff157224ULL, 0x000fe400078e0a0fULL,
0x000000ffff117224ULL, 0x000fc400078e0a09ULL, 0x00005a0015127a24ULL, 0x000fe400078e0212ULL,
0x00005a0011047a24ULL, 0x000fe400078e0204ULL, 0x0000000117127824ULL, 0x040fe400078e0212ULL,
0x0000000117047824ULL, 0x000fe400078e0204ULL, 0x0000000105057824ULL, 0x000fe400078e0a06ULL,
0x0000001409047224ULL, 0x080fe200078e0204ULL, 0x000000f00c097812ULL, 0x000fe200078ec0ffULL,
0x000000140f067224ULL, 0x000fe200078e0212ULL, 0x000000050700720cULL, 0x080fe20003f06070ULL,
0x00000010080f7824ULL, 0x000fe200078e00ffULL, 0x000000050e00720cULL, 0x000fe20003f26070ULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x00000001080e7824ULL, 0x100fe200078e0203ULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x0000000110087824ULL, 0x040fe200078e0203ULL,
0x0000000410097819ULL, 0x000fe400000006ffULL, 0xfffffff00f0e7812ULL, 0x000fe400078ee20eULL,
0x0000600004047a10ULL, 0x000fe40007f5e0ffULL, 0xfffffff009087812ULL, 0x000fe200078ee208ULL,
0x000000100e097824ULL, 0x000fe200078e00ffULL, 0x0000600006067a10ULL, 0x000fc40007f7e0ffULL,
0x0000610005057a10ULL, 0x000fe200017fe4ffULL, 0x00000010080f7824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc60001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000c101c46ULL, 0x00000000060f7faeULL, 0x0003e2000c901c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x00005a0000077b06ULL, 0x000e620000209000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fcc00078e00ffULL,
0x0000000700077308ULL, 0x002e620000001000ULL, 0x0000000603087211ULL, 0x004fc800078fe0ffULL,
0x00000002080e7810ULL, 0x040fe20007ffe0ffULL, 0x0000001008107824ULL, 0x000fe200078e00ffULL,
0x0ffffffe07097810ULL, 0x002fc60007ffe0ffULL, 0x000000019f077824ULL, 0x000fe200078e020eULL,
0x0000000900057305ULL, 0x000e64000021f000ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a05ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f050f7227ULL, 0x000fc800078e0004ULL,
0x000000019f047824ULL, 0x000fe400078e0208ULL, 0x000000070f097227ULL, 0x000fc800078e00ffULL,
0x000000040f057227ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a09ULL, 0x00005a000f067a24ULL, 0x000fe400078e0204ULL,
0x00005a000c0c7a24ULL, 0x000fc600078e0207ULL, 0x00005a0006007a0cULL, 0x000fe40003f06070ULL,
0x00005a000c007a0cULL, 0x000fd60003f46070ULL, 0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL,
0x80005a000c0c2a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x00005a000c007a0cULL, 0x000fe20003f66070ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000000109092810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000109093810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000906097207ULL, 0x000fc60004000000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a05ULL, 0x000000ffff067224ULL, 0x000fe400078e0a09ULL,
0x00005a000f047a24ULL, 0x000fe200078e0204ULL, 0x000000f00c0f7812ULL, 0x000fe200078ec0ffULL,
0x00005a0006077a24ULL, 0x000fc600078e0207ULL, 0x0000000417047210ULL, 0x040fe20007ffe0ffULL,
0x0000000117067824ULL, 0x000fc800078e0207ULL, 0x0000001405047224ULL, 0x080fe400078e0204ULL,
0x0000001409067224ULL, 0x000fe400078e0206ULL, 0x0000010004047825ULL, 0x000fc800078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000f04047212ULL, 0x000fc600078efcffULL,
0x0000000108097824ULL, 0x100fe200078e0203ULL, 0x0000000f06067212ULL, 0x000fe200078efcffULL,
0x000000010e087824ULL, 0x000fe200078e0203ULL, 0x0000600004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff010097812ULL, 0x000fe400078ee209ULL,
0x0000600006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00f087812ULL, 0x000fe200078ee208ULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x0000610005057a10ULL, 0x000fc400007fe4ffULL,
0x0000610007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080f7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000b901c46ULL,
0x00000000060f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000067919ULL, 0x002e620000000000ULL,
0x0000000000047806ULL, 0x000fe200038e0000ULL, 0x00000004ff9a7424ULL, 0x000fc600078e00ffULL,
0x0000000400057300ULL, 0x000e6200000e0000ULL, 0x00006800a5087625ULL, 0x000fce00078e009aULL,
0x0000000400077309ULL, 0x000ea20000000000ULL, 0x000000060500720cULL, 0x002fe40003f02070ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff057224ULL, 0x004fd400078e0a07ULL,
0x01e60405ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608047981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0d00720cULL, 0x000fe40003f05270ULL, 0x0000003f04057810ULL, 0x046fe40007ffe0ffULL,
0x000000ff04067810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff057819ULL, 0x000fe40000011605ULL,
0x00000008ff067819ULL, 0x000fca0000011606ULL, 0x0000eaf000008947ULL, 0x000fea0003800000ULL,
0x00000002ff7d7819ULL, 0x000fe20000011600ULL, 0x00000008007c7824ULL, 0x000fe400078e00ffULL,
0x00000003ff097424ULL, 0x000fe200078e00ffULL, 0x03ffffff7d077812ULL, 0x000fc800078ec0ffULL,
0x00000007022c7211ULL, 0x000fc800078e10ffULL, 0x000000052c00720cULL, 0x000fda0003f06070ULL,
0x00000002a5078824ULL, 0x000fe400078e00ffULL, 0x00006a00ff088624ULL, 0x000fc800078e00ffULL,
0x00006a0007078624ULL, 0x000fe400078e0208ULL, 0xffffffffff087424ULL, 0x000fe400078e00ffULL,
0x000000012c078824ULL, 0x000fe200078e0207ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e68c097cff738cULL, 0x0003e20000000000ULL, 0x00006600070a8625ULL, 0x000fe200078e009aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a088981ULL, 0x000ea2000c1e1900ULL,
0x00000001020d7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff0e7424ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011600ULL, 0x01e688007cff7f8cULL, 0x0007e2000c80043fULL,
0x000000060d00720cULL, 0x000fc60003f06070ULL, 0x00000020077e7824ULL, 0x000fc800078e00ffULL,
0x00000100020f7824ULL, 0x000fe400078e027eULL, 0x0000590008097a24ULL, 0x006fe400078e02ffULL,
0x000000407f087824ULL, 0x000fc600078e00ffULL, 0x00000006090d7819ULL, 0x000fe400000006ffULL,
0x0000000100097812ULL, 0x000fe400078ec0ffULL, 0x0000002008257812ULL, 0x000fe200078ef80fULL,
0x000064000d0a7625ULL, 0x000fe200078e000eULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1a7819ULL, 0x008fe20000011603ULL, 0x00000002071d7824ULL, 0x000fe200078e0209ULL,
0x0000000f040d7217ULL, 0x000fe40007800000ULL, 0x000000041a0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c1a187810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0fULL,
0x000000700c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000010e0f7824ULL, 0x100fe200078e0203ULL,
0x000000081a127810ULL, 0x000fe20007ffe0ffULL, 0x000000080e1e7824ULL, 0x000fe200078e00ffULL,
0x000000200d1b7817ULL, 0x000fe20003800000ULL, 0x0000000118117824ULL, 0x040fe200078e0203ULL,
0x000000ff000d7202ULL, 0x000fe20000000f00ULL, 0x0000000818227824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL, 0x00000080090c7824ULL, 0x000fe200078e020cULL,
0x0000001b0e00720cULL, 0x080fe20003f86070ULL, 0x00000001250f7824ULL, 0x040fe200078e021aULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000000112107824ULL, 0x000fe200078e0203ULL,
0x000000141a267810ULL, 0x000fe20007ffe0ffULL, 0x0000000812137824ULL, 0x000fe200078e00ffULL,
0x000000101a1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125117824ULL, 0x000fe200078e020eULL,
0x0000001b1200720cULL, 0x000fe20003f66070ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0xfffffff813207812ULL, 0x000fc400078ee210ULL, 0x0000001b1800720cULL, 0x080fe20003f46070ULL,
0x0000010011107825ULL, 0x000fe200078e000cULL, 0x0000000e0a147210ULL, 0x000fe40007f1e0ffULL,
0x0000001b1a00720cULL, 0x000fe20003fa6070ULL, 0x0000000126157824ULL, 0x100fe200078e0203ULL,
0x000000100a167210ULL, 0x000fe20007f3e0ffULL, 0x0000000826287824ULL, 0x000fe200078e00ffULL,
0x000160001d1d7811ULL, 0x000fe200078e68ffULL, 0x000000011c137824ULL, 0x040fe400078e0203ULL,
0x000000081c247824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee215ULL,
0x000000010b157824ULL, 0x000fc400000e060fULL, 0x00000001250f7824ULL, 0x000fe200078e0212ULL,
0xfffffff824247812ULL, 0x000fe200078ee213ULL, 0x000000010b177824ULL, 0x000fe200008e0611ULL,
0x0000001c25137210ULL, 0x040fe20007ffe0ffULL, 0x0000000125117824ULL, 0x000fe200078e0218ULL,
0x0000001b1c00720cULL, 0x000fe20003f26070ULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x000000011a127824ULL, 0x000fe200078e0203ULL, 0x0000000e0a187210ULL, 0x000fe20007f1e0ffULL,
0x0000010011107825ULL, 0x000fc600078e000cULL, 0x00000007121c7812ULL, 0x000fe200078ec0ffULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x000000100a107210ULL, 0x000fe40007fde0ffULL,
0x0ffffff81c1c7812ULL, 0x000fe200078ef803ULL, 0x000000010b197824ULL, 0x000fe200000e060fULL,
0x0000001b2600720cULL, 0x000fe20003f06070ULL, 0x00000001250f7824ULL, 0x000fe400078e0226ULL,
0x000000010b117824ULL, 0x000fe200030e0611ULL, 0x000000120a127210ULL, 0x000fe20007fde0ffULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x000000101c1f7824ULL, 0x100fe200078e021dULL,
0x000000181a1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101e217824ULL, 0x000fe200078e021dULL,
0x0000001c1a1e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b137824ULL, 0x000fe200030e0613ULL,
0x0000000e0a1a7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0003e2000e901c46ULL, 0x0000000125237824ULL, 0x040fe200078e021cULL,
0x0000001b1c00720cULL, 0x080fe20003fa6070ULL, 0x0000000125257824ULL, 0x000fe200078e021eULL,
0x0000000016217faeULL, 0x0005e2000e101c46ULL, 0x0000001b1e00720cULL, 0x000fe20003f86070ULL,
0x000000010b1b7824ULL, 0x000fc400030e060fULL, 0x00000100230e7825ULL, 0x000fc800078e000cULL,
0x000000011c147824ULL, 0x102fe200078e0203ULL, 0x0000000e0a0e7210ULL, 0x000fe20007fde0ffULL,
0x000000011e157824ULL, 0x000fe200078e0203ULL, 0x000000031c1f7819ULL, 0x000fe200000006ffULL,
0x000000081e167824ULL, 0x004fe400078e00ffULL, 0x00000100250c7825ULL, 0x000fe200078e000cULL,
0xfffffff81f147812ULL, 0x000fe400078ee214ULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x000000010b0f7824ULL, 0x000fe200030e060fULL, 0x0000000c0a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001020157824ULL, 0x000fc400078e021dULL, 0x0000001022177824ULL, 0x100fe400078e021dULL,
0x00000010241f7824ULL, 0x100fe200078e021dULL, 0x0000000018157faeULL, 0x0003e2000d901c46ULL,
0x0000001028217824ULL, 0x100fe400078e021dULL, 0x0000001014237824ULL, 0x100fe200078e021dULL,
0x0000000010177faeULL, 0x0003e2000d101c46ULL, 0x00000010161d7824ULL, 0x000fe400078e021dULL,
0x000000010b0b7824ULL, 0x000fe200030e060dULL, 0x00000000121f7faeULL, 0x0003e8000c901c46ULL,
0x000000001a217faeULL, 0x0003e8000c101c46ULL, 0x000000000e237faeULL, 0x0003e8000e901c46ULL,
0x000000000a1d7faeULL, 0x0003e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x00000004030e7811ULL, 0x008fe200078fe8ffULL, 0x00000002071b7824ULL, 0x000fe200078e0209ULL,
0x0000000803107811ULL, 0x000fc400078fe8ffULL, 0x000000030e0d7210ULL, 0x0c0fe20007ffe0ffULL,
0x000000080e1e7824ULL, 0x000fe200078e00ffULL, 0x0000000c03127811ULL, 0x040fe200078fe8ffULL,
0x00000001100f7824ULL, 0x040fe200078e0203ULL, 0x0000001003147811ULL, 0x040fe200078fe8ffULL,
0x0000000810207824ULL, 0x000fe200078e00ffULL, 0x0000001403167811ULL, 0x040fe200078fe8ffULL,
0x0000000812227824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL,
0x00000001120d7824ULL, 0x000fe200078e0203ULL, 0xfffffff820207812ULL, 0x000fe200078ee20fULL,
0x00000001140f7824ULL, 0x140fe200078e0203ULL, 0x0000001803187811ULL, 0x040fe200078fe8ffULL,
0x0000000814247824ULL, 0x000fe200078e00ffULL, 0x000000700c1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000116117824ULL, 0x140fe200078e0203ULL, 0x00000003030c7211ULL, 0x040fe200078fe8ffULL,
0x0000000816267824ULL, 0x000fe200078e00ffULL, 0x0000001c031c7811ULL, 0x000fe200078fe8ffULL,
0x0000000118137824ULL, 0x040fe200078e0203ULL, 0x0000000318287819ULL, 0x000fe200000006ffULL,
0x00000080091a7824ULL, 0x000fe200078e021aULL, 0xfffffff822227812ULL, 0x000fe200078ee20dULL,
0x000000081c1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x00000001250f7824ULL, 0x000fe200078e020eULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000011c0e7824ULL, 0x000fe200078e0203ULL, 0x00000025030d7211ULL, 0x000fe200078fe8ffULL,
0x0000000125157824ULL, 0x000fe200078e0214ULL, 0x000160001b2b7811ULL, 0x000fe200078e68ffULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee211ULL,
0x0000000125117824ULL, 0x040fe200078e0210ULL, 0xfffffff828287812ULL, 0x000fe200078ee213ULL,
0x0000000125137824ULL, 0x040fe200078e0212ULL, 0x0000001c251d7210ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e001aULL, 0x0ffffff80c1c7812ULL, 0x000fc400078ef803ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee20eULL, 0x000001000d0c7825ULL, 0x000fe200078e001aULL,
0x000000100a107210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e001aULL,
0x0000000c0a0c7210ULL, 0x000fc60007f1e0ffULL, 0x0000000125177824ULL, 0x000fe200078e0216ULL,
0x0000000e0a0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010013127825ULL, 0x000fc600078e001aULL,
0x0000000f0b0f7210ULL, 0x000fe20000ffe4ffULL, 0x0000000125197824ULL, 0x000fe200078e0218ULL,
0x000000120a127210ULL, 0x000fe20007f7e0ffULL, 0x0000010015147825ULL, 0x000fc800078e001aULL,
0x0000010017167825ULL, 0x000fc800078e001aULL, 0x0000010019187825ULL, 0x000fe200078e001aULL,
0x000000160a167210ULL, 0x000fc60007f3e0ffULL, 0x000001001d1a7825ULL, 0x000fc800078e001aULL,
0x000000010b0d7824ULL, 0x040fe200000e060dULL, 0x000000140a147210ULL, 0x000fe20007f1e0ffULL,
0x000000101c1d7824ULL, 0x000fe400078e022bULL, 0x000000010b117824ULL, 0x040fe200010e0611ULL,
0x000000180a187210ULL, 0x000fe20007f5e0ffULL, 0x000000101e1f7824ULL, 0x000fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1d7faeULL, 0x0003e2000b901c46ULL,
0x000000010b137824ULL, 0x000fe200018e0613ULL, 0x0000001a0a0a7210ULL, 0x000fe20007f7e0ffULL,
0x0000001020217824ULL, 0x100fe200078e022bULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001022237824ULL, 0x000fc400078e022bULL, 0x0000001024257824ULL, 0x000fe200078e022bULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x000000010b157824ULL, 0x040fe400000e0615ULL,
0x0000001026277824ULL, 0x000fe200078e022bULL, 0x0000000012237faeULL, 0x0003e2000b901c46ULL,
0x000000010b177824ULL, 0x040fe400008e0617ULL, 0x0000001028297824ULL, 0x000fe200078e022bULL,
0x0000000014257faeULL, 0x0003e2000b901c46ULL, 0x000000010b197824ULL, 0x000fc400010e0619ULL,
0x000000102a2b7824ULL, 0x000fe200078e022bULL, 0x0000000016277faeULL, 0x0003e2000b901c46ULL,
0x000000010b0b7824ULL, 0x000fc600018e061bULL, 0x0000000018297faeULL, 0x0003e8000b901c46ULL,
0x000000000a2b7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff837624ULL, 0x000fe200078e00ffULL,
0x000000032c0a7812ULL, 0x002fe200078ec0ffULL, 0xffffffffff1e7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffffd9a837424ULL, 0x000fe200078e0283ULL,
0x000000030a00780cULL, 0x000fc80003f05270ULL, 0x00000001831f7807ULL, 0x000fca0004000000ULL,
0x000000012c1f7824ULL, 0x000fca00078e021fULL, 0x000000051f00720cULL, 0x000fda0003f06070ULL,
0x00000002a50a8824ULL, 0x000fe400078e00ffULL, 0x00006a00ff0b8624ULL, 0x000fc800078e00ffULL,
0x00006a000a0a8624ULL, 0x000fca00078e020bULL, 0x0000001f0a9b8210ULL, 0x000fca0007ffe0ffULL,
0x000066009b9a8625ULL, 0x000fca00078e009aULL, 0x000000069a1e8981ULL, 0x000322000c1e1900ULL,
0x000000060200720cULL, 0x000fe20003f06070ULL, 0xff317217ff687424ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x00007fb000000947ULL, 0x000fea0003800000ULL,
0x00000002a50a7824ULL, 0x002fe400078e00ffULL, 0x00006a00ff0b7624ULL, 0x000fc400078e00ffULL,
0xff317217ff687424ULL, 0x000fe400078e00ffULL, 0x000000ffff2b7224ULL, 0x000fe400078e00ffULL,
0x00006a000a0a7624ULL, 0x000fc400078e020bULL, 0x00000010000b7824ULL, 0x000fe200078e00ffULL,
0x0000000102117810ULL, 0x000fe20007ffe0ffULL, 0x000059001e1e7a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe00b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000100ff137424ULL, 0x000fe200078e00ffULL, 0x000000061100720cULL, 0x000fe40003f06070ULL,
0x000000061e127819ULL, 0x000fe200000006ffULL, 0x00000100020b7824ULL, 0x000fc800078e020bULL,
0x0000640012127625ULL, 0x000fe200078e0013ULL, 0x000000400b157810ULL, 0x020fc80007ffe0ffULL,
0x00000020150b7812ULL, 0x000fca00078ec0ffULL, 0x00000001081e7824ULL, 0x000fe200078e020bULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x00000003ff227819ULL, 0x100fe20000011603ULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x00000015040b7217ULL, 0x000fe20007800000ULL,
0x0000008000147824ULL, 0x000fe200078e00ffULL, 0x0000000822207810ULL, 0x040fe20007ffe0ffULL,
0x0000000122187824ULL, 0x040fe200078e0203ULL, 0x0000007011177812ULL, 0x000fe200078ec0ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a15ULL, 0x0000001022707810ULL, 0x000fe20007ffe0ffULL,
0x0000200000117824ULL, 0x000fe200078e00ffULL, 0x0000001422747810ULL, 0x000fe20007ffe0ffULL,
0x0000000120157824ULL, 0x000fe200078e0203ULL, 0x00000004221a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008206c7824ULL, 0x000fe200078e00ffULL, 0x0000200011167812ULL, 0x000fe200078ec0ffULL,
0x0000000870727824ULL, 0x000fe200078e00ffULL, 0x0000008017147812ULL, 0x000fe200078ef814ULL,
0x0000000874197824ULL, 0x000fe200078e00ffULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee215ULL,
0x0000000170157824ULL, 0x100fe200078e0203ULL, 0x0000000c22247810ULL, 0x000fe20007ffe0ffULL,
0x0000400007077824ULL, 0x000fe200078e0216ULL, 0x000000200b0b7817ULL, 0x000fe20003800000ULL,
0x0000000174167824ULL, 0x000fe200078e0203ULL, 0xfffffff872727812ULL, 0x000fe200078ee215ULL,
0x000000011a117824ULL, 0x000fe200078e0203ULL, 0x0000000b2000720cULL, 0x000fe20003f06070ULL,
0x000000081a6a7824ULL, 0x000fe200078e00ffULL, 0xfffffff819767812ULL, 0x000fe200078ee216ULL,
0x0000000122177824ULL, 0x000fe200078e021eULL, 0x0000001e241b7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee211ULL,
0x00000008246e7824ULL, 0x040fe200078e00ffULL, 0x0000000324117210ULL, 0x000fe20007ffe0ffULL,
0x0000010017167825ULL, 0x000fe200078e0014ULL, 0x0000000718267812ULL, 0x000fc400078ec0ffULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee211ULL, 0x000000011a117824ULL, 0x100fe200078e021eULL,
0x00000016121c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000120197824ULL, 0x000fe200078e021eULL,
0x0000000b2200720cULL, 0x080fe40003f86070ULL, 0x0000000b1a00720cULL, 0x080fe20003f66070ULL,
0x00000001131d7824ULL, 0x000fe200010e0617ULL, 0x0000000b2400720cULL, 0x000fe20003f26070ULL,
0x0000010011167825ULL, 0x000fe200078e0014ULL, 0x0001700007077810ULL, 0x000fc40007ffe0ffULL,
0x0ffffff826267812ULL, 0x000fe200078ef803ULL, 0x0000010019187825ULL, 0x000fe200078e0014ULL,
0x0000001612207210ULL, 0x000fc60007f5e0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0014ULL,
0x0000001812247210ULL, 0x000fc60007fbe0ffULL, 0x0000000113217824ULL, 0x000fe200010e0617ULL,
0x0000001a121a7210ULL, 0x000fe20007fde0ffULL, 0x0000000170177824ULL, 0x040fe200078e021eULL,
0x0000000b7000720cULL, 0x000fe20003f46070ULL, 0x0000001026117824ULL, 0x000fe400078e0207ULL,
0x0000010017167825ULL, 0x000fc600078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c117faeULL, 0x0003e2000e101c46ULL, 0x0000000113257824ULL, 0x040fe200028e0619ULL,
0x0000000b7400720cULL, 0x080fe20003fa6070ULL, 0x000000106a697824ULL, 0x000fe200078e0207ULL,
0x00000018226a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000174197824ULL, 0x000fe200078e021eULL,
0x0000001c22227810ULL, 0x000fe20007ffe0ffULL, 0x00000001131b7824ULL, 0x000fe200030e061bULL,
0x0000001612267210ULL, 0x000fe20007fde0ffULL, 0x0000000020697faeULL, 0x0005e2000d901c46ULL,
0x0000010019187825ULL, 0x000fe200078e0014ULL, 0x0000000b6a00720cULL, 0x000fc40003f86070ULL,
0x0000000b2200720cULL, 0x000fe20003f66070ULL, 0x000000016a0b7824ULL, 0x000fe200078e021eULL,
0x0000001e22117210ULL, 0x002fe20007ffe0ffULL, 0x0000000113277824ULL, 0x000fe200030e0617ULL,
0x0000001812187210ULL, 0x000fe20007fde0ffULL, 0x000001000b167825ULL, 0x000fc800078e0014ULL,
0x0000000113197824ULL, 0x000fe200030e0619ULL, 0x0000001612167210ULL, 0x000fe20007fde0ffULL,
0x00000001220b7824ULL, 0x140fe400078e0203ULL, 0x00000008221e7824ULL, 0x000fe400078e00ffULL,
0x000000016a1c7824ULL, 0x040fe400078e0203ULL, 0x000000086a1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x0000010011147825ULL, 0x000fc600078e0014ULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee21cULL, 0x0000000113177824ULL, 0x040fe200030e0617ULL,
0x0000001412127210ULL, 0x000fe20007fde0ffULL, 0x000000106c0b7824ULL, 0x100fe200078e0207ULL,
0x000000071c697211ULL, 0x004fe200078e20ffULL, 0x000000106e117824ULL, 0x100fe400078e0207ULL,
0x00000010721d7824ULL, 0x100fe200078e0207ULL, 0x00000000240b7faeULL, 0x0003e2000c101c46ULL,
0x0000001076217824ULL, 0x100fe400078e0207ULL, 0x000000101e077824ULL, 0x000fe200078e0207ULL,
0x000000001a117faeULL, 0x0003e2000c901c46ULL, 0x0000000113137824ULL, 0x000fc600030e0615ULL,
0x00000000261d7faeULL, 0x0003e8000d101c46ULL, 0x0000000018217faeULL, 0x0003e8000e901c46ULL,
0x0000000016697faeULL, 0x0003e8000e101c46ULL, 0x0000000012077faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x00000010030b7824ULL, 0x040fe200078e00ffULL,
0x0000000803197811ULL, 0x040fe200078fe8ffULL, 0x0000200000117824ULL, 0x040fe200078e00ffULL,
0x0000000403177811ULL, 0x000fe200078fe8ffULL, 0x0000008000267824ULL, 0x000fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000819187824ULL, 0x000fe200078e00ffULL,
0x0000200011147812ULL, 0x000fe200078ec0ffULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0x000000800b267812ULL, 0x000fe200078ef826ULL, 0x00000001190b7824ULL, 0x100fe200078e0203ULL,
0x0000000c031b7811ULL, 0x000fe200078fe8ffULL, 0x0000400007117824ULL, 0x000fe200078e0214ULL,
0x0000001403217811ULL, 0x000fe200078fe8ffULL, 0x0000000117077824ULL, 0x000fe200078e0203ULL,
0x00000010031d7811ULL, 0x000fe200078fe8ffULL, 0x000000081b6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8186b7812ULL, 0x000fe200078ee20bULL, 0x00000001210b7824ULL, 0x000fe200078e0203ULL,
0x000000031b147210ULL, 0x080fe20007ffe0ffULL, 0x0000000821187824ULL, 0x000fe200078e00ffULL,
0xfffffff816697812ULL, 0x000fe200078ee207ULL, 0x000000011d077824ULL, 0x000fe200078e0203ULL,
0x0000001803257811ULL, 0x000fe200078fe8ffULL, 0x000000081d167824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee214ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0xfffffff818717812ULL, 0x000fe200078ee20bULL, 0x0000000125147824ULL, 0x040fe200078e0203ULL,
0xfffffff8166f7812ULL, 0x000fe200078ee207ULL, 0x0000000825737824ULL, 0x000fe200078e00ffULL,
0x0000001c030b7811ULL, 0x000fe200078fe8ffULL, 0x0000000117177824ULL, 0x100fe200078e021eULL,
0x0000000303077211ULL, 0x000fe200078fe8ffULL, 0x0000000119197824ULL, 0x000fe200078e021eULL,
0xfffffff873737812ULL, 0x000fe200078ee214ULL, 0x000000010b167824ULL, 0x100fe200078e0203ULL,
0x0000000707147812ULL, 0x000fe200078ec0ffULL, 0x000000080b757824ULL, 0x000fe200078e00ffULL,
0x0000001e03157211ULL, 0x080fe200078fe8ffULL, 0x000000010b077824ULL, 0x100fe200078e021eULL,
0x0ffffff8140b7812ULL, 0x000fe200078ef803ULL, 0x000000011b1b7824ULL, 0x000fe200078e021eULL,
0xfffffff875757812ULL, 0x000fe200078ee216ULL, 0x0000010015147825ULL, 0x000fe200078e0026ULL,
0x0000001e1d1d7210ULL, 0x000fc60007ffe0ffULL, 0x0000010017167825ULL, 0x000fe200078e0026ULL,
0x0000001412147210ULL, 0x000fc60007f1e0ffULL, 0x0000010019187825ULL, 0x000fe200078e0026ULL,
0x0000001612167210ULL, 0x000fc60007f3e0ffULL, 0x0000000121217824ULL, 0x100fe200078e021eULL,
0x0000001812187210ULL, 0x000fe20007f5e0ffULL, 0x0000000125257824ULL, 0x000fe200078e021eULL,
0x00017000111e7810ULL, 0x000fe20007ffe0ffULL, 0x000001001b1a7825ULL, 0x000fc800078e0026ULL,
0x000001001d1c7825ULL, 0x000fe200078e0026ULL, 0x0000001a121a7210ULL, 0x000fc60007f7e0ffULL,
0x0000010021207825ULL, 0x000fc800078e0026ULL, 0x0000010025247825ULL, 0x000fc800078e0026ULL,
0x0000010007267825ULL, 0x000fc800078e0026ULL, 0x0000000113157824ULL, 0x040fe200000e0615ULL,
0x0000001c121c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000113177824ULL, 0x000fe200008e0617ULL,
0x0000002012207210ULL, 0x040fe20007f3e0ffULL, 0x000000100b077824ULL, 0x100fe400078e021eULL,
0x0000000113197824ULL, 0x000fe200010e0619ULL, 0x0000002412247210ULL, 0x040fe20007f5e0ffULL,
0x00000010690b7824ULL, 0x100fe200078e021eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014077faeULL, 0x0003e2000b901c46ULL, 0x000000106b117824ULL, 0x100fe200078e021eULL,
0x0000001e6f6b7211ULL, 0x000fe200078e20ffULL, 0x00000001131b7824ULL, 0x000fe200018e061bULL,
0x0000002612127210ULL, 0x000fe20007f7e0ffULL, 0x000000106d697824ULL, 0x000fe200078e021eULL,
0x00000000160b7faeULL, 0x0003e2000b901c46ULL, 0x00000001131d7824ULL, 0x000fc400000e061dULL,
0x00000010716d7824ULL, 0x100fe200078e021eULL, 0x0000000018117faeULL, 0x0003e2000b901c46ULL,
0x0000000113217824ULL, 0x000fe400008e0621ULL, 0x00000010736f7824ULL, 0x100fe200078e021eULL,
0x000000001a697faeULL, 0x0003e2000b901c46ULL, 0x0000000113257824ULL, 0x040fe200010e0625ULL,
0x0000002713137210ULL, 0x000fe20001ffe4ffULL, 0x0000001075717824ULL, 0x000fe200078e021eULL,
0x000000001c6b7faeULL, 0x0003e8000b901c46ULL, 0x00000000206d7faeULL, 0x0003e8000b901c46ULL,
0x00000000246f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012717faeULL, 0x0003e4000b901c46ULL,
0x000000031f077812ULL, 0x002fe200078ec0ffULL, 0xffffffffff1d7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000030700780cULL, 0x000fc80003f05270ULL,
0x0000000183127807ULL, 0x000fca0004000000ULL, 0x00000001121f7824ULL, 0x000fca00078e021fULL,
0x000000051f00720cULL, 0x000fda0003f06070ULL, 0x000000010a128824ULL, 0x000fe400078e021fULL,
0x00000004ff138424ULL, 0x000fc800078e00ffULL, 0x0000660012128625ULL, 0x000fca00078e0013ULL,
0x00000006121d8981ULL, 0x000322000c1e1900ULL, 0xffffffe07c207812ULL, 0x040fe400078ec0ffULL,
0x000000107c077812ULL, 0x040fe400078ec0ffULL, 0x000000087c0b7812ULL, 0x000fc800078ec0ffULL,
0x000000200b207210ULL, 0x000fe20007ffe007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6080020167f8cULL, 0x0022a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01e60c0020077984ULL, 0x000ee40000000800ULL, 0x8000000007ff7812ULL, 0x00cfe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc80000011415ULL,
0x0000001407077211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000207077819ULL, 0x000fc80000001214ULL, 0x000000070000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60c0020077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff807819ULL, 0x000fc80000011603ULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c80807812ULL, 0x000fc600078ec0ffULL,
0x000000807d077824ULL, 0x000fc800078e020bULL, 0x0000000107077824ULL, 0x000fca00078e0280ULL,
0x01e0000007117984ULL, 0x000ea80000000800ULL, 0x01e2000007127984ULL, 0x0006620000000800ULL,
0x000000681100720bULL, 0x004fe20003f1d000ULL, 0x000170727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x008fc800000e0100ULL, 0x000000ff1300720cULL, 0x000fe20003f25270ULL,
0x0000074000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff077224ULL, 0x000fd400078e0068ULL, 0x0000070000009947ULL, 0x000fea0003800000ULL,
0x000000007d00720cULL, 0x000fe40003f25270ULL, 0x000000681100720bULL, 0x000fe20003f54000ULL,
0x000170427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x0000008000159824ULL, 0x000fe200078e020bULL, 0x0000006811077209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000180169824ULL, 0x000fca00078e0215ULL,
0x01e4000716009388ULL, 0x0005e20000000800ULL, 0x000000ff1400720cULL, 0x000fda0003f25270ULL,
0x000005e000009947ULL, 0x000fea0003800000ULL, 0x0000006807157221ULL, 0x004fe20000010100ULL,
0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b15157820ULL, 0x000fcc0000410000ULL, 0x0000001500157308ULL, 0x000ea40000000800ULL,
0x0000001523237220ULL, 0x004fe40000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x000fe20000011603ULL, 0x00016f927f007947ULL, 0x000fea000b800000ULL,
0x00001f2415247589ULL, 0x0004e400000e0000ULL, 0x0000002464647220ULL, 0x08cfe40000410000ULL,
0x0000002465657220ULL, 0x080fe40000410000ULL, 0x0000002460607220ULL, 0x080fe40000410000ULL,
0x0000002461617220ULL, 0x000fc40000410000ULL, 0x000000245c5c7220ULL, 0x080fe40000410000ULL,
0x000000245d5d7220ULL, 0x080fe40000410000ULL, 0x0000002458587220ULL, 0x080fe40000410000ULL,
0x0000002459597220ULL, 0x080fe40000410000ULL, 0x0000002454547220ULL, 0x080fe40000410000ULL,
0x0000002455557220ULL, 0x000fc40000410000ULL, 0x0000002450507220ULL, 0x080fe40000410000ULL,
0x0000002451517220ULL, 0x080fe40000410000ULL, 0x000000244c4c7220ULL, 0x080fe40000410000ULL,
0x000000244d4d7220ULL, 0x080fe40000410000ULL, 0x0000002448487220ULL, 0x080fe40000410000ULL,
0x0000002449497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0014ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000000803247811ULL, 0x000fe200078ff0ffULL,
0x00016e827f007947ULL, 0x000fea000b800000ULL, 0x00001f2415247589ULL, 0x0004e400000e0000ULL,
0x0000002466667220ULL, 0x08cfe40000410000ULL, 0x0000002467677220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x080fe40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x000fc40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x000fc40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000014ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001003247811ULL, 0x000fe200078ff0ffULL, 0x00016d727f007947ULL, 0x000fea000b800000ULL,
0x00001f2415247589ULL, 0x0004e400000e0000ULL, 0x0000002444447220ULL, 0x08cfe40000410000ULL,
0x0000002445457220ULL, 0x080fe40000410000ULL, 0x0000002440407220ULL, 0x080fe40000410000ULL,
0x0000002441417220ULL, 0x080fe40000410000ULL, 0x000000243c3c7220ULL, 0x080fe40000410000ULL,
0x000000243d3d7220ULL, 0x000fc40000410000ULL, 0x0000002438387220ULL, 0x080fe40000410000ULL,
0x0000002439397220ULL, 0x080fe40000410000ULL, 0x0000002434347220ULL, 0x080fe40000410000ULL,
0x0000002435357220ULL, 0x080fe40000410000ULL, 0x0000002430307220ULL, 0x080fe40000410000ULL,
0x0000002431317220ULL, 0x000fc40000410000ULL, 0x000000242c2c7220ULL, 0x080fe40000410000ULL,
0x000000242d2d7220ULL, 0x080fe40000410000ULL, 0x0000002428287220ULL, 0x080fe40000410000ULL,
0x0000002429297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000014ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001803247811ULL, 0x000fe200078ff0ffULL, 0x00016c727f007947ULL, 0x000fea000b800000ULL,
0x00001f2415247589ULL, 0x0004e400000e0000ULL, 0x0000002446467220ULL, 0x08cfe40000410000ULL,
0x0000002447477220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x080fe40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x000fc40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x000fc40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000001413ff7212ULL, 0x000fda00078230ffULL, 0x8000000711111221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b11111820ULL, 0x000fc80000410000ULL,
0x00000011000c1308ULL, 0x000ea40000000800ULL, 0x0000000c12121220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002312237221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000cff0d723eULL, 0x000fe400000010ffULL,
0x00000002ff107819ULL, 0x000fe40000011603ULL, 0x000054100d117816ULL, 0x000fe2000000000dULL,
0x00016ac27f007947ULL, 0x000fea000b800000ULL, 0x00001f10110d7589ULL, 0x0002a400000e0000ULL,
0x0000000810247810ULL, 0x000fe20007ffe0ffULL, 0x00016b127f007947ULL, 0x000fea000b800000ULL,
0x0000001010127810ULL, 0x000fe20007ffe0ffULL, 0x00001f24110e7589ULL, 0x00066800000e0000ULL,
0x00001f12110f7589ULL, 0x0006a400000e0000ULL, 0x0000001810247810ULL, 0x008fe20007ffe0ffULL,
0x00016ba27f007947ULL, 0x000fea000b800000ULL, 0x00001f2411107589ULL, 0x0022e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200217824ULL, 0x040fe200078e00ffULL,
0x0000000803127812ULL, 0x000fe200078ec0ffULL, 0x00002000001e7824ULL, 0x000fe200078e00ffULL,
0x000120007d787811ULL, 0x000fe200078e60ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000421227812ULL, 0x000fe200078ec0ffULL, 0x0000029000007945ULL, 0x000fe20003800000ULL,
0x00000007121c7812ULL, 0x000fc400078ef803ULL, 0x0000002203117211ULL, 0x042fe400078fe0ffULL,
0x000000101c7a7812ULL, 0x040fe200078efcffULL, 0x000000081c177824ULL, 0x040fe200078e00ffULL,
0x0000001c03157211ULL, 0x000fe200078fe0ffULL, 0x000000011c127824ULL, 0x040fe200078e0211ULL,
0x000000031c1b7819ULL, 0x000fe200000006ffULL, 0x0000000111137824ULL, 0x000fe200078e027aULL,
0x0000000215147810ULL, 0x000fe20007ffe0ffULL, 0x000000087a167824ULL, 0x000fe200078e00ffULL,
0xfffffff817117812ULL, 0x000fe200078ee212ULL, 0x000000081c197824ULL, 0x040fe200078e00ffULL,
0x0000000415187810ULL, 0x000fe20007ffe0ffULL, 0x000000081c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff816127812ULL, 0x000fe200078ee213ULL, 0x0000001011747824ULL, 0x000fe200078e0278ULL,
0xffffc0001e167812ULL, 0x000fc400078ec0ffULL, 0xfffffff819137812ULL, 0x000fe200078ee214ULL,
0x000000081c147824ULL, 0x000fe200078e00ffULL, 0x0000000615197810ULL, 0x000fe20007ffe0ffULL,
0x0000200009177824ULL, 0x000fe200078e0216ULL, 0x000000007474783bULL, 0x000e620000000200ULL,
0x0000001012247824ULL, 0x000fe200078e0278ULL, 0xfffffff814147812ULL, 0x000fe400078ee215ULL,
0xfffffff81b157812ULL, 0x000fe400078ee218ULL, 0x0001600017177810ULL, 0x000fe20007ffe0ffULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0xfffffff81a167812ULL, 0x000fc600078ee219ULL,
0x0000001014707824ULL, 0x100fe400078e0217ULL, 0x00000010136c7824ULL, 0x100fe400078e0217ULL,
0x0000001015187824ULL, 0x000fe200078e0217ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000d74747231ULL, 0x086fe400003400ffULL, 0x0000000d76767231ULL, 0x000fe400003400ffULL,
0x0000000e75757231ULL, 0x080fe400003400ffULL, 0x0000000e77777231ULL, 0x000fc400003400ffULL,
0x0000000f24247231ULL, 0x088fe400003400ffULL, 0x0000000f26267231ULL, 0x000fe400003400ffULL,
0x0000001025257231ULL, 0x080fe400003400ffULL, 0x0000001027277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000001818783bULL, 0x000ee20000004200ULL,
0x0000001016687824ULL, 0x000fe200078e0217ULL, 0x0000000222227812ULL, 0x000fe200078efcffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x000000006c6c783bULL, 0x000ea20000004200ULL,
0x00000001ff847819ULL, 0x000fc40000011600ULL, 0x0000002203177211ULL, 0x000fe200078fe0ffULL,
0x000000006868783bULL, 0x000e680000004200ULL, 0x000000007070783bULL, 0x000e640000004200ULL,
0x000000187454723cULL, 0x04af700000041854ULL, 0x0000001a7450723cULL, 0x000f700000041850ULL,
0x000000182434723cULL, 0x040b6e0000041834ULL, 0x000000081c197824ULL, 0x020fe200078e00ffULL,
0x0000001a2430723cULL, 0x000b620000041830ULL, 0x000000017a187824ULL, 0x000fe200078e0217ULL,
0x000000171c1c7210ULL, 0x000fc80007ffe0ffULL, 0xfffffff819177812ULL, 0x000fe200078ee21cULL,
0x000000087a1b7824ULL, 0x060fe200078e00ffULL, 0x0000007a031a7211ULL, 0x000fe200078fe0ffULL,
0x0000006c745c723cULL, 0x044f62000004185cULL, 0x000000087a197824ULL, 0x000fe400078e00ffULL,
0xfffffff81b187812ULL, 0x000fe200078ee218ULL, 0x0000001017797824ULL, 0x000fe200078e0278ULL,
0x000000021a1b7810ULL, 0x040fe40007ffe0ffULL, 0x000000041a1c7810ULL, 0x000fe20007ffe0ffULL,
0x00000068744c723cULL, 0x000f62000004184cULL, 0xfffffff819197812ULL, 0x000fc400078ee21aULL,
0x000000061a227810ULL, 0x000fca0007ffe0ffULL, 0x0000006c243c723cULL, 0x040b6e000004183cULL,
0x000000087a6c7824ULL, 0x060fe200078e00ffULL, 0x00000068242c723cULL, 0x000b62000004182cULL,
0x000000087a6d7824ULL, 0x000fc600078e00ffULL, 0xfffffff86c1a7812ULL, 0x000fc600078ee21bULL,
0x0000000284687824ULL, 0x020fe200078e0209ULL, 0x000000702444723cULL, 0x000f620000041844ULL,
0x000000087a697824ULL, 0x000fc600078e00ffULL, 0x0001600068687811ULL, 0x000fe400078e68ffULL,
0xfffffff8691b7812ULL, 0x000fe400078ee21cULL, 0x000000722440723cULL, 0x000f620000041840ULL,
0xfffffff86d1c7812ULL, 0x000fe200078ee222ULL, 0x00000010196c7824ULL, 0x000fcc00078e0268ULL,
0x0000006e2438723cULL, 0x040f700000041838ULL, 0x0000006a2428723cULL, 0x000b6e0000041828ULL,
0x0000001018247824ULL, 0x020fe200078e0278ULL, 0x000000707464723cULL, 0x040b620000041864ULL,
0x000000007978783bULL, 0x000e680000000200ULL, 0x000000002424783bULL, 0x000ea40000000200ULL,
0x000000681b707211ULL, 0x020fe200078e20ffULL, 0x000000727460723cULL, 0x040f700000041860ULL,
0x0000006e7458723cULL, 0x040f700000041858ULL, 0x0000006a7448723cULL, 0x000b6e0000041848ULL,
0x000000101a747824ULL, 0x020fe200078e0268ULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000000d78787231ULL, 0x082fe400003400ffULL, 0x0000000d7a7a7231ULL, 0x000fc400003400ffULL,
0x0000000e79797231ULL, 0x080fe400003400ffULL, 0x0000000e7b7b7231ULL, 0x000fe400003400ffULL,
0x0000000f24247231ULL, 0x084fe400003400ffULL, 0x0000000f26267231ULL, 0x000fe400003400ffULL,
0x0000001025257231ULL, 0x080fe400003400ffULL, 0x0000001027277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101c687824ULL, 0x000fe200078e0268ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x000059001d227a24ULL, 0x010fe200078e02ffULL,
0xfffffff8211d7812ULL, 0x000fe200078ec0ffULL, 0x0000000802217824ULL, 0x000fe200078e0284ULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000e680000004200ULL,
0x000000006868783bULL, 0x000e640000004200ULL, 0x0000006c7864723cULL, 0x04ab700000041864ULL,
0x0000006e7860723cULL, 0x040b700000041860ULL, 0x00000074785c723cULL, 0x044b70000004185cULL,
0x000000767858723cULL, 0x040b700000041858ULL, 0x000000707854723cULL, 0x040b700000041854ULL,
0x000000727850723cULL, 0x040b700000041850ULL, 0x00000068784c723cULL, 0x040b70000004184cULL,
0x0000006a7848723cULL, 0x000b700000041848ULL, 0x00000074243c723cULL, 0x040b70000004183cULL,
0x000000762438723cULL, 0x040b700000041838ULL, 0x000000702434723cULL, 0x040b700000041834ULL,
0x000000722430723cULL, 0x040b700000041830ULL, 0x0000006c2444723cULL, 0x040b700000041844ULL,
0x0000006e2440723cULL, 0x040b700000041840ULL, 0x00000068242c723cULL, 0x040b70000004182cULL,
0x0000006a2428723cULL, 0x000b620000041828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000102257810ULL, 0x020fe20007ffe0ffULL, 0x00000100ff697424ULL, 0x000fe200078e00ffULL,
0x0000008021277811ULL, 0x000fe200078e28ffULL, 0x0000004022227824ULL, 0x000fe200078e00ffULL,
0x000000062500720cULL, 0x000fe20003f06070ULL, 0x01e688001dff7f8cULL, 0x0003e2000c80043fULL,
0x0000002027217812ULL, 0x000fe200078ec0ffULL, 0x0000640022247625ULL, 0x000fc800078e0069ULL,
0x0000000108227824ULL, 0x000fe200078e0221ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff757819ULL, 0x002fe40000011603ULL,
0x000020001e217812ULL, 0x000fe400078ec0ffULL, 0x00000027041e7217ULL, 0x000fe40007800000ULL,
0x00000008756d7810ULL, 0x040fe20007ffe0ffULL, 0x0000400084847824ULL, 0x000fe200078e0221ULL,
0x00000004756b7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e1e7824ULL, 0x000fe200078e0a27ULL,
0x0000000700267819ULL, 0x000fe200000006ffULL, 0x000000016d687824ULL, 0x100fe200078e0203ULL,
0x0000001475797810ULL, 0x000fe20007ffe0ffULL, 0x000000086d697824ULL, 0x000fe200078e00ffULL,
0x000000201e1e7817ULL, 0x000fe20003800000ULL, 0x000000016b217824ULL, 0x000fe200078e0203ULL,
0x000000800b267812ULL, 0x000fe200078ef826ULL, 0x000000086b767824ULL, 0x000fe200078e00ffULL,
0xfffffff869787812ULL, 0x000fe200078ee268ULL, 0x0000000175697824ULL, 0x100fe200078e0222ULL,
0x0000001e6b00720cULL, 0x000fe20003f86070ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x0000001075737810ULL, 0x000fe20007ffe0ffULL, 0x000000016b6b7824ULL, 0x000fe200078e0222ULL,
0xfffffff876767812ULL, 0x000fe200078ee221ULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0x0000000c75217810ULL, 0x000fc40007ffe0ffULL, 0x0000001e6d00720cULL, 0x000fe20003f66070ULL,
0x0000000179707824ULL, 0x040fe200078e0203ULL, 0x00000068246e7210ULL, 0x040fe20007f1e0ffULL,
0x0000000879777824ULL, 0x000fe200078e00ffULL, 0x0000001e2100720cULL, 0x080fe20003f46070ULL,
0x000001006b6a7825ULL, 0x000fe200078e0026ULL, 0x0000001e7500720cULL, 0x000fe40003fa6070ULL,
0xfffffff877887812ULL, 0x000fe200078ee270ULL, 0x00000001736f7824ULL, 0x140fe200078e0203ULL,
0x0000006a24707210ULL, 0x000fe20007f3e0ffULL, 0x0000000873867824ULL, 0x000fe200078e00ffULL,
0x0000001875877810ULL, 0x000fe20007ffe0ffULL, 0x00000001216c7824ULL, 0x000fe200078e0203ULL,
0x0000001c75897810ULL, 0x000fe20007ffe0ffULL, 0x0000000821717824ULL, 0x000fe200078e00ffULL,
0xfffffff886867812ULL, 0x000fe200078ee26fULL, 0x00000001877b7824ULL, 0x100fe200078e0222ULL,
0x00000069256f7210ULL, 0x000fe200007fe4ffULL, 0x000000016d697824ULL, 0x000fe200078e0222ULL,
0xfffffff8717a7812ULL, 0x000fe200078ee26cULL, 0x0000000125717824ULL, 0x000fe200008e066bULL,
0x0000001e7300720cULL, 0x000fe20003f26070ULL, 0x00000001216b7824ULL, 0x000fc400078e0222ULL,
0x0000010069687825ULL, 0x000fc800078e0026ULL, 0x000001006b6a7825ULL, 0x000fe200078e0026ULL,
0x0000006824727210ULL, 0x000fc60007f1e0ffULL, 0x0000000175217824ULL, 0x000fe200078e0203ULL,
0x0000006a246a7210ULL, 0x000fe20007fde0ffULL, 0x00000001736d7824ULL, 0x000fe400078e0222ULL,
0x0000000125737824ULL, 0x000fe200000e0669ULL, 0x0000000721747812ULL, 0x000fe200078ec0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0026ULL, 0x0001600084217810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff874747812ULL, 0x000fe200078ef803ULL, 0x0000000179697824ULL, 0x040fe200078e0222ULL,
0x0000001e7900720cULL, 0x000fe20003f06070ULL, 0x00000001256b7824ULL, 0x000fe200030e066bULL,
0x0000006c246c7210ULL, 0x000fe20007fde0ffULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0x0000002176797211ULL, 0x000fc600078e20ffULL, 0x0000001074777824ULL, 0x000fe400078e0221ULL,
0x00000001256d7824ULL, 0x000fe200030e066dULL, 0x0000006824747210ULL, 0x000fe20007fde0ffULL,
0x0000000189857824ULL, 0x000fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e777faeULL, 0x0003e2000e901c46ULL, 0x0000001e8700720cULL, 0x080fe20003fa6070ULL,
0x0000000189227824ULL, 0x000fe400078e0203ULL, 0x0000000125757824ULL, 0x000fe200030e0669ULL,
0x0000000070797faeULL, 0x0005e2000e101c46ULL, 0x000001007b687825ULL, 0x000fe200078e0026ULL,
0x0000001e8900720cULL, 0x000fc60003f86070ULL, 0x00000001871e7824ULL, 0x040fe200078e0203ULL,
0x0000006824687210ULL, 0x000fe20007fde0ffULL, 0x0000000887877824ULL, 0x000fe200078e00ffULL,
0x0000002186777211ULL, 0x002fe200078e20ffULL, 0x0000000889897824ULL, 0x000fe400078e00ffULL,
0x0000010085267825ULL, 0x000fe200078e0026ULL, 0xfffffff8871e7812ULL, 0x000fe400078ee21eULL,
0xfffffff889227812ULL, 0x000fe200078ee222ULL, 0x0000000125697824ULL, 0x000fe200030e0669ULL,
0x0000002624247210ULL, 0x000fe20007fde0ffULL, 0x00000010786f7824ULL, 0x000fc400078e0221ULL,
0x000000107a717824ULL, 0x104fe400078e0221ULL, 0x0000001088797824ULL, 0x100fe200078e0221ULL,
0x00000000726f7faeULL, 0x0003e2000d901c46ULL, 0x000000101e7b7824ULL, 0x100fe400078e0221ULL,
0x0000001022217824ULL, 0x000fe200078e0221ULL, 0x000000006a717faeULL, 0x0003e2000d101c46ULL,
0x0000000125257824ULL, 0x000fc600030e0627ULL, 0x000000006c777faeULL, 0x0003e8000c901c46ULL,
0x0000000074797faeULL, 0x0003e8000c101c46ULL, 0x00000000687b7faeULL, 0x0003e8000e901c46ULL,
0x0000000024217faeULL, 0x0003e2000e101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000c036d7811ULL, 0x002fe200078fe8ffULL, 0x0000008000747824ULL, 0x000fe200078e00ffULL,
0x000020001e217812ULL, 0x000fc400078ec0ffULL, 0x0000000403697811ULL, 0x000fe200078fe8ffULL,
0x000000016d267824ULL, 0x000fe200078e0203ULL, 0x00000008036b7811ULL, 0x000fe200078fe8ffULL,
0x0000400084847824ULL, 0x000fe200078e0221ULL, 0x000000036d717819ULL, 0x000fe200000006ffULL,
0x00000001691e7824ULL, 0x100fe200078e0203ULL, 0x00000010036f7811ULL, 0x000fe200078fe8ffULL,
0x0000000869277824ULL, 0x000fe200078e00ffULL, 0xfffffff8717a7812ULL, 0x000fe200078ee226ULL,
0x000000016b217824ULL, 0x100fe200078e0203ULL, 0x0000001403717811ULL, 0x000fe200078fe8ffULL,
0x000000086b787824ULL, 0x000fe200078e00ffULL, 0xfffffff827767812ULL, 0x000fe200078ee21eULL,
0x000000016f1e7824ULL, 0x000fe200078e0203ULL, 0x0000001803737811ULL, 0x000fe200078fe8ffULL,
0x000000086f277824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee221ULL,
0x0000000171217824ULL, 0x100fe200078e0203ULL, 0x000000226f6f7210ULL, 0x080fe20007ffe0ffULL,
0x0000000871887824ULL, 0x000fe200078e00ffULL, 0xfffffff827867812ULL, 0x000fe200078ee21eULL,
0x0000000173267824ULL, 0x000fe200078e0203ULL, 0x000000800b747812ULL, 0x000fe200078ef874ULL,
0x0000000873277824ULL, 0x000fe200078e00ffULL, 0xfffffff888887812ULL, 0x000fe200078ee221ULL,
0x0000000169697824ULL, 0x100fe200078e0222ULL, 0x0000001c03217811ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0222ULL, 0xfffffff8278a7812ULL, 0x000fe200078ee226ULL,
0x000000016d6d7824ULL, 0x100fe200078e0222ULL, 0x0000002203277211ULL, 0x000fe200078fe8ffULL,
0x0000000121267824ULL, 0x100fe200078e0203ULL, 0x00000003031e7211ULL, 0x000fe200078fe8ffULL,
0x0000000821757824ULL, 0x000fe200078e00ffULL, 0x00016000848b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000171717824ULL, 0x100fe200078e0222ULL, 0x000000071e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000173737824ULL, 0x100fe200078e0222ULL, 0x0000008b86857211ULL, 0x000fe200078e20ffULL,
0x0000000121217824ULL, 0x000fe200078e0222ULL, 0xfffffff875227812ULL, 0x000fe200078ee226ULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x0ffffff81e1e7812ULL, 0x000fe200078ef803ULL,
0x0000001076777824ULL, 0x000fc400078e028bULL, 0x0000010027267825ULL, 0x000fc800078e0074ULL,
0x0000010069687825ULL, 0x000fe200078e0074ULL, 0x0000002624267210ULL, 0x000fc60007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0074ULL, 0x0000006824687210ULL, 0x000fc60007f3e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0074ULL, 0x0000006a246a7210ULL, 0x000fc60007f5e0ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0074ULL, 0x0000006c246c7210ULL, 0x000fc60007f7e0ffULL,
0x0000010071707825ULL, 0x000fc800078e0074ULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x0000010021747825ULL, 0x000fc800078e0074ULL, 0x0000000125277824ULL, 0x040fe200000e0627ULL,
0x0000006e246e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000125697824ULL, 0x040fe200008e0669ULL,
0x0000007024707210ULL, 0x000fe20007f3e0ffULL, 0x000000101e217824ULL, 0x000fe400078e028bULL,
0x00000001256b7824ULL, 0x040fe200010e066bULL, 0x0000007224727210ULL, 0x000fe20007f5e0ffULL,
0x0000001078797824ULL, 0x000fe200078e028bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026217faeULL, 0x0003e2000b901c46ULL, 0x00000001256d7824ULL, 0x040fe200018e066dULL,
0x0000007424247210ULL, 0x000fe20007f7e0ffULL, 0x000000107a7b7824ULL, 0x000fe200078e028bULL,
0x0000000068777faeULL, 0x0003e2000b901c46ULL, 0x00000001256f7824ULL, 0x000fc400000e066fULL,
0x0000001088877824ULL, 0x000fe200078e028bULL, 0x000000006a797faeULL, 0x0003e2000b901c46ULL,
0x0000000125717824ULL, 0x040fe400008e0671ULL, 0x000000108a897824ULL, 0x000fe200078e028bULL,
0x000000006c7b7faeULL, 0x0003e2000b901c46ULL, 0x0000000125737824ULL, 0x040fe200010e0673ULL,
0x0000007525257210ULL, 0x000fe20001ffe4ffULL, 0x00000010228b7824ULL, 0x000fe200078e028bULL,
0x000000006e857faeULL, 0x0003e8000b901c46ULL, 0x0000000070877faeULL, 0x0003e8000b901c46ULL,
0x0000000072897faeULL, 0x0003e8000b901c46ULL, 0x00000000248b7faeULL, 0x0003e4000b901c46ULL,
0x000000031f1e7812ULL, 0x000fc800078ec0ffULL, 0x000000031e00780cULL, 0x000fc80003f05270ULL,
0x00000001831e7807ULL, 0x000fca0004000000ULL, 0x000000011f1f7824ULL, 0x000fe400078e021eULL,
0xffffffffff1e7424ULL, 0x000fc600078e00ffULL, 0x000000051f00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010a247824ULL, 0x002fe400078e021fULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000660024247625ULL, 0x000fca00078e0025ULL,
0x00000006241e7981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6280020687f8cULL, 0x0022a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0xffffffe07c207812ULL, 0x042fe400078ec0ffULL,
0x000000107c217812ULL, 0x040fe400078ec0ffULL, 0x000000087c227812ULL, 0x000fc800078ec0ffULL,
0x0000002022207210ULL, 0x000fca0007ffe021ULL, 0x01e62c0020217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x006fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624227210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e25ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff217819ULL, 0x000fc80000011426ULL, 0x0000002221217211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0626ULL, 0x0000000221217819ULL, 0x000fc80000001222ULL,
0x000000210000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e62c0020217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000217824ULL, 0x000fca00078e00ffULL,
0xffffff8021227812ULL, 0x000fc800078ec0ffULL, 0x000000800b217810ULL, 0x000fca0007ffe022ULL,
0x0000000180217824ULL, 0x000fca00078e0221ULL, 0x01e0000021227984ULL, 0x000e680000000800ULL,
0x01e2000021687984ULL, 0x0004e20000000800ULL, 0x000000072200720bULL, 0x002fe20003f1d000ULL,
0x000152b27f007947ULL, 0x000fd8000b800000ULL, 0x00000000006a7806ULL, 0x004fc800000e0100ULL,
0x000000ff6a00720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff217224ULL, 0x000fd400078e0007ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000017d217810ULL, 0x000fe40007ffe0ffULL,
0x000000072200720bULL, 0x000fe40003f34000ULL, 0x000000002100720cULL, 0x000fe20003f05270ULL,
0x000152727f007947ULL, 0x000fd4000b800000ULL, 0x0000000000217806ULL, 0x000fc400008e0100ULL,
0x0000008000258824ULL, 0x000fe200078e020bULL, 0x0000000722248209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000180258824ULL, 0x000fca00078e0225ULL,
0x01e4002425008388ULL, 0x0003e20000000800ULL, 0x000000ff2100720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000000722247209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff21ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000724247221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024006c7308ULL, 0x000e640000000800ULL, 0x0000006c23237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe20000011603ULL,
0x000151b27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0021ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803247811ULL, 0x000fe200078ff0ffULL, 0x000150a27f007947ULL, 0x000fea000b800000ULL,
0x00001f246c247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x0000002462627220ULL, 0x080fe40000410000ULL,
0x0000002463637220ULL, 0x080fe40000410000ULL, 0x000000245e5e7220ULL, 0x080fe40000410000ULL,
0x000000245f5f7220ULL, 0x000fc40000410000ULL, 0x000000245a5a7220ULL, 0x080fe40000410000ULL,
0x000000245b5b7220ULL, 0x080fe40000410000ULL, 0x0000002456567220ULL, 0x080fe40000410000ULL,
0x0000002457577220ULL, 0x080fe40000410000ULL, 0x0000002452527220ULL, 0x080fe40000410000ULL,
0x0000002453537220ULL, 0x000fc40000410000ULL, 0x000000244e4e7220ULL, 0x080fe40000410000ULL,
0x000000244f4f7220ULL, 0x080fe40000410000ULL, 0x000000244a4a7220ULL, 0x080fe40000410000ULL,
0x000000244b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000021ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001003247811ULL, 0x000fe200078ff0ffULL,
0x00014f927f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000021ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001803247811ULL, 0x000fe200078ff0ffULL,
0x00014e927f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x0000002442427220ULL, 0x080fe40000410000ULL, 0x0000002443437220ULL, 0x080fe40000410000ULL,
0x000000243e3e7220ULL, 0x080fe40000410000ULL, 0x000000243f3f7220ULL, 0x000fc40000410000ULL,
0x000000243a3a7220ULL, 0x080fe40000410000ULL, 0x000000243b3b7220ULL, 0x080fe40000410000ULL,
0x0000002436367220ULL, 0x080fe40000410000ULL, 0x0000002437377220ULL, 0x080fe40000410000ULL,
0x0000002432327220ULL, 0x080fe40000410000ULL, 0x0000002433337220ULL, 0x000fc40000410000ULL,
0x000000242e2e7220ULL, 0x080fe40000410000ULL, 0x000000242f2f7220ULL, 0x080fe40000410000ULL,
0x000000242a2a7220ULL, 0x080fe40000410000ULL, 0x000000242b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000216aff7212ULL, 0x000fe400078030ffULL,
0x0000000722217209ULL, 0x000fd60007810000ULL, 0x8000002122220221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x00000022000c0308ULL, 0x000e640000000800ULL,
0x0000000c68680220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002368237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000cff07723eULL, 0x000fe400000010ffULL,
0x00000002ff107819ULL, 0x000fe40000011603ULL, 0x0000541007077816ULL, 0x000fe20000000007ULL,
0x00014cf27f007947ULL, 0x000fea000b800000ULL, 0x00001f10070d7589ULL, 0x0002a400000e0000ULL,
0x0000000810247810ULL, 0x000fe20007ffe0ffULL, 0x00014d427f007947ULL, 0x000fea000b800000ULL,
0x0000001010227810ULL, 0x000fe20007ffe0ffULL, 0x00001f24070e7589ULL, 0x00066800000e0000ULL,
0x00001f22070f7589ULL, 0x0006a400000e0000ULL, 0x0000001810247810ULL, 0x008fe20007ffe0ffULL,
0x00014dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2407107589ULL, 0x0022e400000e0000ULL,
0x0000200000227824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000040000077824ULL, 0x002fe200078e00ffULL, 0x0000016000007945ULL, 0x000fe40003800000ULL,
0xffffc00022247812ULL, 0x000fc400078ec0ffULL, 0xfffff00007077812ULL, 0x000fc600078ec0ffULL,
0x0000200009247824ULL, 0x000fe200078e0224ULL, 0x0001300007847810ULL, 0x000fc80007ffe0ffULL,
0x0001700024077810ULL, 0x000fe20007ffe0ffULL, 0x0000001011787824ULL, 0x100fe400078e0284ULL,
0x0000001012247824ULL, 0x000fe400078e0284ULL, 0x0000001014747824ULL, 0x100fe400078e0207ULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0x0000001013707824ULL, 0x100fe400078e0207ULL,
0x00000010156c7824ULL, 0x000fe200078e0207ULL, 0x000000002424783bULL, 0x000ee20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000d78787231ULL, 0x086fe400003400ffULL,
0x0000000d7a7a7231ULL, 0x000fc400003400ffULL, 0x0000000e79797231ULL, 0x080fe400003400ffULL,
0x0000000e7b7b7231ULL, 0x000fe400003400ffULL, 0x0000000f24247231ULL, 0x088fe400003400ffULL,
0x0000000f26267231ULL, 0x000fe400003400ffULL, 0x0000001025257231ULL, 0x080fe400003400ffULL,
0x0000001027277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001016687824ULL, 0x000fe200078e0207ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x00000001ff077819ULL, 0x000fe20000011600ULL, 0x0000026000007945ULL, 0x000fe40003800000ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000006c6c783bULL, 0x000e680000004200ULL,
0x000000006868783bULL, 0x000e640000004200ULL, 0x000000747864723cULL, 0x04af700000041864ULL,
0x000000767860723cULL, 0x040f700000041860ULL, 0x00000070785c723cULL, 0x044f70000004185cULL,
0x000000727858723cULL, 0x040f700000041858ULL, 0x0000006c7854723cULL, 0x040f700000041854ULL,
0x0000006e7850723cULL, 0x040f700000041850ULL, 0x00000068784c723cULL, 0x040f70000004184cULL,
0x0000006a7848723cULL, 0x000b6e0000041848ULL, 0x0000001017787824ULL, 0x020fe200078e0284ULL,
0x000000742444723cULL, 0x040f6a0000041844ULL, 0x000000007878783bULL, 0x000e660000000200ULL,
0x000000762440723cULL, 0x040f700000041840ULL, 0x00000070243c723cULL, 0x040f70000004183cULL,
0x000000722438723cULL, 0x040f700000041838ULL, 0x0000006c2434723cULL, 0x040f700000041834ULL,
0x0000006e2430723cULL, 0x040f700000041830ULL, 0x00000068242c723cULL, 0x040b6e000004182cULL,
0x0000000907687211ULL, 0x020fe200078e08ffULL, 0x0000006a2428723cULL, 0x000b660000041828ULL,
0x0001700068687811ULL, 0x000fc800078e68ffULL, 0x0000001018247824ULL, 0x020fe400078e0284ULL,
0x0000001019747824ULL, 0x100fe400078e0268ULL, 0x000000101a707824ULL, 0x100fe400078e0268ULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x000000101b6c7824ULL, 0x000fe200078e0268ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000d78787231ULL, 0x082fe400003400ffULL,
0x0000000d7a7a7231ULL, 0x000fc400003400ffULL, 0x0000000e79797231ULL, 0x080fe400003400ffULL,
0x0000000e7b7b7231ULL, 0x000fe400003400ffULL, 0x0000000f24247231ULL, 0x084fe400003400ffULL,
0x0000000f26267231ULL, 0x000fe400003400ffULL, 0x0000001025257231ULL, 0x080fe400003400ffULL,
0x0000001027277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x000000101c687824ULL, 0x000fe200078e0268ULL, 0x000000007474783bULL, 0x000e620000004200ULL,
0x000059001e1e7a24ULL, 0x010fc600078e02ffULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x000000747864723cULL, 0x042f700000041864ULL, 0x000000767860723cULL, 0x040f700000041860ULL,
0x00000070785c723cULL, 0x048f70000004185cULL, 0x000000727858723cULL, 0x040f700000041858ULL,
0x0000006c7854723cULL, 0x044f700000041854ULL, 0x0000006e7850723cULL, 0x040f700000041850ULL,
0x0000006a7848723cULL, 0x000f700000041848ULL, 0x000000742444723cULL, 0x040f700000041844ULL,
0x000000762440723cULL, 0x040f700000041840ULL, 0x00000070243c723cULL, 0x040f70000004183cULL,
0x000000722438723cULL, 0x040f700000041838ULL, 0x0000006c2434723cULL, 0x040f700000041834ULL,
0x0000006e2430723cULL, 0x040f700000041830ULL, 0x0000006a2428723cULL, 0x000f700000041828ULL,
0x00000068784c723cULL, 0x080f70000004184cULL, 0x00000068242c723cULL, 0x000b6e000004182cULL,
0x0000000802697824ULL, 0x020fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000000102257810ULL, 0x000fe20007ffe0ffULL, 0x01e690001dff7f8cULL, 0x0003e2000c80043fULL,
0x000000c069697811ULL, 0x000fe200078e28ffULL, 0x00000100ff6b7424ULL, 0x000fe200078e00ffULL,
0x000000062500720cULL, 0x000fe20003f06070ULL, 0x000000401e1e7824ULL, 0x000fe200078e00ffULL,
0x0000002069277812ULL, 0x000fc600078ec0ffULL, 0x000064001e247625ULL, 0x000fc800078e006bULL,
0x0000000108767824ULL, 0x000fe200078e0227ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff757819ULL, 0x102fe20000011603ULL,
0x0000008000267824ULL, 0x000fe200078e00ffULL, 0x00000069041e7217ULL, 0x000fe40007800000ULL,
0x00000004756b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c75737810ULL, 0x000fe40007ffe0ffULL,
0x0000001e691e7210ULL, 0x000fe20007ffe1ffULL, 0x000000016b277824ULL, 0x100fe200078e0203ULL,
0x00000008756d7810ULL, 0x000fe20007ffe0ffULL, 0x000000086b787824ULL, 0x000fe200078e00ffULL,
0x000000201e1e7817ULL, 0x000fe20003800000ULL, 0x0000000173697824ULL, 0x000fe200078e0203ULL,
0x000000800b267812ULL, 0x000fe200078ef826ULL, 0x0000000873847824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee227ULL, 0x000000016d687824ULL, 0x000fe200078e0203ULL,
0x0000001e6b00720cULL, 0x000fe20003f86070ULL, 0x000000086d6f7824ULL, 0x000fe200078e00ffULL,
0xfffffff884847812ULL, 0x000fe200078ee269ULL, 0x0000000175697824ULL, 0x040fe200078e0276ULL,
0x0000001475797810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0xfffffff86f7a7812ULL, 0x000fe200078ee268ULL, 0x000000016b6b7824ULL, 0x000fe200078e0276ULL,
0x0000001075777810ULL, 0x000fe20007ffe0ffULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0x0000200022227812ULL, 0x000fc400078ec0ffULL, 0x00000003776c7210ULL, 0x000fe20007ffe0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0026ULL, 0x00000068246e7210ULL, 0x040fe40007f1e0ffULL,
0x0000001e6d00720cULL, 0x000fe20003f66070ULL, 0x00000001796f7824ULL, 0x040fe200078e0203ULL,
0x0000006a24707210ULL, 0x000fe20007f3e0ffULL, 0x0000000879887824ULL, 0x000fe200078e00ffULL,
0x0000001e7300720cULL, 0x080fe20003f46070ULL, 0x0000000877717824ULL, 0x000fe200078e00ffULL,
0x0000001e7500720cULL, 0x080fe20003fa6070ULL, 0x0000400007747824ULL, 0x000fe200078e0222ULL,
0xfffffff888887812ULL, 0x000fe200078ee26fULL, 0x00000001256f7824ULL, 0x000fe200000e0669ULL,
0xfffffff871867812ULL, 0x000fe200078ee26cULL, 0x000000016d697824ULL, 0x100fe200078e0276ULL,
0x00017000747b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125717824ULL, 0x000fe200008e066bULL,
0x0000001875897810ULL, 0x000fe20007ffe0ffULL, 0x00000001736b7824ULL, 0x000fe200078e0276ULL,
0x0000001e7700720cULL, 0x000fe20003f26070ULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0x0000001c758b7810ULL, 0x000fc60007ffe0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0026ULL,
0x0000006824727210ULL, 0x000fc60007f1e0ffULL, 0x00000001776d7824ULL, 0x000fe200078e0276ULL,
0x0000006a246a7210ULL, 0x000fe20007fde0ffULL, 0x0000000175227824ULL, 0x000fe200078e0203ULL,
0x0000006925737210ULL, 0x000fe200007fe4ffULL, 0x000001006d6c7825ULL, 0x000fe200078e0026ULL,
0x0000001e7900720cULL, 0x040fe40003f06070ULL, 0x0000000722227812ULL, 0x000fe200078ec0ffULL,
0x0000000179697824ULL, 0x000fe400078e0276ULL, 0x00000001256b7824ULL, 0x000fe200030e066bULL,
0x0000006c246c7210ULL, 0x000fe20007fde0ffULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0x0ffffff822227812ULL, 0x000fc600078ef803ULL, 0x00000001256d7824ULL, 0x000fe200030e066dULL,
0x0000006824747210ULL, 0x000fe20007fde0ffULL, 0x0000001022857824ULL, 0x100fe200078e027bULL,
0x000000038b227210ULL, 0x000fe20007ffe0ffULL, 0x0000000189777824ULL, 0x000fe400078e0276ULL,
0x0000001078877824ULL, 0x000fe200078e027bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e857faeULL, 0x0003e2000e901c46ULL, 0x0000000125757824ULL, 0x000fe200030e0669ULL,
0x0000001e8900720cULL, 0x080fe20003fa6070ULL, 0x0000010077687825ULL, 0x000fe200078e0026ULL,
0x0000000070877faeULL, 0x0005e2000e101c46ULL, 0x0000001e8b00720cULL, 0x000fc40003f86070ULL,
0x000000018b797824ULL, 0x000fe200078e0276ULL, 0x0000006824687210ULL, 0x040fe20007fde0ffULL,
0x00000001891e7824ULL, 0x040fe400078e0203ULL, 0x0000000889897824ULL, 0x000fe400078e00ffULL,
0x000000088b8b7824ULL, 0x000fe400078e00ffULL, 0x0000010079267825ULL, 0x000fe200078e0026ULL,
0xfffffff8891e7812ULL, 0x000fe400078ee21eULL, 0xfffffff88b227812ULL, 0x000fe200078ee222ULL,
0x0000000125697824ULL, 0x000fe200030e0669ULL, 0x0000002624247210ULL, 0x000fe20007fde0ffULL,
0x000000107a6f7824ULL, 0x002fc400078e027bULL, 0x0000001084717824ULL, 0x104fe400078e027bULL,
0x0000001086777824ULL, 0x100fe200078e027bULL, 0x00000000726f7faeULL, 0x0003e2000d901c46ULL,
0x0000001088797824ULL, 0x100fe400078e027bULL, 0x000000101e857824ULL, 0x100fe200078e027bULL,
0x000000006a717faeULL, 0x0003e2000d101c46ULL, 0x00000010227b7824ULL, 0x000fe400078e027bULL,
0x0000000125257824ULL, 0x000fe200030e0627ULL, 0x000000006c777faeULL, 0x0003e8000c901c46ULL,
0x0000000074797faeULL, 0x0003e8000c101c46ULL, 0x0000000068857faeULL, 0x0003e8000e901c46ULL,
0x00000000247b7faeULL, 0x0003e2000e101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000008036b7811ULL, 0x042fe400078fe8ffULL, 0x0000000403697811ULL, 0x000fc400078fe8ffULL,
0x0000000c036d7811ULL, 0x000fe200078fe8ffULL, 0x000000016b267824ULL, 0x100fe200078e0203ULL,
0x0000000369277819ULL, 0x000fe200000006ffULL, 0x000000086b6f7824ULL, 0x000fe200078e00ffULL,
0x0000001403717811ULL, 0x000fe200078fe8ffULL, 0x00000001691e7824ULL, 0x100fe200078e0203ULL,
0x0000001803737811ULL, 0x000fe200078fe8ffULL, 0x000000086d757824ULL, 0x000fe200078e00ffULL,
0xfffffff86f7a7812ULL, 0x000fe200078ee226ULL, 0x0000000871887824ULL, 0x000fe200078e00ffULL,
0x00000010036f7811ULL, 0x000fe200078fe8ffULL, 0x0000000173687824ULL, 0x100fe200078e0203ULL,
0xfffffff827787812ULL, 0x000fe200078ee21eULL, 0x000000016d1e7824ULL, 0x100fe200078e0203ULL,
0x0000000700747819ULL, 0x000fe200000006ffULL, 0x000000016f267824ULL, 0x140fe200078e0203ULL,
0x0000200022227812ULL, 0x000fe200078ec0ffULL, 0x000000086f777824ULL, 0x000fe200078e00ffULL,
0xfffffff875847812ULL, 0x000fe200078ee21eULL, 0x0000000171277824ULL, 0x000fe200078e0203ULL,
0x000000800b747812ULL, 0x000fe200078ef874ULL, 0x0000000873797824ULL, 0x000fe200078e00ffULL,
0xfffffff877867812ULL, 0x000fe200078ee226ULL, 0x0000000169697824ULL, 0x100fe200078e0276ULL,
0x0000001c03777811ULL, 0x000fe200078fe8ffULL, 0x000000016b6b7824ULL, 0x100fe200078e0276ULL,
0xfffffff888887812ULL, 0x000fe200078ee227ULL, 0x000000016d6d7824ULL, 0x000fe200078e0276ULL,
0x0000007603277211ULL, 0x000fe200078fe8ffULL, 0x0000000177267824ULL, 0x000fe200078e0203ULL,
0x00000003031e7211ULL, 0x000fe200078fe8ffULL, 0x0000000877757824ULL, 0x000fe200078e00ffULL,
0xfffffff8798a7812ULL, 0x000fe200078ee268ULL, 0x000000016f6f7824ULL, 0x100fe200078e0276ULL,
0x000000071e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000171717824ULL, 0x000fc400078e0276ULL,
0x0000000173737824ULL, 0x100fe200078e0276ULL, 0x0ffffff81e1e7812ULL, 0x000fe200078ef803ULL,
0x0000000177777824ULL, 0x000fe200078e0276ULL, 0xfffffff875767812ULL, 0x000fe200078ee226ULL,
0x0000400007227824ULL, 0x000fe200078e0222ULL, 0x000000ff00757202ULL, 0x000fc80000000f00ULL,
0x0001700022797810ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fc800078e0074ULL,
0x0000010069687825ULL, 0x000fe200078e0074ULL, 0x0000002624267210ULL, 0x000fc60007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0074ULL, 0x0000006824687210ULL, 0x000fc60007f3e0ffULL,
0x000001006d6c7825ULL, 0x100fe200078e0074ULL, 0x0000006a246a7210ULL, 0x040fe40007f5e0ffULL,
0x0000006925697210ULL, 0x000fe20000ffe4ffULL, 0x000001006f6e7825ULL, 0x000fe200078e0074ULL,
0x0000006c246c7210ULL, 0x000fc60007f7e0ffULL, 0x0000010071707825ULL, 0x000fc800078e0074ULL,
0x0000010073727825ULL, 0x000fe200078e0074ULL, 0x0000007024707210ULL, 0x000fc60007f3e0ffULL,
0x0000010077747825ULL, 0x000fc800078e0074ULL, 0x0000000125277824ULL, 0x040fe200000e0627ULL,
0x0000006e246e7210ULL, 0x000fe20007f1e0ffULL, 0x000000101e777824ULL, 0x000fe400078e0279ULL,
0x00000001256b7824ULL, 0x040fe200010e066bULL, 0x0000007224727210ULL, 0x000fe20007f5e0ffULL,
0x00000010787b7824ULL, 0x000fe200078e0279ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026777faeULL, 0x0003e2000b901c46ULL, 0x00000001256d7824ULL, 0x000fe200018e066dULL,
0x0000007424247210ULL, 0x000fe20007f7e0ffULL, 0x000000107a857824ULL, 0x100fe200078e0279ULL,
0x00000000687b7faeULL, 0x0003e2000b901c46ULL, 0x0000001084877824ULL, 0x000fc400078e0279ULL,
0x0000001086897824ULL, 0x000fe200078e0279ULL, 0x000000006a857faeULL, 0x0003e2000b901c46ULL,
0x00000001256f7824ULL, 0x040fe400000e066fULL, 0x00000010888b7824ULL, 0x000fe200078e0279ULL,
0x000000006c877faeULL, 0x0003e2000b901c46ULL, 0x0000000125717824ULL, 0x040fe400008e0671ULL,
0x000000108a8d7824ULL, 0x000fe200078e0279ULL, 0x000000006e897faeULL, 0x0003e2000b901c46ULL,
0x0000000125737824ULL, 0x000fc400010e0673ULL, 0x0000001076797824ULL, 0x000fe200078e0279ULL,
0x00000000708b7faeULL, 0x0003e2000b901c46ULL, 0x0000000125257824ULL, 0x000fc600018e0675ULL,
0x00000000728d7faeULL, 0x0003e8000b901c46ULL, 0x0000000024797faeULL, 0x0003e4000b901c46ULL,
0x000000031f1e7812ULL, 0x000fc800078ec0ffULL, 0x000000031e00780cULL, 0x000fc80003f05270ULL,
0x00000001831e7807ULL, 0x000fca0004000000ULL, 0x000000011f1f7824ULL, 0x000fe400078e021eULL,
0xffffffffff1e7424ULL, 0x000fc600078e00ffULL, 0x000000051f00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000400257802ULL, 0x002fe20000000f00ULL,
0x000000010a247824ULL, 0x000fc800078e021fULL, 0x0000660024247625ULL, 0x000fca00078e0025ULL,
0x00000006241e7981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6480020687f8cULL, 0x0022a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0xffffffe07c207812ULL, 0x042fe400078ec0ffULL,
0x000000107c277812ULL, 0x040fe400078ec0ffULL, 0x000000087c227812ULL, 0x000fc800078ec0ffULL,
0x0000002022207210ULL, 0x000fca0007ffe027ULL, 0x01e64c0020277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x006fe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026246b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000006b22227211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e64c0020277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000227824ULL, 0x000fca00078e00ffULL,
0xffffff8022227812ULL, 0x000fc800078ec0ffULL, 0x000001000b257810ULL, 0x000fca0007ffe022ULL,
0x0000000180257824ULL, 0x000fca00078e0225ULL, 0x01e0000025227984ULL, 0x000e680000000800ULL,
0x01e2000025687984ULL, 0x0004e20000000800ULL, 0x000000212200720bULL, 0x002fe20003f1d000ULL,
0x000137a27f007947ULL, 0x000fd8000b800000ULL, 0x00000000006a7806ULL, 0x004fc800000e0100ULL,
0x000000ff6a00720cULL, 0x000fe20003f25270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x000000027d257810ULL, 0x000fe40007ffe0ffULL, 0x000000212200720bULL, 0x000fe40003f34000ULL,
0x000000002500720cULL, 0x000fe20003f05270ULL, 0x000137727f007947ULL, 0x000fd4000b800000ULL,
0x00000000006b7806ULL, 0x000fc400008e0100ULL, 0x0000000b00258211ULL, 0x000fe200078e38ffULL,
0x0000064000017945ULL, 0x000fe20003800000ULL, 0x0000002122247209ULL, 0x000fc60007810000ULL,
0x0000000180258824ULL, 0x000fca00078e0225ULL, 0x01e4002425008388ULL, 0x0003e20000000800ULL,
0x000000ff6b00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x8000002421247221ULL, 0x002fe20000010000ULL, 0x000000ff6bff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024006c7308ULL, 0x000e640000000800ULL, 0x0000006c23237220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe20000011603ULL,
0x000136c27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x080fe40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x000fc40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x000fc40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006bff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803247811ULL, 0x000fe200078ff0ffULL, 0x000135b27f007947ULL, 0x000fea000b800000ULL,
0x00001f246c247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x0000002462627220ULL, 0x080fe40000410000ULL,
0x0000002463637220ULL, 0x080fe40000410000ULL, 0x000000245e5e7220ULL, 0x080fe40000410000ULL,
0x000000245f5f7220ULL, 0x000fc40000410000ULL, 0x000000245a5a7220ULL, 0x080fe40000410000ULL,
0x000000245b5b7220ULL, 0x080fe40000410000ULL, 0x0000002456567220ULL, 0x080fe40000410000ULL,
0x0000002457577220ULL, 0x080fe40000410000ULL, 0x0000002452527220ULL, 0x080fe40000410000ULL,
0x0000002453537220ULL, 0x000fc40000410000ULL, 0x000000244e4e7220ULL, 0x080fe40000410000ULL,
0x000000244f4f7220ULL, 0x080fe40000410000ULL, 0x000000244a4a7220ULL, 0x080fe40000410000ULL,
0x000000244b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006bff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001003247811ULL, 0x000fe200078ff0ffULL,
0x000134a27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001803247811ULL, 0x000fe200078ff0ffULL,
0x000133a27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x0000002442427220ULL, 0x080fe40000410000ULL, 0x0000002443437220ULL, 0x080fe40000410000ULL,
0x000000243e3e7220ULL, 0x080fe40000410000ULL, 0x000000243f3f7220ULL, 0x000fc40000410000ULL,
0x000000243a3a7220ULL, 0x080fe40000410000ULL, 0x000000243b3b7220ULL, 0x080fe40000410000ULL,
0x0000002436367220ULL, 0x080fe40000410000ULL, 0x0000002437377220ULL, 0x080fe40000410000ULL,
0x0000002432327220ULL, 0x080fe40000410000ULL, 0x0000002433337220ULL, 0x000fc40000410000ULL,
0x000000242e2e7220ULL, 0x080fe40000410000ULL, 0x000000242f2f7220ULL, 0x080fe40000410000ULL,
0x000000242a2a7220ULL, 0x080fe40000410000ULL, 0x000000242b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006b6aff7212ULL, 0x000fe400078030ffULL,
0x0000002122217209ULL, 0x000fd60007810000ULL, 0x8000002122220221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x00000022000c0308ULL, 0x000e640000000800ULL,
0x0000000c68680220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002368237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000cff0d723eULL, 0x000fe400000010ffULL,
0x00000002ff6b7819ULL, 0x000fe40000011603ULL, 0x000054100d107816ULL, 0x000fe2000000000dULL,
0x000132027f007947ULL, 0x000fea000b800000ULL, 0x00001f6b100d7589ULL, 0x0002a400000e0000ULL,
0x000000086b247810ULL, 0x000fe20007ffe0ffULL, 0x000132527f007947ULL, 0x000fea000b800000ULL,
0x000000106b0f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f24100e7589ULL, 0x00066a00000e0000ULL,
0x00001f0f100f7589ULL, 0x0006a400000e0000ULL, 0x000000186b247810ULL, 0x008fe20007ffe0ffULL,
0x000132e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2410107589ULL, 0x0022e400000e0000ULL,
0x0000040000227824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000207247824ULL, 0x002fe200078e0209ULL, 0x0000015000007945ULL, 0x000fe40003800000ULL,
0xfffff00022847812ULL, 0x000fe200078ec0ffULL, 0x0000200024227824ULL, 0x000fc600078e00ffULL,
0x0001400084847810ULL, 0x000fe40007ffe0ffULL, 0x0001600022857810ULL, 0x000fc60007ffe0ffULL,
0x0000001011687824ULL, 0x100fe400078e0284ULL, 0x0000001012247824ULL, 0x000fe400078e0284ULL,
0x00000010146c7824ULL, 0x100fe400078e0285ULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x0000001013707824ULL, 0x100fe400078e0285ULL, 0x0000001015747824ULL, 0x000fe200078e0285ULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000d68687231ULL, 0x086fe400003400ffULL, 0x0000000d6a6a7231ULL, 0x000fc400003400ffULL,
0x0000000e69697231ULL, 0x080fe400003400ffULL, 0x0000000e6b6b7231ULL, 0x000fe400003400ffULL,
0x0000000f24247231ULL, 0x088fe400003400ffULL, 0x0000000f26267231ULL, 0x000fe400003400ffULL,
0x0000001025257231ULL, 0x080fe400003400ffULL, 0x0000001027277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001016787824ULL, 0x100fe200078e0285ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x0000024000007945ULL, 0x000fe60003800000ULL,
0x000000007070783bULL, 0x000fe80000004200ULL, 0x000000007878783bULL, 0x000ea80000004200ULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x0000006c2444723cULL, 0x008f700000041844ULL,
0x00000078684c723cULL, 0x046f70000004184cULL, 0x0000007a6848723cULL, 0x000f700000041848ULL,
0x00000078242c723cULL, 0x040f70000004182cULL, 0x0000006e2440723cULL, 0x040f700000041840ULL,
0x00000070243c723cULL, 0x040f70000004183cULL, 0x000000722438723cULL, 0x040f700000041838ULL,
0x000000742434723cULL, 0x040f700000041834ULL, 0x000000762430723cULL, 0x040f700000041830ULL,
0x0000007a2478723cULL, 0x000b6e0000041828ULL, 0x0000008417287211ULL, 0x020fe200078e20ffULL,
0x0000001018247824ULL, 0x000fe200078e0284ULL, 0x0000006c6864723cULL, 0x040b680000041864ULL,
0x000000002828783bULL, 0x000e660000000200ULL, 0x000000101a6c7824ULL, 0x120fe200078e0285ULL,
0x0000006e6860723cULL, 0x040f620000041860ULL, 0x000000002424783bULL, 0x000eae0000000200ULL,
0x00000070685c723cULL, 0x040b6e000004185cULL, 0x000000101b707824ULL, 0x120fe200078e0285ULL,
0x000000726858723cULL, 0x040f700000041858ULL, 0x000000746854723cULL, 0x040f700000041854ULL,
0x000000766850723cULL, 0x000b6e0000041850ULL, 0x0000001019687824ULL, 0x020fe200078e0285ULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000d28287231ULL, 0x082fe400003400ffULL,
0x0000000d2a2a7231ULL, 0x000fc400003400ffULL, 0x0000000e29297231ULL, 0x080fe400003400ffULL,
0x0000000e2b2b7231ULL, 0x000fe400003400ffULL, 0x0000000f24247231ULL, 0x084fe400003400ffULL,
0x0000000f26267231ULL, 0x000fe400003400ffULL, 0x0000001025257231ULL, 0x080fe400003400ffULL,
0x0000001027277231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x000000101c747824ULL, 0x000fe200078e0285ULL, 0x000000006868783bULL, 0x000e680000004200ULL,
0x000000006c6c783bULL, 0x000ee80000004200ULL, 0x000000007070783bULL, 0x000ea80000004200ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x000000682864723cULL, 0x042b700000041864ULL,
0x0000006a2860723cULL, 0x040b700000041860ULL, 0x0000006c285c723cULL, 0x048b70000004185cULL,
0x0000006e2858723cULL, 0x040b700000041858ULL, 0x000000702854723cULL, 0x044b700000041854ULL,
0x000000722850723cULL, 0x040b700000041850ULL, 0x00000074284c723cULL, 0x040b70000004184cULL,
0x000000762828723cULL, 0x000b700000041848ULL, 0x000000682444723cULL, 0x040b700000041844ULL,
0x0000006a2440723cULL, 0x040b700000041840ULL, 0x0000006c243c723cULL, 0x040b70000004183cULL,
0x0000006e2438723cULL, 0x040b700000041838ULL, 0x000000702434723cULL, 0x040b700000041834ULL,
0x000000722430723cULL, 0x040b700000041830ULL, 0x00000074242c723cULL, 0x040b70000004182cULL,
0x000000762478723cULL, 0x000b620000041878ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030002027a10ULL, 0x000fe20007ffe0ffULL, 0x01e698001dff7f8cULL, 0x0003e6000c80043fULL,
0x000000060200720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000d4000000947ULL, 0x000fea0003800000ULL, 0x0000000102257810ULL, 0x062fe20007ffe0ffULL,
0x0000010002277824ULL, 0x000fe400078e027eULL, 0x000059001e1e7a24ULL, 0x010fe200078e02ffULL,
0x000000062500720cULL, 0x000fe20003f06070ULL, 0x00000100ff497424ULL, 0x000fe200078e00ffULL,
0x0000002027257812ULL, 0x000fe200078ec0ffULL, 0x000000401e1e7824ULL, 0x000fc800078e00ffULL,
0x0000000108727824ULL, 0x000fe400078e0225ULL, 0x000064001e247625ULL, 0x000fc800078e0049ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff717819ULL, 0x100fe40000011603ULL,
0x00000027041e7217ULL, 0x000fe40007800000ULL, 0x00000004714b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000871697810ULL, 0x000fe40007ffe0ffULL, 0x0000001e271e7210ULL, 0x000fe20007ffe1ffULL,
0x000000014b267824ULL, 0x100fe200078e0203ULL, 0x0000000c716f7810ULL, 0x000fe20007ffe0ffULL,
0x000000084b497824ULL, 0x000fe200078e00ffULL, 0x000000201e1e7817ULL, 0x000fe20003800000ULL,
0x0000000169277824ULL, 0x100fe200078e0203ULL, 0x0000001471757810ULL, 0x000fe20007ffe0ffULL,
0x0000000869767824ULL, 0x000fe200078e00ffULL, 0xfffffff849747812ULL, 0x000fe200078ee226ULL,
0x0000008000267824ULL, 0x000fe200078e00ffULL, 0x0000001e4b00720cULL, 0x080fe20003f86070ULL,
0x000000016f487824ULL, 0x040fe200078e0203ULL, 0xfffffff876767812ULL, 0x000fe200078ee227ULL,
0x000000086f6b7824ULL, 0x000fe200078e00ffULL, 0x000000800b267812ULL, 0x000fe200078ef826ULL,
0x0000000171497824ULL, 0x100fe200078e0272ULL, 0x000000ff00277202ULL, 0x000fe20000000f00ULL,
0x000000014b4b7824ULL, 0x000fe200078e0272ULL, 0xfffffff86b847812ULL, 0x000fe200078ee248ULL,
0x00000001756b7824ULL, 0x000fe200078e0203ULL, 0x0000001071737810ULL, 0x000fe20007ffe0ffULL,
0x0000010049487825ULL, 0x000fe200078e0026ULL, 0x0000001e6900720cULL, 0x000fc40003f66070ULL,
0x0000001e6f00720cULL, 0x000fe20003f46070ULL, 0x000001004b4a7825ULL, 0x000fe200078e0026ULL,
0x00000048246a7210ULL, 0x040fe40007f1e0ffULL, 0x0000001e7100720cULL, 0x000fe20003fa6070ULL,
0x0000000875887824ULL, 0x000fe200078e00ffULL, 0x0000004a246c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000173687824ULL, 0x000fe200078e0203ULL, 0x0000001871897810ULL, 0x000fe20007ffe0ffULL,
0x00000008736d7824ULL, 0x000fe200078e00ffULL, 0xfffffff888887812ULL, 0x000fe200078ee26bULL,
0x0000200000487824ULL, 0x000fe200078e00ffULL, 0x0000001c718b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001256b7824ULL, 0x000fe200000e0649ULL, 0xfffffff86d867812ULL, 0x000fe200078ee268ULL,
0x0000000169497824ULL, 0x000fe200078e0272ULL, 0x0000200048687812ULL, 0x000fe200078ec0ffULL,
0x00000001256d7824ULL, 0x000fe200008e064bULL, 0x000000726f4b7210ULL, 0x000fe20007ffe0ffULL,
0x00000001714a7824ULL, 0x000fe200078e0203ULL, 0x0000001e7300720cULL, 0x000fe20003f26070ULL,
0x0000010049487825ULL, 0x000fc600078e0026ULL, 0x000000074a707812ULL, 0x000fe200078ec0ffULL,
0x000001004b4a7825ULL, 0x000fe200078e0026ULL, 0x00000048246e7210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff870707812ULL, 0x000fe200078ef803ULL, 0x0000000173697824ULL, 0x000fe200078e0272ULL,
0x0000004a244a7210ULL, 0x000fe20007fde0ffULL, 0x0000400007737824ULL, 0x000fe400078e0268ULL,
0x0000010069687825ULL, 0x000fc600078e0026ULL, 0x0001600073777810ULL, 0x000fe20007ffe0ffULL,
0x00000001256f7824ULL, 0x000fe200000e0649ULL, 0x0000001e7500720cULL, 0x040fe20003f06070ULL,
0x0000000175497824ULL, 0x000fe400078e0272ULL, 0x00000001254b7824ULL, 0x000fe200030e064bULL,
0x0000006824687210ULL, 0x000fe20007fde0ffULL, 0x0000010049487825ULL, 0x000fc800078e0026ULL,
0x0000001070857824ULL, 0x000fe400078e0277ULL, 0x0000000125697824ULL, 0x000fe200030e0669ULL,
0x0000004824707210ULL, 0x000fe20007fde0ffULL, 0x0000000189737824ULL, 0x000fe200078e0272ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a857faeULL, 0x0003e2000e901c46ULL,
0x0000001074877824ULL, 0x000fe200078e0277ULL, 0x0000004925717210ULL, 0x000fe200037fe4ffULL,
0x0000010073487825ULL, 0x000fe200078e0026ULL, 0x0000001e8900720cULL, 0x080fe40003fa6070ULL,
0x000000006c877faeULL, 0x0005e2000e101c46ULL, 0x000000018b757824ULL, 0x040fe200078e0272ULL,
0x0000001e8b00720cULL, 0x000fe20003f86070ULL, 0x00000001891e7824ULL, 0x040fe200078e0203ULL,
0x0000004824487210ULL, 0x000fe20007fde0ffULL, 0x0000000889897824ULL, 0x000fc400078e00ffULL,
0x000000018b6a7824ULL, 0x042fe400078e0203ULL, 0x000000088b8b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8891e7812ULL, 0x000fe200078ee21eULL, 0x0000010075267825ULL, 0x000fe200078e0026ULL,
0x0000007788757211ULL, 0x000fe400078e20ffULL, 0xfffffff88b6a7812ULL, 0x000fe200078ee26aULL,
0x0000000125497824ULL, 0x000fe200030e0649ULL, 0x0000002624247210ULL, 0x000fe20007fde0ffULL,
0x00000010766b7824ULL, 0x000fc400078e0277ULL, 0x00000010846d7824ULL, 0x104fe400078e0277ULL,
0x0000001086737824ULL, 0x100fe200078e0277ULL, 0x000000006e6b7faeULL, 0x0003e2000d901c46ULL,
0x000000101e857824ULL, 0x100fe400078e0277ULL, 0x000000106a777824ULL, 0x000fe200078e0277ULL,
0x000000004a6d7faeULL, 0x0003e2000d101c46ULL, 0x0000000125257824ULL, 0x000fc600030e0627ULL,
0x0000000068737faeULL, 0x0003e8000c901c46ULL, 0x0000000070757faeULL, 0x0003e8000c101c46ULL,
0x0000000048857faeULL, 0x0003e8000e901c46ULL, 0x0000000024777faeULL, 0x0003e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x00000008034b7811ULL, 0x040fe200078fe8ffULL,
0x0000008000707824ULL, 0x000fe200078e00ffULL, 0x0000000403497811ULL, 0x000fc400078fe8ffULL,
0x0000000c03697811ULL, 0x000fe200078fe8ffULL, 0x000000014b267824ULL, 0x100fe200078e0203ULL,
0x00000014036d7811ULL, 0x000fe200078fe8ffULL, 0x000000084b6b7824ULL, 0x000fe200078e00ffULL,
0x00000018036f7811ULL, 0x000fe200078fe8ffULL, 0x00000001491e7824ULL, 0x100fe200078e0203ULL,
0x000000800b707812ULL, 0x000fe200078ef870ULL, 0x0000000849277824ULL, 0x000fe200078e00ffULL,
0xfffffff86b767812ULL, 0x000fe200078ee226ULL, 0x0000000869717824ULL, 0x000fe200078e00ffULL,
0x00000010036b7811ULL, 0x000fe200078fe8ffULL, 0x000000086d887824ULL, 0x000fe200078e00ffULL,
0xfffffff827747812ULL, 0x000fe200078ee21eULL, 0x00000001691e7824ULL, 0x100fe200078e0203ULL,
0x000000036b267210ULL, 0x0c0fe20007ffe0ffULL, 0x000000086b737824ULL, 0x000fe200078e00ffULL,
0x0000007269697210ULL, 0x080fe20007ffe0ffULL, 0x000000016d277824ULL, 0x100fe200078e0203ULL,
0xfffffff871847812ULL, 0x000fe200078ee21eULL, 0x00002000001e7824ULL, 0x000fe200078e00ffULL,
0xfffffff873867812ULL, 0x000fe200078ee226ULL, 0x000000016f487824ULL, 0x100fe200078e0203ULL,
0x0000001c03737811ULL, 0x000fe200078fe8ffULL, 0x000000086f757824ULL, 0x000fe200078e00ffULL,
0x000020001e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000149497824ULL, 0x000fe200078e0272ULL,
0x0000000303267211ULL, 0x000fe200078fe8ffULL, 0x00000001734a7824ULL, 0x040fe200078e0203ULL,
0xfffffff888887812ULL, 0x000fe200078ee227ULL, 0x0000000873717824ULL, 0x000fe200078e00ffULL,
0xfffffff8758a7812ULL, 0x000fe200078ee248ULL, 0x000000014b4b7824ULL, 0x100fe200078e0272ULL,
0x0000007203277211ULL, 0x000fe200078fe8ffULL, 0x000000016b6b7824ULL, 0x100fe200078e0272ULL,
0x0000000726267812ULL, 0x000fe200078ec0ffULL, 0x000000016d6d7824ULL, 0x000fc400078e0272ULL,
0x000000016f6f7824ULL, 0x100fe400078e0272ULL, 0x0000000173737824ULL, 0x000fe200078e0272ULL,
0xfffffff871727812ULL, 0x000fe200078ee24aULL, 0x0000400007487824ULL, 0x000fe200078e021eULL,
0x0ffffff8261e7812ULL, 0x000fe200078ef803ULL, 0x000000ffff717224ULL, 0x000fc600078e00ffULL,
0x0001600048757810ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fc600078e0070ULL,
0x0000007574777211ULL, 0x000fe200078e20ffULL, 0x0000010049487825ULL, 0x000fe200078e0070ULL,
0x0000002624267210ULL, 0x000fc60007f1e0ffULL, 0x000001004b4a7825ULL, 0x000fe200078e0070ULL,
0x0000004824487210ULL, 0x000fc60007f3e0ffULL, 0x0000010069687825ULL, 0x000fe200078e0070ULL,
0x0000004a244a7210ULL, 0x000fc60007f5e0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0070ULL,
0x0000006824687210ULL, 0x000fc60007f7e0ffULL, 0x000001006d6c7825ULL, 0x000fe200078e0070ULL,
0x0000006925697210ULL, 0x000fc60001ffe4ffULL, 0x000001006f6e7825ULL, 0x000fc800078e0070ULL,
0x0000010073707825ULL, 0x000fc800078e0070ULL, 0x0000000125277824ULL, 0x040fe200000e0627ULL,
0x0000006a246a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000125497824ULL, 0x040fe200008e0649ULL,
0x0000006c246c7210ULL, 0x000fe20007f3e0ffULL, 0x000000101e737824ULL, 0x000fe400078e0275ULL,
0x00000001254b7824ULL, 0x000fe200010e064bULL, 0x0000006e246e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001076857824ULL, 0x100fe200078e0275ULL, 0x0000007024247210ULL, 0x000fe20007f7e0ffULL,
0x0000001084877824ULL, 0x100fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026737faeULL, 0x0003e2000b901c46ULL, 0x0000001086897824ULL, 0x000fc400078e0275ULL,
0x00000001256b7824ULL, 0x040fe200000e066bULL, 0x0000000048777faeULL, 0x0003e2000b901c46ULL,
0x00000010888b7824ULL, 0x000fe400078e0275ULL, 0x00000001256d7824ULL, 0x040fe200008e066dULL,
0x000000004a857faeULL, 0x0003e2000b901c46ULL, 0x000000108a8d7824ULL, 0x000fe400078e0275ULL,
0x00000001256f7824ULL, 0x000fe200010e066fULL, 0x0000000068877faeULL, 0x0003e2000b901c46ULL,
0x0000001072757824ULL, 0x000fc400078e0275ULL, 0x0000000125257824ULL, 0x000fe200018e0671ULL,
0x000000006a897faeULL, 0x0003e8000b901c46ULL, 0x000000006c8b7faeULL, 0x0003e8000b901c46ULL,
0x000000006e8d7faeULL, 0x0003e8000b901c46ULL, 0x0000000024757faeULL, 0x0003e4000b901c46ULL,
0x000000031f1e7812ULL, 0x000fc800078ec0ffULL, 0x000000031e00780cULL, 0x000fc80003f05270ULL,
0x00000001831e7807ULL, 0x000fca0004000000ULL, 0x000000011f1f7824ULL, 0x000fe400078e021eULL,
0xffffffffff1e7424ULL, 0x000fc600078e00ffULL, 0x000000051f00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010a247824ULL, 0x002fe400078e021fULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000660024247625ULL, 0x000fca00078e0025ULL,
0x00000006241e7981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6680020487f8cULL, 0x0202a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0xffffffe07c207812ULL, 0x042fe400078ec0ffULL,
0x000000107c277812ULL, 0x040fe400078ec0ffULL, 0x000000087c267812ULL, 0x000fc800078ec0ffULL,
0x00000020264a7210ULL, 0x000fca0007ffe027ULL, 0x01e66c004a277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x006fe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026244b7210ULL, 0x000fc80007f1e1ffULL, 0x0000002725277210ULL, 0x000fe400007fe5ffULL,
0x003d09004b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011427ULL, 0x0000004b20207211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000220207819ULL, 0x000fc80000001227ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e66c004a277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000207824ULL, 0x000fca00078e00ffULL,
0xffffff8020207812ULL, 0x000fc800078ec0ffULL, 0x000001800b257810ULL, 0x000fca0007ffe020ULL,
0x0000000180257824ULL, 0x000fca00078e0225ULL, 0x01e0000025207984ULL, 0x000e680000000800ULL,
0x01e2000025487984ULL, 0x0004e20000000800ULL, 0x000000212000720bULL, 0x002fe20003f1d000ULL,
0x00011cb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000497806ULL, 0x004fc800000e0100ULL,
0x000000ff4900720cULL, 0x000fe20003f25270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff687224ULL, 0x000fd400078e0021ULL,
0x0000070000009947ULL, 0x000fea0003800000ULL, 0x000000037d257810ULL, 0x000fe40007ffe0ffULL,
0x000000212000720bULL, 0x000fe40003f34000ULL, 0x000000002500720cULL, 0x000fe20003f05270ULL,
0x00011c727f007947ULL, 0x000fd4000b800000ULL, 0x00000000004a7806ULL, 0x000fc400008e0100ULL,
0x00000080000b8824ULL, 0x000fe200078e020bULL, 0x0000002120687209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe60003800000ULL, 0x0000000b800b8210ULL, 0x000fca0007ffe0ffULL,
0x01e400680b008388ULL, 0x0003e20000000800ULL, 0x000000ff4a00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000021680b7221ULL, 0x002fe20000010100ULL,
0x000000ff4aff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b006a7308ULL, 0x000e640000000800ULL,
0x0000006a23237220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x000fe20000011603ULL, 0x00011bc27f007947ULL, 0x000fea000b800000ULL,
0x00001f246a247589ULL, 0x0002a400000e0000ULL, 0x0000002464647220ULL, 0x084fe40000410000ULL,
0x0000002465657220ULL, 0x080fe40000410000ULL, 0x0000002460607220ULL, 0x080fe40000410000ULL,
0x0000002461617220ULL, 0x080fe40000410000ULL, 0x000000245c5c7220ULL, 0x080fe40000410000ULL,
0x000000245d5d7220ULL, 0x000fc40000410000ULL, 0x0000002458587220ULL, 0x080fe40000410000ULL,
0x0000002459597220ULL, 0x080fe40000410000ULL, 0x0000002454547220ULL, 0x080fe40000410000ULL,
0x0000002455557220ULL, 0x080fe40000410000ULL, 0x0000002450507220ULL, 0x080fe40000410000ULL,
0x0000002451517220ULL, 0x000fc40000410000ULL, 0x000000244c4c7220ULL, 0x080fe40000410000ULL,
0x000000244d4d7220ULL, 0x080fe40000410000ULL, 0x0000002428287220ULL, 0x080fe40000410000ULL,
0x0000002429297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff004aff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803247811ULL, 0x000fe200078ff0ffULL,
0x00011ab27f007947ULL, 0x000fea000b800000ULL, 0x00001f246a247589ULL, 0x00046400000e0000ULL,
0x0000002466667220ULL, 0x086fe40000410000ULL, 0x0000002467677220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x080fe40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x000fc40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x000fc40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x080fe40000410000ULL,
0x000000242a2a7220ULL, 0x080fe40000410000ULL, 0x000000242b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00004aff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001003247811ULL, 0x000fe200078ff0ffULL, 0x000119a27f007947ULL, 0x000fea000b800000ULL,
0x00001f246a247589ULL, 0x00046400000e0000ULL, 0x0000002444447220ULL, 0x086fe40000410000ULL,
0x0000002445457220ULL, 0x080fe40000410000ULL, 0x0000002440407220ULL, 0x080fe40000410000ULL,
0x0000002441417220ULL, 0x080fe40000410000ULL, 0x000000243c3c7220ULL, 0x080fe40000410000ULL,
0x000000243d3d7220ULL, 0x000fc40000410000ULL, 0x0000002438387220ULL, 0x080fe40000410000ULL,
0x0000002439397220ULL, 0x080fe40000410000ULL, 0x0000002434347220ULL, 0x080fe40000410000ULL,
0x0000002435357220ULL, 0x080fe40000410000ULL, 0x0000002430307220ULL, 0x080fe40000410000ULL,
0x0000002431317220ULL, 0x000fc40000410000ULL, 0x000000242c2c7220ULL, 0x080fe40000410000ULL,
0x000000242d2d7220ULL, 0x080fe40000410000ULL, 0x0000002478787220ULL, 0x080fe40000410000ULL,
0x0000002479797220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000004aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001803247811ULL, 0x000fe200078ff0ffULL, 0x000118a27f007947ULL, 0x000fea000b800000ULL,
0x00001f246a247589ULL, 0x00046400000e0000ULL, 0x0000002446467220ULL, 0x086fe40000410000ULL,
0x0000002447477220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x080fe40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x000fc40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x000fc40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x080fe40000410000ULL, 0x000000247a7a7220ULL, 0x080fe40000410000ULL,
0x000000247b7b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000004a49ff7212ULL, 0x000fda00078030ffULL, 0x0000002068200221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b20200820ULL, 0x000fc80000410000ULL, 0x00000020000c0308ULL, 0x000e640000000800ULL,
0x0000000c48480220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002348237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000cff0b723eULL, 0x000fe400000010ffULL,
0x00000002ff107819ULL, 0x000fe40000011603ULL, 0x000054100b0b7816ULL, 0x000fe2000000000bULL,
0x000117127f007947ULL, 0x000fea000b800000ULL, 0x00001f100b0d7589ULL, 0x0002a400000e0000ULL,
0x0000000810247810ULL, 0x000fe20007ffe0ffULL, 0x000117627f007947ULL, 0x000fea000b800000ULL,
0x0000001010207810ULL, 0x000fe20007ffe0ffULL, 0x00001f240b0e7589ULL, 0x00066800000e0000ULL,
0x00001f200b0f7589ULL, 0x0006a400000e0000ULL, 0x0000001810247810ULL, 0x008fe20007ffe0ffULL,
0x000117f27f007947ULL, 0x000fea000b800000ULL, 0x00001f240b107589ULL, 0x0022e400000e0000ULL,
0x0000000a000b7819ULL, 0x002fe200000006ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001700022227810ULL, 0x000fe20007ffe0ffULL, 0x0000013000007945ULL, 0x000fe20003800000ULL,
0xfffff0000b0b7812ULL, 0x000fc600078ec0ffULL, 0x0000001014747824ULL, 0x100fe200078e0222ULL,
0x000150000b0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001013707824ULL, 0x100fe400078e0222ULL,
0x00000010156c7824ULL, 0x000fe400078e0222ULL, 0x0000001011117824ULL, 0x100fe400078e020bULL,
0x0000001012127824ULL, 0x000fc600078e020bULL, 0x000000001184783bULL, 0x0002e80000000200ULL,
0x000000001224783bULL, 0x0002a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000d84847231ULL, 0x08cfe400003400ffULL, 0x0000000d86867231ULL, 0x000fe400003400ffULL,
0x0000000e85857231ULL, 0x080fe400003400ffULL, 0x0000000e87877231ULL, 0x000fc400003400ffULL,
0x0000000f24247231ULL, 0x080fe400003400ffULL, 0x0000000f26267231ULL, 0x000fe400003400ffULL,
0x0000001025257231ULL, 0x080fe400003400ffULL, 0x0000001027277231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001016487824ULL, 0x000fe200078e0222ULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x0000025000007945ULL, 0x000fe60003800000ULL,
0x000000007070783bULL, 0x000fe80000004200ULL, 0x000000004848783bULL, 0x000ee80000004200ULL,
0x000000006c6c783bULL, 0x000ea40000004200ULL, 0x000000742444723cULL, 0x006f700000041844ULL,
0x00000048844c723cULL, 0x088f70000004184cULL, 0x00000048242c723cULL, 0x040b6e000004182cULL,
0x0000001017487824ULL, 0x120fe200078e020bULL, 0x000000762440723cULL, 0x000f620000041840ULL,
0x00000010180b7824ULL, 0x000fca00078e020bULL, 0x000000000b14783bULL, 0x0002a40000000200ULL,
0x00000070243c723cULL, 0x040f70000004183cULL, 0x000000722438723cULL, 0x040f700000041838ULL,
0x0000006c2434723cULL, 0x040f700000041834ULL, 0x0000006e2430723cULL, 0x000f700000041830ULL,
0x0000004a8428723cULL, 0x080f700000041828ULL, 0x0000004a2424723cULL, 0x000b640000041878ULL,
0x000000004848783bULL, 0x020eec0000000200ULL, 0x000000748464723cULL, 0x040b6e0000041864ULL,
0x000000221a747211ULL, 0x020fe200078e20ffULL, 0x000000768460723cULL, 0x040f700000041860ULL,
0x00000070845c723cULL, 0x040b6e000004185cULL, 0x0000001019707824ULL, 0x120fe200078e0222ULL,
0x000000728458723cULL, 0x040f700000041858ULL, 0x0000006c8454723cULL, 0x040b6e0000041854ULL,
0x000000101b6c7824ULL, 0x020fe200078e0222ULL, 0x0000006e8450723cULL, 0x000b620000041850ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x0000000d48487231ULL, 0x08efe400003400ffULL, 0x0000000d4a4a7231ULL, 0x000fc400003400ffULL,
0x0000000e49497231ULL, 0x080fe400003400ffULL, 0x0000000e4b4b7231ULL, 0x000fe400003400ffULL,
0x0000000f14147231ULL, 0x080fe400003400ffULL, 0x0000000f16167231ULL, 0x000fe400003400ffULL,
0x0000001015157231ULL, 0x080fe400003400ffULL, 0x0000001017177231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x00efea0003800000ULL, 0x000000101c187824ULL, 0x000fe200078e0222ULL,
0x000000007070783bULL, 0x000e680000004200ULL, 0x000000007474783bULL, 0x000ea80000004200ULL,
0x000000006c6c783bULL, 0x020ee80000004200ULL, 0x000000001818783bULL, 0x000ea20000004200ULL,
0x000000704864723cULL, 0x042b700000041864ULL, 0x000000724860723cULL, 0x040b700000041860ULL,
0x00000074485c723cULL, 0x044b70000004185cULL, 0x000000764858723cULL, 0x040b700000041858ULL,
0x0000006c4854723cULL, 0x048b700000041854ULL, 0x0000006e4850723cULL, 0x040b700000041850ULL,
0x00000018484c723cULL, 0x040b70000004184cULL, 0x0000001a4848723cULL, 0x000b700000041828ULL,
0x000000701444723cULL, 0x040b700000041844ULL, 0x000000721440723cULL, 0x040b700000041840ULL,
0x00000074143c723cULL, 0x040b70000004183cULL, 0x000000761438723cULL, 0x040b700000041838ULL,
0x0000006c1434723cULL, 0x040b700000041834ULL, 0x0000006e1430723cULL, 0x040b700000041830ULL,
0x00000018142c723cULL, 0x040b70000004182cULL, 0x0000001a1428723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000060200720cULL, 0x000fe20003f06070ULL,
0x01e6a0001dff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff80a000007947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x002e640000002500ULL,
0x000000060500720cULL, 0x002fda0003f06070ULL, 0x0000058000000947ULL, 0x000fea0003800000ULL,
0x0180000023027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0023ULL,
0x0000a120000a7802ULL, 0x000fc40000000f00ULL, 0x000115b000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002300027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc80000000023ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fc40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011604ULL, 0x00000018040f7811ULL, 0x040fe400078ff0ffULL,
0x00000008040b7811ULL, 0x040fe400078ff0ffULL, 0x00000010040d7811ULL, 0x000fe200078ff0ffULL,
0x00001f0302037589ULL, 0x000ea800000e0000ULL, 0x00001f0f02087589ULL, 0x000ee800000e0000ULL,
0x00001f0b02047589ULL, 0x000e6800000e0000ULL, 0x00001f0d02067589ULL, 0x002e6200000e0000ULL,
0x0000006403647220ULL, 0x024fc40000410000ULL, 0x0000006503657220ULL, 0x040fe40000410000ULL,
0x0000006003607220ULL, 0x040fe40000410000ULL, 0x0000006103617220ULL, 0x040fe40000410000ULL,
0x0000005c035c7220ULL, 0x040fe40000410000ULL, 0x0000005d035d7220ULL, 0x040fe40000410000ULL,
0x0000005803587220ULL, 0x000fc40000410000ULL, 0x0000005903597220ULL, 0x040fe40000410000ULL,
0x0000005403547220ULL, 0x040fe40000410000ULL, 0x0000005503557220ULL, 0x040fe40000410000ULL,
0x0000005003507220ULL, 0x040fe40000410000ULL, 0x0000005103517220ULL, 0x040fe40000410000ULL,
0x0000004c034c7220ULL, 0x000fc40000410000ULL, 0x0000004d034d7220ULL, 0x040fe40000410000ULL,
0x0000004803487220ULL, 0x040fe40000410000ULL, 0x0000004903497220ULL, 0x000fe40000410000ULL,
0x0000004608467220ULL, 0x048fe40000410000ULL, 0x0000004708477220ULL, 0x040fe40000410000ULL,
0x0000004208427220ULL, 0x000fc40000410000ULL, 0x0000004308437220ULL, 0x040fe40000410000ULL,
0x0000003e083e7220ULL, 0x040fe40000410000ULL, 0x0000003f083f7220ULL, 0x040fe40000410000ULL,
0x0000003a083a7220ULL, 0x040fe40000410000ULL, 0x0000003b083b7220ULL, 0x040fe40000410000ULL,
0x0000003608367220ULL, 0x000fc40000410000ULL, 0x0000003708377220ULL, 0x040fe40000410000ULL,
0x0000003208327220ULL, 0x040fe40000410000ULL, 0x0000003308337220ULL, 0x040fe40000410000ULL,
0x0000002e082e7220ULL, 0x040fe40000410000ULL, 0x0000002f082f7220ULL, 0x040fe40000410000ULL,
0x0000002a082a7220ULL, 0x000fc40000410000ULL, 0x0000002b082b7220ULL, 0x000fe40000410000ULL,
0x0000000466667220ULL, 0x080fe40000410000ULL, 0x0000000467677220ULL, 0x080fe40000410000ULL,
0x0000000462627220ULL, 0x080fe40000410000ULL, 0x0000000463637220ULL, 0x080fe40000410000ULL,
0x000000045e5e7220ULL, 0x000fc40000410000ULL, 0x000000045f5f7220ULL, 0x080fe40000410000ULL,
0x000000045a5a7220ULL, 0x080fe40000410000ULL, 0x000000045b5b7220ULL, 0x080fe40000410000ULL,
0x0000000456567220ULL, 0x080fe40000410000ULL, 0x0000000457577220ULL, 0x080fe40000410000ULL,
0x0000000452527220ULL, 0x000fc40000410000ULL, 0x0000000453537220ULL, 0x080fe40000410000ULL,
0x000000044e4e7220ULL, 0x080fe40000410000ULL, 0x000000044f4f7220ULL, 0x080fe40000410000ULL,
0x000000044a4a7220ULL, 0x080fe40000410000ULL, 0x000000044b4b7220ULL, 0x000fe40000410000ULL,
0x0000000644447220ULL, 0x002fc40000410000ULL, 0x0000000645457220ULL, 0x080fe40000410000ULL,
0x0000000640407220ULL, 0x080fe40000410000ULL, 0x0000000641417220ULL, 0x080fe40000410000ULL,
0x000000063c3c7220ULL, 0x080fe40000410000ULL, 0x000000063d3d7220ULL, 0x080fe40000410000ULL,
0x0000000638387220ULL, 0x000fc40000410000ULL, 0x0000000639397220ULL, 0x080fe40000410000ULL,
0x0000000634347220ULL, 0x080fe40000410000ULL, 0x0000000635357220ULL, 0x080fe40000410000ULL,
0x0000000630307220ULL, 0x080fe40000410000ULL, 0x0000000631317220ULL, 0x080fe40000410000ULL,
0x000000062c2c7220ULL, 0x000fc40000410000ULL, 0x000000062d2d7220ULL, 0x080fe40000410000ULL,
0x0000000628287220ULL, 0x080fe40000410000ULL, 0x0000000629297220ULL, 0x000fc60000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000000090573c2ULL, 0x000ea200000e0000ULL,
0x000000282928723eULL, 0x020fe400000010ffULL, 0x0000002a2b16723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000646504723eULL, 0x000fc400000010ffULL,
0x000000606106723eULL, 0x000fe400000010ffULL, 0x0000005c5d08723eULL, 0x000fe400000010ffULL,
0x00000058590a723eULL, 0x000fe400000010ffULL, 0x00000054550b723eULL, 0x000fe400000010ffULL,
0x0000002c2d2c723eULL, 0x000fe400000010ffULL, 0x00000050510c723eULL, 0x000fc400000010ffULL,
0x00000002ff1c7819ULL, 0x002fe20000011603ULL, 0x0000000d05057899ULL, 0x004fe2000800063fULL,
0x0000000803297811ULL, 0x000fe400078ff0ffULL, 0x000000021c177810ULL, 0x040fe20007ffe0ffULL,
0x000000081c187824ULL, 0x040fe200078e00ffULL, 0x000000011c027810ULL, 0x040fe20007ffe0ffULL,
0x000000081c197824ULL, 0x040fe200078e00ffULL, 0x000000061c1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000081c217824ULL, 0x000fe200078e00ffULL, 0xfffffff8181b7812ULL, 0x000fe200078ee217ULL,
0x000000081c1d7824ULL, 0x040fe200078e00ffULL, 0x000000051c187810ULL, 0x040fe20007ffe0ffULL,
0x000000081c1e7824ULL, 0x050fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee202ULL,
0x000000081c277824ULL, 0x040fe200078e00ffULL, 0x000000031c027810ULL, 0x000fc40007ffe0ffULL,
0x000000041c177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff821217812ULL, 0x000fe200078ee218ULL,
0x0000000829187824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee202ULL,
0xfffffff81e1f7812ULL, 0x000fe200078ee217ULL, 0x000000081c177824ULL, 0x040fe200078e00ffULL,
0xffffffff1c027810ULL, 0x000fe40007ffe0ffULL, 0xfffffff818297812ULL, 0x000fe200078ee229ULL,
0x0000000403187824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fc400078ee202ULL,
0xfffffff817177812ULL, 0x000fe400078ee21cULL, 0x0000000507027c11ULL, 0x000fe4000f8e60ffULL,
0x000000031c257819ULL, 0x000fe400000006ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0xfffffff825257812ULL, 0x000fe200078ee21aULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0x00000010032b7811ULL, 0x000fe200078ff0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0202ULL, 0x000000021d1d7211ULL, 0x000fe200078e20ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0202ULL, 0x00000018032d7811ULL, 0x000fe200078ff0ffULL,
0x0000000117177824ULL, 0x000fe200078e0218ULL, 0x0000001b181b7210ULL, 0x040fe20007ffe0ffULL,
0x0000001021217824ULL, 0x100fe200078e0202ULL, 0x0000004c4d0d723eULL, 0x000fe200000010ffULL,
0x0000000118197824ULL, 0x000fe200078e0219ULL, 0x0000000417007388ULL, 0x000fe20000000800ULL,
0x000000082b1a7824ULL, 0x000fe200078e00ffULL, 0x00000048490e723eULL, 0x000fe200000010ffULL,
0x0000001025257824ULL, 0x100fe200078e0202ULL, 0x0000000619007388ULL, 0x0003e20000000800ULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0xfffffff81a2b7812ULL, 0x000fe200078ee22bULL,
0x00000001181d7824ULL, 0x040fe200078e021dULL, 0x000000081b007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x100fe200078e0202ULL, 0x000000666766723eULL, 0x000fe200000010ffULL,
0x00000001181f7824ULL, 0x040fe200078e021fULL, 0x0000000a1d007388ULL, 0x000fe20000000800ULL,
0x0000000118217824ULL, 0x040fe200078e0221ULL, 0x000000626362723eULL, 0x000fe200000010ffULL,
0x0000000118257824ULL, 0x040fe200078e0225ULL, 0x0000000b1f007388ULL, 0x000fe20000000800ULL,
0x0000000118277824ULL, 0x040fe200078e0227ULL, 0x0000005e5f5e723eULL, 0x000fe200000010ffULL,
0x0000000118297824ULL, 0x040fe200078e0229ULL, 0x0000000c21007388ULL, 0x000fe20000000800ULL,
0x000000082d1c7824ULL, 0x000fe200078e00ffULL, 0x0000005a5b5a723eULL, 0x000fe200000010ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0202ULL, 0x0000000d25007388ULL, 0x0005e20000000800ULL,
0x000000565756723eULL, 0x000fe200000010ffULL, 0x000000ff00067306ULL, 0x002fe20000205400ULL,
0x000000525352723eULL, 0x000fe200000010ffULL, 0x0000000e27007388ULL, 0x000fe20000000800ULL,
0x0000004e4f4e723eULL, 0x000fe200000010ffULL, 0x00000001182b7824ULL, 0x000fe200078e022bULL,
0x0000004a4b4a723eULL, 0x000fe200000010ffULL, 0x0000006629007388ULL, 0x000fe20000000800ULL,
0xfffffff81c2d7812ULL, 0x000fe200078ee22dULL, 0x000000017e0d7824ULL, 0x004fe200078e0203ULL,
0x000000444544723eULL, 0x000fe200000010ffULL, 0x0004006219007388ULL, 0x000fe20000000800ULL,
0x000000404140723eULL, 0x000fe200000010ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0202ULL,
0x0000003c3d3c723eULL, 0x000fe200000010ffULL, 0x0004005e1b007388ULL, 0x000fe20000000800ULL,
0x000000383938723eULL, 0x000fe200000010ffULL, 0x0000000118187824ULL, 0x000fe200078e022dULL,
0x000000343534723eULL, 0x000fe200000010ffULL, 0x0004005a1d007388ULL, 0x000fe20000000800ULL,
0x000000303130723eULL, 0x000fe200000010ffULL, 0x000000ff000b7306ULL, 0x000e620000209400ULL,
0x00000046470f723eULL, 0x000fe200000010ffULL, 0x000400561f007388ULL, 0x000fe20000000800ULL,
0x000000424310723eULL, 0x000fc400000010ffULL, 0x0000003e3f11723eULL, 0x000fe200000010ffULL,
0x0004005221007388ULL, 0x000fe20000000800ULL, 0x0000003a3b12723eULL, 0x000fe200000010ffULL,
0x000000ff00047306ULL, 0x000ea2000020d400ULL, 0x000000363713723eULL, 0x000fe200000010ffULL,
0x0004004e25007388ULL, 0x000fe20000000800ULL, 0x000000323314723eULL, 0x000fe400000010ffULL,
0x0000002e2f15723eULL, 0x000fe200000010ffULL, 0x0004004a27007388ULL, 0x000fe20000000800ULL,
0x0000030000207a02ULL, 0x000fc40000000f00ULL, 0x000000060b00720bULL, 0x002fe20003f1d000ULL,
0x000000442b007388ULL, 0x000fe80000000800ULL, 0x0008004019007388ULL, 0x000fe80000000800ULL,
0x0008003c1b007388ULL, 0x000fe80000000800ULL, 0x000800381d007388ULL, 0x000fe20000000800ULL,
0x0000000104040812ULL, 0x004fc400078efcffULL, 0x000000012000780cULL, 0x000fe20003f05270ULL,
0x000800341f007388ULL, 0x000fe20000000800ULL, 0x00000004040a723eULL, 0x000fc600000010ffULL,
0x0008003021007388ULL, 0x000fe80000000800ULL, 0x0008002c25007388ULL, 0x000fe80000000800ULL,
0x0008002827007388ULL, 0x000fe80000000800ULL, 0x0000000f18007388ULL, 0x000fe80000000800ULL,
0x000c001019007388ULL, 0x000fe80000000800ULL, 0x000c00111b007388ULL, 0x000fe80000000800ULL,
0x000c00121d007388ULL, 0x000fe80000000800ULL, 0x000c00131f007388ULL, 0x000fe80000000800ULL,
0x000c001421007388ULL, 0x000fe80000000800ULL, 0x000c001525007388ULL, 0x000fe80000000800ULL,
0x000c001627007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000050d287984ULL, 0x000e68000800cc00ULL, 0x000400050d2c7984ULL, 0x000ea8000800cc00ULL,
0x000800050d1c7984ULL, 0x000ee8000800cc00ULL, 0x000c00050d147984ULL, 0x000ee8000800cc00ULL,
0x001000050d187984ULL, 0x000ee8000800cc00ULL, 0x001400050d107984ULL, 0x000ee8000800cc00ULL,
0x001800050d307984ULL, 0x000ee8000800cc00ULL, 0x001c00050d247984ULL, 0x000ee2000800cc00ULL,
0x3f803f800a2b7831ULL, 0x002fc4000020002bULL, 0x3f803f800a2a7831ULL, 0x040fe4000020002aULL,
0x3f803f800a297831ULL, 0x040fe40000200029ULL, 0x3f803f800a287831ULL, 0x040fe40000200028ULL,
0x3f803f800a2f7831ULL, 0x044fe4000020002fULL, 0x3f803f800a2e7831ULL, 0x040fe4000020002eULL,
0x3f803f800a2d7831ULL, 0x000fc4000020002dULL, 0x3f803f800a2c7831ULL, 0x040fe4000020002cULL,
0x3f803f800a1f7831ULL, 0x048fe4000020001fULL, 0x3f803f800a1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800a1d7831ULL, 0x040fe4000020001dULL, 0x3f803f800a1c7831ULL, 0x040fe4000020001cULL,
0x3f803f800a177831ULL, 0x000fc40000200017ULL, 0x3f803f800a167831ULL, 0x040fe40000200016ULL,
0x3f803f800a157831ULL, 0x040fe40000200015ULL, 0x3f803f800a147831ULL, 0x000fe40000200014ULL,
0x3f803f802b2b7831ULL, 0x000fe4000020001bULL, 0x3f803f802a2a7831ULL, 0x000fe4000020001aULL,
0x3f803f8029297831ULL, 0x000fc40000200019ULL, 0x3f803f8028287831ULL, 0x000fe40000200018ULL,
0x3f803f802f2f7831ULL, 0x000fe40000200013ULL, 0x3f803f802e2e7831ULL, 0x000fe20000200012ULL,
0x000000280d007988ULL, 0x000fe2000800cc05ULL, 0x3f803f802d2d7831ULL, 0x000fe40000200011ULL,
0x3f803f802c2c7831ULL, 0x000fe40000200010ULL, 0x3f803f801f1f7831ULL, 0x000fc40000200033ULL,
0x3f803f801e1e7831ULL, 0x000fe20000200032ULL, 0x0004002c0d007988ULL, 0x000fe2000800cc05ULL,
0x3f803f801d1d7831ULL, 0x000fe40000200031ULL, 0x3f803f801c1c7831ULL, 0x000fe40000200030ULL,
0x3f803f8017177831ULL, 0x000fe40000200027ULL, 0x3f803f8016167831ULL, 0x000fe20000200026ULL,
0x0008001c0d007988ULL, 0x000fe2000800cc05ULL, 0x3f803f8015157831ULL, 0x000fc40000200025ULL,
0x3f803f8014147831ULL, 0x000fca0000200024ULL, 0x000c00140d007988ULL, 0x000fe8000800cc05ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000397000008947ULL, 0x000fea0003800000ULL,
0x00000400ff067624ULL, 0x000fe200078e00ffULL, 0x00000000000a7919ULL, 0x000e620000002600ULL,
0x000000400d0f7810ULL, 0x000fc40007ffe0ffULL, 0x00006c0006067a24ULL, 0x000fe200078e02ffULL,
0x00000000000b7919ULL, 0x000e620000002700ULL, 0x000000800d117810ULL, 0x040fe40007ffe0ffULL,
0x000000c00d137810ULL, 0x000fe20007ffe0ffULL, 0x000000050d187984ULL, 0x000ea2000800cc00ULL,
0x0000000f06087811ULL, 0x040fe200078e10ffULL, 0x0000030006067a24ULL, 0x000fe400078e02ffULL,
0x000400050d247984ULL, 0x000ee2000800cc00ULL, 0xfffffff0084d7812ULL, 0x000fc600078ec0ffULL,
0x000800050d287984ULL, 0x000ea4000800cc00ULL, 0x00000080061f7824ULL, 0x040fe400078e024dULL,
0x000c00050d2c7984ULL, 0x0008a4000800cc00ULL, 0x0000008006067824ULL, 0x000fe400078e021fULL,
0x000004000b087a24ULL, 0x002fc600078e020aULL, 0x0000007f060a7810ULL, 0x000fe20007ffe0ffULL,
0x0000030008067a24ULL, 0x000fc600078e02ffULL, 0xffffff800a167812ULL, 0x000fe200078ec0ffULL,
0x0000000106057824ULL, 0x000fc600078e0205ULL, 0x00007000160a7a10ULL, 0x000fc80007f1e0ffULL,
0x0000000a050a7211ULL, 0x000fe200078268ffULL, 0x00007100ff0c7624ULL, 0x000fe200000e06ffULL,
0x0000000107ff7812ULL, 0x000fc8000780f800ULL, 0x0000000c050b7211ULL, 0x000fe400008f6cffULL,
0x000070004d177a10ULL, 0x000fc60007f3e0ffULL, 0x00001000090a7825ULL, 0x000fc800078e000aULL,
0x00007100ff1c7624ULL, 0x000fe400008e06ffULL, 0x000000100d0c7825ULL, 0x010fc800078e000aULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x00000010130a7825ULL, 0x000fe200078e000aULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001003137824ULL, 0x00cfe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x0000008005127824ULL, 0x000fe200078e00ffULL, 0x00000019ff057819ULL, 0x000fe40000011605ULL,
0x0000007013137812ULL, 0x000fe400078ec0ffULL, 0x0000000c14157812ULL, 0x000fe400078ec0ffULL,
0x0000700012147a10ULL, 0x000fc40007ebe01fULL, 0x0000001713127210ULL, 0x000fe40007a3e012ULL,
0x0000001415147210ULL, 0x000fe40007c7e013ULL, 0x0000710005137a10ULL, 0x000fe40002fec4ffULL,
0x0000001215127210ULL, 0x000fe40007fbe0ffULL, 0x0000001cff057210ULL, 0x000fe40000fe4405ULL,
0x00000013ff157210ULL, 0x000fc60001fe84ffULL, 0x000000ffff137224ULL, 0x000fca00028e0605ULL,
0x0000006812007986ULL, 0x0003e8000c101906ULL, 0x0000002314007986ULL, 0x0003e4000c101906ULL,
0x000000ff0300720cULL, 0x00cfe20000705670ULL, 0x000000180c007986ULL, 0x000fe2000c101d06ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000240e007986ULL, 0x000fe8000c101d06ULL,
0x0000002810007986ULL, 0x000fe8000c101d06ULL, 0x0000002c0a007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004000b7802ULL, 0x000fe40000000f00ULL, 0xffffffff20057810ULL, 0x000fc60007ffe0ffULL,
0x00007000080a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x000000050a0a79a8ULL, 0x000ea400099ee1c6ULL, 0x000000050a00720cULL, 0x004fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000008ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff057984ULL, 0x000ee40000000000ULL,
0x000000ff0500720cULL, 0x008fda0003f05270ULL, 0x0000347000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001003007824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011603ULL,
0x00000017060a7211ULL, 0x000fe400078038ffULL, 0x00000070000b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fe400078ec0ffULL, 0x0000001c06007211ULL, 0x000fe400000f3cffULL,
0x0000000a050a7210ULL, 0x000fc8000791e00bULL, 0x00000000ff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a007981ULL, 0x000728000c1e1900ULL, 0x000080060a057981ULL, 0x000722000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100060a0d7981ULL, 0x008722000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180060a0f7981ULL, 0x008722000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200060a117981ULL, 0x008722000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280060a137981ULL, 0x00a322000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe20003f06070ULL, 0x000300060a157981ULL, 0x000318000c1e1900ULL,
0x000380060a170981ULL, 0x000324000c1e1900ULL, 0x0000000720087810ULL, 0x00efc80007ffe0ffULL,
0x00000003ff087819ULL, 0x000fc80000011608ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000004d061b7211ULL, 0x040fe200078038ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff197224ULL, 0x010fe200078e0000ULL, 0x000070001b1b7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff060c7211ULL, 0x000fe400000f3cffULL, 0x000007801b1b7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0c7a10ULL, 0x000fc400017e240cULL, 0x000003000e007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000408007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080e0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000010e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001900007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0xfffc80060a197981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000020e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000500007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003057824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fc80000011603ULL, 0x0000007005057812ULL, 0x000fc800078ec0ffULL,
0x0000000c050a7812ULL, 0x000fc800078ef80aULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0xfffd00060a057981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000030e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000d00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0xfffd80060a0d7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000040e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000f00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000004030a7819ULL, 0x000fe400000006ffULL,
0x00000001ff0b7819ULL, 0x000fe40000011603ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0xfffe00060a0f7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000050e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001100007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0xfffe80060a117981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000060e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001300007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0xffff00060a137981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000070e0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001500007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0xffff80060a157981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000001700007209ULL, 0x000fe40007810000ULL, 0x000003000a007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011603ULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a1b0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060cULL, 0x000000060a177981ULL, 0x000326000c1e1900ULL,
0x000004001b1b7810ULL, 0x000fe40007f3e0ffULL, 0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000cff0c7210ULL, 0x000fe20000ffe4ffULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003057824ULL, 0x014fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc80000011603ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fca00078ec0ffULL, 0x0000000105057824ULL, 0x000fca00078e0208ULL,
0x0000000005007388ULL, 0x0005e40000000800ULL, 0x00007000160a7a10ULL, 0x002fe20007f3e0ffULL,
0x0000000107217824ULL, 0x000fe200078e0206ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x0000100009007824ULL, 0x004fe200078e00ffULL, 0x000000017d057812ULL, 0x040fe200078ec0ffULL,
0x00007100ff0b7624ULL, 0x000fe200008e06ffULL, 0x00000001ff517819ULL, 0x000fe20000011603ULL,
0x000010007d7d7824ULL, 0x000fe200078e00ffULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x00002000210c7825ULL, 0x000fe200078e000aULL, 0x0000004003137810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000c0c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000207228824ULL, 0x100fe200078e0209ULL, 0x0000006003157810ULL, 0x000fe20007ffe0ffULL,
0x0000000207088824ULL, 0x000fe200078e0209ULL, 0x0000000dff0d7210ULL, 0x000fe20000ffe4ffULL,
0x0000001003507824ULL, 0x040fe200078e00ffULL, 0x0000008003177810ULL, 0x040fe20007ffe0ffULL,
0x0000000222228824ULL, 0x100fe200078e0205ULL, 0x000000a003197810ULL, 0x040fe20007ffe0ffULL,
0x0000000208248824ULL, 0x000fe200078e0205ULL, 0x000000c0031b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001011107825ULL, 0x100fe200078e000cULL, 0x000000e0031d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000507057c11ULL, 0x000fe2000f8e70ffULL,
0x0000001013127825ULL, 0x100fe200078e000cULL, 0x000010007d087812ULL, 0x000fe200078ec0ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000007050507812ULL, 0x000fe200078ec0ffULL,
0x0000001015147825ULL, 0x100fe200078e000cULL, 0x0000000c51517812ULL, 0x000fe200078ec0ffULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000070004d4d7a10ULL, 0x000fe20007f5e0ffULL,
0x0000001017167825ULL, 0x100fe200078e000cULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001019187825ULL, 0x100fe200078e000cULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000101b1a7825ULL, 0x100fe200078e000cULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000cULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000010030e7825ULL, 0x000fe200078e000cULL, 0x000070001f0c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x000000ff000d7202ULL, 0x000fe20000000f00ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000150207824ULL, 0x000fe200078e0251ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000001003237824ULL, 0x000fe200078e0208ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00007100ff4e7624ULL, 0x000fe200008e06ffULL, 0x0000000c211e8211ULL, 0x000fe200078238ffULL,
0x0000000020087984ULL, 0x0002a20000000800ULL, 0x00007100ff4f7624ULL, 0x000fc400010e06ffULL,
0x0000004e211f8211ULL, 0x000fe200008f3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e237faeULL, 0x0007e2000b901c46ULL, 0x0000030007007a0cULL, 0x000fe20003f26070ULL,
0x0000000824248824ULL, 0x000fe200078e0203ULL, 0x0000004d21208211ULL, 0x042fe200078438ffULL,
0x0038000010237faeULL, 0x0003e2000b901c46ULL, 0x000000ffff4c7224ULL, 0x000fe400078e00ffULL,
0x0000004f21218211ULL, 0x000fe200010f3cffULL, 0x0058000012237faeULL, 0x0009e2000b901c46ULL,
0x000000ffff527224ULL, 0x000fc400078e00ffULL, 0x00000008220f8824ULL, 0x008fe200078e0203ULL,
0x0078000014237faeULL, 0x0007e8000b901c46ULL, 0x0098000016237faeULL, 0x0007e2000b901c46ULL,
0x000085800f0f8811ULL, 0x000fe200078e20ffULL, 0x0000000000107805ULL, 0x002fe2000001ff00ULL,
0x0000001003128825ULL, 0x010fe200078e001eULL, 0x00b8000018237faeULL, 0x0003e2000b901c46ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x0000001003148825ULL, 0x008fe200078e0020ULL,
0x00d800001a237faeULL, 0x0007e2000b901c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000818024178811ULL, 0x000fe400078e20ffULL, 0x00f800001c237faeULL, 0x0009e2000b901c46ULL,
0x0000000000247805ULL, 0x000fc6000001ff00ULL, 0x00000000120f8faeULL, 0x0005e2000b901c46ULL,
0x0000000000187805ULL, 0x002fc6000001ff00ULL, 0x0000000014178faeULL, 0x0003e2000b901c46ULL,
0x00000000001a7805ULL, 0x008fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x004fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000130000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff667224ULL, 0x000fca00078e0007ULL, 0x0000000266537810ULL, 0x000fc80007ffe0ffULL,
0x0000030053007a0cULL, 0x000fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x00000001ff547819ULL, 0x100fe20000011653ULL, 0x0000000106657824ULL, 0x000fe200078e0253ULL,
0x000000070300780cULL, 0x000fe40003f44070ULL, 0x0000000154557812ULL, 0x000fe200078ec0ffULL,
0x0000080053547824ULL, 0x000fe200078e00ffULL, 0x0000002003577810ULL, 0x000fe20007ffe0ffULL,
0x0000200065507825ULL, 0x000fe200078e000aULL, 0x0000004003597810ULL, 0x000fe40007ffe0ffULL,
0x0000100054547812ULL, 0x000fc400078ec0ffULL, 0x0000000050507210ULL, 0x000fe40007f1e0ffULL,
0x00000060035b7810ULL, 0x000fe20007ffe0ffULL, 0x000000020756a824ULL, 0x100fe200078e0209ULL,
0x00000080035d7810ULL, 0x000fe20007ffe0ffULL, 0x000000020768a824ULL, 0x000fe200078e0209ULL,
0x000000a0035f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105547824ULL, 0x000fe200078e0254ULL,
0x000000c003617810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff517224ULL, 0x000fe200000e0651ULL,
0x000000e003637810ULL, 0x040fe20007ffe0ffULL, 0x000000026868a824ULL, 0x000fe200078e0255ULL,
0x00000055566aa211ULL, 0x000fe200078e08ffULL, 0x0000001003677824ULL, 0x000fe200078e0254ULL,
0x0000000c6562a211ULL, 0x000fe200078038ffULL, 0x0000001003547825ULL, 0x000fe200078e0050ULL,
0x0000004d6564a211ULL, 0x000fc600078238ffULL, 0x0000001057567825ULL, 0x100fe200078e0050ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000054677faeULL, 0x0003e6000b901c46ULL,
0x0000001059587825ULL, 0x100fe200078e0050ULL, 0x0038000056677faeULL, 0x0005e6000b901c46ULL,
0x000000105b5a7825ULL, 0x100fe200078e0050ULL, 0x0058000058677faeULL, 0x0007e6000b901c46ULL,
0x000000105d5c7825ULL, 0x100fe200078e0050ULL, 0x007800005a677faeULL, 0x0007e6000b901c46ULL,
0x000000105f5e7825ULL, 0x100fe200078e0050ULL, 0x009800005c677faeULL, 0x0007e6000b901c46ULL,
0x0000001061607825ULL, 0x100fe200078e0050ULL, 0x00b800005e677faeULL, 0x0007e6000b901c46ULL,
0x0000001063507825ULL, 0x000fe200078e0050ULL, 0x0000004e6563a211ULL, 0x040fe200000f3cffULL,
0x00d8000060677faeULL, 0x0007e2000b901c46ULL, 0x0000004f6565a211ULL, 0x000fe200008f3cffULL,
0x000000086868a824ULL, 0x000fc400078e0203ULL, 0x000000086a6aa824ULL, 0x000fe200078e0203ULL,
0x00f8000050677faeULL, 0x0007e2000b901c46ULL, 0x000000100362a825ULL, 0x040fe200078e0062ULL,
0x000085806869a811ULL, 0x000fe400078e20ffULL, 0x000081806a57a811ULL, 0x004fe200078e20ffULL,
0x000000100354a825ULL, 0x002fe400078e0064ULL, 0x000000006269afaeULL, 0x0007e8000b901c46ULL,
0x000000005457afaeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004066507824ULL, 0x008fe200078e00ffULL, 0x00000001ff567819ULL, 0x000fe20000011603ULL,
0x0000000207557824ULL, 0x000fe200078e0209ULL, 0x00000002ff5a7819ULL, 0x000fe20000011603ULL,
0x0000001003517824ULL, 0x000fe200078e00ffULL, 0x0000008050507812ULL, 0x000fc400078ec0ffULL,
0x000000035a5f7819ULL, 0x040fe200000006ffULL, 0x000000085a617824ULL, 0x040fe200078e00ffULL,
0x000000085a6a7810ULL, 0x040fe20007ffe0ffULL, 0x0000010055547824ULL, 0x000fe200078e0050ULL,
0x0000007051507812ULL, 0x000fe200078ec0ffULL, 0x000000085a597824ULL, 0x000fe200078e00ffULL,
0x0000000c56517812ULL, 0x000fe200078ec0ffULL, 0x000000085a637824ULL, 0x040fe200078e00ffULL,
0x000000025a567810ULL, 0x040fe20007ffe0ffULL, 0x000000085a657824ULL, 0x040fe200078e00ffULL,
0x0000005451557210ULL, 0x000fe20007ffe050ULL, 0x000000085a6d7824ULL, 0x040fe200078e00ffULL,
0x000000015a547810ULL, 0x040fe20007ffe0ffULL, 0x000000085a6b7824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee256ULL, 0x0000000403567824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0081800055577984ULL, 0x000e620000000800ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee254ULL, 0x0000080066547824ULL, 0x000fe200078e00ffULL,
0x000000105a6c7810ULL, 0x000fe20007ffe0ffULL, 0x00858000555d7984ULL, 0x0004e20000000800ULL,
0x0000000c56667812ULL, 0x000fe400078ec0ffULL, 0x0000100054547812ULL, 0x000fe200078ec0ffULL,
0x000000086c5b7824ULL, 0x000fe200078e00ffULL, 0x000000035a587810ULL, 0x000fe40007ffe0ffULL,
0x0000018005547810ULL, 0x000fc40007ffe054ULL, 0xfffffff859557812ULL, 0x004fe200078ee25aULL,
0x000000086a597824ULL, 0x000fe200078e00ffULL, 0x000000185a6e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff863637812ULL, 0x000fe200078ee258ULL, 0x0000001055557824ULL, 0x000fe200078e0254ULL,
0x000000036e677819ULL, 0x000fe400000006ffULL, 0x000000045a5e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000166557824ULL, 0x000fe200078e0255ULL, 0x000000055a607810ULL, 0x000fc40007ffe0ffULL,
0xfffffff865657812ULL, 0x000fe400078ee25eULL, 0x00000000555c7984ULL, 0x0005220000000800ULL,
0x000000065a5e7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff86b6b7812ULL, 0x000fe400078ee260ULL,
0xfffffff86d6d7812ULL, 0x000fe400078ee25eULL, 0xffffffff5a607810ULL, 0x000fe20007ffe0ffULL,
0x0000001061557824ULL, 0x004fc800078e0254ULL, 0x0000000166557824ULL, 0x000fe400078e0255ULL,
0x0000005708567221ULL, 0x002fe20000010100ULL, 0xfffffff859577812ULL, 0x000fe400078ee26aULL,
0xfffffff85b597812ULL, 0x000fe200078ee26cULL, 0x3fb8aa3b56567820ULL, 0x000fe20000410000ULL,
0xfffffff8675b7812ULL, 0x000fe200078ee26eULL, 0x0000001057577824ULL, 0x100fe400078e0254ULL,
0x0000005600587308ULL, 0x0002e20000000800ULL, 0x0000001059597824ULL, 0x000fc400078e0254ULL,
0x0000000166577824ULL, 0x040fe400078e0257ULL, 0x0000000166597824ULL, 0x000fe400078e0259ULL,
0x000000105b5b7824ULL, 0x100fe200078e0254ULL, 0x0000000057677984ULL, 0x0005e20000000800ULL,
0x000000105f567824ULL, 0x002fc600078e0254ULL, 0x0000000059687984ULL, 0x0003e20000000800ULL,
0x0000005b665b7210ULL, 0x040fe20007ffe0ffULL, 0x0000000166567824ULL, 0x000fe400078e0256ULL,
0x0000005d585d7220ULL, 0x008fe40000410000ULL, 0x000000005b697984ULL, 0x0007e20000000800ULL,
0x0000001063577824ULL, 0x104fe400078e0254ULL, 0x000000085a597824ULL, 0x002fe200078e00ffULL,
0x00001f5a5d5e7589ULL, 0x0002a200000e0000ULL, 0x0000001065587824ULL, 0x000fc400078e0254ULL,
0x0000000166577824ULL, 0x040fe200078e0257ULL, 0x00001f6a5d5f7589ULL, 0x000ea200000e0000ULL,
0xfffffff8595b7812ULL, 0x008fe200078ee260ULL, 0x000000106b597824ULL, 0x000fe400078e0254ULL,
0x00001f6c5d607589ULL, 0x000ee200000e0000ULL, 0x0000000166587824ULL, 0x040fe200078e0258ULL,
0x000000546d5a7211ULL, 0x002fe200078e20ffULL, 0x000000105b547824ULL, 0x000fe200078e0254ULL,
0x0000000056627984ULL, 0x000fe20000000800ULL, 0x00005410ff5b7816ULL, 0x110fe2000000005cULL,
0x0000000166597824ULL, 0x040fe200078e0259ULL, 0x00007610ff5c7816ULL, 0x000fe2000000005cULL,
0x0000000055637984ULL, 0x000fe20000000800ULL, 0x00000001665a7824ULL, 0x000fc400078e025aULL,
0x0000000166547824ULL, 0x000fe200078e0254ULL, 0x00001f6e5d617589ULL, 0x000e6200000e0000ULL,
0x000000525d527221ULL, 0x000fe40000010000ULL, 0x0000005e5c4b7223ULL, 0x084fe2000001004bULL,
0x0000000057647984ULL, 0x000ea20000000800ULL, 0x00007610ff5c7816ULL, 0x100fe20000000067ULL,
0x0000005e5b4c7223ULL, 0x000fe2000001004cULL, 0x00005410ff5b7816ULL, 0x000fe20000000067ULL,
0x0000000058657984ULL, 0x000f240000000800ULL, 0x0000005f5c417223ULL, 0x080fe20000010041ULL,
0x00005410ff5c7816ULL, 0x000fe20000000068ULL, 0x0000000059667984ULL, 0x000f220000000800ULL,
0x0000005f5b167223ULL, 0x000fc60000010016ULL, 0x000000605c217223ULL, 0x088fe20000010021ULL,
0x00007610ff5c7816ULL, 0x000fe20000000068ULL, 0x000000005a5d7984ULL, 0x000ee80000000800ULL,
0x000000605c397223ULL, 0x000fe20000010039ULL, 0x00005410ff5c7816ULL, 0x000fe20000000069ULL,
0x0000000054677984ULL, 0x000ee80000000800ULL, 0x000000615c1f7223ULL, 0x002fe2000001001fULL,
0x00007610ff5c7816ULL, 0x000fe20000000069ULL, 0x0004000056687984ULL, 0x000e620000000800ULL,
0x00005410ff5b7816ULL, 0x000fc60000000062ULL, 0x000000615c317223ULL, 0x000fe20000010031ULL,
0x00007610ff5c7816ULL, 0x000fe20000000062ULL, 0x0004000055697984ULL, 0x000fe20000000800ULL,
0x0000005e5b4a7223ULL, 0x080fe2000001004aULL, 0x00005410ff5b7816ULL, 0x000fe40000000063ULL,
0x0000005e5c497223ULL, 0x080fe20000010049ULL, 0x00007610ff5c7816ULL, 0x000fe20000000063ULL,
0x0004000057627984ULL, 0x000e620000000800ULL, 0x0000005e5b487223ULL, 0x000fe20000010048ULL,
0x00005410ff5b7816ULL, 0x004fc40000000064ULL, 0x0000005e5c477223ULL, 0x080fe20000010047ULL,
0x00007610ff5c7816ULL, 0x000fe20000000064ULL, 0x0004000058637984ULL, 0x000fe20000000800ULL,
0x0000005e5b467223ULL, 0x080fe20000010046ULL, 0x00005410ff5b7816ULL, 0x010fe40000000065ULL,
0x0000005e5c457223ULL, 0x080fe20000010045ULL, 0x00007610ff5c7816ULL, 0x000fe20000000065ULL,
0x0004000059647984ULL, 0x000ea20000000800ULL, 0x0000005e5b447223ULL, 0x000fe20000010044ULL,
0x00007610ff5b7816ULL, 0x000fc40000000066ULL, 0x0000005e5c0f7223ULL, 0x080fe2000001000fULL,
0x00005410ff5c7816ULL, 0x000fe20000000066ULL, 0x000400005a657984ULL, 0x000fe20000000800ULL,
0x0000005e5b187223ULL, 0x080fe20000010018ULL, 0x00005410ff5b7816ULL, 0x008fe4000000005dULL,
0x0000005e5c2b7223ULL, 0x080fe2000001002bULL, 0x00007610ff5c7816ULL, 0x000fe2000000005dULL,
0x0004000054667984ULL, 0x000ee20000000800ULL, 0x0000005e5b2a7223ULL, 0x000fe2000001002aULL,
0x00007610ff5b7816ULL, 0x000fc40000000067ULL, 0x0000005e5c437223ULL, 0x080fe20000010043ULL,
0x00005410ff5c7816ULL, 0x000fe20000000067ULL, 0x00080000555d7984ULL, 0x000fe20000000800ULL,
0x0000005e5b427223ULL, 0x080fe20000010042ULL, 0x00005410ff5b7816ULL, 0x002fe40000000068ULL,
0x000c000056677984ULL, 0x000fe20000000800ULL, 0x0000005e5c297223ULL, 0x000fe40000010029ULL,
0x0000005f5b287223ULL, 0x000fe20000010028ULL, 0x00080000565c7984ULL, 0x0003220000000800ULL,
0x00007610ff5b7816ULL, 0x000fc60000000068ULL, 0x000c000055687984ULL, 0x0005240000000800ULL,
0x0000005f5b407223ULL, 0x080fe20000010040ULL, 0x00005410ff5b7816ULL, 0x100fe20000000062ULL,
0x00080000585e7984ULL, 0x000fe20000000800ULL, 0x00005410ff567816ULL, 0x002fe40000000069ULL,
0x00007610ff557816ULL, 0x004fe20000000062ULL, 0x0000005f5b267223ULL, 0x080fe20000010026ULL,
0x000c000057627984ULL, 0x000fe20000000800ULL, 0x0000005f56277223ULL, 0x080fe20000010027ULL,
0x00007610ff567816ULL, 0x000fe20000000069ULL, 0x0000005f553e7223ULL, 0x080fe2000001003eULL,
0x00005410ff557816ULL, 0x000fe20000000064ULL, 0x00080000575b7984ULL, 0x000e640000000800ULL,
0x0000005f563f7223ULL, 0x080fe2000001003fULL, 0x00005410ff567816ULL, 0x000fe20000000063ULL,
0x0000005f55247223ULL, 0x080fe20000010024ULL, 0x00007610ff557816ULL, 0x000fe20000000064ULL,
0x0008000059577984ULL, 0x000fe40000000800ULL, 0x0000005f56257223ULL, 0x080fe20000010025ULL,
0x00007610ff567816ULL, 0x000fe20000000063ULL, 0x0000005f553c7223ULL, 0x080fe2000001003cULL,
0x00005410ff557816ULL, 0x008fe20000000066ULL, 0x000c000058637984ULL, 0x000ea40000000800ULL,
0x0000005f563d7223ULL, 0x080fe2000001003dULL, 0x00005410ff567816ULL, 0x000fe20000000065ULL,
0x0000005f55227223ULL, 0x000fe20000010022ULL, 0x00007610ff557816ULL, 0x000fe20000000066ULL,
0x000800005a587984ULL, 0x000fe20000000800ULL, 0x000000ffff667224ULL, 0x000fc400078e0053ULL,
0x0000005f56237223ULL, 0x080fe20000010023ULL, 0x00007610ff567816ULL, 0x000fe20000000065ULL,
0x0000005f553a7223ULL, 0x080fe2000001003aULL, 0x00005410ff557816ULL, 0x010fe4000000005cULL,
0x0000030066007a0cULL, 0x000fe20003f06070ULL, 0x0000005f563b7223ULL, 0x000fe2000001003bULL,
0x00005410ff567816ULL, 0x000fe20000000067ULL, 0x0000006055207223ULL, 0x080fe20000010020ULL,
0x00007610ff557816ULL, 0x000fe2000000005cULL, 0x000c0000595f7984ULL, 0x000ee40000000800ULL,
0x0000006156177223ULL, 0x000fe20000010017ULL, 0x00007610ff567816ULL, 0x000fe2000000005dULL,
0x0000006055387223ULL, 0x000fe20000010038ULL, 0x0008000054597984ULL, 0x000fe20000000800ULL,
0x00007610ff557816ULL, 0x000fc40000000067ULL, 0x0000006056377223ULL, 0x080fe20000010037ULL,
0x00005410ff567816ULL, 0x000fe20000000068ULL, 0x000c00005a5c7984ULL, 0x000f220000000800ULL,
0x0000006155307223ULL, 0x080fe20000010030ULL, 0x00005410ff557816ULL, 0x000fe4000000005dULL,
0x0000006156157223ULL, 0x000fe40000010015ULL, 0x000c000054567984ULL, 0x0005220000000800ULL,
0x00000060551e7223ULL, 0x000fe2000001001eULL, 0x00007610ff557816ULL, 0x002fca000000005bULL,
0x0000006055367223ULL, 0x000fe20000010036ULL, 0x00007610ff547816ULL, 0x004fe40000000068ULL,
0x00005410ff557816ULL, 0x000fc60000000062ULL, 0x00000061542f7223ULL, 0x080fe2000001002fULL,
0x00005410ff547816ULL, 0x000fe2000000005bULL, 0x0000006155147223ULL, 0x000fe20000010014ULL,
0x00007610ff557816ULL, 0x000fc60000000062ULL, 0x00000060541d7223ULL, 0x000fe2000001001dULL,
0x00007610ff547816ULL, 0x000fe2000000005eULL, 0x00000061552e7223ULL, 0x000fe2000001002eULL,
0x00005410ff557816ULL, 0x000fc6000000005eULL, 0x0000006054357223ULL, 0x080fe20000010035ULL,
0x00005410ff547816ULL, 0x000fe20000000063ULL, 0x00000060551c7223ULL, 0x000fe2000001001cULL,
0x00007610ff557816ULL, 0x000fc60000000057ULL, 0x0000006154137223ULL, 0x080fe20000010013ULL,
0x00007610ff547816ULL, 0x000fe20000000063ULL, 0x0000006055347223ULL, 0x080fe20000010034ULL,
0x00005410ff557816ULL, 0x008fe4000000005fULL, 0x00007610ff537816ULL, 0x010fe2000000005cULL,
0x00000061542d7223ULL, 0x080fe2000001002dULL, 0x00005410ff547816ULL, 0x000fe20000000057ULL,
0x0000006155127223ULL, 0x080fe20000010012ULL, 0x00005410ff557816ULL, 0x000fe20000000058ULL,
0x00000061532c7223ULL, 0x080fe2000001002cULL, 0x00007610ff537816ULL, 0x000fe20000000059ULL,
0x00000060541b7223ULL, 0x080fe2000001001bULL, 0x00007610ff547816ULL, 0x000fe2000000005fULL,
0x00000060551a7223ULL, 0x080fe2000001001aULL, 0x00005410ff557816ULL, 0x000fe2000000005cULL,
0x0000006053327223ULL, 0x000fe20000010032ULL, 0x00005410ff537816ULL, 0x000fe20000000056ULL,
0x0000006154117223ULL, 0x080fe20000010011ULL, 0x00007610ff547816ULL, 0x000fe20000000058ULL,
0x00000061550e7223ULL, 0x000fc4000001000eULL, 0x0000006153107223ULL, 0x000fe40000010010ULL,
0x0000006054337223ULL, 0x000fe20000010033ULL, 0x00005410ff547816ULL, 0x000fca0000000059ULL,
0x0000006054197223ULL, 0x000fe20000010019ULL, 0x00007610ff547816ULL, 0x000fca0000000056ULL,
0x00000061540d7223ULL, 0x000fe2000001000dULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffed2000007947ULL, 0x000fea000383ffffULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x0000008007008824ULL, 0x000fe400078e0250ULL,
0x0000000150507824ULL, 0x000fe400078e0251ULL, 0x0000000151038824ULL, 0x000fca00078e0200ULL,
0x0089805203008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0089800050007984ULL, 0x000e680000000800ULL, 0x008a000050057984ULL, 0x000ea20000000800ULL,
0x00000000ff007221ULL, 0x002fc80000010000ULL, 0x0000000500007221ULL, 0x004fca0000010000ULL,
0x0180000000057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0000ULL,
0x0000dba0000a7802ULL, 0x000fc40000000f00ULL, 0x0000db3000007944ULL, 0x000fea0003c00000ULL,
0x0000000300057202ULL, 0x00cfe20000000f00ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000057308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000005ULL,
0x800000ff03067221ULL, 0x000fc80000010100ULL, 0x0000000605057223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff4e7819ULL, 0x104fe20000011603ULL,
0x000000017e7e7824ULL, 0x000fe200078e0203ULL, 0x0000000803507811ULL, 0x000fc400078ff0ffULL,
0x0000001003527811ULL, 0x040fe200078ff0ffULL, 0x00001f4e05007589ULL, 0x000ea200000e0000ULL,
0x0000001803547811ULL, 0x000fe200078ff0ffULL, 0x000000084e4f7824ULL, 0x040fe400078e00ffULL,
0x00001f50050b7589ULL, 0x000ee200000e0000ULL, 0x000000084e517824ULL, 0x000fe200078e00ffULL,
0x00000003545d7819ULL, 0x000fe200000006ffULL, 0x000000084e577824ULL, 0x040fe200078e00ffULL,
0x00001f52050c7589ULL, 0x000f2200000e0000ULL, 0x000000084e557824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee254ULL, 0x00000008525b7824ULL, 0x000fc400078e00ffULL,
0x0000000850597824ULL, 0x000fe400078e00ffULL, 0x000000105d5d7824ULL, 0x000fe200078e0202ULL,
0xfffffff85b5b7812ULL, 0x000fe400078ee252ULL, 0xfffffff859597812ULL, 0x000fc600078ee250ULL,
0x000000105b5b7824ULL, 0x000fe200078e0202ULL, 0x0000000259597211ULL, 0x000fe200078e20ffULL,
0x0000004c004c7220ULL, 0x044fe40000410000ULL, 0x0000004b004b7220ULL, 0x040fe40000410000ULL,
0x0000004a004a7220ULL, 0x040fe40000410000ULL, 0x0000004900497220ULL, 0x040fe20000410000ULL,
0x0000004c4b4b723eULL, 0x000fe200000010ffULL, 0x0000004800487220ULL, 0x000fc40000410000ULL,
0x0000004700477220ULL, 0x040fe20000410000ULL, 0x0000004a4949723eULL, 0x000fe200000010ffULL,
0x0000004600467220ULL, 0x040fe40000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x000000484747723eULL, 0x000fe200000010ffULL, 0x0000004400447220ULL, 0x040fe40000410000ULL,
0x0000000f000f7220ULL, 0x040fe20000410000ULL, 0x000000464545723eULL, 0x000fe200000010ffULL,
0x0000002b002b7220ULL, 0x000fc40000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x000000440f0f723eULL, 0x000fe200000010ffULL, 0x0000002a002a7220ULL, 0x040fe40000410000ULL,
0x0000004300437220ULL, 0x000fe20000410000ULL, 0x0000002b1818723eULL, 0x000fe200000010ffULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000004200007220ULL, 0x000fe20000410000ULL,
0x0000002a432a723eULL, 0x000fe200000010ffULL, 0x00001f5405427589ULL, 0x00046400000e0000ULL,
0x0000003f0b067220ULL, 0x00afc40000410000ULL, 0x000000160b167220ULL, 0x040fe20000410000ULL,
0x000000290000723eULL, 0x000fe200000010ffULL, 0x000000410b417220ULL, 0x040fe40000410000ULL,
0x000000280b287220ULL, 0x040fe40000410000ULL, 0x000000400b4d7220ULL, 0x000fe20000410000ULL,
0x000000164116723eULL, 0x000fe200000010ffULL, 0x000000270b277220ULL, 0x040fe40000410000ULL,
0x000000260b267220ULL, 0x000fe20000410000ULL, 0x000000284d28723eULL, 0x000fe200000010ffULL,
0x0000003e0b3f7220ULL, 0x040fe20000410000ULL, 0x000000034e3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000250b257220ULL, 0x040fe20000410000ULL, 0x000000270606723eULL, 0x000fe200000010ffULL,
0x0000003d0b087220ULL, 0x000fe20000410000ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee23eULL,
0x000000240b247220ULL, 0x000fe20000410000ULL, 0x000000263f26723eULL, 0x000fe200000010ffULL,
0x0000003c0b057220ULL, 0x044fe20000410000ULL, 0x000000024e3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000230b237220ULL, 0x040fe20000410000ULL, 0x000000250808723eULL, 0x000fe200000010ffULL,
0x0000003b0b0a7220ULL, 0x040fe20000410000ULL, 0x000000014e3b7810ULL, 0x000fe20007ffe0ffULL,
0x000000220b227220ULL, 0x000fe20000410000ULL, 0x000000240505723eULL, 0x000fe200000010ffULL,
0x0000003a0b0b7220ULL, 0x000fe20000410000ULL, 0x000000230a0a723eULL, 0x000fe200000010ffULL,
0x000000390c3a7220ULL, 0x010fc40000410000ULL, 0x000000380c397220ULL, 0x000fe20000410000ULL,
0x000000220b0b723eULL, 0x000fe200000010ffULL, 0x0000002f42387220ULL, 0x040fe40000410000ULL,
0x0000002e422f7220ULL, 0x000fe40000410000ULL, 0x000000210c217220ULL, 0x040fe40000410000ULL,
0x000000200c207220ULL, 0x040fe40000410000ULL, 0x0000001e0c1e7220ULL, 0x000fe20000410000ULL,
0x000000213a21723eULL, 0x000fe200000010ffULL, 0x000000370c377220ULL, 0x040fe20000410000ULL,
0x000000203920723eULL, 0x000fe200000010ffULL, 0x0000001d0c1d7220ULL, 0x000fc40000410000ULL,
0x000000360c367220ULL, 0x040fe20000410000ULL, 0x0000001e371e723eULL, 0x000fe200000010ffULL,
0x0000001c0c1c7220ULL, 0x040fe40000410000ULL, 0x000000350c357220ULL, 0x000fe20000410000ULL,
0x0000001d361d723eULL, 0x000fe200000010ffULL, 0x0000001b0c1b7220ULL, 0x040fe40000410000ULL,
0x000000340c347220ULL, 0x040fe20000410000ULL, 0x0000001c351c723eULL, 0x000fe200000010ffULL,
0x0000001a0c1a7220ULL, 0x000fc40000410000ULL, 0x000000330c337220ULL, 0x000fe20000410000ULL,
0x0000001b341b723eULL, 0x000fe200000010ffULL, 0x000000190c197220ULL, 0x000fe40000410000ULL,
0x0000002d422e7220ULL, 0x000fe20000410000ULL, 0x0000001a331a723eULL, 0x000fe200000010ffULL,
0x000000320c0c7220ULL, 0x000fe40000410000ULL, 0x000000084e3d7824ULL, 0x000fe400078e00ffULL,
0x0000002c422d7220ULL, 0x000fe20000410000ULL, 0x000000044e2c7810ULL, 0x000fe20007ffe0ffULL,
0x0000003142327220ULL, 0x000fe20000410000ULL, 0x000000054e317810ULL, 0x040fe20007ffe0ffULL,
0x000000084e3e7824ULL, 0x040fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee23cULL,
0x000000084e407824ULL, 0x000fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee22cULL,
0x0000001042107220ULL, 0x000fe20000410000ULL, 0x000000190c0c723eULL, 0x000fe200000010ffULL,
0x0000000d420d7220ULL, 0x000fe20000410000ULL, 0x000000064e3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000403197824ULL, 0x000fe200078e00ffULL, 0xfffffff83e537812ULL, 0x000fe200078ee231ULL,
0x000000103d3d7824ULL, 0x000fe200078e0202ULL, 0xffffffff4e2c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001242127220ULL, 0x040fe20000410000ULL, 0xfffffff857317812ULL, 0x000fe200078ee24eULL,
0x0000001142117220ULL, 0x000fe20000410000ULL, 0xfffffff8403b7812ULL, 0x000fe200078ee23bULL,
0x000000104f4f7824ULL, 0x000fe200078e0202ULL, 0xfffffff855557812ULL, 0x000fe200078ee23cULL,
0x0000001031317824ULL, 0x000fe200078e0202ULL, 0xfffffff857577812ULL, 0x000fe200078ee22cULL,
0x000000103b3b7824ULL, 0x100fe200078e0202ULL, 0x000000100d0d723eULL, 0x000fe200000010ffULL,
0x0000001051517824ULL, 0x100fe200078e0202ULL, 0x0000000c19107812ULL, 0x000fe200078ec0ffULL,
0x0000001053537824ULL, 0x100fe200078e0202ULL, 0x000000121111723eULL, 0x000fe200000010ffULL,
0x0000001055557824ULL, 0x000fc400078e0202ULL, 0x0000001057577824ULL, 0x000fe400078e0202ULL,
0x0000000131027824ULL, 0x000fe400078e0210ULL, 0x00000001103b7824ULL, 0x040fe200078e023bULL,
0x0000005710577210ULL, 0x040fe20007ffe0ffULL, 0x00000001103d7824ULL, 0x040fe200078e023dULL,
0x0000004b02007388ULL, 0x000fe20000000800ULL, 0x00000001104f7824ULL, 0x040fe400078e024fULL,
0x0000000110517824ULL, 0x040fe200078e0251ULL, 0x000000493b007388ULL, 0x000fe20000000800ULL,
0x0000000110127824ULL, 0x000fc400078e0253ULL, 0x0000000110557824ULL, 0x040fe200078e0255ULL,
0x000000473d007388ULL, 0x000fe20000000800ULL, 0x0000000110597824ULL, 0x040fe400078e0259ULL,
0x0000000110227824ULL, 0x000fe200078e025bULL, 0x000000454f007388ULL, 0x000fe20000000800ULL,
0x0000001f421f7220ULL, 0x040fe40000410000ULL, 0x0000001742177220ULL, 0x040fe20000410000ULL,
0x0000000f51007388ULL, 0x000fe20000000800ULL, 0x0000003042307220ULL, 0x000fe20000410000ULL,
0x0000001f321f723eULL, 0x000fe200000010ffULL, 0x0000001542157220ULL, 0x040fe20000410000ULL,
0x0000001812007388ULL, 0x000fe20000000800ULL, 0x0000001442147220ULL, 0x000fe20000410000ULL,
0x000000173017723eULL, 0x000fe200000010ffULL, 0x0000001342137220ULL, 0x000fe20000410000ULL,
0x0000002a55007388ULL, 0x000fe20000000800ULL, 0x0000000110107824ULL, 0x000fe200078e025dULL,
0x000000153815723eULL, 0x000fe200000010ffULL, 0x0000000e420e7220ULL, 0x000fe20000410000ULL,
0x0000000057007388ULL, 0x000fe20000000800ULL, 0x000000142f14723eULL, 0x000fc400000010ffULL,
0x000000132e13723eULL, 0x000fe200000010ffULL, 0x0000001659007388ULL, 0x000fe20000000800ULL,
0x0000000e2d0e723eULL, 0x000fc600000010ffULL, 0x000400283b007388ULL, 0x000fe80000000800ULL,
0x000400063d007388ULL, 0x000fe80000000800ULL, 0x000400264f007388ULL, 0x000fe80000000800ULL,
0x0004000851007388ULL, 0x0003e80000000800ULL, 0x0004000512007388ULL, 0x000fe80000000800ULL,
0x0004000a55007388ULL, 0x000fe20000000800ULL, 0x000000040408723eULL, 0x002fc600000010ffULL,
0x0004000b57007388ULL, 0x000fe80000000800ULL, 0x0000002122007388ULL, 0x000fe80000000800ULL,
0x000800203b007388ULL, 0x000fe80000000800ULL, 0x0008001e3d007388ULL, 0x000fe80000000800ULL,
0x0008001d4f007388ULL, 0x000fe80000000800ULL, 0x0008001c51007388ULL, 0x000fe80000000800ULL,
0x0008001b12007388ULL, 0x000fe80000000800ULL, 0x0008001a55007388ULL, 0x000fe80000000800ULL,
0x0008000c57007388ULL, 0x000fe80000000800ULL, 0x0000001f10007388ULL, 0x000fe80000000800ULL,
0x000c00173b007388ULL, 0x000fe80000000800ULL, 0x000c00153d007388ULL, 0x000fe80000000800ULL,
0x000c00144f007388ULL, 0x000fe80000000800ULL, 0x000c001351007388ULL, 0x000fe80000000800ULL,
0x000c001112007388ULL, 0x000fe80000000800ULL, 0x000c000e55007388ULL, 0x000fe80000000800ULL,
0x000c000d57007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000057e187984ULL, 0x000e68000800cc00ULL, 0x000400057e207984ULL, 0x000ea8000800cc00ULL,
0x000800057e147984ULL, 0x000ee8000800cc00ULL, 0x000c00057e107984ULL, 0x000f28000800cc00ULL,
0x001000057e1c7984ULL, 0x000ee8000800cc00ULL, 0x001400057e247984ULL, 0x000f28000800cc00ULL,
0x001800057e287984ULL, 0x000f28000800cc00ULL, 0x001c00057e2c7984ULL, 0x000f22000800cc00ULL,
0x3f803f80081b7831ULL, 0x002fc4000020001bULL, 0x3f803f80081a7831ULL, 0x040fe4000020001aULL,
0x3f803f8008197831ULL, 0x040fe40000200019ULL, 0x3f803f8008187831ULL, 0x040fe40000200018ULL,
0x3f803f8008237831ULL, 0x044fe40000200023ULL, 0x3f803f8008227831ULL, 0x040fe40000200022ULL,
0x3f803f8008217831ULL, 0x000fc40000200021ULL, 0x3f803f8008207831ULL, 0x040fe40000200020ULL,
0x3f803f8008177831ULL, 0x048fe40000200017ULL, 0x3f803f8008167831ULL, 0x040fe40000200016ULL,
0x3f803f8008157831ULL, 0x040fe40000200015ULL, 0x3f803f8008147831ULL, 0x040fe40000200014ULL,
0x3f803f8008137831ULL, 0x010fc40000200013ULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x3f803f8008107831ULL, 0x000fe40000200010ULL,
0x3f803f801b1b7831ULL, 0x000fe4000020001fULL, 0x3f803f801a1a7831ULL, 0x000fe4000020001eULL,
0x3f803f8019197831ULL, 0x000fc4000020001dULL, 0x3f803f8018187831ULL, 0x000fe4000020001cULL,
0x3f803f8023237831ULL, 0x000fe40000200027ULL, 0x3f803f8022227831ULL, 0x000fe20000200026ULL,
0x000000187e007988ULL, 0x000fe2000800cc05ULL, 0x3f803f8021217831ULL, 0x000fe40000200025ULL,
0x3f803f8020207831ULL, 0x000fe40000200024ULL, 0x3f803f8017177831ULL, 0x000fc4000020002bULL,
0x3f803f8016167831ULL, 0x000fe2000020002aULL, 0x000400207e007988ULL, 0x000fe2000800cc05ULL,
0x3f803f8015157831ULL, 0x000fe40000200029ULL, 0x3f803f8014147831ULL, 0x000fe40000200028ULL,
0x3f803f8013137831ULL, 0x000fe4000020002fULL, 0x3f803f8012127831ULL, 0x000fe2000020002eULL,
0x000800147e007988ULL, 0x000fe2000800cc05ULL, 0x3f803f8011117831ULL, 0x000fc4000020002dULL,
0x3f803f8010107831ULL, 0x000fca000020002cULL, 0x000c00107e007988ULL, 0x000fe8000800cc05ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0700720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fc80000011603ULL,
0x000000810600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000077b06ULL, 0x000ee20000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff137a12ULL, 0x002fe200078e33ffULL, 0x000000019f007824ULL, 0x000fe400078e0206ULL,
0x0000000106067824ULL, 0x000fca00078e0203ULL, 0x0000000706067812ULL, 0x000fc800078ec0ffULL,
0x0ffffff806067812ULL, 0x000fe200078ef803ULL, 0x0000000700077308ULL, 0x008e680000001000ULL,
0x00000005060c7984ULL, 0x000ee2000800cc00ULL, 0x0ffffffe07087810ULL, 0x006fc80007ffe0ffULL,
0x0000000800057305ULL, 0x000e64000021f000ULL, 0x000000ffff0b7224ULL, 0x002fc800078e0a05ULL,
0x00005a000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b05117227ULL, 0x000fe200078e0004ULL,
0x00000020030b7810ULL, 0x000fca0007ffe0ffULL, 0x0000000011027227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a02ULL, 0x00005a0005047a24ULL, 0x000fca00078e0200ULL,
0x00005a0004007a0cULL, 0x000fda0003f06070ULL, 0x80005a0004040a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102020810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000102021810ULL, 0x000fc80007ffe0ffULL,
0x0000000213027207ULL, 0x000fc80004000000ULL, 0x000000ff02077210ULL, 0x040fe20007ffe1ffULL,
0x0000590002057a24ULL, 0x000fe200078e027fULL, 0x0000000703027812ULL, 0x000fc600078ec0ffULL,
0x00005a0007007a24ULL, 0x000fe400078e0200ULL, 0x0000000809077824ULL, 0x000fe400078e0202ULL,
0x00005a0005057a24ULL, 0x000fca00078e0200ULL, 0x0000000582057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4400ULL, 0x00000003ff007819ULL, 0x000fc6000001160bULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000810000720cULL, 0x000fc80003f26070ULL,
0x0000000c04007986ULL, 0x0083f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019f027824ULL, 0x100fe200078e0200ULL, 0x0000004003157810ULL, 0x000fe20007ffe0ffULL,
0x000000010b007824ULL, 0x000fc400078e0200ULL, 0x0000000211047227ULL, 0x002fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a04ULL,
0x0ffffff800007812ULL, 0x000fe200078ef80bULL, 0x00005a0005057a24ULL, 0x000fc800078e0202ULL,
0x00000005000c7984ULL, 0x0002a2000800cc00ULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd60000011615ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f46070ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x0000000413047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x000000070b027812ULL, 0x000fc800078ec0ffULL, 0x0000000582057210ULL, 0x000fe20007f3e0ffULL,
0x0000000809077824ULL, 0x000fc800078e0202ULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019f027824ULL, 0x100fe200078e0200ULL, 0x00000060030b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000115007824ULL, 0x000fe400078e0200ULL, 0x0000000211047227ULL, 0x002fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x000000ff04057210ULL, 0x000fe40007ffe1ffULL,
0x0ffffff800007812ULL, 0x000fc600078ef815ULL, 0x00005a0005057a24ULL, 0x000fe400078e0202ULL,
0x00000005000c7984ULL, 0x0002a6000800cc00ULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd6000001160bULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f46070ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x0000000413047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x0000000715027812ULL, 0x000fc800078ec0ffULL, 0x0000000582057210ULL, 0x000fe20007f3e0ffULL,
0x0000000809077824ULL, 0x000fc800078e0202ULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019f027824ULL, 0x100fe200078e0200ULL, 0x0000008003157810ULL, 0x000fe20007ffe0ffULL,
0x000000010b007824ULL, 0x000fe400078e0200ULL, 0x0000000211047227ULL, 0x002fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a04ULL,
0x0ffffff800007812ULL, 0x000fe200078ef80bULL, 0x00005a0005057a24ULL, 0x000fc800078e0202ULL,
0x00000005000c7984ULL, 0x0002a2000800cc00ULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd60000011615ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f46070ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x0000000413047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x000000070b027812ULL, 0x000fc800078ec0ffULL, 0x0000000582057210ULL, 0x000fe40007f3e0ffULL,
0x0000000209077211ULL, 0x000fc600078e18ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019f027824ULL, 0x100fe200078e0200ULL, 0x000000a0030b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000115007824ULL, 0x000fe400078e0200ULL, 0x0000000211047227ULL, 0x002fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a04ULL,
0x0ffffff800007812ULL, 0x000fe200078ef815ULL, 0x00005a0005057a24ULL, 0x000fc800078e0202ULL,
0x00000005000c7984ULL, 0x0002a2000800cc00ULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd6000001160bULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f46070ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x0000000413047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x0000000715027812ULL, 0x000fc800078ec0ffULL, 0x0000000582057210ULL, 0x000fe20007f3e0ffULL,
0x0000000809077824ULL, 0x000fc800078e0202ULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019f027824ULL, 0x100fe200078e0200ULL, 0x000000c003157810ULL, 0x000fe20007ffe0ffULL,
0x000000010b007824ULL, 0x000fe400078e0200ULL, 0x0000000211047227ULL, 0x002fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a04ULL,
0x0ffffff800007812ULL, 0x000fe200078ef80bULL, 0x00005a0005057a24ULL, 0x000fc800078e0202ULL,
0x00000005000c7984ULL, 0x0002a2000800cc00ULL, 0x00005a0005007a0cULL, 0x000fe40003f26070ULL,
0x00000003ff007819ULL, 0x002fd60000011615ULL, 0x80005a0005051a10ULL, 0x000fe40007ffe0ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x00005a0005007a0cULL, 0x000fda0003f46070ULL,
0x0000000104042810ULL, 0x000fc80007ffe0ffULL, 0x0000000413047207ULL, 0x000fc80004000000ULL,
0x000000ff04077210ULL, 0x040fe20007ffe1ffULL, 0x0000590004057a24ULL, 0x000fc800078e027fULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005057a24ULL, 0x000fe200078e0202ULL,
0x000000070b027812ULL, 0x000fc800078ec0ffULL, 0x0000000582057210ULL, 0x000fe20007f3e0ffULL,
0x0000000809077824ULL, 0x000fc800078e0202ULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f4406ULL,
0x000000810000720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019f027824ULL, 0x100fe400078e0200ULL, 0x0000000115007824ULL, 0x000fe400078e0200ULL,
0x0000000211087227ULL, 0x000fc600078e00ffULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x002fc600078e0a08ULL, 0x0ffffff800007812ULL, 0x000fe200078ef815ULL,
0x00005a0005047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108081810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0000000500047984ULL, 0x0002b6000800cc00ULL,
0x0000000108082810ULL, 0x000fc80007ffe0ffULL, 0x0000000813087207ULL, 0x000fca0004000000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0a08ULL, 0x00005900080b7a24ULL, 0x000fe200078e027fULL,
0x0000000715087812ULL, 0x000fe200078ec0ffULL, 0x00005a000d027a24ULL, 0x000fe200078e0202ULL,
0x000000e0030d7810ULL, 0x000fc60007ffe0ffULL, 0x00005a000b0b7a24ULL, 0x000fe200078e0202ULL,
0x00000003ff007819ULL, 0x002fc8000001160dULL, 0x0000000b820b7210ULL, 0x000fe20007f3e0ffULL,
0x000000019f9f7824ULL, 0x000fc800078e0200ULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e000b027a11ULL, 0x000fc800078240ffULL, 0x00005f000b037a11ULL, 0x000fe200008f440aULL,
0x00000008090b7824ULL, 0x000fe200078e0208ULL, 0x000000810000720cULL, 0x000fc60003f26070ULL,
0x000000100b027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000009f11027227ULL, 0x002fc800078e00ffULL,
0x000000010d007824ULL, 0x000fe200078e0200ULL, 0x000000ff02047210ULL, 0x000fc80007ffe1ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x00005a0004037a24ULL, 0x000fc600078e029fULL,
0xfffffff800047812ULL, 0x000fe400078ef80dULL, 0x00005a0003007a0cULL, 0x000fc80003f26070ULL,
0x0000000504047984ULL, 0x000e72000800cc00ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102021810ULL, 0x000fc40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f46070ULL,
0x0000000102022810ULL, 0x000fc80007ffe0ffULL, 0x0000000213027207ULL, 0x000fca0004000000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a02ULL, 0x0000590002027a24ULL, 0x000fe400078e027fULL,
0x00005a00009f7a24ULL, 0x000fe200078e029fULL, 0x000000070d007812ULL, 0x000fc600078ec0ffULL,
0x00005a00029f7a24ULL, 0x000fe400078e029fULL, 0x0000000809097824ULL, 0x000fc600078e0200ULL,
0x0000009f829f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e009f027a11ULL, 0x000fc800078040ffULL, 0x00005f009f037a11ULL, 0x000fca00000f4408ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000402097824ULL, 0x000fca00078e0200ULL,
0x000000050900720cULL, 0x000fda0003f06070ULL, 0x00000002a5088824ULL, 0x000fc800078e00ffULL,
0x00006a0008118a24ULL, 0x000fe400078e0209ULL, 0xffffffffff087424ULL, 0x000fe400078e00ffULL,
0x0000660011108625ULL, 0x000fe200078e009aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000610088981ULL, 0x000ea2000c1e1900ULL, 0x0000000102077810ULL, 0x000fe20007ffe0ffULL,
0x00005800ff9c7624ULL, 0x000fe200078e00ffULL, 0x0000010000127802ULL, 0x000fe20000000f00ULL,
0x0000004013a27824ULL, 0x000fe200078e00ffULL, 0x000000060700720cULL, 0x000fe20003f06070ULL,
0x01e60000ff0e7f8cULL, 0x000e62000c80043fULL, 0x0000001f9c9c7810ULL, 0x000fe20007ffe0ffULL,
0x0000004000a37824ULL, 0x000fc400078e00ffULL, 0x000000407f077824ULL, 0x000fe200078e00ffULL,
0x00000005ff9c7819ULL, 0x000fe2000001169cULL, 0x000000a2080d7224ULL, 0x004fc800078e02ffULL,
0x000064000d107625ULL, 0x000fe400078e0012ULL, 0x00000c8000008947ULL, 0x000fea0003800000ULL,
0x00000100020d7824ULL, 0x002fe200078e02a3ULL, 0x00000003ff287819ULL, 0x000fe40000011603ULL,
0x0000200000247811ULL, 0x000fe400078e70ffULL, 0x0000000d04127217ULL, 0x000fe20007800000ULL,
0x000000407f7f7824ULL, 0x000fe200078e0228ULL, 0x0000000428147810ULL, 0x040fe40007ffe0ffULL,
0x0000000828167810ULL, 0x000fe20007ffe0ffULL, 0x00000001120d7824ULL, 0x000fe200078e0a0dULL,
0x0000002428207810ULL, 0x000fe20007ffe0ffULL, 0x0000000114127824ULL, 0x100fe200078e0203ULL,
0x0000002828227810ULL, 0x000fe20007ffe0ffULL, 0x00000008141f7824ULL, 0x040fe200078e00ffULL,
0x0000000d1400720cULL, 0x080fe20003f46070ULL, 0x0000000816217824ULL, 0x000fe200078e00ffULL,
0x0000000c28147810ULL, 0x000fe20007ffe0ffULL, 0x00000008222d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL, 0x0000000116127824ULL, 0x100fe200078e0203ULL,
0x0000000314187819ULL, 0x040fe200000006ffULL, 0x0000000114137824ULL, 0x000fe200078e0203ULL,
0x0000000d1600720cULL, 0x000fe20003f66070ULL, 0x000000101f1f7824ULL, 0x000fe200078e0224ULL,
0xfffffff821217812ULL, 0x000fc400078ee212ULL, 0x0000001028127810ULL, 0x040fe40007ffe0ffULL,
0x0000001428167810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0224ULL,
0xfffffff818257812ULL, 0x000fe200078ee213ULL, 0x0000000112157824ULL, 0x100fe200078e0203ULL,
0x0000000d1400720cULL, 0x080fe20003f86070ULL, 0x0000000812187824ULL, 0x040fe200078e00ffULL,
0x0000000d1200720cULL, 0x080fe20003fa6070ULL, 0x0000000128147824ULL, 0x100fe200078e0203ULL,
0x0000000d1600720cULL, 0x040fe20003f06070ULL, 0x0000000116177824ULL, 0x000fe200078e0203ULL,
0xfffffff818277812ULL, 0x000fe200078ee215ULL, 0x00000008161a7824ULL, 0x000fe200078e00ffULL,
0x0000000714187812ULL, 0x000fe200078ec0ffULL, 0x000001007f127825ULL, 0x040fe200078e00ffULL,
0x000000047f147810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81a2f7812ULL, 0x000fe400078ee217ULL,
0x0000007012177812ULL, 0x100fe200078ef80cULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000d2800720cULL, 0x000fe40003f26070ULL, 0x0000001710167210ULL, 0x000fe40007fde0ffULL,
0x000000087f127810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff8181d7812ULL, 0x000fe200078ef803ULL,
0x0000000111177824ULL, 0x000fe200030e0613ULL, 0x0000007014197812ULL, 0x000fe200078ef80cULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x00000018281a7810ULL, 0x000fc40007ffe0ffULL,
0x0000001910187210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0224ULL,
0x0000000c7f147810ULL, 0x000fe20007ffe0ffULL, 0x000000011a1c7824ULL, 0x000fe200078e0203ULL,
0x00000070121b7812ULL, 0x000fe200078ef80cULL, 0x0000000111197824ULL, 0x000fe200030e0615ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161d7faeULL, 0x0003e2000c901c46ULL,
0x0000000d1a00720cULL, 0x000fe20003f26070ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000000031a317819ULL, 0x000fe200000006ffULL, 0x00000000181f7faeULL, 0x0005e2000d101c46ULL,
0x0000001b101a7210ULL, 0x000fc40007fde0ffULL, 0x000000107f127810ULL, 0x000fe40007ffe0ffULL,
0xfffffff831317812ULL, 0x000fe200078ee21cULL, 0x00000001111b7824ULL, 0x000fe200030e0613ULL,
0x0000001c281c7810ULL, 0x000fe20007ffe0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000007014177812ULL, 0x102fe400078ef80cULL, 0x000000147f147810ULL, 0x000fe20007ffe0ffULL,
0x000000011c1e7824ULL, 0x000fe200078e0203ULL, 0x0000001710167210ULL, 0x000fe20007fde0ffULL,
0x000000081c337824ULL, 0x000fe200078e00ffULL, 0x00000070121d7812ULL, 0x000fe200078ef80cULL,
0x000000001a217faeULL, 0x0003e2000d901c46ULL, 0x0000000d1c00720cULL, 0x000fe20003f46070ULL,
0x0000000111177824ULL, 0x000fe200030e0615ULL, 0x0000001d101c7210ULL, 0x000fe20007fde0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000187f127810ULL, 0x000fc40007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee21eULL, 0x00000001111d7824ULL, 0x000fe200030e0613ULL,
0x0000007014197812ULL, 0x004fe200078ef80cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000020281e7810ULL, 0x000fe40007ffe0ffULL, 0x0000001910187210ULL, 0x000fe20007fde0ffULL,
0x0000001025217824ULL, 0x002fe200078e0224ULL, 0x0000001c7f147810ULL, 0x000fe20007ffe0ffULL,
0x000000011e1f7824ULL, 0x000fe200078e0203ULL, 0x0000007012237812ULL, 0x000fe200078ef80cULL,
0x0000000111197824ULL, 0x000fe200030e0615ULL, 0x0000000d1e00720cULL, 0x000fe20003f66070ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000031e127819ULL, 0x000fe200000006ffULL,
0x0000000016217faeULL, 0x0003e2000e101c46ULL, 0x00000023101e7210ULL, 0x000fe20007fde0ffULL,
0x0000001027257824ULL, 0x000fe200078e0224ULL, 0xfffffff812297812ULL, 0x000fc400078ee21fULL,
0x00000070141b7812ULL, 0x000fe200078ef80cULL, 0x00000001111f7824ULL, 0x000fe200030e0613ULL,
0x000000207f127810ULL, 0x040fe20007ffe0ffULL, 0x0000000120137824ULL, 0x000fe200078e0203ULL,
0x0000001b101a7210ULL, 0x000fe20007fde0ffULL, 0x0000000820147824ULL, 0x040fe200078e00ffULL,
0x0000000d2000720cULL, 0x000fe20003f86070ULL, 0x000000001c257faeULL, 0x0005e2000e901c46ULL,
0x000000287f167810ULL, 0x002fe20007ffe0ffULL, 0x00000001111b7824ULL, 0x000fe200030e0615ULL,
0xfffffff8142b7812ULL, 0x000fe200078ee213ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000247f147810ULL, 0x000fc40007ffe0ffULL, 0x0000000d2200720cULL, 0x000fe20003fa6070ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000007012217812ULL, 0x000fc600078ef80cULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000002110207210ULL, 0x000fc60007fde0ffULL,
0x0000000122127824ULL, 0x000fe200078e0203ULL, 0x0000007014237812ULL, 0x000fe200078ef80cULL,
0x000000102f257824ULL, 0x104fe200078e0224ULL, 0x0000001311217210ULL, 0x000fe200037fe4ffULL,
0x0000001029297824ULL, 0x100fe200078e0224ULL, 0x0000002310227210ULL, 0x000fe20007fde0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0224ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL,
0x0000000018257faeULL, 0x0003e2000c101c46ULL, 0x0000007016137812ULL, 0x000fe200078ef80cULL,
0x0000000111237824ULL, 0x000fe200030e0615ULL, 0x0000002c7f127810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0224ULL, 0x0000001310167210ULL, 0x000fc40007fde0ffULL,
0x0000002c28147810ULL, 0x000fe20007ffe0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000307f157810ULL, 0x000fe40007ffe0ffULL, 0x0000000d1400720cULL, 0x000fe20003f06070ULL,
0x0000000111177824ULL, 0x000fe200030e0617ULL, 0x0000007012277812ULL, 0x000fe200078ef80cULL,
0x00000001141d7824ULL, 0x000fe200078e0203ULL, 0x0000003028127810ULL, 0x000fe20007ffe0ffULL,
0x0000000814267824ULL, 0x000fe200078e00ffULL, 0x00000027101c7210ULL, 0x000fe20007fde0ffULL,
0x0000010015147825ULL, 0x000fe200078e00ffULL, 0x0000002433277211ULL, 0x000fc400078e20ffULL,
0xfffffff8262f7812ULL, 0x000fe200078ee21dULL, 0x0000001031257824ULL, 0x002fe200078e0224ULL,
0x0000007014197812ULL, 0x000fe200078ef80cULL, 0x00000001111d7824ULL, 0x000fe200030e0613ULL,
0x0000003828267810ULL, 0x000fe20007ffe0ffULL, 0x0000000112137824ULL, 0x040fe200078e0203ULL,
0x000000001e257faeULL, 0x0003e2000c901c46ULL, 0x0000000812147824ULL, 0x040fe200078e00ffULL,
0x0000000d1200720cULL, 0x000fe20003f26070ULL, 0x000000102f2f7824ULL, 0x000fe200078e0224ULL,
0x000000347f127810ULL, 0x000fe20007ffe0ffULL, 0x000000001a277faeULL, 0x0005e2000d101c46ULL,
0xfffffff814317812ULL, 0x000fc400078ee213ULL, 0x0000001910187210ULL, 0x000fe20007fde0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000003428147810ULL, 0x040fe20007ffe0ffULL,
0x0000000020297faeULL, 0x0007e2000d901c46ULL, 0x0000003c28287810ULL, 0x000fe20007ffe0ffULL,
0x0000000111197824ULL, 0x000fe200030e0615ULL, 0x00000070121f7812ULL, 0x002fe200078ef80cULL,
0x00000000222b7faeULL, 0x0003e2000e101c46ULL, 0x000000387f127810ULL, 0x000fe20007ffe0ffULL,
0x00000001261a7824ULL, 0x004fe200078e0203ULL, 0x0000001f101e7210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x000fe200078e0224ULL, 0x0000000d1400720cULL, 0x080fe20003f86070ULL,
0x00000000162d7faeULL, 0x0003e2000e901c46ULL, 0x0000000d2600720cULL, 0x080fe20003f66070ULL,
0x00000001111f7824ULL, 0x000fe200030e0613ULL, 0x0000000d2800720cULL, 0x000fe20003f46070ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000001c2f7faeULL, 0x0003e6000c101c46ULL,
0x00000001140d7824ULL, 0x100fe200078e0203ULL, 0x00000070121b7812ULL, 0x000fe200078ef80cULL,
0x0000000814207824ULL, 0x008fe200078e00ffULL, 0x0000003c7f147810ULL, 0x000fe20007ffe0ffULL,
0x0000000826217824ULL, 0x000fe200078e00ffULL, 0x0000001b10127210ULL, 0x000fe20007fde0ffULL,
0x0000000128037824ULL, 0x040fe200078e0203ULL, 0x0000000328287819ULL, 0x000fe200000006ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0xfffffff8211b7812ULL, 0x000fe200078ee21aULL,
0x0000000018317faeULL, 0x0003e2000c901c46ULL, 0xfffffff828217812ULL, 0x000fe200078ee203ULL,
0x0000000111137824ULL, 0x000fe200030e0613ULL, 0x0000007014037812ULL, 0x000fe200078ef80cULL,
0x000000101b1b7824ULL, 0x100fe200078e0224ULL, 0xfffffff8200d7812ULL, 0x000fe200078ee20dULL,
0x0000001021217824ULL, 0x000fe200078e0224ULL, 0x00000003100c7210ULL, 0x000fc60007fde0ffULL,
0x000000100d037824ULL, 0x000fe400078e0224ULL, 0x00000001110d7824ULL, 0x000fc600030e0615ULL,
0x000000001e037faeULL, 0x0003e8000e101c46ULL, 0x00000000121b7faeULL, 0x0003e8000d901c46ULL,
0x000000000c217faeULL, 0x0003e2000d101c46ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x00000010033a7811ULL, 0x042fe400078fe8ffULL, 0x00000004031e7811ULL, 0x000fc400078fe8ffULL,
0x0000000c03267811ULL, 0x040fe200078fe8ffULL, 0x000000013a137824ULL, 0x140fe200078e0203ULL,
0x00000014033e7811ULL, 0x040fe200078fe8ffULL, 0x000000083a3c7824ULL, 0x000fe200078e00ffULL,
0x0000001803427811ULL, 0x040fe200078fe8ffULL, 0x000000011e0d7824ULL, 0x140fe200078e0203ULL,
0x000000031e207819ULL, 0x000fe200000006ffULL, 0x0000000126127824ULL, 0x140fe200078e0203ULL,
0x0000000803227811ULL, 0x040fe200078fe8ffULL, 0x0000000826157824ULL, 0x000fe200078e00ffULL,
0x0000001c03467811ULL, 0x000fe200078fe8ffULL, 0x000000013e147824ULL, 0x000fe200078e0203ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL, 0x000000083e177824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x0000000142137824ULL, 0x100fe200078e0203ULL,
0xfffffff815307812ULL, 0x000fe200078ee212ULL, 0x00000001220d7824ULL, 0x140fe200078e0203ULL,
0xfffffff817407812ULL, 0x000fe200078ee214ULL, 0x0000000822247824ULL, 0x000fe200078e00ffULL,
0x0000000342447819ULL, 0x000fe200000006ffULL, 0x0000000146147824ULL, 0x040fe200078e0203ULL,
0x0000002c032e7811ULL, 0x040fe200078fe8ffULL, 0x0000000846157824ULL, 0x000fe200078e00ffULL,
0x0000002003287811ULL, 0x000fc400078fe8ffULL, 0x0000003403347811ULL, 0x040fe400078fe8ffULL,
0x00000024032a7811ULL, 0x040fe200078fe8ffULL, 0x0000000828167824ULL, 0x000fe200078e00ffULL,
0x0000003003327811ULL, 0x000fe200078fe8ffULL, 0x00000008341a7824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee213ULL, 0x000000012e137824ULL, 0x000fe200078e0203ULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x00000001280d7824ULL, 0x100fe200078e0203ULL,
0xfffffff815487812ULL, 0x000fe200078ee214ULL, 0x0000000134157824ULL, 0x100fe200078e0203ULL,
0x000000032e187819ULL, 0x000fe200000006ffULL, 0x000000012a127824ULL, 0x140fe200078e0203ULL,
0x0000003803367811ULL, 0x040fe200078fe8ffULL, 0x000000082a177824ULL, 0x000fe200078e00ffULL,
0x00000028032c7811ULL, 0x040fe200078fe8ffULL, 0x0000000132147824ULL, 0x000fe200078e0203ULL,
0xfffffff818187812ULL, 0x000fe200078ee213ULL, 0x0000000832197824ULL, 0x000fe200078e00ffULL,
0xfffffff8160d7812ULL, 0x000fe200078ee20dULL, 0x00000008364a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee215ULL, 0x0000000136157824ULL, 0x000fe200078e0203ULL,
0x0000000303137211ULL, 0x000fc400078fe8ffULL, 0xfffffff817167812ULL, 0x000fe200078ee212ULL,
0x000000012c127824ULL, 0x040fe200078e0203ULL, 0xfffffff819197812ULL, 0x000fe200078ee214ULL,
0x000000082c177824ULL, 0x000fe200078e00ffULL, 0x0000003c03387811ULL, 0x000fe200078fe8ffULL,
0x0000000107147824ULL, 0x000fe200078e021eULL, 0x00000007131c7812ULL, 0x000fe400078ec0ffULL,
0xfffffff84a1b7812ULL, 0x000fe200078ee215ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fc400078ee212ULL, 0x0000000703127211ULL, 0x000fe400078fe8ffULL,
0x0ffffff81c1e7812ULL, 0x100fe200078ef803ULL, 0x0000000138037824ULL, 0x000fe200078e0203ULL,
0x00002000004f7811ULL, 0x000fe200078e70ffULL, 0x00000008381c7824ULL, 0x000fe200078e00ffULL,
0x00000070141f7812ULL, 0x000fe200078ef80cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000004f17457211ULL, 0x080fe400078e20ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee203ULL,
0x0000000107147824ULL, 0x040fe200078e0222ULL, 0x0000004f1e037211ULL, 0x000fe200078e20ffULL,
0x000000101a4b7824ULL, 0x100fe200078e024fULL, 0x0000001f101e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001071a7824ULL, 0x000fe200078e023eULL, 0x00000070121d7812ULL, 0x000fe200078ef80cULL,
0x0000001016437824ULL, 0x000fc400078e024fULL, 0x00000001111f7824ULL, 0x000fe200008e0615ULL,
0x0000001d10127210ULL, 0x000fe20007f1e0ffULL, 0x0000010014147825ULL, 0x000fc800078e00ffULL,
0x0000001018477824ULL, 0x100fe200078e024fULL, 0x0000003a07187210ULL, 0x000fe20007ffe0ffULL,
0x000000101b4d7824ULL, 0x100fe200078e024fULL, 0x0000007014217812ULL, 0x000fe200078ef80cULL,
0x0000000107167824ULL, 0x000fe400078e0226ULL, 0x0000001020337824ULL, 0x100fe400078e024fULL,
0x0000001024357824ULL, 0x100fe400078e024fULL, 0x0000001030377824ULL, 0x000fc400078e024fULL,
0x000000103c397824ULL, 0x100fe400078e024fULL, 0x00000010403b7824ULL, 0x100fe400078e024fULL,
0x00000010443d7824ULL, 0x100fe400078e024fULL, 0x00000010483f7824ULL, 0x100fe400078e024fULL,
0x000000100d417824ULL, 0x100fe400078e024fULL, 0x0000001019497824ULL, 0x000fc400078e024fULL,
0x000001001a1a7825ULL, 0x000fc800078e00ffULL, 0x000000101c4f7824ULL, 0x000fe200078e024fULL,
0x000000701a277812ULL, 0x000fe200078ef80cULL, 0x0000000111137824ULL, 0x000fe200000e0613ULL,
0x0000002110207210ULL, 0x000fe20007f1e0ffULL, 0x00000001071c7824ULL, 0x040fe200078e0242ULL,
0x0000002c071a7210ULL, 0x000fe20007ffe0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012037faeULL, 0x0003e6000b901c46ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000007016237812ULL, 0x100fe200078ef80cULL,
0x000000001e337faeULL, 0x0003e4000b901c46ULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0000007018257812ULL, 0x000fc400078ef80cULL, 0x0000002310227210ULL, 0x040fe20007f3e0ffULL,
0x0000000111217824ULL, 0x000fe200000e0615ULL, 0x0000002710267210ULL, 0x000fe20007f1e0ffULL,
0x0000000107147824ULL, 0x040fe200078e0246ULL, 0x000000701c297812ULL, 0x000fe200078ef80cULL,
0x0000000107167824ULL, 0x040fe200078e0228ULL, 0x0000002510247210ULL, 0x000fe20007f5e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x00000038071c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000020357faeULL, 0x0003e4000b901c46ULL, 0x0000000111277824ULL, 0x000fe200000e061bULL,
0x0000002910287210ULL, 0x000fe20007f1e0ffULL, 0x0000000107187824ULL, 0x000fe200078e022aULL,
0x00000070142b7812ULL, 0x000fe200078ef80cULL, 0x0000000111237824ULL, 0x000fc400008e0617ULL,
0x0000000111257824ULL, 0x040fe400010e0619ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000000022377faeULL, 0x0003e6000b901c46ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x00000070162d7812ULL, 0x100fe200078ef80cULL, 0x0000000024397faeULL, 0x0003e4000b901c46ULL,
0x0000000111297824ULL, 0x000fe200000e061dULL, 0x0000002b102a7210ULL, 0x000fe20007f1e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x00000070182f7812ULL, 0x000fe200078ef80cULL,
0x00000000263b7faeULL, 0x0003e2000b901c46ULL, 0x0000002d102c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000107147824ULL, 0x000fe200078e022eULL, 0x000000701a317812ULL, 0x000fe200078ef80cULL,
0x00000001112b7824ULL, 0x000fe200000e0615ULL, 0x0000002f102e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000003110307210ULL, 0x000fe20007f5e0ffULL,
0x00000000283d7faeULL, 0x0003e4000b901c46ULL, 0x0000000107167824ULL, 0x040fe200078e0232ULL,
0x00000070140d7812ULL, 0x000fe200078ef80cULL, 0x0000000107187824ULL, 0x040fe200078e0234ULL,
0x000000002a3f7faeULL, 0x0003e2000b901c46ULL, 0x00000001071a7824ULL, 0x000fc400078e0236ULL,
0x00000001112d7824ULL, 0x040fe400008e0617ULL, 0x00000001112f7824ULL, 0x040fe200000e0619ULL,
0x0000000d10147210ULL, 0x000fe20007f1e0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000002c417faeULL, 0x0003e6000b901c46ULL, 0x0000000111317824ULL, 0x000fe200010e061bULL,
0x0000007016557812ULL, 0x100fe200078ef80cULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x000000002e437faeULL, 0x0003e6000b901c46ULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007018537812ULL, 0x100fe200078ef80cULL, 0x0000000030457faeULL, 0x0003e4000b901c46ULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x000000701a517812ULL, 0x000fc400078ef80cULL,
0x0000005310167210ULL, 0x000fe20007f3e0ffULL, 0x0000000111157824ULL, 0x040fe200000e0615ULL,
0x000000701c0d7812ULL, 0x000fe400078ef80cULL, 0x00000055100c7210ULL, 0x040fe40007f1e0ffULL,
0x0000005110187210ULL, 0x040fe20007f5e0ffULL, 0x0000000014477faeULL, 0x0003e2000b901c46ULL,
0x0000000d10107210ULL, 0x000fe20007f7e0ffULL, 0x00000001110d7824ULL, 0x040fe400000e0617ULL,
0x0000000111177824ULL, 0x000fc400008e0619ULL, 0x0000000111197824ULL, 0x040fe200010e061bULL,
0x000000000c497faeULL, 0x0003e2000b901c46ULL, 0x0000000111117824ULL, 0x000fc600018e061dULL,
0x00000000164b7faeULL, 0x0003e8000b901c46ULL, 0x00000000184d7faeULL, 0x0003e8000b901c46ULL,
0x00000000104f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000c7805ULL, 0x002fc40000015200ULL, 0x01e60400ff037984ULL, 0x000e620000000800ULL,
0x0000009c0b9b7224ULL, 0x000fe400078e02ffULL, 0x00000001049e7824ULL, 0x000fc400078e0a0aULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe2000780480fULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000062009b9a7625ULL, 0x000fe200078e009aULL, 0x00000008ff9e7819ULL, 0x000fe2000001169eULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100c107210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0dULL,
0x003d09001000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011411ULL, 0x0000001003037211ULL, 0x000fca00078110ffULL,
0x000000ffff107224ULL, 0x000fca00000e0611ULL, 0x0000000203037819ULL, 0x000fc80000001210ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000060200720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000009d7919ULL, 0x000e620000000000ULL,
0x00006a00a5a57a24ULL, 0x000fe200078e02ffULL, 0x000000019c9c7819ULL, 0x000fe200000006ffULL,
0x0000002000a17824ULL, 0x040fe200078e00ffULL, 0x0001e68800a07811ULL, 0x000fe400078e18ffULL,
0xffffffff0a997810ULL, 0x040fe40007ffe0ffULL, 0x000000090a987810ULL, 0x000fc40007ffe0ffULL,
0x0000000102037810ULL, 0x000fe20007ffe0ffULL, 0x00000100ffa47424ULL, 0x000fe200078e00ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000008a20d7224ULL, 0x000fe200078e02ffULL,
0x000000060300720cULL, 0x000fe20003f06070ULL, 0x0000010002237824ULL, 0x000fc400078e02a3ULL,
0x000064000d0c7625ULL, 0x000fd400078e00a4ULL, 0x00000bb000008947ULL, 0x00cfea0003800000ULL,
0x000000109d227824ULL, 0x002fe200078e00ffULL, 0x00000003ff207819ULL, 0x100fe4000001169dULL,
0x000000ff000f7202ULL, 0x000fe40000000f00ULL, 0x0000007022227812ULL, 0x000fe200078ec0ffULL,
0x0000000107117824ULL, 0x000fe200078e0220ULL, 0x0000000820147810ULL, 0x000fe40007ffe0ffULL,
0x00000080220e7812ULL, 0x000fe400078efcffULL, 0x0000000420127810ULL, 0x000fe20007ffe0ffULL,
0x0000000114087824ULL, 0x000fe200078e029dULL, 0x0000000c20167810ULL, 0x040fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x00000010201a7810ULL, 0x000fc40007ffe0ffULL,
0x0000001420247810ULL, 0x000fe20007ffe0ffULL, 0x00000008140b7824ULL, 0x000fe200078e00ffULL,
0x000000100c187210ULL, 0x000fe20007f1e0ffULL, 0x0000000112037824ULL, 0x000fe200078e029dULL,
0x0000001820307810ULL, 0x000fe20007ffe0ffULL, 0x0000000812267824ULL, 0x000fe200078e00ffULL,
0xfffffff80b287812ULL, 0x000fe200078ee208ULL, 0x000000010d197824ULL, 0x000fe200000e0611ULL,
0x0000002304087217ULL, 0x000fe20007800000ULL, 0x0000000107117824ULL, 0x000fe200078e0212ULL,
0xfffffff826267812ULL, 0x000fe200078ee203ULL, 0x0000000116037824ULL, 0x040fe200078e029dULL,
0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL, 0x00000008162a7824ULL, 0x000fe200078e00ffULL,
0x00000003242e7819ULL, 0x000fe200000006ffULL, 0x0000000108087824ULL, 0x000fe200078e0a23ULL,
0x0000001c20327810ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0xfffffff82a2a7812ULL, 0x000fc400078ee203ULL, 0x000000081200720cULL, 0x080fe20003f86070ULL,
0x0000000107137824ULL, 0x040fe200078e0214ULL, 0x000000081a00720cULL, 0x040fe20003f06070ULL,
0x000000011a0b7824ULL, 0x040fe200078e029dULL, 0x0000001a07037210ULL, 0x000fe20007ffe0ffULL,
0x000000081a2c7824ULL, 0x000fe200078e00ffULL, 0x000000100c1a7210ULL, 0x000fe20007f3e0ffULL,
0x0000010013127825ULL, 0x000fe200078e000eULL, 0x000000081400720cULL, 0x080fe40003f46070ULL,
0x000000081600720cULL, 0x000fe20003f66070ULL, 0x000000010d1b7824ULL, 0x000fe200008e0611ULL,
0x000000120c1c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000107157824ULL, 0x000fe200078e0216ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20bULL, 0x0000010003107825ULL, 0x000fe200078e000eULL,
0x0000002020347810ULL, 0x000fc60007ffe0ffULL, 0x0000000107177824ULL, 0x000fe400078e0224ULL,
0x0000010015147825ULL, 0x000fc800078e000eULL, 0x000000010d1d7824ULL, 0x000fe200028e0613ULL,
0x000000100c1e7210ULL, 0x040fe20007fbe0ffULL, 0x0000010017167825ULL, 0x000fe200078e000eULL,
0x000000140c147210ULL, 0x000fc60007f3e0ffULL, 0x0000000107037824ULL, 0x000fe200078e0230ULL,
0x000000160c167210ULL, 0x000fe20007fde0ffULL, 0x000000010d1f7824ULL, 0x000fe200028e0611ULL,
0x000000082000720cULL, 0x000fe20003fa6070ULL, 0x0000010003107825ULL, 0x000fe200078e000eULL,
0x0000400000037811ULL, 0x000fc600078e70ffULL, 0x000000010d157824ULL, 0x040fe200008e0615ULL,
0x000000082400720cULL, 0x000fe20003f26070ULL, 0x0000000120127824ULL, 0x000fe400078e029dULL,
0x000000010d177824ULL, 0x000fe400030e0617ULL, 0x00000001240b7824ULL, 0x000fe200078e029dULL,
0x000000100c247210ULL, 0x000fe20007fde0ffULL, 0x0000001026297824ULL, 0x000fe200078e0203ULL,
0x0000000721127812ULL, 0x000fe200078ef812ULL, 0x00000001302b7824ULL, 0x000fe200078e029dULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee20bULL, 0x000000010d257824ULL, 0x000fc400030e0611ULL,
0x0000000107117824ULL, 0x000fe400078e0232ULL, 0x00000010120b7824ULL, 0x000fe400078e0203ULL,
0x0000010011107825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000180b7faeULL, 0x0003e2000e901c46ULL, 0x000000083000720cULL, 0x040fe20003fa6070ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x000000100c267210ULL, 0x000fe20007fde0ffULL,
0x0000000132107824ULL, 0x040fe200078e029dULL, 0x000000001a297faeULL, 0x0005e2000e101c46ULL,
0x0000000107137824ULL, 0x000fe200078e0234ULL, 0x000000110d277210ULL, 0x000fe400037fe4ffULL,
0x000000083200720cULL, 0x000fe20003f86070ULL, 0x0000010013127825ULL, 0x000fe200078e000eULL,
0x0000002420187810ULL, 0x002fc60007ffe0ffULL, 0x00000008320b7824ULL, 0x000fe200078e00ffULL,
0x000000120c127210ULL, 0x000fe20007fde0ffULL, 0x0000000134197824ULL, 0x000fe200078e029dULL,
0xfffffff8301a7812ULL, 0x004fe200078ee22bULL, 0x000000102a1b7824ULL, 0x100fe200078e0203ULL,
0xfffffff80b307812ULL, 0x000fe200078ee210ULL, 0x00000010280b7824ULL, 0x000fe200078e0203ULL,
0x00000038202a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107117824ULL, 0x000fe400078e0218ULL,
0x000000010d137824ULL, 0x000fe200030e0613ULL, 0x000000001c0b7faeULL, 0x0003e2000d101c46ULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x000000081800720cULL, 0x000fc40003f46070ULL,
0x00000000141b7faeULL, 0x0005e2000d901c46ULL, 0x000000083400720cULL, 0x040fe20003f66070ULL,
0x0000000834347824ULL, 0x000fe400078e00ffULL, 0x0000000118287824ULL, 0x040fe400078e029dULL,
0x0000000818297824ULL, 0x000fe200078e00ffULL, 0x000000100c187210ULL, 0x000fe20007fde0ffULL,
0x000000102c0b7824ULL, 0x002fe200078e0203ULL, 0xfffffff834107812ULL, 0x000fe400078ee219ULL,
0x000000110d197210ULL, 0x000fe200037fe4ffULL, 0x000000102e117824ULL, 0x100fe200078e0203ULL,
0x000000001e0b7faeULL, 0x0003e2000c101c46ULL, 0x000000101a157824ULL, 0x104fe200078e0203ULL,
0x0000002c20147810ULL, 0x000fe20007ffe0ffULL, 0x00000010301b7824ULL, 0x100fe200078e0203ULL,
0x0000000016117faeULL, 0x0005e2000c901c46ULL, 0x00000010101d7824ULL, 0x000fe200078e0203ULL,
0x0000002820107810ULL, 0x000fe20007ffe0ffULL, 0x00000008141c7824ULL, 0x000fe200078e00ffULL,
0x0000000024157faeULL, 0x0007e2000e901c46ULL, 0x00000030201a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff829287812ULL, 0x000fe200078ee228ULL, 0x00000000261b7faeULL, 0x0009e2000e101c46ULL,
0x00000034201e7810ULL, 0x042fe40007ffe0ffULL, 0x0000003c20207810ULL, 0x000fe20007ffe0ffULL,
0x00000000121d7faeULL, 0x0003e2000d901c46ULL, 0x0000000110117824ULL, 0x044fe200078e029dULL,
0x000000081000720cULL, 0x080fe20003fc6070ULL, 0x00000010280b7824ULL, 0x000fe200078e0203ULL,
0x000000081400720cULL, 0x080fe20003fa6070ULL, 0x000000011a167824ULL, 0x040fe200078e029dULL,
0x000000081a00720cULL, 0x080fe20003f86070ULL, 0x0000000107177824ULL, 0x040fe200078e021aULL,
0x000000081e00720cULL, 0x080fe20003f66070ULL, 0x00000000180b7faeULL, 0x0005e2000d101c46ULL,
0x000000082a00720cULL, 0x080fe20003f26070ULL, 0x000000081a1b7824ULL, 0x010fe200078e00ffULL,
0x000000082000720cULL, 0x000fe20003f06070ULL, 0x0000000810127824ULL, 0x002fe200078e00ffULL,
0x0000009d14157210ULL, 0x008fe20007ffe0ffULL, 0x0000000107137824ULL, 0x000fc400078e0214ULL,
0x000000012a1d7824ULL, 0x000fe200078e029dULL, 0xfffffff812087812ULL, 0x000fe200078ee211ULL,
0x0000000107117824ULL, 0x000fe200078e0210ULL, 0xfffffff81c1a7812ULL, 0x000fe200078ee215ULL,
0x0000010013127825ULL, 0x000fe200078e000eULL, 0xfffffff81b1c7812ULL, 0x000fe400078ee216ULL,
0x0000002a071b7210ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fc800078e000eULL,
0x000000081e197824ULL, 0x004fe200078e00ffULL, 0x000000100c147210ULL, 0x000fe20007f5e0ffULL,
0x00000001070b7824ULL, 0x000fe400078e021eULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x000000010d157824ULL, 0x000fe200010e0611ULL, 0x000000120c167210ULL, 0x000fe20007f5e0ffULL,
0x0000010017107825ULL, 0x000fc800078e000eULL, 0x000000011e127824ULL, 0x000fe400078e029dULL,
0x000000010d177824ULL, 0x000fe200010e0613ULL, 0x000000100c187210ULL, 0x000fe20007f5e0ffULL,
0x0000000820247824ULL, 0x000fe200078e00ffULL, 0xfffffff8191e7812ULL, 0x000fe200078ee212ULL,
0x000001000b127825ULL, 0x000fc800078e000eULL, 0x000000010d197824ULL, 0x000fe200010e0611ULL,
0x000000120c127210ULL, 0x000fe20007f5e0ffULL, 0x000001001b107825ULL, 0x000fc800078e000eULL,
0x00000001070b7824ULL, 0x000fe400078e0220ULL, 0x000000010d137824ULL, 0x000fe200010e0613ULL,
0x000000100c107210ULL, 0x000fe20007f5e0ffULL, 0x00000001201b7824ULL, 0x000fe200078e029dULL,
0xfffffff82a207812ULL, 0x000fe200078ee21dULL, 0x000001000b0e7825ULL, 0x000fc600078e000eULL,
0xfffffff824247812ULL, 0x000fe200078ee21bULL, 0x000000010d117824ULL, 0x040fe200010e0611ULL,
0x0000000e0c0c7210ULL, 0x000fe20007f5e0ffULL, 0x00000010080b7824ULL, 0x100fe200078e0203ULL,
0x000000031a1b7211ULL, 0x000fe200078e20ffULL, 0x000000101c1d7824ULL, 0x100fe400078e0203ULL,
0x000000101e1f7824ULL, 0x100fe200078e0203ULL, 0x00000000140b7faeULL, 0x0003e2000f101c46ULL,
0x0000001020257824ULL, 0x100fe400078e0203ULL, 0x0000001024037824ULL, 0x000fe200078e0203ULL,
0x00000000161b7faeULL, 0x0003e2000e901c46ULL, 0x000000010d0d7824ULL, 0x000fc600010e060fULL,
0x00000000181d7faeULL, 0x0003e8000e101c46ULL, 0x00000000121f7faeULL, 0x0003e8000d901c46ULL,
0x0000000010257faeULL, 0x0003e8000c901c46ULL, 0x000000000c037faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x000000049d107811ULL, 0x042fe200078fe8ffULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000000089d127811ULL, 0x000fc400078fe8ffULL,
0x000000249d207811ULL, 0x040fe200078fe8ffULL, 0x0000000110037824ULL, 0x140fe200078e029dULL,
0x000000149d187811ULL, 0x040fe200078fe8ffULL, 0x0000000810087824ULL, 0x000fe200078e00ffULL,
0x000000349d2a7811ULL, 0x040fe200078fe8ffULL, 0x00000008121a7824ULL, 0x000fe200078e00ffULL,
0x0000000c9d147811ULL, 0x040fe200078fe8ffULL, 0x0000000120117824ULL, 0x000fe200078e029dULL,
0xfffffff8080b7812ULL, 0x000fe200078ee203ULL, 0x0000000112037824ULL, 0x100fe200078e029dULL,
0x000000109d167811ULL, 0x040fe200078fe8ffULL, 0x0000000820247824ULL, 0x000fe200078e00ffULL,
0x0000009d2a137210ULL, 0x080fe20007ffe0ffULL, 0x00000001180f7824ULL, 0x000fe200078e029dULL,
0xfffffff81a337812ULL, 0x000fe200078ee203ULL, 0x00000008181c7824ULL, 0x000fe200078e00ffULL,
0x000000189d1a7811ULL, 0x040fe200078fe8ffULL, 0x000000082a2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff824117812ULL, 0x000fe200078ee211ULL, 0x0000000814357824ULL, 0x000fe200078e00ffULL,
0x000000289d247811ULL, 0x040fe200078fe8ffULL, 0x000000011a037824ULL, 0x000fe200078e029dULL,
0xfffffff81c0f7812ULL, 0x000fe200078ee20fULL, 0x000000081a227824ULL, 0x000fe200078e00ffULL,
0x000000209d1e7811ULL, 0x040fe200078fe8ffULL, 0x00000001160e7824ULL, 0x000fe200078e029dULL,
0x0000009d14087210ULL, 0x080fe20007ffe0ffULL, 0x0000000816377824ULL, 0x000fe200078e00ffULL,
0x0000001c9d1c7811ULL, 0x040fe200078fe8ffULL, 0x000000081e3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8223b7812ULL, 0x000fe200078ee203ULL, 0x0000000124037824ULL, 0x000fe200078e029dULL,
0xfffffff82c137812ULL, 0x000fe200078ee213ULL, 0x0000000824227824ULL, 0x000fe200078e00ffULL,
0x000000389d2c7811ULL, 0x000fe200078fe8ffULL, 0x000000081c3d7824ULL, 0x040fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee208ULL, 0x000000011c087824ULL, 0x100fe200078e029dULL,
0xfffffff837377812ULL, 0x000fe200078ee20eULL, 0x000000012c157824ULL, 0x000fe200078e029dULL,
0x0000009d1e0e7210ULL, 0x080fe20007ffe0ffULL, 0x0000000107197824ULL, 0x000fe200078e0218ULL,
0x000000309d287811ULL, 0x000fe200078fe8ffULL, 0x00000001071b7824ULL, 0x000fe200078e021aULL,
0x0000002c9d267811ULL, 0x000fe200078fe8ffULL, 0x00000001071d7824ULL, 0x000fe200078e021cULL,
0xfffffff822437812ULL, 0x000fe200078ee203ULL, 0x000000082c227824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20eULL, 0x00000001280e7824ULL, 0x140fe200078e029dULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee208ULL, 0x0000000828477824ULL, 0x000fe200078e00ffULL,
0x0000003c9d2e7811ULL, 0x000fe200078fe8ffULL, 0x0000000126087824ULL, 0x000fe200078e029dULL,
0xfffffff822157812ULL, 0x000fe200078ee215ULL, 0x0000000826457824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee20eULL, 0x000000109d227824ULL, 0x000fe200078e00ffULL,
0x00004000000e7811ULL, 0x000fe200078e70ffULL, 0x000000012e177824ULL, 0x040fe200078e029dULL,
0xfffffff845457812ULL, 0x000fe200078ee208ULL, 0x000000082e307824ULL, 0x000fe200078e00ffULL,
0x0000009d9d087211ULL, 0x000fe200078fe8ffULL, 0x000000100f397824ULL, 0x100fe200078e020eULL,
0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL, 0x0000001011417824ULL, 0x000fe200078e020eULL,
0x0000007022227812ULL, 0x000fe200078ec0ffULL, 0x0000000107117824ULL, 0x000fe200078e0210ULL,
0x0000000721037812ULL, 0x000fe200078ef808ULL, 0x000000100b0b7824ULL, 0x100fe200078e020eULL,
0xfffffff830177812ULL, 0x000fe200078ee217ULL, 0x0000001033337824ULL, 0x100fe200078e020eULL,
0x000000079d0f7211ULL, 0x000fe200078fe8ffULL, 0x0000001003037824ULL, 0x100fe200078e020eULL,
0x0000008022307812ULL, 0x000fe200078efcffULL, 0x0000001037377824ULL, 0x000fe200078e020eULL,
0x0000000e13497211ULL, 0x080fe200078e20ffULL, 0x0000000107137824ULL, 0x000fe200078e0212ULL,
0x0000000e35357211ULL, 0x000fe200078e20ffULL, 0x000000103b3b7824ULL, 0x100fe200078e020eULL,
0x0000001e071f7210ULL, 0x000fe20007ffe0ffULL, 0x000000103d3d7824ULL, 0x000fc400078e020eULL,
0x000000103f3f7824ULL, 0x100fe400078e020eULL, 0x0000001043437824ULL, 0x100fe400078e020eULL,
0x0000001045457824ULL, 0x100fe400078e020eULL, 0x0000001047477824ULL, 0x100fe400078e020eULL,
0x00000010154b7824ULL, 0x100fe400078e020eULL, 0x00000010174d7824ULL, 0x000fc400078e020eULL,
0x0000000107157824ULL, 0x000fe400078e0214ULL, 0x000001000f0e7825ULL, 0x000fc800078e0030ULL,
0x0000000107177824ULL, 0x000fe200078e0216ULL, 0x0000000e0c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010011107825ULL, 0x000fc800078e0030ULL, 0x0000010013127825ULL, 0x000fe200078e0030ULL,
0x000000100c107210ULL, 0x000fc60007f3e0ffULL, 0x0000010015147825ULL, 0x100fe200078e0030ULL,
0x000000120c127210ULL, 0x040fe40007f5e0ffULL, 0x000000110d117210ULL, 0x000fe20000ffe4ffULL,
0x0000010017167825ULL, 0x000fe200078e0030ULL, 0x000000140c147210ULL, 0x000fc60007f7e0ffULL,
0x0000010019187825ULL, 0x000fc800078e0030ULL, 0x000001001b1a7825ULL, 0x000fe200078e0030ULL,
0x000000180c187210ULL, 0x000fc60007f3e0ffULL, 0x0000000107257824ULL, 0x040fe400078e0220ULL,
0x0000000107277824ULL, 0x000fe400078e0224ULL, 0x000001001d1c7825ULL, 0x000fc800078e0030ULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x000000160c167210ULL, 0x040fe20007f1e0ffULL,
0x0000000107297824ULL, 0x000fe400078e0226ULL, 0x000001001f1e7825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e037faeULL, 0x0003e6000b901c46ULL,
0x000000010d137824ULL, 0x000fe200010e0613ULL, 0x0000001a0c1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000010025247825ULL, 0x000fe200078e0030ULL, 0x00000000100b7faeULL, 0x0003e6000b901c46ULL,
0x00000001072b7824ULL, 0x000fe200078e0228ULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x0000010027267825ULL, 0x000fc800078e0030ULL, 0x000000010d157824ULL, 0x000fe200018e0615ULL,
0x0000001c0c1c7210ULL, 0x000fe20007f7e0ffULL, 0x00000001072d7824ULL, 0x040fe400078e022aULL,
0x00000001072f7824ULL, 0x000fe200078e022cULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x0000010029287825ULL, 0x000fc800078e0030ULL, 0x000000010d177824ULL, 0x000fe200000e0617ULL,
0x0000001e0c1e7210ULL, 0x040fe20007f1e0ffULL, 0x00000001074f7824ULL, 0x000fe400078e022eULL,
0x000000010d197824ULL, 0x000fe200008e0619ULL, 0x000000240c247210ULL, 0x040fe20007f3e0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e0030ULL, 0x0000000016377faeULL, 0x0003e6000b901c46ULL,
0x000000010d1b7824ULL, 0x000fe200010e061bULL, 0x000000260c267210ULL, 0x040fe20007f5e0ffULL,
0x000001002d2c7825ULL, 0x100fe200078e0030ULL, 0x0000000018397faeULL, 0x0003e6000b901c46ULL,
0x000001002f2e7825ULL, 0x000fe200078e0030ULL, 0x000000001a3b7faeULL, 0x0003e6000b901c46ULL,
0x000000010d1d7824ULL, 0x000fe200018e061dULL, 0x000000280c287210ULL, 0x000fe20007f7e0ffULL,
0x000001004f307825ULL, 0x000fc600078e0030ULL, 0x000000290d297210ULL, 0x040fe20001ffe4ffULL,
0x000000010d1f7824ULL, 0x040fe200000e061fULL, 0x0000002a0c2a7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d257824ULL, 0x040fe200008e0625ULL, 0x0000002c0c2c7210ULL, 0x040fe20007f3e0ffULL,
0x000000010d277824ULL, 0x040fe200010e0627ULL, 0x0000002e0c2e7210ULL, 0x040fe20007f5e0ffULL,
0x000000010d2b7824ULL, 0x040fe200000e062bULL, 0x000000300c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000001c3d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d2d7824ULL, 0x000fc400008e062dULL,
0x000000010d2f7824ULL, 0x040fe200010e062fULL, 0x000000001e3f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e0631ULL, 0x0000000024417faeULL, 0x0003e8000b901c46ULL,
0x0000000026437faeULL, 0x0003e8000b901c46ULL, 0x0000000028457faeULL, 0x0003e8000b901c46ULL,
0x000000002a477faeULL, 0x0003e8000b901c46ULL, 0x000000002c497faeULL, 0x0003e8000b901c46ULL,
0x000000002e4b7faeULL, 0x0003e8000b901c46ULL, 0x000000000c4d7faeULL, 0x0003e4000b901c46ULL,
0x0000000409097810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff087424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000050900720cULL, 0x000fda0003f06070ULL,
0x00000002a50c8824ULL, 0x002fe400078e0209ULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000066000c0c8625ULL, 0x000fe200078e000dULL, 0x000000089d207812ULL, 0x000fe400078ec0ffULL,
0x00000004ff197819ULL, 0x000fe2000001169dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000060c088981ULL, 0x000322000c1e1900ULL, 0x0000000720207812ULL, 0x000fe200078ef89dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000079d6c7812ULL, 0x000fc600078ec0ffULL,
0x00000001191f7824ULL, 0x000fe400078e0220ULL, 0x00000010200e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e037812ULL, 0x000fc800078ee21fULL, 0x0000000403647819ULL, 0x000fc400000006ffULL,
0x00000010201c7812ULL, 0x042fe200078efcffULL, 0x0000000819037824ULL, 0x000fe200078e00ffULL,
0x00000003ff1e7819ULL, 0x000fe2000001169dULL, 0x00000010200f7824ULL, 0x000fe200078e00ffULL,
0x000000021f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119197824ULL, 0x000fe200078e021cULL,
0xfffffff8036c7812ULL, 0x000fe200078ee26cULL, 0x000000101c0e7824ULL, 0x000fe200078e00ffULL,
0x000000011e0d7812ULL, 0x000fe200078ec0ffULL, 0x00004000001d7824ULL, 0x000fe200078e00ffULL,
0x000000106c7c7810ULL, 0x040fe20007ffe0ffULL, 0x000000086c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff00e0b7812ULL, 0x000fe200078ee219ULL, 0x000000010d037824ULL, 0x040fe200078e026cULL,
0x000000206c847810ULL, 0x040fe20007ffe0ffULL, 0x000000010d187824ULL, 0x000fe200078e027cULL,
0xfffffff00f107812ULL, 0x000fe200078ee20cULL, 0x000000100b3c7824ULL, 0x000fe200078e00ffULL,
0x000000306c0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d177824ULL, 0x000fe200078e0284ULL,
0x000020001d1b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008840e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x000000010d167824ULL, 0x000fe200078e020bULL,
0x000000041c117819ULL, 0x000fe200000006ffULL, 0x000000087c0d7824ULL, 0x000fe200078e00ffULL,
0x00000002190c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e177812ULL, 0x000fe200078ee217ULL, 0x000000101a607824ULL, 0x100fe200078e021bULL,
0xfffffff80d187812ULL, 0x000fe200078ee218ULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0xfffffff80f167812ULL, 0x000fe200078ee216ULL, 0x0000001017787824ULL, 0x100fe200078e021bULL,
0xfffffff011117812ULL, 0x000fe200078ee20cULL, 0x00000010180c7824ULL, 0x000fe200078e021bULL,
0x0000001b16687211ULL, 0x000fe200078e20ffULL, 0x000000006060783bULL, 0x000e620000000200ULL,
0x000000086c127824ULL, 0x000fe200078e00ffULL, 0x0000000203157810ULL, 0x040fe20007ffe0ffULL,
0x000000087c137824ULL, 0x000fe200078e00ffULL, 0x000000000c0c783bULL, 0x000ea20000000200ULL,
0x0000001203147810ULL, 0x000fe20007ffe0ffULL, 0x0000000884287824ULL, 0x000fe200078e00ffULL,
0xfffffff812157812ULL, 0x000fe200078ee215ULL, 0x000000007878783bULL, 0x000ee20000000200ULL,
0xfffffff813147812ULL, 0x000fe200078ee214ULL, 0x000000080b297824ULL, 0x000fe200078e00ffULL,
0x0000002203137810ULL, 0x040fe20007ffe0ffULL, 0x000000006868783bULL, 0x000ea20000000200ULL,
0x0000003203127810ULL, 0x000fe20007ffe0ffULL, 0x0000001015387824ULL, 0x000fe200078e021bULL,
0xfffffff828137812ULL, 0x000fe200078ee213ULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0xfffffff829127812ULL, 0x000fe200078ee212ULL, 0x00000010145c7824ULL, 0x000fc400078e021bULL,
0x0000001013747824ULL, 0x100fe200078e021bULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000001012287824ULL, 0x000fe400078e021bULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x000000005c5c783bULL, 0x000fe20000000200ULL, 0x0000001011117824ULL, 0x000fe400078e00ffULL,
0x000000087c897824ULL, 0x000fe200078e00ffULL, 0x000000001054783bULL, 0x0002e20000000200ULL,
0x00000008848b7824ULL, 0x000fc400078e00ffULL, 0x000000080b887824ULL, 0x000fe200078e00ffULL,
0x000000007474783bULL, 0x000ee80000000200ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x000000041f107810ULL, 0x002fe20007ffe0ffULL, 0x00000060642c723cULL, 0x040f6400000418ffULL,
0x000000001124783bULL, 0x0002ec0000000200ULL, 0x000000626434723cULL, 0x000f6200000418ffULL,
0x0000000419117810ULL, 0x002fce0007ffe0ffULL, 0x0000000c6440723cULL, 0x044f7000000418ffULL,
0x0000000e6444723cULL, 0x040f7000000418ffULL, 0x000000786448723cULL, 0x048f7000000418ffULL,
0x0000007a644c723cULL, 0x040f7000000418ffULL, 0x000000686450723cULL, 0x040f7000000418ffULL,
0x0000006a6464723cULL, 0x000f7000000418ffULL, 0x0000000c3c58723cULL, 0x040f7000000418ffULL,
0x0000000e3c0c723cULL, 0x040ff000000418ffULL, 0x000000603c30723cULL, 0x040f7000000418ffULL,
0x000000623c60723cULL, 0x000f7000000418ffULL, 0x00000038542c723cULL, 0x060ff0000004182cULL,
0x0000003a5434723cULL, 0x040ff00000041834ULL, 0x0000005c5440723cULL, 0x040ff00000041840ULL,
0x0000005e5444723cULL, 0x040ff00000041844ULL, 0x000000745448723cULL, 0x040ff00000041848ULL,
0x00000076544c723cULL, 0x040ff0000004184cULL, 0x000000285450723cULL, 0x000ff00000041850ULL,
0x000000683c80723cULL, 0x000bee00000418ffULL, 0x000000101c687824ULL, 0x020fe200078e00ffULL,
0x0000002a5454723cULL, 0x000bee0000041864ULL, 0x0000001020677824ULL, 0x060fe200078e00ffULL,
0x0000005c2458723cULL, 0x000be20000041858ULL, 0x0000000420657819ULL, 0x000fe200000006ffULL,
0x000000101c667824ULL, 0x000fc600078e00ffULL, 0xfffffff065647812ULL, 0x000fe400078ee210ULL,
0x000000061f5c7810ULL, 0x020fe20007ffe0ffULL, 0x000000382430723cULL, 0x040fe20000041830ULL,
0x00000006195d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001064647824ULL, 0x000fe200078e00ffULL,
0xfffffff067867812ULL, 0x000fe200078ee25cULL, 0x000000080b677824ULL, 0x000fe200078e00ffULL,
0xfffffff068877812ULL, 0x000fe400078ee25dULL, 0x0000001403107810ULL, 0x040fe20007ffe0ffULL,
0x0000005e245c723cULL, 0x040be2000004180cULL, 0xfffffff066657812ULL, 0x000fe200078ee211ULL,
0x0000000884667824ULL, 0x000fe200078e00ffULL, 0x0000000403117810ULL, 0x040fe20007ffe0ffULL,
0x0000001086867824ULL, 0x000fe200078e00ffULL, 0x0000002603847810ULL, 0x000fe20007ffe0ffULL,
0x00000010878c7824ULL, 0x000fe200078e00ffULL, 0x00000034030e7810ULL, 0x020fe20007ffe0ffULL,
0x000000087c0d7824ULL, 0x000fe200078e00ffULL, 0x0000003a2438723cULL, 0x000fe20000041860ULL,
0x000000086c0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8670e7812ULL, 0x000fe200078ee20eULL,
0x000000008c8c783bULL, 0x000fe20000000200ULL, 0xfffffff80d107812ULL, 0x000fc400078ee210ULL,
0x00000004656c7819ULL, 0x000fe200000006ffULL, 0x000000100e7d7824ULL, 0x100fe200078e021bULL,
0x000000783c60723cULL, 0x040f6200000418ffULL, 0x0000001010707824ULL, 0x000fe200078e021bULL,
0x00000024030f7810ULL, 0x040fe40007ffe0ffULL, 0x000000006c6c783bULL, 0x000fe20000000200ULL,
0x00000006030d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8660f7812ULL, 0x000fe200078ee20fULL,
0x0000007a3c78723cULL, 0x000f6200000418ffULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0xfffffff80c117812ULL, 0x000fc400078ee211ULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee20dULL,
0x000000007070783bULL, 0x000e620000000200ULL, 0x00000016030c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001011687824ULL, 0x100fe200078e021bULL, 0x0000006a3c3c723cULL, 0x000b6200000418ffULL,
0x000000007d7c783bULL, 0x000ea20000000200ULL, 0x0000003603037810ULL, 0x000fe20007ffe0ffULL,
0x000000100f857824ULL, 0x000fe200078e021bULL, 0xfffffff8890c7812ULL, 0x000fe200078ee20cULL,
0x000000006868783bULL, 0x020ee20000000200ULL, 0xfffffff888037812ULL, 0x000fe200078ee203ULL,
0x000000100d887824ULL, 0x000fe200078e021bULL, 0x0000001b0c907211ULL, 0x000fe200078e20ffULL,
0x000000742460723cULL, 0x000fe20000041860ULL, 0xfffffff88b0b7812ULL, 0x000fc600078ee284ULL,
0x000000008888783bULL, 0x000fe40000000200ULL, 0x000000100b947824ULL, 0x100fe400078e021bULL,
0x000000762474723cULL, 0x040be20000041878ULL, 0x000000009090783bULL, 0x000fe80000000200ULL,
0x000000008578783bULL, 0x020ee60000000200ULL, 0x000000282480723cULL, 0x040b620000041880ULL,
0x000000008684783bULL, 0x000ee80000000200ULL, 0x000000009494783bULL, 0x000fe40000000200ULL,
0x0000001003287824ULL, 0x020fe200078e021bULL, 0x0000002a243c723cULL, 0x000b68000004183cULL,
0x000000002824783bULL, 0x020ee80000000200ULL, 0x000000706440723cULL, 0x082f700000041840ULL,
0x000000706c58723cULL, 0x000f700000041858ULL, 0x0000007c6450723cULL, 0x084f700000041850ULL,
0x0000007c6c80723cULL, 0x000f700000041880ULL, 0x00000068642c723cULL, 0x088f70000004182cULL,
0x000000686c30723cULL, 0x000f700000041830ULL, 0x0000006a6434723cULL, 0x080f700000041834ULL,
0x0000006a6c38723cULL, 0x000f700000041838ULL, 0x000000726444723cULL, 0x040f700000041844ULL,
0x000000786448723cULL, 0x040f700000041848ULL, 0x0000007a644c723cULL, 0x040f70000004184cULL,
0x0000007e6454723cULL, 0x000f700000041854ULL, 0x000000726c5c723cULL, 0x040f70000004185cULL,
0x000000786c60723cULL, 0x040f700000041860ULL, 0x0000007a6c74723cULL, 0x040f700000041874ULL,
0x0000007e6c3c723cULL, 0x000f70000004183cULL, 0x000000908440723cULL, 0x0a0f700000041840ULL,
0x000000908c58723cULL, 0x000b6e0000041858ULL, 0x0000030002907a10ULL, 0x020fe20007ffe0ffULL,
0x000000248450723cULL, 0x080f700000041850ULL, 0x000000248c80723cULL, 0x000b6e0000041880ULL,
0x0000000190257810ULL, 0x020fe20007ffe0ffULL, 0x00000088842c723cULL, 0x000b66000004182cULL,
0x000000062500720cULL, 0x000fe20003f06070ULL, 0x000000a208257224ULL, 0x010fc800078e02ffULL,
0x000000888c30723cULL, 0x000b620000041830ULL, 0x0000640025247625ULL, 0x000fce00078e00a4ULL,
0x0000008a8434723cULL, 0x080b700000041834ULL, 0x0000008a8c38723cULL, 0x000b700000041838ULL,
0x000000928444723cULL, 0x040b700000041844ULL, 0x000000948448723cULL, 0x040b700000041848ULL,
0x00000096844c723cULL, 0x040b70000004184cULL, 0x000000268454723cULL, 0x000b700000041854ULL,
0x000000928c5c723cULL, 0x040b70000004185cULL, 0x000000948c60723cULL, 0x040b700000041860ULL,
0x000000968c74723cULL, 0x040b700000041874ULL, 0x000000268c3c723cULL, 0x000b62000004183cULL,
0x00000c5000008947ULL, 0x000fce0003800000ULL, 0x000000011e267824ULL, 0x060fe200078e029dULL,
0x000000041e287810ULL, 0x000fe20007ffe0ffULL, 0x0000010090277824ULL, 0x000fe200078e02a3ULL,
0x0000000c1e667810ULL, 0x000fc40007ffe0ffULL, 0x0000000721847812ULL, 0x000fe200078ef826ULL,
0x0000000128297824ULL, 0x100fe200078e029dULL, 0x0000002704267217ULL, 0x000fe20007800000ULL,
0x0000000828867824ULL, 0x000fe200078e00ffULL, 0x000000181e967810ULL, 0x000fe20007ffe0ffULL,
0x0000000166647824ULL, 0x040fe200078e029dULL, 0x0000000366657819ULL, 0x000fe200000006ffULL,
0x0000000126217824ULL, 0x000fe200078e0a27ULL, 0x000000101e8c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000896a47824ULL, 0x000fe200078e00ffULL, 0xfffffff886867812ULL, 0x000fe200078ee229ULL,
0x0000000196297824ULL, 0x100fe200078e029dULL, 0xfffffff8658a7812ULL, 0x000fe200078ee264ULL,
0x000000018c267824ULL, 0x000fe200078e029dULL, 0x000000201eaa7810ULL, 0x000fe20007ffe0ffULL,
0x000000088c657824ULL, 0x000fe200078e00ffULL, 0x000000081e2a7810ULL, 0x040fe20007ffe0ffULL,
0x00000001077c7824ULL, 0x000fe200078e0266ULL, 0x000000141e927810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8a4a47812ULL, 0x000fe200078ee229ULL, 0x00000008aa297824ULL, 0x000fe200078e00ffULL,
0xfffffff8658e7812ULL, 0x000fe200078ee226ULL, 0x000000012a2b7824ULL, 0x100fe200078e029dULL,
0x0000009daa267210ULL, 0x000fe20007ffe0ffULL, 0x000000082a887824ULL, 0x000fe200078e00ffULL,
0x000000341eb87810ULL, 0x000fe20007ffe0ffULL, 0x0000000192277824ULL, 0x000fe200078e029dULL,
0x0000001c1ea67810ULL, 0x000fe20007ffe0ffULL, 0x0000000892947824ULL, 0x000fe200078e00ffULL,
0x000000241eae7810ULL, 0x000fe20007ffe0ffULL, 0x000001007c7c7825ULL, 0x000fe200078e00ffULL,
0xfffffff829ac7812ULL, 0x000fc400078ee226ULL, 0x0000009db86c7210ULL, 0x040fe20007ffe0ffULL,
0x00000008b8297824ULL, 0x000fe200078e00ffULL, 0xfffffff888887812ULL, 0x000fe200078ee22bULL,
0x00000001a62b7824ULL, 0x000fe200078e029dULL, 0x0000002c1eb47810ULL, 0x000fe20007ffe0ffULL,
0x00000008a6a87824ULL, 0x000fe200078e00ffULL, 0xfffffff894947812ULL, 0x000fe200078ee227ULL,
0x00000001ae277824ULL, 0x100fe200078e029dULL, 0x000000281eb27810ULL, 0x000fe20007ffe0ffULL,
0x00000008aeb07824ULL, 0x000fe200078e00ffULL, 0x000000301eb67810ULL, 0x000fe20007ffe0ffULL,
0x00000001b4707824ULL, 0x000fe200078e029dULL, 0xfffffff8296c7812ULL, 0x000fe200078ee26cULL,
0x0000000107297824ULL, 0x000fe200078e0228ULL, 0xfffffff8a8a87812ULL, 0x000fe200078ee22bULL,
0x00000008b4657824ULL, 0x000fe200078e00ffULL, 0x0000003c1e7a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001b26e7824ULL, 0x000fe200078e029dULL, 0xfffffff8b0b07812ULL, 0x000fe200078ee227ULL,
0x00000008b22b7824ULL, 0x000fe200078e00ffULL, 0x000000212800720cULL, 0x000fe20003fa6070ULL,
0x00000001b6727824ULL, 0x000fe200078e029dULL, 0x000000381e787810ULL, 0x000fe20007ffe0ffULL,
0x00000008b6277824ULL, 0x000fe200078e00ffULL, 0xfffffff865707812ULL, 0x000fe200078ee270ULL,
0x0000010029287825ULL, 0x000fe200078e00ffULL, 0x0000008c077e7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff82b6e7812ULL, 0x000fe200078ee26eULL, 0x0000000107267824ULL, 0x000fe200078e021eULL,
0xfffffff827727812ULL, 0x000fe200078ee272ULL, 0x000000017a687824ULL, 0x100fe200078e029dULL,
0x0000002228677212ULL, 0x080fe200078efcffULL, 0x000000087a657824ULL, 0x000fe200078e00ffULL,
0x000000227c697212ULL, 0x000fe200078efcffULL, 0x00000001786a7824ULL, 0x000fe200078e029dULL,
0x000000216600720cULL, 0x000fe20003f26070ULL, 0x00000008782b7824ULL, 0x000fe200078e00ffULL,
0xfffffff865687812ULL, 0x000fe200078ee268ULL, 0x0000000107647824ULL, 0x000fe200078e022aULL,
0x0000006724667210ULL, 0x000fe20007f7e0ffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0xfffffff82b6a7812ULL, 0x000fc400078ee26aULL, 0x0000006924287210ULL, 0x000fe20007fde0ffULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x00000022262b7212ULL, 0x080fe400078efcffULL,
0x000000211e00720cULL, 0x080fe20003f86070ULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x000000227e697212ULL, 0x080fe400078efcffULL, 0x000000212a00720cULL, 0x000fe20003f06070ULL,
0x00000001077c7824ULL, 0x000fe200078e0292ULL, 0x00000022646b7212ULL, 0x000fe200078efcffULL,
0x0000000125677824ULL, 0x040fe200018e0629ULL, 0x0000002b242a7210ULL, 0x040fe20007f5e0ffULL,
0x0000000125297824ULL, 0x000fe200030e067dULL, 0x0000006924647210ULL, 0x000fe20007fde0ffULL,
0x000001007c7c7825ULL, 0x000fe200078e00ffULL, 0x0000006b24267210ULL, 0x000fc40007f7e0ffULL,
0x0000001b866b7211ULL, 0x000fe200078e20ffULL, 0x0000001084697824ULL, 0x000fe200078e021bULL,
0x000000227c6d7212ULL, 0x000fe200078efcffULL, 0x0000000107847824ULL, 0x000fe400078e02a6ULL,
0x00000001252b7824ULL, 0x000fe200010e0627ULL, 0x000000218c00720cULL, 0x000fe20003f46070ULL,
0x0000010084847825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a697faeULL, 0x0003e2000e101c46ULL, 0x0000000125277824ULL, 0x040fe200018e0665ULL,
0x000000219200720cULL, 0x000fe20003f66070ULL, 0x0000000125657824ULL, 0x000fe200030e067fULL,
0x0000006d247c7210ULL, 0x000fe20007fde0ffULL, 0x00000000666b7faeULL, 0x0005e2000e901c46ULL,
0x00000022846d7212ULL, 0x000fe200078efcffULL, 0x00000001077e7824ULL, 0x000fe200078e0296ULL,
0x000000219600720cULL, 0x000fe20003fa6070ULL, 0x00000001257d7824ULL, 0x000fe400030e067dULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x0000006d242a7210ULL, 0x002fc60007fde0ffULL,
0x0000001088697824ULL, 0x100fe200078e021bULL, 0x000000227e6f7212ULL, 0x000fe200078efcffULL,
0x000000108a677824ULL, 0x104fe400078e021bULL, 0x000000108e6b7824ULL, 0x100fe200078e021bULL,
0x0000000026697faeULL, 0x0003e2000c101c46ULL, 0x00000010946d7824ULL, 0x000fe200078e021bULL,
0x0000006f247e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000107667824ULL, 0x000fe200078e02b4ULL,
0x0000000028677faeULL, 0x0005e2000c901c46ULL, 0x00000001252b7824ULL, 0x040fe200030e0685ULL,
0x00000021b200720cULL, 0x080fe20003f06070ULL, 0x00000001257f7824ULL, 0x000fe200020e067fULL,
0x00000000646b7faeULL, 0x0007e2000d101c46ULL, 0x00000021aa00720cULL, 0x080fe20003f46070ULL,
0x0000000107aa7824ULL, 0x040fe200078e02aaULL, 0x00000021a600720cULL, 0x080fe20003f86070ULL,
0x000000007c6d7faeULL, 0x0009e2000d901c46ULL, 0x00000021ae00720cULL, 0x080fe20003f66070ULL,
0x0000000107ae7824ULL, 0x040fe200078e02aeULL, 0x000000b207b27210ULL, 0x000fe20007ffe0ffULL,
0x00000100aa267825ULL, 0x002fe200078e00ffULL, 0x00000021b400720cULL, 0x000fc60003f26070ULL,
0x00000100ae287825ULL, 0x004fe200078e00ffULL, 0x00000022267d7212ULL, 0x010fc600078efcffULL,
0x00000010a4697824ULL, 0x000fe200078e021bULL, 0x0000002228857212ULL, 0x080fe200078efcffULL,
0x0000010066667825ULL, 0x000fe200078e00ffULL, 0x0000007d247c7210ULL, 0x040fe40007fde0ffULL,
0x000000007e697faeULL, 0x0003e2000e901c46ULL, 0x0000000107267824ULL, 0x000fe200078e02b6ULL,
0x0000008524847210ULL, 0x000fe20007fbe0ffULL, 0x00000001257d7824ULL, 0x000fe200030e0627ULL,
0x00000022666b7212ULL, 0x008fe200078efcffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000007807287210ULL, 0x000fc60007ffe0ffULL, 0x0000000125857824ULL, 0x000fe200028e0629ULL,
0x0000006b24667210ULL, 0x000fe20007fbe0ffULL, 0x00000100b2647825ULL, 0x000fe200078e00ffULL,
0x00000022267f7212ULL, 0x002fc600078efcffULL, 0x0000000125677824ULL, 0x000fe200028e0667ULL,
0x0000007f247e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000107267824ULL, 0x000fe200078e02b8ULL,
0x00000022646d7212ULL, 0x000fe200078efcffULL, 0x00000010a8697824ULL, 0x000fe400078e021bULL,
0x00000001257f7824ULL, 0x000fe200028e0627ULL, 0x0000006d24647210ULL, 0x000fe20007fde0ffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x000000002a697faeULL, 0x0003e2000e101c46ULL,
0x00000021b800720cULL, 0x000fc40003f86070ULL, 0x0000010028287825ULL, 0x000fc800078e00ffULL,
0x00000010ac6b7824ULL, 0x100fe400078e021bULL, 0x00000010b06d7824ULL, 0x000fe400078e021bULL,
0x0000000125657824ULL, 0x000fe200030e0665ULL, 0x00000022262b7212ULL, 0x082fe200078efcffULL,
0x00000001072a7824ULL, 0x000fe200078e027aULL, 0x0000002228697212ULL, 0x080fe200078efcffULL,
0x000000007c6b7faeULL, 0x0003e2000d101c46ULL, 0x0000002b24267210ULL, 0x000fe20007fbe0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000021b600720cULL, 0x000fe20003fc6070ULL,
0x00000000846d7faeULL, 0x0005e2000d901c46ULL, 0x0000006924287210ULL, 0x000fe20007f5e0ffULL,
0x0000000125277824ULL, 0x040fe200028e0627ULL, 0x000000217800720cULL, 0x080fe20003f66070ULL,
0x0000001070697824ULL, 0x000fe200078e021bULL, 0x000000222a6f7212ULL, 0x000fe200078efcffULL,
0x0000000125297824ULL, 0x000fe200010e0629ULL, 0x000000217a00720cULL, 0x000fe20003fa6070ULL,
0x000000106e217824ULL, 0x100fe200078e021bULL, 0x0000006f24247210ULL, 0x000fe20007f5e0ffULL,
0x00000010726b7824ULL, 0x102fe200078e021bULL, 0x0000001b6c6d7211ULL, 0x004fe200078e20ffULL,
0x000000106a6f7824ULL, 0x100fe200078e021bULL, 0x0000000064217faeULL, 0x0003e2000c101c46ULL,
0x00000010681b7824ULL, 0x000fc400078e021bULL, 0x0000000125257824ULL, 0x000fe200010e062bULL,
0x0000000066697faeULL, 0x0003e8000c901c46ULL, 0x000000007e6b7faeULL, 0x0003e8000f101c46ULL,
0x00000000266d7faeULL, 0x0003e8000e101c46ULL, 0x00000000286f7faeULL, 0x0003e8000d901c46ULL,
0x00000000241b7faeULL, 0x0003e2000e901c46ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x000000041e2a7810ULL, 0x040fe20007ffe0ffULL, 0x000000011e267824ULL, 0x060fe200078e029dULL,
0x000000081e667810ULL, 0x000fc40007ffe0ffULL, 0x0000000c1e6a7810ULL, 0x000fe20007ffe0ffULL,
0x000000012a277824ULL, 0x140fe200078e029dULL, 0x0000000721287812ULL, 0x000fe200078ef826ULL,
0x000000082a647824ULL, 0x000fe200078e00ffULL, 0x000000101e6e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000166217824ULL, 0x000fe200078e029dULL, 0x000000141e727810ULL, 0x000fe20007ffe0ffULL,
0x0000000866687824ULL, 0x000fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee227ULL,
0x000000016a267824ULL, 0x040fe200078e029dULL, 0x000000036a277819ULL, 0x000fe200000006ffULL,
0x000000086e707824ULL, 0x000fe200078e00ffULL, 0xfffffff868687812ULL, 0x000fe200078ee221ULL,
0x000000016e217824ULL, 0x100fe200078e029dULL, 0xfffffff8276c7812ULL, 0x000fe200078ee226ULL,
0x0000000172267824ULL, 0x000fe200078e029dULL, 0x000000181e7a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000872277824ULL, 0x000fe200078e00ffULL, 0x0000001c1e7e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107297824ULL, 0x000fe200078e022aULL, 0xfffffff870707812ULL, 0x000fe200078ee221ULL,
0x000000017a217824ULL, 0x140fe200078e029dULL, 0xfffffff827787812ULL, 0x000fe200078ee226ULL,
0x000000087a7c7824ULL, 0x000fe200078e00ffULL, 0x000000201e867810ULL, 0x000fe20007ffe0ffULL,
0x000000017e267824ULL, 0x000fe200078e029dULL, 0x000000241e8a7810ULL, 0x000fe20007ffe0ffULL,
0x000000087e277824ULL, 0x000fe200078e00ffULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee221ULL,
0x0000000186217824ULL, 0x040fe200078e029dULL, 0x0000000386887819ULL, 0x000fe200000006ffULL,
0x0000001068897824ULL, 0x000fe200078e021bULL, 0xfffffff827847812ULL, 0x000fe200078ee226ULL,
0x000000018a267824ULL, 0x000fe200078e029dULL, 0x000000281e8e7810ULL, 0x000fe20007ffe0ffULL,
0x000000088a277824ULL, 0x000fe200078e00ffULL, 0x0000002c1e947810ULL, 0x000fe20007ffe0ffULL,
0x0000000107687824ULL, 0x000fe200078e0272ULL, 0xfffffff888887812ULL, 0x000fe200078ee221ULL,
0x000000018e217824ULL, 0x140fe200078e029dULL, 0xfffffff8278c7812ULL, 0x000fe200078ee226ULL,
0x000000088e927824ULL, 0x000fe200078e00ffULL, 0x000000301ea47810ULL, 0x000fe20007ffe0ffULL,
0x0000000194267824ULL, 0x000fe200078e029dULL, 0x000000341ea87810ULL, 0x000fe20007ffe0ffULL,
0x0000000894277824ULL, 0x000fe200078e00ffULL, 0xfffffff892927812ULL, 0x000fe200078ee221ULL,
0x00000001a4217824ULL, 0x100fe200078e029dULL, 0x0000003c1eae7810ULL, 0x000fe20007ffe0ffULL,
0x00000008a4a67824ULL, 0x000fe200078e00ffULL, 0xfffffff827967812ULL, 0x000fe200078ee226ULL,
0x00000001a8277824ULL, 0x000fe200078e029dULL, 0x000000381eac7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107267824ULL, 0x000fe200078e021eULL, 0x00000003a8aa7819ULL, 0x000fe200000006ffULL,
0x00000008aeb07824ULL, 0x000fe200078e00ffULL, 0xfffffff8a6a67812ULL, 0x000fe200078ee221ULL,
0x00000001ae217824ULL, 0x000fe200078e029dULL, 0xfffffff8aaaa7812ULL, 0x000fe200078ee227ULL,
0x00000001ac1e7824ULL, 0x000fe200078e029dULL, 0x0000001b6c8b7211ULL, 0x080fe200078e20ffULL,
0x00000008ac2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8b02a7812ULL, 0x000fe200078ee221ULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x0000001baaaf7211ULL, 0x000fc400078e20ffULL,
0xfffffff82b1e7812ULL, 0x000fe200078ee21eULL, 0x0000001028217824ULL, 0x000fe200078e021bULL,
0x00000022262b7212ULL, 0x000fe200078efcffULL, 0x0000010029287825ULL, 0x000fc600078e00ffULL,
0x0000002b24267210ULL, 0x000fe20007f1e0ffULL, 0x000000102ab77824ULL, 0x100fe200078e021bULL,
0x00000022282b7212ULL, 0x000fe200078efcffULL, 0x00000001072a7824ULL, 0x000fe400078e0266ULL,
0x0000001064877824ULL, 0x000fe200078e021bULL, 0x0000002b24287210ULL, 0x000fe20007f3e0ffULL,
0x000001002a2a7825ULL, 0x000fc800078e00ffULL, 0x0000000107647824ULL, 0x000fe400078e026aULL,
0x00000010708d7824ULL, 0x100fe400078e021bULL, 0x00000010788f7824ULL, 0x100fe400078e021bULL,
0x000000107c917824ULL, 0x100fe400078e021bULL, 0x0000001084937824ULL, 0x100fe400078e021bULL,
0x0000001088957824ULL, 0x000fc400078e021bULL, 0x000000108c977824ULL, 0x100fe400078e021bULL,
0x0000001092a77824ULL, 0x100fe400078e021bULL, 0x0000001096a97824ULL, 0x100fe400078e021bULL,
0x00000010a6ab7824ULL, 0x100fe400078e021bULL, 0x000000101eb37824ULL, 0x000fe200078e021bULL,
0x000000222a1b7212ULL, 0x000fe200078efcffULL, 0x0000000107667824ULL, 0x000fc400078e026eULL,
0x0000010068687825ULL, 0x000fc800078e00ffULL, 0x0000010064647825ULL, 0x000fc800078e00ffULL,
0x00000001076a7824ULL, 0x000fe200078e027aULL, 0x00000022646d7212ULL, 0x080fe200078efcffULL,
0x0000000125277824ULL, 0x040fe200000e0627ULL, 0x0000001b242a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010066667825ULL, 0x000fe200078e00ffULL, 0x00000022681b7212ULL, 0x080fe400078efcffULL,
0x0000002b252b7210ULL, 0x000fe200007fe4ffULL, 0x000001006a6a7825ULL, 0x000fe200078e00ffULL,
0x00000022666f7212ULL, 0x080fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026217faeULL, 0x0003e2000b901c46ULL, 0x0000001b24687210ULL, 0x000fe20007f1e0ffULL,
0x00000001076c7824ULL, 0x040fe200078e027eULL, 0x000000226a1b7212ULL, 0x000fe200078efcffULL,
0x00000001076e7824ULL, 0x000fe200078e0286ULL, 0x0000006f24667210ULL, 0x040fe20007f5e0ffULL,
0x0000000125297824ULL, 0x000fe200008e0629ULL, 0x0000006d24647210ULL, 0x000fe20007f3e0ffULL,
0x000001006c6c7825ULL, 0x000fc600078e00ffULL, 0x0000000028877faeULL, 0x0003e2000b901c46ULL,
0x0000000107707824ULL, 0x000fe400078e028aULL, 0x000001006e6e7825ULL, 0x000fe200078e00ffULL,
0x000000002a897faeULL, 0x0003e6000b901c46ULL, 0x0000000125697824ULL, 0x000fe200000e0669ULL,
0x0000001b246a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000107727824ULL, 0x000fe200078e028eULL,
0x000000226c1b7212ULL, 0x080fe200078efcffULL, 0x0000010070707825ULL, 0x000fe200078e00ffULL,
0x000000226e797212ULL, 0x000fc600078efcffULL, 0x0000010072727825ULL, 0x000fc800078e00ffULL,
0x0000000107787824ULL, 0x000fe200078e0294ULL, 0x00000022727b7212ULL, 0x080fe200078efcffULL,
0x00000001256b7824ULL, 0x040fe200000e066bULL, 0x0000001b246c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000125657824ULL, 0x000fe200008e0665ULL, 0x00000022701b7212ULL, 0x080fe200078efcffULL,
0x00000001077a7824ULL, 0x000fe200078e02a4ULL, 0x00000079246e7210ULL, 0x000fe20007f3e0ffULL,
0x0000010078787825ULL, 0x000fe200078e00ffULL, 0x0000006d256d7210ULL, 0x040fe200007fe4ffULL,
0x00000000648b7faeULL, 0x0003e2000b901c46ULL, 0x0000001b24707210ULL, 0x040fe20007f1e0ffULL,
0x0000000125677824ULL, 0x000fe200010e0667ULL, 0x0000007b24727210ULL, 0x000fe20007f5e0ffULL,
0x00000001077c7824ULL, 0x040fe200078e02a8ULL, 0x00000022781b7212ULL, 0x000fe200078efcffULL,
0x00000001077e7824ULL, 0x040fe200078e02acULL, 0x00000000668d7faeULL, 0x0003e2000b901c46ULL,
0x0000000107847824ULL, 0x000fc400078e02aeULL, 0x000001007a7a7825ULL, 0x000fe200078e00ffULL,
0x00000000688f7faeULL, 0x0003e6000b901c46ULL, 0x0000000125717824ULL, 0x000fe200000e0671ULL,
0x0000001b24787210ULL, 0x000fe20007f1e0ffULL, 0x000001007c7c7825ULL, 0x000fe200078e00ffULL,
0x000000227a1b7212ULL, 0x080fe200078efcffULL, 0x000000006a917faeULL, 0x0003e4000b901c46ULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x000000227cad7212ULL, 0x080fe200078efcffULL,
0x000000006c937faeULL, 0x0003e4000b901c46ULL, 0x0000010084847825ULL, 0x000fe200078e00ffULL,
0x000000227eb17212ULL, 0x000fc600078efcffULL, 0x0000000125797824ULL, 0x040fe200000e0679ULL,
0x0000002284b57212ULL, 0x000fe200078efcffULL, 0x00000001256f7824ULL, 0x040fe200008e066fULL,
0x0000001b247a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000125737824ULL, 0x040fe200010e0673ULL,
0x000000ad247c7210ULL, 0x040fe40007f3e0ffULL, 0x000000b1247e7210ULL, 0x040fe20007f5e0ffULL,
0x00000001257b7824ULL, 0x040fe200000e067bULL, 0x000000b524247210ULL, 0x000fe20007f7e0ffULL,
0x000000006e957faeULL, 0x0003e2000b901c46ULL, 0x0000007d257d7210ULL, 0x040fe20000ffe4ffULL,
0x00000001257f7824ULL, 0x000fc400010e067fULL, 0x0000000070977faeULL, 0x0003e2000b901c46ULL,
0x0000000125257824ULL, 0x000fc600018e0685ULL, 0x0000000072a77faeULL, 0x0003e8000b901c46ULL,
0x0000000078a97faeULL, 0x0003e8000b901c46ULL, 0x000000007aab7faeULL, 0x0003e8000b901c46ULL,
0x000000007caf7faeULL, 0x0003e8000b901c46ULL, 0x000000007eb37faeULL, 0x0003e8000b901c46ULL,
0x0000000024b77faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001020227824ULL, 0x000fe200078e00ffULL, 0x000000081f1b7810ULL, 0x002fe20007ffe0ffULL,
0x000000101c217824ULL, 0x000fe200078e00ffULL, 0x00000008191e7810ULL, 0x000fc40007ffe0ffULL,
0x000040001d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff0221b7812ULL, 0x000fe400078ee21bULL,
0xfffffff0211e7812ULL, 0x000fe200078ee21eULL, 0x000000101a247824ULL, 0x100fe400078e021dULL,
0x000000101b1b7824ULL, 0x000fe200078e00ffULL, 0x000000041e1e7819ULL, 0x000fe200000006ffULL,
0x00000010176c7824ULL, 0x100fe400078e021dULL, 0x0000001016687824ULL, 0x000fe200078e021dULL,
0x0000000a1f167810ULL, 0x000fe20007ffe0ffULL, 0x0000001020177824ULL, 0x000fc400078e00ffULL,
0x0000001018707824ULL, 0x000fe400078e021dULL, 0x000000101c187824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002424783bULL, 0x000fe20000000200ULL,
0xfffffff017167812ULL, 0x000fe200078ee216ULL, 0x0000001015157824ULL, 0x100fe200078e021dULL,
0x0000000a19177810ULL, 0x000fe20007ffe0ffULL, 0x000000001b28783bULL, 0x000e620000000200ULL,
0x00000010147c7824ULL, 0x000fe400078e021dULL, 0xfffffff018187812ULL, 0x000fe200078ee217ULL,
0x000000001e64783bULL, 0x000ea20000000200ULL, 0x0000001016787824ULL, 0x000fe400078e00ffULL,
0x0000001013887824ULL, 0x000fe200078e021dULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x0000001018187824ULL, 0x000fc400078e00ffULL, 0x00000010128c7824ULL, 0x100fe200078e021dULL,
0x000000006c6c783bULL, 0x000f220000000200ULL, 0x0000001020137824ULL, 0x000fe200078e00ffULL,
0x0000000c1f127810ULL, 0x000fe20007ffe0ffULL, 0x0000001010107824ULL, 0x100fe200078e021dULL,
0x000000006868783bULL, 0x000ee20000000200ULL, 0x0000001020207824ULL, 0x000fe200078e00ffULL,
0xfffffff013127812ULL, 0x000fe200078ee212ULL, 0x000000100c0c7824ULL, 0x000fe200078e021dULL,
0x000000001514783bULL, 0x000fe20000000200ULL, 0x0000000e1f1f7810ULL, 0x000fc60007ffe0ffULL,
0x000000007878783bULL, 0x000ee20000000200ULL, 0xfffffff0201f7812ULL, 0x000fc600078ee21fULL,
0x000000001884783bULL, 0x0002e40000000200ULL, 0x000000101f1f7824ULL, 0x000fe400078e00ffULL,
0x000000007c7c783bULL, 0x000ee80000000200ULL, 0x000000008888783bULL, 0x000f220000000200ULL,
0x000000101c187824ULL, 0x042fe200078e00ffULL, 0x000000041c1c7819ULL, 0x000fe200000006ffULL,
0x00000024282c723cULL, 0x080f62000004182cULL, 0x000000008c8c783bULL, 0x000e6e0000000200ULL,
0x000000246430723cULL, 0x004b6e0000041830ULL, 0x0000001d11247211ULL, 0x020fe200078e20ffULL,
0x000000262834723cULL, 0x000f620000041834ULL, 0x0000000c19117810ULL, 0x000fc40007ffe0ffULL,
0x0000000e19197810ULL, 0x000fe40007ffe0ffULL, 0xfffffff018187812ULL, 0x000fe400078ee211ULL,
0xfffffff01c197812ULL, 0x000fe200078ee219ULL, 0x000000266438723cULL, 0x000b640000041838ULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x000000002424783bULL, 0x020fe20000000200ULL,
0x00000010191c7824ULL, 0x000fc800078e00ffULL, 0x000000702840723cULL, 0x048f700000041840ULL,
0x000000722844723cULL, 0x040f700000041844ULL, 0x0000006c2848723cULL, 0x050f700000041848ULL,
0x0000006e284c723cULL, 0x000f70000004184cULL, 0x000000706458723cULL, 0x040f700000041858ULL,
0x00000072645c723cULL, 0x040b64000004185cULL, 0x000000001f70783bULL, 0x020fec0000000200ULL,
0x0000006c6460723cULL, 0x000b6e0000041860ULL, 0x000000100d6c7824ULL, 0x120fe200078e021dULL,
0x000000682850723cULL, 0x040ff00000041850ULL, 0x0000006a2854723cULL, 0x000b6e0000041854ULL,
0x000000100f287824ULL, 0x120fe200078e021dULL, 0x0000006e6474723cULL, 0x040b640000041874ULL,
0x000000006c6c783bULL, 0x020fe80000000200ULL, 0x000000002828783bULL, 0x000fe40000000200ULL,
0x000000686480723cULL, 0x000b6e0000041880ULL, 0x000000100e687824ULL, 0x120fe200078e021dULL,
0x00000014782c723cULL, 0x080fe2000004182cULL, 0x000000000c0c783bULL, 0x000fee0000000200ULL,
0x000000148430723cULL, 0x000bee0000041830ULL, 0x0000001012147824ULL, 0x020fe200078e00ffULL,
0x0000006a643c723cULL, 0x000b62000004183cULL, 0x000000001010783bULL, 0x000fe80000000200ULL,
0x000000001864783bULL, 0x0205e60000000200ULL, 0x000000167834723cULL, 0x000f620000041834ULL,
0x000000006868783bULL, 0x000fe20000000200ULL, 0x000000100b187824ULL, 0x004fcc00078e021dULL,
0x000000168438723cULL, 0x000be40000041838ULL, 0x000000001414783bULL, 0x020ea80000000200ULL,
0x000000001818783bULL, 0x000ee40000000200ULL, 0x0000007c7840723cULL, 0x040f700000041840ULL,
0x0000007e7844723cULL, 0x040f700000041844ULL, 0x000000887848723cULL, 0x040f700000041848ULL,
0x0000008a784c723cULL, 0x000f70000004184cULL, 0x0000007c8458723cULL, 0x040f700000041858ULL,
0x0000007e845c723cULL, 0x040f70000004185cULL, 0x000000888460723cULL, 0x000f700000041860ULL,
0x0000008e7854723cULL, 0x002f700000041854ULL, 0x0000008a8474723cULL, 0x040f700000041874ULL,
0x0000008c8480723cULL, 0x080f700000041880ULL, 0x0000008c7850723cULL, 0x000b6e0000041850ULL,
0x0000001003787824ULL, 0x020fe200078e021dULL, 0x0000008e843c723cULL, 0x000f62000004183cULL,
0x000000001c1c783bULL, 0x000e680000000200ULL, 0x000000007878783bULL, 0x000f260000000200ULL,
0x00000024142c723cULL, 0x044f70000004182cULL, 0x000000261434723cULL, 0x040f700000041834ULL,
0x000000101440723cULL, 0x040f700000041840ULL, 0x000000121444723cULL, 0x040f700000041844ULL,
0x000000281448723cULL, 0x040ff00000041848ULL, 0x0000002a144c723cULL, 0x000ff0000004184cULL,
0x000000106458723cULL, 0x040ff00000041858ULL, 0x00000012645c723cULL, 0x040ff0000004185cULL,
0x000000286460723cULL, 0x000ff00000041860ULL, 0x0000006a1454723cULL, 0x000ff00000041854ULL,
0x000000246430723cULL, 0x040ff00000041830ULL, 0x000000266438723cULL, 0x040ff00000041838ULL,
0x0000002a6474723cULL, 0x040ff00000041874ULL, 0x000000686480723cULL, 0x080ff00000041880ULL,
0x000000681450723cULL, 0x000ff00000041850ULL, 0x0000006a643c723cULL, 0x020ff0000004183cULL,
0x0000006c702c723cULL, 0x040f70000004182cULL, 0x0000006e7034723cULL, 0x040f700000041834ULL,
0x0000000c7040723cULL, 0x040f700000041840ULL, 0x0000000e7044723cULL, 0x000f640000041844ULL,
0x3db504f32e207820ULL, 0x020fc40000410000ULL, 0x3db504f32f217820ULL, 0x000fe40000410000ULL,
0x3db504f32c117820ULL, 0x000fe40000410000ULL, 0x3db504f32d107820ULL, 0x000fe20000410000ULL,
0x000000187048723cULL, 0x008f620000041848ULL, 0x3db504f335137820ULL, 0x000fe40000410000ULL,
0x3db504f336227820ULL, 0x000fe40000410000ULL, 0x3db504f334127820ULL, 0x000fc40000410000ULL,
0x3db504f337247820ULL, 0x000fe20000410000ULL, 0x0000001a704c723cULL, 0x000f62000004184cULL,
0x3db504f340147820ULL, 0x000fe40000410000ULL, 0x3db504f341157820ULL, 0x000fe40000410000ULL,
0x3db504f342257820ULL, 0x000fe40000410000ULL, 0x3db504f343267820ULL, 0x000fe20000410000ULL,
0x0000000c1c58723cULL, 0x002f620000041858ULL, 0x3db504f347287820ULL, 0x000fc40000410000ULL,
0x3db504f344167820ULL, 0x000fe40000410000ULL, 0x3db504f345177820ULL, 0x000fe40000410000ULL,
0x3db504f346277820ULL, 0x000fe20000410000ULL, 0x0000000e1c5c723cULL, 0x000f64000004185cULL,
0x3db504f34a2a7820ULL, 0x020fe40000410000ULL, 0x3db504f34b2e7820ULL, 0x000fe40000410000ULL,
0x3db504f348487820ULL, 0x000fc40000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x000000181c60723cULL, 0x000f620000041860ULL, 0x3db504f34e2f7820ULL, 0x000fe40000410000ULL,
0x3db504f34c4c7820ULL, 0x000fe40000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe40000410000ULL,
0x3db504f34f4f7820ULL, 0x000fe20000410000ULL, 0x0000007a7054723cULL, 0x010f620000041854ULL,
0x3db504f35a4e7820ULL, 0x000fc40000410000ULL, 0x3db504f35b5b7820ULL, 0x000fca0000410000ULL,
0x0000006c1c30723cULL, 0x000f620000041830ULL, 0x3db504f35c417820ULL, 0x000fe40000410000ULL,
0x3db504f35d427820ULL, 0x000fca0000410000ULL, 0x0000006e1c38723cULL, 0x040f640000041838ULL,
0x3db504f360437820ULL, 0x020fe40000410000ULL, 0x3db504f361447820ULL, 0x000fe40000410000ULL,
0x3db504f362407820ULL, 0x000fe40000410000ULL, 0x3db504f363637820ULL, 0x000fe20000410000ULL,
0x0000001a1c18723cULL, 0x000f620000041874ULL, 0x3db504f356367820ULL, 0x000fc40000410000ULL,
0x3db504f354547820ULL, 0x000fe40000410000ULL, 0x3db504f355557820ULL, 0x000fe40000410000ULL,
0x3db504f357577820ULL, 0x000fe20000410000ULL, 0x000000781c0c723cULL, 0x000f620000041880ULL,
0x3db504f330357820ULL, 0x000fe40000410000ULL, 0x3db504f331037820ULL, 0x000fe40000410000ULL,
0x3db504f332327820ULL, 0x000fc40000410000ULL, 0x3db504f3332b7820ULL, 0x000fe20000410000ULL,
0x000000787050723cULL, 0x000f620000041850ULL, 0x3db504f3380b7820ULL, 0x000fe40000410000ULL,
0x3db504f339297820ULL, 0x000fe40000410000ULL, 0x3db504f33a2c7820ULL, 0x000fe40000410000ULL,
0x3db504f33b2d7820ULL, 0x000fe20000410000ULL, 0x0000007a1c1c723cULL, 0x000b64000004183cULL,
0x3db504f318457820ULL, 0x020fc40000410000ULL, 0x3db504f319467820ULL, 0x000fe40000410000ULL,
0x3db504f31a307820ULL, 0x000fe40000410000ULL, 0x3db504f3583c7820ULL, 0x000fe40000410000ULL,
0x3db504f30c477820ULL, 0x000fe40000410000ULL, 0x3db504f3593f7820ULL, 0x000fe40000410000ULL,
0x3db504f35e3d7820ULL, 0x000fc40000410000ULL, 0x3db504f35f3e7820ULL, 0x000fe40000410000ULL,
0x3db504f350507820ULL, 0x000fe40000410000ULL, 0x3db504f351517820ULL, 0x000fe40000410000ULL,
0x3db504f352527820ULL, 0x000fe40000410000ULL, 0x3db504f353347820ULL, 0x000fe40000410000ULL,
0x3db504f31b377820ULL, 0x000fc40000410000ULL, 0x3db504f30d0d7820ULL, 0x000fe40000410000ULL,
0x3db504f30e0e7820ULL, 0x000fe40000410000ULL, 0x3db504f30f0f7820ULL, 0x000fe40000410000ULL,
0x3db504f31c4a7820ULL, 0x000fe40000410000ULL, 0x3db504f31d4b7820ULL, 0x000fe40000410000ULL,
0x3db504f31e0c7820ULL, 0x000fc40000410000ULL, 0x3db504f31f567820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff337224ULL, 0x000fe200078e0052ULL,
0x00000051001d7202ULL, 0x000fe20000000f00ULL, 0x00000000a0527f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1b7224ULL, 0x000fe400078e004dULL, 0x000000ffff1a7224ULL, 0x000fe200078e004cULL,
0x00000032004c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0050ULL,
0x0000000c00327202ULL, 0x000fe20000000f00ULL, 0x000000ffff317224ULL, 0x000fc400078e004fULL,
0x000000ffff3b7224ULL, 0x000fe400078e0029ULL, 0x000000ffff4d7224ULL, 0x000fe400078e002bULL,
0x000000ffff187224ULL, 0x000fe400078e0048ULL, 0x000000ffff197224ULL, 0x000fe400078e0049ULL,
0x000000ffff4f7224ULL, 0x000fe400078e002cULL, 0x000000ffff507224ULL, 0x000fc400078e002dULL,
0x000000ffff297224ULL, 0x000fe400078e0030ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0037ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0054ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0055ULL,
0x000000ffff387224ULL, 0x000fe400078e0057ULL, 0x000000ffff397224ULL, 0x000fc400078e0003ULL,
0x000000ffff3a7224ULL, 0x000fe400078e000bULL, 0x000000ffff497224ULL, 0x000fe400078e000dULL,
0x000000ffff487224ULL, 0x000fe400078e005bULL, 0x000000ffff2c7224ULL, 0x000fe400078e0063ULL,
0x000000ffff2d7224ULL, 0x000fe400078e000eULL, 0x000000ffff307224ULL, 0x000fc400078e000fULL,
0x000000ffff377224ULL, 0x000fc400078e0056ULL, 0x00000000000c7805ULL, 0x006fca0000015200ULL,
0x00000400a0037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140fULL,
0x0000000e03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x0000000203037819ULL, 0x000fc8000000120eULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400a0037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000049d0b7824ULL, 0x000fe200078e00ffULL, 0x0000009e0200720cULL, 0x000fc80003f06070ULL,
0xfffffff00b037812ULL, 0x000fca00078ec0ffULL, 0x0000008000037824ULL, 0x000fca00078e0203ULL,
0x01e40000030c7984ULL, 0x0002a20000000c00ULL, 0x000021e000008947ULL, 0x000fea0003800000ULL,
0x00005a0000517b06ULL, 0x000ee20000209000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x0000009f9d027211ULL, 0x000fe400078ff0ffULL, 0x00000023045a7217ULL, 0x000fe40007800000ULL,
0x00005a00ff5c7a12ULL, 0x000fc600078e33ffULL, 0x000000015a237824ULL, 0x000fe200078e0a23ULL,
0x0000005100517308ULL, 0x008ee40000001000ULL, 0x0ffffffe51547810ULL, 0x008fcc0007ffe0ffULL,
0x0000005400537305ULL, 0x000ee4000021f000ULL, 0x000000ffff557224ULL, 0x008fc800078e0a53ULL,
0x00005a0055557a24ULL, 0x000fc800078e02ffULL, 0x00000055535d7227ULL, 0x000fe200078e0052ULL,
0x0000000802527810ULL, 0x040fe40007ffe0ffULL, 0x0000001002557810ULL, 0x000fc60007ffe0ffULL,
0x000000025d517227ULL, 0x000fc800078e00ffULL, 0x000000525d537227ULL, 0x000fe200078e00ffULL,
0x000000ff51597210ULL, 0x000fc60007ffe1ffULL, 0x000000ffff5b7224ULL, 0x000fe400078e0a53ULL,
0x000000555d577227ULL, 0x000fc800078e00ffULL, 0x00005a005b547a24ULL, 0x000fe400078e0252ULL,
0x00005a0059527a24ULL, 0x000fe200078e0202ULL, 0x0000001802027810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff567224ULL, 0x000fe200078e0a57ULL, 0x00005a0054007a0cULL, 0x000fe40003fa6070ULL,
0x00005a0052007a0cULL, 0x000fe20003f06070ULL, 0x000000025d587227ULL, 0x000fc800078e00ffULL,
0x00005a0056557a24ULL, 0x000fe400078e0255ULL, 0x000000ffff597224ULL, 0x000fc600078e0a58ULL,
0x00005a0055007a0cULL, 0x000fe20003f26070ULL, 0x00005a0059567a24ULL, 0x000fe200078e0202ULL,
0x80005a0054545a10ULL, 0x000fe20007ffe0ffULL, 0x000000029d027824ULL, 0x000fe200078e00ffULL,
0x80005a0052520a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0056007a0cULL, 0x000fe40003f66070ULL,
0x00005a0052007a0cULL, 0x000fe40003f46070ULL, 0x0000000602027812ULL, 0x000fc400078ec0ffULL,
0x00005a0054007a0cULL, 0x000fe40003fc6070ULL, 0x80005a0055551a10ULL, 0x000fe20007ffe0ffULL,
0x00000001025a7824ULL, 0x000fe200078e020aULL, 0x0000000151510810ULL, 0x000fe20007ffe0ffULL,
0x0000000198547824ULL, 0x000fe200078e0202ULL, 0x0000000153535810ULL, 0x000fe20007ffe0ffULL,
0x000000015a527824ULL, 0x000fe200078e0a23ULL, 0x00005a0055007a0cULL, 0x000fe40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fc40003fa5070ULL, 0x0000000151512810ULL, 0x000fe40007ffe0ffULL,
0x000000235400720cULL, 0x040fe20003f06070ULL, 0x0000000154547824ULL, 0x000fe200078e0a23ULL,
0x80005a0056563a10ULL, 0x000fe40007ffe0ffULL, 0x0000005299697217ULL, 0x000fe40003800000ULL,
0x000000515c527207ULL, 0x000fe40006800000ULL, 0x00005a0056007a0cULL, 0x000fc40003f46070ULL,
0x0000000153536810ULL, 0x000fe40007ffe0ffULL, 0x0000005499547217ULL, 0x040fe40003800000ULL,
0x0000005299517217ULL, 0x000fe40003800000ULL, 0x0000000157571810ULL, 0x000fe40007ffe0ffULL,
0x000000235a00720cULL, 0x000fe20003fc6070ULL, 0x000000519c807224ULL, 0x000fe200078e02ffULL,
0x000000535c567207ULL, 0x000fc40006800000ULL, 0x00000004ff547819ULL, 0x000fe40000011654ULL,
0x0000000157574810ULL, 0x000fe40007ffe0ffULL, 0x000000ff69697207ULL, 0x000fe40003000000ULL,
0x0000000158583810ULL, 0x000fe40007ffe0ffULL, 0x0000005699537217ULL, 0x000fe40003800000ULL,
0x000000ff54557207ULL, 0x000fc40000000000ULL, 0x000000575c547207ULL, 0x000fe20006800000ULL,
0x000000539c847224ULL, 0x000fe200078e02ffULL, 0x0000000158582810ULL, 0x000fe20007ffe0ffULL,
0x0000000180537824ULL, 0x000fe200078e0255ULL, 0x00000080695d7211ULL, 0x000fe400078fe0ffULL,
0x0000005499597217ULL, 0x000fe20003800000ULL, 0x0000000253527825ULL, 0x100fe200078e009aULL,
0x000000585c587207ULL, 0x000fe40006800000ULL, 0x0000008455577210ULL, 0x000fe20007ffe0ffULL,
0x000000025d5c7825ULL, 0x100fe200078e009aULL, 0x00000058995b7217ULL, 0x000fe20003800000ULL,
0x0000000652517981ULL, 0x000724000c1e9500ULL, 0x000000599c867224ULL, 0x000fe200078e02ffULL,
0x0000001002687812ULL, 0x000fe200078efcffULL, 0x000000065c5c7981ULL, 0x000322000c1e9500ULL,
0x0000000257567825ULL, 0x000fe200078e009aULL, 0x0000008469597211ULL, 0x000fc400078fe0ffULL,
0x0000008669617211ULL, 0x000fe200078fe0ffULL, 0x0000005b9c887224ULL, 0x000fe400078e02ffULL,
0x00000001555f7824ULL, 0x040fe200078e0286ULL, 0x00000006565b7981ULL, 0x000522000c1e9500ULL,
0x0000000198627824ULL, 0x000fe400078e0268ULL, 0x0000000155637824ULL, 0x000fe400078e0288ULL,
0x0000000261607825ULL, 0x000fc800078e009aULL, 0x0000000259547825ULL, 0x100fe400078e009aULL,
0x0000000660607981ULL, 0x000324000c1e9500ULL, 0x000000025f527825ULL, 0x008fe400078e009aULL,
0x00000006545e7981ULL, 0x000724000c1e9500ULL, 0x0000000162567824ULL, 0x104fe400078e0a23ULL,
0x0000000168667824ULL, 0x000fe200078e020aULL, 0x00000006525d7981ULL, 0x0022a4000c1e9500ULL,
0x0000005699577217ULL, 0x000fe20003800000ULL, 0x0000000166567824ULL, 0x000fe200078e0a23ULL,
0x00000088696b7211ULL, 0x000fc400078fe0ffULL, 0x000000236200720cULL, 0x080fe40003f26070ULL,
0x00000004ff577819ULL, 0x000fe20000011657ULL, 0x000000026b6a7825ULL, 0x100fe200078e009aULL,
0x000000236600720cULL, 0x000fe40003f06070ULL, 0x0000005699567217ULL, 0x000fe20003800000ULL,
0x0000000263587825ULL, 0x000fe200078e009aULL, 0x000000ff57577207ULL, 0x000fe20000800000ULL,
0x000000066a6a7981ULL, 0x0002a2000c1e9500ULL, 0x000000ff56737207ULL, 0x000fc40000000000ULL,
0x0000002002727812ULL, 0x000fe200078efcffULL, 0x00000006585f7981ULL, 0x0002a2000c1e9500ULL,
0x0000000157557824ULL, 0x008fe200078e0284ULL, 0x00000080736d7211ULL, 0x040fe400078fe0ffULL,
0x00000084736f7211ULL, 0x000fe200078fe0ffULL, 0x0000000180537824ULL, 0x002fe400078e0257ULL,
0x0000000255547825ULL, 0x000fc800078e009aULL, 0x0000000198587824ULL, 0x000fe200078e0272ULL,
0x0000000654677981ULL, 0x0002e2000c1e9500ULL, 0x000000026d6c7825ULL, 0x000fc800078e009aULL,
0x000000026f6e7825ULL, 0x100fe200078e009aULL, 0x0000008873777211ULL, 0x080fe200078fe0ffULL,
0x000000066c6c7981ULL, 0x0002e4000c1e9500ULL, 0x0000000253527825ULL, 0x000fe200078e009aULL,
0x0000008857637210ULL, 0x000fe20007ffe0ffULL, 0x000000066e6e7981ULL, 0x0002e4000c1e9500ULL,
0x0000000158547824ULL, 0x002fe400078e0a23ULL, 0x0000000172747824ULL, 0x000fe200078e020aULL,
0x0000000652617981ULL, 0x0002e2000c1e9500ULL, 0x0000008673717211ULL, 0x000fc400078fe0ffULL,
0x0000005499557217ULL, 0x000fe20003800000ULL, 0x0000000174547824ULL, 0x000fe400078e0a23ULL,
0x0000000157597824ULL, 0x000fe400078e0286ULL, 0x0000000277767825ULL, 0x000fe200078e009aULL,
0x000000235800720cULL, 0x000fc60003f26070ULL, 0x0000000263527825ULL, 0x002fe200078e009aULL,
0x000000237400720cULL, 0x000fe20003f06070ULL, 0x0000000676767981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff557819ULL, 0x000fe20000011655ULL, 0x0000000271707825ULL, 0x100fe200078e009aULL,
0x0000005499547217ULL, 0x000fe20003800000ULL, 0x00000006526d7981ULL, 0x0002e4000c1e9500ULL,
0x0000000259567825ULL, 0x000fe400078e009aULL, 0x0000000670707981ULL, 0x0002e4000c1e9500ULL,
0x000000ff54777207ULL, 0x002fc40000000000ULL, 0x00000006566b7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff55537207ULL, 0x000fe40000800000ULL, 0x0000008477637211ULL, 0x000fc600078fe0ffULL,
0x0000000153657824ULL, 0x000fe400078e0284ULL, 0x0000000263627825ULL, 0x000fc800078e009aULL,
0x0000000265647825ULL, 0x000fe200078e009aULL, 0x00000006627a7981ULL, 0x0002e6000c1e9500ULL,
0x0000000180557824ULL, 0x000fe200078e0253ULL, 0x0000000664717981ULL, 0x0002e2000c1e9500ULL,
0x00000030027c7812ULL, 0x000fe400078efcffULL, 0x0000008077797211ULL, 0x000fe200078fe0ffULL,
0x0000000255547825ULL, 0x000fe200078e009aULL, 0x0000008677577211ULL, 0x002fc400078fe0ffULL,
0x0000008877757211ULL, 0x000fe200078fe0ffULL, 0x0000000153597824ULL, 0x040fe200078e0286ULL,
0x00000006546f7981ULL, 0x0002e2000c1e9500ULL, 0x00000001537b7824ULL, 0x000fe400078e0288ULL,
0x0000000198827824ULL, 0x000fe400078e027cULL, 0x0000000279787825ULL, 0x000fc800078e009aULL,
0x0000000257527825ULL, 0x100fe200078e009aULL, 0x0000008223647210ULL, 0x000fe20007ffe1ffULL,
0x0000000678787981ULL, 0x0002e4000c1e9500ULL, 0x0000000259587825ULL, 0x100fe400078e009aULL,
0x0000000652d67981ULL, 0x0002e4000c1e9500ULL, 0x000000027b547825ULL, 0x002fc800078e009aULL,
0x0000000275567825ULL, 0x000fe200078e009aULL, 0x0000000654857981ULL, 0x0002e6000c1e9500ULL,
0x000000017c7e7824ULL, 0x000fe200078e020aULL, 0x0000000658757981ULL, 0x0002e2000c1e9500ULL,
0x0000006499657217ULL, 0x000fc60003800000ULL, 0x0000000656da7981ULL, 0x0002e2000c1e9500ULL,
0x000000017e647824ULL, 0x000fe200078e0a23ULL, 0x000000238200720cULL, 0x080fe40003f26070ULL,
0x000000237e00720cULL, 0x000fe40003f06070ULL, 0x00000004ff657819ULL, 0x000fe40000011665ULL,
0x0000006499647217ULL, 0x000fe40003800000ULL, 0x000000ff657b7207ULL, 0x000fc40000800000ULL,
0x000000ff64797207ULL, 0x000fc60000000000ULL, 0x0000000180637824ULL, 0x000fe200078e027bULL,
0x0000008079657211ULL, 0x000fe200078fe0ffULL, 0x000000017b577824ULL, 0x002fe200078e0286ULL,
0x0000008679597211ULL, 0x000fe200078fe0ffULL, 0x0000000263627825ULL, 0x000fc800078e009aULL,
0x0000000265647825ULL, 0x100fe200078e009aULL, 0x00000006627d7981ULL, 0x0002e6000c1e9500ULL,
0x0000000257567825ULL, 0x100fe200078e009aULL, 0x0000000664be7981ULL, 0x0002e6000c1e9500ULL,
0x0000000259587825ULL, 0x000fe200078e009aULL, 0x0000000656837981ULL, 0x0002e2000c1e9500ULL,
0x0000008479557211ULL, 0x000fc600078fe0ffULL, 0x0000000658d87981ULL, 0x0002e2000c1e9500ULL,
0x000000017b537824ULL, 0x000fe400078e0284ULL, 0x0000000255547825ULL, 0x000fc800078e009aULL,
0x0000000253527825ULL, 0x000fe200078e009aULL, 0x0000000654d47981ULL, 0x0002e4000c1e9500ULL,
0x0000008879637211ULL, 0x002fe400078fe0ffULL, 0x0000000652817981ULL, 0x0002e2000c1e9500ULL,
0x000000017b657824ULL, 0x000fe400078e0288ULL, 0x0000000263627825ULL, 0x000fc800078e009aULL,
0x0000000265647825ULL, 0x000fe200078e009aULL, 0x0000000662dc7981ULL, 0x0002e8000c1e9500ULL,
0x0000000664877981ULL, 0x0002e4000c1e9500ULL, 0xfffffff069527812ULL, 0x002fc800078ec0ffULL,
0x0000005223537210ULL, 0x000fe20007ffe0ffULL, 0x00000001ffd27424ULL, 0x000fc800078e00ffULL,
0x000000015a527824ULL, 0x000fe200078e0a53ULL, 0x0000000102807812ULL, 0x000fc800078efcffULL,
0x00000052d2527219ULL, 0x000fe200000006ffULL, 0x0000000180547824ULL, 0x000fe200078e020aULL,
0xfffffff073567812ULL, 0x000fc600078ec0ffULL, 0x0000000154557824ULL, 0x100fe200078e0a53ULL,
0x0000000802827812ULL, 0x040fe200078efcffULL, 0x0000000123597824ULL, 0x000fe200078e0256ULL,
0x0000000902847812ULL, 0x000fe400078efcffULL, 0x00000055d2567219ULL, 0x000fe200000006ffULL,
0x0000000182587824ULL, 0x000fe200078e020aULL, 0x0000000a84647210ULL, 0x000fe40007ffe0ffULL,
0xfffffff077627812ULL, 0x000fe200078ec0ffULL, 0x0000000158577824ULL, 0x100fe200078e0a53ULL,
0xfffffff079867812ULL, 0x000fe200078ec0ffULL, 0x0000000164537824ULL, 0x000fe200078e0a53ULL,
0x00000011028a7812ULL, 0x000fe200078efcffULL, 0x0000000123637824ULL, 0x040fe200078e0262ULL,
0x00000057d2627219ULL, 0x040fe200000006ffULL, 0x0000000123777824ULL, 0x000fe200078e0286ULL,
0x00000053d2867219ULL, 0x000fe200000006ffULL, 0x000000018a8c7824ULL, 0x000fc400078e020aULL,
0x0000000166537824ULL, 0x100fe400078e0a59ULL, 0x000000018c557824ULL, 0x000fe200078e0a59ULL,
0x0000001802927812ULL, 0x000fe400078efcffULL, 0x000054105c517816ULL, 0x010fc80000000051ULL,
0x0000005152ff7212ULL, 0x000fc800078ac0ffULL, 0x000000235a00720cULL, 0x000fc80002fa1470ULL,
0x000000230200720cULL, 0x000fe40002fa1070ULL, 0x0000005156ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x000054105e5b7816ULL, 0x000fe4000000005bULL,
0x00005410605d7816ULL, 0x004fe4000000005dULL, 0x0000005b52ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005d52ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005b56ff7212ULL, 0x000fe400078ac0ffULL,
0x000000235a00720cULL, 0x0c0fe40001741470ULL, 0x000000235a00720cULL, 0x080fe40002781470ULL,
0x000000235400720cULL, 0x0c0fe40000f21470ULL, 0x000000235400720cULL, 0x000fc40002fa1470ULL,
0x000000230200720cULL, 0x0c0fe40001741070ULL, 0x000000230200720cULL, 0x080fe40002781070ULL,
0x000000238000720cULL, 0x0c0fe40000f21070ULL, 0x000000238000720cULL, 0x000fe40002fa1070ULL,
0x000054106a5f7816ULL, 0x000fe4000000005fULL, 0xff80000020207808ULL, 0x000fc40001000000ULL,
0xff80000035357808ULL, 0x000fe40002000000ULL, 0xff80000010107808ULL, 0x000fe40000800000ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0x0000005162ff7212ULL, 0x000fe4000786c0ffULL,
0x0000005f52ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005d56ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005f56ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005b86ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005d62ff7212ULL, 0x000fe400078ac0ffULL, 0x000000235a00720cULL, 0x080fe40000701470ULL,
0x000000235400720cULL, 0x0c0fe40001741470ULL, 0x000000235400720cULL, 0x000fc40002781470ULL,
0x000000235800720cULL, 0x0c0fe40001f61470ULL, 0x000000235800720cULL, 0x080fe40002fa1470ULL,
0x000000236400720cULL, 0x080fe40000f21470ULL, 0x0000001902a47812ULL, 0x040fe400078efcffULL,
0x000000230200720cULL, 0x080fe40000701070ULL, 0x000000238000720cULL, 0x000fc40001741070ULL,
0x000000238000720cULL, 0x080fe40002781070ULL, 0x000000238200720cULL, 0x0c0fe40001f61070ULL,
0x000000238200720cULL, 0x080fe40002fa1070ULL, 0x000000238400720cULL, 0x000fe40000f21070ULL,
0x00000053d2887219ULL, 0x040fe400000006ffULL, 0x00000055d28e7219ULL, 0x000fc400000006ffULL,
0x000054106c617816ULL, 0x008fe40000000061ULL, 0x000054106e677816ULL, 0x000fe20000000067ULL,
0x0000000192947824ULL, 0x100fe200078e020aULL, 0xff8000004c4c7808ULL, 0x000fe20000000000ULL,
0x00000001a4a67824ULL, 0x000fe200078e020aULL, 0xff80000039397808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff80000012127808ULL, 0x000fc40001800000ULL,
0xff8000003a3a7808ULL, 0x000fe40002800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0x0000005b62ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005d86ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005f62ff7212ULL, 0x080fe4000788c0ffULL, 0x0000005f86ff7212ULL, 0x000fc4000786c0ffULL,
0x000000618eff7212ULL, 0x000fe400078ac0ffULL, 0x0000006788ff7212ULL, 0x000fe4000782c0ffULL,
0x0000009459577210ULL, 0x000fe20007ffe1ffULL, 0x00000001a6597824ULL, 0x000fe200078e0a59ULL,
0x000000235800720cULL, 0x0c0fe40000701470ULL, 0x000000235800720cULL, 0x080fe40002781470ULL,
0x000000236400720cULL, 0x000fc40001741470ULL, 0x000000236400720cULL, 0x080fe40001f61470ULL,
0x000000236600720cULL, 0x080fe40000f21470ULL, 0x000000238c00720cULL, 0x080fe40002fa1470ULL,
0x000000238200720cULL, 0x0c0fe40000701070ULL, 0x000000238200720cULL, 0x080fe40002781070ULL,
0x000000238400720cULL, 0x000fc40001741070ULL, 0x000000238400720cULL, 0x080fe40001f61070ULL,
0x000000236800720cULL, 0x080fe40000f21070ULL, 0x000000238a00720cULL, 0x000fe40002fa1070ULL,
0x00000057d2967219ULL, 0x040fe400000006ffULL, 0x00000059d2a87219ULL, 0x000fe400000006ffULL,
0x00005410706b7816ULL, 0x000fc4000000006bULL, 0x00005410766d7816ULL, 0x000fe4000000006dULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0xff8000004f4f7808ULL, 0x000fe40002000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001000000ULL, 0xff80000050507808ULL, 0x000fe40001800000ULL,
0xff80000025257808ULL, 0x000fc40000800000ULL, 0xff80000015157808ULL, 0x000fe40002800000ULL,
0x0000006188ff7212ULL, 0x080fe4000780c0ffULL, 0x0000006196ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006b88ff7212ULL, 0x040fe4000784c0ffULL, 0x0000006d88ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006b8eff7212ULL, 0x000fc4000782c0ffULL, 0x00000067a8ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000174657824ULL, 0x000fe200078e0a63ULL, 0x000000236600720cULL, 0x0c0fe40000701470ULL,
0x000000236600720cULL, 0x0c0fe40001741470ULL, 0x000000236600720cULL, 0x080fe40001f61470ULL,
0x000000238c00720cULL, 0x080fe40000f21470ULL, 0x000000239400720cULL, 0x000fc40002781470ULL,
0x00000023a600720cULL, 0x080fe40002fa1470ULL, 0x0000002102ac7812ULL, 0x000fe400078efcffULL,
0x000000236800720cULL, 0x0c0fe40000701070ULL, 0x000000236800720cULL, 0x0c0fe40001741070ULL,
0x000000236800720cULL, 0x080fe40001f61070ULL, 0x000000238a00720cULL, 0x000fc40000f21070ULL,
0x000000239200720cULL, 0x080fe40002781070ULL, 0x00000023a400720cULL, 0x000fe40002fa1070ULL,
0x00000065d2aa7219ULL, 0x000fe400000006ffULL, 0x000054107a717816ULL, 0x000fe20000000071ULL,
0x00000001acae7824ULL, 0x000fe200078e020aULL, 0xff80000014147808ULL, 0x000fe40000000000ULL,
0xff8000003c3c7808ULL, 0x000fc40001000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff80000016167808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x000000678eff7212ULL, 0x040fe4000780c0ffULL,
0x0000006d8eff7212ULL, 0x000fc4000784c0ffULL, 0x0000006796ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006ba8ff7212ULL, 0x040fe4000782c0ffULL, 0x0000006da8ff7212ULL, 0x000fe4000788c0ffULL,
0x00000071aaff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ae697824ULL, 0x000fe200078e0a63ULL,
0x000000238c00720cULL, 0x0c0fe40000701470ULL, 0x000000238c00720cULL, 0x000fc40001741470ULL,
0x000000239400720cULL, 0x080fe40001f61470ULL, 0x00000023a600720cULL, 0x0c0fe40000f21470ULL,
0x00000023a600720cULL, 0x080fe40002781470ULL, 0x000000237400720cULL, 0x000fe40002fa1470ULL,
0x0000002802b27812ULL, 0x040fe400078efcffULL, 0x0000002902b87812ULL, 0x000fc400078efcffULL,
0x000000238a00720cULL, 0x0c0fe40000701070ULL, 0x000000238a00720cULL, 0x080fe40001741070ULL,
0x000000239200720cULL, 0x080fe40001f61070ULL, 0x00000023a400720cULL, 0x0c0fe40000f21070ULL,
0x00000023a400720cULL, 0x080fe40002781070ULL, 0x000000237200720cULL, 0x000fc40002fa1070ULL,
0x00000069d2b07219ULL, 0x000fe400000006ffULL, 0x00005410786f7816ULL, 0x000fe4000000006fULL,
0x00005410d6757816ULL, 0x000fe40000000075ULL, 0x00005410da857816ULL, 0x000fe20000000085ULL,
0x00000001b2b47824ULL, 0x100fe200078e020aULL, 0xff80000026267808ULL, 0x000fe20000000000ULL,
0x00000001b8ba7824ULL, 0x000fe200078e020aULL, 0xff80000048487808ULL, 0x000fc40001000000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000042427808ULL, 0x000fe40000800000ULL,
0xff8000003e3e7808ULL, 0x000fe40002000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002800000ULL,
0x0000005186ff7212ULL, 0x000fe400078cc0ffULL, 0x0000006b96ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006d96ff7212ULL, 0x000fe4000784c0ffULL, 0x0000006faaff7212ULL, 0x040fe4000786c0ffULL,
0x00000075aaff7212ULL, 0x040fe4000782c0ffULL, 0x00000085aaff7212ULL, 0x000fe4000788c0ffULL,
0x00000075b0ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b4737824ULL, 0x100fe200078e0a63ULL,
0x000000236400720cULL, 0x080fe200037c1470ULL, 0x00000001ba637824ULL, 0x000fe200078e0a63ULL,
0x000000239400720cULL, 0x000fc40000701470ULL, 0x000000239400720cULL, 0x080fe40001741470ULL,
0x000000237400720cULL, 0x0c0fe40001f61470ULL, 0x000000237400720cULL, 0x0c0fe40000f21470ULL,
0x000000237400720cULL, 0x080fe40002781470ULL, 0x00000023ae00720cULL, 0x080fe40002fa1470ULL,
0x000000238400720cULL, 0x000fc400037c1070ULL, 0x000000239200720cULL, 0x0c0fe40000701070ULL,
0x000000239200720cULL, 0x080fe40001741070ULL, 0x000000237200720cULL, 0x0c0fe40001f61070ULL,
0x000000237200720cULL, 0x0c0fe40000f21070ULL, 0x000000237200720cULL, 0x080fe40002781070ULL,
0x00000023ac00720cULL, 0x000fc40002fa1070ULL, 0x00000073d2b67219ULL, 0x040fe400000006ffULL,
0x00000063d2bc7219ULL, 0x000fe400000006ffULL, 0xff80000013137808ULL, 0x000fe40003000000ULL,
0xff80000041417808ULL, 0x000fe40000000000ULL, 0xff8000003d3d7808ULL, 0x000fe40001000000ULL,
0xff80000018187808ULL, 0x000fc40001800000ULL, 0xff80000043437808ULL, 0x000fe40000800000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0xff80000044447808ULL, 0x000fe40002800000ULL,
0x00000061a8ff7212ULL, 0x000fe400078cc0ffULL, 0x0000006fb0ff7212ULL, 0x080fe4000780c0ffULL,
0x0000006fb6ff7212ULL, 0x000fc4000784c0ffULL, 0x00000071b0ff7212ULL, 0x040fe4000786c0ffULL,
0x00000085b0ff7212ULL, 0x000fe4000782c0ffULL, 0x00000071b6ff7212ULL, 0x000fe4000788c0ffULL,
0x00000075bcff7212ULL, 0x000fe200078ac0ffULL, 0x000000017e797824ULL, 0x000fe200078e0a77ULL,
0x00000023a600720cULL, 0x080fe400037c1470ULL, 0x00000023ae00720cULL, 0x000fc40000701470ULL,
0x00000023ae00720cULL, 0x0c0fe40001f61470ULL, 0x00000023ae00720cULL, 0x080fe40000f21470ULL,
0x00000023b400720cULL, 0x0c0fe40001741470ULL, 0x00000023b400720cULL, 0x080fe40002781470ULL,
0x00000023ba00720cULL, 0x000fe40002fa1470ULL, 0x0000003102c27812ULL, 0x000fc400078efcffULL,
0x0000003802c87812ULL, 0x040fe400078efcffULL, 0x0000003902ce7812ULL, 0x000fe400078efcffULL,
0x00000023a400720cULL, 0x080fe400037c1070ULL, 0x00000023ac00720cULL, 0x0c0fe40000701070ULL,
0x00000023ac00720cULL, 0x0c0fe40001f61070ULL, 0x00000023ac00720cULL, 0x000fc40000f21070ULL,
0x00000023b200720cULL, 0x0c0fe40001741070ULL, 0x00000023b200720cULL, 0x080fe40002781070ULL,
0x00000023b800720cULL, 0x000fe40002fa1070ULL, 0x00000079d2c07219ULL, 0x000fe400000006ffULL,
0x00005410be7d7816ULL, 0x000fe4000000007dULL, 0x00005410d8837816ULL, 0x000fe20000000083ULL,
0x00000001c2c47824ULL, 0x100fe200078e020aULL, 0xff80000017177808ULL, 0x000fe20003000000ULL,
0x00000001c8ca7824ULL, 0x100fe200078e020aULL, 0xff80000019197808ULL, 0x000fe20000000000ULL,
0x00000001ced07824ULL, 0x000fe200078e020aULL, 0xff8000002e2e7808ULL, 0x000fc40001800000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fe40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fe40002800000ULL,
0x0000006fbcff7212ULL, 0x040fe400078cc0ffULL, 0x00000071bcff7212ULL, 0x000fc4000780c0ffULL,
0x00000075b6ff7212ULL, 0x040fe4000786c0ffULL, 0x00000085b6ff7212ULL, 0x080fe4000782c0ffULL,
0x00000085bcff7212ULL, 0x000fe4000784c0ffULL, 0x0000007dc0ff7212ULL, 0x040fe4000788c0ffULL,
0x00000083c0ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c47b7824ULL, 0x100fe200078e0a77ULL,
0x00000023b400720cULL, 0x080fe20001f61470ULL, 0x00000001ca7f7824ULL, 0x100fe200078e0a77ULL,
0x00000023b400720cULL, 0x080fe20000f21470ULL, 0x00000001d0777824ULL, 0x000fe200078e0a77ULL,
0x00000023ba00720cULL, 0x000fc400037c1470ULL, 0x00000023ba00720cULL, 0x0c0fe40000701470ULL,
0x00000023ba00720cULL, 0x080fe40001741470ULL, 0x000000237e00720cULL, 0x0c0fe40002781470ULL,
0x000000237e00720cULL, 0x000fe40002fa1470ULL, 0x0000007bd2c67219ULL, 0x040fe400000006ffULL,
0x0000007fd2cc7219ULL, 0x000fc400000006ffULL, 0x00000023b200720cULL, 0x0c0fe40001f61070ULL,
0x00000023b200720cULL, 0x080fe40000f21070ULL, 0x00000023b800720cULL, 0x0c0fe400037c1070ULL,
0x00000023b800720cULL, 0x0c0fe40000701070ULL, 0x00000023b800720cULL, 0x080fe40001741070ULL,
0x000000237c00720cULL, 0x000fc40002781070ULL, 0x000000237c00720cULL, 0x000fe40002fa1070ULL,
0x00000077d2d27219ULL, 0x000fe400000006ffULL, 0x00005410d4817816ULL, 0x000fe40000000081ULL,
0xff80000045457808ULL, 0x000fe40001800000ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff8000001b1b7808ULL, 0x000fc40003000000ULL, 0xff80000031317808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002000000ULL,
0xff80000047477808ULL, 0x000fe40002800000ULL, 0x0000007dc6ff7212ULL, 0x080fe4000786c0ffULL,
0x0000007dccff7212ULL, 0x000fc4000782c0ffULL, 0x0000007dd2ff7212ULL, 0x000fe400078cc0ffULL,
0x00000081c0ff7212ULL, 0x080fe4000780c0ffULL, 0x00000081c6ff7212ULL, 0x080fe4000784c0ffULL,
0x00000081ccff7212ULL, 0x000fe4000788c0ffULL, 0x00000083c6ff7212ULL, 0x000fe400078ac0ffULL,
0x000000237e00720cULL, 0x000fc40000701470ULL, 0x00000023c400720cULL, 0x0c0fe40001f61470ULL,
0x00000023c400720cULL, 0x0c0fe40001741470ULL, 0x00000023c400720cULL, 0x080fe40002fa1470ULL,
0x00000023ca00720cULL, 0x080fe40000f21470ULL, 0x00000023d000720cULL, 0x080fe400037c1470ULL,
0x00000023ca00720cULL, 0x000fc40002781470ULL, 0x000000237c00720cULL, 0x080fe40000701070ULL,
0x00000023c200720cULL, 0x0c0fe40001f61070ULL, 0x00000023c200720cULL, 0x0c0fe40001741070ULL,
0x00000023c200720cULL, 0x080fe40002fa1070ULL, 0x00000023c800720cULL, 0x080fe40000f21070ULL,
0x00000023ce00720cULL, 0x000fc400037c1070ULL, 0x00000023c800720cULL, 0x000fe40002781070ULL,
0x00005410dc877816ULL, 0x000fe40000000087ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff8000001d1d7808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000049497808ULL, 0x000fc40002800000ULL, 0xff8000001e1e7808ULL, 0x000fe40000800000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40002000000ULL,
0x00000081d2ff7212ULL, 0x000fe4000780c0ffULL, 0x00000083ccff7212ULL, 0x080fe4000786c0ffULL,
0x00000083d2ff7212ULL, 0x000fc4000784c0ffULL, 0x00000087c0ff7212ULL, 0x080fe400078ac0ffULL,
0x00000087c6ff7212ULL, 0x080fe4000782c0ffULL, 0x00000087ccff7212ULL, 0x080fe400078cc0ffULL,
0x00000087d2ff7212ULL, 0x000fe4000788c0ffULL, 0x000000237e00720cULL, 0x080fe40002fa1470ULL,
0x00000023c400720cULL, 0x000fc40000f21470ULL, 0x00000023ca00720cULL, 0x0c0fe40001f61470ULL,
0x00000023ca00720cULL, 0x080fe400037c1470ULL, 0x00000023d000720cULL, 0x0c0fe40000701470ULL,
0x00000023d000720cULL, 0x0c0fe40001741470ULL, 0x00000023d000720cULL, 0x080fe40002781470ULL,
0x000000237c00720cULL, 0x000fc40002fa1070ULL, 0x00000023c200720cULL, 0x080fe40000f21070ULL,
0x00000023ce00720cULL, 0x080fe40000701070ULL, 0x00000023c800720cULL, 0x0c0fe40001f61070ULL,
0x00000023c800720cULL, 0x080fe400037c1070ULL, 0x00000023ce00720cULL, 0x0c0fe40001741070ULL,
0x00000023ce00720cULL, 0x000fc40002781070ULL, 0xff80000038387808ULL, 0x000fe40000000000ULL,
0xff8000004a4a7808ULL, 0x000fe40001800000ULL, 0xff8000004b4b7808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000032327808ULL, 0x000fc40003000000ULL, 0xff80000037377808ULL, 0x000fc40002000000ULL,
0x000000110c00720bULL, 0x004fe40003f1e000ULL, 0x000000200d00720bULL, 0x000fe40003f3e000ULL,
0x000000350e00720bULL, 0x000fe40003f5e000ULL, 0x0000004c0f00720bULL, 0x000fe40003f7e000ULL,
0x0000000c11237208ULL, 0x000fe40004000000ULL, 0x0000000d20027208ULL, 0x000fc40004800000ULL,
0x0000000e350e7208ULL, 0x000fe40005000000ULL, 0x0000000f4c0c7208ULL, 0x000fe40005800000ULL,
0x000000102300720bULL, 0x000fe40003f1e000ULL, 0x000000210200720bULL, 0x000fe40003f3e000ULL,
0x000000390e00720bULL, 0x000fe40003f5e000ULL, 0x0000004d0c00720bULL, 0x000fc40003f7e000ULL,
0x0000002310237208ULL, 0x000fe40004000000ULL, 0x00000002210d7208ULL, 0x000fe40004800000ULL,
0x0000000e390f7208ULL, 0x000fe40005000000ULL, 0x0000000c4d0c7208ULL, 0x000fe40005800000ULL,
0x000000122300720bULL, 0x000fe40003f1e000ULL, 0x000000220d00720bULL, 0x000fc40003f3e000ULL,
0x0000003a0f00720bULL, 0x000fe40003f5e000ULL, 0x0000004f0c00720bULL, 0x000fe40003f7e000ULL,
0x0000002312027208ULL, 0x000fe40004000000ULL, 0x0000000d220d7208ULL, 0x000fe40004800000ULL,
0x0000000f3a0e7208ULL, 0x000fe40005000000ULL, 0x0000000c4f0f7208ULL, 0x000fc40005800000ULL,
0x000000130200720bULL, 0x000fe40003f1e000ULL, 0x000000240d00720bULL, 0x000fe40003f3e000ULL,
0x0000003b0e00720bULL, 0x000fe40003f5e000ULL, 0x000000500f00720bULL, 0x000fe40003f7e000ULL,
0x0000000213237208ULL, 0x000fe40004000000ULL, 0x0000000d24027208ULL, 0x000fc40004800000ULL,
0x0000000e3b0d7208ULL, 0x000fe40005000000ULL, 0x0000000f500f7208ULL, 0x000fe40005800000ULL,
0x000000142300720bULL, 0x000fe40003f1e000ULL, 0x000000250200720bULL, 0x000fe40003f3e000ULL,
0x0000003c0d00720bULL, 0x000fe40003f5e000ULL, 0x0000004e0f00720bULL, 0x000fc40003f7e000ULL,
0x00000023140c7208ULL, 0x000fe40004000000ULL, 0x0000000225237208ULL, 0x000fe40004800000ULL,
0x0000000d3c027208ULL, 0x000fe40005000000ULL, 0x0000000f4e0f7208ULL, 0x000fe40005800000ULL,
0x000000150c00720bULL, 0x000fe40003f1e000ULL, 0x000000262300720bULL, 0x000fc40003f3e000ULL,
0x0000003f0200720bULL, 0x000fe40003f5e000ULL, 0x000000480f00720bULL, 0x000fe40003f7e000ULL,
0x0000000c150d7208ULL, 0x000fe40004000000ULL, 0x00000023260c7208ULL, 0x000fe40004800000ULL,
0x000000023f027208ULL, 0x000fe40005000000ULL, 0x0000000f480e7208ULL, 0x000fc40005800000ULL,
0x000000160d00720bULL, 0x000fe40003f1e000ULL, 0x000000270c00720bULL, 0x000fe40003f3e000ULL,
0x000000410200720bULL, 0x000fe40003f5e000ULL, 0x0000003d0e00720bULL, 0x000fe40003f7e000ULL,
0x0000000d16527208ULL, 0x000fe40004000000ULL, 0x0000000c270d7208ULL, 0x000fc40004800000ULL,
0x00000002410f7208ULL, 0x000fe40005000000ULL, 0x0000000e3d237208ULL, 0x000fe40005800000ULL,
0x000000175200720bULL, 0x000fe40003f1e000ULL, 0x000000280d00720bULL, 0x000fe40003f3e000ULL,
0x000000420f00720bULL, 0x000fe40003f5e000ULL, 0x0000003e2300720bULL, 0x000fc40003f7e000ULL,
0x0000005217517208ULL, 0x000fe40004000000ULL, 0x0000000d280d7208ULL, 0x000fe40004800000ULL,
0x0000000f42027208ULL, 0x000fe40005000000ULL, 0x000000233e237208ULL, 0x000fe40005800000ULL,
0x000000185100720bULL, 0x000fe40003f1e000ULL, 0x0000002a0d00720bULL, 0x000fc40003f3e000ULL,
0x000000430200720bULL, 0x000fe40003f5e000ULL, 0x000000402300720bULL, 0x000fe40003f7e000ULL,
0x00000051180c7208ULL, 0x000fe40004000000ULL, 0x0000000d2a0d7208ULL, 0x000fe40004800000ULL,
0x00000002430f7208ULL, 0x000fe40005000000ULL, 0x0000002340237208ULL, 0x000fc40005800000ULL,
0x000000190c00720bULL, 0x000fe40003f1e000ULL, 0x0000002e0d00720bULL, 0x000fe40003f3e000ULL,
0x000000440f00720bULL, 0x000fe40003f5e000ULL, 0x0000002c2300720bULL, 0x000fe40003f7e000ULL,
0x0000000c19517208ULL, 0x000fe40004000000ULL, 0x0000000d2e027208ULL, 0x000fc40004800000ULL,
0x0000000f440c7208ULL, 0x000fe40005000000ULL, 0x000000232c0e7208ULL, 0x000fe40005800000ULL,
0x0000001a5100720bULL, 0x000fe40003f1e000ULL, 0x0000002f0200720bULL, 0x000fe40003f3e000ULL,
0x000000450c00720bULL, 0x000fe40003f5e000ULL, 0x000000290e00720bULL, 0x000fc40003f7e000ULL,
0x000000511a527208ULL, 0x000fe40004000000ULL, 0x000000022f027208ULL, 0x000fe40004800000ULL,
0x0000000c450d7208ULL, 0x000fe40005000000ULL, 0x0000000e290e7208ULL, 0x000fe40005800000ULL,
0x0000001b5200720bULL, 0x000fe40003f1e000ULL, 0x000000310200720bULL, 0x000fc40003f3e000ULL,
0x000000460d00720bULL, 0x000fe40003f5e000ULL, 0x0000002b0e00720bULL, 0x000fe40003f7e000ULL,
0x000000521b0f7208ULL, 0x000fe40004000000ULL, 0x0000000231027208ULL, 0x000fe40004800000ULL,
0x0000000d460c7208ULL, 0x000fe40005000000ULL, 0x0000000e2b0e7208ULL, 0x000fc40005800000ULL,
0x0000001c0f00720bULL, 0x000fe40003f1e000ULL, 0x000000330200720bULL, 0x000fe40003f3e000ULL,
0x000000470c00720bULL, 0x000fe40003f5e000ULL, 0x0000002d0e00720bULL, 0x000fe40003f7e000ULL,
0x0000000f1c527208ULL, 0x000fe40004000000ULL, 0x00000002330d7208ULL, 0x000fc40004800000ULL,
0x0000000c470c7208ULL, 0x000fe40005000000ULL, 0x0000000e2d0f7208ULL, 0x000fe40005800000ULL,
0x0000001d5200720bULL, 0x000fe40003f1e000ULL, 0x000000340d00720bULL, 0x000fe40003f3e000ULL,
0x000000490c00720bULL, 0x000fe40003f5e000ULL, 0x000000300f00720bULL, 0x000fc40003f7e000ULL,
0x000000521d237208ULL, 0x000fe40004000000ULL, 0x0000000d340d7208ULL, 0x000fe40004800000ULL,
0x0000000c49517208ULL, 0x000fe40005000000ULL, 0x0000000f300f7208ULL, 0x000fe40005800000ULL,
0x0000001e2300720bULL, 0x000fe40003f1e000ULL, 0x000000360d00720bULL, 0x000fc40003f3e000ULL,
0x0000004a5100720bULL, 0x000fe40003f5e000ULL, 0x000000320f00720bULL, 0x000fe40003f7e000ULL,
0x000000231e027208ULL, 0x000fe40004000000ULL, 0x0000000d360d7208ULL, 0x000fe40004800000ULL,
0x000000514a0c7208ULL, 0x000fe40005000000ULL, 0x0000000f320e7208ULL, 0x000fc40005800000ULL,
0x0000001f0200720bULL, 0x000fe40003f1e000ULL, 0x000000380d00720bULL, 0x000fe40003f3e000ULL,
0x0000004b0c00720bULL, 0x000fe40003f5e000ULL, 0x000000370e00720bULL, 0x000fe40003f7e000ULL,
0x000000021f0f7208ULL, 0x000fe40004000000ULL, 0x0000000d38237208ULL, 0x000fc40004800000ULL,
0x0000000c4b557208ULL, 0x000fe40005000000ULL, 0x0000000e37567208ULL, 0x000fe20005800000ULL,
0x000025627f007947ULL, 0x000fea000b800000ULL, 0x0c401f000f027f89ULL, 0x0004e400000e0000ULL,
0x000000020f00720bULL, 0x00cfc80003f1e000ULL, 0x0000000f02577208ULL, 0x000fe20004000000ULL,
0x000025827f007947ULL, 0x000fea000b800000ULL, 0x0c401f0023027f89ULL, 0x000ea800000e0000ULL,
0x0c401f00550c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f00560d7f89ULL, 0x000f2200000e0000ULL,
0x000000022300720bULL, 0x004fc40003f1e000ULL, 0x0000000c5500720bULL, 0x008fe40003f3e000ULL,
0x0000002302027208ULL, 0x000fe40004000000ULL, 0x000000550c0f7208ULL, 0x002fe40004800000ULL,
0x0000000d5600720bULL, 0x010fe20003f1e000ULL, 0x0c201f00570c7f89ULL, 0x000e6600000e0000ULL,
0x000000560d237208ULL, 0x000fe20004000000ULL, 0x0c201f0002517f89ULL, 0x000ea800000e0000ULL,
0x0c201f000f0e7f89ULL, 0x000ee800000e0000ULL, 0x0c201f00235a7f89ULL, 0x0002e400000e0000ULL,
0x0000000c5700720bULL, 0x002fc40003f1e000ULL, 0x000000510200720bULL, 0x004fe40003f3e000ULL,
0x000000570c0c7208ULL, 0x000fe40004000000ULL, 0x0000000e0f00720bULL, 0x008fe40003f5e000ULL,
0x00000002510d7208ULL, 0x000fe40004800000ULL, 0x0000000f0e0e7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b0c0f7820ULL, 0x002fe20000410000ULL, 0x0000005a2300720bULL, 0x000fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fc40000000000ULL, 0x3fb8aa3b11117823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b10107823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b12127823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080fULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b14147823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b15157823ULL, 0x000fc4000001080fULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001080fULL,
0x0000001000107308ULL, 0x000e620000000800ULL, 0x3fb8aa3b18537823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b19547823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b1a567823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b1b577823ULL, 0x100fe2000001080fULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c027823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b1d517823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b1e527823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b1f557823ULL, 0x000fe2000001080fULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b0d0f7820ULL, 0x000fe20000410000ULL,
0x000000111010723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b0e187820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b20207823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080fULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b25257823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080fULL, 0x0000002400197308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001080fULL, 0x000000121312723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b28287823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080fULL, 0x0000001500157308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b31317823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b33587823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b345b7823ULL, 0x100fe2000001080fULL,
0x0000002a005c7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b36597823ULL, 0x000fc4000001080fULL,
0x3fb8aa3b38387823ULL, 0x000fe2000001080fULL, 0x000000235a0f7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010818ULL, 0x000000039dff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010818ULL, 0x0000002e005d7308ULL, 0x0007e20000000800ULL,
0x00000002ff2a7819ULL, 0x004fe2000001169dULL, 0x3fb8aa3b0f337820ULL, 0x000fe20000410000ULL,
0x000000141514723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010818ULL,
0x000000012a1b7810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010818ULL,
0x000000042a237810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010833ULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010833ULL,
0x000000022a1f7810ULL, 0x040fe20007ffe0ffULL, 0x000000082a247824ULL, 0x040fe200078e00ffULL,
0xffffffff2a347810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010833ULL,
0x000000032a367819ULL, 0x000fe200000006ffULL, 0x3fb8aa3b39397823ULL, 0x000fe20000010818ULL,
0x00000041001e7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b4f4f7823ULL, 0x000fc40000010833ULL,
0x000000082a2e7824ULL, 0x008fe400078e00ffULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe40000010818ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010818ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0xfffffff824417812ULL, 0x002fe200078ee21bULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010818ULL,
0xfffffff82e5f7812ULL, 0x000fe200078ee223ULL, 0x3fb8aa3b43437823ULL, 0x100fe40000010818ULL,
0x3fb8aa3b44447823ULL, 0x000fc40000010818ULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x3fb8aa3b45457823ULL, 0x100fe40000010818ULL, 0x3fb8aa3b46467823ULL, 0x100fe40000010818ULL,
0x3fb8aa3b47477823ULL, 0x100fe40000010818ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010818ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010818ULL,
0x000000202111723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b4b187823ULL, 0x000fc40000010818ULL,
0x00000004ff2e7e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000082a4b7824ULL, 0x000fe200078e00ffULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000221913723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010833ULL,
0x3f8000002e2e783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe40000010833ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe40000010833ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b48487823ULL, 0x000fc40000010833ULL, 0x000000082a617824ULL, 0x000fe400078e00ffULL,
0x000000ffff667224ULL, 0x100fe400078e002eULL, 0x000000ffff677224ULL, 0x100fe200078e002eULL,
0x00000039001a7308ULL, 0x000fe20000000800ULL, 0x000000252615723eULL, 0x004fe200000010ffULL,
0x000000ffff257224ULL, 0x000fe200078e002eULL, 0xfffffff861617812ULL, 0x000fe200078ee234ULL,
0x3fb8aa3b40407823ULL, 0x100fe40000010833ULL, 0x3fb8aa3b2b347823ULL, 0x000fc40000010833ULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010833ULL,
0x3fb8aa3b29297823ULL, 0x000fca0000010833ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000004c004c7308ULL, 0x000ff00000000800ULL, 0x0000004d004d7308ULL, 0x000e700000000800ULL,
0x0000004f001b7308ULL, 0x000ff00000000800ULL, 0x0000005000507308ULL, 0x000ea20000000800ULL,
0x0000004c4d19723eULL, 0x002fe200000010ffULL, 0x000000082a4d7824ULL, 0x000fcc00078e00ffULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x0000001b501b723eULL, 0x004fce00000010ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x000000161716723eULL, 0x002fce00000010ffULL,
0x0000001800397308ULL, 0x0003f00000000800ULL, 0x0000003c001c7308ULL, 0x000fe20000000800ULL,
0x000000032a187810ULL, 0x002fe40007ffe0ffULL, 0x000000272817723eULL, 0x004fc400000010ffULL,
0xfffffff84b4b7812ULL, 0x000fe400078ee218ULL, 0x000000351a18723eULL, 0x000fe200000010ffULL,
0x0000002f005e7308ULL, 0x0003e20000000800ULL, 0x0000003a3b1a723eULL, 0x000fe200000010ffULL,
0x000000ffff3a7224ULL, 0x100fe200078e002eULL, 0x000000052a287810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200078e002eULL, 0x000000102a357810ULL, 0x040fe40007ffe0ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee228ULL, 0x00000049003c7308ULL, 0x0005e20000000800ULL,
0x000000ffff2f7224ULL, 0x002fe200078e002eULL, 0x000000082a287810ULL, 0x000fca0007ffe0ffULL,
0x0000000828637824ULL, 0x000fe200078e00ffULL, 0x00000042001d7308ULL, 0x000e620000000800ULL,
0xfffffff824497812ULL, 0x004fe200078ee21fULL, 0x000000ffff247224ULL, 0x000fe200078e002eULL,
0x0000002e1020723cULL, 0x000b6200000418ffULL, 0xfffffff863637812ULL, 0x000fc800078ee228ULL,
0x0000004e004e7308ULL, 0x000fe40000000800ULL, 0x000000062a2f7810ULL, 0x020fe20007ffe0ffULL,
0x000000241824723cULL, 0x000f6600000418ffULL, 0xfffffff8364f7812ULL, 0x000fe200078ee22fULL,
0x0000000835367824ULL, 0x000fe200078e00ffULL, 0x00000048001f7308ULL, 0x0004e20000000800ULL,
0x0000001e1d1e723eULL, 0x002fc600000010ffULL, 0xfffffff836657812ULL, 0x000fe400078ee235ULL,
0x0000002e00367202ULL, 0x000fe40000000f00ULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x000000ffff487224ULL, 0x004fe400078e002eULL, 0x0000003a1420723cULL, 0x000b6a0000041820ULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x0000004e1f1d723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b2d3a7823ULL, 0x020fc40000010833ULL, 0x3fb8aa3b303b7823ULL, 0x000fe20000010833ULL,
0x000000182a307810ULL, 0x000fc60007ffe0ffULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000001c3f1c723eULL, 0x002fe200000010ffULL, 0x000000082a3f7824ULL, 0x000fca00078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee22aULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0x0000003d3e1f723eULL, 0x004fce00000010ffULL, 0x0000005400547308ULL, 0x000e620000000800ULL,
0x3fb8aa3b373e7823ULL, 0x100fe40000010833ULL, 0x3fb8aa3b323d7823ULL, 0x000fe40000010833ULL,
0x000000ffff377224ULL, 0x000fe200078e002eULL, 0x000000661c24723cULL, 0x000f640000041824ULL,
0x0000003100317308ULL, 0x000eb00000000800ULL, 0x0000005600567308ULL, 0x000fe20000000800ULL,
0x000000535428723eULL, 0x002fe200000010ffULL, 0x0000000830537824ULL, 0x000fca00078e00ffULL,
0xfffffff853537812ULL, 0x000fe200078ee230ULL, 0x0000005700577308ULL, 0x000e620000000800ULL,
0x0000005e312b723eULL, 0x004fce00000010ffULL, 0x0000004000407308ULL, 0x000ff00000000800ULL,
0x0000002c002f7308ULL, 0x000ea20000000800ULL, 0x00000056572a723eULL, 0x002fce00000010ffULL,
0x0000004300437308ULL, 0x000ff00000000800ULL, 0x0000004400447308ULL, 0x000e620000000800ULL,
0x000000402f31723eULL, 0x004fe200000010ffULL, 0x000000ffff2f7224ULL, 0x000fcc00078e002eULL,
0x0000004500457308ULL, 0x000ff00000000800ULL, 0x0000004600467308ULL, 0x000ea20000000800ULL,
0x000000434430723eULL, 0x002fce00000010ffULL, 0x00000029002d7308ULL, 0x0003f00000000800ULL,
0x0000003400347308ULL, 0x000ee20000000800ULL, 0x0000005c5d29723eULL, 0x002fe400000010ffULL,
0x000000454632723eULL, 0x004fc400000010ffULL, 0x0000000c0b467812ULL, 0x000fc600078ec0ffULL,
0x0000000200027308ULL, 0x000ff00000000800ULL, 0x0000005100517308ULL, 0x000e620000000800ULL,
0x0000002d3433723eULL, 0x008fe400000010ffULL, 0x000000362834723cULL, 0x000b6a0000041820ULL,
0x0000004a004a7308ULL, 0x000ea60000000800ULL, 0x0000002e3024723cULL, 0x020b6a0000041824ULL,
0x0000005900597308ULL, 0x000fe20000000800ULL, 0x000000025120723eULL, 0x002fc400000010ffULL,
0x0001200000027811ULL, 0x000fc800078e60ffULL, 0x0000000261437211ULL, 0x000fe200078e20ffULL,
0x0000003800387308ULL, 0x000e620000000800ULL, 0x000000103f0b7824ULL, 0x100fe400078e0202ULL,
0x00000010412d7824ULL, 0x100fe400078e0202ULL, 0x00000010492f7824ULL, 0x120fe400078e0202ULL,
0x000000104b3f7824ULL, 0x100fe200078e0202ULL, 0x0000003a002c7308ULL, 0x0005e20000000800ULL,
0x000000105f407824ULL, 0x000fe200078e0202ULL, 0x0000002f462f7210ULL, 0x040fe20007ffe0ffULL,
0x00000001460b7824ULL, 0x000fc400078e020bULL, 0x000000ffff497224ULL, 0x000fe400078e002eULL,
0x000000104d417824ULL, 0x100fe200078e0202ULL, 0x0000003b003b7308ULL, 0x000ee20000000800ULL,
0x0000004a393a723eULL, 0x004fe200000010ffULL, 0x00000001462d7824ULL, 0x000fe200078e022dULL,
0x000000593823723eULL, 0x002fe200000010ffULL, 0x000000104f427824ULL, 0x100fe200078e0202ULL,
0x000000100b007388ULL, 0x0003e20000000800ULL, 0x00000001463f7824ULL, 0x040fe400078e023fULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x0000001063447824ULL, 0x000fe200078e0202ULL,
0x000000122d007388ULL, 0x0003e20000000800ULL, 0x0000000146407824ULL, 0x000fc400078e0240ULL,
0x0000000146417824ULL, 0x040fe200078e0241ULL, 0x000000142f007388ULL, 0x0003e20000000800ULL,
0x0000000146427824ULL, 0x040fe200078e0242ULL, 0x0000005500557308ULL, 0x000ea20000000800ULL,
0x0000002c3b39723eULL, 0x008fe200000010ffULL, 0x0000000146437824ULL, 0x040fe200078e0243ULL,
0x000000163f007388ULL, 0x0003e20000000800ULL, 0x0000000146447824ULL, 0x000fe400078e0244ULL,
0x0000001065457824ULL, 0x100fe200078e0202ULL, 0x0000002840007388ULL, 0x0003e20000000800ULL,
0x0000005800587308ULL, 0x000fe20000000800ULL, 0x0000001053027824ULL, 0x000fc400078e0202ULL,
0x0000002a41007388ULL, 0x0003e20000000800ULL, 0x0000000146457824ULL, 0x040fe400078e0245ULL,
0x0000000146027824ULL, 0x000fe200078e0202ULL, 0x0000002042007388ULL, 0x0003e20000000800ULL,
0x0000005b005b7308ULL, 0x000ee20000000800ULL, 0x000000525522723eULL, 0x004fca00000010ffULL,
0x0000002243007388ULL, 0x0003e40000000800ULL, 0x0000004700477308ULL, 0x000ea40000000800ULL,
0x0000001144007388ULL, 0x0003e80000000800ULL, 0x000400132d007388ULL, 0x0003e40000000800ULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x000000585b21723eULL, 0x008fe200000010ffULL,
0x000400152f007388ULL, 0x0003e80000000800ULL, 0x000400173f007388ULL, 0x0003e40000000800ULL,
0x0000003e003e7308ULL, 0x000ee20000000800ULL, 0x000000473c38723eULL, 0x004fe200000010ffULL,
0x000000ffff3c7224ULL, 0x100fe200078e002eULL, 0x000000482034723cULL, 0x000f620000041834ULL,
0x0004002940007388ULL, 0x0003e80000000800ULL, 0x0004002b41007388ULL, 0x0003e80000000800ULL,
0x0004002142007388ULL, 0x0003e20000000800ULL, 0x0000003d3e3b723eULL, 0x008fe200000010ffULL,
0x000000ffff3d7224ULL, 0x000fc400078e002eULL, 0x0004002343007388ULL, 0x0003e80000000800ULL,
0x0000001845007388ULL, 0x0003e20000000800ULL, 0x0000003c3824723cULL, 0x000f660000041824ULL,
0x0008001a2d007388ULL, 0x0003e60000000800ULL, 0x000000ffff357224ULL, 0x020fe200078e0036ULL,
0x0008001c2f007388ULL, 0x0003e80000000800ULL, 0x0008001e3f007388ULL, 0x0003e80000000800ULL,
0x0008003040007388ULL, 0x0003e80000000800ULL, 0x0008003241007388ULL, 0x0003e80000000800ULL,
0x0008003842007388ULL, 0x0003e20000000800ULL, 0x0000002400367202ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fc400078e0026ULL, 0x0008003a43007388ULL, 0x0003e80000000800ULL,
0x0000001902007388ULL, 0x0003e80000000800ULL, 0x000c001b2d007388ULL, 0x0003e80000000800ULL,
0x000c001d2f007388ULL, 0x0003e80000000800ULL, 0x000c001f3f007388ULL, 0x0003e80000000800ULL,
0x000c003140007388ULL, 0x0003e80000000800ULL, 0x000c003341007388ULL, 0x0003e80000000800ULL,
0x000c003942007388ULL, 0x0003e80000000800ULL, 0x000c003b43007388ULL, 0x0003e80000000800ULL,
0x01e0000c03008388ULL, 0x0003e80000000c00ULL, 0x01e2003403008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e60800a1ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e61000a1ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e61800a1ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000069000720cULL, 0x000fe20003f06070ULL,
0x01e62000a1ff7f8cULL, 0x0003e4000c80043fULL, 0x000000ffff027224ULL, 0x002fd400078e0090ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff746000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff247807ULL, 0x008fe40004000000ULL,
0xffffffff00257802ULL, 0x000fe40000000f00ULL, 0x0001a2f000267802ULL, 0x000fc40000000f00ULL,
0x000015e000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff137224ULL, 0x000fe200078e0024ULL,
0xfffe8f4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20005000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001a35000267802ULL, 0x000fc40000000f00ULL,
0x0000158000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0024ULL,
0xfffe8f7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0015ULL,
0x0001a3c000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000014c000007944ULL, 0x012fea0003c00000ULL,
0xfffe902000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0015ULL,
0x0000001f00697802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001a42000257802ULL, 0x000fc40000000f00ULL, 0x0000146000007944ULL, 0x012fea0003c00000ULL,
0xfffe913000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0015ULL,
0x0001a48000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000140000007944ULL, 0x012fea0003c00000ULL,
0xfffe924000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0015ULL,
0x0001a4e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000013a000007944ULL, 0x012fea0003c00000ULL,
0xfffe934000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0011ULL,
0xffffffff00277802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fe200078e0010ULL,
0x0001a55000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fc400078e00ffULL,
0x0000133000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0024ULL,
0xfffe94d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0011ULL,
0x0001a5c000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000012c000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0024ULL, 0x0000001010247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0011ULL, 0x0001a63000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000125000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0024ULL,
0xfffe944000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0011ULL,
0x0000001f00697802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001a6a000257802ULL, 0x000fc40000000f00ULL, 0x000011e000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0024ULL, 0xfffe940000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001a70000267802ULL, 0x000fc40000000f00ULL, 0x000011d000007944ULL, 0x018fea0003c00000ULL,
0x00000024006a7202ULL, 0x000fe20000000f00ULL, 0xfffead0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001a76000267802ULL, 0x000fc40000000f00ULL, 0x0000117000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0024ULL, 0xfffead4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001a7d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000010b000007944ULL, 0x018fea0003c00000ULL, 0xfffeae0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe200078e00ffULL, 0x0001a83000257802ULL, 0x000fc40000000f00ULL,
0x0000105000007944ULL, 0x01afea0003c00000ULL, 0xfffeaf1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001a89000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000ff000007944ULL, 0x01afea0003c00000ULL, 0xfffeb02000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0001a8f000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000f9000007944ULL, 0x01afea0003c00000ULL, 0xfffeb12000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0007ULL, 0x0001a96000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fc400078e0010ULL, 0x0000001fff697424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000f2000007944ULL, 0x010fea0003c00000ULL,
0x00000024000d7202ULL, 0x004fe20000000f00ULL, 0xfffeb2a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0007ULL, 0x0001a9d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000eb000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0024ULL,
0x0000001010247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0007ULL,
0x0001aa4000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000e4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0024ULL, 0xfffeb21000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0007ULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe200078e00ffULL, 0x0001aab000257802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0xfffeb1d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x004fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001ab1000267802ULL, 0x000fc40000000f00ULL,
0x00000dc000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e0024ULL,
0xfffec81000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001ab7000267802ULL, 0x000fc40000000f00ULL,
0x00000d6000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e0024ULL,
0xfffec84000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001abe000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000ca000007944ULL, 0x018fea0003c00000ULL,
0xfffec8f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001ac4000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000c4000007944ULL, 0x01afea0003c00000ULL,
0xfffeca0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0xffffffff00277802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fe200078e00ffULL,
0x0001aca000257802ULL, 0x000fc40000000f00ULL, 0x00000be000007944ULL, 0x01afea0003c00000ULL,
0xfffecb1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001ad0000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000b8000007944ULL, 0x01afea0003c00000ULL,
0xfffecc1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0010ULL,
0x0001ad7000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fc400078e006bULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000b1000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0024ULL,
0xfffecd9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0010ULL,
0x0000001f00697802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001ade000257802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0024ULL, 0x000000106b247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0010ULL, 0x0001ae5000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000a3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0024ULL,
0xfffecd0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0010ULL,
0x0001aec000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000009c000007944ULL, 0x016fea0003c00000ULL,
0x0000002400107202ULL, 0x004fe20000000f00ULL, 0xfffeccc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001af2000267802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff497224ULL, 0x000fe200078e0024ULL, 0xfffee30000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001af8000267802ULL, 0x000fc40000000f00ULL, 0x0000095000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0024ULL, 0xfffee34000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006aULL, 0x0001aff000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000089000007944ULL, 0x018fea0003c00000ULL, 0xfffee3f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006aULL, 0x0001b05000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000083000007944ULL, 0x01afea0003c00000ULL, 0xfffee50000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006aULL, 0x0001b0b000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000007d000007944ULL, 0x01afea0003c00000ULL, 0xfffee61000007947ULL, 0x000fea000383ffffULL,
0x0000006a00267202ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fe200078e00ffULL,
0x0001b11000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000077000007944ULL, 0x01afea0003c00000ULL, 0xfffee71000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000bULL, 0x0001b18000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fc400078e0010ULL, 0x0000001fff697424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000070000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0024ULL, 0xfffee88000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000bULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe200078e00ffULL, 0x0001b1f000257802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0024ULL,
0x0000001010247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e000bULL,
0x0001b26000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff697424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000062000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0024ULL, 0xfffee7f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000bULL, 0x0001b2d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff697424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000005b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0xfffee7b000007947ULL, 0x000fea000383ffffULL, 0x0000000200547802ULL, 0x000fe20000000f00ULL,
0x0000001fff027424ULL, 0x000fe200078e00ffULL, 0x0001b34000527802ULL, 0x000fe20000000f00ULL,
0xffffffffff597424ULL, 0x000fc400078e00ffULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0xffffda5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0f7224ULL, 0x002fe200078e0023ULL,
0x0001b3b000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fc400078e00ffULL,
0x0000001fff027424ULL, 0x000fe400078e00ffULL, 0xffffffffff597424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000022300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0055ULL, 0xffffffff00597802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x00000023020d7208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fe200078e00ffULL, 0x0001b43000527802ULL, 0x000fc40000000f00ULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000025500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0056ULL, 0x0001b4b000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x0000005502517208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fc400078e00ffULL, 0xffffffffff597424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000025600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0057ULL, 0x0001b53000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x0000005602237208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fe400078e00ffULL, 0xffffffffff597424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000025700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e000dULL, 0x0000000100547802ULL, 0x000fe20000000f00ULL,
0xffffffffff597424ULL, 0x000fe200078e00ffULL, 0x00000057020c7208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fe200078e00ffULL, 0x0001b5b000527802ULL, 0x000fc40000000f00ULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000020d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0051ULL, 0x0001b63000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x0000000d020d7208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fc400078e00ffULL, 0xffffffffff597424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000025100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0023ULL, 0xffffffff00597802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x00000051020e7208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fe200078e00ffULL, 0x0001b6b000527802ULL, 0x000fc40000000f00ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff5a7224ULL, 0x004fe200078e0002ULL,
0xffffd83000007947ULL, 0x000fea000383ffffULL, 0x0180000006037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003087812ULL, 0x000fc800078ec0ffULL,
0x018000000800780cULL, 0x000fda0003f05070ULL, 0x0000000600038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0800720cULL, 0x040fe40003f25070ULL,
0x008000000800780cULL, 0x000fe40003f02070ULL, 0x00000001ff087807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000308ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000308ff7212ULL, 0x000fda000780c0ffULL, 0x0080000006030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff0b7424ULL, 0x000fc800078e00ffULL, 0xfffe47c00a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005900007348ULL, 0x000fe80003800000ULL,
0x0c0000540f027389ULL, 0x0002a200000e0002ULL, 0xfffe478052007950ULL, 0x000fea0003c3ffffULL,
0x0000002700007348ULL, 0x000fe80003800000ULL, 0x0000002426247389ULL, 0x0002a400000e0069ULL,
0x000000ffff267224ULL, 0x002fc400078e0025ULL, 0x00000000ff277424ULL, 0x000fc800078e00ffULL,
0xfffe473026007950ULL, 0x000fea0003c3ffffULL, 0x000000012400780cULL, 0x000fe20003f45070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000002500007348ULL, 0x000ff60003800000ULL,
0x0000000000247806ULL, 0x000fc800050e0100ULL, 0x0000002524247212ULL, 0x000fe200078ec0ffULL,
0xfffe46d026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000868ULL,
0x0000000000000270ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ad8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b98ULL,
0x00000000000006d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001268ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001278ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001308ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000130cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x000000000001ba00ULL, 0xdf00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001cf00ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001cf40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001d2c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001308ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001bbf8ULL,
0x000000000001bbf8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001cf00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001d2c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_64_nqpkv_0_m_32_sm_80_cubin_len = 119712;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
