/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015c90ULL, 0x0000000000015810ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000141f0ULL, 0x0000000000000180ULL,
0x000e002200000106ULL, 0x0000000000014370ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000143b0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000143f0ULL,
0x0000000000000110ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000014500ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000141f000000000ULL, 0x0000040400000000ULL, 0x810c0000011c0400ULL,
0x004f540400288080ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8708288080820828ULL, 0x2880808808288080ULL, 0x808b082880808a08ULL, 0x082880808c082880ULL,
0x808090082880808dULL, 0x9a08288080980828ULL, 0x2880809c08288080ULL, 0x809e082880809d08ULL,
0x082880809f082880ULL, 0x8080b108288080b0ULL, 0xb608288080b20828ULL, 0x288080a308288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080a3ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x000141f000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8085288080880900ULL, 0x0900000010042880ULL, 0x28808088288080a3ULL, 0x00000094ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880808808288080ULL, 0x808b082880808a08ULL,
0x082880808c082880ULL, 0x8080980828808090ULL, 0x9c082880809a0828ULL, 0x2880809d08288080ULL,
0x809f082880809e08ULL, 0x08288080b0082880ULL, 0x8080b208288080b1ULL, 0x8016288080b60828ULL,
0x0000000310288082ULL, 0x80b6920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000015800000000ULL, 0x0001437000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880808808288080ULL,
0x808b082880808a08ULL, 0x082880808c082880ULL, 0x8080980828808090ULL, 0x9d082880809a0828ULL,
0x2880809e08288080ULL, 0x80b0082880809f08ULL, 0x08288080b1082880ULL, 0x8080b608288080b2ULL,
0x80162880809c0828ULL, 0x0000000310288082ULL, 0x809c920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000022000000000ULL, 0x000143b000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL,
0x2880808808288080ULL, 0x808b082880808a08ULL, 0x082880808c082880ULL, 0x8080980828808090ULL,
0x9c082880809a0828ULL, 0x2880809e08288080ULL, 0x80b0082880809f08ULL, 0x08288080b1082880ULL,
0x8080b608288080b2ULL, 0x80162880809d0828ULL, 0x0000000310288082ULL, 0x809d920000000000ULL,
0x0000000022002880ULL, 0x0000002cffffffffULL, 0x000002e800000000ULL, 0x000143f000000000ULL,
0x0000011000000000ULL, 0x0000140400000000ULL, 0x80902880809d0900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x0008120400000090ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000eULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x00012b4000012860ULL,
0x00012c1000012b50ULL, 0x00012c3000012c20ULL, 0xffffffff01702904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x05000017ffffffffULL, 0x0500001705000017ULL, 0xffffffff05000017ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01702804ffffffffULL, 0x0000012000000100ULL, 0x00002880000016a0ULL, 0x000029d000002910ULL,
0x00002cf000002a00ULL, 0x00002d6000002d00ULL, 0x0000344000002dc0ULL, 0x0000450000004470ULL,
0x000046f0000045d0ULL, 0x000048f0000048e0ULL, 0x000049b000004950ULL, 0x00005ec000004dc0ULL,
0x0000602000005f50ULL, 0x0000633000006140ULL, 0x000063a000006340ULL, 0x0000680000006400ULL,
0x000078b000007820ULL, 0x00007aa000007980ULL, 0x00007ca000007c90ULL, 0x00007d6000007d00ULL,
0x000081f0000081e0ULL, 0x0000a9f00000a900ULL, 0x0000b2200000b1f0ULL, 0x000124b000012480ULL,
0x000124d0000124c0ULL, 0x0001252000012500ULL, 0x0001254000012530ULL, 0x00012c6000012c00ULL,
0x00012c8000012c70ULL, 0x00013400000133a0ULL, 0x000134e000013470ULL, 0x000135b000013540ULL,
0x0001367000013610ULL, 0x00013750000136e0ULL, 0x00013800000137a0ULL, 0x000138c000013860ULL,
0x000139a000013930ULL, 0x00013a50000139f0ULL, 0x00013b1000013ab0ULL, 0x00013bd000013b70ULL,
0x00013c8000013c20ULL, 0x00013d8000013d00ULL, 0x00013e6000013df0ULL, 0x00013f4000013ed0ULL,
0x0001402000013fb0ULL, 0x0001411000014090ULL, 0x000141d000014170ULL, 0x000001f002003904ULL,
0x0001b600000000ffULL, 0x00000270003f0100ULL, 0x0001b6080000000dULL, 0x00000340003f0120ULL,
0x0001b6880000000dULL, 0x00000400003f0120ULL, 0x0001b600000000ffULL, 0x000005d0003f0107ULL,
0x0001b68c0000005aULL, 0x00000680003f0102ULL, 0x0001b6880000005aULL, 0x000026d0003f0101ULL,
0x0001b60800000006ULL, 0x000026e0003f0101ULL, 0x0001b60c00000006ULL, 0x00002780003f0105ULL,
0x0001b60c00000007ULL, 0x000033d0003f0105ULL, 0x0001b68800000076ULL, 0x00004320003f0101ULL,
0x0001b62800000006ULL, 0x00004330003f0101ULL, 0x0001b62c00000006ULL, 0x000043c0003f0105ULL,
0x0001b62c00000006ULL, 0x00004d60003f0105ULL, 0x0001b69000000076ULL, 0x00005d30003f0101ULL,
0x0001b64800000006ULL, 0x00005d40003f0101ULL, 0x0001b64c00000006ULL, 0x00005e10003f0105ULL,
0x0001b64c00000013ULL, 0x000067a0003f0105ULL, 0x0001b69800000076ULL, 0x000076d0003f0101ULL,
0x0001b66800000006ULL, 0x000076e0003f0101ULL, 0x0001b66c00000006ULL, 0x00007770003f0105ULL,
0x0001b66c00000006ULL, 0x00008020003f0105ULL, 0x0001b6a000000076ULL, 0x0000bfa0003f0101ULL,
0x0001b600000000ffULL, 0x0000dba0003f0101ULL, 0x0001b604000000ffULL, 0x0000dc40003f0105ULL,
0x0001b604000000ffULL, 0x00011aa0003f0105ULL, 0x000000000000000dULL, 0x00011ad0003f0101ULL,
0x000000040000000dULL, 0x00011da0003f0105ULL, 0x000000040000000dULL, 0x000131f0003f0105ULL,
0x0001b6080000000bULL, 0x00013250003f0101ULL, 0x0001b6100000000bULL, 0x000132b0003f0101ULL,
0x0001b6180000000bULL, 0x00013320003f0101ULL, 0x0001b6200000000bULL, 0x00033803003f0101ULL,
0x0000bc2000141c04ULL, 0x0000dca00000be70ULL, 0x000133600000dd30ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x000000000000039cULL, 0x0000001200000002ULL, 0x00000000000002d4ULL,
0x0000001200000002ULL, 0x000000000000020cULL, 0x0000001200000002ULL, 0x000000000000012cULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000375ULL,
0x0000001200000002ULL, 0x00000000000002adULL, 0x0000001200000002ULL, 0x00000000000001e5ULL,
0x0000001200000002ULL, 0x0000000000000107ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff187624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000f7919ULL, 0x000ea20000002300ULL,
0x0000001400067300ULL, 0x000fe200000e0000ULL, 0x0000000818047824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea20000002200ULL, 0x00000100ff0b7424ULL, 0x000fc600078e00ffULL,
0x0000000000107919ULL, 0x000ee20000002600ULL, 0x0000001400147309ULL, 0x000f260000000000ULL,
0x00000000000e7919ULL, 0x000f680000002700ULL, 0x0000000000077919ULL, 0x000f620000000000ULL,
0x00000005ff607819ULL, 0x002fe2000001160dULL, 0x000000ffff147224ULL, 0x010fca00078e0a14ULL,
0x00001fff60607589ULL, 0x000fe200000e0000ULL, 0x000000010f007824ULL, 0x004fc600078e0200ULL,
0x00001fff0f0f7589ULL, 0x000e6200000e0000ULL, 0x00000080000d7824ULL, 0x000fc600078e020dULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x0000000810057824ULL, 0x008fe200078e00ffULL,
0x000000ff0d00720cULL, 0x000fc60003f05270ULL, 0x0000000e04047224ULL, 0x020fe200078e0205ULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000070600720cULL, 0x000fe40003f82070ULL,
0x0000007f0d00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x000000040f057824ULL, 0x002fe400078e0260ULL,
0x3fffffc0ff089424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x0003e20000000a00ULL,
0x00000004ff0c7819ULL, 0x004fe20000011600ULL, 0x0000000205067824ULL, 0x000fe200078e00ffULL,
0x000000030d00780cULL, 0x000fe20003f04070ULL, 0x7fffffc0ff099424ULL, 0x000fc400078e00ffULL,
0x0000000106117824ULL, 0x040fe200078e020cULL, 0x0000000806077817ULL, 0x000fe20007800000ULL,
0xff317217ff12a424ULL, 0x000fe200078e00ffULL, 0x01b608080d009388ULL, 0x0005e20000008a00ULL,
0x0000000104027824ULL, 0x002fe200078e0211ULL, 0x0000000711137812ULL, 0x000fe200078ec0ffULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x01b400120d00a388ULL, 0x0003e20000004800ULL,
0x00005c0002027625ULL, 0x000fe200078e000bULL, 0x0000000f13047812ULL, 0x000fe400078e7800ULL,
0x000000f005157812ULL, 0x000fe200078ec0ffULL, 0x3fffff60ff0a8424ULL, 0x000fc400078e00ffULL,
0x7fffff60ff0b8424ULL, 0x000fe400078e00ffULL, 0x0000000107077824ULL, 0x000fe200078e0a06ULL,
0x0000001502067210ULL, 0x000fe20007f7e0ffULL, 0x0000001011047824ULL, 0x000fe200078e0204ULL,
0x01b6880a0d008388ULL, 0x0003e20000008a00ULL, 0x00000004ff117424ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000070c00720cULL, 0x000fe20003f26070ULL,
0x000000ffff077224ULL, 0x000fe400018e0603ULL, 0x0000001004097824ULL, 0x004fe400078e00ffULL,
0x000000ffff047224ULL, 0x000fe400078e0014ULL, 0x000062000e027625ULL, 0x000fcc00078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000c901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01b60404ffff438cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602617981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x00000004ff177e24ULL, 0x008fe2000f8e00ffULL,
0x0000007f61167810ULL, 0x004fc40007ffe0ffULL, 0x000000ff61147810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff167819ULL, 0x000fe40000011616ULL, 0x00000008ff147819ULL, 0x000fca0000011614ULL,
0x0000b97000008947ULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x000fe20000011660ULL,
0x00000008605a7824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x000fe200078e00ffULL,
0x01ffffff02027812ULL, 0x000fe200078ec0ffULL, 0xffffffffff157424ULL, 0x000fc800078e00ffULL,
0x0000000217597824ULL, 0x000fca00078e0202ULL, 0x000000165900720cULL, 0x000fda0003f06070ULL,
0x000000020e028824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640002028624ULL, 0x000fc800078e0203ULL, 0x0000000159028824ULL, 0x000fe200078e0202ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b68c055aff738cULL, 0x0005e20000000000ULL,
0x0000600002028625ULL, 0x000fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000602158981ULL, 0x000ee2000c1e1900ULL, 0x0000000117057810ULL, 0x004fe20007ffe0ffULL,
0x00000080100f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff5b7819ULL, 0x000fe20000011660ULL,
0x01b688005aff7f8cULL, 0x0005e2000c80043fULL, 0x000000140500720cULL, 0x000fe40003f06070ULL,
0x0000000160627812ULL, 0x000fe200078ec0ffULL, 0x000000205b587824ULL, 0x000fc800078e00ffULL,
0x0000010017067824ULL, 0x002fca00078e0258ULL, 0x000000600f127812ULL, 0x000fe200078ef806ULL,
0x0000580015047a24ULL, 0x008fc800078e02ffULL, 0x00000080041e7824ULL, 0x000fe200078e00ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x004fe20000011600ULL,
0x00000008621b7824ULL, 0x000fe200078e00ffULL, 0x0000000661027217ULL, 0x000fe40007800000ULL,
0x000000040d057810ULL, 0x040fe40007ffe0ffULL, 0x000000080d077810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a06ULL, 0x0000000005037212ULL, 0x0c0fe200078e3cffULL,
0x0000000805087824ULL, 0x000fe200078e00ffULL, 0x0000000007047212ULL, 0x040fe200078e3cffULL,
0x00000008071f7824ULL, 0x000fe200078e00ffULL, 0x0000002002187817ULL, 0x000fc40003800000ULL,
0xfffffff8081d7812ULL, 0x000fe200078ee203ULL, 0x0000000112037824ULL, 0x040fe200078e020dULL,
0x0000000c0d137810ULL, 0x000fe40007ffe0ffULL, 0x000000180500720cULL, 0x080fe20003f06070ULL,
0x0000000112057824ULL, 0x000fe200078e0205ULL, 0x000000031e037210ULL, 0x000fe20007f5e0ffULL,
0x0000000112027824ULL, 0x040fe200078e0213ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL,
0x0000000813217824ULL, 0x000fe200078e00ffULL, 0x000000180700720cULL, 0x000fe20003f26070ULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x00005e0003047a11ULL, 0x000fe200078440ffULL,
0x0000000112077824ULL, 0x000fe200078e0207ULL, 0x000000051e0b7210ULL, 0x000fc40007f7e0ffULL,
0x00005f0003057a11ULL, 0x000fe400010f4406ULL, 0x000000071e097210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x000000021e037210ULL, 0x000fe40007fbe0ffULL,
0x000000100d237810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x00005e0003027a11ULL, 0x000fe200078840ffULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x00005e000b067a11ULL, 0x000fc400078440ffULL, 0x000000140d257810ULL, 0x000fe40007ffe0ffULL,
0x00005f0003037a11ULL, 0x000fe200020f440aULL, 0x00000001120a7824ULL, 0x040fe200078e0223ULL,
0x00005f000b077a11ULL, 0x000fe200010f4410ULL, 0x00000001120b7824ULL, 0x000fe200078e0225ULL,
0x00005e0009087a11ULL, 0x000fe400078640ffULL, 0x000000180d277810ULL, 0x040fe40007ffe0ffULL,
0x0000001c0d297810ULL, 0x000fc40007ffe0ffULL, 0x0000000a1e117210ULL, 0x000fe40007f5e0ffULL,
0x00005f0009097a11ULL, 0x000fe200018f440cULL, 0x00000001120c7824ULL, 0x040fe200078e0227ULL,
0x00005e00110a7a11ULL, 0x040fe200078840ffULL, 0x0000000112107824ULL, 0x000fe200078e0229ULL,
0x0000000b1e127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x0000000c1e207210ULL, 0x040fe40007f7e0ffULL, 0x000000101e1e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200028e06ffULL, 0x00005f00110b7a11ULL, 0x000fe200020f441aULL,
0x000000025b1a7824ULL, 0x000fe200078e0262ULL, 0x00005e00120c7a11ULL, 0x000fe200078a40ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x000000070d117812ULL, 0x000fc400078e4800ULL,
0x000000180d00720cULL, 0x000fe40003f86070ULL, 0x00005f00120d7a11ULL, 0x000fe400028f4419ULL,
0x000130001a1a7811ULL, 0x000fe400078e68ffULL, 0x0ffffff811117812ULL, 0x100fe400078ef800ULL,
0xfffffff81b197812ULL, 0x000fe200078ee200ULL, 0x000000101d1d7824ULL, 0x100fe200078e021aULL,
0x00005e001e127a11ULL, 0x000fe200078a40ffULL, 0x00000010111b7824ULL, 0x000fe200078e021aULL,
0x00000000131c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005e0020107a11ULL, 0x000fe200078640ffULL, 0x0000001019047825ULL, 0x000fe200078e0004ULL,
0x000000181300720cULL, 0x000fc40003f46070ULL, 0x00005f0020117a11ULL, 0x000fe200018f4411ULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x00005f001e137a11ULL, 0x000fe200028f442bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041b7faeULL, 0x0003e2000e101c46ULL,
0x000000182300720cULL, 0x080fe20003f66070ULL, 0x0000001019027825ULL, 0x000fe200078e0002ULL,
0x000000182500720cULL, 0x080fe40003f86070ULL, 0x000000182700720cULL, 0x080fe40003fa6070ULL,
0x000000182900720cULL, 0x000fc40003fc6070ULL, 0x0000000023187212ULL, 0x0c0fe200078e3cffULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe400078ee21cULL,
0x00000000251c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x00000000271e7212ULL, 0x0c0fe200078e3cffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0000000029047212ULL, 0x042fe200078e3cffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff823057812ULL, 0x000fe200078ee218ULL, 0x0000001021217824ULL, 0x000fe200078e021aULL,
0xfffffff825237812ULL, 0x000fc400078ee21cULL, 0xfffffff827257812ULL, 0x000fe200078ee21eULL,
0x00000010051b7824ULL, 0x000fe200078e021aULL, 0xfffffff829277812ULL, 0x000fe200078ee204ULL,
0x0000001019047825ULL, 0x000fc800078e0006ULL, 0x0000001019067825ULL, 0x040fe200078e0008ULL,
0x00000000041d7faeULL, 0x0003e6000c101c46ULL, 0x0000001019087825ULL, 0x000fe200078e000aULL,
0x00000000061f7faeULL, 0x0003e6000c901c46ULL, 0x0000001023237824ULL, 0x000fe200078e021aULL,
0x0000000002217faeULL, 0x0003e2000d101c46ULL, 0x00000010190a7825ULL, 0x000fc600078e000cULL,
0x00000000081b7faeULL, 0x0003e2000d901c46ULL, 0x0000001025257824ULL, 0x000fe400078e021aULL,
0x00000010190c7825ULL, 0x000fe200078e0010ULL, 0x000000000a237faeULL, 0x0003e6000e101c46ULL,
0x0000001027277824ULL, 0x000fe200078e021aULL, 0x000000000c257faeULL, 0x0003e2000e901c46ULL,
0x0000001019107825ULL, 0x000fca00078e0012ULL, 0x0000000010277faeULL, 0x0003e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x004fc80000011600ULL,
0x0000000405077810ULL, 0x040fe40007ffe0ffULL, 0x0000000805097810ULL, 0x000fe40007ffe0ffULL,
0x0000000007027212ULL, 0x0c0fe200078e3cffULL, 0x0000000807037824ULL, 0x000fe200078e00ffULL,
0x0000000009047212ULL, 0x040fe200078e3cffULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0x0000001005117810ULL, 0x000fe20007ffe0ffULL, 0x0000000112077824ULL, 0x040fe200078e0207ULL,
0xfffffff8030a7812ULL, 0x000fe200078ee202ULL, 0x0000000112037824ULL, 0x040fe200078e0205ULL,
0xfffffff80b0c7812ULL, 0x000fe200078ee204ULL, 0x00000008111b7824ULL, 0x000fe200078e00ffULL,
0x0000000c050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112097824ULL, 0x000fe200078e0209ULL,
0x000000031e037210ULL, 0x000fc40007f1e0ffULL, 0x000000000b067212ULL, 0x0c0fe200078e3cffULL,
0x000000080b197824ULL, 0x000fe200078e00ffULL, 0x0000001405137810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000011087212ULL, 0x000fe200078e3cffULL,
0x0000000112117824ULL, 0x000fe200078e0211ULL, 0xfffffff819107812ULL, 0x000fe200078ee206ULL,
0x00000008131a7824ULL, 0x000fe200078e00ffULL, 0x00005e0003027a11ULL, 0x000fe200078040ffULL,
0x000000025b067824ULL, 0x000fe200078e0262ULL, 0x0000001805197810ULL, 0x000fc40007ffe0ffULL,
0x00000000130d7212ULL, 0x080fe200078e3cffULL, 0x0000000112137824ULL, 0x040fe200078e0213ULL,
0xfffffff81b187812ULL, 0x000fe200078ee208ULL, 0x00000001121b7824ULL, 0x000fe200078e0219ULL,
0x00005f0003037a11ULL, 0x000fe400000f4404ULL, 0x0000001c051d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000019047212ULL, 0x040fe200078e3cffULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20dULL, 0x00000001120d7824ULL, 0x000fe200078e020bULL,
0x000000071e087210ULL, 0x000fe20007fde0ffULL, 0x00000001121f7824ULL, 0x000fe200078e021dULL,
0x0000000705057812ULL, 0x000fe200078e4800ULL, 0x000000081d207824ULL, 0x000fe200078e00ffULL,
0xfffffff819127812ULL, 0x000fc400078ee204ULL, 0x0001300006077811ULL, 0x000fe400078e68ffULL,
0x000000091e0b7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x000000001d197212ULL, 0x000fe200078e3cffULL, 0x000000100a1d7824ULL, 0x100fe200078e0207ULL,
0x0ffffff805067812ULL, 0x000fe200078ef800ULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x0000000d1e0d7210ULL, 0x000fe20007f9e0ffULL, 0x0000001010217824ULL, 0x100fe200078e0207ULL,
0x00005e0008047a11ULL, 0x000fe200078c40ffULL, 0x0000001018237824ULL, 0x100fe200078e0207ULL,
0x000000111e117210ULL, 0x000fe20007f7e0ffULL, 0x000000101a257824ULL, 0x100fe200078e0207ULL,
0x000000131e137210ULL, 0x000fe20007f1e0ffULL, 0x0000001012297824ULL, 0x100fe200078e0207ULL,
0x0000001b1e1c7210ULL, 0x000fe20007f3e0ffULL, 0x00000010061b7824ULL, 0x100fe200078e0207ULL,
0x0000001f1e1e7210ULL, 0x000fe20007f5e0ffULL, 0x000000100c1f7824ULL, 0x000fe200078e0207ULL,
0xfffffff820207812ULL, 0x000fe200078ee219ULL, 0x0000000862197824ULL, 0x000fe200078e00ffULL,
0x00005f0008057a11ULL, 0x000fe200030f4409ULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x00005e000b067a11ULL, 0x000fe200078a40ffULL, 0x00000010202d7824ULL, 0x000fe200078e0207ULL,
0x00005e000d087a11ULL, 0x000fe200078840ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x00005f000b077a11ULL, 0x000fe200028f440aULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x00005f000d097a11ULL, 0x000fe200020f440cULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0xfffffff819197812ULL, 0x000fe200078ee200ULL, 0x000000ffff2b7224ULL, 0x000fe200010e06ffULL,
0x00005e00110a7a11ULL, 0x000fc400078640ffULL, 0x00005e00130c7a11ULL, 0x000fe200078040ffULL,
0x0000001019027825ULL, 0x040fe200078e0002ULL, 0x00005e001c107a11ULL, 0x000fe400078240ffULL,
0x00005e001e127a11ULL, 0x000fe200078440ffULL, 0x0000001019047825ULL, 0x000fe200078e0004ULL,
0x00005f00110b7a11ULL, 0x000fe200018f4418ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000021b7faeULL, 0x0003e2000b901c46ULL, 0x00005f00130d7a11ULL, 0x000fe200000f441aULL,
0x0000001019067825ULL, 0x040fe200078e0006ULL, 0x00005f001c117a11ULL, 0x000fe200008f4427ULL,
0x00000000041d7faeULL, 0x0003e2000b901c46ULL, 0x00005f001e137a11ULL, 0x000fe200010f442bULL,
0x0000001019087825ULL, 0x000fc400078e0008ULL, 0x00000000061f7faeULL, 0x0003e4000b901c46ULL,
0x00000010190a7825ULL, 0x040fe400078e000aULL, 0x0000000008217faeULL, 0x0003e4000b901c46ULL,
0x00000010190c7825ULL, 0x040fe400078e000cULL, 0x000000000a237faeULL, 0x0003e4000b901c46ULL,
0x0000001019107825ULL, 0x000fc400078e0010ULL, 0x000000000c257faeULL, 0x0003e4000b901c46ULL,
0x0000001019127825ULL, 0x000fe400078e0012ULL, 0x0000000010297faeULL, 0x0003e8000b901c46ULL,
0x00000000122d7faeULL, 0x0003e4000b901c46ULL, 0x000000141700720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff027424ULL, 0x002fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00006aa000000947ULL, 0x000fea0003800000ULL,
0x000000020e047824ULL, 0x000fe400078e00ffULL, 0x00006400ff057624ULL, 0x000fc400078e00ffULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff7a7224ULL, 0x000fe400078e00ffULL,
0x0000640004047624ULL, 0x000fe400078e0205ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x0000010017067824ULL, 0x000fca00078e00ffULL, 0x000000610600720cULL, 0x000fda0003f06070ULL,
0x000069d000000947ULL, 0x020fea0003800000ULL, 0x0000001060057824ULL, 0x000fe200078e00ffULL,
0x0000000117077810ULL, 0x000fe20007ffe0ffULL, 0x0000580015157a24ULL, 0x000fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000140700720cULL, 0x000fe20003f06070ULL,
0x000000ffff787224ULL, 0x000fe200078e0059ULL, 0xffffffe005067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe400078e007aULL, 0x0000008015227824ULL, 0x000fe400078e00ffULL,
0x0000010017067824ULL, 0x000fca00078e0206ULL, 0x00000040060c7810ULL, 0x000fc80007ffe0ffULL,
0x000000600f1f7812ULL, 0x000fe200078ef80cULL, 0x0000077000008947ULL, 0x000fea0003800000ULL,
0x0000000c61067217ULL, 0x000fe20007800000ULL, 0x0000200060087824ULL, 0x000fe200078e00ffULL,
0x00000003ff247819ULL, 0x000fe20000011600ULL, 0x000010007a097824ULL, 0x000fe200078e00ffULL,
0x0000000700077812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0cULL,
0x0000200008087812ULL, 0x000fe200078ec0ffULL, 0x00000008620c7824ULL, 0x000fe200078e00ffULL,
0x0000000424107810ULL, 0x000fe40007ffe0ffULL, 0x0000100009097812ULL, 0x000fe200078e0cffULL,
0x000040005b087824ULL, 0x000fe200078e0208ULL, 0x000000080c157812ULL, 0x000fe200078ee207ULL,
0x0000000124077824ULL, 0x000fe200078e021fULL, 0x00000000100b7212ULL, 0x040fe200078e3cffULL,
0x00000008100c7824ULL, 0x000fe200078e00ffULL, 0x00013000080e7810ULL, 0x000fc40007ffe009ULL,
0x0000000722077210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80c277812ULL, 0x000fe400078ee20bULL,
0x00000020060b7817ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000824127810ULL, 0x000fe20007ffe0ffULL, 0x0000000110067824ULL, 0x140fe200078e021fULL,
0x00005e00070c7a11ULL, 0x040fe400078040ffULL, 0x0000000b1000720cULL, 0x000fe20003f46070ULL,
0x00000008121c7824ULL, 0x040fe200078e00ffULL, 0x00005f00070d7a11ULL, 0x000fe200000f4408ULL,
0x0000000112077824ULL, 0x000fe200078e021fULL, 0x0000000622107210ULL, 0x000fc40007f1e0ffULL,
0x0000000012097212ULL, 0x000fe200078e3cffULL, 0x00000010150c7825ULL, 0x000fe200078e000cULL,
0x0000000c24267810ULL, 0x040fe40007ffe0ffULL, 0x00000010242a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0xfffffff81c297812ULL, 0x000fe200078ee209ULL,
0x0000000126087824ULL, 0x100fe200078e021fULL, 0x00005e0010067a11ULL, 0x000fe200078040ffULL,
0x000000012a097824ULL, 0x000fe200078e021fULL, 0x0000000722137210ULL, 0x000fe20007f7e0ffULL,
0x00000008262b7824ULL, 0x000fe200078e00ffULL, 0x00005f0010077a11ULL, 0x000fc400000f4411ULL,
0x0000000822117210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x0000000922097210ULL, 0x000fe20007fbe0ffULL, 0x0000001015067825ULL, 0x000fe200078e0006ULL,
0x00000014242c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b1200720cULL, 0x000fe20003f26070ULL,
0x000000ffff1e7224ULL, 0x000fe200020e06ffULL, 0x00005e0009087a11ULL, 0x000fe200078840ffULL,
0x000000ffff1c7224ULL, 0x000fe200028e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078040ffULL,
0x000000082c2d7824ULL, 0x000fe200078e00ffULL, 0x00005e0011107a11ULL, 0x000fc400078640ffULL,
0x00005f0009097a11ULL, 0x000fe200020f441cULL, 0x000000012c1c7824ULL, 0x000fe200078e021fULL,
0x00000018242e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c24307810ULL, 0x000fe20007ffe0ffULL,
0x0000001015087825ULL, 0x000fe200078e0008ULL, 0x00005f0013137a11ULL, 0x000fe400000f4420ULL,
0x00005f0011117a11ULL, 0x000fe200018f441eULL, 0x000000012e1d7824ULL, 0x100fe200078e021fULL,
0x0000001c22207210ULL, 0x000fe20007f1e0ffULL, 0x00000001301e7824ULL, 0x000fe200078e021fULL,
0x0000000724257812ULL, 0x000fe200078e4800ULL, 0x000000082e2f7824ULL, 0x000fe200078e00ffULL,
0x0000000b2400720cULL, 0x000fe20003f66070ULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e00201c7a11ULL, 0x000fe200078040ffULL, 0x0000000830317824ULL, 0x000fe200078e00ffULL,
0x0000001d22217210ULL, 0x040fe20007f9e0ffULL, 0x0000001015127825ULL, 0x000fe200078e0012ULL,
0x0000001e221f7210ULL, 0x000fc40007fbe0ffULL, 0x0ffffff825257812ULL, 0x000fe200078ef800ULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x00005f00201d7a11ULL, 0x000fe200000f4423ULL,
0x000000ffff227224ULL, 0x000fe200028e06ffULL, 0x00005e0021207a11ULL, 0x000fe200078840ffULL,
0x0000001025237824ULL, 0x000fe200078e020eULL, 0x00005e001f1e7a11ULL, 0x000fe200078a40ffULL,
0x0000001015107825ULL, 0x000fe200078e0010ULL, 0x00005f0021217a11ULL, 0x000fe400020f4424ULL,
0x00005f001f1f7a11ULL, 0x000fe200028f4422ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c237faeULL, 0x0003e2000d901c46ULL, 0x0000000b2600720cULL, 0x080fe20003f06070ULL,
0x00000010151c7825ULL, 0x000fe200078e001cULL, 0x0000000b2a00720cULL, 0x000fc40003f66070ULL,
0x0000000b2c00720cULL, 0x080fe20003f86070ULL, 0x0000001015207825ULL, 0x040fe200078e0020ULL,
0x0000000b2e00720cULL, 0x080fe40003fa6070ULL, 0x0000000b3000720cULL, 0x000fe20003fc6070ULL,
0x00000010151e7825ULL, 0x000fe200078e001eULL, 0x000000002a0b7212ULL, 0x080fe400078e3cffULL,
0x0000000026287212ULL, 0x080fe200078e3cffULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x000000002c227212ULL, 0x080fe200078e3cffULL, 0x00000010290d7824ULL, 0x002fe200078e020eULL,
0x000000002e247212ULL, 0x000fc400078e3cffULL, 0xfffffff82b257812ULL, 0x000fe400078ee228ULL,
0x00000000300c7212ULL, 0x000fe400078e3cffULL, 0xfffffff82a2b7812ULL, 0x000fe200078ee20bULL,
0x00000010270b7824ULL, 0x000fe200078e020eULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL,
0x0000001025237824ULL, 0x000fe200078e020eULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL,
0x000000102b257824ULL, 0x000fe200078e020eULL, 0xfffffff831317812ULL, 0x000fe200078ee20cULL,
0x000000102d277824ULL, 0x100fe200078e020eULL, 0x00000000060b7faeULL, 0x0003e2000d101c46ULL,
0x000000102f297824ULL, 0x000fc400078e020eULL, 0x00000010312b7824ULL, 0x000fe200078e020eULL,
0x00000000120d7faeULL, 0x0003e8000c901c46ULL, 0x0000000010237faeULL, 0x0003e8000c101c46ULL,
0x0000000008257faeULL, 0x0003e8000d901c46ULL, 0x000000001c277faeULL, 0x0003e8000e101c46ULL,
0x0000000020297faeULL, 0x0003e8000e901c46ULL, 0x000000001e2b7faeULL, 0x0003e2000f101c46ULL,
0x000006b000007947ULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fe20000011600ULL,
0x0000200060077824ULL, 0x000fe200078e00ffULL, 0x0000000700067812ULL, 0x000fe200078ec0ffULL,
0x000010007a097824ULL, 0x000fe200078e00ffULL, 0x00000004080e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008620b7824ULL, 0x000fe200078e00ffULL, 0x00002000070c7812ULL, 0x000fc400078ec0ffULL,
0x0000000808117810ULL, 0x000fe20007ffe0ffULL, 0x000000080e107824ULL, 0x040fe200078e00ffULL,
0x000000000e077212ULL, 0x080fe200078e3cffULL, 0x000040005b0c7824ULL, 0x000fe200078e020cULL,
0x0000000011127212ULL, 0x040fe200078e3cffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x0000000108077824ULL, 0x100fe200078e021fULL,
0x0000100009097812ULL, 0x000fe200078e0cffULL, 0x0000000111117824ULL, 0x000fe200078e021fULL,
0xfffffff8131c7812ULL, 0x000fc400078ee212ULL, 0x0000000722077210ULL, 0x000fe40007f1e0ffULL,
0x0000000c08127810ULL, 0x000fe40007ffe0ffULL, 0x000130000c0d7810ULL, 0x000fe20007ffe009ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x000000080b0b7812ULL, 0x000fe200078ee206ULL,
0x00000008121e7824ULL, 0x000fe200078e00ffULL, 0x0000001008157810ULL, 0x040fe40007ffe0ffULL,
0x00000014081d7810ULL, 0x000fc40007ffe0ffULL, 0x00005e0007067a11ULL, 0x000fe200078040ffULL,
0x0000000815207824ULL, 0x000fe200078e00ffULL, 0x0000000012097212ULL, 0x080fe200078e3cffULL,
0x000000081d247824ULL, 0x000fe200078e00ffULL, 0x00005f0007077a11ULL, 0x000fe400000f440cULL,
0x0000000015137212ULL, 0x0c0fe200078e3cffULL, 0x0000000115157824ULL, 0x000fe200078e021fULL,
0x000000001d217212ULL, 0x000fe200078e3cffULL, 0x000000100b067825ULL, 0x000fe200078e0006ULL,
0xfffffff81e1e7812ULL, 0x000fc400078ee209ULL, 0x00000018080c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e097824ULL, 0x000fe200078e021fULL, 0x0000001c08257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff820207812ULL, 0x000fe200078ee213ULL, 0x0000000112137824ULL, 0x000fe200078e021fULL,
0xfffffff824247812ULL, 0x000fe200078ee221ULL, 0x000000011d217824ULL, 0x100fe200078e021fULL,
0x00000009220e7210ULL, 0x000fe20007fde0ffULL, 0x000000010c237824ULL, 0x100fe200078e021fULL,
0x0000000708097812ULL, 0x000fe200078e4800ULL, 0x0000000125277824ULL, 0x040fe200078e021fULL,
0x0000001122127210ULL, 0x040fe20007fbe0ffULL, 0x0000000825287824ULL, 0x000fe200078e00ffULL,
0x0000001322137210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x00000015221d7210ULL, 0x000fe20007f7e0ffULL, 0x0000001020297824ULL, 0x100fe200078e020dULL,
0x0000002122217210ULL, 0x000fe20007f1e0ffULL, 0x00000010242b7824ULL, 0x000fe200078e020dULL,
0x00000023221f7210ULL, 0x000fc40007f3e0ffULL, 0x0000002722267210ULL, 0x000fe20007f5e0ffULL,
0x000000080c227824ULL, 0x040fe200078e00ffULL, 0x000000000c157212ULL, 0x080fe200078e3cffULL,
0x000000101e277824ULL, 0x100fe200078e020dULL, 0x0000000025237212ULL, 0x000fe200078e3cffULL,
0x000000101c257824ULL, 0x000fe200078e020dULL, 0x00005e000e087a11ULL, 0x000fe200078c40ffULL,
0x000000ffff247224ULL, 0x000fe200008e06ffULL, 0x0ffffff8090c7812ULL, 0x000fe200078ef800ULL,
0x000000ffff2f7224ULL, 0x000fe200010e06ffULL, 0xfffffff822227812ULL, 0x000fc400078ee215ULL,
0xfffffff828287812ULL, 0x000fe200078ee223ULL, 0x000000100c157824ULL, 0x000fe200078e020dULL,
0x00005f000e097a11ULL, 0x000fe200030f4411ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x00005e00120c7a11ULL, 0x000fe200078a40ffULL, 0x0000001010237824ULL, 0x100fe200078e020dULL,
0x00005e001f1e7a11ULL, 0x000fe200078240ffULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x00005e0013107a11ULL, 0x040fe200078840ffULL, 0x00000010222d7824ULL, 0x100fe200078e020dULL,
0x00005e0026207a11ULL, 0x000fe200078440ffULL, 0x0000001028317824ULL, 0x000fe200078e020dULL,
0x00005f00120d7a11ULL, 0x000fe200028f4411ULL, 0x000000ffff227224ULL, 0x000fe200000e06ffULL,
0x00005f0013117a11ULL, 0x000fe200020f440eULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x00005e001d127a11ULL, 0x000fe200078640ffULL, 0x000000100b087825ULL, 0x000fe200078e0008ULL,
0x00005e00211c7a11ULL, 0x000fe200078040ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006157faeULL, 0x0003e2000b901c46ULL, 0x00005f001d137a11ULL, 0x000fe200018f440eULL,
0x000000100b0c7825ULL, 0x000fe200078e000cULL, 0x00005f00211d7a11ULL, 0x000fe200000f4422ULL,
0x0000000008237faeULL, 0x0003e2000b901c46ULL, 0x00005f001f1f7a11ULL, 0x000fe200008f4424ULL,
0x000000100b107825ULL, 0x040fe200078e0010ULL, 0x00005f0026217a11ULL, 0x000fe200010f442fULL,
0x000000000c257faeULL, 0x0003e4000b901c46ULL, 0x000000100b127825ULL, 0x000fc400078e0012ULL,
0x0000000010277faeULL, 0x0003e4000b901c46ULL, 0x000000100b1c7825ULL, 0x040fe400078e001cULL,
0x0000000012297faeULL, 0x0003e4000b901c46ULL, 0x000000100b1e7825ULL, 0x040fe400078e001eULL,
0x000000001c2b7faeULL, 0x0003e4000b901c46ULL, 0x000000100b207825ULL, 0x000fc400078e0020ULL,
0x000000001e2d7faeULL, 0x0003e8000b901c46ULL, 0x0000000020317faeULL, 0x0003e4000b901c46ULL,
0x00000300ff757624ULL, 0x000fe200078e00ffULL, 0x0000000159067812ULL, 0x002fe200078ec0ffULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010600780cULL, 0x000fe40003f05070ULL, 0xffffffff75757811ULL, 0x000fc800078e08ffULL,
0x0000000175757807ULL, 0x000fca0004000000ULL, 0x0000000159597824ULL, 0x000fca00078e0275ULL,
0x000000165900720cULL, 0x000fda0003f06070ULL, 0x0000007504088210ULL, 0x000fe20007ffe078ULL,
0x00000004ff098424ULL, 0x000fc800078e00ffULL, 0x0000600008088625ULL, 0x000fca00078e0009ULL,
0x0000000608158981ULL, 0x000362000c1e1900ULL, 0xffffffe05a067812ULL, 0x040fe400078ec0ffULL,
0x000000105a077812ULL, 0x000fca00078ec0ffULL, 0x0000000106077824ULL, 0x000fe200078e0207ULL,
0x000000085a067812ULL, 0x000fca00078ec0ffULL, 0x0000000107067824ULL, 0x000fe200078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080006087f8cULL, 0x002fe8000c80043fULL,
0x01b60c00060b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x0000000862077824ULL, 0x000fe400078e0207ULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b000c7305ULL, 0x0002a4000021f000ULL,
0x3fa000000b0b7823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe20003800000ULL,
0x01b60c00070d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011600ULL, 0x0000002060087824ULL, 0x000fc600078e00ffULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0xffffff8008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fc800078ec0ffULL, 0x00000008090b7210ULL, 0x000fca0007ffe007ULL,
0x01b000000b0d7984ULL, 0x000e680000000800ULL, 0x01b200000b0c7984ULL, 0x0004e20000000800ULL,
0x000000020d00720bULL, 0x002fe20003f1d000ULL, 0x00010af27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b127812ULL, 0x000fe2000780c0ffULL,
0x000003e000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fd600078e00ffULL,
0x000003b000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe40000011660ULL,
0x000000020d00720bULL, 0x000fe40003f34000ULL, 0x000000600b00720cULL, 0x000fe20003f05270ULL,
0x00010ac27f007947ULL, 0x000ff4000b800000ULL, 0x00000000000b7806ULL, 0x000fe400008e0100ULL,
0x0000000d02117209ULL, 0x000fe20007810000ULL, 0x00000080600e8824ULL, 0x000fe200078e0207ULL,
0x0000ffff0b0b7812ULL, 0x000fc600078e3cffULL, 0x8000001102027221ULL, 0x000fe40000010000ULL,
0x00000001090e8824ULL, 0x000fe400078e020eULL, 0x3fb8aa3b02027820ULL, 0x000fc60000410000ULL,
0x01b400110e008388ULL, 0x0003e20000000800ULL, 0x00000002001e7308ULL, 0x0002a20000000800ULL,
0x0000000b12ff7212ULL, 0x000fe4000780c0ffULL, 0x00000002ff0b7819ULL, 0x000fe20000011600ULL,
0x00010a627f007947ULL, 0x000ff0000b800000ULL, 0x00001f0b1e027589ULL, 0x0062a400000e0000ULL,
0x000000080b0b7810ULL, 0x002fe20007ffe0ffULL, 0x00010aa27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b1e2f7589ULL, 0x00032400000e0000ULL, 0x800000110d0d0221ULL, 0x000fe20000010000ULL,
0x00000001ff107807ULL, 0x000fe20000000000ULL, 0x0000000219197220ULL, 0x004fe40000410000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc40000410000ULL, 0x0000000218187220ULL, 0x080fe40000410000ULL,
0x0000000d000a0308ULL, 0x000ea20000000800ULL, 0x0000000235357220ULL, 0x080fe40000410000ULL,
0x0000000234347220ULL, 0x080fe40000410000ULL, 0x0000000239397220ULL, 0x080fe40000410000ULL,
0x0000000238387220ULL, 0x080fe40000410000ULL, 0x000000023d3d7220ULL, 0x000fc40000410000ULL,
0x000000023c3c7220ULL, 0x080fe40000410000ULL, 0x0000000241417220ULL, 0x080fe40000410000ULL,
0x0000000240407220ULL, 0x080fe40000410000ULL, 0x0000000245457220ULL, 0x080fe40000410000ULL,
0x0000000244447220ULL, 0x080fe40000410000ULL, 0x0000000249497220ULL, 0x000fc40000410000ULL,
0x0000000248487220ULL, 0x080fe40000410000ULL, 0x000000024d4d7220ULL, 0x080fe40000410000ULL,
0x000000024c4c7220ULL, 0x000fe40000410000ULL, 0x0000001e03037220ULL, 0x000fe40000410000ULL,
0x0000002f1b1b7220ULL, 0x090fe40000410000ULL, 0x0000002f1a1a7220ULL, 0x000fc40000410000ULL,
0x0000002f37377220ULL, 0x080fe40000410000ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f3b3b7220ULL, 0x080fe40000410000ULL, 0x0000002f3a3a7220ULL, 0x080fe40000410000ULL,
0x0000002f3f3f7220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x000fc40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f47477220ULL, 0x080fe40000410000ULL, 0x0000002f46467220ULL, 0x080fe40000410000ULL,
0x0000002f4b4b7220ULL, 0x080fe40000410000ULL, 0x0000002f4a4a7220ULL, 0x000fc40000410000ULL,
0x0000002f4f4f7220ULL, 0x080fe40000410000ULL, 0x0000002f4e4e7220ULL, 0x000fe40000410000ULL,
0x000000ffff027224ULL, 0x000fe400078e0011ULL, 0x0000000a0c0c0220ULL, 0x00cfe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000aff0b723eULL, 0x002fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff0d7819ULL, 0x000fe40000011600ULL,
0x000054100b1e7816ULL, 0x000fe2000000000bULL, 0x000108227f007947ULL, 0x000fea000b800000ULL,
0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL, 0x00001f0d1e6d7589ULL, 0x0002a800000e0000ULL,
0x00001f0b1e6e7589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000100d1f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x00002d70001c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fc400078e00ffULL,
0x0001164000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000180d1f7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x00002dd0001c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fc400078e00ffULL,
0x000115e000007944ULL, 0x03cfea0003c00000ULL, 0x0000000260767824ULL, 0x040fe200078e00ffULL,
0x00000004ff667819ULL, 0x100fe20000011600ULL, 0x0000020060127824ULL, 0x000fe200078e00ffULL,
0x00000007000d7812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000476117812ULL, 0x000fe200078ec0ffULL, 0x000000030c037221ULL, 0x008fe20000010000ULL,
0x000000080d0e7812ULL, 0x000fc400078ef800ULL, 0xfffff800121d7812ULL, 0x000fe200078ec0ffULL,
0x0000000166137824ULL, 0x000fca00078e0211ULL, 0x0000000713117812ULL, 0x000fca00078e780eULL,
0x000000080e127824ULL, 0x000fe200078e0211ULL, 0x0000000800117812ULL, 0x000fc600078ec0ffULL,
0x00000010120c7824ULL, 0x000fc600078e021dULL, 0x00002000606b7824ULL, 0x000fe200078e00ffULL,
0x0000000711127812ULL, 0x000fe200078ec800ULL, 0x011000000c2c783bULL, 0x004e620000000200ULL,
0x00000002661f7810ULL, 0x000fe20007ffe0ffULL, 0x0000200062687824ULL, 0x000fe200078e00ffULL,
0xffffc0006b6b7812ULL, 0x000fe400078ec0ffULL, 0x0000000466217810ULL, 0x040fe40007ffe0ffULL,
0x0000000666237810ULL, 0x000fe20007ffe0ffULL, 0x00002000626b7824ULL, 0x000fe200078e026bULL,
0x0000006612667212ULL, 0x000fc400078e3cffULL, 0x0000001f121c7212ULL, 0x040fe400078e3cffULL,
0x0000002112647212ULL, 0x040fe400078e3cffULL, 0x00000023121e7212ULL, 0x000fe200078e3cffULL,
0x000010007a127824ULL, 0x000fe200078e026bULL, 0x0000000711117812ULL, 0x000fe400078ef800ULL,
0x0000000213137810ULL, 0x000fe40007ffe0ffULL, 0x0001300012127810ULL, 0x000fe20007ffe0ffULL,
0x00000008116c7824ULL, 0x000fe200078e0266ULL, 0x0000000713137812ULL, 0x000fe200078e780eULL,
0x00000008116a7824ULL, 0x040fe200078e021cULL, 0x0000008011637811ULL, 0x040fe200078e18ffULL,
0x0000000811697824ULL, 0x040fe200078e0264ULL, 0x00009910101f7816ULL, 0x000fe200000000ffULL,
0x0000000811677824ULL, 0x000fe200078e021eULL, 0xfffffff876767812ULL, 0x000fe200078ec0ffULL,
0x000000106c5c7824ULL, 0x100fe200078e0212ULL, 0x000000ff1f00720cULL, 0x000fe20003f05270ULL,
0x000000106a547824ULL, 0x000fc400078e0212ULL, 0x0000001069507824ULL, 0x100fe400078e0212ULL,
0x0000001067307824ULL, 0x000fe200078e0212ULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x000000080e0e7824ULL, 0x000fe400078e0213ULL, 0x000040005b137824ULL, 0x000fe200078e0268ULL,
0x000000005454783bULL, 0x000ee20000004200ULL, 0x000000100e0e7824ULL, 0x000fe400078e021dULL,
0x000010007a1d7824ULL, 0x000fe200078e0213ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000000166667824ULL, 0x100fe200078e0263ULL, 0x0000006d2c2c8231ULL, 0x082fe200003400ffULL,
0x000000011c657824ULL, 0x100fe200078e0263ULL, 0x000000003030783bULL, 0x000fe20000004200ULL,
0x000130001d1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000164647824ULL, 0x100fe200078e0263ULL,
0x0000006d2e2e8231ULL, 0x000fe200003400ffULL, 0x000000011e637824ULL, 0x000fe200078e0263ULL,
0x011000000e10783bULL, 0x000e620000000200ULL, 0x0000001066287824ULL, 0x100fe200078e021dULL,
0x0000006e2d2d8231ULL, 0x090fe200003400ffULL, 0x0000001065247824ULL, 0x100fe200078e021dULL,
0x0000006e2f2f8231ULL, 0x000fe200003400ffULL, 0x0000001064207824ULL, 0x000fc400078e021dULL,
0x00000010631d7824ULL, 0x000fe200078e021dULL, 0x000000002828783bULL, 0x000f280000004200ULL,
0x000000002424783bULL, 0x000f280000004200ULL, 0x000000002020783bULL, 0x000f280000004200ULL,
0x000000001d1c783bULL, 0x000f220000004200ULL, 0x0000005c2c4c723cULL, 0x044ff0000004184cULL,
0x0000005e2c48723cULL, 0x040ff00000041848ULL, 0x000000542c44723cULL, 0x008fe20000041844ULL,
0x0000006d10108231ULL, 0x002fc400003400ffULL, 0x0000006d12128231ULL, 0x000fe400003400ffULL,
0x0000006e11118231ULL, 0x080fe400003400ffULL, 0x0000006e13138231ULL, 0x000fe200003400ffULL,
0x000000562c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028104c723cULL, 0x050ff0000004184cULL,
0x0000002a1048723cULL, 0x040ff00000041848ULL, 0x000000241044723cULL, 0x040ff00000041844ULL,
0x000000261040723cULL, 0x040ff00000041840ULL, 0x00000020103c723cULL, 0x040ff0000004183cULL,
0x000000221038723cULL, 0x040ff00000041838ULL, 0x0000001c1034723cULL, 0x040ff00000041834ULL,
0x0000001e1018723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000004017107811ULL, 0x000fe200078e40ffULL, 0x01b6880076ff7f8cULL, 0x0003e2000c80043fULL,
0x000000017a7a7812ULL, 0x000fc400078e0cffULL, 0x000000611000720cULL, 0x000fda0003f06070ULL,
0x00004c3000000947ULL, 0x000fea0003800000ULL, 0x0000001060107824ULL, 0x002fe200078e00ffULL,
0x0000000117117810ULL, 0x000fe20007ffe0ffULL, 0x0000580015777a24ULL, 0x020fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000141100720cULL, 0x000fe20003f06070ULL,
0x0000008077777824ULL, 0x000fe200078e00ffULL, 0xffffffe010107812ULL, 0x000fca00078ec0ffULL,
0x0000010017107824ULL, 0x000fca00078e0210ULL, 0x00000080101c7810ULL, 0x000fc80007ffe0ffULL,
0x000000600f1e7812ULL, 0x000fe200078ef81cULL, 0x0000076000008947ULL, 0x000fea0003800000ULL,
0x0000200060117824ULL, 0x000fe200078e00ffULL, 0x00000003ff237819ULL, 0x000fe20000011600ULL,
0x0000100005107824ULL, 0x000fc600078e00ffULL, 0x0000200011207812ULL, 0x000fe400078ec0ffULL,
0x0000100010127812ULL, 0x000fe200078ec0ffULL, 0x0000000123107824ULL, 0x000fe200078e021eULL,
0x0000001c61117217ULL, 0x000fe20007800000ULL, 0x000040005b297824ULL, 0x000fe200078e0220ULL,
0x00000004231d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001077137210ULL, 0x000fe20007f3e0ffULL,
0x0000000111117824ULL, 0x000fe200078e0a1cULL, 0x0000001423317810ULL, 0x000fe20007ffe0ffULL,
0x000000011d107824ULL, 0x000fe200078e021eULL, 0x0001300029297810ULL, 0x000fe20007ffe012ULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x0000002011287817ULL, 0x000fe20003800000ULL,
0x0000000131227824ULL, 0x000fe200078e021eULL, 0x0000001077117210ULL, 0x000fe20007f5e0ffULL,
0x000000081d307824ULL, 0x000fe200078e00ffULL, 0x0000000823217810ULL, 0x000fc40007ffe0ffULL,
0x00005e0013267a11ULL, 0x000fe200078240ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078440ffULL, 0x0000000821327824ULL, 0x000fe200078e00ffULL,
0x0000000c232d7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0011117a11ULL, 0x000fe200010f4412ULL,
0x0000000121127824ULL, 0x000fe200078e021eULL, 0x0000002277227210ULL, 0x000fe20007f7e0ffULL,
0x000000082d557824ULL, 0x000fe200078e00ffULL, 0x00005f0013277a11ULL, 0x000fe200008f441cULL,
0x000000012d1c7824ULL, 0x000fe200078e021eULL, 0x00000010232f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x000000001d1f7212ULL, 0x000fc400078e3cffULL,
0x000000281d00720cULL, 0x000fe20003f06070ULL, 0x000000012f207824ULL, 0x000fe200078e021eULL,
0x00000000211d7212ULL, 0x040fe400078e3cffULL, 0x000000282100720cULL, 0x000fe40003f26070ULL,
0x0000001277217210ULL, 0x040fe40007f9e0ffULL, 0xfffffff830307812ULL, 0x000fe400078ee21fULL,
0x00005e0022127a11ULL, 0x000fe200078640ffULL, 0x000000ffff2e7224ULL, 0x000fe200020e06ffULL,
0x0000001c771f7210ULL, 0x000fc40007fbe0ffULL, 0xfffffff832327812ULL, 0x000fe400078ee21dULL,
0x00005f0022137a11ULL, 0x000fe200018f4413ULL, 0x0000000862227824ULL, 0x000fe200078e00ffULL,
0x00000020771d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200028e06ffULL,
0x00005e0021247a11ULL, 0x000fe400078840ffULL, 0x0000001823337810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005e001f207a11ULL, 0x000fc400078a40ffULL,
0x0000001c23537810ULL, 0x000fe40007ffe0ffULL, 0x00005f0021257a11ULL, 0x000fe400020f442eULL,
0x0000000822517812ULL, 0x000fe200078ee20dULL, 0x0000000133227824ULL, 0x100fe200078e021eULL,
0x00005e001d1c7a11ULL, 0x000fe200078440ffULL, 0x00000001531e7824ULL, 0x000fe200078e021eULL,
0x00005f001f217a11ULL, 0x000fe200028f442cULL, 0x0000001051267825ULL, 0x000fe200078e0026ULL,
0x00000007231f7812ULL, 0x000fc400078e4800ULL, 0x000000282300720cULL, 0x000fe20003f66070ULL,
0x0000001051107825ULL, 0x000fe200078e0010ULL, 0x00005f001d1d7a11ULL, 0x000fe400010f442aULL,
0x0ffffff81f2a7812ULL, 0x000fe200078ef800ULL, 0x0000001051247825ULL, 0x000fe200078e0024ULL,
0x0000002277237210ULL, 0x040fe40007f5e0ffULL, 0x0000001e771f7210ULL, 0x000fe20007fbe0ffULL,
0x000000102a2b7824ULL, 0x000fe200078e0229ULL, 0x00005e0023227a11ULL, 0x000fe200078840ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x000000282d00720cULL, 0x000fe20003f46070ULL,
0x000000ffff2a7224ULL, 0x000fe200028e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e2000d901c46ULL,
0x00005f0023237a11ULL, 0x000fe200020f442cULL, 0x0000001051207825ULL, 0x000fe200078e0020ULL,
0x00005f001f1f7a11ULL, 0x000fc400028f442aULL, 0x000000282f00720cULL, 0x080fe20003f66070ULL,
0x00000010511c7825ULL, 0x000fe200078e001cULL, 0x000000283100720cULL, 0x080fe40003f86070ULL,
0x000000283300720cULL, 0x080fe20003fa6070ULL, 0x0000001051127825ULL, 0x000fe200078e0012ULL,
0x000000285300720cULL, 0x000fe40003fc6070ULL, 0x000000002f287212ULL, 0x0c0fe200078e3cffULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x000000002d2e7212ULL, 0x080fe200078e3cffULL,
0x0000001030277824ULL, 0x102fe200078e0229ULL, 0x00000000312a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x00000000332c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000000053267212ULL, 0x040fe200078e3cffULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0xfffffff8552e7812ULL, 0x000fe200078ee22eULL,
0x00000010322b7824ULL, 0x000fe200078e0229ULL, 0xfffffff82f287812ULL, 0x000fe200078ee228ULL,
0x0000001051227825ULL, 0x000fe200078e0022ULL, 0xfffffff8312a7812ULL, 0x000fe200078ee22aULL,
0x0000000010277faeULL, 0x0003e2000c101c46ULL, 0xfffffff8332c7812ULL, 0x000fe200078ee22cULL,
0x000000102e2d7824ULL, 0x100fe200078e0229ULL, 0xfffffff853267812ULL, 0x000fe200078ee226ULL,
0x00000010282f7824ULL, 0x100fe200078e0229ULL, 0x00000000242b7faeULL, 0x0003e2000c901c46ULL,
0x000000102a317824ULL, 0x000fc400078e0229ULL, 0x000000102c337824ULL, 0x100fe200078e0229ULL,
0x00000000202d7faeULL, 0x0003e2000d101c46ULL, 0x0000001026297824ULL, 0x000fe400078e0229ULL,
0x00000010511e7825ULL, 0x000fe200078e001eULL, 0x000000001c2f7faeULL, 0x0003e8000d901c46ULL,
0x0000000012317faeULL, 0x0003e8000e101c46ULL, 0x0000000022337faeULL, 0x0003e8000e901c46ULL,
0x000000001e297faeULL, 0x0003e2000f101c46ULL, 0x000006a000007947ULL, 0x000fea0003800000ULL,
0x0000200060107824ULL, 0x000fe200078e00ffULL, 0x00000003ff137819ULL, 0x000fe20000011600ULL,
0x0000100005117824ULL, 0x000fc600078e00ffULL, 0x0000200010107812ULL, 0x000fe400078ec0ffULL,
0x0000000813237810ULL, 0x000fe40007ffe0ffULL, 0x0000100011117812ULL, 0x000fe200078ec0ffULL,
0x000040005b107824ULL, 0x000fe200078e0210ULL, 0x00000004131f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0x0000000c13277810ULL, 0x000fe40007ffe0ffULL,
0x00013000101c7810ULL, 0x000fe20007ffe011ULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x0000000023107212ULL, 0x000fe200078e3cffULL, 0x0000000827207824ULL, 0x000fe200078e00ffULL,
0x00000010132b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127247824ULL, 0x000fe200078e021eULL,
0x00000014132d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff825257812ULL, 0x000fe200078ee210ULL,
0x0000000113107824ULL, 0x000fe200078e021eULL, 0x000000001f127212ULL, 0x080fe200078e3cffULL,
0x000000082b337824ULL, 0x000fe200078e00ffULL, 0x0000000027117212ULL, 0x080fe200078e3cffULL,
0x000000082d227824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee212ULL,
0x000000012b267824ULL, 0x100fe200078e021eULL, 0xfffffff820297812ULL, 0x000fe200078ee211ULL,
0x000000011f207824ULL, 0x100fe200078e021eULL, 0x000000002b127212ULL, 0x080fe200078e3cffULL,
0x000000012d287824ULL, 0x040fe200078e021eULL, 0x000000002d1d7212ULL, 0x000fe200078e3cffULL,
0x00000010212d7824ULL, 0x000fe200078e021cULL, 0x00000018132f7810ULL, 0x000fc40007ffe0ffULL,
0x0000001077117210ULL, 0x000fe40007f1e0ffULL, 0x0000001c13317810ULL, 0x000fe20007ffe0ffULL,
0x000000082f2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee212ULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0xfffffff822517812ULL, 0x000fe200078ee21dULL,
0x0000000123227824ULL, 0x000fe200078e021eULL, 0x00000007131d7812ULL, 0x000fe200078e4800ULL,
0x000000012f2a7824ULL, 0x140fe200078e021eULL, 0x000000002f137212ULL, 0x080fe200078e3cffULL,
0x00000001312e7824ULL, 0x000fe200078e021eULL, 0x00005e0011107a11ULL, 0x000fe200078040ffULL,
0x00000008311f7824ULL, 0x040fe200078e00ffULL, 0x00000000311e7212ULL, 0x000fe200078e3cffULL,
0x00000010252f7824ULL, 0x100fe200078e021cULL, 0xfffffff82c137812ULL, 0x000fe200078ee213ULL,
0x0000001029317824ULL, 0x000fe200078e021cULL, 0x00005f0011117a11ULL, 0x000fe200000f4412ULL,
0x0000001033337824ULL, 0x100fe200078e021cULL, 0x0000002077207210ULL, 0x000fe20007f1e0ffULL,
0x0000001013557824ULL, 0x000fe200078e021cULL, 0x0ffffff81d1d7812ULL, 0x000fe200078ef800ULL,
0x0000001051517824ULL, 0x000fe200078e021cULL, 0x0000002477247210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee21eULL,
0x000000101d2b7824ULL, 0x100fe200078e021cULL, 0x0000002277227210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200010e06ffULL, 0x00005e00201e7a11ULL, 0x000fe200078040ffULL,
0x000000101f5d7824ULL, 0x000fe200078e021cULL, 0x00005e0024127a11ULL, 0x000fe200078440ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x00005e00221c7a11ULL, 0x000fe200078240ffULL,
0x00000008622c7824ULL, 0x000fe200078e00ffULL, 0x00005f00201f7a11ULL, 0x000fc400000f4413ULL,
0x00005f0024137a11ULL, 0x000fe400010f4421ULL, 0x00005f00221d7a11ULL, 0x000fe400008f441dULL,
0x0000002677217210ULL, 0x040fe40007f1e0ffULL, 0x000000082c297812ULL, 0x000fe400078ee20dULL,
0x0000002877237210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff287224ULL, 0x000fe200000e06ffULL,
0x0000002a772c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x0000002e772e7210ULL, 0x000fc40007f7e0ffULL, 0x00005e0021267a11ULL, 0x000fe200078040ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0023247a11ULL, 0x000fe200078240ffULL,
0x000000ffff537224ULL, 0x000fe200010e06ffULL, 0x00005e002c227a11ULL, 0x000fe200078440ffULL,
0x000000ffff577224ULL, 0x000fe200018e06ffULL, 0x00005e002e207a11ULL, 0x000fe200078640ffULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x00005f0021277a11ULL, 0x000fe200000f4428ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102b7faeULL, 0x0003e2000b901c46ULL,
0x00005f0023257a11ULL, 0x000fe200008f442aULL, 0x00000010291c7825ULL, 0x040fe200078e001cULL,
0x00005f002c237a11ULL, 0x000fe200010f4453ULL, 0x000000001e2d7faeULL, 0x0003e2000b901c46ULL,
0x00005f002e217a11ULL, 0x000fe200018f4457ULL, 0x0000001029127825ULL, 0x000fc400078e0012ULL,
0x000000001c2f7faeULL, 0x0003e4000b901c46ULL, 0x0000001029267825ULL, 0x040fe400078e0026ULL,
0x0000000012317faeULL, 0x0003e4000b901c46ULL, 0x0000001029247825ULL, 0x040fe400078e0024ULL,
0x0000000026337faeULL, 0x0003e4000b901c46ULL, 0x0000001029227825ULL, 0x000fc400078e0022ULL,
0x0000000024517faeULL, 0x0003e4000b901c46ULL, 0x0000001029207825ULL, 0x000fe400078e0020ULL,
0x0000000022557faeULL, 0x0003e8000b901c46ULL, 0x00000000205d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6280006107f8cULL, 0x002fe8000c80043fULL, 0x01b62c0006137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200137305ULL, 0x0002a4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x004fe40003800000ULL,
0x01b62c0006137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008007107810ULL, 0x000fca0007ffe008ULL,
0x0000000109107824ULL, 0x000fca00078e0210ULL, 0x01b0000010137984ULL, 0x000e680000000800ULL,
0x01b2000010127984ULL, 0x0004e20000000800ULL, 0x000000021300720bULL, 0x002fe20003f1d000ULL,
0x0000f1727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800000e0100ULL,
0x0000ffff101e7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff107424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000160117811ULL, 0x000fe400078ff0ffULL, 0x000000021300720bULL, 0x000fe40003f34000ULL,
0x000000601100720cULL, 0x000fe20003f05270ULL, 0x0000f1427f007947ULL, 0x000ff4000b800000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x0000001302207209ULL, 0x000fe20007810000ULL,
0x00000080601c8824ULL, 0x000fe200078e0207ULL, 0x0000ffff10117812ULL, 0x000fe400078e3cffULL,
0x00000002ff1f7819ULL, 0x000fe20000011600ULL, 0x8000002002027221ULL, 0x000fc40000010000ULL,
0x00000001091d8824ULL, 0x000fe400078e021cULL, 0x3fb8aa3b02027820ULL, 0x000fc60000410000ULL,
0x01b400201d008388ULL, 0x0003e20000000800ULL, 0x000000111eff7212ULL, 0x000fe4000780c0ffULL,
0x0000000200027308ULL, 0x000ea40000000800ULL, 0x0000000203037220ULL, 0x004fe20000410000ULL,
0x0000f0d27f007947ULL, 0x000fec000b800000ULL, 0x00001f1f022f7589ULL, 0x0022a400000e0000ULL,
0x0000002f4c4c7220ULL, 0x084fe40000410000ULL, 0x0000002f4d4d7220ULL, 0x080fe40000410000ULL,
0x0000002f48487220ULL, 0x000fc40000410000ULL, 0x0000002f49497220ULL, 0x080fe40000410000ULL,
0x0000002f44447220ULL, 0x080fe40000410000ULL, 0x0000002f45457220ULL, 0x080fe40000410000ULL,
0x0000002f40407220ULL, 0x080fe40000410000ULL, 0x0000002f41417220ULL, 0x080fe40000410000ULL,
0x0000002f3c3c7220ULL, 0x000fc40000410000ULL, 0x0000002f3d3d7220ULL, 0x080fe40000410000ULL,
0x0000002f38387220ULL, 0x080fe40000410000ULL, 0x0000002f39397220ULL, 0x080fe40000410000ULL,
0x0000002f34347220ULL, 0x080fe40000410000ULL, 0x0000002f35357220ULL, 0x080fe40000410000ULL,
0x0000002f18187220ULL, 0x000fc40000410000ULL, 0x0000002f19197220ULL, 0x000fe20000410000ULL,
0x0000f0127f007947ULL, 0x000fea000b800000ULL, 0x00001f0b022f7589ULL, 0x00052400000e0000ULL,
0x8000002013130221ULL, 0x000fe20000010000ULL, 0x00000001ff107807ULL, 0x000fe20000000000ULL,
0x0000002f4e4e7220ULL, 0x094fe40000410000ULL, 0x3fb8aa3b13130820ULL, 0x000fe40000410000ULL,
0x0000002f4f4f7220ULL, 0x080fe40000410000ULL, 0x00000013000a0308ULL, 0x000ea20000000800ULL,
0x0000002f4a4a7220ULL, 0x000fc40000410000ULL, 0x0000002f4b4b7220ULL, 0x080fe40000410000ULL,
0x0000002f46467220ULL, 0x080fe40000410000ULL, 0x0000002f47477220ULL, 0x080fe40000410000ULL,
0x0000002f42427220ULL, 0x080fe40000410000ULL, 0x0000002f43437220ULL, 0x080fe40000410000ULL,
0x0000002f3e3e7220ULL, 0x000fc40000410000ULL, 0x0000002f3f3f7220ULL, 0x080fe40000410000ULL,
0x0000002f3a3a7220ULL, 0x080fe40000410000ULL, 0x0000002f3b3b7220ULL, 0x080fe40000410000ULL,
0x0000002f36367220ULL, 0x080fe40000410000ULL, 0x0000002f37377220ULL, 0x080fe40000410000ULL,
0x0000002f1a1a7220ULL, 0x000fc40000410000ULL, 0x0000002f1b1b7220ULL, 0x000fe40000410000ULL,
0x000000ffff027224ULL, 0x002fe400078e0020ULL, 0x000000120a120220ULL, 0x00cfe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000aff1c723eULL, 0x000fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff1f7819ULL, 0x000fe40000011600ULL,
0x000054101c1e7816ULL, 0x000fe4000000001cULL, 0x000000181f117810ULL, 0x040fe40007ffe0ffULL,
0x000000101f137810ULL, 0x000fe20007ffe0ffULL, 0x0000ee927f007947ULL, 0x000fea000b800000ULL,
0x00001f1f1e797589ULL, 0x0002a800000e0000ULL, 0x00001f0b1e7a7589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff1f7224ULL, 0x002fe200078e0013ULL,
0x00004960001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000fa5000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff1f7224ULL, 0x002fe200078e0011ULL,
0x000049c0001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000f9f000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000312037221ULL, 0x008fe40000010000ULL,
0x00001000057c7824ULL, 0x000fe200078e00ffULL, 0x011800000c2c783bULL, 0x004ea20000000200ULL,
0x000000025b117824ULL, 0x000fe200078e0262ULL, 0x00009910101d7816ULL, 0x000fe400000000ffULL,
0x000010007c7c7812ULL, 0x000fc400078e0cffULL, 0x000000ff1d00720cULL, 0x000fe40003f05270ULL,
0x000130006b717810ULL, 0x100fe20007ffe07cULL, 0x00002000111c7824ULL, 0x000fe400078e007cULL,
0x011800000e10783bULL, 0x000ee40000000200ULL, 0x000000106c747824ULL, 0x100fe200078e0271ULL,
0x000130001c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000106a737824ULL, 0x100fe400078e0271ULL,
0x0000001069727824ULL, 0x100fe200078e0271ULL, 0x00000000745c783bULL, 0x000f620000004200ULL,
0x0000001067717824ULL, 0x000fc400078e0271ULL, 0x0000001066707824ULL, 0x100fe200078e021cULL,
0x000000007354783bULL, 0x000e620000004200ULL, 0x00000010656f7824ULL, 0x100fe400078e021cULL,
0x00000010646e7824ULL, 0x100fe200078e021cULL, 0x000000007250783bULL, 0x000f220000004200ULL,
0x00000010636d7824ULL, 0x000fc600078e021cULL, 0x000000007130783bULL, 0x002e680000004200ULL,
0x000000007028783bULL, 0x000e680000004200ULL, 0x000000006f24783bULL, 0x000e620000004200ULL,
0x000000792c2c8231ULL, 0x004fc600003400ffULL, 0x000000006e20783bULL, 0x000ea20000004200ULL,
0x000000792e2e8231ULL, 0x080fe400003400ffULL, 0x0000007a2d2d8231ULL, 0x090fe200003400ffULL,
0x000000006d1c783bULL, 0x000f220000004200ULL, 0x0000007a2f2f8231ULL, 0x080fe400003400ffULL,
0x0000007910108231ULL, 0x088fe400003400ffULL, 0x0000007912128231ULL, 0x000fe400003400ffULL,
0x0000007a11118231ULL, 0x000fc400003400ffULL, 0x0000007a13138231ULL, 0x000fe200003400ffULL,
0x0000005c2c4c723cULL, 0x060ff0000004184cULL, 0x0000005e2c48723cULL, 0x040ff00000041848ULL,
0x000000542c44723cULL, 0x040ff00000041844ULL, 0x000000562c40723cULL, 0x040ff00000041840ULL,
0x000000502c3c723cULL, 0x040ff0000004183cULL, 0x000000522c38723cULL, 0x040ff00000041838ULL,
0x000000302c34723cULL, 0x042ff00000041834ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x00000028104c723cULL, 0x040ff0000004184cULL, 0x0000002a1048723cULL, 0x040ff00000041848ULL,
0x000000241044723cULL, 0x040ff00000041844ULL, 0x000000261040723cULL, 0x040ff00000041840ULL,
0x00000020103c723cULL, 0x044ff0000004183cULL, 0x000000221038723cULL, 0x040ff00000041838ULL,
0x0000001c1034723cULL, 0x050ff00000041834ULL, 0x0000001e1018723cULL, 0x000fe20000041818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008017107811ULL, 0x000fe200078e40ffULL,
0x01b6900076ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001057a7812ULL, 0x000fc400078ec0ffULL,
0x000000611000720cULL, 0x000fda0003f06070ULL, 0x000032a000000947ULL, 0x000fea0003800000ULL,
0x0000001060107824ULL, 0x002fe200078e00ffULL, 0x0000000117117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000141100720cULL, 0x000fe40003f06070ULL,
0xffffffe010107812ULL, 0x000fca00078ec0ffULL, 0x0000010017107824ULL, 0x000fca00078e0210ULL,
0x000000c010127810ULL, 0x000fc80007ffe0ffULL, 0x000000600f157812ULL, 0x000fe200078ef812ULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x0000200060117824ULL, 0x000fe200078e00ffULL,
0x0000001261107217ULL, 0x000fe20007800000ULL, 0x00000008622c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff217819ULL, 0x000fe40000011600ULL, 0x00002000111c7812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a12ULL, 0x0000000421137810ULL, 0x040fe20007ffe0ffULL,
0x0000000121127824ULL, 0x040fe200078e0215ULL, 0x00000008211d7810ULL, 0x000fe20007ffe0ffULL,
0x000040005b117824ULL, 0x000fe200078e021cULL, 0x00000000131c7212ULL, 0x040fe200078e3cffULL,
0x0000000813297824ULL, 0x000fe200078e00ffULL, 0x0000001277127210ULL, 0x000fe20007f1e0ffULL,
0x000000081d2b7824ULL, 0x000fe200078e00ffULL, 0x00013000117c7810ULL, 0x000fc40007ffe07cULL,
0x0000002010287817ULL, 0x000fe20003800000ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e0012267a11ULL, 0x040fe200078040ffULL, 0x0000000113107824ULL, 0x000fe200078e0215ULL,
0xfffffff829297812ULL, 0x000fe400078ee21cULL, 0x000000001d1c7212ULL, 0x000fe400078e3cffULL,
0x0000000c212d7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0012277a11ULL, 0x000fc400000f4411ULL,
0x0000001077117210ULL, 0x000fe20007f1e0ffULL, 0x000000011d107824ULL, 0x100fe200078e0215ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21cULL, 0x000000012d1c7824ULL, 0x100fe200078e0215ULL,
0x00000010212f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x00000010771f7210ULL, 0x000fe20007f7e0ffULL, 0x000000082d2e7824ULL, 0x000fe200078e00ffULL,
0x00005e0011127a11ULL, 0x000fe200078040ffULL, 0x000000012f1e7824ULL, 0x000fe200078e0215ULL,
0x0000001c77107210ULL, 0x000fc40007f9e0ffULL, 0x000000281300720cULL, 0x080fe40003f46070ULL,
0x000000281d00720cULL, 0x000fe20003f26070ULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x00005f0011137a11ULL, 0x000fe200000f4420ULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x00005e0010227a11ULL, 0x000fe400078640ffULL, 0x0000001421317810ULL, 0x000fe40007ffe0ffULL,
0x0000001e771e7210ULL, 0x000fc40007fbe0ffULL, 0x00005f0010237a11ULL, 0x000fe200018f441dULL,
0x0000000131107824ULL, 0x000fe200078e0215ULL, 0x00005e001f247a11ULL, 0x000fe200078040ffULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x0000001821517810ULL, 0x040fe40007ffe0ffULL,
0x00005e001e1c7a11ULL, 0x000fe400078840ffULL, 0x0000001c21537810ULL, 0x000fe40007ffe0ffULL,
0x00005f001f257a11ULL, 0x000fc400000f4420ULL, 0x00000010771f7210ULL, 0x000fe20007f1e0ffULL,
0x0000000151107824ULL, 0x000fe200078e0215ULL, 0x00005f001e1d7a11ULL, 0x000fe200020f4411ULL,
0x00000001531e7824ULL, 0x000fe200078e0215ULL, 0x0000000721157812ULL, 0x040fe200078e4800ULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x000000282100720cULL, 0x000fe40003f66070ULL,
0x00005e001f207a11ULL, 0x000fe400078040ffULL, 0x0000001077117210ULL, 0x000fc40007f9e0ffULL,
0x0000001e77777210ULL, 0x000fe40007fbe0ffULL, 0x0ffffff815157812ULL, 0x000fe400078ef800ULL,
0x000000082c337812ULL, 0x000fe200078ee20dULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005f001f217a11ULL, 0x000fe200000f442aULL, 0x0000001015157824ULL, 0x000fe200078e027cULL,
0x000000002d1f7212ULL, 0x000fe200078e3cffULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005e00111e7a11ULL, 0x000fe200078840ffULL, 0x0000001033267825ULL, 0x000fe200078e0026ULL,
0x00005e0077107a11ULL, 0x000fc400078a40ffULL, 0x000000282d00720cULL, 0x080fe20003f06070ULL,
0x0000001033127825ULL, 0x000fe200078e0012ULL, 0xfffffff82e2d7812ULL, 0x000fe200078ee21fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026157faeULL, 0x0003e2000d901c46ULL,
0x00005f00111f7a11ULL, 0x000fe200020f442cULL, 0x0000001033247825ULL, 0x000fe200078e0024ULL,
0x00005f0077117a11ULL, 0x000fe400028f442aULL, 0x000000282f00720cULL, 0x080fe20003f66070ULL,
0x0000001033227825ULL, 0x000fe200078e0022ULL, 0x000000283100720cULL, 0x000fc40003f86070ULL,
0x000000285100720cULL, 0x080fe20003fa6070ULL, 0x00000010331c7825ULL, 0x000fe200078e001cULL,
0x000000285300720cULL, 0x000fe40003fc6070ULL, 0x000000002f287212ULL, 0x0c0fe200078e3cffULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x00000000312a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x00000000512c7212ULL, 0x080fe200078e3cffULL,
0x0000000853267824ULL, 0x042fe200078e00ffULL, 0x0000000053157212ULL, 0x000fe200078e3cffULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee228ULL,
0x000000102b277824ULL, 0x000fe200078e027cULL, 0xfffffff831317812ULL, 0x000fe200078ee22aULL,
0x0000001033207825ULL, 0x000fe200078e0020ULL, 0xfffffff826537812ULL, 0x000fc400078ee215ULL,
0xfffffff851517812ULL, 0x000fe200078ee22cULL, 0x0000001029157824ULL, 0x100fe400078e027cULL,
0x000000102d297824ULL, 0x100fe400078e027cULL, 0x000000102f2b7824ULL, 0x100fe200078e027cULL,
0x0000000012157faeULL, 0x0003e2000d101c46ULL, 0x00000010312d7824ULL, 0x100fe400078e027cULL,
0x00000010512f7824ULL, 0x000fe200078e027cULL, 0x0000000024277faeULL, 0x0003e2000c901c46ULL,
0x00000010331e7825ULL, 0x000fc600078e001eULL, 0x0000000022297faeULL, 0x0003e2000c101c46ULL,
0x0000001053317824ULL, 0x000fe400078e027cULL, 0x0000001033107825ULL, 0x000fe200078e0010ULL,
0x000000001c2b7faeULL, 0x0003e8000d901c46ULL, 0x00000000202d7faeULL, 0x0003e8000e101c46ULL,
0x000000001e2f7faeULL, 0x0003e8000e901c46ULL, 0x0000000010317faeULL, 0x0003e2000f101c46ULL,
0x0000068000007947ULL, 0x000fea0003800000ULL, 0x0000200060107824ULL, 0x000fe200078e00ffULL,
0x00000003ff127819ULL, 0x000fc80000011600ULL, 0x0000200010107812ULL, 0x000fe400078ec0ffULL,
0x0000000412137810ULL, 0x040fe40007ffe0ffULL, 0x00000008121d7810ULL, 0x000fe20007ffe0ffULL,
0x000040005b117824ULL, 0x000fe200078e0210ULL, 0x0000000013107212ULL, 0x0c0fe200078e3cffULL,
0x00000008131f7824ULL, 0x000fe200078e00ffULL, 0x000000001d1c7212ULL, 0x040fe200078e3cffULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0x00013000117c7810ULL, 0x000fc40007ffe07cULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL, 0x0000000112107824ULL, 0x140fe200078e0215ULL,
0x0000000c12207810ULL, 0x040fe40007ffe0ffULL, 0x0000001012247810ULL, 0x040fe20007ffe0ffULL,
0x000000101f2b7824ULL, 0x000fe200078e027cULL, 0x0000001412257810ULL, 0x000fe20007ffe0ffULL,
0x0000000820237824ULL, 0x000fe200078e00ffULL, 0x0000001077117210ULL, 0x000fe20007f1e0ffULL,
0x0000000824277824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee21cULL,
0x0000000825337824ULL, 0x040fe200078e00ffULL, 0x00000000201e7212ULL, 0x080fe200078e3cffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x0000000024227212ULL, 0x0c0fe200078e3cffULL,
0x0000000124247824ULL, 0x000fe200078e0215ULL, 0x0000000025267212ULL, 0x000fe200078e3cffULL,
0x00000010212d7824ULL, 0x000fe200078e027cULL, 0x00005e0011107a11ULL, 0x000fc400078040ffULL,
0x0000001812287810ULL, 0x040fe40007ffe0ffULL, 0x0000001c12297810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823237812ULL, 0x000fe200078ee21eULL, 0x000000011d1e7824ULL, 0x100fe200078e0215ULL,
0xfffffff827277812ULL, 0x000fe200078ee222ULL, 0x0000000120227824ULL, 0x100fe200078e0215ULL,
0xfffffff833337812ULL, 0x000fe200078ee226ULL, 0x0000000125267824ULL, 0x100fe200078e0215ULL,
0x00005f0011117a11ULL, 0x000fe200000f441cULL, 0x00000001131c7824ULL, 0x100fe200078e0215ULL,
0x0000000712137812ULL, 0x000fe200078e4800ULL, 0x00000001282c7824ULL, 0x140fe200078e0215ULL,
0x0000001e77207210ULL, 0x000fe20007fbe0ffULL, 0x00000001292e7824ULL, 0x000fe200078e0215ULL,
0x0000000028157212ULL, 0x040fe200078e3cffULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000001c771c7210ULL, 0x000fe20007fde0ffULL, 0x0000000829537824ULL, 0x040fe200078e00ffULL,
0x00000000291e7212ULL, 0x000fe200078e3cffULL, 0x00000010232f7824ULL, 0x000fe200078e027cULL,
0xfffffff828517812ULL, 0x000fe200078ee215ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x0ffffff813157812ULL, 0x000fe200078ef800ULL, 0x0000001027317824ULL, 0x100fe200078e027cULL,
0x0000002277227210ULL, 0x000fe20007f9e0ffULL, 0x0000001033337824ULL, 0x100fe200078e027cULL,
0x00005e001c127a11ULL, 0x000fe200078c40ffULL, 0x0000001015297824ULL, 0x000fe200078e027cULL,
0x0000002477257210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0xfffffff853537812ULL, 0x000fe200078ee21eULL, 0x0000000862247824ULL, 0x000fe200078e00ffULL,
0x00000026772a7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x00005f001c137a11ULL, 0x000fe200030f441dULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x00005e00201e7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff217224ULL, 0x000fe200000e06ffULL,
0x0000002c772c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001053557824ULL, 0x100fe200078e027cULL,
0x0000002e772e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001051517824ULL, 0x000fe200078e027cULL,
0x00005e00221c7a11ULL, 0x000fe200078840ffULL, 0x000000ffff237224ULL, 0x000fe200008e06ffULL,
0x00005f00201f7a11ULL, 0x000fe200028f4415ULL, 0x000000ffff537224ULL, 0x000fe200010e06ffULL,
0x0000000824157812ULL, 0x000fc400078ee20dULL, 0x00005e0025267a11ULL, 0x000fe400078640ffULL,
0x00005f00221d7a11ULL, 0x000fe200020f441dULL, 0x0000001015107825ULL, 0x040fe200078e0010ULL,
0x00005e002a247a11ULL, 0x000fe400078040ffULL, 0x00005e002c227a11ULL, 0x000fe200078240ffULL,
0x0000001015127825ULL, 0x000fe200078e0012ULL, 0x00005e002e207a11ULL, 0x000fe200078440ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0003e2000b901c46ULL,
0x00005f0025277a11ULL, 0x000fe200018f4428ULL, 0x00000010151e7825ULL, 0x040fe200078e001eULL,
0x00005f002a257a11ULL, 0x000fe200000f4421ULL, 0x00000000122b7faeULL, 0x0003e2000b901c46ULL,
0x00005f002c237a11ULL, 0x000fe200008f4423ULL, 0x00000010151c7825ULL, 0x040fe200078e001cULL,
0x00005f002e217a11ULL, 0x000fe200010f4453ULL, 0x000000001e2d7faeULL, 0x0003e4000b901c46ULL,
0x0000001015267825ULL, 0x000fc400078e0026ULL, 0x000000001c2f7faeULL, 0x0003e4000b901c46ULL,
0x0000001015247825ULL, 0x040fe400078e0024ULL, 0x0000000026317faeULL, 0x0003e4000b901c46ULL,
0x0000001015227825ULL, 0x040fe400078e0022ULL, 0x0000000024337faeULL, 0x0003e4000b901c46ULL,
0x0000001015207825ULL, 0x000fc400078e0020ULL, 0x0000000022517faeULL, 0x0003e8000b901c46ULL,
0x0000000020557faeULL, 0x0003e4000b901c46ULL, 0x0000000178597824ULL, 0x000fe400078e0275ULL,
0x00000300ff107624ULL, 0x002fe400078e00ffULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x0000000159117812ULL, 0x000fe400078ec0ffULL, 0xffffffff10107811ULL, 0x000fc400078e08ffULL,
0x000000011100780cULL, 0x000fc80003f05070ULL, 0x0000000110107807ULL, 0x000fca0004000000ULL,
0x0000000159597824ULL, 0x000fca00078e0210ULL, 0x000000165900720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000159107824ULL, 0x000fe400078e0204ULL,
0x00000004ff117424ULL, 0x000fc800078e00ffULL, 0x0000600010107625ULL, 0x000fca00078e0011ULL,
0x0000000610157981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6480006107f8cULL, 0x002fe8000c80043fULL,
0x01b64c0006137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0xffffffe05a137812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff127424ULL, 0x000fe200078e00ffULL, 0x000000105a1c7812ULL, 0x000fc400078ec0ffULL,
0x000000085a1d7812ULL, 0x000fc800078ec0ffULL, 0x000000131d137210ULL, 0x000fe40007ffe01cULL,
0x00000012001c7305ULL, 0x0002a4000021f000ULL, 0x3fa0000012127823ULL, 0x002fe200000100ffULL,
0x0000001c0000735dULL, 0x004fe20003800000ULL, 0x01b64c00131d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010007107810ULL, 0x000fca0007ffe008ULL, 0x0000000109107824ULL, 0x000fca00078e0210ULL,
0x01b0000010137984ULL, 0x000e680000000800ULL, 0x01b2000010127984ULL, 0x0004e20000000800ULL,
0x000000021300720bULL, 0x002fe20003f1d000ULL, 0x0000d9727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff101e7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000260117811ULL, 0x000fe400078ff0ffULL,
0x000000021300720bULL, 0x000fe40003f34000ULL, 0x000000601100720cULL, 0x000fe20003f05270ULL,
0x0000d9427f007947ULL, 0x000ff4000b800000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x0000001302117209ULL, 0x000fe20007810000ULL, 0x0000008060208824ULL, 0x000fe200078e0207ULL,
0x0000ffff101d7812ULL, 0x000fe400078e3cffULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x80000011021c7221ULL, 0x000fc40000010000ULL, 0x0000000109228824ULL, 0x000fe400078e0220ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc60000410000ULL, 0x01b4001122008388ULL, 0x0003e20000000800ULL,
0x0000001c00207308ULL, 0x000ea20000000800ULL, 0x0000001d1eff7212ULL, 0x000fe2000780c0ffULL,
0x0000002003037220ULL, 0x004fe20000410000ULL, 0x0000d8d27f007947ULL, 0x000ff2000b800000ULL,
0x00001f1f202f7589ULL, 0x0022a400000e0000ULL, 0x0000002f4c4c7220ULL, 0x084fe40000410000ULL,
0x0000002f4d4d7220ULL, 0x080fe40000410000ULL, 0x0000002f48487220ULL, 0x080fe40000410000ULL,
0x0000002f49497220ULL, 0x000fc40000410000ULL, 0x0000002f44447220ULL, 0x080fe40000410000ULL,
0x0000002f45457220ULL, 0x080fe40000410000ULL, 0x0000002f40407220ULL, 0x080fe40000410000ULL,
0x0000002f41417220ULL, 0x080fe40000410000ULL, 0x0000002f3c3c7220ULL, 0x080fe40000410000ULL,
0x0000002f3d3d7220ULL, 0x000fc40000410000ULL, 0x0000002f38387220ULL, 0x080fe40000410000ULL,
0x0000002f39397220ULL, 0x080fe40000410000ULL, 0x0000002f34347220ULL, 0x080fe40000410000ULL,
0x0000002f35357220ULL, 0x080fe40000410000ULL, 0x0000002f18187220ULL, 0x080fe40000410000ULL,
0x0000002f19197220ULL, 0x000fe20000410000ULL, 0x0000d8127f007947ULL, 0x000fea000b800000ULL,
0x00001f0b202f7589ULL, 0x00052400000e0000ULL, 0x0000001302027209ULL, 0x000fe20007810000ULL,
0x0000002f4e4e7220ULL, 0x094fe20000410000ULL, 0x00000001ff107807ULL, 0x000fe20000000000ULL,
0x0000002f4f4f7220ULL, 0x000fc40000410000ULL, 0x8000000213130221ULL, 0x000fe40000010000ULL,
0x0000002f4a4a7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b13130820ULL, 0x000fe40000410000ULL,
0x0000002f4b4b7220ULL, 0x080fe40000410000ULL, 0x00000013000a0308ULL, 0x000ea20000000800ULL,
0x0000002f46467220ULL, 0x080fe40000410000ULL, 0x0000002f47477220ULL, 0x000fc40000410000ULL,
0x0000002f42427220ULL, 0x080fe40000410000ULL, 0x0000002f43437220ULL, 0x080fe40000410000ULL,
0x0000002f3e3e7220ULL, 0x080fe40000410000ULL, 0x0000002f3f3f7220ULL, 0x080fe40000410000ULL,
0x0000002f3a3a7220ULL, 0x080fe40000410000ULL, 0x0000002f3b3b7220ULL, 0x000fc40000410000ULL,
0x0000002f36367220ULL, 0x080fe40000410000ULL, 0x0000002f37377220ULL, 0x080fe40000410000ULL,
0x0000002f1a1a7220ULL, 0x080fe40000410000ULL, 0x0000002f1b1b7220ULL, 0x000fe40000410000ULL,
0x000000120a120220ULL, 0x00cfe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000aff1c723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff1f7819ULL, 0x002fe40000011600ULL, 0x000054101c1e7816ULL, 0x000fe4000000001cULL,
0x000000181f117810ULL, 0x040fe40007ffe0ffULL, 0x000000101f137810ULL, 0x000fe20007ffe0ffULL,
0x0000d6927f007947ULL, 0x000fea000b800000ULL, 0x00001f1f1e757589ULL, 0x0002a800000e0000ULL,
0x00001f0b1e787589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e0013ULL, 0x000063b0001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000e00000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e0011ULL, 0x00006410001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000dfa000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000312037221ULL, 0x008fe40000010000ULL, 0x0000100005117824ULL, 0x000fe200078e00ffULL,
0x012000000c2c783bULL, 0x004ea20000000200ULL, 0x000040005b1f7824ULL, 0x002fe200078e0268ULL,
0x00009910101d7816ULL, 0x000fe400000000ffULL, 0x00001000111c7812ULL, 0x000fc400078ec0ffULL,
0x012000000e10783bULL, 0x000e620000000200ULL, 0x000000ff1d00720cULL, 0x000fe40003f05270ULL,
0x000130006b6b7810ULL, 0x100fe40007ffe01cULL, 0x000130001f1c7810ULL, 0x000fc60007ffe01cULL,
0x000000106c5c7824ULL, 0x100fe400078e026bULL, 0x000000106a547824ULL, 0x100fe400078e026bULL,
0x0000001069507824ULL, 0x100fe400078e026bULL, 0x0000001067307824ULL, 0x000fe200078e026bULL,
0x000000005c5c783bULL, 0x000ee20000004200ULL, 0x0000001066287824ULL, 0x100fe400078e021cULL,
0x0000001065247824ULL, 0x100fe200078e021cULL, 0x000000005454783bULL, 0x000f220000004200ULL,
0x0000001064207824ULL, 0x000fc400078e021cULL, 0x00000010631c7824ULL, 0x000fe200078e021cULL,
0x000000005050783bULL, 0x000f280000004200ULL, 0x000000003030783bULL, 0x000f280000004200ULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x000000752c2c8231ULL, 0x004fc600003400ffULL,
0x000000002424783bULL, 0x000ea20000004200ULL, 0x000000752e2e8231ULL, 0x080fe400003400ffULL,
0x000000782d2d8231ULL, 0x090fe200003400ffULL, 0x000000002020783bULL, 0x000f220000004200ULL,
0x000000782f2f8231ULL, 0x080fe400003400ffULL, 0x0000007510108231ULL, 0x082fe200003400ffULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x0000007512128231ULL, 0x000fe400003400ffULL,
0x0000007811118231ULL, 0x000fc400003400ffULL, 0x0000007813138231ULL, 0x000fe200003400ffULL,
0x0000005c2c4c723cULL, 0x048ff0000004184cULL, 0x0000005e2c48723cULL, 0x040ff00000041848ULL,
0x000000542c44723cULL, 0x040ff00000041844ULL, 0x000000562c40723cULL, 0x040ff00000041840ULL,
0x000000502c3c723cULL, 0x040ff0000004183cULL, 0x000000522c38723cULL, 0x040ff00000041838ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x00000028104c723cULL, 0x040ff0000004184cULL, 0x0000002a1048723cULL, 0x040ff00000041848ULL,
0x000000241044723cULL, 0x044ff00000041844ULL, 0x000000261040723cULL, 0x040ff00000041840ULL,
0x00000020103c723cULL, 0x050ff0000004183cULL, 0x000000221038723cULL, 0x040ff00000041838ULL,
0x0000001c1034723cULL, 0x042ff00000041834ULL, 0x0000001e1018723cULL, 0x000fe20000041818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000c017107811ULL, 0x000fe200078e40ffULL,
0x01b6980076ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001057a7812ULL, 0x000fc400078e0cffULL,
0x000000611000720cULL, 0x000fda0003f06070ULL, 0x0000186000000947ULL, 0x000fea0003800000ULL,
0x0000030017137a10ULL, 0x002fe20007ffe0ffULL, 0x0000580015237a24ULL, 0x020fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000113117810ULL, 0x040fe20007ffe0ffULL,
0x0000010013127824ULL, 0x000fe400078e0258ULL, 0x0000008023237824ULL, 0x000fe200078e00ffULL,
0x000000141100720cULL, 0x000fe40003f06070ULL, 0x000000600f227812ULL, 0x000fd600078ef812ULL,
0x0000076000008947ULL, 0x000fea0003800000ULL, 0x0000001261107217ULL, 0x000fe20007800000ULL,
0x0000200060137824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fe20000011600ULL,
0x00000008621c7824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a12ULL,
0x0000200013127812ULL, 0x000fe200078ec0ffULL, 0x0000100005117824ULL, 0x000fe200078e00ffULL,
0x000000081c0d7812ULL, 0x000fe400078ee20dULL, 0x0000000425137810ULL, 0x000fe20007ffe0ffULL,
0x000040005b1c7824ULL, 0x000fe200078e0212ULL, 0x0000100011117812ULL, 0x000fe200078ec0ffULL,
0x0000000125127824ULL, 0x000fe200078e0222ULL, 0x00000000131d7212ULL, 0x040fe200078e3cffULL,
0x00000008131e7824ULL, 0x000fe200078e00ffULL, 0x000130001c2e7810ULL, 0x000fc40007ffe011ULL,
0x0000001223117210ULL, 0x000fe20007f1e0ffULL, 0x0000000113127824ULL, 0x000fe200078e0222ULL,
0x00000008251f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81e2d7812ULL, 0x000fe200078ee21dULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x0000002010287817ULL, 0x000fe20003800000ULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x00005e0011107a11ULL, 0x000fe200078040ffULL,
0x000000102d2d7824ULL, 0x000fe200078e022eULL, 0x000000001f1d7212ULL, 0x000fc400078e3cffULL,
0x0000000c25317810ULL, 0x040fe40007ffe0ffULL, 0x0000001025337810ULL, 0x000fe40007ffe0ffULL,
0x000000281300720cULL, 0x000fe20003f46070ULL, 0x0000000831307824ULL, 0x000fe200078e00ffULL,
0x00005f0011117a11ULL, 0x000fe200000f441cULL, 0x0000000133207824ULL, 0x100fe200078e0222ULL,
0xfffffff81e2f7812ULL, 0x000fe200078ee21dULL, 0x00000001311e7824ULL, 0x100fe200078e0222ULL,
0x0000001223137210ULL, 0x000fe20007f1e0ffULL, 0x000000011f1c7824ULL, 0x040fe200078e0222ULL,
0x000000281f00720cULL, 0x000fe20003f26070ULL, 0x000000100d107825ULL, 0x000fe200078e0010ULL,
0x0000001e231f7210ULL, 0x000fc40007f9e0ffULL, 0x00000020231d7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078040ffULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x0000001c23217210ULL, 0x000fe20007f7e0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e022eULL, 0x00005f0013137a11ULL, 0x000fe200000f4424ULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x0000001425517810ULL, 0x000fe20007ffe0ffULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x00005f001d1d7a11ULL, 0x000fc400020f4424ULL,
0x00005e0021207a11ULL, 0x000fe200078040ffULL, 0x0000000151247824ULL, 0x000fe200078e0222ULL,
0x00005e001f1e7a11ULL, 0x000fe200078640ffULL, 0x000000100d1c7825ULL, 0x000fe200078e001cULL,
0x0000001825537810ULL, 0x040fe40007ffe0ffULL, 0x0000001c25557810ULL, 0x000fe40007ffe0ffULL,
0x00005f0021217a11ULL, 0x000fe400000f442aULL, 0x00005f001f1f7a11ULL, 0x000fe200018f4426ULL,
0x0000000155267824ULL, 0x100fe200078e0222ULL, 0x0000002423297210ULL, 0x000fe20007f1e0ffULL,
0x0000000153247824ULL, 0x000fe200078e0222ULL, 0x00000007252b7812ULL, 0x000fe200078e4800ULL,
0x000000100d207825ULL, 0x000fe200078e0020ULL, 0x000000282500720cULL, 0x000fc40003f66070ULL,
0x0000002423277210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200000e06ffULL,
0x00005e0029227a11ULL, 0x000fe200078040ffULL, 0x000000100d1e7825ULL, 0x000fe200078e001eULL,
0x0000002623257210ULL, 0x000fe40007fbe0ffULL, 0x0ffffff82b2b7812ULL, 0x000fe200078ef800ULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x00005f0029237a11ULL, 0x000fe200000f442aULL,
0x000000ffff2a7224ULL, 0x000fe200028e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078840ffULL,
0x000000102b2b7824ULL, 0x000fe200078e022eULL, 0x00005e0025247a11ULL, 0x000fe200078a40ffULL,
0x000000100d227825ULL, 0x000fe200078e0022ULL, 0x00005f0027277a11ULL, 0x000fc400020f442cULL,
0x00005f0025257a11ULL, 0x000fe200028f442aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e2000d901c46ULL, 0x000000283100720cULL, 0x080fe20003f06070ULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x000000283300720cULL, 0x080fe20003f66070ULL,
0x00000000122d7faeULL, 0x0005e2000d101c46ULL, 0x000000285100720cULL, 0x080fe20003f86070ULL,
0x000000100d247825ULL, 0x000fe200078e0024ULL, 0x000000285300720cULL, 0x080fe20003fa6070ULL,
0x00000000202f7faeULL, 0x0005e2000c901c46ULL, 0x000000285500720cULL, 0x000fc40003fc6070ULL,
0x0000000033287212ULL, 0x0c0fe200078e3cffULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000000031297212ULL, 0x080fe200078e3cffULL, 0x0000000853317824ULL, 0x000fe200078e00ffULL,
0x00000000512a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0x0000000055107212ULL, 0x0c2fe200078e3cffULL, 0x0000000855557824ULL, 0x000fe200078e00ffULL,
0x00000000532c7212ULL, 0x000fe400078e3cffULL, 0xfffffff830297812ULL, 0x000fc400078ee229ULL,
0xfffffff833117812ULL, 0x000fe400078ee228ULL, 0xfffffff8512b7812ULL, 0x000fe200078ee22aULL,
0x0000001029297824ULL, 0x000fe200078e022eULL, 0xfffffff831317812ULL, 0x000fe200078ee22cULL,
0x0000001011117824ULL, 0x000fe200078e022eULL, 0xfffffff855337812ULL, 0x000fe200078ee210ULL,
0x000000102b2b7824ULL, 0x100fe200078e022eULL, 0x000000001e297faeULL, 0x0005e2000c101c46ULL,
0x0000001031317824ULL, 0x100fe400078e022eULL, 0x0000001033337824ULL, 0x000fe200078e022eULL,
0x000000001c117faeULL, 0x0005e8000d901c46ULL, 0x00000000222b7faeULL, 0x0005e8000e101c46ULL,
0x0000000026317faeULL, 0x0005e8000e901c46ULL, 0x0000000024337faeULL, 0x0005e2000f101c46ULL,
0x000006a000007947ULL, 0x000fea0003800000ULL, 0x0000200060117824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe20000011600ULL, 0x0000100005107824ULL, 0x000fc400078e00ffULL,
0x00000008621e7824ULL, 0x000fe200078e00ffULL, 0x0000200011127812ULL, 0x000fe400078ec0ffULL,
0x00000004131f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000813217810ULL, 0x000fe20007ffe0ffULL,
0x000040005b117824ULL, 0x000fe200078e0212ULL, 0x0000100010107812ULL, 0x000fe200078ec0ffULL,
0x000000081f257824ULL, 0x040fe200078e00ffULL, 0x000000001f127212ULL, 0x080fe200078e3cffULL,
0x0000000821277824ULL, 0x040fe200078e00ffULL, 0x00000000211c7212ULL, 0x000fc400078e3cffULL,
0x00013000111d7810ULL, 0x000fe20007ffe010ULL, 0x0000000113107824ULL, 0x000fe200078e0222ULL,
0xfffffff825207812ULL, 0x000fe400078ee212ULL, 0xfffffff827247812ULL, 0x000fe400078ee21cULL,
0x0000000c13257810ULL, 0x040fe40007ffe0ffULL, 0x0000001013277810ULL, 0x040fe40007ffe0ffULL,
0x0000001413297810ULL, 0x000fe20007ffe0ffULL, 0x00000008252b7824ULL, 0x000fe200078e00ffULL,
0x0000001023117210ULL, 0x000fe20007f1e0ffULL, 0x00000008272d7824ULL, 0x000fe200078e00ffULL,
0x000000081e0d7812ULL, 0x000fe200078ee20dULL, 0x00000008292f7824ULL, 0x000fe200078e00ffULL,
0x00000000251c7212ULL, 0x080fe200078e3cffULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00000000271e7212ULL, 0x0c0fe200078e3cffULL, 0x00000001272a7824ULL, 0x000fe200078e0222ULL,
0xfffffff82b287812ULL, 0x000fe200078ee21cULL, 0x00000001211c7824ULL, 0x100fe200078e0222ULL,
0x0000000029267212ULL, 0x040fe200078e3cffULL, 0x00000001292e7824ULL, 0x000fe200078e0222ULL,
0x00005e0011107a11ULL, 0x000fc400078040ffULL, 0xfffffff82d2c7812ULL, 0x000fe400078ee21eULL,
0x00000018132b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c132d7810ULL, 0x000fe20007ffe0ffULL,
0x000000102c317824ULL, 0x100fe200078e021dULL, 0xfffffff82f307812ULL, 0x000fe200078ee226ULL,
0x0000000125267824ULL, 0x000fe200078e0222ULL, 0x00005f0011117a11ULL, 0x000fe200000f4412ULL,
0x000000011f127824ULL, 0x000fe200078e0222ULL, 0x0000000713137812ULL, 0x000fe200078e4800ULL,
0x000000012b327824ULL, 0x100fe200078e0222ULL, 0x0000001c23217210ULL, 0x000fe20007fbe0ffULL,
0x000000012d227824ULL, 0x000fe200078e0222ULL, 0x00000012231e7210ULL, 0x000fe20007fde0ffULL,
0x000000082d507824ULL, 0x000fe200078e00ffULL, 0x0000002623267210ULL, 0x040fe20007f9e0ffULL,
0x00000010282f7824ULL, 0x100fe200078e021dULL, 0x0000002223277210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x000000002b227212ULL, 0x040fe200078e3cffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000002a232a7210ULL, 0x040fe20007f7e0ffULL,
0x0000001030337824ULL, 0x000fe200078e021dULL, 0x0000002e232e7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x0000003223327210ULL, 0x000fe20007f3e0ffULL,
0x000000100d107825ULL, 0x000fe200078e0010ULL, 0x000000002d237212ULL, 0x000fc400078e3cffULL,
0x00005e001e127a11ULL, 0x000fe200078c40ffULL, 0x00000010242d7824ULL, 0x100fe200078e021dULL,
0x0ffffff8131c7812ULL, 0x000fe200078ef800ULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0xfffffff82b227812ULL, 0x000fe200078ee222ULL, 0x00000010202b7824ULL, 0x000fe200078e021dULL,
0xfffffff850507812ULL, 0x000fe200078ee223ULL, 0x000000ffff207224ULL, 0x000fe200028e06ffULL,
0x00005f001e137a11ULL, 0x000fe200030f441fULL, 0x000000101c297824ULL, 0x100fe200078e021dULL,
0x00005e00211e7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x00005e00261c7a11ULL, 0x000fe200078840ffULL, 0x0000001022517824ULL, 0x100fe200078e021dULL,
0x00005f00211f7a11ULL, 0x000fe200028f4420ULL, 0x0000001050537824ULL, 0x000fe200078e021dULL,
0x00005f00261d7a11ULL, 0x000fe200020f4423ULL, 0x000000ffff217224ULL, 0x000fe200018e06ffULL,
0x00005e002a207a11ULL, 0x000fe200078640ffULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e002e227a11ULL, 0x000fe200078040ffULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x00005e0032247a11ULL, 0x000fe200078240ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010297faeULL, 0x0003e2000b901c46ULL, 0x00005e0027267a11ULL, 0x000fe200078440ffULL,
0x000000100d1e7825ULL, 0x040fe200078e001eULL, 0x00005f002a217a11ULL, 0x000fe200018f4421ULL,
0x00000000122b7faeULL, 0x0003e2000b901c46ULL, 0x00005f002e237a11ULL, 0x000fe200000f4423ULL,
0x000000100d1c7825ULL, 0x000fe200078e001cULL, 0x00005f0032257a11ULL, 0x000fe200008f4425ULL,
0x000000001e2d7faeULL, 0x0003e2000b901c46ULL, 0x00005f0027277a11ULL, 0x000fe200010f4428ULL,
0x000000100d207825ULL, 0x000fc400078e0020ULL, 0x000000001c2f7faeULL, 0x0003e4000b901c46ULL,
0x000000100d227825ULL, 0x040fe400078e0022ULL, 0x0000000020317faeULL, 0x0003e4000b901c46ULL,
0x000000100d247825ULL, 0x040fe400078e0024ULL, 0x0000000022337faeULL, 0x0003e4000b901c46ULL,
0x000000100d267825ULL, 0x000fc400078e0026ULL, 0x0000000024517faeULL, 0x0003e8000b901c46ULL,
0x0000000026537faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6680006107f8cULL, 0x006fe8000c80043fULL,
0x01b66c00060d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc40007804811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0d7424ULL, 0x000fc800078e00ffULL,
0x0000000d00127305ULL, 0x0002a4000021f000ULL, 0x3fa000000d0d7823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe20003800000ULL, 0x01b66c0006137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018007087810ULL, 0x000fca0007ffe008ULL, 0x0000000109087824ULL, 0x000fca00078e0208ULL,
0x01b00000080d7984ULL, 0x000e680000000800ULL, 0x01b2000008067984ULL, 0x0004e20000000800ULL,
0x000000020d00720bULL, 0x002fe20003f1d000ULL, 0x0000c2627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x004fc800000e0100ULL, 0x0000ffff08127812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff087424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000360117811ULL, 0x000fe400078ff0ffULL,
0x000000020d00720bULL, 0x000fe40003f34000ULL, 0x000000601100720cULL, 0x000fe20003f05270ULL,
0x0000c2327f007947ULL, 0x000ff4000b800000ULL, 0x0000000000087806ULL, 0x000fe400008e0100ULL,
0x0000000d02107209ULL, 0x000fe20007810000ULL, 0x00000080601c8824ULL, 0x000fe200078e0207ULL,
0x0000ffff08077812ULL, 0x000fe400078e3cffULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x8000001002027221ULL, 0x000fc40000010000ULL, 0x0000000109098824ULL, 0x000fe400078e021cULL,
0x3fb8aa3b02027820ULL, 0x000fc60000410000ULL, 0x01b4001009008388ULL, 0x0003e20000000800ULL,
0x00000002001e7308ULL, 0x000ea20000000800ULL, 0x0000000712ff7212ULL, 0x000fe2000780c0ffULL,
0x0000001e03037220ULL, 0x004fe20000410000ULL, 0x0000c1c27f007947ULL, 0x000ff2000b800000ULL,
0x00001f1f1e2f7589ULL, 0x0022a400000e0000ULL, 0x0000002f4c4c7220ULL, 0x084fe40000410000ULL,
0x0000002f4d4d7220ULL, 0x080fe40000410000ULL, 0x0000002f48487220ULL, 0x080fe40000410000ULL,
0x0000002f49497220ULL, 0x000fc40000410000ULL, 0x0000002f44447220ULL, 0x080fe40000410000ULL,
0x0000002f45457220ULL, 0x080fe40000410000ULL, 0x0000002f40407220ULL, 0x080fe40000410000ULL,
0x0000002f41417220ULL, 0x080fe40000410000ULL, 0x0000002f3c3c7220ULL, 0x080fe40000410000ULL,
0x0000002f3d3d7220ULL, 0x000fc40000410000ULL, 0x0000002f38387220ULL, 0x080fe40000410000ULL,
0x0000002f39397220ULL, 0x080fe40000410000ULL, 0x0000002f34347220ULL, 0x080fe40000410000ULL,
0x0000002f35357220ULL, 0x080fe40000410000ULL, 0x0000002f18187220ULL, 0x080fe40000410000ULL,
0x0000002f19197220ULL, 0x000fe20000410000ULL, 0x0000c0f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b1e2f7589ULL, 0x00052400000e0000ULL, 0x800000100d0d0221ULL, 0x000fe20000010000ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000002f4e4e7220ULL, 0x014fc40000410000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fe40000410000ULL, 0x0000002f4f4f7220ULL, 0x080fe40000410000ULL,
0x0000000d000a0308ULL, 0x000ea20000000800ULL, 0x0000002f4a4a7220ULL, 0x080fe40000410000ULL,
0x0000002f4b4b7220ULL, 0x080fe40000410000ULL, 0x0000002f46467220ULL, 0x080fe40000410000ULL,
0x0000002f47477220ULL, 0x000fc40000410000ULL, 0x0000002f42427220ULL, 0x080fe40000410000ULL,
0x0000002f43437220ULL, 0x080fe40000410000ULL, 0x0000002f3e3e7220ULL, 0x080fe40000410000ULL,
0x0000002f3f3f7220ULL, 0x080fe40000410000ULL, 0x0000002f3a3a7220ULL, 0x080fe40000410000ULL,
0x0000002f3b3b7220ULL, 0x000fc40000410000ULL, 0x0000002f36367220ULL, 0x080fe40000410000ULL,
0x0000002f37377220ULL, 0x080fe40000410000ULL, 0x0000002f1a1a7220ULL, 0x080fe40000410000ULL,
0x0000002f1b1b7220ULL, 0x000fe40000410000ULL, 0x000000ffff027224ULL, 0x000fe400078e0010ULL,
0x000000060a060220ULL, 0x00cfc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000aff07723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff1f7819ULL, 0x002fe40000011600ULL, 0x00005410071e7816ULL, 0x000fe40000000007ULL,
0x000000181f097810ULL, 0x040fe40007ffe0ffULL, 0x000000101f0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000bf627f007947ULL, 0x000fea000b800000ULL, 0x00001f1f1e077589ULL, 0x0002a800000e0000ULL,
0x00001f0b1e647589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e000dULL, 0x00007d10001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000c6a000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e0009ULL, 0x00007d70001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000c64000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000306037221ULL, 0x008fe40000010000ULL, 0x012800000c10783bULL, 0x000ee20000000200ULL,
0x0000991008067816ULL, 0x000fc600000000ffULL, 0x00000000741c783bULL, 0x002e620000004200ULL,
0x000000ff0600720cULL, 0x000fc60003f05270ULL, 0x000000007320783bULL, 0x000fe80000004200ULL,
0x000000007224783bULL, 0x000fe80000004200ULL, 0x000000007128783bULL, 0x000fe80000004200ULL,
0x012800000e2c783bULL, 0x004ea80000000200ULL, 0x000000007030783bULL, 0x000f680000004200ULL,
0x000000006f50783bULL, 0x000f280000004200ULL, 0x000000006e54783bULL, 0x000f280000004200ULL,
0x000000006d5c783bULL, 0x000f220000004200ULL, 0x0000000710108231ULL, 0x008fc400003400ffULL,
0x0000000712128231ULL, 0x000fe400003400ffULL, 0x0000006411118231ULL, 0x090fe400003400ffULL,
0x0000006413138231ULL, 0x000fce00003400ffULL, 0x0000001c104c723cULL, 0x002fe2000004184cULL,
0x000000072c2c8231ULL, 0x004fce00003400ffULL, 0x0000001e1048723cULL, 0x000fe20000041848ULL,
0x000000072e2e8231ULL, 0x000fe400003400ffULL, 0x000000642d2d8231ULL, 0x080fe400003400ffULL,
0x000000642f2f8231ULL, 0x000fc600003400ffULL, 0x000000201044723cULL, 0x040ff00000041844ULL,
0x000000221040723cULL, 0x040ff00000041840ULL, 0x00000024103c723cULL, 0x040ff0000004183cULL,
0x000000261038723cULL, 0x040ff00000041838ULL, 0x000000281034723cULL, 0x040ff00000041834ULL,
0x0000002a1018723cULL, 0x000ff00000041818ULL, 0x000000302c4c723cULL, 0x060ff0000004184cULL,
0x000000322c48723cULL, 0x040ff00000041848ULL, 0x000000502c44723cULL, 0x040ff00000041844ULL,
0x000000522c40723cULL, 0x040ff00000041840ULL, 0x000000542c3c723cULL, 0x040ff0000004183cULL,
0x000000562c38723cULL, 0x040ff00000041838ULL, 0x0000005c2c34723cULL, 0x040ff00000041834ULL,
0x0000005e2c18723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01b6a00076ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001057a7812ULL, 0x000fce00078ec0ffULL,
0x0000030017177a10ULL, 0x002fc80007ffe0ffULL, 0x000000141700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff95c000007947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x000e640000002500ULL, 0x000000140700720cULL, 0x002fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x0180000003007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e0003ULL, 0x0000813000237802ULL, 0x000fe40000000f00ULL,
0x0000c0c000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff007224ULL, 0x008fe200078e0005ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300007308ULL, 0x000e640000001000ULL,
0xbf80000000047423ULL, 0x002fc80000000003ULL, 0x800000ff04057221ULL, 0x000fc80000010100ULL,
0x0000000500007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x0000000805057811ULL, 0x002fe400078ff0ffULL, 0x00000002ff097819ULL, 0x004fc80000011604ULL,
0x00001f0500057589ULL, 0x000e6800000e0000ULL, 0x00001f0900047589ULL, 0x000ea200000e0000ULL,
0x0000004e054e7220ULL, 0x042fe40000410000ULL, 0x0000004f054f7220ULL, 0x000fe40000410000ULL,
0x0000004c044c7220ULL, 0x044fe40000410000ULL, 0x0000004d044d7220ULL, 0x000fc40000410000ULL,
0x0000004804487220ULL, 0x040fe40000410000ULL, 0x0000004904497220ULL, 0x040fe40000410000ULL,
0x0000004404447220ULL, 0x040fe40000410000ULL, 0x0000004504457220ULL, 0x040fe40000410000ULL,
0x0000004004407220ULL, 0x040fe40000410000ULL, 0x0000004104417220ULL, 0x000fc40000410000ULL,
0x0000003c043c7220ULL, 0x040fe40000410000ULL, 0x0000003d043d7220ULL, 0x040fe40000410000ULL,
0x0000003804387220ULL, 0x040fe40000410000ULL, 0x0000003904397220ULL, 0x040fe40000410000ULL,
0x0000003404347220ULL, 0x040fe40000410000ULL, 0x0000003504357220ULL, 0x000fc40000410000ULL,
0x0000001804187220ULL, 0x040fe40000410000ULL, 0x0000001904197220ULL, 0x000fe40000410000ULL,
0x0000004a054a7220ULL, 0x040fe40000410000ULL, 0x0000004b054b7220ULL, 0x040fe40000410000ULL,
0x0000004605467220ULL, 0x040fe40000410000ULL, 0x0000004705477220ULL, 0x000fc40000410000ULL,
0x0000004205427220ULL, 0x040fe40000410000ULL, 0x0000004305437220ULL, 0x040fe40000410000ULL,
0x0000003e053e7220ULL, 0x040fe40000410000ULL, 0x0000003f053f7220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x000fc40000410000ULL,
0x0000003605367220ULL, 0x040fe40000410000ULL, 0x0000003705377220ULL, 0x040fe40000410000ULL,
0x0000001a051a7220ULL, 0x040fe40000410000ULL, 0x0000001b051b7220ULL, 0x000fe40000410000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x00000018190e723eULL, 0x000fe400000010ffULL,
0x0000001a1b16723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000034350d723eULL, 0x000fc400000010ffULL, 0x0000004c4d06723eULL, 0x000fe400000010ffULL,
0x000000484908723eULL, 0x000fe400000010ffULL, 0x000000444509723eULL, 0x000fe400000010ffULL,
0x00000040410a723eULL, 0x000fe400000010ffULL, 0x0000003c3d0b723eULL, 0x000fe400000010ffULL,
0x00000038390c723eULL, 0x000fc400000010ffULL, 0x0000004e4f0f723eULL, 0x000fe400000010ffULL,
0x0000004a4b10723eULL, 0x000fe400000010ffULL, 0x000000464711723eULL, 0x000fe400000010ffULL,
0x00000002ff237819ULL, 0x002fe40000011605ULL, 0x0000000805337811ULL, 0x000fe400078ff0ffULL,
0x0000000723007812ULL, 0x040fe200078ec0ffULL, 0x0000000823047824ULL, 0x040fe200078e00ffULL,
0x00000023ff257212ULL, 0x000fe200078e33ffULL, 0x0000000823187824ULL, 0x000fe200078e00ffULL,
0x00000033ff357212ULL, 0x000fe200078e33ffULL, 0x00000008331a7824ULL, 0x000fe200078e00ffULL,
0xfffffff804177812ULL, 0x000fc400078ee223ULL, 0x0000000100047812ULL, 0x000fe400078e3cffULL,
0xfffffff818257812ULL, 0x000fe400078ee225ULL, 0xfffffff81a357812ULL, 0x000fe200078ee235ULL,
0x0000000823197824ULL, 0x040fe200078e0204ULL, 0x0000000200187812ULL, 0x000fe200078e3cffULL,
0x0000100062047824ULL, 0x000fe200078e00ffULL, 0x00000003001a7812ULL, 0x040fe400078e3cffULL,
0x00000004001c7812ULL, 0x040fe200078e3cffULL, 0x00000008231b7824ULL, 0x040fe200078e0218ULL,
0x00000005001e7812ULL, 0x040fe200078e3cffULL, 0x00000008231d7824ULL, 0x040fe200078e021aULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x00000008231f7824ULL, 0x000fe200078e021cULL,
0x00000007331a7812ULL, 0x000fe200078ec0ffULL, 0x0000000823217824ULL, 0x000fe200078e021eULL,
0x000000424312723eULL, 0x000fe200000010ffULL, 0x0000000405187824ULL, 0x000fe200078e00ffULL,
0x000000021a1e7812ULL, 0x040fe200078e3cffULL, 0x0000000823237824ULL, 0x000fe200078e0200ULL,
0x000000031a207812ULL, 0x000fe200078e3cffULL, 0x000008005b007824ULL, 0x000fe200078e0204ULL,
0x0000000c18187812ULL, 0x000fe200078ec0ffULL, 0x00000008331c7824ULL, 0x000fe200078e00ffULL,
0x000000041a227812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0200ULL,
0x000000051a247812ULL, 0x000fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0200ULL,
0xfffffff81c277812ULL, 0x000fe200078ee233ULL, 0x0000000117177824ULL, 0x000fe200078e0218ULL,
0x000000011a1c7812ULL, 0x040fe200078e3cffULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x000000061a1a7812ULL, 0x000fe200078e3cffULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0x0000000617007388ULL, 0x0003e20000000800ULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x0000003e3f13723eULL, 0x000fe200000010ffULL, 0x0000000833297824ULL, 0x000fe200078e021cULL,
0x0000003a3b14723eULL, 0x000fe200000010ffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x000000363715723eULL, 0x020fe200000010ffULL, 0x0000000118197824ULL, 0x000fc400078e0219ULL,
0x00000008332b7824ULL, 0x040fe400078e021eULL, 0x00000008332d7824ULL, 0x040fe200078e0220ULL,
0x0000000819007388ULL, 0x0005e20000000800ULL, 0x00000008332f7824ULL, 0x040fe400078e0222ULL,
0x0000000833317824ULL, 0x000fe400078e0224ULL, 0x0000001023237824ULL, 0x000fe400078e0200ULL,
0x0000000118067824ULL, 0x002fc400078e021bULL, 0x0000000833337824ULL, 0x000fe200078e021aULL,
0x000000ff00087306ULL, 0x004fe20000205400ULL, 0x0000001025257824ULL, 0x100fe200078e0200ULL,
0x0000000906007388ULL, 0x0003e20000000800ULL, 0x00000001181d7824ULL, 0x040fe400078e021dULL,
0x0000001027277824ULL, 0x100fe400078e0200ULL, 0x00000001181a7824ULL, 0x000fe200078e021fULL,
0x0000000a1d007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x000fc400078e0200ULL,
0x0000000118217824ULL, 0x040fe200078e0221ULL, 0x0000000b1a007388ULL, 0x000fe20000000800ULL,
0x000000102b2b7824ULL, 0x100fe200078e0200ULL, 0x000000ff00097306ULL, 0x002e620000209400ULL,
0x00000001181c7824ULL, 0x040fe200078e0223ULL, 0x0000000c21007388ULL, 0x000fe20000000800ULL,
0x0000000118257824ULL, 0x040fe400078e0225ULL, 0x000000102d2d7824ULL, 0x100fe200078e0200ULL,
0x0000000d1c007388ULL, 0x000fe20000000800ULL, 0x00000001181e7824ULL, 0x000fe200078e0227ULL,
0x000000ff00067306ULL, 0x000ea2000020d400ULL, 0x000000102f2f7824ULL, 0x100fe200078e0200ULL,
0x0000000e25007388ULL, 0x000fe20000000800ULL, 0x0000001035357824ULL, 0x000fc400078e0200ULL,
0x0000001031317824ULL, 0x100fe200078e0200ULL, 0x0000000f1e007388ULL, 0x000fe20000000800ULL,
0x0000000118297824ULL, 0x040fe200078e0229ULL, 0x000000080900720bULL, 0x002fe20003f1d000ULL,
0x0000001033337824ULL, 0x000fe400078e0200ULL, 0x0000000118207824ULL, 0x040fe200078e022bULL,
0x0000001029007388ULL, 0x000fe20000000800ULL, 0x00000001182d7824ULL, 0x040fe400078e022dULL,
0x0000000118227824ULL, 0x040fe200078e022fULL, 0x0000001120007388ULL, 0x000fe20000000800ULL,
0x0000000118357824ULL, 0x000fc400078e0235ULL, 0x0000000118317824ULL, 0x040fe200078e0231ULL,
0x000000122d007388ULL, 0x000fe20000000800ULL, 0x0000000118187824ULL, 0x000fe200078e0233ULL,
0x0000000106060812ULL, 0x004fe200078efcffULL, 0x0000000158177824ULL, 0x000fe200078e0205ULL,
0x0000001322007388ULL, 0x000fe40000000800ULL, 0x000000060608723eULL, 0x000fe200000010ffULL,
0x0000001017197824ULL, 0x000fe200078e0204ULL, 0x0000001431007388ULL, 0x000fe80000000800ULL,
0x0000001518007388ULL, 0x000fe80000000800ULL, 0x0000001635007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000190c7984ULL, 0x000e680000000c00ULL,
0x0004000019247984ULL, 0x000ea80000000c00ULL, 0x00080000191c7984ULL, 0x000ee80000000c00ULL,
0x000c000019107984ULL, 0x000f220000000c00ULL, 0x3f803f80080f7831ULL, 0x002fc4000020000fULL,
0x3f803f80080e7831ULL, 0x040fe4000020000eULL, 0x3f803f80080d7831ULL, 0x040fe4000020000dULL,
0x3f803f80080c7831ULL, 0x040fe4000020000cULL, 0x3f803f8008277831ULL, 0x044fe40000200027ULL,
0x3f803f8008267831ULL, 0x040fe40000200026ULL, 0x3f803f8008257831ULL, 0x000fc40000200025ULL,
0x3f803f8008247831ULL, 0x000fe20000200024ULL, 0x00000001ff087424ULL, 0x000fe200078e00ffULL,
0x3f803f800f0f7831ULL, 0x008fe4000020001fULL, 0x3f803f800e0e7831ULL, 0x000fe4000020001eULL,
0x0000030008007a0cULL, 0x000fe20003f05270ULL, 0x3f803f800d0d7831ULL, 0x000fe4000020001dULL,
0x3f803f800c0c7831ULL, 0x000fe4000020001cULL, 0x3f803f8027277831ULL, 0x010fc40000200013ULL,
0x3f803f8026267831ULL, 0x000fe20000200012ULL, 0x0000000c19007388ULL, 0x0003e20000000c00ULL,
0x3f803f8025257831ULL, 0x000fe40000200011ULL, 0x3f803f8024247831ULL, 0x000fca0000200010ULL,
0x0004002419007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f2000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000ea20000002700ULL,
0x00005800ff087624ULL, 0x000fe200078e00ffULL, 0x000000015bff7812ULL, 0x000fe2000780f860ULL,
0x00000800ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000097919ULL, 0x000ea40000002600ULL,
0x000000ff0500720cULL, 0x000fc40000725670ULL, 0x0000000019187984ULL, 0x002e620000000c00ULL,
0x0000580010107a24ULL, 0x004fe400078e0209ULL, 0x0000030008097a24ULL, 0x000fe400078e02ffULL,
0x0000030010087a24ULL, 0x000fe400078e02ffULL, 0x0000660009097a24ULL, 0x000fe400078e02ffULL,
0x00000001080c7824ULL, 0x000fc600078e0207ULL, 0x000007ff09077811ULL, 0x040fe400078e40ffULL,
0x01ffffff09097812ULL, 0x000fe400078ec0ffULL, 0x0000000c070a7211ULL, 0x000fca00078fa8ffULL,
0x00006c000a0a7625ULL, 0x000fcc00078e000bULL, 0x00000400620a7825ULL, 0x000fcc00078e000aULL,
0x00000010170e7825ULL, 0x000fe200078e000aULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010050a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011605ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x000000010c0d7824ULL, 0x000fe200078e0209ULL,
0x000000700a137812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b127812ULL, 0x000fe200078ec0ffULL,
0x00006c000c0a7625ULL, 0x000fc800078e0011ULL, 0x00006c000d0c7625ULL, 0x000fe200078e0011ULL,
0x0000000a120a7210ULL, 0x000fc80007a1e013ULL, 0x0000000c120c7210ULL, 0x000fe40007c7e013ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000020a007986ULL, 0x0003e8000c101906ULL, 0x000000030c007986ULL, 0x0003e4000c101906ULL,
0x000000180e007986ULL, 0x0023e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000004ff037424ULL, 0x000fc600078e00ffULL,
0x000003000b0b7a10ULL, 0x000fe20007ffe1ffULL, 0x00006a0010027625ULL, 0x000fe200078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b020279a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0200720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0a7807ULL, 0x000fca0000000000ULL,
0x0000000aff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff027984ULL, 0x000ee40000000000ULL,
0x000000ff0200720cULL, 0x008fda0003f05270ULL, 0x00002b9000008947ULL, 0x000fea0003800000ULL,
0x000000ff6000720cULL, 0x000fda0003f05270ULL, 0x00000d6000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe20000011605ULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001080a7810ULL, 0x004fe40007ffe0ffULL,
0x0000007002177812ULL, 0x000fe400078ec0ffULL, 0x0000000c030e7812ULL, 0x002fe200078ec0ffULL,
0x00006c0008027625ULL, 0x000fc800078e000dULL, 0x00006c000a0a7625ULL, 0x000fe200078e000dULL,
0x000000020e027210ULL, 0x000fc8000791e017ULL, 0x0000000a0e0a7210ULL, 0x000fe40007b5e017ULL,
0x00000003ff037210ULL, 0x000fe400007e24ffULL, 0x0000000bff0b7210ULL, 0x000fc600017e64ffULL,
0x0000000602027981ULL, 0x000368000c1e1900ULL, 0x000000060a0f7981ULL, 0x000362000c1e1900ULL,
0x00000300ff0c7624ULL, 0x000fca00078e00ffULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002080a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a037981ULL, 0x000362000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003080a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004080a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005080a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080c00780cULL, 0x002fe40003f06070ULL,
0x00000006080a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a0e0a7210ULL, 0x000fe40007a3e017ULL, 0x00000007080c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fca00078e000dULL,
0x0000000c0e0c0210ULL, 0x000fe40007c7e017ULL, 0x000000060a177981ULL, 0x000364000c1e1900ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c190981ULL, 0x000368000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff127224ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x020fe400078e0002ULL,
0x000000ffff147224ULL, 0x000fc600078e00ffULL, 0x0000030012007a0cULL, 0x000fe40003f26070ULL,
0x0000000114147810ULL, 0x000fc80007ffe0ffULL, 0x0000000414007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008120a7810ULL, 0x044fe40007ffe0ffULL,
0x00000001120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000d02027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000080c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011605ULL,
0x00000010050d7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e00dULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0d7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000002120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000f02027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000090c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000010050e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0f7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000003120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000000302027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011605ULL,
0x0000001005037824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x0000007003037812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e003ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a037981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000004120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001102027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000010050e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000005120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000010050e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d120a7810ULL, 0x042fe40007ffe0ffULL, 0x00000006120b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001502027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000010050e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e120a7810ULL, 0x042fe40007ffe0ffULL,
0x00000007120b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001702027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e0c0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011605ULL,
0x00000010050e7824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c10107812ULL, 0x000fe400078ec0ffULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f120a7810ULL, 0x002fe40007ffe0ffULL, 0x0000001902027209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011605ULL, 0x00000010050e7824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700e197812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007a3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0x0000000812127810ULL, 0x000fe40007ffe0ffULL, 0x000000080c0c7810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x0000001005037824ULL, 0x028fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x006fc80000011605ULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL,
0x0000000103037824ULL, 0x000fca00078e020aULL, 0x0000000203007388ULL, 0x0003e40000000800ULL,
0x000000070500780cULL, 0x040fe20003f04070ULL, 0x0000001005027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011605ULL, 0x000000015b107824ULL, 0x000fe200078e0208ULL,
0x00000002ff0a7819ULL, 0x004fe20000011660ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x0000020060607824ULL, 0x000fe200078e00ffULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x000020005b237824ULL, 0x000fe200078e0204ULL,
0x00000020050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000003005b007a0cULL, 0x040fe20003f26070ULL, 0x0000000102297824ULL, 0x000fe200078e0203ULL,
0x000000010a027812ULL, 0x000fe200078ec0ffULL, 0x000000025b0b8824ULL, 0x100fe200078e0262ULL,
0x0000001007037211ULL, 0x000fe200078fa8ffULL, 0x000000025b0d8824ULL, 0x000fe200078e0262ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000800ff0a7424ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000020b0e8824ULL, 0x100fe200078e0202ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000020d168824ULL, 0x000fe200078e0202ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00006c0003027625ULL, 0x000fe200078e000aULL,
0x00000800600a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x00000001090b8824ULL, 0x000fe200078e0210ULL, 0x0000000029297984ULL, 0x000e620000000800ULL,
0x00000080ff128424ULL, 0x000fe400078e00ffULL, 0x00000080ff118424ULL, 0x000fe400078e00ffULL,
0x0000040062027825ULL, 0x000fc800078e0002ULL, 0x00000001230c7824ULL, 0x000fe400078e020aULL,
0x00006c000b0a8625ULL, 0x000fc800078e0012ULL, 0x00006c0010108625ULL, 0x000fc800078e0011ULL,
0x000000080e148824ULL, 0x100fe400078e0205ULL, 0x0000000816168824ULL, 0x000fe400078e0205ULL,
0x0000001005177824ULL, 0x040fe400078e020cULL, 0x00000010050c7825ULL, 0x000fe200078e0002ULL,
0x00004180161d8811ULL, 0x000fc600078e20ffULL, 0x000000100f0e7825ULL, 0x000fe200078e0002ULL,
0x0000458014038811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c177faeULL, 0x0005e4000b901c46ULL, 0x0000001005128825ULL, 0x040fe400078e000aULL,
0x003800000e177faeULL, 0x0007e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000001005148825ULL, 0x000fe400078e0010ULL, 0x0000000012038faeULL, 0x0009e2000b901c46ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000000ffff227224ULL, 0x000fc400078e00ffULL,
0x00000000141d8faeULL, 0x000be2000b901c46ULL, 0x00000000000c7805ULL, 0x004fe2000001ff00ULL,
0x000000ffff287224ULL, 0x000fe400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000027805ULL, 0x010fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x020fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000d3000001947ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e005bULL,
0x00000002342b7810ULL, 0x000fc80007ffe0ffULL, 0x000003002b007a0cULL, 0x000fda0003f06070ULL,
0x0000025000000947ULL, 0x000fea0003800000ULL, 0x000000070500780cULL, 0x000fe20003f04070ULL,
0x0000000108327824ULL, 0x100fe200078e022bULL, 0x00000001ff2c7819ULL, 0x000fe2000001162bULL,
0x000004002b2d7824ULL, 0x000fe200078e00ffULL, 0x0000002005377810ULL, 0x000fe20007ffe0ffULL,
0x00000800ff317424ULL, 0x000fe200078e00ffULL, 0x000000012c2f7812ULL, 0x000fe400078ec0ffULL,
0x00000032072c7211ULL, 0x000fe400078fa8ffULL, 0x000008002d307812ULL, 0x000fc600078ec0ffULL,
0x000000025b368824ULL, 0x140fe400078e0262ULL, 0x000000025b388824ULL, 0x000fe400078e0262ULL,
0x00006c002c2c7625ULL, 0x000fc800078e0031ULL, 0x00000001092e8824ULL, 0x000fe400078e0232ULL,
0x00000080ff338424ULL, 0x000fe400078e00ffULL, 0x0000000236368824ULL, 0x100fe400078e022fULL,
0x0000000238388824ULL, 0x000fe400078e022fULL, 0x00006c002e2e8625ULL, 0x000fc800078e0033ULL,
0x00000080ff318424ULL, 0x000fe400078e00ffULL, 0x0000000123307824ULL, 0x000fe400078e0230ULL,
0x00000400622c7825ULL, 0x000fc800078e002cULL, 0x00006c0032328625ULL, 0x000fc800078e0031ULL,
0x0000001005357824ULL, 0x040fe400078e0230ULL, 0x0000000836368824ULL, 0x000fe400078e0205ULL,
0x0000001005308825ULL, 0x000fc800078e002eULL, 0x0000000838388824ULL, 0x000fe400078e0205ULL,
0x00000010372e7825ULL, 0x100fe200078e002cULL, 0x0000458036378811ULL, 0x000fe400078e20ffULL,
0x0000418038398811ULL, 0x000fe200078e20ffULL, 0x00000010052c7825ULL, 0x000fc800078e002cULL,
0x0000001005328825ULL, 0x000fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002c357faeULL, 0x0003e8000b901c46ULL, 0x003800002e357faeULL, 0x0003e8000b901c46ULL,
0x0000000030378faeULL, 0x0003e8000b901c46ULL, 0x0000000032398faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0034ULL,
0x00000001ff2e7819ULL, 0x100fe20000011605ULL, 0x000000025b317824ULL, 0x000fe200078e0262ULL,
0x00000002ff4e7819ULL, 0x000fe20000011605ULL, 0x000000402f2c7824ULL, 0x000fe200078e00ffULL,
0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL, 0x00000010052d7824ULL, 0x000fe200078e00ffULL,
0x000000074e3c7812ULL, 0x040fe200078ec0ffULL, 0x000000084e337824ULL, 0x000fe200078e00ffULL,
0x000000802c2c7812ULL, 0x000fc400078ec0ffULL, 0x000000702d2d7812ULL, 0x000fe400078ec0ffULL,
0x000000084e507810ULL, 0x040fe20007ffe0ffULL, 0x00000100312c7824ULL, 0x000fe400078e002cULL,
0x000000084e317824ULL, 0x000fe200078e00ffULL, 0x00000050ff4a7212ULL, 0x000fe200078e33ffULL,
0x00000008503e7824ULL, 0x000fe200078e00ffULL, 0x0000002c2e2e7210ULL, 0x000fe20007ffe02dULL,
0x000000084e2d7824ULL, 0x000fe200078e00ffULL, 0x0000004eff2c7212ULL, 0x000fe200078e33ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180002e3a7984ULL, 0x000e620000000800ULL,
0xfffffff833487812ULL, 0x000fe200078ee22cULL, 0x0000000850337824ULL, 0x000fe200078e00ffULL,
0xfffffff8312c7812ULL, 0x100fe200078ee23cULL, 0x004580002e4c7984ULL, 0x0002a20000000800ULL,
0x000000012d307812ULL, 0x140fe400078ef63cULL, 0x000000022d327812ULL, 0x140fe400078ef63cULL,
0x000000032d347812ULL, 0x140fe400078ef63cULL, 0x000000042d367812ULL, 0x000fc400078ef63cULL,
0x000000052d387812ULL, 0x000fe400078ef63cULL, 0xfffffff8334a7812ULL, 0x000fe200078ee24aULL,
0x0000000405337824ULL, 0x000fca00078e00ffULL, 0x0000000c33357812ULL, 0x000fe200078ec0ffULL,
0x0000003a292e7221ULL, 0x002fe20000010100ULL, 0x000000062d3a7812ULL, 0x000fe200078ef63cULL,
0x000004002f2d7824ULL, 0x000fe200078e00ffULL, 0x00000007502f7812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b2e317820ULL, 0x000fe40000410000ULL, 0x00000008503c7824ULL, 0x000fe200078e00ffULL,
0x000008002d2e7812ULL, 0x000fe400078ec0ffULL, 0x000000013e407812ULL, 0x000fe200078ef62fULL,
0x0000003100317308ULL, 0x000ea20000000800ULL, 0x00000180232d7810ULL, 0x000fc40007ffe02eULL,
0xfffffff83c3c7812ULL, 0x100fe400078ee22fULL, 0x000000023e427812ULL, 0x000fe200078ef62fULL,
0x000000102c2c7824ULL, 0x000fe200078e022dULL, 0x000000033e447812ULL, 0x000fe200078ef62fULL,
0x0000001030307824ULL, 0x000fe200078e022dULL, 0x000000043e467812ULL, 0x000fe200078ef62fULL,
0x00000001352c7824ULL, 0x040fe400078e022cULL, 0x0000000135307824ULL, 0x000fe400078e0230ULL,
0x0000001032327824ULL, 0x000fc400078e022dULL, 0x0000004c31337220ULL, 0x004fe40000410000ULL,
0x000000002c317984ULL, 0x000e620000000800ULL, 0x0000000135327824ULL, 0x040fe400078e0232ULL,
0x000000103c3c7824ULL, 0x100fe200078e022dULL, 0x0000000030307984ULL, 0x000fe20000000800ULL,
0x0000001040407824ULL, 0x100fe400078e022dULL, 0x00000001353c7824ULL, 0x040fe200078e023cULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x00000010482e7824ULL, 0x000fe200078e022dULL,
0x000000053e487812ULL, 0x140fe200078ef62fULL, 0x0000000135407824ULL, 0x040fe200078e0240ULL,
0x000000063e3e7812ULL, 0x000fe200078ef62fULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x00000001352e7824ULL, 0x000fc400078e022eULL, 0x0000001034347824ULL, 0x100fe200078e022dULL,
0x00001f4e332f7589ULL, 0x000ea200000e0000ULL, 0x0000001042427824ULL, 0x100fe400078e022dULL,
0x0000000135347824ULL, 0x040fe200078e0234ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x0000000135427824ULL, 0x000fe400078e0242ULL, 0x0000001044447824ULL, 0x100fe200078e022dULL,
0x000000002e2e7984ULL, 0x000ee20000000800ULL, 0x0000001048487824ULL, 0x000fc400078e022dULL,
0x0000000135447824ULL, 0x040fe200078e0244ULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0x0000000135487824ULL, 0x000fe400078e0248ULL, 0x0000001036367824ULL, 0x100fe200078e022dULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x000000103e3e7824ULL, 0x100fe400078e022dULL,
0x0000001038387824ULL, 0x100fe200078e022dULL, 0x00001f50332c7589ULL, 0x000f2200000e0000ULL,
0x000000103a3a7824ULL, 0x000fc400078e022dULL, 0x0000001046467824ULL, 0x100fe200078e022dULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x000000104a4a7824ULL, 0x000fe200078e022dULL,
0x00005410ff2d7816ULL, 0x102fe20000000031ULL, 0x0000000135367824ULL, 0x040fe200078e0236ULL,
0x0000000048487984ULL, 0x000e620000000800ULL, 0x00000001353e7824ULL, 0x000fe200078e023eULL,
0x00007610ff4c7816ULL, 0x000fe20000000031ULL, 0x0000002f2d287223ULL, 0x084fe20000010028ULL,
0x00005410ff2d7816ULL, 0x000fe20000000030ULL, 0x0000000135387824ULL, 0x040fe200078e0238ULL,
0x0000000036367984ULL, 0x000ea20000000800ULL, 0x0000000135467824ULL, 0x040fe200078e0246ULL,
0x00007610ff307816ULL, 0x000fe20000000030ULL, 0x00000001354a7824ULL, 0x000fe200078e024aULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x0000002f2d267223ULL, 0x080fe20000010026ULL,
0x00005410ff2d7816ULL, 0x000fe20000000032ULL, 0x00000001353a7824ULL, 0x000fe200078e023aULL,
0x0000000038387984ULL, 0x000f620000000800ULL, 0x0000002f4c277223ULL, 0x080fe20000010027ULL,
0x00007610ff327816ULL, 0x000fe20000000032ULL, 0x0000002f2d247223ULL, 0x080fe20000010024ULL,
0x0000000046467984ULL, 0x000f620000000800ULL, 0x00005410ff2d7816ULL, 0x000fe2000000003cULL,
0x0000002a332a7221ULL, 0x000fe20000010000ULL, 0x00005410ff4c7816ULL, 0x108fe2000000002eULL,
0x000000004a4a7984ULL, 0x000ee20000000800ULL, 0x00007610ff2e7816ULL, 0x000fe2000000002eULL,
0x0000002c2d037223ULL, 0x090fe20000010003ULL, 0x00005410ff2d7816ULL, 0x000fe20000000040ULL,
0x000000003a3a7984ULL, 0x000f220000000800ULL, 0x00007610ff3c7816ULL, 0x000fe2000000003cULL,
0x0000002f2e187223ULL, 0x080fe20000010018ULL, 0x00005410ff2e7816ULL, 0x000fe20000000034ULL,
0x0000002c2d107223ULL, 0x000fe20000010010ULL, 0x00007610ff2d7816ULL, 0x000fe20000000040ULL,
0x0000002f4c197223ULL, 0x080fe20000010019ULL, 0x00007610ff347816ULL, 0x000fe20000000034ULL,
0x0000002f2e217223ULL, 0x000fc40000010021ULL, 0x0000002c2d167223ULL, 0x080fe20000010016ULL,
0x00005410ff2d7816ULL, 0x000fe20000000042ULL, 0x0000002f34207223ULL, 0x080fe20000010020ULL,
0x00007610ff427816ULL, 0x000fe20000000042ULL, 0x000000ffff347224ULL, 0x000fe200078e002bULL,
0x00007610ff2b7816ULL, 0x002fe20000000048ULL, 0x0000002c2d0f7223ULL, 0x080fe2000001000fULL,
0x00005410ff2d7816ULL, 0x000fe20000000044ULL, 0x0000002f30257223ULL, 0x080fe20000010025ULL,
0x0000030034007a0cULL, 0x000fe20003f06070ULL, 0x0000002c2b127223ULL, 0x080fe20000010012ULL,
0x00005410ff2e7816ULL, 0x004fe20000000036ULL, 0x0000002c2d0e7223ULL, 0x080fe2000001000eULL,
0x00007610ff2d7816ULL, 0x000fe20000000044ULL, 0x0000002f32227223ULL, 0x080fe20000010022ULL,
0x00005410ff2b7816ULL, 0x020fe2000000003eULL, 0x0000002f2e1f7223ULL, 0x080fe2000001001fULL,
0x00007610ff367816ULL, 0x000fe20000000036ULL, 0x0000002c2d147223ULL, 0x080fe20000010014ULL,
0x00005410ff2e7816ULL, 0x100fe20000000038ULL, 0x0000002c2b0b7223ULL, 0x080fe2000001000bULL,
0x00007610ff387816ULL, 0x000fe20000000038ULL, 0x0000002f361e7223ULL, 0x080fe2000001001eULL,
0x00005410ff2d7816ULL, 0x100fe20000000046ULL, 0x0000002f2e1d7223ULL, 0x080fe2000001001dULL,
0x00007610ff467816ULL, 0x000fe20000000046ULL, 0x0000002f381c7223ULL, 0x080fe2000001001cULL,
0x00005410ff2b7816ULL, 0x008fe2000000004aULL, 0x0000002c2d0d7223ULL, 0x080fe2000001000dULL,
0x00005410ff2d7816ULL, 0x000fe20000000048ULL, 0x0000002c3c177223ULL, 0x080fe20000010017ULL,
0x00005410ff2e7816ULL, 0x010fe2000000003aULL, 0x0000002c2b0a7223ULL, 0x080fe2000001000aULL,
0x00007610ff3a7816ULL, 0x000fe2000000003aULL, 0x0000002c42157223ULL, 0x000fe20000010015ULL,
0x00007610ff3e7816ULL, 0x000fe2000000003eULL, 0x0000002f2e1b7223ULL, 0x080fe2000001001bULL,
0x00007610ff2b7816ULL, 0x000fe2000000004aULL, 0x0000002f3a1a7223ULL, 0x000fc4000001001aULL,
0x0000002c46137223ULL, 0x080fe40000010013ULL, 0x0000002c2d0c7223ULL, 0x080fe4000001000cULL,
0x0000002c3e117223ULL, 0x080fe40000010011ULL, 0x0000002c2b027223ULL, 0x000fe20000010002ULL,
0xfffff2f000008947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x000000ff6200720cULL, 0x000fe20003f05270ULL, 0x0000001005077824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011605ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c05087812ULL, 0x000fca00078ec0ffULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000001005077824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011605ULL,
0x0000007007087812ULL, 0x000fe400078ec0ffULL, 0x0000000c052c7812ULL, 0x000fc600078ec0ffULL,
0x000000805b057824ULL, 0x000fc800078e0208ULL, 0x000000012c057824ULL, 0x000fca00078e0205ULL,
0x0049802a05007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800009057984ULL, 0x002e680000000800ULL,
0x004a000009087984ULL, 0x000ea20000000800ULL, 0x00000005ff057221ULL, 0x002fc80000010000ULL,
0x0000000805057221ULL, 0x004fca0000010000ULL, 0x0180000005077810ULL, 0x000fc80007ffe0ffULL,
0x7f80000007077812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0700780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0000b13000237802ULL, 0x000fe40000000f00ULL,
0x000090c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x008fe200078e0005ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000500087308ULL, 0x000e640000001000ULL,
0xbf80000005077423ULL, 0x002fc80000000008ULL, 0x800000ff07077221ULL, 0x000fc80000010100ULL,
0x0000000708077223ULL, 0x000fe40000000008ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff2a7819ULL, 0x002fe40000011605ULL, 0x00000008052c7811ULL, 0x000fe400078ff0ffULL,
0x0000002aff297212ULL, 0x000fe200078e33ffULL, 0x00001f2a07097589ULL, 0x000e6200000e0000ULL,
0x0000002cff2b7212ULL, 0x000fe200078e33ffULL, 0x000000082c307824ULL, 0x000fc400078e00ffULL,
0x00001f2c07087589ULL, 0x000ea200000e0000ULL, 0x000000082a2e7824ULL, 0x000fe400078e00ffULL,
0xfffffff830357812ULL, 0x000fc600078ee22bULL, 0xfffffff82e297812ULL, 0x000fe400078ee229ULL,
0x0000001035357824ULL, 0x000fc600078e0200ULL, 0x0000001029297824ULL, 0x000fe400078e0200ULL,
0x0000002809287220ULL, 0x042fe40000410000ULL, 0x0000002709277220ULL, 0x040fe40000410000ULL,
0x0000002609267220ULL, 0x040fe40000410000ULL, 0x0000002509257220ULL, 0x000fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000010ffULL, 0x0000002409247220ULL, 0x000fc40000410000ULL,
0x0000002209237220ULL, 0x000fe20000410000ULL, 0x000000262525723eULL, 0x000fe200000010ffULL,
0x0000002109217220ULL, 0x040fe40000410000ULL, 0x0000002009207220ULL, 0x000fe20000410000ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x0000001f091f7220ULL, 0x040fe40000410000ULL,
0x0000001e091e7220ULL, 0x040fe20000410000ULL, 0x000000212020723eULL, 0x000fe200000010ffULL,
0x0000001d091d7220ULL, 0x000fc40000410000ULL, 0x0000001c091c7220ULL, 0x040fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000010ffULL, 0x0000001b091b7220ULL, 0x040fe40000410000ULL,
0x0000001a091a7220ULL, 0x040fe20000410000ULL, 0x0000001d1c1c723eULL, 0x000fe200000010ffULL,
0x0000001909197220ULL, 0x040fe40000410000ULL, 0x0000001809187220ULL, 0x000fe20000410000ULL,
0x0000001b1a1a723eULL, 0x000fe200000010ffULL, 0x0000001408097220ULL, 0x004fc40000410000ULL,
0x0000001308147220ULL, 0x000fe20000410000ULL, 0x000000191818723eULL, 0x000fe200000010ffULL,
0x0000001208137220ULL, 0x040fe40000410000ULL, 0x0000001108127220ULL, 0x040fe40000410000ULL,
0x0000000a080a7220ULL, 0x040fe40000410000ULL, 0x0000000208117220ULL, 0x000fe20000410000ULL,
0x000000072a027812ULL, 0x000fe200078ec0ffULL, 0x0000000c080c7220ULL, 0x000fc40000410000ULL,
0x0000001608077220ULL, 0x040fe20000410000ULL, 0x0000000a110a723eULL, 0x000fe200000010ffULL,
0x0000000308037220ULL, 0x040fe20000410000ULL, 0x0000000c130c723eULL, 0x000fe200000010ffULL,
0x0000001708227220ULL, 0x000fe20000410000ULL, 0x0000000102137812ULL, 0x000fe200078e3cffULL,
0x0000001008107220ULL, 0x000fe20000410000ULL, 0x0000000302177812ULL, 0x000fe200078e3cffULL,
0x0000000f080f7220ULL, 0x000fe20000410000ULL, 0x0000000402197812ULL, 0x000fe200078e3cffULL,
0x0000001508167220ULL, 0x000fe20000410000ULL, 0x0000000202157812ULL, 0x000fe200078e3cffULL,
0x0000000e080e7220ULL, 0x000fe20000410000ULL, 0x00000005021b7812ULL, 0x000fe200078e3cffULL,
0x0000000d080d7220ULL, 0x000fe20000410000ULL, 0x00000006021d7812ULL, 0x000fe200078e3cffULL,
0x0000000b080b7220ULL, 0x000fe20000410000ULL, 0x000000072c087812ULL, 0x000fe200078ec0ffULL,
0x000000082a117824ULL, 0x000fe200078e00ffULL, 0x0000000e0909723eULL, 0x000fe200000010ffULL,
0x000000082c1f7824ULL, 0x000fe200078e00ffULL, 0x0000000108217812ULL, 0x000fe200078e3cffULL,
0x0000000405027824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee22aULL,
0x000000082a137824ULL, 0x000fe200078e0213ULL, 0x00000002082b7812ULL, 0x000fe200078e3cffULL,
0x000000082a157824ULL, 0x000fe200078e0215ULL, 0x00000003082d7812ULL, 0x000fe200078e3cffULL,
0x000000082a177824ULL, 0x000fe200078e0217ULL, 0x00000004082f7812ULL, 0x000fe200078e3cffULL,
0x000000082a197824ULL, 0x000fe200078e0219ULL, 0x0000000508317812ULL, 0x000fe200078e3cffULL,
0x000000082a1b7824ULL, 0x000fe200078e021bULL, 0x0000000608337812ULL, 0x000fe200078e3cffULL,
0x000000082a1d7824ULL, 0x000fe200078e021dULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee22cULL,
0x000000082c217824ULL, 0x000fe200078e0221ULL, 0x0000000c02027812ULL, 0x000fe200078ec0ffULL,
0x000000082c2b7824ULL, 0x040fe200078e022bULL, 0x000000100707723eULL, 0x000fe200000010ffULL,
0x000000082c2d7824ULL, 0x000fe200078e022dULL, 0x000000032203723eULL, 0x000fe200000010ffULL,
0x000000082c2f7824ULL, 0x000fe200078e022fULL, 0x0000000d140d723eULL, 0x000fe200000010ffULL,
0x000000082c317824ULL, 0x000fe200078e0231ULL, 0x0000000f160f723eULL, 0x000fe200000010ffULL,
0x000000082c337824ULL, 0x000fe200078e0233ULL, 0x0000000b120b723eULL, 0x000fe200000010ffULL,
0x0000001011117824ULL, 0x000fc400078e0200ULL, 0x0000001013137824ULL, 0x100fe400078e0200ULL,
0x0000001015157824ULL, 0x100fe400078e0200ULL, 0x0000001017177824ULL, 0x100fe400078e0200ULL,
0x000000101f1f7824ULL, 0x000fe400078e0200ULL, 0x0000000111087824ULL, 0x000fe400078e0202ULL,
0x0000001019197824ULL, 0x000fc400078e0200ULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x0000002708007388ULL, 0x0003e20000000800ULL, 0x000000101d1d7824ULL, 0x100fe400078e0200ULL,
0x0000001021217824ULL, 0x100fe400078e0200ULL, 0x000000102b2b7824ULL, 0x100fe400078e0200ULL,
0x000000102d2d7824ULL, 0x100fe400078e0200ULL, 0x000000102f2f7824ULL, 0x000fc400078e0200ULL,
0x0000001031317824ULL, 0x100fe400078e0200ULL, 0x0000001033337824ULL, 0x000fe400078e0200ULL,
0x0000000102007824ULL, 0x040fe400078e0213ULL, 0x00000001020e7824ULL, 0x040fe400078e0215ULL,
0x0000000102177824ULL, 0x040fe200078e0217ULL, 0x0000002500007388ULL, 0x0005e20000000800ULL,
0x0000000102197824ULL, 0x000fc400078e0219ULL, 0x00000001021b7824ULL, 0x040fe200078e021bULL,
0x000000230e007388ULL, 0x000fe20000000800ULL, 0x00000001021d7824ULL, 0x040fe400078e021dULL,
0x0000000102297824ULL, 0x040fe200078e0229ULL, 0x0000002017007388ULL, 0x000fe20000000800ULL,
0x0000000102107824ULL, 0x040fe400078e021fULL, 0x0000000102147824ULL, 0x040fe200078e0221ULL,
0x0000001e19007388ULL, 0x000fe20000000800ULL, 0x0000000102087824ULL, 0x002fc400078e022bULL,
0x0000000102227824ULL, 0x040fe200078e022dULL, 0x0000001c1b007388ULL, 0x000fe20000000800ULL,
0x0000000102247824ULL, 0x040fe400078e022fULL, 0x0000000102357824ULL, 0x040fe200078e0235ULL,
0x0000001a1d007388ULL, 0x000fe20000000800ULL, 0x0000000102317824ULL, 0x040fe400078e0231ULL,
0x0000000102027824ULL, 0x000fe200078e0233ULL, 0x0000001829007388ULL, 0x000fe20000000800ULL,
0x0000000158117824ULL, 0x000fc600078e0205ULL, 0x0000000310007388ULL, 0x000fe20000000800ULL,
0x0000001011007824ULL, 0x004fc600078e0204ULL, 0x0000000714007388ULL, 0x000fe80000000800ULL,
0x0000000f08007388ULL, 0x0003e80000000800ULL, 0x0000000922007388ULL, 0x000fe80000000800ULL,
0x0000000d24007388ULL, 0x000fe20000000800ULL, 0x000000060608723eULL, 0x002fc600000010ffULL,
0x0000000c31007388ULL, 0x000fe80000000800ULL, 0x0000000b02007388ULL, 0x000fe80000000800ULL,
0x0000000a35007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000107984ULL, 0x000e680000000c00ULL, 0x0004000000187984ULL, 0x000ea80000000c00ULL,
0x0008000000147984ULL, 0x000ee80000000c00ULL, 0x000c0000001c7984ULL, 0x000f220000000c00ULL,
0x3f803f8008137831ULL, 0x002fc40000200013ULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x3f803f8008107831ULL, 0x040fe40000200010ULL,
0x3f803f80081b7831ULL, 0x044fe4000020001bULL, 0x3f803f80081a7831ULL, 0x040fe4000020001aULL,
0x3f803f8008197831ULL, 0x000fc40000200019ULL, 0x3f803f8008187831ULL, 0x000fe40000200018ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f801b1b7831ULL, 0x010fc4000020001fULL, 0x3f803f801a1a7831ULL, 0x000fe2000020001eULL,
0x0000001000007388ULL, 0x0003e20000000c00ULL, 0x3f803f8019197831ULL, 0x000fe4000020001dULL,
0x3f803f8018187831ULL, 0x000fca000020001cULL, 0x0004001800007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff5b00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002005127810ULL, 0x002fe20007ffe0ffULL,
0x0000000000027919ULL, 0x000e620000002600ULL, 0x00000003ff067819ULL, 0x100fe20000011605ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff037819ULL, 0x100fe20000011612ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000706087812ULL, 0x100fe200078e4805ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000703007812ULL, 0x000fe200078e4812ULL,
0x0000000862137824ULL, 0x000fe200078e00ffULL, 0x0ffffff808097812ULL, 0x000fc400078ef805ULL,
0x0ffffff800077812ULL, 0x000fc600078ef812ULL, 0x0000001009007824ULL, 0x100fe400078e0204ULL,
0x0000001007077824ULL, 0x000fc600078e0204ULL, 0x0000000000087984ULL, 0x0045280000000c00ULL,
0x00000000070c7984ULL, 0x000b220000000c00ULL, 0x0000000802117824ULL, 0x042fe400078e00ffULL,
0x0000000802047824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000862007824ULL, 0x004fe200078e00ffULL, 0xfffffff811027812ULL, 0x000fc400078ee206ULL,
0xfffffff804037812ULL, 0x000fe400078ee203ULL, 0x0000000402107c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000403067c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff800117812ULL, 0x000fe200078ee205ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0010027a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x020fe200008e06ffULL, 0x00005a0006047a11ULL, 0x000fc400078240ffULL,
0x00005b0010037a11ULL, 0x000fe400000f4403ULL, 0x00005b0006057a11ULL, 0x000fe400008f4407ULL,
0xfffffff813077812ULL, 0x000fe200078ee212ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff027819ULL, 0x000fe20000011660ULL, 0xffffffffff137424ULL, 0x000fc800078e00ffULL,
0x0000000217157824ULL, 0x000fca00078e0202ULL, 0x000000161500720cULL, 0x000fda0003f06070ULL,
0x000000020e088824ULL, 0x000fc800078e00ffULL, 0x0000640008088a24ULL, 0x000fc800078e0215ULL,
0x0000600008088625ULL, 0x002fe200078e0011ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000608138981ULL, 0x000ea2000c1e1900ULL, 0x0000000117077810ULL, 0x000fe20007ffe0ffULL,
0x0000004060127824ULL, 0x000fe400078e00ffULL, 0x0000008010117824ULL, 0x000fe200078e00ffULL,
0x000000140700720cULL, 0x000fe20003f06070ULL, 0x00000100170a7824ULL, 0x000fe200078e0212ULL,
0x01b60000ff027f8cULL, 0x000e62000c80043fULL, 0x0000008018107824ULL, 0x000fc600078e00ffULL,
0x0000004011067812ULL, 0x000fe200078ef80aULL, 0x0000001013047224ULL, 0x004fcc00078e02ffULL,
0x00000e7000008947ULL, 0x000fea0003800000ULL, 0x0000000a61077217ULL, 0x002fe40007800000ULL,
0x00000003ff2b7819ULL, 0x000fe40000011600ULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x00000001070f7824ULL, 0x000fe200078e0a0aULL, 0x000000042b097810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x000fe200078e022bULL, 0x000000082b0d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0900720cULL, 0x040fe20003f06070ULL, 0x0000000809287824ULL, 0x040fe200078e00ffULL,
0x0000000704197210ULL, 0x000fe20007f3e0ffULL, 0x0000000106077824ULL, 0x000fe200078e0209ULL,
0x00000000090b7212ULL, 0x080fe200078e3cffULL, 0x000000080d2a7824ULL, 0x040fe200078e00ffULL,
0x000000000d097212ULL, 0x000fe200078e3cffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000c2b1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000704077210ULL, 0x000fe40007f5e0ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL, 0x0000000106097824ULL, 0x000fe200078e021fULL,
0x00005e0019247a11ULL, 0x000fe200078240ffULL, 0x000000ffff087224ULL, 0x000fe200010e06ffULL,
0x00005e0007227a11ULL, 0x000fe200078440ffULL, 0x000000081f2c7824ULL, 0x000fe200078e00ffULL,
0x000000142b297810ULL, 0x000fe40007ffe0ffULL, 0x0000000904097210ULL, 0x000fc40007fbe0ffULL,
0x00005f0019197a11ULL, 0x000fe200008f440aULL, 0x0000000829307824ULL, 0x000fe200078e00ffULL,
0x00005f00071b7a11ULL, 0x000fe200010f4408ULL, 0x0000000106077824ULL, 0x040fe200078e020dULL,
0x0000000f0d00720cULL, 0x000fe20003f26070ULL, 0x00000001060d7824ULL, 0x000fe200078e0229ULL,
0x000000102b237810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x00005e0009207a11ULL, 0x000fe400078a40ffULL, 0x0000000d040d7210ULL, 0x000fe20007f7e0ffULL,
0x00000008232e7824ULL, 0x000fe200078e00ffULL, 0x00005f0009217a11ULL, 0x000fc400028f440aULL,
0x000000072b097812ULL, 0x140fe200078e4800ULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x000000182b2d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20bULL,
0x00000001060b7824ULL, 0x040fe200078e0223ULL, 0x0ffffff809267812ULL, 0x000fe200078ef800ULL,
0x0000000106097824ULL, 0x000fe200078e022dULL, 0x0000000704077210ULL, 0x000fe40007f9e0ffULL,
0x00005e000d1e7a11ULL, 0x000fc400078640ffULL, 0x0000000b040b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x00005f000d277a11ULL, 0x000fe400018f4408ULL,
0x0000000904257210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x0000002405087210ULL, 0x000fe40007f7e0ffULL, 0x00005e00070c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff0a7224ULL, 0x000fe200030e06ffULL, 0x00005e000b187a11ULL, 0x000fe200078440ffULL,
0x000000ffff097224ULL, 0x000fe200018e0619ULL, 0x00005f00071d7a11ULL, 0x000fc400020f441cULL,
0x00005e00251c7a11ULL, 0x000fe400078640ffULL, 0x00005f000b1a7a11ULL, 0x000fe400010f441aULL,
0x00005f0025257a11ULL, 0x000fe400018f440aULL, 0x000000001f0b7212ULL, 0x000fe400078e3cffULL,
0x00000022050a7210ULL, 0x000fe20007f7e0ffULL, 0x000000082d227824ULL, 0x000fe200078e00ffULL,
0x0000001c2b2f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000f2b00720cULL, 0x080fe40003f46070ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20bULL, 0x000000ffff0b7224ULL, 0x000fe200018e061bULL,
0x0000100060077811ULL, 0x000fe200078e70ffULL, 0x00000001061b7824ULL, 0x000fe200078e022fULL,
0x0000000f2300720cULL, 0x040fe40003f86070ULL, 0x00000000230d7212ULL, 0x000fe200078e3cffULL,
0x0000001026197824ULL, 0x100fe200078e0207ULL, 0x0000001b04237210ULL, 0x000fe20007fde0ffULL,
0x00000010281b7824ULL, 0x000fe200078e0207ULL, 0x0000000f1f00720cULL, 0x000fc40003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008197faeULL, 0x0003e2000d101c46ULL,
0x00000000291f7212ULL, 0x000fe400078e3cffULL, 0x0000000c050c7210ULL, 0x000fe20007f7e0ffULL,
0x000000000a1b7faeULL, 0x0005e2000c101c46ULL, 0xfffffff830307812ULL, 0x000fe400078ee21fULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0d7224ULL, 0x000fe200018e061dULL,
0x000000202b1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000102a1d7824ULL, 0x000fe200078e0207ULL,
0x0000000f2f00720cULL, 0x000fe20003f06070ULL, 0x000000ffff087224ULL, 0x002fe200030e06ffULL,
0x00005e0023267a11ULL, 0x000fc400078c40ffULL, 0x000000002d097212ULL, 0x000fe200078e3cffULL,
0x000000000c1d7faeULL, 0x0003e2000c901c46ULL, 0x00005f0023237a11ULL, 0x000fe200030f4408ULL,
0x000000102e1b7824ULL, 0x004fe200078e0207ULL, 0x0000002005087210ULL, 0x040fe40007fde0ffULL,
0xfffffff822287812ULL, 0x000fe400078ee209ULL, 0x0000001805187210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200030e0621ULL, 0x000000242b0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106217824ULL, 0x000fe200078e021fULL, 0x000000001f0a7212ULL, 0x0c0fe200078e3cffULL,
0x000000ffff197224ULL, 0x000fe200008e061aULL, 0x0000000f1f00720cULL, 0x040fe20003f26070ULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x0000002104217210ULL, 0x000fe20007fde0ffULL,
0x000000102c0d7824ULL, 0x002fe200078e0207ULL, 0x000000002f207212ULL, 0x000fe200078e3cffULL,
0x00000001061d7824ULL, 0x000fe200078e020bULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee20aULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x00005e0021227a11ULL, 0x000fe200078c40ffULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x00000000080d7faeULL, 0x0003e2000e901c46ULL,
0x0000000f2900720cULL, 0x000fc40003f46070ULL, 0x00005f0021247a11ULL, 0x000fe200030f4424ULL,
0x00000000181b7faeULL, 0x0005e2000e101c46ULL, 0x0000001d041f7210ULL, 0x000fe20007fde0ffULL,
0x000000080b1d7824ULL, 0x000fe200078e00ffULL, 0x0000001e050a7210ULL, 0x000fe40007fbe0ffULL,
0x0000000f2d00720cULL, 0x080fe40003f66070ULL, 0x000000000b0c7212ULL, 0x000fe400078e3cffULL,
0xfffffff82f2a7812ULL, 0x000fe200078ee220ULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x0000000f0b00720cULL, 0x000fe20003f86070ULL, 0x000000ffff0b7224ULL, 0x000fe200028e0627ULL,
0x00005e001f1e7a11ULL, 0x000fe200078c40ffULL, 0x000000102a217824ULL, 0x000fe200078e0207ULL,
0x0000001c05087210ULL, 0x002fc40007fbe0ffULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee20cULL,
0x00000010301d7824ULL, 0x000fe200078e0207ULL, 0x00005f001f1b7a11ULL, 0x004fe200030f4420ULL,
0x000000ffff097224ULL, 0x000fe200028e0625ULL, 0x000000342b277810ULL, 0x000fe20007ffe0ffULL,
0x00000010281f7824ULL, 0x100fe200078e0207ULL, 0x000000000a1d7faeULL, 0x0003e2000d101c46ULL,
0x00000026050c7210ULL, 0x000fe20007f5e0ffULL, 0x000000101c257824ULL, 0x000fe200078e0207ULL,
0x000000382b297810ULL, 0x000fe20007ffe0ffULL, 0x00000000081f7faeULL, 0x0005e2000d901c46ULL,
0x0000002205187210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fc400010e0623ULL,
0x000000101a237824ULL, 0x000fe200078e0207ULL, 0x0000001e051a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0624ULL, 0x000000000c217faeULL, 0x0007e2000c101c46ULL,
0x0000002c2b1d7810ULL, 0x002fe20007ffe0ffULL, 0x00000008271c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x000000282b097810ULL, 0x044fe20007ffe0ffULL,
0x0000000018237faeULL, 0x0003e2000c901c46ULL, 0x000000302b1f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0x0000000f0900720cULL, 0x040fe20003fa6070ULL,
0x00000001060b7824ULL, 0x000fe200078e0209ULL, 0x000000001a257faeULL, 0x0005e2000e101c46ULL,
0x0000000009087212ULL, 0x0c0fe200078e3cffULL, 0x00000008090d7824ULL, 0x008fe200078e00ffULL,
0x000000001d097212ULL, 0x000fc400078e3cffULL, 0x0000000b040b7210ULL, 0x000fe20007f1e0ffULL,
0x000000081d187824ULL, 0x002fe200078e00ffULL, 0xfffffff80d0c7812ULL, 0x000fe400078ee208ULL,
0x00005e000b0a7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff1a7224ULL, 0x004fe200000e06ffULL,
0xfffffff818187812ULL, 0x000fe400078ee209ULL, 0x0000000f1d00720cULL, 0x000fe20003f86070ULL,
0x00000001061d7824ULL, 0x000fe200078e021dULL, 0x00005f000b097a11ULL, 0x000fc400030f441aULL,
0x0000000a05087210ULL, 0x000fe40007fde0ffULL, 0x0000003c2b2b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1f00720cULL, 0x000fe20003f66070ULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000001d041d7210ULL, 0x000fe20007fde0ffULL, 0x0000000106197824ULL, 0x040fe200078e022bULL,
0x0000000f2700720cULL, 0x080fe40003f46070ULL, 0x0000000f2900720cULL, 0x080fe20003f26070ULL,
0x000000ffff227224ULL, 0x000fe200030e06ffULL, 0x0000000f2b00720cULL, 0x000fe20003f06070ULL,
0x000000081f0f7824ULL, 0x000fe200078e00ffULL, 0x00000000270b7212ULL, 0x080fe200078e3cffULL,
0x0000000106277824ULL, 0x040fe200078e0227ULL, 0x000000001f0a7212ULL, 0x000fe200078e3cffULL,
0x00000001061f7824ULL, 0x000fe200078e021fULL, 0x00005e001d207a11ULL, 0x000fc400078c40ffULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee20bULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee20aULL,
0x00000010180f7824ULL, 0x100fe200078e0207ULL, 0x00005f001d0b7a11ULL, 0x000fe200030f4422ULL,
0x000000101c1b7824ULL, 0x000fe200078e0207ULL, 0x00000020050a7210ULL, 0x000fe40007fde0ffULL,
0x00000000290d7212ULL, 0x080fe200078e3cffULL, 0x0000000106297824ULL, 0x000fe200078e0229ULL,
0x000000002b007212ULL, 0x040fe200078e3cffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x000000100c0d7824ULL, 0x000fe200078e0207ULL,
0x0000001f041f7210ULL, 0x000fe20007fde0ffULL, 0x000000082b2b7824ULL, 0x000fc400078e00ffULL,
0x000000101e1d7824ULL, 0x100fe200078e0207ULL, 0x00000000080d7faeULL, 0x0003e2000e901c46ULL,
0x000000ffff207224ULL, 0x000fe200030e06ffULL, 0x00005e001f067a11ULL, 0x040fe400078c40ffULL,
0x0000002704277210ULL, 0x040fe20007fbe0ffULL, 0x000000000a0f7faeULL, 0x0005e2000e101c46ULL,
0x00005f001f207a11ULL, 0x000fe400030f4420ULL, 0x0000002904297210ULL, 0x040fe40007f9e0ffULL,
0x00000019040c7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff047224ULL, 0x000fe200028e06ffULL,
0x00005e0027187a11ULL, 0x000fe200078a40ffULL, 0x000000101a197824ULL, 0x000fe200078e0207ULL,
0xfffffff82b007812ULL, 0x000fe200078ee200ULL, 0x000000ffff097224ULL, 0x002fe200030e06ffULL,
0x00005f00270d7a11ULL, 0x000fc400028f4404ULL, 0x0000000605067210ULL, 0x000fe20007fbe0ffULL,
0x00000010001f7824ULL, 0x000fe200078e0207ULL, 0x00005e000c0a7a11ULL, 0x044fe200078c40ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005e0029047a11ULL, 0x000fe200078840ffULL,
0x000000ffff077224ULL, 0x000fe200028e0620ULL, 0x0000001805087210ULL, 0x000fe40007fbe0ffULL,
0x00005f00290b7a11ULL, 0x000fe400020f4400ULL, 0x00005f000c007a11ULL, 0x000fe200030f4409ULL,
0x000000ffff097224ULL, 0x000fe200028e060dULL, 0x0000000405047210ULL, 0x040fe20007f9e0ffULL,
0x0000000006197faeULL, 0x0003e2000d901c46ULL, 0x0000000a050a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200020e060bULL, 0x00000000081b7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fc600028e0600ULL, 0x00000000041d7faeULL, 0x0003e8000c901c46ULL,
0x000000000a1f7faeULL, 0x0003e2000c101c46ULL, 0x00000d4000007947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x002fc80000011600ULL, 0x00000008070f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001007217810ULL, 0x000fe40007ffe0ffULL, 0x000000000f097212ULL, 0x0c0fe200078e3cffULL,
0x000000080f0c7824ULL, 0x000fe200078e00ffULL, 0x0000001807277810ULL, 0x000fe20007ffe0ffULL,
0x0000000821187824ULL, 0x000fe200078e00ffULL, 0x00000004070d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001060f7824ULL, 0x000fe200078e020fULL, 0xfffffff80c1b7812ULL, 0x000fe200078ee209ULL,
0x00000008270c7824ULL, 0x000fe200078e00ffULL, 0x0000000c071d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d197824ULL, 0x000fe200078e00ffULL, 0x00000000210b7212ULL, 0x080fe200078e3cffULL,
0x0000000106217824ULL, 0x040fe200078e0221ULL, 0x00000020072b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000027097212ULL, 0x000fe200078e3cffULL,
0x0000000106277824ULL, 0x000fe200078e0227ULL, 0x0000002807317810ULL, 0x000fc40007ffe0ffULL,
0xfffffff818237812ULL, 0x000fe200078ee20bULL, 0x000000082b187824ULL, 0x000fe200078e00ffULL,
0x0000001407257810ULL, 0x040fe40007ffe0ffULL, 0x0000001c07297810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c337812ULL, 0x000fe200078ee209ULL, 0x00000008310c7824ULL, 0x000fe200078e00ffULL,
0x000000000d087212ULL, 0x080fe200078e3cffULL, 0x00000008252d7824ULL, 0x000fe200078e00ffULL,
0x000000001d0a7212ULL, 0x080fe200078e3cffULL, 0x0000000829357824ULL, 0x000fe200078e00ffULL,
0x000000002b0b7212ULL, 0x080fe200078e3cffULL, 0x00000001060d7824ULL, 0x040fe200078e020dULL,
0x0000003007417810ULL, 0x000fe20007ffe0ffULL, 0x00000001061d7824ULL, 0x040fe200078e021dULL,
0x0000000031097212ULL, 0x000fe200078e3cffULL, 0x00000001062b7824ULL, 0x040fe200078e022bULL,
0xfffffff819197812ULL, 0x000fe200078ee208ULL, 0x0000000106317824ULL, 0x000fe200078e0231ULL,
0xfffffff81f1f7812ULL, 0x000fc400078ee20aULL, 0xfffffff818377812ULL, 0x000fe200078ee20bULL,
0x0000000841187824ULL, 0x000fe200078e00ffULL, 0x00000024072f7810ULL, 0x040fe40007ffe0ffULL,
0x0000002c073d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000025087212ULL, 0x080fe200078e3cffULL,
0x000000082f397824ULL, 0x000fe200078e00ffULL, 0x00000000290a7212ULL, 0x080fe200078e3cffULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c3b7812ULL, 0x000fe200078ee209ULL,
0x0000000106097824ULL, 0x040fe200078e0207ULL, 0x00000000410b7212ULL, 0x080fe200078e3cffULL,
0x0000000106257824ULL, 0x040fe200078e0225ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL,
0x0000000106297824ULL, 0x040fe200078e0229ULL, 0xfffffff835357812ULL, 0x000fe200078ee20aULL,
0x0000000106417824ULL, 0x040fe200078e0241ULL, 0x000000002f087212ULL, 0x080fe200078e3cffULL,
0x00000001062f7824ULL, 0x040fe200078e022fULL, 0x000000003d0a7212ULL, 0x000fe200078e3cffULL,
0x00000001063d7824ULL, 0x000fe200078e023dULL, 0xfffffff818437812ULL, 0x000fc400078ee20bULL,
0x00000007070b7812ULL, 0x040fe400078e4800ULL, 0x0000003407457810ULL, 0x040fe40007ffe0ffULL,
0x0000003807497810ULL, 0x040fe40007ffe0ffULL, 0x0000003c074d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106477824ULL, 0x000fe200078e0245ULL, 0x0000000904097210ULL, 0x000fe20007f1e0ffULL,
0x00000001064b7824ULL, 0x040fe200078e0249ULL, 0xfffffff839397812ULL, 0x000fe200078ee208ULL,
0x00000001064f7824ULL, 0x000fe200078e024dULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20aULL,
0x00000008450c7824ULL, 0x000fe200078e00ffULL, 0x0ffffff80b0b7812ULL, 0x000fc400078ef800ULL,
0x0000000045077212ULL, 0x080fe400078e3cffULL, 0x0000000049087212ULL, 0x0c0fe200078e3cffULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x000000004d0a7212ULL, 0x040fe200078e3cffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x0000002104217210ULL, 0x040fe20007f7e0ffULL,
0x000000084d4d7824ULL, 0x000fe200078e00ffULL, 0x00005e0009067a11ULL, 0x040fe400078040ffULL,
0x0000000f040f7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00005f0009007a11ULL, 0x000fc400000f4400ULL, 0x0000000d040d7210ULL, 0x040fe40007f1e0ffULL,
0x0000001d041d7210ULL, 0x000fe40007f5e0ffULL, 0x00005e0021207a11ULL, 0x000fe400078640ffULL,
0xfffffff80c457812ULL, 0x000fe200078ee207ULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0xfffffff849497812ULL, 0x000fe200078ee208ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005f0021217a11ULL, 0x000fe200018f441eULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0xfffffff84d4d7812ULL, 0x000fc400078ee20aULL, 0x00005e000f187a11ULL, 0x000fe400078240ffULL,
0x0000002b042b7210ULL, 0x000fe40007f7e0ffULL, 0x00005e000d0a7a11ULL, 0x000fe400078040ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078440ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005f000f097a11ULL, 0x000fe400008f440cULL, 0x00005f000d0d7a11ULL, 0x000fc400000f4408ULL,
0x00005f001d1d7a11ULL, 0x000fe400010f441aULL, 0x0000002704277210ULL, 0x040fe40007f3e0ffULL,
0x0000002504257210ULL, 0x040fe40007f1e0ffULL, 0x0000002904297210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e002b2c7a11ULL, 0x000fe200078640ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e00271e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff227224ULL, 0x000fe200010e06ffULL, 0x00005f002b2a7a11ULL, 0x000fc400018f442aULL,
0x0000002f042f7210ULL, 0x000fe40007f7e0ffULL, 0x00005e00251a7a11ULL, 0x000fe400078040ffULL,
0x00005e0029247a11ULL, 0x000fe400078440ffULL, 0x00005f0027267a11ULL, 0x000fe200008f440cULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00005f0025257a11ULL, 0x000fe400000f4408ULL,
0x00005f0029287a11ULL, 0x000fc400010f4422ULL, 0x0000003d043d7210ULL, 0x040fe40007f1e0ffULL,
0x0000004104417210ULL, 0x040fe40007f3e0ffULL, 0x00005e002f227a11ULL, 0x040fe400078c40ffULL,
0x0000003104077210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x0000100060087811ULL, 0x000fe400078e70ffULL, 0x00005f002f2e7a11ULL, 0x000fe200030f440cULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000004704477210ULL, 0x040fe20007f7e0ffULL,
0x000000100b0f7824ULL, 0x100fe200078e0208ULL, 0x0000004b044b7210ULL, 0x040fe20007f9e0ffULL,
0x0000001019277824ULL, 0x100fe200078e0208ULL, 0x0000004f044f7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff047224ULL, 0x000fe200010e06ffULL, 0x00005e003d327a11ULL, 0x000fe200078040ffULL,
0x000000101b297824ULL, 0x100fe200078e0208ULL, 0x00005e0041367a11ULL, 0x000fe200078240ffULL,
0x000000101f2b7824ULL, 0x100fe200078e0208ULL, 0x00005e0007307a11ULL, 0x000fe200078440ffULL,
0x00000010232f7824ULL, 0x000fe200078e0208ULL, 0x00005f003d3d7a11ULL, 0x000fe200000f440cULL,
0x000000102d317824ULL, 0x000fe200078e0208ULL, 0x00005f0041347a11ULL, 0x000fe200008f4434ULL,
0x0000001033337824ULL, 0x000fe200078e0208ULL, 0x00005f0007237a11ULL, 0x000fe200010f4404ULL,
0x0000001035357824ULL, 0x100fe200078e0208ULL, 0x00000070052d7812ULL, 0x000fe200078ec0ffULL,
0x0000001037377824ULL, 0x100fe200078e0208ULL, 0x00005e0047387a11ULL, 0x000fe200078240ffULL,
0x0000001039397824ULL, 0x100fe200078e0208ULL, 0x00005e004b3a7a11ULL, 0x000fe200078440ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0208ULL, 0x000000062d047210ULL, 0x000fe20007f1e0ffULL,
0x000000103f3f7824ULL, 0x000fc400078e0208ULL, 0x0000001043437824ULL, 0x100fe400078e0208ULL,
0x0000001045457824ULL, 0x100fe400078e0208ULL, 0x0000001049497824ULL, 0x100fe400078e0208ULL,
0x000000104d4d7824ULL, 0x000fe400078e0208ULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005e004f3e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff0c7224ULL, 0x000fc400020e06ffULL,
0x000000ffff3c7224ULL, 0x000fe200028e06ffULL, 0x00005f0047477a11ULL, 0x000fe200008f4408ULL,
0x000000ffff057224ULL, 0x000fe200000e0600ULL, 0x00005f004b4b7a11ULL, 0x000fe400010f440cULL,
0x0000000a2d067210ULL, 0x000fe40007f3e0ffULL, 0x00005f004f3c7a11ULL, 0x000fe200018f443cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040f7faeULL, 0x0003e2000b901c46ULL,
0x000000182d087210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e060dULL,
0x0000001c2d0a7210ULL, 0x000fc40007f7e0ffULL, 0x000000202d0c7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000001a2d187210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e061dULL, 0x0000001e2d1a7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0621ULL, 0x000000242d1c7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200020e0625ULL, 0x0000002c2d1e7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e0626ULL, 0x000000222d207210ULL, 0x040fe20007f7e0ffULL,
0x0000000006277faeULL, 0x0005e2000b901c46ULL, 0x000000302d227210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e0628ULL, 0x000000322d247210ULL, 0x040fe20007f9e0ffULL,
0x0000000008297faeULL, 0x0007e2000b901c46ULL, 0x000000362d267210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e062aULL, 0x000000382d287210ULL, 0x040fe20007f3e0ffULL,
0x000000000a2b7faeULL, 0x0009e2000b901c46ULL, 0x0000003a2d2a7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e062eULL, 0x0000003e2d2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000000c2f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc400028e0623ULL,
0x000000ffff257224ULL, 0x000fe200020e063dULL, 0x0000000018317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff277224ULL, 0x004fe400000e0634ULL, 0x000000ffff297224ULL, 0x008fe200008e0647ULL,
0x000000001a337faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2b7224ULL, 0x010fe400010e064bULL,
0x000000ffff2d7224ULL, 0x000fe200018e063cULL, 0x000000001c357faeULL, 0x0003e8000b901c46ULL,
0x000000001e377faeULL, 0x0003e8000b901c46ULL, 0x0000000020397faeULL, 0x0003e8000b901c46ULL,
0x00000000223b7faeULL, 0x0003e8000b901c46ULL, 0x00000000243f7faeULL, 0x0003e8000b901c46ULL,
0x0000000026437faeULL, 0x0003e8000b901c46ULL, 0x0000000028457faeULL, 0x0003e8000b901c46ULL,
0x000000002a497faeULL, 0x0003e8000b901c46ULL, 0x000000002c4d7faeULL, 0x0003e4000b901c46ULL,
0x01b60400ff057984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000005ff7812ULL, 0x002fc60007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x01b60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000141700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x000064000e0e7a24ULL, 0x000fe200078e02ffULL, 0x0001b688600d7811ULL, 0x040fe200078e18ffULL,
0x00000020600b7824ULL, 0x000fe200078e00ffULL, 0xffffffff140c7810ULL, 0x000fe40007ffe0ffULL,
0x00000100170a7824ULL, 0x000fe200078e0212ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000000a6100720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x014fea0003800000ULL,
0x0000000117037810ULL, 0x000fe20007ffe0ffULL, 0x0000001310137224ULL, 0x000fe200078e02ffULL,
0x000000400a007812ULL, 0x000fe400078ec0ffULL, 0x000000140300720cULL, 0x000fc60003f06070ULL,
0x0000000111317824ULL, 0x000fd400078e0200ULL, 0x00000d8000008947ULL, 0x000fea0003800000ULL,
0x00000003ff8a7819ULL, 0x002fc8000001160fULL, 0x000000048a887810ULL, 0x040fe40007ffe0ffULL,
0x000000088a867810ULL, 0x000fe40007ffe0ffULL, 0x0000000f88857212ULL, 0x0c0fe200078e3cffULL,
0x0000000888007824ULL, 0x000fe200078e00ffULL, 0x000000108a827810ULL, 0x000fe20007ffe0ffULL,
0x0000000886027824ULL, 0x040fe200078e00ffULL, 0x0000000f86837212ULL, 0x000fe400078e3cffULL,
0xfffffff800857812ULL, 0x000fe200078ee285ULL, 0x0000000882007824ULL, 0x000fe200078e00ffULL,
0x000000148a807810ULL, 0x000fc40007ffe0ffULL, 0x0000000f827f7212ULL, 0x080fe400078e3cffULL,
0xfffffff802837812ULL, 0x000fe200078ee283ULL, 0x0000000880027824ULL, 0x000fe200078e00ffULL,
0xfffffff8007f7812ULL, 0x000fe200078ee27fULL, 0x000000018a007824ULL, 0x000fe200078e0231ULL,
0x0000000f807d7212ULL, 0x000fe400078e3cffULL, 0x0000000c8a847810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8027d7812ULL, 0x000fc400078ee27dULL, 0x0000000013027210ULL, 0x040fe20007f1e0ffULL,
0x0000000188007824ULL, 0x000fe200078e0231ULL, 0x0000000f84817212ULL, 0x0c0fe200078e3cffULL,
0x0000000884047824ULL, 0x000fe200078e00ffULL, 0x000000188a7e7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200000e06ffULL, 0x0000000013007210ULL, 0x000fe40007f3e0ffULL,
0x000000208a7a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff804817812ULL, 0x000fe200078ee281ULL,
0x000000ffff037224ULL, 0x000fe200008e06ffULL, 0x00005e0000287a11ULL, 0x000fe200078240ffULL,
0x000000087e047824ULL, 0x040fe200078e00ffULL, 0x0000000f7e7b7212ULL, 0x000fe200078e3cffULL,
0x000000087a067824ULL, 0x000fe200078e00ffULL, 0x0000001c8a7c7810ULL, 0x000fc40007ffe0ffULL,
0x00005e00022a7a11ULL, 0x000fe400078040ffULL, 0x0000000f7a777212ULL, 0x080fe400078e3cffULL,
0x00005f0000297a11ULL, 0x000fe200008f4403ULL, 0x0000000186007824ULL, 0x000fe200078e0231ULL,
0xfffffff8047b7812ULL, 0x000fe200078ee27bULL, 0x000000087c047824ULL, 0x000fe200078e00ffULL,
0x00005f00022b7a11ULL, 0x000fe200000f4405ULL, 0x0000000184027824ULL, 0x000fe200078e0231ULL,
0x0000000f7c797212ULL, 0x000fc400078e3cffULL, 0xfffffff806777812ULL, 0x000fe200078ee277ULL,
0x0000000180067824ULL, 0x000fe200078e0231ULL, 0x0000000013007210ULL, 0x040fe40007f1e0ffULL,
0xfffffff804797812ULL, 0x000fe200078ee279ULL, 0x0000000182047824ULL, 0x000fe200078e0231ULL,
0x0000000213027210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000000613067210ULL, 0x040fe40007f7e0ffULL, 0x00005e00002e7a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000000413047210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff037224ULL, 0x000fe200018e06ffULL, 0x00005e00022c7a11ULL, 0x000fc400078240ffULL,
0x00005e00061e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x00005f00002f7a11ULL, 0x000fe200000f4409ULL, 0x000000017e007824ULL, 0x000fe200078e0231ULL,
0x000000248a787810ULL, 0x000fe40007ffe0ffULL, 0x00005f00022d7a11ULL, 0x000fe200008f4407ULL,
0x000000017c027824ULL, 0x000fe200078e0231ULL, 0x00005e0004207a11ULL, 0x000fe400078440ffULL,
0x00005f00061f7a11ULL, 0x000fe200018f4403ULL, 0x0000000178067824ULL, 0x000fe200078e0231ULL,
0x0000000013007210ULL, 0x000fc40007f1e0ffULL, 0x00005f0004217a11ULL, 0x000fe200010f4405ULL,
0x000000017a047824ULL, 0x000fe200078e0231ULL, 0x0000000213027210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000000613067210ULL, 0x040fe40007f7e0ffULL,
0x00005e0000267a11ULL, 0x000fe200078040ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x000000288a767810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff037224ULL, 0x000fe200018e06ffULL,
0x0000000413047210ULL, 0x000fc40007f5e0ffULL, 0x00005e0002247a11ULL, 0x000fe400078240ffULL,
0x0000002c8a747810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x00005e00061a7a11ULL, 0x000fe400078640ffULL, 0x00005f0000277a11ULL, 0x000fe200000f4409ULL,
0x0000000176007824ULL, 0x000fe200078e0231ULL, 0x000000348a707810ULL, 0x000fe40007ffe0ffULL,
0x00005f0002257a11ULL, 0x000fe200008f4407ULL, 0x0000000174027824ULL, 0x000fe200078e0231ULL,
0x00005e0004227a11ULL, 0x000fc400078440ffULL, 0x00005f00061b7a11ULL, 0x000fe200018f4403ULL,
0x0000000170067824ULL, 0x000fe200078e0231ULL, 0x000000308a727810ULL, 0x040fe40007ffe0ffULL,
0x000000388a6e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000013077210ULL, 0x040fe40007f1e0ffULL,
0x00005f0004237a11ULL, 0x000fe200010f4405ULL, 0x0000000172047824ULL, 0x100fe200078e0231ULL,
0x0000000213057210ULL, 0x040fe20007f7e0ffULL, 0x000000016e187824ULL, 0x000fe200078e0231ULL,
0x0000000613027210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000003c8a6c7810ULL, 0x000fc40007ffe0ffULL, 0x00005e00071c7a11ULL, 0x000fe400078840ffULL,
0x0000000413197210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff047224ULL, 0x000fe200018e06ffULL,
0x00005e0005087a11ULL, 0x000fe200078a40ffULL, 0x000000016c307824ULL, 0x000fe200078e0231ULL,
0x0000001813007210ULL, 0x000fe40007f7e0ffULL, 0x00005f00071d7a11ULL, 0x000fe200020f4406ULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005e0002067a11ULL, 0x000fc400078240ffULL,
0x00005f0005097a11ULL, 0x000fe200028f4404ULL, 0x000000ffff057224ULL, 0x000fe200018e06ffULL,
0x0000003013037210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e0000047a11ULL, 0x000fe200078640ffULL, 0x0000000161137824ULL, 0x000fe200078e0a0aULL,
0x00005f0002077a11ULL, 0x000fe200008f4407ULL, 0x000000ffff327224ULL, 0x000fe200000e06ffULL,
0x0000000f8a027212ULL, 0x000fe400078e3cffULL, 0x00005e0019187a11ULL, 0x000fc400078440ffULL,
0x00005f0000057a11ULL, 0x000fe400018f4405ULL, 0x000000070f007812ULL, 0x000fe400078ec0ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x00005f0019197a11ULL, 0x000fe400010f4430ULL,
0x000000138a00720cULL, 0x080fe40003f26070ULL, 0x000000138800720cULL, 0x000fc40003f46070ULL,
0x000000138600720cULL, 0x080fe40003f66070ULL, 0x0000300060307811ULL, 0x000fe400078e70ffULL,
0x0000000800317812ULL, 0x000fe400078efcffULL, 0x0ffffff802877812ULL, 0x000fe200078ef80fULL,
0x0000001085357824ULL, 0x000fe200078e0230ULL, 0x000000138400720cULL, 0x000fe20003f86070ULL,
0x00000010312a7825ULL, 0x000fe200078e002aULL, 0x00005e0003027a11ULL, 0x000fc400078040ffULL,
0x0000000f78757212ULL, 0x000fe200078e3cffULL, 0x0000001087337824ULL, 0x000fe200078e0230ULL,
0x00005f0003037a11ULL, 0x000fe200000f4432ULL, 0x0000001031287825ULL, 0x000fe200078e0028ULL,
0x000000138200720cULL, 0x080fe40003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a337faeULL, 0x0003e2000c901c46ULL, 0x0000001083377824ULL, 0x000fe200078e0230ULL,
0x000000138000720cULL, 0x080fe20003f26070ULL, 0x00000010312e7825ULL, 0x000fe200078e002eULL,
0x0000000028357faeULL, 0x0005e2000d101c46ULL, 0x000000137e00720cULL, 0x000fc40003f46070ULL,
0x0000001081397824ULL, 0x000fe200078e0230ULL, 0x000000002e377faeULL, 0x0007e2000d901c46ULL,
0x00000010312c7825ULL, 0x000fe200078e002cULL, 0x000000137c00720cULL, 0x000fe40003f66070ULL,
0x0000000f76737212ULL, 0x000fe200078e3cffULL, 0x000000107f3b7824ULL, 0x000fe200078e0230ULL,
0x000000002c397faeULL, 0x0009e2000e101c46ULL, 0x000000137a00720cULL, 0x000fe20003f86070ULL,
0x0000001031207825ULL, 0x000fe200078e0020ULL, 0x0000000f74717212ULL, 0x000fc400078e3cffULL,
0x000000136e00720cULL, 0x080fe20003fa6070ULL, 0x000000107d3d7824ULL, 0x000fe200078e0230ULL,
0x00000000203b7faeULL, 0x000be2000c101c46ULL, 0x00000010311e7825ULL, 0x000fe200078e001eULL,
0x000000137800720cULL, 0x080fe40003f06070ULL, 0x000000136c00720cULL, 0x080fe20003fc6070ULL,
0x000000107b2b7824ULL, 0x002fe200078e0230ULL, 0x000000001e3d7faeULL, 0x0003e2000c901c46ULL,
0x0000001031267825ULL, 0x000fe200078e0026ULL, 0x000000137600720cULL, 0x000fc40003f26070ULL,
0x0000000f726f7212ULL, 0x000fe200078e3cffULL, 0x0000001079297824ULL, 0x004fe200078e0230ULL,
0x00000000262b7faeULL, 0x0005e2000d101c46ULL, 0x0000001031247825ULL, 0x000fe200078e0024ULL,
0x000000137400720cULL, 0x000fe40003f46070ULL, 0x0000000f706d7212ULL, 0x000fe200078e3cffULL,
0x00000010772f7824ULL, 0x008fe200078e0230ULL, 0x0000000024297faeULL, 0x0007e2000d901c46ULL,
0x0000001031227825ULL, 0x000fe200078e0022ULL, 0x000000137200720cULL, 0x000fc40003f66070ULL,
0x0000000f6c6a7212ULL, 0x000fe200078e3cffULL, 0x00000008781e7824ULL, 0x002fe200078e00ffULL,
0x00000000222f7faeULL, 0x0003e2000e101c46ULL, 0x0000000876207824ULL, 0x020fe200078e00ffULL,
0x000000137000720cULL, 0x000fe20003f86070ULL, 0x000000086c137824ULL, 0x000fe200078e00ffULL,
0xfffffff81e757812ULL, 0x000fe200078ee275ULL, 0x00000008721e7824ULL, 0x000fe200078e00ffULL,
0xfffffff820737812ULL, 0x000fe200078ee273ULL, 0x0000000870207824ULL, 0x000fe200078e00ffULL,
0x0000000f6e6b7212ULL, 0x000fe200078e3cffULL, 0x00000010311a7825ULL, 0x000fe200078e001aULL,
0xfffffff81e6f7812ULL, 0x000fc400078ee26fULL, 0xfffffff8206d7812ULL, 0x000fe200078ee26dULL,
0x0000000874227824ULL, 0x002fe200078e00ffULL, 0xfffffff8136a7812ULL, 0x000fe200078ee26aULL,
0x0000001075137824ULL, 0x100fe400078e0230ULL, 0x00000010731f7824ULL, 0x000fe200078e0230ULL,
0xfffffff822717812ULL, 0x000fe200078ee271ULL, 0x000000086e227824ULL, 0x000fe200078e00ffULL,
0x000000001a137faeULL, 0x0009e2000c101c46ULL, 0x00000010311c7825ULL, 0x000fc600078e001cULL,
0xfffffff8226b7812ULL, 0x000fe200078ee26bULL, 0x0000001031087825ULL, 0x000fe200078e0008ULL,
0x000000001c1f7faeULL, 0x0009e6000c901c46ULL, 0x0000001071217824ULL, 0x000fe400078e0230ULL,
0x0000001031187825ULL, 0x000fc600078e0018ULL, 0x0000000008217faeULL, 0x0009e2000d101c46ULL,
0x000000106f237824ULL, 0x000fe400078e0230ULL, 0x0000001031067825ULL, 0x000fc600078e0006ULL,
0x0000000018237faeULL, 0x0009e2000d901c46ULL, 0x000000106d257824ULL, 0x008fe400078e0230ULL,
0x0000001031047825ULL, 0x000fc600078e0004ULL, 0x0000000006257faeULL, 0x0009e2000e101c46ULL,
0x000000106b277824ULL, 0x004fe400078e0230ULL, 0x0000001031027825ULL, 0x000fc600078e0002ULL,
0x0000000004277faeULL, 0x0009e2000e901c46ULL, 0x000000106a297824ULL, 0x000fca00078e0230ULL,
0x0000000002297faeULL, 0x0009e2000f101c46ULL, 0x00000c6000007947ULL, 0x000fea0003800000ULL,
0x00000003ff8a7819ULL, 0x002fe4000001160fULL, 0x0000300060327811ULL, 0x000fe400078e70ffULL,
0x000000048a887810ULL, 0x040fe40007ffe0ffULL, 0x000000108a827810ULL, 0x000fe40007ffe0ffULL,
0x0000000f88857212ULL, 0x040fe200078e3cffULL, 0x0000000888007824ULL, 0x000fe200078e00ffULL,
0x000000088a867810ULL, 0x000fc40007ffe0ffULL, 0x0000000f827f7212ULL, 0x080fe400078e3cffULL,
0xfffffff800857812ULL, 0x000fe200078ee285ULL, 0x0000000882007824ULL, 0x000fe200078e00ffULL,
0x000000208a7a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000886027824ULL, 0x000fe200078e00ffULL,
0x0000000c8a847810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8007f7812ULL, 0x000fe200078ee27fULL,
0x000000087a007824ULL, 0x000fe200078e00ffULL, 0x0000000f86837212ULL, 0x000fe200078e3cffULL,
0x0000000884047824ULL, 0x000fe200078e00ffULL, 0x000000148a807810ULL, 0x000fc40007ffe0ffULL,
0x0000000f7a777212ULL, 0x080fe400078e3cffULL, 0x0000000f84817212ULL, 0x080fe400078e3cffULL,
0x000000188a7e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff802837812ULL, 0x000fe200078ee283ULL,
0x0000000880027824ULL, 0x000fe200078e00ffULL, 0x0000001c8a7c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff800777812ULL, 0x000fe200078ee277ULL, 0x000000018a007824ULL, 0x000fe200078e0231ULL,
0x0000000f807d7212ULL, 0x080fe200078e3cffULL, 0x000000087c067824ULL, 0x000fe200078e00ffULL,
0x000000248a787810ULL, 0x000fe20007ffe0ffULL, 0x00000010773b7824ULL, 0x000fe200078e0232ULL,
0xfffffff804817812ULL, 0x000fe200078ee281ULL, 0x000000087e047824ULL, 0x040fe200078e00ffULL,
0x0000000f7e7b7212ULL, 0x000fc400078e3cffULL, 0x000000288a767810ULL, 0x000fe40007ffe0ffULL,
0x0000000f7c797212ULL, 0x080fe400078e3cffULL, 0xfffffff8027d7812ULL, 0x000fe200078ee27dULL,
0x0000000878027824ULL, 0x000fe200078e00ffULL, 0x0000002c8a747810ULL, 0x000fe40007ffe0ffULL,
0x0000000013007210ULL, 0x000fe40007f1e0ffULL, 0x0000000f78757212ULL, 0x000fc400078e3cffULL,
0xfffffff8047b7812ULL, 0x000fe200078ee27bULL, 0x0000000876047824ULL, 0x000fe200078e00ffULL,
0xfffffff806797812ULL, 0x000fe200078ee279ULL, 0x0000000874067824ULL, 0x000fe200078e00ffULL,
0x0000000f76737212ULL, 0x080fe200078e3cffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x000000308a727810ULL, 0x000fe20007ffe0ffULL, 0x0000001079397824ULL, 0x000fe200078e0232ULL,
0x0000000f74717212ULL, 0x000fe400078e3cffULL, 0xfffffff802757812ULL, 0x000fc400078ee275ULL,
0x000000348a707810ULL, 0x040fe40007ffe0ffULL, 0x000000388a6e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010753d7824ULL, 0x100fe200078e0232ULL, 0x00005e0000027a11ULL, 0x000fe200078040ffULL,
0x0000000170287824ULL, 0x000fe200078e0231ULL, 0xfffffff804737812ULL, 0x000fe200078ee273ULL,
0x0000000872047824ULL, 0x000fe200078e00ffULL, 0xfffffff806717812ULL, 0x000fe200078ee271ULL,
0x0000000870067824ULL, 0x000fe200078e00ffULL, 0x0000000f726f7212ULL, 0x080fe200078e3cffULL,
0x000000086e087824ULL, 0x000fe200078e00ffULL, 0x00005f0000037a11ULL, 0x000fe200000f4403ULL,
0x0000000188007824ULL, 0x100fe200078e0231ULL, 0x0000000f706d7212ULL, 0x080fe200078e3cffULL,
0x000000016e2a7824ULL, 0x040fe200078e0231ULL, 0x0000000f6e6b7212ULL, 0x000fe200078e3cffULL,
0x00000010733f7824ULL, 0x000fe200078e0232ULL, 0xfffffff8046f7812ULL, 0x000fe200078ee26fULL,
0x0000000186047824ULL, 0x000fe200078e0231ULL, 0xfffffff8066d7812ULL, 0x000fe200078ee26dULL,
0x0000000184067824ULL, 0x000fe200078e0231ULL, 0xfffffff8086b7812ULL, 0x000fe200078ee26bULL,
0x0000000182087824ULL, 0x000fe200078e0231ULL, 0x0000000013007210ULL, 0x000fc40007f1e0ffULL,
0x0000000413077210ULL, 0x040fe40007f3e0ffULL, 0x00000006131b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e06ffULL, 0x00000008131d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005e0000187a11ULL, 0x040fe200078040ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x00005e0007087a11ULL, 0x000fe200078240ffULL,
0x000000ffff1e7224ULL, 0x000fe200018e06ffULL, 0x00005f0000197a11ULL, 0x000fe200000f4405ULL,
0x0000000180007824ULL, 0x000fe200078e0231ULL, 0x00005e001b067a11ULL, 0x000fc400078440ffULL,
0x00005e001d047a11ULL, 0x000fe400078640ffULL, 0x00005f0007097a11ULL, 0x000fe200008f441aULL,
0x000000017e1a7824ULL, 0x100fe200078e0231ULL, 0x00005f001b077a11ULL, 0x000fe200010f441cULL,
0x000000017c1c7824ULL, 0x100fe200078e0231ULL, 0x00005f001d057a11ULL, 0x000fe200018f441eULL,
0x000000017a1e7824ULL, 0x000fe200078e0231ULL, 0x0000000013007210ULL, 0x040fe40007f1e0ffULL,
0x0000001a131d7210ULL, 0x000fc40007f3e0ffULL, 0x0000001c13237210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e06ffULL, 0x0000001e13257210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff227224ULL, 0x000fe200008e06ffULL, 0x00005e0000207a11ULL, 0x040fe200078040ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005e001d1e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x00005f0000217a11ULL, 0x000fe200000f441bULL,
0x0000000178007824ULL, 0x000fe200078e0231ULL, 0x00005e00231c7a11ULL, 0x000fc400078440ffULL,
0x00005e00251a7a11ULL, 0x000fe400078640ffULL, 0x0000003c8a6c7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001d1f7a11ULL, 0x000fe200008f4422ULL, 0x0000000176227824ULL, 0x100fe200078e0231ULL,
0x00005f00231d7a11ULL, 0x000fe200010f4424ULL, 0x0000000174247824ULL, 0x100fe200078e0231ULL,
0x00005f00251b7a11ULL, 0x000fe200018f4426ULL, 0x0000000172267824ULL, 0x100fe200078e0231ULL,
0x0000000013007210ULL, 0x040fe20007fbe0ffULL, 0x000000016c2c7824ULL, 0x040fe200078e0231ULL,
0x0000002213257210ULL, 0x040fe20007f9e0ffULL, 0x000000086c277824ULL, 0x000fe200078e00ffULL,
0x0000002413297210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff237224ULL, 0x000fe200028e06ffULL,
0x00000026132b7210ULL, 0x000fc40007f5e0ffULL, 0x00000028132d7210ULL, 0x040fe40007f1e0ffULL,
0x0000002a13357210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x0000002c13377210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x0000000f8a137212ULL, 0x080fe200078e3cffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e0000227a11ULL, 0x000fe200078c40ffULL, 0x000000ffff367224ULL, 0x000fe200000e06ffULL,
0x0000000f6c6a7212ULL, 0x000fe200078e3cffULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x00005e0025267a11ULL, 0x000fe200078840ffULL, 0x000000ffff3a7224ULL, 0x000fe200028e06ffULL,
0x0000000713287812ULL, 0x000fc400078ec0ffULL, 0x00005e0029247a11ULL, 0x000fe400078640ffULL,
0x00005f0000237a11ULL, 0x000fe400030f4423ULL, 0xfffffff8276a7812ULL, 0x000fe400078ee26aULL,
0x000000070f007812ULL, 0x000fe400078ec0ffULL, 0x00005f0025277a11ULL, 0x000fe400020f442aULL,
0x0ffffff828877812ULL, 0x000fc400078ef80fULL, 0x00005f0029257a11ULL, 0x000fe400018f442cULL,
0x00005e002b2e7a11ULL, 0x000fe200078440ffULL, 0x0000001087337824ULL, 0x000fe200078e0232ULL,
0x00005e002d2c7a11ULL, 0x000fe400078040ffULL, 0x00005e00352a7a11ULL, 0x000fe400078240ffULL,
0x00005e0037287a11ULL, 0x000fe400078640ffULL, 0x0000000800137812ULL, 0x000fc400078efcffULL,
0x00005f002b2f7a11ULL, 0x000fe400010f4434ULL, 0x00005f002d2d7a11ULL, 0x000fe200000f4436ULL,
0x0000001013307825ULL, 0x000fe200078e0002ULL, 0x00005f00352b7a11ULL, 0x000fe400008f4438ULL,
0x00005f0037297a11ULL, 0x000fe200018f443aULL, 0x0000001013027825ULL, 0x040fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030337faeULL, 0x0003e6000b901c46ULL,
0x0000001013087825ULL, 0x000fc800078e0008ULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x0000001013047825ULL, 0x000fc800078e0004ULL, 0x0000001013207825ULL, 0x000fc800078e0020ULL,
0x00000010131e7825ULL, 0x000fc800078e001eULL, 0x00000010131c7825ULL, 0x000fc800078e001cULL,
0x00000010131a7825ULL, 0x000fc800078e001aULL, 0x0000001013227825ULL, 0x000fc800078e0022ULL,
0x0000001013267825ULL, 0x000fc800078e0026ULL, 0x0000001013247825ULL, 0x000fc800078e0024ULL,
0x00000010132e7825ULL, 0x000fc800078e002eULL, 0x00000010132c7825ULL, 0x000fc800078e002cULL,
0x00000010132a7825ULL, 0x000fc800078e002aULL, 0x0000001013287825ULL, 0x000fc800078e0028ULL,
0x0000001085137824ULL, 0x100fe400078e0232ULL, 0x0000001083197824ULL, 0x100fe400078e0232ULL,
0x0000001081317824ULL, 0x102fe200078e0232ULL, 0x0000000002137faeULL, 0x0003e2000b901c46ULL,
0x000000107f337824ULL, 0x100fe400078e0232ULL, 0x000000107d357824ULL, 0x100fe200078e0232ULL,
0x0000000008197faeULL, 0x0005e2000b901c46ULL, 0x000000107b377824ULL, 0x000fc600078e0232ULL,
0x0000000006317faeULL, 0x0007e8000b901c46ULL, 0x0000000004337faeULL, 0x0009e2000b901c46ULL,
0x0000001071037824ULL, 0x102fe400078e0232ULL, 0x000000106a137824ULL, 0x100fe200078e0232ULL,
0x0000000020357faeULL, 0x0003e2000b901c46ULL, 0x000000106b097824ULL, 0x004fc600078e0232ULL,
0x000000001e377faeULL, 0x0003e2000b901c46ULL, 0x000000106d077824ULL, 0x008fc600078e0232ULL,
0x000000001c397faeULL, 0x0003e2000b901c46ULL, 0x000000106f057824ULL, 0x010fc600078e0232ULL,
0x000000001a3b7faeULL, 0x0003e8000b901c46ULL, 0x00000000223d7faeULL, 0x0003e8000b901c46ULL,
0x00000000263f7faeULL, 0x0003e8000b901c46ULL, 0x0000000024037faeULL, 0x0003e8000b901c46ULL,
0x000000002e057faeULL, 0x0003e8000b901c46ULL, 0x000000002c077faeULL, 0x0003e8000b901c46ULL,
0x000000002a097faeULL, 0x0003e8000b901c46ULL, 0x0000000028137faeULL, 0x0003e4000b901c46ULL,
0x00000300ff027624ULL, 0x010fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff137424ULL, 0x002fc400078e00ffULL, 0x0000000202157824ULL, 0x000fca00078e0215ULL,
0x000000161500720cULL, 0x000fda0003f06070ULL, 0x000000020e028824ULL, 0x000fe400078e0215ULL,
0x00000004ff038424ULL, 0x000fe200078e00ffULL, 0x00000004ff097819ULL, 0x000fe2000001160fULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600002028625ULL, 0x000fca00078e0003ULL,
0x0000000602138981ULL, 0x000362000c1e1900ULL, 0x0000000800087812ULL, 0x000fe200078ef80fULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000709057812ULL, 0x000fca00078e7808ULL,
0x0000001008057824ULL, 0x000fc800078e0205ULL, 0x0000001005057824ULL, 0x000fc800078e00ffULL,
0x0000000809037824ULL, 0x002fe200078e00ffULL, 0x000000000534783bULL, 0x000fe20000000200ULL,
0x0000400060897824ULL, 0x000fe200078e00ffULL, 0x000000018a407812ULL, 0x000fe400078ec0ffULL,
0xfffffff803007812ULL, 0x000fe400078ee200ULL, 0x00001000898c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000700477812ULL, 0x040fe200078ec0ffULL, 0x0000000800027824ULL, 0x000fe200078e00ffULL,
0x0000000209037810ULL, 0x000fc40007ffe0ffULL, 0x00000001478b7812ULL, 0x000fe400078e788aULL,
0x0000000703037812ULL, 0x000fe400078e7808ULL, 0x000000028b8b7212ULL, 0x000fe400078efcffULL,
0x0000001000637810ULL, 0x000fe20007ffe0ffULL, 0x0000001008037824ULL, 0x000fe200078e0203ULL,
0x0000002000627810ULL, 0x040fe20007ffe0ffULL, 0x000000108b1c7824ULL, 0x000fe200078e028cULL,
0x0000003000007810ULL, 0x000fe20007ffe0ffULL, 0x0000001003307824ULL, 0x000fe200078e00ffULL,
0x0000000763457812ULL, 0x040fe200078ec0ffULL, 0x0000000863637824ULL, 0x000fe200078e00ffULL,
0x0000000762437812ULL, 0x000fe200078ec0ffULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x0000000700417812ULL, 0x000fe200078ec0ffULL, 0x0000000862627824ULL, 0x000fe200078e00ffULL,
0x0000000247077812ULL, 0x000fe200078e1e40ULL, 0x0000000800007824ULL, 0x000fe200078e00ffULL,
0x0000000145047812ULL, 0x100fe200078e788aULL, 0x000000003030783bULL, 0x000fe20000000200ULL,
0x0000000143037812ULL, 0x000fc400078e788aULL, 0x0000000141677812ULL, 0x000fe400078e788aULL,
0x0000000207667212ULL, 0x000fe400078efcffULL, 0x0000006304697212ULL, 0x000fe400078efcffULL,
0x0000006203687212ULL, 0x000fe200078efcffULL, 0x0000001066587824ULL, 0x100fe200078e028cULL,
0x0000000067677212ULL, 0x000fe200078efcffULL, 0x00000010693c7824ULL, 0x000fe200078e028cULL,
0x0000000243037812ULL, 0x000fe200078e1e40ULL, 0x0000001068187824ULL, 0x000fe200078e028cULL,
0x0000000245207812ULL, 0x000fe200078e1e40ULL, 0x0000001067047824ULL, 0x000fe200078e028cULL,
0x000000005858783bULL, 0x000ea20000000200ULL, 0x0000006203647212ULL, 0x000fc400078efcffULL,
0x0000006320657212ULL, 0x000fe200078efcffULL, 0x000000003c3c783bULL, 0x000ee20000000200ULL,
0x0000000241037812ULL, 0x000fe200078e1e40ULL, 0x0000001064287824ULL, 0x100fe400078e028cULL,
0x000000001818783bULL, 0x000f220000000200ULL, 0x0000001065207824ULL, 0x000fc600078e028cULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000001c345c723cULL, 0x042fe600000418ffULL, 0x000000002020783bULL, 0x000e6a0000000200ULL,
0x0000001e341c723cULL, 0x000fde00000418ffULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000058305c723cULL, 0x044ff0000004185cULL, 0x0000005a3058723cULL, 0x000ff0000004181cULL,
0x0000003c341c723cULL, 0x048ff000000418ffULL, 0x000000183424723cULL, 0x050ff000000418ffULL,
0x0000003e343c723cULL, 0x040ff000000418ffULL, 0x0000001a3418723cULL, 0x040ff000000418ffULL,
0x00000004342c723cULL, 0x040fee00000418ffULL, 0x0000000447057812ULL, 0x100fe200078e1e40ULL,
0x000000063434723cULL, 0x000fe200000418ffULL, 0x0000000445047812ULL, 0x000fc400078e1e40ULL,
0x0000000647477812ULL, 0x000fc800078e1e40ULL, 0x0000000003077212ULL, 0x000fe200078efcffULL,
0x000000283024723cULL, 0x040fe20000041824ULL, 0x0000000409037810ULL, 0x000fe40007ffe0ffULL,
0x0000000205067212ULL, 0x080fe200078efcffULL, 0x0000001007387824ULL, 0x000fe200078e028cULL,
0x0000000703037812ULL, 0x000fe400078e7808ULL, 0x0000006304057212ULL, 0x000fe200078efcffULL,
0x0000002a3028723cULL, 0x000fe20000041818ULL, 0x0000000247027212ULL, 0x000fe200078efcffULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x0000001008037824ULL, 0x000fc400078e0203ULL,
0x0000001005547824ULL, 0x000fe400078e028cULL, 0x0000001003487824ULL, 0x000fe200078e00ffULL,
0x0000000443037812ULL, 0x000fe200078e1e40ULL, 0x0000001006187824ULL, 0x000fe200078e028cULL,
0x0000000441197812ULL, 0x100fe200078e1e40ULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0x0000006203047212ULL, 0x000fe200078efcffULL, 0x00000020301c723cULL, 0x042fe2000004181cULL,
0x0000000019037212ULL, 0x000fe200078efcffULL, 0x000000004848783bULL, 0x000e620000000200ULL,
0x0000000643437812ULL, 0x000fe200078e1e40ULL, 0x0000001004507824ULL, 0x000fe200078e028cULL,
0x0000000641417812ULL, 0x000fe200078e1e40ULL, 0x00000010034c7824ULL, 0x100fe200078e028cULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x000000223020723cULL, 0x000fe2000004183cULL,
0x0000006243627212ULL, 0x000fe200078efcffULL, 0x0000001002447824ULL, 0x000fe200078e028cULL,
0x000000005050783bULL, 0x000f220000000200ULL, 0x0000000041007212ULL, 0x000fc600078efcffULL,
0x000000004c4c783bULL, 0x000f220000000200ULL, 0x00000006093d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010623c7824ULL, 0x000fc600078e028cULL, 0x000000073d3d7812ULL, 0x000fca00078e7808ULL,
0x00000010083d7824ULL, 0x000fe200078e023dULL, 0x00000038302c723cULL, 0x044fe6000004182cULL,
0x000000103d8d7824ULL, 0x000fe400078e00ffULL, 0x000000003c3c783bULL, 0x000fe40000000200ULL,
0x0000000645387812ULL, 0x000fe200078e1e40ULL, 0x0000003a3030723cULL, 0x000fe20000041834ULL,
0x000000008d34783bULL, 0x000fe40000000200ULL, 0x0000006338637212ULL, 0x000fe200078efcffULL,
0x0000001000387824ULL, 0x100fe200078e028cULL, 0x000000004444783bULL, 0x000ea60000000200ULL,
0x0000001063407824ULL, 0x000fe200078e028cULL, 0x00000054481c723cULL, 0x042fe2000004181cULL,
0x000000003838783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000e660000000200ULL,
0x00000018485c723cULL, 0x048ff0000004185cULL, 0x0000001a4858723cULL, 0x040ff00000041858ULL,
0x000000564820723cULL, 0x040ff00000041820ULL, 0x000000504824723cULL, 0x050ff00000041824ULL,
0x000000524828723cULL, 0x040ff00000041828ULL, 0x0000004c482c723cULL, 0x040fee000004182cULL,
0x00000300174d7a10ULL, 0x000fe20007ffe0ffULL, 0x0000004e4830723cULL, 0x000fe60000041830ULL,
0x000000014d197810ULL, 0x040fe20007ffe0ffULL, 0x000001004d1a7824ULL, 0x000fc600078e0212ULL,
0x000000141900720cULL, 0x000fe20003f06070ULL, 0x00000044345c723cULL, 0x004fe2000004185cULL,
0x000000401a187812ULL, 0x000fce00078ec0ffULL, 0x000000463458723cULL, 0x040ff00000041858ULL,
0x00000040341c723cULL, 0x042ff0000004181cULL, 0x000000423420723cULL, 0x040ff00000041820ULL,
0x0000003c3424723cULL, 0x040ff00000041824ULL, 0x0000003e3428723cULL, 0x040ff00000041828ULL,
0x00000038342c723cULL, 0x040fee000004182cULL, 0x0000000111397824ULL, 0x000fe200078e0218ULL,
0x0000003a3434723cULL, 0x000fee0000041830ULL, 0x0000001013307224ULL, 0x020fe200078e02ffULL,
0x00000a8000008947ULL, 0x000fea0003800000ULL, 0x000000018a197824ULL, 0x100fe200078e0239ULL,
0x0000001a61317217ULL, 0x000fe20007800000ULL, 0x00000001861b7824ULL, 0x000fc400078e0239ULL,
0x000000100f387824ULL, 0x000fe200078e00ffULL, 0x00000019303c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000188197824ULL, 0x100fe200078e0239ULL, 0x0000001b301b7210ULL, 0x000fe20007f9e0ffULL,
0x0000000131317824ULL, 0x000fe200078e0a1aULL, 0x0000007038387812ULL, 0x000fe200078ec0ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x00005e003c417a11ULL, 0x000fe200078040ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000001930327210ULL, 0x000fe20007f7e0ffULL,
0x0000000184197824ULL, 0x000fe200078e0239ULL, 0x00005f003c3c7a11ULL, 0x000fe200000f4433ULL,
0x0000001087877824ULL, 0x100fe200078e028cULL, 0x00005e00323b7a11ULL, 0x000fe200078040ffULL,
0x000000ffff337224ULL, 0x000fe200018e06ffULL, 0x00005e001b3d7a11ULL, 0x000fe200078640ffULL,
0x0000001085857824ULL, 0x100fe200078e028cULL, 0x000000318a00720cULL, 0x000fe20003fa6070ULL,
0x0000001083837824ULL, 0x000fe200078e028cULL, 0x00005f001b3a7a11ULL, 0x000fe200018f443aULL,
0x00000001821b7824ULL, 0x000fe200078e0239ULL, 0x00005f0032327a11ULL, 0x000fe200000f4433ULL,
0x0000001081817824ULL, 0x100fe200078e028cULL, 0x0000001930467210ULL, 0x000fe20007f1e0ffULL,
0x0000000180197824ULL, 0x000fe200078e0239ULL, 0x0000001b301b7210ULL, 0x000fe20007fde0ffULL,
0x000000107f7f7824ULL, 0x100fe200078e028cULL, 0x00005e0046437a11ULL, 0x000fe200078640ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x00005e001b3f7a11ULL, 0x000fe200078040ffULL,
0x000000ffff3e7224ULL, 0x000fe200030e06ffULL, 0x000000318800720cULL, 0x000fe20003f46070ULL,
0x000000107d7d7824ULL, 0x100fe200078e028cULL, 0x00005f0046467a11ULL, 0x000fe200018f4433ULL,
0x000000017e337824ULL, 0x000fe200078e0239ULL, 0x0000004138187210ULL, 0x000fe20007fde0ffULL,
0x000000107b7b7824ULL, 0x000fe200078e028cULL, 0x00005f001b3e7a11ULL, 0x000fe200000f443eULL,
0x0000001079797824ULL, 0x000fe200078e028cULL, 0x0000001930427210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff197224ULL, 0x000fe200030e063cULL, 0x0000003b381a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001077777824ULL, 0x000fe200078e028cULL, 0x00005e0042477a11ULL, 0x000fe200078c40ffULL,
0x000000ffff3b7224ULL, 0x000fe200018e06ffULL, 0x000000318600720cULL, 0x000fe20003f26070ULL,
0x000000ffff1b7224ULL, 0x000fe200000e0632ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018877faeULL, 0x0003e2000e901c46ULL, 0x0000003330447210ULL, 0x000fe20007fbe0ffULL,
0x0000001075757824ULL, 0x000fe200078e028cULL, 0x00005f0042427a11ULL, 0x000fe200030f443bULL,
0x000000001a857faeULL, 0x0005e2000d101c46ULL, 0x0000003d38327210ULL, 0x000fe20007f5e0ffULL,
0x000000017c3b7824ULL, 0x100fe200078e0239ULL, 0x000000318400720cULL, 0x000fe20003f86070ULL,
0x000000ffff3d7224ULL, 0x000fe200028e06ffULL, 0x00005e0044457a11ULL, 0x000fe200078a40ffULL,
0x000000ffff337224ULL, 0x000fe200010e063aULL, 0x0000003b303b7210ULL, 0x000fe20007fde0ffULL,
0x000000017a197824ULL, 0x002fe200078e0239ULL, 0x00005f0044447a11ULL, 0x000fe200028f443dULL,
0x0000001073737824ULL, 0x100fe200078e028cULL, 0x0000000032837faeULL, 0x0003e2000c901c46ULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x00005e003b417a11ULL, 0x000fe200078a40ffULL,
0x0000001071717824ULL, 0x100fe200078e028cULL, 0x0000001930407210ULL, 0x000fe20007f3e0ffULL,
0x0000000178197824ULL, 0x000fe200078e0239ULL, 0x000000318200720cULL, 0x000fe20003f66070ULL,
0x000000106f6f7824ULL, 0x000fe200078e028cULL, 0x00000043383c7210ULL, 0x040fe20007fde0ffULL,
0x000000ffff1b7224ULL, 0x004fe200008e06ffULL, 0x00005f003b437a11ULL, 0x000fe200028f4418ULL,
0x000000106d6d7824ULL, 0x000fe200078e028cULL, 0x0000003f383a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0646ULL, 0x00005e00403f7a11ULL, 0x000fe200078240ffULL,
0x000000106b6b7824ULL, 0x000fe200078e028cULL, 0x000000318000720cULL, 0x000fe20003f06070ULL,
0x000000ffff3b7224ULL, 0x000fe200028e063eULL, 0x00005f0040407a11ULL, 0x000fe200008f441bULL,
0x00000001761b7824ULL, 0x000fe200078e0239ULL, 0x0000004738187210ULL, 0x000fe20007f3e0ffULL,
0x000000003c817faeULL, 0x0005e2000e101c46ULL, 0x00000019303e7210ULL, 0x000fe20007f9e0ffULL,
0x000000106a6a7824ULL, 0x000fe200078e028cULL, 0x000000317e00720cULL, 0x000fe20003f46070ULL,
0x000000003a7f7faeULL, 0x0007e2000d901c46ULL, 0x000000ffff197224ULL, 0x000fe200008e0642ULL,
0x0000001b30427210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff337224ULL, 0x002fe200020e06ffULL,
0x00000045381a7210ULL, 0x000fc40007f7e0ffULL, 0x00005e003e477a11ULL, 0x000fe200078840ffULL,
0x00000000187d7faeULL, 0x0003e2000c101c46ULL, 0x000000ffff3d7224ULL, 0x004fe200008e06ffULL,
0x000000317c00720cULL, 0x000fe20003fc6070ULL, 0x000000ffff1b7224ULL, 0x000fe200018e0644ULL,
0x00005e0042457a11ULL, 0x000fe400078640ffULL, 0x00005f003e3e7a11ULL, 0x000fe400020f4433ULL,
0x0000004138327210ULL, 0x000fe20007f9e0ffULL, 0x0000000170417824ULL, 0x000fe200078e0239ULL,
0x00005f0042427a11ULL, 0x000fe200018f443dULL, 0x00000001743d7824ULL, 0x000fe200078e0239ULL,
0x000000317a00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff337224ULL, 0x000fe200020e0643ULL,
0x0000003f383a7210ULL, 0x008fe20007f9e0ffULL, 0x00000001723f7824ULL, 0x100fe200078e0239ULL,
0x0000003d303d7210ULL, 0x000fe20007f1e0ffULL, 0x000000016e437824ULL, 0x100fe200078e0239ULL,
0x000000001a7b7faeULL, 0x0005e2000d101c46ULL, 0x000000ffff3b7224ULL, 0x000fe200020e0640ULL,
0x0000003f303f7210ULL, 0x000fe20007f7e0ffULL, 0x000000016c397824ULL, 0x000fe200078e0239ULL,
0x0000000032797faeULL, 0x0007e2000f101c46ULL, 0x0000004330437210ULL, 0x000fc40007f5e0ffULL,
0x000000317800720cULL, 0x000fe20003f26070ULL, 0x000000003a777faeULL, 0x0009e2000e901c46ULL,
0x0000004130417210ULL, 0x000fe40007fbe0ffULL, 0x0000004738187210ULL, 0x002fe20007f9e0ffULL,
0x000000ffff1a7224ULL, 0x004fe200000e06ffULL, 0x00000039303c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff407224ULL, 0x000fe200028e06ffULL, 0x00005e003d337a11ULL, 0x048fe200078c40ffULL,
0x000000ffff197224ULL, 0x000fe200020e063eULL, 0x000000317400720cULL, 0x080fe20003f86070ULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x00005f003d307a11ULL, 0x000fe200030f441aULL,
0x000000ffff3a7224ULL, 0x010fe200018e06ffULL, 0x00005e003f397a11ULL, 0x040fe200078c40ffULL,
0x0000000018757faeULL, 0x0003e2000c901c46ULL, 0x000000317600720cULL, 0x000fe20003f66070ULL,
0x000000ffff3b7224ULL, 0x000fe200000e06ffULL, 0x00005f003f3a7a11ULL, 0x000fc400030f443aULL,
0x00000045381a7210ULL, 0x040fe40007fde0ffULL, 0x00005e00413f7a11ULL, 0x000fe400078a40ffULL,
0x00005e00433d7a11ULL, 0x000fe200078440ffULL, 0x000000ffff1b7224ULL, 0x000fe200030e0642ULL,
0x00005f0041407a11ULL, 0x000fe400028f4440ULL, 0x0000003338327210ULL, 0x040fe40007fbe0ffULL,
0x000000001a737faeULL, 0x0005e2000d901c46ULL, 0x0000003938187210ULL, 0x002fc40007f7e0ffULL,
0x000000ffff337224ULL, 0x000fe200028e0630ULL, 0x000000317200720cULL, 0x080fe40003f26070ULL,
0x000000317000720cULL, 0x080fe20003fc6070ULL, 0x000000ffff197224ULL, 0x000fe200018e063aULL,
0x00005e003c397a11ULL, 0x000fe200078040ffULL, 0x0000000032717faeULL, 0x0005e2000e101c46ULL,
0x000000316e00720cULL, 0x080fe40003fa6070ULL, 0x00005f00433e7a11ULL, 0x000fe400010f443eULL,
0x000000316c00720cULL, 0x000fc40003f66070ULL, 0x0000003f38307210ULL, 0x040fe20007f5e0ffULL,
0x00000000186f7faeULL, 0x0005e2000c901c46ULL, 0x0000003d383a7210ULL, 0x000fe40007f9e0ffULL,
0x00005f003c3c7a11ULL, 0x000fe200000f443bULL, 0x000000ffff317224ULL, 0x000fe200010e0640ULL,
0x0000003938387210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fc600020e063eULL,
0x00000000306d7faeULL, 0x0005e2000f101c46ULL, 0x000000ffff397224ULL, 0x000fc600000e063cULL,
0x000000003a6b7faeULL, 0x0005e8000e901c46ULL, 0x00000000386a7faeULL, 0x0005e2000d901c46ULL,
0x0000095000007947ULL, 0x000fea0003800000ULL, 0x00000001881b7824ULL, 0x100fe400078e0239ULL,
0x000000018a197824ULL, 0x100fe400078e0239ULL, 0x0000000184337824ULL, 0x100fe200078e0239ULL,
0x0000001b301b7210ULL, 0x000fe20007f3e0ffULL, 0x00000001823b7824ULL, 0x100fe200078e0239ULL,
0x0000001930197210ULL, 0x000fe20007f1e0ffULL, 0x0000000186317824ULL, 0x000fc400078e0239ULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078240ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005e0019187a11ULL, 0x000fe200078040ffULL,
0x00000001803d7824ULL, 0x100fe200078e0239ULL, 0x00005f001b1b7a11ULL, 0x000fe200008f4438ULL,
0x000000017c437824ULL, 0x100fe200078e0239ULL, 0x00005f0019197a11ULL, 0x000fe200000f4432ULL,
0x000000017e417824ULL, 0x100fe200078e0239ULL, 0x0000003330337210ULL, 0x000fe20007f3e0ffULL,
0x0000000178477824ULL, 0x100fe200078e0239ULL, 0x0000003b303b7210ULL, 0x000fe20007f5e0ffULL,
0x000000017a457824ULL, 0x100fe200078e0239ULL, 0x0000003130317210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x0000003d303f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff407224ULL, 0x000fe200010e06ffULL, 0x00005e00333e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005e003b427a11ULL, 0x000fe200078440ffULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x00005e0031387a11ULL, 0x000fe200078040ffULL,
0x00000001744f7824ULL, 0x100fe200078e0239ULL, 0x00005e003f3a7a11ULL, 0x000fe200078640ffULL,
0x00000001764b7824ULL, 0x100fe200078e0239ULL, 0x00005f0033337a11ULL, 0x000fe200008f443cULL,
0x0000000172517824ULL, 0x100fe200078e0239ULL, 0x00005f003b3d7a11ULL, 0x000fe200010f4440ULL,
0x0000000170557824ULL, 0x100fe200078e0239ULL, 0x00005f0031317a11ULL, 0x000fe200000f4432ULL,
0x000000016e577824ULL, 0x100fe200078e0239ULL, 0x00005f003f3b7a11ULL, 0x000fe200018f4444ULL,
0x000000016c397824ULL, 0x000fe200078e0239ULL, 0x0000004330437210ULL, 0x040fe20007f3e0ffULL,
0x0000001087877824ULL, 0x100fe200078e028cULL, 0x0000004130417210ULL, 0x040fe20007f1e0ffULL,
0x0000001085857824ULL, 0x100fe200078e028cULL, 0x0000004730497210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x0000004530467210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005e0043447a11ULL, 0x000fe200078240ffULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x00005e00413c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff477224ULL, 0x000fe200010e06ffULL, 0x00005e00494c7a11ULL, 0x000fe200078640ffULL,
0x0000001083837824ULL, 0x100fe200078e028cULL, 0x00005e0046487a11ULL, 0x040fe200078440ffULL,
0x0000001081817824ULL, 0x000fe200078e028cULL, 0x00005f00433f7a11ULL, 0x000fe200008f4440ULL,
0x000000107f7f7824ULL, 0x000fe200078e028cULL, 0x00005f0041457a11ULL, 0x000fe200000f4432ULL,
0x000000107d7d7824ULL, 0x000fe200078e028cULL, 0x00005f0049437a11ULL, 0x000fe200018f444aULL,
0x000000107b7b7824ULL, 0x100fe200078e028cULL, 0x00005f0046417a11ULL, 0x000fe200010f4447ULL,
0x0000001079797824ULL, 0x100fe200078e028cULL, 0x0000004f304f7210ULL, 0x040fe20007f7e0ffULL,
0x0000001077777824ULL, 0x100fe200078e028cULL, 0x0000004b304b7210ULL, 0x040fe20007f5e0ffULL,
0x0000001075757824ULL, 0x100fe200078e028cULL, 0x0000005130517210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff407224ULL, 0x000fe200018e06ffULL, 0x0000003930397210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x0000005530557210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200028e06ffULL, 0x0000005730577210ULL, 0x000fe20007f3e0ffULL,
0x000000100f307824ULL, 0x000fe200078e00ffULL, 0x00005e004b467a11ULL, 0x000fe200078440ffULL,
0x000000ffff547224ULL, 0x000fe200018e06ffULL, 0x00005e004f4a7a11ULL, 0x000fe200078840ffULL,
0x0000001073737824ULL, 0x100fe200078e028cULL, 0x00005e0051507a11ULL, 0x000fe200078a40ffULL,
0x0000001071717824ULL, 0x000fe200078e028cULL, 0x00005f004b4b7a11ULL, 0x000fe200010f4432ULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005f004f4f7a11ULL, 0x000fe200020f4440ULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x00005f0051497a11ULL, 0x000fe200028f444eULL,
0x000000106f6f7824ULL, 0x100fe200078e028cULL, 0x00005e0039567a11ULL, 0x000fe200078440ffULL,
0x000000106d6d7824ULL, 0x100fe200078e028cULL, 0x0000007030517812ULL, 0x000fe200078ec0ffULL,
0x000000106b6b7824ULL, 0x100fe200078e028cULL, 0x00005e0057527a11ULL, 0x000fe200078240ffULL,
0x000000106a537824ULL, 0x000fe200078e028cULL, 0x00005e00554e7a11ULL, 0x000fc400078040ffULL,
0x00005f0039547a11ULL, 0x000fe400010f4454ULL, 0x0000001851187210ULL, 0x000fe40007f5e0ffULL,
0x00005f0057577a11ULL, 0x000fe400008f4440ULL, 0x0000001a511a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x00005f0055557a11ULL, 0x000fe400000f4432ULL,
0x0000003851307210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200030e061bULL,
0x0000003e51327210ULL, 0x040fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018877faeULL, 0x0003e2000b901c46ULL, 0x0000004251387210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff317224ULL, 0x000fe200008e0631ULL, 0x0000003a513a7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff337224ULL, 0x000fe200000e0633ULL, 0x0000003c513c7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff397224ULL, 0x000fe200028e063dULL, 0x00000044513e7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e063bULL, 0x0000004851407210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e0645ULL, 0x0000004c51427210ULL, 0x040fe20007f1e0ffULL,
0x000000001a857faeULL, 0x0003e2000b901c46ULL, 0x0000004651447210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e063fULL, 0x0000004a51467210ULL, 0x040fe20007f9e0ffULL,
0x0000000030837faeULL, 0x0003e2000b901c46ULL, 0x0000005051487210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff417224ULL, 0x000fe200008e0641ULL, 0x0000004e514a7210ULL, 0x040fe20007f5e0ffULL,
0x0000000032817faeULL, 0x0003e2000b901c46ULL, 0x00000052514e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff437224ULL, 0x000fe200000e0643ULL, 0x0000005651507210ULL, 0x000fe20007f1e0ffULL,
0x00000000387f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff457224ULL, 0x000fc400028e064bULL,
0x000000ffff477224ULL, 0x000fe200020e064fULL, 0x000000003a7d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff497224ULL, 0x000fe400018e0649ULL, 0x000000ffff4b7224ULL, 0x000fe200010e0655ULL,
0x000000003c7b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff4f7224ULL, 0x000fe400008e0657ULL,
0x000000ffff517224ULL, 0x000fe200000e0654ULL, 0x000000003e797faeULL, 0x0003e8000b901c46ULL,
0x0000000040777faeULL, 0x0003e8000b901c46ULL, 0x0000000042757faeULL, 0x0003e8000b901c46ULL,
0x0000000044737faeULL, 0x0003e8000b901c46ULL, 0x0000000046717faeULL, 0x0003e8000b901c46ULL,
0x00000000486f7faeULL, 0x0003e8000b901c46ULL, 0x000000004a6d7faeULL, 0x0003e8000b901c46ULL,
0x000000004e6b7faeULL, 0x0003e8000b901c46ULL, 0x0000000050537faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000809197810ULL, 0x006fc40007ffe0ffULL,
0x0000300089897810ULL, 0x000fe40007ffe0ffULL, 0x0000000719197812ULL, 0x100fe400078e7808ULL,
0x0000000a09317810ULL, 0x000fe20007ffe0ffULL, 0x000000108b187824ULL, 0x000fe400078e0289ULL,
0x0000001008197824ULL, 0x000fe200078e0219ULL, 0x0000000731317812ULL, 0x000fe200078e7808ULL,
0x0000001069387824ULL, 0x000fe400078e0289ULL, 0x0000001019447824ULL, 0x000fc400078e00ffULL,
0x0000001068307824ULL, 0x000fe400078e0289ULL, 0x0000001008317824ULL, 0x000fe400078e0231ULL,
0x0000001067487824ULL, 0x000fe400078e0289ULL, 0x00000010313c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001818783bULL, 0x000fe20000000200ULL,
0x0000001066407824ULL, 0x100fe400078e0289ULL, 0x0000001006067824ULL, 0x100fe200078e0289ULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x0000001063547824ULL, 0x100fe400078e0289ULL,
0x0000001002507824ULL, 0x100fe200078e0289ULL, 0x000000003838783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000f280000000200ULL, 0x000000004040783bULL, 0x000fe80000000200ULL,
0x000000005454783bULL, 0x000fe80000000200ULL, 0x000000005050783bULL, 0x000fe20000000200ULL,
0x00000018445c723cULL, 0x042fee000004185cULL, 0x0000001065187824ULL, 0x100fe200078e0289ULL,
0x00000038441c723cULL, 0x044fee000004181cULL, 0x0000001064387824ULL, 0x100fe200078e0289ULL,
0x0000001a4458723cULL, 0x040fe20000041858ULL, 0x000000001818783bULL, 0x000e6e0000000200ULL,
0x0000003a4420723cULL, 0x040fe20000041820ULL, 0x000000003838783bULL, 0x000eae0000000200ULL,
0x000000304424723cULL, 0x048fee0000041824ULL, 0x0000001007307824ULL, 0x000fe200078e0289ULL,
0x000000324428723cULL, 0x000fe20000041828ULL, 0x0000000c09077810ULL, 0x000fc40007ffe0ffULL,
0x0000000e09097810ULL, 0x000fe40007ffe0ffULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x0000000707077812ULL, 0x100fe400078e7808ULL, 0x00000048442c723cULL, 0x010fe2000004182cULL,
0x0000000709097812ULL, 0x000fe400078e7808ULL, 0x0000001008077824ULL, 0x000fc600078e0207ULL,
0x0000001008097824ULL, 0x000fe400078e0209ULL, 0x0000004a4434723cULL, 0x000fe20000041834ULL,
0x0000001000487824ULL, 0x000fe400078e0289ULL, 0x0000001009097824ULL, 0x000fc800078e00ffULL,
0x0000001004447824ULL, 0x100fe200078e0289ULL, 0x000000183c1c723cULL, 0x042fe2000004181cULL,
0x000000004848783bULL, 0x000fe80000000200ULL, 0x000000004444783bULL, 0x000fe40000000200ULL,
0x0000001007187824ULL, 0x000fe200078e00ffULL, 0x000000403c5c723cULL, 0x040fee000004185cULL,
0x0000001005407824ULL, 0x100fe200078e0289ULL, 0x000000383c24723cULL, 0x044fe20000041824ULL,
0x000000000604783bULL, 0x000fec0000000200ULL, 0x0000001003387824ULL, 0x100fe200078e0289ULL,
0x0000001a3c20723cULL, 0x040fe20000041820ULL, 0x000000001818783bULL, 0x000e6e0000000200ULL,
0x000000423c58723cULL, 0x040fe20000041858ULL, 0x000000004040783bULL, 0x000eae0000000200ULL,
0x0000003a3c28723cULL, 0x040fe20000041828ULL, 0x000000003838783bULL, 0x000f2e0000000200ULL,
0x000000303c2c723cULL, 0x048ff0000004182cULL, 0x000000323c34723cULL, 0x000fe20000041834ULL,
0x000000000930783bULL, 0x000eec0000000200ULL, 0x00000010623c7824ULL, 0x000fe200078e0289ULL,
0x00000004185c723cULL, 0x042fea000004185cULL, 0x000000003c3c783bULL, 0x000e660000000200ULL,
0x000000061858723cULL, 0x040ff00000041858ULL, 0x00000040181c723cULL, 0x044ff0000004181cULL,
0x000000441804723cULL, 0x040ff00000041824ULL, 0x000000421820723cULL, 0x040ff00000041820ULL,
0x000000461828723cULL, 0x040ff00000041828ULL, 0x00000038182c723cULL, 0x050ff0000004182cULL,
0x0000003a1834723cULL, 0x000ff00000041834ULL, 0x00000054301c723cULL, 0x048ff0000004181cULL,
0x0000003c3004723cULL, 0x042ff00000041804ULL, 0x00000050305c723cULL, 0x040ff0000004185cULL,
0x000000523058723cULL, 0x040ff00000041858ULL, 0x000000563054723cULL, 0x040ff00000041820ULL,
0x0000003e303c723cULL, 0x040ff00000041828ULL, 0x000000483018723cULL, 0x040ff0000004182cULL,
0x0000004a3030723cULL, 0x000fe20000041834ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff00000008000ULL,
0x000000000d027f8cULL, 0x000fe2000c80043fULL, 0x3db504f31d1d7820ULL, 0x000fc40000410000ULL,
0x3db504f358587820ULL, 0x000fe20000410000ULL, 0x000004000d377984ULL, 0x000e620000000800ULL,
0x3db504f359597820ULL, 0x000fe40000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe40000410000ULL,
0x3db504f31b007820ULL, 0x000fe40000410000ULL, 0x3db504f31a097820ULL, 0x000fe40000410000ULL,
0x3db504f3042d7820ULL, 0x000fc40000410000ULL, 0x3db504f3301a7820ULL, 0x000fe40000410000ULL,
0x3db504f31e277820ULL, 0x000fe40000410000ULL, 0x3db504f31f287820ULL, 0x000fe40000410000ULL,
0x3db504f3311b7820ULL, 0x000fe40000410000ULL, 0x3db504f332047820ULL, 0x000fe40000410000ULL,
0x3db504f333087820ULL, 0x000fc40000410000ULL, 0x000000ffff307224ULL, 0x000fe400078e001dULL,
0x3db504f35c357820ULL, 0x000fe40000410000ULL, 0x3db504f35d347820ULL, 0x000fe40000410000ULL,
0x3db504f35e227820ULL, 0x000fe40000410000ULL, 0x3db504f35f217820ULL, 0x000fe40000410000ULL,
0x3db504f35a257820ULL, 0x000fc40000410000ULL, 0x3db504f35b267820ULL, 0x000fe40000410000ULL,
0x3db504f3542f7820ULL, 0x000fe40000410000ULL, 0x3db504f3552e7820ULL, 0x000fe20000410000ULL,
0x8000000037ff7812ULL, 0x002fe20007804803ULL, 0x3db504f356297820ULL, 0x000fe40000410000ULL,
0x3db504f357237820ULL, 0x000fe40000410000ULL, 0x3db504f3052c7820ULL, 0x000fc40000410000ULL,
0x3db504f306247820ULL, 0x000fe40000410000ULL, 0x3db504f307207820ULL, 0x000fe40000410000ULL,
0x3db504f33c2b7820ULL, 0x000fe40000410000ULL, 0x3db504f33d2a7820ULL, 0x000fe40000410000ULL,
0x3db504f33e1f7820ULL, 0x000fe40000410000ULL, 0x3db504f33f1e7820ULL, 0x000fc40000410000ULL,
0x3db504f318187820ULL, 0x000fe40000410000ULL, 0x3db504f319197820ULL, 0x000fe40000410000ULL,
0x000000ffff337224ULL, 0x000fe400078e0058ULL, 0x000000ffff327224ULL, 0x000fe400078e0059ULL,
0x000000ffff317224ULL, 0x000fe400078e001cULL, 0x000000ffff1d7224ULL, 0x000fe200078e0000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0004ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x000004000d057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000040f007824ULL, 0x000fe200078e00ffULL,
0x0000000c1700720cULL, 0x000fc80003f05270ULL, 0xfffffff000037812ULL, 0x000fca00078ec0ffULL,
0x0000008060027824ULL, 0x000fca00078e0203ULL, 0x01b4000002047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000020f037824ULL, 0x000fe400078e00ffULL,
0x0000000161377824ULL, 0x000fc600078e0a0aULL, 0x0000000603037812ULL, 0x000fc800078ec0ffULL,
0x00000001030a7812ULL, 0x040fe400078efcffULL, 0x0000000803177812ULL, 0x040fe400078efcffULL,
0x000000370a00720cULL, 0x080fe40003f26070ULL, 0x00000010030a7812ULL, 0x000fe400078efcffULL,
0x000000371700720cULL, 0x080fe40003f06070ULL, 0x000000370a00720cULL, 0x000fc40003fc6070ULL,
0x0000001103177812ULL, 0x040fe400078efcffULL, 0x00000018030a7812ULL, 0x040fe400078efcffULL,
0x000000370300720cULL, 0x080fe40003f46070ULL, 0x000000371700720cULL, 0x080fe40003fa6070ULL,
0x000000370a00720cULL, 0x000fe40003f66070ULL, 0x0000000903367812ULL, 0x000fc400078efcffULL,
0x0000001903177812ULL, 0x040fe400078efcffULL, 0x00000020030a7812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff35357808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff34347808ULL, 0x000fc40004800000ULL,
0x000000373600720cULL, 0x080fe40003f86070ULL, 0x000000371700720cULL, 0x080fe40003f46070ULL,
0x000000370a00720cULL, 0x000fe40003f26070ULL, 0x0000002103177812ULL, 0x040fe400078efcffULL,
0x00000028030a7812ULL, 0x000fe400078efcffULL, 0xff7fffff25257808ULL, 0x000fc40004000000ULL,
0xff7fffff33337808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40006000000ULL,
0xff7fffff32327808ULL, 0x000fe40006000000ULL, 0x000000371700720cULL, 0x080fe40003f06070ULL,
0x000000370a00720cULL, 0x000fe40003f86070ULL, 0x0000002903177812ULL, 0x000fc400078efcffULL,
0x00000030030a7812ULL, 0x000fe400078efcffULL, 0xff7fffff27277808ULL, 0x000fe40007000000ULL,
0xff7fffff31317808ULL, 0x000fe40007000000ULL, 0xff7fffff28287808ULL, 0x000fe40006800000ULL,
0xff7fffff30307808ULL, 0x000fe40006800000ULL, 0x000000371700720cULL, 0x000fc40003fc6070ULL,
0x000000370a00720cULL, 0x000fe40003fa6070ULL, 0x0000003103177812ULL, 0x040fe400078efcffULL,
0x00000038030a7812ULL, 0x040fe400078efcffULL, 0x0000003903037812ULL, 0x000fe400078efcffULL,
0xff7fffff29297808ULL, 0x000fe40005800000ULL, 0xff7fffff2f2f7808ULL, 0x000fc40005800000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40005000000ULL,
0xff7fffff24247808ULL, 0x000fe40004800000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL,
0x000000371700720cULL, 0x080fe40003f66070ULL, 0x000000370a00720cULL, 0x000fc40003f46070ULL,
0x000000370300720cULL, 0x000fe40003f26070ULL, 0xff7fffff20207808ULL, 0x000fe40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff2b2b7808ULL, 0x000fe40006000000ULL, 0xff7fffff1e1e7808ULL, 0x000fc40007000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff18187808ULL, 0x000fe40006800000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL,
0xff7fffff19197808ULL, 0x000fe40005800000ULL, 0xff7fffff1c1c7808ULL, 0x000fc40005000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff08087808ULL, 0x000fe40004800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0x0000003504037209ULL, 0x004fe40007810000ULL,
0x00000022050a7209ULL, 0x000fe40007810000ULL, 0x0000003403047209ULL, 0x000fe40007810000ULL,
0x000000210a0a7209ULL, 0x000fc40007810000ULL, 0x0000003304037209ULL, 0x000fe40007810000ULL,
0x000000250a057209ULL, 0x000fe40007810000ULL, 0x0000003203047209ULL, 0x000fe40007810000ULL,
0x00000026050a7209ULL, 0x000fe40007810000ULL, 0x0000003104037209ULL, 0x000fe40007810000ULL,
0x000000270a057209ULL, 0x000fc40007810000ULL, 0x0000003003047209ULL, 0x000fe40007810000ULL,
0x00000028050a7209ULL, 0x000fe40007810000ULL, 0x0000002f04037209ULL, 0x000fe40007810000ULL,
0x000000290a0a7209ULL, 0x000fe40007810000ULL, 0x0000002e03047209ULL, 0x000fe40007810000ULL,
0x000000230a037209ULL, 0x000fc40007810000ULL, 0x0000002d04057209ULL, 0x000fe40007810000ULL,
0x0000002403037209ULL, 0x000fe40007810000ULL, 0x0000002c05047209ULL, 0x000fe40007810000ULL,
0x00000020030a7209ULL, 0x000fe40007810000ULL, 0x0000002b04037209ULL, 0x000fe40007810000ULL,
0x0000001f0a057209ULL, 0x000fc40007810000ULL, 0x0000002a03037209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x00000018030a7209ULL, 0x000fe40007810000ULL,
0x0000000904047209ULL, 0x000fe40007810000ULL, 0x000000190a037209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fc40007810000ULL, 0x0000001a03047209ULL, 0x000fe40007810000ULL,
0x0000001c05057209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fe40007810000ULL,
0x0000000805397209ULL, 0x000fe20007810000ULL, 0x000018327f007947ULL, 0x000fea000b800000ULL,
0x0c401f0004037f89ULL, 0x0004e400000e0000ULL, 0x00000003043a7209ULL, 0x008fe20007810000ULL,
0x000018827f007947ULL, 0x000fea000b800000ULL, 0x0c401f0039037f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007047f89ULL, 0x004ea200000e0000ULL,
0x0000000339177209ULL, 0x00afc40007810000ULL, 0x0000000506367209ULL, 0x010fc60007810000ULL,
0x0c201f0017387f89ULL, 0x000fe200000e0000ULL, 0x0000000407037209ULL, 0x004fc60007810000ULL,
0x0c201f003a057f89ULL, 0x000e6800000e0000ULL, 0x0c201f0036377f89ULL, 0x000ea800000e0000ULL,
0x0c201f00030a7f89ULL, 0x00072200000e0000ULL, 0x000000053a047209ULL, 0x002fe40007810000ULL,
0x0000003817057209ULL, 0x000fc40007810000ULL, 0x0000003736067209ULL, 0x004fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x008fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b053d7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b32327823ULL, 0x000fe20000010807ULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b22227823ULL, 0x000fc4000001083dULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001083dULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001083dULL, 0x3fb8aa3b25257823ULL, 0x000fe2000001083dULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b18187823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1b077823ULL, 0x000fe20000010807ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe4000001083dULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001083dULL,
0x3fb8aa3b27277823ULL, 0x000fc4000001083dULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001083dULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe4000001083dULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe4000001083dULL, 0x3fb8aa3b09097823ULL, 0x100fe4000001083dULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001083dULL, 0x00000025001b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc4000001083dULL, 0x3fb8aa3b08087823ULL, 0x000fca000001083dULL,
0x0000002600267308ULL, 0x000ef00000000800ULL, 0x0000002c00367308ULL, 0x000bf00000000800ULL,
0x0000002d00177308ULL, 0x0023e20000000800ULL, 0x00000004ff2c7e24ULL, 0x020fe2000f8e00ffULL,
0x0000001b261b723eULL, 0x008fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fc400038e0100ULL, 0x3f8000002c2c783eULL, 0x000fe400000010ffULL,
0x0000001800397308ULL, 0x0007e60000000800ULL, 0x000000ffff2d7224ULL, 0x002fca00078e002cULL,
0x00000019003a7308ULL, 0x0003e20000000800ULL, 0x000000353418723eULL, 0x008fce00000010ffULL,
0x0000001a003b7308ULL, 0x0007e20000000800ULL, 0x000000222119723eULL, 0x002fce00000010ffULL,
0x0000002b00377308ULL, 0x0003e20000000800ULL, 0x00000033321a723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b20327823ULL, 0x000fcc000001083dULL, 0x0000002a00387308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b242b7823ULL, 0x002fce000001083dULL, 0x00000007003c7308ULL, 0x000ff00000000800ULL,
0x00000027002a7308ULL, 0x0003f00000000800ULL, 0x0000002800077308ULL, 0x000ee20000000800ULL,
0x0000002c1824723cULL, 0x002fee00000418ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002300287308ULL, 0x000e620000000800ULL, 0x0000002a0721723eULL, 0x008fce00000010ffULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ee20000000800ULL,
0x000000292823723eULL, 0x002fe200000010ffULL, 0x000000ffff287224ULL, 0x000fc400078e002cULL,
0x000000ffff297224ULL, 0x000fc800078e002cULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x000000313020723eULL, 0x008fce00000010ffULL,
0x0000002b002d7308ULL, 0x0007e20000000800ULL, 0x0000002f2e22723eULL, 0x002fce00000010ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000282028723cULL, 0x008fee0000041824ULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000173624723eULL, 0x000fe400000010ffULL,
0x000000373826723eULL, 0x000fca00000010ffULL, 0x0000001e001e7308ULL, 0x000ee20000000800ULL,
0x0000002d3225723eULL, 0x002fe200000010ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e002cULL,
0xfffffffc0f177812ULL, 0x000fca00078ec0ffULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x0000001f1e27723eULL, 0x008fe200000010ffULL, 0x0000000fff1e7424ULL, 0x000fcc00078e00ffULL,
0x0000001d002e7308ULL, 0x000e620000000800ULL, 0x000000171e177219ULL, 0x000fe200000006ffULL,
0x0000002c2430723cULL, 0x000fec0000041828ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x00000000171e73a1ULL, 0x000ee200000e8000ULL, 0x00000000170473c4ULL, 0x000f620000004000ULL,
0x000000393a28723eULL, 0x000fc400000010ffULL, 0x0000003b3c2a723eULL, 0x000fc600000010ffULL,
0x0000000800077308ULL, 0x000f220000000800ULL, 0x000000092e29723eULL, 0x002fe400000010ffULL,
0x0000001c072b723eULL, 0x010fe400000010ffULL, 0x0000000517ff7c12ULL, 0x008fe4000f80401eULL,
0x000000030a077209ULL, 0x004fc60007810000ULL, 0x0000002c2830723cULL, 0x000ff00000041830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000144204008947ULL, 0x020fde000b800000ULL,
0x001c1fff302c7589ULL, 0x0002a400000e0000ULL, 0x00000000170873a1ULL, 0x000ee200000e8000ULL,
0x00000000170473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x0000000517ff7c12ULL, 0x008fda000f804008ULL, 0x0000146204008947ULL, 0x010fea000b800000ULL,
0x001c1fff322d7589ULL, 0x00072800000e0000ULL, 0x001c1fff2e2e7589ULL, 0x00066800000e0000ULL,
0x001c1fff002f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff037819ULL, 0x000fe4000001160fULL,
0x0000000c003d7812ULL, 0x000fc400078ec0ffULL, 0x0000000703087812ULL, 0x040fe200078ec0ffULL,
0x00000008031d7824ULL, 0x040fe200078e00ffULL, 0x00000003ff177212ULL, 0x00afe200078e33ffULL,
0x0000000803097824ULL, 0x000fe200078e00ffULL, 0x000000030fff7812ULL, 0x000fe2000780c0ffULL,
0x0000000803387824ULL, 0x040fe200078e00ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81d0a7812ULL, 0x100fe400078ee208ULL, 0x00000001091c7812ULL, 0x100fe200078ef608ULL,
0x0000000803487824ULL, 0x000fe200078e00ffULL, 0x00000002091e7812ULL, 0x100fe200078ef608ULL,
0x00000008031d7824ULL, 0x000fe200078e00ffULL, 0x0000000309307812ULL, 0x000fc400078ef608ULL,
0x0000000409327812ULL, 0x140fe400078ef608ULL, 0x0000000509347812ULL, 0x140fe400078ef608ULL,
0x0000000609367812ULL, 0x000fe200078ef608ULL, 0x0000000803097824ULL, 0x040fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe400078ee217ULL, 0x00000003ff177212ULL, 0x000fe400078e33ffULL,
0x0000000703087812ULL, 0x000fc400078ec0ffULL, 0x0001100060037811ULL, 0x000fe400078e58ffULL,
0xfffffff81d3a7812ULL, 0x100fe400078ee208ULL, 0x00000001093c7812ULL, 0x140fe200078ef608ULL,
0x000000100a007824ULL, 0x000fe200078e0203ULL, 0xfffffff848487812ULL, 0x000fe200078ee217ULL,
0x000000101e0a7824ULL, 0x100fe200078e0203ULL, 0x00000002093e7812ULL, 0x140fe200078ef608ULL,
0x00000010321e7824ULL, 0x100fe200078e0203ULL, 0x0000000309407812ULL, 0x140fe200078ef608ULL,
0x0000001036327824ULL, 0x100fe200078e0203ULL, 0x0000000409427812ULL, 0x140fe200078ef608ULL,
0x000000103c367824ULL, 0x100fe200078e0203ULL, 0x0000000509447812ULL, 0x140fe200078ef608ULL,
0x000000103e377824ULL, 0x100fe200078e0203ULL, 0x0000000609467812ULL, 0x000fe200078ef608ULL,
0x000000101c087824ULL, 0x000fc400078e0203ULL, 0x00000010301c7824ULL, 0x100fe400078e0203ULL,
0x0000001034307824ULL, 0x100fe400078e0203ULL, 0x000000013d097824ULL, 0x000fe400078e0200ULL,
0x0000001038347824ULL, 0x100fe400078e0203ULL, 0x000000103a007824ULL, 0x100fe200078e0203ULL,
0x0000001809007388ULL, 0x0003e20000000800ULL, 0x0000001040387824ULL, 0x000fc400078e0203ULL,
0x0000001042397824ULL, 0x100fe400078e0203ULL, 0x00000010443a7824ULL, 0x100fe400078e0203ULL,
0x00000010463b7824ULL, 0x100fe400078e0203ULL, 0x00000010483c7824ULL, 0x000fe400078e0203ULL,
0x000000013d037824ULL, 0x040fe400078e0208ULL, 0x000000013d177824ULL, 0x000fc400078e020aULL,
0x000000013d1d7824ULL, 0x040fe200078e021cULL, 0x0000001a03007388ULL, 0x0007e20000000800ULL,
0x000000013d1f7824ULL, 0x040fe400078e021eULL, 0x000000013d317824ULL, 0x040fe200078e0230ULL,
0x0000002017007388ULL, 0x0007e20000000800ULL, 0x000000013d337824ULL, 0x040fe400078e0232ULL,
0x000000013d357824ULL, 0x040fe200078e0234ULL, 0x000000221d007388ULL, 0x0007e20000000800ULL,
0x000000013d007824ULL, 0x000fc400078e0200ULL, 0x000000013d367824ULL, 0x040fe200078e0236ULL,
0x000000241f007388ULL, 0x0007e20000000800ULL, 0x000000013d087824ULL, 0x040fe400078e0237ULL,
0x000000013d387824ULL, 0x040fe200078e0238ULL, 0x0000002631007388ULL, 0x0007e20000000800ULL,
0x000000013d0a7824ULL, 0x040fe400078e0239ULL, 0x000000013d3a7824ULL, 0x040fe200078e023aULL,
0x0000002833007388ULL, 0x0007e20000000800ULL, 0x000000013d187824ULL, 0x002fc400078e023bULL,
0x000000013d3c7824ULL, 0x000fe200078e023cULL, 0x0000002a35007388ULL, 0x0007e80000000800ULL,
0x0000001900007388ULL, 0x0007e80000000800ULL, 0x0000001b36007388ULL, 0x0007e80000000800ULL,
0x0000002108007388ULL, 0x0007e80000000800ULL, 0x0000002338007388ULL, 0x0007e80000000800ULL,
0x000000250a007388ULL, 0x0007e80000000800ULL, 0x000000273a007388ULL, 0x0007e80000000800ULL,
0x0000002918007388ULL, 0x0007e80000000800ULL, 0x0000002b3c007388ULL, 0x0007e80000000800ULL,
0x01b0000402008388ULL, 0x0007e80000000c00ULL, 0x01b2002c02008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b608000bff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b610000bff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b618000bff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000144d00720cULL, 0x000fe20003f06070ULL,
0x01b620000bff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff177224ULL, 0x008fd600078e004dULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa9a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x000133b0001d7802ULL, 0x000fe40000000f00ULL,
0x0000104000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e001cULL,
0xfffef4c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004800000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00013410001d7802ULL, 0x000fe40000000f00ULL,
0x00000fe000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e001cULL,
0xfffef4f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1f7224ULL, 0x000fe200078e000bULL,
0x00013480001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x00000f3000007944ULL, 0x02efea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e002fULL, 0xfffef54000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1f7224ULL, 0x000fe200078e000bULL, 0x000134f0001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x00000ec000007944ULL, 0x02cfea0003c00000ULL, 0xfffef51000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1f7224ULL, 0x000fe200078e000dULL, 0x00013550001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x00000e6000007944ULL, 0x028fea0003c00000ULL, 0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff6d7224ULL, 0x004fe200078e002fULL, 0x000135c0001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x002fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fc400078e000bULL, 0x00000df000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6e7224ULL, 0x004fe200078e002fULL, 0xfffef73000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013620001d7802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xffff0e4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013680001d7802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xffff0e7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x002fe200078e0002ULL, 0x000136f0001c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x00000cc000007944ULL, 0x008fea0003c00000ULL, 0xffff0ee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x002fe200078e0002ULL, 0x00013760001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000bULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000c5000007944ULL, 0x008fea0003c00000ULL,
0xffff0f9000007947ULL, 0x000fea000383ffffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x000137b0001c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x00000c0000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff797224ULL, 0x004fe200078e002fULL,
0x00013810001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x002fc400078e000bULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x00000ba000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff7a7224ULL, 0x004fe200078e002fULL,
0xffff10d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00013870001d7802ULL, 0x000fe40000000f00ULL,
0x00000b8000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xffff264000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004800000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x000138d0001d7802ULL, 0x000fe40000000f00ULL,
0x00000b2000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xffff267000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x002fe200078e0020ULL,
0x00013940001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x00000a7000007944ULL, 0x028fea0003c00000ULL,
0xffff26e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1e7224ULL, 0x002fe200078e0020ULL,
0x000139b0001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fe400078e000bULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x00000a0000007944ULL, 0x028fea0003c00000ULL, 0xffff279000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x000fe200078e00ffULL, 0x00013a00001c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x000009b000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff757224ULL, 0x004fe200078e002fULL, 0x00013a60001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x002fc400078e000bULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x0000095000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff787224ULL, 0x004fe200078e002fULL, 0xffff28d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013ac0001d7802ULL, 0x000fe40000000f00ULL, 0x0000093000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e001cULL, 0xffff3d5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x00013b20001d7802ULL, 0x000fe40000000f00ULL, 0x000008d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e001cULL, 0xffff3d8000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x002fe200078e00ffULL, 0x00013b80001c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff317424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x008fea0003c00000ULL,
0xffff3e0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1f7224ULL, 0x002fe200078e000bULL,
0x00013be0001c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x000007d000007944ULL, 0x008fea0003c00000ULL,
0xffff3ec000007947ULL, 0x000fea000383ffffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x00013c30001c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000078000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e002fULL,
0x00013c90001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000bULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x0000072000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e002fULL,
0xffff400000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0004ULL,
0x00013d1000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000066000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000aULL,
0xffffe76000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0039ULL,
0x00013d9000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000005e000007944ULL, 0x004fea0003c00000ULL, 0x0000000a39057209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0006ULL, 0x00013e0000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff177424ULL, 0x002fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000057000007944ULL, 0x000fea0003c00000ULL,
0x0000000a06397209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0007ULL,
0x00013e7000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff177424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x0000000a07037209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e003aULL, 0x00013ee000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x002fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000000a3a047209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0005ULL,
0x00013f5000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000000a05057209ULL, 0x004fe20007810000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0039ULL, 0x00013fc000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff177424ULL, 0x002fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000000a39067209ULL, 0x004fe20007810000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0003ULL,
0x0001403000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff177424ULL, 0x002fe400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe54000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x000fe200078e0030ULL, 0x000140a0001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fe400078e0017ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e002fULL, 0xffffeb5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1e7224ULL, 0x002fe200078e0032ULL, 0x00014120001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fe400078e0017ULL, 0x0000029000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x002fe200078e00ffULL, 0x00014180001c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff307424ULL, 0x000fc400078e00ffULL, 0x000000ffff317224ULL, 0x000fe400078e0017ULL,
0x000000ffff2d7224ULL, 0x004fe400078e002fULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff317224ULL, 0x002fe200078e0017ULL, 0x000141e0001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff2e7224ULL, 0x004fe400078e002fULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0xffffeaa000007947ULL, 0x000fea000383ffffULL, 0x0180000008057810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000005097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000800058308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff2a7807ULL, 0x000fe40000800000ULL,
0x00000001ff057807ULL, 0x004fc80004000000ULL, 0x000000052aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff08ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000008087812ULL, 0x002fe400078ec0ffULL, 0x00000001ff057807ULL, 0x000fc80000000000ULL,
0x000000052aff7212ULL, 0x000fda000780c0ffULL, 0x0080000008050812ULL, 0x000fe200078efcffULL,
0x000000ffff058224ULL, 0x000fe200078e0008ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000800057308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x006fe400078e0023ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffebc9008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff377424ULL, 0x000fe200078e00ffULL,
0x0000003b00007348ULL, 0x000fe80003800000ULL, 0x0c0000170a0a7389ULL, 0x0002a200000e0038ULL,
0xfffebc5036007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000003100007348ULL, 0x000fe80003800000ULL, 0x0000001f1e2f7389ULL, 0x0002a200000e0030ULL,
0xfffebc101c007950ULL, 0x000fea0003c3ffffULL, 0x000000011000780cULL, 0x000fe20003f25070ULL,
0x0000001100007348ULL, 0x000fd80003800000ULL, 0x0000000000107806ULL, 0x000fc800048e0100ULL,
0x00000011101c7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fe400078e001dULL,
0x00000000ff117424ULL, 0x000fc800078e00ffULL, 0xfffebba010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000003c0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009a0ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a30ULL, 0x00000000000005e4ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001014ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001038ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001048ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001068ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000010f8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001100ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001110ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001300ULL, 0x0000000000014500ULL, 0x9000001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015800ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000015810ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015810ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015c90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000010f8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014708ULL, 0x0000000000014708ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015c90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 89456;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
