/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000011e10ULL, 0x0000000000011990ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000010790ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000010900ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000010940ULL, 0x0000000000000140ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000010a80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001079000000000ULL, 0x0000040400000000ULL, 0x810c0000007c0400ULL, 0x0041580400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080ae0828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080ae92ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001079000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0xad08288080970828ULL, 0x288080ae08288080ULL, 0x80b608288080b008ULL,
0x16288080ac082880ULL, 0x0000031028808280ULL, 0xac92000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001090000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0xad08288080ac0828ULL,
0x288080ae08288080ULL, 0x80b008288080b608ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080b09200ULL, 0x0000001cffffffffULL, 0x0000017000000000ULL, 0x0001094000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000a2ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000f86000183104ULL, 0x0000fb700000fb60ULL, 0x0000fc000000fbf0ULL,
0x00f829040000fc10ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002105000021ULL,
0x0500002105000021ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000c000f82804ULL, 0x00001530000000f0ULL, 0x00002650000025a0ULL, 0x00002700000026d0ULL,
0x00002b9000002b50ULL, 0x00003de000002f90ULL, 0x00003ee000003e80ULL, 0x000042d000003f20ULL,
0x000045d000004300ULL, 0x00005590000054d0ULL, 0x00005610000055e0ULL, 0x00005a00000059e0ULL,
0x00006af000005cd0ULL, 0x00006c0000006b90ULL, 0x00006f6000006c30ULL, 0x000073b000006f70ULL,
0x0000a030000073c0ULL, 0x0000a5300000a050ULL, 0x0000f4500000a560ULL, 0x0000f4900000f480ULL,
0x0000f4c00000f4a0ULL, 0x0000f5000000f4e0ULL, 0x0000fbe00000f510ULL, 0x0000fc500000fc40ULL,
0x000102900000fc60ULL, 0x0001036000010300ULL, 0x00010410000103c0ULL, 0x000104b000010460ULL,
0x0001055000010500ULL, 0x00010620000105a0ULL, 0x00010700000106a0ULL, 0x0170390400010760ULL,
0x000000ff00000170ULL, 0x003f010000013600ULL, 0x0000000b000001b0ULL, 0x003f013000013608ULL,
0x0000000b000001d0ULL, 0x003f013000013610ULL, 0x000000ff000003f0ULL, 0x003f010700013600ULL,
0x00000000000005f0ULL, 0x003f010200013614ULL, 0x00000000000006c0ULL, 0x003f010100013610ULL,
0x0000000d00002310ULL, 0x003f01060001360cULL, 0x0000000d00002410ULL, 0x003f01060001360cULL,
0x0000001000002f20ULL, 0x003f010100000000ULL, 0x0000000d00003c80ULL, 0x003f01060001361cULL,
0x0000000d00003d30ULL, 0x003f01060001361cULL, 0x0000001000004560ULL, 0x003f010100000000ULL,
0x0000000d00005290ULL, 0x003f01060001362cULL, 0x0000000d00005420ULL, 0x003f01060001362cULL,
0x0000001000005c60ULL, 0x003f010100000000ULL, 0x0000000d000069b0ULL, 0x003f01060001363cULL,
0x0000000d00006a60ULL, 0x003f01060001363cULL, 0x0000000d000071a0ULL, 0x003f010100013640ULL,
0x000000ff0000c0b0ULL, 0x003f010600013604ULL, 0x000000ff0000c140ULL, 0x003f010600013604ULL,
0x000000030000e910ULL, 0x003f010600013614ULL, 0x000000030000ed30ULL, 0x003f010600013614ULL,
0x00000003000101e0ULL, 0x003f010100013608ULL, 0x00141c0400033803ULL, 0x0000b3a00000af60ULL,
0x0000c2400000c190ULL, 0x0000040100010240ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001e4ULL,
0x0000001100000002ULL, 0x000000000000015cULL, 0x0000001100000002ULL, 0x00000000000000ccULL,
0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001c1ULL,
0x0000001100000002ULL, 0x0000000000000136ULL, 0x0000001100000002ULL, 0x00000000000000a8ULL,
0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff137424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e620000002200ULL, 0x0000580000047ab9ULL, 0x000fc60000000800ULL,
0x0000000000677919ULL, 0x000ea80000002100ULL, 0x0000000000627919ULL, 0x000ee80000002700ULL,
0x00000000000d7919ULL, 0x000f220000002600ULL, 0x0000000106007824ULL, 0x002fc800078e0203ULL,
0x00000080000b7824ULL, 0x104fe200078e0267ULL, 0x00000005ff677819ULL, 0x000fe20000011667ULL,
0x00001fff06007589ULL, 0x00066600000e0000ULL, 0x000000ff0b00720cULL, 0x040fe40003f05270ULL,
0x000000030b00780cULL, 0x040fe20003f24070ULL, 0x00001fff67677589ULL, 0x000ea200000e0000ULL,
0x0000007f0b00780cULL, 0x000fe20003f44070ULL, 0x0000620062067625ULL, 0x008fd000078e0013ULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe200078e00ffULL,
0x3fffff8000089802ULL, 0x000fe20000000f00ULL, 0x3fffffe0ff049424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff059424ULL, 0x000fe200078e00ffULL, 0x01360002ff008388ULL, 0x0007e20000000a00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0xff317217ff0aa424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff099424ULL, 0x000fe200078e00ffULL, 0x013608040b009388ULL, 0x0007e8000000ca00ULL,
0x0134000a0b00a388ULL, 0x0007e80000004800ULL, 0x013610080b009388ULL, 0x0007e8000000ca00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x014e620000000000ULL, 0x0000000467027824ULL, 0x008fe200078e00ffULL,
0x0000000404057899ULL, 0x000fe2000800063fULL, 0x000000100d037824ULL, 0x000fc400078e00ffULL,
0x00000100ff0e7424ULL, 0x000fc600078e00ffULL, 0x0000000562037c24ULL, 0x000fe2000f8e0203ULL,
0x000000020f087211ULL, 0x042fe200078fe0ffULL, 0x000000100f047824ULL, 0x000fc600078e00ffULL,
0x00000002080a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103027824ULL, 0x040fe200078e0208ULL,
0x0000000708057812ULL, 0x000fe400078ec0ffULL, 0x000000070a0c7812ULL, 0x000fe200078ec0ffULL,
0x00000001030b7824ULL, 0x000fe200078e020aULL, 0x000000f004117812ULL, 0x000fe200078ec0ffULL,
0x00005c0002027625ULL, 0x000fe200078e000eULL, 0x0000000f05097812ULL, 0x000fc600078e780fULL,
0x00005c000b047625ULL, 0x000fe200078e000eULL, 0x0000000f0c0b7812ULL, 0x000fe400078e780fULL,
0x0000001102027210ULL, 0x000fe40007f1e0ffULL, 0x0000000908097211ULL, 0x000fe200078e20ffULL,
0x000000100a0b7824ULL, 0x000fe200078e020bULL, 0x0000001104047210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff037224ULL, 0x000fe400000e0603ULL, 0x0000001009097824ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c46ULL,
0x00000000040b7faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000606687981ULL, 0x014ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000f220000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000005ff697e24ULL, 0x010fe2000f8e00ffULL,
0x0000007f68667810ULL, 0x004fc40007ffe0ffULL, 0x000000ff68647810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff667819ULL, 0x000fe40000011666ULL, 0x00000008ff647819ULL, 0x000fca0000011664ULL,
0x0000aec000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe20000011667ULL,
0xffffffffff027424ULL, 0x00afc600078e00ffULL, 0x01ffffff00007812ULL, 0x000fca00078ec0ffULL,
0x0000000269037824ULL, 0x000fca00078e0200ULL, 0x000000660300720cULL, 0x000fda0003f06070ULL,
0x0000640000058a02ULL, 0x000fe20000000f00ULL, 0x0000000262008824ULL, 0x000fc800078e00ffULL,
0x0000640000048624ULL, 0x000fe400078e0205ULL, 0x0000001067007824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x000fe400078e00ffULL, 0x0000000103048824ULL, 0x000fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136140500ff738cULL, 0x0003e20000000000ULL,
0x0000600004088625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000169057810ULL, 0x002fe20007ffe0ffULL, 0x0000000608028981ULL, 0x000362000c1e1900ULL,
0x00000001ff047819ULL, 0x000fe20000011667ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x000000640500720cULL, 0x000fe20003f06070ULL, 0x000000800d057824ULL, 0x000fe200078e00ffULL,
0x0136100000ff7f8cULL, 0x0003e2000c80043fULL, 0x0000002004067824ULL, 0x000fe200078e00ffULL,
0x00000001670f7812ULL, 0x000fc600078ec0ffULL, 0x00000100690d7824ULL, 0x000fca00078e0206ULL,
0x00000060050b7812ULL, 0x000fe200078ef80dULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x0000000d68087217ULL, 0x000fe20007800000ULL,
0x00000004020c7c24ULL, 0x020fe2000f8e020bULL, 0x0000000f04107211ULL, 0x000fe200078e08ffULL,
0x00000100ff297424ULL, 0x000fe400078e00ffULL, 0x0000000108087824ULL, 0x000fe400078e0a0dULL,
0x000000080f127824ULL, 0x000fc600078e00ffULL, 0x00000020080a7817ULL, 0x000fe40003800000ULL,
0x00000003ff0b7819ULL, 0x002fe40000011607ULL, 0x0ffffff8070e7812ULL, 0x000fe400078ec0ffULL,
0x0000007f0b097812ULL, 0x040fe400078ec0ffULL, 0x000000070b0d7212ULL, 0x040fe400078e3cffULL,
0x0000000a0b00720cULL, 0x000fe20003f06070ULL, 0x000000010c097824ULL, 0x000fe200078e0209ULL,
0x000000070e0d7812ULL, 0x000fc400078ef80dULL, 0x0000b000100e7811ULL, 0x000fe200078e68ffULL,
0x00005e0009087625ULL, 0x000fe200078e0029ULL, 0xfffffff812197812ULL, 0x000fe400078ee207ULL,
0x000000080b117810ULL, 0x000fe20007ffe0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e020eULL,
0x000000040b107810ULL, 0x000fe20007ffe0ffULL, 0x0000001019087825ULL, 0x000fe200078e0008ULL,
0x000000100b147810ULL, 0x040fe40007ffe0ffULL, 0x0000000c0b127810ULL, 0x000fe20007ffe0ffULL,
0x00000008111c7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000140b167810ULL, 0x000fc40007ffe0ffULL,
0x000000180b187810ULL, 0x040fe20007ffe0ffULL, 0x0000000812157824ULL, 0x000fe200078e00ffULL,
0x0000001c0b1a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008100b7824ULL, 0x000fe200078e00ffULL,
0x0000000718137212ULL, 0x0c0fe200078e3cffULL, 0x00000008181e7824ULL, 0x000fe200078e00ffULL,
0x0000000a1000720cULL, 0x080fe20003f06070ULL, 0x000000081a277824ULL, 0x000fe200078e00ffULL,
0x0000000a1100720cULL, 0x040fe40003f26070ULL, 0x0000000711097212ULL, 0x002fc400078e3cffULL,
0x0000000710087212ULL, 0x080fe400078e3cffULL, 0xfffffff81c0d7812ULL, 0x000fe200078ee209ULL,
0x00000008141c7824ULL, 0x040fe200078e00ffULL, 0x0000000714097212ULL, 0x080fe400078e3cffULL,
0xfffffff80b0b7812ULL, 0x000fe400078ee208ULL, 0x0000000712087212ULL, 0x040fe400078e3cffULL,
0x0000000a1200720cULL, 0x000fc40003f46070ULL, 0x0000000a1400720cULL, 0x080fe40003f66070ULL,
0x0000000a1600720cULL, 0x080fe40003f86070ULL, 0x0000000a1800720cULL, 0x080fe40003fa6070ULL,
0x0000000a1a00720cULL, 0x000fe40003fc6070ULL, 0xfffffff81c217812ULL, 0x000fe400078ee209ULL,
0x00000007160a7212ULL, 0x000fc400078e3cffULL, 0x0000000316237819ULL, 0x000fe200000006ffULL,
0x0000001021217824ULL, 0x000fe200078e020eULL, 0x0000007f10097812ULL, 0x000fe400078ec0ffULL,
0x0000007f11117812ULL, 0x000fe400078ec0ffULL, 0xfffffff815157812ULL, 0x000fe200078ee208ULL,
0x000000010c097824ULL, 0x000fe200078e0209ULL, 0xfffffff81e257812ULL, 0x000fe400078ee213ULL,
0x0000007f12137812ULL, 0x000fc400078ec0ffULL, 0x000000071a087212ULL, 0x000fe200078e3cffULL,
0x0000001025257824ULL, 0x000fe200078e020eULL, 0x0000007f14177812ULL, 0x000fe200078ec0ffULL,
0x000000010c137824ULL, 0x000fe200078e0213ULL, 0x0000007f161b7812ULL, 0x000fe400078ec0ffULL,
0xfffffff823237812ULL, 0x000fe200078ee20aULL, 0x000000010c0a7824ULL, 0x000fe200078e0211ULL,
0x0000007f181d7812ULL, 0x000fe200078ec0ffULL, 0x000000010c107824ULL, 0x000fe200078e0217ULL,
0x0000007f1a1f7812ULL, 0x000fe200078ec0ffULL, 0x000000010c127824ULL, 0x040fe200078e021bULL,
0xfffffff827117812ULL, 0x000fe200078ee208ULL, 0x000000010c147824ULL, 0x040fe200078e021dULL,
0x0000001f0c167210ULL, 0x000fe20007ffe0ffULL, 0x000000100b1b7824ULL, 0x000fc400078e020eULL,
0x00005e0009087625ULL, 0x000fc800078e0029ULL, 0x000000100d1d7824ULL, 0x000fe400078e020eULL,
0x00005e000a0a7625ULL, 0x000fc800078e0029ULL, 0x0000001011277824ULL, 0x000fe400078e020eULL,
0x00005e00130c7625ULL, 0x000fc800078e0029ULL, 0x00005e0010107625ULL, 0x000fc800078e0029ULL,
0x00000010151f7824ULL, 0x000fe400078e020eULL, 0x00005e0012127625ULL, 0x000fc800078e0029ULL,
0x00005e0014147625ULL, 0x000fc800078e0029ULL, 0x00005e0016167625ULL, 0x000fc800078e0029ULL,
0x0000001019087825ULL, 0x000fc800078e0008ULL, 0x00000010190a7825ULL, 0x040fe200078e000aULL,
0x00000000081b7faeULL, 0x0003e6000c101c46ULL, 0x00000010190c7825ULL, 0x040fe200078e000cULL,
0x000000000a1d7faeULL, 0x0003e6000c901c46ULL, 0x0000001019107825ULL, 0x000fe200078e0010ULL,
0x000000000c1f7faeULL, 0x0003e6000d101c46ULL, 0x0000001023237824ULL, 0x000fe200078e020eULL,
0x0000000010217faeULL, 0x0003e2000d901c46ULL, 0x0000001019127825ULL, 0x000fc800078e0012ULL,
0x0000001019147825ULL, 0x040fe200078e0014ULL, 0x0000000012237faeULL, 0x0003e6000e101c46ULL,
0x0000001019167825ULL, 0x000fe200078e0016ULL, 0x0000000014257faeULL, 0x0003e8000e901c46ULL,
0x0000000016277faeULL, 0x0003e2000f101c46ULL, 0x000005a000007947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x000000080f267824ULL, 0x000fc400078e00ffULL,
0x00000004020b7c24ULL, 0x020fe4000f8e020bULL, 0x00000100ff197424ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x002fe40000011607ULL, 0x0ffffff8070a7812ULL, 0x000fe400078ec0ffULL,
0x0000000808127810ULL, 0x040fe40007ffe0ffULL, 0x00000010081a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000708097212ULL, 0x000fc400078e3cffULL, 0x00000004080e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081a137824ULL, 0x000fe200078e00ffULL, 0x0000000c08167810ULL, 0x040fe40007ffe0ffULL,
0x0000001808227810ULL, 0x000fe20007ffe0ffULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x0000000712117212ULL, 0x000fe200078e3cffULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0x0000000312147819ULL, 0x000fe200000006ffULL, 0x0000000822247824ULL, 0x000fe200078e00ffULL,
0x000000070a0c7812ULL, 0x000fc400078ef809ULL, 0x000000071a0a7212ULL, 0x080fe400078e3cffULL,
0xfffffff814147812ULL, 0x000fe400078ee211ULL, 0x00000014081e7810ULL, 0x000fe40007ffe0ffULL,
0x000000070e0d7212ULL, 0x080fe400078e3cffULL, 0x0000000716097212ULL, 0x080fe200078e3cffULL,
0x000000081e207824ULL, 0x000fe200078e00ffULL, 0x0000000722117212ULL, 0x000fc400078e3cffULL,
0xfffffff8261b7812ULL, 0x000fe400078ee207ULL, 0x0000001c08267810ULL, 0x040fe40007ffe0ffULL,
0xfffffff8131c7812ULL, 0x000fe400078ee20aULL, 0x0000007f080a7812ULL, 0x000fe400078ec0ffULL,
0xfffffff810107812ULL, 0x000fe400078ee20dULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x0000000204097824ULL, 0x000fe200078e020fULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x000000010b087824ULL, 0x000fe200078e020aULL, 0x0000007f0e0e7812ULL, 0x000fc400078ec0ffULL,
0x000000071e0d7212ULL, 0x080fe400078e3cffULL, 0x0000007f26287812ULL, 0x040fe200078ec0ffULL,
0x000000010b0a7824ULL, 0x040fe200078e020eULL, 0x0000000726117212ULL, 0x040fe400078e3cffULL,
0x0000000326267819ULL, 0x000fe200000006ffULL, 0x000000010b287824ULL, 0x000fe200078e0228ULL,
0x0000007f12127812ULL, 0x000fe400078ec0ffULL, 0x0000007f16167812ULL, 0x000fc400078ec0ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x000000010b127824ULL, 0x040fe200078e0212ULL,
0x0000007f1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000010b167824ULL, 0x040fe200078e0216ULL,
0x0000007f1e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000007f22227812ULL, 0x000fe200078ec0ffULL,
0x000000010b1a7824ULL, 0x000fe200078e021aULL, 0x0000b000090d7811ULL, 0x000fe200078e68ffULL,
0x00005e0008087625ULL, 0x000fe200078e0019ULL, 0xfffffff8260e7812ULL, 0x000fc400078ee211ULL,
0x0000000d101f7211ULL, 0x000fe200078e20ffULL, 0x000000010b1e7824ULL, 0x040fe400078e021eULL,
0x000000010b227824ULL, 0x000fe400078e0222ULL, 0x000000100c1d7824ULL, 0x100fe400078e020dULL,
0x0000001014217824ULL, 0x100fe400078e020dULL, 0x0000001018237824ULL, 0x100fe400078e020dULL,
0x000000101c257824ULL, 0x000fc400078e020dULL, 0x0000001020277824ULL, 0x100fe400078e020dULL,
0x0000001024297824ULL, 0x100fe400078e020dULL, 0x000000100e2b7824ULL, 0x000fe400078e020dULL,
0x00005e000a0a7625ULL, 0x000fc800078e0019ULL, 0x00005e00120c7625ULL, 0x000fc800078e0019ULL,
0x00005e0016107625ULL, 0x000fc800078e0019ULL, 0x00005e001a127625ULL, 0x000fc800078e0019ULL,
0x00005e001e147625ULL, 0x000fc800078e0019ULL, 0x000000101b087825ULL, 0x000fc800078e0008ULL,
0x00005e0022167625ULL, 0x080fe200078e0019ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000081d7faeULL, 0x0003e6000b901c46ULL, 0x00005e0028187625ULL, 0x000fc800078e0019ULL,
0x000000101b0a7825ULL, 0x000fc800078e000aULL, 0x000000101b0c7825ULL, 0x040fe200078e000cULL,
0x000000000a1f7faeULL, 0x0003e6000b901c46ULL, 0x000000101b107825ULL, 0x040fe200078e0010ULL,
0x000000000c217faeULL, 0x0003e6000b901c46ULL, 0x000000101b127825ULL, 0x040fe200078e0012ULL,
0x0000000010237faeULL, 0x0003e6000b901c46ULL, 0x000000101b147825ULL, 0x040fe200078e0014ULL,
0x0000000012257faeULL, 0x0003e6000b901c46ULL, 0x000000101b167825ULL, 0x040fe200078e0016ULL,
0x0000000014277faeULL, 0x0003e6000b901c46ULL, 0x000000101b187825ULL, 0x000fe200078e0018ULL,
0x0000000016297faeULL, 0x0003e8000b901c46ULL, 0x00000000182b7faeULL, 0x0003e4000b901c46ULL,
0x000000646900720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff087424ULL, 0x002fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00005dc000000947ULL, 0x000fea0003800000ULL, 0x00000001620a7819ULL, 0x000fe200000006ffULL,
0x00006400ff0b7624ULL, 0x000fc400078e00ffULL, 0xff317217ff087424ULL, 0x000fe400078e00ffULL,
0x000064000a0a7624ULL, 0x000fe200078e020bULL, 0x00007610ff0b7816ULL, 0x000fe2000000000bULL,
0x000000ffff7a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fe400078e00ffULL,
0xffffffc0000c7812ULL, 0x000fca00078ec0ffULL, 0x00000100690d7824ULL, 0x000fca00078e020cULL,
0x000000680d00720cULL, 0x000fda0003f06070ULL, 0x00005cb000000947ULL, 0x020fea0003800000ULL,
0x00000001690d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000640d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff797224ULL, 0x000fe200078e0003ULL,
0xffffffe0000c7812ULL, 0x000fca00078ec0ffULL, 0x00000100690c7824ULL, 0x000fca00078e020cULL,
0x000000400c127810ULL, 0x000fe40007ffe0ffULL, 0x0000007a000c7202ULL, 0x000fe40000000f00ULL,
0x0000006005137812ULL, 0x000fe200078ef812ULL, 0x000006b000008947ULL, 0x000fea0003800000ULL,
0x000000080f237824ULL, 0x000fe200078e00ffULL, 0x0000000707107812ULL, 0x000fe200078ec0ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000012680d7217ULL, 0x000fe20007800000ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x0000000823237812ULL, 0x000fe200078ee210ULL,
0x0000200067107824ULL, 0x000fe200078e00ffULL, 0x00000003ff187819ULL, 0x000fe20000011607ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a12ULL, 0x0000010000217802ULL, 0x000fe20000000f00ULL,
0x000010007a127824ULL, 0x000fe200078e00ffULL, 0x0000200010117812ULL, 0x000fe200078ec0ffULL,
0x0000000402027c24ULL, 0x000fe2000f8e0213ULL, 0x00000004181c7810ULL, 0x000fc40007ffe0ffULL,
0x0000100012127812ULL, 0x000fe200078e0cffULL, 0x0000400004117824ULL, 0x000fe200078e0211ULL,
0x00000008181e7810ULL, 0x000fe20007ffe0ffULL, 0x000000081c197824ULL, 0x040fe200078e00ffULL,
0x000000071c107212ULL, 0x080fe400078e3cffULL, 0x0000b00011127810ULL, 0x000fe20007ffe012ULL,
0x000000081e257824ULL, 0x000fe200078e00ffULL, 0x0000007f18117812ULL, 0x000fe400078ec0ffULL,
0x000000071e1a7212ULL, 0x000fc400078e3cffULL, 0x000000200d0d7817ULL, 0x000fe40003800000ULL,
0xfffffff819197812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x000fe200078e0202ULL,
0xfffffff825257812ULL, 0x000fe400078ee21aULL, 0x0000000c18207810ULL, 0x000fe20007ffe0ffULL,
0x00005e0010107625ULL, 0x000fe200078e0021ULL, 0x0000001018227810ULL, 0x040fe40007ffe0ffULL,
0x00000007181a7812ULL, 0x100fe200078e4807ULL, 0x0000000820277824ULL, 0x000fe200078e00ffULL,
0x0000000d1800720cULL, 0x000fe20003f06070ULL, 0x0000000822267824ULL, 0x000fe200078e00ffULL,
0x0ffffff81a137812ULL, 0x000fe200078ef807ULL, 0x0000001023107825ULL, 0x000fe200078e0010ULL,
0x00000007201a7212ULL, 0x000fc400078e3cffULL, 0x00000007221b7212ULL, 0x080fe200078e3cffULL,
0x0000001013137824ULL, 0x000fe200078e0212ULL, 0x0000001418247810ULL, 0x000fe40007ffe0ffULL,
0xfffffff827277812ULL, 0x000fe400078ee21aULL, 0xfffffff826297812ULL, 0x000fe200078ee21bULL,
0x0000000824287824ULL, 0x000fe200078e00ffULL, 0x00000018181a7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000c101c46ULL,
0x0000001c18267810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x100fe200078e0212ULL,
0x00000007241d7212ULL, 0x000fe200078e3cffULL, 0x000000081a2d7824ULL, 0x000fe200078e00ffULL,
0x0000007f262f7812ULL, 0x040fe200078ec0ffULL, 0x00000008264d7824ULL, 0x000fe200078e00ffULL,
0x0000000d1c00720cULL, 0x080fe20003f06070ULL, 0x0000001029297824ULL, 0x000fe200078e0212ULL,
0x0000000d1e00720cULL, 0x000fc40003f26070ULL, 0x0000000d2000720cULL, 0x080fe40003f46070ULL,
0x0000000d2200720cULL, 0x080fe40003f66070ULL, 0x0000000d2400720cULL, 0x080fe40003f86070ULL,
0x0000000d1a00720cULL, 0x080fe40003fa6070ULL, 0x0000000d2600720cULL, 0x000fe40003fc6070ULL,
0x0000007f221b7812ULL, 0x000fc400078ec0ffULL, 0x000000071a187212ULL, 0x080fe400078e3cffULL,
0x0000007f1c0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000726227212ULL, 0x000fe400078e3cffULL,
0x0000007f1e137812ULL, 0x002fe400078ec0ffULL, 0x0000007f20117812ULL, 0x000fe200078ec0ffULL,
0x000000012f207824ULL, 0x100fe200078e0202ULL, 0xfffffff8282b7812ULL, 0x000fe200078ee21dULL,
0x0000000113137824ULL, 0x000fe200078e0202ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee218ULL,
0x0000000111187824ULL, 0x000fe200078e0202ULL, 0x0000007f241d7812ULL, 0x000fe200078ec0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0212ULL, 0x000000020d107210ULL, 0x000fe20007ffe0ffULL,
0x00000010190d7824ULL, 0x000fe200078e0212ULL, 0xfffffff84d2f7812ULL, 0x000fe200078ee222ULL,
0x000000011d1c7824ULL, 0x100fe200078e0202ULL, 0x0000007f1a1f7812ULL, 0x000fe200078ec0ffULL,
0x000000011b1a7824ULL, 0x000fe200078e0202ULL, 0x0000001225257211ULL, 0x000fe200078e20ffULL,
0x000000102d2d7824ULL, 0x000fc400078e0212ULL, 0x000000102f2f7824ULL, 0x000fe400078e0212ULL,
0x00005e0010107625ULL, 0x000fc800078e0021ULL, 0x000000011f1e7824ULL, 0x000fe400078e0202ULL,
0x00005e0013127625ULL, 0x000fc800078e0021ULL, 0x00005e0018187625ULL, 0x000fc800078e0021ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0021ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0021ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0021ULL, 0x00005e0020207625ULL, 0x000fc800078e0021ULL,
0x0000001023107825ULL, 0x000fc800078e0010ULL, 0x0000001023127825ULL, 0x040fe200078e0012ULL,
0x00000000100d7faeULL, 0x0003e6000c101c46ULL, 0x0000001023187825ULL, 0x040fe200078e0018ULL,
0x0000000012257faeULL, 0x0003e6000c901c46ULL, 0x00000010231a7825ULL, 0x040fe200078e001aULL,
0x0000000018277faeULL, 0x0003e6000d101c46ULL, 0x00000010231c7825ULL, 0x040fe200078e001cULL,
0x000000001a297faeULL, 0x0003e6000d901c46ULL, 0x00000010231e7825ULL, 0x040fe200078e001eULL,
0x000000001c2b7faeULL, 0x0003e6000e101c46ULL, 0x0000001023207825ULL, 0x000fe200078e0020ULL,
0x000000001e2d7faeULL, 0x0003e8000e901c46ULL, 0x00000000202f7faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000200067107824ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000010007a127824ULL, 0x000fe200078e00ffULL,
0x00000007070d7812ULL, 0x000fe200078ec0ffULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000200010117812ULL, 0x000fc400078ec0ffULL, 0x000000030f187819ULL, 0x000fe400000006ffULL,
0x00000003ff107819ULL, 0x000fe20000011607ULL, 0x0000400004117824ULL, 0x000fe200078e0211ULL,
0x00000008180d7812ULL, 0x000fe200078ee20dULL, 0x0000000402027c24ULL, 0x000fe2000f8e0213ULL,
0x00000008101c7810ULL, 0x000fe40007ffe0ffULL, 0x0000100012127812ULL, 0x000fe400078e0cffULL,
0x0000000410187810ULL, 0x000fe20007ffe0ffULL, 0x000000081c1b7824ULL, 0x000fe200078e00ffULL,
0x0000b00011137810ULL, 0x000fc40007ffe012ULL, 0x0000000c10207810ULL, 0x000fe20007ffe0ffULL,
0x00000008181a7824ULL, 0x000fe200078e00ffULL, 0x000000071c127212ULL, 0x080fe400078e3cffULL,
0x0000001010227810ULL, 0x000fe20007ffe0ffULL, 0x0000000820247824ULL, 0x000fe200078e00ffULL,
0x0000001410287810ULL, 0x000fe40007ffe0ffULL, 0x0000000718117212ULL, 0x000fe200078e3cffULL,
0x0000000822267824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1e7812ULL, 0x000fe200078ee212ULL,
0x00000008281b7824ULL, 0x000fe200078e00ffULL, 0x00000018102c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000720197212ULL, 0x080fe200078e3cffULL, 0x000000101e297824ULL, 0x000fe200078e0213ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL, 0x000000082c2e7824ULL, 0x000fe200078e00ffULL,
0x0000000722117212ULL, 0x080fe400078e3cffULL, 0x0000000728127212ULL, 0x080fe400078e3cffULL,
0xfffffff824247812ULL, 0x000fe400078ee219ULL, 0x000000072c197212ULL, 0x000fc400078e3cffULL,
0xfffffff826267812ULL, 0x000fe200078ee211ULL, 0x00000010242b7824ULL, 0x000fe200078e0213ULL,
0xfffffff81b2a7812ULL, 0x000fe400078ee212ULL, 0x0000000710127812ULL, 0x000fe200078e4807ULL,
0x00000010262d7824ULL, 0x100fe200078e0213ULL, 0x0000007f10117812ULL, 0x000fe200078ec0ffULL,
0x000000102a2f7824ULL, 0x000fe200078e0213ULL, 0x0000001c10107810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee219ULL, 0x0000000111117824ULL, 0x000fe200078e0202ULL,
0x0000007f18197812ULL, 0x000fc400078ec0ffULL, 0x0000000710187212ULL, 0x040fe400078e3cffULL,
0x0000000310277819ULL, 0x000fe200000006ffULL, 0x0000000119197824ULL, 0x100fe200078e0202ULL,
0x0000007f1c1b7812ULL, 0x000fe400078ec0ffULL, 0x0000007f201d7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff812127812ULL, 0x000fe200078ef807ULL, 0x000000011b1b7824ULL, 0x100fe200078e0202ULL,
0x0000007f221f7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff227424ULL, 0x000fe200078e00ffULL,
0x0000007f10257812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0202ULL,
0xfffffff827187812ULL, 0x000fe200078ee218ULL, 0x000000011f1f7824ULL, 0x000fe200078e0202ULL,
0x0000007f28217812ULL, 0x000fe200078ec0ffULL, 0x000000101a277824ULL, 0x100fe200078e0213ULL,
0x0000007f2c237812ULL, 0x000fe200078ec0ffULL, 0x0000001018517824ULL, 0x100fe200078e0213ULL,
0x00000002254f7210ULL, 0x000fe20007ffe0ffULL, 0x0000001012257824ULL, 0x000fe200078e0213ULL,
0x000000132e4d7211ULL, 0x000fe200078e20ffULL, 0x00005e0011107625ULL, 0x000fc800078e0022ULL,
0x0000000121217824ULL, 0x000fe400078e0202ULL, 0x00005e0019127625ULL, 0x000fc800078e0022ULL,
0x0000000123237824ULL, 0x000fe400078e0202ULL, 0x00005e001b187625ULL, 0x000fc800078e0022ULL,
0x00005e001d1a7625ULL, 0x000fc800078e0022ULL, 0x00005e001f1c7625ULL, 0x000fc800078e0022ULL,
0x00005e00211e7625ULL, 0x000fc800078e0022ULL, 0x00005e0023207625ULL, 0x000fc800078e0022ULL,
0x000000100d107825ULL, 0x000fc800078e0010ULL, 0x00005e004f227625ULL, 0x000fe200078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010257faeULL, 0x0003e6000b901c46ULL,
0x000000100d127825ULL, 0x000fc800078e0012ULL, 0x000000100d187825ULL, 0x040fe200078e0018ULL,
0x0000000012277faeULL, 0x0003e6000b901c46ULL, 0x000000100d1a7825ULL, 0x040fe200078e001aULL,
0x0000000018297faeULL, 0x0003e6000b901c46ULL, 0x000000100d1c7825ULL, 0x040fe200078e001cULL,
0x000000001a2b7faeULL, 0x0003e6000b901c46ULL, 0x000000100d1e7825ULL, 0x040fe200078e001eULL,
0x000000001c2d7faeULL, 0x0003e6000b901c46ULL, 0x000000100d207825ULL, 0x040fe200078e0020ULL,
0x000000001e2f7faeULL, 0x0003e6000b901c46ULL, 0x000000100d227825ULL, 0x000fe200078e0022ULL,
0x00000000204d7faeULL, 0x0003e8000b901c46ULL, 0x0000000022517faeULL, 0x0003e4000b901c46ULL,
0x00000300ff787624ULL, 0x000fe200078e00ffULL, 0x0000000103027812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000010200780cULL, 0x000fe20003f05070ULL,
0x00000004670d7824ULL, 0x002fe200078e00ffULL, 0xffffffff78787811ULL, 0x000fe200078e08ffULL,
0xffffffffff027424ULL, 0x000fc600078e00ffULL, 0x0000000178787807ULL, 0x000fca0004000000ULL,
0x0000000103037824ULL, 0x000fe200078e0278ULL, 0xfffffff00d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000660300720cULL, 0x000fe20003f06070ULL, 0x01360c000d137984ULL, 0x000e580000000800ULL,
0x000000780a108210ULL, 0x000fe20007ffe079ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000600010108625ULL, 0x000fca00078e0011ULL, 0x0000000610028981ULL, 0x000562000c1e1900ULL,
0x0000ffff0b127812ULL, 0x000fc800078ec0ffULL, 0x0000888012577816ULL, 0x000fca00000000ffULL,
0x8000000057127824ULL, 0x000fca00078e00ffULL, 0x8000000013ff7812ULL, 0x002fe20007804812ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x004fea0003800000ULL,
0x3e00000000107802ULL, 0x000fe20000000f00ULL, 0x8000000057127824ULL, 0x000fc600078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01360c000d117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000001007607824ULL, 0x000fe200078e00ffULL,
0x00000001ff5d7819ULL, 0x100fe20000011607ULL, 0x00000020675e7824ULL, 0x040fe200078e00ffULL,
0x00000004ff197819ULL, 0x000fe20000011607ULL, 0x0000000267107824ULL, 0x000fe200078e00ffULL,
0x0000007060607812ULL, 0x000fc400078ec0ffULL, 0xffffff805e5e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c5d5d7812ULL, 0x000fe400078ec0ffULL, 0x0000000410107812ULL, 0x000fe400078ec0ffULL,
0x0000005e5d5f7210ULL, 0x000fe40007ffe060ULL, 0x0000000707567812ULL, 0x000fe200078ec0ffULL,
0x0000000119137824ULL, 0x000fe400078e0210ULL, 0x013000005f117984ULL, 0x000e620000000800ULL,
0x0000000856127812ULL, 0x000fc400078ef807ULL, 0x00000002131b7810ULL, 0x040fe20007ffe0ffULL,
0x013200005f5f7984ULL, 0x000ea20000000800ULL, 0x0000000713137812ULL, 0x100fe400078e7812ULL,
0x000000071b1b7812ULL, 0x000fc600078e7812ULL, 0x00000008125c7824ULL, 0x040fe200078e0213ULL,
0x0000001b121c7211ULL, 0x000fe400078e18ffULL, 0x000000081100720bULL, 0x002fda0003f1d000ULL,
0x0000000000107806ULL, 0x000fc800000e0100ULL, 0x0000ffff101a7812ULL, 0x000fe2000780c0ffULL,
0x00000001ff107424ULL, 0x000fd800078e00ffULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x000000081100720bULL, 0x004fe40003f14000ULL, 0x00000011081d7209ULL, 0x000fe40007810000ULL,
0x00000002ff137819ULL, 0x000fc60000011607ULL, 0x8000001d08107221ULL, 0x000fe20000010000ULL,
0x0000000813187810ULL, 0x000fe40007ffe0ffULL, 0x00000002ff087819ULL, 0x000fe20000011667ULL,
0x3fb8aa3b10127820ULL, 0x000fe40000410000ULL, 0x0000000000107806ULL, 0x000fe400000e0100ULL,
0x000000670800720cULL, 0x000fe40003f05270ULL, 0x0000ffff101b7812ULL, 0x000fe200078e3cffULL,
0x0000001200127308ULL, 0x000e660000000800ULL, 0x0000001b1aff7212ULL, 0x000fc8000782c0ffULL,
0x00000001ff107807ULL, 0x000fc60000800000ULL, 0x0000008067088824ULL, 0x000fc800078e0260ULL,
0x000000015d088824ULL, 0x000fe200078e0208ULL, 0x00001f1812187589ULL, 0x002e6200000e0000ULL,
0x8000001d11111221ULL, 0x000fe20000010000ULL, 0x0000001209097220ULL, 0x000fe40000410000ULL,
0x00001f1312137589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b11111820ULL, 0x000fc60000410000ULL,
0x0134001d08008388ULL, 0x0007e20000000800ULL, 0x00000011000e1308ULL, 0x000f220000000800ULL,
0x000000ffff087224ULL, 0x008fe200078e001dULL, 0x0000001817177220ULL, 0x082fe20000410000ULL,
0x0000001816167220ULL, 0x080fe20000410000ULL, 0x0000001833337220ULL, 0x080fe20000410000ULL,
0x0000001832327220ULL, 0x080fe20000410000ULL, 0x0000001837377220ULL, 0x080fe20000410000ULL,
0x0000001836367220ULL, 0x080fe20000410000ULL, 0x000000183b3b7220ULL, 0x080fe20000410000ULL,
0x000000183a3a7220ULL, 0x080fe20000410000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x000000183e3e7220ULL, 0x080fe20000410000ULL, 0x0000001843437220ULL, 0x080fe20000410000ULL,
0x0000001842427220ULL, 0x080fe20000410000ULL, 0x0000001847477220ULL, 0x080fe20000410000ULL,
0x0000001846467220ULL, 0x080fe20000410000ULL, 0x000000184b4b7220ULL, 0x080fe20000410000ULL,
0x000000184a4a7220ULL, 0x000fe20000410000ULL, 0x0000001315157220ULL, 0x084fe20000410000ULL,
0x0000001314147220ULL, 0x080fe20000410000ULL, 0x0000001331317220ULL, 0x080fe20000410000ULL,
0x0000001330307220ULL, 0x080fe20000410000ULL, 0x0000001335357220ULL, 0x080fe20000410000ULL,
0x0000001334347220ULL, 0x080fe20000410000ULL, 0x0000001339397220ULL, 0x080fe20000410000ULL,
0x0000001338387220ULL, 0x080fe20000410000ULL, 0x000000133d3d7220ULL, 0x080fe20000410000ULL,
0x000000133c3c7220ULL, 0x080fe20000410000ULL, 0x0000001341417220ULL, 0x080fe20000410000ULL,
0x0000001340407220ULL, 0x080fe20000410000ULL, 0x0000001345457220ULL, 0x080fe20000410000ULL,
0x0000001344447220ULL, 0x080fe20000410000ULL, 0x0000001349497220ULL, 0x080fe20000410000ULL,
0x0000001348487220ULL, 0x000fe20000410000ULL, 0x0000000e5f5f1220ULL, 0x010fe20000410000ULL,
0x0000020067127824ULL, 0x004fe200078e00ffULL, 0x0000000807137812ULL, 0x000fe200078ec0ffULL,
0x00002000671e7824ULL, 0x000fe200078e00ffULL, 0x00000002191b7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffff80012557812ULL, 0x000fe200078ec0ffULL,
0x000020000f6d7824ULL, 0x000fe200078e00ffULL, 0x0000000713127812ULL, 0x000fe200078ec856ULL,
0x0000010069777824ULL, 0x000fe200078e00ffULL, 0x00000004191d7810ULL, 0x040fe20007ffe0ffULL,
0x000000105c5c7824ULL, 0x100fe200078e0255ULL, 0x00000006191f7810ULL, 0x000fe20007ffe0ffULL,
0x000000101c557824ULL, 0x000fe200078e0255ULL, 0x00000019126c7212ULL, 0x040fe400078e3cffULL,
0x0000001b12187212ULL, 0x040fe200078e3cffULL, 0x009000005c28783bULL, 0x000fe20000000200ULL,
0x0000001d126a7212ULL, 0x000fc400078e3cffULL, 0x0000001f121a7212ULL, 0x000fe400078e3cffULL,
0xffffc0001e127812ULL, 0x000fe400078ec0ffULL, 0x0000000eff11723eULL, 0x000fe400000010ffULL,
0x000000120f757211ULL, 0x000fe400078e68ffULL, 0x00005410111b7816ULL, 0x000fe40000000011ULL,
0x0000005613137212ULL, 0x000fe200078efcffULL, 0x000010007a117824ULL, 0x000fe200078e0275ULL,
0x00000002ff1c7819ULL, 0x000fc40000011607ULL, 0x0000008013657811ULL, 0x040fe200078e18ffULL,
0x0000000813727824ULL, 0x000fe200078e021aULL, 0x0000b00011117810ULL, 0x000fe20007ffe0ffULL,
0x0000000813747824ULL, 0x040fe200078e0218ULL, 0x000000081c547810ULL, 0x000fe20007ffe0ffULL,
0x0000000813767824ULL, 0x040fe200078e026cULL, 0x00001f1c1b617589ULL, 0x000e6200000e0000ULL,
0x0000000813737824ULL, 0x000fe200078e026aULL, 0x0000001174507211ULL, 0x000fe200078e20ffULL,
0x00000010722c7824ULL, 0x100fe200078e0211ULL, 0x00001f541b627589ULL, 0x000ea200000e0000ULL,
0x0000001076587824ULL, 0x100fe200078e0211ULL, 0x0000991010107816ULL, 0x000fe200000000ffULL,
0x00000010734c7824ULL, 0x000fe200078e0211ULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x0000400004117824ULL, 0x000fe200078e026dULL, 0x000000ff1000720cULL, 0x000fe20003f05270ULL,
0x000000016c6c7824ULL, 0x000fe200078e0265ULL, 0x000000002c2c783bULL, 0x000f220000004200ULL,
0x000010007a197824ULL, 0x000fc400078e0211ULL, 0x00000001186b7824ULL, 0x100fe200078e0265ULL,
0x000000005858783bULL, 0x000f220000004200ULL, 0x000000016a6a7824ULL, 0x000fe200078e0265ULL,
0x0000b00019197810ULL, 0x000fe40007ffe0ffULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x000000651a657210ULL, 0x000fe40007ffe0ffULL, 0x000000106c247824ULL, 0x100fe200078e0219ULL,
0x009000005510783bULL, 0x000f220000000200ULL, 0x000000106b207824ULL, 0x100fe200078e0219ULL,
0x0000006128288231ULL, 0x082fe200003400ffULL, 0x000000106a1c7824ULL, 0x100fe200078e0219ULL,
0x000000612a2a8231ULL, 0x000fe200003400ffULL, 0x0000001065197824ULL, 0x000fe200078e0219ULL,
0x000000002424783bULL, 0x000fe20000004200ULL, 0x0000006229298231ULL, 0x004fc400003400ffULL,
0x000000622b2b8231ULL, 0x000fe200003400ffULL, 0x000000002020783bULL, 0x000fe80000004200ULL,
0x000000001918783bULL, 0x000e680000004200ULL, 0x000000001c1c783bULL, 0x000ea20000004200ULL,
0x000000502840723cULL, 0x048ff00000041840ULL, 0x0000002c2830723cULL, 0x050ff00000041830ULL,
0x000000582848723cULL, 0x000fe20000041848ULL, 0x0000006110108231ULL, 0x000fc400003400ffULL,
0x0000006112128231ULL, 0x000fe400003400ffULL, 0x0000006211118231ULL, 0x080fe400003400ffULL,
0x0000006213138231ULL, 0x000fe200003400ffULL, 0x0000005a2844723cULL, 0x040ff00000041844ULL,
0x00000052283c723cULL, 0x040ff0000004183cULL, 0x0000004c2838723cULL, 0x040ff00000041838ULL,
0x0000004e2834723cULL, 0x040ff00000041834ULL, 0x0000002e2814723cULL, 0x000ff00000041814ULL,
0x000000181030723cULL, 0x042fee0000041830ULL, 0x00000002ff187819ULL, 0x000fe20000011667ULL,
0x000000241048723cULL, 0x040ff00000041848ULL, 0x000000261044723cULL, 0x040ff00000041844ULL,
0x000000201040723cULL, 0x040ff00000041840ULL, 0x00000022103c723cULL, 0x040ff0000004183cULL,
0x0000001c1038723cULL, 0x044ff00000041838ULL, 0x0000001e1034723cULL, 0x040ff00000041834ULL,
0x0000001a1014723cULL, 0x000fee0000041814ULL, 0x0001361018107811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004018117824ULL, 0x000fe200078e0277ULL,
0x0000000010ff7f8cULL, 0x0003e2000c80043fULL, 0x000000095f097221ULL, 0x000fe20000010000ULL,
0x000000017a7a7812ULL, 0x000fc400078e0cffULL, 0x0000004011117810ULL, 0x000fc80007ffe0ffULL,
0x000000681100720cULL, 0x000fda0003f06070ULL, 0x0000425000000947ULL, 0x000fea0003800000ULL,
0x0000000169117810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000641100720cULL, 0x000fe40003f06070ULL, 0xffffffe000107812ULL, 0x000fca00078ec0ffULL,
0x0000010069107824ULL, 0x000fca00078e0210ULL, 0x0000008010127810ULL, 0x000fc80007ffe0ffULL,
0x0000006005137812ULL, 0x000fe200078ef812ULL, 0x000006a000008947ULL, 0x000fea0003800000ULL,
0x0000000d67117819ULL, 0x000fe200000006ffULL, 0x000010000c107824ULL, 0x000fe200078e00ffULL,
0x00000003ff1a7819ULL, 0x000fe20000011607ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000200011197812ULL, 0x000fe200078ec0ffULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x000000081a1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f4d7824ULL, 0x000fe200078e00ffULL,
0x0000100010107812ULL, 0x000fe200078ec0ffULL, 0x0000400004197824ULL, 0x000fe200078e0219ULL,
0x0000001268117217ULL, 0x000fe20007800000ULL, 0x000000081d257824ULL, 0x000fe200078e00ffULL,
0x000000041a1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000402137c24ULL, 0x020fe2000f8e0213ULL,
0x0000b00019187810ULL, 0x000fe20007ffe010ULL, 0x0000000111117824ULL, 0x000fe200078e0a12ULL,
0x000000071d107212ULL, 0x080fe200078e3cffULL, 0x000000081b237824ULL, 0x040fe200078e00ffULL,
0x000000071b1c7212ULL, 0x000fe200078e3cffULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fc400078ee210ULL, 0x0000007f1a107812ULL, 0x000fe400078ec0ffULL,
0x0000002011127817ULL, 0x000fe20003800000ULL, 0x0000001025257824ULL, 0x000fe200078e0218ULL,
0x0000001310107210ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe400078ee21cULL,
0x000000101a1f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0010107625ULL, 0x000fe200078e0021ULL,
0x000000071a1c7812ULL, 0x000fc400078e4807ULL, 0x000000141a227810ULL, 0x040fe20007ffe0ffULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0x000000121a00720cULL, 0x040fe20003f06070ULL,
0x0000001023237824ULL, 0x000fe200078e0218ULL, 0x0000000c1a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008222b7824ULL, 0x000fe200078e00ffULL, 0x000000084d4d7812ULL, 0x000fe400078ee256ULL,
0x0ffffff81c197812ULL, 0x000fe200078ef807ULL, 0x000000081e277824ULL, 0x000fe200078e00ffULL,
0x000000071f207212ULL, 0x080fe200078e3cffULL, 0x000000104d107825ULL, 0x000fe200078e0010ULL,
0x0000000722247212ULL, 0x000fc400078e3cffULL, 0x000000071e1c7212ULL, 0x000fe200078e3cffULL,
0x0000001019197824ULL, 0x000fe200078e0218ULL, 0xfffffff829297812ULL, 0x000fe400078ee220ULL,
0x000000181a207810ULL, 0x040fe40007ffe0ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010197faeULL, 0x0003e2000c101c46ULL,
0x0000001c1a247810ULL, 0x000fe20007ffe0ffULL, 0x00000008202d7824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee21cULL, 0x0000001029297824ULL, 0x100fe200078e0218ULL,
0x000000122200720cULL, 0x040fe20003f86070ULL, 0x000000102b2b7824ULL, 0x000fe200078e0218ULL,
0x0000007f221c7812ULL, 0x000fc400078ec0ffULL, 0x000000122400720cULL, 0x0c0fe40003fc6070ULL,
0x0000007f24227812ULL, 0x000fe200078ec0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e0213ULL,
0x0000000724117212ULL, 0x0c2fe200078e3cffULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0x00000007201a7212ULL, 0x000fe400078e3cffULL, 0x000000121b00720cULL, 0x080fe40003f06070ULL,
0x000000121d00720cULL, 0x000fc40003f26070ULL, 0x000000121e00720cULL, 0x080fe40003f46070ULL,
0x000000121f00720cULL, 0x080fe40003f66070ULL, 0x000000122000720cULL, 0x000fe40003fa6070ULL,
0x0000007f1b107812ULL, 0x000fe400078ec0ffULL, 0x0000007f1d127812ULL, 0x000fe200078ec0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0021ULL, 0xfffffff82d2d7812ULL, 0x000fc400078ee21aULL,
0x0000007f1e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x100fe200078e0213ULL,
0x0000007f1f1a7812ULL, 0x000fe200078ec0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0218ULL,
0x0000007f20207812ULL, 0x000fe200078ec0ffULL, 0x000000011e197824ULL, 0x000fe200078e0213ULL,
0xfffffff824117812ULL, 0x000fe200078ee211ULL, 0x000000011a1a7824ULL, 0x100fe200078e0213ULL,
0x0000001312127210ULL, 0x000fe20007ffe0ffULL, 0x00000001201e7824ULL, 0x000fe200078e0213ULL,
0x0000001827277211ULL, 0x000fe200078e20ffULL, 0x00000010112f7824ULL, 0x000fc400078e0218ULL,
0x0000000122207824ULL, 0x000fe400078e0213ULL, 0x00005e0010107625ULL, 0x000fc800078e0021ULL,
0x00005e0012127625ULL, 0x000fc800078e0021ULL, 0x00005e0019187625ULL, 0x000fc800078e0021ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0021ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0021ULL,
0x00005e0020207625ULL, 0x000fc800078e0021ULL, 0x000000104d107825ULL, 0x000fc800078e0010ULL,
0x000000104d127825ULL, 0x040fe200078e0012ULL, 0x0000000010237faeULL, 0x0003e6000c101c46ULL,
0x000000104d187825ULL, 0x040fe200078e0018ULL, 0x0000000012257faeULL, 0x0003e6000c901c46ULL,
0x000000104d1a7825ULL, 0x040fe200078e001aULL, 0x0000000018277faeULL, 0x0003e6000d101c46ULL,
0x000000104d1c7825ULL, 0x040fe200078e001cULL, 0x000000001a297faeULL, 0x0003e6000d901c46ULL,
0x000000104d1e7825ULL, 0x040fe200078e001eULL, 0x000000001c2b7faeULL, 0x0003e6000e101c46ULL,
0x000000104d207825ULL, 0x000fe200078e0020ULL, 0x000000001e2d7faeULL, 0x0003e8000e901c46ULL,
0x00000000202f7faeULL, 0x0003e2000f101c46ULL, 0x000005e000007947ULL, 0x000fea0003800000ULL,
0x0000200067107824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fe20000011607ULL,
0x000010000c117824ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000010000237802ULL, 0x000fe20000000f00ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x00000008121e7810ULL, 0x040fe20007ffe0ffULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0x0000000c12227810ULL, 0x000fc40007ffe0ffULL, 0x0000200010197812ULL, 0x000fe200078ec0ffULL,
0x000000081e1d7824ULL, 0x040fe200078e00ffULL, 0x000000071e187212ULL, 0x080fe200078e3cffULL,
0x0000000822247824ULL, 0x040fe200078e00ffULL, 0x00000007221b7212ULL, 0x000fe200078e3cffULL,
0x0000400004197824ULL, 0x000fe200078e0219ULL, 0x0000001012267810ULL, 0x000fe20007ffe0ffULL,
0x0000000402137c24ULL, 0x020fe2000f8e0213ULL, 0x00000018122e7810ULL, 0x000fe40007ffe0ffULL,
0x0000100011107812ULL, 0x000fc400078ec0ffULL, 0x00000004121a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81d207812ULL, 0x000fe200078ee218ULL, 0x000000082e1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee21bULL, 0x00000008261b7824ULL, 0x040fe200078e00ffULL,
0x0000b00019197810ULL, 0x000fe40007ffe010ULL, 0x0000000726107212ULL, 0x080fe400078e3cffULL,
0x000000072e187212ULL, 0x080fe200078e3cffULL, 0x00000010202b7824ULL, 0x100fe200078e0219ULL,
0x00000014122a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010242d7824ULL, 0x000fe200078e0219ULL,
0x000000071a117212ULL, 0x000fc400078e3cffULL, 0x000000031a1c7819ULL, 0x000fe200000006ffULL,
0x000000082a2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b287812ULL, 0x000fe400078ee210ULL,
0xfffffff81d4c7812ULL, 0x000fe400078ee218ULL, 0x0000000712187812ULL, 0x000fe200078e4807ULL,
0x00000010282f7824ULL, 0x100fe200078e0219ULL, 0x0000007f12107812ULL, 0x000fe200078ec0ffULL,
0x000000104c4f7824ULL, 0x000fe200078e0219ULL, 0xfffffff81c1c7812ULL, 0x000fc400078ee211ULL,
0x0000001c12127810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0213ULL,
0x000000072a117212ULL, 0x000fe200078e3cffULL, 0x000000101c297824ULL, 0x000fe200078e0219ULL,
0x0000007f1a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000812507824ULL, 0x000fe200078e00ffULL,
0x0000007f22227812ULL, 0x000fe400078ec0ffULL, 0x0000007f124e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff82c2c7812ULL, 0x000fc400078ee211ULL, 0x0000007f1e1e7812ULL, 0x000fe400078ec0ffULL,
0x0000000712117212ULL, 0x000fe200078e3cffULL, 0x000000102c4d7824ULL, 0x000fe200078e0219ULL,
0x000000131a127210ULL, 0x000fe20007ffe0ffULL, 0x00000001221a7824ULL, 0x100fe200078e0213ULL,
0x0000007f26267812ULL, 0x000fe200078ec0ffULL, 0x000000014e227824ULL, 0x100fe200078e0213ULL,
0x0000007f2a2a7812ULL, 0x000fe200078ec0ffULL, 0x000000011e1e7824ULL, 0x100fe200078e0213ULL,
0x0000007f2e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000126267824ULL, 0x000fe200078e0213ULL,
0x0ffffff818187812ULL, 0x000fe200078ef807ULL, 0x000000012a2a7824ULL, 0x000fe200078e0213ULL,
0xfffffff8504e7812ULL, 0x000fe200078ee211ULL, 0x000000012e2e7824ULL, 0x000fe200078e0213ULL,
0x0000000825257812ULL, 0x000fe200078ee256ULL, 0x00005e0010107625ULL, 0x000fe200078e0023ULL,
0x000000194e517211ULL, 0x000fc600078e20ffULL, 0x0000001018277824ULL, 0x000fe400078e0219ULL,
0x00005e0012127625ULL, 0x000fc800078e0023ULL, 0x00005e001e187625ULL, 0x000fc800078e0023ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0023ULL, 0x00005e00261c7625ULL, 0x000fc800078e0023ULL,
0x00005e002a1e7625ULL, 0x000fc800078e0023ULL, 0x00005e002e207625ULL, 0x000fc800078e0023ULL,
0x0000001025107825ULL, 0x000fc800078e0010ULL, 0x00005e0022227625ULL, 0x000fe200078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0003e6000b901c46ULL,
0x0000001025127825ULL, 0x000fc800078e0012ULL, 0x0000001025187825ULL, 0x040fe200078e0018ULL,
0x0000000012297faeULL, 0x0003e6000b901c46ULL, 0x00000010251a7825ULL, 0x040fe200078e001aULL,
0x00000000182b7faeULL, 0x0003e6000b901c46ULL, 0x00000010251c7825ULL, 0x040fe200078e001cULL,
0x000000001a2d7faeULL, 0x0003e6000b901c46ULL, 0x00000010251e7825ULL, 0x040fe200078e001eULL,
0x000000001c2f7faeULL, 0x0003e6000b901c46ULL, 0x0000001025207825ULL, 0x040fe200078e0020ULL,
0x000000001e4d7faeULL, 0x0003e6000b901c46ULL, 0x0000001025227825ULL, 0x000fe200078e0022ULL,
0x00000000204f7faeULL, 0x0003e8000b901c46ULL, 0x0000000022517faeULL, 0x0003e4000b901c46ULL,
0x01361c000d107984ULL, 0x002e620000000800ULL, 0x8000000057117824ULL, 0x000fc600078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x8000000010ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fe400078e00ffULL, 0x8000000057127824ULL, 0x000fe400078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01361c000d117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007804812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000008060107810ULL, 0x000fe20007ffe05eULL,
0x000010000c7c7824ULL, 0x000fc800078e00ffULL, 0x000000015d107824ULL, 0x000fe200078e0210ULL,
0x000010007c7c7812ULL, 0x000fc800078e0cffULL, 0x0130000010117984ULL, 0x000e680000000800ULL,
0x01320000107a7984ULL, 0x0004e20000000800ULL, 0x000000081100720bULL, 0x002fda0003f1d000ULL,
0x0000000000127806ULL, 0x000fc800000e0100ULL, 0x0000ffff12137812ULL, 0x000fe2000780c0ffULL,
0x00000001ff127424ULL, 0x000fd800078e00ffULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x000000081100720bULL, 0x00cfe40003f14000ULL, 0x0000001108187209ULL, 0x000fe40007810000ULL,
0x00000002ff197819ULL, 0x000fc60000011607ULL, 0x8000001808107221ULL, 0x000fe20000010000ULL,
0x0000000167087811ULL, 0x000fc600078ff0ffULL, 0x3fb8aa3b10127820ULL, 0x000fe40000410000ULL,
0x0000000000107806ULL, 0x000fe400000e0100ULL, 0x000000670800720cULL, 0x000fe40003f05270ULL,
0x0000001200127308ULL, 0x000e620000000800ULL, 0x0000ffff10107812ULL, 0x000fc800078e3cffULL,
0x0000001013ff7212ULL, 0x000fcc000782c0ffULL, 0x0000008067108824ULL, 0x000fe200078e0260ULL,
0x00001f1912087589ULL, 0x002e6800000e0000ULL, 0x000000105d138210ULL, 0x000fe40007ffe0ffULL,
0x8000001811111221ULL, 0x000fe20000010000ULL, 0x0000001209097220ULL, 0x000fe20000410000ULL,
0x00001f5412107589ULL, 0x0004e400000e0000ULL, 0x3fb8aa3b11111820ULL, 0x000fc40000410000ULL,
0x0134001813008388ULL, 0x0009e40000000800ULL, 0x00000011000e1308ULL, 0x000f620000000800ULL,
0x00000001ff127807ULL, 0x004fe20000800000ULL, 0x0000000848487220ULL, 0x082fe20000410000ULL,
0x0000000849497220ULL, 0x080fe20000410000ULL, 0x0000000844447220ULL, 0x080fe20000410000ULL,
0x0000000845457220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x000fe20000410000ULL, 0x000000104a4a7220ULL, 0x088fe20000410000ULL,
0x000000104b4b7220ULL, 0x080fe20000410000ULL, 0x0000001046467220ULL, 0x080fe20000410000ULL,
0x0000001047477220ULL, 0x080fe20000410000ULL, 0x0000001042427220ULL, 0x080fe20000410000ULL,
0x0000001043437220ULL, 0x080fe20000410000ULL, 0x000000103e3e7220ULL, 0x080fe20000410000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001016167220ULL, 0x080fe20000410000ULL,
0x0000001017177220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fe200078e0018ULL,
0x0000007a0e7a1220ULL, 0x020fe20000410000ULL, 0x0000b00075117810ULL, 0x01cfe20007ffe07cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x009800005c28783bULL, 0x000fe20000000200ULL,
0x00000010726e7824ULL, 0x100fe200078e0211ULL, 0x0000000eff10723eULL, 0x000fe200000010ffULL,
0x0000001076717824ULL, 0x000fe200078e0211ULL, 0x00000002ff7b7819ULL, 0x000fe20000011607ULL,
0x0000001074707824ULL, 0x100fe200078e0211ULL, 0x000000006e2c783bULL, 0x000fe20000004200ULL,
0x00000010736f7824ULL, 0x000fe200078e0211ULL, 0x0000541010197816ULL, 0x000fe20000000010ULL,
0x00004000045f7824ULL, 0x000fe200078e026dULL, 0x000000007158783bULL, 0x000fe20000004200ULL,
0x0000991012187816ULL, 0x000fc600000000ffULL, 0x000000007050783bULL, 0x000fe20000004200ULL,
0x0000b0005f5f7810ULL, 0x000fe40007ffe07cULL, 0x000000ff1800720cULL, 0x000fe20003f05270ULL,
0x000000006f4c783bULL, 0x000fe20000004200ULL, 0x0000005f6b627211ULL, 0x000fe200078e20ffULL,
0x000000106c637824ULL, 0x100fe400078e025fULL, 0x00001f7b197b7589ULL, 0x000e6200000e0000ULL,
0x000000106a617824ULL, 0x100fe400078e025fULL, 0x00000010655f7824ULL, 0x000fe200078e025fULL,
0x00001f54197e7589ULL, 0x000ea800000e0000ULL, 0x009800005510783bULL, 0x000ee80000000200ULL,
0x000000005f18783bULL, 0x000f280000004200ULL, 0x000000006324783bULL, 0x000f680000004200ULL,
0x000000006220783bULL, 0x000f280000004200ULL, 0x00000000611c783bULL, 0x000f220000004200ULL,
0x0000007b28288231ULL, 0x002fc400003400ffULL, 0x0000007b2a2a8231ULL, 0x000fe400003400ffULL,
0x0000007e29298231ULL, 0x084fe400003400ffULL, 0x0000007e2b2b8231ULL, 0x000fce00003400ffULL,
0x0000002c2830723cULL, 0x040ff00000041830ULL, 0x000000582848723cULL, 0x000fe20000041848ULL,
0x0000007b10108231ULL, 0x088fe400003400ffULL, 0x0000007b12128231ULL, 0x000fc400003400ffULL,
0x0000007e11118231ULL, 0x000fc600003400ffULL, 0x0000005a2844723cULL, 0x000fe20000041844ULL,
0x0000007e13138231ULL, 0x000fce00003400ffULL, 0x000000502840723cULL, 0x040ff00000041840ULL,
0x00000052283c723cULL, 0x040ff0000004183cULL, 0x0000004c2838723cULL, 0x040ff00000041838ULL,
0x0000004e2834723cULL, 0x040ff00000041834ULL, 0x0000002e2814723cULL, 0x000ff00000041814ULL,
0x000000181030723cULL, 0x050fee0000041830ULL, 0x00000002ff187819ULL, 0x000fe20000011667ULL,
0x000000241048723cULL, 0x060ff00000041848ULL, 0x000000261044723cULL, 0x040ff00000041844ULL,
0x000000201040723cULL, 0x040ff00000041840ULL, 0x00000022103c723cULL, 0x040ff0000004183cULL,
0x0000001c1038723cULL, 0x040ff00000041838ULL, 0x0000001e1034723cULL, 0x040ff00000041834ULL,
0x0000001a1014723cULL, 0x000fee0000041814ULL, 0x0001362018107811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004018117824ULL, 0x000fe200078e0277ULL,
0x0000000010ff7f8cULL, 0x0003e2000c80043fULL, 0x000000097a097221ULL, 0x000fe20000010000ULL,
0x000000010c7a7812ULL, 0x000fc400078ec0ffULL, 0x0000008011117810ULL, 0x000fc80007ffe0ffULL,
0x000000681100720cULL, 0x000fda0003f06070ULL, 0x00002c1000000947ULL, 0x000fea0003800000ULL,
0x0000000169037810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000640300720cULL, 0x000fe40003f06070ULL, 0xffffffe000107812ULL, 0x000fca00078ec0ffULL,
0x0000010069107824ULL, 0x000fca00078e0210ULL, 0x000000c010107810ULL, 0x000fc80007ffe0ffULL,
0x0000006005117812ULL, 0x000fe200078ef810ULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff187819ULL, 0x000fe20000011607ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x0000001068037217ULL, 0x000fe20007800000ULL,
0x0000200067127824ULL, 0x000fe200078e00ffULL, 0x0000000418197810ULL, 0x040fe20007ffe0ffULL,
0x000000080f217824ULL, 0x000fe200078e00ffULL, 0x00000008181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000402117c24ULL, 0x000fe2000f8e0211ULL, 0x0000000719027212ULL, 0x080fe200078e3cffULL,
0x0000000103037824ULL, 0x000fe200078e0a10ULL, 0x0000000319237819ULL, 0x000fe200000006ffULL,
0x000000081a257824ULL, 0x040fe200078e00ffULL, 0x000000071a107212ULL, 0x000fe200078e3cffULL,
0x00000100ff4d7424ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fc400078ee202ULL,
0x0000200012137812ULL, 0x000fe400078ec0ffULL, 0x0000007f18027812ULL, 0x040fe400078ec0ffULL,
0x00000010181c7810ULL, 0x000fe20007ffe0ffULL, 0x0000400004137824ULL, 0x000fe200078e0213ULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x0000000102027824ULL, 0x000fe200078e0211ULL,
0x0000002003107817ULL, 0x000fe20003800000ULL, 0x000000081c207824ULL, 0x000fe200078e00ffULL,
0x00000014181e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fe200078e004dULL,
0x0000000718127812ULL, 0x000fc400078e4807ULL, 0x0000000c181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081e227824ULL, 0x000fe200078e00ffULL, 0x000000101800720cULL, 0x000fe40003f06070ULL,
0x000000071c1d7212ULL, 0x080fe200078e3cffULL, 0x000000081b277824ULL, 0x000fe200078e00ffULL,
0x0000b000137c7810ULL, 0x000fe40007ffe07cULL, 0x0000000821217812ULL, 0x000fe400078ee256ULL,
0x0ffffff812137812ULL, 0x000fe200078ef807ULL, 0x0000001023237824ULL, 0x000fe200078e027cULL,
0xfffffff8201d7812ULL, 0x000fe200078ee21dULL, 0x0000001021027825ULL, 0x000fe200078e0002ULL,
0x000000071e1f7212ULL, 0x000fc400078e3cffULL, 0x0000001818207810ULL, 0x000fe20007ffe0ffULL,
0x000000101d297824ULL, 0x100fe200078e027cULL, 0x000000071b127212ULL, 0x080fe200078e3cffULL,
0x0000001025257824ULL, 0x000fe200078e027cULL, 0x0000007c13137211ULL, 0x000fe200078e20ffULL,
0x00000008202d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8221f7812ULL, 0x000fe400078ee21fULL,
0xfffffff827277812ULL, 0x000fe200078ee212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002137faeULL, 0x0003e2000c101c46ULL, 0x0000001c18227810ULL, 0x000fe20007ffe0ffULL,
0x000000101f2b7824ULL, 0x100fe200078e027cULL, 0x0000000720127212ULL, 0x000fe200078e3cffULL,
0x0000001027277824ULL, 0x000fe200078e027cULL, 0x000000101900720cULL, 0x000fc40003f06070ULL,
0x000000101a00720cULL, 0x080fe40003f26070ULL, 0x000000101b00720cULL, 0x080fe40003f46070ULL,
0x000000101c00720cULL, 0x080fe40003f66070ULL, 0x000000101e00720cULL, 0x080fe40003f86070ULL,
0x000000102000720cULL, 0x080fe40003fa6070ULL, 0x000000102200720cULL, 0x000fc40003fc6070ULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee212ULL, 0x0000007f19107812ULL, 0x000fe400078ec0ffULL,
0x0000007f1a127812ULL, 0x000fe200078ec0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e027cULL,
0x0000007f1b187812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x100fe200078e0211ULL,
0x0000007f1c1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000112127824ULL, 0x100fe200078e0211ULL,
0x0000007f1e1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000118187824ULL, 0x100fe200078e0211ULL,
0x0000007f22027812ULL, 0x002fe200078ec0ffULL, 0x000000011a1a7824ULL, 0x100fe200078e0211ULL,
0x0000007f201e7812ULL, 0x000fe200078ec0ffULL, 0x000000011c1c7824ULL, 0x100fe200078e0211ULL,
0x0000000722037212ULL, 0x040fe200078e3cffULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x000000111e1e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000102027824ULL, 0x000fc400078e0211ULL,
0x00005e0010107625ULL, 0x000fe200078e004dULL, 0xfffffff822037812ULL, 0x000fc600078ee203ULL,
0x00005e0012127625ULL, 0x000fe200078e004dULL, 0x0000007c032f7211ULL, 0x000fc600078e20ffULL,
0x00005e0018187625ULL, 0x000fc800078e004dULL, 0x00005e001a1a7625ULL, 0x000fc800078e004dULL,
0x00005e001c1c7625ULL, 0x000fc800078e004dULL, 0x00005e001e1e7625ULL, 0x000fc800078e004dULL,
0x00005e0002027625ULL, 0x000fc800078e004dULL, 0x0000001021107825ULL, 0x000fc800078e0010ULL,
0x0000001021127825ULL, 0x040fe200078e0012ULL, 0x0000000010237faeULL, 0x0003e6000c101c46ULL,
0x0000001021187825ULL, 0x040fe200078e0018ULL, 0x0000000012257faeULL, 0x0003e6000c901c46ULL,
0x00000010211a7825ULL, 0x040fe200078e001aULL, 0x0000000018277faeULL, 0x0003e6000d101c46ULL,
0x00000010211c7825ULL, 0x040fe200078e001cULL, 0x000000001a297faeULL, 0x0003e6000d901c46ULL,
0x00000010211e7825ULL, 0x040fe200078e001eULL, 0x000000001c2b7faeULL, 0x0003e6000e101c46ULL,
0x0000001021027825ULL, 0x000fe200078e0002ULL, 0x000000001e2d7faeULL, 0x0003e8000e901c46ULL,
0x00000000022f7faeULL, 0x0003e2000f101c46ULL, 0x000005c000007947ULL, 0x000fea0003800000ULL,
0x0000200067037824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fe20000011607ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000200003037812ULL, 0x000fe400078ec0ffULL, 0x0000000410187810ULL, 0x040fe40007ffe0ffULL,
0x00000008101c7810ULL, 0x000fe20007ffe0ffULL, 0x0000400004037824ULL, 0x000fe200078e0203ULL,
0x0000000c10207810ULL, 0x000fe20007ffe0ffULL, 0x0000000818197824ULL, 0x000fe200078e00ffULL,
0x0000001010247810ULL, 0x000fe20007ffe0ffULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0x0000000718127212ULL, 0x080fe200078e3cffULL, 0x0000000402027c24ULL, 0x000fe2000f8e0211ULL,
0x0000001410287810ULL, 0x000fe20007ffe0ffULL, 0x0000000820227824ULL, 0x000fe200078e00ffULL,
0x000000071c137212ULL, 0x000fe200078e3cffULL, 0x00000008241b7824ULL, 0x000fe200078e00ffULL,
0x0000b00003117810ULL, 0x000fe20007ffe07cULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8191a7812ULL, 0x000fc400078ee212ULL, 0x0000000720037212ULL, 0x080fe400078e3cffULL,
0x0000000724127212ULL, 0x080fe400078e3cffULL, 0x00000018102c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee213ULL, 0x0000000728137212ULL, 0x000fe400078e3cffULL,
0xfffffff822227812ULL, 0x000fc400078ee203ULL, 0xfffffff81b267812ULL, 0x000fe400078ee212ULL,
0x000000072c197212ULL, 0x000fe200078e3cffULL, 0x00000010222b7824ULL, 0x000fe200078e0211ULL,
0x000000032c2e7819ULL, 0x000fe400000006ffULL, 0x0000000710127812ULL, 0x040fe400078e4807ULL,
0x0000007f10037812ULL, 0x040fe400078ec0ffULL, 0x0000001c10107810ULL, 0x000fc40007ffe0ffULL,
0x0000007f28237812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x100fe200078e0202ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee213ULL, 0x0000000810297824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee219ULL, 0x00000001232f7824ULL, 0x100fe200078e0202ULL,
0x0000007f18137812ULL, 0x000fe200078ec0ffULL, 0x000000080f237824ULL, 0x000fe200078e00ffULL,
0x0000007f1c197812ULL, 0x000fe200078ec0ffULL, 0x000000102a4d7824ULL, 0x000fe200078e0211ULL,
0x0000007f201d7812ULL, 0x000fe200078ec0ffULL, 0x00000001131b7824ULL, 0x100fe200078e0202ULL,
0x0000007f2c257812ULL, 0x000fe200078ec0ffULL, 0x0000000119197824ULL, 0x100fe200078e0202ULL,
0x0000007f10277812ULL, 0x000fe200078ec0ffULL, 0x000000011d1f7824ULL, 0x100fe200078e0202ULL,
0x0ffffff812127812ULL, 0x000fe200078ef807ULL, 0x000000102e517824ULL, 0x100fe200078e0211ULL,
0x0000007f24217812ULL, 0x000fe200078ec0ffULL, 0x0000000127537824ULL, 0x000fe200078e0202ULL,
0x0000000710187212ULL, 0x000fe200078e3cffULL, 0x00000100ff107424ULL, 0x000fe200078e00ffULL,
0x00000002254f7210ULL, 0x000fe20007ffe0ffULL, 0x0000001012257824ULL, 0x100fe200078e0211ULL,
0xfffffff829187812ULL, 0x000fe200078ee218ULL, 0x0000000121217824ULL, 0x000fe200078e0202ULL,
0x0000000823237812ULL, 0x000fe200078ee256ULL, 0x000000101a277824ULL, 0x000fe200078e0211ULL,
0x00000011262d7211ULL, 0x000fe200078e20ffULL, 0x00005e0003127625ULL, 0x000fc800078e0010ULL,
0x00005e001b1a7625ULL, 0x000fc800078e0010ULL, 0x000000101e297824ULL, 0x000fe400078e0211ULL,
0x00005e00191c7625ULL, 0x000fc800078e0010ULL, 0x00005e001f1e7625ULL, 0x000fc800078e0010ULL,
0x0000001018597824ULL, 0x000fe400078e0211ULL, 0x00005e0021207625ULL, 0x000fc800078e0010ULL,
0x00005e002f187625ULL, 0x000fc800078e0010ULL, 0x00005e004f027625ULL, 0x000fc800078e0010ULL,
0x0000001023127825ULL, 0x000fc800078e0012ULL, 0x00005e0053107625ULL, 0x000fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012257faeULL, 0x0003e6000b901c46ULL,
0x00000010231a7825ULL, 0x000fc800078e001aULL, 0x00000010231c7825ULL, 0x040fe200078e001cULL,
0x000000001a277faeULL, 0x0003e6000b901c46ULL, 0x00000010231e7825ULL, 0x040fe200078e001eULL,
0x000000001c297faeULL, 0x0003e6000b901c46ULL, 0x0000001023207825ULL, 0x040fe200078e0020ULL,
0x000000001e2b7faeULL, 0x0003e6000b901c46ULL, 0x0000001023187825ULL, 0x040fe200078e0018ULL,
0x00000000202d7faeULL, 0x0003e6000b901c46ULL, 0x0000001023027825ULL, 0x040fe200078e0002ULL,
0x00000000184d7faeULL, 0x0003e6000b901c46ULL, 0x0000001023107825ULL, 0x000fe200078e0010ULL,
0x0000000002517faeULL, 0x0003e8000b901c46ULL, 0x0000000010597faeULL, 0x0003e4000b901c46ULL,
0x0000000179037824ULL, 0x002fe200078e0278ULL, 0x01362c000d127984ULL, 0x000e620000000800ULL,
0x00000300ff027624ULL, 0x000fc600078e00ffULL, 0x0000000103107812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff02027811ULL, 0x000fe400078e08ffULL,
0x000000011000780cULL, 0x000fc80003f05070ULL, 0x0000000102027807ULL, 0x000fca0004000000ULL,
0x0000000103037824ULL, 0x000fe400078e0202ULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x000000660300720cULL, 0x000fda0003f06070ULL, 0x0000000400118802ULL, 0x000fe20000000f00ULL,
0x0000000103108824ULL, 0x000fc800078e020aULL, 0x0000600010108625ULL, 0x000fca00078e0011ULL,
0x0000000610028981ULL, 0x000562000c1e1900ULL, 0x8000000057137824ULL, 0x000fca00078e00ffULL,
0x8000000012ff7812ULL, 0x002fe20007804813ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000000947ULL, 0x000fea0003800000ULL, 0x00000004670d7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x004fe400078e00ffULL, 0x8000000057127824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01362c000d117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007804812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000010060107810ULL, 0x004fe40007ffe05eULL, 0x0000000c0c137819ULL, 0x000fc600000006ffULL,
0x000000015d107824ULL, 0x000fe200078e0210ULL, 0x00001000131c7812ULL, 0x000fc800078ec0ffULL,
0x0130000010117984ULL, 0x000e680000000800ULL, 0x0132000010787984ULL, 0x0004e20000000800ULL,
0x000000081100720bULL, 0x002fda0003f1d000ULL, 0x0000000000127806ULL, 0x000fc800000e0100ULL,
0x0000ffff12197812ULL, 0x000fe2000780c0ffULL, 0x00000001ff127424ULL, 0x000fd800078e00ffULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x0000001108137209ULL, 0x0ccfe40007810000ULL,
0x000000081100720bULL, 0x000fe40003f14000ULL, 0x00000002ff1b7819ULL, 0x000fe20000011607ULL,
0x8000001308107221ULL, 0x040fe20000010000ULL, 0x0000001108087209ULL, 0x000fc60007810000ULL,
0x3fb8aa3b10187820ULL, 0x000fe20000410000ULL, 0x0000000267107811ULL, 0x000fca00078ff0ffULL,
0x0000001800187308ULL, 0x000e620000000800ULL, 0x0000000000127806ULL, 0x000fe400000e0100ULL,
0x000000671000720cULL, 0x000fe40003f05270ULL, 0x0000ffff12127812ULL, 0x000fc800078e3cffULL,
0x0000001219ff7212ULL, 0x000fce000782c0ffULL, 0x0000008067128824ULL, 0x000fe200078e0260ULL,
0x00001f1b18107589ULL, 0x002e6200000e0000ULL, 0x0000001809097220ULL, 0x000fe40000410000ULL,
0x000000015d1a8824ULL, 0x000fe400078e0212ULL, 0x00001f5418127589ULL, 0x000ea200000e0000ULL,
0x8000001311191221ULL, 0x000fc60000010000ULL, 0x013400131a008388ULL, 0x0007e20000000800ULL,
0x3fb8aa3b19191820ULL, 0x000fc80000410000ULL, 0x00000019000e1308ULL, 0x000f220000000800ULL,
0x0000001048487220ULL, 0x082fe20000410000ULL, 0x0000001049497220ULL, 0x080fe20000410000ULL,
0x0000001044447220ULL, 0x080fe20000410000ULL, 0x0000001045457220ULL, 0x080fe20000410000ULL,
0x0000001040407220ULL, 0x080fe20000410000ULL, 0x0000001041417220ULL, 0x080fe20000410000ULL,
0x000000103c3c7220ULL, 0x080fe20000410000ULL, 0x000000103d3d7220ULL, 0x080fe20000410000ULL,
0x0000001038387220ULL, 0x080fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001014147220ULL, 0x080fe20000410000ULL, 0x0000001015157220ULL, 0x000fe20000410000ULL,
0x00000001ff107807ULL, 0x000fe20000800000ULL, 0x000000124a4a7220ULL, 0x084fe20000410000ULL,
0x000000124b4b7220ULL, 0x080fe20000410000ULL, 0x0000001246467220ULL, 0x080fe20000410000ULL,
0x0000001247477220ULL, 0x080fe20000410000ULL, 0x0000001242427220ULL, 0x080fe20000410000ULL,
0x0000001243437220ULL, 0x080fe20000410000ULL, 0x000000123e3e7220ULL, 0x080fe20000410000ULL,
0x000000123f3f7220ULL, 0x080fe20000410000ULL, 0x000000123a3a7220ULL, 0x080fe20000410000ULL,
0x000000123b3b7220ULL, 0x080fe20000410000ULL, 0x0000001236367220ULL, 0x080fe20000410000ULL,
0x0000001237377220ULL, 0x080fe20000410000ULL, 0x0000001232327220ULL, 0x080fe20000410000ULL,
0x0000001233337220ULL, 0x080fe20000410000ULL, 0x0000001216167220ULL, 0x080fe20000410000ULL,
0x0000001217177220ULL, 0x000fe20000410000ULL, 0x0000761010127816ULL, 0x000fe20000000012ULL,
0x000000780e781220ULL, 0x010fe20000410000ULL, 0x0000b00075757810ULL, 0x00cfe20007ffe01cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00a000005c28783bULL, 0x000fe20000000200ULL,
0x00000010722c7824ULL, 0x100fe200078e0275ULL, 0x0000000eff10723eULL, 0x000fe200000010ffULL,
0x0000001076587824ULL, 0x100fe200078e0275ULL, 0x0000991012197816ULL, 0x000fe200000000ffULL,
0x0000001074507824ULL, 0x100fe200078e0275ULL, 0x00005410101a7816ULL, 0x000fe20000000010ULL,
0x00000010734c7824ULL, 0x000fe200078e0275ULL, 0x000000002c2c783bULL, 0x000fe20000004200ULL,
0x00000002ff737819ULL, 0x000fe20000011607ULL, 0x00004000046d7824ULL, 0x000fe200078e026dULL,
0x000000ff1900720cULL, 0x000fe20003f05270ULL, 0x000000005858783bULL, 0x000fe60000004200ULL,
0x0000b0006d187810ULL, 0x000fe20007ffe01cULL, 0x000000005050783bULL, 0x000fe60000004200ULL,
0x000000186c247211ULL, 0x000fe200078e20ffULL, 0x000000004c4c783bULL, 0x000fe20000004200ULL,
0x000000106b207824ULL, 0x000fc400078e0218ULL, 0x000000106a1c7824ULL, 0x100fe200078e0218ULL,
0x00001f731a737589ULL, 0x000e6200000e0000ULL, 0x0000001065187824ULL, 0x000fc600078e0218ULL,
0x00001f541a727589ULL, 0x000ea800000e0000ULL, 0x00a000005510783bULL, 0x000ee80000000200ULL,
0x000000001818783bULL, 0x000f280000004200ULL, 0x000000002424783bULL, 0x000f280000004200ULL,
0x000000002020783bULL, 0x000f280000004200ULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0x0000007328288231ULL, 0x002fc400003400ffULL, 0x000000732a2a8231ULL, 0x000fe400003400ffULL,
0x0000007229298231ULL, 0x084fe400003400ffULL, 0x000000722b2b8231ULL, 0x000fce00003400ffULL,
0x0000002c2830723cULL, 0x040ff00000041830ULL, 0x000000582848723cULL, 0x000fe20000041848ULL,
0x0000007310108231ULL, 0x088fe400003400ffULL, 0x0000007312128231ULL, 0x000fc400003400ffULL,
0x0000007211118231ULL, 0x000fc600003400ffULL, 0x0000005a2844723cULL, 0x000fe20000041844ULL,
0x0000007213138231ULL, 0x000fce00003400ffULL, 0x000000502840723cULL, 0x040ff00000041840ULL,
0x00000052283c723cULL, 0x040ff0000004183cULL, 0x0000004c2838723cULL, 0x040ff00000041838ULL,
0x0000004e2834723cULL, 0x040ff00000041834ULL, 0x0000002e2814723cULL, 0x000ff00000041814ULL,
0x000000181030723cULL, 0x050fee0000041830ULL, 0x00000002ff187819ULL, 0x000fe20000011667ULL,
0x000000241048723cULL, 0x040ff00000041848ULL, 0x000000261044723cULL, 0x040ff00000041844ULL,
0x000000201040723cULL, 0x040ff00000041840ULL, 0x00000022103c723cULL, 0x040ff0000004183cULL,
0x0000001c1038723cULL, 0x040ff00000041838ULL, 0x0000001e1034723cULL, 0x040ff00000041834ULL,
0x0000001a1014723cULL, 0x000fee0000041814ULL, 0x0001363018107811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004018117824ULL, 0x000fe200078e0277ULL,
0x0000000010ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000978097221ULL, 0x000fe20000010000ULL,
0x000000010c7a7812ULL, 0x000fc400078e0cffULL, 0x000000c011117810ULL, 0x000fc80007ffe0ffULL,
0x000000681100720cULL, 0x000fda0003f06070ULL, 0x0000151000000947ULL, 0x000fea0003800000ULL,
0x0000030069137a10ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000113117810ULL, 0x040fe20007ffe0ffULL, 0x0000010013137824ULL, 0x000fc600078e0206ULL,
0x000000641100720cULL, 0x000fe40003f06070ULL, 0x0000006005117812ULL, 0x000fd600078ef813ULL,
0x000006a000008947ULL, 0x000fea0003800000ULL, 0x0000001368107217ULL, 0x000fe20007800000ULL,
0x0000200067187824ULL, 0x000fe200078e00ffULL, 0x00000003ff197819ULL, 0x000fe20000011607ULL,
0x000010000c127824ULL, 0x000fe200078e00ffULL, 0x0000001013107210ULL, 0x000fe20007ffe1ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000004191c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x0000200018137812ULL, 0x000fe200078ec0ffULL,
0x000000080f237824ULL, 0x000fe200078e00ffULL, 0x00000008191e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081c1d7824ULL, 0x040fe200078e00ffULL, 0x000000071c187212ULL, 0x000fe200078e3cffULL,
0x0000400004137824ULL, 0x000fe200078e0213ULL, 0x0000100012127812ULL, 0x000fe200078ec0ffULL,
0x000000081e1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d227812ULL, 0x000fe200078ee218ULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x0000b000131b7810ULL, 0x000fe20007ffe012ULL,
0x0000000402137c24ULL, 0x020fe2000f8e0211ULL, 0x0000007f19187812ULL, 0x000fc400078ec0ffULL,
0x000000071e1a7212ULL, 0x000fe400078e3cffULL, 0x0000001019207810ULL, 0x000fe40007ffe0ffULL,
0x0000002010127817ULL, 0x000fe20003800000ULL, 0x0000000118107824ULL, 0x000fe200078e0213ULL,
0xfffffff81f247812ULL, 0x000fe400078ee21aULL, 0x00000007191a7812ULL, 0x040fe200078e4807ULL,
0x00005e0010107625ULL, 0x000fe200078e0021ULL, 0x0000001419277810ULL, 0x000fc40007ffe0ffULL,
0x0000000c191f7810ULL, 0x040fe40007ffe0ffULL, 0x000000121900720cULL, 0x000fe20003f06070ULL,
0x00000008272a7824ULL, 0x000fe200078e00ffULL, 0x0000000720257212ULL, 0x040fe200078e3cffULL,
0x000000081f2b7824ULL, 0x000fe200078e00ffULL, 0x0000000320287819ULL, 0x000fe400000006ffULL,
0x0000000823237812ULL, 0x000fe400078ee256ULL, 0x0ffffff81a1a7812ULL, 0x000fc400078ef807ULL,
0xfffffff828287812ULL, 0x000fe200078ee225ULL, 0x0000001023107825ULL, 0x000fe200078e0010ULL,
0x0000000727297212ULL, 0x080fe400078e3cffULL, 0x0000001819257810ULL, 0x000fe20007ffe0ffULL,
0x000000101a1d7824ULL, 0x000fe200078e021bULL, 0x000000071f187212ULL, 0x080fe400078e3cffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee229ULL, 0x0000000825297824ULL, 0x000fe200078e00ffULL,
0xfffffff82b267812ULL, 0x000fe200078ee218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x0000001c19197810ULL, 0x000fe20007ffe0ffULL,
0x00000010282b7824ULL, 0x000fe200078e021bULL, 0x0000000725187212ULL, 0x000fc400078e3cffULL,
0x000000121c00720cULL, 0x080fe20003f06070ULL, 0x00000008192e7824ULL, 0x000fe200078e00ffULL,
0x000000121e00720cULL, 0x080fe40003f26070ULL, 0x000000121f00720cULL, 0x080fe40003f46070ULL,
0x000000122000720cULL, 0x080fe40003f66070ULL, 0x000000122700720cULL, 0x080fe40003f86070ULL,
0x000000122500720cULL, 0x000fc40003fa6070ULL, 0x000000121900720cULL, 0x000fe40003fc6070ULL,
0x0000007f1c107812ULL, 0x002fe400078ec0ffULL, 0xfffffff8292c7812ULL, 0x000fe200078ee218ULL,
0x0000001026297824ULL, 0x000fe200078e021bULL, 0x0000007f1e127812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0213ULL, 0x0000007f1f187812ULL, 0x000fe200078ec0ffULL,
0x000000102c2f7824ULL, 0x000fe200078e021bULL, 0x0000000719117212ULL, 0x000fe200078e3cffULL,
0x0000000112127824ULL, 0x100fe200078e0213ULL, 0x0000007f201a7812ULL, 0x000fe200078ec0ffULL,
0x0000000118187824ULL, 0x000fe200078e0213ULL, 0x0000007f271c7812ULL, 0x000fe200078ec0ffULL,
0x0000001024277824ULL, 0x100fe200078e021bULL, 0x0000007f251e7812ULL, 0x000fe200078ec0ffULL,
0x0000001022257824ULL, 0x000fe200078e021bULL, 0x0000007f19207812ULL, 0x000fe200078ec0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0213ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee211ULL,
0x000000011e1e7824ULL, 0x100fe200078e0213ULL, 0x000000131a1a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000120207824ULL, 0x000fe200078e0213ULL, 0x0000001b2a2d7211ULL, 0x000fe200078e20ffULL,
0x00005e0010107625ULL, 0x000fc800078e0021ULL, 0x00005e0012127625ULL, 0x000fc800078e0021ULL,
0x000000102e4d7824ULL, 0x000fe400078e021bULL, 0x00005e0018187625ULL, 0x000fc800078e0021ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0021ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0021ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0021ULL, 0x00005e0020207625ULL, 0x000fc800078e0021ULL,
0x0000001023107825ULL, 0x000fc800078e0010ULL, 0x0000001023127825ULL, 0x040fe200078e0012ULL,
0x0000000010257faeULL, 0x0003e6000c101c46ULL, 0x0000001023187825ULL, 0x040fe200078e0018ULL,
0x0000000012277faeULL, 0x0003e6000c901c46ULL, 0x00000010231a7825ULL, 0x040fe200078e001aULL,
0x0000000018297faeULL, 0x0003e6000d101c46ULL, 0x00000010231c7825ULL, 0x040fe200078e001cULL,
0x000000001a2b7faeULL, 0x0003e6000d901c46ULL, 0x00000010231e7825ULL, 0x040fe200078e001eULL,
0x000000001c2d7faeULL, 0x0003e6000e101c46ULL, 0x0000001023207825ULL, 0x000fe200078e0020ULL,
0x000000001e2f7faeULL, 0x0003e8000e901c46ULL, 0x00000000204d7faeULL, 0x0003e2000f101c46ULL,
0x000005e000007947ULL, 0x000fea0003800000ULL, 0x0000200067127824ULL, 0x000fe200078e00ffULL,
0x00000003ff187819ULL, 0x000fe20000011607ULL, 0x000010000c107824ULL, 0x000fe200078e00ffULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0x00000004181a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000000c18227810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff237424ULL, 0x000fe200078e00ffULL,
0x0000200012137812ULL, 0x000fe200078ec0ffULL, 0x000000081a1d7824ULL, 0x040fe200078e00ffULL,
0x000000071a127212ULL, 0x080fe200078e3cffULL, 0x0000000822247824ULL, 0x040fe200078e00ffULL,
0x00000007221b7212ULL, 0x000fe200078e3cffULL, 0x0000400004137824ULL, 0x000fe200078e0213ULL,
0x0000001018267810ULL, 0x000fe20007ffe0ffULL, 0x0000000402117c24ULL, 0x020fe2000f8e0211ULL,
0x00000014182a7810ULL, 0x000fc40007ffe0ffULL, 0x0000100010107812ULL, 0x000fe400078ec0ffULL,
0x00000008181e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee212ULL,
0x000000082a1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee21bULL,
0x00000008261b7824ULL, 0x040fe200078e00ffULL, 0x0000b00013137810ULL, 0x000fe40007ffe010ULL,
0x0000000726107212ULL, 0x000fc400078e3cffULL, 0x000000072a127212ULL, 0x080fe200078e3cffULL,
0x00000010242d7824ULL, 0x000fe200078e0213ULL, 0x00000018182e7810ULL, 0x000fe40007ffe0ffULL,
0x000000071e197212ULL, 0x040fe400078e3cffULL, 0x000000031e207819ULL, 0x000fe200000006ffULL,
0x000000082e4c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b287812ULL, 0x000fe400078ee210ULL,
0xfffffff81d2c7812ULL, 0x000fc400078ee212ULL, 0x0000000718127812ULL, 0x000fe200078e4807ULL,
0x00000010282f7824ULL, 0x100fe200078e0213ULL, 0x0000007f18107812ULL, 0x000fe200078ec0ffULL,
0x000000102c4d7824ULL, 0x000fe200078e0213ULL, 0xfffffff820207812ULL, 0x000fe400078ee219ULL,
0x0000001c18187810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0211ULL,
0x000000072e197212ULL, 0x000fe200078e3cffULL, 0x00000010202b7824ULL, 0x000fe200078e0213ULL,
0x0000007f1e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000818507824ULL, 0x000fe200078e00ffULL,
0x0000007f2a2a7812ULL, 0x000fc400078ec0ffULL, 0xfffffff84c4c7812ULL, 0x000fe400078ee219ULL,
0x0000000718197212ULL, 0x000fe400078e3cffULL, 0x0000007f1a1a7812ULL, 0x000fe200078ec0ffULL,
0x000000104c4f7824ULL, 0x000fe200078e0213ULL, 0x0000007f184e7812ULL, 0x000fe400078ec0ffULL,
0x000000111e187210ULL, 0x000fe20007ffe0ffULL, 0x000000012a1e7824ULL, 0x100fe200078e0211ULL,
0x0000007f22227812ULL, 0x000fe200078ec0ffULL, 0x000000011a1a7824ULL, 0x100fe200078e0211ULL,
0x0000007f26267812ULL, 0x000fe200078ec0ffULL, 0x000000014e4e7824ULL, 0x100fe200078e0211ULL,
0x0000007f2e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000122227824ULL, 0x000fe200078e0211ULL,
0x0ffffff812127812ULL, 0x000fe200078ef807ULL, 0x0000000126267824ULL, 0x000fe200078e0211ULL,
0xfffffff8502a7812ULL, 0x000fe200078ee219ULL, 0x000000012e2e7824ULL, 0x000fe200078e0211ULL,
0x000000131c297211ULL, 0x000fe200078e20ffULL, 0x0000001012277824ULL, 0x100fe200078e0213ULL,
0x0000000825257812ULL, 0x000fe200078ee256ULL, 0x000000102a517824ULL, 0x000fc400078e0213ULL,
0x00005e0010107625ULL, 0x000fc800078e0023ULL, 0x00005e001a127625ULL, 0x000fc800078e0023ULL,
0x00005e0018187625ULL, 0x000fc800078e0023ULL, 0x00005e00221a7625ULL, 0x000fc800078e0023ULL,
0x00005e00261c7625ULL, 0x000fc800078e0023ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0023ULL,
0x00005e002e207625ULL, 0x000fc800078e0023ULL, 0x0000001025107825ULL, 0x000fc800078e0010ULL,
0x00005e004e227625ULL, 0x000fe200078e0023ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010277faeULL, 0x0003e6000b901c46ULL, 0x0000001025127825ULL, 0x000fc800078e0012ULL,
0x0000001025187825ULL, 0x040fe200078e0018ULL, 0x0000000012297faeULL, 0x0003e6000b901c46ULL,
0x00000010251a7825ULL, 0x040fe200078e001aULL, 0x00000000182b7faeULL, 0x0003e6000b901c46ULL,
0x00000010251c7825ULL, 0x040fe200078e001cULL, 0x000000001a2d7faeULL, 0x0003e6000b901c46ULL,
0x00000010251e7825ULL, 0x040fe200078e001eULL, 0x000000001c2f7faeULL, 0x0003e6000b901c46ULL,
0x0000001025207825ULL, 0x040fe200078e0020ULL, 0x000000001e4d7faeULL, 0x0003e6000b901c46ULL,
0x0000001025227825ULL, 0x000fe200078e0022ULL, 0x00000000204f7faeULL, 0x0003e8000b901c46ULL,
0x0000000022517faeULL, 0x0003e4000b901c46ULL, 0x01363c000d107984ULL, 0x002e620000000800ULL,
0x8000000057117824ULL, 0x000fc600078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x8000000010ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x0000001f57127819ULL, 0x000fe200000006ffULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01363c000d117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007804812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000180605e7810ULL, 0x000fca0007ffe05eULL, 0x000000015d5e7824ULL, 0x000fca00078e025eULL,
0x013000005e117984ULL, 0x000e680000000800ULL, 0x013200005e567984ULL, 0x0004e20000000800ULL,
0x000000081100720bULL, 0x002fda0003f1d000ULL, 0x0000000000107806ULL, 0x000fc800000e0100ULL,
0x0000ffff10137812ULL, 0x000fe2000780c0ffULL, 0x00000001ff107424ULL, 0x000fd800078e00ffULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x000000081100720bULL, 0x00cfe40003f14000ULL,
0x0000001108187209ULL, 0x000fe40007810000ULL, 0x00000002ff197819ULL, 0x000fc60000011607ULL,
0x8000001808107221ULL, 0x000fe20000010000ULL, 0x0000000367087811ULL, 0x000fc600078ff0ffULL,
0x3fb8aa3b10127820ULL, 0x000fe40000410000ULL, 0x0000000000107806ULL, 0x000fe400000e0100ULL,
0x000000670800720cULL, 0x000fe40003f05270ULL, 0x0000001200127308ULL, 0x000e620000000800ULL,
0x0000ffff10107812ULL, 0x000fc800078e3cffULL, 0x0000001013ff7212ULL, 0x000fcc000782c0ffULL,
0x0000008067608824ULL, 0x000fc800078e0260ULL, 0x000000015d5d8824ULL, 0x000fe200078e0260ULL,
0x00001f1912087589ULL, 0x002e6200000e0000ULL, 0x0000001209097220ULL, 0x000fe20000410000ULL,
0x8000001811111221ULL, 0x100fe40000010000ULL, 0x00001f5412107589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b11111820ULL, 0x000fe40000410000ULL, 0x013400185d008388ULL, 0x0007e40000000800ULL,
0x00000011000e1308ULL, 0x0009640000000800ULL, 0x00000001ff117807ULL, 0x010fe20000800000ULL,
0x0000000848487220ULL, 0x082fe20000410000ULL, 0x0000000849497220ULL, 0x080fe20000410000ULL,
0x0000000844447220ULL, 0x080fe20000410000ULL, 0x0000000845457220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000838387220ULL, 0x080fe20000410000ULL, 0x0000000839397220ULL, 0x080fe20000410000ULL,
0x0000000834347220ULL, 0x080fe20000410000ULL, 0x0000000835357220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x000fe20000410000ULL,
0x000000104a4a7220ULL, 0x084fe20000410000ULL, 0x000000104b4b7220ULL, 0x080fe20000410000ULL,
0x0000001046467220ULL, 0x080fe20000410000ULL, 0x0000001047477220ULL, 0x080fe20000410000ULL,
0x0000001042427220ULL, 0x080fe20000410000ULL, 0x0000001043437220ULL, 0x080fe20000410000ULL,
0x000000103e3e7220ULL, 0x080fe20000410000ULL, 0x000000103f3f7220ULL, 0x080fe20000410000ULL,
0x000000103a3a7220ULL, 0x080fe20000410000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001016167220ULL, 0x080fe20000410000ULL, 0x0000001017177220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fe200078e0018ULL, 0x0000761011107816ULL, 0x000fe20000000010ULL,
0x000000560e561220ULL, 0x020fe20000410000ULL, 0x000080400000791aULL, 0x00cfc80000000000ULL,
0x00a800005c28783bULL, 0x0003e20000000200ULL, 0x0000000eff11723eULL, 0x000fe400000010ffULL,
0x00000002ff577819ULL, 0x000fe20000011607ULL, 0x000000007158783bULL, 0x000fe20000004200ULL,
0x0000991010187816ULL, 0x000fc600000000ffULL, 0x000000007050783bULL, 0x000fe20000004200ULL,
0x00005410115c7816ULL, 0x002fe40000000011ULL, 0x000000ff1800720cULL, 0x000fe20003f05270ULL,
0x000000006f4c783bULL, 0x000fe80000004200ULL, 0x000000006e2c783bULL, 0x000fe80000004200ULL,
0x00001f575c577589ULL, 0x000e6800000e0000ULL, 0x00001f545c547589ULL, 0x000ea800000e0000ULL,
0x00a800005510783bULL, 0x000ee80000000200ULL, 0x000000006324783bULL, 0x000f280000004200ULL,
0x000000006220783bULL, 0x000f680000004200ULL, 0x00000000611c783bULL, 0x000f280000004200ULL,
0x000000005f18783bULL, 0x000f220000004200ULL, 0x0000005728288231ULL, 0x002fc400003400ffULL,
0x000000572a2a8231ULL, 0x000fe400003400ffULL, 0x0000005429298231ULL, 0x084fe400003400ffULL,
0x000000542b2b8231ULL, 0x000fce00003400ffULL, 0x000000582848723cULL, 0x040ff00000041848ULL,
0x0000005a2844723cULL, 0x000fe20000041844ULL, 0x0000005710108231ULL, 0x088fe400003400ffULL,
0x0000005712128231ULL, 0x000fc400003400ffULL, 0x0000005411118231ULL, 0x000fc600003400ffULL,
0x000000502840723cULL, 0x000fe20000041840ULL, 0x0000005413138231ULL, 0x000fce00003400ffULL,
0x00000052283c723cULL, 0x040ff0000004183cULL, 0x0000004c2838723cULL, 0x040ff00000041838ULL,
0x0000004e2834723cULL, 0x040ff00000041834ULL, 0x0000002c2830723cULL, 0x040ff00000041830ULL,
0x0000002e2814723cULL, 0x000ff00000041814ULL, 0x000000241048723cULL, 0x050ff00000041848ULL,
0x000000261044723cULL, 0x040ff00000041844ULL, 0x000000201040723cULL, 0x060ff00000041840ULL,
0x00000022103c723cULL, 0x040ff0000004183cULL, 0x0000001c1038723cULL, 0x040ff00000041838ULL,
0x0000001e1034723cULL, 0x040ff00000041834ULL, 0x000000181030723cULL, 0x040ff00000041830ULL,
0x0000001a1014723cULL, 0x000fe20000041814ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fdc0000008000ULL,
0x013640000dff7f8cULL, 0x0003e2000c80043fULL, 0x000000010c7a7812ULL, 0x000fe200078ec0ffULL,
0x0000000956097221ULL, 0x000fce0000010000ULL, 0x0000030069697a10ULL, 0x002fe40007ffe0ffULL,
0x000000ff0bff7812ULL, 0x000fc4000780c0ffULL, 0x000000646900720cULL, 0x000fe40003f26070ULL,
0x00000001ff0b7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffffa2b000007947ULL, 0x000fea000383ffffULL, 0x00000000000a7919ULL, 0x000e620000002500ULL,
0x000000ffff197224ULL, 0x000fe200078e0017ULL, 0x00000016001a7202ULL, 0x000fe40000000f00ULL,
0x000000640a00720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000009007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0009ULL,
0x00007300002e7802ULL, 0x000fe40000000f00ULL, 0x0000949000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x022fc80000000009ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000027919ULL, 0x000ee20000000000ULL, 0x0000000803037811ULL, 0x004fe400078ff0ffULL,
0x00000002ff057819ULL, 0x008fc80000011602ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0500027589ULL, 0x000ee200000e0000ULL, 0x0000004a034a7220ULL, 0x044fe20000410000ULL,
0x0000004b034b7220ULL, 0x040fe20000410000ULL, 0x0000004603467220ULL, 0x040fe20000410000ULL,
0x0000004703477220ULL, 0x040fe20000410000ULL, 0x0000004802487220ULL, 0x048fe20000410000ULL,
0x0000004902497220ULL, 0x040fe20000410000ULL, 0x0000004402447220ULL, 0x040fe20000410000ULL,
0x0000004502457220ULL, 0x040fe20000410000ULL, 0x0000004002407220ULL, 0x040fe20000410000ULL,
0x0000004102417220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x040fe20000410000ULL, 0x0000003802387220ULL, 0x040fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000003402347220ULL, 0x040fe20000410000ULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x000fe20000410000ULL, 0x0000004203427220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000003a033a7220ULL, 0x040fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000003603367220ULL, 0x040fe20000410000ULL,
0x0000003703377220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000363717723eULL, 0x000fc400000010ffULL, 0x0000001a1919723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000038390d723eULL, 0x000fe400000010ffULL,
0x000000484902723eULL, 0x020fe400000010ffULL, 0x00000034350e723eULL, 0x000fe400000010ffULL,
0x000000303110723eULL, 0x000fe400000010ffULL, 0x000000323318723eULL, 0x000fc400000010ffULL,
0x000000444507723eULL, 0x002fe400000010ffULL, 0x00000040410b723eULL, 0x000fe400000010ffULL,
0x0000003c3d0c723eULL, 0x000fe400000010ffULL, 0x000000141511723eULL, 0x000fe400000010ffULL,
0x0000004a4b12723eULL, 0x000fe400000010ffULL, 0x00000002ff277819ULL, 0x004fc40000011603ULL,
0x0000000803377811ULL, 0x000fe400078ff0ffULL, 0x0000000727007812ULL, 0x040fe200078ec0ffULL,
0x00000008271c7824ULL, 0x000fe200078e00ffULL, 0x00000027ff297212ULL, 0x000fe200078e33ffULL,
0x00000008371e7824ULL, 0x000fe200078e00ffULL, 0x00000037ff397212ULL, 0x000fe200078e33ffULL,
0x00000008271a7824ULL, 0x000fe200078e00ffULL, 0x0000000100057812ULL, 0x000fe400078e3cffULL,
0xfffffff81c297812ULL, 0x000fc400078ee229ULL, 0xfffffff81e397812ULL, 0x000fe200078ee239ULL,
0x00000008271d7824ULL, 0x000fe200078e0205ULL, 0xfffffff81a1b7812ULL, 0x000fe200078ee227ULL,
0x000010000f057824ULL, 0x000fe200078e00ffULL, 0x00000002001a7812ULL, 0x040fe400078e3cffULL,
0x00000003001c7812ULL, 0x040fe400078e3cffULL, 0x00000004001e7812ULL, 0x040fe200078e3cffULL,
0x00000008271f7824ULL, 0x000fe200078e021aULL, 0x0000000500207812ULL, 0x040fe200078e3cffULL,
0x00000004031a7824ULL, 0x000fe200078e00ffULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x0000000827237824ULL, 0x040fe200078e021eULL, 0x0000001c27217211ULL, 0x040fe200078e18ffULL,
0x0000000827257824ULL, 0x040fe200078e0220ULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000827277824ULL, 0x000fe200078e0200ULL, 0x00000007371c7812ULL, 0x000fe200078ec0ffULL,
0x0000080004007824ULL, 0x000fe200078e0205ULL, 0x000000464713723eULL, 0x000fe200000010ffULL,
0x00000008371e7824ULL, 0x000fe200078e00ffULL, 0x000000021c207812ULL, 0x000fe200078e3cffULL,
0x000000101d1d7824ULL, 0x100fe200078e0200ULL, 0x000000001b1b7211ULL, 0x080fe200078e20ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0xfffffff81e2b7812ULL, 0x000fe200078ee237ULL,
0x0000001021217824ULL, 0x000fe200078e0200ULL, 0x000000011c1e7812ULL, 0x040fe200078e3cffULL,
0x000000011b1b7824ULL, 0x000fe200078e021aULL, 0x000000031c227812ULL, 0x040fe200078e3cffULL,
0x00000008372f7824ULL, 0x040fe200078e0220ULL, 0x000000041c247812ULL, 0x040fe200078e3cffULL,
0x00000008372d7824ULL, 0x040fe200078e021eULL, 0x000000051c267812ULL, 0x040fe200078e3cffULL,
0x0000000837317824ULL, 0x040fe200078e0222ULL, 0x000000061c1c7812ULL, 0x000fe200078e3cffULL,
0x0000000837337824ULL, 0x040fe200078e0224ULL, 0x000000021b007388ULL, 0x0003e20000000800ULL,
0x0000000837357824ULL, 0x000fe200078e0226ULL, 0x0000000027277211ULL, 0x080fe200078e20ffULL,
0x0000001023237824ULL, 0x000fe200078e0200ULL, 0x0000000029297211ULL, 0x000fe200078e20ffULL,
0x0000000837377824ULL, 0x000fe200078e021cULL, 0x000000424314723eULL, 0x000fe200000010ffULL,
0x0000001025257824ULL, 0x000fe200078e0200ULL, 0x0000003e3f15723eULL, 0x000fe200000010ffULL,
0x000000011a1c7824ULL, 0x040fe200078e021fULL, 0x0000000037377211ULL, 0x000fe200078e20ffULL,
0x000000011a027824ULL, 0x042fe200078e021dULL, 0x0000003a3b16723eULL, 0x000fe200000010ffULL,
0x000000011a217824ULL, 0x000fc400078e0221ULL, 0x000000102b2b7824ULL, 0x100fe200078e0200ULL,
0x0000000702007388ULL, 0x0003e20000000800ULL, 0x000000102d2d7824ULL, 0x100fe400078e0200ULL,
0x000000011a1e7824ULL, 0x040fe200078e0223ULL, 0x0000000b1c007388ULL, 0x0005e20000000800ULL,
0x000000011a257824ULL, 0x040fe200078e0225ULL, 0x0000002d1a227210ULL, 0x040fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0200ULL, 0x0000000c21007388ULL, 0x000fe20000000800ULL,
0x000000011a277824ULL, 0x040fe200078e0227ULL, 0x000000ff00027306ULL, 0x002fe20000205400ULL,
0x000000011a207824ULL, 0x000fe200078e0229ULL, 0x0000000d1e007388ULL, 0x000fe20000000800ULL,
0x0000001031317824ULL, 0x000fc400078e0200ULL, 0x000000011a2b7824ULL, 0x040fe200078e022bULL,
0x0000000e25007388ULL, 0x000fe20000000800ULL, 0x0000001033337824ULL, 0x100fe200078e0200ULL,
0x000000ff00077306ULL, 0x000e620000209400ULL, 0x0000001035357824ULL, 0x100fe200078e0200ULL,
0x0000001027007388ULL, 0x000fe20000000800ULL, 0x000000011a2f7824ULL, 0x040fe400078e022fULL,
0x0000001039397824ULL, 0x000fe200078e0200ULL, 0x0000001120007388ULL, 0x000fe20000000800ULL,
0x000000011a247824ULL, 0x000fc400078e0231ULL, 0x000000011a337824ULL, 0x040fe200078e0233ULL,
0x000000122b007388ULL, 0x000fe20000000800ULL, 0x000000011a267824ULL, 0x040fe400078e0235ULL,
0x000000011a377824ULL, 0x040fe200078e0237ULL, 0x0000001322007388ULL, 0x000fe20000000800ULL,
0x000000011a287824ULL, 0x000fe200078e0239ULL, 0x000000020700720bULL, 0x002fe20003f1d000ULL,
0x00000001061a7824ULL, 0x000fe200078e0203ULL, 0x000000142f007388ULL, 0x000fe20000000800ULL,
0x000000ff00027245ULL, 0x000fc4000020d400ULL, 0x000000101a0b7824ULL, 0x004fe200078e0205ULL,
0x0000001524007388ULL, 0x000fe80000000800ULL, 0x0000001633007388ULL, 0x000fe60000000800ULL,
0x0000000102020812ULL, 0x000fe200078efcffULL, 0x0000001726007388ULL, 0x000fe60000000800ULL,
0x000000020207723eULL, 0x000fe200000010ffULL, 0x0000001837007388ULL, 0x000fe80000000800ULL,
0x0000001928007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000b107984ULL, 0x000e680000000c00ULL, 0x000400000b207984ULL, 0x000ea80000000c00ULL,
0x000800000b1c7984ULL, 0x000ee80000000c00ULL, 0x000c00000b2c7984ULL, 0x000f220000000c00ULL,
0x3f803f8007137831ULL, 0x002fc40000200013ULL, 0x3f803f8007127831ULL, 0x040fe40000200012ULL,
0x3f803f8007117831ULL, 0x040fe40000200011ULL, 0x3f803f8007107831ULL, 0x040fe40000200010ULL,
0x3f803f8007237831ULL, 0x044fe40000200023ULL, 0x3f803f8007227831ULL, 0x040fe40000200022ULL,
0x3f803f8007217831ULL, 0x000fc40000200021ULL, 0x3f803f8007207831ULL, 0x000fe20000200020ULL,
0x0000000100077802ULL, 0x000fe20000000f00ULL, 0x3f803f8013137831ULL, 0x008fe4000020001fULL,
0x3f803f8012127831ULL, 0x000fe2000020001eULL, 0x0000030007007a0cULL, 0x000fe20003f05270ULL,
0x3f803f8011117831ULL, 0x000fe4000020001dULL, 0x3f803f8010107831ULL, 0x000fe4000020001cULL,
0x3f803f8023237831ULL, 0x010fc4000020002fULL, 0x3f803f8022227831ULL, 0x000fe2000020002eULL,
0x000000100b007388ULL, 0x0003e20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe4000020002dULL,
0x3f803f8020207831ULL, 0x000fca000020002cULL, 0x000400200b007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000309000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7919ULL, 0x000ea20000002700ULL, 0x00005800ff0c7624ULL, 0x000fe200078e00ffULL,
0x0000000104ff7812ULL, 0x000fe2000780f867ULL, 0x00001000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x000003000c0c7a24ULL, 0x000fe200078e02ffULL,
0x000000401a1d7810ULL, 0x000fc40007ffe0ffULL, 0x000000000b107984ULL, 0x002e620000000c00ULL,
0x000066000c0e7a24ULL, 0x000fe200078e02ffULL, 0x000000ff0300720cULL, 0x000fe40000725670ULL,
0x000400000b147984ULL, 0x0007240000000c00ULL, 0x01ffffff0e0b7812ULL, 0x008fe200078ec0ffULL,
0x000058001e1e7a24ULL, 0x004fc800078e0207ULL, 0x000003001e077a24ULL, 0x000fc800078e02ffULL,
0x0000000107187824ULL, 0x000fe200078e020aULL, 0x00000fff0e0a7811ULL, 0x000fc800078e40ffULL,
0x000000180a0c7211ULL, 0x000fca00078fa0ffULL, 0x00006c000c0c7625ULL, 0x000fcc00078e000dULL,
0x000008000f0c7825ULL, 0x000fcc00078e000cULL, 0x000000101a1a7825ULL, 0x000fc800078e000cULL,
0x000000101d1c7825ULL, 0x000fe200078e000cULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x012fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011603ULL,
0x00000080ff0e7424ULL, 0x000fe400078e00ffULL, 0x0000000118197824ULL, 0x000fe200078e020bULL,
0x000000700c1f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d207812ULL, 0x000fe200078ec0ffULL,
0x00006c00180c7625ULL, 0x000fc800078e000eULL, 0x00006c0019187625ULL, 0x000fe200078e000eULL,
0x0000000c200c7210ULL, 0x000fc80007a1e01fULL, 0x0000001820187210ULL, 0x000fe40007c7e01fULL,
0x0000000dff0d7210ULL, 0x000fe400007e44ffULL, 0x00000019ff197210ULL, 0x000fc60001fe84ffULL,
0x000000080c007986ULL, 0x0003e8000c101906ULL, 0x0000000918007986ULL, 0x0003e4000c101906ULL,
0x000000101a007986ULL, 0x0123e2000c101d06ULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x000000141c007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000400097802ULL, 0x000fc80000000f00ULL, 0x000003000d0d7a10ULL, 0x000fe20007ffe1ffULL,
0x00006a001e087625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d080879a8ULL, 0x000ea400099ee1c6ULL,
0x0000000d0800720cULL, 0x004fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0c7807ULL, 0x000fca0000000000ULL, 0x0000000cff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff087984ULL, 0x000ee40000000000ULL, 0x000000ff0800720cULL, 0x008fda0003f05270ULL,
0x00002cc000008947ULL, 0x000fea0003800000ULL, 0x000000ff6700720cULL, 0x000fda0003f05270ULL,
0x00000d6000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000080ff117424ULL, 0x002fe200078e00ffULL,
0x00000001070c7810ULL, 0x004fe40007ffe0ffULL, 0x00000070081b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c090e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0007087625ULL, 0x000fc800078e0011ULL,
0x00006c000c0c7625ULL, 0x000fe200078e0011ULL, 0x000000080e087210ULL, 0x000fc8000791e01bULL,
0x0000000c0e0c7210ULL, 0x000fe40007b5e01bULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x0000000608087981ULL, 0x000368000c1e1900ULL,
0x000000060c137981ULL, 0x000362000c1e1900ULL, 0x00000300ff107624ULL, 0x000fca00078e00ffULL,
0x000000021000780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002070c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c0e0c7210ULL, 0x000fc8000791e01bULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c097981ULL, 0x000362000c1e1900ULL, 0x000000041000780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003070c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c0e0c7210ULL, 0x000fc8000791e01bULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c157981ULL, 0x000362000c1e1900ULL,
0x000000041000780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004070c7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000c0c7625ULL, 0x000fca00078e0011ULL,
0x0000000c0e0c7210ULL, 0x000fc8000791e01bULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c177981ULL, 0x000362000c1e1900ULL, 0x000000061000780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005070c7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c0e0c7210ULL, 0x000fc8000791e01bULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c197981ULL, 0x000362000c1e1900ULL,
0x000000061000780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081000780cULL, 0x002fe40003f06070ULL, 0x00000006070c7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000c0c7625ULL, 0x000fca00078e0011ULL, 0x0000000c0e0c7210ULL, 0x000fe40007a3e01bULL,
0x0000000707100810ULL, 0x000fe40007ffe0ffULL, 0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL,
0x00006c0010100625ULL, 0x000fca00078e0011ULL, 0x000000100e100210ULL, 0x000fe40007c7e01bULL,
0x000000060c1b7981ULL, 0x000364000c1e1900ULL, 0x00000011ff110210ULL, 0x000fcc0001fe84ffULL,
0x0000000610110981ULL, 0x000366000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x000000ffff0e7224ULL, 0x000fe400078e0007ULL,
0x000000ffff1d7224ULL, 0x020fe400078e0008ULL, 0x000000ffff167224ULL, 0x000fc600078e00ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000000116167810ULL, 0x000fc80007ffe0ffULL,
0x0000000416007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008140c7810ULL, 0x044fe40007ffe0ffULL, 0x00000001140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001d08087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000080e0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x00000080000d7802ULL, 0x000fe40000000f00ULL, 0x00000001ff127819ULL, 0x000fe40000011603ULL,
0x00000070101d7812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e01dULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c1d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000002140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000090e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x0000001003107824ULL, 0x000fe400078e00ffULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c12127812ULL, 0x000fe400078ec0ffULL, 0x0000007010137812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e013ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c137981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000003140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000908087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a0e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x0000001003097824ULL, 0x000fe400078e00ffULL,
0x00006c000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x0000007009097812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e009ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c097981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000004140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001508087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b0e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x0000001003107824ULL, 0x000fe400078e00ffULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c12127812ULL, 0x000fe400078ec0ffULL, 0x0000007010157812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e015ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c157981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000005140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001708087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c0e0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x00000080000d7802ULL, 0x000fe40000000f00ULL, 0x00000001ff127819ULL, 0x000fe40000011603ULL,
0x0000007010177812ULL, 0x000fe200078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e017ULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c177981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000006140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001908087209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d0e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x0000001003107824ULL, 0x000fe400078e00ffULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c12127812ULL, 0x000fe400078ec0ffULL, 0x0000007010197812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007b3e019ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c197981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e140c7810ULL, 0x042fe40007ffe0ffULL, 0x00000007140d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001b08087209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e0e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x0000001003107824ULL, 0x000fe400078e00ffULL,
0x00006c000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000c12127812ULL, 0x000fe400078ec0ffULL,
0x00000070101b7812ULL, 0x000fc800078ec0ffULL, 0x0000000c120c7210ULL, 0x000fc80007b3e01bULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c1b7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f140c7810ULL, 0x002fe40007ffe0ffULL,
0x0000001108087209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f0e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x0000001003107824ULL, 0x000fe400078e00ffULL, 0x00006c000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c12127812ULL, 0x000fe400078ec0ffULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000c120c7210ULL, 0x000fc80007a3e011ULL, 0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL,
0x000000060c117981ULL, 0x000368000c1e1900ULL, 0x0000000814147810ULL, 0x000fe40007ffe0ffULL,
0x000000080e0e7810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x0000000403097819ULL, 0x028fe400000006ffULL,
0x00000001ff0c7819ULL, 0x006fe40000011603ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e020cULL,
0x0000000809007388ULL, 0x0003e40000000800ULL, 0x0000001003087824ULL, 0x042fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x0000000104187824ULL, 0x000fe200078e0207ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000007008087812ULL, 0x000fe200078ec0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000c09097812ULL, 0x000fe200078ec0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000002ff0d7819ULL, 0x000fe20000011667ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000180a0c7211ULL, 0x004fe200078fa0ffULL, 0x00000001082b7824ULL, 0x000fe200078e0209ULL,
0x000000010d087812ULL, 0x000fe200078ec0ffULL, 0x00001000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000967677819ULL, 0x000fe200000006ffULL, 0x0000000204118824ULL, 0x140fe200078e020fULL,
0x0000006003157810ULL, 0x000fe20007ffe0ffULL, 0x0000000204138824ULL, 0x000fe200078e020fULL,
0x0000008000198802ULL, 0x000fe20000000f00ULL, 0x00006c000c0c7625ULL, 0x000fe200078e0009ULL,
0x0000080067097812ULL, 0x000fe200078ec0ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000030004007a0cULL, 0x040fe20003f26070ULL, 0x00000002111a8824ULL, 0x100fe200078e0208ULL,
0x0000002003117810ULL, 0x000fe20007ffe0ffULL, 0x00000002131c8824ULL, 0x000fe200078e0208ULL,
0x0000004003137810ULL, 0x000fe20007ffe0ffULL, 0x0000200004087824ULL, 0x000fe200078e0205ULL,
0x000000002b2b7984ULL, 0x000e620000000800ULL, 0x000008000f0c7825ULL, 0x000fe200078e000cULL,
0x00000000002c7805ULL, 0x000fc6000001ff00ULL, 0x000000010b168824ULL, 0x000fe400078e0218ULL,
0x00000080ff178424ULL, 0x000fe400078e00ffULL, 0x00000001080e7824ULL, 0x000fe400078e0209ULL,
0x00006c0016168625ULL, 0x000fc800078e0017ULL, 0x0000001011107825ULL, 0x000fc800078e000cULL,
0x0000001013127825ULL, 0x000fc800078e000cULL, 0x0000001015147825ULL, 0x000fc800078e000cULL,
0x00006c0018188625ULL, 0x000fc800078e0019ULL, 0x000000081a1a8824ULL, 0x000fe400078e0203ULL,
0x00000010031b7824ULL, 0x040fe400078e020eULL, 0x00000010030c7825ULL, 0x000fe200078e000cULL,
0x000045801a1f8811ULL, 0x000fc600078e20ffULL, 0x000000081c238824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c1b7faeULL, 0x0005e2000b901c46ULL,
0x0000001003168825ULL, 0x000fc600078e0016ULL, 0x0000418023238811ULL, 0x000fe200078e20ffULL,
0x00000010031c8825ULL, 0x000fe200078e0018ULL, 0x00380000101b7faeULL, 0x0007e2000b901c46ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00580000121b7faeULL, 0x0009e2000b901c46ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x00780000141b7faeULL, 0x0005e8000b901c46ULL, 0x00000000161f8faeULL, 0x000be2000b901c46ULL,
0x0000000000107805ULL, 0x008fc6000001ff00ULL, 0x000000001c238faeULL, 0x0007e2000b901c46ULL,
0x0000000000127805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001a7805ULL, 0x004fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x020fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x008fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000df000001947ULL, 0x000fea0003800000ULL, 0x00000de000007945ULL, 0x002fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e0004ULL,
0x0000000232307810ULL, 0x000fe20007ffe0ffULL, 0x0000000204347824ULL, 0x000fe200078e020fULL,
0x0000003200457202ULL, 0x000fe20000000f00ULL, 0x0000041000017945ULL, 0x000fe20003800000ULL,
0x0000030030007a0cULL, 0x000fe20003f06070ULL, 0x0000001003477824ULL, 0x000fe200078e00ffULL,
0x00000002ff2f7819ULL, 0x000fe20000011603ULL, 0x0000004045317824ULL, 0x000fc600078e00ffULL,
0x000000072f337812ULL, 0x040fe200078ec0ffULL, 0x000000082f2e7824ULL, 0x000fe200078e00ffULL,
0x0000008031317812ULL, 0x000fe200078ec0ffULL, 0x000000082f3e7824ULL, 0x040fe200078e00ffULL,
0x0000002fff327212ULL, 0x000fe200078e33ffULL, 0x000000082f357824ULL, 0x00afe200078e00ffULL,
0x000000012e407812ULL, 0x000fe200078ef633ULL, 0x0000010034437824ULL, 0x000fe200078e0031ULL,
0x000000022e427812ULL, 0x140fe400078ef633ULL, 0x000000032e447812ULL, 0x000fc400078ef633ULL,
0x000000042e467812ULL, 0x140fe400078ef633ULL, 0x000000052e487812ULL, 0x140fe400078ef633ULL,
0x000000062e4a7812ULL, 0x100fe400078ef633ULL, 0xfffffff83e3e7812ULL, 0x000fe400078ee233ULL,
0xfffffff835527812ULL, 0x000fe400078ee232ULL, 0x000000082f2e7810ULL, 0x000fe20007ffe0ffULL,
0x000002b000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x00001000ff337424ULL, 0x000fe200078e00ffULL, 0x00000001ff317819ULL, 0x000fc40000011630ULL,
0x00000030073c7210ULL, 0x000fe40007ffe0ffULL, 0x0000000131317812ULL, 0x000fe400078ec0ffULL,
0x0000003c0a327211ULL, 0x000fe400078fa0ffULL, 0x0000002003377810ULL, 0x040fe40007ffe0ffULL,
0x0000004003397810ULL, 0x040fe20007ffe0ffULL, 0x00000002044c8824ULL, 0x140fe200078e020fULL,
0x00000080003b8802ULL, 0x000fe20000000f00ULL, 0x0000000204348824ULL, 0x000fe200078e020fULL,
0x00000060033f7810ULL, 0x000fe20007ffe0ffULL, 0x000000024c4c8824ULL, 0x000fc400078e0231ULL,
0x00000002344e8824ULL, 0x000fe400078e0231ULL, 0x0000040030317824ULL, 0x000fe400078e00ffULL,
0x00006c0032327625ULL, 0x000fc600078e0033ULL, 0x0000080031317812ULL, 0x000fe200078ec0ffULL,
0x000000010b3a8824ULL, 0x000fe400078e023cULL, 0x000008000f327825ULL, 0x000fc800078e0032ULL,
0x0000000108347824ULL, 0x000fe400078e0231ULL, 0x00000080ff3d8424ULL, 0x000fe400078e00ffULL,
0x0000001003317824ULL, 0x040fe400078e0234ULL, 0x0000001003347825ULL, 0x000fc800078e0032ULL,
0x0000001037367825ULL, 0x100fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000034317faeULL, 0x0003e6000b901c46ULL, 0x0000001039387825ULL, 0x100fe200078e0032ULL,
0x0038000036317faeULL, 0x0003e6000b901c46ULL, 0x00006c003a3a8625ULL, 0x000fe200078e003bULL,
0x0058000038317faeULL, 0x0003e6000b901c46ULL, 0x000000103f327825ULL, 0x000fc800078e0032ULL,
0x00006c003c3c8625ULL, 0x000fe200078e003dULL, 0x0078000032317faeULL, 0x0003e6000b901c46ULL,
0x000000084c3f8824ULL, 0x100fe400078e0203ULL, 0x000000084e418824ULL, 0x000fe400078e0203ULL,
0x00000010033a8825ULL, 0x000fe200078e003aULL, 0x000045803f3f8811ULL, 0x000fe400078e20ffULL,
0x0000418041418811ULL, 0x000fe200078e20ffULL, 0x00000010033c8825ULL, 0x000fc400078e003cULL,
0x000000003a3f8faeULL, 0x0003e8000b901c46ULL, 0x000000003c418faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff347819ULL, 0x002fe20000011603ULL, 0x0000040045317824ULL, 0x000fe200078e00ffULL,
0x00000070474e7812ULL, 0x000fe200078ec0ffULL, 0x000000082e377824ULL, 0x000fe200078e00ffULL,
0x0000000c34357812ULL, 0x000fe400078ec0ffULL, 0x000000072e327812ULL, 0x000fc400078ec0ffULL,
0x0000004335437210ULL, 0x000fe20007ffe04eULL, 0x000000082e357824ULL, 0x040fe200078e00ffULL,
0x000000032e337819ULL, 0x000fe400000006ffULL, 0x0000080031317812ULL, 0x000fe400078ec0ffULL,
0xfffffff837347812ULL, 0x100fe400078ee232ULL, 0x0000000133367812ULL, 0x140fe400078ef632ULL,
0x0000000233387812ULL, 0x000fc400078ef632ULL, 0x00000003333a7812ULL, 0x140fe400078ef632ULL,
0x00000004333c7812ULL, 0x000fe200078ef632ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800043507984ULL, 0x000e620000000800ULL, 0x00000005334c7812ULL, 0x140fe400078ef632ULL,
0x0000000633327812ULL, 0x000fe200078ef632ULL, 0x0000000403337824ULL, 0x000fe200078e00ffULL,
0x0000002eff4e7212ULL, 0x000fe200078e33ffULL, 0x0045800043437984ULL, 0x000fe20000000800ULL,
0x0000018008317810ULL, 0x000fe40007ffe031ULL, 0xfffffff8354e7812ULL, 0x000fe400078ee24eULL,
0x0000000c33357812ULL, 0x000fe200078ec0ffULL, 0x000000103e3e7824ULL, 0x100fe200078e0231ULL,
0x0000003148487211ULL, 0x080fe200078e20ffULL, 0x0000001040407824ULL, 0x100fe200078e0231ULL,
0x0000003132337211ULL, 0x000fe200078e20ffULL, 0x0000001042427824ULL, 0x100fe200078e0231ULL,
0x0000004835487210ULL, 0x000fe20007ffe0ffULL, 0x000000103a3a7824ULL, 0x000fc400078e0231ULL,
0x000000104c4c7824ULL, 0x100fe400078e0231ULL, 0x0000001044447824ULL, 0x100fe200078e0231ULL,
0x0000000048487984ULL, 0x000ea20000000800ULL, 0x0000001046467824ULL, 0x100fe200078e0231ULL,
0x0000004c354c7210ULL, 0x000fe20007ffe0ffULL, 0x000000104a4a7824ULL, 0x100fe400078e0231ULL,
0x0000001034347824ULL, 0x100fe400078e0231ULL, 0x000000103c3c7824ULL, 0x100fe200078e0231ULL,
0x000000004c4c7984ULL, 0x000ee20000000800ULL, 0x000000104e4e7824ULL, 0x000fc400078e0231ULL,
0x0000001036367824ULL, 0x100fe400078e0231ULL, 0x0000001038387824ULL, 0x100fe400078e0231ULL,
0x00000001353e7824ULL, 0x000fe400078e023eULL, 0x0000001052327824ULL, 0x000fe200078e0231ULL,
0x000000502b507221ULL, 0x002fe20000010100ULL, 0x0000000135407824ULL, 0x040fe400078e0240ULL,
0x0000000135427824ULL, 0x040fe200078e0242ULL, 0x000000003e3e7984ULL, 0x000e620000000800ULL,
0x00000001353a7824ULL, 0x040fe200078e023aULL, 0x3fb8aa3b50507820ULL, 0x000fe20000410000ULL,
0x0000000135447824ULL, 0x040fe200078e0244ULL, 0x0000000040407984ULL, 0x000f220000000800ULL,
0x0000000135467824ULL, 0x000fc400078e0246ULL, 0x00000001354a7824ULL, 0x040fe200078e024aULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x0000000135347824ULL, 0x040fe200078e0234ULL,
0x0000005000507308ULL, 0x000ee20000000800ULL, 0x00000001353c7824ULL, 0x040fe200078e023cULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x00000001354e7824ULL, 0x040fe400078e024eULL,
0x0000000135367824ULL, 0x040fe200078e0236ULL, 0x0000000044447984ULL, 0x000f620000000800ULL,
0x0000000135387824ULL, 0x040fe200078e0238ULL, 0x00005410ff457816ULL, 0x004fe20000000048ULL,
0x0000000135337824ULL, 0x040fe200078e0233ULL, 0x0000000046467984ULL, 0x000ea20000000800ULL,
0x0000000135327824ULL, 0x000fe200078e0232ULL, 0x00007610ff477816ULL, 0x000fc40000000048ULL,
0x000000004a4a7984ULL, 0x000ea20000000800ULL, 0x0000004350357220ULL, 0x008fe20000410000ULL,
0x00005410ff527816ULL, 0x100fe4000000004cULL, 0x0000000034347984ULL, 0x000ee20000000800ULL,
0x00007610ff577816ULL, 0x000fe2000000004cULL, 0x0000002d352d7221ULL, 0x000fe40000010000ULL,
0x000000003c3c7984ULL, 0x000ee80000000800ULL, 0x000000004e4e7984ULL, 0x000ee80000000800ULL,
0x0000000032317984ULL, 0x000ae20000000800ULL, 0x00005410ff397816ULL, 0x002fc4000000003eULL,
0x00007610ff3b7816ULL, 0x000fe2000000003eULL, 0x0000000036367984ULL, 0x000e620000000800ULL,
0x00005410ff3e7816ULL, 0x110fe40000000040ULL, 0x00007610ff3d7816ULL, 0x000fe20000000040ULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000ffff327224ULL, 0x020fe200078e0030ULL,
0x00005410ff407816ULL, 0x100fe40000000042ULL, 0x0000000033337984ULL, 0x000f620000000800ULL,
0x00007610ff3f7816ULL, 0x000fc40000000042ULL, 0x00005410ff537816ULL, 0x100fe4000000003aULL,
0x00007610ff557816ULL, 0x000fe4000000003aULL, 0x00005410ff427816ULL, 0x100fe40000000044ULL,
0x00007610ff417816ULL, 0x000fe40000000044ULL, 0x00005410ff437816ULL, 0x004fe40000000046ULL,
0x00005410ff497816ULL, 0x000fc4000000004aULL, 0x0000030032007a0cULL, 0x000fe40003f06070ULL,
0x00005410ff4d7816ULL, 0x008fe40000000034ULL, 0x00007610ff467816ULL, 0x000fe40000000046ULL,
0x00005410ff3a7816ULL, 0x000fe4000000003cULL, 0x00007610ff4a7816ULL, 0x000fe4000000004aULL,
0x00005410ff547816ULL, 0x000fc4000000004eULL, 0x00007610ff347816ULL, 0x000fe40000000034ULL,
0x00005410ff447816ULL, 0x100fe40000000031ULL, 0x00007610ff4b7816ULL, 0x000fe40000000031ULL,
0x00005410ff4f7816ULL, 0x102fe40000000036ULL, 0x00007610ff517816ULL, 0x000fe40000000036ULL,
0x00005410ff487816ULL, 0x010fc40000000038ULL, 0x00007610ff507816ULL, 0x000fe40000000038ULL,
0x00007610ff3c7816ULL, 0x000fe4000000003cULL, 0x00005410ff597816ULL, 0x120fe40000000033ULL,
0x00007610ff4c7816ULL, 0x000fe40000000033ULL, 0x00007610ff4e7816ULL, 0x000fe2000000004eULL,
0x000062227f007947ULL, 0x000fea000b800000ULL, 0x00001f2f352f7589ULL, 0x0002a400000e0000ULL,
0x000062727f007947ULL, 0x000fea000b800000ULL, 0x00001f2e352e7589ULL, 0x00072400000e0000ULL,
0x0000002f392c7223ULL, 0x084fe2000001002cULL, 0x0000002f3b2a7223ULL, 0x080fe2000001002aULL,
0x0000002f3e297223ULL, 0x080fe20000010029ULL, 0x0000002f3d287223ULL, 0x080fe20000010028ULL,
0x0000002f40277223ULL, 0x080fe20000010027ULL, 0x0000002f3f267223ULL, 0x080fe20000010026ULL,
0x0000002f42257223ULL, 0x080fe20000010025ULL, 0x0000002f41247223ULL, 0x080fe20000010024ULL,
0x0000002f430c7223ULL, 0x080fe2000001000cULL, 0x0000002f46237223ULL, 0x080fe20000010023ULL,
0x0000002f45147223ULL, 0x080fe20000010014ULL, 0x0000002f47227223ULL, 0x080fe20000010022ULL,
0x0000002f490e7223ULL, 0x080fe2000001000eULL, 0x0000002f4a217223ULL, 0x080fe20000010021ULL,
0x0000002f440d7223ULL, 0x080fe2000001000dULL, 0x0000002f4b207223ULL, 0x000fe20000010020ULL,
0x0000002e4d107223ULL, 0x090fe20000010010ULL, 0x0000002e341f7223ULL, 0x080fe2000001001fULL,
0x0000002e4f187223ULL, 0x080fe20000010018ULL, 0x0000002e511e7223ULL, 0x080fe2000001001eULL,
0x0000002e48177223ULL, 0x080fe20000010017ULL, 0x0000002e501d7223ULL, 0x080fe2000001001dULL,
0x0000002e53167223ULL, 0x080fe20000010016ULL, 0x0000002e551c7223ULL, 0x080fe2000001001cULL,
0x0000002e3a157223ULL, 0x080fe20000010015ULL, 0x0000002e3c1b7223ULL, 0x080fe2000001001bULL,
0x0000002e52137223ULL, 0x080fe20000010013ULL, 0x0000002e571a7223ULL, 0x080fe2000001001aULL,
0x0000002e59127223ULL, 0x080fe20000010012ULL, 0x0000002e4c197223ULL, 0x080fe20000010019ULL,
0x0000002e54117223ULL, 0x080fe20000010011ULL, 0x0000002e4e097223ULL, 0x000fe20000010009ULL,
0xfffff25000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x0000001003077824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011603ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c03087812ULL, 0x000fca00078ec0ffULL,
0x00000001070a7824ULL, 0x000fe200078e0208ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003077824ULL, 0x002fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc80000011603ULL, 0x0000007007037812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fc600078ec0ffULL, 0x0000008004037824ULL, 0x000fca00078e0203ULL,
0x0000000308087210ULL, 0x000fca0007ffe0ffULL, 0x0049802d08007388ULL, 0x0003e40000000800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x004980000a037984ULL, 0x000ea80000000800ULL,
0x004a00000a087984ULL, 0x002e620000000800ULL, 0x00000003ff037221ULL, 0x004fc80000010000ULL,
0x0000000803037221ULL, 0x002fca0000010000ULL, 0x0180000003077810ULL, 0x000fc80007ffe0ffULL,
0x7f80000007077812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0700780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0003ULL, 0x0000a470002e7802ULL, 0x000fe40000000f00ULL,
0x0000632000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff077224ULL, 0x00efe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300087308ULL, 0x000e640000001000ULL,
0xbf80000003077423ULL, 0x002fc80000000008ULL, 0x800000ff07077221ULL, 0x000fc80000010100ULL,
0x0000000708077223ULL, 0x000fe40000000008ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000803307811ULL, 0x002fe200078ff0ffULL, 0x0000000106067824ULL, 0x100fe200078e0203ULL,
0x00000002ff2e7819ULL, 0x000fc60000011603ULL, 0x00001f3007087589ULL, 0x000e6200000e0000ULL,
0x0000000830357824ULL, 0x008fe400078e00ffULL, 0x000000082e2d7824ULL, 0x000fe200078e00ffULL,
0x00001f2e070b7589ULL, 0x000ea200000e0000ULL, 0x0000001006067824ULL, 0x000fe200078e0205ULL,
0x0000001d080a7220ULL, 0x042fe20000410000ULL, 0x0000001c081d7220ULL, 0x040fe20000410000ULL,
0x0000001008107220ULL, 0x040fe20000410000ULL, 0x0000001f081f7220ULL, 0x040fe20000410000ULL,
0x0000002c0b2c7220ULL, 0x044fe20000410000ULL, 0x0000002a0b2b7220ULL, 0x040fe20000410000ULL,
0x000000290b297220ULL, 0x040fe20000410000ULL, 0x000000280b287220ULL, 0x040fe20000410000ULL,
0x000000270b277220ULL, 0x040fe20000410000ULL, 0x000000260b267220ULL, 0x040fe20000410000ULL,
0x000000250b257220ULL, 0x040fe20000410000ULL, 0x000000240b247220ULL, 0x040fe20000410000ULL,
0x0000000c0b0c7220ULL, 0x040fe20000410000ULL, 0x000000230b237220ULL, 0x040fe20000410000ULL,
0x000000140b147220ULL, 0x040fe20000410000ULL, 0x000000220b077220ULL, 0x040fe20000410000ULL,
0x0000000e0b0e7220ULL, 0x040fe20000410000ULL, 0x000000210b217220ULL, 0x040fe20000410000ULL,
0x0000000d0b0d7220ULL, 0x040fe20000410000ULL, 0x000000200b207220ULL, 0x000fe20000410000ULL,
0x0000001808187220ULL, 0x040fe20000410000ULL, 0x0000001e080b7220ULL, 0x040fe20000410000ULL,
0x0000001708177220ULL, 0x040fe20000410000ULL, 0x0000001608167220ULL, 0x040fe20000410000ULL,
0x0000001508157220ULL, 0x040fe20000410000ULL, 0x0000001b081c7220ULL, 0x040fe20000410000ULL,
0x0000001308137220ULL, 0x040fe20000410000ULL, 0x0000001a081a7220ULL, 0x040fe20000410000ULL,
0x0000001208127220ULL, 0x040fe20000410000ULL, 0x0000001908197220ULL, 0x040fe20000410000ULL,
0x0000001108117220ULL, 0x040fe20000410000ULL, 0x0000000908087220ULL, 0x000fe20000410000ULL,
0x000000101f10723eULL, 0x000fe200000010ffULL, 0x000000082e097824ULL, 0x000fe200078e00ffULL,
0x000000170a0a723eULL, 0x000fc400000010ffULL, 0x000000110808723eULL, 0x000fe400000010ffULL,
0x000000072e117812ULL, 0x000fe400078ec0ffULL, 0x000000161d16723eULL, 0x000fe400000010ffULL,
0x000000121912723eULL, 0x000fe400000010ffULL, 0x0000000111177812ULL, 0x040fe400078e3cffULL,
0x0000000211197812ULL, 0x000fc400078e3cffULL, 0x00000003111b7812ULL, 0x040fe200078e3cffULL,
0x000000082e177824ULL, 0x040fe200078e0217ULL, 0x00000004111d7812ULL, 0x040fe400078e3cffULL,
0x00000005111f7812ULL, 0x040fe200078e3cffULL, 0x000000082e1b7824ULL, 0x040fe200078e021bULL,
0x0000000611117812ULL, 0x000fe200078e3cffULL, 0x000000082e1d7824ULL, 0x040fe200078e021dULL,
0x000000140707723eULL, 0x000fe200000010ffULL, 0x0000001017177824ULL, 0x000fe200078e0200ULL,
0x0000000e210e723eULL, 0x000fe200000010ffULL, 0x000000082e217824ULL, 0x000fe200078e0211ULL,
0x0000000730147812ULL, 0x000fe200078ec0ffULL, 0x0000000403117824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fe200078ee22eULL, 0x000000082e1f7824ULL, 0x000fe200078e021fULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0200ULL,
0x0000000c230c723eULL, 0x000fe200000010ffULL, 0x0000000830237824ULL, 0x000fe200078e00ffULL,
0x000000192e197211ULL, 0x000fe200078e18ffULL, 0x0000001009097824ULL, 0x100fe200078e0200ULL,
0x0000002eff227212ULL, 0x000fe200078e33ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0200ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000001019197824ULL, 0x100fe200078e0200ULL,
0x000000252424723eULL, 0x000fe200000010ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0200ULL,
0x0000000214277812ULL, 0x000fe200078e3cffULL, 0x0000001021217824ULL, 0x000fe200078e0200ULL,
0x00000030ff2a7212ULL, 0x000fc400078e33ffULL, 0x0000000114257812ULL, 0x000fe200078e3cffULL,
0x0000000830277824ULL, 0x000fe200078e0227ULL, 0x0000000314297812ULL, 0x040fe400078e3cffULL,
0x00000004142f7812ULL, 0x000fe200078e3cffULL, 0x0000000830257824ULL, 0x000fe200078e0225ULL,
0x0000000514317812ULL, 0x040fe400078e3cffULL, 0x0000000614337812ULL, 0x000fe200078e3cffULL,
0x00000008302f7824ULL, 0x040fe200078e022fULL, 0x0000000c11147812ULL, 0x000fe200078ec0ffULL,
0x0000000830317824ULL, 0x040fe200078e0231ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL,
0x0000000830337824ULL, 0x000fe200078e0233ULL, 0xfffffff835357812ULL, 0x000fe200078ee22aULL,
0x0000000114197824ULL, 0x040fe200078e0219ULL, 0x000000180b0b723eULL, 0x000fe200000010ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0200ULL, 0xfffffff823237812ULL, 0x000fe200078ee230ULL,
0x00000001141b7824ULL, 0x000fe200078e021bULL, 0x0000002930297211ULL, 0x000fe200078e18ffULL,
0x0000001035357824ULL, 0x100fe200078e0200ULL, 0x0000002c2b2b723eULL, 0x000fe200000010ffULL,
0x0000001023237824ULL, 0x100fe200078e0200ULL, 0x0000001409187210ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x100fe200078e0200ULL, 0x0000001714177210ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x100fe200078e0200ULL, 0x0000000027277211ULL, 0x000fe200078e20ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0200ULL, 0x0000002b18007388ULL, 0x000fe20000000800ULL,
0x0000001031317824ULL, 0x100fe200078e0200ULL, 0x000000131a13723eULL, 0x000fe200000010ffULL,
0x0000001033337824ULL, 0x000fe200078e0200ULL, 0x0000002817007388ULL, 0x000fe20000000800ULL,
0x00000001141d7824ULL, 0x000fe200078e021dULL, 0x0000000d200d723eULL, 0x000fe200000010ffULL,
0x0000000114007824ULL, 0x040fe200078e021fULL, 0x0000002619007388ULL, 0x000fe20000000800ULL,
0x0000000114217824ULL, 0x000fe200078e0221ULL, 0x000000151c15723eULL, 0x000fe200000010ffULL,
0x00000001141a7824ULL, 0x040fe200078e022dULL, 0x000000241b007388ULL, 0x000fe20000000800ULL,
0x0000000114237824ULL, 0x040fe200078e0223ULL, 0x0000002914297210ULL, 0x040fe20007ffe0ffULL,
0x00000001141c7824ULL, 0x040fe200078e0225ULL, 0x0000000c1d007388ULL, 0x0003e20000000800ULL,
0x0000000114277824ULL, 0x000fc400078e0227ULL, 0x00000001142a7824ULL, 0x040fe200078e022fULL,
0x0000000700007388ULL, 0x000fe20000000800ULL, 0x00000001142c7824ULL, 0x040fe400078e0231ULL,
0x0000000114337824ULL, 0x040fe200078e0233ULL, 0x0000000e21007388ULL, 0x000fe20000000800ULL,
0x0000000114357824ULL, 0x000fe200078e0235ULL, 0x00000002020c723eULL, 0x002fe400000010ffULL,
0x0000000d1a007388ULL, 0x000fe80000000800ULL, 0x0000001023007388ULL, 0x000fe80000000800ULL,
0x0000000b1c007388ULL, 0x000fe80000000800ULL, 0x0000000a27007388ULL, 0x000fe80000000800ULL,
0x0000001629007388ULL, 0x000fe80000000800ULL, 0x000000152a007388ULL, 0x000fe80000000800ULL,
0x000000132c007388ULL, 0x000fe80000000800ULL, 0x0000001233007388ULL, 0x000fe80000000800ULL,
0x0000000835007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000006187984ULL, 0x000e680000000c00ULL, 0x0004000006207984ULL, 0x000ea80000000c00ULL,
0x00080000061c7984ULL, 0x000ee80000000c00ULL, 0x000c000006247984ULL, 0x000f220000000c00ULL,
0x3f803f800c1b7831ULL, 0x002fc4000020001bULL, 0x3f803f800c1a7831ULL, 0x040fe4000020001aULL,
0x3f803f800c197831ULL, 0x040fe40000200019ULL, 0x3f803f800c187831ULL, 0x040fe40000200018ULL,
0x3f803f800c237831ULL, 0x044fe40000200023ULL, 0x3f803f800c227831ULL, 0x040fe40000200022ULL,
0x3f803f800c217831ULL, 0x000fc40000200021ULL, 0x3f803f800c207831ULL, 0x000fe40000200020ULL,
0x3f803f801b1b7831ULL, 0x008fe4000020001fULL, 0x3f803f801a1a7831ULL, 0x000fe4000020001eULL,
0x3f803f8019197831ULL, 0x000fe4000020001dULL, 0x3f803f8018187831ULL, 0x000fe4000020001cULL,
0x3f803f8023237831ULL, 0x010fc40000200027ULL, 0x3f803f8022227831ULL, 0x000fe20000200026ULL,
0x0000001806007388ULL, 0x0003e20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe40000200025ULL,
0x3f803f8020207831ULL, 0x000fca0000200024ULL, 0x0004002006007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x002e620000002600ULL,
0x00000040031d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x00000020031b7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x00000060031f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff027819ULL, 0x000fe20000011603ULL, 0x000000080f1a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fe2000001161dULL, 0x000000080f1c7824ULL, 0x040fe200078e00ffULL,
0x00000003ff0c7819ULL, 0x004fe2000001161bULL, 0x000000080f1e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0e7819ULL, 0x000fc4000001161fULL, 0x0000000702067812ULL, 0x000fe400078e4803ULL,
0x000000070d047812ULL, 0x000fe400078e481dULL, 0x0ffffff8060a7812ULL, 0x000fe400078ef803ULL,
0x0ffffff804067812ULL, 0x000fe400078ef81dULL, 0xfffffff81a217812ULL, 0x000fe200078ee203ULL,
0x0000001018077824ULL, 0x042fe200078e00ffULL, 0x0000000418237819ULL, 0x000fe200000006ffULL,
0x000000100a047824ULL, 0x100fe200078e0205ULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x0000001006107824ULL, 0x000fe200078e0205ULL, 0xfffffff007007812ULL, 0x000fe200078ee202ULL,
0x0000001018197824ULL, 0x000fe200078e00ffULL, 0x000000070c027812ULL, 0x000fe200078e481bULL,
0x00000010181a7824ULL, 0x000fe200078e00ffULL, 0x000000070e077812ULL, 0x000fe200078e481fULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x0ffffff802027812ULL, 0x000fc400078ef81bULL,
0x0ffffff807087812ULL, 0x000fe400078ef81fULL, 0x0000000502027211ULL, 0x000fe400078e20ffULL,
0x0000000400007c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001008147824ULL, 0x000fe200078e0205ULL,
0xfffffff0190c7812ULL, 0x000fe200078ee20cULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0xfffffff01a0d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0xfffffff0230e7812ULL, 0x000fe200078ee20eULL, 0x0000000002087984ULL, 0x0004e20000000c00ULL,
0xfffffff81c1b7812ULL, 0x000fc400078ee21bULL, 0x000000040d0f7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000014147984ULL, 0x000f220000000c00ULL, 0xfffffff81e1d7812ULL, 0x040fe400078ee21dULL,
0xfffffff81e1f7812ULL, 0x000fe200078ee21fULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00005a0000027a11ULL, 0x004fc800078040ffULL, 0x00005b0000037a11ULL, 0x000fe400000f4403ULL,
0x000000040c1c7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000040e007c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001021027825ULL, 0x000fe200078e0002ULL, 0x00005a000f0e7a11ULL, 0x000fc600078240ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005a001c0c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x00005a0000187a11ULL, 0x000fe400078440ffULL,
0x00005b001c0d7a11ULL, 0x000fe400000f440dULL, 0x00005b000f0f7a11ULL, 0x000fe400008f441aULL,
0x00005b0000197a11ULL, 0x000fe200010f4419ULL, 0x000000101b0c7825ULL, 0x000fc800078e000cULL,
0x000000101d0e7825ULL, 0x000fe200078e000eULL, 0x0000000402007986ULL, 0x002fe6000c101d06ULL,
0x000000101f187825ULL, 0x000fe200078e0018ULL, 0x000000080c007986ULL, 0x008fe8000c101d06ULL,
0x000000100e007986ULL, 0x000fe8000c101d06ULL, 0x0000001418007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe20000011667ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x01ffffff00007812ULL, 0x000fca00078ec0ffULL,
0x0000000269657824ULL, 0x000fca00078e0200ULL, 0x000000666500720cULL, 0x000fe40003f06070ULL,
0x0000000169057810ULL, 0x00afd60007ffe0ffULL, 0x0000000262028824ULL, 0x000fc800078e00ffULL,
0x0000640002028a24ULL, 0x000fc800078e0265ULL, 0x0000600002028625ULL, 0x000fca00078e0013ULL,
0x0000000602818981ULL, 0x000362000c1e1900ULL, 0x000000640500720cULL, 0x000fe20003f06070ULL,
0x000000800d007824ULL, 0x000fe200078e00ffULL, 0x0000000667637819ULL, 0x000fe200000006ffULL,
0x0000000704047899ULL, 0x000fc8000800063fULL, 0x0000010069097824ULL, 0x000fca00078e0263ULL,
0x0000004000047812ULL, 0x000fe200078ef809ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x002e620000000000ULL, 0x0000000481117c24ULL, 0x020fe2000f8e0204ULL,
0x0000000968067217ULL, 0x000fe20007800000ULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x0000100067137811ULL, 0x000fe400078e68ffULL, 0x0000000609107210ULL, 0x000fe40007ffe1ffULL,
0x00000002ff1d7819ULL, 0x102fe2000001160dULL, 0x000000100d1f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff127819ULL, 0x000fc4000001160dULL, 0x0000007f1d027812ULL, 0x040fe400078ec0ffULL,
0x000000101d237810ULL, 0x040fe40007ffe0ffULL, 0x000000081d0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111027824ULL, 0x000fe200078e0202ULL, 0x0000007f23087812ULL, 0x000fe400078ec0ffULL,
0x0000007f0f047812ULL, 0x000fe200078ec0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0021ULL,
0x000000301f1f7812ULL, 0x000fc400078ec0ffULL, 0x000000181d257810ULL, 0x000fe20007ffe0ffULL,
0x0000000111077824ULL, 0x040fe200078e0208ULL, 0x0000001f02087210ULL, 0x000fe20007f1e0ffULL,
0x0000000111047824ULL, 0x000fe200078e0204ULL, 0x0000007f25027812ULL, 0x000fe200078ec0ffULL,
0x00005e0007067625ULL, 0x080fe200078e0021ULL, 0x000000201d177810ULL, 0x000fe40007ffe0ffULL,
0x0000000312127812ULL, 0x000fe200078e480dULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x0000001f06067210ULL, 0x000fc40007f3e0ffULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x0000000111027824ULL, 0x000fe200078e0202ULL, 0x000000301d1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0603ULL, 0x0000001f040a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x0000007f17047812ULL, 0x000fe400078ec0ffULL,
0x000000102300720cULL, 0x080fe20003fa6070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000001f020c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000111047824ULL, 0x000fe200078e0204ULL,
0x0ffffffc12027812ULL, 0x000fe200078ef80dULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000100f00720cULL, 0x000fe20003f26070ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x0000001302157211ULL, 0x000fc400078e20ffULL, 0x000000101d00720cULL, 0x080fe20003f06070ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000007f19027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0603ULL, 0x0000001f040e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f047812ULL, 0x000fe200078ee212ULL,
0x0000000111027824ULL, 0x000fe200078e0202ULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e0605ULL, 0x000000102500720cULL, 0x080fe20003f86070ULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x000000101700720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008157faeULL, 0x0003e2000c101c46ULL,
0x000000101900720cULL, 0x080fe20003f46070ULL, 0x0000001004057824ULL, 0x000fe200078e0213ULL,
0x0000007f1b047812ULL, 0x000fe200078ec0ffULL, 0x0000000417177824ULL, 0x000fe200078e00ffULL,
0x0000000225257819ULL, 0x000fe200000006ffULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x000000000a057faeULL, 0x0005e2000c901c46ULL, 0x000000101b00720cULL, 0x0c0fe20003f26070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x000000101d00720cULL, 0x000fc40003f06070ULL,
0x0000001f02087210ULL, 0x002fe20007fde0ffULL, 0x0000000111027824ULL, 0x000fe200078e0204ULL,
0xfffffffc25107812ULL, 0x100fe400078ee212ULL, 0xfffffffc17147812ULL, 0x100fe200078ee212ULL,
0x000000ffff097224ULL, 0x000fe200030e0603ULL, 0xfffffffc19167812ULL, 0x100fe200078ee212ULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x0000007f1d0a7812ULL, 0x004fe400078ec0ffULL,
0xfffffffc1b187812ULL, 0x000fe200078ee212ULL, 0x000000041d1d7824ULL, 0x000fe200078e00ffULL,
0x0000001f02027210ULL, 0x000fe20007fde0ffULL, 0x0000000111047824ULL, 0x000fe200078e020aULL,
0xfffffffc230a7812ULL, 0x100fe200078ee212ULL, 0x0000001010117824ULL, 0x000fe200078e0213ULL,
0xfffffffc1d127812ULL, 0x000fe200078ee212ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x0000001314157211ULL, 0x000fc600078e20ffULL, 0x000000ffff037224ULL, 0x000fe200030e0603ULL,
0x0000001f04047210ULL, 0x000fe20007fde0ffULL, 0x000000100a0b7824ULL, 0x100fe400078e0213ULL,
0x0000001016177824ULL, 0x100fe400078e0213ULL, 0x0000001018197824ULL, 0x100fe200078e0213ULL,
0x00000000060b7faeULL, 0x0003e2000e901c46ULL, 0x0000001012137824ULL, 0x000fe400078e0213ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x000000000c117faeULL, 0x0003e8000e101c46ULL,
0x000000000e157faeULL, 0x0003e8000d901c46ULL, 0x0000000008177faeULL, 0x0003e8000d101c46ULL,
0x0000000002197faeULL, 0x0003e8000c901c46ULL, 0x0000000004137faeULL, 0x0003e2000c101c46ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x002e620000000000ULL,
0x0000000481047c24ULL, 0x020fc4000f8e0204ULL, 0x00000100ff107424ULL, 0x000fe200078e00ffULL,
0x00000002ff037819ULL, 0x102fe40000011602ULL, 0x00000003ff057819ULL, 0x000fe40000011602ULL,
0x0000007f03077812ULL, 0x040fe400078ec0ffULL, 0x0000000803067810ULL, 0x040fe40007ffe0ffULL,
0x0000001003087810ULL, 0x040fe40007ffe0ffULL, 0x00000020030c7810ULL, 0x000fc40007ffe0ffULL,
0x00000028030e7810ULL, 0x040fe40007ffe0ffULL, 0x0000003003127810ULL, 0x040fe40007ffe0ffULL,
0x0000003803147810ULL, 0x040fe40007ffe0ffULL, 0x00000018030a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000104037824ULL, 0x000fe200078e0207ULL, 0x0000007f06077812ULL, 0x040fe200078ec0ffULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x0000007f08097812ULL, 0x000fc400078ec0ffULL,
0x0000007f0c0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000104077824ULL, 0x000fe200078e0207ULL,
0x0000007f0e117812ULL, 0x000fe200078ec0ffULL, 0x00000001040b7824ULL, 0x000fe200078e0209ULL,
0x0000007f12137812ULL, 0x000fe200078ec0ffULL, 0x00000001040f7824ULL, 0x000fe200078e020fULL,
0x0000007f14157812ULL, 0x000fe200078ec0ffULL, 0x0000000104117824ULL, 0x000fe200078e0211ULL,
0x0000007f0a0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000104217824ULL, 0x040fe200078e0213ULL,
0x0000000305057812ULL, 0x100fe200078e4802ULL, 0x0000000104257824ULL, 0x040fe200078e0215ULL,
0x0000000d040d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001002047824ULL, 0x000fe200078e00ffULL,
0x0000100067097811ULL, 0x000fe200078e68ffULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc05027812ULL, 0x000fe200078ef802ULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x0000000208087819ULL, 0x000fe200000006ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x100fe200078ee205ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee205ULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee205ULL, 0x0000001002157824ULL, 0x000fe200078e0209ULL,
0xfffffffc0e0e7812ULL, 0x100fe200078ee205ULL, 0x00005e0003027625ULL, 0x000fe200078e0010ULL,
0xfffffffc12127812ULL, 0x000fc400078ee205ULL, 0xfffffffc14147812ULL, 0x000fe200078ee205ULL,
0x0000001006177824ULL, 0x000fe200078e0209ULL, 0xfffffffc08087812ULL, 0x000fe200078ee205ULL,
0x000000100a1b7824ULL, 0x100fe200078e0209ULL, 0x0000003004137812ULL, 0x000fe200078ec0ffULL,
0x000000100c1d7824ULL, 0x100fe200078e0209ULL, 0x0000000908197211ULL, 0x000fe200078e20ffULL,
0x000000100e1f7824ULL, 0x100fe200078e0209ULL, 0x0000001302027210ULL, 0x000fe20007f1e0ffULL,
0x0000001012237824ULL, 0x100fe400078e0209ULL, 0x0000001014277824ULL, 0x000fc400078e0209ULL,
0x00005e000d087625ULL, 0x000fc800078e0010ULL, 0x00005e0007047625ULL, 0x000fc800078e0010ULL,
0x00005e000b067625ULL, 0x000fe200078e0010ULL, 0x0000001304047210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001308087210ULL, 0x080fe20007f1e0ffULL,
0x00005e000f0a7625ULL, 0x080fe200078e0010ULL, 0x0000001306067210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002157faeULL, 0x0003e2000b901c46ULL,
0x00005e00110c7625ULL, 0x000fe200078e0010ULL, 0x00000007ff077210ULL, 0x000fc600017fe4ffULL,
0x00005e00210e7625ULL, 0x000fc800078e0010ULL, 0x00005e0025107625ULL, 0x000fe200078e0010ULL,
0x000000130e0e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x000000130a0a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x000000130c0c7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x0000001310107210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000004177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0d7224ULL, 0x000fe400008e060dULL,
0x000000ffff117224ULL, 0x000fe200018e0611ULL, 0x0000000006197faeULL, 0x0003e8000b901c46ULL,
0x00000000081b7faeULL, 0x0003e8000b901c46ULL, 0x000000000a1d7faeULL, 0x0003e8000b901c46ULL,
0x000000000c1f7faeULL, 0x0003e8000b901c46ULL, 0x000000000e237faeULL, 0x0003e8000b901c46ULL,
0x0000000010277faeULL, 0x0003e4000b901c46ULL, 0x01360400ff027984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000002ff7812ULL, 0x002fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000030000735dULL, 0x004fe40003800000ULL,
0x01360400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000646900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x0000640062627a24ULL, 0x000fe200078e02ffULL,
0xffffffff64617810ULL, 0x000fe20007ffe0ffULL, 0x0000001067037824ULL, 0x000fe200078e00ffULL,
0x00007610ff607816ULL, 0x000fe20000000060ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe4000800063fULL, 0x0000006369177211ULL, 0x008fe200078e40ffULL,
0x0000000000007946ULL, 0x000fe60003800000ULL, 0x000000176800720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000169057810ULL, 0x000fe20007ffe0ffULL,
0x00000b2000007945ULL, 0x000fe20003800000ULL, 0x00000100ff047424ULL, 0x000fe400078e00ffULL,
0x000000640500720cULL, 0x000fe40003f06070ULL, 0x0000004017057812ULL, 0x000fca00078ec0ffULL,
0x0000000100067824ULL, 0x000fcc00078e0205ULL, 0x000005b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x002fe20000011602ULL, 0x0000000481157c24ULL, 0x000fe2000f8e0206ULL,
0x00000003ff197819ULL, 0x000fe20000011602ULL, 0x0000000168147824ULL, 0x000fe200078e0a17ULL,
0x0000000805067810ULL, 0x040fe40007ffe0ffULL, 0x0000007f05077812ULL, 0x000fe400078ec0ffULL,
0x0000000219097212ULL, 0x000fe200078e3cffULL, 0x00000004060a7824ULL, 0x040fe200078e00ffULL,
0x0000007f06087812ULL, 0x000fe200078ec0ffULL, 0x00000001079f7824ULL, 0x000fe200078e0215ULL,
0x00000003028a7812ULL, 0x000fc400078ec0ffULL, 0x0000000309817812ULL, 0x000fe200078ec0ffULL,
0x00000001089d7824ULL, 0x000fe200078e0215ULL, 0x000000140500720cULL, 0x000fe20003f26070ULL,
0x00005e009f9e7625ULL, 0x000fe200078e0004ULL, 0x000000140600720cULL, 0x000fe40003f46070ULL,
0x0000200067167811ULL, 0x000fe200078e68ffULL, 0x00005e009d9c7625ULL, 0x000fe200078e0004ULL,
0x000000048a237812ULL, 0x000fe400078efcffULL, 0x0ffffffc81887812ULL, 0x000fc400078ef802ULL,
0xfffffffc0a877812ULL, 0x000fe200078ee281ULL, 0x0000001023107825ULL, 0x000fe200078e009eULL,
0x00000018050a7810ULL, 0x000fe40007ffe0ffULL, 0x00000016871b7211ULL, 0x000fe200078e20ffULL,
0x00000010880f7824ULL, 0x000fe200078e0216ULL, 0x0000001005097810ULL, 0x000fe20007ffe0ffULL,
0x0000001023127825ULL, 0x000fe200078e009cULL, 0x00000028050c7810ULL, 0x040fe40007ffe0ffULL,
0x00000020050b7810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0003e2000c901c46ULL, 0x00000030050d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000409867824ULL, 0x000fe200078e00ffULL, 0x00000038050e7810ULL, 0x000fe20007ffe0ffULL,
0x00000000121b7faeULL, 0x0005e2000d101c46ULL, 0x000000140900720cULL, 0x080fe20003f26070ULL,
0x000000040b847824ULL, 0x000fe200078e00ffULL, 0x000000140a00720cULL, 0x080fe20003f46070ULL,
0x000000040d827824ULL, 0x000fe200078e00ffULL, 0x000000140b00720cULL, 0x000fc40003f66070ULL,
0x000000140c00720cULL, 0x080fe20003f86070ULL, 0x000000040a107824ULL, 0x002fe200078e00ffULL,
0x0000007f090f7812ULL, 0x000fe400078ec0ffULL, 0x000000140d00720cULL, 0x080fe20003fa6070ULL,
0x000000040c127824ULL, 0x004fe200078e00ffULL, 0x000000140e00720cULL, 0x040fe20003fc6070ULL,
0x000000040e147824ULL, 0x000fe200078e00ffULL, 0xfffffffc10857812ULL, 0x000fe200078ee281ULL,
0x000000010f9b7824ULL, 0x000fe200078e0215ULL, 0x0000007f0a107812ULL, 0x000fc400078ec0ffULL,
0xfffffffc12837812ULL, 0x100fe200078ee281ULL, 0x00005e009b9a7625ULL, 0x000fe200078e0004ULL,
0x0000007f0b117812ULL, 0x000fe400078ec0ffULL, 0xfffffffc86867812ULL, 0x000fe200078ee281ULL,
0x0000000110997824ULL, 0x000fe200078e0215ULL, 0xfffffffc84847812ULL, 0x000fe200078ee281ULL,
0x0000000111977824ULL, 0x000fe200078e0215ULL, 0xfffffffc82827812ULL, 0x000fe200078ee281ULL,
0x00000010231a7825ULL, 0x000fe200078e009aULL, 0x0000007f0c127812ULL, 0x000fc400078ec0ffULL,
0xfffffffc14817812ULL, 0x000fe200078ee281ULL, 0x00005e0099987625ULL, 0x000fe200078e0004ULL,
0x0000007f0d137812ULL, 0x000fe400078ec0ffULL, 0x0000007f0e147812ULL, 0x000fe200078ec0ffULL,
0x0000000112957824ULL, 0x100fe200078e0215ULL, 0x00000016861d7211ULL, 0x080fe200078e20ffULL,
0x0000000113937824ULL, 0x100fe200078e0215ULL, 0x0000001683277211ULL, 0x000fe200078e20ffULL,
0x0000000114917824ULL, 0x000fe400078e0215ULL, 0x00005e0097967625ULL, 0x080fe200078e0004ULL,
0x000000001a1d7faeULL, 0x0003e6000c901c46ULL, 0x00005e0095947625ULL, 0x000fc800078e0004ULL,
0x00005e0093927625ULL, 0x000fc800078e0004ULL, 0x00005e0091907625ULL, 0x000fc800078e0004ULL,
0x0000001085157824ULL, 0x000fe400078e0216ULL, 0x00000010231a7825ULL, 0x002fc800078e0098ULL,
0x0000001084257824ULL, 0x000fe200078e0216ULL, 0x000000001a157faeULL, 0x0003e2000d101c46ULL,
0x00000010231c7825ULL, 0x000fc800078e0096ULL, 0x00000010231e7825ULL, 0x040fe200078e0094ULL,
0x000000001c257faeULL, 0x0003e6000d901c46ULL, 0x0000001082297824ULL, 0x000fe200078e0216ULL,
0x000000001e277faeULL, 0x0003e2000e101c46ULL, 0x0000001023207825ULL, 0x000fc800078e0092ULL,
0x00000010812b7824ULL, 0x000fe200078e0216ULL, 0x0000000020297faeULL, 0x0003e2000e901c46ULL,
0x0000001023227825ULL, 0x000fca00078e0090ULL, 0x00000000222b7faeULL, 0x0003e2000f101c46ULL,
0x0000051000007947ULL, 0x000fea0003800000ULL, 0x00000002ff057819ULL, 0x002fe20000011602ULL,
0x0000000481157c24ULL, 0x000fe2000f8e0206ULL, 0x00000003ff197819ULL, 0x000fe40000011602ULL,
0x0000000805067810ULL, 0x000fe40007ffe0ffULL, 0x0000000219087212ULL, 0x000fe400078e3cffULL,
0x00000018050a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000406107824ULL, 0x000fe200078e00ffULL,
0x0000001005097810ULL, 0x000fc40007ffe0ffULL, 0x0000007f05077812ULL, 0x000fe200078ec0ffULL,
0x000000040a127824ULL, 0x000fe200078e00ffULL, 0x0000000308817812ULL, 0x000fe200078ec0ffULL,
0x0000000409867824ULL, 0x000fe200078e00ffULL, 0x00000028050c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001079f7824ULL, 0x000fe200078e0215ULL, 0x0000007f06087812ULL, 0x000fe400078ec0ffULL,
0x0000007f090f7812ULL, 0x000fe200078ec0ffULL, 0x00005e009f9e7625ULL, 0x000fe200078e0004ULL,
0x00000020050b7810ULL, 0x000fc40007ffe0ffULL, 0x00000030050d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001089d7824ULL, 0x100fe200078e0215ULL, 0x000000020c147819ULL, 0x000fe200000006ffULL,
0x000000010f9b7824ULL, 0x000fe200078e0215ULL, 0xfffffffc10877812ULL, 0x000fe200078ee281ULL,
0x00005e009d9c7625ULL, 0x080fe200078e0004ULL, 0x00000003028a7812ULL, 0x000fe400078ec0ffULL,
0x00000038050e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e009b9a7625ULL, 0x000fe200078e0004ULL,
0x0000007f0a107812ULL, 0x000fc400078ec0ffULL, 0xfffffffc12857812ULL, 0x100fe200078ee281ULL,
0x000000040b847824ULL, 0x040fe200078e00ffULL, 0x0000007f0b117812ULL, 0x000fe200078ec0ffULL,
0x000000040d827824ULL, 0x000fe200078e00ffULL, 0x0000007f0c127812ULL, 0x000fe200078ec0ffULL,
0x000000040e187824ULL, 0x000fe200078e00ffULL, 0xfffffffc14837812ULL, 0x000fe200078ee281ULL,
0x0000000111977824ULL, 0x100fe200078e0215ULL, 0x0000007f0d137812ULL, 0x000fe200078ec0ffULL,
0x0000000112957824ULL, 0x000fe200078e0215ULL, 0x0000200067167811ULL, 0x000fe200078e68ffULL,
0x00005e0097967625ULL, 0x000fe200078e0004ULL, 0x000000048a237812ULL, 0x000fc400078efcffULL,
0x0ffffffc81887812ULL, 0x000fe200078ef802ULL, 0x0000000113937824ULL, 0x000fe200078e0215ULL,
0x0000007f0e147812ULL, 0x000fe200078ec0ffULL, 0x00000010231a7825ULL, 0x000fe200078e009eULL,
0x0000001510997210ULL, 0x000fe40007ffe0ffULL, 0xfffffffc86867812ULL, 0x100fe200078ee281ULL,
0x0000001088217824ULL, 0x100fe200078e0216ULL, 0xfffffffc84847812ULL, 0x000fe200078ee281ULL,
0x0000000114917824ULL, 0x000fe200078e0215ULL, 0xfffffffc82827812ULL, 0x100fe200078ee281ULL,
0x00005e0099987625ULL, 0x000fe200078e0004ULL, 0xfffffffc18817812ULL, 0x000fe200078ee281ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a217faeULL, 0x0003e2000b901c46ULL,
0x0000001682297211ULL, 0x000fe200078e20ffULL, 0x0000001087257824ULL, 0x000fc400078e0216ULL,
0x00000010231c7825ULL, 0x000fc800078e009cULL, 0x0000001086277824ULL, 0x000fe200078e0216ULL,
0x000000001c257faeULL, 0x0005e2000b901c46ULL, 0x00000010231e7825ULL, 0x000fc800078e009aULL,
0x00005e0095947625ULL, 0x080fe200078e0004ULL, 0x000000001e277faeULL, 0x0007e6000b901c46ULL,
0x00005e0093927625ULL, 0x000fc800078e0004ULL, 0x00005e0091907625ULL, 0x000fc800078e0004ULL,
0x0000001085157824ULL, 0x000fe400078e0216ULL, 0x00000010231a7825ULL, 0x002fc800078e0098ULL,
0x0000001084257824ULL, 0x004fe200078e0216ULL, 0x000000001a157faeULL, 0x0003e2000b901c46ULL,
0x00000010231c7825ULL, 0x000fc800078e0096ULL, 0x0000001083277824ULL, 0x008fe200078e0216ULL,
0x000000001c257faeULL, 0x0003e2000b901c46ULL, 0x00000010231e7825ULL, 0x000fc800078e0094ULL,
0x0000001023207825ULL, 0x000fe200078e0092ULL, 0x000000001e277faeULL, 0x0003e6000b901c46ULL,
0x00000010812b7824ULL, 0x000fe200078e0216ULL, 0x0000000020297faeULL, 0x0003e2000b901c46ULL,
0x0000001023227825ULL, 0x000fca00078e0090ULL, 0x00000000222b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000007021d7812ULL, 0x002fe400078ec0ffULL, 0x00000004ff157819ULL, 0x100fe40000011602ULL,
0x000000081d167812ULL, 0x000fc800078ef802ULL, 0x00000007151b7812ULL, 0x000fca00078e7816ULL,
0x00000010161b7824ULL, 0x000fc800078e021bULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000000815187824ULL, 0x000fe200078e00ffULL, 0x000000001b34783bULL, 0x000fe20000000200ULL,
0x00002000678b7824ULL, 0x000fe200078e00ffULL, 0x0000000215257810ULL, 0x000fe20007ffe0ffULL,
0x000008a000007945ULL, 0x000fe20003800000ULL, 0xfffffff818187812ULL, 0x000fe400078ee21dULL,
0x000010008b737810ULL, 0x000fe40007ffe0ffULL, 0x00000010181c7810ULL, 0x040fe20007ffe0ffULL,
0x00000004181d7824ULL, 0x040fe200078e00ffULL, 0x00000020181e7810ULL, 0x000fc40007ffe0ffULL,
0x0000003018207810ULL, 0x000fe20007ffe0ffULL, 0x000000041c1f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff1a7819ULL, 0x000fe40000011618ULL, 0x00000001ff187819ULL, 0x000fe2000001161cULL,
0x0000000420237824ULL, 0x000fe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fe4000001161eULL,
0x000000021e217819ULL, 0x000fe400000006ffULL, 0x00000001ff1e7819ULL, 0x000fc40000011620ULL,
0x000000031a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000000318187812ULL, 0x000fe400078ec0ffULL,
0x000000031c1c7812ULL, 0x000fe400078ec0ffULL, 0x000000031e1e7812ULL, 0x000fe400078ec0ffULL,
0x000000011a727812ULL, 0x100fe400078e7819ULL, 0x00000001184a7812ULL, 0x000fc400078e7819ULL,
0x000000011c707812ULL, 0x100fe400078e7819ULL, 0x000000011e487812ULL, 0x000fe400078e7819ULL,
0x0000001d72727212ULL, 0x000fe400078efcffULL, 0x0000001f4a4a7212ULL, 0x000fe400078efcffULL,
0x0000002170707212ULL, 0x000fe200078efcffULL, 0x0000001072897824ULL, 0x100fe200078e0273ULL,
0x0000002348487212ULL, 0x000fe200078efcffULL, 0x000000104a807824ULL, 0x100fe200078e0273ULL,
0x0000000119197812ULL, 0x000fe200078ec0ffULL, 0x00000010707f7824ULL, 0x100fe200078e0273ULL,
0x000000008940783bULL, 0x000e620000000200ULL, 0x00000010487e7824ULL, 0x000fe200078e0273ULL,
0x0000000725257812ULL, 0x000fc400078e7816ULL, 0x00000000803c783bULL, 0x000ea20000000200ULL,
0x00000002188e7812ULL, 0x100fe400078e1e19ULL, 0x000000021c6c7812ULL, 0x100fe200078e1e19ULL,
0x000000007f38783bULL, 0x000ee20000000200ULL, 0x000000021a6e7812ULL, 0x000fe200078e1e19ULL,
0x0000001016257824ULL, 0x000fe200078e0225ULL, 0x000000021e8c7812ULL, 0x000fe200078e1e19ULL,
0x000000007e44783bULL, 0x000f220000000200ULL, 0x0000001f8e8e7212ULL, 0x000fe200078efcffULL,
0x0000001025257824ULL, 0x000fe200078e00ffULL, 0x000000216c6c7212ULL, 0x000fc400078efcffULL,
0x0000001d6e6e7212ULL, 0x000fe200078efcffULL, 0x000000108e7c7824ULL, 0x100fe200078e0273ULL,
0x000000238c8c7212ULL, 0x000fe200078efcffULL, 0x000000106c7b7824ULL, 0x100fe200078e0273ULL,
0x000000736e7d7211ULL, 0x000fe200078e20ffULL, 0x000000002528783bULL, 0x0009e40000000200ULL,
0x000000108c6a7824ULL, 0x000fe400078e0273ULL, 0x000000007d58783bULL, 0x000f680000000200ULL,
0x000000007c18783bULL, 0x000f280000000200ULL, 0x000000007b20783bULL, 0x000f280000000200ULL,
0x000000006a30783bULL, 0x000f220000000200ULL, 0x00000040342c723cULL, 0x042ff000000418ffULL,
0x0000003c3454723cULL, 0x044ff000000418ffULL, 0x00000038341c723cULL, 0x048ff000000418ffULL,
0x000000423440723cULL, 0x040ff000000418ffULL, 0x0000003e343c723cULL, 0x040ff000000418ffULL,
0x0000003a3438723cULL, 0x040ff000000418ffULL, 0x000000443424723cULL, 0x050ff000000418ffULL,
0x000000463434723cULL, 0x000ff000000418ffULL, 0x00000058282c723cULL, 0x060ff0000004182cULL,
0x000000182854723cULL, 0x040ff00000041854ULL, 0x00000020281c723cULL, 0x040ff0000004181cULL,
0x0000005a2858723cULL, 0x040ff00000041840ULL, 0x0000001a2818723cULL, 0x040ff0000004183cULL,
0x000000222820723cULL, 0x040ff00000041838ULL, 0x000000302824723cULL, 0x040ff00000041824ULL,
0x000000322828723cULL, 0x000fe20000041834ULL, 0x0000026000008947ULL, 0x000fee0003800000ULL,
0x0000000168347824ULL, 0x000fe200078e0a17ULL, 0x000000088a3d7812ULL, 0x000fe200078efcffULL,
0x00000010887a7824ULL, 0x100fe200078e0273ULL, 0x0000007385777211ULL, 0x000fe200078e20ffULL,
0x0000001087797824ULL, 0x000fe200078e0273ULL, 0x000000340500720cULL, 0x080fe20003f46070ULL,
0x000000103d327825ULL, 0x000fe200078e009eULL, 0x000000340600720cULL, 0x000fc40003f66070ULL,
0x000000340900720cULL, 0x080fe20003f26070ULL, 0x000000103d307825ULL, 0x000fe200078e009cULL,
0x000000340c00720cULL, 0x080fe40003f86070ULL, 0x000000340d00720cULL, 0x080fe20003fa6070ULL,
0x0000001086787824ULL, 0x000fe200078e0273ULL, 0x000000340e00720cULL, 0x080fe20003fc6070ULL,
0x000000103d3a7825ULL, 0x040fe400078e009aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000327a7faeULL, 0x0003e2000d101c46ULL, 0x000000340a00720cULL, 0x000fe20003f46070ULL,
0x000000103d387825ULL, 0x000fc400078e0098ULL, 0x0000000030797faeULL, 0x0005e2000d901c46ULL,
0x000000340b00720cULL, 0x000fe20003f66070ULL, 0x0000001084767824ULL, 0x000fe400078e0273ULL,
0x000000103d367825ULL, 0x000fe200078e0096ULL, 0x000000003a787faeULL, 0x0007e6000c901c46ULL,
0x0000001083757824ULL, 0x000fe400078e0273ULL, 0x000000103d347825ULL, 0x040fe200078e0094ULL,
0x0000000038777faeULL, 0x0007e6000d101c46ULL, 0x0000001082747824ULL, 0x000fe200078e0273ULL,
0x0000000036767faeULL, 0x0007e2000d901c46ULL, 0x000000103d327825ULL, 0x002fc600078e0092ULL,
0x0000000034757faeULL, 0x0007e2000e101c46ULL, 0x0000001081737824ULL, 0x000fe400078e0273ULL,
0x000000103d307825ULL, 0x004fe200078e0090ULL, 0x0000000032747faeULL, 0x0007e8000e901c46ULL,
0x0000000030737faeULL, 0x0007e2000f101c46ULL, 0x000001c000007947ULL, 0x000fea0003800000ULL,
0x000000088a3d7812ULL, 0x000fe200078efcffULL, 0x00000010887a7824ULL, 0x100fe200078e0273ULL,
0x0000007385777211ULL, 0x000fe200078e20ffULL, 0x0000001087797824ULL, 0x000fc400078e0273ULL,
0x000000103d327825ULL, 0x000fc800078e009eULL, 0x000000103d307825ULL, 0x040fe200078e009cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000327a7faeULL, 0x0003e6000b901c46ULL,
0x0000001086787824ULL, 0x000fe200078e0273ULL, 0x0000000030797faeULL, 0x0005e2000b901c46ULL,
0x000000103d3a7825ULL, 0x000fc800078e009aULL, 0x000000103d387825ULL, 0x040fe200078e0098ULL,
0x000000003a787faeULL, 0x0007e6000b901c46ULL, 0x0000001084767824ULL, 0x000fe200078e0273ULL,
0x0000000038777faeULL, 0x0007e2000b901c46ULL, 0x000000103d367825ULL, 0x000fc800078e0096ULL,
0x0000001083757824ULL, 0x000fe200078e0273ULL, 0x0000000036767faeULL, 0x0007e2000b901c46ULL,
0x000000103d347825ULL, 0x000fc800078e0094ULL, 0x0000001082747824ULL, 0x000fe200078e0273ULL,
0x0000000034757faeULL, 0x0007e2000b901c46ULL, 0x000000103d327825ULL, 0x002fc800078e0092ULL,
0x0000001081737824ULL, 0x000fe200078e0273ULL, 0x0000000032747faeULL, 0x0007e2000b901c46ULL,
0x000000103d307825ULL, 0x004fca00078e0090ULL, 0x0000000030737faeULL, 0x0007e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000415317810ULL, 0x008fe20007ffe0ffULL, 0x000006f000007945ULL, 0x000fe20003800000ULL,
0x000020008b8b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000731317812ULL, 0x100fe400078e7816ULL,
0x0000008b4a717211ULL, 0x080fe200078e20ffULL, 0x0000001072727824ULL, 0x000fe200078e028bULL,
0x0000000615337810ULL, 0x000fe20007ffe0ffULL, 0x0000001016317824ULL, 0x000fe200078e0231ULL,
0x0000008b8c6b7211ULL, 0x000fe200078e20ffULL, 0x0000001070707824ULL, 0x000fe200078e028bULL,
0x0000000733337812ULL, 0x000fe200078e7816ULL, 0x0000001031317824ULL, 0x000fc400078e00ffULL,
0x00000010486f7824ULL, 0x000fe400078e028bULL, 0x0000001016337824ULL, 0x000fe400078e0233ULL,
0x000000106e6e7824ULL, 0x000fe400078e028bULL, 0x0000001033337824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000000725c783bULL, 0x000fe20000000200ULL,
0x000000108e6d7824ULL, 0x100fe400078e028bULL, 0x000000106c6c7824ULL, 0x000fe200078e028bULL,
0x000000003144783bULL, 0x000e680000000200ULL, 0x000000007150783bULL, 0x000ea80000000200ULL,
0x00000000704c783bULL, 0x000ee80000000200ULL, 0x000000006f48783bULL, 0x000f280000000200ULL,
0x000000006e40783bULL, 0x000fe80000000200ULL, 0x000000003330783bULL, 0x000f680000000200ULL,
0x000000006d3c783bULL, 0x000ee80000000200ULL, 0x000000006c38783bULL, 0x000ee80000000200ULL,
0x000000006b34783bULL, 0x000ee20000000200ULL, 0x0000005c442c723cULL, 0x042ff0000004182cULL,
0x0000005e4458723cULL, 0x040ff00000041858ULL, 0x000000504454723cULL, 0x044ff00000041854ULL,
0x000000524418723cULL, 0x040ff00000041818ULL, 0x0000004c441c723cULL, 0x048ff0000004181cULL,
0x0000004e4420723cULL, 0x040ff00000041820ULL, 0x000000484424723cULL, 0x050ff00000041824ULL,
0x0000004a4428723cULL, 0x000ff00000041828ULL, 0x00000040302c723cULL, 0x060ff0000004182cULL,
0x000000423058723cULL, 0x040ff00000041858ULL, 0x0000003c3054723cULL, 0x040ff00000041854ULL,
0x0000003e3018723cULL, 0x040ff00000041818ULL, 0x00000038301c723cULL, 0x040ff0000004181cULL,
0x0000003a3020723cULL, 0x040ff00000041820ULL, 0x000000343024723cULL, 0x040ff00000041824ULL,
0x000000363030723cULL, 0x000fe20000041828ULL, 0x0000026000008947ULL, 0x000fee0003800000ULL,
0x0000000168287824ULL, 0x000fe200078e0a17ULL, 0x0000000c8a297812ULL, 0x000fe200078efcffULL,
0x00000010882b7824ULL, 0x100fe200078e028bULL, 0x0000008b82397211ULL, 0x000fe200078e20ffULL,
0x0000001087877824ULL, 0x000fe200078e028bULL, 0x000000280500720cULL, 0x080fe20003f06070ULL,
0x00000010299e7825ULL, 0x000fe200078e009eULL, 0x000000280900720cULL, 0x000fc40003f26070ULL,
0x000000280a00720cULL, 0x080fe20003f46070ULL, 0x00000010299c7825ULL, 0x000fe200078e009cULL,
0x000000280b00720cULL, 0x080fe40003f66070ULL, 0x000000280c00720cULL, 0x080fe20003f86070ULL,
0x0000001086357824ULL, 0x000fe200078e028bULL, 0x000000280d00720cULL, 0x080fe20003fa6070ULL,
0x00000010299a7825ULL, 0x000fe200078e009aULL, 0x000000280e00720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000009e2b7faeULL, 0x0003e2000c101c46ULL,
0x000000280600720cULL, 0x000fe20003f06070ULL, 0x0000001085857824ULL, 0x000fc400078e028bULL,
0x0000001029987825ULL, 0x000fc800078e0098ULL, 0x0000001084377824ULL, 0x000fe400078e028bULL,
0x0000001029967825ULL, 0x000fc800078e0096ULL, 0x0000001083837824ULL, 0x000fe200078e028bULL,
0x000000009c877faeULL, 0x0003e2000c101c46ULL, 0x0000001029947825ULL, 0x000fc600078e0094ULL,
0x000000009a357faeULL, 0x0003e2000c901c46ULL, 0x0000001029927825ULL, 0x000fc600078e0092ULL,
0x0000000098857faeULL, 0x0003e2000d101c46ULL, 0x0000001081817824ULL, 0x000fe400078e028bULL,
0x0000001029907825ULL, 0x000fe200078e0090ULL, 0x0000000096377faeULL, 0x0003e8000d901c46ULL,
0x0000000094837faeULL, 0x0003e8000e101c46ULL, 0x0000000092397faeULL, 0x0003e8000e901c46ULL,
0x0000000090817faeULL, 0x0003e2000f101c46ULL, 0x000001c000007947ULL, 0x000fea0003800000ULL,
0x0000000c8a297812ULL, 0x000fe200078efcffULL, 0x00000010882b7824ULL, 0x100fe200078e028bULL,
0x0000008b82397211ULL, 0x000fe200078e20ffULL, 0x0000001087877824ULL, 0x000fc400078e028bULL,
0x00000010299e7825ULL, 0x000fc800078e009eULL, 0x00000010299c7825ULL, 0x040fe200078e009cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000009e2b7faeULL, 0x0003e6000b901c46ULL,
0x0000001086357824ULL, 0x000fe200078e028bULL, 0x000000009c877faeULL, 0x0003e2000b901c46ULL,
0x00000010299a7825ULL, 0x000fc800078e009aULL, 0x0000001085857824ULL, 0x000fe200078e028bULL,
0x000000009a357faeULL, 0x0003e2000b901c46ULL, 0x0000001029987825ULL, 0x000fc800078e0098ULL,
0x0000001084377824ULL, 0x000fe200078e028bULL, 0x0000000098857faeULL, 0x0003e2000b901c46ULL,
0x0000001029967825ULL, 0x000fc800078e0096ULL, 0x0000001083837824ULL, 0x000fe200078e028bULL,
0x0000000096377faeULL, 0x0003e2000b901c46ULL, 0x0000001029947825ULL, 0x000fc800078e0094ULL,
0x0000001029927825ULL, 0x000fe200078e0092ULL, 0x0000000094837faeULL, 0x0003e6000b901c46ULL,
0x0000001081817824ULL, 0x000fe200078e028bULL, 0x0000000092397faeULL, 0x0003e2000b901c46ULL,
0x0000001029907825ULL, 0x000fca00078e0090ULL, 0x0000000090817faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff287624ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff817424ULL, 0x002fe400078e00ffULL,
0x0000000228657824ULL, 0x000fe200078e0265ULL, 0x0000000815297810ULL, 0x000fc80007ffe0ffULL,
0x000000666500720cULL, 0x000fe40003f06070ULL, 0x0000000729297812ULL, 0x000fca00078e7816ULL,
0x0000001016297824ULL, 0x000fca00078e0229ULL, 0x0000000429487819ULL, 0x000fe200000006ffULL,
0x0000000262348824ULL, 0x000fe400078e0265ULL, 0x00000004ff358424ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600034348625ULL, 0x000fe200078e0035ULL,
0x000000008928783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x00000000805c783bULL, 0x000ea80000000200ULL, 0x000000007f50783bULL, 0x000ee80000000200ULL,
0x000000007e4c783bULL, 0x000f280000000200ULL, 0x0000000634818981ULL, 0x000362000c1e1900ULL,
0x0000088000007945ULL, 0x000fe60003800000ULL, 0x000000007d44783bULL, 0x000fe80000000200ULL,
0x000000007c40783bULL, 0x000fe20000000200ULL, 0x0000000a15357810ULL, 0x002fc60007ffe0ffULL,
0x000000007b3c783bULL, 0x000fe20000000200ULL, 0x0000000735357812ULL, 0x000fc600078e7816ULL,
0x000000006a38783bULL, 0x000fe40000000200ULL, 0x0000001016357824ULL, 0x000fc800078e0235ULL,
0x0000001035357824ULL, 0x000fe200078e00ffULL, 0x00000028482c723cULL, 0x040fea000004182cULL,
0x000000003534783bULL, 0x000e660000000200ULL, 0x0000002a4858723cULL, 0x040ff00000041858ULL,
0x0000005c4854723cULL, 0x044ff00000041854ULL, 0x0000005e4818723cULL, 0x040ff00000041818ULL,
0x00000050481c723cULL, 0x048ff0000004181cULL, 0x000000524820723cULL, 0x040ff00000041820ULL,
0x0000004c4824723cULL, 0x050ff00000041824ULL, 0x0000004e4830723cULL, 0x000ff00000041830ULL,
0x00000044342c723cULL, 0x042ff0000004182cULL, 0x000000463458723cULL, 0x040ff00000041858ULL,
0x000000403454723cULL, 0x040ff00000041854ULL, 0x000000423418723cULL, 0x040ff00000041818ULL,
0x0000003c341c723cULL, 0x040ff0000004181cULL, 0x0000003e3420723cULL, 0x040ff00000041820ULL,
0x000000383424723cULL, 0x040ff00000041824ULL, 0x0000003a3430723cULL, 0x000fee0000041830ULL,
0x0000030069347a10ULL, 0x000fc80007ffe0ffULL, 0x0000000134297810ULL, 0x040fe20007ffe0ffULL,
0x0000010034357824ULL, 0x000fc600078e0263ULL, 0x000000642900720cULL, 0x000fe40003f06070ULL,
0x0000004035297812ULL, 0x000fca00078ec0ffULL, 0x0000000100287824ULL, 0x000fcc00078e0229ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x0000000481297c24ULL, 0x020fe2000f8e0228ULL,
0x0000003568287217ULL, 0x000fe20007800000ULL, 0x00000010022a7824ULL, 0x000fe400078e00ffULL,
0x0000000107077824ULL, 0x000fe200078e0229ULL, 0x00000029082b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000128357824ULL, 0x000fe200078e0a35ULL, 0x000000302a417812ULL, 0x000fe200078ec0ffULL,
0x000000010f0f7824ULL, 0x100fe400078e0229ULL, 0x0000000110377824ULL, 0x100fe200078e0229ULL,
0x000000350900720cULL, 0x080fe20003f06070ULL, 0x0000000111397824ULL, 0x000fe200078e0229ULL,
0x000000350500720cULL, 0x080fe20003fa6070ULL, 0x00005e0007107625ULL, 0x000fe200078e0004ULL,
0x000000350600720cULL, 0x000fc40003f86070ULL, 0x000000350a00720cULL, 0x000fe20003f66070ULL,
0x00005e000f087625ULL, 0x000fe200078e0004ULL, 0x0000004110287210ULL, 0x000fc60007f3e0ffULL,
0x00005e002b067625ULL, 0x000fe200078e0004ULL, 0x0000004108367210ULL, 0x000fc60007f5e0ffULL,
0x00000001123b7824ULL, 0x100fe400078e0229ULL, 0x00000001133d7824ULL, 0x100fe400078e0229ULL,
0x00000001143f7824ULL, 0x000fe400078e0229ULL, 0x000000ffff297224ULL, 0x000fe200008e0611ULL,
0x00000041062a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0037107625ULL, 0x000fc600078e0004ULL,
0x00000007ff2b7210ULL, 0x000fe20000ffe4ffULL, 0x00005e0039127625ULL, 0x080fe200078e0004ULL,
0x00000041100a7210ULL, 0x080fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000287a7faeULL, 0x0003e4000e901c46ULL, 0x000000ffff377224ULL, 0x000fe200010e0609ULL,
0x0000004112107210ULL, 0x000fe20007f3e0ffULL, 0x00005e003d087625ULL, 0x080fe200078e0004ULL,
0x000000350b00720cULL, 0x080fe20003f46070ULL, 0x000000002a797faeULL, 0x0003e2000e101c46ULL,
0x000000350d00720cULL, 0x000fe20003f86070ULL, 0x00005e003b067625ULL, 0x080fe200078e0004ULL,
0x0000004108087210ULL, 0x080fe20007fbe0ffULL, 0x0000000036787faeULL, 0x0003e4000c101c46ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0611ULL, 0x0000004106067210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0613ULL, 0x000000350c00720cULL, 0x080fe20003f26070ULL,
0x00005e003f047625ULL, 0x000fe200078e0004ULL, 0x000000000a777faeULL, 0x0003e6000d901c46ULL,
0x000000ffff097224ULL, 0x000fe200028e0609ULL, 0x000000350e00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000004104047210ULL, 0x000fe20007fde0ffULL,
0x0000000010767faeULL, 0x0003e8000d101c46ULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0x0000000006757faeULL, 0x0003e8000c901c46ULL, 0x0000000008747faeULL, 0x0003e8000e101c46ULL,
0x0000000004737faeULL, 0x0003e2000e901c46ULL, 0x000002e000007947ULL, 0x000fea0003800000ULL,
0x0000000481287c24ULL, 0x020fe4000f8e0228ULL, 0x0000001002057824ULL, 0x000fc400078e00ffULL,
0x00000001100d7824ULL, 0x100fe200078e0228ULL, 0x0000002807077210ULL, 0x000fe20007ffe0ffULL,
0x0000000108097824ULL, 0x100fe200078e0228ULL, 0x0000003005057812ULL, 0x000fe200078ec0ffULL,
0x000000010f0b7824ULL, 0x000fe400078e0228ULL, 0x00005e0007067625ULL, 0x000fc800078e0004ULL,
0x00005e000d0c7625ULL, 0x000fe200078e0004ULL, 0x0000000506067210ULL, 0x000fc60007f1e0ffULL,
0x00005e0009087625ULL, 0x080fe200078e0004ULL, 0x00000007ff077210ULL, 0x000fe400007fe4ffULL,
0x000000050c0c7210ULL, 0x080fe20007f1e0ffULL, 0x00000001110f7824ULL, 0x100fe200078e0228ULL,
0x0000000508087210ULL, 0x080fe20007f3e0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000067a7faeULL, 0x0003e6000b901c46ULL,
0x0000000112117824ULL, 0x100fe200078e0228ULL, 0x000000050a0a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000113137824ULL, 0x000fc400078e0228ULL, 0x0000000114297824ULL, 0x000fe400078e0228ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0004ULL, 0x00005e0011107625ULL, 0x000fc800078e0004ULL,
0x00005e0013127625ULL, 0x000fc800078e0004ULL, 0x00005e0029287625ULL, 0x000fc800078e0004ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x000000050e047210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x00000005100e7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000512107210ULL, 0x080fe40007f5e0ffULL,
0x0000000528127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e060fULL,
0x0000000008797faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc400008e0611ULL,
0x000000ffff117224ULL, 0x000fe200010e0613ULL, 0x000000000a787faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fc600018e0629ULL, 0x000000000c777faeULL, 0x0003e8000b901c46ULL,
0x0000000004767faeULL, 0x0003e8000b901c46ULL, 0x000000000e757faeULL, 0x0003e8000b901c46ULL,
0x0000000010747faeULL, 0x0003e8000b901c46ULL, 0x0000000012737faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000c15057810ULL, 0x002fc40007ffe0ffULL, 0x0000000e15157810ULL, 0x000fe40007ffe0ffULL,
0x0000000705057812ULL, 0x100fe400078e7816ULL, 0x0000000715157812ULL, 0x000fe400078e7816ULL,
0x0000000516057211ULL, 0x000fc600078e20ffULL, 0x0000001016157824ULL, 0x000fe400078e0215ULL,
0x0000001005057824ULL, 0x000fe400078e00ffULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000007208783bULL, 0x000fe80000000200ULL,
0x000000000504783bULL, 0x000e680000000200ULL, 0x00000000710c783bULL, 0x000ea80000000200ULL,
0x000000007010783bULL, 0x000ee80000000200ULL, 0x000000006f38783bULL, 0x000f280000000200ULL,
0x000000001528783bULL, 0x000fe80000000200ULL, 0x000000006c44783bULL, 0x000fe80000000200ULL,
0x000000006e3c783bULL, 0x000fe80000000200ULL, 0x0136140003357984ULL, 0x000fe20000000800ULL,
0x000000080440723cULL, 0x042fe6000004182cULL, 0x000000006d2c783bULL, 0x000e6a0000000200ULL,
0x0000000a0458723cULL, 0x040fe20000041858ULL, 0x000000006b08783bULL, 0x000f6e0000000200ULL,
0x0000000c0454723cULL, 0x044ff00000041854ULL, 0x0000000e0418723cULL, 0x040ff00000041818ULL,
0x00000010040c723cULL, 0x048ff0000004181cULL, 0x000000380424723cULL, 0x050ff00000041824ULL,
0x0000003a0430723cULL, 0x040ff00000041830ULL, 0x000000120420723cULL, 0x000ff00000041820ULL,
0x0000002c2810723cULL, 0x042ff00000041854ULL, 0x00000044280c723cULL, 0x040ff0000004180cULL,
0x000000082804723cULL, 0x060ff00000041824ULL, 0x0000000a2808723cULL, 0x000fe20000041830ULL,
0x3db504f311257820ULL, 0x000fe20000410000ULL, 0x0000ffff60117812ULL, 0x000fe200078ec0ffULL,
0x3db504f310267820ULL, 0x000fca0000410000ULL, 0x0000003c2840723cULL, 0x000fe20000041840ULL,
0x3db504f30f107820ULL, 0x000fce0000410000ULL, 0x0000003e2858723cULL, 0x000fe20000041858ULL,
0x3db504f3041e7820ULL, 0x000fe20000410000ULL, 0x3db504f3051d7820ULL, 0x000fe20000410000ULL,
0x3db504f3060f7820ULL, 0x000fe20000410000ULL, 0x3db504f307157820ULL, 0x000fc80000410000ULL,
0x0000002e282c723cULL, 0x000fe20000041818ULL, 0x3db504f3081c7820ULL, 0x000fe20000410000ULL,
0x3db504f309087820ULL, 0x000fe20000410000ULL, 0x3db504f30a147820ULL, 0x000fc80000410000ULL,
0x3db504f3131a7820ULL, 0x000fe20000410000ULL, 0x000000462844723cULL, 0x000fe20000041820ULL,
0x3db504f312197820ULL, 0x000fe20000410000ULL, 0x3db504f30e137820ULL, 0x000fe20000410000ULL,
0x3db504f342427820ULL, 0x000fe20000410000ULL, 0x3db504f343437820ULL, 0x000fe20000410000ULL,
0x3db504f30b0e7820ULL, 0x000fe40000410000ULL, 0x3db504f30c227820ULL, 0x000fe20000410000ULL,
0x00008880110c7816ULL, 0x000fe200000000ffULL, 0x3db504f3402b7820ULL, 0x000fe20000410000ULL,
0x3db504f3412a7820ULL, 0x000fe20000410000ULL, 0x3db504f358297820ULL, 0x000fe20000410000ULL,
0x3db504f359277820ULL, 0x000fe20000410000ULL, 0x800000000c047824ULL, 0x000fe200078e00ffULL,
0x3db504f35a5a7820ULL, 0x000fe20000410000ULL, 0x3db504f35b187820ULL, 0x000fe20000410000ULL,
0x3db504f32c247820ULL, 0x000fe20000410000ULL, 0x3db504f32d237820ULL, 0x000fe20000410000ULL,
0x3db504f32e1b7820ULL, 0x000fe20000410000ULL, 0x3db504f32f127820ULL, 0x000fe20000410000ULL,
0x3db504f30d217820ULL, 0x000fe20000410000ULL, 0x8000000035ff7812ULL, 0x000fc60007804804ULL,
0x3db504f344207820ULL, 0x000fe20000410000ULL, 0x3db504f3451f7820ULL, 0x000fe20000410000ULL,
0x3db504f346117820ULL, 0x000fe20000410000ULL, 0x3db504f347167820ULL, 0x000fe20000410000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0042ULL, 0x000000ffff097224ULL, 0x000fe400078e0043ULL,
0x000000ffff0b7224ULL, 0x000fe200078e005aULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x0000001f0c0c7819ULL, 0x000fe200000006ffULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x0136140003057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc4000780480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004020c7824ULL, 0x000fe200078e00ffULL, 0x000000616900720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff00c047812ULL, 0x000fca00078ec0ffULL,
0x00000080670d7824ULL, 0x000fca00078e0204ULL, 0x013400000d047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202287824ULL, 0x000fe400078e00ffULL,
0x00000001682e7824ULL, 0x000fc600078e0a17ULL, 0x0000000628287812ULL, 0x000fc800078ec0ffULL,
0x0000000128177812ULL, 0x040fe400078efcffULL, 0x00000008282c7812ULL, 0x040fe400078efcffULL,
0x0000002e1700720cULL, 0x080fe40003f26070ULL, 0x0000001028177812ULL, 0x000fe400078efcffULL,
0x0000002e2c00720cULL, 0x080fe40003f06070ULL, 0x0000002e1700720cULL, 0x000fc40003fc6070ULL,
0x00000011282c7812ULL, 0x040fe400078efcffULL, 0x0000001828177812ULL, 0x040fe400078efcffULL,
0x0000002e2800720cULL, 0x080fe40003f46070ULL, 0x0000002e2c00720cULL, 0x080fe40003fa6070ULL,
0x0000002e1700720cULL, 0x000fe40003f66070ULL, 0x00000009282d7812ULL, 0x000fc400078efcffULL,
0x00000019282c7812ULL, 0x040fe400078efcffULL, 0x0000002028177812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL,
0xff7fffff09097808ULL, 0x000fe40004800000ULL, 0xff7fffff2a2a7808ULL, 0x000fc40004800000ULL,
0x0000002e2d00720cULL, 0x080fe40003f86070ULL, 0x0000002e2c00720cULL, 0x080fe40003f46070ULL,
0x0000002e1700720cULL, 0x000fe40003f26070ULL, 0x00000021282c7812ULL, 0x040fe400078efcffULL,
0x0000002828177812ULL, 0x000fe400078efcffULL, 0xff7fffff0b0b7808ULL, 0x000fc40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff18187808ULL, 0x000fe40006000000ULL,
0xff7fffff27277808ULL, 0x000fe40006000000ULL, 0x0000002e2c00720cULL, 0x080fe40003f06070ULL,
0x0000002e1700720cULL, 0x000fe40003f86070ULL, 0x00000029282c7812ULL, 0x000fc400078efcffULL,
0x0000003028177812ULL, 0x000fe400078efcffULL, 0xff7fffff19197808ULL, 0x000fe40007000000ULL,
0xff7fffff26267808ULL, 0x000fe40007000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff25257808ULL, 0x000fe40006800000ULL, 0x0000002e2c00720cULL, 0x000fc40003fc6070ULL,
0x0000002e1700720cULL, 0x000fe40003fa6070ULL, 0x00000031282c7812ULL, 0x040fe400078efcffULL,
0x0000003828177812ULL, 0x040fe400078efcffULL, 0x0000003928287812ULL, 0x000fe400078efcffULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff24247808ULL, 0x000fc40005800000ULL,
0xff7fffff12127808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff13137808ULL, 0x000fe40004800000ULL, 0xff7fffff22227808ULL, 0x000fe40004800000ULL,
0x0000002e2c00720cULL, 0x080fe40003f66070ULL, 0x0000002e1700720cULL, 0x000fc40003f46070ULL,
0x0000002e2800720cULL, 0x000fe40003f26070ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff21217808ULL, 0x000fe40004000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0xff7fffff20207808ULL, 0x000fe40006000000ULL, 0xff7fffff16167808ULL, 0x000fc40007000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL, 0xff7fffff15157808ULL, 0x000fe40005800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL, 0xff7fffff14147808ULL, 0x000fc40005000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL,
0xff7fffff08087808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002b04177209ULL, 0x004fe20007810000ULL, 0x0000001fff2f7424ULL, 0x000fe200078e00ffULL,
0x0000000a05287209ULL, 0x000fe20007810000ULL, 0xffffffffff327424ULL, 0x000fe200078e00ffULL,
0x0000002a17047209ULL, 0x000fe40007810000ULL, 0x0000000928287209ULL, 0x000fc40007810000ULL,
0x0000002904047209ULL, 0x000fe40007810000ULL, 0x0000000b28057209ULL, 0x000fe40007810000ULL,
0x0000002704177209ULL, 0x000fe40007810000ULL, 0x0000001805047209ULL, 0x000fe40007810000ULL,
0x0000002617287209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fc40007810000ULL,
0x0000002528177209ULL, 0x000fe40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000002417287209ULL, 0x000fe40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000002328177209ULL, 0x000fe40007810000ULL, 0x0000001205047209ULL, 0x000fc40007810000ULL,
0x0000002217287209ULL, 0x000fe40007810000ULL, 0x0000001304057209ULL, 0x000fe40007810000ULL,
0x0000002128177209ULL, 0x000fe40007810000ULL, 0x0000001005047209ULL, 0x000fe40007810000ULL,
0x0000002017287209ULL, 0x000fe40007810000ULL, 0x0000001104057209ULL, 0x000fc40007810000ULL,
0x0000001f28177209ULL, 0x000fe40007810000ULL, 0x0000001605047209ULL, 0x000fe40007810000ULL,
0x0000001e17287209ULL, 0x000fe40007810000ULL, 0x0000000f04047209ULL, 0x000fe40007810000ULL,
0x0000001d28057209ULL, 0x000fe40007810000ULL, 0x0000001504177209ULL, 0x000fc40007810000ULL,
0x0000001c05057209ULL, 0x000fe40007810000ULL, 0x0000001417177209ULL, 0x000fe40007810000ULL,
0x0000000805057209ULL, 0x000fe40007810000ULL, 0x0000000e17307209ULL, 0x000fe20007810000ULL,
0x00000ee27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x0000000405317209ULL, 0x008fe20007810000ULL, 0x00000f127f007947ULL, 0x000fea000b800000ULL,
0x0c401f0030047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x004ea800000e0000ULL,
0x0c401f0007287f89ULL, 0x000f2200000e0000ULL, 0x0000000430177209ULL, 0x008fc60007810000ULL,
0x0c201f0031047f89ULL, 0x000ee200000e0000ULL, 0x00000005062c7209ULL, 0x004fc60007810000ULL,
0x0c201f00172e7f89ULL, 0x002e6200000e0000ULL, 0x0000002807287209ULL, 0x010fc60007810000ULL,
0x0c201f002c2f7f89ULL, 0x000ea800000e0000ULL, 0x0c201f00282d7f89ULL, 0x00092200000e0000ULL,
0x0000000431047209ULL, 0x008fe40007810000ULL, 0x0000002e17057209ULL, 0x002fe40007810000ULL,
0x0000002f2c067209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05337820ULL, 0x000fe20000410000ULL, 0x3f80000000057882ULL, 0x000fc40000000000ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b18187823ULL, 0x000fe20000010833ULL, 0x3fb8aa3b27277823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b09097823ULL, 0x000fe20000010833ULL,
0x0000001f002e7308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010807ULL,
0x0000001e002f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b08077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010833ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b15157823ULL, 0x000fcc0000010833ULL, 0x0000002a002a7308ULL, 0x000e700000000800ULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x00000027002c7308ULL, 0x000ea20000000800ULL,
0x0000002b2a08723eULL, 0x002fce00000010ffULL, 0x0000000a001f7308ULL, 0x0005f00000000800ULL,
0x00000009001e7308ULL, 0x000e620000000800ULL, 0x000000292c0a723eULL, 0x004fce00000010ffULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000001800187308ULL, 0x000ea20000000800ULL,
0x0000001f1e09723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b121e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b131f7823ULL, 0x000fca0000010833ULL, 0x0000002000277308ULL, 0x0003f00000000800ULL,
0x0000002100177308ULL, 0x0007e20000000800ULL, 0x00000005ff207e24ULL, 0x002fe2000f8e00ffULL,
0x0000000b180b723eULL, 0x004fe200000010ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000087886ULL, 0x000fc400038e0100ULL, 0x3f8000002020783eULL, 0x000fe400000010ffULL,
0x0000001d00307308ULL, 0x0003e60000000800ULL, 0x000000ffff217224ULL, 0x008fca00078e0020ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b1d7823ULL, 0x002fce0000010833ULL,
0x0000002500257308ULL, 0x000e700000000800ULL, 0x0000001c00317308ULL, 0x000ff00000000800ULL,
0x0000000700327308ULL, 0x000ff00000000800ULL, 0x00000019001c7308ULL, 0x000ff00000000800ULL,
0x0000001a00077308ULL, 0x0004f00000000800ULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x000000200818723cULL, 0x004fee00000418ffULL, 0x0000001e001e7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b10217823ULL, 0x100fe20000010833ULL, 0x000000262510723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b11257823ULL, 0x100fe20000010833ULL, 0x0000001c0711723eULL, 0x008fe200000010ffULL,
0x000000ffff1c7224ULL, 0x100fe200078e0020ULL, 0x3fb8aa3b14077823ULL, 0x000fe20000010833ULL,
0xfffffffc02147812ULL, 0x000fe200078ec0ffULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000001d1e13723eULL, 0x004fe200000010ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e0020ULL, 0x000000272e1e723eULL, 0x000fca00000010ffULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x000000242312723eULL, 0x002fce00000010ffULL,
0x00000021002a7308ULL, 0x0002a20000000800ULL, 0x0000001c1018723cULL, 0x000fee0000041818ULL,
0x0000002200227308ULL, 0x000ee20000000800ULL, 0x000000ffff217224ULL, 0x002fce00078e0020ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000001f2a1d723eULL, 0x004fce00000010ffULL,
0x0000001600167308ULL, 0x000e620000000800ULL, 0x00000022171c723eULL, 0x008fce00000010ffULL,
0x0000000f000f7308ULL, 0x000fe20000000800ULL, 0x00000025161f723eULL, 0x002fce00000010ffULL,
0x0000001500247308ULL, 0x000e620000000800ULL, 0x000000313216723eULL, 0x000fe200000010ffULL,
0x000000ffff257224ULL, 0x000fe200078e0020ULL, 0x000000201c18723cULL, 0x000fea0000041818ULL,
0x0000000700077308ULL, 0x000fe40000000800ULL, 0x0000000fff217424ULL, 0x000fcc00078e00ffULL,
0x0000000e000e7308ULL, 0x000ea20000000800ULL, 0x0000000f2415723eULL, 0x002fe400000010ffULL,
0x0000001421217219ULL, 0x000fe400000006ffULL, 0x0000002f3014723eULL, 0x000fe400000010ffULL,
0x00000000212273a1ULL, 0x000e6200000e8000ULL, 0x00000000210573c4ULL, 0x000ee20000004000ULL,
0x0000002000247202ULL, 0x000fe40000000f00ULL, 0x000000070e17723eULL, 0x004fc400000010ffULL,
0x000000282d077209ULL, 0x010fca0007810000ULL, 0x000000241424723cULL, 0x000fe20000041818ULL,
0x0000000821ff7c12ULL, 0x002fda000f804022ULL, 0x000009f205008947ULL, 0x008ff4000b800000ULL,
0x001c1fff24187589ULL, 0x0002a400000e0000ULL, 0x00000000210e73a1ULL, 0x000ee200000e8000ULL,
0x00000000210573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x0000000821ff7c12ULL, 0x008fda000f80400eULL, 0x00000a1205008947ULL, 0x010fea000b800000ULL,
0x001c1fff26197589ULL, 0x00072800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x00066800000e0000ULL,
0x001c1fff001b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff0e7819ULL, 0x000fe40000011602ULL,
0x0000000c0c377812ULL, 0x002fc400078ec0ffULL, 0x000000070e0f7812ULL, 0x040fe200078ec0ffULL,
0x000000080e247824ULL, 0x040fe200078e00ffULL, 0x0000000eff227212ULL, 0x000fe200078e33ffULL,
0x000000080e207824ULL, 0x000fe200078e00ffULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080e2d7824ULL, 0x040fe200078e00ffULL, 0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff824217812ULL, 0x108fe400078ee20fULL, 0x0000000120237812ULL, 0x100fe200078ef60fULL,
0x000000080e417824ULL, 0x000fe200078e00ffULL, 0x0000000220257812ULL, 0x100fe200078ef60fULL,
0x000000080e317824ULL, 0x000fe200078e00ffULL, 0x0000000320277812ULL, 0x000fc400078ef60fULL,
0x0000000420297812ULL, 0x140fe400078ef60fULL, 0x00000005202b7812ULL, 0x140fe400078ef60fULL,
0x00000006200f7812ULL, 0x000fe400078ef60fULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee222ULL,
0x0000000eff227212ULL, 0x000fe400078e33ffULL, 0x000000070e207812ULL, 0x000fc400078ec0ffULL,
0x000000030e2f7819ULL, 0x000fe400000006ffULL, 0x00009000670e7811ULL, 0x000fe400078e58ffULL,
0xfffffff82f2f7812ULL, 0x100fe400078ee220ULL, 0x0000000131337812ULL, 0x000fe200078ef620ULL,
0x00000010210c7824ULL, 0x000fe200078e020eULL, 0x0000000231357812ULL, 0x000fe200078ef620ULL,
0x0000001027247824ULL, 0x000fe200078e020eULL, 0x0000000331397812ULL, 0x000fe200078ef620ULL,
0x0000001029267824ULL, 0x000fe200078e020eULL, 0x00000004313b7812ULL, 0x000fe200078ef620ULL,
0x000000102b287824ULL, 0x000fe200078e020eULL, 0x00000005313d7812ULL, 0x000fe200078ef620ULL,
0x000000102d2c7824ULL, 0x000fe200078e020eULL, 0x00000006313f7812ULL, 0x000fe200078ef620ULL,
0x0000001023207824ULL, 0x000fe200078e020eULL, 0xfffffff841417812ULL, 0x000fe200078ee222ULL,
0x0000001025227824ULL, 0x000fe200078e020eULL, 0x0000000e0f2a7211ULL, 0x080fe200078e20ffULL,
0x00000001370f7824ULL, 0x000fe200078e020cULL, 0x0000000e3d327211ULL, 0x000fe200078e20ffULL,
0x0000000137217824ULL, 0x040fe200078e0220ULL, 0x0000002a372b7210ULL, 0x040fe20007ffe0ffULL,
0x0000000137237824ULL, 0x040fe200078e0222ULL, 0x000000080f007388ULL, 0x0003e20000000800ULL,
0x0000000137257824ULL, 0x000fc400078e0224ULL, 0x000000102f0c7824ULL, 0x000fe200078e020eULL,
0x0000000a21007388ULL, 0x0007e20000000800ULL, 0x0000000137277824ULL, 0x000fe400078e0226ULL,
0x00000010332e7824ULL, 0x000fe200078e020eULL, 0x0000001023007388ULL, 0x0007e20000000800ULL,
0x0000000137297824ULL, 0x000fe400078e0228ULL, 0x00000010352f7824ULL, 0x100fe200078e020eULL,
0x0000001225007388ULL, 0x0007e20000000800ULL, 0x0000001039307824ULL, 0x000fc400078e020eULL,
0x00000001372d7824ULL, 0x000fe200078e022cULL, 0x0000001c27007388ULL, 0x0007e20000000800ULL,
0x000000103b317824ULL, 0x000fe400078e020eULL, 0x00000001370c7824ULL, 0x000fe200078e020cULL,
0x0000001e29007388ULL, 0x0007e20000000800ULL, 0x000000103f337824ULL, 0x100fe400078e020eULL,
0x0000001041357824ULL, 0x000fe200078e020eULL, 0x000000142b007388ULL, 0x0007e20000000800ULL,
0x00000001372e7824ULL, 0x040fe200078e022eULL, 0x0000003337207210ULL, 0x040fe20007ffe0ffULL,
0x00000001370e7824ULL, 0x040fe200078e022fULL, 0x000000162d007388ULL, 0x0007e20000000800ULL,
0x0000000137307824ULL, 0x000fc400078e0230ULL, 0x0000000137087824ULL, 0x042fe200078e0231ULL,
0x000000090c007388ULL, 0x0007e20000000800ULL, 0x0000000137327824ULL, 0x040fe400078e0232ULL,
0x0000000137227824ULL, 0x000fe200078e0235ULL, 0x0000000b2e007388ULL, 0x0007e80000000800ULL,
0x000000110e007388ULL, 0x0007e80000000800ULL, 0x0000001330007388ULL, 0x0007e80000000800ULL,
0x0000001d08007388ULL, 0x0007e80000000800ULL, 0x0000001f32007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001722007388ULL, 0x0007e80000000800ULL,
0x013000040d008388ULL, 0x0007e80000000c00ULL, 0x013200180d008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000643400720cULL, 0x000fe20003f26070ULL,
0x0136080003ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff60ff7812ULL, 0x000fe2000780c0ffULL,
0x000000ffff697224ULL, 0x000fc600078e0034ULL, 0x00000001ff607807ULL, 0x000fce0000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffbfd000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e002fULL,
0x000102a000307802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x000006a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x004fe200078e0033ULL, 0xffff9d8000007947ULL, 0x000fea000383ffffULL,
0x0000002e00367202ULL, 0x002fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe200078e00ffULL,
0x0001031000307802ULL, 0x000fe20000000f00ULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0033ULL,
0xffff9d3000007947ULL, 0x000fea000383ffffULL, 0x0000000500177202ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fe200078e00ffULL, 0x00010370002c7802ULL, 0x000fc40000000f00ULL,
0x0000059000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0017ULL,
0xfffff0d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0030ULL,
0x000103d0002c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x002fc400078e00ffULL,
0x0000053000007944ULL, 0x004fea0003c00000ULL, 0x0000001730307209ULL, 0x004fe20007810000ULL,
0x000000ffff177224ULL, 0x000fe200078e0006ULL, 0x00010420002c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x002fc400078e00ffULL, 0x000004e000007944ULL, 0x000fea0003c00000ULL,
0x0000001706067209ULL, 0x004fe20007810000ULL, 0x000000ffff177224ULL, 0x000fe200078e0007ULL,
0x00000002002e7802ULL, 0x002fc40000000f00ULL, 0x00010470002c7802ULL, 0x000fe40000000f00ULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000001707287209ULL, 0x004fe20007810000ULL,
0x000000ffff177224ULL, 0x000fe200078e0031ULL, 0x000104c0002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fe400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000001731047209ULL, 0x004fe20007810000ULL, 0x000000ffff177224ULL, 0x000fe200078e0030ULL,
0x00010510002c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x002fe400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000001730057209ULL, 0x004fe20007810000ULL,
0x000000ffff177224ULL, 0x000fe200078e0006ULL, 0x00010560002c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x002fe400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000001706067209ULL, 0x004fe20007810000ULL, 0x000000ffff177224ULL, 0x000fe200078e0028ULL,
0x00000001002e7802ULL, 0x002fc40000000f00ULL, 0x000105b0002c7802ULL, 0x000fe40000000f00ULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2d7224ULL, 0x004fe200078e0017ULL,
0xffffef8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0024ULL,
0x0001063000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fe400078e00ffULL,
0x00001c1fff377424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fe400078e0021ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0033ULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x002fe200078e0026ULL,
0x000000ff00367202ULL, 0x000fe20000000f00ULL, 0x00001c1fff377424ULL, 0x000fe200078e00ffULL,
0x000106b000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff387224ULL, 0x000fc400078e0021ULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff367224ULL, 0x002fe200078e00ffULL,
0x0001071000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff377424ULL, 0x000fc400078e00ffULL,
0x000000ffff387224ULL, 0x000fe400078e0021ULL, 0x000000ffff197224ULL, 0x004fe400078e0033ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff387224ULL, 0x002fe200078e0021ULL,
0x000000ff00367202ULL, 0x000fe20000000f00ULL, 0x00001c1fff377424ULL, 0x000fe200078e00ffULL,
0x0001077000307802ULL, 0x000fe20000000f00ULL, 0x000000ffff1a7224ULL, 0x004fe400078e0033ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0033ULL,
0xfffff4e000007947ULL, 0x000fea000383ffffULL, 0x0180000007037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f800000030b7812ULL, 0x000fc800078ec0ffULL,
0x018000000b00780cULL, 0x000fda0003f05070ULL, 0x0000000700038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0b00720cULL, 0x040fe40003f25070ULL,
0x008000000b00780cULL, 0x000fe40003f02070ULL, 0x00000001ff4c7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000034cff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007077812ULL, 0x002fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000034cff7212ULL, 0x000fda000780c0ffULL, 0x0080000007030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff2f7424ULL, 0x000fc800078e00ffULL, 0xfffef7002e007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0c00002e17177389ULL, 0x0002a200000e002fULL, 0xfffef6c02c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003800007348ULL, 0x000fe80003800000ULL,
0x0000003635337389ULL, 0x0002a200000e0037ULL, 0xfffef68030007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000013680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000790ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000808ULL, 0x0000000000000460ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c68ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000c88ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c98ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000cb8ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d28ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000d30ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000010a80ULL, 0xa200001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011980ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000011990ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000011990ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000011e10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000d28ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000010c58ULL, 0x0000000000010c58ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000011980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000011e10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_16_m_16_sm_86_cubin_len = 73456;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
