/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a7b8ULL, 0x000000000001a438ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x346a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4532336a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL,
0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL,
0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x000000676e696469ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x6e695f5f24000000ULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x722e006874617077ULL,
0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL, 0x616c65722e006168ULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x0000000000000061ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000000beULL, 0x0000000000000028ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0001000001c6ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b00010000020cULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000299ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000002e7ULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b000100000335ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000390ULL, 0x00000000000190e0ULL, 0x0000000000000220ULL,
0x0004000300000406ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000019300ULL, 0x000d000300000436ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000190e000000000ULL, 0x0001380400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL,
0x000190e000000000ULL, 0x0000022000000000ULL, 0x0000000000000000ULL, 0x0000001300082f04ULL,
0x00082304000000e1ULL, 0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL,
0x0000000000000011ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL,
0x000c17040021f000ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0xffffffff010c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000260010c2804ULL,
0x0000081000000300ULL, 0x00003390000023b0ULL, 0x0000350000003410ULL, 0x0000376000003630ULL,
0x00003c80000038a0ULL, 0x00003ca000003c90ULL, 0x000043e000003cb0ULL, 0x000052b000005240ULL,
0x000054f0000053c0ULL, 0x0000576000005620ULL, 0x000059f0000059e0ULL, 0x00005a1000005a00ULL,
0x00006ed000005fd0ULL, 0x0000705000006f40ULL, 0x000072b000007180ULL, 0x00007640000073f0ULL,
0x0000766000007650ULL, 0x00007bc000007670ULL, 0x00008b6000008ae0ULL, 0x00008d8000008c50ULL,
0x00008ff000008eb0ULL, 0x0000926000009250ULL, 0x0000928000009270ULL, 0x0000998000009970ULL,
0x000099a000009990ULL, 0x0000c7800000c5e0ULL, 0x0000c8000000c7c0ULL, 0x0000d1800000d150ULL,
0x0000d1c00000d190ULL, 0x000178b000017800ULL, 0x00017cc000017bb0ULL, 0x000181a0000180a0ULL,
0x00018580000184d0ULL, 0x0000053001f03904ULL, 0x0001e600000000ffULL, 0x0000061000040100ULL,
0x0001e60800000005ULL, 0x00000720003f0100ULL, 0x0001e68800000002ULL, 0x000011d0003f0100ULL,
0x0001e6000000001dULL, 0x00001370003f0107ULL, 0x0001e68800000000ULL, 0x00003120003f0101ULL,
0x0001e6080000000bULL, 0x00003140003f0101ULL, 0x0001e6080000000bULL, 0x000032b0003f0109ULL,
0x0001e6080000000bULL, 0x00004380003f0109ULL, 0x0001e68800000074ULL, 0x00005020003f0101ULL,
0x0001e62800000071ULL, 0x00005040003f0101ULL, 0x0001e62800000071ULL, 0x000051b0003f0109ULL,
0x0001e62800000071ULL, 0x00005ee0003f0109ULL, 0x0001e69000000070ULL, 0x00006cb0003f0101ULL,
0x0001e64800000029ULL, 0x00006cd0003f0101ULL, 0x0001e64800000029ULL, 0x00006e40003f0109ULL,
0x0001e64800000029ULL, 0x00007b40003f0109ULL, 0x0001e6980000006cULL, 0x000088c0003f0101ULL,
0x0001e6680000002bULL, 0x000088e0003f0101ULL, 0x0001e6680000002bULL, 0x00008a50003f0109ULL,
0x0001e6680000002bULL, 0x00009680003f0109ULL, 0x0001e6a000000000ULL, 0x0000ee50003f0101ULL,
0x0001e6000000001dULL, 0x00010760003f0101ULL, 0x0001e6000000001dULL, 0x00010920003f0109ULL,
0x0001e6000000001dULL, 0x00014c40003f0109ULL, 0x0001e68800000014ULL, 0x00015250003f0101ULL,
0x0001e68800000014ULL, 0x000153c0003f0109ULL, 0x0001e68800000014ULL, 0x00019080003f0109ULL,
0x0001e60800000012ULL, 0x00019090003f0101ULL, 0x0001e61000000012ULL, 0x000190a0003f0101ULL,
0x0001e61800000012ULL, 0x000190b0003f0101ULL, 0x0001e62000000012ULL, 0x00033803003f0101ULL,
0x0000dd8000301c04ULL, 0x0000e0700000ddb0ULL, 0x0000e4500000e260ULL, 0x0000e8300000e640ULL,
0x0000ec200000ea20ULL, 0x000109500000edd0ULL, 0x000c0504000190d0ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0068190300000000ULL, 0x0000001400080a04ULL, 0x0000000000680210ULL,
0x00000000000000bcULL, 0x0000001300000002ULL, 0x00000000000190e0ULL, 0x0000000000000044ULL,
0x0000001300000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001300000002ULL,
0x0000000000000000ULL, 0x000000000001e700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000297919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff157b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000129052836ULL, 0x008fe40000000000ULL, 0x0000000429062825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x0000000606062981ULL, 0x0004e8000c1e1900ULL,
0x0000000602092981ULL, 0x000ae2000c1e1900ULL, 0x0000001500007306ULL, 0x010f220000209000ULL,
0x00000300ff287b82ULL, 0x000ea20000000800ULL, 0x000000ff1500720cULL, 0x000fe20003f65070ULL,
0x00000000000b7919ULL, 0x000ea20000002300ULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x0000000000227919ULL, 0x000ea80000002600ULL, 0x00000400ff087b82ULL, 0x000f620000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00047836ULL, 0x010fcc0000000000ULL, 0x0000000400057305ULL, 0x0008a4000021f000ULL,
0x000000ff00047202ULL, 0x010fe20000000f00ULL, 0x000000ffff0a7224ULL, 0x006fc800078e0a05ULL,
0x000000150a077224ULL, 0x000fc800078e02ffULL, 0x0000000705057227ULL, 0x000fe400078e0004ULL,
0x0000000000077919ULL, 0x000e680000002100ULL, 0x0000000805057227ULL, 0x020fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a05ULL, 0x0000000015007224ULL, 0x000fe400078e0208ULL,
0x0000000000087919ULL, 0x000ea60000002200ULL, 0x000000150000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe400078e0a15ULL, 0x0000000105050836ULL, 0x000fe20000000000ULL,
0x00000005ff247819ULL, 0x002fe40000011607ULL, 0x000000150000720cULL, 0x000fc80003f26070ULL,
0x00001fff24247589ULL, 0x000e7200000e0000ULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00000015ff05b212ULL, 0x000fc800078e33ffULL, 0x0000000500007306ULL, 0x000f220000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00027836ULL, 0x010fe40000000000ULL, 0x000000040b007c24ULL, 0x004fe2000f8e0208ULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x000522000021f000ULL,
0x00001fff0b0b7589ULL, 0x000e6200000e0000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x0000000305047224ULL, 0x010fc800078e02ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a04ULL,
0x00008400ff04ab82ULL, 0x000e640000000800ULL, 0x0000000d03037227ULL, 0x000fc800078e0002ULL,
0x0000000400027c24ULL, 0x000fe4000f8e0207ULL, 0x0000002203267227ULL, 0x000fc600078e00ffULL,
0x0000007f0200780cULL, 0x000fe40003f64070ULL, 0x000000ff26037210ULL, 0x000fca0007ffe1ffULL,
0x0000000305007224ULL, 0x000fca00078e0222ULL, 0x000000050000720cULL, 0x000fe20003f06070ULL,
0x00000000000db919ULL, 0x000ea20000008800ULL, 0x000004000008b802ULL, 0x000fe20000000f00ULL,
0xff317217ff07b424ULL, 0x000fd400078e00ffULL, 0x0000000100000824ULL, 0x000fe400078e0a05ULL,
0x0000000126260836ULL, 0x000fe20000000000ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x000000050000720cULL, 0x000fda0003f26070ULL, 0x0000000126261810ULL, 0x000fe40007ffe0ffULL,
0x00000005ff26c212ULL, 0x000fe400078e33ffULL, 0x000006540d0db816ULL, 0x004fe40000000008ULL,
0x0000000f0200780cULL, 0x040fe20003f24070ULL, 0x000000ffff007224ULL, 0x000fe200078e0a26ULL,
0x000000030200780cULL, 0x000fc60003f84070ULL, 0x0000000005227224ULL, 0x000fe400078e0222ULL,
0x000000040200b824ULL, 0x000fe400078e020dULL, 0x0000000109032824ULL, 0x008fcc00078e0a06ULL,
0x00008400ff03ab82ULL, 0x000ee20000000800ULL, 0x0000000000240947ULL, 0x002fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01e60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402057c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01e60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01e68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000522227819ULL, 0x000fe200000006ffULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000217919ULL, 0x000e620000002500ULL, 0x0000000403057c24ULL, 0x008fe4000f8e02ffULL,
0x000000ffff207224ULL, 0x000fe200078e0a22ULL, 0x01e400070000b388ULL, 0x0005e20000000800ULL,
0x000000042906a224ULL, 0x000fe200078e02ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000220500720cULL, 0x000fe20003f06070ULL, 0x0000000415137c24ULL, 0x000fe2000f8e02ffULL,
0x0000002005207446ULL, 0x000fe20003800020ULL, 0x000000040b007824ULL, 0x004fc400078e0224ULL,
0x00000013061f7224ULL, 0x000fe200078e02ffULL, 0x000000ff20207207ULL, 0x000fe20000000000ULL,
0x0000000400077824ULL, 0x000fe400078e00ffULL, 0x00000004260e7c24ULL, 0x000fe2000f8e021fULL,
0x000000202000780cULL, 0x000fda0003f05270ULL, 0x00000004002c8947ULL, 0x002fea0003800000ULL,
0x0000000400007d06ULL, 0x000e620008209000ULL, 0x00000000001e7919ULL, 0x000ea20000000000ULL,
0x00000400001d7802ULL, 0x000fe20000000f00ULL, 0x0000000000107919ULL, 0x000eea0000008800ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00047810ULL, 0x002fc40007ffe0ffULL,
0x00000004ff027819ULL, 0x004fc8000001161eULL, 0x0000000400057305ULL, 0x0002a2000021f000ULL,
0x00000654101d7816ULL, 0x008fe2000000001dULL, 0x0000000202087836ULL, 0x000fe40000000000ULL,
0x00000001070f7824ULL, 0x000fe400078e0202ULL, 0x000000ffff047224ULL, 0x002fe200078e00ffULL,
0x0000000807117210ULL, 0x000fe20007ffe0ffULL, 0x0000000122007824ULL, 0x000fe400078e020fULL,
0x000000ffff097224ULL, 0x004fc400078e0a05ULL, 0x00000001220a7824ULL, 0x000fe400078e0211ULL,
0x0000000409097c24ULL, 0x000fc8000f8e02ffULL, 0x0000000905057227ULL, 0x000fcc00078e0004ULL,
0x0000000005047227ULL, 0x000fc800078e00ffULL, 0x0000000a050c7227ULL, 0x000fe200078e00ffULL,
0x000000ff04057210ULL, 0x000fc60007ffe1ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a0cULL,
0x0000000405057c24ULL, 0x000fe4000f8e0200ULL, 0x0000000409097c24ULL, 0x000fc6000f8e020aULL,
0x0000000405007c0cULL, 0x000fe4000bf06070ULL, 0x0000000409007c0cULL, 0x000fd6000bf46070ULL,
0x8000000405050c36ULL, 0x000fe20008000000ULL, 0x0000000104040810ULL, 0x000fe20007ffe0ffULL,
0x8000000409092c36ULL, 0x000fe20008000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bf05070ULL,
0x000000010c0c2836ULL, 0x000fe20000000000ULL, 0x0000000405007c0cULL, 0x000fe4000bf26070ULL,
0x0000000409007c0cULL, 0x000fe4000bf66070ULL, 0x00000004ff057c12ULL, 0x000fd2000f8e33ffULL,
0x0000000104041836ULL, 0x000fe40000000000ULL, 0x000000010c0c3836ULL, 0x000fc60000000000ULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000c050c7207ULL, 0x000fe40004000000ULL,
0x000000ff04057210ULL, 0x000fc60007ffe1ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a0cULL,
0x0000000405057c24ULL, 0x000fe2000f8e0200ULL, 0x0000000720007248ULL, 0x000fe20007fe0000ULL,
0x00000004090a7c24ULL, 0x000fe2000f8e020aULL, 0x00008c0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000010e057824ULL, 0x000fe400078e0205ULL, 0x0000000100007824ULL, 0x000fe200078e0a07ULL,
0x0000000a0e097210ULL, 0x000fe20007ffe0ffULL, 0x0000001304057224ULL, 0x000fc400078e0205ULL,
0x000000101e077824ULL, 0x000fe200078e00ffULL, 0x000000000800720cULL, 0x080fe20003f26070ULL,
0x000000130c097224ULL, 0x000fe200078e0209ULL, 0x000000000200720cULL, 0x000fe20003f06070ULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f0070d7812ULL, 0x000fe400078ec0ffULL,
0x0000001e11027210ULL, 0x000fe20007ffe0ffULL, 0x0000010009087825ULL, 0x000fe200078e00ffULL,
0x0000000d04047212ULL, 0x000fc600078efcffULL, 0x000000010f007824ULL, 0x040fe200078e021eULL,
0x0000000d08087212ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000404047c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x0000000408087c10ULL, 0x000fe4000ff7e0ffULL, 0xfffffff00f007812ULL, 0x000fe400078ee200ULL,
0xfffffff011027812ULL, 0x000fe400078ee202ULL, 0x0000000505057c10ULL, 0x000fe200097fe4ffULL,
0x00000010000d7824ULL, 0x100fe200078e021dULL, 0x0000000509097c10ULL, 0x000fe20009ffe4ffULL,
0x00000010020f7824ULL, 0x000fc600078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e8000c101c46ULL, 0x00000000080f7faeULL, 0x0003e2000c901c46ULL,
0x0000000400107947ULL, 0x000fea0003800000ULL, 0x0000000400007d06ULL, 0x000e620008209000ULL,
0x00000000001e7919ULL, 0x000ea20000000000ULL, 0x00000400001d7802ULL, 0x000fe20000000f00ULL,
0x00000000000a7919ULL, 0x000eea0000008800ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00047810ULL, 0x002fc40007ffe0ffULL, 0x000000071e0d7211ULL, 0x004fc800078fe0ffULL,
0x0000000400057305ULL, 0x0002a2000021f000ULL, 0x0000000d22007210ULL, 0x000fe20007ffe0ffULL,
0x000000020d0f7836ULL, 0x000fe20000000000ULL, 0x000006540a1d7816ULL, 0x008fe2000000001dULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff027224ULL, 0x004fc800078e0a05ULL,
0x0000000402077c24ULL, 0x000fc8000f8e02ffULL, 0x0000000705077227ULL, 0x000fc800078e0004ULL,
0x0000000122057824ULL, 0x000fe400078e020fULL, 0x0000000007027227ULL, 0x000fc800078e00ffULL,
0x0000000507077227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a02ULL,
0x000000ffff087224ULL, 0x000fe400078e0a07ULL, 0x0000000409047c24ULL, 0x000fe4000f8e0200ULL,
0x0000000408087c24ULL, 0x000fc6000f8e0205ULL, 0x0000000404007c0cULL, 0x000fe4000bf06070ULL,
0x0000000408007c0cULL, 0x000fd6000bf46070ULL, 0x8000000404040c10ULL, 0x000fe2000fffe0ffULL,
0x0000000102020836ULL, 0x000fe20000000000ULL, 0x00000004ff007c0cULL, 0x000fe2000bf05070ULL,
0x8000000408082c36ULL, 0x000fe20008000000ULL, 0x0000000404007c0cULL, 0x000fe2000bf26070ULL,
0x0000000107072836ULL, 0x000fe20000000000ULL, 0x00000004ff047c12ULL, 0x000fe4000f8e33ffULL,
0x0000000408007c0cULL, 0x000fd2000bf66070ULL, 0x0000000102021810ULL, 0x000fc80007ffe0ffULL,
0x0000000107073836ULL, 0x000fe20000000000ULL, 0x0000000204027207ULL, 0x000fc80004000000ULL,
0x0000000704047207ULL, 0x000fe20004000000ULL, 0x000000ffff077224ULL, 0x000fc800078e0a02ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x0000000407007c24ULL, 0x000fe4000f8e0200ULL,
0x0000000408077c24ULL, 0x000fe2000f8e0205ULL, 0x00008c0000047ab9ULL, 0x000fe40000000a00ULL,
0x000000000e057210ULL, 0x000fe20007ffe0ffULL, 0x000000010e097824ULL, 0x000fe400078e0207ULL,
0x000000101e077824ULL, 0x000fc400078e00ffULL, 0x0000001302057224ULL, 0x080fe400078e0205ULL,
0x0000001304097224ULL, 0x000fe200078e0209ULL, 0x000000f007117812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010009087825ULL, 0x000fe200078e00ffULL,
0x0000001104047212ULL, 0x000fc600078efcffULL, 0x000000010d007824ULL, 0x140fe200078e021eULL,
0x000000040d0d7819ULL, 0x000fe200000006ffULL, 0x000000010f027824ULL, 0x040fe200078e021eULL,
0x0000001108087212ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d007812ULL, 0x000fe400078ee200ULL, 0x0000000404047c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000408087c10ULL, 0x000fe2000ff3e0ffULL, 0x00000010000d7824ULL, 0x000fe200078e021dULL,
0xfffffff00f027812ULL, 0x000fc400078ee202ULL, 0x0000000505057c10ULL, 0x000fe400087fe4ffULL,
0x0000000509097c10ULL, 0x000fe40008ffe4ffULL, 0x0000001d020f7211ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e8000b901c46ULL,
0x00000000080f7faeULL, 0x0003e4000b901c46ULL, 0x000000001d0472caULL, 0x000fe200000e0000ULL,
0x00009400ff047b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001e60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000429047825ULL, 0x002fe200078e0004ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006041c7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x0000007f1c1b7836ULL, 0x004fe40000000000ULL,
0x000000ff1c1a7836ULL, 0x000fc60000000000ULL, 0x00000007ff1b7819ULL, 0x000fe4000001161bULL,
0x00000008ff1a7819ULL, 0x000fca000001161aULL, 0x000000d800d08947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011624ULL, 0x0000000824197824ULL, 0x000fe200078e00ffULL,
0xffffffff00237802ULL, 0x000fe20000000f00ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0x01ffffff00007812ULL, 0x000fca00078ec0ffULL, 0x00000002212a7824ULL, 0x000fca00078e0200ULL,
0x0000001b2a00720cULL, 0x000fda0003f06070ULL, 0x00009600ff038b82ULL, 0x000e620000000800ULL,
0x0000000129008819ULL, 0x000fce00000006ffULL, 0x00009200ff048b82ULL, 0x000ea20000000a00ULL,
0x0000000300038224ULL, 0x002fe400078e0203ULL, 0x000000011d007824ULL, 0x000fe400078e0219ULL,
0x000000012a038824ULL, 0x000fe400078e0203ULL, 0x01e6880900ff79a7ULL, 0x0003e4000850003fULL,
0x0000000403048825ULL, 0x004fca00078e0004ULL, 0x0000000604238981ULL, 0x000e62000c1e1900ULL,
0x00000001210b7836ULL, 0x000fe20000000000ULL, 0x00000001ff187819ULL, 0x000fe20000011624ULL,
0x0000008026167824ULL, 0x000fc600078e00ffULL, 0x0000001a0b00720cULL, 0x000fe20003f06070ULL,
0x0000002018177824ULL, 0x000fe200078e00ffULL, 0x00009000ff027b82ULL, 0x000ea60000000a00ULL,
0x00000100210b7824ULL, 0x000fca00078e0217ULL, 0x0000006016347812ULL, 0x000fe200078ef80bULL,
0x0000001523007224ULL, 0x002fe200078e02ffULL, 0x0000000124157812ULL, 0x000fc800078ec0ffULL,
0x0000000700097819ULL, 0x000fca00000006ffULL, 0x0000010009027825ULL, 0x004fe200078e0002ULL,
0x0000000400948947ULL, 0x000fec0003800000ULL, 0x0000007007047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001161eULL,
0x0000000b1c007248ULL, 0x000fe20007fe0000ULL, 0x0000008015047824ULL, 0x000fe200078e0204ULL,
0x0000000f34077210ULL, 0x000fe20007ffe0ffULL, 0x000000040f097836ULL, 0x000fe20000000000ULL,
0x000000080f257810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200078e0a0bULL,
0x0000001c0f317810ULL, 0x000fe20007ffe0ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0000001e09087210ULL, 0x000fc40007ffe0ffULL, 0x0000002000007446ULL, 0x000fe2000380000bULL,
0x0000000809137824ULL, 0x040fe200078e00ffULL, 0x00000006020c7210ULL, 0x000fe20007f1e0ffULL,
0x0000400018067824ULL, 0x000fe200078e021dULL, 0x000000000900720cULL, 0x080fe20003f26070ULL,
0x000000100f2b7836ULL, 0x000fe20000000000ULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x00000001030d7824ULL, 0x000fe200000e0607ULL, 0x0000001e0f087210ULL, 0x000fe20007ffe0ffULL,
0x0000000134077824ULL, 0x000fe200078e0209ULL, 0x000000000f00720cULL, 0x080fe20003f06070ULL,
0x00002000150e7824ULL, 0x000fe200078e0206ULL, 0x0000000708117812ULL, 0x000fe200078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000002500720cULL, 0x000fc40003fa6070ULL,
0x0ffffff811117812ULL, 0x000fe200078ef81eULL, 0x000160000e107836ULL, 0x000fe20000000000ULL,
0x0000000602067210ULL, 0x000fe20007f5e0ffULL, 0x0000000c0f277836ULL, 0x000fe40000000000ULL,
0x0000001011117824ULL, 0x100fe200078e0210ULL, 0x0000000703077210ULL, 0x000fe200017fe4ffULL,
0x0000001013137824ULL, 0x000fe200078e0210ULL, 0x000000002700720cULL, 0x080fe20003f86070ULL,
0x000000140f2d7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c117faeULL, 0x0003e2000c101c46ULL, 0x000000180f2f7836ULL, 0x000fe20000000000ULL,
0x000000003100720cULL, 0x080fe20003f06070ULL, 0x00000001340f7824ULL, 0x040fe200078e022bULL,
0x0000000006137faeULL, 0x0005e2000c901c46ULL, 0x0000000134097824ULL, 0x040fe200078e0225ULL,
0x000000002f00720cULL, 0x000fe20003f26070ULL, 0x00000001340b7824ULL, 0x000fc400078e0227ULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x0000001e270d7210ULL, 0x002fc60007ffe0ffULL,
0x0000000827127824ULL, 0x000fe200078e00ffULL, 0x0000000802087210ULL, 0x000fe20007f7e0ffULL,
0x000001000b0a7825ULL, 0x000fc600078e0004ULL, 0xfffffff812137812ULL, 0x004fe200078ee20dULL,
0x000001000f067825ULL, 0x000fe200078e0004ULL, 0x0000000a020a7210ULL, 0x000fc60007f5e0ffULL,
0x00000001340f7824ULL, 0x000fe200078e022dULL, 0x00000006020c7210ULL, 0x000fe20007fde0ffULL,
0x00000001250e7824ULL, 0x040fe200078e021eULL, 0x0000000b030b7210ULL, 0x000fe200017fe4ffULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x000000002d00720cULL, 0x000fe20003f46070ULL,
0x00000001030d7824ULL, 0x000fe400030e0607ULL, 0x000001000f067825ULL, 0x000fe200078e0004ULL,
0xfffffff825117812ULL, 0x000fc600078ee20eULL, 0x0000000103097824ULL, 0x000fe200018e0609ULL,
0x000000002b00720cULL, 0x000fe20003f66070ULL, 0x000000012d0f7824ULL, 0x040fe200078e021eULL,
0x0000001e2b007210ULL, 0x000fe20007ffe0ffULL, 0x000000082d127824ULL, 0x000fe200078e00ffULL,
0x00000006020e7210ULL, 0x000fe20007fde0ffULL, 0x000000082b257824ULL, 0x000fe200078e00ffULL,
0x0000002f342b7210ULL, 0x000fe20007ffe0ffULL, 0x00000001342d7824ULL, 0x000fe200078e0231ULL,
0xfffffff812277812ULL, 0x000fe200078ee20fULL, 0x00000001030f7824ULL, 0x000fe200030e0607ULL,
0xfffffff825257812ULL, 0x000fe200078ee200ULL, 0x000001002b067825ULL, 0x000fe200078e0004ULL,
0x000000032f2b7819ULL, 0x000fc400000006ffULL, 0x0000001011117211ULL, 0x080fe200078e20ffULL,
0x0000000131127824ULL, 0x100fe200078e021eULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x000000012f007824ULL, 0x000fe400078e021eULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0x0000000008117faeULL, 0x0003e2000e901c46ULL, 0x000001002d047825ULL, 0x000fe200078e0004ULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee200ULL, 0xfffffff8312d7812ULL, 0x000fe200078ee212ULL,
0x0000000103077824ULL, 0x000fe200030e0607ULL, 0x0000000402027210ULL, 0x000fe20007fde0ffULL,
0x0000001013137824ULL, 0x100fe200078e0210ULL, 0x000000102b2b7211ULL, 0x000fe200078e20ffULL,
0x0000001025257824ULL, 0x000fc400078e0210ULL, 0x0000001027277824ULL, 0x100fe200078e0210ULL,
0x000000000a137faeULL, 0x0003e2000e101c46ULL, 0x000000102d2d7824ULL, 0x000fe400078e0210ULL,
0x0000000103037824ULL, 0x000fe200030e0605ULL, 0x000000000c257faeULL, 0x0003e8000d901c46ULL,
0x000000000e277faeULL, 0x0003e8000d101c46ULL, 0x00000000062b7faeULL, 0x0003e8000c901c46ULL,
0x00000000022d7faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x000000041e057811ULL, 0x040fe400078fe8ffULL, 0x000000081e0b7811ULL, 0x040fe400078fe8ffULL,
0x0000000305097819ULL, 0x040fe200000006ffULL, 0x0000000105007824ULL, 0x100fe200078e021eULL,
0x0000000c1e0d7811ULL, 0x040fe200078fe8ffULL, 0x000000010b047824ULL, 0x140fe200078e021eULL,
0x000000141e117811ULL, 0x040fe200078fe8ffULL, 0x000000080b2b7824ULL, 0x000fe200078e00ffULL,
0x000000101e0f7811ULL, 0x000fe200078fe8ffULL, 0x00000001340b7824ULL, 0x000fe200078e020bULL,
0xfffffff809147812ULL, 0x000fe200078ee200ULL, 0x000000010d007824ULL, 0x100fe200078e021eULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL, 0x0000000111067824ULL, 0x100fe200078e021eULL,
0x000000181e137811ULL, 0x000fe200078fe8ffULL, 0x000000010f047824ULL, 0x100fe200078e021eULL,
0x000000030d097819ULL, 0x000fe200000006ffULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0x0000000311277819ULL, 0x000fe200000006ffULL, 0x0000000113087824ULL, 0x140fe200078e021eULL,
0xfffffff8092c7812ULL, 0x000fe200078ee200ULL, 0x00000008132d7824ULL, 0x000fe200078e00ffULL,
0xfffffff827307812ULL, 0x000fe200078ee206ULL, 0x0000000134097824ULL, 0x000fe200078e0205ULL,
0x0000001e1e007211ULL, 0x000fe200078fe8ffULL, 0x00000001340f7824ULL, 0x000fe200078e020fULL,
0x0000001c1e277811ULL, 0x000fe200078fe8ffULL, 0x0000000134117824ULL, 0x000fe200078e0211ULL,
0xfffffff8252e7812ULL, 0x000fe200078ee204ULL, 0x0000400018047824ULL, 0x000fe200078e021dULL,
0x0000007007127812ULL, 0x000fe200078ec0ffULL, 0x0000000134257824ULL, 0x000fe200078e0213ULL,
0x0000000700077812ULL, 0x000fe200078ec0ffULL, 0x0000000127007824ULL, 0x000fe200078e021eULL,
0xfffffff82d327812ULL, 0x000fe200078ee208ULL, 0x0000200015047824ULL, 0x040fe200078e0204ULL,
0x0000001215127211ULL, 0x000fc400078e38ffULL, 0x00000003272d7819ULL, 0x000fe200000006ffULL,
0x0000000134277824ULL, 0x000fe200078e0227ULL, 0x000000341e057211ULL, 0x000fe200078fe8ffULL,
0x0001600004357836ULL, 0x000fe20000000000ULL, 0x000000ff00137202ULL, 0x000fe40000000f00ULL,
0x0000000d340d7210ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0235ULL,
0xfffffff82d347812ULL, 0x000fe200078ee200ULL, 0x0000010005047825ULL, 0x000fe200078e0012ULL,
0x0ffffff807007812ULL, 0x000fc400078ef81eULL, 0x000000352c2d7211ULL, 0x000fe200078e20ffULL,
0x0000010009067825ULL, 0x000fe200078e0012ULL, 0x0000000402047210ULL, 0x000fc60007f1e0ffULL,
0x000001000b087825ULL, 0x000fe200078e0012ULL, 0x0000000602067210ULL, 0x000fc60007f3e0ffULL,
0x000001000d0a7825ULL, 0x000fe200078e0012ULL, 0x0000000802087210ULL, 0x000fc60007f5e0ffULL,
0x000001000f0c7825ULL, 0x000fe200078e0012ULL, 0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL,
0x00000100110e7825ULL, 0x000fe200078e0012ULL, 0x0000000b030b7210ULL, 0x000fc60001ffe4ffULL,
0x0000010025107825ULL, 0x000fc800078e0012ULL, 0x0000010027127825ULL, 0x000fc800078e0012ULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000000c020c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000103077824ULL, 0x040fe200008e0607ULL, 0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001000257824ULL, 0x000fe400078e0235ULL, 0x0000000103097824ULL, 0x040fe200010e0609ULL,
0x0000001002107210ULL, 0x000fe20007f5e0ffULL, 0x0000001014277824ULL, 0x100fe200078e0235ULL,
0x0000001202027210ULL, 0x000fe20007f7e0ffULL, 0x000000102e2f7824ULL, 0x000fe200078e0235ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004257faeULL, 0x0003e2000b901c46ULL,
0x00000001030d7824ULL, 0x000fc400000e060dULL, 0x0000001030317824ULL, 0x000fe200078e0235ULL,
0x0000000006277faeULL, 0x0003e2000b901c46ULL, 0x00000001030f7824ULL, 0x040fe400008e060fULL,
0x0000001032337824ULL, 0x000fe200078e0235ULL, 0x0000003534357211ULL, 0x000fe200078e20ffULL,
0x0000000103117824ULL, 0x000fe200010e0611ULL, 0x0000001303037210ULL, 0x000fe20001ffe4ffULL,
0x00000000082b7faeULL, 0x0003e8000b901c46ULL, 0x000000000a2d7faeULL, 0x0003e8000b901c46ULL,
0x000000000c2f7faeULL, 0x0003e8000b901c46ULL, 0x000000000e317faeULL, 0x0003e8000b901c46ULL,
0x0000000010337faeULL, 0x0003e8000b901c46ULL, 0x0000000002357faeULL, 0x0003e4000b901c46ULL,
0x0000001a2100720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff887424ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x002fe2000001ff00ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fc4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fc4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe4000001ff00ULL,
0x00000000005a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x00000000007a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000787805ULL, 0x000fe4000001ff00ULL,
0x00000000007e7805ULL, 0x000fe4000001ff00ULL, 0x00000000007c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000667805ULL, 0x000fc4000001ff00ULL, 0x0000000000647805ULL, 0x000fe4000001ff00ULL,
0x00000000006a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000007400480947ULL, 0x000fec0003800000ULL, 0x00009600ff037b82ULL, 0x000e620000000800ULL,
0x0000000229147824ULL, 0x000fe200078e00ffULL, 0xff31721700887802ULL, 0x000fe20000000f00ULL,
0x000000ffff2f7224ULL, 0x000fe400078e00ffULL, 0x0000000314147224ULL, 0x002fce00078e0203ULL,
0x00009000ff027b82ULL, 0x000e620000000a00ULL, 0x0000001024007824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x00000001210b7836ULL, 0x000fe40000000000ULL,
0x0000000423237c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe000007812ULL, 0x000fe400078ec0ffULL,
0x0000001a0b00720cULL, 0x000fe20003f06070ULL, 0x0000008023237824ULL, 0x000fe400078e00ffULL,
0x0000010021007824ULL, 0x000fca00078e0200ULL, 0x00000040000d7810ULL, 0x000fc80007ffe0ffULL,
0x000000600d057812ULL, 0x000fe200078ec0ffULL, 0x0000010023027825ULL, 0x002fc800078e0002ULL,
0x0000000116277824ULL, 0x000fe200078e0205ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x000000041e067819ULL, 0x000fe200000006ffULL,
0x000000ffff057224ULL, 0x000fe200078e0a0dULL, 0x00000003ff237819ULL, 0x100fe2000001161eULL,
0x0000008024047824ULL, 0x000fe200078e00ffULL, 0x0000000d1c007248ULL, 0x000fe40007fe0000ULL,
0x00000070060b7812ULL, 0x000fe200078ec0ffULL, 0x0000000423297836ULL, 0x000fe20000000000ULL,
0x0000002000007446ULL, 0x000fe20003800005ULL, 0x00000001230d7824ULL, 0x140fe200078e0227ULL,
0x000000800b047812ULL, 0x000fe200078ef804ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000d24067819ULL, 0x000fe200000006ffULL, 0x00000001230b7824ULL, 0x000fe200078e021eULL,
0x0000001d18137211ULL, 0x000fe200078e70ffULL, 0x00000001290f7824ULL, 0x000fe200078e0227ULL,
0x0000200006067812ULL, 0x000fe200078ec0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0004ULL,
0x000000070b0b7812ULL, 0x000fc400078ec0ffULL, 0x000000002300720cULL, 0x080fe20003f26070ULL,
0x000001000f0e7825ULL, 0x000fe200078e0004ULL, 0x0000000c020c7210ULL, 0x000fe40007f1e0ffULL,
0x0001700013067810ULL, 0x000fe20007ffe006ULL, 0x0000000129107824ULL, 0x000fe200078e021eULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef81eULL, 0x00000001030d7824ULL, 0x000fe200000e060dULL,
0x0000000329137819ULL, 0x000fe200000006ffULL, 0x00000010235d7836ULL, 0x000fe20000000000ULL,
0x0000000e02127210ULL, 0x000fe20007f5e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0206ULL,
0x000000002900720cULL, 0x080fe20003f06070ULL, 0x00000014235f7836ULL, 0x000fe20000000000ULL,
0xfffffff813297812ULL, 0x000fe200078ee210ULL, 0x0000000103137824ULL, 0x000fe200010e060fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000c901c46ULL,
0x00000008230f7836ULL, 0x000fe20000000000ULL, 0x0000000c232b7810ULL, 0x000fe20007ffe0ffULL,
0x00000018236d7836ULL, 0x000fe20000000000ULL, 0x0000001c236f7810ULL, 0x000fe20007ffe0ffULL,
0x000000015d107824ULL, 0x100fe200078e021eULL, 0x000000000f00720cULL, 0x080fe20003fc6070ULL,
0x000000085d617824ULL, 0x000fe200078e00ffULL, 0x000000275d237210ULL, 0x000fe20007ffe0ffULL,
0x000000085f637824ULL, 0x000fe200078e00ffULL, 0x000000005d00720cULL, 0x080fe20003f86070ULL,
0x000000010f0c7824ULL, 0x002fe200078e021eULL, 0x000000002b00720cULL, 0x080fe20003fa6070ULL,
0x000000080f0d7824ULL, 0x000fe200078e00ffULL, 0x000000005f00720cULL, 0x080fe20003f66070ULL,
0x00000010290b7824ULL, 0x000fe200078e0206ULL, 0x000000006d00720cULL, 0x000fc40003f46070ULL,
0xfffffff80d297812ULL, 0x000fe400078ee20cULL, 0x000000270f0d7210ULL, 0x000fe20007ffe0ffULL,
0x000000012b0f7824ULL, 0x000fe200078e0227ULL, 0x00000000120b7faeULL, 0x0003e2000c101c46ULL,
0x000000006f00720cULL, 0x000fe20003f26070ULL, 0x000000012b007824ULL, 0x000fe200078e021eULL,
0xfffffff861617812ULL, 0x000fe200078ee210ULL, 0x000001000d0c7825ULL, 0x000fc800078e0004ULL,
0x000001000f0e7825ULL, 0x000fe200078e0004ULL, 0x0000000c025c7210ULL, 0x000fc60007f1e0ffULL,
0x000000015f0b7824ULL, 0x002fe400078e0227ULL, 0x00000001035d7824ULL, 0x000fe200000e060dULL,
0x0000000e02127210ULL, 0x000fe20007f1e0ffULL, 0x00000100230c7825ULL, 0x000fe200078e0004ULL,
0x000000276d237210ULL, 0x000fc60007ffe0ffULL, 0x000000082b2b7824ULL, 0x000fe400078e00ffULL,
0x0000000103137824ULL, 0x000fe200000e060fULL, 0x0000000c025e7210ULL, 0x000fe20007f1e0ffULL,
0x000001000b0e7825ULL, 0x000fe200078e0004ULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee200ULL,
0x0000001e5f007210ULL, 0x000fe20007ffe0ffULL, 0x00000001035f7824ULL, 0x000fe200000e060dULL,
0x0000000e020e7210ULL, 0x000fe20007f1e0ffULL, 0x00000100230c7825ULL, 0x000fe200078e0004ULL,
0xfffffff863637812ULL, 0x000fc600078ee200ULL, 0x000000016f0b7824ULL, 0x000fe400078e0227ULL,
0x000000016d007824ULL, 0x140fe200078e021eULL, 0x000000036d6d7819ULL, 0x000fe200000006ffULL,
0x000000016f107824ULL, 0x000fe400078e021eULL, 0x00000001030f7824ULL, 0x000fe200000e060fULL,
0x0000000c020c7210ULL, 0x000fe20007f1e0ffULL, 0x000000086f6f7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee200ULL, 0x000001000b047825ULL, 0x000fe200078e0004ULL,
0x0000000d030d7210ULL, 0x000fc400007fe4ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee210ULL,
0x00000010290b7824ULL, 0x100fe200078e0206ULL, 0x0000000402027210ULL, 0x000fe20007f1e0ffULL,
0x000000102b237824ULL, 0x100fe200078e0206ULL, 0x0000000663297211ULL, 0x000fe200078e20ffULL,
0x0000001061277824ULL, 0x100fe200078e0206ULL, 0x000000005c0b7faeULL, 0x0003e2000f101c46ULL,
0x000000106d2b7824ULL, 0x100fe400078e0206ULL, 0x000000106f617824ULL, 0x000fe200078e0206ULL,
0x0000000012237faeULL, 0x0003e2000e901c46ULL, 0x0000000103037824ULL, 0x000fc600000e0605ULL,
0x000000005e277faeULL, 0x0003e8000e101c46ULL, 0x000000000e297faeULL, 0x0003e8000d901c46ULL,
0x000000000c2b7faeULL, 0x0003e8000d101c46ULL, 0x0000000002617faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x0000200024047824ULL, 0x000fe200078e00ffULL,
0x0000001d18187211ULL, 0x000fe200078e70ffULL, 0x000000101e007824ULL, 0x040fe200078e00ffULL,
0x000000101e5d7811ULL, 0x000fe200078fe8ffULL, 0x0000008024637824ULL, 0x000fe200078e00ffULL,
0x0000200004057812ULL, 0x000fe400078ec0ffULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x000000085d067824ULL, 0x040fe200078e00ffULL, 0x000000081e0f7811ULL, 0x000fe400078fe8ffULL,
0x0001700018187810ULL, 0x000fe20007ffe005ULL, 0x000000015d057824ULL, 0x100fe200078e021eULL,
0x000000041e0d7811ULL, 0x040fe200078fe8ffULL, 0x000000080f297824ULL, 0x040fe200078e00ffULL,
0x0000008000627812ULL, 0x000fe200078ef863ULL, 0x000000010f007824ULL, 0x100fe200078e021eULL,
0x000000181e617811ULL, 0x040fe200078fe8ffULL, 0x000000080d237824ULL, 0x000fe200078e00ffULL,
0x0000000c1e137811ULL, 0x040fe200078fe8ffULL, 0x000000010f0f7824ULL, 0x100fe200078e0227ULL,
0xfffffff806637812ULL, 0x000fe200078ee205ULL, 0x0000000161057824ULL, 0x040fe200078e021eULL,
0x0000001e0d047210ULL, 0x000fe20007ffe0ffULL, 0x00000008610c7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee200ULL, 0x00000008132b7824ULL, 0x000fe200078e00ffULL,
0x0000001e1e007211ULL, 0x040fe200078fe8ffULL, 0x000000010d0d7824ULL, 0x100fe200078e0227ULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x000000015d5d7824ULL, 0x100fe200078e0227ULL,
0x0000001e13047210ULL, 0x000fe20007ffe0ffULL, 0x0000000161617824ULL, 0x000fe200078e0227ULL,
0x000000141e5f7811ULL, 0x040fe200078fe8ffULL, 0x0000001023237824ULL, 0x000fe200078e0218ULL,
0x0000001c1e717811ULL, 0x000fc400078fe8ffULL, 0xfffffff80c6f7812ULL, 0x000fe200078ee205ULL,
0x000000085f6d7824ULL, 0x000fe200078e00ffULL, 0x0000000700057812ULL, 0x000fe200078ec0ffULL,
0x0000000871737824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL,
0x000000106f6f7824ULL, 0x000fe200078e0218ULL, 0x0000001e5f047210ULL, 0x000fe20007ffe0ffULL,
0x000000015f5f7824ULL, 0x000fe200078e0227ULL, 0x0000001e71067210ULL, 0x000fe40007ffe0ffULL,
0x0ffffff8050b7812ULL, 0x000fc400078ef81eULL, 0x0000002713137210ULL, 0x000fe40007ffe0ffULL,
0x0000002771717210ULL, 0x000fe20007ffe0ffULL, 0x000000100b0b7824ULL, 0x100fe200078e0218ULL,
0x000000271e057211ULL, 0x000fe200078fe8ffULL, 0x0000001029277824ULL, 0x100fe200078e0218ULL,
0x000000182b297211ULL, 0x000fe200078e20ffULL, 0x00000010632b7824ULL, 0x000fe200078e0218ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee204ULL, 0x000000ffff637224ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee206ULL, 0x0000010005047825ULL, 0x000fc600078e0062ULL,
0x0000001873737211ULL, 0x000fe200078e20ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0062ULL,
0x0000000402047210ULL, 0x000fc60007f1e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0062ULL,
0x0000000c020c7210ULL, 0x000fc60007f3e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0062ULL,
0x0000000e020e7210ULL, 0x000fc60007f5e0ffULL, 0x000001005d5c7825ULL, 0x100fe200078e0062ULL,
0x0000001202127210ULL, 0x000fe40007f7e0ffULL, 0x0000000f030f7210ULL, 0x000fe200017fe4ffULL,
0x000001005f5e7825ULL, 0x000fc800078e0062ULL, 0x0000010061607825ULL, 0x000fc800078e0062ULL,
0x0000010071627825ULL, 0x000fe200078e0062ULL, 0x0000006002607210ULL, 0x000fc60007f5e0ffULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000005c025c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001030d7824ULL, 0x040fe200008e060dULL, 0x0000005e025e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000103137824ULL, 0x040fe200018e0613ULL, 0x0000006202027210ULL, 0x000fe20007f7e0ffULL,
0x00000001035d7824ULL, 0x000fe200000e065dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000b901c46ULL, 0x000000106d6d7824ULL, 0x000fe200078e0218ULL,
0x0000006103617210ULL, 0x000fe200017fe4ffULL, 0x00000001035f7824ULL, 0x040fe200008e065fULL,
0x000000000c237faeULL, 0x0003e2000b901c46ULL, 0x0000000103037824ULL, 0x000fc600018e0663ULL,
0x000000000e277faeULL, 0x0003e8000b901c46ULL, 0x0000000012297faeULL, 0x0003e8000b901c46ULL,
0x000000005c2b7faeULL, 0x0003e8000b901c46ULL, 0x000000005e6d7faeULL, 0x0003e8000b901c46ULL,
0x00000000606f7faeULL, 0x0003e8000b901c46ULL, 0x0000000002737faeULL, 0x0003e4000b901c46ULL,
0x000000012a027812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff28007811ULL, 0x000fe400078e08ffULL, 0x000000010200780cULL, 0x000fe40003f05070ULL,
0xffffffff00297802ULL, 0x000fe40000000f00ULL, 0x0000000100237807ULL, 0x000fca0004000000ULL,
0x0000000123237824ULL, 0x000fca00078e022aULL, 0x0000001b2300720cULL, 0x000fda0003f06070ULL,
0x00009200ff028b82ULL, 0x000e620000000a00ULL, 0x0000000114058824ULL, 0x000fe200078e0223ULL,
0xffffffe019007812ULL, 0x040fe400078ec0ffULL, 0x0000001019047812ULL, 0x000fe200078ec0ffULL,
0x00000001ff0c7424ULL, 0x000fc600078e00ffULL, 0x0000001d04007210ULL, 0x000fe20007ffe000ULL,
0x0000000405028825ULL, 0x002fe200078e0002ULL, 0x0000000819057812ULL, 0x000fc800078ec0ffULL,
0x0000000602298981ULL, 0x000322000c1e1900ULL, 0x00000001000b7824ULL, 0x000fc800078e0205ULL,
0x01e6080c0b0c79a7ULL, 0x0002a6000850003fULL, 0x0000000000027805ULL, 0x002fce0000015200ULL,
0x01e6080d0b0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x00000004020f7210ULL, 0x000fc80007f1e1ffULL, 0x0000000503057210ULL, 0x000fe400007fe5ffULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000f00007211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x01e6080d0b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000101e137824ULL, 0x000fe200078e00ffULL,
0x0000000524007819ULL, 0x000fe200000006ffULL, 0x000000ffff277224ULL, 0x000fe200078e0088ULL,
0x00000001ff127819ULL, 0x000fe4000001161eULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c12127812ULL, 0x000fe400078ec0ffULL,
0x0000001d13037210ULL, 0x000fca0007ffe000ULL, 0x0000000103037824ULL, 0x000fca00078e0212ULL,
0x01e0000003057984ULL, 0x000e680000000800ULL, 0x01e20000032a7984ULL, 0x0004a20000000800ULL,
0x000000880500720bULL, 0x002fda0003f1d000ULL, 0x0000000000027806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff0200720cULL, 0x000fda0003f25270ULL,
0x0000000400909947ULL, 0x004fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011624ULL,
0x000000880500720bULL, 0x000fe40003f34000ULL, 0x000000240300720cULL, 0x000fe40003f45270ULL,
0x0000008805277209ULL, 0x000fd20007810000ULL, 0x0000000000037806ULL, 0x000fe400008e0100ULL,
0x000000802400a824ULL, 0x000fe400078e021dULL, 0x000000ff0300720cULL, 0x000fc60003f25270ULL,
0x000000001200a210ULL, 0x000fca0007ffe013ULL, 0x01e400270000a388ULL, 0x0003ea0000000800ULL,
0x0000000400509947ULL, 0x000fea0003800000ULL, 0x0000008827007221ULL, 0x002fe20000010100ULL,
0x000000ff03ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0003ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b00007820ULL, 0x000fe20000410000ULL, 0x00ff000003ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000003ff7812ULL, 0x000fe2000788c0ffULL, 0x00000000000b7308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000002ff007819ULL, 0x002fcc000001161eULL,
0x00001f000b007589ULL, 0x004e6400000e0000ULL, 0x0000000068687220ULL, 0x082fe20000410000ULL,
0x0000000069697220ULL, 0x080fe20000410000ULL, 0x0000000064647220ULL, 0x080fe20000410000ULL,
0x0000000065657220ULL, 0x080fe20000410000ULL, 0x000000007c7c7220ULL, 0x080fe20000410000ULL,
0x000000007d7d7220ULL, 0x080fe20000410000ULL, 0x0000000078787220ULL, 0x080fe20000410000ULL,
0x0000000079797220ULL, 0x080fe20000410000ULL, 0x0000000058587220ULL, 0x080fe20000410000ULL,
0x0000000059597220ULL, 0x080fe20000410000ULL, 0x0000000054547220ULL, 0x080fe20000410000ULL,
0x0000000055557220ULL, 0x080fe20000410000ULL, 0x0000000050507220ULL, 0x080fe20000410000ULL,
0x0000000051517220ULL, 0x080fe20000410000ULL, 0x000000004c4c7220ULL, 0x080fe20000410000ULL,
0x000000004d4d7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000081e007811ULL, 0x002fcc00078ff0ffULL, 0x00001f000b007589ULL, 0x004e6400000e0000ULL,
0x000000006a6a7220ULL, 0x082fe20000410000ULL, 0x000000006b6b7220ULL, 0x080fe20000410000ULL,
0x0000000066667220ULL, 0x080fe20000410000ULL, 0x0000000067677220ULL, 0x080fe20000410000ULL,
0x000000007e7e7220ULL, 0x080fe20000410000ULL, 0x000000007f7f7220ULL, 0x080fe20000410000ULL,
0x000000007a7a7220ULL, 0x080fe20000410000ULL, 0x000000007b7b7220ULL, 0x080fe20000410000ULL,
0x000000005a5a7220ULL, 0x080fe20000410000ULL, 0x000000005b5b7220ULL, 0x080fe20000410000ULL,
0x0000000056567220ULL, 0x080fe20000410000ULL, 0x0000000057577220ULL, 0x080fe20000410000ULL,
0x0000000052527220ULL, 0x080fe20000410000ULL, 0x0000000053537220ULL, 0x080fe20000410000ULL,
0x000000004e4e7220ULL, 0x080fe20000410000ULL, 0x000000004f4f7220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000101e007811ULL, 0x002fcc00078ff0ffULL,
0x00001f000b007589ULL, 0x004e6400000e0000ULL, 0x0000000048487220ULL, 0x082fe20000410000ULL,
0x0000000049497220ULL, 0x080fe20000410000ULL, 0x0000000044447220ULL, 0x080fe20000410000ULL,
0x0000000045457220ULL, 0x080fe20000410000ULL, 0x0000000040407220ULL, 0x080fe20000410000ULL,
0x0000000041417220ULL, 0x080fe20000410000ULL, 0x000000003c3c7220ULL, 0x080fe20000410000ULL,
0x000000003d3d7220ULL, 0x080fe20000410000ULL, 0x0000000038387220ULL, 0x080fe20000410000ULL,
0x0000000039397220ULL, 0x080fe20000410000ULL, 0x0000000034347220ULL, 0x080fe20000410000ULL,
0x0000000035357220ULL, 0x080fe20000410000ULL, 0x0000000030307220ULL, 0x080fe20000410000ULL,
0x0000000031317220ULL, 0x080fe20000410000ULL, 0x000000002c2c7220ULL, 0x080fe20000410000ULL,
0x000000002d2d7220ULL, 0x000fce0000410000ULL, 0x0000000b25257220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000181e007811ULL, 0x002fcc00078ff0ffULL,
0x00001f000b007589ULL, 0x000e6400000e0000ULL, 0x000000004a4a7220ULL, 0x082fe20000410000ULL,
0x000000004b4b7220ULL, 0x080fe20000410000ULL, 0x0000000046467220ULL, 0x080fe20000410000ULL,
0x0000000047477220ULL, 0x080fe20000410000ULL, 0x0000000042427220ULL, 0x080fe20000410000ULL,
0x0000000043437220ULL, 0x080fe20000410000ULL, 0x000000003e3e7220ULL, 0x080fe20000410000ULL,
0x000000003f3f7220ULL, 0x080fe20000410000ULL, 0x000000003a3a7220ULL, 0x080fe20000410000ULL,
0x000000003b3b7220ULL, 0x080fe20000410000ULL, 0x0000000036367220ULL, 0x080fe20000410000ULL,
0x0000000037377220ULL, 0x080fe20000410000ULL, 0x0000000032327220ULL, 0x080fe20000410000ULL,
0x0000000033337220ULL, 0x080fe20000410000ULL, 0x000000002e2e7220ULL, 0x080fe20000410000ULL,
0x000000002f2f7220ULL, 0x000fce0000410000ULL, 0x0000000302ff7212ULL, 0x000fda00078230ffULL,
0x8000002705051221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b05051820ULL, 0x000fc80000410000ULL, 0x0000000500111308ULL, 0x000ea40000000800ULL,
0x000000112a2a1220ULL, 0x004fce0000410000ULL, 0x00000001242b7819ULL, 0x040fe200000006ffULL,
0x0000200024187824ULL, 0x000fe200078e00ffULL, 0x000000081e037812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000042b8f7812ULL, 0x000fe400078ec0ffULL,
0x00000007038d7812ULL, 0x000fe400078ef81eULL, 0x0000008f1e007211ULL, 0x002fe400078fe0ffULL,
0x000000108d917812ULL, 0x040fe200078efcffULL, 0x000000088d037824ULL, 0x040fe200078e00ffULL,
0xffffc00018047812ULL, 0x000fe200078ec0ffULL, 0x000000018d107824ULL, 0x000fe200078e0200ULL,
0x00000091000f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000891007824ULL, 0x000fe200078e00ffULL,
0x0000008d1e027211ULL, 0x000fe200078fe0ffULL, 0x000000011d047824ULL, 0x000fe200078e0204ULL,
0xfffffff803107812ULL, 0x000fe200078ee210ULL, 0x000000088d057824ULL, 0x040fe200078e00ffULL,
0xfffffff8000f7812ULL, 0x000fe200078ee20fULL, 0x00000002020e7836ULL, 0x000fe20000000000ULL,
0x0000000a24007819ULL, 0x000fe200000006ffULL, 0x000000088d0d7824ULL, 0x040fe200078e00ffULL,
0x00000004020c7810ULL, 0x000fe20007ffe0ffULL, 0x000000088d067824ULL, 0x000fe200078e00ffULL,
0xfffff00000007812ULL, 0x000fe200078ec0ffULL, 0x00000006020b7836ULL, 0x000fe20000000000ULL,
0xfffffff8050e7812ULL, 0x000fe200078ee20eULL, 0x0000200015047824ULL, 0x000fe200078e0204ULL,
0xfffffff80d0d7812ULL, 0x000fc400078ee202ULL, 0xfffffff8030c7812ULL, 0x000fe200078ee20cULL,
0x0001600004047836ULL, 0x000fe20000000000ULL, 0xfffffff8060b7812ULL, 0x000fe400078ee20bULL,
0x000120001d8c7810ULL, 0x000fe20007ffe000ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff077819ULL, 0x000fe4000001161eULL, 0x00000011ff00723eULL, 0x000fe400000010ffULL,
0x0000000807037810ULL, 0x000fe20007ffe0ffULL, 0x0000001007097836ULL, 0x000fe20000000000ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000001807057836ULL, 0x000fc80000000000ULL,
0x00001f03000a7589ULL, 0x0002a800000e0000ULL, 0x00001f0900097589ULL, 0x0002e800000e0000ULL,
0x00001f0700077589ULL, 0x00026800000e0000ULL, 0x00001f0500087589ULL, 0x00026400000e0000ULL,
0x0000001010887824ULL, 0x000fe200078e028cULL, 0x0000008c0f6c7211ULL, 0x000fe200078e20ffULL,
0x000000100d847824ULL, 0x100fe400078e0204ULL, 0x000000100e807824ULL, 0x100fe400078e0204ULL,
0x000000008888783bULL, 0x000ee20000000200ULL, 0x000000100c747824ULL, 0x000fc600078e0204ULL,
0x000000006c6c783bULL, 0x000ea20000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000000788887232ULL, 0x08afe40000200000ULL, 0x000000078a8a7232ULL, 0x000fe40000200000ULL,
0x0000000a89897232ULL, 0x084fe40000200000ULL, 0x0000000a8b8b7232ULL, 0x000fe40000200000ULL,
0x000000096c6c7232ULL, 0x080fe40000200000ULL, 0x000000096e6e7232ULL, 0x000fc40000200000ULL,
0x000000086d6d7232ULL, 0x080fe40000200000ULL, 0x000000086f6f7232ULL, 0x000fce0000200000ULL,
0x000000040b707211ULL, 0x000fe200078e20ffULL, 0x000000008484783bULL, 0x000f620000004200ULL,
0x000000028f8f7812ULL, 0x000fe200078efcffULL, 0x000000088d037824ULL, 0x002fe400078e00ffULL,
0x000000008080783bULL, 0x000e620000004200ULL, 0x0000008f1e007211ULL, 0x040fe200078fe0ffULL,
0x0000000891027824ULL, 0x000fe400078e00ffULL, 0x000000007474783bULL, 0x000e620000004200ULL,
0x0000000091057210ULL, 0x000fe20007ffe0ffULL, 0x000000018d067824ULL, 0x000fe200078e0200ULL,
0x000000911e007211ULL, 0x000fe200078fe0ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0xfffffff802057812ULL, 0x000fc400078ee205ULL, 0xfffffff803067812ULL, 0x000fe200078ee206ULL,
0x0000000891037824ULL, 0x000fe400078e00ffULL, 0x0000000400027836ULL, 0x000fc60000000000ULL,
0xfffffff803047812ULL, 0x000fe200078ee200ULL, 0x0000000200037836ULL, 0x000fe20000000000ULL,
0x0000000600007810ULL, 0x000fe20007ffe0ffULL, 0x000000868864723cULL, 0x028fec0000041864ULL,
0x000000866c44723cULL, 0x004fec0000041844ULL, 0x000000848868723cULL, 0x000fe20000041868ULL,
0x00000001ff867819ULL, 0x000fca0000011624ULL, 0x000000808860723cULL, 0x002fec000004187cULL,
0x00000082885c723cULL, 0x000fec0000041878ULL, 0x000000748858723cULL, 0x000fec0000041858ULL,
0x000000768854723cULL, 0x000fec0000041854ULL, 0x000000708850723cULL, 0x000fec0000041850ULL,
0x00000072884c723cULL, 0x000fec000004184cULL, 0x000000746c38723cULL, 0x000fe20000041838ULL,
0x0000400086887824ULL, 0x000fca00078e021dULL, 0x000000846c48723cULL, 0x000fe20000041848ULL,
0x0000000891747824ULL, 0x000fca00078e00ffULL, 0x000000806c40723cULL, 0x000fe20000041840ULL,
0xfffffff874037812ULL, 0x000fca00078ee203ULL, 0x000000826c3c723cULL, 0x000fe2000004183cULL,
0x0000001006807824ULL, 0x000fca00078e028cULL, 0x000000766c34723cULL, 0x000fe20000041834ULL,
0x000000008080783bULL, 0x000e6a0000000200ULL, 0x000000706c30723cULL, 0x000fec0000041830ULL,
0x000000726c2c723cULL, 0x000fe2000004182cULL, 0x0000000391717819ULL, 0x000fe200000006ffULL,
0x0000200015707824ULL, 0x000fc400078e0288ULL, 0x0000000891917824ULL, 0x000fe200078e00ffULL,
0xfffffff871027812ULL, 0x000fe200078ee202ULL, 0x0001600070717836ULL, 0x000fe20000000000ULL,
0x0000008c056c7211ULL, 0x000fe400078e20ffULL, 0xfffffff891007812ULL, 0x000fe200078ee200ULL,
0x0000001004747824ULL, 0x100fe400078e0271ULL, 0x00000010037c7824ULL, 0x100fe200078e0271ULL,
0x000000006c6c783bULL, 0x000ea20000000200ULL, 0x0000001002787824ULL, 0x000fe200078e0271ULL,
0x0000000000208947ULL, 0x000ff20003800000ULL, 0x0000000780807232ULL, 0x082fe40000200000ULL,
0x0000000782827232ULL, 0x000fe40000200000ULL, 0x0000000a81817232ULL, 0x080fe40000200000ULL,
0x0000000a83837232ULL, 0x000fe40000200000ULL, 0x000000096c6c7232ULL, 0x084fe40000200000ULL,
0x000000096e6e7232ULL, 0x000fc40000200000ULL, 0x000000086d6d7232ULL, 0x080fe40000200000ULL,
0x000000086f6f7232ULL, 0x000fce0000200000ULL, 0x0000007100707211ULL, 0x000fe200078e20ffULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x00009000ff847b82ULL, 0x000f620000000a00ULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x000000252a257221ULL, 0x000fe20000010000ULL,
0x000000007c7c783bULL, 0x000f620000004200ULL, 0x0000000429297c24ULL, 0x010fc6000f8e02ffULL,
0x000000007070783bULL, 0x000f280000004200ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x000000746c48723cULL, 0x00cfec0000041848ULL, 0x0000007c6c40723cULL, 0x022fec0000041840ULL,
0x000000708050723cULL, 0x010fec0000041850ULL, 0x000000706c30723cULL, 0x000fec0000041830ULL,
0x0000007e6c3c723cULL, 0x000fe2000004183cULL, 0x0000000121717810ULL, 0x000fc80007ffe0ffULL,
0x0000001a7100720cULL, 0x000fe20003f06070ULL, 0x000000786c38723cULL, 0x000fec0000041838ULL,
0x0000007a6c34723cULL, 0x000fec0000041834ULL, 0x000000766c44723cULL, 0x000fec0000041844ULL,
0x000000726c2c723cULL, 0x000fec000004182cULL, 0x000000748068723cULL, 0x000fe20000041868ULL,
0x00000008216c7824ULL, 0x000fc400078e0286ULL, 0x00000080296d7824ULL, 0x000fc600078e00ffULL,
0x000000806c6f7811ULL, 0x000fe200078e28ffULL, 0x000000768064723cULL, 0x000fe20000041864ULL,
0xfffffff82b747812ULL, 0x000fe200078ec0ffULL, 0x00000001ff2b7424ULL, 0x000fe200078e00ffULL,
0x000000606f297812ULL, 0x000fe200078ec0ffULL, 0x000001006d847825ULL, 0x000fe400078e0084ULL,
0x0000007c8060723cULL, 0x000fe40000041860ULL, 0x000000011d747824ULL, 0x000fc800078e0274ULL,
0x01e6882b74ff79a7ULL, 0x0003e2000850003fULL, 0x0000007e805c723cULL, 0x000fe2000004185cULL,
0x00000001167d7824ULL, 0x000fca00078e0229ULL, 0x000000788058723cULL, 0x000fec0000041858ULL,
0x0000007a8054723cULL, 0x000fec0000041854ULL, 0x00000072804c723cULL, 0x000fe2000004184cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400908947ULL, 0x002fde0003800000ULL, 0x00000003ff7f7819ULL, 0x100fe2000001161eULL,
0x00000080246c7824ULL, 0x000fe200078e00ffULL, 0x0000200018297812ULL, 0x000fe400078ec0ffULL,
0x0000006f1c187248ULL, 0x000fe20007fe0000ULL, 0x000000047f717836ULL, 0x000fe20000000000ULL,
0x000000ff6f6d7210ULL, 0x000fe20007ffe1ffULL, 0x000000087f817836ULL, 0x000fe20000000000ULL,
0x00000080136c7812ULL, 0x000fe200078ef86cULL, 0x00000001712a7824ULL, 0x040fe200078e021eULL,
0x0000002018187446ULL, 0x000fe2000380006dULL, 0x00000008716f7824ULL, 0x040fe200078e00ffULL,
0x0001600088297810ULL, 0x000fe20007ffe029ULL, 0x000000ffff6d7224ULL, 0x000fe200078e00ffULL,
0x000000187100720cULL, 0x080fe20003f26070ULL, 0x0000000c7f837836ULL, 0x000fe20000000000ULL,
0xfffffff86f7a7812ULL, 0x000fe200078ee22aULL, 0x000000017f6f7824ULL, 0x100fe200078e027dULL,
0x0000007d71717210ULL, 0x000fe20007ffe0ffULL, 0x0000000181737824ULL, 0x000fe200078e027dULL,
0x0000001e7f2a7210ULL, 0x000fe20007ffe0ffULL, 0x000001006f6e7825ULL, 0x000fe200078e006cULL,
0x000000187f00720cULL, 0x000fc40003f06070ULL, 0x000000072a797812ULL, 0x000fe200078ec0ffULL,
0x0000010071707825ULL, 0x000fe200078e006cULL, 0x0000006e84767210ULL, 0x000fe40007f5e0ffULL,
0x0ffffff8792a7812ULL, 0x000fe200078ef81eULL, 0x0000000183757824ULL, 0x000fe200078e027dULL,
0x0000007084787210ULL, 0x000fe20007f7e0ffULL, 0x0000010073727825ULL, 0x100fe200078e006cULL,
0x0000006f85777210ULL, 0x000fe400017fe4ffULL, 0x000000187f8b7810ULL, 0x000fe20007ffe0ffULL,
0x0000010075747825ULL, 0x000fe200078e006cULL, 0x00000072846e7210ULL, 0x000fc40007f5e0ffULL,
0x000000188300720cULL, 0x080fe20003f86070ULL, 0x0000000185797824ULL, 0x000fe200018e0671ULL,
0x0000007484707210ULL, 0x000fe20007f7e0ffULL, 0x000000107f877836ULL, 0x000fe20000000000ULL,
0x000000188100720cULL, 0x080fe20003fa6070ULL, 0x000000102a7b7824ULL, 0x000fe400078e0229ULL,
0x00000001856f7824ULL, 0x040fe200010e0673ULL, 0x000000297a737211ULL, 0x000fe200078e20ffULL,
0x0000000185717824ULL, 0x000fe200018e0675ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000767b7faeULL, 0x0003e2000c101c46ULL, 0x0000000187757824ULL, 0x140fe200078e027dULL,
0x000000188700720cULL, 0x080fe20003f66070ULL, 0x000000147f897836ULL, 0x000fe20000000000ULL,
0x0000000078737faeULL, 0x0005e2000c901c46ULL, 0x0000001c7f7f7836ULL, 0x000fe20000000000ULL,
0x000000188b00720cULL, 0x080fe20003f26070ULL, 0x00000001812a7824ULL, 0x100fe200078e021eULL,
0x000000188900720cULL, 0x0c0fe20003f46070ULL, 0x00000001897a7824ULL, 0x100fe200078e021eULL,
0x000000187f00720cULL, 0x000fe20003f06070ULL, 0x000000088b7c7824ULL, 0x000fe200078e00ffULL,
0x0000000381817819ULL, 0x000fe200000006ffULL, 0x0000000189777824ULL, 0x042fe200078e027dULL,
0x0000000389897819ULL, 0x000fe200000006ffULL, 0x0000000183767824ULL, 0x000fe200078e021eULL,
0xfffffff8812a7812ULL, 0x000fe200078ee22aULL, 0x0000010075727825ULL, 0x004fe200078e006cULL,
0xfffffff8897a7812ULL, 0x000fc600078ee27aULL, 0x0000000883837824ULL, 0x000fe200078e00ffULL,
0x0000007284747210ULL, 0x000fe20007fde0ffULL, 0x0000000887787824ULL, 0x000fe400078e00ffULL,
0x000000018b797824ULL, 0x000fe200078e027dULL, 0x0000007385757210ULL, 0x000fe200037fe4ffULL,
0x0000010077727825ULL, 0x000fe200078e006cULL, 0xfffffff883187812ULL, 0x000fc600078ee276ULL,
0x0000000187777824ULL, 0x100fe200078e021eULL, 0x0000007284767210ULL, 0x000fe20007fde0ffULL,
0x000000017f7b7824ULL, 0x040fe400078e027dULL, 0x000000017f7d7824ULL, 0x000fe200078e021eULL,
0xfffffff878787812ULL, 0x000fe200078ee277ULL, 0x0000000185777824ULL, 0x000fe400030e0673ULL,
0x0000010079727825ULL, 0x000fe200078e006cULL, 0x0000001e8b797210ULL, 0x000fc60007ffe0ffULL,
0x000000087f7e7824ULL, 0x000fe200078e00ffULL, 0x0000007284727210ULL, 0x000fe20007fde0ffULL,
0x000001007b6c7825ULL, 0x000fe200078e006cULL, 0xfffffff87c7c7812ULL, 0x000fe400078ee279ULL,
0x0000007385737210ULL, 0x000fe200037fe4ffULL, 0x000000102a797824ULL, 0x100fe200078e0229ULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee27dULL, 0x00000010187b7824ULL, 0x100fe200078e0229ULL,
0x0000006c846c7210ULL, 0x000fe20007fde0ffULL, 0x00000010787d7824ULL, 0x100fe200078e0229ULL,
0x000000297a7f7211ULL, 0x000fe200078e20ffULL, 0x000000107c817824ULL, 0x100fe200078e0229ULL,
0x000000006e797faeULL, 0x0003e2000e901c46ULL, 0x000000107e297824ULL, 0x000fc400078e0229ULL,
0x00000001856d7824ULL, 0x000fe200030e066dULL, 0x00000000707b7faeULL, 0x0003e8000e101c46ULL,
0x00000000747d7faeULL, 0x0003e8000d901c46ULL, 0x00000000767f7faeULL, 0x0003e8000d101c46ULL,
0x0000000072817faeULL, 0x0003e8000c901c46ULL, 0x000000006c297faeULL, 0x0003e2000c101c46ULL,
0x00000004005c7947ULL, 0x000fea0003800000ULL, 0x000000041e6f7811ULL, 0x000fe200078fe8ffULL,
0x00000080247a7824ULL, 0x000fe200078e00ffULL, 0x0000200018297812ULL, 0x000fe400078ec0ffULL,
0x0000001e6f187210ULL, 0x000fe20007ffe0ffULL, 0x000000086f6d7824ULL, 0x040fe200078e00ffULL,
0x000000081e717811ULL, 0x040fe200078fe8ffULL, 0x000000016f6f7824ULL, 0x000fe200078e027dULL,
0x0000000c1e737811ULL, 0x040fe400078fe8ffULL, 0xfffffff86d2a7812ULL, 0x000fe200078ee218ULL,
0x0000000171187824ULL, 0x140fe200078e021eULL, 0x000000101e757811ULL, 0x000fe200078fe8ffULL,
0x0000000871797824ULL, 0x000fe200078e00ffULL, 0x00016000888b7810ULL, 0x000fe20007ffe029ULL,
0x00000008737e7824ULL, 0x000fe200078e00ffULL, 0x0000001e73297210ULL, 0x000fe20007ffe0ffULL,
0x00000001756c7824ULL, 0x040fe200078e021eULL, 0xfffffff8797c7812ULL, 0x000fe200078ee218ULL,
0x00000008757b7824ULL, 0x000fe200078e00ffULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee229ULL,
0x0000000173737824ULL, 0x100fe200078e027dULL, 0x000000141e777811ULL, 0x040fe200078fe8ffULL,
0x0000000175757824ULL, 0x000fe200078e027dULL, 0x0000001e1e187211ULL, 0x000fc400078fe8ffULL,
0x000000181e297811ULL, 0x000fe200078fe8ffULL, 0x0000000877827824ULL, 0x000fe200078e00ffULL,
0xfffffff87b807812ULL, 0x000fe400078ee26cULL, 0x00000007187b7812ULL, 0x000fe200078ec0ffULL,
0x0000000129187824ULL, 0x140fe200078e021eULL, 0x0000001e776d7210ULL, 0x000fe20007ffe0ffULL,
0x00000008297f7824ULL, 0x000fe200078e00ffULL, 0x0000001c1e6c7811ULL, 0x000fe200078fe8ffULL,
0x0000000177777824ULL, 0x000fe200078e027dULL, 0xfffffff882827812ULL, 0x000fe200078ee26dULL,
0x0000001080837824ULL, 0x100fe200078e028bULL, 0xfffffff87f867812ULL, 0x000fe200078ee218ULL,
0x000000016c6e7824ULL, 0x000fe200078e021eULL, 0x00000080137a7812ULL, 0x000fe200078ef87aULL,
0x000000107c7f7824ULL, 0x100fe200078e028bULL, 0x0000007d1e6d7211ULL, 0x000fe200078fe8ffULL,
0x0000001086897824ULL, 0x000fe200078e028bULL, 0x0ffffff87b187812ULL, 0x000fe200078ef81eULL,
0x000000ffff7b7224ULL, 0x000fe200078e00ffULL, 0x0000007d71717210ULL, 0x000fc40007ffe0ffULL,
0x0000007d29797210ULL, 0x000fe20007ffe0ffULL, 0x000000016c297824ULL, 0x040fe200078e027dULL,
0x000000036c817819ULL, 0x000fe200000006ffULL, 0x000001006d6c7825ULL, 0x100fe200078e007aULL,
0x0000008b2a7d7211ULL, 0x080fe400078e20ffULL, 0xfffffff881887812ULL, 0x000fe200078ee26eULL,
0x0000010071707825ULL, 0x100fe200078e007aULL, 0x0000006c846c7210ULL, 0x000fe40007f1e0ffULL,
0x0000008b82877211ULL, 0x000fe200078e20ffULL, 0x000001006f6e7825ULL, 0x000fe200078e007aULL,
0x0000007084707210ULL, 0x000fc60007f5e0ffULL, 0x0000010073727825ULL, 0x000fe200078e007aULL,
0x0000006e846e7210ULL, 0x000fc60007f3e0ffULL, 0x0000010075747825ULL, 0x100fe200078e007aULL,
0x0000007284727210ULL, 0x000fe40007f7e0ffULL, 0x0000006f856f7210ULL, 0x000fe20000ffe4ffULL,
0x0000010077767825ULL, 0x000fc800078e007aULL, 0x0000010079787825ULL, 0x000fe200078e007aULL,
0x0000007684767210ULL, 0x000fc60007f3e0ffULL, 0x00000100297a7825ULL, 0x000fe200078e007aULL,
0x0000007785777210ULL, 0x000fc60000ffe4ffULL, 0x00000001856d7824ULL, 0x040fe200000e066dULL,
0x0000007484747210ULL, 0x000fe20007f1e0ffULL, 0x0000001018297824ULL, 0x000fe400078e028bULL,
0x0000000185717824ULL, 0x040fe200010e0671ULL, 0x0000007884787210ULL, 0x000fe20007f5e0ffULL,
0x0000000185737824ULL, 0x040fe200018e0673ULL, 0x0000007a847a7210ULL, 0x000fe20007f7e0ffULL,
0x000000107e817824ULL, 0x000fe200078e028bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c297faeULL, 0x0003e2000b901c46ULL, 0x0000000185757824ULL, 0x000fc400000e0675ULL,
0x0000000185797824ULL, 0x040fe200010e0679ULL, 0x000000006e7d7faeULL, 0x0003e2000b901c46ULL,
0x00000010888b7824ULL, 0x000fe400078e028bULL, 0x00000001857b7824ULL, 0x000fe200018e067bULL,
0x00000000707f7faeULL, 0x0003e8000b901c46ULL, 0x0000000072817faeULL, 0x0003e8000b901c46ULL,
0x0000000074837faeULL, 0x0003e8000b901c46ULL, 0x0000000076877faeULL, 0x0003e8000b901c46ULL,
0x0000000078897faeULL, 0x0003e8000b901c46ULL, 0x000000007a8b7faeULL, 0x0003e4000b901c46ULL,
0xffffffe019187812ULL, 0x040fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001019297812ULL, 0x042fe400078ec0ffULL, 0x00000008192a7812ULL, 0x000fe400078ec0ffULL,
0x0000001d29297210ULL, 0x000fca0007ffe018ULL, 0x0000000129717824ULL, 0x000fc800078e022aULL,
0x01e6282b716e79a7ULL, 0x0002a6000850003fULL, 0x00000000002a7805ULL, 0x002fe20000015200ULL,
0x01e6286f710075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ff00707202ULL, 0x000fce0000000f00ULL, 0x000000107000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c2a297210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6c7824ULL, 0x000fe200000e0e2bULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff6c00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff6c00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc8000001146cULL, 0x0000002918187211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e066cULL, 0x0000000218187819ULL, 0x000fc80000001229ULL,
0x000000180000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000170707836ULL, 0x000fce0000000000ULL, 0x01e6286f710075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000524187819ULL, 0x000fc800000006ffULL,
0xffffff8018187812ULL, 0x000fc800078ec0ffULL, 0x000000801d187810ULL, 0x000fc80007ffe018ULL,
0x0000001812187210ULL, 0x000fca0007ffe013ULL, 0x01e00000186c7984ULL, 0x000e680000000800ULL,
0x01e20000182a7984ULL, 0x0004a20000000800ULL, 0x000000276c00720bULL, 0x002fda0003f1d000ULL,
0x00000000002b7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff2b00720cULL, 0x000fda0003f25270ULL, 0x0000000400949947ULL, 0x004fea0003800000ULL,
0x0000000124297811ULL, 0x000fe400078ff0ffULL, 0x000000276c00720bULL, 0x000fe40003f14000ULL,
0x000000242900720cULL, 0x000fd60003f25270ULL, 0x00000000006e7806ULL, 0x000fe400000e0100ULL,
0x0000008024299824ULL, 0x000fe200078e021dULL, 0x000000276c189209ULL, 0x000fe40007810000ULL,
0x000000ff6e00720cULL, 0x000fe40003f05270ULL, 0x0000002912299210ULL, 0x000fca0007ffe013ULL,
0x01e4001829009388ULL, 0x0003ec0000000800ULL, 0x0000000400548947ULL, 0x000fea0003800000ULL,
0x000000276c187209ULL, 0x002fe40007810000ULL, 0x000000ff6eff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff006eff7812ULL, 0x000fe2000782c0ffULL, 0x0000002718187221ULL, 0x000fe20000010100ULL,
0x00ff00006eff7812ULL, 0x040fe4000784c0ffULL, 0xff0000006eff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL, 0x0000001800707308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff297819ULL, 0x000fca000001161eULL,
0x00001f2970187589ULL, 0x006e6400000e0000ULL, 0x0000006818687220ULL, 0x042fe20000410000ULL,
0x0000006918697220ULL, 0x040fe20000410000ULL, 0x0000006418647220ULL, 0x040fe20000410000ULL,
0x0000006518657220ULL, 0x040fe20000410000ULL, 0x0000006018607220ULL, 0x040fe20000410000ULL,
0x0000006118617220ULL, 0x040fe20000410000ULL, 0x0000005c185c7220ULL, 0x040fe20000410000ULL,
0x0000005d185d7220ULL, 0x040fe20000410000ULL, 0x0000005818587220ULL, 0x040fe20000410000ULL,
0x0000005918597220ULL, 0x040fe20000410000ULL, 0x0000005418547220ULL, 0x040fe20000410000ULL,
0x0000005518557220ULL, 0x040fe20000410000ULL, 0x0000005018507220ULL, 0x040fe20000410000ULL,
0x0000005118517220ULL, 0x040fe20000410000ULL, 0x0000004c184c7220ULL, 0x040fe20000410000ULL,
0x0000004d184d7220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x000000081e297811ULL, 0x000fca00078ff0ffULL, 0x00001f2970187589ULL, 0x006e6400000e0000ULL,
0x0000006a186a7220ULL, 0x042fe20000410000ULL, 0x0000006b186b7220ULL, 0x040fe20000410000ULL,
0x0000006618667220ULL, 0x040fe20000410000ULL, 0x0000006718677220ULL, 0x040fe20000410000ULL,
0x0000006218627220ULL, 0x040fe20000410000ULL, 0x0000006318637220ULL, 0x040fe20000410000ULL,
0x0000005e185e7220ULL, 0x040fe20000410000ULL, 0x0000005f185f7220ULL, 0x040fe20000410000ULL,
0x0000005a185a7220ULL, 0x040fe20000410000ULL, 0x0000005b185b7220ULL, 0x040fe20000410000ULL,
0x0000005618567220ULL, 0x040fe20000410000ULL, 0x0000005718577220ULL, 0x040fe20000410000ULL,
0x0000005218527220ULL, 0x040fe20000410000ULL, 0x0000005318537220ULL, 0x040fe20000410000ULL,
0x0000004e184e7220ULL, 0x040fe20000410000ULL, 0x0000004f184f7220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000101e297811ULL, 0x000fca00078ff0ffULL,
0x00001f2970187589ULL, 0x006e6400000e0000ULL, 0x0000004818487220ULL, 0x042fe20000410000ULL,
0x0000004918497220ULL, 0x040fe20000410000ULL, 0x0000004418447220ULL, 0x040fe20000410000ULL,
0x0000004518457220ULL, 0x040fe20000410000ULL, 0x0000004018407220ULL, 0x040fe20000410000ULL,
0x0000004118417220ULL, 0x040fe20000410000ULL, 0x0000003c183c7220ULL, 0x040fe20000410000ULL,
0x0000003d183d7220ULL, 0x040fe20000410000ULL, 0x0000003818387220ULL, 0x040fe20000410000ULL,
0x0000003918397220ULL, 0x040fe20000410000ULL, 0x0000003418347220ULL, 0x040fe20000410000ULL,
0x0000003518357220ULL, 0x040fe20000410000ULL, 0x0000003018307220ULL, 0x040fe20000410000ULL,
0x0000003118317220ULL, 0x040fe20000410000ULL, 0x0000002c182c7220ULL, 0x040fe20000410000ULL,
0x0000002d182d7220ULL, 0x000fce0000410000ULL, 0x0000007025257220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x000000181e297811ULL, 0x000fca00078ff0ffULL,
0x00001f2970187589ULL, 0x002e6400000e0000ULL, 0x0000004a184a7220ULL, 0x042fe20000410000ULL,
0x0000004b184b7220ULL, 0x040fe20000410000ULL, 0x0000004618467220ULL, 0x040fe20000410000ULL,
0x0000004718477220ULL, 0x040fe20000410000ULL, 0x0000004218427220ULL, 0x040fe20000410000ULL,
0x0000004318437220ULL, 0x040fe20000410000ULL, 0x0000003e183e7220ULL, 0x040fe20000410000ULL,
0x0000003f183f7220ULL, 0x040fe20000410000ULL, 0x0000003a183a7220ULL, 0x040fe20000410000ULL,
0x0000003b183b7220ULL, 0x040fe20000410000ULL, 0x0000003618367220ULL, 0x040fe20000410000ULL,
0x0000003718377220ULL, 0x040fe20000410000ULL, 0x0000003218327220ULL, 0x040fe20000410000ULL,
0x0000003318337220ULL, 0x040fe20000410000ULL, 0x0000002e182e7220ULL, 0x040fe20000410000ULL,
0x0000002f182f7220ULL, 0x000fce0000410000ULL, 0x0000006e2bff7212ULL, 0x000fe400078030ffULL,
0x000000276c277209ULL, 0x000fd60007810000ULL, 0x800000276c6c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b6c6c0820ULL, 0x000fc80000410000ULL, 0x0000006c00110308ULL, 0x000ea40000000800ULL,
0x000000112a2a0220ULL, 0x004fce0000410000ULL, 0x0000200024297824ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000040024187824ULL, 0x000fe200078e00ffULL,
0xffffc000296c7812ULL, 0x000fc800078ec0ffULL, 0xfffff00018187812ULL, 0x000fe400078ec0ffULL,
0x0000006c1d6c7210ULL, 0x000fe40007ffe0ffULL, 0x000130001d187810ULL, 0x000fc60007ffe018ULL,
0x00002000152b7824ULL, 0x000fe400078e026cULL, 0x0000001010807824ULL, 0x000fe400078e0218ULL,
0x000170002b2b7836ULL, 0x000fe20000000000ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff6d7819ULL, 0x000fe4000001161eULL, 0x00000011ff07723eULL, 0x000fe400000010ffULL,
0x000000086d6f7810ULL, 0x000fe20007ffe0ffULL, 0x000000106d097836ULL, 0x000fe20000000000ULL,
0x00005410076c7816ULL, 0x000fe20000000007ULL, 0x000000186d717836ULL, 0x000fc80000000000ULL,
0x00001f6f6c0a7589ULL, 0x0002a800000e0000ULL, 0x00001f096c097589ULL, 0x0002e800000e0000ULL,
0x00001f6d6c077589ULL, 0x00026800000e0000ULL, 0x00001f716c087589ULL, 0x00026400000e0000ULL,
0x000000100f187824ULL, 0x000fe200078e0218ULL, 0x000000008080783bULL, 0x000ee20000000200ULL,
0x0000002b0d7c7211ULL, 0x000fe200078e20ffULL, 0x000000100e787824ULL, 0x100fe400078e022bULL,
0x00000000186c783bULL, 0x0022a20000000200ULL, 0x000000100c747824ULL, 0x000fe200078e022bULL,
0x0000000000208947ULL, 0x000fec0003800000ULL, 0x0000000780807232ULL, 0x088fe40000200000ULL,
0x0000000782827232ULL, 0x000fe40000200000ULL, 0x0000000a81817232ULL, 0x084fe40000200000ULL,
0x0000000a83837232ULL, 0x000fe40000200000ULL, 0x000000096c6c7232ULL, 0x080fe40000200000ULL,
0x000000096e6e7232ULL, 0x000fc40000200000ULL, 0x000000086d6d7232ULL, 0x080fe40000200000ULL,
0x000000086f6f7232ULL, 0x000fce0000200000ULL, 0x000000100b707824ULL, 0x000fe200078e022bULL,
0x000000007c7c783bULL, 0x000f220000004200ULL, 0x00000002ff867819ULL, 0x100fe40000011624ULL,
0x00000001ff187819ULL, 0x002fe20000011624ULL, 0x000000007878783bULL, 0x000fe40000004200ULL,
0x00001000862b7824ULL, 0x000fe200078e021dULL, 0x0000001d18887211ULL, 0x000fe200078e70ffULL,
0x000000007070783bULL, 0x000e640000004200ULL, 0x000130002b2b7836ULL, 0x000fc40000000000ULL,
0x000000007474783bULL, 0x000f620000004200ULL, 0x0000007c8068723cULL, 0x018fec0000041868ULL,
0x0000007e8064723cULL, 0x000fec0000041864ULL, 0x000000708050723cULL, 0x002fec0000041850ULL,
0x000000706c30723cULL, 0x004fec0000041830ULL, 0x000000788060723cULL, 0x000fe20000041860ULL,
0x0000200015717824ULL, 0x000fca00078e0288ULL, 0x0000007a805c723cULL, 0x000fe2000004185cULL,
0x0001700071717810ULL, 0x000fca0007ffe0ffULL, 0x000000748058723cULL, 0x020fec0000041858ULL,
0x000000768054723cULL, 0x000fec0000041854ULL, 0x00000072804c723cULL, 0x000fec000004184cULL,
0x0000007c6c48723cULL, 0x000fe20000041848ULL, 0x0000001006807824ULL, 0x000fc400078e022bULL,
0x00000010052b7824ULL, 0x000fc600078e022bULL, 0x0000007e6c44723cULL, 0x000fe20000041844ULL,
0x000000008080783bULL, 0x000e620000000200ULL, 0x00000010047c7824ULL, 0x000fc800078e0271ULL,
0x000000786c40723cULL, 0x000fec0000041840ULL, 0x0000007a6c3c723cULL, 0x000fe2000004183cULL,
0x0000007103787211ULL, 0x000fca00078e20ffULL, 0x000000746c38723cULL, 0x000fec0000041838ULL,
0x000000766c34723cULL, 0x000fe20000041834ULL, 0x0000001002747824ULL, 0x000fca00078e0271ULL,
0x000000726c2c723cULL, 0x000fe2000004182cULL, 0x000000002b6c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000208947ULL, 0x000fde0003800000ULL,
0x0000000780807232ULL, 0x082fe40000200000ULL, 0x0000000782827232ULL, 0x000fe40000200000ULL,
0x0000000a81817232ULL, 0x080fe40000200000ULL, 0x0000000a83837232ULL, 0x000fe40000200000ULL,
0x000000096c6c7232ULL, 0x088fe40000200000ULL, 0x000000096e6e7232ULL, 0x000fc40000200000ULL,
0x000000086d6d7232ULL, 0x080fe40000200000ULL, 0x000000086f6f7232ULL, 0x000fce0000200000ULL,
0x0000001000717824ULL, 0x000fe200078e0271ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x00000001ff2b7424ULL, 0x004fe400078e00ffULL, 0x000000252a257221ULL, 0x000fe20000010000ULL,
0x000000007878783bULL, 0x000fe80000004200ULL, 0x000000007170783bULL, 0x000ea80000004200ULL,
0x000000007474783bULL, 0x000f620000004200ULL, 0x0000007c6c48723cULL, 0x018fec0000041848ULL,
0x0000007e6c44723cULL, 0x000fec0000041844ULL, 0x000000708050723cULL, 0x006fec0000041850ULL,
0x000000706c30723cULL, 0x000fec0000041830ULL, 0x000000786c40723cULL, 0x000fe20000041840ULL,
0x0000000121717836ULL, 0x000fe20000000000ULL, 0x0000001d86707211ULL, 0x000fc800078e18ffULL,
0x0000007a6c3c723cULL, 0x000fe2000004183cULL, 0x0000001a7100720cULL, 0x000fe20003f06070ULL,
0x01e6902b70ff79a7ULL, 0x0003e8000850003fULL, 0x000000746c38723cULL, 0x020fec0000041838ULL,
0x000000766c34723cULL, 0x000fec0000041834ULL, 0x000000726c2c723cULL, 0x000fec000004182cULL,
0x0000007c8068723cULL, 0x000fe20000041868ULL, 0x00000008216f7824ULL, 0x000fca00078e0218ULL,
0x000000c06f6f7811ULL, 0x000fe200078e28ffULL, 0x0000007e8064723cULL, 0x000fe60000041864ULL,
0x000000606f6d7812ULL, 0x000fc600078ec0ffULL, 0x000000788060723cULL, 0x000fec0000041860ULL,
0x0000007a805c723cULL, 0x000fec000004185cULL, 0x000000748058723cULL, 0x000fe20000041858ULL,
0x00000001167b7824ULL, 0x000fca00078e026dULL, 0x000000768054723cULL, 0x000fec0000041854ULL,
0x00000072804c723cULL, 0x000fe2000004184cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400908947ULL, 0x002fde0003800000ULL,
0x00000003ff7a7819ULL, 0x100fe2000001161eULL, 0x000000ffff2a7224ULL, 0x000fe200078e0a6fULL,
0x00002000296d7812ULL, 0x000fe400078ec0ffULL, 0x000000047a6e7810ULL, 0x000fe20007ffe0ffULL,
0x000000087a7e7836ULL, 0x000fe20000000000ULL, 0x0000006f1c297248ULL, 0x000fe20007fe0000ULL,
0x0000001c7a8a7836ULL, 0x000fe20000000000ULL, 0x00000007246c7819ULL, 0x000fe200000006ffULL,
0x000000016e6f7824ULL, 0x000fe200078e021eULL, 0x00017000887d7810ULL, 0x000fe20007ffe06dULL,
0x000000086e7c7824ULL, 0x040fe200078e00ffULL, 0x0000002029297446ULL, 0x000fe2000380002aULL,
0x000000ffff6d7224ULL, 0x000fe200078e00ffULL, 0x00000080136c7812ULL, 0x000fe200078ef86cULL,
0x000000016e717824ULL, 0x100fe200078e027bULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee26fULL,
0x000000017a6f7824ULL, 0x100fe200078e027bULL, 0x000000296e00720cULL, 0x080fe20003f26070ULL,
0x000000017e737824ULL, 0x000fe200078e027bULL, 0x0000000c7a807810ULL, 0x000fe20007ffe0ffULL,
0x000001006f6e7825ULL, 0x000fe200078e006cULL, 0x000000297a00720cULL, 0x000fc40003f06070ULL,
0x0000007b80757210ULL, 0x000fe20007ffe0ffULL, 0x000000017a2a7824ULL, 0x000fe200078e021eULL,
0x0000006e84767210ULL, 0x000fe20007f5e0ffULL, 0x0000010073727825ULL, 0x100fe200078e006cULL,
0x000000147a827810ULL, 0x000fe40007ffe0ffULL, 0x000000072a797812ULL, 0x000fe200078ec0ffULL,
0x0000010071707825ULL, 0x000fe200078e006cULL, 0x000000297e00720cULL, 0x080fe40003fa6070ULL,
0x0ffffff8792a7812ULL, 0x000fe200078ef81eULL, 0x0000000185777824ULL, 0x000fe200010e066fULL,
0x00000072846e7210ULL, 0x000fe20007f5e0ffULL, 0x000000107c817824ULL, 0x000fe200078e027dULL,
0x0000007084787210ULL, 0x000fe20007f7e0ffULL, 0x000000107a7c7836ULL, 0x000fe20000000000ULL,
0x00000073856f7210ULL, 0x000fe200017fe4ffULL, 0x0000010075747825ULL, 0x000fe200078e006cULL,
0x000000298000720cULL, 0x000fc40003f86070ULL, 0x0000007b7c737210ULL, 0x000fe20007ffe0ffULL,
0x0000000185797824ULL, 0x000fe200018e0671ULL, 0x0000007484707210ULL, 0x000fe20007f7e0ffULL,
0x000000102a7f7824ULL, 0x000fe200078e027dULL, 0x000000298200720cULL, 0x000fe20003f46070ULL,
0x0000010073727825ULL, 0x000fc600078e006cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000767f7faeULL, 0x0003e2000c101c46ULL, 0x0000000185717824ULL, 0x000fe200018e0675ULL,
0x0000007284747210ULL, 0x000fe20007fde0ffULL, 0x0000000180757824ULL, 0x100fe200078e021eULL,
0x0000000078817faeULL, 0x0005e2000c901c46ULL, 0x000000187a887836ULL, 0x000fe20000000000ULL,
0x000000297c00720cULL, 0x0c0fe20003f66070ULL, 0x000000087c7a7824ULL, 0x000fe200078e00ffULL,
0x000000298a00720cULL, 0x080fe20003f06070ULL, 0x000000017e2a7824ULL, 0x000fe200078e021eULL,
0x000000298800720cULL, 0x040fe20003f26070ULL, 0x0000000188297824ULL, 0x000fe200078e027bULL,
0x0000007b82777210ULL, 0x002fe20007ffe0ffULL, 0x000000087e837824ULL, 0x000fc400078e00ffULL,
0x00000008887e7824ULL, 0x000fe200078e00ffULL, 0x0000001e82797210ULL, 0x004fe20007ffe0ffULL,
0x0000000880787824ULL, 0x000fe200078e00ffULL, 0xfffffff8832a7812ULL, 0x000fe400078ee22aULL,
0x000000038a807819ULL, 0x000fe400000006ffULL, 0xfffffff878787812ULL, 0x000fe200078ee275ULL,
0x0000000185757824ULL, 0x000fe400030e0673ULL, 0x0000010077727825ULL, 0x000fc800078e006cULL,
0x000000017c777824ULL, 0x000fe200078e021eULL, 0x0000007284767210ULL, 0x000fe20007fde0ffULL,
0x00000008827c7824ULL, 0x000fc600078e00ffULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee277ULL,
0x0000000185777824ULL, 0x000fe200030e0673ULL, 0xfffffff87c7c7812ULL, 0x000fe200078ee279ULL,
0x0000010029727825ULL, 0x000fe200078e006cULL, 0x0000007b8a797210ULL, 0x000fc60007ffe0ffULL,
0x0000000188297824ULL, 0x100fe200078e021eULL, 0x0000007284727210ULL, 0x000fe20007fde0ffULL,
0x000000018a7b7824ULL, 0x000fe400078e021eULL, 0x00000100796c7825ULL, 0x000fe200078e006cULL,
0xfffffff87e7e7812ULL, 0x000fe400078ee229ULL, 0xfffffff880807812ULL, 0x000fe200078ee27bULL,
0x0000000185737824ULL, 0x000fe200030e0673ULL, 0x0000006c846c7210ULL, 0x000fe20007fde0ffULL,
0x000000102a297824ULL, 0x100fe200078e027dULL, 0x0000007d7a7b7211ULL, 0x000fe200078e20ffULL,
0x0000001078797824ULL, 0x100fe200078e027dULL, 0x0000006d856d7210ULL, 0x000fe200037fe4ffULL,
0x000000107c7f7824ULL, 0x100fe200078e027dULL, 0x000000006e297faeULL, 0x0003e2000e901c46ULL,
0x000000107e817824ULL, 0x000fc400078e027dULL, 0x00000010807d7824ULL, 0x000fe200078e027dULL,
0x0000000070797faeULL, 0x0003e8000e101c46ULL, 0x00000000747b7faeULL, 0x0003e8000d901c46ULL,
0x00000000767f7faeULL, 0x0003e8000d101c46ULL, 0x0000000072817faeULL, 0x0003e8000c901c46ULL,
0x000000006c7d7faeULL, 0x0003e2000c101c46ULL, 0x00000004005c7947ULL, 0x000fea0003800000ULL,
0x000000041e6f7811ULL, 0x000fe200078fe8ffULL, 0x00000080247a7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e737811ULL, 0x040fe400078fe8ffULL, 0x0000200029297812ULL, 0x000fe200078ec0ffULL,
0x000000016f2a7824ULL, 0x140fe200078e021eULL, 0x000000081e717811ULL, 0x040fe200078fe8ffULL,
0x000000086f7f7824ULL, 0x000fe200078e00ffULL, 0x000000141e777811ULL, 0x000fe200078fe8ffULL,
0x0000000873837824ULL, 0x000fe200078e00ffULL, 0x0001700088887810ULL, 0x000fe20007ffe029ULL,
0x0000000171297824ULL, 0x100fe200078e021eULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee22aULL,
0x00000001732a7824ULL, 0x100fe200078e021eULL, 0x000000101e757811ULL, 0x040fe200078fe8ffULL,
0x00000001776d7824ULL, 0x100fe200078e021eULL, 0x00000003716e7819ULL, 0x000fe200000006ffULL,
0x0000000877707824ULL, 0x000fe200078e00ffULL, 0xfffffff883837812ULL, 0x000fe200078ee22aULL,
0x00000001756c7824ULL, 0x040fe200078e021eULL, 0x0000000375877819ULL, 0x000fe200000006ffULL,
0x0000000171717824ULL, 0x100fe200078e027bULL, 0xfffffff86e817812ULL, 0x000fe200078ee229ULL,
0x0000000173737824ULL, 0x100fe200078e027bULL, 0xfffffff870897812ULL, 0x000fe200078ee26dULL,
0x0000000175757824ULL, 0x100fe200078e027bULL, 0x000000181e2a7811ULL, 0x040fe200078fe8ffULL,
0x000000107f7f7824ULL, 0x100fe200078e0288ULL, 0x0000001e1e297211ULL, 0x040fe200078fe8ffULL,
0x0000001081817824ULL, 0x000fe200078e0288ULL, 0x0000001c1e6d7811ULL, 0x000fe200078fe8ffULL,
0x000000012a797824ULL, 0x140fe200078e027bULL, 0xfffffff887877812ULL, 0x000fe200078ee26cULL,
0x000000012a6c7824ULL, 0x040fe200078e021eULL, 0x00000007297d7812ULL, 0x000fe200078ec0ffULL,
0x000000082a8b7824ULL, 0x000fe200078e00ffULL, 0x0000001e6d2a7210ULL, 0x000fe20007ffe0ffULL,
0x000000086d8d7824ULL, 0x040fe200078e00ffULL, 0x00000080137a7812ULL, 0x000fe200078ef87aULL,
0x000000016d297824ULL, 0x000fe200078e027bULL, 0x0000007b6f6f7210ULL, 0x000fe20007ffe0ffULL,
0x0000001083837824ULL, 0x100fe200078e0288ULL, 0x0000007b77777210ULL, 0x000fe20007ffe0ffULL,
0x0000001089897824ULL, 0x000fe200078e0288ULL, 0x0000007b1e6d7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff7b7224ULL, 0x000fe200078e00ffULL, 0xfffffff88b8b7812ULL, 0x000fc400078ee26cULL,
0x0ffffff87d7d7812ULL, 0x000fe200078ef81eULL, 0x000001006f6e7825ULL, 0x100fe200078e007aULL,
0xfffffff88d8d7812ULL, 0x000fe400078ee22aULL, 0x000000887d7d7211ULL, 0x080fe200078e20ffULL,
0x000001006d6c7825ULL, 0x100fe200078e007aULL, 0x0000006e846e7210ULL, 0x000fe40007f3e0ffULL,
0x0000008887877211ULL, 0x000fe200078e20ffULL, 0x0000010071707825ULL, 0x000fe200078e007aULL,
0x0000006c846c7210ULL, 0x000fc60007f1e0ffULL, 0x0000010073727825ULL, 0x100fe200078e007aULL,
0x0000007084707210ULL, 0x000fe40007f5e0ffULL, 0x0000006d856d7210ULL, 0x000fe200007fe4ffULL,
0x0000010075747825ULL, 0x000fe200078e007aULL, 0x0000007284727210ULL, 0x000fc60007f7e0ffULL,
0x0000010077767825ULL, 0x100fe200078e007aULL, 0x0000007484747210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c7d7faeULL, 0x0003e4000b901c46ULL,
0x0000010079787825ULL, 0x000fe200078e007aULL, 0x0000007585757210ULL, 0x000fc600007fe4ffULL,
0x00000100297a7825ULL, 0x000fc800078e007aULL, 0x00000001856f7824ULL, 0x040fe200008e066fULL,
0x0000007684767210ULL, 0x000fe20007f3e0ffULL, 0x0000000185717824ULL, 0x040fe200010e0671ULL,
0x0000007884787210ULL, 0x000fe20007f5e0ffULL, 0x0000000185737824ULL, 0x040fe200018e0673ULL,
0x0000007a847a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000185777824ULL, 0x000fe200008e0677ULL,
0x000000006e7f7faeULL, 0x0003e2000b901c46ULL, 0x000000108b8b7824ULL, 0x100fe400078e0288ULL,
0x0000000185797824ULL, 0x000fe200010e0679ULL, 0x0000000070817faeULL, 0x0003e2000b901c46ULL,
0x000000108d8d7824ULL, 0x000fc400078e0288ULL, 0x00000001857b7824ULL, 0x000fe200018e067bULL,
0x0000000072837faeULL, 0x0003e8000b901c46ULL, 0x0000000074877faeULL, 0x0003e8000b901c46ULL,
0x0000000076897faeULL, 0x0003e8000b901c46ULL, 0x00000000788b7faeULL, 0x0003e8000b901c46ULL,
0x000000007a8d7faeULL, 0x0003e4000b901c46ULL, 0x0000000123297812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff282a7811ULL, 0x000fe400078e08ffULL,
0x000000012900780cULL, 0x000fc80003f05070ULL, 0x000000012a2a7807ULL, 0x000fc80004000000ULL,
0x0000002a232a7210ULL, 0x000fe20007ffe0ffULL, 0x0000002086867824ULL, 0x000fe200078e021dULL,
0x00000010196e7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff237424ULL, 0x000fe200078e00ffULL,
0x0000001b2a00720cULL, 0x000fda0003f06070ULL, 0x00009200ff6c8b82ULL, 0x000e620000000a00ULL,
0x000000012a298824ULL, 0x000fc800078e0214ULL, 0x00000004296c8825ULL, 0x002fe200078e006cULL,
0x0000000819297812ULL, 0x000fc800078ec0ffULL, 0x0000008629297210ULL, 0x000fe20007ffe06eULL,
0x000000066c238981ULL, 0x000326000c1e1900ULL, 0x01e6482b297079a7ULL, 0x0002a6000850003fULL,
0x00000000006c7805ULL, 0x002fce0000015200ULL, 0x01e64871290075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ff00727202ULL, 0x000fce0000000f00ULL,
0x000000107200780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000006e7805ULL, 0x000fce0000015200ULL, 0x0000006e6c6e7210ULL, 0x000fca0007f1e1ffULL,
0x000000016f6f7824ULL, 0x000fe200000e0e6dULL, 0x003d09006e00780cULL, 0x000fc80003f06070ULL,
0x000000ff6f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c406e00780cULL, 0x000fc80003f06070ULL, 0x000000ff6f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2b7819ULL, 0x000fc8000001146fULL,
0x0000006e2b2b7211ULL, 0x000fca00078110ffULL, 0x000000ffff6e7224ULL, 0x000fca00000e066fULL,
0x000000022b2b7819ULL, 0x000fc8000000126eULL, 0x0000002b0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000172727836ULL, 0x000fce0000000000ULL,
0x01e64871290075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000524297819ULL, 0x000fc800000006ffULL, 0xffffff80296c7812ULL, 0x000fc800078ec0ffULL,
0x000001001d297810ULL, 0x000fc80007ffe06cULL, 0x0000002912297210ULL, 0x000fca0007ffe013ULL,
0x01e00000296c7984ULL, 0x000e680000000800ULL, 0x01e2000029867984ULL, 0x0004a20000000800ULL,
0x000000276c00720bULL, 0x002fda0003f1d000ULL, 0x00000000002b7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff2b00720cULL, 0x000fda0003f25270ULL,
0x0000000400949947ULL, 0x004fea0003800000ULL, 0x0000000224297811ULL, 0x000fe400078ff0ffULL,
0x000000276c00720bULL, 0x000fe40003f14000ULL, 0x000000242900720cULL, 0x000fd60003f25270ULL,
0x00000000006e7806ULL, 0x000fe400000e0100ULL, 0x00000080246d9824ULL, 0x000fe200078e021dULL,
0x000000276c299209ULL, 0x000fe40007810000ULL, 0x000000ff6e00720cULL, 0x000fe40003f05270ULL,
0x0000006d12709210ULL, 0x000fca0007ffe013ULL, 0x01e4002970009388ULL, 0x0003ec0000000800ULL,
0x0000000400548947ULL, 0x000fea0003800000ULL, 0x000000276c707209ULL, 0x002fe40007810000ULL,
0x000000ff6eff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff006eff7812ULL, 0x000fe2000782c0ffULL,
0x0000002770297221ULL, 0x000fe20000010100ULL, 0x00ff00006eff7812ULL, 0x040fe4000784c0ffULL,
0xff0000006eff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL,
0x0000002900707308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff297819ULL, 0x002fcc000001161eULL, 0x00001f2970297589ULL, 0x004e6400000e0000ULL,
0x0000006829687220ULL, 0x042fe20000410000ULL, 0x0000006929697220ULL, 0x040fe20000410000ULL,
0x0000006429647220ULL, 0x040fe20000410000ULL, 0x0000006529657220ULL, 0x040fe20000410000ULL,
0x0000006029607220ULL, 0x040fe20000410000ULL, 0x0000006129617220ULL, 0x040fe20000410000ULL,
0x0000005c295c7220ULL, 0x040fe20000410000ULL, 0x0000005d295d7220ULL, 0x040fe20000410000ULL,
0x0000005829587220ULL, 0x040fe20000410000ULL, 0x0000005929597220ULL, 0x040fe20000410000ULL,
0x0000005429547220ULL, 0x040fe20000410000ULL, 0x0000005529557220ULL, 0x040fe20000410000ULL,
0x0000005029507220ULL, 0x040fe20000410000ULL, 0x0000005129517220ULL, 0x040fe20000410000ULL,
0x0000004c294c7220ULL, 0x040fe20000410000ULL, 0x0000004d294d7220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x000000081e297811ULL, 0x002fcc00078ff0ffULL,
0x00001f2970297589ULL, 0x004e6400000e0000ULL, 0x0000006a296a7220ULL, 0x042fe20000410000ULL,
0x0000006b296b7220ULL, 0x040fe20000410000ULL, 0x0000006629667220ULL, 0x040fe20000410000ULL,
0x0000006729677220ULL, 0x040fe20000410000ULL, 0x0000006229627220ULL, 0x040fe20000410000ULL,
0x0000006329637220ULL, 0x040fe20000410000ULL, 0x0000005e295e7220ULL, 0x040fe20000410000ULL,
0x0000005f295f7220ULL, 0x040fe20000410000ULL, 0x0000005a295a7220ULL, 0x040fe20000410000ULL,
0x0000005b295b7220ULL, 0x040fe20000410000ULL, 0x0000005629567220ULL, 0x040fe20000410000ULL,
0x0000005729577220ULL, 0x040fe20000410000ULL, 0x0000005229527220ULL, 0x040fe20000410000ULL,
0x0000005329537220ULL, 0x040fe20000410000ULL, 0x0000004e294e7220ULL, 0x040fe20000410000ULL,
0x0000004f294f7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000101e297811ULL, 0x002fcc00078ff0ffULL, 0x00001f2970297589ULL, 0x004e6400000e0000ULL,
0x0000004829487220ULL, 0x042fe20000410000ULL, 0x0000004929497220ULL, 0x040fe20000410000ULL,
0x0000004429447220ULL, 0x040fe20000410000ULL, 0x0000004529457220ULL, 0x040fe20000410000ULL,
0x0000004029407220ULL, 0x040fe20000410000ULL, 0x0000004129417220ULL, 0x040fe20000410000ULL,
0x0000003c293c7220ULL, 0x040fe20000410000ULL, 0x0000003d293d7220ULL, 0x040fe20000410000ULL,
0x0000003829387220ULL, 0x040fe20000410000ULL, 0x0000003929397220ULL, 0x040fe20000410000ULL,
0x0000003429347220ULL, 0x040fe20000410000ULL, 0x0000003529357220ULL, 0x040fe20000410000ULL,
0x0000003029307220ULL, 0x040fe20000410000ULL, 0x0000003129317220ULL, 0x040fe20000410000ULL,
0x0000002c292c7220ULL, 0x040fe20000410000ULL, 0x0000002d292d7220ULL, 0x000fce0000410000ULL,
0x0000007025257220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x000000181e297811ULL, 0x002fcc00078ff0ffULL, 0x00001f2970297589ULL, 0x000e6400000e0000ULL,
0x0000004a294a7220ULL, 0x042fe20000410000ULL, 0x0000004b294b7220ULL, 0x040fe20000410000ULL,
0x0000004629467220ULL, 0x040fe20000410000ULL, 0x0000004729477220ULL, 0x040fe20000410000ULL,
0x0000004229427220ULL, 0x040fe20000410000ULL, 0x0000004329437220ULL, 0x040fe20000410000ULL,
0x0000003e293e7220ULL, 0x040fe20000410000ULL, 0x0000003f293f7220ULL, 0x040fe20000410000ULL,
0x0000003a293a7220ULL, 0x040fe20000410000ULL, 0x0000003b293b7220ULL, 0x040fe20000410000ULL,
0x0000003629367220ULL, 0x040fe20000410000ULL, 0x0000003729377220ULL, 0x040fe20000410000ULL,
0x0000003229327220ULL, 0x040fe20000410000ULL, 0x0000003329337220ULL, 0x040fe20000410000ULL,
0x0000002e292e7220ULL, 0x040fe20000410000ULL, 0x0000002f292f7220ULL, 0x000fce0000410000ULL,
0x0000006e2bff7212ULL, 0x000fe400078030ffULL, 0x000000276c277209ULL, 0x000fd60007810000ULL,
0x800000276c6c0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b6c6c0820ULL, 0x000fc80000410000ULL,
0x0000006c00110308ULL, 0x000ea40000000800ULL, 0x0000001186860220ULL, 0x004fce0000410000ULL,
0x0000400018847824ULL, 0x000fe200078e021dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000040024297824ULL, 0x002fe200078e00ffULL, 0x00000084152b7211ULL, 0x000fc800078e68ffULL,
0xfffff000296c7812ULL, 0x000fe200078ec0ffULL, 0x000160002b857836ULL, 0x000fc60000000000ULL,
0x000140001d297810ULL, 0x000fe20007ffe06cULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff6c7819ULL, 0x000fe4000001161eULL, 0x00000011ff07723eULL, 0x000fe400000010ffULL,
0x000000186c087810ULL, 0x000fe20007ffe0ffULL, 0x000000086c0a7836ULL, 0x000fe20000000000ULL,
0x00005410072b7816ULL, 0x000fe20000000007ULL, 0x000000106c6e7836ULL, 0x000fc80000000000ULL,
0x00001f0a2b0a7589ULL, 0x0002a800000e0000ULL, 0x00001f6e2b097589ULL, 0x0002e800000e0000ULL,
0x00001f6c2b077589ULL, 0x00026800000e0000ULL, 0x00001f082b087589ULL, 0x00026400000e0000ULL,
0x0000001010707824ULL, 0x100fe200078e0229ULL, 0x000000850e787211ULL, 0x000fe200078e20ffULL,
0x000000100f297824ULL, 0x000fe400078e0229ULL, 0x000000100d747824ULL, 0x100fe400078e0285ULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0x000000100c7c7824ULL, 0x000fc600078e0285ULL,
0x00000000296c783bULL, 0x0022a20000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x088fe40000200000ULL, 0x0000000772727232ULL, 0x000fe40000200000ULL,
0x0000000a71717232ULL, 0x084fe40000200000ULL, 0x0000000a73737232ULL, 0x000fe40000200000ULL,
0x000000096c6c7232ULL, 0x080fe40000200000ULL, 0x000000096e6e7232ULL, 0x000fc40000200000ULL,
0x000000086d6d7232ULL, 0x080fe40000200000ULL, 0x000000086f6f7232ULL, 0x000fce0000200000ULL,
0x000000100b807824ULL, 0x000fe200078e0285ULL, 0x000000007474783bULL, 0x000f620000004200ULL,
0x00000002ff887819ULL, 0x000fc60000011624ULL, 0x000000007878783bULL, 0x000fe40000004200ULL,
0x0000100088297824ULL, 0x002fe400078e021dULL, 0x000000008080783bULL, 0x000e660000004200ULL,
0x0001400029297810ULL, 0x000fe20007ffe0ffULL, 0x000000007c7c783bULL, 0x000e620000004200ULL,
0x000000746c48723cULL, 0x024fec0000041848ULL, 0x000000766c44723cULL, 0x000fec0000041844ULL,
0x000000807050723cULL, 0x00afec0000041850ULL, 0x00000082704c723cULL, 0x000fec000004184cULL,
0x000000806c30723cULL, 0x000fec0000041830ULL, 0x000000786c40723cULL, 0x000fec0000041840ULL,
0x0000007a6c3c723cULL, 0x000fec000004183cULL, 0x0000007c6c38723cULL, 0x000fec0000041838ULL,
0x0000007e6c34723cULL, 0x000fec0000041834ULL, 0x000000826c80723cULL, 0x000fec000004182cULL,
0x000000747068723cULL, 0x000fe20000041868ULL, 0x00000010066c7824ULL, 0x000fc400078e0229ULL,
0x0000001005297824ULL, 0x000fc600078e0229ULL, 0x000000767064723cULL, 0x000fe20000041864ULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x0000008503747211ULL, 0x000fc600078e20ffULL,
0x00000000292c783bULL, 0x0004e20000000200ULL, 0x000000787060723cULL, 0x000fec0000041860ULL,
0x0000007a705c723cULL, 0x000fe2000004185cULL, 0x0000001002787824ULL, 0x000fca00078e0285ULL,
0x0000007c7058723cULL, 0x000fec0000041858ULL, 0x0000007e7054723cULL, 0x000fee0000041854ULL,
0x0000001004707824ULL, 0x000fe200078e0285ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000208947ULL, 0x004fde0003800000ULL, 0x000000076c6c7232ULL, 0x082fe40000200000ULL,
0x000000076e6e7232ULL, 0x000fe40000200000ULL, 0x0000000a6d6d7232ULL, 0x080fe40000200000ULL,
0x0000000a6f6f7232ULL, 0x000fe40000200000ULL, 0x000000092c2c7232ULL, 0x088fe40000200000ULL,
0x000000092e2e7232ULL, 0x000fc40000200000ULL, 0x000000082d2d7232ULL, 0x080fe40000200000ULL,
0x000000082f2f7232ULL, 0x000fce0000200000ULL, 0x00000010007c7824ULL, 0x000fe200078e0285ULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0x00000001282b7824ULL, 0x000fe400078e0221ULL,
0x0000002586257221ULL, 0x000fe20000010000ULL, 0x00000001ff297424ULL, 0x000fe200078e00ffULL,
0x000000007474783bULL, 0x000f620000004200ULL, 0x0000001a2b00720cULL, 0x000fc60003f06070ULL,
0x000000007878783bULL, 0x000f680000004200ULL, 0x000000007c7c783bULL, 0x000f620000004200ULL,
0x000000706c68723cULL, 0x006fec0000041868ULL, 0x000000726c64723cULL, 0x000fec0000041864ULL,
0x000000746c60723cULL, 0x028fec0000041860ULL, 0x000000766c5c723cULL, 0x000fec000004185cULL,
0x000000786c58723cULL, 0x000fec0000041858ULL, 0x0000007a6c54723cULL, 0x000fec0000041854ULL,
0x0000007c6c50723cULL, 0x000fec0000041850ULL, 0x0000007e6c4c723cULL, 0x000fec000004184cULL,
0x000000702c48723cULL, 0x000fe20000041848ULL, 0x0000001d886c7211ULL, 0x000fc800078e18ffULL,
0x01e698296cff79a7ULL, 0x0003e2000850003fULL, 0x000000722c44723cULL, 0x000fec0000041844ULL,
0x000000742c40723cULL, 0x000fec0000041840ULL, 0x000000762c3c723cULL, 0x000fec000004183cULL,
0x000000782c38723cULL, 0x000fec0000041838ULL, 0x0000007a2c34723cULL, 0x000fec0000041834ULL,
0x0000007c2c30723cULL, 0x000fec0000041830ULL, 0x0000007e2c2c723cULL, 0x000fe20000041880ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000c00200947ULL, 0x002fde0003800000ULL, 0x00009000ff6c7b82ULL, 0x000e620000000a00ULL,
0x000001002b6f7824ULL, 0x000fe200078e0217ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x000000012b2b7836ULL, 0x000fe40000000000ULL, 0x00000004236e7c24ULL, 0x010fc6000f8e02ffULL,
0x0000001a2b00720cULL, 0x000fe40003f06070ULL, 0x000000606f2b7812ULL, 0x000fe400078ec0ffULL,
0x000000076e717819ULL, 0x000fc600000006ffULL, 0x00000001167d7824ULL, 0x000fe400078e022bULL,
0x00000100716c7825ULL, 0x002fc800078e006cULL, 0x0000000400948947ULL, 0x000fea0003800000ULL,
0x00000003ff7c7819ULL, 0x100fe2000001161eULL, 0x0000200024707824ULL, 0x000fe200078e00ffULL,
0x0000006f1c2b7248ULL, 0x000fe40007fe0000ULL, 0x000000ff6f6e7210ULL, 0x000fe20007ffe1ffULL,
0x000000047c727836ULL, 0x000fe20000000000ULL, 0x00002000706f7812ULL, 0x000fe200078ec0ffULL,
0x0000008024707824ULL, 0x000fe200078e00ffULL, 0x000000202b2b7446ULL, 0x000fe2000380006eULL,
0x0000000172717824ULL, 0x000fe200078e021eULL, 0x0001600084847810ULL, 0x000fe20007ffe06fULL,
0x0000000872747824ULL, 0x000fe200078e00ffULL, 0x0000001e7c6f7210ULL, 0x000fe20007ffe0ffULL,
0x000000087c7e7836ULL, 0x000fe20000000000ULL, 0x00000080136e7812ULL, 0x000fe200078ef870ULL,
0x0000000c7c807836ULL, 0x000fe20000000000ULL, 0xfffffff874817812ULL, 0x000fe200078ee271ULL,
0x000000017c717824ULL, 0x100fe200078e027dULL, 0x000000076f7b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff6f7224ULL, 0x000fe200078e00ffULL, 0x0000007d72737210ULL, 0x000fe20007ffe0ffULL,
0x000000017e757824ULL, 0x000fe200078e027dULL, 0x0000002b7200720cULL, 0x080fe20003f26070ULL,
0x0000010071707825ULL, 0x000fe200078e006eULL, 0x0000002b7c00720cULL, 0x000fc40003f06070ULL,
0x0000008481817211ULL, 0x000fe200078e20ffULL, 0x0000010075747825ULL, 0x100fe200078e006eULL,
0x000000706c787210ULL, 0x000fe40007f5e0ffULL, 0x0000002b7e00720cULL, 0x000fe20003fa6070ULL,
0x0000010073727825ULL, 0x000fe200078e006eULL, 0x000000716d797210ULL, 0x000fe400017fe4ffULL,
0x0ffffff87b717812ULL, 0x000fe200078ef81eULL, 0x0000000180777824ULL, 0x000fe200078e027dULL,
0x000000746c707210ULL, 0x000fe20007f5e0ffULL, 0x000000107c827836ULL, 0x000fe20000000000ULL,
0x000000726c7a7210ULL, 0x000fe20007f7e0ffULL, 0x0000010077767825ULL, 0x000fe200078e006eULL,
0x000000187c8a7810ULL, 0x000fc40007ffe0ffULL, 0x0000002b8000720cULL, 0x080fe20003f86070ULL,
0x00000010717f7824ULL, 0x000fe400078e0284ULL, 0x000000016d717824ULL, 0x040fe400010e0675ULL,
0x000000016d7b7824ULL, 0x000fe200018e0673ULL, 0x000000766c727210ULL, 0x000fe20007f7e0ffULL,
0x0000000182757824ULL, 0x000fe200078e027dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000787f7faeULL, 0x0003e2000c101c46ULL, 0x000000147c867836ULL, 0x000fe40000000000ULL,
0x0000010075747825ULL, 0x000fe200078e006eULL, 0x000000007a817faeULL, 0x0005e2000c901c46ULL,
0x0000002b8a00720cULL, 0x000fc40003f26070ULL, 0x000000016d737824ULL, 0x000fe200018e0677ULL,
0x000000746c767210ULL, 0x000fe20007fde0ffULL, 0x000000017e777824ULL, 0x140fe200078e021eULL,
0x000000037e7e7819ULL, 0x000fe200000006ffULL, 0x0000001c7c7c7836ULL, 0x000fe20000000000ULL,
0x0000002b8200720cULL, 0x080fe20003f66070ULL, 0x0000000186797824ULL, 0x002fe200078e027dULL,
0xfffffff87e7f7812ULL, 0x000fe200078ee277ULL, 0x0000000180787824ULL, 0x040fe200078e021eULL,
0x000000756d777210ULL, 0x000fe200037fe4ffULL, 0x0000000880817824ULL, 0x004fe200078e00ffULL,
0x0000002b8600720cULL, 0x080fe20003f46070ULL, 0x0000010079747825ULL, 0x000fe200078e006eULL,
0x0000002b7c00720cULL, 0x000fc40003f06070ULL, 0xfffffff881817812ULL, 0x000fe200078ee278ULL,
0x0000000182797824ULL, 0x140fe200078e021eULL, 0x000000746c787210ULL, 0x000fe20007fde0ffULL,
0x0000000882827824ULL, 0x000fe200078e00ffULL, 0x0000000386857819ULL, 0x000fe200000006ffULL,
0x000000018a2b7824ULL, 0x000fe400078e027dULL, 0x00000001867a7824ULL, 0x000fe200078e021eULL,
0xfffffff882837812ULL, 0x000fe200078ee279ULL, 0x000000016d797824ULL, 0x000fe400030e0675ULL,
0x000001002b747825ULL, 0x000fe200078e006eULL, 0x0000001e8a2b7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff885857812ULL, 0x000fe200078ee27aULL, 0x000000017c7b7824ULL, 0x000fe200078e027dULL,
0x000000746c747210ULL, 0x000fe20007fde0ffULL, 0x000000088a8a7824ULL, 0x000fe200078e00ffULL,
0x0000008485857211ULL, 0x000fe200078e20ffULL, 0x000000017c7a7824ULL, 0x040fe200078e021eULL,
0x000000756d757210ULL, 0x000fe200037fe4ffULL, 0x000000087c7d7824ULL, 0x000fe200078e00ffULL,
0xfffffff88a2b7812ULL, 0x000fe200078ee22bULL, 0x000001007b6e7825ULL, 0x000fc600078e006eULL,
0xfffffff87d7b7812ULL, 0x000fe200078ee27aULL, 0x000000107f7f7824ULL, 0x100fe200078e0284ULL,
0x0000006e6c6c7210ULL, 0x000fe20007fde0ffULL, 0x0000001081817824ULL, 0x100fe400078e0284ULL,
0x0000001083837824ULL, 0x100fe200078e0284ULL, 0x00000000707f7faeULL, 0x0003e2000e901c46ULL,
0x000000102b2b7824ULL, 0x100fe400078e0284ULL, 0x000000107b7b7824ULL, 0x000fe200078e0284ULL,
0x0000000072817faeULL, 0x0003e2000e101c46ULL, 0x000000016d6d7824ULL, 0x000fc600030e066fULL,
0x0000000076837faeULL, 0x0003e8000d901c46ULL, 0x0000000078857faeULL, 0x0003e8000d101c46ULL,
0x00000000742b7faeULL, 0x0003e8000c901c46ULL, 0x000000006c7b7faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x000000041e717811ULL, 0x000fe200078fe8ffULL,
0x00000080247c7824ULL, 0x040fe200078e00ffULL, 0x0000000d242b7819ULL, 0x000fe400000006ffULL,
0x0000000c1e757811ULL, 0x040fe200078fe8ffULL, 0x00000001716e7824ULL, 0x000fe200078e021eULL,
0x000020002b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000871817824ULL, 0x000fe200078e00ffULL,
0x000000081e737811ULL, 0x040fe200078fe8ffULL, 0x0000000875857824ULL, 0x000fe200078e00ffULL,
0x000000101e777811ULL, 0x000fc400078fe8ffULL, 0xfffffff881817812ULL, 0x000fe200078ee26eULL,
0x00000001756e7824ULL, 0x100fe200078e021eULL, 0x0001600084847810ULL, 0x000fe20007ffe02bULL,
0x00000001732b7824ULL, 0x100fe200078e021eULL, 0x000000141e797811ULL, 0x040fe200078fe8ffULL,
0x00000001776f7824ULL, 0x100fe200078e021eULL, 0x0000000373727819ULL, 0x040fe200000006ffULL,
0x0000000173737824ULL, 0x100fe200078e027dULL, 0x0000000377747819ULL, 0x000fe200000006ffULL,
0x0000000179707824ULL, 0x040fe200078e021eULL, 0xfffffff885857812ULL, 0x000fe200078ee26eULL,
0x0000000879897824ULL, 0x000fe200078e00ffULL, 0xfffffff872837812ULL, 0x000fe200078ee22bULL,
0x0000000175757824ULL, 0x100fe200078e027dULL, 0xfffffff874877812ULL, 0x000fe200078ee26fULL,
0x0000000177777824ULL, 0x100fe200078e027dULL, 0x000000181e6e7811ULL, 0x040fe200078fe8ffULL,
0x0000001081817824ULL, 0x100fe200078e0284ULL, 0x0000001e1e2b7211ULL, 0x040fe200078fe8ffULL,
0x0000001083837824ULL, 0x000fe200078e0284ULL, 0x0000001c1e6f7811ULL, 0x000fe200078fe8ffULL,
0x000000016e7b7824ULL, 0x140fe200078e027dULL, 0xfffffff889897812ULL, 0x000fe200078ee270ULL,
0x000000016e707824ULL, 0x040fe200078e021eULL, 0x000000072b7f7812ULL, 0x000fe200078ec0ffULL,
0x000000086e8b7824ULL, 0x000fe200078e00ffULL, 0x0000001e6f6e7210ULL, 0x000fe20007ffe0ffULL,
0x000000086f8d7824ULL, 0x040fe200078e00ffULL, 0x00000080137c7812ULL, 0x000fe200078ef87cULL,
0x000000016f2b7824ULL, 0x000fe200078e027dULL, 0x0000007d71717210ULL, 0x000fe20007ffe0ffULL,
0x0000001085857824ULL, 0x100fe200078e0284ULL, 0x0000007d79797210ULL, 0x000fe20007ffe0ffULL,
0x0000001089897824ULL, 0x000fe200078e0284ULL, 0x0000007d1e6f7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff7d7224ULL, 0x000fe200078e00ffULL, 0xfffffff88b8b7812ULL, 0x000fc400078ee270ULL,
0xfffffff88d8d7812ULL, 0x000fe200078ee26eULL, 0x0000010071707825ULL, 0x100fe200078e007cULL,
0x0ffffff87f7f7812ULL, 0x000fe400078ef81eULL, 0x0000008487877211ULL, 0x080fe200078e20ffULL,
0x000001006f6e7825ULL, 0x100fe200078e007cULL, 0x000000706c707210ULL, 0x000fe40007f3e0ffULL,
0x000000847f7f7211ULL, 0x000fe200078e20ffULL, 0x0000010073727825ULL, 0x000fe200078e007cULL,
0x0000006e6c6e7210ULL, 0x000fc60007f1e0ffULL, 0x0000010075747825ULL, 0x100fe200078e007cULL,
0x000000726c727210ULL, 0x000fe40007f5e0ffULL, 0x0000006f6d6f7210ULL, 0x000fe200007fe4ffULL,
0x0000010077767825ULL, 0x000fe200078e007cULL, 0x000000746c747210ULL, 0x000fc60007f7e0ffULL,
0x0000010079787825ULL, 0x100fe200078e007cULL, 0x000000766c767210ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e7f7faeULL, 0x0003e4000b901c46ULL,
0x000001007b7a7825ULL, 0x000fe200078e007cULL, 0x000000776d777210ULL, 0x000fc600007fe4ffULL,
0x000001002b7c7825ULL, 0x000fc800078e007cULL, 0x000000016d717824ULL, 0x040fe200008e0671ULL,
0x000000786c787210ULL, 0x000fe20007f3e0ffULL, 0x000000016d737824ULL, 0x040fe200010e0673ULL,
0x0000007a6c7a7210ULL, 0x000fe20007f5e0ffULL, 0x000000016d757824ULL, 0x040fe200018e0675ULL,
0x0000007c6c6c7210ULL, 0x000fe20007f7e0ffULL, 0x000000016d797824ULL, 0x000fe200008e0679ULL,
0x0000000070817faeULL, 0x0003e2000b901c46ULL, 0x000000108b8b7824ULL, 0x100fe400078e0284ULL,
0x000000016d7b7824ULL, 0x000fe200010e067bULL, 0x0000000072837faeULL, 0x0003e2000b901c46ULL,
0x000000108d8d7824ULL, 0x000fc400078e0284ULL, 0x000000016d6d7824ULL, 0x000fe200018e067dULL,
0x0000000074857faeULL, 0x0003e8000b901c46ULL, 0x0000000076877faeULL, 0x0003e8000b901c46ULL,
0x0000000078897faeULL, 0x0003e8000b901c46ULL, 0x000000007a8b7faeULL, 0x0003e8000b901c46ULL,
0x000000006c8d7faeULL, 0x0003e4000b901c46ULL, 0x0000001d88887211ULL, 0x000fe200078e28ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010192b7812ULL, 0x042fe400078ec0ffULL,
0x00000008196c7812ULL, 0x000fc800078ec0ffULL, 0x000000886c2b7210ULL, 0x000fc80007ffe02bULL,
0x01e668292b7079a7ULL, 0x0002a6000850003fULL, 0x00000000006c7805ULL, 0x000fce0000015200ULL,
0x01e668712b0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff727224ULL, 0x000fce00078e00ffULL, 0x000000107200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000006e7805ULL, 0x000fce0000015200ULL,
0x0000006e6c6e7210ULL, 0x000fca0007f1e1ffULL, 0x000000016f6f7824ULL, 0x000fe200000e0e6dULL,
0x003d09006e00780cULL, 0x000fc80003f06070ULL, 0x000000ff6f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c406e00780cULL, 0x000fc80003f06070ULL,
0x000000ff6f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff297819ULL, 0x002fc8000001146fULL, 0x0000006e29297211ULL, 0x000fca00078110ffULL,
0x000000ffff6e7224ULL, 0x000fca00000e066fULL, 0x0000000229297819ULL, 0x000fc8000000126eULL,
0x000000290000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fce0007ffe0ffULL, 0x01e668712b0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00000003246c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff887224ULL, 0x000fc800078e0027ULL, 0x000000806c297824ULL, 0x002fca00078e021dULL,
0x0000002912297210ULL, 0x000fca0007ffe013ULL, 0x01e00000296e7984ULL, 0x000e680000000800ULL,
0x01e20000298a7984ULL, 0x0004a20000000800ULL, 0x000000276e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002b7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff2b00720cULL, 0x000fda0003f25270ULL, 0x0000000400909947ULL, 0x004fea0003800000ULL,
0x000000246c00720cULL, 0x000fe40003f25270ULL, 0x000000276e00720bULL, 0x000fd60003f14000ULL,
0x00000080246d9824ULL, 0x000fe200078e021dULL, 0x000000276e299209ULL, 0x000fe40007810000ULL,
0x0000000000707806ULL, 0x000fe400000e0100ULL, 0x0000006d12129210ULL, 0x000fe40007ffe013ULL,
0x000000ff7000720cULL, 0x000fc60003f05270ULL, 0x01e4002912009388ULL, 0x0003f40000000800ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000276e127209ULL, 0x000fe40007810000ULL,
0x000000ff70ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0070ff7812ULL, 0x000fe2000782c0ffULL,
0x0000002712127221ULL, 0x000fe20000010100ULL, 0x00ff000070ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000070ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x0000001200727308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff137819ULL, 0x000fca000001161eULL, 0x00001f1372127589ULL, 0x006e6400000e0000ULL,
0x0000006812687220ULL, 0x042fe20000410000ULL, 0x0000006912697220ULL, 0x040fe20000410000ULL,
0x0000006412647220ULL, 0x040fe20000410000ULL, 0x0000006512657220ULL, 0x040fe20000410000ULL,
0x0000006012607220ULL, 0x040fe20000410000ULL, 0x0000006112617220ULL, 0x040fe20000410000ULL,
0x0000005c125c7220ULL, 0x040fe20000410000ULL, 0x0000005d125d7220ULL, 0x040fe20000410000ULL,
0x0000005812587220ULL, 0x040fe20000410000ULL, 0x0000005912597220ULL, 0x040fe20000410000ULL,
0x0000005412547220ULL, 0x040fe20000410000ULL, 0x0000005512557220ULL, 0x040fe20000410000ULL,
0x0000005012507220ULL, 0x040fe20000410000ULL, 0x0000005112517220ULL, 0x040fe20000410000ULL,
0x0000004c124c7220ULL, 0x040fe20000410000ULL, 0x0000004d124d7220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x000000081e137811ULL, 0x000fca00078ff0ffULL,
0x00001f1372127589ULL, 0x006e6400000e0000ULL, 0x0000006a126a7220ULL, 0x042fe20000410000ULL,
0x0000006b126b7220ULL, 0x040fe20000410000ULL, 0x0000006612667220ULL, 0x040fe20000410000ULL,
0x0000006712677220ULL, 0x040fe20000410000ULL, 0x0000006212627220ULL, 0x040fe20000410000ULL,
0x0000006312637220ULL, 0x040fe20000410000ULL, 0x0000005e125e7220ULL, 0x040fe20000410000ULL,
0x0000005f125f7220ULL, 0x040fe20000410000ULL, 0x0000005a125a7220ULL, 0x040fe20000410000ULL,
0x0000005b125b7220ULL, 0x040fe20000410000ULL, 0x0000005612567220ULL, 0x040fe20000410000ULL,
0x0000005712577220ULL, 0x040fe20000410000ULL, 0x0000005212527220ULL, 0x040fe20000410000ULL,
0x0000005312537220ULL, 0x040fe20000410000ULL, 0x0000004e124e7220ULL, 0x040fe20000410000ULL,
0x0000004f124f7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000101e137811ULL, 0x000fca00078ff0ffULL, 0x00001f1372127589ULL, 0x006e6400000e0000ULL,
0x0000004812487220ULL, 0x042fe20000410000ULL, 0x0000004912497220ULL, 0x040fe20000410000ULL,
0x0000004412447220ULL, 0x040fe20000410000ULL, 0x0000004512457220ULL, 0x040fe20000410000ULL,
0x0000004012407220ULL, 0x040fe20000410000ULL, 0x0000004112417220ULL, 0x040fe20000410000ULL,
0x0000003c123c7220ULL, 0x040fe20000410000ULL, 0x0000003d123d7220ULL, 0x040fe20000410000ULL,
0x0000003812387220ULL, 0x040fe20000410000ULL, 0x0000003912397220ULL, 0x040fe20000410000ULL,
0x0000003412347220ULL, 0x040fe20000410000ULL, 0x0000003512357220ULL, 0x040fe20000410000ULL,
0x0000003012307220ULL, 0x040fe20000410000ULL, 0x0000003112317220ULL, 0x040fe20000410000ULL,
0x0000002c122c7220ULL, 0x040fe20000410000ULL, 0x0000002d122d7220ULL, 0x000fce0000410000ULL,
0x0000007225257220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x000000181e137811ULL, 0x000fca00078ff0ffULL, 0x00001f1372127589ULL, 0x002e6400000e0000ULL,
0x0000004a124a7220ULL, 0x042fe20000410000ULL, 0x0000004b124b7220ULL, 0x040fe20000410000ULL,
0x0000004612467220ULL, 0x040fe20000410000ULL, 0x0000004712477220ULL, 0x040fe20000410000ULL,
0x0000004212427220ULL, 0x040fe20000410000ULL, 0x0000004312437220ULL, 0x040fe20000410000ULL,
0x0000003e123e7220ULL, 0x040fe20000410000ULL, 0x0000003f123f7220ULL, 0x040fe20000410000ULL,
0x0000003a123a7220ULL, 0x040fe20000410000ULL, 0x0000003b123b7220ULL, 0x040fe20000410000ULL,
0x0000003612367220ULL, 0x040fe20000410000ULL, 0x0000003712377220ULL, 0x040fe20000410000ULL,
0x0000003212327220ULL, 0x040fe20000410000ULL, 0x0000003312337220ULL, 0x040fe20000410000ULL,
0x0000002e122e7220ULL, 0x040fe20000410000ULL, 0x0000002f122f7220ULL, 0x000fce0000410000ULL,
0x000000702bff7212ULL, 0x000fe400078030ffULL, 0x000000276e887209ULL, 0x000fd60007810000ULL,
0x800000886e6e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00110308ULL, 0x000ea40000000800ULL, 0x000000118a8a0220ULL, 0x004fce0000410000ULL,
0x0000001d6c6c7211ULL, 0x000fe200078e60ffULL, 0x00004000186e7824ULL, 0x000fe200078e021dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000120006c127836ULL, 0x002fe40000000000ULL,
0x00002000156e7824ULL, 0x000fe400078e026eULL, 0x000000100f0f7824ULL, 0x000fe200078e0212ULL,
0x0000001210107211ULL, 0x000fe200078e20ffULL, 0x000170006e277836ULL, 0x000fe20000000000ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff6c7819ULL, 0x000fe4000001161eULL,
0x00000011ff07723eULL, 0x000fe400000010ffULL, 0x000000106c6e7810ULL, 0x000fe20007ffe0ffULL,
0x000000086c0a7836ULL, 0x000fe20000000000ULL, 0x0000541007137816ULL, 0x000fe20000000007ULL,
0x000000186c087836ULL, 0x000fc80000000000ULL, 0x00001f0a130a7589ULL, 0x0002a800000e0000ULL,
0x00001f6e13097589ULL, 0x0002e800000e0000ULL, 0x00001f6c13077589ULL, 0x00026800000e0000ULL,
0x00001f0813087589ULL, 0x00026400000e0000ULL, 0x000000001070783bULL, 0x0006a20000000200ULL,
0x000000100d747824ULL, 0x100fe400078e0227ULL, 0x000000100e787824ULL, 0x000fe200078e0227ULL,
0x000000000f6c783bULL, 0x0026620000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x084fe40000200000ULL, 0x0000000772727232ULL, 0x000fe40000200000ULL,
0x0000000a71717232ULL, 0x080fe40000200000ULL, 0x0000000a73737232ULL, 0x000fe40000200000ULL,
0x000000096c6c7232ULL, 0x08afe40000200000ULL, 0x000000096e6e7232ULL, 0x000fc40000200000ULL,
0x000000086d6d7232ULL, 0x080fe40000200000ULL, 0x000000086f6f7232ULL, 0x000fce0000200000ULL,
0x000000270c0c7211ULL, 0x000fe200078e20ffULL, 0x000000100b7c7824ULL, 0x000fe200078e0227ULL,
0x000000007878783bULL, 0x000f620000004200ULL, 0x0000001006067824ULL, 0x100fe400078e0212ULL,
0x000000258a257221ULL, 0x000fe20000010000ULL, 0x0000001005057824ULL, 0x000fe200078e0212ULL,
0x000000007474783bULL, 0x000f680000004200ULL, 0x000000000c0c783bULL, 0x008ee80000004200ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x000000787080723cULL, 0x024fe60000041860ULL,
0x000000000660783bULL, 0x0004a60000000200ULL, 0x0000007a7084723cULL, 0x000fe2000004185cULL,
0x00000000055c783bULL, 0x0004aa0000000200ULL, 0x000000747068723cULL, 0x000fec0000041868ULL,
0x000000767064723cULL, 0x000fec0000041864ULL, 0x0000000c7058723cULL, 0x008fec0000041858ULL,
0x0000000e7054723cULL, 0x000fec0000041854ULL, 0x0000007c7050723cULL, 0x002fec0000041850ULL,
0x0000007e704c723cULL, 0x000fec000004184cULL, 0x000000746c48723cULL, 0x000fec0000041848ULL,
0x000000766c44723cULL, 0x000fec0000041844ULL, 0x000000786c40723cULL, 0x000fec0000041840ULL,
0x0000007a6c3c723cULL, 0x000fec000004183cULL, 0x0000000c6c38723cULL, 0x000fec0000041838ULL,
0x0000000e6c34723cULL, 0x000fec0000041834ULL, 0x0000007c6c30723cULL, 0x000fec0000041830ULL,
0x0000007e6c2c723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000208947ULL, 0x004fde0003800000ULL, 0x0000000760607232ULL, 0x080fe40000200000ULL,
0x0000000762627232ULL, 0x000fe40000200000ULL, 0x0000000a61617232ULL, 0x080fe40000200000ULL,
0x0000000a63637232ULL, 0x000fe40000200000ULL, 0x000000095c5c7232ULL, 0x080fe40000200000ULL,
0x000000095e5e7232ULL, 0x000fc40000200000ULL, 0x000000085d5d7232ULL, 0x080fe40000200000ULL,
0x000000085f5f7232ULL, 0x000fce0000200000ULL, 0x00000027046c7211ULL, 0x000fe200078e20ffULL,
0x0000001003747824ULL, 0x100fe200078e0227ULL, 0x0000000100037802ULL, 0x000fe20000000f00ULL,
0x0000001002707824ULL, 0x100fe400078e0227ULL, 0x00000010000c7824ULL, 0x000fe200078e0227ULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x0000000128217824ULL, 0x000fe200078e0221ULL,
0x00000002ff007819ULL, 0x000fe40000011624ULL, 0x000000007474783bULL, 0x000ea40000004200ULL,
0x0000001a2100720cULL, 0x000fe20003f06070ULL, 0x0000000800007824ULL, 0x000fe200078e021dULL,
0x000000007070783bULL, 0x000ee80000004200ULL, 0x000000000c0c783bULL, 0x000f620000004200ULL,
0x01e6a00300ff79a7ULL, 0x0003e4000850003fULL, 0x0000006c6068723cULL, 0x002fec0000041868ULL,
0x0000006e6064723cULL, 0x000fec0000041864ULL, 0x00000074607c723cULL, 0x004fec0000041880ULL,
0x000000766078723cULL, 0x000fec0000041884ULL, 0x000000706058723cULL, 0x008fec0000041858ULL,
0x000000726054723cULL, 0x000fec0000041854ULL, 0x0000000c6050723cULL, 0x020fec0000041850ULL,
0x0000000e604c723cULL, 0x000fec000004184cULL, 0x0000006c5c48723cULL, 0x000fec0000041848ULL,
0x0000006e5c44723cULL, 0x000fec0000041844ULL, 0x000000745c40723cULL, 0x000fec0000041840ULL,
0x000000765c3c723cULL, 0x000fec000004183cULL, 0x000000705c38723cULL, 0x000fec0000041838ULL,
0x000000725c34723cULL, 0x000fec0000041834ULL, 0x0000000c5c30723cULL, 0x000fec0000041830ULL,
0x0000000e5c2c723cULL, 0x000fe2000004182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff8800cc8947ULL, 0x000fde000383ffffULL, 0x0000000000027919ULL, 0x000e620000002500ULL,
0x00000032005d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff5c7224ULL, 0x000fe200078e002fULL,
0x0000002e005f7202ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fe400078e002dULL,
0x000000ffff1e7224ULL, 0x000fe400078e002cULL, 0x000000ffff1c7224ULL, 0x000fe400078e0033ULL,
0x000000ffff167224ULL, 0x000fc400078e0031ULL, 0x000000ffff327224ULL, 0x000fe200078e0030ULL,
0x0000001a0200720cULL, 0x002fda0003f06070ULL, 0x0000000400540947ULL, 0x000fea0003800000ULL,
0x0180000025007836ULL, 0x000fca0000000000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x000098c000047802ULL, 0x000fce0000000f00ULL, 0x000000f800087944ULL, 0x010fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000002500007308ULL, 0x000e640000001000ULL,
0xbf80000000037423ULL, 0x002fc80000000025ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x00000002ff037819ULL, 0x022fe40000011605ULL, 0x0000000805077811ULL, 0x040fe400078ff0ffULL,
0x0000001005097811ULL, 0x040fe400078ff0ffULL, 0x00000018050b7811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0300037589ULL, 0x000e6800000e0000ULL,
0x00001f0700047589ULL, 0x000ea800000e0000ULL, 0x00001f0900057589ULL, 0x000ee800000e0000ULL,
0x00001f0b00067589ULL, 0x000f6200000e0000ULL, 0x0000006803687220ULL, 0x042fe20000410000ULL,
0x0000006903697220ULL, 0x040fe20000410000ULL, 0x0000006403647220ULL, 0x040fe20000410000ULL,
0x0000006503657220ULL, 0x040fe20000410000ULL, 0x0000007c037c7220ULL, 0x040fe20000410000ULL,
0x0000007d037d7220ULL, 0x040fe20000410000ULL, 0x0000007803787220ULL, 0x040fe20000410000ULL,
0x0000007903797220ULL, 0x040fe20000410000ULL, 0x0000005803587220ULL, 0x040fe20000410000ULL,
0x0000005903597220ULL, 0x040fe20000410000ULL, 0x0000005403547220ULL, 0x040fe20000410000ULL,
0x0000005503557220ULL, 0x040fe20000410000ULL, 0x0000005003507220ULL, 0x040fe20000410000ULL,
0x0000005103517220ULL, 0x040fe20000410000ULL, 0x0000004c034c7220ULL, 0x040fe20000410000ULL,
0x0000004d034d7220ULL, 0x000fe20000410000ULL, 0x0000006a046a7220ULL, 0x044fe20000410000ULL,
0x0000006b046b7220ULL, 0x040fe20000410000ULL, 0x0000006604667220ULL, 0x040fe20000410000ULL,
0x0000006704677220ULL, 0x040fe20000410000ULL, 0x0000007e047e7220ULL, 0x040fe20000410000ULL,
0x0000007f047f7220ULL, 0x040fe20000410000ULL, 0x0000007a047a7220ULL, 0x040fe20000410000ULL,
0x0000007b047b7220ULL, 0x040fe20000410000ULL, 0x0000005a045a7220ULL, 0x040fe20000410000ULL,
0x0000005b045b7220ULL, 0x040fe20000410000ULL, 0x0000005604567220ULL, 0x040fe20000410000ULL,
0x0000005704577220ULL, 0x040fe20000410000ULL, 0x0000005204527220ULL, 0x040fe20000410000ULL,
0x0000005304537220ULL, 0x040fe20000410000ULL, 0x0000004e044e7220ULL, 0x040fe20000410000ULL,
0x0000004f044f7220ULL, 0x000fe20000410000ULL, 0x0000004805487220ULL, 0x048fe20000410000ULL,
0x0000004905497220ULL, 0x040fe20000410000ULL, 0x0000004405447220ULL, 0x040fe20000410000ULL,
0x0000004505457220ULL, 0x040fe20000410000ULL, 0x0000004005407220ULL, 0x040fe20000410000ULL,
0x0000004105417220ULL, 0x040fe20000410000ULL, 0x0000003c053c7220ULL, 0x040fe20000410000ULL,
0x0000003d053d7220ULL, 0x040fe20000410000ULL, 0x0000003805387220ULL, 0x040fe20000410000ULL,
0x0000003905397220ULL, 0x040fe20000410000ULL, 0x0000003405347220ULL, 0x040fe20000410000ULL,
0x0000003505357220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x000fe20000410000ULL, 0x0000004a064a7220ULL, 0x060fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000004606467220ULL, 0x040fe20000410000ULL,
0x0000004706477220ULL, 0x040fe20000410000ULL, 0x0000004206427220ULL, 0x040fe20000410000ULL,
0x0000004306437220ULL, 0x040fe20000410000ULL, 0x0000003e063e7220ULL, 0x040fe20000410000ULL,
0x0000003f063f7220ULL, 0x040fe20000410000ULL, 0x0000003a063a7220ULL, 0x040fe20000410000ULL,
0x0000003b063b7220ULL, 0x040fe20000410000ULL, 0x0000003606367220ULL, 0x040fe20000410000ULL,
0x0000003706377220ULL, 0x040fe20000410000ULL, 0x0000005d065d7220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000005f065f7220ULL, 0x040fe20000410000ULL,
0x0000005c065c7220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0000001d151d7211ULL, 0x000fe400078e68ffULL, 0x000000545509723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000100018147824ULL, 0x000fe200078e021dULL,
0x0000004c4d0b723eULL, 0x000fc400000010ffULL, 0x0000006a6b0c723eULL, 0x000fe400000010ffULL,
0x00000066670d723eULL, 0x000fe400000010ffULL, 0x0000007e7f0e723eULL, 0x000fe400000010ffULL,
0x0000007a7b0f723eULL, 0x000fe400000010ffULL, 0x0000005a5b10723eULL, 0x000fe400000010ffULL,
0x000000565711723eULL, 0x000fc400000010ffULL, 0x000000525312723eULL, 0x000fe400000010ffULL,
0x0000004e4f13723eULL, 0x000fe400000010ffULL, 0x00000048492c723eULL, 0x000fe400000010ffULL,
0x00000044452d723eULL, 0x000fe400000010ffULL, 0x0000ffff00037812ULL, 0x002fe400078ec0ffULL,
0xfffffff8ff057812ULL, 0x000fc400078ee200ULL, 0x00000003ff037819ULL, 0x000fe40000011603ULL,
0x0000001805087810ULL, 0x000fe20007ffe0ffULL, 0x0000000805067836ULL, 0x000fe20000000000ULL,
0x0000000303037812ULL, 0x000fe200078ec0ffULL, 0x0000001005077836ULL, 0x000fe20000000000ULL,
0x0000000305197819ULL, 0x000fe200000006ffULL, 0x0000000806217824ULL, 0x000fe200078e00ffULL,
0x00000040412e723eULL, 0x000fe200000010ffULL, 0x0000000103037824ULL, 0x000fe200078e0200ULL,
0x0000003c3d2f723eULL, 0x000fe200000010ffULL, 0x0000000807277824ULL, 0x000fe200078e00ffULL,
0x000000383930723eULL, 0x000fe200000010ffULL, 0x00000008082b7824ULL, 0x000fe200078e00ffULL,
0x0000000703047812ULL, 0x040fe200078ec0ffULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x0000000403037812ULL, 0x000fe200078e3cffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee204ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fc400078ee204ULL, 0xfffffff827277812ULL, 0x000fe200078ee204ULL,
0x0000001019197824ULL, 0x100fe200078e0214ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL,
0x0000001021217824ULL, 0x100fe200078e0214ULL, 0x0000000305047819ULL, 0x000fe200000006ffULL,
0x0000001027277824ULL, 0x000fe200078e0214ULL, 0x0000000703037812ULL, 0x000fe400078ec0ffULL,
0x000000646505723eULL, 0x000fe400000010ffULL, 0xfffffff8041b7812ULL, 0x000fc400078ee203ULL,
0xfffffff806237812ULL, 0x010fe400078ee203ULL, 0xfffffff80a297812ULL, 0x000fe400078ee203ULL,
0xfffffff808037812ULL, 0x000fe200078ee203ULL, 0x0000001023237824ULL, 0x100fe200078e0214ULL,
0x000000686904723eULL, 0x000fe200000010ffULL, 0x0000001029297824ULL, 0x100fe200078e0214ULL,
0x0000007c7d06723eULL, 0x000fe200000010ffULL, 0x0000001003037824ULL, 0x000fe200078e0214ULL,
0x000000787907723eULL, 0x000fc400000010ffULL, 0x000000585908723eULL, 0x000fe400000010ffULL,
0x00000050510a723eULL, 0x000fe200000010ffULL, 0x0000000419007844ULL, 0x0003e20000000200ULL,
0x000000141b1b7211ULL, 0x000fe400078e20ffULL, 0x000000343531723eULL, 0x000fe400000010ffULL,
0x000000321632723eULL, 0x000fe200000010ffULL, 0x000000081b007844ULL, 0x0005e20000000200ULL,
0x0000001e2a33723eULL, 0x000fc400000010ffULL, 0x000000142b2b7211ULL, 0x000fe200078e20ffULL,
0x0000000c21007844ULL, 0x0007e20000000200ULL, 0x000000012800780cULL, 0x000fc60003f05270ULL,
0x0000001023007844ULL, 0x000fe20000000200ULL, 0x0000004a4b04723eULL, 0x002fe400000010ffULL,
0x000000464705723eULL, 0x000fe200000010ffULL, 0x0000002c27007844ULL, 0x000fe20000000200ULL,
0x000000424306723eULL, 0x000fe400000010ffULL, 0x0000003e3f07723eULL, 0x000fe200000010ffULL,
0x0000003029007844ULL, 0x000fe20000000200ULL, 0x0000003a3b08723eULL, 0x004fe200000010ffULL,
0x00000001170c7824ULL, 0x008fe200078e0200ULL, 0x000000363709723eULL, 0x000fe200000010ffULL,
0x000000042b007844ULL, 0x0003e20000000200ULL, 0x0000005d1c0a723eULL, 0x000fe200000010ffULL,
0x000000100c0d7824ULL, 0x000fe200078e021dULL, 0x0000005f5c0b723eULL, 0x000fca00000010ffULL,
0x0000000803007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff00047306ULL, 0x002e620000202400ULL, 0x000000000d107984ULL, 0x000e680000000c00ULL,
0x000400000d387984ULL, 0x000ea80000000c00ULL, 0x000800000d407984ULL, 0x000ee80000000c00ULL,
0x000c00000d307984ULL, 0x000f280000000c00ULL, 0x001000000d347984ULL, 0x000f680000000c00ULL,
0x001400000d3c7984ULL, 0x000f280000000c00ULL, 0x001800000d2c7984ULL, 0x000f280000000c00ULL,
0x001c00000d447984ULL, 0x000f620000000c00ULL, 0x0000001304137230ULL, 0x002fc40000200800ULL,
0x0000001204127230ULL, 0x040fe40000200800ULL, 0x0000001104117230ULL, 0x040fe40000200800ULL,
0x0000001004107230ULL, 0x040fe40000200800ULL, 0x0000003b043b7230ULL, 0x044fe40000200800ULL,
0x0000003a043a7230ULL, 0x040fe40000200800ULL, 0x0000003904397230ULL, 0x000fc40000200800ULL,
0x0000003804387230ULL, 0x040fe40000200800ULL, 0x0000004304437230ULL, 0x048fe40000200800ULL,
0x0000004204427230ULL, 0x040fe40000200800ULL, 0x0000004104417230ULL, 0x040fe40000200800ULL,
0x0000004004407230ULL, 0x040fe40000200800ULL, 0x0000003304337230ULL, 0x010fc40000200800ULL,
0x0000003204327230ULL, 0x040fe40000200800ULL, 0x0000003104317230ULL, 0x040fe40000200800ULL,
0x0000003004047230ULL, 0x000fe40000200800ULL, 0x0000003713137230ULL, 0x020fe40000200000ULL,
0x0000003612127230ULL, 0x000fe40000200000ULL, 0x0000003511117230ULL, 0x000fc40000200000ULL,
0x0000003410107230ULL, 0x000fe40000200000ULL, 0x0000003f3b3b7230ULL, 0x000fe40000200000ULL,
0x0000003e3a3a7230ULL, 0x000fe20000200000ULL, 0x000000100d007388ULL, 0x0003e20000000c00ULL,
0x0000003d39397230ULL, 0x000fe40000200000ULL, 0x0000003c38387230ULL, 0x000fe40000200000ULL,
0x0000002f43437230ULL, 0x000fc40000200000ULL, 0x0000002e42427230ULL, 0x000fe20000200000ULL,
0x000400380d007388ULL, 0x0003e20000000c00ULL, 0x0000002d41417230ULL, 0x000fe40000200000ULL,
0x0000002c40407230ULL, 0x000fe40000200000ULL, 0x0000004733337230ULL, 0x000fe40000200000ULL,
0x0000004632327230ULL, 0x000fe20000200000ULL, 0x000800400d007388ULL, 0x0003e20000000c00ULL,
0x0000004531317230ULL, 0x000fc40000200000ULL, 0x0000004404307230ULL, 0x000fca0000200000ULL,
0x000c00300d007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000003400e88947ULL, 0x000fea0003800000ULL, 0x00000400ff0f7b82ULL, 0x000ea20000000800ULL,
0x0000000000087919ULL, 0x000ee20000002600ULL, 0x000000400c077836ULL, 0x000fe40000000000ULL,
0x000000800c097836ULL, 0x000fe20000000000ULL, 0x0000000000057919ULL, 0x000ee20000002700ULL,
0x000000c00c0b7836ULL, 0x000fe40000000000ULL, 0x00009800ff047b82ULL, 0x000ea20000000800ULL,
0x000000000d2c7984ULL, 0x0009280000000c00ULL, 0x000400000d307984ULL, 0x0029260000000c00ULL,
0x00009c00ff2a7b82ULL, 0x000e620000000a00ULL, 0x000800000d347984ULL, 0x0009280000000c00ULL,
0x000c00000d387984ULL, 0x0009220000000c00ULL, 0x000000040f037224ULL, 0x004fc800078e02ffULL,
0x0000002803067224ULL, 0x040fe200078e02ffULL, 0x0000000f03047811ULL, 0x000fe200078e10ffULL,
0x0000000f050f7224ULL, 0x008fc600078e0208ULL, 0xfffffff004117812ULL, 0x000fe200078ec0ffULL,
0x000000280f197224ULL, 0x000fc600078e02ffULL, 0x0000001106137211ULL, 0x000fe200078e38ffULL,
0x00000001190a7824ULL, 0x000fc800078e0202ULL, 0x0000008006067824ULL, 0x000fc800078e0213ULL,
0x0000007f06067836ULL, 0x000fca0000000000ULL, 0xffffff8006217812ULL, 0x000fc800078ec0ffULL,
0x0000002a21037210ULL, 0x002fc80007f1e0ffULL, 0x000000030a027211ULL, 0x040fe400078268ffULL,
0x0000002bff037210ULL, 0x000fe400007fe4ffULL, 0x0000000118ff7812ULL, 0x000fe4000780f824ULL,
0x000000030a037211ULL, 0x000fe400008f6cffULL, 0x0000002a11107210ULL, 0x000fe20007f3e0ffULL,
0x0000100015027825ULL, 0x000fc600078e0002ULL, 0x0000002bff127210ULL, 0x000fe20000ffe4ffULL,
0x000000100c047825ULL, 0x000fc800078e0002ULL, 0x0000001007067825ULL, 0x000fc800078e0002ULL,
0x0000001009087825ULL, 0x000fc800078e0002ULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x0000000000400947ULL, 0x010fec0003800000ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011600ULL, 0x000000800a0b7824ULL, 0x000fc600078e00ffULL,
0x000000700c0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0e167812ULL, 0x000fe400078ec0ffULL,
0x0000002a0b0c7210ULL, 0x000fe40007ebe013ULL, 0x00000019ff0e7819ULL, 0x000fe4000001160aULL,
0x000000100d0b7210ULL, 0x000fe40007a3e00bULL, 0x0000000c160c7210ULL, 0x000fc40007c7e00dULL,
0x0000002b0e0d7210ULL, 0x000fe40002fec4ffULL, 0x0000000b160a7210ULL, 0x000fe40007fbe0ffULL,
0x00000012ff0e7210ULL, 0x000fe40000fe440eULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff0b7224ULL, 0x000fca00028e060eULL, 0x000000880a007986ULL, 0x0003e8000c101906ULL,
0x000000250c007986ULL, 0x0003e4000c101906ULL, 0x000000ff0000720cULL, 0x000fe20000705670ULL,
0x0000002c04007986ULL, 0x0005e8000c101d06ULL, 0x0000003006007986ULL, 0x0005e8000c101d06ULL,
0x0000003408007986ULL, 0x0005e8000c101d06ULL, 0x0000003802007986ULL, 0x0005e2000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000700947ULL, 0x000fea0003800000ULL,
0x00009c00ff027b82ULL, 0x004ea20000000a00ULL, 0xffffffff28057810ULL, 0x000fe20007ffe0ffULL,
0x000000040f027825ULL, 0x004fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000005020279a8ULL, 0x00052200099ee1c6ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000050200720cULL, 0x010fc80003f05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x008fd20008000004ULL, 0x00000002ff007988ULL, 0x0007e60008000004ULL,
0x0000000000027919ULL, 0x00cea20000008800ULL, 0x00000400001b7802ULL, 0x000fe20000000f00ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000654021b7816ULL, 0x004fca000000001bULL, 0x000000001b027984ULL, 0x000ea40000000000ULL,
0x000000ff0200720cULL, 0x004fda0003f05270ULL, 0x00000030006c8947ULL, 0x000fea0003800000ULL,
0x000000ff2400720cULL, 0x000fda0003f05270ULL, 0x0000000800940947ULL, 0x000fea0003800000ULL,
0x000000ff2800720cULL, 0x000fda0003f05270ULL, 0x00000000006c8947ULL, 0x000fea0003800000ULL,
0x0000001000037824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe40000011600ULL,
0x0000001019027211ULL, 0x000fe400078038ffULL, 0x0000007003057812ULL, 0x000fe400078ec0ffULL,
0x0000000c04047812ULL, 0x000fe400078ec0ffULL, 0x0000001219037211ULL, 0x000fe400000f3cffULL,
0x0000000204027210ULL, 0x000fc8000791e005ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602067981ULL, 0x000528000c1e1900ULL, 0x0000800602077981ULL, 0x000522000c1e1900ULL,
0x000000022800780cULL, 0x000fda0003f05270ULL, 0x00000000003c8947ULL, 0x004fea0003800000ULL,
0x0001000602097981ULL, 0x000522000c1e1900ULL, 0x000000042800780cULL, 0x000fda0003f06070ULL,
0x0000000000308947ULL, 0x004fea0003800000ULL, 0x00018006020b7981ULL, 0x002322000c1e1900ULL,
0x000000042800780cULL, 0x000fda0003f05270ULL, 0x0000000000248947ULL, 0x002fea0003800000ULL,
0x00020006020d7981ULL, 0x000322000c1e1900ULL, 0x000000062800780cULL, 0x000fda0003f06070ULL,
0x0000000000188947ULL, 0x002fea0003800000ULL, 0x00028006020f7981ULL, 0x000322000c1e1900ULL,
0x000000062800780cULL, 0x000fda0003f05270ULL, 0x00000000000c8947ULL, 0x002fea0003800000ULL,
0x000000082800780cULL, 0x000fe20003f06070ULL, 0x0003000602237981ULL, 0x000318000c1e1900ULL,
0x0003800602250981ULL, 0x000324000c1e1900ULL, 0x0000000728027836ULL, 0x002fca0000000000ULL,
0x00000003ff047819ULL, 0x000fc80000011602ULL, 0x000000ff0400720cULL, 0x000fda0003f05270ULL,
0x0000000400f48947ULL, 0x000fea0003800000ULL, 0x0000001119277211ULL, 0x040fe200078038ffULL,
0x000000ffff057224ULL, 0x010fe200078e0006ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000002a27277210ULL, 0x000fe40007f3e0ffULL,
0x000000ff19087211ULL, 0x000fe400000f3cffULL, 0x0000078027277810ULL, 0x000fc80007f5e0ffULL,
0x00000008ff087210ULL, 0x000fd200017e242bULL, 0x0000000428007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000504007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400b41947ULL, 0x012fee0003800000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000000506067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000400027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0xfffc800602057981ULL, 0x000326000c1e1900ULL,
0x0000000104087890ULL, 0x000fcc000fffe03fULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000004007c1947ULL, 0x000fea0003800000ULL, 0x0000000904087890ULL, 0x000fe2000fffe03fULL,
0x0000000706067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0xfffd000602077981ULL, 0x000326000c1e1900ULL,
0x0000000204087890ULL, 0x000fcc000fffe03fULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x0000000400441947ULL, 0x000fea0003800000ULL, 0x0000000a04087890ULL, 0x000fe2000fffe03fULL,
0x0000000906067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000400027819ULL, 0x002fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0xfffd800602097981ULL, 0x000326000c1e1900ULL,
0x0000000304087890ULL, 0x000fcc000fffe03fULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000004000c1947ULL, 0x000fea0003800000ULL, 0x0000000b04087890ULL, 0x000fe2000fffe03fULL,
0x0000000b06067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0xfffe0006020b7981ULL, 0x000326000c1e1900ULL,
0x0000000404087890ULL, 0x000fcc000fffe03fULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x0000000000d41947ULL, 0x000fea0003800000ULL, 0x0000000c04087890ULL, 0x000fe2000fffe03fULL,
0x0000000d06067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000400027819ULL, 0x002fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0xfffe8006020d7981ULL, 0x000326000c1e1900ULL,
0x0000000504087890ULL, 0x000fcc000fffe03fULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000009c1947ULL, 0x000fea0003800000ULL, 0x0000000d04087890ULL, 0x000fe2000fffe03fULL,
0x0000000f06067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0xffff0006020f7981ULL, 0x000326000c1e1900ULL,
0x0000000604087890ULL, 0x000fcc000fffe03fULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x0000000000641947ULL, 0x000fea0003800000ULL, 0x0000000e04087890ULL, 0x000fe2000fffe03fULL,
0x0000002306067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000400027819ULL, 0x002fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0xffff800602237981ULL, 0x000326000c1e1900ULL,
0x0000000704087890ULL, 0x000fcc000fffe03fULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000002c1947ULL, 0x000fea0003800000ULL, 0x0000000f04087890ULL, 0x000fe2000fffe03fULL,
0x0000002506067209ULL, 0x000fca0007810000ULL, 0x0000000828007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x0000000227027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0608ULL, 0x0000000602257981ULL, 0x000326000c1e1900ULL,
0x0000040027277810ULL, 0x000fe20007f3e0ffULL, 0x0000000804047890ULL, 0x000fc6000fffe03fULL,
0x00000008ff087210ULL, 0x000fe20000ffe4ffULL, 0xfffffff8002c8947ULL, 0x000ff0000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000027824ULL, 0x006fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000001b03037210ULL, 0x000fca0007ffe002ULL,
0x0000000603007388ULL, 0x0103e40000000800ULL, 0x00009c00ff2a7b82ULL, 0x000ea20000000a00ULL,
0x000000070000780cULL, 0x000fe20003f04070ULL, 0x0000100015167824ULL, 0x040fe200078e00ffULL,
0x00000002ff067819ULL, 0x002fe20000011624ULL, 0x00004000181e7824ULL, 0x100fe200078e021bULL,
0x0000001918297210ULL, 0x000fe20007ffe0ffULL, 0x00000060000d7836ULL, 0x000fe20000000000ULL,
0x0000000106067812ULL, 0x000fe200078ec0ffULL, 0x00002000151e7824ULL, 0x040fe200078e021eULL,
0x00000040000b7810ULL, 0x000fe20007ffe0ffULL, 0x00000080000f7836ULL, 0x000fe20000000000ULL,
0x0000000000707805ULL, 0x000fe2000001ff00ULL, 0x000000e000237836ULL, 0x000fe20000000000ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000020018048824ULL, 0x140fe200078e021bULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000020018088824ULL, 0x000fe200078e021bULL,
0x00000000006c7805ULL, 0x000fe2000001ff00ULL, 0x0000010015078824ULL, 0x000fe200078e0204ULL,
0x00000000005c7805ULL, 0x000fc4000001ff00ULL, 0x0000000000667805ULL, 0x000fe4000001ff00ULL,
0x0000000815098211ULL, 0x000fe200078e40ffULL, 0x0000008006318824ULL, 0x000fe200078e0207ULL,
0x0000000a24077819ULL, 0x000fe200000006ffULL, 0x0000001000247824ULL, 0x000fe200078e00ffULL,
0x0000002a21027210ULL, 0x004fe20007f3e0ffULL, 0x0000008006338824ULL, 0x000fe200078e0209ULL,
0x0000100007077812ULL, 0x000fe200078ec0ffULL, 0x0000002000097836ULL, 0x000fe20000000000ULL,
0x0000002a111c7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff037224ULL, 0x000fe200008e062bULL,
0x00000001ff217819ULL, 0x000fe20000011600ULL, 0x000000011e077824ULL, 0x000fe200078e0207ULL,
0x0000002a131a7210ULL, 0x000fe20007f3e0ffULL, 0x0000200029047825ULL, 0x000fe200078e0002ULL,
0x000000a000117810ULL, 0x000fc40007ffe0ffULL, 0x00000000005e7805ULL, 0x000fe4000001ff00ULL,
0x00000007002f7211ULL, 0x000fe200078e20ffULL, 0x000000c000137836ULL, 0x000fe20000000000ULL,
0x0000001604047210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x100fe200008e062bULL,
0x0000007024247812ULL, 0x000fe200078ec0ffULL, 0x000000ffff277224ULL, 0x000fe200018e062bULL,
0x0000000c21217812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000001a292a8211ULL, 0x000fe200078238ffULL, 0x0000001000318824ULL, 0x000fe200078e0231ULL,
0x0000001b212e7210ULL, 0x000fe20007ffe024ULL, 0x0000001009067825ULL, 0x000fe200078e0004ULL,
0x0000001c292c8211ULL, 0x000fc400078438ffULL, 0x00000000006e7805ULL, 0x000fe4000001ff00ULL,
0x00000025292b8211ULL, 0x000fe200008f3cffULL, 0x000000100b087825ULL, 0x100fe200078e0004ULL,
0x000000281800720cULL, 0x000fe40003f26070ULL, 0x0000000000607805ULL, 0x000fe4000001ff00ULL,
0x00000027292d8211ULL, 0x000fe200010f3cffULL, 0x000000100d0a7825ULL, 0x000fe200078e0004ULL,
0x0000003300338211ULL, 0x000fc400078e20ffULL, 0x0000000000627805ULL, 0x000fe4000001ff00ULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x000000100f0c7825ULL, 0x100fe200078e0004ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x00000000006a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x00000010110e7825ULL, 0x000fe200078e0004ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000001013107825ULL, 0x100fe200078e0004ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000001023127825ULL, 0x100fe200078e0004ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001000047825ULL, 0x000fe200078e0004ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x000000002e237984ULL, 0x0002a20000000800ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000042f7faeULL, 0x0007e2000b901c46ULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x00380000062f7faeULL, 0x0009e2000b901c46ULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00580000082f7faeULL, 0x0003e2000b901c46ULL, 0x0000000000467805ULL, 0x000fc4000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x007800000a2f7faeULL, 0x0003e2000b901c46ULL,
0x0000001000048825ULL, 0x048fe200078e002aULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x009800000c2f7faeULL, 0x0003e2000b901c46ULL, 0x0000001000068825ULL, 0x010fc600078e002cULL,
0x00b800000e2f7faeULL, 0x0003e8000b901c46ULL, 0x00d80000102f7faeULL, 0x0003e8000b901c46ULL,
0x00f80000122f7faeULL, 0x0003e8000b901c46ULL, 0x0858000004318faeULL, 0x0003e8000b901c46ULL,
0x0818000006338faeULL, 0x0003e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010007c1947ULL, 0x004fea0003800000ULL, 0x00000003ff077819ULL, 0x102fe20000011600ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0xfffffff8ff067812ULL, 0x000fe400078ee200ULL,
0x0000000307057812ULL, 0x000fe400078ec0ffULL, 0x0000000400047810ULL, 0x000fe20007ffe007ULL,
0x0000000806077836ULL, 0x000fe20000000000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x0000001806097836ULL, 0x000fe20000000000ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x0000000806737824ULL, 0x000fe200078e00ffULL, 0x00000003080d7819ULL, 0x000fe200000006ffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0x00000002ff7c7819ULL, 0x100fe20000011600ULL,
0x0000000809757824ULL, 0x000fe200078e00ffULL, 0xfffffff873737812ULL, 0x000fe200078ee204ULL,
0x0000000105057824ULL, 0x000fe200078e0200ULL, 0xfffffff80b727812ULL, 0x000fe200078ee204ULL,
0x0000000807767824ULL, 0x000fe200078e00ffULL, 0xfffffff80d747812ULL, 0x000fe200078ee204ULL,
0x0000000806067824ULL, 0x000fe200078e00ffULL, 0xfffffff875757812ULL, 0x000fe200078ee204ULL,
0x0000000809047824ULL, 0x000fe200078e00ffULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x000000087c7e7836ULL, 0x000fe20000000000ULL, 0x0000000308787819ULL, 0x000fe200000006ffULL,
0x000000107c7f7836ULL, 0x000fe20000000000ULL, 0xfffffff8047b7812ULL, 0x000fe200078ee205ULL,
0x0000020018047824ULL, 0x000fe200078e021bULL, 0xfffffff876767812ULL, 0x000fc400078ee205ULL,
0xfffffff806777812ULL, 0x000fe200078ee205ULL, 0x00000100157d7824ULL, 0x000fe200078e0204ULL,
0xfffffff878787812ULL, 0x000fe400078ee205ULL, 0x0000001800317202ULL, 0x000fe40000000f00ULL,
0x000000187c797810ULL, 0x000fce0007ffe0ffULL, 0x00000002317a7836ULL, 0x000fca0000000000ULL,
0x000000287a00720cULL, 0x000fda0003f06070ULL, 0x0000000000cc0947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f44070ULL, 0x00000001192f7824ULL, 0x100fe200078e027aULL,
0x00000001ff067819ULL, 0x000fe2000001167aULL, 0x00000040000b7836ULL, 0x000fe20000000000ULL,
0x0000002000097810ULL, 0x000fe20007ffe0ffULL, 0x000020002f047825ULL, 0x000fe200078e0002ULL,
0x0000000106307812ULL, 0x000fc600078ec0ffULL, 0x000008007a067824ULL, 0x000fe200078e00ffULL,
0x0000001604047210ULL, 0x000fe20007f1e0ffULL, 0x00000060000d7836ULL, 0x000fe40000000000ULL,
0x000002001808a824ULL, 0x000fe200078e021bULL, 0x0000100006077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x0000001a2f2ca211ULL, 0x000fe200078038ffULL,
0x00000080000f7836ULL, 0x000fe20000000000ULL, 0x000000071e077210ULL, 0x000fe20007ffe0ffULL,
0x000000a000117836ULL, 0x000fe20000000000ULL, 0x00000008157da211ULL, 0x000fe200078e40ffULL,
0x000000c000137836ULL, 0x000fe20000000000ULL, 0x0000000700337211ULL, 0x040fe200078e20ffULL,
0x000000e0002d7836ULL, 0x000fe20000000000ULL, 0x0000001c2f2ea211ULL, 0x000fe200078238ffULL,
0x0000001000067825ULL, 0x000fc800078e0004ULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006337faeULL, 0x0003e6000b901c46ULL,
0x000000100b0a7825ULL, 0x100fe200078e0004ULL, 0x0038000008337faeULL, 0x0003e6000b901c46ULL,
0x000000100d0c7825ULL, 0x100fe200078e0004ULL, 0x005800000a337faeULL, 0x0003e6000b901c46ULL,
0x000000100f0e7825ULL, 0x100fe200078e0004ULL, 0x007800000c337faeULL, 0x0003e6000b901c46ULL,
0x0000001011107825ULL, 0x100fe200078e0004ULL, 0x009800000e337faeULL, 0x0003e6000b901c46ULL,
0x0000001013127825ULL, 0x100fe200078e0004ULL, 0x00b8000010337faeULL, 0x0003e6000b901c46ULL,
0x000000102d047825ULL, 0x000fe200078e0004ULL, 0x000000252f2da211ULL, 0x040fe200000f3cffULL,
0x00d8000012337faeULL, 0x0003e2000b901c46ULL, 0x000000272f2fa211ULL, 0x000fe200008f3cffULL,
0x000000803081a824ULL, 0x000fc400078e027dULL, 0x000000803083a824ULL, 0x000fe200078e027dULL,
0x00f8000004337faeULL, 0x0003e2000b901c46ULL, 0x00000010002ca825ULL, 0x000fc800078e002cULL,
0x000000100081a824ULL, 0x040fe400078e0281ULL, 0x00000010002ea825ULL, 0x000fc600078e002eULL,
0x085800002c81afaeULL, 0x0003e2000b901c46ULL, 0x000000100083a824ULL, 0x000fca00078e0283ULL,
0x081800002e83afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000b31047819ULL, 0x002fc800000006ffULL, 0x0000100004057812ULL, 0x000fe200078ec0ffULL,
0x0000004031047824ULL, 0x000fc600078e00ffULL, 0x000001801e307810ULL, 0x000fe40007ffe005ULL,
0x0000008004047812ULL, 0x000fe400078ec0ffULL, 0x0000003074807211ULL, 0x000fe200078e20ffULL,
0x0000001073107824ULL, 0x000fe200078e0230ULL, 0x0000007d24047210ULL, 0x000fe20007ffe004ULL,
0x00000010772c7824ULL, 0x100fe400078e0230ULL, 0x000000107b317824ULL, 0x100fe200078e0230ULL,
0x0000000421327210ULL, 0x000fe20007ffe0ffULL, 0x0000001076047824ULL, 0x000fc400078e0230ULL,
0x0000001072087824ULL, 0x000fe200078e0230ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x00000010780c7824ULL, 0x100fe400078e0230ULL,
0x0000001075817824ULL, 0x000fe200078e0230ULL, 0x0081800032907984ULL, 0x000ea80000000800ULL,
0x0085800032997984ULL, 0x000fe80000000800ULL, 0x000000002c2c783bULL, 0x000ee80000000200ULL,
0x000000003130783bULL, 0x000fe80000000200ULL, 0x000000000404783bULL, 0x000f280000000200ULL,
0x000000000808783bULL, 0x000f680000000200ULL, 0x000000000c0c783bULL, 0x000f620000000200ULL,
0x00007632108a7816ULL, 0x042fe2000000008aULL, 0x00010000108b7824ULL, 0x000fe200078e00ffULL,
0x00007632118c7816ULL, 0x000fe2000000008cULL, 0x00010000128f7824ULL, 0x000fc400078e00ffULL,
0x0000009023107221ULL, 0x004fe20000010100ULL, 0x00000010118d7819ULL, 0x000fe200000006ffULL,
0x0001000013917824ULL, 0x040fe200078e00ffULL, 0x00007632128e7816ULL, 0x000fe2000000008eULL,
0x3fb8aa3b10967820ULL, 0x000fe20000410000ULL, 0x0000763213907816ULL, 0x000fe20000000090ULL,
0x000100008a8a7824ULL, 0x000fe200078e00ffULL, 0x000000008110783bULL, 0x000e620000000200ULL,
0x0000009600987308ULL, 0x000ea20000000800ULL, 0x000076322c827816ULL, 0x048fe20000000082ULL,
0x000100002c837824ULL, 0x000fe200078e00ffULL, 0x000076322d847816ULL, 0x040fe20000000084ULL,
0x000100002d857824ULL, 0x000fe200078e00ffULL, 0x000076322e867816ULL, 0x040fe20000000086ULL,
0x000100002f897824ULL, 0x040fe200078e00ffULL, 0x000000102e877819ULL, 0x000fe200000006ffULL,
0x0001000082827824ULL, 0x000fe200078e00ffULL, 0x000076322f887816ULL, 0x000fe20000000088ULL,
0x0001000004937824ULL, 0x010fe200078e00ffULL, 0x00000000802c783bULL, 0x0007e20000000200ULL,
0x0000763231a17816ULL, 0x040fe200000000a1ULL, 0x0001000006957824ULL, 0x000fe200078e00ffULL,
0x0000001031317819ULL, 0x000fe200000006ffULL, 0x0000009998a97220ULL, 0x004fe20000410000ULL,
0x0000763206927816ULL, 0x000fe20000000092ULL, 0x0001000033a47824ULL, 0x040fe200078e00ffULL,
0x0000763233a37816ULL, 0x000fe200000000a3ULL, 0x00000070a9707221ULL, 0x000fe20000010000ULL,
0x00001f7ca9a87589ULL, 0x000ea200000e0000ULL, 0x0000763204807816ULL, 0x008fe20000000080ULL,
0x0001000008817824ULL, 0x020fe200078e00ffULL, 0x0000763205047816ULL, 0x040fe20000000004ULL,
0x000100000a977824ULL, 0x000fe200078e00ffULL, 0x0000001005057819ULL, 0x000fe200000006ffULL,
0x000100000c997824ULL, 0x000fe200078e00ffULL, 0x0000001004047819ULL, 0x000fe200000006ffULL,
0x000100000e9b7824ULL, 0x000fe200078e00ffULL, 0x0000763207067816ULL, 0x040fe20000000006ULL,
0x0001000007077824ULL, 0x000fe200078e00ffULL, 0x0000763208947816ULL, 0x000fe20000000094ULL,
0x0001000086867824ULL, 0x000fe200078e00ffULL, 0x000076320a967816ULL, 0x000fe20000000096ULL,
0x0001000006067824ULL, 0x000fe200078e00ffULL, 0x000076320c987816ULL, 0x000fe20000000098ULL,
0x0001000088887824ULL, 0x000fe200078e00ffULL, 0x000076320e9a7816ULL, 0x000fe2000000009aULL,
0x000100008e8e7824ULL, 0x000fe200078e00ffULL, 0x0000763210337816ULL, 0x042fe20000000033ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x0000763211a57816ULL, 0x040fe200000000a5ULL,
0x0001000090907824ULL, 0x000fe200078e00ffULL, 0x0000001011a67819ULL, 0x000fe200000006ffULL,
0x000000a883587223ULL, 0x084fe20000010058ULL, 0x000000a882577223ULL, 0x000fe20000010057ULL,
0x00001f7fa9837589ULL, 0x000fe200000e0000ULL, 0x0000763209087816ULL, 0x000fe20000000008ULL,
0x0001000080807824ULL, 0x000fe200078e00ffULL, 0x000076320b0a7816ULL, 0x040fe2000000000aULL,
0x00001f7ea9827589ULL, 0x000e6200000e0000ULL, 0x000076322c9c7816ULL, 0x000fe2000000009cULL,
0x000100000b0b7824ULL, 0x000fe200078e00ffULL, 0x000076322f9f7816ULL, 0x000fe2000000009fULL,
0x00001f79a9a97589ULL, 0x000ea200000e0000ULL, 0x000076322e9e7816ULL, 0x000fe2000000009eULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x000076320d0c7816ULL, 0x000fe2000000000cULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x000076320f0e7816ULL, 0x040fe2000000000eULL,
0x000100000f0f7824ULL, 0x000fe200078e00ffULL, 0x000076322d9d7816ULL, 0x000fe2000000009dULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x0000763230a07816ULL, 0x040fe200000000a0ULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x0000763232a27816ULL, 0x040fe200000000a2ULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x0000763212117816ULL, 0x040fe20000000011ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000763213a77816ULL, 0x040fe200000000a7ULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x0000001009097819ULL, 0x000fe200000006ffULL,
0x0001000092927824ULL, 0x000fe200078e00ffULL, 0x000000100d0d7819ULL, 0x000fe200000006ffULL,
0x0000008205467223ULL, 0x082fe20000010046ULL, 0x0000008204457223ULL, 0x000fe20000010045ULL,
0x000100009c057824ULL, 0x000fe200078e00ffULL, 0x000000102d2d7819ULL, 0x000fe200000006ffULL,
0x000000a931647223ULL, 0x004fe20000010064ULL, 0x0000007a00317202ULL, 0x000fe20000000f00ULL,
0x000100009f047824ULL, 0x000fc400078e00ffULL, 0x0000008305607223ULL, 0x080fe20000010060ULL,
0x000100009e057824ULL, 0x000fe200078e00ffULL, 0x000000283100720cULL, 0x000fe20003f06070ULL,
0x0000008304597223ULL, 0x080fe20000010059ULL, 0x0001000033047824ULL, 0x000fe200078e00ffULL,
0x0000001084847819ULL, 0x000fe200000006ffULL, 0x0000008206417223ULL, 0x000fe20000010041ULL,
0x000000108c8c7819ULL, 0x000fe200000006ffULL, 0x00000083055c7223ULL, 0x000fe2000001005cULL,
0x0000001008087819ULL, 0x000fe200000006ffULL, 0x000000a9045f7223ULL, 0x000fe2000001005fULL,
0x000000100c0c7819ULL, 0x000fe200000006ffULL, 0x0001000094947824ULL, 0x000fe200078e00ffULL,
0x000000109d9d7819ULL, 0x000fe200000006ffULL, 0x0001000096967824ULL, 0x000fe200078e00ffULL,
0x00000010a1a17819ULL, 0x000fe200000006ffULL, 0x000100000a0a7824ULL, 0x000fc400078e00ffULL,
0x000000a885567223ULL, 0x080fe20000010056ULL, 0x0001000098987824ULL, 0x000fe400078e00ffULL,
0x000000a884557223ULL, 0x080fe20000010055ULL, 0x000100009a9a7824ULL, 0x000fe400078e00ffULL,
0x000000a887547223ULL, 0x080fe20000010054ULL, 0x000100000e0e7824ULL, 0x000fe400078e00ffULL,
0x000000a886537223ULL, 0x000fe20000010053ULL, 0x00010000a0a07824ULL, 0x000fc400078e00ffULL,
0x000000a889527223ULL, 0x080fe20000010052ULL, 0x00010000a2057824ULL, 0x000fe400078e00ffULL,
0x000000a888517223ULL, 0x080fe20000010051ULL, 0x00010000a3a37824ULL, 0x000fe400078e00ffULL,
0x000000a88b507223ULL, 0x080fe20000010050ULL, 0x00010000a5a57824ULL, 0x000fe400078e00ffULL,
0x000000a88a4f7223ULL, 0x000fe2000001004fULL, 0x0001000011047824ULL, 0x000fc400078e00ffULL,
0x000000a88d4e7223ULL, 0x080fe2000001004eULL, 0x00010000a7067824ULL, 0x000fe400078e00ffULL,
0x000000a88c4d7223ULL, 0x080fe2000001004dULL, 0x000000a88f4c7223ULL, 0x080fe2000001004cULL,
0x000000a88e4b7223ULL, 0x080fe2000001004bULL, 0x000000a8914a7223ULL, 0x080fe2000001004aULL,
0x000000a890497223ULL, 0x000fe20000010049ULL, 0x0000008293487223ULL, 0x080fe20000010048ULL,
0x0000008280477223ULL, 0x080fe20000010047ULL, 0x0000008295447223ULL, 0x080fe20000010044ULL,
0x0000008292437223ULL, 0x080fe20000010043ULL, 0x0000008207427223ULL, 0x080fe20000010042ULL,
0x0000008281407223ULL, 0x080fe20000010040ULL, 0x00000082943f7223ULL, 0x080fe2000001003fULL,
0x00000082093e7223ULL, 0x080fe2000001003eULL, 0x00000082083d7223ULL, 0x080fe2000001003dULL,
0x00000082973c7223ULL, 0x080fe2000001003cULL, 0x00000082963b7223ULL, 0x080fe2000001003bULL,
0x000000820b3a7223ULL, 0x080fe2000001003aULL, 0x000000820a397223ULL, 0x000fe20000010039ULL,
0x0000008399387223ULL, 0x080fe20000010038ULL, 0x0000008398377223ULL, 0x080fe20000010037ULL,
0x000000830d367223ULL, 0x080fe20000010036ULL, 0x000000830c357223ULL, 0x080fe20000010035ULL,
0x000000839b347223ULL, 0x080fe20000010034ULL, 0x000000839a2b7223ULL, 0x080fe2000001002bULL,
0x000000830f2a7223ULL, 0x080fe2000001002aULL, 0x000000830e297223ULL, 0x080fe20000010029ULL,
0x000000832c6f7223ULL, 0x080fe2000001006fULL, 0x000000832d6e7223ULL, 0x080fe2000001006eULL,
0x000000839d5e7223ULL, 0x080fe2000001005eULL, 0x000000832e6d7223ULL, 0x080fe2000001006dULL,
0x000000832f6c7223ULL, 0x000fe2000001006cULL, 0x000000a9306b7223ULL, 0x080fe2000001006bULL,
0x000000a9a0657223ULL, 0x080fe20000010065ULL, 0x000000a9a16a7223ULL, 0x080fe2000001006aULL,
0x000000a932697223ULL, 0x080fe20000010069ULL, 0x000000a905687223ULL, 0x080fe20000010068ULL,
0x000000a9a4637223ULL, 0x080fe20000010063ULL, 0x000000a9a3627223ULL, 0x080fe20000010062ULL,
0x000000a910617223ULL, 0x080fe20000010061ULL, 0x000000a9a6677223ULL, 0x080fe20000010067ULL,
0x000000a9a5667223ULL, 0x080fe20000010066ULL, 0x000000a9125d7223ULL, 0x080fe2000001005dULL,
0x000000a9045b7223ULL, 0x080fe2000001005bULL, 0x000000a9135a7223ULL, 0x080fe2000001005aULL,
0x000000a906717223ULL, 0x000fe20000010071ULL, 0xfffffff0000c8947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ff1500720cULL, 0x000fe40003f05270ULL,
0x0000000400027819ULL, 0x004fe400000006ffULL, 0x00000001ff037819ULL, 0x000fe20000011600ULL,
0x000089801b007836ULL, 0x000fe20000000000ULL, 0x0000007002057812ULL, 0x002fe400078ec0ffULL,
0x0000000c03067812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00000080181b7824ULL, 0x000fe400078e021bULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011602ULL,
0x0000007003027812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000001b041b7210ULL, 0x000fca0007ffe002ULL, 0x008980701b007388ULL, 0x0003e40000000800ULL,
0x0000000006007210ULL, 0x000fe20007ffe005ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000027984ULL, 0x000ea80000000800ULL, 0x0000800000037984ULL, 0x000ee20000000800ULL,
0x00000002ff027221ULL, 0x004fc80000010000ULL, 0x0000000302027221ULL, 0x008fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e0002ULL,
0x0000d0a000047802ULL, 0x000fce0000000f00ULL, 0x000000c000107944ULL, 0x002fea0003c00000ULL,
0x000000ffff037224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000200037308ULL, 0x000ea40000001000ULL, 0xbf80000002007423ULL, 0x004fc80000000003ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003037223ULL, 0x000fce0000000003ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x00000002ff027819ULL, 0x004fe40000011600ULL,
0x00000008000c7811ULL, 0x040fe400078ff0ffULL, 0x00000010000a7811ULL, 0x040fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0203027589ULL, 0x000ea200000e0000ULL,
0x00000018001a7811ULL, 0x000fc400078ff0ffULL, 0xfffffff8ff237812ULL, 0x000fe200078ee200ULL,
0x00001f0c030c7589ULL, 0x000ee800000e0000ULL, 0x00001f0a03197589ULL, 0x000fe200000e0000ULL,
0x0000001023287836ULL, 0x000fe40000000000ULL, 0x00000018232c7836ULL, 0x000fe20000000000ULL,
0x00001f1a031a7589ULL, 0x000f2200000e0000ULL, 0x0000000823257824ULL, 0x002fc400078e00ffULL,
0x00000008282f7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000082c337824ULL, 0x000fe400078e00ffULL, 0x0000005602057220ULL, 0x044fe20000410000ULL,
0x0000005502067220ULL, 0x040fe20000410000ULL, 0x0000005802047220ULL, 0x040fe20000410000ULL,
0x0000005702577220ULL, 0x000fe20000410000ULL, 0x000000480c487220ULL, 0x048fe20000410000ULL,
0x000000470c477220ULL, 0x040fe20000410000ULL, 0x000000460c0d7220ULL, 0x040fe20000410000ULL,
0x000000450c0e7220ULL, 0x040fe20000410000ULL, 0x000000440c447220ULL, 0x040fe20000410000ULL,
0x000000430c437220ULL, 0x040fe20000410000ULL, 0x000000420c0f7220ULL, 0x040fe20000410000ULL,
0x000000410c107220ULL, 0x040fe20000410000ULL, 0x000000400c407220ULL, 0x040fe20000410000ULL,
0x0000003f0c3f7220ULL, 0x040fe20000410000ULL, 0x0000003e0c117220ULL, 0x040fe20000410000ULL,
0x0000003d0c127220ULL, 0x040fe20000410000ULL, 0x0000003c0c3c7220ULL, 0x040fe20000410000ULL,
0x0000003b0c3b7220ULL, 0x040fe20000410000ULL, 0x0000003a0c137220ULL, 0x040fe20000410000ULL,
0x000000390c167220ULL, 0x000fe20000410000ULL, 0x0000ffff000c7812ULL, 0x000fe200078ec0ffULL,
0x0000006b1a6b7220ULL, 0x050fe20000410000ULL, 0x000000651a1c7220ULL, 0x040fe20000410000ULL,
0x000000641a647220ULL, 0x040fe20000410000ULL, 0x00000003ff0c7819ULL, 0x000fe2000001160cULL,
0x0000006a1a1b7220ULL, 0x040fe20000410000ULL, 0x000000691a697220ULL, 0x040fe20000410000ULL,
0x000000681a687220ULL, 0x000fe20000410000ULL, 0x000000030c217812ULL, 0x000fe200078ec0ffULL,
0x000000631a637220ULL, 0x040fe20000410000ULL, 0x000000621a627220ULL, 0x040fe20000410000ULL,
0x000000611a617220ULL, 0x040fe20000410000ULL, 0x0000005f1a1e7220ULL, 0x040fe20000410000ULL,
0x000000671a677220ULL, 0x040fe20000410000ULL, 0x000000661a667220ULL, 0x040fe20000410000ULL,
0x0000005d1a5d7220ULL, 0x040fe20000410000ULL, 0x0000005b1a247220ULL, 0x040fe20000410000ULL,
0x0000005a1a5a7220ULL, 0x040fe20000410000ULL, 0x000000711a717220ULL, 0x000fe20000410000ULL,
0x0000000121217824ULL, 0x000fe200078e0200ULL, 0x00000008231a7810ULL, 0x000fe20007ffe0ffULL,
0x0000005402547220ULL, 0x040fe20000410000ULL, 0x0000005302537220ULL, 0x040fe20000410000ULL,
0x0000005202077220ULL, 0x000fe20000410000ULL, 0x000000031a277819ULL, 0x000fe200000006ffULL,
0x0000005102087220ULL, 0x040fe20000410000ULL, 0x00000007210c7812ULL, 0x040fe200078ec0ffULL,
0x0000005002507220ULL, 0x040fe20000410000ULL, 0x0000000421217812ULL, 0x000fe200078e3cffULL,
0x0000004f024f7220ULL, 0x040fe20000410000ULL, 0xfffffff825257812ULL, 0x000fe200078ee20cULL,
0x0000004e02097220ULL, 0x040fe20000410000ULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x0000004d020a7220ULL, 0x040fe20000410000ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20cULL,
0x0000004c024c7220ULL, 0x040fe20000410000ULL, 0xfffffff833337812ULL, 0x000fe200078ee20cULL,
0x00000008230c7824ULL, 0x000fe200078e00ffULL, 0x0000000721217812ULL, 0x000fe200078ec0ffULL,
0x0000004b024b7220ULL, 0x040fe20000410000ULL, 0x0000004a020b7220ULL, 0x000fe20000410000ULL,
0x000000031a1a7819ULL, 0x000fe200000006ffULL, 0x0000004902027220ULL, 0x000fe20000410000ULL,
0xfffffff80c237812ULL, 0x000fe200078ee221ULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0xfffffff81a2d7812ULL, 0x000fe200078ee221ULL, 0x0000001025257824ULL, 0x100fe200078e0214ULL,
0x000000050605723eULL, 0x000fe200000010ffULL, 0x0000001023237824ULL, 0x100fe200078e0214ULL,
0x000000045704723eULL, 0x000fe200000010ffULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x000000545306723eULL, 0x000fe200000010ffULL, 0x0000003819387220ULL, 0x040fe20000410000ULL,
0x000000070807723eULL, 0x000fe200000010ffULL, 0x0000003719377220ULL, 0x040fe20000410000ULL,
0x000000090a09723eULL, 0x000fe200000010ffULL, 0x0000003619367220ULL, 0x000fe20000410000ULL,
0x000000504f08723eULL, 0x000fe200000010ffULL, 0x0000003519357220ULL, 0x000fe20000410000ULL,
0x0000004c4b0a723eULL, 0x000fe200000010ffULL, 0x0000003419347220ULL, 0x040fe20000410000ULL,
0x0000000b020b723eULL, 0x000fe200000010ffULL, 0x0000002b192b7220ULL, 0x040fe20000410000ULL,
0x0000000d0e0d723eULL, 0x000fe200000010ffULL, 0x0000002a192a7220ULL, 0x000fe20000410000ULL,
0x00000048470c723eULL, 0x000fe200000010ffULL, 0x0000002919297220ULL, 0x000fe20000410000ULL,
0x00000044430e723eULL, 0x000fe200000010ffULL, 0x0000006f196f7220ULL, 0x040fe20000410000ULL,
0x0000000f100f723eULL, 0x000fe200000010ffULL, 0x0000006019607220ULL, 0x040fe20000410000ULL,
0x000000111211723eULL, 0x000fe200000010ffULL, 0x0000006e196e7220ULL, 0x000fe20000410000ULL,
0x0000001427277211ULL, 0x000fe200078e20ffULL, 0x0000005e19037220ULL, 0x000fe20000410000ULL,
0x000000403f10723eULL, 0x000fe200000010ffULL, 0x0000006d196d7220ULL, 0x000fe20000410000ULL,
0x0000003c3b12723eULL, 0x000fe200000010ffULL, 0x0000005c195c7220ULL, 0x040fe20000410000ULL,
0x000000131613723eULL, 0x000fe200000010ffULL, 0x0000006c196c7220ULL, 0x000fe20000410000ULL,
0x000000142d2d7211ULL, 0x000fe200078e20ffULL, 0x0000005919197220ULL, 0x000fe20000410000ULL,
0xfffffff828317812ULL, 0x000fe200078ee221ULL, 0x0000000425007844ULL, 0x0003e20000000200ULL,
0xfffffff82c217812ULL, 0x000fe200078ee221ULL, 0x000000102f027824ULL, 0x100fe200078e0214ULL,
0x000000383738723eULL, 0x000fe200000010ffULL, 0x0000000823007844ULL, 0x0005e20000000200ULL,
0x000000363539723eULL, 0x000fe200000010ffULL, 0x0000001031167824ULL, 0x100fe200078e0214ULL,
0x000000342b3a723eULL, 0x000fe200000010ffULL, 0x0000000c27007844ULL, 0x000fe20000000200ULL,
0x0000002a293b723eULL, 0x000fe200000010ffULL, 0x00000010331a7824ULL, 0x000fc400078e0214ULL,
0x000000102d007844ULL, 0x0007e20000000200ULL, 0x0000001021217824ULL, 0x000fe200078e0214ULL,
0x0000006f6004723eULL, 0x002fe400000010ffULL, 0x0000003802007844ULL, 0x0003e20000000200ULL,
0x0000006e0305723eULL, 0x000fe400000010ffULL, 0x0000006d5c06723eULL, 0x000fe400000010ffULL,
0x0000006c1907723eULL, 0x000fe400000010ffULL, 0x0000006b1c08723eULL, 0x004fc400000010ffULL,
0x000000641b09723eULL, 0x000fe200000010ffULL, 0x0000000416007844ULL, 0x000fe20000000200ULL,
0x0000000117107824ULL, 0x008fe200078e0200ULL, 0x00000069680a723eULL, 0x000fe400000010ffULL,
0x00000063620b723eULL, 0x000fe400000010ffULL, 0x000000611e0c723eULL, 0x000fe200000010ffULL,
0x000000ff00027306ULL, 0x002e620000202400ULL, 0x00000067660d723eULL, 0x000fe200000010ffULL,
0x000000081a007844ULL, 0x000fe20000000200ULL, 0x0000005d240e723eULL, 0x000fc400000010ffULL,
0x0000005a710f723eULL, 0x000fe400000010ffULL, 0x0000001d10037211ULL, 0x000fc600078e20ffULL,
0x0000000c21007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000003107984ULL, 0x000e680000000c00ULL, 0x00040000032c7984ULL, 0x000ea80000000c00ULL,
0x0008000003347984ULL, 0x000ee80000000c00ULL, 0x000c000003047984ULL, 0x000f280000000c00ULL,
0x0010000003287984ULL, 0x000f680000000c00ULL, 0x0014000003307984ULL, 0x000f280000000c00ULL,
0x0018000003387984ULL, 0x000f280000000c00ULL, 0x001c000003087984ULL, 0x000f620000000c00ULL,
0x0000001302137230ULL, 0x002fc40000200800ULL, 0x0000001202127230ULL, 0x040fe40000200800ULL,
0x0000001102117230ULL, 0x040fe40000200800ULL, 0x0000001002107230ULL, 0x040fe40000200800ULL,
0x0000002f022f7230ULL, 0x044fe40000200800ULL, 0x0000002e022e7230ULL, 0x040fe40000200800ULL,
0x0000002d022d7230ULL, 0x000fc40000200800ULL, 0x0000002c022c7230ULL, 0x040fe40000200800ULL,
0x0000003702377230ULL, 0x048fe40000200800ULL, 0x0000003602367230ULL, 0x040fe40000200800ULL,
0x0000003502357230ULL, 0x040fe40000200800ULL, 0x0000003402347230ULL, 0x040fe40000200800ULL,
0x0000000702077230ULL, 0x010fc40000200800ULL, 0x0000000602067230ULL, 0x040fe40000200800ULL,
0x0000000502057230ULL, 0x040fe40000200800ULL, 0x0000000402047230ULL, 0x000fe40000200800ULL,
0x0000002b13137230ULL, 0x020fe40000200000ULL, 0x0000002a12127230ULL, 0x000fe40000200000ULL,
0x0000002911117230ULL, 0x000fc40000200000ULL, 0x0000002810107230ULL, 0x000fe40000200000ULL,
0x000000332f2f7230ULL, 0x000fe40000200000ULL, 0x000000322e2e7230ULL, 0x000fe20000200000ULL,
0x0000001003007388ULL, 0x0003e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000200000ULL,
0x000000302c2c7230ULL, 0x000fe40000200000ULL, 0x0000003b37377230ULL, 0x000fc40000200000ULL,
0x0000003a36367230ULL, 0x000fe20000200000ULL, 0x0004002c03007388ULL, 0x0003e20000000c00ULL,
0x0000003935357230ULL, 0x000fe40000200000ULL, 0x0000003834347230ULL, 0x000fe40000200000ULL,
0x0000000b07077230ULL, 0x000fe40000200000ULL, 0x0000000a06067230ULL, 0x000fe20000200000ULL,
0x0008003403007388ULL, 0x0003e20000000c00ULL, 0x0000000905057230ULL, 0x000fc40000200000ULL,
0x0000000804047230ULL, 0x000fca0000200000ULL, 0x000c000403007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x002fc80000011600ULL,
0x000000200700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x0000000800047d06ULL, 0x000e620008209000ULL, 0x00000008ff0c7c12ULL, 0x000fe2000f8e33ffULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00000020000e7836ULL, 0x000fe20000000000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000007000a7812ULL, 0x000fc600078ec0ffULL,
0x00000003ff0b7819ULL, 0x000fe2000001160eULL, 0x0000000400047308ULL, 0x002e640000001000ULL,
0x0ffffffe04067836ULL, 0x002fcc0000000000ULL, 0x0000000600037305ULL, 0x000e64000021f000ULL,
0x000000ffff057224ULL, 0x002fc800078e0a03ULL, 0x0000000805057c24ULL, 0x000fc8000f8e02ffULL,
0x00000005030d7227ULL, 0x000fe200078e0002ULL, 0x0000000722027210ULL, 0x000fc60007ffe0ffULL,
0x0000000107077824ULL, 0x000fe400078e0200ULL, 0x000000020d037227ULL, 0x000fc600078e00ffULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a03ULL,
0x0000000805047c24ULL, 0x000fca000f8e0202ULL, 0x0000000804007c0cULL, 0x000fda000bf06070ULL,
0x8000000804040c36ULL, 0x000fe20008000000ULL, 0x0000000103030810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000804007c0cULL, 0x000fe4000bf26070ULL,
0x0ffffff807047812ULL, 0x000fca00078ef800ULL, 0x0000001004047824ULL, 0x000fcc00078e021dULL,
0x0000000103031836ULL, 0x000fe20000000000ULL, 0x0000000004047984ULL, 0x000e680000000c00ULL,
0x000000030c037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000000903037c24ULL, 0x000fe4000f8e0226ULL, 0x0000000809027c24ULL, 0x000fe4000f8e0202ULL,
0x0000000815097824ULL, 0x000fe400078e020aULL, 0x0000000803027c24ULL, 0x000fca000f8e0202ULL,
0x000000021f037210ULL, 0x000fc80007f3e0ffULL, 0x000000ffff087210ULL, 0x000fe40000ffe4ffULL,
0x0000000403027c11ULL, 0x000fc8000f8240ffULL, 0x0000000503037c11ULL, 0x000fe400088f4408ULL,
0x000000200b00720cULL, 0x000fe20003f26070ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0023ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000122027824ULL, 0x102fe200078e020bULL, 0x000000070e087812ULL, 0x040fe200078ec0ffULL,
0x000000010e0b7824ULL, 0x000fe400078e020bULL, 0x000000020d037227ULL, 0x000fc600078e00ffULL,
0x000000070b0b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff03057210ULL, 0x000fca0007ffe1ffULL,
0x0000000805047c24ULL, 0x000fca000f8e0202ULL, 0x0000000804007c0cULL, 0x000fda000bf26070ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x0000000103031836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff80b047812ULL, 0x000fe400078ef80eULL,
0x00000040000e7810ULL, 0x000fe40007ffe0ffULL, 0x0000001d04047211ULL, 0x000fe400078e20ffULL,
0x00000003ff0b7819ULL, 0x000fc8000001160eULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x0000000103032836ULL, 0x000fca0000000000ULL, 0x000000030c037207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a03ULL, 0x0000000903037c24ULL, 0x000fe4000f8e0226ULL,
0x0000000809027c24ULL, 0x000fe4000f8e0202ULL, 0x0000000815097824ULL, 0x000fe400078e0208ULL,
0x0000000803027c24ULL, 0x000fca000f8e0202ULL, 0x000000021f037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8240ffULL,
0x0000000503037c11ULL, 0x000fe400088f440aULL, 0x000000200b00720cULL, 0x000fe20003f26070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000122027824ULL, 0x102fe200078e020bULL,
0x000000070e087812ULL, 0x040fe200078ec0ffULL, 0x000000010e0b7824ULL, 0x000fe400078e020bULL,
0x000000020d037227ULL, 0x000fc600078e00ffULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x0000000805047c24ULL, 0x000fca000f8e0202ULL,
0x0000000804007c0cULL, 0x000fda000bf26070ULL, 0x8000000804041c10ULL, 0x000fe2000fffe0ffULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff80b047812ULL, 0x000fe200078ef80eULL, 0x00000060000e7836ULL, 0x000fc80000000000ULL,
0x0000001004047824ULL, 0x000fe200078e021dULL, 0x00000003ff0b7819ULL, 0x000fca000001160eULL,
0x0000000103032810ULL, 0x000fe20007ffe0ffULL, 0x0000000004047984ULL, 0x000e660000000c00ULL,
0x000000030c037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000000903037c24ULL, 0x000fe4000f8e0226ULL, 0x0000000809027c24ULL, 0x000fe2000f8e0202ULL,
0x0000000815097211ULL, 0x000fc600078e18ffULL, 0x0000000803027c24ULL, 0x000fca000f8e0202ULL,
0x000000021f037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000403027c11ULL, 0x000fc8000f8240ffULL, 0x0000000503037c11ULL, 0x000fe400088f440aULL,
0x000000200b00720cULL, 0x000fe20003f26070ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0023ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000122027824ULL, 0x002fe200078e020bULL, 0x0000000b0e0b7210ULL, 0x000fe40007ffe0ffULL,
0x000000070e087812ULL, 0x000fe200078ec0ffULL, 0x000000020d037227ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fc600078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a03ULL,
0x0000000805047c24ULL, 0x000fca000f8e0202ULL, 0x0000000804007c0cULL, 0x000fda000bf26070ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x0000000103031836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff80b047812ULL, 0x000fe200078ef80eULL,
0x00000080000e7836ULL, 0x000fc80000000000ULL, 0x0000001004047824ULL, 0x000fe200078e021dULL,
0x00000003ff0b7819ULL, 0x000fca000001160eULL, 0x0000000103032836ULL, 0x000fe20000000000ULL,
0x0000000004047984ULL, 0x000e680000000c00ULL, 0x000000030c037207ULL, 0x000fc80004000000ULL,
0x000000ff03097210ULL, 0x000fe20007ffe1ffULL, 0x0000000903037c24ULL, 0x000fc8000f8e0226ULL,
0x0000000809027c24ULL, 0x000fe4000f8e0202ULL, 0x0000000815097824ULL, 0x000fe400078e0208ULL,
0x0000000803027c24ULL, 0x000fca000f8e0202ULL, 0x000000021f037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8240ffULL,
0x0000000503037c11ULL, 0x000fe400088f440aULL, 0x000000200b00720cULL, 0x000fe20003f26070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000b22027210ULL, 0x002fe20007ffe0ffULL,
0x000000010e0b7824ULL, 0x040fe200078e020bULL, 0x000000070e087812ULL, 0x000fc600078ec0ffULL,
0x000000020d037227ULL, 0x000fe200078e00ffULL, 0x000000070b0b7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x0000000805047c24ULL, 0x000fca000f8e0202ULL,
0x0000000804007c0cULL, 0x000fda000bf26070ULL, 0x8000000804041c36ULL, 0x000fe20008000000ULL,
0x0000000103031810ULL, 0x000fc80007ffe0ffULL, 0x0000000804007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff80b047812ULL, 0x000fe200078ef80eULL, 0x000000a0000e7836ULL, 0x000fc80000000000ULL,
0x0000001004047824ULL, 0x000fe200078e021dULL, 0x00000003ff0b7819ULL, 0x000fca000001160eULL,
0x0000000103032836ULL, 0x000fe20000000000ULL, 0x0000000004047984ULL, 0x000e680000000c00ULL,
0x000000030c037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000000903037c24ULL, 0x000fe4000f8e0226ULL, 0x0000000809027c24ULL, 0x000fe4000f8e0202ULL,
0x0000000815097824ULL, 0x000fe400078e0208ULL, 0x0000000803027c24ULL, 0x000fca000f8e0202ULL,
0x000000021f037210ULL, 0x000fc80007f3e0ffULL, 0x000000ffff0a7210ULL, 0x000fe40000ffe4ffULL,
0x0000000403027c11ULL, 0x000fc8000f8240ffULL, 0x0000000503037c11ULL, 0x000fe400088f440aULL,
0x000000200b00720cULL, 0x000fe20003f26070ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0023ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000122027824ULL, 0x102fe200078e020bULL, 0x000000070e087812ULL, 0x040fe200078ec0ffULL,
0x000000010e0b7824ULL, 0x000fe400078e020bULL, 0x000000020d037227ULL, 0x000fc600078e00ffULL,
0x000000070b0b7812ULL, 0x000fe400078ec0ffULL, 0x000000ff03057210ULL, 0x000fca0007ffe1ffULL,
0x0000000805047c24ULL, 0x000fca000f8e0202ULL, 0x0000000804007c0cULL, 0x000fda000bf26070ULL,
0x8000000804041c36ULL, 0x000fe40008000000ULL, 0x0000000103031836ULL, 0x000fc60000000000ULL,
0x0000000804007c0cULL, 0x000fe4000bf46070ULL, 0x0ffffff80b047812ULL, 0x000fe400078ef80eULL,
0x000000c0000e7810ULL, 0x000fe40007ffe0ffULL, 0x0000001d04047211ULL, 0x000fe400078e20ffULL,
0x00000003ff0b7819ULL, 0x000fc8000001160eULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x0000000103032836ULL, 0x000fca0000000000ULL, 0x000000030c037207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a03ULL, 0x0000000903037c24ULL, 0x000fe4000f8e0226ULL,
0x0000000809027c24ULL, 0x000fe4000f8e0202ULL, 0x0000000815097824ULL, 0x000fe400078e0208ULL,
0x0000000803027c24ULL, 0x000fca000f8e0202ULL, 0x000000021f037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000000403027c11ULL, 0x000fc8000f8240ffULL,
0x0000000503037c11ULL, 0x000fe400088f440aULL, 0x000000200b00720cULL, 0x000fe20003f26070ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x0023ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000122027824ULL, 0x102fe200078e020bULL,
0x000000070e087812ULL, 0x040fe200078ec0ffULL, 0x000000010e0b7824ULL, 0x000fe400078e020bULL,
0x000000020d037227ULL, 0x000fc600078e00ffULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a03ULL, 0x0000000805047c24ULL, 0x000fca000f8e0202ULL,
0x0000000804007c0cULL, 0x000fda000bf26070ULL, 0x8000000804041c10ULL, 0x000fe2000fffe0ffULL,
0x0000000103031836ULL, 0x000fc60000000000ULL, 0x0000000804007c0cULL, 0x000fe4000bf46070ULL,
0x0ffffff80b047812ULL, 0x000fca00078ef80eULL, 0x0000001004047824ULL, 0x000fcc00078e021dULL,
0x0000000103032810ULL, 0x000fe20007ffe0ffULL, 0x0000000004047984ULL, 0x000e660000000c00ULL,
0x000000030c037207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a03ULL,
0x0000000903037c24ULL, 0x000fe4000f8e0226ULL, 0x0000000809027c24ULL, 0x000fe2000f8e0202ULL,
0x0000000815097211ULL, 0x000fc600078e18ffULL, 0x0000000803027c24ULL, 0x000fca000f8e0202ULL,
0x000000021f037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000000403027c11ULL, 0x000fc8000f8240ffULL, 0x0000000503037c11ULL, 0x000fe200088f440aULL,
0x000000e0000a7836ULL, 0x000fe40000000000ULL, 0x0000001009027825ULL, 0x000fc600078e0002ULL,
0x00000003ff0b7819ULL, 0x000fc8000001160aULL, 0x000000200b00720cULL, 0x000fe20003f26070ULL,
0x0000000402007986ULL, 0x0023e2000c101d06ULL, 0x0000000122227824ULL, 0x000fd600078e020bULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000220d027227ULL, 0x002fe200078e00ffULL,
0x0000000b0a0b7210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff037224ULL, 0x000fe200078e0a02ULL,
0x000000070b0b7812ULL, 0x000fc600078ec0ffULL, 0x0000000803007c24ULL, 0x000fca000f8e0222ULL,
0x0000000800007c0cULL, 0x000fda000bf26070ULL, 0x8000000800001c36ULL, 0x000fe40008000000ULL,
0x0000000102021836ULL, 0x000fc60000000000ULL, 0x0000000800007c0cULL, 0x000fe4000bf46070ULL,
0xfffffff80b007812ULL, 0x000fca00078ef80aULL, 0x00000010001d7824ULL, 0x000fe200078e021dULL,
0x000000070a007812ULL, 0x000fc800078ec0ffULL, 0x000000001d047984ULL, 0x000e620000000c00ULL,
0x0000000102022836ULL, 0x000fe40000000000ULL, 0x0000000815157824ULL, 0x000fc600078e0200ULL,
0x000000020c037207ULL, 0x000fc80004000000ULL, 0x000000ff03097210ULL, 0x000fe20007ffe1ffULL,
0x0000000903037c24ULL, 0x000fc8000f8e0226ULL, 0x0000000809227c24ULL, 0x000fc8000f8e0222ULL,
0x0000000803227c24ULL, 0x000fca000f8e0222ULL, 0x000000221f227210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000422027c11ULL, 0x000fc8000f8040ffULL,
0x0000000522037c11ULL, 0x000fc600080f4403ULL, 0x0000001015027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff007819ULL, 0x000fe20000011624ULL, 0x00000001ff087424ULL, 0x000fe200078e00ffULL,
0x00009000ff0c7b82ULL, 0x000e620000000a00ULL, 0x00000001210f7836ULL, 0x000fe20000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000221007824ULL, 0x000fca00078e0200ULL,
0x0000001b0000720cULL, 0x000fe20003f06070ULL, 0x01e600081d0879a7ULL, 0x000498000850003fULL,
0x00009600ff028b82ULL, 0x000ee20000000800ULL, 0x0000000129058819ULL, 0x000fce00000006ffULL,
0x00009200ff0a8b82ULL, 0x000f220000000a00ULL, 0x0000000205058224ULL, 0x008fe400078e0200ULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x00000004050a8825ULL, 0x010fca00078e000aULL,
0x000000060a028981ULL, 0x000ee2000c1e1900ULL, 0x0000001a0f00720cULL, 0x000fe20003f06070ULL,
0x0000004024047824ULL, 0x000fe200078e00ffULL, 0x0000000715057819ULL, 0x000fe200000006ffULL,
0x0000001f04047890ULL, 0x000fe2000fffe03fULL, 0x0000008026267824ULL, 0x000fe400078e00ffULL,
0x0000010021117824ULL, 0x000fe200078e0204ULL, 0x000000053f047899ULL, 0x000fe20008011604ULL,
0x00000005020f7224ULL, 0x008fc800078e02ffULL, 0x000001000f0a7825ULL, 0x002fe200078e000cULL,
0x00000040260d7812ULL, 0x000fe200078ef811ULL, 0x0000000c00208947ULL, 0x004fec0003800000ULL,
0x000000111c0c7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3d7819ULL, 0x000fc6000001161eULL,
0x000000010c0c7824ULL, 0x000fe200078e0a11ULL, 0x000000043d0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e023dULL, 0x000000243d357810ULL, 0x000fe20007ffe0ffULL,
0x000000083d137836ULL, 0x000fe20000000000ULL, 0x0000001e0f117210ULL, 0x000fe20007ffe0ffULL,
0x000000080f207824ULL, 0x040fe200078e00ffULL, 0x0000000c0f00720cULL, 0x000fe20003fa6070ULL,
0x000000103d177836ULL, 0x000fe20000000000ULL, 0x0000000f0d107210ULL, 0x000fe20007ffe0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fc600078ee211ULL,
0x0000000113127824ULL, 0x140fe200078e021eULL, 0x000000700e197812ULL, 0x000fe200078ef807ULL,
0x0000000813157824ULL, 0x000fe400078e00ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000190a187210ULL, 0x000fe40007f1e0ffULL, 0xfffffff815347812ULL, 0x000fe200078ee212ULL,
0x00000001170e7824ULL, 0x040fe200078e021eULL, 0x00000070102b7812ULL, 0x000fe200078ef807ULL,
0x0000000817237824ULL, 0x000fc400078e00ffULL, 0x0000000c3d157836ULL, 0x000fe20000000000ULL,
0x0000002b0a2a7210ULL, 0x000fe20007f3e0ffULL, 0x000000010b197824ULL, 0x000fe200000e060fULL,
0xfffffff823387812ULL, 0x000fe200078ee20eULL, 0x000000010d0e7824ULL, 0x000fe200078e0213ULL,
0x00000003151f7819ULL, 0x000fe200000006ffULL, 0x000000010d107824ULL, 0x000fe200078e0215ULL,
0x000000110b2b7210ULL, 0x000fe20000ffe4ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000c1700720cULL, 0x080fe40003f06070ULL, 0x0000000c1300720cULL, 0x000fe20003f26070ULL,
0x0000000115127824ULL, 0x000fe200078e021eULL, 0x000000700e2d7812ULL, 0x000fe200078ef807ULL,
0x000000183d397836ULL, 0x000fe20000000000ULL, 0x0000001d240e7211ULL, 0x000fe200078e70ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffff81f367812ULL, 0x000fc400078ee212ULL,
0x000000170d127210ULL, 0x000fe20007ffe0ffULL, 0x000000010d167824ULL, 0x000fe200078e0239ULL,
0x00000070102f7812ULL, 0x000fe200078ef807ULL, 0x000000143d237836ULL, 0x000fe20000000000ULL,
0x0000002d0a2c7210ULL, 0x000fe20007f7e0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000002f0a2e7210ULL, 0x000fe40007f9e0ffULL, 0x0000000f0b2d7210ULL, 0x000fe20001ffe4ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x00000070160f7812ULL, 0x000fc400078ef807ULL,
0x0000000c1500720cULL, 0x000fe20003f46070ULL, 0x0000001c3d3b7836ULL, 0x000fe20000000000ULL,
0x00000070121f7812ULL, 0x000fe200078ef807ULL, 0x000000010b2f7824ULL, 0x000fe200020e0611ULL,
0x0000000f0a167210ULL, 0x000fe20007f9e0ffULL, 0x000000010d147824ULL, 0x040fe200078e0223ULL,
0x0000001f0a127210ULL, 0x000fe20007f7e0ffULL, 0x000000010d0f7824ULL, 0x000fe200078e023bULL,
0x0000001e3d107210ULL, 0x000fe20007ffe0ffULL, 0x000020000e1f7836ULL, 0x000fe20000000000ULL,
0x00000003233a7819ULL, 0x000fe200000006ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x00000003393c7819ULL, 0x000fc600000006ffULL, 0x000001000f0e7825ULL, 0x000fe200078e00ffULL,
0x0000007014117812ULL, 0x000fc600078ef807ULL, 0x000000203d277836ULL, 0x000fe20000000000ULL,
0x000000700e317812ULL, 0x000fe200078ef807ULL, 0x000000010b137824ULL, 0x000fe200018e0613ULL,
0x000000110a147210ULL, 0x000fe20007f7e0ffULL, 0x000000010d0e7824ULL, 0x000fe200078e0227ULL,
0x000000310a307210ULL, 0x000fe20007fde0ffULL, 0x000000010b177824ULL, 0x040fe200020e0617ULL,
0x0000000710117812ULL, 0x000fe200078ec0ffULL, 0x000000010b157824ULL, 0x000fe200018e0615ULL,
0x0000000c3d00720cULL, 0x080fe20003f86070ULL, 0x000000010b317824ULL, 0x000fe200030e060fULL,
0x0ffffff811107812ULL, 0x000fe200078ef81eULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000c2300720cULL, 0x000fc60003f66070ULL, 0x0000000123257824ULL, 0x000fe200078e021eULL,
0x000000700e337812ULL, 0x000fe200078ef807ULL, 0x0000001010237824ULL, 0x000fe400078e021fULL,
0x000000010d107824ULL, 0x000fe200078e0235ULL, 0x000000330a327210ULL, 0x000fe20007fde0ffULL,
0x000000283d377836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000e101c46ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee225ULL, 0x0000000c3900720cULL, 0x000fe20003f86070ULL,
0x000000010d0e7824ULL, 0x000fc400078e0237ULL, 0x000000010b337824ULL, 0x000fe400030e060fULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007010197812ULL, 0x002fc600078ef807ULL,
0x0000000139257824ULL, 0x000fe400078e021eULL, 0x0000002c3d397836ULL, 0x000fe20000000000ULL,
0x000000190a107210ULL, 0x000fe20007fde0ffULL, 0x0000001020237824ULL, 0x000fe200078e021fULL,
0x000000700e197812ULL, 0x000fe200078ef807ULL, 0x000000010d0e7824ULL, 0x000fe200078e0239ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee225ULL, 0x000000010b117824ULL, 0x000fe200030e0611ULL,
0x000000190a187210ULL, 0x000fe20007fde0ffULL, 0x000000002a237faeULL, 0x0003e2000e901c46ULL,
0x0000001f34257211ULL, 0x000fc400078e20ffULL, 0x0000000c3b00720cULL, 0x080fe20003fa6070ULL,
0x000000010b197824ULL, 0x000fe200030e060fULL, 0x0000001e3b207210ULL, 0x000fe20007ffe0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000002c257faeULL, 0x0005e2000c901c46ULL,
0x0000000c2700720cULL, 0x080fe40003f26070ULL, 0x000000083b3b7824ULL, 0x000fe400078e00ffULL,
0x0000001036237824ULL, 0x002fe200078e021fULL, 0x000000700e2b7812ULL, 0x000fe200078ef807ULL,
0x00000001350e7824ULL, 0x040fe200078e021eULL, 0xfffffff83b3e7812ULL, 0x000fe200078ee220ULL,
0x000000383d3b7836ULL, 0x000fe20000000000ULL, 0x000000002e237faeULL, 0x0003e2000d101c46ULL,
0x0000000c3500720cULL, 0x040fe20003f46070ULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x0000001e27207210ULL, 0x000fe20007ffe0ffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0000002b0a2a7210ULL, 0x000fc40007fde0ffULL, 0xfffffff8350e7812ULL, 0x000fe200078ee20eULL,
0x000000303d357836ULL, 0x000fe20000000000ULL, 0xfffffff827207812ULL, 0x000fe200078ee220ULL,
0x000000010b2b7824ULL, 0x000fe200030e060fULL, 0x0000001f38257211ULL, 0x084fe200078e20ffULL,
0x000000103a0f7824ULL, 0x100fe200078e021fULL, 0x0000001f3e277211ULL, 0x000fe200078e20ffULL,
0x000000100e2f7824ULL, 0x102fe200078e021fULL, 0x000000350d0e7210ULL, 0x000fe20007ffe0ffULL,
0x000000103c237824ULL, 0x100fe200078e021fULL, 0x0000000012257faeULL, 0x0003e2000c101c46ULL,
0x00000010202d7824ULL, 0x000fc400078e021fULL, 0x000000083b2e7824ULL, 0x000fe200078e00ffULL,
0x00000000140f7faeULL, 0x0005e2000d901c46ULL, 0x0000000c3500720cULL, 0x000fc60003f66070ULL,
0x0000000016237faeULL, 0x0007e2000e101c46ULL, 0x0000000c3900720cULL, 0x000fc60003f86070ULL,
0x0000000030277faeULL, 0x0009e2000e901c46ULL, 0x000000343d257836ULL, 0x002fe20000000000ULL,
0x0000001e37137210ULL, 0x000fe20007ffe0ffULL, 0x0000003c3d3d7836ULL, 0x000fe20000000000ULL,
0x00000000322d7faeULL, 0x000fe2000c901c46ULL, 0x000001000e0e7825ULL, 0x004fe200078e00ffULL,
0x0000000c3700720cULL, 0x080fe40003fa6070ULL, 0x00000000102f7faeULL, 0x0005e2000d101c46ULL,
0x000000010d147824ULL, 0x000fe200078e0225ULL, 0x0000000c2500720cULL, 0x080fe20003f46070ULL,
0x0000000837167824ULL, 0x008fe200078e00ffULL, 0x0000000c3b00720cULL, 0x080fe20003f26070ULL,
0x0000000125157824ULL, 0x100fe200078e021eULL, 0x0000000c3d00720cULL, 0x000fe20003f06070ULL,
0x00000008252c7824ULL, 0x000fe200078e00ffULL, 0x0000001e390c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x000000033d307819ULL, 0x010fe200000006ffULL,
0x000000013b177824ULL, 0x100fe200078e021eULL, 0x000000700e117812ULL, 0x004fe200078ef807ULL,
0x00000001350e7824ULL, 0x000fc400078e021eULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x000000110a127210ULL, 0x000fe20007fde0ffULL, 0x0000010014107825ULL, 0x000fe200078e00ffULL,
0xfffffff816147812ULL, 0x000fe400078ee213ULL, 0xfffffff835207812ULL, 0x000fe200078ee20eULL,
0x000000010b137824ULL, 0x000fe200030e060fULL, 0x00000070100f7812ULL, 0x000fe200078ef807ULL,
0x000000013d237824ULL, 0x000fe200078e021eULL, 0xfffffff839167812ULL, 0x000fe400078ee20cULL,
0x0000000f0a107210ULL, 0x000fc40007fde0ffULL, 0x0000003b0d0f7210ULL, 0x000fe40007ffe0ffULL,
0x0000003d0d0d7210ULL, 0x000fe20007ffe0ffULL, 0x000000010b117824ULL, 0x000fe200030e0611ULL,
0xfffffff82c1e7812ULL, 0x000fe200078ee215ULL, 0x000001000f0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff82e2c7812ULL, 0x000fe400078ee217ULL, 0xfffffff8302e7812ULL, 0x000fe200078ee223ULL,
0x000001000d0c7825ULL, 0x000fe200078e00ffULL, 0x000000700e257812ULL, 0x000fc400078ef807ULL,
0x0000001f20177211ULL, 0x000fe200078e20ffULL, 0x0000001016157824ULL, 0x100fe200078e021fULL,
0x000000250a0e7210ULL, 0x000fe20007fde0ffULL, 0x000000102c257824ULL, 0x100fe200078e021fULL,
0x000000700c237812ULL, 0x000fe200078ef807ULL, 0x0000001014077824ULL, 0x000fe400078e021fULL,
0x000000010b0f7824ULL, 0x000fe200030e060fULL, 0x000000230a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101e237824ULL, 0x100fe200078e021fULL, 0x0000000018077faeULL, 0x0003e2000e901c46ULL,
0x000000102e1f7824ULL, 0x000fe200078e021fULL, 0x0000000d0b0b7210ULL, 0x000fc400037fe4ffULL,
0x000000002a157faeULL, 0x0003e8000e101c46ULL, 0x0000000012177faeULL, 0x0003e8000d901c46ULL,
0x0000000010237faeULL, 0x0003e8000d101c46ULL, 0x000000000e257faeULL, 0x0003e8000c901c46ULL,
0x000000000a1f7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000c1e157811ULL, 0x040fe400078fe8ffULL, 0x000000041e137811ULL, 0x040fe400078fe8ffULL,
0x000000081e147811ULL, 0x040fe200078fe8ffULL, 0x00000001150f7824ULL, 0x140fe200078e021eULL,
0x0000001c1e327811ULL, 0x000fe200078fe8ffULL, 0x0000000815127824ULL, 0x000fe200078e00ffULL,
0x0000000314317819ULL, 0x000fe200000006ffULL, 0x00000001130c7824ULL, 0x140fe200078e021eULL,
0x000000141e2e7811ULL, 0x000fe200078fe8ffULL, 0x00000008132f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8123b7812ULL, 0x000fe200078ee20fULL, 0x00000001140e7824ULL, 0x100fe200078e021eULL,
0x000000201e0f7811ULL, 0x000fe200078fe8ffULL, 0x0000000132117824ULL, 0x100fe200078e021eULL,
0x000000101e207811ULL, 0x000fe200078fe8ffULL, 0x0000000832127824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x140fe200078e021eULL,
0xfffffff831317812ULL, 0x000fe200078ee20eULL, 0x000000012e0e7824ULL, 0x140fe200078e021eULL,
0xfffffff812437812ULL, 0x000fe200078ee211ULL, 0x000000082e3f7824ULL, 0x000fe200078e00ffULL,
0x000000030f177819ULL, 0x000fe200000006ffULL, 0x0000000120107824ULL, 0x000fe200078e021eULL,
0x000000241e117811ULL, 0x000fc400078fe8ffULL, 0x000000281e167811ULL, 0x000fe400078fe8ffULL,
0x00000003203d7819ULL, 0x000fe200000006ffULL, 0x0000000811197824ULL, 0x000fe200078e00ffULL,
0x000000181e307811ULL, 0x000fe200078fe8ffULL, 0x000000010d337824ULL, 0x000fe200078e0211ULL,
0xfffffff817177812ULL, 0x000fe200078ee20cULL, 0x00000001110c7824ULL, 0x100fe200078e021eULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20eULL, 0x00000001160e7824ULL, 0x100fe200078e021eULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee210ULL, 0x0000000130107824ULL, 0x000fe200078e021eULL,
0x0000000316257819ULL, 0x000fe200000006ffULL, 0x000000010d347824ULL, 0x000fe200078e0216ULL,
0x0000000330417819ULL, 0x000fc400000006ffULL, 0x0000002c1e1f7811ULL, 0x040fe400078fe8ffULL,
0xfffffff819187812ULL, 0x000fe400078ee20cULL, 0xfffffff825197812ULL, 0x000fe200078ee20eULL,
0x000000081f277824ULL, 0x040fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee210ULL,
0x000000011f107824ULL, 0x000fe200078e021eULL, 0x000000301e237811ULL, 0x040fe200078fe8ffULL,
0x000000010d357824ULL, 0x000fe200078e021fULL, 0x0000001e1e0e7211ULL, 0x000fc400078fe8ffULL,
0x000000341e257811ULL, 0x000fe200078fe8ffULL, 0x0000000123127824ULL, 0x000fe200078e021eULL,
0x000000070e2d7812ULL, 0x000fe200078ec0ffULL, 0x00000001130e7824ULL, 0x000fe200078e020dULL,
0x00000003232b7819ULL, 0x000fe200000006ffULL, 0x000000010d3c7824ULL, 0x000fe200078e0225ULL,
0xfffffff8272a7812ULL, 0x000fe200078ee210ULL, 0x0000000114107824ULL, 0x100fe200078e020dULL,
0x0000000d20137210ULL, 0x000fe20007ffe0ffULL, 0x0000000132207824ULL, 0x100fe200078e020dULL,
0x0000003c1e2c7811ULL, 0x000fe200078fe8ffULL, 0x000000012e147824ULL, 0x100fe200078e020dULL,
0x0000000d1e0c7211ULL, 0x040fe200078fe8ffULL, 0x00000008252e7824ULL, 0x000fe200078e00ffULL,
0x000000381e277811ULL, 0x000fe200078fe8ffULL, 0x000000010d407824ULL, 0x000fe200078e022cULL,
0x0000000f0d327210ULL, 0x000fe20007ffe0ffULL, 0x00000001250f7824ULL, 0x100fe200078e021eULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee212ULL, 0x0000000115127824ULL, 0x100fe200078e020dULL,
0x000000230d3a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000130157824ULL, 0x000fe200078e020dULL,
0x000000270d3e7210ULL, 0x000fe20007ffe0ffULL, 0x000000082c237824ULL, 0x000fe200078e00ffULL,
0x0ffffff82d2d7812ULL, 0x000fe200078ef81eULL, 0x0000000127117824ULL, 0x000fe200078e021eULL,
0x0000001e2c167210ULL, 0x000fe20007ffe0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff82e1e7812ULL, 0x000fc400078ee20fULL, 0xfffffff8232c7812ULL, 0x000fe200078ee216ULL,
0x00004000240f7824ULL, 0x000fe200078e021dULL, 0x000000700c237812ULL, 0x000fe200078ef807ULL,
0x0000000827307824ULL, 0x000fe400078e00ffULL, 0x000020000f0c7836ULL, 0x000fe20000000000ULL,
0x000000230a167210ULL, 0x000fe20007f1e0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff8301f7812ULL, 0x000fe400078ee211ULL, 0x0000000c17457211ULL, 0x080fe200078e20ffULL,
0x0000001019497824ULL, 0x000fe200078e020cULL, 0x000000700e197812ULL, 0x000fe200078ef807ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000000c2d237211ULL, 0x000fc400078e20ffULL,
0x0000000c3d3d7211ULL, 0x080fe200078e20ffULL, 0x0000001018477824ULL, 0x100fe200078e020cULL,
0x000000190a187210ULL, 0x000fe20007f3e0ffULL, 0x000000101f517824ULL, 0x100fe200078e020cULL,
0x0000000c2b4d7211ULL, 0x000fe200078e20ffULL, 0x000000102f257824ULL, 0x100fe200078e020cULL,
0x0000000d0b177210ULL, 0x000fe200007fe4ffULL, 0x0000001031277824ULL, 0x100fe200078e020cULL,
0x00000070101f7812ULL, 0x000fe200078ef807ULL, 0x000000103b3b7824ULL, 0x100fe400078e020cULL,
0x000000103f3f7824ULL, 0x100fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000b901c46ULL, 0x0000001041417824ULL, 0x000fc400078e020cULL,
0x0000001043437824ULL, 0x100fe400078e020cULL, 0x000000102a4b7824ULL, 0x100fe400078e020cULL,
0x000000101e4f7824ULL, 0x100fe200078e020cULL, 0x0000001f0a1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000102c537824ULL, 0x000fe400078e020cULL, 0x00000100120c7825ULL, 0x000fc800078e00ffULL,
0x000000010b197824ULL, 0x000fe200008e060fULL, 0x000000700c2b7812ULL, 0x000fe200078ef807ULL,
0x00000100130e7825ULL, 0x000fc600078e00ffULL, 0x0000000018257faeULL, 0x0003e2000b901c46ULL,
0x0000010014127825ULL, 0x000fe200078e00ffULL, 0x000000700e2d7812ULL, 0x000fc600078ef807ULL,
0x0000010015147825ULL, 0x000fe200078e00ffULL, 0x0000002d0a2c7210ULL, 0x000fe40007f3e0ffULL,
0x00000070122f7812ULL, 0x000fe200078ef807ULL, 0x000000010b1f7824ULL, 0x000fe200000e0611ULL,
0x0000002b0a2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010033107825ULL, 0x000fe200078e00ffULL,
0x0000007014317812ULL, 0x000fe400078ef807ULL, 0x0000000f0b2d7210ULL, 0x000fe20000ffe4ffULL,
0x000000010b2b7824ULL, 0x040fe200000e060dULL, 0x000000310a307210ULL, 0x000fe20007f5e0ffULL,
0x00000100200c7825ULL, 0x000fe200078e00ffULL, 0x0000002f0a2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000001e277faeULL, 0x0003e2000b901c46ULL, 0x0000007010377812ULL, 0x000fe200078ef807ULL,
0x00000100320e7825ULL, 0x000fe200078e00ffULL, 0x000000700c337812ULL, 0x000fe200078ef807ULL,
0x000000002a3b7faeULL, 0x0003e4000b901c46ULL, 0x000000010b317824ULL, 0x000fc400010e0615ULL,
0x0000010035147825ULL, 0x000fe200078e00ffULL, 0x000000700e357812ULL, 0x000fe200078ef807ULL,
0x000000002c3d7faeULL, 0x0003e4000b901c46ULL, 0x000000010b2f7824ULL, 0x040fe200000e0613ULL,
0x000000330a327210ULL, 0x000fe20007f1e0ffULL, 0x0000010034127825ULL, 0x000fe200078e00ffULL,
0x000000350a347210ULL, 0x000fe40007f3e0ffULL, 0x000000002e3f7faeULL, 0x0003e2000b901c46ULL,
0x000000010b337824ULL, 0x000fe200000e060dULL, 0x0000007012397812ULL, 0x000fe200078ef807ULL,
0x000001003a0c7825ULL, 0x000fe200078e00ffULL, 0x000000370a367210ULL, 0x000fe20007f1e0ffULL,
0x0000000030417faeULL, 0x0003e2000b901c46ULL, 0x0000000f0b357210ULL, 0x000fc40000ffe4ffULL,
0x00000070140f7812ULL, 0x000fe200078ef807ULL, 0x000000010b377824ULL, 0x040fe200000e0611ULL,
0x000000390a387210ULL, 0x000fe20007f5e0ffULL, 0x000001003e107825ULL, 0x000fe200078e00ffULL,
0x0000000f0a147210ULL, 0x000fe20007f1e0ffULL, 0x0000000032437faeULL, 0x0003e2000b901c46ULL,
0x000000700c597812ULL, 0x000fe200078ef807ULL, 0x000001003c0e7825ULL, 0x000fe200078e00ffULL,
0x0000007010557812ULL, 0x000fe200078ef807ULL, 0x0000000034457faeULL, 0x0003e4000b901c46ULL,
0x000000010b397824ULL, 0x040fe200010e0613ULL, 0x000000700e577812ULL, 0x000fe200078ef807ULL,
0x0000010040127825ULL, 0x000fe200078e00ffULL, 0x000000550a107210ULL, 0x000fe20007f5e0ffULL,
0x0000000036477faeULL, 0x0003e2000b901c46ULL, 0x000000570a0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000010b157824ULL, 0x040fe200000e0615ULL, 0x0000007012077812ULL, 0x000fe200078ef807ULL,
0x000000010b117824ULL, 0x040fe200010e0611ULL, 0x000000590a0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000010b0f7824ULL, 0x000fe200008e060fULL, 0x000000070a0a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000038497faeULL, 0x0003e2000b901c46ULL, 0x0000000d0b0d7210ULL, 0x000fc600007fe4ffULL,
0x000000010b0b7824ULL, 0x000fe200018e0613ULL, 0x00000000144b7faeULL, 0x0003e8000b901c46ULL,
0x000000000c4d7faeULL, 0x0003e8000b901c46ULL, 0x000000000e4f7faeULL, 0x0003e8000b901c46ULL,
0x0000000010517faeULL, 0x0003e8000b901c46ULL, 0x000000000a537faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000a7805ULL, 0x002fe20000015200ULL,
0x01e600091d0075a7ULL, 0x000ea2000800017fULL, 0x0000000406077c24ULL, 0x000fe2000f8e02ffULL,
0x800000031c067210ULL, 0x000fc80007ffe0ffULL, 0x00000008ff067819ULL, 0x000fe20000011606ULL,
0x00008e00ffaa7b82ULL, 0x000ee40000000a00ULL, 0x0000000407aa7825ULL, 0x008fe200078e00aaULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc8000001140dULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fce0007ffe0ffULL,
0x01e600091d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001a2100720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009600ff087b82ULL, 0x000e620000000800ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x0000000824147824ULL, 0x040fe200078e021dULL, 0x0000001d24127211ULL, 0x000fe200078e28ffULL,
0x0000000903097836ULL, 0x000fe20000000000ULL, 0x0000000104057899ULL, 0x000fe2000800063fULL,
0x0000000829297224ULL, 0x002fe400078e02ffULL, 0xffffffff03087836ULL, 0x000fd20000000000ULL,
0x00009000ffac7b82ULL, 0x000e620000000a00ULL, 0x00000001210d7836ULL, 0x008fe40000000000ULL,
0x00000100210b7824ULL, 0x000fc600078e0204ULL, 0x0000001a0d00720cULL, 0x000fe20003f06070ULL,
0x00000002050d7224ULL, 0x000fe200078e02ffULL, 0x000000400b0f7812ULL, 0x000fca00078ec0ffULL,
0x0000000126207824ULL, 0x000fe400078e020fULL, 0x000001000d0c7825ULL, 0x002fc800078e00acULL,
0x0000000800f08947ULL, 0x000fea0003800000ULL, 0x00000004071e7819ULL, 0x004fe200000006ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fe20000011607ULL,
0x0000400024447824ULL, 0x000fe200078e021dULL, 0x000000701e1e7812ULL, 0x000fe400078ec0ffULL,
0x0000000c27197810ULL, 0x000fe20007ffe0ffULL, 0x0000000127117824ULL, 0x000fe200078e0220ULL,
0x000000801e0e7812ULL, 0x000fe200078efcffULL, 0x0000000427137836ULL, 0x000fe20000000000ULL,
0x0000000319257819ULL, 0x000fe200000006ffULL, 0x0000001427377836ULL, 0x000fe20000000000ULL,
0x0000001c273d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0x00000003131f7819ULL, 0x000fc600000006ffULL, 0x0000000113027824ULL, 0x100fe200078e0207ULL,
0x000000100c2c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000827177836ULL, 0x000fe40000000000ULL,
0x00000010272b7836ULL, 0x000fe20000000000ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee202ULL,
0x00000001170a7824ULL, 0x000fe200078e0207ULL, 0x000000110d2d7210ULL, 0x000fe200007fe4ffULL,
0x0000000113117824ULL, 0x000fe200078e0220ULL, 0x0000000b1c027248ULL, 0x000fe20007fe0000ULL,
0x0000000817237824ULL, 0x000fc400078e00ffULL, 0x0000010011107825ULL, 0x000fc600078e000eULL,
0xfffffff823237812ULL, 0x000fe200078ee20aULL, 0x0000000102027824ULL, 0x000fe200078e0a0bULL,
0x000000100c2e7210ULL, 0x000fe20007f7e0ffULL, 0x000000012b157824ULL, 0x040fe400078e0207ULL,
0x000000082b167824ULL, 0x000fe200078e00ffULL, 0x000000021300720cULL, 0x080fe20003f86070ULL,
0x0000000137137824ULL, 0x100fe200078e0220ULL, 0x000000021700720cULL, 0x0c0fe20003f26070ULL,
0x0000000117177824ULL, 0x000fe200078e0220ULL, 0xfffffff8163b7812ULL, 0x000fe200078ee215ULL,
0x000000010d2f7824ULL, 0x000fe200018e0611ULL, 0x000000021900720cULL, 0x080fe20003f46070ULL,
0x0000010013107825ULL, 0x000fe200078e000eULL, 0x000000022b00720cULL, 0x000fc60003f06070ULL,
0x0000001827397836ULL, 0x000fe20000000000ULL, 0x000000100c347210ULL, 0x000fe20007fde0ffULL,
0x00000001190a7824ULL, 0x000fe200078e0207ULL, 0x0000002019197210ULL, 0x000fe20007ffe0ffULL,
0x0000010017167825ULL, 0x000fe200078e000eULL, 0x0000002039137210ULL, 0x000fe40007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000012b2b7824ULL, 0x000fe200078e0220ULL,
0x000000160c307210ULL, 0x000fe20007fbe0ffULL, 0x0000010019187825ULL, 0x000fe200078e000eULL,
0x0000000737167210ULL, 0x000fc40007ffe0ffULL, 0x000000170d317210ULL, 0x000fe20002ffe4ffULL,
0x000001002b2a7825ULL, 0x000fe200078e000eULL, 0x000000180c327210ULL, 0x000fe40007f7e0ffULL,
0x0ffffff807187812ULL, 0x000fe200078ec0ffULL, 0x000000010d357824ULL, 0x000fe200030e0611ULL,
0x0000002a0c2a7210ULL, 0x000fe20007fbe0ffULL, 0x0000010013107825ULL, 0x000fc800078e000eULL,
0x0000000127157824ULL, 0x000fe200078e0207ULL, 0x000000100c367210ULL, 0x000fe20007fde0ffULL,
0x000000010d2b7824ULL, 0x000fe200028e062bULL, 0x000000022700720cULL, 0x080fe20003fa6070ULL,
0x000000010d337824ULL, 0x000fe200018e0619ULL, 0x000000023700720cULL, 0x040fe20003f66070ULL,
0x0000000837197824ULL, 0x000fe200078e00ffULL, 0x0000000718137812ULL, 0x000fe200078ef815ULL,
0x000000010d377824ULL, 0x000fe200030e0611ULL, 0x000000203d117210ULL, 0x000fe20007ffe0ffULL,
0x00004000440a7836ULL, 0x000fe20000000000ULL, 0xfffffff819197812ULL, 0x000fe200078ee216ULL,
0x00000020273f7836ULL, 0x000fc40000000000ULL, 0x0000001013137824ULL, 0x000fe400078e020aULL,
0x0000010011107825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c137faeULL, 0x0003e2000e901c46ULL, 0x000000101f157824ULL, 0x000fe200078e020aULL,
0x000000100c387210ULL, 0x000fe20007fde0ffULL, 0x000000013f177824ULL, 0x000fe200078e0220ULL,
0x000000023900720cULL, 0x0c0fe20003fa6070ULL, 0x00000001391f7824ULL, 0x040fe200078e0207ULL,
0x000000002e157faeULL, 0x0005e2000e101c46ULL, 0x00000008393a7824ULL, 0x000fe200078e00ffULL,
0x000000073d107210ULL, 0x000fe20007ffe0ffULL, 0x0000010017167825ULL, 0x000fe200078e000eULL,
0x000000023d00720cULL, 0x000fc40003f86070ULL, 0xfffffff83a1f7812ULL, 0x000fe200078ee21fULL,
0x000000083d2d7824ULL, 0x002fe400078e00ffULL, 0x000000010d397824ULL, 0x000fe200030e0611ULL,
0x000000160c167210ULL, 0x000fe20007fde0ffULL, 0x0000001023137824ULL, 0x100fe200078e020aULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL, 0x00000024272f7836ULL, 0x004fe20000000000ULL,
0x000000073f237210ULL, 0x000fe20007ffe0ffULL, 0x0000001025157824ULL, 0x000fe200078e020aULL,
0x0000000030137faeULL, 0x0003e2000c901c46ULL, 0x000000012f117824ULL, 0x000fe200078e0220ULL,
0x000000023f00720cULL, 0x0c0fe20003f26070ULL, 0x000000083f2c7824ULL, 0x000fe200078e00ffULL,
0x0000000032157faeULL, 0x0005e2000d101c46ULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0x000000022f00720cULL, 0x000fc40003f46070ULL, 0x000000170d177210ULL, 0x000fe200037fe4ffULL,
0x000000012f257824ULL, 0x040fe200078e0207ULL, 0xfffffff82c237812ULL, 0x000fe200078ee223ULL,
0x000000082f2e7824ULL, 0x000fe200078e00ffULL, 0x000000100c107210ULL, 0x000fe20007fde0ffULL,
0x0000003027317836ULL, 0x002fe20000000000ULL, 0x0000000a3b137211ULL, 0x080fe200078e20ffULL,
0x0000001023237824ULL, 0x100fe200078e020aULL, 0xfffffff82e257812ULL, 0x000fe200078ee225ULL,
0x0000001019157824ULL, 0x104fe200078e020aULL, 0x0000002c272f7810ULL, 0x000fe20007ffe0ffULL,
0x000000101f197824ULL, 0x000fe200078e020aULL, 0x0000000a2d1f7211ULL, 0x000fe200078e20ffULL,
0x00000028272d7836ULL, 0x000fe20000000000ULL, 0x000000002a137faeULL, 0x0003e2000c101c46ULL,
0x000000010d117824ULL, 0x000fc400030e0611ULL, 0x0000001025257824ULL, 0x000fe200078e020aULL,
0x0000000034157faeULL, 0x0005e2000d901c46ULL, 0x000000082d2c7824ULL, 0x000fe200078e00ffULL,
0x000000023100720cULL, 0x080fe20003f66070ULL, 0x0000003427337836ULL, 0x000fe20000000000ULL,
0x0000000036197faeULL, 0x0007e2000e901c46ULL, 0x000000022d00720cULL, 0x0c0fe20003fa6070ULL,
0x000000012d137824ULL, 0x002fe400078e0220ULL, 0x00000000381f7faeULL, 0x000fe2000e101c46ULL,
0x000000022f00720cULL, 0x000fe20003f86070ULL, 0x000000012d157824ULL, 0x004fc400078e0207ULL,
0x0000000016237faeULL, 0x0003e2000c901c46ULL, 0x0000003827357836ULL, 0x000fe20000000000ULL,
0x0000003c27277810ULL, 0x000fe40007ffe0ffULL, 0x0000000010257faeULL, 0x0005e2000d101c46ULL,
0xfffffff82c197812ULL, 0x008fe200078ee215ULL, 0x0000000135157824ULL, 0x000fe200078e0220ULL,
0x000000023300720cULL, 0x080fe40003f46070ULL, 0x000000023500720cULL, 0x080fe40003f26070ULL,
0x000000022700720cULL, 0x000fe20003f06070ULL, 0x000000012f027824ULL, 0x100fe200078e0207ULL,
0x000000202f177210ULL, 0x002fe20007ffe0ffULL, 0x0000000133237824ULL, 0x000fe200078e0207ULL,
0x000000032f1f7819ULL, 0x000fe200000006ffULL, 0x0000010013107825ULL, 0x004fe200078e000eULL,
0x0000000333307819ULL, 0x000fc400000006ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee202ULL,
0x0000010017167825ULL, 0x000fe200078e000eULL, 0x000000100c2a7210ULL, 0x000fe40007fde0ffULL,
0xfffffff830237812ULL, 0x000fe200078ee223ULL, 0x0000000131137824ULL, 0x000fe400078e0220ULL,
0x000000010d2b7824ULL, 0x000fe200030e0611ULL, 0x000000160c2c7210ULL, 0x000fe20007fde0ffULL,
0x0000010013107825ULL, 0x000fc800078e000eULL, 0x0000000133137824ULL, 0x000fe400078e0220ULL,
0x000000010d2d7824ULL, 0x000fe200030e0617ULL, 0x000000100c2e7210ULL, 0x000fe20007fde0ffULL,
0x0000010013167825ULL, 0x000fc600078e000eULL, 0x000000110d2f7210ULL, 0x000fe200037fe4ffULL,
0x0000010015107825ULL, 0x000fe200078e000eULL, 0x000000160c167210ULL, 0x000fc60007fde0ffULL,
0x0000000127137824ULL, 0x000fe400078e0220ULL, 0x0000000131027824ULL, 0x000fe400078e0207ULL,
0x000000010d177824ULL, 0x000fe200030e0617ULL, 0x000000100c107210ULL, 0x000fe20007fde0ffULL,
0x0000000831317824ULL, 0x000fe400078e00ffULL, 0x00000100130e7825ULL, 0x000fe200078e000eULL,
0x0000000a19137211ULL, 0x080fe400078e20ffULL, 0xfffffff831157812ULL, 0x000fe200078ee202ULL,
0x000000010d117824ULL, 0x000fe200030e0611ULL, 0x0000000735027210ULL, 0x000fe20007ffe0ffULL,
0x0000000835257824ULL, 0x000fe200078e00ffULL, 0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000000127207824ULL, 0x000fe200078e0207ULL, 0x0000000a23197211ULL, 0x000fe200078e20ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee202ULL,
0x000000010d0d7824ULL, 0x000fe200030e060fULL, 0x000000002a137faeULL, 0x0003e2000e901c46ULL,
0x000000101f0f7824ULL, 0x100fe200078e020aULL, 0xfffffff827277812ULL, 0x000fe200078ee220ULL,
0x0000001015157824ULL, 0x000fc400078e020aULL, 0x00000010251f7824ULL, 0x100fe200078e020aULL,
0x000000002c0f7faeULL, 0x0003e2000e101c46ULL, 0x0000001027237824ULL, 0x000fc600078e020aULL,
0x000000002e157faeULL, 0x0003e8000d901c46ULL, 0x0000000016197faeULL, 0x0003e8000d101c46ULL,
0x00000000101f7faeULL, 0x0003e8000c901c46ULL, 0x000000000c237faeULL, 0x0003e2000c101c46ULL,
0x0000000800a07947ULL, 0x000fea0003800000ULL, 0x0000000407117811ULL, 0x044fe200078fe8ffULL,
0x00000010071e7824ULL, 0x040fe200078e00ffULL, 0x0000000c07197811ULL, 0x040fe200078fe8ffULL,
0x000000ffff417224ULL, 0x000fe200078e00ffULL, 0x00000010072b7811ULL, 0x000fe200078fe8ffULL,
0x0000000111027824ULL, 0x100fe200078e0207ULL, 0x0000000807177811ULL, 0x000fe200078fe8ffULL,
0x00000001190e7824ULL, 0x100fe200078e0207ULL, 0x0000000311157819ULL, 0x000fe200000006ffULL,
0x000000012b0f7824ULL, 0x100fe200078e0207ULL, 0x00000014072d7811ULL, 0x000fe200078fe8ffULL,
0x000000082b107824ULL, 0x000fe200078e00ffULL, 0x0000000319237819ULL, 0x000fe200000006ffULL,
0x00000001170a7824ULL, 0x100fe200078e0207ULL, 0x0000001c07317811ULL, 0x000fe200078fe8ffULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x0000002007337811ULL, 0x000fe200078fe8ffULL,
0x0000000119197824ULL, 0x100fe200078e0220ULL, 0xfffffff815157812ULL, 0x000fe200078ee202ULL,
0x000000012d027824ULL, 0x100fe200078e0207ULL, 0xfffffff823237812ULL, 0x000fe200078ee20eULL,
0x00000001310e7824ULL, 0x100fe200078e0207ULL, 0x00000018072f7811ULL, 0x000fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0220ULL, 0xfffffff810257812ULL, 0x000fe200078ee20fULL,
0x00000001330f7824ULL, 0x100fe200078e0207ULL, 0x000000032d277819ULL, 0x000fe200000006ffULL,
0x0000000833107824ULL, 0x000fe200078e00ffULL, 0x0000002407357811ULL, 0x000fe200078fe8ffULL,
0x000000082f457824ULL, 0x000fe200078e00ffULL, 0x0000000331477819ULL, 0x000fe200000006ffULL,
0x0000000117177824ULL, 0x100fe200078e0220ULL, 0x0000002c07397811ULL, 0x000fe200078fe8ffULL,
0x0000000131317824ULL, 0x100fe200078e0220ULL, 0x00000030073b7811ULL, 0x000fe200078fe8ffULL,
0x0000000133337824ULL, 0x100fe200078e0220ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x000000012f0a7824ULL, 0x100fe200078e0207ULL, 0xfffffff827277812ULL, 0x000fe200078ee202ULL,
0x0000000135027824ULL, 0x100fe200078e0207ULL, 0xfffffff847477812ULL, 0x000fe200078ee20eULL,
0x00000001390e7824ULL, 0x100fe200078e0207ULL, 0x0000002807377811ULL, 0x000fe200078fe8ffULL,
0x000000012f2f7824ULL, 0x100fe200078e0220ULL, 0xfffffff810497812ULL, 0x000fe200078ee20fULL,
0x000000013b0f7824ULL, 0x100fe200078e0207ULL, 0x00000003354b7819ULL, 0x000fe200000006ffULL,
0x000000083b107824ULL, 0x000fe200078e00ffULL, 0x00000003394f7819ULL, 0x000fe200000006ffULL,
0x00000008374d7824ULL, 0x040fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20aULL,
0x00000001370a7824ULL, 0x040fe200078e0207ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee202ULL,
0x0000000137377824ULL, 0x100fe200078e0220ULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee20eULL,
0x0000000139397824ULL, 0x100fe200078e0220ULL, 0x0000003407027811ULL, 0x000fe200078fe8ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0220ULL, 0xfffffff810517812ULL, 0x000fe200078ee20fULL,
0x0000400024447824ULL, 0x000fe200078e021dULL, 0x00000038070e7811ULL, 0x040fe200078fe8ffULL,
0x0000000802537824ULL, 0x000fe200078e00ffULL, 0x0000003c070f7811ULL, 0x000fc400078fe8ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee20aULL, 0x00000001020a7824ULL, 0x100fe200078e0207ULL,
0x000000701e1e7812ULL, 0x000fe200078ec0ffULL, 0x000000010e3f7824ULL, 0x140fe200078e0220ULL,
0x00000020023d7210ULL, 0x000fe20007ffe0ffULL, 0x000000080e557824ULL, 0x000fe200078e00ffULL,
0x000000070e027210ULL, 0x000fe20007ffe0ffULL, 0x000000010f137824ULL, 0x040fe200078e0220ULL,
0x000000030f577819ULL, 0x040fe200000006ffULL, 0x000000010f0e7824ULL, 0x000fe200078e0207ULL,
0x000000801e407812ULL, 0x000fc400078efcffULL, 0x00000020070f7211ULL, 0x000fe400078fe8ffULL,
0x0000002011117210ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x100fe200078e0040ULL,
0xfffffff857577812ULL, 0x000fe400078ee20eULL, 0x000000202d2d7210ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x100fe200078e0040ULL, 0x0000002035357210ULL, 0x000fe40007ffe0ffULL,
0xfffffff853537812ULL, 0x000fe200078ee20aULL, 0x0000010011107825ULL, 0x000fe200078e0040ULL,
0x0000000e0c0e7210ULL, 0x000fc40007f1e0ffULL, 0x00004000440a7810ULL, 0x000fe20007ffe0ffULL,
0x000001002b2a7825ULL, 0x100fe200078e0040ULL, 0x000000100c107210ULL, 0x000fe40007f3e0ffULL,
0xfffffff855557812ULL, 0x000fe200078ee202ULL, 0x0000010017167825ULL, 0x000fc800078e0040ULL,
0x000001002d2c7825ULL, 0x000fe200078e0040ULL, 0x000000160c167210ULL, 0x000fc60007f5e0ffULL,
0x000001002f2e7825ULL, 0x100fe200078e0040ULL, 0x000000170d177210ULL, 0x000fe400017fe4ffULL,
0x0000002c0c2c7210ULL, 0x000fe20007f5e0ffULL, 0x0000010031307825ULL, 0x000fe200078e0040ULL,
0x0000002e0c2e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010033327825ULL, 0x000fe200078e0040ULL,
0x0000002f0d2f7210ULL, 0x000fc60001ffe4ffULL, 0x0000010035347825ULL, 0x000fc800078e0040ULL,
0x0000010037367825ULL, 0x000fc800078e0040ULL, 0x0000010039387825ULL, 0x000fe200078e0040ULL,
0x000000360c367210ULL, 0x000fc60007f7e0ffULL, 0x000001003b3a7825ULL, 0x000fe200078e0040ULL,
0x000000370d377210ULL, 0x000fc60001ffe4ffULL, 0x000001003d3c7825ULL, 0x000fc800078e0040ULL,
0x000001003f3e7825ULL, 0x000fc800078e0040ULL, 0x000000010d0f7824ULL, 0x000fe200000e060fULL,
0x000000180c427210ULL, 0x000fe20007f1e0ffULL, 0x0000010013407825ULL, 0x000fe200078e0040ULL,
0x0000000707137211ULL, 0x040fe400078fe8ffULL, 0x0ffffff807187812ULL, 0x000fe200078ec0ffULL,
0x000000010d117824ULL, 0x040fe200008e0611ULL, 0x0000002a0c2a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010d437824ULL, 0x000fe200000e0619ULL, 0x0000000718137812ULL, 0x000fe200078ef813ULL,
0x0000001015157824ULL, 0x100fe200078e020aULL, 0x000000300c307210ULL, 0x000fe20007f1e0ffULL,
0x000000010d2b7824ULL, 0x000fe200008e062bULL, 0x000000320c327210ULL, 0x000fe20007f3e0ffULL,
0x0000001013137824ULL, 0x000fc400078e020aULL, 0x000000010d317824ULL, 0x040fe200000e0631ULL,
0x000000380c387210ULL, 0x000fe20007f1e0ffULL, 0x000000010d337824ULL, 0x000fe200008e0633ULL,
0x0000003a0c3a7210ULL, 0x000fe20007f3e0ffULL, 0x000000101f197824ULL, 0x100fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e137faeULL, 0x0003e2000b901c46ULL,
0x000000010d2d7824ULL, 0x000fe200010e062dULL, 0x000000340c347210ULL, 0x000fe20007f5e0ffULL,
0x00000010231f7824ULL, 0x100fe200078e020aULL, 0x0000000a25237211ULL, 0x000fe200078e20ffULL,
0x0000001027257824ULL, 0x100fe200078e020aULL, 0x0000000010157faeULL, 0x0005e2000b901c46ULL,
0x0000001045277824ULL, 0x000fc400078e020aULL, 0x000000010d397824ULL, 0x040fe200000e0639ULL,
0x0000000016197faeULL, 0x0007e2000b901c46ULL, 0x000000010d3b7824ULL, 0x000fe200008e063bULL,
0x0000003c0c3c7210ULL, 0x000fe20007f1e0ffULL, 0x00000010470f7824ULL, 0x102fe200078e020aULL,
0x00000000421f7faeULL, 0x0003e2000b901c46ULL, 0x000000010d357824ULL, 0x000fe200010e0635ULL,
0x0000003e0c3e7210ULL, 0x000fe20007f3e0ffULL, 0x000000104b137824ULL, 0x100fe200078e020aULL,
0x0000000a49117211ULL, 0x084fe200078e20ffULL, 0x000000002a237faeULL, 0x0005e2000b901c46ULL,
0x000000104d157824ULL, 0x100fe200078e020aULL, 0x000000400c0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000104f177824ULL, 0x008fe200078e020aULL, 0x000000002c257faeULL, 0x000fe2000b901c46ULL,
0x0000000a51197211ULL, 0x000fe200078e20ffULL, 0x000000010d3d7824ULL, 0x000fc400000e063dULL,
0x000000002e277faeULL, 0x000fe2000b901c46ULL, 0x00000010531f7824ULL, 0x102fe400078e020aULL,
0x000000010d3f7824ULL, 0x000fe200008e063fULL, 0x00000000300f7faeULL, 0x0003e2000b901c46ULL,
0x000000410d0d7210ULL, 0x000fe200017fe4ffULL, 0x0000001057237824ULL, 0x104fe400078e020aULL,
0x0000000032117faeULL, 0x0007e8000b901c46ULL, 0x0000000034137faeULL, 0x0007e2000b901c46ULL,
0x00000010550f7824ULL, 0x002fc600078e020aULL, 0x0000000036157faeULL, 0x0007e8000b901c46ULL,
0x0000000038177faeULL, 0x0007e8000b901c46ULL, 0x000000003a197faeULL, 0x0007e8000b901c46ULL,
0x000000003c1f7faeULL, 0x0007e8000b901c46ULL, 0x000000003e0f7faeULL, 0x0007e8000b901c46ULL,
0x000000000c237faeULL, 0x0007e4000b901c46ULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000001b0000720cULL, 0x000fda0003f06070ULL, 0x00009200ff108b82ULL, 0x00ae620000000a00ULL,
0x00000002290d8824ULL, 0x000fe200078e0200ULL, 0x00000004ff137819ULL, 0x100fe40000011607ULL,
0x00000007070c7812ULL, 0x040fe400078ec0ffULL, 0x00000003ff0e7819ULL, 0x000fe40000011607ULL,
0x0000000807207812ULL, 0x000fe200078ec0ffULL, 0x0000200044167836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000040d108825ULL, 0x002fca00078e0010ULL,
0x0000000610028981ULL, 0x0002a2000c1e1900ULL, 0x0000000313157819ULL, 0x000fe400000006ffULL,
0x000000010e2e7812ULL, 0x000fe400078ec0ffULL, 0xfffffff815157812ULL, 0x000fe400078ee20cULL,
0x00000007200d7812ULL, 0x000fe400078ef807ULL, 0x0000002128af7210ULL, 0x000fe20007ffe0ffULL,
0x000000012e257824ULL, 0x000fe200078e0215ULL, 0x000000100d107812ULL, 0x002fe200078efcffULL,
0x0000000815207824ULL, 0x000fc400078e00ffULL, 0x0000002015237836ULL, 0x000fe20000000000ULL,
0x0000001013117210ULL, 0x000fe20007ffe0ffULL, 0x0000001015277836ULL, 0x000fe20000000000ULL,
0xfffffff820a97812ULL, 0x000fe200078ee225ULL, 0x0000003015207836ULL, 0x000fe20000000000ULL,
0x00000004102c7819ULL, 0x000fe200000006ffULL, 0x000000012ea57824ULL, 0x000fe400078e0223ULL,
0x0000000823327824ULL, 0x000fe200078e00ffULL, 0x0000000320347819ULL, 0x000fe200000006ffULL,
0x000000012ea77824ULL, 0x040fe200078e0227ULL, 0xfffffff02c2c7812ULL, 0x000fe200078ee211ULL,
0x000000012ea37824ULL, 0x000fe200078e0220ULL, 0xfffffff832a57812ULL, 0x000fe200078ee2a5ULL,
0x0000000827307824ULL, 0x000fe200078e00ffULL, 0x0000001d2c2c7211ULL, 0x080fe200078e20ffULL,
0x00000001130f7824ULL, 0x000fe200078e020dULL, 0xfffffff834a37812ULL, 0x000fe200078ee2a3ULL,
0x000000100d2a7824ULL, 0x040fe200078e00ffULL, 0xfffffff830a77812ULL, 0x000fe200078ee2a7ULL,
0x000000100d367824ULL, 0x000fe200078e00ffULL, 0x00000016a3647211ULL, 0x080fe200078e20ffULL,
0x000000020f137836ULL, 0x000fe20000000000ULL, 0xfffffff02a2a7812ULL, 0x000fe200078ee20fULL,
0x00000010a9587824ULL, 0x100fe200078e0216ULL, 0x00000016a74c7211ULL, 0x000fe200078e20ffULL,
0x00000010a5347824ULL, 0x000fe200078e0216ULL, 0x0000001d2a2a7211ULL, 0x000fe200078e20ffULL,
0x000000006464783bULL, 0x000fe20000000200ULL, 0xfffffff0362e7812ULL, 0x000fe200078ee213ULL,
0x00000012259f7836ULL, 0x000fc40000000000ULL, 0x000000002a54783bULL, 0x0002e20000000200ULL,
0x0000000815307824ULL, 0x000fe200078e00ffULL, 0x0000001d2e2e7211ULL, 0x000fe200078e20ffULL,
0x0000000225a17836ULL, 0x000fe20000000000ULL, 0x000000005858783bULL, 0x000f220000000200ULL,
0x00000022259d7836ULL, 0x000fe40000000000ULL, 0x00000032252b7836ULL, 0x000fe20000000000ULL,
0x000000004c4c783bULL, 0x000f620000000200ULL, 0xfffffff830a17812ULL, 0x000fe200078ee2a1ULL,
0x00000010102a7824ULL, 0x002fe200078e00ffULL, 0x0000000320307819ULL, 0x000fe200000006ffULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x0000000211137836ULL, 0x000fc40000000000ULL,
0xfffffff8302b7812ULL, 0x000fe200078ee22bULL, 0x000000002c68783bULL, 0x0006620000000200ULL,
0x00000010a17c7824ULL, 0x100fe200078e0216ULL, 0xfffffff02a2a7812ULL, 0x000fe200078ee213ULL,
0x000000040f137836ULL, 0x000fe20000000000ULL, 0x000000002e78783bULL, 0x000fe20000000200ULL,
0x000000102b5c7824ULL, 0x000fe400078e0216ULL, 0x000000102a2a7824ULL, 0x000fe200078e021dULL,
0x000000007c7c783bULL, 0x000e620000000200ULL, 0x00000008272c7824ULL, 0x008fc400078e00ffULL,
0x0000000411177836ULL, 0x000fe20000000000ULL, 0x000000005c5c783bULL, 0x000fe20000000200ULL,
0x0000000425197836ULL, 0x000fe20000000000ULL, 0xfffffff82c9f7812ULL, 0x000fe200078ee29fULL,
0x00000008232c7824ULL, 0x000fe200078e00ffULL, 0x000000002a84783bULL, 0x0007e20000000200ULL,
0x000000060f1f7836ULL, 0x000fe40000000000ULL, 0x000000109f747824ULL, 0x100fe200078e0216ULL,
0xfffffff82c9d7812ULL, 0x000fe200078ee29dULL, 0x000000645440723cULL, 0x000fe800000418ffULL,
0x000000109d707824ULL, 0x000fe200078e0216ULL, 0x000000007474783bULL, 0x000e620000000200ULL,
0x000000040d2a7819ULL, 0x008fe200000006ffULL, 0x000000585498723cULL, 0x010fe600000418ffULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0xfffffff02a2a7812ULL, 0x000fc400078ee213ULL,
0x0000005a5430723cULL, 0x000fe400000418ffULL, 0x0000001d2a2a7211ULL, 0x000fc800078e20ffULL,
0x0000004c5438723cULL, 0x020fe200000418ffULL, 0x000000002a90783bULL, 0x0009ea0000000200ULL,
0x0000004e543c723cULL, 0x000fe200000418ffULL, 0x00000036252a7810ULL, 0x010fca0007ffe0ffULL,
0x000000345444723cULL, 0x002fec00000418ffULL, 0x000000365448723cULL, 0x000fec00000418ffULL,
0x000000665454723cULL, 0x000fec00000418ffULL, 0x00000058682c723cULL, 0x000fec00000418ffULL,
0x0000005a6858723cULL, 0x000fec00000418ffULL, 0x0000004c6850723cULL, 0x000fec00000418ffULL,
0x0000004e684c723cULL, 0x000fec00000418ffULL, 0x0000007c7898723cULL, 0x000fec0000041898ULL,
0x0000007e7830723cULL, 0x000fec0000041830ULL, 0x000000747838723cULL, 0x000fec0000041838ULL,
0x00000076783c723cULL, 0x000fec000004183cULL, 0x000000707844723cULL, 0x008fec0000041844ULL,
0x000000727848723cULL, 0x000fec0000041848ULL, 0x0000005c7840723cULL, 0x000fec0000041840ULL,
0x0000005e7878723cULL, 0x000fec0000041854ULL, 0x0000007c842c723cULL, 0x000fe2000004182cULL,
0x0000001010547824ULL, 0x000fc400078e00ffULL, 0x000000100d567824ULL, 0x000fc600078e00ffULL,
0x000000646860723cULL, 0x000fe200000418ffULL, 0xfffffff054547812ULL, 0x000fe200078ee217ULL,
0x0000003425177836ULL, 0x000fe20000000000ULL, 0xfffffff056567812ULL, 0x000fe200078ee21fULL,
0x00000006251f7836ULL, 0x000fe40000000000ULL, 0x0000007e847c723cULL, 0x000fe20000041858ULL,
0x0000000315647819ULL, 0x000fe200000006ffULL, 0x0000001054547824ULL, 0x000fc600078e021dULL,
0xfffffff864137812ULL, 0x000fe200078ee219ULL, 0x000000346858723cULL, 0x000fe200000418ffULL,
0x0000000320647819ULL, 0x000fe200000006ffULL, 0x0000002425197836ULL, 0x000fe20000000000ULL,
0x00000000546c783bULL, 0x000fe20000000200ULL, 0x0000001013947824ULL, 0x100fe200078e0216ULL,
0xfffffff864177812ULL, 0x000fe200078ee217ULL, 0x000000366834723cULL, 0x000fe800000418ffULL,
0x0000001017807824ULL, 0x000fe200078e0216ULL, 0x000000009494783bULL, 0x000fe20000000200ULL,
0x000000748450723cULL, 0x000fe80000041850ULL, 0x000000008080783bULL, 0x000e640000000200ULL,
0x000000666868723cULL, 0x000fec00000418ffULL, 0x000000768474723cULL, 0x000fe2000004184cULL,
0x0000000315667819ULL, 0x000fe200000006ffULL, 0x0000001425157836ULL, 0x000fc60000000000ULL,
0xfffffff8661f7812ULL, 0x000fe200078ee21fULL, 0x000000708458723cULL, 0x000fe20000041858ULL,
0x00000008234e7824ULL, 0x000fe400078e00ffULL, 0x00000008274c7824ULL, 0x000fc600078e00ffULL,
0xfffffff84e197812ULL, 0x000fe200078ee219ULL, 0x000000728470723cULL, 0x000fe20000041834ULL,
0xfffffff84c157812ULL, 0x000fe200078ee215ULL, 0x00000010564c7824ULL, 0x000fe200078e021dULL,
0x0000001619887211ULL, 0x000fc600078e20ffULL, 0x00000010158c7824ULL, 0x000fe200078e0216ULL,
0x0000000320377819ULL, 0x000fe200000006ffULL, 0x0000000827347824ULL, 0x000fe200078e00ffULL,
0x000000008888783bULL, 0x000ee20000000200ULL, 0x0000000823367824ULL, 0x000fe200078e00ffULL,
0x0000005c8460723cULL, 0x000fe20000041860ULL, 0x0000002625277836ULL, 0x000fe20000000000ULL,
0x000000008c8c783bULL, 0x000f220000000200ULL, 0x0000001010357824ULL, 0x000fe400078e00ffULL,
0x0000000611207836ULL, 0x000fe20000000000ULL, 0x0000005e8484723cULL, 0x000fe20000041868ULL,
0x0000001625237836ULL, 0x000fe20000000000ULL, 0xfffffff836257812ULL, 0x000fe200078ee227ULL,
0x000000004c4c783bULL, 0x000fe20000000200ULL, 0xfffffff837277812ULL, 0x000fc400078ee22aULL,
0xfffffff035207812ULL, 0x000fe200078ee220ULL, 0x00000010255c7824ULL, 0x100fe200078e0216ULL,
0xfffffff834237812ULL, 0x000fe200078ee223ULL, 0x00000010272a7824ULL, 0x100fe200078e0216ULL,
0x0000001d20207211ULL, 0x000fe200078e20ffULL, 0x000000101f347824ULL, 0x100fe200078e0216ULL,
0x000000809040723cULL, 0x002fe20000041840ULL, 0x0000001023547824ULL, 0x000fe200078e0216ULL,
0x000000002a68783bULL, 0x000e680000000200ULL, 0x000000002064783bULL, 0x000a620000000200ULL,
0x000000806c60723cULL, 0x000fe60000041860ULL, 0x000000005c5c783bULL, 0x000e660000000200ULL,
0x000000949098723cULL, 0x000fe20000041898ULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x00000100af207824ULL, 0x020fc600078e0204ULL, 0x000000005454783bULL, 0x000f620000000200ULL,
0x000000946c2c723cULL, 0x000fec000004182cULL, 0x000000889044723cULL, 0x008fec0000041844ULL,
0x0000008a9048723cULL, 0x000fec0000041848ULL, 0x000000886c58723cULL, 0x000fec0000041858ULL,
0x0000008a6c70723cULL, 0x000fec0000041870ULL, 0x000000969030723cULL, 0x000fec0000041830ULL,
0x0000008c9038723cULL, 0x010fec0000041838ULL, 0x0000008e903c723cULL, 0x000fec000004183cULL,
0x0000008c6c50723cULL, 0x000fec0000041850ULL, 0x000000966c7c723cULL, 0x000fec000004187cULL,
0x0000008e6c74723cULL, 0x000fec0000041874ULL, 0x000000829078723cULL, 0x000fec0000041878ULL,
0x000000826c6c723cULL, 0x000fec0000041884ULL, 0x000000684c40723cULL, 0x002fec0000041840ULL,
0x000000686460723cULL, 0x000fec0000041860ULL, 0x0000005c4c44723cULL, 0x000fe20000041844ULL,
0x00000001af697836ULL, 0x000fca0000000000ULL, 0x0000001a6900720cULL, 0x000fe20003f06070ULL,
0x0000005e4c48723cULL, 0x000fe20000041848ULL, 0x0000000502697224ULL, 0x004fc800078e02ffULL,
0x0000010069ac7825ULL, 0x000fe200078e00acULL, 0x0000005c6458723cULL, 0x000fec0000041858ULL,
0x0000005e645c723cULL, 0x000fec0000041870ULL, 0x000000344c98723cULL, 0x000fe20000041898ULL,
0x0000004020717812ULL, 0x000fca00078ec0ffULL, 0x00000034642c723cULL, 0x000fe2000004182cULL,
0x0000000126717824ULL, 0x000fca00078e0271ULL, 0x000000364c30723cULL, 0x000fec0000041830ULL,
0x000000544c38723cULL, 0x020fec0000041838ULL, 0x000000564c3c723cULL, 0x000fec000004183cULL,
0x000000546450723cULL, 0x000fec0000041850ULL, 0x000000366434723cULL, 0x000fec000004187cULL,
0x000000566454723cULL, 0x000fec0000041874ULL, 0x0000006a4c4c723cULL, 0x000fec0000041878ULL,
0x0000006a6464723cULL, 0x000fe2000004186cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000c00108947ULL, 0x000fde0003800000ULL, 0x000000080e6c7836ULL, 0x000fe20000000000ULL,
0x000000040e6a7810ULL, 0x000fe20007ffe0ffULL, 0x000000010e697824ULL, 0x100fe200078e0207ULL,
0x000000201c757248ULL, 0x000fe20007fe0000ULL, 0x000000016c687824ULL, 0x100fe200078e0207ULL,
0x000000036a7f7819ULL, 0x000fe200000006ffULL, 0x000000086c817824ULL, 0x000fe200078e00ffULL,
0x00000007187d7812ULL, 0x000fe200078ef869ULL, 0x000000016a2a7824ULL, 0x040fe400078e0207ULL,
0x0000000175757824ULL, 0x000fe200078e0a20ULL, 0xfffffff881817812ULL, 0x000fe200078ee268ULL,
0x000000140e707836ULL, 0x000fe20000000000ULL, 0x000000710e687210ULL, 0x000fe20007ffe0ffULL,
0x0000000c0e187836ULL, 0x000fe20000000000ULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee22aULL,
0x000000100e2a7836ULL, 0x000fe20000000000ULL, 0x000000756a00720cULL, 0x000fe20003f46070ULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x000000716a6a7210ULL, 0x000fc40007ffe0ffULL,
0x000000032a6e7819ULL, 0x040fe200000006ffULL, 0x000000012a6b7824ULL, 0x100fe200078e0207ULL,
0x0000001e68737212ULL, 0x080fe200078efcffULL, 0x0000000170687824ULL, 0x000fe200078e0207ULL,
0x000000756c00720cULL, 0x080fe20003f66070ULL, 0x0000000870877824ULL, 0x000fe200078e00ffULL,
0xfffffff86e857812ULL, 0x000fe200078ee26bULL, 0x000001006a6a7825ULL, 0x000fe200078e00ffULL,
0x00000073ac727210ULL, 0x000fe40007f1e0ffULL, 0xfffffff887877812ULL, 0x000fe200078ee268ULL,
0x000000016c687824ULL, 0x100fe200078e0271ULL, 0x0000001e6a6f7212ULL, 0x000fe200078efcffULL,
0x00000001186c7824ULL, 0x000fe200078e0271ULL, 0x000000750e00720cULL, 0x080fe20003f26070ULL,
0x00000001ad737824ULL, 0x000fe200000e0669ULL, 0x0000006fac6e7210ULL, 0x000fe20007f1e0ffULL,
0x000001006c6c7825ULL, 0x000fe200078e00ffULL, 0x000000751800720cULL, 0x000fc40003fa6070ULL,
0x0000006bad6f7210ULL, 0x000fe200007fe4ffULL, 0x000000012a6a7824ULL, 0x000fe200078e0271ULL,
0x0000001e6c777212ULL, 0x080fe200078efcffULL, 0x0000010068687825ULL, 0x000fe200078e00ffULL,
0x000000752a00720cULL, 0x080fe40003f86070ULL, 0x00000077ac767210ULL, 0x000fe20007fde0ffULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0x0000001e687b7212ULL, 0x080fe400078efcffULL,
0x0000006dad777210ULL, 0x000fe200037fe4ffULL, 0x0000000118207824ULL, 0x000fe200078e0207ULL,
0x0000001e6a797212ULL, 0x000fe200078efcffULL, 0x0000000818837824ULL, 0x000fe200078e00ffULL,
0x0000007bac7a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001706a7824ULL, 0x000fe200078e0271ULL,
0x00000079ac687210ULL, 0x000fe20007fde0ffULL, 0x000000107d7d7824ULL, 0x000fe200078e0216ULL,
0xfffffff883837812ULL, 0x000fe200078ee220ULL, 0x00000001ad7b7824ULL, 0x040fe200000e0669ULL,
0x000000180e207810ULL, 0x000fe20007ffe0ffULL, 0x00000001ad697824ULL, 0x000fe200030e066bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000727d7faeULL, 0x0003e2000c901c46ULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0x000000752000720cULL, 0x000fc40003f26070ULL,
0x000000757000720cULL, 0x000fe20003f06070ULL, 0x0000000120187824ULL, 0x000fe200078e0207ULL,
0x0000001e6a6d7212ULL, 0x000fe200078efcffULL, 0x0000000820897824ULL, 0x040fe400078e00ffULL,
0x00000001206c7824ULL, 0x000fe200078e0271ULL, 0x0000006dac6a7210ULL, 0x000fe20007fde0ffULL,
0x000000107f7f7824ULL, 0x000fe200078e0216ULL, 0xfffffff889897812ULL, 0x000fe200078ee218ULL,
0x000001006c6c7825ULL, 0x000fe200078e00ffULL, 0x0000001c0e187810ULL, 0x000fc40007ffe0ffULL,
0x0000006bad6b7210ULL, 0x000fe200037fe4ffULL, 0x0000001081817824ULL, 0x000fe200078e0216ULL,
0x0000001e6c737212ULL, 0x002fe200078efcffULL, 0x000000200e787836ULL, 0x000fe20000000000ULL,
0x000000006e7f7faeULL, 0x0003e2000d101c46ULL, 0x0000000118727824ULL, 0x000fe200078e0271ULL,
0x00000073ac6c7210ULL, 0x000fe20007fde0ffULL, 0x00000001782a7824ULL, 0x000fe200078e0207ULL,
0x000000007a817faeULL, 0x0005e2000d901c46ULL, 0x0000010072727825ULL, 0x000fe200078e00ffULL,
0x000000757800720cULL, 0x000fc40003f66070ULL, 0x00000003188b7819ULL, 0x000fe200000006ffULL,
0x00000008788d7824ULL, 0x000fe200078e00ffULL, 0x000000751800720cULL, 0x040fe20003f46070ULL,
0x0000000118207824ULL, 0x000fe200078e0207ULL, 0x0000001e726f7212ULL, 0x002fe200078efcffULL,
0x0000000178787824ULL, 0x000fe200078e0271ULL, 0x0000006dad6d7210ULL, 0x000fe200037fe4ffULL,
0x0000001083837824ULL, 0x000fe200078e0216ULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee220ULL,
0x000000240e187836ULL, 0x000fe20000000000ULL, 0x0000006fac6e7210ULL, 0x000fe20007fde0ffULL,
0x0000010078787825ULL, 0x000fe200078e00ffULL, 0x0000000076837faeULL, 0x0003e2000e901c46ULL,
0xfffffff88d8d7812ULL, 0x000fc400078ee22aULL, 0x0000000118207824ULL, 0x040fe200078e0207ULL,
0x00000003187f7819ULL, 0x040fe200000006ffULL, 0x0000001085857824ULL, 0x000fe200078e0216ULL,
0x000000751800720cULL, 0x040fe20003fa6070ULL, 0x0000000118187824ULL, 0x000fe200078e0271ULL,
0x0000001e787b7212ULL, 0x004fe200078efcffULL, 0x00000001ad6f7824ULL, 0x000fe200030e0673ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee220ULL, 0x0000000068857faeULL, 0x0005e2000e101c46ULL,
0x0000010018767825ULL, 0x002fe200078e00ffULL, 0x0000007bac727210ULL, 0x000fc40007fde0ffULL,
0x000000300e2a7810ULL, 0x000fe20007ffe0ffULL, 0x000000280e187836ULL, 0x000fe20000000000ULL,
0x00000079ad737210ULL, 0x000fe200037fe4ffULL, 0x0000001087877824ULL, 0x100fe200078e0216ULL,
0x0000001e76797212ULL, 0x000fe200078efcffULL, 0x0000000118207824ULL, 0x040fe200078e0207ULL,
0x000000751800720cULL, 0x040fe20003f86070ULL, 0x0000000818817824ULL, 0x000fe200078e00ffULL,
0x0000007118187210ULL, 0x000fe20007ffe0ffULL, 0x000000006a877faeULL, 0x0003e2000c101c46ULL,
0x00000079ac787210ULL, 0x000fe20007fde0ffULL, 0x0000001089897824ULL, 0x000fe200078e0216ULL,
0xfffffff881817812ULL, 0x000fe200078ee220ULL, 0x0000010018687825ULL, 0x004fe200078e00ffULL,
0x000000712a7a7210ULL, 0x000fc40007ffe0ffULL, 0x000000006c897faeULL, 0x0005e2000c901c46ULL,
0x0000002c0e207836ULL, 0x000fe20000000000ULL, 0x000000752a00720cULL, 0x080fe20003f26070ULL,
0x00000001ad797824ULL, 0x000fe200030e0677ULL, 0x0000001e68777212ULL, 0x000fe200078efcffULL,
0x0000000120767824ULL, 0x040fe200078e0271ULL, 0x000000752000720cULL, 0x040fe20003f06070ULL,
0x0000000120187824ULL, 0x000fe200078e0207ULL, 0x00000077ac687210ULL, 0x000fe20007fde0ffULL,
0x0000010076767825ULL, 0x000fe200078e00ffULL, 0x000000032a857819ULL, 0x000fc400000006ffULL,
0x0000001681817211ULL, 0x000fe200078e20ffULL, 0x0000000820837824ULL, 0x000fe200078e00ffULL,
0x0000001e766b7212ULL, 0x002fe200078efcffULL, 0x000001007a7a7825ULL, 0x000fc600078e00ffULL,
0xfffffff883837812ULL, 0x000fe200078ee218ULL, 0x000000340e207836ULL, 0x000fe20000000000ULL,
0x0000001e7a7d7212ULL, 0x000fe200078efcffULL, 0x00000001ad697824ULL, 0x000fe200030e0669ULL,
0x0000006bac6a7210ULL, 0x000fe20007fde0ffULL, 0x000000012a187824ULL, 0x000fe200078e0207ULL,
0x00000071206c7210ULL, 0x004fe20007ffe0ffULL, 0x000000108b8b7824ULL, 0x000fe200078e0216ULL,
0x000000380e2a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001ad6b7824ULL, 0x000fe200030e0677ULL,
0x0000007dac767210ULL, 0x000fe20007fde0ffULL, 0x000001006c6c7825ULL, 0x000fe200078e00ffULL,
0x000000006e8b7faeULL, 0x0003e2000d101c46ULL, 0xfffffff8857d7812ULL, 0x000fc400078ee218ULL,
0x00000001ad777824ULL, 0x000fe200030e067bULL, 0x0000001e6c7b7212ULL, 0x000fe200078efcffULL,
0x000000108d8d7824ULL, 0x100fe200078e0216ULL, 0x0000000720187210ULL, 0x000fe20007ffe0ffULL,
0x000000107f7f7824ULL, 0x000fe200078e0216ULL, 0x0000007bac747210ULL, 0x000fe20007fde0ffULL,
0x0000003c0e707836ULL, 0x000fe20000000000ULL, 0x00000000728d7faeULL, 0x000fe2000d901c46ULL,
0x000000012a6c7824ULL, 0x140fe200078e0271ULL, 0x000000752a00720cULL, 0x080fe20003f66070ULL,
0x00000001706e7824ULL, 0x002fe200078e0271ULL, 0x00000000787f7faeULL, 0x0003e2000e901c46ULL,
0x000000752000720cULL, 0x080fe20003fa6070ULL, 0x00000008707b7824ULL, 0x040fe200078e00ffULL,
0x000000757000720cULL, 0x000fe20003f46070ULL, 0x00000001ad757824ULL, 0x000fe200030e066dULL,
0x0000000068817faeULL, 0x0007e2000e101c46ULL, 0x000001006c6c7825ULL, 0x000fc800078e00ffULL,
0x000001006e6e7825ULL, 0x000fe200078e00ffULL, 0x0000001e6c717212ULL, 0x080fe400078efcffULL,
0x000000032a797819ULL, 0x002fe200000006ffULL, 0x0000000820737824ULL, 0x000fe200078e00ffULL,
0x00000071ac6c7210ULL, 0x000fe20007fde0ffULL, 0x000000012a207824ULL, 0x100fe200078e0207ULL,
0x0000001e6e717212ULL, 0x000fe200078efcffULL, 0x00000001702a7824ULL, 0x000fe200078e0207ULL,
0xfffffff873737812ULL, 0x000fe200078ee218ULL, 0x00000001ad6d7824ULL, 0x000fe200030e066dULL,
0xfffffff879797812ULL, 0x000fe200078ee220ULL, 0x0000001083837824ULL, 0x100fe200078e0216ULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee22aULL, 0x000000107d7d7824ULL, 0x100fe200078e0216ULL,
0x00000071ac6e7210ULL, 0x000fe20007fde0ffULL, 0x0000001073737824ULL, 0x100fe200078e0216ULL,
0x0000001679797211ULL, 0x000fe200078e20ffULL, 0x000000107b7b7824ULL, 0x000fe200078e0216ULL,
0x000000006a837faeULL, 0x0007e2000c101c46ULL, 0x00000001ad6f7824ULL, 0x000fc600030e066fULL,
0x00000000767d7faeULL, 0x0007e8000c901c46ULL, 0x0000000074737faeULL, 0x0007e8000e901c46ULL,
0x000000006c797faeULL, 0x0007e8000d901c46ULL, 0x000000006e7b7faeULL, 0x0007e2000d101c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x000000040e207836ULL, 0x000fe20000000000ULL,
0x000000070e697210ULL, 0x000fe20007ffe0ffULL, 0x000000080e6c7836ULL, 0x000fe20000000000ULL,
0x0000001c0e767810ULL, 0x000fe20007ffe0ffULL, 0x00000001202a7824ULL, 0x140fe200078e0207ULL,
0x0000000320737819ULL, 0x000fe200000006ffULL, 0x0000000c0e6e7836ULL, 0x000fe20000000000ULL,
0x00000007186b7812ULL, 0x000fe200078ef869ULL, 0x000000100e187836ULL, 0x000fe20000000000ULL,
0xfffffff873737812ULL, 0x000fe200078ee22aULL, 0x000000016c687824ULL, 0x100fe200078e0207ULL,
0x000000036e777819ULL, 0x000fe200000006ffULL, 0x000000086c757824ULL, 0x000fe200078e00ffULL,
0x00000003767f7819ULL, 0x000fe200000006ffULL, 0x000000016e6a7824ULL, 0x100fe200078e0207ULL,
0x0000002c0e7e7810ULL, 0x000fe20007ffe0ffULL, 0x000000140e727836ULL, 0x000fe20000000000ULL,
0xfffffff875757812ULL, 0x000fe200078ee268ULL, 0x00000001182a7824ULL, 0x140fe200078e0207ULL,
0xfffffff877777812ULL, 0x000fe200078ee26aULL, 0x0000000818797824ULL, 0x000fe200078e00ffULL,
0x00000003727b7819ULL, 0x040fe200000006ffULL, 0x000000180e747836ULL, 0x000fe20000000000ULL,
0x000000380e847810ULL, 0x000fe20007ffe0ffULL, 0x0000000172687824ULL, 0x100fe200078e0207ULL,
0xfffffff879797812ULL, 0x000fe200078ee22aULL, 0x00000001766a7824ULL, 0x100fe200078e0207ULL,
0x000000037e787819ULL, 0x000fe200000006ffULL, 0x000000200e2a7836ULL, 0x000fe20000000000ULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee268ULL, 0x000000280e7c7836ULL, 0x000fe20000000000ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee26aULL, 0x0000000174697824ULL, 0x140fe200078e0207ULL,
0x00000007846f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000874707824ULL, 0x000fe200078e00ffULL,
0x000000716e6e7210ULL, 0x000fe20007ffe0ffULL, 0x000000240e7a7836ULL, 0x000fe20000000000ULL,
0x0000007176767210ULL, 0x000fe20007ffe0ffULL, 0x000000012a687824ULL, 0x140fe200078e0207ULL,
0xfffffff8707d7812ULL, 0x000fe200078ee269ULL, 0x000000082a817824ULL, 0x000fe200078e00ffULL,
0x000000037a707819ULL, 0x000fe200000006ffULL, 0x000000017c6a7824ULL, 0x140fe200078e0207ULL,
0x00000016778f7211ULL, 0x080fe200078e20ffULL, 0x000000087c857824ULL, 0x000fe200078e00ffULL,
0xfffffff881817812ULL, 0x000fe200078ee268ULL, 0x000000017a697824ULL, 0x100fe200078e0207ULL,
0x000000167f977211ULL, 0x000fe200078e20ffULL, 0x000000300e807836ULL, 0x000fe20000000000ULL,
0xfffffff885857812ULL, 0x000fe200078ee26aULL, 0x000000017e6d7824ULL, 0x000fe200078e0207ULL,
0xfffffff870837812ULL, 0x000fe200078ee269ULL, 0x000000010e687824ULL, 0x100fe200078e0271ULL,
0x000000717e7e7210ULL, 0x000fe20007ffe0ffULL, 0x000000340e827836ULL, 0x000fe20000000000ULL,
0xfffffff878877812ULL, 0x000fe200078ee26dULL, 0x00000001206a7824ULL, 0x000fc400078e0271ULL,
0x0000003c0e887836ULL, 0x000fe20000000000ULL, 0x0000001687b77211ULL, 0x000fe200078e20ffULL,
0x0000000180207824ULL, 0x040fe400078e0207ULL, 0x0000000880897824ULL, 0x000fe200078e00ffULL,
0x0000000388c17819ULL, 0x000fe200000006ffULL, 0x0000000184867824ULL, 0x040fe400078e0271ULL,
0x0000000884847824ULL, 0x000fe400078e00ffULL, 0x0000010068687825ULL, 0x000fc600078e00ffULL,
0xfffffff884bd7812ULL, 0x000fe200078ee26fULL, 0x0000000118707824ULL, 0x100fe200078e0271ULL,
0x0000001e686f7212ULL, 0x000fe200078efcffULL, 0x000000012a787824ULL, 0x100fe200078e0271ULL,
0x00000071822a7210ULL, 0x000fe20007ffe0ffULL, 0x000000016c6c7824ULL, 0x100fe200078e0271ULL,
0x0000006fac687210ULL, 0x000fe20007f1e0ffULL, 0x0000000172727824ULL, 0x100fe400078e0271ULL,
0x0000000174747824ULL, 0x100fe400078e0271ULL, 0x000000017a7a7824ULL, 0x000fc400078e0271ULL,
0x000000017c7c7824ULL, 0x100fe400078e0271ULL, 0x0000000180187824ULL, 0x000fe400078e0271ULL,
0x00000001826d7824ULL, 0x000fe400078e0207ULL, 0x00000001888a7824ULL, 0x000fe200078e0271ULL,
0xfffffff889717812ULL, 0x000fe200078ee220ULL, 0x0000000882827824ULL, 0x000fe400078e00ffULL,
0x000000106b897824ULL, 0x000fc400078e0216ULL, 0x000001006a6a7825ULL, 0x000fe200078e00ffULL,
0xfffffff882b97812ULL, 0x000fc600078ee26dULL, 0x000001006c6c7825ULL, 0x000fe200078e00ffULL,
0x0000001e6a6f7212ULL, 0x000fc600078efcffULL, 0x00000010738b7824ULL, 0x000fe200078e0216ULL,
0x0000006fac6a7210ULL, 0x000fe20007f3e0ffULL, 0x000001006e6e7825ULL, 0x000fe200078e00ffULL,
0x0000001e6c737212ULL, 0x000fc600078efcffULL, 0x00000001ad697824ULL, 0x040fe200000e0669ULL,
0x00000073ac6c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010072727825ULL, 0x000fe200078e00ffULL,
0x0000001e6e777212ULL, 0x080fe400078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000068897faeULL, 0x0003e2000b901c46ULL, 0x00000001ad6d7824ULL, 0x000fe200000e066dULL,
0x00000077ac6e7210ULL, 0x000fe20007f1e0ffULL, 0x00000010758d7824ULL, 0x100fe200078e0216ULL,
0x0000001e72777212ULL, 0x000fe200078efcffULL, 0x0000001071bb7824ULL, 0x000fe200078e0216ULL,
0x0000006fad6f7210ULL, 0x000fe200007fe4ffULL, 0x0000010074747825ULL, 0x000fe200078e00ffULL,
0x00000077ac727210ULL, 0x000fc60007f1e0ffULL, 0x0000010070707825ULL, 0x000fc800078e00ffULL,
0x000000107b937824ULL, 0x100fe200078e0216ULL, 0x0000001e747b7212ULL, 0x080fe200078efcffULL,
0x0000001079917824ULL, 0x000fe200078e0216ULL, 0x0000001e70797212ULL, 0x000fe200078efcffULL,
0x0000010076767825ULL, 0x000fe200078e00ffULL, 0x0000007bac747210ULL, 0x000fc60007f5e0ffULL,
0x0000001081b17824ULL, 0x000fe200078e0216ULL, 0x0000001e76817212ULL, 0x000fe200078efcffULL,
0x00000001ad6b7824ULL, 0x000fe200008e066bULL, 0x00000079ac707210ULL, 0x000fe20007f3e0ffULL,
0x000001007a7a7825ULL, 0x000fc600078e00ffULL, 0x000000006a8b7faeULL, 0x0003e2000b901c46ULL,
0x0000010078787825ULL, 0x000fc600078e00ffULL, 0x000000006c8d7faeULL, 0x0003e2000b901c46ULL,
0x00000001ad737824ULL, 0x000fe200000e0673ULL, 0x00000081ac767210ULL, 0x000fe20007f1e0ffULL,
0x0000001083b37824ULL, 0x100fe200078e0216ULL, 0x0000001e7a817212ULL, 0x080fe200078efcffULL,
0x000000107d957824ULL, 0x000fe200078e0216ULL, 0x0000001e78837212ULL, 0x000fe200078efcffULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x00000077ad777210ULL, 0x000fe200007fe4ffULL,
0x000000006e8f7faeULL, 0x0003e2000b901c46ULL, 0x00000081ac7a7210ULL, 0x000fe20007f1e0ffULL,
0x000001007c7c7825ULL, 0x000fc800078e00ffULL, 0x0000000188807824ULL, 0x000fe400078e0207ULL,
0x00000001ad717824ULL, 0x000fe200008e0671ULL, 0x00000083ac787210ULL, 0x000fe20007f3e0ffULL,
0x0000001085b57824ULL, 0x000fe200078e0216ULL, 0x0000001e7e837212ULL, 0x080fe200078efcffULL,
0x00000001ad7b7824ULL, 0x040fe200000e067bULL, 0x0000001e7c857212ULL, 0x000fe200078efcffULL,
0x00000001ad757824ULL, 0x000fe200010e0675ULL, 0xfffffff8c1c17812ULL, 0x000fe200078ee280ULL,
0x0000010018807825ULL, 0x000fe200078e00ffULL, 0x00000083ac7e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000070917faeULL, 0x0003e2000b901c46ULL, 0x00000085ac7c7210ULL, 0x000fe20007f5e0ffULL,
0x000001002a827825ULL, 0x000fe200078e00ffULL, 0x00000016c1c77211ULL, 0x000fe200078e20ffULL,
0x0000000072937faeULL, 0x0003e2000b901c46ULL, 0x0000007fad7f7210ULL, 0x000fe200007fe4ffULL,
0x0000010086847825ULL, 0x000fc400078e00ffULL, 0x0000000074957faeULL, 0x0003e4000b901c46ULL,
0x00000010b9bf7824ULL, 0x100fe200078e0216ULL, 0x0000001e80b97212ULL, 0x080fe200078efcffULL,
0x000001008a867825ULL, 0x000fe200078e00ffULL, 0x0000001e84c17212ULL, 0x080fe200078efcffULL,
0x0000000076977faeULL, 0x0003e2000b901c46ULL, 0x000000b9ac807210ULL, 0x000fe20007f1e0ffULL,
0x00000010bdc37824ULL, 0x000fe200078e0216ULL, 0x0000001e82bd7212ULL, 0x080fe200078efcffULL,
0x00000001ad797824ULL, 0x040fe200008e0679ULL, 0x0000001e86c57212ULL, 0x000fe200078efcffULL,
0x00000001ad7d7824ULL, 0x040fe200010e067dULL, 0x000000bdac827210ULL, 0x000fe20007f3e0ffULL,
0x00000001ad817824ULL, 0x040fe200000e0681ULL, 0x000000c1ac847210ULL, 0x000fe20007f5e0ffULL,
0x0000000078b17faeULL, 0x0003e2000b901c46ULL, 0x000000c5ac867210ULL, 0x000fe20007f7e0ffULL,
0x00000001ad837824ULL, 0x000fc400008e0683ULL, 0x00000001ad857824ULL, 0x000fe200010e0685ULL,
0x000000007ab37faeULL, 0x0003e2000b901c46ULL, 0x00000087ad877210ULL, 0x000fc60001ffe4ffULL,
0x000000007cb57faeULL, 0x0003e8000b901c46ULL, 0x000000007eb77faeULL, 0x0003e8000b901c46ULL,
0x0000000080bb7faeULL, 0x0003e8000b901c46ULL, 0x0000000082bf7faeULL, 0x0003e8000b901c46ULL,
0x0000000084c37faeULL, 0x0003e8000b901c46ULL, 0x0000000086c77faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000811187836ULL, 0x000fe20000000000ULL,
0x00000004106b7819ULL, 0x00afe200000006ffULL, 0x000000080f167836ULL, 0x000fe20000000000ULL,
0x000000040d817819ULL, 0x040fe200000006ffULL, 0x000000100d697824ULL, 0x000fe200078e00ffULL,
0xfffffff06b187812ULL, 0x000fe200078ee218ULL, 0x00000010a9687824ULL, 0x100fe400078e020aULL,
0x00000010a7707824ULL, 0x000fe200078e020aULL, 0xfffffff069167812ULL, 0x000fe200078ee216ULL,
0x0000001018187824ULL, 0x000fc400078e021dULL, 0x00000010a5747824ULL, 0x100fe200078e020aULL,
0x0000001d16167211ULL, 0x000fe200078e20ffULL, 0x00000010a3787824ULL, 0x100fe400078e020aULL,
0x0000000a0f1e7836ULL, 0x000fe40000000000ULL, 0x0000000a11207836ULL, 0x000fe40000000000ULL,
0x00000010a1807824ULL, 0x000fe200078e020aULL, 0xfffffff0811e7812ULL, 0x000fe200078ee21eULL,
0x0000001010817824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006868783bULL, 0x000fe20000000200ULL, 0xfffffff081207812ULL, 0x000fe200078ee220ULL,
0x000000109f887824ULL, 0x100fe200078e020aULL, 0x0000001d1e1e7211ULL, 0x080fe200078e20ffULL,
0x00000000166c783bULL, 0x0002a20000000200ULL, 0x000000109d8c7824ULL, 0x100fe200078e020aULL,
0x0000001d20207211ULL, 0x000fe200078e20ffULL, 0x000000102b907824ULL, 0x000fe200078e020aULL,
0x00000000187c783bULL, 0x0007220000000200ULL, 0x000000100d2b7824ULL, 0x000fc600078e00ffULL,
0x000000007070783bULL, 0x000f620000000200ULL, 0x0000000c0f167836ULL, 0x002fe40000000000ULL,
0x0000000e0f0f7836ULL, 0x000fe20000000000ULL, 0x000000007474783bULL, 0x000e620000000200ULL,
0x0000001010187824ULL, 0x048fe200078e00ffULL, 0xfffffff02b167812ULL, 0x000fe400078ee216ULL,
0x000000007878783bULL, 0x000ee20000000200ULL, 0x0000000410107819ULL, 0x000fe400000006ffULL,
0x0000001d16167211ULL, 0x000fe200078e20ffULL, 0x000000008080783bULL, 0x000fe80000000200ULL,
0x000000001e84783bULL, 0x0004680000000200ULL, 0x000000008888783bULL, 0x000e680000000200ULL,
0x000000008c8c783bULL, 0x000ee20000000200ULL, 0x000000100d1e7824ULL, 0x004fc600078e00ffULL,
0x000000009090783bULL, 0x000ea80000000200ULL, 0x000000002094783bULL, 0x000ea20000000200ULL,
0x000000686c98723cULL, 0x000fec0000041898ULL, 0x000000687c2c723cULL, 0x010fec000004182cULL,
0x0000006a6c30723cULL, 0x000fe20000041830ULL, 0x0000001013687824ULL, 0x000fc400078e020aULL,
0x0000000c11137836ULL, 0x000fe40000000000ULL, 0x0000000e11117836ULL, 0x000fe20000000000ULL,
0x000000706c38723cULL, 0x020fe40000041838ULL, 0xfffffff018187812ULL, 0x000fe400078ee213ULL,
0xfffffff010107812ULL, 0x000fe400078ee211ULL, 0x000000726c3c723cULL, 0x000fe2000004183cULL,
0x0000001d18187211ULL, 0x000fc400078e20ffULL, 0x0000001d10107211ULL, 0x000fc600078e20ffULL,
0x000000746c44723cULL, 0x002fec0000041844ULL, 0x000000766c48723cULL, 0x000fec0000041848ULL,
0x000000786c40723cULL, 0x008fec0000041840ULL, 0x0000007a6c4c723cULL, 0x000fe2000004184cULL,
0x00000000166c783bULL, 0x0003ea0000000200ULL, 0x0000006a7c34723cULL, 0x000fe20000041834ULL,
0x000000006868783bULL, 0x000ee20000000200ULL, 0xfffffff01e167812ULL, 0x002fc800078ee20fULL,
0x000000707c50723cULL, 0x000fe20000041850ULL, 0x0000001016167824ULL, 0x000fca00078e021dULL,
0x000000727c54723cULL, 0x000fe20000041854ULL, 0x0000001015707824ULL, 0x000fca00078e020aULL,
0x000000747c58723cULL, 0x000fe20000041858ULL, 0x000000007070783bULL, 0x000e6a0000000200ULL,
0x000000767c5c723cULL, 0x000fe2000004185cULL, 0x0000001017747824ULL, 0x000fca00078e020aULL,
0x000000787c60723cULL, 0x000fe20000041860ULL, 0x000000007474783bULL, 0x000fea0000000200ULL,
0x0000007a7c64723cULL, 0x000fe20000041864ULL, 0x0000000a19787211ULL, 0x000fe200078e20ffULL,
0x00000000187c783bULL, 0x0009e20000000200ULL, 0x00000001ff197424ULL, 0x000fc600078e00ffULL,
0x000000808498723cULL, 0x000fe20000041898ULL, 0x000000007878783bULL, 0x000f6a0000000200ULL,
0x000000828430723cULL, 0x000fec0000041830ULL, 0x000000888438723cULL, 0x000fec0000041838ULL,
0x0000008a843c723cULL, 0x000fec000004183cULL, 0x0000008c8444723cULL, 0x000fec0000041844ULL,
0x0000008e8448723cULL, 0x000fec0000041848ULL, 0x000000908440723cULL, 0x004fec0000041840ULL,
0x00000092844c723cULL, 0x000fe2000004184cULL, 0x000000001684783bULL, 0x000fea0000000200ULL,
0x00000080942c723cULL, 0x000fec000004182cULL, 0x000000829434723cULL, 0x000fe20000041834ULL,
0x000000101f807824ULL, 0x000fca00078e020aULL, 0x000000889450723cULL, 0x000fe20000041850ULL,
0x000000008080783bULL, 0x000eaa0000000200ULL, 0x0000008a9454723cULL, 0x000fe20000041854ULL,
0x0000001023887824ULL, 0x000fca00078e020aULL, 0x0000008c9458723cULL, 0x000fe20000041858ULL,
0x000000008888783bULL, 0x000eaa0000000200ULL, 0x0000008e945c723cULL, 0x000fe2000004185cULL,
0x00000010278c7824ULL, 0x000fca00078e020aULL, 0x000000909460723cULL, 0x000fe20000041860ULL,
0x000000008c8c783bULL, 0x000fea0000000200ULL, 0x000000929464723cULL, 0x000fe20000041864ULL,
0x0000001025907824ULL, 0x000fe200078e020aULL, 0x000000001094783bULL, 0x000fe80000000200ULL,
0x000000686c98723cULL, 0x008fe20000041898ULL, 0x000000009090783bULL, 0x000ee20000000200ULL,
0x01e68819141879a7ULL, 0x010f28000850003fULL, 0x0000006a6c30723cULL, 0x000fec0000041830ULL,
0x000000706c38723cULL, 0x002fec0000041838ULL, 0x000000726c3c723cULL, 0x000fec000004183cULL,
0x000000786c44723cULL, 0x020fec0000041844ULL, 0x0000007a6c48723cULL, 0x000fec0000041848ULL,
0x000000746c40723cULL, 0x000fec0000041840ULL, 0x000000766c4c723cULL, 0x000fec000004184cULL,
0x000000687c2c723cULL, 0x000fec000004182cULL, 0x0000006a7c34723cULL, 0x000fec0000041834ULL,
0x000000707c50723cULL, 0x000fec0000041850ULL, 0x000000727c54723cULL, 0x000fec0000041854ULL,
0x000000787c58723cULL, 0x000fec0000041858ULL, 0x0000007a7c5c723cULL, 0x000fec000004185cULL,
0x000000747c60723cULL, 0x000fec0000041860ULL, 0x000000767c64723cULL, 0x000fec0000041864ULL,
0x000000808498723cULL, 0x004fec0000041898ULL, 0x000000828430723cULL, 0x000fec0000041830ULL,
0x000000888438723cULL, 0x000fec0000041838ULL, 0x0000008a843c723cULL, 0x000fec000004183cULL,
0x000000908444723cULL, 0x008fe20000041844ULL, 0x3db504f3980f7820ULL, 0x000fe20000410000ULL,
0x3db504f399997820ULL, 0x000fe20000410000ULL, 0x3db504f39a9a7820ULL, 0x000fe20000410000ULL,
0x3db504f39b9b7820ULL, 0x000fc40000410000ULL, 0x000000928448723cULL, 0x000fe20000041848ULL,
0x3db504f330307820ULL, 0x000fe20000410000ULL, 0x3db504f331317820ULL, 0x000fe20000410000ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fe40000410000ULL,
0x0000008c8440723cULL, 0x000fe20000041840ULL, 0x3db504f338387820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc40000410000ULL, 0x0000008e844c723cULL, 0x000fe2000004184cULL,
0x3db504f33c3c7820ULL, 0x000fe20000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe20000410000ULL,
0x3db504f33e3e7820ULL, 0x000fe20000410000ULL, 0x3db504f33f3f7820ULL, 0x000fe40000410000ULL,
0x00000080942c723cULL, 0x000fe2000004182cULL, 0x3db504f344447820ULL, 0x000fe20000410000ULL,
0x3db504f345457820ULL, 0x000fe20000410000ULL, 0x3db504f346467820ULL, 0x000fe20000410000ULL,
0x3db504f347477820ULL, 0x000fc40000410000ULL, 0x000000829434723cULL, 0x000fe20000041834ULL,
0x3db504f348487820ULL, 0x000fe20000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x3db504f34a4a7820ULL, 0x000fe20000410000ULL, 0x3db504f34b4b7820ULL, 0x000fe40000410000ULL,
0x000000889450723cULL, 0x000fe20000041850ULL, 0x3db504f340407820ULL, 0x000fe20000410000ULL,
0x3db504f341417820ULL, 0x000fe20000410000ULL, 0x3db504f342427820ULL, 0x000fe20000410000ULL,
0x3db504f343437820ULL, 0x000fc40000410000ULL, 0x0000008a9454723cULL, 0x000fe20000041854ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fe40000410000ULL,
0x000000909458723cULL, 0x000fe20000041858ULL, 0x3db504f32c137820ULL, 0x000fe20000410000ULL,
0x3db504f32d157820ULL, 0x000fe20000410000ULL, 0x3db504f32e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f1f7820ULL, 0x000fc40000410000ULL, 0x00000092945c723cULL, 0x000fe2000004185cULL,
0x3db504f334347820ULL, 0x000fe20000410000ULL, 0x3db504f335357820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f337377820ULL, 0x000fe40000410000ULL,
0x0000008c9460723cULL, 0x000fe20000041860ULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fc40000410000ULL, 0x0000008e9464723cULL, 0x000fe20000041864ULL,
0x3db504f354547820ULL, 0x000fe20000410000ULL, 0x3db504f355557820ULL, 0x000fe20000410000ULL,
0x3db504f356567820ULL, 0x000fe20000410000ULL, 0x3db504f357577820ULL, 0x000fe40000410000ULL,
0x3db504f358587820ULL, 0x000fe20000410000ULL, 0x3db504f359597820ULL, 0x000fe20000410000ULL,
0x3db504f35a5a7820ULL, 0x000fe20000410000ULL, 0x3db504f35b5b7820ULL, 0x000fc60000410000ULL,
0x3db504f35c5c7820ULL, 0x000fe20000410000ULL, 0x3db504f35d5d7820ULL, 0x000fe20000410000ULL,
0x3db504f35e5e7820ULL, 0x000fe20000410000ULL, 0x3db504f35f5f7820ULL, 0x000fc60000410000ULL,
0x3db504f360607820ULL, 0x000fe20000410000ULL, 0x3db504f361617820ULL, 0x000fe20000410000ULL,
0x3db504f362627820ULL, 0x000fe20000410000ULL, 0x3db504f363637820ULL, 0x000fc60000410000ULL,
0x3db504f364647820ULL, 0x000fe20000410000ULL, 0x3db504f365657820ULL, 0x000fe20000410000ULL,
0x3db504f366667820ULL, 0x000fe20000410000ULL, 0x3db504f367677820ULL, 0x000fe20000410000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x01e68819140075a7ULL, 0x010e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff207224ULL, 0x000fce00078e00ffULL,
0x000000102000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016100d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000117167824ULL, 0x000fe200000e0e11ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc80000011416ULL,
0x0000000d0a0a7211ULL, 0x000fc800078110ffULL, 0x00000016ff0d7210ULL, 0x000fc800007fe4ffULL,
0x000000020a0a7819ULL, 0x000fc8000000120dULL, 0x0000000a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000120207836ULL, 0x000fce0000000000ULL,
0x01e68819140075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000004070a7824ULL, 0x000fe200078e00ffULL, 0x000000062100720cULL, 0x000fe20003f06070ULL,
0x00000080240d7824ULL, 0x000fc600078e021dULL, 0xfffffff00a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0d0d7210ULL, 0x000fca0007ffe0ffULL, 0x01e400000d2c7984ULL, 0x0002a20000000c00ULL,
0x0000002000608947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x00000022070a7211ULL, 0x000fe200078ff0ffULL, 0x0000000400177d06ULL, 0x000ef00008209000ULL,
0x0000001700177308ULL, 0x008ee40000001000ULL, 0x0ffffffe17107836ULL, 0x008fc40000000000ULL,
0x000000100a177836ULL, 0x000fc80000000000ULL, 0x0000001000117305ULL, 0x000724000021f000ULL,
0x000000ffff107224ULL, 0x008fe400078e00ffULL, 0x000000ffff197224ULL, 0x010fc800078e0a11ULL,
0x0000000419197c24ULL, 0x000fc8000f8e02ffULL, 0x00000019112a7227ULL, 0x000fe200078e0010ULL,
0x000000080a117810ULL, 0x000fc60007ffe0ffULL, 0x000000180a197836ULL, 0x000fe40000000000ULL,
0x0000000a2a107227ULL, 0x000fc800078e00ffULL, 0x000000112a167227ULL, 0x000fe200078e00ffULL,
0x000000ff10217210ULL, 0x000fc60007ffe1ffULL, 0x000000ffff207224ULL, 0x000fe400078e0a16ULL,
0x00000004210a7c24ULL, 0x000fe2000f8e020aULL, 0x00000004ff217c12ULL, 0x000fe2000f8e33ffULL,
0x0000000420117c24ULL, 0x000fe4000f8e0211ULL, 0x000000172a187227ULL, 0x000fe200078e00ffULL,
0x000000040a007c0cULL, 0x000fe4000bfa6070ULL, 0x0000000411007c0cULL, 0x000fe2000bf06070ULL,
0x000000192a207227ULL, 0x000fc800078e00ffULL, 0x000000ffff2a7224ULL, 0x000fe400078e0a18ULL,
0x000000ffff687224ULL, 0x000fe400078e0a20ULL, 0x000000042a177c24ULL, 0x000fe2000f8e0217ULL,
0x0000000b1c2a7248ULL, 0x000fe20007fe0000ULL, 0x0000000468197c24ULL, 0x000fe2000f8e0219ULL,
0x800000040a0a5c10ULL, 0x000fe2000fffe0ffULL, 0x8000000411110c36ULL, 0x000fe20008000000ULL,
0x0000000417007c0cULL, 0x000fe2000bf46070ULL, 0x0000000116160836ULL, 0x000fe20000000000ULL,
0x000000040a007c0cULL, 0x000fe2000bf86070ULL, 0x0000000110105836ULL, 0x000fe20000000000ULL,
0x0000000411007c0cULL, 0x000fe2000bfc6070ULL, 0x000000012a237824ULL, 0x000fe200078e0a0bULL,
0x0000000107687819ULL, 0x000fc400000006ffULL, 0x0000000419007c0cULL, 0x000fe2000bf66070ULL,
0x000000ffff817224ULL, 0x000fe200078e0a23ULL, 0x0000000668687812ULL, 0x000fc600078ec0ffULL,
0x8000000417172c36ULL, 0x000fe20008000000ULL, 0x00000003686a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000110104836ULL, 0x000fe20000000000ULL, 0x0000000118182810ULL, 0x000fe20007ffe0ffULL,
0x0000000116166836ULL, 0x000fe20000000000ULL, 0x0000000417007c0cULL, 0x000fe2000bf26070ULL,
0x00000001090a7824ULL, 0x000fe200078e0268ULL, 0x00000004ff007c0cULL, 0x000fe2000bfc5070ULL,
0x8000000419193c36ULL, 0x000fe20008000000ULL, 0x000000236a00720cULL, 0x000fe20003f86070ULL,
0x0000000120203836ULL, 0x000fe20000000000ULL, 0x00000010210b7207ULL, 0x000fc40007000000ULL,
0x000000230a00720cULL, 0x000fe40003fa6070ULL, 0x000000810a0a7246ULL, 0x000fe40003800008ULL,
0x0000000b080b7248ULL, 0x000fe20003fe0000ULL, 0x0000000118181836ULL, 0x000fe20000000000ULL,
0x000000816a737246ULL, 0x000fe40003800008ULL, 0x00000004ff0a7819ULL, 0x000fe2000001160aULL,
0x000000050b8c7c24ULL, 0x000fe2000f8e02ffULL, 0x0000000419007c0cULL, 0x000fc4000bf06070ULL,
0x000000ff73737207ULL, 0x000fe40002000000ULL, 0x0000001621117207ULL, 0x040fe40007000000ULL,
0x000000ff0a177207ULL, 0x000fe40002800000ULL, 0x0000001821197207ULL, 0x000fe40007000000ULL,
0x0000008c736d7211ULL, 0x000fe400078fe0ffULL, 0x0000001108117248ULL, 0x000fe20003fe0000ULL,
0x0000000120200836ULL, 0x000fe20000000000ULL, 0x000000178c0b7210ULL, 0x000fe20007ffe0ffULL,
0x000000026d6c7825ULL, 0x000fe200078e00aaULL, 0x0000001908197248ULL, 0x000fc40003fe0000ULL,
0x0000002021217207ULL, 0x000fe20007000000ULL, 0x00000005118e7c24ULL, 0x000fe4000f8e02ffULL,
0x000000020b0a7825ULL, 0x000fe200078e00aaULL, 0x000000066c6c7981ULL, 0x000ee2000c1e9500ULL,
0x0000002108217248ULL, 0x000fe40003fe0000ULL, 0x0000000519907c24ULL, 0x000fe2000f8e02ffULL,
0x000000060a257981ULL, 0x0008e2000c1e9500ULL, 0x0000000117117824ULL, 0x000fe200078e028eULL,
0x0000008e736f7211ULL, 0x000fc400078fe0ffULL, 0x0000009073717211ULL, 0x000fe200078fe0ffULL,
0x0000000211107825ULL, 0x000fe200078e00aaULL, 0x0000001068727812ULL, 0x000fc600078efcffULL,
0x0000000117197824ULL, 0x000fe200078e0290ULL, 0x0000000610277981ULL, 0x000ae2000c1e9500ULL,
0x000000026f6e7825ULL, 0x000fc800078e00aaULL, 0x0000000271707825ULL, 0x100fe400078e00aaULL,
0x000000066e6e7981ULL, 0x000ee4000c1e9500ULL, 0x00000002190a7825ULL, 0x012fe200078e00aaULL,
0x0000007209107210ULL, 0x024fe20007ffe0ffULL, 0x0000000670707981ULL, 0x000ea4000c1e9500ULL,
0x0000000521927c24ULL, 0x000fe2000f8e02ffULL, 0x0000008110117246ULL, 0x000fe20003800008ULL,
0x000000060a697981ULL, 0x0002a2000c1e9500ULL, 0x0000000172747824ULL, 0x000fc400078e0203ULL,
0x0000009273777211ULL, 0x000fe200078fe0ffULL, 0x0000000117177824ULL, 0x000fe200078e0292ULL,
0x000000231000720cULL, 0x080fe40003f26070ULL, 0x00000004ff117819ULL, 0x000fe20000011611ULL,
0x0000000217167825ULL, 0x100fe200078e00aaULL, 0x000000237400720cULL, 0x000fe40003f06070ULL,
0x00000081747b7246ULL, 0x000fe20003800008ULL, 0x0000000277767825ULL, 0x000fe200078e00aaULL,
0x000000ff11117207ULL, 0x000fe20000800000ULL, 0x00000006166b7981ULL, 0x000962000c1e9500ULL,
0x000000ff7b7b7207ULL, 0x000fc60000000000ULL, 0x0000000676767981ULL, 0x000f62000c1e9500ULL,
0x0000008c7b797211ULL, 0x040fe200078fe0ffULL, 0x000000018c0b7824ULL, 0x002fe200078e0211ULL,
0x0000008e7b197211ULL, 0x000fe200078fe0ffULL, 0x0000000111177824ULL, 0x010fe200078e028eULL,
0x00000020687e7812ULL, 0x000fc600078efcffULL, 0x0000000217167825ULL, 0x000fe200078e00aaULL,
0x0000009011217210ULL, 0x000fc60007ffe0ffULL, 0x0000000279787825ULL, 0x000fe200078e00aaULL,
0x00000006166f7981ULL, 0x000326000c1e9500ULL, 0x00000001112b7824ULL, 0x000fe400078e0292ULL,
0x000000020b0a7825ULL, 0x100fe200078e00aaULL, 0x0000000678787981ULL, 0x000f26000c1e9500ULL,
0x0000000219107825ULL, 0x000fe200078e00aaULL, 0x000000060a6d7981ULL, 0x000f26000c1e9500ULL,
0x0000000109167824ULL, 0x002fe200078e027eULL, 0x00000006107a7981ULL, 0x000322000c1e9500ULL,
0x000000907b7d7211ULL, 0x040fe200078fe0ffULL, 0x000000017e807824ULL, 0x000fe200078e0203ULL,
0x000000927b837211ULL, 0x000fc400078fe0ffULL, 0x0000008116177246ULL, 0x000fe20003800008ULL,
0x000000027d7c7825ULL, 0x000fe200078e00aaULL, 0x000000231600720cULL, 0x080fe40003f26070ULL,
0x00000004ff177819ULL, 0x000fe20000011617ULL, 0x0000000283827825ULL, 0x100fe200078e00aaULL,
0x000000238000720cULL, 0x000fe20003f06070ULL, 0x000000067c7c7981ULL, 0x000f22000c1e9500ULL,
0x0000008180107246ULL, 0x002fe20003800008ULL, 0x0000000221187825ULL, 0x100fe200078e00aaULL,
0x000000ff17177207ULL, 0x000fe20000800000ULL, 0x0000000682827981ULL, 0x000f24000c1e9500ULL,
0x000000022b0a7825ULL, 0x000fe200078e00aaULL, 0x000000ff107f7207ULL, 0x000fe20000000000ULL,
0x0000000618717981ULL, 0x000f28000c1e9500ULL, 0x000000060a757981ULL, 0x000322000c1e9500ULL,
0x0000000117857824ULL, 0x000fe200078e028eULL, 0x0000008e7f217211ULL, 0x000fc400078fe0ffULL,
0x000000927f797211ULL, 0x000fe400078fe0ffULL, 0x000000178c0b7210ULL, 0x002fe20007ffe0ffULL,
0x0000000285847825ULL, 0x000fc800078e00aaULL, 0x000000020b0a7825ULL, 0x100fe400078e00aaULL,
0x0000000684847981ULL, 0x000f24000c1e9500ULL, 0x0000000221207825ULL, 0x000fe400078e00aaULL,
0x000000060a777981ULL, 0x000322000c1e9500ULL, 0x0000008c7f2b7211ULL, 0x040fe400078fe0ffULL,
0x000000907f117211ULL, 0x000fe200078fe0ffULL, 0x0000000117197824ULL, 0x000fc400078e0290ULL,
0x00000002790a7825ULL, 0x002fe400078e00aaULL, 0x0000000620797981ULL, 0x000f24000c1e9500ULL,
0x00000001177d7824ULL, 0x000fe400078e0292ULL, 0x000000022b2a7825ULL, 0x100fe200078e00aaULL,
0x0000003068887812ULL, 0x000fe200078efcffULL, 0x000000060adc7981ULL, 0x000f24000c1e9500ULL,
0x0000000211167825ULL, 0x000fc400078e00aaULL, 0x000000062a867981ULL, 0x000324000c1e9500ULL,
0x0000000219187825ULL, 0x100fe400078e00aaULL, 0x0000000616d87981ULL, 0x000f24000c1e9500ULL,
0x000000027d107825ULL, 0x000fe400078e00aaULL, 0x00000006187d7981ULL, 0x000324000c1e9500ULL,
0x00000088092a7210ULL, 0x002fc40007ffe0ffULL, 0x00000006108d7981ULL, 0x000322000c1e9500ULL,
0x00000001888a7824ULL, 0x000fe200078e0203ULL, 0x000000812a2b7246ULL, 0x000fe40003800008ULL,
0x000000232a00720cULL, 0x080fe40003f26070ULL, 0x000000238a00720cULL, 0x000fe40003f06070ULL,
0x00000004ff2b7819ULL, 0x000fe4000001162bULL, 0x000000818a187246ULL, 0x000fc40003800008ULL,
0x000000ff2b837207ULL, 0x000fe40000800000ULL, 0x000000ff18817207ULL, 0x000fe40000000000ULL,
0x0000009083177210ULL, 0x000fe20007ffe0ffULL, 0x000000018c217824ULL, 0x000fe200078e0283ULL,
0x0000008c812b7211ULL, 0x040fe400078fe0ffULL, 0x0000009081197211ULL, 0x000fe200078fe0ffULL,
0x0000000221207825ULL, 0x000fc800078e00aaULL, 0x000000022b2a7825ULL, 0x100fe200078e00aaULL,
0x0000000620857981ULL, 0x000326000c1e9500ULL, 0x0000000217167825ULL, 0x100fe200078e00aaULL,
0x000000062ac07981ULL, 0x000326000c1e9500ULL, 0x0000000219187825ULL, 0x000fe200078e00aaULL,
0x00000006168b7981ULL, 0x000f22000c1e9500ULL, 0x0000008e81117211ULL, 0x002fc600078fe0ffULL,
0x0000000618da7981ULL, 0x000f22000c1e9500ULL, 0x00000001830b7824ULL, 0x000fe400078e028eULL,
0x0000000211107825ULL, 0x000fc800078e00aaULL, 0x000000020b0a7825ULL, 0x000fe200078e00aaULL,
0x0000000610d67981ULL, 0x000f22000c1e9500ULL, 0x0000009281217211ULL, 0x000fc600078fe0ffULL,
0x000000060a897981ULL, 0x000322000c1e9500ULL, 0x00000001832b7824ULL, 0x000fe400078e0292ULL,
0x0000000221207825ULL, 0x000fc800078e00aaULL, 0x000000022b2a7825ULL, 0x000fe200078e00aaULL,
0x0000000620de7981ULL, 0x000f28000c1e9500ULL, 0x000000062a8f7981ULL, 0x000324000c1e9500ULL,
0xfffffff0730a7812ULL, 0x002fe200078ec0ffULL, 0x00000001ffd47424ULL, 0x000fc800078e00ffULL,
0x00000001230b7824ULL, 0x000fe200078e020aULL, 0x00000001688c7812ULL, 0x000fc800078efcffULL,
0x8000000b6a0a7210ULL, 0x000fc80007ffe0ffULL, 0x0000000ad40a7219ULL, 0x000fe200000006ffULL,
0x000000018c107824ULL, 0x000fe200078e0203ULL, 0xfffffff07b167812ULL, 0x000fc600078ec0ffULL,
0x0000000110117824ULL, 0x000fe200078e0a0bULL, 0x00000008688e7812ULL, 0x040fe400078efcffULL,
0x0000000968907812ULL, 0x000fe400078efcffULL, 0x0000001623197210ULL, 0x000fe40007ffe0ffULL,
0x00000011d4167219ULL, 0x000fe400000006ffULL, 0x000000038e187210ULL, 0x000fe20007ffe0ffULL,
0x00000001902a7824ULL, 0x000fe200078e0203ULL, 0xfffffff07f207812ULL, 0x000fc400078ec0ffULL,
0xfffffff081927812ULL, 0x000fe200078ec0ffULL, 0x0000000118177824ULL, 0x100fe400078e0a0bULL,
0x000000012a0b7824ULL, 0x000fe200078e0a0bULL, 0x0000001168967812ULL, 0x000fe200078efcffULL,
0x0000000123217824ULL, 0x040fe200078e0220ULL, 0x00000017d4207219ULL, 0x040fe200000006ffULL,
0x00000001237f7824ULL, 0x000fe200078e0292ULL, 0x0000000bd4927219ULL, 0x000fe200000006ffULL,
0x0000000196987824ULL, 0x000fe400078e0203ULL, 0x00000001740b7824ULL, 0x000fe200078e0a19ULL,
0x00000018689e7812ULL, 0x000fc400078efcffULL, 0x0000009819117210ULL, 0x000fe40007ffe1ffULL,
0x0000001968a47812ULL, 0x000fe400078efcffULL, 0x000054106c257816ULL, 0x008fc80000000025ULL,
0x000000250aff7212ULL, 0x000fc800078ac0ffULL, 0x000000236a00720cULL, 0x000fc80002fa1470ULL,
0x000000236800720cULL, 0x000fe40002fa1070ULL, 0x000054106e277816ULL, 0x000fe40000000027ULL,
0xff8000000f0f7808ULL, 0x000fe40002800000ULL, 0x0000002516ff7212ULL, 0x000fe4000782c0ffULL,
0x0000541070697816ULL, 0x004fe40000000069ULL, 0x000000270aff7212ULL, 0x000fc4000784c0ffULL,
0x000000690aff7212ULL, 0x000fe4000788c0ffULL, 0x0000002716ff7212ULL, 0x000fe400078ac0ffULL,
0x000000236a00720cULL, 0x0c0fe40001741470ULL, 0x000000236a00720cULL, 0x080fe40002781470ULL,
0x000000231000720cULL, 0x0c0fe40000f21470ULL, 0x000000231000720cULL, 0x000fc40002fa1470ULL,
0x000000236800720cULL, 0x0c0fe40001741070ULL, 0x000000236800720cULL, 0x080fe40002781070ULL,
0x000000238c00720cULL, 0x0c0fe40000f21070ULL, 0x000000238c00720cULL, 0x000fe40002fa1070ULL,
0x00005410766b7816ULL, 0x020fe4000000006bULL, 0xff8000009a9a7808ULL, 0x000fc40001000000ULL,
0xff80000013137808ULL, 0x000fe40002000000ULL, 0xff80000099997808ULL, 0x000fe40000800000ULL,
0xff8000009b9b7808ULL, 0x000fe40002800000ULL, 0x0000002520ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006b0aff7212ULL, 0x000fe4000780c0ffULL, 0x0000006916ff7212ULL, 0x000fc4000784c0ffULL,
0x0000006b16ff7212ULL, 0x000fe4000788c0ffULL, 0x0000002792ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006920ff7212ULL, 0x000fe400078ac0ffULL, 0x000000236a00720cULL, 0x080fe40000701470ULL,
0x000000231000720cULL, 0x0c0fe40001741470ULL, 0x000000231000720cULL, 0x000fc40002781470ULL,
0x000000231800720cULL, 0x0c0fe40001f61470ULL, 0x000000231800720cULL, 0x080fe40002fa1470ULL,
0x000000232a00720cULL, 0x080fe40000f21470ULL, 0x000000236800720cULL, 0x080fe40000701070ULL,
0x000000238c00720cULL, 0x0c0fe40001741070ULL, 0x000000238c00720cULL, 0x000fc40002781070ULL,
0x000000238e00720cULL, 0x0c0fe40001f61070ULL, 0x000000238e00720cULL, 0x080fe40002fa1070ULL,
0x000000239000720cULL, 0x000fe40000f21070ULL, 0x0000000bd4947219ULL, 0x040fe400000006ffULL,
0x00000011d49c7219ULL, 0x000fe400000006ffULL, 0x00005410786d7816ULL, 0x010fc4000000006dULL,
0x000054107a6f7816ULL, 0x000fe2000000006fULL, 0x000000019ea07824ULL, 0x000fe200078e0203ULL,
0x00000003a4a67210ULL, 0x000fe40007ffe0ffULL, 0xff8000001e1e7808ULL, 0x000fe40000000000ULL,
0xff80000015157808ULL, 0x000fe40001000000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fc40001800000ULL, 0xff80000034347808ULL, 0x000fe40002800000ULL,
0xff80000033337808ULL, 0x000fe40000800000ULL, 0x0000002720ff7212ULL, 0x000fe4000780c0ffULL,
0x0000006992ff7212ULL, 0x000fe4000784c0ffULL, 0x0000006b20ff7212ULL, 0x080fe4000788c0ffULL,
0x0000006b92ff7212ULL, 0x000fc4000786c0ffULL, 0x0000006d9cff7212ULL, 0x000fe400078ac0ffULL,
0x0000006f94ff7212ULL, 0x000fe2000782c0ffULL, 0x00000001a0177824ULL, 0x100fe200078e0a19ULL,
0x000000231800720cULL, 0x080fe20000701470ULL, 0x00000001a6197824ULL, 0x000fe200078e0a19ULL,
0x000000231800720cULL, 0x080fe40002781470ULL, 0x000000232a00720cULL, 0x0c0fe40001741470ULL,
0x000000232a00720cULL, 0x000fc40001f61470ULL, 0x000000237400720cULL, 0x080fe40000f21470ULL,
0x000000239800720cULL, 0x080fe40002fa1470ULL, 0x000000238e00720cULL, 0x0c0fe40000701070ULL,
0x000000238e00720cULL, 0x080fe40002781070ULL, 0x000000239000720cULL, 0x0c0fe40001741070ULL,
0x000000239000720cULL, 0x000fc40001f61070ULL, 0x000000237200720cULL, 0x080fe40000f21070ULL,
0x000000239600720cULL, 0x000fe40002fa1070ULL, 0x00000017d4a27219ULL, 0x040fe400000006ffULL,
0x00000019d4a87219ULL, 0x000fe400000006ffULL, 0x000054107c717816ULL, 0x000fe40000000071ULL,
0x0000541082757816ULL, 0x000fc40000000075ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000036367808ULL, 0x000fe40002000000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff80000037377808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff80000039397808ULL, 0x000fc40002800000ULL, 0x0000006d94ff7212ULL, 0x080fe4000780c0ffULL,
0x0000006da2ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007194ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007594ff7212ULL, 0x000fe4000786c0ffULL, 0x000000719cff7212ULL, 0x000fe4000782c0ffULL,
0x0000006fa8ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001802b7824ULL, 0x000fe200078e0a21ULL,
0x000000237400720cULL, 0x000fc40000701470ULL, 0x000000237400720cULL, 0x0c0fe40001741470ULL,
0x000000237400720cULL, 0x080fe40001f61470ULL, 0x000000239800720cULL, 0x080fe40000f21470ULL,
0x00000023a000720cULL, 0x080fe40002781470ULL, 0x00000023a600720cULL, 0x000fe40002fa1470ULL,
0x0000002168ae7812ULL, 0x000fc400078efcffULL, 0x000000237200720cULL, 0x0c0fe40000701070ULL,
0x000000237200720cULL, 0x0c0fe40001741070ULL, 0x000000237200720cULL, 0x080fe40001f61070ULL,
0x000000239600720cULL, 0x080fe40000f21070ULL, 0x000000239e00720cULL, 0x080fe40002781070ULL,
0x00000023a400720cULL, 0x000fc40002fa1070ULL, 0x0000002bd4ac7219ULL, 0x000fe400000006ffULL,
0x0000541079797816ULL, 0x000fe20000000084ULL, 0x00000001aeb07824ULL, 0x000fe200078e0203ULL,
0xff80000038387808ULL, 0x000fe40000000000ULL, 0xff80000050507808ULL, 0x000fe40001000000ULL,
0xff80000052527808ULL, 0x000fe40001800000ULL, 0xff80000051517808ULL, 0x000fc40000800000ULL,
0xff8000003c3c7808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x0000006f9cff7212ULL, 0x040fe4000780c0ffULL, 0x000000759cff7212ULL, 0x000fe4000784c0ffULL,
0x0000006fa2ff7212ULL, 0x000fe4000786c0ffULL, 0x00000071a8ff7212ULL, 0x000fc4000782c0ffULL,
0x00000075a8ff7212ULL, 0x000fe4000788c0ffULL, 0x00000079acff7212ULL, 0x000fe400078ac0ffULL,
0x000000239800720cULL, 0x0c0fe40000701470ULL, 0x000000239800720cULL, 0x080fe40001741470ULL,
0x00000023a000720cULL, 0x080fe40001f61470ULL, 0x00000023a600720cULL, 0x000fc40000f21470ULL,
0x00000023a600720cULL, 0x080fe40002781470ULL, 0x000000238000720cULL, 0x080fe40002fa1470ULL,
0x000000b021737210ULL, 0x000fe40007ffe1ffULL, 0x0000002868b47812ULL, 0x040fe400078efcffULL,
0x0000002968ba7812ULL, 0x000fe400078efcffULL, 0x000000239600720cULL, 0x000fc40000701070ULL,
0x000000239600720cULL, 0x080fe40001741070ULL, 0x000000239e00720cULL, 0x080fe40001f61070ULL,
0x00000023a400720cULL, 0x0c0fe40000f21070ULL, 0x00000023a400720cULL, 0x080fe40002781070ULL,
0x000000237e00720cULL, 0x000fe40002fa1070ULL, 0x00000073d4b27219ULL, 0x000fc400000006ffULL,
0x0000541086777816ULL, 0x000fe40000000077ULL, 0x00005410d87d7816ULL, 0x000fe4000000007dULL,
0x00005410dc8d7816ULL, 0x000fe2000000008dULL, 0x00000001b4b67824ULL, 0x100fe200078e0203ULL,
0xff8000003b3b7808ULL, 0x000fe20000000000ULL, 0x00000001babc7824ULL, 0x000fe200078e0203ULL,
0xff80000053537808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fc40001800000ULL,
0xff80000055557808ULL, 0x000fe40000800000ULL, 0xff80000057577808ULL, 0x000fe40002000000ULL,
0xff80000046467808ULL, 0x000fe40002800000ULL, 0x0000002592ff7212ULL, 0x000fe400078cc0ffULL,
0x00000071a2ff7212ULL, 0x040fe4000780c0ffULL, 0x00000075a2ff7212ULL, 0x000fc4000784c0ffULL,
0x00000077acff7212ULL, 0x040fe4000786c0ffULL, 0x0000007dacff7212ULL, 0x040fe4000782c0ffULL,
0x0000008dacff7212ULL, 0x000fe4000788c0ffULL, 0x0000007db2ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b67b7824ULL, 0x100fe200078e0a21ULL, 0x000000232a00720cULL, 0x080fe200037c1470ULL,
0x00000001bc217824ULL, 0x000fe200078e0a21ULL, 0x00000023a000720cULL, 0x000fc40000701470ULL,
0x00000023a000720cULL, 0x080fe40001741470ULL, 0x000000238000720cULL, 0x0c0fe40001f61470ULL,
0x000000238000720cULL, 0x0c0fe40000f21470ULL, 0x000000238000720cULL, 0x080fe40002781470ULL,
0x00000023b000720cULL, 0x080fe40002fa1470ULL, 0x000000239000720cULL, 0x000fc400037c1070ULL,
0x000000239e00720cULL, 0x0c0fe40000701070ULL, 0x000000239e00720cULL, 0x080fe40001741070ULL,
0x000000237e00720cULL, 0x0c0fe40001f61070ULL, 0x000000237e00720cULL, 0x0c0fe40000f21070ULL,
0x000000237e00720cULL, 0x080fe40002781070ULL, 0x00000023ae00720cULL, 0x000fc40002fa1070ULL,
0x0000007bd4b87219ULL, 0x040fe400000006ffULL, 0x00000021d4be7219ULL, 0x000fe400000006ffULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000054547808ULL, 0x000fe40000000000ULL,
0xff80000056567808ULL, 0x000fe40001000000ULL, 0xff80000044447808ULL, 0x000fc40001800000ULL,
0xff80000058587808ULL, 0x000fe40000800000ULL, 0xff8000005a5a7808ULL, 0x000fe40002000000ULL,
0xff80000059597808ULL, 0x000fe40002800000ULL, 0x0000006da8ff7212ULL, 0x000fe400078cc0ffULL,
0x00000077b2ff7212ULL, 0x080fe4000780c0ffULL, 0x00000077b8ff7212ULL, 0x000fc4000784c0ffULL,
0x00000079b2ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008db2ff7212ULL, 0x000fe4000782c0ffULL,
0x00000079b8ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007dbeff7212ULL, 0x000fe200078ac0ffULL,
0x000000018a817824ULL, 0x000fe200078e0a7fULL, 0x00000023a600720cULL, 0x080fe400037c1470ULL,
0x00000023b000720cULL, 0x000fc40000701470ULL, 0x00000023b000720cULL, 0x0c0fe40001f61470ULL,
0x00000023b000720cULL, 0x080fe40000f21470ULL, 0x00000023b600720cULL, 0x0c0fe40001741470ULL,
0x00000023b600720cULL, 0x080fe40002781470ULL, 0x00000023bc00720cULL, 0x000fe40002fa1470ULL,
0x0000003868ca7812ULL, 0x000fc400078efcffULL, 0x0000003168c47812ULL, 0x040fe400078efcffULL,
0x0000003968d07812ULL, 0x000fe400078efcffULL, 0x00000023a400720cULL, 0x080fe400037c1070ULL,
0x00000023ae00720cULL, 0x0c0fe40000701070ULL, 0x00000023ae00720cULL, 0x0c0fe40001f61070ULL,
0x00000023ae00720cULL, 0x000fc40000f21070ULL, 0x00000023b400720cULL, 0x0c0fe40001741070ULL,
0x00000023b400720cULL, 0x080fe40002781070ULL, 0x00000023ba00720cULL, 0x000fe40002fa1070ULL,
0x00000081d4c27219ULL, 0x000fe400000006ffULL, 0x00005410c0857816ULL, 0x000fe40000000085ULL,
0x00005410da8b7816ULL, 0x000fe2000000008bULL, 0x00000001cacc7824ULL, 0x100fe200078e0203ULL,
0x00000003c4c67210ULL, 0x000fe20007ffe0ffULL, 0x00000001d0d27824ULL, 0x000fe200078e0203ULL,
0xff8000003d3d7808ULL, 0x000fc40003000000ULL, 0xff80000045457808ULL, 0x000fe40000000000ULL,
0xff80000047477808ULL, 0x000fe40001800000ULL, 0xff8000005b5b7808ULL, 0x000fe40000800000ULL,
0xff80000048487808ULL, 0x000fe40001000000ULL, 0xff8000004a4a7808ULL, 0x000fe40002000000ULL,
0xff8000005d5d7808ULL, 0x000fc40002800000ULL, 0x00000077beff7212ULL, 0x040fe400078cc0ffULL,
0x00000079beff7212ULL, 0x000fe4000780c0ffULL, 0x0000007db8ff7212ULL, 0x040fe4000786c0ffULL,
0x0000008db8ff7212ULL, 0x080fe4000782c0ffULL, 0x0000008dbeff7212ULL, 0x000fe4000784c0ffULL,
0x00000085c2ff7212ULL, 0x000fc4000788c0ffULL, 0x0000008bc2ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001cc877824ULL, 0x100fe200078e0a7fULL, 0x000000c67f837210ULL, 0x000fe20007ffe1ffULL,
0x00000001d27f7824ULL, 0x000fe200078e0a7fULL, 0x00000023b600720cULL, 0x0c0fe40001f61470ULL,
0x00000023b600720cULL, 0x080fe40000f21470ULL, 0x00000023bc00720cULL, 0x0c0fe400037c1470ULL,
0x00000023bc00720cULL, 0x000fc40000701470ULL, 0x00000023bc00720cULL, 0x080fe40001741470ULL,
0x000000238a00720cULL, 0x0c0fe40002781470ULL, 0x000000238a00720cULL, 0x000fe40002fa1470ULL,
0x00000083d4c87219ULL, 0x040fe400000006ffULL, 0x00000087d4ce7219ULL, 0x000fe400000006ffULL,
0x00000023b400720cULL, 0x000fc40001f61070ULL, 0x00000023b400720cULL, 0x080fe40000f21070ULL,
0x00000023ba00720cULL, 0x0c0fe400037c1070ULL, 0x00000023ba00720cULL, 0x0c0fe40000701070ULL,
0x00000023ba00720cULL, 0x080fe40001741070ULL, 0x000000238800720cULL, 0x0c0fe40002781070ULL,
0x000000238800720cULL, 0x000fc40002fa1070ULL, 0x0000007fd4d47219ULL, 0x000fe400000006ffULL,
0x00005410d6897816ULL, 0x000fe40000000089ULL, 0xff8000005c5c7808ULL, 0x000fe40001800000ULL,
0xff8000005e5e7808ULL, 0x000fe40000800000ULL, 0xff80000049497808ULL, 0x000fe40003000000ULL,
0xff8000004b4b7808ULL, 0x000fc40000000000ULL, 0xff8000005f5f7808ULL, 0x000fe40001000000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0xff80000060607808ULL, 0x000fe40002800000ULL,
0x00000085c8ff7212ULL, 0x080fe4000786c0ffULL, 0x00000085ceff7212ULL, 0x080fe4000782c0ffULL,
0x00000085d4ff7212ULL, 0x000fc400078cc0ffULL, 0x00000089c2ff7212ULL, 0x080fe4000780c0ffULL,
0x00000089c8ff7212ULL, 0x080fe4000784c0ffULL, 0x00000089ceff7212ULL, 0x000fe4000788c0ffULL,
0x0000008bc8ff7212ULL, 0x000fe400078ac0ffULL, 0x000000238a00720cULL, 0x080fe40000701470ULL,
0x00000023c600720cULL, 0x000fc40001f61470ULL, 0x00000023c600720cULL, 0x0c0fe40001741470ULL,
0x00000023c600720cULL, 0x080fe40002fa1470ULL, 0x00000023cc00720cULL, 0x080fe40000f21470ULL,
0x00000023d200720cULL, 0x080fe400037c1470ULL, 0x00000023cc00720cULL, 0x080fe40002781470ULL,
0x000000238800720cULL, 0x000fc40000701070ULL, 0x00000023c400720cULL, 0x0c0fe40001f61070ULL,
0x00000023c400720cULL, 0x0c0fe40001741070ULL, 0x00000023c400720cULL, 0x080fe40002fa1070ULL,
0x00000023ca00720cULL, 0x080fe40000f21070ULL, 0x00000023d000720cULL, 0x080fe400037c1070ULL,
0x00000023ca00720cULL, 0x000fc40002781070ULL, 0x00005410de8f7816ULL, 0x000fe4000000008fULL,
0xff80000042427808ULL, 0x000fe40000000000ULL, 0xff80000041417808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40001000000ULL, 0xff80000061617808ULL, 0x000fe40002800000ULL,
0xff8000004c4c7808ULL, 0x000fc40000800000ULL, 0xff8000004d4d7808ULL, 0x000fe40003000000ULL,
0xff8000004e4e7808ULL, 0x000fe40002000000ULL, 0x00000089d4ff7212ULL, 0x000fe4000780c0ffULL,
0x0000008bceff7212ULL, 0x080fe4000786c0ffULL, 0x0000008bd4ff7212ULL, 0x000fe4000784c0ffULL,
0x0000008fc2ff7212ULL, 0x000fc400078ac0ffULL, 0x0000008fc8ff7212ULL, 0x080fe4000782c0ffULL,
0x0000008fceff7212ULL, 0x080fe400078cc0ffULL, 0x0000008fd4ff7212ULL, 0x000fe4000788c0ffULL,
0x000000238a00720cULL, 0x080fe40002fa1470ULL, 0x00000023c600720cULL, 0x080fe40000f21470ULL,
0x00000023cc00720cULL, 0x000fc40001f61470ULL, 0x00000023cc00720cULL, 0x080fe400037c1470ULL,
0x00000023d200720cULL, 0x0c0fe40000701470ULL, 0x00000023d200720cULL, 0x0c0fe40001741470ULL,
0x00000023d200720cULL, 0x080fe40002781470ULL, 0x000000238800720cULL, 0x080fe40002fa1070ULL,
0x00000023c400720cULL, 0x000fc40000f21070ULL, 0x00000023d000720cULL, 0x080fe40000701070ULL,
0x00000023ca00720cULL, 0x0c0fe40001f61070ULL, 0x00000023ca00720cULL, 0x080fe400037c1070ULL,
0x00000023d000720cULL, 0x0c0fe40001741070ULL, 0x00000023d000720cULL, 0x000fe40002781070ULL,
0xff8000004f4f7808ULL, 0x000fc40000000000ULL, 0xff80000064647808ULL, 0x000fe40001800000ULL,
0xff80000065657808ULL, 0x000fe40001000000ULL, 0xff80000062627808ULL, 0x000fe40002800000ULL,
0xff80000063637808ULL, 0x000fe40000800000ULL, 0xff80000066667808ULL, 0x000fe40003000000ULL,
0xff80000067677808ULL, 0x000fce0002000000ULL, 0x0000000f2c00720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fc60000000000ULL, 0x0000002c0f2c7208ULL, 0x000fc80004000000ULL,
0x000000992c00720bULL, 0x000fc80003f1e000ULL, 0x0000002c990b7208ULL, 0x000fc80004000000ULL,
0x000000300b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b300a7208ULL, 0x000fc80004000000ULL,
0x000000310a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a310b7208ULL, 0x000fc80004000000ULL,
0x000000380b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b380a7208ULL, 0x000fc80004000000ULL,
0x000000390a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a390b7208ULL, 0x000fc80004000000ULL,
0x0000003c0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b3c0a7208ULL, 0x000fc80004000000ULL,
0x0000003d0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a3d0b7208ULL, 0x000fc80004000000ULL,
0x000000440b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b440a7208ULL, 0x000fc80004000000ULL,
0x000000450a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a450b7208ULL, 0x000fc80004000000ULL,
0x000000480b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b480a7208ULL, 0x000fc80004000000ULL,
0x000000490a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a490b7208ULL, 0x000fc80004000000ULL,
0x000000400b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b400a7208ULL, 0x000fc80004000000ULL,
0x000000410a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a410b7208ULL, 0x000fc80004000000ULL,
0x0000004c0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b4c0a7208ULL, 0x000fe40004000000ULL,
0x0000009a2d00720bULL, 0x000fe40003f1e000ULL, 0x0000004d0a00720bULL, 0x000fc80003f3e000ULL,
0x0000000a4d107208ULL, 0x000fe40004800000ULL, 0x0000002d9a0a7208ULL, 0x000fc60004000000ULL,
0x0c401f0010117f89ULL, 0x000ea200000e0000ULL, 0x0000009b0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a9b0b7208ULL, 0x000fc80004000000ULL, 0x000000320b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b320a7208ULL, 0x000fc80004000000ULL, 0x000000330a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a330b7208ULL, 0x000fe40004000000ULL, 0x000000111000720bULL, 0x004fe40003f3e000ULL,
0x0000003a0b00720bULL, 0x000fe40003f1e000ULL, 0x0000001011117208ULL, 0x000fe40004800000ULL,
0x0000000b3a0a7208ULL, 0x000fc60004000000ULL, 0x0c201f00112c7f89ULL, 0x000ea200000e0000ULL,
0x0000003b0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a3b0b7208ULL, 0x000fc80004000000ULL,
0x0000003e0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b3e0a7208ULL, 0x000fc80004000000ULL,
0x0000003f0a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a3f0b7208ULL, 0x000fe40004000000ULL,
0x0000002c1100720bULL, 0x004fe40003f3e000ULL, 0x000000460b00720bULL, 0x000fe40003f1e000ULL,
0x000000112c2c7208ULL, 0x000fe40004800000ULL, 0x0000000b460a7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b2c687820ULL, 0x000fe20000410000ULL, 0x000000470a00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010868ULL, 0x0000000a470b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010868ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010868ULL,
0x0000000f00697308ULL, 0x000fe20000000800ULL, 0x0000004a0b00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b39177823ULL, 0x100fe20000010868ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010868ULL,
0x3fb8aa3b99997823ULL, 0x100fe20000010868ULL, 0x0000000b4a0a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3c197823ULL, 0x100fe20000010868ULL, 0x3fb8aa3b3d207823ULL, 0x100fe20000010868ULL,
0x00000030006b7308ULL, 0x000fe20000000800ULL, 0x0000004b0a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010868ULL, 0x3fb8aa3b45107823ULL, 0x100fe20000010868ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010868ULL, 0x0000000a4b0b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b49217823ULL, 0x100fe20000010868ULL, 0x3fb8aa3b48487823ULL, 0x000fe20000010868ULL,
0x00000031006c7308ULL, 0x000fe20000000800ULL, 0x000000420b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b420a7208ULL, 0x000fc60004000000ULL, 0x00000099006a7308ULL, 0x000fe20000000800ULL,
0x000000430a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a430b7208ULL, 0x000fc60004000000ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x0000004e0b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b4e0a7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b440b7823ULL, 0x000fe40000010868ULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x0000004f0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a4f117208ULL, 0x000fe40004000000ULL, 0x000000132e00720bULL, 0x000fe20003f1e000ULL,
0x0000001900197308ULL, 0x000fe40000000800ULL, 0x0c401f0011167f89ULL, 0x000ee200000e0000ULL,
0x0000002e132e7208ULL, 0x000fc80004000000ULL, 0x000000152e00720bULL, 0x000fe20003f1e000ULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x000000381738723eULL, 0x004fe400000010ffULL,
0x0000002e150f7208ULL, 0x000fc80004000000ULL, 0x000000340f00720bULL, 0x000fe20003f1e000ULL,
0x0000002100217308ULL, 0x000fe60000000800ULL, 0x0000000f340a7208ULL, 0x000fc80004000000ULL,
0x000000350a00720bULL, 0x000fe20003f1e000ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000161100720bULL, 0x008fe40003f3e000ULL, 0x0000000a350f7208ULL, 0x000fe40004000000ULL,
0x00000011162d7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b4c117823ULL, 0x000fe20000010868ULL,
0x000000500f00720bULL, 0x000fe20003f1e000ULL, 0x0000004800167308ULL, 0x000fe40000000800ULL,
0x0c201f002d2a7f89ULL, 0x000ea200000e0000ULL, 0x0000000f500a7208ULL, 0x000fc80004000000ULL,
0x000000510a00720bULL, 0x000fe20003f1e000ULL, 0x0000001000107308ULL, 0x000ee60000000800ULL,
0x0000000a510f7208ULL, 0x000fc80004000000ULL, 0x000000540f00720bULL, 0x000fe20003f1e000ULL,
0x00000040000a7308ULL, 0x000fe60000000800ULL, 0x0000000f54187208ULL, 0x000fc80004000000ULL,
0x000000551800720bULL, 0x000fe20003f1e000ULL, 0x00000041000f7308ULL, 0x000fe20000000800ULL,
0x0000000b1048723eULL, 0x008fe400000010ffULL, 0x0000001855237208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4d187823ULL, 0x000fe20000010868ULL, 0x0000002a2d00720bULL, 0x004fe40003f3e000ULL,
0x000000582300720bULL, 0x000fe20003f1e000ULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x0000002d2a2d7208ULL, 0x000fc40004800000ULL, 0x00000023582a7208ULL, 0x000fe40004000000ULL,
0x00000004070b7810ULL, 0x000fe20007ffe00eULL, 0x3fb8aa3b2d317820ULL, 0x000fe20000410000ULL,
0x000000592a00720bULL, 0x000fe20003f1e000ULL, 0x0000001800187308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010831ULL, 0x0000002a59237208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b9a9a7823ULL, 0x100fe20000010831ULL, 0x0000005c2300720bULL, 0x000fe20003f1e000ULL,
0x0000003200397308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b9b9b7823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010831ULL, 0x000000235c2a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010831ULL, 0x0000005d2a00720bULL, 0x000fe20003f1e000ULL,
0x0000003a00407308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010831ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010831ULL, 0x0000002a5d237208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4b4b7823ULL, 0x000fe20000010831ULL, 0x0000001e2f00720bULL, 0x000fc40003f1e000ULL,
0x000000602300720bULL, 0x000fe20003f3e000ULL, 0x0000003e00447308ULL, 0x000fe20000000800ULL,
0x0000002f1e2a7208ULL, 0x000fe40004000000ULL, 0x00000023602e7208ULL, 0x000fe40004800000ULL,
0x0000001f2a00720bULL, 0x000fe40003f1e000ULL, 0x000000612e00720bULL, 0x000fe20003f3e000ULL,
0x0000009a009a7308ULL, 0x000fe20000000800ULL, 0x0000002a1f237208ULL, 0x000fc40004000000ULL,
0x0000002e61257208ULL, 0x000fe40004800000ULL, 0x000000362300720bULL, 0x000fe40003f1e000ULL,
0x000000642500720bULL, 0x000fe20003f3e000ULL, 0x0000009b009b7308ULL, 0x000fe20000000800ULL,
0x00000023362a7208ULL, 0x000fe40004000000ULL, 0x00000025642e7208ULL, 0x000fe40004800000ULL,
0x000000372a00720bULL, 0x000fc40003f1e000ULL, 0x000000652e00720bULL, 0x000fe20003f3e000ULL,
0x00000033003c7308ULL, 0x000ea20000000800ULL, 0x0000002a37237208ULL, 0x000fe40004000000ULL,
0x0000002e652e7208ULL, 0x000fe40004800000ULL, 0x000000522300720bULL, 0x000fc60003f1e000ULL,
0x0c401f002e257f89ULL, 0x000ee200000e0000ULL, 0x00000023522a7208ULL, 0x000fe20004000000ULL,
0x0000003b003b7308ULL, 0x000fe60000000800ULL, 0x000000532a00720bULL, 0x000fe40003f1e000ULL,
0x000000393c33723eULL, 0x004fe400000010ffULL, 0x0000002a53237208ULL, 0x000fe20004000000ULL,
0x0000003f00457308ULL, 0x000fe60000000800ULL, 0x000000562300720bULL, 0x000fc80003f1e000ULL,
0x00000023562a7208ULL, 0x000fe20004000000ULL, 0x0000004600497308ULL, 0x000fe60000000800ULL,
0x000000572a00720bULL, 0x000fe40003f1e000ULL, 0x000000252e00720bULL, 0x008fe40003f3e000ULL,
0x0000002a57237208ULL, 0x000fe20004000000ULL, 0x00000047004c7308ULL, 0x000ea20000000800ULL,
0x0000002e252b7208ULL, 0x000fc40004800000ULL, 0x0000005a2300720bULL, 0x000fc60003f1e000ULL,
0x0c201f002b307f89ULL, 0x000ee200000e0000ULL, 0x000000235a2a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b42237823ULL, 0x000fe20000010831ULL, 0x0000004a004d7308ULL, 0x0009e40000000800ULL,
0x0000005b2a00720bULL, 0x000fc80003f1e000ULL, 0x0000002a5b257208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b432a7823ULL, 0x100fe20000010831ULL, 0x0000004b00687308ULL, 0x000f620000000800ULL,
0x00000016214a723eULL, 0x010fe400000010ffULL, 0x0000005e2500720bULL, 0x000fe40003f1e000ULL,
0x000000494c49723eULL, 0x004fe400000010ffULL, 0x000000255e2e7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4e257823ULL, 0x100fe20000010831ULL, 0x3fb8aa3b4f317823ULL, 0x000fe20000010831ULL,
0x000000070b217812ULL, 0x000fe200078ec0ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x0000005f2e00720bULL, 0x000fc40003f1e000ULL, 0x000000302b00720bULL, 0x008fe40003f3e000ULL,
0x0000002e5f277208ULL, 0x000fe40004000000ULL, 0x0000002b302e7208ULL, 0x000fe20004800000ULL,
0x00000031006e7308ULL, 0x0005e20000000800ULL, 0x000000622700720bULL, 0x000fe40003f1e000ULL,
0x0000004d684b723eULL, 0x022fe200000010ffULL, 0x3fb8aa3b2e327820ULL, 0x000fe20000410000ULL,
0x0000002762307208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b13277823ULL, 0x100fe20000010832ULL,
0x000000633000720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010832ULL,
0x0000003063137208ULL, 0x000fe20004000000ULL, 0x00000015003a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b51517823ULL, 0x100fe20000010832ULL,
0x000000661300720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b55557823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010832ULL,
0x0000001366307208ULL, 0x000fe20004000000ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x3fb8aa3b59597823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b5c5c7823ULL, 0x100fe20000010832ULL,
0x000000673000720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b5d5d7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b60607823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b61617823ULL, 0x100fe20000010832ULL,
0x0000003067307208ULL, 0x000fe20004000000ULL, 0x00000035003e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b64647823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b65327823ULL, 0x000fe20000010832ULL,
0x0000009a9b31723eULL, 0x004fe200000010ffULL, 0x0c401f0030137f89ULL, 0x000ea800000e0000ULL,
0x00000034002b7308ULL, 0x0003f00000000800ULL, 0x0000005000507308ULL, 0x000fe20000000800ULL,
0x000000273a34723eULL, 0x002fc400000010ffULL, 0xfffffff8ff277812ULL, 0x000fe400078ee20cULL,
0x00000019203a723eULL, 0x000fc600000010ffULL, 0x0000000827397824ULL, 0x000fe200078e00ffULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x000000133000720bULL, 0x004fc80003f1e000ULL,
0x0000003013137208ULL, 0x000fc60004000000ULL, 0x0000005400547308ULL, 0x000fe40000000800ULL,
0x0c201f0013307f89ULL, 0x000e6c00000e0000ULL, 0x0000005500557308ULL, 0x000ff00000000800ULL,
0x0000005c004e7308ULL, 0x0005f00000000800ULL, 0x0000005800587308ULL, 0x000fe20000000800ULL,
0x00000010275c7836ULL, 0x004fe20000000000ULL, 0x000000301300720bULL, 0x002fc80003f1e000ULL,
0x00000013302f7208ULL, 0x000fe40004000000ULL, 0x0000005900597308ULL, 0x000e620000000800ULL,
0x000000696a30723eULL, 0x000fe200000010ffULL, 0x000000085c697824ULL, 0x040fe200078e00ffULL,
0x00000018276a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b2f157820ULL, 0x000fe20000410000ULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0x0000000307ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010815ULL,
0x0000003200137308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b52527823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b5a5a7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b5b5b7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b5e5e7823ULL, 0x100fe20000010815ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000006b6c32723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b5f5f7823ULL, 0x100fe20000010815ULL, 0x000000036a6b7819ULL, 0x000fe200000006ffULL,
0x3fb8aa3b62627823ULL, 0x100fe20000010815ULL, 0x00000058594c723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b63637823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b66667823ULL, 0x100fe20000010815ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b67157823ULL, 0x000fe20000010815ULL,
0x000000036a6a7819ULL, 0x000fc400000006ffULL, 0xfffffff85c197812ULL, 0x000fe200078ee221ULL,
0x000000ffff5c7224ULL, 0x000fc600078e0048ULL, 0x00000036003d7308ULL, 0x0005e20000000800ULL,
0x0000001e1f35723eULL, 0x002fce00000010ffULL, 0x0000003700427308ULL, 0x000e620000000800ULL,
0x000000030e1e7812ULL, 0x000fe400078ec0ffULL, 0x0000002b3e36723eULL, 0x004fe200000010ffULL,
0x00000008272b7836ULL, 0x000fe40000000000ULL, 0x000000011e0c7824ULL, 0x000fe200078e0207ULL,
0x00000004001e7c02ULL, 0x000fe20008000f00ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x000000082b657824ULL, 0x040fe400078e00ffULL, 0x3f8000001e1e783eULL, 0x000fe200000010ffULL,
0x000000082b107824ULL, 0x000fe200078e00ffULL, 0x000000070c0c7812ULL, 0x000fc400078ec0ffULL,
0x0000003d4237723eULL, 0x002fe200000010ffULL, 0x000000ffff1f7224ULL, 0x100fe200078e001eULL,
0x0000005300537308ULL, 0x000e620000000800ULL, 0x000000ffff427224ULL, 0x100fe200078e001eULL,
0xfffffff865657812ULL, 0x000fe200078ee20cULL, 0x000000ffff437224ULL, 0x100fe200078e001eULL,
0xfffffff869697812ULL, 0x000fe200078ee20cULL, 0x000000ffff167224ULL, 0x100fe200078e001eULL,
0x0000001e303c723cULL, 0x000fe200000418ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee20cULL,
0x0000005600567308ULL, 0x000fe80000000800ULL, 0x0000001e00177202ULL, 0x000fe20000000f00ULL,
0x000000ffff587224ULL, 0x000fc400078e001eULL, 0x000000ffff597224ULL, 0x100fe200078e001eULL,
0xfffffff8391f7812ULL, 0x000fe400078ee20cULL, 0x000000403b39723eULL, 0x000fe200000010ffULL,
0x0000005700577308ULL, 0x000ea20000000800ULL, 0x000000423440723cULL, 0x000fe200000418ffULL,
0x00000044453b723eULL, 0x000fe200000010ffULL, 0x000000ffff447224ULL, 0x000fe200078e001eULL,
0x0000001e00457202ULL, 0x000fc80000000f00ULL, 0x0000005d005d7308ULL, 0x000ee60000000800ULL,
0x000000443844723cULL, 0x000fea000004183cULL, 0x0000005a005a7308ULL, 0x000fe40000000800ULL,
0x00000050513c723eULL, 0x000fe200000010ffULL, 0x000000ffff507224ULL, 0x100fe200078e001eULL,
0x00000054553e723eULL, 0x000fe200000010ffULL, 0x000000ffff517224ULL, 0x000fe200078e001eULL,
0x00000052533d723eULL, 0x002fc400000010ffULL, 0x0000005b005b7308ULL, 0x000e620000000800ULL,
0x00000056573f723eULL, 0x004fe400000010ffULL, 0x0000004e5d4e723eULL, 0x008fe200000010ffULL,
0x000000ffff5d7224ULL, 0x000fe200078e004aULL, 0x000000111852723eULL, 0x000fe400000010ffULL,
0x0000001e00117202ULL, 0x000fe20000000f00ULL, 0x000000503c40723cULL, 0x000fe20000041840ULL,
0x0000005e004f7308ULL, 0x000fea0000000800ULL, 0x000000164844723cULL, 0x000fe20000041844ULL,
0x0000005a5b4d723eULL, 0x002fe200000010ffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0038ULL,
0x0000005f000c7308ULL, 0x0002a20000000800ULL, 0x0000000a0f50723eULL, 0x000fe200000010ffULL,
0x00001000240a7824ULL, 0x000fe200078e021dULL, 0x0000001e000f7202ULL, 0x000fe20000000f00ULL,
0x000000ffff387224ULL, 0x000fe200078e0049ULL, 0xfffffff810177812ULL, 0x000fe200078ee221ULL,
0x000000ffff107224ULL, 0x000fe200078e001eULL, 0x0000003a005b7202ULL, 0x000fe20000000f00ULL,
0x0000002a002a7308ULL, 0x000ee20000000800ULL, 0x000120000a0a7836ULL, 0x000fe20000000000ULL,
0x00000052005f7202ULL, 0x002fe20000000f00ULL, 0x000000ffff5e7224ULL, 0x000fe200078e0050ULL,
0x0000003600497202ULL, 0x000fe20000000f00ULL, 0x000000101f1f7824ULL, 0x100fe200078e020aULL,
0x0000000a17177211ULL, 0x000fe200078e20ffULL, 0x0000001065657824ULL, 0x000fe200078e020aULL,
0x0000004f0c4f723eULL, 0x004fe200000010ffULL, 0x00000008270c7824ULL, 0x000fe200078e00ffULL,
0x0000002500257308ULL, 0x000e620000000800ULL, 0x000000ffff487224ULL, 0x000fe200078e0034ULL,
0x0000003d00367202ULL, 0x000fe20000000f00ULL, 0x0000001069697824ULL, 0x000fe200078e020aULL,
0xfffffff80c0b7812ULL, 0x000fe200078ee221ULL, 0x000000584c40723cULL, 0x000fe20000041840ULL,
0x000000232a51723eULL, 0x008fe200000010ffULL, 0x000000ffff4a7224ULL, 0x000fe200078e003cULL,
0x0000006200557308ULL, 0x000fe20000000800ULL, 0x000000100b0b7824ULL, 0x000fe200078e020aULL,
0xfffffff86a217812ULL, 0x000fe200078ee221ULL, 0x000000ffff347224ULL, 0x000fe200078e0035ULL,
0x00000051003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff587224ULL, 0x000fe200078e0030ULL,
0x0000004f003d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fe200078e0032ULL,
0x00000063000e7308ULL, 0x000ea20000000800ULL, 0x000000256e53723eULL, 0x002fe200000010ffULL,
0x000000ffff307224ULL, 0x000fc400078e0031ULL, 0x000000ffff317224ULL, 0x000fe200078e0033ULL,
0x0000003b00337202ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe200078e0039ULL,
0x000000581f007844ULL, 0x000fe20000000200ULL, 0x0000006000607308ULL, 0x000fe20000000800ULL,
0x000000105044723cULL, 0x000fe20000041844ULL, 0x000000ffff397224ULL, 0x000fe200078e004bULL,
0x0000005c0b007844ULL, 0x0003e80000000200ULL, 0x000000ffff3b7224ULL, 0x000fc400078e0053ULL,
0x000000ffff4b7224ULL, 0x000fe200078e003eULL, 0x000000550e55723eULL, 0x004fe200000010ffULL,
0x0000006100617308ULL, 0x000ea20000000800ULL, 0x000000ffff0e7224ULL, 0x000fe200078e001eULL,
0x0000004c00507202ULL, 0x000fe20000000f00ULL, 0x0000001019197824ULL, 0x000fe200078e020aULL,
0x0000003065007844ULL, 0x0007e20000000200ULL, 0x000000ffff517224ULL, 0x000fe400078e004eULL,
0x000000ffff357224ULL, 0x000fe200078e0037ULL, 0x0000006400647308ULL, 0x000f220000000800ULL,
0x000000106b6b7824ULL, 0x000fe200078e020aULL, 0x0000000a210a7211ULL, 0x000fe200078e20ffULL,
0x000000ffff377224ULL, 0x000fe200078e003fULL, 0x0000003817007844ULL, 0x0007e20000000200ULL,
0x000000ffff3c7224ULL, 0x000fe200078e004dULL, 0x00000001000b7802ULL, 0x002fe20000000f00ULL,
0x000000ffff3e7224ULL, 0x000fe200078e0055ULL, 0x0000006600577308ULL, 0x000fe20000000800ULL,
0x000000606154723eULL, 0x004fe200000010ffULL, 0x0000004869007844ULL, 0x0007e20000000200ULL,
0x0000004600457202ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fc400078e00afULL,
0x000000ffff527224ULL, 0x000fe200078e0054ULL, 0x000000641356723eULL, 0x010fe200000010ffULL,
0x00000015000c7308ULL, 0x000e660000000800ULL, 0x0000005600537202ULL, 0x000fca0000000f00ULL,
0x0000005019007844ULL, 0x0007e80000000200ULL, 0x000000346b007844ULL, 0x0007e20000000200ULL,
0x000000570c57723eULL, 0x002fca00000010ffULL, 0x000000ffff3f7224ULL, 0x000fe400078e0057ULL,
0x0000000e5440723cULL, 0x000fe60000041840ULL, 0x0000003c0a007844ULL, 0x0007e80000000200ULL,
0x01e0002c0d008388ULL, 0x0007de0000000c00ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000ffff467224ULL, 0x000fe400078e0040ULL, 0x000000ffff477224ULL, 0x000fca00078e0042ULL,
0x01e200440d008388ULL, 0x0007e20000000c00ULL, 0x0000001aaf00720cULL, 0x000fe20003f06070ULL,
0x01e6080b12ff79a7ULL, 0x0007e2000850003fULL, 0x01e6100b12ff79a7ULL, 0x0007e2000850003fULL,
0x01e6180b12ff79a7ULL, 0x0007e2000850003fULL, 0x01e6200b12ff79a7ULL, 0x0007f2000850003fULL,
0xffffff7800448947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000025007836ULL, 0x000fe20000000000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000002500008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff25ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000025037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe400078efcffULL, 0x0000000300008202ULL, 0x000fe20000000f00ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000002500007308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffe6c046c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x000000000000044fULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000005d0ULL, 0x00000000000001f8ULL,
0x0000001300000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000007c8ULL, 0x00000000000000d0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000898ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008ecULL, 0x0000000000000530ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e20ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000e20ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e68ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000019300ULL,
0x0000001300000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a180ULL, 0x0000000000000038ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a1c0ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000001a1c0ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x000000000001a7b8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a7b8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e68ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000019300ULL, 0x0000000000019300ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x000000000001a180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x000000000001a1c0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 108808;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
