/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001bb40ULL, 0x000000000001b7c0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL,
0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL,
0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL,
0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL,
0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL,
0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b002200000377ULL, 0x0000000000019e90ULL, 0x0000000000000180ULL,
0x000b0022000003aaULL, 0x000000000001a010ULL, 0x0000000000000040ULL, 0x000b0022000003d5ULL,
0x000000000001a050ULL, 0x0000000000000050ULL, 0x000b0022000003ffULL, 0x000000000001a0a0ULL,
0x0000000000000160ULL, 0x000a00030000046dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000048dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001a200ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00019e9000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x0066240400288080ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL,
0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00019e9000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080860900ULL, 0x0900000010042880ULL,
0x2880808628808088ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8908288080880828ULL,
0x2880809f08288080ULL, 0x80d008288080a008ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080d09200ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL, 0x0001a01000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x8908288080880828ULL, 0x288080a008288080ULL, 0x8280162880809f08ULL, 0x0000000003102880ULL,
0x80809f9200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL, 0x0000018800000000ULL,
0x0001a05000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL, 0x80a02880809f0900ULL,
0x0000000000002880ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8908288080880828ULL,
0x2880809f08288080ULL, 0x828016288080a008ULL, 0x0000000003102880ULL, 0x8080a09200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000022000000000ULL, 0x0001a0a000000000ULL,
0x0000016000000000ULL, 0x0000000000000000ULL, 0x0000001700082f04ULL, 0x00082304000000dcULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL,
0x0000000000000011ULL, 0x0000001000082304ULL, 0x0008120400000000ULL, 0x0000000000000010ULL,
0x0000001000081104ULL, 0x0008230400000000ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0068016000000014ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000e6000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000031001cc2804ULL,
0x0000055000000380ULL, 0x000031a000002060ULL, 0x0000337000003260ULL, 0x00003650000034e0ULL,
0x000039c0000037b0ULL, 0x00003a1000003a00ULL, 0x000043a000003a40ULL, 0x00005390000052f0ULL,
0x00005620000054b0ULL, 0x000058f000005790ULL, 0x00005b3000005af0ULL, 0x00005b7000005b40ULL,
0x0000722000006210ULL, 0x000073d0000072b0ULL, 0x000076b000007540ULL, 0x00007a1000007810ULL,
0x00007a6000007a50ULL, 0x000080a000007a90ULL, 0x00009130000090a0ULL, 0x000093c000009250ULL,
0x0000969000009530ULL, 0x000098d000009890ULL, 0x00009910000098e0ULL, 0x0000a0700000a050ULL,
0x0000a0900000a080ULL, 0x0000ce500000ce10ULL, 0x0000cf400000cef0ULL, 0x0000db300000db00ULL,
0x0000dc200000db60ULL, 0x00017b0000017ac0ULL, 0x00017b2000017b10ULL, 0x00017b9000017b70ULL,
0x00017bc000017bb0ULL, 0x0001905000019000ULL, 0x000190e0000190a0ULL, 0x0001916000019120ULL,
0x00019200000191b0ULL, 0x000192a000019250ULL, 0x00019340000192f0ULL, 0x000193d000019390ULL,
0x0001945000019410ULL, 0x000194f0000194a0ULL, 0x0001959000019540ULL, 0x00019630000195e0ULL,
0x000196c000019680ULL, 0x0001974000019700ULL, 0x000197e000019790ULL, 0x0001988000019830ULL,
0x00019920000198d0ULL, 0x000199b000019970ULL, 0x00019a30000199f0ULL, 0x00019ad000019a80ULL,
0x00019b7000019b20ULL, 0x00019c3000019bd0ULL, 0x00019cf000019c90ULL, 0x00019db000019d50ULL,
0x00019e7000019e10ULL, 0x0000042002003904ULL, 0x00016600000000ffULL, 0x00000430003f0100ULL,
0x000166080000000dULL, 0x000004d0003f0120ULL, 0x000166880000000dULL, 0x00000e80003f0120ULL,
0x00016600000000ffULL, 0x00001080003f0107ULL, 0x0001668c00000080ULL, 0x00001130003f0102ULL,
0x0001668800000080ULL, 0x00002ea0003f0101ULL, 0x0001660800000008ULL, 0x00002ec0003f0101ULL,
0x0001660c00000008ULL, 0x00003090003f0105ULL, 0x0001660c00000008ULL, 0x00004340003f0105ULL,
0x000166880000001cULL, 0x00005030003f0101ULL, 0x000166280000001bULL, 0x00005050003f0101ULL,
0x0001662c0000001bULL, 0x00005220003f0105ULL, 0x0001662c0000001bULL, 0x000061c0003f0105ULL,
0x000000000000001eULL, 0x00006f60003f0101ULL, 0x000166480000001cULL, 0x00006f80003f0101ULL,
0x0001664c0000001cULL, 0x00007150003f0105ULL, 0x0001664c0000001cULL, 0x00008080003f0105ULL,
0x000000000000001fULL, 0x00008df0003f0101ULL, 0x0001666800000066ULL, 0x00008e10003f0101ULL,
0x0001666c00000066ULL, 0x00008fe0003f0105ULL, 0x0001666c00000066ULL, 0x00009ed0003f0105ULL,
0x0000000000000002ULL, 0x0000faf0003f0101ULL, 0x00016600000000ffULL, 0x000106f0003f0101ULL,
0x00016604000000ffULL, 0x00010900003f0105ULL, 0x00016604000000ffULL, 0x00014db0003f0105ULL,
0x000000000000009fULL, 0x00014e30003f0101ULL, 0x000000040000009fULL, 0x00015000003f0105ULL,
0x000000040000009fULL, 0x00018e60003f0105ULL, 0x00016608000000a0ULL, 0x00018ec0003f0101ULL,
0x00016610000000a0ULL, 0x00018f20003f0101ULL, 0x00016618000000a0ULL, 0x00018f90003f0101ULL,
0x00016620000000a0ULL, 0x00033803003f0101ULL, 0x0000e9a000301c04ULL, 0x0000ec600000e9d0ULL,
0x0000f0400000ee50ULL, 0x0000f4200000f230ULL, 0x0000f8100000f610ULL, 0x000109600000f9c0ULL,
0x0000040100018fd0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000294ULL, 0x0000001700000002ULL,
0x00000000000001fcULL, 0x0000001700000002ULL, 0x0000000000000174ULL, 0x0000001700000002ULL,
0x00000000000000d4ULL, 0x0000001700000002ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x000000000000026cULL, 0x0000001700000002ULL, 0x00000000000001d4ULL, 0x0000001700000002ULL,
0x0000000000000151ULL, 0x0000001700000002ULL, 0x00000000000000adULL, 0x0000001700000002ULL,
0x0000000000016700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000a47919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff030424ULL, 0x000fe200078e00ffULL,
0x00000001a4040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0003ULL,
0x00005c00a4020625ULL, 0x000fe200078e0003ULL, 0x00000006049b0981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000009c7919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a0000117a02ULL, 0x000fc40000000f00ULL, 0x00000000000b7919ULL, 0x000ee60000002300ULL,
0x0000590011117a24ULL, 0x000fe200078e02ffULL, 0x00000000009a7919ULL, 0x000ee20000002100ULL,
0x0000000000007308ULL, 0x010f220000001000ULL, 0x00000004ff957e24ULL, 0x002fe2000f8e00ffULL,
0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL, 0x0000000600077305ULL, 0x000324000021f000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x010fc800078e0a07ULL,
0x0000590009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fe400078e0006ULL,
0x0000000000067919ULL, 0x000e680000002200ULL, 0x0000040007097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x008fc800078e0a09ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x8000590000001a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900007306ULL, 0x000ee20000209000ULL, 0x000000ff0900720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x008ee40000001000ULL, 0x0ffffffe00047810ULL, 0x008fcc0007ffe0ffULL,
0x0000000400057305ULL, 0x000724000021f000ULL, 0x000000ffff047224ULL, 0x008fe400078e00ffULL,
0x0000000509037224ULL, 0x010fc800078e02ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a03ULL,
0x0000000305057227ULL, 0x000fc800078e0004ULL, 0x000001000b037a24ULL, 0x002fe400078e0206ULL,
0x0000009c059d7227ULL, 0x000fe200078e00ffULL, 0x00001fff0b0b7589ULL, 0x000fe600000e0000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a9dULL, 0x00000000030d7a24ULL, 0x100fe200078e029aULL,
0x00000005ff9a7819ULL, 0x000fe2000001169aULL, 0x0000000009007224ULL, 0x000fc600078e029cULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x000000090000720cULL, 0x000fe20003f66070ULL,
0x00001fff9a9a7589ULL, 0x000e6200000e0000ULL, 0x0000000f0d00780cULL, 0x000fd20003f44070ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x0000000100003824ULL, 0x000fe200078e0a09ULL,
0x000000019d9d3810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff059424ULL, 0x000fe200078e00ffULL,
0x000000030d00780cULL, 0x000fe20003f64070ULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x000000090000720cULL, 0x000fe20003f86070ULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x01660004ff009388ULL, 0x000fe80000000a00ULL, 0x016608060d00a388ULL, 0x000fea0000008a00ULL,
0x3fffff60ff08b424ULL, 0x000fc400078e00ffULL, 0x000000019d9d4810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff9dd212ULL, 0x000fe400078e33ffULL, 0x0000007f0d00780cULL, 0x000fc60003f84070ULL,
0x000000ffff007224ULL, 0x000fc800078e0a9dULL, 0x00000000099c7224ULL, 0x000fe400078e029cULL,
0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL, 0x000000209c9c7824ULL, 0x000fe400078e00ffULL,
0xff317217ff0ac424ULL, 0x000fe200078e00ffULL, 0x016688080d00b388ULL, 0x000fe80000008a00ULL,
0x0164000a0d00c388ULL, 0x000fe20000004800ULL, 0x000000019b9b0824ULL, 0x004fc400078e0a02ULL,
0x00005800ff9b8624ULL, 0x000fe400078e00ffULL, 0x00005800a4028a24ULL, 0x000fe400078e02ffULL,
0x00005a009b037a24ULL, 0x000fe400078e02ffULL, 0x0000001102837224ULL, 0x000fe400078e02ffULL,
0x0000000103007824ULL, 0x040fe200078e0a9cULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000009c0300720cULL, 0x000fe20003f26070ULL, 0x00005a009d127a24ULL, 0x000fe200078e0283ULL,
0x0000002000007817ULL, 0x000fc80003800000ULL, 0x000000ff00827207ULL, 0x000fe20000800000ULL,
0x000000040b007824ULL, 0x002fc600078e029aULL, 0x000000208200780cULL, 0x000fe20003f05270ULL,
0x0000000400037824ULL, 0x000fd800078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x0000000000007919ULL, 0x000eae0000000000ULL,
0x0000000800087308ULL, 0x002e620000001000ULL, 0x00000004ff067819ULL, 0x004fc80000011600ULL,
0x00000002060a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103077824ULL, 0x000fe200078e0206ULL,
0x0ffffffe08047810ULL, 0x002fc60007ffe0ffULL, 0x00000001030d7824ULL, 0x000fe200078e020aULL,
0x0000000400057305ULL, 0x0002a6000021f000ULL, 0x000000019c0f7824ULL, 0x000fe400078e020dULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x004fc800078e0a05ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000905087227ULL, 0x000fc800078e0004ULL,
0x000000019c057824ULL, 0x000fe400078e0207ULL, 0x0000000f080c7227ULL, 0x000fc800078e00ffULL,
0x0000000508047227ULL, 0x000fc800078e00ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x000000ffff107224ULL, 0x000fe400078e0a0cULL, 0x00005a0008087a24ULL, 0x000fe400078e0205ULL,
0x00005a0010097a24ULL, 0x000fc600078e020fULL, 0x00005a0008007a0cULL, 0x000fe40003f06070ULL,
0x00005a0009007a0cULL, 0x000fd60003f46070ULL, 0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe40003f26070ULL,
0x00005a0009007a0cULL, 0x000fe40003f66070ULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff097a12ULL, 0x000fc600078e33ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c3810ULL, 0x000fe40007ffe0ffULL, 0x0000000409087207ULL, 0x040fe40004000000ULL,
0x0000000c09097207ULL, 0x000fe40004000000ULL, 0x0000000382047217ULL, 0x000fe20007800000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x000000ffff107224ULL, 0x000fc400078e0a09ULL,
0x00005a000c057a24ULL, 0x000fe400078e0205ULL, 0x00005a00100f7a24ULL, 0x000fe400078e020fULL,
0x0000000104047824ULL, 0x000fe400078e0a03ULL, 0x0000000112057824ULL, 0x040fe400078e0205ULL,
0x00000001120c7824ULL, 0x000fe200078e020fULL, 0x000000040600720cULL, 0x080fe20003f06070ULL,
0x0000001108057224ULL, 0x000fe200078e0205ULL, 0x000000040a00720cULL, 0x000fe20003f26070ULL,
0x0000001000067824ULL, 0x000fc400078e00ffULL, 0x0000001109097224ULL, 0x000fe400078e020cULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f006037812ULL, 0x000fc600078ec0ffULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x0000000304047212ULL, 0x000fc600078efcffULL,
0x00000001070a7824ULL, 0x140fe200078e0200ULL, 0x0000000308037212ULL, 0x000fe200078efcffULL,
0x00000010070f7824ULL, 0x000fe200078e00ffULL, 0x0000600004047a10ULL, 0x000fe20007f5e0ffULL,
0x000000010d077824ULL, 0x000fe200078e0200ULL, 0x0000600003087a10ULL, 0x000fe20007f7e0ffULL,
0x000000100d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff00f0a7812ULL, 0x000fe400078ee20aULL,
0x0000610005057a10ULL, 0x000fe400017fe4ffULL, 0xfffffff00c077812ULL, 0x000fe200078ee207ULL,
0x000000100a037824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc40001ffe4ffULL,
0x0000000407077819ULL, 0x000fe400000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e8000c101c46ULL, 0x0000000008077faeULL, 0x0003e2000c901c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fcc00078e00ffULL,
0x0000000600067308ULL, 0x002e620000001000ULL, 0x0000000300037211ULL, 0x004fc800078fe0ffULL,
0x00000002030d7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe06087810ULL, 0x002fc60007ffe0ffULL,
0x000000100d0c7824ULL, 0x000fe200078e00ffULL, 0x0000000800057305ULL, 0x000e64000021f000ULL,
0x000000ffff077224ULL, 0x002fc800078e0a05ULL, 0x00005a0007077a24ULL, 0x000fc800078e02ffULL,
0x0000000705097227ULL, 0x000fc800078e0004ULL, 0x000000019c047824ULL, 0x040fe400078e0203ULL,
0x000000019c077824ULL, 0x000fe400078e020dULL, 0x0000000409057227ULL, 0x000fc800078e00ffULL,
0x0000000709087227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a05ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0a08ULL, 0x00005a0009067a24ULL, 0x000fe400078e0204ULL,
0x00005a000a097a24ULL, 0x000fe400078e0207ULL, 0x00000010030a7824ULL, 0x000fe200078e00ffULL,
0x00005a0006007a0cULL, 0x000fe40003f06070ULL, 0x00005a0009007a0cULL, 0x000fd60003f46070ULL,
0x80005a0006060a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0009092a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fe40003f26070ULL, 0x00005a0009007a0cULL, 0x000fe40003f66070ULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000000108082810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff067a12ULL, 0x000fc600078e33ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x0000000108083810ULL, 0x000fe40007ffe0ffULL,
0x0000000506057207ULL, 0x040fe40004000000ULL, 0x0000000806087207ULL, 0x000fc60004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a05ULL, 0x000000ffff067224ULL, 0x000fe400078e0a08ULL,
0x00005a0009047a24ULL, 0x000fe400078e0204ULL, 0x00005a0006077a24ULL, 0x000fe400078e0207ULL,
0x0000000112047824ULL, 0x040fe400078e0204ULL, 0x0000000112077824ULL, 0x000fc400078e0207ULL,
0x0000001000067824ULL, 0x000fe400078e00ffULL, 0x0000001105047224ULL, 0x080fe400078e0204ULL,
0x0000001108087224ULL, 0x000fe200078e0207ULL, 0x000000f0060f7812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000f04047212ULL, 0x000fc600078efcffULL, 0x0000000103077824ULL, 0x100fe200078e0200ULL,
0x0000000f08087212ULL, 0x000fe200078efcffULL, 0x000000010d037824ULL, 0x000fe200078e0200ULL,
0x0000600004047a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff00a077812ULL, 0x000fe400078ee207ULL,
0xfffffff00c037812ULL, 0x000fe400078ee203ULL, 0x0000600008087a10ULL, 0x000fe20007f3e0ffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x0000610005057a10ULL, 0x000fe200007fe4ffULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c46ULL,
0x0000000008037faeULL, 0x0003e4000b901c46ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fe200038e0000ULL, 0x00000004ff977424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000300047300ULL, 0x000e7000000e0000ULL,
0x0000000300077309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x00006800a4047625ULL, 0x000fc800078e0097ULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01660407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01660000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000604947981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f94237810ULL, 0x044fe40007ffe0ffULL,
0x000000ff94227810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff237819ULL, 0x000fe40000011623ULL,
0x00000008ff227819ULL, 0x000fca0000011622ULL, 0x0000ea1000008947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe2000001169aULL, 0x00000003ff057424ULL, 0x000fe200078e00ffULL,
0x000000039a807819ULL, 0x000fe200000006ffULL, 0xffffffffff197424ULL, 0x000fe200078e00ffULL,
0x01ffffff02027812ULL, 0x000fca00078ec0ffULL, 0x00000002951a7824ULL, 0x000fca00078e0202ULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x00000002a4028824ULL, 0x000fe400078e00ffULL,
0x00006a00ff038624ULL, 0x000fc800078e00ffULL, 0x00006a0002038624ULL, 0x000fc800078e0203ULL,
0x000000011a038824ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01668c0580ff738cULL, 0x0005e20000000000ULL, 0x0000660003028625ULL, 0x000fe200078e0097ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000602198981ULL, 0x000ee2000c1e1900ULL,
0x0000000195057810ULL, 0x004fe20007ffe0ffULL, 0x000000809d167824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001169aULL, 0x0166880080ff7f8cULL, 0x0005e2000c80043fULL,
0x000000220500720cULL, 0x000fe20003f06070ULL, 0x00000100ff057424ULL, 0x000fe200078e00ffULL,
0x000000019a157812ULL, 0x000fe200078ec0ffULL, 0x0000002018177824ULL, 0x000fc800078e00ffULL,
0x0000010095077824ULL, 0x002fca00078e0217ULL, 0x00000060162a7812ULL, 0x000fe200078ef807ULL,
0x0000590019047a24ULL, 0x008fc800078e02ffULL, 0x0000008004047824ULL, 0x000fc800078e00ffULL,
0x0000640004027625ULL, 0x000fe200078e0005ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff127819ULL, 0x104fe40000011600ULL, 0x0000000794047217ULL, 0x000fe40007800000ULL,
0x0000000c120b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000412057810ULL, 0x000fe20007ffe0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a07ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x000000010b097824ULL, 0x140fe200078e0200ULL, 0x00000008120a7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x0000002004137817ULL, 0x000fe20003800000ULL,
0x0000000105077824ULL, 0x040fe200078e0200ULL, 0x0000001012107810ULL, 0x000fe20007ffe0ffULL,
0x00000008050c7824ULL, 0x040fe200078e00ffULL, 0xfffffff80e217812ULL, 0x000fe200078ee209ULL,
0x000000012a097824ULL, 0x000fe200078e0205ULL, 0x000000130500720cULL, 0x080fe20003f86070ULL,
0x0000008015047824ULL, 0x000fe200078e0206ULL, 0xfffffff80c1d7812ULL, 0x000fe200078ee207ULL,
0x000000012a077824ULL, 0x000fe200078e0212ULL, 0x00000014121c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x000000130a00720cULL, 0x0c0fe20003f66070ULL,
0x000000010a087824ULL, 0x000fe200078e0200ULL, 0x000000031c1e7819ULL, 0x000fe200000006ffULL,
0x000000080a1f7824ULL, 0x000fe200078e00ffULL, 0x000000130b00720cULL, 0x080fe20003f46070ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000131200720cULL, 0x000fc40003fa6070ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x00000006020c7210ULL, 0x000fc60007f1e0ffULL, 0x00000001100d7824ULL, 0x100fe200078e0200ULL,
0x00000008020e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000810147824ULL, 0x000fe400078e00ffULL,
0x000000011c0f7824ULL, 0x000fc600078e0200ULL, 0xfffffff814257812ULL, 0x000fe200078ee20dULL,
0x00000001030d7824ULL, 0x040fe200000e0607ULL, 0xfffffff81e277812ULL, 0x000fe200078ee20fULL,
0x000000012a077824ULL, 0x000fe200078e020aULL, 0x0000001c121e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001030f7824ULL, 0x000fe200008e0609ULL, 0x000000131000720cULL, 0x000fe20003f26070ULL,
0x000000012a097824ULL, 0x000fe400078e020bULL, 0x0000010007067825ULL, 0x000fc800078e0004ULL,
0x00000001120a7824ULL, 0x000fe400078e0200ULL, 0x0000010009087825ULL, 0x000fc600078e0004ULL,
0x000000070a1b7812ULL, 0x000fe200078ec0ffULL, 0x000000012a0b7824ULL, 0x000fe200078e0210ULL,
0x0000000602107210ULL, 0x000fe20007f1e0ffULL, 0x0000000218147824ULL, 0x000fe200078e0215ULL,
0x0000000802087210ULL, 0x000fe20007fde0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x0ffffff81b1b7812ULL, 0x000fe400078ef800ULL, 0x0000e00014147811ULL, 0x000fe200078e68ffULL,
0x0000000103117824ULL, 0x040fe200000e0607ULL, 0x000000131c00720cULL, 0x000fe20003f06070ULL,
0x000000012a077824ULL, 0x000fe200078e021cULL, 0x00000018121c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103097824ULL, 0x000fe200030e0609ULL, 0x0000000a020a7210ULL, 0x000fe20007fde0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x0000001421217211ULL, 0x000fc600078e20ffULL,
0x000000101b1b7824ULL, 0x100fe400078e0214ULL, 0x000000101d1d7824ULL, 0x000fe400078e0214ULL,
0x00000001030b7824ULL, 0x040fe200030e060bULL, 0x0000000602127210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000e901c46ULL,
0x000000012a297824ULL, 0x000fe200078e021cULL, 0x000000131c00720cULL, 0x080fe20003fa6070ULL,
0x000000012a2b7824ULL, 0x000fe200078e021eULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x000000131e00720cULL, 0x000fe20003f86070ULL, 0x0000000103137824ULL, 0x000fc400030e0607ULL,
0x0000010029067825ULL, 0x000fc800078e0004ULL, 0x000000011c0c7824ULL, 0x102fe200078e0200ULL,
0x0000000602067210ULL, 0x000fe20007fde0ffULL, 0x000000081c0d7824ULL, 0x000fe400078e00ffULL,
0x000000011e0e7824ULL, 0x044fe400078e0200ULL, 0x000000081e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL, 0x000001002b047825ULL, 0x000fc600078e0004ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee20eULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x100fe400078e0214ULL,
0x0000001025257824ULL, 0x100fe400078e0214ULL, 0x0000001027277824ULL, 0x100fe200078e0214ULL,
0x00000000101f7faeULL, 0x0003e2000d901c46ULL, 0x000000100d0d7824ULL, 0x100fe400078e0214ULL,
0x000000100f0f7824ULL, 0x000fe200078e0214ULL, 0x0000000008217faeULL, 0x0003e2000d101c46ULL,
0x0000000103037824ULL, 0x000fc600030e0605ULL, 0x000000000a257faeULL, 0x0003e8000c901c46ULL,
0x0000000012277faeULL, 0x0003e8000c101c46ULL, 0x00000000060d7faeULL, 0x0003e8000e901c46ULL,
0x00000000020f7faeULL, 0x0003e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000400057811ULL, 0x044fe400078fe8ffULL, 0x00000008000b7811ULL, 0x000fc400078fe8ffULL,
0x0000000c000d7811ULL, 0x040fe200078fe8ffULL, 0x0000000105047824ULL, 0x140fe200078e0200ULL,
0x0000001400117811ULL, 0x040fe200078fe8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x00000010000f7811ULL, 0x040fe200078fe8ffULL, 0x000000010b077824ULL, 0x040fe200078e0200ULL,
0x0000001800137811ULL, 0x000fe200078fe8ffULL, 0x000000080b1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8091c7812ULL, 0x000fe200078ee204ULL, 0x000000010d047824ULL, 0x140fe200078e0200ULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x000000080d1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL, 0x0000000111087824ULL, 0x000fc400078e0200ULL,
0x00000008111d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b207812ULL, 0x000fe200078ee204ULL,
0x000000010f077824ULL, 0x040fe200078e0200ULL, 0x0000000000047211ULL, 0x040fe200078fe8ffULL,
0x000000080f247824ULL, 0x000fe200078e00ffULL, 0xfffffff81d267812ULL, 0x000fe200078ee208ULL,
0x0000000113097824ULL, 0x140fe200078e0200ULL, 0x0000001c001d7811ULL, 0x000fe200078fe8ffULL,
0x0000000813287824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee207ULL,
0x000000012a1b7824ULL, 0x000fe200078e0213ULL, 0x0000000704077812ULL, 0x000fe200078ec0ffULL,
0x000000011d047824ULL, 0x140fe200078e0200ULL, 0xfffffff828287812ULL, 0x000fe200078ee209ULL,
0x000000012a097824ULL, 0x000fe200078e0205ULL, 0x0000002a00057211ULL, 0x000fe200078fe8ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000f2a0f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000218087824ULL, 0x000fe200078e0215ULL, 0x0ffffff807147812ULL, 0x000fe200078ef800ULL,
0x0000008015127824ULL, 0x000fc400078e0206ULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0x0000e000082b7811ULL, 0x000fe200078e68ffULL, 0x000000012a0b7824ULL, 0x040fe400078e020bULL,
0x000000012a0d7824ULL, 0x040fe400078e020dULL, 0x000000012a117824ULL, 0x040fe400078e0211ULL,
0x000000012a1d7824ULL, 0x000fe200078e021dULL, 0xfffffff81f2a7812ULL, 0x000fe200078ee204ULL,
0x0000010005047825ULL, 0x000fc800078e0012ULL, 0x0000010009067825ULL, 0x000fe200078e0012ULL,
0x0000000402047210ULL, 0x000fc60007f1e0ffULL, 0x000001000b087825ULL, 0x000fe200078e0012ULL,
0x0000000602067210ULL, 0x000fc60007f3e0ffULL, 0x000001000d0a7825ULL, 0x000fe200078e0012ULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0c7825ULL, 0x000fe200078e0012ULL,
0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL, 0x00000100110e7825ULL, 0x000fc800078e0012ULL,
0x000001001b107825ULL, 0x000fc800078e0012ULL, 0x000001001d127825ULL, 0x000fc800078e0012ULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000103077824ULL, 0x040fe200008e0607ULL, 0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL,
0x00000010141b7824ULL, 0x000fe400078e022bULL, 0x0000000103097824ULL, 0x040fe200010e0609ULL,
0x0000001002107210ULL, 0x000fe20007f5e0ffULL, 0x000000101c1d7824ULL, 0x000fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041b7faeULL, 0x0003e2000b901c46ULL,
0x00000001030b7824ULL, 0x000fe200018e060bULL, 0x0000001202027210ULL, 0x000fe20007f7e0ffULL,
0x000000101e1f7824ULL, 0x100fe200078e022bULL, 0x00000000061d7faeULL, 0x0003e2000b901c46ULL,
0x0000001020217824ULL, 0x000fc400078e022bULL, 0x0000001024257824ULL, 0x000fe200078e022bULL,
0x00000000081f7faeULL, 0x0003e2000b901c46ULL, 0x00000001030d7824ULL, 0x040fe400000e060dULL,
0x0000001026277824ULL, 0x000fe200078e022bULL, 0x000000000a217faeULL, 0x0003e2000b901c46ULL,
0x00000001030f7824ULL, 0x040fe400008e060fULL, 0x0000001028297824ULL, 0x000fe200078e022bULL,
0x000000000c257faeULL, 0x0003e2000b901c46ULL, 0x0000000103117824ULL, 0x000fc400010e0611ULL,
0x000000102a2b7824ULL, 0x000fe200078e022bULL, 0x000000000e277faeULL, 0x0003e2000b901c46ULL,
0x0000000103037824ULL, 0x000fc600018e0613ULL, 0x0000000010297faeULL, 0x0003e8000b901c46ULL,
0x00000000022b7faeULL, 0x0003e4000b901c46ULL, 0x000000229500720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217001b7802ULL, 0x002fe20000000f00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00007f2000000947ULL, 0x000fea0003800000ULL,
0x00000002a4147824ULL, 0x000fe400078e00ffULL, 0x00006a00ff037624ULL, 0x000fc400078e00ffULL,
0xff317217ff1b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff5f7224ULL, 0x000fe400078e00ffULL,
0x00006a0014147624ULL, 0x000fc400078e0203ULL, 0x000000109a027824ULL, 0x000fe200078e00ffULL,
0x0000000195037810ULL, 0x000fe20007ffe0ffULL, 0x0000590019197a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe002027812ULL, 0x000fe400078ec0ffULL,
0x000000220300720cULL, 0x000fe20003f06070ULL, 0x00000100ff037424ULL, 0x000fe400078e00ffULL,
0x0000010095027824ULL, 0x000fca00078e0202ULL, 0x0000004002077810ULL, 0x020fe20007ffe0ffULL,
0x0000008019027824ULL, 0x000fc600078e00ffULL, 0x0000006007057812ULL, 0x000fe200078ec0ffULL,
0x0000640002027625ULL, 0x000fc800078e0003ULL, 0x0000000116677824ULL, 0x000fe200078e0205ULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0000000794047217ULL, 0x000fe20007800000ULL, 0x000000809a067824ULL, 0x000fe200078e00ffULL,
0x00000003ff207819ULL, 0x000fe40000011600ULL, 0x0000007005097812ULL, 0x000fe200078ec0ffULL,
0x0000000104057824ULL, 0x000fe200078e0a07ULL, 0x00000004200a7810ULL, 0x000fe20007ffe0ffULL,
0x000020009a077824ULL, 0x000fe200078e00ffULL, 0x0000008009047812ULL, 0x000fc400078ef806ULL,
0x0000000c201e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a067824ULL, 0x040fe200078e0200ULL,
0x0000200007077812ULL, 0x000fe200078ec0ffULL, 0x000000080a657824ULL, 0x000fe200078e00ffULL,
0x00000008201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000081e6b7824ULL, 0x000fe200078e00ffULL,
0x0000001420667810ULL, 0x000fe20007ffe0ffULL, 0x0000400018187824ULL, 0x000fe200078e0207ULL,
0xfffffff865657812ULL, 0x000fe200078ee206ULL, 0x000000011e067824ULL, 0x000fe200078e0200ULL,
0x0000002005137817ULL, 0x000fe20003800000ULL, 0x0000000120077824ULL, 0x040fe200078e0267ULL,
0x0000001020647810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee206ULL, 0x000000011c087824ULL, 0x100fe200078e0200ULL,
0x00000003646d7819ULL, 0x000fe200000006ffULL, 0x000000081c697824ULL, 0x040fe200078e00ffULL,
0x000000131c00720cULL, 0x080fe20003f06070ULL, 0x0000000166097824ULL, 0x000fe200078e0200ULL,
0x000000132000720cULL, 0x080fe20003f86070ULL, 0x00000008660c7824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee208ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000130a00720cULL, 0x000fc40003f66070ULL, 0xfffffff80c6f7812ULL, 0x000fe200078ee209ULL,
0x0000000164087824ULL, 0x000fe200078e0200ULL, 0x00000006020c7210ULL, 0x000fe20007f5e0ffULL,
0x000000010a097824ULL, 0x100fe200078e0267ULL, 0x000000131e00720cULL, 0x000fe20003f26070ULL,
0x000000011c0b7824ULL, 0x000fe200078e0267ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee208ULL,
0x0000000120087824ULL, 0x000fe200078e0200ULL, 0x0000f000181c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001030d7824ULL, 0x000fe200010e0607ULL, 0x0000001c20687810ULL, 0x000fe20007ffe0ffULL,
0x0000010009067825ULL, 0x000fe200078e0004ULL, 0x00000007081f7812ULL, 0x000fc600078ec0ffULL,
0x000001000b087825ULL, 0x000fe200078e0004ULL, 0x0000000602187210ULL, 0x000fe40007f5e0ffULL,
0x0ffffff81f217812ULL, 0x000fe200078ef800ULL, 0x000000011e197824ULL, 0x000fe200078e0267ULL,
0x00000008021e7210ULL, 0x000fe20007fbe0ffULL, 0x0000001065657824ULL, 0x000fe400078e021cULL,
0x00000100190a7825ULL, 0x000fc800078e0004ULL, 0x0000000103197824ULL, 0x040fe200010e0607ULL,
0x0000000a020a7210ULL, 0x000fe20007fde0ffULL, 0x0000000164077824ULL, 0x040fe200078e0267ULL,
0x000000136400720cULL, 0x080fe20003f46070ULL, 0x00000001031f7824ULL, 0x000fe200028e0609ULL,
0x0000001820647810ULL, 0x000fe20007ffe0ffULL, 0x0000001021097824ULL, 0x000fe200078e021cULL,
0x000000136600720cULL, 0x000fe20003fa6070ULL, 0x0000010007067825ULL, 0x000fc600078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000e101c46ULL,
0x0000000166217824ULL, 0x000fe200078e0267ULL, 0x000000136400720cULL, 0x080fe20003f86070ULL,
0x00000001030b7824ULL, 0x000fe200030e060bULL, 0x0000000602207210ULL, 0x000fe20007fde0ffULL,
0x0000000018657faeULL, 0x0005e2000d901c46ULL, 0x000000136800720cULL, 0x000fe20003f66070ULL,
0x0000000164137824ULL, 0x000fe400078e0267ULL, 0x0000010021087825ULL, 0x002fc800078e0004ULL,
0x0000000103217824ULL, 0x000fe200030e0607ULL, 0x0000000802087210ULL, 0x000fe20007fde0ffULL,
0x0000010013067825ULL, 0x000fc800078e0004ULL, 0x00000001680d7824ULL, 0x000fe400078e0267ULL,
0x0000000103097824ULL, 0x000fe200030e0609ULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x00000001640c7824ULL, 0x140fe400078e0200ULL, 0x0000000864677824ULL, 0x000fe400078e00ffULL,
0x0000000168137824ULL, 0x040fe200078e0200ULL, 0x0000000368687819ULL, 0x000fe200000006ffULL,
0x000001000d047825ULL, 0x000fe200078e0004ULL, 0xfffffff867677812ULL, 0x000fc400078ee20cULL,
0xfffffff868717812ULL, 0x000fe200078ee213ULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x00000010690d7824ULL, 0x100fe400078e021cULL,
0x000000106b137824ULL, 0x100fe400078e021cULL, 0x000000106d197824ULL, 0x104fe200078e021cULL,
0x000000001e0d7faeULL, 0x0003e2000c101c46ULL, 0x000000106f657824ULL, 0x100fe400078e021cULL,
0x0000001067677824ULL, 0x100fe200078e021cULL, 0x000000000a137faeULL, 0x0003e2000c901c46ULL,
0x0000001071697824ULL, 0x000fc400078e021cULL, 0x0000000103037824ULL, 0x000fe200030e0605ULL,
0x0000000020197faeULL, 0x0003e8000d101c46ULL, 0x0000000008657faeULL, 0x0003e8000e901c46ULL,
0x0000000006677faeULL, 0x0003e8000e101c46ULL, 0x0000000002697faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x040fe200078e00ffULL,
0x0000000400077811ULL, 0x000fe200078fe8ffULL, 0x000000809a217824ULL, 0x000fe200078e00ffULL,
0x0000000c000b7811ULL, 0x000fe200078fe8ffULL, 0x000020009a057824ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fe200078ec0ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000000800097811ULL, 0x000fe200078fe8ffULL, 0x000000010b067824ULL, 0x100fe200078e0200ULL,
0x0000008004207812ULL, 0x000fe200078ef821ULL, 0x0000000107047824ULL, 0x000fe200078e0200ULL,
0x0000200005057812ULL, 0x000fe200078ec0ffULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x00000018001f7811ULL, 0x000fe200078fe8ffULL, 0x0000000809667824ULL, 0x000fe200078e00ffULL,
0xfffffff80d647812ULL, 0x000fe200078ee204ULL, 0x0000400018187824ULL, 0x000fe200078e0205ULL,
0x00000010000d7811ULL, 0x040fe200078fe8ffULL, 0x0000000109057824ULL, 0x000fe200078e0200ULL,
0xfffffff813687812ULL, 0x000fe200078ee206ULL, 0x000000011f067824ULL, 0x100fe200078e0200ULL,
0x0000001400197811ULL, 0x000fe200078fe8ffULL, 0x000000010d047824ULL, 0x140fe200078e0200ULL,
0xfffffff866667812ULL, 0x000fe200078ee205ULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x00000003196c7819ULL, 0x000fe200000006ffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0x0000f00018717810ULL, 0x000fe20007ffe0ffULL, 0x0000000119057824ULL, 0x000fe200078e0200ULL,
0xfffffff8136a7812ULL, 0x000fe200078ee204ULL, 0x0000000107077824ULL, 0x100fe200078e0267ULL,
0x0000000000047211ULL, 0x040fe200078fe8ffULL, 0x0000000109097824ULL, 0x100fe200078e0267ULL,
0x0000001c00137811ULL, 0x000fe200078fe8ffULL, 0x000000010b0b7824ULL, 0x100fe200078e0267ULL,
0xfffffff8216e7812ULL, 0x000fe200078ee206ULL, 0x000000010d0d7824ULL, 0x000fe200078e0267ULL,
0x0000000704217812ULL, 0x000fe200078ec0ffULL, 0x0000000113047824ULL, 0x140fe200078e0200ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee205ULL, 0x0000000813657824ULL, 0x000fe200078e00ffULL,
0x0000006700057211ULL, 0x000fe200078fe8ffULL, 0x0000000119197824ULL, 0x100fe200078e0267ULL,
0x0ffffff8211c7812ULL, 0x000fe200078ef800ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0xfffffff865707812ULL, 0x000fe200078ee204ULL, 0x000000011f1f7824ULL, 0x000fc400078e0267ULL,
0x0000010005047825ULL, 0x000fc800078e0020ULL, 0x0000010007067825ULL, 0x000fe200078e0020ULL,
0x0000000402047210ULL, 0x000fc60007f1e0ffULL, 0x0000010009087825ULL, 0x000fe200078e0020ULL,
0x0000000602067210ULL, 0x000fc60007f3e0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0020ULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x0000000113137824ULL, 0x000fe200078e0267ULL,
0x0000000a020a7210ULL, 0x000fe20007f7e0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0020ULL,
0x0000000903097210ULL, 0x000fc600017fe4ffULL, 0x0000010019187825ULL, 0x000fc800078e0020ULL,
0x000001001f1e7825ULL, 0x000fc800078e0020ULL, 0x0000010013207825ULL, 0x000fe200078e0020ULL,
0x0000001e021e7210ULL, 0x000fc60007f5e0ffULL, 0x0000000103057824ULL, 0x040fe200000e0605ULL,
0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000103077824ULL, 0x040fe200008e0607ULL,
0x0000001802187210ULL, 0x000fe20007f3e0ffULL, 0x000000101c137824ULL, 0x100fe400078e0271ULL,
0x0000001064657824ULL, 0x000fe400078e0271ULL, 0x00000001030b7824ULL, 0x000fe200018e060bULL,
0x0000002002027210ULL, 0x000fe20007f7e0ffULL, 0x0000001066677824ULL, 0x100fe200078e0271ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004137faeULL, 0x0003e2000b901c46ULL,
0x0000001068697824ULL, 0x000fc400078e0271ULL, 0x000000106a6b7824ULL, 0x000fe200078e0271ULL,
0x0000000006657faeULL, 0x0003e2000b901c46ULL, 0x00000001030d7824ULL, 0x040fe400000e060dULL,
0x000000106c6d7824ULL, 0x000fe200078e0271ULL, 0x0000000008677faeULL, 0x0003e2000b901c46ULL,
0x0000000103197824ULL, 0x040fe400008e0619ULL, 0x000000106e6f7824ULL, 0x000fe200078e0271ULL,
0x000000000a697faeULL, 0x0003e2000b901c46ULL, 0x00000001031f7824ULL, 0x000fc400010e061fULL,
0x0000001070717824ULL, 0x000fe200078e0271ULL, 0x000000000c6b7faeULL, 0x0003e2000b901c46ULL,
0x0000000103037824ULL, 0x000fc600018e0621ULL, 0x00000000186d7faeULL, 0x0003e8000b901c46ULL,
0x000000001e6f7faeULL, 0x0003e8000b901c46ULL, 0x0000000002717faeULL, 0x0003e4000b901c46ULL,
0x00000300ff027624ULL, 0x002fe200078e00ffULL, 0x000000011a037812ULL, 0x000fe200078ec0ffULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010300780cULL, 0x000fc40003f05070ULL, 0xffffffff02027811ULL, 0x000fc800078e08ffULL,
0x0000000102037807ULL, 0x000fca0004000000ULL, 0x00000001031a7824ULL, 0x000fca00078e021aULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x0000000114028824ULL, 0x000fe400078e021aULL,
0x00000004ff038424ULL, 0x000fc800078e00ffULL, 0x0000660002028625ULL, 0x000fca00078e0003ULL,
0x0000000602198981ULL, 0x000322000c1e1900ULL, 0xffffffe080047812ULL, 0x040fe400078ec0ffULL,
0x0000001080057812ULL, 0x040fe400078ec0ffULL, 0x0000000880067812ULL, 0x000fc800078ec0ffULL,
0x0000000406087210ULL, 0x000fe20007ffe005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166080008067f8cULL, 0x0022a4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01660c0008057984ULL, 0x000ee40000000800ULL, 0x8000000005ff7812ULL, 0x00cfe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01660c0008057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x004fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x00000001ff817819ULL, 0x000fe20000011600ULL,
0x000000209a027824ULL, 0x000fe400078e00ffULL, 0xffffffffff847424ULL, 0x000fe200078e00ffULL,
0x0000007013137812ULL, 0x000fc400078ec0ffULL, 0xffffff8002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c81817812ULL, 0x000fc800078ec0ffULL, 0x0000000281027210ULL, 0x000fca0007ffe013ULL,
0x0160000002047984ULL, 0x000ea80000000800ULL, 0x0162000002037984ULL, 0x0006620000000800ULL,
0x0000001b0400720bULL, 0x004fe20003f1d000ULL, 0x00015e427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x008fc800000e0100ULL, 0x000000ff0200720cULL, 0x000fe20003f25270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff187224ULL, 0x000fe400078e001bULL, 0x0000001fff877424ULL, 0x000fc400078e00ffULL,
0xffffffffff857424ULL, 0x000fcc00078e00ffULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x000fe4000001169aULL, 0x0000001b0400720bULL, 0x000fe40003f54000ULL,
0x0000009a0500720cULL, 0x000fe20003f25270ULL, 0x00015dd27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000057806ULL, 0x000fc400010e0100ULL, 0x000000809a069824ULL, 0x000fe200078e0213ULL,
0x0000001b04187209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe60003800000ULL,
0x0000000681079210ULL, 0x000fca0007ffe0ffULL, 0x0164001807009388ULL, 0x0005e20000000800ULL,
0x000000ff0500720cULL, 0x000fda0003f25270ULL, 0x000005e000009947ULL, 0x000fea0003800000ULL,
0x0000001b18067221ULL, 0x004fe20000010100ULL, 0x000000ff05ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL,
0x0000000600077308ULL, 0x000ea40000000800ULL, 0x000000071d1d7220ULL, 0x004fc80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x00015d127f007947ULL, 0x000fea000b800000ULL, 0x00001f1e071e7589ULL, 0x0004e400000e0000ULL,
0x0000001e60607220ULL, 0x08cfe20000410000ULL, 0x0000001e61617220ULL, 0x080fe20000410000ULL,
0x0000001e24247220ULL, 0x080fe20000410000ULL, 0x0000001e25257220ULL, 0x080fe20000410000ULL,
0x0000001e28287220ULL, 0x080fe20000410000ULL, 0x0000001e29297220ULL, 0x080fe20000410000ULL,
0x0000001e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001e30307220ULL, 0x080fe20000410000ULL, 0x0000001e31317220ULL, 0x080fe20000410000ULL,
0x0000001e34347220ULL, 0x080fe20000410000ULL, 0x0000001e35357220ULL, 0x080fe20000410000ULL,
0x0000001e38387220ULL, 0x080fe20000410000ULL, 0x0000001e39397220ULL, 0x080fe20000410000ULL,
0x0000001e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001e3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0005ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x000fe200078ff0ffULL, 0x00015be27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e071e7589ULL, 0x0004e400000e0000ULL, 0x0000001e62627220ULL, 0x08cfe20000410000ULL,
0x0000001e63637220ULL, 0x080fe20000410000ULL, 0x0000001e26267220ULL, 0x080fe20000410000ULL,
0x0000001e27277220ULL, 0x080fe20000410000ULL, 0x0000001e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001e32327220ULL, 0x080fe20000410000ULL,
0x0000001e33337220ULL, 0x080fe20000410000ULL, 0x0000001e36367220ULL, 0x080fe20000410000ULL,
0x0000001e37377220ULL, 0x080fe20000410000ULL, 0x0000001e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001e3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000005ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000010001e7811ULL, 0x000fe200078ff0ffULL,
0x00015ab27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e071e7589ULL, 0x0004e400000e0000ULL,
0x0000001e40407220ULL, 0x08cfe20000410000ULL, 0x0000001e41417220ULL, 0x080fe20000410000ULL,
0x0000001e44447220ULL, 0x080fe20000410000ULL, 0x0000001e45457220ULL, 0x080fe20000410000ULL,
0x0000001e48487220ULL, 0x080fe20000410000ULL, 0x0000001e49497220ULL, 0x080fe20000410000ULL,
0x0000001e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001e50507220ULL, 0x080fe20000410000ULL, 0x0000001e51517220ULL, 0x080fe20000410000ULL,
0x0000001e54547220ULL, 0x080fe20000410000ULL, 0x0000001e55557220ULL, 0x080fe20000410000ULL,
0x0000001e58587220ULL, 0x080fe20000410000ULL, 0x0000001e59597220ULL, 0x080fe20000410000ULL,
0x0000001e5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001e5d5d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000005ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000018001e7811ULL, 0x000fe200078ff0ffULL,
0x000159927f007947ULL, 0x000fea000b800000ULL, 0x00001f1e071e7589ULL, 0x0004e400000e0000ULL,
0x0000001e42427220ULL, 0x08cfe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e46467220ULL, 0x080fe20000410000ULL, 0x0000001e47477220ULL, 0x080fe20000410000ULL,
0x0000001e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000001e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000001e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000001e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000001e52527220ULL, 0x080fe20000410000ULL, 0x0000001e53537220ULL, 0x080fe20000410000ULL,
0x0000001e56567220ULL, 0x080fe20000410000ULL, 0x0000001e57577220ULL, 0x080fe20000410000ULL,
0x0000001e5a5a7220ULL, 0x080fe20000410000ULL, 0x0000001e5b5b7220ULL, 0x080fe20000410000ULL,
0x0000001e5e5e7220ULL, 0x080fe20000410000ULL, 0x0000001e5f5f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000000502ff7212ULL, 0x000fda00078230ffULL,
0x8000001804041221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b04041820ULL, 0x000fc80000410000ULL, 0x0000000400121308ULL, 0x000ea40000000800ULL,
0x0000001203031220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000001d031d7221ULL, 0x002fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff02723eULL, 0x000fe400000010ffULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x000157c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0302117589ULL, 0x0002a400000e0000ULL, 0x00000008031e7810ULL, 0x000fe20007ffe0ffULL,
0x000157f27f007947ULL, 0x000fea000b800000ULL, 0x00000010030f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1e02107589ULL, 0x00066a00000e0000ULL, 0x00001f0f020f7589ULL, 0x0006a400000e0000ULL,
0x00000018031e7810ULL, 0x008fe20007ffe0ffULL, 0x000158427f007947ULL, 0x000fea000b800000ULL,
0x00001f1e020e7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000029a1c7824ULL, 0x000fe200078e00ffULL, 0x0000000800037812ULL, 0x002fe200078ec0ffULL,
0x000020009a1b7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000002c000007945ULL, 0x000fe20003800000ULL, 0x000000041c1f7812ULL, 0x000fc400078ec0ffULL,
0x0000000703037812ULL, 0x000fe400078ef800ULL, 0x0000001f00027211ULL, 0x048fe400078fe0ffULL,
0x0000001003217812ULL, 0x040fe200078efcffULL, 0x0000000803067824ULL, 0x040fe200078e00ffULL,
0x0000000300047211ULL, 0x000fe200078fe0ffULL, 0x00000001030d7824ULL, 0x040fe200078e0202ULL,
0x0000000303077819ULL, 0x040fe200000006ffULL, 0x00000001020c7824ULL, 0x000fe200078e0221ULL,
0x00000002040b7810ULL, 0x000fe20007ffe0ffULL, 0x000004009a027824ULL, 0x000fe200078e00ffULL,
0x0000000404097810ULL, 0x000fe20007ffe0ffULL, 0x00000008031e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8060d7812ULL, 0x000fe200078ee20dULL, 0x0000000821057824ULL, 0x000fe200078e00ffULL,
0xfffff00002027812ULL, 0x000fc400078ec0ffULL, 0xfffffff8060b7812ULL, 0x000fe400078ee20bULL,
0xffffc0001b067812ULL, 0x000fe400078ec0ffULL, 0xfffffff81e097812ULL, 0x000fe400078ee209ULL,
0xfffffff8050c7812ULL, 0x000fe200078ee20cULL, 0x0000000803057824ULL, 0x000fe200078e00ffULL,
0x0000a000021e7810ULL, 0x000fe20007ffe0ffULL, 0x0000200015067824ULL, 0x000fe200078e0206ULL,
0x0000000604087810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8050a7812ULL, 0x000fe200078ee204ULL,
0x000000100d747824ULL, 0x100fe200078e021eULL, 0x0000e00006067810ULL, 0x000fe20007ffe0ffULL,
0x000000100c647824ULL, 0x000fe200078e021eULL, 0xfffffff807087812ULL, 0x000fc600078ee208ULL,
0x000000007474783bULL, 0x000e620000000200ULL, 0x000000100a707824ULL, 0x100fe400078e0206ULL,
0x000000100b6c7824ULL, 0x100fe200078e0206ULL, 0x000000006464783bULL, 0x000ee20000000200ULL,
0x0000001009047824ULL, 0x000fe200078e0206ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001174747231ULL, 0x086fe400003400ffULL, 0x0000001176767231ULL, 0x000fe400003400ffULL,
0x0000001075757231ULL, 0x000fc400003400ffULL, 0x0000001077777231ULL, 0x000fe400003400ffULL,
0x0000000f64647231ULL, 0x088fe400003400ffULL, 0x0000000f66667231ULL, 0x000fe400003400ffULL,
0x0000000e65657231ULL, 0x080fe400003400ffULL, 0x0000000e67677231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001008687824ULL, 0x000fe200078e0206ULL,
0x000000007070783bULL, 0x000ee20000004200ULL, 0x000000021f1f7812ULL, 0x000fe200078efcffULL,
0x0000039000007945ULL, 0x000fe20003800000ULL, 0x00000001ff207819ULL, 0x000fe2000001169aULL,
0x000000000404783bULL, 0x000ea20000004200ULL, 0x0000001f00027211ULL, 0x000fc600078fe0ffULL,
0x000000006868783bULL, 0x000e620000004200ULL, 0x00000002201f7824ULL, 0x000fc600078e0215ULL,
0x000000006c6c783bULL, 0x000e640000004200ULL, 0x0000e0001f1f7811ULL, 0x000fe200078e68ffULL,
0x000000706440723cULL, 0x008f700000041840ULL, 0x000000047430723cULL, 0x046f700000041830ULL,
0x000000067434723cULL, 0x000f700000041834ULL, 0x000000046450723cULL, 0x040b6e0000041850ULL,
0x0000000803047824ULL, 0x020fe200078e00ffULL, 0x000000066454723cULL, 0x000b620000041854ULL,
0x0000000821057824ULL, 0x000fcc00078e00ffULL, 0x0000000103077824ULL, 0x120fe200078e0202ULL,
0x000000687438723cULL, 0x080f620000041838ULL, 0x0000000121067824ULL, 0x000fe200078e0202ULL,
0x0000002100027211ULL, 0x000fe400078fe0ffULL, 0xfffffff804077812ULL, 0x000fe400078ee207ULL,
0xfffffff805067812ULL, 0x000fe400078ee206ULL, 0x000000686458723cULL, 0x000b620000041858ULL,
0x0000000202047810ULL, 0x040fe20007ffe0ffULL, 0x0000001007787824ULL, 0x100fe200078e021eULL,
0x0000000402037810ULL, 0x000fe20007ffe0ffULL, 0x00000010061e7824ULL, 0x000fe200078e021eULL,
0xfffffff805057812ULL, 0x000fc400078ee202ULL, 0x0000000821697824ULL, 0x060fe200078e00ffULL,
0x000000726444723cULL, 0x040f620000041844ULL, 0x0000000821687824ULL, 0x040fe200078e00ffULL,
0x0000000602027810ULL, 0x000fe20007ffe0ffULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0xfffffff869047812ULL, 0x000fe200078ee204ULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0xfffffff868037812ULL, 0x000fe400078ee203ULL, 0x0000006c6448723cULL, 0x000f620000041848ULL,
0xfffffff821027812ULL, 0x000fce00078ee202ULL, 0x0000006e644c723cULL, 0x040f70000004184cULL,
0x0000006a645c723cULL, 0x000b64000004185cULL, 0x000000001e64783bULL, 0x0204ec0000000200ULL,
0x000000707460723cULL, 0x040b6e0000041860ULL, 0x0000001003707824ULL, 0x120fe200078e021fULL,
0x000000727424723cULL, 0x040f700000041824ULL, 0x0000006c7428723cULL, 0x040b6e0000041828ULL,
0x00000010056c7824ULL, 0x120fe200078e021fULL, 0x0000006e742c723cULL, 0x040f70000004182cULL,
0x0000006a743c723cULL, 0x000b6e000004183cULL, 0x0000001004747824ULL, 0x020fe200078e021fULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000001178787231ULL, 0x08efe400003400ffULL,
0x000000117a7a7231ULL, 0x000fc400003400ffULL, 0x0000001079797231ULL, 0x080fe400003400ffULL,
0x000000107b7b7231ULL, 0x000fe400003400ffULL, 0x0000000f64647231ULL, 0x080fe400003400ffULL,
0x0000000f66667231ULL, 0x000fe400003400ffULL, 0x0000000e65657231ULL, 0x080fe400003400ffULL,
0x0000000e67677231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x00efea0003800000ULL,
0x0000001002687824ULL, 0x000fe200078e021fULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x0000590019197a24ULL, 0x010fe200078e02ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ec0ffULL,
0x00000008951e7824ULL, 0x000fe200078e0220ULL, 0x000000007474783bULL, 0x000ea80000004200ULL,
0x000000007070783bULL, 0x000ee80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x0000006c7860723cULL, 0x042b700000041860ULL, 0x0000006e7824723cULL, 0x040b700000041824ULL,
0x000000747828723cULL, 0x044b700000041828ULL, 0x00000076782c723cULL, 0x040b70000004182cULL,
0x000000707830723cULL, 0x048b700000041830ULL, 0x000000727834723cULL, 0x040b700000041834ULL,
0x000000687838723cULL, 0x040b700000041838ULL, 0x0000006a783c723cULL, 0x000b70000004183cULL,
0x000000746448723cULL, 0x040b700000041848ULL, 0x00000076644c723cULL, 0x040b70000004184cULL,
0x000000706450723cULL, 0x040b700000041850ULL, 0x000000726454723cULL, 0x040b700000041854ULL,
0x0000006c6440723cULL, 0x040b700000041840ULL, 0x0000006e6444723cULL, 0x040b700000041844ULL,
0x000000686458723cULL, 0x040b700000041858ULL, 0x0000006a645c723cULL, 0x000b62000004185cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000001951f7810ULL, 0x000fe20007ffe0ffULL,
0x0000008019647824ULL, 0x020fe200078e00ffULL, 0x000000801e1e7811ULL, 0x000fe200078e28ffULL,
0x016688001cff7f8cULL, 0x0003e2000c80043fULL, 0x000000221f00720cULL, 0x000fc40003f06070ULL,
0x0000010000657802ULL, 0x000fe40000000f00ULL, 0x000000601e197812ULL, 0x000fc600078ec0ffULL,
0x0000640064647625ULL, 0x000fc800078e0065ULL, 0x0000000116797824ULL, 0x000fe200078e0219ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1c7819ULL, 0x102fe40000011600ULL, 0x000020001b1b7812ULL, 0x000fe400078ec0ffULL,
0x000000081c687810ULL, 0x040fe20007ffe0ffULL, 0x000000011c217824ULL, 0x000fe200078e0279ULL,
0x0000001e94197217ULL, 0x000fe20007800000ULL, 0x0000400020707824ULL, 0x000fe200078e021bULL,
0x000000041c667810ULL, 0x000fe20007ffe0ffULL, 0x00000001681f7824ULL, 0x000fe200078e0200ULL,
0x000000141c7c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000868747824ULL, 0x000fe200078e00ffULL,
0x0000000c1c6e7810ULL, 0x000fe20007ffe0ffULL, 0x000000809a207824ULL, 0x000fe200078e00ffULL,
0x000000101c787810ULL, 0x000fe20007ffe0ffULL, 0x0000000119197824ULL, 0x000fe200078e0a1eULL,
0xfffffff874747812ULL, 0x000fe200078ee21fULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x00000080131e7812ULL, 0x000fe200078ef820ULL, 0x0000000166677824ULL, 0x040fe200078e0279ULL,
0x0000002019197817ULL, 0x000fe20003800000ULL, 0x00000001661b7824ULL, 0x000fc400078e0200ULL,
0x0000010021207825ULL, 0x100fe200078e001eULL, 0x000000196600720cULL, 0x080fe40003f86070ULL,
0x000000196e00720cULL, 0x080fe20003f46070ULL, 0x0000000866727824ULL, 0x000fe200078e00ffULL,
0x00000020646a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010067667825ULL, 0x000fe200078e001eULL,
0x000000196800720cULL, 0x080fe40003f66070ULL, 0xfffffff872727812ULL, 0x000fe200078ee21bULL,
0x000000017c6b7824ULL, 0x100fe200078e0200ULL, 0x00000066646c7210ULL, 0x000fe20007f3e0ffULL,
0x000000087c7e7824ULL, 0x000fe200078e00ffULL, 0x000000191c00720cULL, 0x000fe20003fa6070ULL,
0x000000016e1b7824ULL, 0x000fc400078e0200ULL, 0x000000086e767824ULL, 0x000fe200078e00ffULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee26bULL, 0x00000001656b7824ULL, 0x040fe400000e0621ULL,
0x0000000168217824ULL, 0x000fe200078e0279ULL, 0xfffffff876767812ULL, 0x000fe200078ee21bULL,
0x00000001656d7824ULL, 0x000fe200008e0667ULL, 0x000000001c1b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000178697824ULL, 0x040fe200078e0200ULL, 0x000000197800720cULL, 0x040fe20003f26070ULL,
0x00000008787a7824ULL, 0x000fe200078e00ffULL, 0x000000071b717812ULL, 0x000fe200078ec0ffULL,
0x000000016e677824ULL, 0x000fe200078e0279ULL, 0x0000e000701b7810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e001eULL, 0xfffffff87a7a7812ULL, 0x000fc600078ee269ULL,
0x0000010067667825ULL, 0x000fe200078e001eULL, 0x00000020646e7210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff871207812ULL, 0x000fe200078ef800ULL, 0x0000000178697824ULL, 0x000fe200078e0279ULL,
0x0000006664667210ULL, 0x000fe20007fde0ffULL, 0x00000001656f7824ULL, 0x000fe200000e0621ULL,
0x0000001c1c787810ULL, 0x000fe20007ffe0ffULL, 0x0000010069687825ULL, 0x000fe200078e001eULL,
0x000000197c00720cULL, 0x000fc60003f06070ULL, 0x000000017c217824ULL, 0x000fe400078e0279ULL,
0x0000000165677824ULL, 0x000fe200030e0667ULL, 0x0000006864687210ULL, 0x000fe20007fde0ffULL,
0x0000001020737824ULL, 0x000fe400078e021bULL, 0x0000010021207825ULL, 0x000fc600078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a737faeULL, 0x0003e2000e901c46ULL,
0x0000001072757824ULL, 0x000fe200078e021bULL, 0x000000181c727810ULL, 0x000fe20007ffe0ffULL,
0x0000000165697824ULL, 0x040fe200030e0669ULL, 0x0000002064707210ULL, 0x000fe40007fde0ffULL,
0x000000006c757faeULL, 0x0005e2000e101c46ULL, 0x0000000172777824ULL, 0x040fe200078e0279ULL,
0x000000197200720cULL, 0x080fe20003fa6070ULL, 0x0000000165717824ULL, 0x000fe200030e0621ULL,
0x000000197800720cULL, 0x000fe20003f86070ULL, 0x0000010077207825ULL, 0x000fc800078e001eULL,
0x0000000178197824ULL, 0x000fe200078e0279ULL, 0x0000002064207210ULL, 0x000fe20007fde0ffULL,
0x00000001721c7824ULL, 0x140fe400078e0200ULL, 0x00000008726b7824ULL, 0x002fe400078e00ffULL,
0x00000001786a7824ULL, 0x040fe400078e0200ULL, 0x00000008786d7824ULL, 0x004fe200078e00ffULL,
0xfffffff86b1c7812ULL, 0x000fe200078ee21cULL, 0x00000100191e7825ULL, 0x000fc600078e001eULL,
0xfffffff86d6a7812ULL, 0x000fe200078ee26aULL, 0x0000000165217824ULL, 0x000fe200030e0621ULL,
0x0000001e641e7210ULL, 0x000fe20007fde0ffULL, 0x0000001074197824ULL, 0x100fe400078e021bULL,
0x00000010766b7824ULL, 0x100fe400078e021bULL, 0x000000107a6d7824ULL, 0x100fe200078e021bULL,
0x000000006e197faeULL, 0x0003e2000d901c46ULL, 0x000000107e737824ULL, 0x100fe400078e021bULL,
0x000000101c757824ULL, 0x100fe200078e021bULL, 0x00000000666b7faeULL, 0x0003e2000d101c46ULL,
0x000000106a1b7824ULL, 0x000fc400078e021bULL, 0x00000001651f7824ULL, 0x000fe200030e061fULL,
0x00000000686d7faeULL, 0x0003e8000c901c46ULL, 0x0000000070737faeULL, 0x0003e8000c101c46ULL,
0x0000000020757faeULL, 0x0003e8000e901c46ULL, 0x000000001e1b7faeULL, 0x0003e2000e101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000400217811ULL, 0x002fe200078fe8ffULL,
0x000000809a707824ULL, 0x000fe200078e00ffULL, 0x0000000c00697811ULL, 0x000fc400078fe8ffULL,
0x00000010006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000121197824ULL, 0x100fe200078e0200ULL,
0x000020001b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008211e7824ULL, 0x000fe200078e00ffULL,
0x0000000800677811ULL, 0x040fe200078fe8ffULL, 0x00000001691c7824ULL, 0x140fe200078e0200ULL,
0x00000018006f7811ULL, 0x000fe200078fe8ffULL, 0x0000000869777824ULL, 0x000fe200078e00ffULL,
0xfffffff81e737812ULL, 0x000fe200078ee219ULL, 0x000000016b197824ULL, 0x100fe200078e0200ULL,
0x0000001b20207211ULL, 0x000fe200078e70ffULL, 0x00000001671b7824ULL, 0x000fe200078e0200ULL,
0xfffffff877777812ULL, 0x000fe200078ee21cULL, 0x000000086b1c7824ULL, 0x000fe200078e00ffULL,
0x00000014006d7811ULL, 0x000fe200078fe8ffULL, 0x0000000867667824ULL, 0x000fe200078e00ffULL,
0x0000008013707812ULL, 0x000fe200078ef870ULL, 0x000000086f7f7824ULL, 0x040fe200078e00ffULL,
0xfffffff81c7b7812ULL, 0x000fe200078ee219ULL, 0x000000016f1c7824ULL, 0x100fe200078e0200ULL,
0xfffffff866757812ULL, 0x000fe200078ee21bULL, 0x000000016d1b7824ULL, 0x040fe200078e0200ULL,
0x0000000000197211ULL, 0x040fe200078fe8ffULL, 0x000000086d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee21cULL, 0x0000000121217824ULL, 0x100fe200078e0279ULL,
0x0000001c001c7811ULL, 0x000fe200078fe8ffULL, 0x0000000167677824ULL, 0x000fe200078e0279ULL,
0xfffffff81e7d7812ULL, 0x000fe200078ee21bULL, 0x0000000169697824ULL, 0x100fe200078e0279ULL,
0x00000079001f7211ULL, 0x000fe200078fe8ffULL, 0x000000011c1e7824ULL, 0x040fe200078e0200ULL,
0x000000ff00717202ULL, 0x000fe20000000f00ULL, 0x000000081c897824ULL, 0x040fe200078e00ffULL,
0x00000007191b7812ULL, 0x000fe200078ec0ffULL, 0x000000011c197824ULL, 0x000fe200078e0279ULL,
0x0000e000201c7810ULL, 0x000fe20007ffe0ffULL, 0x0000010021207825ULL, 0x000fe200078e0070ULL,
0xfffffff889897812ULL, 0x000fc400078ee21eULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef800ULL,
0x000001001f1e7825ULL, 0x000fe200078e0070ULL, 0x0000002064207210ULL, 0x000fc60007f3e0ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0279ULL, 0x0000001e641e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010067667825ULL, 0x000fc800078e0070ULL, 0x000000016d6d7824ULL, 0x000fe200078e0279ULL,
0x0000006664667210ULL, 0x000fe20007f5e0ffULL, 0x0000010069687825ULL, 0x000fc800078e0070ULL,
0x000000016f6f7824ULL, 0x000fe200078e0279ULL, 0x0000006864687210ULL, 0x000fe20007f7e0ffULL,
0x000001006b6a7825ULL, 0x000fc800078e0070ULL, 0x000001006d6c7825ULL, 0x000fc800078e0070ULL,
0x000001006f6e7825ULL, 0x000fc800078e0070ULL, 0x0000010019707825ULL, 0x000fc800078e0070ULL,
0x00000001651f7824ULL, 0x040fe200000e061fULL, 0x0000006a646a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000165217824ULL, 0x000fe200008e0621ULL, 0x0000006c646c7210ULL, 0x040fe20007f3e0ffULL,
0x000000101b197824ULL, 0x100fe400078e021cULL, 0x0000000165677824ULL, 0x000fe200010e0667ULL,
0x0000006e646e7210ULL, 0x040fe20007f5e0ffULL, 0x00000010731b7824ULL, 0x100fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e2000b901c46ULL,
0x0000000165697824ULL, 0x000fe200018e0669ULL, 0x0000007064707210ULL, 0x000fe20007f7e0ffULL,
0x0000001075737824ULL, 0x100fe200078e021cULL, 0x00000000201b7faeULL, 0x0003e2000b901c46ULL,
0x0000001077757824ULL, 0x000fc400078e021cULL, 0x000000107b777824ULL, 0x100fe200078e021cULL,
0x0000000066737faeULL, 0x0003e2000b901c46ULL, 0x00000001656b7824ULL, 0x000fe400000e066bULL,
0x000000107d797824ULL, 0x100fe200078e021cULL, 0x0000000068757faeULL, 0x0003e2000b901c46ULL,
0x00000001656d7824ULL, 0x000fe400008e066dULL, 0x000000107f7b7824ULL, 0x000fe200078e021cULL,
0x000000006a777faeULL, 0x0003e2000b901c46ULL, 0x00000001656f7824ULL, 0x000fc400010e066fULL,
0x00000010897d7824ULL, 0x000fe200078e021cULL, 0x000000006c797faeULL, 0x0003e2000b901c46ULL,
0x0000000165717824ULL, 0x000fc600018e0671ULL, 0x000000006e7b7faeULL, 0x0003e8000b901c46ULL,
0x00000000707d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe080197812ULL, 0x042fe400078ec0ffULL, 0x00000010801c7812ULL, 0x040fe400078ec0ffULL,
0x00000008801b7812ULL, 0x000fc800078ec0ffULL, 0x000000191b1b7210ULL, 0x000fe20007ffe01cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016628001b667f8cULL, 0x0002a4000c80043fULL,
0x00000000001e7805ULL, 0x000fc40000015200ULL, 0x01662c001b197984ULL, 0x000ee40000000800ULL,
0x8000000019ff7812ULL, 0x00cfe40007804867ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e1c7210ULL, 0x000fca0007f1e1ffULL, 0x0000000121207824ULL, 0x000fe200000e0e1fULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff197819ULL, 0x000fc80000011420ULL, 0x0000001c19197211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e0620ULL, 0x0000000219197819ULL, 0x000fc8000000121cULL,
0x000000190000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01662c001b197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209a197824ULL, 0x000fca00078e00ffULL,
0xffffff80191c7812ULL, 0x000fc800078ec0ffULL, 0x00000080131c7810ULL, 0x000fca0007ffe01cULL,
0x00000001811c7824ULL, 0x000fca00078e021cULL, 0x016000001c197984ULL, 0x000ea80000000800ULL,
0x016200001c667984ULL, 0x0006620000000800ULL, 0x000000181900720bULL, 0x004fe20003f1d000ULL,
0x00013fe27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001c7806ULL, 0x008fc800000e0100ULL,
0x000000ff1c00720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x00000018001b7202ULL, 0x002fd20000000f00ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000019a1b7811ULL, 0x000fe400078ff0ffULL,
0x000000181900720bULL, 0x000fe40003f34000ULL, 0x0000009a1b00720cULL, 0x000fe20003f05270ULL,
0x00013f927f007947ULL, 0x000fd4000b800000ULL, 0x00000000001b7806ULL, 0x000fc400008e0100ULL,
0x000000809a208824ULL, 0x000fe200078e0213ULL, 0x00000018191e8209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x00000001811f8824ULL, 0x000fca00078e0220ULL,
0x0164001e1f008388ULL, 0x0003e20000000800ULL, 0x000000ff1b00720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x00000018191f7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff1bff7812ULL, 0x000fc6000780c0ffULL,
0x000000181f1e7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00687308ULL, 0x000e640000000800ULL, 0x000000681d1d7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x00013ec27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0002a400000e0000ULL,
0x0000001e60607220ULL, 0x084fe20000410000ULL, 0x0000001e61617220ULL, 0x080fe20000410000ULL,
0x0000001e24247220ULL, 0x080fe20000410000ULL, 0x0000001e25257220ULL, 0x080fe20000410000ULL,
0x0000001e28287220ULL, 0x080fe20000410000ULL, 0x0000001e29297220ULL, 0x080fe20000410000ULL,
0x0000001e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001e30307220ULL, 0x080fe20000410000ULL, 0x0000001e31317220ULL, 0x080fe20000410000ULL,
0x0000001e34347220ULL, 0x080fe20000410000ULL, 0x0000001e35357220ULL, 0x080fe20000410000ULL,
0x0000001e38387220ULL, 0x080fe20000410000ULL, 0x0000001e39397220ULL, 0x080fe20000410000ULL,
0x0000001e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001e3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001bff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x000fe200078ff0ffULL, 0x00013d927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e62627220ULL, 0x08cfe20000410000ULL,
0x0000001e63637220ULL, 0x080fe20000410000ULL, 0x0000001e26267220ULL, 0x080fe20000410000ULL,
0x0000001e27277220ULL, 0x080fe20000410000ULL, 0x0000001e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001e32327220ULL, 0x080fe20000410000ULL,
0x0000001e33337220ULL, 0x080fe20000410000ULL, 0x0000001e36367220ULL, 0x080fe20000410000ULL,
0x0000001e37377220ULL, 0x080fe20000410000ULL, 0x0000001e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001e3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001bff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000010001e7811ULL, 0x000fe200078ff0ffULL,
0x00013c627f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e40407220ULL, 0x08cfe20000410000ULL, 0x0000001e41417220ULL, 0x080fe20000410000ULL,
0x0000001e44447220ULL, 0x080fe20000410000ULL, 0x0000001e45457220ULL, 0x080fe20000410000ULL,
0x0000001e48487220ULL, 0x080fe20000410000ULL, 0x0000001e49497220ULL, 0x080fe20000410000ULL,
0x0000001e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001e50507220ULL, 0x080fe20000410000ULL, 0x0000001e51517220ULL, 0x080fe20000410000ULL,
0x0000001e54547220ULL, 0x080fe20000410000ULL, 0x0000001e55557220ULL, 0x080fe20000410000ULL,
0x0000001e58587220ULL, 0x080fe20000410000ULL, 0x0000001e59597220ULL, 0x080fe20000410000ULL,
0x0000001e5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001e5d5d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000018001e7811ULL, 0x000fe200078ff0ffULL,
0x00013b427f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e42427220ULL, 0x08cfe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e46467220ULL, 0x080fe20000410000ULL, 0x0000001e47477220ULL, 0x080fe20000410000ULL,
0x0000001e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000001e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000001e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000001e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000001e52527220ULL, 0x080fe20000410000ULL, 0x0000001e53537220ULL, 0x080fe20000410000ULL,
0x0000001e56567220ULL, 0x080fe20000410000ULL, 0x0000001e57577220ULL, 0x080fe20000410000ULL,
0x0000001e5a5a7220ULL, 0x080fe20000410000ULL, 0x0000001e5b5b7220ULL, 0x080fe20000410000ULL,
0x0000001e5e5e7220ULL, 0x080fe20000410000ULL, 0x0000001e5f5f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001b1cff7212ULL, 0x000fe400078030ffULL,
0x00000018191b7209ULL, 0x000fd60007810000ULL, 0x8000001b19190221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL, 0x0000001900120308ULL, 0x000e640000000800ULL,
0x0000001266660220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001d661d7221ULL, 0x000fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000012ff0e723eULL, 0x000fe400000010ffULL,
0x00000002ff197819ULL, 0x000fe40000011600ULL, 0x000054100e0e7816ULL, 0x000fe2000000000eULL,
0x000139827f007947ULL, 0x000fea000b800000ULL, 0x00001f190e117589ULL, 0x0002a400000e0000ULL,
0x00000008191e7810ULL, 0x000fe20007ffe0ffULL, 0x000139b27f007947ULL, 0x000fea000b800000ULL,
0x00000010190f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1e0e107589ULL, 0x00066a00000e0000ULL,
0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL, 0x00000018191e7810ULL, 0x008fe20007ffe0ffULL,
0x00013a027f007947ULL, 0x000fea000b800000ULL, 0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL,
0x000004009a187824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000020009a197824ULL, 0x000fe200078e00ffULL, 0x0000016000007945ULL, 0x000fe40003800000ULL,
0xfffff00018187812ULL, 0x000fc400078ec0ffULL, 0xffffc000191c7812ULL, 0x000fe400078ec0ffULL,
0x0000b00018187810ULL, 0x000fc60007ffe0ffULL, 0x00002000151c7824ULL, 0x000fe400078e021cULL,
0x000000100d7c7824ULL, 0x100fe400078e0218ULL, 0x000000100c187824ULL, 0x000fe200078e0218ULL,
0x0000f0001c1c7810ULL, 0x000fc60007ffe0ffULL, 0x000000007c7c783bULL, 0x000e620000000200ULL,
0x0000001c0b747211ULL, 0x000fe200078e20ffULL, 0x000000100a787824ULL, 0x100fe400078e021cULL,
0x000000001868783bULL, 0x0006a20000000200ULL, 0x0000001009707824ULL, 0x000fe200078e021cULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x000000117c7c7231ULL, 0x086fe400003400ffULL,
0x000000117e7e7231ULL, 0x000fe400003400ffULL, 0x000000107d7d7231ULL, 0x000fc400003400ffULL,
0x000000107f7f7231ULL, 0x000fe400003400ffULL, 0x0000000f68687231ULL, 0x080fe400003400ffULL,
0x0000000f6a6a7231ULL, 0x000fe400003400ffULL, 0x0000000e69697231ULL, 0x088fe400003400ffULL,
0x0000000e6b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010086c7824ULL, 0x000fe200078e021cULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000002ff1c7819ULL, 0x100fe2000001169aULL, 0x0000029000007945ULL, 0x000fe20003800000ULL,
0x00000001ff187819ULL, 0x008fe2000001169aULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x0000b0001c1e7811ULL, 0x002fc600078e60ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x00000002181f7824ULL, 0x000fc600078e0215ULL, 0x000000006c6c783bULL, 0x000ea40000004200ULL,
0x0000f0001f1f7811ULL, 0x000fe200078e68ffULL, 0x000000787c60723cULL, 0x050f700000041860ULL,
0x0000007a7c24723cULL, 0x040f700000041824ULL, 0x000000747c28723cULL, 0x048f700000041828ULL,
0x000000767c2c723cULL, 0x040f70000004182cULL, 0x000000707c30723cULL, 0x042f700000041830ULL,
0x000000727c34723cULL, 0x040f700000041834ULL, 0x0000006c7c38723cULL, 0x044f700000041838ULL,
0x0000006e7c3c723cULL, 0x000b6e000004183cULL, 0x00000010077c7824ULL, 0x120fe200078e021eULL,
0x000000786840723cULL, 0x000b620000041840ULL, 0x00000010061e7824ULL, 0x000fc800078e021eULL,
0x000000007c7c783bULL, 0x000e640000000200ULL, 0x0000001005787824ULL, 0x120fe200078e021fULL,
0x0000007a6844723cULL, 0x040f700000041844ULL, 0x000000746848723cULL, 0x040b6e0000041848ULL,
0x0000001004747824ULL, 0x120fe200078e021fULL, 0x00000076684c723cULL, 0x040f70000004184cULL,
0x000000706850723cULL, 0x040b6e0000041850ULL, 0x0000001003707824ULL, 0x020fe200078e021fULL,
0x000000726854723cULL, 0x040f700000041854ULL, 0x0000006c6858723cULL, 0x040f700000041858ULL,
0x0000006e685c723cULL, 0x000b64000004185cULL, 0x000000001e68783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x000000117c7c7231ULL, 0x082fe400003400ffULL, 0x000000117e7e7231ULL, 0x000fc400003400ffULL,
0x000000107d7d7231ULL, 0x080fe400003400ffULL, 0x000000107f7f7231ULL, 0x000fe400003400ffULL,
0x0000000f68687231ULL, 0x088fe400003400ffULL, 0x0000000f6a6a7231ULL, 0x000fe400003400ffULL,
0x0000000e69697231ULL, 0x080fe400003400ffULL, 0x0000000e6b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x00000010026c7824ULL, 0x000fe200078e021fULL,
0x000000007878783bULL, 0x000e620000004200ULL, 0x0000000895217824ULL, 0x000fe200078e0218ULL,
0x000166901c1e7811ULL, 0x004fc400078e18ffULL, 0x000000007474783bULL, 0x000ea80000004200ULL,
0x000000007070783bULL, 0x000f280000004200ULL, 0x000000006c6c783bULL, 0x000ee20000004200ULL,
0x000000787c60723cULL, 0x042b700000041860ULL, 0x0000007a7c24723cULL, 0x040b700000041824ULL,
0x000000747c28723cULL, 0x044b700000041828ULL, 0x000000767c2c723cULL, 0x040b70000004182cULL,
0x000000707c30723cULL, 0x050b700000041830ULL, 0x000000727c34723cULL, 0x040b700000041834ULL,
0x0000006c7c38723cULL, 0x048b700000041838ULL, 0x0000006e7c3c723cULL, 0x000b70000004183cULL,
0x000000786840723cULL, 0x040b700000041840ULL, 0x0000007a6844723cULL, 0x040b700000041844ULL,
0x000000746848723cULL, 0x040b700000041848ULL, 0x00000076684c723cULL, 0x040b70000004184cULL,
0x000000706850723cULL, 0x040b700000041850ULL, 0x000000726854723cULL, 0x040b700000041854ULL,
0x0000006c6858723cULL, 0x040b700000041858ULL, 0x0000006e685c723cULL, 0x000b62000004185cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000195677810ULL, 0x000fe20007ffe0ffULL,
0x000000001eff7f8cULL, 0x0003e2000c80043fULL, 0x000000c021217811ULL, 0x000fc400078e28ffULL,
0x000000226700720cULL, 0x000fe40003f06070ULL, 0x00000060211f7812ULL, 0x000fca00078ec0ffULL,
0x0000000116737824ULL, 0x020fe200078e021fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff707819ULL, 0x102fe40000011600ULL,
0x00000021941e7217ULL, 0x000fe40007800000ULL, 0x0000000470207810ULL, 0x040fe40007ffe0ffULL,
0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e1f7824ULL, 0x000fe200078e0a21ULL,
0x0000000870687810ULL, 0x000fe20007ffe0ffULL, 0x0000000120217824ULL, 0x100fe200078e0200ULL,
0x0000001070747810ULL, 0x000fe20007ffe0ffULL, 0x00000008206a7824ULL, 0x000fe200078e00ffULL,
0x000000201f717817ULL, 0x000fe20003800000ULL, 0x000000809a1e7824ULL, 0x000fe200078e00ffULL,
0x0000001470767810ULL, 0x000fe20007ffe0ffULL, 0x000000016e677824ULL, 0x000fe200078e0200ULL,
0xfffffff86a777812ULL, 0x000fe200078ee221ULL, 0x000000086e6c7824ULL, 0x000fe200078e00ffULL,
0x00000080131e7812ULL, 0x000fe200078ef81eULL, 0x0000000170217824ULL, 0x000fe200078e0273ULL,
0x000000712000720cULL, 0x080fe20003f86070ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0xfffffff86c7b7812ULL, 0x000fe200078ee267ULL, 0x0000000168667824ULL, 0x000fe200078e0200ULL,
0x0000000074697210ULL, 0x000fe20007ffe0ffULL, 0x0000000868797824ULL, 0x000fe200078e00ffULL,
0x0000200019197812ULL, 0x000fe200078ec0ffULL, 0x0000000120677824ULL, 0x000fe200078e0273ULL,
0x000000716e00720cULL, 0x000fe20003f46070ULL, 0x0000010021207825ULL, 0x000fe200078e001eULL,
0xfffffff879797812ULL, 0x000fc400078ee266ULL, 0x000000716800720cULL, 0x080fe20003f66070ULL,
0x00000008746c7824ULL, 0x000fe200078e00ffULL, 0x00000020646a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010067667825ULL, 0x000fe200078e001eULL, 0x000000717000720cULL, 0x000fe40003fa6070ULL,
0xfffffff86c7d7812ULL, 0x000fe200078ee269ULL, 0x00000001766b7824ULL, 0x000fe200078e0200ULL,
0x00000066646c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000876727824ULL, 0x000fe400078e00ffULL,
0x0000000174697824ULL, 0x000fc400078e0273ULL, 0x00000001656d7824ULL, 0x040fe200008e0667ULL,
0xfffffff8727f7812ULL, 0x000fe200078ee26bULL, 0x00000001656b7824ULL, 0x000fe200000e0621ULL,
0x000000717400720cULL, 0x000fe20003f26070ULL, 0x0000000168217824ULL, 0x100fe200078e0273ULL,
0x0000001870747810ULL, 0x000fe20007ffe0ffULL, 0x000000016e677824ULL, 0x000fe400078e0273ULL,
0x0000010021207825ULL, 0x000fc800078e001eULL, 0x0000400018727824ULL, 0x000fe200078e0219ULL,
0x00000020646e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000170197824ULL, 0x000fe400078e0200ULL,
0x0000010067667825ULL, 0x100fe200078e001eULL, 0x0000f00072727810ULL, 0x000fe40007ffe0ffULL,
0x0000000719197812ULL, 0x000fe200078ec0ffULL, 0x0000010069687825ULL, 0x000fe200078e001eULL,
0x0000006664667210ULL, 0x000fe40007fde0ffULL, 0x0ffffff819197812ULL, 0x000fe200078ef800ULL,
0x00000001656f7824ULL, 0x040fe200000e0621ULL, 0x000000717600720cULL, 0x040fe20003f06070ULL,
0x0000000176217824ULL, 0x000fe200078e0273ULL, 0x0000001c70767810ULL, 0x000fe20007ffe0ffULL,
0x0000000165677824ULL, 0x000fe200030e0667ULL, 0x0000006864687210ULL, 0x000fe20007fde0ffULL,
0x0000010021207825ULL, 0x000fc800078e001eULL, 0x0000001019757824ULL, 0x100fe400078e0272ULL,
0x0000001077777824ULL, 0x000fe400078e0272ULL, 0x0000000165697824ULL, 0x040fe200030e0669ULL,
0x0000002064707210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a757faeULL, 0x0003e2000e901c46ULL, 0x0000000174197824ULL, 0x140fe200078e0273ULL,
0x000000717400720cULL, 0x080fe20003fa6070ULL, 0x0000000176737824ULL, 0x040fe200078e0273ULL,
0x000000006c777faeULL, 0x0005e2000e101c46ULL, 0x000000717600720cULL, 0x000fe20003f86070ULL,
0x0000000165717824ULL, 0x000fc400030e0621ULL, 0x0000010019207825ULL, 0x000fc800078e001eULL,
0x0000000174197824ULL, 0x100fe200078e0200ULL, 0x0000002064207210ULL, 0x000fe20007fde0ffULL,
0x0000000874747824ULL, 0x000fe200078e00ffULL, 0x00000003766b7819ULL, 0x042fe200000006ffULL,
0x00000001766a7824ULL, 0x000fe400078e0200ULL, 0x00000100731e7825ULL, 0x000fe200078e001eULL,
0xfffffff874197812ULL, 0x000fe400078ee219ULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee26aULL,
0x0000000165217824ULL, 0x000fe200030e0621ULL, 0x0000001e641e7210ULL, 0x000fe20007fde0ffULL,
0x0000001079797824ULL, 0x000fc400078e0272ULL, 0x000000107b7b7824ULL, 0x100fe400078e0272ULL,
0x000000107d7d7824ULL, 0x100fe200078e0272ULL, 0x000000006e797faeULL, 0x0005e2000d901c46ULL,
0x000000107f7f7824ULL, 0x100fe400078e0272ULL, 0x0000001019197824ULL, 0x100fe200078e0272ULL,
0x00000000667b7faeULL, 0x0005e2000d101c46ULL, 0x000000106b6b7824ULL, 0x000fe400078e0272ULL,
0x00000001651f7824ULL, 0x000fe200030e061fULL, 0x00000000687d7faeULL, 0x0005e8000c901c46ULL,
0x00000000707f7faeULL, 0x0005e8000c101c46ULL, 0x0000000020197faeULL, 0x0005e8000e901c46ULL,
0x000000001e6b7faeULL, 0x0005e2000e101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000400217811ULL, 0x002fe200078fe8ffULL, 0x000000809a707824ULL, 0x000fe200078e00ffULL,
0x0000000800677811ULL, 0x000fc400078fe8ffULL, 0x00000010006b7811ULL, 0x040fe200078fe8ffULL,
0x00000001211e7824ULL, 0x140fe200078e0200ULL, 0x00000014006d7811ULL, 0x040fe200078fe8ffULL,
0x0000000821697824ULL, 0x000fe200078e00ffULL, 0x00000018006f7811ULL, 0x040fe200078fe8ffULL,
0x00000001671f7824ULL, 0x000fe200078e0200ULL, 0x0000008013707812ULL, 0x000fe200078ef870ULL,
0x0000000867767824ULL, 0x000fe200078e00ffULL, 0xfffffff869747812ULL, 0x000fe200078ee21eULL,
0x000000086b7a7824ULL, 0x000fe200078e00ffULL, 0x0000000c00697811ULL, 0x000fe200078fe8ffULL,
0x000000016d207824ULL, 0x100fe200078e0200ULL, 0xfffffff876767812ULL, 0x000fe200078ee21fULL,
0x000000016b1f7824ULL, 0x100fe200078e0200ULL, 0x0000007321217210ULL, 0x000fe20007ffe0ffULL,
0x00000001691e7824ULL, 0x000fc400078e0200ULL, 0x0000000869717824ULL, 0x000fe200078e00ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee21fULL, 0x000000086d757824ULL, 0x000fe200078e00ffULL,
0x00002000191f7812ULL, 0x000fe200078ec0ffULL, 0x000000016f667824ULL, 0x040fe200078e0200ULL,
0x0000000000197211ULL, 0x000fe200078fe8ffULL, 0x000000086f777824ULL, 0x000fe200078e00ffULL,
0xfffffff871787812ULL, 0x000fe200078ee21eULL, 0x00004000181e7824ULL, 0x000fe200078e021fULL,
0xfffffff8757c7812ULL, 0x000fe200078ee220ULL, 0x0000000167677824ULL, 0x100fe200078e0273ULL,
0x0000001c00207811ULL, 0x000fe200078fe8ffULL, 0x0000000169697824ULL, 0x100fe200078e0273ULL,
0x0000000719717812ULL, 0x000fe200078ec0ffULL, 0x000000016b6b7824ULL, 0x000fe200078e0273ULL,
0xfffffff8777e7812ULL, 0x000fe200078ee266ULL, 0x0000000120667824ULL, 0x100fe200078e0200ULL,
0x00000073001f7211ULL, 0x000fe200078fe8ffULL, 0x0000000820757824ULL, 0x000fe200078e00ffULL,
0x0ffffff871727812ULL, 0x000fe200078ef800ULL, 0x000000ffff717224ULL, 0x000fc400078e00ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0273ULL, 0xfffffff875867812ULL, 0x000fe200078ee266ULL,
0x000000016f6f7824ULL, 0x100fe400078e0273ULL, 0x0000000120197824ULL, 0x000fe200078e0273ULL,
0x0000f0001e737810ULL, 0x000fe20007ffe0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0070ULL,
0x0000010021207825ULL, 0x000fe200078e0070ULL, 0x0000001e641e7210ULL, 0x000fc60007f1e0ffULL,
0x0000010067667825ULL, 0x000fe200078e0070ULL, 0x0000002064207210ULL, 0x000fc60007f3e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0070ULL, 0x0000006664667210ULL, 0x000fc60007f5e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0070ULL, 0x0000006864687210ULL, 0x000fc60007f7e0ffULL,
0x000001006d6c7825ULL, 0x000fc800078e0070ULL, 0x000001006f6e7825ULL, 0x000fc800078e0070ULL,
0x0000010019707825ULL, 0x000fc800078e0070ULL, 0x00000001651f7824ULL, 0x040fe200000e061fULL,
0x0000006a646a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001072197824ULL, 0x000fe400078e0273ULL,
0x0000000165217824ULL, 0x040fe200008e0621ULL, 0x0000006c646c7210ULL, 0x040fe20007f3e0ffULL,
0x0000000165677824ULL, 0x040fe200010e0667ULL, 0x0000006e646e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001074757824ULL, 0x000fe200078e0273ULL, 0x0000006d656d7210ULL, 0x040fe20000ffe4ffULL,
0x0000000165697824ULL, 0x000fe200018e0669ULL, 0x0000007064647210ULL, 0x000fe20007f7e0ffULL,
0x0000001076777824ULL, 0x100fe200078e0273ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e197faeULL, 0x0003e2000b901c46ULL, 0x0000001078797824ULL, 0x000fc400078e0273ULL,
0x000000107a7b7824ULL, 0x000fe200078e0273ULL, 0x0000000020757faeULL, 0x0003e2000b901c46ULL,
0x00000001656b7824ULL, 0x040fe400000e066bULL, 0x000000107c7d7824ULL, 0x100fe200078e0273ULL,
0x0000000066777faeULL, 0x0003e2000b901c46ULL, 0x000000107e7f7824ULL, 0x000fe400078e0273ULL,
0x00000001656f7824ULL, 0x000fe200010e066fULL, 0x0000000068797faeULL, 0x0003e2000b901c46ULL,
0x0000001086737824ULL, 0x000fc400078e0273ULL, 0x0000000165657824ULL, 0x000fe200018e0671ULL,
0x000000006a7b7faeULL, 0x0003e8000b901c46ULL, 0x000000006c7d7faeULL, 0x0003e8000b901c46ULL,
0x000000006e7f7faeULL, 0x0003e8000b901c46ULL, 0x0000000064737faeULL, 0x0003e4000b901c46ULL,
0x00000300ff197624ULL, 0x006fe200078e00ffULL, 0x000000011a1e7812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000011e00780cULL, 0x000fc40003f05070ULL,
0xffffffff19197811ULL, 0x000fc800078e08ffULL, 0x0000000119197807ULL, 0x000fca0004000000ULL,
0x000000011a1a7824ULL, 0x000fe400078e0219ULL, 0xffffffffff197424ULL, 0x000fc600078e00ffULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x000000011a1e8824ULL, 0x000fe400078e0214ULL,
0x00000004ff1f8424ULL, 0x000fc800078e00ffULL, 0x000066001e1e8625ULL, 0x000fca00078e001fULL,
0x000000061e198981ULL, 0x000322000c1e1900ULL, 0x0000001080217812ULL, 0x000fca00078ec0ffULL,
0x000000201c1c7824ULL, 0x000fe200078e0221ULL, 0x0000000880217812ULL, 0x000fca00078ec0ffULL,
0x00000001211c7824ULL, 0x000fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016648001c647f8cULL, 0x0022a4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x01664c001c217984ULL, 0x000ee40000000800ULL, 0x8000000021ff7812ULL, 0x00cfe40007804865ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e677210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1fULL, 0x003d09006700780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406700780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc80000011421ULL,
0x0000006720207211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000220207819ULL, 0x000fc80000001221ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000166667810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01664c001c217984ULL, 0x000ea40000000800ULL,
0x8000000021ff7812ULL, 0x004fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000209a1c7824ULL, 0x002fca00078e00ffULL, 0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL,
0x00000100131c7810ULL, 0x000fca0007ffe01cULL, 0x00000001811c7824ULL, 0x000fca00078e021cULL,
0x016000001c647984ULL, 0x000e680000000800ULL, 0x016200001c657984ULL, 0x0004e20000000800ULL,
0x0000001b6400720bULL, 0x002fe20003f1d000ULL, 0x000123a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001c7806ULL, 0x004fc800000e0100ULL, 0x000000ff1c00720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000029a1f7811ULL, 0x000fe400078ff0ffULL,
0x0000001b6400720bULL, 0x000fe40003f34000ULL, 0x0000009a1f00720cULL, 0x000fe20003f05270ULL,
0x000123627f007947ULL, 0x000fd4000b800000ULL, 0x0000000000677806ULL, 0x000fc400008e0100ULL,
0x000000809a208824ULL, 0x000fe200078e0213ULL, 0x0000001b641e8209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x00000001811f8824ULL, 0x000fca00078e0220ULL,
0x0164001e1f008388ULL, 0x0003e20000000800ULL, 0x000000ff6700720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000001b641e7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff67ff7812ULL, 0x000fc6000780c0ffULL,
0x0000001b1e1e7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00667308ULL, 0x000e640000000800ULL, 0x000000661d1d7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x000122927f007947ULL, 0x000fea000b800000ULL, 0x00001f1e661e7589ULL, 0x0002a400000e0000ULL,
0x0000001e60607220ULL, 0x084fe20000410000ULL, 0x0000001e61617220ULL, 0x080fe20000410000ULL,
0x0000001e24247220ULL, 0x080fe20000410000ULL, 0x0000001e25257220ULL, 0x080fe20000410000ULL,
0x0000001e28287220ULL, 0x080fe20000410000ULL, 0x0000001e29297220ULL, 0x080fe20000410000ULL,
0x0000001e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001e30307220ULL, 0x080fe20000410000ULL, 0x0000001e31317220ULL, 0x080fe20000410000ULL,
0x0000001e34347220ULL, 0x080fe20000410000ULL, 0x0000001e35357220ULL, 0x080fe20000410000ULL,
0x0000001e38387220ULL, 0x080fe20000410000ULL, 0x0000001e39397220ULL, 0x080fe20000410000ULL,
0x0000001e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001e3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0067ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x000fe200078ff0ffULL, 0x000121627f007947ULL, 0x000fea000b800000ULL,
0x00001f1e661e7589ULL, 0x00046400000e0000ULL, 0x0000001e62627220ULL, 0x086fe20000410000ULL,
0x0000001e63637220ULL, 0x080fe20000410000ULL, 0x0000001e26267220ULL, 0x080fe20000410000ULL,
0x0000001e27277220ULL, 0x080fe20000410000ULL, 0x0000001e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001e32327220ULL, 0x080fe20000410000ULL,
0x0000001e33337220ULL, 0x080fe20000410000ULL, 0x0000001e36367220ULL, 0x080fe20000410000ULL,
0x0000001e37377220ULL, 0x080fe20000410000ULL, 0x0000001e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001e3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000067ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000010001e7811ULL, 0x000fe200078ff0ffULL,
0x000120327f007947ULL, 0x000fea000b800000ULL, 0x00001f1e661e7589ULL, 0x00046400000e0000ULL,
0x0000001e40407220ULL, 0x086fe20000410000ULL, 0x0000001e41417220ULL, 0x080fe20000410000ULL,
0x0000001e44447220ULL, 0x080fe20000410000ULL, 0x0000001e45457220ULL, 0x080fe20000410000ULL,
0x0000001e48487220ULL, 0x080fe20000410000ULL, 0x0000001e49497220ULL, 0x080fe20000410000ULL,
0x0000001e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001e50507220ULL, 0x080fe20000410000ULL, 0x0000001e51517220ULL, 0x080fe20000410000ULL,
0x0000001e54547220ULL, 0x080fe20000410000ULL, 0x0000001e55557220ULL, 0x080fe20000410000ULL,
0x0000001e58587220ULL, 0x080fe20000410000ULL, 0x0000001e59597220ULL, 0x080fe20000410000ULL,
0x0000001e5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001e5d5d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000067ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000018001e7811ULL, 0x000fe200078ff0ffULL,
0x00011f127f007947ULL, 0x000fea000b800000ULL, 0x00001f1e661e7589ULL, 0x00046400000e0000ULL,
0x0000001e42427220ULL, 0x086fe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e46467220ULL, 0x080fe20000410000ULL, 0x0000001e47477220ULL, 0x080fe20000410000ULL,
0x0000001e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000001e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000001e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000001e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000001e52527220ULL, 0x080fe20000410000ULL, 0x0000001e53537220ULL, 0x080fe20000410000ULL,
0x0000001e56567220ULL, 0x080fe20000410000ULL, 0x0000001e57577220ULL, 0x080fe20000410000ULL,
0x0000001e5a5a7220ULL, 0x080fe20000410000ULL, 0x0000001e5b5b7220ULL, 0x080fe20000410000ULL,
0x0000001e5e5e7220ULL, 0x080fe20000410000ULL, 0x0000001e5f5f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000671cff7212ULL, 0x000fe400078030ffULL,
0x0000001b641b7209ULL, 0x000fd60007810000ULL, 0x8000001b64640221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b64640820ULL, 0x000fc80000410000ULL, 0x0000006400120308ULL, 0x000e640000000800ULL,
0x0000001265650220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001d651d7221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000012ff0e723eULL, 0x000fe400000010ffULL,
0x00000002ff657819ULL, 0x000fe40000011600ULL, 0x000054100e0e7816ULL, 0x000fe2000000000eULL,
0x00011d527f007947ULL, 0x000fea000b800000ULL, 0x00001f650e117589ULL, 0x0002a400000e0000ULL,
0x00000008651e7810ULL, 0x000fe20007ffe0ffULL, 0x00011d827f007947ULL, 0x000fea000b800000ULL,
0x00000010650f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1e0e107589ULL, 0x00066a00000e0000ULL,
0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL, 0x00000018651e7810ULL, 0x008fe20007ffe0ffULL,
0x00011dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL,
0x000004009a1c7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000002181f7824ULL, 0x000fe200078e0215ULL, 0x0000015000007945ULL, 0x000fe40003800000ULL,
0xfffff0001c1e7812ULL, 0x002fe200078ec0ffULL, 0x000020001f1c7824ULL, 0x000fc600078e00ffULL,
0x0000c0001e1e7810ULL, 0x000fe40007ffe0ffULL, 0x0000e0001c1f7810ULL, 0x000fc60007ffe0ffULL,
0x000000100d687824ULL, 0x100fe400078e021eULL, 0x000000100c1e7824ULL, 0x000fe400078e021eULL,
0x000000100a6c7824ULL, 0x100fe400078e021fULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x000000100b707824ULL, 0x100fe400078e021fULL, 0x0000001009747824ULL, 0x000fe200078e021fULL,
0x000000001e64783bULL, 0x0006a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001168687231ULL, 0x086fe400003400ffULL, 0x000000116a6a7231ULL, 0x000fc400003400ffULL,
0x0000001069697231ULL, 0x080fe400003400ffULL, 0x000000106b6b7231ULL, 0x000fe400003400ffULL,
0x0000000f64647231ULL, 0x080fe400003400ffULL, 0x0000000f66667231ULL, 0x000fe400003400ffULL,
0x0000000e65657231ULL, 0x088fe400003400ffULL, 0x0000000e67677231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001008787824ULL, 0x000fe200078e021fULL,
0x000000006c6c783bULL, 0x000ee40000004200ULL, 0x00000002ff1e7819ULL, 0x008fe2000001169aULL,
0x0000025000007945ULL, 0x000fe20003800000ULL, 0x000000007070783bULL, 0x000fe40000004200ULL,
0x0000c0001e207811ULL, 0x000fc400078e60ffULL, 0x000000007878783bULL, 0x000ee80000004200ULL,
0x000000007474783bULL, 0x000ea40000004200ULL, 0x0000006c6440723cULL, 0x004f700000041840ULL,
0x000000786838723cULL, 0x04af700000041838ULL, 0x0000007a683c723cULL, 0x000f70000004183cULL,
0x000000786458723cULL, 0x040f700000041858ULL, 0x0000006e6444723cULL, 0x040f700000041844ULL,
0x000000706448723cULL, 0x040f700000041848ULL, 0x00000072644c723cULL, 0x040f70000004184cULL,
0x000000746450723cULL, 0x040f700000041850ULL, 0x000000766454723cULL, 0x040f700000041854ULL,
0x0000007a6478723cULL, 0x000b6e000004185cULL, 0x0000001007647824ULL, 0x120fe200078e0220ULL,
0x0000006c6860723cULL, 0x000b620000041860ULL, 0x0000001006207824ULL, 0x000fc800078e0220ULL,
0x000000006464783bULL, 0x000e640000000200ULL, 0x00000010046c7824ULL, 0x120fe200078e021fULL,
0x0000006e6824723cULL, 0x040f620000041824ULL, 0x00000000205c783bULL, 0x0004ee0000000200ULL,
0x000000706828723cULL, 0x040b6e0000041828ULL, 0x0000001003707824ULL, 0x120fe200078e021fULL,
0x00000072682c723cULL, 0x040f70000004182cULL, 0x000000746830723cULL, 0x040f700000041830ULL,
0x000000766834723cULL, 0x000b6e0000041834ULL, 0x0000001005687824ULL, 0x020fe200078e021fULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000001164647231ULL, 0x086fe400003400ffULL,
0x0000001166667231ULL, 0x000fc400003400ffULL, 0x0000001065657231ULL, 0x080fe400003400ffULL,
0x0000001067677231ULL, 0x000fe400003400ffULL, 0x0000000f5c5c7231ULL, 0x088fe400003400ffULL,
0x0000000f5e5e7231ULL, 0x000fe400003400ffULL, 0x0000000e5d5d7231ULL, 0x080fe400003400ffULL,
0x0000000e5f5f7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000001f02747211ULL, 0x000fe200078e20ffULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x000166981e1f7811ULL, 0x000fc600078e18ffULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x000000007070783bULL, 0x000ee80000004200ULL, 0x000000007474783bULL, 0x000ea20000004200ULL,
0x000000685c40723cULL, 0x04ab700000041840ULL, 0x0000006a5c44723cULL, 0x040b700000041844ULL,
0x0000006c5c48723cULL, 0x044b700000041848ULL, 0x0000006e5c4c723cULL, 0x040b70000004184cULL,
0x000000705c50723cULL, 0x040b700000041850ULL, 0x000000725c54723cULL, 0x040b700000041854ULL,
0x000000745c58723cULL, 0x000b700000041858ULL, 0x000000686460723cULL, 0x040b700000041860ULL,
0x0000006a6424723cULL, 0x040b700000041824ULL, 0x0000006c6428723cULL, 0x040b700000041828ULL,
0x0000006e642c723cULL, 0x040b70000004182cULL, 0x000000706430723cULL, 0x040b700000041830ULL,
0x000000726434723cULL, 0x040b700000041834ULL, 0x000000746438723cULL, 0x040b700000041838ULL,
0x00000076643c723cULL, 0x080b70000004183cULL, 0x000000765c5c723cULL, 0x000b620000041878ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000030095957a10ULL, 0x000fe20007ffe0ffULL,
0x000000001fff7f8cULL, 0x0003e6000c80043fULL, 0x000000229500720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x0000000195217810ULL, 0x002fe20007ffe0ffULL, 0x00005900191f7a24ULL, 0x010fe400078e02ffULL,
0x0000010095647824ULL, 0x020fe200078e0217ULL, 0x000000222100720cULL, 0x000fe20003f06070ULL,
0x000000801f207824ULL, 0x000fe400078e00ffULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x00000060641f7812ULL, 0x000fc600078ec0ffULL, 0x0000640020207625ULL, 0x000fc800078e0021ULL,
0x0000000116777824ULL, 0x000fe400078e021fULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff727819ULL, 0x000fe40000011600ULL, 0x00000064941f7217ULL, 0x000fe40007800000ULL,
0x0000000472667810ULL, 0x040fe40007ffe0ffULL, 0x00000008726a7810ULL, 0x040fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0a64ULL, 0x0000000c72707810ULL, 0x000fe20007ffe0ffULL,
0x0000000166647824ULL, 0x100fe200078e0200ULL, 0x0000001472767810ULL, 0x000fe20007ffe0ffULL,
0x0000000866757824ULL, 0x000fe200078e00ffULL, 0x000000201f1f7817ULL, 0x000fe20003800000ULL,
0x000000016a657824ULL, 0x000fe200078e0200ULL, 0x0000001072747810ULL, 0x000fe20007ffe0ffULL,
0x000000086a687824ULL, 0x000fe200078e00ffULL, 0xfffffff875757812ULL, 0x000fe200078ee264ULL,
0x0000000170677824ULL, 0x000fe200078e0200ULL, 0x0000001f6600720cULL, 0x080fe20003f86070ULL,
0x00000008706c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8687d7812ULL, 0x000fe200078ee265ULL,
0x000000809a647824ULL, 0x000fe200078e00ffULL, 0x0000001f7000720cULL, 0x080fe20003f46070ULL,
0x000000ffff657224ULL, 0x000fe200078e00ffULL, 0xfffffff86c7f7812ULL, 0x000fe200078ee267ULL,
0x0000000172677824ULL, 0x100fe200078e0277ULL, 0x0000008013647812ULL, 0x000fe200078ef864ULL,
0x0000000166697824ULL, 0x000fe200078e0277ULL, 0x0000001f6a00720cULL, 0x080fe20003f66070ULL,
0x00000001766d7824ULL, 0x000fe200078e0200ULL, 0x0000001f7200720cULL, 0x000fe20003fa6070ULL,
0x0000010067667825ULL, 0x000fc800078e0064ULL, 0x0000010069687825ULL, 0x000fe200078e0064ULL,
0x00000066206c7210ULL, 0x000fc60007f1e0ffULL, 0x00000008767a7824ULL, 0x000fe200078e00ffULL,
0x00000068206e7210ULL, 0x000fe20007f3e0ffULL, 0x000020009a667824ULL, 0x000fe200078e00ffULL,
0x0000000072687210ULL, 0x000fe20007ffe0ffULL, 0x00000001746b7824ULL, 0x100fe200078e0200ULL,
0xfffffff87a8b7812ULL, 0x000fe200078ee26dULL, 0x00000001216d7824ULL, 0x040fe200000e0667ULL,
0x0000200066717812ULL, 0x000fe200078ec0ffULL, 0x000000016a677824ULL, 0x000fe200078e0277ULL,
0x0000000768737812ULL, 0x000fe200078ec0ffULL, 0x00000001216f7824ULL, 0x000fe200008e0669ULL,
0x0000001f7400720cULL, 0x040fe20003f26070ULL, 0x0000000874787824ULL, 0x000fe200078e00ffULL,
0x0ffffff873737812ULL, 0x000fe200078ef800ULL, 0x0000000170697824ULL, 0x000fc400078e0277ULL,
0x0000010067667825ULL, 0x000fe200078e0064ULL, 0xfffffff878897812ULL, 0x000fe400078ee26bULL,
0x0000001c72787810ULL, 0x000fe20007ffe0ffULL, 0x0000010069687825ULL, 0x000fe200078e0064ULL,
0x0000006620707210ULL, 0x000fc60007f1e0ffULL, 0x00000001746b7824ULL, 0x000fe200078e0277ULL,
0x0000006820687210ULL, 0x000fe20007fde0ffULL, 0x0000400018747824ULL, 0x000fe400078e0271ULL,
0x000001006b6a7825ULL, 0x000fc600078e0064ULL, 0x0000e00074747810ULL, 0x000fe20007ffe0ffULL,
0x0000000121717824ULL, 0x040fe200000e0667ULL, 0x0000001f7600720cULL, 0x040fe20003f06070ULL,
0x0000000176677824ULL, 0x000fe200078e0277ULL, 0x0000001872767810ULL, 0x000fe20007ffe0ffULL,
0x0000000121697824ULL, 0x000fe200030e0669ULL, 0x0000006a206a7210ULL, 0x000fe20007fde0ffULL,
0x0000010067667825ULL, 0x000fc800078e0064ULL, 0x00000001216b7824ULL, 0x000fe200030e066bULL,
0x0000006620727210ULL, 0x000fe20007fde0ffULL, 0x0000001073797824ULL, 0x100fe400078e0274ULL,
0x00000010757b7824ULL, 0x000fe400078e0274ULL, 0x0000000176757824ULL, 0x040fe200078e0277ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c797faeULL, 0x0003e2000e901c46ULL,
0x0000000121737824ULL, 0x000fe200030e0667ULL, 0x0000001f7600720cULL, 0x080fe20003fa6070ULL,
0x0000010075667825ULL, 0x000fe200078e0064ULL, 0x000000006e7b7faeULL, 0x0005e2000e101c46ULL,
0x0000001f7800720cULL, 0x000fc40003f86070ULL, 0x00000001781f7824ULL, 0x000fe200078e0277ULL,
0x0000006620667210ULL, 0x000fe20007fde0ffULL, 0x0000000876757824ULL, 0x000fe400078e00ffULL,
0x000001001f647825ULL, 0x000fc800078e0064ULL, 0x00000001786d7824ULL, 0x102fe400078e0200ULL,
0x00000001766c7824ULL, 0x000fe400078e0200ULL, 0x0000000878787824ULL, 0x000fe400078e00ffULL,
0x0000000121677824ULL, 0x000fe200030e0667ULL, 0xfffffff8751f7812ULL, 0x000fe200078ee26cULL,
0x000000107d7d7824ULL, 0x100fe200078e0274ULL, 0xfffffff8786d7812ULL, 0x000fe200078ee26dULL,
0x000000107f7f7824ULL, 0x100fe200078e0274ULL, 0x0000006420207210ULL, 0x000fe20007fde0ffULL,
0x0000001089897824ULL, 0x100fe200078e0274ULL, 0x000000741f1f7211ULL, 0x000fe200078e20ffULL,
0x000000108b8b7824ULL, 0x100fe200078e0274ULL, 0x00000000707d7faeULL, 0x0005e2000d901c46ULL,
0x000000106d6d7824ULL, 0x000fc400078e0274ULL, 0x0000000121217824ULL, 0x000fe200030e0665ULL,
0x00000000687f7faeULL, 0x0005e8000d101c46ULL, 0x000000006a897faeULL, 0x0005e8000c901c46ULL,
0x00000000728b7faeULL, 0x0005e8000c101c46ULL, 0x00000000661f7faeULL, 0x0005e8000e901c46ULL,
0x00000000206d7faeULL, 0x0005e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000800697811ULL, 0x000fe200078fe8ffULL, 0x000000809a727824ULL, 0x000fe200078e00ffULL,
0x0000000400677811ULL, 0x000fc400078fe8ffULL, 0x00000010006d7811ULL, 0x040fe200078fe8ffULL,
0x0000000169647824ULL, 0x140fe200078e0200ULL, 0x0000000c006b7811ULL, 0x040fe200078fe8ffULL,
0x0000000869657824ULL, 0x000fe200078e00ffULL, 0x00000014006f7811ULL, 0x040fe200078fe8ffULL,
0x00000001671f7824ULL, 0x040fe200078e0200ULL, 0x0000001800717811ULL, 0x000fe200078fe8ffULL,
0x0000000867767824ULL, 0x000fe200078e00ffULL, 0xfffffff865787812ULL, 0x000fe200078ee264ULL,
0x000000016d647824ULL, 0x000fe200078e0200ULL, 0x0000008013727812ULL, 0x000fe200078ef872ULL,
0x000000086d737824ULL, 0x000fe200078e00ffULL, 0xfffffff876767812ULL, 0x000fe200078ee21fULL,
0x000000016b1f7824ULL, 0x000fc400078e0200ULL, 0x000000086b7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8737c7812ULL, 0x000fe200078ee264ULL, 0x000000016f657824ULL, 0x140fe200078e0200ULL,
0x0000000000647211ULL, 0x080fe200078fe8ffULL, 0x000000086f7e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee21fULL, 0x0000000171667824ULL, 0x040fe200078e0200ULL,
0x0000000764737812ULL, 0x000fe200078ec0ffULL, 0x0000000871757824ULL, 0x000fe200078e00ffULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee265ULL, 0x000020009a1f7824ULL, 0x000fe200078e00ffULL,
0x0000001c00657811ULL, 0x040fe200078fe8ffULL, 0x0000000167677824ULL, 0x100fe200078e0277ULL,
0xfffffff875867812ULL, 0x000fe200078ee266ULL, 0x0000000169697824ULL, 0x100fe200078e0277ULL,
0x000020001f757812ULL, 0x000fe200078ec0ffULL, 0x0000000865797824ULL, 0x040fe200078e00ffULL,
0x0000000065647210ULL, 0x040fe20007ffe0ffULL, 0x00000001651f7824ULL, 0x100fe200078e0277ULL,
0x0000007700657211ULL, 0x000fe200078fe8ffULL, 0x000000016b6b7824ULL, 0x100fe200078e0277ULL,
0x0ffffff873747812ULL, 0x000fe200078ef800ULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0xfffffff879887812ULL, 0x000fe200078ee264ULL, 0x000000016d6d7824ULL, 0x000fc400078e0277ULL,
0x0000010065647825ULL, 0x000fc800078e0072ULL, 0x0000010067667825ULL, 0x000fe200078e0072ULL,
0x0000006420647210ULL, 0x000fc60007f1e0ffULL, 0x0000400018757824ULL, 0x000fe200078e0275ULL,
0x0000006620667210ULL, 0x000fe20007f3e0ffULL, 0x0000010069687825ULL, 0x000fc600078e0072ULL,
0x0000e00075757810ULL, 0x000fe20007ffe0ffULL, 0x000000016f6f7824ULL, 0x000fe200078e0277ULL,
0x0000006820687210ULL, 0x000fe20007f5e0ffULL, 0x000001006b6a7825ULL, 0x000fc800078e0072ULL,
0x0000000171717824ULL, 0x000fe200078e0277ULL, 0x0000006a206a7210ULL, 0x000fe20007f7e0ffULL,
0x000001006d6c7825ULL, 0x000fc800078e0072ULL, 0x000001006f6e7825ULL, 0x000fc800078e0072ULL,
0x0000010071707825ULL, 0x000fc800078e0072ULL, 0x000001001f727825ULL, 0x000fc800078e0072ULL,
0x0000000121657824ULL, 0x040fe200000e0665ULL, 0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000121677824ULL, 0x040fe200008e0667ULL, 0x0000006e206e7210ULL, 0x000fe20007f3e0ffULL,
0x00000010741f7824ULL, 0x000fe400078e0275ULL, 0x0000000121697824ULL, 0x040fe200010e0669ULL,
0x0000007020707210ULL, 0x000fe20007f5e0ffULL, 0x0000001076777824ULL, 0x000fe200078e0275ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000641f7faeULL, 0x0003e2000b901c46ULL,
0x00000001216b7824ULL, 0x000fe200018e066bULL, 0x0000007220207210ULL, 0x000fe20007f7e0ffULL,
0x0000001078797824ULL, 0x100fe200078e0275ULL, 0x0000000066777faeULL, 0x0003e2000b901c46ULL,
0x000000107a7b7824ULL, 0x000fc400078e0275ULL, 0x000000107c7d7824ULL, 0x000fe200078e0275ULL,
0x0000000068797faeULL, 0x0003e2000b901c46ULL, 0x00000001216d7824ULL, 0x040fe400000e066dULL,
0x000000107e7f7824ULL, 0x000fe200078e0275ULL, 0x000000006a7b7faeULL, 0x0003e2000b901c46ULL,
0x00000001216f7824ULL, 0x040fe400008e066fULL, 0x0000001086897824ULL, 0x000fe200078e0275ULL,
0x000000006c7d7faeULL, 0x0003e2000b901c46ULL, 0x0000000121717824ULL, 0x000fc400010e0671ULL,
0x0000001088757824ULL, 0x000fe200078e0275ULL, 0x000000006e7f7faeULL, 0x0003e2000b901c46ULL,
0x0000000121217824ULL, 0x000fc600018e0673ULL, 0x0000000070897faeULL, 0x0003e8000b901c46ULL,
0x0000000020757faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x00000010801f7812ULL, 0x044fe400078ec0ffULL, 0x0000000880207812ULL, 0x000fc600078ec0ffULL,
0x000000201e1f7824ULL, 0x000fc800078e021fULL, 0x0000000120667824ULL, 0x020fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166680066647f8cULL, 0x0002a4000c80043fULL,
0x00000000001e7805ULL, 0x000fc40000015200ULL, 0x01666c0066217984ULL, 0x000ee40000000800ULL,
0x8000000021ff7812ULL, 0x00cfe40007804865ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff00687202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e677210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1fULL,
0x003d09006700780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406700780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011421ULL, 0x0000006720207211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000220207819ULL, 0x000fc80000001221ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01666c0066217984ULL, 0x000ea40000000800ULL, 0x8000000021ff7812ULL, 0x004fe40007804865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000039a1e7811ULL, 0x000fca00078ff0ffULL,
0x000000801e1e7824ULL, 0x000fc800078e0213ULL, 0x00000001811e7824ULL, 0x000fca00078e021eULL,
0x016000001e647984ULL, 0x000ea80000000800ULL, 0x016200001e657984ULL, 0x0006620000000800ULL,
0x0000001b6400720bULL, 0x004fe20003f1d000ULL, 0x000108127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000667806ULL, 0x00afc800000e0100ULL, 0x000000ff6600720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000039a1f7811ULL, 0x000fe400078ff0ffULL,
0x0000001b6400720bULL, 0x000fe40003f34000ULL, 0x0000009a1f00720cULL, 0x000fe20003f05270ULL,
0x000107d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000677806ULL, 0x000fc400008e0100ULL,
0x000000809a1e8824ULL, 0x000fe200078e0213ULL, 0x0000001b64138209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x00000001811e8824ULL, 0x000fca00078e021eULL,
0x016400131e008388ULL, 0x0003e20000000800ULL, 0x000000ff6700720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000001b641e7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff67ff7812ULL, 0x000fc6000780c0ffULL,
0x0000001b1e137221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300687308ULL, 0x000e640000000800ULL, 0x000000681d1d7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe20000011600ULL,
0x000107027f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0002a400000e0000ULL,
0x0000001e60607220ULL, 0x084fe20000410000ULL, 0x0000001e61617220ULL, 0x080fe20000410000ULL,
0x0000001e24247220ULL, 0x080fe20000410000ULL, 0x0000001e25257220ULL, 0x080fe20000410000ULL,
0x0000001e28287220ULL, 0x080fe20000410000ULL, 0x0000001e29297220ULL, 0x080fe20000410000ULL,
0x0000001e2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001e2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001e30307220ULL, 0x080fe20000410000ULL, 0x0000001e31317220ULL, 0x080fe20000410000ULL,
0x0000001e34347220ULL, 0x080fe20000410000ULL, 0x0000001e35357220ULL, 0x080fe20000410000ULL,
0x0000001e38387220ULL, 0x080fe20000410000ULL, 0x0000001e39397220ULL, 0x080fe20000410000ULL,
0x0000001e3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001e3d3d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0067ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001e7811ULL, 0x000fe200078ff0ffULL, 0x000105d27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e62627220ULL, 0x08cfe20000410000ULL,
0x0000001e63637220ULL, 0x080fe20000410000ULL, 0x0000001e26267220ULL, 0x080fe20000410000ULL,
0x0000001e27277220ULL, 0x080fe20000410000ULL, 0x0000001e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001e32327220ULL, 0x080fe20000410000ULL,
0x0000001e33337220ULL, 0x080fe20000410000ULL, 0x0000001e36367220ULL, 0x080fe20000410000ULL,
0x0000001e37377220ULL, 0x080fe20000410000ULL, 0x0000001e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001e3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000067ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000010001e7811ULL, 0x000fe200078ff0ffULL,
0x000104a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e40407220ULL, 0x08cfe20000410000ULL, 0x0000001e41417220ULL, 0x080fe20000410000ULL,
0x0000001e44447220ULL, 0x080fe20000410000ULL, 0x0000001e45457220ULL, 0x080fe20000410000ULL,
0x0000001e48487220ULL, 0x080fe20000410000ULL, 0x0000001e49497220ULL, 0x080fe20000410000ULL,
0x0000001e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001e50507220ULL, 0x080fe20000410000ULL, 0x0000001e51517220ULL, 0x080fe20000410000ULL,
0x0000001e54547220ULL, 0x080fe20000410000ULL, 0x0000001e55557220ULL, 0x080fe20000410000ULL,
0x0000001e58587220ULL, 0x080fe20000410000ULL, 0x0000001e59597220ULL, 0x080fe20000410000ULL,
0x0000001e5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001e5d5d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000067ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000018001e7811ULL, 0x000fe200078ff0ffULL,
0x000103827f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e42427220ULL, 0x08cfe20000410000ULL, 0x0000001e43437220ULL, 0x080fe20000410000ULL,
0x0000001e46467220ULL, 0x080fe20000410000ULL, 0x0000001e47477220ULL, 0x080fe20000410000ULL,
0x0000001e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000001e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000001e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000001e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000001e52527220ULL, 0x080fe20000410000ULL, 0x0000001e53537220ULL, 0x080fe20000410000ULL,
0x0000001e56567220ULL, 0x080fe20000410000ULL, 0x0000001e57577220ULL, 0x080fe20000410000ULL,
0x0000001e5a5a7220ULL, 0x080fe20000410000ULL, 0x0000001e5b5b7220ULL, 0x080fe20000410000ULL,
0x0000001e5e5e7220ULL, 0x080fe20000410000ULL, 0x0000001e5f5f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006766ff7212ULL, 0x000fe400078030ffULL,
0x0000001b641b7209ULL, 0x000fd60007810000ULL, 0x8000001b64640221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b64640820ULL, 0x000fc80000410000ULL, 0x0000006400120308ULL, 0x000e640000000800ULL,
0x0000001265650220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001d651d7221ULL, 0x000fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000012ff0e723eULL, 0x000fe400000010ffULL,
0x00000002ff137819ULL, 0x000fe40000011600ULL, 0x000054100e0e7816ULL, 0x000fe2000000000eULL,
0x000101c27f007947ULL, 0x000fea000b800000ULL, 0x00001f130e117589ULL, 0x0002a400000e0000ULL,
0x00000008131e7810ULL, 0x000fe20007ffe0ffULL, 0x000101f27f007947ULL, 0x000fea000b800000ULL,
0x00000010130f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1e0e107589ULL, 0x00066a00000e0000ULL,
0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL, 0x00000018131e7810ULL, 0x008fe20007ffe0ffULL,
0x000102427f007947ULL, 0x000fea000b800000ULL, 0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL,
0x000000039a137811ULL, 0x000fe200078ff0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000f0001c1c7810ULL, 0x000fe20007ffe0ffULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000a00013137811ULL, 0x000fc600078e60ffULL, 0x000000100a707824ULL, 0x100fe200078e021cULL,
0x000000130c0c7211ULL, 0x000fe200078e20ffULL, 0x000000100d0d7824ULL, 0x000fe400078e0213ULL,
0x000000100b6c7824ULL, 0x100fe400078e021cULL, 0x000000000c64783bULL, 0x0002e20000000200ULL,
0x0000001009687824ULL, 0x000fc600078e021cULL, 0x000000000d74783bULL, 0x0002a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001174747231ULL, 0x084fe400003400ffULL,
0x0000001176767231ULL, 0x000fe400003400ffULL, 0x0000001075757231ULL, 0x080fe400003400ffULL,
0x0000001077777231ULL, 0x000fe400003400ffULL, 0x0000000f64647231ULL, 0x088fe400003400ffULL,
0x0000000f66667231ULL, 0x000fc400003400ffULL, 0x0000000e65657231ULL, 0x080fe400003400ffULL,
0x0000000e67677231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008087824ULL, 0x100fe200078e021cULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x0000001006067824ULL, 0x100fe200078e0213ULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x00000010050c7824ULL, 0x102fe200078e021cULL, 0x000000006c6c783bULL, 0x000fe20000004200ULL,
0x00000010040d7824ULL, 0x100fe400078e021cULL, 0x0000001003037824ULL, 0x000fe200078e021cULL,
0x000000000808783bULL, 0x000e680000004200ULL, 0x000000006868783bULL, 0x000ee20000004200ULL,
0x000000707460723cULL, 0x044f700000041860ULL, 0x000000087438723cULL, 0x082f700000041838ULL,
0x000000086458723cULL, 0x008b6e0000041858ULL, 0x0000001007087824ULL, 0x020fe200078e0213ULL,
0x0000000a743c723cULL, 0x080f62000004183cULL, 0x000000000604783bULL, 0x000e6e0000000200ULL,
0x0000000a645c723cULL, 0x000b64000004185cULL, 0x000000000808783bULL, 0x020eac0000000200ULL,
0x000000727424723cULL, 0x040b700000041824ULL, 0x0000006c7428723cULL, 0x040b700000041828ULL,
0x0000006e742c723cULL, 0x040b70000004182cULL, 0x000000687430723cULL, 0x040b700000041830ULL,
0x0000006a7434723cULL, 0x000b700000041834ULL, 0x000000706440723cULL, 0x040b700000041840ULL,
0x000000726444723cULL, 0x040b700000041844ULL, 0x0000006c6448723cULL, 0x040b700000041848ULL,
0x0000006e644c723cULL, 0x040b70000004184cULL, 0x000000686450723cULL, 0x040b700000041850ULL,
0x0000006a6454723cULL, 0x000b620000041854ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000001108087231ULL, 0x086fe400003400ffULL,
0x000000110a0a7231ULL, 0x000fc400003400ffULL, 0x0000001009097231ULL, 0x080fe400003400ffULL,
0x000000100b0b7231ULL, 0x000fe400003400ffULL, 0x0000000f04047231ULL, 0x080fe400003400ffULL,
0x0000000f06067231ULL, 0x000fe400003400ffULL, 0x0000000e05057231ULL, 0x080fe400003400ffULL,
0x0000000e07077231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000001002027824ULL, 0x000fe200078e021cULL, 0x000000000c64783bULL, 0x020e680000004200ULL,
0x000000000d68783bULL, 0x000ea80000004200ULL, 0x00000000036c783bULL, 0x000ee80000004200ULL,
0x000000000270783bULL, 0x0002a40000004200ULL, 0x00000002ff027819ULL, 0x002fc8000001169aULL,
0x000166a002027811ULL, 0x000fe200078e18ffULL, 0x000000640860723cULL, 0x040b700000041860ULL,
0x000000660824723cULL, 0x040b700000041824ULL, 0x000000680828723cULL, 0x044b700000041828ULL,
0x0000006a082c723cULL, 0x040b70000004182cULL, 0x0000006c0830723cULL, 0x048b700000041830ULL,
0x0000006e0834723cULL, 0x040b700000041834ULL, 0x000000700838723cULL, 0x040b700000041838ULL,
0x00000072083c723cULL, 0x000b70000004183cULL, 0x000000640440723cULL, 0x040b700000041840ULL,
0x000000660444723cULL, 0x040b700000041844ULL, 0x000000680448723cULL, 0x040b700000041848ULL,
0x0000006a044c723cULL, 0x040b70000004184cULL, 0x0000006c0450723cULL, 0x040b700000041850ULL,
0x0000006e0454723cULL, 0x040b700000041854ULL, 0x000000700458723cULL, 0x040b700000041858ULL,
0x00000072045c723cULL, 0x000b62000004185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000229500720cULL, 0x000fe20003f06070ULL, 0x0000000002ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff813000007947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x020e640000002500ULL, 0x000000220500720cULL, 0x002fda0003f06070ULL,
0x0000057000000947ULL, 0x000fea0003800000ULL, 0x018000001d007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e001dULL, 0x00009fb000087802ULL, 0x000fc40000000f00ULL,
0x0000fee000007944ULL, 0x010fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001d00007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc8000000001dULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x00000002ff077819ULL, 0x002fe40000011603ULL, 0x00000018030d7811ULL, 0x040fe400078ff0ffULL,
0x0000000803097811ULL, 0x040fe200078ff0ffULL, 0x00001f0700027589ULL, 0x008e6200000e0000ULL,
0x00000010030b7811ULL, 0x000fc600078ff0ffULL, 0x00001f0d00067589ULL, 0x000ea800000e0000ULL,
0x00001f0900037589ULL, 0x000ee800000e0000ULL, 0x00001f0b00047589ULL, 0x000ea200000e0000ULL,
0x0000006002607220ULL, 0x042fe20000410000ULL, 0x0000006102617220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002502257220ULL, 0x040fe20000410000ULL,
0x0000002802287220ULL, 0x040fe20000410000ULL, 0x0000002902297220ULL, 0x040fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000002d022d7220ULL, 0x040fe20000410000ULL,
0x0000003002307220ULL, 0x040fe20000410000ULL, 0x0000003102317220ULL, 0x040fe20000410000ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000003802387220ULL, 0x040fe20000410000ULL, 0x0000003902397220ULL, 0x040fe20000410000ULL,
0x0000003c023c7220ULL, 0x040fe20000410000ULL, 0x0000003d023d7220ULL, 0x000fe20000410000ULL,
0x0000004206427220ULL, 0x044fe20000410000ULL, 0x0000004306437220ULL, 0x040fe20000410000ULL,
0x0000004606467220ULL, 0x040fe20000410000ULL, 0x0000004706477220ULL, 0x040fe20000410000ULL,
0x0000004a064a7220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000004e064e7220ULL, 0x040fe20000410000ULL, 0x0000004f064f7220ULL, 0x040fe20000410000ULL,
0x0000005206527220ULL, 0x040fe20000410000ULL, 0x0000005306537220ULL, 0x040fe20000410000ULL,
0x0000005606567220ULL, 0x040fe20000410000ULL, 0x0000005706577220ULL, 0x040fe20000410000ULL,
0x0000005a065a7220ULL, 0x040fe20000410000ULL, 0x0000005b065b7220ULL, 0x040fe20000410000ULL,
0x0000005e065e7220ULL, 0x040fe20000410000ULL, 0x0000005f065f7220ULL, 0x000fe20000410000ULL,
0x0000000362627220ULL, 0x088fe20000410000ULL, 0x0000000363637220ULL, 0x080fe20000410000ULL,
0x0000000326267220ULL, 0x080fe20000410000ULL, 0x0000000327277220ULL, 0x080fe20000410000ULL,
0x000000032a2a7220ULL, 0x080fe20000410000ULL, 0x000000032b2b7220ULL, 0x080fe20000410000ULL,
0x000000032e2e7220ULL, 0x080fe20000410000ULL, 0x000000032f2f7220ULL, 0x080fe20000410000ULL,
0x0000000332327220ULL, 0x080fe20000410000ULL, 0x0000000333337220ULL, 0x080fe20000410000ULL,
0x0000000336367220ULL, 0x080fe20000410000ULL, 0x0000000337377220ULL, 0x080fe20000410000ULL,
0x000000033a3a7220ULL, 0x080fe20000410000ULL, 0x000000033b3b7220ULL, 0x080fe20000410000ULL,
0x000000033e3e7220ULL, 0x080fe20000410000ULL, 0x000000033f3f7220ULL, 0x000fe20000410000ULL,
0x0000000440407220ULL, 0x080fe20000410000ULL, 0x0000000441417220ULL, 0x080fe20000410000ULL,
0x0000000444447220ULL, 0x080fe20000410000ULL, 0x0000000445457220ULL, 0x080fe20000410000ULL,
0x0000000448487220ULL, 0x080fe20000410000ULL, 0x0000000449497220ULL, 0x080fe20000410000ULL,
0x000000044c4c7220ULL, 0x080fe20000410000ULL, 0x000000044d4d7220ULL, 0x080fe20000410000ULL,
0x0000000450507220ULL, 0x080fe20000410000ULL, 0x0000000451517220ULL, 0x080fe20000410000ULL,
0x0000000454547220ULL, 0x080fe20000410000ULL, 0x0000000455557220ULL, 0x080fe20000410000ULL,
0x0000000458587220ULL, 0x080fe20000410000ULL, 0x0000000459597220ULL, 0x080fe20000410000ULL,
0x000000045c5c7220ULL, 0x080fe20000410000ULL, 0x000000045d5d7220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000262726723eULL, 0x000fc400000010ffULL,
0x0000002c2d08723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000242506723eULL, 0x000fe400000010ffULL, 0x0000002a2b2a723eULL, 0x000fe400000010ffULL,
0x000000282907723eULL, 0x000fc400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe400000010ffULL,
0x000000606104723eULL, 0x000fe400000010ffULL, 0x000000303109723eULL, 0x000fe400000010ffULL,
0x00000034350a723eULL, 0x000fe400000010ffULL, 0x00000002ff1a7819ULL, 0x002fe40000011600ULL,
0x00000008002d7811ULL, 0x000fc400078ff0ffULL, 0x000000011a027810ULL, 0x040fe20007ffe0ffULL,
0x000000081a1f7824ULL, 0x040fe200078e00ffULL, 0x000000021a037810ULL, 0x040fe20007ffe0ffULL,
0x000000081a1c7824ULL, 0x040fe200078e00ffULL, 0x000000031a167810ULL, 0x040fe20007ffe0ffULL,
0x000000081a237824ULL, 0x040fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee202ULL,
0x000000081a1e7824ULL, 0x040fe200078e00ffULL, 0x000000041a197810ULL, 0x050fe20007ffe0ffULL,
0x000000081a277824ULL, 0x040fe200078e00ffULL, 0x000000051a027810ULL, 0x040fe20007ffe0ffULL,
0x000000081a2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c217812ULL, 0x000fc400078ee203ULL,
0x000000061a037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823237812ULL, 0x000fe400078ee216ULL,
0xfffffff81e257812ULL, 0x000fe200078ee219ULL, 0x000000081a197824ULL, 0x040fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee202ULL, 0x000000082d027824ULL, 0x000fe200078e00ffULL,
0xffffffff1a167810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81c297812ULL, 0x000fe200078ee203ULL,
0x0000200015037824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fc400078ee216ULL,
0xfffffff819197812ULL, 0x000fe400078ee21aULL, 0xfffffff8022d7812ULL, 0x000fe200078ee22dULL,
0x0000100018027824ULL, 0x000fe200078e0203ULL, 0x0000000200167819ULL, 0x040fe400000006ffULL,
0x00000010002f7811ULL, 0x000fe200078ff0ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x0000001800317811ULL, 0x000fe200078ff0ffULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x00000038390b723eULL, 0x000fe200000010ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x0000003c3d0c723eULL, 0x000fe200000010ffULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x000000626362723eULL, 0x000fe200000010ffULL, 0x0000000119197824ULL, 0x000fe200078e0216ULL,
0x000000323332723eULL, 0x000fe200000010ffULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x000000363736723eULL, 0x000fe200000010ffULL, 0x00000001161f7824ULL, 0x040fe200078e021fULL,
0x0000000419007388ULL, 0x0003e20000000800ULL, 0x000000082f1a7824ULL, 0x000fe200078e00ffULL,
0x0000003a3b3a723eULL, 0x000fe200000010ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x000000061f007388ULL, 0x000fe20000000800ULL, 0x0000000116217824ULL, 0x000fe200078e0221ULL,
0xfffffff81a2f7812ULL, 0x000fe200078ee22fULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x0000003e3f3e723eULL, 0x000fe200000010ffULL, 0x0000000116237824ULL, 0x040fe200078e0223ULL,
0x0000000721007388ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x000000404140723eULL, 0x000fe200000010ffULL, 0x0000000116257824ULL, 0x040fe200078e0225ULL,
0x0000000823007388ULL, 0x000fe20000000800ULL, 0x0000000116277824ULL, 0x040fe200078e0227ULL,
0x000000444544723eULL, 0x000fe200000010ffULL, 0x0000000116297824ULL, 0x040fe200078e0229ULL,
0x0000000925007388ULL, 0x000fe20000000800ULL, 0x00000001162b7824ULL, 0x040fe200078e022bULL,
0x000000484948723eULL, 0x000fe200000010ffULL, 0x00000001162d7824ULL, 0x000fe200078e022dULL,
0x0000000a27007388ULL, 0x0005e20000000800ULL, 0x00000008311c7824ULL, 0x000fe200078e00ffULL,
0x0000004c4d4c723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0202ULL,
0x0000000b29007388ULL, 0x000fe20000000800ULL, 0x000000505150723eULL, 0x000fe200000010ffULL,
0x000000ff00047306ULL, 0x002fe20000205400ULL, 0xfffffff81c317812ULL, 0x000fe200078ee231ULL,
0x0000000c2b007388ULL, 0x000fe20000000800ULL, 0x00000001162f7824ULL, 0x000fe200078e022fULL,
0x000000545554723eULL, 0x000fe200000010ffULL, 0x00000001170a7824ULL, 0x004fe200078e0200ULL,
0x000000622d007388ULL, 0x000fe20000000800ULL, 0x0000001031317824ULL, 0x000fe200078e0202ULL,
0x000000585958723eULL, 0x000fe200000010ffULL, 0x000000100a097824ULL, 0x000fe200078e0203ULL,
0x000400261f007388ULL, 0x000fe20000000800ULL, 0x0000005c5d5c723eULL, 0x000fe200000010ffULL,
0x000000ff00077306ULL, 0x000e620000209400ULL, 0x00000042430d723eULL, 0x000fe200000010ffULL,
0x0004002a21007388ULL, 0x000fe20000000800ULL, 0x0000003116167210ULL, 0x000fe20007ffe0ffULL,
0x00000300ff1c7624ULL, 0x000fe200078e00ffULL, 0x00000046470e723eULL, 0x000fe200000010ffULL,
0x0004002e23007388ULL, 0x000fe20000000800ULL, 0x0000004a4b0f723eULL, 0x000fc400000010ffULL,
0x0000004e4f10723eULL, 0x000fe200000010ffULL, 0x0004003225007388ULL, 0x000fe20000000800ULL,
0x000000525311723eULL, 0x000fe400000010ffULL, 0x000000565712723eULL, 0x000fe200000010ffULL,
0x0004003627007388ULL, 0x000fe20000000800ULL, 0x0000005a5b13723eULL, 0x000fe400000010ffULL,
0x0000005e5f14723eULL, 0x000fe200000010ffULL, 0x0004003a29007388ULL, 0x000fe20000000800ULL,
0x000000040700720bULL, 0x002fc40003f1d000ULL, 0x000000ff00047245ULL, 0x000fe2000020d400ULL,
0x0004003e2b007388ULL, 0x000fe80000000800ULL, 0x000000402f007388ULL, 0x000fe80000000800ULL,
0x000800441f007388ULL, 0x000fe40000000800ULL, 0x0000000104040812ULL, 0x000fc400078efcffULL,
0x0008004821007388ULL, 0x000fe20000000800ULL, 0x000000011c00780cULL, 0x000fc60003f05270ULL,
0x0008004c23007388ULL, 0x000fe80000000800ULL, 0x0008005025007388ULL, 0x000fe80000000800ULL,
0x0008005427007388ULL, 0x000fe80000000800ULL, 0x0008005829007388ULL, 0x000fe80000000800ULL,
0x0008005c2b007388ULL, 0x000fe80000000800ULL, 0x0000000d16007388ULL, 0x0003e80000000800ULL,
0x000c000e1f007388ULL, 0x000fe80000000800ULL, 0x000c000f21007388ULL, 0x000fe20000000800ULL,
0x000000040416723eULL, 0x002fc600000010ffULL, 0x000c001023007388ULL, 0x000fe80000000800ULL,
0x000c001125007388ULL, 0x000fe80000000800ULL, 0x000c001227007388ULL, 0x000fe80000000800ULL,
0x000c001329007388ULL, 0x000fe80000000800ULL, 0x000c00142b007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000092c7984ULL, 0x000e680000000c00ULL,
0x0004000009207984ULL, 0x000ea80000000c00ULL, 0x0008000009247984ULL, 0x000ee80000000c00ULL,
0x000c000009347984ULL, 0x000ee80000000c00ULL, 0x00100000090c7984ULL, 0x000ee80000000c00ULL,
0x0014000009307984ULL, 0x000ee80000000c00ULL, 0x0018000009107984ULL, 0x000ee80000000c00ULL,
0x001c000009287984ULL, 0x000ee20000000c00ULL, 0x3f803f80162f7831ULL, 0x002fc4000020002fULL,
0x3f803f80162e7831ULL, 0x040fe4000020002eULL, 0x3f803f80162d7831ULL, 0x040fe4000020002dULL,
0x3f803f80162c7831ULL, 0x040fe4000020002cULL, 0x3f803f8016237831ULL, 0x044fe40000200023ULL,
0x3f803f8016227831ULL, 0x040fe40000200022ULL, 0x3f803f8016217831ULL, 0x000fc40000200021ULL,
0x3f803f8016207831ULL, 0x040fe40000200020ULL, 0x3f803f8016277831ULL, 0x048fe40000200027ULL,
0x3f803f8016267831ULL, 0x040fe40000200026ULL, 0x3f803f8016257831ULL, 0x040fe40000200025ULL,
0x3f803f8016247831ULL, 0x040fe40000200024ULL, 0x3f803f8016377831ULL, 0x000fc40000200037ULL,
0x3f803f8016367831ULL, 0x040fe40000200036ULL, 0x3f803f8016357831ULL, 0x040fe40000200035ULL,
0x3f803f8016347831ULL, 0x000fe40000200034ULL, 0x3f803f802f2f7831ULL, 0x000fe4000020000fULL,
0x3f803f802e2e7831ULL, 0x000fe4000020000eULL, 0x3f803f802d2d7831ULL, 0x000fc4000020000dULL,
0x3f803f802c2c7831ULL, 0x000fe4000020000cULL, 0x3f803f8023237831ULL, 0x000fe40000200033ULL,
0x3f803f8022227831ULL, 0x000fe20000200032ULL, 0x0000002c09007388ULL, 0x000fe20000000c00ULL,
0x3f803f8021217831ULL, 0x000fe40000200031ULL, 0x3f803f8020207831ULL, 0x000fe40000200030ULL,
0x3f803f8027277831ULL, 0x000fc40000200013ULL, 0x3f803f8026267831ULL, 0x000fe20000200012ULL,
0x0004002009007388ULL, 0x000fe20000000c00ULL, 0x3f803f8025257831ULL, 0x000fe40000200011ULL,
0x3f803f8024247831ULL, 0x000fe40000200010ULL, 0x3f803f8037377831ULL, 0x000fe4000020002bULL,
0x3f803f8036367831ULL, 0x000fe2000020002aULL, 0x0008002409007388ULL, 0x000fe20000000c00ULL,
0x3f803f8035357831ULL, 0x000fc40000200029ULL, 0x3f803f8034347831ULL, 0x000fca0000200028ULL,
0x000c003409007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000039a000008947ULL, 0x000fea0003800000ULL, 0x00000400ff067624ULL, 0x000fe200078e00ffULL,
0x0000000000147919ULL, 0x000e620000002600ULL, 0x000000400a0d7810ULL, 0x000fc40007ffe0ffULL,
0x00006c0006067a24ULL, 0x000fe200078e02ffULL, 0x00000000000b7919ULL, 0x000e620000002700ULL,
0x000000800a0f7810ULL, 0x000fc60007ffe0ffULL, 0x0000000f06077811ULL, 0x040fe200078e10ffULL,
0x0000030006067a24ULL, 0x000fe200078e02ffULL, 0x0000000009207984ULL, 0x000ea40000000c00ULL,
0xfffffff0074f7812ULL, 0x000fe400078ec0ffULL, 0x0004000009247984ULL, 0x000ee60000000c00ULL,
0x0000008006197824ULL, 0x040fe200078e024fULL, 0x0008000009287984ULL, 0x000ea60000000c00ULL,
0x0000008006067824ULL, 0x000fe200078e0219ULL, 0x000c0000092c7984ULL, 0x0008a80000000c00ULL,
0x0000007f06067810ULL, 0x000fe20007ffe0ffULL, 0x000004000b147a24ULL, 0x002fc600078e0214ULL,
0xffffff8006167812ULL, 0x000fe200078ec0ffULL, 0x0000030014087a24ULL, 0x000fe200078e02ffULL,
0x000000c00a097810ULL, 0x010fe40007ffe0ffULL, 0x0000700016067a10ULL, 0x000fe20007f1e0ffULL,
0x0000000108057824ULL, 0x000fc800078e0205ULL, 0x00007100ff0c7624ULL, 0x000fe200000e06ffULL,
0x0000000605067211ULL, 0x040fe400078268ffULL, 0x0000000118ff7812ULL, 0x000fe4000780f89aULL,
0x0000000c05077211ULL, 0x000fe400008f6cffULL, 0x000070004f1f7a10ULL, 0x000fc60007f3e0ffULL,
0x0000100015067825ULL, 0x000fc800078e0006ULL, 0x00007100ff1a7624ULL, 0x000fe400008e06ffULL,
0x000000100a0a7825ULL, 0x000fc800078e0006ULL, 0x000000100d0c7825ULL, 0x000fc800078e0006ULL,
0x000000100f0e7825ULL, 0x000fc800078e0006ULL, 0x0000001009067825ULL, 0x000fe200078e0006ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x0000001000097824ULL, 0x00cfe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x0000008005107824ULL, 0x000fe200078e00ffULL,
0x00000019ff057819ULL, 0x000fe40000011605ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c11117812ULL, 0x000fe400078ec0ffULL, 0x0000700010127a10ULL, 0x000fc40007ebe019ULL,
0x0000001f09107210ULL, 0x000fe40007a3e010ULL, 0x0000001211127210ULL, 0x000fe40007c7e009ULL,
0x0000710005097a10ULL, 0x000fe40002fec4ffULL, 0x0000001011107210ULL, 0x000fe40007fbe0ffULL,
0x0000001aff057210ULL, 0x000fe40000fe4405ULL, 0x00000009ff137210ULL, 0x000fc60001fe84ffULL,
0x000000ffff117224ULL, 0x000fca00028e0605ULL, 0x0000001b10007986ULL, 0x0003e8000c101906ULL,
0x0000001d12007986ULL, 0x0003e4000c101906ULL, 0x000000ff0000720cULL, 0x00cfe20000705670ULL,
0x000000200a007986ULL, 0x000fe2000c101d06ULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000240c007986ULL, 0x000fe8000c101d06ULL, 0x000000280e007986ULL, 0x000fe8000c101d06ULL,
0x0000002c06007986ULL, 0x000fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0xffffffff1c057810ULL, 0x000fc60007ffe0ffULL, 0x0000700014067625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000005060679a8ULL, 0x000ea400099ee1c6ULL,
0x000000050600720cULL, 0x004fc80003f05270ULL, 0x00000001ff097807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000009ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff057984ULL, 0x000ee40000000000ULL, 0x000000ff0500720cULL, 0x008fda0003f05270ULL,
0x000034a000008947ULL, 0x000fea0003800000ULL, 0x000000ff9a00720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x004fe40000011600ULL, 0x0000001f08067211ULL, 0x040fe400078038ffULL,
0x0000007005077812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fe400078ec0ffULL,
0x0000001a08057211ULL, 0x000fe400000f3cffULL, 0x0000000609067210ULL, 0x000fc8000791e007ULL,
0x00000005ff077210ULL, 0x000fca00007e24ffULL, 0x0000000606057981ULL, 0x000528000c1e1900ULL,
0x00008006060a7981ULL, 0x000522000c1e1900ULL, 0x000000021c00780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010006060c7981ULL, 0x004522000c1e1900ULL,
0x000000041c00780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x00018006060e7981ULL, 0x004522000c1e1900ULL, 0x000000041c00780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000606107981ULL, 0x006322000c1e1900ULL,
0x000000061c00780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800606127981ULL, 0x002322000c1e1900ULL, 0x000000061c00780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081c00780cULL, 0x002fe20003f06070ULL,
0x0003000606147981ULL, 0x000318000c1e1900ULL, 0x00038006061a0981ULL, 0x000324000c1e1900ULL,
0x000000071c067810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff097819ULL, 0x000fc80000011606ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x0000004f080b7211ULL, 0x040fe200078038ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1c7224ULL, 0x010fe200078e0005ULL,
0x000070000b0b7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff080d7211ULL, 0x000fe400000f3cffULL,
0x000007800b0b7810ULL, 0x000fc80007f5e0ffULL, 0x00007100ff0d7a10ULL, 0x000fc400017e240dULL,
0x000003000f007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000409007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080f067810ULL, 0x040fe40007ffe0ffULL, 0x000000010f077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001c05057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0xfffc8006061c7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090f067810ULL, 0x042fe40007ffe0ffULL, 0x000000020f077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000a05057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0xfffd0006060a7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f067810ULL, 0x042fe40007ffe0ffULL, 0x000000030f077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000c05057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0xfffd8006060c7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0f067810ULL, 0x042fe40007ffe0ffULL, 0x000000040f077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000e05057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000000400067819ULL, 0x000fe400000006ffULL, 0x00000001ff077819ULL, 0x000fe40000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0xfffe0006060e7981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f067810ULL, 0x042fe40007ffe0ffULL, 0x000000050f077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001005057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0xfffe800606107981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0f067810ULL, 0x042fe40007ffe0ffULL, 0x000000060f077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001205057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0xffff000606127981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f067810ULL, 0x042fe40007ffe0ffULL, 0x000000070f077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001405057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0xffff800606147981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0f067810ULL, 0x002fe40007ffe0ffULL, 0x0000001a05057209ULL, 0x000fe40007810000ULL,
0x0000030006007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000060b067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060dULL,
0x00000006061a7981ULL, 0x000326000c1e1900ULL, 0x000004000b0b7810ULL, 0x000fe40007f3e0ffULL,
0x000000080f0f7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000067824ULL, 0x006fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000106067824ULL, 0x000fca00078e0207ULL, 0x0000000506007388ULL, 0x0103e40000000800ULL,
0x000000070000780cULL, 0x000fe20003f04070ULL, 0x0000000118147824ULL, 0x000fe200078e0208ULL,
0x00000002ff097819ULL, 0x004fe2000001169aULL, 0x0000100015057824ULL, 0x002fe200078e00ffULL,
0x0000700016067a10ULL, 0x000fe20007f3e0ffULL, 0x0000001000537824ULL, 0x000fe200078e00ffULL,
0x0000000109097812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002180c8824ULL, 0x000fe200078e0215ULL, 0x00000020000f7810ULL, 0x040fe20007ffe0ffULL,
0x00007100ff077624ULL, 0x000fe200008e06ffULL, 0x0000004000117810ULL, 0x000fe20007ffe0ffULL,
0x000000020c258824ULL, 0x000fe200078e0209ULL, 0x0000006000137810ULL, 0x000fe20007ffe0ffULL,
0x00000002180e8824ULL, 0x000fe200078e0215ULL, 0x00000080001b7810ULL, 0x000fe20007ffe0ffULL,
0x000004009a0c7824ULL, 0x000fe200078e00ffULL, 0x000000a0001d7810ULL, 0x000fe20007ffe0ffULL,
0x00002000140a7825ULL, 0x000fe200078e0006ULL, 0x000000c0001f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000010000c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000020e298824ULL, 0x000fe200078e0209ULL, 0x0000000318097211ULL, 0x000fe200078e70ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000050a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000829298824ULL, 0x000fe200078e0200ULL, 0x000000e000217810ULL, 0x040fe20007ffe0ffULL,
0x00000001090d7824ULL, 0x000fe200078e020cULL, 0x00000001ff527819ULL, 0x000fe20000011600ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000007053537812ULL, 0x000fe200078ec0ffULL,
0x0000001000277824ULL, 0x000fe200078e020dULL, 0x0000000c52527812ULL, 0x000fe200078ec0ffULL,
0x000000100f0e7825ULL, 0x100fe200078e000aULL, 0x000070004f4f7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001011107825ULL, 0x100fe200078e000aULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000001013127825ULL, 0x100fe200078e000aULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000101b1a7825ULL, 0x100fe200078e000aULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000aULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000101f1e7825ULL, 0x000fe200078e000aULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fc4000001ff00ULL, 0x0000001021207825ULL, 0x000fc800078e000aULL,
0x00000010000c7825ULL, 0x000fe200078e000aULL, 0x00007000190b7a10ULL, 0x000fc60007f3e0ffULL,
0x0000000153167824ULL, 0x000fe400078e0252ULL, 0x00007100ff507624ULL, 0x000fe200008e06ffULL,
0x0000000b14228211ULL, 0x040fe200078238ffULL, 0x00007100ff517624ULL, 0x000fe200010e06ffULL,
0x0000004f14248211ULL, 0x040fe200078438ffULL, 0x0000000825198824ULL, 0x000fe200078e0200ULL,
0x0000005014238211ULL, 0x000fe200008f3cffULL, 0x00000000160a7984ULL, 0x0002a20000000800ULL,
0x0000030018007a0cULL, 0x000fe20003f26070ULL, 0x000000ffff4e7224ULL, 0x000fe200078e00ffULL,
0x0000005114258211ULL, 0x000fe200010f3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c277faeULL, 0x0007e2000b901c46ULL, 0x0000858019198811ULL, 0x000fe200078e20ffULL,
0x000000ffff147224ULL, 0x000fc400078e00ffULL, 0x003800000e277faeULL, 0x0009e2000b901c46ULL,
0x000000ffff167224ULL, 0x002fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fe200078e00ffULL,
0x0058000010277faeULL, 0x0003e8000b901c46ULL, 0x0078000012277faeULL, 0x0003e2000b901c46ULL,
0x00000000000c7805ULL, 0x008fc6000001ff00ULL, 0x009800001a277faeULL, 0x0007e2000b901c46ULL,
0x00000000000e7805ULL, 0x010fe2000001ff00ULL, 0x0000001000108825ULL, 0x042fe200078e0022ULL,
0x0000818029238811ULL, 0x000fe200078e20ffULL, 0x00b800001c277faeULL, 0x0003e2000b901c46ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000001000128825ULL, 0x000fe400078e0024ULL,
0x00d800001e277faeULL, 0x0009e2000b901c46ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x008fc4000001ff00ULL, 0x00f8000020277faeULL, 0x0007e8000b901c46ULL,
0x0000000010198faeULL, 0x0005e2000b901c46ULL, 0x00000000001c7805ULL, 0x002fc6000001ff00ULL,
0x0000000012238faeULL, 0x0003e2000b901c46ULL, 0x00000000001e7805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x002fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000130000001947ULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff687224ULL, 0x000fca00078e0018ULL,
0x0000000268557810ULL, 0x000fc80007ffe0ffULL, 0x0000030055007a0cULL, 0x000fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f44070ULL,
0x00000001086a7824ULL, 0x100fe200078e0255ULL, 0x00000001ff567819ULL, 0x000fe40000011655ULL,
0x0000002000597810ULL, 0x000fe20007ffe0ffULL, 0x000020006a527825ULL, 0x000fe200078e0006ULL,
0x0000000156577812ULL, 0x000fe400078ec0ffULL, 0x00000040005b7810ULL, 0x000fe20007ffe0ffULL,
0x0000080055567824ULL, 0x000fe200078e00ffULL, 0x0000000552527210ULL, 0x000fc40007f1e0ffULL,
0x00000060005d7810ULL, 0x000fe20007ffe0ffULL, 0x000000021858a824ULL, 0x100fe200078e0215ULL,
0x0000100056567812ULL, 0x000fe200078ec0ffULL, 0x00000002185aa824ULL, 0x000fe200078e0215ULL,
0x00000053ff537210ULL, 0x000fe200007fe4ffULL, 0x00000002586ba824ULL, 0x100fe200078e0257ULL,
0x00000080005f7810ULL, 0x000fe20007ffe0ffULL, 0x000000025a6da824ULL, 0x000fe200078e0257ULL,
0x000000a000617810ULL, 0x040fe20007ffe0ffULL, 0x0000000109577824ULL, 0x000fe200078e0256ULL,
0x000000c000637810ULL, 0x040fe20007ffe0ffULL, 0x0000001059587825ULL, 0x000fe200078e0052ULL,
0x000000e000657810ULL, 0x000fc40007ffe0ffULL, 0x0000000b6a64a211ULL, 0x000fe200078038ffULL,
0x0000001000697824ULL, 0x000fe200078e0257ULL, 0x0000004f6a66a211ULL, 0x000fe200078238ffULL,
0x0000001000567825ULL, 0x000fc600078e0052ULL, 0x000000516a67a211ULL, 0x040fe200008f3cffULL,
0x000000105b5a7825ULL, 0x100fe200078e0052ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000056697faeULL, 0x0003e6000b901c46ULL, 0x000000105d5c7825ULL, 0x100fe200078e0052ULL,
0x0038000058697faeULL, 0x0005e6000b901c46ULL, 0x000000105f5e7825ULL, 0x100fe200078e0052ULL,
0x005800005a697faeULL, 0x0007e6000b901c46ULL, 0x0000001061607825ULL, 0x100fe200078e0052ULL,
0x007800005c697faeULL, 0x0007e6000b901c46ULL, 0x0000001063627825ULL, 0x100fe200078e0052ULL,
0x009800005e697faeULL, 0x0007e6000b901c46ULL, 0x0000001065527825ULL, 0x000fe200078e0052ULL,
0x000000506a65a211ULL, 0x000fe200000f3cffULL, 0x00b8000060697faeULL, 0x0007e4000b901c46ULL,
0x000000086b6ba824ULL, 0x000fc400078e0200ULL, 0x000000086d6da824ULL, 0x000fe200078e0200ULL,
0x00d8000062697faeULL, 0x0007e2000b901c46ULL, 0x000000100064a825ULL, 0x040fe200078e0064ULL,
0x000085806b6ba811ULL, 0x000fe400078e20ffULL, 0x000081806d59a811ULL, 0x004fe200078e20ffULL,
0x000000100056a825ULL, 0x002fe200078e0066ULL, 0x00f8000052697faeULL, 0x0007e8000b901c46ULL,
0x00000000646bafaeULL, 0x0007e8000b901c46ULL, 0x000000005659afaeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000004068527824ULL, 0x008fe200078e00ffULL,
0x00000001ff587819ULL, 0x100fe20000011600ULL, 0x0000000218577824ULL, 0x000fe200078e0215ULL,
0x00000002ff5c7819ULL, 0x000fe20000011600ULL, 0x0000001000537824ULL, 0x000fe200078e00ffULL,
0x0000008052527812ULL, 0x000fc400078ec0ffULL, 0x000000085c6c7810ULL, 0x040fe20007ffe0ffULL,
0x000000085c617824ULL, 0x000fe200078e00ffULL, 0x0000007053537812ULL, 0x000fe200078ec0ffULL,
0x0000010057567824ULL, 0x000fe200078e0052ULL, 0x0000000c58527812ULL, 0x000fe200078ec0ffULL,
0x000000085c637824ULL, 0x040fe200078e00ffULL, 0x000000025c587810ULL, 0x040fe20007ffe0ffULL,
0x000000085c5b7824ULL, 0x000fe200078e00ffULL, 0x0000005652577210ULL, 0x000fe20007ffe053ULL,
0x000000085c657824ULL, 0x040fe200078e00ffULL, 0x000000015c567810ULL, 0x040fe20007ffe0ffULL,
0x000000085c677824ULL, 0x000fe200078e00ffULL, 0xfffffff863637812ULL, 0x000fe200078ee258ULL,
0x0000000400587824ULL, 0x000fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee256ULL,
0x0000080068567824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0081800057597984ULL, 0x000e620000000800ULL, 0x0000100056567812ULL, 0x000fe200078ec0ffULL,
0x000000085c6f7824ULL, 0x000fe200078e00ffULL, 0x0000000c58687812ULL, 0x000fe200078ec0ffULL,
0x00858000575f7984ULL, 0x0004e20000000800ULL, 0x0000018009567810ULL, 0x000fe20007ffe056ULL,
0x000000085c6d7824ULL, 0x040fe200078e00ffULL, 0x000000035c5a7810ULL, 0x040fe40007ffe0ffULL,
0x000000105c6e7810ULL, 0x040fe40007ffe0ffULL, 0x000000185c707810ULL, 0x000fc40007ffe0ffULL,
0xfffffff85b577812ULL, 0x004fe200078ee25cULL, 0x000000086c5b7824ULL, 0x000fe200078e00ffULL,
0xfffffff865657812ULL, 0x000fe200078ee25aULL, 0x000000086e5d7824ULL, 0x000fe200078e00ffULL,
0x000000045c607810ULL, 0x040fe20007ffe0ffULL, 0x0000001057577824ULL, 0x000fe200078e0256ULL,
0x000000055c627810ULL, 0x000fe20007ffe0ffULL, 0x0000000870697824ULL, 0x000fe200078e00ffULL,
0xfffffff867677812ULL, 0x000fe400078ee260ULL, 0x0000005768577210ULL, 0x000fc40007ffe0ffULL,
0x000000065c607810ULL, 0x040fe40007ffe0ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee262ULL,
0x00000000575e7984ULL, 0x0005220000000800ULL, 0xfffffff86f6f7812ULL, 0x000fe400078ee260ULL,
0xffffffff5c627810ULL, 0x000fe20007ffe0ffULL, 0x0000001063577824ULL, 0x004fe200078e0256ULL,
0x000000590a587221ULL, 0x002fe20000010100ULL, 0xfffffff85b597812ULL, 0x000fe400078ee26cULL,
0x0000000168577824ULL, 0x000fe200078e0257ULL, 0xfffffff85d5b7812ULL, 0x000fe200078ee26eULL,
0x3fb8aa3b58587820ULL, 0x000fe20000410000ULL, 0xfffffff8695d7812ULL, 0x000fe200078ee270ULL,
0x0000001059597824ULL, 0x000fc400078e0256ULL, 0x00000058005a7308ULL, 0x0002e20000000800ULL,
0x000000105b5b7824ULL, 0x100fe400078e0256ULL, 0x0000000168597824ULL, 0x040fe400078e0259ULL,
0x00000001685b7824ULL, 0x040fe400078e025bULL, 0x000000105d5d7824ULL, 0x100fe200078e0256ULL,
0x0000000059697984ULL, 0x0005e20000000800ULL, 0x0000001061587824ULL, 0x002fe400078e0256ULL,
0x00000001685d7824ULL, 0x040fe200078e025dULL, 0x000000005b6a7984ULL, 0x0003e20000000800ULL,
0x0000000168587824ULL, 0x000fe200078e0258ULL, 0x0000005f5a5f7220ULL, 0x008fc40000410000ULL,
0x000000005d6b7984ULL, 0x0007e20000000800ULL, 0x0000001065597824ULL, 0x004fe400078e0256ULL,
0x000000085c5b7824ULL, 0x002fe200078e00ffULL, 0x00001f5c5f607589ULL, 0x0002a200000e0000ULL,
0x0000000168597824ULL, 0x000fe200078e0259ULL, 0x000000545f547221ULL, 0x000fe20000010000ULL,
0x00000010675a7824ULL, 0x000fe200078e0256ULL, 0x00001f6c5f617589ULL, 0x000ea200000e0000ULL,
0xfffffff85b5d7812ULL, 0x008fe200078ee262ULL, 0x000000106d5b7824ULL, 0x000fc400078e0256ULL,
0x0000000058647984ULL, 0x000fe20000000800ULL, 0x00000001685a7824ULL, 0x040fe400078e025aULL,
0x000000106f5c7824ULL, 0x102fe200078e0256ULL, 0x0000000057657984ULL, 0x000fe20000000800ULL,
0x000000105d567824ULL, 0x000fe200078e0256ULL, 0x00005410ff5d7816ULL, 0x010fe2000000005eULL,
0x00000001685b7824ULL, 0x040fe200078e025bULL, 0x00001f6e5f627589ULL, 0x000e6200000e0000ULL,
0x00000001685c7824ULL, 0x040fe200078e025cULL, 0x00007610ff5e7816ULL, 0x000fe2000000005eULL,
0x0000000168567824ULL, 0x000fe200078e0256ULL, 0x0000000059667984ULL, 0x000fe80000000800ULL,
0x00001f705f637589ULL, 0x000ee200000e0000ULL, 0x000000605d4e7223ULL, 0x084fe2000001004eULL,
0x000000605e4d7223ULL, 0x000fe2000001004dULL, 0x00005410ff5d7816ULL, 0x000fe20000000069ULL,
0x000000005a677984ULL, 0x000ea20000000800ULL, 0x00005410ff5e7816ULL, 0x000fc6000000006aULL,
0x000000615d167223ULL, 0x080fe20000010016ULL, 0x00007610ff5d7816ULL, 0x000fe20000000069ULL,
0x000000005b687984ULL, 0x000f280000000800ULL, 0x000000615d447223ULL, 0x000fe20000010044ULL,
0x00007610ff5d7816ULL, 0x000fe2000000006aULL, 0x000000005c5f7984ULL, 0x000f220000000800ULL,
0x000000625e237223ULL, 0x002fe20000010023ULL, 0x00005410ff5e7816ULL, 0x000fc4000000006bULL,
0x000000625d3c7223ULL, 0x000fe2000001003cULL, 0x00007610ff5d7816ULL, 0x000fe2000000006bULL,
0x0000000056697984ULL, 0x000e620000000800ULL, 0x000000635e217223ULL, 0x088fe20000010021ULL,
0x00007610ff5e7816ULL, 0x000fe40000000064ULL, 0x000000635d347223ULL, 0x000fe20000010034ULL,
0x00005410ff5d7816ULL, 0x000fe20000000064ULL, 0x00040000586a7984ULL, 0x000ee20000000800ULL,
0x000000605e4b7223ULL, 0x000fe2000001004bULL, 0x00007610ff5e7816ULL, 0x000fc40000000065ULL,
0x000000605d4c7223ULL, 0x080fe2000001004cULL, 0x00005410ff5d7816ULL, 0x000fe20000000065ULL,
0x00040000576b7984ULL, 0x000ee20000000800ULL, 0x000000605e497223ULL, 0x080fe20000010049ULL,
0x00007610ff5e7816ULL, 0x000fe40000000066ULL, 0x000000605d4a7223ULL, 0x080fe2000001004aULL,
0x00005410ff5d7816ULL, 0x000fe20000000066ULL, 0x0004000059647984ULL, 0x000ee20000000800ULL,
0x000000605e477223ULL, 0x000fc60000010047ULL, 0x000000605d487223ULL, 0x080fe20000010048ULL,
0x00005410ff5d7816ULL, 0x104fe20000000067ULL, 0x000400005a657984ULL, 0x000ea80000000800ULL,
0x000000605d2e7223ULL, 0x000fe2000001002eULL, 0x00007610ff5d7816ULL, 0x000fe20000000067ULL,
0x000400005b667984ULL, 0x000ea20000000800ULL, 0x00005410ff5e7816ULL, 0x010fc60000000068ULL,
0x000000605d0e7223ULL, 0x080fe2000001000eULL, 0x00007610ff5d7816ULL, 0x000fe20000000068ULL,
0x000400005c677984ULL, 0x000f220000000800ULL, 0x000000605e2d7223ULL, 0x000fc6000001002dULL,
0x000000605d1a7223ULL, 0x000fe2000001001aULL, 0x00005410ff5d7816ULL, 0x000fe2000000005fULL,
0x0004000056687984ULL, 0x000f220000000800ULL, 0x00005410ff5e7816ULL, 0x002fc60000000069ULL,
0x000000605d2c7223ULL, 0x080fe2000001002cULL, 0x00007610ff5d7816ULL, 0x000fe2000000005fULL,
0x000000605e2b7223ULL, 0x080fe2000001002bULL, 0x00007610ff5e7816ULL, 0x000fe20000000069ULL,
0x00080000585f7984ULL, 0x000e640000000800ULL, 0x000000605d467223ULL, 0x080fe20000010046ULL,
0x00005410ff5d7816ULL, 0x008fe2000000006aULL, 0x000c000058697984ULL, 0x0007e20000000800ULL,
0x000000605e457223ULL, 0x000fc60000010045ULL, 0x000000615d2a7223ULL, 0x000fe2000001002aULL,
0x00007610ff5d7816ULL, 0x000fe2000000006bULL, 0x00080000575e7984ULL, 0x000e620000000800ULL,
0x00007610ff587816ULL, 0x008fc6000000006aULL, 0x000000615d427223ULL, 0x080fe20000010042ULL,
0x00005410ff5d7816ULL, 0x000fe20000000064ULL, 0x000c0000576a7984ULL, 0x0004e20000000800ULL,
0x0000006158437223ULL, 0x080fe20000010043ULL, 0x00005410ff587816ULL, 0x000fe4000000006bULL,
0x000000615d287223ULL, 0x080fe20000010028ULL, 0x000800005a607984ULL, 0x000fe40000000800ULL,
0x0000006158297223ULL, 0x000fe20000010029ULL, 0x00007610ff587816ULL, 0x000fe20000000064ULL,
0x00080000595d7984ULL, 0x000ee20000000800ULL, 0x00007610ff577816ULL, 0x004fc60000000065ULL,
0x0000006158417223ULL, 0x080fe20000010041ULL, 0x00005410ff587816ULL, 0x000fe20000000065ULL,
0x000c000059647984ULL, 0x000ea20000000800ULL, 0x0000006157407223ULL, 0x080fe20000010040ULL,
0x00005410ff577816ULL, 0x100fe40000000066ULL, 0x0000006158277223ULL, 0x080fe20000010027ULL,
0x00007610ff587816ULL, 0x000fe20000000066ULL, 0x000800005b597984ULL, 0x000fe20000000800ULL,
0x0000006157267223ULL, 0x000fe20000010026ULL, 0x00007610ff577816ULL, 0x010fc40000000067ULL,
0x00000061583f7223ULL, 0x080fe2000001003fULL, 0x00005410ff587816ULL, 0x000fe20000000067ULL,
0x000c00005a657984ULL, 0x000f220000000800ULL, 0x00000061573e7223ULL, 0x080fe2000001003eULL,
0x00005410ff577816ULL, 0x100fe40000000068ULL, 0x0000006158257223ULL, 0x080fe20000010025ULL,
0x00007610ff587816ULL, 0x000fe20000000068ULL, 0x000800005c5a7984ULL, 0x000fe20000000800ULL,
0x0000006157247223ULL, 0x000fe20000010024ULL, 0x00005410ff577816ULL, 0x002fc4000000005fULL,
0x00000061583d7223ULL, 0x000fe2000001003dULL, 0x00007610ff587816ULL, 0x000fe2000000005fULL,
0x000c00005b617984ULL, 0x000fe20000000800ULL, 0x0000006257227223ULL, 0x080fe20000010022ULL,
0x00005410ff577816ULL, 0x000fe4000000005eULL, 0x00000062583b7223ULL, 0x080fe2000001003bULL,
0x00005410ff587816ULL, 0x000fe20000000069ULL, 0x000c0000565b7984ULL, 0x000e620000000800ULL,
0x0000006257207223ULL, 0x000fe20000010020ULL, 0x00007610ff577816ULL, 0x000fc4000000005eULL,
0x0000006358197223ULL, 0x080fe20000010019ULL, 0x00007610ff587816ULL, 0x000fe20000000069ULL,
0x000c00005c5f7984ULL, 0x000e620000000800ULL, 0x00000062573a7223ULL, 0x000fe2000001003aULL,
0x00005410ff577816ULL, 0x008fe4000000006aULL, 0x0000006358337223ULL, 0x000fe20000010033ULL,
0x0000005500687202ULL, 0x000fe20000000f00ULL, 0x0008000056587984ULL, 0x0006620000000800ULL,
0x0000006357147223ULL, 0x000fe20000010014ULL, 0x00007610ff577816ULL, 0x000fc4000000006aULL,
0x0000030068007a0cULL, 0x000fc60003f06070ULL, 0x0000006357327223ULL, 0x000fe20000010032ULL,
0x00005410ff567816ULL, 0x008fe4000000005dULL, 0x00005410ff577816ULL, 0x000fc60000000060ULL,
0x00000062561f7223ULL, 0x080fe2000001001fULL, 0x00007610ff567816ULL, 0x000fe2000000005dULL,
0x00000062571e7223ULL, 0x000fe2000001001eULL, 0x00007610ff577816ULL, 0x000fc60000000060ULL,
0x0000006256397223ULL, 0x080fe20000010039ULL, 0x00005410ff567816ULL, 0x004fe20000000064ULL,
0x0000006257387223ULL, 0x000fe20000010038ULL, 0x00005410ff577816ULL, 0x010fc60000000065ULL,
0x0000006356137223ULL, 0x080fe20000010013ULL, 0x00007610ff567816ULL, 0x000fe20000000064ULL,
0x0000006357127223ULL, 0x080fe20000010012ULL, 0x00007610ff577816ULL, 0x000fe40000000065ULL,
0x00007610ff557816ULL, 0x002fe2000000005bULL, 0x0000006356317223ULL, 0x080fe20000010031ULL,
0x00005410ff567816ULL, 0x000fe20000000059ULL, 0x0000006357307223ULL, 0x080fe20000010030ULL,
0x00007610ff577816ULL, 0x000fe20000000061ULL, 0x00000063550c7223ULL, 0x000fc4000001000cULL,
0x00000062561d7223ULL, 0x000fe2000001001dULL, 0x00007610ff567816ULL, 0x000fe20000000059ULL,
0x0000006357107223ULL, 0x000fe20000010010ULL, 0x00005410ff577816ULL, 0x000fc6000000005aULL,
0x0000006256377223ULL, 0x080fe20000010037ULL, 0x00005410ff567816ULL, 0x000fe20000000061ULL,
0x00000062571c7223ULL, 0x000fe2000001001cULL, 0x00007610ff577816ULL, 0x000fc6000000005aULL,
0x0000006356117223ULL, 0x000fe20000010011ULL, 0x00005410ff567816ULL, 0x000fe2000000005fULL,
0x0000006257367223ULL, 0x000fc80000010036ULL, 0x00000063560d7223ULL, 0x000fe2000001000dULL,
0x00007610ff567816ULL, 0x000fca000000005fULL, 0x00000063562f7223ULL, 0x000fe2000001002fULL,
0x00005410ff567816ULL, 0x000fca0000000058ULL, 0x00000062561b7223ULL, 0x000fe2000001001bULL,
0x00007610ff567816ULL, 0x000fca0000000058ULL, 0x0000006256357223ULL, 0x000fe20000010035ULL,
0x00005410ff567816ULL, 0x000fca000000005bULL, 0x00000063560f7223ULL, 0x000fe2000001000fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed2000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000008018058824ULL, 0x000fc800078e0253ULL, 0x0000000152058824ULL, 0x000fe400078e0205ULL,
0x0000000153527824ULL, 0x000fc600078e0252ULL, 0x0089805405008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0089800052007984ULL, 0x000e680000000800ULL,
0x008a000052077984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000700007221ULL, 0x004fca0000010000ULL, 0x0180000000067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0000ULL, 0x0000da3000087802ULL, 0x000fc40000000f00ULL,
0x0000c46000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x008fe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000067423ULL, 0x002fc80000000005ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000605057223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000040404723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff507819ULL, 0x002fe40000011600ULL,
0x0000001000547811ULL, 0x040fe400078ff0ffULL, 0x0000001800567811ULL, 0x040fe200078ff0ffULL,
0x00001f5005077589ULL, 0x000e6200000e0000ULL, 0x0000000800527811ULL, 0x000fe200078ff0ffULL,
0x0000000850537824ULL, 0x000fc400078e00ffULL, 0x00001f5405087589ULL, 0x000ea200000e0000ULL,
0x0000000850557824ULL, 0x040fe400078e00ffULL, 0x0000000850577824ULL, 0x000fe200078e00ffULL,
0x00001f52054f7589ULL, 0x000ee200000e0000ULL, 0x0000000852597824ULL, 0x000fe400078e00ffULL,
0x00000008545b7824ULL, 0x000fe400078e00ffULL, 0x00000008565d7824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fc400078ee252ULL, 0xfffffff85b5b7812ULL, 0x000fe400078ee254ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee256ULL, 0x0000001059597824ULL, 0x100fe400078e0202ULL,
0x000000105b5b7824ULL, 0x100fe400078e0202ULL, 0x000000105d5d7824ULL, 0x000fe200078e0202ULL,
0x00000046070b7220ULL, 0x042fe20000410000ULL, 0x0000000e07097220ULL, 0x040fe20000410000ULL,
0x00001f5605467589ULL, 0x000e6200000e0000ULL, 0x0000004e074e7220ULL, 0x040fe20000410000ULL,
0x00000037080e7220ULL, 0x044fe20000410000ULL, 0x0000003608377220ULL, 0x040fe20000410000ULL,
0x0000004d074d7220ULL, 0x040fe20000410000ULL, 0x0000004c074c7220ULL, 0x040fe20000410000ULL,
0x0000004b074b7220ULL, 0x040fe20000410000ULL, 0x0000004a074a7220ULL, 0x040fe20000410000ULL,
0x0000004907497220ULL, 0x040fe20000410000ULL, 0x0000004807487220ULL, 0x040fe20000410000ULL,
0x0000004707477220ULL, 0x040fe20000410000ULL, 0x0000002e072e7220ULL, 0x040fe20000410000ULL,
0x0000002d072d7220ULL, 0x040fe20000410000ULL, 0x0000001a071a7220ULL, 0x040fe20000410000ULL,
0x0000002c072c7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000004507067220ULL, 0x000fe20000410000ULL, 0x00000039080a7220ULL, 0x040fe20000410000ULL,
0x000000444f077220ULL, 0x048fe20000410000ULL, 0x0000003808397220ULL, 0x000fe20000410000ULL,
0x0000000850457824ULL, 0x040fe200078e00ffULL, 0x0000000250387810ULL, 0x040fe20007ffe0ffULL,
0x0000000850447824ULL, 0x000fe200078e00ffULL, 0x000000164f167220ULL, 0x040fe20000410000ULL,
0x0000003346367220ULL, 0x042fe20000410000ULL, 0x0000003246337220ULL, 0x040fe20000410000ULL,
0x0000003146327220ULL, 0x040fe20000410000ULL, 0x0000003046317220ULL, 0x040fe20000410000ULL,
0x0000002f46307220ULL, 0x000fe20000410000ULL, 0x00000004502f7810ULL, 0x000fe20007ffe0ffULL,
0x0000002a4f2a7220ULL, 0x040fe20000410000ULL, 0x000000434f437220ULL, 0x040fe20000410000ULL,
0x000000294f297220ULL, 0x040fe20000410000ULL, 0x000000424f427220ULL, 0x040fe20000410000ULL,
0x000000284f287220ULL, 0x040fe20000410000ULL, 0x000000414f417220ULL, 0x040fe20000410000ULL,
0x000000274f277220ULL, 0x040fe20000410000ULL, 0x000000404f407220ULL, 0x040fe20000410000ULL,
0x000000264f267220ULL, 0x040fe20000410000ULL, 0x0000003f4f3f7220ULL, 0x040fe20000410000ULL,
0x000000254f257220ULL, 0x040fe20000410000ULL, 0x0000003e4f3e7220ULL, 0x040fe20000410000ULL,
0x000000244f247220ULL, 0x040fe20000410000ULL, 0x0000003d4f3d7220ULL, 0x000fe20000410000ULL,
0x0000003a08057220ULL, 0x000fe20000410000ULL, 0x00000008504f7824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee238ULL, 0x0000002308237220ULL, 0x000fe20000410000ULL,
0x00000003503a7810ULL, 0x000fe20007ffe0ffULL, 0x0000003c083c7220ULL, 0x000fe20000410000ULL,
0x0000000550387810ULL, 0x000fe20007ffe0ffULL, 0x0000002208227220ULL, 0x000fe20000410000ULL,
0xfffffff844517812ULL, 0x000fe200078ee22fULL, 0x0000003b083b7220ULL, 0x040fe20000410000ULL,
0x0000002008207220ULL, 0x040fe20000410000ULL, 0x0000001f081f7220ULL, 0x040fe20000410000ULL,
0x0000001e081e7220ULL, 0x040fe20000410000ULL, 0x0000001d081d7220ULL, 0x040fe20000410000ULL,
0x0000001c081c7220ULL, 0x040fe20000410000ULL, 0x0000001b081b7220ULL, 0x000fe20000410000ULL,
0x00000008502f7824ULL, 0x000fe200078e00ffULL, 0x0000003508087220ULL, 0x000fe20000410000ULL,
0x0000000150357810ULL, 0x000fe20007ffe0ffULL, 0x0000001045457824ULL, 0x000fe200078e0202ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee23aULL, 0x0000001051517824ULL, 0x000fe200078e0202ULL,
0xfffffff853537812ULL, 0x000fe200078ee238ULL, 0x0000002146217220ULL, 0x000fe20000410000ULL,
0x000000160707723eULL, 0x000fe200000010ffULL, 0x0000000400167824ULL, 0x000fe200078e00ffULL,
0x00000006503a7810ULL, 0x040fe20007ffe0ffULL, 0x000000104f4f7824ULL, 0x000fe200078e0202ULL,
0xffffffff50387810ULL, 0x000fe20007ffe0ffULL, 0x0000003446347220ULL, 0x040fe20000410000ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee250ULL, 0x0000001946197220ULL, 0x000fe20000410000ULL,
0xfffffff844357812ULL, 0x000fe200078ee235ULL, 0x0000001446147220ULL, 0x000fe20000410000ULL,
0xfffffff855557812ULL, 0x000fe200078ee23aULL, 0x000000102f2f7824ULL, 0x000fe200078e0202ULL,
0xfffffff857577812ULL, 0x000fe200078ee238ULL, 0x0000001035357824ULL, 0x100fe200078e0202ULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x0000001055557824ULL, 0x100fe200078e0202ULL,
0x0000000253537211ULL, 0x000fe200078e20ffULL, 0x0000001057577824ULL, 0x000fe200078e0202ULL,
0x0000004e4d4d723eULL, 0x000fe200000010ffULL, 0x000000012f027824ULL, 0x000fe200078e0216ULL,
0x0000004c4b4b723eULL, 0x000fe200000010ffULL, 0x0000000116357824ULL, 0x040fe200078e0235ULL,
0x000000200505723eULL, 0x000fe200000010ffULL, 0x0000000116207824ULL, 0x040fe200078e0245ULL,
0x0000004a4949723eULL, 0x000fe200000010ffULL, 0x00000001164f7824ULL, 0x040fe200078e024fULL,
0x000000484747723eULL, 0x000fe200000010ffULL, 0x0000000116517824ULL, 0x040fe200078e0251ULL,
0x0000002e0909723eULL, 0x000fe200000010ffULL, 0x0000000116537824ULL, 0x000fe200078e0253ULL,
0x0000002d1a1a723eULL, 0x000fe200000010ffULL, 0x0000004d02007388ULL, 0x0003e20000000800ULL,
0x000000213421723eULL, 0x000fe200000010ffULL, 0x0000000116347824ULL, 0x000fe200078e0255ULL,
0x0000002c0b0b723eULL, 0x000fe200000010ffULL, 0x0000004b35007388ULL, 0x000fe20000000800ULL,
0x0000002b0606723eULL, 0x000fe200000010ffULL, 0x0000000116577824ULL, 0x040fe200078e0257ULL,
0x0000002a432a723eULL, 0x000fe200000010ffULL, 0x0000004920007388ULL, 0x000fe20000000800ULL,
0x00000001162c7824ULL, 0x000fe200078e0259ULL, 0x000000294229723eULL, 0x000fe200000010ffULL,
0x00000001162e7824ULL, 0x000fe200078e025bULL, 0x000000474f007388ULL, 0x000fe20000000800ULL,
0x000000284128723eULL, 0x000fe200000010ffULL, 0x0000001346137220ULL, 0x000fe20000410000ULL,
0x000000274027723eULL, 0x000fe200000010ffULL, 0x0000000951007388ULL, 0x000fe20000000800ULL,
0x000000263f26723eULL, 0x000fe200000010ffULL, 0x0000001246127220ULL, 0x000fe20000410000ULL,
0x000000253e25723eULL, 0x000fe200000010ffULL, 0x0000001a53007388ULL, 0x000fe20000000800ULL,
0x000000243d24723eULL, 0x000fe200000010ffULL, 0x0000001146117220ULL, 0x000fe20000410000ULL,
0x000000233c23723eULL, 0x000fe200000010ffULL, 0x0000000b34007388ULL, 0x000fe20000000800ULL,
0x000000223b22723eULL, 0x000fe200000010ffULL, 0x0000001046107220ULL, 0x000fe20000410000ULL,
0x0000001f0a0a723eULL, 0x000fe200000010ffULL, 0x0000000657007388ULL, 0x000fe20000000800ULL,
0x0000001e391e723eULL, 0x000fe200000010ffULL, 0x0000000116167824ULL, 0x000fe200078e025dULL,
0x0000001d0e0e723eULL, 0x000fe200000010ffULL, 0x000000072c007388ULL, 0x000fe20000000800ULL,
0x0000001c371c723eULL, 0x000fe200000010ffULL, 0x0000000d460d7220ULL, 0x000fe20000410000ULL,
0x0000001b0808723eULL, 0x000fe200000010ffULL, 0x0004002a35007388ULL, 0x000fe20000000800ULL,
0x000000193619723eULL, 0x000fe200000010ffULL, 0x0000000f460f7220ULL, 0x040fe20000410000ULL,
0x0000000c460c7220ULL, 0x000fe20000410000ULL, 0x0004002920007388ULL, 0x000fe20000000800ULL,
0x000000143314723eULL, 0x000fe200000010ffULL, 0x0000000117027824ULL, 0x002fe200078e0200ULL,
0x000000133213723eULL, 0x000fe200000010ffULL, 0x000400284f007388ULL, 0x000fe20000000800ULL,
0x000000123112723eULL, 0x000fe200000010ffULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x000000111010723eULL, 0x000fe200000010ffULL, 0x0004002751007388ULL, 0x000fe20000000800ULL,
0x0000000d300d723eULL, 0x000fc400000010ffULL, 0x0000000f0c0c723eULL, 0x000fe200000010ffULL,
0x0004002653007388ULL, 0x000fe80000000800ULL, 0x0004002534007388ULL, 0x000fe80000000800ULL,
0x0004002457007388ULL, 0x000fe80000000800ULL, 0x000000232e007388ULL, 0x000fe80000000800ULL,
0x0008002235007388ULL, 0x000fe80000000800ULL, 0x0008000520007388ULL, 0x000fe80000000800ULL,
0x0008000a4f007388ULL, 0x000fe80000000800ULL, 0x0008001e51007388ULL, 0x000fe80000000800ULL,
0x0008000e53007388ULL, 0x000fe80000000800ULL, 0x0008001c34007388ULL, 0x000fe80000000800ULL,
0x0008000857007388ULL, 0x000fe80000000800ULL, 0x0000002116007388ULL, 0x000fe80000000800ULL,
0x000c001935007388ULL, 0x000fe80000000800ULL, 0x000c001420007388ULL, 0x000fe80000000800ULL,
0x000c00134f007388ULL, 0x000fe80000000800ULL, 0x000c001251007388ULL, 0x000fe80000000800ULL,
0x000c001053007388ULL, 0x000fe80000000800ULL, 0x000c000d34007388ULL, 0x000fe80000000800ULL,
0x000c000c57007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002087984ULL, 0x000e680000000c00ULL, 0x0004000002207984ULL, 0x000ea80000000c00ULL,
0x0008000002287984ULL, 0x000ee80000000c00ULL, 0x000c000002107984ULL, 0x000f280000000c00ULL,
0x00100000021c7984ULL, 0x000ee80000000c00ULL, 0x0014000002247984ULL, 0x000f280000000c00ULL,
0x00180000022c7984ULL, 0x000f280000000c00ULL, 0x001c000002307984ULL, 0x000f220000000c00ULL,
0x3f803f80040b7831ULL, 0x002fc4000020000bULL, 0x3f803f80040a7831ULL, 0x040fe4000020000aULL,
0x3f803f8004097831ULL, 0x040fe40000200009ULL, 0x3f803f8004087831ULL, 0x040fe40000200008ULL,
0x3f803f8004237831ULL, 0x044fe40000200023ULL, 0x3f803f8004227831ULL, 0x040fe40000200022ULL,
0x3f803f8004217831ULL, 0x000fc40000200021ULL, 0x3f803f8004207831ULL, 0x040fe40000200020ULL,
0x3f803f80042b7831ULL, 0x048fe4000020002bULL, 0x3f803f80042a7831ULL, 0x040fe4000020002aULL,
0x3f803f8004297831ULL, 0x040fe40000200029ULL, 0x3f803f8004287831ULL, 0x040fe40000200028ULL,
0x3f803f8004137831ULL, 0x010fc40000200013ULL, 0x3f803f8004127831ULL, 0x040fe40000200012ULL,
0x3f803f8004117831ULL, 0x040fe40000200011ULL, 0x3f803f8004107831ULL, 0x000fe40000200010ULL,
0x3f803f800b0b7831ULL, 0x000fe4000020001fULL, 0x3f803f800a0a7831ULL, 0x000fe4000020001eULL,
0x3f803f8009097831ULL, 0x000fc4000020001dULL, 0x3f803f8008087831ULL, 0x000fe4000020001cULL,
0x3f803f8023237831ULL, 0x000fe40000200027ULL, 0x3f803f8022227831ULL, 0x000fe20000200026ULL,
0x0000000802007388ULL, 0x000fe20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe40000200025ULL,
0x3f803f8020207831ULL, 0x000fe40000200024ULL, 0x3f803f802b2b7831ULL, 0x000fc4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fe2000020002eULL, 0x0004002002007388ULL, 0x000fe20000000c00ULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fe4000020002cULL,
0x3f803f8013137831ULL, 0x000fe40000200033ULL, 0x3f803f8012127831ULL, 0x000fe20000200032ULL,
0x0008002802007388ULL, 0x000fe20000000c00ULL, 0x3f803f8011117831ULL, 0x000fc40000200031ULL,
0x3f803f8010107831ULL, 0x000fca0000200030ULL, 0x000c001002007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff1800720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc80000011600ULL,
0x000000820700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000067b06ULL, 0x000ee20000209000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0e7a12ULL, 0x000fe200078e33ffULL, 0x000000019c027824ULL, 0x000fe200078e0207ULL,
0x0000002000107810ULL, 0x042fe20007ffe0ffULL, 0x0000000107077824ULL, 0x000fe200078e0200ULL,
0x00000007000c7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011610ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000000600067308ULL, 0x008e640000001000ULL,
0x0ffffffe06087810ULL, 0x002fc40007ffe0ffULL, 0x0ffffff807067812ULL, 0x000fc800078ef800ULL,
0x0000000800057305ULL, 0x000e62000021f000ULL, 0x0000001006067824ULL, 0x000fe400078e0203ULL,
0x000000ffff097224ULL, 0x006fc800078e0a05ULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x00000009050f7227ULL, 0x000fe400078e0004ULL, 0x0000000006087984ULL, 0x000e680000000c00ULL,
0x000000020f047227ULL, 0x000fca00078e00ffULL, 0x000000ff04057210ULL, 0x000fca0007ffe1ffULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x000000040e047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e029dULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x0000000815077824ULL, 0x000fe400078e020cULL,
0x00005a0005027a24ULL, 0x000fca00078e0202ULL, 0x0000000283027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e06ffULL, 0x00005e0002047a11ULL, 0x000fc800078240ffULL,
0x00005f0002057a11ULL, 0x000fe400008f4405ULL, 0x000000820d00720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000019c027824ULL, 0x100fe200078e020dULL,
0x0000004000127810ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x000fe400078e020dULL,
0x000000020f057227ULL, 0x002fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d047812ULL, 0x000fe400078ef810ULL, 0x00000003ff0d7819ULL, 0x000fc60000011612ULL,
0x0000001004067824ULL, 0x000fca00078e0203ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e029dULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005027a24ULL, 0x000fca00078e0202ULL,
0x0000000283057210ULL, 0x000fe40007f3e0ffULL, 0x0000000710027812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078240ffULL,
0x0000000815077824ULL, 0x000fc600078e0202ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000820d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c027824ULL, 0x100fe200078e020dULL, 0x0000006000107810ULL, 0x000fe20007ffe0ffULL,
0x00000001120d7824ULL, 0x000fe400078e020dULL, 0x000000020f057227ULL, 0x002fc600078e00ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a05ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80d047812ULL, 0x000fe400078ef812ULL,
0x00000003ff0d7819ULL, 0x000fc60000011610ULL, 0x0000001004067824ULL, 0x000fca00078e0203ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e047207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000590004057a24ULL, 0x000fe400078e029dULL, 0x00005a0007027a24ULL, 0x000fc800078e0202ULL,
0x00005a0005027a24ULL, 0x000fca00078e0202ULL, 0x0000000283057210ULL, 0x000fe40007f3e0ffULL,
0x0000000712027812ULL, 0x000fc600078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fe200078240ffULL, 0x0000000815077824ULL, 0x000fc600078e0202ULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000820d00720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000019c027824ULL, 0x000fe200078e020dULL,
0x0000000d100d7210ULL, 0x000fe40007ffe0ffULL, 0x0000008000127810ULL, 0x000fe20007ffe0ffULL,
0x000000020f057227ULL, 0x002fe200078e00ffULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d047812ULL, 0x000fe400078ef810ULL, 0x00000003ff0d7819ULL, 0x000fc60000011612ULL,
0x0000001004067824ULL, 0x000fca00078e0203ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e029dULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005027a24ULL, 0x000fca00078e0202ULL,
0x0000000283057210ULL, 0x000fe40007f3e0ffULL, 0x0000000710027812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078240ffULL,
0x0000000815077824ULL, 0x000fc600078e0202ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000820d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c027824ULL, 0x100fe200078e020dULL, 0x000000a000107810ULL, 0x000fe20007ffe0ffULL,
0x00000001120d7824ULL, 0x000fe400078e020dULL, 0x000000020f057227ULL, 0x002fc600078e00ffULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a05ULL,
0x00005a0007047a24ULL, 0x000fca00078e0202ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80d047812ULL, 0x000fe400078ef812ULL,
0x00000003ff0d7819ULL, 0x000fc60000011610ULL, 0x0000001004067824ULL, 0x000fca00078e0203ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e047207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000590004057a24ULL, 0x000fe400078e029dULL, 0x00005a0007027a24ULL, 0x000fc800078e0202ULL,
0x00005a0005027a24ULL, 0x000fca00078e0202ULL, 0x0000000283057210ULL, 0x000fe40007f3e0ffULL,
0x0000000712027812ULL, 0x000fc600078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fe200078240ffULL, 0x0000000815077824ULL, 0x000fc600078e0202ULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000820d00720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000019c027824ULL, 0x100fe200078e020dULL,
0x000000c000127810ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x000fe400078e020dULL,
0x000000020f057227ULL, 0x002fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d047812ULL, 0x000fe400078ef810ULL, 0x00000003ff0d7819ULL, 0x000fc60000011612ULL,
0x0000001004067824ULL, 0x000fca00078e0203ULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e029dULL,
0x00005a0007027a24ULL, 0x000fc800078e0202ULL, 0x00005a0005027a24ULL, 0x000fca00078e0202ULL,
0x0000000283057210ULL, 0x000fe40007f3e0ffULL, 0x0000000710027812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fe200078240ffULL,
0x0000000815077824ULL, 0x000fc600078e0202ULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000820d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c027824ULL, 0x100fe200078e020dULL, 0x000000e0000c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001120d7824ULL, 0x040fe200078e020dULL, 0x0000000712007812ULL, 0x000fe200078ec0ffULL,
0x000000020f057227ULL, 0x002fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a05ULL, 0x00005a0007047a24ULL, 0x000fca00078e0202ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff80d047812ULL, 0x000fe400078ef812ULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0000000304067211ULL, 0x000fc600078e20ffULL, 0x000000019c9c7824ULL, 0x000fe400078e020dULL,
0x0000000006087984ULL, 0x000e640000000c00ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e047207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000590004057a24ULL, 0x000fe400078e029dULL, 0x00005a0007027a24ULL, 0x000fe400078e0202ULL,
0x0000000815077824ULL, 0x000fe400078e0200ULL, 0x00005a0005027a24ULL, 0x000fca00078e0202ULL,
0x0000000283027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005e0002047a11ULL, 0x000fc800078240ffULL, 0x00005f0002057a11ULL, 0x000fe400008f4405ULL,
0x000000820d00720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000009c0f027227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x002fe400078e0a02ULL,
0x000000010c0d7824ULL, 0x000fe400078e020dULL, 0x00005a0005007a24ULL, 0x000fc600078e029cULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00005a0000007a0cULL, 0x000fda0003f26070ULL,
0x80005a0000001a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00005a0000007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80d007812ULL, 0x000fca00078ef80cULL,
0x0000001000047824ULL, 0x000fe200078e0203ULL, 0x000000070c007812ULL, 0x000fca00078ec0ffULL,
0x0000000102022810ULL, 0x000fe20007ffe0ffULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x0000000815157824ULL, 0x000fe400078e0200ULL, 0x000000020e027207ULL, 0x000fca0004000000ULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x00005900029d7a24ULL, 0x000fe400078e029dULL,
0x00005a00039c7a24ULL, 0x000fc800078e029cULL, 0x00005a009d9c7a24ULL, 0x000fca00078e029cULL,
0x0000009c839c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005e009c027a11ULL, 0x000fc800078040ffULL, 0x00005f009c037a11ULL, 0x000fca00000f4403ULL,
0x0000001015027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff047819ULL, 0x000fe2000001169aULL,
0xffffffffff887424ULL, 0x000fc800078e00ffULL, 0x0000000295217824ULL, 0x000fca00078e0204ULL,
0x000000232100720cULL, 0x000fda0003f06070ULL, 0x00000002a4088824ULL, 0x000fc800078e00ffULL,
0x00006a0008088a24ULL, 0x000fc800078e0221ULL, 0x0000660008088625ULL, 0x000fe200078e0097ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000608888981ULL, 0x000ea2000c1e1900ULL,
0x0000000195037810ULL, 0x000fe20007ffe0ffULL, 0x000000409aa27824ULL, 0x000fe400078e00ffULL,
0x000000800ea17824ULL, 0x000fe200078e00ffULL, 0x000000220300720cULL, 0x000fe20003f06070ULL,
0x00005800ff037624ULL, 0x000fe200078e00ffULL, 0x01660000ff047f8cULL, 0x000ee2000c80043fULL,
0x000000809d9d7824ULL, 0x000fe400078e00ffULL, 0x0000010095147824ULL, 0x000fe200078e02a2ULL,
0x0000001f03037810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff077424ULL, 0x002fc600078e00ffULL,
0x00000005ff2b7819ULL, 0x000fe40000011603ULL, 0x000000409d1f7812ULL, 0x000fe200078ef814ULL,
0x000000a188087224ULL, 0x004fc800078e02ffULL, 0x0000640008087625ULL, 0x000fe200078e0007ULL,
0x0000060000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1c7819ULL, 0x008fe40000011600ULL,
0x0000001494037217ULL, 0x000fe40007800000ULL, 0x000000181c207810ULL, 0x040fe20007ffe0ffULL,
0x000000011f0a7824ULL, 0x000fe200078e021cULL, 0x000000101c1e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103037824ULL, 0x000fe200078e0a14ULL, 0x000000081c167810ULL, 0x000fe20007ffe0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001e1f0e7210ULL, 0x000fc40007ffe0ffULL,
0x000000201c187810ULL, 0x000fe20007ffe0ffULL, 0x000000011f107824ULL, 0x040fe200078e0220ULL,
0x000000300a137812ULL, 0x000fe200078ef806ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000020009a197811ULL, 0x000fe400078e68ffULL, 0x0000001308127210ULL, 0x000fe20007f1e0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000281c1a7810ULL, 0x000fe40007ffe0ffULL,
0x000000031e00720cULL, 0x000fe20003fa6070ULL, 0x000000011f0c7824ULL, 0x000fe200078e0216ULL,
0x0000003010077812ULL, 0x100fe200078ef806ULL, 0x0000000109137824ULL, 0x000fe200000e060bULL,
0x000000300e0b7812ULL, 0x000fe200078ef806ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000708107210ULL, 0x000fc40007f5e0ffULL, 0x0000000b080e7210ULL, 0x000fe20007f3e0ffULL,
0x000000011f0a7824ULL, 0x000fe200078e0218ULL, 0x0000000000077211ULL, 0x000fe200078fe8ffULL,
0x0000000109117824ULL, 0x000fe200010e0611ULL, 0x000000300c157812ULL, 0x100fe200078ef806ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000307077812ULL, 0x000fe400078ec0ffULL,
0x00000015080c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001090f7824ULL, 0x000fe200008e060fULL,
0x000000300a157812ULL, 0x000fe200078ef806ULL, 0x00000004160a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc07007812ULL, 0x000fe200078ef800ULL, 0x00000001090d7824ULL, 0x000fe200000e060dULL,
0x0000001508147210ULL, 0x000fe20007f5e0ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee207ULL, 0x00000010001b7824ULL, 0x000fe200078e0219ULL,
0x000000031c00720cULL, 0x080fe20003f06070ULL, 0x000000011f007824ULL, 0x000fe200078e021aULL,
0x000000031600720cULL, 0x080fe20003f26070ULL, 0x0000000109157824ULL, 0x000fe200010e060bULL,
0x000000032000720cULL, 0x080fe20003f86070ULL, 0x000000100a1d7824ULL, 0x000fe200078e0219ULL,
0x000000031800720cULL, 0x000fe20003f66070ULL, 0x00000100000a7825ULL, 0x000fe200078e00ffULL,
0x000000301c007810ULL, 0x000fc40007ffe0ffULL, 0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x000000300a177812ULL, 0x000fe200078ef806ULL,
0x000000011f0a7824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0003e2000c101c46ULL, 0x000000031a00720cULL, 0x040fe20003f46070ULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0x0000001708167210ULL, 0x000fe20007fde0ffULL,
0x000000000c1d7faeULL, 0x0005e2000c901c46ULL, 0x000000030000720cULL, 0x080fe20003f26070ULL,
0x000000041c247824ULL, 0x040fe200078e00ffULL, 0x000000031c00720cULL, 0x000fe20003f06070ULL,
0x0000000109177824ULL, 0x000fe200030e060bULL, 0xfffffffc18187812ULL, 0x100fe200078ee207ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc1a1a7812ULL, 0x000fc600078ee207ULL,
0x0000000420127824ULL, 0x002fe200078e00ffULL, 0x000000300a037812ULL, 0x000fe200078ef806ULL,
0x000000011f0c7824ULL, 0x004fe400078e021cULL, 0x0000000400207824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e007812ULL, 0x100fe200078ee207ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc12127812ULL, 0x000fe400078ee207ULL, 0x00000003080a7210ULL, 0x000fe20007fde0ffULL,
0x0000001000037824ULL, 0x000fe200078e0219ULL, 0xfffffffc201c7812ULL, 0x000fe200078ee207ULL,
0x0000001012137824ULL, 0x000fe200078e0219ULL, 0xfffffffc241e7812ULL, 0x000fe200078ee207ULL,
0x00000010181b7824ULL, 0x100fe200078e0219ULL, 0x000000300c077812ULL, 0x000fe200078ef806ULL,
0x000000101a1d7824ULL, 0x100fe200078e0219ULL, 0x0000000b090b7210ULL, 0x040fe200037fe4ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0219ULL, 0x0000000708067210ULL, 0x000fe20007fde0ffULL,
0x000000101e197824ULL, 0x000fe200078e0219ULL, 0x000000000e037faeULL, 0x0003e6000e901c46ULL,
0x0000000109077824ULL, 0x000fe200030e060dULL, 0x0000000010137faeULL, 0x0003e8000e101c46ULL,
0x00000000141b7faeULL, 0x0003e8000d901c46ULL, 0x00000000161d7faeULL, 0x0003e8000d101c46ULL,
0x000000000a1f7faeULL, 0x0003e8000c901c46ULL, 0x0000000006197faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000000000c7211ULL, 0x048fe400078fe8ffULL,
0x00000008000e7811ULL, 0x000fc400078ff0ffULL, 0x0000001000107811ULL, 0x040fe400078ff0ffULL,
0x0000001800127811ULL, 0x000fe200078ff0ffULL, 0x000000040e147824ULL, 0x000fe200078e00ffULL,
0x0000002000037811ULL, 0x000fe200078ff0ffULL, 0x0000000410167824ULL, 0x000fe200078e00ffULL,
0x0000002800077811ULL, 0x040fe400078ff0ffULL, 0x00000030000b7811ULL, 0x040fe200078ff0ffULL,
0x0000000403187824ULL, 0x000fe200078e00ffULL, 0x00000038000d7811ULL, 0x000fe200078ff0ffULL,
0x0000000407207824ULL, 0x000fe200078e00ffULL, 0x000000030c0f7812ULL, 0x000fe200078ec0ffULL,
0x000000011f0c7824ULL, 0x040fe200078e020eULL, 0x0000001f000a7211ULL, 0x000fe200078ff0ffULL,
0x000000011f0e7824ULL, 0x000fe200078e0210ULL, 0x0ffffffc0f197812ULL, 0x000fe200078ef800ULL,
0x000000011f107824ULL, 0x000fe200078e0212ULL, 0xfffffffc18157812ULL, 0x100fe200078ee20fULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x000020009a297811ULL, 0x000fe200078e68ffULL,
0x000000040b247824ULL, 0x000fe200078e00ffULL, 0xfffffffc14007812ULL, 0x100fe200078ee20fULL,
0x000000040d267824ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x000fe200078ee20fULL,
0x000000011f1c7824ULL, 0x040fe200078e020bULL, 0xfffffffc24177812ULL, 0x000fe200078ee20fULL,
0x000000011f1a7824ULL, 0x000fe200078e0207ULL, 0xfffffffc16077812ULL, 0x100fe200078ee20fULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc20167812ULL, 0x000fc400078ee20fULL,
0xfffffffc26187812ULL, 0x000fe200078ee20fULL, 0x000000011f1e7824ULL, 0x000fe200078e020dULL,
0x0000002919337211ULL, 0x000fe200078e20ffULL, 0x000001000c0c7825ULL, 0x000fc800078e00ffULL,
0x000001000e0e7825ULL, 0x000fc800078e00ffULL, 0x000000011f137824ULL, 0x000fe200078e0203ULL,
0x000000300a037812ULL, 0x100fe200078ef806ULL, 0x00000010071b7824ULL, 0x100fe200078e0229ULL,
0x000000300c077812ULL, 0x100fe200078ef806ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000300e197812ULL, 0x000fe400078ef806ULL, 0x0000000308147210ULL, 0x000fe20007f1e0ffULL,
0x0000001000037824ULL, 0x100fe400078e0229ULL, 0x00000010121d7824ULL, 0x000fc400078e0229ULL,
0x00000010151f7824ULL, 0x100fe400078e0229ULL, 0x0000001016257824ULL, 0x100fe200078e0229ULL,
0x0000000708167210ULL, 0x000fe20007f3e0ffULL, 0x0000001017277824ULL, 0x100fe200078e0229ULL,
0x0000003010077812ULL, 0x000fe200078ef806ULL, 0x0000001018297824ULL, 0x000fe200078e0229ULL,
0x0000001908187210ULL, 0x040fe20007f5e0ffULL, 0x0000000109157824ULL, 0x040fe200000e060bULL,
0x0000000708107210ULL, 0x000fe20007f1e0ffULL, 0x0000000109177824ULL, 0x000fc400008e060dULL,
0x00000100130a7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014337faeULL, 0x0003e6000b901c46ULL, 0x0000000109197824ULL, 0x000fe200010e060fULL,
0x000000300a317812ULL, 0x100fe200078ef806ULL, 0x000001001a0c7825ULL, 0x000fe200078e00ffULL,
0x0000000016037faeULL, 0x0003e6000b901c46ULL, 0x000001001c0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c2f7812ULL, 0x100fe200078ef806ULL, 0x00000000181b7faeULL, 0x0003e4000b901c46ULL,
0x000001001e127825ULL, 0x000fe200078e00ffULL, 0x000000300e2d7812ULL, 0x000fc400078ef806ULL,
0x0000002f080a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000109117824ULL, 0x040fe200000e0611ULL,
0x0000003012077812ULL, 0x000fe400078ef806ULL, 0x0000003108067210ULL, 0x040fe40007f1e0ffULL,
0x0000002d080c7210ULL, 0x040fe20007f5e0ffULL, 0x00000000101d7faeULL, 0x0003e2000b901c46ULL,
0x0000000708087210ULL, 0x000fe20007f7e0ffULL, 0x0000000109077824ULL, 0x040fe400000e060bULL,
0x00000001090b7824ULL, 0x000fc400008e060dULL, 0x00000001090d7824ULL, 0x040fe200010e060fULL,
0x00000000061f7faeULL, 0x0003e2000b901c46ULL, 0x0000000109097824ULL, 0x000fc600018e0613ULL,
0x000000000a257faeULL, 0x0003e8000b901c46ULL, 0x000000000c277faeULL, 0x0003e8000b901c46ULL,
0x0000000008297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01660400ff037984ULL, 0x000e620000000800ULL,
0x0000002b02967224ULL, 0x000fe400078e02ffULL, 0x00000001949e7824ULL, 0x000fc400078e0a9bULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804805ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620096967625ULL, 0x000fe200078e0097ULL, 0x00000008ff9e7819ULL, 0x000fe2000001169eULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000027805ULL, 0x000fcc0000015200ULL,
0x0000000206097210ULL, 0x000fca0007f1e1ffULL, 0x0000000103037824ULL, 0x000fe200000e0e07ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011403ULL, 0x0000000900007211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x0000000200007819ULL, 0x000fc80000001203ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01660400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000229500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000207919ULL, 0x000e620000000000ULL,
0x00006a00a4a47a24ULL, 0x000fe200078e02ffULL, 0x000166889a9f7811ULL, 0x040fe200078e18ffULL,
0x000000022b1f7824ULL, 0x000fe200078e00ffULL, 0xffffffff9b1e7810ULL, 0x040fe20007ffe0ffULL,
0x000000209aa07824ULL, 0x000fe200078e00ffULL, 0x000000099b1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000195037810ULL, 0x044fe20007ffe0ffULL, 0x00000100ffa37424ULL, 0x000fe200078e00ffULL,
0x000000a2951c7211ULL, 0x000fe200078e40ffULL, 0x00000088a1987224ULL, 0x000fe200078e02ffULL,
0x000000220300720cULL, 0x000fe20003f06070ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000401c007812ULL, 0x000fe200078ec0ffULL, 0x0000640098987625ULL, 0x000fc800078e00a3ULL,
0x000000019d1b7824ULL, 0x000fcc00078e0200ULL, 0x0000064000008947ULL, 0x008fea0003800000ULL,
0x00000002ff107819ULL, 0x002fe20000011620ULL, 0x00000010201a7824ULL, 0x000fc600078e00ffULL,
0x0000000810147810ULL, 0x040fe20007ffe0ffULL, 0x0000000110027824ULL, 0x100fe200078e021bULL,
0x000000301a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000002010187810ULL, 0x000fe20007ffe0ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000401a117812ULL, 0x000fe400078efcffULL,
0x0000001010157810ULL, 0x000fe20007ffe0ffULL, 0x0000000114047824ULL, 0x100fe200078e021bULL,
0x00000011020d7212ULL, 0x000fe200078efcffULL, 0x00000001180a7824ULL, 0x000fe200078e021bULL,
0x0000001810167810ULL, 0x000fe20007ffe0ffULL, 0x000000011b067824ULL, 0x000fe200078e0215ULL,
0x0000000d980c7210ULL, 0x000fe20007f3e0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000002810247810ULL, 0x000fc40007ffe0ffULL, 0x000030009a027811ULL, 0x000fe200078e68ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001104137212ULL, 0x000fe400078efcffULL,
0x0000002020047211ULL, 0x000fe200078fe8ffULL, 0x0000000116087824ULL, 0x000fe400078e021bULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000304127812ULL, 0x000fc600078ec0ffULL,
0x00000001990d7824ULL, 0x000fe200008e0603ULL, 0x000000110a037212ULL, 0x080fe200078efcffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x00000011060f7212ULL, 0x000fe400078efcffULL,
0x00000013980e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000124047824ULL, 0x000fe200078e021bULL,
0x00000003980a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000415177824ULL, 0x000fe200078e00ffULL,
0x0000001108137212ULL, 0x000fe400078efcffULL, 0x0000001c94037217ULL, 0x000fe20007800000ULL,
0x00000001990b7824ULL, 0x040fe200018e060bULL, 0x0000000f98067210ULL, 0x040fe20007f5e0ffULL,
0x00000001990f7824ULL, 0x000fe200008e0605ULL, 0x0000001398087210ULL, 0x000fe20007f3e0ffULL,
0x0000000103007824ULL, 0x000fe200078e0a1cULL, 0x0ffffffc20037812ULL, 0x000fe200078ec0ffULL,
0x0000000414057824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x000fe200078ee212ULL,
0x0000000199097824ULL, 0x040fe200008e0609ULL, 0x000000001000720cULL, 0x080fe20003f26070ULL,
0x0000000199077824ULL, 0x000fe200010e0607ULL, 0x0000000312137212ULL, 0x000fe200078efcffULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0x000000001500720cULL, 0x000fc40003f66070ULL,
0xfffffffc05157812ULL, 0x000fe200078ee212ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000001400720cULL, 0x080fe40003f46070ULL, 0x0000003010147810ULL, 0x000fe20007ffe0ffULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x0000001104197212ULL, 0x000fe200078efcffULL,
0x0000001015157824ULL, 0x000fe200078e0202ULL, 0x0000003810107810ULL, 0x000fe20007ffe0ffULL,
0x0000000114047824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000c901c46ULL, 0x000000001600720cULL, 0x080fe20003fa6070ULL,
0x0000000414257824ULL, 0x000fe200078e00ffULL, 0x000000001800720cULL, 0x080fe20003f86070ULL,
0x0000000410277824ULL, 0x000fe200078e00ffULL, 0x000000000e157faeULL, 0x0005e2000d101c46ULL,
0x000000001400720cULL, 0x000fc40003f46070ULL, 0x000000001000720cULL, 0x080fe20003f26070ULL,
0x0000000006177faeULL, 0x0007e2000d901c46ULL, 0x000000002400720cULL, 0x000fe40003f66070ULL,
0x00000019980c7210ULL, 0x002fe20007fde0ffULL, 0x0000000424197824ULL, 0x000fe200078e00ffULL,
0xfffffffc25257812ULL, 0x100fe400078ee212ULL, 0x00000005990d7210ULL, 0x000fe200037fe4ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0xfffffffc19197812ULL, 0x000fc400078ee212ULL,
0xfffffffc27277812ULL, 0x100fe200078ee212ULL, 0x0000000110067824ULL, 0x008fe200078e021bULL,
0x00000011040f7212ULL, 0x004fe200078efcffULL, 0x0000000416157824ULL, 0x000fe400078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000f98047210ULL, 0x000fe40007fde0ffULL,
0xfffffffc15157812ULL, 0x000fe200078ee212ULL, 0x0000000418177824ULL, 0x000fe200078e00ffULL,
0x0000001106137212ULL, 0x000fe200078efcffULL, 0x0000000199057824ULL, 0x000fc400030e0605ULL,
0x00000010150f7824ULL, 0x000fe200078e0202ULL, 0xfffffffc17177812ULL, 0x000fe200078ee212ULL,
0x0000001025157824ULL, 0x100fe200078e0202ULL, 0x0000001398067210ULL, 0x000fe20007fde0ffULL,
0x0000001019137824ULL, 0x100fe200078e0202ULL, 0x00000000080f7faeULL, 0x0003e2000e901c46ULL,
0x0000001017117824ULL, 0x100fe400078e0202ULL, 0x0000001027177824ULL, 0x000fe400078e0202ULL,
0x0000000199077824ULL, 0x000fe200030e0607ULL, 0x000000000a117faeULL, 0x0003e8000e101c46ULL,
0x000000000c137faeULL, 0x0003e8000d901c46ULL, 0x0000000004157faeULL, 0x0003e8000d101c46ULL,
0x0000000006177faeULL, 0x0003e2000c901c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000010201a7824ULL, 0x042fe200078e00ffULL, 0x00000018200c7811ULL, 0x000fc400078ff0ffULL,
0x00000010200a7811ULL, 0x040fe400078ff0ffULL, 0x0000001b20047211ULL, 0x000fe200078ff0ffULL,
0x000000040c0b7824ULL, 0x000fe200078e00ffULL, 0x0000002020007211ULL, 0x000fe200078fe8ffULL,
0x000000040a097824ULL, 0x000fe200078e00ffULL, 0x0000000820087811ULL, 0x000fe200078ff0ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000002820167811ULL, 0x000fe400078ff0ffULL,
0x000000301a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000108067824ULL, 0x100fe200078e021bULL,
0x0000003820267811ULL, 0x000fe200078ff0ffULL, 0x0000000408077824ULL, 0x000fe200078e00ffULL,
0x0000000300027812ULL, 0x000fe200078ec0ffULL, 0x000000010a087824ULL, 0x100fe200078e021bULL,
0x00000002160f7819ULL, 0x000fe200000006ffULL, 0x000000010c007824ULL, 0x000fe200078e021bULL,
0x000000401a2d7812ULL, 0x000fe200078efcffULL, 0x0000000426137824ULL, 0x000fe200078e00ffULL,
0x0000002020147811ULL, 0x000fc400078ff0ffULL, 0x000030009a2b7811ULL, 0x000fe400078e68ffULL,
0x0000003020187811ULL, 0x000fe200078ff0ffULL, 0x00000004140d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b0e7812ULL, 0x100fe400078ee202ULL, 0xfffffffc090c7812ULL, 0x100fe200078ee202ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0xfffffffc0f127812ULL, 0x100fe400078ee202ULL,
0x0000002d040f7212ULL, 0x000fe200078efcffULL, 0x0000000418117824ULL, 0x000fe200078e00ffULL,
0xfffffffc070a7812ULL, 0x100fe200078ee202ULL, 0x000000100e197824ULL, 0x000fe200078e022bULL,
0xfffffffc13287812ULL, 0x000fe200078ee202ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000f980e7210ULL, 0x000fc40007f3e0ffULL, 0x0000002d08137212ULL, 0x080fe200078efcffULL,
0x0000001012277824ULL, 0x000fe200078e022bULL, 0xfffffffc0d107812ULL, 0x100fe200078ee202ULL,
0x00000001990f7824ULL, 0x000fe200008e0605ULL, 0xfffffffc11247812ULL, 0x000fe200078ee202ULL,
0x0000010000047825ULL, 0x000fe200078e00ffULL, 0x0000002d06117212ULL, 0x000fe400078efcffULL,
0x0000001398127210ULL, 0x000fe20007f7e0ffULL, 0x0000001010257824ULL, 0x000fe200078e022bULL,
0x0000001198107210ULL, 0x000fe20007f5e0ffULL, 0x0000000114067824ULL, 0x000fe200078e021bULL,
0x0ffffffc20037812ULL, 0x000fe200078ec0ffULL, 0x0000000199137824ULL, 0x000fe200018e0609ULL,
0x0000002d04097212ULL, 0x000fe200078efcffULL, 0x000000100a157824ULL, 0x000fe200078e022bULL,
0x0000000302027212ULL, 0x000fe200078efcffULL, 0x0000000116087824ULL, 0x100fe200078e021bULL,
0x0000000998047210ULL, 0x000fe20007f3e0ffULL, 0x00000001180a7824ULL, 0x000fc400078e021bULL,
0x000000100c177824ULL, 0x000fe400078e022bULL, 0x0000000199117824ULL, 0x000fe400010e0607ULL,
0x00000001260c7824ULL, 0x000fe400078e021bULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000002d06337212ULL, 0x000fc600078efcffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002d08317212ULL, 0x000fc600078efcffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002d0a2f7212ULL, 0x000fe400078efcffULL,
0x0000003198087210ULL, 0x000fe20007f5e0ffULL, 0x0000000199057824ULL, 0x040fe200008e0605ULL,
0x0000002d0c2d7212ULL, 0x000fe200078efcffULL, 0x0000001002357824ULL, 0x000fe200078e022bULL,
0x0000003398067210ULL, 0x040fe20007f3e0ffULL, 0x0000000199097824ULL, 0x040fe200010e0609ULL,
0x0000002f980a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001024297824ULL, 0x000fe200078e022bULL,
0x0000002d980c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000199077824ULL, 0x040fe200008e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e357faeULL, 0x0003e2000b901c46ULL,
0x00000001990b7824ULL, 0x040fe200018e060bULL, 0x0000000d990d7210ULL, 0x000fe200027fe4ffULL,
0x00000010282b7824ULL, 0x000fe200078e022bULL, 0x0000000010157faeULL, 0x0003e8000b901c46ULL,
0x0000000012177faeULL, 0x0003e8000b901c46ULL, 0x0000000004197faeULL, 0x0003e8000b901c46ULL,
0x0000000006257faeULL, 0x0003e8000b901c46ULL, 0x0000000008277faeULL, 0x0003e8000b901c46ULL,
0x000000000a297faeULL, 0x0003e8000b901c46ULL, 0x000000000c2b7faeULL, 0x0003e4000b901c46ULL,
0x0000000820197812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff157819ULL, 0x100fe20000011620ULL, 0x000020009a717824ULL, 0x000fe200078e00ffULL,
0x0000000719197812ULL, 0x000fc400078ef820ULL, 0x0000000720057812ULL, 0x000fe200078ec0ffULL,
0x0000000815027824ULL, 0x040fe200078e00ffULL, 0x00000003ff737819ULL, 0x000fe20000011620ULL,
0x0000000115187824ULL, 0x000fe200078e0219ULL, 0x0000001019167812ULL, 0x040fe200078efcffULL,
0x0000001019077824ULL, 0x040fe200078e00ffULL, 0xfffffff802057812ULL, 0x000fe200078ee205ULL,
0x0000001019097824ULL, 0x000fe200078e00ffULL, 0x0000000218007810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200078e0216ULL, 0x0000000173047812ULL, 0x000fe200078ec0ffULL,
0x00000004050b7824ULL, 0x000fe200078e00ffULL, 0xfffffff0070c7812ULL, 0x000fe200078ee200ULL,
0x0000001016067824ULL, 0x040fe200078e00ffULL, 0x0000000405027211ULL, 0x040fe200078ff8ffULL,
0x0000000405277824ULL, 0x040fe200078e00ffULL, 0x0000001005077810ULL, 0x040fe20007ffe0ffULL,
0x0000001016257824ULL, 0x000fe200078e00ffULL, 0x00000020050d7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000030050f7810ULL, 0x000fe20007ffe0ffULL,
0x00000004077a7824ULL, 0x000fe200078e00ffULL, 0xfffffff009007812ULL, 0x000fe200078ee218ULL,
0x000000040d097824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b787812ULL, 0x000fe200078ee202ULL,
0x000000040f0b7824ULL, 0x000fe200078e00ffULL, 0x0000000202727810ULL, 0x000fe20007ffe0ffULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0xfffffff006027812ULL, 0x000fe200078ee215ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000407057211ULL, 0x0c0fe200078ff8ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x000000040d067211ULL, 0x080fe200078ff8ffULL,
0x0000001002027824ULL, 0x000fe200078e00ffULL, 0x000000040f047211ULL, 0x000fe200078ff8ffULL,
0x000000000064783bULL, 0x000fe20000000200ULL, 0x0000200071177810ULL, 0x000fe20007ffe0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc7a7a7812ULL, 0x000fe200078ee205ULL,
0x000000100c0c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09767812ULL, 0x000fe200078ee206ULL,
0x0000001078147824ULL, 0x100fe200078e0217ULL, 0xfffffffc0b747812ULL, 0x000fe200078ee204ULL,
0x000000107a137824ULL, 0x100fe200078e0217ULL, 0x000000000208783bULL, 0x0003e20000000200ULL,
0x0000001076127824ULL, 0x100fe200078e0217ULL, 0x00000002150e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001074117824ULL, 0x000fe200078e0217ULL, 0x000000001468783bULL, 0x000ea20000000200ULL,
0x0000000205707810ULL, 0x000fc40007ffe0ffULL, 0x000000020f0f7819ULL, 0x000fe200000006ffULL,
0x000000001360783bULL, 0x000ee20000000200ULL, 0x0000000206027810ULL, 0x002fe40007ffe0ffULL,
0x0000000204007810ULL, 0x000fe20007ffe0ffULL, 0x00000000125c783bULL, 0x000e620000000200ULL,
0xfffffff0250e7812ULL, 0x000fe400078ee20eULL, 0xfffffffc27727812ULL, 0x000fe200078ee272ULL,
0x00000000116c783bULL, 0x000f220000000200ULL, 0xfffffffc07707812ULL, 0x000fe200078ee270ULL,
0x000000100e547824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d027812ULL, 0x000fe200078ee202ULL,
0x0000001072107824ULL, 0x100fe200078e0217ULL, 0xfffffffc0f007812ULL, 0x000fe200078ee200ULL,
0x00000010700f7824ULL, 0x100fe200078e0217ULL, 0x000000000c34783bULL, 0x000fe20000000200ULL,
0x00000010020e7824ULL, 0x000fc400078e0217ULL, 0x00000010000d7824ULL, 0x000fe200078e0217ULL,
0x00000000103c783bULL, 0x000e680000000200ULL, 0x000000005454783bULL, 0x000e680000000200ULL,
0x000000000f44783bULL, 0x000e680000000200ULL, 0x000000000e4c783bULL, 0x000e680000000200ULL,
0x000000000d04783bULL, 0x000e620000000200ULL, 0x000000686458723cULL, 0x084f7000000418ffULL,
0x000000680838723cULL, 0x000f7000000418ffULL, 0x0000006a6424723cULL, 0x040f7000000418ffULL,
0x000000606428723cULL, 0x048f7000000418ffULL, 0x000000626490723cULL, 0x040f7000000418ffULL,
0x0000005c648c723cULL, 0x042f7000000418ffULL, 0x0000005e642c723cULL, 0x000f7000000418ffULL,
0x000000600840723cULL, 0x040f7000000418ffULL, 0x0000005c0848723cULL, 0x040f7000000418ffULL,
0x0000006a0868723cULL, 0x000f7000000418ffULL, 0x0000006c6430723cULL, 0x010f7000000418ffULL,
0x000000620860723cULL, 0x040f7000000418ffULL, 0x0000005e085c723cULL, 0x040f7000000418ffULL,
0x0000006c0850723cULL, 0x000f7000000418ffULL, 0x0000006e6464723cULL, 0x080f7000000418ffULL,
0x0000006e0808723cULL, 0x000f7000000418ffULL, 0x0000003c3458723cULL, 0x0a0b700000041858ULL,
0x0000003c5438723cULL, 0x000b700000041838ULL, 0x0000003e3424723cULL, 0x040b700000041824ULL,
0x000000443428723cULL, 0x040b700000041828ULL, 0x000000463490723cULL, 0x040b700000041890ULL,
0x0000004c348c723cULL, 0x040b70000004188cULL, 0x0000004e342c723cULL, 0x000b70000004182cULL,
0x000000445440723cULL, 0x040b700000041840ULL, 0x0000004c5448723cULL, 0x040b700000041848ULL,
0x0000003e543c723cULL, 0x000b700000041868ULL, 0x000000043430723cULL, 0x000b700000041830ULL,
0x000000465444723cULL, 0x040b700000041860ULL, 0x0000004e544c723cULL, 0x040b70000004185cULL,
0x000000045450723cULL, 0x000b700000041850ULL, 0x000000063434723cULL, 0x080b700000041864ULL,
0x000000065454723cULL, 0x000b620000041808ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff067819ULL, 0x120fe20000011620ULL, 0x00000001730c7824ULL, 0x000fe200078e0220ULL,
0x0000001c94057217ULL, 0x000fc40007800000ULL, 0x0000000806667810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x140fe200078e021bULL, 0x0000001006687810ULL, 0x000fe20007ffe0ffULL,
0x0000000105697824ULL, 0x000fe200078e0a1cULL, 0x000000801a047812ULL, 0x000fe200078efcffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x00000020066c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000166097824ULL, 0x000fe200078e021bULL, 0x00000018066a7810ULL, 0x040fe20007ffe0ffULL,
0x000000011b0b7824ULL, 0x000fe200078e0268ULL, 0x00000028066e7810ULL, 0x040fe20007ffe0ffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x00000030067c7810ULL, 0x000fc40007ffe0ffULL,
0x00000038067e7810ULL, 0x000fe20007ffe0ffULL, 0x000000016c5f7824ULL, 0x000fe200078e021bULL,
0x0000000898087210ULL, 0x000fe20007f7e0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x000000690600720cULL, 0x080fe40003f26070ULL, 0x000000030c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000016a5d7824ULL, 0x100fe200078e021bULL, 0x0000000a98647210ULL, 0x000fe20007f9e0ffULL,
0x000000016e617824ULL, 0x100fe200078e021bULL, 0x000000697c00720cULL, 0x0c0fe20003fa6070ULL,
0x000000017c637824ULL, 0x000fe200078e021bULL, 0x000000697e00720cULL, 0x000fe20003fc6070ULL,
0x000001005f5e7825ULL, 0x000fc800078e0004ULL, 0x000000017e657824ULL, 0x000fe400078e021bULL,
0x0000010007067825ULL, 0x000fc800078e0004ULL, 0x000001005d5c7825ULL, 0x000fe200078e0004ULL,
0x0000000698067210ULL, 0x000fc60007f5e0ffULL, 0x0000010061607825ULL, 0x000fc800078e0004ULL,
0x0000010063627825ULL, 0x000fc800078e0004ULL, 0x0000000199097824ULL, 0x000fe200018e0609ULL,
0x0000005e985e7210ULL, 0x000fe20007f7e0ffULL, 0x0000010065047825ULL, 0x000fc600078e0004ULL,
0x0000005f995f7210ULL, 0x040fe20001ffe4ffULL, 0x0000000199657824ULL, 0x040fe200020e060bULL,
0x000000030c0b7212ULL, 0x000fe200078efcffULL, 0x0000000466037824ULL, 0x000fe200078e00ffULL,
0x0000006098607210ULL, 0x000fe20007f9e0ffULL, 0x0000000468677824ULL, 0x000fe200078e00ffULL,
0x000000696600720cULL, 0x080fe20003f66070ULL, 0x0000000199077824ULL, 0x000fe200010e0607ULL,
0xfffffffc03667812ULL, 0x100fe200078ee20cULL, 0x0000000199617824ULL, 0x000fe200020e0661ULL,
0x000000696800720cULL, 0x080fe20003f86070ULL, 0x000000100b0a7824ULL, 0x100fe200078e0217ULL,
0xfffffffc67687812ULL, 0x100fe200078ee20cULL, 0x0000001066037824ULL, 0x100fe200078e0217ULL,
0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL, 0x000000046a6b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060a7faeULL, 0x0003e2000c901c46ULL,
0x0000001068677824ULL, 0x000fe200078e0217ULL, 0x000000696a00720cULL, 0x000fe20003f26070ULL,
0x00000001995d7824ULL, 0x000fe200010e065dULL, 0x0000000008037faeULL, 0x0005e2000d901c46ULL,
0xfffffffc6b667812ULL, 0x000fc400078ee20cULL, 0x0000006298627210ULL, 0x000fe20007f5e0ffULL,
0x0000000064677faeULL, 0x0007e2000e101c46ULL, 0x000000696c00720cULL, 0x080fe40003f66070ULL,
0x000000696e00720cULL, 0x000fe20003f86070ULL, 0x0000001066077824ULL, 0x002fe400078e0217ULL,
0x0000000199637824ULL, 0x000fe200010e0663ULL, 0x0000000498047210ULL, 0x000fe20007f5e0ffULL,
0x000000046c037824ULL, 0x004fe200078e00ffULL, 0x000000005c077faeULL, 0x0003e2000c901c46ULL,
0x000000046e097824ULL, 0x000fc400078e00ffULL, 0x000000047c657824ULL, 0x008fe200078e00ffULL,
0xfffffffc03067812ULL, 0x100fe200078ee20cULL, 0x000000047e677824ULL, 0x000fe200078e00ffULL,
0xfffffffc09087812ULL, 0x100fe200078ee20cULL, 0x0000000199057824ULL, 0x000fe400010e0605ULL,
0x0000001006037824ULL, 0x100fe200078e0217ULL, 0xfffffffc65067812ULL, 0x100fe200078ee20cULL,
0x0000001008097824ULL, 0x100fe200078e0217ULL, 0xfffffffc67647812ULL, 0x000fe400078ee20cULL,
0x000000005e037faeULL, 0x0005e2000d901c46ULL, 0x0000001006077824ULL, 0x002fc400078e0217ULL,
0x00000010645d7824ULL, 0x000fe200078e0217ULL, 0x0000000060097faeULL, 0x0005e8000e101c46ULL,
0x0000000062077faeULL, 0x0005e8000e901c46ULL, 0x00000000045d7faeULL, 0x0005e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000801a627812ULL, 0x020fe200078efcffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x0000001b20057211ULL, 0x040fe200078ff0ffULL,
0x00000001730c7824ULL, 0x000fe200078e0220ULL, 0x00000018206a7811ULL, 0x000fc400078ff0ffULL,
0x0000000820667811ULL, 0x000fe200078ff0ffULL, 0x0000010005047825ULL, 0x000fe200078e0062ULL,
0x0000001b6a0b7210ULL, 0x000fe40007ffe0ffULL, 0x0000001020687811ULL, 0x000fe200078ff0ffULL,
0x0000000166077824ULL, 0x000fe200078e021bULL, 0x00000020206c7811ULL, 0x040fe200078ff0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0062ULL, 0x00000028206e7811ULL, 0x040fe400078ff0ffULL,
0x00000030207c7811ULL, 0x000fe200078ff0ffULL, 0x0000000168097824ULL, 0x100fe200078e021bULL,
0x0000000498047210ULL, 0x000fe20007f3e0ffULL, 0x000000016c5d7824ULL, 0x100fe200078e021bULL,
0x00000038207e7811ULL, 0x000fe200078ff0ffULL, 0x000000016e5f7824ULL, 0x100fe200078e021bULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000017c617824ULL, 0x000fe200078e021bULL,
0x000000026e6d7819ULL, 0x000fe200000006ffULL, 0x0000000199057824ULL, 0x000fe200008e0605ULL,
0x0000000a98647210ULL, 0x000fe20007f3e0ffULL, 0x000000017e657824ULL, 0x000fc400078e021bULL,
0x0000010007067825ULL, 0x000fc800078e0062ULL, 0x0000010009087825ULL, 0x000fe200078e0062ULL,
0x0000000698067210ULL, 0x000fc60007f5e0ffULL, 0x000001005d5c7825ULL, 0x000fe200078e0062ULL,
0x0000000898087210ULL, 0x000fc60007f7e0ffULL, 0x000001005f5e7825ULL, 0x000fc800078e0062ULL,
0x0000010061607825ULL, 0x000fc800078e0062ULL, 0x0000000466677824ULL, 0x000fe400078e00ffULL,
0x0000010065627825ULL, 0x000fc600078e0062ULL, 0xfffffffc67667812ULL, 0x100fe200078ee20cULL,
0x0000000199657824ULL, 0x000fe200008e060bULL, 0x000000030c0b7212ULL, 0x000fe200078efcffULL,
0x0000000468037824ULL, 0x000fe200078e00ffULL, 0x0000005e985e7210ULL, 0x000fe20007f3e0ffULL,
0x000000046a677824ULL, 0x000fe400078e00ffULL, 0x000000046c6b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc03687812ULL, 0x100fe200078ee20cULL, 0x0000001066037824ULL, 0x000fe200078e0217ULL,
0xfffffffc67667812ULL, 0x000fe200078ee20cULL, 0x0000000199077824ULL, 0x000fe200010e0607ULL,
0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL, 0x000000100b0a7824ULL, 0x000fc400078e0217ULL,
0x0000001066697824ULL, 0x000fe200078e0217ULL, 0xfffffffc6b667812ULL, 0x000fe200078ee20cULL,
0x000000047c6b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040a7faeULL, 0x0003e2000b901c46ULL, 0x000000047e6f7824ULL, 0x000fe400078e00ffULL,
0x00000001995d7824ULL, 0x040fe200010e065dULL, 0x0000000006037faeULL, 0x0005e2000b901c46ULL,
0x0000000199097824ULL, 0x040fe200018e0609ULL, 0x0000006098607210ULL, 0x040fe20007f5e0ffULL,
0x00000001995f7824ULL, 0x000fe200008e065fULL, 0x0000006298627210ULL, 0x000fe20007f3e0ffULL,
0x0000001068677824ULL, 0x000fc400078e0217ULL, 0x0000000199617824ULL, 0x000fe200010e0661ULL,
0xfffffffc6d047812ULL, 0x102fe200078ee20cULL, 0x0000001066057824ULL, 0x100fe200078e0217ULL,
0xfffffffc6f667812ULL, 0x100fe200078ee20cULL, 0x0000000008677faeULL, 0x0003e2000b901c46ULL,
0xfffffffc6b067812ULL, 0x004fe200078ee20cULL, 0x0000001004037824ULL, 0x000fe400078e0217ULL,
0x0000000199637824ULL, 0x000fe200008e0663ULL, 0x0000000064697faeULL, 0x0005e2000b901c46ULL,
0x0000001006077824ULL, 0x000fc600078e0217ULL, 0x000000005c057faeULL, 0x0005e2000b901c46ULL,
0x0000001066097824ULL, 0x002fc600078e0217ULL, 0x000000005e037faeULL, 0x0005e8000b901c46ULL,
0x0000000060077faeULL, 0x0005e8000b901c46ULL, 0x0000000062097faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001016057824ULL, 0x004fe200078e00ffULL,
0x0000000415047810ULL, 0x000fe20007ffe0ffULL, 0x0000001019067824ULL, 0x040fe200078e00ffULL,
0x0000000418037810ULL, 0x000fe20007ffe0ffULL, 0x00000010195d7824ULL, 0x000fe200078e00ffULL,
0x0000300071097810ULL, 0x000fe20007ffe0ffULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0xfffffff005047812ULL, 0x000fc400078ee204ULL, 0xfffffff006037812ULL, 0x000fe200078ee203ULL,
0x0000001074057824ULL, 0x100fe400078e0209ULL, 0x0000001004747824ULL, 0x000fe200078e00ffULL,
0x0000000618047810ULL, 0x000fe20007ffe0ffULL, 0x0000001078087824ULL, 0x100fe400078e0209ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0xfffffff05d5c7812ULL, 0x000fe200078ee204ULL,
0x000000107a077824ULL, 0x100fe200078e0209ULL, 0x00000006155d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001076067824ULL, 0x000fc400078e0209ULL, 0x000000105c717824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000884783bULL, 0x000fe20000000200ULL,
0xfffffff05e5d7812ULL, 0x000fe200078ee25dULL, 0x0000001072047824ULL, 0x100fe400078e0209ULL,
0x000000000388783bULL, 0x0002a20000000200ULL, 0x000000045d5d7819ULL, 0x000fe200000006ffULL,
0x0000001002027824ULL, 0x100fe400078e0209ULL, 0x000000000780783bULL, 0x000ee20000000200ULL,
0x0000001000007824ULL, 0x000fc600078e0209ULL, 0x00000000067c783bULL, 0x000f220000000200ULL,
0x0000001070037824ULL, 0x002fc600078e0209ULL, 0x000000000578783bULL, 0x000e680000000200ULL,
0x000000007474783bULL, 0x000e680000000200ULL, 0x00000000046c783bULL, 0x000fe80000000200ULL,
0x000000007170783bULL, 0x000e680000000200ULL, 0x000000000368783bULL, 0x000e680000000200ULL,
0x000000000264783bULL, 0x000e680000000200ULL, 0x000000000060783bULL, 0x000e680000000200ULL,
0x000000005d5c783bULL, 0x000e620000000200ULL, 0x000000848858723cULL, 0x044f700000041858ULL,
0x000000868824723cULL, 0x040f700000041824ULL, 0x000000808828723cULL, 0x048f700000041828ULL,
0x000000828890723cULL, 0x040f700000041890ULL, 0x0000007c888c723cULL, 0x050f70000004188cULL,
0x0000007e882c723cULL, 0x040f70000004182cULL, 0x000000788830723cULL, 0x042f700000041830ULL,
0x0000007a8834723cULL, 0x000f700000041834ULL, 0x000000847438723cULL, 0x040f700000041838ULL,
0x00000086743c723cULL, 0x040f70000004183cULL, 0x000000807440723cULL, 0x040f700000041840ULL,
0x000000827444723cULL, 0x040f700000041844ULL, 0x0000007c7448723cULL, 0x040f700000041848ULL,
0x0000007e744c723cULL, 0x040f70000004184cULL, 0x000000787450723cULL, 0x040f700000041850ULL,
0x0000007a7454723cULL, 0x000f700000041854ULL, 0x0000006c7058723cULL, 0x060b700000041858ULL,
0x0000006e7024723cULL, 0x040b700000041824ULL, 0x000000687028723cULL, 0x040b700000041828ULL,
0x0000006a7090723cULL, 0x040b700000041890ULL, 0x00000064708c723cULL, 0x040b70000004188cULL,
0x00000066702c723cULL, 0x040b70000004182cULL, 0x000000607030723cULL, 0x040b700000041830ULL,
0x000000627034723cULL, 0x000b700000041834ULL, 0x0000006c5c38723cULL, 0x040b700000041838ULL,
0x0000006e5c3c723cULL, 0x040b70000004183cULL, 0x000000685c40723cULL, 0x040b700000041840ULL,
0x0000006a5c44723cULL, 0x040b700000041844ULL, 0x000000645c48723cULL, 0x040b700000041848ULL,
0x000000665c4c723cULL, 0x040b70000004184cULL, 0x000000605c50723cULL, 0x040b700000041850ULL,
0x000000625c54723cULL, 0x000b620000041854ULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff6e7819ULL, 0x020fe20000011620ULL, 0x000000ffff637224ULL, 0x000fe200078e00ffULL,
0x000000c01a627812ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fe200078e0209ULL,
0x000000086e6a7810ULL, 0x040fe20007ffe0ffULL, 0x000000016e5d7824ULL, 0x040fe200078e021bULL,
0x000000106e6f7810ULL, 0x000fc40007ffe0ffULL, 0x000000186e707810ULL, 0x000fe20007ffe0ffULL,
0x000000016a5f7824ULL, 0x000fe200078e021bULL, 0x000000206e717810ULL, 0x040fe20007ffe0ffULL,
0x000001005d5c7825ULL, 0x100fe200078e0062ULL, 0x000000286e727810ULL, 0x040fe40007ffe0ffULL,
0x000000306e737810ULL, 0x000fe20007ffe0ffULL, 0x000001005f5e7825ULL, 0x000fe200078e0062ULL,
0x0000005c98667210ULL, 0x000fc60007f1e0ffULL, 0x000000011b617824ULL, 0x000fe200078e026fULL,
0x0000005e98687210ULL, 0x000fe20007f3e0ffULL, 0x0000000199677824ULL, 0x000fe400000e065dULL,
0x00000100615c7825ULL, 0x000fc800078e0062ULL, 0x0000000199697824ULL, 0x000fe200008e065fULL,
0x0000001c945f7217ULL, 0x000fe20007800000ULL, 0x0000000170617824ULL, 0x100fe200078e021bULL,
0x0000005c985c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000171657824ULL, 0x000fe400078e021bULL,
0x000000015f6c7824ULL, 0x000fe400078e0a1cULL, 0x00000100615e7825ULL, 0x000fc600078e0062ULL,
0x0000006c6e00720cULL, 0x080fe20003f46070ULL, 0x00000001726b7824ULL, 0x000fe200078e021bULL,
0x0000006c6a00720cULL, 0x000fe20003f66070ULL, 0x00000001995d7824ULL, 0x000fe200000e065dULL,
0x0000005e985e7210ULL, 0x000fe20007f1e0ffULL, 0x0000010065607825ULL, 0x100fe200078e0062ULL,
0x000000386e6e7810ULL, 0x000fe40007ffe0ffULL, 0x0000006c6f00720cULL, 0x000fe20003fa6070ULL,
0x000001006b647825ULL, 0x000fe200078e0062ULL, 0x0000006098607210ULL, 0x000fc40007f3e0ffULL,
0x0000006c7000720cULL, 0x000fe20003f86070ULL, 0x000000046a6b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000660b7faeULL, 0x0003e2000d101c46ULL,
0x00000001995f7824ULL, 0x000fe200000e065fULL, 0x00000064986a7210ULL, 0x000fe20007f1e0ffULL,
0x000000046f6f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc6b647812ULL, 0x000fe200078ee20cULL,
0x0000000199617824ULL, 0x000fe200008e0661ULL, 0x0000006c7300720cULL, 0x080fe20003f26070ULL,
0x00000001996b7824ULL, 0x000fe200000e0665ULL, 0x0000006c7200720cULL, 0x080fe20003f46070ULL,
0x00000010646d7824ULL, 0x000fe200078e0209ULL, 0x0000006c6e00720cULL, 0x080fe20003f06070ULL,
0x0000000173657824ULL, 0x100fe200078e021bULL, 0x00000002700b7819ULL, 0x002fe200000006ffULL,
0x000000016e1b7824ULL, 0x000fe200078e021bULL, 0x00000000686d7faeULL, 0x0003e2000d901c46ULL,
0x0000010065647825ULL, 0x000fe200078e0062ULL, 0x0000006c7100720cULL, 0x000fc40003f66070ULL,
0xfffffffc6f667812ULL, 0x000fe200078ee20cULL, 0x000001001b627825ULL, 0x000fe200078e0062ULL,
0x0000006498647210ULL, 0x000fc60007fde0ffULL, 0x0000000471717824ULL, 0x000fe400078e00ffULL,
0x00000004721b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b687812ULL, 0x102fe200078ee20cULL,
0x0000000473737824ULL, 0x000fe200078e00ffULL, 0xfffffffc716c7812ULL, 0x100fe200078ee20cULL,
0x000000046e677824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b6e7812ULL, 0x100fe200078ee20cULL,
0x0000000199657824ULL, 0x000fe200030e0665ULL, 0xfffffffc73707812ULL, 0x100fe200078ee20cULL,
0x00000010660b7824ULL, 0x100fe200078e0209ULL, 0xfffffffc67727812ULL, 0x000fe200078ee20cULL,
0x00000010681b7824ULL, 0x100fe200078e0209ULL, 0x0000006298627210ULL, 0x000fe20007fde0ffULL,
0x000000106c677824ULL, 0x100fe200078e0209ULL, 0x000000005c0b7faeULL, 0x0003e2000e901c46ULL,
0x000000106e697824ULL, 0x000fc400078e0209ULL, 0x00000010706d7824ULL, 0x100fe200078e0209ULL,
0x000000005e1b7faeULL, 0x0003e2000e101c46ULL, 0x0000001072097824ULL, 0x000fe400078e0209ULL,
0x0000000199637824ULL, 0x000fe200030e0663ULL, 0x0000000060677faeULL, 0x0003e8000d901c46ULL,
0x000000006a697faeULL, 0x0003e8000d101c46ULL, 0x00000000646d7faeULL, 0x0003e8000c901c46ULL,
0x0000000062097faeULL, 0x0003e2000c101c46ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x00000008206c7811ULL, 0x060fe200078ff0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x00000010206e7811ULL, 0x040fe200078ff0ffULL, 0x000000100b757824ULL, 0x000fe200078e0209ULL,
0x0000001820707811ULL, 0x000fe200078ff0ffULL, 0x000000016c657824ULL, 0x100fe200078e021bULL,
0x0000002020727811ULL, 0x000fe200078ff0ffULL, 0x000000016e677824ULL, 0x100fe200078e021bULL,
0x0000002820747811ULL, 0x000fe200078ff0ffULL, 0x0000000170697824ULL, 0x100fe200078e021bULL,
0x0000003020767811ULL, 0x000fe200078ff0ffULL, 0x00000001725d7824ULL, 0x100fe200078e021bULL,
0x000000c01a6a7812ULL, 0x000fe200078efcffULL, 0x00000001745f7824ULL, 0x100fe200078e021bULL,
0x0000001b20637211ULL, 0x000fe200078ff0ffULL, 0x0000000176617824ULL, 0x000fe200078e021bULL,
0x0000003820787811ULL, 0x000fe200078ff0ffULL, 0x0000010065647825ULL, 0x000fc800078e006aULL,
0x00000001781b7824ULL, 0x000fe200078e021bULL, 0x0000006498647210ULL, 0x000fe20007f3e0ffULL,
0x0000010063627825ULL, 0x000fc800078e006aULL, 0x0000010067667825ULL, 0x000fe200078e006aULL,
0x0000006298627210ULL, 0x000fc60007f1e0ffULL, 0x0000010069687825ULL, 0x000fe200078e006aULL,
0x0000006698667210ULL, 0x000fc60007f5e0ffULL, 0x000001005d5c7825ULL, 0x000fe200078e006aULL,
0x0000006898687210ULL, 0x000fc60007f7e0ffULL, 0x000001005f5e7825ULL, 0x000fc800078e006aULL,
0x0000010061607825ULL, 0x000fc800078e006aULL, 0x000000046c0b7824ULL, 0x000fe400078e00ffULL,
0x000001001b6a7825ULL, 0x000fe200078e006aULL, 0x000000026e1b7819ULL, 0x000fe400000006ffULL,
0xfffffffc0b6c7812ULL, 0x100fe200078ee20cULL, 0x00000004706d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b6e7812ULL, 0x100fe200078ee20cULL, 0x00000004726f7824ULL, 0x000fe400078e00ffULL,
0x0000000474717824ULL, 0x000fe200078e00ffULL, 0xfffffffc6d707812ULL, 0x100fe200078ee20cULL,
0x0000000476737824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f727812ULL, 0x100fe200078ee20cULL,
0x0000000478777824ULL, 0x000fe200078e00ffULL, 0xfffffffc71747812ULL, 0x100fe200078ee20cULL,
0x0000000199637824ULL, 0x040fe200000e0663ULL, 0x0000005c985c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000199657824ULL, 0x040fe200008e0665ULL, 0x0000005e985e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000199677824ULL, 0x000fe200010e0667ULL, 0xfffffffc73767812ULL, 0x100fe200078ee20cULL,
0x000000106c0b7824ULL, 0x000fe200078e0209ULL, 0x0000006098607210ULL, 0x000fe20007f5e0ffULL,
0x0000000199697824ULL, 0x000fe200018e0669ULL, 0xfffffffc77787812ULL, 0x000fe200078ee20cULL,
0x000000106e1b7824ULL, 0x100fe200078e0209ULL, 0x0000006a986a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010706d7824ULL, 0x100fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062757faeULL, 0x0003e2000b901c46ULL, 0x00000010726f7824ULL, 0x000fc400078e0209ULL,
0x00000001995d7824ULL, 0x040fe200000e065dULL, 0x00000000640b7faeULL, 0x0003e2000b901c46ULL,
0x0000001074717824ULL, 0x000fe400078e0209ULL, 0x00000001995f7824ULL, 0x040fe200008e065fULL,
0x00000000661b7faeULL, 0x0003e2000b901c46ULL, 0x0000001076737824ULL, 0x000fe400078e0209ULL,
0x0000000199617824ULL, 0x000fe200010e0661ULL, 0x00000000686d7faeULL, 0x0003e2000b901c46ULL,
0x0000001078097824ULL, 0x000fc400078e0209ULL, 0x00000001996b7824ULL, 0x000fe200018e066bULL,
0x000000005c6f7faeULL, 0x0003e8000b901c46ULL, 0x000000005e717faeULL, 0x0003e8000b901c46ULL,
0x0000000060737faeULL, 0x0003e8000b901c46ULL, 0x000000006a097faeULL, 0x0003e4000b901c46ULL,
0x0000000221217810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff887424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000232100720cULL, 0x000fda0003f06070ULL,
0x0000000400658802ULL, 0x002fe20000000f00ULL, 0x00000002a4648824ULL, 0x000fc800078e0221ULL,
0x0000660064648625ULL, 0x000fe200078e0065ULL, 0x0000000818097810ULL, 0x000fe40007ffe0ffULL,
0x00000008150b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010195c7824ULL, 0x000fe200078e00ffULL,
0x0000000664888981ULL, 0x0002a2000c1e1900ULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff05c097812ULL, 0x000fe200078ee209ULL,
0x0000001019747824ULL, 0x000fe200078e00ffULL, 0xfffffff05e0b7812ULL, 0x000fe200078ee20bULL,
0x0000001016757824ULL, 0x000fe200078e00ffULL, 0x000000001364783bULL, 0x002fe20000000200ULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x0000000a181b7810ULL, 0x000fe20007ffe0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x00000000145c783bULL, 0x000fe40000000200ULL,
0xfffffff0741b7812ULL, 0x000fc400078ee21bULL, 0x000000000960783bULL, 0x0002e20000000200ULL,
0x0000000a15747810ULL, 0x000fe40007ffe0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x000000000b6c783bULL, 0x000f220000000200ULL, 0xfffffff075097812ULL, 0x002fc600078ee274ULL,
0x000000001268783bULL, 0x000e640000000200ULL, 0x0000001009097824ULL, 0x000fe400078e00ffULL,
0x000000001170783bULL, 0x000e680000000200ULL, 0x000000001b74783bULL, 0x000fe80000000200ULL,
0x000000000f78783bULL, 0x000e680000000200ULL, 0x000000000980783bULL, 0x000e680000000200ULL,
0x000000001010783bULL, 0x000e680000000200ULL, 0x000000000e7c783bULL, 0x0002680000000200ULL,
0x000000000d84783bULL, 0x000e620000000200ULL, 0x000000646028723cULL, 0x088f700000041828ULL,
0x000000646c40723cULL, 0x010f700000041840ULL, 0x0000005c6058723cULL, 0x080f700000041858ULL,
0x0000005c6c38723cULL, 0x000f700000041838ULL, 0x0000005e6024723cULL, 0x040f700000041824ULL,
0x000000666090723cULL, 0x040f700000041890ULL, 0x00000068608c723cULL, 0x042f70000004188cULL,
0x0000006a602c723cULL, 0x040f70000004182cULL, 0x000000706030723cULL, 0x040f700000041830ULL,
0x000000726034723cULL, 0x000f700000041834ULL, 0x0000005e6c3c723cULL, 0x040f70000004183cULL,
0x000000666c44723cULL, 0x040f700000041844ULL, 0x000000686c48723cULL, 0x040f700000041848ULL,
0x0000006a6c4c723cULL, 0x040f70000004184cULL, 0x000000706c50723cULL, 0x040f700000041850ULL,
0x000000726c54723cULL, 0x000f700000041854ULL, 0x000000787428723cULL, 0x0a0f700000041828ULL,
0x000000788040723cULL, 0x000b6e0000041840ULL, 0x0000030095797a10ULL, 0x020fe20007ffe0ffULL,
0x000000107458723cULL, 0x000f660000041858ULL, 0x0000000179097810ULL, 0x040fe20007ffe0ffULL,
0x00000100790b7824ULL, 0x000fc600078e02a2ULL, 0x000000220900720cULL, 0x000fe20003f06070ULL,
0x000000108038723cULL, 0x000b620000041838ULL, 0x000000400b0e7812ULL, 0x000fca00078ec0ffULL,
0x000000019d1b7824ULL, 0x000fe400078e020eULL, 0x000000127424723cULL, 0x040b700000041824ULL,
0x0000007a7490723cULL, 0x040b700000041890ULL, 0x0000007c748c723cULL, 0x040b70000004188cULL,
0x0000007e742c723cULL, 0x040b70000004182cULL, 0x000000847430723cULL, 0x040b700000041830ULL,
0x000000867434723cULL, 0x000b700000041834ULL, 0x00000012803c723cULL, 0x040b70000004183cULL,
0x0000007a8044723cULL, 0x040b700000041844ULL, 0x0000007c8048723cULL, 0x040b700000041848ULL,
0x0000007e804c723cULL, 0x040b70000004184cULL, 0x000000848050723cULL, 0x000b640000041850ULL,
0x000000a188107224ULL, 0x024fc800078e02ffULL, 0x00006400100e7625ULL, 0x000fe400078e00a3ULL,
0x000000868054723cULL, 0x000b620000041854ULL, 0x000005b000008947ULL, 0x000fce0003800000ULL,
0x00000002ff147819ULL, 0x000fe40000011620ULL, 0x0000000b94097217ULL, 0x000fe40007800000ULL,
0x0000000814647810ULL, 0x040fe20007ffe0ffULL, 0x0000000114107824ULL, 0x040fe200078e021bULL,
0x0000001014667810ULL, 0x040fe20007ffe0ffULL, 0x0000000109097824ULL, 0x000fe200078e0a0bULL,
0x0000001814687810ULL, 0x000fe20007ffe0ffULL, 0x0000000164127824ULL, 0x000fe200078e021bULL,
0x00000020146a7810ULL, 0x000fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x00000028146c7810ULL, 0x000fc40007ffe0ffULL, 0x00000030146e7810ULL, 0x000fe20007ffe0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000001a10617212ULL, 0x080fe400078efcffULL,
0x000000096600720cULL, 0x000fe20003fa6070ULL, 0x000000011b5c7824ULL, 0x000fe200078e0266ULL,
0x0000001a12637212ULL, 0x000fe200078efcffULL, 0x00000001685e7824ULL, 0x000fe200078e021bULL,
0x000000610e607210ULL, 0x000fe20007f1e0ffULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x000000630e627210ULL, 0x000fc40007f3e0ffULL, 0x000000096800720cULL, 0x000fe20003f86070ULL,
0x000000016a127824ULL, 0x000fe200078e021bULL, 0x0000001a5c0b7212ULL, 0x000fe200078efcffULL,
0x000000010f617824ULL, 0x040fe400000e0611ULL, 0x000000010f637824ULL, 0x000fe200008e0613ULL,
0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL, 0x000001005e5e7825ULL, 0x000fe200078e00ffULL,
0x000000096400720cULL, 0x000fc60003f26070ULL, 0x0000010012127825ULL, 0x000fc800078e00ffULL,
0x000000010f117824ULL, 0x040fe200000e065dULL, 0x0000001a5e5d7212ULL, 0x080fe200078efcffULL,
0x00000004640d7824ULL, 0x000fe200078e00ffULL, 0x0000001a120b7212ULL, 0x000fe200078efcffULL,
0x000000016c127824ULL, 0x000fe200078e021bULL, 0x0000005d0e5c7210ULL, 0x040fe40007f5e0ffULL,
0x0000000b0e5e7210ULL, 0x000fe40007f7e0ffULL, 0x000000091400720cULL, 0x000fe40003f06070ULL,
0x0000005f0f5d7210ULL, 0x040fe200017fe4ffULL, 0x000000010f5f7824ULL, 0x000fe200018e0613ULL,
0xfffffffc0d647812ULL, 0x000fe200078ee20cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000003814147810ULL, 0x000fc40007ffe0ffULL, 0x000000096a00720cULL, 0x080fe20003f66070ULL,
0x00000010640b7824ULL, 0x000fe200078e0217ULL, 0x0000001a12657212ULL, 0x000fe200078efcffULL,
0x0000000114127824ULL, 0x000fe200078e021bULL, 0x000000096c00720cULL, 0x000fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000600a7faeULL, 0x0003e2000c101c46ULL,
0x000000650e647210ULL, 0x000fe20007fde0ffULL, 0x00000004680d7824ULL, 0x000fe200078e00ffULL,
0x000000091400720cULL, 0x080fe20003f06070ULL, 0x00000000620b7faeULL, 0x0005e2000c901c46ULL,
0x000000096e00720cULL, 0x000fe20003f26070ULL, 0x000000010f657824ULL, 0x000fc400030e0613ULL,
0x0000000466097824ULL, 0x000fe400078e00ffULL, 0x000000046a137824ULL, 0x000fe400078e00ffULL,
0x000000016e0a7824ULL, 0x002fe200078e021bULL, 0xfffffffc0d607812ULL, 0x100fe200078ee20cULL,
0x00000004141b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09147812ULL, 0x100fe200078ee20cULL,
0x000001000a0a7825ULL, 0x004fe200078e00ffULL, 0xfffffffc13627812ULL, 0x100fe400078ee20cULL,
0xfffffffc1b6a7812ULL, 0x000fe200078ee20cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000001a0a097212ULL, 0x000fc600078efcffULL, 0x000000046c617824ULL, 0x000fe200078e00ffULL,
0x000000090e0a7210ULL, 0x000fe20007fde0ffULL, 0x000000046e637824ULL, 0x000fe200078e00ffULL,
0x0000001a120d7212ULL, 0x000fe200078efcffULL, 0x0000001014097824ULL, 0x000fe200078e0217ULL,
0xfffffffc61667812ULL, 0x100fe200078ee20cULL, 0x000000010f0b7824ULL, 0x000fe200030e060bULL,
0xfffffffc63687812ULL, 0x000fe200078ee20cULL, 0x00000010601b7824ULL, 0x100fe200078e0217ULL,
0x0000000d0e0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001062617824ULL, 0x100fe200078e0217ULL,
0x0000000010097faeULL, 0x0003e2000e901c46ULL, 0x0000001066637824ULL, 0x000fc400078e0217ULL,
0x0000001068677824ULL, 0x100fe200078e0217ULL, 0x000000005c1b7faeULL, 0x0003e2000e101c46ULL,
0x000000106a177824ULL, 0x000fe400078e0217ULL, 0x000000010f0d7824ULL, 0x000fe200030e0613ULL,
0x000000005e617faeULL, 0x0003e8000d901c46ULL, 0x0000000064637faeULL, 0x0003e8000d101c46ULL,
0x000000000a677faeULL, 0x0003e8000c901c46ULL, 0x000000000c177faeULL, 0x0003e2000c101c46ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x0000000820127811ULL, 0x040fe400078ff0ffULL,
0x0000001020147811ULL, 0x000fc400078ff0ffULL, 0x00000018205e7811ULL, 0x000fe200078ff0ffULL,
0x00000001120d7824ULL, 0x100fe200078e021bULL, 0x0000002020607811ULL, 0x000fe200078ff0ffULL,
0x00000004145d7824ULL, 0x000fe200078e00ffULL, 0x0000002820627811ULL, 0x000fe200078ff0ffULL,
0x000000015e5c7824ULL, 0x100fe200078e021bULL, 0x0000003020647811ULL, 0x000fe200078ff0ffULL,
0x000000045e5f7824ULL, 0x000fe200078e00ffULL, 0x0000003820667811ULL, 0x000fe200078ff0ffULL,
0x0000000160097824ULL, 0x100fe200078e021bULL, 0x0000001b20107211ULL, 0x000fe200078ff0ffULL,
0x00000001620b7824ULL, 0x100fe200078e021bULL, 0x0000000212137819ULL, 0x000fe200000006ffULL,
0x0000000114127824ULL, 0x000fc400078e021bULL, 0x0000000164147824ULL, 0x100fe400078e021bULL,
0x00000001665e7824ULL, 0x000fe400078e021bULL, 0x0000000460617824ULL, 0x000fe400078e00ffULL,
0x0000000462637824ULL, 0x000fe200078e00ffULL, 0xfffffffc13627812ULL, 0x100fe200078ee20cULL,
0x0000000464657824ULL, 0x000fe200078e00ffULL, 0xfffffffc5d647812ULL, 0x100fe200078ee20cULL,
0x00000004661b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc5f667812ULL, 0x100fe200078ee20cULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffffc61687812ULL, 0x000fc400078ee20cULL,
0xfffffffc636a7812ULL, 0x100fe200078ee20cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0xfffffffc656c7812ULL, 0x100fe400078ee20cULL, 0xfffffffc1b6e7812ULL, 0x000fe200078ee20cULL,
0x000001000d0c7825ULL, 0x000fe200078e00ffULL, 0x0000001a10617212ULL, 0x080fe400078efcffULL,
0x0000001a12657212ULL, 0x000fe200078efcffULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x000000610e607210ULL, 0x000fc40007f1e0ffULL, 0x0000001a0c637212ULL, 0x080fe200078efcffULL,
0x0000001062677824ULL, 0x000fe400078e0217ULL, 0x000000010f617824ULL, 0x040fe200000e0611ULL,
0x000000630e627210ULL, 0x000fe20007f3e0ffULL, 0x0000001064697824ULL, 0x000fe200078e0217ULL,
0x0000001a5c117212ULL, 0x080fe200078efcffULL, 0x000001005e5e7825ULL, 0x000fe200078e00ffULL,
0x000000650e647210ULL, 0x040fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000600a7faeULL, 0x0003e2000b901c46ULL, 0x000000110e5c7210ULL, 0x000fe20007f1e0ffULL,
0x000000010f637824ULL, 0x040fe200008e060dULL, 0x000000130f657210ULL, 0x000fe200017fe4ffULL,
0x00000100090c7825ULL, 0x000fe200078e00ffULL, 0x0000001a5e097212ULL, 0x000fc400078efcffULL,
0x0000000062677faeULL, 0x0003e2000b901c46ULL, 0x000001000b107825ULL, 0x000fe200078e00ffULL,
0x0000001a0c1b7212ULL, 0x000fe400078efcffULL, 0x0000000064697faeULL, 0x0003e2000b901c46ULL,
0x0000010014127825ULL, 0x000fc800078e00ffULL, 0x00000010666b7824ULL, 0x100fe200078e0217ULL,
0x0000001a120b7212ULL, 0x080fe200078efcffULL, 0x00000010686d7824ULL, 0x100fe400078e0217ULL,
0x000000106a6f7824ULL, 0x100fe200078e0217ULL, 0x0000000b0e127210ULL, 0x000fe20007f5e0ffULL,
0x000000106c717824ULL, 0x100fe400078e0217ULL, 0x000000106e737824ULL, 0x000fe200078e0217ULL,
0x0000001a10177212ULL, 0x000fe200078efcffULL, 0x000000010f5d7824ULL, 0x040fe200000e065dULL,
0x0000001b0e0c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010f137824ULL, 0x000fe200010e0613ULL,
0x000000170e107210ULL, 0x000fc40007f3e0ffULL, 0x000000090e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f0d7824ULL, 0x040fe200000e060dULL, 0x000000005c6b7faeULL, 0x0003e2000b901c46ULL,
0x000000010f117824ULL, 0x040fe400008e0611ULL, 0x000000010f0f7824ULL, 0x000fe200018e065fULL,
0x000000000c6d7faeULL, 0x0003e8000b901c46ULL, 0x00000000106f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012717faeULL, 0x0003e8000b901c46ULL, 0x000000000e737faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x0000000c18097810ULL, 0x000fe20007ffe0ffULL, 0x0000001016117824ULL, 0x000fe200078e00ffULL,
0x0000000c15107810ULL, 0x000fe20007ffe0ffULL, 0x00000010195e7824ULL, 0x000fe200078e00ffULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x0000001016167824ULL, 0x000fe200078e00ffULL,
0xfffffff011147812ULL, 0x000fc400078ee210ULL, 0x0000000e18177810ULL, 0x000fe20007ffe0ffULL,
0x00000010090c7824ULL, 0x000fe200078e00ffULL, 0x0000000e15157810ULL, 0x000fe20007ffe0ffULL,
0x00000010145c7824ULL, 0x000fe200078e00ffULL, 0xfffffff05e177812ULL, 0x000fca00078ee217ULL,
0x0000001017687824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000c0c783bULL, 0x000fe80000000200ULL, 0x000000000560783bULL, 0x000e680000000200ULL,
0x000000000808783bULL, 0x000fe80000000200ULL, 0x000000005c5c783bULL, 0x000ea80000000200ULL,
0x000000000710783bULL, 0x0007e80000000200ULL, 0x000000000618783bULL, 0x000f220000000200ULL,
0xfffffff016077812ULL, 0x008fc600078ee215ULL, 0x000000006868783bULL, 0x000fe40000000200ULL,
0x0000001007077824ULL, 0x000fe400078e00ffULL, 0x000000000074783bULL, 0x000ee80000000200ULL,
0x000000000464783bULL, 0x000fe80000000200ULL, 0x000000000770783bULL, 0x0004e80000000200ULL,
0x000000000314783bULL, 0x000fe20000000200ULL, 0x000000620c34723cULL, 0x042f660000041834ULL,
0x00000000026c783bULL, 0x000e6a0000000200ULL, 0x000000600c30723cULL, 0x000f700000041830ULL,
0x000000085c38723cULL, 0x044f700000041838ULL, 0x0000000a5c3c723cULL, 0x080f70000004183cULL,
0x0000000a0c24723cULL, 0x040f700000041824ULL, 0x000000180c8c723cULL, 0x050ff0000004188cULL,
0x0000001a0c2c723cULL, 0x000ff0000004182cULL, 0x000000105c40723cULL, 0x040ff00000041840ULL,
0x000000185c48723cULL, 0x000ff00000041848ULL, 0x000000100c28723cULL, 0x000ff00000041828ULL,
0x000000125c44723cULL, 0x040ff00000041844ULL, 0x0000001a5c4c723cULL, 0x040ff0000004184cULL,
0x000000605c04723cULL, 0x000ff00000041850ULL, 0x000000080c58723cULL, 0x040ff00000041858ULL,
0x000000120c90723cULL, 0x000ff00000041890ULL, 0x000000625c54723cULL, 0x020ff00000041854ULL,
0x000000766834723cULL, 0x048ff00000041834ULL, 0x000000746830723cULL, 0x000f700000041830ULL,
0x000000647038723cULL, 0x040f700000041838ULL, 0x00000066703c723cULL, 0x080ff0000004183cULL,
0x000000666824723cULL, 0x000f640000041824ULL, 0x3db504f330137820ULL, 0x020fcc0000410000ULL,
0x0000006c688c723cULL, 0x002f62000004188cULL, 0x3db504f33a007820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fcc0000410000ULL, 0x0000006e682c723cULL, 0x000f70000004182cULL,
0x000000147040723cULL, 0x000f620000041840ULL, 0x3db504f324097820ULL, 0x000fe20000410000ULL,
0x3db504f3250a7820ULL, 0x000fe20000410000ULL, 0x3db504f326197820ULL, 0x000fe20000410000ULL,
0x3db504f3271a7820ULL, 0x000fc80000410000ULL, 0x0000006c7048723cULL, 0x000f640000041848ULL,
0x3db504f38c0f7820ULL, 0x020fe20000410000ULL, 0x3db504f38d107820ULL, 0x000fe20000410000ULL,
0x3db504f38f8f7820ULL, 0x000fc80000410000ULL, 0x000000146828723cULL, 0x000b620000041828ULL,
0x3db504f32d127820ULL, 0x000fe20000410000ULL, 0x3db504f32e2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32c117820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fc60000410000ULL,
0x3db504f334157820ULL, 0x020fe20000410000ULL, 0x000000167044723cULL, 0x040f620000041844ULL,
0x3db504f331147820ULL, 0x000fe20000410000ULL, 0x3db504f336347820ULL, 0x000fe20000410000ULL,
0x3db504f332317820ULL, 0x000fe20000410000ULL, 0x3db504f337367820ULL, 0x000fe20000410000ULL,
0x3db504f333327820ULL, 0x000fe20000410000ULL, 0x3db504f339377820ULL, 0x000fe20000410000ULL,
0x3db504f338337820ULL, 0x000fe20000410000ULL, 0x0000006e706c723cULL, 0x040b62000004184cULL,
0x3db504f33d397820ULL, 0x000fe20000410000ULL, 0x3db504f33c387820ULL, 0x000fe20000410000ULL,
0x3db504f3403a7820ULL, 0x000fe20000410000ULL, 0x3db504f3413d7820ULL, 0x000fe20000410000ULL,
0x3db504f343027820ULL, 0x000fe20000410000ULL, 0x3db504f348417820ULL, 0x000fe20000410000ULL,
0x3db504f33f4e7820ULL, 0x020fe20000410000ULL, 0x000000747004723cULL, 0x000f620000041804ULL,
0x3db504f3424c7820ULL, 0x000fe20000410000ULL, 0x3db504f3280b7820ULL, 0x000fe20000410000ULL,
0x3db504f3290c7820ULL, 0x000fe20000410000ULL, 0x3db504f32a1b7820ULL, 0x000fe20000410000ULL,
0x3db504f32b247820ULL, 0x000fe20000410000ULL, 0x3db504f33e4d7820ULL, 0x000fe20000410000ULL,
0x3db504f349427820ULL, 0x000fe20000410000ULL, 0x000000646858723cULL, 0x040f620000041858ULL,
0x3db504f3443f7820ULL, 0x000fe20000410000ULL, 0x3db504f345407820ULL, 0x000fe20000410000ULL,
0x3db504f3473c7820ULL, 0x000fe20000410000ULL, 0x3db504f38e287820ULL, 0x000fe20000410000ULL,
0x3db504f346277820ULL, 0x000fe20000410000ULL, 0x3db504f34a3e7820ULL, 0x000fe20000410000ULL,
0x3db504f34b2a7820ULL, 0x000fe20000410000ULL, 0x000000166890723cULL, 0x000b620000041890ULL,
0x3db504f36c437820ULL, 0x000fe20000410000ULL, 0x3db504f36d447820ULL, 0x000fe20000410000ULL,
0x3db504f36e6e7820ULL, 0x000fe20000410000ULL, 0x3db504f36f297820ULL, 0x000fc60000410000ULL,
0x3db504f335167820ULL, 0x020fe20000410000ULL, 0x000000767070723cULL, 0x000f620000041854ULL,
0x3db504f304457820ULL, 0x000fe20000410000ULL, 0x3db504f305477820ULL, 0x000fe20000410000ULL,
0x3db504f3062b7820ULL, 0x000fe20000410000ULL, 0x3db504f3072e7820ULL, 0x000fc80000410000ULL,
0x3db504f358037820ULL, 0x000fe20000410000ULL, 0x3db504f359087820ULL, 0x000fe20000410000ULL,
0x3db504f35a187820ULL, 0x000fe20000410000ULL, 0x3db504f35b177820ULL, 0x000fca0000410000ULL,
0x3db504f3900d7820ULL, 0x000fe20000410000ULL, 0x3db504f3910e7820ULL, 0x000fe20000410000ULL,
0x3db504f392257820ULL, 0x000fe20000410000ULL, 0x3db504f393267820ULL, 0x000fca0000410000ULL,
0x3db504f370487820ULL, 0x020fe20000410000ULL, 0x3db504f371497820ULL, 0x000fe20000410000ULL,
0x3db504f372307820ULL, 0x000fe20000410000ULL, 0x3db504f373357820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000009f507f8cULL, 0x0002a2000c80043fULL,
0x000000ffff4b7224ULL, 0x000fe400078e003bULL, 0x000000ffff3b7224ULL, 0x000fe400078e0027ULL,
0x000000ffff2c7224ULL, 0x000fe400078e008fULL, 0x000000ffff4a7224ULL, 0x000fc400078e0000ULL,
0x000000ffff467224ULL, 0x000fe400078e0002ULL, 0x000000ffff277224ULL, 0x000fc400078e006eULL,
0x0000000000047805ULL, 0x002fca0000015200ULL, 0x000004009f077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fe40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006044f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09004f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000004f00007211ULL, 0x000fc800078110ffULL,
0x00000007ff077210ULL, 0x000fc800007fe4ffULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000102027810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004009f077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000420027824ULL, 0x000fe200078e00ffULL,
0x0000009e9500720cULL, 0x000fc80003f06070ULL, 0xfffffff002057812ULL, 0x000fca00078ec0ffULL,
0x000000809a007824ULL, 0x000fca00078e0205ULL, 0x0164000000047984ULL, 0x0002a20000000c00ULL,
0x000021e000008947ULL, 0x000fea0003800000ULL, 0x00005a0000537b06ULL, 0x000ee20000209000ULL,
0x000000ffff507224ULL, 0x000fe200078e00ffULL, 0x0000009c204f7211ULL, 0x000fe400078ff0ffULL,
0x0000001c94597217ULL, 0x000fe40007800000ULL, 0x000000104f547810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff5b7a12ULL, 0x000fe200078e33ffULL, 0x00000001591c7824ULL, 0x000fe200078e0a1cULL,
0x0000005300537308ULL, 0x008ee40000001000ULL, 0x0ffffffe53557810ULL, 0x008fcc0007ffe0ffULL,
0x0000005500517305ULL, 0x000ee4000021f000ULL, 0x000000ffff577224ULL, 0x008fc800078e0a51ULL,
0x00005a0057577a24ULL, 0x000fc800078e02ffULL, 0x00000057515c7227ULL, 0x000fe200078e0050ULL,
0x000000084f517810ULL, 0x000fca0007ffe0ffULL, 0x000000515c527227ULL, 0x000fc800078e00ffULL,
0x0000004f5c507227ULL, 0x000fc800078e00ffULL, 0x000000ffff5a7224ULL, 0x000fe400078e0a52ULL,
0x000000ffff587224ULL, 0x000fe400078e0a50ULL, 0x00005a005a537a24ULL, 0x000fe400078e0251ULL,
0x00005a0058517a24ULL, 0x000fe200078e024fULL, 0x000000184f4f7810ULL, 0x000fe20007ffe0ffULL,
0x000000545c567227ULL, 0x000fe200078e00ffULL, 0x00005a0053007a0cULL, 0x000fe40003fa6070ULL,
0x00005a0051007a0cULL, 0x000fe20003f06070ULL, 0x000000ffff557224ULL, 0x000fc400078e0a56ULL,
0x0000004f5c577227ULL, 0x000fc800078e00ffULL, 0x00005a0055547a24ULL, 0x000fe400078e0254ULL,
0x000000ffff587224ULL, 0x000fe400078e0a57ULL, 0x80005a0053535a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0058557a24ULL, 0x000fe200078e024fULL, 0x00005a0054007a0cULL, 0x000fe20003f26070ULL,
0x00000002204f7824ULL, 0x000fe200078e00ffULL, 0x80005a0051510a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0055007a0cULL, 0x000fc40003f66070ULL, 0x00005a0051007a0cULL, 0x000fe40003f46070ULL,
0x000000064f4f7812ULL, 0x000fe400078ec0ffULL, 0x00005a0053007a0cULL, 0x000fe40003fc6070ULL,
0x0000000150500810ULL, 0x000fe20007ffe0ffULL, 0x000000014f597824ULL, 0x000fe200078e029bULL,
0x80005a0054541a10ULL, 0x000fe20007ffe0ffULL, 0x000000011d537824ULL, 0x000fe200078e024fULL,
0x0000000152525810ULL, 0x000fe20007ffe0ffULL, 0x0000000159517824ULL, 0x000fe200078e0a1cULL,
0x00005a0054007a0cULL, 0x000fc40003f86070ULL, 0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL,
0x0000001c5300720cULL, 0x040fe20003f06070ULL, 0x0000000153537824ULL, 0x000fe200078e0a1cULL,
0x80005a0055553a10ULL, 0x000fe40007ffe0ffULL, 0x0000000150502810ULL, 0x000fe40007ffe0ffULL,
0x000000511e687217ULL, 0x000fe40003800000ULL, 0x00005a0055007a0cULL, 0x000fc40003f46070ULL,
0x000000505b517207ULL, 0x000fe40006800000ULL, 0x000000531e537217ULL, 0x000fe40003800000ULL,
0x0000000152526810ULL, 0x000fe40007ffe0ffULL, 0x000000511e507217ULL, 0x000fe40003800000ULL,
0x0000000156561810ULL, 0x000fe40007ffe0ffULL, 0x0000001c5900720cULL, 0x000fe20003fc6070ULL,
0x000000501f817224ULL, 0x000fe200078e02ffULL, 0x00000004ff537819ULL, 0x000fc40000011653ULL,
0x000000525b557207ULL, 0x000fe40006800000ULL, 0x0000000157573810ULL, 0x000fe40007ffe0ffULL,
0x0000000156564810ULL, 0x000fe40007ffe0ffULL, 0x000000ff68687207ULL, 0x000fe40003000000ULL,
0x000000ff53547207ULL, 0x000fe40000000000ULL, 0x000000551e527217ULL, 0x000fc40003800000ULL,
0x0000000157572810ULL, 0x000fe20007ffe0ffULL, 0x0000000181537824ULL, 0x000fe200078e0254ULL,
0x000000565b557207ULL, 0x000fe20006800000ULL, 0x000000521f857224ULL, 0x000fe200078e02ffULL,
0x0000008168517211ULL, 0x000fe200078fe0ffULL, 0x0000000253527825ULL, 0x100fe200078e0096ULL,
0x000000575b5b7207ULL, 0x000fe40006800000ULL, 0x000000551e5a7217ULL, 0x040fe20003800000ULL,
0x0000000251507825ULL, 0x000fe200078e0096ULL, 0x0000005b1e5c7217ULL, 0x000fe20003800000ULL,
0x0000000652587981ULL, 0x000722000c1e9500ULL, 0x000000104f677812ULL, 0x000fe200078efcffULL,
0x0000000154577824ULL, 0x000fc400078e0285ULL, 0x0000005a1f877224ULL, 0x000fe200078e02ffULL,
0x00000006505b7981ULL, 0x000322000c1e9500ULL, 0x0000000257567825ULL, 0x000fe200078e0096ULL,
0x0000008568557211ULL, 0x040fe400078fe0ffULL, 0x00000087685d7211ULL, 0x000fe200078fe0ffULL,
0x0000005c1f897224ULL, 0x000fe200078e02ffULL, 0x00000006565a7981ULL, 0x000522000c1e9500ULL,
0x000000011d6b7824ULL, 0x000fe400078e0267ULL, 0x0000000154617824ULL, 0x000fe200078e0287ULL,
0x00000089685f7211ULL, 0x000fe200078fe0ffULL, 0x0000000154637824ULL, 0x000fc400078e0289ULL,
0x0000000255547825ULL, 0x000fc800078e0096ULL, 0x000000016b577824ULL, 0x004fe400078e0a1cULL,
0x0000000261607825ULL, 0x000fc800078e0096ULL, 0x000000025d527825ULL, 0x008fe200078e0096ULL,
0x000000571e567217ULL, 0x000fe20003800000ULL, 0x00000006545d7981ULL, 0x0004e4000c1e9500ULL,
0x0000000167657824ULL, 0x000fe400078e029bULL, 0x000000025f507825ULL, 0x002fe200078e0096ULL,
0x00000006605c7981ULL, 0x0002e2000c1e9500ULL, 0x0000001c6b00720cULL, 0x000fc60003f26070ULL,
0x00000006525f7981ULL, 0x0002e2000c1e9500ULL, 0x000000651c577210ULL, 0x000fe40007ffe1ffULL,
0x00000004ff567819ULL, 0x000fe20000011656ULL, 0x0000000263627825ULL, 0x000fe200078e0096ULL,
0x0000001c6500720cULL, 0x000fe20003f06070ULL, 0x0000000650697981ULL, 0x0002e2000c1e9500ULL,
0x000000571e577217ULL, 0x000fe40003800000ULL, 0x000000ff56547207ULL, 0x004fe20000800000ULL,
0x00000006625e7981ULL, 0x0004e2000c1e9500ULL, 0x000000ff57727207ULL, 0x000fc40000000000ULL,
0x000000204f717812ULL, 0x000fe200078efcffULL, 0x0000000154577824ULL, 0x000fe200078e0285ULL,
0x0000008172517211ULL, 0x002fc600078fe0ffULL, 0x0000000257567825ULL, 0x000fe200078e0096ULL,
0x0000008572557211ULL, 0x000fc600078fe0ffULL, 0x0000000181537824ULL, 0x000fe200078e0254ULL,
0x0000000656667981ULL, 0x0002e2000c1e9500ULL, 0x000000011d777824ULL, 0x000fe200078e0271ULL,
0x00000089726d7211ULL, 0x000fe200078fe0ffULL, 0x0000000251507825ULL, 0x000fc800078e0096ULL,
0x0000000154637824ULL, 0x044fe200078e0287ULL, 0x00000006506b7981ULL, 0x0004e2000c1e9500ULL,
0x00000001546f7824ULL, 0x000fe400078e0289ULL, 0x0000000253527825ULL, 0x000fc800078e0096ULL,
0x0000000255547825ULL, 0x000fe200078e0096ULL, 0x0000000652647981ULL, 0x0004e6000c1e9500ULL,
0x0000000177577824ULL, 0x002fe400078e0a1cULL, 0x0000000171737824ULL, 0x000fe400078e029bULL,
0x000000026d507825ULL, 0x004fe200078e0096ULL, 0x000000571e567217ULL, 0x000fe20003800000ULL,
0x00000006546d7981ULL, 0x0002a4000c1e9500ULL, 0x0000000173577824ULL, 0x000fe200078e0a1cULL,
0x0000008772617211ULL, 0x000fe200078fe0ffULL, 0x0000000263627825ULL, 0x100fe200078e0096ULL,
0x0000001c7300720cULL, 0x080fe20003f06070ULL, 0x0000000650757981ULL, 0x0002a2000c1e9500ULL,
0x000000571e577217ULL, 0x000fe20003800000ULL, 0x0000000261607825ULL, 0x000fe200078e0096ULL,
0x0000001c7700720cULL, 0x000fe20003f26070ULL, 0x00000006626a7981ULL, 0x0002a2000c1e9500ULL,
0x00000004ff567819ULL, 0x000fe20000011656ULL, 0x000000026f527825ULL, 0x000fe200078e0096ULL,
0x000000ff57767207ULL, 0x000fe20000000000ULL, 0x00000006606f7981ULL, 0x0002a2000c1e9500ULL,
0x000000ff56567207ULL, 0x000fc40000800000ULL, 0x0000008176557211ULL, 0x002fe200078fe0ffULL,
0x00000006526c7981ULL, 0x0002a4000c1e9500ULL, 0x0000000156637824ULL, 0x000fe200078e0285ULL,
0x0000008576617211ULL, 0x000fe200078fe0ffULL, 0x0000000255547825ULL, 0x000fc800078e0096ULL,
0x0000000181537824ULL, 0x002fe200078e0256ULL, 0x00000089767b7211ULL, 0x000fe200078fe0ffULL,
0x0000000263627825ULL, 0x100fe200078e0096ULL, 0x0000000654777981ULL, 0x0002a6000c1e9500ULL,
0x0000000253527825ULL, 0x100fe200078e0096ULL, 0x0000000662707981ULL, 0x0002a6000c1e9500ULL,
0x0000000261607825ULL, 0x000fe200078e0096ULL, 0x00000006526e7981ULL, 0x0002a6000c1e9500ULL,
0x00000001567d7824ULL, 0x000fc400078e0289ULL, 0x000000027b547825ULL, 0x102fe400078e0096ULL,
0x00000006607b7981ULL, 0x0002a4000c1e9500ULL, 0x000000027d527825ULL, 0x000fe200078e0096ULL,
0x000000304f7d7812ULL, 0x000fe200078efcffULL, 0x0000000654d77981ULL, 0x0002a2000c1e9500ULL,
0x0000008776517211ULL, 0x000fe200078fe0ffULL, 0x0000000156577824ULL, 0x000fe400078e0287ULL,
0x000000011d837824ULL, 0x000fe200078e027dULL, 0x0000000652847981ULL, 0x0002a2000c1e9500ULL,
0x0000000257567825ULL, 0x000fc800078e0096ULL, 0x0000000251507825ULL, 0x000fe200078e0096ULL,
0x0000000656747981ULL, 0x0002a6000c1e9500ULL, 0x0000000183637824ULL, 0x000fe200078e0a1cULL,
0x0000000650d37981ULL, 0x0002a2000c1e9500ULL, 0x000000017d7f7824ULL, 0x000fc600078e029bULL,
0x000000631e627217ULL, 0x040fe20003800000ULL, 0x000000017f637824ULL, 0x000fe200078e0a1cULL,
0x0000001c8300720cULL, 0x080fe40003f26070ULL, 0x0000001c7f00720cULL, 0x000fe40003f06070ULL,
0x00000004ff627819ULL, 0x000fe40000011662ULL, 0x000000631e637217ULL, 0x000fe40003800000ULL,
0x000000ff627a7207ULL, 0x000fc40000800000ULL, 0x000000ff63787207ULL, 0x000fc60000000000ULL,
0x0000000181617824ULL, 0x002fe200078e027aULL, 0x0000008178637211ULL, 0x000fe200078fe0ffULL,
0x000000017a557824ULL, 0x000fe200078e0287ULL, 0x0000008778577211ULL, 0x000fe200078fe0ffULL,
0x0000000261607825ULL, 0x000fc800078e0096ULL, 0x0000000263627825ULL, 0x100fe200078e0096ULL,
0x00000006607c7981ULL, 0x0002a6000c1e9500ULL, 0x0000000255547825ULL, 0x100fe200078e0096ULL,
0x0000000662bb7981ULL, 0x0002a6000c1e9500ULL, 0x0000000257567825ULL, 0x000fe200078e0096ULL,
0x0000000654827981ULL, 0x0002a2000c1e9500ULL, 0x0000008578537211ULL, 0x000fc600078fe0ffULL,
0x0000000656d57981ULL, 0x0002a2000c1e9500ULL, 0x000000017a517824ULL, 0x000fe400078e0285ULL,
0x0000000253527825ULL, 0x000fc800078e0096ULL, 0x0000000251507825ULL, 0x000fe200078e0096ULL,
0x0000000652d17981ULL, 0x0002a4000c1e9500ULL, 0x0000008978617211ULL, 0x002fe400078fe0ffULL,
0x0000000650807981ULL, 0x0002a2000c1e9500ULL, 0x000000017a637824ULL, 0x000fe400078e0289ULL,
0x0000000261607825ULL, 0x000fc800078e0096ULL, 0x0000000263627825ULL, 0x000fe200078e0096ULL,
0x0000000660d97981ULL, 0x0002a8000c1e9500ULL, 0x0000000662867981ULL, 0x0002a4000c1e9500ULL,
0xfffffff068517812ULL, 0x002fe200078ec0ffULL, 0x00000001ffcf7424ULL, 0x000fc800078e00ffULL,
0x000000011c507824ULL, 0x000fc800078e0251ULL, 0x0000000159517824ULL, 0x000fe200078e0a50ULL,
0x000000014f817812ULL, 0x000fc800078efcffULL, 0x00000051cf517219ULL, 0x000fe400000006ffULL,
0x0000009b81537210ULL, 0x000fe40007ffe0ffULL, 0xfffffff072557812ULL, 0x000fc600078ec0ffULL,
0x0000000153527824ULL, 0x100fe200078e0a50ULL, 0x000000084f837812ULL, 0x040fe200078efcffULL,
0x000000011c567824ULL, 0x000fe200078e0255ULL, 0x000000094f857812ULL, 0x000fe400078efcffULL,
0x00000052cf557219ULL, 0x000fe200000006ffULL, 0x0000000183577824ULL, 0x100fe400078e029bULL,
0x0000000185637824ULL, 0x000fe200078e029bULL, 0xfffffff076617812ULL, 0x000fe200078ec0ffULL,
0x0000000157547824ULL, 0x100fe200078e0a50ULL, 0xfffffff078877812ULL, 0x000fe200078ec0ffULL,
0x0000000163507824ULL, 0x000fe200078e0a50ULL, 0x000000114f8b7812ULL, 0x000fe200078efcffULL,
0x000000011c607824ULL, 0x040fe200078e0261ULL, 0x00000054cf617219ULL, 0x040fe200000006ffULL,
0x000000011c767824ULL, 0x000fe200078e0287ULL, 0x00000050cf877219ULL, 0x000fe200000006ffULL,
0x000000018b8d7824ULL, 0x000fc400078e029bULL, 0x0000000165507824ULL, 0x100fe400078e0a56ULL,
0x000000018d527824ULL, 0x000fe200078e0a56ULL, 0x000000184f917812ULL, 0x040fe400078efcffULL,
0x000000194f997812ULL, 0x000fe400078efcffULL, 0x000054105b587816ULL, 0x010fc80000000058ULL,
0x0000005851ff7212ULL, 0x000fc800078ac0ffULL, 0x0000001c5900720cULL, 0x000fc80002fa1470ULL,
0x0000001c4f00720cULL, 0x000fe40002fa1070ULL, 0x0000005855ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000003037808ULL, 0x000fe40002800000ULL, 0x000054105d5a7816ULL, 0x008fc8000000005aULL,
0x0000005a51ff7212ULL, 0x080fe4000784c0ffULL, 0x000054105f5c7816ULL, 0x000fe4000000005cULL,
0x0000005a55ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005c51ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001c5900720cULL, 0x0c0fe40001741470ULL, 0x0000001c5900720cULL, 0x000fc40002781470ULL,
0x0000001c5300720cULL, 0x0c0fe40000f21470ULL, 0x0000001c5300720cULL, 0x080fe40002fa1470ULL,
0x0000001c4f00720cULL, 0x0c0fe40001741070ULL, 0x0000001c4f00720cULL, 0x080fe40002781070ULL,
0x0000001c8100720cULL, 0x0c0fe40000f21070ULL, 0x0000001c8100720cULL, 0x000fc40002fa1070ULL,
0x00005410695e7816ULL, 0x000fe4000000005eULL, 0xff80000018187808ULL, 0x000fe40001000000ULL,
0xff80000033337808ULL, 0x000fe40002000000ULL, 0xff80000008087808ULL, 0x000fe40000800000ULL,
0xff80000017177808ULL, 0x000fe40002800000ULL, 0x0000005861ff7212ULL, 0x000fc4000786c0ffULL,
0x0000005e51ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005c55ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005e55ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005a87ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005c61ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001c5900720cULL, 0x000fc40000701470ULL,
0x0000001c5300720cULL, 0x0c0fe40001741470ULL, 0x0000001c5300720cULL, 0x080fe40002781470ULL,
0x0000001c5700720cULL, 0x0c0fe40001f61470ULL, 0x0000001c5700720cULL, 0x080fe40002fa1470ULL,
0x0000001c6300720cULL, 0x080fe40000f21470ULL, 0x0000001c4f00720cULL, 0x000fc40000701070ULL,
0x0000001c8100720cULL, 0x0c0fe40001741070ULL, 0x0000001c8100720cULL, 0x080fe40002781070ULL,
0x0000001c8300720cULL, 0x0c0fe40001f61070ULL, 0x0000001c8300720cULL, 0x080fe40002fa1070ULL,
0x0000001c8500720cULL, 0x000fe40000f21070ULL, 0x00000050cf897219ULL, 0x000fc400000006ffULL,
0x00000052cf8f7219ULL, 0x000fe400000006ffULL, 0x000054106b647816ULL, 0x000fe40000000064ULL,
0x000054106d667816ULL, 0x004fe20000000066ULL, 0x0000000191937824ULL, 0x100fe200078e029bULL,
0xff8000004a4a7808ULL, 0x000fe20000000000ULL, 0x0000000199a37824ULL, 0x000fe200078e029bULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff8000004b4b7808ULL, 0x000fc40002000000ULL,
0xff80000009097808ULL, 0x000fe40001800000ULL, 0xff80000038387808ULL, 0x000fe40002800000ULL,
0xff8000001a1a7808ULL, 0x000fe40000800000ULL, 0x0000005a61ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005c87ff7212ULL, 0x000fe4000784c0ffULL, 0x0000005e61ff7212ULL, 0x000fc4000788c0ffULL,
0x0000005e87ff7212ULL, 0x000fe4000786c0ffULL, 0x000000648fff7212ULL, 0x000fe400078ac0ffULL,
0x0000006689ff7212ULL, 0x000fe4000782c0ffULL, 0x0000009356547210ULL, 0x000fe20007ffe1ffULL,
0x00000001a3567824ULL, 0x000fe200078e0a56ULL, 0x0000001c5700720cULL, 0x0c0fe40000701470ULL,
0x0000001c5700720cULL, 0x000fc40002781470ULL, 0x0000001c6300720cULL, 0x0c0fe40001741470ULL,
0x0000001c6300720cULL, 0x080fe40001f61470ULL, 0x0000001c6500720cULL, 0x080fe40000f21470ULL,
0x0000001c8d00720cULL, 0x080fe40002fa1470ULL, 0x0000001c8300720cULL, 0x0c0fe40000701070ULL,
0x0000001c8300720cULL, 0x000fc40002781070ULL, 0x0000001c8500720cULL, 0x0c0fe40001741070ULL,
0x0000001c8500720cULL, 0x080fe40001f61070ULL, 0x0000001c6700720cULL, 0x080fe40000f21070ULL,
0x0000001c8b00720cULL, 0x000fe40002fa1070ULL, 0x00000054cf957219ULL, 0x040fe400000006ffULL,
0x00000056cfa57219ULL, 0x000fc400000006ffULL, 0x000054106f6a7816ULL, 0x000fe4000000006aULL,
0x00005410756c7816ULL, 0x000fe4000000006cULL, 0xff80000019197808ULL, 0x000fe40000000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff80000039397808ULL, 0x000fe40001000000ULL,
0xff8000004e4e7808ULL, 0x000fc40001800000ULL, 0xff8000001b1b7808ULL, 0x000fe40000800000ULL,
0xff8000000c0c7808ULL, 0x000fe40002800000ULL, 0x0000006489ff7212ULL, 0x080fe4000780c0ffULL,
0x0000006495ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006a89ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006c89ff7212ULL, 0x000fc4000786c0ffULL, 0x0000006a8fff7212ULL, 0x000fe4000782c0ffULL,
0x00000066a5ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000173627824ULL, 0x000fe200078e0a60ULL,
0x0000001c6500720cULL, 0x0c0fe40000701470ULL, 0x0000001c6500720cULL, 0x0c0fe40001741470ULL,
0x0000001c6500720cULL, 0x080fe40001f61470ULL, 0x0000001c8d00720cULL, 0x000fc40000f21470ULL,
0x0000001c9300720cULL, 0x080fe40002781470ULL, 0x0000001ca300720cULL, 0x080fe40002fa1470ULL,
0x000000214fa97812ULL, 0x000fe400078efcffULL, 0x0000001c6700720cULL, 0x0c0fe40000701070ULL,
0x0000001c6700720cULL, 0x0c0fe40001741070ULL, 0x0000001c6700720cULL, 0x000fc40001f61070ULL,
0x0000001c8b00720cULL, 0x080fe40000f21070ULL, 0x0000001c9100720cULL, 0x080fe40002781070ULL,
0x0000001c9900720cULL, 0x000fe40002fa1070ULL, 0x00000062cfa77219ULL, 0x000fe400000006ffULL,
0x000054107b707816ULL, 0x000fe20000000070ULL, 0x00000001a9ab7824ULL, 0x000fe200078e029bULL,
0xff8000000b0b7808ULL, 0x000fc40000000000ULL, 0xff8000003a3a7808ULL, 0x000fe40001000000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff8000000d0d7808ULL, 0x000fe40002000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0x000000668fff7212ULL, 0x000fc4000780c0ffULL, 0x0000006c8fff7212ULL, 0x000fe4000784c0ffULL,
0x0000006695ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006aa5ff7212ULL, 0x040fe4000782c0ffULL,
0x0000006ca5ff7212ULL, 0x000fe4000788c0ffULL, 0x00000070a7ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ab687824ULL, 0x000fe200078e0a60ULL, 0x0000001c8d00720cULL, 0x000fc40000701470ULL,
0x0000001c8d00720cULL, 0x080fe40001741470ULL, 0x0000001c9300720cULL, 0x080fe40001f61470ULL,
0x0000001ca300720cULL, 0x0c0fe40000f21470ULL, 0x0000001ca300720cULL, 0x080fe40002781470ULL,
0x0000001c7300720cULL, 0x000fe40002fa1470ULL, 0x000000284faf7812ULL, 0x000fc400078efcffULL,
0x000000294fb57812ULL, 0x000fe400078efcffULL, 0x0000001c8b00720cULL, 0x0c0fe40000701070ULL,
0x0000001c8b00720cULL, 0x080fe40001741070ULL, 0x0000001c9100720cULL, 0x080fe40001f61070ULL,
0x0000001c9900720cULL, 0x0c0fe40000f21070ULL, 0x0000001c9900720cULL, 0x000fc40002781070ULL,
0x0000001c7100720cULL, 0x000fe40002fa1070ULL, 0x00000068cfad7219ULL, 0x000fe400000006ffULL,
0x00005410776e7816ULL, 0x000fe4000000006eULL, 0x00005410d3747816ULL, 0x000fe40000000074ULL,
0x00005410d7847816ULL, 0x000fe20000000084ULL, 0x00000001afb17824ULL, 0x100fe200078e029bULL,
0xff80000024247808ULL, 0x000fe20000000000ULL, 0x00000001b5b77824ULL, 0x000fe200078e029bULL,
0xff80000046467808ULL, 0x000fc40001000000ULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff80000040407808ULL, 0x000fe40000800000ULL, 0xff8000003c3c7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x0000005887ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006a95ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006c95ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006ea7ff7212ULL, 0x040fe4000786c0ffULL, 0x00000074a7ff7212ULL, 0x040fe4000782c0ffULL,
0x00000084a7ff7212ULL, 0x000fe4000788c0ffULL, 0x00000074adff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b1727824ULL, 0x100fe200078e0a60ULL, 0x0000001c6300720cULL, 0x080fe200037c1470ULL,
0x00000001b7607824ULL, 0x000fe200078e0a60ULL, 0x0000001c9300720cULL, 0x000fc40000701470ULL,
0x0000001c9300720cULL, 0x080fe40001741470ULL, 0x0000001c7300720cULL, 0x0c0fe40001f61470ULL,
0x0000001c7300720cULL, 0x0c0fe40000f21470ULL, 0x0000001c7300720cULL, 0x080fe40002781470ULL,
0x0000001cab00720cULL, 0x080fe40002fa1470ULL, 0x0000001c8500720cULL, 0x000fc400037c1070ULL,
0x0000001c9100720cULL, 0x0c0fe40000701070ULL, 0x0000001c9100720cULL, 0x080fe40001741070ULL,
0x0000001c7100720cULL, 0x0c0fe40001f61070ULL, 0x0000001c7100720cULL, 0x0c0fe40000f21070ULL,
0x0000001c7100720cULL, 0x080fe40002781070ULL, 0x0000001ca900720cULL, 0x000fc40002fa1070ULL,
0x00000072cfb37219ULL, 0x040fe400000006ffULL, 0x00000060cfb97219ULL, 0x000fe400000006ffULL,
0xff8000000a0a7808ULL, 0x000fe40003000000ULL, 0xff8000003f3f7808ULL, 0x000fe40000000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001000000ULL, 0xff8000000f0f7808ULL, 0x000fc40001800000ULL,
0xff80000041417808ULL, 0x000fe40000800000ULL, 0xff8000003e3e7808ULL, 0x000fe40002000000ULL,
0xff80000042427808ULL, 0x000fe40002800000ULL, 0x00000064a5ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006eadff7212ULL, 0x080fe4000780c0ffULL, 0x0000006eb3ff7212ULL, 0x000fc4000784c0ffULL,
0x00000070adff7212ULL, 0x040fe4000786c0ffULL, 0x00000084adff7212ULL, 0x000fe4000782c0ffULL,
0x00000070b3ff7212ULL, 0x000fe4000788c0ffULL, 0x00000074b9ff7212ULL, 0x000fe200078ac0ffULL,
0x000000017f787824ULL, 0x000fe200078e0a76ULL, 0x0000001ca300720cULL, 0x080fe400037c1470ULL,
0x0000001cab00720cULL, 0x000fc40000701470ULL, 0x0000001cab00720cULL, 0x0c0fe40001f61470ULL,
0x0000001cab00720cULL, 0x080fe40000f21470ULL, 0x0000001cb100720cULL, 0x0c0fe40001741470ULL,
0x0000001cb100720cULL, 0x080fe40002781470ULL, 0x0000001cb700720cULL, 0x000fe40002fa1470ULL,
0x000000314fbf7812ULL, 0x000fc400078efcffULL, 0x000000384fc57812ULL, 0x040fe400078efcffULL,
0x000000394fcb7812ULL, 0x000fe400078efcffULL, 0x0000001c9900720cULL, 0x080fe400037c1070ULL,
0x0000001ca900720cULL, 0x0c0fe40000701070ULL, 0x0000001ca900720cULL, 0x0c0fe40001f61070ULL,
0x0000001ca900720cULL, 0x000fc40000f21070ULL, 0x0000001caf00720cULL, 0x0c0fe40001741070ULL,
0x0000001caf00720cULL, 0x080fe40002781070ULL, 0x0000001cb500720cULL, 0x000fe40002fa1070ULL,
0x00000078cfbd7219ULL, 0x000fe400000006ffULL, 0x00005410bb7c7816ULL, 0x000fe4000000007cULL,
0x00005410d5827816ULL, 0x000fe20000000082ULL, 0x00000001bfc17824ULL, 0x100fe200078e029bULL,
0xff8000000e0e7808ULL, 0x000fe20003000000ULL, 0x00000001c5c77824ULL, 0x100fe200078e029bULL,
0xff80000010107808ULL, 0x000fe20000000000ULL, 0x00000001cbcd7824ULL, 0x000fe200078e029bULL,
0xff8000002c2c7808ULL, 0x000fc40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff80000044447808ULL, 0x000fe40002800000ULL, 0x0000006eb9ff7212ULL, 0x040fe400078cc0ffULL,
0x00000070b9ff7212ULL, 0x000fc4000780c0ffULL, 0x00000074b3ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084b3ff7212ULL, 0x080fe4000782c0ffULL, 0x00000084b9ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007cbdff7212ULL, 0x040fe4000788c0ffULL, 0x00000082bdff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c17a7824ULL, 0x100fe200078e0a76ULL, 0x0000001cb100720cULL, 0x080fe20001f61470ULL,
0x00000001c77e7824ULL, 0x100fe200078e0a76ULL, 0x0000001cb100720cULL, 0x080fe20000f21470ULL,
0x00000001cd767824ULL, 0x000fe200078e0a76ULL, 0x0000001cb700720cULL, 0x000fc400037c1470ULL,
0x0000001cb700720cULL, 0x0c0fe40000701470ULL, 0x0000001cb700720cULL, 0x080fe40001741470ULL,
0x0000001c7f00720cULL, 0x0c0fe40002781470ULL, 0x0000001c7f00720cULL, 0x000fe40002fa1470ULL,
0x0000007acfc37219ULL, 0x040fe400000006ffULL, 0x0000007ecfc97219ULL, 0x000fc400000006ffULL,
0x0000001caf00720cULL, 0x0c0fe40001f61070ULL, 0x0000001caf00720cULL, 0x080fe40000f21070ULL,
0x0000001cb500720cULL, 0x0c0fe400037c1070ULL, 0x0000001cb500720cULL, 0x0c0fe40000701070ULL,
0x0000001cb500720cULL, 0x080fe40001741070ULL, 0x0000001c7d00720cULL, 0x000fc40002781070ULL,
0x0000001c7d00720cULL, 0x000fe40002fa1070ULL, 0x00000076cfcf7219ULL, 0x000fe400000006ffULL,
0x00005410d1807816ULL, 0x000fe40000000080ULL, 0xff80000043437808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40000800000ULL, 0xff80000012127808ULL, 0x000fc40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001000000ULL,
0xff80000013137808ULL, 0x000fe40002000000ULL, 0xff80000045457808ULL, 0x000fe40002800000ULL,
0x0000007cc3ff7212ULL, 0x080fe4000786c0ffULL, 0x0000007cc9ff7212ULL, 0x000fc4000782c0ffULL,
0x0000007ccfff7212ULL, 0x000fe400078cc0ffULL, 0x00000080bdff7212ULL, 0x080fe4000780c0ffULL,
0x00000080c3ff7212ULL, 0x080fe4000784c0ffULL, 0x00000080c9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000082c3ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001c7f00720cULL, 0x000fc40000701470ULL,
0x0000001cc100720cULL, 0x0c0fe40001f61470ULL, 0x0000001cc100720cULL, 0x0c0fe40001741470ULL,
0x0000001cc100720cULL, 0x080fe40002fa1470ULL, 0x0000001cc700720cULL, 0x080fe40000f21470ULL,
0x0000001ccd00720cULL, 0x080fe400037c1470ULL, 0x0000001cc700720cULL, 0x000fc40002781470ULL,
0x0000001c7d00720cULL, 0x080fe40000701070ULL, 0x0000001cbf00720cULL, 0x0c0fe40001f61070ULL,
0x0000001cbf00720cULL, 0x0c0fe40001741070ULL, 0x0000001cbf00720cULL, 0x080fe40002fa1070ULL,
0x0000001cc500720cULL, 0x080fe40000f21070ULL, 0x0000001ccb00720cULL, 0x000fc400037c1070ULL,
0x0000001cc500720cULL, 0x000fe40002781070ULL, 0x00005410d9867816ULL, 0x000fe40000000086ULL,
0xff80000031317808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff80000047477808ULL, 0x000fc40002800000ULL,
0xff80000015157808ULL, 0x000fe40000800000ULL, 0xff80000016167808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40002000000ULL, 0x00000080cfff7212ULL, 0x000fe4000780c0ffULL,
0x00000082c9ff7212ULL, 0x080fe4000786c0ffULL, 0x00000082cfff7212ULL, 0x000fc4000784c0ffULL,
0x00000086bdff7212ULL, 0x080fe400078ac0ffULL, 0x00000086c3ff7212ULL, 0x080fe4000782c0ffULL,
0x00000086c9ff7212ULL, 0x080fe400078cc0ffULL, 0x00000086cfff7212ULL, 0x000fe4000788c0ffULL,
0x0000001c7f00720cULL, 0x080fe40002fa1470ULL, 0x0000001cc100720cULL, 0x000fc40000f21470ULL,
0x0000001cc700720cULL, 0x0c0fe40001f61470ULL, 0x0000001cc700720cULL, 0x080fe400037c1470ULL,
0x0000001ccd00720cULL, 0x0c0fe40000701470ULL, 0x0000001ccd00720cULL, 0x0c0fe40001741470ULL,
0x0000001ccd00720cULL, 0x080fe40002781470ULL, 0x0000001c7d00720cULL, 0x000fc40002fa1070ULL,
0x0000001cbf00720cULL, 0x080fe40000f21070ULL, 0x0000001ccb00720cULL, 0x080fe40000701070ULL,
0x0000001cc500720cULL, 0x0c0fe40001f61070ULL, 0x0000001cc500720cULL, 0x080fe400037c1070ULL,
0x0000001ccb00720cULL, 0x0c0fe40001741070ULL, 0x0000001ccb00720cULL, 0x000fc40002781070ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000049497808ULL, 0x000fe40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002800000ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0xff80000030307808ULL, 0x000fc40003000000ULL,
0xff80000035357808ULL, 0x000fc40002000000ULL, 0x000000030400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff547424ULL, 0x000fe200078e00ffULL, 0x000000180500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff5b7424ULL, 0x000fe200078e00ffULL, 0x000000330600720bULL, 0x000fe40003f5e000ULL,
0x0000004a0700720bULL, 0x000fe40003f7e000ULL, 0x00000004034f7208ULL, 0x000fe40004000000ULL,
0x0000000518047208ULL, 0x000fc40004800000ULL, 0x0000000633067208ULL, 0x000fe40005000000ULL,
0x000000074a1c7208ULL, 0x000fe40005800000ULL, 0x000000170400720bULL, 0x000fe40003f3e000ULL,
0x000000084f00720bULL, 0x000fe40003f1e000ULL, 0x000000370600720bULL, 0x000fe40003f5e000ULL,
0x0000004b1c00720bULL, 0x000fc40003f7e000ULL, 0x0000000417047208ULL, 0x000fe40004800000ULL,
0x0000004f08507208ULL, 0x000fe40004000000ULL, 0x0000000637057208ULL, 0x000fe40005000000ULL,
0x0000001c4b1c7208ULL, 0x000fe40005800000ULL, 0x000000190400720bULL, 0x000fe40003f3e000ULL,
0x000000095000720bULL, 0x000fc40003f1e000ULL, 0x000000380500720bULL, 0x000fe40003f5e000ULL,
0x0000004d1c00720bULL, 0x000fe40003f7e000ULL, 0x00000004194f7208ULL, 0x000fe40004800000ULL,
0x0000005009077208ULL, 0x000fe40004000000ULL, 0x0000000538047208ULL, 0x000fe40005000000ULL,
0x0000001c4d057208ULL, 0x000fc40005800000ULL, 0x0000000a0700720bULL, 0x000fe40003f1e000ULL,
0x0000001a4f00720bULL, 0x000fe40003f3e000ULL, 0x000000390400720bULL, 0x000fe40003f5e000ULL,
0x0000004e0500720bULL, 0x000fe40003f7e000ULL, 0x000000070a067208ULL, 0x000fe40004000000ULL,
0x0000004f1a1c7208ULL, 0x000fc40004800000ULL, 0x0000000439077208ULL, 0x000fe40005000000ULL,
0x000000054e057208ULL, 0x000fe40005800000ULL, 0x0000000b0600720bULL, 0x000fe40003f1e000ULL,
0x0000001b1c00720bULL, 0x000fe40003f3e000ULL, 0x0000003a0700720bULL, 0x000fe40003f5e000ULL,
0x0000004c0500720bULL, 0x000fc40003f7e000ULL, 0x000000060b4f7208ULL, 0x000fe40004000000ULL,
0x0000001c1b517208ULL, 0x000fe40004800000ULL, 0x000000073a047208ULL, 0x000fe40005000000ULL,
0x000000054c057208ULL, 0x000fe40005800000ULL, 0x0000000c4f00720bULL, 0x000fe40003f1e000ULL,
0x000000245100720bULL, 0x000fc40003f3e000ULL, 0x0000003d0400720bULL, 0x000fe40003f5e000ULL,
0x000000460500720bULL, 0x000fe40003f7e000ULL, 0x0000004f0c067208ULL, 0x000fe40004000000ULL,
0x00000051241c7208ULL, 0x000fe40004800000ULL, 0x000000043d047208ULL, 0x000fe40005000000ULL,
0x0000000546507208ULL, 0x000fc40005800000ULL, 0x0000000d0600720bULL, 0x000fe40003f1e000ULL,
0x000000251c00720bULL, 0x000fe40003f3e000ULL, 0x0000003f0400720bULL, 0x000fe40003f5e000ULL,
0x0000003b5000720bULL, 0x000fe40003f7e000ULL, 0x000000060d057208ULL, 0x000fe40004000000ULL,
0x0000001c25077208ULL, 0x000fc40004800000ULL, 0x000000043f4f7208ULL, 0x000fe40005000000ULL,
0x000000503b517208ULL, 0x000fe40005800000ULL, 0x0000000e0500720bULL, 0x000fe40003f1e000ULL,
0x000000260700720bULL, 0x000fe40003f3e000ULL, 0x000000404f00720bULL, 0x000fe40003f5e000ULL,
0x0000003c5100720bULL, 0x000fc40003f7e000ULL, 0x000000050e047208ULL, 0x000fe40004000000ULL,
0x0000000726077208ULL, 0x000fe40004800000ULL, 0x0000004f40067208ULL, 0x000fe40005000000ULL,
0x000000513c517208ULL, 0x000fe40005800000ULL, 0x0000000f0400720bULL, 0x000fe40003f1e000ULL,
0x000000280700720bULL, 0x000fc40003f3e000ULL, 0x000000410600720bULL, 0x000fe40003f5e000ULL,
0x0000003e5100720bULL, 0x000fe40003f7e000ULL, 0x000000040f057208ULL, 0x000fe40004000000ULL,
0x0000000728077208ULL, 0x000fe40004800000ULL, 0x00000006414f7208ULL, 0x000fe40005000000ULL,
0x000000513e517208ULL, 0x000fc40005800000ULL, 0x000000100500720bULL, 0x000fe40003f1e000ULL,
0x0000002c0700720bULL, 0x000fe40003f3e000ULL, 0x000000424f00720bULL, 0x000fe40003f5e000ULL,
0x0000002a5100720bULL, 0x000fe40003f7e000ULL, 0x0000000510047208ULL, 0x000fe40004000000ULL,
0x000000072c067208ULL, 0x000fc40004800000ULL, 0x0000004f421c7208ULL, 0x000fe40005000000ULL,
0x000000512a507208ULL, 0x000fe40005800000ULL, 0x000000110400720bULL, 0x000fe40003f1e000ULL,
0x0000002d0600720bULL, 0x000fe40003f3e000ULL, 0x000000431c00720bULL, 0x000fe40003f5e000ULL,
0x000000275000720bULL, 0x000fc40003f7e000ULL, 0x0000000411057208ULL, 0x000fe40004000000ULL,
0x000000062d067208ULL, 0x000fe40004800000ULL, 0x0000001c43077208ULL, 0x000fe40005000000ULL,
0x0000005027507208ULL, 0x000fe40005800000ULL, 0x000000120500720bULL, 0x000fe40003f1e000ULL,
0x0000002f0600720bULL, 0x000fc40003f3e000ULL, 0x000000440700720bULL, 0x000fe40003f5e000ULL,
0x000000295000720bULL, 0x000fe40003f7e000ULL, 0x0000000512047208ULL, 0x000fe40004000000ULL,
0x000000062f067208ULL, 0x000fe40004800000ULL, 0x00000007441c7208ULL, 0x000fe40005000000ULL,
0x0000005029507208ULL, 0x000fc40005800000ULL, 0x000000130400720bULL, 0x000fe40003f1e000ULL,
0x000000310600720bULL, 0x000fe40003f3e000ULL, 0x000000451c00720bULL, 0x000fe40003f5e000ULL,
0x0000002b5000720bULL, 0x000fe40003f7e000ULL, 0x0000000413057208ULL, 0x000fe40004000000ULL,
0x0000000631077208ULL, 0x000fc40004800000ULL, 0x0000001c451c7208ULL, 0x000fe40005000000ULL,
0x000000502b4f7208ULL, 0x000fe40005800000ULL, 0x000000140500720bULL, 0x000fe40003f1e000ULL,
0x000000320700720bULL, 0x000fe40003f3e000ULL, 0x000000471c00720bULL, 0x000fe40003f5e000ULL,
0x0000002e4f00720bULL, 0x000fc40003f7e000ULL, 0x0000000514047208ULL, 0x000fe40004000000ULL,
0x0000000732077208ULL, 0x000fe40004800000ULL, 0x0000001c47057208ULL, 0x000fe40005000000ULL,
0x0000004f2e4f7208ULL, 0x000fe40005800000ULL, 0x000000150400720bULL, 0x000fe40003f1e000ULL,
0x000000340700720bULL, 0x000fc40003f3e000ULL, 0x000000480500720bULL, 0x000fe40003f5e000ULL,
0x000000304f00720bULL, 0x000fe40003f7e000ULL, 0x0000000415517208ULL, 0x000fe40004000000ULL,
0x0000000734077208ULL, 0x000fe40004800000ULL, 0x0000000548047208ULL, 0x000fe40005000000ULL,
0x0000004f30067208ULL, 0x000fc40005800000ULL, 0x000000165100720bULL, 0x000fe40003f1e000ULL,
0x000000360700720bULL, 0x000fe40003f3e000ULL, 0x000000490400720bULL, 0x000fe40003f5e000ULL,
0x000000350600720bULL, 0x000fe40003f7e000ULL, 0x0000005116057208ULL, 0x000fe40004000000ULL,
0x0000000736537208ULL, 0x000fc40004800000ULL, 0x0000000449527208ULL, 0x000fe40005000000ULL,
0x0000000635557208ULL, 0x000fe20005800000ULL, 0x000020e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x000000040500720bULL, 0x008fc80003f1e000ULL,
0x0000000504597208ULL, 0x000fe20004000000ULL, 0x000021027f007947ULL, 0x000fea000b800000ULL,
0x0c401f0053047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0052057f89ULL, 0x004ea800000e0000ULL,
0x0c401f0055067f89ULL, 0x000f2200000e0000ULL, 0x000000045300720bULL, 0x008fc40003f1e000ULL,
0x000000055200720bULL, 0x004fe40003f3e000ULL, 0x0000005304077208ULL, 0x002fe40004000000ULL,
0x00000052051c7208ULL, 0x000fe20004800000ULL, 0x0c201f0059047f89ULL, 0x000e6200000e0000ULL,
0x000000065500720bULL, 0x010fc60003f1e000ULL, 0x0c201f0007507f89ULL, 0x000ea200000e0000ULL,
0x0000005506577208ULL, 0x000fc60004000000ULL, 0x0c201f001c4f7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0057587f89ULL, 0x0002e400000e0000ULL, 0x000000045900720bULL, 0x002fe40003f1e000ULL,
0x000000500700720bULL, 0x004fe40003f3e000ULL, 0x0000005904047208ULL, 0x000fc40004000000ULL,
0x0000004f1c00720bULL, 0x008fe40003f5e000ULL, 0x0000000750057208ULL, 0x000fe40004800000ULL,
0x0000001c4f067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x000000585700720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe40000000000ULL,
0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x0000000300597308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f507823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10517823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11537823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b12547823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13037823ULL, 0x102fe20000010807ULL,
0x3fb8aa3b141c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b154f7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b16527823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b06127820ULL, 0x000fe20000410000ULL, 0x0000000900097308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b2f107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b312f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b32567823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b36557823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010812ULL, 0x0000005758077208ULL, 0x000fe20004000000ULL,
0x00000010005d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010812ULL,
0x0000003300107308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b45457823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b48487823ULL, 0x000fe20000010812ULL,
0x00000025000f7308ULL, 0x0005e20000000800ULL, 0x00000002ff337819ULL, 0x002fe20000011620ULL,
0x3fb8aa3b49127823ULL, 0x000fe20000010812ULL, 0x0000000320ff7812ULL, 0x000fc4000780c0ffULL,
0x0000000133137810ULL, 0x040fe20007ffe0ffULL, 0x0000000833587824ULL, 0x000fe400078e00ffULL,
0x0000000a000a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b07257820ULL, 0x004fe20000410000ULL,
0x0000000833317824ULL, 0x040fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fe200078ee213ULL,
0x00000008335e7824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010825ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010825ULL,
0x000000090a0a723eULL, 0x002fe200000010ffULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010825ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010825ULL,
0x3fb8aa3b35357823ULL, 0x000fca0000010825ULL, 0x0000000800087308ULL, 0x000eb00000000800ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x0000000b0c0c723eULL, 0x002fce00000010ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x000000590808723eULL, 0x004fce00000010ffULL,
0x0000001900197308ULL, 0x000ff00000000800ULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x000000181709723eULL, 0x002fce00000010ffULL, 0x0000002c005b7308ULL, 0x0003f00000000800ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x00000002332c7810ULL, 0x002fe40007ffe0ffULL,
0x000000191a0b723eULL, 0x004fca00000010ffULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e700000000800ULL, 0x0000004a00117308ULL, 0x0005f00000000800ULL,
0x0000004b00327308ULL, 0x000ee20000000800ULL, 0xfffffff8314a7812ULL, 0x004fe200078ee22cULL,
0x00000004ff2c7e24ULL, 0x000fe2000f8e00ffULL, 0x000000103710723eULL, 0x002fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000833377824ULL, 0x040fe200078e00ffULL,
0x0000000633317810ULL, 0x000fc40007ffe0ffULL, 0x0000004d00137308ULL, 0x000fe20000000800ULL,
0x3f8000002c2c783eULL, 0x000fc800000010ffULL, 0x0000002c00657202ULL, 0x000fe20000000f00ULL,
0x000000ffff627224ULL, 0x100fe400078e002cULL, 0x0000004e004e7308ULL, 0x000e620000000800ULL,
0x000000113211723eULL, 0x008fe200000010ffULL, 0x000000ffff637224ULL, 0x100fe200078e002cULL,
0xffffffff33327810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff647224ULL, 0x100fe400078e002cULL,
0x000000ffff4b7224ULL, 0x000fe400078e002cULL, 0x0000000d000d7308ULL, 0x000ff00000000800ULL,
0x0000000e000e7308ULL, 0x000ea20000000800ULL, 0x000000134e13723eULL, 0x002fe200000010ffULL,
0x00000008334e7824ULL, 0x000fca00078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee231ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x0000000d0e0e723eULL, 0x004fce00000010ffULL, 0x0000003f00167308ULL, 0x000ff00000000800ULL,
0x0000004700367308ULL, 0x0005e20000000800ULL, 0x0000001b240d723eULL, 0x002fce00000010ffULL,
0x0000002d005a7308ULL, 0x0003e20000000800ULL, 0x0000000833477824ULL, 0x004fca00078e00ffULL,
0xfffffff847607812ULL, 0x000fe400078ee232ULL, 0x00000012003f7308ULL, 0x0005e20000000800ULL,
0x00000004332d7810ULL, 0x042fe40007ffe0ffULL, 0x0000001033327810ULL, 0x040fe40007ffe0ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee22dULL, 0x000000ffff2d7224ULL, 0x000fe400078e002cULL,
0x0000003a00147308ULL, 0x000fe20000000800ULL, 0x0000000333127810ULL, 0x004fe20007ffe0ffULL,
0x0000000832497824ULL, 0x000fc600078e00ffULL, 0xfffffff8475c7812ULL, 0x000fe200078ee212ULL,
0x0000002c0818723cULL, 0x000f6200000418ffULL, 0x000000383912723eULL, 0x000fe200000010ffULL,
0x000000ffff387224ULL, 0x100fe200078e002cULL, 0x0000004000157308ULL, 0x0002a20000000800ULL,
0x000000ffff397224ULL, 0x000fce00078e002cULL, 0x0000003b00247308ULL, 0x0007e20000000800ULL,
0x0000000833407824ULL, 0x002fca00078e00ffULL, 0xfffffff840407812ULL, 0x000fe400078ee233ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000381038723cULL, 0x008f6200000418ffULL,
0x000000161516723eULL, 0x004fcc00000010ffULL, 0x0000004c004c7308ULL, 0x000ff00000000800ULL,
0x0000004600177308ULL, 0x0004e20000000800ULL, 0x0000000f260f723eULL, 0x002fe400000010ffULL,
0x0000000533267810ULL, 0x000fca0007ffe0ffULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0xfffffff837467812ULL, 0x004fe200078ee226ULL, 0x000000620c18723cULL, 0x020b620000041818ULL,
0x3fb8aa3b2e377823ULL, 0x000fe20000010825ULL, 0x0000000833267810ULL, 0x040fe40007ffe0ffULL,
0x0000001833337810ULL, 0x000fe40007ffe0ffULL, 0x0000003c002d7308ULL, 0x000ea20000000800ULL,
0x0000004c1715723eULL, 0x008fe200000010ffULL, 0x0000000826477824ULL, 0x000fe200078e00ffULL,
0xfffffff849627812ULL, 0x020fc400078ee232ULL, 0x0000000c02497812ULL, 0x000fe400078ec0ffULL,
0xfffffff8474c7812ULL, 0x000fe200078ee226ULL, 0x0000002800287308ULL, 0x000ee20000000800ULL,
0x000000143d14723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b303d7823ULL, 0x000fe20000010825ULL,
0x000000242d17723eULL, 0x004fca00000010ffULL, 0x0000005000507308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2d7823ULL, 0x000fe20000010825ULL, 0x000000641438723cULL, 0x000f620000041838ULL,
0x000000285b25723eULL, 0x008fca00000010ffULL, 0x0000005100517308ULL, 0x000e620000000800ULL,
0x000000ffff5b7224ULL, 0x000fce00078e002cULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000005400547308ULL, 0x000ea20000000800ULL, 0x000000505124723eULL, 0x002fe200000010ffULL,
0x0000000833507824ULL, 0x000fca00078e00ffULL, 0xfffffff850507812ULL, 0x000fe200078ee233ULL,
0x0000004100417308ULL, 0x000ff00000000800ULL, 0x0000004200427308ULL, 0x000e620000000800ULL,
0x000000535426723eULL, 0x004fce00000010ffULL, 0x0000004300437308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000ea20000000800ULL, 0x000000414228723eULL, 0x002fe200000010ffULL,
0x000000ffff427224ULL, 0x000fcc00078e002cULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000002a00317308ULL, 0x0004700000000800ULL, 0x00000027002b7308ULL, 0x0007e20000000800ULL,
0x00000043442a723eULL, 0x004fe200000010ffULL, 0x000000ffff437224ULL, 0x000fcc00078e002cULL,
0x00000029002e7308ULL, 0x0002a20000000800ULL, 0x0000005a5d27723eULL, 0x008fe200000010ffULL,
0x000000ffff5a7224ULL, 0x000fcc00078e002cULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x0000003e3129723eULL, 0x002fe400000010ffULL, 0x0000005a2430723cULL, 0x000b6a0000041818ULL,
0x0000001c001c7308ULL, 0x000e620000000800ULL, 0x0000002b2e2b723eULL, 0x004fce00000010ffULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x000000422838723cULL, 0x020bee0000041838ULL,
0x0000005600567308ULL, 0x000ea20000000800ULL, 0x000000031c18723eULL, 0x002fe400000010ffULL,
0x0000a0009a037811ULL, 0x000fca00078e60ffULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x00000010401c7824ULL, 0x100fe400078e0203ULL, 0x00000010582e7824ULL, 0x100fe400078e0203ULL,
0x000000104a3e7824ULL, 0x100fe400078e0203ULL, 0x000000105c407824ULL, 0x100fe200078e0203ULL,
0x0000005500557308ULL, 0x000e620000000800ULL, 0x0000002f5619723eULL, 0x004fe200000010ffULL,
0x000000105e417824ULL, 0x000fe200078e0203ULL, 0x0000002e492e7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4a7224ULL, 0x000fc400078e002cULL, 0x00000001492f7824ULL, 0x040fe400078e021cULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x0000001046427824ULL, 0x120fe400078e0203ULL,
0x000000104e437824ULL, 0x100fe200078e0203ULL, 0x000000082f007388ULL, 0x0005e20000000800ULL,
0x00000001493e7824ULL, 0x000fe400078e023eULL, 0x0000001060447824ULL, 0x100fe200078e0203ULL,
0x0000005200527308ULL, 0x000ee20000000800ULL, 0x00000034551b723eULL, 0x002fe200000010ffULL,
0x0000000149407824ULL, 0x000fe200078e0240ULL, 0x0000000a2e007388ULL, 0x0005e20000000800ULL,
0x000000104c1c7824ULL, 0x000fc400078e0203ULL, 0x0000000149417824ULL, 0x040fe200078e0241ULL,
0x0000000c3e007388ULL, 0x0005e20000000800ULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0x0000000149427824ULL, 0x040fe400078e0242ULL, 0x0000000149437824ULL, 0x040fe200078e0243ULL,
0x0000000e40007388ULL, 0x0005e20000000800ULL, 0x0000000149447824ULL, 0x040fe400078e0244ULL,
0x00000001491c7824ULL, 0x000fe200078e021cULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x0000004f521a723eULL, 0x008fe200000010ffULL, 0x0000002441007388ULL, 0x0005e20000000800ULL,
0x0000001062467824ULL, 0x000fc400078e0203ULL, 0x0000001050477824ULL, 0x000fe200078e0203ULL,
0x0000002642007388ULL, 0x0005e20000000800ULL, 0x0000000149037824ULL, 0x000fe200078e0246ULL,
0x00000037003c7308ULL, 0x000fe20000000800ULL, 0x000000453634723eULL, 0x002fe200000010ffULL,
0x0000004a1830723cULL, 0x000f620000041830ULL, 0x0000001843007388ULL, 0x0005e80000000800ULL,
0x0000001a44007388ULL, 0x0005e20000000800ULL, 0x0000004800487308ULL, 0x000e660000000800ULL,
0x000000091c007388ULL, 0x0005e80000000800ULL, 0x0004000b2e007388ULL, 0x0005e20000000800ULL,
0x0000003d003d7308ULL, 0x000fe60000000800ULL, 0x0004000d3e007388ULL, 0x0005e80000000800ULL,
0x0004000f40007388ULL, 0x0005e20000000800ULL, 0x0000003500027308ULL, 0x0007220000000800ULL,
0x000000483f36723eULL, 0x002fe200000010ffULL, 0x000000ffff317224ULL, 0x020fe200078e0032ULL,
0x0004002541007388ULL, 0x0005e80000000800ULL, 0x0004002742007388ULL, 0x0005e20000000800ULL,
0x0000002d3c35723eULL, 0x008fe200000010ffULL, 0x000000ffff2d7224ULL, 0x000fc400078e002cULL,
0x0004001943007388ULL, 0x0005e80000000800ULL, 0x0004001b44007388ULL, 0x0005e20000000800ULL,
0x0000003d0237723eULL, 0x010fe200000010ffULL, 0x0000000149027824ULL, 0x000fe400078e0247ULL,
0x0000001003007388ULL, 0x0005e80000000800ULL, 0x0000002c3438723cULL, 0x000f620000041838ULL,
0x000800122e007388ULL, 0x0005e80000000800ULL, 0x000800143e007388ULL, 0x0005e80000000800ULL,
0x0008001640007388ULL, 0x0005e80000000800ULL, 0x0008002841007388ULL, 0x0005e80000000800ULL,
0x0008002a42007388ULL, 0x0005e80000000800ULL, 0x0008003443007388ULL, 0x0005e60000000800ULL,
0x000000ffff327224ULL, 0x020fe200078e0038ULL, 0x0008003644007388ULL, 0x0005e20000000800ULL,
0x000000ffff337224ULL, 0x000fc600078e003aULL, 0x0000001102007388ULL, 0x0005e80000000800ULL,
0x000c00132e007388ULL, 0x0005e80000000800ULL, 0x000c00153e007388ULL, 0x0005e80000000800ULL,
0x000c001740007388ULL, 0x0005e80000000800ULL, 0x000c002941007388ULL, 0x0005e80000000800ULL,
0x000c002b42007388ULL, 0x0005e80000000800ULL, 0x000c003543007388ULL, 0x0005e80000000800ULL,
0x000c003744007388ULL, 0x0005e80000000800ULL, 0x0160000400008388ULL, 0x0005e80000000c00ULL,
0x0162003000008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01660800a0ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01661000a0ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01661800a0ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000227900720cULL, 0x000fe20003f06070ULL, 0x01662000a0ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff957224ULL, 0x000fd600078e0079ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff7a1000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff1e7807ULL, 0x008fe40004000000ULL, 0x0001901000207802ULL, 0x000fc40000000f00ULL,
0x0000109000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e001eULL,
0xfffea18000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x000fe40005000000ULL,
0x0001906000207802ULL, 0x000fc40000000f00ULL, 0x0000104000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e001eULL, 0xfffea1f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x000190b0001f7802ULL, 0x000fc40000000f00ULL,
0x00000fa000007944ULL, 0x012fea0003c00000ULL, 0xfffea2c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x000190f0001f7802ULL, 0x000fc40000000f00ULL,
0x00000f6000007944ULL, 0x012fea0003c00000ULL, 0xfffea3f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x00019130001f7802ULL, 0x000fc40000000f00ULL,
0x00000f2000007944ULL, 0x012fea0003c00000ULL, 0xfffea52000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x00019170001f7802ULL, 0x000fc40000000f00ULL,
0x00000ee000007944ULL, 0x012fea0003c00000ULL, 0xfffea64000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0002ULL, 0x000191c0001f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0003ULL, 0x00000e9000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001eULL, 0xfffea7f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0002ULL, 0x00019210001f7802ULL, 0x000fc40000000f00ULL,
0x00000e4000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001eULL,
0x00000010031e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff207224ULL, 0x000fe200078e0002ULL,
0x00019260001f7802ULL, 0x000fc40000000f00ULL, 0x00000df000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001eULL, 0xfffea7a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0002ULL, 0x000192b0001f7802ULL, 0x000fc40000000f00ULL,
0x00000da000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e001eULL,
0xfffea78000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x008fe40004000000ULL,
0x0001930000207802ULL, 0x000fc40000000f00ULL, 0x00000da000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e001eULL, 0xfffebfe000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x000fe40004800000ULL, 0x0001935000207802ULL, 0x000fc40000000f00ULL,
0x00000d5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e001eULL,
0xfffec03000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x000193a0001f7802ULL, 0x000fc40000000f00ULL, 0x00000cb000007944ULL, 0x000fea0003c00000ULL,
0xfffec11000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x000193e0001f7802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x002fea0003c00000ULL,
0xfffec24000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x00019420001f7802ULL, 0x000fc40000000f00ULL, 0x00000c3000007944ULL, 0x002fea0003c00000ULL,
0xfffec37000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x00019460001f7802ULL, 0x000fc40000000f00ULL, 0x00000bf000007944ULL, 0x002fea0003c00000ULL,
0xfffec49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x000194b0001f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0019ULL,
0x00000ba000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e001eULL,
0xfffec63000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x00019500001f7802ULL, 0x000fc40000000f00ULL, 0x00000b5000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001eULL, 0x00000010191e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x00019550001f7802ULL, 0x000fc40000000f00ULL,
0x00000b0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e001eULL,
0xfffec5e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x000195a0001f7802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001eULL, 0xfffec5c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x004fe40004000000ULL, 0x000195f000207802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e001eULL,
0xfffedc2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x000fe40004800000ULL,
0x0001964000207802ULL, 0x000fc40000000f00ULL, 0x00000a6000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff677224ULL, 0x000fe200078e001eULL, 0xfffedc6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0066ULL, 0x00019690001f7802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x018fea0003c00000ULL, 0xfffedd4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0066ULL, 0x000196d0001f7802ULL, 0x000fc40000000f00ULL,
0x0000098000007944ULL, 0x01afea0003c00000ULL, 0xfffede7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0066ULL, 0x00019710001f7802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x01afea0003c00000ULL, 0xfffedfa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0066ULL, 0x00019750001f7802ULL, 0x000fc40000000f00ULL,
0x0000090000007944ULL, 0x01afea0003c00000ULL, 0xfffee0c000007947ULL, 0x000fea000383ffffULL,
0x0000000e00207202ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0065ULL,
0x000197a0001f7802ULL, 0x000fc40000000f00ULL, 0x000008b000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001eULL, 0xfffee26000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x000197f0001f7802ULL, 0x000fc40000000f00ULL,
0x0000086000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001eULL,
0x00000010651e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x00019840001f7802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001eULL, 0xfffee21000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x00019890001f7802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e001eULL,
0xfffee1f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x008fe40004000000ULL,
0x000198e000207802ULL, 0x000fc40000000f00ULL, 0x000007c000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff667224ULL, 0x000fe200078e001eULL, 0xfffef7b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x000fe40004800000ULL, 0x0001993000207802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff677224ULL, 0x000fe200078e001eULL,
0xfffef7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x00019980001f7802ULL, 0x000fc40000000f00ULL, 0x000006d000007944ULL, 0x010fea0003c00000ULL,
0xfffef8d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x000199c0001f7802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x012fea0003c00000ULL,
0xfffefa0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x00019a00001f7802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x012fea0003c00000ULL,
0xfffefb3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x00019a40001f7802ULL, 0x000fc40000000f00ULL, 0x0000061000007944ULL, 0x012fea0003c00000ULL,
0xfffefc5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x00019a90001f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0013ULL,
0x000005c000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e001eULL,
0xfffefdf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x00019ae0001f7802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001eULL, 0x00000010131e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x00019b30001f7802ULL, 0x000fc40000000f00ULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e001eULL,
0xfffefda000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x00019b80001f7802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001eULL, 0xfffefd8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x00019be000507802ULL, 0x000fe20000000f00ULL,
0x00000002ff1c7424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0058ULL, 0xffffded000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x002fe200078e0053ULL, 0x00019c4000507802ULL, 0x000fe20000000f00ULL,
0x00000002ff1c7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x004fea0003c00000ULL,
0x000000585300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0052ULL,
0x00019ca000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005358057208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000585200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0055ULL,
0x00019d0000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x00000052584f7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000585500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0059ULL,
0x00000001001c7802ULL, 0x000fc40000000f00ULL, 0x0000005558577208ULL, 0x000fe40004000000ULL,
0x00019d6000507802ULL, 0x000fc40000000f00ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000585900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0005ULL,
0x00019dc000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005958047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000580500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e004fULL,
0x00019e2000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000000558057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000584f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0057ULL,
0x00019e8000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000004f58067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffdda000007947ULL, 0x000fea000383ffffULL, 0x0180000006007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000600008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000006000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x006fe400078e0008ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe5ff006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff517424ULL, 0x000fe200078e00ffULL,
0x0000005b00007348ULL, 0x000fe80003800000ULL, 0x0c00001c07587389ULL, 0x0002a200000e0054ULL,
0xfffe5fb050007950ULL, 0x000fea0003c3ffffULL, 0x0000008500007348ULL, 0x000fe80003800000ULL,
0x0000001e201e7389ULL, 0x0002a200000e0087ULL, 0x00000000ff217424ULL, 0x000fc400078e00ffULL,
0x000000ffff207224ULL, 0x002fc800078e001fULL, 0xfffe5f6020007950ULL, 0x000fea0003c3ffffULL,
0x000000011e00780cULL, 0x000fe20003f45070ULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000008400007348ULL, 0x000ff60003800000ULL, 0x00000000001e7806ULL, 0x000fc800050e0100ULL,
0x000000841e1e7212ULL, 0x000fe200078ec0ffULL, 0xfffe5f0020007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000200000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000868ULL,
0x00000000000002a8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b10ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bd0ULL,
0x00000000000006d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012a0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012b0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001340ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001344ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x000000000001a200ULL, 0xdc00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b780ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001b7c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001bb40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001340ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001a440ULL,
0x000000000001a440ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001b780ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001bb40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_86_cubin_len = 113696;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
