/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001d240ULL, 0x000000000001cec0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL,
0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL,
0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL,
0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL,
0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL,
0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b002200000377ULL, 0x000000000001b590ULL, 0x0000000000000180ULL,
0x000b0022000003aaULL, 0x000000000001b710ULL, 0x0000000000000040ULL, 0x000b0022000003d5ULL,
0x000000000001b750ULL, 0x0000000000000050ULL, 0x000b0022000003ffULL, 0x000000000001b7a0ULL,
0x0000000000000160ULL, 0x000a00030000046dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000048dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001b900ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001b59000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x006be40400288080ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL,
0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001b59000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080860900ULL, 0x0900000010042880ULL,
0x2880808628808088ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9f08288080890828ULL,
0x288080a008288080ULL, 0x80d208288080b008ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080d29200ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL, 0x0001b71000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0xa008288080890828ULL, 0x288080b008288080ULL, 0x8280162880809f08ULL, 0x0000000003102880ULL,
0x80809f9200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL, 0x0000018800000000ULL,
0x0001b75000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80a02880809f0900ULL,
0x0000000000002880ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9f08288080890828ULL,
0x288080b008288080ULL, 0x828016288080a008ULL, 0x0000000003102880ULL, 0x8080a09200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000022000000000ULL, 0x0001b7a000000000ULL,
0x0000016000000000ULL, 0x0000000000000000ULL, 0x0000001700082f04ULL, 0x00082304000000deULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL,
0x0000000000000011ULL, 0x0000001000082304ULL, 0x0008120400000000ULL, 0x0000000000000010ULL,
0x0000001000081104ULL, 0x0008230400000000ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0068016000000014ULL, 0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000e6000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000019001cc2804ULL,
0x000005a000000360ULL, 0x0000319000002060ULL, 0x0000334000003230ULL, 0x00003620000034b0ULL,
0x0000399000003780ULL, 0x000039e0000039d0ULL, 0x0000437000003a10ULL, 0x00005360000052c0ULL,
0x000055f000005480ULL, 0x000058c000005760ULL, 0x00005b0000005ac0ULL, 0x00005b4000005b10ULL,
0x000071f0000061e0ULL, 0x000073a000007280ULL, 0x0000768000007510ULL, 0x000079e0000077e0ULL,
0x00007a3000007a20ULL, 0x0000807000007a60ULL, 0x0000910000009070ULL, 0x0000939000009220ULL,
0x0000966000009500ULL, 0x000098a000009860ULL, 0x000098e0000098b0ULL, 0x0000a0400000a020ULL,
0x0000a0600000a050ULL, 0x0000ce100000cde0ULL, 0x0000cf100000cec0ULL, 0x0000db100000dad0ULL,
0x0000dbe00000db40ULL, 0x00018c9000018c50ULL, 0x00018cb000018ca0ULL, 0x00018d2000018d00ULL,
0x00018d5000018d40ULL, 0x0001a1f00001a190ULL, 0x0001a2c00001a260ULL, 0x0001a3800001a320ULL,
0x0001a4600001a3f0ULL, 0x0001a5400001a4d0ULL, 0x0001a6000001a5a0ULL, 0x0001a6d00001a670ULL,
0x0001a7900001a730ULL, 0x0001a8700001a800ULL, 0x0001a9500001a8e0ULL, 0x0001aa100001a9b0ULL,
0x0001aae00001aa80ULL, 0x0001aba00001ab40ULL, 0x0001ac800001ac10ULL, 0x0001ad600001acf0ULL,
0x0001ae200001adc0ULL, 0x0001aef00001ae90ULL, 0x0001afb00001af50ULL, 0x0001b0900001b020ULL,
0x0001b1700001b100ULL, 0x0001b2700001b1f0ULL, 0x0001b3700001b2f0ULL, 0x0001b4700001b3f0ULL,
0x0001b5700001b4f0ULL, 0x0000043002003904ULL, 0x0001e600000000ffULL, 0x00000480003f0100ULL,
0x0001e6080000000dULL, 0x00000550003f0120ULL, 0x0001e6880000000dULL, 0x00000e80003f0120ULL,
0x0001e600000000ffULL, 0x00001080003f0107ULL, 0x0001e68c00000080ULL, 0x00001130003f0102ULL,
0x0001e68800000080ULL, 0x00002ea0003f0101ULL, 0x0001e60800000008ULL, 0x00002ec0003f0101ULL,
0x0001e60c00000008ULL, 0x00003090003f0105ULL, 0x0001e60c00000008ULL, 0x00004310003f0105ULL,
0x0001e6880000001cULL, 0x00005000003f0101ULL, 0x0001e6280000001bULL, 0x00005020003f0101ULL,
0x0001e62c0000001bULL, 0x000051f0003f0105ULL, 0x0001e62c0000001bULL, 0x00006190003f0105ULL,
0x000000000000001eULL, 0x00006f30003f0101ULL, 0x0001e6480000001cULL, 0x00006f50003f0101ULL,
0x0001e64c0000001cULL, 0x00007120003f0105ULL, 0x0001e64c0000001cULL, 0x00008050003f0105ULL,
0x000000000000001fULL, 0x00008dc0003f0101ULL, 0x0001e66800000066ULL, 0x00008de0003f0101ULL,
0x0001e66c00000066ULL, 0x00008fb0003f0105ULL, 0x0001e66c00000066ULL, 0x00009ea0003f0105ULL,
0x0000000000000002ULL, 0x0000faf0003f0101ULL, 0x0001e600000000ffULL, 0x00011320003f0101ULL,
0x0001e604000000ffULL, 0x00011530003f0105ULL, 0x0001e604000000ffULL, 0x00015ed0003f0105ULL,
0x00000000000000a0ULL, 0x00015fe0003f0101ULL, 0x00000004000000a0ULL, 0x000161b0003f0105ULL,
0x00000004000000a0ULL, 0x00019fe0003f0105ULL, 0x0001e608000000a1ULL, 0x0001a040003f0101ULL,
0x0001e610000000a1ULL, 0x0001a0a0003f0101ULL, 0x0001e618000000a1ULL, 0x0001a110003f0101ULL,
0x0001e620000000a1ULL, 0x00033803003f0101ULL, 0x0000e97000301c04ULL, 0x0000ec300000e9a0ULL,
0x0000f0100000ee20ULL, 0x0000f3f00000f200ULL, 0x0000f7e00000f5e0ULL, 0x000115900000f990ULL,
0x000004010001a150ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000294ULL, 0x0000001700000002ULL,
0x00000000000001fcULL, 0x0000001700000002ULL, 0x0000000000000174ULL, 0x0000001700000002ULL,
0x00000000000000d4ULL, 0x0000001700000002ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x000000000000026cULL, 0x0000001700000002ULL, 0x00000000000001d4ULL, 0x0000001700000002ULL,
0x0000000000000151ULL, 0x0000001700000002ULL, 0x00000000000000adULL, 0x0000001700000002ULL,
0x000000000001e700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000a57919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff020424ULL, 0x000fe200078e00ffULL,
0x00000001a5040810ULL, 0x002fca0007ffe0ffULL, 0x00005c0004040625ULL, 0x000fc800078e0002ULL,
0x00005c00a5020625ULL, 0x000fe200078e0002ULL, 0x0000000604090981ULL, 0x0002aa000c1e1900ULL,
0x0000000602020981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ffa27624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000009c7919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff117624ULL, 0x000fc400078e00ffULL, 0x00000000000a7919ULL, 0x000ee40000002300ULL,
0x0000590011117a24ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000ee20000002100ULL,
0x0000000000007308ULL, 0x010f220000001000ULL, 0x00000004ff997e24ULL, 0x002fe2000f8e00ffULL,
0x0ffffffe00067810ULL, 0x010fe40007ffe0ffULL, 0x00000005ff9d7819ULL, 0x008fc80000011608ULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x00001fff9d9d7589ULL, 0x000fe200000e0000ULL,
0x000000ffff067224ULL, 0x002fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a07ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07077227ULL, 0x000fcc00078e0006ULL,
0x00000400070b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a0bULL,
0x0000040003007624ULL, 0x000fca00078e02a2ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00007306ULL, 0x000e620000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00047810ULL, 0x002fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x0002e4000021f000ULL,
0x000000ffff047224ULL, 0x002fe400078e00ffULL, 0x000000050b037224ULL, 0x008fc800078e02ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a03ULL, 0x0000000305057227ULL, 0x000fe400078e0004ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000009c05817227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a81ULL, 0x000000000b007224ULL, 0x000fca00078e029cULL,
0x0000000b0000720cULL, 0x000fe20003f66070ULL, 0x000001000a037a24ULL, 0x002fe400078e0203ULL,
0x00001fff0a0a7589ULL, 0x000e6400000e0000ULL, 0x00000000030d7a24ULL, 0x000fd000078e0208ULL,
0x0000000100003824ULL, 0x000fe200078e0a0bULL, 0x0000000181813810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x0000000b0000720cULL, 0x000fe40003f86070ULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000030d00780cULL, 0x000fce0003f64070ULL,
0x3fffff8000049802ULL, 0x000fe20000000f00ULL, 0x7fffff80ff059424ULL, 0x000fe200078e00ffULL,
0x0000000181814810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff81d212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x01e60004ff009388ULL, 0x000fe20000000a00ULL,
0x0000007f0d00780cULL, 0x000fe20003f84070ULL, 0x7fffffc0ff07a424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fc400078e0a81ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x01e608060d00a388ULL, 0x000fe20000008a00ULL, 0x000000000b9c7224ULL, 0x000fca00078e029cULL,
0x000000059c9c7819ULL, 0x000fe200000006ffULL, 0xff317217ff0cc424ULL, 0x000fca00078e00ffULL,
0x01e4000c0d00c388ULL, 0x000fe20000004800ULL, 0x00000001099e0824ULL, 0x004fe400078e0a02ULL,
0x00005800ff9e8624ULL, 0x000fe400078e00ffULL, 0x00005800a5028a24ULL, 0x000fe400078e02ffULL,
0x00005a009e037a24ULL, 0x000fe400078e02ffULL, 0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL,
0x0000000103007824ULL, 0x040fe200078e0a9cULL, 0x0000009c0300720cULL, 0x000fe20003f26070ULL,
0x0000001102847224ULL, 0x000fe200078e02ffULL, 0x01e688080d00b388ULL, 0x000fe40000008a00ULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x00005a0081107a24ULL, 0x000fc600078e0284ULL,
0x000000ff00837207ULL, 0x000fe20000800000ULL, 0x000000040a007824ULL, 0x002fe200078e029dULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000208300780cULL, 0x000fe20003f05270ULL,
0x0000000400037824ULL, 0x000fd800078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00005a0000077b06ULL, 0x000e620000209000ULL, 0x0000000000007919ULL, 0x000eae0000000000ULL,
0x0000000700077308ULL, 0x002e620000001000ULL, 0x00000004ff067819ULL, 0x004fc80000011600ULL,
0x0000000206097810ULL, 0x000fe20007ffe0ffULL, 0x00000001030b7824ULL, 0x000fe200078e0206ULL,
0x0ffffffe07047810ULL, 0x002fc60007ffe0ffULL, 0x00000001030d7824ULL, 0x000fe200078e0209ULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x000000ffff047224ULL, 0x002fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x004fc800078e0a05ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f05087227ULL, 0x000fe200078e0004ULL, 0x0000000b9c057210ULL, 0x000fc60007ffe0ffULL,
0x000000019c0f7824ULL, 0x000fe400078e020dULL, 0x0000000508047227ULL, 0x000fc800078e00ffULL,
0x0000000f080c7227ULL, 0x000fc800078e00ffULL, 0x000000ffff087224ULL, 0x000fe400078e0a04ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a0cULL, 0x00005a0008077a24ULL, 0x000fe400078e0205ULL,
0x00005a000e087a24ULL, 0x000fc600078e020fULL, 0x00005a0007007a0cULL, 0x000fe40003f06070ULL,
0x00005a0008007a0cULL, 0x000fd60003f46070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fe40003f26070ULL,
0x00005a0008007a0cULL, 0x000fe40003f66070ULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff077a12ULL, 0x000fc600078e33ffULL, 0x0000000104041810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c3810ULL, 0x000fe40007ffe0ffULL, 0x0000000407087207ULL, 0x040fe40004000000ULL,
0x0000000c07077207ULL, 0x000fe40004000000ULL, 0x0000000383047217ULL, 0x000fe20007800000ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a08ULL, 0x000000ffff0e7224ULL, 0x000fc400078e0a07ULL,
0x00005a000c057a24ULL, 0x000fe400078e0205ULL, 0x00005a000e0f7a24ULL, 0x000fe400078e020fULL,
0x0000000110057824ULL, 0x040fe400078e0205ULL, 0x00000001100c7824ULL, 0x000fe400078e020fULL,
0x0000000104047824ULL, 0x000fe400078e0a03ULL, 0x0000001108057224ULL, 0x080fe200078e0205ULL,
0x000000000b087210ULL, 0x000fe20007ffe0ffULL, 0x0000001000037824ULL, 0x000fe200078e00ffULL,
0x000000040600720cULL, 0x080fe20003f06070ULL, 0x0000001107077224ULL, 0x000fe200078e020cULL,
0x000000040900720cULL, 0x000fe20003f26070ULL, 0x0000010005047825ULL, 0x000fe200078e00ffULL,
0x000000f003097812ULL, 0x000fc600078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000904047212ULL, 0x000fc600078efcffULL, 0x000000100b0f7824ULL, 0x000fe200078e00ffULL,
0x0000000906067212ULL, 0x000fe200078efcffULL, 0x000000010d0b7824ULL, 0x040fe200078e0200ULL,
0x0000600004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000100d0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff00f087812ULL, 0x000fe400078ee208ULL, 0x0000600006067a10ULL, 0x000fe40007f7e0ffULL,
0xfffffff00c0b7812ULL, 0x000fe200078ee20bULL, 0x0000001008097824ULL, 0x000fe200078e00ffULL,
0x0000610005057a10ULL, 0x000fc400017fe4ffULL, 0x0000610007077a10ULL, 0x000fe20001ffe4ffULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000c101c46ULL, 0x00000000060b7faeULL, 0x0003e2000c901c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000e620000209000ULL,
0x0000000000007919ULL, 0x000eae0000000000ULL, 0x0000000600067308ULL, 0x002e620000001000ULL,
0x0000000300097211ULL, 0x004fc800078fe0ffULL, 0x00000002090b7810ULL, 0x040fe20007ffe0ffULL,
0x00000010090f7824ULL, 0x000fe200078e00ffULL, 0x0ffffffe06057810ULL, 0x002fc60007ffe0ffULL,
0x000000019c067824ULL, 0x000fe200078e020bULL, 0x000000040b0c7819ULL, 0x000fe400000006ffULL,
0x0000000500057305ULL, 0x000e64000021f000ULL, 0x000000ffff047224ULL, 0x002fc800078e0a05ULL,
0x00005a0004037a24ULL, 0x000fe400078e02ffULL, 0x000000ffff047224ULL, 0x000fc800078e00ffULL,
0x0000000305077227ULL, 0x000fc800078e0004ULL, 0x000000019c037824ULL, 0x000fc800078e0209ULL,
0x0000000307047227ULL, 0x000fc800078e00ffULL, 0x0000000607077227ULL, 0x000fe200078e00ffULL,
0x000000ff04087210ULL, 0x000fc60007ffe1ffULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a07ULL,
0x00005a0008057a24ULL, 0x000fe400078e0203ULL, 0x00005a000d087a24ULL, 0x000fc600078e0206ULL,
0x00005a0005007a0cULL, 0x000fe40003f06070ULL, 0x00005a0008007a0cULL, 0x000fd60003f46070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x80005a0008082a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a0008007a0cULL, 0x000fe40003f66070ULL,
0x0000000104040810ULL, 0x000fe40007ffe0ffULL, 0x0000000107072810ULL, 0x000fc40007ffe0ffULL,
0x00005a00ff007a0cULL, 0x000fe40003f05070ULL, 0x00005a00ff057a12ULL, 0x000fc600078e33ffULL,
0x0000000104041810ULL, 0x000fe40007ffe0ffULL, 0x0000000107073810ULL, 0x000fe40007ffe0ffULL,
0x0000000405047207ULL, 0x040fe40004000000ULL, 0x0000000705077207ULL, 0x000fc60004000000ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x000000ffff057224ULL, 0x000fe400078e0a07ULL,
0x00005a0008037a24ULL, 0x000fe400078e0203ULL, 0x00005a0005067a24ULL, 0x000fe400078e0206ULL,
0x0000000110057824ULL, 0x040fe400078e0203ULL, 0x0000000110067824ULL, 0x000fc400078e0206ULL,
0x0000001000037824ULL, 0x000fe400078e00ffULL, 0x0000001104057224ULL, 0x080fe400078e0205ULL,
0x0000001107067224ULL, 0x000fe200078e0206ULL, 0x000000f0030d7812ULL, 0x000fe200078ec0ffULL,
0x0000010005047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000d04047212ULL, 0x000fc600078efcffULL, 0x0000000109087824ULL, 0x100fe200078e0200ULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe200078e0200ULL,
0x0000600004047a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff00f087812ULL, 0x000fe400078ee208ULL,
0xfffffff00c0b7812ULL, 0x000fe400078ee209ULL, 0x0000600006067a10ULL, 0x000fe20007f3e0ffULL,
0x0000001008097824ULL, 0x000fe200078e00ffULL, 0x0000610005057a10ULL, 0x000fe200007fe4ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc60000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e8000b901c46ULL,
0x00000000060b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff9a7424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600047300ULL, 0x000e7000000e0000ULL,
0x0000000600077309ULL, 0x000ea20000000000ULL, 0x000000050400720cULL, 0x002fe20003f02070ULL,
0x00006800a5047625ULL, 0x000fc800078e009aULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01e60407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000604987981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fe40003f05270ULL, 0x0000007f98237810ULL, 0x044fe40007ffe0ffULL,
0x000000ff98227810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff237819ULL, 0x000fe40000011623ULL,
0x00000008ff227819ULL, 0x000fca0000011622ULL, 0x0000e9e000008947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe2000001169dULL, 0x000000089d807824ULL, 0x000fe200078e00ffULL,
0xffffffff00197802ULL, 0x000fe20000000f00ULL, 0x00000003ff077424ULL, 0x002fe200078e00ffULL,
0x01ffffff02027812ULL, 0x000fca00078ec0ffULL, 0x00000002991a7824ULL, 0x000fca00078e0202ULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x00000002a5028824ULL, 0x000fe400078e00ffULL,
0x00006a00ff058624ULL, 0x000fc800078e00ffULL, 0x00006a0002058624ULL, 0x000fc800078e0205ULL,
0x000000011a058824ULL, 0x000fe200078e0205ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e68c0780ff738cULL, 0x0003e20000000000ULL, 0x00006600059a8625ULL, 0x000fe200078e009aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000069a198981ULL, 0x000ea2000c1e1900ULL,
0x0000000199057810ULL, 0x000fe20007ffe0ffULL, 0x0000008081167824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001169dULL, 0x01e6880080ff7f8cULL, 0x0007e2000c80043fULL,
0x000000220500720cULL, 0x000fe20003f06070ULL, 0x00000100ff057424ULL, 0x000fe200078e00ffULL,
0x000000019d157812ULL, 0x000fe200078ec0ffULL, 0x0000002018177824ULL, 0x000fc800078e00ffULL,
0x0000010099077824ULL, 0x002fca00078e0217ULL, 0x00000060162b7812ULL, 0x000fe200078ef807ULL,
0x0000590019027a24ULL, 0x004fc800078e02ffULL, 0x0000008002027824ULL, 0x000fc800078e00ffULL,
0x0000640002047625ULL, 0x000fe200078e0005ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff127819ULL, 0x108fe40000011600ULL, 0x0000000798027217ULL, 0x000fe40007800000ULL,
0x0000000412087810ULL, 0x040fe40007ffe0ffULL, 0x00000008120a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a07ULL, 0x0000000c120b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108067824ULL, 0x100fe200078e0200ULL, 0x000000000a077210ULL, 0x000fe20007ffe0ffULL,
0x00000008081d7824ULL, 0x000fe200078e00ffULL, 0x0000002002137817ULL, 0x000fe20003800000ULL,
0x000000080a0c7824ULL, 0x000fe200078e00ffULL, 0x0000001012107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b097824ULL, 0x000fe200078e0200ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x0000007003067812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0xfffffff80c1f7812ULL, 0x000fe200078ee207ULL,
0x000000012b077824ULL, 0x000fe200078e0212ULL, 0xfffffff80e217812ULL, 0x000fe200078ee209ULL,
0x0000008015027824ULL, 0x000fe200078e0206ULL, 0x000000130800720cULL, 0x080fe20003f86070ULL,
0x000000012b097824ULL, 0x000fe200078e0208ULL, 0x00000014121c7810ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0002ULL, 0x000000130a00720cULL, 0x000fc40003f66070ULL,
0x000000001c0f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x000fe200078e0200ULL,
0x00000006040c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fe200078e0002ULL,
0x000000130b00720cULL, 0x080fe40003f46070ULL, 0x000000131200720cULL, 0x000fe20003fa6070ULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0x00000008040e7210ULL, 0x000fe20007f3e0ffULL,
0x000000081c1e7824ULL, 0x000fc600078e00ffULL, 0xfffffff814257812ULL, 0x000fe200078ee20dULL,
0x00000001050d7824ULL, 0x000fe200000e0607ULL, 0xfffffff81e277812ULL, 0x000fe200078ee20fULL,
0x000000012b077824ULL, 0x000fe200078e020aULL, 0x0000001c121e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001050f7824ULL, 0x000fe200008e0609ULL, 0x000000131000720cULL, 0x000fe20003f26070ULL,
0x000000012b097824ULL, 0x000fe400078e020bULL, 0x0000010007067825ULL, 0x000fc800078e0002ULL,
0x00000001120a7824ULL, 0x000fe400078e0200ULL, 0x000000012b0b7824ULL, 0x000fe200078e0210ULL,
0x0000000604107210ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fe200078e0002ULL,
0x000000070a1b7812ULL, 0x000fc600078ec0ffULL, 0x0000000218147824ULL, 0x000fe200078e0215ULL,
0x0000000804087210ULL, 0x000fe20007fde0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0002ULL,
0x0ffffff81b1b7812ULL, 0x000fe400078ef800ULL, 0x0001600014147811ULL, 0x000fe200078e68ffULL,
0x0000000105117824ULL, 0x040fe200000e0607ULL, 0x0000000905097210ULL, 0x000fe200037fe4ffULL,
0x000000012b077824ULL, 0x000fe200078e021cULL, 0x0000000a040a7210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0214ULL, 0x000000131c00720cULL, 0x000fe20003f06070ULL,
0x0000010007067825ULL, 0x000fe200078e0002ULL, 0x00000018121c7810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000e901c46ULL,
0x000000101d1d7824ULL, 0x000fe200078e0214ULL, 0x000000131c00720cULL, 0x080fe20003fa6070ULL,
0x00000001050b7824ULL, 0x000fe200030e060bULL, 0x0000000604127210ULL, 0x000fe20007fde0ffULL,
0x000000012b297824ULL, 0x040fe200078e021cULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x000000131e00720cULL, 0x000fe20003f86070ULL, 0x000000012b2b7824ULL, 0x000fe400078e021eULL,
0x0000000105137824ULL, 0x000fc400030e0607ULL, 0x0000010029067825ULL, 0x000fc800078e0002ULL,
0x000000011c0c7824ULL, 0x002fe200078e0200ULL, 0x0000000604067210ULL, 0x000fe20007fde0ffULL,
0x000000081c0d7824ULL, 0x000fe200078e00ffULL, 0x000000001e0e7210ULL, 0x044fe20007ffe0ffULL,
0x000000081e0f7824ULL, 0x000fe400078e00ffULL, 0x000001002b027825ULL, 0x000fe200078e0002ULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee20cULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20eULL,
0x0000000105077824ULL, 0x000fe200030e0607ULL, 0x0000000204027210ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x000fc400078e0214ULL, 0x0000001021217824ULL, 0x100fe400078e0214ULL,
0x0000001025257824ULL, 0x100fe200078e0214ULL, 0x00000000101f7faeULL, 0x0003e2000d901c46ULL,
0x0000001027277824ULL, 0x100fe400078e0214ULL, 0x000000100d0d7824ULL, 0x100fe200078e0214ULL,
0x0000000008217faeULL, 0x0003e2000d101c46ULL, 0x000000100f0f7824ULL, 0x000fe400078e0214ULL,
0x0000000105037824ULL, 0x000fe200030e0603ULL, 0x000000000a257faeULL, 0x0003e8000c901c46ULL,
0x0000000012277faeULL, 0x0003e8000c101c46ULL, 0x00000000060d7faeULL, 0x0003e8000e901c46ULL,
0x00000000020f7faeULL, 0x0003e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000400097811ULL, 0x048fe400078fe8ffULL, 0x00000008000b7811ULL, 0x000fc400078fe8ffULL,
0x0000000009027210ULL, 0x0c0fe20007ffe0ffULL, 0x0000000809077824ULL, 0x000fe200078e00ffULL,
0x0000000c000d7811ULL, 0x040fe200078fe8ffULL, 0x000000010b067824ULL, 0x040fe200078e0200ULL,
0x0000001400117811ULL, 0x040fe200078fe8ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8071c7812ULL, 0x000fe200078ee202ULL, 0x000000010d027824ULL, 0x040fe200078e0200ULL,
0x0000001800137811ULL, 0x040fe200078fe8ffULL, 0x000000080d1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1e7812ULL, 0x000fe200078ee206ULL, 0x0000000111077824ULL, 0x040fe200078e0200ULL,
0x00000010000f7811ULL, 0x040fe200078fe8ffULL, 0x0000000811267824ULL, 0x000fe200078e00ffULL,
0xfffffff81b207812ULL, 0x000fe200078ee202ULL, 0x00000008131f7824ULL, 0x000fe200078e00ffULL,
0x0000007003127812ULL, 0x000fe200078ec0ffULL, 0x000000010f067824ULL, 0x000fe200078e0200ULL,
0x0000000013087210ULL, 0x080fe20007ffe0ffULL, 0x000000080f1d7824ULL, 0x000fe200078e00ffULL,
0x0000000000027211ULL, 0x040fe200078fe8ffULL, 0x000000012b1b7824ULL, 0x000fe200078e0213ULL,
0x0000001c00037811ULL, 0x000fe200078fe8ffULL, 0x0000008015127824ULL, 0x000fe200078e0212ULL,
0xfffffff826267812ULL, 0x000fe200078ee207ULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0xfffffff81d247812ULL, 0x000fe200078ee206ULL, 0x000000012b1d7824ULL, 0x000fe200078e0203ULL,
0xfffffff81f287812ULL, 0x000fe200078ee208ULL, 0x0000000218067824ULL, 0x000fe200078e0215ULL,
0x0000000702077812ULL, 0x000fe200078ec0ffULL, 0x0000000103027824ULL, 0x040fe200078e0200ULL,
0x00000003031f7819ULL, 0x000fe200000006ffULL, 0x000000012b097824ULL, 0x040fe200078e0209ULL,
0x0000002b00037211ULL, 0x000fe200078fe8ffULL, 0x000000012b0b7824ULL, 0x000fe200078e020bULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee202ULL, 0x000000012b0d7824ULL, 0x000fe200078e020dULL,
0x0ffffff807147812ULL, 0x000fe200078ef800ULL, 0x000000012b0f7824ULL, 0x000fc400078e020fULL,
0x000000012b117824ULL, 0x000fe200078e0211ULL, 0x00016000062b7811ULL, 0x000fe200078e68ffULL,
0x0000010003027825ULL, 0x000fc600078e0012ULL, 0x0000002b28297211ULL, 0x000fe200078e20ffULL,
0x0000010009067825ULL, 0x000fe200078e0012ULL, 0x0000000204027210ULL, 0x000fc60007f1e0ffULL,
0x000001000b087825ULL, 0x000fe200078e0012ULL, 0x0000000604067210ULL, 0x000fc60007f3e0ffULL,
0x000001000d0a7825ULL, 0x000fe200078e0012ULL, 0x0000000804087210ULL, 0x000fc60007f5e0ffULL,
0x000001000f0c7825ULL, 0x000fe200078e0012ULL, 0x0000000a040a7210ULL, 0x000fc60007f7e0ffULL,
0x00000100110e7825ULL, 0x000fc800078e0012ULL, 0x000001001b107825ULL, 0x000fc800078e0012ULL,
0x000001001d127825ULL, 0x000fc800078e0012ULL, 0x0000000105037824ULL, 0x040fe200000e0603ULL,
0x0000000c040c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000105077824ULL, 0x040fe200008e0607ULL,
0x0000000e040e7210ULL, 0x000fe20007f3e0ffULL, 0x00000010141b7824ULL, 0x000fe400078e022bULL,
0x0000000105097824ULL, 0x040fe200010e0609ULL, 0x0000001004107210ULL, 0x000fe20007f5e0ffULL,
0x000000101c1d7824ULL, 0x000fe200078e022bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000021b7faeULL, 0x0003e2000b901c46ULL, 0x00000001050b7824ULL, 0x000fe200018e060bULL,
0x0000001204047210ULL, 0x000fe20007f7e0ffULL, 0x000000101e1f7824ULL, 0x100fe200078e022bULL,
0x00000000061d7faeULL, 0x0003e2000b901c46ULL, 0x0000001020217824ULL, 0x000fc400078e022bULL,
0x0000001024257824ULL, 0x000fe200078e022bULL, 0x00000000081f7faeULL, 0x0003e2000b901c46ULL,
0x00000001050d7824ULL, 0x040fe400000e060dULL, 0x0000001026277824ULL, 0x000fe200078e022bULL,
0x000000000a217faeULL, 0x0003e2000b901c46ULL, 0x00000001050f7824ULL, 0x040fe400008e060fULL,
0x0000000105117824ULL, 0x000fe200010e0611ULL, 0x000000000c257faeULL, 0x0003e2000b901c46ULL,
0x000000102a2b7824ULL, 0x000fc400078e022bULL, 0x0000000105057824ULL, 0x000fe200018e0613ULL,
0x000000000e277faeULL, 0x0003e8000b901c46ULL, 0x0000000010297faeULL, 0x0003e8000b901c46ULL,
0x00000000042b7faeULL, 0x0003e4000b901c46ULL, 0x000000229900720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217001b7802ULL, 0x002fe20000000f00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00007ef000000947ULL, 0x000fea0003800000ULL,
0x00000002a5147824ULL, 0x000fe400078e00ffULL, 0x00006a00ff037624ULL, 0x000fc400078e00ffULL,
0xff317217ff1b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff5f7224ULL, 0x000fe400078e00ffULL,
0x00006a0014147624ULL, 0x000fc400078e0203ULL, 0x000000109d027824ULL, 0x000fe200078e00ffULL,
0x0000000199037810ULL, 0x000fe20007ffe0ffULL, 0x0000590019197a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe002027812ULL, 0x000fe400078ec0ffULL,
0x000000220300720cULL, 0x000fe20003f06070ULL, 0x00000100ff037424ULL, 0x000fe400078e00ffULL,
0x0000010099027824ULL, 0x000fca00078e0202ULL, 0x0000004002077810ULL, 0x020fe20007ffe0ffULL,
0x0000008019027824ULL, 0x000fc600078e00ffULL, 0x0000006007057812ULL, 0x000fe200078ec0ffULL,
0x0000640002027625ULL, 0x000fc600078e0003ULL, 0x0000000516677210ULL, 0x000fe20007ffe0ffULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x0000000798047217ULL, 0x000fe20007800000ULL, 0x000000809d067824ULL, 0x000fe200078e00ffULL,
0x00000003ff207819ULL, 0x000fe40000011600ULL, 0x0000007005097812ULL, 0x000fe200078ec0ffULL,
0x0000000104057824ULL, 0x000fe200078e0a07ULL, 0x00000004200a7810ULL, 0x000fe20007ffe0ffULL,
0x000020009d077824ULL, 0x000fe200078e00ffULL, 0x0000008009047812ULL, 0x000fc400078ef806ULL,
0x0000000c201e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a067824ULL, 0x040fe200078e0200ULL,
0x0000200007077812ULL, 0x000fe200078ec0ffULL, 0x000000080a657824ULL, 0x000fe200078e00ffULL,
0x00000008201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000081e6b7824ULL, 0x000fe200078e00ffULL,
0x0000001420667810ULL, 0x000fe20007ffe0ffULL, 0x0000400018187824ULL, 0x000fe200078e0207ULL,
0xfffffff865657812ULL, 0x000fe200078ee206ULL, 0x000000011c087824ULL, 0x000fe200078e0200ULL,
0x000000001e067210ULL, 0x000fe20007ffe0ffULL, 0x000000081c697824ULL, 0x000fe200078e00ffULL,
0x0000002005137817ULL, 0x000fe20003800000ULL, 0x0000000120077824ULL, 0x040fe200078e0267ULL,
0x0000001020647810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee206ULL, 0x0000000166097824ULL, 0x040fe200078e0200ULL,
0xfffffff869697812ULL, 0x000fe200078ee208ULL, 0x00000008660c7824ULL, 0x000fe200078e00ffULL,
0x000000671c0b7210ULL, 0x040fe20007ffe0ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000131c00720cULL, 0x000fc40003f06070ULL, 0xfffffff80c6f7812ULL, 0x000fe200078ee209ULL,
0x0000000164087824ULL, 0x000fe200078e0200ULL, 0x00000006020c7210ULL, 0x000fe20007f5e0ffULL,
0x00000008646d7824ULL, 0x000fe200078e00ffULL, 0x00017000181c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a097824ULL, 0x000fe200078e0267ULL, 0x000000132000720cULL, 0x0c0fe20003f86070ULL,
0x00000001030d7824ULL, 0x000fe200010e0607ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee208ULL,
0x0000000120087824ULL, 0x000fe200078e0200ULL, 0x000000130a00720cULL, 0x080fe20003f66070ULL,
0x0000010009067825ULL, 0x000fe200078e0004ULL, 0x000000131e00720cULL, 0x000fc40003f26070ULL,
0x00000007081f7812ULL, 0x000fe200078ec0ffULL, 0x000001000b087825ULL, 0x000fe200078e0004ULL,
0x0000000602187210ULL, 0x000fe40007f5e0ffULL, 0x0ffffff81f217812ULL, 0x000fe200078ef800ULL,
0x000000011e197824ULL, 0x000fe200078e0267ULL, 0x00000008021e7210ULL, 0x000fe20007fbe0ffULL,
0x0000001065657824ULL, 0x000fe200078e021cULL, 0x0000001c20687810ULL, 0x000fe20007ffe0ffULL,
0x00000100190a7825ULL, 0x000fc800078e0004ULL, 0x0000000103197824ULL, 0x040fe200010e0607ULL,
0x0000000a020a7210ULL, 0x000fe20007fde0ffULL, 0x0000000164077824ULL, 0x040fe200078e0267ULL,
0x000000136400720cULL, 0x080fe20003f46070ULL, 0x00000001031f7824ULL, 0x000fe200028e0609ULL,
0x0000001820647810ULL, 0x000fe20007ffe0ffULL, 0x0000001021097824ULL, 0x000fe200078e021cULL,
0x000000136600720cULL, 0x000fe20003fa6070ULL, 0x0000010007067825ULL, 0x000fc600078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000e101c46ULL,
0x0000000166217824ULL, 0x000fe200078e0267ULL, 0x000000136400720cULL, 0x080fe20003f86070ULL,
0x00000001030b7824ULL, 0x000fe200030e060bULL, 0x0000000018657faeULL, 0x0005e2000d901c46ULL,
0x0000000602207210ULL, 0x000fe40007fde0ffULL, 0x000000136800720cULL, 0x000fe40003f66070ULL,
0x0000006764137210ULL, 0x000fe20007ffe0ffULL, 0x0000010021087825ULL, 0x002fc800078e0004ULL,
0x0000000103217824ULL, 0x000fe200030e0607ULL, 0x0000000802087210ULL, 0x000fe20007fde0ffULL,
0x0000010013067825ULL, 0x000fc800078e0004ULL, 0x00000001680d7824ULL, 0x000fe400078e0267ULL,
0x0000000103097824ULL, 0x000fe200030e0609ULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x00000001640c7824ULL, 0x140fe400078e0200ULL, 0x0000000864677824ULL, 0x000fe400078e00ffULL,
0x0000000168137824ULL, 0x040fe400078e0200ULL, 0x0000000868687824ULL, 0x000fe200078e00ffULL,
0xfffffff867677812ULL, 0x000fe200078ee20cULL, 0x000001000d047825ULL, 0x000fc600078e0004ULL,
0xfffffff868717812ULL, 0x000fe200078ee213ULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x00000010690d7824ULL, 0x100fe200078e021cULL,
0x0000001c6b137211ULL, 0x000fe200078e20ffULL, 0x000000106d197824ULL, 0x104fe400078e021cULL,
0x000000106f657824ULL, 0x100fe200078e021cULL, 0x000000001e0d7faeULL, 0x0003e2000c101c46ULL,
0x0000001067677824ULL, 0x100fe400078e021cULL, 0x0000001071697824ULL, 0x000fe200078e021cULL,
0x000000000a137faeULL, 0x0003e2000c901c46ULL, 0x0000000103037824ULL, 0x000fc600030e0605ULL,
0x0000000020197faeULL, 0x0003e8000d101c46ULL, 0x0000000008657faeULL, 0x0003e8000e901c46ULL,
0x0000000006677faeULL, 0x0003e8000e101c46ULL, 0x0000000002697faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x040fe200078e00ffULL,
0x0000000400077811ULL, 0x040fe200078fe8ffULL, 0x000000809d217824ULL, 0x040fe200078e00ffULL,
0x0000000c000b7811ULL, 0x000fe200078fe8ffULL, 0x000020009d057824ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fe200078ec0ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000000800097811ULL, 0x000fe200078fe8ffULL, 0x000000010b067824ULL, 0x040fe200078e0200ULL,
0x0000008004207812ULL, 0x000fe200078ef821ULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x0000000007047210ULL, 0x080fe20007ffe0ffULL, 0x0000000809667824ULL, 0x000fe200078e00ffULL,
0x0000200005057812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x100fe200078e0267ULL,
0xfffffff80d647812ULL, 0x000fe200078ee204ULL, 0x000000010b0b7824ULL, 0x000fe200078e0267ULL,
0x00000010000d7811ULL, 0x000fe200078fe8ffULL, 0x0000400018187824ULL, 0x000fe200078e0205ULL,
0xfffffff813687812ULL, 0x000fe200078ee206ULL, 0x0000000109057824ULL, 0x100fe200078e0200ULL,
0x00000018001f7811ULL, 0x040fe200078fe8ffULL, 0x000000010d047824ULL, 0x140fe200078e0200ULL,
0x0000001400197811ULL, 0x000fe200078fe8ffULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x000000001f067210ULL, 0x0c0fe20007ffe0ffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0xfffffff866667812ULL, 0x000fe200078ee205ULL, 0x0000000119057824ULL, 0x000fe200078e0200ULL,
0xfffffff8136a7812ULL, 0x000fe200078ee204ULL, 0x00000008196c7824ULL, 0x000fe200078e00ffULL,
0x0000000000047211ULL, 0x040fe200078fe8ffULL, 0x0000000109097824ULL, 0x100fe200078e0267ULL,
0x0000001c00137811ULL, 0x000fe200078fe8ffULL, 0x000000010d0d7824ULL, 0x100fe200078e0267ULL,
0xfffffff8216e7812ULL, 0x000fe200078ee206ULL, 0x0000000119197824ULL, 0x000fe200078e0267ULL,
0x0000000704217812ULL, 0x000fe200078ec0ffULL, 0x0000000113047824ULL, 0x140fe200078e0200ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee205ULL, 0x0000000813657824ULL, 0x000fe200078e00ffULL,
0x0000006700057211ULL, 0x000fe200078fe8ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0267ULL,
0x0ffffff8211c7812ULL, 0x000fe200078ef800ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0xfffffff865707812ULL, 0x000fc400078ee204ULL, 0x0000006713137210ULL, 0x000fe20007ffe0ffULL,
0x0000010005047825ULL, 0x000fe200078e0020ULL, 0x0001700018717810ULL, 0x000fc60007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0020ULL, 0x0000000402047210ULL, 0x000fc60007f1e0ffULL,
0x0000010009087825ULL, 0x100fe200078e0020ULL, 0x0000000602067210ULL, 0x040fe40007f3e0ffULL,
0x0000000503057210ULL, 0x000fe200007fe4ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0020ULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0020ULL,
0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL, 0x0000010019187825ULL, 0x000fe200078e0020ULL,
0x0000000c020c7210ULL, 0x000fc60007f1e0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0020ULL,
0x0000010013207825ULL, 0x000fc800078e0020ULL, 0x0000000103077824ULL, 0x040fe200008e0607ULL,
0x0000001802187210ULL, 0x000fe20007f3e0ffULL, 0x000000101c137824ULL, 0x000fe400078e0271ULL,
0x0000000103097824ULL, 0x040fe200010e0609ULL, 0x0000001e021e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001064657824ULL, 0x000fe200078e0271ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004137faeULL, 0x0003e2000b901c46ULL, 0x00000001030b7824ULL, 0x000fe200018e060bULL,
0x0000002002027210ULL, 0x000fe20007f7e0ffULL, 0x0000001066677824ULL, 0x100fe200078e0271ULL,
0x0000000006657faeULL, 0x0003e2000b901c46ULL, 0x0000001068697824ULL, 0x000fc400078e0271ULL,
0x000000106a6b7824ULL, 0x000fe200078e0271ULL, 0x0000000008677faeULL, 0x0003e2000b901c46ULL,
0x00000001030d7824ULL, 0x040fe400000e060dULL, 0x000000106c6d7824ULL, 0x000fe200078e0271ULL,
0x000000000a697faeULL, 0x0003e2000b901c46ULL, 0x0000000103197824ULL, 0x040fe400008e0619ULL,
0x000000106e6f7824ULL, 0x000fe200078e0271ULL, 0x000000000c6b7faeULL, 0x0003e2000b901c46ULL,
0x00000001031f7824ULL, 0x000fc400010e061fULL, 0x0000001070717824ULL, 0x000fe200078e0271ULL,
0x00000000186d7faeULL, 0x0003e2000b901c46ULL, 0x0000000103037824ULL, 0x000fc600018e0621ULL,
0x000000001e6f7faeULL, 0x0003e8000b901c46ULL, 0x0000000002717faeULL, 0x0003e4000b901c46ULL,
0x00000300ff027624ULL, 0x002fe200078e00ffULL, 0x000000011a037812ULL, 0x000fe200078ec0ffULL,
0xffffffffff197424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010300780cULL, 0x000fe40003f05070ULL, 0xffffffff02027811ULL, 0x000fc800078e08ffULL,
0x0000000102037807ULL, 0x000fca0004000000ULL, 0x00000001031a7824ULL, 0x000fca00078e021aULL,
0x000000231a00720cULL, 0x000fda0003f06070ULL, 0x0000001a14028210ULL, 0x000fe20007ffe0ffULL,
0x00000004ff038424ULL, 0x000fc800078e00ffULL, 0x0000660002028625ULL, 0x000fca00078e0003ULL,
0x0000000602198981ULL, 0x000322000c1e1900ULL, 0xffffffe080047812ULL, 0x040fe400078ec0ffULL,
0x0000001080057812ULL, 0x040fe400078ec0ffULL, 0x0000000880067812ULL, 0x000fc800078ec0ffULL,
0x0000000406087210ULL, 0x000fe20007ffe005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6080008067f8cULL, 0x0022a4000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01e60c0008057984ULL, 0x000ee40000000800ULL, 0x8000000005ff7812ULL, 0x00cfe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402097210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000904047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60c0008057984ULL, 0x000ea40000000800ULL,
0x8000000005ff7812ULL, 0x004fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x00000001ff827819ULL, 0x000fe20000011600ULL,
0x000000209d027824ULL, 0x000fc600078e00ffULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0xffffff8002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c82827812ULL, 0x000fc800078ec0ffULL,
0x0000000282027210ULL, 0x000fca0007ffe013ULL, 0x01e0000002047984ULL, 0x000ea80000000800ULL,
0x01e2000002037984ULL, 0x0006620000000800ULL, 0x0000001b0400720bULL, 0x004fe20003f1d000ULL,
0x00016fd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x008fc800000e0100ULL,
0x000000ff0200720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000001b00187202ULL, 0x000fd20000000f00ULL,
0x0000071000009947ULL, 0x000fea0003800000ULL, 0x00000002ff067819ULL, 0x000fe4000001169dULL,
0x0000001b0400720bULL, 0x000fe40003f54000ULL, 0x0000009d0600720cULL, 0x000fe20003f25270ULL,
0x00016f927f007947ULL, 0x000fd4000b800000ULL, 0x0000000000057806ULL, 0x000fc400010e0100ULL,
0x000000809d079824ULL, 0x000fe200078e0213ULL, 0x0000001b04187209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000182079824ULL, 0x000fca00078e0207ULL,
0x01e4001807009388ULL, 0x0005e20000000800ULL, 0x000000ff0500720cULL, 0x000fda0003f25270ULL,
0x000005e000009947ULL, 0x000fea0003800000ULL, 0x0000001b18067221ULL, 0x004fe20000010100ULL,
0x000000ff05ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL, 0x0000000600077308ULL, 0x000ea40000000800ULL,
0x000000071d1d7220ULL, 0x004fc80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x00016ee27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e071e7589ULL, 0x0004e400000e0000ULL, 0x0000001e60607220ULL, 0x08cfe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x080fe40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x000fc40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x080fe40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x000fc40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0005ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x00016dd27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e071e7589ULL, 0x0004e400000e0000ULL,
0x0000001e62627220ULL, 0x08cfe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000005ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x00016cc27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e071e7589ULL, 0x0004e400000e0000ULL, 0x0000001e40407220ULL, 0x08cfe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000005ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x00016bc27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e071e7589ULL, 0x0004e400000e0000ULL, 0x0000001e42427220ULL, 0x08cfe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000000502ff7212ULL, 0x000fda00078230ffULL, 0x8000001804041221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b04041820ULL, 0x000fc80000410000ULL,
0x0000000400121308ULL, 0x000ea40000000800ULL, 0x0000001203031220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000001d031d7221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000012ff02723eULL, 0x000fe400000010ffULL,
0x00000002ff037819ULL, 0x000fe40000011600ULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x00016a127f007947ULL, 0x000fea000b800000ULL, 0x00001f0302117589ULL, 0x0002a400000e0000ULL,
0x00000008031e7810ULL, 0x000fe20007ffe0ffULL, 0x00016a627f007947ULL, 0x000fea000b800000ULL,
0x00000010030f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1e02107589ULL, 0x00066a00000e0000ULL,
0x00001f0f020f7589ULL, 0x0006a400000e0000ULL, 0x00000018031e7810ULL, 0x008fe20007ffe0ffULL,
0x00016af27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e020e7589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000029d1c7824ULL, 0x040fe200078e00ffULL,
0x0000000800037812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000d9d1b7819ULL, 0x000fe200000006ffULL, 0x000002c000007945ULL, 0x000fe20003800000ULL,
0x000000041c1f7812ULL, 0x000fc400078ec0ffULL, 0x0000000703037812ULL, 0x000fe400078ef800ULL,
0x0000001f00027211ULL, 0x048fe400078fe0ffULL, 0x0000001003217812ULL, 0x040fe200078efcffULL,
0x0000000803067824ULL, 0x040fe200078e00ffULL, 0x0000000300047211ULL, 0x000fe200078fe0ffULL,
0x00000001030d7824ULL, 0x000fe400078e0202ULL, 0x00000001020c7824ULL, 0x000fe200078e0221ULL,
0x00000002040b7810ULL, 0x040fe20007ffe0ffULL, 0x000004009d027824ULL, 0x000fe200078e00ffULL,
0x0000000404097810ULL, 0x000fe20007ffe0ffULL, 0x00000008031e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8060d7812ULL, 0x000fe200078ee20dULL, 0x0000000821057824ULL, 0x000fe200078e00ffULL,
0xfffff00002027812ULL, 0x000fe200078ec0ffULL, 0x0000000803077824ULL, 0x000fe200078e00ffULL,
0xfffffff8060b7812ULL, 0x000fc400078ee20bULL, 0xffffc0001b067812ULL, 0x000fe400078ec0ffULL,
0xfffffff81e097812ULL, 0x000fe400078ee209ULL, 0xfffffff8050c7812ULL, 0x000fe200078ee20cULL,
0x0000000803057824ULL, 0x000fe200078e00ffULL, 0x00012000021e7810ULL, 0x000fe20007ffe0ffULL,
0x0000200015067824ULL, 0x000fe200078e0206ULL, 0x0000000604087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8050a7812ULL, 0x000fe200078ee204ULL, 0x000000100d747824ULL, 0x100fe200078e021eULL,
0x0001600006067810ULL, 0x000fe20007ffe0ffULL, 0x000000100c647824ULL, 0x000fe200078e021eULL,
0xfffffff807087812ULL, 0x000fc600078ee208ULL, 0x000000007474783bULL, 0x000e620000000200ULL,
0x000000100a707824ULL, 0x100fe400078e0206ULL, 0x000000100b6c7824ULL, 0x100fe200078e0206ULL,
0x000000006464783bULL, 0x000ee20000000200ULL, 0x0000001009047824ULL, 0x000fe200078e0206ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001174747231ULL, 0x086fe400003400ffULL,
0x0000001176767231ULL, 0x000fe400003400ffULL, 0x0000001075757231ULL, 0x000fc400003400ffULL,
0x0000001077777231ULL, 0x000fe400003400ffULL, 0x0000000f64647231ULL, 0x088fe400003400ffULL,
0x0000000f66667231ULL, 0x000fe400003400ffULL, 0x0000000e65657231ULL, 0x080fe400003400ffULL,
0x0000000e67677231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000608687211ULL, 0x000fe200078e20ffULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x000000021f1f7812ULL, 0x000fe200078efcffULL, 0x0000039000007945ULL, 0x000fe20003800000ULL,
0x00000001ff207819ULL, 0x000fe2000001169dULL, 0x000000000404783bULL, 0x000ea20000004200ULL,
0x0000001f00027211ULL, 0x000fc600078fe0ffULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x00000002201f7824ULL, 0x000fc600078e0215ULL, 0x000000006c6c783bULL, 0x000e640000004200ULL,
0x000160001f1f7811ULL, 0x000fe200078e68ffULL, 0x000000706440723cULL, 0x008f700000041840ULL,
0x000000047430723cULL, 0x046f700000041830ULL, 0x000000067434723cULL, 0x000f700000041834ULL,
0x000000046450723cULL, 0x040b6e0000041850ULL, 0x0000000803047824ULL, 0x020fe200078e00ffULL,
0x000000066454723cULL, 0x000b620000041854ULL, 0x0000000821057824ULL, 0x000fcc00078e00ffULL,
0x0000000103077824ULL, 0x120fe200078e0202ULL, 0x000000687438723cULL, 0x080f620000041838ULL,
0x0000000121067824ULL, 0x000fe200078e0202ULL, 0x0000002100027211ULL, 0x000fe400078fe0ffULL,
0xfffffff804077812ULL, 0x000fe400078ee207ULL, 0xfffffff805067812ULL, 0x000fe400078ee206ULL,
0x000000686458723cULL, 0x000b620000041858ULL, 0x0000000202047810ULL, 0x040fe20007ffe0ffULL,
0x0000001007787824ULL, 0x000fe200078e021eULL, 0x0000000402037810ULL, 0x000fc40007ffe0ffULL,
0x0000001e061e7211ULL, 0x000fe400078e20ffULL, 0x0000000821697824ULL, 0x020fe200078e00ffULL,
0xfffffff805057812ULL, 0x000fe200078ee202ULL, 0x0000000821687824ULL, 0x040fe200078e00ffULL,
0x000000726444723cULL, 0x000f620000041844ULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0xfffffff869047812ULL, 0x000fe200078ee204ULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0xfffffff868037812ULL, 0x000fe400078ee203ULL, 0x0000000602027810ULL, 0x000fc40007ffe0ffULL,
0x0000006c6448723cULL, 0x000f640000041848ULL, 0xfffffff821027812ULL, 0x000fcc00078ee202ULL,
0x0000006e644c723cULL, 0x040f70000004184cULL, 0x0000006a645c723cULL, 0x000b64000004185cULL,
0x000000001e64783bULL, 0x0204ec0000000200ULL, 0x000000707460723cULL, 0x040b6e0000041860ULL,
0x0000001003707824ULL, 0x120fe200078e021fULL, 0x000000727424723cULL, 0x040f700000041824ULL,
0x0000006c7428723cULL, 0x040b6e0000041828ULL, 0x00000010056c7824ULL, 0x120fe200078e021fULL,
0x0000006e742c723cULL, 0x040f70000004182cULL, 0x0000006a743c723cULL, 0x000b6e000004183cULL,
0x0000001004747824ULL, 0x020fe200078e021fULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000001178787231ULL, 0x08efe400003400ffULL, 0x000000117a7a7231ULL, 0x000fc400003400ffULL,
0x0000001079797231ULL, 0x080fe400003400ffULL, 0x000000107b7b7231ULL, 0x000fe400003400ffULL,
0x0000000f64647231ULL, 0x080fe400003400ffULL, 0x0000000f66667231ULL, 0x000fe400003400ffULL,
0x0000000e65657231ULL, 0x080fe400003400ffULL, 0x0000000e67677231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x00efea0003800000ULL, 0x0000001002687824ULL, 0x000fe200078e021fULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x0000590019197a24ULL, 0x010fe200078e02ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ec0ffULL, 0x00000008991e7824ULL, 0x000fe200078e0220ULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x0000006c7860723cULL, 0x042b700000041860ULL,
0x0000006e7824723cULL, 0x040b700000041824ULL, 0x000000747828723cULL, 0x044b700000041828ULL,
0x00000076782c723cULL, 0x040b70000004182cULL, 0x000000707830723cULL, 0x048b700000041830ULL,
0x000000727834723cULL, 0x040b700000041834ULL, 0x000000687838723cULL, 0x040b700000041838ULL,
0x0000006a783c723cULL, 0x000b70000004183cULL, 0x000000746448723cULL, 0x040b700000041848ULL,
0x00000076644c723cULL, 0x040b70000004184cULL, 0x000000706450723cULL, 0x040b700000041850ULL,
0x000000726454723cULL, 0x040b700000041854ULL, 0x0000006c6440723cULL, 0x040b700000041840ULL,
0x0000006e6444723cULL, 0x040b700000041844ULL, 0x000000686458723cULL, 0x040b700000041858ULL,
0x0000006a645c723cULL, 0x000b62000004185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001991f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008019647824ULL, 0x020fe200078e00ffULL,
0x000000801e1e7811ULL, 0x000fe200078e28ffULL, 0x01e688001cff7f8cULL, 0x0003e2000c80043fULL,
0x000000221f00720cULL, 0x000fe20003f06070ULL, 0x00000100ff657424ULL, 0x000fe200078e00ffULL,
0x000000601e197812ULL, 0x000fc600078ec0ffULL, 0x0000640064647625ULL, 0x000fc800078e0065ULL,
0x0000000116797824ULL, 0x000fe200078e0219ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1c7819ULL, 0x102fe40000011600ULL,
0x000020001b1b7812ULL, 0x000fe400078ec0ffULL, 0x000000081c687810ULL, 0x040fe20007ffe0ffULL,
0x000000011c217824ULL, 0x000fe200078e0279ULL, 0x0000001e98197217ULL, 0x000fe20007800000ULL,
0x0000400020707824ULL, 0x000fe200078e021bULL, 0x000000041c667810ULL, 0x000fe20007ffe0ffULL,
0x00000001681f7824ULL, 0x000fe200078e0200ULL, 0x000000141c7c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000868747824ULL, 0x000fe200078e00ffULL, 0x00000000661b7210ULL, 0x000fe20007ffe0ffULL,
0x000000809d207824ULL, 0x000fe200078e00ffULL, 0x0000000c1c6e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119197824ULL, 0x000fe200078e0a1eULL, 0xfffffff874747812ULL, 0x000fe200078ee21fULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x00000080131e7812ULL, 0x000fe200078ef820ULL,
0x0000000166677824ULL, 0x040fe200078e0279ULL, 0x0000002019197817ULL, 0x000fe20003800000ULL,
0x0000000866727824ULL, 0x000fe200078e00ffULL, 0x000000101c787810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e001eULL, 0x000000196600720cULL, 0x000fc40003f86070ULL,
0xfffffff872727812ULL, 0x000fe200078ee21bULL, 0x0000010067667825ULL, 0x000fe200078e001eULL,
0x00000020646a7210ULL, 0x000fe40007f1e0ffULL, 0x000000036e767819ULL, 0x000fe200000006ffULL,
0x000000017c6b7824ULL, 0x100fe200078e0200ULL, 0x00000066646c7210ULL, 0x000fe20007f3e0ffULL,
0x000000087c7e7824ULL, 0x000fe200078e00ffULL, 0x000000196e00720cULL, 0x0c0fe20003f46070ULL,
0x000000016e1b7824ULL, 0x100fe200078e0200ULL, 0x000000196800720cULL, 0x080fe20003f66070ULL,
0x0000000178697824ULL, 0x000fe200078e0200ULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee26bULL,
0x00000001656b7824ULL, 0x000fe200000e0621ULL, 0xfffffff876767812ULL, 0x000fe200078ee21bULL,
0x0000000168217824ULL, 0x000fe200078e0279ULL, 0x000000191c00720cULL, 0x000fe20003fa6070ULL,
0x00000008787a7824ULL, 0x000fc400078e00ffULL, 0x00000001656d7824ULL, 0x000fe200008e0667ULL,
0x000000197800720cULL, 0x000fe20003f26070ULL, 0x000000016e677824ULL, 0x000fe200078e0279ULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee269ULL, 0x000000011c1b7824ULL, 0x000fe200078e0200ULL,
0x0000007978697210ULL, 0x000fe20007ffe0ffULL, 0x0000010021207825ULL, 0x100fe200078e001eULL,
0x0000001c1c787810ULL, 0x000fe40007ffe0ffULL, 0x000000071b717812ULL, 0x000fe200078ec0ffULL,
0x0000010067667825ULL, 0x000fe200078e001eULL, 0x00000020646e7210ULL, 0x000fc40007f1e0ffULL,
0x00016000701b7810ULL, 0x000fe20007ffe0ffULL, 0x0000010069687825ULL, 0x000fe200078e001eULL,
0x0000006664667210ULL, 0x000fe40007fde0ffULL, 0x0ffffff871207812ULL, 0x000fe200078ef800ULL,
0x00000001656f7824ULL, 0x040fe200000e0621ULL, 0x000000197c00720cULL, 0x040fe20003f06070ULL,
0x000000017c217824ULL, 0x000fe400078e0279ULL, 0x0000000165677824ULL, 0x000fe200030e0667ULL,
0x0000006864687210ULL, 0x000fe20007fde0ffULL, 0x0000001020737824ULL, 0x000fc400078e021bULL,
0x0000010021207825ULL, 0x000fc600078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a737faeULL, 0x0003e2000e901c46ULL, 0x0000001072757824ULL, 0x000fe200078e021bULL,
0x000000181c727810ULL, 0x000fe20007ffe0ffULL, 0x0000000165697824ULL, 0x040fe200030e0669ULL,
0x0000002064707210ULL, 0x000fe40007fde0ffULL, 0x000000006c757faeULL, 0x0005e2000e101c46ULL,
0x0000000172777824ULL, 0x040fe200078e0279ULL, 0x000000197200720cULL, 0x080fe20003fa6070ULL,
0x0000000165717824ULL, 0x000fe200030e0621ULL, 0x000000197800720cULL, 0x000fe20003f86070ULL,
0x0000010077207825ULL, 0x000fe200078e001eULL, 0x00000000721c7210ULL, 0x000fc60007ffe0ffULL,
0x0000000178197824ULL, 0x000fe200078e0279ULL, 0x0000002064207210ULL, 0x000fe20007fde0ffULL,
0x00000008726b7824ULL, 0x002fe400078e00ffULL, 0x00000100191e7825ULL, 0x000fc600078e001eULL,
0xfffffff86b1c7812ULL, 0x000fe200078ee21cULL, 0x00000001786a7824ULL, 0x040fe400078e0200ULL,
0x00000008786d7824ULL, 0x004fe400078e00ffULL, 0x0000000165217824ULL, 0x000fe200030e0621ULL,
0x0000001e641e7210ULL, 0x000fe20007fde0ffULL, 0x0000001074197824ULL, 0x100fe200078e021bULL,
0xfffffff86d6a7812ULL, 0x000fe200078ee26aULL, 0x00000010766b7824ULL, 0x100fe400078e021bULL,
0x000000107a6d7824ULL, 0x100fe200078e021bULL, 0x000000006e197faeULL, 0x0003e2000d901c46ULL,
0x000000107e737824ULL, 0x000fc400078e021bULL, 0x000000101c757824ULL, 0x000fe200078e021bULL,
0x0000001b6a1b7211ULL, 0x000fe200078e20ffULL, 0x00000001651f7824ULL, 0x000fe200030e061fULL,
0x00000000666b7faeULL, 0x0003e8000d101c46ULL, 0x00000000686d7faeULL, 0x0003e8000c901c46ULL,
0x0000000070737faeULL, 0x0003e8000c101c46ULL, 0x0000000020757faeULL, 0x0003e8000e901c46ULL,
0x000000001e1b7faeULL, 0x0003e2000e101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000400217811ULL, 0x042fe200078fe8ffULL, 0x000000809d707824ULL, 0x000fe200078e00ffULL,
0x0000000c00697811ULL, 0x040fe200078fe8ffULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x00000010006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000121197824ULL, 0x100fe200078e0200ULL,
0x000020001b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008211e7824ULL, 0x000fe200078e00ffULL,
0x0000000800677811ULL, 0x040fe200078fe8ffULL, 0x00000001691c7824ULL, 0x140fe200078e0200ULL,
0x00000018006f7811ULL, 0x000fe200078fe8ffULL, 0x0000000869777824ULL, 0x000fe200078e00ffULL,
0xfffffff81e737812ULL, 0x000fe200078ee219ULL, 0x000000016b197824ULL, 0x000fe200078e0200ULL,
0x00000014006d7811ULL, 0x000fe200078fe8ffULL, 0x0000400020207824ULL, 0x000fe200078e021bULL,
0xfffffff877777812ULL, 0x000fe200078ee21cULL, 0x00000001671b7824ULL, 0x000fe200078e0200ULL,
0x000000036b1c7819ULL, 0x000fe200000006ffULL, 0x0000000867667824ULL, 0x000fe200078e00ffULL,
0x0000008013707812ULL, 0x000fe200078ef870ULL, 0x000000086f7f7824ULL, 0x040fe200078e00ffULL,
0xfffffff81c7b7812ULL, 0x000fe200078ee219ULL, 0x000000016f1c7824ULL, 0x100fe200078e0200ULL,
0xfffffff866757812ULL, 0x000fe200078ee21bULL, 0x000000016d1b7824ULL, 0x040fe200078e0200ULL,
0x0000000000197211ULL, 0x040fe200078fe8ffULL, 0x000000086d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee21cULL, 0x0000000121217824ULL, 0x100fe200078e0279ULL,
0x0000001c001c7811ULL, 0x000fe200078fe8ffULL, 0x0000000167677824ULL, 0x000fe200078e0279ULL,
0xfffffff81e7d7812ULL, 0x000fe200078ee21bULL, 0x0000000169697824ULL, 0x100fe200078e0279ULL,
0x00000079001f7211ULL, 0x080fe200078fe8ffULL, 0x000000011c1e7824ULL, 0x040fe200078e0200ULL,
0x00000007191b7812ULL, 0x000fe200078ec0ffULL, 0x000000081c857824ULL, 0x040fe200078e00ffULL,
0x000000796d6d7210ULL, 0x000fe20007ffe0ffULL, 0x000000011c197824ULL, 0x000fe200078e0279ULL,
0x00016000201c7810ULL, 0x000fe20007ffe0ffULL, 0x0000010021207825ULL, 0x000fe200078e0070ULL,
0xfffffff885857812ULL, 0x000fc400078ee21eULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef800ULL,
0x000001001f1e7825ULL, 0x000fe200078e0070ULL, 0x0000002064207210ULL, 0x000fc60007f3e0ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0279ULL, 0x0000001e641e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010067667825ULL, 0x000fc800078e0070ULL, 0x0000010069687825ULL, 0x000fe200078e0070ULL,
0x0000006664667210ULL, 0x000fc60007f5e0ffULL, 0x000000016f6f7824ULL, 0x000fe200078e0279ULL,
0x0000006864687210ULL, 0x000fe20007f7e0ffULL, 0x000001006b6a7825ULL, 0x000fc800078e0070ULL,
0x000001006d6c7825ULL, 0x000fc800078e0070ULL, 0x000001006f6e7825ULL, 0x000fc800078e0070ULL,
0x0000010019707825ULL, 0x000fc800078e0070ULL, 0x00000001651f7824ULL, 0x040fe200000e061fULL,
0x0000006a646a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000165217824ULL, 0x000fe200008e0621ULL,
0x0000006c646c7210ULL, 0x040fe20007f3e0ffULL, 0x000000101b197824ULL, 0x100fe400078e021cULL,
0x00000010731b7824ULL, 0x100fe400078e021cULL, 0x0000000165677824ULL, 0x040fe200010e0667ULL,
0x0000006e646e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000165697824ULL, 0x000fe200018e0669ULL,
0x0000007064707210ULL, 0x000fe20007f7e0ffULL, 0x0000001075737824ULL, 0x100fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e2000b901c46ULL,
0x0000001077757824ULL, 0x100fe200078e021cULL, 0x0000001c7b777211ULL, 0x000fe200078e20ffULL,
0x00000001656b7824ULL, 0x040fe200000e066bULL, 0x0000006f656f7210ULL, 0x000fe200017fe4ffULL,
0x000000107d797824ULL, 0x000fe200078e021cULL, 0x00000000201b7faeULL, 0x0003e2000b901c46ULL,
0x00000001656d7824ULL, 0x000fc400008e066dULL, 0x000000107f7b7824ULL, 0x100fe200078e021cULL,
0x0000000066737faeULL, 0x0003e2000b901c46ULL, 0x00000010857d7824ULL, 0x000fe400078e021cULL,
0x0000000165717824ULL, 0x000fe200018e0671ULL, 0x0000000068757faeULL, 0x0003e8000b901c46ULL,
0x000000006a777faeULL, 0x0003e8000b901c46ULL, 0x000000006c797faeULL, 0x0003e8000b901c46ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c46ULL, 0x00000000707d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe080197812ULL, 0x002fc400078ec0ffULL,
0x00000010801c7812ULL, 0x040fe400078ec0ffULL, 0x00000008801b7812ULL, 0x000fc800078ec0ffULL,
0x000000191b1b7210ULL, 0x000fe20007ffe01cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e628001b667f8cULL, 0x0002a4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x01e62c001b197984ULL, 0x000ee40000000800ULL, 0x8000000019ff7812ULL, 0x00cfe40007804867ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e1c7210ULL, 0x000fca0007f1e1ffULL,
0x0000000121207824ULL, 0x000fe200000e0e1fULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff197819ULL, 0x000fc80000011420ULL,
0x0000001c19197211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e0620ULL,
0x0000000219197819ULL, 0x000fc8000000121cULL, 0x000000190000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000168687810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e62c001b197984ULL, 0x000ea40000000800ULL,
0x8000000019ff7812ULL, 0x004fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000209d197824ULL, 0x000fca00078e00ffULL, 0xffffff80191c7812ULL, 0x000fc800078ec0ffULL,
0x0000008013197810ULL, 0x000fca0007ffe01cULL, 0x0000000182197824ULL, 0x000fca00078e0219ULL,
0x01e0000019697984ULL, 0x000ea80000000800ULL, 0x01e20000191c7984ULL, 0x0006620000000800ULL,
0x000000186900720bULL, 0x004fe20003f1d000ULL, 0x000152b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000197806ULL, 0x008fc800000e0100ULL, 0x000000ff1900720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff1b7224ULL, 0x002fd400078e0018ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000019d1e7811ULL, 0x000fe400078ff0ffULL, 0x000000186900720bULL, 0x000fe40003f34000ULL,
0x0000009d1e00720cULL, 0x000fe20003f05270ULL, 0x000152727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000667806ULL, 0x000fc400008e0100ULL, 0x000000809d1f8824ULL, 0x000fe200078e0213ULL,
0x00000018691b8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x00000001821e8824ULL, 0x000fca00078e021fULL, 0x01e4001b1e008388ULL, 0x0003e20000000800ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x00000018691b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff66ff7812ULL, 0x000fc6000780c0ffULL, 0x000000181b1b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1b1b7820ULL, 0x000fc80000410000ULL, 0x0000001b00687308ULL, 0x000e640000000800ULL,
0x000000681d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x000151b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0002a400000e0000ULL, 0x0000001e60607220ULL, 0x084fe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x080fe40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x000fc40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x080fe40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0066ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x000150a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e62627220ULL, 0x08cfe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000066ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x00014f927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e40407220ULL, 0x08cfe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000066ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x00014e927f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e42427220ULL, 0x08cfe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006619ff7212ULL, 0x000fe400078030ffULL, 0x00000018691b7209ULL, 0x000fd60007810000ULL,
0x8000001b69690221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL,
0x0000006900120308ULL, 0x000e640000000800ULL, 0x000000121c1c0220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001d1c1d7221ULL, 0x000fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000010ffULL, 0x00000002ff197819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x00014cf27f007947ULL, 0x000fea000b800000ULL,
0x00001f190e117589ULL, 0x0002a400000e0000ULL, 0x00000008191e7810ULL, 0x000fe20007ffe0ffULL,
0x00014d427f007947ULL, 0x000fea000b800000ULL, 0x00000010190f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1e0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x00000018191e7810ULL, 0x008fe20007ffe0ffULL, 0x00014dd27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL, 0x000004009d187824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000020009d197824ULL, 0x000fe200078e00ffULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0xfffff00018187812ULL, 0x000fc400078ec0ffULL,
0xffffc000191c7812ULL, 0x000fe400078ec0ffULL, 0x0001300018187810ULL, 0x000fc60007ffe0ffULL,
0x00002000151c7824ULL, 0x000fe400078e021cULL, 0x000000100d7c7824ULL, 0x100fe400078e0218ULL,
0x000000100c187824ULL, 0x000fe200078e0218ULL, 0x000170001c1c7810ULL, 0x000fc60007ffe0ffULL,
0x000000007c7c783bULL, 0x000e620000000200ULL, 0x0000001c09707211ULL, 0x000fe200078e20ffULL,
0x000000100a787824ULL, 0x100fe400078e021cULL, 0x000000001868783bULL, 0x0006a20000000200ULL,
0x000000100b747824ULL, 0x000fe200078e021cULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x000000117c7c7231ULL, 0x086fe400003400ffULL, 0x000000117e7e7231ULL, 0x000fe400003400ffULL,
0x000000107d7d7231ULL, 0x000fc400003400ffULL, 0x000000107f7f7231ULL, 0x000fe400003400ffULL,
0x0000000f68687231ULL, 0x080fe400003400ffULL, 0x0000000f6a6a7231ULL, 0x000fe400003400ffULL,
0x0000000e69697231ULL, 0x088fe400003400ffULL, 0x0000000e6b6b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010086c7824ULL, 0x000fe200078e021cULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000002ff1c7819ULL, 0x100fe2000001169dULL,
0x0000029000007945ULL, 0x000fe20003800000ULL, 0x00000001ff187819ULL, 0x008fe2000001169dULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x000130001c1e7811ULL, 0x002fc600078e60ffULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x00000002181f7824ULL, 0x000fc600078e0215ULL,
0x000000006c6c783bULL, 0x000ea40000004200ULL, 0x000170001f1f7811ULL, 0x000fe200078e68ffULL,
0x000000787c60723cULL, 0x050f700000041860ULL, 0x0000007a7c24723cULL, 0x040f700000041824ULL,
0x000000747c28723cULL, 0x048f700000041828ULL, 0x000000767c2c723cULL, 0x040f70000004182cULL,
0x000000707c30723cULL, 0x042f700000041830ULL, 0x000000727c34723cULL, 0x040f700000041834ULL,
0x0000006c7c38723cULL, 0x044f700000041838ULL, 0x0000006e7c3c723cULL, 0x000b6e000004183cULL,
0x00000010077c7824ULL, 0x120fe200078e021eULL, 0x000000786840723cULL, 0x000b620000041840ULL,
0x00000010061e7824ULL, 0x000fc800078e021eULL, 0x000000007c7c783bULL, 0x000e640000000200ULL,
0x0000001005787824ULL, 0x120fe200078e021fULL, 0x0000007a6844723cULL, 0x040f700000041844ULL,
0x000000746848723cULL, 0x040b6e0000041848ULL, 0x0000001004747824ULL, 0x120fe200078e021fULL,
0x00000076684c723cULL, 0x040f70000004184cULL, 0x000000706850723cULL, 0x040b6e0000041850ULL,
0x0000001003707824ULL, 0x020fe200078e021fULL, 0x000000726854723cULL, 0x040f700000041854ULL,
0x0000006c6858723cULL, 0x040f700000041858ULL, 0x0000006e685c723cULL, 0x000b64000004185cULL,
0x000000001e68783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x000000117c7c7231ULL, 0x082fe400003400ffULL,
0x000000117e7e7231ULL, 0x000fc400003400ffULL, 0x000000107d7d7231ULL, 0x080fe400003400ffULL,
0x000000107f7f7231ULL, 0x000fe400003400ffULL, 0x0000000f68687231ULL, 0x088fe400003400ffULL,
0x0000000f6a6a7231ULL, 0x000fe400003400ffULL, 0x0000000e69697231ULL, 0x080fe400003400ffULL,
0x0000000e6b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x00000010026c7824ULL, 0x000fe200078e021fULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x0000000899217824ULL, 0x000fe200078e0218ULL, 0x0001e6901c1e7811ULL, 0x004fc400078e18ffULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000f280000004200ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x000000787c60723cULL, 0x042b700000041860ULL,
0x0000007a7c24723cULL, 0x040b700000041824ULL, 0x000000747c28723cULL, 0x044b700000041828ULL,
0x000000767c2c723cULL, 0x040b70000004182cULL, 0x000000707c30723cULL, 0x050b700000041830ULL,
0x000000727c34723cULL, 0x040b700000041834ULL, 0x0000006c7c38723cULL, 0x048b700000041838ULL,
0x0000006e7c3c723cULL, 0x000b70000004183cULL, 0x000000786840723cULL, 0x040b700000041840ULL,
0x0000007a6844723cULL, 0x040b700000041844ULL, 0x000000746848723cULL, 0x040b700000041848ULL,
0x00000076684c723cULL, 0x040b70000004184cULL, 0x000000706850723cULL, 0x040b700000041850ULL,
0x000000726854723cULL, 0x040b700000041854ULL, 0x0000006c6858723cULL, 0x040b700000041858ULL,
0x0000006e685c723cULL, 0x000b62000004185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000199677810ULL, 0x000fe20007ffe0ffULL, 0x000000001eff7f8cULL, 0x0003e2000c80043fULL,
0x000000c021217811ULL, 0x000fc400078e28ffULL, 0x000000226700720cULL, 0x000fe40003f06070ULL,
0x00000060211f7812ULL, 0x000fc800078ec0ffULL, 0x0000001f16737210ULL, 0x020fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff707819ULL, 0x102fe40000011600ULL, 0x00000021981e7217ULL, 0x000fe40007800000ULL,
0x0000000470207810ULL, 0x040fe40007ffe0ffULL, 0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e1f7824ULL, 0x000fe200078e0a21ULL, 0x0000000870687810ULL, 0x000fe20007ffe0ffULL,
0x0000000120217824ULL, 0x100fe200078e0200ULL, 0x0000001070747810ULL, 0x000fe20007ffe0ffULL,
0x00000008206a7824ULL, 0x000fe200078e00ffULL, 0x000000201f717817ULL, 0x000fe20003800000ULL,
0x000000809d1e7824ULL, 0x000fe200078e00ffULL, 0x0000001470767810ULL, 0x000fe20007ffe0ffULL,
0x000000016e677824ULL, 0x000fe200078e0200ULL, 0xfffffff86a777812ULL, 0x000fe200078ee221ULL,
0x000000086e6c7824ULL, 0x000fe200078e00ffULL, 0x00000080131e7812ULL, 0x000fe200078ef81eULL,
0x0000000168667824ULL, 0x000fe200078e0200ULL, 0x000000712000720cULL, 0x000fe20003f86070ULL,
0x0000000868797824ULL, 0x000fe200078e00ffULL, 0xfffffff86c7b7812ULL, 0x000fe200078ee267ULL,
0x0000000170217824ULL, 0x000fe200078e0273ULL, 0x0000007320677210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fe200078ee266ULL,
0x0000000174697824ULL, 0x000fe200078e0200ULL, 0x0000200019197812ULL, 0x000fe200078ec0ffULL,
0x0000010021207825ULL, 0x000fe200078e001eULL, 0x000000716e00720cULL, 0x000fc40003f46070ULL,
0x000000716800720cULL, 0x080fe20003f66070ULL, 0x00000008746c7824ULL, 0x000fe200078e00ffULL,
0x00000020646a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010067667825ULL, 0x000fe200078e001eULL,
0x000000717000720cULL, 0x000fe40003fa6070ULL, 0xfffffff86c7d7812ULL, 0x000fe200078ee269ULL,
0x00000001766b7824ULL, 0x000fe200078e0200ULL, 0x00000066646c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000876727824ULL, 0x000fe400078e00ffULL, 0x0000000174697824ULL, 0x000fc400078e0273ULL,
0x00000001656d7824ULL, 0x040fe200008e0667ULL, 0xfffffff8727f7812ULL, 0x000fe200078ee26bULL,
0x00000001656b7824ULL, 0x000fe200000e0621ULL, 0x000000736e677210ULL, 0x000fe20007ffe0ffULL,
0x0000000168217824ULL, 0x000fe200078e0273ULL, 0x000000717400720cULL, 0x000fe20003f26070ULL,
0x0000400018727824ULL, 0x000fe200078e0219ULL, 0x0000001870747810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fc600078e001eULL, 0x0001700072727810ULL, 0x000fe20007ffe0ffULL,
0x0000000170197824ULL, 0x000fe200078e0200ULL, 0x00000020646e7210ULL, 0x040fe20007f1e0ffULL,
0x0000010067667825ULL, 0x100fe200078e001eULL, 0x000000727f7f7211ULL, 0x000fe400078e20ffULL,
0x0000000719197812ULL, 0x000fe200078ec0ffULL, 0x0000010069687825ULL, 0x000fe200078e001eULL,
0x0000006664667210ULL, 0x000fe40007fde0ffULL, 0x0ffffff819197812ULL, 0x000fe200078ef800ULL,
0x00000001656f7824ULL, 0x040fe200000e0621ULL, 0x000000717600720cULL, 0x040fe20003f06070ULL,
0x0000000176217824ULL, 0x000fe200078e0273ULL, 0x0000001c70767810ULL, 0x000fe20007ffe0ffULL,
0x0000000165677824ULL, 0x000fe200030e0667ULL, 0x0000006864687210ULL, 0x000fe20007fde0ffULL,
0x0000010021207825ULL, 0x000fc800078e001eULL, 0x0000001019757824ULL, 0x100fe400078e0272ULL,
0x0000001077777824ULL, 0x100fe400078e0272ULL, 0x0000000165697824ULL, 0x000fe200030e0669ULL,
0x0000002064707210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a757faeULL, 0x0003e2000e901c46ULL, 0x0000000174197824ULL, 0x140fe200078e0273ULL,
0x000000717400720cULL, 0x080fe20003fa6070ULL, 0x0000000176737824ULL, 0x040fe200078e0273ULL,
0x000000006c777faeULL, 0x0005e2000e101c46ULL, 0x000000717600720cULL, 0x000fe20003f86070ULL,
0x0000001079797824ULL, 0x000fe200078e0272ULL, 0x0000002165717210ULL, 0x000fe200037fe4ffULL,
0x0000010019207825ULL, 0x000fc600078e001eULL, 0x000000006e797faeULL, 0x0005e2000d901c46ULL,
0x0000000174197824ULL, 0x100fe200078e0200ULL, 0x0000002064207210ULL, 0x000fe20007fde0ffULL,
0x0000000874747824ULL, 0x000fe400078e00ffULL, 0x00000001766a7824ULL, 0x042fe400078e0200ULL,
0x00000008766b7824ULL, 0x000fe200078e00ffULL, 0xfffffff874197812ULL, 0x000fe200078ee219ULL,
0x00000100731e7825ULL, 0x000fc600078e001eULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee26aULL,
0x0000000165217824ULL, 0x000fe200030e0621ULL, 0x0000001e641e7210ULL, 0x000fe20007fde0ffULL,
0x000000107b7b7824ULL, 0x100fe400078e0272ULL, 0x000000107d7d7824ULL, 0x100fe400078e0272ULL,
0x0000001019197824ULL, 0x100fe200078e0272ULL, 0x00000000667b7faeULL, 0x0005e2000d101c46ULL,
0x000000106b6b7824ULL, 0x000fe400078e0272ULL, 0x00000001651f7824ULL, 0x000fe200030e061fULL,
0x00000000687d7faeULL, 0x0005e8000c901c46ULL, 0x00000000707f7faeULL, 0x0005e8000c101c46ULL,
0x0000000020197faeULL, 0x0005e8000e901c46ULL, 0x000000001e6b7faeULL, 0x0005e2000e101c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000400217811ULL, 0x042fe200078fe8ffULL,
0x000000809d707824ULL, 0x000fe200078e00ffULL, 0x0000000800677811ULL, 0x000fc400078fe8ffULL,
0x00000010006b7811ULL, 0x040fe200078fe8ffULL, 0x00000001211e7824ULL, 0x140fe200078e0200ULL,
0x00000014006d7811ULL, 0x040fe200078fe8ffULL, 0x0000000821697824ULL, 0x000fe200078e00ffULL,
0x00000018006f7811ULL, 0x040fe200078fe8ffULL, 0x00000001671f7824ULL, 0x000fe200078e0200ULL,
0x0000008013707812ULL, 0x000fe200078ef870ULL, 0x0000000867767824ULL, 0x000fe200078e00ffULL,
0xfffffff869747812ULL, 0x000fe200078ee21eULL, 0x000000086b7a7824ULL, 0x000fe200078e00ffULL,
0x0000000c00697811ULL, 0x000fe200078fe8ffULL, 0x000000016d207824ULL, 0x140fe200078e0200ULL,
0xfffffff876767812ULL, 0x000fe200078ee21fULL, 0x000000086d757824ULL, 0x000fe200078e00ffULL,
0x000000006b1f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001691e7824ULL, 0x000fc400078e0200ULL,
0x0000000869717824ULL, 0x000fe200078e00ffULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee21fULL,
0x000000016f667824ULL, 0x000fe200078e0200ULL, 0x00002000191f7812ULL, 0x000fe200078ec0ffULL,
0x000000086f777824ULL, 0x000fe200078e00ffULL, 0x0000000000197211ULL, 0x000fe200078fe8ffULL,
0x0000000121217824ULL, 0x100fe200078e0273ULL, 0xfffffff8757c7812ULL, 0x000fe200078ee220ULL,
0x0000000167677824ULL, 0x000fe200078e0273ULL, 0xfffffff871787812ULL, 0x000fe200078ee21eULL,
0x00004000181e7824ULL, 0x000fe200078e021fULL, 0x0000001c00207811ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x100fe200078e0273ULL, 0x0000000719717812ULL, 0x000fe200078ec0ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0273ULL, 0xfffffff8777e7812ULL, 0x000fe200078ee266ULL,
0x0000000120667824ULL, 0x100fe200078e0200ULL, 0x00000073001f7211ULL, 0x080fe200078fe8ffULL,
0x0000000820757824ULL, 0x040fe200078e00ffULL, 0x0ffffff871727812ULL, 0x000fe200078ef800ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x0000007369697210ULL, 0x000fe20007ffe0ffULL,
0x000000016f6f7824ULL, 0x100fe200078e0273ULL, 0xfffffff875867812ULL, 0x000fe200078ee266ULL,
0x0000000120197824ULL, 0x000fe200078e0273ULL, 0x000170001e737810ULL, 0x000fe20007ffe0ffULL,
0x000001001f1e7825ULL, 0x000fc600078e0070ULL, 0x0000007376777211ULL, 0x000fe200078e20ffULL,
0x0000010021207825ULL, 0x000fe200078e0070ULL, 0x0000001e641e7210ULL, 0x000fc60007f1e0ffULL,
0x0000010067667825ULL, 0x000fe200078e0070ULL, 0x0000002064207210ULL, 0x000fc60007f3e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0070ULL, 0x0000006664667210ULL, 0x000fc60007f5e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0070ULL, 0x0000006864687210ULL, 0x000fc60007f7e0ffULL,
0x000001006d6c7825ULL, 0x000fc800078e0070ULL, 0x000001006f6e7825ULL, 0x000fc800078e0070ULL,
0x0000010019707825ULL, 0x000fc800078e0070ULL, 0x00000001651f7824ULL, 0x040fe200000e061fULL,
0x0000006a646a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000165217824ULL, 0x040fe200008e0621ULL,
0x0000006c646c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001072197824ULL, 0x000fe200078e0273ULL,
0x0000006b656b7210ULL, 0x040fe200007fe4ffULL, 0x0000000165677824ULL, 0x040fe200010e0667ULL,
0x0000006e646e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001074757824ULL, 0x000fe200078e0273ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e197faeULL, 0x0003e2000b901c46ULL,
0x0000000165697824ULL, 0x000fe200018e0669ULL, 0x0000007064647210ULL, 0x000fe20007f7e0ffULL,
0x0000001078797824ULL, 0x100fe200078e0273ULL, 0x0000000020757faeULL, 0x0003e2000b901c46ULL,
0x000000107a7b7824ULL, 0x000fc400078e0273ULL, 0x000000107c7d7824ULL, 0x000fe200078e0273ULL,
0x0000000066777faeULL, 0x0003e2000b901c46ULL, 0x00000001656d7824ULL, 0x040fe400008e066dULL,
0x000000107e7f7824ULL, 0x000fe200078e0273ULL, 0x0000000068797faeULL, 0x0003e2000b901c46ULL,
0x00000001656f7824ULL, 0x040fe400010e066fULL, 0x0000001086737824ULL, 0x000fe200078e0273ULL,
0x000000006a7b7faeULL, 0x0003e2000b901c46ULL, 0x0000000165657824ULL, 0x000fc600018e0671ULL,
0x000000006c7d7faeULL, 0x0003e8000b901c46ULL, 0x000000006e7f7faeULL, 0x0003e8000b901c46ULL,
0x0000000064737faeULL, 0x0003e4000b901c46ULL, 0x00000300ff197624ULL, 0x006fe200078e00ffULL,
0x000000011a1e7812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000011e00780cULL, 0x000fc40003f05070ULL, 0xffffffff19197811ULL, 0x000fc800078e08ffULL,
0x0000000119197807ULL, 0x000fca0004000000ULL, 0x000000011a1a7824ULL, 0x000fe400078e0219ULL,
0xffffffffff197424ULL, 0x000fc600078e00ffULL, 0x000000231a00720cULL, 0x000fda0003f06070ULL,
0x000000011a1e8824ULL, 0x000fe400078e0214ULL, 0x00000004ff1f8424ULL, 0x000fc800078e00ffULL,
0x000066001e1e8625ULL, 0x000fca00078e001fULL, 0x000000061e198981ULL, 0x000322000c1e1900ULL,
0x0000001080217812ULL, 0x000fca00078ec0ffULL, 0x000000201c1c7824ULL, 0x000fe200078e0221ULL,
0x0000000880217812ULL, 0x000fc800078ec0ffULL, 0x0000001c211c7210ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e648001c647f8cULL, 0x0022a4000c80043fULL,
0x00000000001e7805ULL, 0x000fc40000015200ULL, 0x01e64c001c217984ULL, 0x000ee40000000800ULL,
0x8000000021ff7812ULL, 0x00cfe40007804865ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff667224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201e677210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1fULL,
0x003d09006700780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406700780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011421ULL, 0x0000006720207211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000220207819ULL, 0x000fc80000001221ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000166667810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e64c001c217984ULL, 0x000ea40000000800ULL, 0x8000000021ff7812ULL, 0x004fe40007804865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209d1c7824ULL, 0x002fca00078e00ffULL,
0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL, 0x00000100131f7810ULL, 0x000fca0007ffe01cULL,
0x00000001821f7824ULL, 0x000fca00078e021fULL, 0x01e000001f1c7984ULL, 0x000e680000000800ULL,
0x01e200001f647984ULL, 0x0004e20000000800ULL, 0x0000001b1c00720bULL, 0x002fe20003f1d000ULL,
0x000137927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000657806ULL, 0x004fc800000e0100ULL,
0x000000ff6500720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000029d1e7811ULL, 0x000fe400078ff0ffULL, 0x0000001b1c00720bULL, 0x000fe40003f34000ULL,
0x0000009d1e00720cULL, 0x000fe20003f05270ULL, 0x000137627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000667806ULL, 0x000fc400008e0100ULL, 0x000000139d1f8211ULL, 0x000fe200078e38ffULL,
0x0000065000017945ULL, 0x000fe20003800000ULL, 0x0000001b1c1e8209ULL, 0x000fc60007810000ULL,
0x00000001821f8824ULL, 0x000fca00078e021fULL, 0x01e4001e1f008388ULL, 0x0003e20000000800ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001b1c1e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff66ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001b1e1e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL, 0x0000001e00687308ULL, 0x000e640000000800ULL,
0x000000681d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x000136a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0002a400000e0000ULL, 0x0000001e60607220ULL, 0x084fe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x080fe40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x000fc40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x080fe40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0066ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x000135927f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x00046400000e0000ULL,
0x0000001e62627220ULL, 0x086fe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000066ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x000134827f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x00046400000e0000ULL, 0x0000001e40407220ULL, 0x086fe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000066ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x000133827f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x00046400000e0000ULL, 0x0000001e42427220ULL, 0x086fe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006665ff7212ULL, 0x000fe400078030ffULL, 0x0000001b1c1b7209ULL, 0x000fd60007810000ULL,
0x8000001b1c1c0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c00120308ULL, 0x000e640000000800ULL, 0x0000001264640220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001d641d7221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000010ffULL, 0x00000002ff657819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x000131e27f007947ULL, 0x000fea000b800000ULL,
0x00001f650e117589ULL, 0x0002a400000e0000ULL, 0x00000008651e7810ULL, 0x000fe20007ffe0ffULL,
0x000132327f007947ULL, 0x000fea000b800000ULL, 0x00000010650f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1e0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x00000018651e7810ULL, 0x008fe20007ffe0ffULL, 0x000132c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL, 0x000004009d1c7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002181f7824ULL, 0x000fe200078e0215ULL,
0x0000015000007945ULL, 0x000fe40003800000ULL, 0xfffff0001c1e7812ULL, 0x002fe200078ec0ffULL,
0x000020001f1c7824ULL, 0x000fc600078e00ffULL, 0x000140001e1e7810ULL, 0x000fe40007ffe0ffULL,
0x000160001c1f7810ULL, 0x000fc60007ffe0ffULL, 0x000000100d687824ULL, 0x100fe400078e021eULL,
0x000000100c1e7824ULL, 0x000fe400078e021eULL, 0x000000100a6c7824ULL, 0x100fe400078e021fULL,
0x000000006868783bULL, 0x000e620000000200ULL, 0x000000100b707824ULL, 0x100fe400078e021fULL,
0x0000001009747824ULL, 0x000fe200078e021fULL, 0x000000001e64783bULL, 0x0006a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001168687231ULL, 0x086fe400003400ffULL,
0x000000116a6a7231ULL, 0x000fc400003400ffULL, 0x0000001069697231ULL, 0x080fe400003400ffULL,
0x000000106b6b7231ULL, 0x000fe400003400ffULL, 0x0000000f64647231ULL, 0x080fe400003400ffULL,
0x0000000f66667231ULL, 0x000fe400003400ffULL, 0x0000000e65657231ULL, 0x088fe400003400ffULL,
0x0000000e67677231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008787824ULL, 0x000fe200078e021fULL, 0x000000006c6c783bULL, 0x000ee40000004200ULL,
0x00000002ff1e7819ULL, 0x008fe2000001169dULL, 0x0000025000007945ULL, 0x000fe20003800000ULL,
0x000000007070783bULL, 0x000fe40000004200ULL, 0x000140001e207811ULL, 0x000fc400078e60ffULL,
0x000000007878783bULL, 0x000ee80000004200ULL, 0x000000007474783bULL, 0x000ea40000004200ULL,
0x0000006c6440723cULL, 0x004f700000041840ULL, 0x000000786838723cULL, 0x04af700000041838ULL,
0x0000007a683c723cULL, 0x000f70000004183cULL, 0x000000786458723cULL, 0x040f700000041858ULL,
0x0000006e6444723cULL, 0x040f700000041844ULL, 0x000000706448723cULL, 0x040f700000041848ULL,
0x00000072644c723cULL, 0x040f70000004184cULL, 0x000000746450723cULL, 0x040f700000041850ULL,
0x000000766454723cULL, 0x040f700000041854ULL, 0x0000007a6478723cULL, 0x000b6e000004185cULL,
0x0000002007647211ULL, 0x020fe200078e20ffULL, 0x0000001006207824ULL, 0x000fe200078e0220ULL,
0x0000006c6860723cULL, 0x040b680000041860ULL, 0x000000006464783bULL, 0x000e660000000200ULL,
0x00000010046c7824ULL, 0x120fe200078e021fULL, 0x0000006e6824723cULL, 0x040f620000041824ULL,
0x00000000205c783bULL, 0x0004ee0000000200ULL, 0x000000706828723cULL, 0x040b6e0000041828ULL,
0x0000001003707824ULL, 0x120fe200078e021fULL, 0x00000072682c723cULL, 0x040f70000004182cULL,
0x000000746830723cULL, 0x040f700000041830ULL, 0x000000766834723cULL, 0x000b6e0000041834ULL,
0x0000001005687824ULL, 0x020fe200078e021fULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000001164647231ULL, 0x086fe400003400ffULL, 0x0000001166667231ULL, 0x000fc400003400ffULL,
0x0000001065657231ULL, 0x080fe400003400ffULL, 0x0000001067677231ULL, 0x000fe400003400ffULL,
0x0000000f5c5c7231ULL, 0x088fe400003400ffULL, 0x0000000f5e5e7231ULL, 0x000fe400003400ffULL,
0x0000000e5d5d7231ULL, 0x080fe400003400ffULL, 0x0000000e5f5f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000001002747824ULL, 0x000fe200078e021fULL,
0x000000006868783bULL, 0x000e620000004200ULL, 0x0001e6981e1f7811ULL, 0x000fc600078e18ffULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x000000685c40723cULL, 0x04ab700000041840ULL,
0x0000006a5c44723cULL, 0x040b700000041844ULL, 0x0000006c5c48723cULL, 0x044b700000041848ULL,
0x0000006e5c4c723cULL, 0x040b70000004184cULL, 0x000000705c50723cULL, 0x040b700000041850ULL,
0x000000725c54723cULL, 0x040b700000041854ULL, 0x000000745c58723cULL, 0x000b700000041858ULL,
0x000000686460723cULL, 0x040b700000041860ULL, 0x0000006a6424723cULL, 0x040b700000041824ULL,
0x0000006c6428723cULL, 0x040b700000041828ULL, 0x0000006e642c723cULL, 0x040b70000004182cULL,
0x000000706430723cULL, 0x040b700000041830ULL, 0x000000726434723cULL, 0x040b700000041834ULL,
0x000000746438723cULL, 0x040b700000041838ULL, 0x00000076643c723cULL, 0x080b70000004183cULL,
0x000000765c5c723cULL, 0x000b620000041878ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030099997a10ULL, 0x000fe20007ffe0ffULL, 0x000000001fff7f8cULL, 0x0003e6000c80043fULL,
0x000000229900720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x0000000199217810ULL, 0x002fe20007ffe0ffULL,
0x00005900191f7a24ULL, 0x010fe400078e02ffULL, 0x0000010099647824ULL, 0x020fe200078e0217ULL,
0x000000222100720cULL, 0x000fe20003f06070ULL, 0x000000801f207824ULL, 0x000fe400078e00ffULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x00000060641f7812ULL, 0x000fc600078ec0ffULL,
0x0000640020207625ULL, 0x000fc800078e0021ULL, 0x0000000116777824ULL, 0x000fe400078e021fULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff727819ULL, 0x100fe40000011600ULL,
0x00000064981f7217ULL, 0x000fe40007800000ULL, 0x0000000472667810ULL, 0x000fe40007ffe0ffULL,
0x0000001f641f7210ULL, 0x000fe40007ffe1ffULL, 0x00000008726a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000166647824ULL, 0x100fe200078e0200ULL, 0x0000000c72707810ULL, 0x000fe20007ffe0ffULL,
0x0000000866757824ULL, 0x000fe200078e00ffULL, 0x000000201f1f7817ULL, 0x000fe20003800000ULL,
0x000000016a657824ULL, 0x000fe200078e0200ULL, 0x0000001472767810ULL, 0x000fe20007ffe0ffULL,
0x000000086a687824ULL, 0x000fe200078e00ffULL, 0xfffffff875757812ULL, 0x000fe200078ee264ULL,
0x0000000170677824ULL, 0x000fe200078e0200ULL, 0x0000001f6600720cULL, 0x080fe20003f86070ULL,
0x00000008706c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8687d7812ULL, 0x000fe200078ee265ULL,
0x000000809d647824ULL, 0x000fe200078e00ffULL, 0x000000ff00657202ULL, 0x000fe20000000f00ULL,
0x0000000166697824ULL, 0x000fe200078e0277ULL, 0xfffffff86c7f7812ULL, 0x000fe200078ee267ULL,
0x0000000172677824ULL, 0x000fe200078e0277ULL, 0x0000008013647812ULL, 0x000fe200078ef864ULL,
0x00000001766d7824ULL, 0x000fe200078e0200ULL, 0x0000001072747810ULL, 0x000fe20007ffe0ffULL,
0x00000008767a7824ULL, 0x000fe200078e00ffULL, 0x0000001f7000720cULL, 0x080fe20003f46070ULL,
0x0000010067667825ULL, 0x000fe200078e0064ULL, 0x0000001f6a00720cULL, 0x000fc40003f66070ULL,
0xfffffff87a877812ULL, 0x000fe200078ee26dULL, 0x0000010069687825ULL, 0x000fe200078e0064ULL,
0x00000066206c7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f7200720cULL, 0x000fe20003fa6070ULL,
0x000020009d667824ULL, 0x000fe200078e00ffULL, 0x00000068206e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001216d7824ULL, 0x040fe400000e0667ULL, 0x000000016a677824ULL, 0x000fe200078e0277ULL,
0x0000200066717812ULL, 0x000fe200078ec0ffULL, 0x00000001216f7824ULL, 0x000fe200008e0669ULL,
0x0000007770697210ULL, 0x000fe20007ffe0ffULL, 0x0000000172687824ULL, 0x100fe200078e0200ULL,
0x0000001f7400720cULL, 0x040fe20003f26070ULL, 0x00000001746b7824ULL, 0x000fc400078e0200ULL,
0x0000000874787824ULL, 0x000fe200078e00ffULL, 0x0000000768737812ULL, 0x000fe200078ec0ffULL,
0x0000010067667825ULL, 0x000fc600078e0064ULL, 0xfffffff878857812ULL, 0x000fe200078ee26bULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x0000006620707210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff873737812ULL, 0x000fe200078ef800ULL, 0x00000001746b7824ULL, 0x000fe200078e0277ULL,
0x0000006820687210ULL, 0x000fe20007fde0ffULL, 0x0000400018747824ULL, 0x000fe200078e0271ULL,
0x0000001c72787810ULL, 0x000fe20007ffe0ffULL, 0x000001006b6a7825ULL, 0x000fc600078e0064ULL,
0x0001600074747810ULL, 0x000fe20007ffe0ffULL, 0x0000000121717824ULL, 0x040fe200000e0667ULL,
0x0000001f7600720cULL, 0x040fe20003f06070ULL, 0x0000000176677824ULL, 0x000fe200078e0277ULL,
0x0000001872767810ULL, 0x000fe20007ffe0ffULL, 0x0000000121697824ULL, 0x000fe200030e0669ULL,
0x0000006a206a7210ULL, 0x000fe20007fde0ffULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0x0000007487877211ULL, 0x000fc600078e20ffULL, 0x0000001073797824ULL, 0x100fe400078e0274ULL,
0x00000001216b7824ULL, 0x000fe200030e066bULL, 0x0000006620727210ULL, 0x000fe20007fde0ffULL,
0x00000010757b7824ULL, 0x100fe200078e0274ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c797faeULL, 0x0003e2000e901c46ULL, 0x0000000176757824ULL, 0x040fe200078e0277ULL,
0x0000006721737210ULL, 0x000fe200037fe4ffULL, 0x000000107d7d7824ULL, 0x000fe200078e0274ULL,
0x000000006e7b7faeULL, 0x0005e2000e101c46ULL, 0x0000010075667825ULL, 0x000fe200078e0064ULL,
0x0000001f7600720cULL, 0x000fc40003fa6070ULL, 0x0000001f7800720cULL, 0x040fe20003f86070ULL,
0x00000001781f7824ULL, 0x000fe200078e0277ULL, 0x0000006620667210ULL, 0x000fe20007fde0ffULL,
0x0000000876757824ULL, 0x040fe200078e00ffULL, 0x00000000707d7faeULL, 0x0005e2000d901c46ULL,
0x00000001766c7824ULL, 0x102fe400078e0200ULL, 0x00000001786d7824ULL, 0x040fe400078e0200ULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x000001001f647825ULL, 0x000fe200078e0064ULL,
0xfffffff8751f7812ULL, 0x000fc400078ee26cULL, 0xfffffff8786d7812ULL, 0x000fe200078ee26dULL,
0x0000000121677824ULL, 0x000fe200030e0667ULL, 0x0000006420207210ULL, 0x000fe20007fde0ffULL,
0x000000107f7f7824ULL, 0x100fe400078e0274ULL, 0x0000001085857824ULL, 0x100fe400078e0274ULL,
0x000000101f1f7824ULL, 0x100fe200078e0274ULL, 0x00000000687f7faeULL, 0x0005e2000d101c46ULL,
0x000000106d6d7824ULL, 0x000fe400078e0274ULL, 0x0000000121217824ULL, 0x000fe200030e0665ULL,
0x000000006a857faeULL, 0x0005e8000c901c46ULL, 0x0000000072877faeULL, 0x0005e8000c101c46ULL,
0x00000000661f7faeULL, 0x0005e8000e901c46ULL, 0x00000000206d7faeULL, 0x0005e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000400677811ULL, 0x040fe200078fe8ffULL,
0x000000809d727824ULL, 0x000fe200078e00ffULL, 0x0000000800697811ULL, 0x000fc400078fe8ffULL,
0x00000010006d7811ULL, 0x040fe200078fe8ffULL, 0x00000001671f7824ULL, 0x140fe200078e0200ULL,
0x0000000c006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000867767824ULL, 0x000fe200078e00ffULL,
0x00000014006f7811ULL, 0x040fe200078fe8ffULL, 0x0000000169647824ULL, 0x040fe200078e0200ULL,
0x0000001800717811ULL, 0x000fe200078fe8ffULL, 0x0000000869657824ULL, 0x000fe200078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee21fULL, 0x000000086d737824ULL, 0x000fe200078e00ffULL,
0x0000008013727812ULL, 0x000fe200078ef872ULL, 0x000000016b1f7824ULL, 0x000fe200078e0200ULL,
0xfffffff865787812ULL, 0x000fe200078ee264ULL, 0x000000086b7a7824ULL, 0x000fe200078e00ffULL,
0x000000006d647210ULL, 0x080fe20007ffe0ffULL, 0x000000016f657824ULL, 0x000fe200078e0200ULL,
0x000000776b6b7210ULL, 0x080fe20007ffe0ffULL, 0x000000086f7e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8737c7812ULL, 0x000fe200078ee264ULL, 0x0000000171667824ULL, 0x040fe200078e0200ULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee21fULL, 0x0000000871757824ULL, 0x000fe200078e00ffULL,
0x0000000000647211ULL, 0x000fe200078fe8ffULL, 0x000020009d1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee265ULL, 0x0000000167677824ULL, 0x100fe200078e0277ULL,
0x0000001c00657811ULL, 0x000fe200078fe8ffULL, 0x0000000169697824ULL, 0x100fe200078e0277ULL,
0x0000000764737812ULL, 0x000fe200078ec0ffULL, 0x000000016d6d7824ULL, 0x100fe200078e0277ULL,
0xfffffff875867812ULL, 0x000fe200078ee266ULL, 0x0000000165647824ULL, 0x100fe200078e0200ULL,
0x000020001f757812ULL, 0x000fe200078ec0ffULL, 0x0000000865797824ULL, 0x000fe200078e00ffULL,
0x0ffffff873747812ULL, 0x000fe200078ef800ULL, 0x00000001651f7824ULL, 0x000fe200078e0277ULL,
0x0000007700657211ULL, 0x000fe200078fe8ffULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0xfffffff879887812ULL, 0x000fe200078ee264ULL, 0x0000400018757824ULL, 0x000fc400078e0275ULL,
0x0000010065647825ULL, 0x000fc600078e0072ULL, 0x0001600075757810ULL, 0x000fe20007ffe0ffULL,
0x0000010067667825ULL, 0x000fe200078e0072ULL, 0x0000006420647210ULL, 0x000fc60007f1e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0072ULL, 0x0000006620667210ULL, 0x000fc60007f3e0ffULL,
0x000000016f6f7824ULL, 0x100fe200078e0277ULL, 0x0000006820687210ULL, 0x000fe20007f5e0ffULL,
0x0000000171717824ULL, 0x000fe200078e0277ULL, 0x0000007576777211ULL, 0x000fe200078e20ffULL,
0x000001006b6a7825ULL, 0x000fc800078e0072ULL, 0x000001006d6c7825ULL, 0x000fe200078e0072ULL,
0x0000006a206a7210ULL, 0x000fc60007f7e0ffULL, 0x000001006f6e7825ULL, 0x000fe200078e0072ULL,
0x0000006b216b7210ULL, 0x000fc60001ffe4ffULL, 0x0000010071707825ULL, 0x000fc800078e0072ULL,
0x000001001f727825ULL, 0x000fc800078e0072ULL, 0x0000000121657824ULL, 0x040fe200000e0665ULL,
0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000121677824ULL, 0x040fe200008e0667ULL,
0x0000006e206e7210ULL, 0x000fe20007f3e0ffULL, 0x00000010741f7824ULL, 0x000fe400078e0275ULL,
0x0000000121697824ULL, 0x000fe200010e0669ULL, 0x0000007020707210ULL, 0x000fe20007f5e0ffULL,
0x0000001078797824ULL, 0x100fe200078e0275ULL, 0x0000007220207210ULL, 0x000fe20007f7e0ffULL,
0x000000107a7b7824ULL, 0x100fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000641f7faeULL, 0x0003e2000b901c46ULL, 0x000000107c7d7824ULL, 0x000fc400078e0275ULL,
0x00000001216d7824ULL, 0x040fe200000e066dULL, 0x0000000066777faeULL, 0x0003e2000b901c46ULL,
0x000000107e7f7824ULL, 0x000fe400078e0275ULL, 0x00000001216f7824ULL, 0x040fe200008e066fULL,
0x0000000068797faeULL, 0x0003e2000b901c46ULL, 0x0000001086857824ULL, 0x000fe400078e0275ULL,
0x0000000121717824ULL, 0x000fe200010e0671ULL, 0x000000006a7b7faeULL, 0x0003e2000b901c46ULL,
0x0000001088757824ULL, 0x000fc400078e0275ULL, 0x0000000121217824ULL, 0x000fe200018e0673ULL,
0x000000006c7d7faeULL, 0x0003e8000b901c46ULL, 0x000000006e7f7faeULL, 0x0003e8000b901c46ULL,
0x0000000070857faeULL, 0x0003e8000b901c46ULL, 0x0000000020757faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x00000010801f7812ULL, 0x004fc400078ec0ffULL,
0x0000000880207812ULL, 0x000fc600078ec0ffULL, 0x000000201e1f7824ULL, 0x000fc800078e021fULL,
0x0000000120667824ULL, 0x020fe200078e021fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6680066647f8cULL, 0x0002a4000c80043fULL, 0x00000000001e7805ULL, 0x000fc40000015200ULL,
0x01e66c0066217984ULL, 0x000ee40000000800ULL, 0x8000000021ff7812ULL, 0x00cfe40007804865ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201e677210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1fULL, 0x003d09006700780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406700780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc80000011421ULL,
0x0000006720207211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000220207819ULL, 0x000fc80000001221ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000168687810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e66c0066217984ULL, 0x000ea40000000800ULL,
0x8000000021ff7812ULL, 0x004fe40007804865ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000039d1e7811ULL, 0x000fc800078ff0ffULL, 0x000000131e1f7211ULL, 0x000fca00078e38ffULL,
0x00000001821f7824ULL, 0x000fca00078e021fULL, 0x01e000001f647984ULL, 0x000ea80000000800ULL,
0x01e200001f657984ULL, 0x0006620000000800ULL, 0x0000001b6400720bULL, 0x004fe20003f1d000ULL,
0x00011d227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000667806ULL, 0x00afc800000e0100ULL,
0x000000ff6600720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000039d1e7811ULL, 0x000fe400078ff0ffULL, 0x0000001b6400720bULL, 0x000fe40003f34000ULL,
0x0000009d1e00720cULL, 0x000fe20003f05270ULL, 0x00011cf27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000697806ULL, 0x000fc400008e0100ULL, 0x000000809d1f8824ULL, 0x000fe200078e0213ULL,
0x0000001b64138209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000182828824ULL, 0x000fca00078e021fULL, 0x01e4001382008388ULL, 0x0003e20000000800ULL,
0x000000ff6900720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001b641e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff69ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001b1e137221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x0000001300687308ULL, 0x000e640000000800ULL,
0x000000681d1d7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x000fe20000011600ULL, 0x00011c327f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0002a400000e0000ULL, 0x0000001e60607220ULL, 0x084fe40000410000ULL,
0x0000001e61617220ULL, 0x080fe40000410000ULL, 0x0000001e24247220ULL, 0x080fe40000410000ULL,
0x0000001e25257220ULL, 0x000fc40000410000ULL, 0x0000001e28287220ULL, 0x080fe40000410000ULL,
0x0000001e29297220ULL, 0x080fe40000410000ULL, 0x0000001e2c2c7220ULL, 0x080fe40000410000ULL,
0x0000001e2d2d7220ULL, 0x080fe40000410000ULL, 0x0000001e30307220ULL, 0x080fe40000410000ULL,
0x0000001e31317220ULL, 0x000fc40000410000ULL, 0x0000001e34347220ULL, 0x080fe40000410000ULL,
0x0000001e35357220ULL, 0x080fe40000410000ULL, 0x0000001e38387220ULL, 0x080fe40000410000ULL,
0x0000001e39397220ULL, 0x080fe40000410000ULL, 0x0000001e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000001e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0069ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001e7811ULL, 0x000fe200078ff0ffULL,
0x00011b227f007947ULL, 0x000fea000b800000ULL, 0x00001f1e681e7589ULL, 0x0004e400000e0000ULL,
0x0000001e62627220ULL, 0x08cfe40000410000ULL, 0x0000001e63637220ULL, 0x080fe40000410000ULL,
0x0000001e26267220ULL, 0x080fe40000410000ULL, 0x0000001e27277220ULL, 0x080fe40000410000ULL,
0x0000001e2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001e2b2b7220ULL, 0x000fc40000410000ULL,
0x0000001e2e2e7220ULL, 0x080fe40000410000ULL, 0x0000001e2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001e32327220ULL, 0x080fe40000410000ULL, 0x0000001e33337220ULL, 0x080fe40000410000ULL,
0x0000001e36367220ULL, 0x080fe40000410000ULL, 0x0000001e37377220ULL, 0x000fc40000410000ULL,
0x0000001e3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001e3b3b7220ULL, 0x080fe40000410000ULL,
0x0000001e3e3e7220ULL, 0x080fe40000410000ULL, 0x0000001e3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000069ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001e7811ULL, 0x000fe200078ff0ffULL, 0x00011a127f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e40407220ULL, 0x08cfe40000410000ULL,
0x0000001e41417220ULL, 0x080fe40000410000ULL, 0x0000001e44447220ULL, 0x080fe40000410000ULL,
0x0000001e45457220ULL, 0x080fe40000410000ULL, 0x0000001e48487220ULL, 0x080fe40000410000ULL,
0x0000001e49497220ULL, 0x000fc40000410000ULL, 0x0000001e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000001e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000001e50507220ULL, 0x080fe40000410000ULL,
0x0000001e51517220ULL, 0x080fe40000410000ULL, 0x0000001e54547220ULL, 0x080fe40000410000ULL,
0x0000001e55557220ULL, 0x000fc40000410000ULL, 0x0000001e58587220ULL, 0x080fe40000410000ULL,
0x0000001e59597220ULL, 0x080fe40000410000ULL, 0x0000001e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000001e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000069ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001e7811ULL, 0x000fe200078ff0ffULL, 0x000119127f007947ULL, 0x000fea000b800000ULL,
0x00001f1e681e7589ULL, 0x0004e400000e0000ULL, 0x0000001e42427220ULL, 0x08cfe40000410000ULL,
0x0000001e43437220ULL, 0x080fe40000410000ULL, 0x0000001e46467220ULL, 0x080fe40000410000ULL,
0x0000001e47477220ULL, 0x080fe40000410000ULL, 0x0000001e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000001e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000001e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000001e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000001e52527220ULL, 0x080fe40000410000ULL,
0x0000001e53537220ULL, 0x080fe40000410000ULL, 0x0000001e56567220ULL, 0x080fe40000410000ULL,
0x0000001e57577220ULL, 0x000fc40000410000ULL, 0x0000001e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000001e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000001e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000001e5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006966ff7212ULL, 0x000fe400078030ffULL, 0x0000001b641b7209ULL, 0x000fd60007810000ULL,
0x8000001b64640221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b64640820ULL, 0x000fc80000410000ULL,
0x0000006400120308ULL, 0x000e640000000800ULL, 0x0000001265650220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001d651d7221ULL, 0x000fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000010ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x000117727f007947ULL, 0x000fea000b800000ULL,
0x00001f130e117589ULL, 0x0002a400000e0000ULL, 0x00000008131e7810ULL, 0x000fe20007ffe0ffULL,
0x000117c27f007947ULL, 0x000fea000b800000ULL, 0x00000010130f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1e0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x00000018131e7810ULL, 0x008fe20007ffe0ffULL, 0x000118527f007947ULL, 0x000fea000b800000ULL,
0x00001f1e0e0e7589ULL, 0x0022e400000e0000ULL, 0x000000039d137811ULL, 0x000fe200078ff0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000170001c1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0001200013137811ULL, 0x000fc400078e60ffULL,
0x0000001c0b6c7211ULL, 0x000fe200078e20ffULL, 0x000000100a707824ULL, 0x100fe400078e021cULL,
0x000000100d0d7824ULL, 0x100fe400078e0213ULL, 0x000000100c0c7824ULL, 0x000fe400078e0213ULL,
0x0000001009687824ULL, 0x000fe200078e021cULL, 0x000000000d74783bULL, 0x0002e80000000200ULL,
0x000000000c64783bULL, 0x0002a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001174747231ULL, 0x08cfe400003400ffULL, 0x0000001176767231ULL, 0x000fc400003400ffULL,
0x0000001075757231ULL, 0x080fe400003400ffULL, 0x0000001077777231ULL, 0x000fe400003400ffULL,
0x0000000f64647231ULL, 0x080fe400003400ffULL, 0x0000000f66667231ULL, 0x000fe400003400ffULL,
0x0000000e65657231ULL, 0x080fe400003400ffULL, 0x0000000e67677231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001008087824ULL, 0x100fe200078e021cULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x0000001006067824ULL, 0x000fe200078e0213ULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x00000010050c7824ULL, 0x102fe200078e021cULL,
0x000000006c6c783bULL, 0x000fe20000004200ULL, 0x00000010040d7824ULL, 0x000fc400078e021cULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0x000000000808783bULL, 0x000e680000004200ULL,
0x000000006868783bULL, 0x000ee40000004200ULL, 0x000000707460723cULL, 0x048f700000041860ULL,
0x000000087438723cULL, 0x082f700000041838ULL, 0x000000086458723cULL, 0x004b6e0000041858ULL,
0x0000001007087824ULL, 0x020fe200078e0213ULL, 0x0000000a743c723cULL, 0x080f62000004183cULL,
0x000000000604783bULL, 0x000e6e0000000200ULL, 0x0000000a645c723cULL, 0x000b64000004185cULL,
0x000000000808783bULL, 0x020eac0000000200ULL, 0x000000727424723cULL, 0x040b700000041824ULL,
0x0000006c7428723cULL, 0x040b700000041828ULL, 0x0000006e742c723cULL, 0x040b70000004182cULL,
0x000000687430723cULL, 0x040b700000041830ULL, 0x0000006a7434723cULL, 0x000b700000041834ULL,
0x000000706440723cULL, 0x040b700000041840ULL, 0x000000726444723cULL, 0x040b700000041844ULL,
0x0000006c6448723cULL, 0x040b700000041848ULL, 0x0000006e644c723cULL, 0x040b70000004184cULL,
0x000000686450723cULL, 0x040b700000041850ULL, 0x0000006a6454723cULL, 0x000b620000041854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x0000001108087231ULL, 0x086fe400003400ffULL, 0x000000110a0a7231ULL, 0x000fc400003400ffULL,
0x0000001009097231ULL, 0x080fe400003400ffULL, 0x000000100b0b7231ULL, 0x000fe400003400ffULL,
0x0000000f04047231ULL, 0x080fe400003400ffULL, 0x0000000f06067231ULL, 0x000fe400003400ffULL,
0x0000000e05057231ULL, 0x080fe400003400ffULL, 0x0000000e07077231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000001002027824ULL, 0x000fe200078e021cULL,
0x000000000c64783bULL, 0x020e680000004200ULL, 0x000000000d68783bULL, 0x000ea80000004200ULL,
0x00000000036c783bULL, 0x000ee80000004200ULL, 0x000000000270783bULL, 0x0002a40000004200ULL,
0x00000002ff027819ULL, 0x002fc8000001169dULL, 0x0001e6a002027811ULL, 0x000fe200078e18ffULL,
0x000000640860723cULL, 0x040b700000041860ULL, 0x000000660824723cULL, 0x040b700000041824ULL,
0x000000680828723cULL, 0x044b700000041828ULL, 0x0000006a082c723cULL, 0x040b70000004182cULL,
0x0000006c0830723cULL, 0x048b700000041830ULL, 0x0000006e0834723cULL, 0x040b700000041834ULL,
0x000000700838723cULL, 0x040b700000041838ULL, 0x00000072083c723cULL, 0x000b70000004183cULL,
0x000000640440723cULL, 0x040b700000041840ULL, 0x000000660444723cULL, 0x040b700000041844ULL,
0x000000680448723cULL, 0x040b700000041848ULL, 0x0000006a044c723cULL, 0x040b70000004184cULL,
0x0000006c0450723cULL, 0x040b700000041850ULL, 0x0000006e0454723cULL, 0x040b700000041854ULL,
0x000000700458723cULL, 0x040b700000041858ULL, 0x00000072045c723cULL, 0x000b62000004185cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000229900720cULL, 0x000fe20003f06070ULL,
0x0000000002ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff816000007947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x020e640000002500ULL,
0x000000220500720cULL, 0x002fda0003f06070ULL, 0x0000057000000947ULL, 0x000fea0003800000ULL,
0x018000001d007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e001dULL,
0x00009f8000087802ULL, 0x000fc40000000f00ULL, 0x0001161000007944ULL, 0x010fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001d00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc8000000001dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011603ULL,
0x00000018030d7811ULL, 0x040fe400078ff0ffULL, 0x0000000803097811ULL, 0x040fe200078ff0ffULL,
0x00001f0700027589ULL, 0x008e6200000e0000ULL, 0x00000010030b7811ULL, 0x000fc600078ff0ffULL,
0x00001f0d00067589ULL, 0x000ea800000e0000ULL, 0x00001f0900037589ULL, 0x000ee800000e0000ULL,
0x00001f0b00047589ULL, 0x000ea200000e0000ULL, 0x0000006002607220ULL, 0x042fe40000410000ULL,
0x0000006102617220ULL, 0x000fc40000410000ULL, 0x0000002402247220ULL, 0x040fe40000410000ULL,
0x0000002502257220ULL, 0x040fe40000410000ULL, 0x0000002802287220ULL, 0x040fe40000410000ULL,
0x0000002902297220ULL, 0x040fe40000410000ULL, 0x0000002c022c7220ULL, 0x040fe40000410000ULL,
0x0000002d022d7220ULL, 0x000fc40000410000ULL, 0x0000003002307220ULL, 0x040fe40000410000ULL,
0x0000003102317220ULL, 0x040fe40000410000ULL, 0x0000003402347220ULL, 0x040fe40000410000ULL,
0x0000003502357220ULL, 0x040fe40000410000ULL, 0x0000003802387220ULL, 0x040fe40000410000ULL,
0x0000003902397220ULL, 0x000fc40000410000ULL, 0x0000003c023c7220ULL, 0x040fe40000410000ULL,
0x0000003d023d7220ULL, 0x000fe40000410000ULL, 0x0000004206427220ULL, 0x044fe40000410000ULL,
0x0000004306437220ULL, 0x040fe40000410000ULL, 0x0000004606467220ULL, 0x040fe40000410000ULL,
0x0000004706477220ULL, 0x000fc40000410000ULL, 0x0000004a064a7220ULL, 0x040fe40000410000ULL,
0x0000004b064b7220ULL, 0x040fe40000410000ULL, 0x0000004e064e7220ULL, 0x040fe40000410000ULL,
0x0000004f064f7220ULL, 0x040fe40000410000ULL, 0x0000005206527220ULL, 0x040fe40000410000ULL,
0x0000005306537220ULL, 0x000fc40000410000ULL, 0x0000005606567220ULL, 0x040fe40000410000ULL,
0x0000005706577220ULL, 0x040fe40000410000ULL, 0x0000005a065a7220ULL, 0x040fe40000410000ULL,
0x0000005b065b7220ULL, 0x040fe40000410000ULL, 0x0000005e065e7220ULL, 0x040fe40000410000ULL,
0x0000005f065f7220ULL, 0x000fc40000410000ULL, 0x0000000362627220ULL, 0x088fe40000410000ULL,
0x0000000363637220ULL, 0x080fe40000410000ULL, 0x0000000326267220ULL, 0x080fe40000410000ULL,
0x0000000327277220ULL, 0x080fe40000410000ULL, 0x000000032a2a7220ULL, 0x080fe40000410000ULL,
0x000000032b2b7220ULL, 0x000fc40000410000ULL, 0x000000032e2e7220ULL, 0x080fe40000410000ULL,
0x000000032f2f7220ULL, 0x080fe40000410000ULL, 0x0000000332327220ULL, 0x080fe40000410000ULL,
0x0000000333337220ULL, 0x080fe40000410000ULL, 0x0000000336367220ULL, 0x080fe40000410000ULL,
0x0000000337377220ULL, 0x000fc40000410000ULL, 0x000000033a3a7220ULL, 0x080fe40000410000ULL,
0x000000033b3b7220ULL, 0x080fe40000410000ULL, 0x000000033e3e7220ULL, 0x080fe40000410000ULL,
0x000000033f3f7220ULL, 0x000fe40000410000ULL, 0x0000000440407220ULL, 0x080fe40000410000ULL,
0x0000000441417220ULL, 0x000fc40000410000ULL, 0x0000000444447220ULL, 0x080fe40000410000ULL,
0x0000000445457220ULL, 0x080fe40000410000ULL, 0x0000000448487220ULL, 0x080fe40000410000ULL,
0x0000000449497220ULL, 0x080fe40000410000ULL, 0x000000044c4c7220ULL, 0x080fe40000410000ULL,
0x000000044d4d7220ULL, 0x000fc40000410000ULL, 0x0000000450507220ULL, 0x080fe40000410000ULL,
0x0000000451517220ULL, 0x080fe40000410000ULL, 0x0000000454547220ULL, 0x080fe40000410000ULL,
0x0000000455557220ULL, 0x080fe40000410000ULL, 0x0000000458587220ULL, 0x080fe40000410000ULL,
0x0000000459597220ULL, 0x000fc40000410000ULL, 0x000000045c5c7220ULL, 0x080fe40000410000ULL,
0x000000045d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000262726723eULL, 0x000fe400000010ffULL, 0x0000002c2d08723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2a723eULL, 0x000fc400000010ffULL,
0x000000242506723eULL, 0x000fe400000010ffULL, 0x000000282907723eULL, 0x000fe400000010ffULL,
0x0000002e2f2e723eULL, 0x000fe400000010ffULL, 0x000000606104723eULL, 0x000fe400000010ffULL,
0x000000303109723eULL, 0x000fe400000010ffULL, 0x00000034350a723eULL, 0x000fc400000010ffULL,
0x00000002ff1a7819ULL, 0x002fe40000011600ULL, 0x00000008002d7811ULL, 0x000fe400078ff0ffULL,
0x000000011a027810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1c7824ULL, 0x040fe200078e00ffULL,
0x000000031a1f7819ULL, 0x040fe200000006ffULL, 0x000000081a237824ULL, 0x040fe200078e00ffULL,
0x000000021a037810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1e7824ULL, 0x040fe200078e00ffULL,
0x000000031a167810ULL, 0x040fe20007ffe0ffULL, 0x000000081a277824ULL, 0x040fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee202ULL, 0x000000081a2b7824ULL, 0x040fe200078e00ffULL,
0x000000041a197810ULL, 0x010fc40007ffe0ffULL, 0x000000051a027810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81c217812ULL, 0x000fe400078ee203ULL, 0x000000061a037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823237812ULL, 0x000fe400078ee216ULL, 0xfffffff81e257812ULL, 0x000fe200078ee219ULL,
0x000000081a197824ULL, 0x040fe200078e00ffULL, 0xffffffff1a167810ULL, 0x000fc40007ffe0ffULL,
0xfffffff827277812ULL, 0x000fe200078ee202ULL, 0x000000082d027824ULL, 0x000fe200078e00ffULL,
0xfffffff81c297812ULL, 0x000fe200078ee203ULL, 0x0000200015037824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee216ULL, 0x0000000400167824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe400078ee21aULL, 0xfffffff8022d7812ULL, 0x000fe200078ee22dULL,
0x0000100018027824ULL, 0x000fe200078e0203ULL, 0x0000000c16167812ULL, 0x000fc400078ec0ffULL,
0x00000010002f7811ULL, 0x040fe200078ff0ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x000000022b2b7211ULL, 0x000fe200078e20ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x00000038390b723eULL, 0x000fe200000010ffULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x0000003c3d0c723eULL, 0x000fe200000010ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x0000001800317811ULL, 0x000fe200078ff0ffULL, 0x0000001025257824ULL, 0x000fe200078e0202ULL,
0x000000626362723eULL, 0x000fe200000010ffULL, 0x0000000119197824ULL, 0x000fe200078e0216ULL,
0x00000003311c7819ULL, 0x000fe200000006ffULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x000000323332723eULL, 0x000fe200000010ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000000419007388ULL, 0x000fe20000000800ULL, 0x00000001161f7824ULL, 0x040fe200078e021fULL,
0x000000363736723eULL, 0x000fe200000010ffULL, 0x000000082f1a7824ULL, 0x000fe200078e00ffULL,
0x0000002916297210ULL, 0x040fe20007ffe0ffULL, 0x0000000116217824ULL, 0x040fe200078e0221ULL,
0x000000061f007388ULL, 0x0003e20000000800ULL, 0x0000000116237824ULL, 0x000fe200078e0223ULL,
0xfffffff81a2f7812ULL, 0x000fe200078ee22fULL, 0x000000102d2d7824ULL, 0x100fe200078e0202ULL,
0x0000000721007388ULL, 0x000fe20000000800ULL, 0x0000000116257824ULL, 0x040fe200078e0225ULL,
0x0000003a3b3a723eULL, 0x000fe200000010ffULL, 0x0000000116277824ULL, 0x040fe200078e0227ULL,
0x0000000823007388ULL, 0x000fe20000000800ULL, 0x00000001162b7824ULL, 0x040fe200078e022bULL,
0x0000003e3f3e723eULL, 0x000fe200000010ffULL, 0x00000001162d7824ULL, 0x000fe200078e022dULL,
0x0000000925007388ULL, 0x000fe20000000800ULL, 0x000000102f2f7824ULL, 0x100fe200078e0202ULL,
0xfffffff81c317812ULL, 0x000fe200078ee231ULL, 0x000000ff00067306ULL, 0x002fe20000205400ULL,
0x0000000a27007388ULL, 0x0003e20000000800ULL, 0x000000404140723eULL, 0x000fe200000010ffULL,
0x00000001162f7824ULL, 0x040fe200078e022fULL, 0x000000444544723eULL, 0x000fe200000010ffULL,
0x0000000b29007388ULL, 0x000fe20000000800ULL, 0x000000484948723eULL, 0x000fe200000010ffULL,
0x0000001031317824ULL, 0x000fe200078e0202ULL, 0x0000004c4d4c723eULL, 0x000fe200000010ffULL,
0x0000000c2b007388ULL, 0x000fe20000000800ULL, 0x000000505150723eULL, 0x000fe200000010ffULL,
0x0000000116167824ULL, 0x000fe200078e0231ULL, 0x000000545554723eULL, 0x000fe200000010ffULL,
0x000000622d007388ULL, 0x000fe20000000800ULL, 0x000000585958723eULL, 0x000fe200000010ffULL,
0x00000001170a7824ULL, 0x002fe200078e0200ULL, 0x0000005c5d5c723eULL, 0x000fe200000010ffULL,
0x000400261f007388ULL, 0x000fe20000000800ULL, 0x00000042430d723eULL, 0x000fe200000010ffULL,
0x000000100a097824ULL, 0x000fe200078e0203ULL, 0x00000046470e723eULL, 0x000fe200000010ffULL,
0x0004002a21007388ULL, 0x000fe20000000800ULL, 0x0000004a4b0f723eULL, 0x000fe200000010ffULL,
0x000000ff00077306ULL, 0x000e620000209400ULL, 0x0000004e4f10723eULL, 0x000fe200000010ffULL,
0x0004002e23007388ULL, 0x000fe20000000800ULL, 0x000000525311723eULL, 0x000fe200000010ffULL,
0x00000300ff1c7624ULL, 0x000fe200078e00ffULL, 0x000000565712723eULL, 0x000fe200000010ffULL,
0x0004003225007388ULL, 0x000fe20000000800ULL, 0x0000005a5b13723eULL, 0x000fe200000010ffULL,
0x000000ff00047306ULL, 0x000ea2000020d400ULL, 0x0000005e5f14723eULL, 0x000fe200000010ffULL,
0x0004003627007388ULL, 0x000fe80000000800ULL, 0x0004003a29007388ULL, 0x000fe20000000800ULL,
0x000000060700720bULL, 0x002fc60003f1d000ULL, 0x0004003e2b007388ULL, 0x000fe80000000800ULL,
0x000000402f007388ULL, 0x000fe80000000800ULL, 0x000800441f007388ULL, 0x000fe40000000800ULL,
0x0000000104040812ULL, 0x004fc400078efcffULL, 0x0008004821007388ULL, 0x000fe20000000800ULL,
0x000000011c00780cULL, 0x000fe40003f05270ULL, 0x000000040408723eULL, 0x000fe200000010ffULL,
0x0008004c23007388ULL, 0x000fe80000000800ULL, 0x0008005025007388ULL, 0x000fe80000000800ULL,
0x0008005427007388ULL, 0x000fe80000000800ULL, 0x0008005829007388ULL, 0x000fe80000000800ULL,
0x0008005c2b007388ULL, 0x000fe80000000800ULL, 0x0000000d16007388ULL, 0x000fe80000000800ULL,
0x000c000e1f007388ULL, 0x000fe80000000800ULL, 0x000c000f21007388ULL, 0x000fe80000000800ULL,
0x000c001023007388ULL, 0x000fe80000000800ULL, 0x000c001125007388ULL, 0x000fe80000000800ULL,
0x000c001227007388ULL, 0x000fe80000000800ULL, 0x000c001329007388ULL, 0x000fe80000000800ULL,
0x000c00142b007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000092c7984ULL, 0x000e680000000c00ULL, 0x0004000009207984ULL, 0x000ea80000000c00ULL,
0x0008000009107984ULL, 0x000ee80000000c00ULL, 0x000c000009287984ULL, 0x000ee80000000c00ULL,
0x00100000090c7984ULL, 0x000ee80000000c00ULL, 0x0014000009307984ULL, 0x000ee80000000c00ULL,
0x0018000009247984ULL, 0x000ee80000000c00ULL, 0x001c000009347984ULL, 0x000ee20000000c00ULL,
0x3f803f80082f7831ULL, 0x002fc4000020002fULL, 0x3f803f80082e7831ULL, 0x040fe4000020002eULL,
0x3f803f80082d7831ULL, 0x040fe4000020002dULL, 0x3f803f80082c7831ULL, 0x040fe4000020002cULL,
0x3f803f8008237831ULL, 0x044fe40000200023ULL, 0x3f803f8008227831ULL, 0x040fe40000200022ULL,
0x3f803f8008217831ULL, 0x000fc40000200021ULL, 0x3f803f8008207831ULL, 0x040fe40000200020ULL,
0x3f803f8008137831ULL, 0x048fe40000200013ULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x3f803f8008107831ULL, 0x040fe40000200010ULL,
0x3f803f80082b7831ULL, 0x000fc4000020002bULL, 0x3f803f80082a7831ULL, 0x040fe4000020002aULL,
0x3f803f8008297831ULL, 0x040fe40000200029ULL, 0x3f803f8008287831ULL, 0x000fe40000200028ULL,
0x3f803f802f2f7831ULL, 0x000fe4000020000fULL, 0x3f803f802e2e7831ULL, 0x000fe4000020000eULL,
0x3f803f802d2d7831ULL, 0x000fc4000020000dULL, 0x3f803f802c2c7831ULL, 0x000fe4000020000cULL,
0x3f803f8023237831ULL, 0x000fe40000200033ULL, 0x3f803f8022227831ULL, 0x000fe20000200032ULL,
0x0000002c09007388ULL, 0x000fe20000000c00ULL, 0x3f803f8021217831ULL, 0x000fe40000200031ULL,
0x3f803f8020207831ULL, 0x000fe40000200030ULL, 0x3f803f8013137831ULL, 0x000fc40000200027ULL,
0x3f803f8012127831ULL, 0x000fe20000200026ULL, 0x0004002009007388ULL, 0x000fe20000000c00ULL,
0x3f803f8011117831ULL, 0x000fe40000200025ULL, 0x3f803f8010107831ULL, 0x000fe40000200024ULL,
0x3f803f802b2b7831ULL, 0x000fe40000200037ULL, 0x3f803f802a2a7831ULL, 0x000fe20000200036ULL,
0x0008001009007388ULL, 0x000fe20000000c00ULL, 0x3f803f8029297831ULL, 0x000fc40000200035ULL,
0x3f803f8028287831ULL, 0x000fca0000200034ULL, 0x000c002809007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000039a000008947ULL, 0x000fea0003800000ULL,
0x00000400ff067624ULL, 0x000fe200078e00ffULL, 0x0000000000147919ULL, 0x000e620000002600ULL,
0x000000400a0d7810ULL, 0x000fc40007ffe0ffULL, 0x00006c0006067a24ULL, 0x000fe200078e02ffULL,
0x00000000000b7919ULL, 0x000e620000002700ULL, 0x000000800a0f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000f06077811ULL, 0x040fe200078e10ffULL, 0x0000030006067a24ULL, 0x000fe200078e02ffULL,
0x0000000009207984ULL, 0x000ea40000000c00ULL, 0xfffffff0074f7812ULL, 0x000fe400078ec0ffULL,
0x0004000009247984ULL, 0x000ee60000000c00ULL, 0x0000008006197824ULL, 0x040fe200078e024fULL,
0x0008000009287984ULL, 0x000ea80000000c00ULL, 0x0000001906067211ULL, 0x000fe200078e38ffULL,
0x000c0000092c7984ULL, 0x0008a60000000c00ULL, 0x0000007f06067810ULL, 0x000fe20007ffe0ffULL,
0x000004000b147a24ULL, 0x002fc600078e0214ULL, 0xffffff8006167812ULL, 0x000fe200078ec0ffULL,
0x0000030014087a24ULL, 0x000fe200078e02ffULL, 0x000000c00a097810ULL, 0x010fe40007ffe0ffULL,
0x0000700016067a10ULL, 0x000fe20007f1e0ffULL, 0x0000000108057824ULL, 0x000fc800078e0205ULL,
0x00007100ff0c7624ULL, 0x000fe200000e06ffULL, 0x0000000605067211ULL, 0x040fe400078268ffULL,
0x0000000118ff7812ULL, 0x000fe4000780f89dULL, 0x0000000c05077211ULL, 0x000fe400008f6cffULL,
0x000070004f1f7a10ULL, 0x000fc60007f3e0ffULL, 0x0000100015067825ULL, 0x000fc800078e0006ULL,
0x00007100ff1a7624ULL, 0x000fe400008e06ffULL, 0x000000100a0a7825ULL, 0x000fc800078e0006ULL,
0x000000100d0c7825ULL, 0x000fc800078e0006ULL, 0x000000100f0e7825ULL, 0x000fc800078e0006ULL,
0x0000001009067825ULL, 0x000fe200078e0006ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001000097824ULL, 0x00cfe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x0000008005107824ULL, 0x000fe200078e00ffULL, 0x00000019ff057819ULL, 0x000fe40000011605ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fe400078ec0ffULL,
0x0000700010127a10ULL, 0x000fc40007ebe019ULL, 0x0000001f09107210ULL, 0x000fe40007a3e010ULL,
0x0000001211127210ULL, 0x000fe40007c7e009ULL, 0x0000710005097a10ULL, 0x000fe40002fec4ffULL,
0x0000001011107210ULL, 0x000fe40007fbe0ffULL, 0x0000001aff057210ULL, 0x000fe40000fe4405ULL,
0x00000009ff137210ULL, 0x000fc60001fe84ffULL, 0x000000ffff117224ULL, 0x000fca00028e0605ULL,
0x0000001b10007986ULL, 0x0003e8000c101906ULL, 0x0000001d12007986ULL, 0x0003e4000c101906ULL,
0x000000ff0000720cULL, 0x00cfe20000705670ULL, 0x000000200a007986ULL, 0x000fe2000c101d06ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x000000240c007986ULL, 0x000fe8000c101d06ULL,
0x000000280e007986ULL, 0x000fe8000c101d06ULL, 0x0000002c06007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0xffffffff1c057810ULL, 0x000fc60007ffe0ffULL,
0x0000700014067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000005060679a8ULL, 0x000ea400099ee1c6ULL, 0x000000050600720cULL, 0x004fc80003f05270ULL,
0x00000001ff097807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff057984ULL, 0x000ee40000000000ULL,
0x000000ff0500720cULL, 0x008fda0003f05270ULL, 0x000034a000008947ULL, 0x000fea0003800000ULL,
0x000000ff9d00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x004fe40000011600ULL,
0x0000001f08067211ULL, 0x040fe400078038ffULL, 0x0000007005077812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fe400078ec0ffULL, 0x0000001a08057211ULL, 0x000fe400000f3cffULL,
0x0000000609067210ULL, 0x000fc8000791e007ULL, 0x00000005ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606057981ULL, 0x000528000c1e1900ULL, 0x00008006060a7981ULL, 0x000522000c1e1900ULL,
0x000000021c00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006060c7981ULL, 0x004522000c1e1900ULL, 0x000000041c00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018006060e7981ULL, 0x004522000c1e1900ULL,
0x000000041c00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000606107981ULL, 0x006322000c1e1900ULL, 0x000000061c00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800606127981ULL, 0x002322000c1e1900ULL,
0x000000061c00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081c00780cULL, 0x002fe20003f06070ULL, 0x0003000606147981ULL, 0x000318000c1e1900ULL,
0x00038006061a0981ULL, 0x000324000c1e1900ULL, 0x000000071c067810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff097819ULL, 0x000fc80000011606ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000004f080b7211ULL, 0x040fe200078038ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x00000005001c7202ULL, 0x010fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000070000b0b7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff080d7211ULL, 0x000fe400000f3cffULL, 0x000007800b0b7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0d7a10ULL, 0x000fc400017e240dULL, 0x000003000f007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000409007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080f067810ULL, 0x040fe40007ffe0ffULL,
0x000000010f077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001c05057209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060dULL, 0xfffc8006061c7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090f067810ULL, 0x042fe40007ffe0ffULL,
0x000000020f077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000a05057209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060dULL, 0xfffd0006060a7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0f067810ULL, 0x042fe40007ffe0ffULL,
0x000000030f077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000c05057209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060dULL, 0xfffd8006060c7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f067810ULL, 0x042fe40007ffe0ffULL,
0x000000040f077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000e05057209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060dULL, 0xfffe0006060e7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0f067810ULL, 0x042fe40007ffe0ffULL,
0x000000050f077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001005057209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fc80007f3e0ffULL,
0x0000000dff077210ULL, 0x000fca0000ffe4ffULL, 0xfffe800606107981ULL, 0x000328000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f067810ULL, 0x042fe40007ffe0ffULL,
0x000000060f077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001205057209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060dULL, 0xffff000606127981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0f067810ULL, 0x042fe40007ffe0ffULL,
0x000000070f077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001405057209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060dULL, 0xffff800606147981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f067810ULL, 0x002fe40007ffe0ffULL,
0x0000001a05057209ULL, 0x000fe40007810000ULL, 0x0000030006007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000060b067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060dULL, 0x00000006061a7981ULL, 0x000326000c1e1900ULL,
0x000004000b0b7810ULL, 0x000fe40007f3e0ffULL, 0x000000080f0f7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000067824ULL, 0x006fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011600ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fca00078ec0ffULL, 0x0000000106067824ULL, 0x000fca00078e0207ULL,
0x0000000506007388ULL, 0x0103e40000000800ULL, 0x000000070000780cULL, 0x000fe20003f04070ULL,
0x0000000118147824ULL, 0x000fe200078e0208ULL, 0x00000002ff097819ULL, 0x004fe2000001169dULL,
0x0000100015057824ULL, 0x002fe200078e00ffULL, 0x0000700016067a10ULL, 0x000fe20007f3e0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000109097812ULL, 0x000fe200078ec0ffULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000002180c8824ULL, 0x140fe200078e0215ULL,
0x00007100ff077a10ULL, 0x000fe20000ffe4ffULL, 0x00000002180e8824ULL, 0x000fe200078e0215ULL,
0x00000020000f7810ULL, 0x000fe20007ffe0ffULL, 0x000000020c258824ULL, 0x000fe200078e0209ULL,
0x0000004000117810ULL, 0x040fe20007ffe0ffULL, 0x000004009d0c7824ULL, 0x000fe200078e00ffULL,
0x0000006000137810ULL, 0x000fe20007ffe0ffULL, 0x00002000140a7825ULL, 0x000fe200078e0006ULL,
0x00000080001b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x000010000c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000020e298824ULL, 0x000fe200078e0209ULL,
0x000000050a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000400018097824ULL, 0x000fe200078e0203ULL,
0x000000a0001d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000829298824ULL, 0x000fe200078e0200ULL,
0x000000c0001f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090d7824ULL, 0x000fe200078e020cULL,
0x000000e000217810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000000400537819ULL, 0x040fe200000006ffULL, 0x0000001000277824ULL, 0x000fe200078e020dULL,
0x00000001ff527819ULL, 0x000fe20000011600ULL, 0x000000100f0e7825ULL, 0x100fe200078e000aULL,
0x0000007053537812ULL, 0x000fe200078ec0ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000c52527812ULL, 0x000fe200078ec0ffULL, 0x0000001011107825ULL, 0x100fe200078e000aULL,
0x000070004f4f7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000001013127825ULL, 0x100fe200078e000aULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000000101b1a7825ULL, 0x100fe200078e000aULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000101d1c7825ULL, 0x100fe200078e000aULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000101f1e7825ULL, 0x100fe200078e000aULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000001021207825ULL, 0x000fe200078e000aULL,
0x00000000004c7805ULL, 0x000fc6000001ff00ULL, 0x00000010000c7825ULL, 0x000fe200078e000aULL,
0x00007000190b7a10ULL, 0x000fc60007f3e0ffULL, 0x0000000153167824ULL, 0x000fe400078e0252ULL,
0x00007100ff507624ULL, 0x000fe200008e06ffULL, 0x0000000b14228211ULL, 0x040fe200078238ffULL,
0x00007100ff517624ULL, 0x000fe200010e06ffULL, 0x0000004f14248211ULL, 0x040fe200078438ffULL,
0x0000000825198824ULL, 0x000fe200078e0200ULL, 0x0000005014238211ULL, 0x000fe200008f3cffULL,
0x00000000160a7984ULL, 0x0002a20000000800ULL, 0x0000030018007a0cULL, 0x000fe20003f26070ULL,
0x000000ffff4e7224ULL, 0x000fe200078e00ffULL, 0x0000005114258211ULL, 0x000fe200010f3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c277faeULL, 0x0007e2000b901c46ULL,
0x0000858019198811ULL, 0x000fe200078e20ffULL, 0x000000ffff147224ULL, 0x000fc400078e00ffULL,
0x003800000e277faeULL, 0x0009e2000b901c46ULL, 0x000000ff00167202ULL, 0x002fe20000000f00ULL,
0x000000ffff547224ULL, 0x000fe400078e00ffULL, 0x0058000010277faeULL, 0x0003e8000b901c46ULL,
0x0078000012277faeULL, 0x0003e2000b901c46ULL, 0x00000000000c7805ULL, 0x008fc6000001ff00ULL,
0x009800001a277faeULL, 0x0007e2000b901c46ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000001000108825ULL, 0x042fe200078e0022ULL, 0x0000818029238811ULL, 0x000fe200078e20ffULL,
0x00b800001c277faeULL, 0x0003e2000b901c46ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000001000128825ULL, 0x000fe400078e0024ULL, 0x00d800001e277faeULL, 0x0009e2000b901c46ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x008fc4000001ff00ULL,
0x00f8000020277faeULL, 0x0007e8000b901c46ULL, 0x0000000010198faeULL, 0x0005e2000b901c46ULL,
0x00000000001c7805ULL, 0x002fc6000001ff00ULL, 0x0000000012238faeULL, 0x0003e2000b901c46ULL,
0x00000000001e7805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000207805ULL, 0x008fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x004fe2000001ff00ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x002fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000130000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff687224ULL, 0x000fca00078e0018ULL, 0x0000000268557810ULL, 0x000fc80007ffe0ffULL,
0x0000030055007a0cULL, 0x000fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f44070ULL, 0x00000001086a7824ULL, 0x100fe200078e0255ULL,
0x00000001ff567819ULL, 0x000fe40000011655ULL, 0x0000002000597810ULL, 0x000fe20007ffe0ffULL,
0x000020006a527825ULL, 0x000fe200078e0006ULL, 0x0000000156577812ULL, 0x000fe400078ec0ffULL,
0x00000040005b7810ULL, 0x000fe20007ffe0ffULL, 0x0000080055567824ULL, 0x000fe200078e00ffULL,
0x0000000552527210ULL, 0x000fc40007f1e0ffULL, 0x00000060005d7810ULL, 0x000fe20007ffe0ffULL,
0x00000002185aa824ULL, 0x100fe200078e0215ULL, 0x0000100056567812ULL, 0x000fe200078ec0ffULL,
0x000000021858a824ULL, 0x000fe200078e0215ULL, 0x00000080005f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff537224ULL, 0x000fe200000e0653ULL, 0x000000575a6da211ULL, 0x000fe200078e08ffULL,
0x00000002586ba824ULL, 0x000fe200078e0257ULL, 0x000000a000617810ULL, 0x040fe20007ffe0ffULL,
0x0000000109577824ULL, 0x000fe200078e0256ULL, 0x000000c000637810ULL, 0x040fe20007ffe0ffULL,
0x0000001059587825ULL, 0x000fe200078e0052ULL, 0x000000e000657810ULL, 0x000fc40007ffe0ffULL,
0x0000000b6a64a211ULL, 0x000fe200078038ffULL, 0x0000001000697824ULL, 0x000fe200078e0257ULL,
0x0000004f6a66a211ULL, 0x000fe200078238ffULL, 0x0000001000567825ULL, 0x000fc600078e0052ULL,
0x000000516a67a211ULL, 0x040fe200008f3cffULL, 0x000000105b5a7825ULL, 0x100fe200078e0052ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000056697faeULL, 0x0003e6000b901c46ULL,
0x000000105d5c7825ULL, 0x100fe200078e0052ULL, 0x0038000058697faeULL, 0x0005e6000b901c46ULL,
0x000000105f5e7825ULL, 0x100fe200078e0052ULL, 0x005800005a697faeULL, 0x0007e6000b901c46ULL,
0x0000001061607825ULL, 0x100fe200078e0052ULL, 0x007800005c697faeULL, 0x0007e6000b901c46ULL,
0x0000001063627825ULL, 0x100fe200078e0052ULL, 0x009800005e697faeULL, 0x0007e6000b901c46ULL,
0x0000001065527825ULL, 0x000fe200078e0052ULL, 0x000000506a65a211ULL, 0x000fe200000f3cffULL,
0x00b8000060697faeULL, 0x0007e4000b901c46ULL, 0x000000086b6ba824ULL, 0x000fc400078e0200ULL,
0x000000086d6da824ULL, 0x000fe200078e0200ULL, 0x00d8000062697faeULL, 0x0007e2000b901c46ULL,
0x000000100064a825ULL, 0x040fe200078e0064ULL, 0x000085806b6ba811ULL, 0x000fe400078e20ffULL,
0x000081806d59a811ULL, 0x004fe200078e20ffULL, 0x000000100056a825ULL, 0x002fe200078e0066ULL,
0x00f8000052697faeULL, 0x0007e8000b901c46ULL, 0x00000000646bafaeULL, 0x0007e8000b901c46ULL,
0x000000005659afaeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004068527824ULL, 0x008fe200078e00ffULL, 0x00000001ff587819ULL, 0x100fe20000011600ULL,
0x0000000218577824ULL, 0x000fe200078e0215ULL, 0x00000002ff5c7819ULL, 0x000fe20000011600ULL,
0x0000001000537824ULL, 0x000fe200078e00ffULL, 0x0000008052527812ULL, 0x000fc400078ec0ffULL,
0x000000035c617819ULL, 0x040fe200000006ffULL, 0x000000085c637824ULL, 0x000fe200078e00ffULL,
0x0000007053537812ULL, 0x000fe200078ec0ffULL, 0x0000010057567824ULL, 0x000fe200078e0052ULL,
0x0000000c58527812ULL, 0x000fe200078ec0ffULL, 0x000000085c5b7824ULL, 0x040fe200078e00ffULL,
0x000000025c587810ULL, 0x040fe20007ffe0ffULL, 0x000000085c657824ULL, 0x000fe200078e00ffULL,
0x0000005652577210ULL, 0x000fe20007ffe053ULL, 0x000000085c677824ULL, 0x040fe200078e00ffULL,
0x000000015c567810ULL, 0x040fe20007ffe0ffULL, 0x000000085c6f7824ULL, 0x040fe200078e00ffULL,
0x000000085c6c7810ULL, 0x040fe20007ffe0ffULL, 0x000000085c6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee256ULL, 0x0000080068567824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0081800057597984ULL, 0x000e620000000800ULL,
0x0000100056567812ULL, 0x000fe400078ec0ffULL, 0xfffffff863637812ULL, 0x000fe200078ee258ULL,
0x00858000575f7984ULL, 0x0004e20000000800ULL, 0x0000000400587824ULL, 0x000fe200078e00ffULL,
0x0000018009567810ULL, 0x000fe40007ffe056ULL, 0x000000035c5a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c58687812ULL, 0x000fc400078ec0ffULL, 0xfffffff85b577812ULL, 0x004fe200078ee25cULL,
0x000000086c5b7824ULL, 0x000fe200078e00ffULL, 0x000000105c6e7810ULL, 0x040fe40007ffe0ffULL,
0x000000185c707810ULL, 0x000fe20007ffe0ffULL, 0x0000001057577824ULL, 0x000fe200078e0256ULL,
0xfffffff865657812ULL, 0x000fe200078ee25aULL, 0x000000086e5d7824ULL, 0x000fe200078e00ffULL,
0x0000000370697819ULL, 0x000fe200000006ffULL, 0x0000000168577824ULL, 0x000fe200078e0257ULL,
0x000000045c607810ULL, 0x000fc40007ffe0ffULL, 0x000000055c627810ULL, 0x040fe40007ffe0ffULL,
0x00000000575e7984ULL, 0x0005220000000800ULL, 0xfffffff867677812ULL, 0x000fe400078ee260ULL,
0x000000065c607810ULL, 0x040fe40007ffe0ffULL, 0xfffffff86d6d7812ULL, 0x000fe400078ee262ULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee260ULL, 0x0000001063577824ULL, 0x004fe200078e0256ULL,
0xffffffff5c627810ULL, 0x000fc60007ffe0ffULL, 0x0000000168577824ULL, 0x000fe400078e0257ULL,
0x000000590a587221ULL, 0x002fe20000010100ULL, 0xfffffff85b597812ULL, 0x000fe400078ee26cULL,
0xfffffff85d5b7812ULL, 0x000fe200078ee26eULL, 0x3fb8aa3b58587820ULL, 0x000fe20000410000ULL,
0xfffffff8695d7812ULL, 0x000fe200078ee270ULL, 0x0000001059597824ULL, 0x100fe400078e0256ULL,
0x00000058005a7308ULL, 0x0002e20000000800ULL, 0x000000105b5b7824ULL, 0x000fc400078e0256ULL,
0x0000000168597824ULL, 0x040fe400078e0259ULL, 0x00000001685b7824ULL, 0x000fe400078e025bULL,
0x000000105d5d7824ULL, 0x100fe200078e0256ULL, 0x0000000059697984ULL, 0x0005e20000000800ULL,
0x0000001061587824ULL, 0x002fc600078e0256ULL, 0x000000005b6a7984ULL, 0x0003e20000000800ULL,
0x0000005d685d7210ULL, 0x040fe20007ffe0ffULL, 0x0000000168587824ULL, 0x000fe400078e0258ULL,
0x0000005f5a5f7220ULL, 0x008fe40000410000ULL, 0x000000005d6b7984ULL, 0x0007e20000000800ULL,
0x0000001065597824ULL, 0x004fe400078e0256ULL, 0x000000085c5b7824ULL, 0x002fe200078e00ffULL,
0x00001f5c5f607589ULL, 0x0002a200000e0000ULL, 0x0000000168597824ULL, 0x000fc400078e0259ULL,
0x00000010675a7824ULL, 0x000fe200078e0256ULL, 0x00001f6c5f617589ULL, 0x000ea200000e0000ULL,
0xfffffff85b5d7812ULL, 0x008fe200078ee262ULL, 0x000000106d5b7824ULL, 0x000fe400078e0256ULL,
0x0000000058647984ULL, 0x000fe20000000800ULL, 0x00000001685a7824ULL, 0x040fe200078e025aULL,
0x000000566f5c7211ULL, 0x002fe200078e20ffULL, 0x000000105d567824ULL, 0x000fe200078e0256ULL,
0x0000000057657984ULL, 0x000fe20000000800ULL, 0x00005410ff5d7816ULL, 0x110fe2000000005eULL,
0x00000001685b7824ULL, 0x040fe200078e025bULL, 0x00007610ff5e7816ULL, 0x000fe2000000005eULL,
0x00001f6e5f627589ULL, 0x000e6200000e0000ULL, 0x00000001685c7824ULL, 0x000fc400078e025cULL,
0x0000000168567824ULL, 0x000fe200078e0256ULL, 0x0000000059667984ULL, 0x000fe20000000800ULL,
0x000000545f547221ULL, 0x000fc60000010000ULL, 0x00001f705f637589ULL, 0x000ee200000e0000ULL,
0x000000605d4e7223ULL, 0x084fe2000001004eULL, 0x00005410ff5d7816ULL, 0x000fe20000000069ULL,
0x000000605e4d7223ULL, 0x000fe2000001004dULL, 0x000000005a677984ULL, 0x000ea20000000800ULL,
0x00005410ff5e7816ULL, 0x000fe4000000006aULL, 0x000000615d167223ULL, 0x080fe20000010016ULL,
0x00007610ff5d7816ULL, 0x000fe20000000069ULL, 0x000000005b687984ULL, 0x000f280000000800ULL,
0x000000615d447223ULL, 0x000fe20000010044ULL, 0x00007610ff5d7816ULL, 0x000fe2000000006aULL,
0x000000005c5f7984ULL, 0x000fe20000000800ULL, 0x000000625e237223ULL, 0x002fe20000010023ULL,
0x00005410ff5e7816ULL, 0x000fc4000000006bULL, 0x000000625d3c7223ULL, 0x000fe2000001003cULL,
0x00007610ff5d7816ULL, 0x000fe2000000006bULL, 0x0000000056697984ULL, 0x000e620000000800ULL,
0x000000635e217223ULL, 0x008fc60000010021ULL, 0x00040000586a7984ULL, 0x000ee20000000800ULL,
0x000000635d347223ULL, 0x000fe20000010034ULL, 0x00005410ff5d7816ULL, 0x100fe40000000064ULL,
0x00040000576b7984ULL, 0x000ee20000000800ULL, 0x00007610ff5e7816ULL, 0x000fe40000000064ULL,
0x000000605d4c7223ULL, 0x080fe2000001004cULL, 0x00005410ff5d7816ULL, 0x000fe20000000065ULL,
0x0004000059647984ULL, 0x000ee20000000800ULL, 0x000000605e4b7223ULL, 0x000fe2000001004bULL,
0x00007610ff5e7816ULL, 0x000fc40000000065ULL, 0x000000605d4a7223ULL, 0x080fe2000001004aULL,
0x00005410ff5d7816ULL, 0x100fe20000000066ULL, 0x000400005a657984ULL, 0x000ee20000000800ULL,
0x000000605e497223ULL, 0x080fe20000010049ULL, 0x00007610ff5e7816ULL, 0x000fe40000000066ULL,
0x000000605d487223ULL, 0x080fe20000010048ULL, 0x00005410ff5d7816ULL, 0x004fe20000000067ULL,
0x000400005b667984ULL, 0x000ea20000000800ULL, 0x000000605e477223ULL, 0x000fe20000010047ULL,
0x00005410ff5e7816ULL, 0x010fc40000000068ULL, 0x000000605d2e7223ULL, 0x080fe2000001002eULL,
0x00007610ff5d7816ULL, 0x000fe40000000067ULL, 0x000400005c677984ULL, 0x000f220000000800ULL,
0x000000605e2d7223ULL, 0x080fe4000001002dULL, 0x000000605d0e7223ULL, 0x000fe2000001000eULL,
0x00007610ff5d7816ULL, 0x000fe40000000068ULL, 0x0004000056687984ULL, 0x000ea20000000800ULL,
0x00005410ff5e7816ULL, 0x002fc40000000069ULL, 0x000000605d1a7223ULL, 0x080fe2000001001aULL,
0x00005410ff5d7816ULL, 0x000fe4000000005fULL, 0x000000605e2b7223ULL, 0x080fe2000001002bULL,
0x00007610ff5e7816ULL, 0x000fe40000000069ULL, 0x000000605d2c7223ULL, 0x080fe2000001002cULL,
0x00007610ff5d7816ULL, 0x000fe2000000005fULL, 0x000c000058697984ULL, 0x000fe20000000800ULL,
0x000000605e457223ULL, 0x000fc60000010045ULL, 0x00080000585f7984ULL, 0x0003220000000800ULL,
0x000000605d467223ULL, 0x000fe20000010046ULL, 0x00005410ff5d7816ULL, 0x008fe4000000006aULL,
0x00080000575e7984ULL, 0x000ee60000000800ULL, 0x000000615d2a7223ULL, 0x000fe2000001002aULL,
0x00007610ff587816ULL, 0x002fe2000000006aULL, 0x000800005a607984ULL, 0x000fe20000000800ULL,
0x00007610ff5d7816ULL, 0x000fc6000000006bULL, 0x0000006158437223ULL, 0x080fe20000010043ULL,
0x00005410ff587816ULL, 0x000fe2000000006bULL, 0x000000615d427223ULL, 0x080fe20000010042ULL,
0x00005410ff5d7816ULL, 0x100fe20000000064ULL, 0x000c0000576a7984ULL, 0x0002e40000000800ULL,
0x0000006158297223ULL, 0x080fe20000010029ULL, 0x00007610ff587816ULL, 0x000fe20000000064ULL,
0x000000615d287223ULL, 0x080fe20000010028ULL, 0x000c000059647984ULL, 0x000fe60000000800ULL,
0x0000006158417223ULL, 0x000fe20000010041ULL, 0x00005410ff587816ULL, 0x100fe20000000065ULL,
0x00080000595d7984ULL, 0x000ee20000000800ULL, 0x00007610ff577816ULL, 0x002fc60000000065ULL,
0x0000006158277223ULL, 0x080fe20000010027ULL, 0x00007610ff587816ULL, 0x004fe20000000066ULL,
0x0000006157407223ULL, 0x080fe20000010040ULL, 0x00005410ff577816ULL, 0x000fe20000000066ULL,
0x000800005b597984ULL, 0x000fe40000000800ULL, 0x00000061583f7223ULL, 0x080fe2000001003fULL,
0x00005410ff587816ULL, 0x110fe20000000067ULL, 0x0000006157267223ULL, 0x080fe20000010026ULL,
0x00007610ff577816ULL, 0x000fe20000000067ULL, 0x000c00005a657984ULL, 0x000e640000000800ULL,
0x0000006158257223ULL, 0x080fe20000010025ULL, 0x00007610ff587816ULL, 0x000fe20000000068ULL,
0x00000061573e7223ULL, 0x000fe2000001003eULL, 0x00005410ff577816ULL, 0x000fe20000000068ULL,
0x000800005c5a7984ULL, 0x000fe20000000800ULL, 0x000000ffff687224ULL, 0x000fc400078e0055ULL,
0x00000061583d7223ULL, 0x080fe2000001003dULL, 0x00007610ff587816ULL, 0x100fe2000000005fULL,
0x0000006157247223ULL, 0x000fe20000010024ULL, 0x00005410ff577816ULL, 0x000fe2000000005fULL,
0x000c00005b617984ULL, 0x000fe20000000800ULL, 0x0000030068007a0cULL, 0x000fe20003f06070ULL,
0x00000062583b7223ULL, 0x080fe2000001003bULL, 0x00005410ff587816ULL, 0x000fe20000000069ULL,
0x000c0000565b7984ULL, 0x000ea20000000800ULL, 0x0000006257227223ULL, 0x000fe20000010022ULL,
0x00005410ff577816ULL, 0x008fc4000000005eULL, 0x0000006358197223ULL, 0x080fe20000010019ULL,
0x00007610ff587816ULL, 0x000fe20000000069ULL, 0x000c00005c5f7984ULL, 0x000ee20000000800ULL,
0x0000006257207223ULL, 0x080fe20000010020ULL, 0x00007610ff577816ULL, 0x000fe4000000005eULL,
0x0000006358337223ULL, 0x000fe40000010033ULL, 0x0008000056587984ULL, 0x0008e20000000800ULL,
0x00000062573a7223ULL, 0x000fe2000001003aULL, 0x00005410ff577816ULL, 0x000fca000000006aULL,
0x0000006357147223ULL, 0x000fe20000010014ULL, 0x00005410ff567816ULL, 0x010fe4000000005dULL,
0x00007610ff577816ULL, 0x000fc6000000006aULL, 0x00000062561f7223ULL, 0x000fe2000001001fULL,
0x00007610ff567816ULL, 0x000fe2000000005dULL, 0x0000006357327223ULL, 0x000fe20000010032ULL,
0x00005410ff577816ULL, 0x000fc60000000060ULL, 0x0000006256397223ULL, 0x080fe20000010039ULL,
0x00005410ff567816ULL, 0x000fe20000000064ULL, 0x00000062571e7223ULL, 0x000fe2000001001eULL,
0x00007610ff577816ULL, 0x000fc60000000060ULL, 0x0000006356137223ULL, 0x080fe20000010013ULL,
0x00007610ff567816ULL, 0x000fe20000000064ULL, 0x0000006257387223ULL, 0x000fe20000010038ULL,
0x00005410ff577816ULL, 0x002fe40000000065ULL, 0x00007610ff557816ULL, 0x004fe2000000005bULL,
0x0000006356317223ULL, 0x080fe20000010031ULL, 0x00005410ff567816ULL, 0x000fe20000000059ULL,
0x0000006357127223ULL, 0x080fe20000010012ULL, 0x00007610ff577816ULL, 0x000fe20000000065ULL,
0x00000063550c7223ULL, 0x000fc4000001000cULL, 0x00000062561d7223ULL, 0x000fe2000001001dULL,
0x00007610ff567816ULL, 0x000fe20000000059ULL, 0x0000006357307223ULL, 0x000fe20000010030ULL,
0x00007610ff577816ULL, 0x000fc60000000061ULL, 0x0000006256377223ULL, 0x000fe20000010037ULL,
0x00005410ff567816ULL, 0x000fe20000000061ULL, 0x0000006357107223ULL, 0x000fe20000010010ULL,
0x00005410ff577816ULL, 0x000fc6000000005aULL, 0x0000006356117223ULL, 0x000fe20000010011ULL,
0x00005410ff567816ULL, 0x008fe2000000005fULL, 0x00000062571c7223ULL, 0x000fe2000001001cULL,
0x00007610ff577816ULL, 0x000fc6000000005aULL, 0x00000063560d7223ULL, 0x000fe2000001000dULL,
0x00007610ff567816ULL, 0x000fe2000000005fULL, 0x0000006257367223ULL, 0x000fc80000010036ULL,
0x00000063562f7223ULL, 0x000fe2000001002fULL, 0x00005410ff567816ULL, 0x000fca0000000058ULL,
0x00000062561b7223ULL, 0x000fe2000001001bULL, 0x00007610ff567816ULL, 0x000fca0000000058ULL,
0x0000006256357223ULL, 0x000fe20000010035ULL, 0x00005410ff567816ULL, 0x000fca000000005bULL,
0x00000063560f7223ULL, 0x000fe2000001000fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffed2000007947ULL, 0x000fea000383ffffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x0000008018058824ULL, 0x000fc800078e0253ULL,
0x0000000152058824ULL, 0x000fe400078e0205ULL, 0x0000000153527824ULL, 0x000fc600078e0252ULL,
0x0089805405008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0089800052007984ULL, 0x000e680000000800ULL, 0x008a000052077984ULL, 0x000ea20000000800ULL,
0x00000000ff007221ULL, 0x002fc80000010000ULL, 0x0000000700007221ULL, 0x004fca0000010000ULL,
0x0180000000067810ULL, 0x000fc80007ffe0ffULL, 0x7f80000006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0600780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0000ULL,
0x0000da0000087802ULL, 0x000fc40000000f00ULL, 0x0000db9000007944ULL, 0x000fea0003c00000ULL,
0x0000000000057202ULL, 0x008fe20000000f00ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000057308ULL, 0x000e640000001000ULL, 0xbf80000000067423ULL, 0x002fc80000000005ULL,
0x800000ff06067221ULL, 0x000fc80000010100ULL, 0x0000000605057223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000040404723eULL, 0x000fc600000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff507819ULL, 0x002fe40000011600ULL, 0x0000001000547811ULL, 0x040fe400078ff0ffULL,
0x0000001800567811ULL, 0x040fe200078ff0ffULL, 0x00001f5005077589ULL, 0x000e6200000e0000ULL,
0x0000000800527811ULL, 0x000fe200078ff0ffULL, 0x0000000850537824ULL, 0x000fe200078e00ffULL,
0x00000003565d7819ULL, 0x000fe200000006ffULL, 0x00001f5405087589ULL, 0x000ea200000e0000ULL,
0x0000000850557824ULL, 0x000fc400078e00ffULL, 0x0000000850577824ULL, 0x000fe200078e00ffULL,
0x00001f52054f7589ULL, 0x000fe200000e0000ULL, 0x00000008545b7824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee256ULL, 0x0000000852597824ULL, 0x000fc600078e00ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee254ULL, 0x000000105d5d7824ULL, 0x000fe200078e0202ULL,
0xfffffff859597812ULL, 0x000fc600078ee252ULL, 0x000000105b5b7824ULL, 0x000fe200078e0202ULL,
0x0000000259597211ULL, 0x000fe200078e20ffULL, 0x00000046070b7220ULL, 0x042fe40000410000ULL,
0x00001f5605467589ULL, 0x000e6200000e0000ULL, 0x0000000e07097220ULL, 0x040fe40000410000ULL,
0x00000037080e7220ULL, 0x044fe40000410000ULL, 0x0000003608377220ULL, 0x000fe40000410000ULL,
0x0000004e074e7220ULL, 0x000fc40000410000ULL, 0x0000004d074d7220ULL, 0x040fe40000410000ULL,
0x0000004c074c7220ULL, 0x040fe40000410000ULL, 0x0000004b074b7220ULL, 0x000fe20000410000ULL,
0x0000004e4d4d723eULL, 0x000fe200000010ffULL, 0x0000004a074a7220ULL, 0x040fe40000410000ULL,
0x0000004907497220ULL, 0x000fe20000410000ULL, 0x0000004c4b4b723eULL, 0x000fe200000010ffULL,
0x0000004807487220ULL, 0x000fc40000410000ULL, 0x0000004707477220ULL, 0x000fe20000410000ULL,
0x0000004a4949723eULL, 0x000fe200000010ffULL, 0x0000002e072e7220ULL, 0x000fe40000410000ULL,
0x0000003346367220ULL, 0x042fe20000410000ULL, 0x000000484747723eULL, 0x000fe200000010ffULL,
0x0000003246337220ULL, 0x000fe20000410000ULL, 0x0000002e0909723eULL, 0x000fe200000010ffULL,
0x0000002d072d7220ULL, 0x040fe40000410000ULL, 0x0000001a071a7220ULL, 0x000fc40000410000ULL,
0x0000002c072c7220ULL, 0x040fe40000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000002d1a1a723eULL, 0x000fe200000010ffULL, 0x0000004507067220ULL, 0x000fe20000410000ULL,
0x0000002c0b0b723eULL, 0x000fe200000010ffULL, 0x00000039080a7220ULL, 0x000fe40000410000ULL,
0x0000003146327220ULL, 0x000fe20000410000ULL, 0x0000002b0606723eULL, 0x000fe200000010ffULL,
0x000000444f077220ULL, 0x000fc40000410000ULL, 0x0000003808397220ULL, 0x000fe20000410000ULL,
0x0000000250387810ULL, 0x040fe20007ffe0ffULL, 0x0000000850457824ULL, 0x000fe400078e00ffULL,
0x0000003046317220ULL, 0x000fe40000410000ULL, 0x0000000850447824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee238ULL, 0x0000002f46307220ULL, 0x000fe20000410000ULL,
0x00000004502f7810ULL, 0x040fe20007ffe0ffULL, 0x000000164f167220ULL, 0x040fe20000410000ULL,
0x0000000550387810ULL, 0x000fe20007ffe0ffULL, 0x0000002a4f2a7220ULL, 0x040fe20000410000ULL,
0xfffffff844517812ULL, 0x000fe200078ee22fULL, 0x000000434f437220ULL, 0x000fe20000410000ULL,
0xfffffff853537812ULL, 0x000fe200078ee238ULL, 0x000000294f297220ULL, 0x000fe20000410000ULL,
0x000000160707723eULL, 0x000fe200000010ffULL, 0x000000424f427220ULL, 0x040fe20000410000ULL,
0xffffffff50387810ULL, 0x000fe20007ffe0ffULL, 0x000000284f287220ULL, 0x000fe20000410000ULL,
0x0000002a432a723eULL, 0x000fe200000010ffULL, 0x000000414f417220ULL, 0x000fe20000410000ULL,
0xfffffff857577812ULL, 0x000fe200078ee238ULL, 0x000000274f277220ULL, 0x040fe20000410000ULL,
0x000000294229723eULL, 0x000fe200000010ffULL, 0x000000404f407220ULL, 0x000fe20000410000ULL,
0x000000284128723eULL, 0x000fe200000010ffULL, 0x000000264f267220ULL, 0x000fc40000410000ULL,
0x0000003f4f3f7220ULL, 0x040fe20000410000ULL, 0x000000274027723eULL, 0x000fe200000010ffULL,
0x000000254f257220ULL, 0x040fe40000410000ULL, 0x0000003e4f3e7220ULL, 0x000fe20000410000ULL,
0x000000263f26723eULL, 0x000fe200000010ffULL, 0x000000244f247220ULL, 0x040fe40000410000ULL,
0x0000003d4f3d7220ULL, 0x000fe20000410000ULL, 0x000000253e25723eULL, 0x000fe200000010ffULL,
0x0000003a08057220ULL, 0x000fe20000410000ULL, 0x00000003503a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008504f7824ULL, 0x000fe200078e00ffULL, 0x000000243d24723eULL, 0x000fe200000010ffULL,
0x0000002308237220ULL, 0x000fc40000410000ULL, 0x0000003c083c7220ULL, 0x040fe20000410000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee23aULL, 0x0000002208227220ULL, 0x000fe20000410000ULL,
0x00000006503a7810ULL, 0x000fe20007ffe0ffULL, 0x0000003b083b7220ULL, 0x000fe20000410000ULL,
0x000000233c23723eULL, 0x000fe200000010ffULL, 0x0000002008207220ULL, 0x040fe20000410000ULL,
0xfffffff855557812ULL, 0x000fe200078ee23aULL, 0x0000001f081f7220ULL, 0x040fe20000410000ULL,
0x000000223b22723eULL, 0x000fe200000010ffULL, 0x0000001e081e7220ULL, 0x040fe20000410000ULL,
0x000000200505723eULL, 0x000fe200000010ffULL, 0x0000001d081d7220ULL, 0x000fe20000410000ULL,
0x0000001f0a0a723eULL, 0x000fe200000010ffULL, 0x0000001c081c7220ULL, 0x040fe20000410000ULL,
0x0000001e391e723eULL, 0x000fe200000010ffULL, 0x0000001b081b7220ULL, 0x000fe20000410000ULL,
0x0000001d0e0e723eULL, 0x000fe200000010ffULL, 0x00000008502f7824ULL, 0x000fe200078e00ffULL,
0x0000001c371c723eULL, 0x000fe200000010ffULL, 0x0000003508087220ULL, 0x000fe20000410000ULL,
0x0000000150357810ULL, 0x000fe20007ffe0ffULL, 0x0000000400167824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee250ULL, 0x0000001045457824ULL, 0x100fe200078e0202ULL,
0xfffffff844357812ULL, 0x000fe200078ee235ULL, 0x000000104f4f7824ULL, 0x100fe200078e0202ULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0202ULL,
0x0000001b0808723eULL, 0x000fe200000010ffULL, 0x0000001035357824ULL, 0x000fc400078e0202ULL,
0x0000001051517824ULL, 0x100fe400078e0202ULL, 0x0000001053537824ULL, 0x100fe400078e0202ULL,
0x0000001055557824ULL, 0x100fe400078e0202ULL, 0x0000001057577824ULL, 0x000fe400078e0202ULL,
0x0000002146217220ULL, 0x040fe40000410000ULL, 0x0000003446347220ULL, 0x000fe20000410000ULL,
0x0000005716577210ULL, 0x000fe20007ffe0ffULL, 0x000000012f027824ULL, 0x000fc400078e0216ULL,
0x0000000116357824ULL, 0x000fe200078e0235ULL, 0x000000213421723eULL, 0x000fe200000010ffULL,
0x0000000116207824ULL, 0x040fe200078e0245ULL, 0x0000004d02007388ULL, 0x0003e20000000800ULL,
0x00000001164f7824ULL, 0x040fe400078e024fULL, 0x0000000116517824ULL, 0x040fe200078e0251ULL,
0x0000004b35007388ULL, 0x000fe20000000800ULL, 0x0000000116537824ULL, 0x040fe400078e0253ULL,
0x0000000116347824ULL, 0x040fe200078e0255ULL, 0x0000004920007388ULL, 0x000fe20000000800ULL,
0x00000001162c7824ULL, 0x000fc400078e0259ULL, 0x00000001162e7824ULL, 0x000fe200078e025bULL,
0x000000474f007388ULL, 0x000fe20000000800ULL, 0x0000001946197220ULL, 0x040fe40000410000ULL,
0x0000001446147220ULL, 0x040fe20000410000ULL, 0x0000000951007388ULL, 0x000fe20000000800ULL,
0x0000001346137220ULL, 0x000fe20000410000ULL, 0x000000193619723eULL, 0x000fe200000010ffULL,
0x0000001246127220ULL, 0x040fe20000410000ULL, 0x0000001a53007388ULL, 0x000fe20000000800ULL,
0x0000001146117220ULL, 0x040fe20000410000ULL, 0x000000143314723eULL, 0x000fe200000010ffULL,
0x0000001046107220ULL, 0x000fe20000410000ULL, 0x0000000b34007388ULL, 0x000fe20000000800ULL,
0x0000000116167824ULL, 0x000fe200078e025dULL, 0x000000133213723eULL, 0x000fe200000010ffULL,
0x0000000d460d7220ULL, 0x040fe20000410000ULL, 0x0000000657007388ULL, 0x000fe20000000800ULL,
0x0000000f460f7220ULL, 0x040fe20000410000ULL, 0x000000123112723eULL, 0x000fe200000010ffULL,
0x0000000c460c7220ULL, 0x000fe20000410000ULL, 0x000000072c007388ULL, 0x000fe20000000800ULL,
0x000000111010723eULL, 0x000fe200000010ffULL, 0x0000000117027824ULL, 0x002fe200078e0200ULL,
0x0000000d300d723eULL, 0x000fe200000010ffULL, 0x0004002a35007388ULL, 0x000fe20000000800ULL,
0x0000000f0c0c723eULL, 0x000fe200000010ffULL, 0x0000001002027824ULL, 0x000fc400078e0203ULL,
0x0004002920007388ULL, 0x000fe80000000800ULL, 0x000400284f007388ULL, 0x000fe80000000800ULL,
0x0004002751007388ULL, 0x000fe80000000800ULL, 0x0004002653007388ULL, 0x000fe80000000800ULL,
0x0004002534007388ULL, 0x000fe80000000800ULL, 0x0004002457007388ULL, 0x000fe80000000800ULL,
0x000000232e007388ULL, 0x000fe80000000800ULL, 0x0008002235007388ULL, 0x000fe80000000800ULL,
0x0008000520007388ULL, 0x000fe80000000800ULL, 0x0008000a4f007388ULL, 0x000fe80000000800ULL,
0x0008001e51007388ULL, 0x000fe80000000800ULL, 0x0008000e53007388ULL, 0x000fe80000000800ULL,
0x0008001c34007388ULL, 0x000fe80000000800ULL, 0x0008000857007388ULL, 0x000fe80000000800ULL,
0x0000002116007388ULL, 0x000fe80000000800ULL, 0x000c001935007388ULL, 0x000fe80000000800ULL,
0x000c001420007388ULL, 0x000fe80000000800ULL, 0x000c00134f007388ULL, 0x000fe80000000800ULL,
0x000c001251007388ULL, 0x000fe80000000800ULL, 0x000c001053007388ULL, 0x000fe80000000800ULL,
0x000c000d34007388ULL, 0x000fe80000000800ULL, 0x000c000c57007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002087984ULL, 0x000e680000000c00ULL,
0x0004000002207984ULL, 0x000ea80000000c00ULL, 0x0008000002287984ULL, 0x000ee80000000c00ULL,
0x000c000002107984ULL, 0x000f280000000c00ULL, 0x00100000021c7984ULL, 0x000ee80000000c00ULL,
0x0014000002247984ULL, 0x000f280000000c00ULL, 0x00180000022c7984ULL, 0x000f280000000c00ULL,
0x001c000002307984ULL, 0x000f220000000c00ULL, 0x3f803f80040b7831ULL, 0x002fc4000020000bULL,
0x3f803f80040a7831ULL, 0x040fe4000020000aULL, 0x3f803f8004097831ULL, 0x040fe40000200009ULL,
0x3f803f8004087831ULL, 0x040fe40000200008ULL, 0x3f803f8004237831ULL, 0x044fe40000200023ULL,
0x3f803f8004227831ULL, 0x040fe40000200022ULL, 0x3f803f8004217831ULL, 0x000fc40000200021ULL,
0x3f803f8004207831ULL, 0x040fe40000200020ULL, 0x3f803f80042b7831ULL, 0x048fe4000020002bULL,
0x3f803f80042a7831ULL, 0x040fe4000020002aULL, 0x3f803f8004297831ULL, 0x040fe40000200029ULL,
0x3f803f8004287831ULL, 0x040fe40000200028ULL, 0x3f803f8004137831ULL, 0x010fc40000200013ULL,
0x3f803f8004127831ULL, 0x040fe40000200012ULL, 0x3f803f8004117831ULL, 0x040fe40000200011ULL,
0x3f803f8004107831ULL, 0x000fe40000200010ULL, 0x3f803f800b0b7831ULL, 0x000fe4000020001fULL,
0x3f803f800a0a7831ULL, 0x000fe4000020001eULL, 0x3f803f8009097831ULL, 0x000fc4000020001dULL,
0x3f803f8008087831ULL, 0x000fe4000020001cULL, 0x3f803f8023237831ULL, 0x000fe40000200027ULL,
0x3f803f8022227831ULL, 0x000fe20000200026ULL, 0x0000000802007388ULL, 0x000fe20000000c00ULL,
0x3f803f8021217831ULL, 0x000fe40000200025ULL, 0x3f803f8020207831ULL, 0x000fe40000200024ULL,
0x3f803f802b2b7831ULL, 0x000fc4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe2000020002eULL,
0x0004002002007388ULL, 0x000fe20000000c00ULL, 0x3f803f8029297831ULL, 0x000fe4000020002dULL,
0x3f803f8028287831ULL, 0x000fe4000020002cULL, 0x3f803f8013137831ULL, 0x000fe40000200033ULL,
0x3f803f8012127831ULL, 0x000fe20000200032ULL, 0x0008002802007388ULL, 0x000fe20000000c00ULL,
0x3f803f8011117831ULL, 0x000fc40000200031ULL, 0x3f803f8010107831ULL, 0x000fca0000200030ULL,
0x000c001002007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000830700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00005a0000067b06ULL, 0x000ee20000209000ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00005a00ff0e7a12ULL, 0x000fe200078e33ffULL,
0x000000019c027824ULL, 0x000fe200078e0207ULL, 0x0000000007077210ULL, 0x000fe40007ffe0ffULL,
0x00000020000f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000707077812ULL, 0x000fe400078ec0ffULL,
0x00000007000c7812ULL, 0x000fe200078ec0ffULL, 0x0000000600067308ULL, 0x008ee40000001000ULL,
0x0ffffffe06087810ULL, 0x008fc40007ffe0ffULL, 0x0ffffff807067812ULL, 0x000fc800078ef800ULL,
0x0000000800057305ULL, 0x000ee2000021f000ULL, 0x0000001006067824ULL, 0x000fe400078e0203ULL,
0x000000ffff097224ULL, 0x00cfc800078e0a05ULL, 0x00005a0009097a24ULL, 0x000fc800078e02ffULL,
0x00000009050d7227ULL, 0x000fe400078e0004ULL, 0x0000000006087984ULL, 0x000ea80000000c00ULL,
0x000000020d047227ULL, 0x000fc800078e00ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x00005a0005007a0cULL, 0x000fda0003f06070ULL,
0x80005a0005050a10ULL, 0x000fe40007ffe0ffULL, 0x0000000104040810ULL, 0x000fe40007ffe0ffULL,
0x00005a0005007a0cULL, 0x000fe40003f26070ULL, 0x00005a00ff007a0cULL, 0x000fd60003f05070ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x000000040e047207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a04ULL, 0x0000590004057a24ULL, 0x000fe400078e0281ULL,
0x00005a0007027a24ULL, 0x000fe400078e0202ULL, 0x0000000815077824ULL, 0x000fe400078e020cULL,
0x00005a0005057a24ULL, 0x000fca00078e0202ULL, 0x0000000584057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4402ULL, 0x00000003ff027819ULL, 0x000fc6000001160fULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x000000830200720cULL, 0x000fc80003f26070ULL,
0x0000000804007986ULL, 0x0045f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c047824ULL, 0x104fe200078e0202ULL, 0x0000004000117810ULL, 0x002fe20007ffe0ffULL,
0x000000010f027824ULL, 0x000fc400078e0202ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff802027812ULL, 0x000fe200078ef80fULL, 0x00005a0007067a24ULL, 0x000fc800078e0204ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x00005a0006007a0cULL, 0x000fc80003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fce0000011611ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e0281ULL, 0x000000070f067812ULL, 0x000fe200078ec0ffULL,
0x00005a0007047a24ULL, 0x000fc800078e0204ULL, 0x00005a0005057a24ULL, 0x000fe400078e0204ULL,
0x0000000815077824ULL, 0x000fc600078e0206ULL, 0x0000000584057210ULL, 0x000fc80007f3e0ffULL,
0x000000ffff0c7210ULL, 0x000fe40000ffe4ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000830200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000019c047824ULL, 0x102fe200078e0202ULL,
0x00000060000f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111027824ULL, 0x000fe400078e0202ULL,
0x000000040d057227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff802027812ULL, 0x000fe200078ef811ULL,
0x00005a0007067a24ULL, 0x000fc800078e0204ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x00000003ff027819ULL, 0x002fce000001160fULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe200078e0281ULL,
0x0000000711067812ULL, 0x000fe200078ec0ffULL, 0x00005a0007047a24ULL, 0x000fc800078e0204ULL,
0x00005a0005057a24ULL, 0x000fe400078e0204ULL, 0x0000000815077824ULL, 0x000fc600078e0206ULL,
0x0000000584057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000830200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c047824ULL, 0x102fe200078e0202ULL, 0x0000008000117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f027824ULL, 0x000fe400078e0202ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x000000ff05077210ULL, 0x000fe40007ffe1ffULL,
0x0ffffff802027812ULL, 0x000fc600078ef80fULL, 0x00005a0007067a24ULL, 0x000fe400078e0204ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fd20000011611ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e0281ULL, 0x000000070f067812ULL, 0x000fe200078ec0ffULL,
0x00005a0007047a24ULL, 0x000fc800078e0204ULL, 0x00005a0005057a24ULL, 0x000fe400078e0204ULL,
0x0000000815077824ULL, 0x000fc600078e0206ULL, 0x0000000584057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000830200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000019c047824ULL, 0x102fe200078e0202ULL,
0x000000a0000f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111027824ULL, 0x000fe400078e0202ULL,
0x000000040d057227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff077224ULL, 0x000fc600078e0a05ULL, 0x0ffffff802027812ULL, 0x000fe200078ef811ULL,
0x00005a0007067a24ULL, 0x000fc800078e0204ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x00005a0006007a0cULL, 0x000fc80003f26070ULL, 0x0000000002087984ULL, 0x0002a40000000c00ULL,
0x00000003ff027819ULL, 0x002fce000001160fULL, 0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e067207ULL, 0x000fc80004000000ULL,
0x000000ff06077210ULL, 0x040fe20007ffe1ffULL, 0x0000590006057a24ULL, 0x000fe200078e0281ULL,
0x0000000711067812ULL, 0x000fc600078ec0ffULL, 0x00005a0007047a24ULL, 0x000fe400078e0204ULL,
0x0000000815077824ULL, 0x000fe400078e0206ULL, 0x00005a0005057a24ULL, 0x000fca00078e0204ULL,
0x0000000584057210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e0005047a11ULL, 0x000fc800078240ffULL, 0x00005f0005057a11ULL, 0x000fe400008f440cULL,
0x000000830200720cULL, 0x000fc60003f26070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000019c047824ULL, 0x102fe200078e0202ULL, 0x000000c000117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f027824ULL, 0x000fe400078e0202ULL, 0x000000040d057227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fc600078e0a05ULL,
0x0ffffff802027812ULL, 0x000fe200078ef80fULL, 0x00005a0007067a24ULL, 0x000fc800078e0204ULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x00005a0006007a0cULL, 0x000fc80003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fce0000011611ULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00005a0006007a0cULL, 0x000fda0003f46070ULL, 0x0000000105052810ULL, 0x000fc80007ffe0ffULL,
0x000000050e067207ULL, 0x000fca0004000000ULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000590006057a24ULL, 0x000fe200078e0281ULL, 0x000000070f067812ULL, 0x000fe200078ec0ffULL,
0x00005a0007047a24ULL, 0x000fc800078e0204ULL, 0x00005a0005057a24ULL, 0x000fe400078e0204ULL,
0x0000000815077824ULL, 0x000fc600078e0206ULL, 0x0000000584057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f440cULL, 0x000000830200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000029c047210ULL, 0x002fe20007ffe0ffULL,
0x0000000111027824ULL, 0x040fe200078e0202ULL, 0x000000e0000f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000711007812ULL, 0x000fe200078ec0ffULL, 0x000000040d057227ULL, 0x000fe200078e00ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200078e0a05ULL,
0x0ffffff802027812ULL, 0x000fc600078ef811ULL, 0x00005a0007067a24ULL, 0x000fe400078e0204ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x00005a0006007a0cULL, 0x000fe40003f26070ULL,
0x0000000002087984ULL, 0x0002a40000000c00ULL, 0x00000003ff027819ULL, 0x002fd2000001160fULL,
0x80005a0006061a10ULL, 0x000fe40007ffe0ffULL, 0x0000000105051810ULL, 0x000fe20007ffe0ffULL,
0x000000019c9c7824ULL, 0x000fe200078e0202ULL, 0x00005a0006007a0cULL, 0x000fda0003f46070ULL,
0x0000000105052810ULL, 0x000fc80007ffe0ffULL, 0x000000050e067207ULL, 0x000fca0004000000ULL,
0x000000ffff077224ULL, 0x000fe400078e0a06ULL, 0x0000590006057a24ULL, 0x000fe400078e0281ULL,
0x00005a0007047a24ULL, 0x000fe400078e0204ULL, 0x0000000815077824ULL, 0x000fe400078e0200ULL,
0x00005a0005057a24ULL, 0x000fca00078e0204ULL, 0x0000000584057210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e0005047a11ULL, 0x000fc800078240ffULL,
0x00005f0005057a11ULL, 0x000fe400008f4406ULL, 0x000000830200720cULL, 0x000fc60003f26070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000009c0d007227ULL, 0x000fc800078e00ffULL,
0x000000ffff057224ULL, 0x002fe400078e0a00ULL, 0x000000010f027824ULL, 0x000fe400078e0202ULL,
0x00005a0005047a24ULL, 0x000fc600078e029cULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f26070ULL, 0xfffffff802027812ULL, 0x000fd600078ef80fULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000100001810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0000000302047211ULL, 0x000fcc00078e20ffULL,
0x0000000004047984ULL, 0x000e6a0000000c00ULL, 0x0000000100002810ULL, 0x000fc80007ffe0ffULL,
0x000000000e007207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a00ULL,
0x0000590000037a24ULL, 0x000fe200078e0281ULL, 0x000000070f007812ULL, 0x000fe200078ec0ffULL,
0x00005a00099c7a24ULL, 0x000fc800078e029cULL, 0x00005a0003037a24ULL, 0x000fe400078e029cULL,
0x0000000815157824ULL, 0x000fc600078e0200ULL, 0x0000000384037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078040ffULL,
0x00005f0003037a11ULL, 0x000fca00000f4408ULL, 0x0000001015027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fe2000001169dULL, 0xffffffffff207424ULL, 0x000fc800078e00ffULL,
0x0000000299217824ULL, 0x000fca00078e0204ULL, 0x000000232100720cULL, 0x000fda0003f06070ULL,
0x00000002a5048824ULL, 0x000fc800078e00ffULL, 0x00006a0004078a24ULL, 0x002fc800078e0221ULL,
0x0000660007068625ULL, 0x000fe200078e009aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000606208981ULL, 0x000ea2000c1e1900ULL, 0x0000000199097810ULL, 0x000fe20007ffe0ffULL,
0x00005800ff1d7624ULL, 0x000fe200078e00ffULL, 0x00000007811f7819ULL, 0x000fe200000006ffULL,
0x000000409da37824ULL, 0x000fe200078e00ffULL, 0x000000220900720cULL, 0x000fe20003f06070ULL,
0x00000080a2a27824ULL, 0x000fe200078e00ffULL, 0x0000001f1d1d7810ULL, 0x000fe20007ffe0ffULL,
0x00000100990b7824ULL, 0x000fe200078e02a3ULL, 0x01e60000ff047f8cULL, 0x000e62000c80043fULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000005ff1d7819ULL, 0x000fc4000001161dULL,
0x000000401f097812ULL, 0x000fe200078ef80bULL, 0x000000a220067224ULL, 0x004fc800078e02ffULL,
0x0000640006067625ULL, 0x000fe200078e000dULL, 0x00000c7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x102fe40000011600ULL, 0x0000000b98087217ULL, 0x000fe40007800000ULL,
0x00000004390d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x000fe200078e0239ULL,
0x0000001039137810ULL, 0x040fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a0bULL,
0x00000008390f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0b7824ULL, 0x000fe200078e0200ULL,
0x0000000c39117810ULL, 0x000fe20007ffe0ffULL, 0x000000080d107824ULL, 0x040fe200078e00ffULL,
0x000000080d00720cULL, 0x000fe20003fa6070ULL, 0x00000008133b7824ULL, 0x000fe200078e00ffULL,
0x0000001839337810ULL, 0x000fe20007ffe0ffULL, 0x00000001090c7824ULL, 0x040fe200078e020dULL,
0xfffffff8102b7812ULL, 0x000fe200078ee20bULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003309127210ULL, 0x000fc40007ffe0ffULL, 0x0000001439277810ULL, 0x040fe20007ffe0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a157812ULL, 0x100fe400078ef803ULL,
0x0000001c39417810ULL, 0x000fe20007ffe0ffULL, 0x00000001130a7824ULL, 0x100fe200078e0200ULL,
0x0000001506147210ULL, 0x000fe20007f1e0ffULL, 0x000000010f0e7824ULL, 0x040fe200078e0200ULL,
0x000000700c177812ULL, 0x000fe200078ef803ULL, 0x000000080f357824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL, 0x00000001090a7824ULL, 0x000fe200078e020fULL,
0x0000001706167210ULL, 0x000fe20007f3e0ffULL, 0x0000000107157824ULL, 0x000fe200000e060bULL,
0xfffffff835357812ULL, 0x000fe200078ee20eULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x00000000110e7210ULL, 0x000fc40007ffe0ffULL, 0x000000081300720cULL, 0x080fe20003f06070ULL,
0x0000000811377824ULL, 0x000fe200078e00ffULL, 0x000000700a197812ULL, 0x000fe200078ef803ULL,
0x00000001090c7824ULL, 0x000fe200078e0211ULL, 0x000000081100720cULL, 0x080fe20003f46070ULL,
0x0000000107177824ULL, 0x000fe200008e060dULL, 0xfffffff837377812ULL, 0x000fe200078ee20eULL,
0x00000001090e7824ULL, 0x000fe200078e0213ULL, 0x0000001906187210ULL, 0x000fe20007f7e0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000080f00720cULL, 0x000fc40003f26070ULL,
0x00000020392d7810ULL, 0x040fe20007ffe0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000700c1b7812ULL, 0x000fe400078ef803ULL, 0x00000024392f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107197824ULL, 0x000fe200018e060bULL, 0x00000070120b7812ULL, 0x000fe200078ef803ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001b061a7210ULL, 0x040fe40007f9e0ffULL,
0x0000000b06127210ULL, 0x000fe20007fde0ffULL, 0x0000000109107824ULL, 0x040fe200078e0227ULL,
0x000000700e257812ULL, 0x000fe200078ef803ULL, 0x00000001090a7824ULL, 0x000fe200078e0241ULL,
0x000020009d1c7811ULL, 0x000fe200078e70ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x00000025060e7210ULL, 0x000fc40007f7e0ffULL, 0x0000002839317810ULL, 0x000fe20007ffe0ffULL,
0x000001000a0a7825ULL, 0x000fc800078e00ffULL, 0x00000001071b7824ULL, 0x040fe200020e060dULL,
0x00000070100d7812ULL, 0x000fe200078ef803ULL, 0x0000000107137824ULL, 0x000fe200030e0613ULL,
0x000000700a257812ULL, 0x000fe200078ef803ULL, 0x00000001390c7824ULL, 0x100fe200078e0200ULL,
0x0000000d06107210ULL, 0x040fe20007f9e0ffULL, 0x00000008273d7824ULL, 0x000fe200078e00ffULL,
0x0000002506247210ULL, 0x000fe20007fde0ffULL, 0x00000001070f7824ULL, 0x000fe200018e060fULL,
0x0000002d090a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000107117824ULL, 0x000fe200020e0611ULL,
0x000000070c0d7812ULL, 0x000fe200078ec0ffULL, 0x00000001270c7824ULL, 0x100fe200078e0200ULL,
0x000000083900720cULL, 0x080fe20003f86070ULL, 0x0000000107257824ULL, 0x000fe200030e060bULL,
0x0ffffff80d0d7812ULL, 0x000fe200078ef800ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000082700720cULL, 0x000fc40003f66070ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL,
0x00000001090c7824ULL, 0x000fe200078e022fULL, 0x000000700a277812ULL, 0x000fe200078ef803ULL,
0x000000100d297824ULL, 0x000fe400078e021cULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002706267210ULL, 0x000fe40007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014297faeULL, 0x0003e2000e101c46ULL, 0x00000001090a7824ULL, 0x000fe200078e0231ULL,
0x000000083300720cULL, 0x000fe20003f86070ULL, 0x0000000107277824ULL, 0x000fc400030e060bULL,
0x000001000a0a7825ULL, 0x000fc800078e00ffULL, 0x00000001331e7824ULL, 0x040fe400078e0200ULL,
0x00000008333f7824ULL, 0x000fe200078e00ffULL, 0x000000700c157812ULL, 0x102fe200078ef803ULL,
0x000000102b297824ULL, 0x100fe200078e021cULL, 0x0000002c39337810ULL, 0x000fe20007ffe0ffULL,
0x00000010352b7824ULL, 0x000fe200078e021cULL, 0x00000015060c7210ULL, 0x000fe40007fde0ffULL,
0x000000700a157812ULL, 0x000fe200078ef803ULL, 0x00000001090a7824ULL, 0x000fe200078e0233ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee21eULL, 0x00000001070d7824ULL, 0x000fe200030e060dULL,
0x0000001506147210ULL, 0x000fe20007fde0ffULL, 0x0000000016297faeULL, 0x0003e2000e901c46ULL,
0x000000084100720cULL, 0x040fe20003fa6070ULL, 0x00000001411e7824ULL, 0x040fe200078e0200ULL,
0x0000000341417819ULL, 0x000fe200000006ffULL, 0x0000000107157824ULL, 0x000fe200030e060bULL,
0x00000000182b7faeULL, 0x0005e2000c901c46ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fc400078ee21eULL, 0x000000082d00720cULL, 0x0c0fe20003f26070ULL,
0x000000082d1e7824ULL, 0x000fe200078e00ffULL, 0x0000003439357810ULL, 0x000fe20007ffe0ffULL,
0x0000001037297824ULL, 0x002fe200078e021cULL, 0x0000003839377810ULL, 0x000fe20007ffe0ffULL,
0x000000012d177824ULL, 0x100fe200078e0200ULL, 0x000000700a2d7812ULL, 0x000fe200078ef803ULL,
0x000000012f0a7824ULL, 0x040fe200078e0200ULL, 0x000000001a297faeULL, 0x0003e2000d101c46ULL,
0x000000082f00720cULL, 0x040fe20003f46070ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x0000002d06167210ULL, 0x000fc40007fde0ffULL, 0xfffffff81e2b7812ULL, 0x004fe400078ee217ULL,
0xfffffff82f2d7812ULL, 0x000fe200078ee20aULL, 0x0000000107177824ULL, 0x000fe200030e060bULL,
0x00000030392f7810ULL, 0x000fe20007ffe0ffULL, 0x000000103d0b7824ULL, 0x100fe200078e021cULL,
0x0000001c3b197211ULL, 0x000fe200078e20ffULL, 0x000000103f1b7824ULL, 0x102fe200078e021cULL,
0x0000003c39397810ULL, 0x000fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x000fe400078e022fULL,
0x0000001041297824ULL, 0x100fe200078e021cULL, 0x000000000e197faeULL, 0x0003e2000c101c46ULL,
0x000000102b2b7824ULL, 0x100fe200078e021cULL, 0x000000083900720cULL, 0x080fe20003f06070ULL,
0x000000102d2d7824ULL, 0x000fe200078e021cULL, 0x00000000100b7faeULL, 0x0005e2000d901c46ULL,
0x000000082f00720cULL, 0x000fc60003f66070ULL, 0x00000000121b7faeULL, 0x0007e2000e101c46ULL,
0x000000083300720cULL, 0x000fc60003f86070ULL, 0x0000000024297faeULL, 0x0009e2000e901c46ULL,
0x00000001310f7824ULL, 0x142fe200078e0200ULL, 0x000000083100720cULL, 0x080fe20003fa6070ULL,
0x000000082f197824ULL, 0x000fe200078e00ffULL, 0x00000000262b7faeULL, 0x0003e2000c901c46ULL,
0x000001000a0a7825ULL, 0x004fe200078e00ffULL, 0x0000003509107210ULL, 0x000fe40007ffe0ffULL,
0x000000000c2d7faeULL, 0x0005e2000d101c46ULL, 0x0000000831127824ULL, 0x008fe200078e00ffULL,
0x000000083500720cULL, 0x080fe20003f46070ULL, 0x0000000833137824ULL, 0x000fe200078e00ffULL,
0x000000083700720cULL, 0x000fe20003f26070ULL, 0x0000000133087824ULL, 0x100fe200078e0200ULL,
0xfffffff812117812ULL, 0x000fe200078ee20fULL, 0x0000000137127824ULL, 0x000fc400078e0200ULL,
0x0000000837257824ULL, 0x010fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x0000000839277824ULL, 0x002fe200078e00ffULL, 0x000000700a0d7812ULL, 0x004fe200078ef803ULL,
0x000000012f0a7824ULL, 0x000fe200078e0200ULL, 0xfffffff825257812ULL, 0x000fe200078ee212ULL,
0x0000001011117824ULL, 0x000fe200078e021cULL, 0x0000000d060e7210ULL, 0x000fe20007fde0ffULL,
0x00000100100c7825ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe400078ee20aULL,
0x0000001c25257211ULL, 0x000fe200078e20ffULL, 0x00000001070f7824ULL, 0x000fe200030e060bULL,
0x000000700c0b7812ULL, 0x000fe200078ef803ULL, 0x0000000135107824ULL, 0x140fe200078e0200ULL,
0x0000000014117faeULL, 0x0003e2000e901c46ULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x0000000b060c7210ULL, 0x000fe20007fde0ffULL, 0x00000001090b7824ULL, 0x040fe200078e0237ULL,
0x0000003909097210ULL, 0x000fe20007ffe0ffULL, 0x0000000139007824ULL, 0x000fc400078e0200ULL,
0x000001000b0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee200ULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x000000700a1b7812ULL, 0x000fc600078ef803ULL,
0x00000001070d7824ULL, 0x000fe200030e060dULL, 0x0000001b060a7210ULL, 0x000fe20007fde0ffULL,
0x0000001013137824ULL, 0x100fe200078e021cULL, 0x0000007008037812ULL, 0x000fe200078ef803ULL,
0x0000001019197824ULL, 0x000fe200078e021cULL, 0xfffffff8351b7812ULL, 0x000fe200078ee210ULL,
0x00000001070b7824ULL, 0x000fe200030e060bULL, 0x0000000306067210ULL, 0x000fe20007fde0ffULL,
0x0000001027277824ULL, 0x100fe200078e021cULL, 0x0000000016137faeULL, 0x0003e2000e101c46ULL,
0x000000101b1b7824ULL, 0x000fc400078e021cULL, 0x0000000107077824ULL, 0x000fe200030e0609ULL,
0x000000000e197faeULL, 0x0003e8000d901c46ULL, 0x000000000c1b7faeULL, 0x0003e8000d101c46ULL,
0x000000000a257faeULL, 0x0003e8000c901c46ULL, 0x0000000006277faeULL, 0x0003e2000c101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000c00117811ULL, 0x042fe400078fe8ffULL,
0x0000000800107811ULL, 0x000fc400078fe8ffULL, 0x00000004000f7811ULL, 0x040fe200078fe8ffULL,
0x00000001110b7824ULL, 0x140fe200078e0200ULL, 0x0000001800247811ULL, 0x040fe200078fe8ffULL,
0x00000008110c7824ULL, 0x000fe200078e00ffULL, 0x00000014001e7811ULL, 0x000fe200078fe8ffULL,
0x00000001100a7824ULL, 0x100fe200078e0200ULL, 0x0000001c00267811ULL, 0x000fe200078fe8ffULL,
0x0000000810357824ULL, 0x000fe200078e00ffULL, 0xfffffff80c377812ULL, 0x000fe200078ee20bULL,
0x000000010f087824ULL, 0x040fe200078e0200ULL, 0x00000010001c7811ULL, 0x000fe200078fe8ffULL,
0x000000080f337824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20aULL,
0x00000001240b7824ULL, 0x000fe200078e0200ULL, 0x00000024000d7811ULL, 0x000fe200078fe8ffULL,
0x00000008240e7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee208ULL,
0x000000011e0a7824ULL, 0x100fe200078e0200ULL, 0x0000002800127811ULL, 0x000fe200078fe8ffULL,
0x000000081e3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3d7812ULL, 0x000fe200078ee20bULL,
0x00000001260c7824ULL, 0x100fe200078e0200ULL, 0x0000002c00167811ULL, 0x000fe200078fe8ffULL,
0x00000008263f7824ULL, 0x000fe200078e00ffULL, 0x000000031c397819ULL, 0x040fe200000006ffULL,
0x000000011c087824ULL, 0x000fe200078e0200ULL, 0x00000020000b7811ULL, 0x000fe200078fe8ffULL,
0x0000000812177824ULL, 0x040fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL,
0x000000010d0a7824ULL, 0x000fe200078e0200ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20cULL,
0x00000001120c7824ULL, 0x100fe200078e0200ULL, 0x000000030d157819ULL, 0x000fe200000006ffULL,
0x00000001160e7824ULL, 0x040fe200078e0200ULL, 0xfffffff839397812ULL, 0x000fe200078ee208ULL,
0x0000000816197824ULL, 0x000fe200078e00ffULL, 0xfffffff815147812ULL, 0x000fe200078ee20aULL,
0x000000010b087824ULL, 0x000fe200078e0200ULL, 0xfffffff817157812ULL, 0x000fe200078ee20cULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0x00000000000a7211ULL, 0x080fe200078fe8ffULL,
0x00000001100c7824ULL, 0x100fe200078e0209ULL, 0xfffffff819177812ULL, 0x000fe200078ee20eULL,
0x00000001110e7824ULL, 0x100fe200078e0209ULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x000000011e107824ULL, 0x000fe200078e0209ULL, 0x0000003000187811ULL, 0x040fe200078fe8ffULL,
0x00000001091e7824ULL, 0x040fe200078e020bULL, 0x0000003400197811ULL, 0x040fe200078fe8ffULL,
0x0000000109287824ULL, 0x040fe200078e020dULL, 0x00000038001a7811ULL, 0x040fe200078fe8ffULL,
0x0000000109297824ULL, 0x040fe200078e0212ULL, 0x0000003c001b7811ULL, 0x040fe200078fe8ffULL,
0x00000001092a7824ULL, 0x040fe200078e0216ULL, 0x0000000900087211ULL, 0x080fe200078fe8ffULL,
0x0000000109307824ULL, 0x000fe200078e0218ULL, 0x000000070a257812ULL, 0x000fe200078ec0ffULL,
0x000000010f0a7824ULL, 0x100fe200078e0209ULL, 0x0000000924117210ULL, 0x000fe20007ffe0ffULL,
0x000000011c0f7824ULL, 0x100fe200078e0209ULL, 0x00000000190d7210ULL, 0x000fe20007ffe0ffULL,
0x00000001261c7824ULL, 0x000fe200078e0209ULL, 0x0ffffff825257812ULL, 0x000fe200078ef800ULL,
0x0000000109327824ULL, 0x000fc400078e0219ULL, 0x0000000109347824ULL, 0x040fe400078e021aULL,
0x0000000109367824ULL, 0x000fe400078e021bULL, 0x00000001180b7824ULL, 0x000fe400078e0200ULL,
0x0000010008087825ULL, 0x000fc800078e00ffULL, 0x0000000818187824ULL, 0x000fe400078e00ffULL,
0x0000000819167824ULL, 0x000fe400078e00ffULL, 0x000000011a127824ULL, 0x140fe400078e0200ULL,
0x000000081a277824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee20dULL,
0x000000011b197824ULL, 0x040fe200078e0200ULL, 0xfffffff818007812ULL, 0x000fe200078ee20bULL,
0x000000081b1a7824ULL, 0x000fe200078e00ffULL, 0x00000070081b7812ULL, 0x000fe200078ef803ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000020009d087811ULL, 0x000fc400078e70ffULL,
0xfffffff827187812ULL, 0x000fe200078ee212ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff81a197812ULL, 0x000fe400078ee219ULL, 0x0000001b06127210ULL, 0x000fe20007f1e0ffULL,
0x0000001015457824ULL, 0x100fe200078e0208ULL, 0x000000700a157812ULL, 0x100fe200078ef803ULL,
0x0000001014437824ULL, 0x100fe200078e0208ULL, 0x0000000835357211ULL, 0x080fe200078e20ffULL,
0x0000001013417824ULL, 0x100fe200078e0208ULL, 0x0000001506147210ULL, 0x000fe20007f3e0ffULL,
0x0000001017477824ULL, 0x100fe200078e0208ULL, 0x0000000800497211ULL, 0x000fe200078e20ffULL,
0x0000001025317824ULL, 0x100fe200078e0208ULL, 0x000000700c177812ULL, 0x000fe200078ef803ULL,
0x0000001033337824ULL, 0x000fc400078e0208ULL, 0x0000001037377824ULL, 0x100fe400078e0208ULL,
0x0000001039397824ULL, 0x100fe400078e0208ULL, 0x000000103b3b7824ULL, 0x100fe400078e0208ULL,
0x000000103d3d7824ULL, 0x100fe400078e0208ULL, 0x000000103f3f7824ULL, 0x100fe400078e0208ULL,
0x00000010164b7824ULL, 0x000fc400078e0208ULL, 0x00000010184d7824ULL, 0x100fe400078e0208ULL,
0x00000010194f7824ULL, 0x000fe400078e0208ULL, 0x0000000107137824ULL, 0x000fe200000e0609ULL,
0x0000001706167210ULL, 0x000fe20007f1e0ffULL, 0x000001000e087825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012317faeULL, 0x0003e2000b901c46ULL,
0x0000000107157824ULL, 0x000fe200008e060bULL, 0x0000007008197812ULL, 0x000fe200078ef803ULL,
0x000001000f0a7825ULL, 0x000fc600078e00ffULL, 0x0000000014337faeULL, 0x0003e2000b901c46ULL,
0x0000000107177824ULL, 0x000fe200000e060dULL, 0x000000700a1b7812ULL, 0x100fe200078ef803ULL,
0x00000100100e7825ULL, 0x000fe200078e00ffULL, 0x0000001906187210ULL, 0x040fe40007f1e0ffULL,
0x0000001b061a7210ULL, 0x000fe20007f3e0ffULL, 0x0000010011107825ULL, 0x000fe200078e00ffULL,
0x000000700e257812ULL, 0x000fe200078ef803ULL, 0x0000000016357faeULL, 0x0003e4000b901c46ULL,
0x0000000107197824ULL, 0x000fe200000e0609ULL, 0x0000007010277812ULL, 0x000fe200078ef803ULL,
0x000001001c087825ULL, 0x000fe200078e00ffULL, 0x0000002506247210ULL, 0x000fc40007f1e0ffULL,
0x0000002706267210ULL, 0x000fe20007f5e0ffULL, 0x00000001071b7824ULL, 0x040fe200008e060bULL,
0x00000070082d7812ULL, 0x100fe200078ef803ULL, 0x000001001e0a7825ULL, 0x000fe200078e00ffULL,
0x0000001107277210ULL, 0x040fe200017fe4ffULL, 0x0000000018377faeULL, 0x0003e4000b901c46ULL,
0x00000100280c7825ULL, 0x000fe200078e00ffULL, 0x000000700a2b7812ULL, 0x000fe200078ef803ULL,
0x000000001a397faeULL, 0x0003e4000b901c46ULL, 0x0000000107257824ULL, 0x000fe200000e060fULL,
0x0000002d06287210ULL, 0x000fe20007f1e0ffULL, 0x00000100290e7825ULL, 0x000fe200078e00ffULL,
0x000000700c2d7812ULL, 0x000fc400078ef803ULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x000001002a107825ULL, 0x000fe200078e00ffULL, 0x0000002b062a7210ULL, 0x000fe40007f3e0ffULL,
0x000000700e2f7812ULL, 0x000fe200078ef803ULL, 0x0000000107297824ULL, 0x040fe200000e0609ULL,
0x0000002d062c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001072b7824ULL, 0x040fe200008e060bULL,
0x00000070100b7812ULL, 0x000fe200078ef803ULL, 0x0000010030087825ULL, 0x000fe200078e00ffULL,
0x0000002f062e7210ULL, 0x040fe20007f5e0ffULL, 0x00000000263d7faeULL, 0x0003e4000b901c46ULL,
0x00000001072d7824ULL, 0x040fe200000e060dULL, 0x0000000b06107210ULL, 0x000fe20007f1e0ffULL,
0x00000100320a7825ULL, 0x000fe200078e00ffULL, 0x0000007008557812ULL, 0x000fe200078ef803ULL,
0x00000000283f7faeULL, 0x0003e4000b901c46ULL, 0x00000001072f7824ULL, 0x040fe200010e060fULL,
0x000000700a537812ULL, 0x100fe200078ef803ULL, 0x00000100340c7825ULL, 0x000fe200078e00ffULL,
0x000000002a417faeULL, 0x0003e4000b901c46ULL, 0x00000053060a7210ULL, 0x000fe20007f3e0ffULL,
0x00000100360e7825ULL, 0x000fe200078e00ffULL, 0x000000700c517812ULL, 0x000fe200078ef803ULL,
0x000000002c437faeULL, 0x0003e4000b901c46ULL, 0x0000000107117824ULL, 0x040fe200000e0611ULL,
0x000000700e037812ULL, 0x000fe200078ef803ULL, 0x00000001070b7824ULL, 0x000fe200008e060bULL,
0x0000005506087210ULL, 0x040fe20007f1e0ffULL, 0x000000002e457faeULL, 0x0003e2000b901c46ULL,
0x00000051060c7210ULL, 0x000fc40007f5e0ffULL, 0x0000000306067210ULL, 0x000fe20007f7e0ffULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000000010477faeULL, 0x0003e2000b901c46ULL,
0x00000001070d7824ULL, 0x040fe400010e060dULL, 0x0000000107077824ULL, 0x000fe200018e060fULL,
0x0000000008497faeULL, 0x0003e8000b901c46ULL, 0x000000000a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000000c4d7faeULL, 0x0003e8000b901c46ULL, 0x00000000064f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01e60400ff037984ULL, 0x000e620000000800ULL, 0x0000001d029b7224ULL, 0x000fe200078e02ffULL,
0x8000009e989f7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x8000000003ff7812ULL, 0x002fe20007804805ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000062009b9a7625ULL, 0x000fe200078e009aULL,
0x00000008ff9f7819ULL, 0x000fe2000001169fULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000027805ULL, 0x000fcc0000015200ULL, 0x0000000206097210ULL, 0x000fca0007f1e1ffULL,
0x0000000103037824ULL, 0x000fe200000e0e07ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011403ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff037224ULL, 0x000fca00000e0603ULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000229900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000001e7919ULL, 0x000e620000000000ULL, 0x00006a00a5a57a24ULL, 0x000fe200078e02ffULL,
0x0001e6889da07811ULL, 0x000fe200078e18ffULL, 0x000000021d1d7824ULL, 0x000fe200078e00ffULL,
0xffffffff9e1c7810ULL, 0x040fe20007ffe0ffULL, 0x000000209da17824ULL, 0x000fe200078e00ffULL,
0x000000099e1b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000199037810ULL, 0x040fe20007ffe0ffULL,
0x00000100991a7824ULL, 0x000fe200078e02a3ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000100ffa47424ULL, 0x000fe200078e00ffULL, 0x000000220300720cULL, 0x000fe20003f06070ULL,
0x00000020a2037224ULL, 0x000fe200078e02ffULL, 0x000000401a007812ULL, 0x000fc600078ec0ffULL,
0x0000640003027625ULL, 0x000fc800078e00a4ULL, 0x000000011f2f7824ULL, 0x000fc800078e0200ULL,
0x00000bb000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff2b7819ULL, 0x102fe2000001161eULL,
0x000000101e197824ULL, 0x000fe200078e00ffULL, 0x0000001a98097217ULL, 0x000fe40007800000ULL,
0x000000082b0d7810ULL, 0x040fe20007ffe0ffULL, 0x000000012b077824ULL, 0x000fe200078e022fULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x000000012b177824ULL, 0x140fe200078e021eULL,
0x000000042b0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d057824ULL, 0x000fe200078e021eULL,
0x0000008019047812ULL, 0x000fe200078efcffULL, 0x000000080d067824ULL, 0x000fe200078e00ffULL,
0x0000000c2b117810ULL, 0x000fe20007ffe0ffULL, 0x000000080b297824ULL, 0x040fe200078e00ffULL,
0x0000001e0b007210ULL, 0x000fc40007ffe0ffULL, 0xfffffff8062d7812ULL, 0x000fe200078ee205ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee200ULL,
0x0000000111087824ULL, 0x000fe200078e021eULL, 0x000000091a007210ULL, 0x000fe20007ffe1ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000102b137810ULL, 0x040fe40007ffe0ffULL,
0x000000142b257810ULL, 0x000fe20007ffe0ffULL, 0x0000000811317824ULL, 0x000fe200078e00ffULL,
0x00000006020e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010d097824ULL, 0x140fe200078e022fULL,
0x000000000d00720cULL, 0x080fe20003f46070ULL, 0x00000001130d7824ULL, 0x000fe200078e022fULL,
0xfffffff831317812ULL, 0x000fe200078ee208ULL, 0x00000001030f7824ULL, 0x000fe200000e0607ULL,
0x000000000b00720cULL, 0x0c0fe20003f86070ULL, 0x000000010b077824ULL, 0x000fe200078e022fULL,
0x000000001100720cULL, 0x080fe20003f66070ULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x000000001300720cULL, 0x000fc40003f06070ULL, 0x000000182b377810ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x0000000802127210ULL, 0x000fe40007fbe0ffULL,
0x0ffffff81e187812ULL, 0x000fe200078ec0ffULL, 0x00000001130a7824ULL, 0x040fe200078e021eULL,
0x0000000602107210ULL, 0x000fe20007f3e0ffULL, 0x0000000813337824ULL, 0x000fe200078e00ffULL,
0x000040009d207811ULL, 0x000fe200078e70ffULL, 0x00000001110b7824ULL, 0x000fe200078e022fULL,
0x0000000718277812ULL, 0x000fe200078ef817ULL, 0x0000000125137824ULL, 0x000fe200078e022fULL,
0xfffffff833337812ULL, 0x000fe200078ee20aULL, 0x0000000103117824ULL, 0x000fe200008e0607ULL,
0x000000202b397810ULL, 0x000fe20007ffe0ffULL, 0x000001000d067825ULL, 0x000fc800078e0004ULL,
0x00000100130c7825ULL, 0x000fc800078e0004ULL, 0x0000000103137824ULL, 0x000fe200028e0609ULL,
0x0000000602147210ULL, 0x040fe20007fbe0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0004ULL,
0x0000002f37097210ULL, 0x080fe40007ffe0ffULL, 0x0000000c020c7210ULL, 0x040fe20007fde0ffULL,
0x0000000103157824ULL, 0x000fe200028e0607ULL, 0x0000000a020a7210ULL, 0x040fe20007f3e0ffULL,
0x0000010009067825ULL, 0x000fe200078e0004ULL, 0x000000002b00720cULL, 0x080fe40003fa6070ULL,
0x0000002f39097210ULL, 0x000fe20007ffe0ffULL, 0x00000001030b7824ULL, 0x000fe200008e060bULL,
0x000000002500720cULL, 0x000fe20003f26070ULL, 0x00000001030d7824ULL, 0x000fe200030e060dULL,
0x0000000602167210ULL, 0x000fe20007fde0ffULL, 0x0000000125087824ULL, 0x000fc400078e021eULL,
0x0000000825357824ULL, 0x000fe200078e00ffULL, 0x0000001c2b257810ULL, 0x000fe20007ffe0ffULL,
0x0000000103177824ULL, 0x000fe400030e0607ULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0xfffffff835357812ULL, 0x000fe200078ee208ULL, 0x0000000125077824ULL, 0x000fe400078e022fULL,
0x0000001029297824ULL, 0x000fe200078e0220ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e277faeULL, 0x0003e2000e901c46ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000003700720cULL, 0x000fc40003fa6070ULL, 0x0000000010297faeULL, 0x0005e2000e101c46ULL,
0x0000000137267824ULL, 0x040fe200078e021eULL, 0x0000000602247210ULL, 0x000fe20007fde0ffULL,
0x0000000837377824ULL, 0x000fe200078e00ffULL, 0x000000002500720cULL, 0x000fe20003f86070ULL,
0x0000010009087825ULL, 0x000fc800078e0004ULL, 0x0000000125067824ULL, 0x040fe400078e021eULL,
0x00000008250f7824ULL, 0x002fe200078e00ffULL, 0xfffffff837297812ULL, 0x004fe200078ee226ULL,
0x000000102d117824ULL, 0x100fe200078e0220ULL, 0x000000242b2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103257824ULL, 0x000fe200030e0607ULL, 0x0000000802087210ULL, 0x000fe20007fde0ffULL,
0x0000001031277824ULL, 0x000fe200078e0220ULL, 0xfffffff80f377812ULL, 0x000fe200078ee206ULL,
0x000000012d077824ULL, 0x000fe200078e022fULL, 0x0000001e390f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000103097824ULL, 0x000fe200030e0609ULL, 0x0000000012117faeULL, 0x0003e2000d101c46ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000002d00720cULL, 0x000fc40003f46070ULL,
0x000000000a277faeULL, 0x0005e2000d901c46ULL, 0x0000000839267824ULL, 0x000fe200078e00ffULL,
0x00000006020e7210ULL, 0x000fe20007fde0ffULL, 0x000000012d107824ULL, 0x000fe200078e021eULL,
0x000000003900720cULL, 0x000fe20003f66070ULL, 0x000000082d317824ULL, 0x000fe200078e00ffULL,
0xfffffff8262d7812ULL, 0x000fe200078ee20fULL, 0x00000001030f7824ULL, 0x000fe400030e0607ULL,
0x0000001033117824ULL, 0x002fe200078e0220ULL, 0xfffffff831317812ULL, 0x000fe200078ee210ULL,
0x0000001035077824ULL, 0x100fe200078e0220ULL, 0x000000302b337810ULL, 0x000fe20007ffe0ffULL,
0x00000010290b7824ULL, 0x104fe200078e0220ULL, 0x000000282b297810ULL, 0x000fe20007ffe0ffULL,
0x0000000014117faeULL, 0x0003e2000c101c46ULL, 0x0000001037137824ULL, 0x100fe200078e0220ULL,
0x000000342b357810ULL, 0x000fe20007ffe0ffULL, 0x000000102d277824ULL, 0x000fe200078e0220ULL,
0x000000000c077faeULL, 0x0005e2000c901c46ULL, 0x0000001e29067210ULL, 0x000fc40007ffe0ffULL,
0x0000002c2b2d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000160b7faeULL, 0x0007e2000e901c46ULL,
0x000000382b377810ULL, 0x040fe40007ffe0ffULL, 0x0000003c2b2b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000829157824ULL, 0x002fe200078e00ffULL, 0x0000000024137faeULL, 0x0003e2000e101c46ULL,
0x0000000133117824ULL, 0x100fe200078e022fULL, 0x000000002900720cULL, 0x0c0fe20003fc6070ULL,
0x0000000129077824ULL, 0x004fe200078e022fULL, 0xfffffff815157812ULL, 0x000fe200078ee206ULL,
0x00000010310d7824ULL, 0x000fe200078e0220ULL, 0x0000000008277faeULL, 0x0005e2000d901c46ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000002d00720cULL, 0x000fc40003fa6070ULL,
0x000000000e0d7faeULL, 0x0009e2000d101c46ULL, 0x00000001330b7824ULL, 0x048fe200078e021eULL,
0x00000006020a7210ULL, 0x000fe20007f5e0ffULL, 0x00000008330c7824ULL, 0x040fe200078e00ffULL,
0x000000003300720cULL, 0x080fe20003f86070ULL, 0x000000082d177824ULL, 0x000fe200078e00ffULL,
0x000000003500720cULL, 0x080fe20003f66070ULL, 0x000000012b137824ULL, 0x002fe200078e022fULL,
0xfffffff80c257812ULL, 0x000fe200078ee20bULL, 0x000000012d097824ULL, 0x004fe200078e022fULL,
0x00000007030b7210ULL, 0x000fe200017fe4ffULL, 0x0000010011067825ULL, 0x000fe200078e0004ULL,
0x000000003700720cULL, 0x000fc40003f26070ULL, 0x000000002b00720cULL, 0x000fe20003f06070ULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x0000001e2b107210ULL, 0x000fc60007ffe0ffULL,
0x00000001350f7824ULL, 0x110fe200078e022fULL, 0x00000008020c7210ULL, 0x040fe20007f5e0ffULL,
0x000000012d007824ULL, 0x000fe400078e021eULL, 0x0000000137117824ULL, 0x000fe400078e022fULL,
0x00000001030d7824ULL, 0x000fe200010e0609ULL, 0x00000006020e7210ULL, 0x000fe20007f5e0ffULL,
0x000001000f087825ULL, 0x000fe200078e0004ULL, 0xfffffff817177812ULL, 0x000fc600078ee200ULL,
0x0000000135007824ULL, 0x040fe400078e021eULL, 0x0000000835277824ULL, 0x000fe400078e00ffULL,
0x00000001030f7824ULL, 0x000fe200010e0607ULL, 0x0000000802087210ULL, 0x000fe20007f5e0ffULL,
0x0000010011067825ULL, 0x000fe200078e0004ULL, 0xfffffff827277812ULL, 0x000fc600078ee200ULL,
0x0000000137007824ULL, 0x040fe400078e021eULL, 0x0000000837297824ULL, 0x000fe400078e00ffULL,
0x0000000103097824ULL, 0x000fe200010e0609ULL, 0x0000000602067210ULL, 0x000fe20007f5e0ffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee200ULL,
0x0000010013047825ULL, 0x000fc600078e0004ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL,
0x0000000103077824ULL, 0x000fe200010e0607ULL, 0x0000000402027210ULL, 0x000fe20007f5e0ffULL,
0x0000001015117824ULL, 0x100fe400078e0220ULL, 0x0000001017137824ULL, 0x100fe200078e0220ULL,
0x0000000503037210ULL, 0x000fe200017fe4ffULL, 0x0000001025157824ULL, 0x100fe200078e0220ULL,
0x000000000a117faeULL, 0x0003e2000f101c46ULL, 0x0000001027177824ULL, 0x100fe400078e0220ULL,
0x0000001029257824ULL, 0x100fe200078e0220ULL, 0x000000000c137faeULL, 0x0003e2000e901c46ULL,
0x000000102b277824ULL, 0x000fc600078e0220ULL, 0x000000000e157faeULL, 0x0003e8000e101c46ULL,
0x0000000008177faeULL, 0x0003e8000d901c46ULL, 0x0000000006257faeULL, 0x0003e8000c901c46ULL,
0x0000000002277faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x000000041e077811ULL, 0x042fe200078fe8ffULL, 0x000000101e197824ULL, 0x040fe200078e00ffULL,
0x000000141e0f7811ULL, 0x000fc400078fe8ffULL, 0x000000081e097811ULL, 0x040fe200078fe8ffULL,
0x0000000107007824ULL, 0x140fe200078e021eULL, 0x0000000c1e0b7811ULL, 0x040fe200078fe8ffULL,
0x0000000807337824ULL, 0x000fe200078e00ffULL, 0x000000030f067819ULL, 0x040fe200000006ffULL,
0x000000010f057824ULL, 0x100fe200078e021eULL, 0x000000201e157811ULL, 0x040fe200078fe8ffULL,
0x0000000109047824ULL, 0x000fe200078e021eULL, 0xfffffff833337812ULL, 0x000fe200078ee200ULL,
0x0000000809357824ULL, 0x000fe200078e00ffULL, 0x000000101e0d7811ULL, 0x040fe200078fe8ffULL,
0x000000010b007824ULL, 0x140fe200078e021eULL, 0x000000181e117811ULL, 0x000fe200078fe8ffULL,
0x000000080b377824ULL, 0x000fe200078e00ffULL, 0xfffffff8063b7812ULL, 0x000fe200078ee205ULL,
0x0000000115057824ULL, 0x040fe200078e021eULL, 0x0000002c1e277811ULL, 0x040fe200078fe8ffULL,
0x0000000815067824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee204ULL,
0x000000010d047824ULL, 0x000fe200078e021eULL, 0xfffffff837377812ULL, 0x000fe200078ee200ULL,
0x000000080d397824ULL, 0x000fe200078e00ffULL, 0x0000001c1e137811ULL, 0x040fe200078fe8ffULL,
0x0000000111007824ULL, 0x140fe200078e021eULL, 0x000000241e177811ULL, 0x000fe200078fe8ffULL,
0x00000008113d7824ULL, 0x000fe200078e00ffULL, 0xfffffff806417812ULL, 0x000fe200078ee205ULL,
0x0000000127057824ULL, 0x040fe200078e021eULL, 0x000000381e2d7811ULL, 0x040fe200078fe8ffULL,
0x0000000827067824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee204ULL,
0x0000000113047824ULL, 0x000fe200078e021eULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee200ULL,
0x00000008133f7824ULL, 0x000fe200078e00ffULL, 0x000000281e257811ULL, 0x040fe200078fe8ffULL,
0x0000000117007824ULL, 0x140fe200078e021eULL, 0x000000301e297811ULL, 0x000fe200078fe8ffULL,
0x0000000817437824ULL, 0x000fe200078e00ffULL, 0xfffffff806477812ULL, 0x000fe200078ee205ULL,
0x000000012d057824ULL, 0x000fe200078e021eULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL,
0x000000082d067824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee200ULL,
0x0000000125047824ULL, 0x140fe200078e021eULL, 0x0000000325457819ULL, 0x000fe200000006ffULL,
0x0000000129007824ULL, 0x040fe200078e021eULL, 0x000000341e2b7811ULL, 0x040fe200078fe8ffULL,
0x0000000829497824ULL, 0x000fe200078e00ffULL, 0x0000003c1e4f7811ULL, 0x000fe200078fe8ffULL,
0x0000000107077824ULL, 0x000fe200078e022fULL, 0xfffffff8064d7812ULL, 0x000fe200078ee205ULL,
0x000000082b4b7824ULL, 0x000fe200078e00ffULL, 0x0000001e1e057211ULL, 0x040fe200078fe8ffULL,
0x0000000109097824ULL, 0x100fe200078e022fULL, 0x0ffffff81e187812ULL, 0x000fe200078ec0ffULL,
0x000000010b0b7824ULL, 0x100fe200078e022fULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x000000010d0d7824ULL, 0x100fe200078e022fULL, 0xfffffff845457812ULL, 0x000fe200078ee204ULL,
0x000000012b047824ULL, 0x000fe200078e021eULL, 0xfffffff849497812ULL, 0x000fe200078ee200ULL,
0x000000014f007824ULL, 0x040fe200078e021eULL, 0x000000034f517819ULL, 0x000fe200000006ffULL,
0x000000010f0f7824ULL, 0x000fe200078e022fULL, 0x0000000718317812ULL, 0x000fe200078ef805ULL,
0x0000000111117824ULL, 0x100fe200078e022fULL, 0x0000002f17177210ULL, 0x080fe20007ffe0ffULL,
0x0000000113137824ULL, 0x100fe200078e022fULL, 0x0000002f1e057211ULL, 0x000fe200078fe8ffULL,
0x0000000115157824ULL, 0x100fe200078e022fULL, 0x00000080192e7812ULL, 0x000fe200078efcffULL,
0x0000000125257824ULL, 0x100fe200078e022fULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee204ULL,
0x0000000127277824ULL, 0x100fe200078e022fULL, 0xfffffff851517812ULL, 0x000fe200078ee200ULL,
0x0000000129297824ULL, 0x100fe200078e022fULL, 0x000040009d007811ULL, 0x000fe200078e70ffULL,
0x000000012b2b7824ULL, 0x000fc400078e022fULL, 0x000000012d2d7824ULL, 0x100fe200078e022fULL,
0x0000000037377211ULL, 0x080fe200078e20ffULL, 0x000000014f4f7824ULL, 0x000fe200078e022fULL,
0x000000004b4b7211ULL, 0x000fe200078e20ffULL, 0x000000ffff2f7224ULL, 0x000fe400078e00ffULL,
0x0000001031317824ULL, 0x000fe400078e0200ULL, 0x0000010005047825ULL, 0x000fc800078e002eULL,
0x0000010007067825ULL, 0x000fe200078e002eULL, 0x0000000402047210ULL, 0x000fc60007f1e0ffULL,
0x0000010009087825ULL, 0x000fe200078e002eULL, 0x0000000602067210ULL, 0x000fc60007f3e0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e002eULL, 0x0000000802087210ULL, 0x000fc60007f5e0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e002eULL, 0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL,
0x000001000f0e7825ULL, 0x000fc800078e002eULL, 0x0000010011107825ULL, 0x000fc800078e002eULL,
0x0000010013127825ULL, 0x000fc800078e002eULL, 0x0000000103057824ULL, 0x040fe200000e0605ULL,
0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000103077824ULL, 0x000fe200008e0607ULL,
0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010015147825ULL, 0x100fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004317faeULL, 0x0003e6000b901c46ULL,
0x0000010017167825ULL, 0x000fc800078e002eULL, 0x0000000103097824ULL, 0x040fe200010e0609ULL,
0x0000001002107210ULL, 0x040fe20007f5e0ffULL, 0x00000001030b7824ULL, 0x000fe200018e060bULL,
0x0000001202127210ULL, 0x000fe20007f7e0ffULL, 0x0000010025247825ULL, 0x000fe200078e002eULL,
0x0000001103117210ULL, 0x000fc600017fe4ffULL, 0x0000010027267825ULL, 0x000fe200078e002eULL,
0x0000002402247210ULL, 0x000fc60007f5e0ffULL, 0x00000001030d7824ULL, 0x000fe200000e060dULL,
0x0000001402147210ULL, 0x040fe20007f1e0ffULL, 0x0000001033337824ULL, 0x100fe400078e0200ULL,
0x00000001030f7824ULL, 0x000fe200008e060fULL, 0x0000001602167210ULL, 0x000fe20007f3e0ffULL,
0x0000001035357824ULL, 0x000fe200078e0200ULL, 0x0000000006337faeULL, 0x0003e2000b901c46ULL,
0x0000010029287825ULL, 0x000fc600078e002eULL, 0x0000000008357faeULL, 0x0003e2000b901c46ULL,
0x000001002b2a7825ULL, 0x000fc600078e002eULL, 0x000000000a377faeULL, 0x0003e2000b901c46ULL,
0x0000000103137824ULL, 0x000fe200018e0613ULL, 0x0000002602267210ULL, 0x000fe20007f7e0ffULL,
0x0000001039397824ULL, 0x000fe400078e0200ULL, 0x000001002d2c7825ULL, 0x000fc600078e002eULL,
0x000000000c397faeULL, 0x0003e2000b901c46ULL, 0x000000103b3b7824ULL, 0x000fe400078e0200ULL,
0x000001004f2e7825ULL, 0x000fc600078e002eULL, 0x000000000e3b7faeULL, 0x0003e2000b901c46ULL,
0x000000103d3d7824ULL, 0x100fe400078e0200ULL, 0x0000000103157824ULL, 0x000fe200000e0615ULL,
0x0000002802287210ULL, 0x040fe20007f1e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0200ULL,
0x00000000103d7faeULL, 0x0003e2000b901c46ULL, 0x0000000103177824ULL, 0x000fe200008e0617ULL,
0x0000002a022a7210ULL, 0x040fe20007f3e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0200ULL,
0x00000000123f7faeULL, 0x0003e2000b901c46ULL, 0x0000000103257824ULL, 0x000fe200010e0625ULL,
0x0000002c022c7210ULL, 0x040fe20007f5e0ffULL, 0x0000001043437824ULL, 0x100fe200078e0200ULL,
0x0000000014417faeULL, 0x0003e2000b901c46ULL, 0x0000000103277824ULL, 0x000fe200018e0627ULL,
0x0000002e02027210ULL, 0x000fe20007f7e0ffULL, 0x0000001045457824ULL, 0x100fe200078e0200ULL,
0x0000000016437faeULL, 0x0003e2000b901c46ULL, 0x0000001047477824ULL, 0x000fc400078e0200ULL,
0x0000001049497824ULL, 0x100fe200078e0200ULL, 0x0000000024457faeULL, 0x0003e2000b901c46ULL,
0x0000000103297824ULL, 0x040fe400000e0629ULL, 0x00000001032b7824ULL, 0x000fe200008e062bULL,
0x0000000026477faeULL, 0x0003e2000b901c46ULL, 0x000000104d4d7824ULL, 0x100fe400078e0200ULL,
0x00000001032d7824ULL, 0x000fe200010e062dULL, 0x0000000028497faeULL, 0x0003e2000b901c46ULL,
0x0000001051517824ULL, 0x000fc400078e0200ULL, 0x0000000103037824ULL, 0x000fe200018e062fULL,
0x000000002a4b7faeULL, 0x0003e8000b901c46ULL, 0x000000002c4d7faeULL, 0x0003e8000b901c46ULL,
0x0000000002517faeULL, 0x0003e4000b901c46ULL, 0x0000000221217810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff207424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000232100720cULL, 0x000fda0003f06070ULL, 0x00000021a5028211ULL, 0x002fe200078e08ffULL,
0x00000004ff038424ULL, 0x000fc800078e00ffULL, 0x0000660002028625ULL, 0x000fe200078e0003ULL,
0x000000081e177812ULL, 0x000fe400078ec0ffULL, 0x00000004ff107819ULL, 0x000fe2000001161eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000602208981ULL, 0x000322000c1e1900ULL,
0x0000000717177812ULL, 0x000fe200078ef81eULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000071e6c7812ULL, 0x000fc600078ec0ffULL, 0x0000000110167824ULL, 0x000fe400078e0217ULL,
0x0000001017057824ULL, 0x000fca00078e00ffULL, 0xfffffff005007812ULL, 0x000fca00078ee216ULL,
0x0000001000647824ULL, 0x000fc400078e00ffULL, 0x0000001017137812ULL, 0x042fe200078efcffULL,
0x0000000810037824ULL, 0x040fe200078e00ffULL, 0x00000003ff157819ULL, 0x000fe2000001161eULL,
0x0000001017087824ULL, 0x000fe200078e00ffULL, 0x0000001310107210ULL, 0x000fe20007ffe0ffULL,
0x0000001013077824ULL, 0x000fe200078e00ffULL, 0xfffffff8036c7812ULL, 0x000fe200078ee26cULL,
0x000040009d147824ULL, 0x000fe200078e00ffULL, 0x0000000216037810ULL, 0x000fe20007ffe0ffULL,
0x0000001013097824ULL, 0x000fe200078e00ffULL, 0xfffffff007027812ULL, 0x000fe200078ee210ULL,
0x000000086c117824ULL, 0x000fe200078e00ffULL, 0xfffffff008087812ULL, 0x000fe200078ee203ULL,
0x000000006464783bULL, 0x000fe20000000200ULL, 0x0000000115057812ULL, 0x000fe200078ec0ffULL,
0x00000010023c7824ULL, 0x000fe200078e00ffULL, 0x000000106c7c7810ULL, 0x040fe20007ffe0ffULL,
0x000000086c257824ULL, 0x040fe200078e00ffULL, 0x000000206c037810ULL, 0x040fe20007ffe0ffULL,
0x0000000105007824ULL, 0x040fe200078e026cULL, 0x000000306c027810ULL, 0x000fe20007ffe0ffULL,
0x00000001050f7824ULL, 0x040fe200078e027cULL, 0x0000200014127810ULL, 0x000fe20007ffe0ffULL,
0x00000001050e7824ULL, 0x000fe200078e0203ULL, 0xfffffff811117812ULL, 0x000fe200078ee200ULL,
0x00000001050d7824ULL, 0x000fe200078e0202ULL, 0x0000000303057819ULL, 0x000fe200000006ffULL,
0x000000087c067824ULL, 0x000fe200078e00ffULL, 0x0000000210047810ULL, 0x000fe20007ffe0ffULL,
0x00000008020a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8050e7812ULL, 0x000fe200078ee20eULL,
0x0000001011607824ULL, 0x100fe200078e0212ULL, 0xfffffff8060f7812ULL, 0x000fe200078ee20fULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0xfffffff80a0d7812ULL, 0x000fe200078ee20dULL,
0x000000100e787824ULL, 0x000fe200078e0212ULL, 0xfffffff009097812ULL, 0x000fe200078ee204ULL,
0x000000100f047824ULL, 0x100fe200078e0212ULL, 0x000000006060783bULL, 0x000e620000000200ULL,
0x000000100d687824ULL, 0x100fe200078e0212ULL, 0x00000012000b7810ULL, 0x000fe20007ffe0ffULL,
0x000000087c0a7824ULL, 0x000fe200078e00ffULL, 0x000000007878783bULL, 0x000fe20000000200ULL,
0x0000000409247819ULL, 0x000fe200000006ffULL, 0x0000000803297824ULL, 0x000fe200078e00ffULL,
0x00000002000c7810ULL, 0x000fe20007ffe0ffULL, 0x000000000404783bULL, 0x000ea20000000200ULL,
0xfffffff80a0b7812ULL, 0x000fe200078ee20bULL, 0x0000000802097824ULL, 0x000fe200078e00ffULL,
0x00000022000a7810ULL, 0x040fe20007ffe0ffULL, 0x000000006868783bULL, 0x000ee20000000200ULL,
0x0000003200287810ULL, 0x000fe20007ffe0ffULL, 0x000000100b5c7824ULL, 0x000fe200078e0212ULL,
0xfffffff8250c7812ULL, 0x000fe200078ee20cULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0xfffffff8290a7812ULL, 0x000fe200078ee20aULL, 0x000000002424783bULL, 0x000fe20000000200ULL,
0xfffffff809097812ULL, 0x000fe200078ee228ULL, 0x000000100c387824ULL, 0x100fe200078e0212ULL,
0x000000037c887819ULL, 0x000fe200000006ffULL, 0x000000100a747824ULL, 0x100fe200078e0212ULL,
0x000000000854783bULL, 0x0003e20000000200ULL, 0x0000001009287824ULL, 0x000fe200078e0212ULL,
0x0000002600877810ULL, 0x000fe20007ffe0ffULL, 0x000000086c717824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x00000008038a7824ULL, 0x000fc400078e00ffULL,
0x0000000802897824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000ee20000000200ULL,
0x0000000416087810ULL, 0x002fc60007ffe0ffULL, 0x000000007474783bULL, 0x000e680000000200ULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x00000060642c723cULL, 0x040f7000000418ffULL,
0x000000626434723cULL, 0x040f7000000418ffULL, 0x000000046440723cULL, 0x044f7000000418ffULL,
0x000000066444723cULL, 0x040f7000000418ffULL, 0x000000786448723cULL, 0x040f7000000418ffULL,
0x0000007a644c723cULL, 0x040f7000000418ffULL, 0x000000686450723cULL, 0x048f7000000418ffULL,
0x0000006a6464723cULL, 0x000f7000000418ffULL, 0x000000043c58723cULL, 0x040f7000000418ffULL,
0x000000063c04723cULL, 0x040ff000000418ffULL, 0x000000603c30723cULL, 0x040f7000000418ffULL,
0x000000623c60723cULL, 0x000f7000000418ffULL, 0x00000038542c723cULL, 0x060ff0000004182cULL,
0x0000003a5434723cULL, 0x040ff00000041834ULL, 0x0000005c5440723cULL, 0x040ff00000041840ULL,
0x0000005e5444723cULL, 0x040ff00000041844ULL, 0x000000745448723cULL, 0x042ff00000041848ULL,
0x00000076544c723cULL, 0x040ff0000004184cULL, 0x000000285450723cULL, 0x040ff00000041850ULL,
0x0000002a5454723cULL, 0x000bee0000041864ULL, 0x0000001017657824ULL, 0x020fe200078e00ffULL,
0x000000683c80723cULL, 0x000be200000418ffULL, 0x0000001013677824ULL, 0x000fe200078e00ffULL,
0x0000000610667810ULL, 0x000fc40007ffe0ffULL, 0xfffffff065647812ULL, 0x000fe400078ee208ULL,
0x0000000400087810ULL, 0x000fe20007ffe0ffULL, 0x0000001017687824ULL, 0x020fe200078e00ffULL,
0x0000005c2458723cULL, 0x000be20000041858ULL, 0x0000001013697824ULL, 0x000fe400078e00ffULL,
0x0000001064647824ULL, 0x000fc600078e00ffULL, 0xfffffff069867812ULL, 0x000fe200078ee266ULL,
0x0000000802667824ULL, 0x000fe200078e00ffULL, 0x00000006165d7810ULL, 0x020fe20007ffe0ffULL,
0x000000382430723cULL, 0x040fe20000041830ULL, 0x00000004105c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000803697824ULL, 0x000fe200078e00ffULL, 0xfffffff068857812ULL, 0x000fe200078ee25dULL,
0x00000010868c7824ULL, 0x000fe200078e00ffULL, 0xfffffff067657812ULL, 0x000fe200078ee25cULL,
0x000000086c677824ULL, 0x000fe200078e00ffULL, 0x0000001600037810ULL, 0x000fe20007ffe0ffULL,
0x0000005e245c723cULL, 0x040be20000041804ULL, 0x0000001085857824ULL, 0x000fe200078e00ffULL,
0xfffffff88a027812ULL, 0x000fe200078ee287ULL, 0x00000010656c7824ULL, 0x000fe200078e00ffULL,
0xfffffff867087812ULL, 0x000fe200078ee208ULL, 0x000000008c8c783bULL, 0x000fe20000000200ULL,
0xfffffff888037812ULL, 0x000fe200078ee203ULL, 0x0000001002947824ULL, 0x100fe200078e0212ULL,
0x0000001400077810ULL, 0x020fe20007ffe0ffULL, 0x0000003a2438723cULL, 0x000fe20000041860ULL,
0x000000037c047819ULL, 0x000fe200000006ffULL, 0x000000006c6c783bULL, 0x000fe20000000200ULL,
0x0000003400057810ULL, 0x000fe20007ffe0ffULL, 0x0000001008687824ULL, 0x100fe200078e0212ULL,
0xfffffff804077812ULL, 0x000fe200078ee207ULL, 0x0000001003907824ULL, 0x100fe200078e0212ULL,
0xfffffff866057812ULL, 0x000fe200078ee205ULL, 0x000000783c60723cULL, 0x000f6200000418ffULL,
0x0000000600047810ULL, 0x000fe20007ffe0ffULL, 0x0000001007707824ULL, 0x100fe200078e0212ULL,
0x000000006464783bULL, 0x000fe20000000200ULL, 0x00000010057d7824ULL, 0x000fe200078e0212ULL,
0xfffffff871047812ULL, 0x000fc400078ee204ULL, 0x0000002400067810ULL, 0x040fe20007ffe0ffULL,
0x0000007a3c78723cULL, 0x040f6200000418ffULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x0000003600007810ULL, 0x000fe20007ffe0ffULL, 0x0000001004887824ULL, 0x000fe200078e0212ULL,
0xfffffff869067812ULL, 0x000fe200078ee206ULL, 0x000000007d7c783bULL, 0x000ea20000000200ULL,
0xfffffff889007812ULL, 0x000fe400078ee200ULL, 0x0000006a3c3c723cULL, 0x000b6200000418ffULL,
0x0000001006847824ULL, 0x100fe200078e0212ULL, 0x000000006868783bULL, 0x020ee80000000200ULL,
0x000000009090783bULL, 0x000fe40000000200ULL, 0x000000742460723cULL, 0x040fe40000041860ULL,
0x000000008888783bULL, 0x000fe80000000200ULL, 0x000000009494783bULL, 0x000fe40000000200ULL,
0x000000762474723cULL, 0x040be40000041878ULL, 0x000000008478783bULL, 0x020ee80000000200ULL,
0x000000008584783bULL, 0x000ee40000000200ULL, 0x000000282480723cULL, 0x040b6e0000041880ULL,
0x0000001000287824ULL, 0x020fe200078e0212ULL, 0x0000002a243c723cULL, 0x000b68000004183cULL,
0x000000002824783bULL, 0x020ee80000000200ULL, 0x000000706440723cULL, 0x082f700000041840ULL,
0x000000706c58723cULL, 0x000f700000041858ULL, 0x0000007c6450723cULL, 0x084f700000041850ULL,
0x0000007c6c80723cULL, 0x000f700000041880ULL, 0x0000007e6454723cULL, 0x080f700000041854ULL,
0x0000007e6c3c723cULL, 0x000f70000004183cULL, 0x00000068642c723cULL, 0x088f70000004182cULL,
0x000000686c30723cULL, 0x000f700000041830ULL, 0x0000006a6434723cULL, 0x080f700000041834ULL,
0x0000006a6c38723cULL, 0x000f700000041838ULL, 0x000000726444723cULL, 0x040f700000041844ULL,
0x000000786448723cULL, 0x040f700000041848ULL, 0x0000007a644c723cULL, 0x000f70000004184cULL,
0x000000726c5c723cULL, 0x040f70000004185cULL, 0x000000786c60723cULL, 0x040f700000041860ULL,
0x0000007a6c74723cULL, 0x000f700000041874ULL, 0x000000908440723cULL, 0x0a0f700000041840ULL,
0x000000908c58723cULL, 0x000b6e0000041858ULL, 0x0000030099907a10ULL, 0x020fe20007ffe0ffULL,
0x000000248450723cULL, 0x080f700000041850ULL, 0x000000248c80723cULL, 0x000b6e0000041880ULL,
0x0000000190257810ULL, 0x020fe20007ffe0ffULL, 0x000000268454723cULL, 0x000f660000041854ULL,
0x000000222500720cULL, 0x000fe20003f06070ULL, 0x000000a220257224ULL, 0x010fc800078e02ffULL,
0x000000268c3c723cULL, 0x000b62000004183cULL, 0x0000640025247625ULL, 0x000fcc00078e00a4ULL,
0x0000010090277824ULL, 0x020fe200078e02a3ULL, 0x00000088842c723cULL, 0x000b68000004182cULL,
0x0000004027667812ULL, 0x000fc800078ec0ffULL, 0x000000888c30723cULL, 0x000b620000041830ULL,
0x000000661f667210ULL, 0x000fce0007ffe0ffULL, 0x0000008a8434723cULL, 0x080b700000041834ULL,
0x0000008a8c38723cULL, 0x000b700000041838ULL, 0x000000928444723cULL, 0x040b700000041844ULL,
0x000000948448723cULL, 0x040b700000041848ULL, 0x00000096844c723cULL, 0x000b70000004184cULL,
0x000000928c5c723cULL, 0x040b70000004185cULL, 0x000000948c60723cULL, 0x040b700000041860ULL,
0x000000968c74723cULL, 0x000b620000041874ULL, 0x00000c4000008947ULL, 0x000fce0003800000ULL,
0x00000004152b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000115297824ULL, 0x040fe200078e021eULL,
0x0000000815677810ULL, 0x000fc40007ffe0ffULL, 0x00000027986a7217ULL, 0x000fe20007800000ULL,
0x000000012b267824ULL, 0x100fe200078e021eULL, 0x00000010156f7810ULL, 0x000fe20007ffe0ffULL,
0x000000082b717824ULL, 0x000fe200078e00ffULL, 0x00000007186b7812ULL, 0x000fe200078ef829ULL,
0x0000000167287824ULL, 0x000fe200078e021eULL, 0x00000014157d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000867737824ULL, 0x000fe200078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee226ULL,
0x0000000115267824ULL, 0x040fe200078e0266ULL, 0x0000000c156d7810ULL, 0x000fe20007ffe0ffULL,
0x000000016a6a7824ULL, 0x000fe200078e0a27ULL, 0xfffffff873737812ULL, 0x000fe200078ee228ULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x000000036d797819ULL, 0x000fc400000006ffULL,
0x0000006a2b00720cULL, 0x080fe20003f46070ULL, 0x000000016f297824ULL, 0x040fe200078e021eULL,
0x0000001926657212ULL, 0x000fe200078efcffULL, 0x000000086f2a7824ULL, 0x000fe200078e00ffULL,
0x0000006a6d00720cULL, 0x080fe20003fa6070ULL, 0x000000012b287824ULL, 0x000fe200078e0266ULL,
0x0000006524647210ULL, 0x000fe20007f1e0ffULL, 0x000000017d267824ULL, 0x000fe200078e021eULL,
0xfffffff82a7b7812ULL, 0x000fe200078ee229ULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000006a6f00720cULL, 0x000fc40003f86070ULL, 0x0000006a6700720cULL, 0x080fe20003f66070ULL,
0x000000087d7f7824ULL, 0x000fe200078e00ffULL, 0x0000001928697212ULL, 0x000fe200078efcffULL,
0x000000016d2a7824ULL, 0x000fe200078e0266ULL, 0x0000006a1500720cULL, 0x000fe20003f26070ULL,
0x0000000125657824ULL, 0x000fe200000e0627ULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee226ULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000006924687210ULL, 0x000fe40007f1e0ffULL,
0x0000001815857810ULL, 0x020fe20007ffe0ffULL, 0x0000000167267824ULL, 0x100fe200078e0266ULL,
0x0000002015897810ULL, 0x000fe20007ffe0ffULL, 0x000000016f287824ULL, 0x000fc400078e0266ULL,
0x000000016d187824ULL, 0x000fe200078e021eULL, 0x000000192a6d7212ULL, 0x000fe200078efcffULL,
0x0000010026267825ULL, 0x000fc600078e00ffULL, 0x0000006d246c7210ULL, 0x000fe20007fde0ffULL,
0x0000000125697824ULL, 0x000fe200000e0629ULL, 0x00000019266f7212ULL, 0x000fe200078efcffULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fe400078ee218ULL,
0x0000006f246e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001256d7824ULL, 0x000fe200030e062bULL,
0x0000001928677212ULL, 0x000fe200078efcffULL, 0x000000017d287824ULL, 0x000fe200078e0266ULL,
0x0000001e85187210ULL, 0x000fe20007ffe0ffULL, 0x00000001256f7824ULL, 0x000fe200000e0627ULL,
0x0000006724267210ULL, 0x000fe20007fde0ffULL, 0x000000106b2b7824ULL, 0x000fe200078e0212ULL,
0x0000006a7d00720cULL, 0x080fe20003f06070ULL, 0x00000001852a7824ULL, 0x000fe200078e0266ULL,
0x0000001c157d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125277824ULL, 0x000fe200030e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000642b7faeULL, 0x0003e2000c901c46ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000006a8500720cULL, 0x000fc40003f26070ULL,
0x0000001e896b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000885877824ULL, 0x000fe200078e00ffULL,
0x0000001928677212ULL, 0x000fe200078efcffULL, 0x000000087d857824ULL, 0x000fe400078e00ffULL,
0x0000000889707824ULL, 0x000fe200078e00ffULL, 0x0000006724287210ULL, 0x000fe20007fde0ffULL,
0x0000001071677824ULL, 0x000fe200078e0212ULL, 0xfffffff887877812ULL, 0x000fe200078ee218ULL,
0x000001002a2a7825ULL, 0x002fe200078e00ffULL, 0xfffffff8708b7812ULL, 0x000fc400078ee26bULL,
0x0000000068677faeULL, 0x0003e2000d101c46ULL, 0x000000017d187824ULL, 0x040fe200078e021eULL,
0x000000192a657212ULL, 0x000fe200078efcffULL, 0x000000017d647824ULL, 0x040fe200078e0266ULL,
0x0000006a7d00720cULL, 0x000fe20003f46070ULL, 0x0000000125297824ULL, 0x000fe200030e0629ULL,
0x00000065242a7210ULL, 0x000fe20007fde0ffULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0xfffffff885857812ULL, 0x000fe400078ee218ULL, 0x00000030157d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000189187824ULL, 0x000fe200078e0266ULL, 0x0000001964717212ULL, 0x000fe200078efcffULL,
0x00000010736b7824ULL, 0x000fe200078e0212ULL, 0x0000002415737810ULL, 0x000fe20007ffe0ffULL,
0x0000010018687825ULL, 0x002fc600078e00ffULL, 0x000000006e6b7faeULL, 0x0003e2000d901c46ULL,
0x00000001252b7824ULL, 0x000fe200030e062bULL, 0x0000007124647210ULL, 0x000fe20007fde0ffULL,
0x0000001079677824ULL, 0x000fe200078e0212ULL, 0x0000006a8900720cULL, 0x080fe20003f66070ULL,
0x0000000173187824ULL, 0x100fe400078e0266ULL, 0x0000000125657824ULL, 0x000fe200030e0665ULL,
0x000000006c677faeULL, 0x0005e2000e901c46ULL, 0x0000006a7300720cULL, 0x000fe20003fa6070ULL,
0x000000017d707824ULL, 0x000fc400078e0266ULL, 0x00000001736e7824ULL, 0x042fe200078e021eULL,
0x00000003736f7819ULL, 0x000fe200000006ffULL, 0x0000010070707825ULL, 0x000fe200078e00ffULL,
0x00000019686b7212ULL, 0x000fe400078efcffULL, 0xfffffff86f737812ULL, 0x000fe400078ee26eULL,
0x0000006b24687210ULL, 0x000fe20007fde0ffULL, 0x00000100186c7825ULL, 0x004fe200078e00ffULL,
0x00000028156f7810ULL, 0x000fc60007ffe0ffULL, 0x000000107b6b7824ULL, 0x000fe200078e0212ULL,
0x000000196c677212ULL, 0x000fe200078efcffULL, 0x000000016f6e7824ULL, 0x040fe400078e021eULL,
0x000000086f797824ULL, 0x040fe200078e00ffULL, 0x00000000266b7faeULL, 0x0003e2000e101c46ULL,
0x0000006a6f00720cULL, 0x040fe20003f86070ULL, 0x000000016f187824ULL, 0x000fe200078e0266ULL,
0x0000002c156f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125697824ULL, 0x000fe200030e0669ULL,
0x00000067246c7210ULL, 0x000fe20007fde0ffULL, 0x000000107f677824ULL, 0x000fe200078e0212ULL,
0xfffffff879797812ULL, 0x000fe200078ee26eULL, 0x000000086f7b7824ULL, 0x040fe200078e00ffULL,
0x000000666f6e7210ULL, 0x000fe20007ffe0ffULL, 0x00000001256d7824ULL, 0x000fe200030e066dULL,
0x0000000028677faeULL, 0x0005e2000c101c46ULL, 0x0000010018267825ULL, 0x002fe200078e00ffULL,
0x0000006a6f00720cULL, 0x000fc40003f06070ULL, 0x00000034157f7810ULL, 0x000fe20007ffe0ffULL,
0x000000016f187824ULL, 0x000fe200078e021eULL, 0x00000019266b7212ULL, 0x000fe200078efcffULL,
0x000001006e6e7825ULL, 0x000fc600078e00ffULL, 0x0000006b24267210ULL, 0x000fe20007fde0ffULL,
0x0000001073737824ULL, 0x100fe200078e0212ULL, 0x000000196e297212ULL, 0x084fe200078efcffULL,
0x0000001087677824ULL, 0x100fe200078e0212ULL, 0x00000019706b7212ULL, 0x000fe200078efcffULL,
0x0000000125277824ULL, 0x000fe200030e0627ULL, 0x0000002924287210ULL, 0x040fe40007fde0ffULL,
0x000000002a677faeULL, 0x0003e2000c901c46ULL, 0x0000003c15877810ULL, 0x000fe40007ffe0ffULL,
0x0000000125297824ULL, 0x000fe200030e066fULL, 0x0000006b246e7210ULL, 0x000fe20007fde0ffULL,
0x00000010856b7824ULL, 0x000fe200078e0212ULL, 0x0000003815857810ULL, 0x000fc40007ffe0ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee218ULL, 0x00000001256f7824ULL, 0x000fe200030e0671ULL,
0x0000006a7d00720cULL, 0x040fe20003f26070ULL, 0x000000017d187824ULL, 0x000fe200078e021eULL,
0x000000667f2a7210ULL, 0x002fe20007ffe0ffULL, 0x000000087d7d7824ULL, 0x000fe200078e00ffULL,
0x00000000646b7faeULL, 0x0003e2000d101c46ULL, 0x000000108b677824ULL, 0x000fe200078e0212ULL,
0x0000006a8700720cULL, 0x000fe20003f46070ULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fc400078ee218ULL, 0x0000000068677faeULL, 0x0005e2000d901c46ULL,
0x000000017f187824ULL, 0x000fe200078e021eULL, 0x000000192a717212ULL, 0x000fe200078efcffULL,
0x00000001852a7824ULL, 0x100fe200078e0266ULL, 0x000000006c737faeULL, 0x0007e2000e901c46ULL,
0x0000006a7f00720cULL, 0x080fe20003fa6070ULL, 0x0000000187647824ULL, 0x002fe200078e0266ULL,
0x0000007124707210ULL, 0x000fe20007fde0ffULL, 0x000000087f6b7824ULL, 0x000fe200078e00ffULL,
0x0000006a8500720cULL, 0x000fe20003f66070ULL, 0x0000010064647825ULL, 0x000fc600078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee218ULL, 0x0000000125717824ULL, 0x000fe400030e062bULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000003856d7819ULL, 0x008fc600000006ffULL,
0x0000000185667824ULL, 0x100fe200078e021eULL, 0x000000192a157212ULL, 0x080fe200078efcffULL,
0x0000000187677824ULL, 0x044fe200078e021eULL, 0x0000001964197212ULL, 0x000fe200078efcffULL,
0x0000000887687824ULL, 0x000fe200078e00ffULL, 0x00000015242a7210ULL, 0x000fe20007fde0ffULL,
0x0000001079157824ULL, 0x000fe200078e0212ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee266ULL,
0x000000107d697824ULL, 0x100fe200078e0212ULL, 0xfffffff868737812ULL, 0x000fe200078ee267ULL,
0x00000001252b7824ULL, 0x000fe200030e062bULL, 0x0000001924187210ULL, 0x000fe20007fde0ffULL,
0x000000107b677824ULL, 0x100fe200078e0212ULL, 0x0000000026157faeULL, 0x0003e2000e101c46ULL,
0x000000106b6b7824ULL, 0x100fe200078e0212ULL, 0x0000006525197210ULL, 0x000fe200037fe4ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0212ULL, 0x0000000028677faeULL, 0x0003e2000c101c46ULL,
0x0000001073737824ULL, 0x000fc600078e0212ULL, 0x000000006e697faeULL, 0x0003e8000c901c46ULL,
0x00000000706b7faeULL, 0x0003e8000e901c46ULL, 0x000000002a6d7faeULL, 0x0003e8000d901c46ULL,
0x0000000018737faeULL, 0x0003e2000d101c46ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x00000004152b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000115277824ULL, 0x040fe200078e021eULL,
0x0000000c156b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000815677810ULL, 0x000fe20007ffe0ffULL,
0x000000012b267824ULL, 0x100fe200078e021eULL, 0x0000001415717810ULL, 0x000fe20007ffe0ffULL,
0x000000082b657824ULL, 0x000fe200078e00ffULL, 0x0000001c157d7810ULL, 0x000fe20007ffe0ffULL,
0x000000016b2a7824ULL, 0x000fe200078e021eULL, 0x0000001815797810ULL, 0x000fe20007ffe0ffULL,
0x000000086b6d7824ULL, 0x000fe200078e00ffULL, 0xfffffff865657812ULL, 0x000fe200078ee226ULL,
0x0000000167287824ULL, 0x000fe200078e021eULL, 0x0000001e71267210ULL, 0x080fe20007ffe0ffULL,
0x0000000867697824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee22aULL,
0x0000000871737824ULL, 0x000fe200078e00ffULL, 0x0000002415877810ULL, 0x020fe20007ffe0ffULL,
0x000000017d2a7824ULL, 0x000fe200078e021eULL, 0x0000002c158b7810ULL, 0x000fe20007ffe0ffULL,
0x000000087d7f7824ULL, 0x000fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe200078ee228ULL,
0x0000000179287824ULL, 0x000fe200078e021eULL, 0xfffffff873737812ULL, 0x000fe200078ee226ULL,
0x00000008797b7824ULL, 0x000fe200078e00ffULL, 0x0000002815897810ULL, 0x000fe20007ffe0ffULL,
0x0000000187267824ULL, 0x000fe200078e021eULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee22aULL,
0x0000000887a77824ULL, 0x000fe200078e00ffULL, 0x0000000718297812ULL, 0x000fe200078ef827ULL,
0x000000018b2a7824ULL, 0x000fe200078e021eULL, 0x0000001015277810ULL, 0x000fe20007ffe0ffULL,
0x000000088bab7824ULL, 0x000fe200078e00ffULL, 0x00000030158d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000889a97824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee228ULL,
0x0000000127187824ULL, 0x000fe200078e021eULL, 0xfffffff8a7a77812ULL, 0x000fe200078ee226ULL,
0x0000000115267824ULL, 0x000fe200078e0266ULL, 0x0000001e89287210ULL, 0x000fe20007ffe0ffULL,
0x00000008276f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8abab7812ULL, 0x000fe200078ee22aULL,
0x00000001672a7824ULL, 0x100fe200078e0266ULL, 0x0000002015857810ULL, 0x000fe20007ffe0ffULL,
0x0000000127677824ULL, 0x000fe200078e0266ULL, 0x00000034158f7810ULL, 0x000fe20007ffe0ffULL,
0x000000088d867824ULL, 0x000fe200078e00ffULL, 0x0000003815917810ULL, 0x040fe20007ffe0ffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x0000003c15937810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8a9a97812ULL, 0x000fe200078ee228ULL, 0x000000018d157824ULL, 0x000fe200078e021eULL,
0x00000066796a7210ULL, 0x000fe20007ffe0ffULL, 0x000000012b287824ULL, 0x000fe200078e0266ULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee218ULL, 0x000000016b647824ULL, 0x100fe200078e0266ULL,
0xfffffff8866b7812ULL, 0x000fe200078ee215ULL, 0x0000000187707824ULL, 0x000fe200078e0266ULL,
0x0000001926157212ULL, 0x000fe200078efcffULL, 0x00000001912b7824ULL, 0x000fe200078e021eULL,
0x000000126bad7211ULL, 0x000fe200078e20ffULL, 0x0000000891887824ULL, 0x000fe200078e00ffULL,
0x0000001524267210ULL, 0x000fe20007f1e0ffULL, 0x0000001029877824ULL, 0x000fc400078e0212ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0xfffffff888797812ULL, 0x000fc600078ee22bULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001928157212ULL, 0x000fc600078efcffULL,
0x0000000171687824ULL, 0x100fe200078e0266ULL, 0x0000001524287210ULL, 0x000fe20007f3e0ffULL,
0x000000017d6c7824ULL, 0x100fe200078e0266ULL, 0x000000192a157212ULL, 0x000fe200078efcffULL,
0x00000001856e7824ULL, 0x100fe400078e0266ULL, 0x0000000189727824ULL, 0x100fe400078e0266ULL,
0x000000018b787824ULL, 0x100fe200078e0266ULL, 0x00000012698b7211ULL, 0x000fe200078e20ffULL,
0x000000018d7a7824ULL, 0x000fc400078e0266ULL, 0x000000018f7c7824ULL, 0x100fe400078e0266ULL,
0x00000001917e7824ULL, 0x100fe400078e0266ULL, 0x0000000193847824ULL, 0x040fe400078e0266ULL,
0x0000000193667824ULL, 0x040fe400078e021eULL, 0x00000008937d7824ULL, 0x000fe400078e00ffULL,
0x0000001065897824ULL, 0x000fc400078e0212ULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fc600078ee266ULL, 0x0000000185187824ULL, 0x040fe400078e021eULL,
0x0000000885977824ULL, 0x000fe400078e00ffULL, 0x0000000125277824ULL, 0x000fe200000e0627ULL,
0x00000015242a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010067667825ULL, 0x000fe200078e00ffULL,
0x0000001964157212ULL, 0x080fe400078efcffULL, 0xfffffff897977812ULL, 0x000fe200078ee218ULL,
0x000000106d8d7824ULL, 0x000fe200078e0212ULL, 0x00000019666d7212ULL, 0x000fe200078efcffULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x0000001e8f187210ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026877faeULL, 0x0003e4000b901c46ULL,
0x000000088f717824ULL, 0x000fc400078e00ffULL, 0x00000001252b7824ULL, 0x040fe200000e062bULL,
0x0000001524647210ULL, 0x000fe20007f1e0ffULL, 0x0000000125297824ULL, 0x000fe200008e0629ULL,
0x0000001968157212ULL, 0x000fe200078efcffULL, 0x000001006a6a7825ULL, 0x000fe200078e00ffULL,
0x0000006d24667210ULL, 0x000fe40007f3e0ffULL, 0xfffffff871717812ULL, 0x000fe200078ee218ULL,
0x000001006c6c7825ULL, 0x000fe200078e00ffULL, 0x0000000028897faeULL, 0x0003e6000b901c46ULL,
0x000000106f8f7824ULL, 0x100fe200078e0212ULL, 0x000000196a6f7212ULL, 0x000fe200078efcffULL,
0x0000000125657824ULL, 0x000fe200000e0665ULL, 0x0000001524687210ULL, 0x000fe20007f1e0ffULL,
0x0000001071b17824ULL, 0x100fe200078e0212ULL, 0x000000196c157212ULL, 0x000fe200078efcffULL,
0x0000010070707825ULL, 0x000fe200078e00ffULL, 0x0000006f246a7210ULL, 0x040fe20007f5e0ffULL,
0x000000002a8b7faeULL, 0x0003e4000b901c46ULL, 0x0000001073917824ULL, 0x000fe200078e0212ULL,
0x0000006b256b7210ULL, 0x040fe200017fe4ffULL, 0x0000000125697824ULL, 0x000fe200000e0669ULL,
0x00000015246c7210ULL, 0x000fe20007f1e0ffULL, 0x000001006e6e7825ULL, 0x000fe200078e00ffULL,
0x0000001970157212ULL, 0x000fe200078efcffULL, 0x00000000648d7faeULL, 0x0003e4000b901c46ULL,
0x0000010072727825ULL, 0x000fc800078e00ffULL, 0x0000001079b57824ULL, 0x100fe400078e0212ULL,
0x000000107b937824ULL, 0x000fe200078e0212ULL, 0x000000196e7b7212ULL, 0x000fe200078efcffULL,
0x0000010078787825ULL, 0x000fc800078e00ffULL, 0x000000107db77824ULL, 0x100fe200078e0212ULL,
0x00000019727d7212ULL, 0x000fe200078efcffULL, 0x00000001256d7824ULL, 0x040fe200000e066dULL,
0x0000001524707210ULL, 0x040fe20007f1e0ffULL, 0x0000000125677824ULL, 0x000fe200008e0667ULL,
0x0000007b246e7210ULL, 0x000fe20007f3e0ffULL, 0x000001007a7a7825ULL, 0x000fe200078e00ffULL,
0x0000001978157212ULL, 0x000fe400078efcffULL, 0x0000007d24727210ULL, 0x000fe20007f5e0ffULL,
0x000000107f957824ULL, 0x000fe200078e0212ULL, 0x00000000668f7faeULL, 0x0003e2000b901c46ULL,
0x000001007c7c7825ULL, 0x000fc600078e00ffULL, 0x0000000068917faeULL, 0x0003e2000b901c46ULL,
0x0000000125717824ULL, 0x040fe200000e0671ULL, 0x0000001524787210ULL, 0x000fe20007f1e0ffULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x000000197a157212ULL, 0x080fe200078efcffULL,
0x000000006a937faeULL, 0x0003e2000b901c46ULL, 0x000000197caf7212ULL, 0x080fe200078efcffULL,
0x0000010084847825ULL, 0x000fe200078e00ffULL, 0x000000197eb37212ULL, 0x080fe200078efcffULL,
0x000000006c957faeULL, 0x0003e4000b901c46ULL, 0x0000000125797824ULL, 0x040fe200000e0679ULL,
0x0000001984197212ULL, 0x000fe200078efcffULL, 0x00000001256f7824ULL, 0x000fe200008e066fULL,
0x0000001524187210ULL, 0x040fe20007f1e0ffULL, 0x0000001097977824ULL, 0x100fe200078e0212ULL,
0x000000af247a7210ULL, 0x040fe20007f3e0ffULL, 0x0000000125737824ULL, 0x000fe200010e0673ULL,
0x000000b3247c7210ULL, 0x040fe20007f5e0ffULL, 0x00000010a7a77824ULL, 0x100fe200078e0212ULL,
0x0000001924247210ULL, 0x000fe20007f7e0ffULL, 0x00000010a9a97824ULL, 0x100fe200078e0212ULL,
0x000000006e977faeULL, 0x0003e2000b901c46ULL, 0x00000010abab7824ULL, 0x000fc400078e0212ULL,
0x0000000125197824ULL, 0x040fe200000e067bULL, 0x0000000070a77faeULL, 0x0003e2000b901c46ULL,
0x00000001257b7824ULL, 0x040fe400008e067dULL, 0x00000001257d7824ULL, 0x040fe200010e067fULL,
0x0000000072a97faeULL, 0x0003e2000b901c46ULL, 0x0000000125257824ULL, 0x000fc600018e0685ULL,
0x0000000078ab7faeULL, 0x0003e8000b901c46ULL, 0x0000000018ad7faeULL, 0x0003e8000b901c46ULL,
0x000000007ab17faeULL, 0x0003e8000b901c46ULL, 0x000000007cb57faeULL, 0x0003e8000b901c46ULL,
0x0000000024b77faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001013187824ULL, 0x002fe200078e00ffULL, 0x0000000816127810ULL, 0x000fc40007ffe0ffULL,
0x0000000417197819ULL, 0x000fe400000006ffULL, 0x0000000810157810ULL, 0x000fe40007ffe0ffULL,
0x0000400014147810ULL, 0x000fe40007ffe0ffULL, 0xfffffff019127812ULL, 0x000fe400078ee212ULL,
0xfffffff018157812ULL, 0x000fe200078ee215ULL, 0x0000001011247824ULL, 0x000fe200078e0214ULL,
0x000000140c0c7211ULL, 0x000fe200078e20ffULL, 0x0000001012127824ULL, 0x000fc400078e00ffULL,
0x0000001015157824ULL, 0x000fe400078e00ffULL, 0x000000100e6c7824ULL, 0x100fe400078e0214ULL,
0x000000100d687824ULL, 0x000fe200078e0214ULL, 0x0000000a160d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010170e7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002424783bULL, 0x000fe20000000200ULL, 0xfffffff00e0d7812ULL, 0x000fe200078ee20dULL,
0x0000001013117824ULL, 0x000fe200078e00ffULL, 0x0000000a100e7810ULL, 0x000fe20007ffe0ffULL,
0x000000001228783bULL, 0x0002a20000000200ULL, 0x000000100f707824ULL, 0x000fe400078e0214ULL,
0xfffffff011117812ULL, 0x000fe200078ee20eULL, 0x000000001564783bULL, 0x0007220000000200ULL,
0x000000100d787824ULL, 0x000fe400078e00ffULL, 0x000000100a887824ULL, 0x000fe200078e0214ULL,
0x000000006c6c783bULL, 0x000f220000000200ULL, 0x0000001011117824ULL, 0x000fc400078e00ffULL,
0x000000100b7c7824ULL, 0x100fe200078e0214ULL, 0x000000007070783bULL, 0x000f220000000200ULL,
0x00000010098c7824ULL, 0x000fe200078e0214ULL, 0x0000000c16097810ULL, 0x040fe20007ffe0ffULL,
0x00000010170a7824ULL, 0x000fe200078e00ffULL, 0x000000006868783bULL, 0x000f220000000200ULL,
0x0000001013127824ULL, 0x002fe200078e00ffULL, 0x0000000e16167810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e00ffULL, 0x000000000c0c783bULL, 0x000fe20000000200ULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x0000001013137824ULL, 0x000fc400078e00ffULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0xfffffff017167812ULL, 0x000fe200078ee216ULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x000000001184783bULL, 0x0004620000000200ULL,
0x0000001004047824ULL, 0x100fe400078e0214ULL, 0x0000001002157824ULL, 0x008fe200078e0214ULL,
0x000000008888783bULL, 0x000ee80000000200ULL, 0x000000007c7c783bULL, 0x000e620000000200ULL,
0x0000000c10117810ULL, 0x004fc40007ffe0ffULL, 0x0000000e10107810ULL, 0x000fe20007ffe0ffULL,
0x00000024282c723cULL, 0x000f62000004182cULL, 0x000000008c8c783bULL, 0x000ea20000000200ULL,
0xfffffff012117812ULL, 0x000fe200078ee211ULL, 0x0000001003127824ULL, 0x000fe200078e0214ULL,
0xfffffff013037812ULL, 0x000fc600078ee210ULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x000000246430723cULL, 0x010b620000041830ULL, 0x0000001003037824ULL, 0x000fcc00078e00ffULL,
0x0000001407247211ULL, 0x0a0fe200078e20ffULL, 0x000000262834723cULL, 0x080f700000041834ULL,
0x000000266438723cULL, 0x000b640000041838ULL, 0x000000002424783bULL, 0x020fec0000000200ULL,
0x0000006c2848723cULL, 0x040f700000041848ULL, 0x0000006e284c723cULL, 0x000f70000004184cULL,
0x0000006c6460723cULL, 0x000b6e0000041860ULL, 0x00000010166c7824ULL, 0x020fe200078e00ffULL,
0x000000702840723cULL, 0x040f700000041840ULL, 0x000000722844723cULL, 0x040f700000041844ULL,
0x000000682850723cULL, 0x040f700000041850ULL, 0x0000006a2854723cULL, 0x000bee0000041854ULL,
0x0000001006287824ULL, 0x120fe200078e0214ULL, 0x000000706458723cULL, 0x040f6a0000041858ULL,
0x000000002828783bULL, 0x000fe60000000200ULL, 0x00000072645c723cULL, 0x040b64000004185cULL,
0x000000000370783bULL, 0x020fec0000000200ULL, 0x0000006e6474723cULL, 0x040b640000041874ULL,
0x000000006c6c783bULL, 0x020fec0000000200ULL, 0x000000686480723cULL, 0x000b6e0000041880ULL,
0x0000001005687824ULL, 0x120fe200078e0214ULL, 0x0000000c782c723cULL, 0x082fe2000004182cULL,
0x000000000404783bULL, 0x000fee0000000200ULL, 0x0000000c8430723cULL, 0x000bee0000041830ULL,
0x00000010080c7824ULL, 0x020fe200078e0214ULL, 0x0000006a643c723cULL, 0x000b62000004183cULL,
0x000000000908783bULL, 0x000fe80000000200ULL, 0x000000001164783bULL, 0x020fe60000000200ULL,
0x0000000e7834723cULL, 0x080f620000041834ULL, 0x000000006868783bULL, 0x000fe80000000200ULL,
0x000000001210783bULL, 0x000fe60000000200ULL, 0x0000000e8438723cULL, 0x000be40000041838ULL,
0x000000000c0c783bULL, 0x020e6c0000000200ULL, 0x000000887848723cULL, 0x048f700000041848ULL,
0x0000008a784c723cULL, 0x000f70000004184cULL, 0x000000888460723cULL, 0x000f700000041860ULL,
0x0000007c7840723cULL, 0x040f700000041840ULL, 0x0000007e7844723cULL, 0x040f700000041844ULL,
0x0000008c7850723cULL, 0x004f700000041850ULL, 0x0000007c8458723cULL, 0x040f700000041858ULL,
0x0000007e845c723cULL, 0x040f70000004185cULL, 0x0000008a8474723cULL, 0x040f700000041874ULL,
0x0000008c8480723cULL, 0x000f700000041880ULL, 0x0000008e7854723cULL, 0x080b6e0000041854ULL,
0x0000001400787211ULL, 0x020fe200078e20ffULL, 0x0000008e843c723cULL, 0x000f62000004183cULL,
0x000000001514783bULL, 0x000ea80000000200ULL, 0x000000007878783bULL, 0x000ee60000000200ULL,
0x0000000c082c723cULL, 0x042f70000004182cULL, 0x0000000e0834723cULL, 0x040f700000041834ULL,
0x000000280848723cULL, 0x040f700000041848ULL, 0x0000002a084c723cULL, 0x000f70000004184cULL,
0x0000000c6430723cULL, 0x040ff00000041830ULL, 0x0000000e6438723cULL, 0x040ff00000041838ULL,
0x000000286460723cULL, 0x000ff00000041860ULL, 0x000000240840723cULL, 0x040ff00000041840ULL,
0x000000260844723cULL, 0x040ff00000041844ULL, 0x000000680850723cULL, 0x000ff00000041850ULL,
0x000000246458723cULL, 0x040ff00000041858ULL, 0x00000026645c723cULL, 0x040ff0000004185cULL,
0x0000002a6474723cULL, 0x040ff00000041874ULL, 0x000000686480723cULL, 0x000ff00000041880ULL,
0x0000006a0854723cULL, 0x080ff00000041854ULL, 0x0000006a643c723cULL, 0x020ff0000004183cULL,
0x000000046c2c723cULL, 0x040f70000004182cULL, 0x000000066c34723cULL, 0x040f700000041834ULL,
0x000000146c48723cULL, 0x044f700000041848ULL, 0x000000166c4c723cULL, 0x000f64000004184cULL,
0x3db504f32e187820ULL, 0x020fc40000410000ULL, 0x3db504f32c037820ULL, 0x000fe40000410000ULL,
0x3db504f32d087820ULL, 0x000fe40000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x000000047030723cULL, 0x000f620000041830ULL, 0x3db504f3350a7820ULL, 0x000fe40000410000ULL,
0x3db504f334097820ULL, 0x000fe40000410000ULL, 0x3db504f336197820ULL, 0x000fc40000410000ULL,
0x3db504f337247820ULL, 0x000fe20000410000ULL, 0x000000067038723cULL, 0x000f620000041838ULL,
0x3db504f3480f7820ULL, 0x000fe40000410000ULL, 0x3db504f34a2a7820ULL, 0x000fe40000410000ULL,
0x3db504f34b2e7820ULL, 0x000fc60000410000ULL, 0x000000147060723cULL, 0x000f620000041860ULL,
0x3db504f34e4e7820ULL, 0x000fe40000410000ULL, 0x3db504f34f4f7820ULL, 0x000fca0000410000ULL,
0x000000106c40723cULL, 0x000f640000041840ULL, 0x3db504f330357820ULL, 0x020fe40000410000ULL,
0x3db504f331007820ULL, 0x000fc80000410000ULL, 0x000000126c44723cULL, 0x000f620000041844ULL,
0x3db504f338027820ULL, 0x000fe40000410000ULL, 0x3db504f339297820ULL, 0x000fe40000410000ULL,
0x3db504f33a2b7820ULL, 0x000fc60000410000ULL, 0x000000786c50723cULL, 0x008f620000041850ULL,
0x3db504f3632c7820ULL, 0x000fce0000410000ULL, 0x000000107058723cULL, 0x040b620000041858ULL,
0x3db504f3400b7820ULL, 0x000fe40000410000ULL, 0x3db504f3410c7820ULL, 0x000fe40000410000ULL,
0x3db504f342257820ULL, 0x000fe40000410000ULL, 0x3db504f34c117820ULL, 0x020fe20000410000ULL,
0x00000012705c723cULL, 0x000b62000004185cULL, 0x3db504f343267820ULL, 0x000fe40000410000ULL,
0x3db504f3440d7820ULL, 0x000fc40000410000ULL, 0x3db504f3450e7820ULL, 0x000fe40000410000ULL,
0x3db504f346277820ULL, 0x000fe20000410000ULL, 0x000000167014723cULL, 0x040fe20000041874ULL,
0x3db504f347287820ULL, 0x000fe40000410000ULL, 0x3db504f349107820ULL, 0x000fe40000410000ULL,
0x3db504f34d127820ULL, 0x020fe40000410000ULL, 0x3db504f350137820ULL, 0x000fe20000410000ULL,
0x000000787004723cULL, 0x000fe20000041880ULL, 0x3db504f3324c7820ULL, 0x000fc40000410000ULL,
0x3db504f351517820ULL, 0x000fe40000410000ULL, 0x3db504f352527820ULL, 0x000fe40000410000ULL,
0x3db504f353347820ULL, 0x000fe20000410000ULL, 0x0000007a6c54723cULL, 0x000f620000041854ULL,
0x3db504f3334d7820ULL, 0x000fe40000410000ULL, 0x3db504f33b507820ULL, 0x000fe40000410000ULL,
0x3db504f35a5a7820ULL, 0x000fc40000410000ULL, 0x3db504f35b487820ULL, 0x000fe20000410000ULL,
0x0000007a7070723cULL, 0x000b62000004183cULL, 0x3db504f35c417820ULL, 0x000fe40000410000ULL,
0x3db504f35d427820ULL, 0x000fe40000410000ULL, 0x3db504f360437820ULL, 0x000fe40000410000ULL,
0x3db504f3583c7820ULL, 0x020fe40000410000ULL, 0x3db504f3593f7820ULL, 0x000fc40000410000ULL,
0x3db504f35e3d7820ULL, 0x000fe40000410000ULL, 0x3db504f35f3e7820ULL, 0x000fe40000410000ULL,
0x3db504f361447820ULL, 0x000fe40000410000ULL, 0x3db504f354547820ULL, 0x000fe40000410000ULL,
0x3db504f355557820ULL, 0x000fe40000410000ULL, 0x3db504f356367820ULL, 0x000fc40000410000ULL,
0x3db504f357577820ULL, 0x000fe40000410000ULL, 0x3db504f362407820ULL, 0x000fe40000410000ULL,
0x3db504f314457820ULL, 0x000fe40000410000ULL, 0x3db504f315467820ULL, 0x000fe40000410000ULL,
0x3db504f3162d7820ULL, 0x000fe40000410000ULL, 0x3db504f317307820ULL, 0x000fc40000410000ULL,
0x3db504f304477820ULL, 0x000fe40000410000ULL, 0x3db504f305497820ULL, 0x000fe40000410000ULL,
0x3db504f306067820ULL, 0x000fe40000410000ULL, 0x3db504f307077820ULL, 0x000fe40000410000ULL,
0x3db504f3704a7820ULL, 0x000fe40000410000ULL, 0x3db504f3714b7820ULL, 0x000fc40000410000ULL,
0x3db504f372327820ULL, 0x000fe40000410000ULL, 0x3db504f373377820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff337224ULL, 0x000fe200078e0052ULL,
0x0000000000397202ULL, 0x000fe20000000f00ULL, 0x00000000a0527f8cULL, 0x0002a2000c80043fULL,
0x000000ffff317224ULL, 0x000fe400078e004fULL, 0x000000ffff177224ULL, 0x000fe400078e002fULL,
0x000000ffff3b7224ULL, 0x000fc400078e0029ULL, 0x000000ffff4f7224ULL, 0x000fe400078e002bULL,
0x000000ffff2f7224ULL, 0x000fe400078e004eULL, 0x000000ffff297224ULL, 0x000fe400078e002dULL,
0x000000ffff2b7224ULL, 0x000fe400078e0030ULL, 0x000000ffff147224ULL, 0x000fe400078e0051ULL,
0x000000ffff157224ULL, 0x000fc400078e0054ULL, 0x000000ffff167224ULL, 0x000fe400078e0055ULL,
0x000000ffff387224ULL, 0x000fe400078e0057ULL, 0x000000ffff3a7224ULL, 0x000fe400078e0002ULL,
0x000000ffff4e7224ULL, 0x000fe400078e005aULL, 0x000000ffff2d7224ULL, 0x000fe400078e0006ULL,
0x000000ffff307224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x00000400a0077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604517210ULL, 0x000fc80007f1e1ffULL,
0x0000000705077210ULL, 0x000fe400007fe5ffULL, 0x003d09005100780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c405100780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000005100007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000102027810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400a0077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000041e027824ULL, 0x000fe200078e00ffULL, 0x0000009f9900720cULL, 0x000fc80003f06070ULL,
0xfffffff002007812ULL, 0x000fca00078ec0ffULL, 0x000000809d007824ULL, 0x000fca00078e0200ULL,
0x01e4000000047984ULL, 0x0002a20000000c00ULL, 0x000021e000008947ULL, 0x000fea0003800000ULL,
0x00005a0000557b06ULL, 0x000ee20000209000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x0000009c1e517211ULL, 0x000fe400078ff0ffULL, 0x0000001a985b7217ULL, 0x000fe40007800000ULL,
0x0000001051567810ULL, 0x000fe40007ffe0ffULL, 0x0000005b1a1a7210ULL, 0x000fe40007ffe1ffULL,
0x00005a00ff5d7a12ULL, 0x000fe200078e33ffULL, 0x0000005500557308ULL, 0x008ee40000001000ULL,
0x0ffffffe55577810ULL, 0x008fcc0007ffe0ffULL, 0x0000005700537305ULL, 0x000ee4000021f000ULL,
0x000000ffff597224ULL, 0x008fc800078e0a53ULL, 0x00005a0059597a24ULL, 0x000fc800078e02ffULL,
0x00000059535e7227ULL, 0x000fe200078e0052ULL, 0x0000000851537810ULL, 0x000fca0007ffe0ffULL,
0x000000535e547227ULL, 0x000fc800078e00ffULL, 0x000000515e527227ULL, 0x000fc800078e00ffULL,
0x000000ffff5c7224ULL, 0x000fe400078e0a54ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0a52ULL,
0x00005a005c557a24ULL, 0x000fe400078e0253ULL, 0x00005a005a537a24ULL, 0x000fe200078e0251ULL,
0x0000001851517810ULL, 0x000fe20007ffe0ffULL, 0x000000565e587227ULL, 0x000fe200078e00ffULL,
0x00005a0055007a0cULL, 0x000fe40003fa6070ULL, 0x00005a0053007a0cULL, 0x000fe20003f06070ULL,
0x000000ffff577224ULL, 0x000fc400078e0a58ULL, 0x000000515e597227ULL, 0x000fc800078e00ffULL,
0x00005a0057567a24ULL, 0x000fe400078e0256ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0a59ULL,
0x80005a0055555a10ULL, 0x000fe40007ffe0ffULL, 0x00005a005a577a24ULL, 0x000fe200078e0251ULL,
0x00005a0056007a0cULL, 0x000fe20003f26070ULL, 0x000000021e517824ULL, 0x000fe200078e00ffULL,
0x80005a0053530a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0057007a0cULL, 0x000fc40003f66070ULL,
0x00005a0053007a0cULL, 0x000fe40003f46070ULL, 0x0000000651517812ULL, 0x000fe400078ec0ffULL,
0x00005a0055007a0cULL, 0x000fe40003fc6070ULL, 0x0000000152520810ULL, 0x000fe20007ffe0ffULL,
0x00000001515b7824ULL, 0x000fe200078e029eULL, 0x80005a0056561a10ULL, 0x000fe20007ffe0ffULL,
0x000000011b557824ULL, 0x000fe200078e0251ULL, 0x0000000154545810ULL, 0x000fe20007ffe0ffULL,
0x000000015b537824ULL, 0x000fe200078e0a1aULL, 0x00005a0056007a0cULL, 0x000fc40003f86070ULL,
0x00005a00ff007a0cULL, 0x000fe40003fa5070ULL, 0x0000001a5500720cULL, 0x040fe20003f06070ULL,
0x0000000155557824ULL, 0x000fe200078e0a1aULL, 0x80005a0057573a10ULL, 0x000fe40007ffe0ffULL,
0x0000000152522810ULL, 0x000fe40007ffe0ffULL, 0x000000531c6a7217ULL, 0x000fe40003800000ULL,
0x00005a0057007a0cULL, 0x000fc40003f46070ULL, 0x000000525d537207ULL, 0x000fe40006800000ULL,
0x000000551c557217ULL, 0x000fe40003800000ULL, 0x0000000154546810ULL, 0x000fe40007ffe0ffULL,
0x000000531c527217ULL, 0x000fe40003800000ULL, 0x0000000158581810ULL, 0x000fe40007ffe0ffULL,
0x0000001a5b00720cULL, 0x000fe20003fc6070ULL, 0x000000521d817224ULL, 0x000fe200078e02ffULL,
0x00000004ff557819ULL, 0x000fc40000011655ULL, 0x000000545d577207ULL, 0x000fe40006800000ULL,
0x0000000159593810ULL, 0x000fe40007ffe0ffULL, 0x0000000158584810ULL, 0x000fe40007ffe0ffULL,
0x000000ff6a6a7207ULL, 0x000fe40003000000ULL, 0x000000ff55567207ULL, 0x000fe40000000000ULL,
0x000000571c547217ULL, 0x000fc40003800000ULL, 0x0000000159592810ULL, 0x000fe20007ffe0ffULL,
0x0000000181557824ULL, 0x000fe200078e0256ULL, 0x000000585d577207ULL, 0x000fe20006800000ULL,
0x000000541d857224ULL, 0x000fe200078e02ffULL, 0x000000816a537211ULL, 0x000fe200078fe0ffULL,
0x0000000255547825ULL, 0x100fe200078e009aULL, 0x000000595d5d7207ULL, 0x000fe40006800000ULL,
0x000000571c5c7217ULL, 0x040fe20003800000ULL, 0x0000000253527825ULL, 0x000fe200078e009aULL,
0x0000005d1c5e7217ULL, 0x000fe20003800000ULL, 0x00000006545a7981ULL, 0x000722000c1e9500ULL,
0x0000001051697812ULL, 0x000fe200078efcffULL, 0x0000000156597824ULL, 0x000fc400078e0285ULL,
0x0000005c1d877224ULL, 0x000fe200078e02ffULL, 0x00000006525d7981ULL, 0x000322000c1e9500ULL,
0x0000000259587825ULL, 0x000fe200078e009aULL, 0x000000691b6d7210ULL, 0x000fe40007ffe0ffULL,
0x000000856a577211ULL, 0x040fe200078fe0ffULL, 0x0000005e1d897224ULL, 0x000fe200078e02ffULL,
0x000000876a5f7211ULL, 0x000fe200078fe0ffULL, 0x0000000156637824ULL, 0x040fe200078e0287ULL,
0x00000006585c7981ULL, 0x000522000c1e9500ULL, 0x0000000156657824ULL, 0x000fe200078e0289ULL,
0x000000896a617211ULL, 0x000fe200078fe0ffULL, 0x0000000257567825ULL, 0x000fc800078e009aULL,
0x0000000263627825ULL, 0x000fc800078e009aULL, 0x000000016d597824ULL, 0x004fe200078e0a1aULL,
0x00000006625e7981ULL, 0x000522000c1e9500ULL, 0x000000025f547825ULL, 0x008fc600078e009aULL,
0x000000591c587217ULL, 0x040fe20003800000ULL, 0x0000000169677824ULL, 0x000fe200078e029eULL,
0x00000006565f7981ULL, 0x000722000c1e9500ULL, 0x0000000261527825ULL, 0x002fe200078e009aULL,
0x0000001a6d00720cULL, 0x080fe40003f26070ULL, 0x0000000654617981ULL, 0x000322000c1e9500ULL,
0x0000000167597824ULL, 0x040fe200078e0a1aULL, 0x00000004ff587819ULL, 0x000fe40000011658ULL,
0x0000001a6700720cULL, 0x000fe20003f06070ULL, 0x0000000265647825ULL, 0x000fe200078e009aULL,
0x000000591c597217ULL, 0x000fe20003800000ULL, 0x00000006526b7981ULL, 0x000322000c1e9500ULL,
0x000000ff58567207ULL, 0x008fc40000800000ULL, 0x000000ff59747207ULL, 0x000fe20000000000ULL,
0x0000000664607981ULL, 0x000722000c1e9500ULL, 0x0000002051737812ULL, 0x000fe200078efcffULL,
0x0000000156597824ULL, 0x000fe200078e0285ULL, 0x0000008574577211ULL, 0x040fe400078fe0ffULL,
0x0000008174537211ULL, 0x042fe200078fe0ffULL, 0x0000000259587825ULL, 0x000fe200078e009aULL,
0x00000089746f7211ULL, 0x000fc600078fe0ffULL, 0x0000000181557824ULL, 0x000fe200078e0256ULL,
0x0000000658687981ULL, 0x000322000c1e9500ULL, 0x000000011b797824ULL, 0x000fe400078e0273ULL,
0x0000000253527825ULL, 0x000fe200078e009aULL, 0x0000009e73757210ULL, 0x000fc60007ffe0ffULL,
0x0000000156657824ULL, 0x048fe200078e0287ULL, 0x00000006526d7981ULL, 0x000722000c1e9500ULL,
0x0000000156717824ULL, 0x000fe400078e0289ULL, 0x0000000255547825ULL, 0x000fc800078e009aULL,
0x0000000257567825ULL, 0x000fe200078e009aULL, 0x0000000654667981ULL, 0x000526000c1e9500ULL,
0x0000000179597824ULL, 0x002fe400078e0a1aULL, 0x000000026f527825ULL, 0x008fe400078e009aULL,
0x00000006566f7981ULL, 0x0002e2000c1e9500ULL, 0x000000591c587217ULL, 0x000fe20003800000ULL,
0x0000000175597824ULL, 0x000fe200078e0a1aULL, 0x0000008774637211ULL, 0x004fc400078fe0ffULL,
0x0000001a7500720cULL, 0x080fe20003f06070ULL, 0x0000000265647825ULL, 0x100fe200078e009aULL,
0x000000591c597217ULL, 0x000fe20003800000ULL, 0x0000000652777981ULL, 0x0004e2000c1e9500ULL,
0x0000001a7900720cULL, 0x000fe20003f26070ULL, 0x0000000263627825ULL, 0x000fe200078e009aULL,
0x00000004ff587819ULL, 0x000fe20000011658ULL, 0x00000006646c7981ULL, 0x0004e4000c1e9500ULL,
0x0000000271547825ULL, 0x000fe200078e009aULL, 0x000000ff59787207ULL, 0x000fe20000000000ULL,
0x0000000662717981ULL, 0x0004e2000c1e9500ULL, 0x000000ff58587207ULL, 0x000fc40000800000ULL,
0x0000008178577211ULL, 0x002fe200078fe0ffULL, 0x00000006546e7981ULL, 0x0002e4000c1e9500ULL,
0x0000000158657824ULL, 0x004fe200078e0285ULL, 0x0000008578637211ULL, 0x000fe200078fe0ffULL,
0x0000000257567825ULL, 0x000fc800078e009aULL, 0x0000000181557824ULL, 0x002fe200078e0258ULL,
0x00000089787b7211ULL, 0x000fe200078fe0ffULL, 0x0000000265647825ULL, 0x100fe200078e009aULL,
0x0000000656797981ULL, 0x0002a6000c1e9500ULL, 0x0000000255547825ULL, 0x100fe200078e009aULL,
0x0000000664727981ULL, 0x0002a6000c1e9500ULL, 0x0000000263627825ULL, 0x000fe200078e009aULL,
0x0000000654707981ULL, 0x0002a6000c1e9500ULL, 0x00000001587d7824ULL, 0x000fc400078e0289ULL,
0x000000027b567825ULL, 0x102fe400078e009aULL, 0x00000006627b7981ULL, 0x0002a4000c1e9500ULL,
0x000000027d547825ULL, 0x000fe200078e009aULL, 0x00000030517d7812ULL, 0x000fe200078efcffULL,
0x0000000656d97981ULL, 0x0002a2000c1e9500ULL, 0x0000008778537211ULL, 0x000fe200078fe0ffULL,
0x0000000158597824ULL, 0x000fe400078e0287ULL, 0x000000011b837824ULL, 0x000fe200078e027dULL,
0x0000000654867981ULL, 0x0002a2000c1e9500ULL, 0x0000000259587825ULL, 0x000fc800078e009aULL,
0x0000000253527825ULL, 0x000fe200078e009aULL, 0x0000000658767981ULL, 0x0002a6000c1e9500ULL,
0x0000000183657824ULL, 0x000fe200078e0a1aULL, 0x0000000652d57981ULL, 0x0002a2000c1e9500ULL,
0x000000017d7f7824ULL, 0x000fc600078e029eULL, 0x000000651c647217ULL, 0x040fe20003800000ULL,
0x000000017f657824ULL, 0x000fe200078e0a1aULL, 0x0000001a8300720cULL, 0x080fe40003f26070ULL,
0x0000001a7f00720cULL, 0x000fe40003f06070ULL, 0x00000004ff647819ULL, 0x000fe40000011664ULL,
0x000000651c657217ULL, 0x000fe40003800000ULL, 0x000000ff647c7207ULL, 0x000fc40000800000ULL,
0x000000ff657a7207ULL, 0x000fe40000000000ULL, 0x0000007c81637210ULL, 0x002fe20007ffe0ffULL,
0x000000017c577824ULL, 0x000fe200078e0287ULL, 0x000000817a657211ULL, 0x040fe400078fe0ffULL,
0x000000877a597211ULL, 0x000fe200078fe0ffULL, 0x0000000263627825ULL, 0x000fc800078e009aULL,
0x0000000265647825ULL, 0x100fe200078e009aULL, 0x00000006627e7981ULL, 0x0002a6000c1e9500ULL,
0x0000000257567825ULL, 0x100fe200078e009aULL, 0x0000000664bd7981ULL, 0x0002a6000c1e9500ULL,
0x0000000259587825ULL, 0x000fe200078e009aULL, 0x0000000656847981ULL, 0x0002a2000c1e9500ULL,
0x000000857a557211ULL, 0x000fc600078fe0ffULL, 0x0000000658d77981ULL, 0x0002a2000c1e9500ULL,
0x000000017c537824ULL, 0x000fe400078e0285ULL, 0x0000000255547825ULL, 0x000fc800078e009aULL,
0x0000000253527825ULL, 0x000fe200078e009aULL, 0x0000000654d37981ULL, 0x0002a4000c1e9500ULL,
0x000000897a637211ULL, 0x002fe400078fe0ffULL, 0x0000000652827981ULL, 0x0002a2000c1e9500ULL,
0x000000017c657824ULL, 0x000fe400078e0289ULL, 0x0000000263627825ULL, 0x000fc800078e009aULL,
0x0000000265647825ULL, 0x000fe200078e009aULL, 0x0000000662db7981ULL, 0x0002a8000c1e9500ULL,
0x0000000664887981ULL, 0x0002a4000c1e9500ULL, 0xfffffff06a537812ULL, 0x002fe200078ec0ffULL,
0x00000001ffd17424ULL, 0x000fc800078e00ffULL, 0x000000011a527824ULL, 0x000fc800078e0253ULL,
0x000000015b537824ULL, 0x000fe200078e0a52ULL, 0x0000000151817812ULL, 0x000fc800078efcffULL,
0x00000053d1537219ULL, 0x000fe200000006ffULL, 0x0000000181557824ULL, 0x000fe200078e029eULL,
0xfffffff074577812ULL, 0x000fc600078ec0ffULL, 0x0000000155547824ULL, 0x000fe200078e0a52ULL,
0x0000000851837812ULL, 0x040fe200078efcffULL, 0x000000011a587824ULL, 0x000fe200078e0257ULL,
0x0000000951857812ULL, 0x000fe400078efcffULL, 0x00000054d1577219ULL, 0x000fe200000006ffULL,
0x0000000183597824ULL, 0x100fe400078e029eULL, 0x0000000185657824ULL, 0x000fe200078e029eULL,
0xfffffff078637812ULL, 0x000fe400078ec0ffULL, 0xfffffff07a877812ULL, 0x000fc400078ec0ffULL,
0x0000005952567210ULL, 0x000fe20007ffe1ffULL, 0x0000000165527824ULL, 0x000fe200078e0a52ULL,
0x00000011518b7812ULL, 0x000fe200078efcffULL, 0x000000011a627824ULL, 0x040fe200078e0263ULL,
0x00000056d1637219ULL, 0x040fe200000006ffULL, 0x000000011a787824ULL, 0x000fe200078e0287ULL,
0x00000052d1877219ULL, 0x000fe200000006ffULL, 0x000000018b8d7824ULL, 0x000fe400078e029eULL,
0x0000000167527824ULL, 0x100fe400078e0a58ULL, 0x000000018d547824ULL, 0x000fe200078e0a58ULL,
0x0000001851917812ULL, 0x000fc400078efcffULL, 0x0000001951977812ULL, 0x000fe400078efcffULL,
0x00000052d1897219ULL, 0x040fe400000006ffULL, 0x00000054d18f7219ULL, 0x000fe400000006ffULL,
0x000054105d5a7816ULL, 0x010fc8000000005aULL, 0x0000005a53ff7212ULL, 0x000fc800078ac0ffULL,
0x0000001a5b00720cULL, 0x000fc80002fa1470ULL, 0x0000001a5100720cULL, 0x000fe40002fa1070ULL,
0x0000005a57ff7212ULL, 0x000fe4000782c0ffULL, 0xff80000003037808ULL, 0x000fe40002800000ULL,
0x0000001a5500720cULL, 0x000fe40000f21470ULL, 0x000054105f5c7816ULL, 0x000fe4000000005cULL,
0x00005410615e7816ULL, 0x000fc4000000005eULL, 0x0000005c53ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005e53ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005c57ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001a5b00720cULL, 0x0c0fe40001741470ULL, 0x0000001a5b00720cULL, 0x080fe40002781470ULL,
0x0000001a5500720cULL, 0x000fc40002fa1470ULL, 0x0000001a5100720cULL, 0x0c0fe40001741070ULL,
0x0000001a5100720cULL, 0x080fe40002781070ULL, 0x0000001a8100720cULL, 0x0c0fe40000f21070ULL,
0x0000001a8100720cULL, 0x000fe40002fa1070ULL, 0x000054106b607816ULL, 0x000fe40000000060ULL,
0xff80000018187808ULL, 0x000fc40001000000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff80000008087808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x0000005a63ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006053ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005e57ff7212ULL, 0x000fc4000784c0ffULL, 0x0000006057ff7212ULL, 0x000fe4000788c0ffULL,
0x0000005c87ff7212ULL, 0x000fe4000782c0ffULL, 0x0000005e63ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001a5b00720cULL, 0x080fe40000701470ULL, 0x0000001a5500720cULL, 0x0c0fe40001741470ULL,
0x0000001a5500720cULL, 0x000fc40002781470ULL, 0x0000001a5900720cULL, 0x0c0fe40001f61470ULL,
0x0000001a5900720cULL, 0x080fe40002fa1470ULL, 0x0000001a6500720cULL, 0x080fe40000f21470ULL,
0x0000001a5100720cULL, 0x080fe40000701070ULL, 0x0000001a8100720cULL, 0x0c0fe40001741070ULL,
0x0000001a8100720cULL, 0x000fc40002781070ULL, 0x0000001a8300720cULL, 0x0c0fe40001f61070ULL,
0x0000001a8300720cULL, 0x080fe40002fa1070ULL, 0x0000001a8500720cULL, 0x000fe40000f21070ULL,
0x000054106d667816ULL, 0x000fe40000000066ULL, 0x000054106f687816ULL, 0x008fe20000000068ULL,
0x0000000191937824ULL, 0x000fe200078e029eULL, 0x0000009e97997210ULL, 0x000fc40007ffe0ffULL,
0xff8000004c4c7808ULL, 0x000fe40000000000ULL, 0xff80000039397808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff80000009097808ULL, 0x000fe40001800000ULL,
0xff8000003a3a7808ULL, 0x000fe40002800000ULL, 0xff80000024247808ULL, 0x000fc40000800000ULL,
0x0000005c63ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005e87ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006063ff7212ULL, 0x080fe4000788c0ffULL, 0x0000006087ff7212ULL, 0x000fe4000786c0ffULL,
0x000000668fff7212ULL, 0x000fe400078ac0ffULL, 0x0000006889ff7212ULL, 0x000fe2000782c0ffULL,
0x0000000193567824ULL, 0x100fe200078e0a58ULL, 0x0000001a5900720cULL, 0x080fe20000701470ULL,
0x0000000199587824ULL, 0x000fe200078e0a58ULL, 0x0000001a5900720cULL, 0x000fc40002781470ULL,
0x0000001a6500720cULL, 0x0c0fe40001741470ULL, 0x0000001a6500720cULL, 0x080fe40001f61470ULL,
0x0000001a6700720cULL, 0x080fe40000f21470ULL, 0x0000001a8d00720cULL, 0x080fe40002fa1470ULL,
0x0000001a8300720cULL, 0x0c0fe40000701070ULL, 0x0000001a8300720cULL, 0x000fc40002781070ULL,
0x0000001a8500720cULL, 0x0c0fe40001741070ULL, 0x0000001a8500720cULL, 0x080fe40001f61070ULL,
0x0000001a6900720cULL, 0x080fe40000f21070ULL, 0x0000001a8b00720cULL, 0x000fe40002fa1070ULL,
0x00000056d1957219ULL, 0x040fe400000006ffULL, 0x00000058d1a77219ULL, 0x000fc400000006ffULL,
0x00005410716c7816ULL, 0x000fe4000000006cULL, 0x00005410776e7816ULL, 0x000fe4000000006eULL,
0xff80000019197808ULL, 0x000fe40000000000ULL, 0xff8000004f4f7808ULL, 0x000fe40002000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001000000ULL, 0xff80000050507808ULL, 0x000fc40001800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff8000000c0c7808ULL, 0x000fe40002800000ULL,
0x0000006689ff7212ULL, 0x080fe4000780c0ffULL, 0x0000006695ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006c89ff7212ULL, 0x040fe4000784c0ffULL, 0x0000006e89ff7212ULL, 0x000fc4000786c0ffULL,
0x0000006c8fff7212ULL, 0x000fe4000782c0ffULL, 0x00000068a7ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000175647824ULL, 0x000fe200078e0a62ULL, 0x0000001a6700720cULL, 0x0c0fe40000701470ULL,
0x0000001a6700720cULL, 0x0c0fe40001741470ULL, 0x0000001a6700720cULL, 0x080fe40001f61470ULL,
0x0000001a8d00720cULL, 0x000fc40000f21470ULL, 0x0000001a9300720cULL, 0x080fe40002781470ULL,
0x0000001a9900720cULL, 0x080fe40002fa1470ULL, 0x0000002151ab7812ULL, 0x000fe400078efcffULL,
0x0000001a6900720cULL, 0x0c0fe40000701070ULL, 0x0000001a6900720cULL, 0x0c0fe40001741070ULL,
0x0000001a6900720cULL, 0x000fc40001f61070ULL, 0x0000001a8b00720cULL, 0x080fe40000f21070ULL,
0x0000001a9100720cULL, 0x080fe40002781070ULL, 0x0000001a9700720cULL, 0x000fe40002fa1070ULL,
0x00000064d1a97219ULL, 0x000fe400000006ffULL, 0x000054107b727816ULL, 0x004fe20000000072ULL,
0x00000001abad7824ULL, 0x000fe200078e029eULL, 0xff8000000b0b7808ULL, 0x000fc40000000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001800000ULL,
0xff8000003f3f7808ULL, 0x000fe40000800000ULL, 0xff8000000d0d7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x000000688fff7212ULL, 0x000fc4000780c0ffULL,
0x0000006e8fff7212ULL, 0x000fe4000784c0ffULL, 0x0000006895ff7212ULL, 0x000fe4000786c0ffULL,
0x0000006ca7ff7212ULL, 0x040fe4000782c0ffULL, 0x0000006ea7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000072a9ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001a8d00720cULL, 0x000fc40000701470ULL,
0x0000001a8d00720cULL, 0x080fe40001741470ULL, 0x0000001a9300720cULL, 0x080fe40001f61470ULL,
0x0000001a9900720cULL, 0x0c0fe40000f21470ULL, 0x0000001a9900720cULL, 0x080fe40002781470ULL,
0x0000001a7500720cULL, 0x000fe40002fa1470ULL, 0x000000ad626a7210ULL, 0x000fc40007ffe1ffULL,
0x0000002851b17812ULL, 0x040fe400078efcffULL, 0x0000002951b77812ULL, 0x000fe400078efcffULL,
0x0000001a8b00720cULL, 0x0c0fe40000701070ULL, 0x0000001a8b00720cULL, 0x080fe40001741070ULL,
0x0000001a9100720cULL, 0x080fe40001f61070ULL, 0x0000001a9700720cULL, 0x000fc40000f21070ULL,
0x0000001a9700720cULL, 0x080fe40002781070ULL, 0x0000001a7300720cULL, 0x000fe40002fa1070ULL,
0x0000006ad1af7219ULL, 0x000fe400000006ffULL, 0x0000541079707816ULL, 0x000fe40000000070ULL,
0x00005410d5767816ULL, 0x000fe40000000076ULL, 0x00005410d9867816ULL, 0x000fe20000000086ULL,
0x00000001b1b37824ULL, 0x100fe200078e029eULL, 0xff80000026267808ULL, 0x000fe20000000000ULL,
0x00000001b7b97824ULL, 0x000fe200078e029eULL, 0xff80000048487808ULL, 0x000fc40001000000ULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff80000042427808ULL, 0x000fe40000800000ULL,
0xff8000003e3e7808ULL, 0x000fe40002000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002800000ULL,
0x0000005a87ff7212ULL, 0x000fe400078cc0ffULL, 0x0000006c95ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006e95ff7212ULL, 0x000fe4000784c0ffULL, 0x00000070a9ff7212ULL, 0x040fe4000786c0ffULL,
0x00000076a9ff7212ULL, 0x040fe4000782c0ffULL, 0x00000086a9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000076afff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b3747824ULL, 0x100fe200078e0a62ULL,
0x0000001a6500720cULL, 0x080fe200037c1470ULL, 0x00000001b9627824ULL, 0x000fe200078e0a62ULL,
0x0000001a9300720cULL, 0x000fc40000701470ULL, 0x0000001a9300720cULL, 0x080fe40001741470ULL,
0x0000001a7500720cULL, 0x0c0fe40001f61470ULL, 0x0000001a7500720cULL, 0x0c0fe40000f21470ULL,
0x0000001a7500720cULL, 0x080fe40002781470ULL, 0x0000001aad00720cULL, 0x080fe40002fa1470ULL,
0x0000001a8500720cULL, 0x000fc400037c1070ULL, 0x0000001a9100720cULL, 0x0c0fe40000701070ULL,
0x0000001a9100720cULL, 0x080fe40001741070ULL, 0x0000001a7300720cULL, 0x0c0fe40001f61070ULL,
0x0000001a7300720cULL, 0x0c0fe40000f21070ULL, 0x0000001a7300720cULL, 0x080fe40002781070ULL,
0x0000001aab00720cULL, 0x000fc40002fa1070ULL, 0x00000074d1b57219ULL, 0x040fe400000006ffULL,
0x00000062d1bb7219ULL, 0x000fe400000006ffULL, 0xff8000000a0a7808ULL, 0x000fe40003000000ULL,
0xff80000041417808ULL, 0x000fe40000000000ULL, 0xff8000003d3d7808ULL, 0x000fe40001000000ULL,
0xff8000000f0f7808ULL, 0x000fc40001800000ULL, 0xff80000043437808ULL, 0x000fe40000800000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0xff80000044447808ULL, 0x000fe40002800000ULL,
0x00000066a7ff7212ULL, 0x000fe400078cc0ffULL, 0x00000070afff7212ULL, 0x080fe4000780c0ffULL,
0x00000070b5ff7212ULL, 0x000fc4000784c0ffULL, 0x00000072afff7212ULL, 0x040fe4000786c0ffULL,
0x00000086afff7212ULL, 0x000fe4000782c0ffULL, 0x00000072b5ff7212ULL, 0x000fe4000788c0ffULL,
0x00000076bbff7212ULL, 0x000fe200078ac0ffULL, 0x000000017f7a7824ULL, 0x000fe200078e0a78ULL,
0x0000001a9900720cULL, 0x080fe400037c1470ULL, 0x0000001aad00720cULL, 0x000fc40000701470ULL,
0x0000001aad00720cULL, 0x0c0fe40001f61470ULL, 0x0000001aad00720cULL, 0x080fe40000f21470ULL,
0x0000001ab300720cULL, 0x0c0fe40001741470ULL, 0x0000001ab300720cULL, 0x080fe40002781470ULL,
0x0000001ab900720cULL, 0x000fe40002fa1470ULL, 0x0000003151c17812ULL, 0x000fc400078efcffULL,
0x0000003851c77812ULL, 0x040fe400078efcffULL, 0x0000003951cd7812ULL, 0x000fe400078efcffULL,
0x0000001a9700720cULL, 0x080fe400037c1070ULL, 0x0000001aab00720cULL, 0x0c0fe40000701070ULL,
0x0000001aab00720cULL, 0x0c0fe40001f61070ULL, 0x0000001aab00720cULL, 0x000fc40000f21070ULL,
0x0000001ab100720cULL, 0x0c0fe40001741070ULL, 0x0000001ab100720cULL, 0x080fe40002781070ULL,
0x0000001ab700720cULL, 0x000fe40002fa1070ULL, 0x0000007ad1bf7219ULL, 0x000fe400000006ffULL,
0x00005410bd7e7816ULL, 0x000fe4000000007eULL, 0x00005410d7847816ULL, 0x000fe20000000084ULL,
0x00000001c1c37824ULL, 0x100fe200078e029eULL, 0xff8000000e0e7808ULL, 0x000fe20003000000ULL,
0x00000001c7c97824ULL, 0x100fe200078e029eULL, 0xff80000010107808ULL, 0x000fe20000000000ULL,
0x00000001cdcf7824ULL, 0x000fe200078e029eULL, 0xff8000002e2e7808ULL, 0x000fc40001800000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fe40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0xff80000046467808ULL, 0x000fe40002800000ULL,
0x00000070bbff7212ULL, 0x040fe400078cc0ffULL, 0x00000072bbff7212ULL, 0x000fc4000780c0ffULL,
0x00000076b5ff7212ULL, 0x040fe4000786c0ffULL, 0x00000086b5ff7212ULL, 0x080fe4000782c0ffULL,
0x00000086bbff7212ULL, 0x000fe4000784c0ffULL, 0x0000007ebfff7212ULL, 0x040fe4000788c0ffULL,
0x00000084bfff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c37c7824ULL, 0x100fe200078e0a78ULL,
0x0000001ab300720cULL, 0x080fe20001f61470ULL, 0x00000001c9807824ULL, 0x100fe200078e0a78ULL,
0x0000001ab300720cULL, 0x080fe20000f21470ULL, 0x00000001cf787824ULL, 0x000fe200078e0a78ULL,
0x0000001ab900720cULL, 0x000fc400037c1470ULL, 0x0000001ab900720cULL, 0x0c0fe40000701470ULL,
0x0000001ab900720cULL, 0x080fe40001741470ULL, 0x0000001a7f00720cULL, 0x0c0fe40002781470ULL,
0x0000001a7f00720cULL, 0x000fe40002fa1470ULL, 0x0000007cd1c57219ULL, 0x040fe400000006ffULL,
0x00000080d1cb7219ULL, 0x000fc400000006ffULL, 0x0000001ab100720cULL, 0x0c0fe40001f61070ULL,
0x0000001ab100720cULL, 0x080fe40000f21070ULL, 0x0000001ab700720cULL, 0x0c0fe400037c1070ULL,
0x0000001ab700720cULL, 0x0c0fe40000701070ULL, 0x0000001ab700720cULL, 0x080fe40001741070ULL,
0x0000001a7d00720cULL, 0x000fc40002781070ULL, 0x0000001a7d00720cULL, 0x000fe40002fa1070ULL,
0x00000078d1d17219ULL, 0x000fe400000006ffULL, 0x00005410d3827816ULL, 0x000fe40000000082ULL,
0xff80000045457808ULL, 0x000fe40001800000ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff80000012127808ULL, 0x000fc40003000000ULL, 0xff80000031317808ULL, 0x000fe40000000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fe40002000000ULL,
0xff80000047477808ULL, 0x000fe40002800000ULL, 0x0000007ec5ff7212ULL, 0x080fe4000786c0ffULL,
0x0000007ecbff7212ULL, 0x000fc4000782c0ffULL, 0x0000007ed1ff7212ULL, 0x000fe400078cc0ffULL,
0x00000082bfff7212ULL, 0x080fe4000780c0ffULL, 0x00000082c5ff7212ULL, 0x080fe4000784c0ffULL,
0x00000082cbff7212ULL, 0x000fe4000788c0ffULL, 0x00000084c5ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001a7f00720cULL, 0x000fc40000701470ULL, 0x0000001ac300720cULL, 0x0c0fe40001f61470ULL,
0x0000001ac300720cULL, 0x0c0fe40001741470ULL, 0x0000001ac300720cULL, 0x080fe40002fa1470ULL,
0x0000001ac900720cULL, 0x080fe40000f21470ULL, 0x0000001acf00720cULL, 0x080fe400037c1470ULL,
0x0000001ac900720cULL, 0x000fc40002781470ULL, 0x0000001a7d00720cULL, 0x080fe40000701070ULL,
0x0000001ac100720cULL, 0x0c0fe40001f61070ULL, 0x0000001ac100720cULL, 0x0c0fe40001741070ULL,
0x0000001ac100720cULL, 0x080fe40002fa1070ULL, 0x0000001ac700720cULL, 0x080fe40000f21070ULL,
0x0000001acd00720cULL, 0x000fc400037c1070ULL, 0x0000001ac700720cULL, 0x000fe40002781070ULL,
0x00005410db887816ULL, 0x000fe40000000088ULL, 0xff80000033337808ULL, 0x000fe40000000000ULL,
0xff80000014147808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000049497808ULL, 0x000fc40002800000ULL, 0xff80000015157808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40002000000ULL,
0x00000082d1ff7212ULL, 0x000fe4000780c0ffULL, 0x00000084cbff7212ULL, 0x080fe4000786c0ffULL,
0x00000084d1ff7212ULL, 0x000fc4000784c0ffULL, 0x00000088bfff7212ULL, 0x080fe400078ac0ffULL,
0x00000088c5ff7212ULL, 0x080fe4000782c0ffULL, 0x00000088cbff7212ULL, 0x080fe400078cc0ffULL,
0x00000088d1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001a7f00720cULL, 0x080fe40002fa1470ULL,
0x0000001ac300720cULL, 0x000fc40000f21470ULL, 0x0000001ac900720cULL, 0x0c0fe40001f61470ULL,
0x0000001ac900720cULL, 0x080fe400037c1470ULL, 0x0000001acf00720cULL, 0x0c0fe40000701470ULL,
0x0000001acf00720cULL, 0x0c0fe40001741470ULL, 0x0000001acf00720cULL, 0x080fe40002781470ULL,
0x0000001a7d00720cULL, 0x000fc40002fa1070ULL, 0x0000001ac100720cULL, 0x080fe40000f21070ULL,
0x0000001acd00720cULL, 0x080fe40000701070ULL, 0x0000001ac700720cULL, 0x0c0fe40001f61070ULL,
0x0000001ac700720cULL, 0x080fe400037c1070ULL, 0x0000001acd00720cULL, 0x0c0fe40001741070ULL,
0x0000001acd00720cULL, 0x000fc40002781070ULL, 0xff80000038387808ULL, 0x000fe40000000000ULL,
0xff8000004a4a7808ULL, 0x000fe40001800000ULL, 0xff8000004b4b7808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff80000032327808ULL, 0x000fc40003000000ULL, 0xff80000037377808ULL, 0x000fc40002000000ULL,
0x000000030400720bULL, 0x004fe40003f1e000ULL, 0x000000180500720bULL, 0x000fe40003f3e000ULL,
0x000000350600720bULL, 0x000fe40003f5e000ULL, 0x0000004c0700720bULL, 0x000fe40003f7e000ULL,
0x0000000403517208ULL, 0x000fe40004000000ULL, 0x0000000518047208ULL, 0x000fc40004800000ULL,
0x0000000635067208ULL, 0x000fe40005000000ULL, 0x000000074c1a7208ULL, 0x000fe40005800000ULL,
0x000000170400720bULL, 0x000fe40003f3e000ULL, 0x000000085100720bULL, 0x000fe40003f1e000ULL,
0x000000390600720bULL, 0x000fe40003f5e000ULL, 0x0000004d1a00720bULL, 0x000fc40003f7e000ULL,
0x0000000417047208ULL, 0x000fe40004800000ULL, 0x0000005108527208ULL, 0x000fe40004000000ULL,
0x0000000639057208ULL, 0x000fe40005000000ULL, 0x0000001a4d1a7208ULL, 0x000fe40005800000ULL,
0x000000190400720bULL, 0x000fe40003f3e000ULL, 0x000000095200720bULL, 0x000fc40003f1e000ULL,
0x0000003a0500720bULL, 0x000fe40003f5e000ULL, 0x0000004f1a00720bULL, 0x000fe40003f7e000ULL,
0x0000000419517208ULL, 0x000fe40004800000ULL, 0x0000005209077208ULL, 0x000fe40004000000ULL,
0x000000053a047208ULL, 0x000fe40005000000ULL, 0x0000001a4f057208ULL, 0x000fc40005800000ULL,
0x0000000a0700720bULL, 0x000fe40003f1e000ULL, 0x000000245100720bULL, 0x000fe40003f3e000ULL,
0x0000003b0400720bULL, 0x000fe40003f5e000ULL, 0x000000500500720bULL, 0x000fe40003f7e000ULL,
0x000000070a067208ULL, 0x000fe40004000000ULL, 0x00000051241a7208ULL, 0x000fc40004800000ULL,
0x000000043b077208ULL, 0x000fe40005000000ULL, 0x0000000550057208ULL, 0x000fe40005800000ULL,
0x0000000b0600720bULL, 0x000fe40003f1e000ULL, 0x000000251a00720bULL, 0x000fe40003f3e000ULL,
0x0000003c0700720bULL, 0x000fe40003f5e000ULL, 0x0000004e0500720bULL, 0x000fc40003f7e000ULL,
0x000000060b517208ULL, 0x000fe40004000000ULL, 0x0000001a25537208ULL, 0x000fe40004800000ULL,
0x000000073c047208ULL, 0x000fe40005000000ULL, 0x000000054e057208ULL, 0x000fe40005800000ULL,
0x0000000c5100720bULL, 0x000fe40003f1e000ULL, 0x000000265300720bULL, 0x000fc40003f3e000ULL,
0x0000003f0400720bULL, 0x000fe40003f5e000ULL, 0x000000480500720bULL, 0x000fe40003f7e000ULL,
0x000000510c067208ULL, 0x000fe40004000000ULL, 0x00000053261a7208ULL, 0x000fe40004800000ULL,
0x000000043f047208ULL, 0x000fe40005000000ULL, 0x0000000548527208ULL, 0x000fc40005800000ULL,
0x0000000d0600720bULL, 0x000fe40003f1e000ULL, 0x000000271a00720bULL, 0x000fe40003f3e000ULL,
0x000000410400720bULL, 0x000fe40003f5e000ULL, 0x0000003d5200720bULL, 0x000fe40003f7e000ULL,
0x000000060d057208ULL, 0x000fe40004000000ULL, 0x0000001a27077208ULL, 0x000fc40004800000ULL,
0x0000000441517208ULL, 0x000fe40005000000ULL, 0x000000523d537208ULL, 0x000fe40005800000ULL,
0x0000000e0500720bULL, 0x000fe40003f1e000ULL, 0x000000280700720bULL, 0x000fe40003f3e000ULL,
0x000000425100720bULL, 0x000fe40003f5e000ULL, 0x0000003e5300720bULL, 0x000fc40003f7e000ULL,
0x000000050e047208ULL, 0x000fe40004000000ULL, 0x0000000728077208ULL, 0x000fe40004800000ULL,
0x0000005142067208ULL, 0x000fe40005000000ULL, 0x000000533e537208ULL, 0x000fe40005800000ULL,
0x0000000f0400720bULL, 0x000fe40003f1e000ULL, 0x0000002a0700720bULL, 0x000fc40003f3e000ULL,
0x000000430600720bULL, 0x000fe40003f5e000ULL, 0x000000405300720bULL, 0x000fe40003f7e000ULL,
0x000000040f057208ULL, 0x000fe40004000000ULL, 0x000000072a077208ULL, 0x000fe40004800000ULL,
0x0000000643517208ULL, 0x000fe40005000000ULL, 0x0000005340537208ULL, 0x000fc40005800000ULL,
0x000000100500720bULL, 0x000fe40003f1e000ULL, 0x0000002e0700720bULL, 0x000fe40003f3e000ULL,
0x000000445100720bULL, 0x000fe40003f5e000ULL, 0x0000002c5300720bULL, 0x000fe40003f7e000ULL,
0x0000000510047208ULL, 0x000fe40004000000ULL, 0x000000072e067208ULL, 0x000fc40004800000ULL,
0x00000051441a7208ULL, 0x000fe40005000000ULL, 0x000000532c527208ULL, 0x000fe40005800000ULL,
0x000000110400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0600720bULL, 0x000fe40003f3e000ULL,
0x000000451a00720bULL, 0x000fe40003f5e000ULL, 0x000000295200720bULL, 0x000fc40003f7e000ULL,
0x0000000411057208ULL, 0x000fe40004000000ULL, 0x000000062f067208ULL, 0x000fe40004800000ULL,
0x0000001a45077208ULL, 0x000fe40005000000ULL, 0x0000005229527208ULL, 0x000fe40005800000ULL,
0x000000120500720bULL, 0x000fe40003f1e000ULL, 0x000000310600720bULL, 0x000fc40003f3e000ULL,
0x000000460700720bULL, 0x000fe40003f5e000ULL, 0x0000002b5200720bULL, 0x000fe40003f7e000ULL,
0x0000000512047208ULL, 0x000fe40004000000ULL, 0x0000000631067208ULL, 0x000fe40004800000ULL,
0x00000007461a7208ULL, 0x000fe40005000000ULL, 0x000000522b527208ULL, 0x000fc40005800000ULL,
0x000000130400720bULL, 0x000fe40003f1e000ULL, 0x000000330600720bULL, 0x000fe40003f3e000ULL,
0x000000471a00720bULL, 0x000fe40003f5e000ULL, 0x0000002d5200720bULL, 0x000fe40003f7e000ULL,
0x0000000413057208ULL, 0x000fe40004000000ULL, 0x0000000633077208ULL, 0x000fc40004800000ULL,
0x0000001a471a7208ULL, 0x000fe40005000000ULL, 0x000000522d517208ULL, 0x000fe40005800000ULL,
0x000000140500720bULL, 0x000fe40003f1e000ULL, 0x000000340700720bULL, 0x000fe40003f3e000ULL,
0x000000491a00720bULL, 0x000fe40003f5e000ULL, 0x000000305100720bULL, 0x000fc40003f7e000ULL,
0x0000000514047208ULL, 0x000fe40004000000ULL, 0x0000000734077208ULL, 0x000fe40004800000ULL,
0x0000001a49057208ULL, 0x000fe40005000000ULL, 0x0000005130517208ULL, 0x000fe40005800000ULL,
0x000000150400720bULL, 0x000fe40003f1e000ULL, 0x000000360700720bULL, 0x000fc40003f3e000ULL,
0x0000004a0500720bULL, 0x000fe40003f5e000ULL, 0x000000325100720bULL, 0x000fe40003f7e000ULL,
0x0000000415537208ULL, 0x000fe40004000000ULL, 0x0000000736077208ULL, 0x000fe40004800000ULL,
0x000000054a047208ULL, 0x000fe40005000000ULL, 0x0000005132067208ULL, 0x000fc40005800000ULL,
0x000000165300720bULL, 0x000fe40003f1e000ULL, 0x000000380700720bULL, 0x000fe40003f3e000ULL,
0x0000004b0400720bULL, 0x000fe40003f5e000ULL, 0x000000370600720bULL, 0x000fe40003f7e000ULL,
0x0000005316057208ULL, 0x000fe40004000000ULL, 0x0000000738547208ULL, 0x000fc40004800000ULL,
0x000000044b567208ULL, 0x000fe40005000000ULL, 0x0000000637557208ULL, 0x000fe20005800000ULL,
0x000025527f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x000000040500720bULL, 0x008fc80003f1e000ULL, 0x0000000504577208ULL, 0x000fe20004000000ULL,
0x000025927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0054047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0056057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0055067f89ULL, 0x000f2200000e0000ULL,
0x000000045400720bULL, 0x008fc40003f1e000ULL, 0x000000055600720bULL, 0x004fe40003f3e000ULL,
0x0000005404077208ULL, 0x002fe40004000000ULL, 0x00000056051a7208ULL, 0x000fe20004800000ULL,
0x0c201f0057047f89ULL, 0x000e6200000e0000ULL, 0x000000065500720bULL, 0x010fc60003f1e000ULL,
0x0c201f0007527f89ULL, 0x000ea200000e0000ULL, 0x00000055065a7208ULL, 0x000fc60004000000ULL,
0x0c201f001a517f89ULL, 0x000ee800000e0000ULL, 0x0c201f005a5b7f89ULL, 0x0002e400000e0000ULL,
0x000000045700720bULL, 0x002fe40003f1e000ULL, 0x000000520700720bULL, 0x004fe40003f3e000ULL,
0x0000005704047208ULL, 0x000fc40004000000ULL, 0x000000511a00720bULL, 0x008fe40003f5e000ULL,
0x0000000752057208ULL, 0x000fe40004800000ULL, 0x0000001a51067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x0000005b5a00720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe40000000000ULL, 0x3fb8aa3b03037823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b08087823ULL, 0x000fc40000010807ULL, 0x00000003005c7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b09097823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x00000008005d7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b0f527823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b10537823ULL, 0x100fe20000010807ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11557823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b12567823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b13037823ULL, 0x102fe40000010807ULL, 0x3fb8aa3b141a7823ULL, 0x100fe20000010807ULL,
0x0000000c000c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b15517823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b16547823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b06087820ULL, 0x004fe20000410000ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b34587823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b17177823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x0000000a000a7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x0000000b0c0c723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b25257823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL, 0x000000090a0a723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b33577823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b36347823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b38597823ULL, 0x000fe20000010807ULL, 0x0000005a5b077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010808ULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010808ULL, 0x000000031eff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b07337820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010808ULL,
0x000000181709723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b50507823ULL, 0x000fe20000010833ULL,
0x0000004200157308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b35357823ULL, 0x000fc40000010808ULL,
0x3fb8aa3b3a3a7823ULL, 0x000fe40000010808ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe40000010833ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010833ULL, 0x0000002400247308ULL, 0x000ea20000000800ULL,
0x00000002ff427819ULL, 0x002fe2000001161eULL, 0x3fb8aa3b4f4f7823ULL, 0x000fe40000010833ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010808ULL, 0x0000000142137810ULL, 0x040fe20007ffe0ffULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010808ULL, 0x00000003425a7819ULL, 0x040fe200000006ffULL,
0x0000002a005e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010808ULL,
0x0000000442387810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010808ULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee213ULL, 0x3fb8aa3b44447823ULL, 0x000fc40000010808ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010808ULL, 0x0000003500107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b46467823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b49497823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010808ULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0x3fb8aa3b4b087823ULL, 0x000fc40000010808ULL,
0x00000004ff0b7e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe40000010833ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010833ULL,
0x0000003a00127308ULL, 0x0007e20000000800ULL, 0x3f8000000b18783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010833ULL, 0x00000019240b723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b48487823ULL, 0x000fe20000010833ULL, 0x0000001800677202ULL, 0x000fe20000000f00ULL,
0x000000ffff197224ULL, 0x000fc400078e0018ULL, 0x0000003b003b7308ULL, 0x000ea20000000800ULL,
0x000000103910723eULL, 0x002fe200000010ffULL, 0x00000008423a7824ULL, 0x008fe400078e00ffULL,
0x000000ffff397224ULL, 0x100fe400078e0018ULL, 0x000000ffff667224ULL, 0x100fe400078e0018ULL,
0x0000004c00117308ULL, 0x000fe20000000800ULL, 0x000000ffff687224ULL, 0x100fe400078e0018ULL,
0x000000ffff697224ULL, 0x000fc400078e0018ULL, 0x3fb8aa3b40407823ULL, 0x100fe40000010833ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010833ULL, 0x0000004d002a7308ULL, 0x0002e20000000800ULL,
0x000000123b12723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b29297823ULL, 0x000fe40000010833ULL,
0x000000ffff4b7224ULL, 0x000fc800078e0018ULL, 0x0000004f00137308ULL, 0x000fe20000000800ULL,
0x00000018004d7202ULL, 0x002fce0000000f00ULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x000000112a11723eULL, 0x008fe400000010ffULL, 0xffffffff422a7810ULL, 0x000fca0007ffe0ffULL,
0x0000000d000d7308ULL, 0x000ff00000000800ULL, 0x0000000e000e7308ULL, 0x000ea20000000800ULL,
0x000000135013723eULL, 0x002fce00000010ffULL, 0x0000002500257308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x0000000d0e0e723eULL, 0x004fce00000010ffULL,
0x0000002e005f7308ULL, 0x000ff00000000800ULL, 0x0000004100167308ULL, 0x0004e20000000800ULL,
0x00000025260d723eULL, 0x002fce00000010ffULL, 0x00000045002e7308ULL, 0x0003e20000000800ULL,
0x0000000842417824ULL, 0x004fce00078e00ffULL, 0x0000000800357308ULL, 0x0005e20000000800ULL,
0x0000000842457824ULL, 0x002fe200078e00ffULL, 0x000000161516723eULL, 0x008fc800000010ffULL,
0xfffffff845647812ULL, 0x000fe200078ee238ULL, 0x000000ffff387224ULL, 0x000fe200078e0018ULL,
0x00000027000f7308ULL, 0x0003e20000000800ULL, 0x0000000342087810ULL, 0x004fc80007ffe0ffULL,
0xfffffff841627812ULL, 0x000fe400078ee208ULL, 0x0000005c5d08723eULL, 0x000fe200000010ffULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x0000000242277810ULL, 0x002fe40007ffe0ffULL,
0xfffffff8455c7812ULL, 0x000fe400078ee22aULL, 0xfffffff83a4c7812ULL, 0x000fe400078ee227ULL,
0x000000180824723cULL, 0x000b6200000418ffULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x00000010422a7810ULL, 0x000fca0007ffe0ffULL, 0x0000000542197810ULL, 0x020fe20007ffe0ffULL,
0x000000381038723cULL, 0x000f6200000418ffULL, 0x0000004800177308ULL, 0x000e620000000800ULL,
0x0000000f280f723eULL, 0x004fe400000010ffULL, 0x0000000642287810ULL, 0x000fc80007ffe0ffULL,
0xfffffff841507812ULL, 0x000fe200078ee228ULL, 0x0000003c00147308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b37417823ULL, 0x000fe20000010833ULL, 0x0000000842287810ULL, 0x000fca0007ffe0ffULL,
0x000000660c24723cULL, 0x000be20000041824ULL, 0x0000003f003f7308ULL, 0x000ee20000000800ULL,
0x00000008423c7824ULL, 0x004fe200078e00ffULL, 0x0000004e1715723eULL, 0x002fe200000010ffULL,
0x0000000828457824ULL, 0x000fc600078e00ffULL, 0xfffffff83c487812ULL, 0x000fe200078ee219ULL,
0x3fb8aa3b2b3c7823ULL, 0x000fe20000010833ULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x00000008422b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8454e7812ULL, 0x000fcc00078ee228ULL,
0x0000003e003e7308ULL, 0x000e620000000800ULL, 0x000000143f14723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b323f7823ULL, 0x000fcc0000010833ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x0000003d3e17723eULL, 0x002fce00000010ffULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2d3d7823ULL, 0x100fe40000010833ULL, 0x3fb8aa3b303e7823ULL, 0x000fe20000010833ULL,
0x000000681438723cULL, 0x020f680000041838ULL, 0x0000005500557308ULL, 0x000ff00000000800ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x000000525328723eULL, 0x002fce00000010ffULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000003100607308ULL, 0x000e700000000800ULL,
0x0000004000407308ULL, 0x000ff00000000800ULL, 0x0000002c00197308ULL, 0x000ff00000000800ULL,
0x0000004300437308ULL, 0x000ff00000000800ULL, 0x0000004400447308ULL, 0x000eb00000000800ULL,
0x0000004600317308ULL, 0x0007300000000800ULL, 0x0000002900307308ULL, 0x0009e20000000800ULL,
0xfffffff82b467812ULL, 0x008fc400078ee242ULL, 0x0000001842427810ULL, 0x000fe40007ffe0ffULL,
0x0000002f602b723eULL, 0x002fe400000010ffULL, 0x00000043442c723eULL, 0x004fe200000010ffULL,
0x0000003c00337308ULL, 0x000e620000000800ULL, 0x00000008422d7824ULL, 0x000fe200078e00ffULL,
0x0000005e5f29723eULL, 0x010fe200000010ffULL, 0x000000ffff5e7224ULL, 0x100fe200078e0018ULL,
0x0000002e312e723eULL, 0x000fe200000010ffULL, 0x000000ffff5f7224ULL, 0x000fe200078e0018ULL,
0xfffffff82d527812ULL, 0x000fc400078ee242ULL, 0x0000004900367308ULL, 0x0005e20000000800ULL,
0x00000040192d723eULL, 0x000fe200000010ffULL, 0x000000ffff197224ULL, 0x000fcc00078e0018ULL,
0x0000000300037308ULL, 0x000fe20000000800ULL, 0x000000082a497824ULL, 0x004fe200078e00ffULL,
0x00000030332f723eULL, 0x002fc800000010ffULL, 0xfffffff849667812ULL, 0x000fe400078ee22aULL,
0x0000001a001a7308ULL, 0x000e620000000800ULL, 0x00000055562a723eULL, 0x000fe200000010ffULL,
0x000000182c38723cULL, 0x020fe20000041838ULL, 0x0000000c02497812ULL, 0x000fca00078ec0ffULL,
0x0000003400347308ULL, 0x000fe40000000800ULL, 0x0000005e2830723cULL, 0x000b6c0000041824ULL,
0x0000005900597308ULL, 0x000ea20000000800ULL, 0x000000031a24723eULL, 0x022fe400000010ffULL,
0x000120009d037811ULL, 0x000fc800078e60ffULL, 0x0000000346197211ULL, 0x000fe200078e20ffULL,
0x0000004700477308ULL, 0x000e620000000800ULL, 0x000000105a1a7824ULL, 0x100fe400078e0203ULL,
0x000000104c3c7824ULL, 0x100fe400078e0203ULL, 0x0000001062407824ULL, 0x100fe400078e0203ULL,
0x0000001064427824ULL, 0x000fe200078e0203ULL, 0x0000005100517308ULL, 0x000fe20000000800ULL,
0x000000345927723eULL, 0x004fe200000010ffULL, 0x000000ffff4c7224ULL, 0x000fc400078e0018ULL,
0x0000000149197824ULL, 0x040fe400078e0219ULL, 0x00000001491a7824ULL, 0x040fe400078e021aULL,
0x0000005400547308ULL, 0x000ea20000000800ULL, 0x000000473634723eULL, 0x002fe200000010ffULL,
0x0000001050437824ULL, 0x100fe200078e0203ULL, 0x0000000819007388ULL, 0x0003e20000000800ULL,
0x00000001493c7824ULL, 0x040fe400078e023cULL, 0x000000105c447824ULL, 0x000fe200078e0203ULL,
0x0000000a1a007388ULL, 0x0007e20000000800ULL, 0x0000005700577308ULL, 0x000fe20000000800ULL,
0x0000000149407824ULL, 0x000fc400078e0240ULL, 0x000000104e457824ULL, 0x000fe200078e0203ULL,
0x0000000c3c007388ULL, 0x0007e20000000800ULL, 0x0000000149427824ULL, 0x040fe400078e0242ULL,
0x0000000149437824ULL, 0x040fe200078e0243ULL, 0x0000005800587308ULL, 0x000f220000000800ULL,
0x000000515426723eULL, 0x004fe200000010ffULL, 0x0000000149447824ULL, 0x000fe200078e0244ULL,
0x0000000e40007388ULL, 0x0007e20000000800ULL, 0x0000001066467824ULL, 0x000fc600078e0203ULL,
0x0000002842007388ULL, 0x0007e20000000800ULL, 0x0000004a004a7308ULL, 0x000eb00000000800ULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x000000575825723eULL, 0x010fce00000010ffULL,
0x0000003e003e7308ULL, 0x000f220000000800ULL, 0x0000004a3536723eULL, 0x004fe200000010ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e0018ULL, 0x0000004c2430723cULL, 0x000f6a0000041830ULL,
0x0000003f00377308ULL, 0x0005f00000000800ULL, 0x0000004100027308ULL, 0x0002e20000000800ULL,
0x00000010483f7824ULL, 0x004fe200078e0203ULL, 0x0000003d3e35723eULL, 0x010fc800000010ffULL,
0x0000003f493f7210ULL, 0x000fe20007ffe0ffULL, 0x0000001052417824ULL, 0x002fc800078e0203ULL,
0x0000002a3f007388ULL, 0x0003e20000000800ULL, 0x0000000149037824ULL, 0x040fe400078e0246ULL,
0x0000000149087824ULL, 0x040fe200078e0241ULL, 0x0000002443007388ULL, 0x0003e20000000800ULL,
0x000000370237723eULL, 0x008fe200000010ffULL, 0x0000000149027824ULL, 0x000fe400078e0245ULL,
0x0000002644007388ULL, 0x0003e20000000800ULL, 0x000000ffff317224ULL, 0x020fc600078e0032ULL,
0x0000004a3438723cULL, 0x000f620000041838ULL, 0x0000000902007388ULL, 0x0003e80000000800ULL,
0x0004000b1a007388ULL, 0x0003e80000000800ULL, 0x0004000d3c007388ULL, 0x0003e80000000800ULL,
0x0004000f40007388ULL, 0x0003e80000000800ULL, 0x0004002942007388ULL, 0x0003e80000000800ULL,
0x0004002b3f007388ULL, 0x0003e60000000800ULL, 0x000000ffff327224ULL, 0x020fe200078e0038ULL,
0x0004002543007388ULL, 0x0003e20000000800ULL, 0x000000ffff337224ULL, 0x000fc600078e003aULL,
0x0004002744007388ULL, 0x0003e80000000800ULL, 0x0000001003007388ULL, 0x0003e80000000800ULL,
0x000800121a007388ULL, 0x0003e80000000800ULL, 0x000800143c007388ULL, 0x0003e80000000800ULL,
0x0008001640007388ULL, 0x0003e80000000800ULL, 0x0008002c42007388ULL, 0x0003e80000000800ULL,
0x0008002e3f007388ULL, 0x0003e80000000800ULL, 0x0008003443007388ULL, 0x0003e80000000800ULL,
0x0008003644007388ULL, 0x0003e80000000800ULL, 0x0000001108007388ULL, 0x0003e80000000800ULL,
0x000c00131a007388ULL, 0x0003e80000000800ULL, 0x000c00153c007388ULL, 0x0003e80000000800ULL,
0x000c001740007388ULL, 0x0003e80000000800ULL, 0x000c002d42007388ULL, 0x0003e80000000800ULL,
0x000c002f3f007388ULL, 0x0003e80000000800ULL, 0x000c003543007388ULL, 0x0003e80000000800ULL,
0x000c003744007388ULL, 0x0003e80000000800ULL, 0x01e0000400008388ULL, 0x0003e80000000c00ULL,
0x01e2003000008388ULL, 0x0003e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e60800a1ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e61000a1ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e61800a1ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000229000720cULL, 0x000fe20003f06070ULL, 0x01e62000a1ff7f8cULL, 0x0003e2000c80043fULL,
0x0000009000997202ULL, 0x000fd60000000f00ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff74c000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff1e7807ULL, 0x008fe20004000000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x0001a1a000207802ULL, 0x000fc40000000f00ULL, 0x0000160000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e001eULL, 0xfffe8fe000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x000fe20005000000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x0001a20000207802ULL, 0x000fc40000000f00ULL, 0x000015a000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e001eULL, 0xfffe902000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x0001a270001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000014e000007944ULL, 0x012fea0003c00000ULL, 0xfffe90d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0xffffffff00217802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001a2d0001f7802ULL, 0x000fc40000000f00ULL,
0x0000148000007944ULL, 0x012fea0003c00000ULL, 0xfffe91e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x0001a330001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000142000007944ULL, 0x012fea0003c00000ULL, 0xfffe92f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0007ULL, 0x0001a390001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000013c000007944ULL, 0x012fea0003c00000ULL, 0xfffe93f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0002ULL, 0xffffffff00217802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0003ULL, 0x0001a400001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0x0000135000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001eULL, 0xfffe958000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0002ULL, 0x0001a470001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000012e000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001eULL,
0x00000010031e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff207224ULL, 0x000fe200078e0002ULL,
0x0001a4e0001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000127000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001eULL, 0xfffe94f000007947ULL, 0x000fea000383ffffULL,
0x0000000200207202ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001a550001f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000120000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e001eULL,
0xfffe94b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x008fe20004000000ULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0001a5b000207802ULL, 0x000fc40000000f00ULL,
0x000011f000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff197224ULL, 0x000fe200078e001eULL,
0xfffead0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x000fe40004800000ULL,
0xffffffff001f7802ULL, 0x000fc40000000f00ULL, 0x0001a61000207802ULL, 0x000fc40000000f00ULL,
0x0000119000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff667224ULL, 0x000fe200078e001eULL,
0xfffead4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001a680001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000010d000007944ULL, 0x000fea0003c00000ULL,
0xfffeae0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001a6e0001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000107000007944ULL, 0x002fea0003c00000ULL,
0xfffeaf1000007947ULL, 0x000fea000383ffffULL, 0x0000006800207202ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001a740001f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000101000007944ULL, 0x002fea0003c00000ULL,
0xfffeb02000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001a7a0001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000fb000007944ULL, 0x002fea0003c00000ULL,
0xfffeb12000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001a810001f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0019ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000f4000007944ULL, 0x000fea0003c00000ULL, 0x0000001e00117202ULL, 0x004fe20000000f00ULL,
0xfffeb2a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001a880001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000ed000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001eULL, 0x00000010191e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001a8f0001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000e6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e001eULL,
0xfffeb21000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0000001f00677802ULL, 0x000fe20000000f00ULL, 0xffffffffff217424ULL, 0x000fe200078e00ffULL,
0x0001a960001f7802ULL, 0x000fc40000000f00ULL, 0x00000df000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001eULL, 0xfffeb1d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x004fe20004000000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x0001a9c000207802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff657224ULL, 0x000fe200078e001eULL, 0xfffec82000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7807ULL, 0x000fe20004800000ULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x0001aa2000207802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff667224ULL, 0x000fe200078e001eULL, 0xfffec85000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0x0001aa90001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000cc000007944ULL, 0x018fea0003c00000ULL, 0xfffec91000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0x0001aaf0001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000c6000007944ULL, 0x01afea0003c00000ULL, 0xfffeca2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0xffffffff00217802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe200078e00ffULL, 0x0001ab50001f7802ULL, 0x000fc40000000f00ULL,
0x00000c0000007944ULL, 0x01afea0003c00000ULL, 0xfffecb3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e0068ULL, 0x0001abb0001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x00000ba000007944ULL, 0x01afea0003c00000ULL, 0xfffecc3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001ac20001f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0065ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000b3000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001eULL, 0xfffecdb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0000001f00677802ULL, 0x000fe20000000f00ULL,
0xffffffffff217424ULL, 0x000fe200078e00ffULL, 0x0001ac90001f7802ULL, 0x000fc40000000f00ULL,
0x00000ac000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001eULL,
0x00000010651e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001ad00001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001eULL, 0xfffecd2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0001ad70001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fe400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x000009e000007944ULL, 0x016fea0003c00000ULL, 0x0000001e000e7202ULL, 0x004fe20000000f00ULL,
0xfffecce000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x008fe20004000000ULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0001add000207802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff667224ULL, 0x000fe200078e001eULL,
0xfffee29000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1e7807ULL, 0x000fe20004800000ULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x0001ae3000207802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff697224ULL, 0x000fe200078e001eULL,
0xfffee2c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0xffffffff00217802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe200078e00ffULL,
0x0001aea0001f7802ULL, 0x000fc40000000f00ULL, 0x000008b000007944ULL, 0x010fea0003c00000ULL,
0xfffee38000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001af00001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000085000007944ULL, 0x012fea0003c00000ULL,
0xfffee49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001af60001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000007f000007944ULL, 0x012fea0003c00000ULL,
0xfffee5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0068ULL,
0x0001afc0001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x0000079000007944ULL, 0x012fea0003c00000ULL,
0xfffee6a000007947ULL, 0x000fea000383ffffULL, 0x0000000e00207202ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe200078e0013ULL, 0x0001b030001f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff677424ULL, 0x000fc400078e00ffULL, 0xffffffffff217424ULL, 0x000fc400078e00ffULL,
0x0000072000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e001eULL,
0xfffee82000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001b0a0001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fe400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001eULL, 0x00000010131e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff207224ULL, 0x000fe200078e000eULL, 0x0000001f00677802ULL, 0x000fe20000000f00ULL,
0xffffffffff217424ULL, 0x000fe200078e00ffULL, 0x0001b110001f7802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e001eULL,
0xfffee79000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e000eULL,
0x0001b180001f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff677424ULL, 0x000fc400078e00ffULL,
0xffffffffff217424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001eULL, 0xfffee75000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0xffffffff00587802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x000fe200078e00ffULL, 0x0001b20000527802ULL, 0x000fe20000000f00ULL,
0x0000001fff5b7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e005bULL, 0xffffda4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001b28000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x000fe400078e00ffULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x004fea0003c00000ULL,
0x0000005b5400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0056ULL,
0x0001b30000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff1a7424ULL, 0x000fe200078e00ffULL,
0x000000545b067208ULL, 0x000fe20004000000ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5600720bULL, 0x004fe20003f1e000ULL, 0x00000002ff1a7424ULL, 0x002fe200078e00ffULL,
0x0000005500077202ULL, 0x000fe20000000f00ULL, 0xffffffffff587424ULL, 0x000fe200078e00ffULL,
0x000000565b547208ULL, 0x000fe20004000000ULL, 0x0000001fff5b7424ULL, 0x000fe200078e00ffULL,
0x0001b38000527802ULL, 0x000fc40000000f00ULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0057ULL,
0x0001b40000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x000000555b5a7208ULL, 0x000fe20004000000ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001b48000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x000000575b047208ULL, 0x000fe20004000000ULL, 0xffffffffff587424ULL, 0x000fe200078e00ffULL,
0x0000001f005b7802ULL, 0x000fc40000000f00ULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x0000005b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x0001b50000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x000000065b057208ULL, 0x000fe20004000000ULL, 0x0000001fff5b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x0000005b5400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e005aULL,
0x0001b58000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x000fe200078e00ffULL,
0x000000545b067208ULL, 0x000fe20004000000ULL, 0x0000001fff5b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffd83000007947ULL, 0x000fea000383ffffULL, 0x0180000006007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000600008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000006000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x006fe400078e0008ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe48f006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff537424ULL, 0x000fe200078e00ffULL,
0x0000005800007348ULL, 0x000fe80003800000ULL, 0x0c00001a075b7389ULL, 0x0002a200000e005bULL,
0xfffe48b052007950ULL, 0x000fea0003c3ffffULL, 0x0000002100007348ULL, 0x000fe80003800000ULL,
0x0000001e201e7389ULL, 0x0002a400000e0067ULL, 0x000000ffff207224ULL, 0x002fc400078e001fULL,
0x00000000ff217424ULL, 0x000fc800078e00ffULL, 0xfffe486020007950ULL, 0x000fea0003c3ffffULL,
0x000000011e00780cULL, 0x000fe20003f45070ULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000001f00007348ULL, 0x000ff60003800000ULL, 0x00000000001e7806ULL, 0x000fc800050e0100ULL,
0x0000001f1e1e7212ULL, 0x000fe200078ec0ffULL, 0xfffe480020007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000868ULL,
0x00000000000002a8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b10ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bd0ULL,
0x00000000000006d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012a0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012b0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001340ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001344ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x000000000001b900ULL, 0xde00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ce80ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001cec0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001d240ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001340ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001bb40ULL,
0x000000000001bb40ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001ce80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001d240ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 119584;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
