/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015238ULL, 0x0000000000014eb8ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL,
0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL,
0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x6c65722e00687461ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL,
0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000000beULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000fcULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0001000001c6ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b00010000020cULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000299ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000002e7ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000335ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000003d6ULL, 0x0000000000013b60ULL, 0x0000000000000220ULL, 0x000400030000044cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000013d80ULL, 0x000d00030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00013b6000000000ULL, 0x0001380400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808892ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL, 0x00013b6000000000ULL,
0x0000022000000000ULL, 0x0000000000000000ULL, 0x0000001400082f04ULL, 0x0008230400000080ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL,
0x0030000700000000ULL, 0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0xffffffff00b42904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000031000b42804ULL,
0x0000081000000340ULL, 0x00002f5000001f70ULL, 0x000030b000002fd0ULL, 0x000035a0000031f0ULL,
0x00003aa0000035b0ULL, 0x0000497000004900ULL, 0x00004bb000004a70ULL, 0x00004dc000004db0ULL,
0x0000608000005180ULL, 0x000061f0000060f0ULL, 0x0000653000006330ULL, 0x0000690000006540ULL,
0x0000787000007800ULL, 0x00007ab000007970ULL, 0x00007d3000007d20ULL, 0x000082a000008290ULL,
0x0000a4f00000a4c0ULL, 0x0000abd00000aba0ULL, 0x0001304000012f90ULL, 0x000132e000013240ULL,
0x0001367000013640ULL, 0x0001388000013730ULL, 0x0000053001f03904ULL, 0x0001b600000000ffULL,
0x0000061000040100ULL, 0x0001b60800000005ULL, 0x00000720003f0100ULL, 0x0001b68800000004ULL,
0x00000e90003f0100ULL, 0x0001b60000000002ULL, 0x00001040003f0107ULL, 0x0001b68800000007ULL,
0x00002ce0003f0101ULL, 0x0001b6080000001fULL, 0x00002d00003f0101ULL, 0x0001b6080000001fULL,
0x00002e70003f0109ULL, 0x0001b6080000001fULL, 0x00003a30003f0109ULL, 0x0001b68800000027ULL,
0x000046f0003f0101ULL, 0x0001b6280000001fULL, 0x00004710003f0101ULL, 0x0001b6280000001fULL,
0x00004880003f0109ULL, 0x0001b6280000001fULL, 0x00005110003f0109ULL, 0x0001b6900000001dULL,
0x00005e70003f0101ULL, 0x0001b6480000001dULL, 0x00005e90003f0101ULL, 0x0001b6480000001dULL,
0x00006000003f0109ULL, 0x0001b6480000001dULL, 0x000068d0003f0109ULL, 0x0001b6980000001dULL,
0x000075f0003f0101ULL, 0x0001b6680000001fULL, 0x00007610003f0101ULL, 0x0001b6680000001fULL,
0x00007780003f0109ULL, 0x0001b6680000001fULL, 0x00008030003f0109ULL, 0x0001b6a00000004dULL,
0x0000bb30003f0101ULL, 0x0001b60000000002ULL, 0x0000d400003f0101ULL, 0x0001b60000000002ULL,
0x0000d5c0003f0109ULL, 0x0001b60000000002ULL, 0x00011370003f0109ULL, 0x0001b68800000007ULL,
0x00011640003f0101ULL, 0x0001b68800000007ULL, 0x000117b0003f0109ULL, 0x0001b68800000007ULL,
0x00013b00003f0109ULL, 0x0001b6080000000aULL, 0x00013b10003f0101ULL, 0x0001b6100000000aULL,
0x00013b20003f0101ULL, 0x0001b6180000000aULL, 0x00013b30003f0101ULL, 0x0001b6200000000aULL,
0x00033803003f0101ULL, 0x0000b1f000201c04ULL, 0x0000b4d00000b210ULL, 0x0000b8c00000b6c0ULL,
0x0000d5f00000ba70ULL, 0x000c050400013b50ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0068190300000000ULL, 0x0000001500080a04ULL, 0x0000000000680210ULL, 0x00000000000000bcULL,
0x0000001400000002ULL, 0x0000000000013b60ULL, 0x0000000000000044ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001400000002ULL, 0x0000000000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000087919ULL, 0x000ee20000002700ULL, 0x0000820000067ab9ULL, 0x000fcc0000000a00ULL,
0x00008500ff0e7b82ULL, 0x000f220000000800ULL, 0x000000ff0200720cULL, 0x004fc80003f45070ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff022b82ULL, 0x000ea20000000a00ULL,
0x0000000108052836ULL, 0x008fe40000000000ULL, 0x00000004080c2825ULL, 0x004fc800078e0002ULL,
0x0000000405022825ULL, 0x000fe400078e0002ULL, 0x000000060c0c2981ULL, 0x000ea8000c1e1900ULL,
0x00000006025f2981ULL, 0x0006a2000c1e1900ULL, 0x0000000e00067306ULL, 0x010f220000209000ULL,
0x00000300ff007b82ULL, 0x000f620000000800ULL, 0x000000ff0e00720cULL, 0x000fe20003f65070ULL,
0x0000000000107919ULL, 0x000ee20000002300ULL, 0x0000046000007945ULL, 0x000fe20003800000ULL,
0x00000000005e7919ULL, 0x000ee80000002600ULL, 0x00000400ff077b82ULL, 0x000ee20000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x00000000005d7919ULL, 0x000ee20000002100ULL,
0x0000000600067308ULL, 0x010f240000001000ULL, 0x0ffffffe06047836ULL, 0x010fcc0000000000ULL,
0x0000000400057305ULL, 0x000964000021f000ULL, 0x000000ffff047224ULL, 0x010fe400078e00ffULL,
0x000000ffff097224ULL, 0x022fc800078e0a05ULL, 0x0000000e09097224ULL, 0x000fc800078e02ffULL,
0x0000000905057227ULL, 0x000fcc00078e0004ULL, 0x0000000705057227ULL, 0x008fca00078e00ffULL,
0x000000ff05037210ULL, 0x000fca0007ffe1ffULL, 0x000000030e037224ULL, 0x000fe400078e0207ULL,
0x0000000000077919ULL, 0x000e660000002200ULL, 0x0000000e0300720cULL, 0x000fda0003f06070ULL,
0x0000000103030824ULL, 0x000fe400078e0a0eULL, 0x0000000105050836ULL, 0x000fc60000000000ULL,
0x0000000e0300720cULL, 0x000fda0003f26070ULL, 0x0000000105051836ULL, 0x000fe20000000000ULL,
0x0000000eff05b212ULL, 0x000fc800078e33ffULL, 0x0000000500047306ULL, 0x000ee20000209000ULL,
0x000000ff0500720cULL, 0x000fce0003f85070ULL, 0x0000000400047308ULL, 0x008ee40000001000ULL,
0x0ffffffe04027836ULL, 0x008fe40000000000ULL, 0x0000000410047c24ULL, 0x002fe2000f8e0207ULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000200037305ULL, 0x0002e2000021f000ULL,
0x00008400ff07ab82ULL, 0x000f220000000800ULL, 0x0000000404047c24ULL, 0x100fe2000f8e025dULL,
0x00000005ff5d7819ULL, 0x000fe2000001165dULL, 0x00001fff10107589ULL, 0x000f2600000e0000ULL,
0x0000007f0400780cULL, 0x000fe20003f64070ULL, 0x000000ffff027224ULL, 0x002fe200078e00ffULL,
0x00001fff5d5d7589ULL, 0x000f2200000e0000ULL, 0x0000000305067224ULL, 0x008fca00078e02ffULL,
0x000000ff06097210ULL, 0x000fca0007ffe1ffULL, 0x000004000006b802ULL, 0x000fe20000000f00ULL,
0x0000000903037227ULL, 0x000fe400078e0002ULL, 0x000000000009b919ULL, 0x000e680000008800ULL,
0x0000005e03037227ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a03ULL,
0x0000000205027224ULL, 0x000fca00078e025eULL, 0x000000050200720cULL, 0x000fda0003f06070ULL,
0x0000000102020824ULL, 0x000fe200078e0a05ULL, 0x0000000103030810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000050200720cULL, 0x000fe40003f26070ULL,
0x00000654090bb816ULL, 0x002fe20000000006ULL, 0xff317217ff09b424ULL, 0x000fd400078e00ffULL,
0x0000000103031836ULL, 0x000fe20000000000ULL, 0x00000005ff03c212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000030400780cULL, 0x000fe20003f84070ULL,
0x000000ffff027224ULL, 0x000fc800078e0a03ULL, 0x00000002055e7224ULL, 0x000fe400078e025eULL,
0x000000040402b824ULL, 0x000fe400078e020bULL, 0x000000015f5f2824ULL, 0x004fcc00078e0a0cULL,
0x00008400ff5fab82ULL, 0x000ea20000000800ULL, 0x0000000000240947ULL, 0x010fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60008043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01b60804083f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b68804083f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000045e5e7819ULL, 0x000fe200000006ffULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x0000000000607919ULL, 0x000e620000002500ULL, 0x000000045f057c24ULL, 0x004fe4000f8e02ffULL,
0x000000ffff067224ULL, 0x000fe200078e0a5eULL, 0x01b400090200b388ULL, 0x0005e20000000800ULL,
0x00000007080ca224ULL, 0x000fe200078e02ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000005e0500720cULL, 0x000fe20003f06070ULL, 0x000000040e117c24ULL, 0x000fe2000f8e02ffULL,
0x0000001005067446ULL, 0x000fe20003800006ULL, 0x0000000410027824ULL, 0x004fc400078e025dULL,
0x000000110c057224ULL, 0x000fe200078e02ffULL, 0x000000ff06067207ULL, 0x000fe20000000000ULL,
0x0000000202077824ULL, 0x000fe400078e00ffULL, 0x0000000403137c24ULL, 0x000fe2000f8e0205ULL,
0x000000100600780cULL, 0x000fda0003f05270ULL, 0x0000000000c08947ULL, 0x002fea0003800000ULL,
0x0000000400027d06ULL, 0x000e620008209000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x00000004ff007c0cULL, 0x000fe2000bf45070ULL, 0x0000000000157919ULL, 0x000eea0000008800ULL,
0x0000000200027308ULL, 0x002e640000001000ULL, 0x0ffffffe020a7836ULL, 0x002fe20000000000ULL,
0x00000004ff0d7819ULL, 0x004fca0000011604ULL, 0x0000000a000b7305ULL, 0x0002a2000021f000ULL,
0x00000001070f7824ULL, 0x000fc800078e020dULL, 0x000000015e027824ULL, 0x000fe400078e020fULL,
0x000000ffff0a7224ULL, 0x002fe400078e00ffULL, 0x000000100f127824ULL, 0x000fe200078e00ffULL,
0x8000000bff097210ULL, 0x004fca0007ffe0ffULL, 0x0000000409097c24ULL, 0x000fc8000f8e02ffULL,
0x000000090b0b7227ULL, 0x000fcc00078e000aULL, 0x000000020b0b7227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0bULL, 0x0000000409097c24ULL, 0x000fca000f8e0202ULL,
0x0000000409007c0cULL, 0x000fda000bf06070ULL, 0x8000000409090c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b0b0836ULL, 0x000fc60000000000ULL, 0x0000000409007c0cULL, 0x000fda000bf26070ULL,
0x000000010b0b1836ULL, 0x000fe20000000000ULL, 0x00000004ff0bac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0bULL, 0x0000000409027c24ULL, 0x000fe2000f8e0202ULL,
0x0000000404097819ULL, 0x000fe200000006ffULL, 0x00008c0000047ab9ULL, 0x000fe40000000a00ULL,
0x00000001130a7824ULL, 0x000fe200078e0202ULL, 0x0000000706027248ULL, 0x000fc60007fe0000ULL,
0x000000110b0a7224ULL, 0x000fe400078e020aULL, 0x0000000102027824ULL, 0x000fe200078e0a07ULL,
0x000000f009077812ULL, 0x000fe200078ec0ffULL, 0x000001000a0a7825ULL, 0x000fc600078e00ffULL,
0x000000020d00720cULL, 0x000fe20003f06070ULL, 0x000000010f0d7824ULL, 0x000fe200078e0204ULL,
0x0000040000027802ULL, 0x000fe40000000f00ULL, 0x000000070a077212ULL, 0x000fe400078efcffULL,
0x0000065415027816ULL, 0x008fe40000000002ULL, 0xfffffff0120d7812ULL, 0x000fe400078ee20dULL,
0x00000004070a7c10ULL, 0x000fc6000ff3e0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x000000050b0b7c10ULL, 0x000fca0008ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c46ULL, 0x0000000000ac7947ULL, 0x000fea0003800000ULL,
0x0000000400097d06ULL, 0x000e620008209000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00000004ff007c0cULL, 0x000fe2000bf45070ULL,
0x0000000000157919ULL, 0x000ee80000008800ULL, 0x0000000900097308ULL, 0x002e640000001000ULL,
0x0ffffffe090d7810ULL, 0x002fc40007ffe0ffULL, 0x0000000704077211ULL, 0x004fc800078fe0ffULL,
0x0000000d000b7305ULL, 0x0002a2000021f000ULL, 0x000000015e027824ULL, 0x000fe400078e0207ULL,
0x0000001007127824ULL, 0x040fe400078e00ffULL, 0x00000001070d7824ULL, 0x002fca00078e0204ULL,
0xfffffff0120d7812ULL, 0x000fe200078ee20dULL, 0x000000ffff0f7224ULL, 0x004fc800078e0a0bULL,
0x000000040f0f7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000f0b0f7227ULL, 0x000fcc00078e000aULL,
0x000000020f097227ULL, 0x000fc800078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL,
0x000000040b0a7c24ULL, 0x000fca000f8e0202ULL, 0x000000040a007c0cULL, 0x000fda000bf06070ULL,
0x800000040a0a0c10ULL, 0x000fe2000fffe0ffULL, 0x0000000109090836ULL, 0x000fc60000000000ULL,
0x000000040a007c0cULL, 0x000fda000bf26070ULL, 0x0000000109091836ULL, 0x000fe20000000000ULL,
0x00000004ff09ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff0b7224ULL, 0x000fc800078e0a09ULL,
0x000000040b027c24ULL, 0x000fe2000f8e0202ULL, 0x00008c0000047ab9ULL, 0x000fc60000000a00ULL,
0x0000000113027824ULL, 0x000fc800078e0202ULL, 0x0000001109027224ULL, 0x000fe200078e0202ULL,
0x0000000404097819ULL, 0x000fc600000006ffULL, 0x00000100020a7825ULL, 0x000fe200078e00ffULL,
0x000000f0090f7812ULL, 0x000fe400078ec0ffULL, 0x0000040000027802ULL, 0x000fe40000000f00ULL,
0x0000000f0a0a7212ULL, 0x000fe400078efcffULL, 0x0000065415027816ULL, 0x008fe40000000002ULL,
0x000000040a0a7c10ULL, 0x000fc6000ff1e0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0x000000050b0b7c10ULL, 0x000fca00087fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e8000b901c46ULL, 0x00000000020472caULL, 0x000fe200000e0000ULL,
0x00009400ff0a7b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001b60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x00000004080a7825ULL, 0x002fe200078e000aULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x000000060a5c7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x0000007f5c5b7836ULL, 0x004fe20000000000ULL,
0x000000ff5c5a7810ULL, 0x000fc80007ffe0ffULL, 0x00000007ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff5a7819ULL, 0x000fca000001165aULL, 0x000000a800c88947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fe2000001165dULL, 0x000000085d467824ULL, 0x000fe400078e00ffULL,
0xffffffffff517424ULL, 0x000fe200078e00ffULL, 0x01ffffff07077812ULL, 0x000fca00078ec0ffULL,
0x0000000260527824ULL, 0x000fca00078e0207ULL, 0x0000005b5200720cULL, 0x000fda0003f06070ULL,
0x00009600ff0a8b82ULL, 0x000e620000000800ULL, 0x0000000208078824ULL, 0x000fce00078e00ffULL,
0x00009200ff0c8b82ULL, 0x000ea20000000a00ULL, 0x0000000a07078224ULL, 0x002fe200078e020aULL,
0x00000004000a7802ULL, 0x000fc60000000f00ULL, 0x0000000152078824ULL, 0x000fc800078e0207ULL,
0x00000004070c8825ULL, 0x004fc800078e000cULL, 0x0000000102077824ULL, 0x000fc800078e0246ULL,
0x01b6880a07ff79a7ULL, 0x0003e2000850003fULL, 0x000000060c518981ULL, 0x000ea2000c1e1900ULL,
0x00000001600f7836ULL, 0x000fe20000000000ULL, 0x00000001ff4f7819ULL, 0x000fe2000001165dULL,
0x0000008003447824ULL, 0x000fc600078e00ffULL, 0x0000005a0f00720cULL, 0x000fe20003f06070ULL,
0x000000204f457824ULL, 0x000fc800078e00ffULL, 0x0000010060117824ULL, 0x000fe200078e0245ULL,
0x00009000ff0a7b82ULL, 0x002e680000000a00ULL, 0x0000006044137812ULL, 0x000fe200078ef811ULL,
0x0000000e510e7224ULL, 0x004fca00078e02ffULL, 0x000000070e077819ULL, 0x000fca00000006ffULL,
0x00000100070a7825ULL, 0x002fe200078e000aULL, 0x000000015d077812ULL, 0x000fe200078ec0ffULL,
0x0000000400948947ULL, 0x000fec0003800000ULL, 0x00000070090c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fe20000011604ULL,
0x000000ffff147224ULL, 0x000fe200078e0a11ULL, 0x000000115c097248ULL, 0x000fe20007fe0000ULL,
0x00000080070c7824ULL, 0x000fe200078e020cULL, 0x0000000412107810ULL, 0x000fe20007ffe0ffULL,
0x00000001130f7824ULL, 0x000fe200078e0212ULL, 0x0000002009097446ULL, 0x000fe20003800014ULL,
0x00000008121e7836ULL, 0x000fe40000000000ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x000000091000720cULL, 0x000fc40003f26070ULL, 0x000000091e00720cULL, 0x080fe20003fa6070ULL,
0x0000000110117824ULL, 0x040fe200078e0204ULL, 0x0000000e0a167210ULL, 0x000fe20007f1e0ffULL,
0x00000008101c7824ULL, 0x000fe400078e00ffULL, 0x000040004f0e7824ULL, 0x000fe200078e0202ULL,
0x0000000f0b177210ULL, 0x000fe200007fe4ffULL, 0x00000001130f7824ULL, 0x000fe200078e0210ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL, 0x0000000c12207836ULL, 0x000fe20000000000ULL,
0x0000000e071a7211ULL, 0x000fe200078e68ffULL, 0x0000000112107824ULL, 0x040fe200078e0204ULL,
0x000000091200720cULL, 0x080fe20003f06070ULL, 0x0000000113117824ULL, 0x000fe200078e021eULL,
0x000000092000720cULL, 0x000fe20003f86070ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000000710197812ULL, 0x000fc600078ec0ffULL, 0x0000000113157824ULL, 0x000fe200078e0220ULL,
0x0000000e0a187210ULL, 0x000fe20007f5e0ffULL, 0x0000010011107825ULL, 0x000fc800078e000cULL,
0x0000010015147825ULL, 0x000fe200078e000cULL, 0x000000100a0e7210ULL, 0x000fc60007f7e0ffULL,
0x000130001a1b7836ULL, 0x000fe20000000000ULL, 0x0ffffff8191a7812ULL, 0x000fe200078ef804ULL,
0x0000001412227836ULL, 0x000fe20000000000ULL, 0x0000000f0b197210ULL, 0x000fe200017fe4ffULL,
0x000000101c1f7824ULL, 0x100fe200078e021bULL, 0x000000140a107210ULL, 0x000fe20007f5e0ffULL,
0x000000101a1d7824ULL, 0x000fe200078e021bULL, 0x00000010121c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0f7824ULL, 0x040fe400018e0611ULL, 0x000000010b117824ULL, 0x000fe200010e0615ULL,
0x0000001c13157210ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x0000001812247836ULL, 0x000fe20000000000ULL,
0x000000091c00720cULL, 0x080fe20003f66070ULL, 0x0000001c12267836ULL, 0x000fe20000000000ULL,
0x00000000181f7faeULL, 0x0005e2000c901c46ULL, 0x000000011e127824ULL, 0x000fe200078e0204ULL,
0x000000092200720cULL, 0x080fe20003f46070ULL, 0x000000081e217824ULL, 0x000fe200078e00ffULL,
0x000000092400720cULL, 0x080fe20003f26070ULL, 0x0000010015147825ULL, 0x000fe200078e000cULL,
0x000000092600720cULL, 0x000fc60003f06070ULL, 0x0000000120167824ULL, 0x042fe200078e0204ULL,
0x000000140a147210ULL, 0x000fe20007fde0ffULL, 0x0000000113177824ULL, 0x000fe200078e0222ULL,
0xfffffff821187812ULL, 0x004fe200078ee212ULL, 0x0000000820197824ULL, 0x000fe200078e00ffULL,
0x000000150b157210ULL, 0x000fe200037fe4ffULL, 0x0000000122127824ULL, 0x040fe400078e0204ULL,
0x00000008221d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8191a7812ULL, 0x000fe200078ee216ULL,
0x0000010017167825ULL, 0x000fe200078e000cULL, 0x0000002413197210ULL, 0x000fc40007ffe0ffULL,
0xfffffff81d1e7812ULL, 0x000fe200078ee212ULL, 0x000000011c097824ULL, 0x040fe200078e0204ULL,
0x000000160a167210ULL, 0x000fe20007fde0ffULL, 0x000000081c1c7824ULL, 0x000fe400078e00ffULL,
0x00000001131d7824ULL, 0x000fe400078e0226ULL, 0x0000010019127825ULL, 0x000fe200078e000cULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee209ULL, 0x0000000426197210ULL, 0x000fe20007ffe0ffULL,
0x000000010b177824ULL, 0x000fe200030e0617ULL, 0x000000120a127210ULL, 0x000fe20007fde0ffULL,
0x0000000124097824ULL, 0x000fc400078e0204ULL, 0x0000000824207824ULL, 0x000fe400078e00ffULL,
0x0000000826227824ULL, 0x000fe400078e00ffULL, 0x000001001d0c7825ULL, 0x000fe200078e000cULL,
0xfffffff820207812ULL, 0x000fe400078ee209ULL, 0xfffffff822227812ULL, 0x000fe200078ee219ULL,
0x000000010b137824ULL, 0x000fe200030e0613ULL, 0x0000000c0a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001018097824ULL, 0x100fe200078e021bULL, 0x0000001b1c1d7211ULL, 0x000fe200078e20ffULL,
0x000000101a197824ULL, 0x000fc400078e021bULL, 0x000000101e1f7824ULL, 0x100fe200078e021bULL,
0x000000000e097faeULL, 0x0003e2000e901c46ULL, 0x0000001020217824ULL, 0x100fe400078e021bULL,
0x00000010221b7824ULL, 0x000fe200078e021bULL, 0x0000000010197faeULL, 0x0003e2000e101c46ULL,
0x000000010b0b7824ULL, 0x000fc600030e060dULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x00000000161f7faeULL, 0x0003e8000d101c46ULL, 0x0000000012217faeULL, 0x0003e8000c901c46ULL,
0x000000000a1b7faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x00000004040c7811ULL, 0x040fe200078fe8ffULL, 0x000040004f187824ULL, 0x000fe200078e0202ULL,
0x00000008040e7811ULL, 0x000fe400078fe8ffULL, 0x000000040c0d7210ULL, 0x000fe20007ffe0ffULL,
0x000000080c1c7824ULL, 0x000fe200078e00ffULL, 0x0000001404127811ULL, 0x000fe200078fe8ffULL,
0x000000010e0f7824ULL, 0x100fe200078e0204ULL, 0x0000001804167811ULL, 0x000fe200078fe8ffULL,
0x000000080e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL,
0x0000000112147824ULL, 0x100fe200078e0204ULL, 0x0000000c040d7811ULL, 0x000fe200078fe8ffULL,
0x0000000812177824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL,
0x0000000816267824ULL, 0x000fe200078e00ffULL, 0x000000030d207819ULL, 0x040fe200000006ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0204ULL, 0xfffffff817247812ULL, 0x000fe200078ee214ULL,
0x0000000113197824ULL, 0x040fe200078e0212ULL, 0x0000001c04147811ULL, 0x040fe200078fe8ffULL,
0x00000001131d7824ULL, 0x000fe200078e0216ULL, 0x0000001004107811ULL, 0x000fe200078fe8ffULL,
0x0000200007187824ULL, 0x000fe200078e0218ULL, 0xfffffff820207812ULL, 0x000fe200078ee20fULL,
0x00000008141b7824ULL, 0x000fe200078e00ffULL, 0x0000000416157210ULL, 0x000fe20007ffe0ffULL,
0x0000000110117824ULL, 0x040fe200078e0204ULL, 0x0000000c130f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000810227824ULL, 0x000fe200078e00ffULL, 0x00000004140c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000113177824ULL, 0x000fe200078e0210ULL, 0x00000070091a7812ULL, 0x000fe200078ec0ffULL,
0x00000001131f7824ULL, 0x040fe200078e0214ULL, 0xfffffff826267812ULL, 0x000fe200078ee215ULL,
0x0000000113157824ULL, 0x000fe200078e020dULL, 0xfffffff81b287812ULL, 0x000fe200078ee20cULL,
0x00000080071a7824ULL, 0x000fe200078e021aULL, 0x00000013040d7211ULL, 0x000fe200078fe8ffULL,
0x0001300018297836ULL, 0x000fe20000000000ULL, 0x000000ff001b7202ULL, 0x000fc40000000f00ULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000000113117824ULL, 0x000fe200078e020eULL,
0x0000000404097211ULL, 0x000fe200078fe8ffULL, 0x000001000d0c7825ULL, 0x100fe200078e001aULL,
0x0000002922237211ULL, 0x000fe400078e20ffULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x100fe200078e001aULL, 0x0000000c0a0c7210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff809097812ULL, 0x000fe200078ef804ULL, 0x0000010011107825ULL, 0x000fe200078e001aULL,
0x0000000e0a0e7210ULL, 0x000fc60007f3e0ffULL, 0x0000010015127825ULL, 0x100fe200078e001aULL,
0x000000100a107210ULL, 0x000fe40007f5e0ffULL, 0x0000000f0b0f7210ULL, 0x000fe20000ffe4ffULL,
0x0000010017147825ULL, 0x000fe200078e001aULL, 0x000000120a127210ULL, 0x000fc60007f7e0ffULL,
0x0000010019167825ULL, 0x000fc800078e001aULL, 0x000001001d187825ULL, 0x000fe200078e001aULL,
0x000000160a167210ULL, 0x000fc60007f3e0ffULL, 0x000001001f1a7825ULL, 0x000fc800078e001aULL,
0x000000010b0d7824ULL, 0x000fe200000e060dULL, 0x000000140a147210ULL, 0x000fe20007f1e0ffULL,
0x0000001009097824ULL, 0x000fe400078e0229ULL, 0x000000010b117824ULL, 0x040fe200010e0611ULL,
0x000000180a187210ULL, 0x000fe20007f5e0ffULL, 0x000000101c1d7824ULL, 0x000fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0003e2000b901c46ULL,
0x000000010b137824ULL, 0x040fe200018e0613ULL, 0x0000001a0a0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000101e1f7824ULL, 0x100fe200078e0229ULL, 0x000000190b197210ULL, 0x000fe200017fe4ffULL,
0x0000001020217824ULL, 0x000fe200078e0229ULL, 0x000000000e1d7faeULL, 0x0003e2000b901c46ULL,
0x000000010b157824ULL, 0x000fc400000e0615ULL, 0x0000001024257824ULL, 0x000fe200078e0229ULL,
0x00000000101f7faeULL, 0x0003e2000b901c46ULL, 0x000000010b177824ULL, 0x040fe400008e0617ULL,
0x0000001026277824ULL, 0x100fe200078e0229ULL, 0x0000000012217faeULL, 0x0003e2000b901c46ULL,
0x0000001028297824ULL, 0x000fe400078e0229ULL, 0x000000010b0b7824ULL, 0x000fe200018e061bULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e8000b901c46ULL, 0x000000000a297faeULL, 0x0003e4000b901c46ULL,
0x0000005a6000720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff507424ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x000000ffff537224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000060009c0947ULL, 0x000fec0003800000ULL, 0x00009600ff097b82ULL, 0x000e620000000800ULL,
0x0000000208087824ULL, 0x000fe200078e00ffULL, 0xff31721700507802ULL, 0x000fe20000000f00ULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x0000000908087224ULL, 0x002fce00078e0209ULL,
0x000000105d167824ULL, 0x000fe200078e00ffULL, 0x00009000ff147b82ULL, 0x000e620000000a00ULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000451517c24ULL, 0x010fe2000f8e02ffULL,
0xffffffe016177812ULL, 0x000fc600078ec0ffULL, 0x0000008051517824ULL, 0x000fe400078e00ffULL,
0x0000010060177824ULL, 0x000fc800078e0217ULL, 0x00000040171d7836ULL, 0x000fe20000000000ULL,
0x0000000160177810ULL, 0x000fc80007ffe0ffULL, 0x0000005a1700720cULL, 0x000fe40003f06070ULL,
0x000000601d237812ULL, 0x000fe200078ec0ffULL, 0x0000010051147825ULL, 0x002fc800078e0014ULL,
0x0000000144237824ULL, 0x000fe200078e0223ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x00000010041c7824ULL, 0x000fe200078e00ffULL,
0x0000001d5c167248ULL, 0x000fe20007fe0000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0a1dULL,
0x000000075d177819ULL, 0x040fe200000006ffULL, 0x000020005d1e7824ULL, 0x000fe200078e00ffULL,
0x000000701c1c7812ULL, 0x000fe200078ec0ffULL, 0x000040004f4f7824ULL, 0x000fe200078e0202ULL,
0x00000003ff257819ULL, 0x100fe40000011604ULL, 0x0000002016207446ULL, 0x000fe4000380001dULL,
0x000000801c167812ULL, 0x000fe200078ef817ULL, 0x00000001251d7824ULL, 0x040fe200078e0223ULL,
0x000000ff00177202ULL, 0x000fe20000000f00ULL, 0x0000000125217824ULL, 0x040fe200078e0204ULL,
0x000020001e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000425277836ULL, 0x000fe20000000000ULL,
0x000000202500720cULL, 0x000fe20003f26070ULL, 0x000001001d1c7825ULL, 0x000fe200078e0016ULL,
0x0000000721217812ULL, 0x000fc400078ec0ffULL, 0x000140004f227810ULL, 0x000fe20007ffe01eULL,
0x0000000127247824ULL, 0x040fe200078e0204ULL, 0x0000001c141c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001271f7824ULL, 0x040fe200078e0223ULL, 0x0ffffff821217812ULL, 0x000fe200078ef804ULL,
0x0000000c25417836ULL, 0x000fe20000000000ULL, 0x00000003273d7819ULL, 0x000fe200000006ffULL,
0x00000001151d7824ULL, 0x000fe200000e061dULL, 0x000000202700720cULL, 0x000fe20003f06070ULL,
0x0000001021217824ULL, 0x000fe200078e0222ULL, 0xfffffff83d277812ULL, 0x000fe200078ee224ULL,
0x000001001f1e7825ULL, 0x000fe200078e0016ULL, 0x0000001025437810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e2000c901c46ULL,
0x00000008253d7836ULL, 0x000fe20000000000ULL, 0x0000001e141e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001425477836ULL, 0x000fe20000000000ULL, 0x000000204100720cULL, 0x080fe20003fa6070ULL,
0x0000001825497836ULL, 0x000fe20000000000ULL, 0x000000033d3f7819ULL, 0x040fe200000006ffULL,
0x0000001c254b7836ULL, 0x000fe20000000000ULL, 0x000000203d00720cULL, 0x080fe20003fc6070ULL,
0x00000001151f7824ULL, 0x000fe200010e061fULL, 0x000000204300720cULL, 0x080fe20003f86070ULL,
0x0000001027257824ULL, 0x000fe200078e0222ULL, 0x000000204700720cULL, 0x080fe20003f66070ULL,
0x000000013d1c7824ULL, 0x002fe200078e0204ULL, 0x000000204900720cULL, 0x080fe20003f46070ULL,
0x000000013d1d7824ULL, 0x100fe200078e0223ULL, 0x000000001e257faeULL, 0x0003e2000c101c46ULL,
0x0000000141217824ULL, 0x000fe200078e0223ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee21cULL,
0x000001001d1c7825ULL, 0x000fe200078e0016ULL, 0x000000204b00720cULL, 0x000fc60003f26070ULL,
0x0000000143277824ULL, 0x040fe200078e0223ULL, 0x0000001c141c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000143267824ULL, 0x100fe400078e0204ULL, 0x0000000141247824ULL, 0x040fe200078e0204ULL,
0x0000000341417819ULL, 0x000fe200000006ffULL, 0x0000000843437824ULL, 0x000fe400078e00ffULL,
0x0000010021207825ULL, 0x000fe200078e0016ULL, 0xfffffff841417812ULL, 0x000fe400078ee224ULL,
0xfffffff843437812ULL, 0x000fe200078ee226ULL, 0x00000001151d7824ULL, 0x000fe200000e061dULL,
0x00000020141e7210ULL, 0x002fe20007f1e0ffULL, 0x00000008473d7824ULL, 0x000fe200078e00ffULL,
0x0000000447267210ULL, 0x000fe20007ffe0ffULL, 0x0000010027247825ULL, 0x000fc800078e0016ULL,
0x0000000147277824ULL, 0x000fe200078e0223ULL, 0xfffffff83d477812ULL, 0x000fe200078ee226ULL,
0x00000001151f7824ULL, 0x000fe200000e0621ULL, 0x0000002414207210ULL, 0x000fe20007f1e0ffULL,
0x0000010027267825ULL, 0x000fc600078e0016ULL, 0x0000002515217210ULL, 0x000fe200007fe4ffULL,
0x00000001493d7824ULL, 0x100fe200078e0223ULL, 0x0000002614247210ULL, 0x000fe20007f1e0ffULL,
0x000000014b237824ULL, 0x000fe400078e0223ULL, 0x000001003d3c7825ULL, 0x000fc800078e0016ULL,
0x00000001493e7824ULL, 0x100fe400078e0204ULL, 0x0000000115257824ULL, 0x000fe200000e0627ULL,
0x0000003c14267210ULL, 0x000fe20007f1e0ffULL, 0x0000000849497824ULL, 0x000fe400078e00ffULL,
0x000000014b407824ULL, 0x040fe200078e0204ULL, 0x000000034b4b7819ULL, 0x000fe200000006ffULL,
0x0000010023167825ULL, 0x000fe200078e0016ULL, 0xfffffff849497812ULL, 0x000fe400078ee23eULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee240ULL, 0x0000000115277824ULL, 0x000fe200000e063dULL,
0x0000001614147210ULL, 0x000fe20007f1e0ffULL, 0x000000103f237824ULL, 0x100fe200078e0222ULL,
0x00000022433f7211ULL, 0x000fe200078e20ffULL, 0x00000010413d7824ULL, 0x000fc400078e0222ULL,
0x0000001047417824ULL, 0x100fe200078e0222ULL, 0x000000001c237faeULL, 0x0003e2000f101c46ULL,
0x0000001049437824ULL, 0x100fe400078e0222ULL, 0x000000104b477824ULL, 0x000fe200078e0222ULL,
0x000000001e3d7faeULL, 0x0003e2000e901c46ULL, 0x0000000115157824ULL, 0x000fc600000e0617ULL,
0x00000000203f7faeULL, 0x0003e8000e101c46ULL, 0x0000000024417faeULL, 0x0003e8000d901c46ULL,
0x0000000026437faeULL, 0x0003e8000d101c46ULL, 0x0000000014477faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x0000001004167824ULL, 0x040fe200078e00ffULL,
0x00000004041f7811ULL, 0x040fe200078fe8ffULL, 0x000000805d177824ULL, 0x040fe200078e00ffULL,
0x0000000804217811ULL, 0x000fe200078fe8ffULL, 0x000020005d1c7824ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fe200078ec0ffULL, 0x000000011f1d7824ULL, 0x140fe200078e0204ULL,
0x000000031f1e7819ULL, 0x000fe200000006ffULL, 0x0000000821207824ULL, 0x040fe200078e00ffULL,
0x0000008016167812ULL, 0x000fe200078ef817ULL, 0x0000000121177824ULL, 0x100fe200078e0204ULL,
0x0000000c04257811ULL, 0x040fe200078fe8ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0223ULL,
0x0000001004277811ULL, 0x040fe200078fe8ffULL, 0x0000000121217824ULL, 0x100fe200078e0223ULL,
0xfffffff81e417812ULL, 0x000fe200078ee21dULL, 0x00000001251d7824ULL, 0x040fe200078e0204ULL,
0xfffffff820437812ULL, 0x000fe200078ee217ULL, 0x0000000825227824ULL, 0x000fe200078e00ffULL,
0x0000000404177211ULL, 0x040fe200078fe8ffULL, 0x0000000827497824ULL, 0x040fe200078e00ffULL,
0x00000004271e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000127277824ULL, 0x000fe200078e0223ULL,
0x00000014043d7811ULL, 0x000fc400078fe8ffULL, 0x00000018044d7811ULL, 0x040fe400078fe8ffULL,
0x0000001c04517811ULL, 0x000fe400078fe8ffULL, 0x000000024f4f7211ULL, 0x000fe400078e70ffULL,
0x000020001c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000151207824ULL, 0x100fe200078e0204ULL,
0x0000000717177812ULL, 0x000fe200078ec0ffULL, 0x0000000851557824ULL, 0x000fe200078e00ffULL,
0xfffffff822477812ULL, 0x000fe200078ee21dULL, 0x000000013d1d7824ULL, 0x040fe200078e0204ULL,
0xfffffff849497812ULL, 0x000fe200078ee21eULL, 0x000000083d227824ULL, 0x000fe200078e00ffULL,
0x000140004f1c7810ULL, 0x000fe20007ffe01cULL, 0x000000014d1e7824ULL, 0x040fe200078e0204ULL,
0x000000034d4f7819ULL, 0x000fe200000006ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0223ULL,
0x0ffffff817177812ULL, 0x000fe200078ef804ULL, 0x0000001041417824ULL, 0x100fe200078e021cULL,
0xfffffff8224b7812ULL, 0x000fe200078ee21dULL, 0x0000001043437824ULL, 0x100fe200078e021cULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee21eULL, 0x0000001047477824ULL, 0x100fe200078e021cULL,
0xfffffff855557812ULL, 0x000fe200078ee220ULL, 0x0000001049497824ULL, 0x100fe200078e021cULL,
0x00000023041d7211ULL, 0x000fe200078fe8ffULL, 0x000000104f4f7824ULL, 0x100fe200078e021cULL,
0x0000001c173f7211ULL, 0x080fe200078e20ffULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x0000002325257210ULL, 0x000fe20007ffe0ffULL, 0x0000001055557824ULL, 0x000fe200078e021cULL,
0x0000001c4b4b7211ULL, 0x000fe200078e20ffULL, 0x000001001d1c7825ULL, 0x000fc800078e0016ULL,
0x000000014d4d7824ULL, 0x100fe200078e0223ULL, 0x0000001c141c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000151517824ULL, 0x000fe400078e0223ULL, 0x000001001f1e7825ULL, 0x000fc800078e0016ULL,
0x0000010021207825ULL, 0x000fe200078e0016ULL, 0x0000001e141e7210ULL, 0x000fc60007f3e0ffULL,
0x0000010025227825ULL, 0x100fe200078e0016ULL, 0x0000002014207210ULL, 0x000fe40007f5e0ffULL,
0x0000001f151f7210ULL, 0x000fe20000ffe4ffULL, 0x0000010027247825ULL, 0x000fe200078e0016ULL,
0x0000002214227210ULL, 0x000fc60007f7e0ffULL, 0x000001003d267825ULL, 0x000fc800078e0016ULL,
0x000001004d3c7825ULL, 0x000fe200078e0016ULL, 0x0000002614267210ULL, 0x000fc60007f3e0ffULL,
0x0000010051167825ULL, 0x000fc800078e0016ULL, 0x00000001151d7824ULL, 0x040fe200000e061dULL,
0x0000002414247210ULL, 0x000fe20007f1e0ffULL, 0x0000000115217824ULL, 0x040fe200010e0621ULL,
0x0000003c143c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000115237824ULL, 0x040fe200018e0623ULL,
0x0000001614147210ULL, 0x000fe20007f7e0ffULL, 0x0000000115257824ULL, 0x040fe200000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c3f7faeULL, 0x0003e2000b901c46ULL,
0x0000000115277824ULL, 0x040fe200008e0627ULL, 0x0000003d153d7210ULL, 0x000fe200017fe4ffULL,
0x0000000115157824ULL, 0x000fe200018e0617ULL, 0x000000001e417faeULL, 0x0003e8000b901c46ULL,
0x0000000020437faeULL, 0x0003e8000b901c46ULL, 0x0000000022477faeULL, 0x0003e8000b901c46ULL,
0x0000000024497faeULL, 0x0003e8000b901c46ULL, 0x00000000264b7faeULL, 0x0003e8000b901c46ULL,
0x000000003c4f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014557faeULL, 0x0003e4000b901c46ULL,
0x0000000152157812ULL, 0x002fe200078ec0ffULL, 0xffffffffff577424ULL, 0x000fe200078e00ffULL,
0xffffffff00147811ULL, 0x000fe200078e08ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000011500780cULL, 0x000fc80003f05070ULL, 0x0000000114157807ULL, 0x000fca0004000000ULL,
0x0000000115527824ULL, 0x000fca00078e0252ULL, 0x0000005b5200720cULL, 0x000fda0003f06070ULL,
0x00009200ff148b82ULL, 0x000e620000000a00ULL, 0x0000000108178824ULL, 0x000fe200078e0252ULL,
0x0000001046167812ULL, 0x040fe200078ec0ffULL, 0x00000001ff1c7424ULL, 0x000fe400078e00ffULL,
0x0000000417148825ULL, 0x002fe200078e0014ULL, 0xffffffe046177812ULL, 0x000fc800078ec0ffULL,
0x0000000216167210ULL, 0x000fe20007ffe017ULL, 0x0000000614578981ULL, 0x000322000c1e1900ULL,
0x0000000846177812ULL, 0x000fc800078ec0ffULL, 0x00000017161f7210ULL, 0x000fc80007ffe0ffULL,
0x01b6081c1f1c79a7ULL, 0x0002a6000850003fULL, 0x0000000000147805ULL, 0x002fce0000015200ULL,
0x01b6081d1f0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fce00078e00ffULL, 0x000000101e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fce0000015200ULL,
0x0000001614217210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000002116167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fce0007ffe0ffULL, 0x01b6081d1f0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000205d147824ULL, 0x000fe200078e00ffULL,
0x00000001ff4d7819ULL, 0x000fe20000011604ULL, 0x0000001004407824ULL, 0x000fe400078e00ffULL,
0x000000ffff567224ULL, 0x000fe200078e0050ULL, 0xffffff8014157812ULL, 0x000fe400078ec0ffULL,
0x0000007040407812ULL, 0x000fe400078ec0ffULL, 0x0000000c4d4d7812ULL, 0x000fe200078ec0ffULL,
0x00000001024e7824ULL, 0x000fca00078e0215ULL, 0x0000004e4d147210ULL, 0x000fca0007ffe040ULL,
0x01b0000014157984ULL, 0x000e680000000800ULL, 0x01b2000014557984ULL, 0x0004a20000000800ULL,
0x000000501500720bULL, 0x002fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff16167812ULL, 0x000fda000782c0ffULL,
0x0000000000f09947ULL, 0x004fea0003800000ULL, 0x00000002ff147819ULL, 0x000fe4000001165dULL,
0x000000501500720bULL, 0x0c0fe40003f14000ULL, 0x0000005d1400720cULL, 0x000fe40003f25270ULL,
0x0000005015567209ULL, 0x000fd20007810000ULL, 0x00000000001d7806ULL, 0x000fe400000e0100ULL,
0x000000025d149211ULL, 0x000fc800078e38ffULL, 0x000000144d179210ULL, 0x000fe40007ffe040ULL,
0x000099101d147816ULL, 0x000fc600000000ffULL, 0x01b4005617009388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000005056147221ULL, 0x000fe20000010100ULL, 0x000000ff1dff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff001dff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x0000001400177308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff147819ULL, 0x002fcc0000011604ULL, 0x00001f1417147589ULL, 0x004e6400000e0000ULL,
0x0000001428287220ULL, 0x082fe20000410000ULL, 0x0000001429297220ULL, 0x080fe20000410000ULL,
0x000000142c2c7220ULL, 0x080fe20000410000ULL, 0x000000142d2d7220ULL, 0x080fe20000410000ULL,
0x0000001430307220ULL, 0x080fe20000410000ULL, 0x0000001431317220ULL, 0x080fe20000410000ULL,
0x0000001434347220ULL, 0x080fe20000410000ULL, 0x0000001435357220ULL, 0x080fe20000410000ULL,
0x0000001438387220ULL, 0x080fe20000410000ULL, 0x0000001439397220ULL, 0x080fe20000410000ULL,
0x000000140c0c7220ULL, 0x080fe20000410000ULL, 0x000000140d0d7220ULL, 0x080fe20000410000ULL,
0x0000001410107220ULL, 0x080fe20000410000ULL, 0x0000001411117220ULL, 0x080fe20000410000ULL,
0x0000001418187220ULL, 0x080fe20000410000ULL, 0x0000001419197220ULL, 0x000fce0000410000ULL,
0x0000001753537220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000804147811ULL, 0x002fcc00078ff0ffULL, 0x00001f1417147589ULL, 0x000e6400000e0000ULL,
0x000000142a2a7220ULL, 0x082fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x080fe20000410000ULL,
0x000000143a3a7220ULL, 0x080fe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x000000140e0e7220ULL, 0x080fe20000410000ULL, 0x000000140f0f7220ULL, 0x080fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x0000001413137220ULL, 0x080fe20000410000ULL,
0x000000141a1a7220ULL, 0x080fe20000410000ULL, 0x000000141b1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff16ff7812ULL, 0x000fda000780601dULL, 0x8000005615150221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x00000015000b0308ULL, 0x000ea40000000800ULL,
0x0000000b55550220ULL, 0x004fce0000410000ULL, 0x00000007044b7812ULL, 0x040fe200078ec0ffULL,
0x000002005d147824ULL, 0x002fe200078e00ffULL, 0x0000000804487812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000004ff627819ULL, 0x000fe40000011604ULL,
0x0000004b48177212ULL, 0x000fe400078efcffULL, 0x000000015d587819ULL, 0x000fe400000006ffULL,
0x00000001ff517819ULL, 0x000fe2000001165dULL, 0x0000000162167824ULL, 0x000fe200078e0217ULL,
0x000000084b477812ULL, 0x000fe200078ef804ULL, 0x0000000817157824ULL, 0x000fe200078e00ffULL,
0xfffff80014497812ULL, 0x000fe200078ec0ffULL, 0x0000000216427836ULL, 0x000fc40000000000ULL,
0x0000400051547824ULL, 0x000fe400078e0202ULL, 0x0000000817147824ULL, 0x040fe200078e00ffULL,
0xfffffff815427812ULL, 0x000fe200078ee242ULL, 0x0000000817437824ULL, 0x000fe200078e00ffULL,
0x0000000458157812ULL, 0x000fe200078ec0ffULL, 0x0000000416417836ULL, 0x000fe20000000000ULL,
0x0000005407597211ULL, 0x000fe200078e68ffULL, 0x00000006164a7836ULL, 0x000fe20000000000ULL,
0x00000015044c7211ULL, 0x000fe200078fe0ffULL, 0x0000000847157824ULL, 0x000fe200078e00ffULL,
0x0000000317177819ULL, 0x000fe200000006ffULL, 0x0000000102497824ULL, 0x000fe200078e0249ULL,
0xfffffff843437812ULL, 0x000fe200078ee216ULL, 0x00000001474c7824ULL, 0x000fe200078e024cULL,
0xfffffff814417812ULL, 0x000fe200078ee241ULL, 0x0001300059597836ULL, 0x000fe20000000000ULL,
0xfffffff8174a7812ULL, 0x000fc400078ee24aULL, 0xfffffff815507812ULL, 0x000fca00078ee24cULL,
0x0000001050507824ULL, 0x000fe200078e0249ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff177819ULL, 0x000fe40000011604ULL, 0x0000000bff09723eULL, 0x000fc600000010ffULL,
0x0000000817157836ULL, 0x000fe20000000000ULL, 0x0000541009147816ULL, 0x000fca0000000009ULL,
0x00001f17140a7589ULL, 0x0002a800000e0000ULL, 0x00001f1514097589ULL, 0x0002e400000e0000ULL,
0x011000005014783bULL, 0x0022e20000000200ULL, 0x00000010434f7824ULL, 0x100fe200078e0259ULL,
0x00000059423c7211ULL, 0x000fe200078e20ffULL, 0x0000001041247824ULL, 0x000fe200078e0259ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000a14147232ULL, 0x08cfe40000200000ULL,
0x0000000a16167232ULL, 0x000fe40000200000ULL, 0x0000000915157232ULL, 0x080fe40000200000ULL,
0x0000000917177232ULL, 0x000fce0000200000ULL, 0x000000104a1c7824ULL, 0x000fe200078e0259ULL,
0x000000002424783bULL, 0x000f620000004200ULL, 0x0000000451627824ULL, 0x000fc600078e0262ULL,
0x000000004f20783bULL, 0x000b680000004200ULL, 0x000000001c1c783bULL, 0x000f680000004200ULL,
0x000000003c3c783bULL, 0x000f640000004200ULL, 0x00000002624f7810ULL, 0x028fe20007ffe047ULL,
0x000000241438723cULL, 0x002fec0000041838ULL, 0x000000201428723cULL, 0x004fe20000041828ULL,
0x0000001048257812ULL, 0x000fe200078efe4bULL, 0x0000000847247824ULL, 0x000fc800078e00ffULL,
0x0000001c1410723cULL, 0x000fe20000041810ULL, 0xfffffff8244f7812ULL, 0x000fe200078ee24fULL,
0x00000008254b7824ULL, 0x000fc800078e00ffULL, 0x0000003c1430723cULL, 0x000fe20000041830ULL,
0x00000025041c7211ULL, 0x000fe400078fe0ffULL, 0x00000003251d7819ULL, 0x000fe400000006ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee21cULL, 0x0000003e1434723cULL, 0x000fe20000041834ULL,
0x000000021c487836ULL, 0x000fe40000000000ULL, 0x000000041c477836ULL, 0x000fc60000000000ULL,
0x00000026140c723cULL, 0x000fe2000004180cULL, 0xfffffff81d487812ULL, 0x000fca00078ee248ULL,
0x000000221420723cULL, 0x000fe2000004182cULL, 0x0000000825267824ULL, 0x000fe400078e00ffULL,
0x00000010483c7824ULL, 0x000fc600078e0259ULL, 0x0000001e1418723cULL, 0x000fe20000041818ULL,
0xfffffff826477812ULL, 0x000fe200078ee247ULL, 0x000000104b267824ULL, 0x000fc600078e0259ULL,
0x00000059472c7211ULL, 0x000fe400078e20ffULL, 0x000000104f147824ULL, 0x000fe200078e0249ULL,
0x00000003251e7819ULL, 0x000fe200000006ffULL, 0x000000061c497836ULL, 0x000fc80000000000ULL,
0x011000001414783bULL, 0x000e620000000200ULL, 0x0000000000108947ULL, 0x000ff40003800000ULL,
0x0000000a14147232ULL, 0x082fe40000200000ULL, 0x0000000a16167232ULL, 0x000fe40000200000ULL,
0x0000000915157232ULL, 0x080fe40000200000ULL, 0x0000000917177232ULL, 0x000fce0000200000ULL,
0xfffffff81e497812ULL, 0x000fe200078ee249ULL, 0x000000002624783bULL, 0x000ea20000004200ULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x0000005355557221ULL, 0x000fe20000010000ULL,
0x0000000457577c24ULL, 0x010fe2000f8e02ffULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x00000010491c7824ULL, 0x000fe400078e0259ULL, 0x0000008057577824ULL, 0x000fe200078e00ffULL,
0x000000002c2c783bULL, 0x000f280000004200ULL, 0x000000001c1c783bULL, 0x000f620000004200ULL,
0x000000241428723cULL, 0x006fe20000041828ULL, 0x00009000ff247b82ULL, 0x000e6a0000000a00ULL,
0x0000003c1430723cULL, 0x008fec0000041830ULL, 0x0000003e1434723cULL, 0x000fe20000041834ULL,
0x00000001ff3c7424ULL, 0x000fca00078e00ffULL, 0x0000002c1438723cULL, 0x010fec0000041838ULL,
0x0000002e140c723cULL, 0x000fec000004180cULL, 0x000000261420723cULL, 0x000fec0000041820ULL,
0x0000001c1410723cULL, 0x020fe20000041810ULL, 0xfffffff858277812ULL, 0x000fe200078ec0ffULL,
0x0000010057587825ULL, 0x002fc800078e0024ULL, 0x0000001e1414723cULL, 0x000fe20000041818ULL,
0x0000000102277824ULL, 0x000fc800078e0227ULL, 0x01b6883c27ff79a7ULL, 0x0003e4000850003fULL,
0x00000001601b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000860187824ULL, 0x000fc600078e0251ULL,
0x0000005a1b00720cULL, 0x000fe40003f06070ULL, 0x0000008018197811ULL, 0x000fc800078e28ffULL,
0x00000060192d7812ULL, 0x000fca00078ec0ffULL, 0x00000001442d7824ULL, 0x000fe200078e022dULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x00000003ff3f7819ULL, 0x100fe20000011604ULL, 0x000020005d187824ULL, 0x040fe200078e00ffULL,
0x000000195c2c7248ULL, 0x000fe20007fe0000ULL, 0x000000805d1b7824ULL, 0x000fe200078e00ffULL,
0x000000ff19197210ULL, 0x000fe20007ffe1ffULL, 0x000000043f1f7836ULL, 0x000fe20000000000ULL,
0x00002000181d7812ULL, 0x000fe200078ec0ffULL, 0x000000083f537836ULL, 0x000fe20000000000ULL,
0x000000202c2c7446ULL, 0x000fe20003800019ULL, 0x000000011f187824ULL, 0x140fe200078e0204ULL,
0x0001300054547810ULL, 0x000fe20007ffe01dULL, 0x000000081f3d7824ULL, 0x000fe200078e00ffULL,
0x0000002d53257210ULL, 0x000fe20007ffe0ffULL, 0x000000013f197824ULL, 0x000fe200078e0204ULL,
0x0000002c1f00720cULL, 0x0c0fe20003f26070ULL, 0x000000011f1d7824ULL, 0x100fe200078e022dULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee218ULL, 0x0000000c3f577836ULL, 0x000fe20000000000ULL,
0x0000008040187812ULL, 0x000fe200078ef81bULL, 0x000000103f5f7836ULL, 0x000fe20000000000ULL,
0x0000002d3f1b7210ULL, 0x000fe20007ffe0ffULL, 0x00000001571f7824ULL, 0x000fe200078e022dULL,
0x0000000719277812ULL, 0x000fe200078ec0ffULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000002c3f00720cULL, 0x080fe20003f06070ULL, 0x000000103d3d7824ULL, 0x000fe200078e0254ULL,
0x0ffffff827277812ULL, 0x000fe200078ef804ULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x0000002c5300720cULL, 0x000fc40003fa6070ULL, 0x000000183f637810ULL, 0x000fe20007ffe0ffULL,
0x000001001d1c7825ULL, 0x100fe200078e0018ULL, 0x0000001a581a7210ULL, 0x000fe40007f5e0ffULL,
0x0000002c5700720cULL, 0x000fe20003f86070ULL, 0x0000010025247825ULL, 0x000fe200078e0018ULL,
0x0000001c581c7210ULL, 0x000fc60007f7e0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0018ULL,
0x00000001591b7824ULL, 0x040fe200010e061bULL, 0x0000002458267210ULL, 0x000fe20007f5e0ffULL,
0x00000001591d7824ULL, 0x000fe200018e061dULL, 0x0000001e58247210ULL, 0x000fe20007f7e0ffULL,
0x00000010272f7824ULL, 0x000fe200078e0254ULL, 0x0000002559277210ULL, 0x000fe200017fe4ffULL,
0x000000143f617836ULL, 0x000fe40000000000ULL, 0x0000000159257824ULL, 0x000fe200018e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a2f7faeULL, 0x0003e2000c101c46ULL,
0x000000015f1f7824ULL, 0x040fe200078e022dULL, 0x0000002c5f00720cULL, 0x080fe20003f66070ULL,
0x00000001532e7824ULL, 0x040fe200078e0204ULL, 0x000000001c3d7faeULL, 0x0005e2000c901c46ULL,
0x0000000853537824ULL, 0x000fe200078e00ffULL, 0x0000002c6100720cULL, 0x080fe20003f46070ULL,
0x0000001c3f657836ULL, 0x000fe20000000000ULL, 0x0000002c6300720cULL, 0x000fe20003f26070ULL,
0x000001001f1a7825ULL, 0x002fe200078e0018ULL, 0x00000004572f7210ULL, 0x000fc40007ffe0ffULL,
0x0000002c6500720cULL, 0x000fe20003f06070ULL, 0x00000001611d7824ULL, 0x004fe200078e022dULL,
0x0000001a581e7210ULL, 0x000fe20007fde0ffULL, 0x00000008571c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8533d7812ULL, 0x000fe200078ee22eULL, 0x00000001612c7824ULL, 0x000fe200078e0204ULL,
0x000000035f2e7819ULL, 0x000fe200000006ffULL, 0x00000001591f7824ULL, 0x000fe200030e061bULL,
0xfffffff81c3f7812ULL, 0x000fe200078ee22fULL, 0x000001001d1a7825ULL, 0x000fc800078e0018ULL,
0x000000015f1d7824ULL, 0x000fe200078e0204ULL, 0x0000001a581c7210ULL, 0x000fe20007fde0ffULL,
0x00000001632f7824ULL, 0x000fe200078e022dULL, 0x0000002d652d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000861577824ULL, 0x000fe200078e00ffULL, 0xfffffff82e537812ULL, 0x000fe200078ee21dULL,
0x00000001591d7824ULL, 0x000fe400030e061bULL, 0x000001002f1a7825ULL, 0x000fe200078e0018ULL,
0xfffffff857577812ULL, 0x000fc600078ee22cULL, 0x00000001632c7824ULL, 0x140fe200078e0204ULL,
0x0000001a581a7210ULL, 0x000fe20007fde0ffULL, 0x00000008635f7824ULL, 0x000fe400078e00ffULL,
0x00000001652e7824ULL, 0x040fe200078e0204ULL, 0x0000001b591b7210ULL, 0x000fe200037fe4ffULL,
0x0000000865617824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee22cULL,
0x000001002d187825ULL, 0x000fc600078e0018ULL, 0xfffffff861617812ULL, 0x000fe200078ee22eULL,
0x000000103d2d7824ULL, 0x100fe200078e0254ULL, 0x0000001858187210ULL, 0x000fe20007fde0ffULL,
0x000000103f2f7824ULL, 0x100fe400078e0254ULL, 0x00000010533d7824ULL, 0x100fe200078e0254ULL,
0x000000545f537211ULL, 0x000fe200078e20ffULL, 0x00000010573f7824ULL, 0x100fe200078e0254ULL,
0x00000000262d7faeULL, 0x0003e2000e901c46ULL, 0x0000001061577824ULL, 0x000fe400078e0254ULL,
0x0000000159197824ULL, 0x000fe200030e0619ULL, 0x00000000242f7faeULL, 0x0003e8000e101c46ULL,
0x000000001e3d7faeULL, 0x0003e8000d901c46ULL, 0x000000001c3f7faeULL, 0x0003e8000d101c46ULL,
0x000000001a537faeULL, 0x0003e8000c901c46ULL, 0x0000000018577faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x000020005d187824ULL, 0x000fe200078e00ffULL,
0x00000004041b7811ULL, 0x040fe400078fe8ffULL, 0x00000008041d7811ULL, 0x000fe400078fe8ffULL,
0x0000200018197812ULL, 0x000fe200078ec0ffULL, 0x000000011b5f7824ULL, 0x140fe200078e0204ULL,
0x000000031b187819ULL, 0x000fe200000006ffULL, 0x000000011d577824ULL, 0x140fe200078e0204ULL,
0x0000000c041f7811ULL, 0x040fe400078fe8ffULL, 0xfffffff8185f7812ULL, 0x000fe200078ee25fULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x0000001004257811ULL, 0x000fe200078fe8ffULL,
0x000000011f537824ULL, 0x040fe200078e0204ULL, 0x0001300054547810ULL, 0x000fe20007ffe019ULL,
0x000000081f1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff818577812ULL, 0x000fe200078ee257ULL,
0x00000008251c7824ULL, 0x000fe200078e00ffULL, 0x0000000404187211ULL, 0x040fe200078fe8ffULL,
0x000000805d197824ULL, 0x000fe200078e00ffULL, 0xfffffff81a537812ULL, 0x000fe200078ee253ULL,
0x000000011d1d7824ULL, 0x100fe200078e022dULL, 0x00000004253f7210ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e022dULL, 0x00000018041a7811ULL, 0x000fe200078fe8ffULL,
0x0000000125257824ULL, 0x100fe200078e022dULL, 0x0000000718657812ULL, 0x000fe200078ec0ffULL,
0x000000105f5f7824ULL, 0x000fe200078e0254ULL, 0xfffffff81c3f7812ULL, 0x000fe200078ee23fULL,
0x000000081a1c7824ULL, 0x040fe200078e00ffULL, 0x0000008040187812ULL, 0x000fe200078ef819ULL,
0x000000011a197824ULL, 0x000fe200078e0204ULL, 0x0000001c04637811ULL, 0x040fe200078fe8ffULL,
0x0000001057577824ULL, 0x100fe200078e0254ULL, 0x0000001404277811ULL, 0x040fe200078fe8ffULL,
0x000000103f3f7824ULL, 0x000fe200078e0254ULL, 0x0000002d1a617210ULL, 0x000fe20007ffe0ffULL,
0x00000001631a7824ULL, 0x140fe200078e0204ULL, 0x0000002d042f7211ULL, 0x000fe200078fe8ffULL,
0x0000000863697824ULL, 0x000fe200078e00ffULL, 0xfffffff81c677812ULL, 0x000fe200078ee219ULL,
0x00000001273d7824ULL, 0x040fe200078e0204ULL, 0x0000002d1b1b7210ULL, 0x000fe20007ffe0ffULL,
0x00000008271e7824ULL, 0x040fe200078e00ffULL, 0xfffffff869697812ULL, 0x000fe200078ee21aULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000002d63637210ULL, 0x000fe20007ffe0ffULL,
0x0000000127277824ULL, 0x000fe200078e022dULL, 0xfffffff81e3d7812ULL, 0x000fe200078ee23dULL,
0x000001002f2e7825ULL, 0x000fe200078e0018ULL, 0x0ffffff865657812ULL, 0x000fc400078ef804ULL,
0x0000005453537211ULL, 0x000fe200078e20ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x0000002e582e7210ULL, 0x000fc60007f1e0ffULL, 0x000001001d1c7825ULL, 0x100fe200078e0018ULL,
0x0000001a581a7210ULL, 0x000fe40007f3e0ffULL, 0x0000002f592f7210ULL, 0x000fe200007fe4ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0018ULL, 0x0000001c581c7210ULL, 0x000fc60007f5e0ffULL,
0x0000010025247825ULL, 0x000fe200078e0018ULL, 0x0000001e581e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010027267825ULL, 0x000fe200078e0018ULL, 0x0000002458247210ULL, 0x000fc60007f1e0ffULL,
0x00000100612c7825ULL, 0x000fc800078e0018ULL, 0x0000010063187825ULL, 0x000fc800078e0018ULL,
0x0000001065617824ULL, 0x100fe400078e0254ULL, 0x00000001591b7824ULL, 0x040fe200008e061bULL,
0x0000002658267210ULL, 0x000fe20007f3e0ffULL, 0x00000001591d7824ULL, 0x040fe200010e061dULL,
0x0000002c582c7210ULL, 0x000fe20007f5e0ffULL, 0x00000001591f7824ULL, 0x040fe200018e061fULL,
0x0000001858187210ULL, 0x000fe20007f7e0ffULL, 0x0000000159257824ULL, 0x000fe200000e0625ULL,
0x0000002759277210ULL, 0x000fe20000ffe4ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0254ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e617faeULL, 0x0003e2000b901c46ULL,
0x0000001067637824ULL, 0x000fc400078e0254ULL, 0x00000001592d7824ULL, 0x000fe200010e062dULL,
0x000000001a5f7faeULL, 0x0003e2000b901c46ULL, 0x0000001069657824ULL, 0x000fe400078e0254ULL,
0x0000000159197824ULL, 0x000fe200018e0619ULL, 0x000000001c577faeULL, 0x0003e8000b901c46ULL,
0x000000001e537faeULL, 0x0003e8000b901c46ULL, 0x00000000243f7faeULL, 0x0003e8000b901c46ULL,
0x00000000263d7faeULL, 0x0003e8000b901c46ULL, 0x000000002c637faeULL, 0x0003e8000b901c46ULL,
0x0000000018657faeULL, 0x0003e4000b901c46ULL, 0xffffffe046197812ULL, 0x042fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001046187812ULL, 0x040fe400078ec0ffULL,
0x00000008461a7812ULL, 0x000fe400078ec0ffULL, 0x0000000218197210ULL, 0x000fca0007ffe019ULL,
0x00000001191f7824ULL, 0x000fc800078e021aULL, 0x01b6283c1f3c79a7ULL, 0x0002a6000850003fULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x01b6283d1f0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181d7210ULL, 0x000fc80007f1e1ffULL,
0x0000001b191b7210ULL, 0x000fe400007fe5ffULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01b6283d1f0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000008040187810ULL, 0x000fe20007ffe04eULL, 0x000000ffff537224ULL, 0x000fc800078e0056ULL,
0x000000014d187824ULL, 0x000fca00078e0218ULL, 0x01b0000018197984ULL, 0x000ea80000000800ULL,
0x01b2000018547984ULL, 0x0006e20000000800ULL, 0x000000561900720bULL, 0x004fda0003f1d000ULL,
0x00000000001a7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1a1b7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x00afea0003800000ULL,
0x000000015d187811ULL, 0x000fe400078ff0ffULL, 0x000000561900720bULL, 0x000fe40003f14000ULL,
0x0000005d1800720cULL, 0x000fd60003f25270ULL, 0x00000000001c7806ULL, 0x000fe400000e0100ULL,
0x000000025d1a9211ULL, 0x000fe400078e38ffULL, 0x0000005619189209ULL, 0x000fe40007810000ULL,
0x0000001a4d1d9210ULL, 0x000fe40007ffe040ULL, 0x000099101c1a7816ULL, 0x000fc600000000ffULL,
0x01b400181d009388ULL, 0x0003e20000000800ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x00000056191d7209ULL, 0x000fe40007810000ULL,
0x000000ff1cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001cff7812ULL, 0x000fe2000782c0ffULL,
0x000000561d187221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x00000018001a7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x000fca0000011604ULL, 0x00001f1d1a187589ULL, 0x006e6400000e0000ULL,
0x0000002818287220ULL, 0x042fe20000410000ULL, 0x0000002918297220ULL, 0x040fe20000410000ULL,
0x0000002018207220ULL, 0x040fe20000410000ULL, 0x0000002118217220ULL, 0x040fe20000410000ULL,
0x0000003018307220ULL, 0x040fe20000410000ULL, 0x0000003118317220ULL, 0x040fe20000410000ULL,
0x0000003418347220ULL, 0x040fe20000410000ULL, 0x0000003518357220ULL, 0x040fe20000410000ULL,
0x0000003818387220ULL, 0x040fe20000410000ULL, 0x0000003918397220ULL, 0x040fe20000410000ULL,
0x0000000c180c7220ULL, 0x040fe20000410000ULL, 0x0000000d180d7220ULL, 0x040fe20000410000ULL,
0x0000001018107220ULL, 0x040fe20000410000ULL, 0x0000001118117220ULL, 0x040fe20000410000ULL,
0x0000001418147220ULL, 0x040fe20000410000ULL, 0x0000001518157220ULL, 0x000fce0000410000ULL,
0x0000001a55557220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008041d7811ULL, 0x000fca00078ff0ffULL, 0x00001f1d1a187589ULL, 0x002e6400000e0000ULL,
0x0000002a182a7220ULL, 0x042fe20000410000ULL, 0x0000002b182b7220ULL, 0x040fe20000410000ULL,
0x0000002218227220ULL, 0x040fe20000410000ULL, 0x0000002318237220ULL, 0x040fe20000410000ULL,
0x0000003218327220ULL, 0x040fe20000410000ULL, 0x0000003318337220ULL, 0x040fe20000410000ULL,
0x0000003618367220ULL, 0x040fe20000410000ULL, 0x0000003718377220ULL, 0x040fe20000410000ULL,
0x0000003a183a7220ULL, 0x040fe20000410000ULL, 0x0000003b183b7220ULL, 0x040fe20000410000ULL,
0x0000000e180e7220ULL, 0x040fe20000410000ULL, 0x0000000f180f7220ULL, 0x040fe20000410000ULL,
0x0000001218127220ULL, 0x040fe20000410000ULL, 0x0000001318137220ULL, 0x040fe20000410000ULL,
0x0000001618167220ULL, 0x040fe20000410000ULL, 0x0000001718177220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe4000780601cULL, 0x0000005619537209ULL, 0x000fd60007810000ULL,
0x8000005319190221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL,
0x00000019000b0308ULL, 0x000ea40000000800ULL, 0x0000000b54540220ULL, 0x004fce0000410000ULL,
0x0000400051517824ULL, 0x000fe200078e0202ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000200007577824ULL, 0x000fc800078e0251ULL, 0x0001400057577836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff197819ULL, 0x000fe40000011604ULL,
0x0000000bff09723eULL, 0x000fc600000010ffULL, 0x00000008191b7836ULL, 0x000fe20000000000ULL,
0x0000541009187816ULL, 0x002fca0000000009ULL, 0x00001f19180a7589ULL, 0x0002a800000e0000ULL,
0x00001f1b18097589ULL, 0x0002e400000e0000ULL, 0x011800005018783bULL, 0x0022e20000000200ULL,
0x0000005743567211ULL, 0x000fe200078e20ffULL, 0x00000010423c7824ULL, 0x100fe400078e0257ULL,
0x0000001041247824ULL, 0x000fe200078e0257ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000a18187232ULL, 0x08cfe40000200000ULL, 0x0000000a1a1a7232ULL, 0x000fe40000200000ULL,
0x0000000919197232ULL, 0x080fe40000200000ULL, 0x000000091b1b7232ULL, 0x000fce0000200000ULL,
0x00000000562c783bULL, 0x0009620000004200ULL, 0x000000104a1c7824ULL, 0x000fc600078e0257ULL,
0x000000003c3c783bULL, 0x000f680000004200ULL, 0x000000002424783bULL, 0x000f620000004200ULL,
0x00000002ff567819ULL, 0x010fc6000001165dULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0x0000002c1828723cULL, 0x02afec0000041828ULL, 0x0000002e182c723cULL, 0x000fec0000041820ULL,
0x0000003c1830723cULL, 0x000fe20000041830ULL, 0x0000080056207824ULL, 0x000fc400078e0202ULL,
0x0000001047217824ULL, 0x000fc600078e0257ULL, 0x000000204f207211ULL, 0x000fe200078e20ffULL,
0x0000003e1834723cULL, 0x000fe20000041834ULL, 0x000000104b3c7824ULL, 0x000fca00078e0257ULL,
0x000000241838723cULL, 0x004fec0000041838ULL, 0x00000026180c723cULL, 0x000fe2000004180cULL,
0x0000001048247824ULL, 0x000fca00078e0257ULL, 0x0000001c1810723cULL, 0x010fec0000041810ULL,
0x0000001e1814723cULL, 0x000fe20000041814ULL, 0x011800002018783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000a18187232ULL, 0x084fe40000200000ULL, 0x0000000a1a1a7232ULL, 0x000fe40000200000ULL,
0x0000000919197232ULL, 0x080fe40000200000ULL, 0x000000091b1b7232ULL, 0x000fce0000200000ULL,
0x00000010491c7824ULL, 0x000fe200078e0257ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x00000001ff4f7819ULL, 0x000fe2000001165dULL, 0x0000005554547221ULL, 0x000fe40000010000ULL,
0x000000002424783bULL, 0x000f280000004200ULL, 0x000000002120783bULL, 0x002e680000004200ULL,
0x000000001c1c783bULL, 0x000f620000004200ULL, 0x0000003c1828723cULL, 0x00cfec0000041828ULL,
0x0000003e182c723cULL, 0x000fe2000004182cULL, 0x00000001003c7802ULL, 0x000fca0000000f00ULL,
0x000000241830723cULL, 0x010fec0000041830ULL, 0x000000261834723cULL, 0x000fec0000041834ULL,
0x000000201838723cULL, 0x002fec0000041838ULL, 0x00000022180c723cULL, 0x000fec000004180cULL,
0x0000001c1810723cULL, 0x020fec0000041810ULL, 0x0000001e1814723cULL, 0x000fe20000041814ULL,
0x00000008561d7824ULL, 0x000fc800078e0202ULL, 0x01b6903c1dff79a7ULL, 0x0003e4000850003fULL,
0x00000001601b7836ULL, 0x000fe40000000000ULL, 0x0000000860197824ULL, 0x000fc600078e024fULL,
0x0000005a1b00720cULL, 0x000fe40003f06070ULL, 0x000000c019197811ULL, 0x000fc800078e28ffULL,
0x0000006019257812ULL, 0x000fca00078ec0ffULL, 0x0000000144257824ULL, 0x000fe200078e0225ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400948947ULL, 0x002fea0003800000ULL,
0x0000000d5d187819ULL, 0x040fe400000006ffULL, 0x00000003ff277819ULL, 0x100fe40000011604ULL,
0x000000195c247248ULL, 0x000fe20007fe0000ULL, 0x000000ffff197224ULL, 0x000fe200078e0a19ULL,
0x0000200018187812ULL, 0x000fe200078ec0ffULL, 0x00000004271b7836ULL, 0x000fe20000000000ULL,
0x000000075d237819ULL, 0x000fe200000006ffULL, 0x0000000827557836ULL, 0x000fe20000000000ULL,
0x0000002024247446ULL, 0x000fe20003800019ULL, 0x000000011b1a7824ULL, 0x000fe200078e0204ULL,
0x0001400051517810ULL, 0x000fe20007ffe018ULL, 0x0000000127187824ULL, 0x000fe200078e0204ULL,
0x0000008040227812ULL, 0x000fe200078ef823ULL, 0x000000081b1d7824ULL, 0x040fe200078e00ffULL,
0x000000241b00720cULL, 0x080fe20003f26070ULL, 0x0000000127197824ULL, 0x000fe200078e0225ULL,
0x000000251b1b7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000000718217812ULL, 0x000fe200078ec0ffULL, 0x0000000c27577836ULL, 0x000fe20000000000ULL,
0xfffffff81d3e7812ULL, 0x000fe200078ee21aULL, 0x0000010019187825ULL, 0x000fe200078e0022ULL,
0x000000242700720cULL, 0x000fc40003f06070ULL, 0x0ffffff821267812ULL, 0x000fe200078ef804ULL,
0x00000001551f7824ULL, 0x000fe200078e0225ULL, 0x0000001858187210ULL, 0x000fe20007f5e0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0022ULL, 0x00000010275f7810ULL, 0x000fe40007ffe0ffULL,
0x000000245500720cULL, 0x080fe20003fa6070ULL, 0x00000001571d7824ULL, 0x000fe200078e0225ULL,
0x0000001a581a7210ULL, 0x000fe20007f7e0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0022ULL,
0x000000245700720cULL, 0x000fc40003f86070ULL, 0x0000001b591b7210ULL, 0x000fe20001ffe4ffULL,
0x000001001d1c7825ULL, 0x000fc800078e0022ULL, 0x0000000159197824ULL, 0x040fe200010e0619ULL,
0x0000001e58207210ULL, 0x000fe20007f5e0ffULL, 0x00000010263d7824ULL, 0x100fe200078e0251ULL,
0x0000001c581e7210ULL, 0x000fe20007f7e0ffULL, 0x000000103e3f7824ULL, 0x000fe400078e0251ULL,
0x0000000159217824ULL, 0x040fe200010e061fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000183d7faeULL, 0x0003e2000c101c46ULL, 0x00000001591f7824ULL, 0x000fe200018e061dULL,
0x000000255f1d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001427617836ULL, 0x000fe20000000000ULL,
0x000000001a3f7faeULL, 0x0005e2000c901c46ULL, 0x0000001827637836ULL, 0x000fe20000000000ULL,
0x000000245f00720cULL, 0x080fe20003f66070ULL, 0x0000001c27657836ULL, 0x000fe20000000000ULL,
0x000000246100720cULL, 0x080fe20003f46070ULL, 0x0000000157277824ULL, 0x000fe200078e0204ULL,
0x000000246300720cULL, 0x080fe20003f26070ULL, 0x000000085f3e7824ULL, 0x000fe200078e00ffULL,
0x000000246500720cULL, 0x000fe20003f06070ULL, 0x000001001d187825ULL, 0x002fc800078e0022ULL,
0x00000001611b7824ULL, 0x004fe200078e0225ULL, 0x00000018581c7210ULL, 0x000fe20007fde0ffULL,
0x00000008571a7824ULL, 0x000fe400078e00ffULL, 0x0000000155267824ULL, 0x000fe200078e0204ULL,
0x00000019591d7210ULL, 0x000fe200037fe4ffULL, 0x000001001b187825ULL, 0x000fe200078e0022ULL,
0xfffffff81a247812ULL, 0x000fe400078ee227ULL, 0x0000002563277210ULL, 0x000fe20007ffe0ffULL,
0x000000015f1b7824ULL, 0x000fe200078e0204ULL, 0x00000018581a7210ULL, 0x000fe20007fde0ffULL,
0x0000000855557824ULL, 0x000fc400078e00ffULL, 0x00000001613d7824ULL, 0x000fe200078e0204ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee21bULL, 0x00000001591b7824ULL, 0x000fe200030e0619ULL,
0xfffffff855267812ULL, 0x000fe200078ee226ULL, 0x0000010027187825ULL, 0x000fc800078e0022ULL,
0x0000000861627824ULL, 0x000fe200078e00ffULL, 0x0000001858187210ULL, 0x000fe20007fde0ffULL,
0x0000000165257824ULL, 0x000fe400078e0225ULL, 0x0000000163277824ULL, 0x040fe200078e0204ULL,
0xfffffff862627812ULL, 0x000fe200078ee23dULL, 0x0000000863647824ULL, 0x000fe200078e00ffULL,
0x00000004653d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000865667824ULL, 0x000fe400078e00ffULL,
0x0000010025227825ULL, 0x000fe200078e0022ULL, 0xfffffff864647812ULL, 0x000fc400078ee227ULL,
0xfffffff866667812ULL, 0x000fe200078ee23dULL, 0x0000000159197824ULL, 0x040fe200030e0619ULL,
0x0000002258227210ULL, 0x000fe20007fde0ffULL, 0x0000001026257824ULL, 0x100fe200078e0251ULL,
0x000000513e3d7211ULL, 0x000fe200078e20ffULL, 0x0000001024277824ULL, 0x100fe400078e0251ULL,
0x00000010623f7824ULL, 0x100fe200078e0251ULL, 0x0000000020257faeULL, 0x0003e2000e901c46ULL,
0x0000001064557824ULL, 0x100fe400078e0251ULL, 0x0000001066517824ULL, 0x000fe200078e0251ULL,
0x000000001e277faeULL, 0x0003e2000e101c46ULL, 0x0000000159237824ULL, 0x000fc600030e0623ULL,
0x000000001c3d7faeULL, 0x0003e8000d901c46ULL, 0x000000001a3f7faeULL, 0x0003e8000d101c46ULL,
0x0000000018557faeULL, 0x0003e8000c901c46ULL, 0x0000000022517faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x00000004041b7811ULL, 0x040fe400078fe8ffULL,
0x00000008041d7811ULL, 0x040fe400078fe8ffULL, 0x0000000d5d187819ULL, 0x000fe200000006ffULL,
0x000000011b687824ULL, 0x140fe200078e0204ULL, 0x0000001404237811ULL, 0x000fe200078fe8ffULL,
0x000000081b197824ULL, 0x000fe200078e00ffULL, 0x0000200018187812ULL, 0x000fe200078ec0ffULL,
0x000000011d667824ULL, 0x100fe200078e0204ULL, 0x0000000c041f7811ULL, 0x040fe200078fe8ffULL,
0x00000001233e7824ULL, 0x000fe200078e0204ULL, 0xfffffff819687812ULL, 0x000fe200078ee268ULL,
0x000000081d197824ULL, 0x000fe200078e00ffULL, 0x0001400051517810ULL, 0x000fe20007ffe018ULL,
0x000000081f277824ULL, 0x000fe200078e00ffULL, 0x0000001004217811ULL, 0x040fe200078fe8ffULL,
0x000000011b1b7824ULL, 0x100fe200078e0225ULL, 0xfffffff819667812ULL, 0x000fe200078ee266ULL,
0x000000805d197824ULL, 0x000fe200078e00ffULL, 0x0000000404187211ULL, 0x040fe200078fe8ffULL,
0x0000000121627824ULL, 0x100fe200078e0204ULL, 0x00000003233f7819ULL, 0x000fe200000006ffULL,
0x00000008213d7824ULL, 0x000fe200078e00ffULL, 0x00000018041a7811ULL, 0x000fe200078fe8ffULL,
0x000000011d1d7824ULL, 0x100fe200078e0225ULL, 0x0000000718557812ULL, 0x000fe200078ec0ffULL,
0x0000000123237824ULL, 0x100fe200078e0225ULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee23eULL,
0x000000081a6c7824ULL, 0x040fe200078e00ffULL, 0x0000008040187812ULL, 0x000fe200078ef819ULL,
0x000000011a197824ULL, 0x000fe200078e0204ULL, 0x000000041f647210ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0225ULL, 0x0000001c043f7811ULL, 0x000fe200078fe8ffULL,
0x000000103e617824ULL, 0x000fe200078e0251ULL, 0xfffffff827647812ULL, 0x000fc400078ee264ULL,
0xfffffff83d627812ULL, 0x000fe200078ee262ULL, 0x000000011a3d7824ULL, 0x100fe200078e0225ULL,
0x0000002504277211ULL, 0x000fe200078fe8ffULL, 0x000000083f577824ULL, 0x040fe200078e00ffULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee219ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000000043f1a7210ULL, 0x000fe20007ffe0ffULL, 0x000000013f3f7824ULL, 0x000fe200078e0225ULL,
0x0000002521217210ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fe200078e0018ULL,
0xfffffff8576e7812ULL, 0x000fc400078ee21aULL, 0x0ffffff8556a7812ULL, 0x000fe200078ef804ULL,
0x000001001b1a7825ULL, 0x100fe200078e0018ULL, 0x0000002658267210ULL, 0x000fe40007f1e0ffULL,
0x000000516c637211ULL, 0x000fe200078e20ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0018ULL,
0x0000001a581a7210ULL, 0x000fc60007f3e0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0018ULL,
0x0000001c581c7210ULL, 0x000fc60007f5e0ffULL, 0x0000010021207825ULL, 0x000fe200078e0018ULL,
0x0000001e581e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010023227825ULL, 0x000fe200078e0018ULL,
0x0000001f591f7210ULL, 0x000fc60001ffe4ffULL, 0x000001003d247825ULL, 0x000fc800078e0018ULL,
0x000001003f187825ULL, 0x000fe200078e0018ULL, 0x00000051683f7211ULL, 0x000fc600078e20ffULL,
0x0000000159277824ULL, 0x040fe200000e0627ULL, 0x0000002058207210ULL, 0x000fe20007f1e0ffULL,
0x00000001591b7824ULL, 0x040fe200008e061bULL, 0x0000002258227210ULL, 0x000fe20007f3e0ffULL,
0x000000106a3d7824ULL, 0x000fe200078e0251ULL, 0x0000001858187210ULL, 0x000fe20007f7e0ffULL,
0x00000001591d7824ULL, 0x000fe200010e061dULL, 0x0000002458247210ULL, 0x000fe20007f5e0ffULL,
0x0000001066557824ULL, 0x100fe200078e0251ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000263d7faeULL, 0x0003e2000b901c46ULL, 0x0000001064577824ULL, 0x000fc400078e0251ULL,
0x00000010625f7824ULL, 0x000fe200078e0251ULL, 0x000000001a3f7faeULL, 0x0003e2000b901c46ULL,
0x0000000159217824ULL, 0x040fe400000e0621ULL, 0x0000000159237824ULL, 0x040fe200008e0623ULL,
0x000000001c557faeULL, 0x0003e2000b901c46ULL, 0x0000000159257824ULL, 0x040fe400010e0625ULL,
0x000000106e517824ULL, 0x000fe200078e0251ULL, 0x000000001e577faeULL, 0x0003e2000b901c46ULL,
0x0000000159197824ULL, 0x000fc600018e0619ULL, 0x00000000205f7faeULL, 0x0003e8000b901c46ULL,
0x0000000022617faeULL, 0x0003e8000b901c46ULL, 0x0000000024637faeULL, 0x0003e8000b901c46ULL,
0x0000000018517faeULL, 0x0003e4000b901c46ULL, 0x0000000152187812ULL, 0x002fe200078ec0ffULL,
0xffffffffff517424ULL, 0x000fe200078e00ffULL, 0xffffffff00197811ULL, 0x000fe200078e08ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000011800780cULL, 0x000fc80003f05070ULL,
0x0000000119197807ULL, 0x000fc80004000000ULL, 0x0000001952527210ULL, 0x000fc80007ffe0ffULL,
0x0000005b5200720cULL, 0x000fda0003f06070ULL, 0x00009200ff188b82ULL, 0x000e620000000a00ULL,
0x00000001521b8824ULL, 0x000fe200078e0208ULL, 0x00000008461d7812ULL, 0x000fe200078ec0ffULL,
0x0000002056567824ULL, 0x000fe200078e0202ULL, 0x00000010461a7812ULL, 0x000fc800078ec0ffULL,
0x000000561d1d7210ULL, 0x000fe20007ffe01aULL, 0x000000041b188825ULL, 0x002fca00078e0018ULL,
0x0000000618518981ULL, 0x000322000c1e1900ULL, 0x01b6483c1d3c79a7ULL, 0x0002a4000850003fULL,
0x0000000000187805ULL, 0x002fce0000015200ULL, 0x01b6483d1d0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fce00078e00ffULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181f7210ULL, 0x000fc80007f1e1ffULL,
0x0000001b191b7210ULL, 0x000fe400007fe5ffULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001f1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01b6483d1d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000010040187810ULL, 0x000fe20007ffe04eULL, 0x000000ffff567224ULL, 0x000fc800078e0053ULL,
0x000000014d187824ULL, 0x000fca00078e0218ULL, 0x01b00000181a7984ULL, 0x000e680000000800ULL,
0x01b2000018557984ULL, 0x0004a20000000800ULL, 0x000000531a00720bULL, 0x002fda0003f1d000ULL,
0x0000000000197806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff191b7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x004fea0003800000ULL,
0x000000025d187811ULL, 0x000fe400078ff0ffULL, 0x000000531a00720bULL, 0x000fe40003f14000ULL,
0x0000005d1800720cULL, 0x000fd60003f25270ULL, 0x00000000001c7806ULL, 0x000fe400000e0100ULL,
0x000000025d199211ULL, 0x000fe400078e38ffULL, 0x000000531a189209ULL, 0x000fe40007810000ULL,
0x000000194d1d9210ULL, 0x000fe40007ffe040ULL, 0x000099101c197816ULL, 0x000fc600000000ffULL,
0x01b400181d009388ULL, 0x0003e20000000800ULL, 0x000000ff1900720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x000000531a187209ULL, 0x000fe40007810000ULL,
0x000000ff1cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001cff7812ULL, 0x000fe2000782c0ffULL,
0x0000005318187221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x0000001800197308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x002fcc0000011604ULL, 0x00001f1819187589ULL, 0x004e6400000e0000ULL,
0x0000002818287220ULL, 0x042fe20000410000ULL, 0x0000002918297220ULL, 0x040fe20000410000ULL,
0x0000002c182c7220ULL, 0x040fe20000410000ULL, 0x0000002d182d7220ULL, 0x040fe20000410000ULL,
0x0000003018307220ULL, 0x040fe20000410000ULL, 0x0000003118317220ULL, 0x040fe20000410000ULL,
0x0000003418347220ULL, 0x040fe20000410000ULL, 0x0000003518357220ULL, 0x040fe20000410000ULL,
0x0000003818387220ULL, 0x040fe20000410000ULL, 0x0000003918397220ULL, 0x040fe20000410000ULL,
0x0000000c180c7220ULL, 0x040fe20000410000ULL, 0x0000000d180d7220ULL, 0x040fe20000410000ULL,
0x0000001018107220ULL, 0x040fe20000410000ULL, 0x0000001118117220ULL, 0x040fe20000410000ULL,
0x0000001418147220ULL, 0x040fe20000410000ULL, 0x0000001518157220ULL, 0x000fce0000410000ULL,
0x0000001954547220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000804187811ULL, 0x002fcc00078ff0ffULL, 0x00001f1819187589ULL, 0x000e6400000e0000ULL,
0x0000002a182a7220ULL, 0x042fe20000410000ULL, 0x0000002b182b7220ULL, 0x040fe20000410000ULL,
0x0000002e182e7220ULL, 0x040fe20000410000ULL, 0x0000002f182f7220ULL, 0x040fe20000410000ULL,
0x0000003218327220ULL, 0x040fe20000410000ULL, 0x0000003318337220ULL, 0x040fe20000410000ULL,
0x0000003618367220ULL, 0x040fe20000410000ULL, 0x0000003718377220ULL, 0x040fe20000410000ULL,
0x0000003a183a7220ULL, 0x040fe20000410000ULL, 0x0000003b183b7220ULL, 0x040fe20000410000ULL,
0x0000000e180e7220ULL, 0x040fe20000410000ULL, 0x0000000f180f7220ULL, 0x040fe20000410000ULL,
0x0000001218127220ULL, 0x040fe20000410000ULL, 0x0000001318137220ULL, 0x040fe20000410000ULL,
0x0000001618167220ULL, 0x040fe20000410000ULL, 0x0000001718177220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe4000780601cULL, 0x000000531a567209ULL, 0x000fd60007810000ULL,
0x800000561a1a0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1a1a0820ULL, 0x000fc80000410000ULL,
0x0000001a000b0308ULL, 0x000ea40000000800ULL, 0x0000000b55550220ULL, 0x004fce0000410000ULL,
0x000040004f537824ULL, 0x000fe200078e0202ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000200007587824ULL, 0x000fc800078e0253ULL, 0x0001300058587836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff197819ULL, 0x000fe40000011604ULL,
0x0000000bff09723eULL, 0x000fc600000010ffULL, 0x00000008191b7836ULL, 0x000fe20000000000ULL,
0x0000541009187816ULL, 0x002fca0000000009ULL, 0x00001f19180a7589ULL, 0x0002a800000e0000ULL,
0x00001f1b18097589ULL, 0x0002e400000e0000ULL, 0x012000005018783bULL, 0x0022e20000000200ULL,
0x00000058433c7211ULL, 0x000fe200078e20ffULL, 0x0000001042247824ULL, 0x100fe400078e0258ULL,
0x0000001041207824ULL, 0x000fe200078e0258ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000a18187232ULL, 0x08cfe40000200000ULL, 0x0000000a1a1a7232ULL, 0x000fe40000200000ULL,
0x0000000919197232ULL, 0x080fe40000200000ULL, 0x000000091b1b7232ULL, 0x000fce0000200000ULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x000000104a1c7824ULL, 0x000fe200078e0258ULL,
0x00000002ff507819ULL, 0x002fe2000001165dULL, 0x000000024c577836ULL, 0x000fe20000000000ULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000001c1c783bULL, 0x000e680000004200ULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x000000201838723cULL, 0x028fec0000041838ULL,
0x0000003c1828723cULL, 0x002fe20000041828ULL, 0x0000000704217812ULL, 0x000fc800078ec0ffULL,
0x0000000821217812ULL, 0x000fe200078ef804ULL, 0x0000001c1810723cULL, 0x000fe20000041810ULL,
0x000000104b3c7824ULL, 0x000fe400078e0258ULL, 0x0000000321207819ULL, 0x000fc600000006ffULL,
0x0000003e182c723cULL, 0x000fe2000004182cULL, 0xfffffff820577812ULL, 0x000fe200078ee257ULL,
0x00000800501c7824ULL, 0x000fe200078e0202ULL, 0x0000005847207211ULL, 0x000fc600078e20ffULL,
0x00000010571c7824ULL, 0x000fe200078e021cULL, 0x000000241830723cULL, 0x004fec0000041830ULL,
0x000000261834723cULL, 0x000fe20000041834ULL, 0x0000001048247824ULL, 0x000fca00078e0258ULL,
0x00000022180c723cULL, 0x000fec000004180cULL, 0x0000001e1814723cULL, 0x000fe20000041814ULL,
0x012000001c18783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000a18187232ULL, 0x084fe40000200000ULL,
0x0000000a1a1a7232ULL, 0x000fe40000200000ULL, 0x0000000919197232ULL, 0x080fe40000200000ULL,
0x000000091b1b7232ULL, 0x000fce0000200000ULL, 0x00000010491c7824ULL, 0x002fe200078e0258ULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x0000005455547221ULL, 0x000fc60000010000ULL,
0x000000002424783bULL, 0x000ee80000004200ULL, 0x000000002020783bULL, 0x000f680000004200ULL,
0x000000001c1c783bULL, 0x000ee20000004200ULL, 0x0000003c1828723cULL, 0x006fec0000041828ULL,
0x0000003e182c723cULL, 0x000fec000004182cULL, 0x000000241830723cULL, 0x008fe20000041830ULL,
0x00000001ff3e7424ULL, 0x000fca00078e00ffULL, 0x000000261834723cULL, 0x000fec0000041834ULL,
0x000000201838723cULL, 0x020fec0000041838ULL, 0x00000022180c723cULL, 0x000fec000004180cULL,
0x0000001c1810723cULL, 0x000fec0000041810ULL, 0x0000001e1814723cULL, 0x000fe20000041814ULL,
0x00000008501d7824ULL, 0x000fc800078e0202ULL, 0x01b6983e1dff79a7ULL, 0x0003e4000850003fULL,
0x00000001001b7824ULL, 0x000fca00078e0260ULL, 0x0000005a1b00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000c00200947ULL, 0x002fea0003800000ULL,
0x00009000ff187b82ULL, 0x000e620000000a00ULL, 0x000000451b1d7211ULL, 0x000fe200078e40ffULL,
0x000000011b1b7836ULL, 0x000fe20000000000ULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x00000004511a7c24ULL, 0x010fe2000f8e02ffULL, 0x000000601d277812ULL, 0x000fe400078ec0ffULL,
0x0000005a1b00720cULL, 0x000fe20003f06070ULL, 0x000000801a1b7824ULL, 0x000fe400078e00ffULL,
0x0000000144277824ULL, 0x000fc400078e0227ULL, 0x000001001b187825ULL, 0x002fd000078e0018ULL,
0x0000000400948947ULL, 0x000fea0003800000ULL, 0x00000003ff3d7819ULL, 0x100fe20000011604ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0a1dULL, 0x0000001d5c267248ULL, 0x000fe20007fe0000ULL,
0x000020005d1a7824ULL, 0x040fe200078e00ffULL, 0x000000043d217810ULL, 0x000fe20007ffe0ffULL,
0x000000805d1d7824ULL, 0x000fe200078e00ffULL, 0x0000002026267446ULL, 0x000fe2000380001bULL,
0x000000083d597836ULL, 0x000fe20000000000ULL, 0x000020001a1a7812ULL, 0x000fe200078ec0ffULL,
0x00000001211c7824ULL, 0x040fe200078e0204ULL, 0x000000043d1b7210ULL, 0x000fe20007ffe0ffULL,
0x00000008211f7824ULL, 0x000fe200078e00ffULL, 0x0001300053537810ULL, 0x000fe20007ffe01aULL,
0x0000000159237824ULL, 0x100fe200078e0227ULL, 0x000000071b257812ULL, 0x000fe200078ec0ffULL,
0x0000000c3d5f7836ULL, 0x000fe20000000000ULL, 0xfffffff81f587812ULL, 0x000fe200078ee21cULL,
0x000000013d1f7824ULL, 0x100fe200078e0227ULL, 0x00000080401a7812ULL, 0x000fe200078ef81dULL,
0x000000015f1d7824ULL, 0x100fe200078e0227ULL, 0x000000ff001b7202ULL, 0x000fe20000000f00ULL,
0x000000103d617836ULL, 0x000fe20000000000ULL, 0x000000262100720cULL, 0x0c0fe20003f26070ULL,
0x0000000121217824ULL, 0x000fe200078e0227ULL, 0x000000263d00720cULL, 0x000fe20003f06070ULL,
0x000001001f1e7825ULL, 0x000fe200078e001aULL, 0x0ffffff8253c7812ULL, 0x000fc400078ef804ULL,
0x000000143d637810ULL, 0x000fe20007ffe0ffULL, 0x0000010021207825ULL, 0x100fe200078e001aULL,
0x0000001e181e7210ULL, 0x000fe40007f5e0ffULL, 0x000000533c3f7211ULL, 0x000fe200078e20ffULL,
0x0000010023227825ULL, 0x000fe200078e001aULL, 0x0000002018207210ULL, 0x000fe40007f7e0ffULL,
0x000000265900720cULL, 0x080fe20003fa6070ULL, 0x00000001191f7824ULL, 0x000fe200010e061fULL,
0x0000002218247210ULL, 0x000fe20007f5e0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e001aULL,
0x000000265f00720cULL, 0x000fc40003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e3f7faeULL, 0x0003e2000c101c46ULL, 0x0000000119217824ULL, 0x040fe200018e0621ULL,
0x0000001c181c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000119257824ULL, 0x000fe200010e0623ULL,
0x000000266300720cULL, 0x000fe20003f46070ULL, 0x0000001058557824ULL, 0x000fe400078e0253ULL,
0x0000000161237824ULL, 0x000fe400078e0227ULL, 0x000000183d657836ULL, 0x000fe20000000000ULL,
0x0000000020557faeULL, 0x0005e2000c901c46ULL, 0x0000001c3d677836ULL, 0x000fc40000000000ULL,
0x0000000159227824ULL, 0x040fe200078e0204ULL, 0x0000000359597819ULL, 0x000fe200000006ffULL,
0x00000100231e7825ULL, 0x002fe200078e001aULL, 0x000000266500720cULL, 0x080fe40003f26070ULL,
0x000000266700720cULL, 0x080fe20003f06070ULL, 0x00000001191d7824ULL, 0x000fe200018e061dULL,
0x000000266100720cULL, 0x000fe20003f66070ULL, 0x0000000165237824ULL, 0x100fe200078e0227ULL,
0xfffffff859267812ULL, 0x000fe200078ee222ULL, 0x0000000163217824ULL, 0x004fe200078e0227ULL,
0x0000000461227210ULL, 0x000fe20007ffe0ffULL, 0x0000000861617824ULL, 0x000fe200078e00ffULL,
0x0000001e181e7210ULL, 0x000fe20007fde0ffULL, 0x0000010021207825ULL, 0x000fe200078e001aULL,
0x0000000367667819ULL, 0x000fc400000006ffULL, 0xfffffff861587812ULL, 0x000fe200078ee222ULL,
0x00000001191f7824ULL, 0x000fe200030e061fULL, 0x0000002018207210ULL, 0x000fe20007fde0ffULL,
0x00000001633d7824ULL, 0x040fe400078e0204ULL, 0x0000000863627824ULL, 0x000fe200078e00ffULL,
0x0000002119217210ULL, 0x000fe200037fe4ffULL, 0x0000010023227825ULL, 0x000fc600078e001aULL,
0xfffffff862627812ULL, 0x000fe200078ee23dULL, 0x000000015f3c7824ULL, 0x140fe200078e0204ULL,
0x0000002218227210ULL, 0x000fe20007fde0ffULL, 0x000000085f5f7824ULL, 0x000fe200078e00ffULL,
0x0000005362557211ULL, 0x000fe200078e20ffULL, 0x0000000167277824ULL, 0x000fe400078e0227ULL,
0x00000001653d7824ULL, 0x140fe200078e0204ULL, 0xfffffff85f3c7812ULL, 0x000fe200078ee23cULL,
0x0000000865647824ULL, 0x000fe400078e00ffULL, 0x00000001673f7824ULL, 0x000fc400078e0204ULL,
0x00000100271a7825ULL, 0x000fe200078e001aULL, 0xfffffff864647812ULL, 0x000fe400078ee23dULL,
0xfffffff866667812ULL, 0x000fe200078ee23fULL, 0x0000000119237824ULL, 0x000fe200030e0623ULL,
0x0000001a18187210ULL, 0x000fe20007fde0ffULL, 0x0000001026277824ULL, 0x100fe400078e0253ULL,
0x000000103c3d7824ULL, 0x100fe400078e0253ULL, 0x00000010583f7824ULL, 0x100fe200078e0253ULL,
0x0000000024277faeULL, 0x0003e2000e901c46ULL, 0x0000001064597824ULL, 0x000fc400078e0253ULL,
0x0000001066537824ULL, 0x000fe200078e0253ULL, 0x000000001c3d7faeULL, 0x0003e2000e101c46ULL,
0x0000000119197824ULL, 0x000fc600030e061bULL, 0x000000001e3f7faeULL, 0x0003e8000d901c46ULL,
0x0000000020557faeULL, 0x0003e8000d101c46ULL, 0x0000000022597faeULL, 0x0003e8000c901c46ULL,
0x0000000018537faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x00000004041d7811ULL, 0x040fe200078fe8ffULL, 0x000020005d1a7824ULL, 0x000fe200078e00ffULL,
0x00000008041f7811ULL, 0x000fe400078fe8ffULL, 0x000000041d687210ULL, 0x000fe20007ffe0ffULL,
0x000000081d1b7824ULL, 0x000fe200078e00ffULL, 0x000020001a1a7812ULL, 0x000fe200078ec0ffULL,
0x000000011f667824ULL, 0x000fe200078e0204ULL, 0x0000001404257811ULL, 0x040fe200078fe8ffULL,
0x000000011d1d7824ULL, 0x100fe200078e0227ULL, 0xfffffff81b687812ULL, 0x000fe200078ee268ULL,
0x000000081f1b7824ULL, 0x000fe200078e00ffULL, 0x0001300053537810ULL, 0x000fe20007ffe01aULL,
0x0000000125587824ULL, 0x140fe200078e0204ULL, 0x0000001004237811ULL, 0x040fe200078fe8ffULL,
0x0000000825557824ULL, 0x000fe200078e00ffULL, 0x0000000c04217811ULL, 0x040fe200078fe8ffULL,
0x000000011f1f7824ULL, 0x100fe200078e0227ULL, 0xfffffff81b667812ULL, 0x000fe200078ee266ULL,
0x0000000123627824ULL, 0x140fe200078e0204ULL, 0x00000004041a7211ULL, 0x040fe200078fe8ffULL,
0x00000008233f7824ULL, 0x000fe200078e00ffULL, 0x000000075d1b7819ULL, 0x000fe200000006ffULL,
0x0000000121647824ULL, 0x000fe200078e0204ULL, 0x00000018041c7811ULL, 0x000fe200078fe8ffULL,
0x0000000123237824ULL, 0x000fe200078e0227ULL, 0x000000071a597812ULL, 0x000fc400078ec0ffULL,
0xfffffff855587812ULL, 0x000fe200078ee258ULL, 0x000000081c6c7824ULL, 0x040fe200078e00ffULL,
0x00000080401a7812ULL, 0x000fe200078ef81bULL, 0x000000011c1b7824ULL, 0x100fe200078e0204ULL,
0x00000003213d7819ULL, 0x040fe200000006ffULL, 0x0000000121217824ULL, 0x000fe200078e0227ULL,
0x0000001c04557811ULL, 0x000fe200078fe8ffULL, 0x0000001058637824ULL, 0x000fe200078e0253ULL,
0xfffffff83f627812ULL, 0x000fe200078ee262ULL, 0x000000011c3f7824ULL, 0x000fe200078e0227ULL,
0xfffffff83d647812ULL, 0x000fe200078ee264ULL, 0x00000001551c7824ULL, 0x040fe200078e0204ULL,
0x00000027043d7211ULL, 0x000fe200078fe8ffULL, 0x0000001062617824ULL, 0x000fe200078e0253ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee21bULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x00000003555f7819ULL, 0x040fe200000006ffULL, 0x0000000155557824ULL, 0x000fe200078e0227ULL,
0x0000002725257210ULL, 0x000fe20007ffe0ffULL, 0x000001003d3c7825ULL, 0x000fe200078e001aULL,
0xfffffff85f6e7812ULL, 0x000fc400078ee21cULL, 0x0ffffff8596a7812ULL, 0x000fe200078ef804ULL,
0x000001001d267825ULL, 0x100fe200078e001aULL, 0x0000003c183c7210ULL, 0x000fe40007f1e0ffULL,
0x0000005366597211ULL, 0x000fe200078e20ffULL, 0x000001001f1c7825ULL, 0x000fe200078e001aULL,
0x0000002618267210ULL, 0x000fc60007f3e0ffULL, 0x00000100211e7825ULL, 0x000fe200078e001aULL,
0x0000001c181c7210ULL, 0x000fc60007f5e0ffULL, 0x0000010023207825ULL, 0x000fe200078e001aULL,
0x0000001e181e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010025227825ULL, 0x000fc800078e001aULL,
0x000001003f247825ULL, 0x000fc800078e001aULL, 0x00000100551a7825ULL, 0x000fc800078e001aULL,
0x00000001193d7824ULL, 0x040fe200000e063dULL, 0x0000002018207210ULL, 0x000fe20007f1e0ffULL,
0x0000000119277824ULL, 0x040fe200008e0627ULL, 0x0000002218227210ULL, 0x000fe20007f3e0ffULL,
0x000000106a3f7824ULL, 0x000fe200078e0253ULL, 0x0000002119217210ULL, 0x000fe200007fe4ffULL,
0x00000001191d7824ULL, 0x040fe200010e061dULL, 0x0000002418247210ULL, 0x000fe20007f5e0ffULL,
0x0000001068557824ULL, 0x000fe200078e0253ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c3f7faeULL, 0x0003e2000b901c46ULL, 0x00000001191f7824ULL, 0x040fe200018e061fULL,
0x0000001a18187210ULL, 0x000fe20007f7e0ffULL, 0x00000010645f7824ULL, 0x000fe200078e0253ULL,
0x0000000026557faeULL, 0x0003e2000b901c46ULL, 0x0000000119237824ULL, 0x000fc400008e0623ULL,
0x000000106c657824ULL, 0x000fe200078e0253ULL, 0x000000536e537211ULL, 0x000fe200078e20ffULL,
0x0000000119257824ULL, 0x040fe200010e0625ULL, 0x000000001c597faeULL, 0x0003e2000b901c46ULL,
0x0000000119197824ULL, 0x000fc600018e061bULL, 0x000000001e5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000020617faeULL, 0x0003e8000b901c46ULL, 0x0000000022637faeULL, 0x0003e8000b901c46ULL,
0x0000000024657faeULL, 0x0003e8000b901c46ULL, 0x0000000018537faeULL, 0x0003e4000b901c46ULL,
0x0000002050197824ULL, 0x002fe200078e0202ULL, 0x0000001046187812ULL, 0x040fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008461a7812ULL, 0x000fc800078ec0ffULL,
0x000000191a1f7210ULL, 0x000fc80007ffe018ULL, 0x01b6683e1f3e79a7ULL, 0x0002a6000850003fULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x01b6683f1f0075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ff001c7202ULL, 0x000fce0000000f00ULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fce0000015200ULL, 0x0000001a181d7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc8000001141bULL,
0x0000001d1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1b7224ULL, 0x000fca00000e061bULL,
0x000000021a1a7819ULL, 0x000fc8000000121bULL, 0x0000001a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01b6683f1f0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000180404e7810ULL, 0x000fe40007ffe04eULL, 0x0000005600507202ULL, 0x000fc60000000f00ULL,
0x000000014d4e7824ULL, 0x000fca00078e024eULL, 0x01b000004e197984ULL, 0x000ea80000000800ULL,
0x01b200004e537984ULL, 0x0006e20000000800ULL, 0x000000561900720bULL, 0x004fda0003f1d000ULL,
0x0000000000187806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff181b7812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x00afea0003800000ULL,
0x000000035d187811ULL, 0x000fe400078ff0ffULL, 0x000000561900720bULL, 0x000fe40003f14000ULL,
0x0000005d1800720cULL, 0x000fd60003f25270ULL, 0x00000000001c7806ULL, 0x000fe400000e0100ULL,
0x000000805d1a9824ULL, 0x000fe200078e0202ULL, 0x0000005619189209ULL, 0x000fc80007810000ULL,
0x0000001a4d4d9210ULL, 0x000fe40007ffe040ULL, 0x000099101c1a7816ULL, 0x000fc600000000ffULL,
0x01b400184d009388ULL, 0x0003e20000000800ULL, 0x000000ff1a00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x00000056191d7209ULL, 0x000fe40007810000ULL,
0x000000ff1cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001cff7812ULL, 0x000fe2000782c0ffULL,
0x000000561d187221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x00000018001d7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x002fcc0000011604ULL, 0x00001f181d187589ULL, 0x004e6400000e0000ULL,
0x0000002818287220ULL, 0x042fe20000410000ULL, 0x0000002918297220ULL, 0x040fe20000410000ULL,
0x0000002c182c7220ULL, 0x040fe20000410000ULL, 0x0000002d182d7220ULL, 0x040fe20000410000ULL,
0x0000003018307220ULL, 0x040fe20000410000ULL, 0x0000003118317220ULL, 0x040fe20000410000ULL,
0x0000003418347220ULL, 0x040fe20000410000ULL, 0x0000003518357220ULL, 0x040fe20000410000ULL,
0x0000003818387220ULL, 0x040fe20000410000ULL, 0x0000003918397220ULL, 0x040fe20000410000ULL,
0x0000000c180c7220ULL, 0x040fe20000410000ULL, 0x0000000d180d7220ULL, 0x040fe20000410000ULL,
0x0000001018107220ULL, 0x040fe20000410000ULL, 0x0000001118117220ULL, 0x040fe20000410000ULL,
0x0000001418147220ULL, 0x040fe20000410000ULL, 0x0000001518157220ULL, 0x000fce0000410000ULL,
0x0000001d54547220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000804187811ULL, 0x002fcc00078ff0ffULL, 0x00001f181d187589ULL, 0x000e6400000e0000ULL,
0x0000002a182a7220ULL, 0x042fe20000410000ULL, 0x0000002b182b7220ULL, 0x040fe20000410000ULL,
0x0000002e182e7220ULL, 0x040fe20000410000ULL, 0x0000002f182f7220ULL, 0x040fe20000410000ULL,
0x0000003218327220ULL, 0x040fe20000410000ULL, 0x0000003318337220ULL, 0x040fe20000410000ULL,
0x0000003618367220ULL, 0x040fe20000410000ULL, 0x0000003718377220ULL, 0x040fe20000410000ULL,
0x0000003a183a7220ULL, 0x040fe20000410000ULL, 0x0000003b183b7220ULL, 0x040fe20000410000ULL,
0x0000000e180e7220ULL, 0x040fe20000410000ULL, 0x0000000f180f7220ULL, 0x040fe20000410000ULL,
0x0000001218127220ULL, 0x040fe20000410000ULL, 0x0000001318137220ULL, 0x040fe20000410000ULL,
0x0000001618167220ULL, 0x040fe20000410000ULL, 0x0000001718177220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fe4000780601cULL, 0x0000005619507209ULL, 0x000fd60007810000ULL,
0x8000005019190221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL,
0x00000019000b0308ULL, 0x000ea40000000800ULL, 0x0000000b53530220ULL, 0x004fce0000410000ULL,
0x0000000704197812ULL, 0x000fe200078ec0ffULL, 0x000040004f187824ULL, 0x002fe200078e0202ULL,
0x00000002ff4d7819ULL, 0x000fe2000001165dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000819197812ULL, 0x000fe200078ef804ULL, 0x00002000071a7824ULL, 0x000fe200078e0218ULL,
0x000000024d187211ULL, 0x000fc600078e58ffULL, 0x0000000819197824ULL, 0x000fca00078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee24cULL, 0x000140001a4c7836ULL, 0x000fc80000000000ULL,
0x0000001019187824ULL, 0x000fe200078e0218ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff0a7819ULL, 0x000fe40000011604ULL, 0x0000000bff09723eULL, 0x000fc600000010ffULL,
0x000000080a1a7836ULL, 0x000fe20000000000ULL, 0x0000541009197816ULL, 0x000fca0000000009ULL,
0x00001f0a190a7589ULL, 0x0002a800000e0000ULL, 0x00001f1a19097589ULL, 0x0002e400000e0000ULL,
0x012800001818783bULL, 0x002e620000000200ULL, 0x0000001043437824ULL, 0x100fe200078e024cULL,
0x0000004c423c7211ULL, 0x000fe200078e20ffULL, 0x0000001041207824ULL, 0x000fe200078e024cULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000a18187232ULL, 0x086fe40000200000ULL,
0x0000000a1a1a7232ULL, 0x000fe40000200000ULL, 0x0000000919197232ULL, 0x088fe40000200000ULL,
0x000000091b1b7232ULL, 0x000fce0000200000ULL, 0x000000104a247824ULL, 0x000fe200078e024cULL,
0x000000004340783bULL, 0x000f620000004200ULL, 0x000000034d1d7836ULL, 0x000fe40000000000ULL,
0x0000005453537221ULL, 0x000fe20000010000ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x000008001d1c7824ULL, 0x000fc600078e0202ULL, 0x000000002020783bULL, 0x000f640000004200ULL,
0x0000001c571c7211ULL, 0x000fe400078e20ffULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x011000001c1c783bULL, 0x000f640000000200ULL, 0x000000401828723cULL, 0x02afec0000041828ULL,
0x00000042182c723cULL, 0x000fec000004182cULL, 0x0000003c1830723cULL, 0x004fec0000041830ULL,
0x0000003e1834723cULL, 0x000fec0000041834ULL, 0x000000201838723cULL, 0x000fec0000041838ULL,
0x00000022180c723cULL, 0x000fec000004180cULL, 0x000000241810723cULL, 0x000fec0000041810ULL,
0x000000261818723cULL, 0x000fe20000041814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000a1c1c7232ULL, 0x080fe40000200000ULL,
0x0000000a1e1e7232ULL, 0x000fe40000200000ULL, 0x000000091d1d7232ULL, 0x080fe40000200000ULL,
0x000000091f1f7232ULL, 0x000fce0000200000ULL, 0x0000001047207824ULL, 0x100fe200078e024cULL,
0x000000024d4d7211ULL, 0x000fe200078e18ffULL, 0x000000104b3c7824ULL, 0x100fe400078e024cULL,
0x0000001048247824ULL, 0x100fe400078e024cULL, 0x0000001049147824ULL, 0x000fe200078e024cULL,
0x000000002020783bULL, 0x000e620000004200ULL, 0x0000000100607824ULL, 0x000fc600078e0260ULL,
0x000000003c3c783bULL, 0x000ea40000004200ULL, 0x0000005a6000720cULL, 0x000fe40003f06070ULL,
0x000000002424783bULL, 0x000ee80000004200ULL, 0x000000001414783bULL, 0x000f620000004200ULL,
0x000000221c0c723cULL, 0x002fec000004180cULL, 0x0000003c1c28723cULL, 0x004fe20000041828ULL,
0x00000001ff227424ULL, 0x000fc800078e00ffULL, 0x01b6a0224dff79a7ULL, 0x0003e2000850003fULL,
0x0000003e1c2c723cULL, 0x000fec000004182cULL, 0x000000241c30723cULL, 0x008fec0000041830ULL,
0x000000261c34723cULL, 0x000fec0000041834ULL, 0x000000201c38723cULL, 0x000fec0000041838ULL,
0x000000141c10723cULL, 0x020fec0000041810ULL, 0x000000161c18723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff9c00788947ULL, 0x002fde000383ffffULL,
0x00000000001d7919ULL, 0x000e620000002500ULL, 0x0000001800277202ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0012ULL, 0x0000000f001e7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1c7224ULL, 0x000fe400078e001aULL, 0x000000ffff0a7224ULL, 0x000fe400078e0013ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff187224ULL, 0x000fc400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e0019ULL, 0x000000ffff137224ULL, 0x000fe400078e0010ULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe200078e000cULL,
0x0000005a1d00720cULL, 0x002fda0003f06070ULL, 0x0000000000c40947ULL, 0x000fea0003800000ULL,
0x0180000053047836ULL, 0x000fca0000000000ULL, 0x7f80000004047812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000820000087802ULL, 0x000fce0000000f00ULL, 0x000000b800587944ULL, 0x010fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005300047308ULL, 0x000e640000001000ULL,
0xbf80000004087423ULL, 0x002fc80000000053ULL, 0x800000ff08097221ULL, 0x000fc80000010100ULL,
0x0000000904047223ULL, 0x000fce0000000004ULL, 0x0000000000097919ULL, 0x000f640000000000ULL,
0x00000002ff0d7819ULL, 0x022fe40000011609ULL, 0x0000000809097811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0d04087589ULL, 0x000e6800000e0000ULL,
0x00001f0904097589ULL, 0x000ea200000e0000ULL, 0x0000002808287220ULL, 0x042fe20000410000ULL,
0x0000002908297220ULL, 0x040fe20000410000ULL, 0x0000002c082c7220ULL, 0x040fe20000410000ULL,
0x0000002d082d7220ULL, 0x040fe20000410000ULL, 0x0000003008307220ULL, 0x040fe20000410000ULL,
0x0000003108317220ULL, 0x040fe20000410000ULL, 0x0000003408347220ULL, 0x040fe20000410000ULL,
0x0000003508357220ULL, 0x040fe20000410000ULL, 0x0000003808387220ULL, 0x040fe20000410000ULL,
0x0000003908397220ULL, 0x040fe20000410000ULL, 0x0000001108117220ULL, 0x040fe20000410000ULL,
0x0000000e080e7220ULL, 0x040fe20000410000ULL, 0x0000001308137220ULL, 0x040fe20000410000ULL,
0x0000001208127220ULL, 0x040fe20000410000ULL, 0x0000002708277220ULL, 0x040fe20000410000ULL,
0x0000001a081a7220ULL, 0x000fe20000410000ULL, 0x0000002a092a7220ULL, 0x044fe20000410000ULL,
0x0000002b092b7220ULL, 0x040fe20000410000ULL, 0x0000002e092e7220ULL, 0x040fe20000410000ULL,
0x0000002f092f7220ULL, 0x040fe20000410000ULL, 0x0000003209327220ULL, 0x040fe20000410000ULL,
0x0000003309337220ULL, 0x040fe20000410000ULL, 0x0000003609367220ULL, 0x040fe20000410000ULL,
0x0000003709377220ULL, 0x040fe20000410000ULL, 0x0000003a093a7220ULL, 0x040fe20000410000ULL,
0x0000003b093b7220ULL, 0x040fe20000410000ULL, 0x0000001809187220ULL, 0x040fe20000410000ULL,
0x0000001e091e7220ULL, 0x040fe20000410000ULL, 0x0000000b090b7220ULL, 0x040fe20000410000ULL,
0x0000000a090a7220ULL, 0x040fe20000410000ULL, 0x0000001c091c7220ULL, 0x040fe20000410000ULL,
0x0000001b091b7220ULL, 0x000fce0000410000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x000000131212723eULL, 0x000fe400000010ffULL, 0x000000271a13723eULL, 0x000fe200000010ffULL,
0x00001000071a7824ULL, 0x000fe200078e0202ULL, 0x0000002c2d15723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001a4f027211ULL, 0x000fc400078e58ffULL,
0x000000303116723eULL, 0x000fe400000010ffULL, 0x000000343517723eULL, 0x000fe400000010ffULL,
0x0000000b0a0a723eULL, 0x000fe400000010ffULL, 0x000000110e11723eULL, 0x000fe400000010ffULL,
0x0000001c1b0b723eULL, 0x000fe400000010ffULL, 0x00000032330e723eULL, 0x000fc400000010ffULL,
0x00000036370f723eULL, 0x000fe400000010ffULL, 0x000000010000780cULL, 0x000fe40003f05270ULL,
0x00000003ff197819ULL, 0x002fe40000011604ULL, 0xfffffff8ff097812ULL, 0x000fe400078ee204ULL,
0x0000000319087812ULL, 0x000fe400078ec0ffULL, 0x00000008090d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809107824ULL, 0x000fc400078e00ffULL, 0x0000000809217824ULL, 0x000fe200078e00ffULL,
0x000000030d237819ULL, 0x040fe200000006ffULL, 0x0000000108097824ULL, 0x040fe400078e0209ULL,
0x00000001080c7824ULL, 0x000fe400078e020dULL, 0x0000000409087836ULL, 0x000fe20000000000ULL,
0xfffffff8101f7812ULL, 0x000fe200078ee209ULL, 0x000000080d147824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee20cULL, 0x0000000c090d7836ULL, 0x000fe20000000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x000000181e09723eULL, 0x000fe200000010ffULL, 0x00000010231b7824ULL, 0x100fe200078e0202ULL,
0xfffffff814257812ULL, 0x000fe200078ee20dULL, 0x0000001021187824ULL, 0x000fe200078e0202ULL,
0x000000282914723eULL, 0x000fe200000010ffULL, 0x0000000145297824ULL, 0x000fe200078e0204ULL,
0x000000383910723eULL, 0x000fe200000010ffULL, 0x000000ff001e7306ULL, 0x000e620000202400ULL,
0x0000002a2b0c723eULL, 0x000fe200000010ffULL, 0x000000141f007844ULL, 0x000fe20000000200ULL,
0x0000002e2f0d723eULL, 0x000fe200000010ffULL, 0x0000001029287824ULL, 0x000fe200078e021aULL,
0x0000003a3b08723eULL, 0x000fe200000010ffULL, 0x0000001018007844ULL, 0x000fe20000000200ULL,
0x00000002251c7211ULL, 0x000fc600078e20ffULL, 0x0000000c1b007844ULL, 0x000fe80000000200ULL,
0x000000081c007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000282c7984ULL, 0x000e680000000c00ULL, 0x0004000028247984ULL, 0x000ea80000000c00ULL,
0x0008000028307984ULL, 0x000ee80000000c00ULL, 0x000c000028207984ULL, 0x000f620000000c00ULL,
0x0000002f1e2f7230ULL, 0x002fc40000200800ULL, 0x0000002e1e2e7230ULL, 0x040fe40000200800ULL,
0x0000002d1e2d7230ULL, 0x040fe40000200800ULL, 0x0000002c1e2c7230ULL, 0x040fe40000200800ULL,
0x000000271e277230ULL, 0x044fe40000200800ULL, 0x000000261e117230ULL, 0x040fe40000200800ULL,
0x000000251e257230ULL, 0x000fc40000200800ULL, 0x000000241e107230ULL, 0x000fe40000200800ULL,
0x000000332f2f7230ULL, 0x008fe40000200000ULL, 0x000000322e2e7230ULL, 0x000fe40000200000ULL,
0x000000312d2d7230ULL, 0x000fe40000200000ULL, 0x000000302c2c7230ULL, 0x000fe40000200000ULL,
0x0000002327237230ULL, 0x020fc40000200000ULL, 0x0000002211227230ULL, 0x000fe20000200000ULL,
0x0000002c28007388ULL, 0x0003e20000000c00ULL, 0x0000002125217230ULL, 0x000fe40000200000ULL,
0x0000002010207230ULL, 0x000fca0000200000ULL, 0x0004002028007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002800288947ULL, 0x000fea0003800000ULL,
0x00000400ff1b7b82ULL, 0x000ea20000000800ULL, 0x0000000000147919ULL, 0x000ee20000002600ULL,
0x0000004029237836ULL, 0x002fe20000000000ULL, 0x0000000000157919ULL, 0x000eea0000002700ULL,
0x00009800ff087b82ULL, 0x000eb00000000800ULL, 0x00009c00ff107b82ULL, 0x000e620000000a00ULL,
0x000000081b097224ULL, 0x004fc800078e02ffULL, 0x00000000090c7224ULL, 0x0c0fe200078e02ffULL,
0x0000000f091f7811ULL, 0x000fe200078e10ffULL, 0x0000001b151b7224ULL, 0x008fe200078e0214ULL,
0x0000000028087984ULL, 0x0004a40000000c00ULL, 0xfffffff01f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000001b1c7224ULL, 0x000fc800078e02ffULL, 0x000000800c137824ULL, 0x000fe200078e021fULL,
0x0000001d1c1d7210ULL, 0x000fc60007ffe0ffULL, 0x000000800c127824ULL, 0x000fe400078e0213ULL,
0x00040000280c7984ULL, 0x0004a40000000c00ULL, 0x0000007f12127836ULL, 0x000fca0000000000ULL,
0xffffff8012157812ULL, 0x000fc800078ec0ffULL, 0x0000001015167210ULL, 0x002fc80007f1e0ffULL,
0x000000161d167211ULL, 0x000fe200078260ffULL, 0x000000ffff127224ULL, 0x000fe200000e0611ULL,
0x000000014fff7812ULL, 0x000fc8000780f85dULL, 0x000000121d177211ULL, 0x000fe400008f64ffULL,
0x000000101f277210ULL, 0x000fe20007f3e0ffULL, 0x0000080007167825ULL, 0x000fc800078e0016ULL,
0x0000001029207825ULL, 0x000fc800078e0016ULL, 0x0000001023167825ULL, 0x000fc800078e0016ULL,
0x000000ffff297224ULL, 0x000fe200008e0611ULL, 0x0000000000400947ULL, 0x004fec0003800000ULL,
0x0000001004147824ULL, 0x000fe200078e00ffULL, 0x000000071d127819ULL, 0x000fe400000006ffULL,
0x00000001ff187819ULL, 0x000fe40000011604ULL, 0x0000007014257812ULL, 0x000fe400078ec0ffULL,
0x0000001012247210ULL, 0x000fe40007ebe013ULL, 0x00000019ff147819ULL, 0x000fe4000001161dULL,
0x0000000c18237812ULL, 0x000fc400078ec0ffULL, 0x0000002725127210ULL, 0x000fe40007a3e012ULL,
0x0000001114187210ULL, 0x000fe40002fec4ffULL, 0x0000001223227210ULL, 0x000fe40007fbe0ffULL,
0x00000029ff147210ULL, 0x000fe40000fe4414ULL, 0x0000002423247210ULL, 0x000fc60007c7e025ULL,
0x000000ffff237224ULL, 0x000fe200028e0614ULL, 0x00000018ff257210ULL, 0x000fc80001fe84ffULL,
0x0000005022007986ULL, 0x0003e8000c101906ULL, 0x0000005324007986ULL, 0x0003e4000c101906ULL,
0x000000ff0400720cULL, 0x000fe20000705670ULL, 0x0000000820007986ULL, 0x0005e8000c101d06ULL,
0x0000000c16007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fee0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009c00ff087b82ULL, 0x004ea20000000a00ULL,
0xffffffff000b7836ULL, 0x000fe40000000000ULL, 0x000000041b087825ULL, 0x004fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x0000000b080879a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000b0800720cULL, 0x010fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000008ff007988ULL, 0x0007e60008000004ULL, 0x0000000000097919ULL, 0x004ea20000008800ULL,
0x00000400001e7802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000654091e7816ULL, 0x004fca000000001eULL,
0x000000001e087984ULL, 0x008ea40000000000ULL, 0x000000ff0800720cULL, 0x004fda0003f05270ULL,
0x0000002000cc8947ULL, 0x000fea0003800000ULL, 0x000000ff5d00720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001004097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe40000011604ULL, 0x000000271c087211ULL, 0x000fe400078038ffULL,
0x00000070090b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL,
0x000000291c097211ULL, 0x000fe400000f3cffULL, 0x000000080a087210ULL, 0x000fc8000791e00bULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080a7981ULL, 0x000528000c1e1900ULL,
0x00008006080b7981ULL, 0x000522000c1e1900ULL, 0x000000020000780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x004fea0003800000ULL, 0x00010006080d7981ULL, 0x000522000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x004fea0003800000ULL,
0x00018006080f7981ULL, 0x000522000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x004fea0003800000ULL, 0x0002000608177981ULL, 0x000522000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x004fea0003800000ULL,
0x0002800608197981ULL, 0x000522000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x004fea0003800000ULL, 0x000000080000780cULL, 0x000fe20003f06070ULL,
0x00030006081b7981ULL, 0x000518000c1e1900ULL, 0x00038006081d0981ULL, 0x000524000c1e1900ULL,
0x0000000700087836ULL, 0x004fca0000000000ULL, 0x00000003ff0c7819ULL, 0x000fc80000011608ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001f1c097211ULL, 0x040fe200078038ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000000a00217202ULL, 0x010fe20000000f00ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000001009107210ULL, 0x000fe40007f3e0ffULL, 0x000000ff1c087211ULL, 0x000fe400000f3cffULL,
0x0000078010237810ULL, 0x002fc80007f5e0ffULL, 0x00000008ff117210ULL, 0x000fd200017e2411ULL,
0x0000000400007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050c007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x000000210a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xfffc800608217981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000b0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xfffd0006080b7981ULL, 0x000326000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000d0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000404087819ULL, 0x002fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xfffd8006080d7981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000000f0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xfffe0006080f7981ULL, 0x000326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x000000170a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fc80007f3e0ffULL, 0x00000011ff097210ULL, 0x000fca0000ffe4ffULL,
0xfffe800608177981ULL, 0x000328000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x000000190a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xffff000608197981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0xffff8006081b7981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001d0a0a7209ULL, 0x000fca0007810000ULL,
0x0000000800007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000404087819ULL, 0x002fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011604ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000823087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0611ULL,
0x00000006081d7981ULL, 0x000326000c1e1900ULL, 0x0000040023237810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x0000000000047919ULL, 0x000ea40000000000ULL,
0x0000001004087824ULL, 0x006fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x010fc80000011604ULL,
0x0000007008097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000001e0b097210ULL, 0x000fca0007ffe009ULL, 0x0000000a09007388ULL, 0x0003e40000000800ULL,
0x00009c00ff247b82ULL, 0x002e620000000a00ULL, 0x000000070400780cULL, 0x040fe20003f04070ULL,
0x000008005d1b7824ULL, 0x000fe200078e00ffULL, 0x00000002ff0a7819ULL, 0x000fe2000001165dULL,
0x000000014f147824ULL, 0x040fe200078e021cULL, 0x0000001e4f207211ULL, 0x000fe200078e68ffULL,
0x0000001004217824ULL, 0x000fe200078e00ffULL, 0x000000010a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000006004117836ULL, 0x000fe20000000000ULL, 0x000008001b1b7812ULL, 0x000fe200078ee2ffULL,
0x0000100007207824ULL, 0x000fe200078e0220ULL, 0x00000001ff227819ULL, 0x000fc40000011604ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x00000040040f7810ULL, 0x000fe20007ffe0ffULL,
0x000002004f0c8824ULL, 0x040fe200078e021eULL, 0x0000001e4f088211ULL, 0x000fe400078e48ffULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x0000007021217812ULL, 0x000fe400078ec0ffULL,
0x0000000000287805ULL, 0x000fc4000001ff00ULL, 0x0000000c070d8211ULL, 0x040fe200078e40ffULL,
0x00000100070b8824ULL, 0x000fe200078e0208ULL, 0x0000000c22227812ULL, 0x000fe400078ec0ffULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000002415187210ULL, 0x002fe20007f3e0ffULL, 0x000000800a178824ULL, 0x040fe200078e020bULL,
0x000000241f1f7210ULL, 0x000fe20007f7e0ffULL, 0x000002005d0b7824ULL, 0x000fe200078e00ffULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff197224ULL, 0x000fe200008e0625ULL,
0x00000024131d7210ULL, 0x000fe20007f3e0ffULL, 0x000000800a278824ULL, 0x000fe200078e020dULL,
0x000008000b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000100014087825ULL, 0x000fe200078e0018ULL,
0x0000001e22247210ULL, 0x000fe20007ffe021ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001b08087210ULL, 0x000fe20007f5e0ffULL, 0x00000001200b7824ULL, 0x000fe200078e020bULL,
0x0000000024247984ULL, 0x000e620000000800ULL, 0x00000020040d7836ULL, 0x000fe20000000000ULL,
0x0000001704178211ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000001f14128211ULL, 0x040fe200078438ffULL, 0x000000ffff237224ULL, 0x000fe200008e0625ULL,
0x0000001d14108211ULL, 0x000fe200078238ffULL, 0x0000001004157824ULL, 0x000fe200078e020bULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x000000100d0a7825ULL, 0x000fe200078e0008ULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000100f0c7825ULL, 0x100fe200078e0008ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000002514138211ULL, 0x040fe200010f3cffULL, 0x00000010110e7825ULL, 0x000fe200078e0008ULL,
0x0000002314118211ULL, 0x000fc400008f3cffULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x000000004f00720cULL, 0x000fe20003f26070ULL, 0x0000001004087825ULL, 0x000fc800078e0008ULL,
0x0000001004108825ULL, 0x040fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008157faeULL, 0x000fe6000b901c46ULL, 0x00000010042b8824ULL, 0x040fe200078e0227ULL,
0x003800000a157faeULL, 0x000fe2000b901c46ULL, 0x0000001004128825ULL, 0x000fe200078e0012ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x005800000c157faeULL, 0x000fe2000b901c46ULL,
0x000000ffff447224ULL, 0x000fc600078e00ffULL, 0x007800000e157faeULL, 0x000fe8000b901c46ULL,
0x0458000010178faeULL, 0x000fe8000b901c46ULL, 0x04180000122b8faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000002a7805ULL, 0x004fe2000001ff00ULL,
0x0000000800bc1947ULL, 0x002fec0003800000ULL, 0x00000003ff087819ULL, 0x000fe20000011604ULL,
0x000002004f507824ULL, 0x000fe200078e021eULL, 0xfffffff8ff097812ULL, 0x000fe200078ee204ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x0000000308087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200078e004fULL, 0x00000003094a7819ULL, 0x040fe200000006ffULL,
0x00000008090b7836ULL, 0x000fe20000000000ULL, 0x00000002ff4e7819ULL, 0x000fe20000011604ULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000005007507211ULL, 0x000fe200078e40ffULL,
0x0000000108097824ULL, 0x000fc400078e0209ULL, 0x00000001084b7824ULL, 0x000fe400078e020bULL,
0x000000080b087824ULL, 0x040fe200078e00ffULL, 0x00000004094c7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee209ULL,
0x0000000c094d7836ULL, 0x000fe20000000000ULL, 0xfffffff8084b7812ULL, 0x000fe200078ee24bULL,
0x000000084e487836ULL, 0x000fe20000000000ULL, 0xfffffff80d4c7812ULL, 0x000fe400078ee24cULL,
0xfffffff80a4d7812ULL, 0x000fce00078ee24dULL, 0x0000000215497836ULL, 0x000fca0000000000ULL,
0x000000004900720cULL, 0x000fda0003f06070ULL, 0x0000000000a40947ULL, 0x000fea0003800000ULL,
0x000000070400780cULL, 0x000fe20003f44070ULL, 0x000000011c147824ULL, 0x100fe200078e0249ULL,
0x00000001ff0a7819ULL, 0x000fe20000011649ULL, 0x00000020040b7836ULL, 0x000fe40000000000ULL,
0x0000100014087825ULL, 0x000fe200078e0018ULL, 0x000000010a537812ULL, 0x000fc600078ec0ffULL,
0x0000004004557836ULL, 0x000fe20000000000ULL, 0x0000001b080e7210ULL, 0x000fe20007f1e0ffULL,
0x0000040049087824ULL, 0x000fe400078e00ffULL, 0x000002004f0ca824ULL, 0x140fe400078e021eULL,
0x000000ffff0f7224ULL, 0x000fe200000e0609ULL, 0x0000080008097812ULL, 0x000fe200078ec0ffULL,
0x000002004f0aa824ULL, 0x000fe200078e021eULL, 0x0000000c0750a211ULL, 0x000fe200078e40ffULL,
0x0000006004577836ULL, 0x000fe20000000000ULL, 0x0000001d1410a211ULL, 0x000fe200078038ffULL,
0x0000000120097824ULL, 0x000fe200078e0209ULL, 0x0000001f140ca211ULL, 0x000fe200078238ffULL,
0x000000805351a824ULL, 0x010fe200078e0250ULL, 0x0000000a0750a211ULL, 0x000fe200078e40ffULL,
0x0000001004127825ULL, 0x000fe200078e000eULL, 0x000000231411a211ULL, 0x000fc400000f3cffULL,
0x0000000904177211ULL, 0x000fe200078e20ffULL, 0x000000100b087825ULL, 0x000fe200078e000eULL,
0x00000025140da211ULL, 0x000fc600008f3cffULL, 0x000000805353a824ULL, 0x000fe200078e0250ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000012177faeULL, 0x0003e2000b901c46ULL,
0x00000010550a7825ULL, 0x000fc600078e000eULL, 0x0038000008177faeULL, 0x0003e2000b901c46ULL,
0x00000010570e7825ULL, 0x000fc600078e000eULL, 0x005800000a177faeULL, 0x0003e2000b901c46ULL,
0x000000100410a825ULL, 0x000fc600078e0010ULL, 0x007800000e177faeULL, 0x0003e2000b901c46ULL,
0x000000100451a824ULL, 0x040fe400078e0251ULL, 0x00000010040ca825ULL, 0x000fc600078e000cULL,
0x045800001051afaeULL, 0x0003e2000b901c46ULL, 0x000000100453a824ULL, 0x000fca00078e0253ULL,
0x041800000c53afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004015087824ULL, 0x002fca00078e00ffULL, 0x0000008008087812ULL, 0x000fc800078ec0ffULL,
0x0000005021097210ULL, 0x000fe20007ffe008ULL, 0x0000040015087824ULL, 0x000fc600078e00ffULL,
0x0000000922517210ULL, 0x010fe40007ffe0ffULL, 0x0000080008097812ULL, 0x000fc800078ec0ffULL,
0x0000018020147810ULL, 0x000fe20007ffe009ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800051117984ULL, 0x000e620000000800ULL, 0x000000104a087824ULL, 0x100fe400078e0214ULL,
0x000000104c0c7824ULL, 0x100fe200078e0214ULL, 0x0045800051527984ULL, 0x000fe20000000800ULL,
0x000000104b107824ULL, 0x000fe200078e0214ULL, 0x000000144d147211ULL, 0x000fe400078e20ffULL,
0x000000000808783bULL, 0x000ea80000000200ULL, 0x000000000c0c783bULL, 0x000ee20000000200ULL,
0x0000001124157221ULL, 0x002fc60000010100ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x3fb8aa3b15577820ULL, 0x000fc60000410000ULL, 0x000000001414783bULL, 0x000f220000000200ULL,
0x0001000009547824ULL, 0x004fe200078e00ffULL, 0x000076320a537816ULL, 0x040fe20000000053ULL,
0x0000005700577308ULL, 0x000ea20000000800ULL, 0x000100000a557824ULL, 0x000fe200078e00ffULL,
0x000076320b0a7816ULL, 0x040fe2000000000aULL, 0x000100000e597824ULL, 0x008fe200078e00ffULL,
0x0000763208517816ULL, 0x040fe20000000051ULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x000076320e587816ULL, 0x000fe20000000058ULL, 0x000100000b567824ULL, 0x000fe200078e00ffULL,
0x000076320f0e7816ULL, 0x040fe2000000000eULL, 0x000100000f0f7824ULL, 0x000fe200078e00ffULL,
0x000076320c0b7816ULL, 0x040fe2000000000bULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x000000100c0c7819ULL, 0x000fe200000006ffULL, 0x0001000058587824ULL, 0x000fc400078e00ffULL,
0x0000005257657220ULL, 0x004fe20000410000ULL, 0x0000763209527816ULL, 0x000fe40000000052ULL,
0x000076320d577816ULL, 0x000fe20000000057ULL, 0x0000004765477221ULL, 0x000fe20000010000ULL,
0x00001f4e65667589ULL, 0x000ea200000e0000ULL, 0x0001000052097824ULL, 0x000fe400078e00ffULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x00001f4865657589ULL, 0x000ee200000e0000ULL,
0x0001000057577824ULL, 0x000fe200078e00ffULL, 0x00007632135d7816ULL, 0x042fe2000000005dULL,
0x0001000013607824ULL, 0x000fe200078e00ffULL, 0x00007632105a7816ULL, 0x040fe2000000005aULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00007632155f7816ULL, 0x050fe2000000005fULL,
0x0001000015627824ULL, 0x000fe200078e00ffULL, 0x0000004900157202ULL, 0x000fe20000000f00ULL,
0x0001000017647824ULL, 0x000fe200078e00ffULL, 0x00007632115b7816ULL, 0x000fe2000000005bULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x000000001500720cULL, 0x000fe20003f06070ULL,
0x000100005f5f7824ULL, 0x000fc400078e00ffULL, 0x0000006609367223ULL, 0x084fe20000010036ULL,
0x000000100a097819ULL, 0x000fe200000006ffULL, 0x0000006608397223ULL, 0x080fe20000010039ULL,
0x00007632125c7816ULL, 0x000fe2000000005cULL, 0x0001000053087824ULL, 0x000fe200078e00ffULL,
0x0000763214137816ULL, 0x000fe20000000013ULL, 0x00000066093e7223ULL, 0x080fe2000001003eULL,
0x0000763216617816ULL, 0x000fe20000000061ULL, 0x000100000e097824ULL, 0x000fe200078e00ffULL,
0x0000763217637816ULL, 0x000fe20000000063ULL, 0x00000066083f7223ULL, 0x080fe2000001003fULL,
0x0000001011117819ULL, 0x000fe200000006ffULL, 0x00000066093a7223ULL, 0x000fe2000001003aULL,
0x0000001016167819ULL, 0x000fe200000006ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x000000105a5a7819ULL, 0x000fe200000006ffULL, 0x0001000014147824ULL, 0x000fc400078e00ffULL,
0x0000006651387223ULL, 0x080fe20000010038ULL, 0x000100000b087824ULL, 0x000fe400078e00ffULL,
0x0000006654377223ULL, 0x080fe20000010037ULL, 0x000100005b5b7824ULL, 0x000fe400078e00ffULL,
0x0000006655447223ULL, 0x080fe20000010044ULL, 0x000100005c097824ULL, 0x000fe400078e00ffULL,
0x0000006656437223ULL, 0x000fe20000010043ULL, 0x0001000013137824ULL, 0x000fc400078e00ffULL,
0x000000660c417223ULL, 0x080fe20000010041ULL, 0x0001000061617824ULL, 0x000fe400078e00ffULL,
0x00000066083d7223ULL, 0x080fe2000001003dULL, 0x0001000063637824ULL, 0x000fe400078e00ffULL,
0x000000660d467223ULL, 0x080fe20000010046ULL, 0x00000066573c7223ULL, 0x080fe2000001003cULL,
0x0000006659427223ULL, 0x080fe20000010042ULL, 0x00000066583b7223ULL, 0x080fe2000001003bULL,
0x000000660f407223ULL, 0x000fe20000010040ULL, 0x0000006510357223ULL, 0x088fe20000010035ULL,
0x000000655a2f7223ULL, 0x080fe2000001002fULL, 0x00000065112e7223ULL, 0x080fe2000001002eULL,
0x000000655b347223ULL, 0x080fe20000010034ULL, 0x0000006512337223ULL, 0x080fe20000010033ULL,
0x0000006509327223ULL, 0x080fe20000010032ULL, 0x00000065602d7223ULL, 0x080fe2000001002dULL,
0x000000655d2c7223ULL, 0x080fe2000001002cULL, 0x00000065142b7223ULL, 0x080fe2000001002bULL,
0x00000065132a7223ULL, 0x080fe2000001002aULL, 0x0000006562317223ULL, 0x080fe20000010031ULL,
0x000000655f307223ULL, 0x080fe20000010030ULL, 0x0000006516297223ULL, 0x080fe20000010029ULL,
0x0000006561287223ULL, 0x080fe20000010028ULL, 0x0000006564277223ULL, 0x080fe20000010027ULL,
0x0000006563267223ULL, 0x000fe20000010026ULL, 0xfffffff4009c8947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe40000011600ULL,
0x000049801e007810ULL, 0x000fe40007ffe0ffULL, 0x00000070040b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c080a7812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x000000804f1e7824ULL, 0x000fe400078e021eULL,
0x0000001004087824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011604ULL,
0x0000007008097812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000001e041e7210ULL, 0x000fca0007ffe009ULL, 0x004980471e007388ULL, 0x0003e40000000800ULL,
0x000000000a007210ULL, 0x000fe20007ffe00bULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000047984ULL, 0x000ea80000000800ULL, 0x0000800000097984ULL, 0x000ee20000000800ULL,
0x00000004ff047221ULL, 0x004fc80000010000ULL, 0x0000000904047221ULL, 0x008fc80000010000ULL,
0x0180000004087836ULL, 0x000fca0000000000ULL, 0x7f80000008087812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0800780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff537224ULL, 0x000fe200078e0004ULL,
0x0000aae000087802ULL, 0x000fce0000000f00ULL, 0x0000009000207944ULL, 0x012fea0003c00000ULL,
0x0000000400007202ULL, 0x00cfe20000000f00ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000400097308ULL, 0x000ea40000001000ULL, 0xbf80000004007423ULL, 0x004fc80000000009ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000009007223ULL, 0x000fce0000000009ULL,
0x0000000000047919ULL, 0x000ea40000000000ULL, 0x00000002ff097819ULL, 0x104fe20000011604ULL,
0x0000000145457824ULL, 0x100fe200078e0204ULL, 0x00000008040d7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff197819ULL, 0x000fe20000011604ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0900097589ULL, 0x000ea200000e0000ULL, 0xfffffff8ff147812ULL, 0x000fc400078ee204ULL,
0x0000001a45457211ULL, 0x000fe200078e20ffULL, 0x00001f0d00107589ULL, 0x00076400000e0000ULL,
0x0000000814177824ULL, 0x040fe400078e00ffULL, 0x00000008141b7824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003909087220ULL, 0x044fe20000410000ULL,
0x00000038090b7220ULL, 0x040fe20000410000ULL, 0x0000003709377220ULL, 0x040fe20000410000ULL,
0x0000003609367220ULL, 0x040fe20000410000ULL, 0x00000044090a7220ULL, 0x040fe20000410000ULL,
0x0000003f093f7220ULL, 0x040fe20000410000ULL, 0x0000004309437220ULL, 0x040fe20000410000ULL,
0x0000003e093e7220ULL, 0x040fe20000410000ULL, 0x00000041090c7220ULL, 0x040fe20000410000ULL,
0x0000003d093d7220ULL, 0x040fe20000410000ULL, 0x00000046090d7220ULL, 0x048fe20000410000ULL,
0x0000003c093c7220ULL, 0x040fe20000410000ULL, 0x00000042090e7220ULL, 0x040fe20000410000ULL,
0x0000003b093b7220ULL, 0x040fe20000410000ULL, 0x00000040090f7220ULL, 0x040fe20000410000ULL,
0x0000003a093a7220ULL, 0x000fe20000410000ULL, 0x0000000319097812ULL, 0x000fe200078ec0ffULL,
0x0000003510357220ULL, 0x062fe20000410000ULL, 0x0000002f10007220ULL, 0x040fe20000410000ULL,
0x0000002e10117220ULL, 0x040fe20000410000ULL, 0x0000003410347220ULL, 0x040fe20000410000ULL,
0x0000003310127220ULL, 0x040fe20000410000ULL, 0x0000003210137220ULL, 0x040fe20000410000ULL,
0x0000002d102d7220ULL, 0x040fe20000410000ULL, 0x0000002c102c7220ULL, 0x040fe20000410000ULL,
0x0000002b102b7220ULL, 0x040fe20000410000ULL, 0x0000002a102a7220ULL, 0x040fe20000410000ULL,
0x0000003110317220ULL, 0x040fe20000410000ULL, 0x0000003010307220ULL, 0x040fe20000410000ULL,
0x0000002910297220ULL, 0x040fe20000410000ULL, 0x0000002810287220ULL, 0x040fe20000410000ULL,
0x0000002710277220ULL, 0x040fe20000410000ULL, 0x0000002610267220ULL, 0x000fe20000410000ULL,
0x0000000814107836ULL, 0x000fe20000000000ULL, 0x000000080b08723eULL, 0x000fe200000010ffULL,
0x0000000109147824ULL, 0x000fe200078e0214ULL, 0x0000000a3f0a723eULL, 0x000fe200000010ffULL,
0x0000000810187824ULL, 0x040fe200078e00ffULL, 0x0000001009157210ULL, 0x000fe20007ffe0ffULL,
0x00000008101d7824ULL, 0x000fe200078e00ffULL, 0xfffffff817097812ULL, 0x000fe200078ee214ULL,
0x0000000414107836ULL, 0x000fe20000000000ULL, 0xfffffff818177812ULL, 0x000fe200078ee215ULL,
0x0000000c14167836ULL, 0x000fe20000000000ULL, 0x0000000209187211ULL, 0x000fc400078e20ffULL,
0xfffffff81b157812ULL, 0x000fe200078ee210ULL, 0x00000010172e7824ULL, 0x100fe200078e0202ULL,
0xfffffff81d1d7812ULL, 0x000fe400078ee216ULL, 0x000000373609723eULL, 0x000fe200000010ffULL,
0x00000010151b7824ULL, 0x100fe200078e0202ULL, 0x000000433e0b723eULL, 0x000fe200000010ffULL,
0x000000101d027824ULL, 0x000fe200078e0202ULL, 0x0000000c3d0c723eULL, 0x000fe400000010ffULL,
0x0000000d3c0d723eULL, 0x000fe200000010ffULL, 0x0000000818007844ULL, 0x000fe20000000200ULL,
0x0000000e3b0e723eULL, 0x000fc400000010ffULL, 0x0000000f3a0f723eULL, 0x000fe400000010ffULL,
0x000000121312723eULL, 0x000fe400000010ffULL, 0x000000350010723eULL, 0x000fe200000010ffULL,
0x0000000c1b007844ULL, 0x000fe20000000200ULL, 0x000000113411723eULL, 0x000fe200000010ffULL,
0x000000ff00007306ULL, 0x000e620000202400ULL, 0x0000002d2c13723eULL, 0x000fe400000010ffULL,
0x0000002b2a14723eULL, 0x000fc400000010ffULL, 0x000000313015723eULL, 0x000fe200000010ffULL,
0x000000102e007844ULL, 0x000fe20000000200ULL, 0x000000292816723eULL, 0x000fe400000010ffULL,
0x000000272617723eULL, 0x000fca00000010ffULL, 0x0000001402007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000451c7984ULL, 0x000e680000000c00ULL,
0x0004000045247984ULL, 0x000ea80000000c00ULL, 0x0008000045207984ULL, 0x000ee80000000c00ULL,
0x000c000045287984ULL, 0x000f620000000c00ULL, 0x0000001f001f7230ULL, 0x002fc40000200800ULL,
0x0000001e001e7230ULL, 0x040fe40000200800ULL, 0x0000001d001d7230ULL, 0x040fe40000200800ULL,
0x0000001c001c7230ULL, 0x040fe40000200800ULL, 0x0000002700277230ULL, 0x044fe40000200800ULL,
0x0000002600267230ULL, 0x040fe40000200800ULL, 0x0000002500257230ULL, 0x000fc40000200800ULL,
0x0000002400247230ULL, 0x000fe40000200800ULL, 0x000000231f1f7230ULL, 0x008fe40000200000ULL,
0x000000221e1e7230ULL, 0x000fe40000200000ULL, 0x000000211d1d7230ULL, 0x000fe40000200000ULL,
0x000000201c1c7230ULL, 0x000fe40000200000ULL, 0x0000002b27277230ULL, 0x020fc40000200000ULL,
0x0000002a26267230ULL, 0x000fe20000200000ULL, 0x0000001c45007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000200000ULL, 0x0000002824247230ULL, 0x000fca0000200000ULL,
0x0004002445007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff4f00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000061900720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000860000087ab9ULL, 0x000fe20000000800ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x0000000800027d06ULL, 0x000ea20008209000ULL, 0x000000015e007824ULL, 0x000fe200078e0219ULL,
0x00000008ff177c12ULL, 0x000fe2000f8e33ffULL, 0x0000000119197824ULL, 0x000fe200078e0204ULL,
0x0000850000097ab9ULL, 0x000fe20000000800ULL, 0x00008a0000047ab9ULL, 0x000fc60000000a00ULL,
0x0000000719197812ULL, 0x000fc800078ec0ffULL, 0x0ffffff819197812ULL, 0x000fe200078ef804ULL,
0x0000000200027308ULL, 0x004ea40000001000ULL, 0x0ffffffe020a7836ULL, 0x004fcc0000000000ULL,
0x0000000a00097305ULL, 0x0004e4000021f000ULL, 0x00000020040a7836ULL, 0x004fca0000000000ULL,
0x00000003ff117819ULL, 0x000fe2000001160aULL, 0x000000ffff0b7224ULL, 0x008fc800078e0a09ULL,
0x000000080b0b7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000b09157227ULL, 0x000fcc00078e0008ULL,
0x0000000015087227ULL, 0x000fca00078e00ffULL, 0x000000ff08097210ULL, 0x000fca0007ffe1ffULL,
0x0000000809027c24ULL, 0x000fca000f8e0200ULL, 0x0000000802007c0cULL, 0x000fda000bf06070ULL,
0x8000000802020c36ULL, 0x000fe40008000000ULL, 0x0000000108080836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000802007c0cULL, 0x000fe2000bf26070ULL,
0x0000001019027824ULL, 0x000fca00078e021aULL, 0x00000000020c7984ULL, 0x0004ee0000000c00ULL,
0x0000000108081810ULL, 0x000fe40007ffe0ffULL, 0x0000000704027812ULL, 0x004fe400078ec0ffULL,
0x0000000817087207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL,
0x0000000908097c24ULL, 0x000fe4000f8e0203ULL, 0x000000080b007c24ULL, 0x000fe4000f8e0200ULL,
0x00000008070b7824ULL, 0x000fe400078e0202ULL, 0x0000000809007c24ULL, 0x000fca000f8e0200ULL,
0x0000000005007210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000400087c11ULL, 0x000fc8000f8240ffULL, 0x0000000500097c11ULL, 0x000fe400088f4409ULL,
0x000000061100720cULL, 0x000fe20003f26070ULL, 0x000000100b087825ULL, 0x000fca00078e0008ULL,
0x0000000c08007986ULL, 0x0085ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000115e007210ULL, 0x000fe20007ffe0ffULL, 0x000000010a117824ULL, 0x000fc800078e0211ULL,
0x0000000015027227ULL, 0x000fe200078e00ffULL, 0x0000000711117812ULL, 0x000fc600078ec0ffULL,
0x000000ffff097224ULL, 0x004fe200078e0a02ULL, 0x0ffffff811117812ULL, 0x000fc600078ef80aULL,
0x0000000809087c24ULL, 0x000fe2000f8e0200ULL, 0x0000001a11117211ULL, 0x000fc800078e20ffULL,
0x0000000808007c0cULL, 0x000fe4000bf26070ULL, 0x0000000011107984ULL, 0x000eb60000000c00ULL,
0x8000000808081c36ULL, 0x000fc40008000000ULL, 0x0000000102021836ULL, 0x000fc60000000000ULL,
0x0000000808007c0cULL, 0x000fda000bf46070ULL, 0x0000000102022836ULL, 0x000fca0000000000ULL,
0x0000000217027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000000902097c24ULL, 0x000fe4000f8e0203ULL, 0x000000080b007c24ULL, 0x000fc8000f8e0200ULL,
0x0000000809007c24ULL, 0x000fca000f8e0200ULL, 0x0000000005027210ULL, 0x000fe40007f3e0ffULL,
0x000000070a007812ULL, 0x000fe200078ec0ffULL, 0x00000040040a7836ULL, 0x000fe40000000000ULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x0000000402087c11ULL, 0x040fe4000f8240ffULL,
0x00000003ff0d7819ULL, 0x000fe4000001160aULL, 0x0000000502097c11ULL, 0x000fc400088f4409ULL,
0x000000060d00720cULL, 0x000fe40003f26070ULL, 0x00000000070b7211ULL, 0x000fca00078e18ffULL,
0x000000100b087825ULL, 0x000fca00078e0008ULL, 0x0000001008007986ULL, 0x0045e2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x000000015e007824ULL, 0x100fe200078e020dULL,
0x0000006004047810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0d7824ULL, 0x000fe400078e020dULL,
0x0000000015027227ULL, 0x000fe200078e00ffULL, 0x00000003ff117819ULL, 0x004fe40000011604ULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe400078e0a02ULL,
0x000000015e5e7824ULL, 0x000fe200078e0211ULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef80aULL,
0x0000000809087c24ULL, 0x000fc8000f8e0200ULL, 0x000000100d0d7824ULL, 0x000fe200078e021aULL,
0x0000000808007c0cULL, 0x000fca000bf26070ULL, 0x000000000d0c7984ULL, 0x000eb00000000c00ULL,
0x8000000808081c36ULL, 0x000fe20008000000ULL, 0x0000000102021810ULL, 0x000fc80007ffe0ffULL,
0x0000000808007c0cULL, 0x000fda000bf46070ULL, 0x0000000102022836ULL, 0x000fca0000000000ULL,
0x0000000217027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000000902097c24ULL, 0x000fe4000f8e0203ULL, 0x000000080b007c24ULL, 0x000fc8000f8e0200ULL,
0x0000000809007c24ULL, 0x000fca000f8e0200ULL, 0x0000000005027210ULL, 0x000fe40007f3e0ffULL,
0x000000070a007812ULL, 0x000fc600078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000402087c11ULL, 0x000fe2000f8240ffULL, 0x00000008070b7824ULL, 0x000fc600078e0200ULL,
0x0000000502097c11ULL, 0x000fe400088f4409ULL, 0x000000061100720cULL, 0x000fe20003f26070ULL,
0x000000100b087825ULL, 0x000fca00078e0008ULL, 0x0000000c08007986ULL, 0x0045ee000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000005e15007227ULL, 0x000fe200078e00ffULL,
0x0000001104117210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff097224ULL, 0x004fe200078e0a00ULL,
0x0000000711117812ULL, 0x000fc600078ec0ffULL, 0x0000000809027c24ULL, 0x000fe2000f8e025eULL,
0xfffffff811117812ULL, 0x000fc800078ef804ULL, 0x0000000802007c0cULL, 0x000fe2000bf26070ULL,
0x0000001011117824ULL, 0x000fcc00078e021aULL, 0x0000000011107984ULL, 0x000e6c0000000c00ULL,
0x8000000802021c36ULL, 0x000fe40008000000ULL, 0x0000000100001836ULL, 0x000fc60000000000ULL,
0x0000000802007c0cULL, 0x000fda000bf46070ULL, 0x0000000100002836ULL, 0x000fca0000000000ULL,
0x0000000017007207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a00ULL,
0x0000000900037c24ULL, 0x000fe2000f8e0203ULL, 0x0000000704007812ULL, 0x000fe200078ec0ffULL,
0x00000008095e7c24ULL, 0x000fc8000f8e025eULL, 0x00000008035e7c24ULL, 0x000fe4000f8e025eULL,
0x0000000807077824ULL, 0x000fc600078e0200ULL, 0x0000005e055e7210ULL, 0x000fc80007f1e0ffULL,
0x000000ffff037210ULL, 0x000fe400007fe4ffULL, 0x000000045e027c11ULL, 0x000fc8000f8040ffULL,
0x000000055e037c11ULL, 0x000fc600080f4403ULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000001002007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff597819ULL, 0x000fe2000001165dULL, 0x00000001ff077424ULL, 0x000fe200078e00ffULL,
0xffffffff00587802ULL, 0x000fe20000000f00ULL, 0x00009000ff107b82ULL, 0x000e620000000a00ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x0000000260597824ULL, 0x000fca00078e0259ULL,
0x0000005b5900720cULL, 0x000fda0003f06070ULL, 0x00009600ff058b82ULL, 0x000ea20000000800ULL,
0x0000000208068824ULL, 0x000fce00078e00ffULL, 0x00009200ff0a8b82ULL, 0x000ee20000000a00ULL,
0x0000000506058224ULL, 0x004fe400078e0259ULL, 0x01b60007020679a7ULL, 0x0004a4000850003fULL,
0x00000004050a8825ULL, 0x008fca00078e000aULL, 0x000000060a588981ULL, 0x000ee2000c1e1900ULL,
0x0000000160057836ULL, 0x000fe20000000000ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x000000800e0e7824ULL, 0x000fe400078e00ffULL, 0x000000405d0f7824ULL, 0x000fe200078e00ffULL,
0x0000005a0500720cULL, 0x000fe20003f06070ULL, 0x0000008003037824ULL, 0x000fe200078e00ffULL,
0x000000053f047899ULL, 0x000fe40008011604ULL, 0x0000000f600d7211ULL, 0x000fe200078e40ffULL,
0x0000000e58057224ULL, 0x008fc800078e02ffULL, 0x00000100050a7825ULL, 0x002fe200078e0010ULL,
0x0000004003057812ULL, 0x000fc600078ef80dULL, 0x0000000c00208947ULL, 0x004fea0003800000ULL,
0x00000003ff237819ULL, 0x100fe40000011604ULL, 0x0000000d5c227248ULL, 0x000fe40007fe0000ULL,
0x0000001c23337810ULL, 0x000fe20007ffe0ffULL, 0x0000000823157836ULL, 0x000fe40000000000ULL,
0x0000000423117836ULL, 0x000fe40000000000ULL, 0x0000000122227824ULL, 0x000fe400078e0a0dULL,
0x0000000105107824ULL, 0x000fe200078e0223ULL, 0x00000004110d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000115137824ULL, 0x000fe200078e0204ULL, 0x000000221100720cULL, 0x000fe20003fa6070ULL,
0x00000008152c7824ULL, 0x000fc400078e00ffULL, 0x0000000105127824ULL, 0x000fe400078e0211ULL,
0x00000008112a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee213ULL,
0x0000010010107825ULL, 0x000fc600078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20dULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000007010177812ULL, 0x000fe400078ef809ULL,
0x0000000c230d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105107824ULL, 0x000fe200078e0215ULL,
0x0000007012197812ULL, 0x000fe200078ef809ULL, 0x00000010231b7836ULL, 0x000fe20000000000ULL,
0x000000170a167210ULL, 0x000fe20007f1e0ffULL, 0x000000010d147824ULL, 0x040fe200078e0204ULL,
0x000000190a187210ULL, 0x000fe20007f3e0ffULL, 0x000000080d1d7824ULL, 0x000fe200078e00ffULL,
0x0000000d05127210ULL, 0x000fe20007ffe0ffULL, 0x000000010b177824ULL, 0x000fe200000e0611ULL,
0x000000031b1f7819ULL, 0x000fe200000006ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffff81d2e7812ULL, 0x000fc400078ee214ULL, 0x000000220d00720cULL, 0x080fe20003f46070ULL,
0x000000011b267824ULL, 0x000fe200078e0204ULL, 0x0000007010217812ULL, 0x000fe200078ef809ULL,
0x000000010b197824ULL, 0x000fe200008e0613ULL, 0x000000221500720cULL, 0x080fe20003f26070ULL,
0x0000000105147824ULL, 0x000fe200078e021bULL, 0xfffffff81f267812ULL, 0x000fe200078ee226ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000210a207210ULL, 0x000fe40007f7e0ffULL,
0x000000221b00720cULL, 0x000fe20003f06070ULL, 0x0000001423277836ULL, 0x000fe20000000000ULL,
0x00000070121f7812ULL, 0x000fe200078ef809ULL, 0x0000010014147825ULL, 0x000fc600078e00ffULL,
0x0000001f0a1e7210ULL, 0x000fe20007f9e0ffULL, 0x0000001823297836ULL, 0x000fe20000000000ULL,
0x00000070140d7812ULL, 0x000fe200078ef809ULL, 0x00000001051a7824ULL, 0x000fe200078e0227ULL,
0x0000000427287210ULL, 0x000fe20007ffe0ffULL, 0x000000010b217824ULL, 0x040fe200018e0611ULL,
0x00000029051c7210ULL, 0x000fe20007ffe0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000d0a147210ULL, 0x000fe40007f7e0ffULL, 0x0000000429317210ULL, 0x000fe20007ffe0ffULL,
0x000000010b1f7824ULL, 0x000fe200020e0613ULL, 0x000000701a137812ULL, 0x000fe200078ef809ULL,
0x000001001c1c7825ULL, 0x000fc800078e00ffULL, 0x000000010b157824ULL, 0x000fe200018e0615ULL,
0x000000130a127210ULL, 0x000fe20007f7e0ffULL, 0x00000001051a7824ULL, 0x000fe200078e0233ULL,
0x000000701c117812ULL, 0x000fe200078ef809ULL, 0x00000001231c7824ULL, 0x000fe400078e0204ULL,
0x000000010b137824ULL, 0x000fe200018e061bULL, 0x000000110a107210ULL, 0x000fe20007f9e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x000000071c257812ULL, 0x000fe400078ec0ffULL,
0x0000001d0b117210ULL, 0x000fe200027fe4ffULL, 0x00000020232b7836ULL, 0x000fe20000000000ULL,
0x000000701a1d7812ULL, 0x000fe200078ef809ULL, 0x000040005d0d7824ULL, 0x000fe200078e0202ULL,
0x000000222700720cULL, 0x080fe20003f66070ULL, 0x00000001051c7824ULL, 0x000fe200078e022bULL,
0x0000001d0a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x000000222300720cULL, 0x000fe20003f86070ULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0ffffff825247812ULL, 0x000fc400078ef804ULL, 0xfffffff827307812ULL, 0x000fe200078ee228ULL,
0x000010000d0d7836ULL, 0x000fe20000000000ULL, 0x000000701c257812ULL, 0x000fe200078ef809ULL,
0x00000024232d7836ULL, 0x000fe20000000000ULL, 0x0000001b0b1b7210ULL, 0x000fe200037fe4ffULL,
0x0000001024277824ULL, 0x000fe200078e020dULL, 0x000000250a1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000105247824ULL, 0x000fe400078e022dULL, 0x00000028232f7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016277faeULL, 0x0003e2000e101c46ULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x000000222900720cULL, 0x000fc40003f86070ULL,
0x0000001d0b1d7210ULL, 0x000fe200037fe4ffULL, 0x0000000105287824ULL, 0x000fe400078e022fULL,
0x0000000829327824ULL, 0x000fe200078e00ffULL, 0x0000007024297812ULL, 0x000fe200078ef809ULL,
0x000000102a277824ULL, 0x002fc600078e020dULL, 0x000000290a247210ULL, 0x000fe20007fde0ffULL,
0x0000010028167825ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee231ULL,
0x0000000018277faeULL, 0x0003e2000e901c46ULL, 0x000000223300720cULL, 0x040fe20003fa6070ULL,
0x0000000133287824ULL, 0x140fe200078e0204ULL, 0x0000007016297812ULL, 0x000fe200078ef809ULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000002c23317810ULL, 0x000fe20007ffe0ffULL,
0x000000010b257824ULL, 0x000fe200030e0625ULL, 0x000000290a167210ULL, 0x000fe20007fde0ffULL,
0x000000102c297824ULL, 0x000fe200078e020dULL, 0xfffffff833347812ULL, 0x000fe200078ee228ULL,
0x000000012b287824ULL, 0x000fc400078e0204ULL, 0x000000082b337824ULL, 0x000fe200078e00ffULL,
0x0000000d2e277211ULL, 0x002fe200078e20ffULL, 0x0000000020297faeULL, 0x0003e2000c901c46ULL,
0x0000000105187824ULL, 0x000fe200078e0231ULL, 0x000000222b00720cULL, 0x080fe20003f26070ULL,
0x000000010b177824ULL, 0x000fe200030e0617ULL, 0xfffffff833287812ULL, 0x000fe200078ee228ULL,
0x000000001e277faeULL, 0x0005e2000d101c46ULL, 0x0000003023337810ULL, 0x000fe20007ffe0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000222d00720cULL, 0x000fc60003f46070ULL,
0x000000012d2a7824ULL, 0x040fe200078e0204ULL, 0x00000070182b7812ULL, 0x000fe200078ef809ULL,
0x0000001026217824ULL, 0x102fe200078e020dULL, 0x000000032d2d7819ULL, 0x000fe200000006ffULL,
0x0000001034297824ULL, 0x100fe200078e020dULL, 0x0000002b0a187210ULL, 0x000fe20007fde0ffULL,
0x00000010301f7824ULL, 0x104fe200078e020dULL, 0x0000000d32277211ULL, 0x000fe200078e20ffULL,
0x0000000014217faeULL, 0x0003e2000c101c46ULL, 0x00000010282b7824ULL, 0x000fe200078e020dULL,
0xfffffff82d2a7812ULL, 0x000fe200078ee22aULL, 0x000000010b197824ULL, 0x000fe200030e0619ULL,
0x00000000121f7faeULL, 0x0005e2000d901c46ULL, 0x000000223300720cULL, 0x000fc40003f66070ULL,
0x000000102a2d7824ULL, 0x000fe200078e020dULL, 0x0000000010277faeULL, 0x0007e2000e101c46ULL,
0x000000223100720cULL, 0x080fe20003f86070ULL, 0x0000000105147824ULL, 0x002fe400078e0233ULL,
0x000000001a297faeULL, 0x0003e2000e901c46ULL, 0x0000003423217836ULL, 0x000fe20000000000ULL,
0x000000222f00720cULL, 0x080fe20003fa6070ULL, 0x00000038231f7836ULL, 0x004fe20000000000ULL,
0x000000001c2b7faeULL, 0x0005e2000c901c46ULL, 0x0000000105127824ULL, 0x000fe200078e0221ULL,
0x0000003c23237810ULL, 0x000fe20007ffe0ffULL, 0x0000010014107825ULL, 0x008fe200078e00ffULL,
0x00000000242d7faeULL, 0x0007e2000d101c46ULL, 0x000000222100720cULL, 0x000fc40003f46070ULL,
0x000000012f147824ULL, 0x140fe200078e0204ULL, 0x0000007010137812ULL, 0x000fe200078ef809ULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x000000221f00720cULL, 0x080fe20003f26070ULL,
0x0000000131157824ULL, 0x140fe200078e0204ULL, 0x000000130a107210ULL, 0x000fe20007fde0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0xfffffff82f1a7812ULL, 0x002fe400078ee214ULL,
0x000000110b117210ULL, 0x000fe200037fe4ffULL, 0x00000008311c7824ULL, 0x004fe200078e00ffULL,
0x00000070121b7812ULL, 0x000fe200078ef809ULL, 0x0000000133127824ULL, 0x140fe200078e0204ULL,
0x0000000333337819ULL, 0x000fe200000006ffULL, 0x00000001051d7824ULL, 0x040fe200078e021fULL,
0x0000001b0a147210ULL, 0x000fe20007fde0ffULL, 0x0000000105057824ULL, 0x000fe200078e0223ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL, 0x00000001211b7824ULL, 0x000fe200078e0204ULL,
0xfffffff8331e7812ULL, 0x000fe200078ee212ULL, 0x000000010b157824ULL, 0x000fe200030e0613ULL,
0x000000222300720cULL, 0x000fe20003f06070ULL, 0x000001001d127825ULL, 0x000fe200078e00ffULL,
0x0000000321207819ULL, 0x000fc600000006ffULL, 0x000000011f1d7824ULL, 0x040fe200078e0204ULL,
0x0000007012217812ULL, 0x000fe200078ef809ULL, 0x000000081f227824ULL, 0x000fe200078e00ffULL,
0x00000004231f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000823247824ULL, 0x008fe200078e00ffULL,
0x000000210a127210ULL, 0x000fe20007fde0ffULL, 0x0000010005047825ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe400078ee21bULL, 0xfffffff824247812ULL, 0x000fe200078ee21fULL,
0x000000010b137824ULL, 0x040fe200030e0613ULL, 0x00000070041f7812ULL, 0x000fe200078ef809ULL,
0x000000101a097824ULL, 0x100fe200078e020dULL, 0xfffffff822227812ULL, 0x000fe200078ee21dULL,
0x000000101e1d7824ULL, 0x100fe200078e020dULL, 0x0000001f0a047210ULL, 0x000fe20007fde0ffULL,
0x00000010201f7824ULL, 0x100fe200078e020dULL, 0x0000000d1c1b7211ULL, 0x080fe200078e20ffULL,
0x0000001022217824ULL, 0x000fe200078e020dULL, 0x0000000d240d7211ULL, 0x000fe200078e20ffULL,
0x000000010b057824ULL, 0x000fe200030e0605ULL, 0x0000000016097faeULL, 0x0003e8000e901c46ULL,
0x00000000181b7faeULL, 0x0003e8000e101c46ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x00000000141f7faeULL, 0x0003e8000d101c46ULL, 0x0000000012217faeULL, 0x0003e8000c901c46ULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x0000000c041a7811ULL, 0x040fe400078fe8ffULL, 0x0000000404167811ULL, 0x040fe400078fe8ffULL,
0x00000010041d7811ULL, 0x000fe200078fe8ffULL, 0x000000011a117824ULL, 0x100fe200078e0204ULL,
0x0000000804187811ULL, 0x000fe200078fe8ffULL, 0x000000081a1c7824ULL, 0x000fe200078e00ffULL,
0x00000018041f7811ULL, 0x000fe200078fe8ffULL, 0x00000001160d7824ULL, 0x140fe200078e0204ULL,
0x000000041d127210ULL, 0x000fe20007ffe0ffULL, 0x0000000816147824ULL, 0x000fe200078e00ffULL,
0xfffffff81c2b7812ULL, 0x000fe200078ee211ULL, 0x000000081d297824ULL, 0x000fe200078e00ffULL,
0x0000002004117811ULL, 0x000fe200078fe8ffULL, 0x00000008182d7824ULL, 0x000fe200078e00ffULL,
0x0000001c04207811ULL, 0x000fe200078fe8ffULL, 0x000000081f257824ULL, 0x000fe200078e00ffULL,
0xfffffff8142f7812ULL, 0x000fe200078ee20dULL, 0x00000008111c7824ULL, 0x000fe200078e00ffULL,
0x0000000418107210ULL, 0x000fe20007ffe0ffULL, 0x0000000120137824ULL, 0x000fe200078e0204ULL,
0x00000014041e7811ULL, 0x000fe200078fe8ffULL, 0x0000000820147824ULL, 0x000fe200078e00ffULL,
0x00000004110d7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff829297812ULL, 0x000fe200078ee212ULL,
0x000000081e277824ULL, 0x000fe200078e00ffULL, 0x000000041f127210ULL, 0x000fe40007ffe0ffULL,
0x0000002c04387811ULL, 0x000fe400078fe8ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL,
0x000000011e107824ULL, 0x000fe200078e0204ULL, 0xfffffff81c337812ULL, 0x000fe200078ee20dULL,
0x0000000838157824ULL, 0x000fe200078e00ffULL, 0x00000028041c7811ULL, 0x000fc400078fe8ffULL,
0xfffffff825257812ULL, 0x000fe200078ee212ULL, 0x0000000138127824ULL, 0x100fe200078e0204ULL,
0xfffffff814217812ULL, 0x000fe200078ee213ULL, 0x000000081c377824ULL, 0x000fe200078e00ffULL,
0x0000003004347811ULL, 0x040fe400078fe8ffULL, 0x0000002404137811ULL, 0x000fe400078fe8ffULL,
0xfffffff827277812ULL, 0x000fe200078ee210ULL, 0x0000000834177824ULL, 0x000fe200078e00ffULL,
0x000000041c107210ULL, 0x000fe20007ffe0ffULL, 0x00000001130d7824ULL, 0x040fe200078e0204ULL,
0xfffffff815247812ULL, 0x000fe200078ee212ULL, 0x0000000813227824ULL, 0x000fe200078e00ffULL,
0x0000000434147210ULL, 0x000fe20007ffe0ffULL, 0x0000000118127824ULL, 0x100fe200078e0205ULL,
0x0000003404157811ULL, 0x000fe200078fe8ffULL, 0x000000011e187824ULL, 0x000fe200078e0205ULL,
0xfffffff837377812ULL, 0x000fe200078ee210ULL, 0x00000001051c7824ULL, 0x040fe200078e021cULL,
0x0000000404107211ULL, 0x040fe200078fe8ffULL, 0x0000000105307824ULL, 0x040fe200078e0215ULL,
0x00000005201e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000105207824ULL, 0x000fe200078e0211ULL,
0xfffffff817267812ULL, 0x000fe200078ee214ULL, 0x0000000115117824ULL, 0x000fe200078e0204ULL,
0xfffffff822357812ULL, 0x000fe200078ee20dULL, 0x0000000105227824ULL, 0x040fe200078e0213ULL,
0x0000003804177811ULL, 0x040fe200078fe8ffULL, 0x0000000105347824ULL, 0x000fe200078e0234ULL,
0x0000003c04197811ULL, 0x000fe200078fe8ffULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x00000005040d7211ULL, 0x000fc400078fe8ffULL, 0x00000007101b7812ULL, 0x000fe200078ec0ffULL,
0x0000000116107824ULL, 0x100fe200078e0205ULL, 0x00000003152a7819ULL, 0x000fe200000006ffULL,
0x000000011d167824ULL, 0x100fe200078e0205ULL, 0x000000051a147210ULL, 0x000fe20007ffe0ffULL,
0x000000011f1a7824ULL, 0x000fe200078e0205ULL, 0x0000003805387210ULL, 0x000fe20007ffe0ffULL,
0x00000001052c7824ULL, 0x000fe200078e0217ULL, 0x0000001905287210ULL, 0x000fe20007ffe0ffULL,
0x0000000117137824ULL, 0x100fe200078e0204ULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef804ULL,
0x0000000119157824ULL, 0x040fe200078e0204ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL,
0x0000000819327824ULL, 0x000fe200078e00ffULL, 0x00000070223f7812ULL, 0x000fe200078ef809ULL,
0x00000008172e7824ULL, 0x000fc400078e00ffULL, 0x000001000d047825ULL, 0x000fe200078e00ffULL,
0xfffffff832157812ULL, 0x000fe400078ee215ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee213ULL,
0x000040005d117824ULL, 0x000fe200078e0202ULL, 0x00000070040d7812ULL, 0x000fe200078ef809ULL,
0x0000010012127825ULL, 0x000fc600078e00ffULL, 0x0000100011327810ULL, 0x000fe20007ffe0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000000d0a047210ULL, 0x000fe40007f1e0ffULL,
0x000000322b2b7211ULL, 0x080fe200078e20ffULL, 0x000000101b317824ULL, 0x100fe200078e0232ULL,
0x00000032210d7211ULL, 0x080fe200078e20ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0232ULL,
0x0000003224247211ULL, 0x000fe200078e20ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0232ULL,
0x0000007012197812ULL, 0x000fe200078ef809ULL, 0x0000001029297824ULL, 0x100fe200078e0232ULL,
0x0000007010177812ULL, 0x000fe200078ef809ULL, 0x0000001027277824ULL, 0x000fc400078e0232ULL,
0x0000001025257824ULL, 0x100fe200078e0232ULL, 0x000000170a107210ULL, 0x000fe20007f3e0ffULL,
0x0000001033337824ULL, 0x100fe400078e0232ULL, 0x0000001035357824ULL, 0x100fe400078e0232ULL,
0x0000001037377824ULL, 0x100fe400078e0232ULL, 0x0000001026267824ULL, 0x100fe400078e0232ULL,
0x000000102a2a7824ULL, 0x000fc400078e0232ULL, 0x000000102e2e7824ULL, 0x000fe200078e0232ULL,
0x0000003215327211ULL, 0x000fe200078e20ffULL, 0x0000010014147825ULL, 0x000fc800078e00ffULL,
0x000000010b057824ULL, 0x000fe200000e0605ULL, 0x000000190a127210ULL, 0x000fe20007f1e0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x00000070141d7812ULL, 0x000fe400078ef809ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004317faeULL, 0x0003e2000b901c46ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x00000070181f7812ULL, 0x000fc600078ef809ULL,
0x000000010b137824ULL, 0x040fe200000e0613ULL, 0x0000001d0a147210ULL, 0x000fe20007f1e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007016217812ULL, 0x000fe400078ef809ULL,
0x000000150b157210ULL, 0x000fe200007fe4ffULL, 0x000000010b117824ULL, 0x040fe200008e0611ULL,
0x0000001f0a187210ULL, 0x000fe20007f1e0ffULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0x000000210a167210ULL, 0x000fe40007f3e0ffULL, 0x000000701a1d7812ULL, 0x000fe200078ef809ULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x000000701e3d7812ULL, 0x000fe200078ef809ULL,
0x00000000102f7faeULL, 0x0003e2000b901c46ULL, 0x0000001d0a1a7210ULL, 0x000fe20007f5e0ffULL,
0x000001001c3a7825ULL, 0x000fe200078e00ffULL, 0x00000070201d7812ULL, 0x000fe200078ef809ULL,
0x00000000122d7faeULL, 0x0003e4000b901c46ULL, 0x000000010b197824ULL, 0x040fe200000e0619ULL,
0x0000003d0a1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b177824ULL, 0x040fe200008e0617ULL,
0x000000703a3d7812ULL, 0x000fe200078ef809ULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x0000001d0a1e7210ULL, 0x000fe20007f3e0ffULL, 0x00000000142b7faeULL, 0x0003e2000b901c46ULL,
0x0000001f0b1d7210ULL, 0x000fe200007fe4ffULL, 0x000000010b1b7824ULL, 0x040fe200010e061bULL,
0x0000003f0a207210ULL, 0x000fe20007f1e0ffULL, 0x000000010b1f7824ULL, 0x040fe200008e0621ULL,
0x0000003d0a227210ULL, 0x000fe20007f5e0ffULL, 0x000001002c3e7825ULL, 0x000fe200078e00ffULL,
0x00000070383d7812ULL, 0x000fe200078ef809ULL, 0x0000000016297faeULL, 0x0003e4000b901c46ULL,
0x000000010b217824ULL, 0x040fe200000e0623ULL, 0x0000003d0a387210ULL, 0x000fe20007f1e0ffULL,
0x000000010b237824ULL, 0x040fe200010e063bULL, 0x000000703e437812ULL, 0x000fe200078ef809ULL,
0x00000100343a7825ULL, 0x000fe200078e00ffULL, 0x000000390b397210ULL, 0x000fe200007fe4ffULL,
0x0000000018277faeULL, 0x0003e2000b901c46ULL, 0x000000430a3e7210ULL, 0x000fe20007f5e0ffULL,
0x00000100303c7825ULL, 0x000fe200078e00ffULL, 0x000000703a477812ULL, 0x000fe200078ef809ULL,
0x000000001a257faeULL, 0x0003e4000b901c46ULL, 0x0000010028407825ULL, 0x000fe200078e00ffULL,
0x000000703c457812ULL, 0x000fe200078ef809ULL, 0x000000001c0d7faeULL, 0x0003e2000b901c46ULL,
0x000000470a3a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b3f7824ULL, 0x040fe200010e063fULL,
0x0000007040097812ULL, 0x000fe200078ef809ULL, 0x000000001e337faeULL, 0x0003e2000b901c46ULL,
0x000000450a3c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010b3b7824ULL, 0x040fe200000e063bULL,
0x000000090a0a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000020357faeULL, 0x0003e4000b901c46ULL,
0x000000010b3d7824ULL, 0x000fe200008e063dULL, 0x000000410b0b7210ULL, 0x000fe20001ffe4ffULL,
0x0000000022377faeULL, 0x0003e8000b901c46ULL, 0x0000000038247faeULL, 0x0003e8000b901c46ULL,
0x000000003a267faeULL, 0x0003e8000b901c46ULL, 0x000000003c2a7faeULL, 0x0003e8000b901c46ULL,
0x000000003e2e7faeULL, 0x0003e8000b901c46ULL, 0x000000000a327faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000a7805ULL, 0x002fe20000015200ULL,
0x01b60007020075a7ULL, 0x000ea2000800017fULL, 0x000000015c047824ULL, 0x000fe400078e0a5fULL,
0x000000040c057c24ULL, 0x000fc6000f8e02ffULL, 0x00000008ff047819ULL, 0x000fe20000011604ULL,
0x00008e00ff747b82ULL, 0x000ee40000000a00ULL, 0x0000000405747825ULL, 0x008fe200078e0074ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff097224ULL, 0x000fce00078e00ffULL,
0x000000100900780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140dULL,
0x0000000c05057211ULL, 0x000fc800078110ffULL, 0x0000000dff0c7210ULL, 0x000fc800007fe4ffULL,
0x0000000205057819ULL, 0x000fc8000000120cULL, 0x000000050000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000109097836ULL, 0x000fce0000000000ULL,
0x01b60007020075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000005a6000720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009600ff077b82ULL, 0x000e620000000800ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000095f097810ULL, 0x000fe20007ffe0ffULL, 0x000000205d0a7824ULL, 0x140fe200078e0202ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0x0000000708067224ULL, 0x002fe400078e02ffULL,
0x000000085d077824ULL, 0x000fe400078e0202ULL, 0xffffffff5f087836ULL, 0x000fce0000000000ULL,
0x00009000ff767b82ULL, 0x000e620000000a00ULL, 0x00000001600d7836ULL, 0x000fe40000000000ULL,
0x00000100600b7824ULL, 0x004fc600078e020fULL, 0x0000005a0d00720cULL, 0x000fe20003f06070ULL,
0x000000580e0d7224ULL, 0x000fe200078e02ffULL, 0x000000400b127812ULL, 0x000fc800078ec0ffULL,
0x0000001203127210ULL, 0x000fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x002fcc00078e0076ULL,
0x0000000800f08947ULL, 0x004fea0003800000ULL, 0x00000003ff247819ULL, 0x104fe20000011605ULL,
0x0000001005727824ULL, 0x000fe200078e00ffULL, 0x0000000b5c167248ULL, 0x000fe20007fe0000ULL,
0x000040005d707824ULL, 0x000fe200078e0202ULL, 0x0000001224157210ULL, 0x000fe20007ffe0ffULL,
0x0000000424187836ULL, 0x000fe20000000000ULL, 0x0000007072727812ULL, 0x000fe200078ec0ffULL,
0x00000008241a7836ULL, 0x000fe20000000000ULL, 0x0ffffff805717812ULL, 0x000fe200078ec0ffULL,
0x0000000818137824ULL, 0x000fe200078e00ffULL, 0x0000000518107210ULL, 0x000fe20007ffe0ffULL,
0x0000000c241c7836ULL, 0x000fe20000000000ULL, 0x000000121a197210ULL, 0x000fe20007ffe0ffULL,
0x00000010241e7836ULL, 0x000fe20000000000ULL, 0xfffffff813287812ULL, 0x000fe200078ee210ULL,
0x000000011a117824ULL, 0x040fe200078e0205ULL, 0x000000051c137210ULL, 0x000fe20007ffe0ffULL,
0x000000081a2a7824ULL, 0x000fe200078e00ffULL, 0x0000008072107812ULL, 0x000fe200078efcffULL,
0x000000081c2c7824ULL, 0x000fc400078e00ffULL, 0x000000011e177824ULL, 0x040fe200078e0205ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee211ULL, 0x000000081e2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee213ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x000000160b137210ULL, 0x000fe20007ffe1ffULL, 0x000000011c1d7824ULL, 0x100fe200078e0212ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee217ULL, 0x0000000118177824ULL, 0x040fe200078e0212ULL,
0x000000131800720cULL, 0x080fe20003f86070ULL, 0x0000010015147825ULL, 0x000fe200078e0010ULL,
0x000000131a00720cULL, 0x000fc40003f26070ULL, 0x000000131c00720cULL, 0x000fe20003f46070ULL,
0x0000010017167825ULL, 0x000fe200078e0010ULL, 0x000000140c147210ULL, 0x000fc60007f1e0ffULL,
0x0000010019187825ULL, 0x000fe200078e0010ULL, 0x000000160c207210ULL, 0x000fc60007f7e0ffULL,
0x000000011e237824ULL, 0x000fe200078e0212ULL, 0x000000180c1a7210ULL, 0x000fe20007fbe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0010ULL, 0x000000170d217210ULL, 0x000fc60001ffe4ffULL,
0x0000010023227825ULL, 0x000fc800078e0010ULL, 0x000000010d157824ULL, 0x040fe200000e0615ULL,
0x000000131e00720cULL, 0x080fe20003f06070ULL, 0x0000001424307836ULL, 0x000fe20000000000ULL,
0x0000001c0c1e7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d1b7824ULL, 0x040fe200028e0619ULL,
0x000000220c167210ULL, 0x000fe20007fbe0ffULL, 0x0000000130277824ULL, 0x040fe200078e0212ULL,
0x0000000524227210ULL, 0x000fe20007ffe0ffULL, 0x0000001824327836ULL, 0x000fe20000000000ULL,
0x000000230d177210ULL, 0x000fe20002ffe4ffULL, 0x000000010d1f7824ULL, 0x000fe200018e061dULL,
0x000000133000720cULL, 0x080fe20003f66070ULL, 0x0000010027267825ULL, 0x000fe200078e0010ULL,
0x000000132400720cULL, 0x000fc40003fa6070ULL, 0x0000000771227812ULL, 0x000fe200078ef822ULL,
0x0000000130237824ULL, 0x040fe200078e0205ULL, 0x000000260c187210ULL, 0x000fe20007fde0ffULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x00000003322d7819ULL, 0x040fe200000006ffULL,
0x00000001321d7824ULL, 0x000fe400078e0212ULL, 0x0000001c24347836ULL, 0x000fe20000000000ULL,
0xfffffff830307812ULL, 0x000fe200078ee223ULL, 0x000001001d1c7825ULL, 0x000fc800078e0010ULL,
0x0000300070617836ULL, 0x000fe40000000000ULL, 0x0000000134237824ULL, 0x000fe400078e0212ULL,
0x0000002024367836ULL, 0x000fe20000000000ULL, 0x0000006128297211ULL, 0x000fe200078e20ffULL,
0x000000010d197824ULL, 0x000fe200030e0627ULL, 0x0000001c0c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000001022257824ULL, 0x000fe400078e0261ULL, 0x0000010023227825ULL, 0x000fe200078e0010ULL,
0x0000001d0d1d7210ULL, 0x000fc400037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014257faeULL, 0x0003e2000e901c46ULL, 0x0000000136277824ULL, 0x000fe200078e0212ULL,
0x000000220c227210ULL, 0x000fe20007fde0ffULL, 0x00000001342b7824ULL, 0x040fe200078e0205ULL,
0x0000000020297faeULL, 0x0005e2000e101c46ULL, 0x0000010027267825ULL, 0x000fe200078e0010ULL,
0x000000133400720cULL, 0x080fe40003f86070ULL, 0x000000133200720cULL, 0x040fe20003fa6070ULL,
0x000000010d237824ULL, 0x040fe400030e0623ULL, 0x0000000132287824ULL, 0x100fe200078e0205ULL,
0x000000612a257211ULL, 0x002fe200078e20ffULL, 0x0000000834347824ULL, 0x000fe200078e00ffULL,
0x000000260c147210ULL, 0x000fe20007fde0ffULL, 0x00000024242a7836ULL, 0x000fe20000000000ULL,
0xfffffff82d287812ULL, 0x000fe200078ee228ULL, 0x000000001a257faeULL, 0x0003e2000c901c46ULL,
0x000000133600720cULL, 0x040fe20003f26070ULL, 0x0000000136297824ULL, 0x044fe200078e0205ULL,
0xfffffff834267812ULL, 0x000fe200078ee22bULL, 0x0000000836367824ULL, 0x000fe200078e00ffULL,
0x000000122a217210ULL, 0x000fe20007ffe0ffULL, 0x000000010d157824ULL, 0x000fc400030e0627ULL,
0x000000102c277824ULL, 0x000fe200078e0261ULL, 0x00000038242c7810ULL, 0x000fe20007ffe0ffULL,
0x0000010021207825ULL, 0x000fe200078e0010ULL, 0xfffffff8361a7812ULL, 0x002fe400078ee229ULL,
0x000000001e277faeULL, 0x0003e2000d101c46ULL, 0x000000102e1b7824ULL, 0x000fe200078e0261ULL,
0x0000006128257211ULL, 0x000fe200078e20ffULL, 0x000000012a2b7824ULL, 0x000fe200078e0205ULL,
0x000000200c207210ULL, 0x000fe20007fde0ffULL, 0x000000101a297824ULL, 0x000fe200078e0261ULL,
0x00000028241a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000161b7faeULL, 0x0005e2000c101c46ULL,
0x000000132a00720cULL, 0x040fe20003f46070ULL, 0x000000010d217824ULL, 0x000fe200030e0621ULL,
0x000000032a2a7819ULL, 0x000fe200000006ffULL, 0x0000003024287836ULL, 0x000fc40000000000ULL,
0x00000010301f7824ULL, 0x102fe200078e0261ULL, 0xfffffff82a1e7812ULL, 0x000fe200078ee22bULL,
0x0000001026277824ULL, 0x100fe400078e0261ULL, 0x0000002c24267836ULL, 0x000fe20000000000ULL,
0x00000000181f7faeULL, 0x0003e2000d901c46ULL, 0x000000011a177824ULL, 0x044fe200078e0212ULL,
0x000000031a1b7819ULL, 0x000fe200000006ffULL, 0x000000101e2b7824ULL, 0x000fe200078e0261ULL,
0x000000001c257faeULL, 0x0005e2000e901c46ULL, 0x00000034242a7836ULL, 0x000fe20000000000ULL,
0x000000131a00720cULL, 0x080fe20003fa6070ULL, 0x0000003c24247836ULL, 0x000fe20000000000ULL,
0x0000000022277faeULL, 0x000fe2000e101c46ULL, 0x000000132600720cULL, 0x000fc40003f86070ULL,
0x000000132800720cULL, 0x080fe20003f66070ULL, 0x0000000014297faeULL, 0x0007e2000c901c46ULL,
0x000000011a187824ULL, 0x002fe200078e0205ULL, 0x000000132c00720cULL, 0x080fe20003f26070ULL,
0x0000000128197824ULL, 0x000fe200078e0212ULL, 0x000000122c1d7210ULL, 0x004fe20007ffe0ffULL,
0x00000000202b7faeULL, 0x0003e2000d101c46ULL, 0xfffffff81b1e7812ULL, 0x000fe200078ee218ULL,
0x0000010019187825ULL, 0x000fe200078e0010ULL, 0x000000132a00720cULL, 0x080fe40003f46070ULL,
0x000000132400720cULL, 0x000fe20003f06070ULL, 0x000000012a1b7824ULL, 0x000fe200078e0212ULL,
0x0000000526137210ULL, 0x000fe20007ffe0ffULL, 0x0000010017147825ULL, 0x008fc800078e0010ULL,
0x0000000126177824ULL, 0x000fe200078e0212ULL, 0x000000140c147210ULL, 0x000fe20007fde0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0010ULL, 0x000000052a217210ULL, 0x002fc60007ffe0ffULL,
0x0000010017167825ULL, 0x000fc800078e0010ULL, 0x000000010d157824ULL, 0x000fe200030e0615ULL,
0x000000160c167210ULL, 0x000fe20007fde0ffULL, 0x0000000826207824ULL, 0x000fe400078e00ffULL,
0x000001001d1c7825ULL, 0x000fc600078e0010ULL, 0xfffffff820207812ULL, 0x000fe200078ee213ULL,
0x000000010d177824ULL, 0x040fe200030e0617ULL, 0x000000180c187210ULL, 0x000fe20007fde0ffULL,
0x0000000124137824ULL, 0x000fe400078e0212ULL, 0x00000001281f7824ULL, 0x040fe400078e0205ULL,
0x000000010d197824ULL, 0x000fe200030e0619ULL, 0x0000001a0c1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000828287824ULL, 0x000fe400078e00ffULL, 0x0000010013107825ULL, 0x000fc800078e0010ULL,
0x000000010d1b7824ULL, 0x040fe200030e061bULL, 0x0000001c0c127210ULL, 0x000fe20007fde0ffULL,
0x000000082a227824ULL, 0x000fe200078e00ffULL, 0xfffffff8281c7812ULL, 0x000fe200078ee21fULL,
0x00000001241f7824ULL, 0x100fe200078e0205ULL, 0x0000001d0d137210ULL, 0x000fe200037fe4ffULL,
0x000000012c1d7824ULL, 0x040fe200078e0205ULL, 0x000000100c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000082c2c7824ULL, 0x000fe200078e00ffULL, 0x0000000324247819ULL, 0x000fe400000006ffULL,
0xfffffff822227812ULL, 0x000fe200078ee221ULL, 0x000000010d0d7824ULL, 0x000fe200030e0611ULL,
0xfffffff82c107812ULL, 0x000fe200078ee21dULL, 0x000000101e1d7824ULL, 0x100fe200078e0261ULL,
0xfffffff8241e7812ULL, 0x000fe200078ee21fULL, 0x0000001020117824ULL, 0x100fe200078e0261ULL,
0x000000611c1f7211ULL, 0x000fe200078e20ffULL, 0x0000001022217824ULL, 0x100fe200078e0261ULL,
0x00000000141d7faeULL, 0x0003e2000e901c46ULL, 0x0000001010237824ULL, 0x000fc400078e0261ULL,
0x000000101e257824ULL, 0x000fe200078e0261ULL, 0x0000000016117faeULL, 0x0003e8000e101c46ULL,
0x00000000181f7faeULL, 0x0003e8000d901c46ULL, 0x000000001a217faeULL, 0x0003e8000d101c46ULL,
0x0000000012237faeULL, 0x0003e8000c901c46ULL, 0x000000000c257faeULL, 0x0003e2000c101c46ULL,
0x0000000800a07947ULL, 0x000fea0003800000ULL, 0x0000000405157811ULL, 0x004fe200078fe8ffULL,
0x000040005d707824ULL, 0x000fe200078e0202ULL, 0x0000000c051f7811ULL, 0x040fe400078fe8ffULL,
0x00000008051b7811ULL, 0x000fe200078fe8ffULL, 0x0000000815117824ULL, 0x000fe200078e00ffULL,
0x00000005154c7210ULL, 0x000fe20007ffe0ffULL, 0x000000081f177824ULL, 0x000fe200078e00ffULL,
0x0000001405257811ULL, 0x000fe200078fe8ffULL, 0x000000011b4a7824ULL, 0x140fe200078e0205ULL,
0x000000051f487210ULL, 0x000fe20007ffe0ffULL, 0x000000081b137824ULL, 0x000fe200078e00ffULL,
0x0000001c052b7811ULL, 0x000fe200078fe8ffULL, 0x0000000115157824ULL, 0x100fe200078e0212ULL,
0x0000001005217811ULL, 0x000fe200078fe8ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0212ULL,
0xfffffff8114c7812ULL, 0x000fe200078ee24cULL, 0x0000000825117824ULL, 0x000fe200078e00ffULL,
0xfffffff817487812ULL, 0x000fe200078ee248ULL, 0x000000082b177824ULL, 0x000fe200078e00ffULL,
0x0000001805277811ULL, 0x000fe200078fe8ffULL, 0x0000000121467824ULL, 0x140fe200078e0205ULL,
0x0000000525447210ULL, 0x000fe20007ffe0ffULL, 0x0000000821197824ULL, 0x000fe200078e00ffULL,
0x00000024052d7811ULL, 0x000fe200078fe8ffULL, 0x00000001273c7824ULL, 0x100fe200078e0205ULL,
0x000000052b3a7210ULL, 0x000fe20007ffe0ffULL, 0x000000011b1b7824ULL, 0x100fe200078e0212ULL,
0x0000002c05237811ULL, 0x000fe200078fe8ffULL, 0x000000012b2b7824ULL, 0x100fe200078e0212ULL,
0xfffffff8134a7812ULL, 0x000fe200078ee24aULL, 0x0000000827137824ULL, 0x000fe200078e00ffULL,
0x00000020052f7811ULL, 0x000fe200078fe8ffULL, 0x0000000125257824ULL, 0x100fe200078e0212ULL,
0xfffffff811447812ULL, 0x000fe200078ee244ULL, 0x000000082d117824ULL, 0x000fe200078e00ffULL,
0xfffffff8173a7812ULL, 0x000fe200078ee23aULL, 0x0000000823177824ULL, 0x000fe200078e00ffULL,
0x0000002805297811ULL, 0x000fe200078fe8ffULL, 0x000000012f387824ULL, 0x100fe200078e0205ULL,
0x000000052d367210ULL, 0x000fe20007ffe0ffULL, 0x0000000127277824ULL, 0x100fe200078e0212ULL,
0x0000000523327210ULL, 0x000fe20007ffe0ffULL, 0x0000000129347824ULL, 0x100fe200078e0205ULL,
0x0000003405107811ULL, 0x000fe200078fe8ffULL, 0x0000000123237824ULL, 0x100fe200078e0212ULL,
0xfffffff819467812ULL, 0x000fe200078ee246ULL, 0x000000082f197824ULL, 0x000fe200078e00ffULL,
0xfffffff8133c7812ULL, 0x000fe200078ee23cULL, 0x0000000829137824ULL, 0x000fe200078e00ffULL,
0x0000000405727819ULL, 0x040fe200000006ffULL, 0x0000000110427824ULL, 0x140fe200078e0205ULL,
0x00000030051d7811ULL, 0x000fe200078fe8ffULL, 0x000000012d2d7824ULL, 0x100fe200078e0212ULL,
0xfffffff811367812ULL, 0x000fe200078ee236ULL, 0x0000000129297824ULL, 0x100fe200078e0212ULL,
0xfffffff817327812ULL, 0x000fe200078ee232ULL, 0x0000000810177824ULL, 0x000fe200078e00ffULL,
0x0000003805117811ULL, 0x000fe200078fe8ffULL, 0x000000011d307824ULL, 0x140fe200078e0205ULL,
0x0000007072727812ULL, 0x000fe200078ec0ffULL, 0x0000300070617836ULL, 0x000fe20000000000ULL,
0xfffffff819387812ULL, 0x000fe200078ee238ULL, 0x000000081d197824ULL, 0x000fe200078e00ffULL,
0xfffffff813347812ULL, 0x000fe200078ee234ULL, 0x0000000111407824ULL, 0x040fe200078e0205ULL,
0x0000001211137210ULL, 0x000fe20007ffe0ffULL, 0x0000000811337824ULL, 0x000fe200078e00ffULL,
0x0000008072167812ULL, 0x000fe200078efcffULL, 0x0000001046377824ULL, 0x100fe200078e0261ULL,
0x0000001205117211ULL, 0x040fe200078fe8ffULL, 0x0000001044397824ULL, 0x100fe200078e0261ULL,
0xfffffff817427812ULL, 0x000fe200078ee242ULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x0000003c05147811ULL, 0x000fe200078fe8ffULL, 0x000000103c3b7824ULL, 0x000fe200078e0261ULL,
0xfffffff819307812ULL, 0x000fe200078ee230ULL, 0x0000000110197824ULL, 0x000fe200078e0212ULL,
0x00000005143e7210ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e0016ULL,
0x0000001221217210ULL, 0x000fc40007ffe0ffULL, 0x000000122f2f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000114317824ULL, 0x040fe200078e0212ULL, 0x000000100c107210ULL, 0x000fe20007f1e0ffULL,
0x0000000814357824ULL, 0x000fe200078e00ffULL, 0x000000121d1d7210ULL, 0x000fe20007ffe0ffULL,
0x0000010015147825ULL, 0x100fe200078e0016ULL, 0x00000005054e7211ULL, 0x040fe400078fe8ffULL,
0x0ffffff805717812ULL, 0x000fe200078ec0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0016ULL,
0x000000140c147210ULL, 0x000fc40007f3e0ffULL, 0x00000007714e7812ULL, 0x000fe200078ef84eULL,
0x0000010021207825ULL, 0x100fe200078e0016ULL, 0x000000150d157210ULL, 0x000fe40000ffe4ffULL,
0xfffffff833407812ULL, 0x000fe200078ee240ULL, 0x000001001b1a7825ULL, 0x000fe200078e0016ULL,
0x000000200c207210ULL, 0x000fe40007f3e0ffULL, 0xfffffff8353e7812ULL, 0x000fe200078ee23eULL,
0x000000010d117824ULL, 0x000fe200000e0611ULL, 0x0000001e0c1e7210ULL, 0x000fe20007f1e0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e0016ULL, 0x0000001a0c1a7210ULL, 0x000fc40007f5e0ffULL,
0x0000006148357211ULL, 0x000fe200078e20ffULL, 0x000001002f2e7825ULL, 0x000fc800078e0016ULL,
0x0000010025247825ULL, 0x000fc800078e0016ULL, 0x000000010d1f7824ULL, 0x040fe200000e061fULL,
0x0000002a0c2a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010d217824ULL, 0x000fe200008e0621ULL,
0x0000002e0c2e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010027267825ULL, 0x000fc800078e0016ULL,
0x0000010023227825ULL, 0x000fe200078e0016ULL, 0x000000260c267210ULL, 0x000fc60007f7e0ffULL,
0x000001001d1c7825ULL, 0x000fc800078e0016ULL, 0x000000010d1b7824ULL, 0x000fe200010e061bULL,
0x000000240c247210ULL, 0x000fe20007f5e0ffULL, 0x000001002d2c7825ULL, 0x000fc600078e0016ULL,
0x000000250d257210ULL, 0x000fe200017fe4ffULL, 0x000000010d2b7824ULL, 0x040fe200000e062bULL,
0x000000220c227210ULL, 0x000fe20007f1e0ffULL, 0x000000010d2f7824ULL, 0x000fe200008e062fULL,
0x0000001c0c1c7210ULL, 0x000fe20007f3e0ffULL, 0x0000010029287825ULL, 0x100fe200078e0016ULL,
0x0000002c0c2c7210ULL, 0x000fe40007f5e0ffULL, 0x0000001d0d1d7210ULL, 0x000fe20000ffe4ffULL,
0x0000010019187825ULL, 0x000fe200078e0016ULL, 0x0000002d0d2d7210ULL, 0x000fc600017fe4ffULL,
0x0000010013127825ULL, 0x000fc800078e0016ULL, 0x0000010031167825ULL, 0x000fe200078e0016ULL,
0x000000120c127210ULL, 0x000fc60007f3e0ffULL, 0x000000010d277824ULL, 0x040fe200018e0627ULL,
0x000000280c287210ULL, 0x000fe20007f7e0ffULL, 0x000000010d237824ULL, 0x040fe200000e0623ULL,
0x000000180c187210ULL, 0x000fe20007f1e0ffULL, 0x000000104e317824ULL, 0x000fe200078e0261ULL,
0x000000160c0c7210ULL, 0x000fe20007f5e0ffULL, 0x000000010d297824ULL, 0x040fe200018e0629ULL,
0x000000130d137210ULL, 0x000fe20000ffe4ffULL, 0x000000010d197824ULL, 0x040fe200000e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc400010e0617ULL, 0x000000104c177824ULL, 0x100fe400078e0261ULL,
0x000000104a337824ULL, 0x000fc600078e0261ULL, 0x0000000014177faeULL, 0x0005e8000b901c46ULL,
0x000000001a337faeULL, 0x0007e2000b901c46ULL, 0x000000613a117211ULL, 0x002fc600078e20ffULL,
0x000000001e357faeULL, 0x0003e2000b901c46ULL, 0x0000001038157824ULL, 0x004fc600078e0261ULL,
0x0000000020377faeULL, 0x0005e2000b901c46ULL, 0x0000001036177824ULL, 0x100fe400078e0261ULL,
0x00000010341b7824ULL, 0x008fe200078e0261ULL, 0x0000000024397faeULL, 0x0007e2000b901c46ULL,
0x00000061321f7211ULL, 0x002fc600078e20ffULL, 0x00000000263b7faeULL, 0x0003e8000b901c46ULL,
0x000000002a117faeULL, 0x0009e2000b901c46ULL, 0x0000001030217824ULL, 0x004fc600078e0261ULL,
0x000000002e157faeULL, 0x0005e2000b901c46ULL, 0x0000001042257824ULL, 0x008fc600078e0261ULL,
0x000000002c177faeULL, 0x0005e2000b901c46ULL, 0x000000613e277211ULL, 0x002fe200078e20ffULL,
0x0000001040117824ULL, 0x010fe400078e0261ULL, 0x00000000281b7faeULL, 0x0005e8000b901c46ULL,
0x00000000221f7faeULL, 0x0005e8000b901c46ULL, 0x000000001c217faeULL, 0x0005e8000b901c46ULL,
0x0000000018257faeULL, 0x0005e8000b901c46ULL, 0x0000000012117faeULL, 0x0005e8000b901c46ULL,
0x000000000c277faeULL, 0x0005e4000b901c46ULL, 0x0000000259597836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff587424ULL, 0x000fc600078e00ffULL,
0x0000005b5900720cULL, 0x000fda0003f06070ULL, 0x00009200ff108b82ULL, 0x006e620000000a00ULL,
0x00000002060d8824ULL, 0x000fe200078e0259ULL, 0x00000004ff637819ULL, 0x000fe40000011605ULL,
0x00000007050c7812ULL, 0x000fe200078ec0ffULL, 0x0000100070707836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000040d108825ULL, 0x002fca00078e0010ULL,
0x0000000610588981ULL, 0x0002a2000c1e1900ULL, 0x00000003ff0d7819ULL, 0x000fe20000011605ULL,
0x00000001006d7824ULL, 0x000fe200078e0260ULL, 0x0000000363137819ULL, 0x000fe400000006ffULL,
0x000000080c627812ULL, 0x000fe400078ef805ULL, 0x000000010d157812ULL, 0x000fe400078ec0ffULL,
0xfffffff8133c7812ULL, 0x000fe200078ee20cULL, 0x0000000163637824ULL, 0x000fe200078e0262ULL,
0x0000000462177819ULL, 0x040fe200000006ffULL, 0x0000001062127824ULL, 0x000fe200078e00ffULL,
0x000000033c107819ULL, 0x002fe200000006ffULL, 0x0000000115537824ULL, 0x040fe200078e023cULL,
0x000000103c527810ULL, 0x000fe20007ffe0ffULL, 0x0000000263147836ULL, 0x000fe20000000000ULL,
0xfffffff012117812ULL, 0x000fe200078ee263ULL, 0x000000203c517836ULL, 0x000fe20000000000ULL,
0xfffffff810737812ULL, 0x000fe200078ee253ULL, 0x00000001156f7824ULL, 0x000fe200078e0252ULL,
0xfffffff017177812ULL, 0x000fe200078ee214ULL, 0x0000001011117824ULL, 0x000fe200078e0202ULL,
0x000000303c507810ULL, 0x000fe20007ffe0ffULL, 0x0000001073187824ULL, 0x000fe200078e0270ULL,
0x00000032536c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000852147824ULL, 0x000fe200078e00ffULL,
0x0000000463287810ULL, 0x000fe20007ffe0ffULL, 0x000000001110783bULL, 0x000fe20000000200ULL,
0x000000083c1d7824ULL, 0x000fe200078e00ffULL, 0x0000000653697810ULL, 0x000fe20007ffe0ffULL,
0x0000000253567836ULL, 0x000fe20000000000ULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0xfffffff8146f7812ULL, 0x000fe200078ee26fULL, 0x0000001017407824ULL, 0x000fc400078e0202ULL,
0x00000001156e7824ULL, 0x000fe200078e0251ULL, 0xfffffff81d567812ULL, 0x000fe200078ee256ULL,
0x0000000851177824ULL, 0x000fe400078e00ffULL, 0x0000000115577824ULL, 0x000fe200078e0250ULL,
0x0000007056387211ULL, 0x080fe200078e20ffULL, 0x0000000850167824ULL, 0x000fe200078e00ffULL,
0xfffffff8176e7812ULL, 0x000fe200078ee26eULL, 0x000000106f147824ULL, 0x000fe200078e0270ULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x0000001253557836ULL, 0x000fe20000000000ULL,
0xfffffff816577812ULL, 0x000fe200078ee257ULL, 0x0000000852247824ULL, 0x000fe200078e00ffULL,
0x000000706e2c7211ULL, 0x000fe200078e20ffULL, 0x000000001414783bULL, 0x000ee20000000200ULL,
0x0000002253547836ULL, 0x000fc40000000000ULL, 0x0000001057207824ULL, 0x000fe200078e0270ULL,
0x000000003838783bULL, 0x000f220000000200ULL, 0xfffffff824557812ULL, 0x000fe200078ee255ULL,
0x0000000851257824ULL, 0x000fe400078e00ffULL, 0x000000002c2c783bULL, 0x000f620000000200ULL,
0x0000007055347211ULL, 0x000fe200078e20ffULL, 0x0000000850297824ULL, 0x000fe200078e00ffULL,
0xfffffff825547812ULL, 0x000fe200078ee254ULL, 0x000000002020783bULL, 0x000f220000000200ULL,
0x000000083c2b7824ULL, 0x000fc400078e00ffULL, 0xfffffff8296c7812ULL, 0x000fe200078ee26cULL,
0x000000003434783bULL, 0x000f620000000200ULL, 0x0000001054307824ULL, 0x000fe400078e0270ULL,
0x0000001062297824ULL, 0x000fe400078e00ffULL, 0x00000004536a7836ULL, 0x000fe20000000000ULL,
0x00000018101c723cULL, 0x002fe200000418ffULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0xfffffff029297812ULL, 0x000fe200078ee228ULL, 0x0000003453677836ULL, 0x000fe20000000000ULL,
0xfffffff82b6a7812ULL, 0x000fe200078ee26aULL, 0x00000008503e7824ULL, 0x000fe200078e00ffULL,
0x0000001a1018723cULL, 0x000fe200000418ffULL, 0x0000001029297824ULL, 0x000fe200078e0202ULL,
0x000000706a3d7211ULL, 0x000fe200078e20ffULL, 0x00000014536b7836ULL, 0x000fe20000000000ULL,
0xfffffff83e677812ULL, 0x000fe200078ee267ULL, 0x0000002453687836ULL, 0x000fc40000000000ULL,
0x000000002928783bULL, 0x000fe20000000200ULL, 0x0000003653647836ULL, 0x000fe40000000000ULL,
0x0000001653667836ULL, 0x000fe20000000000ULL, 0x000000141024723cULL, 0x008fe200000418ffULL,
0x0000002653657836ULL, 0x000fca0000000000ULL, 0x000000161014723cULL, 0x000fec00000418ffULL,
0x00000038401c723cULL, 0x010fec000004181cULL, 0x0000003a4038723cULL, 0x000fec0000041818ULL,
0x0000002c1018723cULL, 0x020fec00000418ffULL, 0x0000002e102c723cULL, 0x000fec00000418ffULL,
0x00000020104c723cULL, 0x000fec00000418ffULL, 0x000000221010723cULL, 0x000fe200000418ffULL,
0x000000106c207824ULL, 0x000fca00078e0270ULL, 0x000000344024723cULL, 0x000fe20000041824ULL,
0x000000002020783bULL, 0x000eea0000000200ULL, 0x000000364034723cULL, 0x000fe20000041814ULL,
0x000000003d14783bULL, 0x000f2a0000000200ULL, 0x000000304018723cULL, 0x002fee0000041818ULL,
0x0000000852307824ULL, 0x000fe200078e00ffULL, 0x0000000351317819ULL, 0x000fc800000006ffULL,
0xfffffff8306b7812ULL, 0x000fe400078ee26bULL, 0xfffffff831687812ULL, 0x000fe400078ee268ULL,
0x000000324030723cULL, 0x000fe2000004182cULL, 0x000000106b487824ULL, 0x100fe400078e0270ULL,
0x0000001068447824ULL, 0x000fc800078e0270ULL, 0x000000033c2e7819ULL, 0x000fe200000006ffULL,
0x00000010673c7824ULL, 0x000fe200078e0270ULL, 0x000000004848783bULL, 0x000e620000000200ULL,
0x00000010622c7824ULL, 0x000fe200078e00ffULL, 0x00000003502f7819ULL, 0x000fe200000006ffULL,
0x00000006632d7836ULL, 0x000fe20000000000ULL, 0x000000004444783bULL, 0x000f620000000200ULL,
0x00000020404c723cULL, 0x008fe2000004184cULL, 0xfffffff82f647812ULL, 0x000fe400078ee264ULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0xfffffff02c2d7812ULL, 0x000fc400078ee22dULL,
0x00000014281c723cULL, 0x010fe2000004181cULL, 0x0000000852217824ULL, 0x000fe200078e00ffULL,
0x000000022d2d7211ULL, 0x000fe200078e20ffULL, 0x0000000851207824ULL, 0x000fe200078e00ffULL,
0xfffffff82e697812ULL, 0x000fe400078ee269ULL, 0xfffffff821667812ULL, 0x000fe200078ee266ULL,
0x000000162838723cULL, 0x000fe20000041838ULL, 0x0000007064147211ULL, 0x000fe200078e20ffULL,
0x000000002d2c783bULL, 0x000fe20000000200ULL, 0xfffffff820657812ULL, 0x000fe200078ee265ULL,
0x0000001066207824ULL, 0x000fc400078e0270ULL, 0x000000224040723cULL, 0x000fe20000041810ULL,
0x000000001414783bULL, 0x000f220000000200ULL, 0x0000001065507824ULL, 0x000fc600078e0270ULL,
0x000000002020783bULL, 0x000fe40000000200ULL, 0x0000001069107824ULL, 0x000fe400078e0270ULL,
0x000000005050783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x000000482824723cULL, 0x002fec0000041824ULL, 0x000000442818723cULL, 0x020fec0000041818ULL,
0x0000003c284c723cULL, 0x008fec000004184cULL, 0x0000004a2834723cULL, 0x000fec0000041834ULL,
0x000000462830723cULL, 0x000fec0000041830ULL, 0x0000003e2828723cULL, 0x000fec0000041840ULL,
0x000000142c4c723cULL, 0x010fec000004184cULL, 0x000000102c1c723cULL, 0x000fe2000004181cULL,
0x000000016d157836ULL, 0x000fca0000000000ULL, 0x0000005a1500720cULL, 0x000fe20003f06070ULL,
0x000000202c24723cULL, 0x000fec0000041824ULL, 0x000000502c18723cULL, 0x000fec0000041818ULL,
0x000000122c10723cULL, 0x000fec0000041838ULL, 0x000000222c20723cULL, 0x000fec0000041834ULL,
0x000000522c50723cULL, 0x000fec0000041830ULL, 0x000000162c2c723cULL, 0x000fe20000041828ULL,
0x0000000e58157224ULL, 0x004fcc00078e02ffULL, 0x000001006d177824ULL, 0x000fe400078e020fULL,
0x0000010015767825ULL, 0x000fc600078e0076ULL, 0x0000004017147812ULL, 0x000fc800078ec0ffULL,
0x0000001403297210ULL, 0x000fe20007ffe0ffULL, 0x0000000c00108947ULL, 0x000fee0003800000ULL,
0x000000040d2a7836ULL, 0x000fe20000000000ULL, 0x000000175c287248ULL, 0x000fe20007fe0000ULL,
0x000000080d307836ULL, 0x000fe20000000000ULL, 0x000000140d347810ULL, 0x000fe20007ffe0ffULL,
0x000000082a167824ULL, 0x000fe200078e00ffULL, 0x000000052a357210ULL, 0x000fe20007ffe0ffULL,
0x00000001303d7824ULL, 0x140fe200078e0205ULL, 0x0000002817287210ULL, 0x000fe20007ffe1ffULL,
0x0000000830327824ULL, 0x000fe200078e00ffULL, 0xfffffff816357812ULL, 0x000fe200078ee235ULL,
0x000000010d147824ULL, 0x040fe200078e0205ULL, 0x000000282a00720cULL, 0x080fe20003f46070ULL,
0x000000010d167824ULL, 0x040fe200078e0229ULL, 0xfffffff8323d7812ULL, 0x000fe200078ee23dULL,
0x0000000c0d327836ULL, 0x000fe20000000000ULL, 0x0000000771717812ULL, 0x000fe200078ef814ULL,
0x0000000134367824ULL, 0x000fe200078e0205ULL, 0x000000283000720cULL, 0x080fe20003f66070ULL,
0x0000000834157824ULL, 0x000fe200078e00ffULL, 0x000000283200720cULL, 0x080fe20003fa6070ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x000000280d00720cULL, 0x000fc40003f26070ULL,
0xfffffff815367812ULL, 0x000fe200078ee236ULL, 0x000000012a147824ULL, 0x000fe200078e0229ULL,
0x00000072162b7212ULL, 0x000fe200078efcffULL, 0x00000001323b7824ULL, 0x040fe400078e0205ULL,
0x00000008322a7824ULL, 0x000fe400078e00ffULL, 0x0000010014147825ULL, 0x000fc600078e00ffULL,
0xfffffff82a3b7812ULL, 0x000fe200078ee23bULL, 0x0000000130307824ULL, 0x100fe200078e0229ULL,
0x0000002b762a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000132167824ULL, 0x000fe200078e0229ULL,
0x0000007214337212ULL, 0x080fe200078efcffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x00000017772b7210ULL, 0x000fe400007fe4ffULL, 0x0000003376327210ULL, 0x000fe20007f1e0ffULL,
0x000000100d3a7836ULL, 0x000fe20000000000ULL, 0x00000072303f7212ULL, 0x000fe200078efcffULL,
0x0000010016167825ULL, 0x000fc600078e00ffULL, 0x000000293a147210ULL, 0x000fe20007ffe0ffULL,
0x0000000177337824ULL, 0x000fe200000e0615ULL, 0x0000003f76307210ULL, 0x000fe20007f1e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0270ULL, 0x0000007216397212ULL, 0x000fe200078efcffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000003177317210ULL, 0x000fe400007fe4ffULL,
0x000000283400720cULL, 0x000fe20003f06070ULL, 0x000000083a387824ULL, 0x000fe200078e00ffULL,
0x000000053a377210ULL, 0x000fe20007ffe0ffULL, 0x0000000134347824ULL, 0x000fe200078e0229ULL,
0x0000003976167210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a717faeULL, 0x0003e2000c901c46ULL, 0x0000007214397212ULL, 0x000fe200078efcffULL,
0x0000001c0d3e7836ULL, 0x000fe20000000000ULL, 0xfffffff838377812ULL, 0x000fe200078ee237ULL,
0x000000180d387836ULL, 0x000fe20000000000ULL, 0x000000283a00720cULL, 0x080fe20003f86070ULL,
0x0000000177177824ULL, 0x000fe200030e0617ULL, 0x0000003976147210ULL, 0x000fe20007fde0ffULL,
0x00000001383a7824ULL, 0x040fe200078e0205ULL, 0x000000283800720cULL, 0x040fe20003f26070ULL,
0x0000000838417824ULL, 0x000fe200078e00ffULL, 0x0000001577157210ULL, 0x000fe200037fe4ffULL,
0x00000100342a7825ULL, 0x002fc600078e00ffULL, 0xfffffff8413a7812ULL, 0x000fe200078ee23aULL,
0x00000001383c7824ULL, 0x000fe200078e0229ULL, 0x000000722a397212ULL, 0x000fe200078efcffULL,
0x000000083e3f7824ULL, 0x000fe200078e00ffULL, 0x000000053e387210ULL, 0x000fe20007ffe0ffULL,
0x000000200d407836ULL, 0x000fe20000000000ULL, 0x0000003976347210ULL, 0x000fe20007fde0ffULL,
0x0000001036437824ULL, 0x000fe200078e0270ULL, 0xfffffff83f387812ULL, 0x000fe200078ee238ULL,
0x0000000140417824ULL, 0x040fe200078e0205ULL, 0x00000070353f7211ULL, 0x000fe200078e20ffULL,
0x0000000840427824ULL, 0x000fc400078e00ffULL, 0x0000000177357824ULL, 0x000fe400030e062bULL,
0x000001003c2a7825ULL, 0x000fe200078e00ffULL, 0xfffffff842397812ULL, 0x000fe200078ee241ULL,
0x00000000323f7faeULL, 0x0003e2000d101c46ULL, 0x00000029403c7210ULL, 0x000fe20007ffe0ffULL,
0x000000103d417824ULL, 0x000fe200078e0270ULL, 0x000000722a3d7212ULL, 0x000fe200078efcffULL,
0x000000013e2a7824ULL, 0x040fe200078e0229ULL, 0x000000283e00720cULL, 0x080fe20003f46070ULL,
0x000000240d3e7836ULL, 0x000fe20000000000ULL, 0x0000000030417faeULL, 0x0005e2000d901c46ULL,
0x000000284000720cULL, 0x000fc40003f66070ULL, 0x0000003d76327210ULL, 0x002fe20007fde0ffULL,
0x000000103b3f7824ULL, 0x000fc800078e0270ULL, 0x0000000177337824ULL, 0x000fe200030e062bULL,
0x00000000163f7faeULL, 0x0003e2000e901c46ULL, 0x000001002a307825ULL, 0x004fe200078e00ffULL,
0x000000283e00720cULL, 0x000fc60003fa6070ULL, 0x000001003c2a7825ULL, 0x000fe200078e00ffULL,
0x00000072303b7212ULL, 0x080fe400078efcffULL, 0x000000053e3c7210ULL, 0x000fe20007ffe0ffULL,
0x000000083e417824ULL, 0x040fe200078e00ffULL, 0x0000003b76307210ULL, 0x000fe20007fde0ffULL,
0x000000013e3b7824ULL, 0x000fe200078e0229ULL, 0x000000722a3d7212ULL, 0x000fc600078efcffULL,
0x000001003b167825ULL, 0x002fc800078e00ffULL, 0x0000000177317824ULL, 0x000fe200030e0631ULL,
0x0000003d762a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff8413d7812ULL, 0x000fe200078ee23cULL,
0x000000280d3c7836ULL, 0x000fe20000000000ULL, 0x0000007037417211ULL, 0x000fe200078e20ffULL,
0x00000001772b7824ULL, 0x040fe200030e062bULL, 0x0000007216377212ULL, 0x000fe200078efcffULL,
0x000000013c3b7824ULL, 0x040fe200078e0205ULL, 0x000000033c3e7819ULL, 0x040fe200000006ffULL,
0x0000000014417faeULL, 0x0003e2000e101c46ULL, 0x0000003776167210ULL, 0x000fe20007fde0ffULL,
0x000000013c377824ULL, 0x040fe200078e0229ULL, 0x000000283c00720cULL, 0x080fe20003f86070ULL,
0x0000000034437faeULL, 0x0005e2000c101c46ULL, 0x0000002c0d3c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000177177824ULL, 0x000fe200030e0617ULL, 0xfffffff83e3b7812ULL, 0x000fe200078ee23bULL,
0x000000300d3e7836ULL, 0x000fe20000000000ULL, 0x000000283c00720cULL, 0x040fe20003f06070ULL,
0x000000013c367824ULL, 0x040fe200078e0229ULL, 0x000000033c407819ULL, 0x000fe200000006ffULL,
0x0000010037147825ULL, 0x002fe200078e00ffULL, 0x000000703d3d7211ULL, 0x000fc600078e20ffULL,
0x000000013c3f7824ULL, 0x000fe200078e0205ULL, 0x0000007214377212ULL, 0x080fe200078efcffULL,
0x000000013e3c7824ULL, 0x000fe400078e0229ULL, 0x000000103a437824ULL, 0x004fe200078e0270ULL,
0x0000003776147210ULL, 0x000fe20007fde0ffULL, 0x0000010036367825ULL, 0x000fe200078e00ffULL,
0xfffffff8403f7812ULL, 0x000fe400078ee23fULL, 0x0000000032437faeULL, 0x0003e2000c901c46ULL,
0x000001003c347825ULL, 0x000fe200078e00ffULL, 0x0000007236417212ULL, 0x000fc400078efcffULL,
0x000000053e367210ULL, 0x000fe20007ffe0ffULL, 0x0000000177157824ULL, 0x000fe200030e0615ULL,
0x000000283e00720cULL, 0x040fe20003f26070ULL, 0x000000083e457824ULL, 0x000fe400078e00ffULL,
0x000000340d3a7836ULL, 0x000fe40000000000ULL, 0x0000003c0d3c7836ULL, 0x000fe20000000000ULL,
0x0000004176327210ULL, 0x002fe20007fde0ffULL, 0x0000001039437824ULL, 0x100fe200078e0270ULL,
0x0000007234417212ULL, 0x000fe200078efcffULL, 0x000000103b3b7824ULL, 0x000fc400078e0270ULL,
0x0000000177337824ULL, 0x000fe200030e0637ULL, 0x0000004176347210ULL, 0x000fe20007fde0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0270ULL, 0x0000007038417211ULL, 0x000fe200078e20ffULL,
0x000000380d387836ULL, 0x000fe20000000000ULL, 0xfffffff845377812ULL, 0x000fe200078ee236ULL,
0x000000013a367824ULL, 0x000fe400078e0229ULL, 0x0000000030417faeULL, 0x0003e2000d101c46ULL,
0x0000000177357824ULL, 0x000fe200030e0635ULL, 0x000000283c00720cULL, 0x080fe20003f46070ULL,
0x0000001037377824ULL, 0x000fe200078e0270ULL, 0x000000002a437faeULL, 0x0005e2000d901c46ULL,
0x000000283800720cULL, 0x000fc60003f66070ULL, 0x00000000163d7faeULL, 0x0007e2000e901c46ULL,
0x000000283a00720cULL, 0x000fe20003fa6070ULL, 0x0000010036307825ULL, 0x002fe400078e00ffULL,
0x00000000143b7faeULL, 0x0003e4000e101c46ULL, 0x0000000138367824ULL, 0x100fe200078e0229ULL,
0x0000007230397212ULL, 0x000fe200078efcffULL, 0x000000013c297824ULL, 0x000fe200078e0229ULL,
0x00000000323f7faeULL, 0x0003e2000c101c46ULL, 0x00000100362a7825ULL, 0x004fe200078e00ffULL,
0x0000003976167210ULL, 0x008fc40007fde0ffULL, 0x0000000538367210ULL, 0x000fe20007ffe0ffULL,
0x0000010029287825ULL, 0x000fe200078e00ffULL, 0x0000003177177210ULL, 0x000fe200037fe4ffULL,
0x0000000034377faeULL, 0x0003e2000c901c46ULL, 0x000000722a317212ULL, 0x080fe200078efcffULL,
0x000000013a307824ULL, 0x140fe400078e0205ULL, 0x000000083a397824ULL, 0x000fe200078e00ffULL,
0x00000031762a7210ULL, 0x000fe20007fde0ffULL, 0x00000008383d7824ULL, 0x000fe200078e00ffULL,
0x0000007228317212ULL, 0x000fe200078efcffULL, 0x000000013c387824ULL, 0x040fe200078e0205ULL,
0xfffffff839397812ULL, 0x000fe200078ee230ULL, 0x000000083c417824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fc400078ee236ULL, 0x0000002b772b7210ULL, 0x000fe400037fe4ffULL,
0xfffffff841417812ULL, 0x000fe200078ee238ULL, 0x000000103d3d7824ULL, 0x100fe200078e0270ULL,
0x0000003176287210ULL, 0x000fe40007fde0ffULL, 0x0000007039397211ULL, 0x000fe200078e20ffULL,
0x0000001041417824ULL, 0x000fe400078e0270ULL, 0x0000000177297824ULL, 0x000fe400030e0629ULL,
0x0000000016397faeULL, 0x0003e8000e901c46ULL, 0x000000002a3d7faeULL, 0x0003e8000d901c46ULL,
0x0000000028417faeULL, 0x0003e2000d101c46ULL, 0x0000000800c47947ULL, 0x000fea0003800000ULL,
0x000000050d147210ULL, 0x000fe20007ffe0ffULL, 0x000000040d167836ULL, 0x000fe20000000000ULL,
0x000000140d4b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d2a7824ULL, 0x100fe200078e0229ULL,
0x0000000771477812ULL, 0x000fe200078ef814ULL, 0x000000080d147836ULL, 0x000fe20000000000ULL,
0x0000002916177210ULL, 0x000fe20007ffe0ffULL, 0x0000000c0d427836ULL, 0x000fe20000000000ULL,
0x000000294b347210ULL, 0x000fe20007ffe0ffULL, 0x0000000114157824ULL, 0x000fe200078e0229ULL,
0x0000000514437210ULL, 0x000fe20007ffe0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x000000380d787810ULL, 0x000fc60007ffe0ffULL, 0x0000000116457824ULL, 0x000fe200078e0205ULL,
0x000000722a317212ULL, 0x080fe200078efcffULL, 0x0000000816287824ULL, 0x000fe400078e00ffULL,
0x0000010017167825ULL, 0x000fe200078e00ffULL, 0x00000031762a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff828457812ULL, 0x000fe200078ee245ULL, 0x0000000142387824ULL, 0x000fe200078e0229ULL,
0x0000007216337212ULL, 0x000fe200078efcffULL, 0x0000000814307824ULL, 0x000fc400078e00ffULL,
0x0000010015147825ULL, 0x000fe200078e00ffULL, 0x0000003376167210ULL, 0x000fe40007f3e0ffULL,
0xfffffff830437812ULL, 0x000fe200078ee243ULL, 0x000000100d717836ULL, 0x000fe20000000000ULL,
0x0000007214357212ULL, 0x000fe200078efcffULL, 0x000000180d4a7836ULL, 0x000fe20000000000ULL,
0x0000001777177210ULL, 0x000fe20000ffe4ffULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x0000003576147210ULL, 0x000fc60007f5e0ffULL, 0x0000000171367824ULL, 0x100fe200078e0229ULL,
0x0000007238417212ULL, 0x000fe200078efcffULL, 0x000000014a327824ULL, 0x000fe400078e0229ULL,
0x0000001c0d497836ULL, 0x000fe40000000000ULL, 0x0000010036367825ULL, 0x000fc800078e00ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x00000072363f7212ULL, 0x000fc600078efcffULL,
0x0000000149307824ULL, 0x000fe200078e0229ULL, 0x00000072323b7212ULL, 0x000fe200078efcffULL,
0x00000001772b7824ULL, 0x000fe200000e062bULL, 0x0000004176407210ULL, 0x000fe20007f1e0ffULL,
0x0000010034347825ULL, 0x000fc800078e00ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x00000072343d7212ULL, 0x000fc600078efcffULL, 0x0000000177157824ULL, 0x040fe200010e0615ULL,
0x0000003b763a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000177417824ULL, 0x040fe200000e0639ULL,
0x0000003f763e7210ULL, 0x000fe20007f1e0ffULL, 0x000000200d487836ULL, 0x000fe20000000000ULL,
0x0000007230397212ULL, 0x000fe200078efcffULL, 0x00000001773b7824ULL, 0x000fe200010e0633ULL,
0x0000003d763c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001047337824ULL, 0x100fe200078e0270ULL,
0x00000037773f7210ULL, 0x000fe200007fe4ffULL, 0x000000240d477836ULL, 0x000fe20000000000ULL,
0x0000003976387210ULL, 0x000fe20007f1e0ffULL, 0x00000001773d7824ULL, 0x000fe200008e0635ULL,
0x0000002948307210ULL, 0x000fe20007ffe0ffULL, 0x0000001045357824ULL, 0x100fe200078e0270ULL,
0x0000003177397210ULL, 0x000fe200007fe4ffULL, 0x0000001043437824ULL, 0x000fe200078e0270ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a337faeULL, 0x0003e2000b901c46ULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000002c0d457810ULL, 0x000fc40007ffe0ffULL,
0x0000000016357faeULL, 0x000fe2000b901c46ULL, 0x0000000147287824ULL, 0x100fe200078e0229ULL,
0x0000007230377212ULL, 0x000fe200078efcffULL, 0x000000280d467836ULL, 0x000fe20000000000ULL,
0x0000000014437faeULL, 0x0005e2000b901c46ULL, 0x000000300d447836ULL, 0x000fe20000000000ULL,
0x0000003776367210ULL, 0x000fe20007f1e0ffULL, 0x0000000146327824ULL, 0x000fe400078e0229ULL,
0x0000003c0d797836ULL, 0x000fe20000000000ULL, 0x0000003177377210ULL, 0x000fe200007fe4ffULL,
0x00000100322a7825ULL, 0x002fc800078e00ffULL, 0x0000010028147825ULL, 0x004fe200078e00ffULL,
0x000000722a337212ULL, 0x000fc600078efcffULL, 0x0000000145287824ULL, 0x100fe200078e0229ULL,
0x0000007214357212ULL, 0x000fe200078efcffULL, 0x0000000144147824ULL, 0x000fe400078e0229ULL,
0x0000010028167825ULL, 0x000fe200078e00ffULL, 0x0000003576347210ULL, 0x000fc60007f1e0ffULL,
0x000000340d437836ULL, 0x000fe20000000000ULL, 0x0000007216317212ULL, 0x000fe200078efcffULL,
0x0000000177357824ULL, 0x000fe200000e0615ULL, 0x0000003376327210ULL, 0x000fe20007f1e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000003176307210ULL, 0x000fc60007f3e0ffULL,
0x0000000177337824ULL, 0x000fe200000e062bULL, 0x00000072142b7212ULL, 0x000fe200078efcffULL,
0x0000000143147824ULL, 0x100fe200078e0229ULL, 0x0000001777317210ULL, 0x000fe20000ffe4ffULL,
0x0000000178167824ULL, 0x000fe200078e0229ULL, 0x0000002b762a7210ULL, 0x000fca0007f1e0ffULL,
0x00000001772b7824ULL, 0x000fe400000e0615ULL, 0x0000010014147825ULL, 0x000fc600078e00ffULL,
0x0000007214177212ULL, 0x000fe200078efcffULL, 0x0000000179147824ULL, 0x000fc600078e0229ULL,
0x0000001776287210ULL, 0x000fe20007f1e0ffULL, 0x0000010016167825ULL, 0x000fc600078e00ffULL,
0x0000001577297210ULL, 0x000fe200007fe4ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x00000072167b7212ULL, 0x080fe400078efcffULL, 0x00000072147d7212ULL, 0x000fe200078efcffULL,
0x0000000142727824ULL, 0x000fe200078e0205ULL, 0x0000007b76167210ULL, 0x000fe20007f1e0ffULL,
0x000000084a7b7824ULL, 0x000fe200078e00ffULL, 0x0000007d76147210ULL, 0x000fe20007f3e0ffULL,
0x00000008497d7824ULL, 0x000fe400078e00ffULL, 0x0000000177177824ULL, 0x000fc400000e0617ULL,
0x0000000177157824ULL, 0x000fe200008e0615ULL, 0x0000000342777819ULL, 0x000fe200000006ffULL,
0x0000000171427824ULL, 0x040fe400078e0205ULL, 0x0000000871717824ULL, 0x000fe200078e00ffULL,
0xfffffff877777812ULL, 0x000fe400078ee272ULL, 0x000000054b727210ULL, 0x000fe20007ffe0ffULL,
0x000000084b4b7824ULL, 0x000fe200078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee242ULL,
0x0000001077777824ULL, 0x000fc400078e0270ULL, 0x000000014a427824ULL, 0x100fe200078e0205ULL,
0x00000005494a7210ULL, 0x000fe20007ffe0ffULL, 0x0000001071717824ULL, 0x100fe200078e0270ULL,
0x0000000040777faeULL, 0x0003e2000b901c46ULL, 0xfffffff84b4b7812ULL, 0x000fe400078ee272ULL,
0xfffffff87b497812ULL, 0x000fe200078ee242ULL, 0x00000001467b7824ULL, 0x140fe200078e0205ULL,
0x0000000579427210ULL, 0x000fe20007ffe0ffULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0x0000007049497211ULL, 0x080fe200078e20ffULL, 0x0000000879797824ULL, 0x000fe200078e00ffULL,
0x000000003e717faeULL, 0x0005e2000b901c46ULL, 0x000000104b4b7824ULL, 0x100fe200078e0270ULL,
0xfffffff8467b7812ULL, 0x000fe200078ee27bULL, 0x0000000148777824ULL, 0x142fe200078e0205ULL,
0x0000000547407210ULL, 0x000fe20007ffe0ffULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0xfffffff87d417812ULL, 0x000fe200078ee24aULL, 0x0000000848487824ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fe200078ee242ULL, 0x00000001447d7824ULL, 0x040fe200078e0205ULL,
0xfffffff847477812ULL, 0x000fe200078ee240ULL, 0x0000000844447824ULL, 0x000fe200078e00ffULL,
0x0000000545407210ULL, 0x000fe20007ffe0ffULL, 0x0000000845457824ULL, 0x000fe200078e00ffULL,
0xfffffff848777812ULL, 0x000fe200078ee277ULL, 0x0000001041417824ULL, 0x100fe200078e0270ULL,
0xfffffff8447d7812ULL, 0x000fe200078ee27dULL, 0x0000001047477824ULL, 0x100fe200078e0270ULL,
0xfffffff845457812ULL, 0x000fe200078ee240ULL, 0x0000001077777824ULL, 0x100fe200078e0270ULL,
0x0000000543407210ULL, 0x000fe20007ffe0ffULL, 0x0000000843437824ULL, 0x000fe200078e00ffULL,
0x000000707b7b7211ULL, 0x000fe200078e20ffULL, 0x000000003c4b7faeULL, 0x0005e2000b901c46ULL,
0x0000001045457824ULL, 0x000fc400078e0270ULL, 0xfffffff843437812ULL, 0x000fe200078ee240ULL,
0x0000000178407824ULL, 0x040fe200078e0205ULL, 0x000000003a497faeULL, 0x0005e2000b901c46ULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x000000107d7d7824ULL, 0x100fe200078e0270ULL,
0x0000000038417faeULL, 0x0005e2000b901c46ULL, 0x0000001043437824ULL, 0x100fe200078e0270ULL,
0xfffffff878407812ULL, 0x000fe200078ee240ULL, 0x0000001079797824ULL, 0x000fe200078e0270ULL,
0x0000000036777faeULL, 0x0005e4000b901c46ULL, 0x0000007040407211ULL, 0x000fc400078e20ffULL,
0x0000000034477faeULL, 0x0005e8000b901c46ULL, 0x00000000327b7faeULL, 0x0005e8000b901c46ULL,
0x0000000030457faeULL, 0x0005e8000b901c46ULL, 0x000000002a7d7faeULL, 0x0005e8000b901c46ULL,
0x0000000028437faeULL, 0x0005e8000b901c46ULL, 0x0000000016407faeULL, 0x0005e8000b901c46ULL,
0x0000000014797faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000863147836ULL, 0x006fe20000000000ULL, 0x0000006157347211ULL, 0x080fe200078e20ffULL,
0x0000001062157824ULL, 0x040fe400078e00ffULL, 0x0000000a63287836ULL, 0x000fe40000000000ULL,
0x0000001062297824ULL, 0x000fe200078e00ffULL, 0xfffffff015157812ULL, 0x000fe200078ee214ULL,
0x000000106f3c7824ULL, 0x100fe200078e0261ULL, 0x0000006173147211ULL, 0x000fe200078e20ffULL,
0x000000106e387824ULL, 0x000fe200078e0261ULL, 0xfffffff029297812ULL, 0x000fe200078ee228ULL,
0x0000001015307824ULL, 0x000fc400078e0202ULL, 0x0000001056287824ULL, 0x100fe200078e0261ULL,
0x0000000229447211ULL, 0x000fe200078e20ffULL, 0x0000001054547824ULL, 0x100fe400078e0261ULL,
0x000000106c487824ULL, 0x100fe400078e0261ULL, 0x000000106a407824ULL, 0x000fe200078e0261ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003030783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000001414783bULL, 0x000ea80000000200ULL,
0x000000003c3c783bULL, 0x000ee80000000200ULL, 0x000000003838783bULL, 0x000f280000000200ULL,
0x000000002828783bULL, 0x000fe80000000200ULL, 0x000000004444783bULL, 0x000f680000000200ULL,
0x000000004848783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x00000034304c723cULL, 0x002fec000004184cULL, 0x00000014301c723cULL, 0x004fe2000004181cULL,
0x0000000c63347836ULL, 0x000fe20000000000ULL, 0x0000000462357819ULL, 0x000fe200000006ffULL,
0x0000000e63637836ULL, 0x000fc40000000000ULL, 0x0000001062627824ULL, 0x000fe200078e00ffULL,
0xfffffff035357812ULL, 0x000fe200078ee234ULL, 0x0000001055147824ULL, 0x100fe200078e0261ULL,
0x000000163010723cULL, 0x000fe20000041810ULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0xfffffff062637812ULL, 0x000fe200078ee263ULL, 0x0000001035357824ULL, 0x000fe400078e0202ULL,
0x000000001414783bULL, 0x000e620000000200ULL, 0x00000036302c723cULL, 0x000fe6000004182cULL,
0x000000003534783bULL, 0x000ea60000000200ULL, 0x0000003c3024723cULL, 0x008fec0000041824ULL,
0x0000003e3020723cULL, 0x000fe20000041820ULL, 0x00000010683c7824ULL, 0x000fca00078e0261ULL,
0x000000383018723cULL, 0x010fe20000041818ULL, 0x000000003c3c783bULL, 0x000fea0000000200ULL,
0x0000003a3050723cULL, 0x000fe20000041850ULL, 0x0000006167387211ULL, 0x000fca00078e20ffULL,
0x00000028441c723cULL, 0x020fe2000004181cULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x0000001069307824ULL, 0x000fc800078e0261ULL, 0x0000002a4428723cULL, 0x000fe40000041810ULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000144424723cULL, 0x002fe20000041824ULL,
0x000000616b107211ULL, 0x000fca00078e20ffULL, 0x000000164414723cULL, 0x000fe20000041820ULL,
0x000000001010783bULL, 0x000e6a0000000200ULL, 0x000000544418723cULL, 0x000fe20000041818ULL,
0x0000001063207824ULL, 0x000fca00078e0202ULL, 0x000000564450723cULL, 0x000fe20000041850ULL,
0x0000001066547824ULL, 0x000fe200078e0261ULL, 0x000000002020783bULL, 0x000ee80000000200ULL,
0x00000048444c723cULL, 0x000fe2000004184cULL, 0x000000005454783bULL, 0x000f2a0000000200ULL,
0x0000004a442c723cULL, 0x000fec000004182cULL, 0x00000040341c723cULL, 0x004fe2000004181cULL,
0x0000006165447211ULL, 0x000fca00078e20ffULL, 0x000000423428723cULL, 0x000fe20000041828ULL,
0x0000001064407824ULL, 0x000fe200078e0261ULL, 0x000000004444783bULL, 0x000ea80000000200ULL,
0x000000103424723cULL, 0x002fe20000041824ULL, 0x000000004040783bULL, 0x000e6a0000000200ULL,
0x000000123414723cULL, 0x000fe20000041814ULL, 0x00000001ff107424ULL, 0x000fca00078e00ffULL,
0x0000003c3418723cULL, 0x000fe20000041818ULL, 0x01b68810071079a7ULL, 0x000f6a000850003fULL,
0x0000003e3450723cULL, 0x000fec0000041850ULL, 0x00000038344c723cULL, 0x000fec000004184cULL,
0x0000003a342c723cULL, 0x000fec000004182cULL, 0x00000030201c723cULL, 0x008fec000004181cULL,
0x000000322028723cULL, 0x000fec0000041828ULL, 0x000000542024723cULL, 0x010fec0000041824ULL,
0x000000562014723cULL, 0x000fec0000041814ULL, 0x000000442018723cULL, 0x004fe20000041818ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fc60000410000ULL, 0x000000462050723cULL, 0x000fe20000041850ULL,
0x3db504f328287820ULL, 0x000fe20000410000ULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f32a2a7820ULL, 0x000fe20000410000ULL, 0x3db504f32b2b7820ULL, 0x000fe40000410000ULL,
0x00000040204c723cULL, 0x002fe2000004184cULL, 0x3db504f324247820ULL, 0x000fe20000410000ULL,
0x3db504f325257820ULL, 0x000fe20000410000ULL, 0x3db504f326267820ULL, 0x000fe20000410000ULL,
0x3db504f327277820ULL, 0x000fc40000410000ULL, 0x00000042202c723cULL, 0x000fec000004182cULL,
0x3db504f318327820ULL, 0x000fe20000410000ULL, 0x3db504f31c217820ULL, 0x000fe20000410000ULL,
0x3db504f3141c7820ULL, 0x000fe20000410000ULL, 0x3db504f315207820ULL, 0x000fe20000410000ULL,
0x3db504f316227820ULL, 0x000fe20000410000ULL, 0x3db504f317237820ULL, 0x000fe20000410000ULL,
0x3db504f319347820ULL, 0x000fe20000410000ULL, 0x3db504f31a337820ULL, 0x000fe20000410000ULL,
0x3db504f31b317820ULL, 0x000fe20000410000ULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fe20000410000ULL, 0x3db504f34c4c7820ULL, 0x000fe20000410000ULL,
0x3db504f34d4d7820ULL, 0x000fe20000410000ULL, 0x3db504f34e4e7820ULL, 0x000fe20000410000ULL,
0x3db504f34f4f7820ULL, 0x000fc40000410000ULL, 0x3db504f32c2c7820ULL, 0x000fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fe20000410000ULL, 0x3db504f32e2e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f2f7820ULL, 0x000fe20000410000ULL, 0x0000000000127805ULL, 0x000fe20000015200ULL,
0x01b68811070075a7ULL, 0x020e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff167224ULL, 0x000fce00078e00ffULL, 0x000000101600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412177210ULL, 0x000fc80007f1e1ffULL, 0x0000001513157210ULL, 0x000fe400007fe5ffULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000116167836ULL, 0x000fce0000000000ULL, 0x01b68811070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000405107824ULL, 0x000fe200078e00ffULL,
0x000000025d117211ULL, 0x000fe400078e38ffULL, 0x000000046000720cULL, 0x000fe40003f06070ULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111307824ULL, 0x000fca00078e0210ULL,
0x01b4000030107984ULL, 0x0002a20000000c00ULL, 0x0000001400208947ULL, 0x000fea0003800000ULL,
0x0000860000047ab9ULL, 0x000fe20000000800ULL, 0x000000ff00147202ULL, 0x000fe20000000f00ULL,
0x0000000400167d06ULL, 0x000ee20008209000ULL, 0x0000000205367824ULL, 0x000fe200078e00ffULL,
0x00000004ff007c0cULL, 0x000fe4000bf85070ULL, 0x00000004ff1b7c12ULL, 0x000fe4000f8e33ffULL,
0x0000000636367812ULL, 0x000fc800078ec0ffULL, 0x0000005f36387210ULL, 0x000fe20007ffe0ffULL,
0x0000001600167308ULL, 0x008ee40000001000ULL, 0x0ffffffe16187836ULL, 0x008fcc0000000000ULL,
0x0000001800157305ULL, 0x000ee4000021f000ULL, 0x000000ffff177224ULL, 0x008fc800078e0a15ULL,
0x0000000417177c24ULL, 0x000fc8000f8e02ffULL, 0x0000001715197227ULL, 0x000fe200078e0014ULL,
0x0000005e05147211ULL, 0x000fca00078ff0ffULL, 0x0000001419157227ULL, 0x000fc800078e00ffULL,
0x000000ffff177224ULL, 0x000fc800078e0a15ULL, 0x0000000417167c24ULL, 0x000fe4000f8e0214ULL,
0x0000000814147836ULL, 0x000fc60000000000ULL, 0x0000000416007c0cULL, 0x000fe2000bf06070ULL,
0x0000001419187227ULL, 0x000fc800078e00ffULL, 0x000000ffff177224ULL, 0x000fc800078e0a18ULL,
0x0000000417177c24ULL, 0x000fe2000f8e0214ULL, 0x0000000b5c147248ULL, 0x000fc60007fe0000ULL,
0x8000000416160c10ULL, 0x000fe2000fffe0ffULL, 0x0000000115150836ULL, 0x000fe20000000000ULL,
0x0000000417007c0cULL, 0x000fe2000bf46070ULL, 0x00000001140b7824ULL, 0x000fe200078e0a0bULL,
0x0000000416007c0cULL, 0x000fe2000bf26070ULL, 0x0000000109147824ULL, 0x000fe400078e0236ULL,
0x000000ffff477224ULL, 0x000fc600078e0a0bULL, 0x0000000b1400720cULL, 0x080fe40003f66070ULL,
0x0000004714147246ULL, 0x000fe40003800008ULL, 0x0000004738437246ULL, 0x000fe20003800008ULL,
0x0000000118182836ULL, 0x000fe20000000000ULL, 0x8000000417172c10ULL, 0x000fe2000fffe0ffULL,
0x0000000115151836ULL, 0x000fe20000000000ULL, 0x0000000b3800720cULL, 0x000fe40003f26070ULL,
0x0000000417007c0cULL, 0x000fc4000bf06070ULL, 0x000000151b157207ULL, 0x000fe40006000000ULL,
0x00000004ff147819ULL, 0x000fe40000011614ULL, 0x0000001508157248ULL, 0x000fe40003fe0000ULL,
0x000000ff14197207ULL, 0x000fe40001800000ULL, 0x000000ff43437207ULL, 0x000fe20000800000ULL,
0x0000000515607c24ULL, 0x000fe4000f8e02ffULL, 0x0000000118180836ULL, 0x000fc40000000000ULL,
0x0000000160157824ULL, 0x000fe200078e0219ULL, 0x0000006043177211ULL, 0x000fe400078fe0ffULL,
0x000000181b1b7207ULL, 0x000fe20006000000ULL, 0x0000000215147825ULL, 0x000fc600078e0074ULL,
0x0000001b081b7248ULL, 0x000fe20003fe0000ULL, 0x0000000217167825ULL, 0x000fe200078e0074ULL,
0x0000000614457981ULL, 0x000726000c1e9500ULL, 0x000000051b627c24ULL, 0x000fe2000f8e02ffULL,
0x0000000616567981ULL, 0x000f22000c1e9500ULL, 0x00000010363c7812ULL, 0x000fc600078efcffULL,
0x0000006219197210ULL, 0x000fe40007ffe0ffULL, 0x00000062431b7211ULL, 0x000fe200078fe0ffULL,
0x0000000109147824ULL, 0x008fe400078e023cULL, 0x0000000219187825ULL, 0x000fc800078e0074ULL,
0x000000021b1a7825ULL, 0x000fe200078e0074ULL, 0x0000004714157246ULL, 0x000fe20003800008ULL,
0x0000000618417981ULL, 0x0044e4000c1e9500ULL, 0x000000013c3a7824ULL, 0x000fe400078e025fULL,
0x000000061a667981ULL, 0x000ae2000c1e9500ULL, 0x0000002036407812ULL, 0x000fe400078efcffULL,
0x0000000b1400720cULL, 0x080fe40003f26070ULL, 0x0000000b3a00720cULL, 0x000fc40003f06070ULL,
0x00000004ff157819ULL, 0x000fe40000011615ULL, 0x000000473a357246ULL, 0x000fe20003800008ULL,
0x0000000109447824ULL, 0x000fe200078e0240ULL, 0x000000ff15397207ULL, 0x000fe40000800000ULL,
0x000000ff35357207ULL, 0x000fe20000000000ULL, 0x0000000140427824ULL, 0x000fe200078e025fULL,
0x0000006239197210ULL, 0x004fe20007ffe0ffULL, 0x0000000160157824ULL, 0x000fe200078e0239ULL,
0x0000006035177211ULL, 0x002fc400078fe0ffULL, 0x00000062351b7211ULL, 0x020fe200078fe0ffULL,
0x0000000215147825ULL, 0x100fe200078e0074ULL, 0x00000047443b7246ULL, 0x000fe40003800008ULL,
0x0000003036467812ULL, 0x000fe200078efcffULL, 0x0000000217167825ULL, 0x100fe200078e0074ULL,
0x0000000b4400720cULL, 0x080fe20003f26070ULL, 0x0000000614377981ULL, 0x000ea2000c1e9500ULL,
0x0000000b4200720cULL, 0x000fe20003f06070ULL, 0x0000000219187825ULL, 0x000fe200078e0074ULL,
0x00000004ff3b7819ULL, 0x000fe2000001163bULL, 0x00000006163e7981ULL, 0x0002a2000c1e9500ULL,
0x00000047423f7246ULL, 0x000fe20003800008ULL, 0x000000021b1a7825ULL, 0x000fe200078e0074ULL,
0x000000ff3b3d7207ULL, 0x000fe20000800000ULL, 0x0000000618397981ULL, 0x000aa2000c1e9500ULL,
0x000000ff3f3f7207ULL, 0x000fe20000000000ULL, 0x0000000109647824ULL, 0x000fc400078e0246ULL,
0x000000061a447981ULL, 0x000aa2000c1e9500ULL, 0x00000001464a7824ULL, 0x000fe200078e025fULL,
0x000000603f177211ULL, 0x002fe200078fe0ffULL, 0x0000000160157824ULL, 0x000fe200078e023dULL,
0x0000004764497246ULL, 0x000fe40003800008ULL, 0x000000623d197210ULL, 0x020fe20007ffe0ffULL,
0x0000000215147825ULL, 0x000fe200078e0074ULL, 0x000000623f1b7211ULL, 0x000fc600078fe0ffULL,
0x0000000217167825ULL, 0x000fe200078e0074ULL, 0x0000000b6400720cULL, 0x080fe20003f26070ULL,
0x00000006143b7981ULL, 0x000362000c1e9500ULL, 0x00000004ff497819ULL, 0x000fe20000011649ULL,
0x0000000219187825ULL, 0x100fe200078e0074ULL, 0x0000000b4a00720cULL, 0x000fe20003f06070ULL,
0x0000000616487981ULL, 0x000362000c1e9500ULL, 0x000000474a477246ULL, 0x000fe20003800008ULL,
0x000000021b1a7825ULL, 0x000fe200078e0074ULL, 0x000000ff49497207ULL, 0x000fe20000800000ULL,
0x00000006183d7981ULL, 0x000f62000c1e9500ULL, 0x000000ff47477207ULL, 0x000fc60000000000ULL,
0x000000061a547981ULL, 0x000364000c1e9500ULL, 0x0000000160157824ULL, 0x002fe200078e0249ULL,
0x0000006047177211ULL, 0x000fc600078fe0ffULL, 0x0000000215147825ULL, 0x000fc800078e0074ULL,
0x0000000217167825ULL, 0x100fe400078e0074ULL, 0x0000000614147981ULL, 0x000362000c1e9500ULL,
0x00000062491b7210ULL, 0x000fe40007ffe0ffULL, 0x0000006247197211ULL, 0x000fe200078fe0ffULL,
0x0000000616177981ULL, 0x000364000c1e9500ULL, 0x000000021b1a7825ULL, 0x000fc800078e0074ULL,
0x0000000219187825ULL, 0x000fe400078e0074ULL, 0x000000061a1b7981ULL, 0x000368000c1e9500ULL,
0x0000000618187981ULL, 0x000362000c1e9500ULL, 0xfffffff043627812ULL, 0x000fe200078ec0ffULL,
0x00000001ff437424ULL, 0x000fc800078e00ffULL, 0x000000010b157824ULL, 0x002fe200078e0262ULL,
0x0000000136607812ULL, 0x000fc800078efcffULL, 0x8000001538687210ULL, 0x000fe40007ffe0ffULL,
0x0000000936167812ULL, 0x000fe400078efcffULL, 0x0000006843687219ULL, 0x000fe200000006ffULL,
0x0000000160647824ULL, 0x100fe400078e025fULL, 0x00000001161a7824ULL, 0x000fe400078e025fULL,
0x00000001646a7824ULL, 0x100fe400078e0a15ULL, 0x000000011a6e7824ULL, 0x000fc600078e0a15ULL,
0x0000006a436a7219ULL, 0x040fe400000006ffULL, 0x0000006e436e7219ULL, 0x000fe400000006ffULL,
0x00000011367a7812ULL, 0x040fe400078efcffULL, 0x0000001836787812ULL, 0x040fe400078efcffULL,
0xfffffff03f3f7812ULL, 0x000fe400078ec0ffULL, 0x0000001936767812ULL, 0x000fe200078efcffULL,
0x000000017a197824ULL, 0x000fc400078e025fULL, 0x000000010b6f7824ULL, 0x000fe200078e023fULL,
0x0000005f767c7210ULL, 0x000fc60007ffe0ffULL, 0x0000000142657824ULL, 0x000fe200078e0a6fULL,
0x0000002136707812ULL, 0x000fe400078efcffULL, 0xfffffff047477812ULL, 0x000fe400078ec0ffULL,
0x0000006543657219ULL, 0x000fe200000006ffULL, 0x0000000170727824ULL, 0x000fe400078e025fULL,
0x000000010b477824ULL, 0x000fc600078e0247ULL, 0x000000726f677210ULL, 0x000fe20007ffe1ffULL,
0x000000014a6b7824ULL, 0x000fc600078e0a47ULL, 0x0000006743677219ULL, 0x040fe400000006ffULL,
0x0000006b436b7219ULL, 0x000fe400000006ffULL, 0x0000541056457816ULL, 0x010fe40000000045ULL,
0x0000000836567812ULL, 0x000fe400078efcffULL, 0x0000004568ff7212ULL, 0x000fc6000780c0ffULL,
0x0000000156627824ULL, 0x000fe200078e025fULL, 0x0000000b3800720cULL, 0x000fc80000701470ULL,
0x00000062156c7210ULL, 0x000fe40007ffe1ffULL, 0x0000000b3600720cULL, 0x000fe400007a1070ULL,
0x0000006c436c7219ULL, 0x000fe400000006ffULL, 0x0000541066417816ULL, 0x008fe40000000041ULL,
0xff80000021217808ULL, 0x000fe40002800000ULL, 0x0000004168ff7212ULL, 0x000fc4000784c0ffULL,
0x000000416aff7212ULL, 0x080fe4000780c0ffULL, 0x000000416cff7212ULL, 0x080fe400078cc0ffULL,
0x000000416eff7212ULL, 0x000fe400078ac0ffULL, 0xfffffff035417812ULL, 0x000fe200078ec0ffULL,
0x0000000178157824ULL, 0x000fc800078e025fULL, 0x000000010b417824ULL, 0x000fe200078e0241ULL,
0x000000456aff7212ULL, 0x080fe4000782c0ffULL, 0x000000456cff7212ULL, 0x080fe2000786c0ffULL,
0x000000013a3f7824ULL, 0x100fe200078e0a41ULL, 0x000000456eff7212ULL, 0x000fe2000788c0ffULL,
0x0000000115617824ULL, 0x000fe200078e0a41ULL, 0x0000001941457210ULL, 0x000fe40007ffe1ffULL,
0x0000000b3800720cULL, 0x080fe40001741470ULL, 0x0000000b6200720cULL, 0x000fc400037c1470ULL,
0x0000000b1a00720cULL, 0x000fe20002fa1470ULL, 0x000000017c737824ULL, 0x000fe200078e0a41ULL,
0x0000003f43417219ULL, 0x040fe400000006ffULL, 0x00000045433f7219ULL, 0x000fe400000006ffULL,
0x0000000b3600720cULL, 0x080fe40001741070ULL, 0x0000000b5600720cULL, 0x080fe400037c1070ULL,
0x0000000b1600720cULL, 0x000fc40002fa1070ULL, 0x0000006143457219ULL, 0x000fe400000006ffULL,
0x000054103e3e7816ULL, 0x004fe40000000037ULL, 0x0000541044447816ULL, 0x000fe40000000039ULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40003000000ULL,
0xff8000002b2b7808ULL, 0x000fc40002800000ULL, 0x0000003e41ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004441ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004445ff7212ULL, 0x000fe400078ac0ffULL,
0x0000000b6400720cULL, 0x0c0fe40000f21470ULL, 0x0000000b6400720cULL, 0x080fe40000701470ULL,
0x0000000b6200720cULL, 0x000fc40001f61470ULL, 0x0000000b1a00720cULL, 0x080fe40002781470ULL,
0x0000000b3a00720cULL, 0x0c0fe40001741470ULL, 0x0000000b3a00720cULL, 0x080fe400037c1470ULL,
0x0000000b1500720cULL, 0x000fe40002fa1470ULL, 0x00000028366e7812ULL, 0x040fe400078efcffULL,
0x00000029366c7812ULL, 0x000fc400078efcffULL, 0x0000000b6000720cULL, 0x0c0fe40000f21070ULL,
0x0000000b6000720cULL, 0x080fe40000701070ULL, 0x0000000b5600720cULL, 0x080fe40001f61070ULL,
0x0000000b1600720cULL, 0x080fe40002781070ULL, 0x0000000b3c00720cULL, 0x0c0fe40001741070ULL,
0x0000000b3c00720cULL, 0x000fc400037c1070ULL, 0x0000000b7800720cULL, 0x000fe40002fa1070ULL,
0x0000007343617219ULL, 0x000fe400000006ffULL, 0x0000541048487816ULL, 0x020fe4000000003bULL,
0x0000541054547816ULL, 0x000fe2000000003dULL, 0x000000016e357824ULL, 0x000fe200078e025fULL,
0x0000005f6c577210ULL, 0x000fe40007ffe0ffULL, 0xff8000001d1d7808ULL, 0x000fc40000800000ULL,
0xff8000001f1f7808ULL, 0x000fe40000000000ULL, 0xff80000028287808ULL, 0x000fe40001800000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff80000024247808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fe40003000000ULL, 0xff80000022227808ULL, 0x000fc40002800000ULL,
0x0000003e3fff7212ULL, 0x080fe4000782c0ffULL, 0x0000003e45ff7212ULL, 0x080fe4000780c0ffULL,
0x0000003e61ff7212ULL, 0x000fe4000786c0ffULL, 0x000000443fff7212ULL, 0x080fe4000788c0ffULL,
0x0000004461ff7212ULL, 0x000fe4000784c0ffULL, 0x0000004865ff7212ULL, 0x000fc400078cc0ffULL,
0x0000005465ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000135717824ULL, 0x100fe200078e0a6fULL,
0x0000000b1900720cULL, 0x080fe20000f21470ULL, 0x00000001576f7824ULL, 0x000fe200078e0a6fULL,
0x0000000b1900720cULL, 0x080fe40002781470ULL, 0x0000000b1500720cULL, 0x080fe40000701470ULL,
0x0000000b7c00720cULL, 0x0c0fe40001f61470ULL, 0x0000000b7c00720cULL, 0x000fc40001741470ULL,
0x0000000b4200720cULL, 0x0c0fe400037c1470ULL, 0x0000000b4200720cULL, 0x080fe40002fa1470ULL,
0x00000031366a7812ULL, 0x040fe400078efcffULL, 0x0000003836687812ULL, 0x040fe400078efcffULL,
0x0000003936667812ULL, 0x000fe400078efcffULL, 0x0000000b7a00720cULL, 0x000fc40000f21070ULL,
0x0000000b7a00720cULL, 0x080fe40002781070ULL, 0x0000000b7800720cULL, 0x080fe40000701070ULL,
0x0000000b7600720cULL, 0x0c0fe40001f61070ULL, 0x0000000b7600720cULL, 0x080fe40001741070ULL,
0x0000000b4000720cULL, 0x0c0fe400037c1070ULL, 0x0000000b4000720cULL, 0x000fc40002fa1070ULL,
0x0000007143717219ULL, 0x040fe400000006ffULL, 0x0000006f436f7219ULL, 0x000fe400000006ffULL,
0x0000541017147816ULL, 0x000fe20000000014ULL, 0x000000016a557824ULL, 0x100fe200078e025fULL,
0x0000005f684b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000166497824ULL, 0x000fe200078e025fULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fc40002000000ULL,
0xff8000001c1c7808ULL, 0x000fe40000000000ULL, 0xff80000020207808ULL, 0x000fe40001800000ULL,
0xff80000023237808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40002800000ULL, 0x0000004867ff7212ULL, 0x000fc4000782c0ffULL,
0x0000004871ff7212ULL, 0x080fe4000788c0ffULL, 0x000000486fff7212ULL, 0x000fe4000780c0ffULL,
0x0000005467ff7212ULL, 0x080fe4000786c0ffULL, 0x0000005471ff7212ULL, 0x080fe4000784c0ffULL,
0x000000546fff7212ULL, 0x000fe400078cc0ffULL, 0x000000146bff7212ULL, 0x000fe200078ac0ffULL,
0x0000000155697824ULL, 0x100fe200078e0a47ULL, 0x0000004b47637210ULL, 0x000fe20007ffe1ffULL,
0x0000000149477824ULL, 0x000fe200078e0a47ULL, 0x0000000b7200720cULL, 0x000fc40000f21470ULL,
0x0000000b7200720cULL, 0x080fe40001f61470ULL, 0x0000000b3500720cULL, 0x0c0fe40002781470ULL,
0x0000000b3500720cULL, 0x080fe40001741470ULL, 0x0000000b5700720cULL, 0x0c0fe40000701470ULL,
0x0000000b5700720cULL, 0x080fe400037c1470ULL, 0x0000000b4a00720cULL, 0x000fc40002fa1470ULL,
0x0000000b7000720cULL, 0x0c0fe40000f21070ULL, 0x0000000b7000720cULL, 0x080fe40001f61070ULL,
0x0000000b6e00720cULL, 0x0c0fe40002781070ULL, 0x0000000b6e00720cULL, 0x080fe40001741070ULL,
0x0000000b6c00720cULL, 0x0c0fe40000701070ULL, 0x0000000b6c00720cULL, 0x000fc400037c1070ULL,
0x0000000b4600720cULL, 0x000fe40002fa1070ULL, 0x0000006943697219ULL, 0x040fe400000006ffULL,
0x0000006343637219ULL, 0x040fe400000006ffULL, 0x0000004743477219ULL, 0x000fe400000006ffULL,
0x0000541018187816ULL, 0x000fe4000000001bULL, 0xff80000034347808ULL, 0x000fc40000800000ULL,
0xff80000031317808ULL, 0x000fe40001800000ULL, 0xff80000050507808ULL, 0x000fe40002000000ULL,
0xff80000052527808ULL, 0x000fe40001000000ULL, 0xff80000051517808ULL, 0x000fe40000000000ULL,
0xff80000053537808ULL, 0x000fe40003000000ULL, 0xff8000004c4c7808ULL, 0x000fc40002800000ULL,
0x0000001469ff7212ULL, 0x080fe4000782c0ffULL, 0x0000001463ff7212ULL, 0x080fe4000786c0ffULL,
0x0000001447ff7212ULL, 0x000fe4000788c0ffULL, 0x000000186bff7212ULL, 0x080fe4000784c0ffULL,
0x0000001869ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001863ff7212ULL, 0x000fc400078cc0ffULL,
0x0000001847ff7212ULL, 0x000fe400078ac0ffULL, 0x0000000b4a00720cULL, 0x080fe40001741470ULL,
0x0000000b5500720cULL, 0x0c0fe40000f21470ULL, 0x0000000b5500720cULL, 0x080fe40000701470ULL,
0x0000000b4b00720cULL, 0x0c0fe40001f61470ULL, 0x0000000b4b00720cULL, 0x000fc400037c1470ULL,
0x0000000b4900720cULL, 0x0c0fe40002781470ULL, 0x0000000b4900720cULL, 0x080fe40002fa1470ULL,
0x0000000b4600720cULL, 0x080fe40001741070ULL, 0x0000000b6a00720cULL, 0x0c0fe40000f21070ULL,
0x0000000b6a00720cULL, 0x080fe40000701070ULL, 0x0000000b6800720cULL, 0x000fc40001f61070ULL,
0x0000000b6800720cULL, 0x080fe400037c1070ULL, 0x0000000b6600720cULL, 0x0c0fe40002781070ULL,
0x0000000b6600720cULL, 0x000fe40002fa1070ULL, 0xff8000004d4d7808ULL, 0x000fe40000800000ULL,
0xff8000002c2c7808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fc40002000000ULL,
0xff8000004e4e7808ULL, 0x000fe40001000000ULL, 0xff8000004f4f7808ULL, 0x000fe40000000000ULL,
0xff8000002e2e7808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fce0002800000ULL,
0x000000211000720bULL, 0x004fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0xfffffff8ff0c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff607224ULL, 0x000fe200078e006dULL,
0x0000001021107208ULL, 0x000fc80004000000ULL, 0x0000001d1000720bULL, 0x000fc80003f1e000ULL,
0x000000101d0b7208ULL, 0x000fc80004000000ULL, 0x000000280b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b28107208ULL, 0x000fc80004000000ULL, 0x000000291000720bULL, 0x000fc80003f1e000ULL,
0x00000010290b7208ULL, 0x000fc80004000000ULL, 0x000000240b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b24107208ULL, 0x000fc80004000000ULL, 0x000000251000720bULL, 0x000fc80003f1e000ULL,
0x00000010250b7208ULL, 0x000fc80004000000ULL, 0x0000001c0b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b1c0b7208ULL, 0x000fc80004000000ULL, 0x000000200b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b200b7208ULL, 0x000fc80004000000ULL, 0x000000320b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b320b7208ULL, 0x000fc80004000000ULL, 0x000000340b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b340b7208ULL, 0x000fc80004000000ULL, 0x000000500b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b50107208ULL, 0x000fe40004000000ULL, 0x0000001e1100720bULL, 0x000fe40003f1e000ULL,
0x000000511000720bULL, 0x000fc80003f3e000ULL, 0x00000010510b7208ULL, 0x000fe40004800000ULL,
0x000000111e107208ULL, 0x000fe40004000000ULL, 0x0000004c0b00720bULL, 0x000fe40003f3e000ULL,
0x0000001f1000720bULL, 0x000fe40003f1e000ULL, 0x0000000b4c147208ULL, 0x000fe40004800000ULL,
0x000000101f0b7208ULL, 0x000fc40004000000ULL, 0x0000004d1400720bULL, 0x000fe40003f3e000ULL,
0x0000002a0b00720bULL, 0x000fe40003f1e000ULL, 0x000000144d117208ULL, 0x000fe40004800000ULL,
0x0000000b2a107208ULL, 0x000fe40004000000ULL, 0x0000002c1100720bULL, 0x000fe40003f3e000ULL,
0x0000002b1000720bULL, 0x000fc40003f1e000ULL, 0x000000112c147208ULL, 0x000fe40004800000ULL,
0x000000102b0b7208ULL, 0x000fe40004000000ULL, 0x0000002d1400720bULL, 0x000fe40003f3e000ULL,
0x000000260b00720bULL, 0x000fe40003f1e000ULL, 0x000000142d147208ULL, 0x000fe40004800000ULL,
0x0000000b26107208ULL, 0x000fc60004000000ULL, 0x0c401f0014117f89ULL, 0x000ea200000e0000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x00000010270b7208ULL, 0x000fc80004000000ULL,
0x000000220b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b22107208ULL, 0x000fc80004000000ULL,
0x000000231000720bULL, 0x000fc80003f1e000ULL, 0x0000001023107208ULL, 0x000fe40004000000ULL,
0x000000111400720bULL, 0x004fe40003f3e000ULL, 0x000000331000720bULL, 0x000fe40003f1e000ULL,
0x0000001411117208ULL, 0x000fe40004800000ULL, 0x0000001033107208ULL, 0x000fc60004000000ULL,
0x0c201f0011147f89ULL, 0x000ea200000e0000ULL, 0x000000311000720bULL, 0x000fc80003f1e000ULL,
0x00000010310b7208ULL, 0x000fc80004000000ULL, 0x000000520b00720bULL, 0x000fc80003f1e000ULL,
0x0000000b52107208ULL, 0x000fc80004000000ULL, 0x000000531000720bULL, 0x000fc80003f1e000ULL,
0x00000010530b7208ULL, 0x000fe40004000000ULL, 0x000000141100720bULL, 0x004fe40003f3e000ULL,
0x0000004e0b00720bULL, 0x000fe40003f1e000ULL, 0x0000001114107208ULL, 0x000fe40004800000ULL,
0x0000000b4e147208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b10157820ULL, 0x000fe20000410000ULL,
0x0000004f1400720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010815ULL,
0x000000144f0b7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010815ULL,
0x0000002e0b00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b32187823ULL, 0x100fe20000010815ULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010815ULL,
0x0000000b2e147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010815ULL,
0x0000002f1400720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b501a7823ULL, 0x100fe20000010815ULL,
0x0000001d00167308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b51197823ULL, 0x100fe20000010815ULL,
0x000000142f147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4d357823ULL, 0x000fc80000010815ULL,
0x0c401f00140b7f89ULL, 0x000ee200000e0000ULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002900297308ULL, 0x000f300000000800ULL, 0x0000002500367308ULL, 0x000be20000000800ULL,
0x0000000b1400720bULL, 0x008fce0003f1e000ULL, 0x00000024001b7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2c257823ULL, 0x122fe20000010815ULL, 0x3fb8aa3b2d2c7823ULL, 0x100fe20000010815ULL,
0x000000140b117208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b340b7823ULL, 0x000fc80000010815ULL,
0x0c201f0011147f89ULL, 0x000e6200000e0000ULL, 0x0000001c001d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4c247823ULL, 0x008fce0000010815ULL, 0x0000002000387308ULL, 0x000ff00000000800ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x000000141100720bULL, 0x002fce0003f1e000ULL,
0x0000001900197308ULL, 0x000e620000000800ULL, 0x0000001114117208ULL, 0x000fe40004000000ULL,
0x000000211614723eULL, 0x004fe400000010ffULL, 0x000000282916723eULL, 0x010fe200000010ffULL,
0x3fb8aa3b11327820ULL, 0x000fe40000410000ULL, 0x0000001800187308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b22227823ULL, 0x000fc40000010832ULL, 0x0000001e00157308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010832ULL, 0x0000001f001c7308ULL, 0x000ee20000000800ULL,
0x00000004ff1e7e24ULL, 0x004fe4000f8e00ffULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010832ULL, 0x0000001a191a723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010832ULL, 0x3f8000001e28783eULL, 0x000fe200000010ffULL,
0x3fb8aa3b4f4f7823ULL, 0x000fe20000010832ULL, 0x0000002a00177308ULL, 0x000fe20000000800ULL,
0x0000001d381e723eULL, 0x000fc400000010ffULL, 0x000000ffff297224ULL, 0x000fe200078e0028ULL,
0x000000030c327819ULL, 0x000fe400000006ffULL, 0x000000151c15723eULL, 0x008fe400000010ffULL,
0x0000002b00207308ULL, 0x000e620000000800ULL, 0x0000001b361c723eULL, 0x000fce00000010ffULL,
0x00000022002d7308ULL, 0x000fe20000000800ULL, 0x000000172017723eULL, 0x002fce00000010ffULL,
0x00000023002a7308ULL, 0x0002b00000000800ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000281420723cULL, 0x002fe200000418ffULL, 0x0000002d2a1f723eULL, 0x004fcc00000010ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x000000030d2d7812ULL, 0x000fe200078ec0ffULL,
0x000008005d2a7824ULL, 0x000fc600078e0202ULL, 0x0000000c2d0d7210ULL, 0x000fc60007ffe0ffULL,
0x0000000b000b7308ULL, 0x000ea40000000800ULL, 0x000000040d2b7836ULL, 0x000fe20000000000ULL,
0x00000026271d723eULL, 0x002fca00000010ffULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x0c401f0012277f89ULL, 0x000e6200000e0000ULL, 0xfffffff8322b7812ULL, 0x000fe400078ee22bULL,
0x000110002a327810ULL, 0x000fe20007ffe0ffULL, 0x0c401f0013267f89ULL, 0x000ee200000e0000ULL,
0x000000281c20723cULL, 0x000fe20000041820ULL, 0x000000180b18723eULL, 0x004fe200000010ffULL,
0x0000003100347308ULL, 0x000ea80000000800ULL, 0x000000ffff2a7224ULL, 0x000fc800078e001cULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x000000333419723eULL, 0x004fce00000010ffULL,
0x00000053001b7308ULL, 0x000ea20000000800ULL, 0x000000271200720bULL, 0x002fc80003f1e000ULL,
0x0000001227127208ULL, 0x000fe40004000000ULL, 0x000000261300720bULL, 0x008fe20003f3e000ULL,
0x0000002e002e7308ULL, 0x000fe40000000800ULL, 0x0c201f00120b7f89ULL, 0x000e6200000e0000ULL,
0x0000001326137208ULL, 0x000fe40004800000ULL, 0x000000521b1b723eULL, 0x004fc600000010ffULL,
0x0000002f002f7308ULL, 0x000ea80000000800ULL, 0x000000281820723cULL, 0x000fe80000041820ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x0000002e2f27723eULL, 0x004fce00000010ffULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000080c2e7824ULL, 0x000fe200078e00ffULL,
0x0000000b1200720bULL, 0x002fe20003f1e000ULL, 0x000000ffff2f7224ULL, 0x000fc600078e0028ULL,
0xfffffff82e297812ULL, 0x000fe200078ee20dULL, 0x0000000c0d0d7836ULL, 0x000fe20000000000ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x00000028002e7202ULL, 0x000fe40000000f00ULL,
0x000000120b127208ULL, 0x000fe20004000000ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000305ff7812ULL, 0x000fe4000780c0ffULL, 0x000000252c26723eULL, 0x004fe200000010ffULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x000000080c2c7836ULL, 0x000fc40000000000ULL,
0x0c201f00130c7f89ULL, 0x000ea400000e0000ULL, 0x000000012d2d7824ULL, 0x000fe400078e022cULL,
0x000000082c287824ULL, 0x040fe200078e00ffULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x000000082c2c7824ULL, 0x000fc600078e00ffULL, 0xfffffff8282d7812ULL, 0x000fe400078ee22dULL,
0xfffffff82c317812ULL, 0x000fe200078ee20dULL, 0x00000010290d7824ULL, 0x000fe200078e0232ULL,
0x0000004f004f7308ULL, 0x000ee20000000800ULL, 0x000000243524723eULL, 0x002fe200000010ffULL,
0x000000ffff297224ULL, 0x000fe200078e0016ULL, 0x0000001400287202ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x00000018002c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff157224ULL, 0x000fe200078e0017ULL, 0x0000001f00177202ULL, 0x000fe20000000f00ULL,
0x000000ffff187224ULL, 0x000fe200078e0019ULL, 0x0000003231317211ULL, 0x000fe200078e20ffULL,
0x000000ffff167224ULL, 0x000fe200078e001dULL, 0x0000000c1300720bULL, 0x004fe20003f3e000ULL,
0x000000ffff197224ULL, 0x000fe200078e001bULL, 0x00000027001b7202ULL, 0x000fc40000000f00ULL,
0x0000004e4f25723eULL, 0x008fe400000010ffULL, 0x000000130c137208ULL, 0x000fca0004800000ULL,
0x0000002e2420723cULL, 0x000fee0000041820ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0024ULL,
0x000000ffff2f7224ULL, 0x000fd600078e0026ULL, 0x000000102b217824ULL, 0x100fe400078e0232ULL,
0x000000102d237824ULL, 0x000fe400078e0232ULL, 0x000000ffff2b7224ULL, 0x000fe400078e001eULL,
0x000000ffff2d7224ULL, 0x000fe400078e001aULL, 0x000000ffff1a7224ULL, 0x000fe200078e0025ULL,
0x000000280d007844ULL, 0x000fe80000000200ULL, 0x0000002c21007844ULL, 0x0003e80000000200ULL,
0x0000001423007844ULL, 0x0005e80000000200ULL, 0x0000001831007844ULL, 0x0005e80000000200ULL,
0x01b0001030008388ULL, 0x0005e20000000c00ULL, 0x000000ffff217224ULL, 0x002fca00078e0022ULL,
0x01b2002030008388ULL, 0x0005e20000000a00ULL, 0x0000005a6d00720cULL, 0x000fe20003f06070ULL,
0x01b6080b0aff79a7ULL, 0x0005e2000850003fULL, 0x01b6100b0aff79a7ULL, 0x0005e2000850003fULL,
0x01b6180b0aff79a7ULL, 0x0005e2000850003fULL, 0x01b6200b0aff79a7ULL, 0x0005f2000850003fULL,
0xffffff9800cc8947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000053047810ULL, 0x000fe20007ffe0ffULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x7f80000004097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f05070ULL,
0x0000005300048308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f25070ULL, 0x008000000900780cULL, 0x000fe40003f02070ULL,
0x00000001ff097807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000409ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff53ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000409ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000053097812ULL, 0x000fd600078ec0ffULL,
0x0080000009040812ULL, 0x000fe200078efcffULL, 0x000000ffff048224ULL, 0x000fe200078e0009ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000005300047308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffffec008cc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000495ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000210ULL,
0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000000d0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008f0ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000944ULL, 0x0000000000000470ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000db8ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000db8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000013d80ULL,
0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014c00ULL, 0x000000000000003cULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014c40ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000014c40ULL, 0x0000000000000278ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000015238ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015238ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000013d80ULL, 0x0000000000013d80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000014c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000014c40ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000278ULL, 0x0000000000000278ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_90_cubin_len = 86920;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
