/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000160c0ULL, 0x0000000000015d40ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x4c6a496365563349ULL, 0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL,
0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL,
0x70776f6c735f3233ULL, 0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL,
0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL,
0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL,
0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL,
0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL,
0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL,
0x612e6c65722e766eULL, 0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000208ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000002e3ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000331ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b0022000003bdULL, 0x0000000000014430ULL, 0x0000000000000170ULL,
0x000b0022000003f0ULL, 0x00000000000145a0ULL, 0x0000000000000040ULL, 0x000b00220000041bULL,
0x00000000000145e0ULL, 0x0000000000000050ULL, 0x000b002200000445ULL, 0x0000000000014630ULL,
0x0000000000000150ULL, 0x000a0003000004b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000004d3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000503ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000014780ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001443000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x004f8c0400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080830828808081ULL, 0x8608288080850828ULL, 0x2880808908288080ULL, 0x808c082880808b08ULL,
0x082880808d082880ULL, 0x80808f082880808eULL, 0xa408288080920828ULL, 0x288080ab08288080ULL,
0x808408288080b208ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080849200ULL,
0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001443000000000ULL, 0x0000017000000000ULL,
0x0000480400000000ULL, 0x8083288080850900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8608288080850828ULL, 0x2880808b08288080ULL, 0x808e082880808d08ULL,
0x082880808f082880ULL, 0x8080a40828808092ULL, 0xb208288080ab0828ULL, 0x2880808c08288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880808cULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x000145a000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8608288080850828ULL, 0x2880808908288080ULL,
0x808c082880808b08ULL, 0x082880808d082880ULL, 0x808092082880808eULL, 0xab08288080a40828ULL,
0x288080b208288080ULL, 0x8280162880808f08ULL, 0x0000000003102880ULL, 0x80808f9200000000ULL,
0x0000000000220028ULL, 0x0000002cffffffffULL, 0x000001d800000000ULL, 0x000145e000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808e2880808f0900ULL, 0x0000000000002880ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8608288080850828ULL, 0x2880808908288080ULL,
0x808c082880808b08ULL, 0x082880808d082880ULL, 0x808092082880808fULL, 0xab08288080a40828ULL,
0x288080b208288080ULL, 0x8280162880808e08ULL, 0x0000000003102880ULL, 0x80808e9200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000029800000000ULL, 0x0001463000000000ULL,
0x0000015000000000ULL, 0x0000000000000000ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL,
0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL,
0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL, 0x0000001500080a04ULL,
0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f0000060000aULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0011f00000500008ULL, 0x00000000000c1704ULL,
0x0081f00000300007ULL, 0x00000000000c1704ULL, 0x0021f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL,
0x0154290400000b20ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01542804ffffffffULL,
0x0000051000000330ULL, 0x00001c0000000540ULL, 0x00002e2000002d60ULL, 0x000030a000002f40ULL,
0x000032d0000032a0ULL, 0x0000337000003320ULL, 0x000049b000003a60ULL, 0x00004b7000004a40ULL,
0x00004ee000004cd0ULL, 0x00004f6000004f10ULL, 0x0000539000004fb0ULL, 0x00006430000063a0ULL,
0x000066c000006560ULL, 0x00006900000068d0ULL, 0x000069a000006950ULL, 0x00007da000006db0ULL,
0x00007f7000007e40ULL, 0x000082e0000080d0ULL, 0x0000836000008310ULL, 0x00008900000083b0ULL,
0x0000ad1000008910ULL, 0x0000b4a00000ad60ULL, 0x00012cb00000b4e0ULL, 0x00012d0000012cf0ULL,
0x00012d2000012d10ULL, 0x00012da000012d80ULL, 0x00013a7000012dc0ULL, 0x00013b0000013ab0ULL,
0x00013b9000013b40ULL, 0x00013c3000013be0ULL, 0x00013cc000013c70ULL, 0x00013d5000013d00ULL,
0x00013df000013da0ULL, 0x00013e8000013e30ULL, 0x00013f1000013ec0ULL, 0x00013fb000013f60ULL,
0x0001404000013ff0ULL, 0x000140d000014080ULL, 0x0001417000014120ULL, 0x00014230000141d0ULL,
0x000142f000014290ULL, 0x000143b000014350ULL, 0x0200390400014410ULL, 0x000000ff000003f0ULL,
0x003f010000013600ULL, 0x0000000d00000440ULL, 0x003f012000013608ULL, 0x0000000d000004b0ULL,
0x003f012000013688ULL, 0x000000ff00000b40ULL, 0x003f010700013600ULL, 0x0000006d00000d40ULL,
0x003f01020001368cULL, 0x0000006d00000e10ULL, 0x003f010100013688ULL, 0x0000000a00002a60ULL,
0x003f010100013608ULL, 0x0000000a00002a80ULL, 0x003f01050001360cULL, 0x0000000a00002c50ULL,
0x003f01050001360cULL, 0x0000004e000039e0ULL, 0x003f010100013688ULL, 0x0000003400004710ULL,
0x003f010100013628ULL, 0x0000003400004730ULL, 0x003f01050001362cULL, 0x0000003400004900ULL,
0x003f01050001362cULL, 0x0000000e00005340ULL, 0x003f010100000000ULL, 0x0000000900006100ULL,
0x003f010100013648ULL, 0x0000000900006120ULL, 0x003f01050001364cULL, 0x00000009000062f0ULL,
0x003f01050001364cULL, 0x0000000c00006d90ULL, 0x003f010100000000ULL, 0x0000001e00007b00ULL,
0x003f010100013668ULL, 0x0000001e00007b20ULL, 0x003f01050001366cULL, 0x0000001e00007cf0ULL,
0x003f01050001366cULL, 0x00000008000087a0ULL, 0x003f010100000000ULL, 0x000000ff0000c6b0ULL,
0x003f010100013600ULL, 0x000000ff0000d2b0ULL, 0x003f010500013604ULL, 0x000000ff0000d4c0ULL,
0x003f010500013604ULL, 0x00000074000110d0ULL, 0x003f010100000000ULL, 0x0000007400011120ULL,
0x003f010500000004ULL, 0x00000074000112f0ULL, 0x003f010500000004ULL, 0x00000075000138d0ULL,
0x003f010100013608ULL, 0x0000007500013930ULL, 0x003f010100013610ULL, 0x0000007500013990ULL,
0x003f010100013618ULL, 0x0000007500013a00ULL, 0x003f010100013620ULL, 0x00201c0400033803ULL,
0x0000bd500000bd20ULL, 0x0000c1d00000bfe0ULL, 0x0000c5800000c3d0ULL, 0x00013a400000d520ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000334ULL, 0x0000001800000002ULL,
0x0000000000000274ULL, 0x0000001800000002ULL, 0x00000000000001c4ULL, 0x0000001800000002ULL,
0x000000000000010cULL, 0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL,
0x000000000000030cULL, 0x0000001800000002ULL, 0x000000000000024cULL, 0x0000001800000002ULL,
0x000000000000019fULL, 0x0000001800000002ULL, 0x00000000000000e9ULL, 0x0000001800000002ULL,
0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000797919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x0000000179020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c0079040625ULL, 0x000fe200078e0004ULL, 0x0000000602000981ULL, 0x0002aa000c1e1900ULL,
0x0000000604050981ULL, 0x0006a2000c1e1900ULL, 0x0000590000087b06ULL, 0x000f220000209000ULL,
0x00005900ff767624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000000b7919ULL, 0x000e620000002300ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff0c7624ULL, 0x000fc400078e00ffULL, 0x00000000000a7919ULL, 0x000e640000002100ULL,
0x000059000c0c7a24ULL, 0x000fe200078e02ffULL, 0x0000000800087308ULL, 0x010f240000001000ULL,
0x0ffffffe08067810ULL, 0x010fe40007ffe0ffULL, 0x0000000000087919ULL, 0x000f280000002600ULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x000000ffff067224ULL, 0x002fc400078e00ffULL,
0x000000ffff097224ULL, 0x008fc800078e0a07ULL, 0x0000590009097a24ULL, 0x000fc800078e02ffULL,
0x0000000907077227ULL, 0x000fcc00078e0006ULL, 0x0000040007097a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a09ULL, 0x0000040003027624ULL, 0x000fca00078e0276ULL,
0x0000590002007a0cULL, 0x000fda0003f26070ULL, 0x8000590002021a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x0000590002007a0cULL, 0x000fda0003f46070ULL,
0x0000000109092810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff09ba12ULL, 0x000fc800078e33ffULL,
0x0000000900047306ULL, 0x000e620000209000ULL, 0x000000ff0900720cULL, 0x000fce0003fa5070ULL,
0x0000000400047308ULL, 0x002e640000001000ULL, 0x0ffffffe04027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002e4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000309067224ULL, 0x008fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a06ULL,
0x0000000000067919ULL, 0x000e640000002200ULL, 0x0000000703037227ULL, 0x000fcc00078e0002ULL,
0x0000000803707227ULL, 0x010fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a70ULL,
0x0000000309027224ULL, 0x000fca00078e0208ULL, 0x000000090200720cULL, 0x000fe20003f66070ULL,
0x000001000b037a24ULL, 0x002fe400078e0206ULL, 0x00001fff0b0b7589ULL, 0x000fe400000e0000ULL,
0x00000000030d7a24ULL, 0x000fca00078e020aULL, 0x000000ff0d00720cULL, 0x000fc60003f25270ULL,
0x0000000102023824ULL, 0x000fe200078e0a09ULL, 0x0000000170703810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0d00780cULL, 0x040fe40003f44070ULL, 0x000000090200720cULL, 0x000fe40003f86070ULL,
0x000000030d00780cULL, 0x000fc60003f64070ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fc800078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL,
0x0000000170704810ULL, 0x000fe20007ffe0ffULL, 0x01360002ff009388ULL, 0x0003e20000000a00ULL,
0x00000009ff70d212ULL, 0x000fe200078e33ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x0000007f0d00780cULL, 0x000fc60003f84070ULL, 0x000000ffff737224ULL, 0x000fe200078e0a70ULL,
0x013608060d00a388ULL, 0x000fe60000008a00ULL, 0x0000007309737224ULL, 0x000fe400078e0208ULL,
0x3fffff60ff08b424ULL, 0x000fe400078e00ffULL, 0x0000001073737824ULL, 0x000fe400078e00ffULL,
0xff317217ff0ec424ULL, 0x000fc400078e00ffULL, 0x7fffff60ff09b424ULL, 0x000fc600078e00ffULL,
0x0134000e0d00c388ULL, 0x000fe80000004800ULL, 0x013688080d00b388ULL, 0x000fe20000008a00ULL,
0x0000000100040824ULL, 0x004fe200078e0a05ULL, 0x00000005ff007819ULL, 0x000fe2000001160aULL,
0x00005800ff048624ULL, 0x000fe400078e00ffULL, 0x0000580079058a24ULL, 0x000fe400078e02ffULL,
0x00005a00040a7a24ULL, 0x000fe200078e02ffULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x0000000c05747224ULL, 0x000fc400078e02ffULL, 0x000000010a027824ULL, 0x042fe200078e0a73ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000730a00720cULL, 0x000fe20003f26070ULL,
0x00005a0070117a24ULL, 0x000fe200078e0274ULL, 0x0000001002027817ULL, 0x000fc80003800000ULL,
0x000000ff02727207ULL, 0x000fe20000800000ULL, 0x00000004ff027e24ULL, 0x000fc6000f8e00ffULL,
0x000000107200780cULL, 0x000fe20003f05270ULL, 0x000000040b037824ULL, 0x004fc800078e0200ULL,
0x0000000203087824ULL, 0x000fd000078e00ffULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a0000097b06ULL, 0x000e620000209000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000ff00067202ULL, 0x000fe40000000f00ULL, 0x00005a00ff007a0cULL, 0x000fc80003f45070ULL,
0x0000000900097308ULL, 0x002e620000001000ULL, 0x00000004ff0d7819ULL, 0x004fca0000011603ULL,
0x00000001080a7824ULL, 0x000fe200078e020dULL, 0x0ffffffe09077810ULL, 0x002fcc0007ffe0ffULL,
0x0000000700077305ULL, 0x000e64000021f000ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a07ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f070f7227ULL, 0x000fc800078e0006ULL,
0x0000000173067824ULL, 0x000fc800078e020aULL, 0x000000060f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a0fULL, 0x00005a0009077a24ULL, 0x000fe200078e0206ULL,
0x0000000872097217ULL, 0x000fc80007800000ULL, 0x00005a0007007a0cULL, 0x000fda0003f06070ULL,
0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL, 0x000000010f0f0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fda0003f26070ULL, 0x000000010f0f1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0faa12ULL, 0x000fca00078e33ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0fULL,
0x00005a0007067a24ULL, 0x000fe400078e0206ULL, 0x0000001003077824ULL, 0x000fe400078e00ffULL,
0x0000000111067824ULL, 0x000fc800078e0206ULL, 0x0000000c0f0f7224ULL, 0x000fe400078e0206ULL,
0x0000000109067824ULL, 0x000fe400078e0a08ULL, 0x000001000f087825ULL, 0x000fe200078e00ffULL,
0x000000f0070f7812ULL, 0x000fe400078ec0ffULL, 0x000000060d00720cULL, 0x000fe20003f06070ULL,
0x000000010a067824ULL, 0x000fe200078e0203ULL, 0x0000000f080f7212ULL, 0x000fe200078efcffULL,
0x000000100a0d7824ULL, 0x000fc600078e00ffULL, 0x000060000f087a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00d067812ULL, 0x000fe400078ee206ULL, 0x0000610009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000010060d7824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a0000097b06ULL, 0x000e620000209000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000900097308ULL, 0x002e620000001000ULL, 0x00000008030a7211ULL, 0x004fe400078fe0ffULL,
0x0ffffffe090d7810ULL, 0x002fca0007ffe0ffULL, 0x0000000d00077305ULL, 0x000e64000021f000ULL,
0x000000ffff0f7224ULL, 0x002fc800078e0a07ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f07077227ULL, 0x000fc800078e0006ULL, 0x0000000173067824ULL, 0x000fc800078e020aULL,
0x0000000607077227ULL, 0x000fc800078e00ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a07ULL,
0x00005a0009087a24ULL, 0x000fca00078e0206ULL, 0x00005a0008007a0cULL, 0x000fda0003f06070ULL,
0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff07aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a07ULL,
0x00005a0009067a24ULL, 0x000fc800078e0206ULL, 0x0000000111067824ULL, 0x000fc800078e0206ULL,
0x0000000c07067224ULL, 0x000fe400078e0206ULL, 0x0000001003077824ULL, 0x000fe400078e00ffULL,
0x0000010006087825ULL, 0x000fc600078e00ffULL, 0x000000f0070d7812ULL, 0x000fe200078ec0ffULL,
0x000000010a067824ULL, 0x000fc600078e0203ULL, 0x0000000d08087212ULL, 0x000fe200078efcffULL,
0x000000100a0d7824ULL, 0x000fc600078e00ffULL, 0x0000600008087a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff00d067812ULL, 0x000fe400078ee206ULL, 0x0000610009097a10ULL, 0x000fc600007fe4ffULL,
0x00000010060d7824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000097919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff4c7424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600087300ULL, 0x000e7000000e0000ULL,
0x00000006000a7309ULL, 0x000ea20000000000ULL, 0x000000090800720cULL, 0x002fe20003f02070ULL,
0x0000680079087625ULL, 0x000fc800078e004cULL, 0x000000ffff0a7224ULL, 0x004fd000078e0a0aULL,
0x0136040affff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01360000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608637981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f63717810ULL, 0x044fe40007ffe0ffULL,
0x000000ff63677810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff717819ULL, 0x000fe40000011671ULL,
0x00000008ff677819ULL, 0x000fca0000011667ULL, 0x0000b91000008947ULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x000fe20000011600ULL, 0x00000008006d7824ULL, 0x000fe400078e00ffULL,
0x00000003ff067424ULL, 0x000fe200078e00ffULL, 0x01ffffff040b7812ULL, 0x000fe200078ec0ffULL,
0xffffffffff597424ULL, 0x000fc800078e00ffULL, 0x00000002020b7824ULL, 0x000fca00078e020bULL,
0x000000710b00720cULL, 0x000fda0003f06070ULL, 0x0000000279048824ULL, 0x000fe400078e00ffULL,
0x00006a00ff058624ULL, 0x000fc800078e00ffULL, 0x00006a0004048624ULL, 0x000fca00078e0205ULL,
0x000000040b4d8210ULL, 0x000fe20007ffe0ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01368c066dff738cULL, 0x0005e20000000000ULL, 0x000066004d4c8625ULL, 0x000fe200078e004cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000064c598981ULL, 0x000ee2000c1e1900ULL,
0x0000000102067810ULL, 0x004fe20007ffe0ffULL, 0x0000008070697824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x002fe20000011600ULL, 0x00000100ff057424ULL, 0x000fe200078e00ffULL,
0x000000670600720cULL, 0x000fe20003f06070ULL, 0x013688006dff7f8cULL, 0x0003e2000c80043fULL,
0x00000001006b7812ULL, 0x000fe200078ec0ffULL, 0x000000200a6e7824ULL, 0x000fc800078e00ffULL,
0x0000010002087824ULL, 0x000fca00078e026eULL, 0x00000060690e7812ULL, 0x000fe200078ef808ULL,
0x0000590059047a24ULL, 0x008fc800078e02ffULL, 0x0000008004047824ULL, 0x000fc800078e00ffULL,
0x0000640004047625ULL, 0x000fe200078e0005ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff187819ULL, 0x002fe20000011603ULL, 0x000000020a177824ULL, 0x000fe200078e026bULL,
0x0000000863067217ULL, 0x000fe40007800000ULL, 0x00000004180c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c18167810ULL, 0x000fe20007ffe0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a08ULL,
0x0000000818107810ULL, 0x000fe20007ffe0ffULL, 0x000000010c087824ULL, 0x100fe200078e0203ULL,
0x00000014181c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080c1b7824ULL, 0x000fe200078e00ffULL,
0x00000020060f7817ULL, 0x000fe20003800000ULL, 0x00000001160d7824ULL, 0x100fe200078e0203ULL,
0x00000010181a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000816147824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL, 0x0000000110097824ULL, 0x040fe200078e0203ULL,
0x0000007007087812ULL, 0x000fe200078ec0ffULL, 0x0000000810127824ULL, 0x000fe200078e00ffULL,
0xfffffff8141f7812ULL, 0x000fe200078ee20dULL, 0x000000010e0d7824ULL, 0x000fe200078e020cULL,
0x0000000f0c00720cULL, 0x080fe20003f86070ULL, 0x000000806b067824ULL, 0x000fe200078e0208ULL,
0xfffffff8121d7812ULL, 0x000fe200078ee209ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000f1000720cULL, 0x080fe20003f66070ULL, 0x000000010e097824ULL, 0x000fe200078e0218ULL,
0x0000000f1600720cULL, 0x080fe20003f46070ULL, 0x000001000d0c7825ULL, 0x000fe200078e0006ULL,
0x0000000f1800720cULL, 0x000fc60003fa6070ULL, 0x0000010009087825ULL, 0x000fe200078e0006ULL,
0x0000000c04147210ULL, 0x000fc60007f3e0ffULL, 0x000000011c137824ULL, 0x000fe200078e0203ULL,
0x0000000804127210ULL, 0x000fe20007f1e0ffULL, 0x000000081c207824ULL, 0x000fe400078e00ffULL,
0x0000000105157824ULL, 0x000fe200008e060dULL, 0x0000000f1a00720cULL, 0x040fe20003f26070ULL,
0x000000011a117824ULL, 0x000fe200078e0203ULL, 0xfffffff820257812ULL, 0x000fe200078ee213ULL,
0x000000081a1e7824ULL, 0x000fe400078e00ffULL, 0x000000010e0d7824ULL, 0x000fc400078e0216ULL,
0x0000000105137824ULL, 0x000fe200000e0609ULL, 0xfffffff81e217812ULL, 0x000fe200078ee211ULL,
0x000000010e097824ULL, 0x000fe400078e0210ULL, 0x0000000118107824ULL, 0x000fe400078e0203ULL,
0x000001000d0c7825ULL, 0x000fc600078e0006ULL, 0x0000000710167812ULL, 0x000fe200078ec0ffULL,
0x000000010e117824ULL, 0x000fe200078e021aULL, 0x0000000c040c7210ULL, 0x000fe20007fde0ffULL,
0x0000010009087825ULL, 0x000fe200078e0006ULL, 0x0000b000171a7811ULL, 0x000fe400078e68ffULL,
0x0ffffff816177812ULL, 0x000fe200078ef803ULL, 0x0000010011107825ULL, 0x000fe200078e0006ULL,
0x0000000804087210ULL, 0x000fc60007f1e0ffULL, 0x00000001050d7824ULL, 0x040fe200030e060dULL,
0x0000001004167210ULL, 0x000fe20007fde0ffULL, 0x000000010e237824ULL, 0x000fe200078e021cULL,
0x0000000905097210ULL, 0x000fe200007fe4ffULL, 0x0000001017197824ULL, 0x100fe200078e021aULL,
0x0000000f1c00720cULL, 0x080fe20003f06070ULL, 0x0000000105177824ULL, 0x000fe200030e0611ULL,
0x00000018181c7810ULL, 0x040fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e021aULL,
0x0000001c18187810ULL, 0x000fe20007ffe0ffULL, 0x0000010023107825ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012197faeULL, 0x0003e2000e901c46ULL,
0x0000000f1c00720cULL, 0x000fc40003fa6070ULL, 0x000000010e237824ULL, 0x000fe200078e021cULL,
0x00000000141b7faeULL, 0x0005e2000e101c46ULL, 0x0000001004107210ULL, 0x000fe20007fde0ffULL,
0x000000010e277824ULL, 0x000fe200078e0218ULL, 0x0000000f1800720cULL, 0x000fe20003f86070ULL,
0x00000100230e7825ULL, 0x000fc800078e0006ULL, 0x0000000105117824ULL, 0x000fe200030e0611ULL,
0x0000000e040e7210ULL, 0x000fe20007fde0ffULL, 0x000000011c127824ULL, 0x142fe400078e0203ULL,
0x000000081c137824ULL, 0x000fe400078e00ffULL, 0x0000000118147824ULL, 0x044fe400078e0203ULL,
0x0000000818157824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee212ULL,
0x0000010027067825ULL, 0x000fc600078e0006ULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x00000001050f7824ULL, 0x000fe200030e060fULL, 0x0000000604047210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe400078e021aULL, 0x000000101f1f7824ULL, 0x100fe400078e021aULL,
0x0000001021217824ULL, 0x100fe200078e021aULL, 0x00000000081d7faeULL, 0x0003e2000d901c46ULL,
0x0000001025257824ULL, 0x100fe400078e021aULL, 0x0000001013137824ULL, 0x100fe200078e021aULL,
0x000000000c1f7faeULL, 0x0003e2000d101c46ULL, 0x0000001015157824ULL, 0x000fc400078e021aULL,
0x0000000105057824ULL, 0x000fe200030e0607ULL, 0x0000000016217faeULL, 0x0003e8000c901c46ULL,
0x0000000010257faeULL, 0x0003e8000c101c46ULL, 0x000000000e137faeULL, 0x0003e8000e901c46ULL,
0x0000000004157faeULL, 0x0003e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000403087811ULL, 0x042fe200078fe8ffULL, 0x000000020a177824ULL, 0x000fe200078e026bULL,
0x00000008030c7811ULL, 0x000fc400078fe8ffULL, 0x0000000c030f7811ULL, 0x040fe200078fe8ffULL,
0x0000000108067824ULL, 0x140fe200078e0203ULL, 0x0000001003107811ULL, 0x040fe200078fe8ffULL,
0x00000008080d7824ULL, 0x000fe200078e00ffULL, 0x0000001403127811ULL, 0x000fe200078fe8ffULL,
0x000000010c097824ULL, 0x100fe200078e0203ULL, 0x0000000310207819ULL, 0x000fe200000006ffULL,
0x000000080c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d1a7812ULL, 0x000fe200078ee206ULL,
0x000000010f067824ULL, 0x000fe200078e0203ULL, 0x0000007007167812ULL, 0x000fe200078ec0ffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL,
0x0000000110097824ULL, 0x100fe200078e0203ULL, 0x0000001c03077811ULL, 0x000fe200078fe8ffULL,
0x00000001120d7824ULL, 0x040fe200078e0203ULL, 0xfffffff8131e7812ULL, 0x000fe200078ee206ULL,
0x0000000812227824ULL, 0x000fe200078e00ffULL, 0x0000001803147811ULL, 0x000fe200078fe8ffULL,
0x00000008071b7824ULL, 0x000fe200078e00ffULL, 0x0000000303067211ULL, 0x000fe200078fe8ffULL,
0x000000010e197824ULL, 0x000fe200078e0207ULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x000000010e097824ULL, 0x000fe200078e0208ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000000107087824ULL, 0x100fe200078e0203ULL, 0x0000000e03077211ULL, 0x000fe200078fe8ffULL,
0x0000000114117824ULL, 0x040fe200078e0203ULL, 0x0000b00017277811ULL, 0x000fe200078e68ffULL,
0x0000000814247824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20dULL,
0x000000806b167824ULL, 0x000fe200078e0216ULL, 0x0ffffff806187812ULL, 0x000fe200078ef803ULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0xfffffff81b267812ULL, 0x000fe200078ee208ULL,
0x000000010e0d7824ULL, 0x000fe200078e020cULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x000000010e0f7824ULL, 0x000fc400078e020fULL, 0x0000010007067825ULL, 0x000fc800078e0016ULL,
0x0000010009087825ULL, 0x000fe200078e0016ULL, 0x0000000604067210ULL, 0x000fc60007f1e0ffULL,
0x000000010e117824ULL, 0x000fe200078e0210ULL, 0x0000000804087210ULL, 0x000fe20007f3e0ffULL,
0x000001000d0c7825ULL, 0x000fc800078e0016ULL, 0x000000010e137824ULL, 0x000fe200078e0212ULL,
0x0000000c040c7210ULL, 0x000fe20007f5e0ffULL, 0x000000010e157824ULL, 0x000fe400078e0214ULL,
0x000001000f0e7825ULL, 0x000fc800078e0016ULL, 0x0000010011107825ULL, 0x000fe200078e0016ULL,
0x0000000e040e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0016ULL,
0x0000000f050f7210ULL, 0x000fc60001ffe4ffULL, 0x0000010015147825ULL, 0x000fc800078e0016ULL,
0x0000010019167825ULL, 0x000fc800078e0016ULL, 0x0000000105077824ULL, 0x040fe200000e0607ULL,
0x0000001004107210ULL, 0x040fe20007f1e0ffULL, 0x0000000105097824ULL, 0x040fe200008e0609ULL,
0x0000001204127210ULL, 0x000fe20007f3e0ffULL, 0x0000001018197824ULL, 0x000fe400078e0227ULL,
0x00000001050d7824ULL, 0x000fe200010e060dULL, 0x0000001404147210ULL, 0x000fe20007f5e0ffULL,
0x000000101a1b7824ULL, 0x100fe200078e0227ULL, 0x0000001604047210ULL, 0x000fe20007f7e0ffULL,
0x000000101c1d7824ULL, 0x100fe200078e0227ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006197faeULL, 0x0003e2000b901c46ULL, 0x000000101e1f7824ULL, 0x000fc400078e0227ULL,
0x0000001020217824ULL, 0x000fe200078e0227ULL, 0x00000000081b7faeULL, 0x0003e2000b901c46ULL,
0x0000000105117824ULL, 0x040fe400000e0611ULL, 0x0000001022237824ULL, 0x000fe200078e0227ULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x0000000105137824ULL, 0x040fe400008e0613ULL,
0x0000001024257824ULL, 0x000fe200078e0227ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000000105157824ULL, 0x000fc400010e0615ULL, 0x0000001026277824ULL, 0x000fe200078e0227ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000000105057824ULL, 0x000fc600018e0617ULL,
0x0000000012237faeULL, 0x0003e8000b901c46ULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000004277faeULL, 0x0003e4000b901c46ULL, 0x000000670200720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff0c7424ULL, 0x002fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00006c3000000947ULL, 0x000fea0003800000ULL,
0x00000002796c7824ULL, 0x000fe400078e00ffULL, 0x00006a00ff057624ULL, 0x000fc400078e00ffULL,
0xff317217ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e00ffULL,
0x00006a006c6c7624ULL, 0x000fc400078e0205ULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe008097812ULL, 0x000fe200078ec0ffULL,
0x0000590059597a24ULL, 0x010fe200078e02ffULL, 0x0000000102087810ULL, 0x000fc60007ffe0ffULL,
0x0000010002097824ULL, 0x000fe200078e0209ULL, 0x000000670800720cULL, 0x000fe20003f06070ULL,
0x0000008059087824ULL, 0x000fc600078e00ffULL, 0x0000004009247810ULL, 0x020fe20007ffe0ffULL,
0x00000100ff097424ULL, 0x000fc600078e00ffULL, 0x0000006024307812ULL, 0x000fe200078ec0ffULL,
0x0000640008087625ULL, 0x000fc800078e0009ULL, 0x0000000169307824ULL, 0x000fe200078e0230ULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x00000024630d7217ULL, 0x000fe20007800000ULL, 0x00000080000e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fe40000011603ULL, 0x000000700f257812ULL, 0x000fe200078ec0ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0a24ULL, 0x0000000438287810ULL, 0x000fe20007ffe0ffULL,
0x00002000000d7824ULL, 0x000fe200078e00ffULL, 0x0000000838367810ULL, 0x000fc40007ffe0ffULL,
0x00000080250e7812ULL, 0x000fe200078ef80eULL, 0x0000000128247824ULL, 0x140fe200078e0203ULL,
0x000020000d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000828397824ULL, 0x000fe200078e00ffULL,
0x0000000c383a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000136257824ULL, 0x040fe200078e0203ULL,
0x000000200f337817ULL, 0x000fe20003800000ULL, 0x0000000836267824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee224ULL, 0x000040000a347824ULL, 0x000fe200078e020dULL,
0x00000010383c7810ULL, 0x000fe20007ffe0ffULL, 0x000000013a317824ULL, 0x000fe200078e0203ULL,
0xfffffff8260d7812ULL, 0x000fe200078ee225ULL, 0x000000083a247824ULL, 0x000fe200078e00ffULL,
0x00000014383e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000138257824ULL, 0x000fe200078e0230ULL,
0x000000033c277819ULL, 0x000fe200000006ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0xfffffff824317812ULL, 0x000fe200078ee231ULL, 0x000000013c327824ULL, 0x000fe200078e0203ULL,
0x000000333a00720cULL, 0x080fe20003f26070ULL, 0x0000010025247825ULL, 0x000fe200078e000eULL,
0x000000332800720cULL, 0x000fc40003f66070ULL, 0xfffffff827327812ULL, 0x000fe200078ee232ULL,
0x000000013e0a7824ULL, 0x100fe200078e0203ULL, 0x00000024082a7210ULL, 0x000fe20007f5e0ffULL,
0x000000083e297824ULL, 0x000fe200078e00ffULL, 0x000000333600720cULL, 0x080fe20003f06070ULL,
0x0000000138267824ULL, 0x040fe200078e0203ULL, 0x000000333800720cULL, 0x000fe20003f86070ULL,
0x0000000128277824ULL, 0x000fe200078e0230ULL, 0xfffffff8290a7812ULL, 0x000fe200078ee20aULL,
0x0000000136297824ULL, 0x100fe200078e0230ULL, 0x0000c00034367810ULL, 0x000fe20007ffe0ffULL,
0x000000013a357824ULL, 0x000fe200078e0230ULL, 0x00000007263a7812ULL, 0x000fe200078ec0ffULL,
0x00000001092b7824ULL, 0x000fc400010e0625ULL, 0x0000010027247825ULL, 0x000fe200078e000eULL,
0x0ffffff83a377812ULL, 0x000fe400078ef803ULL, 0x00000018383a7810ULL, 0x000fe20007ffe0ffULL,
0x0000010029267825ULL, 0x100fe200078e000eULL, 0x0000002408347210ULL, 0x000fe40007f5e0ffULL,
0x0000001c38387810ULL, 0x000fe20007ffe0ffULL, 0x0000010035287825ULL, 0x000fe200078e000eULL,
0x0000002608247210ULL, 0x000fc60007fbe0ffULL, 0x0000000109357824ULL, 0x040fe200010e0625ULL,
0x0000002808267210ULL, 0x000fe20007fde0ffULL, 0x0000000109257824ULL, 0x000fe200028e0627ULL,
0x000000333c00720cULL, 0x080fe20003f46070ULL, 0x0000001037377824ULL, 0x000fe200078e0236ULL,
0x000000333e00720cULL, 0x080fe20003fa6070ULL, 0x0000000109277824ULL, 0x000fe400030e0629ULL,
0x000000013c297824ULL, 0x000fe200078e0230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a377faeULL, 0x0003e2000e101c46ULL, 0x0000001039397824ULL, 0x000fe200078e0236ULL,
0x000000333a00720cULL, 0x000fe20003f86070ULL, 0x0000010029287825ULL, 0x000fc600078e000eULL,
0x0000000034397faeULL, 0x0005e2000d901c46ULL, 0x000000013e3b7824ULL, 0x000fe200078e0230ULL,
0x0000002808287210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0236ULL,
0x000000333800720cULL, 0x000fe20003f66070ULL, 0x000000013a337824ULL, 0x000fe400078e0230ULL,
0x000001003b2a7825ULL, 0x002fe200078e000eULL, 0x00000000240d7faeULL, 0x0003e6000c101c46ULL,
0x0000000109297824ULL, 0x000fe200030e0629ULL, 0x0000002a082a7210ULL, 0x000fe20007fde0ffULL,
0x0000010033347825ULL, 0x004fc800078e000eULL, 0x0000000138377824ULL, 0x000fe400078e0230ULL,
0x00000001092b7824ULL, 0x000fe200030e062bULL, 0x0000003408347210ULL, 0x000fe20007fde0ffULL,
0x000000013a307824ULL, 0x140fe400078e0203ULL, 0x000000083a397824ULL, 0x000fe400078e00ffULL,
0x0000000138337824ULL, 0x040fe400078e0203ULL, 0x0000000838387824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee230ULL, 0x00000100370e7825ULL, 0x000fc600078e000eULL,
0xfffffff8383b7812ULL, 0x000fe200078ee233ULL, 0x0000000109357824ULL, 0x000fe200030e0635ULL,
0x0000000e08087210ULL, 0x000fe20007fde0ffULL, 0x0000001031317824ULL, 0x100fe200078e0236ULL,
0x0000003632337211ULL, 0x000fe200078e20ffULL, 0x000000100a377824ULL, 0x100fe400078e0236ULL,
0x0000001039397824ULL, 0x100fe200078e0236ULL, 0x0000000026317faeULL, 0x0003e2000c901c46ULL,
0x000000103b3b7824ULL, 0x000fe400078e0236ULL, 0x0000000109097824ULL, 0x000fe200030e060fULL,
0x0000000028337faeULL, 0x0003e8000d101c46ULL, 0x000000002a377faeULL, 0x0003e8000e901c46ULL,
0x0000000034397faeULL, 0x0003e8000e101c46ULL, 0x00000000083b7faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x00002000000e7824ULL, 0x040fe200078e00ffULL,
0x0000000403257811ULL, 0x040fe200078fe8ffULL, 0x00000010030d7824ULL, 0x040fe200078e00ffULL,
0x0000000803277811ULL, 0x000fe200078fe8ffULL, 0x0000008000347824ULL, 0x000fe200078e00ffULL,
0x000020000e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000008252b7824ULL, 0x000fe200078e00ffULL,
0x000000700d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000827387824ULL, 0x000fe200078e00ffULL,
0x0000001403317811ULL, 0x000fe200078fe8ffULL, 0x000040000a0e7824ULL, 0x000fe200078e020fULL,
0x000000800d347812ULL, 0x000fe200078ef834ULL, 0x00000001250a7824ULL, 0x100fe200078e0203ULL,
0x0000000c03297811ULL, 0x000fe200078fe8ffULL, 0x00000001270d7824ULL, 0x100fe200078e0203ULL,
0x0000001803337811ULL, 0x000fe200078fe8ffULL, 0x00000008313e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b367812ULL, 0x000fe200078ee20aULL, 0x00000001290f7824ULL, 0x000fe200078e0203ULL,
0xfffffff838387812ULL, 0x000fe200078ee20dULL, 0x00000001310d7824ULL, 0x000fe200078e0203ULL,
0x00000010032b7811ULL, 0x000fe200078fe8ffULL, 0x00000008293a7824ULL, 0x000fe200078e00ffULL,
0x0000c0000e437810ULL, 0x000fe20007ffe0ffULL, 0x0000000833407824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x000000012b0a7824ULL, 0x000fe200078e0203ULL,
0x0000001c030d7811ULL, 0x000fe200078fe8ffULL, 0x000000082b357824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL, 0x00000001330f7824ULL, 0x140fe200078e0203ULL,
0x0000003033337210ULL, 0x080fe20007ffe0ffULL, 0x000000010d247824ULL, 0x000fe200078e0203ULL,
0xfffffff8353c7812ULL, 0x000fe200078ee20aULL, 0x000000080d357824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee20fULL, 0x0000000125257824ULL, 0x100fe200078e0230ULL,
0x00000030030f7211ULL, 0x000fe200078fe8ffULL, 0x0000000127277824ULL, 0x000fe200078e0230ULL,
0xfffffff835427812ULL, 0x000fe200078ee224ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x00000003030a7211ULL, 0x000fe200078fe8ffULL, 0x0000000129297824ULL, 0x000fc400078e0230ULL,
0x000001000f0e7825ULL, 0x000fe200078e0034ULL, 0x000000070a0a7812ULL, 0x000fc600078ec0ffULL,
0x0000010025247825ULL, 0x000fe200078e0034ULL, 0x0000000e080e7210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff80a0a7812ULL, 0x000fe200078ef803ULL, 0x000000012b2b7824ULL, 0x000fe200078e0230ULL,
0x0000002408247210ULL, 0x000fe20007f3e0ffULL, 0x0000010027267825ULL, 0x000fc800078e0034ULL,
0x0000000131317824ULL, 0x000fe200078e0230ULL, 0x0000002608267210ULL, 0x000fe20007f5e0ffULL,
0x0000010029287825ULL, 0x000fc800078e0034ULL, 0x000000010d0d7824ULL, 0x000fe200078e0230ULL,
0x0000002808287210ULL, 0x000fe20007f7e0ffULL, 0x000001002b2a7825ULL, 0x000fc800078e0034ULL,
0x0000010031307825ULL, 0x000fc800078e0034ULL, 0x0000010033327825ULL, 0x000fc800078e0034ULL,
0x000001000d347825ULL, 0x000fc800078e0034ULL, 0x00000001090f7824ULL, 0x040fe200000e060fULL,
0x0000002a082a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000109257824ULL, 0x040fe200008e0625ULL,
0x0000003008307210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0d7824ULL, 0x000fe400078e0243ULL,
0x0000000109277824ULL, 0x040fe200010e0627ULL, 0x0000003208327210ULL, 0x000fe20007f5e0ffULL,
0x0000001036377824ULL, 0x000fe200078e0243ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e2000b901c46ULL, 0x0000000109297824ULL, 0x000fe200018e0629ULL,
0x0000003408087210ULL, 0x000fe20007f7e0ffULL, 0x0000001038397824ULL, 0x100fe200078e0243ULL,
0x0000000024377faeULL, 0x0003e2000b901c46ULL, 0x000000103a3b7824ULL, 0x000fc400078e0243ULL,
0x000000103c3d7824ULL, 0x000fe200078e0243ULL, 0x0000000026397faeULL, 0x0003e2000b901c46ULL,
0x00000001092b7824ULL, 0x040fe400000e062bULL, 0x000000103e3f7824ULL, 0x000fe200078e0243ULL,
0x00000000283b7faeULL, 0x0003e2000b901c46ULL, 0x0000000109317824ULL, 0x040fe400008e0631ULL,
0x0000001040417824ULL, 0x000fe200078e0243ULL, 0x000000002a3d7faeULL, 0x0003e2000b901c46ULL,
0x0000000109337824ULL, 0x000fc400010e0633ULL, 0x0000001042437824ULL, 0x000fe200078e0243ULL,
0x00000000303f7faeULL, 0x0003e2000b901c46ULL, 0x0000000109097824ULL, 0x000fc600018e0635ULL,
0x0000000032417faeULL, 0x0003e8000b901c46ULL, 0x0000000008437faeULL, 0x0003e4000b901c46ULL,
0x00000300ff087624ULL, 0x002fe200078e00ffULL, 0x000000010b097812ULL, 0x000fe200078ec0ffULL,
0xffffffffff4c7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010900780cULL, 0x000fe40003f05070ULL, 0xffffffff08087811ULL, 0x000fc800078e08ffULL,
0x0000000108087807ULL, 0x000fca0004000000ULL, 0x00000001080b7824ULL, 0x000fca00078e020bULL,
0x000000710b00720cULL, 0x000fda0003f06070ULL, 0x000000016c088824ULL, 0x000fe400078e020bULL,
0x00000004ff098424ULL, 0x000fc800078e00ffULL, 0x0000660008088625ULL, 0x000fca00078e0009ULL,
0x00000006084c8981ULL, 0x000322000c1e1900ULL, 0xffffffe06d0a7812ULL, 0x040fe400078ec0ffULL,
0x000000106d0d7812ULL, 0x040fe400078ec0ffULL, 0x000000086d0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fe20007ffe00dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013608000a247f8cULL, 0x0022a4000c80043fULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x01360c000a0d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e080e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e09ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001140fULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360c000a0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010036a7824ULL, 0x000fe200078e00ffULL, 0x00000005005c7819ULL, 0x000fe200000006ffULL,
0xffffffffff757424ULL, 0x000fe200078e00ffULL, 0x00000001ff6f7819ULL, 0x000fe40000011603ULL,
0x000000706a6a7812ULL, 0x000fc400078ec0ffULL, 0xffffff805c5c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c6f6f7812ULL, 0x000fc800078ec0ffULL, 0x0000005c6f087210ULL, 0x000fca0007ffe06aULL,
0x01300000080d7984ULL, 0x000ea80000000800ULL, 0x01320000080a7984ULL, 0x0022e20000000800ULL,
0x0000000c0d00720bULL, 0x004fe20003f1d000ULL, 0x00010cf27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x002fc800000e0100ULL, 0x0000ffff09257812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff087224ULL, 0x000fe400078e000cULL, 0x0000001fff777424ULL, 0x000fc400078e00ffULL,
0xffffffffff767424ULL, 0x000fcc00078e00ffULL, 0x0000043000009947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe40000011600ULL, 0x0000000c0d00720bULL, 0x000fe40003f34000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x00010c727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000247806ULL, 0x000fc400008e0100ULL, 0x00000080000e8824ULL, 0x000fe200078e026aULL,
0x0000000c0d087209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000016f098824ULL, 0x000fe200078e020eULL, 0x00009910240e7816ULL, 0x000fc800000000ffULL,
0x0134000809008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000c08097221ULL, 0x002fe20000010100ULL,
0x000000ff24ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009000c7308ULL, 0x000e640000000800ULL,
0x0000000c07077220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011603ULL, 0x00010ba27f007947ULL, 0x000fea000b800000ULL,
0x00001f090c097589ULL, 0x0002a400000e0000ULL, 0x0000000910107220ULL, 0x084fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x080fe20000410000ULL, 0x0000000950507220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000954547220ULL, 0x080fe20000410000ULL,
0x0000000955557220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x00010a827f007947ULL, 0x000fea000b800000ULL,
0x00001f090c097589ULL, 0x00046400000e0000ULL, 0x0000000912127220ULL, 0x086fe20000410000ULL,
0x0000000913137220ULL, 0x080fe20000410000ULL, 0x0000000916167220ULL, 0x080fe20000410000ULL,
0x0000000917177220ULL, 0x080fe20000410000ULL, 0x000000091a1a7220ULL, 0x080fe20000410000ULL,
0x000000091b1b7220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000953537220ULL, 0x080fe20000410000ULL, 0x0000000956567220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff25ff7812ULL, 0x000fda0007806024ULL, 0x800000080d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00040308ULL, 0x000e640000000800ULL,
0x000000040a0a0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000070a077221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000004ff05723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x00005410050a7816ULL, 0x000fe20000000005ULL, 0x000108c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0a057589ULL, 0x0002a400000e0000ULL, 0x000000080d097810ULL, 0x000fe20007ffe0ffULL,
0x000108f27f007947ULL, 0x000fea000b800000ULL, 0x00001f090a067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00003330000f7802ULL, 0x000fc40000000f00ULL,
0x000112b000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x00003380000f7802ULL, 0x000fc40000000f00ULL, 0x0001126000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002004e7824ULL, 0x000fe200078e00ffULL,
0x00000007030d7812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000044e0a7812ULL, 0x008fc400078ec0ffULL, 0x000000080d0c7812ULL, 0x000fe400078ef803ULL,
0x0000000a03097211ULL, 0x044fe200078fe0ffULL, 0x00000200000a7824ULL, 0x000fe400078e00ffULL,
0x000000080c5d7824ULL, 0x040fe400078e00ffULL, 0x000000010c687824ULL, 0x000fe200078e0209ULL,
0xfffff8000a0e7812ULL, 0x000fe400078ec0ffULL, 0x00000008030a7812ULL, 0x000fc400078ec0ffULL,
0xfffffff85d5d7812ULL, 0x000fca00078ee268ULL, 0x000000105d5d7824ULL, 0x000fc800078e020eULL,
0x00000004ff267819ULL, 0x000fe20000011603ULL, 0x009000005d38783bULL, 0x000e620000000200ULL,
0x0000000d0a0f7212ULL, 0x000fe200078efcffULL, 0x000059004c4c7a24ULL, 0x010fe200078e02ffULL,
0x00000001ff097819ULL, 0x000fe40000011600ULL, 0x000000100a287812ULL, 0x000fe200078efe0dULL,
0x0000000126247824ULL, 0x000fe200078e020fULL, 0xfffffff84e4e7812ULL, 0x000fe200078ec0ffULL,
0x00000002090a7824ULL, 0x000fe200078e026bULL, 0x0000002803657211ULL, 0x000fe200078fe0ffULL,
0x00000004090d7824ULL, 0x000fe200078e0226ULL, 0x00000002245f7810ULL, 0x040fe20007ffe0ffULL,
0x000000080f2a7824ULL, 0x040fe200078e00ffULL, 0x00000004245e7810ULL, 0x000fe20007ffe0ffULL,
0x000020000a0a7824ULL, 0x000fe200078e00ffULL, 0x000000030f267819ULL, 0x040fe200000006ffULL,
0x000000080f277824ULL, 0x040fe200078e00ffULL, 0x0000000624617810ULL, 0x000fe20007ffe0ffULL,
0x000000080f257824ULL, 0x000fe200078e00ffULL, 0x000000020d0f7810ULL, 0x000fe20007ffe00cULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a5f7812ULL, 0x000fe200078ee25fULL,
0x0000000828297824ULL, 0x000fe200078e00ffULL, 0x0000b0000a0d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8275e7812ULL, 0x000fe400078ee25eULL, 0xfffffff825607812ULL, 0x000fe200078ee224ULL,
0x000000105f587824ULL, 0x000fe200078e020dULL, 0xfffffff826617812ULL, 0x000fe200078ee261ULL,
0x000000105e447824ULL, 0x000fe200078e020dULL, 0xfffffff80c0f7812ULL, 0x000fe200078ee20fULL,
0x0000001060407824ULL, 0x100fe200078e020dULL, 0x0000000465627810ULL, 0x000fe20007ffe0ffULL,
0x00000010613c7824ULL, 0x000fe200078e020dULL, 0x000000005858783bULL, 0x000ea20000004200ULL,
0x000000100f4d7824ULL, 0x000fe200078e00ffULL, 0x0000000265647810ULL, 0x040fe20007ffe0ffULL,
0x00000008280f7824ULL, 0x040fe200078e00ffULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x0000000828257824ULL, 0x040fe200078e00ffULL, 0x0000000665667810ULL, 0x000fe20007ffe0ffULL,
0x00000008280c7824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000090000e0e7810ULL, 0x000fe20007ffe04dULL, 0x0000000538380231ULL, 0x082fe200003400ffULL,
0xfffffff80f627812ULL, 0x000fe200078ee262ULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0xfffffff825647812ULL, 0x000fe200078ee264ULL, 0x000000053a3a0231ULL, 0x000fe200003400ffULL,
0xfffffff80c657812ULL, 0x000fe200078ee265ULL, 0x000000000e24783bULL, 0x000e620000000200ULL,
0xfffffff829667812ULL, 0x000fe200078ee266ULL, 0x0000001062307824ULL, 0x100fe200078e020dULL,
0x0000000639390231ULL, 0x080fe200003400ffULL, 0x0000001064347824ULL, 0x100fe200078e020dULL,
0x000000063b3b0231ULL, 0x000fe200003400ffULL, 0x0000001065287824ULL, 0x000fc400078e020dULL,
0x00000010660d7824ULL, 0x000fe200078e020dULL, 0x000000003030783bULL, 0x000e680000004200ULL,
0x000000002828783bULL, 0x000e680000004200ULL, 0x000000003434783bULL, 0x000e680000004200ULL,
0x000000000d0c783bULL, 0x000e620000004200ULL, 0x000000583848723cULL, 0x044ff00000041818ULL,
0x000000443818723cULL, 0x048ff00000041854ULL, 0x00000046382c723cULL, 0x000f62000004182cULL,
0x0000000524240231ULL, 0x002fc400003400ffULL, 0x0000000526260231ULL, 0x000fe400003400ffULL,
0x0000000625250231ULL, 0x080fe400003400ffULL, 0x0000000627270231ULL, 0x000fe200003400ffULL,
0x000000403844723cULL, 0x040f700000041810ULL, 0x0000005a3850723cULL, 0x040f700000041850ULL,
0x000000423840723cULL, 0x040f700000041814ULL, 0x0000003c3820723cULL, 0x040f700000041820ULL,
0x0000003e3838723cULL, 0x000f70000004181cULL, 0x00000032241c723cULL, 0x060f70000004182cULL,
0x00000028242c723cULL, 0x040f700000041844ULL, 0x000000342410723cULL, 0x040f700000041848ULL,
0x000000362414723cULL, 0x040f700000041850ULL, 0x000000302418723cULL, 0x040f700000041818ULL,
0x0000002a2428723cULL, 0x040f700000041840ULL, 0x0000000c2420723cULL, 0x040b6e0000041820ULL,
0x00000008020c7824ULL, 0x020fe200078e0209ULL, 0x0000000e2424723cULL, 0x000b620000041838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000001020e7810ULL, 0x020fe20007ffe0ffULL,
0x013688004eff7f8cULL, 0x0003e2000c80043fULL, 0x000000800c417811ULL, 0x000fe200078e28ffULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000670e00720cULL, 0x000fe20003f06070ULL,
0x000000804c0c7824ULL, 0x000fe200078e00ffULL, 0x00000060413c7812ULL, 0x000fc600078ec0ffULL,
0x000064000c0c7625ULL, 0x000fc800078e000dULL, 0x00000001693c7824ULL, 0x000fe200078e023cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff407819ULL, 0x002fe20000011603ULL, 0x00002000000f7824ULL, 0x000fe200078e00ffULL,
0x00000041630e7217ULL, 0x000fe40007800000ULL, 0x0000000840347810ULL, 0x040fe40007ffe0ffULL,
0x0000000440307810ULL, 0x000fe20007ffe0ffULL, 0x000000010e417824ULL, 0x000fe200078e0a41ULL,
0x000020000f447812ULL, 0x000fe200078ec0ffULL, 0x00000001343d7824ULL, 0x100fe200078e0203ULL,
0x0000000c40367810ULL, 0x000fe20007ffe0ffULL, 0x00000008340e7824ULL, 0x000fe200078e00ffULL,
0x0000001040387810ULL, 0x000fe20007ffe0ffULL, 0x00000080000f7824ULL, 0x000fe200078e00ffULL,
0x0000002041417817ULL, 0x000fe20003800000ULL, 0x0000000130427824ULL, 0x000fe200078e0203ULL,
0xfffffff80e3d7812ULL, 0x000fe200078ee23dULL, 0x0000000830317824ULL, 0x000fe200078e00ffULL,
0x000000806a0e7812ULL, 0x000fe200078ef80fULL, 0x0000000130337824ULL, 0x040fe200078e023cULL,
0x000000413000720cULL, 0x080fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0xfffffff831427812ULL, 0x000fe200078ee242ULL, 0x00000001363f7824ULL, 0x100fe200078e0203ULL,
0x0000003c40317210ULL, 0x000fe20007ffe0ffULL, 0x00000008363a7824ULL, 0x000fe200078e00ffULL,
0x0000001440487810ULL, 0x000fe20007ffe0ffULL, 0x00000001383e7824ULL, 0x000fe200078e0203ULL,
0x000000413600720cULL, 0x080fe20003f46070ULL, 0x0000000838357824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3f7812ULL, 0x000fe200078ee23fULL, 0x0000010033327825ULL, 0x000fe200078e000eULL,
0x000000413400720cULL, 0x000fc40003f66070ULL, 0xfffffff8353e7812ULL, 0x000fe200078ee23eULL,
0x0000010031307825ULL, 0x000fe200078e000eULL, 0x000000320c3a7210ULL, 0x000fe40007f3e0ffULL,
0x000000414000720cULL, 0x000fe20003fa6070ULL, 0x0000000134377824ULL, 0x100fe200078e023cULL,
0x000000300c307210ULL, 0x000fe20007f1e0ffULL, 0x0000000136357824ULL, 0x000fe400078e023cULL,
0x0000400009447824ULL, 0x000fe400078e0244ULL, 0x0000000148097824ULL, 0x000fc400078e0203ULL,
0x0000000848467824ULL, 0x000fe200078e00ffULL, 0x0000b00044447810ULL, 0x000fe20007ffe0ffULL,
0x0000010037367825ULL, 0x000fc600078e000eULL, 0xfffffff846097812ULL, 0x000fe200078ee209ULL,
0x0000000140327824ULL, 0x000fe400078e0203ULL, 0x0000010035347825ULL, 0x000fc600078e000eULL,
0x0000000732467812ULL, 0x000fe200078ec0ffULL, 0x000000010d3b7824ULL, 0x040fe200008e0633ULL,
0x000000413800720cULL, 0x040fe20003f26070ULL, 0x0000000138337824ULL, 0x000fe200078e023cULL,
0x0ffffff846437812ULL, 0x000fe200078ef803ULL, 0x000000010d317824ULL, 0x000fe200000e0631ULL,
0x000000360c387210ULL, 0x040fe20007f1e0ffULL, 0x0000010033327825ULL, 0x000fe200078e000eULL,
0x000000340c367210ULL, 0x000fc60007fde0ffULL, 0x000000010d397824ULL, 0x040fe200000e0637ULL,
0x000000414800720cULL, 0x000fe20003f06070ULL, 0x000000010d377824ULL, 0x000fe200030e0635ULL,
0x000000320c347210ULL, 0x000fe20007fde0ffULL, 0x0000000148477824ULL, 0x000fe400078e023cULL,
0x0000001042457824ULL, 0x100fe200078e0244ULL, 0x0000001840427810ULL, 0x040fe20007ffe0ffULL,
0x0000001043437824ULL, 0x000fe200078e0244ULL, 0x0000001c40407810ULL, 0x000fe20007ffe0ffULL,
0x000000010d357824ULL, 0x000fc400030e0633ULL, 0x0000010047327825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030437faeULL, 0x0003e2000e901c46ULL,
0x000000414200720cULL, 0x0c0fe40003fa6070ULL, 0x0000000142477824ULL, 0x000fe200078e023cULL,
0x000000003a457faeULL, 0x0005e2000e101c46ULL, 0x000000320c327210ULL, 0x000fe20007fde0ffULL,
0x000000103d3d7824ULL, 0x000fe200078e0244ULL, 0x000000414000720cULL, 0x040fe20003f86070ULL,
0x0000000140417824ULL, 0x000fe400078e023cULL, 0x000000010d337824ULL, 0x000fe200030e0633ULL,
0x00000000383d7faeULL, 0x0007e2000d901c46ULL, 0x0000010047307825ULL, 0x002fc800078e000eULL,
0x00000001423c7824ULL, 0x100fe200078e0203ULL, 0x000000300c307210ULL, 0x000fe20007fde0ffULL,
0x0000000842437824ULL, 0x000fe400078e00ffULL, 0x00000001403a7824ULL, 0x044fe200078e0203ULL,
0x000000310d317210ULL, 0x000fe200037fe4ffULL, 0x00000008403b7824ULL, 0x000fe400078e00ffULL,
0x00000100410e7825ULL, 0x000fe200078e000eULL, 0xfffffff843417812ULL, 0x000fe400078ee23cULL,
0xfffffff83b437812ULL, 0x000fe200078ee23aULL, 0x000000103f3f7824ULL, 0x100fe200078e0244ULL,
0x0000000e0c0e7210ULL, 0x000fe20007fde0ffULL, 0x000000103e3b7824ULL, 0x000fc400078e0244ULL,
0x0000001009097824ULL, 0x100fe200078e0244ULL, 0x00000000363f7faeULL, 0x0007e2000d101c46ULL,
0x0000001041417824ULL, 0x100fe400078e0244ULL, 0x0000001043437824ULL, 0x000fe200078e0244ULL,
0x00000000343b7faeULL, 0x0007e2000c901c46ULL, 0x000000010d0f7824ULL, 0x000fc600030e060fULL,
0x0000000032097faeULL, 0x0007e8000c101c46ULL, 0x0000000030417faeULL, 0x0007e8000e901c46ULL,
0x000000000e437faeULL, 0x0007e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000c033d7811ULL, 0x042fe200078fe8ffULL, 0x00002000000e7824ULL, 0x000fe200078e00ffULL,
0x0000000403397811ULL, 0x000fc400078fe8ffULL, 0x0000000803377811ULL, 0x000fe200078fe8ffULL,
0x000000013d407824ULL, 0x140fe200078e0203ULL, 0x000020000e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000083d317824ULL, 0x000fe200078e00ffULL, 0x0000001803337811ULL, 0x000fe200078fe8ffULL,
0x0000000139427824ULL, 0x100fe200078e0203ULL, 0x0000001c03437811ULL, 0x000fe200078fe8ffULL,
0x0000400009307824ULL, 0x000fe200078e020eULL, 0xfffffff831407812ULL, 0x000fe200078ee240ULL,
0x0000000839097824ULL, 0x000fe200078e00ffULL, 0x0000001403317811ULL, 0x000fe200078fe8ffULL,
0x0000000137417824ULL, 0x100fe200078e0203ULL, 0x00000010030f7811ULL, 0x000fe200078fe8ffULL,
0x00000008370e7824ULL, 0x000fe200078e00ffULL, 0xfffffff809427812ULL, 0x000fe200078ee242ULL,
0x00000001313e7824ULL, 0x000fe200078e0203ULL, 0x0000003c033b7211ULL, 0x000fe200078fe8ffULL,
0x0000000831357824ULL, 0x000fe200078e00ffULL, 0xfffffff80e417812ULL, 0x000fe200078ee241ULL,
0x0000000133097824ULL, 0x040fe200078e0203ULL, 0x0000b000304b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000833327824ULL, 0x000fe200078e00ffULL, 0xfffffff8353e7812ULL, 0x000fe200078ee23eULL,
0x0000008000357824ULL, 0x000fc400078e00ffULL, 0x000000010f3f7824ULL, 0x040fe200078e0203ULL,
0xfffffff832097812ULL, 0x000fe200078ee209ULL, 0x000000080f0e7824ULL, 0x000fe200078e00ffULL,
0x000000806a347812ULL, 0x000fe200078ef835ULL, 0x0000000843357824ULL, 0x040fe200078e00ffULL,
0x0000000343327210ULL, 0x080fe20007ffe0ffULL, 0x0000000139397824ULL, 0x100fe200078e023cULL,
0xfffffff80e3f7812ULL, 0x000fe200078ee23fULL, 0x0000000137377824ULL, 0x000fe200078e023cULL,
0xfffffff835467812ULL, 0x000fe200078ee232ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x00000003030e7211ULL, 0x000fe200078fe8ffULL, 0x000000013d3d7824ULL, 0x000fc400078e023cULL,
0x000001003b3a7825ULL, 0x000fe200078e0034ULL, 0x000000070e0e7812ULL, 0x000fc600078ec0ffULL,
0x0000010039387825ULL, 0x000fe200078e0034ULL, 0x0ffffff80e447812ULL, 0x000fe400078ef803ULL,
0x0000003a0c3a7210ULL, 0x040fe20007f1e0ffULL, 0x000000010f0f7824ULL, 0x100fe200078e023cULL,
0x000000380c387210ULL, 0x000fe20007f3e0ffULL, 0x0000000131317824ULL, 0x100fe400078e023cULL,
0x0000000133337824ULL, 0x100fe400078e023cULL, 0x0000000143437824ULL, 0x000fc400078e023cULL,
0x0000010037367825ULL, 0x000fc800078e0034ULL, 0x000001003d3c7825ULL, 0x000fe200078e0034ULL,
0x000000360c367210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0034ULL,
0x0000003c0c3c7210ULL, 0x000fc60007f7e0ffULL, 0x0000010031307825ULL, 0x000fc800078e0034ULL,
0x0000010033327825ULL, 0x000fc800078e0034ULL, 0x0000010043347825ULL, 0x000fc800078e0034ULL,
0x000000010d3b7824ULL, 0x040fe200000e063bULL, 0x0000000e0c0e7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d397824ULL, 0x040fe200008e0639ULL, 0x000000300c307210ULL, 0x000fe20007f3e0ffULL,
0x0000001044437824ULL, 0x000fe400078e024bULL, 0x000000010d377824ULL, 0x040fe200010e0637ULL,
0x000000320c327210ULL, 0x000fe20007f5e0ffULL, 0x0000001042457824ULL, 0x000fe200078e024bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000b901c46ULL,
0x000000010d3d7824ULL, 0x000fe200018e063dULL, 0x000000340c347210ULL, 0x000fe20007f7e0ffULL,
0x0000001041417824ULL, 0x100fe200078e024bULL, 0x0000000038457faeULL, 0x0003e2000b901c46ULL,
0x0000001040477824ULL, 0x000fc400078e024bULL, 0x000000103f3f7824ULL, 0x000fe200078e024bULL,
0x0000000036417faeULL, 0x0003e2000b901c46ULL, 0x000000010d0f7824ULL, 0x040fe400000e060fULL,
0x000000103e497824ULL, 0x000fe200078e024bULL, 0x000000003c477faeULL, 0x0003e2000b901c46ULL,
0x000000010d317824ULL, 0x000fe400008e0631ULL, 0x0000001009097824ULL, 0x000fe200078e024bULL,
0x000000000e3f7faeULL, 0x0003e2000b901c46ULL, 0x000000010d337824ULL, 0x000fc400010e0633ULL,
0x00000010464b7824ULL, 0x000fe200078e024bULL, 0x0000000030497faeULL, 0x0003e2000b901c46ULL,
0x000000010d357824ULL, 0x000fc600018e0635ULL, 0x0000000032097faeULL, 0x0003e8000b901c46ULL,
0x00000000344b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe06d097812ULL, 0x04afe400078ec0ffULL, 0x000000106d0e7812ULL, 0x040fe400078ec0ffULL,
0x000000086d0f7812ULL, 0x000fc800078ec0ffULL, 0x000000090f347210ULL, 0x000fe20007ffe00eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01362800340e7f8cULL, 0x0002a4000c80043fULL,
0x0000000000307805ULL, 0x000fc40000015200ULL, 0x01362c0034097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230327210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011433ULL, 0x0000003209097211ULL, 0x000fca00078110ffULL,
0x000000ffff327224ULL, 0x000fca00000e0633ULL, 0x0000000209097819ULL, 0x000fc80000001232ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000135357810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01362c0034097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000806a0e7810ULL, 0x000fca0007ffe05cULL,
0x000000016f0e7824ULL, 0x000fca00078e020eULL, 0x013000000e317984ULL, 0x000ea80000000800ULL,
0x013200000e307984ULL, 0x0006620000000800ULL, 0x000000083100720bULL, 0x004fe20003f1d000ULL,
0x0000f2627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x008fc800000e0100ULL,
0x0000ffff09337812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000100097811ULL, 0x000fe400078ff0ffULL, 0x000000083100720bULL, 0x000fe40003f34000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x0000f2127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000327806ULL, 0x000fc400008e0100ULL, 0x00000080000e8824ULL, 0x000fe200078e026aULL,
0x0000000831098209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000016f348824ULL, 0x002fe200078e020eULL, 0x00009910320e7816ULL, 0x000fc800000000ffULL,
0x0134000934008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000831097209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff32ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000809097221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900347308ULL, 0x000e640000000800ULL, 0x0000003407077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011603ULL,
0x0000f1327f007947ULL, 0x000fea000b800000ULL, 0x00001f0934097589ULL, 0x0002a400000e0000ULL,
0x000000092c2c7220ULL, 0x084fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x0000000928287220ULL, 0x080fe20000410000ULL, 0x0000000929297220ULL, 0x080fe20000410000ULL,
0x0000000910107220ULL, 0x080fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000914147220ULL, 0x080fe20000410000ULL, 0x0000000915157220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x000000091c1c7220ULL, 0x080fe20000410000ULL, 0x000000091d1d7220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000921217220ULL, 0x080fe20000410000ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0032ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803097811ULL, 0x000fe200078ff0ffULL,
0x0000f0127f007947ULL, 0x000fea000b800000ULL, 0x00001f0934097589ULL, 0x0004e400000e0000ULL,
0x000000092e2e7220ULL, 0x08cfe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x000000092a2a7220ULL, 0x080fe20000410000ULL, 0x000000092b2b7220ULL, 0x080fe20000410000ULL,
0x0000000912127220ULL, 0x080fe20000410000ULL, 0x0000000913137220ULL, 0x080fe20000410000ULL,
0x0000000916167220ULL, 0x080fe20000410000ULL, 0x0000000917177220ULL, 0x080fe20000410000ULL,
0x000000091a1a7220ULL, 0x080fe20000410000ULL, 0x000000091b1b7220ULL, 0x080fe20000410000ULL,
0x000000091e1e7220ULL, 0x080fe20000410000ULL, 0x000000091f1f7220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000927277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff33ff7812ULL, 0x000fe40007806032ULL,
0x0000000831087209ULL, 0x000fd60007810000ULL, 0x8000000831310221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100040308ULL, 0x000e640000000800ULL,
0x0000000430300220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000000730077221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000004ff05723eULL, 0x000fe400000010ffULL, 0x00000002ff317819ULL, 0x000fe40000011603ULL,
0x0000541005307816ULL, 0x000fe20000000005ULL, 0x0000ee427f007947ULL, 0x000fea000b800000ULL,
0x00001f3130057589ULL, 0x0002a400000e0000ULL, 0x0000000831097810ULL, 0x000fe20007ffe0ffULL,
0x0000ee727f007947ULL, 0x000fea000b800000ULL, 0x00001f0930067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001031097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00004f70000f7802ULL, 0x000fc40000000f00ULL,
0x0000f67000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001831097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00004fc0000f7802ULL, 0x000fc40000000f00ULL, 0x0000f62000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000c0000a0f7810ULL, 0x000fe20007ffe0ffULL, 0x009800005d44783bULL, 0x000f220000000200ULL,
0x00000002ff097819ULL, 0x00cfc40000011600ULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x0000001060547824ULL, 0x100fe200078e020fULL, 0x00013690090e7811ULL, 0x000fe200078e18ffULL,
0x000000105f507824ULL, 0x100fe400078e020fULL, 0x000000105e587824ULL, 0x100fe400078e020fULL,
0x0000001061487824ULL, 0x000fe200078e020fULL, 0x000000005454783bULL, 0x000ea20000004200ULL,
0x0000080009307824ULL, 0x002fe400078e024dULL, 0x0000001065407824ULL, 0x100fe200078e020fULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x00000010643c7824ULL, 0x000fc400078e020fULL,
0x0000001062387824ULL, 0x100fe200078e020fULL, 0x000000005858783bULL, 0x000fe20000004200ULL,
0x0000001066347824ULL, 0x000fe400078e020fULL, 0x00000008020f7824ULL, 0x000fe200078e020aULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x009800003030783bULL, 0x000e680000000200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000003c3c783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x0000000544440231ULL, 0x010fc400003400ffULL,
0x0000000546460231ULL, 0x000fe200003400ffULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x0000000645450231ULL, 0x080fe400003400ffULL, 0x0000000647470231ULL, 0x000fce00003400ffULL,
0x00000054442c723cULL, 0x044f70000004182cULL, 0x000000564428723cULL, 0x000f620000041828ULL,
0x0000000530300231ULL, 0x002fce00003400ffULL, 0x00000050444c723cULL, 0x000f620000041810ULL,
0x0000000532320231ULL, 0x000fe400003400ffULL, 0x0000000631310231ULL, 0x080fe400003400ffULL,
0x0000000633330231ULL, 0x000fc600003400ffULL, 0x000000524450723cULL, 0x040f700000041814ULL,
0x000000584454723cULL, 0x040f700000041818ULL, 0x0000005a441c723cULL, 0x040f70000004181cULL,
0x000000484420723cULL, 0x040f700000041820ULL, 0x0000004a4424723cULL, 0x000f700000041824ULL,
0x000000403010723cULL, 0x068b70000004182cULL, 0x000000423014723cULL, 0x040b700000041828ULL,
0x0000003c3018723cULL, 0x040b70000004184cULL, 0x0000003e3050723cULL, 0x040b700000041850ULL,
0x000000383054723cULL, 0x040b700000041854ULL, 0x0000003a301c723cULL, 0x040b70000004181cULL,
0x000000343020723cULL, 0x050b700000041820ULL, 0x000000363030723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000102247810ULL, 0x020fe20007ffe0ffULL,
0x000000000eff7f8cULL, 0x0003e2000c80043fULL, 0x000000c00f0f7811ULL, 0x000fc400078e28ffULL,
0x000000672400720cULL, 0x000fe40003f06070ULL, 0x000000600f347812ULL, 0x000fca00078ec0ffULL,
0x0000000169347824ULL, 0x000fe200078e0234ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x0000000f630e7217ULL, 0x002fe40007800000ULL,
0x00000003ff397819ULL, 0x000fc60000011603ULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0fULL,
0x0000000c39297810ULL, 0x040fe20007ffe0ffULL, 0x00000080000f7824ULL, 0x000fe200078e00ffULL,
0x0000000439277810ULL, 0x000fe40007ffe0ffULL, 0x000000200e3a7817ULL, 0x000fe20003800000ULL,
0x0000000129357824ULL, 0x040fe200078e0203ULL, 0x000000806a0e7812ULL, 0x000fe200078ef80fULL,
0x0000000829267824ULL, 0x000fe200078e00ffULL, 0x0000003a2700720cULL, 0x0c0fe20003f86070ULL,
0x00000001273b7824ULL, 0x000fe200078e0203ULL, 0x00000008392b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000827247824ULL, 0x040fe200078e00ffULL, 0xfffffff826357812ULL, 0x000fe200078ee235ULL,
0x0000000127277824ULL, 0x000fe200078e0234ULL, 0x00000010393d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0000001439417810ULL, 0x000fe20007ffe0ffULL,
0x000000012b367824ULL, 0x000fe200078e0203ULL, 0xfffffff8243b7812ULL, 0x000fe200078ee23bULL,
0x0000010027267825ULL, 0x000fe200078e000eULL, 0x0000003a2b00720cULL, 0x000fc40003f66070ULL,
0x0000003a2900720cULL, 0x000fe20003f46070ULL, 0x000000082b257824ULL, 0x000fe200078e00ffULL,
0x000000260c2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000013d387824ULL, 0x000fe200078e0203ULL,
0x0000003a3900720cULL, 0x000fe20003fa6070ULL, 0x000000083d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff825367812ULL, 0x000fe200078ee236ULL, 0x000000010d2f7824ULL, 0x000fe200008e0627ULL,
0x0000003439257210ULL, 0x000fe20007ffe0ffULL, 0x0000200000277824ULL, 0x000fe200078e00ffULL,
0xfffffff82d387812ULL, 0x000fe200078ee238ULL, 0x0000000141377824ULL, 0x000fe200078e0203ULL,
0x0000003a3d00720cULL, 0x000fe20003f26070ULL, 0x0000010025247825ULL, 0x000fe200078e000eULL,
0x00002000272d7812ULL, 0x000fc400078ec0ffULL, 0x0000001c39437810ULL, 0x000fe20007ffe0ffULL,
0x0000000841287824ULL, 0x000fe200078e00ffULL, 0x000000240c247210ULL, 0x000fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x100fe400078e0234ULL, 0x0000000129297824ULL, 0x000fe200078e0234ULL,
0xfffffff828377812ULL, 0x000fe200078ee237ULL, 0x0000000139267824ULL, 0x000fe400078e0203ULL,
0x000001002b2a7825ULL, 0x000fc600078e000eULL, 0x00000007263c7812ULL, 0x000fe200078ec0ffULL,
0x0000010029287825ULL, 0x000fc800078e000eULL, 0x000000013d277824ULL, 0x000fe200078e0234ULL,
0x0ffffff83c3d7812ULL, 0x000fe200078ef803ULL, 0x000040000a3e7824ULL, 0x000fe400078e022dULL,
0x000000010d257824ULL, 0x000fe200000e0625ULL, 0x0000002a0c2c7210ULL, 0x040fe20007f1e0ffULL,
0x0000010027267825ULL, 0x000fe200078e000eULL, 0x000000280c2a7210ULL, 0x000fe40007fde0ffULL,
0x0000c0003e3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d2d7824ULL, 0x000fe200000e062bULL,
0x0000003a4100720cULL, 0x000fe20003f06070ULL, 0x000000010d2b7824ULL, 0x000fe200030e0629ULL,
0x000000260c287210ULL, 0x000fe20007fde0ffULL, 0x000000103d3f7824ULL, 0x000fc400078e023cULL,
0x00000001413d7824ULL, 0x000fe400078e0234ULL, 0x000000010d297824ULL, 0x000fe200030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000243f7faeULL, 0x0003e2000e901c46ULL,
0x000001003d267825ULL, 0x000fe200078e000eULL, 0x00000018393d7810ULL, 0x000fc60007ffe0ffULL,
0x000000103b417824ULL, 0x000fe200078e023cULL, 0x000000260c267210ULL, 0x000fe20007fde0ffULL,
0x000000013d397824ULL, 0x140fe200078e0234ULL, 0x0000003a3d00720cULL, 0x080fe20003fa6070ULL,
0x00000001433b7824ULL, 0x000fe200078e0234ULL, 0x000000002e417faeULL, 0x0005e2000e101c46ULL,
0x000000013d347824ULL, 0x000fe200078e0203ULL, 0x0000003a4300720cULL, 0x000fe20003f86070ULL,
0x0000010039247825ULL, 0x002fc800078e000eULL, 0x000000010d277824ULL, 0x000fe200030e0627ULL,
0x000000240c247210ULL, 0x040fe20007fde0ffULL, 0x000000083d3d7824ULL, 0x000fe400078e00ffULL,
0x000001003b0e7825ULL, 0x000fe200078e000eULL, 0x000000250d257210ULL, 0x000fe400037fe4ffULL,
0xfffffff83d3b7812ULL, 0x000fe200078ee234ULL, 0x00000001432e7824ULL, 0x044fe200078e0203ULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000000843437824ULL, 0x000fc400078e00ffULL,
0x00000010362f7824ULL, 0x100fe400078e023cULL, 0x0000001035357824ULL, 0x000fe200078e023cULL,
0xfffffff8433d7812ULL, 0x000fe200078ee22eULL, 0x0000001038397824ULL, 0x100fe200078e023cULL,
0x000000002c2f7faeULL, 0x0003e2000d901c46ULL, 0x0000001037377824ULL, 0x100fe400078e023cULL,
0x000000103b3b7824ULL, 0x100fe200078e023cULL, 0x000000002a357faeULL, 0x0003e2000d101c46ULL,
0x000000103d3d7824ULL, 0x000fc400078e023cULL, 0x000000010d0d7824ULL, 0x000fe200030e060fULL,
0x0000000028397faeULL, 0x0003e8000c901c46ULL, 0x0000000026377faeULL, 0x0003e8000c101c46ULL,
0x00000000243b7faeULL, 0x0003e8000e901c46ULL, 0x000000000c3d7faeULL, 0x0003e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000803357811ULL, 0x042fe400078fe8ffULL,
0x0000001003257811ULL, 0x000fc400078fe8ffULL, 0x0000001803297811ULL, 0x000fe200078fe8ffULL,
0x0000000135387824ULL, 0x100fe200078e0203ULL, 0x00000004032f7811ULL, 0x000fe200078fe8ffULL,
0x00000008350f7824ULL, 0x000fe200078e00ffULL, 0x0000000c03247811ULL, 0x000fe200078fe8ffULL,
0x00000001253a7824ULL, 0x100fe200078e0203ULL, 0x0000001c033d7811ULL, 0x000fe200078fe8ffULL,
0x0000000129367824ULL, 0x100fe200078e0203ULL, 0xfffffff80f387812ULL, 0x000fe200078ee238ULL,
0x00000008250f7824ULL, 0x000fe200078e00ffULL, 0x0000001403277811ULL, 0x000fe200078fe8ffULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0x00000034032d7211ULL, 0x000fe200078fe8ffULL,
0x000000012f377824ULL, 0x000fe200078e0203ULL, 0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL,
0x000000082f0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b367812ULL, 0x000fe200078ee236ULL,
0x00002000000f7824ULL, 0x000fc400078e00ffULL, 0x00000080002b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e377812ULL, 0x000fe200078ee237ULL, 0x0000000124397824ULL, 0x040fe200078e0203ULL,
0x000020000f3f7812ULL, 0x000fe200078ec0ffULL, 0x00000008240e7824ULL, 0x000fe200078e00ffULL,
0x000000806a2a7812ULL, 0x000fe200078ef82bULL, 0x00000001240f7824ULL, 0x100fe200078e0234ULL,
0x000000033d247210ULL, 0x0c0fe20007ffe0ffULL, 0x000000083d2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e397812ULL, 0x000fe200078ee239ULL, 0x000000012f2f7824ULL, 0x100fe200078e0234ULL,
0x00000003030e7211ULL, 0x000fe200078fe8ffULL, 0x0000000135357824ULL, 0x000fe200078e0234ULL,
0xfffffff82b3e7812ULL, 0x000fe200078ee224ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x000000070e0e7812ULL, 0x000fe200078ec0ffULL, 0x00000001273b7824ULL, 0x000fc400078e0203ULL,
0x0000000827267824ULL, 0x000fe200078e00ffULL, 0x0ffffff80e3c7812ULL, 0x000fe200078ef803ULL,
0x000001002d2c7825ULL, 0x000fc600078e002aULL, 0xfffffff8263b7812ULL, 0x000fe200078ee23bULL,
0x0000000125257824ULL, 0x100fe200078e0234ULL, 0x0000002c0c2c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000127277824ULL, 0x100fe400078e0234ULL, 0x0000000129297824ULL, 0x100fe400078e0234ULL,
0x000000013d3d7824ULL, 0x000fe400078e0234ULL, 0x000001002f2e7825ULL, 0x000fc800078e002aULL,
0x000040000a3f7824ULL, 0x000fe200078e023fULL, 0x0000002e0c2e7210ULL, 0x000fe20007f3e0ffULL,
0x0000010035347825ULL, 0x000fc600078e002aULL, 0x0000c0003f3f7810ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e002aULL, 0x000000340c347210ULL, 0x000fc60007f5e0ffULL,
0x0000010025247825ULL, 0x000fe200078e002aULL, 0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010027267825ULL, 0x000fc800078e002aULL, 0x0000010029287825ULL, 0x000fc800078e002aULL,
0x000001003d2a7825ULL, 0x000fc800078e002aULL, 0x000000010d2d7824ULL, 0x040fe200000e062dULL,
0x000000240c247210ULL, 0x040fe20007f1e0ffULL, 0x000000010d2f7824ULL, 0x040fe200008e062fULL,
0x000000260c267210ULL, 0x000fe20007f3e0ffULL, 0x000000103c3d7824ULL, 0x000fe400078e023fULL,
0x000000010d357824ULL, 0x000fe200010e0635ULL, 0x000000280c287210ULL, 0x040fe20007f5e0ffULL,
0x0000001037377824ULL, 0x000fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c3d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d0f7824ULL, 0x000fe200018e060fULL,
0x0000002a0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001038417824ULL, 0x100fe200078e023fULL,
0x000000002e377faeULL, 0x0003e2000b901c46ULL, 0x0000001039397824ULL, 0x000fc400078e023fULL,
0x000000103a437824ULL, 0x000fe200078e023fULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x000000010d257824ULL, 0x000fe400000e0625ULL, 0x000000103b3b7824ULL, 0x000fe200078e023fULL,
0x000000000e397faeULL, 0x0003e2000b901c46ULL, 0x000000010d277824ULL, 0x040fe400008e0627ULL,
0x0000001036457824ULL, 0x000fe200078e023fULL, 0x0000000024437faeULL, 0x0003e2000b901c46ULL,
0x000000010d297824ULL, 0x000fc400010e0629ULL, 0x000000103e3f7824ULL, 0x000fe200078e023fULL,
0x00000000263b7faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x000fc600018e062bULL,
0x0000000028457faeULL, 0x0003e8000b901c46ULL, 0x000000000c3f7faeULL, 0x0003e4000b901c46ULL,
0x00000300ff0c7624ULL, 0x002fe200078e00ffULL, 0x000000010b0d7812ULL, 0x000fe200078ec0ffULL,
0xffffffffff597424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010d00780cULL, 0x000fe40003f05070ULL, 0xffffffff0c0c7811ULL, 0x000fc800078e08ffULL,
0x000000010c0c7807ULL, 0x000fca0004000000ULL, 0x000000010b0b7824ULL, 0x000fca00078e020cULL,
0x000000710b00720cULL, 0x000fda0003f06070ULL, 0x000000010b0c8824ULL, 0x000fe400078e026cULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000066000c0c8625ULL, 0x000fca00078e000dULL,
0x000000060c598981ULL, 0x000322000c1e1900ULL, 0x000000106d0e7812ULL, 0x000fca00078ec0ffULL,
0x0000002009097824ULL, 0x000fe200078e020eULL, 0x000000086d0e7812ULL, 0x000fca00078ec0ffULL,
0x000000010e097824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01364800090c7f8cULL, 0x0022a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01364c0009257984ULL, 0x000ee40000000800ULL, 0x8000000025ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff00267202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x000000240e277210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e0fULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011425ULL,
0x0000002724247211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x0000000224247819ULL, 0x000fc80000001225ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01364c0009257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001006a0c7810ULL, 0x000fca0007ffe05cULL, 0x000000016f0c7824ULL, 0x000fca00078e020cULL,
0x013000000c0d7984ULL, 0x000ea80000000800ULL, 0x013200000c247984ULL, 0x0006620000000800ULL,
0x000000080d00720bULL, 0x004fe20003f1d000ULL, 0x0000da327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x00afc800000e0100ULL, 0x0000ffff09257812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000200097811ULL, 0x000fe400078ff0ffULL,
0x000000080d00720bULL, 0x000fe40003f34000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x0000d9e27f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400008e0100ULL,
0x00000080000e8824ULL, 0x000fe200078e026aULL, 0x000000080d098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000016f268824ULL, 0x000fe200078e020eULL,
0x000099100c0e7816ULL, 0x000fc800000000ffULL, 0x0134000926008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000080d097209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900267308ULL, 0x000e640000000800ULL,
0x0000002607077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011603ULL, 0x0000d9027f007947ULL, 0x000fea000b800000ULL,
0x00001f0926097589ULL, 0x0002a400000e0000ULL, 0x0000000910107220ULL, 0x084fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x080fe20000410000ULL, 0x0000000950507220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000954547220ULL, 0x080fe20000410000ULL,
0x0000000955557220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x0000000930307220ULL, 0x080fe20000410000ULL,
0x0000000931317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x0000d7e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0926097589ULL, 0x0004e400000e0000ULL, 0x0000000912127220ULL, 0x08cfe20000410000ULL,
0x0000000913137220ULL, 0x080fe20000410000ULL, 0x0000000916167220ULL, 0x080fe20000410000ULL,
0x0000000917177220ULL, 0x080fe20000410000ULL, 0x000000091a1a7220ULL, 0x080fe20000410000ULL,
0x000000091b1b7220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000953537220ULL, 0x080fe20000410000ULL, 0x0000000956567220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x0000000932327220ULL, 0x080fe20000410000ULL,
0x0000000933337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff25ff7812ULL, 0x000fe4000780600cULL, 0x000000080d087209ULL, 0x000fd60007810000ULL,
0x800000080d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00040308ULL, 0x000e640000000800ULL, 0x0000000424240220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000724077221ULL, 0x000fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000004ff05723eULL, 0x000fe400000010ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x00005410050c7816ULL, 0x000fe20000000005ULL,
0x0000d6127f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c057589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x0000d6427f007947ULL, 0x000fea000b800000ULL,
0x00001f090c067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x00006960000f7802ULL, 0x000fc40000000f00ULL, 0x0000dc8000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000069b0000f7802ULL, 0x000fc40000000f00ULL,
0x0000dc3000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000007030c7812ULL, 0x00afe200078ec0ffULL,
0x000000020a487824ULL, 0x000fe200078e026bULL, 0x0000000268097810ULL, 0x004fe20007ffe0ffULL,
0x00a000005d3c783bULL, 0x000e620000000200ULL, 0x000000080c0c7812ULL, 0x000fe200078ef803ULL,
0x0000200048487824ULL, 0x000fc800078e00ffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x0000b00048297810ULL, 0x000fc80007ffe0ffULL, 0xfffffff80c587812ULL, 0x000fe200078ee209ULL,
0x000000105e0c7824ULL, 0x100fe200078e0229ULL, 0x00000002ff097819ULL, 0x000fe20000011600ULL,
0x00000010604c7824ULL, 0x100fe400078e0229ULL, 0x000000105f447824ULL, 0x100fe400078e0229ULL,
0x0000001061407824ULL, 0x100fe200078e0229ULL, 0x000000000c0c783bULL, 0x000ea20000004200ULL,
0x0000001058587824ULL, 0x000fe400078e00ffULL, 0x0000001065387824ULL, 0x000fe200078e0229ULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x0000080009247824ULL, 0x000fc400078e0258ULL,
0x0000001064347824ULL, 0x100fe200078e0229ULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x00000010622c7824ULL, 0x000fe200078e0229ULL, 0x0000002966297211ULL, 0x000fe400078e20ffULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x00a000002424783bULL, 0x000ee80000000200ULL,
0x000000002c2c783bULL, 0x000ee20000004200ULL, 0x000000053c3c0231ULL, 0x002fc400003400ffULL,
0x000000053e3e0231ULL, 0x080fe200003400ffULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x000000063d3d0231ULL, 0x080fe400003400ffULL, 0x000000063f3f0231ULL, 0x000fe200003400ffULL,
0x000000003434783bULL, 0x000e680000004200ULL, 0x000000002928783bULL, 0x000e640000004200ULL,
0x0000000c3c54723cULL, 0x044f700000041854ULL, 0x0000004c3c10723cULL, 0x048f700000041810ULL,
0x0000004e3c14723cULL, 0x000f620000041814ULL, 0x0000000524240231ULL, 0x000fc400003400ffULL,
0x0000000526260231ULL, 0x000fe400003400ffULL, 0x0000000625250231ULL, 0x080fe400003400ffULL,
0x0000000627270231ULL, 0x000fe200003400ffULL, 0x000000443c18723cULL, 0x040f700000041818ULL,
0x000000463c50723cULL, 0x040f700000041850ULL, 0x0000000e3c0c723cULL, 0x040f70000004181cULL,
0x000000403c20723cULL, 0x040f700000041820ULL, 0x000000423c30723cULL, 0x000f700000041830ULL,
0x0000002c2454723cULL, 0x060f700000041854ULL, 0x000000382410723cULL, 0x042f700000041810ULL,
0x0000003a2414723cULL, 0x040f700000041814ULL, 0x000000342418723cULL, 0x040f700000041818ULL,
0x000000362450723cULL, 0x040f700000041850ULL, 0x0000002e242c723cULL, 0x040b6e000004180cULL,
0x00013698090c7811ULL, 0x020fe200078e18ffULL, 0x000000282420723cULL, 0x040b700000041820ULL,
0x0000002a2424723cULL, 0x000b620000041830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000300020d7a10ULL, 0x000fe20007ffe0ffULL, 0x000000000cff7f8cULL, 0x0003e6000c80043fULL,
0x000000670d00720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x000000010d0c7810ULL, 0x042fe20007ffe0ffULL,
0x000001000d0f7824ULL, 0x000fe400078e026eULL, 0x00005900590e7a24ULL, 0x010fe200078e02ffULL,
0x000000670c00720cULL, 0x000fe20003f06070ULL, 0x00000100ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000600f327812ULL, 0x020fe200078ec0ffULL, 0x000000800e0c7824ULL, 0x000fc800078e00ffULL,
0x0000000169327824ULL, 0x000fe400078e0232ULL, 0x000064000c0c7625ULL, 0x000fc800078e000dULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff387819ULL, 0x000fe20000011603ULL,
0x00000080002b7824ULL, 0x000fe200078e00ffULL, 0x0000000f630e7217ULL, 0x000fe40007800000ULL,
0x00000004381c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001381d7824ULL, 0x040fe200078e0232ULL,
0x00000008381e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0fULL,
0x0000000c38287810ULL, 0x000fe20007ffe0ffULL, 0x000000011c397824ULL, 0x100fe200078e0203ULL,
0x00000010383e7810ULL, 0x000fe20007ffe0ffULL, 0x000000081c2a7824ULL, 0x000fe200078e00ffULL,
0x000000200e377817ULL, 0x000fe20003800000ULL, 0x000000011e347824ULL, 0x000fe200078e0203ULL,
0x00000014383c7810ULL, 0x000fe20007ffe0ffULL, 0x000000081e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a397812ULL, 0x000fe200078ee239ULL, 0x0000000128337824ULL, 0x000fe200078e0203ULL,
0x000000806a2a7812ULL, 0x000fe200078ef82bULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0xfffffff80f347812ULL, 0x000fe200078ee234ULL, 0x0000000828307824ULL, 0x000fe200078e00ffULL,
0x000000371c00720cULL, 0x0c0fe20003f86070ULL, 0x000000011c0f7824ULL, 0x000fe200078e0232ULL,
0x000000373800720cULL, 0x000fe20003fa6070ULL, 0x000001001d1c7825ULL, 0x000fe200078e002aULL,
0xfffffff830337812ULL, 0x000fc400078ee233ULL, 0x000000371e00720cULL, 0x080fe20003f66070ULL,
0x000000013e367824ULL, 0x100fe200078e0203ULL, 0x0000001c0c307210ULL, 0x000fe20007f1e0ffULL,
0x000000083e1f7824ULL, 0x000fe200078e00ffULL, 0x000000372800720cULL, 0x000fe20003f46070ULL,
0x000000013c357824ULL, 0x000fe400078e0203ULL, 0x000000010d317824ULL, 0x000fe200000e061dULL,
0xfffffff81f367812ULL, 0x000fe200078ee236ULL, 0x00002000001d7824ULL, 0x000fe400078e00ffULL,
0x000000083c3a7824ULL, 0x000fc400078e00ffULL, 0x00000001381c7824ULL, 0x000fe200078e0203ULL,
0x000020001d3b7812ULL, 0x000fe200078ec0ffULL, 0x00000001281f7824ULL, 0x100fe200078e0232ULL,
0xfffffff83a357812ULL, 0x000fe200078ee235ULL, 0x000000011e297824ULL, 0x000fe200078e0232ULL,
0x000000071c3a7812ULL, 0x000fe200078ec0ffULL, 0x000040000a3d7824ULL, 0x000fe400078e023bULL,
0x000001001f1e7825ULL, 0x000fe200078e002aULL, 0x0ffffff83a3b7812ULL, 0x000fe400078ef803ULL,
0x0000b0003d3a7810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e002aULL,
0x0000001e0c1e7210ULL, 0x000fc60007fde0ffULL, 0x000000013e1d7824ULL, 0x000fe200078e0232ULL,
0x0000000e0c0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010029287825ULL, 0x000fc800078e002aULL,
0x000001001d1c7825ULL, 0x000fe200078e002aULL, 0x000000280c287210ULL, 0x000fc60007f1e0ffULL,
0x000000103b3d7824ULL, 0x000fe200078e023aULL, 0x000000290d297210ULL, 0x040fe200007fe4ffULL,
0x000000013c3b7824ULL, 0x040fe200078e0232ULL, 0x000000373c00720cULL, 0x080fe20003f06070ULL,
0x000000010d1f7824ULL, 0x040fe200030e061fULL, 0x0000001c0c1c7210ULL, 0x000fe20007fde0ffULL,
0x000000010d0f7824ULL, 0x000fe200008e060fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e2000e901c46ULL, 0x00000010393f7824ULL, 0x100fe200078e023aULL,
0x00000018383c7810ULL, 0x040fe20007ffe0ffULL, 0x000000010d1d7824ULL, 0x000fe200030e061dULL,
0x0000001c38387810ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e023aULL,
0x000000000e3f7faeULL, 0x0005e2000e101c46ULL, 0x000000013c397824ULL, 0x000fe200078e0232ULL,
0x000000373e00720cULL, 0x080fe20003f26070ULL, 0x0000001035357824ULL, 0x000fe200078e023aULL,
0x000000373c00720cULL, 0x080fe20003fa6070ULL, 0x000001003b307825ULL, 0x002fe200078e002aULL,
0x000000373800720cULL, 0x000fc60003f86070ULL, 0x0000000138377824ULL, 0x000fe200078e0232ULL,
0x000000300c0e7210ULL, 0x004fe20007fde0ffULL, 0x000000013c327824ULL, 0x040fe400078e0203ULL,
0x000000083c3b7824ULL, 0x000fe400078e00ffULL, 0x000000010d0f7824ULL, 0x000fe400030e0631ULL,
0x0000010039307825ULL, 0x000fe200078e002aULL, 0xfffffff83b3b7812ULL, 0x000fc600078ee232ULL,
0x0000000138397824ULL, 0x000fe200078e0203ULL, 0x000000300c307210ULL, 0x000fe20007fde0ffULL,
0x0000000838387824ULL, 0x000fe400078e00ffULL, 0x00000100372a7825ULL, 0x000fc600078e002aULL,
0xfffffff8383d7812ULL, 0x000fe200078ee239ULL, 0x000000010d317824ULL, 0x000fe200030e0631ULL,
0x0000002a0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001034377824ULL, 0x100fe400078e023aULL,
0x0000001036397824ULL, 0x100fe400078e023aULL, 0x000000103b3b7824ULL, 0x100fe200078e023aULL,
0x0000000028377faeULL, 0x0003e2000d901c46ULL, 0x000000103d3d7824ULL, 0x000fe400078e023aULL,
0x000000010d0d7824ULL, 0x000fe200030e062bULL, 0x000000001e337faeULL, 0x0003e8000d101c46ULL,
0x000000001c397faeULL, 0x0003e8000c901c46ULL, 0x000000000e357faeULL, 0x0003e8000c101c46ULL,
0x00000000303b7faeULL, 0x0003e8000e901c46ULL, 0x000000000c3d7faeULL, 0x0003e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000403337811ULL, 0x040fe400078fe8ffULL,
0x0000000c031c7811ULL, 0x000fc400078fe8ffULL, 0x00000014031f7811ULL, 0x000fe200078fe8ffULL,
0x0000000133387824ULL, 0x100fe200078e0203ULL, 0x0000000803357811ULL, 0x000fe200078fe8ffULL,
0x00000008330f7824ULL, 0x000fe200078e00ffULL, 0x00000010031d7811ULL, 0x040fe200078fe8ffULL,
0x000000011c3a7824ULL, 0x140fe200078e0203ULL, 0x0000001c033d7811ULL, 0x000fe200078fe8ffULL,
0x000000011f367824ULL, 0x100fe200078e0203ULL, 0xfffffff80f387812ULL, 0x000fe200078ee238ULL,
0x000000081c0f7824ULL, 0x000fe200078e00ffULL, 0x0000001803297811ULL, 0x000fe200078fe8ffULL,
0x000000081f2b7824ULL, 0x000fe200078e00ffULL, 0x0000003203317211ULL, 0x000fe200078fe8ffULL,
0x0000000135397824ULL, 0x000fe200078e0203ULL, 0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL,
0x00000008350e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b367812ULL, 0x000fe200078ee236ULL,
0x00002000000f7824ULL, 0x000fc400078e00ffULL, 0x00000080002b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e397812ULL, 0x000fe200078ee239ULL, 0x000000011d3b7824ULL, 0x100fe200078e0203ULL,
0x000020000f3f7812ULL, 0x000fe200078ec0ffULL, 0x000000011c0f7824ULL, 0x100fe200078e0232ULL,
0x000000031d0e7819ULL, 0x000fe200000006ffULL, 0x000000013d1c7824ULL, 0x040fe200078e0203ULL,
0x000000806a2a7812ULL, 0x000fe200078ef82bULL, 0x000000083d2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee23bULL, 0x0000000133337824ULL, 0x000fe200078e0232ULL,
0x00000003030e7211ULL, 0x000fe200078fe8ffULL, 0x0000000129377824ULL, 0x000fe200078e0203ULL,
0xfffffff82b3e7812ULL, 0x000fe200078ee21cULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x000000070e0e7812ULL, 0x000fe200078ec0ffULL, 0x00000008291e7824ULL, 0x000fc400078e00ffULL,
0x0000000135357824ULL, 0x100fe200078e0232ULL, 0x0ffffff80e3c7812ULL, 0x000fe200078ef803ULL,
0x000000011d1d7824ULL, 0x100fe200078e0232ULL, 0xfffffff81e377812ULL, 0x000fe200078ee237ULL,
0x000000011f1f7824ULL, 0x100fe400078e0232ULL, 0x0000000129297824ULL, 0x100fe400078e0232ULL,
0x000000013d3d7824ULL, 0x000fe400078e0232ULL, 0x0000010031307825ULL, 0x000fc800078e002aULL,
0x0000010033327825ULL, 0x000fe200078e002aULL, 0x000000300c307210ULL, 0x000fc60007f1e0ffULL,
0x000040000a3f7824ULL, 0x000fe200078e023fULL, 0x000000320c327210ULL, 0x000fe20007f3e0ffULL,
0x0000010035347825ULL, 0x000fc600078e002aULL, 0x0000b0003f3f7810ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e002aULL, 0x000000340c347210ULL, 0x000fc60007f5e0ffULL,
0x000001001d1c7825ULL, 0x100fe200078e002aULL, 0x0000000e0c0e7210ULL, 0x000fe40007f7e0ffULL,
0x000000350d357210ULL, 0x000fe200017fe4ffULL, 0x000001001f1e7825ULL, 0x000fc800078e002aULL,
0x0000010029287825ULL, 0x000fc800078e002aULL, 0x000001003d2a7825ULL, 0x000fe200078e002aULL,
0x000000280c287210ULL, 0x000fc60007f5e0ffULL, 0x000000010d317824ULL, 0x040fe200000e0631ULL,
0x0000001c0c1c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d337824ULL, 0x040fe200008e0633ULL,
0x0000001e0c1e7210ULL, 0x000fe20007f3e0ffULL, 0x000000103c3d7824ULL, 0x100fe400078e023fULL,
0x0000001038417824ULL, 0x000fe400078e023fULL, 0x000000010d0f7824ULL, 0x000fe200018e060fULL,
0x0000002a0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001039397824ULL, 0x100fe200078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303d7faeULL, 0x0003e2000b901c46ULL,
0x000000103a437824ULL, 0x000fc400078e023fULL, 0x000000103b3b7824ULL, 0x000fe200078e023fULL,
0x0000000032417faeULL, 0x0003e2000b901c46ULL, 0x000000010d1d7824ULL, 0x040fe400000e061dULL,
0x0000001036457824ULL, 0x000fe200078e023fULL, 0x0000000034397faeULL, 0x0003e2000b901c46ULL,
0x000000010d1f7824ULL, 0x000fe400008e061fULL, 0x0000001037377824ULL, 0x000fe200078e023fULL,
0x000000000e437faeULL, 0x0003e2000b901c46ULL, 0x000000010d297824ULL, 0x000fc400010e0629ULL,
0x000000103e3f7824ULL, 0x000fe200078e023fULL, 0x000000001c3b7faeULL, 0x0003e2000b901c46ULL,
0x000000010d0d7824ULL, 0x000fc600018e062bULL, 0x000000001e457faeULL, 0x0003e8000b901c46ULL,
0x0000000028377faeULL, 0x0003e8000b901c46ULL, 0x000000000c3f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x000000106d0c7812ULL, 0x040fe400078ec0ffULL,
0x000000086d0d7812ULL, 0x000fc600078ec0ffULL, 0x00000020090c7824ULL, 0x000fc800078e020cULL,
0x000000010d1e7824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013668001e0c7f8cULL, 0x0002a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01366c001e097984ULL, 0x000ee40000000800ULL, 0x8000000009ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101f00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c0e1c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e0fULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc8000001141dULL,
0x0000001c09097211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x0000000209097819ULL, 0x000fc8000000121cULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01366c001e097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001806a5c7810ULL, 0x000fca0007ffe05cULL, 0x000000016f5c7824ULL, 0x000fca00078e025cULL,
0x013000005c0d7984ULL, 0x000ea80000000800ULL, 0x013200005c1c7984ULL, 0x0006620000000800ULL,
0x000000080d00720bULL, 0x004fe20003f1d000ULL, 0x0000c1f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff091d7812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff0c7224ULL, 0x000fd400078e0008ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000300097811ULL, 0x000fe400078ff0ffULL, 0x000000080d00720bULL, 0x000fe40003f34000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x0000c1927f007947ULL, 0x000fd4000b800000ULL,
0x00000000000c7806ULL, 0x000fc400008e0100ULL, 0x00000080006a8824ULL, 0x000fe200078e026aULL,
0x000000080d098209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100c0e7816ULL, 0x000fe200000000ffULL, 0x000000016f6a8824ULL, 0x000fca00078e026aULL,
0x013400096a008388ULL, 0x0005e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000080d097209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL,
0x0000000809097221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x00000009001e7308ULL, 0x002e640000000800ULL, 0x0000001e07077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011603ULL,
0x0000c0b27f007947ULL, 0x000fea000b800000ULL, 0x00001f091e097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000914147220ULL, 0x080fe20000410000ULL, 0x0000000915157220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000951517220ULL, 0x080fe20000410000ULL,
0x0000000954547220ULL, 0x080fe20000410000ULL, 0x0000000955557220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x0a0fe20000410000ULL, 0x0000000921217220ULL, 0x080fe20000410000ULL,
0x0000000924247220ULL, 0x080fe20000410000ULL, 0x0000000925257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803097811ULL, 0x000fe200078ff0ffULL,
0x0000bf927f007947ULL, 0x000fea000b800000ULL, 0x00001f091e097589ULL, 0x0004e400000e0000ULL,
0x0000000912127220ULL, 0x08cfe20000410000ULL, 0x0000000913137220ULL, 0x080fe20000410000ULL,
0x0000000916167220ULL, 0x080fe20000410000ULL, 0x0000000917177220ULL, 0x080fe20000410000ULL,
0x000000091a1a7220ULL, 0x080fe20000410000ULL, 0x000000091b1b7220ULL, 0x080fe20000410000ULL,
0x0000000952527220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000957577220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x0a0fe20000410000ULL, 0x0000000923237220ULL, 0x080fe20000410000ULL,
0x0000000926267220ULL, 0x080fe20000410000ULL, 0x0000000927277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff1dff7812ULL, 0x000fe4000780600cULL,
0x000000080d0c7209ULL, 0x000fd60007810000ULL, 0x8000000c0d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00040308ULL, 0x000ea40000000800ULL,
0x000000041c1c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000071c077221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000004ff05723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x0000541005087816ULL, 0x000fe20000000005ULL, 0x0000bdc27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d08057589ULL, 0x0002a400000e0000ULL, 0x000000080d097810ULL, 0x000fe20007ffe0ffULL,
0x0000bdf27f007947ULL, 0x000fea000b800000ULL, 0x00001f0908067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00008370000f7802ULL, 0x000fc40000000f00ULL,
0x0000c27000007944ULL, 0x036fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x000083c0000f7802ULL, 0x000fc40000000f00ULL, 0x0000c22000007944ULL, 0x032fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000703087812ULL, 0x00afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000808087812ULL, 0x000fca00078ef803ULL,
0x0000000808097824ULL, 0x004fe200078e00ffULL, 0x00000002ff087819ULL, 0x000fc80000011600ULL,
0xfffffff809097812ULL, 0x000fca00078ee268ULL, 0x0000008008407824ULL, 0x000fca00078e0209ULL,
0x0000a80040407811ULL, 0x000fca00078e20ffULL, 0x0000c000480d7810ULL, 0x000fe20007ffe0ffULL,
0x000000004040783bULL, 0x000e620000000200ULL, 0x0000000300097811ULL, 0x000fe400078ff0ffULL,
0x0000000d5f487211ULL, 0x000fe200078e20ffULL, 0x00000010604c7824ULL, 0x100fe200078e020dULL,
0x0000030002027a10ULL, 0x000fe20007ffe0ffULL, 0x000000105e3c7824ULL, 0x100fe200078e020dULL,
0x000136a008087811ULL, 0x000fe200078e18ffULL, 0x0000001061447824ULL, 0x000fe200078e020dULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x00000800091c7824ULL, 0x000fc400078e0258ULL,
0x0000001065387824ULL, 0x100fe200078e020dULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x0000001064347824ULL, 0x100fe400078e020dULL, 0x0000001062307824ULL, 0x120fe200078e020dULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0x0000001066287824ULL, 0x000fc600078e020dULL,
0x000000004444783bULL, 0x000fe80000004200ULL, 0x009000001c1c783bULL, 0x000ee80000000200ULL,
0x000000003838783bULL, 0x000ee80000004200ULL, 0x000000003434783bULL, 0x000ee80000004200ULL,
0x000000003030783bULL, 0x000ee20000004200ULL, 0x0000000540400231ULL, 0x002fc600003400ffULL,
0x000000002828783bULL, 0x000e620000004200ULL, 0x0000000542420231ULL, 0x000fe400003400ffULL,
0x0000000641410231ULL, 0x080fe400003400ffULL, 0x0000000643430231ULL, 0x000fce00003400ffULL,
0x0000004c4010723cULL, 0x044f700000041810ULL, 0x0000004e4014723cULL, 0x000f620000041814ULL,
0x000000051c1c0231ULL, 0x088fe400003400ffULL, 0x000000051e1e0231ULL, 0x000fca00003400ffULL,
0x000000484018723cULL, 0x000f620000041818ULL, 0x000000061d1d0231ULL, 0x080fe400003400ffULL,
0x000000061f1f0231ULL, 0x000fca00003400ffULL, 0x0000004a4050723cULL, 0x040f700000041850ULL,
0x0000003c4054723cULL, 0x040f700000041854ULL, 0x0000003e402c723cULL, 0x040f70000004182cULL,
0x000000444020723cULL, 0x040f700000041820ULL, 0x000000464024723cULL, 0x000f700000041824ULL,
0x000000381c10723cULL, 0x060b700000041810ULL, 0x0000003a1c14723cULL, 0x040b700000041814ULL,
0x000000341c18723cULL, 0x040b700000041818ULL, 0x000000361c50723cULL, 0x040b700000041850ULL,
0x000000301c54723cULL, 0x040b700000041854ULL, 0x000000321c2c723cULL, 0x040b70000004182cULL,
0x000000281c20723cULL, 0x042b700000041820ULL, 0x0000002a1c1c723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000670200720cULL, 0x000fe20003f06070ULL,
0x0000000008ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff942000007947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e640000002500ULL,
0x000000670200720cULL, 0x002fda0003f06070ULL, 0x0000032000000947ULL, 0x000fea0003800000ULL,
0x0180000007037810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000887000047802ULL, 0x000fc40000000f00ULL,
0x0000bbc000007944ULL, 0x030fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000007ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff047819ULL, 0x002fe40000011605ULL, 0x0000000805067811ULL, 0x000fc800078ff0ffULL,
0x00001f0403047589ULL, 0x00ce6800000e0000ULL, 0x00001f0603057589ULL, 0x000ea200000e0000ULL,
0x0000001004107220ULL, 0x062fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000005404547220ULL, 0x040fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x000fe20000410000ULL,
0x0000001205127220ULL, 0x044fe20000410000ULL, 0x0000001305137220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x000fc20000410000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00000020210f723eULL, 0x020fc400000010ffULL,
0x000000101103723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000121311723eULL, 0x000fe400000010ffULL, 0x000000161712723eULL, 0x000fe400000010ffULL,
0x0000001a1b13723eULL, 0x000fc400000010ffULL, 0x0000001e1f1a723eULL, 0x000fe400000010ffULL,
0x0000001c1d10723eULL, 0x000fe400000010ffULL, 0x000000181905723eULL, 0x000fe400000010ffULL,
0x000000222319723eULL, 0x000fe400000010ffULL, 0x00000002ff207819ULL, 0x002fe4000001160dULL,
0x000000080d297811ULL, 0x000fc400078ff0ffULL, 0x0000000220097810ULL, 0x040fe20007ffe0ffULL,
0x0000000820167824ULL, 0x040fe200078e00ffULL, 0x0000000620177810ULL, 0x040fe20007ffe0ffULL,
0x00000008201e7824ULL, 0x040fe200078e00ffULL, 0x0000000120087810ULL, 0x040fe20007ffe0ffULL,
0x00000008201b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8161d7812ULL, 0x000fe200078ee209ULL,
0x00000008201c7824ULL, 0x040fe200078e00ffULL, 0x0000000420097810ULL, 0x040fe20007ffe0ffULL,
0x0000000820237824ULL, 0x040fe200078e00ffULL, 0x0000000520167810ULL, 0x040fe20007ffe0ffULL,
0x00000008201f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e257812ULL, 0x000fe200078ee217ULL,
0x0000000820177824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL,
0x0000000820277824ULL, 0x040fe200078e00ffULL, 0x0000000320087810ULL, 0x000fe20007ffe0ffULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c217812ULL, 0x000fe200078ee209ULL,
0x000010006b097824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee216ULL,
0x000000040d167824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL,
0x000008000a087824ULL, 0x000fe200078e0209ULL, 0xfffffff817177812ULL, 0x000fc400078ee220ULL,
0xffffffff201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0208ULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x0000001017177824ULL, 0x000fe200078e0208ULL,
0xfffffff827277812ULL, 0x000fe200078ee21cULL, 0x000000101d1d7824ULL, 0x100fe200078e0208ULL,
0xfffffff81e297812ULL, 0x000fe200078ee229ULL, 0x000000101f1f7824ULL, 0x100fe200078e0208ULL,
0x000000141504723eULL, 0x000fe200000010ffULL, 0x0000001021217824ULL, 0x000fe200078e0208ULL,
0x000000505106723eULL, 0x000fe200000010ffULL, 0x00000001171c7824ULL, 0x000fe200078e0216ULL,
0x0000000829297211ULL, 0x000fe200078e20ffULL, 0x0000001023237824ULL, 0x100fe200078e0208ULL,
0x00000054550b723eULL, 0x000fe200000010ffULL, 0x00000001161b7824ULL, 0x040fe200078e021bULL,
0x0000002c2d0e723eULL, 0x000fe200000010ffULL, 0x0000001025257824ULL, 0x100fe200078e0208ULL,
0x000000031c007388ULL, 0x0003e20000000800ULL, 0x00000001161e7824ULL, 0x040fe200078e021dULL,
0x000000525314723eULL, 0x000fe200000010ffULL, 0x0000001027277824ULL, 0x000fe200078e0208ULL,
0x000000041b007388ULL, 0x000fe20000000800ULL, 0x00000001161f7824ULL, 0x040fe200078e021fULL,
0x000000565715723eULL, 0x000fe200000010ffULL, 0x0000000116207824ULL, 0x040fe200078e0221ULL,
0x000000051e007388ULL, 0x0005e20000000800ULL, 0x0000000116237824ULL, 0x040fe200078e0223ULL,
0x0000002e2f18723eULL, 0x000fe200000010ffULL, 0x0000000116227824ULL, 0x040fe200078e0225ULL,
0x000000061f007388ULL, 0x000fe20000000800ULL, 0x0000000116277824ULL, 0x040fe200078e0227ULL,
0x000000ff00037306ULL, 0x002fe20000205400ULL, 0x0000000116167824ULL, 0x000fe200078e0229ULL,
0x0000000b20007388ULL, 0x0003e20000000800ULL, 0x000000016e1c7824ULL, 0x000fc600078e020dULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000101c057824ULL, 0x004fe200078e0209ULL,
0x000000ff00047306ULL, 0x000ea40000209400ULL, 0x0000000f22007388ULL, 0x000fe20000000800ULL,
0x000000ff000b7245ULL, 0x002fc6000020d400ULL, 0x0000001027007388ULL, 0x000fe80000000800ULL,
0x0000001116007388ULL, 0x000fe80000000800ULL, 0x000400121b007388ULL, 0x000fe20000000800ULL,
0x000000030400720bULL, 0x004fc60003f1d000ULL, 0x000400131e007388ULL, 0x000fe80000000800ULL,
0x000400141f007388ULL, 0x000fe80000000800ULL, 0x0004001520007388ULL, 0x000fe40000000800ULL,
0x000000010b0b0812ULL, 0x000fc400078efcffULL, 0x0004001823007388ULL, 0x000fe40000000800ULL,
0x0000000b0b03723eULL, 0x000fe400000010ffULL, 0x0004001922007388ULL, 0x000fe80000000800ULL,
0x0004001a27007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000005287984ULL, 0x000e620000000c00ULL, 0x00000300ff227624ULL, 0x000fc600078e00ffULL,
0x0004000005147984ULL, 0x000ea40000000c00ULL, 0x000000012200780cULL, 0x000fe40003f05270ULL,
0x00080000052c7984ULL, 0x000ee80000000c00ULL, 0x000c000005107984ULL, 0x000ee20000000c00ULL,
0x3f803f80032b7831ULL, 0x042fe4000020002bULL, 0x3f803f80032a7831ULL, 0x000fc4000020002aULL,
0x3f803f8003297831ULL, 0x040fe40000200029ULL, 0x3f803f8003287831ULL, 0x040fe40000200028ULL,
0x3f803f8003177831ULL, 0x044fe40000200017ULL, 0x3f803f8003167831ULL, 0x040fe40000200016ULL,
0x3f803f8003157831ULL, 0x040fe40000200015ULL, 0x3f803f8003147831ULL, 0x000fc40000200014ULL,
0x3f803f802b2b7831ULL, 0x008fe4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fe4000020002eULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fe4000020002cULL,
0x3f803f8017177831ULL, 0x000fe40000200013ULL, 0x3f803f8016167831ULL, 0x000fe20000200012ULL,
0x0000002805007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fc40000200011ULL,
0x3f803f8014147831ULL, 0x000fca0000200010ULL, 0x0004001405007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a9000008947ULL, 0x000fea0003800000ULL,
0x00000400ff037624ULL, 0x000fe200078e00ffULL, 0x0000000000067919ULL, 0x000e660000002600ULL,
0x00006c0003037a24ULL, 0x000fe200078e02ffULL, 0x00000000000f7919ULL, 0x000e680000002700ULL,
0x0000000f03187811ULL, 0x040fe200078e10ffULL, 0x0000030003037a24ULL, 0x000fe200078e02ffULL,
0x0000000005107984ULL, 0x000ea40000000c00ULL, 0xfffffff018187812ULL, 0x000fc400078ec0ffULL,
0x0004000005147984ULL, 0x0006a60000000c00ULL, 0x0000008003047824ULL, 0x000fc800078e0218ULL,
0x0000008003037824ULL, 0x000fe200078e0204ULL, 0x000000401c057810ULL, 0x008fc80007ffe0ffULL,
0x0000007f03037810ULL, 0x000fe20007ffe0ffULL, 0x000004000f067a24ULL, 0x002fc600078e0206ULL,
0xffffff8003037812ULL, 0x000fe200078ec0ffULL, 0x00000300060f7a24ULL, 0x000fc600078e02ffULL,
0x00007000031b7a10ULL, 0x000fe20007f1e0ffULL, 0x000000010f027824ULL, 0x000fc800078e0202ULL,
0x00007100ff197624ULL, 0x000fe200000e06ffULL, 0x000000010aff7812ULL, 0x000fe4000780f800ULL,
0x0000001b021a7211ULL, 0x000fc800078260ffULL, 0x00000019021b7211ULL, 0x000fe400008f64ffULL,
0x00007000180e7a10ULL, 0x000fc60007f3e0ffULL, 0x000008006b1a7825ULL, 0x000fc800078e001aULL,
0x00007100ff197624ULL, 0x000fe400008e06ffULL, 0x000000101c1c7825ULL, 0x000fc800078e001aULL,
0x00000010051a7825ULL, 0x000fe200078e001aULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000100d1e7824ULL, 0x004fe200078e00ffULL, 0x00000001ff1f7819ULL, 0x000fe2000001160dULL,
0x0000008002057824ULL, 0x000fe200078e00ffULL, 0x00000019ff027819ULL, 0x000fe40000011602ULL,
0x000000701e217812ULL, 0x000fe400078ec0ffULL, 0x0000000c1f1e7812ULL, 0x000fe400078ec0ffULL,
0x0000700005207a10ULL, 0x000fc40007ebe004ULL, 0x0000000e21057210ULL, 0x000fe40007a3e005ULL,
0x000000201e207210ULL, 0x000fe40007c7e021ULL, 0x00007100021f7a10ULL, 0x000fe40002fec4ffULL,
0x000000051e1e7210ULL, 0x000fe40007fbe0ffULL, 0x00000019ff027210ULL, 0x000fe40000fe4402ULL,
0x0000001fff217210ULL, 0x000fc60001fe84ffULL, 0x000000ffff1f7224ULL, 0x000fca00028e0602ULL,
0x0000000c1e007986ULL, 0x0003e8000c101906ULL, 0x0000000720007986ULL, 0x0003e4000c101906ULL,
0x000000ff0d00720cULL, 0x004fe20000705670ULL, 0x000000101c007986ULL, 0x000fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000141a007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff077424ULL, 0x002fe200078e00ffULL, 0xffffffff22057810ULL, 0x000fc60007ffe0ffULL,
0x0000700006067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000005060679a8ULL, 0x000ea400099ee1c6ULL, 0x000000050600720cULL, 0x004fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000002ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x002e640000000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x0000261000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x000000100d027824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe4000001160dULL,
0x0000000e0f067211ULL, 0x000fe400078038ffULL, 0x0000007002077812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fe400078ec0ffULL, 0x000000190f027211ULL, 0x000fe400000f3cffULL,
0x0000000605067210ULL, 0x000fc8000791e007ULL, 0x00000002ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606027981ULL, 0x000328000c1e1900ULL, 0x0000800606117981ULL, 0x000322000c1e1900ULL,
0x000000022200780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x0001000606137981ULL, 0x002322000c1e1900ULL, 0x000000042200780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800606157981ULL, 0x002322000c1e1900ULL,
0x000000042200780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000606177981ULL, 0x002322000c1e1900ULL, 0x000000062200780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800606197981ULL, 0x002322000c1e1900ULL,
0x000000062200780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082200780cULL, 0x002fe20003f06070ULL, 0x00030006061b7981ULL, 0x000318000c1e1900ULL,
0x00038006061d0981ULL, 0x000324000c1e1900ULL, 0x0000000722057810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff057819ULL, 0x000fc80000011605ULL, 0x000000ff0500720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x000000180f217211ULL, 0x000fe200078038ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1f7224ULL, 0x010fe200078e0002ULL, 0x0000700021217a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0f0c7211ULL, 0x000fe400000f3cffULL, 0x0000078021217810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0c7a10ULL, 0x000fc400017e240cULL, 0x000003000e007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000405007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080e067810ULL, 0x040fe40007ffe0ffULL,
0x000000010e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001f02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffc8006061f7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090e067810ULL, 0x042fe40007ffe0ffULL,
0x000000020e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001102027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000040d067819ULL, 0x000fe400000006ffULL,
0x00000001ff077819ULL, 0x000fe4000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffd000606117981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000030e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffd800606137981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000040e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001502027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffe000606157981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000050e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001702027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xfffe800606177981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000060e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001902027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xffff000606197981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0e067810ULL, 0x042fe40007ffe0ffULL,
0x000000070e077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001b02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0xffff8006061b7981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0e067810ULL, 0x002fe40007ffe0ffULL,
0x0000001d02027209ULL, 0x000fe40007810000ULL, 0x0000030006007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100d067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc8000001160dULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x0000000621067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060cULL, 0x00000006061d7981ULL, 0x000326000c1e1900ULL,
0x0000040021217810ULL, 0x000fe40007f3e0ffULL, 0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e060cULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x00000000000d7919ULL, 0x000ea40000000000ULL, 0x000000100d057824ULL, 0x004fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fc8000001160dULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fca00078ec0ffULL, 0x0000000105057824ULL, 0x000fca00078e0206ULL,
0x0000000205007388ULL, 0x0103e40000000800ULL, 0x000000070d00780cULL, 0x000fe20003f04070ULL,
0x000000010a1d7824ULL, 0x000fe200078e020fULL, 0x0000700003027a10ULL, 0x002fe20007f3e0ffULL,
0x000008006b0c7824ULL, 0x000fe200078e00ffULL, 0x00000002ff057819ULL, 0x000fe20000011600ULL,
0x0000020000117824ULL, 0x000fe200078e00ffULL, 0x000000200d137810ULL, 0x000fe20007ffe0ffULL,
0x00007100ff037624ULL, 0x000fe200008e06ffULL, 0x0000000105057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000010001d067825ULL, 0x000fe200078e0002ULL,
0x0000080011117812ULL, 0x000fe200078ec0ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000700018187a10ULL, 0x000fe20007f5e0ffULL, 0x000000020a0e8824ULL, 0x100fe200078e026bULL,
0x0000000c06067210ULL, 0x000fe20007f3e0ffULL, 0x000000020a1e8824ULL, 0x000fe200078e026bULL,
0x000000400d157810ULL, 0x040fe20007ffe0ffULL, 0x000000020e208824ULL, 0x000fe200078e0205ULL,
0x000000600d177810ULL, 0x040fe20007ffe0ffULL, 0x000020000a0e7824ULL, 0x000fe200078e0209ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000021e1e8824ULL, 0x000fe200078e0205ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000700004007a10ULL, 0x000fe20007f3e0ffULL, 0x000000100d057824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x100fe2000001160dULL, 0x00007100ff1b7624ULL, 0x000fe200010e06ffULL,
0x000000110e107210ULL, 0x000fe20007ffe0ffULL, 0x00007100ff197624ULL, 0x000fe200008e06ffULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x000000081e1e8824ULL, 0x000fe200078e020dULL,
0x0000000c04047812ULL, 0x000fe200078ec0ffULL, 0x000000100d217824ULL, 0x000fe200078e0210ULL,
0x000000001d168211ULL, 0x000fe200078238ffULL, 0x0000001013107825ULL, 0x100fe200078e0006ULL,
0x000000181d1c8211ULL, 0x000fe200078438ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000045801e238811ULL, 0x000fe200078e20ffULL, 0x0000001015127825ULL, 0x000fe200078e0006ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000001051a7824ULL, 0x000fe200078e0204ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000001017147825ULL, 0x100fe200078e0006ULL,
0x000000191d178211ULL, 0x000fe200008f3cffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000003000a007a0cULL, 0x000fe20003f26070ULL, 0x000000100d067825ULL, 0x000fe200078e0006ULL,
0x0000001b1d1d8211ULL, 0x000fe200010f3cffULL, 0x000000001a1a7984ULL, 0x000e620000000800ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000820208824ULL, 0x000fe200078e020dULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006217faeULL, 0x0005e2000b901c46ULL, 0x000000100d168825ULL, 0x000fe200078e0016ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000418020258811ULL, 0x000fe200078e20ffULL,
0x0038000010217faeULL, 0x0007e2000b901c46ULL, 0x000000ffff3c7224ULL, 0x000fc600078e00ffULL,
0x0058000012217faeULL, 0x0007e2000b901c46ULL, 0x000000100d068825ULL, 0x004fc600078e001cULL,
0x0078000014217faeULL, 0x0007e2000b901c46ULL, 0x00000000001c7805ULL, 0x000fc6000001ff00ULL,
0x0000000016238faeULL, 0x0005e8000b901c46ULL, 0x0000000006258faeULL, 0x0003e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x0000000000227805ULL, 0x004fe2000001ff00ULL, 0x0000000000247805ULL, 0x002fe2000001ff00ULL,
0x00000c7000001947ULL, 0x000fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fca00078e000aULL, 0x000000023d3e7810ULL, 0x000fc80007ffe0ffULL,
0x000003003e007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x000000070d00780cULL, 0x000fe20003f44070ULL, 0x000000010f117824ULL, 0x100fe200078e023eULL,
0x00000001ff067819ULL, 0x000fe4000001163eULL, 0x000000400d417810ULL, 0x000fe20007ffe0ffULL,
0x0000100011047825ULL, 0x000fe200078e0002ULL, 0x0000000106067812ULL, 0x000fe400078ec0ffULL,
0x000000600d437810ULL, 0x000fe40007ffe0ffULL, 0x0000000c04127210ULL, 0x000fe20007f1e0ffULL,
0x000004003e047824ULL, 0x000fc400078e00ffULL, 0x000000020a13a824ULL, 0x140fe200078e026bULL,
0x000000181110a211ULL, 0x000fe200078238ffULL, 0x000000020a07a824ULL, 0x000fe400078e026bULL,
0x000000021342a824ULL, 0x100fe400078e0206ULL, 0x000000ffff137224ULL, 0x000fe200000e0605ULL,
0x0000080004057812ULL, 0x000fe200078ec0ffULL, 0x000000020740a824ULL, 0x000fe200078e0206ULL,
0x000000001114a211ULL, 0x000fe200078038ffULL, 0x000000100d167825ULL, 0x040fe200078e0012ULL,
0x000000200d077810ULL, 0x000fc40007ffe0ffULL, 0x000000191115a211ULL, 0x040fe200000f3cffULL,
0x000000010e047824ULL, 0x000fe200078e0205ULL, 0x0000001b1111a211ULL, 0x000fe200008f3cffULL,
0x000000084040a824ULL, 0x100fe400078e020dULL, 0x000000100d3f7824ULL, 0x000fe400078e0204ULL,
0x000000084242a824ULL, 0x000fe400078e020dULL, 0x0000001007047825ULL, 0x100fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000163f7faeULL, 0x0003e6000b901c46ULL,
0x0000001041067825ULL, 0x100fe200078e0012ULL, 0x000045804041a811ULL, 0x000fe200078e20ffULL,
0x00380000043f7faeULL, 0x0003e4000b901c46ULL, 0x0000001043127825ULL, 0x000fe200078e0012ULL,
0x000041804243a811ULL, 0x000fe200078e20ffULL, 0x00580000063f7faeULL, 0x0003e4000b901c46ULL,
0x000000100d14a825ULL, 0x000fc400078e0014ULL, 0x00780000123f7faeULL, 0x0003e4000b901c46ULL,
0x000000100d10a825ULL, 0x000fe400078e0010ULL, 0x000000001441afaeULL, 0x0003e8000b901c46ULL,
0x000000001043afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000403d047824ULL, 0x002fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe2000001160dULL,
0x000000020a077824ULL, 0x000fe200078e026bULL, 0x00000002ff147819ULL, 0x000fe2000001160dULL,
0x000000100d057824ULL, 0x000fe200078e00ffULL, 0x0000008004047812ULL, 0x000fc400078ec0ffULL,
0x0000000314137819ULL, 0x040fe200000006ffULL, 0x0000000814177824ULL, 0x000fe200078e00ffULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x0000010007067824ULL, 0x000fe200078e0004ULL,
0x0000000c10047812ULL, 0x000fe200078ec0ffULL, 0x000000040d077824ULL, 0x000fe200078e00ffULL,
0x0000000814487810ULL, 0x040fe20007ffe0ffULL, 0x0000000814427824ULL, 0x000fe200078e00ffULL,
0x0000000604107210ULL, 0x000fe20007ffe005ULL, 0x0000000814457824ULL, 0x040fe200078e00ffULL,
0x0000000114067810ULL, 0x000fe20007ffe0ffULL, 0x00000008483f7824ULL, 0x000fe200078e00ffULL,
0x0000000c07467812ULL, 0x000fe200078ec0ffULL, 0x0000000814437824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee206ULL, 0x000004003d067824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800010117984ULL, 0x000e620000000800ULL,
0x0000080006077812ULL, 0x000fe200078ec0ffULL, 0x00000008143d7824ULL, 0x040fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee214ULL, 0x0045800010157984ULL, 0x0004e20000000800ULL,
0x0000000214167810ULL, 0x040fe20007ffe0ffULL, 0x0000000814477824ULL, 0x040fe200078e00ffULL,
0x0000000414407810ULL, 0x040fe20007ffe0ffULL, 0x0000000814497824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe400078ee216ULL, 0xfffffff845457812ULL, 0x000fc400078ee240ULL,
0x000001800e107810ULL, 0x004fe40007ffe007ULL, 0xfffffff83f077812ULL, 0x000fe400078ee248ULL,
0x0000000514407810ULL, 0x040fe20007ffe0ffULL, 0x0000001013067824ULL, 0x100fe200078e0210ULL,
0xffffffff14447810ULL, 0x000fe20007ffe0ffULL, 0x0000001007077824ULL, 0x000fe400078e0210ULL,
0x0000000146067824ULL, 0x040fe200078e0206ULL, 0xfffffff849497812ULL, 0x000fe200078ee244ULL,
0x0000000146137824ULL, 0x000fc400078e0207ULL, 0x0000001017077824ULL, 0x000fe200078e0210ULL,
0x0000000006167984ULL, 0x000ea80000000800ULL, 0x0000000013417984ULL, 0x0003e40000000800ULL,
0x000000111a117221ULL, 0x002fc80000010100ULL, 0x3fb8aa3b11127820ULL, 0x000fe20000410000ULL,
0x0000000314117810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8423f7812ULL, 0x000fe200078ee211ULL,
0x0000001200127308ULL, 0x000ee20000000800ULL, 0x0000000146117824ULL, 0x040fe400078e0207ULL,
0x000000103d077824ULL, 0x100fe400078e0210ULL, 0x000000103f137824ULL, 0x000fe200078e0210ULL,
0x00000000113d7984ULL, 0x000fe60000000800ULL, 0x0000000146137824ULL, 0x000fe200078e0213ULL,
0x0004000011427984ULL, 0x0003e80000000800ULL, 0x0004000013447984ULL, 0x000fe20000000800ULL,
0x0000001512177220ULL, 0x008fe20000410000ULL, 0x0000000146127824ULL, 0x000fe200078e0207ULL,
0xfffffff843157812ULL, 0x000fe200078ee240ULL, 0x0000001045117824ULL, 0x002fe200078e0210ULL,
0x0000000614407810ULL, 0x000fe20007ffe0ffULL, 0x00001f1417077589ULL, 0x0002e200000e0000ULL,
0x0000003c173c7221ULL, 0x000fe20000010000ULL, 0x0000000146117824ULL, 0x000fe200078e0211ULL,
0xfffffff847477812ULL, 0x000fe200078ee240ULL, 0x00000000123f7984ULL, 0x000fe80000000800ULL,
0x00001f4817067589ULL, 0x000ee200000e0000ULL, 0x0000001015147824ULL, 0x002fc600078e0210ULL,
0x0004000012437984ULL, 0x0004620000000800ULL, 0x0000001047157824ULL, 0x000fe400078e0210ULL,
0x0000000146147824ULL, 0x040fe200078e0214ULL, 0x0000000013407984ULL, 0x000e620000000800ULL,
0x0000001049107824ULL, 0x000fe400078e0210ULL, 0x0000000146157824ULL, 0x040fe200078e0215ULL,
0x0000000011177984ULL, 0x000e620000000800ULL, 0x00005410ff127816ULL, 0x004fe20000000016ULL,
0x0000000146107824ULL, 0x000fc400078e0210ULL, 0x0004000011457984ULL, 0x0004640000000800ULL,
0x0000000712397223ULL, 0x008fe20000010039ULL, 0x00005410ff127816ULL, 0x000fe20000000041ULL,
0x0000000014137984ULL, 0x000ee20000000800ULL, 0x00007610ff117816ULL, 0x004fc60000000016ULL,
0x0000000612377223ULL, 0x080fe20000010037ULL, 0x00005410ff127816ULL, 0x000fe2000000003dULL,
0x0000000015167984ULL, 0x000fe20000000800ULL, 0x0000000711387223ULL, 0x080fe20000010038ULL,
0x00007610ff117816ULL, 0x000fe40000000041ULL, 0x0000000712357223ULL, 0x000fe20000010035ULL,
0x00005410ff127816ULL, 0x000fe20000000042ULL, 0x0004000014417984ULL, 0x000ea20000000800ULL,
0x0000000611367223ULL, 0x000fe20000010036ULL, 0x00007610ff117816ULL, 0x000fc4000000003dULL,
0x0000000612337223ULL, 0x080fe20000010033ULL, 0x00005410ff127816ULL, 0x000fe2000000003fULL,
0x0000000010147984ULL, 0x000fe20000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e003eULL,
0x0000000711347223ULL, 0x080fe20000010034ULL, 0x00007610ff117816ULL, 0x000fe20000000042ULL,
0x0000000712317223ULL, 0x000fe20000010031ULL, 0x00005410ff127816ULL, 0x002fe20000000043ULL,
0x0004000015467984ULL, 0x000e620000000800ULL, 0x000003003d007a0cULL, 0x000fe20003f06070ULL,
0x0000000611327223ULL, 0x080fe20000010032ULL, 0x00007610ff117816ULL, 0x000fe2000000003fULL,
0x00000006122f7223ULL, 0x000fc4000001002fULL, 0x0004000010127984ULL, 0x0006640000000800ULL,
0x0000000711307223ULL, 0x000fe20000010030ULL, 0x00007610ff117816ULL, 0x000fca0000000043ULL,
0x00000006112e7223ULL, 0x000fe2000001002eULL, 0x00005410ff107816ULL, 0x108fe40000000040ULL,
0x00007610ff117816ULL, 0x000fc60000000040ULL, 0x00000007102d7223ULL, 0x080fe2000001002dULL,
0x00005410ff107816ULL, 0x000fe20000000044ULL, 0x00000007112c7223ULL, 0x000fe2000001002cULL,
0x00007610ff117816ULL, 0x000fc60000000044ULL, 0x00000006102b7223ULL, 0x080fe2000001002bULL,
0x00005410ff107816ULL, 0x100fe20000000017ULL, 0x00000006112a7223ULL, 0x000fe2000001002aULL,
0x00007610ff117816ULL, 0x000fc60000000017ULL, 0x0000000710297223ULL, 0x080fe20000010029ULL,
0x00005410ff107816ULL, 0x100fe20000000045ULL, 0x0000000711287223ULL, 0x000fe20000010028ULL,
0x00007610ff117816ULL, 0x000fc60000000045ULL, 0x0000000610277223ULL, 0x080fe20000010027ULL,
0x00005410ff107816ULL, 0x100fe20000000013ULL, 0x0000000611267223ULL, 0x000fe20000010026ULL,
0x00007610ff117816ULL, 0x000fc60000000013ULL, 0x0000000710257223ULL, 0x080fe20000010025ULL,
0x00005410ff107816ULL, 0x104fe20000000041ULL, 0x0000000711247223ULL, 0x000fe20000010024ULL,
0x00007610ff117816ULL, 0x000fc60000000041ULL, 0x0000000610237223ULL, 0x080fe20000010023ULL,
0x00005410ff107816ULL, 0x000fe20000000016ULL, 0x0000000611227223ULL, 0x000fe20000010022ULL,
0x00007610ff117816ULL, 0x000fc60000000016ULL, 0x0000000710217223ULL, 0x080fe20000010021ULL,
0x00005410ff107816ULL, 0x002fe20000000046ULL, 0x0000000711207223ULL, 0x000fe20000010020ULL,
0x00007610ff117816ULL, 0x000fc60000000046ULL, 0x00000006101f7223ULL, 0x080fe2000001001fULL,
0x00005410ff107816ULL, 0x000fe20000000014ULL, 0x00000006111e7223ULL, 0x000fe2000001001eULL,
0x00007610ff117816ULL, 0x000fc60000000014ULL, 0x00000007103b7223ULL, 0x080fe2000001003bULL,
0x00005410ff107816ULL, 0x000fe20000000012ULL, 0x00000007113a7223ULL, 0x000fe2000001003aULL,
0x00007610ff077816ULL, 0x000fc60000000012ULL, 0x00000006101d7223ULL, 0x080fe4000001001dULL,
0x00000006071c7223ULL, 0x000fe2000001001cULL, 0xfffff3b000008947ULL, 0x000fea000383ffffULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x000000800a038824ULL, 0x000fca00078e0205ULL, 0x0000000304038210ULL, 0x000fe20007ffe0ffULL,
0x0000000105047824ULL, 0x000fc800078e0204ULL, 0x0049803c03008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800004007984ULL, 0x000e680000000800ULL,
0x004a000004057984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000027810ULL, 0x000fc80007ffe0ffULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0000ULL, 0x0000b3d000047802ULL, 0x000fc40000000f00ULL,
0x0000906000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000037308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000003ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000ea20000000000ULL, 0x0000000b0b0b723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000080d077811ULL, 0x006fe200078ff0ffULL,
0x000000016e6e7824ULL, 0x100fe200078e020dULL, 0x00000002ff057819ULL, 0x000fc6000001160dULL,
0x00001f0702037589ULL, 0x000e6200000e0000ULL, 0x0000000305047810ULL, 0x040fe20007ffe0ffULL,
0x00000008050f7824ULL, 0x040fe200078e00ffULL, 0x0000000405067810ULL, 0x040fe20007ffe0ffULL,
0x00001f0502007589ULL, 0x0004e200000e0000ULL, 0x0000000805177824ULL, 0x040fe400078e00ffULL,
0x00000008050c7824ULL, 0x040fe400078e00ffULL, 0x0000000805137824ULL, 0x040fe400078e00ffULL,
0x0000000805157824ULL, 0x000fc400078e00ffULL, 0x0000000805197824ULL, 0x040fe200078e00ffULL,
0x0000000105027810ULL, 0x044fe20007ffe0ffULL, 0x00000008051b7824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee204ULL, 0x000000106e6e7824ULL, 0x000fe200078e0209ULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee202ULL, 0x0000000505027810ULL, 0x000fe20007ffe0ffULL,
0x0000001013137824ULL, 0x100fe200078e0208ULL, 0x0000000605047810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0208ULL, 0x0000003703377220ULL, 0x042fe20000410000ULL,
0x0000003603367220ULL, 0x040fe20000410000ULL, 0x0000003303337220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000002f032f7220ULL, 0x040fe20000410000ULL,
0x0000002e032e7220ULL, 0x040fe20000410000ULL, 0x0000002b032b7220ULL, 0x040fe20000410000ULL,
0x0000002a032a7220ULL, 0x040fe20000410000ULL, 0x0000002703277220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002303237220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x000fe20000410000ULL, 0x0000000205037810ULL, 0x000fe20007ffe0ffULL,
0x0000003900397220ULL, 0x008fe20000410000ULL, 0xfffffff817177812ULL, 0x000fe200078ee202ULL,
0x000000040d027824ULL, 0x000fe200078e00ffULL, 0xfffffff80c117812ULL, 0x000fe200078ee203ULL,
0x0000003800387220ULL, 0x000fe20000410000ULL, 0xfffffff80c037812ULL, 0x000fe200078ee205ULL,
0x00000008070c7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee206ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0xffffffff05067810ULL, 0x000fe20007ffe0ffULL,
0x0000003400347220ULL, 0x000fe20000410000ULL, 0x0000000c02027812ULL, 0x000fe200078ec0ffULL,
0x0000001003037824ULL, 0x000fe200078e0208ULL, 0xfffffff819197812ULL, 0x000fe200078ee204ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x0000001011117824ULL, 0x100fe200078e0208ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x000fe20000410000ULL,
0xfffffff80c077812ULL, 0x000fe200078ee207ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x000fe20000410000ULL, 0x000000393838723eULL, 0x000fe200000010ffULL,
0x0000001015057824ULL, 0x000fe200078e0208ULL, 0x0000003b003b7220ULL, 0x000fe20000410000ULL,
0x0000000103037824ULL, 0x000fe200078e0202ULL, 0x000000353434723eULL, 0x000fe200000010ffULL,
0x0000001017177824ULL, 0x100fe200078e0208ULL, 0x0000003a00007220ULL, 0x000fe20000410000ULL,
0x0000001019197824ULL, 0x100fe200078e0208ULL, 0x000000313030723eULL, 0x000fe200000010ffULL,
0x00000001020f7824ULL, 0x000fe200078e020fULL, 0x0000001d1c1c723eULL, 0x000fe200000010ffULL,
0x0000000102157824ULL, 0x000fe200078e0211ULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0208ULL, 0x0000001f1e1e723eULL, 0x000fe200000010ffULL,
0x00000001021d7824ULL, 0x000fe200078e0213ULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000001007077824ULL, 0x000fe200078e0208ULL, 0x000000212020723eULL, 0x000fe200000010ffULL,
0x00000001021f7824ULL, 0x000fe200078e0205ULL, 0x000000252424723eULL, 0x000fe200000010ffULL,
0x0000000102217824ULL, 0x000fe200078e0217ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000003803007388ULL, 0x000fe20000000800ULL, 0x0000001902237210ULL, 0x040fe20007ffe0ffULL,
0x0000000102257824ULL, 0x000fe200078e021bULL, 0x0000003b0000723eULL, 0x000fe200000010ffULL,
0x000000340f007388ULL, 0x000fe20000000800ULL, 0x000000373636723eULL, 0x000fe200000010ffULL,
0x0000000102077824ULL, 0x000fe200078e0207ULL, 0x000000333232723eULL, 0x000fe200000010ffULL,
0x0000003015007388ULL, 0x000fe20000000800ULL, 0x0000002f2e2e723eULL, 0x000fc400000010ffULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x0000002c1d007388ULL, 0x000fe20000000800ULL,
0x000000272626723eULL, 0x000fc600000010ffULL, 0x000000281f007388ULL, 0x000fe80000000800ULL,
0x0000002421007388ULL, 0x000fe80000000800ULL, 0x0000002023007388ULL, 0x000fe80000000800ULL,
0x0000000025007388ULL, 0x000fe80000000800ULL, 0x0000003607007388ULL, 0x000fe80000000800ULL,
0x000400320f007388ULL, 0x000fe80000000800ULL, 0x0004002e15007388ULL, 0x000fe80000000800ULL,
0x0004002a1d007388ULL, 0x000fe80000000800ULL, 0x000400261f007388ULL, 0x000fe80000000800ULL,
0x0004002221007388ULL, 0x000fe80000000800ULL, 0x0004001e23007388ULL, 0x000fe80000000800ULL,
0x0004001c25007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000006e047984ULL, 0x000e680000000c00ULL, 0x000400006e147984ULL, 0x000ea80000000c00ULL,
0x000800006e107984ULL, 0x000ee80000000c00ULL, 0x000c00006e187984ULL, 0x000ee20000000c00ULL,
0x3f803f800b077831ULL, 0x002fc40000200007ULL, 0x3f803f800b067831ULL, 0x040fe40000200006ULL,
0x3f803f800b057831ULL, 0x040fe40000200005ULL, 0x3f803f800b047831ULL, 0x040fe40000200004ULL,
0x3f803f800b177831ULL, 0x044fe40000200017ULL, 0x3f803f800b167831ULL, 0x040fe40000200016ULL,
0x3f803f800b157831ULL, 0x000fc40000200015ULL, 0x3f803f800b147831ULL, 0x000fe40000200014ULL,
0x3f803f8007077831ULL, 0x008fe40000200013ULL, 0x3f803f8006067831ULL, 0x000fe40000200012ULL,
0x3f803f8005057831ULL, 0x000fe40000200011ULL, 0x3f803f8004047831ULL, 0x000fe40000200010ULL,
0x3f803f8017177831ULL, 0x000fc4000020001bULL, 0x3f803f8016167831ULL, 0x000fe2000020001aULL,
0x000000046e007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fe40000200019ULL,
0x3f803f8014147831ULL, 0x000fca0000200018ULL, 0x000400146e007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fc8000001160dULL,
0x000000720400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000057b06ULL, 0x000e620000209000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0c7a12ULL, 0x000fe200078e33ffULL, 0x0000000173007824ULL, 0x000fe200078e0204ULL,
0x000000200d117810ULL, 0x040fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e020dULL,
0x000000070d087812ULL, 0x000fc800078ec0ffULL, 0x0000000704047812ULL, 0x000fc800078ec0ffULL,
0x0ffffff804047812ULL, 0x000fe200078ef80dULL, 0x0000000500057308ULL, 0x002e680000001000ULL,
0x0000001004047824ULL, 0x000fe200078e0209ULL, 0x0ffffffe05067810ULL, 0x002fc80007ffe0ffULL,
0x0000000600037305ULL, 0x000e64000021f000ULL, 0x000000ffff077224ULL, 0x002fc800078e0a03ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x00000007030f7227ULL, 0x000fe400078e0002ULL,
0x0000000004047984ULL, 0x000e680000000c00ULL, 0x000000000f027227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a02ULL, 0x00005a0003037a24ULL, 0x000fca00078e0200ULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102020810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000102021810ULL, 0x000fc80007ffe0ffULL,
0x000000020c037207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0270ULL, 0x00005a000b007a24ULL, 0x000fe400078e0200ULL,
0x000000086b0b7824ULL, 0x000fe400078e0208ULL, 0x00005a0003037a24ULL, 0x000fca00078e0200ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4400ULL,
0x00000003ff007819ULL, 0x000fc60000011611ULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x000000720000720cULL, 0x000fc80003f26070ULL, 0x0000000402007986ULL, 0x0023f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000173027824ULL, 0x102fe200078e0200ULL,
0x000000400d137810ULL, 0x000fe20007ffe0ffULL, 0x0000000111007824ULL, 0x040fe200078e0200ULL,
0x0000000711087812ULL, 0x000fe200078ec0ffULL, 0x000000020f037227ULL, 0x000fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a03ULL,
0x0ffffff800007812ULL, 0x000fe200078ef811ULL, 0x00005a0005047a24ULL, 0x000fc800078e0202ULL,
0x0000001000007824ULL, 0x000fe200078e0209ULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0000000000047984ULL, 0x0002a40000000c00ULL,
0x00000003ff007819ULL, 0x002fd20000011613ULL, 0x0000000103032810ULL, 0x000fc80007ffe0ffULL,
0x000000030c037207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0270ULL, 0x00005a000b027a24ULL, 0x000fe400078e0202ULL,
0x000000086b0b7824ULL, 0x000fe400078e0208ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440aULL,
0x000000720000720cULL, 0x000fc60003f26070ULL, 0x000000100b027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000173027824ULL, 0x102fe200078e0200ULL, 0x000000600d0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000113007824ULL, 0x040fe200078e0200ULL, 0x0000000713087812ULL, 0x000fe200078ec0ffULL,
0x000000020f037227ULL, 0x000fc600078e00ffULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc600078e0a03ULL, 0x0ffffff800007812ULL, 0x000fe200078ef813ULL,
0x00005a0005047a24ULL, 0x000fc800078e0202ULL, 0x0000001000007824ULL, 0x000fe200078e0209ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0000000000047984ULL, 0x0002a40000000c00ULL, 0x00000003ff007819ULL, 0x002fd2000001160dULL,
0x0000000103032810ULL, 0x000fe40007ffe0ffULL, 0x0000000073737210ULL, 0x000fe40007ffe0ffULL,
0x000000030c037207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a03ULL,
0x0000590003037a24ULL, 0x000fe400078e0270ULL, 0x00005a000b027a24ULL, 0x000fe400078e0202ULL,
0x000000086b0b7824ULL, 0x000fe400078e0208ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440aULL,
0x000000720000720cULL, 0x000fc60003f26070ULL, 0x000000100b027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000730f027227ULL, 0x002fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fe400078e0a02ULL,
0x000000010d007824ULL, 0x000fe400078e0200ULL, 0x00005a0004037a24ULL, 0x000fc600078e0273ULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f26070ULL,
0xfffffff800007812ULL, 0x000fca00078ef80dULL, 0x0000001000097824ULL, 0x000fcc00078e0209ULL,
0x80005a0003031a10ULL, 0x000fe20007ffe0ffULL, 0x0000000009087984ULL, 0x000e620000000c00ULL,
0x0000000102021810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f46070ULL,
0x0000000102022810ULL, 0x000fc80007ffe0ffULL, 0x000000020c037207ULL, 0x000fca0004000000ULL,
0x000000ffff007224ULL, 0x000fe400078e0a03ULL, 0x0000590003707a24ULL, 0x000fe400078e0270ULL,
0x00005a0000737a24ULL, 0x000fe200078e0273ULL, 0x000000070d007812ULL, 0x000fc600078ec0ffULL,
0x00005a0070737a24ULL, 0x000fe400078e0273ULL, 0x000000086b6b7824ULL, 0x000fc600078e0200ULL,
0x0000007374737210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005e0073027a11ULL, 0x000fc800078040ffULL, 0x00005f0073037a11ULL, 0x000fca00000f4404ULL,
0x000000106b027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff617819ULL, 0x000fca0000011600ULL,
0x0000000202617824ULL, 0x000fca00078e0261ULL, 0x000000716100720cULL, 0x000fda0003f06070ULL,
0x0000000279068824ULL, 0x000fc800078e00ffULL, 0x00006a00060b8a24ULL, 0x000fe400078e0261ULL,
0xffffffffff067424ULL, 0x000fe400078e00ffULL, 0x000066000b0a8625ULL, 0x002fe200078e004cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a068981ULL, 0x000ea2000c1e1900ULL,
0x00000001020c7810ULL, 0x000fe20007ffe0ffULL, 0x0000004000777824ULL, 0x000fe400078e00ffULL,
0x0000008076767824ULL, 0x000fe200078e00ffULL, 0x000000670c00720cULL, 0x000fe20003f06070ULL,
0x00005800ff0c7624ULL, 0x000fe200078e00ffULL, 0x01360000ff087f8cULL, 0x000e62000c80043fULL,
0x00000080706f7824ULL, 0x000fc400078e00ffULL, 0x0000010002167824ULL, 0x000fe200078e0277ULL,
0x0000001f0c707810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff0d7424ULL, 0x000fc600078e00ffULL,
0x00000005ff707819ULL, 0x000fe40000011670ULL, 0x000000406f267812ULL, 0x000fe200078ef816ULL,
0x00000076060a7224ULL, 0x004fc800078e02ffULL, 0x000064000a0a7625ULL, 0x000fe200078e000dULL,
0x0000060000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x002fe40000011603ULL,
0x00000003031a7211ULL, 0x000fe400078fe8ffULL, 0x00000010241f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001260c7824ULL, 0x000fe200078e0224ULL, 0x0000000824187810ULL, 0x040fe40007ffe0ffULL,
0x0000001824217810ULL, 0x000fe20007ffe0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x00000020241e7810ULL, 0x000fc40007ffe0ffULL, 0x000000031a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000126107824ULL, 0x000fe200078e021fULL, 0x000000300c157812ULL, 0x000fe200078ef807ULL,
0x00000001260e7824ULL, 0x040fe200078e0218ULL, 0x00000016630c7217ULL, 0x000fe20007800000ULL,
0x0000000126127824ULL, 0x000fe200078e0221ULL, 0x000000150a147210ULL, 0x000fe20007f1e0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000002824207810ULL, 0x000fe40007ffe0ffULL,
0x00001000001c7811ULL, 0x000fe200078e68ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000003010177812ULL, 0x000fc400078ef807ULL, 0x0ffffffc1a037812ULL, 0x000fe200078ef803ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000300e1b7812ULL, 0x000fe400078ef807ULL,
0x0000003024227810ULL, 0x000fe20007ffe0ffULL, 0x000000010c197824ULL, 0x000fe200078e0a16ULL,
0x000000170a0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010b157824ULL, 0x040fe200000e060dULL,
0x00000030120d7812ULL, 0x000fe200078ef807ULL, 0x0000000126107824ULL, 0x000fe200078e021eULL,
0x0000001b0a167210ULL, 0x000fe20007f1e0ffULL, 0x00000004181b7824ULL, 0x000fe200078e00ffULL,
0x0000000d0a0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b0d7824ULL, 0x000fe200008e0611ULL,
0x0000002026127210ULL, 0x000fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000191800720cULL, 0x000fc40003f26070ULL, 0x000000191f00720cULL, 0x080fe20003fa6070ULL,
0x000000010b177824ULL, 0x040fe200000e060fULL, 0x000000192400720cULL, 0x000fe20003f06070ULL,
0x000000010b0f7824ULL, 0x000fe200010e0613ULL, 0x0000003010137812ULL, 0x000fe200078ef807ULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0x0000003824247810ULL, 0x000fe40007ffe0ffULL,
0x000000130a107210ULL, 0x000fe40007f5e0ffULL, 0xfffffffc1b137812ULL, 0x000fe200078ee21aULL,
0x0000000424237824ULL, 0x000fe200078e00ffULL, 0x000000192100720cULL, 0x080fe20003f86070ULL,
0x000000010b117824ULL, 0x000fe200010e0611ULL, 0x000000191e00720cULL, 0x080fe20003f66070ULL,
0x00000010131b7824ULL, 0x000fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014037faeULL, 0x0003e2000c101c46ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000192000720cULL, 0x000fc40003f46070ULL, 0x00000000161b7faeULL, 0x0005e2000c901c46ULL,
0x000000192200720cULL, 0x080fe40003f26070ULL, 0x00000030121d7812ULL, 0x000fe200078ef807ULL,
0x0000000126127824ULL, 0x000fe200078e0222ULL, 0x000000192400720cULL, 0x000fe40003f06070ULL,
0x0000001d0a187210ULL, 0x000fe20007fde0ffULL, 0x0000000126147824ULL, 0x002fe400078e0224ULL,
0x000000041f037824ULL, 0x000fc400078e00ffULL, 0x000000010b197824ULL, 0x000fe400030e0613ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x000fc600078ee21aULL,
0x0000000421177824ULL, 0x004fe200078e00ffULL, 0x00000030121d7812ULL, 0x000fe200078ef807ULL,
0x0000010014147825ULL, 0x000fc600078e00ffULL, 0x0000001d0a127210ULL, 0x000fe20007fde0ffULL,
0x000000041e1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x100fe200078ee21aULL,
0x00000004201f7824ULL, 0x000fe200078e00ffULL, 0x0000003014077812ULL, 0x000fe200078ef807ULL,
0x0000000422217824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b1b7812ULL, 0x100fe200078ee21aULL,
0x000000010b137824ULL, 0x000fe200030e0613ULL, 0xfffffffc1f1d7812ULL, 0x000fe200078ee21aULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0xfffffffc211f7812ULL, 0x000fe200078ee21aULL,
0x0000001017177824ULL, 0x000fe200078e021cULL, 0xfffffffc23217812ULL, 0x000fe200078ee21aULL,
0x000000101b1b7824ULL, 0x100fe200078e021cULL, 0x000000070a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021cULL, 0x000000000c037faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x000fc400078e021cULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0x000000000e177faeULL, 0x0003e2000e101c46ULL, 0x000000010b0b7824ULL, 0x000fc600030e0615ULL,
0x00000000101b7faeULL, 0x0003e8000d901c46ULL, 0x00000000181d7faeULL, 0x0003e8000d101c46ULL,
0x00000000121f7faeULL, 0x0003e8000c901c46ULL, 0x000000000a217faeULL, 0x0003e2000c101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000003030e7211ULL, 0x042fe400078fe8ffULL,
0x0000000803177811ULL, 0x000fc400078ff0ffULL, 0x00000018030f7811ULL, 0x040fe400078ff0ffULL,
0x00000010030d7811ULL, 0x040fe400078ff0ffULL, 0x0000002003117811ULL, 0x040fe200078ff0ffULL,
0x0000000126127824ULL, 0x040fe200078e020fULL, 0x0000003003147811ULL, 0x000fe200078ff0ffULL,
0x000000040d197824ULL, 0x000fe200078e00ffULL, 0x00000026030c7211ULL, 0x000fe200078ff0ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0x0000002803137811ULL, 0x040fe200078ff0ffULL,
0x00000001261c7824ULL, 0x000fe200078e0211ULL, 0x000000030e1a7812ULL, 0x000fe200078ec0ffULL,
0x00000001260e7824ULL, 0x040fe200078e0217ULL, 0x0000003803157811ULL, 0x000fe200078ff0ffULL,
0x0000000417177824ULL, 0x000fe200078e00ffULL, 0x00000013261e7210ULL, 0x040fe20007ffe0ffULL,
0x0000000126107824ULL, 0x000fe200078e020dULL, 0x0ffffffc1a1d7812ULL, 0x000fe200078ef803ULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc17037812ULL, 0x100fe200078ee21aULL,
0x00000004141b7824ULL, 0x000fe200078e00ffULL, 0x0000100000247811ULL, 0x000fe200078e68ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc11177812ULL, 0x000fc600078ee21aULL,
0x0000000413137824ULL, 0x000fe400078e00ffULL, 0x0000000126207824ULL, 0x040fe200078e0214ULL,
0xfffffffc19147812ULL, 0x100fe200078ee21aULL, 0x0000000126227824ULL, 0x000fe200078e0215ULL,
0xfffffffc1b197812ULL, 0x100fe200078ee21aULL, 0x00000004151f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0f157812ULL, 0x100fe200078ee21aULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c1b7812ULL, 0x000fe400078ef807ULL, 0xfffffffc13187812ULL, 0x100fe200078ee21aULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffffc1f1a7812ULL, 0x000fc400078ee21aULL,
0x0000001b0a167210ULL, 0x000fe20007f1e0ffULL, 0x00000010151f7824ULL, 0x000fe200078e0224ULL,
0x000000300e157812ULL, 0x100fe200078ef807ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000030101b7812ULL, 0x000fc600078ef807ULL, 0x0000001018237824ULL, 0x100fe200078e0224ULL,
0x000000150a187210ULL, 0x000fe20007f3e0ffULL, 0x000000101a277824ULL, 0x100fe200078e0224ULL,
0x0000001b0a1a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001017217824ULL, 0x100fe200078e0224ULL,
0x0000003012157812ULL, 0x000fe200078ef807ULL, 0x0000001019257824ULL, 0x000fe400078e0224ULL,
0x000000010b177824ULL, 0x040fe200000e060dULL, 0x000000150a127210ULL, 0x000fe20007f1e0ffULL,
0x000000010b197824ULL, 0x000fc400008e060fULL, 0x000001001c0c7825ULL, 0x000fc800078e00ffULL,
0x000000101d2f7824ULL, 0x100fe200078e0224ULL, 0x000000300c2d7812ULL, 0x000fe200078ef807ULL,
0x000000010b1b7824ULL, 0x000fe400010e0611ULL, 0x000001001e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000162f7faeULL, 0x0003e6000b901c46ULL,
0x00000010141d7824ULL, 0x000fe200078e0224ULL, 0x000000300e2b7812ULL, 0x000fe200078ef807ULL,
0x0000010020107825ULL, 0x000fc600078e00ffULL, 0x0000002b0a0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000010022147825ULL, 0x000fe200078e00ffULL, 0x0000003010297812ULL, 0x000fc600078ef807ULL,
0x000000010b137824ULL, 0x000fe200000e0613ULL, 0x0000003014077812ULL, 0x000fe200078ef807ULL,
0x0000001003037824ULL, 0x000fe200078e0224ULL, 0x0000002d0a0c7210ULL, 0x040fe20007f1e0ffULL,
0x000000010b0f7824ULL, 0x040fe200008e060fULL, 0x000000290a107210ULL, 0x040fe40007f5e0ffULL,
0x000000070a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b0d7824ULL, 0x040fe200000e060dULL,
0x0000000018037faeULL, 0x0003e2000b901c46ULL, 0x000000010b117824ULL, 0x000fc400010e0611ULL,
0x000000010b0b7824ULL, 0x000fe200018e0615ULL, 0x000000001a1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000121f7faeULL, 0x0003e8000b901c46ULL, 0x000000000c217faeULL, 0x0003e8000b901c46ULL,
0x000000000e237faeULL, 0x0003e8000b901c46ULL, 0x0000000010257faeULL, 0x0003e8000b901c46ULL,
0x000000000a277faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000a7805ULL, 0x002fc40000015200ULL, 0x01360400ff037984ULL, 0x000e620000000800ULL,
0x00000070054d7224ULL, 0x000fc400078e02ffULL, 0x0000000163727824ULL, 0x000fe400078e0a04ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x8000000003ff7812ULL, 0x002fe20007804809ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000062004d4c7625ULL, 0x000fe200078e004cULL, 0x00000008ff727819ULL, 0x000fe20000011672ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140dULL, 0x0000000c03037211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e060dULL, 0x0000000203037819ULL, 0x000fc8000000120cULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000670200720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000006e7919ULL, 0x000e620000000000ULL,
0x00006a0079797a24ULL, 0x000fe200078e02ffULL, 0x0001368800747811ULL, 0x000fe200078e18ffULL,
0x0000000270707824ULL, 0x000fe200078e00ffULL, 0xffffffff044f7810ULL, 0x000fe20007ffe0ffULL,
0x0000002000757824ULL, 0x000fe200078e00ffULL, 0x0000000904607810ULL, 0x000fc40007ffe0ffULL,
0x0000000102087810ULL, 0x004fe20007ffe0ffULL, 0x0000000676137224ULL, 0x000fe200078e02ffULL,
0x00000077024e7211ULL, 0x000fe200078e40ffULL, 0x00000100ff787424ULL, 0x000fe200078e00ffULL,
0x000000670800720cULL, 0x000fe20003f06070ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000404e067812ULL, 0x000fe200078ec0ffULL, 0x0000640013127625ULL, 0x000fc800078e0078ULL,
0x000000016f117824ULL, 0x000fcc00078e0206ULL, 0x0000064000008947ULL, 0x008fea0003800000ULL,
0x00000002ff1a7819ULL, 0x002fe2000001166eULL, 0x000000106e107824ULL, 0x000fc600078e00ffULL,
0x000000081a1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000011a067824ULL, 0x100fe200078e0211ULL,
0x0000003010107812ULL, 0x000fe400078ec0ffULL, 0x000000201a247810ULL, 0x000fe20007ffe0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000004010057812ULL, 0x000fe400078efcffULL,
0x000000181a227810ULL, 0x000fe20007ffe0ffULL, 0x000000011e087824ULL, 0x100fe200078e0211ULL,
0x0000000506157212ULL, 0x000fe200078efcffULL, 0x00000001240e7824ULL, 0x000fe200078e0211ULL,
0x000000101a207810ULL, 0x000fe20007ffe0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000001512147210ULL, 0x000fc60007f3e0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000508177212ULL, 0x000fc600078efcffULL, 0x00000001220c7824ULL, 0x100fe200078e0211ULL,
0x000000050e037212ULL, 0x000fe200078efcffULL, 0x00000001200a7824ULL, 0x000fe200078e0211ULL,
0x00002000000e7811ULL, 0x000fe200078e68ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000312087210ULL, 0x040fe40007f7e0ffULL, 0x0000004e63037217ULL, 0x000fe20007800000ULL,
0x0000000113157824ULL, 0x000fe200008e0607ULL, 0x0000001712167210ULL, 0x000fe20007f3e0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000050c077212ULL, 0x000fc400078efcffULL,
0x000000281a0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000113177824ULL, 0x000fe200008e0609ULL,
0x000000050a197212ULL, 0x000fe200078efcffULL, 0x0000000103037824ULL, 0x000fe200078e0a4eULL,
0x0000000712067210ULL, 0x000fe20007f3e0ffULL, 0x0000000113097824ULL, 0x040fe200018e060fULL,
0x0000006e6e0a7211ULL, 0x000fe200078fe8ffULL, 0x000000041e1b7824ULL, 0x000fe200078e00ffULL,
0x0000001912187210ULL, 0x000fe20007f5e0ffULL, 0x0000000113077824ULL, 0x040fe200008e060dULL,
0x0ffffffc6e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000004201d7824ULL, 0x000fe200078e00ffULL,
0x000000030a1c7812ULL, 0x000fe200078ec0ffULL, 0x000000010c0a7824ULL, 0x000fe200078e0211ULL,
0x000000031a00720cULL, 0x000fe20003f26070ULL, 0x0000000113197824ULL, 0x000fe200010e060bULL,
0x0000000f1c0d7212ULL, 0x000fe200078efcffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000031e00720cULL, 0x000fc40003f46070ULL, 0x000000032000720cULL, 0x000fe20003f66070ULL,
0x000000100d0d7824ULL, 0x000fe200078e020eULL, 0xfffffffc1b1b7812ULL, 0x100fe400078ee21cULL,
0xfffffffc1d1d7812ULL, 0x000fe400078ee21cULL, 0x000000050a1f7212ULL, 0x000fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140d7faeULL, 0x0003e2000c901c46ULL,
0x000000301a1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e020eULL,
0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e020eULL,
0x000000032200720cULL, 0x080fe20003fa6070ULL, 0x000000011e0a7824ULL, 0x000fe200078e0211ULL,
0x00000000161b7faeULL, 0x0005e2000d101c46ULL, 0x000000032400720cULL, 0x000fc40003f86070ULL,
0x000000031e00720cULL, 0x000fe20003f46070ULL, 0x00000000181d7faeULL, 0x0007e2000d901c46ULL,
0x0000001f12147210ULL, 0x002fe20007fde0ffULL, 0x000000041e1f7824ULL, 0x000fe200078e00ffULL,
0x000000030c00720cULL, 0x080fe40003f66070ULL, 0x000000031a00720cULL, 0x040fe20003f26070ULL,
0x0000000113157824ULL, 0x000fe200030e060bULL, 0x000000021a217819ULL, 0x000fe200000006ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc1f1f7812ULL, 0x000fc400078ee21cULL,
0xfffffffc21217812ULL, 0x100fe200078ee21cULL, 0x000000040c1d7824ULL, 0x008fe200078e00ffULL,
0x000000050a037212ULL, 0x000fe200078efcffULL, 0x000000011a0c7824ULL, 0x000fe400078e0211ULL,
0x0000000422197824ULL, 0x000fe200078e00ffULL, 0x00000003120a7210ULL, 0x000fe20007fde0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc1d1d7812ULL, 0x100fe400078ee21cULL,
0xfffffffc19197812ULL, 0x000fe200078ee21cULL, 0x00000004241b7824ULL, 0x004fe200078e00ffULL,
0x000000050c177212ULL, 0x000fe200078efcffULL, 0x00000001130b7824ULL, 0x000fc400030e060bULL,
0x0000001019037824ULL, 0x000fe200078e020eULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee21cULL,
0x000000101f197824ULL, 0x100fe200078e020eULL, 0x00000017120c7210ULL, 0x000fe20007fde0ffULL,
0x000000101d177824ULL, 0x100fe200078e020eULL, 0x0000000006037faeULL, 0x0003e2000e901c46ULL,
0x000000101b057824ULL, 0x100fe400078e020eULL, 0x00000010211b7824ULL, 0x000fe400078e020eULL,
0x00000001130d7824ULL, 0x000fe200030e060dULL, 0x0000000008057faeULL, 0x0003e8000e101c46ULL,
0x0000000014177faeULL, 0x0003e8000d901c46ULL, 0x000000000a197faeULL, 0x0003e8000d101c46ULL,
0x000000000c1b7faeULL, 0x0003e2000c901c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x000000186e147811ULL, 0x042fe200078ff0ffULL, 0x000000106e107824ULL, 0x040fe200078e00ffULL,
0x0000006e6e037211ULL, 0x000fc400078fe8ffULL, 0x000000086e0a7811ULL, 0x000fe200078ff0ffULL,
0x0000000414097824ULL, 0x000fe200078e00ffULL, 0x000000206e1c7811ULL, 0x040fe400078ff0ffULL,
0x000000286e1e7811ULL, 0x000fe200078ff0ffULL, 0x000000010a087824ULL, 0x100fe200078e0211ULL,
0x000000106e0c7811ULL, 0x000fe200078ff0ffULL, 0x000000041c0b7824ULL, 0x000fe200078e00ffULL,
0x00000003030e7812ULL, 0x000fe200078ec0ffULL, 0x000000040a037824ULL, 0x000fe200078e00ffULL,
0x0000003010107812ULL, 0x000fe200078ec0ffULL, 0x000000041e0d7824ULL, 0x000fe200078e00ffULL,
0x000000306e227811ULL, 0x000fe200078ff0ffULL, 0x000000010c0a7824ULL, 0x000fe200078e0211ULL,
0x000000116e067211ULL, 0x000fe200078ff0ffULL, 0x000000040c057824ULL, 0x000fe200078e00ffULL,
0xfffffffc09187812ULL, 0x000fe200078ee20eULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000004010277812ULL, 0x000fc400078efcffULL, 0xfffffffc0b1a7812ULL, 0x100fe200078ee20eULL,
0x0000000422157824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d207812ULL, 0x100fe200078ee20eULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x00000027080d7212ULL, 0x080fe400078efcffULL,
0x0000200000257811ULL, 0x000fe200078e68ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc15247812ULL, 0x000fe400078ee20eULL, 0x0000002706157212ULL, 0x080fe200078efcffULL,
0x00000001140c7824ULL, 0x000fe200078e0211ULL, 0x000000270a1b7212ULL, 0x000fe200078efcffULL,
0x000000101a1f7824ULL, 0x000fe200078e0225ULL, 0x0000000d12087210ULL, 0x000fe20007f5e0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000386e267811ULL, 0x000fc400078ff0ffULL,
0xfffffffc03147812ULL, 0x100fe200078ee20eULL, 0x000000011c0a7824ULL, 0x000fe200078e0211ULL,
0xfffffffc05167812ULL, 0x100fe200078ee20eULL, 0x0000000426177824ULL, 0x000fe200078e00ffULL,
0x0000001512067210ULL, 0x000fe20007f3e0ffULL, 0x0000001014037824ULL, 0x100fe200078e0225ULL,
0x0000001b121a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001016057824ULL, 0x000fe200078e0225ULL,
0x000000270c157212ULL, 0x000fe200078efcffULL, 0x000000011e147824ULL, 0x000fe200078e0211ULL,
0x0ffffffc6e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000010181d7824ULL, 0x000fe200078e0225ULL,
0xfffffffc17287812ULL, 0x000fe200078ee20eULL, 0x0000000122167824ULL, 0x000fe200078e0211ULL,
0x0000000f0e0e7212ULL, 0x000fe200078efcffULL, 0x0000000113077824ULL, 0x040fe200008e0607ULL,
0x00000015120c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001131b7824ULL, 0x040fe200018e060bULL,
0x0000000913097210ULL, 0x000fe200017fe4ffULL, 0x0000000126187824ULL, 0x000fc400078e0211ULL,
0x000001000a0a7825ULL, 0x000fc800078e00ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000000270a2d7212ULL, 0x000fc600078efcffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x00000027142b7212ULL, 0x000fc600078efcffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000002716297212ULL, 0x000fe400078efcffULL, 0x0000002b12147210ULL, 0x000fe20007f5e0ffULL,
0x00000001130d7824ULL, 0x040fe200008e060dULL, 0x0000002718277212ULL, 0x000fe200078efcffULL,
0x000000100e2f7824ULL, 0x100fe200078e0225ULL, 0x0000002d120a7210ULL, 0x000fe20007f3e0ffULL,
0x0000001020217824ULL, 0x000fe200078e0225ULL, 0x0000002912167210ULL, 0x040fe20007f7e0ffULL,
0x0000000113157824ULL, 0x040fe200010e0615ULL, 0x0000002712187210ULL, 0x000fe20007f9e0ffULL,
0x00000001130b7824ULL, 0x000fe200008e060bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000062f7faeULL, 0x0003e2000b901c46ULL, 0x0000001024237824ULL, 0x000fc400078e0225ULL,
0x0000000113177824ULL, 0x040fe200018e0617ULL, 0x0000000008037faeULL, 0x0003e2000b901c46ULL,
0x0000001028257824ULL, 0x000fe400078e0225ULL, 0x0000000113197824ULL, 0x000fe200020e0619ULL,
0x000000001a057faeULL, 0x0003e8000b901c46ULL, 0x000000000c1d7faeULL, 0x0003e8000b901c46ULL,
0x000000000a1f7faeULL, 0x0003e8000b901c46ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e8000b901c46ULL, 0x0000000018257faeULL, 0x0003e4000b901c46ULL,
0x00000004ff0d7819ULL, 0x102fe2000001166eULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000076e037812ULL, 0x000fe200078ec0ffULL, 0x00002000000e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff507819ULL, 0x100fe2000001166eULL, 0x000000080d067824ULL, 0x000fe200078e00ffULL,
0x0000000803627812ULL, 0x000fc400078ef86eULL, 0x0000000150057812ULL, 0x000fe400078ec0ffULL,
0xfffffff806067812ULL, 0x000fe200078ee203ULL, 0x000000010d0d7824ULL, 0x000fe200078e0262ULL,
0x000010000e0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001062087824ULL, 0x000fe200078e00ffULL,
0x00000010061c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000406247824ULL, 0x040fe200078e00ffULL,
0x0000000506077211ULL, 0x080fe200078ff8ffULL, 0x0000001062227824ULL, 0x000fe200078e00ffULL,
0xfffffff008037812ULL, 0x000fe200078ee20dULL, 0x0000000406087824ULL, 0x040fe200078e00ffULL,
0x00000020061e7810ULL, 0x000fe20007ffe0ffULL, 0x000000041c097824ULL, 0x000fe200078e00ffULL,
0x0000003006207810ULL, 0x000fe20007ffe0ffULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0xfffffffc080b7812ULL, 0x000fe200078ee207ULL, 0x000000041e087824ULL, 0x000fe200078e00ffULL,
0x000000051c067211ULL, 0x080fe200078ff8ffULL, 0x0000000420147824ULL, 0x000fe200078e00ffULL,
0x000000051e1d7211ULL, 0x080fe200078ff8ffULL, 0x000000100b5c7824ULL, 0x000fe200078e020cULL,
0x0000000520057211ULL, 0x000fe200078ff8ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffffc090a7812ULL, 0x000fe200078ee206ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0xfffffffc08097812ULL, 0x000fe200078ee21dULL, 0x000000005c34783bULL, 0x000fe20000000200ULL,
0xfffffffc14087812ULL, 0x000fe200078ee205ULL, 0x000000100a5d7824ULL, 0x100fe200078e020cULL,
0x000000020d1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001009647824ULL, 0x100fe200078e020cULL,
0x000000000314783bULL, 0x0002a20000000200ULL, 0x0000001008657824ULL, 0x000fe200078e020cULL,
0x0000000207077810ULL, 0x000fe20007ffe0ffULL, 0x000000041c217824ULL, 0x000fe200078e00ffULL,
0x000000005d3c783bULL, 0x000ee20000000200ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0000000206067810ULL, 0x000fc40007ffe0ffULL, 0x000000006444783bULL, 0x000f220000000200ULL,
0x000000021d1d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000220207819ULL, 0x000fe200000006ffULL,
0x000000006518783bULL, 0x000f220000000200ULL, 0x0000000205037810ULL, 0x002fe40007ffe0ffULL,
0xfffffff0221f7812ULL, 0x000fe400078ee21fULL, 0xfffffffc24077812ULL, 0x000fe400078ee207ULL,
0xfffffffc21067812ULL, 0x000fe200078ee206ULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e057812ULL, 0x000fe200078ee21dULL, 0x0000001007667824ULL, 0x100fe200078e020cULL,
0xfffffffc20037812ULL, 0x000fe200078ee203ULL, 0x00000010066a7824ULL, 0x000fc400078e020cULL,
0x00000010056c7824ULL, 0x100fe200078e020cULL, 0x000000001f1c783bULL, 0x000fe20000000200ULL,
0x00000010036d7824ULL, 0x000fc600078e020cULL, 0x000000006620783bULL, 0x000e680000000200ULL,
0x000000006a24783bULL, 0x000e680000000200ULL, 0x000000006c28783bULL, 0x000e620000000200ULL,
0x000000341430723cULL, 0x044f6600000418ffULL, 0x000000006d2c783bULL, 0x000eaa0000000200ULL,
0x0000003c1438723cULL, 0x048ff000000418ffULL, 0x000000441440723cULL, 0x050ff000000418ffULL,
0x000000361434723cULL, 0x040f7000000418ffULL, 0x0000003e143c723cULL, 0x040f7000000418ffULL,
0x000000461444723cULL, 0x040f7000000418ffULL, 0x000000181448723cULL, 0x040f7000000418ffULL,
0x0000001a1414723cULL, 0x000f7000000418ffULL, 0x000000201c30723cULL, 0x062b700000041830ULL,
0x000000221c34723cULL, 0x040b700000041834ULL, 0x000000241c38723cULL, 0x040b700000041838ULL,
0x000000261c3c723cULL, 0x040b70000004183cULL, 0x000000281c40723cULL, 0x040b700000041840ULL,
0x0000002a1c44723cULL, 0x040b700000041844ULL, 0x0000002c1c48723cULL, 0x044b700000041848ULL,
0x0000002e1c1c723cULL, 0x000b620000041814ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2e7819ULL, 0x120fe2000001166eULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000004e63157217ULL, 0x000fe20007800000ULL, 0x0000000150507824ULL, 0x000fe200078e026eULL,
0x000000102e517810ULL, 0x040fe20007ffe0ffULL, 0x000000012e177824ULL, 0x140fe200078e0211ULL,
0x000000082e527810ULL, 0x000fe20007ffe0ffULL, 0x00000001152a7824ULL, 0x000fe200078e0a4eULL,
0x0000008010227812ULL, 0x000fe200078efcffULL, 0x0000000151217824ULL, 0x100fe200078e0211ULL,
0x000000282e2c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001521b7824ULL, 0x000fe200078e0211ULL,
0x000000202e2b7810ULL, 0x040fe20007ffe0ffULL, 0x0000010021207825ULL, 0x000fe200078e0022ULL,
0x000000182e2f7810ULL, 0x000fc40007ffe0ffULL, 0x000000302e2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012c157824ULL, 0x000fe200078e0211ULL, 0x0000002a2e00720cULL, 0x000fe20003f26070ULL,
0x000001001b1a7825ULL, 0x000fe200078e0022ULL, 0x0000002012207210ULL, 0x000fe40007f9e0ffULL,
0x000000382e2e7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b277824ULL, 0x000fe200078e0211ULL,
0x0000001a121a7210ULL, 0x000fe20007f7e0ffULL, 0x0000010017167825ULL, 0x000fe200078e0022ULL,
0x0000002a2d00720cULL, 0x000fc40003fa6070ULL, 0x0000002a2e00720cULL, 0x000fe20003fc6070ULL,
0x0000010015147825ULL, 0x000fe200078e0022ULL, 0x0000001612167210ULL, 0x000fc60007f5e0ffULL,
0x000000012f257824ULL, 0x000fe400078e0211ULL, 0x0000010027267825ULL, 0x000fc800078e0022ULL,
0x000000012d197824ULL, 0x000fe400078e0211ULL, 0x0000000113217824ULL, 0x000fe200020e0621ULL,
0x0000001412287210ULL, 0x000fe20007f9e0ffULL, 0x000000012e297824ULL, 0x000fe200078e0211ULL,
0x0000000350147812ULL, 0x000fe200078ec0ffULL, 0x0000010025247825ULL, 0x000fc600078e0022ULL,
0x0000000f140f7212ULL, 0x000fe200078efcffULL, 0x00000001131b7824ULL, 0x000fe200018e061bULL,
0x0000002612267210ULL, 0x000fe20007f7e0ffULL, 0x0000010019187825ULL, 0x000fc800078e0022ULL,
0x0000010029227825ULL, 0x000fc800078e0022ULL, 0x0000000113177824ULL, 0x040fe200010e0617ULL,
0x0000002412247210ULL, 0x000fe20007f5e0ffULL, 0x0000000113297824ULL, 0x000fe200020e0615ULL,
0x0000002a5100720cULL, 0x080fe20003f86070ULL, 0x0000000452157824ULL, 0x040fe400078e00ffULL,
0x0000000113277824ULL, 0x000fe200018e0627ULL, 0x0000002a5200720cULL, 0x000fe20003f66070ULL,
0x0000000451537824ULL, 0x000fe200078e00ffULL, 0xfffffffc15517812ULL, 0x000fe200078ee214ULL,
0x0000000113257824ULL, 0x000fe200010e0625ULL, 0x0000001812187210ULL, 0x000fe20007f5e0ffULL,
0x000000100f157824ULL, 0x000fe200078e020cULL, 0xfffffffc53537812ULL, 0x000fe200078ee214ULL,
0x0000001051517824ULL, 0x000fc400078e020cULL, 0x0000000113197824ULL, 0x000fe200010e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000c901c46ULL,
0x0000000c53537211ULL, 0x000fe400078e20ffULL, 0x0000002a2f00720cULL, 0x0c0fe20003f26070ULL,
0x000000001a517faeULL, 0x0005e2000d901c46ULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x0000002a2b00720cULL, 0x080fe40003f66070ULL, 0x0000000020537faeULL, 0x0007e2000e101c46ULL,
0x0000002a2c00720cULL, 0x000fc40003f86070ULL, 0xfffffffc2f2f7812ULL, 0x000fe400078ee214ULL,
0x0000002212167210ULL, 0x002fe20007f5e0ffULL, 0x000000042b1b7824ULL, 0x004fc800078e00ffULL,
0x0000000113177824ULL, 0x000fe400010e0623ULL, 0x000000042c217824ULL, 0x008fe200078e00ffULL,
0xfffffffc1b1b7812ULL, 0x100fe200078ee214ULL, 0x000000042d237824ULL, 0x000fe400078e00ffULL,
0x000000042e2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc21217812ULL, 0x000fe200078ee214ULL,
0x000000102f2f7824ULL, 0x000fe200078e020cULL, 0xfffffffc23237812ULL, 0x000fe200078ee214ULL,
0x000000101b1b7824ULL, 0x000fe200078e020cULL, 0xfffffffc2b2b7812ULL, 0x000fe200078ee214ULL,
0x0000001021217824ULL, 0x100fe200078e020cULL, 0x00000000242f7faeULL, 0x0003e2000c901c46ULL,
0x0000001023237824ULL, 0x000fc400078e020cULL, 0x000000102b2b7824ULL, 0x000fe200078e020cULL,
0x00000000261b7faeULL, 0x0003e8000d901c46ULL, 0x0000000028217faeULL, 0x0003e8000e101c46ULL,
0x0000000018237faeULL, 0x0003e8000e901c46ULL, 0x00000000162b7faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000086e587811ULL, 0x000fe200078ff0ffULL,
0x000000ffff297224ULL, 0x020fe200078e00ffULL, 0x0000008010287812ULL, 0x000fe200078efcffULL,
0x0000000150507824ULL, 0x000fe200078e026eULL, 0x000000206e547811ULL, 0x000fe200078ff0ffULL,
0x0000000158197824ULL, 0x000fe200078e0211ULL, 0x000000306e2c7811ULL, 0x000fc400078ff0ffULL,
0x000000116e177211ULL, 0x040fe200078ff0ffULL, 0x0000010019187825ULL, 0x000fe200078e0028ULL,
0x000000186e2a7811ULL, 0x040fe400078ff0ffULL, 0x000000106e567811ULL, 0x000fe200078ff0ffULL,
0x0000000154237824ULL, 0x100fe200078e0211ULL, 0x0000001812187210ULL, 0x000fe20007f5e0ffULL,
0x000000012c157824ULL, 0x000fe200078e0211ULL, 0x000000286e527811ULL, 0x040fe200078ff0ffULL,
0x0000010023227825ULL, 0x000fe200078e0028ULL, 0x000000386e2e7811ULL, 0x000fc400078ff0ffULL,
0x00000002582b7819ULL, 0x000fe200000006ffULL, 0x0000000113197824ULL, 0x000fe200010e0619ULL,
0x0000002212227210ULL, 0x000fe20007f5e0ffULL, 0x0000010017167825ULL, 0x000fc800078e0028ULL,
0x0000010015147825ULL, 0x000fe200078e0028ULL, 0x0000001612167210ULL, 0x000fc60007f3e0ffULL,
0x000000012a217824ULL, 0x000fe400078e0211ULL, 0x0000000113237824ULL, 0x000fe200010e0623ULL,
0x0000001412267210ULL, 0x000fe20007f5e0ffULL, 0x0000010021207825ULL, 0x000fe200078e0028ULL,
0x0000000350147812ULL, 0x000fc600078ec0ffULL, 0x00000001561b7824ULL, 0x100fe200078e0211ULL,
0x0000000f140f7212ULL, 0x000fe200078efcffULL, 0x0000000152257824ULL, 0x100fe200078e0211ULL,
0xfffffffc2b2b7812ULL, 0x000fe200078ee214ULL, 0x000000012e277824ULL, 0x000fe400078e0211ULL,
0x0000000113177824ULL, 0x000fe200008e0617ULL, 0x0000002012207210ULL, 0x000fe20007f3e0ffULL,
0x000001001b1a7825ULL, 0x000fc800078e0028ULL, 0x0000010025247825ULL, 0x000fe200078e0028ULL,
0x0000001a121a7210ULL, 0x000fc60007f7e0ffULL, 0x0000010027287825ULL, 0x000fc800078e0028ULL,
0x00000004562d7824ULL, 0x000fe400078e00ffULL, 0x0000000113277824ULL, 0x000fe400010e0615ULL,
0x000000042a2f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc2d2d7812ULL, 0x000fe200078ee214ULL,
0x000000100f157824ULL, 0x000fe400078e020cULL, 0x0000000454517824ULL, 0x000fe200078e00ffULL,
0xfffffffc2f2f7812ULL, 0x000fe200078ee214ULL, 0x0000000113217824ULL, 0x000fe200008e0621ULL,
0x0000002412247210ULL, 0x000fe20007f3e0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000b901c46ULL,
0x0000000452537824ULL, 0x000fe200078e00ffULL, 0xfffffffc51517812ULL, 0x000fe200078ee214ULL,
0x000000042c557824ULL, 0x000fe200078e00ffULL, 0x00000000182b7faeULL, 0x0005e2000b901c46ULL,
0x000000042e577824ULL, 0x000fc400078e00ffULL, 0x0000000113257824ULL, 0x040fe200008e0625ULL,
0x0000002812287210ULL, 0x000fe20007f3e0ffULL, 0x00000001131b7824ULL, 0x000fe400018e061bULL,
0x000000102d2d7824ULL, 0x000fe200078e020cULL, 0xfffffffc53177812ULL, 0x002fe200078ee214ULL,
0x000000102f2f7824ULL, 0x100fe400078e020cULL, 0x0000001051517824ULL, 0x000fe200078e020cULL,
0xfffffffc55197812ULL, 0x004fe200078ee214ULL, 0x0000001017177824ULL, 0x000fe200078e020cULL,
0xfffffffc572b7812ULL, 0x000fe200078ee214ULL, 0x0000000113297824ULL, 0x000fe200008e0629ULL,
0x000000001a2d7faeULL, 0x0003e2000b901c46ULL, 0x0000001019197824ULL, 0x000fc400078e020cULL,
0x000000102b2b7824ULL, 0x000fe200078e020cULL, 0x00000000202f7faeULL, 0x0003e8000b901c46ULL,
0x0000000022517faeULL, 0x0003e8000b901c46ULL, 0x0000000024177faeULL, 0x0003e8000b901c46ULL,
0x0000000026197faeULL, 0x0003e8000b901c46ULL, 0x00000000282b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001062177824ULL, 0x042fe200078e00ffULL,
0x000000040d167810ULL, 0x000fe20007ffe0ffULL, 0x00000010622d7824ULL, 0x000fe200078e00ffULL,
0x000020000e0e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff017167812ULL, 0x000fe400078ee216ULL,
0x000000060d2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000100b6b7824ULL, 0x000fe400078e020eULL,
0x0000001016167824ULL, 0x000fe200078e00ffULL, 0xfffffff02d2c7812ULL, 0x000fe200078ee22cULL,
0x000000100a697824ULL, 0x100fe400078e020eULL, 0x0000001009687824ULL, 0x100fe400078e020eULL,
0x0000001008177824ULL, 0x000fc400078e020eULL, 0x0000001005057824ULL, 0x100fe400078e020eULL,
0x0000001003037824ULL, 0x000fe200078e020eULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006b20783bULL, 0x000fe80000000200ULL, 0x000000001618783bULL, 0x0002a80000000200ULL,
0x000000006924783bULL, 0x000ee80000000200ULL, 0x000000006808783bULL, 0x000f220000000200ULL,
0x0000001007167824ULL, 0x002fc400078e020eULL, 0x0000001006077824ULL, 0x000fe200078e020eULL,
0x000000001728783bULL, 0x000e680000000200ULL, 0x000000000754783bULL, 0x000fe80000000200ULL,
0x000000000550783bULL, 0x000fe80000000200ULL, 0x000000000358783bULL, 0x000fe20000000200ULL,
0x000000201830723cULL, 0x044b6e0000041830ULL, 0x000000102c207824ULL, 0x020fe200078e00ffULL,
0x000000221834723cULL, 0x040b620000041834ULL, 0x00000000162c783bULL, 0x000fe80000000200ULL,
0x000000002020783bULL, 0x020ea60000000200ULL, 0x000000241838723cULL, 0x048f700000041838ULL,
0x00000026183c723cULL, 0x040f70000004183cULL, 0x000000081840723cULL, 0x050f700000041840ULL,
0x0000000a1844723cULL, 0x040f700000041844ULL, 0x000000281848723cULL, 0x042f700000041848ULL,
0x0000002a181c723cULL, 0x000f70000004181cULL, 0x0000002c2030723cULL, 0x044b700000041830ULL,
0x0000002e2034723cULL, 0x040b700000041834ULL, 0x000000542038723cULL, 0x060b700000041838ULL,
0x00000056203c723cULL, 0x040b70000004183cULL, 0x000000502040723cULL, 0x040b700000041840ULL,
0x000000522044723cULL, 0x040b700000041844ULL, 0x000000582048723cULL, 0x040b700000041848ULL,
0x0000005a201c723cULL, 0x000b62000004181cULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2a7819ULL, 0x000fe2000001166eULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0x000000c0101a7812ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e020eULL,
0x000000112a0b7210ULL, 0x000fc40007ffe0ffULL, 0x000000102a067810ULL, 0x040fe40007ffe0ffULL,
0x000000082a2e7810ULL, 0x040fe20007ffe0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e001aULL,
0x0000004e63277217ULL, 0x000fe40007800000ULL, 0x000000182a267810ULL, 0x000fe20007ffe0ffULL,
0x0000000106197824ULL, 0x100fe200078e0211ULL, 0x0000000a12207210ULL, 0x020fe20007f1e0ffULL,
0x000000012e097824ULL, 0x000fe200078e0211ULL, 0x000000202a287810ULL, 0x040fe20007ffe0ffULL,
0x0000010019187825ULL, 0x000fe200078e001aULL, 0x000000282a2c7810ULL, 0x000fc60007ffe0ffULL,
0x0000000127277824ULL, 0x000fe400078e0a4eULL, 0x0000000113217824ULL, 0x000fe200000e060bULL,
0x0000001812187210ULL, 0x000fe20007f1e0ffULL, 0x00000001260b7824ULL, 0x000fe200078e0211ULL,
0x000000272a00720cULL, 0x080fe20003f46070ULL, 0x0000010009087825ULL, 0x100fe200078e001aULL,
0x000000272e00720cULL, 0x080fe40003f66070ULL, 0x000000270600720cULL, 0x000fe20003fa6070ULL,
0x000000042e297824ULL, 0x000fe200078e00ffULL, 0x0000000812087210ULL, 0x000fe20007f3e0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e001aULL, 0x000000302a2e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc29297812ULL, 0x000fe200078ee214ULL, 0x0000000128257824ULL, 0x100fe200078e0211ULL,
0x000000382a2a7810ULL, 0x000fe20007ffe0ffULL, 0x000000012c237824ULL, 0x000fe200078e0211ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000200f7faeULL, 0x0003e2000d101c46ULL,
0x0000000113197824ULL, 0x000fe200000e0619ULL, 0x0000000a120a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010025247825ULL, 0x100fe200078e001aULL, 0x000000272600720cULL, 0x080fe40003f86070ULL,
0x000000272c00720cULL, 0x000fe20003f46070ULL, 0x0000010023227825ULL, 0x000fc800078e001aULL,
0x0000000113097824ULL, 0x000fe200008e0609ULL, 0x0000002412247210ULL, 0x040fe20007f3e0ffULL,
0x0000001029297824ULL, 0x000fe400078e020eULL, 0x00000001130b7824ULL, 0x000fe200000e060bULL,
0x0000002212227210ULL, 0x000fe20007f1e0ffULL, 0x000000012e2b7824ULL, 0x100fe200078e0211ULL,
0x0000000008297faeULL, 0x0005e2000d901c46ULL, 0x000000012a117824ULL, 0x000fe200078e0211ULL,
0x000000272800720cULL, 0x000fe20003f66070ULL, 0x00000004060f7824ULL, 0x002fc400078e00ffULL,
0x0000000113257824ULL, 0x040fe200008e0625ULL, 0x000000272e00720cULL, 0x080fe20003f26070ULL,
0x0000000113237824ULL, 0x000fe200000e0623ULL, 0x000000272a00720cULL, 0x000fe20003f06070ULL,
0x0000000428217824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee214ULL,
0x000000042c277824ULL, 0x000fe400078e00ffULL, 0x000001002b087825ULL, 0x004fe200078e001aULL,
0xfffffffc21217812ULL, 0x100fe400078ee214ULL, 0xfffffffc27277812ULL, 0x000fe200078ee214ULL,
0x00000100111a7825ULL, 0x000fe200078e001aULL, 0x0000000812087210ULL, 0x000fc60007fde0ffULL,
0x0000000426117824ULL, 0x000fe400078e00ffULL, 0x000000042e297824ULL, 0x000fe400078e00ffULL,
0x000000042a2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc11117812ULL, 0x100fe200078ee214ULL,
0x0000000113097824ULL, 0x000fe200030e0609ULL, 0xfffffffc29297812ULL, 0x000fe200078ee214ULL,
0x000000100f0f7824ULL, 0x000fe200078e020eULL, 0xfffffffc2b2b7812ULL, 0x000fe200078ee214ULL,
0x0000001021217824ULL, 0x100fe200078e020eULL, 0x0000001a12127210ULL, 0x000fe20007fde0ffULL,
0x0000001027277824ULL, 0x100fe200078e020eULL, 0x0000000e11117211ULL, 0x000fe200078e20ffULL,
0x0000001029297824ULL, 0x100fe200078e020eULL, 0x00000000180f7faeULL, 0x0003e2000e901c46ULL,
0x000000102b2b7824ULL, 0x000fc400078e020eULL, 0x0000000113137824ULL, 0x000fe200030e061bULL,
0x000000000a117faeULL, 0x0003e8000e101c46ULL, 0x0000000024217faeULL, 0x0003e8000d901c46ULL,
0x0000000022277faeULL, 0x0003e8000d101c46ULL, 0x0000000008297faeULL, 0x0003e8000c901c46ULL,
0x00000000122b7faeULL, 0x0003e2000c101c46ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x000000086e067811ULL, 0x040fe200078ff0ffULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x000000106e287811ULL, 0x000fc400078ff0ffULL, 0x000000186e2a7811ULL, 0x000fe200078ff0ffULL,
0x0000000406297824ULL, 0x000fe200078e00ffULL, 0x000000206e2c7811ULL, 0x000fe200078ff0ffULL,
0x00000004282b7824ULL, 0x000fe200078e00ffULL, 0x000000286e2e7811ULL, 0x000fe200078ff0ffULL,
0x000000042a2d7824ULL, 0x000fe200078e00ffULL, 0x000000386e527811ULL, 0x020fe200078ff0ffULL,
0x000000042c2f7824ULL, 0x000fe200078e00ffULL, 0x000000306e507811ULL, 0x000fe200078ff0ffULL,
0x000000042e517824ULL, 0x000fe200078e00ffULL, 0x000000c010087812ULL, 0x000fe200078efcffULL,
0x0000000452557824ULL, 0x000fe200078e00ffULL, 0x000000116e217211ULL, 0x000fe200078ff0ffULL,
0x0000000450537824ULL, 0x000fe200078e00ffULL, 0xfffffffc29297812ULL, 0x100fe200078ee214ULL,
0x0000000106237824ULL, 0x100fe200078e0211ULL, 0xfffffffc2b2b7812ULL, 0x100fe200078ee214ULL,
0x0000000128257824ULL, 0x100fe200078e0211ULL, 0xfffffffc2d2d7812ULL, 0x100fe200078ee214ULL,
0x000000012a277824ULL, 0x100fe200078e0211ULL, 0xfffffffc2f2f7812ULL, 0x100fe200078ee214ULL,
0x000000012c0b7824ULL, 0x100fe200078e0211ULL, 0xfffffffc51517812ULL, 0x100fe200078ee214ULL,
0x000000012e197824ULL, 0x100fe200078e0211ULL, 0xfffffffc55557812ULL, 0x100fe200078ee214ULL,
0x00000001501b7824ULL, 0x100fe200078e0211ULL, 0xfffffffc53537812ULL, 0x000fe200078ee214ULL,
0x0000000152117824ULL, 0x000fc400078e0211ULL, 0x0000010021207825ULL, 0x000fe200078e0008ULL,
0x0000000e53537211ULL, 0x000fc600078e20ffULL, 0x0000010023227825ULL, 0x000fc800078e0008ULL,
0x0000010025247825ULL, 0x000fc800078e0008ULL, 0x0000010027267825ULL, 0x000fc800078e0008ULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x0000010019187825ULL, 0x000fc800078e0008ULL,
0x000001001b1a7825ULL, 0x000fc800078e0008ULL, 0x0000010011087825ULL, 0x000fc800078e0008ULL,
0x000000100f117824ULL, 0x100fe400078e020eULL, 0x0000001029297824ULL, 0x100fe400078e020eULL,
0x000000102b2b7824ULL, 0x100fe400078e020eULL, 0x000000102d2d7824ULL, 0x100fe400078e020eULL,
0x000000102f2f7824ULL, 0x100fe400078e020eULL, 0x0000001051517824ULL, 0x000fc400078e020eULL,
0x0000001055557824ULL, 0x000fe200078e020eULL, 0x00000020120e7210ULL, 0x040fe40007f1e0ffULL,
0x0000002212207210ULL, 0x040fe40007f3e0ffULL, 0x0000002412227210ULL, 0x040fe20007f5e0ffULL,
0x00000001130f7824ULL, 0x040fe200000e0621ULL, 0x0000002612247210ULL, 0x040fe20007f7e0ffULL,
0x0000000113217824ULL, 0x040fe200008e0623ULL, 0x0000000a120a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000113237824ULL, 0x040fe200010e0625ULL, 0x0000001812187210ULL, 0x040fe20007f3e0ffULL,
0x0000000113257824ULL, 0x040fe200018e0627ULL, 0x0000001a121a7210ULL, 0x040fe20007f5e0ffULL,
0x00000001130b7824ULL, 0x040fe200000e060bULL, 0x0000000812087210ULL, 0x000fe20007f7e0ffULL,
0x0000000113197824ULL, 0x040fe200008e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e117faeULL, 0x0003e2000b901c46ULL, 0x00000001131b7824ULL, 0x000fc400010e061bULL,
0x0000000113097824ULL, 0x000fe200018e0609ULL, 0x0000000020297faeULL, 0x0003e8000b901c46ULL,
0x00000000222b7faeULL, 0x0003e8000b901c46ULL, 0x00000000242d7faeULL, 0x0003e8000b901c46ULL,
0x000000000a2f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018517faeULL, 0x0003e8000b901c46ULL,
0x000000001a537faeULL, 0x0003e8000b901c46ULL, 0x0000000008557faeULL, 0x0003e4000b901c46ULL,
0x0000000261617810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff067424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000716100720cULL, 0x000fda0003f06070ULL,
0x00000002790e8824ULL, 0x002fe400078e0261ULL, 0x00000004ff0f8424ULL, 0x000fc800078e00ffULL,
0x000066000e0e8625ULL, 0x000fe200078e000fULL, 0x000000080d087810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000060e068981ULL, 0x0002a2000c1e1900ULL,
0x0000001062097824ULL, 0x000fc600078e00ffULL, 0x000000006554783bULL, 0x000fe40000000200ULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x000000006458783bULL, 0x000fe20000000200ULL,
0x00000010620f7824ULL, 0x002fe200078e00ffULL, 0x0000000a0d0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001008507824ULL, 0x000fe200078e00ffULL, 0x00000000662c783bULL, 0x000fe40000000200ULL,
0xfffffff00f0e7812ULL, 0x000fc400078ee20eULL, 0x000000005c08783bULL, 0x000fe60000000200ULL,
0x000000100e0e7824ULL, 0x000fe200078e00ffULL, 0x000000005050783bULL, 0x000e680000000200ULL,
0x000000005d5c783bULL, 0x000ee80000000200ULL, 0x000000000e18783bULL, 0x000f280000000200ULL,
0x000000006d20783bULL, 0x000ee80000000200ULL, 0x000000006a28783bULL, 0x000ee80000000200ULL,
0x000000006c24783bULL, 0x000ee20000000200ULL, 0x000000085030723cULL, 0x042f700000041830ULL,
0x00000056501c723cULL, 0x040f70000004181cULL, 0x0000000a5034723cULL, 0x040f700000041834ULL,
0x0000005c5038723cULL, 0x048f700000041838ULL, 0x0000005e503c723cULL, 0x040f70000004183cULL,
0x000000585040723cULL, 0x040f700000041840ULL, 0x0000005a5044723cULL, 0x040f700000041844ULL,
0x000000545048723cULL, 0x000f700000041848ULL, 0x0000002c1830723cULL, 0x070b6e0000041830ULL,
0x00000300022c7a10ULL, 0x020fe20007ffe0ffULL, 0x00000022181c723cULL, 0x000b66000004181cULL,
0x000000012c087810ULL, 0x000fc80007ffe0ffULL, 0x000000670800720cULL, 0x000fe20003f06070ULL,
0x000001002c227824ULL, 0x020fe200078e0277ULL, 0x0000002e1834723cULL, 0x000b680000041834ULL,
0x0000004022087812ULL, 0x000fc800078ec0ffULL, 0x000000281838723cULL, 0x000b620000041838ULL,
0x000000016f117824ULL, 0x000fce00078e0208ULL, 0x0000002a183c723cULL, 0x040b70000004183cULL,
0x000000241840723cULL, 0x040b700000041840ULL, 0x000000261844723cULL, 0x040b700000041844ULL,
0x000000201848723cULL, 0x000b620000041848ULL, 0x0000007606097224ULL, 0x004fc800078e02ffULL,
0x0000640009087625ULL, 0x000fe200078e0078ULL, 0x000005b000008947ULL, 0x000fca0003800000ULL,
0x00000002ff247819ULL, 0x020fe4000001166eULL, 0x00000022630e7217ULL, 0x000fe40007800000ULL,
0x0000000824207810ULL, 0x040fe20007ffe0ffULL, 0x00000001240a7824ULL, 0x040fe200078e0211ULL,
0x0000001024267810ULL, 0x000fe20007ffe0ffULL, 0x000000010e227824ULL, 0x000fe200078e0a22ULL,
0x0000002024287810ULL, 0x000fe20007ffe0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001824277810ULL, 0x000fc40007ffe0ffULL, 0x0000002824297810ULL, 0x000fe20007ffe0ffULL,
0x00000001200f7824ULL, 0x100fe200078e0211ULL, 0x000000100a197212ULL, 0x000fe200078efcffULL,
0x0000000126127824ULL, 0x000fe200078e0211ULL, 0x00000030242a7810ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e00ffULL, 0x00000019080a7210ULL, 0x000fe40007f1e0ffULL,
0x000000222600720cULL, 0x000fe20003fa6070ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000100e1b7212ULL, 0x000fc400078efcffULL, 0x000000222700720cULL, 0x000fe20003f86070ULL,
0x00000001281a7824ULL, 0x000fe200078e0211ULL, 0x0000001012197212ULL, 0x000fe200078efcffULL,
0x00000001090b7824ULL, 0x000fe200000e060bULL, 0x0000001b080e7210ULL, 0x000fe20007f3e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000001908127210ULL, 0x000fc60007f1e0ffULL,
0x0000000420257824ULL, 0x000fe200078e00ffULL, 0x0000001309137210ULL, 0x000fe200007fe4ffULL,
0x0000000127187824ULL, 0x000fe200078e0211ULL, 0x000000222400720cULL, 0x000fe20003f06070ULL,
0x00000001090f7824ULL, 0x000fe200008e060fULL, 0x000000101a217212ULL, 0x000fe200078efcffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000222000720cULL, 0x000fe40003f26070ULL,
0x00000021081a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000129207824ULL, 0x000fe200078e0211ULL,
0xfffffffc25217812ULL, 0x000fc400078ee214ULL, 0x0000001018237212ULL, 0x000fe200078efcffULL,
0x00000001091b7824ULL, 0x000fe200018e061bULL, 0x0000003824247810ULL, 0x000fe20007ffe0ffULL,
0x0000001021257824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000c101c46ULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000002308187210ULL, 0x000fe40007f5e0ffULL, 0x000000000e257faeULL, 0x0005e2000c901c46ULL,
0x000000222800720cULL, 0x000fe20003f66070ULL, 0x00000004242b7824ULL, 0x000fe200078e00ffULL,
0x0000001020237212ULL, 0x000fe200078efcffULL, 0x0000000109197824ULL, 0x000fe200010e0619ULL,
0x000000222900720cULL, 0x000fc40003f46070ULL, 0x0000002308207210ULL, 0x000fe20007fde0ffULL,
0x000000012a0a7824ULL, 0x142fe200078e0211ULL, 0x000000222a00720cULL, 0x080fe20003f26070ULL,
0x0000000426157824ULL, 0x000fe200078e00ffULL, 0x000000222400720cULL, 0x000fe20003f06070ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc2b2b7812ULL, 0x100fe400078ee214ULL,
0xfffffffc15157812ULL, 0x000fe200078ee214ULL, 0x00000001240e7824ULL, 0x004fe200078e0211ULL,
0x000000100a117212ULL, 0x000fe200078efcffULL, 0x0000000427237824ULL, 0x000fc400078e00ffULL,
0x000001000e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffffc23237812ULL, 0x100fe200078ee214ULL,
0x0000000428257824ULL, 0x000fe400078e00ffULL, 0x0000000109217824ULL, 0x000fe200030e0621ULL,
0x00000011080a7210ULL, 0x000fe20007fde0ffULL, 0x0000000429277824ULL, 0x000fe200078e00ffULL,
0x000000100e117212ULL, 0x000fe200078efcffULL, 0x000000042a297824ULL, 0x000fe200078e00ffULL,
0xfffffffc25257812ULL, 0x100fe200078ee214ULL, 0x00000001090b7824ULL, 0x000fe200030e060bULL,
0xfffffffc27277812ULL, 0x000fe200078ee214ULL, 0x0000001015157824ULL, 0x000fe200078e020cULL,
0xfffffffc29297812ULL, 0x000fe200078ee214ULL, 0x0000001023237824ULL, 0x100fe200078e020cULL,
0x0000001108087210ULL, 0x000fe20007fde0ffULL, 0x0000001025257824ULL, 0x100fe200078e020cULL,
0x0000000012157faeULL, 0x0003e2000e901c46ULL, 0x0000001027277824ULL, 0x000fc400078e020cULL,
0x0000001029297824ULL, 0x100fe200078e020cULL, 0x0000000018237faeULL, 0x0003e2000e101c46ULL,
0x000000102b2b7824ULL, 0x000fe400078e020cULL, 0x0000000109097824ULL, 0x000fe200030e060fULL,
0x000000001a257faeULL, 0x0003e8000d901c46ULL, 0x0000000020277faeULL, 0x0003e8000d101c46ULL,
0x000000000a297faeULL, 0x0003e8000c901c46ULL, 0x00000000082b7faeULL, 0x0003e2000c101c46ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x000000116e0a7211ULL, 0x060fe400078ff0ffULL,
0x000000086e0e7811ULL, 0x000fc400078ff0ffULL, 0x000000106e187811ULL, 0x000fe200078ff0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000186e1a7811ULL, 0x040fe400078ff0ffULL,
0x000000206e227811ULL, 0x000fe200078ff0ffULL, 0x000000010e127824ULL, 0x100fe200078e0211ULL,
0x000000286e267811ULL, 0x000fe200078ff0ffULL, 0x000000040e277824ULL, 0x000fe200078e00ffULL,
0x000000306e287811ULL, 0x000fe200078ff0ffULL, 0x00000001180e7824ULL, 0x100fe200078e0211ULL,
0x000000386e2a7811ULL, 0x000fe200078ff0ffULL, 0x0000000418297824ULL, 0x000fe200078e00ffULL,
0x000000111a207210ULL, 0x040fe20007ffe0ffULL, 0x000000041a197824ULL, 0x000fe200078e00ffULL,
0xfffffffc27277812ULL, 0x100fe200078ee214ULL, 0x0000000122247824ULL, 0x140fe200078e0211ULL,
0xfffffffc29297812ULL, 0x100fe200078ee214ULL, 0x00000004221b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc19197812ULL, 0x000fe200078ee214ULL, 0x0000000126227824ULL, 0x000fc400078e0211ULL,
0x00000001281a7824ULL, 0x100fe200078e0211ULL, 0xfffffffc1b1b7812ULL, 0x100fe200078ee214ULL,
0x000000012a187824ULL, 0x000fe200078e0211ULL, 0x000000100a117212ULL, 0x080fe200078efcffULL,
0x0000000428257824ULL, 0x000fe400078e00ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x00000011080a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc25257812ULL, 0x000fe200078ee214ULL,
0x0000000426237824ULL, 0x000fe200078e00ffULL, 0x000000100e117212ULL, 0x000fe200078efcffULL,
0x0000010012127825ULL, 0x000fc600078e00ffULL, 0xfffffffc23237812ULL, 0x000fe200078ee214ULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x00000011080e7210ULL, 0x000fc60007f5e0ffULL,
0x000000042a2b7824ULL, 0x000fe200078e00ffULL, 0x0000001020117212ULL, 0x080fe200078efcffULL,
0x0000001019517824ULL, 0x100fe200078e020cULL, 0x0000001012197212ULL, 0x000fe200078efcffULL,
0x0000001025577824ULL, 0x000fe200078e020cULL, 0xfffffffc2b2b7812ULL, 0x000fe200078ee214ULL,
0x0000001023557824ULL, 0x000fe200078e020cULL, 0x0000001908127210ULL, 0x000fe20007f3e0ffULL,
0x0000010024247825ULL, 0x000fc800078e00ffULL, 0x000000101b537824ULL, 0x000fe200078e020cULL,
0x00000010242f7212ULL, 0x000fe200078efcffULL, 0x0000010022227825ULL, 0x000fc800078e00ffULL,
0x00000001090b7824ULL, 0x000fe200000e060bULL, 0x0000001108207210ULL, 0x000fe20007f1e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x00000010222d7212ULL, 0x000fe400078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e2000b901c46ULL,
0x0000010018187825ULL, 0x000fc800078e00ffULL, 0x000000102b597824ULL, 0x100fe200078e020cULL,
0x000000101a2b7212ULL, 0x080fe200078efcffULL, 0x0000000109217824ULL, 0x040fe200000e0621ULL,
0x0000001018117212ULL, 0x000fe200078efcffULL, 0x0000000109137824ULL, 0x040fe200008e0613ULL,
0x0000002f08107210ULL, 0x040fe20007f1e0ffULL, 0x00000001090f7824ULL, 0x000fe200010e060fULL,
0x0000002d08227210ULL, 0x040fe20007f3e0ffULL, 0x0000001027277824ULL, 0x100fe200078e020cULL,
0x0000002b081a7210ULL, 0x040fe20007f5e0ffULL, 0x0000001029297824ULL, 0x000fe200078e020cULL,
0x0000001108087210ULL, 0x000fe20007f7e0ffULL, 0x0000000109117824ULL, 0x040fe200000e0625ULL,
0x0000000012277faeULL, 0x0003e2000b901c46ULL, 0x0000000109237824ULL, 0x000fc400008e0623ULL,
0x00000001091b7824ULL, 0x040fe200010e061bULL, 0x000000000e297faeULL, 0x0003e2000b901c46ULL,
0x0000000109097824ULL, 0x000fc600018e0619ULL, 0x0000000020517faeULL, 0x0003e8000b901c46ULL,
0x0000000010537faeULL, 0x0003e8000b901c46ULL, 0x0000000022557faeULL, 0x0003e8000b901c46ULL,
0x000000001a577faeULL, 0x0003e8000b901c46ULL, 0x0000000008597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001062097824ULL, 0x002fe200078e00ffULL,
0x0000000c0d087810ULL, 0x000fc40007ffe0ffULL, 0x0000000e0d0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x0000000462627819ULL, 0x000fc600000006ffULL,
0x0000001008107824ULL, 0x000fe200078e00ffULL, 0xfffffff0620d7812ULL, 0x000fca00078ee20dULL,
0x000000100d147824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006b08783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x000e680000000200ULL,
0x000000006918783bULL, 0x000fe80000000200ULL, 0x00000000170c783bULL, 0x000ea80000000200ULL,
0x000000006868783bULL, 0x000ee80000000200ULL, 0x000000001620783bULL, 0x000fe80000000200ULL,
0x000000001414783bULL, 0x000f280000000200ULL, 0x000000000328783bULL, 0x000ee80000000200ULL,
0x000000000724783bULL, 0x000ee20000000200ULL, 0x000000081030723cULL, 0x042f700000041830ULL,
0x0000000a1034723cULL, 0x040be40000041834ULL, 0x000000000508783bULL, 0x020e6c0000000200ULL,
0x0000000e101c723cULL, 0x044f70000004181cULL, 0x000000181038723cULL, 0x040f700000041838ULL,
0x0000001a103c723cULL, 0x040ff0000004183cULL, 0x000000681040723cULL, 0x048ff00000041840ULL,
0x0000006a1044723cULL, 0x040ff00000041844ULL, 0x0000000c1048723cULL, 0x000ff00000041848ULL,
0x000000201430723cULL, 0x050f700000041830ULL, 0x0000002a141c723cULL, 0x060f70000004181cULL,
0x000000221434723cULL, 0x040b700000041834ULL, 0x000000241438723cULL, 0x000b640000041838ULL,
0x3db504f331237820ULL, 0x020fe20000410000ULL, 0x3db504f332037820ULL, 0x000fca0000410000ULL,
0x00000026143c723cULL, 0x000f62000004183cULL, 0x3db504f31c227820ULL, 0x000fe20000410000ULL,
0x3db504f31d1c7820ULL, 0x000fe20000410000ULL, 0x3db504f31e197820ULL, 0x000fe20000410000ULL,
0x3db504f31f1a7820ULL, 0x000fc80000410000ULL, 0x000000081440723cULL, 0x002f620000041840ULL,
0x3db504f334247820ULL, 0x000fe20000410000ULL, 0x3db504f3352e7820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f3372f7820ULL, 0x000fc80000410000ULL,
0x0000000a1444723cULL, 0x000f620000041844ULL, 0x3db504f3382a7820ULL, 0x000fe20000410000ULL,
0x3db504f339257820ULL, 0x000fe20000410000ULL, 0x3db504f33a207820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc80000410000ULL, 0x000000281448723cULL, 0x000b640000041848ULL,
0x3db504f33c267820ULL, 0x020fe20000410000ULL, 0x3db504f33d327820ULL, 0x000fe20000410000ULL,
0x3db504f33e217820ULL, 0x000fe20000410000ULL, 0x3db504f33f317820ULL, 0x000fe40000410000ULL,
0x3db504f330177820ULL, 0x000fe20000410000ULL, 0x3db504f333167820ULL, 0x000fe20000410000ULL,
0x3db504f340307820ULL, 0x000fe20000410000ULL, 0x3db504f341277820ULL, 0x000fe20000410000ULL,
0x3db504f342157820ULL, 0x000fe20000410000ULL, 0x3db504f343147820ULL, 0x000fc80000410000ULL,
0x3db504f344287820ULL, 0x000fe20000410000ULL, 0x3db504f3452d7820ULL, 0x000fe20000410000ULL,
0x3db504f346127820ULL, 0x000fe20000410000ULL, 0x3db504f347137820ULL, 0x000fca0000410000ULL,
0x3db504f3482b7820ULL, 0x000fe20000410000ULL, 0x3db504f349297820ULL, 0x000fe20000410000ULL,
0x3db504f34a077820ULL, 0x000fe20000410000ULL, 0x3db504f34b187820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000074087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1e7224ULL, 0x000fe400078e0003ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0036ULL,
0x000000ffff1f7224ULL, 0x000fc400078e003bULL, 0x00000000000a7805ULL, 0x000fca0000015200ULL,
0x0000040074037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00cfc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140dULL,
0x0000000c03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000203037819ULL, 0x000fc8000000120cULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040074037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x004fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000046e1b7824ULL, 0x000fe200078e00ffULL, 0x000000720200720cULL, 0x000fc80003f06070ULL,
0xfffffff01b057812ULL, 0x000fca00078ec0ffULL, 0x0000008000057824ULL, 0x000fca00078e0205ULL,
0x0134000005087984ULL, 0x0004e20000000c00ULL, 0x000014e000008947ULL, 0x000fea0003800000ULL,
0x00005a00000c7b06ULL, 0x000f220000209000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff007a0cULL, 0x000fe20003f85070ULL, 0x000000026e337824ULL, 0x000fe200078e00ffULL,
0x00005a00ff107a12ULL, 0x000fc800078e33ffULL, 0x0000000633337812ULL, 0x000fca00078ec0ffULL,
0x0000000133357824ULL, 0x000fe200078e0204ULL, 0x0000000c000c7308ULL, 0x010f240000001000ULL,
0x0ffffffe0c0e7810ULL, 0x010fcc0007ffe0ffULL, 0x0000000e00037305ULL, 0x000f24000021f000ULL,
0x000000ffff0d7224ULL, 0x010fc800078e0a03ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d030f7227ULL, 0x000fe200078e0002ULL, 0x000000736e027211ULL, 0x000fca00078ff0ffULL,
0x000000020f037227ULL, 0x000fc800078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a03ULL,
0x00005a000d0c7a24ULL, 0x000fe200078e0202ULL, 0x0000000802027810ULL, 0x000fc80007ffe0ffULL,
0x00005a000c007a0cULL, 0x000fe20003f06070ULL, 0x000000020f0f7227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a0fULL, 0x00005a000d0e7a24ULL, 0x000fe200078e0202ULL,
0x0000004e630d7217ULL, 0x000fc60007800000ULL, 0x80005a000c0c0a10ULL, 0x000fe40007ffe0ffULL,
0x00005a000e007a0cULL, 0x000fe20003f46070ULL, 0x000000010d4e7824ULL, 0x000fe200078e0a4eULL,
0x00005a000c007a0cULL, 0x000fe20003f26070ULL, 0x00000001600d7824ULL, 0x000fe200078e0233ULL,
0x0000000103030810ULL, 0x000fc60007ffe0ffULL, 0x000000010d0c7824ULL, 0x040fe200078e0a4eULL,
0x0000004e0d00720cULL, 0x000fca0003f66070ULL, 0x80005a000e0e2a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a000e007a0cULL, 0x000fe40003f06070ULL,
0x0000000310027207ULL, 0x000fe40006000000ULL, 0x0000000c4f037217ULL, 0x000fe20003800000ULL,
0x00000001350c7824ULL, 0x000fe200078e0a4eULL, 0x000000024f517217ULL, 0x000fc40003800000ULL,
0x00000004ff037819ULL, 0x000fe40000011603ULL, 0x000000010f0f2810ULL, 0x000fe20007ffe0ffULL,
0x0000005170517224ULL, 0x000fe200078e02ffULL, 0x000000ff030e7207ULL, 0x000fe40001800000ULL,
0x0000004e3500720cULL, 0x000fe40003f26070ULL, 0x0000000c4f0c7217ULL, 0x000fe20003800000ULL,
0x0000000151037824ULL, 0x000fe200078e020eULL, 0x000000010f0f0810ULL, 0x000fc40007ffe0ffULL,
0x000000ff0c407207ULL, 0x000fe20000800000ULL, 0x0000000203027825ULL, 0x000fe200078e004cULL,
0x0000000f10107207ULL, 0x000fe40006000000ULL, 0x0000001033397812ULL, 0x000fe400078efcffULL,
0x00000051400d7211ULL, 0x000fe200078fe0ffULL, 0x0000000602467981ULL, 0x0048a2000c1e9500ULL,
0x000000104f537217ULL, 0x000fc60003800000ULL, 0x000000020d0c7825ULL, 0x000fc800078e004cULL,
0x0000000160037824ULL, 0x010fe200078e0239ULL, 0x000000060c4b7981ULL, 0x0008a2000c1e9500ULL,
0x0000005370537224ULL, 0x000fe400078e02ffULL, 0x0000000103027824ULL, 0x000fe400078e0a4eULL,
0x000000010e0f7824ULL, 0x000fe200078e0253ULL, 0x00000020333b7812ULL, 0x000fe200078efcffULL,
0x0000000139377824ULL, 0x000fe200078e0204ULL, 0x000000024f0c7217ULL, 0x010fe20003800000ULL,
0x000000020f0e7825ULL, 0x000fe200078e004cULL, 0x0000004e0300720cULL, 0x000fc40003f26070ULL,
0x00000004ff0c7819ULL, 0x000fe2000001160cULL, 0x0000000137027824ULL, 0x140fe200078e0a4eULL,
0x000000060e427981ULL, 0x0088e2000c1e9500ULL, 0x0000000160437824ULL, 0x000fe200078e023bULL,
0x0000004e3700720cULL, 0x000fe40003f06070ULL, 0x000000024f027217ULL, 0x000fe20003800000ULL,
0x00000001433a7824ULL, 0x000fe200078e0a4eULL, 0x000000ff0c0e7207ULL, 0x010fe40000800000ULL,
0x0000005340117211ULL, 0x000fc600078fe0ffULL, 0x0000000151037824ULL, 0x000fe200078e020eULL,
0x000000ff02347207ULL, 0x000fe40000000000ULL, 0x0000003a4f3a7217ULL, 0x000fe20003800000ULL,
0x0000000203027825ULL, 0x000fe200078e004cULL, 0x0000004e4300720cULL, 0x000fc60003f26070ULL,
0x0000000211107825ULL, 0x000fe200078e004cULL, 0x00000004ff3a7819ULL, 0x000fe2000001163aULL,
0x0000000602367981ULL, 0x0008e4000c1e9500ULL, 0x000000013b3f7824ULL, 0x000fe200078e0204ULL,
0x000000ff3a3e7207ULL, 0x000fe20000800000ULL, 0x0000000610577981ULL, 0x0002e2000c1e9500ULL,
0x0000003033437812ULL, 0x000fe200078efcffULL, 0x000000013f027824ULL, 0x010fe200078e0a4eULL,
0x00000051340d7211ULL, 0x000fe400078fe0ffULL, 0x000000530e0f7210ULL, 0x000fc40007ffe0ffULL,
0x0000005334117211ULL, 0x002fe200078fe0ffULL, 0x0000000151037824ULL, 0x000fe200078e023eULL,
0x0000004e3f00720cULL, 0x000fe40003f06070ULL, 0x000000024f027217ULL, 0x000fe20003800000ULL,
0x0000000160557824ULL, 0x000fe400078e0243ULL, 0x000000020d0c7825ULL, 0x000fe200078e004cULL,
0x000000ff023a7207ULL, 0x000fc60000000000ULL, 0x000000020f0e7825ULL, 0x100fe200078e004cULL,
0x000000060c3d7981ULL, 0x000326000c1e9500ULL, 0x0000000211107825ULL, 0x100fe200078e004cULL,
0x000000060e387981ULL, 0x000326000c1e9500ULL, 0x0000000203027825ULL, 0x000fe200078e004cULL,
0x0000000610417981ULL, 0x000326000c1e9500ULL, 0x0000000155447824ULL, 0x000fe200078e0a4eULL,
0x00000006023c7981ULL, 0x000322000c1e9500ULL, 0x0000000143477824ULL, 0x000fe200078e0204ULL,
0x000000513a0d7211ULL, 0x002fc400078fe0ffULL, 0x000000444f447217ULL, 0x000fe20003800000ULL,
0x000000013e0f7824ULL, 0x000fe200078e0253ULL, 0x000000533a117211ULL, 0x000fe200078fe0ffULL,
0x0000000147027824ULL, 0x000fe200078e0a4eULL, 0x0000004e5500720cULL, 0x080fe40003f26070ULL,
0x00000004ff447819ULL, 0x000fe20000011644ULL, 0x000000020d0c7825ULL, 0x100fe200078e004cULL,
0x0000004e4700720cULL, 0x000fe40003f06070ULL, 0x000000024f027217ULL, 0x000fe20003800000ULL,
0x000000020f0e7825ULL, 0x100fe200078e004cULL, 0x000000ff44487207ULL, 0x000fe20000800000ULL,
0x000000060c457981ULL, 0x000324000c1e9500ULL, 0x0000000211107825ULL, 0x000fe200078e004cULL,
0x000000ff02447207ULL, 0x000fe20000000000ULL, 0x000000060e3e7981ULL, 0x000328000c1e9500ULL,
0x0000000610497981ULL, 0x000322000c1e9500ULL, 0x0000000151037824ULL, 0x000fe200078e0248ULL,
0x00000051440d7211ULL, 0x002fc600078fe0ffULL, 0x0000000203027825ULL, 0x000fc800078e004cULL,
0x000000020d0c7825ULL, 0x000fe400078e004cULL, 0x0000000602027981ULL, 0x000322000c1e9500ULL,
0x00000053440f7211ULL, 0x000fc600078fe0ffULL, 0x000000060c0d7981ULL, 0x000322000c1e9500ULL,
0x0000000148117824ULL, 0x000fe400078e0253ULL, 0x000000020f0e7825ULL, 0x000fc800078e004cULL,
0x0000000211107825ULL, 0x000fe400078e004cULL, 0x000000060e0e7981ULL, 0x000328000c1e9500ULL,
0x0000000610117981ULL, 0x000322000c1e9500ULL, 0xfffffff040537812ULL, 0x000fe200078ec0ffULL,
0x00000001ff407424ULL, 0x000fc800078e00ffULL, 0x000000014e487824ULL, 0x000fc800078e0253ULL,
0x0000000135597824ULL, 0x000fe200078e0a48ULL, 0x0000000133517812ULL, 0x040fe400078efcffULL,
0x0000000933037812ULL, 0x002fe400078efcffULL, 0x0000005940597219ULL, 0x000fe200000006ffULL,
0x0000000151557824ULL, 0x100fe400078e0204ULL, 0x00000001030f7824ULL, 0x000fe400078e0204ULL,
0x00000001555b7824ULL, 0x000fc400078e0a48ULL, 0x000000010f5f7824ULL, 0x000fe200078e0a48ULL,
0x00000018337d7812ULL, 0x040fe400078efcffULL, 0x0000005b405b7219ULL, 0x040fe400000006ffULL,
0x0000005f405f7219ULL, 0x000fe400000006ffULL, 0x00000011330c7812ULL, 0x040fe400078efcffULL,
0x00000019337b7812ULL, 0x000fe400078efcffULL, 0xfffffff03a4a7812ULL, 0x000fc600078ec0ffULL,
0x000000017b107824ULL, 0x000fe400078e0204ULL, 0x000000014e4a7824ULL, 0x000fc800078e024aULL,
0x000000013f5e7824ULL, 0x000fe200078e0a4aULL, 0x0000002133657812ULL, 0x000fe400078efcffULL,
0xfffffff044447812ULL, 0x000fe400078ec0ffULL, 0x0000005e405e7219ULL, 0x000fe200000006ffULL,
0x00000001656d7824ULL, 0x000fe400078e0204ULL, 0x000000014e667824ULL, 0x000fe400078e0244ULL,
0x000000016d647824ULL, 0x000fc400078e0a4aULL, 0x0000000147567824ULL, 0x000fc600078e0a66ULL,
0x0000006440647219ULL, 0x040fe400000006ffULL, 0x0000005640567219ULL, 0x000fe400000006ffULL,
0x000054104b467816ULL, 0x004fe40000000046ULL, 0x00000008334b7812ULL, 0x000fe400078efcffULL,
0x0000004659ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014b537824ULL, 0x000fe200078e0204ULL,
0x0000004e3500720cULL, 0x000fc60000701470ULL, 0x00000001535d7824ULL, 0x000fe200078e0a48ULL,
0x0000004e3300720cULL, 0x000fe400007a1070ULL, 0xfffffff034487812ULL, 0x000fe400078ec0ffULL,
0x0000005d405d7219ULL, 0x000fe400000006ffULL, 0xff80000017177808ULL, 0x000fe20002800000ULL,
0x000000014e487824ULL, 0x000fc800078e0248ULL, 0x0000000137507824ULL, 0x000fe200078e0a48ULL,
0x000000465bff7212ULL, 0x000fc8000782c0ffULL, 0x0000005040507219ULL, 0x000fe400000006ffULL,
0x0000541057427816ULL, 0x008fc80000000042ULL, 0x0000004259ff7212ULL, 0x080fe4000784c0ffULL,
0x000000425bff7212ULL, 0x080fe4000780c0ffULL, 0x000000425dff7212ULL, 0x080fe400078cc0ffULL,
0x000000425fff7212ULL, 0x000fe200078ac0ffULL, 0x000000017d427824ULL, 0x000fe200078e0204ULL,
0x0000004e3500720cULL, 0x080fe40001741470ULL, 0x0000004e5300720cULL, 0x080fe200037c1470ULL,
0x0000000142587824ULL, 0x000fe200078e0a48ULL, 0x0000004e0f00720cULL, 0x000fc40002fa1470ULL,
0x0000004e3300720cULL, 0x080fe40001741070ULL, 0x0000004e4b00720cULL, 0x080fe400037c1070ULL,
0x0000004e0300720cULL, 0x000fe40002fa1070ULL, 0x0000005840587219ULL, 0x000fe400000006ffULL,
0x000054103d3d7816ULL, 0x010fe40000000036ULL, 0x000000465dff7212ULL, 0x000fc4000786c0ffULL,
0x0000541041417816ULL, 0x000fe40000000038ULL, 0x000000465fff7212ULL, 0x000fe2000788c0ffULL,
0x000000010c467824ULL, 0x000fe200078e0204ULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000003d50ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004150ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004158ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000146547824ULL, 0x100fe200078e0a48ULL,
0x0000004e5500720cULL, 0x0c0fe20000f21470ULL, 0x0000000110627824ULL, 0x000fe200078e0a48ULL,
0x0000004e5500720cULL, 0x080fe40000701470ULL, 0x0000004e5300720cULL, 0x080fe40001f61470ULL,
0x0000004e0f00720cULL, 0x000fc40002781470ULL, 0x0000004e3700720cULL, 0x0c0fe40001741470ULL,
0x0000004e3700720cULL, 0x080fe400037c1470ULL, 0x0000004e4200720cULL, 0x080fe40002fa1470ULL,
0x00000028335f7812ULL, 0x040fe400078efcffULL, 0x00000029335d7812ULL, 0x000fe400078efcffULL,
0x0000004e5100720cULL, 0x000fc40000f21070ULL, 0x0000004e5100720cULL, 0x080fe40000701070ULL,
0x0000004e4b00720cULL, 0x080fe40001f61070ULL, 0x0000004e0300720cULL, 0x080fe40002781070ULL,
0x0000004e3900720cULL, 0x0c0fe40001741070ULL, 0x0000004e3900720cULL, 0x080fe400037c1070ULL,
0x0000004e7d00720cULL, 0x000fc40002fa1070ULL, 0x0000005440547219ULL, 0x040fe400000006ffULL,
0x0000006240627219ULL, 0x000fe400000006ffULL, 0x0000541045457816ULL, 0x000fe4000000003cULL,
0x0000541049497816ULL, 0x000fe2000000003eULL, 0x000000015f6b7824ULL, 0x000fe200078e0204ULL,
0x000000045d697210ULL, 0x000fe40007ffe0ffULL, 0xff80000023237808ULL, 0x000fc40000800000ULL,
0xff80000016167808ULL, 0x000fe40000000000ULL, 0xff80000024247808ULL, 0x000fe40001800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0xff8000002a2a7808ULL, 0x000fe40001000000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fc40002800000ULL,
0x0000003d54ff7212ULL, 0x080fe4000782c0ffULL, 0x0000003d58ff7212ULL, 0x080fe4000780c0ffULL,
0x0000003d62ff7212ULL, 0x000fe4000786c0ffULL, 0x0000004154ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004162ff7212ULL, 0x000fe4000784c0ffULL, 0x000000455eff7212ULL, 0x000fc400078cc0ffULL,
0x000000495eff7212ULL, 0x000fe200078ac0ffULL, 0x000000016b5a7824ULL, 0x100fe200078e0a4aULL,
0x0000004e4600720cULL, 0x0c0fe20000f21470ULL, 0x00000001695c7824ULL, 0x000fe200078e0a4aULL,
0x0000004e4600720cULL, 0x080fe40002781470ULL, 0x0000004e4200720cULL, 0x080fe40000701470ULL,
0x0000004e1000720cULL, 0x0c0fe40001f61470ULL, 0x0000004e1000720cULL, 0x000fc40001741470ULL,
0x0000004e3f00720cULL, 0x0c0fe400037c1470ULL, 0x0000004e3f00720cULL, 0x080fe40002fa1470ULL,
0x00000031335b7812ULL, 0x040fe400078efcffULL, 0x0000003833597812ULL, 0x040fe400078efcffULL,
0x0000003933577812ULL, 0x000fe400078efcffULL, 0x0000004e0c00720cULL, 0x000fc40000f21070ULL,
0x0000004e0c00720cULL, 0x080fe40002781070ULL, 0x0000004e7d00720cULL, 0x080fe40000701070ULL,
0x0000004e7b00720cULL, 0x0c0fe40001f61070ULL, 0x0000004e7b00720cULL, 0x080fe40001741070ULL,
0x0000004e3b00720cULL, 0x0c0fe400037c1070ULL, 0x0000004e3b00720cULL, 0x000fc40002fa1070ULL,
0x0000005a405a7219ULL, 0x040fe400000006ffULL, 0x0000005c405c7219ULL, 0x000fe400000006ffULL,
0x000054100d0d7816ULL, 0x000fe20000000002ULL, 0x000000015b347824ULL, 0x100fe200078e0204ULL,
0xff80000025257808ULL, 0x000fe20000800000ULL, 0x00000001593a7824ULL, 0x100fe200078e0204ULL,
0xff8000001f1f7808ULL, 0x000fe20002000000ULL, 0x0000000157447824ULL, 0x000fe200078e0204ULL,
0xff80000026267808ULL, 0x000fc40000000000ULL, 0xff80000032327808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40003000000ULL,
0xff80000015157808ULL, 0x000fe40002800000ULL, 0x0000004564ff7212ULL, 0x080fe4000782c0ffULL,
0x000000455aff7212ULL, 0x000fc4000788c0ffULL, 0x000000455cff7212ULL, 0x000fe4000780c0ffULL,
0x0000004964ff7212ULL, 0x080fe4000786c0ffULL, 0x000000495aff7212ULL, 0x080fe4000784c0ffULL,
0x000000495cff7212ULL, 0x000fe400078cc0ffULL, 0x0000000d56ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000134527824ULL, 0x100fe200078e0a66ULL, 0x0000004e6d00720cULL, 0x0c0fe20000f21470ULL,
0x000000013a487824ULL, 0x100fe200078e0a66ULL, 0x0000004e6d00720cULL, 0x080fe20001f61470ULL,
0x00000001444a7824ULL, 0x000fe200078e0a66ULL, 0x0000004e6b00720cULL, 0x000fc40002781470ULL,
0x0000004e6b00720cULL, 0x080fe40001741470ULL, 0x0000004e6900720cULL, 0x0c0fe40000701470ULL,
0x0000004e6900720cULL, 0x080fe400037c1470ULL, 0x0000004e4700720cULL, 0x080fe40002fa1470ULL,
0x0000004e6500720cULL, 0x0c0fe40000f21070ULL, 0x0000004e6500720cULL, 0x000fc40001f61070ULL,
0x0000004e5f00720cULL, 0x0c0fe40002781070ULL, 0x0000004e5f00720cULL, 0x080fe40001741070ULL,
0x0000004e5d00720cULL, 0x0c0fe40000701070ULL, 0x0000004e5d00720cULL, 0x080fe400037c1070ULL,
0x0000004e4300720cULL, 0x000fe40002fa1070ULL, 0x0000005240527219ULL, 0x000fc400000006ffULL,
0x0000004840487219ULL, 0x040fe400000006ffULL, 0x0000004a404a7219ULL, 0x000fe400000006ffULL,
0x000054100e117816ULL, 0x000fe40000000011ULL, 0xff80000027277808ULL, 0x000fe40000800000ULL,
0xff80000014147808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fc40002000000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40003000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002800000ULL,
0x0000000d52ff7212ULL, 0x080fe4000782c0ffULL, 0x0000000d48ff7212ULL, 0x000fc4000786c0ffULL,
0x0000000d4aff7212ULL, 0x000fe4000788c0ffULL, 0x0000001156ff7212ULL, 0x080fe4000784c0ffULL,
0x0000001152ff7212ULL, 0x080fe4000780c0ffULL, 0x0000001148ff7212ULL, 0x080fe400078cc0ffULL,
0x000000114aff7212ULL, 0x000fe400078ac0ffULL, 0x0000004e4700720cULL, 0x000fc40001741470ULL,
0x0000004e3400720cULL, 0x0c0fe40000f21470ULL, 0x0000004e3400720cULL, 0x080fe40000701470ULL,
0x0000004e3a00720cULL, 0x0c0fe40001f61470ULL, 0x0000004e3a00720cULL, 0x080fe400037c1470ULL,
0x0000004e4400720cULL, 0x0c0fe40002781470ULL, 0x0000004e4400720cULL, 0x000fc40002fa1470ULL,
0x0000004e4300720cULL, 0x080fe40001741070ULL, 0x0000004e5b00720cULL, 0x0c0fe40000f21070ULL,
0x0000004e5b00720cULL, 0x080fe40000701070ULL, 0x0000004e5900720cULL, 0x0c0fe40001f61070ULL,
0x0000004e5900720cULL, 0x080fe400037c1070ULL, 0x0000004e5700720cULL, 0x000fc40002781070ULL,
0x0000004e5700720cULL, 0x000fe40002fa1070ULL, 0xff80000029297808ULL, 0x000fe40000800000ULL,
0xff80000022227808ULL, 0x000fe40001800000ULL, 0xff8000001c1c7808ULL, 0x000fe40002000000ULL,
0xff80000007077808ULL, 0x000fe40001000000ULL, 0xff80000018187808ULL, 0x000fc40000000000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000001a1a7808ULL, 0x000fc40002800000ULL,
0x000000170800720bULL, 0x008fe20003f1e000ULL, 0x0000001fff117424ULL, 0x000fe200078e00ffULL,
0x0000001e0900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000817087208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000230800720bULL, 0x000fc40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000823037208ULL, 0x000fe40004000000ULL, 0x0000000916027208ULL, 0x000fe40004800000ULL,
0x000000240300720bULL, 0x000fe40003f1e000ULL, 0x0000001d0200720bULL, 0x000fe40003f3e000ULL,
0x0000000324037208ULL, 0x000fc40004000000ULL, 0x000000021d027208ULL, 0x000fe40004800000ULL,
0x0000002e0300720bULL, 0x000fe40003f1e000ULL, 0x0000002f0200720bULL, 0x000fe40003f3e000ULL,
0x000000032e037208ULL, 0x000fe40004000000ULL, 0x000000022f097208ULL, 0x000fe40004800000ULL,
0x0000002a0300720bULL, 0x000fc40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000032a027208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fe40004800000ULL,
0x000000250200720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000225037208ULL, 0x000fc40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000260300720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000326037208ULL, 0x000fe40004000000ULL, 0x0000000821087208ULL, 0x000fe40004800000ULL,
0x000000320300720bULL, 0x000fc40003f1e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x0000000332037208ULL, 0x000fe40004000000ULL, 0x0000000831087208ULL, 0x000fe40004800000ULL,
0x000000300300720bULL, 0x000fe40003f1e000ULL, 0x000000150800720bULL, 0x000fe40003f3e000ULL,
0x0000000330027208ULL, 0x000fc40004000000ULL, 0x0000000815037208ULL, 0x000fe40004800000ULL,
0x000000270200720bULL, 0x000fe40003f1e000ULL, 0x000000140300720bULL, 0x000fe40003f3e000ULL,
0x0000000227097208ULL, 0x000fe40004000000ULL, 0x0000000314037208ULL, 0x000fe40004800000ULL,
0x000000280900720bULL, 0x000fc40003f1e000ULL, 0x000000120300720bULL, 0x000fe40003f3e000ULL,
0x0000000928027208ULL, 0x000fe40004000000ULL, 0x0000000312087208ULL, 0x000fe40004800000ULL,
0x0000002d0200720bULL, 0x000fe40003f1e000ULL, 0x000000130800720bULL, 0x000fe40003f3e000ULL,
0x000000022d027208ULL, 0x000fc40004000000ULL, 0x0000000813087208ULL, 0x000fe40004800000ULL,
0x0000002b0200720bULL, 0x000fe40003f1e000ULL, 0x000000070800720bULL, 0x000fe40003f3e000ULL,
0x000000022b027208ULL, 0x000fe40004000000ULL, 0x0000000807037208ULL, 0x000fe40004800000ULL,
0x000000290200720bULL, 0x000fc40003f1e000ULL, 0x000000180300720bULL, 0x000fe40003f3e000ULL,
0x0000000229097208ULL, 0x000fe40004000000ULL, 0x0000000318027208ULL, 0x000fe40004800000ULL,
0x000000220900720bULL, 0x000fe40003f1e000ULL, 0x000000190200720bULL, 0x000fe40003f3e000ULL,
0x0000000922097208ULL, 0x000fc40004000000ULL, 0x0000000219037208ULL, 0x000fe40004800000ULL,
0x0000001c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001a0300720bULL, 0x000fe40003f3e000ULL,
0x000000091c0e7208ULL, 0x000fe40004000000ULL, 0x000000031a107208ULL, 0x000fe20004800000ULL,
0x000014a27f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e027f89ULL, 0x00066400000e0000ULL,
0x000000020e00720bULL, 0x002fc80003f1e000ULL, 0x0000000e02347208ULL, 0x000fe20004000000ULL,
0x000014b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010027f89ULL, 0x000e6800000e0000ULL,
0x0c401f000a037f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000ea800000e0000ULL,
0x0c201f0034097f89ULL, 0x000ee200000e0000ULL, 0x000000021000720bULL, 0x002fc40003f1e000ULL,
0x000000030a00720bULL, 0x010fe40003f3e000ULL, 0x00000010020c7208ULL, 0x000fe40004000000ULL,
0x0000000a030d7208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x004fe20003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08027208ULL, 0x000fe20004000000ULL,
0x0c201f000d0e7f89ULL, 0x008ea200000e0000ULL, 0x000000093400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0002037f89ULL, 0x0006e200000e0000ULL, 0x0000003409087208ULL, 0x000fe40004000000ULL,
0x0000000f0c00720bULL, 0x002fe40003f3e000ULL, 0x0000000e0d00720bULL, 0x004fe40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080b7820ULL, 0x008fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x000000036eff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080bULL, 0x0000002e000f7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b2a107823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b302a7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080bULL, 0x00000017000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b092e7820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001080bULL, 0x000000030200720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001082eULL,
0x00000023000d7308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b07077823ULL, 0x100fe2000001082eULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001082eULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001082eULL,
0x00000024000e7308ULL, 0x0007220000000800ULL, 0x3fb8aa3b2b237823ULL, 0x002fe2000001080bULL,
0x3fb8aa3b1a1a7823ULL, 0x000fcc000001082eULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x00000004ff247e24ULL, 0x008fe2000f8e00ffULL, 0x0000000c0d0c723eULL, 0x004fe200000010ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x3f8000002424783eULL, 0x000fe400000010ffULL,
0x0000001600177308ULL, 0x000e620000000800ULL, 0x0000000e0f0e723eULL, 0x010fe400000010ffULL,
0x000000ffff2b7224ULL, 0x000fca00078e0024ULL, 0x0000001d001d7308ULL, 0x000ff00000000800ULL,
0x0000002f00307308ULL, 0x000ea20000000800ULL, 0x0000001e170d723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b141e7823ULL, 0x000fcc000001082eULL, 0x0000002500117308ULL, 0x0003e20000000800ULL,
0x0000001d300f723eULL, 0x004fe200000010ffULL, 0x000000ffff257224ULL, 0x002fe200078e0024ULL,
0x3fb8aa3b151d7823ULL, 0x000fca000001082eULL, 0x0000001000107308ULL, 0x000e620000000800ULL,
0x000000240c14723cULL, 0x000b6e00000418ffULL, 0x0000002600337308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b12257823ULL, 0x020fce000001082eULL, 0x0000003200327308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b29267823ULL, 0x104fe2000001080bULL, 0x3fb8aa3b13297823ULL, 0x000fe2000001082eULL,
0x000000101110723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1c0b7823ULL, 0x000fc8000001080bULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000e620000000800ULL,
0x000000333212723eULL, 0x008fe200000010ffULL, 0x000000ffff327224ULL, 0x000fc400078e0024ULL,
0x000000ffff337224ULL, 0x000fc800078e0024ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000003100347308ULL, 0x000ea20000000800ULL, 0x000000201f11723eULL, 0x002fce00000010ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000213413723eULL, 0x004fce00000010ffULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x00000002ff217819ULL, 0x000fc8000001166eULL,
0x00000001211c7810ULL, 0x040fe20007ffe0ffULL, 0x000000321014723cULL, 0x000b620000041814ULL,
0x00000008211f7824ULL, 0x040fe200078e00ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000000821347824ULL, 0x040fe400078e00ffULL, 0x0000000821387824ULL, 0x000fe200078e00ffULL,
0xfffffff81f2e7812ULL, 0x000fe200078ee21cULL, 0x0000000821327824ULL, 0x060fe400078e00ffULL,
0x00000008213a7824ULL, 0x000fe200078e00ffULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x0000002a271c723eULL, 0x002fe200000010ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0024ULL,
0x0000000421277810ULL, 0x000fc80007ffe0ffULL, 0xfffffff834347812ULL, 0x000fe200078ee227ULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0xffffffff21277810ULL, 0x000fc80007ffe0ffULL,
0xfffffff83a3a7812ULL, 0x000fc600078ee227ULL, 0x0000001e00307308ULL, 0x0004700000000800ULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x000000282d1e723eULL, 0x004fe200000010ffULL,
0x0000000821287824ULL, 0x000fca00078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee221ULL,
0x0000002900207308ULL, 0x0004e20000000800ULL, 0x0000001d301d723eULL, 0x002fce00000010ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x0000000821297824ULL, 0x004fe200078e00ffULL,
0x00000025201f723eULL, 0x008fcc00000010ffULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0x0000000221207810ULL, 0x040fe40007ffe0ffULL, 0x0000000321257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff829307812ULL, 0x000fe200078ee220ULL, 0x0000002a1c14723cULL, 0x000b620000041814ULL,
0x0000000821297810ULL, 0x040fe20007ffe0ffULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x0000000521207810ULL, 0x000fe40007ffe0ffULL, 0xfffffff832327812ULL, 0x000fe200078ee225ULL,
0x00000008293c7824ULL, 0x000fe200078e00ffULL, 0x0000000621257810ULL, 0x040fe20007ffe0ffULL,
0x00000008212b7824ULL, 0x020fe200078e00ffULL, 0x0000000c1b2a7812ULL, 0x000fe200078ec0ffULL,
0x0000001800187308ULL, 0x000ea20000000800ULL, 0x000000220b22723eULL, 0x002fc400000010ffULL,
0x00009000000b7811ULL, 0x000fe400078e58ffULL, 0xfffffff82b367812ULL, 0x000fe400078ee220ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee229ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x0000002400297202ULL, 0x000fe20000000f00ULL, 0x00000010341b7824ULL, 0x000fe200078e020bULL,
0xfffffff838387812ULL, 0x000fc600078ee225ULL, 0x000000012a1b7824ULL, 0x000fe400078e021bULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000071821723eULL, 0x004fe200000010ffULL,
0x0000001028077824ULL, 0x100fe400078e020bULL, 0x000000ffff287224ULL, 0x000fe400078e0024ULL,
0x000000102e187824ULL, 0x000fe400078e020bULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000012a077824ULL, 0x000fc400078e0207ULL, 0x0000001036247824ULL, 0x100fe400078e020bULL,
0x000000012a187824ULL, 0x000fe200078e0218ULL, 0x0000000c07007388ULL, 0x0005e20000000800ULL,
0x0000001038257824ULL, 0x100fe200078e020bULL, 0x0000001a001a7308ULL, 0x000ee20000000800ULL,
0x000000232620723eULL, 0x002fe200000010ffULL, 0x000000103a267824ULL, 0x000fe200078e020bULL,
0x0000000e18007388ULL, 0x0005e20000000800ULL, 0x000000012a247824ULL, 0x040fe400078e0224ULL,
0x000000012a257824ULL, 0x000fc400078e0225ULL, 0x000000012a267824ULL, 0x000fe200078e0226ULL,
0x000000191a23723eULL, 0x008fe200000010ffULL, 0x0000001030197824ULL, 0x100fe400078e020bULL,
0x00000010321a7824ULL, 0x000fe400078e020bULL, 0x000000012a197824ULL, 0x040fe400078e0219ULL,
0x000000282014723cULL, 0x000b620000041814ULL, 0x000000012a1a7824ULL, 0x000fe400078e021aULL,
0x000000103c0b7824ULL, 0x000fe200078e020bULL, 0x0000001019007388ULL, 0x0005e60000000800ULL,
0x000000012a287824ULL, 0x020fe200078e020bULL, 0x000000121a007388ULL, 0x0005e20000000800ULL,
0x00000002030b7208ULL, 0x000fc60004800000ULL, 0x0000001c1b007388ULL, 0x0005e80000000800ULL,
0x0000001e24007388ULL, 0x0005e80000000800ULL, 0x0000002025007388ULL, 0x0005e80000000800ULL,
0x0000002226007388ULL, 0x0005e20000000800ULL, 0x000000ffff157224ULL, 0x000fc600078e0016ULL,
0x0000000d28007388ULL, 0x0005e80000000800ULL, 0x0004000f18007388ULL, 0x0005e80000000800ULL,
0x0004001119007388ULL, 0x0005e80000000800ULL, 0x000400131a007388ULL, 0x0005e80000000800ULL,
0x0004001d1b007388ULL, 0x0005e80000000800ULL, 0x0004001f24007388ULL, 0x0005e80000000800ULL,
0x0004002125007388ULL, 0x0005e80000000800ULL, 0x0004002326007388ULL, 0x0005e80000000800ULL,
0x0130000805008388ULL, 0x0005e80000000c00ULL, 0x0132001405008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080075ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100075ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180075ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000672c00720cULL, 0x000fe20003f06070ULL,
0x0136200075ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff027224ULL, 0x000fd600078e002cULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9b6000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff097807ULL, 0x002fe40004000000ULL,
0x00013a80000e7802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x018fea0003c00000ULL,
0xfffef2e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x00013ac0000e7802ULL, 0x000fc40000000f00ULL, 0x00000b7000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xfffef35000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00013b10000f7802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x018fea0003c00000ULL, 0xfffef43000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00013b50000f7802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x01afea0003c00000ULL, 0xfffef55000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00013ba0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e000dULL, 0x00000a4000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xfffef6f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00013bf0000f7802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xfffef6d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe40004000000ULL,
0x00013c40000e7802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x002fea0003c00000ULL,
0xffff0d7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x00013c80000e7802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff327224ULL, 0x000fe200078e0009ULL, 0xffff0db000007947ULL, 0x000fea000383ffffULL,
0x00000034000e7202ULL, 0x000fe40000000f00ULL, 0x00013cd0000f7802ULL, 0x000fc40000000f00ULL,
0x0000091000007944ULL, 0x000fea0003c00000ULL, 0xffff0ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0034ULL, 0x00013d10000f7802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x002fea0003c00000ULL, 0xffff0fc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00013d60000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e0031ULL, 0x0000088000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xffff117000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00013db0000f7802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff115000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x00afe40004000000ULL,
0x00013e00000e7802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x010fea0003c00000ULL,
0xffff25a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x00013e40000e7802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0xffff25e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x00013e90000f7802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x010fea0003c00000ULL, 0xffff26d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x00013ed0000f7802ULL, 0x000fc40000000f00ULL,
0x0000071000007944ULL, 0x012fea0003c00000ULL, 0xffff27f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00013f20000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e000dULL, 0x000006c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xffff29a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00013f70000f7802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff298000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe40004000000ULL,
0x00013fc0000e7802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x032fea0003c00000ULL,
0xffff3de000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x00014000000e7802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0xffff3e3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x00014050000f7802ULL, 0x000fc40000000f00ULL,
0x0000059000007944ULL, 0x030fea0003c00000ULL, 0xffff3f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x00014090000f7802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x032fea0003c00000ULL, 0xffff404000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x000140e0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e000dULL, 0x0000050000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xffff41f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00014130000f7802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x036fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff41d000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00014180000c7802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0003ULL, 0xffffeb2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x008fe200078e0010ULL, 0x000141e0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x004fea0003c00000ULL,
0x000000031000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00014240000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001003107208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000030a00720bULL, 0x004fe20003f1e000ULL, 0x00000002ff0f7424ULL, 0x002fe200078e00ffULL,
0x0000000b000e7202ULL, 0x000fc40000000f00ULL, 0x0000000a030a7208ULL, 0x000fe40004000000ULL,
0x000142a0000c7802ULL, 0x000fc40000000f00ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000030b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0034ULL,
0x00014300000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b03027208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000033400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00014360000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003403087208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000031000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x000143c0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001003097208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000030a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0002ULL,
0x00014420000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a030a7208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe9f000007947ULL, 0x000fea000383ffffULL, 0x0180000007037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000700038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000306ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffeba6004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000f0e037389ULL, 0x0002a200000e0011ULL, 0xfffeba200c007950ULL, 0x000fea0003c3ffffULL,
0x0000007600007348ULL, 0x000fe80003800000ULL, 0x000000090e097389ULL, 0x0002a400000e0077ULL,
0x000000ffff0e7224ULL, 0x002fc400078e000fULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffeb9d00e007950ULL, 0x000fea0003c3ffffULL, 0x000000010900780cULL, 0x000fe20003f25070ULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000007500007348ULL, 0x000ff60003800000ULL,
0x0000000000097806ULL, 0x000fc800048e0100ULL, 0x0000007509097212ULL, 0x000fe200078ec0ffULL,
0xfffeb9700e007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000002ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000512ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000670ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c8ULL,
0x0000000000000348ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c10ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cd0ULL,
0x00000000000005ccULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012a0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012b0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001340ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001344ULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000014780ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015d00ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015d40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000160c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001340ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000149c0ULL,
0x00000000000149c0ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015d00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000160c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_89_cubin_len = 90528;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
