/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017640ULL, 0x00000000000172c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x4c6a496365563349ULL, 0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL,
0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL,
0x70776f6c735f3233ULL, 0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL,
0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL,
0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL,
0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL,
0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL,
0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL,
0x612e6c65722e766eULL, 0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000208ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000002e3ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000331ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b0022000003bdULL, 0x0000000000015a30ULL, 0x0000000000000190ULL,
0x000b0022000003f0ULL, 0x0000000000015bc0ULL, 0x0000000000000040ULL, 0x000b00220000041bULL,
0x0000000000015c00ULL, 0x0000000000000050ULL, 0x000b002200000445ULL, 0x0000000000015c50ULL,
0x0000000000000130ULL, 0x000a0003000004b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000004d3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000503ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000015d80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00015a3000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x0055080400288080ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8708288080840828ULL, 0x2880808c08288080ULL, 0x808f082880808e08ULL,
0x0828808096082880ULL, 0x80808b08288080a6ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808b92ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00015a3000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8086288080840900ULL, 0x0900000004042880ULL,
0x288080842880808bULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8708288080840828ULL,
0x2880808b08288080ULL, 0x808f082880808e08ULL, 0x0828808090082880ULL, 0x8080a60828808096ULL,
0x80162880808c0828ULL, 0x0000000310288082ULL, 0x808c920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000012000000000ULL, 0x00015bc000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8708288080840828ULL,
0x2880808b08288080ULL, 0x8096082880808e08ULL, 0x08288080a6082880ULL, 0x808280162880808fULL,
0x0000000000031028ULL, 0x2880808f92000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000001c000000000ULL, 0x00015c0000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x808e2880808f0900ULL, 0x0000000000002880ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8708288080840828ULL, 0x2880808b08288080ULL, 0x8096082880808f08ULL, 0x08288080a6082880ULL,
0x808280162880808eULL, 0x0000000000031028ULL, 0x2880808e92000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000026800000000ULL, 0x00015c5000000000ULL, 0x0000013000000000ULL,
0x0000000000000000ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0068016000000015ULL,
0x000c170400681903ULL, 0x0060000a00000000ULL, 0x000c17040021f000ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL,
0x000c17040081f000ULL, 0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x00000b2000043104ULL,
0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000033001542804ULL,
0x000005a0000003a0ULL, 0x00002d5000001c20ULL, 0x00002f1000002df0ULL, 0x0000327000003070ULL,
0x00003310000032a0ULL, 0x00003a7000003380ULL, 0x00004a50000049c0ULL, 0x00004ce000004b80ULL,
0x00004f2000004ef0ULL, 0x0000500000004f90ULL, 0x000063f0000053e0ULL, 0x000065b000006480ULL,
0x0000692000006710ULL, 0x000069c000006950ULL, 0x00006e4000006a30ULL, 0x00007ed000007e30ULL,
0x0000816000008000ULL, 0x000083a000008370ULL, 0x0000848000008410ULL, 0x000089f0000089e0ULL,
0x0000ae600000adf0ULL, 0x0000b5c00000b580ULL, 0x00013f8000013f40ULL, 0x00013fa000013f90ULL,
0x0001401000013ff0ULL, 0x0001404000014030ULL, 0x00014d5000014d00ULL, 0x00014e2000014dc0ULL,
0x00014f0000014e90ULL, 0x00014fb000014f60ULL, 0x0001508000015020ULL, 0x00015160000150f0ULL,
0x00015210000151c0ULL, 0x000152e000015280ULL, 0x000153c000015350ULL, 0x0001547000015420ULL,
0x00015540000154e0ULL, 0x00015620000155b0ULL, 0x0001570000015690ULL, 0x0001580000015780ULL,
0x0001590000015880ULL, 0x00015a0000015980ULL, 0x0000044002003904ULL, 0x0001b600000000ffULL,
0x00000480003f0100ULL, 0x0001b6080000000fULL, 0x00000540003f0120ULL, 0x0001b6880000000fULL,
0x00000b40003f0120ULL, 0x0001b600000000ffULL, 0x00000d40003f0107ULL, 0x0001b68c0000006eULL,
0x00000df0003f0102ULL, 0x0001b6880000006eULL, 0x00002a60003f0101ULL, 0x0001b6080000000aULL,
0x00002a80003f0101ULL, 0x0001b60c0000000aULL, 0x00002c50003f0105ULL, 0x0001b60c0000000aULL,
0x000039f0003f0105ULL, 0x0001b6880000004eULL, 0x00004720003f0101ULL, 0x0001b62800000034ULL,
0x00004740003f0101ULL, 0x0001b62c00000034ULL, 0x00004910003f0105ULL, 0x0001b62c00000034ULL,
0x00005390003f0105ULL, 0x000000000000000eULL, 0x00006150003f0101ULL, 0x0001b64800000009ULL,
0x00006170003f0101ULL, 0x0001b64c00000009ULL, 0x00006340003f0105ULL, 0x0001b64c00000009ULL,
0x00006e20003f0105ULL, 0x000000000000000cULL, 0x00007b90003f0101ULL, 0x0001b6680000001eULL,
0x00007bb0003f0101ULL, 0x0001b66c0000001eULL, 0x00007d80003f0105ULL, 0x0001b66c0000001eULL,
0x00008870003f0105ULL, 0x0000000000000008ULL, 0x0000c790003f0101ULL, 0x0001b600000000ffULL,
0x0000dff0003f0101ULL, 0x0001b604000000ffULL, 0x0000e200003f0105ULL, 0x0001b604000000ffULL,
0x000122e0003f0105ULL, 0x0000000000000073ULL, 0x000123d0003f0101ULL, 0x0000000400000073ULL,
0x000125a0003f0105ULL, 0x0000000400000073ULL, 0x00014b50003f0105ULL, 0x0001b60800000074ULL,
0x00014bb0003f0101ULL, 0x0001b61000000074ULL, 0x00014c10003f0101ULL, 0x0001b61800000074ULL,
0x00014c80003f0101ULL, 0x0001b62000000074ULL, 0x00033803003f0101ULL, 0x0000be0000201c04ULL,
0x0000c0c00000be30ULL, 0x0000c4b00000c2b0ULL, 0x0000e2600000c660ULL, 0x0000040100014cc0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000002ecULL, 0x0000001800000002ULL, 0x0000000000000244ULL,
0x0000001800000002ULL, 0x00000000000001acULL, 0x0000001800000002ULL, 0x00000000000000f4ULL,
0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL, 0x00000000000002c3ULL,
0x0000001800000002ULL, 0x000000000000021bULL, 0x0000001800000002ULL, 0x0000000000000185ULL,
0x0000001800000002ULL, 0x00000000000000d0ULL, 0x0000001800000002ULL, 0x000000000001b700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000797919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff0a0424ULL, 0x000fe200078e00ffULL,
0x0000000179020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e000aULL,
0x00005c00790a0625ULL, 0x000fe200078e000aULL, 0x0000000602090981ULL, 0x0002aa000c1e1900ULL,
0x000000060a0a0981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff777624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000727919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff117624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x008ee40000002300ULL,
0x0000590011117a24ULL, 0x000fe200078e02ffULL, 0x0000000000007308ULL, 0x010f240000001000ULL,
0x0ffffffe00047810ULL, 0x010fcc0007ffe0ffULL, 0x0000000400057305ULL, 0x000864000021f000ULL,
0x000000ffff047224ULL, 0x010fe400078e00ffULL, 0x000000ffff077224ULL, 0x002fc800078e0a05ULL,
0x0000590007077a24ULL, 0x000fc800078e02ffULL, 0x0000000705057227ULL, 0x000fcc00078e0004ULL,
0x00000400050d7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a0dULL,
0x0000040002007624ULL, 0x000fca00078e0277ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0dba12ULL, 0x000fc800078e33ffULL, 0x0000000d00007306ULL, 0x000e620000209000ULL,
0x000000ff0d00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000030d047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000007203717227ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000e640000002100ULL, 0x000000ffff007224ULL, 0x000fc800078e0a71ULL,
0x000000000d007224ULL, 0x000fca00078e0272ULL, 0x0000000d0000720cULL, 0x040fe20003f66070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000ff400000e0000ULL,
0x0000000100003824ULL, 0x000fe200078e0a0dULL, 0x0000000171713810ULL, 0x000fe20007ffe0ffULL,
0x00000000020f7a24ULL, 0x102fe200078e0203ULL, 0x00000005ff027819ULL, 0x000fc40000011603ULL,
0x0000000d0000720cULL, 0x000fe40003f86070ULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000000f0f00780cULL, 0x040fe40003f44070ULL,
0x000000030f00780cULL, 0x000fcc0003f64070ULL, 0x0000000171714810ULL, 0x000fe40007ffe0ffULL,
0x0000000dff71d212ULL, 0x000fe200078e33ffULL, 0x7fffff80ff059424ULL, 0x000fe200078e00ffULL,
0x3fffff8000049802ULL, 0x000fe20000000f00ULL, 0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL,
0x0000007f0f00780cULL, 0x000fe20003f84070ULL, 0x000000ffff087224ULL, 0x000fe400078e0a71ULL,
0x01b60004ff009388ULL, 0x0007e20000000a00ULL, 0x7fffffc0ff07a424ULL, 0x000fc400078e00ffULL,
0x000000080d727224ULL, 0x000fe400078e0272ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x01b608060f00a388ULL, 0x000fe20000008a00ULL, 0x0000001072727824ULL, 0x000fc600078e00ffULL,
0xff317217ff0cc424ULL, 0x000fca00078e00ffULL, 0x01b4000c0f00c388ULL, 0x000fe20000004800ULL,
0x0000000109000824ULL, 0x004fe400078e0a0aULL, 0x00005800ff008624ULL, 0x000fe400078e00ffULL,
0x00005800790a8a24ULL, 0x000fe400078e02ffULL, 0x00005a0000037a24ULL, 0x000fe400078e02ffULL,
0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL, 0x000000110a747224ULL, 0x000fe200078e02ffULL,
0x0000000372047210ULL, 0x008fc40007ffe1ffULL, 0x000000720300720cULL, 0x000fe20003f26070ULL,
0x01b688080f00b388ULL, 0x000fe20000008a00ULL, 0x0000001004047817ULL, 0x000fe20003800000ULL,
0x00000004ff037e24ULL, 0x000fe4000f8e00ffULL, 0x00005a0071137a24ULL, 0x000fe200078e0274ULL,
0x000000ff04737207ULL, 0x000fe20000800000ULL, 0x000000040b047824ULL, 0x002fe200078e0202ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107300780cULL, 0x000fe20003f05270ULL,
0x0000000204047824ULL, 0x000fd800078e00ffULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a00000c7b06ULL, 0x000e620000209000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000c000c7308ULL, 0x002e620000001000ULL, 0x00000004ff097819ULL, 0x004fca0000011605ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x0ffffffe0c077810ULL, 0x002fe20007ffe0ffULL,
0x00000010050c7824ULL, 0x000fca00078e00ffULL, 0x0000000700077305ULL, 0x000e64000021f000ULL,
0x000000ffff0d7224ULL, 0x002fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d070d7227ULL, 0x000fc800078e0006ULL, 0x0000000172067824ULL, 0x000fc800078e0208ULL,
0x000000060d0d7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fc800078e0a0dULL,
0x00005a000f077a24ULL, 0x000fca00078e0206ULL, 0x00005a0007007a0cULL, 0x000fda0003f06070ULL,
0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d0810ULL, 0x000fe40007ffe0ffULL,
0x00005a0007007a0cULL, 0x000fda0003f26070ULL, 0x000000010d0d1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0daa12ULL, 0x000fca00078e33ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a0dULL,
0x00005a0007067a24ULL, 0x000fe200078e0206ULL, 0x0000000473077217ULL, 0x000fc80007800000ULL,
0x0000000613067210ULL, 0x000fe20007ffe0ffULL, 0x0000000107047824ULL, 0x000fc800078e0a04ULL,
0x000000110d067224ULL, 0x000fe200078e0206ULL, 0x000000f00c0d7812ULL, 0x000fe400078ec0ffULL,
0x000000040900720cULL, 0x000fe20003f06070ULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000000108047824ULL, 0x000fe200078e0205ULL, 0x0000000d060d7212ULL, 0x000fe200078efcffULL,
0x0000001008097824ULL, 0x000fc600078e00ffULL, 0x000060000d067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff009047812ULL, 0x000fe400078ee204ULL, 0x0000610007077a10ULL, 0x000fc60000ffe4ffULL,
0x0000001004097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a0000087b06ULL, 0x000e620000209000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000800087308ULL, 0x002e620000001000ULL, 0x0000000405047211ULL, 0x004fe400078fe0ffULL,
0x0ffffffe080c7810ULL, 0x002fca0007ffe0ffULL, 0x0000000c00077305ULL, 0x0002a4000021f000ULL,
0x00000010050c7824ULL, 0x002fe400078e00ffULL, 0x000000ffff097224ULL, 0x004fc800078e0a07ULL,
0x00005a0009097a24ULL, 0x000fc800078e02ffULL, 0x0000000907077227ULL, 0x000fc800078e0006ULL,
0x0000000172067824ULL, 0x000fc800078e0204ULL, 0x0000000607077227ULL, 0x000fc800078e00ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a07ULL, 0x00005a0009087a24ULL, 0x000fca00078e0206ULL,
0x00005a0008007a0cULL, 0x000fda0003f06070ULL, 0x80005a0008080a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe20003f26070ULL,
0x0000000104087824ULL, 0x000fd800078e0205ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff07aa12ULL, 0x000fca00078e33ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a07ULL,
0x00005a0009067a24ULL, 0x000fe200078e0206ULL, 0x000000f00c097812ULL, 0x000fc800078ec0ffULL,
0x0000000613067210ULL, 0x000fca0007ffe0ffULL, 0x0000001107067224ULL, 0x000fc800078e0206ULL,
0x0000010006067825ULL, 0x000fca00078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x0000001004097824ULL, 0x000fc600078e00ffULL, 0x0000600006067a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x0000610007077a10ULL, 0x000fc600007fe4ffULL,
0x0000001008097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e4000b901c46ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x0000000000047806ULL, 0x000fe200038e0000ULL, 0x00000004ff547424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400067300ULL, 0x000e7000000e0000ULL,
0x0000000400087309ULL, 0x000ea20000000000ULL, 0x000000070600720cULL, 0x002fe20003f02070ULL,
0x0000680079067625ULL, 0x000fc800078e0054ULL, 0x000000ffff087224ULL, 0x004fd000078e0a08ULL,
0x01b60408ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000606697981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f696d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff695e7810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff6d7819ULL, 0x000fe4000001166dULL,
0x00000008ff5e7819ULL, 0x000fca000001165eULL, 0x0000b9f000008947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011602ULL, 0x00000008026e7824ULL, 0x000fe400078e00ffULL,
0xffffffffff597424ULL, 0x000fe200078e00ffULL, 0x01ffffff00007812ULL, 0x000fca00078ec0ffULL,
0x00000002030b7824ULL, 0x000fca00078e0200ULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x0000000279008824ULL, 0x000fe400078e00ffULL, 0x00006a00ff078624ULL, 0x000fc800078e00ffULL,
0x00006a0000008624ULL, 0x000fe200078e0207ULL, 0x0000000300077802ULL, 0x000fc60000000f00ULL,
0x000000010b558824ULL, 0x000fe200078e0200ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b68c076eff738cULL, 0x0005e20000000000ULL, 0x0000660055548625ULL, 0x000fe200078e0054ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000654598981ULL, 0x000ee2000c1e1900ULL,
0x0000000103077810ULL, 0x004fe20007ffe0ffULL, 0x0000008071687824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011602ULL, 0x01b688006eff7f8cULL, 0x0005e2000c80043fULL,
0x0000005e0700720cULL, 0x000fe20003f06070ULL, 0x00000100ff077424ULL, 0x000fe200078e00ffULL,
0x00000001026b7812ULL, 0x000fe200078ec0ffULL, 0x000000200a6f7824ULL, 0x000fc800078e00ffULL,
0x00000100030d7824ULL, 0x000fe400078e026fULL, 0x0000590059007a24ULL, 0x008fc800078e02ffULL,
0x0000008000067824ULL, 0x000fe200078e00ffULL, 0x0000006068007812ULL, 0x000fc600078ef80dULL,
0x0000640006067625ULL, 0x000fe200078e0007ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff197819ULL, 0x004fe20000011605ULL, 0x000000020a1a7824ULL, 0x000fe200078e026bULL,
0x0000000d69047217ULL, 0x000fe40007800000ULL, 0x0000000419097810ULL, 0x040fe40007ffe0ffULL,
0x0000000819117810ULL, 0x040fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a0dULL,
0x0000000c19177810ULL, 0x000fe20007ffe0ffULL, 0x0000000109087824ULL, 0x102fe200078e0205ULL,
0x00000005110d7210ULL, 0x000fe20007ffe0ffULL, 0x00000008091d7824ULL, 0x000fe200078e00ffULL,
0x0000002004047817ULL, 0x000fe20003800000ULL, 0x0000000811107824ULL, 0x000fe200078e00ffULL,
0x0000001419257810ULL, 0x000fe20007ffe0ffULL, 0x00000001170e7824ULL, 0x000fe200078e0205ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee208ULL, 0x0000000817217824ULL, 0x000fe200078e00ffULL,
0x000000700c087812ULL, 0x000fe200078ec0ffULL, 0x00000001000f7824ULL, 0x000fe200078e0209ULL,
0xfffffff8101f7812ULL, 0x000fe200078ee20dULL, 0x00000001000d7824ULL, 0x000fe200078e0219ULL,
0x000000040900720cULL, 0x080fe20003f86070ULL, 0x000000806b087824ULL, 0x000fe200078e0208ULL,
0xfffffff821217812ULL, 0x000fe200078ee20eULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00000010191b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125137824ULL, 0x040fe200078e0205ULL,
0x0000000325167819ULL, 0x000fe200000006ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0x000000041100720cULL, 0x000fc40003f66070ULL, 0xfffffff816277812ULL, 0x000fe200078ee213ULL,
0x000001000f0e7825ULL, 0x000fe200078e0008ULL, 0x0000000c06127210ULL, 0x040fe40007f1e0ffULL,
0x000000041700720cULL, 0x000fe20003f46070ULL, 0x000000011b107824ULL, 0x040fe200078e0205ULL,
0x0000000e06147210ULL, 0x000fe20007f3e0ffULL, 0x000000081b237824ULL, 0x000fe200078e00ffULL,
0x000130001a1a7811ULL, 0x000fe200078e68ffULL, 0x0000000107137824ULL, 0x000fe200000e060dULL,
0x000000041900720cULL, 0x080fe20003fa6070ULL, 0x0000000107157824ULL, 0x000fe200008e060fULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x00000001000d7824ULL, 0x040fe200078e0211ULL,
0x000000041b00720cULL, 0x000fe20003f26070ULL, 0x00000001000f7824ULL, 0x000fe200078e0217ULL,
0x0000001c192b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000119107824ULL, 0x000fe200078e0205ULL,
0x0000001a1f1f7211ULL, 0x000fe200078e20ffULL, 0x000001000d0c7825ULL, 0x000fc600078e0008ULL,
0x0000000710167812ULL, 0x000fe200078ec0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0008ULL,
0x0000000c060c7210ULL, 0x000fe40007f1e0ffULL, 0x0ffffff816177812ULL, 0x000fe200078ef805ULL,
0x0000000100117824ULL, 0x000fe200078e021bULL, 0x0000000e060e7210ULL, 0x000fe20007fde0ffULL,
0x00000001070d7824ULL, 0x000fe200000e060dULL, 0x000000042500720cULL, 0x000fe20003f06070ULL,
0x0000010011107825ULL, 0x000fe200078e0008ULL, 0x0000002500257210ULL, 0x000fc60007ffe0ffULL,
0x00000001070f7824ULL, 0x000fe200030e060fULL, 0x0000001006167210ULL, 0x000fe20007fde0ffULL,
0x00000010171b7824ULL, 0x100fe400078e021aULL, 0x000000101d1d7824ULL, 0x000fe400078e021aULL,
0x0000000107177824ULL, 0x000fe200030e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0003e2000e901c46ULL, 0x0000010025107825ULL, 0x000fe200078e0008ULL,
0x0000001819257810ULL, 0x000fe40007ffe0ffULL, 0x00000000141d7faeULL, 0x0005e2000e101c46ULL,
0x00000001002d7824ULL, 0x000fe200078e022bULL, 0x0000001006187210ULL, 0x000fe20007fde0ffULL,
0x0000000100297824ULL, 0x000fe200078e0225ULL, 0x000000042500720cULL, 0x0c0fe20003fa6070ULL,
0x0000000125007824ULL, 0x000fe200078e0205ULL, 0x000000042b00720cULL, 0x000fe20003f86070ULL,
0x0000000107197824ULL, 0x000fe200030e0611ULL, 0x000000000c1f7faeULL, 0x0007e2000d901c46ULL,
0x0000010029107825ULL, 0x000fc800078e0008ULL, 0x0000000825137824ULL, 0x002fe200078e00ffULL,
0x0000001006107210ULL, 0x000fe20007fde0ffULL, 0x000000012b047824ULL, 0x040fe400078e0205ULL,
0x000000082b157824ULL, 0x004fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee200ULL,
0x000001002d087825ULL, 0x000fc600078e0008ULL, 0xfffffff815157812ULL, 0x000fe200078ee204ULL,
0x0000000107117824ULL, 0x000fe200030e0611ULL, 0x0000000806067210ULL, 0x000fe20007fde0ffULL,
0x0000001021217824ULL, 0x100fe400078e021aULL, 0x0000001023237824ULL, 0x100fe400078e021aULL,
0x0000001027277824ULL, 0x100fe200078e021aULL, 0x000000000e217faeULL, 0x0007e2000d101c46ULL,
0x0000001013137824ULL, 0x100fe400078e021aULL, 0x0000001015157824ULL, 0x000fe200078e021aULL,
0x0000000016237faeULL, 0x0007e2000c901c46ULL, 0x0000000107077824ULL, 0x000fc600030e0609ULL,
0x0000000018277faeULL, 0x0007e8000c101c46ULL, 0x0000000010137faeULL, 0x0007e8000e901c46ULL,
0x0000000006157faeULL, 0x0007e2000e101c46ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x044fe200078fe8ffULL, 0x000000020a167824ULL, 0x000fe200078e026bULL,
0x0000000405087811ULL, 0x002fc400078fe8ffULL, 0x0000001005107811ULL, 0x000fe200078fe8ffULL,
0x00000001090d7824ULL, 0x100fe200078e0205ULL, 0x0000001405127811ULL, 0x000fe200078fe8ffULL,
0x00000008091c7824ULL, 0x000fe200078e00ffULL, 0x0000000c050e7811ULL, 0x040fe200078fe8ffULL,
0x0000000108047824ULL, 0x040fe200078e0205ULL, 0x0000001805147811ULL, 0x040fe200078fe8ffULL,
0x00000008080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL,
0x00000001100d7824ULL, 0x100fe200078e0205ULL, 0x000000700c187812ULL, 0x000fe200078ec0ffULL,
0x0000000810207824ULL, 0x000fe200078e00ffULL, 0x0000001c050c7811ULL, 0x000fe200078fe8ffULL,
0x0000000812227824ULL, 0x040fe200078e00ffULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee204ULL,
0x00000001120f7824ULL, 0x000fe200078e0205ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x000000080e137824ULL, 0x040fe200078e00ffULL, 0x000000050e047210ULL, 0x000fe20007ffe0ffULL,
0x0000000114117824ULL, 0x000fe200078e0205ULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x0000000814247824ULL, 0x000fe200078e00ffULL, 0xfffffff8131e7812ULL, 0x000fe200078ee204ULL,
0x00000001000d7824ULL, 0x040fe200078e0208ULL, 0x00000009000f7210ULL, 0x000fe20007ffe0ffULL,
0x000000010c087824ULL, 0x000fe200078e0205ULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x000000080c197824ULL, 0x000fe200078e00ffULL, 0x0000000005097211ULL, 0x040fe200078fe8ffULL,
0x0000000100117824ULL, 0x040fe200078e020eULL, 0x0000000505047211ULL, 0x000fe200078fe8ffULL,
0x0000000100137824ULL, 0x000fe200078e0210ULL, 0x0001300016297811ULL, 0x000fe200078e68ffULL,
0x0000000100157824ULL, 0x000fe200078e0212ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x0000000100177824ULL, 0x000fe200078e0214ULL, 0x000000291c1f7211ULL, 0x000fe200078e20ffULL,
0x00000001001b7824ULL, 0x000fe200078e020cULL, 0xfffffff819007812ULL, 0x000fe200078ee208ULL,
0x000000806b187824ULL, 0x000fe200078e0218ULL, 0x0ffffff804047812ULL, 0x000fe200078ef805ULL,
0x000000ffff197224ULL, 0x000fc400078e00ffULL, 0x000000101a1d7824ULL, 0x000fe400078e0229ULL,
0x0000010009087825ULL, 0x000fc800078e0018ULL, 0x000001000d0c7825ULL, 0x000fe200078e0018ULL,
0x0000000806087210ULL, 0x000fc60007f1e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0018ULL,
0x0000000c060c7210ULL, 0x000fc60007f3e0ffULL, 0x0000010011107825ULL, 0x000fe200078e0018ULL,
0x0000000e060e7210ULL, 0x000fc60007f5e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0018ULL,
0x0000001006107210ULL, 0x000fc60007f7e0ffULL, 0x0000010015147825ULL, 0x000fc800078e0018ULL,
0x0000010017167825ULL, 0x000fc800078e0018ULL, 0x000001001b187825ULL, 0x000fc800078e0018ULL,
0x0000000107097824ULL, 0x040fe200000e0609ULL, 0x0000001206127210ULL, 0x000fe20007f1e0ffULL,
0x00000010041b7824ULL, 0x000fe400078e0229ULL, 0x00000001070d7824ULL, 0x040fe200008e060dULL,
0x0000001406147210ULL, 0x040fe20007f3e0ffULL, 0x00000001070f7824ULL, 0x040fe200010e060fULL,
0x0000001606167210ULL, 0x040fe20007f5e0ffULL, 0x0000000107117824ULL, 0x040fe200018e0611ULL,
0x0000001806067210ULL, 0x000fe20007f7e0ffULL, 0x000000101e217824ULL, 0x100fe200078e0229ULL,
0x0000001507157210ULL, 0x040fe20000ffe4ffULL, 0x0000001020237824ULL, 0x000fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000081b7faeULL, 0x0003e2000b901c46ULL,
0x0000000107137824ULL, 0x000fc400000e0613ULL, 0x0000001022257824ULL, 0x100fe200078e0229ULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x0000001024277824ULL, 0x000fe400078e0229ULL,
0x0000000107177824ULL, 0x040fe200010e0617ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001000297824ULL, 0x000fe400078e0229ULL, 0x0000000107077824ULL, 0x000fe200018e0619ULL,
0x0000000010217faeULL, 0x0003e8000b901c46ULL, 0x0000000012237faeULL, 0x0003e8000b901c46ULL,
0x0000000014257faeULL, 0x0003e8000b901c46ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000006297faeULL, 0x0003e4000b901c46ULL, 0x0000005e0300720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff0c7424ULL, 0x00afe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00006d0000000947ULL, 0x000fea0003800000ULL,
0x00000002796c7824ULL, 0x000fe400078e00ffULL, 0x00006a00ff097624ULL, 0x000fc400078e00ffULL,
0xff317217ff0c7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e00ffULL,
0x00006a006c6c7624ULL, 0x000fc400078e0209ULL, 0x0000001002087824ULL, 0x000fe200078e00ffULL,
0x0000000103097810ULL, 0x000fe20007ffe0ffULL, 0x0000590059597a24ULL, 0x010fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe008087812ULL, 0x000fe400078ec0ffULL,
0x0000005e0900720cULL, 0x000fe40003f06070ULL, 0x0000010000097802ULL, 0x000fe20000000f00ULL,
0x0000010003087824ULL, 0x000fca00078e0208ULL, 0x0000004008247810ULL, 0x020fe20007ffe0ffULL,
0x0000008059087824ULL, 0x000fc600078e00ffULL, 0x00000060240d7812ULL, 0x000fe200078ec0ffULL,
0x0000640008087625ULL, 0x000fc800078e0009ULL, 0x0000000168307824ULL, 0x000fe200078e020dULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x00000010050f7824ULL, 0x000fe200078e00ffULL,
0x00000024690d7217ULL, 0x000fe20007800000ULL, 0x00000080020e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fe40000011605ULL, 0x000000700f257812ULL, 0x000fe200078ec0ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0a24ULL, 0x0000000438287810ULL, 0x000fe20007ffe0ffULL,
0x00002000020d7824ULL, 0x000fe200078e00ffULL, 0x0000000838367810ULL, 0x000fc40007ffe0ffULL,
0x00000080250e7812ULL, 0x000fe200078ef80eULL, 0x0000000128247824ULL, 0x100fe200078e0205ULL,
0x0000000c383a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000828397824ULL, 0x000fe200078e00ffULL,
0x000020000d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000136257824ULL, 0x140fe200078e0205ULL,
0x000000200f337817ULL, 0x000fe20003800000ULL, 0x0000000836267824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee224ULL, 0x000000013a317824ULL, 0x000fe200078e0205ULL,
0x0000000d0a347211ULL, 0x000fe200078e70ffULL, 0x000000083a247824ULL, 0x000fe200078e00ffULL,
0xfffffff8260d7812ULL, 0x000fe200078ee225ULL, 0x0000000138257824ULL, 0x040fe200078e0230ULL,
0x00000010383c7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x00000014383e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000138267824ULL, 0x000fe200078e0205ULL,
0xfffffff824317812ULL, 0x000fe200078ee231ULL, 0x0000010025247825ULL, 0x000fe200078e000eULL,
0x000000333a00720cULL, 0x000fc40003f26070ULL, 0x000000332800720cULL, 0x080fe20003f66070ULL,
0x000000013c327824ULL, 0x100fe200078e0205ULL, 0x00000024082a7210ULL, 0x000fe20007f5e0ffULL,
0x000000083c277824ULL, 0x000fe200078e00ffULL, 0x000000333600720cULL, 0x080fe20003f06070ULL,
0x000000013e0a7824ULL, 0x000fe200078e0205ULL, 0x000000333800720cULL, 0x000fe20003f86070ULL,
0x000000083e297824ULL, 0x000fe200078e00ffULL, 0xfffffff827327812ULL, 0x000fe200078ee232ULL,
0x0000000128277824ULL, 0x100fe400078e0230ULL, 0x000000013a357824ULL, 0x000fe200078e0230ULL,
0xfffffff8290a7812ULL, 0x000fe200078ee20aULL, 0x00000001092b7824ULL, 0x000fe200010e0625ULL,
0x0000003036297210ULL, 0x000fe20007ffe0ffULL, 0x0000010027247825ULL, 0x000fe200078e000eULL,
0x00000007263a7812ULL, 0x000fc400078ec0ffULL, 0x0001400034367810ULL, 0x000fe20007ffe0ffULL,
0x0000010029267825ULL, 0x000fe200078e000eULL, 0x0000002408347210ULL, 0x000fe40007f5e0ffULL,
0x0ffffff83a377812ULL, 0x000fe200078ef805ULL, 0x0000010035287825ULL, 0x000fe200078e000eULL,
0x0000002608247210ULL, 0x000fe40007fbe0ffULL, 0x00000018383a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109357824ULL, 0x040fe200010e0625ULL, 0x0000002808267210ULL, 0x000fe20007fde0ffULL,
0x0000000109257824ULL, 0x000fe200028e0627ULL, 0x0000001c38387810ULL, 0x000fe20007ffe0ffULL,
0x0000001037377824ULL, 0x000fe200078e0236ULL, 0x000000333c00720cULL, 0x080fe20003f46070ULL,
0x0000000109277824ULL, 0x000fe200030e0629ULL, 0x000000333e00720cULL, 0x080fe20003fa6070ULL,
0x000000013c297824ULL, 0x000fe200078e0230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a377faeULL, 0x0003e2000e101c46ULL, 0x0000001039397824ULL, 0x000fe200078e0236ULL,
0x000000333a00720cULL, 0x000fe20003f86070ULL, 0x0000010029287825ULL, 0x000fc600078e000eULL,
0x0000000034397faeULL, 0x0005e2000d901c46ULL, 0x000000013e3b7824ULL, 0x000fe200078e0230ULL,
0x0000002808287210ULL, 0x000fe20007fde0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0236ULL,
0x000000333800720cULL, 0x000fe20003f66070ULL, 0x000000013a337824ULL, 0x000fe200078e0230ULL,
0x0000002909297210ULL, 0x000fe200037fe4ffULL, 0x000001003b2a7825ULL, 0x002fe200078e000eULL,
0x00000000240d7faeULL, 0x0003e6000c101c46ULL, 0x0000000138377824ULL, 0x000fe200078e0230ULL,
0x0000002a082a7210ULL, 0x000fe20007fde0ffULL, 0x0000010033347825ULL, 0x004fc800078e000eULL,
0x00000001092b7824ULL, 0x000fe200030e062bULL, 0x0000003408347210ULL, 0x000fe20007fde0ffULL,
0x000000013a307824ULL, 0x140fe400078e0205ULL, 0x000000083a397824ULL, 0x000fe400078e00ffULL,
0x0000000138337824ULL, 0x040fe400078e0205ULL, 0x0000000838387824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee230ULL, 0x00000100370e7825ULL, 0x000fe200078e000eULL,
0x000000360a377211ULL, 0x000fc400078e20ffULL, 0xfffffff8383b7812ULL, 0x000fe200078ee233ULL,
0x0000000109357824ULL, 0x000fe200030e0635ULL, 0x0000000e08087210ULL, 0x000fe20007fde0ffULL,
0x0000001031317824ULL, 0x100fe400078e0236ULL, 0x0000001032337824ULL, 0x100fe400078e0236ULL,
0x0000001039397824ULL, 0x100fe200078e0236ULL, 0x0000000026317faeULL, 0x0003e2000c901c46ULL,
0x000000103b3b7824ULL, 0x000fe400078e0236ULL, 0x0000000109097824ULL, 0x000fe200030e060fULL,
0x0000000028337faeULL, 0x0003e8000d101c46ULL, 0x000000002a377faeULL, 0x0003e8000e901c46ULL,
0x0000000034397faeULL, 0x0003e8000e101c46ULL, 0x00000000083b7faeULL, 0x0003e2000d901c46ULL,
0x000005b000007947ULL, 0x000fea0003800000ULL, 0x00002000020e7824ULL, 0x040fe200078e00ffULL,
0x0000000405257811ULL, 0x040fe200078fe8ffULL, 0x00000010050d7824ULL, 0x040fe200078e00ffULL,
0x0000000805277811ULL, 0x000fe200078fe8ffULL, 0x0000008002347824ULL, 0x000fe200078e00ffULL,
0x000020000e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000008252b7824ULL, 0x000fe200078e00ffULL,
0x000000700d0d7812ULL, 0x000fc400078ec0ffULL, 0x0000000327387819ULL, 0x000fe200000006ffULL,
0x000040000a0e7824ULL, 0x000fe200078e020fULL, 0x000000800d347812ULL, 0x000fe200078ef834ULL,
0x00000001250a7824ULL, 0x100fe200078e0205ULL, 0x0000001405317811ULL, 0x000fe200078fe8ffULL,
0x00000001270d7824ULL, 0x000fe200078e0205ULL, 0x0000000c05297811ULL, 0x000fe200078fe8ffULL,
0x0000000125257824ULL, 0x000fe200078e0230ULL, 0xfffffff82b367812ULL, 0x000fe200078ee20aULL,
0x00000008313e7824ULL, 0x040fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x00000001310d7824ULL, 0x100fe200078e0205ULL, 0x00000010052b7811ULL, 0x000fe200078fe8ffULL,
0x00000001290f7824ULL, 0x000fe200078e0205ULL, 0x0000001805337811ULL, 0x000fe200078fe8ffULL,
0x00000008293a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x000000012b0a7824ULL, 0x000fe200078e0205ULL, 0x0000001c050d7811ULL, 0x000fe200078fe8ffULL,
0x000000082b357824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL,
0x00000001330f7824ULL, 0x100fe200078e0205ULL, 0x0000003029297210ULL, 0x080fe20007ffe0ffULL,
0x0000000833407824ULL, 0x000fe200078e00ffULL, 0xfffffff8353c7812ULL, 0x000fe200078ee20aULL,
0x000000010d247824ULL, 0x000fe200078e0205ULL, 0x00000005050a7211ULL, 0x000fe200078fe8ffULL,
0x000000080d357824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee20fULL,
0x0000000127277824ULL, 0x100fe200078e0230ULL, 0x00000030050f7211ULL, 0x000fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x000fe200078e0230ULL, 0xfffffff835427812ULL, 0x000fe200078ee224ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000140000e437810ULL, 0x000fe20007ffe0ffULL,
0x0000000131317824ULL, 0x000fe200078e0230ULL, 0x000000070a0a7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0034ULL, 0x000000433a3b7211ULL, 0x000fc400078e20ffULL,
0x0ffffff80a0a7812ULL, 0x000fe200078ef805ULL, 0x0000010025247825ULL, 0x000fe200078e0034ULL,
0x0000000e080e7210ULL, 0x000fc60007f1e0ffULL, 0x0000010027267825ULL, 0x000fe200078e0034ULL,
0x0000002408247210ULL, 0x000fc60007f3e0ffULL, 0x0000010029287825ULL, 0x000fe200078e0034ULL,
0x0000002608267210ULL, 0x000fc60007f5e0ffULL, 0x0000000133337824ULL, 0x100fe200078e0230ULL,
0x0000002808287210ULL, 0x000fe20007f7e0ffULL, 0x000000010d0d7824ULL, 0x000fe400078e0230ULL,
0x000001002b2a7825ULL, 0x000fc800078e0034ULL, 0x0000010031307825ULL, 0x000fc800078e0034ULL,
0x0000010033327825ULL, 0x000fc800078e0034ULL, 0x000001000d347825ULL, 0x000fc800078e0034ULL,
0x00000001090f7824ULL, 0x040fe200000e060fULL, 0x0000002a082a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000109257824ULL, 0x040fe200008e0625ULL, 0x0000003008307210ULL, 0x000fe20007f3e0ffULL,
0x000000100a0d7824ULL, 0x000fe400078e0243ULL, 0x0000000109277824ULL, 0x040fe200010e0627ULL,
0x0000003208327210ULL, 0x000fe20007f5e0ffULL, 0x0000001036377824ULL, 0x000fe200078e0243ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e2000b901c46ULL,
0x0000000109297824ULL, 0x040fe200018e0629ULL, 0x0000003408087210ULL, 0x000fe20007f7e0ffULL,
0x0000001038397824ULL, 0x100fe200078e0243ULL, 0x0000003309337210ULL, 0x040fe200017fe4ffULL,
0x000000103c3d7824ULL, 0x000fe200078e0243ULL, 0x0000000024377faeULL, 0x0003e2000b901c46ULL,
0x00000001092b7824ULL, 0x000fc400000e062bULL, 0x000000103e3f7824ULL, 0x000fe200078e0243ULL,
0x0000000026397faeULL, 0x0003e2000b901c46ULL, 0x0000000109317824ULL, 0x040fe400008e0631ULL,
0x0000001040417824ULL, 0x100fe200078e0243ULL, 0x00000000283b7faeULL, 0x0003e2000b901c46ULL,
0x0000001042437824ULL, 0x000fe400078e0243ULL, 0x0000000109097824ULL, 0x000fe200018e0635ULL,
0x000000002a3d7faeULL, 0x0003e8000b901c46ULL, 0x00000000303f7faeULL, 0x0003e8000b901c46ULL,
0x0000000032417faeULL, 0x0003e8000b901c46ULL, 0x0000000008437faeULL, 0x0003e4000b901c46ULL,
0x00000300ff087624ULL, 0x002fe200078e00ffULL, 0x000000010b097812ULL, 0x000fe200078ec0ffULL,
0xffffffffff4c7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000010900780cULL, 0x000fc40003f05070ULL, 0xffffffff08087811ULL, 0x000fc800078e08ffULL,
0x0000000108087807ULL, 0x000fca0004000000ULL, 0x00000001080b7824ULL, 0x000fca00078e020bULL,
0x0000006d0b00720cULL, 0x000fda0003f06070ULL, 0x000000016c088824ULL, 0x000fe400078e020bULL,
0x00000004ff098424ULL, 0x000fc800078e00ffULL, 0x0000660008088625ULL, 0x000fca00078e0009ULL,
0x00000006084c8981ULL, 0x000322000c1e1900ULL, 0xffffffe06e0a7812ULL, 0x040fe400078ec0ffULL,
0x000000106e0d7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fe20007ffe00dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b608000a247f8cULL, 0x0022a4000c80043fULL, 0x0000000000087805ULL, 0x000fc40000015200ULL,
0x01b60c000a0d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00cfe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e080e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e09ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001140fULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60c000a0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010056a7824ULL, 0x000fe200078e00ffULL, 0x00000005025c7819ULL, 0x000fe400000006ffULL,
0x00000001ff707819ULL, 0x000fe40000011605ULL, 0x000000706a6a7812ULL, 0x000fc400078ec0ffULL,
0xffffff805c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fc800078ec0ffULL,
0x0000005c70087210ULL, 0x000fca0007ffe06aULL, 0x01b00000080d7984ULL, 0x000ea80000000800ULL,
0x01b20000080a7984ULL, 0x0022e20000000800ULL, 0x0000000c0d00720bULL, 0x004fe20003f1d000ULL,
0x00011f827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x002fc800000e0100ULL,
0x0000ffff09257812ULL, 0x000fe2000782c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff087224ULL, 0x000fd400078e000cULL,
0x0000043000009947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe40000011602ULL,
0x0000000c0d00720bULL, 0x000fe40003f34000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x00011f327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000247806ULL, 0x000fc400008e0100ULL,
0x0000008002098824ULL, 0x000fe200078e026aULL, 0x0000000c0d087209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910240e7816ULL, 0x000fe200000000ffULL,
0x0000000170098824ULL, 0x000fca00078e0209ULL, 0x01b4000809008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000c08097221ULL, 0x002fe20000010100ULL, 0x000000ff24ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x00000009000c7308ULL, 0x000e640000000800ULL, 0x0000000c07077220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011605ULL,
0x00011e727f007947ULL, 0x000fea000b800000ULL, 0x00001f090c097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe40000410000ULL, 0x0000000911117220ULL, 0x080fe40000410000ULL,
0x0000000914147220ULL, 0x080fe40000410000ULL, 0x0000000915157220ULL, 0x080fe40000410000ULL,
0x0000000918187220ULL, 0x080fe40000410000ULL, 0x0000000919197220ULL, 0x000fc40000410000ULL,
0x0000000950507220ULL, 0x080fe40000410000ULL, 0x0000000951517220ULL, 0x080fe40000410000ULL,
0x0000000954547220ULL, 0x080fe40000410000ULL, 0x0000000955557220ULL, 0x080fe40000410000ULL,
0x000000092c2c7220ULL, 0x080fe40000410000ULL, 0x000000092d2d7220ULL, 0x000fc40000410000ULL,
0x0000000920207220ULL, 0x080fe40000410000ULL, 0x0000000921217220ULL, 0x080fe40000410000ULL,
0x000000091c1c7220ULL, 0x080fe40000410000ULL, 0x000000091d1d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x00011d727f007947ULL, 0x000fea000b800000ULL, 0x00001f090c097589ULL, 0x00046400000e0000ULL,
0x0000000912127220ULL, 0x086fe40000410000ULL, 0x0000000913137220ULL, 0x080fe40000410000ULL,
0x0000000916167220ULL, 0x080fe40000410000ULL, 0x0000000917177220ULL, 0x080fe40000410000ULL,
0x000000091a1a7220ULL, 0x080fe40000410000ULL, 0x000000091b1b7220ULL, 0x000fc40000410000ULL,
0x0000000952527220ULL, 0x080fe40000410000ULL, 0x0000000953537220ULL, 0x080fe40000410000ULL,
0x0000000956567220ULL, 0x080fe40000410000ULL, 0x0000000957577220ULL, 0x080fe40000410000ULL,
0x000000092e2e7220ULL, 0x080fe40000410000ULL, 0x000000092f2f7220ULL, 0x000fc40000410000ULL,
0x0000000922227220ULL, 0x080fe40000410000ULL, 0x0000000923237220ULL, 0x080fe40000410000ULL,
0x000000091e1e7220ULL, 0x080fe40000410000ULL, 0x000000091f1f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff25ff7812ULL, 0x000fda0007806024ULL,
0x800000080d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00000308ULL, 0x000e640000000800ULL, 0x000000000a0a0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000070a077221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000000ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011605ULL, 0x00005410040a7816ULL, 0x000fe20000000004ULL,
0x00011bd27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a047589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x00011c227f007947ULL, 0x000fea000b800000ULL,
0x00001f090a067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x0000000a000e7202ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fe200078e00ffULL,
0x00003320000f7802ULL, 0x000fc40000000f00ULL, 0x000128e000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00003390000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0001287000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002024e7824ULL, 0x040fe200078e00ffULL, 0x00000007050d7812ULL, 0x002fe200078ec0ffULL,
0x0000020002097824ULL, 0x00cfe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000044e0a7812ULL, 0x000fe400078ec0ffULL, 0x000000080d0c7812ULL, 0x000fe400078ef805ULL,
0x0000000a05677211ULL, 0x000fe400078fe0ffULL, 0xfffff800090e7812ULL, 0x000fe200078ec0ffULL,
0x000000080c0a7824ULL, 0x000fc400078e00ffULL, 0x000000010c677824ULL, 0x000fca00078e0267ULL,
0xfffffff80a5d7812ULL, 0x000fe400078ee267ULL, 0x00000008050a7812ULL, 0x000fc600078ec0ffULL,
0x000000105d5d7824ULL, 0x000fc800078e020eULL, 0x00000001ff097819ULL, 0x000fe20000011602ULL,
0x011000005d38783bULL, 0x000e620000000200ULL, 0x00000004ff267819ULL, 0x000fe20000011605ULL,
0x000059004c4c7a24ULL, 0x010fe200078e02ffULL, 0x0000000d0a0f7212ULL, 0x040fe400078efcffULL,
0x000000100a287812ULL, 0x000fe200078efe0dULL, 0x00000002090a7824ULL, 0x000fe200078e026bULL,
0x0000000f26247210ULL, 0x000fe20007ffe0ffULL, 0x000000080f617824ULL, 0x000fe200078e00ffULL,
0x0000002805657211ULL, 0x000fe200078fe0ffULL, 0x00000004090d7824ULL, 0x000fe200078e0226ULL,
0x0000000224607810ULL, 0x040fe20007ffe0ffULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0x00000004245f7810ULL, 0x000fe20007ffe0ffULL, 0x000020000a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee224ULL, 0x000000080f267824ULL, 0x040fe200078e00ffULL,
0x0000000624627810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0f7824ULL, 0x000fe200078e00ffULL,
0x000000020d0d7810ULL, 0x000fe20007ffe00cULL, 0x000000080c247824ULL, 0x000fe200078e00ffULL,
0xfffffff825607812ULL, 0x000fe200078ee260ULL, 0x0000000828307824ULL, 0x000fe200078e00ffULL,
0x000130000a0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8265f7812ULL, 0x000fc400078ee25fULL, 0xfffffff80f627812ULL, 0x000fe200078ee262ULL,
0x0000001060587824ULL, 0x100fe200078e020cULL, 0xfffffff8240d7812ULL, 0x000fe200078ee20dULL,
0x000000105f447824ULL, 0x100fe200078e020cULL, 0x0000000465637810ULL, 0x000fe20007ffe0ffULL,
0x0000001061407824ULL, 0x100fe200078e020cULL, 0x00000003280f7819ULL, 0x000fe200000006ffULL,
0x00000010623c7824ULL, 0x000fe200078e020cULL, 0x000000005858783bULL, 0x000ea20000004200ULL,
0x000000100d4d7824ULL, 0x000fe200078e00ffULL, 0x0000000265647810ULL, 0x040fe20007ffe0ffULL,
0x00000008280d7824ULL, 0x000fe200078e00ffULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x0000000665667810ULL, 0x000fe20007ffe0ffULL, 0x0000000438380231ULL, 0x082fe200003400ffULL,
0x000110000e0e7810ULL, 0x000fe20007ffe04dULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0xfffffff830637812ULL, 0x000fe200078ee263ULL, 0x000000043a3a0231ULL, 0x000fe200003400ffULL,
0xfffffff80f647812ULL, 0x000fe200078ee264ULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0xfffffff82a657812ULL, 0x000fe200078ee265ULL, 0x0000001063307824ULL, 0x000fe200078e020cULL,
0xfffffff80d667812ULL, 0x000fe200078ee266ULL, 0x000000000e24783bULL, 0x000e620000000200ULL,
0x0000001064347824ULL, 0x100fe200078e020cULL, 0x0000000639390231ULL, 0x080fe200003400ffULL,
0x0000001065287824ULL, 0x100fe200078e020cULL, 0x000000003030783bULL, 0x000e620000004200ULL,
0x00000010660c7824ULL, 0x000fe200078e020cULL, 0x000000063b3b0231ULL, 0x000fe200003400ffULL,
0xfffffff84e4e7812ULL, 0x000fe200078ec0ffULL, 0x000000003434783bULL, 0x000fe80000004200ULL,
0x000000002828783bULL, 0x000e680000004200ULL, 0x000000000c0c783bULL, 0x000e620000004200ULL,
0x000000583848723cULL, 0x044ff00000041818ULL, 0x000000443818723cULL, 0x048ff00000041854ULL,
0x00000046382c723cULL, 0x000f62000004182cULL, 0x0000000424240231ULL, 0x002fc400003400ffULL,
0x0000000426260231ULL, 0x000fe400003400ffULL, 0x0000000625250231ULL, 0x080fe400003400ffULL,
0x0000000627270231ULL, 0x000fe200003400ffULL, 0x000000403844723cULL, 0x040f700000041810ULL,
0x0000005a3850723cULL, 0x040f700000041850ULL, 0x000000423840723cULL, 0x040f700000041814ULL,
0x0000003c3820723cULL, 0x040f700000041820ULL, 0x0000003e3838723cULL, 0x000f70000004181cULL,
0x00000032241c723cULL, 0x060f70000004182cULL, 0x00000028242c723cULL, 0x040f700000041844ULL,
0x000000342410723cULL, 0x040f700000041848ULL, 0x000000362414723cULL, 0x040f700000041850ULL,
0x000000302418723cULL, 0x040f700000041818ULL, 0x0000002a2428723cULL, 0x040f700000041840ULL,
0x0000000c2420723cULL, 0x040b6e0000041820ULL, 0x00000009030c7211ULL, 0x020fe200078e18ffULL,
0x0000000e2424723cULL, 0x000b620000041838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001030d7810ULL, 0x000fe20007ffe0ffULL, 0x01b688004eff7f8cULL, 0x0003e2000c80043fULL,
0x000000800c307811ULL, 0x000fe200078e28ffULL, 0x00000100ff317424ULL, 0x000fe200078e00ffULL,
0x0000005e0d00720cULL, 0x000fe20003f06070ULL, 0x000000804c0c7824ULL, 0x000fe200078e00ffULL,
0x00000060300f7812ULL, 0x020fc600078ec0ffULL, 0x000064000c0c7625ULL, 0x000fc800078e0031ULL,
0x00000001683c7824ULL, 0x000fe200078e020fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3f7819ULL, 0x102fe20000011605ULL,
0x00002000020f7824ULL, 0x040fe200078e00ffULL, 0x00000030690e7217ULL, 0x000fe20007800000ULL,
0x0000008002317824ULL, 0x000fe200078e00ffULL, 0x000000043f357810ULL, 0x040fe20007ffe0ffULL,
0x000000013f337824ULL, 0x040fe200078e023cULL, 0x000000083f377810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a30ULL, 0x000020000f307812ULL, 0x000fe200078ec0ffULL,
0x00000001353a7824ULL, 0x100fe200078e0205ULL, 0x0000000c3f3b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008350f7824ULL, 0x000fe200078e00ffULL, 0x0000003009417211ULL, 0x000fe200078e70ffULL,
0x00000001373d7824ULL, 0x040fe200078e0205ULL, 0x000000806a307812ULL, 0x000fe200078ef831ULL,
0x0000000837327824ULL, 0x000fe200078e00ffULL, 0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000000200e427817ULL, 0x000fe20003800000ULL,
0x00000001350f7824ULL, 0x000fe200078e023cULL, 0xfffffff8323d7812ULL, 0x000fe200078ee23dULL,
0x0000010033327825ULL, 0x000fe200078e0030ULL, 0x000000103f437810ULL, 0x000fc40007ffe0ffULL,
0x000000423500720cULL, 0x000fe20003f86070ULL, 0x000000013b407824ULL, 0x000fe200078e0205ULL,
0x000000143f457810ULL, 0x000fe20007ffe0ffULL, 0x000000083b357824ULL, 0x000fe200078e00ffULL,
0x000000320c387210ULL, 0x040fe20007f1e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0030ULL,
0x000000423700720cULL, 0x000fe40003f66070ULL, 0xfffffff835407812ULL, 0x000fe200078ee240ULL,
0x00000001433e7824ULL, 0x140fe200078e0205ULL, 0x0000000e0c327210ULL, 0x000fe20007f3e0ffULL,
0x0000000843397824ULL, 0x000fe200078e00ffULL, 0x0000003c37357210ULL, 0x000fe20007ffe0ffULL,
0x0000000145097824ULL, 0x000fe200078e0205ULL, 0x000000423b00720cULL, 0x080fe20003f46070ULL,
0x0000000845347824ULL, 0x000fe200078e00ffULL, 0xfffffff8393e7812ULL, 0x000fe200078ee23eULL,
0x000000013b377824ULL, 0x000fe200078e023cULL, 0x000000423f00720cULL, 0x080fe20003fa6070ULL,
0x000000010d397824ULL, 0x040fe200000e0633ULL, 0xfffffff834097812ULL, 0x000fe200078ee209ULL,
0x000000010d337824ULL, 0x000fe200008e060fULL, 0x0001300041417810ULL, 0x000fe20007ffe0ffULL,
0x000000013f367824ULL, 0x040fe200078e0205ULL, 0x000000183f497810ULL, 0x000fe20007ffe0ffULL,
0x00000100350e7825ULL, 0x000fe200078e0030ULL, 0x000000424300720cULL, 0x000fc40003f26070ULL,
0x0000000736447812ULL, 0x000fe200078ec0ffULL, 0x0000010037347825ULL, 0x000fe200078e0030ULL,
0x0000000e0c0e7210ULL, 0x000fe40007f1e0ffULL, 0x0ffffff844447812ULL, 0x000fe200078ef805ULL,
0x00000001433b7824ULL, 0x000fe200078e023cULL, 0x000000340c347210ULL, 0x000fe20007fde0ffULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x000000424500720cULL, 0x000fe20003f06070ULL,
0x000001003b367825ULL, 0x000fe200078e0030ULL, 0x0000001c3f4b7810ULL, 0x000fc40007ffe0ffULL,
0x0000003c493f7210ULL, 0x000fe20007ffe0ffULL, 0x00000001453b7824ULL, 0x000fe200078e023cULL,
0x0000004109097211ULL, 0x000fe200078e20ffULL, 0x000000010d357824ULL, 0x000fe200030e0635ULL,
0x000000360c367210ULL, 0x000fe20007fde0ffULL, 0x000000103a457824ULL, 0x100fe400078e0241ULL,
0x0000001044437824ULL, 0x000fe400078e0241ULL, 0x000001003b3a7825ULL, 0x000fc600078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038437faeULL, 0x0003e2000e901c46ULL,
0x000000010d377824ULL, 0x000fe200030e0637ULL, 0x0000003a0c3a7210ULL, 0x000fe20007fde0ffULL,
0x000000014b477824ULL, 0x000fe200078e023cULL, 0x0000000032457faeULL, 0x0005e2000e101c46ULL,
0x000000424900720cULL, 0x0c0fe20003fa6070ULL, 0x00000001493c7824ULL, 0x000fe200078e0205ULL,
0x000000424b00720cULL, 0x000fe20003f86070ULL, 0x000000010d3b7824ULL, 0x000fe400030e063bULL,
0x000000084b427824ULL, 0x000fc400078e00ffULL, 0x000001003f387825ULL, 0x002fc800078e0030ULL,
0x000000014b337824ULL, 0x004fe200078e0205ULL, 0x000000380c327210ULL, 0x000fe20007fde0ffULL,
0x0000000849497824ULL, 0x000fe400078e00ffULL, 0x0000010047307825ULL, 0x000fe200078e0030ULL,
0xfffffff842387812ULL, 0x000fe400078ee233ULL, 0xfffffff8493c7812ULL, 0x000fe200078ee23cULL,
0x000000010d337824ULL, 0x000fe200030e0639ULL, 0x000000300c307210ULL, 0x000fe20007fde0ffULL,
0x000000103d3d7824ULL, 0x000fc400078e0241ULL, 0x0000001040397824ULL, 0x100fe400078e0241ULL,
0x000000103e3f7824ULL, 0x100fe200078e0241ULL, 0x000000000e3d7faeULL, 0x0003e2000d901c46ULL,
0x000000103c437824ULL, 0x100fe400078e0241ULL, 0x0000001038417824ULL, 0x000fe200078e0241ULL,
0x0000000034397faeULL, 0x0003e2000d101c46ULL, 0x000000010d317824ULL, 0x000fc600030e0631ULL,
0x00000000363f7faeULL, 0x0003e8000c901c46ULL, 0x000000003a097faeULL, 0x0003e8000c101c46ULL,
0x0000000032437faeULL, 0x0003e8000e901c46ULL, 0x0000000030417faeULL, 0x0003e2000e101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000c053b7811ULL, 0x042fe200078fe8ffULL,
0x00002000020e7824ULL, 0x000fe200078e00ffULL, 0x00000010050f7811ULL, 0x000fc400078fe8ffULL,
0x00000008053d7811ULL, 0x000fe200078fe8ffULL, 0x000000013b3f7824ULL, 0x100fe200078e0205ULL,
0x000020000e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000010f407824ULL, 0x100fe200078e0205ULL,
0x000000033b327819ULL, 0x000fe200000006ffULL, 0x000000080f357824ULL, 0x000fe200078e00ffULL,
0x0000001805337811ULL, 0x000fe200078fe8ffULL, 0x000000013d3e7824ULL, 0x000fe200078e0205ULL,
0x0000000405397811ULL, 0x000fe200078fe8ffULL, 0x000000083d317824ULL, 0x000fe200078e00ffULL,
0xfffffff8323f7812ULL, 0x000fe200078ee23fULL, 0x0000400009307824ULL, 0x000fe200078e020eULL,
0xfffffff835407812ULL, 0x000fe200078ee240ULL, 0x0000000133327824ULL, 0x100fe200078e0205ULL,
0xfffffff8313e7812ULL, 0x000fe200078ee23eULL, 0x0000000833377824ULL, 0x000fe200078e00ffULL,
0x0000001c05437811ULL, 0x040fe200078fe8ffULL, 0x0000008002357824ULL, 0x000fe200078e00ffULL,
0x0000001405317811ULL, 0x000fe200078fe8ffULL, 0x0000000139097824ULL, 0x000fe200078e0205ULL,
0xfffffff837447812ULL, 0x000fe200078ee232ULL, 0x00000008390e7824ULL, 0x000fe200078e00ffULL,
0x000000806a347812ULL, 0x000fe200078ef835ULL, 0x0000000143327824ULL, 0x000fe200078e0205ULL,
0x0000003c05377211ULL, 0x080fe200078fe8ffULL, 0x0000000843357824ULL, 0x000fe200078e00ffULL,
0xfffffff80e097812ULL, 0x000fe200078ee209ULL, 0x0000000131417824ULL, 0x000fe200078e0205ULL,
0x0000003c0f0f7210ULL, 0x000fe20007ffe0ffULL, 0x00000008310e7824ULL, 0x000fe200078e00ffULL,
0xfffffff835467812ULL, 0x000fe200078ee232ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x00013000304b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000139397824ULL, 0x100fe200078e023cULL,
0xfffffff80e417812ULL, 0x000fe200078ee241ULL, 0x000000013d3d7824ULL, 0x100fe200078e023cULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x000000013b3b7824ULL, 0x000fe200078e023cULL,
0x0000004b40477211ULL, 0x000fe200078e20ffULL, 0x0000010037367825ULL, 0x000fe200078e0034ULL,
0x000000070e0e7812ULL, 0x000fc600078ec0ffULL, 0x0000000131317824ULL, 0x100fe200078e023cULL,
0x0ffffff80e427812ULL, 0x000fe200078ef805ULL, 0x0000000133337824ULL, 0x100fe200078e023cULL,
0x000000360c367210ULL, 0x000fe20007f1e0ffULL, 0x0000000143437824ULL, 0x000fe400078e023cULL,
0x0000010039387825ULL, 0x000fc800078e0034ULL, 0x000001003d3c7825ULL, 0x000fe200078e0034ULL,
0x000000380c387210ULL, 0x000fc60007f3e0ffULL, 0x000001003b3a7825ULL, 0x000fe200078e0034ULL,
0x0000003c0c3c7210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0034ULL,
0x0000003a0c3a7210ULL, 0x000fc60007f7e0ffULL, 0x0000010031307825ULL, 0x000fc800078e0034ULL,
0x0000010033327825ULL, 0x000fc800078e0034ULL, 0x0000010043347825ULL, 0x000fc800078e0034ULL,
0x000000010d377824ULL, 0x040fe200000e0637ULL, 0x0000000e0c0e7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d397824ULL, 0x040fe200008e0639ULL, 0x000000300c307210ULL, 0x000fe20007f3e0ffULL,
0x0000001042437824ULL, 0x000fe400078e024bULL, 0x000000010d3d7824ULL, 0x000fe200010e063dULL,
0x000000320c327210ULL, 0x000fe20007f5e0ffULL, 0x0000001009097824ULL, 0x100fe200078e024bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036437faeULL, 0x0003e2000b901c46ULL,
0x000000103e457824ULL, 0x000fc400078e024bULL, 0x000000010d3b7824ULL, 0x000fe200018e063bULL,
0x000000340c347210ULL, 0x000fe20007f7e0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e024bULL,
0x0000000038097faeULL, 0x0003e2000b901c46ULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x000000350d357210ULL, 0x000fe20001ffe4ffULL, 0x0000001041417824ULL, 0x000fe200078e024bULL,
0x000000003c457faeULL, 0x0003e2000b901c46ULL, 0x000000010d317824ULL, 0x040fe400008e0631ULL,
0x0000001044497824ULL, 0x000fe200078e024bULL, 0x000000003a3f7faeULL, 0x0003e2000b901c46ULL,
0x000000010d337824ULL, 0x000fc400010e0633ULL, 0x00000010464b7824ULL, 0x000fe200078e024bULL,
0x000000000e477faeULL, 0x0003e8000b901c46ULL, 0x0000000030417faeULL, 0x0003e8000b901c46ULL,
0x0000000032497faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe06e097812ULL, 0x002fc400078ec0ffULL,
0x000000106e0e7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0f7812ULL, 0x000fc800078ec0ffULL,
0x000000090f347210ULL, 0x000fe20007ffe00eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6280034307f8cULL, 0x0002a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01b62c0034097984ULL, 0x000ee40000000800ULL, 0x8000000009ff7812ULL, 0x00cfe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x000000320e327210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e0fULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011433ULL,
0x0000003209097211ULL, 0x000fca00078110ffULL, 0x000000ffff327224ULL, 0x000fca00000e0633ULL,
0x0000000209097819ULL, 0x000fc80000001232ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b62c0034097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000806a097810ULL, 0x000fca0007ffe05cULL, 0x0000000170097824ULL, 0x000fca00078e0209ULL,
0x01b0000009317984ULL, 0x000ea80000000800ULL, 0x01b2000009307984ULL, 0x0006620000000800ULL,
0x000000083100720bULL, 0x004fe20003f1d000ULL, 0x000105727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff09337812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000102097811ULL, 0x000fe400078ff0ffULL,
0x000000083100720bULL, 0x000fe40003f34000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x000105327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000327806ULL, 0x000fc400008e0100ULL,
0x00000080020f8824ULL, 0x000fe200078e026aULL, 0x0000000831098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x00009910320e7816ULL, 0x000fe200000000ffULL,
0x0000000170348824ULL, 0x002fca00078e020fULL, 0x01b4000934008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000831097209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff32ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900367308ULL, 0x000e640000000800ULL,
0x0000003607077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011605ULL, 0x000104627f007947ULL, 0x000fea000b800000ULL,
0x00001f0936097589ULL, 0x0002a400000e0000ULL, 0x000000092c2c7220ULL, 0x084fe40000410000ULL,
0x000000092d2d7220ULL, 0x080fe40000410000ULL, 0x0000000928287220ULL, 0x080fe40000410000ULL,
0x0000000929297220ULL, 0x000fc40000410000ULL, 0x0000000910107220ULL, 0x080fe40000410000ULL,
0x0000000911117220ULL, 0x080fe40000410000ULL, 0x0000000914147220ULL, 0x080fe40000410000ULL,
0x0000000915157220ULL, 0x080fe40000410000ULL, 0x0000000918187220ULL, 0x080fe40000410000ULL,
0x0000000919197220ULL, 0x000fc40000410000ULL, 0x000000091c1c7220ULL, 0x080fe40000410000ULL,
0x000000091d1d7220ULL, 0x080fe40000410000ULL, 0x0000000920207220ULL, 0x080fe40000410000ULL,
0x0000000921217220ULL, 0x080fe40000410000ULL, 0x0000000924247220ULL, 0x080fe40000410000ULL,
0x0000000925257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0032ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x000fe200078ff0ffULL, 0x000103627f007947ULL, 0x000fea000b800000ULL,
0x00001f0936097589ULL, 0x0004e400000e0000ULL, 0x000000092e2e7220ULL, 0x08cfe40000410000ULL,
0x000000092f2f7220ULL, 0x080fe40000410000ULL, 0x000000092a2a7220ULL, 0x080fe40000410000ULL,
0x000000092b2b7220ULL, 0x080fe40000410000ULL, 0x0000000912127220ULL, 0x080fe40000410000ULL,
0x0000000913137220ULL, 0x000fc40000410000ULL, 0x0000000916167220ULL, 0x080fe40000410000ULL,
0x0000000917177220ULL, 0x080fe40000410000ULL, 0x000000091a1a7220ULL, 0x080fe40000410000ULL,
0x000000091b1b7220ULL, 0x080fe40000410000ULL, 0x000000091e1e7220ULL, 0x080fe40000410000ULL,
0x000000091f1f7220ULL, 0x000fc40000410000ULL, 0x0000000922227220ULL, 0x080fe40000410000ULL,
0x0000000923237220ULL, 0x080fe40000410000ULL, 0x0000000926267220ULL, 0x080fe40000410000ULL,
0x0000000927277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fe40007806032ULL, 0x0000000831087209ULL, 0x000fd60007810000ULL,
0x8000000831310221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100000308ULL, 0x000e640000000800ULL, 0x0000000030300220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000730077221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000000ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff317819ULL, 0x000fe40000011605ULL, 0x0000541004307816ULL, 0x000fe20000000004ULL,
0x000101b27f007947ULL, 0x000fea000b800000ULL, 0x00001f3130047589ULL, 0x0002a400000e0000ULL,
0x0000000831097810ULL, 0x000fe20007ffe0ffULL, 0x000102027f007947ULL, 0x000fea000b800000ULL,
0x00001f0930067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001031097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00004fa0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00010c6000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001831097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00005010000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00010bf000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000140000a0a7810ULL, 0x000fe20007ffe0ffULL,
0x011800005d44783bULL, 0x000f220000000200ULL, 0x00000002ff097819ULL, 0x00cfe40000011602ULL,
0x0000000a5f587211ULL, 0x000fe200078e20ffULL, 0x0000001061547824ULL, 0x100fe200078e020aULL,
0x0001b690090e7811ULL, 0x000fe200078e18ffULL, 0x0000001060507824ULL, 0x000fc400078e020aULL,
0x0000001062487824ULL, 0x100fe200078e020aULL, 0x000000005858783bULL, 0x000fe20000004200ULL,
0x0000080009307824ULL, 0x002fe400078e024dULL, 0x0000001065407824ULL, 0x100fe200078e020aULL,
0x000000005454783bULL, 0x000e620000004200ULL, 0x00000010643c7824ULL, 0x100fe400078e020aULL,
0x0000001063387824ULL, 0x100fe200078e020aULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000001066347824ULL, 0x000fe200078e020aULL, 0x00000001ff0a7819ULL, 0x000fc40000011602ULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x011800003030783bULL, 0x000ea80000000200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000003c3c783bULL, 0x000ee80000004200ULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x0000000444440231ULL, 0x010fc600003400ffULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x0000000446460231ULL, 0x000fe400003400ffULL,
0x0000000645450231ULL, 0x080fe400003400ffULL, 0x0000000647470231ULL, 0x000fce00003400ffULL,
0x00000054442c723cULL, 0x042f70000004182cULL, 0x000000564428723cULL, 0x000f620000041828ULL,
0x0000000430300231ULL, 0x084fe400003400ffULL, 0x0000000432320231ULL, 0x000fca00003400ffULL,
0x00000050444c723cULL, 0x000f620000041810ULL, 0x0000000631310231ULL, 0x080fe400003400ffULL,
0x0000000633330231ULL, 0x000fca00003400ffULL, 0x000000524450723cULL, 0x040f700000041814ULL,
0x000000584454723cULL, 0x040f700000041818ULL, 0x0000005a441c723cULL, 0x040f70000004181cULL,
0x000000484420723cULL, 0x040f700000041820ULL, 0x0000004a4424723cULL, 0x000f700000041824ULL,
0x000000403010723cULL, 0x068f70000004182cULL, 0x000000423014723cULL, 0x040f700000041828ULL,
0x0000003c3018723cULL, 0x040f70000004184cULL, 0x0000003e3050723cULL, 0x040f700000041850ULL,
0x000000383054723cULL, 0x040f700000041854ULL, 0x0000003a301c723cULL, 0x040f70000004181cULL,
0x000000343020723cULL, 0x050f700000041820ULL, 0x000000363030723cULL, 0x000b6e0000041824ULL,
0x0000000803247824ULL, 0x020fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000000103257810ULL, 0x000fe20007ffe0ffULL, 0x000000000eff7f8cULL, 0x0003e2000c80043fULL,
0x000000c024247811ULL, 0x000fc400078e28ffULL, 0x0000005e2500720cULL, 0x000fe40003f06070ULL,
0x00000060240f7812ULL, 0x000fca00078ec0ffULL, 0x0000000168347824ULL, 0x000fe200078e020fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x102fe40000011605ULL, 0x00000024690e7217ULL, 0x000fe40007800000ULL,
0x0000000439257810ULL, 0x040fe40007ffe0ffULL, 0x0000000839297810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a24ULL, 0x00000003250f7819ULL, 0x040fe200000006ffULL,
0x00000001252e7824ULL, 0x100fe200078e0205ULL, 0x00000014393d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129367824ULL, 0x040fe200078e0205ULL, 0x000000200e3a7817ULL, 0x000fe20003800000ULL,
0x0000000829277824ULL, 0x000fe200078e00ffULL, 0xfffffff80f2e7812ULL, 0x000fe200078ee22eULL,
0x00000080020f7824ULL, 0x000fe200078e00ffULL, 0x0000000c392b7810ULL, 0x000fe20007ffe0ffULL,
0x000000083d287824ULL, 0x000fe200078e00ffULL, 0xfffffff827367812ULL, 0x000fe200078ee236ULL,
0x0000000139277824ULL, 0x040fe200078e0234ULL, 0x000000806a0e7812ULL, 0x000fe200078ef80fULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x00000010393b7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b357824ULL, 0x000fe200078e0205ULL, 0x000000053d377210ULL, 0x000fe20007ffe0ffULL,
0x0000010027267825ULL, 0x000fe200078e000eULL, 0x0000003a2500720cULL, 0x000fc40003f86070ULL,
0xfffffff828377812ULL, 0x000fe200078ee237ULL, 0x000000082b247824ULL, 0x000fe200078e00ffULL,
0x000000260c2c7210ULL, 0x000fe20007f1e0ffULL, 0x000000013b387824ULL, 0x000fe200078e0205ULL,
0x0000003a2900720cULL, 0x080fe20003f66070ULL, 0x000000083b2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff824357812ULL, 0x000fe200078ee235ULL, 0x0000000125257824ULL, 0x000fe200078e0234ULL,
0x0000003a2b00720cULL, 0x080fe20003f46070ULL, 0x0000200002287824ULL, 0x000fe200078e00ffULL,
0xfffffff82d387812ULL, 0x000fe200078ee238ULL, 0x0000010025247825ULL, 0x000fe200078e000eULL,
0x0000003a3900720cULL, 0x000fc40003fa6070ULL, 0x00002000282f7812ULL, 0x000fe200078ec0ffULL,
0x000000010d2d7824ULL, 0x000fe200000e0627ULL, 0x000000240c247210ULL, 0x000fe20007f3e0ffULL,
0x0000000129277824ULL, 0x100fe200078e0234ULL, 0x0000001839437810ULL, 0x000fe20007ffe0ffULL,
0x000000012b297824ULL, 0x000fe200078e0234ULL, 0x0000001c39457810ULL, 0x040fe20007ffe0ffULL,
0x0000000139267824ULL, 0x000fe400078e0205ULL, 0x0000010029287825ULL, 0x000fc600078e000eULL,
0x00000007263c7812ULL, 0x000fe200078ec0ffULL, 0x000040000a2f7824ULL, 0x000fe200078e022fULL,
0x000000280c287210ULL, 0x000fe20007fde0ffULL, 0x000000013b2b7824ULL, 0x000fe200078e0234ULL,
0x0ffffff83c3c7812ULL, 0x000fe200078ef805ULL, 0x000000010d257824ULL, 0x000fe200008e0625ULL,
0x0000003a3b00720cULL, 0x000fe20003f26070ULL, 0x000001002b2a7825ULL, 0x100fe200078e000eULL,
0x000140002f3b7810ULL, 0x000fe40007ffe0ffULL, 0x000000290d297210ULL, 0x000fe200037fe4ffULL,
0x0000010027267825ULL, 0x000fe200078e000eULL, 0x0000002a0c2a7210ULL, 0x000fc60007fde0ffULL,
0x000000013d2f7824ULL, 0x000fe200078e0234ULL, 0x000000260c267210ULL, 0x000fe20007f1e0ffULL,
0x000000102e417824ULL, 0x100fe400078e023bULL, 0x000000103c3f7824ULL, 0x000fe400078e023bULL,
0x000001002f2e7825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c3f7faeULL, 0x0003e2000e901c46ULL, 0x0000000143397824ULL, 0x140fe200078e0234ULL,
0x0000003a4300720cULL, 0x000fe20003fa6070ULL, 0x000000010d2b7824ULL, 0x040fe200030e062bULL,
0x0000002e0c2e7210ULL, 0x000fe20007fde0ffULL, 0x000000010d277824ULL, 0x000fe200000e0627ULL,
0x0000003a3d00720cULL, 0x080fe20003f06070ULL, 0x00000001453d7824ULL, 0x040fe200078e0234ULL,
0x0000000024417faeULL, 0x0005e2000e101c46ULL, 0x0000003a4500720cULL, 0x000fe20003f86070ULL,
0x000000010d2f7824ULL, 0x000fe200030e062fULL, 0x00000003453a7819ULL, 0x000fe200000006ffULL,
0x00000100392c7825ULL, 0x002fc800078e000eULL, 0x0000000143347824ULL, 0x140fe400078e0205ULL,
0x0000000843437824ULL, 0x000fe400078e00ffULL, 0x0000000145257824ULL, 0x004fe200078e0205ULL,
0x0000002c0c247210ULL, 0x000fe20007fde0ffULL, 0x000001003d0e7825ULL, 0x000fe200078e000eULL,
0xfffffff843347812ULL, 0x000fe400078ee234ULL, 0xfffffff83a2c7812ULL, 0x000fe200078ee225ULL,
0x000000010d257824ULL, 0x000fe200030e062dULL, 0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000010362d7824ULL, 0x000fc400078e023bULL, 0x0000001035357824ULL, 0x100fe400078e023bULL,
0x0000001038397824ULL, 0x100fe200078e023bULL, 0x00000000262d7faeULL, 0x0003e2000d901c46ULL,
0x0000001037377824ULL, 0x100fe400078e023bULL, 0x00000010343d7824ULL, 0x100fe200078e023bULL,
0x0000000028357faeULL, 0x0003e2000d101c46ULL, 0x000000102c3b7824ULL, 0x000fe400078e023bULL,
0x000000010d0d7824ULL, 0x000fe200030e060fULL, 0x000000002a397faeULL, 0x0003e8000c901c46ULL,
0x000000002e377faeULL, 0x0003e8000c101c46ULL, 0x00000000243d7faeULL, 0x0003e8000e901c46ULL,
0x000000000c3b7faeULL, 0x0003e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000805357811ULL, 0x042fe400078fe8ffULL, 0x0000001005247811ULL, 0x000fc400078fe8ffULL,
0x00000005353a7210ULL, 0x040fe20007ffe0ffULL, 0x00000008350f7824ULL, 0x000fe200078e00ffULL,
0x0000001805277811ULL, 0x040fe200078fe8ffULL, 0x0000000124387824ULL, 0x140fe200078e0205ULL,
0x00000004052d7811ULL, 0x000fe200078fe8ffULL, 0x0000000135357824ULL, 0x000fe200078e0234ULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x00000008240f7824ULL, 0x000fe200078e00ffULL,
0x0000001c053d7811ULL, 0x000fe200078fe8ffULL, 0x0000000127367824ULL, 0x100fe200078e0205ULL,
0x0000000c052f7811ULL, 0x000fe200078fe8ffULL, 0x0000000827297824ULL, 0x000fe200078e00ffULL,
0xfffffff80f387812ULL, 0x000fe200078ee238ULL, 0x00002000020f7824ULL, 0x040fe200078e00ffULL,
0x00000034052b7211ULL, 0x000fe200078fe8ffULL, 0x000000012d3b7824ULL, 0x100fe200078e0205ULL,
0xfffffff829367812ULL, 0x000fe200078ee236ULL, 0x000000082d0e7824ULL, 0x000fe200078e00ffULL,
0x0000000702297819ULL, 0x000fe200000006ffULL, 0x000000012f397824ULL, 0x000fe200078e0205ULL,
0x000020000f3f7812ULL, 0x000fe200078ec0ffULL, 0x00000001240f7824ULL, 0x000fe200078e0234ULL,
0x000000806a287812ULL, 0x000fe200078ef829ULL, 0x000000013d247824ULL, 0x040fe200078e0205ULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee23bULL, 0x000000083d297824ULL, 0x000fe200078e00ffULL,
0x0000001405257811ULL, 0x000fe200078fe8ffULL, 0x000000082f0e7824ULL, 0x000fc400078e00ffULL,
0x000000012d2d7824ULL, 0x000fe200078e0234ULL, 0xfffffff8293e7812ULL, 0x000fe200078ee224ULL,
0x000000012f2f7824ULL, 0x000fe200078e0234ULL, 0x000000ff00297202ULL, 0x000fe20000000f00ULL,
0x0000000125377824ULL, 0x040fe200078e0205ULL, 0xfffffff80e397812ULL, 0x000fe200078ee239ULL,
0x0000000825267824ULL, 0x000fe200078e00ffULL, 0x00000005050e7211ULL, 0x000fe200078fe8ffULL,
0x000001002b2a7825ULL, 0x000fc600078e0028ULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x000001002d2c7825ULL, 0x000fe200078e0028ULL, 0x0000002a0c2a7210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff80e3c7812ULL, 0x000fe200078ef805ULL, 0x0000000125257824ULL, 0x100fe200078e0234ULL,
0x0000002c0c2c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000127277824ULL, 0x100fe200078e0234ULL,
0xfffffff826377812ULL, 0x000fe200078ee237ULL, 0x000000013d3d7824ULL, 0x000fe400078e0234ULL,
0x000040000a3f7824ULL, 0x000fc400078e023fULL, 0x0000010035347825ULL, 0x000fc600078e0028ULL,
0x000140003f3f7810ULL, 0x000fe20007ffe0ffULL, 0x000001002f2e7825ULL, 0x000fe200078e0028ULL,
0x000000340c347210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e0028ULL,
0x0000002e0c2e7210ULL, 0x000fe40007f7e0ffULL, 0x000000350d357210ULL, 0x000fe200017fe4ffULL,
0x0000010025247825ULL, 0x000fc800078e0028ULL, 0x0000010027267825ULL, 0x000fc800078e0028ULL,
0x000001003d287825ULL, 0x000fe200078e0028ULL, 0x000000260c267210ULL, 0x000fc60007f5e0ffULL,
0x000000010d2b7824ULL, 0x040fe200000e062bULL, 0x0000000e0c0e7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d2d7824ULL, 0x000fe200008e062dULL, 0x000000240c247210ULL, 0x000fe20007f3e0ffULL,
0x000000103c3d7824ULL, 0x100fe400078e023fULL, 0x000000103b3b7824ULL, 0x000fe400078e023fULL,
0x000000010d2f7824ULL, 0x000fe200018e062fULL, 0x000000280c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000103a417824ULL, 0x100fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3d7faeULL, 0x0003e2000b901c46ULL, 0x0000001039397824ULL, 0x000fc400078e023fULL,
0x0000001038437824ULL, 0x000fe200078e023fULL, 0x000000002c3b7faeULL, 0x0003e2000b901c46ULL,
0x000000010d0f7824ULL, 0x000fe400000e060fULL, 0x0000001037377824ULL, 0x000fe200078e023fULL,
0x0000000034417faeULL, 0x0003e2000b901c46ULL, 0x000000010d257824ULL, 0x040fe400008e0625ULL,
0x0000001036457824ULL, 0x000fe200078e023fULL, 0x000000002e397faeULL, 0x0003e2000b901c46ULL,
0x000000010d277824ULL, 0x000fc400010e0627ULL, 0x000000103e3f7824ULL, 0x000fe200078e023fULL,
0x000000000e437faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x000fc600018e0629ULL,
0x0000000024377faeULL, 0x0003e8000b901c46ULL, 0x0000000026457faeULL, 0x0003e8000b901c46ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff0c7624ULL, 0x002fe200078e00ffULL,
0x000000010b0d7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000010d00780cULL, 0x000fc40003f05070ULL,
0xffffffff0c0c7811ULL, 0x000fc800078e08ffULL, 0x000000010c0c7807ULL, 0x000fca0004000000ULL,
0x000000010b0b7824ULL, 0x000fca00078e020cULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x000000010b0c8824ULL, 0x000fe400078e026cULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000066000c0c8625ULL, 0x000fca00078e000dULL, 0x000000060c598981ULL, 0x000322000c1e1900ULL,
0x000000106e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000e09097211ULL, 0x000fe400078e28ffULL,
0x000000086e0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010e097824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b64800090e7f8cULL, 0x0022a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01b64c0009257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x000000240c277210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e0dULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000002724247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b64c0009257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001006a097810ULL, 0x002fca0007ffe05cULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x01b00000090d7984ULL, 0x000e680000000800ULL,
0x01b20000090c7984ULL, 0x0004e20000000800ULL, 0x000000080d00720bULL, 0x002fe20003f1d000ULL,
0x0000eda27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x004fc800000e0100ULL,
0x0000ffff09257812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000202097811ULL, 0x000fe400078ff0ffULL, 0x000000080d00720bULL, 0x000fe40003f34000ULL,
0x000000020900720cULL, 0x000fe20003f05270ULL, 0x0000ed627f007947ULL, 0x000fd4000b800000ULL,
0x0000000000247806ULL, 0x000fc400008e0100ULL, 0x00000080020f8824ULL, 0x000fe200078e026aULL,
0x000000080d098209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910240e7816ULL, 0x000fe200000000ffULL, 0x0000000170268824ULL, 0x000fca00078e020fULL,
0x01b4000926008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000080d097209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff24ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000809097221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900267308ULL, 0x000e640000000800ULL, 0x0000002607077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011605ULL,
0x0000ec927f007947ULL, 0x000fea000b800000ULL, 0x00001f0926097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe40000410000ULL, 0x0000000911117220ULL, 0x080fe40000410000ULL,
0x0000000914147220ULL, 0x080fe40000410000ULL, 0x0000000915157220ULL, 0x000fc40000410000ULL,
0x0000000918187220ULL, 0x080fe40000410000ULL, 0x0000000919197220ULL, 0x080fe40000410000ULL,
0x0000000950507220ULL, 0x080fe40000410000ULL, 0x0000000951517220ULL, 0x080fe40000410000ULL,
0x0000000954547220ULL, 0x080fe40000410000ULL, 0x0000000955557220ULL, 0x000fc40000410000ULL,
0x000000091c1c7220ULL, 0x080fe40000410000ULL, 0x000000091d1d7220ULL, 0x080fe40000410000ULL,
0x0000000920207220ULL, 0x080fe40000410000ULL, 0x0000000921217220ULL, 0x080fe40000410000ULL,
0x0000000930307220ULL, 0x080fe40000410000ULL, 0x0000000931317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x0000eb927f007947ULL, 0x000fea000b800000ULL, 0x00001f0926097589ULL, 0x00046400000e0000ULL,
0x0000000912127220ULL, 0x086fe40000410000ULL, 0x0000000913137220ULL, 0x080fe40000410000ULL,
0x0000000916167220ULL, 0x080fe40000410000ULL, 0x0000000917177220ULL, 0x080fe40000410000ULL,
0x000000091a1a7220ULL, 0x080fe40000410000ULL, 0x000000091b1b7220ULL, 0x000fc40000410000ULL,
0x0000000952527220ULL, 0x080fe40000410000ULL, 0x0000000953537220ULL, 0x080fe40000410000ULL,
0x0000000956567220ULL, 0x080fe40000410000ULL, 0x0000000957577220ULL, 0x080fe40000410000ULL,
0x000000091e1e7220ULL, 0x080fe40000410000ULL, 0x000000091f1f7220ULL, 0x000fc40000410000ULL,
0x0000000922227220ULL, 0x080fe40000410000ULL, 0x0000000923237220ULL, 0x080fe40000410000ULL,
0x0000000932327220ULL, 0x080fe40000410000ULL, 0x0000000933337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff25ff7812ULL, 0x000fe40007806024ULL,
0x000000080d087209ULL, 0x000fd60007810000ULL, 0x800000080d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00000308ULL, 0x000e640000000800ULL,
0x000000000c0c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000070c077221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000000ff04723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011605ULL,
0x00005410040c7816ULL, 0x000fe20000000004ULL, 0x0000e9e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c047589ULL, 0x0002a400000e0000ULL, 0x000000080d097810ULL, 0x000fe20007ffe0ffULL,
0x0000ea327f007947ULL, 0x000fea000b800000ULL, 0x00001f090c067589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100d097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000069d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000f23000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180d097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x00006a40000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000f1c000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00000007050c7812ULL, 0x00afe200078ec0ffULL, 0x000000020a487824ULL, 0x000fe200078e026bULL,
0x0000000267097810ULL, 0x004fe20007ffe0ffULL, 0x012000005d3c783bULL, 0x000e620000000200ULL,
0x000000080c0c7812ULL, 0x000fe400078ef805ULL, 0x0000000d48487819ULL, 0x000fc600000006ffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x0001300048287810ULL, 0x000fc80007ffe0ffULL,
0xfffffff80c587812ULL, 0x000fe200078ee209ULL, 0x000000105f0c7824ULL, 0x000fe200078e0228ULL,
0x00000002ff097819ULL, 0x000fe20000011602ULL, 0x00000010614c7824ULL, 0x100fe400078e0228ULL,
0x0000001060447824ULL, 0x100fe400078e0228ULL, 0x0000001062407824ULL, 0x100fe200078e0228ULL,
0x000000000c0c783bULL, 0x000ea20000004200ULL, 0x0000001058587824ULL, 0x000fe400078e00ffULL,
0x0000001065387824ULL, 0x000fe200078e0228ULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x0000080009247824ULL, 0x000fc400078e0258ULL, 0x0000001064347824ULL, 0x100fe200078e0228ULL,
0x000000004444783bULL, 0x000fe20000004200ULL, 0x00000010632c7824ULL, 0x000fe200078e0228ULL,
0x0000002866287211ULL, 0x000fe400078e20ffULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x012000002424783bULL, 0x000ee80000000200ULL, 0x000000002c2c783bULL, 0x000ee20000004200ULL,
0x000000043c3c0231ULL, 0x002fc400003400ffULL, 0x000000043e3e0231ULL, 0x000fe200003400ffULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x000000063d3d0231ULL, 0x080fe400003400ffULL,
0x000000063f3f0231ULL, 0x000fe200003400ffULL, 0x000000003434783bULL, 0x000e680000004200ULL,
0x000000002828783bULL, 0x000e640000004200ULL, 0x0000000c3c54723cULL, 0x044f700000041854ULL,
0x0000004c3c10723cULL, 0x048f700000041810ULL, 0x0000004e3c14723cULL, 0x000f620000041814ULL,
0x0000000424240231ULL, 0x000fc400003400ffULL, 0x0000000426260231ULL, 0x000fe400003400ffULL,
0x0000000625250231ULL, 0x080fe400003400ffULL, 0x0000000627270231ULL, 0x000fe200003400ffULL,
0x000000443c18723cULL, 0x040f700000041818ULL, 0x000000463c50723cULL, 0x040f700000041850ULL,
0x0000000e3c0c723cULL, 0x040f70000004181cULL, 0x000000403c20723cULL, 0x040f700000041820ULL,
0x000000423c30723cULL, 0x000f700000041830ULL, 0x0000002c2454723cULL, 0x060f700000041854ULL,
0x000000382410723cULL, 0x042f700000041810ULL, 0x0000003a2414723cULL, 0x040f700000041814ULL,
0x000000342418723cULL, 0x040f700000041818ULL, 0x000000362450723cULL, 0x040f700000041850ULL,
0x0000002e242c723cULL, 0x040b6e000004180cULL, 0x0001b698090c7811ULL, 0x020fe200078e18ffULL,
0x000000282420723cULL, 0x040b700000041820ULL, 0x0000002a2424723cULL, 0x000b620000041830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000300030e7a10ULL, 0x000fe20007ffe0ffULL,
0x000000000cff7f8cULL, 0x0003e6000c80043fULL, 0x0000005e0e00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x000000010e0d7810ULL, 0x042fe20007ffe0ffULL, 0x000001000e0f7824ULL, 0x000fe400078e026fULL,
0x00005900590c7a24ULL, 0x010fe200078e02ffULL, 0x0000005e0d00720cULL, 0x000fe20003f06070ULL,
0x00000100ff1d7424ULL, 0x000fe200078e00ffULL, 0x000000600f0d7812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7824ULL, 0x000fc800078e00ffULL, 0x0000000168347824ULL, 0x000fe400078e020dULL,
0x000064000c0c7625ULL, 0x000fc800078e001dULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x000fe40000011605ULL, 0x0000000f690e7217ULL, 0x000fe40007800000ULL,
0x00000004391d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000839317810ULL, 0x060fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a0fULL, 0x0000000c393b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d327824ULL, 0x100fe200078e0205ULL, 0x00000010393d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d0f7824ULL, 0x000fe200078e00ffULL, 0x000000200e3a7817ULL, 0x000fe20003800000ULL,
0x0000000131367824ULL, 0x100fe200078e0205ULL, 0x000000033b1c7819ULL, 0x000fe200000006ffULL,
0x00000008311f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f327812ULL, 0x000fe200078ee232ULL,
0x00000080020f7824ULL, 0x000fe200078e00ffULL, 0x0000003a1d00720cULL, 0x080fe20003f86070ULL,
0x000000013b357824ULL, 0x000fe200078e0205ULL, 0xfffffff81f367812ULL, 0x000fe200078ee236ULL,
0x000000011d1d7824ULL, 0x100fe200078e0234ULL, 0x000000806a0e7812ULL, 0x000fe200078ef80fULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0xfffffff81c357812ULL, 0x000fe200078ee235ULL,
0x00000001391f7824ULL, 0x040fe200078e0234ULL, 0x0000001439417810ULL, 0x000fe20007ffe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e000eULL, 0x0000003a3100720cULL, 0x000fc40003f66070ULL,
0x0000003a3900720cULL, 0x000fe20003fa6070ULL, 0x000000013d387824ULL, 0x000fe200078e0205ULL,
0x0000001c0c287210ULL, 0x040fe20007f3e0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e000eULL,
0x0000003a3b00720cULL, 0x000fe40003f46070ULL, 0x0000001839437810ULL, 0x000fe20007ffe0ffULL,
0x000000083d297824ULL, 0x000fe200078e00ffULL, 0x0000001e0c2a7210ULL, 0x000fe20007f1e0ffULL,
0x00000001391c7824ULL, 0x140fe200078e0205ULL, 0x0000001c39457810ULL, 0x000fe20007ffe0ffULL,
0x0000000141377824ULL, 0x000fe200078e0205ULL, 0xfffffff829387812ULL, 0x000fe200078ee238ULL,
0x000000010d297824ULL, 0x040fe200008e061dULL, 0x0000000d021d7819ULL, 0x000fe200000006ffULL,
0x000000010d2b7824ULL, 0x000fe200000e061fULL, 0x000000071c3c7812ULL, 0x000fe200078ec0ffULL,
0x00000001311f7824ULL, 0x100fe200078e0234ULL, 0x000020001d337812ULL, 0x000fe200078ec0ffULL,
0x000000013b1d7824ULL, 0x000fe200078e0234ULL, 0x0ffffff83c3c7812ULL, 0x000fe200078ef805ULL,
0x000001001f1e7825ULL, 0x000fe200078e000eULL, 0x0000003a3d00720cULL, 0x000fc60003f26070ULL,
0x0000000841307824ULL, 0x000fe200078e00ffULL, 0x0000001e0c1e7210ULL, 0x000fe20007f1e0ffULL,
0x000001001d1c7825ULL, 0x000fc600078e000eULL, 0xfffffff830377812ULL, 0x000fe200078ee237ULL,
0x000000013d317824ULL, 0x000fe200078e0234ULL, 0x0000001c0c1c7210ULL, 0x000fe20007fde0ffULL,
0x000040000a337824ULL, 0x000fe400078e0233ULL, 0x0000010031307825ULL, 0x000fc600078e000eULL,
0x00013000333b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000141337824ULL, 0x000fe400078e0234ULL,
0x000000010d1f7824ULL, 0x000fe200000e061fULL, 0x0000003a4100720cULL, 0x000fe20003f06070ULL,
0x000000010d1d7824ULL, 0x000fe200030e061dULL, 0x000000300c307210ULL, 0x000fe20007fde0ffULL,
0x000000103c3f7824ULL, 0x000fe200078e023bULL, 0x0000003b32417211ULL, 0x000fe200078e20ffULL,
0x0000010033327825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000e901c46ULL, 0x0000000143397824ULL, 0x140fe200078e0234ULL,
0x0000003a4300720cULL, 0x000fe20003fa6070ULL, 0x000000010d317824ULL, 0x000fe200030e0631ULL,
0x000000320c327210ULL, 0x000fe20007fde0ffULL, 0x0000000028417faeULL, 0x0005e2000e101c46ULL,
0x00000001453d7824ULL, 0x040fe200078e0234ULL, 0x0000003a4500720cULL, 0x000fe20003f86070ULL,
0x0000000143347824ULL, 0x000fe400078e0205ULL, 0x000000010d337824ULL, 0x000fc400030e0633ULL,
0x00000100392a7825ULL, 0x002fe200078e000eULL, 0x0000003b38397211ULL, 0x000fc600078e20ffULL,
0x00000008453a7824ULL, 0x040fe200078e00ffULL, 0x0000002a0c287210ULL, 0x004fe20007fde0ffULL,
0x0000000145297824ULL, 0x000fe400078e0205ULL, 0x0000000843437824ULL, 0x000fe400078e00ffULL,
0x000001003d0e7825ULL, 0x000fe200078e000eULL, 0xfffffff83a2a7812ULL, 0x000fe400078ee229ULL,
0xfffffff843347812ULL, 0x000fe200078ee234ULL, 0x000000010d297824ULL, 0x000fe200030e062bULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010362b7824ULL, 0x000fc400078e023bULL,
0x0000001035357824ULL, 0x100fe400078e023bULL, 0x0000001037377824ULL, 0x100fe200078e023bULL,
0x000000001e2b7faeULL, 0x0003e2000d901c46ULL, 0x00000010343d7824ULL, 0x100fe400078e023bULL,
0x000000102a3b7824ULL, 0x000fe200078e023bULL, 0x000000001c357faeULL, 0x0003e2000d101c46ULL,
0x000000010d0d7824ULL, 0x000fc600030e060fULL, 0x0000000030397faeULL, 0x0003e8000c901c46ULL,
0x0000000032377faeULL, 0x0003e8000c101c46ULL, 0x00000000283d7faeULL, 0x0003e8000e901c46ULL,
0x000000000c3b7faeULL, 0x0003e2000e101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000805357811ULL, 0x040fe400078fe8ffULL, 0x00000010051d7811ULL, 0x000fc400078fe8ffULL,
0x0000001805297811ULL, 0x020fe200078fe8ffULL, 0x00000001353a7824ULL, 0x100fe200078e0205ULL,
0x0000000405337811ULL, 0x000fe200078fe8ffULL, 0x00000008350f7824ULL, 0x000fe200078e00ffULL,
0x000000051d387210ULL, 0x080fe20007ffe0ffULL, 0x0000000129367824ULL, 0x100fe200078e0205ULL,
0x0000000c051c7811ULL, 0x000fe200078fe8ffULL, 0x00000008292b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x000000081d0f7824ULL, 0x000fe200078e00ffULL,
0x0000001c053d7811ULL, 0x000fe200078fe8ffULL, 0x00000001333b7824ULL, 0x000fe200078e0205ULL,
0xfffffff82b367812ULL, 0x000fe200078ee236ULL, 0x00000008330e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f387812ULL, 0x000fe200078ee238ULL, 0x00002000020f7824ULL, 0x040fe200078e00ffULL,
0x00000014051f7811ULL, 0x000fe200078fe8ffULL, 0x00000080022b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee23bULL, 0x000000011c397824ULL, 0x040fe200078e0205ULL,
0x000020000f3f7812ULL, 0x000fe200078ec0ffULL, 0x000000081c0e7824ULL, 0x000fe200078e00ffULL,
0x000000806a2a7812ULL, 0x000fe200078ef82bULL, 0x000000011c0f7824ULL, 0x100fe200078e0234ULL,
0x0000003405317211ULL, 0x080fe200078fe8ffULL, 0x000000013d1c7824ULL, 0x040fe200078e0205ULL,
0xfffffff80e397812ULL, 0x000fe200078ee239ULL, 0x000000083d2b7824ULL, 0x000fe200078e00ffULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x0000000133337824ULL, 0x100fe200078e0234ULL,
0x000000341d1d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000135357824ULL, 0x000fe200078e0234ULL,
0xfffffff82b3e7812ULL, 0x000fe200078ee21cULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x000000070e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000011f377824ULL, 0x000fc400078e0205ULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x0ffffff80e3c7812ULL, 0x000fe200078ef805ULL,
0x0000010031307825ULL, 0x000fc600078e002aULL, 0xfffffff81e377812ULL, 0x000fe200078ee237ULL,
0x000000011f1f7824ULL, 0x100fe200078e0234ULL, 0x000000300c307210ULL, 0x000fe20007f1e0ffULL,
0x0000000129297824ULL, 0x100fe400078e0234ULL, 0x000000013d3d7824ULL, 0x000fe400078e0234ULL,
0x0000010033327825ULL, 0x000fc800078e002aULL, 0x000040000a3f7824ULL, 0x000fe200078e023fULL,
0x000000320c327210ULL, 0x000fe20007f3e0ffULL, 0x0000010035347825ULL, 0x000fc600078e002aULL,
0x000130003f3f7810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e002aULL,
0x000000340c347210ULL, 0x040fe40007f5e0ffULL, 0x0000003f39397211ULL, 0x000fe200078e20ffULL,
0x000001001d1c7825ULL, 0x000fe200078e002aULL, 0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL,
0x000001001f1e7825ULL, 0x000fc800078e002aULL, 0x0000010029287825ULL, 0x000fc800078e002aULL,
0x000001003d2a7825ULL, 0x000fc800078e002aULL, 0x000000010d317824ULL, 0x040fe200000e0631ULL,
0x0000001c0c1c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d337824ULL, 0x040fe200008e0633ULL,
0x0000001e0c1e7210ULL, 0x000fe20007f3e0ffULL, 0x000000103c3d7824ULL, 0x000fe400078e023fULL,
0x000000010d357824ULL, 0x000fe200010e0635ULL, 0x000000280c287210ULL, 0x040fe20007f5e0ffULL,
0x000000103b3b7824ULL, 0x000fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303d7faeULL, 0x0003e2000b901c46ULL, 0x000000010d0f7824ULL, 0x040fe200018e060fULL,
0x0000002a0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000103a417824ULL, 0x100fe200078e023fULL,
0x000000290d297210ULL, 0x040fe200017fe4ffULL, 0x0000001038437824ULL, 0x000fe200078e023fULL,
0x00000000323b7faeULL, 0x0003e2000b901c46ULL, 0x000000010d1d7824ULL, 0x000fc400000e061dULL,
0x0000001037377824ULL, 0x000fe200078e023fULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x000000010d1f7824ULL, 0x040fe400008e061fULL, 0x0000001036457824ULL, 0x100fe200078e023fULL,
0x000000000e397faeULL, 0x0003e2000b901c46ULL, 0x000000103e3f7824ULL, 0x000fe400078e023fULL,
0x000000010d0d7824ULL, 0x000fe200018e062bULL, 0x000000001c437faeULL, 0x0003e8000b901c46ULL,
0x000000001e377faeULL, 0x0003e8000b901c46ULL, 0x0000000028457faeULL, 0x0003e8000b901c46ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x000000106e0c7812ULL, 0x000fc400078ec0ffULL, 0x000000086e0d7812ULL, 0x000fc600078ec0ffULL,
0x00000020090c7824ULL, 0x000fc800078e020cULL, 0x000000010d1e7824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b668001e0e7f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01b66c001e097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c0c1c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e0dULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001141dULL, 0x0000001c09097211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000209097819ULL, 0x000fc8000000121cULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b66c001e097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001806a097810ULL, 0x000fca0007ffe05cULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x01b00000090d7984ULL, 0x000ea80000000800ULL,
0x01b20000091c7984ULL, 0x0006620000000800ULL, 0x000000080d00720bULL, 0x004fe20003f1d000ULL,
0x0000d5c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x008fc800000e0100ULL,
0x0000ffff091d7812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff0c7224ULL, 0x000fd400078e0008ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000302097811ULL, 0x000fe400078ff0ffULL,
0x000000080d00720bULL, 0x000fe40003f34000ULL, 0x000000020900720cULL, 0x000fe20003f05270ULL,
0x0000d5727f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400008e0100ULL,
0x00000080020f8824ULL, 0x000fe200078e026aULL, 0x000000080d098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100c0e7816ULL, 0x000fe200000000ffULL,
0x0000000170708824ULL, 0x000fca00078e020fULL, 0x01b4000970008388ULL, 0x0005e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000080d097209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009001e7308ULL, 0x002e640000000800ULL,
0x0000001e07077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011605ULL, 0x0000d4a27f007947ULL, 0x000fea000b800000ULL,
0x00001f091e097589ULL, 0x0002a400000e0000ULL, 0x0000000910107220ULL, 0x084fe40000410000ULL,
0x0000000911117220ULL, 0x080fe40000410000ULL, 0x0000000914147220ULL, 0x080fe40000410000ULL,
0x0000000915157220ULL, 0x000fc40000410000ULL, 0x0000000918187220ULL, 0x080fe40000410000ULL,
0x0000000919197220ULL, 0x080fe40000410000ULL, 0x0000000950507220ULL, 0x080fe40000410000ULL,
0x0000000951517220ULL, 0x080fe40000410000ULL, 0x0000000954547220ULL, 0x080fe40000410000ULL,
0x0000000955557220ULL, 0x000fc40000410000ULL, 0x000000092c2c7220ULL, 0x080fe40000410000ULL,
0x000000092d2d7220ULL, 0x080fe40000410000ULL, 0x0000000920207220ULL, 0x0a0fe40000410000ULL,
0x0000000921217220ULL, 0x080fe40000410000ULL, 0x0000000924247220ULL, 0x080fe40000410000ULL,
0x0000000925257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000805097811ULL, 0x000fe200078ff0ffULL, 0x0000d3a27f007947ULL, 0x000fea000b800000ULL,
0x00001f091e097589ULL, 0x0004e400000e0000ULL, 0x0000000912127220ULL, 0x08cfe40000410000ULL,
0x0000000913137220ULL, 0x080fe40000410000ULL, 0x0000000916167220ULL, 0x080fe40000410000ULL,
0x0000000917177220ULL, 0x080fe40000410000ULL, 0x000000091a1a7220ULL, 0x080fe40000410000ULL,
0x000000091b1b7220ULL, 0x000fc40000410000ULL, 0x0000000952527220ULL, 0x080fe40000410000ULL,
0x0000000953537220ULL, 0x080fe40000410000ULL, 0x0000000956567220ULL, 0x080fe40000410000ULL,
0x0000000957577220ULL, 0x080fe40000410000ULL, 0x000000092e2e7220ULL, 0x080fe40000410000ULL,
0x000000092f2f7220ULL, 0x000fc40000410000ULL, 0x0000000922227220ULL, 0x0a0fe40000410000ULL,
0x0000000923237220ULL, 0x080fe40000410000ULL, 0x0000000926267220ULL, 0x080fe40000410000ULL,
0x0000000927277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1dff7812ULL, 0x000fe4000780600cULL, 0x000000080d0c7209ULL, 0x000fd60007810000ULL,
0x8000000c0d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00000308ULL, 0x000ea40000000800ULL, 0x000000001c1c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x000000071c077221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000000ff04723eULL, 0x000fe400000010ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011605ULL, 0x0000541004087816ULL, 0x000fe20000000004ULL,
0x0000d1f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d08047589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x0000d2427f007947ULL, 0x000fea000b800000ULL,
0x00001f0908067589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x00008420000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000d7e000007944ULL, 0x036fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x00008490000f7802ULL, 0x000fc40000000f00ULL,
0x0000d77000007944ULL, 0x032fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000705087812ULL, 0x00afe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000808087812ULL, 0x000fca00078ef805ULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x00000002ff087819ULL, 0x000fc80000011602ULL, 0xfffffff80e677812ULL, 0x000fca00078ee267ULL,
0x0000008008407824ULL, 0x000fca00078e0267ULL, 0x0001280040407811ULL, 0x000fca00078e20ffULL,
0x00014000480d7810ULL, 0x000fe20007ffe0ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000000302097811ULL, 0x004fe400078ff0ffULL, 0x0000000d63307211ULL, 0x020fe200078e20ffULL,
0x00000010614c7824ULL, 0x100fe200078e020dULL, 0x0000030003037a10ULL, 0x000fe20007ffe0ffULL,
0x0000001060487824ULL, 0x100fe200078e020dULL, 0x0001b6a008087811ULL, 0x000fe200078e18ffULL,
0x000000105f3c7824ULL, 0x100fe200078e020dULL, 0x000000003030783bULL, 0x000fe20000004200ULL,
0x0000001062447824ULL, 0x000fc400078e020dULL, 0x00000800091c7824ULL, 0x000fe200078e0258ULL,
0x000000004c4c783bULL, 0x000ea20000004200ULL, 0x0000001065387824ULL, 0x100fe400078e020dULL,
0x0000001064347824ULL, 0x100fe200078e020dULL, 0x000000004848783bULL, 0x000ee20000004200ULL,
0x0000001066287824ULL, 0x000fc600078e020dULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000004444783bULL, 0x000fe80000004200ULL, 0x011000001c1c783bULL, 0x000ee80000000200ULL,
0x000000003838783bULL, 0x000ee80000004200ULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x0000000440400231ULL, 0x002fc600003400ffULL, 0x000000002828783bULL, 0x000e620000004200ULL,
0x0000000442420231ULL, 0x000fe400003400ffULL, 0x0000000641410231ULL, 0x080fe400003400ffULL,
0x0000000643430231ULL, 0x000fce00003400ffULL, 0x0000004c4010723cULL, 0x044f700000041810ULL,
0x0000004e4014723cULL, 0x040f700000041814ULL, 0x000000484018723cULL, 0x008f620000041818ULL,
0x000000041c1c0231ULL, 0x000fc400003400ffULL, 0x000000041e1e0231ULL, 0x000fe400003400ffULL,
0x000000061d1d0231ULL, 0x080fe400003400ffULL, 0x000000061f1f0231ULL, 0x000fe200003400ffULL,
0x0000004a4050723cULL, 0x040f700000041850ULL, 0x0000003c4054723cULL, 0x040f700000041854ULL,
0x0000003e402c723cULL, 0x040f70000004182cULL, 0x000000444020723cULL, 0x040f700000041820ULL,
0x000000464024723cULL, 0x000f700000041824ULL, 0x000000381c10723cULL, 0x060b700000041810ULL,
0x0000003a1c14723cULL, 0x040b700000041814ULL, 0x000000341c18723cULL, 0x040b700000041818ULL,
0x000000361c50723cULL, 0x040b700000041850ULL, 0x000000301c54723cULL, 0x040b700000041854ULL,
0x000000321c2c723cULL, 0x040b70000004182cULL, 0x000000281c20723cULL, 0x042b700000041820ULL,
0x0000002a1c1c723cULL, 0x000b620000041824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000005e0300720cULL, 0x000fe20003f06070ULL, 0x0000000008ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff935000007947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000e640000002500ULL, 0x0000005e0300720cULL, 0x002fda0003f06070ULL,
0x0000033000000947ULL, 0x000fea0003800000ULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00008940000b7802ULL, 0x000fc40000000f00ULL, 0x0000d0f000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0006ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000e640000001000ULL, 0xbf80000000047423ULL, 0x002fc80000000007ULL,
0x800000ff04057221ULL, 0x000fc80000010100ULL, 0x0000000500007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff097819ULL, 0x004fe40000011605ULL, 0x0000000805057811ULL, 0x000fc600078ff0ffULL,
0x00001f0900047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000001004107220ULL, 0x064fe40000410000ULL, 0x0000001104117220ULL, 0x040fe40000410000ULL,
0x0000001404147220ULL, 0x040fe40000410000ULL, 0x0000001504157220ULL, 0x000fc40000410000ULL,
0x0000001804187220ULL, 0x040fe40000410000ULL, 0x0000001904197220ULL, 0x040fe40000410000ULL,
0x0000005004507220ULL, 0x040fe40000410000ULL, 0x0000005104517220ULL, 0x040fe40000410000ULL,
0x0000005404547220ULL, 0x040fe40000410000ULL, 0x0000005504557220ULL, 0x000fc40000410000ULL,
0x0000002c042c7220ULL, 0x040fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000002004207220ULL, 0x040fe40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000001c041c7220ULL, 0x040fe40000410000ULL, 0x0000001d041d7220ULL, 0x000fc40000410000ULL,
0x0000001205127220ULL, 0x048fe40000410000ULL, 0x0000001305137220ULL, 0x040fe40000410000ULL,
0x0000001605167220ULL, 0x040fe40000410000ULL, 0x0000001705177220ULL, 0x040fe40000410000ULL,
0x0000001a051a7220ULL, 0x040fe40000410000ULL, 0x0000001b051b7220ULL, 0x000fc40000410000ULL,
0x0000005205527220ULL, 0x040fe40000410000ULL, 0x0000005305537220ULL, 0x040fe40000410000ULL,
0x0000005605567220ULL, 0x040fe40000410000ULL, 0x0000005705577220ULL, 0x040fe40000410000ULL,
0x0000002e052e7220ULL, 0x040fe40000410000ULL, 0x0000002f052f7220ULL, 0x000fc40000410000ULL,
0x0000002205227220ULL, 0x040fe40000410000ULL, 0x0000002305237220ULL, 0x040fe40000410000ULL,
0x0000001e051e7220ULL, 0x040fe40000410000ULL, 0x0000001f051f7220ULL, 0x000fc40000410000ULL,
0x00000000000e7919ULL, 0x000ea20000000000ULL, 0x00000020210f723eULL, 0x020fe400000010ffULL,
0x000000101104723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000121311723eULL, 0x000fc400000010ffULL, 0x000000161712723eULL, 0x000fe400000010ffULL,
0x0000001a1b13723eULL, 0x000fe400000010ffULL, 0x0000001e1f1a723eULL, 0x000fe400000010ffULL,
0x0000001c1d10723eULL, 0x000fe400000010ffULL, 0x000000181906723eULL, 0x000fe400000010ffULL,
0x000000222319723eULL, 0x000fc400000010ffULL, 0x00000002ff207819ULL, 0x004fe4000001160eULL,
0x000000080e297811ULL, 0x000fe400078ff0ffULL, 0x0000000220097810ULL, 0x040fe20007ffe0ffULL,
0x0000000820167824ULL, 0x040fe200078e00ffULL, 0x0000000620177810ULL, 0x040fe20007ffe0ffULL,
0x00000008201e7824ULL, 0x040fe200078e00ffULL, 0x0000000120007810ULL, 0x040fe20007ffe0ffULL,
0x00000008201b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8161d7812ULL, 0x000fe200078ee209ULL,
0x00000008201c7824ULL, 0x040fe200078e00ffULL, 0x0000000420097810ULL, 0x040fe20007ffe0ffULL,
0x0000000820237824ULL, 0x040fe200078e00ffULL, 0x0000000520167810ULL, 0x040fe20007ffe0ffULL,
0x00000008201f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e257812ULL, 0x000fe200078ee217ULL,
0x0000000820177824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0x0000000320007810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81c217812ULL, 0x000fe200078ee209ULL, 0x000010006b097824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee216ULL, 0x000000040e167824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL, 0x000008000a007824ULL, 0x000fe200078e0209ULL,
0xfffffff817177812ULL, 0x000fe400078ee220ULL, 0xffffffff201c7810ULL, 0x040fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0200ULL, 0x0000000320277819ULL, 0x000fe200000006ffULL,
0x0000001017177824ULL, 0x100fe200078e0200ULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0200ULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x000000101f1f7824ULL, 0x100fe200078e0200ULL, 0xfffffff81e297812ULL, 0x000fe200078ee229ULL,
0x0000001021217824ULL, 0x000fe200078e0200ULL, 0x000000141505723eULL, 0x000fe200000010ffULL,
0x0000000117177824ULL, 0x000fe200078e0216ULL, 0x0000000027277211ULL, 0x000fe200078e20ffULL,
0x0000001023237824ULL, 0x100fe200078e0200ULL, 0x000000505108723eULL, 0x000fe200000010ffULL,
0x00000001161b7824ULL, 0x040fe200078e021bULL, 0x00000054550b723eULL, 0x000fe200000010ffULL,
0x0000001025257824ULL, 0x100fe200078e0200ULL, 0x0000002c2d0d723eULL, 0x000fe200000010ffULL,
0x00000001161d7824ULL, 0x040fe200078e021dULL, 0x0000000417007388ULL, 0x000fe20000000800ULL,
0x00000001161f7824ULL, 0x040fe200078e021fULL, 0x000000525314723eULL, 0x000fe200000010ffULL,
0x0000001029297824ULL, 0x000fe200078e0200ULL, 0x000000051b007388ULL, 0x0005e20000000800ULL,
0x00000001161c7824ULL, 0x040fe200078e0221ULL, 0x000000565715723eULL, 0x000fe200000010ffULL,
0x0000000116237824ULL, 0x040fe200078e0223ULL, 0x000000061d007388ULL, 0x000fe20000000800ULL,
0x00000001161e7824ULL, 0x040fe200078e0225ULL, 0x0000002e2f18723eULL, 0x000fe200000010ffULL,
0x0000000116277824ULL, 0x040fe200078e0227ULL, 0x000000081f007388ULL, 0x0007e20000000800ULL,
0x0000000116167824ULL, 0x000fe200078e0229ULL, 0x0000000e6f057210ULL, 0x004fe20007ffe0ffULL,
0x000000ff00047306ULL, 0x000fe20000205400ULL, 0x0000000b1c007388ULL, 0x000fe80000000800ULL,
0x0000000d23007388ULL, 0x0005e60000000800ULL, 0x000000ff00087306ULL, 0x008fe2000020d400ULL,
0x0000000f1e007388ULL, 0x000fe80000000800ULL, 0x0000001027007388ULL, 0x000fe20000000800ULL,
0x00000010050d7824ULL, 0x004fc400078e0209ULL, 0x000000ff000b7306ULL, 0x000ea20000209400ULL,
0x0000001116007388ULL, 0x000fe80000000800ULL, 0x000400121b007388ULL, 0x000fe80000000800ULL,
0x000400131d007388ULL, 0x000fe80000000800ULL, 0x000400141f007388ULL, 0x000fe20000000800ULL,
0x000000040b00720bULL, 0x004fc60003f1d000ULL, 0x000400151c007388ULL, 0x000fe80000000800ULL,
0x0004001823007388ULL, 0x000fe80000000800ULL, 0x000400191e007388ULL, 0x000fe80000000800ULL,
0x0004001a27007388ULL, 0x000fe20000000800ULL, 0x0000000108080812ULL, 0x000fc600078efcffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000d287984ULL, 0x000ea20000000c00ULL,
0x00000300ff197624ULL, 0x000fe200078e00ffULL, 0x00000008080b723eULL, 0x000fe400000010ffULL,
0x000400000d147984ULL, 0x000ee40000000c00ULL, 0x000000011900780cULL, 0x000fc40003f05270ULL,
0x000800000d2c7984ULL, 0x000e680000000c00ULL, 0x000c00000d107984ULL, 0x000e620000000c00ULL,
0x3f803f800b2b7831ULL, 0x044fe4000020002bULL, 0x3f803f800b2a7831ULL, 0x040fe4000020002aULL,
0x3f803f800b297831ULL, 0x040fe40000200029ULL, 0x3f803f800b287831ULL, 0x000fc40000200028ULL,
0x3f803f800b177831ULL, 0x048fe40000200017ULL, 0x3f803f800b167831ULL, 0x040fe40000200016ULL,
0x3f803f800b157831ULL, 0x040fe40000200015ULL, 0x3f803f800b147831ULL, 0x000fe40000200014ULL,
0x3f803f802b2b7831ULL, 0x002fe4000020002fULL, 0x3f803f802a2a7831ULL, 0x000fc4000020002eULL,
0x3f803f8029297831ULL, 0x000fe4000020002dULL, 0x3f803f8028287831ULL, 0x000fe4000020002cULL,
0x3f803f8017177831ULL, 0x000fe40000200013ULL, 0x3f803f8016167831ULL, 0x000fe20000200012ULL,
0x000000280d007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fe40000200011ULL,
0x3f803f8014147831ULL, 0x000fca0000200010ULL, 0x000400140d007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a9000008947ULL, 0x000fea0003800000ULL,
0x00000400ff047624ULL, 0x000fe200078e00ffULL, 0x00000000000f7919ULL, 0x000e660000002600ULL,
0x00006c0004047a24ULL, 0x000fe200078e02ffULL, 0x00000000001a7919ULL, 0x000e660000002700ULL,
0x00000300040b7a24ULL, 0x040fe200078e02ffULL, 0x0000000f04187811ULL, 0x000fe200078e10ffULL,
0x000000000d107984ULL, 0x000ea60000000c00ULL, 0xfffffff018187812ULL, 0x000fe200078ec0ffULL,
0x000400000d147984ULL, 0x0006a80000000c00ULL, 0x000000800b067824ULL, 0x000fc800078e0218ULL,
0x000000800b0b7824ULL, 0x000fe200078e0206ULL, 0x00000040050d7810ULL, 0x008fc80007ffe0ffULL,
0x0000007f0b047810ULL, 0x000fe20007ffe0ffULL, 0x000004001a0f7a24ULL, 0x002fc600078e020fULL,
0xffffff8004047812ULL, 0x000fe200078ec0ffULL, 0x000003000f0b7a24ULL, 0x000fc600078e02ffULL,
0x00007000041a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000010b037824ULL, 0x000fc800078e0203ULL,
0x00007100ff1c7624ULL, 0x000fe200000e06ffULL, 0x000000010aff7812ULL, 0x000fe4000780f802ULL,
0x0000001a031a7211ULL, 0x000fc800078260ffULL, 0x0000001c031b7211ULL, 0x000fe400008f64ffULL,
0x0000700018227a10ULL, 0x000fc60007f3e0ffULL, 0x000008006b1a7825ULL, 0x000fc800078e001aULL,
0x00007100ff247624ULL, 0x000fe400008e06ffULL, 0x00000010051c7825ULL, 0x000fc800078e001aULL,
0x000000100d1a7825ULL, 0x000fe200078e001aULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000100e0d7824ULL, 0x004fe200078e00ffULL, 0x00000001ff1e7819ULL, 0x000fe2000001160eULL,
0x0000008003057824ULL, 0x000fe200078e00ffULL, 0x00000019ff037819ULL, 0x000fe40000011603ULL,
0x000000700d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c1e1e7812ULL, 0x000fe400078ec0ffULL,
0x0000700005207a10ULL, 0x000fc40007ebe006ULL, 0x000000220d057210ULL, 0x000fe40007a3e005ULL,
0x000000201e207210ULL, 0x040fe40007c7e00dULL, 0x00007100030d7a10ULL, 0x000fe40002fec4ffULL,
0x000000051e1e7210ULL, 0x000fe40007fbe0ffULL, 0x00000024ff037210ULL, 0x000fe40000fe4403ULL,
0x0000000dff217210ULL, 0x000fc40001fe84ffULL, 0x00000003ff1f7210ULL, 0x000fca0002ffe4ffULL,
0x0000000c1e007986ULL, 0x0003e8000c101906ULL, 0x0000000720007986ULL, 0x0003e4000c101906ULL,
0x000000ff0e00720cULL, 0x004fe20000705670ULL, 0x000000101c007986ULL, 0x000fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000141a007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0c7424ULL, 0x002fe200078e00ffULL, 0xffffffff19037810ULL, 0x000fc60007ffe0ffULL,
0x000070000f0c7625ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x000000030c0c79a8ULL, 0x000ea400099ee1c6ULL, 0x000000030c00720cULL, 0x004fc80003f05270ULL,
0x00000001ff057807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000005ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff037984ULL, 0x000ea40000000000ULL,
0x000000ff0300720cULL, 0x004fda0003f05270ULL, 0x0000261000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x000000100e037824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x002fe4000001160eULL,
0x000000220b0c7211ULL, 0x000fe400078038ffULL, 0x00000070030d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fe400078ec0ffULL, 0x000000240b037211ULL, 0x000fe400000f3cffULL,
0x0000000c050c7210ULL, 0x000fc8000791e00dULL, 0x00000003ff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c037981ULL, 0x000328000c1e1900ULL, 0x000080060c107981ULL, 0x000322000c1e1900ULL,
0x000000021900780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100060c127981ULL, 0x002322000c1e1900ULL, 0x000000041900780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180060c147981ULL, 0x002322000c1e1900ULL,
0x000000041900780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200060c167981ULL, 0x002322000c1e1900ULL, 0x000000061900780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280060c1a7981ULL, 0x002322000c1e1900ULL,
0x000000061900780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081900780cULL, 0x002fe20003f06070ULL, 0x000300060c1c7981ULL, 0x000318000c1e1900ULL,
0x000380060c1e0981ULL, 0x000324000c1e1900ULL, 0x0000000719057810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff057819ULL, 0x000fc80000011605ULL, 0x000000ff0500720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x000000180b077211ULL, 0x000fe200078038ffULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff207224ULL, 0x010fe200078e0003ULL, 0x0000700007077a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0b0f7211ULL, 0x000fe400000f3cffULL, 0x0000078007077810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff0f7a10ULL, 0x000fc400017e240fULL, 0x0000030011007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000405007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008110c7810ULL, 0x040fe40007ffe0ffULL,
0x00000001110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000002003037209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100e0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc8000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0xfffc80060c207981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000002110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001003037209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100e0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc8000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0xfffd00060c107981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000003110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001203037209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100e0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc8000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0xfffd80060c127981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000004110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001403037209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000040e0c7819ULL, 0x000fe400000006ffULL,
0x00000001ff0d7819ULL, 0x000fe4000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0xfffe00060c147981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000005110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001603037209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100e0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc8000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0xfffe80060c167981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000006110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001a03037209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100e0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc8000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0xffff00060c1a7981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e110c7810ULL, 0x042fe40007ffe0ffULL,
0x00000007110d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001c03037209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100e0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc8000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0xffff80060c1c7981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f110c7810ULL, 0x002fe40007ffe0ffULL,
0x0000001e03037209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x000000100e0c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc8000001160eULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c070c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060fULL, 0x000000060c1e7981ULL, 0x000326000c1e1900ULL,
0x0000040007077810ULL, 0x000fe40007f3e0ffULL, 0x0000000811117810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x00000000000e7919ULL, 0x000ea40000000000ULL, 0x000000040e057819ULL, 0x004fe400000006ffULL,
0x00000001ff077819ULL, 0x000fe4000001160eULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c070c7812ULL, 0x002fca00078ec0ffULL, 0x00000001050c7824ULL, 0x000fca00078e020cULL,
0x000000030c007388ULL, 0x0103e40000000800ULL, 0x0000700004047a10ULL, 0x000fe20007f3e0ffULL,
0x000000010a1d7824ULL, 0x000fe200078e020bULL, 0x000000070e00780cULL, 0x000fe20003f04070ULL,
0x000008006b0f7824ULL, 0x000fe200078e00ffULL, 0x00000002ff037819ULL, 0x002fe20000011602ULL,
0x00007100ff057624ULL, 0x000fe200008e06ffULL, 0x000000090a177211ULL, 0x000fe200078e68ffULL,
0x0000020002077824ULL, 0x000fe200078e00ffULL, 0x0000000103037812ULL, 0x000fe200078ec0ffULL,
0x000010001d0c7825ULL, 0x000fe200078e0004ULL, 0x00000001ff027819ULL, 0x000fe2000001160eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000f0c0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000020a108824ULL, 0x100fe200078e026bULL, 0x000000200e117810ULL, 0x000fe20007ffe0ffULL,
0x000000020a128824ULL, 0x000fe200078e026bULL, 0x0000700018187a10ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000700006167a10ULL, 0x000fe20007f3e0ffULL,
0x00000002101f8824ULL, 0x100fe200078e0203ULL, 0x0000080007067812ULL, 0x000fe200078ec0ffULL,
0x0000000212238824ULL, 0x000fe200078e0203ULL, 0x000000400e137810ULL, 0x040fe20007ffe0ffULL,
0x000000100e037824ULL, 0x000fe200078e00ffULL, 0x0000000c02027812ULL, 0x000fe200078ec0ffULL,
0x0000000117077824ULL, 0x000fe200078e0206ULL, 0x000000600e157810ULL, 0x040fe20007ffe0ffULL,
0x00007100ff197624ULL, 0x000fe200008e06ffULL, 0x0000007003037812ULL, 0x000fe200078ec0ffULL,
0x000000100e217824ULL, 0x000fe200078e0207ULL, 0x000000161d148211ULL, 0x000fe200078238ffULL,
0x0000001011067825ULL, 0x100fe200078e000cULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00007100ff1b7624ULL, 0x000fe200010e06ffULL, 0x000000181d1c8211ULL, 0x000fe200078438ffULL,
0x0000001013107825ULL, 0x000fe200078e000cULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000001031a7824ULL, 0x000fe200078e0202ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001015127825ULL, 0x100fe200078e000cULL, 0x000000191d158211ULL, 0x040fe200008f3cffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000003000a007a0cULL, 0x000fe20003f26070ULL,
0x000000100e0c7825ULL, 0x040fe200078e000cULL, 0x0000001b1d1d8211ULL, 0x000fe200010f3cffULL,
0x000000001a1a7984ULL, 0x000e620000000800ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x000000081f1f8824ULL, 0x100fe200078e020eULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000823258824ULL, 0x000fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c217faeULL, 0x0005e2000b901c46ULL, 0x000000100e148825ULL, 0x000fe200078e0014ULL,
0x000045801f238811ULL, 0x000fe200078e20ffULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000418025258811ULL, 0x000fe200078e20ffULL, 0x0038000006217faeULL, 0x0007e2000b901c46ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff3c7224ULL, 0x000fc400078e00ffULL,
0x0058000010217faeULL, 0x0007e2000b901c46ULL, 0x000000100e0c8825ULL, 0x004fc600078e001cULL,
0x0078000012217faeULL, 0x0007e2000b901c46ULL, 0x00000000001c7805ULL, 0x000fc6000001ff00ULL,
0x0000000014238faeULL, 0x0005e8000b901c46ULL, 0x000000000c258faeULL, 0x0003e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000207805ULL, 0x008fe2000001ff00ULL,
0x0000000000227805ULL, 0x004fe2000001ff00ULL, 0x0000000000247805ULL, 0x002fe2000001ff00ULL,
0x00000c7000001947ULL, 0x000fea0003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x0000000a003d7202ULL, 0x000fc80000000f00ULL, 0x000000023d3e7810ULL, 0x000fc80007ffe0ffULL,
0x000003003e007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x000000010b0d7824ULL, 0x100fe200078e023eULL, 0x000000070e00780cULL, 0x040fe40003f44070ULL,
0x00000001ff067819ULL, 0x000fe2000001163eULL, 0x000010000d027825ULL, 0x000fe200078e0004ULL,
0x000000400e437810ULL, 0x000fe40007ffe0ffULL, 0x0000000106067812ULL, 0x000fe400078ec0ffULL,
0x0000000f02107210ULL, 0x000fe20007f1e0ffULL, 0x000004003e027824ULL, 0x000fe200078e00ffULL,
0x000000600e457810ULL, 0x000fc60007ffe0ffULL, 0x000000020a07a824ULL, 0x100fe200078e026bULL,
0x0000080002027812ULL, 0x000fe200078ec0ffULL, 0x000000020a41a824ULL, 0x000fe200078e026bULL,
0x000000180d0ca211ULL, 0x000fe200078238ffULL, 0x000000020747a824ULL, 0x000fe200078e0206ULL,
0x000000200e077810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0603ULL,
0x000000160d12a211ULL, 0x000fe200078038ffULL, 0x0000000117037824ULL, 0x000fe400078e0202ULL,
0x000000024141a824ULL, 0x000fe200078e0206ULL, 0x000000190d13a211ULL, 0x040fe200000f3cffULL,
0x000000100e3f7824ULL, 0x000fe200078e0203ULL, 0x0000001b0d0da211ULL, 0x000fe200008f3cffULL,
0x0000001007027825ULL, 0x000fc800078e0010ULL, 0x000000084141a824ULL, 0x000fe400078e020eULL,
0x000000100e147825ULL, 0x000fc600078e0010ULL, 0x000045804141a811ULL, 0x000fe200078e20ffULL,
0x0000001043067825ULL, 0x100fe200078e0010ULL, 0x0000000e4743a211ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000143f7faeULL, 0x0003e4000b901c46ULL,
0x0000001045107825ULL, 0x000fe200078e0010ULL, 0x000041804343a811ULL, 0x000fe200078e20ffULL,
0x00380000023f7faeULL, 0x0003e4000b901c46ULL, 0x000000100e12a825ULL, 0x040fe400078e0012ULL,
0x00580000063f7faeULL, 0x0003e4000b901c46ULL, 0x000000100e0ca825ULL, 0x000fc400078e000cULL,
0x00780000103f7faeULL, 0x0003e8000b901c46ULL, 0x000000001241afaeULL, 0x0003e8000b901c46ULL,
0x000000000c43afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000403d027824ULL, 0x002fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x100fe2000001160eULL,
0x000000020a077824ULL, 0x000fe200078e026bULL, 0x00000002ff127819ULL, 0x000fe2000001160eULL,
0x000000100e037824ULL, 0x000fe200078e00ffULL, 0x0000008002027812ULL, 0x000fc400078ec0ffULL,
0x0000000812487810ULL, 0x040fe20007ffe0ffULL, 0x0000000812157824ULL, 0x000fe200078e00ffULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x0000010007067824ULL, 0x000fe200078e0002ULL,
0x0000000c0c027812ULL, 0x000fe200078ec0ffULL, 0x000000040e0c7824ULL, 0x000fe200078e00ffULL,
0x0000000212147810ULL, 0x040fe20007ffe0ffULL, 0x0000000812117824ULL, 0x000fe200078e00ffULL,
0x0000000602077210ULL, 0x000fe20007ffe003ULL, 0x0000000812427824ULL, 0x040fe200078e00ffULL,
0x0000000112067810ULL, 0x040fe20007ffe0ffULL, 0x0000000812457824ULL, 0x000fe200078e00ffULL,
0x0000000c0c467812ULL, 0x000fe200078ec0ffULL, 0x0000000812437824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee206ULL, 0x000004003d067824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000070d7984ULL, 0x000e620000000800ULL,
0x0000080006067812ULL, 0x000fe200078ec0ffULL, 0x00000008123d7824ULL, 0x040fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee212ULL, 0x0045800007137984ULL, 0x0004e20000000800ULL,
0x00000180170c7810ULL, 0x000fe20007ffe006ULL, 0x0000000812497824ULL, 0x040fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe400078ee214ULL, 0x0000000c11067211ULL, 0x000fe400078e20ffULL,
0x0000000412407810ULL, 0x000fe20007ffe0ffULL, 0x0000000848077824ULL, 0x004fe200078e00ffULL,
0x0000000312477819ULL, 0x000fe200000006ffULL, 0x0000000146067824ULL, 0x000fe200078e0206ULL,
0xfffffff845457812ULL, 0x000fc400078ee240ULL, 0xfffffff807077812ULL, 0x000fe400078ee248ULL,
0x0000000006147984ULL, 0x000ea20000000800ULL, 0x0000000512407810ULL, 0x040fe40007ffe0ffULL,
0x0000001007077824ULL, 0x000fe200078e020cULL, 0xffffffff12447810ULL, 0x000fc60007ffe0ffULL,
0x0000000146117824ULL, 0x000fe200078e0207ULL, 0xfffffff849497812ULL, 0x000fe200078ee244ULL,
0x0000001015077824ULL, 0x000fc600078e020cULL, 0x0000000011417984ULL, 0x0003e40000000800ULL,
0x0000000d1a0d7221ULL, 0x002fc80000010100ULL, 0x3fb8aa3b0d107820ULL, 0x000fe20000410000ULL,
0x00000003120d7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8423f7812ULL, 0x000fe200078ee20dULL,
0x0000001000107308ULL, 0x000ee20000000800ULL, 0x00000001460d7824ULL, 0x040fe400078e0207ULL,
0x000000103d077824ULL, 0x100fe400078e020cULL, 0x000000103f117824ULL, 0x000fe200078e020cULL,
0x000000000d3d7984ULL, 0x000fe60000000800ULL, 0x0000000146117824ULL, 0x000fe200078e0211ULL,
0x000400000d427984ULL, 0x0003e80000000800ULL, 0x0004000011447984ULL, 0x000fe20000000800ULL,
0x0000001310157220ULL, 0x008fe20000410000ULL, 0xfffffff843137812ULL, 0x000fe200078ee240ULL,
0x0000000146107824ULL, 0x000fe200078e0207ULL, 0x0000000612407810ULL, 0x000fe20007ffe0ffULL,
0x00000010450d7824ULL, 0x002fe200078e020cULL, 0x00001f1215077589ULL, 0x0002e200000e0000ULL,
0x0000003c153c7221ULL, 0x000fe20000010000ULL, 0xfffffff847477812ULL, 0x000fe200078ee240ULL,
0x00000001460d7824ULL, 0x000fe200078e020dULL, 0x00000000103f7984ULL, 0x000fe80000000800ULL,
0x0000000011407984ULL, 0x000fe20000000800ULL, 0x0000001013127824ULL, 0x002fc600078e020cULL,
0x00001f4815067589ULL, 0x000e6200000e0000ULL, 0x0000001047137824ULL, 0x100fe400078e020cULL,
0x00000010490c7824ULL, 0x000fe200078e020cULL, 0x000000000d157984ULL, 0x000fe20000000800ULL,
0x0000000146127824ULL, 0x040fe400078e0212ULL, 0x0000000146137824ULL, 0x040fe200078e0213ULL,
0x0004000010437984ULL, 0x0004620000000800ULL, 0x0000000c460c7210ULL, 0x000fc60007ffe0ffULL,
0x000400000d457984ULL, 0x0006620000000800ULL, 0x00005410ff107816ULL, 0x004fc60000000014ULL,
0x0000000012117984ULL, 0x000ea20000000800ULL, 0x00007610ff0d7816ULL, 0x008fe20000000014ULL,
0x0000000710397223ULL, 0x080fe20000010039ULL, 0x00005410ff107816ULL, 0x000fe2000000003dULL,
0x0000000013147984ULL, 0x000fe40000000800ULL, 0x000000070d387223ULL, 0x080fe20000010038ULL,
0x00005410ff0d7816ULL, 0x000fe20000000041ULL, 0x0000000710357223ULL, 0x000fe20000010035ULL,
0x0004000013467984ULL, 0x000fe60000000800ULL, 0x000000060d377223ULL, 0x002fe20000010037ULL,
0x00005410ff107816ULL, 0x000fc4000000003fULL, 0x00007610ff0d7816ULL, 0x000fe40000000041ULL,
0x0004000012417984ULL, 0x000e620000000800ULL, 0x0000000710317223ULL, 0x080fe40000010031ULL,
0x000000060d367223ULL, 0x000fe20000010036ULL, 0x000000000c107984ULL, 0x000ee20000000800ULL,
0x00007610ff0d7816ULL, 0x000fe2000000003dULL, 0x000000ffff3d7224ULL, 0x000fe400078e003eULL,
0x000400000c127984ULL, 0x0004640000000800ULL, 0x000000070d347223ULL, 0x000fe20000010034ULL,
0x00005410ff0d7816ULL, 0x000fc40000000042ULL, 0x000003003d007a0cULL, 0x000fe40003f06070ULL,
0x00005410ff0c7816ULL, 0x004fe20000000040ULL, 0x000000060d337223ULL, 0x000fe20000010033ULL,
0x00007610ff0d7816ULL, 0x000fc60000000042ULL, 0x000000070c2d7223ULL, 0x000fe2000001002dULL,
0x00007610ff0c7816ULL, 0x000fe20000000040ULL, 0x000000060d327223ULL, 0x000fe20000010032ULL,
0x00007610ff0d7816ULL, 0x000fc6000000003fULL, 0x000000070c2c7223ULL, 0x080fe2000001002cULL,
0x00005410ff0c7816ULL, 0x000fe20000000044ULL, 0x000000070d307223ULL, 0x000fe20000010030ULL,
0x00005410ff0d7816ULL, 0x000fc60000000043ULL, 0x000000060c2b7223ULL, 0x080fe2000001002bULL,
0x00005410ff0c7816ULL, 0x000fe20000000015ULL, 0x000000060d2f7223ULL, 0x000fe2000001002fULL,
0x00007610ff0d7816ULL, 0x000fc60000000043ULL, 0x000000070c297223ULL, 0x000fe20000010029ULL,
0x00007610ff0c7816ULL, 0x000fe20000000015ULL, 0x000000060d2e7223ULL, 0x000fe2000001002eULL,
0x00007610ff0d7816ULL, 0x000fc60000000044ULL, 0x000000070c287223ULL, 0x000fe20000010028ULL,
0x00005410ff0c7816ULL, 0x100fe20000000045ULL, 0x000000060d2a7223ULL, 0x000fe2000001002aULL,
0x00007610ff0d7816ULL, 0x000fc60000000045ULL, 0x000000060c277223ULL, 0x080fe20000010027ULL,
0x00005410ff0c7816ULL, 0x000fe20000000011ULL, 0x000000060d267223ULL, 0x000fe20000010026ULL,
0x00007610ff0d7816ULL, 0x002fc60000000041ULL, 0x000000070c257223ULL, 0x000fe20000010025ULL,
0x00007610ff0c7816ULL, 0x000fe20000000011ULL, 0x000000060d227223ULL, 0x000fe20000010022ULL,
0x00007610ff0d7816ULL, 0x000fc60000000046ULL, 0x000000070c247223ULL, 0x000fe20000010024ULL,
0x00005410ff0c7816ULL, 0x000fe20000000041ULL, 0x000000060d1e7223ULL, 0x000fc8000001001eULL,
0x000000060c237223ULL, 0x000fe20000010023ULL, 0x00005410ff0c7816ULL, 0x000fca0000000014ULL,
0x000000070c217223ULL, 0x000fe20000010021ULL, 0x00007610ff0c7816ULL, 0x000fca0000000014ULL,
0x000000070c207223ULL, 0x000fe20000010020ULL, 0x00005410ff0c7816ULL, 0x000fca0000000046ULL,
0x000000060c1f7223ULL, 0x000fe2000001001fULL, 0x00005410ff0c7816ULL, 0x008fca0000000010ULL,
0x000000070c3b7223ULL, 0x000fe2000001003bULL, 0x00007610ff0c7816ULL, 0x000fca0000000010ULL,
0x000000070c3a7223ULL, 0x000fe2000001003aULL, 0x00005410ff077816ULL, 0x000fca0000000012ULL,
0x00000006071d7223ULL, 0x000fe2000001001dULL, 0x00007610ff077816ULL, 0x000fca0000000012ULL,
0x00000006071c7223ULL, 0x000fe2000001001cULL, 0xfffff3b000008947ULL, 0x000fea000383ffffULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x0000000103047824ULL, 0x000fe200078e0202ULL,
0x0000017000007945ULL, 0x000ff60003800000ULL, 0x000000800a058824ULL, 0x000fc800078e0203ULL,
0x0000000102058824ULL, 0x000fca00078e0205ULL, 0x0049803c05008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800004027984ULL, 0x000e680000000800ULL,
0x004a000004037984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000302027221ULL, 0x004fca0000010000ULL, 0x0180000002037810ULL, 0x000fc80007ffe0ffULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0002ULL, 0x0000b4b0000b7802ULL, 0x000fc40000000f00ULL,
0x0000a58000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0006ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000003ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000ea20000000000ULL, 0x000000080808723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff067819ULL, 0x004fe4000001160eULL,
0x000000080e0c7811ULL, 0x000fe400078ff0ffULL, 0x0000000206057810ULL, 0x040fe20007ffe0ffULL,
0x00001f0603027589ULL, 0x000ea200000e0000ULL, 0x0000000806127824ULL, 0x040fe200078e00ffULL,
0x00000003060d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000806107824ULL, 0x040fe200078e00ffULL,
0x00001f0c03047589ULL, 0x00066200000e0000ULL, 0x0000000806147824ULL, 0x000fe200078e00ffULL,
0xfffffff8120b7812ULL, 0x000fe200078ee205ULL, 0x0000000806167824ULL, 0x040fe200078e00ffULL,
0x0000000506057810ULL, 0x040fe20007ffe0ffULL, 0x0000000806137824ULL, 0x040fe200078e00ffULL,
0x00000004060f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000806157824ULL, 0x000fe200078e00ffULL,
0xfffffff814117812ULL, 0x000fe200078ee205ULL, 0x000000040e057824ULL, 0x000fe200078e00ffULL,
0x0000000106037810ULL, 0x008fe20007ffe0ffULL, 0x000000080c177824ULL, 0x000fe200078e00ffULL,
0xfffffff8140d7812ULL, 0x000fe200078ee20dULL, 0x000000100b0b7824ULL, 0x100fe200078e0200ULL,
0xfffffff810077812ULL, 0x002fe200078ee203ULL, 0x0000001011117824ULL, 0x100fe200078e0200ULL,
0x0000000306037819ULL, 0x040fe200000006ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0200ULL,
0x0000000606107810ULL, 0x000fe20007ffe0ffULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0xfffffff803037812ULL, 0x000fe200078ee206ULL, 0x0000003902397220ULL, 0x004fe20000410000ULL,
0xffffffff06127810ULL, 0x000fe20007ffe0ffULL, 0x0000003802387220ULL, 0x000fe20000410000ULL,
0xfffffff8160f7812ULL, 0x000fe200078ee20fULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000000c05067812ULL, 0x000fe200078ec0ffULL, 0x0000003402347220ULL, 0x040fe20000410000ULL,
0xfffffff813137812ULL, 0x000fe200078ee210ULL, 0x0000001003037824ULL, 0x000fe200078e0200ULL,
0xfffffff815157812ULL, 0x000fe200078ee212ULL, 0x0000003102317220ULL, 0x040fe20000410000ULL,
0xfffffff817177812ULL, 0x000fe200078ee20cULL, 0x0000003002307220ULL, 0x000fe20000410000ULL,
0x000000393838723eULL, 0x000fe200000010ffULL, 0x0000002d022d7220ULL, 0x000fe20000410000ULL,
0x000000353434723eULL, 0x000fe200000010ffULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000000013137211ULL, 0x000fe200078e20ffULL, 0x0000002902297220ULL, 0x000fe20000410000ULL,
0x000000313030723eULL, 0x000fe200000010ffULL, 0x0000002802287220ULL, 0x000fe20000410000ULL,
0x0000002d2c2c723eULL, 0x000fe200000010ffULL, 0x0000003704377220ULL, 0x000fc40000410000ULL,
0x0000003604367220ULL, 0x000fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000010ffULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000003204327220ULL, 0x000fe20000410000ULL,
0x000000373636723eULL, 0x000fe200000010ffULL, 0x0000002f042f7220ULL, 0x040fe40000410000ULL,
0x0000002e042e7220ULL, 0x000fe20000410000ULL, 0x000000333232723eULL, 0x000fe200000010ffULL,
0x0000002b042b7220ULL, 0x000fc40000410000ULL, 0x0000002a042a7220ULL, 0x000fe20000410000ULL,
0x0000002f2e2e723eULL, 0x000fe200000010ffULL, 0x0000002704277220ULL, 0x040fe40000410000ULL,
0x0000002604267220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000010ffULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x0000001f041f7220ULL, 0x000fc40000410000ULL,
0x0000001e041e7220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000010ffULL,
0x0000001d041d7220ULL, 0x000fe40000410000ULL, 0x0000002502257220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000010ffULL, 0x0000002402247220ULL, 0x000fe40000410000ULL,
0x0000001c04047220ULL, 0x000fe40000410000ULL, 0x000000100f0f7824ULL, 0x000fe200078e0200ULL,
0x000000252424723eULL, 0x000fe200000010ffULL, 0x0000000103037824ULL, 0x000fe200078e0206ULL,
0x0000001d0404723eULL, 0x000fe200000010ffULL, 0x0000002102217220ULL, 0x000fc40000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000003803007388ULL, 0x000fe20000000800ULL,
0x0000003b023b7220ULL, 0x000fe40000410000ULL, 0x0000000106077824ULL, 0x000fe200078e0207ULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000003a02027220ULL, 0x000fe40000410000ULL,
0x00000001060b7824ULL, 0x000fe200078e020bULL, 0x0000003407007388ULL, 0x000fe20000000800ULL,
0x0000001015157824ULL, 0x100fe200078e0200ULL, 0x0000003b0202723eULL, 0x000fe200000010ffULL,
0x0000001017177824ULL, 0x000fe200078e0200ULL, 0x000000300b007388ULL, 0x000fe20000000800ULL,
0x00000001060d7824ULL, 0x000fc400078e020dULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x0000001706177210ULL, 0x040fe20007ffe0ffULL, 0x0000000106057824ULL, 0x040fe200078e0211ULL,
0x0000002c0d007388ULL, 0x000fe20000000800ULL, 0x00000001061d7824ULL, 0x040fe400078e0213ULL,
0x00000001061f7824ULL, 0x000fe200078e0215ULL, 0x000000280f007388ULL, 0x000fe20000000800ULL,
0x000000016f007824ULL, 0x000fc600078e020eULL, 0x0000002405007388ULL, 0x000fe20000000800ULL,
0x0000001000007824ULL, 0x000fc600078e0209ULL, 0x000000201d007388ULL, 0x000fe80000000800ULL,
0x000000021f007388ULL, 0x000fe80000000800ULL, 0x0000003617007388ULL, 0x000fe80000000800ULL,
0x0004003207007388ULL, 0x000fe80000000800ULL, 0x0004002e0b007388ULL, 0x000fe80000000800ULL,
0x0004002a0d007388ULL, 0x000fe80000000800ULL, 0x000400260f007388ULL, 0x000fe80000000800ULL,
0x0004002205007388ULL, 0x000fe80000000800ULL, 0x0004001e1d007388ULL, 0x000fe80000000800ULL,
0x000400041f007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000107984ULL, 0x000e680000000c00ULL, 0x0004000000187984ULL, 0x000ea80000000c00ULL,
0x0008000000147984ULL, 0x000ee80000000c00ULL, 0x000c0000002c7984ULL, 0x000ee20000000c00ULL,
0x3f803f8008137831ULL, 0x002fc40000200013ULL, 0x3f803f8008127831ULL, 0x040fe40000200012ULL,
0x3f803f8008117831ULL, 0x040fe40000200011ULL, 0x3f803f8008107831ULL, 0x040fe40000200010ULL,
0x3f803f80081b7831ULL, 0x044fe4000020001bULL, 0x3f803f80081a7831ULL, 0x040fe4000020001aULL,
0x3f803f8008197831ULL, 0x000fc40000200019ULL, 0x3f803f8008187831ULL, 0x000fe40000200018ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f801b1b7831ULL, 0x000fc4000020002fULL, 0x3f803f801a1a7831ULL, 0x000fe2000020002eULL,
0x0000001000007388ULL, 0x000fe20000000c00ULL, 0x3f803f8019197831ULL, 0x000fe4000020002dULL,
0x3f803f8018187831ULL, 0x000fca000020002cULL, 0x0004001800007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x002fc8000001160eULL,
0x000000730500720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000047b06ULL, 0x000e620000209000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0c7a12ULL, 0x000fe200078e33ffULL, 0x0000000172007824ULL, 0x000fe200078e0205ULL,
0x000000200e0f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e020eULL,
0x000000070e087812ULL, 0x000fc800078ec0ffULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x0000000400047308ULL, 0x002e640000001000ULL, 0x0ffffffe04067810ULL, 0x002fe40007ffe0ffULL,
0x0ffffff805047812ULL, 0x000fc800078ef80eULL, 0x0000000600037305ULL, 0x000e62000021f000ULL,
0x0000001004047824ULL, 0x000fe400078e0209ULL, 0x000000ffff077224ULL, 0x002fc800078e0a03ULL,
0x00005a0007077a24ULL, 0x000fc800078e02ffULL, 0x00000007030d7227ULL, 0x000fe400078e0002ULL,
0x0000000004047984ULL, 0x000e680000000c00ULL, 0x000000000d027227ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a02ULL, 0x00005a0003037a24ULL, 0x000fca00078e0200ULL,
0x00005a0003007a0cULL, 0x000fda0003f06070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x0000000102020810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f26070ULL,
0x00005a00ff007a0cULL, 0x000fd60003f05070ULL, 0x0000000102021810ULL, 0x000fc80007ffe0ffULL,
0x000000020c027207ULL, 0x000fca0004000000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a02ULL,
0x0000590002037a24ULL, 0x000fe400078e0271ULL, 0x00005a000b007a24ULL, 0x000fe200078e0200ULL,
0x000000086b0b7211ULL, 0x000fc600078e18ffULL, 0x00005a0003037a24ULL, 0x000fca00078e0200ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4400ULL,
0x00000003ff007819ULL, 0x000fc6000001160fULL, 0x000000100b027825ULL, 0x000fe200078e0002ULL,
0x000000730000720cULL, 0x000fc80003f26070ULL, 0x0000000402007986ULL, 0x0023f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000172027824ULL, 0x102fe200078e0200ULL,
0x000000400e117810ULL, 0x000fe20007ffe0ffULL, 0x000000010f007824ULL, 0x000fc400078e0200ULL,
0x000000020d037227ULL, 0x000fc600078e00ffULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fc600078e0a03ULL, 0x0ffffff800007812ULL, 0x000fe200078ef80fULL,
0x00005a0005047a24ULL, 0x000fc800078e0202ULL, 0x0000001000007824ULL, 0x000fe200078e0209ULL,
0x00005a0004007a0cULL, 0x000fda0003f26070ULL, 0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103031810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f46070ULL,
0x0000000000047984ULL, 0x0002a40000000c00ULL, 0x00000003ff007819ULL, 0x002fd20000011611ULL,
0x0000000103032810ULL, 0x000fc80007ffe0ffULL, 0x000000030c087207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL, 0x0000590008037a24ULL, 0x000fe200078e0271ULL,
0x000000070f087812ULL, 0x000fe200078ec0ffULL, 0x00005a000b027a24ULL, 0x000fc800078e0202ULL,
0x00005a0003037a24ULL, 0x000fe400078e0202ULL, 0x000000086b0b7824ULL, 0x000fc600078e0208ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440aULL,
0x000000730000720cULL, 0x000fc60003f26070ULL, 0x000000100b027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000172027824ULL, 0x102fe200078e0200ULL, 0x000000600e0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111007824ULL, 0x000fe400078e0200ULL, 0x000000020d037227ULL, 0x000fc600078e00ffULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e0a03ULL,
0x0ffffff800007812ULL, 0x000fe200078ef811ULL, 0x00005a0005047a24ULL, 0x000fc600078e0202ULL,
0x0000000900007211ULL, 0x000fe400078e20ffULL, 0x00005a0004007a0cULL, 0x000fda0003f26070ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000103031810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0000000000047984ULL, 0x0002a40000000c00ULL,
0x00000003ff007819ULL, 0x002fd2000001160fULL, 0x0000000103032810ULL, 0x000fe20007ffe0ffULL,
0x0000000172727824ULL, 0x000fc600078e0200ULL, 0x000000030c087207ULL, 0x000fca0004000000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0a08ULL, 0x0000590008037a24ULL, 0x000fe200078e0271ULL,
0x0000000711087812ULL, 0x000fe200078ec0ffULL, 0x00005a000b027a24ULL, 0x000fc800078e0202ULL,
0x00005a0003037a24ULL, 0x000fe400078e0202ULL, 0x000000086b0b7824ULL, 0x000fc600078e0208ULL,
0x0000000374037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440aULL,
0x000000730000720cULL, 0x000fc60003f26070ULL, 0x000000100b027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x0043ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000720d027227ULL, 0x002fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fe400078e0a02ULL,
0x000000010f007824ULL, 0x000fe400078e0200ULL, 0x00005a0003037a24ULL, 0x000fc600078e0272ULL,
0x0000000700007812ULL, 0x000fe400078ec0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f26070ULL,
0xfffffff800007812ULL, 0x000fca00078ef80fULL, 0x0000001000097824ULL, 0x000fe200078e0209ULL,
0x000000070f007812ULL, 0x000fca00078ec0ffULL, 0x80005a0003031a10ULL, 0x000fe20007ffe0ffULL,
0x0000000009087984ULL, 0x000e620000000c00ULL, 0x0000000102021810ULL, 0x000fe20007ffe0ffULL,
0x000000086b6b7824ULL, 0x000fe200078e0200ULL, 0x00005a0003007a0cULL, 0x000fda0003f46070ULL,
0x0000000102022810ULL, 0x000fc80007ffe0ffULL, 0x000000020c027207ULL, 0x000fca0004000000ULL,
0x000000ffff057224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e0271ULL,
0x00005a0005727a24ULL, 0x000fc800078e0272ULL, 0x00005a0003037a24ULL, 0x000fca00078e0272ULL,
0x0000000374037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4404ULL,
0x000000106b027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff047819ULL, 0x000fe20000011602ULL,
0xffffffffff0f7424ULL, 0x000fc600078e00ffULL, 0x0000000403047211ULL, 0x000fc800078e08ffULL,
0x0000006d0400720cULL, 0x000fda0003f06070ULL, 0x0000000279098824ULL, 0x000fc800078e00ffULL,
0x00006a0009098a24ULL, 0x000fc800078e0204ULL, 0x0000660009088625ULL, 0x002fe200078e0054ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006080f8981ULL, 0x000ea2000c1e1900ULL,
0x00000001030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000004002787824ULL, 0x000fe400078e00ffULL,
0x0000008077777824ULL, 0x000fe200078e00ffULL, 0x0000005e0b00720cULL, 0x000fe20003f06070ULL,
0x00005800ff0b7624ULL, 0x000fe200078e00ffULL, 0x01b60000ff067f8cULL, 0x000e62000c80043fULL,
0x0000008071687824ULL, 0x000fe400078e00ffULL, 0x00000100030d7824ULL, 0x000fe200078e0278ULL,
0x0000001f0b0b7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff117424ULL, 0x000fc600078e00ffULL,
0x00000005ff0b7819ULL, 0x000fe4000001160bULL, 0x00000040680e7812ULL, 0x000fe200078ef80dULL,
0x000000770f087224ULL, 0x004fc800078e02ffULL, 0x0000640008087625ULL, 0x000fe200078e0011ULL,
0x00000c7000008947ULL, 0x000fea0003800000ULL, 0x00000003ff237819ULL, 0x002fe40000011605ULL,
0x0000000d69227217ULL, 0x000fe40007800000ULL, 0x0000000823157810ULL, 0x040fe20007ffe0ffULL,
0x000000010e107824ULL, 0x000fe200078e0223ULL, 0x0000000423117810ULL, 0x040fe20007ffe0ffULL,
0x0000000122227824ULL, 0x000fe200078e0a0dULL, 0x0000000c23177810ULL, 0x000fe20007ffe0ffULL,
0x0000000115137824ULL, 0x000fe200078e0205ULL, 0x00000005110d7210ULL, 0x000fe20007ffe0ffULL,
0x00000008152c7824ULL, 0x000fe200078e00ffULL, 0x000000221100720cULL, 0x000fe20003fa6070ULL,
0x000000010e127824ULL, 0x000fe200078e0211ULL, 0x00000010231b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000117147824ULL, 0x000fe200078e0205ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee213ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000001423257810ULL, 0x000fc40007ffe0ffULL,
0x0000001823297810ULL, 0x000fe20007ffe0ffULL, 0x00000008171d7824ULL, 0x000fe200078e00ffULL,
0x0000007012197812ULL, 0x000fe200078ef80cULL, 0x00000008112a7824ULL, 0x000fe200078e00ffULL,
0x000000150e127210ULL, 0x000fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000001908187210ULL, 0x000fe40007f3e0ffULL, 0xfffffff81d2e7812ULL, 0x000fe200078ee214ULL,
0x000000010e147824ULL, 0x000fe200078e0217ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20dULL,
0x0000000109197824ULL, 0x000fe200008e0613ULL, 0x00000070100d7812ULL, 0x000fe200078ef80cULL,
0x000000011b267824ULL, 0x000fe200078e0205ULL, 0x000000221500720cULL, 0x000fe20003f26070ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000000d08107210ULL, 0x000fc40007f1e0ffULL,
0x0000001c23337810ULL, 0x000fe20007ffe0ffULL, 0x000000081b1f7824ULL, 0x000fe200078e00ffULL,
0x0000007014217812ULL, 0x000fe200078ef80cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000221700720cULL, 0x080fe40003f46070ULL, 0xfffffff81f267812ULL, 0x000fe200078ee226ULL,
0x000000010e1a7824ULL, 0x000fe200078e0225ULL, 0x0000002108207210ULL, 0x000fe20007f9e0ffULL,
0x0000000109117824ULL, 0x000fe200000e0611ULL, 0x000000221b00720cULL, 0x000fe20003f06070ULL,
0x000000010e167824ULL, 0x000fe200078e021bULL, 0x00000070121f7812ULL, 0x000fe200078ef80cULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x00000020232b7810ULL, 0x000fc40007ffe0ffULL,
0x0000001f081e7210ULL, 0x000fe20007f7e0ffULL, 0x000000010e1c7824ULL, 0x000fe200078e0229ULL,
0x00000024232d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109217824ULL, 0x000fe200020e0615ULL,
0x000000701a157812ULL, 0x100fe200078ef80cULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x00000028232f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001508147210ULL, 0x000fe20007f9e0ffULL,
0x00000001091f7824ULL, 0x000fe200018e0613ULL, 0x000000701c137812ULL, 0x000fe200078ef80cULL,
0x000000010e1a7824ULL, 0x000fe200078e0233ULL, 0x00000005231c7210ULL, 0x000fe20007ffe0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000001308127210ULL, 0x000fc40007fde0ffULL,
0x000000071c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000109157824ULL, 0x040fe200020e061bULL,
0x00000070160d7812ULL, 0x100fe200078ef80cULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0ffffff81c247812ULL, 0x000fe400078ef805ULL, 0x0000000d08167210ULL, 0x000fe20007f7e0ffULL,
0x0000000109137824ULL, 0x000fe200030e061dULL, 0x000000701a1d7812ULL, 0x000fe200078ef80cULL,
0x000000010e1c7824ULL, 0x000fe200078e022bULL, 0x00001000020d7811ULL, 0x000fe200078e70ffULL,
0x0000000125277824ULL, 0x040fe200078e0205ULL, 0x0000001d081a7210ULL, 0x000fe20007fde0ffULL,
0x0000000825307824ULL, 0x000fe200078e00ffULL, 0x000000222300720cULL, 0x000fe20003f86070ULL,
0x000001001c1c7825ULL, 0x000fc600078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee227ULL,
0x0000000109177824ULL, 0x000fe200018e0617ULL, 0x000000222500720cULL, 0x080fe20003f66070ULL,
0x0000001024277824ULL, 0x000fe200078e020dULL, 0x000000701c257812ULL, 0x000fe200078ef80cULL,
0x000000010e247824ULL, 0x000fe400078e022dULL, 0x00000001091b7824ULL, 0x000fe200030e061bULL,
0x00000025081c7210ULL, 0x000fe20007fde0ffULL, 0x0000010024247825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010277faeULL, 0x0003e2000e101c46ULL,
0x000000222900720cULL, 0x000fc40003f86070ULL, 0x000000010e287824ULL, 0x000fe200078e022fULL,
0x0000001d091d7210ULL, 0x000fe200037fe4ffULL, 0x0000000129317824ULL, 0x040fe400078e0205ULL,
0x0000000829327824ULL, 0x000fe200078e00ffULL, 0x0000007024297812ULL, 0x000fe200078ef80cULL,
0x000000102a277824ULL, 0x002fc600078e020dULL, 0x0000002908247210ULL, 0x000fe20007fde0ffULL,
0x0000010028107825ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee231ULL,
0x0000000018277faeULL, 0x0003e2000e901c46ULL, 0x000000223300720cULL, 0x040fe20003fa6070ULL,
0x0000000133287824ULL, 0x040fe200078e0205ULL, 0x0000007010297812ULL, 0x000fe200078ef80cULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000002c23317810ULL, 0x000fe20007ffe0ffULL,
0x0000000109257824ULL, 0x000fe200030e0625ULL, 0x0000002908107210ULL, 0x000fe20007fde0ffULL,
0x000000102c297824ULL, 0x000fe200078e020dULL, 0xfffffff833347812ULL, 0x000fe200078ee228ULL,
0x000000012b287824ULL, 0x000fc400078e0205ULL, 0x000000082b337824ULL, 0x040fe200078e00ffULL,
0x000000001e297faeULL, 0x0005e2000c901c46ULL, 0x000000102e277824ULL, 0x002fe200078e020dULL,
0x000000222b00720cULL, 0x080fe20003f26070ULL, 0x000000010e187824ULL, 0x000fe200078e0231ULL,
0xfffffff833287812ULL, 0x000fe200078ee228ULL, 0x0000000109117824ULL, 0x000fe200030e0611ULL,
0x0000003023337810ULL, 0x000fe20007ffe0ffULL, 0x0000000020277faeULL, 0x0003e2000d101c46ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000222d00720cULL, 0x000fc60003f46070ULL,
0x00000010261f7824ULL, 0x104fe200078e020dULL, 0x00000070182b7812ULL, 0x000fe200078ef80cULL,
0x0000001034297824ULL, 0x000fe400078e020dULL, 0x000000012d2a7824ULL, 0x040fe200078e0205ULL,
0x00000000161f7faeULL, 0x0005e2000c101c46ULL, 0x0000002b08187210ULL, 0x000fe20007fde0ffULL,
0x0000001030217824ULL, 0x102fe200078e020dULL, 0x000000032d2d7819ULL, 0x000fe200000006ffULL,
0x0000001032277824ULL, 0x000fe400078e020dULL, 0x0000000109197824ULL, 0x000fe200030e0619ULL,
0x0000000014217faeULL, 0x0003e2000d901c46ULL, 0x00000010282b7824ULL, 0x000fe200078e020dULL,
0xfffffff82d2a7812ULL, 0x000fc400078ee22aULL, 0x0000000012277faeULL, 0x0007e2000e101c46ULL,
0x000000010e167824ULL, 0x004fe200078e0233ULL, 0x0000003423177810ULL, 0x000fe20007ffe0ffULL,
0x000000102a2d7824ULL, 0x000fe200078e020dULL, 0x000000001a297faeULL, 0x0005e2000e901c46ULL,
0x000000222f00720cULL, 0x080fe40003fa6070ULL, 0x00000038231f7810ULL, 0x000fe20007ffe0ffULL,
0x000000001c2b7faeULL, 0x0009e2000c901c46ULL, 0x000000170e147210ULL, 0x002fe40007ffe0ffULL,
0x000000223300720cULL, 0x080fe20003f66070ULL, 0x0000010016127825ULL, 0x008fe200078e00ffULL,
0x000000223100720cULL, 0x080fe20003f86070ULL, 0x00000000242d7faeULL, 0x0003e2000d101c46ULL,
0x0000003c23237810ULL, 0x000fe20007ffe0ffULL, 0x000000012f167824ULL, 0x040fe200078e0205ULL,
0x0000007012157812ULL, 0x000fe200078ef80cULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x000000221700720cULL, 0x000fe20003f46070ULL, 0x000000010e217824ULL, 0x000fe200078e021fULL,
0x0000001508127210ULL, 0x000fe20007fde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0xfffffff82f1c7812ULL, 0x010fc400078ee216ULL, 0x000000221f00720cULL, 0x080fe20003f26070ULL,
0x0000000109137824ULL, 0x000fe200030e0613ULL, 0x00000070141b7812ULL, 0x004fe200078ef80cULL,
0x0000000133147824ULL, 0x100fe200078e0205ULL, 0x000000222300720cULL, 0x000fe20003f06070ULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000001b081a7210ULL, 0x000fe20007fde0ffULL,
0x0000000131167824ULL, 0x040fe400078e0205ULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0xfffffff833207812ULL, 0x000fe200078ee214ULL, 0x00000001091b7824ULL, 0x000fc400030e0615ULL,
0x0000010021147825ULL, 0x000fe200078e00ffULL, 0xfffffff8311e7812ULL, 0x000fe400078ee216ULL,
0x000000051f217210ULL, 0x000fe20007ffe0ffULL, 0x000000010e167824ULL, 0x000fe400078e0223ULL,
0x00000001171d7824ULL, 0x040fe400078e0205ULL, 0x0000000817227824ULL, 0x000fe400078e00ffULL,
0x000000081f247824ULL, 0x002fe200078e00ffULL, 0x00000070141f7812ULL, 0x000fe200078ef80cULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0xfffffff8220e7812ULL, 0x000fc400078ee21dULL,
0x0000001f08147210ULL, 0x000fe20007fde0ffULL, 0x0000000123057824ULL, 0x040fe200078e0205ULL,
0xfffffff824227812ULL, 0x000fe200078ee221ULL, 0x0000000823267824ULL, 0x000fe200078e00ffULL,
0x0000007016217812ULL, 0x000fe200078ef80cULL, 0x0000000109157824ULL, 0x000fe400030e0615ULL,
0x000000101e1d7824ULL, 0x000fe200078e020dULL, 0xfffffff826247812ULL, 0x000fe200078ee205ULL,
0x000000101c057824ULL, 0x100fe200078e020dULL, 0x0000002108087210ULL, 0x000fe20007fde0ffULL,
0x00000010201f7824ULL, 0x000fc400078e020dULL, 0x000000100e217824ULL, 0x100fe200078e020dULL,
0x0000001709097210ULL, 0x000fe200037fe4ffULL, 0x0000001022237824ULL, 0x100fe200078e020dULL,
0x0000000010057faeULL, 0x0003e2000e901c46ULL, 0x00000010240d7824ULL, 0x000fc600078e020dULL,
0x00000000181d7faeULL, 0x0003e8000e101c46ULL, 0x00000000121f7faeULL, 0x0003e8000d901c46ULL,
0x000000001a217faeULL, 0x0003e8000d101c46ULL, 0x0000000014237faeULL, 0x0003e8000c901c46ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x0000000405147811ULL, 0x042fe400078fe8ffULL, 0x0000000805157811ULL, 0x000fc400078fe8ffULL,
0x0000000c05167811ULL, 0x040fe200078fe8ffULL, 0x00000001140d7824ULL, 0x140fe200078e0205ULL,
0x0000001c05207811ULL, 0x040fe200078fe8ffULL, 0x0000000814367824ULL, 0x000fe200078e00ffULL,
0x0000001005187811ULL, 0x000fe200078fe8ffULL, 0x0000000115107824ULL, 0x100fe200078e0205ULL,
0x00000014051a7811ULL, 0x000fe200078fe8ffULL, 0x0000000815137824ULL, 0x000fe200078e00ffULL,
0x00000018051c7811ULL, 0x040fe200078fe8ffULL, 0x0000000116117824ULL, 0x000fe200078e0205ULL,
0xfffffff836367812ULL, 0x000fe200078ee20dULL, 0x00000008163c7824ULL, 0x000fe200078e00ffULL,
0x00000028051e7811ULL, 0x000fe200078fe8ffULL, 0x0000000120127824ULL, 0x140fe200078e0205ULL,
0xfffffff8133a7812ULL, 0x000fe200078ee210ULL, 0x0000000820177824ULL, 0x000fe200078e00ffULL,
0x0000002c05387811ULL, 0x000fe200078fe8ffULL, 0x00000001180d7824ULL, 0x000fe200078e0205ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee211ULL, 0x00000008183e7824ULL, 0x000fe200078e00ffULL,
0x000000051c117210ULL, 0x080fe20007ffe0ffULL, 0x000000011a107824ULL, 0x040fe200078e0205ULL,
0xfffffff817447812ULL, 0x000fe200078ee212ULL, 0x000000081a137824ULL, 0x000fe200078e00ffULL,
0x00000024051f7811ULL, 0x040fe200078fe8ffULL, 0x000000081c427824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x000000011e127824ULL, 0x040fe200078e0205ULL,
0x00000020050d7811ULL, 0x000fe200078fe8ffULL, 0x000000081e377824ULL, 0x000fe200078e00ffULL,
0xfffffff813407812ULL, 0x000fe200078ee210ULL, 0x0000000838247824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee211ULL, 0x000000011f117824ULL, 0x140fe200078e0205ULL,
0x0000000538137210ULL, 0x080fe20007ffe0ffULL, 0x000000081f227824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee212ULL, 0x000000010d107824ULL, 0x000fe200078e0205ULL,
0x0000000505127211ULL, 0x080fe200078fe8ffULL, 0x000000080d337824ULL, 0x000fe200078e00ffULL,
0xfffffff824177812ULL, 0x000fe200078ee213ULL, 0x0000000116167824ULL, 0x100fe200078e020eULL,
0x0000003405137811ULL, 0x040fe200078fe8ffULL, 0x0000000118187824ULL, 0x100fe200078e020eULL,
0x0000003805197811ULL, 0x040fe200078fe8ffULL, 0x000000011a1a7824ULL, 0x100fe200078e020eULL,
0xfffffff822357812ULL, 0x000fe200078ee211ULL, 0x000000010e2e7824ULL, 0x000fe200078e0213ULL,
0x0000003005117811ULL, 0x000fe200078fe8ffULL, 0x00000008132c7824ULL, 0x000fe200078e00ffULL,
0x0000000712247812ULL, 0x000fe200078ec0ffULL, 0x0000000114127824ULL, 0x000fe200078e020eULL,
0xfffffff833337812ULL, 0x000fe200078ee210ULL, 0x0000000115147824ULL, 0x000fe200078e020eULL,
0x0000003c051b7811ULL, 0x000fe200078fe8ffULL, 0x0000000113157824ULL, 0x000fe200078e0205ULL,
0x0000000e05107211ULL, 0x000fe200078fe8ffULL, 0x0000000819307824ULL, 0x040fe200078e00ffULL,
0x0000000519137210ULL, 0x000fe20007ffe0ffULL, 0x000000010e227824ULL, 0x000fe200078e020dULL,
0x0ffffff824247812ULL, 0x100fe200078ef805ULL, 0x00000001110d7824ULL, 0x040fe200078e0205ULL,
0xfffffff830307812ULL, 0x000fe200078ee213ULL, 0x000000010e347824ULL, 0x040fe200078e0211ULL,
0x0000001f0e1f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000811287824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee215ULL, 0x000000011b057824ULL, 0x000fc400078e0205ULL,
0x000000081b327824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee20dULL,
0x000000010e2a7824ULL, 0x000fe200078e0219ULL, 0x0000100002197811ULL, 0x000fe200078e70ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe400078ee205ULL,
0x0000001940277211ULL, 0x080fe200078e20ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000007010057812ULL, 0x000fe400078ef80cULL, 0x0000001932327211ULL, 0x000fe200078e20ffULL,
0x000000011c1c7824ULL, 0x100fe200078e020eULL, 0x0000000508107210ULL, 0x000fe20007f1e0ffULL,
0x0000000120207824ULL, 0x000fc400078e020eULL, 0x000000010e1e7824ULL, 0x040fe400078e021eULL,
0x000000010e387824ULL, 0x040fe400078e0238ULL, 0x000000010e267824ULL, 0x000fe400078e021bULL,
0x0000010014147825ULL, 0x000fc800078e00ffULL, 0x00000010170e7824ULL, 0x000fe200078e0219ULL,
0x0000007012177812ULL, 0x100fe200078ef80cULL, 0x0000000109117824ULL, 0x000fe200000e0611ULL,
0x00000070141b7812ULL, 0x000fe200078ef80cULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0000001708127210ULL, 0x040fe40007f3e0ffULL, 0x0000001b08147210ULL, 0x000fe20007f1e0ffULL,
0x0000010016167825ULL, 0x000fc800078e00ffULL, 0x0000000109157824ULL, 0x000fe200000e0615ULL,
0x0000007016217812ULL, 0x000fe200078ef80cULL, 0x000001001a1a7825ULL, 0x000fc600078e00ffULL,
0x0000002108167210ULL, 0x000fe20007f1e0ffULL, 0x0000001024317824ULL, 0x100fe200078e0219ULL,
0x000000701c217812ULL, 0x100fe200078ef80cULL, 0x00000010362f7824ULL, 0x100fe200078e0219ULL,
0x000000701a237812ULL, 0x000fe200078ef80cULL, 0x000000103a2d7824ULL, 0x100fe200078e0219ULL,
0x00000021081c7210ULL, 0x000fe20007f5e0ffULL, 0x000000103c2b7824ULL, 0x100fe200078e0219ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000103e297824ULL, 0x100fe400078e0219ULL, 0x00000010420d7824ULL, 0x000fc400078e0219ULL,
0x0000001044057824ULL, 0x100fe400078e0219ULL, 0x0000001033337824ULL, 0x100fe400078e0219ULL,
0x0000001035357824ULL, 0x100fe400078e0219ULL, 0x0000001037377824ULL, 0x100fe400078e0219ULL,
0x0000001028287824ULL, 0x100fe400078e0219ULL, 0x000000102c2c7824ULL, 0x000fc400078e0219ULL,
0x0000001030307824ULL, 0x000fe400078e0219ULL, 0x0000010018187825ULL, 0x000fc800078e00ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000007018257812ULL, 0x000fc600078ef80cULL,
0x0000000109177824ULL, 0x040fe200000e0617ULL, 0x00000023081a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000109137824ULL, 0x000fe200008e0613ULL, 0x0000002508187210ULL, 0x000fe20007f3e0ffULL,
0x0000010022227825ULL, 0x000fe200078e00ffULL, 0x00000070203d7812ULL, 0x100fe400078ef80cULL,
0x00000000122f7faeULL, 0x0003e2000b901c46ULL, 0x000001001f247825ULL, 0x000fe200078e00ffULL,
0x00000070221f7812ULL, 0x100fe400078ef80cULL, 0x00000000142d7faeULL, 0x0003e2000b901c46ULL,
0x000001001e3a7825ULL, 0x000fe200078e00ffULL, 0x00000070243f7812ULL, 0x000fc400078ef80cULL,
0x00000000162b7faeULL, 0x0003e2000b901c46ULL, 0x00000001091b7824ULL, 0x040fe200000e061bULL,
0x0000003d081e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000109197824ULL, 0x040fe200008e0619ULL,
0x000000703a3d7812ULL, 0x100fe200078ef80cULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x0000001f08207210ULL, 0x040fe40007f3e0ffULL, 0x0000000018297faeULL, 0x0003e2000b901c46ULL,
0x00000001091d7824ULL, 0x040fe200010e061dULL, 0x0000003d08247210ULL, 0x040fe20007f5e0ffULL,
0x00000001091f7824ULL, 0x040fe200000e0621ULL, 0x0000003f08227210ULL, 0x000fe20007f1e0ffULL,
0x0000000109217824ULL, 0x040fe200008e0623ULL, 0x00000070383d7812ULL, 0x100fe200078ef80cULL,
0x000001002a3e7825ULL, 0x000fe200078e00ffULL, 0x0000002509237210ULL, 0x040fe200007fe4ffULL,
0x000000001a277faeULL, 0x0003e2000b901c46ULL, 0x0000003d08387210ULL, 0x000fe20007f1e0ffULL,
0x0000000109257824ULL, 0x040fe200010e063bULL, 0x000000703e457812ULL, 0x100fe200078ef80cULL,
0x00000100343a7825ULL, 0x000fe200078e00ffULL, 0x000000001c0d7faeULL, 0x0003e4000b901c46ULL,
0x00000045083e7210ULL, 0x000fe20007f5e0ffULL, 0x000001002e3c7825ULL, 0x000fe200078e00ffULL,
0x000000703a497812ULL, 0x100fe200078ef80cULL, 0x000000001e057faeULL, 0x0003e4000b901c46ULL,
0x0000010026407825ULL, 0x000fe200078e00ffULL, 0x000000703c477812ULL, 0x100fe200078ef80cULL,
0x0000000020337faeULL, 0x0003e4000b901c46ULL, 0x0000000109397824ULL, 0x040fe200000e0639ULL,
0x0000007040437812ULL, 0x000fe200078ef80cULL, 0x00000001093f7824ULL, 0x000fe200010e063fULL,
0x00000049083a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000022357faeULL, 0x0003e2000b901c46ULL,
0x00000047083c7210ULL, 0x000fc40007f3e0ffULL, 0x0000004308087210ULL, 0x000fe20007f7e0ffULL,
0x00000001093b7824ULL, 0x040fe200000e063bULL, 0x0000000024377faeULL, 0x0003e2000b901c46ULL,
0x00000001093d7824ULL, 0x040fe400008e063dULL, 0x0000000109097824ULL, 0x000fe200018e0641ULL,
0x00000000380e7faeULL, 0x0003e8000b901c46ULL, 0x000000003a287faeULL, 0x0003e8000b901c46ULL,
0x000000003c2c7faeULL, 0x0003e8000b901c46ULL, 0x000000003e307faeULL, 0x0003e8000b901c46ULL,
0x0000000008327faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01b60400ff057984ULL, 0x000e620000000800ULL,
0x0000000b0a557224ULL, 0x000fc400078e02ffULL, 0x0000000169717824ULL, 0x000fe400078e0a00ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x8000000005ff7812ULL, 0x002fe20007804807ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x0000620055547625ULL, 0x000fe200078e0054ULL, 0x00000008ff717819ULL, 0x000fe20000011671ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0c7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140cULL, 0x0000000a05057211ULL, 0x000fc800078110ffULL,
0x0000000cff0a7210ULL, 0x000fc800007fe4ffULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005e0300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0x00006a0079797a24ULL, 0x000fe200078e02ffULL, 0x0001b68802737811ULL, 0x000fe200078e18ffULL,
0x000000020b6a7824ULL, 0x000fe200078e00ffULL, 0xffffffff00067810ULL, 0x000fe20007ffe0ffULL,
0x0000002002747824ULL, 0x000fe200078e00ffULL, 0x0000000900077810ULL, 0x000fc40007ffe0ffULL,
0x0000000103097810ULL, 0x040fe20007ffe0ffULL, 0x0000010003087824ULL, 0x000fe200078e0278ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000100ff6b7424ULL, 0x000fe200078e00ffULL,
0x0000005e0900720cULL, 0x000fe20003f06070ULL, 0x0000000f770c7224ULL, 0x000fe200078e02ffULL,
0x0000004008097812ULL, 0x000fc600078ec0ffULL, 0x000064000c0c7625ULL, 0x000fc800078e006bULL,
0x0000000168107824ULL, 0x000fc800078e0209ULL, 0x00000bb000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff117819ULL, 0x102fe20000011605ULL, 0x0000001005097824ULL, 0x000fe200078e00ffULL,
0x0000000869137217ULL, 0x000fe40007800000ULL, 0x0000000411157810ULL, 0x040fe40007ffe0ffULL,
0x0000000811177810ULL, 0x000fe20007ffe0ffULL, 0x0000000113207824ULL, 0x000fe200078e0a08ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x00000001150a7824ULL, 0x100fe200078e0205ULL,
0x0000000317267819ULL, 0x000fe200000006ffULL, 0x00000008150f7824ULL, 0x000fe200078e00ffULL,
0x00000080090e7812ULL, 0x000fe200078efcffULL, 0x00000001170b7824ULL, 0x000fe200078e0205ULL,
0x0000000c11197810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80f227812ULL, 0x000fe200078ee20aULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee20bULL,
0x00000001110b7824ULL, 0x040fe200078e0210ULL, 0x00000010111b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119147824ULL, 0x000fe200078e0205ULL, 0x000000201500720cULL, 0x080fe20003f86070ULL,
0x000001000b0a7825ULL, 0x000fe200078e000eULL, 0x0000001411237810ULL, 0x000fe40007ffe0ffULL,
0x000000201700720cULL, 0x000fe20003f46070ULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x0000000a0c127210ULL, 0x000fe20007f1e0ffULL, 0x000000011b167824ULL, 0x000fe200078e0205ULL,
0x000000201900720cULL, 0x080fe20003f66070ULL, 0x000000081b1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d287812ULL, 0x000fe200078ee214ULL, 0x000000010d137824ULL, 0x000fe200000e060bULL,
0x000000201b00720cULL, 0x000fe20003f06070ULL, 0x00000001150b7824ULL, 0x100fe200078e0210ULL,
0x0000001017157210ULL, 0x000fe20007ffe0ffULL, 0x0000000119177824ULL, 0x000fe200078e0210ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee216ULL, 0x000001000b0a7825ULL, 0x000fe200078e000eULL,
0x0000001811297810ULL, 0x000fc40007ffe0ffULL, 0x0000000511217210ULL, 0x000fe20007ffe0ffULL,
0x000000011b197824ULL, 0x000fe200078e0210ULL, 0x0000000a0c247210ULL, 0x040fe20007f3e0ffULL,
0x0000010015147825ULL, 0x000fe200078e000eULL, 0x0000001c112d7810ULL, 0x040fe40007ffe0ffULL,
0x00000020112f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001231b7824ULL, 0x000fe200078e0210ULL,
0x000000140c1a7210ULL, 0x000fe20007fbe0ffULL, 0x000000010d257824ULL, 0x000fe200008e060bULL,
0x0000003c11317810ULL, 0x000fe20007ffe0ffULL, 0x00000100190a7825ULL, 0x000fc800078e000eULL,
0x000001001b187825ULL, 0x000fc800078e000eULL, 0x0000010017167825ULL, 0x000fe200078e000eULL,
0x000000180c147210ULL, 0x000fc60007fde0ffULL, 0x000000010d1b7824ULL, 0x000fe200028e0615ULL,
0x000000160c1c7210ULL, 0x040fe20007f3e0ffULL, 0x00000001291f7824ULL, 0x000fe200078e0210ULL,
0x0000000a0c167210ULL, 0x000fe20007fbe0ffULL, 0x000000010d157824ULL, 0x000fe200030e0619ULL,
0x0ffffff8050a7812ULL, 0x000fe200078ec0ffULL, 0x000000010d1d7824ULL, 0x000fe200008e0617ULL,
0x000000202300720cULL, 0x000fe20003f26070ULL, 0x000001001f187825ULL, 0x000fe200078e000eULL,
0x000000070a1e7812ULL, 0x000fc600078ef821ULL, 0x000000010d177824ULL, 0x000fe200028e060bULL,
0x000000201100720cULL, 0x000fe20003fa6070ULL, 0x00000001231f7824ULL, 0x040fe200078e0205ULL,
0x00003000020b7811ULL, 0x000fe200078e70ffULL, 0x00000008232c7824ULL, 0x000fe200078e00ffULL,
0x000000180c187210ULL, 0x000fe20007fde0ffULL, 0x000000012f237824ULL, 0x100fe400078e0210ULL,
0x000000101e217824ULL, 0x000fe200078e020bULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee21fULL,
0x000000012d1f7824ULL, 0x000fc400078e0210ULL, 0x0000001022277824ULL, 0x000fe400078e020bULL,
0x000001001f1e7825ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x0003e2000e901c46ULL, 0x000000202900720cULL, 0x000fe40003fa6070ULL,
0x000000010d197824ULL, 0x000fe200030e0619ULL, 0x0000000024277faeULL, 0x0005e2000e101c46ULL,
0x0000001e0c1e7210ULL, 0x000fe20007fde0ffULL, 0x0000010023227825ULL, 0x000fe200078e000eULL,
0x000000202d00720cULL, 0x000fc60003f86070ULL, 0x000000010d1f7824ULL, 0x000fe400030e061fULL,
0x0000001026217824ULL, 0x002fe200078e020bULL, 0x000000220c127210ULL, 0x000fe20007fde0ffULL,
0x00000001292b7824ULL, 0x040fe400078e0205ULL, 0x0000001028257824ULL, 0x004fe200078e020bULL,
0x000000001a217faeULL, 0x0003e2000d101c46ULL, 0x00000008292e7824ULL, 0x000fe200078e00ffULL,
0x0000002411277810ULL, 0x000fe20007ffe0ffULL, 0x000000082d307824ULL, 0x000fe200078e00ffULL,
0x000000001c257faeULL, 0x0005e2000d901c46ULL, 0x000000202f00720cULL, 0x0c0fe20003f66070ULL,
0x000000012f267824ULL, 0x000fe200078e0205ULL, 0x000000052d297210ULL, 0x000fe20007ffe0ffULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82e247812ULL, 0x000fe200078ee22bULL,
0x000000010d137824ULL, 0x000fe200030e0623ULL, 0xfffffff8302e7812ULL, 0x000fe200078ee229ULL,
0x0000000127237824ULL, 0x040fe200078e0210ULL, 0x000000202700720cULL, 0x040fe20003f46070ULL,
0x0000000127287824ULL, 0x040fe200078e0205ULL, 0x0000000327277819ULL, 0x000fe200000006ffULL,
0x000000102a1b7824ULL, 0x102fe200078e020bULL, 0xfffffff82f267812ULL, 0x000fe200078ee226ULL,
0x000000102c1d7824ULL, 0x104fe200078e020bULL, 0xfffffff827287812ULL, 0x000fe200078ee228ULL,
0x0000001024217824ULL, 0x100fe200078e020bULL, 0x00000000161b7faeULL, 0x0003e2000c101c46ULL,
0x000000102e257824ULL, 0x100fe200078e020bULL, 0x0000002811297810ULL, 0x000fe20007ffe0ffULL,
0x0000001026277824ULL, 0x000fe200078e020bULL, 0x00000000141d7faeULL, 0x0005e2000c901c46ULL,
0x0000010023227825ULL, 0x000fe200078e000eULL, 0x0000002c112b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000018217faeULL, 0x0007e2000e901c46ULL, 0x00000030112d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000831247824ULL, 0x000fe200078e00ffULL, 0x000000220c227210ULL, 0x000fe20007fde0ffULL,
0x000000001e257faeULL, 0x0009e2000e101c46ULL, 0x00000034111b7810ULL, 0x002fe20007ffe0ffULL,
0x000000012d177824ULL, 0x100fe200078e0210ULL, 0x00000038112f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000012277faeULL, 0x0003e2000d901c46ULL, 0x000000010d237824ULL, 0x000fe200030e0623ULL,
0x000000202d00720cULL, 0x080fe20003f86070ULL, 0x0000001028117824ULL, 0x000fe200078e020bULL,
0x000000202b00720cULL, 0x0c0fe20003fa6070ULL, 0x000000012b157824ULL, 0x004fe200078e0210ULL,
0x000000202900720cULL, 0x080fe20003fc6070ULL, 0x000000012d187824ULL, 0x108fe200078e0205ULL,
0x0000000022117faeULL, 0x0005e2000d101c46ULL, 0x000000012b167824ULL, 0x100fe200078e0205ULL,
0x000000201b00720cULL, 0x080fe20003f66070ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x000000202f00720cULL, 0x080fe20003f26070ULL, 0x0000000129127824ULL, 0x002fe200078e0205ULL,
0x000000203100720cULL, 0x000fe20003f06070ULL, 0x0000000829137824ULL, 0x000fe200078e00ffULL,
0xfffffff82d1e7812ULL, 0x010fe200078ee218ULL, 0x000000082b2b7824ULL, 0x000fc400078e00ffULL,
0x0000010015147825ULL, 0x000fe200078e000eULL, 0xfffffff8131a7812ULL, 0x000fe400078ee212ULL,
0x0000001029137210ULL, 0x080fe20007ffe0ffULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee216ULL, 0x0000010017167825ULL, 0x000fe200078e000eULL,
0x000000101b117210ULL, 0x004fc60007ffe0ffULL, 0x0000010013127825ULL, 0x000fc800078e000eULL,
0x000000012f1f7824ULL, 0x040fe200078e0205ULL, 0x000000120c127210ULL, 0x000fe20007f5e0ffULL,
0x000000082f227824ULL, 0x000fc800078e00ffULL, 0x000000010d137824ULL, 0x000fe200010e0613ULL,
0x000000140c187210ULL, 0x000fe20007f5e0ffULL, 0x000000011b147824ULL, 0x000fe200078e0205ULL,
0xfffffff822227812ULL, 0x000fe200078ee21fULL, 0x000000012f1b7824ULL, 0x000fe400078e0210ULL,
0x000000010d197824ULL, 0x000fe200010e0615ULL, 0x000000160c167210ULL, 0x000fe20007f5e0ffULL,
0x000000101e1f7824ULL, 0x000fe200078e020bULL, 0xfffffff81d207812ULL, 0x000fe200078ee214ULL,
0x0000010011147825ULL, 0x000fc800078e000eULL, 0x000000010d177824ULL, 0x000fe200010e0617ULL,
0x000000140c147210ULL, 0x000fe20007f5e0ffULL, 0x00000001311d7824ULL, 0x000fe400078e0210ULL,
0x000001001b107825ULL, 0x000fc800078e000eULL, 0x00000001311b7824ULL, 0x000fe400078e0205ULL,
0x000000010d157824ULL, 0x000fe200010e0615ULL, 0x000000100c107210ULL, 0x000fe20007f5e0ffULL,
0x000001001d0e7825ULL, 0x000fe200078e000eULL, 0xfffffff824247812ULL, 0x000fe400078ee21bULL,
0x000000110d117210ULL, 0x000fe200017fe4ffULL, 0x000000101a1b7824ULL, 0x100fe200078e020bULL,
0x0000000e0c0c7210ULL, 0x000fe20007f5e0ffULL, 0x000000101c1d7824ULL, 0x000fc400078e020bULL,
0x0000001020217824ULL, 0x100fe200078e020bULL, 0x00000000121b7faeULL, 0x0003e2000f101c46ULL,
0x0000001022237824ULL, 0x100fe400078e020bULL, 0x00000010240b7824ULL, 0x000fe200078e020bULL,
0x00000000181d7faeULL, 0x0003e2000e901c46ULL, 0x000000010d0d7824ULL, 0x000fc600010e060fULL,
0x00000000161f7faeULL, 0x0003e8000e101c46ULL, 0x0000000014217faeULL, 0x0003e8000d901c46ULL,
0x0000000010237faeULL, 0x0003e8000c901c46ULL, 0x000000000c0b7faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x0000000405237811ULL, 0x042fe400078fe8ffULL,
0x0000000c05297811ULL, 0x000fc400078fe8ffULL, 0x0000001805257811ULL, 0x000fe200078fe8ffULL,
0x0000000123097824ULL, 0x000fe200078e0205ULL, 0x0000000805277811ULL, 0x000fe200078fe8ffULL,
0x00000008230e7824ULL, 0x000fe200078e00ffULL, 0x0000002405197811ULL, 0x000fe200078fe8ffULL,
0x0000000123237824ULL, 0x000fe200078e0210ULL, 0x00000005270a7210ULL, 0x0c0fe20007ffe0ffULL,
0x0000000827317824ULL, 0x000fe200078e00ffULL, 0xfffffff80e2f7812ULL, 0x000fe200078ee209ULL,
0x0000000129097824ULL, 0x100fe200078e0205ULL, 0x00000010052b7811ULL, 0x000fe200078fe8ffULL,
0x00000008290e7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20aULL,
0x0000000129297824ULL, 0x000fe200078e0210ULL, 0x0000003005137811ULL, 0x000fe200078fe8ffULL,
0x000000012b0a7824ULL, 0x000fe200078e0205ULL, 0xfffffff80e337812ULL, 0x000fe200078ee209ULL,
0x0000000125097824ULL, 0x000fe200078e0205ULL, 0x0000001c05217811ULL, 0x000fe200078fe8ffULL,
0x00000008250e7824ULL, 0x000fe200078e00ffULL, 0x00000014052d7811ULL, 0x000fe200078fe8ffULL,
0x000000082b357824ULL, 0x000fe200078e00ffULL, 0x0000003c05417811ULL, 0x000fe200078fe8ffULL,
0x00000008213b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e397812ULL, 0x000fe200078ee209ULL,
0x0000000119097824ULL, 0x100fe200078e0205ULL, 0xfffffff835357812ULL, 0x000fe200078ee20aULL,
0x00000008190e7824ULL, 0x000fe200078e00ffULL, 0x00000005210a7210ULL, 0x080fe20007ffe0ffULL,
0x000000012d0b7824ULL, 0x000fe200078e0205ULL, 0x00000028050f7811ULL, 0x000fe200078fe8ffULL,
0x000000082d127824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3f7812ULL, 0x000fe200078ee209ULL,
0x00000008130e7824ULL, 0x040fe200078e00ffULL, 0x0000000513097210ULL, 0x000fe20007ffe0ffULL,
0x00000008414b7824ULL, 0x000fe200078e00ffULL, 0x00000020051d7811ULL, 0x000fe200078fe8ffULL,
0x000000080f1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e457812ULL, 0x000fe200078ee209ULL,
0x00000001410e7824ULL, 0x100fe200078e0205ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL,
0x000000010f0a7824ULL, 0x000fe200078e0205ULL, 0xfffffff812377812ULL, 0x000fe200078ee20bULL,
0x000000011d0b7824ULL, 0x000fe200078e0205ULL, 0x0000002c05117811ULL, 0x000fe200078fe8ffULL,
0x000000081d127824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee20eULL,
0x0000001005097824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL,
0x000000012b2b7824ULL, 0x100fe200078e0210ULL, 0x00003000020e7811ULL, 0x000fe200078e70ffULL,
0x000000012d2d7824ULL, 0x000fe200078e0210ULL, 0xfffffff8123d7812ULL, 0x000fe200078ee20bULL,
0x00000001110b7824ULL, 0x100fe200078e0205ULL, 0x0000007009097812ULL, 0x000fe200078ec0ffULL,
0x0000000811127824ULL, 0x000fe200078e00ffULL, 0x0000003405157811ULL, 0x000fe200078fe8ffULL,
0x000000101b2e7824ULL, 0x000fe200078e020eULL, 0x0000003805177811ULL, 0x000fe200078fe8ffULL,
0x0000000125257824ULL, 0x100fe200078e0210ULL, 0x00000010051f7211ULL, 0x080fe200078fe8ffULL,
0x00000001150a7824ULL, 0x000fe200078e0205ULL, 0x00000080091a7812ULL, 0x000fe200078efcffULL,
0x0000000815477824ULL, 0x000fe200078e00ffULL, 0x000000ff001b7202ULL, 0x000fe20000000f00ULL,
0x0000000121217824ULL, 0x000fe200078e0210ULL, 0xfffffff812437812ULL, 0x000fe200078ee20bULL,
0x00000001170b7824ULL, 0x000fe200078e0205ULL, 0x0000001027277210ULL, 0x000fe20007ffe0ffULL,
0x0000000817127824ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fe200078ee20aULL,
0x000001001f1e7825ULL, 0x000fe200078e001aULL, 0x0ffffff8050a7812ULL, 0x000fc400078ec0ffULL,
0xfffffff812497812ULL, 0x000fe200078ee20bULL, 0x0000010023227825ULL, 0x100fe200078e001aULL,
0x00000005050b7211ULL, 0x000fe400078fe8ffULL, 0x0000001e0c1e7210ULL, 0x040fe20007f1e0ffULL,
0x0000010027267825ULL, 0x000fe200078e001aULL, 0x000000220c227210ULL, 0x000fe40007f3e0ffULL,
0x000000070a0b7812ULL, 0x000fe200078ef80bULL, 0x0000010029287825ULL, 0x000fe200078e001aULL,
0x000000260c267210ULL, 0x000fc40007f5e0ffULL, 0x0000001013137210ULL, 0x000fe20007ffe0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e001aULL, 0x000000280c287210ULL, 0x000fe40007f7e0ffULL,
0x0000000e39397211ULL, 0x000fe200078e20ffULL, 0x000000011d1d7824ULL, 0x000fe400078e0210ULL,
0x000001002d2c7825ULL, 0x000fc800078e001aULL, 0x0000010025247825ULL, 0x000fc800078e001aULL,
0x0000010021207825ULL, 0x000fc800078e001aULL, 0x0000000119197824ULL, 0x100fe400078e0210ULL,
0x000000010f0f7824ULL, 0x100fe400078e0210ULL, 0x000000010d1f7824ULL, 0x000fe200000e061fULL,
0x0000002a0c2a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000111117824ULL, 0x000fe400078e0210ULL,
0x0000001043307824ULL, 0x000fe400078e020eULL, 0x000001001d1c7825ULL, 0x000fc800078e001aULL,
0x000000010d237824ULL, 0x040fe200008e0623ULL, 0x0000002c0c2c7210ULL, 0x040fe20007f3e0ffULL,
0x000000010d277824ULL, 0x000fe200010e0627ULL, 0x000000240c247210ULL, 0x000fe20007f5e0ffULL,
0x000000100b0b7824ULL, 0x100fe400078e020eULL, 0x000000102f2f7824ULL, 0x100fe400078e020eULL,
0x0000001031317824ULL, 0x100fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e0b7faeULL, 0x0003e2000b901c46ULL, 0x0000001033337824ULL, 0x000fc400078e020eULL,
0x0000001035357824ULL, 0x100fe200078e020eULL, 0x00000000222f7faeULL, 0x0003e2000b901c46ULL,
0x0000001037377824ULL, 0x100fe400078e020eULL, 0x000000103b3b7824ULL, 0x100fe200078e020eULL,
0x0000000026317faeULL, 0x0003e2000b901c46ULL, 0x000000103d3d7824ULL, 0x100fe400078e020eULL,
0x000000103f3f7824ULL, 0x100fe400078e020eULL, 0x0000001045327824ULL, 0x000fc400078e020eULL,
0x0000001047347824ULL, 0x100fe400078e020eULL, 0x0000001049367824ULL, 0x100fe400078e020eULL,
0x000000104b437824ULL, 0x000fe400078e020eULL, 0x000000010d297824ULL, 0x000fe200018e0629ULL,
0x000000200c207210ULL, 0x000fe20007f7e0ffULL, 0x0000000115157824ULL, 0x100fe400078e0210ULL,
0x0000000117177824ULL, 0x100fe200078e0210ULL, 0x0000000028337faeULL, 0x0003e2000b901c46ULL,
0x0000000141417824ULL, 0x000fc400078e0210ULL, 0x0000010019187825ULL, 0x000fc800078e001aULL,
0x000001000f0e7825ULL, 0x000fc800078e001aULL, 0x0000010011107825ULL, 0x000fc800078e001aULL,
0x000000010d2b7824ULL, 0x000fe200000e062bULL, 0x0000001c0c1c7210ULL, 0x000fe20007f1e0ffULL,
0x0000010013127825ULL, 0x000fc600078e001aULL, 0x000000002a357faeULL, 0x0003e2000b901c46ULL,
0x000000010d2d7824ULL, 0x040fe200008e062dULL, 0x000000180c187210ULL, 0x040fe20007f3e0ffULL,
0x000000010d257824ULL, 0x000fe200010e0625ULL, 0x0000000e0c0e7210ULL, 0x040fe20007f5e0ffULL,
0x0000010015147825ULL, 0x000fe200078e001aULL, 0x000000190d197210ULL, 0x040fe20000ffe4ffULL,
0x000000002c377faeULL, 0x0003e4000b901c46ULL, 0x000000010d217824ULL, 0x000fe200018e0621ULL,
0x000000100c107210ULL, 0x040fe20007f7e0ffULL, 0x0000010017167825ULL, 0x100fe200078e001aULL,
0x000000140c147210ULL, 0x000fe20007f3e0ffULL, 0x0000000024397faeULL, 0x0003e4000b901c46ULL,
0x00000100411a7825ULL, 0x000fc400078e001aULL, 0x00000000203b7faeULL, 0x0003e4000b901c46ULL,
0x000000010d1d7824ULL, 0x040fe200000e061dULL, 0x000000120c127210ULL, 0x040fe20007f1e0ffULL,
0x000000010d0f7824ULL, 0x040fe200010e060fULL, 0x000000160c167210ULL, 0x040fe20007f5e0ffULL,
0x000000010d117824ULL, 0x040fe200018e0611ULL, 0x0000001a0c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d137824ULL, 0x040fe200000e0613ULL, 0x000000001c3d7faeULL, 0x0003e2000b901c46ULL,
0x000000010d157824ULL, 0x000fc400008e0615ULL, 0x000000010d177824ULL, 0x040fe200010e0617ULL,
0x00000000183f7faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x000fc600018e061bULL,
0x000000000e2e7faeULL, 0x0003e8000b901c46ULL, 0x0000000010307faeULL, 0x0003e8000b901c46ULL,
0x0000000012327faeULL, 0x0003e8000b901c46ULL, 0x0000000014347faeULL, 0x0003e8000b901c46ULL,
0x0000000016367faeULL, 0x0003e8000b901c46ULL, 0x000000000c437faeULL, 0x0003e4000b901c46ULL,
0x0000000204047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0f7424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000006d0400720cULL, 0x000fda0003f06070ULL,
0x0000000279108824ULL, 0x000fe400078e0204ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000660010108625ULL, 0x000fe200078e0011ULL, 0x0000000705307812ULL, 0x000fe400078ec0ffULL,
0x00000004ff0e7819ULL, 0x000fe20000011605ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000006100f8981ULL, 0x000322000c1e1900ULL, 0x00000008300b7812ULL, 0x000fe200078ef805ULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000b0e0c7210ULL, 0x000fe20007ffe0ffULL,
0x000000100b0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fca00078ee20cULL,
0x000000100d3c7824ULL, 0x000fc800078e00ffULL, 0x000000080e0d7824ULL, 0x002fe200078e00ffULL,
0x00000003ff607819ULL, 0x000fe20000011605ULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x000000100b167824ULL, 0x000fe200078e00ffULL, 0x000000020c157810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d307812ULL, 0x000fe200078ee230ULL, 0x00004000020d7824ULL, 0x000fe200078e00ffULL,
0x0000000160147812ULL, 0x000fe400078ec0ffULL, 0x0000001030457810ULL, 0x040fe20007ffe0ffULL,
0x0000000830117824ULL, 0x000fe200078e00ffULL, 0x000010000d0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114447824ULL, 0x000fe200078e0230ULL, 0xfffffff016157812ULL, 0x000fe200078ee215ULL,
0x0000000830187824ULL, 0x040fe200078e00ffULL, 0x0000002030467810ULL, 0x000fe20007ffe0ffULL,
0x00000001145a7824ULL, 0x000fe200078e0245ULL, 0xfffffff811587812ULL, 0x000fe200078ee244ULL,
0x0000000845177824ULL, 0x000fe200078e00ffULL, 0x00000002445d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114597824ULL, 0x000fe200078e0246ULL, 0x0000000415157819ULL, 0x000fe200000006ffULL,
0x0000001058107824ULL, 0x000fe200078e020eULL, 0xfffffff8185d7812ULL, 0x000fe200078ee25dULL,
0x0000000846167824ULL, 0x000fe200078e00ffULL, 0xfffffff8175a7812ULL, 0x000fe200078ee25aULL,
0x000000001534783bULL, 0x0003e20000000200ULL, 0x0000003030477810ULL, 0x000fe20007ffe0ffULL,
0x000000105d4c7824ULL, 0x100fe200078e020eULL, 0x00000012445c7810ULL, 0x000fe20007ffe0ffULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x000000105a1c7824ULL, 0x100fe200078e020eULL,
0xfffffff816597812ULL, 0x000fe200078ee259ULL, 0x00000001145b7824ULL, 0x000fe200078e0247ULL,
0x000000004c4c783bULL, 0x000fe20000000200ULL, 0x0000000845157824ULL, 0x002fe200078e00ffULL,
0x0000002244617810ULL, 0x000fe20007ffe0ffULL, 0x0000000847147824ULL, 0x000fe200078e00ffULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x0000001059287824ULL, 0x000fe200078e020eULL,
0xfffffff8155c7812ULL, 0x000fe200078ee25cULL, 0x0000000846187824ULL, 0x000fe200078e00ffULL,
0xfffffff8145b7812ULL, 0x000fe200078ee25bULL, 0x0000000847247824ULL, 0x000fe200078e00ffULL,
0x0000003244657810ULL, 0x000fe20007ffe0ffULL, 0x000000105c147824ULL, 0x000fe200078e020eULL,
0x0000000e5b2c7211ULL, 0x000fe200078e20ffULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0xfffffff818617812ULL, 0x000fc400078ee261ULL, 0xfffffff824657812ULL, 0x000fe200078ee265ULL,
0x000000001414783bULL, 0x000ee20000000200ULL, 0x0000000444627810ULL, 0x040fe20007ffe0ffULL,
0x0000001061207824ULL, 0x100fe200078e020eULL, 0x0000003444677810ULL, 0x000fe20007ffe0ffULL,
0x000000002c2c783bULL, 0x000ee20000000200ULL, 0x0000001065407824ULL, 0x000fe200078e020eULL,
0x000000060c317810ULL, 0x000fe40007ffe0ffULL, 0x000000002020783bULL, 0x000ee20000000200ULL,
0x0000001444637810ULL, 0x000fc40007ffe0ffULL, 0x0000002444667810ULL, 0x040fe20007ffe0ffULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x0000003644567810ULL, 0x040fe40007ffe0ffULL,
0x00000016445f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000644647810ULL, 0x040fe20007ffe0ffULL,
0x000000103c38723cULL, 0x004f6200000418ffULL, 0x0000002644577810ULL, 0x000fce0007ffe0ffULL,
0x000000123c10723cULL, 0x040f7000000418ffULL, 0x000000283c18723cULL, 0x002ff000000418ffULL,
0x0000004c3438723cULL, 0x060ff00000041838ULL, 0x0000004e344c723cULL, 0x000ff00000041810ULL,
0x0000001c3c10723cULL, 0x040f7000000418ffULL, 0x0000001e3c1c723cULL, 0x040f7000000418ffULL,
0x0000002a3c28723cULL, 0x000f7000000418ffULL, 0x000000143410723cULL, 0x028bee0000041810ULL,
0x000000100b157824ULL, 0x020fe200078e00ffULL, 0x0000002c3c24723cULL, 0x000b6200000418ffULL,
0x000000040c147810ULL, 0x000fcc0007ffe0ffULL, 0x00000008302d7824ULL, 0x020fe200078e00ffULL,
0xfffffff0152c7812ULL, 0x000fe200078ee214ULL, 0x000000203418723cULL, 0x000fe60000041818ULL,
0xfffffff82d627812ULL, 0x000fc800078ee262ULL, 0x0000000e62507211ULL, 0x000fe200078e20ffULL,
0x000000163414723cULL, 0x040bea000004181cULL, 0x000000005050783bULL, 0x000fe40000000200ULL,
0x000000102c1c7824ULL, 0x020fe200078e00ffULL, 0x000000223420723cULL, 0x000bea0000041828ULL,
0x000000001c1c783bULL, 0x000e640000000200ULL, 0x00000008472a7824ULL, 0x020fe200078e00ffULL,
0x0000002e3c3c723cULL, 0x000f6200000418ffULL, 0x0000000845287824ULL, 0x000fc400078e00ffULL,
0x0000000846297824ULL, 0x000fe200078e00ffULL, 0xfffffff82a677812ULL, 0x000fe200078ee267ULL,
0x0000000847477824ULL, 0x000fe200078e00ffULL, 0xfffffff828637812ULL, 0x000fe400078ee263ULL,
0x000000403424723cULL, 0x000b620000041824ULL, 0xfffffff829667812ULL, 0x000fe400078ee266ULL,
0xfffffff847567812ULL, 0x000fe200078ee256ULL, 0x0000001063287824ULL, 0x100fe200078e020eULL,
0x0000000346467819ULL, 0x000fe200000006ffULL, 0x00000010662c7824ULL, 0x000fc400078e020eULL,
0x0000000830417824ULL, 0x020fe200078e00ffULL, 0xfffffff846577812ULL, 0x000fe200078ee257ULL,
0x000000100b407824ULL, 0x000fe200078e00ffULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x0000001067307824ULL, 0x000fe200078e020eULL, 0xfffffff841647812ULL, 0x000fe200078ee264ULL,
0x0000001057487824ULL, 0x000fe200078e020eULL, 0xfffffff040407812ULL, 0x000fe200078ee231ULL,
0x000000423434723cULL, 0x000b62000004183cULL, 0x000000002c2c783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000ee40000000200ULL, 0x00000008453c7824ULL, 0x020fc400078e00ffULL,
0x000000004848783bULL, 0x000fe60000000200ULL, 0xfffffff83c5f7812ULL, 0x000fe200078ee25fULL,
0x000000501c38723cULL, 0x042be20000041838ULL, 0x00000010403c7824ULL, 0x000fe400078e00ffULL,
0x0000001064407824ULL, 0x100fe400078e020eULL, 0x000000105f447824ULL, 0x100fe400078e020eULL,
0x0000001056507824ULL, 0x020fe200078e020eULL, 0x000000521c4c723cULL, 0x040be2000004184cULL,
0x000000003c3c783bULL, 0x000fe80000000200ULL, 0x000000005050783bULL, 0x020e680000000200ULL,
0x000000004040783bULL, 0x000e680000000200ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x000000281c10723cULL, 0x044ff00000041810ULL, 0x0000002a1c14723cULL, 0x040ff00000041814ULL,
0x000000301c24723cULL, 0x048f700000041824ULL, 0x0000002c1c18723cULL, 0x040f700000041818ULL,
0x0000002e1c20723cULL, 0x040f700000041820ULL, 0x000000321c34723cULL, 0x000b6e0000041834ULL,
0x000000770f1c7224ULL, 0x030fe200078e02ffULL, 0x000000503c24723cULL, 0x042b6e0000041824ULL,
0x0000030003507a10ULL, 0x020fe20007ffe0ffULL, 0x000000403c38723cULL, 0x000f660000041838ULL,
0x00000001501d7810ULL, 0x040fe20007ffe0ffULL, 0x00000100501e7824ULL, 0x000fc600078e0278ULL,
0x0000005e1d00720cULL, 0x000fe20003f06070ULL, 0x000000423c4c723cULL, 0x000f62000004184cULL,
0x000000401e1f7812ULL, 0x000fe200078ec0ffULL, 0x000064001c1c7625ULL, 0x000fcc00078e006bULL,
0x000000443c10723cULL, 0x040f700000041810ULL, 0x000000463c14723cULL, 0x040b6e0000041814ULL,
0x0000000168467824ULL, 0x020fe200078e021fULL, 0x000000483c18723cULL, 0x040b700000041818ULL,
0x0000004a3c20723cULL, 0x040b700000041820ULL, 0x000000523c34723cULL, 0x000b620000041834ULL,
0x00000c4000008947ULL, 0x000fce0003800000ULL, 0x00000008602d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001603d7824ULL, 0x020fe200078e0205ULL, 0x0000001e693c7217ULL, 0x000fc40007800000ULL,
0x00000004601f7810ULL, 0x040fe20007ffe0ffULL, 0x000000012d417824ULL, 0x040fe200078e0205ULL,
0x0000001460437810ULL, 0x000fe20007ffe0ffULL, 0x000000082d2a7824ULL, 0x000fe200078e00ffULL,
0x000000051f317210ULL, 0x040fe20007ffe0ffULL, 0x000000013c3c7824ULL, 0x000fe200078e0a1eULL,
0x000000070a3d7812ULL, 0x000fe200078ef83dULL, 0x00000001601e7824ULL, 0x100fe200078e0246ULL,
0xfffffff82a417812ULL, 0x000fe200078ee241ULL, 0x000000081f287824ULL, 0x040fe200078e00ffULL,
0x0000003c1f00720cULL, 0x040fe20003f46070ULL, 0x000000011f2a7824ULL, 0x000fe200078e0246ULL,
0x0000000c602f7810ULL, 0x000fe20007ffe0ffULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0xfffffff828317812ULL, 0x000fc400078ee231ULL, 0x0000001060477810ULL, 0x000fe20007ffe0ffULL,
0x00000001430a7824ULL, 0x140fe200078e0205ULL, 0x000000091e297212ULL, 0x000fe200078efcffULL,
0x00000008432b7824ULL, 0x000fe200078e00ffULL, 0x0000003c2f00720cULL, 0x040fe20003fa6070ULL,
0x000000012f3f7824ULL, 0x040fe200078e0205ULL, 0x000000291c1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000082f287824ULL, 0x000fe200078e00ffULL, 0xfffffff82b0a7812ULL, 0x000fe200078ee20aULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000003472c7819ULL, 0x000fc400000006ffULL,
0xfffffff8283f7812ULL, 0x000fe200078ee23fULL, 0x000000012d2e7824ULL, 0x100fe200078e0246ULL,
0x000000092a297212ULL, 0x000fe200078efcffULL, 0x000000012f287824ULL, 0x000fe200078e0246ULL,
0x0000003c6000720cULL, 0x080fe20003f26070ULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000003c4700720cULL, 0x080fe40003f86070ULL, 0x0000003c2d00720cULL, 0x000fe20003f66070ULL,
0x000000011d1f7824ULL, 0x000fe200000e061fULL, 0x000000291c2a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000147337824ULL, 0x000fe200078e0205ULL, 0x000000092e497212ULL, 0x000fe200078efcffULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000001860457810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82c337812ULL, 0x000fe200078ee233ULL, 0x000000011d2b7824ULL, 0x000fe200000e062bULL,
0x000000491c2e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001472c7824ULL, 0x000fe200078e0246ULL,
0x0000000928477212ULL, 0x000fe200078efcffULL, 0x000000103d3d7824ULL, 0x000fe200078e020eULL,
0x0000002f1d2f7210ULL, 0x000fe200007fe4ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000003c4300720cULL, 0x0c0fe40003f06070ULL, 0x000000471c287210ULL, 0x000fe20007fde0ffULL,
0x0000000143437824ULL, 0x000fe200078e0246ULL, 0x000000092c477212ULL, 0x000fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e3d7faeULL, 0x0003e2000c901c46ULL,
0x0000000145327824ULL, 0x000fe200078e0205ULL, 0x0000002060497810ULL, 0x000fe20007ffe0ffULL,
0x000000011d297824ULL, 0x000fe200030e0629ULL, 0x000000471c2c7210ULL, 0x000fe20007fde0ffULL,
0x00000008454b7824ULL, 0x000fe200078e00ffULL, 0x0000001c60477810ULL, 0x000fe20007ffe0ffULL,
0x0000000149407824ULL, 0x000fe200078e0205ULL, 0x0000003c4500720cULL, 0x000fe20003f26070ULL,
0x000000011d2d7824ULL, 0x000fe200030e062dULL, 0xfffffff84b327812ULL, 0x000fe200078ee232ULL,
0x00000001473e7824ULL, 0x000fc400078e0205ULL, 0x00000100431e7825ULL, 0x002fc800078e00ffULL,
0x00000008474b7824ULL, 0x000fe200078e00ffULL, 0x000000091e437212ULL, 0x000fe200078efcffULL,
0x0000000145457824ULL, 0x000fe400078e0246ULL, 0x0000000849517824ULL, 0x000fe200078e00ffULL,
0x000000431c307210ULL, 0x000fe20007fde0ffULL, 0x0000001041417824ULL, 0x100fe200078e020eULL,
0x0000000e31437211ULL, 0x000fe200078e20ffULL, 0x000000103f3f7824ULL, 0x000fe200078e020eULL,
0xfffffff84b3d7812ULL, 0x000fe200078ee23eULL, 0x000000011d317824ULL, 0x000fe200030e061fULL,
0xfffffff8513e7812ULL, 0x000fe200078ee240ULL, 0x00000100451e7825ULL, 0x000fe200078e00ffULL,
0x000000002a437faeULL, 0x0003e2000d101c46ULL, 0x0000003c4700720cULL, 0x000fc40003f46070ULL,
0x0000000147407824ULL, 0x100fe200078e0246ULL, 0x000000091e457212ULL, 0x000fe200078efcffULL,
0x000000002e417faeULL, 0x0005e2000d901c46ULL, 0x0000000149427824ULL, 0x040fe200078e0246ULL,
0x0000003c4900720cULL, 0x080fe20003f66070ULL, 0x0000001033337824ULL, 0x000fe200078e020eULL,
0x000000451c1e7210ULL, 0x000fe20007fde0ffULL, 0x00000000283f7faeULL, 0x0007e2000e901c46ULL,
0x0000002460457810ULL, 0x000fe20007ffe0ffULL, 0x00000100422a7825ULL, 0x002fe200078e00ffULL,
0x0000003060497810ULL, 0x000fe20007ffe0ffULL, 0x000000002c337faeULL, 0x0003e2000e101c46ULL,
0x0000003c4500720cULL, 0x000fe20003fa6070ULL, 0x000000011d1f7824ULL, 0x000fe200030e061fULL,
0x000000092a417212ULL, 0x004fe200078efcffULL, 0x00000100402e7825ULL, 0x000fe200078e00ffULL,
0x0000003c60517810ULL, 0x000fc60007ffe0ffULL, 0x0000000145407824ULL, 0x040fe200078e0205ULL,
0x000000092e437212ULL, 0x000fe200078efcffULL, 0x00000001452e7824ULL, 0x140fe400078e0246ULL,
0x0000000845477824ULL, 0x000fe200078e00ffULL, 0x000000431c287210ULL, 0x008fe20007fde0ffULL,
0x0000000149337824ULL, 0x042fe200078e0246ULL, 0x0000002860437810ULL, 0x000fe20007ffe0ffULL,
0x00000008494b7824ULL, 0x000fe200078e00ffULL, 0x0000002f1d297210ULL, 0x000fe200037fe4ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x000000411c2a7210ULL, 0x000fc40007fde0ffULL,
0xfffffff847417812ULL, 0x000fe200078ee240ULL, 0x0000000143407824ULL, 0x000fe200078e0205ULL,
0x000000092e3f7212ULL, 0x000fe200078efcffULL, 0x000000011d2b7824ULL, 0x000fe200030e062bULL,
0x0000002c60477810ULL, 0x000fe20007ffe0ffULL, 0x0000000843457824ULL, 0x040fe200078e00ffULL,
0x0000003f1c2c7210ULL, 0x000fe20007fde0ffULL, 0x00000001432e7824ULL, 0x040fe200078e0246ULL,
0x0000003c4300720cULL, 0x000fe20003f86070ULL, 0x000000103d3d7824ULL, 0x000fe200078e020eULL,
0xfffffff8453f7812ULL, 0x000fe200078ee240ULL, 0x000000100a457824ULL, 0x000fc400078e020eULL,
0x000000011d2d7824ULL, 0x000fe400030e062fULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000000030457faeULL, 0x0003e2000c101c46ULL, 0x0000003c4700720cULL, 0x040fe40003f06070ULL,
0x00000001470a7824ULL, 0x040fe200078e0246ULL, 0x000000092e437212ULL, 0x000fe200078efcffULL,
0x0000000147407824ULL, 0x040fe200078e0205ULL, 0x0000000347477819ULL, 0x000fe200000006ffULL,
0x0000001041417824ULL, 0x100fe200078e020eULL, 0x000000431c2e7210ULL, 0x000fe20007fde0ffULL,
0x000000103f3f7824ULL, 0x000fe200078e020eULL, 0xfffffff847437812ULL, 0x000fe200078ee240ULL,
0x0000001032477824ULL, 0x000fc400078e020eULL, 0x000001000a307825ULL, 0x002fc600078e00ffULL,
0x000000001e477faeULL, 0x0003e2000c901c46ULL, 0x0000010033327825ULL, 0x000fe200078e00ffULL,
0x0000000930457212ULL, 0x000fe400078efcffULL, 0x0000003c4900720cULL, 0x080fe20003f26070ULL,
0x000000011d2f7824ULL, 0x000fe200030e062fULL, 0x00000000283d7faeULL, 0x0005e2000d101c46ULL,
0x00000001490a7824ULL, 0x000fe200078e0205ULL, 0x0000003460497810ULL, 0x000fe20007ffe0ffULL,
0x0000001043437824ULL, 0x000fe200078e020eULL, 0x0000003c5100720cULL, 0x000fc40003f46070ULL,
0x000000451c1e7210ULL, 0x002fe40007fde0ffULL, 0x0000000932457212ULL, 0x000fe200078efcffULL,
0x0000000149327824ULL, 0x000fe400078e0205ULL, 0x000000011d1f7824ULL, 0x000fe200030e0631ULL,
0x000000451c307210ULL, 0x000fe40007fde0ffULL, 0xfffffff84b457812ULL, 0x000fe200078ee20aULL,
0x00000001490a7824ULL, 0x000fe200078e0246ULL, 0x00000038604b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d317824ULL, 0x000fe200030e0633ULL, 0x0000000e3e337211ULL, 0x000fe200078e20ffULL,
0x000001000a287825ULL, 0x004fc800078e00ffULL, 0x000000014b0a7824ULL, 0x040fe200078e0246ULL,
0x000000002a337faeULL, 0x0003e2000d901c46ULL, 0x0000000928477212ULL, 0x000fe200078efcffULL,
0x000000084b3d7824ULL, 0x040fe200078e00ffULL, 0x0000003c4b00720cULL, 0x080fe20003f66070ULL,
0x000000002c417faeULL, 0x0005e2000e901c46ULL, 0x000000471c287210ULL, 0x000fe20007fde0ffULL,
0x0000001045457824ULL, 0x000fe200078e020eULL, 0x0000003c4900720cULL, 0x040fe20003fa6070ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x000000002e3f7faeULL, 0x0007e2000e101c46ULL,
0x000000011d297824ULL, 0x000fc400030e0629ULL, 0x000001000a2a7825ULL, 0x002fe200078e00ffULL,
0x000000001e437faeULL, 0x0007e6000c101c46ULL, 0x00000001512c7824ULL, 0x004fe200078e0246ULL,
0x000000092a337212ULL, 0x000fe200078efcffULL, 0x000000014b0a7824ULL, 0x100fe200078e0205ULL,
0x0000000351417819ULL, 0x000fe200000006ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x000000331c2a7210ULL, 0x000fe20007fde0ffULL, 0x0000000030457faeULL, 0x0007e2000c901c46ULL,
0xfffffff849337812ULL, 0x000fe200078ee232ULL, 0x00000001513c7824ULL, 0x000fe200078e0205ULL,
0x000000092c097212ULL, 0x000fe200078efcffULL, 0x000000011d2b7824ULL, 0x000fe200030e062bULL,
0xfffffff83d3d7812ULL, 0x000fc400078ee20aULL, 0xfffffff841417812ULL, 0x000fe400078ee23cULL,
0x000000091c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001033097824ULL, 0x100fe400078e020eULL,
0x000000103d337824ULL, 0x100fe400078e020eULL, 0x00000010413d7824ULL, 0x000fe200078e020eULL,
0x0000000028097faeULL, 0x0007e2000e901c46ULL, 0x000000011d1d7824ULL, 0x000fc600030e062dULL,
0x000000002a337faeULL, 0x0007e8000d901c46ULL, 0x000000001c3d7faeULL, 0x0007e2000d101c46ULL,
0x00000b1000007947ULL, 0x000fea0003800000ULL, 0x00000046602a7210ULL, 0x040fe20007ffe0ffULL,
0x0000000160457824ULL, 0x040fe200078e0205ULL, 0x0000000c606f7810ULL, 0x040fe40007ffe0ffULL,
0x00000004601e7810ULL, 0x000fe20007ffe0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000000860707810ULL, 0x000fc40007ffe0ffULL, 0x00000010606e7810ULL, 0x000fe20007ffe0ffULL,
0x000000016f1f7824ULL, 0x100fe200078e0246ULL, 0x000000092a2f7212ULL, 0x000fe200078efcffULL,
0x000000011e287824ULL, 0x100fe200078e0246ULL, 0x000000466e3c7210ULL, 0x020fe20007ffe0ffULL,
0x00000001702c7824ULL, 0x000fe200078e0246ULL, 0x0000002f1c2a7210ULL, 0x000fe20007f1e0ffULL,
0x000000011e447824ULL, 0x000fe200078e0205ULL, 0x0000001860527810ULL, 0x000fe20007ffe0ffULL,
0x000000081e317824ULL, 0x000fe200078e00ffULL, 0x000000070a457812ULL, 0x000fe200078ef845ULL,
0x000001001f1e7825ULL, 0x000fe200078e00ffULL, 0x00000014606c7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff831447812ULL, 0x000fe200078ee244ULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x000000091e2f7212ULL, 0x080fe400078efcffULL, 0x00000020600a7810ULL, 0x000fe20007ffe0ffULL,
0x000001002c2c7825ULL, 0x000fe200078e00ffULL, 0x0000000928317212ULL, 0x080fe400078efcffULL,
0x0000001c60517810ULL, 0x000fe20007ffe0ffULL, 0x000001003c3c7825ULL, 0x000fe200078e00ffULL,
0x000000092c437212ULL, 0x000fc400078efcffULL, 0x000000311c287210ULL, 0x040fe20007f3e0ffULL,
0x000000011d2b7824ULL, 0x040fe200000e062bULL, 0x0000002f1c1e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000152307824ULL, 0x100fe200078e0246ULL, 0x000000431c427210ULL, 0x000fe20007f5e0ffULL,
0x000000016c327824ULL, 0x100fe200078e0246ULL, 0x000000093c417212ULL, 0x080fe200078efcffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x00000024604a7810ULL, 0x040fe40007ffe0ffULL,
0x00000028604b7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a2c7824ULL, 0x100fe200078e0246ULL,
0x0000000930477212ULL, 0x000fe200078efcffULL, 0x000000011d1f7824ULL, 0x000fe200000e061fULL,
0x000000411c407210ULL, 0x000fe20007f1e0ffULL, 0x00000001512e7824ULL, 0x000fe200078e0246ULL,
0x0000002c60537810ULL, 0x040fe20007ffe0ffULL, 0x000000011d437824ULL, 0x000fe200010e062dULL,
0x00000030606b7810ULL, 0x000fe20007ffe0ffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x0000003460767810ULL, 0x000fc40007ffe0ffULL, 0x0000003860757810ULL, 0x000fe20007ffe0ffULL,
0x000001002c2c7825ULL, 0x000fe200078e00ffULL, 0x00000009323f7212ULL, 0x000fe400078efcffULL,
0x0000003c60607810ULL, 0x000fe20007ffe0ffULL, 0x000001002e2e7825ULL, 0x000fc800078e00ffULL,
0x000000011d417824ULL, 0x000fe200000e063dULL, 0x000000471c3c7210ULL, 0x000fe20007f1e0ffULL,
0x0000001045457824ULL, 0x000fe200078e020eULL, 0x000000092c477212ULL, 0x080fe200078efcffULL,
0x000000011d297824ULL, 0x040fe200008e0629ULL, 0x000000092e497212ULL, 0x000fe200078efcffULL,
0x000000011d3d7824ULL, 0x000fe200000e0631ULL, 0x000000464a2c7210ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a457faeULL, 0x0003e2000b901c46ULL,
0x0000003f1c3e7210ULL, 0x040fe20007f3e0ffULL, 0x000000016b487824ULL, 0x000fe200078e0246ULL,
0x000000491c327210ULL, 0x000fe20007f5e0ffULL, 0x000000010a7d7824ULL, 0x000fe200078e0205ULL,
0x000000471c307210ULL, 0x000fe20007f1e0ffULL, 0x000000011d3f7824ULL, 0x040fe200008e0633ULL,
0x000000030a0a7819ULL, 0x000fe200000006ffULL, 0x000000011d337824ULL, 0x000fc400010e062fULL,
0x000000011d317824ULL, 0x000fe200000e062dULL, 0xfffffff80a7d7812ULL, 0x000fe200078ee27dULL,
0x000001002c2a7825ULL, 0x002fc600078e00ffULL, 0x0000000e7d7d7211ULL, 0x000fe200078e20ffULL,
0x000000014b2d7824ULL, 0x000fe200078e0246ULL, 0x000000092a2f7212ULL, 0x000fe200078efcffULL,
0x0000001044477824ULL, 0x000fe400078e020eULL, 0x000001002d2c7825ULL, 0x000fe200078e00ffULL,
0x0000002f1c2e7210ULL, 0x000fe40007f1e0ffULL, 0x0000000028477faeULL, 0x0003e2000b901c46ULL,
0x0000000153447824ULL, 0x000fe200078e0246ULL, 0x000000092c457212ULL, 0x000fe200078efcffULL,
0x000000011d2f7824ULL, 0x000fc400000e062bULL, 0x00000100442a7825ULL, 0x000fe200078e00ffULL,
0x000000451c2c7210ULL, 0x000fe40007f1e0ffULL, 0x0000004676447210ULL, 0x000fe20007ffe0ffULL,
0x000000014b0a7824ULL, 0x000fe200078e0205ULL, 0x000000092a457212ULL, 0x000fe200078efcffULL,
0x000000011d2d7824ULL, 0x000fe400000e062dULL, 0x0000010048287825ULL, 0x002fe200078e00ffULL,
0x000000451c2a7210ULL, 0x000fc60007f1e0ffULL, 0x0000010044447825ULL, 0x000fe200078e00ffULL,
0x0000000928477212ULL, 0x000fc600078efcffULL, 0x000000011d2b7824ULL, 0x000fe200000e062bULL,
0x000000471c287210ULL, 0x000fe20007f3e0ffULL, 0x0000000160487824ULL, 0x000fe200078e0246ULL,
0x0000000944477212ULL, 0x000fc600078efcffULL, 0x0000010048487825ULL, 0x000fe200078e00ffULL,
0x000000471c447210ULL, 0x000fc60007f1e0ffULL, 0x0000000175477824ULL, 0x000fe400078e0246ULL,
0x000000011d457824ULL, 0x000fe400000e0645ULL, 0x0000010047467825ULL, 0x000fc800078e00ffULL,
0x000000011d297824ULL, 0x000fe200008e0629ULL, 0x00000009467b7212ULL, 0x080fe400078efcffULL,
0x0000000948097212ULL, 0x000fe400078efcffULL, 0x0000007b1c467210ULL, 0x040fe40007f1e0ffULL,
0x000000091c1c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000170097824ULL, 0x040fe200078e0205ULL,
0x000000036f487819ULL, 0x000fe200000006ffULL, 0x0000000870707824ULL, 0x000fc400078e00ffULL,
0x000000011d477824ULL, 0x040fe400000e0647ULL, 0x000000011d1d7824ULL, 0x000fe200008e0649ULL,
0xfffffff870097812ULL, 0x000fe200078ee209ULL, 0x000000016c497824ULL, 0x140fe400078e0205ULL,
0x000000086c6c7824ULL, 0x000fe400078e00ffULL, 0x00000010097b7824ULL, 0x000fe400078e020eULL,
0x000000016f097824ULL, 0x000fe200078e0205ULL, 0xfffffff86c497812ULL, 0x000fe200078ee249ULL,
0x000000016e6f7824ULL, 0x040fe200078e0205ULL, 0x00000000427b7faeULL, 0x0003e2000b901c46ULL,
0x000000086e6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff848097812ULL, 0x000fe200078ee209ULL,
0x0000000152487824ULL, 0x000fc400078e0205ULL, 0x0000001049497824ULL, 0x100fe200078e020eULL,
0xfffffff86e6f7812ULL, 0x000fe200078ee26fULL, 0x0000001009097824ULL, 0x000fc800078e020eULL,
0x000000106f6f7824ULL, 0x000fe200078e020eULL, 0x000000001e097faeULL, 0x0005e2000b901c46ULL,
0x0000000151437824ULL, 0x042fe400078e0205ULL, 0x0000000851427824ULL, 0x000fe200078e00ffULL,
0x00000000406f7faeULL, 0x0005e2000b901c46ULL, 0x00000008527b7824ULL, 0x000fc600078e00ffULL,
0xfffffff842437812ULL, 0x000fe200078ee243ULL, 0x000000084b427824ULL, 0x000fe200078e00ffULL,
0xfffffff87b517812ULL, 0x000fe200078ee248ULL, 0x00000001534b7824ULL, 0x140fe200078e0205ULL,
0x000000003e497faeULL, 0x0005e2000b901c46ULL, 0x0000000853487824ULL, 0x000fe200078e00ffULL,
0xfffffff842537812ULL, 0x000fe200078ee20aULL, 0x000000016b0a7824ULL, 0x040fe400078e0205ULL,
0x000000086b427824ULL, 0x000fe200078e00ffULL, 0xfffffff8484b7812ULL, 0x000fe200078ee24bULL,
0x000000014a7b7824ULL, 0x000fc400078e0205ULL, 0x000000084a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8420a7812ULL, 0x000fe200078ee20aULL, 0x00000001766b7824ULL, 0x140fe200078e0205ULL,
0x0000000376767819ULL, 0x000fe200000006ffULL, 0x0000000175427824ULL, 0x040fe200078e0205ULL,
0xfffffff84a7b7812ULL, 0x000fe200078ee27bULL, 0x0000000875487824ULL, 0x000fe200078e00ffULL,
0xfffffff8766b7812ULL, 0x000fe200078ee26bULL, 0x0000000160757824ULL, 0x040fe400078e0205ULL,
0x0000000860607824ULL, 0x000fe200078e00ffULL, 0xfffffff848427812ULL, 0x000fe200078ee242ULL,
0x0000001051517824ULL, 0x000fc400078e020eULL, 0x0000001043437824ULL, 0x100fe200078e020eULL,
0xfffffff860757812ULL, 0x000fe200078ee275ULL, 0x000000107b7b7824ULL, 0x100fe200078e020eULL,
0x000000003c517faeULL, 0x0005e2000b901c46ULL, 0x0000001053537824ULL, 0x100fe400078e020eULL,
0x000000104b4b7824ULL, 0x100fe200078e020eULL, 0x0000000032437faeULL, 0x0005e2000b901c46ULL,
0x000000100a0a7824ULL, 0x100fe400078e020eULL, 0x000000106b6b7824ULL, 0x100fe200078e020eULL,
0x00000000307d7faeULL, 0x0005e2000b901c46ULL, 0x0000001042427824ULL, 0x000fc400078e020eULL,
0x0000001075757824ULL, 0x000fe200078e020eULL, 0x000000002e7b7faeULL, 0x0005e8000b901c46ULL,
0x000000002c537faeULL, 0x0005e8000b901c46ULL, 0x000000002a4b7faeULL, 0x0005e8000b901c46ULL,
0x00000000280a7faeULL, 0x0005e8000b901c46ULL, 0x00000000446b7faeULL, 0x0005e8000b901c46ULL,
0x0000000046427faeULL, 0x0005e8000b901c46ULL, 0x000000001c757faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000100b0a7824ULL, 0x044fe200078e00ffULL,
0x000000080c097810ULL, 0x008fe20007ffe0ffULL, 0x000000100b297824ULL, 0x000fe200078e00ffULL,
0x000030000d0d7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff00a097812ULL, 0x000fe400078ee209ULL,
0x0000000a0c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010581c7824ULL, 0x100fe200078e020dULL,
0x0000000409097819ULL, 0x000fe200000006ffULL, 0x0000001059407824ULL, 0x100fe200078e020dULL,
0xfffffff0290a7812ULL, 0x000fe200078ee20aULL, 0x000000105d2c7824ULL, 0x100fe400078e020dULL,
0x000000105a447824ULL, 0x100fe400078e020dULL, 0x000000105b3c7824ULL, 0x000fc400078e020dULL,
0x000000100a0a7824ULL, 0x000fe400078e00ffULL, 0x000000105c487824ULL, 0x100fe400078e020dULL,
0x0000001056587824ULL, 0x000fe200078e020dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001c1c783bULL, 0x000fe80000000200ULL, 0x000000000930783bULL, 0x0002a80000000200ULL,
0x000000004040783bULL, 0x000ee80000000200ULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x0000000c0c097810ULL, 0x002fc40007ffe0ffULL, 0x0000000e0c0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000000a28783bULL, 0x0003280000000200ULL, 0x000000004444783bULL, 0x000ee80000000200ULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x000000040b0a7819ULL, 0x042fe200000006ffULL,
0x000000100b0b7824ULL, 0x000fc400078e00ffULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0xfffffff00a097812ULL, 0x000fe400078ee209ULL, 0xfffffff00b0c7812ULL, 0x000fe200078ee20cULL,
0x000000005858783bULL, 0x000fe40000000200ULL, 0x0000001009097824ULL, 0x000fe400078e00ffULL,
0x000000100c0c7824ULL, 0x000fe200078e00ffULL, 0x0000001c3038723cULL, 0x044b6e0000041838ULL,
0x00000010611c7824ULL, 0x120fe200078e020dULL, 0x0000001e304c723cULL, 0x040b6a000004184cULL,
0x000000001c1c783bULL, 0x020e660000000200ULL, 0x000000403018723cULL, 0x008b6e0000041818ULL,
0x0000001063407824ULL, 0x120fe200078e020dULL, 0x0000002c2838723cULL, 0x010bee0000041838ULL,
0x00000010652c7824ULL, 0x120fe200078e020dULL, 0x000000443010723cULL, 0x040bee0000041810ULL,
0x0000001067447824ULL, 0x120fe200078e020dULL, 0x000000463014723cULL, 0x040bea0000041814ULL,
0x000000004444783bULL, 0x020fe60000000200ULL, 0x000000423020723cULL, 0x040b640000041820ULL,
0x000000004040783bULL, 0x020fec0000000200ULL, 0x0000003c3024723cULL, 0x040f700000041824ULL,
0x0000003e3034723cULL, 0x000b640000041834ULL, 0x00000000093c783bULL, 0x020fea0000000200ULL,
0x0000001062307824ULL, 0x100fe200078e020dULL, 0x0000002e284c723cULL, 0x040b64000004184cULL,
0x000000002c2c783bULL, 0x020ea80000000200ULL, 0x000000003030783bULL, 0x000ee40000000200ULL,
0x0000001c2818723cULL, 0x042b6e0000041818ULL, 0x00000010661c7824ULL, 0x120fe200078e020dULL,
0x0000001e2820723cULL, 0x040b6a0000041820ULL, 0x000000001c1c783bULL, 0x020e660000000200ULL,
0x000000482810723cULL, 0x040bee0000041810ULL, 0x000000105f487824ULL, 0x120fe200078e020dULL,
0x0000004a2814723cULL, 0x040bea0000041814ULL, 0x000000004848783bULL, 0x020fe60000000200ULL,
0x0000002c2824723cULL, 0x044b6e0000041824ULL, 0x00000010642c7824ULL, 0x020fe200078e020dULL,
0x0000002e2834723cULL, 0x000b640000041834ULL, 0x000000000c28783bULL, 0x020fe80000000200ULL,
0x000000002c2c783bULL, 0x000fe40000000200ULL, 0x000000303c38723cULL, 0x048bee0000041838ULL,
0x0000000d57307211ULL, 0x020fe200078e20ffULL, 0x000000323c4c723cULL, 0x040bea000004184cULL,
0x000000003030783bULL, 0x020ea60000000200ULL, 0x0000001c3c18723cULL, 0x042f700000041818ULL,
0x0000001e3c20723cULL, 0x040f700000041820ULL, 0x000000443c24723cULL, 0x040f700000041824ULL,
0x000000403c10723cULL, 0x040ff00000041810ULL, 0x000000423c14723cULL, 0x040ff00000041814ULL,
0x000000463c34723cULL, 0x000ff00000041834ULL, 0x000000302818723cULL, 0x064f700000041818ULL,
0x000000322820723cULL, 0x040f700000041820ULL, 0x000000582824723cULL, 0x040f700000041824ULL,
0x0000002c2838723cULL, 0x000b640000041838ULL, 0x3db504f318187820ULL, 0x020fc40000410000ULL,
0x3db504f31b097820ULL, 0x000fc60000410000ULL, 0x3db504f3192c7820ULL, 0x000fe20000410000ULL,
0x0000002e284c723cULL, 0x040b62000004184cULL, 0x3db504f321317820ULL, 0x000fe40000410000ULL,
0x3db504f31a197820ULL, 0x000fe40000410000ULL, 0x3db504f3202d7820ULL, 0x000fe40000410000ULL,
0x3db504f3220c7820ULL, 0x000fe20000410000ULL, 0x000000482810723cULL, 0x000f620000041810ULL,
0x3db504f3271d7820ULL, 0x000fc40000410000ULL, 0x3db504f3230d7820ULL, 0x000fe40000410000ULL,
0x3db504f324307820ULL, 0x000fe40000410000ULL, 0x3db504f3252e7820ULL, 0x020fe20000410000ULL,
0x0000004a2814723cULL, 0x000f620000041814ULL, 0x3db504f338387820ULL, 0x000fe40000410000ULL,
0x3db504f33a3a7820ULL, 0x000fe40000410000ULL, 0x3db504f33b3b7820ULL, 0x000fc40000410000ULL,
0x3db504f3261c7820ULL, 0x000fe20000410000ULL, 0x0000005a2834723cULL, 0x000b620000041834ULL,
0x3db504f34d327820ULL, 0x000fe40000410000ULL, 0x3db504f34e4e7820ULL, 0x000fe40000410000ULL,
0x3db504f34f337820ULL, 0x000fe40000410000ULL, 0x3db504f339287820ULL, 0x020fe40000410000ULL,
0x3db504f34c297820ULL, 0x000fc40000410000ULL, 0x3db504f3102f7820ULL, 0x000fe40000410000ULL,
0x3db504f3112a7820ULL, 0x000fe40000410000ULL, 0x3db504f312127820ULL, 0x000fe40000410000ULL,
0x3db504f313137820ULL, 0x000fe40000410000ULL, 0x3db504f3142b7820ULL, 0x000fe40000410000ULL,
0x3db504f315157820ULL, 0x000fc40000410000ULL, 0x3db504f316167820ULL, 0x000fe40000410000ULL,
0x3db504f317177820ULL, 0x000fe40000410000ULL, 0x3db504f334277820ULL, 0x000fe40000410000ULL,
0x3db504f335217820ULL, 0x000fe40000410000ULL, 0x3db504f3361e7820ULL, 0x000fe40000410000ULL,
0x3db504f3371f7820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000730a7f8cULL, 0x0002a2000c80043fULL, 0x000000ffff347224ULL, 0x000fe200078e0018ULL,
0x0000001600267202ULL, 0x000fe20000000f00ULL, 0x000000ffff357224ULL, 0x000fc400078e0017ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0038ULL, 0x000000ffff367224ULL, 0x000fe400078e0015ULL,
0x000000ffff227224ULL, 0x000fe400078e003aULL, 0x000000ffff1a7224ULL, 0x000fe400078e003bULL,
0x000000ffff237224ULL, 0x000fe400078e004eULL, 0x000000ffff257224ULL, 0x000fc400078e0012ULL,
0x000000ffff247224ULL, 0x000fe400078e0013ULL, 0x000000ffff187224ULL, 0x000fe400078e0009ULL,
0x000000ffff167224ULL, 0x000fe400078e000cULL, 0x000000ffff177224ULL, 0x000fc400078e000dULL,
0x00000000000c7805ULL, 0x002fca0000015200ULL, 0x0000040073097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x006fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100c0e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000111107824ULL, 0x000fe200000e0e0dULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011410ULL, 0x0000000e09097211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0610ULL, 0x0000000209097819ULL, 0x000fc8000000120eULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040073097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000405207824ULL, 0x000fe200078e00ffULL,
0x000000710300720cULL, 0x000fc80003f06070ULL, 0xfffffff020097812ULL, 0x000fca00078ec0ffULL,
0x00000080020e7824ULL, 0x000fca00078e0209ULL, 0x01b400000e107984ULL, 0x0002a20000000c00ULL,
0x000014e000008947ULL, 0x000fea0003800000ULL, 0x00005a00000c7b06ULL, 0x000ee20000209000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fcc0003f85070ULL,
0x0000000c000c7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0c0b7810ULL, 0x008fcc0007ffe0ffULL,
0x0000000b000b7305ULL, 0x000ee4000021f000ULL, 0x8000000bff037210ULL, 0x008fca0007ffe0ffULL,
0x00005a0003037a24ULL, 0x000fc800078e02ffULL, 0x000000030b147227ULL, 0x000fe200078e000aULL,
0x0000007205037211ULL, 0x000fe400078ff0ffULL, 0x00000008690b7217ULL, 0x000fc60007800000ULL,
0x0000000314097227ULL, 0x000fc800078e00ffULL, 0x000000ffff0a7224ULL, 0x000fe400078e0a09ULL,
0x000000010b387824ULL, 0x000fe400078e0a08ULL, 0x00005a000a0a7a24ULL, 0x000fe200078e0203ULL,
0x0000000803037810ULL, 0x000fc80007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fe20003f06070ULL,
0x00000003140d7227ULL, 0x000fe200078e00ffULL, 0x00005a00ff147a12ULL, 0x000fc600078e33ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0a0dULL, 0x00005a000c0c7a24ULL, 0x000fe400078e0203ULL,
0x0000000205037824ULL, 0x000fe400078e00ffULL, 0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL,
0x00005a000c007a0cULL, 0x000fe40003f46070ULL, 0x00005a000a007a0cULL, 0x000fe40003f26070ULL,
0x0000000603037812ULL, 0x000fc400078ec0ffULL, 0x0000000109090810ULL, 0x000fc60007ffe0ffULL,
0x00000001070b7824ULL, 0x000fe400078e0203ULL, 0x0000000103377824ULL, 0x000fe400078e0200ULL,
0x80005a000c0c2a10ULL, 0x000fe40007ffe0ffULL, 0x000000380b00720cULL, 0x040fe20003f66070ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a38ULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x00005a000c007a0cULL, 0x000fc40003f06070ULL, 0x0000000914097207ULL, 0x000fe40006000000ULL,
0x0000000b06087217ULL, 0x040fe20003800000ULL, 0x00000001370b7824ULL, 0x040fe200078e0a38ULL,
0x0000000906097217ULL, 0x000fe40003800000ULL, 0x00000004ff087819ULL, 0x000fe40000011608ULL,
0x000000383700720cULL, 0x000fe20003f26070ULL, 0x000000096a4f7224ULL, 0x000fe200078e02ffULL,
0x0000000b060b7217ULL, 0x000fc40003800000ULL, 0x000000ff080c7207ULL, 0x000fe40001800000ULL,
0x000000010d0d2810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0b467207ULL, 0x000fe40000800000ULL,
0x0000000c4f097210ULL, 0x000fe40007ffe0ffULL, 0x000000010d0d0810ULL, 0x000fe40007ffe0ffULL,
0x0000004f460b7211ULL, 0x000fe200078fe0ffULL, 0x0000000209087825ULL, 0x000fe200078e0054ULL,
0x0000000d140d7207ULL, 0x000fc40006000000ULL, 0x00000010033b7812ULL, 0x000fe200078efcffULL,
0x000000020b0a7825ULL, 0x000fe200078e0054ULL, 0x0000000d060d7217ULL, 0x000fe20003800000ULL,
0x00000006084c7981ULL, 0x000728000c1e9500ULL, 0x000000060a4d7981ULL, 0x000322000c1e9500ULL,
0x0000000d6a517224ULL, 0x000fe400078e02ffULL, 0x000000013b397824ULL, 0x000fc400078e0200ULL,
0x000000010c0d7824ULL, 0x000fe200078e0251ULL, 0x00000020033d7812ULL, 0x000fe200078efcffULL,
0x0000000107097824ULL, 0x008fe200078e023bULL, 0x0000005146157211ULL, 0x000fe200078fe0ffULL,
0x000000020d0c7825ULL, 0x000fc800078e0054ULL, 0x00000001090b7824ULL, 0x142fe200078e0a38ULL,
0x000000380900720cULL, 0x080fe20003f26070ULL, 0x0000000139097824ULL, 0x040fe200078e0a38ULL,
0x000000060c487981ULL, 0x0002e2000c1e9500ULL, 0x000000383900720cULL, 0x000fe20003f06070ULL,
0x0000000107457824ULL, 0x000fe200078e023dULL, 0x0000000b060b7217ULL, 0x000fe20003800000ULL,
0x0000000215147825ULL, 0x000fc600078e0054ULL, 0x00000004ff0b7819ULL, 0x000fe4000001160bULL,
0x0000000906097217ULL, 0x000fe20003800000ULL, 0x0000000145437824ULL, 0x000fe200078e0a38ULL,
0x000000ff0b0c7207ULL, 0x002fe20000800000ULL, 0x0000000614577981ULL, 0x0002e2000c1e9500ULL,
0x000000ff093a7207ULL, 0x000fc60000000000ULL, 0x000000014f097824ULL, 0x000fe200078e020cULL,
0x000000003d417210ULL, 0x000fc60007ffe0ffULL, 0x0000000209087825ULL, 0x000fe200078e0054ULL,
0x0000004306407217ULL, 0x000fe40003800000ULL, 0x000000384500720cULL, 0x080fe40003f26070ULL,
0x00000006083c7981ULL, 0x0004e2000c1e9500ULL, 0x00000004ff407819ULL, 0x000fe40000011640ULL,
0x000000384100720cULL, 0x040fe40003f06070ULL, 0x000000ff40447207ULL, 0x000fe20000800000ULL,
0x0000000141097824ULL, 0x004fe200078e0a38ULL, 0x0000003003457812ULL, 0x000fc800078efcffULL,
0x0000000906097217ULL, 0x000fe20003800000ULL, 0x000000010c0d7824ULL, 0x000fe200078e0251ULL,
0x0000004f3a0b7211ULL, 0x040fe400078fe0ffULL, 0x000000513a157211ULL, 0x002fe400078fe0ffULL,
0x000000ff09407207ULL, 0x000fe20000000000ULL, 0x000000014f097824ULL, 0x000fe400078e0244ULL,
0x0000000107537824ULL, 0x000fe400078e0245ULL, 0x000000020b0a7825ULL, 0x000fc800078e0054ULL,
0x000000020d0c7825ULL, 0x100fe200078e0054ULL, 0x000000060a3f7981ULL, 0x0002a6000c1e9500ULL,
0x0000000215147825ULL, 0x100fe200078e0054ULL, 0x000000060c3e7981ULL, 0x0002a6000c1e9500ULL,
0x0000000209087825ULL, 0x000fe200078e0054ULL, 0x0000000614437981ULL, 0x0002a6000c1e9500ULL,
0x00000001534b7824ULL, 0x000fe200078e0a38ULL, 0x0000000608427981ULL, 0x0002a2000c1e9500ULL,
0x0000000145497824ULL, 0x000fe200078e0200ULL, 0x0000004f400b7211ULL, 0x002fc400078fe0ffULL,
0x0000004b064a7217ULL, 0x000fe20003800000ULL, 0x00000001440d7824ULL, 0x000fe200078e0251ULL,
0x0000005140157211ULL, 0x000fe200078fe0ffULL, 0x0000000149097824ULL, 0x000fe200078e0a38ULL,
0x000000385300720cULL, 0x080fe40003f26070ULL, 0x00000004ff4a7819ULL, 0x000fe2000001164aULL,
0x000000020b0a7825ULL, 0x100fe200078e0054ULL, 0x000000384900720cULL, 0x000fe40003f06070ULL,
0x0000000906097217ULL, 0x000fe20003800000ULL, 0x000000020d0c7825ULL, 0x100fe200078e0054ULL,
0x000000ff4a4e7207ULL, 0x000fe20000800000ULL, 0x000000060a477981ULL, 0x0002a4000c1e9500ULL,
0x0000000215147825ULL, 0x000fe200078e0054ULL, 0x000000ff094a7207ULL, 0x000fe20000000000ULL,
0x000000060c447981ULL, 0x0002a8000c1e9500ULL, 0x00000006144b7981ULL, 0x0002a2000c1e9500ULL,
0x000000014f097824ULL, 0x000fe200078e024eULL, 0x0000004f4a0b7211ULL, 0x002fc600078fe0ffULL,
0x0000000209087825ULL, 0x000fc800078e0054ULL, 0x000000020b0a7825ULL, 0x000fe400078e0054ULL,
0x0000000608087981ULL, 0x0002a2000c1e9500ULL, 0x000000514a0d7211ULL, 0x000fc600078fe0ffULL,
0x000000060a0b7981ULL, 0x0002a2000c1e9500ULL, 0x000000014e157824ULL, 0x000fe400078e0251ULL,
0x000000020d0c7825ULL, 0x000fc800078e0054ULL, 0x0000000215147825ULL, 0x000fe400078e0054ULL,
0x000000060c0c7981ULL, 0x0002a8000c1e9500ULL, 0x0000000614157981ULL, 0x0002a2000c1e9500ULL,
0xfffffff046517812ULL, 0x000fca00078ec0ffULL, 0x00000001384e7824ULL, 0x000fe200078e0251ULL,
0x0000000100467802ULL, 0x000fc60000000f00ULL, 0x0000000137597824ULL, 0x000fe200078e0a4eULL,
0x00000001034f7812ULL, 0x040fe400078efcffULL, 0x0000000903097812ULL, 0x002fe400078efcffULL,
0x0000005946597219ULL, 0x000fe200000006ffULL, 0x000000014f537824ULL, 0x100fe400078e0200ULL,
0x00000001090d7824ULL, 0x000fe400078e0200ULL, 0x00000001535b7824ULL, 0x000fc400078e0a4eULL,
0x000000010d5f7824ULL, 0x000fe200078e0a4eULL, 0x00000018036f7812ULL, 0x000fe400078efcffULL,
0x0000005b465b7219ULL, 0x040fe400000006ffULL, 0x0000005f465f7219ULL, 0x000fe400000006ffULL,
0xfffffff03a3a7812ULL, 0x000fe400078ec0ffULL, 0x000000006f7d7210ULL, 0x000fe40007ffe0ffULL,
0x0000001103757812ULL, 0x000fc400078efcffULL, 0x00000019036b7812ULL, 0x000fc600078efcffULL,
0x00000001750a7824ULL, 0x100fe400078e0200ULL, 0x000000016b7b7824ULL, 0x000fe200078e0200ULL,
0x0000002103617812ULL, 0x000fe400078efcffULL, 0xfffffff04a4a7812ULL, 0x000fc600078ec0ffULL,
0x0000000161677824ULL, 0x000fe400078e0200ULL, 0x00000001384a7824ULL, 0x000fc800078e024aULL,
0x0000000149567824ULL, 0x000fca00078e0a4aULL, 0x0000005646567219ULL, 0x000fe400000006ffULL,
0x000054104d4c7816ULL, 0x010fe4000000004cULL, 0x00000008034d7812ULL, 0x000fe400078efcffULL,
0x0000004c59ff7212ULL, 0x000fc6000780c0ffULL, 0x000000014d517824ULL, 0x000fe200078e0200ULL,
0x000000383700720cULL, 0x000fc60000701470ULL, 0x00000001515d7824ULL, 0x000fe200078e0a4eULL,
0x000000380300720cULL, 0x000fc800007a1070ULL, 0x0000005d465d7219ULL, 0x000fe400000006ffULL,
0xff8000001b1b7808ULL, 0x000fe40002800000ULL, 0x0000541057487816ULL, 0x008fc80000000048ULL,
0x0000004859ff7212ULL, 0x080fe4000784c0ffULL, 0x000000485bff7212ULL, 0x080fe4000780c0ffULL,
0x000000485dff7212ULL, 0x080fe400078cc0ffULL, 0x000000485fff7212ULL, 0x000fe400078ac0ffULL,
0xfffffff040487812ULL, 0x000fe200078ec0ffULL, 0x0000000138407824ULL, 0x000fe200078e023aULL,
0x0000004c5bff7212ULL, 0x000fc4000782c0ffULL, 0x0000004c5dff7212ULL, 0x080fe2000786c0ffULL,
0x000000017d587824ULL, 0x000fe200078e0a40ULL, 0x0000004c5fff7212ULL, 0x000fe4000788c0ffULL,
0x000000383700720cULL, 0x080fe40001741470ULL, 0x000000385100720cULL, 0x080fe400037c1470ULL,
0x000000380d00720cULL, 0x000fe40002fa1470ULL, 0x80000040394c7210ULL, 0x000fc40007ffe0ffULL,
0x000000380300720cULL, 0x080fe40001741070ULL, 0x000000384d00720cULL, 0x080fe400037c1070ULL,
0x000000380900720cULL, 0x000fe40002fa1070ULL, 0x0000004c464c7219ULL, 0x040fe400000006ffULL,
0x0000005846587219ULL, 0x000fe200000006ffULL, 0x0000000138487824ULL, 0x000fe200078e0248ULL,
0xff80000022227808ULL, 0x000fc40001000000ULL, 0xff80000023237808ULL, 0x000fe40003000000ULL,
0x000054103f3f7816ULL, 0x004fe4000000003cULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0x0000003f4cff7212ULL, 0x000fe4000784c0ffULL, 0x0000541043437816ULL, 0x000fc8000000003eULL,
0x000000434cff7212ULL, 0x080fe400078cc0ffULL, 0x0000004358ff7212ULL, 0x000fe200078ac0ffULL,
0x000000010a527824ULL, 0x100fe200078e0a40ULL, 0x000000385300720cULL, 0x080fe20000f21470ULL,
0x000000017b627824ULL, 0x000fe200078e0a40ULL, 0x000000385300720cULL, 0x080fe20000701470ULL,
0x0000000141607824ULL, 0x000fe200078e0a48ULL, 0x000000385100720cULL, 0x080fe40001f61470ULL,
0x000000380d00720cULL, 0x000fc40002781470ULL, 0x000000383900720cULL, 0x0c0fe40001741470ULL,
0x000000383900720cULL, 0x080fe400037c1470ULL, 0x000000387d00720cULL, 0x080fe40002fa1470ULL,
0x00000028035f7812ULL, 0x040fe400078efcffULL, 0x00000029035d7812ULL, 0x000fe400078efcffULL,
0x000000384f00720cULL, 0x000fc40000f21070ULL, 0x000000384f00720cULL, 0x080fe40000701070ULL,
0x000000384d00720cULL, 0x080fe40001f61070ULL, 0x000000380900720cULL, 0x080fe40002781070ULL,
0x000000383b00720cULL, 0x0c0fe40001741070ULL, 0x000000383b00720cULL, 0x080fe400037c1070ULL,
0x000000386f00720cULL, 0x000fc40002fa1070ULL, 0x0000005246527219ULL, 0x040fe400000006ffULL,
0x0000006246627219ULL, 0x040fe400000006ffULL, 0x0000006046607219ULL, 0x000fe400000006ffULL,
0x0000541047477816ULL, 0x000fe40000000042ULL, 0x000054104b4b7816ULL, 0x000fe20000000044ULL,
0x000000015f657824ULL, 0x100fe200078e0200ULL, 0xff80000028287808ULL, 0x000fe20000800000ULL,
0x000000015d637824ULL, 0x000fe200078e0200ULL, 0xff8000001a1a7808ULL, 0x000fc40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000032327808ULL, 0x000fe40002000000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0x0000003f52ff7212ULL, 0x000fc4000782c0ffULL,
0x0000003f58ff7212ULL, 0x080fe4000780c0ffULL, 0x0000003f62ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004352ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004362ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004760ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004b60ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000167647824ULL, 0x100fe200078e0a48ULL, 0x000000380a00720cULL, 0x0c0fe20000f21470ULL,
0x00000001655a7824ULL, 0x100fe200078e0a48ULL, 0x000000380a00720cULL, 0x080fe20002781470ULL,
0x00000001635c7824ULL, 0x000fe200078e0a48ULL, 0x000000387d00720cULL, 0x000fc40000701470ULL,
0x000000387b00720cULL, 0x0c0fe40001f61470ULL, 0x000000387b00720cULL, 0x080fe40001741470ULL,
0x000000384100720cULL, 0x0c0fe400037c1470ULL, 0x000000384100720cULL, 0x000fe40002fa1470ULL,
0x00000031035b7812ULL, 0x040fe400078efcffULL, 0x0000003803597812ULL, 0x000fc400078efcffULL,
0x0000003903577812ULL, 0x000fe400078efcffULL, 0x000000387500720cULL, 0x0c0fe40000f21070ULL,
0x000000387500720cULL, 0x080fe40002781070ULL, 0x000000386f00720cULL, 0x080fe40000701070ULL,
0x000000386b00720cULL, 0x0c0fe40001f61070ULL, 0x000000386b00720cULL, 0x000fc40001741070ULL,
0x000000383d00720cULL, 0x0c0fe400037c1070ULL, 0x000000383d00720cULL, 0x000fe40002fa1070ULL,
0x0000006446647219ULL, 0x040fe400000006ffULL, 0x0000005a465a7219ULL, 0x040fe400000006ffULL,
0x0000005c465c7219ULL, 0x000fe400000006ffULL, 0x000054100b0b7816ULL, 0x000fe20000000008ULL,
0x000000015b147824ULL, 0x100fe200078e0200ULL, 0xff8000002a2a7808ULL, 0x000fe20000800000ULL,
0x00000001593a7824ULL, 0x100fe200078e0200ULL, 0xff80000024247808ULL, 0x000fe20002000000ULL,
0x0000000157407824ULL, 0x000fe200078e0200ULL, 0xff8000002b2b7808ULL, 0x000fc40000000000ULL,
0xff80000036367808ULL, 0x000fe40001800000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff80000034347808ULL, 0x000fe40003000000ULL, 0xff80000019197808ULL, 0x000fe40002800000ULL,
0x0000004764ff7212ULL, 0x080fe4000782c0ffULL, 0x000000475aff7212ULL, 0x000fc4000788c0ffULL,
0x000000475cff7212ULL, 0x000fe4000780c0ffULL, 0x0000004b64ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004b5aff7212ULL, 0x080fe4000784c0ffULL, 0x0000004b5cff7212ULL, 0x000fe400078cc0ffULL,
0x0000000b56ff7212ULL, 0x000fe200078ac0ffULL, 0x000000013a487824ULL, 0x100fe200078e0a4aULL,
0x000000144a4e7210ULL, 0x000fe20007ffe1ffULL, 0x00000001404a7824ULL, 0x000fe200078e0a4aULL,
0x000000386700720cULL, 0x000fc40000f21470ULL, 0x000000386700720cULL, 0x080fe40001f61470ULL,
0x000000386500720cULL, 0x0c0fe40002781470ULL, 0x000000386500720cULL, 0x080fe40001741470ULL,
0x000000386300720cULL, 0x0c0fe40000701470ULL, 0x000000386300720cULL, 0x080fe400037c1470ULL,
0x000000384900720cULL, 0x000fc40002fa1470ULL, 0x000000386100720cULL, 0x0c0fe40000f21070ULL,
0x000000386100720cULL, 0x080fe40001f61070ULL, 0x000000385f00720cULL, 0x0c0fe40002781070ULL,
0x000000385f00720cULL, 0x080fe40001741070ULL, 0x000000385d00720cULL, 0x0c0fe40000701070ULL,
0x000000385d00720cULL, 0x000fc400037c1070ULL, 0x000000384500720cULL, 0x000fe40002fa1070ULL,
0x0000004e464e7219ULL, 0x040fe400000006ffULL, 0x0000004846487219ULL, 0x040fe400000006ffULL,
0x0000004a464a7219ULL, 0x000fe400000006ffULL, 0x000054100c157816ULL, 0x000fe40000000015ULL,
0xff8000002c2c7808ULL, 0x000fc40000800000ULL, 0xff80000018187808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff80000016167808ULL, 0x000fe40001000000ULL,
0xff80000031317808ULL, 0x000fe40000000000ULL, 0xff80000017177808ULL, 0x000fe40003000000ULL,
0xff80000030307808ULL, 0x000fc40002800000ULL, 0x0000000b4eff7212ULL, 0x080fe4000782c0ffULL,
0x0000000b48ff7212ULL, 0x080fe4000786c0ffULL, 0x0000000b4aff7212ULL, 0x000fe4000788c0ffULL,
0x0000001556ff7212ULL, 0x080fe4000784c0ffULL, 0x000000154eff7212ULL, 0x080fe4000780c0ffULL,
0x0000001548ff7212ULL, 0x000fc400078cc0ffULL, 0x000000154aff7212ULL, 0x000fe400078ac0ffULL,
0x000000384900720cULL, 0x080fe40001741470ULL, 0x000000381400720cULL, 0x0c0fe40000f21470ULL,
0x000000381400720cULL, 0x080fe40000701470ULL, 0x000000383a00720cULL, 0x0c0fe40001f61470ULL,
0x000000383a00720cULL, 0x000fc400037c1470ULL, 0x000000384000720cULL, 0x0c0fe40002781470ULL,
0x000000384000720cULL, 0x080fe40002fa1470ULL, 0x000000384500720cULL, 0x080fe40001741070ULL,
0x000000385b00720cULL, 0x0c0fe40000f21070ULL, 0x000000385b00720cULL, 0x080fe40000701070ULL,
0x000000385900720cULL, 0x000fc40001f61070ULL, 0x000000385900720cULL, 0x080fe400037c1070ULL,
0x000000385700720cULL, 0x0c0fe40002781070ULL, 0x000000385700720cULL, 0x000fe40002fa1070ULL,
0xff8000002e2e7808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fc40002000000ULL, 0xff8000001c1c7808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40000000000ULL, 0xff8000001e1e7808ULL, 0x000fe40003000000ULL,
0xff8000001f1f7808ULL, 0x000fc40002800000ULL, 0x0000001b1000720bULL, 0x004fe40003f1e000ULL,
0x000000221100720bULL, 0x000fe40003f3e000ULL, 0x000000101b037208ULL, 0x000fc40004000000ULL,
0x0000001122117208ULL, 0x000fe40004800000ULL, 0x000000280300720bULL, 0x000fe40003f1e000ULL,
0x0000001a1100720bULL, 0x000fe40003f3e000ULL, 0x0000000328087208ULL, 0x000fe40004000000ULL,
0x000000111a0a7208ULL, 0x000fe40004800000ULL, 0x000000290800720bULL, 0x000fc40003f1e000ULL,
0x000000230a00720bULL, 0x000fe40003f3e000ULL, 0x0000000829037208ULL, 0x000fe40004000000ULL,
0x0000000a230a7208ULL, 0x000fe40004800000ULL, 0x000000320300720bULL, 0x000fe40003f1e000ULL,
0x000000330a00720bULL, 0x000fe40003f3e000ULL, 0x0000000332087208ULL, 0x000fc40004000000ULL,
0x0000000a330a7208ULL, 0x000fe40004800000ULL, 0x0000002f0800720bULL, 0x000fe40003f1e000ULL,
0x000000250a00720bULL, 0x000fe40003f3e000ULL, 0x000000082f037208ULL, 0x000fe40004000000ULL,
0x0000000a25097208ULL, 0x000fe40004800000ULL, 0x0000002a0300720bULL, 0x000fc40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x000000032a087208ULL, 0x000fe40004000000ULL,
0x0000000924097208ULL, 0x000fe40004800000ULL, 0x0000002b0800720bULL, 0x000fe40003f1e000ULL,
0x000000260900720bULL, 0x000fe40003f3e000ULL, 0x000000082b037208ULL, 0x000fc40004000000ULL,
0x0000000926087208ULL, 0x000fe40004800000ULL, 0x000000360300720bULL, 0x000fe40003f1e000ULL,
0x000000350800720bULL, 0x000fe40003f3e000ULL, 0x0000000336037208ULL, 0x000fe40004000000ULL,
0x0000000835087208ULL, 0x000fe40004800000ULL, 0x000000340300720bULL, 0x000fc40003f1e000ULL,
0x000000190800720bULL, 0x000fe40003f3e000ULL, 0x0000000334037208ULL, 0x000fe40004000000ULL,
0x0000000819097208ULL, 0x000fe40004800000ULL, 0x0000002c0300720bULL, 0x000fe40003f1e000ULL,
0x000000180900720bULL, 0x000fe40003f3e000ULL, 0x000000032c087208ULL, 0x000fc40004000000ULL,
0x0000000918097208ULL, 0x000fe40004800000ULL, 0x0000002d0800720bULL, 0x000fe40003f1e000ULL,
0x000000160900720bULL, 0x000fe40003f3e000ULL, 0x000000082d087208ULL, 0x000fe40004000000ULL,
0x00000009160a7208ULL, 0x000fe40004800000ULL, 0x000000310800720bULL, 0x000fc40003f1e000ULL,
0x000000170a00720bULL, 0x000fe40003f3e000ULL, 0x0000000831037208ULL, 0x000fe40004000000ULL,
0x0000000a17097208ULL, 0x000fe40004800000ULL, 0x000000300300720bULL, 0x000fe40003f1e000ULL,
0x0000001c0900720bULL, 0x000fe40003f3e000ULL, 0x0000000330037208ULL, 0x000fc40004000000ULL,
0x000000091c087208ULL, 0x000fe40004800000ULL, 0x0000002e0300720bULL, 0x000fe40003f1e000ULL,
0x0000001d0800720bULL, 0x000fe40003f3e000ULL, 0x000000032e0a7208ULL, 0x000fe40004000000ULL,
0x000000081d037208ULL, 0x000fe40004800000ULL, 0x000000270a00720bULL, 0x000fc40003f1e000ULL,
0x0000001e0300720bULL, 0x000fe40003f3e000ULL, 0x0000000a270a7208ULL, 0x000fe40004000000ULL,
0x000000031e087208ULL, 0x000fe40004800000ULL, 0x000000210a00720bULL, 0x000fe40003f1e000ULL,
0x0000001f0800720bULL, 0x000fe40003f3e000ULL, 0x0000000a21107208ULL, 0x000fc40004000000ULL,
0x000000081f147208ULL, 0x000fe20004800000ULL, 0x000017127f007947ULL, 0x000fec000b800000ULL,
0x0c401f0010037f89ULL, 0x0004e400000e0000ULL, 0x000000031000720bULL, 0x00cfc80003f1e000ULL,
0x00000010033a7208ULL, 0x000fe20004000000ULL, 0x000017327f007947ULL, 0x000fea000b800000ULL,
0x0c401f0014037f89ULL, 0x000ea800000e0000ULL, 0x0c401f0012097f89ULL, 0x000ee800000e0000ULL,
0x0c401f0013087f89ULL, 0x000f2200000e0000ULL, 0x000000031400720bULL, 0x004fc40003f1e000ULL,
0x000000091200720bULL, 0x008fe40003f3e000ULL, 0x0000001403037208ULL, 0x000fe40004000000ULL,
0x00000012090c7208ULL, 0x000fe40004800000ULL, 0x0c201f003a097f89ULL, 0x000ea200000e0000ULL,
0x000000081300720bULL, 0x010fc60003f1e000ULL, 0x0c201f00030a7f89ULL, 0x000ee200000e0000ULL,
0x00000013080b7208ULL, 0x000fc60004000000ULL, 0x0c201f000c0d7f89ULL, 0x000f2800000e0000ULL,
0x0c201f000b387f89ULL, 0x00226200000e0000ULL, 0x000000093a00720bULL, 0x004fe40003f1e000ULL,
0x0000000a0300720bULL, 0x008fe40003f3e000ULL, 0x0000003a09087208ULL, 0x000fe40004000000ULL,
0x0000000d0c00720bULL, 0x010fc40003f5e000ULL, 0x000000030a097208ULL, 0x000fe40004800000ULL,
0x0000000c0d0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b08037820ULL, 0x002fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000305ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010803ULL, 0x000000380b00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b2b137823ULL, 0x100fe40000010803ULL, 0x0000002900127308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010803ULL, 0x0000000b380b7208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b32327823ULL, 0x000fc40000010803ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b2a0c7823ULL, 0x100fe20000010803ULL, 0x00000028000d7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b2e297823ULL, 0x102fe40000010803ULL, 0x3fb8aa3b092e7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b36367823ULL, 0x000fe40000010803ULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082eULL,
0x0000003200117308ULL, 0x000e620000000800ULL, 0x3fb8aa3b23237823ULL, 0x000fc4000001082eULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b33337823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b30287823ULL, 0x004fe20000010803ULL, 0x0000001300377308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001082eULL, 0x3fb8aa3b24247823ULL, 0x100fe4000001082eULL,
0x3fb8aa3b26267823ULL, 0x000fc4000001082eULL, 0x3fb8aa3b35357823ULL, 0x000fe2000001082eULL,
0x0000001b00107308ULL, 0x000ea20000000800ULL, 0x000000121112723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b2c2b7823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b342a7823ULL, 0x100fe40000010803ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2c7823ULL, 0x000fc40000010803ULL, 0x3fb8aa3b312d7823ULL, 0x100fe40000010803ULL,
0x3fb8aa3b27277823ULL, 0x100fe40000010803ULL, 0x3fb8aa3b21037823ULL, 0x000fe20000010803ULL,
0x0000001a00137308ULL, 0x000e620000000800ULL, 0x000000100d10723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b1c217823ULL, 0x000fcc000001082eULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000003300307308ULL, 0x000ea20000000800ULL, 0x000000221311723eULL, 0x002fe200000010ffULL,
0x3fb8aa3b19227823ULL, 0x000fcc000001082eULL, 0x0000000c00157308ULL, 0x0003e20000000800ULL,
0x000000233013723eULL, 0x004fe200000010ffULL, 0x00000004ff0c7e24ULL, 0x002fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b18237823ULL, 0x000fc8000001082eULL,
0x0000002f00147308ULL, 0x0002a20000000800ULL, 0x00000002ff307819ULL, 0x000fe40000011605ULL,
0x3f8000000c0c783eULL, 0x000fe400000010ffULL, 0x00000001301c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008303a7824ULL, 0x040fe200078e00ffULL, 0x0000000330347819ULL, 0x000fe200000006ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0x0000003600367308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b172f7823ULL, 0x002fc4000001082eULL, 0x000000ffff327224ULL, 0x100fe400078e000cULL,
0x000000ffff337224ULL, 0x000fe200078e000cULL, 0x0000000c1018723cULL, 0x000b6200000418ffULL,
0x000000141514723eULL, 0x004fe200000010ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x00000008303c7824ULL, 0x040fe400078e00ffULL, 0x00000008303e7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b160d7823ULL, 0x020fc6000001082eULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000373616723eULL, 0x008fe200000010ffULL, 0x0000000830367824ULL, 0x000fcc00078e00ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x000000252415723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1d257823ULL, 0x000fc4000001082eULL,
0x00000008301d7824ULL, 0x000fc800078e00ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000263517723eULL, 0x004fce00000010ffULL, 0x0000002b002b7308ULL, 0x000e620000000800ULL,
0x000000321418723cULL, 0x000b6e0000041818ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0xfffffff81d327812ULL, 0x020fce00078ee21cULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x0000002a2b1c723eULL, 0x002fe200000010ffULL, 0x000000ffff2a7224ULL, 0x100fe400078e000cULL,
0x000000ffff2b7224ULL, 0x000fc800078e000cULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e700000000800ULL, 0x0000000d000d7308ULL, 0x000ff00000000800ULL,
0x0000002f00247308ULL, 0x0004e20000000800ULL, 0x00000022231d723eULL, 0x002fc400000010ffULL,
0x0000000430237810ULL, 0x000fc80007ffe0ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee223ULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1e2f7823ULL, 0x104fe2000001082eULL,
0x0000002c2d1e723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b1f2e7823ULL, 0x000fe2000001082eULL,
0xffffffff30237810ULL, 0x040fe20007ffe0ffULL, 0x00000008302c7824ULL, 0x000fe200078e00ffULL,
0x0000000d241f723eULL, 0x008fe400000010ffULL, 0x0000000300267308ULL, 0x0002a20000000800ULL,
0x00000003300d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000830247810ULL, 0x000fe40007ffe0ffULL,
0xfffffff836367812ULL, 0x000fe200078ee20dULL, 0x0000002a1c18723cULL, 0x000b620000041818ULL,
0x00000006300d7810ULL, 0x040fe20007ffe0ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000000230037810ULL, 0x002fe40007ffe0ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee20dULL,
0xfffffff834347812ULL, 0x000fc400078ee203ULL, 0x0000000530037810ULL, 0x000fe20007ffe0ffULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x000000272626723eULL, 0x004fe400000010ffULL,
0xfffffff83e3e7812ULL, 0x000fca00078ee223ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002500227308ULL, 0x0004f00000000800ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x0000000830257824ULL, 0x004fca00078e00ffULL, 0xfffffff8252a7812ULL, 0x020fe200078ee230ULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0x0000002e002e7308ULL, 0x000ea20000000800ULL,
0xfffffff82c307812ULL, 0x000fe400078ee203ULL, 0x0001100002037811ULL, 0x000fe400078e58ffULL,
0xfffffff825407812ULL, 0x000fe400078ee224ULL, 0x000000032a0d7211ULL, 0x000fe200078e20ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000000282924723eULL, 0x002fe200000010ffULL,
0x00000010320c7824ULL, 0x100fe200078e0203ULL, 0x000000212225723eULL, 0x008fe200000010ffULL,
0x0000001036217824ULL, 0x100fe200078e0203ULL, 0x0000000c202c7812ULL, 0x000fe200078ec0ffULL,
0x0000001034207824ULL, 0x100fe200078e0203ULL, 0x0000002f2e27723eULL, 0x004fe200000010ffULL,
0x000000103a227824ULL, 0x000fc400078e0203ULL, 0x000000012c0d7824ULL, 0x000fe400078e020dULL,
0x0000001030237824ULL, 0x100fe400078e0203ULL, 0x0000002a2418723cULL, 0x000b620000041818ULL,
0x000000012c0c7824ULL, 0x000fe200078e020cULL, 0x000000100d007388ULL, 0x0003e20000000800ULL,
0x000000103c287824ULL, 0x100fe400078e0203ULL, 0x000000103e297824ULL, 0x000fe200078e0203ULL,
0x0000000340037211ULL, 0x000fe200078e20ffULL, 0x000000012c207824ULL, 0x040fe200078e0220ULL,
0x000000120c007388ULL, 0x0003e20000000800ULL, 0x000000012c217824ULL, 0x000fc400078e0221ULL,
0x000000012c227824ULL, 0x040fe200078e0222ULL, 0x0000001420007388ULL, 0x0003e20000000800ULL,
0x000000012c237824ULL, 0x040fe400078e0223ULL, 0x000000012c287824ULL, 0x040fe200078e0228ULL,
0x0000001621007388ULL, 0x0003e20000000800ULL, 0x000000012c297824ULL, 0x040fe400078e0229ULL,
0x000000012c2a7824ULL, 0x020fe200078e0203ULL, 0x0000001c22007388ULL, 0x0003e80000000800ULL,
0x0000001e23007388ULL, 0x0003e20000000800ULL, 0x000000ffff197224ULL, 0x000fc600078e001aULL,
0x0000002428007388ULL, 0x0003e80000000800ULL, 0x0000002629007388ULL, 0x0003e80000000800ULL,
0x000000112a007388ULL, 0x0003e80000000800ULL, 0x000400130c007388ULL, 0x0003e80000000800ULL,
0x0004001520007388ULL, 0x0003e80000000800ULL, 0x0004001721007388ULL, 0x0003e80000000800ULL,
0x0004001d22007388ULL, 0x0003e80000000800ULL, 0x0004001f23007388ULL, 0x0003e80000000800ULL,
0x0004002528007388ULL, 0x0003e80000000800ULL, 0x0004002729007388ULL, 0x0003e80000000800ULL,
0x01b000080e008388ULL, 0x0003e80000000c00ULL, 0x01b200180e008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080074ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100074ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000005e5000720cULL, 0x000fe20003f06070ULL,
0x01b6200074ff7f8cULL, 0x0003e2000c80043fULL, 0x0000005000037202ULL, 0x000fd60000000f00ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff962000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff097807ULL, 0x002fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014d10000e7802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x018fea0003c00000ULL, 0xfffee04000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014d60000e7802ULL, 0x000fc40000000f00ULL, 0x00000ef000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xfffee08000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00014dd0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000e3000007944ULL, 0x018fea0003c00000ULL, 0xfffee14000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x00014e30000f7802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x01afea0003c00000ULL, 0xfffee24000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00014ea0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e000dULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000d6000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xfffee3c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00014f10000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000cf000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xfffee38000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014f70000e7802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x002fea0003c00000ULL, 0xfffefa5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014fc0000e7802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff327224ULL, 0x000fe200078e0009ULL, 0xfffefa8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x00015030000f7802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x000fea0003c00000ULL, 0xfffefb5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x00015090000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000b7000007944ULL, 0x002fea0003c00000ULL, 0xfffefc5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00015100000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e0031ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000b0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xfffefde000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x00015170000f7802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xfffefda000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x000151d0000e7802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x018fea0003c00000ULL, 0xffff122000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00015220000e7802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xffff125000007947ULL, 0x000fea000383ffffULL,
0x00000026000e7202ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x00015290000f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000097000007944ULL, 0x018fea0003c00000ULL, 0xffff132000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x000152f0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000091000007944ULL, 0x01afea0003c00000ULL, 0xffff142000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00015360000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e000dULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x000008a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xffff15b000007947ULL, 0x000fea000383ffffULL,
0x0000000c000e7202ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x000153d0000f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000083000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff157000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00015430000e7802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x032fea0003c00000ULL, 0xffff2a0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff097807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00015480000e7802ULL, 0x000fc40000000f00ULL, 0x000007d000007944ULL, 0x032fea0003c00000ULL,
0x00000009000c7202ULL, 0x000fe20000000f00ULL, 0xffff2a4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x000154f0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000071000007944ULL, 0x030fea0003c00000ULL, 0xffff2b1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x00015550000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x032fea0003c00000ULL, 0xffff2c1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe200078e000dULL, 0x000155c0000f7802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0009ULL, 0xffff2da000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00015630000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x036fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff2d6000007947ULL, 0x000fea000383ffffULL, 0x00000002ff117424ULL, 0x000fe200078e00ffULL,
0x000156a0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff037424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x002fea0003c00000ULL,
0xffffe8a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x002fe200078e0014ULL,
0x00015710000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff117424ULL, 0x000fe400078e00ffULL,
0x0000001fff037424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x000000031400720bULL, 0x004fe20003f1e000ULL,
0x00000002ff117424ULL, 0x002fe200078e00ffULL, 0x0000001200107202ULL, 0x000fe20000000f00ULL,
0xffffffffff387424ULL, 0x000fe200078e00ffULL, 0x00000014030a7208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fe200078e00ffULL, 0x00015790000c7802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0013ULL, 0x00015810000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff117424ULL, 0x000fe200078e00ffULL, 0x0000001203127208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x000000031300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e003aULL, 0x00015890000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x00000013030b7208ULL, 0x000fe20004000000ULL,
0xffffffffff387424ULL, 0x000fe200078e00ffULL, 0x0000001f00037802ULL, 0x000fc40000000f00ULL,
0x0000033000007944ULL, 0x000fea0003c00000ULL, 0x000000033a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e000aULL, 0x00015910000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000003a03087208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000030a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff107224ULL, 0x002fe200078e0012ULL, 0x00015990000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x0000000a03097208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x00000001ff117424ULL, 0x002fe200078e00ffULL, 0x0000000b00107202ULL, 0x000fe20000000f00ULL,
0xffffffffff387424ULL, 0x000fe200078e00ffULL, 0x00000012030a7208ULL, 0x000fe20004000000ULL,
0x0000001fff037424ULL, 0x000fe200078e00ffULL, 0x00015a10000c7802ULL, 0x000fc40000000f00ULL,
0x000001b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff387224ULL, 0x006fe200078e0003ULL,
0xffffe68000007947ULL, 0x000fea000383ffffULL, 0x0180000007047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000700048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000007057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e000bULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffea44004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003800007348ULL, 0x000fe80003800000ULL,
0x0c00001110037389ULL, 0x0002a200000e0003ULL, 0xfffea4000c007950ULL, 0x000fea0003c3ffffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x000000090e097389ULL, 0x0002a400000e0035ULL,
0x000000ffff0e7224ULL, 0x002fc400078e000fULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea3b00e007950ULL, 0x000fea0003c3ffffULL, 0x000000010900780cULL, 0x000fe20003f25070ULL,
0x0000000f00007348ULL, 0x000fd80003800000ULL, 0x0000000000097806ULL, 0x000fc800048e0100ULL,
0x0000000f09097212ULL, 0x000fe200078ec0ffULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea3500e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000512ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000670ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c8ULL,
0x0000000000000300ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bc8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c88ULL,
0x00000000000005d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001258ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001268ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012fcULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000015d80ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000017280ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000172c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000017640ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012f8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015f88ULL,
0x0000000000015f88ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017280ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000017640ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_pagedKV_128_nqpkv_0_m_16_sm_80_cubin_len = 96032;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
