/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012a10ULL, 0x0000000000012590ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000011060ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000111d0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000011210ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000011250ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000011380ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001106000000000ULL, 0x0000040400000000ULL, 0x810c000001180400ULL,
0x0042f40400288080ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080940828808081ULL,
0xa708288080980828ULL, 0x288080ad08288080ULL, 0x80b608288080b208ULL, 0x1628808086082880ULL,
0x0000031028808280ULL, 0x8692000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001106000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0xa708288080940828ULL, 0x288080ad08288080ULL,
0x80b608288080b208ULL, 0x1628808098082880ULL, 0x0000031028808280ULL, 0x9892000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL, 0x000111d000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0xa708288080980828ULL, 0x288080ad08288080ULL, 0x80b608288080b208ULL, 0x1628808094082880ULL,
0x0000031028808280ULL, 0x9492000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x0000019000000000ULL, 0x0001121000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0xa708288080980828ULL, 0x288080ad08288080ULL,
0x80b608288080b208ULL, 0x1628808094082880ULL, 0x0000031028808280ULL, 0x9492000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000022000000000ULL, 0x0001125000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x0008120400000073ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000eULL, 0x000c170400501903ULL,
0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL,
0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x0000fa400000f840ULL, 0x0000fbd00000fac0ULL, 0x0000fbf00000fbe0ULL,
0xffffffff01702904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000017ffffffffULL, 0x0500001705000017ULL,
0xffffffff05000017ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01702804ffffffffULL, 0x00000100000000e0ULL,
0x0000207000001280ULL, 0x000021c000002100ULL, 0x000024e0000021f0ULL, 0x00002550000024f0ULL,
0x00002bd0000025b0ULL, 0x00003960000038d0ULL, 0x00003b5000003a30ULL, 0x00003d5000003d40ULL,
0x00003e1000003db0ULL, 0x00004e40000041e0ULL, 0x00004fa000004ed0ULL, 0x000052b0000050c0ULL,
0x00005320000052c0ULL, 0x0000575000005380ULL, 0x00006450000063c0ULL, 0x0000664000006520ULL,
0x0000684000006830ULL, 0x00006900000068a0ULL, 0x00006df000006de0ULL, 0x000097f000009550ULL,
0x00009e7000009e30ULL, 0x0000f4a00000f470ULL, 0x0000f4c00000f4b0ULL, 0x0000f5100000f4f0ULL,
0x0000f5300000f520ULL, 0x0000fc200000fbc0ULL, 0x0000fc400000fc30ULL, 0x000103a000010350ULL,
0x0001048000010410ULL, 0x00010560000104f0ULL, 0x00010600000105b0ULL, 0x000106d000010660ULL,
0x0001079000010730ULL, 0x00010830000107e0ULL, 0x0001090000010890ULL, 0x000109c000010960ULL,
0x00010a6000010a10ULL, 0x00010b3000010ac0ULL, 0x00010bf000010b90ULL, 0x00010cb000010c50ULL,
0x00010d5000010d00ULL, 0x00010df000010da0ULL, 0x00010e9000010e40ULL, 0x00010f8000010f00ULL,
0x0001104000010fe0ULL, 0x0000020002003904ULL, 0x00013600000000ffULL, 0x00000240003f0100ULL,
0x0001360800000005ULL, 0x00000310003f0120ULL, 0x0001368800000005ULL, 0x000003f0003f0120ULL,
0x00013600000000ffULL, 0x00000510003f0107ULL, 0x0001368c00000062ULL, 0x000005a0003f0102ULL,
0x0001368800000062ULL, 0x00001e90003f0101ULL, 0x0001360800000004ULL, 0x00001ea0003f0101ULL,
0x0001360c00000004ULL, 0x00001f60003f0105ULL, 0x0001360c00000005ULL, 0x00002b80003f0105ULL,
0x000136880000006bULL, 0x00003740003f0101ULL, 0x0001362800000004ULL, 0x00003750003f0101ULL,
0x0001362c00000004ULL, 0x00003820003f0105ULL, 0x0001362c0000001cULL, 0x00004190003f0105ULL,
0x000136900000006bULL, 0x00004cf0003f0101ULL, 0x0001364800000004ULL, 0x00004d00003f0101ULL,
0x0001364c00000004ULL, 0x00004d90003f0105ULL, 0x0001364c00000004ULL, 0x00005700003f0105ULL,
0x000136980000006bULL, 0x00006270003f0101ULL, 0x0001366800000004ULL, 0x00006280003f0101ULL,
0x0001366c00000004ULL, 0x00006310003f0105ULL, 0x0001366c00000004ULL, 0x00006c40003f0105ULL,
0x000136a00000006bULL, 0x0000ab40003f0101ULL, 0x00013600000000ffULL, 0x0000b600003f0101ULL,
0x00013604000000ffULL, 0x0000b6a0003f0105ULL, 0x00013604000000ffULL, 0x0000ea40003f0105ULL,
0x000000000000005dULL, 0x0000ea80003f0101ULL, 0x000000040000005dULL, 0x0000ed70003f0105ULL,
0x000000040000005dULL, 0x000101b0003f0105ULL, 0x0001360800000004ULL, 0x00010210003f0101ULL,
0x0001361000000004ULL, 0x00010270003f0101ULL, 0x0001361800000004ULL, 0x000102e0003f0101ULL,
0x0001362000000004ULL, 0x00033803003f0101ULL, 0x0000a86000141c04ULL, 0x0000b7000000aab0ULL,
0x000103200000b780ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL, 0x00000000fffffffdULL,
0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000029cULL,
0x0000001200000002ULL, 0x000000000000020cULL, 0x0000001200000002ULL, 0x000000000000017cULL,
0x0000001200000002ULL, 0x00000000000000ecULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x0000000000000276ULL, 0x0000001200000002ULL, 0x00000000000001e6ULL,
0x0000001200000002ULL, 0x0000000000000156ULL, 0x0000001200000002ULL, 0x00000000000000c6ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001300067300ULL, 0x000ee200000e0000ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x0000000000097919ULL, 0x000ee20000000000ULL,
0x0000001300137309ULL, 0x000f260000000000ULL, 0x0000000000107919ULL, 0x000f680000002600ULL,
0x0000000000617919ULL, 0x000f220000002700ULL, 0x00000005ff667819ULL, 0x002fcc0000011605ULL,
0x00001fff66667589ULL, 0x000fe200000e0000ULL, 0x000000010d007824ULL, 0x004fc600078e0200ULL,
0x00001fff0d0d7589ULL, 0x000e6200000e0000ULL, 0x0000008000057824ULL, 0x000fe200078e0205ULL,
0x000000090600720cULL, 0x008fe40003f82070ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000310047819ULL, 0x020fe400000006ffULL, 0x000000ff0500720cULL, 0x040fe40003f05270ULL,
0x0000000f0500780cULL, 0x000fe20003f24070ULL, 0x0000006107077224ULL, 0x010fe200078e0204ULL,
0x0000007f0500780cULL, 0x000fe20003f44070ULL, 0x00000100ff047424ULL, 0x000fd000078e00ffULL,
0x3fffff80ff028424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff038424ULL, 0x000fe200078e00ffULL,
0x3fffffc000089802ULL, 0x000fe20000000f00ULL, 0x000000040d067824ULL, 0x002fe200078e0266ULL,
0xff3172170012a802ULL, 0x000fe20000000f00ULL, 0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL,
0x01360002ff008388ULL, 0x0003e20000000a00ULL, 0x000000030500780cULL, 0x000fe20003f04070ULL,
0x0000000206067824ULL, 0x000fe200078e00ffULL, 0x00000004ff0f7819ULL, 0x004fe20000011600ULL,
0x0136080805009388ULL, 0x0005e20000008a00ULL, 0x00000010000e7824ULL, 0x000fc400078e00ffULL,
0x00000008060b7817ULL, 0x040fe20007800000ULL, 0x00000001060c7824ULL, 0x000fe200078e020fULL,
0x013400120500a388ULL, 0x0007e20000004800ULL, 0x000000f00e117812ULL, 0x000fe400078ec0ffULL,
0x000000010b067824ULL, 0x000fe400078e0a06ULL, 0x3fffff60ff0a8424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff0b8424ULL, 0x000fe200078e00ffULL, 0x000000060f00720cULL, 0x000fe20003f26070ULL,
0x0000000107037824ULL, 0x002fe200078e020cULL, 0x000000070c077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x004fe200078e0a13ULL, 0x0136880a05008388ULL, 0x0007e20000008a00ULL,
0x00005c0003027625ULL, 0x000fe200078e0004ULL, 0x0000000f07077812ULL, 0x000fc400078e7800ULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x0000001102067210ULL, 0x000fe20007f7e0ffULL,
0x000000100c0c7824ULL, 0x000fe400078e0207ULL, 0x00000004ff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200018e0603ULL, 0x000000040c097819ULL, 0x000fe200000006ffULL,
0x0000600061027625ULL, 0x000fc800078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0007e8000c901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01360408ffff438cULL, 0x0007e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01360000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602657981ULL, 0x000ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0d00720cULL, 0x000fe20003f05270ULL,
0x00000004ff677e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff65647810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff647819ULL, 0x000fce0000011664ULL, 0x0000a5e000008947ULL, 0x000fea0003800000ULL,
0x0000000866627824ULL, 0x000fe400078e00ffULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01368c0362ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000167037810ULL, 0x002fe20007ffe0ffULL,
0x0000000261617824ULL, 0x000fe200078e00ffULL, 0x00000001ff607819ULL, 0x000fe20000011666ULL,
0x0136880062ff7f8cULL, 0x0003e2000c80043fULL, 0x000000640300720cULL, 0x000fe40003f06070ULL,
0x0000580010027a10ULL, 0x000fc40007ffe0ffULL, 0x0000000560577819ULL, 0x000fe400000006ffULL,
0x0000000166637812ULL, 0x000fe200078ec0ffULL, 0x0000580061617a24ULL, 0x000fe400078e0202ULL,
0x0000010067087824ULL, 0x008fc800078e0257ULL, 0x0000620061217a24ULL, 0x000fe200078e0208ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x0000000865027217ULL, 0x002fe20007800000ULL,
0x0000000260107824ULL, 0x000fe200078e0263ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x0000000863117824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fe200078e0a08ULL,
0x00000008060a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000121037824ULL, 0x000fe200078e0206ULL,
0x0000000c060c7810ULL, 0x000fe40007ffe0ffULL, 0x0000002002057817ULL, 0x000fe20003800000ULL,
0x00005e0003027625ULL, 0x000fe200078e0004ULL, 0x0000000706077812ULL, 0x000fc400078e4800ULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x000000080a127824ULL, 0x000fe200078e00ffULL,
0x0000000406087810ULL, 0x000fe20007ffe0ffULL, 0x000000080c147824ULL, 0x000fe200078e00ffULL,
0x0000b00010107811ULL, 0x000fe400078e68ffULL, 0xfffffff811117812ULL, 0x100fe400078ee200ULL,
0x0ffffff807077812ULL, 0x000fe400078ef800ULL, 0x000000000a0b7212ULL, 0x080fe200078e3cffULL,
0x0000001011027825ULL, 0x000fe200078e0002ULL, 0x000000000c0d7212ULL, 0x000fc400078e3cffULL,
0x0000000008097212ULL, 0x0c0fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0210ULL,
0x00000003080e7819ULL, 0x000fe400000006ffULL, 0xfffffff812157812ULL, 0x000fe400078ee20bULL,
0xfffffff814177812ULL, 0x000fe200078ee20dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e2000c101c46ULL, 0x00000010060b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001015157824ULL, 0x100fe200078e0210ULL, 0xfffffff80e137812ULL, 0x000fe200078ee209ULL,
0x0000001017177824ULL, 0x100fe200078e0210ULL, 0x00000014060d7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b197824ULL, 0x000fe200078e00ffULL, 0x00000018060e7810ULL, 0x040fe20007ffe0ffULL,
0x0000001013137824ULL, 0x000fe200078e0210ULL, 0x0000001c06127810ULL, 0x000fe20007ffe0ffULL,
0x000000080d1b7824ULL, 0x000fe200078e00ffULL, 0x000000050800720cULL, 0x080fe20003f06070ULL,
0x0000000121037824ULL, 0x002fe200078e0208ULL, 0x000000000b027212ULL, 0x080fe200078e3cffULL,
0x000000080e1f7824ULL, 0x000fe200078e00ffULL, 0x000000000d067212ULL, 0x000fe200078e3cffULL,
0x0000000121077824ULL, 0x040fe200078e020aULL, 0x000000050a00720cULL, 0x080fe20003f26070ULL,
0x0000000812237824ULL, 0x000fe200078e00ffULL, 0x0000000c21097210ULL, 0x040fe20007ffe0ffULL,
0x00000001210f7824ULL, 0x040fe200078e020dULL, 0x000000000e087212ULL, 0x000fe200078e3cffULL,
0x00000001211d7824ULL, 0x000fe200078e020eULL, 0x000000050c00720cULL, 0x000fc40003f46070ULL,
0x000000050b00720cULL, 0x080fe40003f66070ULL, 0x000000050d00720cULL, 0x080fe20003f86070ULL,
0x00005e000f0c7625ULL, 0x000fe200078e0004ULL, 0x000000050e00720cULL, 0x080fe40003fa6070ULL,
0x000000051200720cULL, 0x040fe20003fc6070ULL, 0x0000000121057824ULL, 0x000fe200078e020bULL,
0x00000000120a7212ULL, 0x000fe200078e3cffULL, 0x00005e001d0e7625ULL, 0x000fe200078e0004ULL,
0xfffffff819197812ULL, 0x000fc400078ee202ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL,
0x00005e0003027625ULL, 0x000fe200078e0004ULL, 0x0000001221217210ULL, 0x000fe40007ffe0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x00005e0007067625ULL, 0x000fe200078e0004ULL,
0xfffffff823237812ULL, 0x000fe400078ee20aULL, 0x0000001019197211ULL, 0x000fe200078e20ffULL,
0x00005e0009087625ULL, 0x000fc800078e0004ULL, 0x00005e00050a7625ULL, 0x000fc800078e0004ULL,
0x00005e0021047625ULL, 0x000fc800078e0004ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001011067825ULL, 0x040fe200078e0006ULL, 0x0000000002137faeULL, 0x0003e6000c101c46ULL,
0x0000001011087825ULL, 0x040fe200078e0008ULL, 0x0000000006157faeULL, 0x0003e6000c901c46ULL,
0x00000010110a7825ULL, 0x040fe200078e000aULL, 0x0000000008177faeULL, 0x0003e6000d101c46ULL,
0x00000010110c7825ULL, 0x000fe200078e000cULL, 0x000000000a197faeULL, 0x0003e6000d901c46ULL,
0x000000101b1b7824ULL, 0x000fc400078e0210ULL, 0x00000010110e7825ULL, 0x000fc600078e000eULL,
0x000000000c1b7faeULL, 0x0003e2000e101c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0210ULL,
0x0000001011047825ULL, 0x000fc600078e0004ULL, 0x000000000e1f7faeULL, 0x0003e2000e901c46ULL,
0x0000001023237824ULL, 0x000fca00078e0210ULL, 0x0000000004237faeULL, 0x0003e2000f101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x002fe20000011600ULL,
0x0000000863137824ULL, 0x000fc600078e00ffULL, 0x0000000402067810ULL, 0x040fe40007ffe0ffULL,
0x0000000802087810ULL, 0x000fe40007ffe0ffULL, 0x0000000006037212ULL, 0x0c0fe200078e3cffULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0x0000000c020a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000121097824ULL, 0x000fe200078e0208ULL, 0x0000000008057212ULL, 0x080fe400078e3cffULL,
0xfffffff80c177812ULL, 0x000fe200078ee203ULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0x000000000a077212ULL, 0x000fe200078e3cffULL, 0x0000000260037824ULL, 0x000fe200078e0263ULL,
0x000000030a0e7819ULL, 0x000fc400000006ffULL, 0xfffffff80c197812ULL, 0x000fe400078ee205ULL,
0xfffffff80e1b7812ULL, 0x000fe200078ee207ULL, 0x0000000121077824ULL, 0x040fe200078e0206ULL,
0x00000010020c7810ULL, 0x040fe40007ffe0ffULL, 0x00000014020e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001802107810ULL, 0x000fe20007ffe0ffULL, 0x000000080c1d7824ULL, 0x000fe200078e00ffULL,
0x0000001c02147810ULL, 0x000fe20007ffe0ffULL, 0x00000001210d7824ULL, 0x000fe200078e020cULL,
0x0000b00003127811ULL, 0x000fe200078e68ffULL, 0x0000000121037824ULL, 0x040fe200078e0202ULL,
0x0000000a210b7210ULL, 0x040fe20007ffe0ffULL, 0x00000001210f7824ULL, 0x040fe200078e020eULL,
0x000000000c067212ULL, 0x000fe200078e3cffULL, 0x000000080e1f7824ULL, 0x000fe200078e00ffULL,
0x0000001421237210ULL, 0x040fe20007ffe0ffULL, 0x0000000121117824ULL, 0x000fe200078e0210ULL,
0x0000000702057812ULL, 0x000fe200078e4800ULL, 0x0000000810217824ULL, 0x000fe200078e00ffULL,
0x000000000e087212ULL, 0x080fe200078e3cffULL, 0x0000000814257824ULL, 0x000fe200078e00ffULL,
0x00000000100a7212ULL, 0x000fe200078e3cffULL, 0x00005e0003027625ULL, 0x000fe200078e0004ULL,
0x00000000140c7212ULL, 0x000fc400078e3cffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x00005e0007067625ULL, 0x080fe200078e0004ULL, 0xfffffff813137812ULL, 0x100fe400078ee200ULL,
0x0ffffff805057812ULL, 0x000fe200078ef800ULL, 0x00005e000f0e7625ULL, 0x080fe200078e0004ULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee208ULL, 0xfffffff821217812ULL, 0x000fe200078ee20aULL,
0x00005e0009087625ULL, 0x000fe200078e0004ULL, 0xfffffff825257812ULL, 0x000fc400078ee20cULL,
0x000000121b1b7211ULL, 0x000fe200078e20ffULL, 0x00005e000b0a7625ULL, 0x000fc800078e0004ULL,
0x00005e000d0c7625ULL, 0x000fc800078e0004ULL, 0x0000001005157824ULL, 0x000fe400078e0212ULL,
0x0000001013027825ULL, 0x000fc800078e0002ULL, 0x00005e0011107625ULL, 0x080fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002157faeULL, 0x0003e6000b901c46ULL,
0x00005e0023047625ULL, 0x000fc800078e0004ULL, 0x0000001013067825ULL, 0x000fc800078e0006ULL,
0x0000001017177824ULL, 0x000fe400078e0212ULL, 0x0000001013087825ULL, 0x000fc600078e0008ULL,
0x0000000006177faeULL, 0x0003e2000b901c46ULL, 0x0000001019197824ULL, 0x000fe400078e0212ULL,
0x00000010130a7825ULL, 0x000fc600078e000aULL, 0x0000000008197faeULL, 0x0003e2000b901c46ULL,
0x00000010130c7825ULL, 0x000fc600078e000cULL, 0x000000000a1b7faeULL, 0x0003e2000b901c46ULL,
0x000000101d1d7824ULL, 0x000fe400078e0212ULL, 0x00000010130e7825ULL, 0x000fc600078e000eULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0212ULL,
0x0000001013107825ULL, 0x000fc600078e0010ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x000fe400078e0212ULL, 0x0000001013047825ULL, 0x000fc600078e0004ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000001025257824ULL, 0x000fca00078e0212ULL,
0x0000000004257faeULL, 0x0003e4000b901c46ULL, 0x000000646700720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff567424ULL, 0x000fe200078e00ffULL,
0x000000ff00557202ULL, 0x000fe20000000f00ULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00005aa000000947ULL, 0x000fea0003800000ULL,
0xff317217ff567424ULL, 0x000fe400078e00ffULL, 0x000000ffff6d7224ULL, 0x000fc400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x0000010067027824ULL, 0x000fca00078e00ffULL,
0x000000650200720cULL, 0x000fda0003f06070ULL, 0x00005a0000000947ULL, 0x000fea0003800000ULL,
0x0000000167037810ULL, 0x040fe20007ffe0ffULL, 0x00000100676a7824ULL, 0x000fe200078e0257ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000640300720cULL, 0x000fe40003f06070ULL,
0x000000406a047810ULL, 0x000fe40007ffe0ffULL, 0x0000006d00547202ULL, 0x000fc60000000f00ULL,
0x0000620061107a24ULL, 0x000fcc00078e0204ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000465027217ULL, 0x000fe20007800000ULL, 0x000010006d037824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x000fe20000011600ULL, 0x0000000260067824ULL, 0x000fe200078e0263ULL,
0x0000010000117802ULL, 0x000fe20000000f00ULL, 0x0000000102027824ULL, 0x000fe200078e0a04ULL,
0x0000100003037812ULL, 0x000fe200078e0cffULL, 0x0000000863137824ULL, 0x000fe200078e00ffULL,
0x00000007070b7812ULL, 0x100fe400078e4800ULL, 0x0000002002047817ULL, 0x000fe20003800000ULL,
0x0000200006057824ULL, 0x000fe200078e0003ULL, 0xfffffff813137812ULL, 0x000fe200078ee200ULL,
0x0000000107037824ULL, 0x040fe200078e0210ULL, 0x000000040700720cULL, 0x000fc40003f06070ULL,
0x00000008070f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0003027625ULL, 0x000fe200078e0011ULL,
0x0ffffff80b0b7812ULL, 0x000fe400078ef800ULL, 0x0000b00005087810ULL, 0x000fe20007ffe0ffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0x00000004070d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x0000000c071d7810ULL, 0x000fe40007ffe0ffULL,
0x000000000f0a7212ULL, 0x080fe200078e3cffULL, 0x000000100b057824ULL, 0x000fe200078e0208ULL,
0x00000010070b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0x0000001807237810ULL, 0x000fe20007ffe0ffULL, 0x000000081d1f7824ULL, 0x000fe200078e00ffULL,
0x0000001c07257810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000c101c46ULL, 0x000000000d067212ULL, 0x080fe200078e3cffULL,
0x000000080b127824ULL, 0x000fe200078e00ffULL, 0x000000001d0c7212ULL, 0x000fe200078e3cffULL,
0x0000000823167824ULL, 0x000fe200078e00ffULL, 0x0000001407217810ULL, 0x000fe20007ffe0ffULL,
0x00000008251c7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee20aULL,
0x000000010b0a7824ULL, 0x140fe200078e0210ULL, 0x000000040b00720cULL, 0x000fe20003f66070ULL,
0x00000001230e7824ULL, 0x000fe200078e0210ULL, 0xfffffff815157812ULL, 0x000fe200078ee206ULL,
0x000000011d067824ULL, 0x000fe200078e0210ULL, 0x000000000b037212ULL, 0x002fc400078e3cffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL, 0x00000001210c7824ULL, 0x000fe200078e0210ULL,
0x000000040d00720cULL, 0x080fe40003f06070ULL, 0x000000040f00720cULL, 0x080fe40003f26070ULL,
0x000000041d00720cULL, 0x080fe40003f46070ULL, 0x000000042100720cULL, 0x080fe40003f86070ULL,
0x000000042300720cULL, 0x000fc40003fa6070ULL, 0x000000042500720cULL, 0x000fe20003fc6070ULL,
0x000000010f047824ULL, 0x100fe200078e0210ULL, 0x000000100d027210ULL, 0x000fe20007ffe0ffULL,
0x0000000125107824ULL, 0x000fe200078e0210ULL, 0x0000000021057212ULL, 0x0c0fe200078e3cffULL,
0x00005e000c0c7625ULL, 0x080fe200078e0011ULL, 0x0000000321147819ULL, 0x000fe400000006ffULL,
0x0000000023077212ULL, 0x080fe200078e3cffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0011ULL,
0x00000000250b7212ULL, 0x000fc400078e3cffULL, 0xfffffff8121d7812ULL, 0x000fe200078ee203ULL,
0x00005e0002027625ULL, 0x080fe200078e0011ULL, 0xfffffff814217812ULL, 0x000fe400078ee205ULL,
0xfffffff816237812ULL, 0x000fe200078ee207ULL, 0x00005e0004047625ULL, 0x000fe200078e0011ULL,
0xfffffff81c257812ULL, 0x000fc600078ee20bULL, 0x00005e0006067625ULL, 0x000fc800078e0011ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0011ULL, 0x00005e0010107625ULL, 0x000fc800078e0011ULL,
0x0000001013027825ULL, 0x000fc800078e0002ULL, 0x0000001013047825ULL, 0x000fc800078e0004ULL,
0x0000001013067825ULL, 0x000fc800078e0006ULL, 0x00000010130a7825ULL, 0x000fc800078e000aULL,
0x00000010130c7825ULL, 0x000fc800078e000cULL, 0x00000010130e7825ULL, 0x000fc800078e000eULL,
0x0000001013107825ULL, 0x000fc800078e0010ULL, 0x0000001015137824ULL, 0x100fe200078e0208ULL,
0x0000000817157211ULL, 0x000fe200078e20ffULL, 0x000000101f177824ULL, 0x100fe400078e0208ULL,
0x000000101d1d7824ULL, 0x100fe200078e0208ULL, 0x0000000002137faeULL, 0x0003e2000c101c46ULL,
0x00000010211f7824ULL, 0x100fe400078e0208ULL, 0x0000001023217824ULL, 0x100fe200078e0208ULL,
0x0000000004157faeULL, 0x0003e2000c901c46ULL, 0x0000001025237824ULL, 0x000fc600078e0208ULL,
0x0000000006177faeULL, 0x0003e8000d101c46ULL, 0x000000000a1d7faeULL, 0x0003e8000d901c46ULL,
0x000000000c1f7faeULL, 0x0003e8000e101c46ULL, 0x000000000e217faeULL, 0x0003e8000e901c46ULL,
0x0000000010237faeULL, 0x0003e2000f101c46ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x000fe20000011600ULL, 0x0000000260027824ULL, 0x000fe200078e0263ULL,
0x0000000c6d047819ULL, 0x000fc400000006ffULL, 0x0000000403077810ULL, 0x000fe40007ffe0ffULL,
0x0000100004057812ULL, 0x000fe400078e0cffULL, 0x0000000007067212ULL, 0x040fe200078e3cffULL,
0x00000008070d7824ULL, 0x000fe200078e00ffULL, 0x00000008030b7810ULL, 0x040fe20007ffe0ffULL,
0x0000200002047824ULL, 0x000fe200078e0005ULL, 0x00000010030f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d147812ULL, 0x000fe200078ee206ULL, 0x000000080b137824ULL, 0x000fe200078e00ffULL,
0x0000000c030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x000fe200078e0210ULL,
0x0000001403117810ULL, 0x000fc40007ffe0ffULL, 0x000000000b027212ULL, 0x080fe200078e3cffULL,
0x000000080d1c7824ULL, 0x040fe200078e00ffULL, 0x000000000d057212ULL, 0x080fe200078e3cffULL,
0x0000000811177824ULL, 0x000fe200078e00ffULL, 0x000000000f067212ULL, 0x000fe200078e3cffULL,
0x000000010d0c7824ULL, 0x100fe200078e0210ULL, 0x000000030f157819ULL, 0x000fe200000006ffULL,
0x0000000111127824ULL, 0x000fe200078e0210ULL, 0xfffffff813167812ULL, 0x000fe200078ee202ULL,
0x0000000103027824ULL, 0x000fe200078e0210ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL,
0x00000100ff137424ULL, 0x000fe200078e00ffULL, 0xfffffff8151e7812ULL, 0x000fe200078ee206ULL,
0x0000000107067824ULL, 0x000fe200078e0210ULL, 0x0000000703057812ULL, 0x000fc400078e4800ULL,
0x0000001803157810ULL, 0x000fe40007ffe0ffULL, 0x0000000011087212ULL, 0x000fe400078e3cffULL,
0x0000001c03037810ULL, 0x000fe20007ffe0ffULL, 0x0000000115227824ULL, 0x000fe200078e0210ULL,
0xfffffff817207812ULL, 0x000fe200078ee208ULL, 0x0000000863177824ULL, 0x000fe200078e00ffULL,
0x000000100b0a7210ULL, 0x000fe20007ffe0ffULL, 0x00000008030b7824ULL, 0x040fe200078e00ffULL,
0x0000000003087212ULL, 0x0c0fe200078e3cffULL, 0x0000000103267824ULL, 0x000fe200078e0210ULL,
0x0000000015077212ULL, 0x040fe200078e3cffULL, 0x00005e0002027625ULL, 0x000fe200078e0013ULL,
0x0000000315247819ULL, 0x000fc400000006ffULL, 0xfffffff817157812ULL, 0x000fe200078ee200ULL,
0x00005e0022107625ULL, 0x080fe200078e0013ULL, 0xfffffff80b287812ULL, 0x000fe400078ee208ULL,
0x0ffffff805087812ULL, 0x000fe200078ef800ULL, 0x0000001015027825ULL, 0x000fe200078e0002ULL,
0x0000b00004177810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824247812ULL, 0x000fe200078ee207ULL,
0x00005e0006047625ULL, 0x000fe200078e0013ULL, 0x000000171e237211ULL, 0x000fc600078e20ffULL,
0x00005e000a067625ULL, 0x000fc800078e0013ULL, 0x00005e000c0a7625ULL, 0x000fc800078e0013ULL,
0x00005e000e0c7625ULL, 0x000fc800078e0013ULL, 0x00005e00120e7625ULL, 0x000fc800078e0013ULL,
0x00005e0026127625ULL, 0x000fc800078e0013ULL, 0x0000001015047825ULL, 0x000fc800078e0004ULL,
0x0000001015067825ULL, 0x000fc800078e0006ULL, 0x00000010150a7825ULL, 0x000fc800078e000aULL,
0x00000010150c7825ULL, 0x000fc800078e000cULL, 0x00000010150e7825ULL, 0x000fc800078e000eULL,
0x0000001015107825ULL, 0x000fc800078e0010ULL, 0x0000001015127825ULL, 0x000fc800078e0012ULL,
0x0000001008157824ULL, 0x100fe400078e0217ULL, 0x00000010141d7824ULL, 0x100fe400078e0217ULL,
0x00000010161f7824ULL, 0x100fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000b901c46ULL, 0x000000101c217824ULL, 0x100fe400078e0217ULL,
0x0000001020257824ULL, 0x100fe200078e0217ULL, 0x00000000041d7faeULL, 0x0003e2000b901c46ULL,
0x0000001024277824ULL, 0x000fc400078e0217ULL, 0x0000001028177824ULL, 0x000fe200078e0217ULL,
0x00000000061f7faeULL, 0x0003e8000b901c46ULL, 0x000000000a217faeULL, 0x0003e8000b901c46ULL,
0x000000000c237faeULL, 0x0003e8000b901c46ULL, 0x000000000e257faeULL, 0x0003e8000b901c46ULL,
0x0000000010277faeULL, 0x0003e8000b901c46ULL, 0x0000000012177faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001060027824ULL, 0x002fe200078e00ffULL,
0xffffffe062037812ULL, 0x000fc800078ec0ffULL, 0x0000001002027812ULL, 0x000fca00078ec0ffULL,
0x0000000103027824ULL, 0x000fca00078e0202ULL, 0x0000000263047211ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080004067f8cULL, 0x000fe8000c80043fULL,
0x01360c0004057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000000947ULL, 0x000fea0003800000ULL, 0x0000001062087812ULL, 0x040fe200078ec0ffULL,
0x3e000000ff027424ULL, 0x000fe200078e00ffULL, 0x0000000862057812ULL, 0x000fc800078ec0ffULL,
0x0000000305057210ULL, 0x000fe40007ffe008ULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x000000030000735dULL, 0x004fe40003800000ULL,
0x01360c0005037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011600ULL, 0x0000002066067824ULL, 0x000fc400078e00ffULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0xffffff8006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fc800078ec0ffULL,
0x0000000607027210ULL, 0x000fca0007ffe005ULL, 0x0130000002037984ULL, 0x000e680000000800ULL,
0x01320000020c7984ULL, 0x0004e20000000800ULL, 0x000000560300720bULL, 0x002fe20003f1d000ULL,
0x0000e2c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x004fc800000e0100ULL,
0x0000ffff020d7812ULL, 0x000fe2000780c0ffULL, 0x000003e000007945ULL, 0x000fe20003800000ULL,
0x0000000100027802ULL, 0x000fd60000000f00ULL, 0x000003b000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe40000011666ULL, 0x000000560300720bULL, 0x000fe40003f34000ULL,
0x000000660b00720cULL, 0x000fe20003f05270ULL, 0x0000e2827f007947ULL, 0x000ff4000b800000ULL,
0x0000000000027806ULL, 0x000fe400008e0100ULL, 0x00000003560f7209ULL, 0x000fe20007810000ULL,
0x00000080660a8824ULL, 0x000fe200078e0205ULL, 0x0000ffff02027812ULL, 0x000fc600078e3cffULL,
0x8000000f560b7221ULL, 0x000fe20000010000ULL, 0x00000001070a8824ULL, 0x000fc600078e020aULL,
0x3fb8aa3b0b0b7820ULL, 0x000fe40000410000ULL, 0x0134000f0a008388ULL, 0x0003e20000000800ULL,
0x000000020dff7212ULL, 0x000fe2000780c0ffULL, 0x0000000b00247308ULL, 0x0002a20000000800ULL,
0x00000002ff027819ULL, 0x000fe20000011600ULL, 0x0000e2127f007947ULL, 0x000ff0000b800000ULL,
0x00001f02240a7589ULL, 0x0062a400000e0000ULL, 0x0000000802027810ULL, 0x002fe20007ffe0ffULL,
0x0000e2527f007947ULL, 0x000fea000b800000ULL, 0x00001f0224027589ULL, 0x00032400000e0000ULL,
0x8000000f03030221ULL, 0x000fe20000010000ULL, 0x000000021b1b7220ULL, 0x090fe20000410000ULL,
0x000000021a1a7220ULL, 0x080fe20000410000ULL, 0x0000000237377220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b03030820ULL, 0x000fe20000410000ULL, 0x0000000236367220ULL, 0x080fe20000410000ULL,
0x000000023b3b7220ULL, 0x080fe20000410000ULL, 0x000000023a3a7220ULL, 0x080fe20000410000ULL,
0x0000000300090308ULL, 0x000f220000000800ULL, 0x000000023f3f7220ULL, 0x080fe20000410000ULL,
0x000000023e3e7220ULL, 0x080fe20000410000ULL, 0x0000000243437220ULL, 0x080fe20000410000ULL,
0x0000000242427220ULL, 0x080fe20000410000ULL, 0x0000000247477220ULL, 0x080fe20000410000ULL,
0x0000000246467220ULL, 0x080fe20000410000ULL, 0x000000024b4b7220ULL, 0x080fe20000410000ULL,
0x000000024a4a7220ULL, 0x080fe20000410000ULL, 0x000000024f4f7220ULL, 0x080fe20000410000ULL,
0x000000024e4e7220ULL, 0x000fe20000410000ULL, 0x0000002455557220ULL, 0x000fe20000410000ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000000a19197220ULL, 0x084fe20000410000ULL,
0x0000000a18187220ULL, 0x080fe20000410000ULL, 0x0000000a35357220ULL, 0x080fe20000410000ULL,
0x0000000a34347220ULL, 0x080fe20000410000ULL, 0x0000000a39397220ULL, 0x080fe20000410000ULL,
0x0000000a38387220ULL, 0x080fe20000410000ULL, 0x0000000a3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000a3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000a41417220ULL, 0x080fe20000410000ULL,
0x0000000a40407220ULL, 0x080fe20000410000ULL, 0x0000000a45457220ULL, 0x080fe20000410000ULL,
0x0000000a44447220ULL, 0x080fe20000410000ULL, 0x0000000a49497220ULL, 0x080fe20000410000ULL,
0x0000000a48487220ULL, 0x080fe20000410000ULL, 0x0000000a4d4d7220ULL, 0x080fe20000410000ULL,
0x0000000a4c4c7220ULL, 0x000fe20000410000ULL, 0x0000000f00567202ULL, 0x000fe20000000f00ULL,
0x000000090c0c0220ULL, 0x018fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000009ff03723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff0b7819ULL, 0x000fe40000011600ULL, 0x0000541003247816ULL, 0x002fe20000000003ULL,
0x0000dfe27f007947ULL, 0x000fea000b800000ULL, 0x000000080b0a7810ULL, 0x000fe20007ffe0ffULL,
0x00001f0b24697589ULL, 0x0002a800000e0000ULL, 0x00001f0a246c7589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000100b277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0x0000256000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x0000ecb000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000180b277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0xffffffff00297802ULL, 0x000fc40000000f00ULL,
0x000025c000147802ULL, 0x000fe40000000f00ULL, 0x0000ec5000007944ULL, 0x01cfea0003c00000ULL,
0x0000000460037824ULL, 0x000fe200078e00ffULL, 0x00000007000b7812ULL, 0x002fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000550c557221ULL, 0x008fe40000010000ULL,
0x00000004030d7812ULL, 0x000fe200078ec0ffULL, 0x0000020066037824ULL, 0x000fe200078e00ffULL,
0x000000080b117812ULL, 0x000fe400078ef800ULL, 0x0000000d000e7211ULL, 0x000fe400078fe0ffULL,
0xfffff80003137812ULL, 0x000fc400078ec0ffULL, 0x000000070e0e7812ULL, 0x000fe400078e7811ULL,
0x0000000800037812ULL, 0x000fc600078ec0ffULL, 0x00000008110e7824ULL, 0x000fc800078e020eULL,
0x000000100e0c7824ULL, 0x000fc600078e0213ULL, 0x0000000260687824ULL, 0x000fe200078e0263ULL,
0x0000000703127812ULL, 0x140fe200078ef800ULL, 0x009000000c2c783bULL, 0x000e620000000200ULL,
0x00000004ff167819ULL, 0x100fe20000011600ULL, 0x00000002666b7824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe400078ec800ULL, 0x0000000d68687819ULL, 0x000fe400000006ffULL,
0x000000020d1c7810ULL, 0x000fe40007ffe016ULL, 0x0000000216107810ULL, 0x040fe20007ffe0ffULL,
0x000010006d0e7824ULL, 0x000fe200078e0268ULL, 0x0000000416147810ULL, 0x000fc40007ffe0ffULL,
0x00000016031d7212ULL, 0x040fe400078e3cffULL, 0x0000000616167810ULL, 0x000fe40007ffe0ffULL,
0x00000010031f7212ULL, 0x044fe200078e3cffULL, 0x00000008120d7824ULL, 0x000fe200078e021dULL,
0x0000001403217212ULL, 0x040fe400078e3cffULL, 0x0000001603037212ULL, 0x000fe400078e3cffULL,
0x0000b0000e1e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008120e7824ULL, 0x040fe200078e021fULL,
0x0000000312107211ULL, 0x040fe200078e18ffULL, 0x00000008120f7824ULL, 0x000fe200078e0221ULL,
0x000000071c1c7812ULL, 0x000fe200078e7811ULL, 0x000000100d5c7824ULL, 0x100fe200078e021eULL,
0x0000991002027816ULL, 0x000fe200000000ffULL, 0x000000100e587824ULL, 0x100fe200078e021eULL,
0xfffffff86b6b7812ULL, 0x000fe200078ec0ffULL, 0x000000100f507824ULL, 0x100fe200078e021eULL,
0x000000ff0200720cULL, 0x000fe20003f05270ULL, 0x0000001010307824ULL, 0x000fe200078e021eULL,
0x000000005c5c783bULL, 0x000ea20000004200ULL, 0x00000008111c7824ULL, 0x000fc600078e021cULL,
0x000000005858783bULL, 0x000ee20000004200ULL, 0x000000101c117824ULL, 0x000fe200078e0213ULL,
0x00000080121c7811ULL, 0x000fe400078e18ffULL, 0x000000005050783bULL, 0x000fe40000004200ULL,
0x0000001c1d127210ULL, 0x000fe20007ffe0ffULL, 0x0000000121027824ULL, 0x100fe200078e021cULL,
0x000000003030783bULL, 0x000fe20000004200ULL, 0x000000011f137824ULL, 0x100fe200078e021cULL,
0x000000692c2c8231ULL, 0x082fe200003400ffULL, 0x0000000103037824ULL, 0x000fe200078e021cULL,
0x009000001114783bULL, 0x000e620000000200ULL, 0x0000001012287824ULL, 0x100fe200078e021eULL,
0x0000001e02207211ULL, 0x000fe200078e20ffULL, 0x0000001013247824ULL, 0x100fe200078e021eULL,
0x000000692e2e8231ULL, 0x000fe200003400ffULL, 0x00000010031c7824ULL, 0x000fe200078e021eULL,
0x0000006c2d2d8231ULL, 0x090fe200003400ffULL, 0x000000002828783bULL, 0x000f220000004200ULL,
0x0000006c2f2f8231ULL, 0x000fc600003400ffULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000002020783bULL, 0x000f280000004200ULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0x0000005c2c4c723cULL, 0x044ff0000004184cULL, 0x0000005e2c48723cULL, 0x040ff00000041848ULL,
0x000000582c44723cULL, 0x008fe20000041844ULL, 0x0000006914148231ULL, 0x002fc400003400ffULL,
0x0000006916168231ULL, 0x000fe400003400ffULL, 0x0000006c15158231ULL, 0x080fe400003400ffULL,
0x0000006c17178231ULL, 0x000fe200003400ffULL, 0x0000005a2c40723cULL, 0x040ff00000041840ULL,
0x000000502c3c723cULL, 0x040ff0000004183cULL, 0x000000522c38723cULL, 0x040ff00000041838ULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x00000028144c723cULL, 0x050ff0000004184cULL, 0x0000002a1448723cULL, 0x040ff00000041848ULL,
0x000000241444723cULL, 0x060ff00000041844ULL, 0x000000261440723cULL, 0x040ff00000041840ULL,
0x00000020143c723cULL, 0x040ff0000004183cULL, 0x000000221438723cULL, 0x040ff00000041838ULL,
0x0000001c1434723cULL, 0x040ff00000041834ULL, 0x0000001e1418723cULL, 0x000fe20000041818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000004067147811ULL, 0x000fe200078e40ffULL,
0x013688006bff7f8cULL, 0x0003e2000c80043fULL, 0x000000016d6d7812ULL, 0x000fc400078e0cffULL,
0x000000651400720cULL, 0x000fda0003f06070ULL, 0x000040a000000947ULL, 0x000fea0003800000ULL,
0x0000000167157810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000641500720cULL, 0x000fe40003f06070ULL, 0x000000806a167810ULL, 0x000fca0007ffe0ffULL,
0x0000620061247a24ULL, 0x000fcc00078e0216ULL, 0x000005c000008947ULL, 0x000fea0003800000ULL,
0x0000001665157217ULL, 0x000fe20007800000ULL, 0x0000100054147824ULL, 0x000fe200078e00ffULL,
0x00000003ff1d7819ULL, 0x000fe20000011600ULL, 0x00000008631c7824ULL, 0x000fe200078e00ffULL,
0x0000010000257802ULL, 0x000fe20000000f00ULL, 0x0000000115157824ULL, 0x000fe200078e0a16ULL,
0x0000100014177812ULL, 0x000fe200078ec0ffULL, 0x000000011d147824ULL, 0x040fe200078e0224ULL,
0x0000000c1d2d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002015167817ULL, 0x000fe20003800000ULL,
0x00005e0014147625ULL, 0x000fe200078e0025ULL, 0x000000071d1f7812ULL, 0x000fc400078e4800ULL,
0x000000161d00720cULL, 0x000fe20003f06070ULL, 0x000000082d207824ULL, 0x000fe200078e00ffULL,
0x0000b00068267810ULL, 0x000fe40007ffe017ULL, 0xfffffff81c277812ULL, 0x000fe400078ee20bULL,
0x000000081d237810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff81f177812ULL, 0x000fe200078ef800ULL,
0x0000001027147825ULL, 0x000fe200078e0014ULL, 0x000000002d1f7212ULL, 0x000fc400078e3cffULL,
0x000000041d217810ULL, 0x000fe20007ffe0ffULL, 0x00000008232b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8202f7812ULL, 0x000fe200078ee21fULL, 0x0000001017177824ULL, 0x000fe200078e0226ULL,
0x00000000231e7212ULL, 0x080fe200078e3cffULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0x000000101d1f7810ULL, 0x040fe40007ffe0ffULL, 0x000000181d337810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c101c46ULL,
0x0000001c1d517810ULL, 0x000fe20007ffe0ffULL, 0x000000081f287824ULL, 0x000fe200078e00ffULL,
0x00000000211c7212ULL, 0x000fe200078e3cffULL, 0x00000008332c7824ULL, 0x000fe200078e00ffULL,
0x000000141d317810ULL, 0x000fe20007ffe0ffULL, 0x00000008512e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21eULL, 0x000000011f1e7824ULL, 0x140fe200078e0224ULL,
0x000000161f00720cULL, 0x000fe20003f66070ULL, 0x0000000131207824ULL, 0x000fe200078e0224ULL,
0xfffffff829297812ULL, 0x000fe200078ee21cULL, 0x000000012d1c7824ULL, 0x100fe200078e0224ULL,
0x000000001f157212ULL, 0x002fe200078e3cffULL, 0x0000000133227824ULL, 0x000fe200078e0224ULL,
0x000000162100720cULL, 0x000fc40003f06070ULL, 0x000000162300720cULL, 0x080fe40003f26070ULL,
0x000000162d00720cULL, 0x080fe40003f46070ULL, 0x000000163100720cULL, 0x080fe40003f86070ULL,
0x000000163300720cULL, 0x080fe40003fa6070ULL, 0x000000165100720cULL, 0x000fe20003fc6070ULL,
0x0000000123167824ULL, 0x100fe200078e0224ULL, 0x0000002421147210ULL, 0x000fe20007ffe0ffULL,
0x0000000151247824ULL, 0x000fe200078e0224ULL, 0x0000000031177212ULL, 0x040fe200078e3cffULL,
0x00005e0020207625ULL, 0x000fe200078e0025ULL, 0x00000003312a7819ULL, 0x000fc400000006ffULL,
0x00000000331d7212ULL, 0x080fe200078e3cffULL, 0x00005e0022227625ULL, 0x080fe200078e0025ULL,
0x00000000511f7212ULL, 0x000fe400078e3cffULL, 0xfffffff8282d7812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x080fe200078e0025ULL, 0xfffffff82a317812ULL, 0x000fe400078ee217ULL,
0xfffffff82c337812ULL, 0x000fe200078ee21dULL, 0x00005e0016167625ULL, 0x000fe200078e0025ULL,
0xfffffff82e517812ULL, 0x000fc600078ee21fULL, 0x00005e001c1c7625ULL, 0x000fc800078e0025ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0025ULL, 0x00005e0024247625ULL, 0x000fc800078e0025ULL,
0x0000001027147825ULL, 0x000fc800078e0014ULL, 0x0000001027167825ULL, 0x000fc800078e0016ULL,
0x00000010271c7825ULL, 0x000fc800078e001cULL, 0x00000010271e7825ULL, 0x000fc800078e001eULL,
0x0000001027207825ULL, 0x000fc800078e0020ULL, 0x0000001027227825ULL, 0x000fc800078e0022ULL,
0x0000001027247825ULL, 0x000fc800078e0024ULL, 0x0000001029277824ULL, 0x100fe200078e0226ULL,
0x000000262b297211ULL, 0x000fe200078e20ffULL, 0x000000102f2b7824ULL, 0x100fe400078e0226ULL,
0x000000102d2d7824ULL, 0x100fe200078e0226ULL, 0x0000000014277faeULL, 0x0003e2000c101c46ULL,
0x00000010312f7824ULL, 0x100fe400078e0226ULL, 0x0000001033317824ULL, 0x100fe200078e0226ULL,
0x0000000016297faeULL, 0x0003e2000c901c46ULL, 0x0000001051337824ULL, 0x000fc600078e0226ULL,
0x000000001c2b7faeULL, 0x0003e8000d101c46ULL, 0x000000001e2d7faeULL, 0x0003e8000d901c46ULL,
0x00000000202f7faeULL, 0x0003e8000e101c46ULL, 0x0000000022317faeULL, 0x0003e8000e901c46ULL,
0x0000000024337faeULL, 0x0003e2000f101c46ULL, 0x0000050000007947ULL, 0x000fea0003800000ULL,
0x00000003ff157819ULL, 0x000fe20000011600ULL, 0x00000100ff277424ULL, 0x000fc600078e00ffULL,
0x00000004151f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000815217810ULL, 0x040fe40007ffe0ffULL,
0x0000000c15237810ULL, 0x000fe40007ffe0ffULL, 0x000000001f147212ULL, 0x080fe200078e3cffULL,
0x00000008212f7824ULL, 0x000fe200078e00ffULL, 0x000000031f2d7819ULL, 0x000fe200000006ffULL,
0x00000008231c7824ULL, 0x000fe200078e00ffULL, 0x0000000021167212ULL, 0x080fe200078e3cffULL,
0x00000001231e7824ULL, 0x000fe200078e0224ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee214ULL,
0x0000100054147824ULL, 0x000fe200078e00ffULL, 0x0000000023177212ULL, 0x000fc400078e3cffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee216ULL, 0x0000000863167824ULL, 0x000fe200078e00ffULL,
0xfffffff81c317812ULL, 0x000fe200078ee217ULL, 0x00000001211c7824ULL, 0x000fe200078e0224ULL,
0x0000001015257810ULL, 0x040fe40007ffe0ffULL, 0x00001000141d7812ULL, 0x000fe400078ec0ffULL,
0x0000000715177812ULL, 0x000fe200078e4800ULL, 0x00000008252c7824ULL, 0x000fe200078e00ffULL,
0x00000014152b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000125207824ULL, 0x000fe200078e0224ULL,
0x0000001815337810ULL, 0x000fc40007ffe0ffULL, 0x0000001c15517810ULL, 0x000fe20007ffe0ffULL,
0x000000082b2e7824ULL, 0x000fe200078e00ffULL, 0x0000002415147210ULL, 0x000fe20007ffe0ffULL,
0x0000000133267824ULL, 0x100fe200078e0224ULL, 0xfffffff816297812ULL, 0x000fe200078ee20bULL,
0x000000011f167824ULL, 0x100fe200078e0224ULL, 0x0000b00068287810ULL, 0x000fe20007ffe01dULL,
0x00000001512a7824ULL, 0x000fe200078e0224ULL, 0x0ffffff817177812ULL, 0x000fe200078ef800ULL,
0x0000000851307824ULL, 0x000fe200078e00ffULL, 0x00000000251d7212ULL, 0x000fe200078e3cffULL,
0x00005e0014147625ULL, 0x000fe200078e0027ULL, 0x000000242b227210ULL, 0x000fc40007ffe0ffULL,
0x000000002b1f7212ULL, 0x080fe200078e3cffULL, 0x0000000833247824ULL, 0x040fe200078e00ffULL,
0x0000000033217212ULL, 0x080fe200078e3cffULL, 0x0000001029147825ULL, 0x000fe200078e0014ULL,
0x0000000051237212ULL, 0x000fe400078e3cffULL, 0x00000028172b7211ULL, 0x080fe200078e20ffULL,
0x00005e0016167625ULL, 0x080fe200078e0027ULL, 0xfffffff82c337812ULL, 0x000fe400078ee21dULL,
0xfffffff82e517812ULL, 0x000fe200078ee21fULL, 0x00005e001c1c7625ULL, 0x080fe200078e0027ULL,
0xfffffff824537812ULL, 0x000fe200078ee221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0xfffffff830597812ULL, 0x000fe200078ee223ULL,
0x00005e001e1e7625ULL, 0x000fe200078e0027ULL, 0x0000002853537211ULL, 0x000fc600078e20ffULL,
0x00005e0020207625ULL, 0x000fc800078e0027ULL, 0x00005e0022227625ULL, 0x000fc800078e0027ULL,
0x00005e0026247625ULL, 0x000fc800078e0027ULL, 0x00005e002a267625ULL, 0x000fc800078e0027ULL,
0x0000001029167825ULL, 0x000fc800078e0016ULL, 0x000000102d2d7824ULL, 0x000fe400078e0228ULL,
0x00000010291c7825ULL, 0x000fc600078e001cULL, 0x00000000162d7faeULL, 0x0003e2000b901c46ULL,
0x000000102f2f7824ULL, 0x000fe400078e0228ULL, 0x00000010291e7825ULL, 0x000fc600078e001eULL,
0x000000001c2f7faeULL, 0x0003e2000b901c46ULL, 0x0000001031317824ULL, 0x000fe400078e0228ULL,
0x0000001029207825ULL, 0x000fc600078e0020ULL, 0x000000001e317faeULL, 0x0003e2000b901c46ULL,
0x0000001033337824ULL, 0x000fe400078e0228ULL, 0x0000001029227825ULL, 0x000fc600078e0022ULL,
0x0000000020337faeULL, 0x0003e2000b901c46ULL, 0x0000001051517824ULL, 0x000fe400078e0228ULL,
0x0000001029247825ULL, 0x000fc600078e0024ULL, 0x0000000022517faeULL, 0x0003e2000b901c46ULL,
0x0000001029267825ULL, 0x000fc600078e0026ULL, 0x0000000024537faeULL, 0x0003e2000b901c46ULL,
0x0000001059597824ULL, 0x000fca00078e0228ULL, 0x0000000026597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136280004167f8cULL, 0x002fe8000c80043fULL, 0x01362c0004157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0xffffffe062157812ULL, 0x040fe200078ec0ffULL, 0x3e000000ff147424ULL, 0x000fe200078e00ffULL,
0x00000010621c7812ULL, 0x000fc400078ec0ffULL, 0x00000008621d7812ULL, 0x000fc800078ec0ffULL,
0x000000151d1c7210ULL, 0x000fe40007ffe01cULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01362c001c157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008005147810ULL, 0x000fca0007ffe006ULL,
0x0000000107147824ULL, 0x000fca00078e0214ULL, 0x0130000014177984ULL, 0x000e680000000800ULL,
0x0132000014167984ULL, 0x0004e20000000800ULL, 0x000000561700720bULL, 0x002fe20003f1d000ULL,
0x0000ccc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x004fc800000e0100ULL,
0x0000ffff141d7812ULL, 0x000fe2000780c0ffULL, 0x000003d000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1c7424ULL, 0x000fd600078e00ffULL, 0x000003a000008947ULL, 0x000fea0003800000ULL,
0x0000000166157811ULL, 0x000fe400078ff0ffULL, 0x000000561700720bULL, 0x000fe40003f34000ULL,
0x000000661500720cULL, 0x000fe20003f05270ULL, 0x0000cc827f007947ULL, 0x000ff4000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x0000001756157209ULL, 0x000fe20007810000ULL,
0x00000080661e8824ULL, 0x000fe200078e0205ULL, 0x0000ffff14147812ULL, 0x000fe400078e3cffULL,
0x00000002ff277819ULL, 0x000fe20000011600ULL, 0x80000015561c7221ULL, 0x000fe20000010000ULL,
0x00000001071e8824ULL, 0x000fc600078e021eULL, 0x3fb8aa3b1c1c7820ULL, 0x000fe40000410000ULL,
0x013400151e008388ULL, 0x0003e20000000800ULL, 0x000000141dff7212ULL, 0x000fe2000780c0ffULL,
0x0000001c00247308ULL, 0x000ea40000000800ULL, 0x0000002455557220ULL, 0x004fe20000410000ULL,
0x0000cc027f007947ULL, 0x000fee000b800000ULL, 0x00001f2724147589ULL, 0x0022a400000e0000ULL,
0x000000144c4c7220ULL, 0x084fe20000410000ULL, 0x000000144d4d7220ULL, 0x080fe20000410000ULL,
0x0000001448487220ULL, 0x080fe20000410000ULL, 0x0000001449497220ULL, 0x080fe20000410000ULL,
0x0000001444447220ULL, 0x080fe20000410000ULL, 0x0000001445457220ULL, 0x080fe20000410000ULL,
0x0000001440407220ULL, 0x080fe20000410000ULL, 0x0000001441417220ULL, 0x080fe20000410000ULL,
0x000000143c3c7220ULL, 0x080fe20000410000ULL, 0x000000143d3d7220ULL, 0x080fe20000410000ULL,
0x0000001438387220ULL, 0x080fe20000410000ULL, 0x0000001439397220ULL, 0x080fe20000410000ULL,
0x0000001434347220ULL, 0x080fe20000410000ULL, 0x0000001435357220ULL, 0x080fe20000410000ULL,
0x0000001418187220ULL, 0x080fe20000410000ULL, 0x0000001419197220ULL, 0x000fe20000410000ULL,
0x0000cb427f007947ULL, 0x000fea000b800000ULL, 0x00001f0a24147589ULL, 0x00052400000e0000ULL,
0x0000001756567209ULL, 0x000fe20007810000ULL, 0x000000144e4e7220ULL, 0x090fe20000410000ULL,
0x00000001ff1c7807ULL, 0x000fe20000000000ULL, 0x000000144f4f7220ULL, 0x080fe20000410000ULL,
0x000000144a4a7220ULL, 0x080fe20000410000ULL, 0x8000005617170221ULL, 0x000fe20000010000ULL,
0x000000144b4b7220ULL, 0x080fe20000410000ULL, 0x0000001446467220ULL, 0x080fe20000410000ULL,
0x0000001447477220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b17170820ULL, 0x000fe20000410000ULL,
0x0000001442427220ULL, 0x080fe20000410000ULL, 0x0000001443437220ULL, 0x080fe20000410000ULL,
0x000000143e3e7220ULL, 0x080fe20000410000ULL, 0x0000001700090308ULL, 0x000f220000000800ULL,
0x000000143f3f7220ULL, 0x080fe20000410000ULL, 0x000000143a3a7220ULL, 0x080fe20000410000ULL,
0x000000143b3b7220ULL, 0x080fe20000410000ULL, 0x0000001436367220ULL, 0x080fe20000410000ULL,
0x0000001437377220ULL, 0x080fe20000410000ULL, 0x000000141a1a7220ULL, 0x080fe20000410000ULL,
0x000000141b1b7220ULL, 0x000fe20000410000ULL, 0x0000001609160220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000009ff14723eULL, 0x000fe200000010ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff277819ULL, 0x002fe40000011600ULL,
0x0000001000177811ULL, 0x000fe400078ff0ffULL, 0x00000018271d7810ULL, 0x000fe40007ffe0ffULL,
0x0000541014247816ULL, 0x004fe20000000014ULL, 0x0000c9c27f007947ULL, 0x000fea000b800000ULL,
0x00001f27246d7589ULL, 0x0002a800000e0000ULL, 0x00001f0a246c7589ULL, 0x00032400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff277224ULL, 0x002fe200078e0017ULL,
0x0000001f00267802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x00003dc000147802ULL, 0x000fc40000000f00ULL, 0x0000d45000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff277224ULL, 0x002fe200078e001dULL,
0x00003e2000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000d3f000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000005516557221ULL, 0x008fe20000010000ULL,
0x0000100054697824ULL, 0x000fe200078e00ffULL, 0x009800000c2c783bULL, 0x000ee20000000200ULL,
0x000099101c1c7816ULL, 0x000fc600000000ffULL, 0x0000100069697812ULL, 0x000fe200078e0cffULL,
0x009800001114783bULL, 0x000f620000000200ULL, 0x000000ff1c00720cULL, 0x000fe40003f05270ULL,
0x0000b00068697810ULL, 0x000fc80007ffe069ULL, 0x000000690d5c7211ULL, 0x080fe200078e20ffULL,
0x000000100e587824ULL, 0x100fe200078e0269ULL, 0x0000006902207211ULL, 0x000fe200078e20ffULL,
0x000000100f507824ULL, 0x100fe400078e0269ULL, 0x0000001010307824ULL, 0x100fe200078e0269ULL,
0x000000005c5c783bULL, 0x000e620000004200ULL, 0x0000001012287824ULL, 0x100fe400078e0269ULL,
0x0000001013247824ULL, 0x102fe200078e0269ULL, 0x000000005858783bULL, 0x000e620000004200ULL,
0x00000010031c7824ULL, 0x000fc600078e0269ULL, 0x000000005050783bULL, 0x000f280000004200ULL,
0x000000003030783bULL, 0x000ea80000004200ULL, 0x000000002828783bULL, 0x000e680000004200ULL,
0x000000002424783bULL, 0x000ea40000004200ULL, 0x0000006d2c2c8231ULL, 0x00cfc400003400ffULL,
0x000000002020783bULL, 0x000ea20000004200ULL, 0x0000006d2e2e8231ULL, 0x080fe400003400ffULL,
0x0000006c2d2d8231ULL, 0x090fe200003400ffULL, 0x000000001c1c783bULL, 0x000ee20000004200ULL,
0x0000006c2f2f8231ULL, 0x080fe400003400ffULL, 0x0000006d14148231ULL, 0x0a0fe400003400ffULL,
0x0000006d16168231ULL, 0x000fe400003400ffULL, 0x0000006c15158231ULL, 0x000fc400003400ffULL,
0x0000006c17178231ULL, 0x000fe200003400ffULL, 0x0000005c2c4c723cULL, 0x040ff0000004184cULL,
0x0000005e2c48723cULL, 0x040ff00000041848ULL, 0x000000582c44723cULL, 0x042ff00000041844ULL,
0x0000005a2c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000302c34723cULL, 0x040ff00000041834ULL,
0x000000322c18723cULL, 0x000ff00000041818ULL, 0x00000028144c723cULL, 0x040ff0000004184cULL,
0x0000002a1448723cULL, 0x040ff00000041848ULL, 0x000000241444723cULL, 0x040ff00000041844ULL,
0x000000261440723cULL, 0x040ff00000041840ULL, 0x00000020143c723cULL, 0x044ff0000004183cULL,
0x000000221438723cULL, 0x040ff00000041838ULL, 0x0000001c1434723cULL, 0x048ff00000041834ULL,
0x0000001e1418723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000008067147811ULL, 0x000fe200078e40ffULL, 0x013690006bff7f8cULL, 0x0003e2000c80043fULL,
0x00000001546d7812ULL, 0x000fc400078ec0ffULL, 0x000000651400720cULL, 0x000fda0003f06070ULL,
0x00002a9000000947ULL, 0x000fea0003800000ULL, 0x0000000167157810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000641500720cULL, 0x000fe40003f06070ULL,
0x000000c06a6a7810ULL, 0x000fca0007ffe0ffULL, 0x0000620061247a24ULL, 0x000fcc00078e026aULL,
0x0000059000008947ULL, 0x000fea0003800000ULL, 0x0000006a65147217ULL, 0x000fe20007800000ULL,
0x0000000863167824ULL, 0x000fe200078e00ffULL, 0x00000003ff1d7819ULL, 0x000fe20000011600ULL,
0x00000100ff257424ULL, 0x000fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe200078e0a6aULL,
0xfffffff8162b7812ULL, 0x000fe200078ee20bULL, 0x000000011d157824ULL, 0x040fe200078e0224ULL,
0x000000081d217810ULL, 0x000fe40007ffe0ffULL, 0x0000002014167817ULL, 0x000fe20003800000ULL,
0x00005e0015147625ULL, 0x000fe200078e0025ULL, 0x0000000c1d237810ULL, 0x000fc40007ffe0ffULL,
0x000000071d177812ULL, 0x000fe200078e4800ULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0x000000041d1f7810ULL, 0x000fe20007ffe0ffULL, 0x00000008232d7824ULL, 0x000fe200078e00ffULL,
0x000000161d00720cULL, 0x000fe20003f06070ULL, 0x000000102b147825ULL, 0x000fe200078e0014ULL,
0x0ffffff8171c7812ULL, 0x000fe400078ef800ULL, 0x000000001f1e7212ULL, 0x0c0fe400078e3cffULL,
0x000000031f277819ULL, 0x000fe200000006ffULL, 0x000000101c177824ULL, 0x000fe200078e0269ULL,
0x0000000021207212ULL, 0x000fc400078e3cffULL, 0x0000000023227212ULL, 0x000fe400078e3cffULL,
0xfffffff827267812ULL, 0x000fe200078ee21eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c101c46ULL, 0xfffffff829287812ULL, 0x000fe400078ee220ULL,
0xfffffff82d2a7812ULL, 0x000fe400078ee222ULL, 0x000000101d277810ULL, 0x040fe40007ffe0ffULL,
0x000000141d297810ULL, 0x000fc40007ffe0ffULL, 0x000000181d2d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008272c7824ULL, 0x000fe200078e00ffULL, 0x0000001c1d2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f147824ULL, 0x142fe200078e0224ULL, 0x000000161f00720cULL, 0x080fe20003f06070ULL,
0x00000008292e7824ULL, 0x000fe200078e00ffULL, 0x000000162100720cULL, 0x080fe20003f26070ULL,
0x000000082d307824ULL, 0x000fe200078e00ffULL, 0x000000162300720cULL, 0x080fe20003f46070ULL,
0x000000082f327824ULL, 0x000fe200078e00ffULL, 0x000000162700720cULL, 0x0c0fe20003f66070ULL,
0x00000001271e7824ULL, 0x100fe200078e0224ULL, 0x000000162900720cULL, 0x0c0fe20003f86070ULL,
0x0000000129207824ULL, 0x100fe200078e0224ULL, 0x000000162d00720cULL, 0x0c0fe20003fa6070ULL,
0x000000012d227824ULL, 0x100fe200078e0224ULL, 0x000000162f00720cULL, 0x000fe20003fc6070ULL,
0x0000000121167824ULL, 0x000fe200078e0224ULL, 0x00000024231c7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0020207625ULL, 0x000fe200078e0025ULL, 0x0000000027157212ULL, 0x000fc400078e3cffULL,
0x0000000029177212ULL, 0x080fe200078e3cffULL, 0x00005e0022227625ULL, 0x080fe200078e0025ULL,
0x000000002d1d7212ULL, 0x080fe400078e3cffULL, 0x000000002f1f7212ULL, 0x040fe200078e3cffULL,
0x0000001026277824ULL, 0x100fe200078e0269ULL, 0x000000242f247210ULL, 0x000fe20007ffe0ffULL,
0x0000001028297824ULL, 0x000fe200078e0269ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x000fe200078e0025ULL, 0xfffffff82e2e7812ULL, 0x000fc400078ee217ULL,
0xfffffff830307812ULL, 0x000fe200078ee21dULL, 0x00005e0016167625ULL, 0x000fe200078e0025ULL,
0xfffffff832327812ULL, 0x000fe400078ee21fULL, 0x000000692c2d7211ULL, 0x000fe200078e20ffULL,
0x00005e001c1c7625ULL, 0x000fc800078e0025ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0025ULL,
0x00005e0024247625ULL, 0x000fc800078e0025ULL, 0x000000102b147825ULL, 0x000fc800078e0014ULL,
0x000000102b167825ULL, 0x040fe200078e0016ULL, 0x0000000014277faeULL, 0x0003e6000c101c46ULL,
0x000000102b1c7825ULL, 0x040fe200078e001cULL, 0x0000000016297faeULL, 0x0003e6000c901c46ULL,
0x000000102b1e7825ULL, 0x000fc800078e001eULL, 0x000000102b207825ULL, 0x000fc800078e0020ULL,
0x000000102b227825ULL, 0x000fc800078e0022ULL, 0x000000102b247825ULL, 0x000fc800078e0024ULL,
0x000000102a2b7824ULL, 0x100fe400078e0269ULL, 0x000000102e2f7824ULL, 0x100fe400078e0269ULL,
0x0000001030317824ULL, 0x100fe200078e0269ULL, 0x000000001c2b7faeULL, 0x0003e2000d101c46ULL,
0x0000001032337824ULL, 0x000fc600078e0269ULL, 0x000000001e2d7faeULL, 0x0003e8000d901c46ULL,
0x00000000202f7faeULL, 0x0003e8000e101c46ULL, 0x0000000022317faeULL, 0x0003e8000e901c46ULL,
0x0000000024337faeULL, 0x0003e2000f101c46ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x00000003ff157819ULL, 0x000fe20000011600ULL, 0x00000100ff277424ULL, 0x000fc600078e00ffULL,
0x00000004151d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008151f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c15217810ULL, 0x000fe20007ffe0ffULL, 0x000000081d237824ULL, 0x040fe200078e00ffULL,
0x000000001d147212ULL, 0x080fe200078e3cffULL, 0x000000081f257824ULL, 0x040fe200078e00ffULL,
0x000000001f167212ULL, 0x080fe200078e3cffULL, 0x000000011d1c7824ULL, 0x100fe200078e0224ULL,
0x0000000021177212ULL, 0x000fe200078e3cffULL, 0x000000011f1e7824ULL, 0x000fe200078e0224ULL,
0x00000003212c7819ULL, 0x000fc400000006ffULL, 0xfffffff823287812ULL, 0x000fe200078ee214ULL,
0x0000000863147824ULL, 0x000fe200078e00ffULL, 0xfffffff8252a7812ULL, 0x000fe400078ee216ULL,
0xfffffff82c2c7812ULL, 0x000fe400078ee217ULL, 0x0000001015237810ULL, 0x040fe20007ffe0ffULL,
0x000000102a2f7824ULL, 0x000fe200078e0269ULL, 0x0000000715177812ULL, 0x040fe400078e4800ULL,
0x0000001415257810ULL, 0x000fe20007ffe0ffULL, 0x00000008232e7824ULL, 0x000fe200078e00ffULL,
0x00000018152b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000123227824ULL, 0x100fe200078e0224ULL,
0x0000001c152d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000825307824ULL, 0x000fe200078e00ffULL,
0xfffffff814297812ULL, 0x000fe200078ee20bULL, 0x0000000115147824ULL, 0x000fe200078e0224ULL,
0x0ffffff817167812ULL, 0x000fe200078ef800ULL, 0x000000082b507824ULL, 0x000fe200078e00ffULL,
0x0000000023177212ULL, 0x080fe200078e3cffULL, 0x000000082d587824ULL, 0x000fe200078e00ffULL,
0x00000000251d7212ULL, 0x000fe200078e3cffULL, 0x000000012b327824ULL, 0x000fe200078e0224ULL,
0x0000002421207210ULL, 0x000fe20007ffe0ffULL, 0x00005e0014147625ULL, 0x000fe200078e0027ULL,
0x000000002b1f7212ULL, 0x000fc400078e3cffULL, 0x000000002d217212ULL, 0x000fe200078e3cffULL,
0x00000010162b7824ULL, 0x000fe200078e0269ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee217ULL,
0x0000000125267824ULL, 0x000fe200078e0224ULL, 0x000000242d527210ULL, 0x000fe20007ffe0ffULL,
0x00005e001c167625ULL, 0x080fe200078e0027ULL, 0xfffffff830307812ULL, 0x000fe400078ee21dULL,
0xfffffff850507812ULL, 0x000fe200078ee21fULL, 0x00005e001e1c7625ULL, 0x000fe200078e0027ULL,
0xfffffff858587812ULL, 0x000fc600078ee221ULL, 0x00005e00201e7625ULL, 0x000fc800078e0027ULL,
0x00005e0022207625ULL, 0x000fc800078e0027ULL, 0x00005e0026227625ULL, 0x000fc800078e0027ULL,
0x00005e0032247625ULL, 0x000fc800078e0027ULL, 0x0000001029147825ULL, 0x000fc800078e0014ULL,
0x00005e0052267625ULL, 0x000fe200078e0027ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e6000b901c46ULL, 0x00000010282d7824ULL, 0x000fe400078e0269ULL,
0x0000001029167825ULL, 0x000fc800078e0016ULL, 0x00000010291c7825ULL, 0x040fe200078e001cULL,
0x00000000162d7faeULL, 0x0005e2000b901c46ULL, 0x000000692c157211ULL, 0x002fe400078e20ffULL,
0x00000010291e7825ULL, 0x040fe200078e001eULL, 0x000000001c2f7faeULL, 0x0005e6000b901c46ULL,
0x0000001029207825ULL, 0x040fe200078e0020ULL, 0x000000001e157faeULL, 0x0005e6000b901c46ULL,
0x0000001029227825ULL, 0x000fc800078e0022ULL, 0x0000001029247825ULL, 0x000fc800078e0024ULL,
0x0000001029267825ULL, 0x000fc800078e0026ULL, 0x000000102e297824ULL, 0x100fe400078e0269ULL,
0x00000010302b7824ULL, 0x100fe400078e0269ULL, 0x0000001050317824ULL, 0x100fe200078e0269ULL,
0x0000000020297faeULL, 0x0005e2000b901c46ULL, 0x0000001058337824ULL, 0x000fc600078e0269ULL,
0x00000000222b7faeULL, 0x0005e8000b901c46ULL, 0x0000000024317faeULL, 0x0005e8000b901c46ULL,
0x0000000026337faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136480004167f8cULL, 0x006fe8000c80043fULL,
0x01364c0004157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007804817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01364c0004157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010005147810ULL, 0x000fc80007ffe006ULL, 0x0000001407147210ULL, 0x000fca0007ffe0ffULL,
0x0130000014177984ULL, 0x000e680000000800ULL, 0x0132000014167984ULL, 0x0004e20000000800ULL,
0x000000561700720bULL, 0x002fe20003f1d000ULL, 0x0000b9827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff141d7812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000266157811ULL, 0x000fe400078ff0ffULL,
0x000000561700720bULL, 0x000fe40003f34000ULL, 0x000000661500720cULL, 0x000fe20003f05270ULL,
0x0000b9427f007947ULL, 0x000ff4000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x0000001756157209ULL, 0x000fe20007810000ULL, 0x00000080661e8824ULL, 0x000fe200078e0205ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff277819ULL, 0x000fe20000011600ULL,
0x80000015561c7221ULL, 0x000fe20000010000ULL, 0x00000001071e8824ULL, 0x000fc600078e021eULL,
0x3fb8aa3b1c1c7820ULL, 0x000fe40000410000ULL, 0x013400151e008388ULL, 0x0003e20000000800ULL,
0x000000141dff7212ULL, 0x000fe2000780c0ffULL, 0x0000001c00247308ULL, 0x000ea40000000800ULL,
0x0000002455557220ULL, 0x004fe20000410000ULL, 0x0000b8c27f007947ULL, 0x000fee000b800000ULL,
0x00001f2724147589ULL, 0x0022a400000e0000ULL, 0x000000144c4c7220ULL, 0x084fe20000410000ULL,
0x000000144d4d7220ULL, 0x080fe20000410000ULL, 0x0000001448487220ULL, 0x080fe20000410000ULL,
0x0000001449497220ULL, 0x080fe20000410000ULL, 0x0000001444447220ULL, 0x080fe20000410000ULL,
0x0000001445457220ULL, 0x080fe20000410000ULL, 0x0000001440407220ULL, 0x080fe20000410000ULL,
0x0000001441417220ULL, 0x080fe20000410000ULL, 0x000000143c3c7220ULL, 0x080fe20000410000ULL,
0x000000143d3d7220ULL, 0x080fe20000410000ULL, 0x0000001438387220ULL, 0x080fe20000410000ULL,
0x0000001439397220ULL, 0x080fe20000410000ULL, 0x0000001434347220ULL, 0x080fe20000410000ULL,
0x0000001435357220ULL, 0x080fe20000410000ULL, 0x0000001418187220ULL, 0x080fe20000410000ULL,
0x0000001419197220ULL, 0x000fe20000410000ULL, 0x0000b8027f007947ULL, 0x000fea000b800000ULL,
0x00001f0a24147589ULL, 0x00052400000e0000ULL, 0x0000001756567209ULL, 0x000fe20007810000ULL,
0x000000144e4e7220ULL, 0x090fe20000410000ULL, 0x00000001ff1c7807ULL, 0x000fe20000000000ULL,
0x000000144f4f7220ULL, 0x080fe20000410000ULL, 0x000000144a4a7220ULL, 0x080fe20000410000ULL,
0x8000005617170221ULL, 0x000fe20000010000ULL, 0x000000144b4b7220ULL, 0x080fe20000410000ULL,
0x0000001446467220ULL, 0x080fe20000410000ULL, 0x0000001447477220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b17170820ULL, 0x000fe20000410000ULL, 0x0000001442427220ULL, 0x080fe20000410000ULL,
0x0000001443437220ULL, 0x080fe20000410000ULL, 0x000000143e3e7220ULL, 0x080fe20000410000ULL,
0x0000001700090308ULL, 0x000f220000000800ULL, 0x000000143f3f7220ULL, 0x080fe20000410000ULL,
0x000000143a3a7220ULL, 0x080fe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x080fe20000410000ULL,
0x000000141a1a7220ULL, 0x080fe20000410000ULL, 0x000000141b1b7220ULL, 0x000fe20000410000ULL,
0x0000001609160220ULL, 0x018fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000009ff14723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff277819ULL, 0x002fe40000011600ULL, 0x0000001000177811ULL, 0x000fe400078ff0ffULL,
0x00000018271d7810ULL, 0x000fe40007ffe0ffULL, 0x0000541014247816ULL, 0x004fe20000000014ULL,
0x0000b6827f007947ULL, 0x000fea000b800000ULL, 0x00001f27246d7589ULL, 0x0002a800000e0000ULL,
0x00001f0a246a7589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff277224ULL, 0x002fe200078e0017ULL, 0x0000533000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000bee000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff277224ULL, 0x002fe200078e001dULL, 0x0000001f00267802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fe200078e00ffULL, 0x0000539000147802ULL, 0x000fe40000000f00ULL,
0x0000be8000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000005516557221ULL, 0x008fe20000010000ULL, 0x0000100054147824ULL, 0x000fe200078e00ffULL,
0x00a000000c2c783bULL, 0x000ee20000000200ULL, 0x000099101c1c7816ULL, 0x000fc600000000ffULL,
0x0000100014157812ULL, 0x000fe400078ec0ffULL, 0x000000ff1c00720cULL, 0x000fe40003f05270ULL,
0x0000b00068687810ULL, 0x000fe40007ffe015ULL, 0x00a000001114783bULL, 0x000f640000000200ULL,
0x0000006810307211ULL, 0x000fe200078e20ffULL, 0x000000100d5c7824ULL, 0x100fe400078e0268ULL,
0x000000100e587824ULL, 0x000fc400078e0268ULL, 0x000000100f507824ULL, 0x100fe200078e0268ULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x0000001012287824ULL, 0x100fe400078e0268ULL,
0x0000001013247824ULL, 0x102fe200078e0268ULL, 0x000000005c5c783bULL, 0x000e620000004200ULL,
0x0000001002207824ULL, 0x100fe400078e0268ULL, 0x00000010031c7824ULL, 0x000fe200078e0268ULL,
0x000000005858783bULL, 0x000f280000004200ULL, 0x000000005050783bULL, 0x000ea80000004200ULL,
0x000000002828783bULL, 0x000ea80000004200ULL, 0x000000002424783bULL, 0x000ea40000004200ULL,
0x0000006d2c2c8231ULL, 0x00cfc400003400ffULL, 0x000000002020783bULL, 0x000ea20000004200ULL,
0x0000006d2e2e8231ULL, 0x080fe400003400ffULL, 0x0000006a2d2d8231ULL, 0x090fe200003400ffULL,
0x000000001c1c783bULL, 0x000ee20000004200ULL, 0x0000006a2f2f8231ULL, 0x080fe400003400ffULL,
0x0000006d14148231ULL, 0x0a0fe400003400ffULL, 0x0000006d16168231ULL, 0x000fe400003400ffULL,
0x0000006a15158231ULL, 0x000fc400003400ffULL, 0x0000006a17178231ULL, 0x000fe200003400ffULL,
0x000000302c34723cULL, 0x040ff00000041834ULL, 0x0000005c2c4c723cULL, 0x042ff0000004184cULL,
0x0000005e2c48723cULL, 0x040ff00000041848ULL, 0x000000582c44723cULL, 0x040ff00000041844ULL,
0x0000005a2c40723cULL, 0x040ff00000041840ULL, 0x000000502c3c723cULL, 0x040ff0000004183cULL,
0x000000522c38723cULL, 0x040ff00000041838ULL, 0x000000322c18723cULL, 0x000ff00000041818ULL,
0x00000028144c723cULL, 0x040ff0000004184cULL, 0x0000002a1448723cULL, 0x040ff00000041848ULL,
0x000000241444723cULL, 0x040ff00000041844ULL, 0x000000261440723cULL, 0x040ff00000041840ULL,
0x00000020143c723cULL, 0x044ff0000004183cULL, 0x000000221438723cULL, 0x040ff00000041838ULL,
0x0000001c1434723cULL, 0x048ff00000041834ULL, 0x0000001e1418723cULL, 0x000fe20000041818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000c067147811ULL, 0x000fe200078e40ffULL,
0x013698006bff7f8cULL, 0x0003e2000c80043fULL, 0x00000001546d7812ULL, 0x000fc400078e0cffULL,
0x000000651400720cULL, 0x000fda0003f06070ULL, 0x0000152000000947ULL, 0x000fea0003800000ULL,
0x0000030067147a10ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000114157810ULL, 0x040fe20007ffe0ffULL, 0x0000010014167824ULL, 0x000fc600078e0257ULL,
0x000000641500720cULL, 0x000fe20003f06070ULL, 0x0000620061247a24ULL, 0x000fd800078e0216ULL,
0x0000059000008947ULL, 0x000fea0003800000ULL, 0x0000001665147217ULL, 0x000fe20007800000ULL,
0x00000100ff257424ULL, 0x000fe200078e00ffULL, 0x00000003631c7819ULL, 0x000fe400000006ffULL,
0x00000003ff1d7819ULL, 0x000fe20000011600ULL, 0x0000000114147824ULL, 0x000fe200078e0a16ULL,
0xfffffff81c277812ULL, 0x000fe400078ee20bULL, 0x000000071d177812ULL, 0x040fe200078e4800ULL,
0x000000011d157824ULL, 0x000fe200078e0224ULL, 0x00000020140b7817ULL, 0x000fc40003800000ULL,
0x0ffffff817177812ULL, 0x000fe200078ef800ULL, 0x00005e0015147625ULL, 0x000fe200078e0025ULL,
0x0000000b1d00720cULL, 0x040fe40003f06070ULL, 0x000000041d1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e0268ULL, 0x000000081d217810ULL, 0x000fe20007ffe0ffULL,
0x0000001027147825ULL, 0x000fe200078e0014ULL, 0x0000000c1d237810ULL, 0x040fe40007ffe0ffULL,
0x000000141d317810ULL, 0x000fe20007ffe0ffULL, 0x000000081f297824ULL, 0x000fe200078e00ffULL,
0x000000181d337810ULL, 0x000fe20007ffe0ffULL, 0x00000008212b7824ULL, 0x000fe200078e00ffULL,
0x000000101d2f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014177faeULL, 0x0003e2000c101c46ULL, 0x000000001f167212ULL, 0x080fe200078e3cffULL,
0x0000000831287824ULL, 0x000fe200078e00ffULL, 0x00000000211c7212ULL, 0x080fe200078e3cffULL,
0x00000008332a7824ULL, 0x000fe200078e00ffULL, 0x00000000231e7212ULL, 0x000fe200078e3cffULL,
0x0000000131207824ULL, 0x100fe200078e0224ULL, 0x00000003232d7819ULL, 0x000fe200000006ffULL,
0x0000000133227824ULL, 0x000fe200078e0224ULL, 0x0000001c1d1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000b1f00720cULL, 0x040fe20003f06070ULL, 0x000000011f147824ULL, 0x002fe200078e0224ULL,
0xfffffff829297812ULL, 0x000fe200078ee216ULL, 0x0000000121167824ULL, 0x000fe200078e0224ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21cULL, 0x00000001231c7824ULL, 0x000fe200078e0224ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee21eULL, 0x000000012f1e7824ULL, 0x100fe200078e0224ULL,
0x0000000031157212ULL, 0x080fe200078e3cffULL, 0x000000011d247824ULL, 0x000fe200078e0224ULL,
0x0000000033177212ULL, 0x000fc400078e3cffULL, 0x000000001d1f7212ULL, 0x040fe400078e3cffULL,
0x000000031d2c7819ULL, 0x000fe400000006ffULL, 0x0000000b3100720cULL, 0x080fe40003f86070ULL,
0x0000000b3300720cULL, 0x080fe40003fa6070ULL, 0x0000000b2100720cULL, 0x000fe20003f26070ULL,
0x00005e0020207625ULL, 0x000fe200078e0025ULL, 0x0000000b2300720cULL, 0x000fc40003f46070ULL,
0x0000000b1d00720cULL, 0x000fe20003fc6070ULL, 0x00005e001c1c7625ULL, 0x080fe200078e0025ULL,
0xfffffff828317812ULL, 0x000fe400078ee215ULL, 0xfffffff82a337812ULL, 0x000fe200078ee217ULL,
0x00005e0014147625ULL, 0x000fe200078e0025ULL, 0xfffffff82c517812ULL, 0x000fe400078ee21fULL,
0x0000000b2f00720cULL, 0x040fe20003f66070ULL, 0x00005e0016167625ULL, 0x000fe200078e0025ULL,
0x000000002f0b7212ULL, 0x000fc400078e3cffULL, 0x000000032f267819ULL, 0x000fe200000006ffULL,
0x00005e001e1e7625ULL, 0x000fc600078e0025ULL, 0xfffffff8262f7812ULL, 0x000fe200078ee20bULL,
0x00005e0022227625ULL, 0x000fc800078e0025ULL, 0x00005e0024247625ULL, 0x000fc800078e0025ULL,
0x0000001027147825ULL, 0x000fc800078e0014ULL, 0x0000001027167825ULL, 0x000fc800078e0016ULL,
0x00000010271c7825ULL, 0x000fc800078e001cULL, 0x00000010271e7825ULL, 0x000fc800078e001eULL,
0x0000001027207825ULL, 0x000fc800078e0020ULL, 0x0000001027227825ULL, 0x000fc800078e0022ULL,
0x0000001027247825ULL, 0x000fc800078e0024ULL, 0x00000010290b7824ULL, 0x100fe400078e0268ULL,
0x000000102b277824ULL, 0x100fe400078e0268ULL, 0x000000102d297824ULL, 0x100fe200078e0268ULL,
0x00000000140b7faeULL, 0x0003e2000c101c46ULL, 0x000000102f2b7824ULL, 0x100fe200078e0268ULL,
0x00000068332f7211ULL, 0x000fe200078e20ffULL, 0x00000010312d7824ULL, 0x100fe200078e0268ULL,
0x0000000016277faeULL, 0x0003e2000c901c46ULL, 0x0000001051317824ULL, 0x000fc600078e0268ULL,
0x000000001c297faeULL, 0x0003e8000d101c46ULL, 0x000000001e2b7faeULL, 0x0003e8000d901c46ULL,
0x00000000202d7faeULL, 0x0003e8000e101c46ULL, 0x00000000222f7faeULL, 0x0003e8000e901c46ULL,
0x0000000024317faeULL, 0x0003e2000f101c46ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x00000003ff157819ULL, 0x000fe20000011600ULL, 0x00000008631c7824ULL, 0x000fe200078e00ffULL,
0x0000010000277802ULL, 0x000fc40000000f00ULL, 0x0000000c15217810ULL, 0x040fe40007ffe0ffULL,
0x00000004151d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008151f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008211e7824ULL, 0x040fe200078e00ffULL, 0x0000000021177212ULL, 0x080fe200078e3cffULL,
0x000000081d2b7824ULL, 0x040fe200078e00ffULL, 0x000000001d147212ULL, 0x080fe200078e3cffULL,
0x000000081f2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e2f7812ULL, 0x000fe200078ee217ULL,
0x00000001211e7824ULL, 0x000fe200078e0224ULL, 0x000000001f167212ULL, 0x000fc400078e3cffULL,
0x0000000715177812ULL, 0x000fe200078e4800ULL, 0x000000102f2f7824ULL, 0x000fe200078e0268ULL,
0x0000001015237810ULL, 0x040fe40007ffe0ffULL, 0x0000001415257810ULL, 0x040fe40007ffe0ffULL,
0x0000001815297810ULL, 0x000fe20007ffe0ffULL, 0x0000000123207824ULL, 0x100fe200078e0224ULL,
0x0000001c15317810ULL, 0x000fe20007ffe0ffULL, 0x0000000125227824ULL, 0x000fe200078e0224ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee214ULL, 0x0000000115147824ULL, 0x000fe200078e0224ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee216ULL, 0x000000011d167824ULL, 0x000fe200078e0224ULL,
0x0ffffff817177812ULL, 0x000fe200078ef800ULL, 0x00000008252c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c0b7812ULL, 0x000fe200078ee20bULL, 0x000000011f1c7824ULL, 0x100fe200078e0224ULL,
0x00000000231d7212ULL, 0x080fe200078e3cffULL, 0x0000000129267824ULL, 0x100fe200078e0224ULL,
0x00000003232a7819ULL, 0x000fe200000006ffULL, 0x0000000131287824ULL, 0x000fe200078e0224ULL,
0x00000000251f7212ULL, 0x080fe200078e3cffULL, 0x0000000829247824ULL, 0x040fe200078e00ffULL,
0x0000000029217212ULL, 0x080fe200078e3cffULL, 0x00005e0014147625ULL, 0x000fe200078e0027ULL,
0x0000000031237212ULL, 0x000fc400078e3cffULL, 0x00000003312e7819ULL, 0x000fe200000006ffULL,
0x0000001017297824ULL, 0x000fe200078e0268ULL, 0xfffffff82a317812ULL, 0x000fe200078ee21dULL,
0x00005e0016167625ULL, 0x080fe200078e0027ULL, 0xfffffff82c337812ULL, 0x000fe400078ee21fULL,
0xfffffff824517812ULL, 0x000fe200078ee221ULL, 0x00005e001c1c7625ULL, 0x080fe200078e0027ULL,
0xfffffff82e537812ULL, 0x000fe400078ee223ULL, 0x0000006833337211ULL, 0x000fe200078e20ffULL,
0x00005e001e1e7625ULL, 0x000fc800078e0027ULL, 0x00005e0020207625ULL, 0x000fc800078e0027ULL,
0x00005e0022227625ULL, 0x000fc800078e0027ULL, 0x000000100b147825ULL, 0x000fc800078e0014ULL,
0x00005e0026247625ULL, 0x080fe200078e0027ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014297faeULL, 0x0003e6000b901c46ULL, 0x00005e0028267625ULL, 0x000fc800078e0027ULL,
0x000000100b167825ULL, 0x000fc800078e0016ULL, 0x000000102b2b7824ULL, 0x000fe400078e0268ULL,
0x000000100b1c7825ULL, 0x000fc600078e001cULL, 0x00000000162b7faeULL, 0x0003e2000b901c46ULL,
0x000000102d2d7824ULL, 0x000fe400078e0268ULL, 0x000000100b1e7825ULL, 0x000fc600078e001eULL,
0x000000001c2d7faeULL, 0x0003e2000b901c46ULL, 0x000000100b207825ULL, 0x000fc600078e0020ULL,
0x000000001e2f7faeULL, 0x0003e2000b901c46ULL, 0x0000001031317824ULL, 0x000fe400078e0268ULL,
0x000000100b227825ULL, 0x000fc600078e0022ULL, 0x0000000020317faeULL, 0x0003e2000b901c46ULL,
0x000000100b247825ULL, 0x000fc600078e0024ULL, 0x0000000022337faeULL, 0x0003e2000b901c46ULL,
0x0000001051517824ULL, 0x000fe400078e0268ULL, 0x000000100b267825ULL, 0x000fc600078e0026ULL,
0x0000000024517faeULL, 0x0003e2000b901c46ULL, 0x0000001053537824ULL, 0x000fca00078e0268ULL,
0x0000000026537faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136680004147f8cULL, 0x002fe8000c80043fULL,
0x01366c00040b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b00167305ULL, 0x0002a4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x000000160000735dULL, 0x004fe20003800000ULL, 0x01366c0004177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018005067810ULL, 0x000fca0007ffe006ULL, 0x0000000107067824ULL, 0x000fca00078e0206ULL,
0x01300000060b7984ULL, 0x000e680000000800ULL, 0x0132000006047984ULL, 0x0004e20000000800ULL,
0x000000560b00720bULL, 0x002fe20003f1d000ULL, 0x0000a6327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000067806ULL, 0x004fc800000e0100ULL, 0x0000ffff06167812ULL, 0x000fe2000780c0ffULL,
0x000003d000007945ULL, 0x000fe20003800000ULL, 0x0000000100287802ULL, 0x000fd60000000f00ULL,
0x000003a000008947ULL, 0x000fea0003800000ULL, 0x0000000366157811ULL, 0x000fe400078ff0ffULL,
0x000000560b00720bULL, 0x000fe40003f34000ULL, 0x000000661500720cULL, 0x000fe20003f05270ULL,
0x0000a5f27f007947ULL, 0x000ff4000b800000ULL, 0x0000000000067806ULL, 0x000fe400008e0100ULL,
0x0000000b56087209ULL, 0x000fe20007810000ULL, 0x0000008066148824ULL, 0x000fe200078e0205ULL,
0x00000002ff277819ULL, 0x000fc60000011600ULL, 0x8000000856057221ULL, 0x000fe20000010000ULL,
0x0000000107158824ULL, 0x000fe200078e0214ULL, 0x0000ffff06077812ULL, 0x000fe400078e3cffULL,
0x3fb8aa3b05057820ULL, 0x000fe40000410000ULL, 0x0134000815008388ULL, 0x0003e20000000800ULL,
0x0000000716ff7212ULL, 0x000fe2000780c0ffULL, 0x0000000500247308ULL, 0x000ea40000000800ULL,
0x0000002455557220ULL, 0x004fe20000410000ULL, 0x0000a5727f007947ULL, 0x000fee000b800000ULL,
0x00001f2724057589ULL, 0x0022a400000e0000ULL, 0x000000054c4c7220ULL, 0x084fe20000410000ULL,
0x000000054d4d7220ULL, 0x080fe20000410000ULL, 0x0000000548487220ULL, 0x080fe20000410000ULL,
0x0000000549497220ULL, 0x080fe20000410000ULL, 0x0000000544447220ULL, 0x080fe20000410000ULL,
0x0000000545457220ULL, 0x080fe20000410000ULL, 0x0000000540407220ULL, 0x080fe20000410000ULL,
0x0000000541417220ULL, 0x080fe20000410000ULL, 0x000000053c3c7220ULL, 0x080fe20000410000ULL,
0x000000053d3d7220ULL, 0x080fe20000410000ULL, 0x0000000538387220ULL, 0x080fe20000410000ULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x0000000534347220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x0000000519197220ULL, 0x000fe20000410000ULL, 0x0000a4b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0a24057589ULL, 0x00052400000e0000ULL, 0x800000080b0b0221ULL, 0x100fe20000010000ULL,
0x00000001ff287807ULL, 0x000fe20000000000ULL, 0x000000054e4e7220ULL, 0x090fe20000410000ULL,
0x000000054f4f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b0b0b0820ULL, 0x000fe20000410000ULL,
0x000000054a4a7220ULL, 0x080fe20000410000ULL, 0x000000054b4b7220ULL, 0x080fe20000410000ULL,
0x0000000546467220ULL, 0x080fe20000410000ULL, 0x0000000b00090308ULL, 0x000f220000000800ULL,
0x0000000547477220ULL, 0x080fe20000410000ULL, 0x0000000542427220ULL, 0x080fe20000410000ULL,
0x0000000543437220ULL, 0x080fe20000410000ULL, 0x000000053e3e7220ULL, 0x080fe20000410000ULL,
0x000000053f3f7220ULL, 0x080fe20000410000ULL, 0x000000053a3a7220ULL, 0x080fe20000410000ULL,
0x000000053b3b7220ULL, 0x080fe20000410000ULL, 0x0000000536367220ULL, 0x080fe20000410000ULL,
0x0000000537377220ULL, 0x080fe20000410000ULL, 0x000000051a1a7220ULL, 0x080fe20000410000ULL,
0x000000051b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff567224ULL, 0x000fe200078e0008ULL,
0x0000000409040220ULL, 0x018fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000009ff07723eULL, 0x000fe200000010ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff277819ULL, 0x002fe40000011600ULL, 0x0000001000057811ULL, 0x000fe400078ff0ffULL,
0x0000001827067810ULL, 0x000fe40007ffe0ffULL, 0x0000541007247816ULL, 0x004fe20000000007ULL,
0x0000a3327f007947ULL, 0x000fea000b800000ULL, 0x00001f27240b7589ULL, 0x0002a800000e0000ULL,
0x00001f0a240a7589ULL, 0x00032400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff277224ULL, 0x002fe200078e0005ULL, 0x000068b000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000a96000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff277224ULL, 0x002fe200078e0006ULL, 0xffffffff00297802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0x0000691000147802ULL, 0x000fe40000000f00ULL,
0x0000a90000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000005504557221ULL, 0x008fe40000010000ULL, 0x00a800000c04783bULL, 0x000ee20000000200ULL,
0x000000100d147824ULL, 0x100fe200078e0269ULL, 0x0000991028087816ULL, 0x000fe200000000ffULL,
0x000000100e1c7824ULL, 0x100fe200078e0269ULL, 0x0000006913307211ULL, 0x000fe200078e20ffULL,
0x000000100f247824ULL, 0x102fe200078e0269ULL, 0x000000ff0800720cULL, 0x000fe20003f05270ULL,
0x0000001010207824ULL, 0x100fe200078e0269ULL, 0x000000001414783bULL, 0x000e620000004200ULL,
0x0000001012507824ULL, 0x000fc400078e0269ULL, 0x0000001003287824ULL, 0x100fe200078e0269ULL,
0x000000001c1c783bULL, 0x004fe20000004200ULL, 0x00000010022c7824ULL, 0x000fc600078e0269ULL,
0x000000002424783bULL, 0x000fe80000004200ULL, 0x000000002020783bULL, 0x000fe80000004200ULL,
0x00a80000110c783bULL, 0x000ea80000000200ULL, 0x000000005050783bULL, 0x000f680000004200ULL,
0x000000003030783bULL, 0x000f280000004200ULL, 0x000000002c2c783bULL, 0x000f280000004200ULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x0000000b04048231ULL, 0x008fc400003400ffULL,
0x0000000b06068231ULL, 0x000fe400003400ffULL, 0x0000000a05058231ULL, 0x090fe400003400ffULL,
0x0000000a07078231ULL, 0x000fce00003400ffULL, 0x00000014044c723cULL, 0x042ff0000004184cULL,
0x000000160448723cULL, 0x000fe20000041848ULL, 0x0000000b0c0c8231ULL, 0x084fe400003400ffULL,
0x0000000b0e0e8231ULL, 0x000fc400003400ffULL, 0x0000000a0d0d8231ULL, 0x000fc600003400ffULL,
0x0000001c0444723cULL, 0x000fe20000041844ULL, 0x0000000a0f0f8231ULL, 0x000fce00003400ffULL,
0x0000001e0440723cULL, 0x040ff00000041840ULL, 0x00000024043c723cULL, 0x040ff0000004183cULL,
0x000000260438723cULL, 0x040ff00000041838ULL, 0x000000200434723cULL, 0x040ff00000041834ULL,
0x000000220418723cULL, 0x000ff00000041818ULL, 0x000000500c4c723cULL, 0x060ff0000004184cULL,
0x000000520c48723cULL, 0x040ff00000041848ULL, 0x000000300c44723cULL, 0x040ff00000041844ULL,
0x000000320c40723cULL, 0x040ff00000041840ULL, 0x0000002c0c3c723cULL, 0x040ff0000004183cULL,
0x0000002e0c38723cULL, 0x040ff00000041838ULL, 0x000000280c34723cULL, 0x040ff00000041834ULL,
0x0000002a0c18723cULL, 0x000fe20000041818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0136a0006bff7f8cULL, 0x0003e2000c80043fULL, 0x00000001546d7812ULL, 0x000fce00078ec0ffULL,
0x0000030067677a10ULL, 0x002fc80007ffe0ffULL, 0x000000646700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffa59000007947ULL, 0x000fea000383ffffULL,
0x00000000000579c3ULL, 0x000e640000002500ULL, 0x0000000564007c0cULL, 0x002fda000bf03070ULL,
0x0000033000000947ULL, 0x000fea0003800000ULL, 0x0180000055007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x00006d4000067802ULL, 0x000fe40000000f00ULL, 0x0000a32000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000005500007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000055ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000f280000000000ULL, 0x0000000000027919ULL, 0x000f620000000000ULL,
0x0000000803037811ULL, 0x010fe400078ff0ffULL, 0x00000002ff057819ULL, 0x020fc80000011602ULL,
0x00001f0300037589ULL, 0x00cea800000e0000ULL, 0x00001f0500027589ULL, 0x000ee200000e0000ULL,
0x0000004e034e7220ULL, 0x044fe20000410000ULL, 0x0000004f034f7220ULL, 0x040fe20000410000ULL,
0x0000004a034a7220ULL, 0x040fe20000410000ULL, 0x0000004b034b7220ULL, 0x040fe20000410000ULL,
0x0000004c024c7220ULL, 0x048fe20000410000ULL, 0x0000004d024d7220ULL, 0x040fe20000410000ULL,
0x0000004802487220ULL, 0x040fe20000410000ULL, 0x0000004902497220ULL, 0x040fe20000410000ULL,
0x0000004402447220ULL, 0x040fe20000410000ULL, 0x0000004502457220ULL, 0x040fe20000410000ULL,
0x0000004002407220ULL, 0x040fe20000410000ULL, 0x0000004102417220ULL, 0x040fe20000410000ULL,
0x0000003c023c7220ULL, 0x040fe20000410000ULL, 0x0000003d023d7220ULL, 0x040fe20000410000ULL,
0x0000003802387220ULL, 0x040fe20000410000ULL, 0x0000003902397220ULL, 0x040fe20000410000ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000001802187220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x000fe20000410000ULL,
0x0000004603467220ULL, 0x040fe20000410000ULL, 0x0000004703477220ULL, 0x040fe20000410000ULL,
0x0000004203427220ULL, 0x040fe20000410000ULL, 0x0000004303437220ULL, 0x040fe20000410000ULL,
0x0000003e033e7220ULL, 0x040fe20000410000ULL, 0x0000003f033f7220ULL, 0x040fe20000410000ULL,
0x0000003a033a7220ULL, 0x040fe20000410000ULL, 0x0000003b033b7220ULL, 0x040fe20000410000ULL,
0x0000003603367220ULL, 0x040fe20000410000ULL, 0x0000003703377220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x00000018190b723eULL, 0x000fc400000010ffULL,
0x0000001a1b13723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000004c4d04723eULL, 0x000fe400000010ffULL, 0x000000484905723eULL, 0x000fe400000010ffULL,
0x000000444506723eULL, 0x000fe400000010ffULL, 0x000000404107723eULL, 0x000fe400000010ffULL,
0x0000003c3d08723eULL, 0x000fc400000010ffULL, 0x000000383909723eULL, 0x000fe400000010ffULL,
0x00000034350a723eULL, 0x000fe400000010ffULL, 0x0000004e4f0c723eULL, 0x000fe400000010ffULL,
0x0000004a4b0d723eULL, 0x000fe400000010ffULL, 0x00000046470e723eULL, 0x000fe400000010ffULL,
0x00000002ff217819ULL, 0x004fc40000011600ULL, 0x0000000800317811ULL, 0x000fe400078ff0ffULL,
0x0000000721027812ULL, 0x040fe200078ec0ffULL, 0x0000000821147824ULL, 0x040fe200078e00ffULL,
0x00000021ff237212ULL, 0x000fe200078e33ffULL, 0x0000000821167824ULL, 0x000fe200078e00ffULL,
0x00000031ff337212ULL, 0x000fe200078e33ffULL, 0x0000000831187824ULL, 0x000fe200078e00ffULL,
0x0000000102037812ULL, 0x000fe400078e3cffULL, 0xfffffff814157812ULL, 0x000fc400078ee221ULL,
0xfffffff816237812ULL, 0x000fe400078ee223ULL, 0xfffffff818337812ULL, 0x000fe400078ee233ULL,
0x0000000202147812ULL, 0x040fe400078e3cffULL, 0x0000000302167812ULL, 0x040fe400078e3cffULL,
0x0000000402187812ULL, 0x040fe200078e3cffULL, 0x0000000821197824ULL, 0x040fe200078e0214ULL,
0x00000005021a7812ULL, 0x040fe200078e3cffULL, 0x00000008211b7824ULL, 0x040fe200078e0216ULL,
0x0000000602027812ULL, 0x000fe200078e3cffULL, 0x00000008211d7824ULL, 0x040fe200078e0218ULL,
0x0000000321177211ULL, 0x040fe200078e18ffULL, 0x00000008211f7824ULL, 0x000fe200078e021aULL,
0x0000000c63037819ULL, 0x000fe200000006ffULL, 0x0000000400147824ULL, 0x000fe200078e00ffULL,
0x0000000731167812ULL, 0x000fe200078ec0ffULL, 0x0000000821217824ULL, 0x000fe200078e0202ULL,
0x00000042430f723eULL, 0x000fe200000010ffULL, 0x0000080060027824ULL, 0x000fe200078e0203ULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x0000000831187824ULL, 0x000fe200078e00ffULL,
0x00000002161a7812ULL, 0x040fe200078e3cffULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x00000003161c7812ULL, 0x000fe200078e3cffULL, 0x0000001017177824ULL, 0x000fe200078e0202ULL,
0xfffffff818257812ULL, 0x000fe200078ee231ULL, 0x0000000115157824ULL, 0x000fe200078e0214ULL,
0x0000000116187812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x00000004161e7812ULL, 0x040fe200078e3cffULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0x0000000516207812ULL, 0x040fe200078e3cffULL, 0x0000000831277824ULL, 0x000fe200078e0218ULL,
0x0000000616167812ULL, 0x000fe200078e3cffULL, 0x0000000415007388ULL, 0x0005e20000000800ULL,
0x000000021d1d7211ULL, 0x000fe200078e20ffULL, 0x00000008312b7824ULL, 0x040fe200078e021cULL,
0x0000001a31297211ULL, 0x040fe200078e18ffULL, 0x00000008312d7824ULL, 0x000fe200078e021eULL,
0x0000000223237211ULL, 0x080fe200078e20ffULL, 0x00000008312f7824ULL, 0x000fe200078e0220ULL,
0x0000000229297211ULL, 0x000fe200078e20ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x0000003e3f10723eULL, 0x000fe200000010ffULL, 0x0000000831317824ULL, 0x000fe200078e0216ULL,
0x0000001714047210ULL, 0x044fe20007ffe0ffULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x0000003a3b11723eULL, 0x000fe200000010ffULL, 0x0000000114197824ULL, 0x040fe200078e0219ULL,
0x000000363712723eULL, 0x000fe200000010ffULL, 0x0000000114167824ULL, 0x000fe200078e021bULL,
0x0000000504007388ULL, 0x0005e20000000800ULL, 0x0000001025257824ULL, 0x000fc400078e0202ULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0x0000000619007388ULL, 0x000fe20000000800ULL,
0x00000001141d7824ULL, 0x040fe400078e021dULL, 0x0000000114187824ULL, 0x040fe200078e021fULL,
0x0000000716007388ULL, 0x000fe20000000800ULL, 0x0000000114217824ULL, 0x040fe200078e0221ULL,
0x00000027141c7210ULL, 0x040fe20007ffe0ffULL, 0x00000001141a7824ULL, 0x040fe200078e0223ULL,
0x000000081d007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x000000ff00047306ULL, 0x004fe20000205400ULL, 0x0000000114257824ULL, 0x000fe200078e0225ULL,
0x0000000918007388ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x000fc400078e0202ULL,
0x000000102f2f7824ULL, 0x100fe200078e0202ULL, 0x0000000a21007388ULL, 0x000fe20000000800ULL,
0x0000001031317824ULL, 0x100fe200078e0202ULL, 0x000000ff00057306ULL, 0x000ea20000209400ULL,
0x0000000114297824ULL, 0x040fe200078e0229ULL, 0x0000000b1a007388ULL, 0x000fe20000000800ULL,
0x0000001033337824ULL, 0x000fe400078e0202ULL, 0x00000001141e7824ULL, 0x040fe200078e022bULL,
0x0000000c25007388ULL, 0x000fe20000000800ULL, 0x00000001142d7824ULL, 0x000fc400078e022dULL,
0x0000000114207824ULL, 0x040fe200078e022fULL, 0x0000000d1c007388ULL, 0x000fe20000000800ULL,
0x0000000114317824ULL, 0x040fe400078e0231ULL, 0x0000000114227824ULL, 0x000fe200078e0233ULL,
0x0000000e29007388ULL, 0x000fe20000000800ULL, 0x0000000057147210ULL, 0x000fe40007ffe0ffULL,
0x000000040500720bULL, 0x004fe20003f1d000ULL, 0x0000000f1e007388ULL, 0x000fe20000000800ULL,
0x000000ff00047245ULL, 0x000fe2000020d400ULL, 0x0000001014157824ULL, 0x000fc400078e0203ULL,
0x000000102d007388ULL, 0x000fe80000000800ULL, 0x0000001120007388ULL, 0x000fe80000000800ULL,
0x0000001231007388ULL, 0x000fe20000000800ULL, 0x0000000104040812ULL, 0x000fc600078efcffULL,
0x0000001322007388ULL, 0x000fe20000000800ULL, 0x000000040405723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000015087984ULL, 0x000ea80000000c00ULL,
0x00040000150c7984ULL, 0x000ee80000000c00ULL, 0x0008000015187984ULL, 0x000f280000000c00ULL,
0x000c0000151c7984ULL, 0x000f620000000c00ULL, 0x3f803f80050b7831ULL, 0x004fc4000020000bULL,
0x3f803f80050a7831ULL, 0x040fe4000020000aULL, 0x3f803f8005097831ULL, 0x040fe40000200009ULL,
0x3f803f8005087831ULL, 0x040fe40000200008ULL, 0x3f803f80050f7831ULL, 0x048fe4000020000fULL,
0x3f803f80050e7831ULL, 0x040fe4000020000eULL, 0x3f803f80050d7831ULL, 0x000fc4000020000dULL,
0x3f803f80050c7831ULL, 0x000fe2000020000cULL, 0x00000001ff057424ULL, 0x000fe200078e00ffULL,
0x3f803f800b0b7831ULL, 0x010fe4000020001bULL, 0x3f803f800a0a7831ULL, 0x000fe4000020001aULL,
0x0000030005007a0cULL, 0x000fe20003f05270ULL, 0x3f803f8009097831ULL, 0x000fe40000200019ULL,
0x3f803f8008087831ULL, 0x000fe40000200018ULL, 0x3f803f800f0f7831ULL, 0x020fc4000020001fULL,
0x3f803f800e0e7831ULL, 0x000fe2000020001eULL, 0x0000000815007388ULL, 0x0005e20000000c00ULL,
0x3f803f800d0d7831ULL, 0x000fe4000020001dULL, 0x3f803f800c0c7831ULL, 0x000fca000020001cULL,
0x0004000c15007388ULL, 0x0005e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00002f6000008947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000ee20000002700ULL,
0x00005800ff067624ULL, 0x000fe200078e00ffULL, 0x0000000160ff7812ULL, 0x000fe2000780f866ULL,
0x00000800ff097424ULL, 0x004fe200078e00ffULL, 0x0000000000057919ULL, 0x000ee20000002600ULL,
0x0000030006067a24ULL, 0x000fe200078e02ffULL, 0x000000ff0000720cULL, 0x000fe20000725670ULL,
0x0000040063077824ULL, 0x000fe200078e00ffULL, 0x0000000015187984ULL, 0x0005220000000c00ULL,
0x00006400060a7a24ULL, 0x000fca00078e02ffULL, 0x000007ff0a067811ULL, 0x000fe200078e40ffULL,
0x0000580010107a24ULL, 0x008fc800078e0205ULL, 0x0000030010057a24ULL, 0x000fca00078e02ffULL,
0x00000005050b7c10ULL, 0x000fc8000fffe0ffULL, 0x0000000b06087211ULL, 0x000fca00078fa8ffULL,
0x00006a0008087625ULL, 0x000fca00078e0009ULL, 0x00000007080e7210ULL, 0x000fe40007f5e0ffULL,
0x01ffffff0a087812ULL, 0x000fe400078ec0ffULL, 0x00000009ff0f7210ULL, 0x000fca00017fe4ffULL,
0x00000010140e7825ULL, 0x000fe200078e000eULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x014fe20000011600ULL, 0x0000001000097824ULL, 0x000fe400078e00ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000c0a117812ULL, 0x000fe200078ec0ffULL,
0x000000010b0c7824ULL, 0x000fe200078e0208ULL, 0x0000007009097812ULL, 0x000fe200078ec0ffULL,
0x00006a000b0a7625ULL, 0x000fc800078e000dULL, 0x00006a000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000a110a7210ULL, 0x000fc80007a1e009ULL, 0x0000000c110c7210ULL, 0x000fe40007c7e009ULL,
0x0000000bff0b7210ULL, 0x000fe400007e44ffULL, 0x0000000dff0d7210ULL, 0x000fc60001fe84ffULL,
0x000000560a007986ULL, 0x0005e8000c101906ULL, 0x000000550c007986ULL, 0x0005e4000c101906ULL,
0x000000180e007986ULL, 0x0145e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x00000001ff097424ULL, 0x000fe400078e00ffULL, 0x00000004ff0b7424ULL, 0x000fc600078e00ffULL,
0x0000030009097a10ULL, 0x000fe20007ffe1ffULL, 0x00006800100a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000090a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x000000090a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0c7807ULL, 0x000fca0000000000ULL,
0x0000000cff007388ULL, 0x0007e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff097984ULL, 0x000f240000000000ULL,
0x000000ff0900720cULL, 0x010fda0003f05270ULL, 0x00002bb000008947ULL, 0x000fea0003800000ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x00000d6000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0a7819ULL, 0x000fe20000011600ULL, 0x00000080ff117424ULL, 0x000fe200078e00ffULL,
0x00000001050c7810ULL, 0x048fe40007ffe0ffULL, 0x0000000400097819ULL, 0x000fe400000006ffULL,
0x0000000c0a157812ULL, 0x000fe200078ec0ffULL, 0x00006a00050a7625ULL, 0x000fe200078e0011ULL,
0x0000007009137812ULL, 0x000fc600078ec0ffULL, 0x00006a000c0c7625ULL, 0x000fe200078e0011ULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000c150c7210ULL, 0x000fe40007b5e013ULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a097981ULL, 0x000768000c1e1900ULL, 0x000000060c0e7981ULL, 0x004762000c1e1900ULL,
0x00000300ff0f7624ULL, 0x000fca00078e00ffULL, 0x000000020f00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002050a7810ULL, 0x008fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0011ULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a107981ULL, 0x000562000c1e1900ULL,
0x000000040f00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003050a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0011ULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a127981ULL, 0x000562000c1e1900ULL, 0x000000040f00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004050a7810ULL, 0x004fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e0011ULL, 0x0000000a150a7210ULL, 0x000fc8000791e013ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a147981ULL, 0x000562000c1e1900ULL,
0x000000060f00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005050a7810ULL, 0x004fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0011ULL,
0x0000000a150a7210ULL, 0x000fc8000791e013ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a167981ULL, 0x000562000c1e1900ULL, 0x000000060f00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080f00780cULL, 0x004fe40003f06070ULL,
0x00000006050a7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e0011ULL,
0x0000000a150a7210ULL, 0x000fe40007a3e013ULL, 0x00000007050c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006a000c0c0625ULL, 0x000fe400078e0011ULL,
0x000000060a187981ULL, 0x000566000c1e1900ULL, 0x0000000c150c0210ULL, 0x000fc80007c7e013ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c0c0981ULL, 0x000568000c1e1900ULL,
0x0000030000047ab9ULL, 0x00cfe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0x000000ff00157202ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0005ULL,
0x000000ffff1a7224ULL, 0x020fe400078e0009ULL, 0x0000030013007a0cULL, 0x000fe40003f26070ULL,
0x0000000115157810ULL, 0x000fc80007ffe0ffULL, 0x0000000415007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x024fea0003800000ULL, 0x00000008130a7810ULL, 0x040fe40007ffe0ffULL,
0x00000001130b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001a09097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000080d0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000010000f7824ULL, 0x000fe400078e00ffULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c11117812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1a7981ULL, 0x000568000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009130a7810ULL, 0x044fe40007ffe0ffULL, 0x00000002130b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000000e09097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000090d0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000010000e7824ULL, 0x000fe400078e00ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c11117812ULL, 0x000fe400078ec0ffULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0e7981ULL, 0x000568000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a130a7810ULL, 0x044fe40007ffe0ffULL,
0x00000003130b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001009097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a0d0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000004000f7819ULL, 0x000fe400000006ffULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x000000700f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c10107812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a107981ULL, 0x000568000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b130a7810ULL, 0x044fe40007ffe0ffULL, 0x00000004130b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001209097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b0d0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000010000f7824ULL, 0x000fe400078e00ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c11117812ULL, 0x000fe400078ec0ffULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a127981ULL, 0x000568000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c130a7810ULL, 0x044fe40007ffe0ffULL,
0x00000005130b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001409097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c0d0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000010000f7824ULL, 0x000fe400078e00ffULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c11117812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a147981ULL, 0x000568000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d130a7810ULL, 0x044fe40007ffe0ffULL, 0x00000006130b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001609097209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d0d0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000004000f7819ULL, 0x000fe400000006ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x000000700f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c11117812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a167981ULL, 0x000568000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e130a7810ULL, 0x044fe40007ffe0ffULL,
0x00000007130b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001809097209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e0d0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000010000f7824ULL, 0x000fe400078e00ffULL, 0x00006a000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c11117812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a187981ULL, 0x000568000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f130a7810ULL, 0x004fe40007ffe0ffULL, 0x0000000c09097209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f0d0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000010000c7824ULL, 0x000fe400078e00ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c11117812ULL, 0x000fe400078ec0ffULL,
0x000000700c0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007a3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a0c7981ULL, 0x000568000c1e1900ULL,
0x0000000813137810ULL, 0x000fe40007ffe0ffULL, 0x000000080d0d7810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000010000a7824ULL, 0x00cfe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fc80000011600ULL,
0x000000700a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000b0a0a7210ULL, 0x000fca0007ffe0ffULL, 0x000000090a007388ULL, 0x0205e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000001000097824ULL, 0x004fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe20000011600ULL, 0x0000000160137824ULL, 0x040fe200078e0205ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011666ULL,
0x00000800ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000007009097812ULL, 0x000fe200078ec0ffULL,
0x0000200060277824ULL, 0x000fe200078e0203ULL, 0x0000000c0b0c7812ULL, 0x008fe200078ec0ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000013060a7211ULL, 0x000fe200078fa8ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000006360108211ULL, 0x000fe200078e08ffULL,
0x00000001092a7824ULL, 0x000fe200078e020cULL, 0x000000010d097812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e000fULL, 0x00000020000f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000200660c7824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000002600e8824ULL, 0x000fe200078e0263ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000210158824ULL, 0x100fe200078e0209ULL, 0x000008000c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000001308108210ULL, 0x000fe20007ffe0ffULL,
0x000000020e0d8824ULL, 0x000fe200078e0209ULL, 0x00000000151f8211ULL, 0x000fe200078e18ffULL,
0x00000080ff128424ULL, 0x000fe200078e00ffULL, 0x000000002a2a7984ULL, 0x000ea20000000800ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000030060007a0cULL, 0x000fe20003f26070ULL,
0x0000000127097824ULL, 0x000fe200078e020cULL, 0x000041801f1f8811ULL, 0x000fe200078e20ffULL,
0x00006a0010108625ULL, 0x000fe200078e0011ULL, 0x0000000000287805ULL, 0x000fc6000001ff00ULL,
0x00006a0013128625ULL, 0x000fc800078e0012ULL, 0x000000080d1d8824ULL, 0x000fe400078e0200ULL,
0x0000001000177824ULL, 0x040fe400078e0209ULL, 0x00000010000c7825ULL, 0x000fe200078e000aULL,
0x000045801d1d8811ULL, 0x000fc600078e20ffULL, 0x000000100f0e7825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c177faeULL, 0x0007e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000001000108825ULL, 0x040fe200078e0010ULL,
0x003800000e177faeULL, 0x0009e6000b901c46ULL, 0x0000001000148825ULL, 0x000fe200078e0012ULL,
0x00000000101d8faeULL, 0x000be2000b901c46ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00000000141f8faeULL, 0x0003e2000b901c46ULL,
0x00000000000c7805ULL, 0x008fe2000001ff00ULL, 0x000000ffff267224ULL, 0x000fe400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x020fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x002fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000d4000001947ULL, 0x000fea0003800000ULL, 0x000000ffff097224ULL, 0x004fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fca00078e0060ULL, 0x000000022d2c7810ULL, 0x000fc80007ffe0ffULL,
0x000003002c007a0cULL, 0x000fda0003f06070ULL, 0x0000026000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00000800ff347424ULL, 0x000fe200078e00ffULL,
0x0000002c05357210ULL, 0x000fe20007ffe0ffULL, 0x000004002c307824ULL, 0x000fe200078e00ffULL,
0x00000001ff2e7819ULL, 0x000fe4000001162cULL, 0x00000035062f7211ULL, 0x000fe400078fa8ffULL,
0x000000012e327812ULL, 0x000fe400078ec0ffULL, 0x00000020003b7810ULL, 0x000fe20007ffe0ffULL,
0x00006a002f2e7625ULL, 0x000fc400078e0034ULL, 0x0000008000349802ULL, 0x000fe40000000f00ULL,
0x0000000260399824ULL, 0x100fe200078e0263ULL, 0x000000072e2e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000260339824ULL, 0x000fe400078e0263ULL, 0x0000000239399824ULL, 0x100fe400078e0232ULL,
0x00000002333d9824ULL, 0x000fe200078e0232ULL, 0x0000080030327812ULL, 0x000fe200078ec0ffULL,
0x0000000108319824ULL, 0x000fc400078e0235ULL, 0x00000080ff369424ULL, 0x000fe400078e00ffULL,
0x00006a0031309625ULL, 0x000fc800078e0034ULL, 0x0000000127337824ULL, 0x000fe400078e0232ULL,
0x000000ffff2f7224ULL, 0x000fe400000e062fULL, 0x00006a0035349625ULL, 0x000fe200078e0036ULL,
0x0000003300377211ULL, 0x000fc600078e20ffULL, 0x0000000839399824ULL, 0x000fe400078e0200ULL,
0x0000001000329825ULL, 0x000fc600078e0030ULL, 0x0000458039399811ULL, 0x000fe200078e20ffULL,
0x000000083d3d9824ULL, 0x000fe400078e0200ULL, 0x000000103b307825ULL, 0x000fc600078e002eULL,
0x000041803d3b9811ULL, 0x000fe200078e20ffULL, 0x00000010002e7825ULL, 0x000fc800078e002eULL,
0x0000001000349825ULL, 0x000fe200078e0034ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800002e377faeULL, 0x0003e8000b901c46ULL, 0x0038000030377faeULL, 0x0003e8000b901c46ULL,
0x0000000032399faeULL, 0x0003e8000b901c46ULL, 0x00000000343b9faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff327224ULL, 0x002fe200078e002dULL,
0x00000004002e7819ULL, 0x000fe200000006ffULL, 0x0000000260307824ULL, 0x000fe200078e0263ULL,
0x00000001ff2f7819ULL, 0x000fe20000011600ULL, 0x00000040322d7824ULL, 0x000fe200078e00ffULL,
0x000000702e2e7812ULL, 0x000fc400078ec0ffULL, 0x0000000c2f2f7812ULL, 0x000fe400078ec0ffULL,
0x000000802d2d7812ULL, 0x000fe400078ec0ffULL, 0x00000002ff4d7819ULL, 0x000fc60000011600ULL,
0x00000100302d7824ULL, 0x000fe200078e002dULL, 0x000000074d3b7812ULL, 0x040fe200078ec0ffULL,
0x000000084d367824ULL, 0x040fe200078e00ffULL, 0x000000084d4f7810ULL, 0x040fe20007ffe0ffULL,
0x000000084d347824ULL, 0x000fe200078e00ffULL, 0x0000002d2f307210ULL, 0x000fe20007ffe02eULL,
0x000000084d2e7824ULL, 0x000fe200078e00ffULL, 0x0000004dff2d7212ULL, 0x000fe200078e33ffULL,
0x000000084f3d7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800030397984ULL, 0x000e620000000800ULL, 0x000000012e2f7812ULL, 0x140fe400078ef63bULL,
0x000000022e317812ULL, 0x140fe200078ef63bULL, 0x00458000304b7984ULL, 0x0002a20000000800ULL,
0x000000032e337812ULL, 0x140fe400078ef63bULL, 0x000000042e357812ULL, 0x140fe400078ef63bULL,
0x000000052e377812ULL, 0x000fe400078ef63bULL, 0xfffffff836477812ULL, 0x000fe200078ee22dULL,
0x0000000400367824ULL, 0x000fe200078e00ffULL, 0xfffffff8342d7812ULL, 0x000fc400078ee23bULL,
0x000000034f347819ULL, 0x040fe400000006ffULL, 0x0000004fff497212ULL, 0x000fe400078e33ffULL,
0x0000000c36367812ULL, 0x000fe400078ec0ffULL, 0xfffffff834497812ULL, 0x000fe200078ee249ULL,
0x000000392a307221ULL, 0x002fe20000010100ULL, 0x000000062e397812ULL, 0x000fe200078ef63bULL,
0x00000400322e7824ULL, 0x000fe200078e00ffULL, 0x000000074f327812ULL, 0x040fe200078ec0ffULL,
0x3fb8aa3b30307820ULL, 0x000fe20000410000ULL, 0x000000084f3b7824ULL, 0x000fc400078e00ffULL,
0x000008002e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000003000347308ULL, 0x0002a20000000800ULL,
0x000000013d3f7812ULL, 0x000fe400078ef632ULL, 0x00000180272e7810ULL, 0x000fe40007ffe02eULL,
0x000000023d417812ULL, 0x000fe400078ef632ULL, 0x0000002e2d2d7211ULL, 0x080fe200078e20ffULL,
0x000000102f2f7824ULL, 0x000fe200078e022eULL, 0x000000033d437812ULL, 0x000fe200078ef632ULL,
0x0000001047307824ULL, 0x002fe200078e022eULL, 0x000000043d457812ULL, 0x140fe200078ef632ULL,
0x00000001362d7824ULL, 0x040fe200078e022dULL, 0x000000053d477812ULL, 0x000fe200078ef632ULL,
0x0000000136307824ULL, 0x040fe200078e0230ULL, 0xfffffff83b3b7812ULL, 0x100fe200078ee232ULL,
0x00000001362f7824ULL, 0x000fe200078e022fULL, 0x000000063d3d7812ULL, 0x000fe200078ef632ULL,
0x0000001033337824ULL, 0x100fe200078e022eULL, 0x000000002d327984ULL, 0x000e620000000800ULL,
0x0000002e31317211ULL, 0x080fe200078e20ffULL, 0x0000004b34347220ULL, 0x004fe20000410000ULL,
0x0000000136337824ULL, 0x040fe200078e0233ULL, 0x0000000030307984ULL, 0x000fe20000000800ULL,
0x0000001035357824ULL, 0x100fe200078e022eULL, 0x0000002e39397211ULL, 0x080fe200078e20ffULL,
0x0000000136317824ULL, 0x040fe200078e0231ULL, 0x000000002f2f7984ULL, 0x000fe20000000800ULL,
0x0000000136357824ULL, 0x040fe200078e0235ULL, 0x0000002e43437211ULL, 0x080fe200078e20ffULL,
0x0000001037377824ULL, 0x100fe200078e022eULL, 0x00001f4d342d7589ULL, 0x000ea200000e0000ULL,
0x0000000136397824ULL, 0x040fe200078e0239ULL, 0x0000002e3d3d7211ULL, 0x000fe200078e20ffULL,
0x0000000136377824ULL, 0x040fe200078e0237ULL, 0x0000000031317984ULL, 0x000ee20000000800ULL,
0x000000103b3b7824ULL, 0x100fe200078e022eULL, 0x0000003d363d7210ULL, 0x040fe20007ffe0ffULL,
0x0000001041417824ULL, 0x100fe200078e022eULL, 0x0000000033337984ULL, 0x000f220000000800ULL,
0x00000001363b7824ULL, 0x000fe200078e023bULL, 0x0000002b342b7221ULL, 0x000fe20000010000ULL,
0x000000103f3f7824ULL, 0x000fe200078e022eULL, 0x0000000035357984ULL, 0x000f620000000800ULL,
0x0000000136417824ULL, 0x000fc400078e0241ULL, 0x0000001045457824ULL, 0x100fe200078e022eULL,
0x0000000037377984ULL, 0x000f620000000800ULL, 0x0000003f363f7210ULL, 0x040fe20007ffe0ffULL,
0x0000001047477824ULL, 0x000fe400078e022eULL, 0x0000000039397984ULL, 0x000f620000000800ULL,
0x0000000136457824ULL, 0x040fe400078e0245ULL, 0x0000000136437824ULL, 0x040fe200078e0243ULL,
0x000000003b3b7984ULL, 0x000f620000000800ULL, 0x0000000136477824ULL, 0x000fc400078e0247ULL,
0x0000001049497824ULL, 0x000fe200078e022eULL, 0x00007610ff4b7816ULL, 0x002fe20000000032ULL,
0x0000000041417984ULL, 0x000fe40000000800ULL, 0x0000000136497824ULL, 0x000fe400078e0249ULL,
0x0000002d4b287223ULL, 0x004fe20000010028ULL, 0x00005410ff4b7816ULL, 0x100fe20000000030ULL,
0x000000003f3f7984ULL, 0x000e620000000800ULL, 0x00007610ff307816ULL, 0x000fc60000000030ULL,
0x0000002d4b1a7223ULL, 0x080fe2000001001aULL, 0x00005410ff4b7816ULL, 0x000fe2000000002fULL,
0x0000002d30197223ULL, 0x080fe20000010019ULL, 0x00007610ff307816ULL, 0x000fe2000000002fULL,
0x0000000045457984ULL, 0x000fe20000000800ULL, 0x00005410ff2f7816ULL, 0x008fe20000000031ULL,
0x0000002d4b267223ULL, 0x080fe40000010026ULL, 0x0000002d30257223ULL, 0x080fe20000010025ULL,
0x00007610ff307816ULL, 0x000fe20000000031ULL, 0x0000002d2f247223ULL, 0x080fe20000010024ULL,
0x00005410ff2f7816ULL, 0x010fe20000000033ULL, 0x00001f4f342e7589ULL, 0x0004e400000e0000ULL,
0x0000002d30237223ULL, 0x080fe20000010023ULL, 0x00007610ff307816ULL, 0x000fe20000000033ULL,
0x0000000043437984ULL, 0x000f220000000800ULL, 0x0000002d2f227223ULL, 0x000fe20000010022ULL,
0x00005410ff2f7816ULL, 0x020fc40000000035ULL, 0x0000000047477984ULL, 0x000f620000000800ULL,
0x0000002d30217223ULL, 0x080fe20000010021ULL, 0x00007610ff307816ULL, 0x000fe20000000035ULL,
0x0000002d2f207223ULL, 0x080fe20000010020ULL, 0x0000000049497984ULL, 0x000f620000000800ULL,
0x00005410ff2f7816ULL, 0x000fe40000000037ULL, 0x0000002d301f7223ULL, 0x080fe2000001001fULL,
0x00007610ff307816ULL, 0x000fe20000000037ULL, 0x000000003d3d7984ULL, 0x000f620000000800ULL,
0x0000002d2f1e7223ULL, 0x000fe2000001001eULL, 0x00005410ff347816ULL, 0x004fc40000000032ULL,
0x0000002d301d7223ULL, 0x080fe2000001001dULL, 0x00005410ff2f7816ULL, 0x100fe40000000039ULL,
0x00007610ff307816ULL, 0x000fe20000000039ULL, 0x0000002d34297223ULL, 0x080fe40000010029ULL,
0x0000002d2f1c7223ULL, 0x080fe4000001001cULL, 0x0000002d301b7223ULL, 0x000fe2000001001bULL,
0x00005410ff2d7816ULL, 0x000fe4000000003bULL, 0x00005410ff307816ULL, 0x002fc4000000003fULL,
0x00007610ff3b7816ULL, 0x000fe2000000003bULL, 0x0000002e2d0a7223ULL, 0x088fe2000001000aULL,
0x00005410ff2d7816ULL, 0x000fe20000000041ULL, 0x0000002e30117223ULL, 0x080fe20000010011ULL,
0x00007610ff307816ULL, 0x000fe2000000003fULL, 0x0000002e3b187223ULL, 0x080fe20000010018ULL,
0x00007610ff417816ULL, 0x000fe20000000041ULL, 0x0000002e2d107223ULL, 0x080fe20000010010ULL,
0x00005410ff2d7816ULL, 0x000fe20000000045ULL, 0x0000002e30177223ULL, 0x080fe20000010017ULL,
0x00005410ff307816ULL, 0x010fe20000000043ULL, 0x0000002e41167223ULL, 0x080fe20000010016ULL,
0x00007610ff457816ULL, 0x000fe20000000045ULL, 0x0000002e2d0e7223ULL, 0x080fe2000001000eULL,
0x000000ffff2d7224ULL, 0x000fe200078e002cULL, 0x00007610ff2c7816ULL, 0x020fe20000000047ULL,
0x0000002e300f7223ULL, 0x080fe2000001000fULL, 0x00007610ff307816ULL, 0x000fe20000000043ULL,
0x0000002e45147223ULL, 0x080fe20000010014ULL, 0x000003002d007a0cULL, 0x000fe20003f06070ULL,
0x0000002e2c137223ULL, 0x080fe20000010013ULL, 0x00005410ff2c7816ULL, 0x000fe20000000049ULL,
0x0000002e30157223ULL, 0x000fe20000010015ULL, 0x00005410ff2f7816ULL, 0x000fc4000000003dULL,
0x00005410ff307816ULL, 0x000fe20000000047ULL, 0x0000002e2c0b7223ULL, 0x080fe2000001000bULL,
0x00007610ff3d7816ULL, 0x000fe2000000003dULL, 0x0000002e2f0c7223ULL, 0x080fe2000001000cULL,
0x00007610ff2c7816ULL, 0x000fe20000000049ULL, 0x0000002e300d7223ULL, 0x080fe4000001000dULL,
0x0000002e3d127223ULL, 0x080fe40000010012ULL, 0x0000002e2c097223ULL, 0x000fe20000010009ULL,
0xfffff2e000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x004e620000000000ULL,
0x000000ff6300720cULL, 0x000fe20003f05270ULL, 0x0000001000057824ULL, 0x002fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fc80000011600ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x0000000105067824ULL, 0x000fe200078e0200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000000400057819ULL, 0x002fe400000006ffULL, 0x00000001ff007819ULL, 0x000fe40000011600ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c00077812ULL, 0x000fc600078ec0ffULL,
0x0000008060007824ULL, 0x000fc800078e0205ULL, 0x0000000107007824ULL, 0x000fca00078e0200ULL,
0x0049802b00007388ULL, 0x0003e40000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000013000007945ULL, 0x000fe20003800000ULL, 0x0049800006007984ULL, 0x002e680000000800ULL,
0x004a000006057984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000057810ULL, 0x000fc80007ffe0ffULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff557224ULL, 0x000fe200078e0000ULL, 0x00009d7000067802ULL, 0x000fe40000000f00ULL,
0x000072f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000067423ULL, 0x002fc80000000005ULL, 0x800000ff06067221ULL, 0x000fc80000010100ULL,
0x0000000605057223ULL, 0x000fe40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008002c7811ULL, 0x004fe400078ff0ffULL, 0x00000002ff2a7819ULL, 0x000fe40000011600ULL,
0x0000002cff2d7212ULL, 0x000fe200078e33ffULL, 0x00001f2c05077589ULL, 0x000ea200000e0000ULL,
0x0000002aff277212ULL, 0x000fe200078e33ffULL, 0x000000082c307824ULL, 0x000fe200078e00ffULL,
0x000000032a2e7819ULL, 0x000fe200000006ffULL, 0x00001f2a05067589ULL, 0x000ee600000e0000ULL,
0xfffffff82e2b7812ULL, 0x000fc400078ee227ULL, 0xfffffff830397812ULL, 0x000fc600078ee22dULL,
0x000000102b2b7824ULL, 0x000fe200078e0202ULL, 0x0000000239397211ULL, 0x000fe200078e20ffULL,
0x0000001507087220ULL, 0x044fe20000410000ULL, 0x0000001407157220ULL, 0x040fe20000410000ULL,
0x0000001307147220ULL, 0x040fe20000410000ULL, 0x0000001107117220ULL, 0x040fe20000410000ULL,
0x0000002906297220ULL, 0x048fe20000410000ULL, 0x0000002806287220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002506257220ULL, 0x040fe20000410000ULL,
0x0000002406247220ULL, 0x040fe20000410000ULL, 0x0000002306237220ULL, 0x040fe20000410000ULL,
0x0000002206227220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000001f061f7220ULL, 0x040fe20000410000ULL,
0x0000001e061e7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000001a061a7220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x000fe20000410000ULL,
0x0000001707067220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000001607177220ULL, 0x040fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000000e070e7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000001207137220ULL, 0x040fe20000410000ULL, 0x0000000907127220ULL, 0x040fe20000410000ULL,
0x0000000a070a7220ULL, 0x040fe20000410000ULL, 0x0000001807057220ULL, 0x040fe20000410000ULL,
0x000000072a097812ULL, 0x000fe200078ec0ffULL, 0x0000000d070d7220ULL, 0x040fe20000410000ULL,
0x000000110606723eULL, 0x000fe200000010ffULL, 0x0000000b070b7220ULL, 0x000fe20000410000ULL,
0x000000101710723eULL, 0x000fe200000010ffULL, 0x000000082a077824ULL, 0x000fe200078e00ffULL,
0x0000000f0808723eULL, 0x000fc400000010ffULL, 0x0000000e150e723eULL, 0x000fe400000010ffULL,
0x0000000c130c723eULL, 0x000fe400000010ffULL, 0x00000001090f7812ULL, 0x040fe400078e3cffULL,
0x0000000209117812ULL, 0x040fe400078e3cffULL, 0x0000000309137812ULL, 0x040fe200078e3cffULL,
0x000000082a0f7824ULL, 0x000fe200078e020fULL, 0x0000000409157812ULL, 0x000fc400078e3cffULL,
0x0000000509177812ULL, 0x000fe200078e3cffULL, 0x000000082a137824ULL, 0x040fe200078e0213ULL,
0x0000000a0505723eULL, 0x000fe200000010ffULL, 0x000000082a157824ULL, 0x040fe200078e0215ULL,
0x0000000609097812ULL, 0x000fe200078e3cffULL, 0x000000082a177824ULL, 0x000fe200078e0217ULL,
0x000000072c0a7812ULL, 0x000fe200078ec0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0202ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x000000082c297824ULL, 0x000fe200078e00ffULL,
0x000000030a317812ULL, 0x000fe200078e3cffULL, 0x000000082a277824ULL, 0x000fe200078e0209ULL,
0xfffffff807077812ULL, 0x000fe200078ee22aULL, 0x0000001013137824ULL, 0x100fe200078e0202ULL,
0x0000000200097819ULL, 0x000fe200000006ffULL, 0x000000082c317824ULL, 0x000fe200078e0231ULL,
0x000000010a2d7812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x000000020a2f7812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x000000040a337812ULL, 0x000fe200078e3cffULL, 0x000000082c2d7824ULL, 0x000fe200078e022dULL,
0x000000050a357812ULL, 0x000fe200078e3cffULL, 0x000000082c2f7824ULL, 0x000fe200078e022fULL,
0x000000060a377812ULL, 0x000fe200078e3cffULL, 0x000000082c337824ULL, 0x000fe200078e0233ULL,
0x000000112a117211ULL, 0x000fe200078e18ffULL, 0x0000001027277824ULL, 0x000fe200078e0202ULL,
0xfffffff829297812ULL, 0x000fe200078ee22cULL, 0x000000082c377824ULL, 0x040fe200078e0237ULL,
0x000000352c357211ULL, 0x000fe200078e18ffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x0000000c090a7812ULL, 0x000fe200078ec0ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000000215157211ULL, 0x080fe200078e20ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0202ULL,
0x0000000231317211ULL, 0x000fe200078e20ffULL, 0x0000000107077824ULL, 0x000fe200078e020aULL,
0x000000262525723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0202ULL,
0x0000000b120b723eULL, 0x000fe200000010ffULL, 0x0000001033337824ULL, 0x100fe200078e0202ULL,
0x000000242323723eULL, 0x000fe200000010ffULL, 0x0000001035357824ULL, 0x100fe200078e0202ULL,
0x0000000d140d723eULL, 0x000fe200000010ffULL, 0x0000001037377824ULL, 0x000fe200078e0202ULL,
0x000000222121723eULL, 0x000fe200000010ffULL, 0x000000010a027824ULL, 0x040fe200078e020fULL,
0x000000201f1f723eULL, 0x000fe200000010ffULL, 0x000000010a127824ULL, 0x040fe200078e0211ULL,
0x000000150a167210ULL, 0x040fe20007ffe0ffULL, 0x000000010a147824ULL, 0x040fe200078e0213ULL,
0x0000001e1d1d723eULL, 0x000fe200000010ffULL, 0x0000002807007388ULL, 0x000fe20000000800ULL,
0x0000001a1919723eULL, 0x000fe200000010ffULL, 0x000000010a187824ULL, 0x040fe200078e0217ULL,
0x0000001c1b1b723eULL, 0x000fe200000010ffULL, 0x000000010a1a7824ULL, 0x040fe200078e0227ULL,
0x0000002502007388ULL, 0x0005e20000000800ULL, 0x000000010a1c7824ULL, 0x040fe200078e022bULL,
0x000000290a1e7210ULL, 0x040fe20007ffe0ffULL, 0x000000010a2d7824ULL, 0x040fe200078e022dULL,
0x0000002312007388ULL, 0x000fe20000000800ULL, 0x000000010a2f7824ULL, 0x040fe200078e022fULL,
0x000000310a317210ULL, 0x040fe20007ffe0ffULL, 0x000000010a337824ULL, 0x040fe200078e0233ULL,
0x0000002114007388ULL, 0x000fe20000000800ULL, 0x000000010a207824ULL, 0x000fc400078e0235ULL,
0x000000010a377824ULL, 0x040fe200078e0237ULL, 0x0000001f16007388ULL, 0x000fe20000000800ULL,
0x000000010a227824ULL, 0x000fe400078e0239ULL, 0x00000001570a7824ULL, 0x000fe200078e0200ULL,
0x0000001d18007388ULL, 0x000fe80000000800ULL, 0x0000001b1a007388ULL, 0x000fe20000000800ULL,
0x000000030a027211ULL, 0x004fc400078e20ffULL, 0x00000004040a723eULL, 0x000fe200000010ffULL,
0x000000191c007388ULL, 0x000fe80000000800ULL, 0x000000051e007388ULL, 0x000fe80000000800ULL,
0x000000062d007388ULL, 0x000fe80000000800ULL, 0x000000102f007388ULL, 0x000fe80000000800ULL,
0x0000000831007388ULL, 0x000fe80000000800ULL, 0x0000000e33007388ULL, 0x000fe80000000800ULL,
0x0000000d20007388ULL, 0x000fe80000000800ULL, 0x0000000c37007388ULL, 0x000fe80000000800ULL,
0x0000000b22007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000002147984ULL, 0x000ea80000000c00ULL, 0x00040000021c7984ULL, 0x000ee80000000c00ULL,
0x0008000002187984ULL, 0x000f280000000c00ULL, 0x000c000002107984ULL, 0x000f620000000c00ULL,
0x3f803f800a177831ULL, 0x004fc40000200017ULL, 0x3f803f800a167831ULL, 0x040fe40000200016ULL,
0x3f803f800a157831ULL, 0x040fe40000200015ULL, 0x3f803f800a147831ULL, 0x040fe40000200014ULL,
0x3f803f800a1f7831ULL, 0x048fe4000020001fULL, 0x3f803f800a1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800a1d7831ULL, 0x000fc4000020001dULL, 0x3f803f800a1c7831ULL, 0x000fe4000020001cULL,
0x3f803f8017177831ULL, 0x010fe4000020001bULL, 0x3f803f8016167831ULL, 0x000fe4000020001aULL,
0x3f803f8015157831ULL, 0x000fe40000200019ULL, 0x3f803f8014147831ULL, 0x000fe40000200018ULL,
0x3f803f801f1f7831ULL, 0x020fc40000200013ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200012ULL,
0x0000001402007388ULL, 0x0005e20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200011ULL,
0x3f803f801c1c7831ULL, 0x000fca0000200010ULL, 0x0004001c02007388ULL, 0x0005e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff6000720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000137810ULL, 0x000fe20007ffe0ffULL,
0x0000000000057919ULL, 0x000f220000002600ULL, 0x00000003ff077819ULL, 0x100fe20000011600ULL,
0x00000000000579c3ULL, 0x000f620000002700ULL, 0x00000003ff047819ULL, 0x100fe20000011613ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000707097812ULL, 0x104fe200078e4800ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000704027812ULL, 0x000fe200078e4813ULL,
0x0000000863127824ULL, 0x000fe200078e00ffULL, 0x0ffffff809087812ULL, 0x000fc400078ef800ULL,
0x0ffffff802067812ULL, 0x000fe400078ef813ULL, 0x0000000363117819ULL, 0x000fe200000006ffULL,
0x0000001008027824ULL, 0x100fe400078e0203ULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0xfffffff811117812ULL, 0x000fe400078ee200ULL, 0x0000000002087984ULL, 0x0004680000000c00ULL,
0x00000000060c7984ULL, 0x0086620000000c00ULL, 0x0000000805107824ULL, 0x010fc400078e00ffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x020fe4000f8e023fULL,
0xfffffff810037812ULL, 0x000fe400078ee207ULL, 0xfffffff805047812ULL, 0x000fe400078ee204ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404057c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff812077812ULL, 0x000fe200078ee213ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x004fe200078040ffULL, 0x000000ffff067224ULL, 0x008fe200008e06ffULL,
0x00005a0005047a11ULL, 0x000fc400078240ffULL, 0x00005b0003037a11ULL, 0x000fe400000f4410ULL,
0x00005b0005057a11ULL, 0x000fc600008f4406ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000000c04007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000167057810ULL, 0x008fe20007ffe0ffULL,
0x0000000261037824ULL, 0x000fe200078e00ffULL, 0x0000000666027819ULL, 0x000fe200000006ffULL,
0x01360000ff067f8cULL, 0x000e62000c80043fULL, 0x000000640500720cULL, 0x000fe20003f06070ULL,
0x0000580003037a24ULL, 0x000fc400078e0210ULL, 0x00000100670c7824ULL, 0x000fc800078e0202ULL,
0x0000620003297a24ULL, 0x000fcc00078e020cULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x000fe40000011600ULL, 0x000000300e1f7812ULL, 0x000fe400078ec0ffULL,
0x000000081a127810ULL, 0x040fe20007ffe0ffULL, 0x0000000129097824ULL, 0x040fe200078e021aULL,
0x000000181a1e7810ULL, 0x040fe40007ffe0ffULL, 0x000000201a167810ULL, 0x000fe20007ffe0ffULL,
0x00000001290b7824ULL, 0x040fe200078e0212ULL, 0x0000001e290f7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0004ULL, 0x0000000c65057217ULL, 0x000fc40007800000ULL,
0x000000101a1c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e000b0a7625ULL, 0x080fe200078e0004ULL,
0x0000001f08107210ULL, 0x080fe40007f1e0ffULL, 0x00000003ff177819ULL, 0x100fe20000011600ULL,
0x00005e000f0e7625ULL, 0x080fe200078e0004ULL, 0x0000001f0a0a7210ULL, 0x080fe40007f3e0ffULL,
0x0000000317177812ULL, 0x000fe200078e4800ULL, 0x000000ffff117224ULL, 0x000fe200000e0609ULL,
0x000000281a187810ULL, 0x000fe20007ffe0ffULL, 0x0000000129097824ULL, 0x000fe200078e0216ULL,
0x0000100066197811ULL, 0x000fe200078e68ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001f0e0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a0cULL,
0x0ffffffc17007812ULL, 0x000fe200078ef800ULL, 0x00005e0009087625ULL, 0x000fc600078e0004ULL,
0x000000051c00720cULL, 0x080fe20003fa6070ULL, 0x00000001290d7824ULL, 0x000fe200078e021cULL,
0x000000051e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000051200720cULL, 0x040fe20003f26070ULL, 0x0000000412147824ULL, 0x000fe200078e00ffULL,
0x0000001f08127210ULL, 0x000fe20007f5e0ffULL, 0x00005e000d0c7625ULL, 0x080fe200078e0004ULL,
0x000000051600720cULL, 0x000fe40003f66070ULL, 0xfffffffc14087812ULL, 0x000fe200078ee217ULL,
0x000000ffff137224ULL, 0x000fe200010e0609ULL, 0x0000001f0c0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000129097824ULL, 0x000fe200078e0218ULL, 0x00000019081d7211ULL, 0x000fe200078e20ffULL,
0x00000010001b7824ULL, 0x000fe200078e0219ULL, 0x0000000dff0d7210ULL, 0x000fe200007fe4ffULL,
0x00005e0009087625ULL, 0x000fe200078e0004ULL, 0x000000051a00720cULL, 0x000fc40003f06070ULL,
0x000000301a007810ULL, 0x000fe20007ffe0ffULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x0000001f08147210ULL, 0x000fe40007fde0ffULL, 0x000000381a1a7810ULL, 0x000fe40007ffe0ffULL,
0x000000051800720cULL, 0x080fe20003f46070ULL, 0x000000ffff157224ULL, 0x000fe400030e0609ULL,
0x0000000129097824ULL, 0x000fe400078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101b7faeULL, 0x0005e2000c101c46ULL, 0x000000051a00720cULL, 0x000fe20003f06070ULL,
0x00005e0009087625ULL, 0x000fc400078e0004ULL, 0x000000000a1d7faeULL, 0x0007e2000c901c46ULL,
0x000000050000720cULL, 0x000fe20003f26070ULL, 0x0000000129057824ULL, 0x000fe200078e021aULL,
0x0000001f08087210ULL, 0x000fe40007fde0ffULL, 0x000000021a1a7819ULL, 0x000fe200000006ffULL,
0x00005e0005047625ULL, 0x000fe200078e0004ULL, 0x0000000216107819ULL, 0x004fc600000006ffULL,
0x0000000418167824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a1a7812ULL, 0x100fe200078ee217ULL,
0x000000041e0a7824ULL, 0x008fe200078e00ffULL, 0xfffffffc10107812ULL, 0x100fe200078ee217ULL,
0x0000000400187824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c007812ULL, 0x000fe200078ee217ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee217ULL,
0xfffffffc16167812ULL, 0x000fe200078ee217ULL, 0x00000010000b7824ULL, 0x000fe200078e0219ULL,
0xfffffffc18187812ULL, 0x000fe200078ee217ULL, 0x000000100a117824ULL, 0x100fe200078e0219ULL,
0x0000001f04047210ULL, 0x000fe20007fde0ffULL, 0x0000001010177824ULL, 0x100fe200078e0219ULL,
0x00000019161b7211ULL, 0x000fe200078e20ffULL, 0x00000010181d7824ULL, 0x100fe200078e0219ULL,
0x000000000c0b7faeULL, 0x0005e2000e901c46ULL, 0x000000101a197824ULL, 0x000fc400078e0219ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x000000000e117faeULL, 0x0005e8000e101c46ULL,
0x0000000012177faeULL, 0x0005e8000d901c46ULL, 0x00000000141b7faeULL, 0x0005e8000d101c46ULL,
0x00000000081d7faeULL, 0x0005e8000c901c46ULL, 0x0000000004197faeULL, 0x0005e2000c101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x000fe40000011600ULL,
0x0000000800107811ULL, 0x000fc400078ff0ffULL, 0x0000001800087811ULL, 0x040fe400078ff0ffULL,
0x0000002900097211ULL, 0x040fe400078ff0ffULL, 0x0000001000127811ULL, 0x040fe200078ff0ffULL,
0x00000001290d7824ULL, 0x000fe200078e0208ULL, 0x00000028000c7811ULL, 0x000fe200078ff0ffULL,
0x0000000408167824ULL, 0x000fe200078e00ffULL, 0x0000000305117812ULL, 0x000fe200078e4800ULL,
0x0000000129057824ULL, 0x000fe200078e0210ULL, 0x00000020000a7811ULL, 0x040fe200078ff0ffULL,
0x00005e0009087625ULL, 0x000fe200078e0004ULL, 0x00000038000f7811ULL, 0x000fc400078ff0ffULL,
0x000000300e2d7812ULL, 0x000fe200078ec0ffULL, 0x00000001290b7824ULL, 0x040fe200078e0212ULL,
0x0000000210107819ULL, 0x000fe200000006ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x00000030000e7811ULL, 0x000fe200078ff0ffULL, 0x0000000129217824ULL, 0x040fe200078e020cULL,
0x0000000a291d7210ULL, 0x000fe20007ffe0ffULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc11147812ULL, 0x000fe200078ef800ULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc10007812ULL, 0x000fe200078ee211ULL, 0x000000040f1a7824ULL, 0x000fe200078e00ffULL,
0x000000020e187819ULL, 0x000fe200000006ffULL, 0x0000000129257824ULL, 0x040fe200078e020eULL,
0x0000002d08107210ULL, 0x000fe20007f1e0ffULL, 0x0000000129297824ULL, 0x000fe200078e020fULL,
0xfffffffc120e7812ULL, 0x000fc400078ee211ULL, 0xfffffffc160f7812ULL, 0x100fe400078ee211ULL,
0xfffffffc0a127812ULL, 0x100fe200078ee211ULL, 0x00005e000b0a7625ULL, 0x080fe200078e0004ULL,
0xfffffffc0c137812ULL, 0x100fe400078ee211ULL, 0xfffffffc18157812ULL, 0x100fe200078ee211ULL,
0x00005e000d0c7625ULL, 0x000fe200078e0004ULL, 0xfffffffc1a167812ULL, 0x000fe400078ee211ULL,
0x00001000662b7811ULL, 0x000fe200078e68ffULL, 0x000000ffff117224ULL, 0x000fc400000e0609ULL,
0x00005e0005087625ULL, 0x000fe200078e0004ULL, 0x0000002b15277211ULL, 0x080fe400078e20ffULL,
0x0000002b00177211ULL, 0x000fe200078e20ffULL, 0x00000010121f7824ULL, 0x100fe200078e022bULL,
0x0000002d08127210ULL, 0x080fe20007f1e0ffULL, 0x00000010142f7824ULL, 0x100fe200078e022bULL,
0x0000002d0a147210ULL, 0x080fe20007f3e0ffULL, 0x0000001013237824ULL, 0x000fe400078e022bULL,
0x000000ffff137224ULL, 0x000fe200000e0609ULL, 0x0000002d0c0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e060bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102f7faeULL, 0x0005e2000b901c46ULL, 0x000000100e197824ULL, 0x000fc400078e022bULL,
0x000000100f1b7824ULL, 0x000fe200078e022bULL, 0x0000000012177faeULL, 0x0005e2000b901c46ULL,
0x00005e001d087625ULL, 0x000fc600078e0004ULL, 0x0000000014197faeULL, 0x0005e2000b901c46ULL,
0x00005e00210a7625ULL, 0x000fc800078e0004ULL, 0x00005e00250e7625ULL, 0x000fe200078e0004ULL,
0x0000002d0a0a7210ULL, 0x000fc60007f3e0ffULL, 0x00005e0029047625ULL, 0x000fe200078e0004ULL,
0x0000002d0e0e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000002d08087210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000002d04047210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x00000009ff097210ULL, 0x000fe200007fe4ffULL, 0x00000010162b7824ULL, 0x000fe200078e022bULL,
0x000000000c1b7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fc600018e0605ULL,
0x00000000081f7faeULL, 0x0005e8000b901c46ULL, 0x000000000a237faeULL, 0x0005e8000b901c46ULL,
0x000000000e277faeULL, 0x0005e8000b901c46ULL, 0x00000000042b7faeULL, 0x0005e4000b901c46ULL,
0x01360400ff057984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000005ff7812ULL, 0x006fc60007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x01360400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000646700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x00013688665d7811ULL, 0x000fe400078e18ffULL, 0xffffffff645c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000566047819ULL, 0x000fe400000006ffULL, 0x0000010067067824ULL, 0x008fe200078e0202ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000066500720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x014fea0003800000ULL, 0x0000000167057810ULL, 0x000fe20007ffe0ffULL,
0x0000620003697a24ULL, 0x000fc600078e0206ULL, 0x000000640500720cULL, 0x000fe20003f06070ULL,
0x00000100ff057424ULL, 0x000fd800078e00ffULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0e7819ULL, 0x002fe20000011600ULL, 0x00000001650a7824ULL, 0x000fe200078e0a06ULL,
0x00000003ff0b7819ULL, 0x000fe40000011600ULL, 0x000000080e0d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010e087824ULL, 0x000fe200078e0269ULL, 0x000000000b077212ULL, 0x000fe400078e3cffULL,
0x000000690d0c7210ULL, 0x040fe20007ffe0ffULL, 0x000000040d107824ULL, 0x000fe200078e00ffULL,
0x00000003006c7812ULL, 0x000fe200078ec0ffULL, 0x00005e0008087625ULL, 0x000fe200078e0005ULL,
0x0000000307077812ULL, 0x000fc400078ec0ffULL, 0x0000000a0e00720cULL, 0x080fe40003f26070ULL,
0x0000000a0d00720cULL, 0x000fe20003f46070ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0005ULL,
0x000000046c177812ULL, 0x000fe400078efcffULL, 0x0000200066197811ULL, 0x000fe400078e68ffULL,
0x0ffffffc076a7812ULL, 0x000fe200078ef800ULL, 0x0000001017087825ULL, 0x000fe200078e0008ULL,
0xfffffffc10107812ULL, 0x000fc400078ee207ULL, 0x000000100e167810ULL, 0x000fe20007ffe0ffULL,
0x000000106a0f7824ULL, 0x100fe200078e0219ULL, 0x000000180e187810ULL, 0x000fe20007ffe0ffULL,
0x0000001010117824ULL, 0x000fe200078e0219ULL, 0x000000200e1a7810ULL, 0x040fe20007ffe0ffULL,
0x00000010170c7825ULL, 0x000fe200078e000cULL, 0x000000280e1b7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c901c46ULL,
0x000000300e1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000380e1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000000c117faeULL, 0x0005e2000d101c46ULL, 0x0000000a1600720cULL, 0x080fe20003f26070ULL,
0x000000011a0e7824ULL, 0x100fe200078e0269ULL, 0x0000000a1800720cULL, 0x080fe20003f46070ULL,
0x000000011b107824ULL, 0x140fe200078e0269ULL, 0x0000000a1a00720cULL, 0x080fe20003f66070ULL,
0x000000011c127824ULL, 0x100fe200078e0269ULL, 0x0000000a1b00720cULL, 0x080fe20003f86070ULL,
0x0000000116087824ULL, 0x102fe200078e0269ULL, 0x0000000a1c00720cULL, 0x080fe20003fa6070ULL,
0x000000011d147824ULL, 0x040fe200078e0269ULL, 0x0000000a1d00720cULL, 0x000fe20003fc6070ULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x00000069180c7210ULL, 0x004fc40007ffe0ffULL,
0x00000002160a7819ULL, 0x000fe200000006ffULL, 0x0000000418167824ULL, 0x000fe200078e00ffULL,
0x000000021d1e7819ULL, 0x000fe200000006ffULL, 0x000000041a187824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee207ULL, 0x00005e000c0c7625ULL, 0x080fe200078e0005ULL,
0xfffffffc16167812ULL, 0x100fe400078ee207ULL, 0xfffffffc18187812ULL, 0x100fe200078ee207ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0005ULL, 0xfffffffc1e1e7812ULL, 0x000fc600078ee207ULL,
0x00005e0010107625ULL, 0x000fc800078e0005ULL, 0x00005e0012127625ULL, 0x000fc800078e0005ULL,
0x00005e0014147625ULL, 0x000fc800078e0005ULL, 0x000000041b1a7824ULL, 0x000fe400078e00ffULL,
0x000000041c1c7824ULL, 0x000fe400078e00ffULL, 0x0000001017087825ULL, 0x040fe200078e0008ULL,
0xfffffffc1a1a7812ULL, 0x100fe400078ee207ULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee207ULL,
0x00000010170c7825ULL, 0x000fc600078e000cULL, 0x000000191c217211ULL, 0x000fe200078e20ffULL,
0x00000010170e7825ULL, 0x000fc800078e000eULL, 0x0000001017107825ULL, 0x000fc800078e0010ULL,
0x0000001017127825ULL, 0x000fc800078e0012ULL, 0x0000001017147825ULL, 0x000fc800078e0014ULL,
0x000000100a177824ULL, 0x100fe400078e0219ULL, 0x00000010161b7824ULL, 0x100fe400078e0219ULL,
0x00000010181d7824ULL, 0x100fe200078e0219ULL, 0x0000000008177faeULL, 0x0003e2000c901c46ULL,
0x000000101a1f7824ULL, 0x100fe400078e0219ULL, 0x000000101e197824ULL, 0x000fe200078e0219ULL,
0x000000000c1b7faeULL, 0x0003e8000d101c46ULL, 0x000000000e1d7faeULL, 0x0003e8000d901c46ULL,
0x00000000101f7faeULL, 0x0003e8000e101c46ULL, 0x0000000012217faeULL, 0x0003e8000e901c46ULL,
0x0000000014197faeULL, 0x0003e2000f101c46ULL, 0x0000047000007947ULL, 0x000fea0003800000ULL,
0x00000008000a7811ULL, 0x042fe400078ff0ffULL, 0x00000010001a7811ULL, 0x000fc400078ff0ffULL,
0x00000018001c7811ULL, 0x000fe200078ff0ffULL, 0x000000010a0c7824ULL, 0x100fe200078e0269ULL,
0x00000020001e7811ULL, 0x000fe200078ff0ffULL, 0x000000011a0e7824ULL, 0x100fe200078e0269ULL,
0x0000002800207811ULL, 0x000fe200078ff0ffULL, 0x000000011c107824ULL, 0x100fe200078e0269ULL,
0x0000003000227811ULL, 0x000fe200078ff0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0005ULL,
0x0000003800247811ULL, 0x040fe400078ff0ffULL, 0x0000006900087211ULL, 0x080fe200078ff0ffULL,
0x0000000120147824ULL, 0x100fe200078e0269ULL, 0x000000691e127210ULL, 0x000fe20007ffe0ffULL,
0x0000000122167824ULL, 0x100fe200078e0269ULL, 0x00000003006c7812ULL, 0x000fe200078ec0ffULL,
0x0000000124187824ULL, 0x000fe200078e0269ULL, 0x00000003ff0b7819ULL, 0x000fe20000011600ULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x000000046c077812ULL, 0x000fc400078efcffULL,
0x000000021a1a7819ULL, 0x000fe200000006ffULL, 0x00005e000e0e7625ULL, 0x080fe200078e0005ULL,
0x0000200066277811ULL, 0x000fe400078e68ffULL, 0x0000000224247819ULL, 0x000fe200000006ffULL,
0x00005e0010107625ULL, 0x000fc800078e0005ULL, 0x00005e0012127625ULL, 0x000fc800078e0005ULL,
0x00005e0014147625ULL, 0x000fc800078e0005ULL, 0x00005e0016167625ULL, 0x000fc800078e0005ULL,
0x00005e0018187625ULL, 0x000fc800078e0005ULL, 0x0000001007087825ULL, 0x000fc800078e0008ULL,
0x00000010070c7825ULL, 0x000fc800078e000cULL, 0x00000010070e7825ULL, 0x000fc800078e000eULL,
0x0000001007107825ULL, 0x000fc800078e0010ULL, 0x0000001007127825ULL, 0x000fc800078e0012ULL,
0x0000001007147825ULL, 0x000fc800078e0014ULL, 0x0000001007167825ULL, 0x000fc800078e0016ULL,
0x0000001007187825ULL, 0x000fe200078e0018ULL, 0x000000000b077212ULL, 0x000fc600078e3cffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000307077812ULL, 0x000fe200078ec0ffULL,
0x000000041c1c7824ULL, 0x000fe400078e00ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc076a7812ULL, 0x000fe200078ef800ULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee207ULL, 0x0000000422227824ULL, 0x000fe200078e00ffULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee207ULL, 0x000000106a297824ULL, 0x000fe200078e0227ULL,
0xfffffffc1c1c7812ULL, 0x000fe200078ee207ULL, 0x000000100a1b7824ULL, 0x000fe200078e0227ULL,
0xfffffffc1e1e7812ULL, 0x000fe200078ee207ULL, 0x000000101a1d7824ULL, 0x000fe200078e0227ULL,
0xfffffffc20207812ULL, 0x000fe200078ee207ULL, 0x000000101c1f7824ULL, 0x000fe200078e0227ULL,
0xfffffffc22227812ULL, 0x100fe200078ee207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008297faeULL, 0x0003e2000b901c46ULL, 0xfffffffc24247812ULL, 0x000fe200078ee207ULL,
0x0000001020237824ULL, 0x100fe200078e0227ULL, 0x000000271e217211ULL, 0x000fe200078e20ffULL,
0x0000001022257824ULL, 0x100fe200078e0227ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c46ULL,
0x0000001024277824ULL, 0x000fc600078e0227ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e4000b901c46ULL, 0x00000004ff087819ULL, 0x002fe20000011600ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000700097812ULL, 0x000fc400078ec0ffULL,
0x0000000d666d7819ULL, 0x000fe200000006ffULL, 0x00000008080c7824ULL, 0x000fc600078e00ffULL,
0x000010006d137810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee209ULL,
0x0000000809097812ULL, 0x000fe400078ef800ULL, 0x00000001ff0d7819ULL, 0x000fe2000001160cULL,
0x000000040c0f7824ULL, 0x040fe200078e00ffULL, 0x000000100c0e7810ULL, 0x040fe40007ffe0ffULL,
0x000000200c107810ULL, 0x000fc40007ffe0ffULL, 0x000000300c147810ULL, 0x000fe20007ffe0ffULL,
0x000000040e117824ULL, 0x000fe200078e00ffULL, 0x000000030d0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000410157824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe2000001160eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000001ff127819ULL, 0x000fe20000011610ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001ff107819ULL, 0x000fe40000011614ULL,
0x000000030d0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000312127812ULL, 0x000fe400078ec0ffULL,
0x0000000310107812ULL, 0x000fe400078ec0ffULL, 0x00000007080a7812ULL, 0x000fc400078e7809ULL,
0x000000010c467812ULL, 0x100fe400078e780bULL, 0x000000010e407812ULL, 0x100fe200078e780bULL,
0x00000010090a7824ULL, 0x000fe200078e020aULL, 0x0000000112427812ULL, 0x100fe400078e780bULL,
0x0000000214177819ULL, 0x000fe200000006ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000110447812ULL, 0x000fe400078e780bULL, 0x0000000f46467212ULL, 0x000fc400078efcffULL,
0x0000001140407212ULL, 0x000fe200078efcffULL, 0x000000000a2c783bULL, 0x000fe20000000200ULL,
0x0000001542427212ULL, 0x000fe200078efcffULL, 0x00000010466b7824ULL, 0x100fe200078e0213ULL,
0x0000001744447212ULL, 0x000fe200078efcffULL, 0x0000001040687824ULL, 0x100fe200078e0213ULL,
0x000000010b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001042637824ULL, 0x000fe200078e0213ULL,
0x0000001344627211ULL, 0x000fe200078e20ffULL, 0x000000006b38783bULL, 0x000e620000000200ULL,
0x0000000208147810ULL, 0x000fc40007ffe0ffULL, 0x000000020c707812ULL, 0x000fe200078e1e0bULL,
0x000000006834783bULL, 0x000ea20000000200ULL, 0x00000007140c7812ULL, 0x000fe400078e7809ULL,
0x000000020e0e7812ULL, 0x100fe200078e1e0bULL, 0x000000006330783bULL, 0x000ee20000000200ULL,
0x00000002126e7812ULL, 0x100fe200078e1e0bULL, 0x00000010090c7824ULL, 0x000fe200078e020cULL,
0x0000000210127812ULL, 0x000fe200078e1e0bULL, 0x00000000623c783bULL, 0x000f220000000200ULL,
0x0000000f70707212ULL, 0x000fe200078efcffULL, 0x000000100c247824ULL, 0x000fe200078e00ffULL,
0x000000110e107212ULL, 0x000fc400078efcffULL, 0x000000156e6e7212ULL, 0x000fe200078efcffULL,
0x0000001070617824ULL, 0x100fe200078e0213ULL, 0x0000001712127212ULL, 0x000fe200078efcffULL,
0x0000001010607824ULL, 0x100fe200078e0213ULL, 0x000000136e5f7211ULL, 0x000fe200078e20ffULL,
0x000000002424783bULL, 0x000fe40000000200ULL, 0x00000010125e7824ULL, 0x000fe400078e0213ULL,
0x000000006154783bULL, 0x000f680000000200ULL, 0x000000006014783bULL, 0x000f280000000200ULL,
0x000000005f1c783bULL, 0x000f280000000200ULL, 0x000000005e0c783bULL, 0x000f220000000200ULL,
0x000000382c28723cULL, 0x042ff000000418ffULL, 0x000000342c50723cULL, 0x044ff000000418ffULL,
0x000000302c18723cULL, 0x048ff000000418ffULL, 0x0000003a2c38723cULL, 0x040ff000000418ffULL,
0x000000362c34723cULL, 0x040ff000000418ffULL, 0x000000322c30723cULL, 0x040ff000000418ffULL,
0x0000003c2c20723cULL, 0x050ff000000418ffULL, 0x0000003e2c2c723cULL, 0x000ff000000418ffULL,
0x000000542428723cULL, 0x060ff00000041828ULL, 0x000000142450723cULL, 0x040ff00000041850ULL,
0x0000001c2418723cULL, 0x040ff00000041818ULL, 0x000000562454723cULL, 0x040ff00000041838ULL,
0x000000162414723cULL, 0x040ff00000041834ULL, 0x0000001e241c723cULL, 0x040ff00000041830ULL,
0x0000000c2420723cULL, 0x040ff00000041820ULL, 0x0000000e2424723cULL, 0x000fe2000004182cULL,
0x000004c000008947ULL, 0x000fee0003800000ULL, 0x00000002ff2d7819ULL, 0x000fe20000011600ULL,
0x00000001652c7824ULL, 0x000fe200078e0a06ULL, 0x000000086c0b7812ULL, 0x000fc400078efcffULL,
0x000000082d0a7810ULL, 0x040fe20007ffe0ffULL, 0x000000012d0c7824ULL, 0x140fe200078e0269ULL,
0x0000002c2d00720cULL, 0x0c0fe40003f26070ULL, 0x000000020a2e7819ULL, 0x040fe200000006ffULL,
0x000000010a0e7824ULL, 0x040fe200078e0269ULL, 0x0000002c0a00720cULL, 0x000fe20003f46070ULL,
0x00005e000c0c7625ULL, 0x080fe200078e0005ULL, 0xfffffffc2e2e7812ULL, 0x000fe400078ee207ULL,
0x000000182d357810ULL, 0x040fe20007ffe0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0005ULL,
0x000000202d367810ULL, 0x000fc40007ffe0ffULL, 0x000000282d377810ULL, 0x040fe20007ffe0ffULL,
0x000000102e117824ULL, 0x100fe200078e0213ULL, 0x000000102d2e7810ULL, 0x040fe20007ffe0ffULL,
0x000000106a0a7824ULL, 0x000fe200078e0213ULL, 0x000000302d387810ULL, 0x000fe20007ffe0ffULL,
0x000000100b0c7825ULL, 0x000fe200078e000cULL, 0x000000382d397810ULL, 0x000fe40007ffe0ffULL,
0x0000002c3600720cULL, 0x080fe20003f66070ULL, 0x000000100b0e7825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0a7faeULL, 0x0003e2000c901c46ULL,
0x0000002c2e00720cULL, 0x000fc40003f26070ULL, 0x000000042e347824ULL, 0x000fe200078e00ffULL,
0x000000000e117faeULL, 0x0005e2000d101c46ULL, 0x0000002c3500720cULL, 0x080fe20003f46070ULL,
0x0000000137307824ULL, 0x140fe200078e0269ULL, 0x0000002c3700720cULL, 0x080fe20003f86070ULL,
0x0000000138327824ULL, 0x140fe200078e0269ULL, 0x0000002c3800720cULL, 0x080fe20003fa6070ULL,
0x00000001393a7824ULL, 0x140fe200078e0269ULL, 0x0000002c3900720cULL, 0x040fe20003fc6070ULL,
0x000000012e0c7824ULL, 0x002fe200078e0269ULL, 0xfffffffc34347812ULL, 0x000fe200078ee207ULL,
0x00000001362c7824ULL, 0x000fe200078e0269ULL, 0x00000002393e7819ULL, 0x000fe200000006ffULL,
0x00005e000c2e7625ULL, 0x000fe200078e0005ULL, 0x00000069350e7210ULL, 0x004fc40007ffe0ffULL,
0x0000001334117211ULL, 0x000fe200078e20ffULL, 0x0000000435347824ULL, 0x000fe400078e00ffULL,
0x00005e000e0c7625ULL, 0x000fc600078e0005ULL, 0xfffffffc34347812ULL, 0x000fe200078ee207ULL,
0x00005e002c0e7625ULL, 0x000fc800078e0005ULL, 0x00005e00302c7625ULL, 0x000fc800078e0005ULL,
0x00005e0032307625ULL, 0x000fc800078e0005ULL, 0x00005e003a327625ULL, 0x000fc800078e0005ULL,
0x0000000436367824ULL, 0x000fe400078e00ffULL, 0x00000004373a7824ULL, 0x000fe400078e00ffULL,
0x00000004383c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc36367812ULL, 0x000fe200078ee207ULL,
0x000000100b2e7825ULL, 0x040fe200078e002eULL, 0xfffffffc3a387812ULL, 0x100fe400078ee207ULL,
0xfffffffc3c3a7812ULL, 0x000fe200078ee207ULL, 0x000000100b0c7825ULL, 0x000fe200078e000cULL,
0x000000002e117faeULL, 0x0003e2000c901c46ULL, 0xfffffffc3e3c7812ULL, 0x000fc400078ee207ULL,
0x000000100b0e7825ULL, 0x040fe400078e000eULL, 0x000000133c377211ULL, 0x000fe400078e20ffULL,
0x000000100b2c7825ULL, 0x000fc800078e002cULL, 0x000000100b307825ULL, 0x000fc800078e0030ULL,
0x000000100b327825ULL, 0x000fc800078e0032ULL, 0x00000010340b7824ULL, 0x100fe400078e0213ULL,
0x0000001036117824ULL, 0x102fe400078e0213ULL, 0x00000010382f7824ULL, 0x100fe200078e0213ULL,
0x000000000c0b7faeULL, 0x0003e2000d101c46ULL, 0x000000103a357824ULL, 0x000fc600078e0213ULL,
0x000000000e117faeULL, 0x0003e8000d901c46ULL, 0x000000002c2f7faeULL, 0x0003e8000e101c46ULL,
0x0000000030357faeULL, 0x0003e8000e901c46ULL, 0x0000000032377faeULL, 0x0003e2000f101c46ULL,
0x0000041000007947ULL, 0x000fea0003800000ULL, 0x00000008000e7811ULL, 0x000fe200078ff0ffULL,
0x000000106a0a7824ULL, 0x000fe200078e0213ULL, 0x00000069000c7211ULL, 0x000fc400078ff0ffULL,
0x00000010002c7811ULL, 0x000fe200078ff0ffULL, 0x000000040e367824ULL, 0x000fe200078e00ffULL,
0x000000086c377812ULL, 0x000fe200078efcffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0005ULL,
0x000000022c387819ULL, 0x000fe400000006ffULL, 0x00000018003a7811ULL, 0x000fe200078ff0ffULL,
0x000000010e307824ULL, 0x000fe200078e0269ULL, 0xfffffffc36367812ULL, 0x000fe200078ee207ULL,
0x000000012c327824ULL, 0x000fe200078e0269ULL, 0x00000020003c7811ULL, 0x000fe200078ff0ffULL,
0x00000010370c7825ULL, 0x000fe200078e000cULL, 0xfffffffc38387812ULL, 0x000fc400078ee207ULL,
0x00000028003e7811ULL, 0x000fe200078ff0ffULL, 0x00005e0030307625ULL, 0x080fe200078e0005ULL,
0x0000003000487811ULL, 0x040fe200078ff0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0a7faeULL, 0x0003e2000b901c46ULL, 0x00000038004a7811ULL, 0x000fe200078ff0ffULL,
0x000000013a0e7824ULL, 0x000fe400078e0269ULL, 0x00005e0032327625ULL, 0x000fe200078e0005ULL,
0x000000694a4c7210ULL, 0x000fc60007ffe0ffULL, 0x00000010360b7824ULL, 0x000fe400078e0213ULL,
0x000000013c2c7824ULL, 0x000fe400078e0269ULL, 0x0000001038117824ULL, 0x000fe400078e0213ULL,
0x000000043a367824ULL, 0x000fe200078e00ffULL, 0x000000023e3a7819ULL, 0x040fe200000006ffULL,
0x000000013e2e7824ULL, 0x000fe400078e0269ULL, 0x000000043c387824ULL, 0x000fe200078e00ffULL,
0xfffffffc36367812ULL, 0x000fe200078ee207ULL, 0x0000000148347824ULL, 0x000fe200078e0269ULL,
0xfffffffc3a3a7812ULL, 0x100fe200078ee207ULL, 0x00005e000e0c7625ULL, 0x002fe200078e0005ULL,
0xfffffffc38387812ULL, 0x000fc600078ee207ULL, 0x0000001037307825ULL, 0x000fc800078e0030ULL,
0x00000004483c7824ULL, 0x000fe200078e00ffULL, 0x00000000300b7faeULL, 0x0003e2000b901c46ULL,
0x00005e002c0e7625ULL, 0x000fc600078e0005ULL, 0xfffffffc3c3c7812ULL, 0x000fe200078ee207ULL,
0x000000044a4a7824ULL, 0x000fe400078e00ffULL, 0x00005e002e2c7625ULL, 0x000fc800078e0005ULL,
0x0000001037327825ULL, 0x000fe200078e0032ULL, 0xfffffffc4a307812ULL, 0x002fe400078ee207ULL,
0x000000133a317211ULL, 0x000fe200078e20ffULL, 0x00005e00342e7625ULL, 0x080fe200078e0005ULL,
0x0000000032117faeULL, 0x0003e6000b901c46ULL, 0x00005e004c347625ULL, 0x000fc800078e0005ULL,
0x00000010370c7825ULL, 0x000fc800078e000cULL, 0x00000010360b7824ULL, 0x000fe400078e0213ULL,
0x00000010370e7825ULL, 0x000fc600078e000eULL, 0x000000000c0b7faeULL, 0x0005e2000b901c46ULL,
0x0000001038117824ULL, 0x002fe400078e0213ULL, 0x00000010372c7825ULL, 0x000fc600078e002cULL,
0x000000000e117faeULL, 0x0005e2000b901c46ULL, 0x00000010372e7825ULL, 0x000fc600078e002eULL,
0x000000002c317faeULL, 0x0005e2000b901c46ULL, 0x0000001037347825ULL, 0x000fc800078e0034ULL,
0x000000103c337824ULL, 0x100fe400078e0213ULL, 0x0000001030377824ULL, 0x000fc600078e0213ULL,
0x000000002e337faeULL, 0x0005e8000b901c46ULL, 0x0000000034377faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004080c7810ULL, 0x006fe40007ffe0ffULL,
0x000020006d6d7810ULL, 0x000fe40007ffe0ffULL, 0x000000070c0c7812ULL, 0x000fe400078e7809ULL,
0x00000006082c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010460b7824ULL, 0x000fe200078e026dULL,
0x0000006d700f7211ULL, 0x000fe200078e20ffULL, 0x00000010090c7824ULL, 0x000fe200078e020cULL,
0x000000072c2c7812ULL, 0x000fe200078e7809ULL, 0x00000010420d7824ULL, 0x000fc400078e026dULL,
0x00000010440e7824ULL, 0x100fe200078e026dULL, 0x000000040c417819ULL, 0x000fe200000006ffULL,
0x00000010400c7824ULL, 0x100fe400078e026dULL, 0x00000010092c7824ULL, 0x000fe400078e022cULL,
0x0000001010107824ULL, 0x000fe400078e026dULL, 0x000000102c2c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000b58783bULL, 0x000fe20000000200ULL,
0x000000106e117824ULL, 0x100fe400078e026dULL, 0x0000001012127824ULL, 0x000fe200078e026dULL,
0x000000004140783bULL, 0x000e680000000200ULL, 0x000000000c4c783bULL, 0x000ea80000000200ULL,
0x000000000d48783bULL, 0x000ee80000000200ULL, 0x000000000e44783bULL, 0x000f280000000200ULL,
0x000000000f3c783bULL, 0x000fe80000000200ULL, 0x000000002c2c783bULL, 0x000f680000000200ULL,
0x000000001038783bULL, 0x000ee80000000200ULL, 0x000000001134783bULL, 0x000ee80000000200ULL,
0x000000001230783bULL, 0x000ee20000000200ULL, 0x000000584028723cULL, 0x042ff00000041828ULL,
0x0000005a4054723cULL, 0x040ff00000041854ULL, 0x0000004c4050723cULL, 0x044ff00000041850ULL,
0x0000004e4014723cULL, 0x040ff00000041814ULL, 0x000000484018723cULL, 0x048ff00000041818ULL,
0x0000004a401c723cULL, 0x040ff0000004181cULL, 0x000000444020723cULL, 0x050ff00000041820ULL,
0x000000464024723cULL, 0x000ff00000041824ULL, 0x0000003c2c28723cULL, 0x060ff00000041828ULL,
0x0000003e2c54723cULL, 0x040ff00000041854ULL, 0x000000382c50723cULL, 0x040ff00000041850ULL,
0x0000003a2c14723cULL, 0x040ff00000041814ULL, 0x000000342c18723cULL, 0x040ff00000041818ULL,
0x000000362c1c723cULL, 0x040ff0000004181cULL, 0x000000302c20723cULL, 0x040ff00000041820ULL,
0x000000322c2c723cULL, 0x000fe20000041824ULL, 0x000004c000008947ULL, 0x000fee0003800000ULL,
0x00000002ff307819ULL, 0x000fe20000011600ULL, 0x000000106a277824ULL, 0x000fe200078e026dULL,
0x8000000665267210ULL, 0x000fc40007ffe0ffULL, 0x0000000c6c3b7812ULL, 0x000fe200078efcffULL,
0x0000000130247824ULL, 0x040fe200078e0269ULL, 0x000000263000720cULL, 0x040fe40003f06070ULL,
0x0000000830317810ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x000fe200078e0005ULL,
0x0000001030327810ULL, 0x040fe40007ffe0ffULL, 0x0000001830337810ULL, 0x040fe40007ffe0ffULL,
0x0000002030357810ULL, 0x040fe20007ffe0ffULL, 0x000000103b247825ULL, 0x000fe200078e0024ULL,
0x0000002830367810ULL, 0x000fc40007ffe0ffULL, 0x0000003030377810ULL, 0x040fe20007ffe0ffULL,
0x00000004333a7824ULL, 0x000fe200078e00ffULL, 0x0000003830397810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000c101c46ULL,
0x000000263100720cULL, 0x080fe20003f06070ULL, 0x0000000133347824ULL, 0x140fe200078e0269ULL,
0x000000263200720cULL, 0x080fe20003f26070ULL, 0x00000001363c7824ULL, 0x140fe200078e0269ULL,
0x000000263300720cULL, 0x080fe20003f46070ULL, 0x0000000436427824ULL, 0x040fe200078e00ffULL,
0x000000263500720cULL, 0x0c0fe20003f66070ULL, 0x0000000135387824ULL, 0x100fe200078e0269ULL,
0x000000263600720cULL, 0x080fe20003f86070ULL, 0x0000000137407824ULL, 0x140fe200078e0269ULL,
0x000000263700720cULL, 0x080fe20003fa6070ULL, 0x0000000131247824ULL, 0x002fe200078e0269ULL,
0x000000263900720cULL, 0x000fe20003fc6070ULL, 0x0000000431267824ULL, 0x000fe200078e00ffULL,
0x0000006932307210ULL, 0x040fe20007ffe0ffULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0xfffffffc3a367812ULL, 0x100fe200078ee207ULL, 0x00005e0024247625ULL, 0x000fe200078e0005ULL,
0xfffffffc26267812ULL, 0x000fc400078ee207ULL, 0xfffffffc32327812ULL, 0x000fe200078ee207ULL,
0x0000000437467824ULL, 0x000fe200078e00ffULL, 0x00000002353e7819ULL, 0x000fe200000006ffULL,
0x00000010263d7824ULL, 0x000fe200078e026dULL, 0x0000006939447210ULL, 0x040fe20007ffe0ffULL,
0x00005e0030267625ULL, 0x000fe200078e0005ULL, 0xfffffffc3e3a7812ULL, 0x100fe400078ee207ULL,
0xfffffffc423e7812ULL, 0x100fe200078ee207ULL, 0x0000000439487824ULL, 0x000fe200078e00ffULL,
0xfffffffc46427812ULL, 0x000fe200078ee207ULL, 0x00000010323f7824ULL, 0x000fe200078e026dULL,
0x0000006d3a437211ULL, 0x000fe200078e20ffULL, 0x00005e0034307625ULL, 0x000fe200078e0005ULL,
0xfffffffc48467812ULL, 0x000fc600078ee207ULL, 0x00005e0038327625ULL, 0x000fc800078e0005ULL,
0x0000001036417824ULL, 0x000fe400078e026dULL, 0x00005e003c347625ULL, 0x000fc800078e0005ULL,
0x00005e0040367625ULL, 0x000fc800078e0005ULL, 0x00005e0044387625ULL, 0x000fc800078e0005ULL,
0x000000103b247825ULL, 0x000fc800078e0024ULL, 0x000000103b267825ULL, 0x040fe200078e0026ULL,
0x00000000243d7faeULL, 0x0003e6000c101c46ULL, 0x000000103b307825ULL, 0x040fe200078e0030ULL,
0x00000000263f7faeULL, 0x0003e6000c901c46ULL, 0x000000103b327825ULL, 0x040fe200078e0032ULL,
0x0000000030417faeULL, 0x0003e6000d101c46ULL, 0x000000103e457824ULL, 0x000fe200078e026dULL,
0x0000000032437faeULL, 0x0003e2000d901c46ULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x0000001042477824ULL, 0x000fe200078e026dULL, 0x0000000034457faeULL, 0x0003e2000e101c46ULL,
0x000000103b367825ULL, 0x000fc800078e0036ULL, 0x00000010466d7824ULL, 0x000fe200078e026dULL,
0x0000000036477faeULL, 0x0003e2000e901c46ULL, 0x000000103b387825ULL, 0x000fca00078e0038ULL,
0x00000000386d7faeULL, 0x0003e2000f101c46ULL, 0x0000041000007947ULL, 0x000fea0003800000ULL,
0x0000006900247211ULL, 0x000fe200078ff0ffULL, 0x000000106a277824ULL, 0x000fe200078e026dULL,
0x0000000c6c477812ULL, 0x000fe400078efcffULL, 0x0000000800267811ULL, 0x000fe200078ff0ffULL,
0x00005e0024247625ULL, 0x000fe200078e0005ULL, 0x0000001000327811ULL, 0x040fe400078ff0ffULL,
0x0000001800347811ULL, 0x000fe200078ff0ffULL, 0x0000000426487824ULL, 0x000fe200078e00ffULL,
0x0000002000387811ULL, 0x000fe200078ff0ffULL, 0x0000001047247825ULL, 0x000fe200078e0024ULL,
0x0000006926307210ULL, 0x000fc40007ffe0ffULL, 0x00000028003c7811ULL, 0x000fe200078ff0ffULL,
0x0000000132267824ULL, 0x140fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000b901c46ULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x0000003000407811ULL, 0x000fe200078ff0ffULL, 0x0000000134367824ULL, 0x140fe200078e0269ULL,
0x0000000234347819ULL, 0x000fe200000006ffULL, 0x00000001383a7824ULL, 0x000fe200078e0269ULL,
0x0000003800447811ULL, 0x000fe200078ff0ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0xfffffffc32327812ULL, 0x000fe200078ee207ULL, 0x000000013c3e7824ULL, 0x000fe200078e0269ULL,
0xfffffffc34347812ULL, 0x100fe200078ee207ULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc48247812ULL, 0x002fe200078ee207ULL, 0x00005e0026267625ULL, 0x000fe200078e0005ULL,
0x0000006940427210ULL, 0x000fc40007ffe0ffULL, 0xfffffffc38387812ULL, 0x000fe200078ee207ULL,
0x00000010243b7824ULL, 0x000fe200078e026dULL, 0x0000006d323d7211ULL, 0x000fe200078e20ffULL,
0x00005e0030247625ULL, 0x000fe200078e0005ULL, 0xfffffffc3c3c7812ULL, 0x000fc600078ee207ULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x0000000144467824ULL, 0x000fe400078e0269ULL,
0x00005e0036307625ULL, 0x000fe200078e0005ULL, 0xfffffffc40407812ULL, 0x000fc600078ee207ULL,
0x0000000444447824ULL, 0x000fe400078e00ffULL, 0x00000010343f7824ULL, 0x000fe400078e026dULL,
0x00005e003a327625ULL, 0x000fe200078e0005ULL, 0xfffffffc44447812ULL, 0x000fc600078ee207ULL,
0x00005e003e347625ULL, 0x000fc800078e0005ULL, 0x0000001038417824ULL, 0x000fe400078e026dULL,
0x00005e0042367625ULL, 0x000fc800078e0005ULL, 0x00005e0046387625ULL, 0x000fc800078e0005ULL,
0x0000001047247825ULL, 0x000fc800078e0024ULL, 0x0000001047267825ULL, 0x040fe200078e0026ULL,
0x00000000243b7faeULL, 0x0003e6000b901c46ULL, 0x0000001047307825ULL, 0x040fe200078e0030ULL,
0x00000000263d7faeULL, 0x0003e6000b901c46ULL, 0x0000001047327825ULL, 0x040fe200078e0032ULL,
0x00000000303f7faeULL, 0x0003e6000b901c46ULL, 0x000000103c437824ULL, 0x000fe200078e026dULL,
0x0000000032417faeULL, 0x0003e2000b901c46ULL, 0x0000001047347825ULL, 0x000fc800078e0034ULL,
0x0000001040457824ULL, 0x000fe200078e026dULL, 0x0000006d446d7211ULL, 0x000fe200078e20ffULL,
0x0000001047367825ULL, 0x040fe200078e0036ULL, 0x0000000034437faeULL, 0x0003e6000b901c46ULL,
0x0000001047387825ULL, 0x000fe200078e0038ULL, 0x0000000036457faeULL, 0x0003e8000b901c46ULL,
0x00000000386d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000808247810ULL, 0x002fc40007ffe0ffULL, 0x0000000a08307810ULL, 0x000fe40007ffe0ffULL,
0x0000000724247812ULL, 0x100fe400078e7809ULL, 0x0000000730307812ULL, 0x000fc600078e7809ULL,
0x0000001009247824ULL, 0x040fe400078e0224ULL, 0x0000001009307824ULL, 0x000fe400078e0230ULL,
0x0000001024447824ULL, 0x000fe400078e00ffULL, 0x0000001030307824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006b24783bULL, 0x000fe80000000200ULL,
0x000000004444783bULL, 0x000e680000000200ULL, 0x000000006858783bULL, 0x000ea80000000200ULL,
0x00000000634c783bULL, 0x000ee80000000200ULL, 0x000000006248783bULL, 0x000f280000000200ULL,
0x000000006140783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000f680000000200ULL,
0x00000000603c783bULL, 0x000ee80000000200ULL, 0x000000005f38783bULL, 0x000ee80000000200ULL,
0x000000005e34783bULL, 0x000ee20000000200ULL, 0x000000244428723cULL, 0x042fee0000041828ULL,
0x0000030067257a10ULL, 0x000fe20007ffe0ffULL, 0x000000264454723cULL, 0x040fee0000041854ULL,
0x0000000125277810ULL, 0x000fe20007ffe0ffULL, 0x000000584450723cULL, 0x004fe60000041850ULL,
0x000000642700720cULL, 0x000fca0003f06070ULL, 0x0000005a4414723cULL, 0x040ff00000041814ULL,
0x0000004c4418723cULL, 0x048ff00000041818ULL, 0x0000004e441c723cULL, 0x040ff0000004181cULL,
0x000000484420723cULL, 0x050ff00000041820ULL, 0x0000004a442c723cULL, 0x000ff0000004182cULL,
0x000000403028723cULL, 0x060ff00000041828ULL, 0x000000423054723cULL, 0x040ff00000041854ULL,
0x0000003c3050723cULL, 0x040ff00000041850ULL, 0x0000003e3014723cULL, 0x040ff00000041814ULL,
0x000000383018723cULL, 0x040ff00000041818ULL, 0x0000003a301c723cULL, 0x040ff0000004181cULL,
0x000000343020723cULL, 0x040ff00000041820ULL, 0x00000036302c723cULL, 0x000fee000004182cULL,
0x0000000225327211ULL, 0x000fca00078e40ffULL, 0x00006200033d7a24ULL, 0x000fe200078e0232ULL,
0x0000055000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3a7819ULL, 0x000fe20000011600ULL,
0x0000001000277824ULL, 0x000fe200078e00ffULL, 0x0000003265247217ULL, 0x000fe40007800000ULL,
0x000000083a347810ULL, 0x040fe20007ffe0ffULL, 0x000000013a267824ULL, 0x000fe200078e023dULL,
0x00000030273f7812ULL, 0x000fe200078ec0ffULL, 0x0000000124247824ULL, 0x000fe200078e0a32ULL,
0x000000103a3c7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0026267625ULL, 0x000fe200078e0005ULL,
0x000000183a3e7810ULL, 0x000fc40007ffe0ffULL, 0x000000243400720cULL, 0x040fe20003f26070ULL,
0x0000000134307824ULL, 0x000fe200078e023dULL, 0x0000003f26367210ULL, 0x000fe40007f1e0ffULL,
0x0000000234347819ULL, 0x000fe200000006ffULL, 0x00005e0030307625ULL, 0x000fe200078e0005ULL,
0x0000003d3c267210ULL, 0x000fe40007ffe0ffULL, 0xfffffffc34347812ULL, 0x000fe200078ee207ULL,
0x000000ffff377224ULL, 0x000fe200000e0627ULL, 0x0000003f30387210ULL, 0x000fe20007f1e0ffULL,
0x00005e0026267625ULL, 0x000fe200078e0005ULL, 0x000000203a407810ULL, 0x000fc40007ffe0ffULL,
0x000000283a427810ULL, 0x000fe20007ffe0ffULL, 0x0000001034417824ULL, 0x000fe200078e0213ULL,
0x0000003f26267210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff397224ULL, 0x000fe200000e0631ULL,
0x0000003d42347210ULL, 0x000fe20007ffe0ffULL, 0x000000013e307824ULL, 0x100fe200078e023dULL,
0x000000243a00720cULL, 0x000fe20003f06070ULL, 0x0000000140327824ULL, 0x000fe200078e023dULL,
0x000000303a437810ULL, 0x000fe20007ffe0ffULL, 0x00005e0030307625ULL, 0x000fe200078e0005ULL,
0x000000383a447810ULL, 0x000fc40007ffe0ffULL, 0x000000243c00720cULL, 0x080fe20003fa6070ULL,
0x00005e0032327625ULL, 0x000fe200078e0005ULL, 0x000000243e00720cULL, 0x000fc60003f86070ULL,
0x00005e0034347625ULL, 0x000fe200078e0005ULL, 0x0000003f32327210ULL, 0x080fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000360a7faeULL, 0x0003e2000c101c46ULL,
0x000000244400720cULL, 0x080fe20003f06070ULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x0000003f30307210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x0000003f343a7210ULL, 0x000fe20007fde0ffULL, 0x0000000038417faeULL, 0x0005e2000c901c46ULL,
0x0000003d43347210ULL, 0x040fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x000fe200010e0631ULL,
0x000000244000720cULL, 0x080fe20003f66070ULL, 0x000000ffff3b7224ULL, 0x000fe200030e0635ULL,
0x000000244200720cULL, 0x080fe20003f46070ULL, 0x000000043c0a7824ULL, 0x002fe200078e00ffULL,
0x000000244300720cULL, 0x000fe20003f26070ULL, 0x00005e0034347625ULL, 0x000fc600078e0005ULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee207ULL, 0x000000043e247824ULL, 0x000fe200078e00ffULL,
0x0000003f34347210ULL, 0x000fe20007fde0ffULL, 0x0000000144367824ULL, 0x000fe400078e023dULL,
0x0000000440387824ULL, 0x004fe200078e00ffULL, 0xfffffffc24247812ULL, 0x100fe200078ee207ULL,
0x00000004423c7824ULL, 0x000fe200078e00ffULL, 0x00000035ff357210ULL, 0x000fe200037fe4ffULL,
0x00000004433e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc38387812ULL, 0x100fe200078ee207ULL,
0x0000000444407824ULL, 0x000fe200078e00ffULL, 0xfffffffc3c3c7812ULL, 0x100fe200078ee207ULL,
0x00005e0036367625ULL, 0x000fe200078e0005ULL, 0xfffffffc3e3e7812ULL, 0x000fc400078ee207ULL,
0xfffffffc40407812ULL, 0x000fe200078ee207ULL, 0x000000100a057824ULL, 0x100fe200078e0213ULL,
0x0000003f36367210ULL, 0x000fe20007fde0ffULL, 0x0000001024077824ULL, 0x100fe200078e0213ULL,
0x000000133e3f7211ULL, 0x000fe200078e20ffULL, 0x0000001038397824ULL, 0x100fe200078e0213ULL,
0x0000000026057faeULL, 0x0003e2000e901c46ULL, 0x000000103c3d7824ULL, 0x100fe400078e0213ULL,
0x0000001040137824ULL, 0x000fe200078e0213ULL, 0x0000000030077faeULL, 0x0003e2000e101c46ULL,
0x000000ffff377224ULL, 0x000fc600030e0637ULL, 0x0000000032397faeULL, 0x0003e8000d901c46ULL,
0x000000003a3d7faeULL, 0x0003e8000d101c46ULL, 0x00000000343f7faeULL, 0x0003e8000c901c46ULL,
0x0000000036137faeULL, 0x0003e2000c101c46ULL, 0x0000049000007947ULL, 0x000fea0003800000ULL,
0x0000001000247824ULL, 0x040fe200078e00ffULL, 0x0000003d00267211ULL, 0x000fc400078ff0ffULL,
0x0000000800307811ULL, 0x040fe400078ff0ffULL, 0x0000001000327811ULL, 0x000fe200078ff0ffULL,
0x00005e0026267625ULL, 0x000fe200078e0005ULL, 0x0000001800347811ULL, 0x040fe400078ff0ffULL,
0x0000002000367811ULL, 0x000fe200078ff0ffULL, 0x0000000432447824ULL, 0x000fe200078e00ffULL,
0x0000002800387811ULL, 0x000fe200078ff0ffULL, 0x0000000434467824ULL, 0x000fe200078e00ffULL,
0x00000030243f7812ULL, 0x000fe200078ec0ffULL, 0x0000000130247824ULL, 0x140fe200078e023dULL,
0x0000000230427819ULL, 0x000fe200000006ffULL, 0x0000000132307824ULL, 0x100fe200078e023dULL,
0x00000030003a7811ULL, 0x000fe200078ff0ffULL, 0x0000000134327824ULL, 0x100fe200078e023dULL,
0x0000003d36347210ULL, 0x040fe20007ffe0ffULL, 0x0000000436487824ULL, 0x000fe200078e00ffULL,
0x00000038003c7811ULL, 0x000fe200078ff0ffULL, 0x0000000138367824ULL, 0x100fe200078e023dULL,
0x000000023a4c7819ULL, 0x000fe200000006ffULL, 0x00000004384a7824ULL, 0x000fe200078e00ffULL,
0x0000003f26387210ULL, 0x000fe20007f1e0ffULL, 0x000000013a3e7824ULL, 0x000fe200078e023dULL,
0xfffffffc423a7812ULL, 0x100fe200078ee207ULL, 0x000000043c4e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc46427812ULL, 0x000fe200078ee207ULL, 0x000000ffff397224ULL, 0x000fe200000e0627ULL,
0xfffffffc4a467812ULL, 0x000fe200078ee207ULL, 0x000000013c407824ULL, 0x000fe200078e023dULL,
0xfffffffc443c7812ULL, 0x100fe200078ee207ULL, 0x00005e0024267625ULL, 0x080fe200078e0005ULL,
0xfffffffc48447812ULL, 0x100fe200078ee207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000380a7faeULL, 0x0003e2000b901c46ULL, 0xfffffffc4c487812ULL, 0x100fe200078ee207ULL,
0x00005e0030307625ULL, 0x000fe200078e0005ULL, 0xfffffffc4e4a7812ULL, 0x000fc400078ee207ULL,
0x000000133c417211ULL, 0x000fe200078e20ffULL, 0x000000103a077824ULL, 0x000fe200078e0213ULL,
0x0000003f263a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0032327625ULL, 0x000fe200078e0005ULL,
0x0000003f303c7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e0627ULL,
0x0000003f32327210ULL, 0x000fe20007f1e0ffULL, 0x00005e0034267625ULL, 0x000fc600078e0005ULL,
0x000000003a077faeULL, 0x0003e2000b901c46ULL, 0x000000ffff3d7224ULL, 0x000fe400008e0631ULL,
0x00005e0036307625ULL, 0x000fc600078e0005ULL, 0x000000003c417faeULL, 0x0003e2000b901c46ULL,
0x00005e003e347625ULL, 0x000fe200078e0005ULL, 0x0000003f30307210ULL, 0x000fc60007f3e0ffULL,
0x00005e0040367625ULL, 0x000fe200078e0005ULL, 0x0000003f34347210ULL, 0x000fe40007f5e0ffULL,
0x00000031ff317210ULL, 0x000fe20000ffe4ffULL, 0x000000ffff337224ULL, 0x000fe200000e0633ULL,
0x0000003f26267210ULL, 0x080fe20007f1e0ffULL, 0x0000001042437824ULL, 0x100fe200078e0213ULL,
0x0000003f36367210ULL, 0x000fe20007f7e0ffULL, 0x0000001044457824ULL, 0x000fe400078e0213ULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000000032437faeULL, 0x0003e2000b901c46ULL,
0x0000001046477824ULL, 0x000fc400078e0213ULL, 0x0000001048497824ULL, 0x000fe200078e0213ULL,
0x000000134a137211ULL, 0x000fe200078e20ffULL, 0x000000ffff357224ULL, 0x000fe200010e0635ULL,
0x0000000026457faeULL, 0x0003e2000b901c46ULL, 0x000000ffff377224ULL, 0x000fc600018e0637ULL,
0x0000000030477faeULL, 0x0003e8000b901c46ULL, 0x0000000034497faeULL, 0x0003e8000b901c46ULL,
0x0000000036137faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000c080a7810ULL, 0x042fe40007ffe0ffULL, 0x0000000e08087810ULL, 0x000fc40007ffe0ffULL,
0x000000070a0a7812ULL, 0x100fe400078e7809ULL, 0x0000000708087812ULL, 0x000fc600078e7809ULL,
0x00000010090a7824ULL, 0x040fe200078e020aULL, 0x0000000809087211ULL, 0x000fc600078e20ffULL,
0x000000100a0a7824ULL, 0x000fe400078e00ffULL, 0x00000010083c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000a34783bULL, 0x000fe80000000200ULL,
0x000000000c38783bULL, 0x000e680000000200ULL, 0x000000000d40783bULL, 0x000ea80000000200ULL,
0x000000000e44783bULL, 0x000ee80000000200ULL, 0x000000000b30783bULL, 0x000f280000000200ULL,
0x000000003c3c783bULL, 0x000fe80000000200ULL, 0x00000000104c783bULL, 0x000f680000000200ULL,
0x000000001148783bULL, 0x000f280000000200ULL, 0x000000001208783bULL, 0x000f680000000200ULL,
0x000000000f58783bULL, 0x0007620000000200ULL, 0x000000383450723cULL, 0x042ff00000041850ULL,
0x000000403418723cULL, 0x044ff00000041818ULL, 0x00000044340c723cULL, 0x048ff00000041820ULL,
0x000000303428723cULL, 0x050ff00000041828ULL, 0x000000323454723cULL, 0x040ff00000041854ULL,
0x0000003a3438723cULL, 0x040ff00000041814ULL, 0x00000042341c723cULL, 0x040ff0000004181cULL,
0x00000046342c723cULL, 0x000ff0000004182cULL, 0x0000004c3c14723cULL, 0x060ff00000041850ULL,
0x000000483c10723cULL, 0x040ff00000041818ULL, 0x000000083c0c723cULL, 0x040ff0000004180cULL,
0x000000583c28723cULL, 0x040ff00000041828ULL, 0x0000005a3c54723cULL, 0x040ff00000041854ULL,
0x0000004e3c4c723cULL, 0x040ff00000041838ULL, 0x0000004a3c48723cULL, 0x040ff0000004181cULL,
0x0000000a3c08723cULL, 0x000fe2000004182cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000ff20000008000ULL,
0x000000005d187f8cULL, 0x000fe2000c80043fULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f328287820ULL, 0x000fe20000410000ULL, 0x3db504f315157820ULL, 0x000fe20000410000ULL,
0x000004005d2d7984ULL, 0x000e620000000800ULL, 0x3db504f34c4c7820ULL, 0x000fe20000410000ULL,
0x3db504f34a4a7820ULL, 0x000fe20000410000ULL, 0x3db504f32a057820ULL, 0x000fe20000410000ULL,
0x3db504f32b077820ULL, 0x000fe20000410000ULL, 0x3db504f356567820ULL, 0x000fe20000410000ULL,
0x3db504f357577820ULL, 0x000fe20000410000ULL, 0x3db504f3161a7820ULL, 0x000fe20000410000ULL,
0x3db504f311247820ULL, 0x000fe20000410000ULL, 0x3db504f313167820ULL, 0x000fe20000410000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0029ULL, 0x3db504f3142a7820ULL, 0x000fe20000410000ULL,
0x3db504f3171c7820ULL, 0x000fe20000410000ULL, 0x3db504f310267820ULL, 0x000fe20000410000ULL,
0x3db504f3121b7820ULL, 0x000fe20000410000ULL, 0x3db504f30c217820ULL, 0x000fe20000410000ULL,
0x3db504f30d207820ULL, 0x000fe20000410000ULL, 0x3db504f30e117820ULL, 0x000fe20000410000ULL,
0x3db504f30f137820ULL, 0x000fe20000410000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0028ULL,
0x3db504f3542c7820ULL, 0x000fe20000410000ULL, 0x000000ffff297224ULL, 0x000fe200078e0015ULL,
0x3db504f3552b7820ULL, 0x000fe20000410000ULL, 0x3db504f34d277820ULL, 0x000fe20000410000ULL,
0x3db504f34e1d7820ULL, 0x000fe20000410000ULL, 0x3db504f34f177820ULL, 0x000fe20000410000ULL,
0x3db504f348237820ULL, 0x000fe20000410000ULL, 0x3db504f349227820ULL, 0x000fe20000410000ULL,
0x3db504f34b147820ULL, 0x000fe20000410000ULL, 0x3db504f3081f7820ULL, 0x000fe20000410000ULL,
0x3db504f3091e7820ULL, 0x000fe20000410000ULL, 0x3db504f30a127820ULL, 0x000fe20000410000ULL,
0x3db504f30b107820ULL, 0x000fe20000410000ULL, 0x0000004c00287202ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0005ULL, 0x0000004a00157202ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0007ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0056ULL,
0x800000002dff7812ULL, 0x002fe20007804819ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0057ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff057424ULL, 0x000fc800078e00ffULL,
0x0000000500077305ULL, 0x0002a4000021f000ULL, 0x3fa0000005057823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x000004005d077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fc40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000400057824ULL, 0x000fe200078e00ffULL, 0x0000005c6700720cULL, 0x000fc80003f05270ULL,
0xfffffff005077812ULL, 0x000fca00078ec0ffULL, 0x0000008066077824ULL, 0x000fca00078e0207ULL,
0x0134000007087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000200187824ULL, 0x000fe200078e00ffULL, 0x8000000665317210ULL, 0x000fc80007ffe0ffULL,
0x0000000618187812ULL, 0x000fc800078ec0ffULL, 0x0000000118067812ULL, 0x040fe400078efcffULL,
0x0000000818197812ULL, 0x000fe400078efcffULL, 0x000000310600720cULL, 0x080fe40003f26070ULL,
0x0000001018067812ULL, 0x000fe400078efcffULL, 0x000000311900720cULL, 0x080fe40003f06070ULL,
0x000000310600720cULL, 0x000fc40003fc6070ULL, 0x0000001118197812ULL, 0x040fe400078efcffULL,
0x0000001818067812ULL, 0x040fe400078efcffULL, 0x000000311800720cULL, 0x080fe40003f46070ULL,
0x000000311900720cULL, 0x080fe40003fa6070ULL, 0x000000310600720cULL, 0x000fe40003f66070ULL,
0x00000009182d7812ULL, 0x000fc400078efcffULL, 0x0000001918197812ULL, 0x040fe400078efcffULL,
0x0000002018067812ULL, 0x000fe400078efcffULL, 0xff7fffff0c0c7808ULL, 0x000fe40005000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL,
0xff7fffff2e2e7808ULL, 0x000fc40004800000ULL, 0x000000312d00720cULL, 0x080fe40003f86070ULL,
0x000000311900720cULL, 0x080fe40003f46070ULL, 0x000000310600720cULL, 0x000fe40003f26070ULL,
0x0000002118197812ULL, 0x040fe400078efcffULL, 0x0000002818067812ULL, 0x000fe400078efcffULL,
0xff7fffff0e0e7808ULL, 0x000fc40004000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40004000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40006000000ULL,
0x000000311900720cULL, 0x080fe40003f06070ULL, 0x000000310600720cULL, 0x000fe40003f86070ULL,
0x0000002918197812ULL, 0x000fc400078efcffULL, 0x0000003018067812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40007000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40007000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40006800000ULL, 0xff7fffff29297808ULL, 0x000fe40006800000ULL,
0x000000311900720cULL, 0x000fc40003fc6070ULL, 0x000000310600720cULL, 0x000fe40003fa6070ULL,
0x0000003118197812ULL, 0x040fe400078efcffULL, 0x0000003818067812ULL, 0x040fe400078efcffULL,
0x0000003918187812ULL, 0x000fe400078efcffULL, 0xff7fffff1d1d7808ULL, 0x000fe40005800000ULL,
0xff7fffff28287808ULL, 0x000fc40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005000000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff26267808ULL, 0x000fe40004800000ULL, 0x000000311900720cULL, 0x080fe40003f66070ULL,
0x000000310600720cULL, 0x000fc40003f46070ULL, 0x000000311800720cULL, 0x000fe40003f26070ULL,
0xff7fffff16167808ULL, 0x000fe40004000000ULL, 0xff7fffff24247808ULL, 0x000fe40004000000ULL,
0xff7fffff15157808ULL, 0x000fe40006000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fc40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40007000000ULL,
0xff7fffff11117808ULL, 0x000fe40006800000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff13137808ULL, 0x000fe40005800000ULL, 0xff7fffff20207808ULL, 0x000fe40005800000ULL,
0xff7fffff12127808ULL, 0x000fc40005000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL,
0xff7fffff10107808ULL, 0x000fe40004800000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40004800000ULL,
0x0000002f08197209ULL, 0x004fe20007810000ULL, 0x0000001fff337424ULL, 0x000fe200078e00ffULL,
0x0000000c09067209ULL, 0x000fe20007810000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000002e19197209ULL, 0x000fe40007810000ULL, 0x0000000d06097209ULL, 0x000fc40007810000ULL,
0x0000002c19067209ULL, 0x000fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000002b06097209ULL, 0x000fe40007810000ULL, 0x0000000f08197209ULL, 0x000fe40007810000ULL,
0x0000002a09067209ULL, 0x000fe40007810000ULL, 0x0000001a19197209ULL, 0x000fc40007810000ULL,
0x0000002906097209ULL, 0x000fe40007810000ULL, 0x0000001c19067209ULL, 0x000fe40007810000ULL,
0x0000002809087209ULL, 0x000fe40007810000ULL, 0x0000001d06067209ULL, 0x000fe40007810000ULL,
0x0000002708097209ULL, 0x000fe40007810000ULL, 0x0000001706067209ULL, 0x000fc40007810000ULL,
0x0000002609097209ULL, 0x000fe40007810000ULL, 0x0000001b06197209ULL, 0x000fe40007810000ULL,
0x0000002409067209ULL, 0x000fe40007810000ULL, 0x0000001619087209ULL, 0x000fe40007810000ULL,
0x0000002306097209ULL, 0x000fe40007810000ULL, 0x0000001508197209ULL, 0x000fc40007810000ULL,
0x0000002209067209ULL, 0x000fe40007810000ULL, 0x0000001419087209ULL, 0x000fe40007810000ULL,
0x0000002106097209ULL, 0x000fe40007810000ULL, 0x0000001108087209ULL, 0x000fe40007810000ULL,
0x0000002009067209ULL, 0x000fe40007810000ULL, 0x0000001308097209ULL, 0x000fc40007810000ULL,
0x0000001f06197209ULL, 0x000fe40007810000ULL, 0x0000001209097209ULL, 0x000fe40007810000ULL,
0x0000001e19317209ULL, 0x000fe40007810000ULL, 0x0000001009327209ULL, 0x000fe20007810000ULL,
0x000017b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0031067f89ULL, 0x0004e400000e0000ULL,
0x0000000631347209ULL, 0x008fe20007810000ULL, 0x000017e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0032067f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b087f89ULL, 0x000f6200000e0000ULL, 0x0000000632187209ULL, 0x008fc40007810000ULL,
0x000000090a197209ULL, 0x010fc60007810000ULL, 0x0c201f0018317f89ULL, 0x004fe200000e0000ULL,
0x000000080b067209ULL, 0x020fc60007810000ULL, 0x0c201f0034097f89ULL, 0x000ea800000e0000ULL,
0x0c201f0019307f89ULL, 0x002e6800000e0000ULL, 0x0c201f00062d7f89ULL, 0x00072200000e0000ULL,
0x0000000934087209ULL, 0x004fe40007810000ULL, 0x0000003118097209ULL, 0x000fc40007810000ULL,
0x00000030190a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x008fe20000410000ULL,
0x3f80000000047882ULL, 0x000fc60000000000ULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080bULL, 0x0000002400317308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080bULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b09247820ULL, 0x008fe20000410000ULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010824ULL, 0x0000002e002e7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1e0b7823ULL, 0x000fe2000001080bULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b1d347823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010824ULL, 0x0000002000337308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b12127823ULL, 0x000fc40000010824ULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000e700000000800ULL,
0x0000000c00197308ULL, 0x0007f00000000800ULL, 0x0000000d001e7308ULL, 0x000b220000000800ULL,
0x0000002f2e0c723eULL, 0x008fce00000010ffULL, 0x0000000e00207308ULL, 0x0003e20000000800ULL,
0x00000004000d7c02ULL, 0x020fe20008000f00ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x3f8000000d2e783eULL, 0x000fc600000010ffULL,
0x0000000f000f7308ULL, 0x000ee20000000800ULL, 0x0000002c2b0e723eULL, 0x002fe200000010ffULL,
0x000000ffff2f7224ULL, 0x000fe200078e002eULL, 0x000000191e0d723eULL, 0x010fca00000010ffULL,
0x0000002a00187308ULL, 0x000fe20000000800ULL, 0x000000200f0f723eULL, 0x008fce00000010ffULL,
0x0000001f00307308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b207823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b10247823ULL, 0x000fe20000010824ULL, 0xfffffffc00107812ULL, 0x000fca00078ec0ffULL,
0x0000001c00327308ULL, 0x0003f00000000800ULL, 0x00000021002a7308ULL, 0x000fe20000000800ULL,
0x0000002e0c1c723cULL, 0x002fee00000418ffULL, 0x0000002900297308ULL, 0x000e700000000800ULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ee20000000800ULL,
0x000000182918723eULL, 0x002fce00000010ffULL, 0x0000001a00217308ULL, 0x0006700000000800ULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x00000028271a723eULL, 0x008fce00000010ffULL,
0x0000001700177308ULL, 0x000ee20000000800ULL, 0x000000213219723eULL, 0x002fce00000010ffULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x00000034171b723eULL, 0x008fce00000010ffULL,
0x0000002200227308ULL, 0x000e620000000800ULL, 0x0000000fff177424ULL, 0x000fe200078e00ffULL,
0x0000002e181c723cULL, 0x000fe8000004181cULL, 0x0000001017177219ULL, 0x000fe400000006ffULL,
0x0000002600267308ULL, 0x000ee20000000800ULL, 0x0000002a3310723eULL, 0x000fe200000010ffULL,
0x00000000170473c4ULL, 0x000f2c0000004000ULL, 0x00000020002b7308ULL, 0x0007e20000000800ULL,
0x000000232222723eULL, 0x002fce00000010ffULL, 0x0000001600167308ULL, 0x000e620000000800ULL,
0x000000263120723eULL, 0x008fce00000010ffULL, 0x0000001500157308ULL, 0x000ff00000000800ULL,
0x0000001400147308ULL, 0x000ee20000000800ULL, 0x0000002b1621723eULL, 0x002fe400000010ffULL,
0x00000000171673a1ULL, 0x000e6a00000e8000ULL, 0x0000000b000b7308ULL, 0x000f620000000800ULL,
0x000000151423723eULL, 0x008fce00000010ffULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x0000002e201c723cULL, 0x000fee000004181cULL, 0x0000001300287308ULL, 0x000ee20000000800ULL,
0x0000000517ff7c12ULL, 0x002fce000f804016ULL, 0x0000001200147308ULL, 0x000bf00000000800ULL,
0x0000002400157308ULL, 0x000e620000000800ULL, 0x000000300b12723eULL, 0x020fe400000010ffULL,
0x000000112811723eULL, 0x008fc400000010ffULL, 0x000000062d0b7209ULL, 0x004fe40007810000ULL,
0x000000141513723eULL, 0x002fce00000010ffULL, 0x0000002e1028723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000012f204008947ULL, 0x010fde000b800000ULL,
0x001c1fff281c7589ULL, 0x0002a400000e0000ULL, 0x00000000170673a1ULL, 0x000ee200000e8000ULL,
0x00000000170473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000517ff7c12ULL, 0x008fda000f804006ULL, 0x0000131204008947ULL, 0x010fea000b800000ULL,
0x001c1fff2a1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff001f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff067819ULL, 0x000fe40000011600ULL,
0x0000000c05377812ULL, 0x000fc400078ec0ffULL, 0x0000000706147812ULL, 0x040fe200078ec0ffULL,
0x0000000806177824ULL, 0x04afe200078e00ffULL, 0x0000000306157819ULL, 0x040fe200000006ffULL,
0x0000000806317824ULL, 0x040fe200078e00ffULL, 0x00000006ff167212ULL, 0x000fe400078e33ffULL,
0x0000000806067810ULL, 0x000fe40007ffe0ffULL, 0x0000000117277812ULL, 0x140fe400078ef614ULL,
0x0000000217297812ULL, 0x140fe200078ef614ULL, 0x0000000806437824ULL, 0x040fe200078e00ffULL,
0x00000003172b7812ULL, 0x140fe200078ef614ULL, 0x0000000806337824ULL, 0x000fe200078e00ffULL,
0x00000004172d7812ULL, 0x000fc400078ef614ULL, 0x00000005172f7812ULL, 0x100fe400078ef614ULL,
0xfffffff815157812ULL, 0x100fe400078ee214ULL, 0x0000000617177812ULL, 0x000fe400078ef614ULL,
0xfffffff831317812ULL, 0x000fe400078ee216ULL, 0x00000006ff167212ULL, 0x000fe400078e33ffULL,
0x0000000706147812ULL, 0x000fc400078ec0ffULL, 0x0000000306357819ULL, 0x000fe400000006ffULL,
0x0000900066067811ULL, 0x000fe400078e58ffULL, 0x0000000135397812ULL, 0x140fe400078ef614ULL,
0x00000002353b7812ULL, 0x000fe200078ef614ULL, 0x0000001015057824ULL, 0x000fe200078e0206ULL,
0x00000003353d7812ULL, 0x000fe200078ef614ULL, 0x000000102b247824ULL, 0x000fe200078e0206ULL,
0x00000004353f7812ULL, 0x100fe200078ef614ULL, 0x0000000137057824ULL, 0x000fe200078e0205ULL,
0x0000000535417812ULL, 0x000fe200078ef614ULL, 0x000000102f287824ULL, 0x000fe200078e0206ULL,
0xfffffff833337812ULL, 0x000fe200078ee214ULL, 0x00000010172a7824ULL, 0x000fe200078e0206ULL,
0x0000000635357812ULL, 0x000fe200078ef614ULL, 0x0000001027147824ULL, 0x000fe200078e0206ULL,
0xfffffff843437812ULL, 0x000fe200078ee216ULL, 0x0000001029167824ULL, 0x000fe200078e0206ULL,
0x000000062d267211ULL, 0x000fe200078e20ffULL, 0x0000000137157824ULL, 0x040fe200078e0214ULL,
0x0000002437277210ULL, 0x040fe20007ffe0ffULL, 0x0000000137177824ULL, 0x000fe200078e0216ULL,
0x00000006332e7211ULL, 0x000fe200078e20ffULL, 0x00000010312c7824ULL, 0x000fe200078e0206ULL,
0x0000000c05007388ULL, 0x0003e20000000800ULL, 0x0000000137297824ULL, 0x040fe200078e0226ULL,
0x0000002e372e7210ULL, 0x000fe20007ffe0ffULL, 0x0000001039307824ULL, 0x000fe200078e0206ULL,
0x0000000e15007388ULL, 0x0007e20000000800ULL, 0x00000001372b7824ULL, 0x000fe200078e0228ULL,
0x0000000300ff7812ULL, 0x000fe2000780c0ffULL, 0x000000103b317824ULL, 0x000fe200078e0206ULL,
0x0000001817007388ULL, 0x0007e20000000800ULL, 0x00000001372d7824ULL, 0x000fe200078e022aULL,
0x0000000641347211ULL, 0x000fe200078e20ffULL, 0x000000103d327824ULL, 0x000fe200078e0206ULL,
0x0000001a27007388ULL, 0x0007e20000000800ULL, 0x00000001372f7824ULL, 0x040fe200078e022cULL,
0x0000003437347210ULL, 0x000fe20007ffe0ffULL, 0x000000103f337824ULL, 0x100fe200078e0206ULL,
0x0000002029007388ULL, 0x0007e20000000800ULL, 0x0000001035357824ULL, 0x000fc400078e0206ULL,
0x0000001043367824ULL, 0x000fe200078e0206ULL, 0x000000222b007388ULL, 0x0007e20000000800ULL,
0x0000000137307824ULL, 0x040fe400078e0230ULL, 0x0000000137067824ULL, 0x040fe200078e0231ULL,
0x000000102d007388ULL, 0x0007e20000000800ULL, 0x0000000137327824ULL, 0x040fe400078e0232ULL,
0x00000001370c7824ULL, 0x042fe200078e0233ULL, 0x000000122f007388ULL, 0x0007e20000000800ULL,
0x0000000137147824ULL, 0x000fc400078e0235ULL, 0x0000000137367824ULL, 0x000fe200078e0236ULL,
0x0000000d2e007388ULL, 0x0007e80000000800ULL, 0x0000000f30007388ULL, 0x0007e80000000800ULL,
0x0000001906007388ULL, 0x0007e80000000800ULL, 0x0000001b32007388ULL, 0x0007e80000000800ULL,
0x000000210c007388ULL, 0x0007e80000000800ULL, 0x0000002334007388ULL, 0x0007e80000000800ULL,
0x0000001114007388ULL, 0x0007e80000000800ULL, 0x0000001336007388ULL, 0x0007e80000000800ULL,
0x0130000807008388ULL, 0x0007e80000000c00ULL, 0x0132001c07008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080004ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100004ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180004ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000642500720cULL, 0x000fe20003f06070ULL,
0x0136200004ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff677224ULL, 0x000fd600078e0025ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb43000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff157807ULL, 0x004fe40004000000ULL,
0x0001036000147802ULL, 0x000fe40000000f00ULL, 0x00000ef000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e001cULL, 0xffff1d0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x000103b000147802ULL, 0x000fe40000000f00ULL,
0x00000ea000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e001cULL,
0xffff1d4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e0002ULL,
0xffffffff00297802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fe200078e00ffULL,
0x0001042000147802ULL, 0x000fe40000000f00ULL, 0x00000df000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e001fULL, 0xffff1d9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff277224ULL, 0x000fe200078e0002ULL, 0x0001049000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x00000d8000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e001fULL,
0xffff1d5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e000bULL,
0x0001050000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x00000d1000007944ULL, 0x008fea0003c00000ULL,
0x000000080b0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff697224ULL, 0x004fe200078e001fULL,
0xffffffff00297802ULL, 0x002fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fe200078e00ffULL,
0x0001057000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e000aULL,
0x00000ca000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e001fULL,
0xffff1f7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x004fe40004000000ULL,
0x000105c000147802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xffff330000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x0001061000147802ULL, 0x000fc40000000f00ULL,
0x00000c4000007944ULL, 0x008fea0003c00000ULL, 0x0000001c00147202ULL, 0x000fe20000000f00ULL,
0xffff334000007947ULL, 0x000fea000383ffffULL, 0x0000001fff267424ULL, 0x002fe200078e00ffULL,
0x0001067000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x00000ba000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e001fULL,
0xffff33b000007947ULL, 0x000fea000383ffffULL, 0x0000000a00277202ULL, 0x002fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0x000106e000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x00000b3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e001fULL, 0xffff346000007947ULL, 0x000fea000383ffffULL,
0x0000001fff267424ULL, 0x000fe200078e00ffULL, 0x0001074000147802ULL, 0x000fe20000000f00ULL,
0xffffffffff297424ULL, 0x000fc400078e00ffULL, 0x00000ad000007944ULL, 0x008fea0003c00000ULL,
0x0000001f006d7202ULL, 0x004fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe200078e000aULL,
0x000107a000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x00000a7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x004fe200078e001fULL, 0xffff35a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x004fe40004000000ULL, 0x000107f000147802ULL, 0x000fe40000000f00ULL,
0x00000a6000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e001cULL,
0xffff464000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x000fe40004800000ULL,
0x0001084000147802ULL, 0x000fe40000000f00ULL, 0x00000a1000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e001cULL, 0xffff468000007947ULL, 0x000fea000383ffffULL,
0x0000001f00267802ULL, 0x002fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x000108a000147802ULL, 0x000fe40000000f00ULL, 0x0000097000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e001fULL, 0xffff46f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff277224ULL, 0x002fe200078e000aULL, 0x0001091000147802ULL, 0x000fe20000000f00ULL,
0x0000001fff267424ULL, 0x000fc400078e00ffULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x0000090000007944ULL, 0x008fea0003c00000ULL, 0x0000001f00147202ULL, 0x004fe20000000f00ULL,
0xffff47a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff267424ULL, 0x000fe200078e00ffULL,
0x0001097000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fe400078e00ffULL,
0x000008a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff6d7224ULL, 0x004fe200078e001fULL,
0xffffffff00297802ULL, 0x002fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e000aULL,
0x000109d000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fe400078e00ffULL,
0x0000084000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e001fULL,
0xffff48e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x004fe40004000000ULL,
0x00010a2000147802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff067224ULL, 0x000fe200078e001cULL, 0xffff599000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x00010a7000147802ULL, 0x000fc40000000f00ULL,
0x000007e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff067224ULL, 0x000fe200078e001cULL,
0xffff59d000007947ULL, 0x000fea000383ffffULL, 0x0000001fff267424ULL, 0x002fe200078e00ffULL,
0x00010ad000147802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fc400078e00ffULL,
0x0000074000007944ULL, 0x008fea0003c00000ULL, 0x0000001f00057202ULL, 0x004fe20000000f00ULL,
0xffff5a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x002fe200078e000aULL,
0x00010b4000147802ULL, 0x000fe20000000f00ULL, 0x0000001fff267424ULL, 0x000fc400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x000006d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e001fULL, 0xffff5af000007947ULL, 0x000fea000383ffffULL,
0x0000001f00267802ULL, 0x000fe20000000f00ULL, 0xffffffffff297424ULL, 0x000fe200078e00ffULL,
0x00010ba000147802ULL, 0x000fe40000000f00ULL, 0x0000067000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e001fULL, 0x00010c0000147802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e000aULL, 0x0000001fff267424ULL, 0x000fe400078e00ffULL,
0xffffffffff297424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x000fea0003c00000ULL,
0x0000001f000a7202ULL, 0x004fe20000000f00ULL, 0xffff5c3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2d7224ULL, 0x000fe200078e0031ULL, 0x00010c6000187802ULL, 0x000fe20000000f00ULL,
0x00000002ff307424ULL, 0x000fc400078e00ffULL, 0x0000057000007944ULL, 0x002fea0003c00000ULL,
0x0000002d00067202ULL, 0x004fe20000000f00ULL, 0xffffe80000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2d7224ULL, 0x000fe200078e0032ULL, 0x00010cc000187802ULL, 0x000fe20000000f00ULL,
0x00000002ff307424ULL, 0x002fc400078e00ffULL, 0x0000051000007944ULL, 0x004fea0003c00000ULL,
0x0000002d32327209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e000aULL,
0x00010d1000187802ULL, 0x000fe20000000f00ULL, 0x00000002ff307424ULL, 0x002fc400078e00ffULL,
0x000004c000007944ULL, 0x000fea0003c00000ULL, 0x0000002d0a0a7209ULL, 0x004fe20007810000ULL,
0x00000002ff307424ULL, 0x002fe200078e00ffULL, 0x0000000b002d7202ULL, 0x000fc40000000f00ULL,
0x00010d6000187802ULL, 0x000fe40000000f00ULL, 0x0000047000007944ULL, 0x000fea0003c00000ULL,
0x0000002d0b067209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0034ULL,
0x00010db000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x002fe400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000002d34087209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0032ULL, 0x0000000100307802ULL, 0x002fe40000000f00ULL,
0x00010e0000187802ULL, 0x000fe40000000f00ULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000002d32097209ULL, 0x004fe20007810000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e000aULL,
0x00010e5000187802ULL, 0x000fe20000000f00ULL, 0x00000001ff307424ULL, 0x002fc400078e00ffULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x0000002d0a0a7209ULL, 0x004fe20007810000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0006ULL, 0x00010ea000187802ULL, 0x000fe20000000f00ULL,
0x00000001ff307424ULL, 0x002fc400078e00ffULL, 0x0000033000007944ULL, 0x000fea0003c00000ULL,
0xffffe6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff247224ULL, 0x000fe200078e0028ULL,
0x00001c1f00267802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x00010f1000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0017ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e001fULL,
0xffffeca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff247224ULL, 0x002fe200078e002aULL,
0x00001c1f00267802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x00010f9000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0017ULL,
0x0000028000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff277224ULL, 0x002fe200078e00ffULL,
0x0000001f001d7202ULL, 0x004fe20000000f00ULL, 0x00001c1fff267424ULL, 0x000fe200078e00ffULL,
0x00010ff000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0017ULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff297224ULL, 0x002fe200078e0017ULL,
0x0001105000147802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e00ffULL,
0x00001c1fff267424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e001fULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xffffebf000007947ULL, 0x000fea000383ffffULL,
0x0180000055007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000005500008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff55ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000055057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000005500007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000077802ULL, 0x000fc80000000f00ULL,
0xfffeee3006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff197424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c0000302d2d7389ULL, 0x0002a200000e0033ULL,
0xfffeedf018007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000002900007348ULL, 0x000fe80003800000ULL, 0x00000027241f7389ULL, 0x0002a200000e0026ULL,
0xfffeedb014007950ULL, 0x000fea0003c3ffffULL, 0x000000011500780cULL, 0x000fe20003f25070ULL,
0x0000000800007348ULL, 0x000fd80003800000ULL, 0x0000000000157806ULL, 0x000fc800048e0100ULL,
0x00000008151c7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff157424ULL, 0x000fc800078e00ffULL,
0xfffeed5014007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000002b0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000920ULL, 0x00000000000005e4ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f04ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f28ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f38ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f58ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000fe8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000ff0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001200ULL, 0x0000000000011380ULL, 0x7300001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012580ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012590ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012590ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000012a10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000fe8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000011598ULL, 0x0000000000011598ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000012a10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_8_m_8_sm_86_cubin_len = 76528;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
