/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000012490ULL, 0x0000000000012010ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000010ed0ULL, 0x0000000000000180ULL, 0x000e002200000106ULL, 0x0000000000011050ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000011090ULL, 0x00000000000000f0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000011180ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00010ed000000000ULL, 0x0000040400000000ULL, 0x810c000000780400ULL, 0x00432c0400288080ULL,
0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808e0828808081ULL, 0x8016288080880828ULL,
0x0000000310288082ULL, 0x8088920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x00010ed000000000ULL, 0x0000018000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0xb0082880808e0828ULL, 0x288080b408288080ULL,
0x828016288080a808ULL, 0x0000000003102880ULL, 0x8080a89200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x000000e800000000ULL, 0x0001105000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0xb4082880808e0828ULL,
0x288080b008288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b0ULL,
0x0000001cffffffffULL, 0x0000017000000000ULL, 0x0001109000000000ULL, 0x000000f000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000a4ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000dULL, 0x000c170400501903ULL,
0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL,
0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000fdc000183104ULL, 0x0001016000010140ULL, 0x0001023000010220ULL, 0x00c8290400010240ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0500001e0500001eULL, 0x0500001e0500001eULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000b000c82804ULL, 0x00001cb0000000e0ULL, 0x000033c000003300ULL,
0x000034a000003470ULL, 0x00003950000038f0ULL, 0x0000575000004100ULL, 0x000058b0000057f0ULL,
0x00005d0000005900ULL, 0x0000649000005d10ULL, 0x00006800000064c0ULL, 0x0000948000006810ULL,
0x00009970000094a0ULL, 0x0000fac000009990ULL, 0x0000fb000000faf0ULL, 0x0000fb300000fb10ULL,
0x0000fb700000fb50ULL, 0x000102100000fb80ULL, 0x0001028000010270ULL, 0x000108d000010290ULL,
0x000109d000010950ULL, 0x00010ac000010a50ULL, 0x00010ba000010b30ULL, 0x00010c8000010c10ULL,
0x00010d6000010cf0ULL, 0x00010e4000010de0ULL, 0x0110390400010ea0ULL, 0x000000ff00000160ULL,
0x003f010000023600ULL, 0x0000000b000001a0ULL, 0x003f013000023608ULL, 0x0000000b000001c0ULL,
0x003f013000023610ULL, 0x000000ff000003f0ULL, 0x003f010700023600ULL, 0x0000000400000540ULL,
0x003f010200000004ULL, 0x00000004000005d0ULL, 0x003f010100000000ULL, 0x0000001100003160ULL,
0x003f01060002360cULL, 0x0000001100003230ULL, 0x003f01060002360cULL, 0x00000011000040a0ULL,
0x003f010100023610ULL, 0x00000011000055a0ULL, 0x003f01060002362cULL, 0x0000001100005670ULL,
0x003f01060002362cULL, 0x00000011000061d0ULL, 0x003f010100023630ULL, 0x000000ff0000be90ULL,
0x003f010600023604ULL, 0x000000ff0000bf20ULL, 0x003f010600023604ULL, 0x000000760000f060ULL,
0x003f010600023614ULL, 0x000000760000f3c0ULL, 0x003f010600023614ULL, 0x0000007600010810ULL,
0x003f010100023608ULL, 0x00141c0400033803ULL, 0x0000a7f00000a3a0ULL, 0x0000bff00000bf70ULL,
0x0000040100010870ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000001dcULL, 0x0000001100000002ULL,
0x000000000000015cULL, 0x0000001100000002ULL, 0x00000000000000d4ULL, 0x0000001100000002ULL,
0x0000000000000044ULL, 0x0000001100000002ULL, 0x00000000000001b7ULL, 0x0000001100000002ULL,
0x0000000000000134ULL, 0x0000001100000002ULL, 0x00000000000000adULL, 0x0000001100000002ULL,
0x0000004043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x0000000000077919ULL, 0x000ea80000002100ULL,
0x00000000000c7919ULL, 0x000ee80000002700ULL, 0x0000000000797919ULL, 0x000f220000002600ULL,
0x0000000106007824ULL, 0x002fc800078e0203ULL, 0x00000080000b7824ULL, 0x104fe200078e0207ULL,
0x00000005ff7a7819ULL, 0x000fe20000011607ULL, 0x00001fff06007589ULL, 0x00066600000e0000ULL,
0x000000ff0b00720cULL, 0x040fe40003f05270ULL, 0x000000030b00780cULL, 0x040fe20003f24070ULL,
0x00001fff7a7a7589ULL, 0x000ea200000e0000ULL, 0x0000007f0b00780cULL, 0x000fe20003f44070ULL,
0x000060000c067625ULL, 0x008fd000078e000dULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe200078e00ffULL, 0x3fffffe000049802ULL, 0x000fe20000000f00ULL,
0x7fffffe0ff059424ULL, 0x000fe400078e00ffULL, 0xff317217ff0aa424ULL, 0x000fe200078e00ffULL,
0x02360002ff008388ULL, 0x0007e20000000a00ULL, 0x000000ff0000720cULL, 0x002fe20003f05270ULL,
0x3fffffc0ff089424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff099424ULL, 0x000fe200078e00ffULL,
0x023608040b009388ULL, 0x0007e8000000ca00ULL, 0x0234000a0b00a388ULL, 0x0007e80000004800ULL,
0x023610080b009388ULL, 0x0007e8000000ca00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000027000000947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x014e620000000000ULL,
0x0000580000027a02ULL, 0x008fe20000000f00ULL, 0x000000047a047824ULL, 0x000fc400078e00ffULL,
0x0000001079037824ULL, 0x000fe400078e00ffULL, 0x0000001002027824ULL, 0x000fe400078e00ffULL,
0x00000100ff0e7424ULL, 0x000fe400078e00ffULL, 0x0000000c02027224ULL, 0x000fe200078e0203ULL,
0x000000040d097211ULL, 0x042fe200078fe0ffULL, 0x000000100d047824ULL, 0x000fc600078e00ffULL,
0x00000002090b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000902037210ULL, 0x040fe40007ffe0ffULL,
0x0000000709087812ULL, 0x000fe200078ec0ffULL, 0x0000000102057824ULL, 0x000fe200078e020bULL,
0x000000070b0a7812ULL, 0x000fe200078ec0ffULL, 0x00005c0003027625ULL, 0x080fe200078e000eULL,
0x000000f0040f7812ULL, 0x000fe400078ec0ffULL, 0x0000000f08087812ULL, 0x100fe200078e780dULL,
0x00005c0005047625ULL, 0x000fe200078e000eULL, 0x0000000f0a0a7812ULL, 0x000fc400078e780dULL,
0x0000000f02027210ULL, 0x080fe20007f1e0ffULL, 0x0000001009087824ULL, 0x000fe200078e0208ULL,
0x0000000f04047210ULL, 0x000fe20007f3e0ffULL, 0x000000100b0a7824ULL, 0x000fe400078e020aULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000000408097819ULL, 0x000fe200000006ffULL,
0x000000ffff057224ULL, 0x000fe400008e0605ULL, 0x000000100a0b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c46ULL,
0x00000000040b7faeULL, 0x0003e8000b901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x02360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006067b7981ULL, 0x014ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000f220000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000004ff7c7e24ULL, 0x010fe2000f8e00ffULL,
0x000000ff7b787810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff787819ULL, 0x000fce0000011678ULL,
0x0000a33000008947ULL, 0x000fea0003800000ULL, 0x000236107a047811ULL, 0x00afe200078e20ffULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040304ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000017c097810ULL, 0x000fe20007ffe0ffULL, 0x000000020c007824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x002fe2000001167aULL, 0x0000000004ff7f8cULL, 0x0003e2000c80043fULL,
0x000000780900720cULL, 0x000fe40003f06070ULL, 0x0000580079077a10ULL, 0x000fe20007ffe0ffULL,
0x0000004003057824ULL, 0x000fe200078e00ffULL, 0x000000017a027812ULL, 0x000fc600078ec0ffULL,
0x0000580000007a24ULL, 0x000fe200078e0207ULL, 0x000000057c0a7211ULL, 0x000fca00078e40ffULL,
0x0000620000067a24ULL, 0x000fe200078e020aULL, 0x00000ad000008947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x0000000a7b077217ULL, 0x000fe20007800000ULL,
0x0000000203177824ULL, 0x000fe400078e0202ULL, 0x00000100ff227424ULL, 0x000fe400078e00ffULL,
0x0000000107077824ULL, 0x000fe200078e0a0aULL, 0x0001300017177811ULL, 0x000fc800078e70ffULL,
0x0000004007077817ULL, 0x000fe40003800000ULL, 0x00000003ff137819ULL, 0x002fe40000011604ULL,
0x0ffffff804097812ULL, 0x000fe400078ec0ffULL, 0x00000004130b7810ULL, 0x040fe40007ffe0ffULL,
0x00000008130d7810ULL, 0x000fe40007ffe0ffULL, 0x000000040b0c7212ULL, 0x0c0fe200078e3cffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x00000010131f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x0000000413087212ULL, 0x000fc400078e3cffULL,
0xfffffff80f107812ULL, 0x000fe200078ee20cULL, 0x000000081f157824ULL, 0x000fe200078e00ffULL,
0x00000007090a7812ULL, 0x000fe400078ef808ULL, 0x0000000c130f7810ULL, 0x000fe40007ffe0ffULL,
0x000000040d087212ULL, 0x080fe400078e3cffULL, 0x000000041f0c7212ULL, 0x000fe200078e3cffULL,
0x000000080f147824ULL, 0x000fe200078e00ffULL, 0x0000001c13257810ULL, 0x000fc40007ffe0ffULL,
0x0000001413217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff811127812ULL, 0x000fe400078ee208ULL,
0xfffffff815167812ULL, 0x000fe200078ee20cULL, 0x0000000825157824ULL, 0x000fe200078e00ffULL,
0x0000001813237810ULL, 0x000fe20007ffe0ffULL, 0x00000010121b7824ULL, 0x000fe200078e0217ULL,
0x000000040f097212ULL, 0x080fe400078e3cffULL, 0x0000000421087212ULL, 0x000fe200078e3cffULL,
0x00000008231a7824ULL, 0x000fe200078e00ffULL, 0x0000000321117819ULL, 0x000fc400000006ffULL,
0x00000004250c7212ULL, 0x080fe400078e3cffULL, 0xfffffff814147812ULL, 0x000fe400078ee209ULL,
0xfffffff811187812ULL, 0x000fe200078ee208ULL, 0x000000100a117824ULL, 0x100fe200078e0217ULL,
0x0000002013277810ULL, 0x000fe20007ffe0ffULL, 0x00000010141d7824ULL, 0x000fe200078e0217ULL,
0x0000000423097212ULL, 0x000fe400078e3cffULL, 0xfffffff8151c7812ULL, 0x000fe200078ee20cULL,
0x0000000802157824ULL, 0x000fe200078e00ffULL, 0x0000001306087210ULL, 0x000fe20007ffe0ffULL,
0x0000000827197824ULL, 0x000fe200078e00ffULL, 0x000000071300720cULL, 0x000fc40003f06070ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x000fe200078e0022ULL,
0x000000070b00720cULL, 0x080fe40003f26070ULL, 0x000000070d00720cULL, 0x080fe20003f46070ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x00000004270c7212ULL, 0x000fe200078e3cffULL,
0x00000001060d7824ULL, 0x000fe200078e020dULL, 0xfffffff815157812ULL, 0x000fe200078ee204ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0022ULL, 0x000000070f00720cULL, 0x000fc40003f66070ULL,
0xfffffff8191e7812ULL, 0x000fe200078ee20cULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x0000001710197211ULL, 0x000fe200078e20ffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0022ULL,
0x000000072700720cULL, 0x000fc60003f86070ULL, 0x0000001015087825ULL, 0x000fc800078e0008ULL,
0x00005e000f0e7625ULL, 0x000fe200078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000c101c46ULL, 0x000000071f00720cULL, 0x000fe40003f06070ULL,
0x00000010150a7825ULL, 0x000fc800078e000aULL, 0x00000010150c7825ULL, 0x000fe200078e000cULL,
0x000000000a197faeULL, 0x0005e2000c901c46ULL, 0x000000072100720cULL, 0x080fe40003f26070ULL,
0x00000001061f7824ULL, 0x000fe200078e021fULL, 0x000000000c1b7faeULL, 0x0007e2000d101c46ULL,
0x00000010150e7825ULL, 0x000fe200078e000eULL, 0x000000072300720cULL, 0x000fc60003f46070ULL,
0x00005e001f087625ULL, 0x082fe200078e0022ULL, 0x000000000e1d7faeULL, 0x0003e2000d901c46ULL,
0x000000072500720cULL, 0x000fe40003f66070ULL, 0x0000000106217824ULL, 0x000fe200078e0221ULL,
0x00000017161f7211ULL, 0x000fe200078e20ffULL, 0x0000000106237824ULL, 0x040fe400078e0223ULL,
0x0000000106257824ULL, 0x000fe400078e0225ULL, 0x00005e00210a7625ULL, 0x004fe200078e0022ULL,
0x0000002813217810ULL, 0x000fc60007ffe0ffULL, 0x0000000106107824ULL, 0x000fe200078e0227ULL,
0x0000003413277810ULL, 0x000fe20007ffe0ffULL, 0x00005e00230c7625ULL, 0x008fe200078e0022ULL,
0x0000002c13237810ULL, 0x000fc60007ffe0ffULL, 0x0000001015087825ULL, 0x000fc800078e0008ULL,
0x00005e00250e7625ULL, 0x082fe200078e0022ULL, 0x00000000081f7faeULL, 0x0003e2000c101c46ULL,
0x0000003013257810ULL, 0x000fe40007ffe0ffULL, 0x00005e0010107625ULL, 0x000fc800078e0022ULL,
0x0000001018197824ULL, 0x000fe400078e0217ULL, 0x00000010150a7825ULL, 0x000fe200078e000aULL,
0x00000024131f7810ULL, 0x002fc60007ffe0ffULL, 0x000000101a1b7824ULL, 0x000fe200078e0217ULL,
0x000000000a197faeULL, 0x0003e2000c901c46ULL, 0x00000010150c7825ULL, 0x000fe200078e000cULL,
0x000000171e097211ULL, 0x000fe400078e20ffULL, 0x000000041f087212ULL, 0x080fe200078e3cffULL,
0x000000101c1d7824ULL, 0x000fe200078e0217ULL, 0x000000000c1b7faeULL, 0x0005e2000d101c46ULL,
0x00000010150e7825ULL, 0x000fe200078e000eULL, 0x000000071f00720cULL, 0x080fe40003f06070ULL,
0x000000072100720cULL, 0x080fe20003f26070ULL, 0x0000001015107825ULL, 0x000fe200078e0010ULL,
0x0000003813197810ULL, 0x042fe20007ffe0ffULL, 0x000000000e1d7faeULL, 0x0003e2000d901c46ULL,
0x0000003c13137810ULL, 0x000fe20007ffe0ffULL, 0x000000081f0b7824ULL, 0x000fe200078e00ffULL,
0x00000004230a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000010097faeULL, 0x0007e2000e101c46ULL,
0x00000008230d7824ULL, 0x044fe200078e00ffULL, 0x000000072300720cULL, 0x080fe20003f46070ULL,
0x0000000821167824ULL, 0x000fe200078e00ffULL, 0x000000072500720cULL, 0x080fe20003f66070ULL,
0x00000001060c7824ULL, 0x040fe200078e0225ULL, 0x000000072700720cULL, 0x080fe20003f86070ULL,
0x00000008251a7824ULL, 0x000fe200078e00ffULL, 0x000000071900720cULL, 0x080fe20003fa6070ULL,
0x00000001060e7824ULL, 0x042fe200078e0227ULL, 0x000000071300720cULL, 0x000fe20003fc6070ULL,
0x0000000106077824ULL, 0x040fe200078e021fULL, 0x0000000421097212ULL, 0x008fe200078e3cffULL,
0x0000000106107824ULL, 0x040fe200078e0219ULL, 0xfffffff80b147812ULL, 0x000fe200078ee208ULL,
0x0000000106087824ULL, 0x040fe200078e0221ULL, 0xfffffff80d187812ULL, 0x000fe200078ee20aULL,
0x00000008271c7824ULL, 0x000fe200078e00ffULL, 0x00000023060a7210ULL, 0x040fe20007ffe0ffULL,
0x0000000813207824ULL, 0x000fe200078e00ffULL, 0x0000001306127210ULL, 0x000fe20007ffe0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0022ULL, 0x0000000419067212ULL, 0x000fc400078e3cffULL,
0xfffffff816167812ULL, 0x000fe200078ee209ULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x0000000425097212ULL, 0x000fe200078e3cffULL, 0x00005e0010107625ULL, 0x000fe200078e0022ULL,
0x00000004270b7212ULL, 0x080fe400078e3cffULL, 0x00000004130d7212ULL, 0x000fe200078e3cffULL,
0x00005e0012127625ULL, 0x080fe200078e0022ULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee209ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x00005e0008087625ULL, 0x000fe200078e0022ULL,
0xfffffff8191e7812ULL, 0x000fc400078ee206ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x00005e0007067625ULL, 0x000fe200078e0022ULL, 0x000000171a1d7211ULL, 0x000fc600078e20ffULL,
0x00005e000a0a7625ULL, 0x000fc800078e0022ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0022ULL,
0x0000001015067825ULL, 0x000fc800078e0006ULL, 0x0000001015087825ULL, 0x000fc800078e0008ULL,
0x00000010150a7825ULL, 0x000fc800078e000aULL, 0x00000010150c7825ULL, 0x000fc800078e000cULL,
0x00000010150e7825ULL, 0x000fc800078e000eULL, 0x0000001015107825ULL, 0x000fc800078e0010ULL,
0x0000001015127825ULL, 0x000fc800078e0012ULL, 0x0000001014157824ULL, 0x100fe400078e0217ULL,
0x0000001016197824ULL, 0x100fe400078e0217ULL, 0x00000010181b7824ULL, 0x100fe200078e0217ULL,
0x0000000006157faeULL, 0x0003e2000c101c46ULL, 0x000000101c1f7824ULL, 0x100fe400078e0217ULL,
0x000000101e217824ULL, 0x100fe200078e0217ULL, 0x0000000008197faeULL, 0x0003e2000c901c46ULL,
0x0000001020177824ULL, 0x000fc600078e0217ULL, 0x000000000a1b7faeULL, 0x0003e8000d101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000d901c46ULL, 0x000000000e1f7faeULL, 0x0003e8000e101c46ULL,
0x0000000010217faeULL, 0x0003e8000e901c46ULL, 0x0000000012177faeULL, 0x0003e2000f101c46ULL,
0x0000099000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000000000ULL,
0x00000100ff237424ULL, 0x000fc400078e00ffULL, 0x0000000802257824ULL, 0x000fe200078e00ffULL,
0x00000003ff077819ULL, 0x002fe40000011604ULL, 0x0ffffff804097812ULL, 0x000fe400078ec0ffULL,
0x0000000407087212ULL, 0x0c0fe400078e3cffULL, 0x0000000c070f7810ULL, 0x040fe40007ffe0ffULL,
0x00000004070b7810ULL, 0x040fe40007ffe0ffULL, 0x00000008070d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001060e7824ULL, 0x000fe200078e020fULL, 0x0000000709097812ULL, 0x000fe200078ef808ULL,
0x000000080b277824ULL, 0x000fe200078e00ffULL, 0x0000001807157810ULL, 0x000fe20007ffe0ffULL,
0x000000080d297824ULL, 0x000fe200078e00ffULL, 0x000000040f087212ULL, 0x000fc400078e3cffULL,
0x000000030f2b7819ULL, 0x000fe200000006ffULL, 0x0000000815317824ULL, 0x000fe200078e00ffULL,
0x0000001007117810ULL, 0x040fe40007ffe0ffULL, 0x0000001407137810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee208ULL, 0x00000008112d7824ULL, 0x000fe200078e00ffULL,
0x000000040b0a7212ULL, 0x080fe200078e3cffULL, 0x00000008132f7824ULL, 0x000fe200078e00ffULL,
0x000000040d0c7212ULL, 0x080fe200078e3cffULL, 0x0000000106107824ULL, 0x040fe200078e0211ULL,
0x0000000415087212ULL, 0x000fe200078e3cffULL, 0x0000000106127824ULL, 0x000fe200078e0213ULL,
0x00000024071b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff827277812ULL, 0x000fe400078ee20aULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x00000001061a7824ULL, 0x040fe200078e021bULL,
0x0000001c07177810ULL, 0x040fe40007ffe0ffULL, 0x0000002007197810ULL, 0x000fe40007ffe0ffULL,
0xfffffff831317812ULL, 0x000fe200078ee208ULL, 0x0000000817337824ULL, 0x000fe200078e00ffULL,
0x00000004110a7212ULL, 0x080fe200078e3cffULL, 0x0000000819357824ULL, 0x000fe200078e00ffULL,
0x00000004130c7212ULL, 0x080fe200078e3cffULL, 0x0000000106167824ULL, 0x040fe200078e0217ULL,
0x000000041b087212ULL, 0x040fe200078e3cffULL, 0x0000000106187824ULL, 0x000fe200078e0219ULL,
0x000000031b377819ULL, 0x000fc400000006ffULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee20aULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee20cULL, 0x00000028071d7810ULL, 0x040fe40007ffe0ffULL,
0x0000002c071f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff837377812ULL, 0x000fe200078ee208ULL,
0x0000000203087824ULL, 0x000fe200078e0202ULL, 0x00000004170a7212ULL, 0x080fe200078e3cffULL,
0x000000081d397824ULL, 0x000fe200078e00ffULL, 0x00000004190c7212ULL, 0x080fe200078e3cffULL,
0x000000081f3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee20aULL,
0x00000001061c7824ULL, 0x040fe200078e021dULL, 0xfffffff835357812ULL, 0x000fe200078ee20cULL,
0x00000001061e7824ULL, 0x000fe200078e021fULL, 0x000000041d0a7212ULL, 0x000fc400078e3cffULL,
0x000000041f0c7212ULL, 0x080fe400078e3cffULL, 0x0001300008247811ULL, 0x000fe400078e70ffULL,
0x00000034073d7810ULL, 0x040fe40007ffe0ffULL, 0x00000038073f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010091d7824ULL, 0x000fe200078e0224ULL, 0x0000003c07417810ULL, 0x040fe20007ffe0ffULL,
0x0000000106227824ULL, 0x040fe200078e023dULL, 0x0000000706087210ULL, 0x040fe20007ffe0ffULL,
0x0000000106267824ULL, 0x040fe200078e023fULL, 0x0000003007217810ULL, 0x000fe20007ffe0ffULL,
0x0000000106287824ULL, 0x040fe200078e0241ULL, 0xfffffff839397812ULL, 0x000fe200078ee20aULL,
0x00000001060a7824ULL, 0x040fe200078e020bULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20cULL,
0x00000001060c7824ULL, 0x040fe200078e020dULL, 0x0000001506147210ULL, 0x040fe20007ffe0ffULL,
0x00000008212a7824ULL, 0x000fe200078e00ffULL, 0x0000002106207210ULL, 0x000fe20007ffe0ffULL,
0x00005e0008067625ULL, 0x000fe200078e0023ULL, 0x000000043f087212ULL, 0x000fc400078e3cffULL,
0x000000033f117819ULL, 0x000fe200000006ffULL, 0x000000083d2c7824ULL, 0x000fe200078e00ffULL,
0x00000004210b7212ULL, 0x080fe200078e3cffULL, 0x00000008412e7824ULL, 0x000fe200078e00ffULL,
0x000000043d0d7212ULL, 0x080fe200078e3cffULL, 0x0000001027277824ULL, 0x100fe200078e0224ULL,
0x00000004410f7212ULL, 0x000fe200078e3cffULL, 0x0000001029297824ULL, 0x000fe200078e0224ULL,
0xfffffff825257812ULL, 0x000fe200078ee204ULL, 0x000000102b2b7824ULL, 0x000fe200078e0224ULL,
0xfffffff811417812ULL, 0x000fe200078ee208ULL, 0x00005e000a087625ULL, 0x000fe200078e0023ULL,
0xfffffff82a3d7812ULL, 0x000fc400078ee20bULL, 0xfffffff82c3f7812ULL, 0x000fe200078ee20dULL,
0x00005e000c0a7625ULL, 0x080fe200078e0023ULL, 0xfffffff82e437812ULL, 0x000fe400078ee20fULL,
0x000000242d2d7211ULL, 0x080fe200078e20ffULL, 0x00005e000e0c7625ULL, 0x000fe200078e0023ULL,
0x0000002439397211ULL, 0x000fc600078e20ffULL, 0x00005e00100e7625ULL, 0x000fc800078e0023ULL,
0x0000001025067825ULL, 0x000fc800078e0006ULL, 0x00005e0012107625ULL, 0x080fe200078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000061d7faeULL, 0x0003e6000b901c46ULL,
0x00005e0014127625ULL, 0x000fc800078e0023ULL, 0x00005e0016147625ULL, 0x000fc800078e0023ULL,
0x0000001025087825ULL, 0x000fc800078e0008ULL, 0x00005e0018167625ULL, 0x000fe200078e0023ULL,
0x0000000008277faeULL, 0x0005e6000b901c46ULL, 0x00000010250a7825ULL, 0x000fc800078e000aULL,
0x00005e001a187625ULL, 0x000fe200078e0023ULL, 0x000000000a297faeULL, 0x0005e6000b901c46ULL,
0x00000010250c7825ULL, 0x000fc800078e000cULL, 0x00005e001c1a7625ULL, 0x000fe200078e0023ULL,
0x000000000c2b7faeULL, 0x0005e6000b901c46ULL, 0x00000010250e7825ULL, 0x000fc800078e000eULL,
0x00005e001e067625ULL, 0x002fe200078e0023ULL, 0x000000000e2d7faeULL, 0x0005e6000b901c46ULL,
0x0000001025107825ULL, 0x000fc800078e0010ULL, 0x000000102f2f7824ULL, 0x000fe400078e0224ULL,
0x00005e00201c7625ULL, 0x000fc600078e0023ULL, 0x00000000102f7faeULL, 0x0005e2000b901c46ULL,
0x0000001025127825ULL, 0x000fc800078e0012ULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x00005e00221e7625ULL, 0x000fc600078e0023ULL, 0x0000000012317faeULL, 0x0005e2000b901c46ULL,
0x0000001025147825ULL, 0x000fc800078e0014ULL, 0x0000001033337824ULL, 0x000fe400078e0224ULL,
0x00005e0026207625ULL, 0x000fc600078e0023ULL, 0x0000000014337faeULL, 0x0005e2000b901c46ULL,
0x0000001025167825ULL, 0x000fc800078e0016ULL, 0x0000001035357824ULL, 0x000fe400078e0224ULL,
0x00005e0028227625ULL, 0x000fc600078e0023ULL, 0x0000000016357faeULL, 0x0005e2000b901c46ULL,
0x0000001025187825ULL, 0x000fc800078e0018ULL, 0x0000001037377824ULL, 0x000fe400078e0224ULL,
0x00000010251a7825ULL, 0x000fc600078e001aULL, 0x0000000018377faeULL, 0x0005e2000b901c46ULL,
0x0000001025067825ULL, 0x000fc600078e0006ULL, 0x000000001a397faeULL, 0x0005e2000b901c46ULL,
0x000000103b3b7824ULL, 0x000fe400078e0224ULL, 0x00000010251c7825ULL, 0x000fc600078e001cULL,
0x00000000063b7faeULL, 0x0005e2000b901c46ULL, 0x000000103d3d7824ULL, 0x000fe400078e0224ULL,
0x00000010251e7825ULL, 0x000fc600078e001eULL, 0x000000001c3d7faeULL, 0x0005e2000b901c46ULL,
0x000000103f3f7824ULL, 0x000fe400078e0224ULL, 0x0000001025207825ULL, 0x000fc600078e0020ULL,
0x000000001e3f7faeULL, 0x0005e2000b901c46ULL, 0x0000001041417824ULL, 0x000fe400078e0224ULL,
0x0000001025227825ULL, 0x000fc600078e0022ULL, 0x0000000020417faeULL, 0x0005e2000b901c46ULL,
0x0000001043437824ULL, 0x000fca00078e0224ULL, 0x0000000022437faeULL, 0x0005e4000b901c46ULL,
0x000000787c00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff31721700067802ULL, 0x006fe20000000f00ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000465000000947ULL, 0x000fea0003800000ULL, 0x00000002030f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001003117824ULL, 0x000fe200078e00ffULL, 0x00007610ff087816ULL, 0x000fe20000000008ULL,
0xff317217ff067424ULL, 0x000fc400078e00ffULL, 0x000000ffff6d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x000000057c0c7211ULL, 0x000fc800078e40ffULL,
0x0000007b0c00720cULL, 0x000fda0003f06070ULL, 0x0000456000000947ULL, 0x000fea0003800000ULL,
0x000000017c097810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000780900720cULL, 0x000fe20003f06070ULL, 0x000000ffff097224ULL, 0x000fe200078e006dULL,
0x000000800c0c7810ULL, 0x000fe40007ffe0ffULL, 0x000000016d6d7812ULL, 0x000fc600078e0cffULL,
0x0000620000107a24ULL, 0x000fcc00078e020cULL, 0x00000ac000008947ULL, 0x000fea0003800000ULL,
0x00000003ff437819ULL, 0x000fe20000011604ULL, 0x0000000203147824ULL, 0x000fe200078e0202ULL,
0x0000000c7b0b7217ULL, 0x000fe20007800000ULL, 0x00000100ff127424ULL, 0x000fe200078e00ffULL,
0x00000004431d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000214147824ULL, 0x000fe200078e026dULL,
0x00000008431f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0a0cULL,
0x0000000c43357810ULL, 0x000fe20007ffe0ffULL, 0x000000081d347824ULL, 0x040fe200078e00ffULL,
0x000000041d0d7212ULL, 0x000fe200078e3cffULL, 0x000000081f137824ULL, 0x000fe200078e00ffULL,
0x00000010433f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000835387824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fc400078ee20dULL, 0x0000001843457810ULL, 0x000fe40007ffe0ffULL,
0x000000041f0c7212ULL, 0x080fe400078e3cffULL, 0x00000004350d7212ULL, 0x080fe200078e3cffULL,
0x00000008453e7824ULL, 0x000fe200078e00ffULL, 0x0000001443417810ULL, 0x000fe40007ffe0ffULL,
0x000000043f0e7212ULL, 0x040fe400078e3cffULL, 0x000000033f157819ULL, 0x000fc400000006ffULL,
0x0000001c43477810ULL, 0x000fe40007ffe0ffULL, 0xfffffff813367812ULL, 0x000fe200078ee20cULL,
0x0000000841137824ULL, 0x000fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe400078ee20dULL,
0x00000004450d7212ULL, 0x080fe400078e3cffULL, 0x0000002043497810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8153a7812ULL, 0x000fe200078ee20eULL, 0x0000000847157824ULL, 0x000fe200078e00ffULL,
0x00000004410c7212ULL, 0x000fc400078e3cffULL, 0x00000024434b7810ULL, 0x000fe40007ffe0ffULL,
0x00000004470e7212ULL, 0x080fe400078e3cffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x00000008490d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8133c7812ULL, 0x000fe200078ee20cULL,
0x000000084b137824ULL, 0x000fe200078e00ffULL, 0x00000004490c7212ULL, 0x000fe400078e3cffULL,
0xfffffff815407812ULL, 0x000fc400078ee20eULL, 0x00000028434d7810ULL, 0x000fe40007ffe0ffULL,
0x000000044b0e7212ULL, 0x080fe400078e3cffULL, 0xfffffff80d427812ULL, 0x000fe400078ee20cULL,
0x000000044d0c7212ULL, 0x040fe400078e3cffULL, 0x000000034d157819ULL, 0x000fe400000006ffULL,
0xfffffff8130e7812ULL, 0x000fc400078ee20eULL, 0x000000400b137817ULL, 0x000fe40003800000ULL,
0xfffffff8150c7812ULL, 0x000fe200078ee20cULL, 0x0000000143157824ULL, 0x040fe200078e0210ULL,
0x0000000743177812ULL, 0x100fe400078e4804ULL, 0x00000007040d7812ULL, 0x000fe400078ec0ffULL,
0x000000131d00720cULL, 0x040fe40003f26070ULL, 0x000000101d1d7210ULL, 0x000fe20007ffe0ffULL,
0x00000008020d7824ULL, 0x000fe200078e020dULL, 0x00013000140b7811ULL, 0x000fe200078e68ffULL,
0x00005e0015147625ULL, 0x000fe200078e0012ULL, 0x0ffffff817167812ULL, 0x000fc400078ef804ULL,
0x000000134300720cULL, 0x080fe20003f06070ULL, 0x00005e001d1c7625ULL, 0x080fe200078e0012ULL,
0x000000131f00720cULL, 0x080fe40003f46070ULL, 0x000000133500720cULL, 0x000fe20003f66070ULL,
0x000000011f1f7824ULL, 0x100fe200078e0210ULL, 0x0000000b363b7211ULL, 0x000fe200078e20ffULL,
0x0000000135357824ULL, 0x000fe200078e0210ULL, 0x000000134900720cULL, 0x000fe20003f86070ULL,
0x0000001016377824ULL, 0x000fe200078e020bULL, 0x0000002c434f7810ULL, 0x000fe20007ffe0ffULL,
0x00005e001f1e7625ULL, 0x000fc600078e0012ULL, 0x000000044f447212ULL, 0x000fe200078e3cffULL,
0x000000100d167825ULL, 0x000fc800078e0014ULL, 0x00005e0035147625ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016377faeULL, 0x0003e2000c101c46ULL,
0x000000133f00720cULL, 0x000fe40003f06070ULL, 0x0000001034397824ULL, 0x000fe400078e020bULL,
0x000000100d1c7825ULL, 0x000fc800078e001cULL, 0x000000100d1e7825ULL, 0x000fe200078e001eULL,
0x000000001c397faeULL, 0x0005e2000c901c46ULL, 0x000000134100720cULL, 0x080fe40003f26070ULL,
0x00000010383d7824ULL, 0x000fe200078e020bULL, 0x000000001e3b7faeULL, 0x0007e2000d101c46ULL,
0x000000100d347825ULL, 0x000fe200078e0014ULL, 0x000000134500720cULL, 0x000fc60003f46070ULL,
0x000000013f157824ULL, 0x100fe200078e0210ULL, 0x00000000343d7faeULL, 0x0009e2000d901c46ULL,
0x00000001413f7824ULL, 0x100fe200078e0210ULL, 0x0000001049397210ULL, 0x004fe20007ffe0ffULL,
0x0000000145417824ULL, 0x100fe200078e0210ULL, 0x000000134700720cULL, 0x040fe20003f66070ULL,
0x0000000147377824ULL, 0x002fe200078e0210ULL, 0x0000003443457810ULL, 0x000fe20007ffe0ffULL,
0x00005e0015167625ULL, 0x000fe200078e0012ULL, 0x0000003843477810ULL, 0x000fc60007ffe0ffULL,
0x00005e003f1c7625ULL, 0x000fe200078e0012ULL, 0x000000134700720cULL, 0x000fc60003fa6070ULL,
0x00005e00411e7625ULL, 0x088fe200078e0012ULL, 0x0000003043417810ULL, 0x040fe40007ffe0ffULL,
0x0000003c43437810ULL, 0x000fe20007ffe0ffULL, 0x00005e0037347625ULL, 0x010fc600078e0012ULL,
0x000000134300720cULL, 0x000fe20003fc6070ULL, 0x00005e0039367625ULL, 0x000fc800078e0012ULL,
0x000000103a157824ULL, 0x000fe400078e020bULL, 0x000000100d167825ULL, 0x000fc800078e0016ULL,
0x000000103c397824ULL, 0x000fe200078e020bULL, 0x0000000016157faeULL, 0x0003e2000c101c46ULL,
0x000000100d1c7825ULL, 0x000fe200078e001cULL, 0x000000134b00720cULL, 0x000fc60003f06070ULL,
0x000000103e3b7824ULL, 0x000fe200078e020bULL, 0x000000001c397faeULL, 0x0005e2000c901c46ULL,
0x000000100d1e7825ULL, 0x000fe200078e001eULL, 0x000000134d00720cULL, 0x000fc60003f26070ULL,
0x00000010403d7824ULL, 0x000fe200078e020bULL, 0x000000001e3b7faeULL, 0x0007e2000d101c46ULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x000000134f00720cULL, 0x080fe40003f46070ULL,
0x0000000445167212ULL, 0x082fe200078e3cffULL, 0x00000010423f7824ULL, 0x000fe200078e020bULL,
0x00000000343d7faeULL, 0x0003e2000d901c46ULL, 0x000000100d367825ULL, 0x000fe200078e0036ULL,
0x000000134100720cULL, 0x080fe40003f66070ULL, 0x00000004471c7212ULL, 0x0c4fe200078e3cffULL,
0x0000000147397824ULL, 0x100fe200078e0210ULL, 0x00000000363f7faeULL, 0x0005e2000e101c46ULL,
0x000000134500720cULL, 0x000fe20003f86070ULL, 0x0000000143137824ULL, 0x040fe200078e0210ULL,
0x00000004431e7212ULL, 0x008fe200078e3cffULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x000000104b177210ULL, 0x000fe20007ffe0ffULL, 0x0000000841347824ULL, 0x042fe200078e00ffULL,
0x0000000441157212ULL, 0x000fe200078e3cffULL, 0x0000000843437824ULL, 0x000fe200078e00ffULL,
0xfffffff8473c7812ULL, 0x000fe200078ee21cULL, 0x000000014d1d7824ULL, 0x000fc400078e0210ULL,
0x0000000145377824ULL, 0x144fe200078e0210ULL, 0x0000000345457819ULL, 0x000fe200000006ffULL,
0x000000014f1f7824ULL, 0x000fe200078e0210ULL, 0xfffffff8433e7812ULL, 0x000fe200078ee21eULL,
0x0000000141357824ULL, 0x000fe200078e0210ULL, 0xfffffff834107812ULL, 0x000fe200078ee215ULL,
0x000000084f517824ULL, 0x000fe200078e00ffULL, 0xfffffff8453a7812ULL, 0x000fe200078ee216ULL,
0x00005e0017167625ULL, 0x080fe200078e0012ULL, 0x0000000b0c157211ULL, 0x000fe400078e20ffULL,
0xfffffff851147812ULL, 0x000fe200078ee244ULL, 0x00005e001d1c7625ULL, 0x000fc800078e0012ULL,
0x00005e001f1e7625ULL, 0x000fc800078e0012ULL, 0x00005e0035347625ULL, 0x000fc800078e0012ULL,
0x00005e0037367625ULL, 0x000fc800078e0012ULL, 0x00005e0039387625ULL, 0x000fc800078e0012ULL,
0x00005e0013127625ULL, 0x000fc800078e0012ULL, 0x000000100d167825ULL, 0x000fc800078e0016ULL,
0x000000100d1c7825ULL, 0x000fc800078e001cULL, 0x000000100d1e7825ULL, 0x000fc800078e001eULL,
0x000000100d347825ULL, 0x000fc800078e0034ULL, 0x000000100d367825ULL, 0x000fc800078e0036ULL,
0x000000100d387825ULL, 0x000fc800078e0038ULL, 0x000000100d127825ULL, 0x000fc800078e0012ULL,
0x000000100e0d7824ULL, 0x100fe400078e020bULL, 0x00000010143b7824ULL, 0x100fe400078e020bULL,
0x00000010103d7824ULL, 0x100fe200078e020bULL, 0x00000000160d7faeULL, 0x0003e2000c101c46ULL,
0x000000103a3f7824ULL, 0x100fe400078e020bULL, 0x000000103c417824ULL, 0x100fe200078e020bULL,
0x000000001c157faeULL, 0x0003e2000c901c46ULL, 0x000000103e0b7824ULL, 0x000fc600078e020bULL,
0x000000001e3b7faeULL, 0x0003e8000d101c46ULL, 0x00000000343d7faeULL, 0x0003e8000d901c46ULL,
0x00000000363f7faeULL, 0x0003e8000e101c46ULL, 0x0000000038417faeULL, 0x0003e8000e901c46ULL,
0x00000000120b7faeULL, 0x0003e2000f101c46ULL, 0x0000098000007947ULL, 0x000fea0003800000ULL,
0x00000003ff0d7819ULL, 0x000fe40000011604ULL, 0x0000010000537802ULL, 0x000fc40000000f00ULL,
0x000000080d397810ULL, 0x040fe40007ffe0ffULL, 0x000000100d3d7810ULL, 0x000fe40007ffe0ffULL,
0x00000004391c7212ULL, 0x0c0fe200078e3cffULL, 0x0000000839137824ULL, 0x000fe200078e00ffULL,
0x000000140d3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000083d0c7824ULL, 0x040fe200078e00ffULL,
0x000000043d177212ULL, 0x080fe200078e3cffULL, 0x0000000139387824ULL, 0x100fe200078e0210ULL,
0x000000180d417810ULL, 0x000fe20007ffe0ffULL, 0x000000013d3c7824ULL, 0x100fe200078e0210ULL,
0x000000040d157810ULL, 0x000fe20007ffe0ffULL, 0x000000013f3e7824ULL, 0x000fe200078e0210ULL,
0xfffffff8131c7812ULL, 0x000fe200078ee21cULL, 0x000000083f137824ULL, 0x000fe200078e00ffULL,
0xfffffff80c177812ULL, 0x000fe200078ee217ULL, 0x00000008410c7824ULL, 0x000fe200078e00ffULL,
0x00000004150e7212ULL, 0x040fe200078e3cffULL, 0x0000000115147824ULL, 0x140fe200078e0210ULL,
0x00000003150b7819ULL, 0x000fe200000006ffULL, 0x0000000141407824ULL, 0x000fe200078e0210ULL,
0x0000000c0d3b7810ULL, 0x000fc40007ffe0ffULL, 0x000000043f347212ULL, 0x080fe400078e3cffULL,
0x000000280d497810ULL, 0x000fe40007ffe0ffULL, 0x00000004411f7212ULL, 0x000fe400078e3cffULL,
0x000000240d477810ULL, 0x000fe20007ffe0ffULL, 0x00000001494a7824ULL, 0x000fe200078e0210ULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee20eULL, 0x000000083b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff813347812ULL, 0x000fe200078ee234ULL, 0x0000000849137824ULL, 0x000fe200078e00ffULL,
0x000000200d457810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80c1f7812ULL, 0x000fe200078ee21fULL,
0x00000008470c7824ULL, 0x000fe200078e00ffULL, 0x000000043b167212ULL, 0x080fe200078e3cffULL,
0x0000000845127824ULL, 0x000fe200078e00ffULL, 0x0000000449367212ULL, 0x080fe200078e3cffULL,
0x0000000145467824ULL, 0x000fe200078e0210ULL, 0x0000001c0d437810ULL, 0x000fe40007ffe0ffULL,
0x0000000447357212ULL, 0x080fe400078e3cffULL, 0xfffffff80b167812ULL, 0x000fe200078ee216ULL,
0x0000000143447824ULL, 0x000fe200078e0210ULL, 0x00000004451d7212ULL, 0x000fc400078e3cffULL,
0x0000002c0d4b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff813367812ULL, 0x000fe400078ee236ULL,
0x00000004431e7212ULL, 0x000fe200078e3cffULL, 0x000000014b4c7824ULL, 0x000fe200078e0210ULL,
0x00000003430b7819ULL, 0x000fe400000006ffULL, 0xfffffff80c357812ULL, 0x000fe200078ee235ULL,
0x00000002030c7824ULL, 0x000fe200078e0202ULL, 0x0000000704137812ULL, 0x000fc400078ec0ffULL,
0xfffffff8121d7812ULL, 0x000fe200078ee21dULL, 0x000000084b127824ULL, 0x000fe200078e00ffULL,
0xfffffff80b1e7812ULL, 0x000fe200078ee21eULL, 0x000000020c377824ULL, 0x000fe200078e026dULL,
0x000000044b0b7212ULL, 0x000fe200078e3cffULL, 0x0000000802427824ULL, 0x000fe200078e0213ULL,
0x000000300d4d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010d0c7824ULL, 0x040fe200078e0210ULL,
0x000000070d137812ULL, 0x040fe400078e4804ULL, 0x000000380d517810ULL, 0x000fe20007ffe0ffULL,
0x000000084d5c7824ULL, 0x000fe200078e00ffULL, 0x000000340d4f7810ULL, 0x000fe20007ffe0ffULL,
0x000000014d4e7824ULL, 0x000fe200078e0210ULL, 0x0000003c0d5d7810ULL, 0x000fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0053ULL, 0xfffffff8120b7812ULL, 0x000fc400078ee20bULL,
0x0001300037377811ULL, 0x000fe200078e68ffULL, 0x0000000851627824ULL, 0x000fe200078e00ffULL,
0x0ffffff813127812ULL, 0x000fe200078ef804ULL, 0x000000085d647824ULL, 0x000fe200078e00ffULL,
0x000000044d137212ULL, 0x080fe200078e3cffULL, 0x000000014f507824ULL, 0x140fe200078e0210ULL,
0x000000044f157212ULL, 0x000fe200078e3cffULL, 0x0000000151527824ULL, 0x100fe200078e0210ULL,
0x000000034f5e7819ULL, 0x000fe200000006ffULL, 0x000000015d607824ULL, 0x000fe200078e0210ULL,
0x000000103b3a7210ULL, 0x000fe20007ffe0ffULL, 0x0000001012437824ULL, 0x000fe200078e0237ULL,
0x0000000451397212ULL, 0x000fe200078e3cffULL, 0x00000010420c7825ULL, 0x000fe200078e000cULL,
0x0000001047487210ULL, 0x000fc40007ffe0ffULL, 0x000000045d3b7212ULL, 0x000fe200078e3cffULL,
0x00000010165d7824ULL, 0x000fe200078e0237ULL, 0xfffffff85c107812ULL, 0x000fe200078ee213ULL,
0x00005e0014127625ULL, 0x080fe200078e0053ULL, 0xfffffff85e5c7812ULL, 0x000fe200078ee215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c437faeULL, 0x0003e2000b901c46ULL,
0xfffffff8625e7812ULL, 0x000fe200078ee239ULL, 0x00005e0038147625ULL, 0x000fe200078e0053ULL,
0xfffffff864627812ULL, 0x000fe400078ee23bULL, 0x000000371e617211ULL, 0x000fe200078e20ffULL,
0x00005e003a387625ULL, 0x000fe200078e0053ULL, 0x000000375c677211ULL, 0x000fc600078e20ffULL,
0x00005e003c3a7625ULL, 0x000fe200078e0053ULL, 0x000000370e437211ULL, 0x002fc600078e20ffULL,
0x00005e003e3c7625ULL, 0x000fc800078e0053ULL, 0x00005e00403e7625ULL, 0x000fc800078e0053ULL,
0x00005e0044407625ULL, 0x000fc800078e0053ULL, 0x00000010420c7825ULL, 0x000fc800078e0012ULL,
0x00005e0046447625ULL, 0x000fe200078e0053ULL, 0x000000000c437faeULL, 0x0003e6000b901c46ULL,
0x0000001042127825ULL, 0x000fc800078e0014ULL, 0x00005e0048467625ULL, 0x000fc800078e0053ULL,
0x0000001042147825ULL, 0x000fc800078e0038ULL, 0x00005e004a487625ULL, 0x000fc800078e0053ULL,
0x0000001042387825ULL, 0x000fc800078e003aULL, 0x00005e004c4a7625ULL, 0x000fc800078e0053ULL,
0x00000010423a7825ULL, 0x000fc800078e003cULL, 0x00005e004e4c7625ULL, 0x000fc800078e0053ULL,
0x00000010423c7825ULL, 0x000fc800078e003eULL, 0x00000010423e7825ULL, 0x000fc800078e0040ULL,
0x0000001042407825ULL, 0x000fc800078e0044ULL, 0x0000001042447825ULL, 0x000fc800078e0046ULL,
0x0000001042467825ULL, 0x000fc800078e0048ULL, 0x0000001042487825ULL, 0x000fc800078e004aULL,
0x00000010424a7825ULL, 0x000fc800078e004cULL, 0x000000101c4d7824ULL, 0x100fe400078e0237ULL,
0x0000001017177824ULL, 0x100fe400078e0237ULL, 0x00000010345f7824ULL, 0x100fe200078e0237ULL,
0x00000000124d7faeULL, 0x0003e2000b901c46ULL, 0x000000101f1f7824ULL, 0x100fe400078e0237ULL,
0x00005e00504e7625ULL, 0x080fe200078e0053ULL, 0x00000000145d7faeULL, 0x0003e6000b901c46ULL,
0x00005e0052507625ULL, 0x080fe200078e0053ULL, 0x0000000038177faeULL, 0x0003e6000b901c46ULL,
0x000000101d1d7824ULL, 0x000fe200078e0237ULL, 0x000000003a5f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0060527625ULL, 0x000fc600078e0053ULL, 0x000000003c1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001035357824ULL, 0x100fe400078e0237ULL, 0x0000001036637824ULL, 0x100fe200078e0237ULL,
0x000000003e617faeULL, 0x0003e2000b901c46ULL, 0x000000100b0b7824ULL, 0x100fe400078e0237ULL,
0x0000001010657824ULL, 0x000fe200078e0237ULL, 0x00000000401d7faeULL, 0x0003e2000b901c46ULL,
0x00000010424e7825ULL, 0x000fc600078e004eULL, 0x0000000044357faeULL, 0x0003e2000b901c46ULL,
0x0000001042507825ULL, 0x000fc600078e0050ULL, 0x0000000046637faeULL, 0x0003e2000b901c46ULL,
0x000000105e697824ULL, 0x000fe400078e0237ULL, 0x0000001042527825ULL, 0x000fe200078e0052ULL,
0x00000000480b7faeULL, 0x0003e6000b901c46ULL, 0x0000001062377824ULL, 0x000fe200078e0237ULL,
0x000000004a657faeULL, 0x0003e8000b901c46ULL, 0x000000004e677faeULL, 0x0003e8000b901c46ULL,
0x0000000050697faeULL, 0x0003e8000b901c46ULL, 0x0000000052377faeULL, 0x0003e4000b901c46ULL,
0x02360c00110d7984ULL, 0x002e620000000800ULL, 0x0000ffff080b7812ULL, 0x000fc600078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000088800b0b7816ULL, 0x000fca00000000ffULL,
0x800000000b0c7824ULL, 0x000fca00078e00ffULL, 0x800000000dff7812ULL, 0x002fe2000780480cULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000b0c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b000d7305ULL, 0x0002a4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x0000000d0000735dULL, 0x004fe40003800000ULL, 0x02360c00110d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc4000780480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000004040c7819ULL, 0x000fe400000006ffULL,
0x00000001ff0b7819ULL, 0x000fe40000011604ULL, 0x000000700c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fc600078ec0ffULL, 0x00000080030c7824ULL, 0x000fc800078e020cULL,
0x000000010c0b7824ULL, 0x000fca00078e020bULL, 0x023000000b0d7984ULL, 0x000e680000000800ULL,
0x023200000b6b7984ULL, 0x0004e20000000800ULL, 0x000000060d00720bULL, 0x002fda0003f1d000ULL,
0x00000000000c7806ULL, 0x000fc800000e0100ULL, 0x0000ffff0c107812ULL, 0x000fe2000780c0ffULL,
0x00000001ff0c7424ULL, 0x000fd800078e00ffULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x0000000d06157209ULL, 0x04cfe40007810000ULL, 0x000000060d00720bULL, 0x000fe40003f34000ULL,
0x0000007a0300720cULL, 0x000fe20003f05270ULL, 0x8000001506067221ULL, 0x000fe20000010000ULL,
0x00000002ff0c7819ULL, 0x000fc60000011604ULL, 0x3fb8aa3b060b7820ULL, 0x000fe20000410000ULL,
0x000000080c0e7810ULL, 0x000fca0007ffe0ffULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0x0000000000067806ULL, 0x000fc800008e0100ULL, 0x0000ffff06137812ULL, 0x000fe200078e3cffULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000001004127824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011604ULL, 0x00000070121d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c06177812ULL, 0x000fc600078ec0ffULL, 0x000000807a067824ULL, 0x000fca00078e021dULL,
0x0000000617067210ULL, 0x000fca0007ffe0ffULL, 0x0234001506007388ULL, 0x0005e40000000800ULL,
0x0000001310ff7212ULL, 0x000fe2000780c0ffULL, 0x00001f0c0b0c7589ULL, 0x002e6200000e0000ULL,
0x0000000b07077220ULL, 0x000fe40000410000ULL, 0x000000ffff067224ULL, 0x104fe200078e0015ULL,
0x00001f0e0b0e7589ULL, 0x0004f000000e0000ULL, 0x800000150d0d0221ULL, 0x000fe20000010000ULL,
0x00000001ff0b7807ULL, 0x004fc60000000000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d000a0308ULL, 0x000ea20000000800ULL, 0x0000000c19197220ULL, 0x082fe40000410000ULL,
0x0000000c18187220ULL, 0x080fe40000410000ULL, 0x0000000c21217220ULL, 0x080fe40000410000ULL,
0x0000000c20207220ULL, 0x080fe40000410000ULL, 0x0000000c25257220ULL, 0x080fe40000410000ULL,
0x0000000c24247220ULL, 0x000fc40000410000ULL, 0x0000000c29297220ULL, 0x080fe40000410000ULL,
0x0000000c28287220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c31317220ULL, 0x080fe40000410000ULL,
0x0000000c30307220ULL, 0x000fc40000410000ULL, 0x0000000c55557220ULL, 0x080fe40000410000ULL,
0x0000000c54547220ULL, 0x080fe40000410000ULL, 0x0000000c59597220ULL, 0x080fe40000410000ULL,
0x0000000c58587220ULL, 0x000fe20000410000ULL, 0x000076100b0c7816ULL, 0x000fe2000000000cULL,
0x0000000e1b1b7220ULL, 0x088fe40000410000ULL, 0x0000000e1a1a7220ULL, 0x000fc40000410000ULL,
0x0000000e23237220ULL, 0x080fe40000410000ULL, 0x0000000e22227220ULL, 0x080fe40000410000ULL,
0x0000000e27277220ULL, 0x080fe40000410000ULL, 0x0000000e26267220ULL, 0x080fe40000410000ULL,
0x0000000e2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000e2a2a7220ULL, 0x000fc40000410000ULL,
0x0000000e2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000e2e2e7220ULL, 0x080fe40000410000ULL,
0x0000000e33337220ULL, 0x080fe40000410000ULL, 0x0000000e32327220ULL, 0x080fe40000410000ULL,
0x0000000e57577220ULL, 0x080fe40000410000ULL, 0x0000000e56567220ULL, 0x000fc40000410000ULL,
0x0000000e5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000e5a5a7220ULL, 0x000fe40000410000ULL,
0x0000000a6b6b0220ULL, 0x004fe40000410000ULL, 0x0000000704137812ULL, 0x00cfe200078ec0ffULL,
0x0000000203687824ULL, 0x000fe200078e0202ULL, 0x00000004ff0d7819ULL, 0x000fe20000011604ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000008130e7812ULL, 0x000fe200078ef804ULL,
0x0000400068687824ULL, 0x000fe200078e00ffULL, 0x0000000804707812ULL, 0x000fe400078ec0ffULL,
0x000000070d0b7812ULL, 0x000fe400078e780eULL, 0x0000000770107812ULL, 0x040fe400078ec813ULL,
0x0000001370707212ULL, 0x000fe200078efcffULL, 0x000000080e0b7824ULL, 0x000fe200078e020bULL,
0x00000068096e7211ULL, 0x000fc400078e68ffULL, 0x0000000d105f7212ULL, 0x000fe200078e3cffULL,
0x000000100b6a7824ULL, 0x000fe200078e00ffULL, 0x000000020d397810ULL, 0x000fe40007ffe0ffULL,
0x000130006e6e7810ULL, 0x000fe20007ffe0ffULL, 0x0000080003347824ULL, 0x000fe200078e026aULL,
0x00000039105e7212ULL, 0x000fe200078e3cffULL, 0x0000000870677824ULL, 0x040fe200078e025fULL,
0x00000002ff697819ULL, 0x000fe40000011604ULL, 0x0000000aff0b723eULL, 0x000fe200000010ffULL,
0x011000003434783bULL, 0x000fe20000000200ULL, 0x00000010671c7824ULL, 0x000fe200078e026eULL,
0x00000008693b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000870667824ULL, 0x000fe200078e025eULL,
0x000054100b127816ULL, 0x000fc4000000000bULL, 0x000099100c0b7816ULL, 0x000fe200000000ffULL,
0x000000001c1c783bULL, 0x000fe20000004200ULL, 0x0000001066147824ULL, 0x000fe200078e026eULL,
0x000000040d5d7810ULL, 0x040fe40007ffe0ffULL, 0x00001f6912697589ULL, 0x000e6200000e0000ULL,
0x000000060d137810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0b00720cULL, 0x000fe20003f05270ULL,
0x000000001414783bULL, 0x000fe20000004200ULL, 0x0000005d105d7212ULL, 0x000fc400078e3cffULL,
0x0000001310137212ULL, 0x000fe200078e3cffULL, 0x00001f3b126c7589ULL, 0x0004e200000e0000ULL,
0x0000005d70657211ULL, 0x040fe400078e18ffULL, 0x0000000739397812ULL, 0x000fe200078e780eULL,
0x0000000870637824ULL, 0x040fe200078e0213ULL, 0x00000080700c7811ULL, 0x000fe200078e18ffULL,
0x00000010653c7824ULL, 0x100fe200078e026eULL, 0x00000004040b7811ULL, 0x000fe200078fe0ffULL,
0x000000080e397824ULL, 0x000fe400078e0239ULL, 0x0000001063387824ULL, 0x000fe200078e026eULL,
0x000000070b0b7812ULL, 0x000fe200078e780eULL, 0x0000001039647824ULL, 0x000fe200078e00ffULL,
0x000000003c3c783bULL, 0x000f220000004200ULL, 0x000000015e617824ULL, 0x100fe200078e020cULL,
0x0000010070127811ULL, 0x004fe200078e18ffULL, 0x000000015f627824ULL, 0x100fe200078e020cULL,
0x000000003838783bULL, 0x000ea20000004200ULL, 0x000000015d607824ULL, 0x100fe200078e020cULL,
0x000000125f5c7210ULL, 0x000fe20007ffe0ffULL, 0x00000001130c7824ULL, 0x000fe200078e020cULL,
0x0000006934348231ULL, 0x082fe200003400ffULL, 0x0000001062407824ULL, 0x000fe200078e026eULL,
0x0000006936368231ULL, 0x000fe200003400ffULL, 0x000000080e0b7824ULL, 0x000fe200078e020bULL,
0x0000006c35358231ULL, 0x088fe200003400ffULL, 0x000000015e0d7824ULL, 0x000fe200078e0212ULL,
0x0000006c37378231ULL, 0x000fe200003400ffULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000000100b107824ULL, 0x000fe200078e00ffULL, 0x00000006040b7811ULL, 0x000fe200078fe0ffULL,
0x000000100d507824ULL, 0x000fe200078e026eULL, 0x0000018070707811ULL, 0x000fe200078e18ffULL,
0x0000080003447824ULL, 0x000fe200078e0210ULL, 0x0000001c3458723cULL, 0x000fe40000041858ULL,
0x000000705e5e7210ULL, 0x000fe20007ffe0ffULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x000000015f5f7824ULL, 0x000fc600078e0270ULL, 0x00000064031c7211ULL, 0x000fe200078e58ffULL,
0x0000001e3454723cULL, 0x040fe20000041854ULL, 0x011000004444783bULL, 0x000e680000000200ULL,
0x011000001c1c783bULL, 0x000ee60000000200ULL, 0x000000143430723cULL, 0x040fee0000041830ULL,
0x0000001061147824ULL, 0x100fe200078e026eULL, 0x00000016342c723cULL, 0x040fea000004182cULL,
0x000000001414783bULL, 0x000f660000004200ULL, 0x0000003c3428723cULL, 0x050fee0000041828ULL,
0x0000006e603c7211ULL, 0x000fe200078e20ffULL, 0x000000383420723cULL, 0x044fee0000041820ULL,
0x000000100c387824ULL, 0x000fe200078e026eULL, 0x0000003e3424723cULL, 0x000fe20000041824ULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x0000006944448231ULL, 0x002fc400003400ffULL,
0x0000006946468231ULL, 0x080fe400003400ffULL, 0x000000691c1c8231ULL, 0x088fe400003400ffULL,
0x0000003a3434723cULL, 0x000fe20000041818ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x000000691e1e8231ULL, 0x000fe400003400ffULL, 0x0000006c1d1d8231ULL, 0x080fe400003400ffULL,
0x0000006c1f1f8231ULL, 0x000fc400003400ffULL, 0x0000006c45458231ULL, 0x080fe400003400ffULL,
0x0000006c47478231ULL, 0x000fc600003400ffULL, 0x000000141c30723cULL, 0x060fee0000041830ULL,
0x000000070b157812ULL, 0x000fe200078e780eULL, 0x000000015d0b7824ULL, 0x100fe200078e0212ULL,
0x000000161c2c723cULL, 0x000fe2000004182cULL, 0x0000000113127824ULL, 0x000fe200078e0212ULL,
0x000000150e0e7211ULL, 0x000fe200078e18ffULL, 0x000000105c147824ULL, 0x000fc400078e026eULL,
0x000000100b4c7824ULL, 0x100fe400078e026eULL, 0x0000001012487824ULL, 0x000fe200078e026eULL,
0x000000401c58723cULL, 0x040fe20000041858ULL, 0x000000001414783bULL, 0x000ee20000004200ULL,
0x000000100e0e7824ULL, 0x000fe400078e00ffULL, 0x0000000113137824ULL, 0x000fe200078e0270ULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x0000080003187824ULL, 0x000fe400078e020eULL,
0x000000015d5d7824ULL, 0x000fe200078e0270ULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x000000421c54723cULL, 0x000fe20000041854ULL, 0x000000105f407824ULL, 0x000fc400078e026eULL,
0x011000001818783bULL, 0x000f280000000200ULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x0000003c1c28723cULL, 0x044fee0000041828ULL, 0x000000105e3c7824ULL, 0x100fe200078e026eULL,
0x0000003e1c24723cULL, 0x040fea0000041824ULL, 0x000000003c3c783bULL, 0x000ea60000004200ULL,
0x000000381c20723cULL, 0x042fee0000041820ULL, 0x000000105d387824ULL, 0x000fe200078e026eULL,
0x0000003a1c1c723cULL, 0x000fea0000041834ULL, 0x000000003838783bULL, 0x000e640000004200ULL,
0x0000006e13347211ULL, 0x000fe200078e20ffULL, 0x000000144458723cULL, 0x008fe20000041858ULL,
0x0000006918188231ULL, 0x010fc800003400ffULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x000000691a1a8231ULL, 0x000fe400003400ffULL, 0x000000164454723cULL, 0x000fe20000041854ULL,
0x0000006c19198231ULL, 0x080fe400003400ffULL, 0x0000006c1b1b8231ULL, 0x000fca00003400ffULL,
0x000000504430723cULL, 0x040ff00000041830ULL, 0x00000052442c723cULL, 0x040ff0000004182cULL,
0x0000004c4428723cULL, 0x040ff00000041828ULL, 0x0000004e4424723cULL, 0x040ff00000041824ULL,
0x000000484420723cULL, 0x040ff00000041820ULL, 0x0000004a441c723cULL, 0x000ff0000004181cULL,
0x000000401858723cULL, 0x060ff00000041858ULL, 0x000000421854723cULL, 0x040ff00000041854ULL,
0x0000003c1830723cULL, 0x044ff00000041830ULL, 0x0000003e182c723cULL, 0x040ff0000004182cULL,
0x000000381828723cULL, 0x042ff00000041828ULL, 0x0000003a1824723cULL, 0x040ff00000041824ULL,
0x000000341820723cULL, 0x048ff00000041820ULL, 0x000000361818723cULL, 0x000fe2000004181cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000047c147824ULL, 0x000fe200078e020fULL,
0x0236100011ff7f8cULL, 0x0003e2000c80043fULL, 0x000000076b077221ULL, 0x000fc40000010000ULL,
0x0000004014147824ULL, 0x000fca00078e00ffULL, 0x0000007b1400720cULL, 0x000fda0003f06070ULL,
0x0000211000000947ULL, 0x000fea0003800000ULL, 0x000003007c147a10ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000114157810ULL, 0x040fe20007ffe0ffULL,
0x0000010014177824ULL, 0x000fc600078e0205ULL, 0x000000781500720cULL, 0x000fe20003f06070ULL,
0x00006200001c7a24ULL, 0x000fd800078e0217ULL, 0x00000ac000008947ULL, 0x000fea0003800000ULL,
0x00000003ff3d7819ULL, 0x000fe40000011604ULL, 0x000000177b147217ULL, 0x000fe40007800000ULL,
0x000000043d377810ULL, 0x040fe40007ffe0ffULL, 0x0000000c3d3b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000114167824ULL, 0x000fe200078e0a17ULL, 0x0000000437157212ULL, 0x040fe200078e3cffULL,
0x00000008371e7824ULL, 0x000fe200078e00ffULL, 0x000000103d4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000013b387824ULL, 0x000fe200078e021cULL, 0x000000083d397810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81e457812ULL, 0x000fe200078ee215ULL, 0x000000083b1e7824ULL, 0x040fe200078e00ffULL,
0x000000043b157212ULL, 0x080fe200078e3cffULL, 0x000000084b347824ULL, 0x040fe200078e00ffULL,
0x000000044b177212ULL, 0x080fe200078e3cffULL, 0x0000000139367824ULL, 0x100fe200078e021cULL,
0x000000143d4f7810ULL, 0x040fe40007ffe0ffULL, 0x000000183d537810ULL, 0x040fe40007ffe0ffULL,
0x0000001c3d6b7810ULL, 0x000fe20007ffe0ffULL, 0x000000084f517824ULL, 0x000fe200078e00ffULL,
0x0000000439147212ULL, 0x000fe200078e3cffULL, 0x000000014f427824ULL, 0x000fe200078e021cULL,
0x0000000339477819ULL, 0x000fc400000006ffULL, 0xfffffff81e497812ULL, 0x000fe200078ee215ULL,
0x00000008531e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8344d7812ULL, 0x000fe200078ee217ULL,
0x000000086b347824ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fe400078ee214ULL,
0x000000044f147212ULL, 0x080fe400078e3cffULL, 0x0000000453157212ULL, 0x080fe400078e3cffULL,
0x000000046b177212ULL, 0x000fc400078e3cffULL, 0x000000243d417810ULL, 0x040fe40007ffe0ffULL,
0x000000203d717810ULL, 0x040fe40007ffe0ffULL, 0x000000283d3f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff851517812ULL, 0x000fe200078ee214ULL, 0x0000000171407824ULL, 0x000fe200078e021cULL,
0xfffffff81e697812ULL, 0x000fe200078ee215ULL, 0x00000008411e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8346f7812ULL, 0x000fe200078ee217ULL, 0x000000083f347824ULL, 0x000fe200078e00ffULL,
0x0000000471147212ULL, 0x000fc400078e3cffULL, 0x0000000371737819ULL, 0x000fe400000006ffULL,
0x0000000109177812ULL, 0x000fe400078ec0ffULL, 0x0000000441157212ULL, 0x080fe400078e3cffULL,
0x0000000704357812ULL, 0x000fe200078ec0ffULL, 0x00002000171f7824ULL, 0x000fe200078e0268ULL,
0x000000043f1d7212ULL, 0x000fe400078e3cffULL, 0xfffffff873737812ULL, 0x000fe200078ee214ULL,
0x0000000802177824ULL, 0x000fe200078e0235ULL, 0xfffffff81e147812ULL, 0x000fc400078ee215ULL,
0x00000040163c7817ULL, 0x000fe40003800000ULL, 0xfffffff834157812ULL, 0x000fe200078ee21dULL,
0x00000100ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000001c3d1e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000137347824ULL, 0x000fe200078e021cULL, 0x000000073d357812ULL, 0x040fe400078e4804ULL,
0x0000003c3d00720cULL, 0x080fe40003f06070ULL, 0x000130001f167810ULL, 0x000fe20007ffe0ffULL,
0x00005e001e1e7625ULL, 0x000fe200078e001dULL, 0x0000003c3700720cULL, 0x000fc40003f26070ULL,
0x0ffffff835437812ULL, 0x000fe200078ef804ULL, 0x00005e0034347625ULL, 0x080fe200078e001dULL,
0x0000003c3900720cULL, 0x080fe40003f46070ULL, 0x0000003c3b00720cULL, 0x000fe20003f66070ULL,
0x00005e0036367625ULL, 0x080fe200078e001dULL, 0x0000002c3d757810ULL, 0x000fe40007ffe0ffULL,
0x0000001645457211ULL, 0x000fe200078e20ffULL, 0x00005e0038387625ULL, 0x000fe200078e001dULL,
0x00000004753e7212ULL, 0x000fc400078e3cffULL, 0x0000003c7100720cULL, 0x000fe20003f86070ULL,
0x0000001043437824ULL, 0x000fe400078e0216ULL, 0x00000010171e7825ULL, 0x000fc800078e001eULL,
0x0000000875777824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e437faeULL, 0x0003e2000c101c46ULL, 0x0000001017347825ULL, 0x000fe200078e0034ULL,
0x0000003c4b00720cULL, 0x000fc60003f06070ULL, 0x0000001047477824ULL, 0x000fe200078e0216ULL,
0x0000000034457faeULL, 0x0005e2000c901c46ULL, 0x00000010173a7825ULL, 0x000fe200078e0036ULL,
0xfffffff877377812ULL, 0x000fe400078ee23eULL, 0x0000003c4f00720cULL, 0x000fe20003f26070ULL,
0x0000001049497824ULL, 0x000fe200078e0216ULL, 0x000000003a477faeULL, 0x0007e2000d101c46ULL,
0x0000001017387825ULL, 0x000fe200078e0038ULL, 0x0000001c6b1e7210ULL, 0x002fe40007ffe0ffULL,
0x0000003c5300720cULL, 0x080fe20003f46070ULL, 0x000000014b367824ULL, 0x100fe200078e021cULL,
0x0000000038497faeULL, 0x0003e2000d901c46ULL, 0x00000001533e7824ULL, 0x000fe200078e021cULL,
0x0000003c6b00720cULL, 0x000fe20003f66070ULL, 0x00005e0042427625ULL, 0x000fe200078e001dULL,
0x000000303d4f7810ULL, 0x000fc40007ffe0ffULL, 0x000000383d537810ULL, 0x000fe20007ffe0ffULL,
0x00005e003e3a7625ULL, 0x008fc600078e001dULL, 0x0000003c5300720cULL, 0x000fe20003fa6070ULL,
0x00005e001e347625ULL, 0x004fc800078e001dULL, 0x00005e0036387625ULL, 0x002fc800078e001dULL,
0x00005e00401e7625ULL, 0x000fc800078e001dULL, 0x000000104d457824ULL, 0x000fe200078e0216ULL,
0x00000016734d7211ULL, 0x000fe200078e20ffULL, 0x0000001017387825ULL, 0x000fc800078e0038ULL,
0x0000001051477824ULL, 0x000fe200078e0216ULL, 0x0000000038457faeULL, 0x0003e2000c101c46ULL,
0x0000001017427825ULL, 0x000fe200078e0042ULL, 0x000000343d517810ULL, 0x040fe40007ffe0ffULL,
0x0000003c3d3d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001069497824ULL, 0x000fe200078e0216ULL,
0x0000000042477faeULL, 0x0005e2000c901c46ULL, 0x00000010173a7825ULL, 0x000fe200078e003aULL,
0x0000003c4100720cULL, 0x080fe40003f06070ULL, 0x0000003c3f00720cULL, 0x080fe20003f26070ULL,
0x000000106f4b7824ULL, 0x000fe200078e0216ULL, 0x000000003a497faeULL, 0x0007e2000d101c46ULL,
0x0000001017347825ULL, 0x000fe200078e0034ULL, 0x0000003c7500720cULL, 0x000fc40003f46070ULL,
0x0000003c3d00720cULL, 0x080fe20003fc6070ULL, 0x00000010171e7825ULL, 0x000fe200078e001eULL,
0x00000000344b7faeULL, 0x0009e2000d901c46ULL, 0x0000003c4f00720cULL, 0x0c0fe40003f66070ULL,
0x000000084f427824ULL, 0x004fe200078e00ffULL, 0x000000001e4d7faeULL, 0x0005e2000e101c46ULL,
0x0000003c5100720cULL, 0x040fe20003f86070ULL, 0x0000000851447824ULL, 0x040fe200078e00ffULL,
0x0000001c513c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000175387824ULL, 0x102fe200078e021cULL,
0x000000043d367212ULL, 0x080fe200078e3cffULL, 0x000000014f3a7824ULL, 0x108fe200078e021cULL,
0x0000000451357212ULL, 0x010fe200078e3cffULL, 0x000000013f347824ULL, 0x000fc400078e021cULL,
0x00000001533e7824ULL, 0x100fe200078e021cULL, 0x000000044f1f7212ULL, 0x084fe200078e3cffULL,
0x00000001411e7824ULL, 0x100fe200078e021cULL, 0xfffffff844457812ULL, 0x000fe200078ee235ULL,
0x000000013d407824ULL, 0x040fe200078e021cULL, 0xfffffff842437812ULL, 0x000fe200078ee21fULL,
0x000000083d497824ULL, 0x000fe200078e00ffULL, 0x00000004531c7212ULL, 0x040fe200078e3cffULL,
0x0000000853477824ULL, 0x000fe400078e00ffULL, 0x00005e001e1e7625ULL, 0x000fe200078e001dULL,
0xfffffff849497812ULL, 0x000fc400078ee236ULL, 0xfffffff847477812ULL, 0x000fe200078ee21cULL,
0x00005e0034347625ULL, 0x000fc800078e001dULL, 0x00005e0038387625ULL, 0x000fc800078e001dULL,
0x00005e003a3a7625ULL, 0x000fc800078e001dULL, 0x00005e003c3c7625ULL, 0x000fc800078e001dULL,
0x00005e003e3e7625ULL, 0x000fc800078e001dULL, 0x00005e0040407625ULL, 0x000fc800078e001dULL,
0x00000010171c7825ULL, 0x000fc800078e001eULL, 0x0000001017347825ULL, 0x000fc800078e0034ULL,
0x0000001017387825ULL, 0x000fc800078e0038ULL, 0x00000010173a7825ULL, 0x000fc800078e003aULL,
0x00000010173c7825ULL, 0x000fc800078e003cULL, 0x00000010173e7825ULL, 0x000fc800078e003eULL,
0x0000001017407825ULL, 0x000fe200078e0040ULL, 0x0000001614177211ULL, 0x000fc600078e20ffULL,
0x0000001015157824ULL, 0x100fe400078e0216ULL, 0x0000001037377824ULL, 0x100fe200078e0216ULL,
0x000000001c177faeULL, 0x0003e2000c101c46ULL, 0x00000010431f7824ULL, 0x100fe400078e0216ULL,
0x0000001045437824ULL, 0x100fe200078e0216ULL, 0x0000000034157faeULL, 0x0003e2000c901c46ULL,
0x0000001047457824ULL, 0x000fe200078e0216ULL, 0x0000001649477211ULL, 0x000fe400078e20ffULL,
0x0000000038377faeULL, 0x0003e8000d101c46ULL, 0x000000003a1f7faeULL, 0x0003e8000d901c46ULL,
0x000000003c437faeULL, 0x0003e8000e101c46ULL, 0x000000003e457faeULL, 0x0003e8000e901c46ULL,
0x0000000040477faeULL, 0x0003e2000f101c46ULL, 0x0000098000007947ULL, 0x000fea0003800000ULL,
0x00000003ff177819ULL, 0x000fe40000011604ULL, 0x00000100006e7802ULL, 0x000fc40000000f00ULL,
0x0000000c17377810ULL, 0x040fe40007ffe0ffULL, 0x00000004171f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000437527212ULL, 0x0c0fe200078e3cffULL, 0x0000000837157824ULL, 0x000fe200078e00ffULL,
0x0000001c17457810ULL, 0x000fe20007ffe0ffULL, 0x000000081f147824ULL, 0x040fe200078e00ffULL,
0x000000041f697212ULL, 0x080fe400078e3cffULL, 0xfffffff815527812ULL, 0x000fe200078ee252ULL,
0x0000000845157824ULL, 0x000fe200078e00ffULL, 0x0000001017397810ULL, 0x000fe20007ffe0ffULL,
0x0000000145477824ULL, 0x040fe200078e021cULL, 0x00000004454e7212ULL, 0x000fc400078e3cffULL,
0x00000024176f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001393b7824ULL, 0x000fe200078e021cULL,
0x00000014173d7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0047467625ULL, 0x000fe200078e006eULL,
0xfffffff814697812ULL, 0x000fe400078ee269ULL, 0xfffffff8154e7812ULL, 0x000fe200078ee24eULL,
0x0000000839147824ULL, 0x040fe200078e00ffULL, 0x0000000439517212ULL, 0x080fe200078e3cffULL,
0x000000086f157824ULL, 0x000fe200078e00ffULL, 0x0000001817417810ULL, 0x000fe20007ffe0ffULL,
0x000000083d1d7824ULL, 0x000fe200078e00ffULL, 0x000000046f4c7212ULL, 0x080fe200078e3cffULL,
0x000000013d3f7824ULL, 0x140fe200078e021cULL, 0x000000043d507212ULL, 0x000fe200078e3cffULL,
0x0000000141437824ULL, 0x000fe200078e021cULL, 0x0000002c17737810ULL, 0x000fe20007ffe0ffULL,
0x00005e003b3a7625ULL, 0x000fe200078e006eULL, 0x0000000817357810ULL, 0x000fc40007ffe0ffULL,
0xfffffff814517812ULL, 0x000fe200078ee251ULL, 0x00000001733d7824ULL, 0x000fe200078e021cULL,
0x00000004414f7212ULL, 0x000fe200078e3cffULL, 0x0000000835167824ULL, 0x000fe200078e00ffULL,
0x0000000341147819ULL, 0x000fe200000006ffULL, 0x00005e003f3e7625ULL, 0x080fe200078e006eULL,
0x0000002817717810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8154c7812ULL, 0x000fe200078ee24cULL,
0x00005e0043427625ULL, 0x000fe200078e006eULL, 0xfffffff81d507812ULL, 0x000fc400078ee250ULL,
0x0000000109157812ULL, 0x000fe200078ec0ffULL, 0x00000008731d7824ULL, 0x040fe200078e00ffULL,
0x00000004734a7212ULL, 0x080fe200078e3cffULL, 0x0000000171417824ULL, 0x040fe200078e021cULL,
0xfffffff8144f7812ULL, 0x000fe200078ee24fULL, 0x0000000871147824ULL, 0x000fe200078e00ffULL,
0x0000000435537212ULL, 0x080fe200078e3cffULL, 0x00002000156c7824ULL, 0x000fe200078e0268ULL,
0x0000002017497810ULL, 0x040fe20007ffe0ffULL, 0x0000000117157824ULL, 0x000fe200078e021cULL,
0x00000004714b7212ULL, 0x000fe200078e3cffULL, 0x00005e0041407625ULL, 0x000fe200078e006eULL,
0xfffffff81d4a7812ULL, 0x000fc400078ee24aULL, 0x00000007046b7812ULL, 0x000fe200078ec0ffULL,
0x00005e003d3c7625ULL, 0x080fe200078e006eULL, 0x00000007171d7812ULL, 0x000fe400078e4804ULL,
0xfffffff816537812ULL, 0x000fe200078ee253ULL, 0x0000000849167824ULL, 0x000fe200078e00ffULL,
0xfffffff8144b7812ULL, 0x000fe200078ee24bULL, 0x00005e0015147625ULL, 0x000fe200078e006eULL,
0x0000003417777810ULL, 0x000fe40007ffe0ffULL, 0x00000004494d7212ULL, 0x000fe200078e3cffULL,
0x00000008026b7824ULL, 0x000fe200078e026bULL, 0x0000003017757810ULL, 0x000fe20007ffe0ffULL,
0x0000000149497824ULL, 0x000fe200078e021cULL, 0x0000003817797810ULL, 0x000fe20007ffe0ffULL,
0x000000106b147825ULL, 0x000fe200078e0014ULL, 0x0000003c177d7810ULL, 0x000fc40007ffe0ffULL,
0x000130006c6c7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f177824ULL, 0x000fe200078e021cULL,
0x0ffffff81d1d7812ULL, 0x000fe200078ef804ULL, 0x00000001351f7824ULL, 0x100fe200078e021cULL,
0xfffffff8164d7812ULL, 0x000fe200078ee24dULL, 0x0000000177357824ULL, 0x140fe200078e021cULL,
0x0000000477717212ULL, 0x000fe200078e3cffULL, 0x0000000175397824ULL, 0x100fe200078e021cULL,
0x00000003771e7819ULL, 0x000fe200000006ffULL, 0x0000000875167824ULL, 0x000fe200078e00ffULL,
0x0000001c37377210ULL, 0x080fe20007ffe0ffULL, 0x0000000179777824ULL, 0x100fe200078e021cULL,
0x0000001c6f457210ULL, 0x000fe20007ffe0ffULL, 0x000000017d7f7824ULL, 0x000fe200078e021cULL,
0x00000004756f7212ULL, 0x080fe200078e3cffULL, 0x00000008791c7824ULL, 0x040fe200078e00ffULL,
0x0000000479737212ULL, 0x080fe200078e3cffULL, 0x000000087d347824ULL, 0x040fe200078e00ffULL,
0x000000047d757212ULL, 0x000fe200078e3cffULL, 0x000000101d1d7824ULL, 0x000fe200078e026cULL,
0xfffffff8166f7812ULL, 0x000fe200078ee26fULL, 0x00005e0017167625ULL, 0x000fe200078e006eULL,
0xfffffff81e717812ULL, 0x000fc400078ee271ULL, 0xfffffff81c737812ULL, 0x000fe200078ee273ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e2000b901c46ULL,
0xfffffff834757812ULL, 0x000fe200078ee275ULL, 0x00005e001f1e7625ULL, 0x000fe200078e006eULL,
0x0000006c69697211ULL, 0x080fe400078e20ffULL, 0x0000006c4e797211ULL, 0x000fe200078e20ffULL,
0x00005e0037367625ULL, 0x000fe200078e006eULL, 0x0000006c71717211ULL, 0x000fc600078e20ffULL,
0x00005e0049487625ULL, 0x000fc800078e006eULL, 0x00005e0045447625ULL, 0x000fc800078e006eULL,
0x00005e0039387625ULL, 0x000fc800078e006eULL, 0x00005e0035347625ULL, 0x000fc800078e006eULL,
0x00005e00771c7625ULL, 0x002fc800078e006eULL, 0x00005e007f147625ULL, 0x000fc800078e006eULL,
0x000000106b167825ULL, 0x000fc800078e0016ULL, 0x000000106b1e7825ULL, 0x040fe200078e001eULL,
0x0000000016697faeULL, 0x0003e6000b901c46ULL, 0x000000106b367825ULL, 0x000fc800078e0036ULL,
0x000000106b3a7825ULL, 0x000fc800078e003aULL, 0x000000106b3e7825ULL, 0x000fc800078e003eULL,
0x000000106b427825ULL, 0x000fc800078e0042ULL, 0x000000106b467825ULL, 0x000fc800078e0046ULL,
0x000000106b487825ULL, 0x000fc800078e0048ULL, 0x000000106b447825ULL, 0x000fc800078e0044ULL,
0x000000106b407825ULL, 0x000fc800078e0040ULL, 0x000000106b3c7825ULL, 0x000fc800078e003cULL,
0x000000106b387825ULL, 0x000fc800078e0038ULL, 0x000000106b347825ULL, 0x000fc800078e0034ULL,
0x000000106b1c7825ULL, 0x000fc800078e001cULL, 0x000000106b147825ULL, 0x000fc800078e0014ULL,
0x0000001053537824ULL, 0x100fe400078e026cULL, 0x00000010526b7824ULL, 0x100fe400078e026cULL,
0x0000001051517824ULL, 0x100fe200078e026cULL, 0x000000001e537faeULL, 0x0003e2000b901c46ULL,
0x0000001050777824ULL, 0x100fe400078e026cULL, 0x000000104f4f7824ULL, 0x100fe200078e026cULL,
0x00000000366b7faeULL, 0x0003e2000b901c46ULL, 0x000000104d4d7824ULL, 0x000fc400078e026cULL,
0x000000104c7d7824ULL, 0x100fe200078e026cULL, 0x000000003a517faeULL, 0x0003e2000b901c46ULL,
0x000000104b4b7824ULL, 0x100fe400078e026cULL, 0x000000104a7f7824ULL, 0x100fe200078e026cULL,
0x000000003e777faeULL, 0x0003e2000b901c46ULL, 0x000000106f6f7824ULL, 0x100fe400078e026cULL,
0x0000001073737824ULL, 0x100fe200078e026cULL, 0x00000000424f7faeULL, 0x0003e2000b901c46ULL,
0x0000001075757824ULL, 0x000fc600078e026cULL, 0x0000000046797faeULL, 0x0003e8000b901c46ULL,
0x00000000484d7faeULL, 0x0003e8000b901c46ULL, 0x00000000447d7faeULL, 0x0003e8000b901c46ULL,
0x00000000404b7faeULL, 0x0003e8000b901c46ULL, 0x000000003c7f7faeULL, 0x0003e8000b901c46ULL,
0x00000000386f7faeULL, 0x0003e8000b901c46ULL, 0x0000000034717faeULL, 0x0003e8000b901c46ULL,
0x000000001c737faeULL, 0x0003e8000b901c46ULL, 0x0000000014757faeULL, 0x0003e4000b901c46ULL,
0x02362c0011147984ULL, 0x002e620000000800ULL, 0x0000ffff08157812ULL, 0x000fc600078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000888015157816ULL, 0x000fca00000000ffULL,
0x8000000015177824ULL, 0x000fca00078e00ffULL, 0x8000000014ff7812ULL, 0x002fe20007804817ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x8000000015157824ULL, 0x000fe400078e00ffULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400167305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000160000735dULL, 0x004fe40003800000ULL, 0x02362c0011167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fc40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000404157819ULL, 0x000fe200000006ffULL,
0x00000001ff1c7424ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe40000011604ULL,
0x0000007015167812ULL, 0x000fe400078ec0ffULL, 0x0000000c14157812ULL, 0x000fc600078ec0ffULL,
0x000000800f147824ULL, 0x000fc800078e0216ULL, 0x0000000115147824ULL, 0x000fca00078e0214ULL,
0x0230000014157984ULL, 0x000e680000000800ULL, 0x0232000014507984ULL, 0x0004e20000000800ULL,
0x000000061500720bULL, 0x002fda0003f1d000ULL, 0x0000000000167806ULL, 0x000fc800000e0100ULL,
0x0000ffff16177812ULL, 0x000fda000780c0ffULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x00000015061f7209ULL, 0x04cfe40007810000ULL, 0x000000061500720bULL, 0x000fe40003f34000ULL,
0x0000007a0f00720cULL, 0x000fe20003f05270ULL, 0x8000001f06147221ULL, 0x000fe20000010000ULL,
0x00000002ff357819ULL, 0x000fc60000011604ULL, 0x3fb8aa3b14167820ULL, 0x000fc80000410000ULL,
0x00000016001e7308ULL, 0x0002a40000000800ULL, 0x0000000000147806ULL, 0x000fc800008e0100ULL,
0x0000ffff141c7812ULL, 0x000fe200078e3cffULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001004167824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fc80000011604ULL,
0x00000070161d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c14167812ULL, 0x000fe400078ec0ffULL,
0x0000001506147209ULL, 0x000fe20007810000ULL, 0x000000807a1d7824ULL, 0x000fca00078e021dULL,
0x0000001d161d7210ULL, 0x000fca0007ffe0ffULL, 0x023400141d007388ULL, 0x0003e40000000800ULL,
0x0000001c17ff7212ULL, 0x000fe2000780c0ffULL, 0x00001f351e147589ULL, 0x006e6200000e0000ULL,
0x00000008351d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001e07077220ULL, 0x000fe20000410000ULL,
0x0000001506067209ULL, 0x000fe40007810000ULL, 0x00000001ff1c7807ULL, 0x000fe20000000000ULL,
0x00001f1d1e167589ULL, 0x000eac00000e0000ULL, 0x8000001f15170221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL, 0x00000017000a0308ULL, 0x000ee20000000800ULL,
0x0000001458587220ULL, 0x082fe40000410000ULL, 0x0000001459597220ULL, 0x080fe40000410000ULL,
0x0000001454547220ULL, 0x080fe40000410000ULL, 0x0000001455557220ULL, 0x080fe40000410000ULL,
0x0000001430307220ULL, 0x080fe40000410000ULL, 0x0000001431317220ULL, 0x000fc40000410000ULL,
0x000000142c2c7220ULL, 0x080fe40000410000ULL, 0x000000142d2d7220ULL, 0x080fe40000410000ULL,
0x0000001428287220ULL, 0x080fe40000410000ULL, 0x0000001429297220ULL, 0x080fe40000410000ULL,
0x0000001424247220ULL, 0x080fe40000410000ULL, 0x0000001425257220ULL, 0x000fc40000410000ULL,
0x0000001420207220ULL, 0x080fe40000410000ULL, 0x0000001421217220ULL, 0x080fe40000410000ULL,
0x0000001418187220ULL, 0x080fe40000410000ULL, 0x0000001419197220ULL, 0x000fe40000410000ULL,
0x000000165a5a7220ULL, 0x084fe40000410000ULL, 0x000000165b5b7220ULL, 0x000fc40000410000ULL,
0x0000001656567220ULL, 0x080fe40000410000ULL, 0x0000001657577220ULL, 0x080fe40000410000ULL,
0x0000001632327220ULL, 0x080fe40000410000ULL, 0x0000001633337220ULL, 0x080fe40000410000ULL,
0x000000162e2e7220ULL, 0x080fe40000410000ULL, 0x000000162f2f7220ULL, 0x000fc40000410000ULL,
0x000000162a2a7220ULL, 0x080fe40000410000ULL, 0x000000162b2b7220ULL, 0x080fe40000410000ULL,
0x0000001626267220ULL, 0x080fe40000410000ULL, 0x0000001627277220ULL, 0x080fe40000410000ULL,
0x0000001622227220ULL, 0x080fe40000410000ULL, 0x0000001623237220ULL, 0x000fc40000410000ULL,
0x000000161a1a7220ULL, 0x080fe40000410000ULL, 0x000000161b1b7220ULL, 0x000fe40000410000ULL,
0x000000500a500220ULL, 0x008fe40000410000ULL, 0x000020006d527824ULL, 0x00cfe200078e0268ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000008000f387824ULL, 0x040fe200078e026aULL,
0x0001300052527810ULL, 0x000fe20007ffe0ffULL, 0x000008000f0e7824ULL, 0x000fe200078e020eULL,
0x00000002ff517819ULL, 0x000fe40000011604ULL, 0x0000000aff1d723eULL, 0x000fe200000010ffULL,
0x011000003838783bULL, 0x000fe20000000200ULL, 0x0000001066447824ULL, 0x100fe200078e0252ULL,
0x00000052633c7211ULL, 0x000fe200078e20ffULL, 0x0000001065407824ULL, 0x100fe200078e0252ULL,
0x0000000851687810ULL, 0x000fe20007ffe0ffULL, 0x0000001067147824ULL, 0x100fe200078e0252ULL,
0x000054101d1d7816ULL, 0x000fe2000000001dULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x000099101c1c7816ULL, 0x000fe200000000ffULL, 0x0000001061487824ULL, 0x000fe200078e0252ULL,
0x000000100f107211ULL, 0x040fe200078e58ffULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000000ff1c00720cULL, 0x000fe20003f05270ULL, 0x000008000f1c7824ULL, 0x000fc400078e0264ULL,
0x000000001414783bULL, 0x000fe20000004200ULL, 0x00000010604c7824ULL, 0x100fe400078e0252ULL,
0x0000001062347824ULL, 0x100fe200078e0252ULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x000000100c0c7824ULL, 0x100fe400078e0252ULL, 0x000000105e5e7824ULL, 0x000fe200078e0252ULL,
0x00001f511d517589ULL, 0x000e6800000e0000ULL, 0x00001f681d687589ULL, 0x000ea800000e0000ULL,
0x011000001c1c783bULL, 0x000ee80000000200ULL, 0x000000004848783bULL, 0x000f280000004200ULL,
0x000000004c4c783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x0000005138388231ULL, 0x002fc400003400ffULL, 0x000000513a3a8231ULL, 0x000fe400003400ffULL,
0x0000006839398231ULL, 0x084fe400003400ffULL, 0x000000683b3b8231ULL, 0x000fce00003400ffULL,
0x000000443830723cULL, 0x040fee0000041830ULL, 0x000000100d447824ULL, 0x000fe200078e0252ULL,
0x00000046382c723cULL, 0x000fe2000004182cULL, 0x000000511c1c8231ULL, 0x088fe400003400ffULL,
0x000000511e1e8231ULL, 0x000fc400003400ffULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x000000681d1d8231ULL, 0x080fe400003400ffULL, 0x000000403828723cULL, 0x000fe20000041828ULL,
0x000000681f1f8231ULL, 0x000fcc00003400ffULL, 0x000000100b407824ULL, 0x100fe200078e0252ULL,
0x000000143858723cULL, 0x040ff00000041858ULL, 0x000000163814723cULL, 0x040fee0000041854ULL,
0x000000525f547211ULL, 0x000fe200078e20ffULL, 0x000000423824723cULL, 0x040fe20000041824ULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x000000005454783bULL, 0x000fe60000004200ULL,
0x0000003c3820723cULL, 0x040fee0000041820ULL, 0x000000105c3c7824ULL, 0x100fe200078e0252ULL,
0x0000003e3838723cULL, 0x000fe20000041818ULL, 0x000000000c18783bULL, 0x000e680000004200ULL,
0x000000003c3c783bULL, 0x000fe60000004200ULL, 0x000000481c30723cULL, 0x050ff00000041830ULL,
0x0000004a1c48723cULL, 0x040fe2000004182cULL, 0x01100000102c783bULL, 0x000eae0000000200ULL,
0x0000004c1c28723cULL, 0x060fee0000041828ULL, 0x00000010124c7824ULL, 0x000fe200078e0252ULL,
0x0000004e1c24723cULL, 0x040fea0000041824ULL, 0x000000004c4c783bULL, 0x000ee60000004200ULL,
0x000000341c58723cULL, 0x040ff00000041858ULL, 0x000000361c14723cULL, 0x040fe20000041814ULL,
0x011000000e34783bULL, 0x000f2e0000000200ULL, 0x000000181c20723cULL, 0x002fe20000041820ULL,
0x000000512c2c8231ULL, 0x004fc400003400ffULL, 0x000000512e2e8231ULL, 0x000fe400003400ffULL,
0x000000682d2d8231ULL, 0x080fe400003400ffULL, 0x0000001013187824ULL, 0x000fe200078e0252ULL,
0x0000001a1c38723cULL, 0x000fe20000041838ULL, 0x000000682f2f8231ULL, 0x000fc800003400ffULL,
0x000000001818783bULL, 0x000e640000004200ULL, 0x000000105d1c7824ULL, 0x000fe200078e0252ULL,
0x0000003c2c58723cULL, 0x040fe20000041858ULL, 0x000000005e5c783bULL, 0x000ea80000004200ULL,
0x000000001c1c783bULL, 0x000f660000004200ULL, 0x0000004c2c20723cULL, 0x048ff00000041820ULL,
0x0000003e2c14723cULL, 0x000fe20000041814ULL, 0x0000005134348231ULL, 0x010fc400003400ffULL,
0x0000005136368231ULL, 0x000fe400003400ffULL, 0x0000006835358231ULL, 0x080fe400003400ffULL,
0x0000006837378231ULL, 0x000fe200003400ffULL, 0x000000442c30723cULL, 0x040ff00000041830ULL,
0x000000462c48723cULL, 0x040ff00000041848ULL, 0x000000402c28723cULL, 0x040ff00000041828ULL,
0x000000422c24723cULL, 0x040ff00000041824ULL, 0x0000004e2c38723cULL, 0x000ff00000041838ULL,
0x000000543458723cULL, 0x040ff00000041858ULL, 0x000000183420723cULL, 0x042ff00000041820ULL,
0x000000563454723cULL, 0x040ff00000041814ULL, 0x0000005c3430723cULL, 0x044ff00000041830ULL,
0x0000005e342c723cULL, 0x040ff00000041848ULL, 0x0000001c3428723cULL, 0x060ff00000041828ULL,
0x0000001e3424723cULL, 0x040ff00000041824ULL, 0x0000001a3418723cULL, 0x000fe20000041838ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fdc0000008000ULL, 0x0236300011ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000750077221ULL, 0x000fe20000010000ULL, 0x00000001096d7812ULL, 0x000fce00078ec0ffULL,
0x000003007c7c7a10ULL, 0x002fe40007ffe0ffULL, 0x000000ff08ff7812ULL, 0x000fc4000780c0ffULL,
0x000000787c00720cULL, 0x000fe40003f26070ULL, 0x00000001ff087807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffffba1000007947ULL, 0x000fea000383ffffULL,
0x00000000000c7919ULL, 0x000e620000000000ULL, 0x0000000203007824ULL, 0x000fe200078e00ffULL,
0x00000000000579c3ULL, 0x000ea40000002500ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000200057812ULL, 0x000fe400078e0cffULL, 0x000000077a007819ULL, 0x000fe400000006ffULL,
0x0000000105057812ULL, 0x000fe200078ef87aULL, 0x000000100c047824ULL, 0x002fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc4000001160cULL, 0x00000002ff0c7819ULL, 0x000fe4000001160cULL,
0x00000070040f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c08117812ULL, 0x000fe200078ec0ffULL,
0x0000008005087824ULL, 0x000fe200078e00ffULL, 0x000230000f047810ULL, 0x140fe40007ffe000ULL,
0x000232000f007810ULL, 0x040fe40007ffe000ULL, 0x000230000f097810ULL, 0x000fe20007ffe008ULL,
0x0000000111057824ULL, 0x000fe200078e0204ULL, 0x000232000f087810ULL, 0x000fe20007ffe008ULL,
0x0000000111047824ULL, 0x040fe200078e0200ULL, 0x0000000578007c0cULL, 0x004fe2000bf03070ULL,
0x0000000111097824ULL, 0x040fe200078e0209ULL, 0x0000000605007388ULL, 0x000fe20000000800ULL,
0x0000000111087824ULL, 0x000fc600078e0208ULL, 0x0000000704007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000009097984ULL, 0x000e680000000800ULL,
0x0000000008087984ULL, 0x000ea20000000800ULL, 0x00000006090b7209ULL, 0x002fca0007810000ULL,
0x000000060b007221ULL, 0x000fe40000010100ULL, 0x8000000b09097221ULL, 0x000fe40000010000ULL,
0x3fb8aa3b000a7820ULL, 0x000fe40000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x3fb8aa3b09097820ULL, 0x000fe20000410000ULL, 0x0000000a000d7308ULL, 0x000ef00000000800ULL,
0x0000000900097308ULL, 0x000ea20000000800ULL, 0x00001f0c0d057589ULL, 0x00872200000e0000ULL,
0x0000000800047811ULL, 0x002fe200078ff0ffULL, 0x0000000908087220ULL, 0x004fc80000410000ULL,
0x00001f040d067589ULL, 0x000e6200000e0000ULL, 0x000000070d0c7223ULL, 0x008fe40000010008ULL,
0x0000005805587220ULL, 0x050fe40000410000ULL, 0x0000005905597220ULL, 0x040fe40000410000ULL,
0x0000005405547220ULL, 0x040fe40000410000ULL, 0x0000005505557220ULL, 0x040fe40000410000ULL,
0x0000003005307220ULL, 0x000fc40000410000ULL, 0x0000003105317220ULL, 0x040fe40000410000ULL,
0x0000002c052c7220ULL, 0x040fe40000410000ULL, 0x0000002d052d7220ULL, 0x040fe40000410000ULL,
0x0000002805287220ULL, 0x040fe40000410000ULL, 0x0000002905297220ULL, 0x040fe40000410000ULL,
0x0000002405247220ULL, 0x000fc40000410000ULL, 0x0000002505257220ULL, 0x040fe40000410000ULL,
0x0000002005207220ULL, 0x040fe40000410000ULL, 0x0000002105217220ULL, 0x040fe40000410000ULL,
0x0000001805187220ULL, 0x040fe40000410000ULL, 0x0000001905057220ULL, 0x000fe40000410000ULL,
0x0000005a065a7220ULL, 0x002fc40000410000ULL, 0x0000005b065b7220ULL, 0x040fe40000410000ULL,
0x0000005606567220ULL, 0x040fe40000410000ULL, 0x0000005706577220ULL, 0x040fe40000410000ULL,
0x0000003206327220ULL, 0x040fe40000410000ULL, 0x0000003306337220ULL, 0x040fe40000410000ULL,
0x0000002e062e7220ULL, 0x000fc40000410000ULL, 0x0000002f062f7220ULL, 0x040fe40000410000ULL,
0x0000002a062a7220ULL, 0x040fe40000410000ULL, 0x0000002b062b7220ULL, 0x040fe40000410000ULL,
0x0000002606267220ULL, 0x040fe40000410000ULL, 0x0000002706277220ULL, 0x040fe40000410000ULL,
0x0000002206227220ULL, 0x000fc40000410000ULL, 0x0000002306237220ULL, 0x040fe40000410000ULL,
0x0000001a061a7220ULL, 0x040fe40000410000ULL, 0x0000001b061b7220ULL, 0x000fe20000410000ULL,
0x0000033000000947ULL, 0x000fea0003800000ULL, 0x018000000c007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000c00077202ULL, 0x000fe40000000f00ULL, 0x0000677000087802ULL, 0x000fe40000000f00ULL,
0x0000a76000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000c00077308ULL, 0x000e640000001000ULL, 0xbf8000000c007423ULL, 0x002fc80000000007ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000007077223ULL, 0x000fe40000000007ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011600ULL, 0x0000000800047811ULL, 0x000fc800078ff0ffULL,
0x00001f0607067589ULL, 0x000e6800000e0000ULL, 0x00001f0407087589ULL, 0x000ea200000e0000ULL,
0x0000000658587220ULL, 0x082fe40000410000ULL, 0x0000000659597220ULL, 0x080fe40000410000ULL,
0x0000000654547220ULL, 0x080fe40000410000ULL, 0x0000000655557220ULL, 0x000fc40000410000ULL,
0x0000000630307220ULL, 0x080fe40000410000ULL, 0x0000000631317220ULL, 0x080fe40000410000ULL,
0x000000062c2c7220ULL, 0x080fe40000410000ULL, 0x000000062d2d7220ULL, 0x080fe40000410000ULL,
0x0000000628287220ULL, 0x080fe40000410000ULL, 0x0000000629297220ULL, 0x000fc40000410000ULL,
0x0000000624247220ULL, 0x080fe40000410000ULL, 0x0000000625257220ULL, 0x080fe40000410000ULL,
0x0000000620207220ULL, 0x080fe40000410000ULL, 0x0000000621217220ULL, 0x080fe40000410000ULL,
0x0000000618187220ULL, 0x080fe40000410000ULL, 0x0000000605057220ULL, 0x000fc40000410000ULL,
0x000000085a5a7220ULL, 0x084fe40000410000ULL, 0x000000085b5b7220ULL, 0x080fe40000410000ULL,
0x0000000856567220ULL, 0x080fe40000410000ULL, 0x0000000857577220ULL, 0x080fe40000410000ULL,
0x0000000832327220ULL, 0x080fe40000410000ULL, 0x0000000833337220ULL, 0x000fc40000410000ULL,
0x000000082e2e7220ULL, 0x080fe40000410000ULL, 0x000000082f2f7220ULL, 0x080fe40000410000ULL,
0x000000082a2a7220ULL, 0x080fe40000410000ULL, 0x000000082b2b7220ULL, 0x080fe40000410000ULL,
0x0000000826267220ULL, 0x080fe40000410000ULL, 0x0000000827277220ULL, 0x000fc40000410000ULL,
0x0000000822227220ULL, 0x080fe40000410000ULL, 0x0000000823237220ULL, 0x080fe40000410000ULL,
0x000000081a1a7220ULL, 0x080fe40000410000ULL, 0x000000081b1b7220ULL, 0x000fe40000410000ULL,
0x00000002ff3e7819ULL, 0x000fe20000011600ULL, 0x00000008040d7824ULL, 0x040fe200078e00ffULL,
0x000000180518723eULL, 0x000fe200000010ffULL, 0x0000000804097824ULL, 0x000fe200078e00ffULL,
0x00000004ff3c7212ULL, 0x000fe200078e33ffULL, 0x000000083e077824ULL, 0x000fe200078e00ffULL,
0x0000003eff147212ULL, 0x000fe200078e33ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000704057812ULL, 0x000fc400078ec0ffULL, 0xfffffff80d3c7812ULL, 0x000fe400078ee23cULL,
0xfffffff807147812ULL, 0x000fe400078ee214ULL, 0xfffffff809167812ULL, 0x000fe400078ee204ULL,
0x0000000105077812ULL, 0x040fe400078e3cffULL, 0x0000000205097812ULL, 0x040fe400078e3cffULL,
0x00000003050d7812ULL, 0x040fe200078e3cffULL, 0x00000008041c7824ULL, 0x040fe200078e0207ULL,
0x00000004050f7812ULL, 0x040fe200078e3cffULL, 0x00000008041e7824ULL, 0x000fe200078e0209ULL,
0x0000000505117812ULL, 0x000fc400078e3cffULL, 0x0000000605057812ULL, 0x000fe200078e3cffULL,
0x0000000804367824ULL, 0x040fe200078e020fULL, 0x0000000d04347211ULL, 0x040fe200078e18ffULL,
0x0000000804387824ULL, 0x000fe200078e0211ULL, 0x000000033e097819ULL, 0x000fe200000006ffULL,
0x00000008043a7824ULL, 0x000fe200078e0205ULL, 0x000000073e087812ULL, 0x000fe200078ec0ffULL,
0x0000000400057824ULL, 0x000fe200078e00ffULL, 0xfffffff809067812ULL, 0x000fe200078ee23eULL,
0x0000100002047824ULL, 0x000fe200078e00ffULL, 0x0000000108097812ULL, 0x000fc400078e3cffULL,
0x0000000c05077812ULL, 0x000fe200078ec0ffULL, 0x0000080003057824ULL, 0x000fe200078e0204ULL,
0x00000002080a7812ULL, 0x040fe400078e3cffULL, 0x00000003080d7812ULL, 0x000fe200078e3cffULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0x00000004080f7812ULL, 0x000fe200078e3cffULL,
0x000000083e0a7824ULL, 0x000fe200078e020aULL, 0x0000000508117812ULL, 0x000fe200078e3cffULL,
0x000000083e0e7824ULL, 0x000fe200078e020dULL, 0x0000000608127812ULL, 0x000fe200078e3cffULL,
0x000000083e087824ULL, 0x000fe200078e0209ULL, 0x000000585958723eULL, 0x000fe200000010ffULL,
0x0000000106097824ULL, 0x000fe200078e0207ULL, 0x0000000f3e107211ULL, 0x040fe200078e18ffULL,
0x000000083e067824ULL, 0x000fe200078e0211ULL, 0x0000000514147211ULL, 0x080fe200078e20ffULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x0000000510107211ULL, 0x080fe200078e20ffULL,
0x000000083e127824ULL, 0x000fe200078e0212ULL, 0x0000005809007388ULL, 0x0003e20000000800ULL,
0x000000100a0a7824ULL, 0x100fe200078e0205ULL, 0x0000000538387211ULL, 0x000fe200078e20ffULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x000000545554723eULL, 0x000fe200000010ffULL,
0x0000001034347824ULL, 0x100fe200078e0205ULL, 0x000000303130723eULL, 0x000fe200000010ffULL,
0x0000001016167824ULL, 0x100fe200078e0205ULL, 0x0000002c2d2c723eULL, 0x000fe200000010ffULL,
0x000000103c3c7824ULL, 0x100fe200078e0205ULL, 0x0000000e070f7210ULL, 0x000fe20007ffe0ffULL,
0x000000101c1c7824ULL, 0x100fe200078e0205ULL, 0x000000282928723eULL, 0x000fe200000010ffULL,
0x000000101e1e7824ULL, 0x100fe200078e0205ULL, 0x000000242524723eULL, 0x000fe200000010ffULL,
0x0000001036367824ULL, 0x100fe200078e0205ULL, 0x000000202120723eULL, 0x000fe200000010ffULL,
0x000000103a3a7824ULL, 0x100fe200078e0205ULL, 0x000000222322723eULL, 0x000fe200000010ffULL,
0x0000001006067824ULL, 0x100fe200078e0205ULL, 0x0000001a1b1a723eULL, 0x000fe200000010ffULL,
0x0000000107097824ULL, 0x042fe200078e0208ULL, 0x00000034071d7210ULL, 0x000fe20007ffe0ffULL,
0x0000001012127824ULL, 0x000fe200078e0205ULL, 0x0000005a5b5a723eULL, 0x000fe200000010ffULL,
0x00000001070d7824ULL, 0x040fe200078e020aULL, 0x0000005409007388ULL, 0x000fe20000000800ULL,
0x0000000107117824ULL, 0x000fe200078e0210ULL, 0x000000565756723eULL, 0x000fe200000010ffULL,
0x0000000107177824ULL, 0x040fe200078e0216ULL, 0x000000300d007388ULL, 0x000fe20000000800ULL,
0x0000000107257824ULL, 0x000fe200078e023cULL, 0x000000323332723eULL, 0x000fe200000010ffULL,
0x0000000107157824ULL, 0x040fe200078e0214ULL, 0x0000002c0f007388ULL, 0x000fe20000000800ULL,
0x0000000107197824ULL, 0x000fe200078e021cULL, 0x0000002e2f2e723eULL, 0x000fe200000010ffULL,
0x00000001071b7824ULL, 0x040fe200078e021eULL, 0x0000002811007388ULL, 0x000fe20000000800ULL,
0x00000001071f7824ULL, 0x000fe200078e0236ULL, 0x0000002a2b2a723eULL, 0x000fe200000010ffULL,
0x0000000107217824ULL, 0x000fe200078e0238ULL, 0x000000262726723eULL, 0x000fe200000010ffULL,
0x0000000107237824ULL, 0x040fe200078e023aULL, 0x000000ff00087306ULL, 0x000fe20000205400ULL,
0x0000000107137824ULL, 0x000fc400078e0206ULL, 0x0000000107077824ULL, 0x000fe400078e0212ULL,
0x0000002003277824ULL, 0x000fe200078e0200ULL, 0x0000002413007388ULL, 0x000fe40000000800ULL,
0x000000ff00067306ULL, 0x000fe2000020d400ULL, 0x00000010270a7824ULL, 0x000fe200078e0204ULL,
0x0000002007007388ULL, 0x0003e80000000800ULL, 0x0000001815007388ULL, 0x000fe80000000800ULL,
0x0000005a17007388ULL, 0x000fe20000000800ULL, 0x000000ff00077306ULL, 0x002e660000209400ULL,
0x0000005619007388ULL, 0x000fe80000000800ULL, 0x000000321b007388ULL, 0x000fe80000000800ULL,
0x0000002e1d007388ULL, 0x000fe80000000800ULL, 0x0000002a1f007388ULL, 0x000fe20000000800ULL,
0x000000080700720bULL, 0x002fc60003f1d000ULL, 0x0000002621007388ULL, 0x000fe20000000800ULL,
0x0000000100077802ULL, 0x000fc60000000f00ULL, 0x0000002223007388ULL, 0x000fe80000000800ULL,
0x0000001a25007388ULL, 0x000fe40000000800ULL, 0x0000000106060812ULL, 0x000fe400078efcffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000030007007a0cULL, 0x000fe40003f05270ULL,
0x000000060608723eULL, 0x000fc600000010ffULL, 0x000000000a107984ULL, 0x000e680000000c00ULL,
0x000400000a2c7984ULL, 0x000ea80000000c00ULL, 0x000800000a147984ULL, 0x000ee80000000c00ULL,
0x000c00000a1c7984ULL, 0x000f220000000c00ULL, 0x3f803f8008137831ULL, 0x002fc40000200013ULL,
0x3f803f8008127831ULL, 0x040fe40000200012ULL, 0x3f803f8008117831ULL, 0x040fe40000200011ULL,
0x3f803f8008107831ULL, 0x040fe40000200010ULL, 0x3f803f80082f7831ULL, 0x044fe4000020002fULL,
0x3f803f80082e7831ULL, 0x040fe4000020002eULL, 0x3f803f80082d7831ULL, 0x000fc4000020002dULL,
0x3f803f80082c7831ULL, 0x000fe4000020002cULL, 0x3f803f8013137831ULL, 0x008fe40000200017ULL,
0x3f803f8012127831ULL, 0x000fe40000200016ULL, 0x3f803f8011117831ULL, 0x000fe40000200015ULL,
0x3f803f8010107831ULL, 0x000fe40000200014ULL, 0x3f803f802f2f7831ULL, 0x010fc4000020001fULL,
0x3f803f802e2e7831ULL, 0x000fe2000020001eULL, 0x000000100a007388ULL, 0x0003e20000000c00ULL,
0x3f803f802d2d7831ULL, 0x000fe4000020001dULL, 0x3f803f802c2c7831ULL, 0x000fca000020001cULL,
0x0004002c0a007388ULL, 0x0003e80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000030a000008947ULL, 0x000fea0003800000ULL, 0x00000000001a7919ULL, 0x000ea20000002700ULL,
0x00005800ff087624ULL, 0x000fe200078e00ffULL, 0x0000000103ff7812ULL, 0x000fe2000780f87aULL,
0x00001000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x0000080002097824ULL, 0x000fe200078e00ffULL, 0x0000004027197810ULL, 0x000fc40007ffe0ffULL,
0x000000000a107984ULL, 0x002e680000000c00ULL, 0x000400000a1c7984ULL, 0x0007220000000c00ULL,
0x000058001a1a7a24ULL, 0x004fe400078e0207ULL, 0x0000030008077a24ULL, 0x000fe400078e02ffULL,
0x000003001a087a24ULL, 0x000fe400078e02ffULL, 0x00006400070d7a24ULL, 0x000fc600078e02ffULL,
0x0000000508147c10ULL, 0x000fe4000fffe0ffULL, 0x00000fff0d077811ULL, 0x040fe400078e40ffULL,
0x01ffffff0d0a7812ULL, 0x008fe400078ec0ffULL, 0x00000014070e7211ULL, 0x000fca00078fa0ffULL,
0x00006a000e0e7625ULL, 0x000fca00078e000fULL, 0x000000090e0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000000ff0000720cULL, 0x000fc60000725670ULL,
0x0000001027167825ULL, 0x000fc800078e000eULL, 0x0000001019187825ULL, 0x000fe200078e000eULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000010000e7824ULL, 0x012fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011600ULL, 0x0000000114157824ULL, 0x000fe200078e020aULL,
0x00000080000d7802ULL, 0x000fe40000000f00ULL, 0x000000700e1b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0f207812ULL, 0x000fe200078ec0ffULL, 0x00006a00140e7625ULL, 0x000fc800078e000dULL,
0x00006a0015147625ULL, 0x000fe200078e000dULL, 0x0000000e200e7210ULL, 0x000fc80007a1e01bULL,
0x0000001420147210ULL, 0x000fe40007c7e01bULL, 0x0000000fff0f7210ULL, 0x000fe400007e44ffULL,
0x00000015ff157210ULL, 0x000fc60001fe84ffULL, 0x0000000b0e007986ULL, 0x0003e8000c101906ULL,
0x0000000c14007986ULL, 0x0003e4000c101906ULL, 0x0000001016007986ULL, 0x0123e2000c101d06ULL,
0x0000013000007945ULL, 0x000fe60003800000ULL, 0x0000001c18007986ULL, 0x0003e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000004ff0d7424ULL, 0x000fc600078e00ffULL,
0x000003000b0b7a10ULL, 0x000fe20007ffe1ffULL, 0x000068001a0c7625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b0c0c79a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0c00720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff0e7807ULL, 0x000fca0000000000ULL,
0x0000000eff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff0b7984ULL, 0x000ee40000000000ULL,
0x000000ff0b00720cULL, 0x008fda0003f05270ULL, 0x00002cb000008947ULL, 0x000fea0003800000ULL,
0x000000ff7a00720cULL, 0x000fda0003f05270ULL, 0x00000d6000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x00000001ff0c7819ULL, 0x000fe20000011600ULL, 0x00000010000b7824ULL, 0x000fe200078e00ffULL,
0x00000001080e7810ULL, 0x004fe20007ffe0ffULL, 0x00000080ff137424ULL, 0x002fe200078e00ffULL,
0x0000000c0c177812ULL, 0x000fe400078ec0ffULL, 0x000000700b157812ULL, 0x000fe200078ec0ffULL,
0x00006a00080c7625ULL, 0x000fc800078e0013ULL, 0x00006a000e0e7625ULL, 0x000fe200078e0013ULL,
0x0000000c170c7210ULL, 0x000fc8000791e015ULL, 0x0000000e170e7210ULL, 0x000fe40007b5e015ULL,
0x0000000dff0d7210ULL, 0x000fe400007e24ffULL, 0x0000000fff0f7210ULL, 0x000fc600017e64ffULL,
0x000000060c0b7981ULL, 0x000368000c1e1900ULL, 0x000000060e107981ULL, 0x000362000c1e1900ULL,
0x0000030000117a02ULL, 0x000fc80000000f00ULL, 0x000000021100780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002080c7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000c0c7625ULL, 0x000fca00078e0013ULL, 0x0000000c170c7210ULL, 0x000fc8000791e015ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c127981ULL, 0x000362000c1e1900ULL,
0x000000041100780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003080c7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0013ULL,
0x0000000c170c7210ULL, 0x000fc8000791e015ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c147981ULL, 0x000362000c1e1900ULL, 0x000000041100780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004080c7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000c0c7625ULL, 0x000fca00078e0013ULL, 0x0000000c170c7210ULL, 0x000fc8000791e015ULL,
0x0000000dff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c167981ULL, 0x000362000c1e1900ULL,
0x000000061100780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005080c7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0013ULL,
0x0000000c170c7210ULL, 0x000fc8000791e015ULL, 0x0000000dff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c187981ULL, 0x000362000c1e1900ULL, 0x000000061100780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081100780cULL, 0x002fe40003f06070ULL,
0x00000006080c7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000c0c7625ULL, 0x000fca00078e0013ULL,
0x0000000c170c7210ULL, 0x000fe40007a3e015ULL, 0x00000007080e0810ULL, 0x000fe40007ffe0ffULL,
0x0000000dff0d7210ULL, 0x000fc60000fe44ffULL, 0x00006a000e0e0625ULL, 0x000fe400078e0013ULL,
0x000000060c1a7981ULL, 0x000366000c1e1900ULL, 0x0000000e170e0210ULL, 0x000fc80007c7e015ULL,
0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL, 0x000000060e1c0981ULL, 0x000368000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x000000ffff0e7224ULL, 0x004fe400078e0008ULL, 0x000000ffff1e7224ULL, 0x020fe400078e000bULL,
0x000000ffff157224ULL, 0x000fc600078e00ffULL, 0x0000030013007a0cULL, 0x000fe40003f26070ULL,
0x0000000115157810ULL, 0x000fc80007ffe0ffULL, 0x0000000415007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x00000008130c7810ULL, 0x040fe40007ffe0ffULL,
0x00000001130d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001e0b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000080e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000004000f7819ULL, 0x000fe400000006ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00006a000c0c7625ULL, 0x000fe200078e000dULL,
0x000000700f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fc800078ec0ffULL,
0x0000000c110c7210ULL, 0x000fc80007b3e00fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c1e7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x00000009130c7810ULL, 0x042fe40007ffe0ffULL, 0x00000002130d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000100b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000090e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000010000f7824ULL, 0x000fe400078e00ffULL,
0x00006a000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000c10107812ULL, 0x000fe400078ec0ffULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000c100c7210ULL, 0x000fc80007b3e00fULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c107981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a130c7810ULL, 0x042fe40007ffe0ffULL,
0x00000003130d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x000000120b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a0e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000010000f7824ULL, 0x000fe400078e00ffULL, 0x00006a000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c11117812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000c110c7210ULL, 0x000fc80007b3e00fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c127981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b130c7810ULL, 0x042fe40007ffe0ffULL, 0x00000004130d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000140b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b0e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000004000f7819ULL, 0x000fe400000006ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00006a000c0c7625ULL, 0x000fe200078e000dULL, 0x000000700f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c11117812ULL, 0x000fc800078ec0ffULL, 0x0000000c110c7210ULL, 0x000fc80007b3e00fULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c147981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c130c7810ULL, 0x042fe40007ffe0ffULL,
0x00000005130d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x000000160b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c0e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011600ULL,
0x00000010000f7824ULL, 0x000fe400078e00ffULL, 0x00006a000c0c7625ULL, 0x000fe200078e000dULL,
0x0000000c11117812ULL, 0x000fe400078ec0ffULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000c110c7210ULL, 0x000fc80007b3e00fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c167981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d130c7810ULL, 0x042fe40007ffe0ffULL, 0x00000006130d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x000000180b0b7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d0e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000010000f7824ULL, 0x000fe400078e00ffULL,
0x00006a000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000c11117812ULL, 0x000fe400078ec0ffULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000c110c7210ULL, 0x000fc80007b3e00fULL,
0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL, 0x000000060c187981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e130c7810ULL, 0x042fe40007ffe0ffULL,
0x00000007130d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001a0b0b7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e0e0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000004000f7819ULL, 0x000fe400000006ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00006a000c0c7625ULL, 0x000fe200078e000dULL,
0x000000700f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c11117812ULL, 0x000fc800078ec0ffULL,
0x0000000c110c7210ULL, 0x000fc80007b3e00fULL, 0x0000000dff0d7210ULL, 0x000fca0000fe64ffULL,
0x000000060c1a7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f130c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001c0b0b7209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f0e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000001ff117819ULL, 0x000fe20000011600ULL, 0x00000010000f7824ULL, 0x000fe400078e00ffULL,
0x00006a000c0c7625ULL, 0x000fe200078e000dULL, 0x0000000c11117812ULL, 0x000fe400078ec0ffULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000c110c7210ULL, 0x000fc80007a3e00fULL,
0x0000000dff0d7210ULL, 0x000fca0000fe44ffULL, 0x000000060c1c7981ULL, 0x000368000c1e1900ULL,
0x0000000813137810ULL, 0x000fe40007ffe0ffULL, 0x000000080e0e7810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x00000010000c7824ULL, 0x00afe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0d0d7812ULL, 0x000fca00078ec0ffULL,
0x000000010c0c7824ULL, 0x000fca00078e020dULL, 0x0000000b0c007388ULL, 0x0203e40000000800ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011600ULL, 0x00001000ff117424ULL, 0x002fe200078e00ffULL,
0x0000000803187210ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000700d0e7812ULL, 0x004fe200078ec0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000002ff0b7819ULL, 0x000fe2000001167aULL, 0x000002007a7a7824ULL, 0x000fe200078e00ffULL,
0x00000018070c7211ULL, 0x000fe200078fa0ffULL, 0x0000000203108824ULL, 0x100fe200078e0202ULL,
0x000000010b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000010e297824ULL, 0x000fe200078e020fULL,
0x000008007a7a7812ULL, 0x000fe200078ec0ffULL, 0x00006a000c0c7625ULL, 0x000fe200078e0011ULL,
0x0000000b10178211ULL, 0x000fe200078e08ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000002000117810ULL, 0x000fe20007ffe0ffULL, 0x00000002030e8824ULL, 0x040fe200078e0202ULL,
0x000000090c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010a108824ULL, 0x000fe200078e0218ULL,
0x0000008000198802ULL, 0x000fe20000000f00ULL, 0x000000020e1f8824ULL, 0x000fe200078e020bULL,
0x0000004000137810ULL, 0x040fe20007ffe0ffULL, 0x00002000030b7824ULL, 0x040fe200078e0204ULL,
0x0000006000157810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000030003007a0cULL, 0x000fe20003f26070ULL, 0x000000010b0f7824ULL, 0x000fe200078e027aULL,
0x0000000029297984ULL, 0x000e620000000800ULL, 0x00000080ff1b8424ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000010001d7824ULL, 0x000fc400078e020fULL,
0x00000010110e7825ULL, 0x000fc800078e000cULL, 0x00006a0010108625ULL, 0x000fc800078e0019ULL,
0x0000001013127825ULL, 0x000fc800078e000cULL, 0x0000001015147825ULL, 0x000fc800078e000cULL,
0x00006a0018188625ULL, 0x000fc800078e001bULL, 0x0000000817218824ULL, 0x000fe400078e0200ULL,
0x00000010000c7825ULL, 0x000fc600078e000cULL, 0x0000458021218811ULL, 0x000fe200078e20ffULL,
0x000000081f1f8824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000c1d7faeULL, 0x0005e2000b901c46ULL, 0x0000001000168825ULL, 0x040fe400078e0010ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000041801f238811ULL, 0x000fe200078e20ffULL,
0x00000010001a8825ULL, 0x000fe200078e0018ULL, 0x003800000e1d7faeULL, 0x0007e2000b901c46ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00580000121d7faeULL, 0x0009e2000b901c46ULL,
0x00000000000c7805ULL, 0x004fc6000001ff00ULL, 0x00780000141d7faeULL, 0x0005e8000b901c46ULL,
0x0000000016218faeULL, 0x000be2000b901c46ULL, 0x00000000000e7805ULL, 0x008fc6000001ff00ULL,
0x000000001a238faeULL, 0x0007e2000b901c46ULL, 0x0000000000127805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000147805ULL, 0x004fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x020fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x008fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000df000001947ULL, 0x000fea0003800000ULL,
0x00000de000007945ULL, 0x002fe20003800000ULL, 0x000000ff000c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff327224ULL, 0x000fca00078e0003ULL, 0x0000000232317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff477224ULL, 0x000fe200078e0032ULL, 0x00000002ff2f7819ULL, 0x000fe20000011600ULL,
0x0000000203457824ULL, 0x000fe200078e0202ULL, 0x0000030031007a0cULL, 0x000fe20003f06070ULL,
0x0000004047307824ULL, 0x000fe200078e00ffULL, 0x000000072f337812ULL, 0x040fe200078ec0ffULL,
0x000000082f3e7824ULL, 0x040fe200078e00ffULL, 0x000000032f2e7819ULL, 0x048fe200000006ffULL,
0x000000082f357824ULL, 0x002fe200078e00ffULL, 0x0000008030307812ULL, 0x000fe200078ec0ffULL,
0x000003a000017945ULL, 0x000fe20003800000ULL, 0x0000002fff327212ULL, 0x000fe200078e33ffULL,
0x00000010004b7824ULL, 0x000fe200078e00ffULL, 0x000000012e407812ULL, 0x140fe200078ef633ULL,
0x0000010045457824ULL, 0x000fe200078e0030ULL, 0x000000022e427812ULL, 0x000fc400078ef633ULL,
0x000000032e447812ULL, 0x140fe400078ef633ULL, 0x000000042e467812ULL, 0x140fe400078ef633ULL,
0x000000052e487812ULL, 0x140fe400078ef633ULL, 0x000000062e4a7812ULL, 0x100fe400078ef633ULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee233ULL, 0xfffffff835527812ULL, 0x000fc400078ee232ULL,
0x000000082f2e7810ULL, 0x000fe20007ffe0ffULL, 0x000002c000000947ULL, 0x000fea0003800000ULL,
0x00000001083c7824ULL, 0x100fe200078e0231ULL, 0x000000070000780cULL, 0x000fe20003f24070ULL,
0x00001000ff337424ULL, 0x000fe200078e00ffULL, 0x00000001ff307819ULL, 0x000fe40000011631ULL,
0x0000003c07327211ULL, 0x000fe400078fa0ffULL, 0x0000000130347812ULL, 0x000fe200078ec0ffULL,
0x0000040031307824ULL, 0x000fe200078e00ffULL, 0x0000002000377810ULL, 0x000fe20007ffe0ffULL,
0x00006a0032327625ULL, 0x000fe200078e0033ULL, 0x0000004000397810ULL, 0x000fc40007ffe0ffULL,
0x0000080030307812ULL, 0x000fe200078ec0ffULL, 0x0000000203359824ULL, 0x040fe200078e0202ULL,
0x0000000203419211ULL, 0x000fe200078e08ffULL, 0x00000080ff3b9424ULL, 0x000fe200078e00ffULL,
0x0000000932327210ULL, 0x000fe20007f1e0ffULL, 0x0000000235499824ULL, 0x000fe200078e0234ULL,
0x0000003c0a3a9210ULL, 0x000fe20007ffe0ffULL, 0x000000010b357824ULL, 0x000fe200078e0230ULL,
0x0000006000437810ULL, 0x000fe20007ffe0ffULL, 0x0000000241419824ULL, 0x000fe400078e0234ULL,
0x000000ffff337224ULL, 0x000fc400000e0633ULL, 0x00000080ff3d9424ULL, 0x000fe400078e00ffULL,
0x00006a003a3a9625ULL, 0x000fc800078e003bULL, 0x00000010003f7824ULL, 0x040fe400078e0235ULL,
0x0000001000347825ULL, 0x000fc800078e0032ULL, 0x00006a003c3c9625ULL, 0x000fe200078e003dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000343f7faeULL, 0x0003e6000b901c46ULL,
0x0000001037367825ULL, 0x000fc800078e0032ULL, 0x0000001039387825ULL, 0x000fe200078e0032ULL,
0x00380000363f7faeULL, 0x0003e6000b901c46ULL, 0x0000000841419824ULL, 0x000fe200078e0200ULL,
0x00580000383f7faeULL, 0x0003e2000b901c46ULL, 0x0000001043327825ULL, 0x000fe200078e0032ULL,
0x0000000049439211ULL, 0x000fe400078e18ffULL, 0x0000458041419811ULL, 0x000fe200078e20ffULL,
0x00000010003a9825ULL, 0x040fe200078e003aULL, 0x0000418043439811ULL, 0x000fe200078e20ffULL,
0x00780000323f7faeULL, 0x0003e4000b901c46ULL, 0x00000010003c9825ULL, 0x000fc400078e003cULL,
0x000000003a419faeULL, 0x0003e8000b901c46ULL, 0x000000003c439faeULL, 0x0003e4000b901c46ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000001ff347819ULL, 0x002fe20000011600ULL, 0x0000040047307824ULL, 0x000fe200078e00ffULL,
0x000000704b4e7812ULL, 0x000fe200078ec0ffULL, 0x000000082e377824ULL, 0x000fe200078e00ffULL,
0x0000000c34357812ULL, 0x000fe200078ec0ffULL, 0x000000082e337824ULL, 0x040fe200078e00ffULL,
0x000000072e327812ULL, 0x000fc400078ec0ffULL, 0x0000004535457210ULL, 0x000fe20007ffe04eULL,
0x0000000400357824ULL, 0x000fe200078e00ffULL, 0x0000080030307812ULL, 0x000fe400078ec0ffULL,
0x0000002eff4e7212ULL, 0x000fe400078e33ffULL, 0xfffffff837347812ULL, 0x100fe400078ee232ULL,
0x0000000133367812ULL, 0x140fe400078ef632ULL, 0x0000000233387812ULL, 0x000fc400078ef632ULL,
0x00000003333a7812ULL, 0x140fe400078ef632ULL, 0x00000004333c7812ULL, 0x000fe200078ef632ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800045507984ULL, 0x000e620000000800ULL,
0x00000005334c7812ULL, 0x140fe400078ef632ULL, 0x0000000633327812ULL, 0x000fe200078ef632ULL,
0x0045800045457984ULL, 0x000fe20000000800ULL, 0x000001800b337810ULL, 0x000fe40007ffe030ULL,
0xfffffff8374e7812ULL, 0x000fe400078ee24eULL, 0x0000000c35357812ULL, 0x000fe200078ec0ffULL,
0x0000001044447824ULL, 0x100fe200078e0233ULL, 0x0000003340407211ULL, 0x080fe200078e20ffULL,
0x000000104e4e7824ULL, 0x100fe200078e0233ULL, 0x0000003334347211ULL, 0x080fe200078e20ffULL,
0x000000103e3e7824ULL, 0x100fe200078e0233ULL, 0x0000003332327211ULL, 0x000fe200078e20ffULL,
0x0000001042427824ULL, 0x100fe200078e0233ULL, 0x0000004435447210ULL, 0x040fe20007ffe0ffULL,
0x0000001046467824ULL, 0x100fe200078e0233ULL, 0x0000004e354e7210ULL, 0x000fe20007ffe0ffULL,
0x0000001048487824ULL, 0x000fc400078e0233ULL, 0x000000104a4a7824ULL, 0x100fe200078e0233ULL,
0x0000000044447984ULL, 0x000ea20000000800ULL, 0x0000001036367824ULL, 0x100fe400078e0233ULL,
0x0000001038387824ULL, 0x100fe200078e0233ULL, 0x000000004e4e7984ULL, 0x000ee20000000800ULL,
0x000000103a3a7824ULL, 0x100fe200078e0233ULL, 0x0000003635367210ULL, 0x000fe20007ffe0ffULL,
0x000000103c3c7824ULL, 0x100fe400078e0233ULL, 0x000000104c4c7824ULL, 0x000fc400078e0233ULL,
0x0000001052307824ULL, 0x000fe200078e0233ULL, 0x0000000036367984ULL, 0x000f220000000800ULL,
0x00000001353e7824ULL, 0x040fe400078e023eULL, 0x0000000135407824ULL, 0x040fe400078e0240ULL,
0x0000000135427824ULL, 0x040fe400078e0242ULL, 0x0000000135467824ULL, 0x040fe200078e0246ULL,
0x000000003e3e7984ULL, 0x000f620000000800ULL, 0x0000000135487824ULL, 0x000fc400078e0248ULL,
0x00000001354a7824ULL, 0x040fe200078e024aULL, 0x0000000040407984ULL, 0x000f620000000800ULL,
0x0000000135387824ULL, 0x040fe400078e0238ULL, 0x00000001353a7824ULL, 0x040fe200078e023aULL,
0x0000000042427984ULL, 0x000f620000000800ULL, 0x00000001353c7824ULL, 0x040fe400078e023cULL,
0x00000001354c7824ULL, 0x040fe200078e024cULL, 0x0000000046467984ULL, 0x000f620000000800ULL,
0x0000000135307824ULL, 0x000fc400078e0230ULL, 0x0000000135347824ULL, 0x040fe200078e0234ULL,
0x0000000048487984ULL, 0x000f620000000800ULL, 0x0000000135337824ULL, 0x000fe400078e0232ULL,
0x0000005029507221ULL, 0x002fe20000010100ULL, 0x000000004a4a7984ULL, 0x000e620000000800ULL,
0x000000ffff327224ULL, 0x000fe200078e0031ULL, 0x00005410ff527816ULL, 0x004fe20000000044ULL,
0x3fb8aa3b50507820ULL, 0x000fe20000410000ULL, 0x0000000038387984ULL, 0x000ea20000000800ULL,
0x00005410ff497816ULL, 0x008fc4000000004eULL, 0x0000030032007a0cULL, 0x000fe20003f06070ULL,
0x000000003a3a7984ULL, 0x000ee20000000800ULL, 0x0000005000507308ULL, 0x000f620000000800ULL,
0x00007610ff447816ULL, 0x000fe40000000044ULL, 0x000000003c3c7984ULL, 0x000ee20000000800ULL,
0x00005410ff5e7816ULL, 0x110fe40000000036ULL, 0x00007610ff607816ULL, 0x000fe20000000036ULL,
0x000000004c4c7984ULL, 0x000f220000000800ULL, 0x00007610ff4e7816ULL, 0x000fc6000000004eULL,
0x0000000030307984ULL, 0x000f220000000800ULL, 0x00005410ff397816ULL, 0x120fe4000000003eULL,
0x00007610ff3e7816ULL, 0x000fe2000000003eULL, 0x0000000034347984ULL, 0x000f620000000800ULL,
0x0000004550667220ULL, 0x000fe20000410000ULL, 0x00005410ff3b7816ULL, 0x000fe40000000040ULL,
0x0000000033337984ULL, 0x000f620000000800ULL, 0x00005410ff507816ULL, 0x000fe20000000042ULL,
0x0000002d662d7221ULL, 0x000fe20000010000ULL, 0x00007610ff407816ULL, 0x000fc40000000040ULL,
0x00005410ff547816ULL, 0x000fe40000000046ULL, 0x00007610ff427816ULL, 0x000fe40000000042ULL,
0x00005410ff567816ULL, 0x000fe40000000048ULL, 0x00007610ff467816ULL, 0x000fe40000000046ULL,
0x00005410ff3d7816ULL, 0x002fe4000000004aULL, 0x00007610ff487816ULL, 0x000fc40000000048ULL,
0x00005410ff417816ULL, 0x004fe40000000038ULL, 0x00007610ff4a7816ULL, 0x000fe4000000004aULL,
0x00005410ff627816ULL, 0x008fe4000000003aULL, 0x00007610ff387816ULL, 0x000fe40000000038ULL,
0x00005410ff437816ULL, 0x000fe4000000003cULL, 0x00007610ff3a7816ULL, 0x000fc4000000003aULL,
0x00005410ff457816ULL, 0x010fe4000000004cULL, 0x00007610ff3c7816ULL, 0x000fe4000000003cULL,
0x00005410ff587816ULL, 0x100fe40000000030ULL, 0x00007610ff5a7816ULL, 0x000fe40000000030ULL,
0x00005410ff5c7816ULL, 0x120fe40000000034ULL, 0x00007610ff3f7816ULL, 0x000fc40000000034ULL,
0x00007610ff4c7816ULL, 0x000fe4000000004cULL, 0x00005410ff647816ULL, 0x100fe40000000033ULL,
0x00007610ff477816ULL, 0x000fe20000000033ULL, 0x000074027f007947ULL, 0x000fea000b800000ULL,
0x00001f2f662f7589ULL, 0x0002a400000e0000ULL, 0x000074627f007947ULL, 0x000fea000b800000ULL,
0x00001f2e66317589ULL, 0x00072400000e0000ULL, 0x0000002f392c7223ULL, 0x084fe4000001002cULL,
0x0000002f3e2b7223ULL, 0x080fe4000001002bULL, 0x0000002f3b2a7223ULL, 0x080fe4000001002aULL,
0x0000002f40287223ULL, 0x000fc40000010028ULL, 0x0000002f50277223ULL, 0x080fe40000010027ULL,
0x0000002f42267223ULL, 0x080fe40000010026ULL, 0x0000002f52257223ULL, 0x080fe40000010025ULL,
0x0000002f44247223ULL, 0x080fe40000010024ULL, 0x0000002f54237223ULL, 0x080fe40000010023ULL,
0x0000002f46227223ULL, 0x000fc40000010022ULL, 0x0000002f56137223ULL, 0x080fe40000010013ULL,
0x0000002f48217223ULL, 0x080fe40000010021ULL, 0x0000002f3d0e7223ULL, 0x080fe4000001000eULL,
0x0000002f4a207223ULL, 0x080fe40000010020ULL, 0x0000002f580d7223ULL, 0x080fe4000001000dULL,
0x0000002f5a1f7223ULL, 0x000fc4000001001fULL, 0x000000315c0f7223ULL, 0x090fe4000001000fULL,
0x000000313f1e7223ULL, 0x080fe4000001001eULL, 0x000000315e177223ULL, 0x080fe40000010017ULL,
0x00000031601d7223ULL, 0x080fe4000001001dULL, 0x0000003141167223ULL, 0x080fe40000010016ULL,
0x00000031381c7223ULL, 0x000fc4000001001cULL, 0x0000003162157223ULL, 0x080fe40000010015ULL,
0x000000313a1b7223ULL, 0x080fe4000001001bULL, 0x0000003143147223ULL, 0x080fe40000010014ULL,
0x000000313c1a7223ULL, 0x080fe4000001001aULL, 0x0000003145127223ULL, 0x080fe40000010012ULL,
0x000000314c197223ULL, 0x000fc40000010019ULL, 0x0000003164117223ULL, 0x080fe40000010011ULL,
0x0000003147187223ULL, 0x080fe40000010018ULL, 0x0000003149107223ULL, 0x080fe40000010010ULL,
0x000000314e0c7223ULL, 0x000fe2000001000cULL, 0xfffff25000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x002e620000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x0000000400077819ULL, 0x002fc400000006ffULL,
0x00000001ff007819ULL, 0x000fe40000011600ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x0000000107097824ULL, 0x000fe200078e0200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000001000077824ULL, 0x002fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fc80000011600ULL,
0x0000007007007812ULL, 0x000fe400078ec0ffULL, 0x0000000c08077812ULL, 0x000fc600078ec0ffULL,
0x0000008003007824ULL, 0x000fc800078e0200ULL, 0x0000000100007824ULL, 0x000fca00078e0207ULL,
0x0049802d00007388ULL, 0x0003e40000000800ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0049800009007984ULL, 0x002e680000000800ULL, 0x004a000009077984ULL, 0x000ea20000000800ULL,
0x00000000ff007221ULL, 0x002fc80000010000ULL, 0x0000000700007221ULL, 0x004fca0000010000ULL,
0x0180000000077810ULL, 0x000fc80007ffe0ffULL, 0x7f80000007077812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x01ffffff0700780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0000ULL,
0x000098c000087802ULL, 0x000fe40000000f00ULL, 0x0000761000007944ULL, 0x008fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000077308ULL, 0x000e640000001000ULL,
0xbf80000000087423ULL, 0x002fc80000000007ULL, 0x800000ff08087221ULL, 0x000fc80000010100ULL,
0x0000000807077223ULL, 0x000fe40000000007ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000060606723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff2e7819ULL, 0x00afe40000011600ULL,
0x0000000800307811ULL, 0x000fc600078ff0ffULL, 0x00001f2e07087589ULL, 0x000e6400000e0000ULL,
0x0000000830367824ULL, 0x000fe400078e00ffULL, 0x00001f30070b7589ULL, 0x0004e200000e0000ULL,
0x0000001308137220ULL, 0x042fe40000410000ULL, 0x00000021080a7220ULL, 0x040fe20000410000ULL,
0x00000030ff217212ULL, 0x000fe200078e33ffULL, 0x0000002c082c7220ULL, 0x040fe40000410000ULL,
0x0000002b082b7220ULL, 0x000fe20000410000ULL, 0x000000130a0a723eULL, 0x000fe200000010ffULL,
0x0000002a082a7220ULL, 0x000fe20000410000ULL, 0xfffffff836367812ULL, 0x000fe200078ee221ULL,
0x0000002808097220ULL, 0x000fe20000410000ULL, 0x000000032e287819ULL, 0x000fe200000006ffULL,
0x0000002708277220ULL, 0x040fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000010ffULL,
0x0000002608267220ULL, 0x040fe20000410000ULL, 0x0000002a0909723eULL, 0x000fe200000010ffULL,
0x0000002508257220ULL, 0x000fc40000410000ULL, 0x0000002408247220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000010ffULL, 0x0000002308237220ULL, 0x040fe40000410000ULL,
0x0000002208227220ULL, 0x000fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000010ffULL,
0x0000000e080e7220ULL, 0x040fe40000410000ULL, 0x0000002008077220ULL, 0x004fe20000410000ULL,
0x000000232222723eULL, 0x000fe200000010ffULL, 0x0000000d080d7220ULL, 0x000fc40000410000ULL,
0x0000001f08087220ULL, 0x000fe20000410000ULL, 0x0000002eff1f7212ULL, 0x000fe200078e33ffULL,
0x0000001d0b207220ULL, 0x008fe20000410000ULL, 0x0000000e0707723eULL, 0x000fe200000010ffULL,
0x0000001c0b1d7220ULL, 0x040fe20000410000ULL, 0x0000000d0808723eULL, 0x000fe200000010ffULL,
0x0000001b0b1c7220ULL, 0x040fe20000410000ULL, 0x000000072e0d7812ULL, 0x000fe200078ec0ffULL,
0x000000160b167220ULL, 0x040fe20000410000ULL, 0xfffffff828287812ULL, 0x000fe200078ee21fULL,
0x000000140b147220ULL, 0x000fe20000410000ULL, 0x000000050d1f7812ULL, 0x000fe200078e3cffULL,
0x0000001a0b1b7220ULL, 0x000fe20000410000ULL, 0x000000161d16723eULL, 0x000fe200000010ffULL,
0x000000120b127220ULL, 0x000fe20000410000ULL, 0x000000040d1d7812ULL, 0x000fe200078e3cffULL,
0x000000190b197220ULL, 0x000fe20000410000ULL, 0x000000141b14723eULL, 0x000fe200000010ffULL,
0x000000082e137824ULL, 0x000fe200078e00ffULL, 0x000000030d1b7812ULL, 0x000fe200078e3cffULL,
0x0000000f0b0f7220ULL, 0x000fe20000410000ULL, 0x000000121912723eULL, 0x000fe200000010ffULL,
0x0000001e0b1e7220ULL, 0x000fe20000410000ULL, 0x000000020d197812ULL, 0x000fe200078e3cffULL,
0x000000170b177220ULL, 0x040fe20000410000ULL, 0x0000000528287211ULL, 0x000fe200078e20ffULL,
0x000000150b157220ULL, 0x040fe20000410000ULL, 0x0000000f1e0f723eULL, 0x000fe200000010ffULL,
0x000000110b117220ULL, 0x040fe20000410000ULL, 0x000000172017723eULL, 0x000fe200000010ffULL,
0x000000180b187220ULL, 0x040fe20000410000ULL, 0x000000151c15723eULL, 0x000fe200000010ffULL,
0x000000100b107220ULL, 0x040fe20000410000ULL, 0x0000000730207812ULL, 0x040fe200078ec0ffULL,
0x0000000c0b0b7220ULL, 0x000fe20000410000ULL, 0xfffffff8130c7812ULL, 0x000fe200078ee22eULL,
0x0000000830217824ULL, 0x000fe200078e00ffULL, 0x000000010d137812ULL, 0x040fe200078e3cffULL,
0x000000082e1a7824ULL, 0x040fe200078e021dULL, 0x000000060d0d7812ULL, 0x000fe200078e3cffULL,
0x000000082e1c7824ULL, 0x000fe200078e021fULL, 0x000000111811723eULL, 0x000fe200000010ffULL,
0x000000082e0e7824ULL, 0x040fe200078e0213ULL, 0x000000100b0b723eULL, 0x000fe200000010ffULL,
0x000000082e107824ULL, 0x040fe200078e0219ULL, 0x0000001b2e187211ULL, 0x040fe200078e18ffULL,
0x000000082e2e7824ULL, 0x000fe200078e020dULL, 0xfffffff8211e7812ULL, 0x000fe200078ee230ULL,
0x00000004000d7824ULL, 0x000fe200078e00ffULL, 0x0000000120137812ULL, 0x000fe200078e3cffULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x00000003201b7812ULL, 0x000fe200078e3cffULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x00000004201d7812ULL, 0x000fe200078e3cffULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0x00000005201f7812ULL, 0x000fe200078e3cffULL,
0x00000008302c7824ULL, 0x000fe200078e021bULL, 0x0000000220197812ULL, 0x000fe200078e3cffULL,
0x0000000830327824ULL, 0x000fe200078e021dULL, 0x0000000620217812ULL, 0x000fe200078e3cffULL,
0x0000000830207824ULL, 0x040fe200078e0213ULL, 0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000830347824ULL, 0x040fe200078e021fULL, 0x00000019302a7211ULL, 0x040fe200078e18ffULL,
0x0000000830307824ULL, 0x000fe200078e0221ULL, 0x0000000518187211ULL, 0x080fe200078e20ffULL,
0x000000010c0c7824ULL, 0x000fe200078e020dULL, 0x000000052c2c7211ULL, 0x000fe200078e20ffULL,
0x000000101a1a7824ULL, 0x000fc400078e0205ULL, 0x000000101e1e7824ULL, 0x100fe200078e0205ULL,
0x0000002b0c007388ULL, 0x000fe20000000800ULL, 0x0000001036367824ULL, 0x100fe400078e0205ULL,
0x000000101c1c7824ULL, 0x100fe400078e0205ULL, 0x000000102e2e7824ULL, 0x100fe200078e0205ULL,
0x000000360d367210ULL, 0x040fe20007ffe0ffULL, 0x0000001020207824ULL, 0x100fe400078e0205ULL,
0x000000102a2a7824ULL, 0x100fe200078e0205ULL, 0x0000002e0d2e7210ULL, 0x000fe20007ffe0ffULL,
0x0000001032327824ULL, 0x000fc400078e0205ULL, 0x0000001034347824ULL, 0x100fe400078e0205ULL,
0x0000001030307824ULL, 0x000fe400078e0205ULL, 0x000000010d0e7824ULL, 0x040fe400078e020eULL,
0x000000010d057824ULL, 0x040fe200078e0210ULL, 0x000000300d307210ULL, 0x040fe20007ffe0ffULL,
0x000000010d137824ULL, 0x040fe200078e0218ULL, 0x000000090e007388ULL, 0x000fe20000000800ULL,
0x000000010d197824ULL, 0x000fc400078e021aULL, 0x000000010d1b7824ULL, 0x040fe200078e021cULL,
0x0000002605007388ULL, 0x0003e20000000800ULL, 0x000000010d1d7824ULL, 0x040fe400078e0228ULL,
0x000000010d1e7824ULL, 0x040fe200078e021eULL, 0x0000002413007388ULL, 0x000fe20000000800ULL,
0x000000010d207824ULL, 0x040fe400078e0220ULL, 0x000000010d217824ULL, 0x040fe200078e022aULL,
0x0000002219007388ULL, 0x000fe20000000800ULL, 0x000000010d2c7824ULL, 0x000fc400078e022cULL,
0x000000010d257824ULL, 0x040fe200078e0232ULL, 0x0000000a1b007388ULL, 0x000fe20000000800ULL,
0x000000010d277824ULL, 0x000fe400078e0234ULL, 0x00000020030d7824ULL, 0x000fe200078e0200ULL,
0x000000072e007388ULL, 0x000fe60000000800ULL, 0x000000100d057824ULL, 0x002fe200078e0204ULL,
0x000000081d007388ULL, 0x000fe80000000800ULL, 0x0000000f1e007388ULL, 0x000fe80000000800ULL,
0x0000001720007388ULL, 0x000fe80000000800ULL, 0x0000001621007388ULL, 0x000fe80000000800ULL,
0x000000152c007388ULL, 0x000fe80000000800ULL, 0x0000001425007388ULL, 0x000fe80000000800ULL,
0x0000001227007388ULL, 0x000fe80000000800ULL, 0x0000001130007388ULL, 0x000fe80000000800ULL,
0x0000000b36007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000050c7984ULL, 0x000e680000000c00ULL, 0x00040000051c7984ULL, 0x000ea80000000c00ULL,
0x0008000005187984ULL, 0x000ee80000000c00ULL, 0x000c000005207984ULL, 0x000f220000000c00ULL,
0x3f803f80060f7831ULL, 0x002fc4000020000fULL, 0x3f803f80060e7831ULL, 0x040fe4000020000eULL,
0x3f803f80060d7831ULL, 0x040fe4000020000dULL, 0x3f803f80060c7831ULL, 0x040fe4000020000cULL,
0x3f803f80061f7831ULL, 0x044fe4000020001fULL, 0x3f803f80061e7831ULL, 0x040fe4000020001eULL,
0x3f803f80061d7831ULL, 0x000fc4000020001dULL, 0x3f803f80061c7831ULL, 0x000fe4000020001cULL,
0x3f803f800f0f7831ULL, 0x008fe4000020001bULL, 0x3f803f800e0e7831ULL, 0x000fe4000020001aULL,
0x3f803f800d0d7831ULL, 0x000fe40000200019ULL, 0x3f803f800c0c7831ULL, 0x000fe40000200018ULL,
0x3f803f801f1f7831ULL, 0x010fc40000200023ULL, 0x3f803f801e1e7831ULL, 0x000fe20000200022ULL,
0x0000000c05007388ULL, 0x0003e20000000c00ULL, 0x3f803f801d1d7831ULL, 0x000fe40000200021ULL,
0x3f803f801c1c7831ULL, 0x000fca0000200020ULL, 0x0004001c05007388ULL, 0x0003e80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000ff0300720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000147919ULL, 0x000ee20000002600ULL,
0x0000002000187810ULL, 0x042fe20007ffe0ffULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x00000040001f7810ULL, 0x040fe20007ffe0ffULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000006000217810ULL, 0x000fe20007ffe0ffULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x00000003ff057819ULL, 0x000fe20000011600ULL, 0x0000000802237824ULL, 0x040fe200078e00ffULL,
0x00000003ff157819ULL, 0x000fe20000011618ULL, 0x00000008021d7824ULL, 0x040fe200078e00ffULL,
0x00000003ff167819ULL, 0x000fe2000001161fULL, 0x00000008021a7824ULL, 0x040fe200078e00ffULL,
0x00000003ff177819ULL, 0x000fe20000011621ULL, 0x00000008021e7824ULL, 0x000fe200078e00ffULL,
0x0000000705077812ULL, 0x000fc400078e4800ULL, 0x0000000717087812ULL, 0x100fe400078e4821ULL,
0x0ffffff8070d7812ULL, 0x100fe400078ef800ULL, 0x0ffffff8080b7812ULL, 0x000fe400078ef821ULL,
0xfffffff823237812ULL, 0x000fe200078ee200ULL, 0x0000001014067824ULL, 0x048fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL, 0x000000100b107824ULL, 0x000fe200078e0204ULL,
0x00000004050472a4ULL, 0x002fe2000f8e023fULL, 0x0000001014007824ULL, 0x000fe200078e00ffULL,
0xfffffff006037812ULL, 0x000fc400078ee205ULL, 0x0000000715057812ULL, 0x100fe200078e4818ULL,
0x0000000010107984ULL, 0x000fe20000000c00ULL, 0x0000000716067812ULL, 0x100fe400078e481fULL,
0x0ffffff805077812ULL, 0x000fe200078ef818ULL, 0x000000100d057824ULL, 0x100fe200078e0204ULL,
0x0ffffff806097812ULL, 0x000fe400078ef81fULL, 0x0000000403037c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001007087824ULL, 0x000fe200078e0204ULL, 0x00000004090c7211ULL, 0x000fc400078e20ffULL,
0x0000000005047984ULL, 0x000e620000000c00ULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL,
0x00000010141a7824ULL, 0x040fe200078e00ffULL, 0x0000000414197819ULL, 0x000fe200000006ffULL,
0x0000000008087984ULL, 0x000ee20000000c00ULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00005a0003147a11ULL, 0x000fe400078040ffULL, 0x000000000c0c7984ULL, 0x004ea20000000c00ULL,
0xfffffff000007812ULL, 0x000fe400078ee215ULL, 0xfffffff019167812ULL, 0x000fc400078ee216ULL,
0xfffffff01a177812ULL, 0x000fe400078ee217ULL, 0x00005b0003157a11ULL, 0x000fe400000f4418ULL,
0x00000004001b7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000416027c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000417007c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005a001b167a11ULL, 0x000fe200078040ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x00005a0002187a11ULL, 0x000fc400078240ffULL, 0x000000ffff037210ULL, 0x000fe400017fe4ffULL,
0x00005a00001a7a11ULL, 0x000fe400078440ffULL, 0x00005b001b177a11ULL, 0x000fe400000f441cULL,
0x00005b0002197a11ULL, 0x000fe400008f4419ULL, 0xfffffff81e217812ULL, 0x000fe400078ee221ULL,
0x00005b00001b7a11ULL, 0x000fe200010f4403ULL, 0x0000001023027825ULL, 0x000fc800078e0014ULL,
0x000000101d147825ULL, 0x000fe200078e0016ULL, 0x0000000402007986ULL, 0x002fe6000c101d06ULL,
0x000000101f167825ULL, 0x000fe200078e0018ULL, 0x0000000814007986ULL, 0x008fe6000c101d06ULL,
0x0000001021187825ULL, 0x000fe200078e001aULL, 0x0000000c16007986ULL, 0x004fe8000c101d06ULL,
0x0000001018007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000017c037810ULL, 0x00afe20007ffe0ffULL, 0x000000020c0c7824ULL, 0x000fc400078e00ffULL,
0x000000407a777824ULL, 0x000fe200078e00ffULL, 0x000000780300720cULL, 0x000fe20003f06070ULL,
0x000058000c797a24ULL, 0x000fe400078e0279ULL, 0x000001007c167824ULL, 0x000fc800078e0277ULL,
0x0000620079007a24ULL, 0x000fcc00078e0216ULL, 0x00000ba000008947ULL, 0x000fea0003800000ULL,
0x0000000000187919ULL, 0x000e620000000000ULL, 0x000000167b027217ULL, 0x000fe20007800000ULL,
0x00000100ff1f7424ULL, 0x000fe200078e00ffULL, 0x000010007a177811ULL, 0x000fe400078e70ffULL,
0x0000000216167210ULL, 0x000fe40007ffe1ffULL, 0x00000003ff1d7819ULL, 0x002fc80000011618ULL,
0x000000081d077810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x000fe200078e021dULL,
0x000000041d057810ULL, 0x000fe40007ffe0ffULL, 0x0000001807047212ULL, 0x0c0fe200078e3cffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000001805037212ULL, 0x040fe200078e3cffULL,
0x0000000805147824ULL, 0x000fe200078e00ffULL, 0x000000101d0d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8091a7812ULL, 0x000fe200078ee204ULL, 0x0000001018047824ULL, 0x000fe200078e00ffULL,
0x0000000c1d097810ULL, 0x000fc40007ffe0ffULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x0000001809067212ULL, 0x0c0fe400078e3cffULL,
0x0000007004217812ULL, 0x000fe200078ec0ffULL, 0x00000008090b7824ULL, 0x000fe200078e00ffULL,
0x000000180d047212ULL, 0x000fe200078e3cffULL, 0x00000010141b7824ULL, 0x000fe200078e0217ULL,
0x00000002210a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff80b1c7812ULL, 0x000fe200078ee206ULL,
0x000000080d0b7824ULL, 0x000fe200078e00ffULL, 0x0000000500027210ULL, 0x040fe20007ffe0ffULL,
0x0000000100067824ULL, 0x000fe200078e0209ULL, 0x000000160500720cULL, 0x000fc40003f86070ULL,
0xfffffff80b1e7812ULL, 0x000fe200078ee204ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0603ULL,
0x000000160700720cULL, 0x080fe20003f46070ULL, 0x00005e0002027625ULL, 0x080fe200078e001fULL,
0x000000141d137810ULL, 0x000fe40007ffe0ffULL, 0x000000160d00720cULL, 0x000fe20003f06070ULL,
0x0000000100047824ULL, 0x040fe200078e0207ULL, 0x00000002210c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000100077824ULL, 0x000fe200078e020dULL, 0x000000181d157810ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0x00000003ff0d7210ULL, 0x000fc40000ffe4ffULL,
0x000000160900720cULL, 0x000fe20003f66070ULL, 0x00005e0006027625ULL, 0x080fe200078e001fULL,
0x00000004210e7210ULL, 0x000fe40007f3e0ffULL, 0x0000001c1d237810ULL, 0x000fe20007ffe0ffULL,
0x0000000100087824ULL, 0x000fe200078e0213ULL, 0x0000001813047212ULL, 0x000fe200078e3cffULL,
0x000000ffff0f7224ULL, 0x000fe200008e0605ULL, 0x0000000221107210ULL, 0x000fe20007f3e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e001fULL, 0x000000071d057812ULL, 0x000fc400078e4818ULL,
0x000000201d257810ULL, 0x000fe20007ffe0ffULL, 0x00005e0007067625ULL, 0x080fe200078e001fULL,
0x0000000821087210ULL, 0x000fe40007fde0ffULL, 0x0000001815227212ULL, 0x000fe200078e3cffULL,
0x0000000100027824ULL, 0x000fe200078e0215ULL, 0x0000000621067210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0603ULL, 0x000000161300720cULL, 0x040fe20003f26070ULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x0000000313137819ULL, 0x000fc400000006ffULL,
0x0000000315277819ULL, 0x000fe200000006ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000000221127210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0ffffff805027812ULL, 0x000fe400078ef818ULL, 0x000000161d00720cULL, 0x000fe40003fa6070ULL,
0xfffffff813207812ULL, 0x000fe200078ee204ULL, 0x0000001002197824ULL, 0x000fe200078e0217ULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x0000000100027824ULL, 0x000fe200078e0223ULL,
0x000000381d277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fc400030e0603ULL,
0x00005e0002027625ULL, 0x000fc800078e001fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e2000e901c46ULL, 0x0000000221147210ULL, 0x000fe20007fde0ffULL,
0x0000000100047824ULL, 0x000fe200078e0225ULL, 0x0000001823027212ULL, 0x040fe200078e3cffULL,
0x000000000c1b7faeULL, 0x0005e2000e101c46ULL, 0x000000162300720cULL, 0x0c0fe20003f86070ULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x000000161500720cULL, 0x000fe20003fa6070ULL,
0x00005e0004047625ULL, 0x000fc800078e001fULL, 0x000000ffff157224ULL, 0x000fe200030e0603ULL,
0x0000000421047210ULL, 0x000fe20007fde0ffULL, 0x000000101c197824ULL, 0x102fe200078e0217ULL,
0x00000018250b7212ULL, 0x000fe200078e3cffULL, 0x000000101a0d7824ULL, 0x004fe200078e0217ULL,
0x000000241d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200030e0605ULL,
0xfffffff8230c7812ULL, 0x000fe200078ee202ULL, 0x00000008251c7824ULL, 0x000fe200078e00ffULL,
0x0000001b00027210ULL, 0x000fe20007ffe0ffULL, 0x000000000e0d7faeULL, 0x0003e2000d101c46ULL,
0x000000161b00720cULL, 0x000fc40003f46070ULL, 0x000000181b1a7212ULL, 0x000fe200078e3cffULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x0000000010197faeULL, 0x0005e2000d901c46ULL,
0x000000162500720cULL, 0x000fe40003f66070ULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x00000002210a7210ULL, 0x000fe40007fde0ffULL, 0xfffffff81c027812ULL, 0x000fe200078ee20bULL,
0x000000101e0d7824ULL, 0x002fe200078e0217ULL, 0xfffffff81b1a7812ULL, 0x000fe200078ee21aULL,
0x000000ffff0b7224ULL, 0x000fe200030e0603ULL, 0x000000281d1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001020037824ULL, 0x100fe200078e0217ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0x0000001002197824ULL, 0x104fe200078e0217ULL, 0x000000181b027212ULL, 0x000fe200078e3cffULL,
0x000000100c117824ULL, 0x000fe200078e0217ULL, 0x0000000008037faeULL, 0x0005e2000c901c46ULL,
0x00000017220f7211ULL, 0x000fc400078e20ffULL, 0x0000002c1d237810ULL, 0x040fe40007ffe0ffULL,
0x000000301d257810ULL, 0x000fe20007ffe0ffULL, 0x00000000120f7faeULL, 0x0007e2000e901c46ULL,
0x000000161b00720cULL, 0x000fe20003fc6070ULL, 0x0000000823107824ULL, 0x040fe200078e00ffULL,
0x0000001823077212ULL, 0x002fe200078e3cffULL, 0x0000000014117faeULL, 0x0003e2000e101c46ULL,
0x000000341d0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000081b037824ULL, 0x004fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x000000101a097824ULL, 0x000fe200078e0217ULL,
0x0000000004197faeULL, 0x0005e2000d901c46ULL, 0x0000000100087824ULL, 0x040fe200078e0225ULL,
0xfffffff8030e7812ULL, 0x000fe200078ee202ULL, 0x0000000100027824ULL, 0x000fe200078e021bULL,
0x000000000a097faeULL, 0x0009e2000d101c46ULL, 0x000000162500720cULL, 0x000fc40003f86070ULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x00000018250c7212ULL, 0x000fe400078e3cffULL,
0x0000003c1d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d147824ULL, 0x002fe200078e00ffULL,
0x0000002300047210ULL, 0x004fe20007ffe0ffULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x0000000221067210ULL, 0x000fe20007f5e0ffULL, 0x0000001010117824ULL, 0x000fe200078e0217ULL,
0x000000180d0b7212ULL, 0x010fe200078e3cffULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0xfffffff825127812ULL, 0x008fc400078ee20cULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000ffff077224ULL, 0x000fe200010e0603ULL, 0x000000160d00720cULL, 0x000fe20003f66070ULL,
0x00005e0008027625ULL, 0x000fe200078e001fULL, 0x0000000421087210ULL, 0x000fe40007f5e0ffULL,
0x0000000d00047210ULL, 0x000fe20007ffe0ffULL, 0x0000001012137824ULL, 0x000fe200078e0217ULL,
0x000000162300720cULL, 0x000fe20003fa6070ULL, 0x000000ffff097224ULL, 0x000fe200010e0605ULL,
0x00000002210a7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0x000000162700720cULL, 0x000fc40003f26070ULL, 0x000000161d00720cULL, 0x000fe20003f06070ULL,
0x0000000100027824ULL, 0x000fe200078e0227ULL, 0x00000018270f7212ULL, 0x000fe200078e3cffULL,
0x000000ffff0b7224ULL, 0x000fe200010e0603ULL, 0x00000004210c7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x000000181d187212ULL, 0x040fe400078e3cffULL,
0x0000001714157211ULL, 0x000fe200078e20ffULL, 0x0000000100007824ULL, 0x000fe200078e021dULL,
0x000000031d1d7819ULL, 0x000fe200000006ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e0605ULL,
0x0000000221027210ULL, 0x000fe20007f5e0ffULL, 0x0000000827167824ULL, 0x000fe200078e00ffULL,
0xfffffff81d187812ULL, 0x000fe200078ee218ULL, 0x00005e0000047625ULL, 0x000fc600078e001fULL,
0xfffffff816167812ULL, 0x000fe200078ee20fULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x0000000421047210ULL, 0x000fe20007f5e0ffULL, 0x000000100e0f7824ULL, 0x100fe400078e0217ULL,
0x0000001016197824ULL, 0x100fe400078e0217ULL, 0x0000001018177824ULL, 0x000fe200078e0217ULL,
0x00000000060f7faeULL, 0x0003e2000f101c46ULL, 0x000000ffff057224ULL, 0x000fc600010e0605ULL,
0x0000000008117faeULL, 0x0003e8000e901c46ULL, 0x000000000a137faeULL, 0x0003e8000e101c46ULL,
0x000000000c157faeULL, 0x0003e8000d901c46ULL, 0x0000000002197faeULL, 0x0003e8000c901c46ULL,
0x0000000004177faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000010000217802ULL, 0x000fc40000000f00ULL,
0x00000003ff037819ULL, 0x002fc80000011604ULL, 0x0000000403077810ULL, 0x040fe40007ffe0ffULL,
0x0000000803097810ULL, 0x000fe40007ffe0ffULL, 0x0000000407027212ULL, 0x0c0fe200078e3cffULL,
0x00000008070b7824ULL, 0x000fe200078e00ffULL, 0x0000001403177810ULL, 0x000fe20007ffe0ffULL,
0x00000008090d7824ULL, 0x000fe200078e00ffULL, 0x0000000c030f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee202ULL, 0x0000000817197824ULL, 0x000fe200078e00ffULL,
0x0000000409027212ULL, 0x000fe200078e3cffULL, 0x00000001000a7824ULL, 0x000fe200078e020fULL,
0x0000001003137810ULL, 0x000fc40007ffe0ffULL, 0x000000040f057212ULL, 0x0c0fe400078e3cffULL,
0x000000030f087819ULL, 0x000fe200000006ffULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee202ULL, 0x00000001000c7824ULL, 0x040fe200078e0213ULL,
0x00000018031b7810ULL, 0x040fe40007ffe0ffULL, 0x0000002003257810ULL, 0x000fe40007ffe0ffULL,
0x0000000417027212ULL, 0x080fe200078e3cffULL, 0x0000000100107824ULL, 0x000fe200078e021bULL,
0xfffffff808117812ULL, 0x000fe200078ee205ULL, 0x000000081b087824ULL, 0x000fe200078e00ffULL,
0x0000001c031f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000825357824ULL, 0x000fe200078e00ffULL,
0x0000000413067212ULL, 0x080fe200078e3cffULL, 0x0000000100147824ULL, 0x040fe200078e0225ULL,
0xfffffff819197812ULL, 0x000fe200078ee202ULL, 0x000000081f337824ULL, 0x000fe200078e00ffULL,
0x0000002c032b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000100127824ULL, 0x000fe200078e021fULL,
0x000000041b057212ULL, 0x000fc400078e3cffULL, 0x0000000425027212ULL, 0x080fe200078e3cffULL,
0x000000082b3b7824ULL, 0x000fe200078e00ffULL, 0x0000002403277810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815157812ULL, 0x000fe400078ee206ULL, 0x0000002803297810ULL, 0x000fe20007ffe0ffULL,
0x0000000100167824ULL, 0x000fe200078e0227ULL, 0x000000041f067212ULL, 0x080fe400078e3cffULL,
0xfffffff8081d7812ULL, 0x000fe200078ee205ULL, 0x0000000829397824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee202ULL, 0x0000000100187824ULL, 0x000fe200078e0229ULL,
0x0000000427057212ULL, 0x000fc400078e3cffULL, 0x0000000327087819ULL, 0x000fe400000006ffULL,
0x00000030032d7810ULL, 0x000fe40007ffe0ffULL, 0x000000042b027212ULL, 0x080fe400078e3cffULL,
0xfffffff833337812ULL, 0x000fe200078ee206ULL, 0x00000001001c7824ULL, 0x000fe200078e022dULL,
0x00000034032f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000429067212ULL, 0x000fc400078e3cffULL,
0xfffffff808377812ULL, 0x000fe200078ee205ULL, 0x000000082d087824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee202ULL, 0x0000001004027824ULL, 0x000fe200078e00ffULL,
0x000000042d057212ULL, 0x080fe200078e3cffULL, 0x000000082f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee206ULL, 0x00000001001e7824ULL, 0x000fe200078e022fULL,
0x000000042f067212ULL, 0x000fe400078e3cffULL, 0x0000003803317810ULL, 0x000fc40007ffe0ffULL,
0x0000003c03417810ULL, 0x040fe40007ffe0ffULL, 0xfffffff8083d7812ULL, 0x000fe200078ee205ULL,
0x0000000100087824ULL, 0x000fe200078e0209ULL, 0x0000007002237812ULL, 0x000fe200078ec0ffULL,
0x0000000100027824ULL, 0x040fe200078e0203ULL, 0x0000000703057812ULL, 0x000fe200078e4804ULL,
0x0000000100207824ULL, 0x040fe200078e0231ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL,
0x0000000100067824ULL, 0x040fe200078e0207ULL, 0x00000017000e7210ULL, 0x040fe20007ffe0ffULL,
0x0000000100227824ULL, 0x040fe200078e0241ULL, 0x0000002b001a7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x0ffffff805057812ULL, 0x000fc400078ef804ULL,
0x0000000431077212ULL, 0x0c0fe200078e3cffULL, 0x0000000831247824ULL, 0x000fe200078e00ffULL,
0x000010007a007811ULL, 0x000fe400078e70ffULL, 0x0000000441047212ULL, 0x040fe400078e3cffULL,
0x0000000341137819ULL, 0x000fe200000006ffULL, 0x0000001005257824ULL, 0x100fe200078e0200ULL,
0x0000000223027210ULL, 0x000fe20007f1e0ffULL, 0x000000100b277824ULL, 0x000fe200078e0200ULL,
0xfffffff813137812ULL, 0x000fe200078ee204ULL, 0x00005e0006047625ULL, 0x000fe200078e0021ULL,
0xfffffff8240f7812ULL, 0x000fc400078ee207ULL, 0x00000000152d7211ULL, 0x080fe200078e20ffULL,
0x00005e0008067625ULL, 0x000fe200078e0021ULL, 0x0000000039397211ULL, 0x000fc600078e20ffULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000000423047210ULL, 0x040fe20007f1e0ffULL,
0x00005e000a087625ULL, 0x000fe200078e0021ULL, 0x0000000623067210ULL, 0x040fe40007f3e0ffULL,
0x00000005ff057210ULL, 0x000fe200007fe4ffULL, 0x00005e000c0a7625ULL, 0x080fe200078e0021ULL,
0x0000000823087210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002257faeULL, 0x0003e4000b901c46ULL, 0x000000100d297824ULL, 0x100fe200078e0200ULL,
0x0000000a230a7210ULL, 0x000fe20007f1e0ffULL, 0x000000100f417824ULL, 0x000fe200078e0200ULL,
0x0000000004277faeULL, 0x0003e2000b901c46ULL, 0x00005e000e0c7625ULL, 0x000fc800078e0021ULL,
0x00005e00100e7625ULL, 0x000fc800078e0021ULL, 0x00000010112b7824ULL, 0x100fe400078e0200ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000e230e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001013437824ULL, 0x000fe400078e0200ULL, 0x00005e0012107625ULL, 0x000fc800078e0021ULL,
0x00005e0014127625ULL, 0x000fc800078e0021ULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000c230c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0016147625ULL, 0x000fc600078e0021ULL,
0x0000000006297faeULL, 0x0003e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000001223127210ULL, 0x000fe20007f1e0ffULL, 0x00000010192f7824ULL, 0x000fe400078e0200ULL,
0x00005e0018167625ULL, 0x000fc800078e0021ULL, 0x00005e001a187625ULL, 0x000fc800078e0021ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x0000001023107210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000001823187210ULL, 0x000fe20007f1e0ffULL,
0x000000101d317824ULL, 0x000fe200078e0200ULL, 0x00000011ff117210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000001423147210ULL, 0x040fe20007f3e0ffULL,
0x00005e001c1a7625ULL, 0x080fe200078e0021ULL, 0x0000001623167210ULL, 0x000fe40007f5e0ffULL,
0x00000000082b7faeULL, 0x0003e2000b901c46ULL, 0x00005e001e1c7625ULL, 0x000fc600078e0021ULL,
0x000000000a2d7faeULL, 0x0003e2000b901c46ULL, 0x00005e00201e7625ULL, 0x000fc600078e0021ULL,
0x000000000c2f7faeULL, 0x0003e2000b901c46ULL, 0x00005e0022207625ULL, 0x000fc600078e0021ULL,
0x000000000e317faeULL, 0x0003e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000001a231a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001033337824ULL, 0x100fe200078e0200ULL,
0x0000002023207210ULL, 0x000fe20007f7e0ffULL, 0x0000001035357824ULL, 0x100fe400078e0200ULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000001c231c7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000001e231e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001037377824ULL, 0x100fe200078e0200ULL, 0x0000000010337faeULL, 0x0003e2000b901c46ULL,
0x000000103b3b7824ULL, 0x100fe200078e0200ULL, 0x0000001dff1d7210ULL, 0x000fe20000ffe4ffULL,
0x000000103d3d7824ULL, 0x000fe200078e0200ULL, 0x0000000012357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fc400000e061bULL, 0x000000103f3f7824ULL, 0x000fe200078e0200ULL,
0x0000000014377faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe400010e061fULL,
0x000000ffff217224ULL, 0x000fe200018e0621ULL, 0x0000000016397faeULL, 0x0003e8000b901c46ULL,
0x00000000183b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a3d7faeULL, 0x0003e8000b901c46ULL,
0x000000001c3f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e417faeULL, 0x0003e8000b901c46ULL,
0x0000000020437faeULL, 0x0003e4000b901c46ULL, 0x02360400ff007984ULL, 0x000ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000000ff7812ULL, 0x004fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0022a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x02360400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000787c00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000006d7919ULL, 0x000ea20000000000ULL, 0x000000107a767824ULL, 0x000fe200078e00ffULL,
0xffffffff78757810ULL, 0x000fe40007ffe0ffULL, 0x00007610ff747816ULL, 0x000fe40000000074ULL,
0x000001007c6c7824ULL, 0x000fe200078e0277ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000006c7b00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x000000017c037810ULL, 0x002fe20007ffe0ffULL, 0x0000144000007945ULL, 0x000fe20003800000ULL,
0x0000620079197a24ULL, 0x000fe400078e026cULL, 0x000000780300720cULL, 0x000fda0003f06070ULL,
0x00000a9000008947ULL, 0x000fea0003800000ULL, 0x00000003ff6b7819ULL, 0x004fe2000001166dULL,
0x000000017b1d7824ULL, 0x000fe200078e0a6cULL, 0x000000076d187812ULL, 0x000fe200078ec0ffULL,
0x00000100ff6a7424ULL, 0x000fe200078e00ffULL, 0x000000046b687810ULL, 0x040fe40007ffe0ffULL,
0x000000086b667810ULL, 0x040fe40007ffe0ffULL, 0x0000000c6b007810ULL, 0x040fe20007ffe0ffULL,
0x0000000168117824ULL, 0x140fe200078e0219ULL, 0x0000006d68677212ULL, 0x080fe200078e3cffULL,
0x0000000866087824ULL, 0x000fe200078e00ffULL, 0x0000000368067819ULL, 0x000fe200000006ffULL,
0x00000008000a7824ULL, 0x040fe200078e00ffULL, 0x000000106b027810ULL, 0x000fe20007ffe0ffULL,
0x0000000100157824ULL, 0x000fe200078e0219ULL, 0x0000006d66657212ULL, 0x000fc400078e3cffULL,
0xfffffff806677812ULL, 0x000fe200078ee267ULL, 0x0000000802057824ULL, 0x040fe200078e00ffULL,
0x000000186b067810ULL, 0x000fe20007ffe0ffULL, 0x0000000102177824ULL, 0x000fe200078e0219ULL,
0x0000006d00037212ULL, 0x080fe200078e3cffULL, 0x00005e0015147625ULL, 0x080fe200078e006aULL,
0x0000006d02047212ULL, 0x000fe400078e3cffULL, 0xfffffff808657812ULL, 0x000fe200078ee265ULL,
0x00000008060d7824ULL, 0x000fe200078e00ffULL, 0x000000206b087810ULL, 0x000fe20007ffe0ffULL,
0x00005e0017167625ULL, 0x000fe200078e006aULL, 0xfffffff80a037812ULL, 0x000fc400078ee203ULL,
0xfffffff805047812ULL, 0x000fe200078ee204ULL, 0x00000008080f7824ULL, 0x000fe200078e00ffULL,
0x0000006d060a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000106277824ULL, 0x100fe200078e0219ULL,
0x000000146b057810ULL, 0x040fe20007ffe0ffULL, 0x00000001082d7824ULL, 0x140fe200078e0219ULL,
0x0000006d080c7212ULL, 0x080fe400078e3cffULL, 0x0000001c6b077810ULL, 0x000fe20007ffe0ffULL,
0x00000008050e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL,
0x0000000105257824ULL, 0x100fe200078e0219ULL, 0x0000006d6b0d7212ULL, 0x080fe200078e3cffULL,
0x00000001072b7824ULL, 0x000fe200078e0219ULL, 0x0000006d05097212ULL, 0x000fc400078e3cffULL,
0xfffffff80f0c7812ULL, 0x000fe200078ee20cULL, 0x000000016b0f7824ULL, 0x000fe200078e0219ULL,
0x0000006d070b7212ULL, 0x040fe400078e3cffULL, 0x0000000307107819ULL, 0x000fe400000006ffULL,
0x000000070d1a7812ULL, 0x000fe400078ec0ffULL, 0x0000001966137210ULL, 0x000fe40007ffe0ffULL,
0x0000001d6b00720cULL, 0x000fc40003f06070ULL, 0xfffffff80e097812ULL, 0x000fe200078ee209ULL,
0x00005e000f0e7625ULL, 0x080fe200078e006aULL, 0x0000001d6800720cULL, 0x080fe40003f26070ULL,
0xfffffff8100b7812ULL, 0x000fe200078ee20bULL, 0x00005e0011107625ULL, 0x080fe200078e006aULL,
0x0000001d6600720cULL, 0x000fe40003f46070ULL, 0x000030007a287811ULL, 0x000fe200078e70ffULL,
0x00005e0013127625ULL, 0x000fe200078e006aULL, 0x0000000818297812ULL, 0x000fc400078efcffULL,
0x0000001d0000720cULL, 0x080fe20003f66070ULL, 0x00000010671b7824ULL, 0x000fe200078e0228ULL,
0x0ffffff81a697812ULL, 0x000fe200078ef86dULL, 0x00000010290e7825ULL, 0x000fe200078e000eULL,
0x0000001d0200720cULL, 0x000fe40003f86070ULL, 0x0000002803217211ULL, 0x000fe200078e20ffULL,
0x00000010690d7824ULL, 0x000fe400078e0228ULL, 0x0000001029107825ULL, 0x000fc600078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e2000c101c46ULL,
0x0000001029127825ULL, 0x000fe200078e0012ULL, 0x0000001d0500720cULL, 0x080fe40003f06070ULL,
0x00000000101b7faeULL, 0x0005e2000c901c46ULL, 0x00000010651f7824ULL, 0x000fe200078e0228ULL,
0x0000001d0600720cULL, 0x000fe20003f26070ULL, 0x0000001029147825ULL, 0x000fc600078e0014ULL,
0x00000000121f7faeULL, 0x0007e2000d101c46ULL, 0x0000001029167825ULL, 0x000fe200078e0016ULL,
0x0000001d0700720cULL, 0x080fe40003f46070ULL, 0x0000000014217faeULL, 0x0009e2000d901c46ULL,
0x0000001004237824ULL, 0x000fe200078e0228ULL, 0x0000001d0800720cULL, 0x000fe20003f66070ULL,
0x00005e00250e7625ULL, 0x082fe200078e006aULL, 0x000000246b0d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000016237faeULL, 0x0003e2000e101c46ULL, 0x00005e0027107625ULL, 0x004fe200078e006aULL,
0x00000028091f7211ULL, 0x008fc600078e20ffULL, 0x00005e002b1a7625ULL, 0x000fc800078e006aULL,
0x0000001029127825ULL, 0x000fe200078e000eULL, 0x0000002c6b0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000286b0e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e002d167625ULL, 0x002fe200078e006aULL,
0x00000000121f7faeULL, 0x0003e2000c101c46ULL, 0x0000001d0d00720cULL, 0x000fe40003f06070ULL,
0x0000001029147825ULL, 0x010fe200078e0010ULL, 0x000000306b107810ULL, 0x040fe40007ffe0ffULL,
0x000000346b117810ULL, 0x000fe20007ffe0ffULL, 0x000000100a217824ULL, 0x000fc400078e0228ULL,
0x00000010291a7825ULL, 0x000fe200078e001aULL, 0x0000001d1100720cULL, 0x080fe40003f86070ULL,
0x0000000014217faeULL, 0x0005e2000c901c46ULL, 0x000000100b237824ULL, 0x000fe200078e0228ULL,
0x000000386b127810ULL, 0x002fe20007ffe0ffULL, 0x0000001029167825ULL, 0x000fe200078e0016ULL,
0x0000003c6b137810ULL, 0x000fe40007ffe0ffULL, 0x000000001a237faeULL, 0x0003e2000d101c46ULL,
0x000000100c257824ULL, 0x000fe200078e0228ULL, 0x0000001d0e00720cULL, 0x080fe20003f26070ULL,
0x00000008121c7824ULL, 0x000fe200078e00ffULL, 0x0000001d0f00720cULL, 0x0c0fe20003f46070ULL,
0x000000010f1f7824ULL, 0x100fe200078e0219ULL, 0x0000000016257faeULL, 0x0007e2000d901c46ULL,
0x0000001d1000720cULL, 0x0c0fe20003f66070ULL, 0x0000000110217824ULL, 0x104fe200078e0219ULL,
0x0000001d1200720cULL, 0x000fe20003fa6070ULL, 0x0000000113277824ULL, 0x100fe200078e0219ULL,
0x0000006d0e157212ULL, 0x040fe200078e3cffULL, 0x000000080e1a7824ULL, 0x002fe200078e00ffULL,
0x000000030f1b7819ULL, 0x000fe200000006ffULL, 0x0000000111237824ULL, 0x100fe200078e0219ULL,
0x0000001d1300720cULL, 0x040fe20003fc6070ULL, 0x00000008131d7824ULL, 0x000fe200078e00ffULL,
0x0000006d0d147212ULL, 0x0c0fe200078e3cffULL, 0x000000080d177824ULL, 0x008fe200078e00ffULL,
0x0000006d0f167212ULL, 0x080fe200078e3cffULL, 0x0000000112257824ULL, 0x000fe200078e0219ULL,
0x0000006d11607212ULL, 0x000fe200078e3cffULL, 0x00005e001f1e7625ULL, 0x000fe200078e006aULL,
0xfffffff81b167812ULL, 0x000fc400078ee216ULL, 0x0000006d13627212ULL, 0x080fe200078e3cffULL,
0x00000008111b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a157812ULL, 0x000fe200078ee215ULL,
0x00000008101a7824ULL, 0x040fe200078e00ffULL, 0xfffffff817147812ULL, 0x000fe200078ee214ULL,
0x00005e0021207625ULL, 0x080fe200078e006aULL, 0x0000006d10177212ULL, 0x080fe400078e3cffULL,
0xfffffff81b607812ULL, 0x000fe200078ee260ULL, 0x000000010d1b7824ULL, 0x000fe200078e0219ULL,
0xfffffff81d627812ULL, 0x000fe200078ee262ULL, 0x00005e0023227625ULL, 0x000fe200078e006aULL,
0x0000006d12617212ULL, 0x000fc400078e3cffULL, 0x000000190e1d7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0025247625ULL, 0x080fe200078e006aULL, 0xfffffff81a177812ULL, 0x000fe400078ee217ULL,
0xfffffff81c617812ULL, 0x000fe200078ee261ULL, 0x00005e001b1a7625ULL, 0x000fe200078e006aULL,
0x0000002814197211ULL, 0x080fe400078e20ffULL, 0x0000002861317211ULL, 0x000fe200078e20ffULL,
0x00005e001d1c7625ULL, 0x000fc800078e006aULL, 0x00005e0027267625ULL, 0x000fc800078e006aULL,
0x00000010291a7825ULL, 0x000fc800078e001aULL, 0x00000010291c7825ULL, 0x040fe200078e001cULL,
0x000000001a197faeULL, 0x0003e6000c101c46ULL, 0x00000010291e7825ULL, 0x000fc800078e001eULL,
0x0000001029207825ULL, 0x000fc800078e0020ULL, 0x00000010152b7824ULL, 0x000fe400078e0228ULL,
0x0000001029227825ULL, 0x000fc600078e0022ULL, 0x000000001c2b7faeULL, 0x0003e2000c901c46ULL,
0x0000001029247825ULL, 0x000fc800078e0024ULL, 0x0000001029267825ULL, 0x000fc800078e0026ULL,
0x0000001016297824ULL, 0x100fe400078e0228ULL, 0x00000010172d7824ULL, 0x100fe400078e0228ULL,
0x00000010602f7824ULL, 0x100fe200078e0228ULL, 0x000000001e297faeULL, 0x0003e2000d101c46ULL,
0x0000001062337824ULL, 0x000fc600078e0228ULL, 0x00000000202d7faeULL, 0x0003e8000d901c46ULL,
0x00000000222f7faeULL, 0x0003e8000e101c46ULL, 0x0000000024317faeULL, 0x0003e8000e901c46ULL,
0x0000000026337faeULL, 0x0003e2000f101c46ULL, 0x0000097000007947ULL, 0x000fea0003800000ULL,
0x00000003ff6b7819ULL, 0x004fe2000001166dULL, 0x00000100ff6a7424ULL, 0x000fe200078e00ffULL,
0x000030007a3e7811ULL, 0x000fc400078e70ffULL, 0x000000046b687810ULL, 0x040fe40007ffe0ffULL,
0x000000086b667810ULL, 0x040fe40007ffe0ffULL, 0x0000006d68677212ULL, 0x0c0fe200078e3cffULL,
0x0000000868007824ULL, 0x000fe200078e00ffULL, 0x0000006d66657212ULL, 0x040fe200078e3cffULL,
0x0000000866027824ULL, 0x000fe200078e00ffULL, 0x000000146b057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff800677812ULL, 0x000fc400078ee267ULL, 0xfffffff802657812ULL, 0x000fe200078ee265ULL,
0x0000000805087824ULL, 0x000fe200078e00ffULL, 0x0000000c6b007810ULL, 0x000fe20007ffe0ffULL,
0x0000000105297824ULL, 0x100fe200078e0219ULL, 0x000000106b027810ULL, 0x000fe40007ffe0ffULL,
0x0000006d05097212ULL, 0x080fe200078e3cffULL, 0x0000000800067824ULL, 0x000fe200078e00ffULL,
0x0000006d02047212ULL, 0x080fe200078e3cffULL, 0x0000000100217824ULL, 0x100fe200078e0219ULL,
0x0000000302077819ULL, 0x040fe200000006ffULL, 0x0000000102277824ULL, 0x000fe200078e0219ULL,
0x0000006d00037212ULL, 0x000fe200078e3cffULL, 0x00005e0021207625ULL, 0x000fe200078e006aULL,
0xfffffff807047812ULL, 0x000fc400078ee204ULL, 0xfffffff808097812ULL, 0x000fe200078ee209ULL,
0x00005e0027267625ULL, 0x080fe200078e006aULL, 0x0000001c6b077810ULL, 0x000fe40007ffe0ffULL,
0xfffffff806037812ULL, 0x000fe200078ee203ULL, 0x00005e0029287625ULL, 0x080fe200078e006aULL,
0x000000206b087810ULL, 0x040fe40007ffe0ffULL, 0x000000186b067810ULL, 0x000fe20007ffe0ffULL,
0x00000008070e7824ULL, 0x040fe200078e00ffULL, 0x0000006d070b7212ULL, 0x080fe200078e3cffULL,
0x00000008080f7824ULL, 0x040fe200078e00ffULL, 0x0000006d080c7212ULL, 0x080fe200078e3cffULL,
0x00000008060d7824ULL, 0x040fe200078e00ffULL, 0x0000006d060a7212ULL, 0x040fe200078e3cffULL,
0x00000001062b7824ULL, 0x000fe200078e0219ULL, 0xfffffff80e0b7812ULL, 0x000fe200078ee20bULL,
0x00000001082f7824ULL, 0x000fe200078e0219ULL, 0xfffffff80f0c7812ULL, 0x000fe200078ee20cULL,
0x00005e002b2a7625ULL, 0x000fe200078e006aULL, 0x000000286b0e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL, 0x00005e002f2e7625ULL, 0x080fe200078e006aULL,
0x0000002c6b0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000246b0d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e107824ULL, 0x040fe200078e00ffULL, 0x0000006d0e157212ULL, 0x0c0fe200078e3cffULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x0000006d0d147212ULL, 0x080fe200078e3cffULL,
0x000000010f357824ULL, 0x100fe200078e0219ULL, 0x000000030d117819ULL, 0x040fe200000006ffULL,
0x000000010d317824ULL, 0x100fe200078e0219ULL, 0x0000006d0f167212ULL, 0x000fe200078e3cffULL,
0x000000010e337824ULL, 0x000fe200078e0219ULL, 0x000000386b127810ULL, 0x000fe20007ffe0ffULL,
0x00005e0035347625ULL, 0x000fe200078e006aULL, 0xfffffff811147812ULL, 0x000fc400078ee214ULL,
0xfffffff810157812ULL, 0x000fe200078ee215ULL, 0x00000001123b7824ULL, 0x000fe200078e0219ULL,
0x000000306b107810ULL, 0x000fe20007ffe0ffULL, 0x00005e0031307625ULL, 0x080fe200078e006aULL,
0xfffffff813167812ULL, 0x000fe400078ee216ULL, 0x000000346b117810ULL, 0x040fe20007ffe0ffULL,
0x0000000810187824ULL, 0x000fe200078e00ffULL, 0x0000003c6b137810ULL, 0x000fe20007ffe0ffULL,
0x00005e0033327625ULL, 0x000fe200078e006aULL, 0x0000006d12617212ULL, 0x000fc400078e3cffULL,
0x00000003121a7819ULL, 0x000fe200000006ffULL, 0x00000008111b7824ULL, 0x000fe200078e00ffULL,
0x0000006d10177212ULL, 0x080fe200078e3cffULL, 0x00000008131d7824ULL, 0x000fe200078e00ffULL,
0x0000006d11607212ULL, 0x0c0fe200078e3cffULL, 0x0000000111397824ULL, 0x000fe200078e0219ULL,
0xfffffff81a617812ULL, 0x000fe200078ee261ULL, 0x00000001133d7824ULL, 0x040fe200078e0219ULL,
0x0000006d13627212ULL, 0x080fe200078e3cffULL, 0x00005e0039387625ULL, 0x000fe200078e006aULL,
0x0000006d6b1a7212ULL, 0x000fc400078e3cffULL, 0x00000019661f7210ULL, 0x080fe20007ffe0ffULL,
0x00005e003b3a7625ULL, 0x080fe200078e006aULL, 0xfffffff818177812ULL, 0x000fe400078ee217ULL,
0xfffffff81b607812ULL, 0x000fe200078ee260ULL, 0x000000016b1b7824ULL, 0x100fe200078e0219ULL,
0x000000076d187812ULL, 0x000fe200078ec0ffULL, 0x00005e001f1e7625ULL, 0x080fe200078e006aULL,
0xfffffff81d627812ULL, 0x000fe400078ee262ULL, 0x000000071a1c7812ULL, 0x000fe200078ec0ffULL,
0x00000001681d7824ULL, 0x000fe200078e0219ULL, 0x00000019072d7210ULL, 0x080fe20007ffe0ffULL,
0x00005e001b1a7625ULL, 0x000fe200078e006aULL, 0x0000001910377210ULL, 0x000fc40007ffe0ffULL,
0x00000008183f7812ULL, 0x000fe200078efcffULL, 0x00005e002d2c7625ULL, 0x000fe200078e006aULL,
0x0ffffff81c697812ULL, 0x000fc600078ef86dULL, 0x00005e001d1c7625ULL, 0x000fc800078e006aULL,
0x00005e0037367625ULL, 0x000fc800078e006aULL, 0x00005e003d3c7625ULL, 0x000fc800078e006aULL,
0x000000103f227825ULL, 0x000fc800078e001eULL, 0x000000103f1a7825ULL, 0x000fc800078e001aULL,
0x000000103f247825ULL, 0x000fc800078e0020ULL, 0x000000103f1e7825ULL, 0x000fe200078e002aULL,
0x0000003e672b7211ULL, 0x000fc600078e20ffULL, 0x0000001069197824ULL, 0x000fe400078e023eULL,
0x000000103f1c7825ULL, 0x000fc600078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a197faeULL, 0x0003e2000b901c46ULL, 0x000000103f207825ULL, 0x000fc600078e0034ULL,
0x000000001c2b7faeULL, 0x0005e2000b901c46ULL, 0x000000103f267825ULL, 0x000fc800078e0026ULL,
0x000000103f287825ULL, 0x000fe200078e0028ULL, 0x0000003e0a197211ULL, 0x002fc600078e20ffULL,
0x000000103f2c7825ULL, 0x000fe200078e002cULL, 0x0000003e161d7211ULL, 0x004fc600078e20ffULL,
0x000000103f2e7825ULL, 0x000fc800078e002eULL, 0x000000103f307825ULL, 0x000fc800078e0030ULL,
0x000000103f327825ULL, 0x000fc800078e0032ULL, 0x000000103f367825ULL, 0x000fc800078e0036ULL,
0x000000103f387825ULL, 0x000fc800078e0038ULL, 0x000000103f3a7825ULL, 0x000fc800078e003aULL,
0x000000103f3c7825ULL, 0x000fc800078e003cULL, 0x0000001065357824ULL, 0x100fe400078e023eULL,
0x00000010033f7824ULL, 0x100fe400078e023eULL, 0x0000001004417824ULL, 0x100fe200078e023eULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x0000001009437824ULL, 0x100fe400078e023eULL,
0x000000100b1b7824ULL, 0x100fe200078e023eULL, 0x00000000243f7faeULL, 0x0005e2000b901c46ULL,
0x000000100c457824ULL, 0x000fc400078e023eULL, 0x0000001014477824ULL, 0x100fe200078e023eULL,
0x0000000026417faeULL, 0x0007e2000b901c46ULL, 0x0000001015497824ULL, 0x000fc600078e023eULL,
0x0000000028437faeULL, 0x0009e2000b901c46ULL, 0x0000001017237824ULL, 0x002fc600078e023eULL,
0x000000001e197faeULL, 0x0003e2000b901c46ULL, 0x0000001060257824ULL, 0x004fc600078e023eULL,
0x000000002c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000001061277824ULL, 0x008fc600078e023eULL,
0x000000002e457faeULL, 0x0003e2000b901c46ULL, 0x0000001062297824ULL, 0x010fc600078e023eULL,
0x0000000030477faeULL, 0x0003e8000b901c46ULL, 0x0000000032497faeULL, 0x0003e8000b901c46ULL,
0x00000000201d7faeULL, 0x0003e8000b901c46ULL, 0x0000000036237faeULL, 0x0003e8000b901c46ULL,
0x0000000038257faeULL, 0x0003e8000b901c46ULL, 0x000000003a277faeULL, 0x0003e8000b901c46ULL,
0x000000003c297faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004ff637819ULL, 0x000fc4000001166dULL,
0x0000000818647812ULL, 0x000fc800078ef86dULL, 0x0000000763197812ULL, 0x002fc800078e7864ULL,
0x0000001964197211ULL, 0x000fca00078e20ffULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00000008631b7824ULL, 0x000fe200078e00ffULL, 0x000000001934783bULL, 0x000fe20000000200ULL,
0x000040007a717824ULL, 0x000fe200078e00ffULL, 0x000000016b417812ULL, 0x000fe200078ec0ffULL,
0x0000160000007945ULL, 0x000fe20003800000ULL, 0xfffffff81b187812ULL, 0x000fe400078ee218ULL,
0x0000100071727810ULL, 0x000fe40007ffe0ffULL, 0x0000000718467812ULL, 0x040fe200078ec0ffULL,
0x0000000818857824ULL, 0x000fe200078e00ffULL, 0x00000002631b7810ULL, 0x000fc40007ffe0ffULL,
0x00000001461a7812ULL, 0x000fe400078e786bULL, 0x000000071b1b7812ULL, 0x000fe400078e7864ULL,
0x000000851a737212ULL, 0x000fe400078efcffULL, 0x0000001018937810ULL, 0x000fe20007ffe0ffULL,
0x00000010641a7824ULL, 0x000fe200078e021bULL, 0x00000072731c7211ULL, 0x000fe400078e20ffULL,
0x0000000793447812ULL, 0x040fe200078ec0ffULL, 0x000000101a1a7824ULL, 0x000fe200078e00ffULL,
0x00000030188f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000893937824ULL, 0x000fe200078e00ffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x0000002018917810ULL, 0x000fc40007ffe0ffULL,
0x00000002466e7812ULL, 0x000fe200078e1e41ULL, 0x000000001a30783bULL, 0x0005e20000000200ULL,
0x0000000144707812ULL, 0x000fe400078e786bULL, 0x000000078f407812ULL, 0x040fe200078ec0ffULL,
0x000000088f8f7824ULL, 0x000fe200078e00ffULL, 0x0000000791427812ULL, 0x000fe400078ec0ffULL,
0x000000856e6e7212ULL, 0x000fe400078efcffULL, 0x0000009370707212ULL, 0x000fc400078efcffULL,
0x00000001401a7812ULL, 0x104fe200078e786bULL, 0x000000106e587824ULL, 0x100fe200078e0272ULL,
0x0000000391917819ULL, 0x000fe200000006ffULL, 0x00000010703c7824ULL, 0x100fe200078e0272ULL,
0x0000000142187812ULL, 0x000fe400078e786bULL, 0x0000008f1a7d7212ULL, 0x000fe200078efcffULL,
0x000000005858783bULL, 0x000ea20000000200ULL, 0x00000091186f7212ULL, 0x000fe400078efcffULL,
0x0000000244207812ULL, 0x000fe200078e1e41ULL, 0x000000107d387824ULL, 0x100fe200078e0272ULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x000000106f187824ULL, 0x000fe200078e0272ULL,
0x00000093207f7212ULL, 0x000fc400078efcffULL, 0x0000000242247812ULL, 0x100fe200078e1e41ULL,
0x000000003838783bULL, 0x000f220000000200ULL, 0x000000727f207211ULL, 0x000fe400078e20ffULL,
0x0000009124817212ULL, 0x000fe200078efcffULL, 0x000000001818783bULL, 0x000f620000000200ULL,
0x0000000440487812ULL, 0x000fe200078e1e41ULL, 0x0000001c345c723cULL, 0x002fe400000418ffULL,
0x0000001081287824ULL, 0x000fe200078e0272ULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x0000008f48877212ULL, 0x000fc800078efcffULL, 0x000000002828783bULL, 0x000e620000000200ULL,
0x0000001e341c723cULL, 0x000fe200000418ffULL, 0x00000010874c7824ULL, 0x000fcc00078e0272ULL,
0x000000004c4c783bULL, 0x000ff00000000200ULL, 0x00000058305c723cULL, 0x044ff2000004185cULL,
0x0000005a3058723cULL, 0x000ff0000004181cULL, 0x0000003c341c723cULL, 0x048ff000000418ffULL,
0x0000003e343c723cULL, 0x040ff000000418ffULL, 0x00000038342c723cULL, 0x050fee00000418ffULL,
0x0000000240387812ULL, 0x140fe200078e1e41ULL, 0x000000183424723cULL, 0x020fe200000418ffULL,
0x0000000640407812ULL, 0x000fc400078e1e41ULL, 0x0000008f38837212ULL, 0x080fe400078efcffULL,
0x0000008f408f7212ULL, 0x000fc600078efcffULL, 0x0000001083387824ULL, 0x000fe200078e0272ULL,
0x0000001a3418723cULL, 0x040ff000000418ffULL, 0x0000003a3434723cULL, 0x000fe200000418ffULL,
0x000000003838783bULL, 0x000eae0000000200ULL, 0x00000020301c723cULL, 0x042ff0000004181cULL,
0x000000223020723cULL, 0x040fee000004183cULL, 0x00000004633d7810ULL, 0x000fe20007ffe0ffULL,
0x000000283024723cULL, 0x000fe20000041824ULL, 0x00000004423e7812ULL, 0x000fc400078e1e41ULL,
0x0000000642427812ULL, 0x000fe400078e1e41ULL, 0x000000913e897212ULL, 0x080fe400078efcffULL,
0x000000073d297812ULL, 0x000fe400078e7864ULL, 0x00000006633d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001089507824ULL, 0x000fe200078e0272ULL, 0x0000009142917212ULL, 0x000fe200078efcffULL,
0x00000010643c7824ULL, 0x000fe200078e0229ULL, 0x000000073d3d7812ULL, 0x000fe200078e7864ULL,
0x0000002a3028723cULL, 0x000fe40000041818ULL, 0x000000103c3c7824ULL, 0x000fe200078e00ffULL,
0x000000005050783bULL, 0x000fe20000000200ULL, 0x00000010643d7824ULL, 0x000fc600078e023dULL,
0x000000003c48783bULL, 0x0002e20000000200ULL, 0x00000004441a7812ULL, 0x100fe200078e1e41ULL,
0x00000038302c723cULL, 0x044fe2000004182cULL, 0x0000000446187812ULL, 0x100fe400078e1e41ULL,
0x000000931a8b7212ULL, 0x000fe400078efcffULL, 0x00000085188d7212ULL, 0x000fe200078efcffULL,
0x00000010913c7824ULL, 0x102fe200078e0272ULL, 0x000000043d7e7819ULL, 0x000fe200000006ffULL,
0x000000108b547824ULL, 0x100fe200078e0272ULL, 0x000000728d187211ULL, 0x000fe200078e20ffULL,
0x000000108f387824ULL, 0x000fe200078e0272ULL, 0x0000003a3030723cULL, 0x000fe20000041834ULL,
0x000000007e34783bULL, 0x000fe20000000200ULL, 0x0000000646467812ULL, 0x000fc400078e1e41ULL,
0x0000000644447812ULL, 0x000fe200078e1e41ULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x0000008546857212ULL, 0x000fe400078efcffULL, 0x0000009344937212ULL, 0x000fe200078efcffULL,
0x000000005454783bULL, 0x000ea40000000200ULL, 0x0000001085447824ULL, 0x100fe400078e0272ULL,
0x000000003838783bULL, 0x000f220000000200ULL, 0x0000001093407824ULL, 0x000fc600078e0272ULL,
0x000000004444783bULL, 0x000f680000000200ULL, 0x000000004040783bULL, 0x000ea80000000200ULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x0000004c482c723cULL, 0x048ff0000004182cULL,
0x000000504824723cULL, 0x040ff00000041824ULL, 0x000000524828723cULL, 0x040ff00000041828ULL,
0x00000018485c723cULL, 0x042ff0000004185cULL, 0x0000001a4858723cULL, 0x040ff00000041858ULL,
0x00000054481c723cULL, 0x044ff0000004181cULL, 0x000000564820723cULL, 0x040ff00000041820ULL,
0x0000004e4830723cULL, 0x000ff00000041830ULL, 0x00000038342c723cULL, 0x050fee000004182cULL,
0x000003007c387a10ULL, 0x000fe20007ffe0ffULL, 0x00000044345c723cULL, 0x020fe6000004185cULL,
0x0000000138197810ULL, 0x000fc40007ffe0ffULL, 0x0000007738187211ULL, 0x000fe400078e40ffULL,
0x000000781900720cULL, 0x000fe20003f06070ULL, 0x000000463458723cULL, 0x000fe40000041858ULL,
0x0000620079397a24ULL, 0x000fcc00078e0218ULL, 0x00000040341c723cULL, 0x040ff0000004181cULL,
0x000000423420723cULL, 0x040ff00000041820ULL, 0x0000003c3424723cULL, 0x040ff00000041824ULL,
0x0000003e3428723cULL, 0x040ff00000041828ULL, 0x0000003a3430723cULL, 0x000fe20000041830ULL,
0x0000078000008947ULL, 0x000fee0003800000ULL, 0x000000100b3d7824ULL, 0x100fe200078e0272ULL,
0x000000187b377217ULL, 0x000fe20007800000ULL, 0x000000016b0b7824ULL, 0x000fe200078e0239ULL,
0x000000720c3b7211ULL, 0x080fe200078e20ffULL, 0x000000106d3f7824ULL, 0x000fe200078e00ffULL,
0x0000007203437211ULL, 0x000fe200078e20ffULL, 0x0000001009477824ULL, 0x100fe200078e0272ULL,
0x00000039074b7210ULL, 0x080fe20007ffe0ffULL, 0x000000100a417824ULL, 0x100fe200078e0272ULL,
0x000000703f3f7812ULL, 0x000fe200078ec0ffULL, 0x0000001015097824ULL, 0x000fe200078e0272ULL,
0x0000003968157210ULL, 0x000fe20007ffe0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e006aULL,
0x0000007260607211ULL, 0x000fc600078e20ffULL, 0x00000010173a7824ULL, 0x100fe200078e0272ULL,
0x0000000a3f0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000166177824ULL, 0x000fe400078e0239ULL,
0x00000010140c7824ULL, 0x100fe400078e0272ULL, 0x0000001016367824ULL, 0x000fe400078e0272ULL,
0x00005e0015147625ULL, 0x000fc800078e006aULL, 0x00005e0017167625ULL, 0x000fc800078e006aULL,
0x00000001021b7824ULL, 0x040fe200078e0239ULL, 0x000000163f167210ULL, 0x000fe20007f3e0ffULL,
0x0000000137377824ULL, 0x000fe400078e0a18ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000143f147210ULL, 0x000fe20007f1e0ffULL, 0x00005e001b1a7625ULL, 0x000fe200078e006aULL,
0x000000376b00720cULL, 0x000fe40003f66070ULL, 0x00000015ff157210ULL, 0x000fe200007fe4ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x000000370200720cULL, 0x080fe20003f06070ULL,
0x0000000100197824ULL, 0x100fe200078e0239ULL, 0x0000001a3f027210ULL, 0x000fe20007f3e0ffULL,
0x0000000106497824ULL, 0x000fe200078e0239ULL, 0x000000376800720cULL, 0x080fe20003f46070ULL,
0x0000001069697824ULL, 0x000fe200078e0272ULL, 0x000000376600720cULL, 0x080fe20003f86070ULL,
0x000000ffff037224ULL, 0x000fe200008e061bULL, 0x000000370000720cULL, 0x080fe20003fa6070ULL,
0x00005e0019187625ULL, 0x000fe200078e006aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a697faeULL, 0x0003e2000d901c46ULL, 0x000000370500720cULL, 0x000fc40003f26070ULL,
0x00005e00491a7625ULL, 0x000fe200078e006aULL, 0x000000183f187210ULL, 0x000fc60007fde0ffULL,
0x0000000105357824ULL, 0x000fe200078e0239ULL, 0x0000001a3f1a7210ULL, 0x000fe20007f7e0ffULL,
0x0000001067677824ULL, 0x000fe400078e0272ULL, 0x00005e0035347625ULL, 0x000fc600078e006aULL,
0x0000000014677faeULL, 0x0005e2000d101c46ULL, 0x0000001065657824ULL, 0x100fe200078e0272ULL,
0x000000370600720cULL, 0x080fe20003f46070ULL, 0x0000001004457824ULL, 0x000fe400078e0272ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000343f047210ULL, 0x000fe20007fde0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x000000370700720cULL, 0x000fe20003f66070ULL,
0x0000000016657faeULL, 0x0007e2000e101c46ULL, 0x0000003908077210ULL, 0x000fe20007ffe0ffULL,
0x000000010d0b7824ULL, 0x142fe200078e0239ULL, 0x000000370d00720cULL, 0x080fe20003f86070ULL,
0x000000010e0d7824ULL, 0x000fe200078e0239ULL, 0x0000000018437faeULL, 0x0003e2000e901c46ULL,
0x000000ffff057224ULL, 0x000fe200030e0635ULL, 0x000000370800720cULL, 0x080fe20003fa6070ULL,
0x00005e004b347625ULL, 0x000fe200078e006aULL, 0x0000000002457faeULL, 0x0009e2000c101c46ULL,
0x000000370e00720cULL, 0x000fc40003f06070ULL, 0x00005e0007067625ULL, 0x000fe200078e006aULL,
0x0000000004477faeULL, 0x000be2000c901c46ULL, 0x000000343f347210ULL, 0x000fe40007fde0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e006aULL, 0x000000063f067210ULL, 0x000fe20007f3e0ffULL,
0x000000001a417faeULL, 0x0003e4000d101c46ULL, 0x000000010f157824ULL, 0x004fe400078e0239ULL,
0x00005e000d027625ULL, 0x010fc800078e006aULL, 0x00000001100d7824ULL, 0x000fe200078e0239ULL,
0x000000023f0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff357224ULL, 0x000fe200030e0635ULL,
0x0000000a3f0a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x000000370f00720cULL, 0x000fe20003f26070ULL, 0x00005e0015047625ULL, 0x020fe200078e006aULL,
0x0000000bff0b7210ULL, 0x000fe200037fe4ffULL, 0x00000000343d7faeULL, 0x0003e4000d901c46ULL,
0x000000ffff0f7224ULL, 0x000fe200010e0603ULL, 0x000000043f147210ULL, 0x000fe20007fde0ffULL,
0x00005e000d027625ULL, 0x000fe200078e006aULL, 0x00000039120d7210ULL, 0x000fe20007ffe0ffULL,
0x00000000063b7faeULL, 0x0003e2000e901c46ULL, 0x000000371000720cULL, 0x080fe20003f46070ULL,
0x0000000111177824ULL, 0x008fe200078e0239ULL, 0x000000023f167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200030e0605ULL, 0x000000000a0c7faeULL, 0x0003e2000e101c46ULL,
0x00005e0017047625ULL, 0x000fe200078e006aULL, 0x000000371200720cULL, 0x000fc40003f86070ULL,
0x000000000e097faeULL, 0x0003e2000c101c46ULL, 0x000000ffff177224ULL, 0x000fe200018e0603ULL,
0x000000043f047210ULL, 0x000fe20007fde0ffULL, 0x00005e000d027625ULL, 0x000fe200078e006aULL,
0x000000371100720cULL, 0x000fe20003f66070ULL, 0x0000000014367faeULL, 0x0003e4000c901c46ULL,
0x00000001136b7824ULL, 0x000fe200078e0239ULL, 0x000000023f027210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x00000000163a7faeULL, 0x0003e2000d101c46ULL,
0x00005e006b6a7625ULL, 0x000fc800078e006aULL, 0x000000ffff037224ULL, 0x000fe200028e0603ULL,
0x000000371300720cULL, 0x000fe20003fa6070ULL, 0x0000001061617824ULL, 0x100fe200078e0272ULL,
0x0000006a3f107210ULL, 0x000fe20007fde0ffULL, 0x0000001062627824ULL, 0x000fe200078e0272ULL,
0x0000000004607faeULL, 0x0003e4000d901c46ULL, 0x0000006bff117210ULL, 0x000fe400037fe4ffULL,
0x0000000002617faeULL, 0x0003ea000e101c46ULL, 0x0000000010627faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000001004357824ULL, 0x000fe200078e0272ULL,
0x0000003902517210ULL, 0x080fe20007ffe0ffULL, 0x000000016b6b7824ULL, 0x000fe200078e0239ULL,
0x00000072031b7211ULL, 0x000fe200078e20ffULL, 0x000000106d047824ULL, 0x000fe200078e00ffULL,
0x000000390d977210ULL, 0x080fe20007ffe0ffULL, 0x00005e006b027625ULL, 0x000fe200078e006aULL,
0x00000039123f7210ULL, 0x000fc40007ffe0ffULL, 0x00000070044d7812ULL, 0x000fe200078ec0ffULL,
0x0000000168197824ULL, 0x100fe200078e0239ULL, 0x000000720c3d7211ULL, 0x000fe200078e20ffULL,
0x0000000105537824ULL, 0x100fe200078e0239ULL, 0x000000024d027210ULL, 0x000fe20007f1e0ffULL,
0x0000000166497824ULL, 0x000fe400078e0239ULL, 0x00005e0019047625ULL, 0x000fc800078e006aULL,
0x00000001004f7824ULL, 0x100fe200078e0239ULL, 0x0000007217007211ULL, 0x000fe200078e20ffULL,
0x0000000106557824ULL, 0x100fe400078e0239ULL, 0x0000000107577824ULL, 0x100fe400078e0239ULL,
0x0000000108957824ULL, 0x100fe400078e0239ULL, 0x000000010e997824ULL, 0x100fe400078e0239ULL,
0x000000010f9b7824ULL, 0x000fc400078e0239ULL, 0x00000001109d7824ULL, 0x100fe400078e0239ULL,
0x0000000111457824ULL, 0x100fe400078e0239ULL, 0x0000000113417824ULL, 0x000fe400078e0239ULL,
0x000000100a397824ULL, 0x100fe400078e0272ULL, 0x000000100b3b7824ULL, 0x000fe400078e0272ULL,
0x00005e0049067625ULL, 0x000fc800078e006aULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x000000044d047210ULL, 0x000fe20007f1e0ffULL, 0x00005e00510a7625ULL, 0x000fe200078e006aULL,
0x000000064d067210ULL, 0x000fe40007f3e0ffULL, 0x00000005ff057210ULL, 0x000fe200007fe4ffULL,
0x00005e00530c7625ULL, 0x000fe200078e006aULL, 0x0000000a4d0a7210ULL, 0x000fc60007f1e0ffULL,
0x00005e00550e7625ULL, 0x000fc800078e006aULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000c4d0c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000000e4d0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001009377824ULL, 0x000fe400078e0272ULL,
0x00005e0057107625ULL, 0x000fe200078e006aULL, 0x0000000fff0f7210ULL, 0x000fc600007fe4ffULL,
0x00005e0095127625ULL, 0x000fc800078e006aULL, 0x00005e004f087625ULL, 0x000fe200078e006aULL,
0x000000124d127210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000104d107210ULL, 0x040fe20007f3e0ffULL, 0x0000001014437824ULL, 0x100fe200078e0272ULL,
0x000000084d087210ULL, 0x000fe20007f5e0ffULL, 0x0000001015477824ULL, 0x100fe400078e0272ULL,
0x00000010164b7824ULL, 0x000fe400078e0272ULL, 0x00005e0097167625ULL, 0x000fc800078e006aULL,
0x00005e009b147625ULL, 0x000fc800078e006aULL, 0x00005e0099187625ULL, 0x000fc800078e006aULL,
0x0000001069697824ULL, 0x100fe400078e0272ULL, 0x0000001067677824ULL, 0x100fe400078e0272ULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000000164d167210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x000000144d147210ULL, 0x000fe20007f1e0ffULL,
0x0000001065657824ULL, 0x000fe200078e0272ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002697faeULL, 0x0003e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x000000184d187210ULL, 0x000fe20007f5e0ffULL, 0x00005e009d487625ULL, 0x080fe200078e006aULL,
0x00000015ff157210ULL, 0x000fe200007fe4ffULL, 0x0000000004677faeULL, 0x0003e4000b901c46ULL,
0x00005e0045447625ULL, 0x000fe200078e006aULL, 0x000000484d407210ULL, 0x000fe20007f1e0ffULL,
0x0000000006657faeULL, 0x0003e4000b901c46ULL, 0x00005e003f3e7625ULL, 0x000fc400078e006aULL,
0x00000000081b7faeULL, 0x0003e4000b901c46ULL, 0x00005e00416a7625ULL, 0x000fe400078e006aULL,
0x000000000a357faeULL, 0x0003e4000b901c46ULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x000000444d447210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000003e4d3e7210ULL, 0x040fe20007f5e0ffULL, 0x000000000c377faeULL, 0x0003e2000b901c46ULL,
0x0000006a4d487210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff417224ULL, 0x000fc400000e0649ULL,
0x000000000e397faeULL, 0x0003e2000b901c46ULL, 0x00000010609f7824ULL, 0x100fe400078e0272ULL,
0x000000ffff457224ULL, 0x000fe200008e0645ULL, 0x00000000103b7faeULL, 0x0003e2000b901c46ULL,
0x0000001061617824ULL, 0x100fe400078e0272ULL, 0x000000ffff3f7224ULL, 0x000fe200010e063fULL,
0x00000000123d7faeULL, 0x0003e2000b901c46ULL, 0x0000001062a17824ULL, 0x000fe400078e0272ULL,
0x000000ffff497224ULL, 0x000fe200018e066bULL, 0x0000000016437faeULL, 0x0003e8000b901c46ULL,
0x0000000018477faeULL, 0x0003e8000b901c46ULL, 0x00000000144b7faeULL, 0x0003e8000b901c46ULL,
0x0000000040007faeULL, 0x0003e8000b901c46ULL, 0x00000000449f7faeULL, 0x0003e8000b901c46ULL,
0x000000003e617faeULL, 0x0003e8000b901c46ULL, 0x0000000048a17faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000863037810ULL, 0x002fc40007ffe0ffULL, 0x0000300071007810ULL, 0x000fe40007ffe0ffULL,
0x0000000703037812ULL, 0x000fe400078e7864ULL, 0x000000007d147211ULL, 0x080fe200078e20ffULL,
0x0000001073047824ULL, 0x100fe200078e0200ULL, 0x0000000364037211ULL, 0x000fe200078e20ffULL,
0x00000010700c7824ULL, 0x100fe200078e0200ULL, 0x0000000081347211ULL, 0x000fe200078e20ffULL,
0x000000106f107824ULL, 0x000fe200078e0200ULL, 0x0000ffff74027812ULL, 0x000fe200078ec0ffULL,
0x0000001003037824ULL, 0x000fc400078e00ffULL, 0x000000106e187824ULL, 0x100fe400078e0200ULL,
0x0000001091407824ULL, 0x100fe400078e0200ULL, 0x00000010933c7824ULL, 0x000fe200078e0200ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000404783bULL, 0x000fe80000000200ULL,
0x000000000308783bULL, 0x0002a80000000200ULL, 0x000000000c0c783bULL, 0x000ee80000000200ULL,
0x000000001010783bULL, 0x000f220000000200ULL, 0x0000000c63037810ULL, 0x002fc60007ffe0ffULL,
0x000000001414783bULL, 0x000e620000000200ULL, 0x0000000703037812ULL, 0x000fc600078e7864ULL,
0x000000001818783bULL, 0x000fe40000000200ULL, 0x0000001064037824ULL, 0x000fe400078e0203ULL,
0x000000003434783bULL, 0x000fe40000000200ULL, 0x0000001003037824ULL, 0x000fe400078e00ffULL,
0x000000004040783bULL, 0x000fe80000000200ULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x00000004085c723cULL, 0x044fee000004185cULL, 0x0000000a63057810ULL, 0x040fe20007ffe0ffULL,
0x000000060858723cULL, 0x000fe20000041858ULL, 0x0000000e63637810ULL, 0x000fc40007ffe0ffULL,
0x0000000705057812ULL, 0x100fe400078e7864ULL, 0x0000000763637812ULL, 0x000fc600078e7864ULL,
0x0000001064057824ULL, 0x040fe200078e0205ULL, 0x0000000c081c723cULL, 0x008fe2000004181cULL,
0x0000001064637824ULL, 0x000fe400078e0263ULL, 0x0000001005057824ULL, 0x000fc600078e00ffULL,
0x0000000463637819ULL, 0x000fe200000006ffULL, 0x000000107f0c7824ULL, 0x100fe200078e0200ULL,
0x0000000e0820723cULL, 0x040fe20000041820ULL, 0x000000000504783bULL, 0x000ea80000000200ULL,
0x000000000c0c783bULL, 0x000ee60000000200ULL, 0x000000100824723cULL, 0x050fee0000041824ULL,
0x0000001083107824ULL, 0x100fe200078e0200ULL, 0x000000120828723cULL, 0x040fea0000041828ULL,
0x000000001010783bULL, 0x000f260000000200ULL, 0x00000014082c723cULL, 0x042ff0000004182cULL,
0x000000160830723cULL, 0x000fe20000041830ULL, 0x000000000314783bULL, 0x000fec0000000200ULL,
0x000000108d087824ULL, 0x100fe200078e0200ULL, 0x00000018045c723cULL, 0x044fea000004185cULL,
0x000000000808783bULL, 0x000e640000000200ULL, 0x0000001089187824ULL, 0x100fe200078e0200ULL,
0x0000001a0458723cULL, 0x040fea0000041858ULL, 0x000000001818783bULL, 0x000ea60000000200ULL,
0x0000000c041c723cULL, 0x048fee000004181cULL, 0x000000008b0c7211ULL, 0x000fe200078e20ffULL,
0x000000340424723cULL, 0x040fee0000041824ULL, 0x0000001087347824ULL, 0x100fe200078e0200ULL,
0x0000000e0420723cULL, 0x040fe20000041820ULL, 0x000000000c0c783bULL, 0x000eee0000000200ULL,
0x000000360428723cULL, 0x040fe20000041828ULL, 0x000000003434783bULL, 0x000f6e0000000200ULL,
0x00000010042c723cULL, 0x050fee000004182cULL, 0x0000001085107824ULL, 0x100fe200078e0200ULL,
0x000000120430723cULL, 0x000fe20000041830ULL, 0x000000006304783bULL, 0x000fe80000000200ULL,
0x000000001010783bULL, 0x000f260000000200ULL, 0x00000008145c723cULL, 0x042fee000004185cULL,
0x000000108f087824ULL, 0x000fe200078e0200ULL, 0x0000000a1458723cULL, 0x040fea0000041858ULL,
0x000000000808783bULL, 0x000e660000000200ULL, 0x000000181424723cULL, 0x044ff00000041824ULL,
0x0000000c141c723cULL, 0x048ff0000004181cULL, 0x0000000e1420723cULL, 0x040ff00000041820ULL,
0x00000034140c723cULL, 0x060ff0000004182cULL, 0x0000001a1428723cULL, 0x040ff00000041828ULL,
0x000000361430723cULL, 0x000ff00000041830ULL, 0x00000010045c723cULL, 0x050ff0000004185cULL,
0x000000120458723cULL, 0x040ff00000041858ULL, 0x000000400410723cULL, 0x040fe20000041824ULL,
0x0236140076257984ULL, 0x000eae0000000800ULL, 0x0000003c0414723cULL, 0x000fe2000004181cULL,
0x3db504f35c5c7820ULL, 0x000fc40000410000ULL, 0x3db504f35d5d7820ULL, 0x000fe40000410000ULL,
0x3db504f35e5e7820ULL, 0x000fe40000410000ULL, 0x3db504f35f5f7820ULL, 0x000fe20000410000ULL,
0x00000008040c723cULL, 0x002fe2000004180cULL, 0x3db504f358267820ULL, 0x000fe40000410000ULL,
0x3db504f359247820ULL, 0x000fc80000410000ULL, 0x3db504f35a087820ULL, 0x000fe20000410000ULL,
0x0000003e043c723cULL, 0x040fe20000041820ULL, 0x3db504f3101e7820ULL, 0x000fe40000410000ULL,
0x3db504f3111d7820ULL, 0x000fe40000410000ULL, 0x3db504f35b097820ULL, 0x000fe40000410000ULL,
0x0000888002207816ULL, 0x000fe200000000ffULL, 0x000000420440723cULL, 0x000fe20000041828ULL,
0x3db504f314237820ULL, 0x000fc40000410000ULL, 0x3db504f315227820ULL, 0x000fe40000410000ULL,
0x8000000020027824ULL, 0x000fe400078e00ffULL, 0x3db504f312007820ULL, 0x000fe20000410000ULL,
0x0000000a0404723cULL, 0x000fe20000041830ULL, 0x3db504f30c1a7820ULL, 0x000fe20000410000ULL,
0x8000000025ff7812ULL, 0x004fe20007804802ULL, 0x3db504f30d197820ULL, 0x000fe40000410000ULL,
0x3db504f30e0c7820ULL, 0x000fc40000410000ULL, 0x3db504f3170b7820ULL, 0x000fe40000410000ULL,
0x3db504f3160a7820ULL, 0x000fe40000410000ULL, 0x3db504f33c217820ULL, 0x000fe40000410000ULL,
0x3db504f33d1f7820ULL, 0x000fe40000410000ULL, 0x3db504f33e147820ULL, 0x000fe40000410000ULL,
0x3db504f33f3f7820ULL, 0x000fc40000410000ULL, 0x3db504f313117820ULL, 0x000fe40000410000ULL,
0x3db504f3401c7820ULL, 0x000fe40000410000ULL, 0x3db504f3411b7820ULL, 0x000fe40000410000ULL,
0x3db504f342107820ULL, 0x000fe40000410000ULL, 0x3db504f343437820ULL, 0x000fe40000410000ULL,
0x3db504f30f0e7820ULL, 0x000fc40000410000ULL, 0x3db504f304187820ULL, 0x000fe40000410000ULL,
0x3db504f305177820ULL, 0x000fe40000410000ULL, 0x3db504f3060d7820ULL, 0x000fe40000410000ULL,
0x3db504f307037820ULL, 0x000fe20000410000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000005e00167202ULL, 0x000fe20000000f00ULL,
0x000000ffff157224ULL, 0x000fe400078e005fULL, 0x000000ffff127224ULL, 0x000fc400078e003fULL,
0x000000ffff137224ULL, 0x000fe400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0043ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x0000001f20057819ULL, 0x000fe200000006ffULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x0236140076027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000046d007824ULL, 0x000fe200078e00ffULL,
0x000000757c00720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff000057812ULL, 0x000fca00078ec0ffULL, 0x000000807a027824ULL, 0x000fca00078e0205ULL,
0x0234000002047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x000000026d207824ULL, 0x000fe200078e00ffULL, 0x8000006c7b6c7210ULL, 0x000fc80007ffe0ffULL,
0x0000000620207812ULL, 0x000fc800078ec0ffULL, 0x0000000120257812ULL, 0x040fe400078efcffULL,
0x0000000820277812ULL, 0x040fe400078efcffULL, 0x0000006c2500720cULL, 0x080fe40003f26070ULL,
0x0000001020257812ULL, 0x000fe400078efcffULL, 0x0000006c2700720cULL, 0x080fe40003f06070ULL,
0x0000006c2500720cULL, 0x000fc40003fc6070ULL, 0x0000001120277812ULL, 0x040fe400078efcffULL,
0x0000001820257812ULL, 0x040fe400078efcffULL, 0x0000006c2000720cULL, 0x0c0fe40003f46070ULL,
0x0000006c2700720cULL, 0x080fe40003fa6070ULL, 0x0000006c2500720cULL, 0x000fe40003f66070ULL,
0x0000000920287812ULL, 0x000fc400078efcffULL, 0x0000001920277812ULL, 0x040fe400078efcffULL,
0x0000002020257812ULL, 0x000fe400078efcffULL, 0xff7fffff16167808ULL, 0x000fe40005000000ULL,
0xff7fffff5c5c7808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40004800000ULL,
0xff7fffff5d5d7808ULL, 0x000fc40004800000ULL, 0x0000006c2800720cULL, 0x080fe40003f86070ULL,
0x0000006c2700720cULL, 0x080fe40003f46070ULL, 0x0000006c2500720cULL, 0x000fe40003f26070ULL,
0x0000002120277812ULL, 0x040fe400078efcffULL, 0x0000002820257812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fc40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40004000000ULL,
0xff7fffff09097808ULL, 0x000fe40006000000ULL, 0xff7fffff24247808ULL, 0x000fe40006000000ULL,
0x0000006c2700720cULL, 0x080fe40003f06070ULL, 0x0000006c2500720cULL, 0x000fe40003f86070ULL,
0x0000002920277812ULL, 0x000fc400078efcffULL, 0x0000003020257812ULL, 0x000fe400078efcffULL,
0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL, 0xff7fffff23237808ULL, 0x000fe40007000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40006800000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0x0000006c2700720cULL, 0x000fc40003fc6070ULL, 0x0000006c2500720cULL, 0x000fe40003fa6070ULL,
0x0000003120277812ULL, 0x040fe400078efcffULL, 0x0000003820257812ULL, 0x040fe400078efcffULL,
0x0000003920207812ULL, 0x000fe400078efcffULL, 0xff7fffff14147808ULL, 0x000fe40005800000ULL,
0xff7fffff21217808ULL, 0x000fc40005800000ULL, 0xff7fffff12127808ULL, 0x000fe40005000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL, 0xff7fffff13137808ULL, 0x000fe40004800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40004800000ULL, 0x0000006c2700720cULL, 0x080fe40003f66070ULL,
0x0000006c2500720cULL, 0x000fc40003f46070ULL, 0x0000006c2000720cULL, 0x000fe40003f26070ULL,
0xff7fffff11117808ULL, 0x000fe40004000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL,
0xff7fffff10107808ULL, 0x000fe40006000000ULL, 0xff7fffff1c1c7808ULL, 0x000fe40006000000ULL,
0xff7fffff0f0f7808ULL, 0x000fc40007000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40007000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40005800000ULL, 0xff7fffff19197808ULL, 0x000fe40005800000ULL,
0xff7fffff0d0d7808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff03037808ULL, 0x000fe40004800000ULL, 0xff7fffff17177808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005c04047209ULL, 0x004fe40007810000ULL,
0x0000001605207209ULL, 0x000fe40007810000ULL, 0x0000005d04057209ULL, 0x000fe40007810000ULL,
0x0000001520257209ULL, 0x000fc40007810000ULL, 0x0000002605057209ULL, 0x000fe40007810000ULL,
0x0000000825047209ULL, 0x000fe40007810000ULL, 0x0000002405207209ULL, 0x000fe40007810000ULL,
0x0000000904057209ULL, 0x000fe40007810000ULL, 0x0000002320257209ULL, 0x000fe40007810000ULL,
0x0000000a05047209ULL, 0x000fc40007810000ULL, 0x0000002225207209ULL, 0x000fe40007810000ULL,
0x0000000b04057209ULL, 0x000fe40007810000ULL, 0x0000002120207209ULL, 0x000fe40007810000ULL,
0x0000001405057209ULL, 0x000fe40007810000ULL, 0x0000001f20257209ULL, 0x000fe40007810000ULL,
0x0000001205047209ULL, 0x000fc40007810000ULL, 0x0000001e25207209ULL, 0x000fe40007810000ULL,
0x0000001304047209ULL, 0x000fe40007810000ULL, 0x0000001d20057209ULL, 0x000fe40007810000ULL,
0x0000001104257209ULL, 0x000fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x0000001025207209ULL, 0x000fc40007810000ULL, 0x0000001b04057209ULL, 0x000fe40007810000ULL,
0x0000000f20257209ULL, 0x000fe40007810000ULL, 0x0000001a05047209ULL, 0x000fe40007810000ULL,
0x0000000c25257209ULL, 0x000fe40007810000ULL, 0x0000001904057209ULL, 0x000fe40007810000ULL,
0x0000000e25047209ULL, 0x000fc40007810000ULL, 0x0000001805207209ULL, 0x000fe40007810000ULL,
0x0000000d04047209ULL, 0x000fe40007810000ULL, 0x0000001720057209ULL, 0x000fe40007810000ULL,
0x00000003042b7209ULL, 0x000fe20007810000ULL, 0x00000ec27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x00000004052c7209ULL, 0x008fe20007810000ULL,
0x00000f127f007947ULL, 0x000fea000b800000ULL, 0x0c401f002b047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0007207f89ULL, 0x000f2200000e0000ULL,
0x000000042b277209ULL, 0x00afc60007810000ULL, 0x0c201f002c047f89ULL, 0x000e6200000e0000ULL,
0x0000000506287209ULL, 0x004fc60007810000ULL, 0x0c201f00272a7f89ULL, 0x000ea200000e0000ULL,
0x0000002007207209ULL, 0x010fc60007810000ULL, 0x0c201f0028297f89ULL, 0x000ee800000e0000ULL,
0x0c201f0020257f89ULL, 0x00092200000e0000ULL, 0x000000042c047209ULL, 0x002fe40007810000ULL,
0x0000002a27057209ULL, 0x004fe40007810000ULL, 0x0000002928067209ULL, 0x008fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0x3f80000000047882ULL, 0x000fe20000000000ULL,
0x3fb8aa3b052b7820ULL, 0x000fc40000410000ULL, 0x3fb8aa3b5c5c7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b5d5d7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x0000005c005c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b23237823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b22227823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b21217823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010807ULL,
0x0000005d005d7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1a1a7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b17077823ULL, 0x000fe20000010807ULL,
0x0000002400277308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b15157823ULL, 0x100fe4000001082bULL, 0x3fb8aa3b08177823ULL, 0x100fe2000001082bULL,
0x0000005c5d08723eULL, 0x008fe200000010ffULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001082bULL,
0x00000018002a7308ULL, 0x000fe20000000800ULL, 0x00000004ff307e24ULL, 0x000fe2000f8e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001082bULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b12127823ULL, 0x100fe2000001082bULL,
0x3f8000003030783eULL, 0x000fe200000010ffULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001082bULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001082bULL,
0x0000003000317202ULL, 0x000fe20000000f00ULL, 0x3fb8aa3b11117823ULL, 0x000fc4000001082bULL,
0x3fb8aa3b03037823ULL, 0x000fc6000001082bULL, 0x0000001500157308ULL, 0x000e700000000800ULL,
0x0000001700177308ULL, 0x000ff00000000800ULL, 0x0000000900187308ULL, 0x0002f00000000800ULL,
0x0000001f00287308ULL, 0x000fe20000000800ULL, 0x000000161509723eULL, 0x002fce00000010ffULL,
0x0000001a00247308ULL, 0x0003f00000000800ULL, 0x00000019001f7308ULL, 0x000be20000000800ULL,
0x3fb8aa3b0b1a7823ULL, 0x002fe2000001082bULL, 0x00000017180b723eULL, 0x008fcc00000010ffULL,
0x0000001b00297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0a197823ULL, 0x020fe2000001082bULL,
0x00000026270a723eULL, 0x000fcc00000010ffULL, 0x00000019002c7308ULL, 0x000ff00000000800ULL,
0x0000001a002d7308ULL, 0x0002f00000000800ULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000300818723cULL, 0x002fee00000418ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x0000002c2d15723eULL, 0x008fce00000010ffULL, 0x0000002100217308ULL, 0x000ef00000000800ULL,
0x0000001400267308ULL, 0x0003f00000000800ULL, 0x0000001200177308ULL, 0x000b220000000800ULL,
0x000000232214723eULL, 0x002fc400000010ffULL, 0x000000212816723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b0e217823ULL, 0x000fc8000001082bULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0f127823ULL, 0x020fe2000001082bULL, 0x000000261717723eULL, 0x010fcc00000010ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x000000301418723cULL, 0x000fee0000041818ULL,
0x0000001c001c7308ULL, 0x000e700000000800ULL, 0x0000001300137308ULL, 0x000ff00000000800ULL,
0x00000011002e7308ULL, 0x0007220000000800ULL, 0x0000001c290e723eULL, 0x002fce00000010ffULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0c117823ULL, 0x108fe2000001082bULL,
0x0000001e1d0c723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b0d1d7823ULL, 0x000fca000001082bULL,
0x00000012000f7308ULL, 0x000e620000000800ULL, 0x000000132e0d723eULL, 0x010fce00000010ffULL,
0x0000002100227308ULL, 0x0007e20000000800ULL, 0x000000100f0f723eULL, 0x002fe200000010ffULL,
0x0000000fff217424ULL, 0x008fe200078e00ffULL, 0xfffffffc6d107812ULL, 0x000fca00078ec0ffULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x00000010211e7219ULL, 0x000fe200000006ffULL,
0x000000300c18723cULL, 0x000fe20000041818ULL, 0x000000241f10723eULL, 0x000fe400000010ffULL,
0x000000001e2173a1ULL, 0x000ee600000e8000ULL, 0x0000001100117308ULL, 0x000f220000000800ULL,
0x000000001e0473c4ULL, 0x000f6e0000004000ULL, 0x0000001d00137308ULL, 0x000fe20000000800ULL,
0x0000002a0712723eULL, 0x002fc400000010ffULL, 0x0000002025077209ULL, 0x004fca0007810000ULL,
0x00000003001c7308ULL, 0x000e620000000800ULL, 0x000000112211723eULL, 0x010fe400000010ffULL,
0x000000051eff7c12ULL, 0x008fe4000f804021ULL, 0x000000131c13723eULL, 0x002fce00000010ffULL,
0x000000301028723cULL, 0x000fe80000041818ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000b0204008947ULL, 0x020fde000b800000ULL, 0x001c1fff28187589ULL, 0x0002a400000e0000ULL,
0x000000001e0373a1ULL, 0x000ee200000e8000ULL, 0x000000001e0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000051eff7c12ULL, 0x008fda000f804003ULL,
0x00000b2204008947ULL, 0x010fea000b800000ULL, 0x001c1fff2a197589ULL, 0x00072800000e0000ULL,
0x001c1fff011a7589ULL, 0x00066800000e0000ULL, 0x001c1fff1b1b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff037819ULL, 0x000fe4000001166dULL, 0x0000000c00317812ULL, 0x000fc400078ec0ffULL,
0x00000007031c7812ULL, 0x040fe200078ec0ffULL, 0x00000008031d7824ULL, 0x040fe200078e00ffULL,
0x0000000303217819ULL, 0x040fe200000006ffULL, 0x00000008032c7824ULL, 0x040fe200078e00ffULL,
0x00000003ff1f7212ULL, 0x000fe400078e33ffULL, 0x0000000803037810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8211e7812ULL, 0x10afe400078ee21cULL, 0x000000011d207812ULL, 0x100fe200078ef61cULL,
0x00000008033e7824ULL, 0x000fe200078e00ffULL, 0x000000021d227812ULL, 0x100fe200078ef61cULL,
0x0000000803217824ULL, 0x000fe200078e00ffULL, 0x000000031d247812ULL, 0x000fc400078ef61cULL,
0x000000041d267812ULL, 0x140fe400078ef61cULL, 0x000000051d287812ULL, 0x140fe400078ef61cULL,
0x000000061d2a7812ULL, 0x000fe400078ef61cULL, 0xfffffff82c2c7812ULL, 0x000fe400078ee21fULL,
0x00000003ff1f7212ULL, 0x000fe400078e33ffULL, 0x00000007031c7812ULL, 0x000fc400078ec0ffULL,
0x00000003031d7819ULL, 0x000fe400000006ffULL, 0x000110007a037811ULL, 0x000fe400078e58ffULL,
0x000000011d307812ULL, 0x100fe400078ef61cULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee21fULL,
0x000000101e007824ULL, 0x100fe200078e0203ULL, 0xfffffff8212e7812ULL, 0x100fe200078ee21cULL,
0x00000010221e7824ULL, 0x000fe200078e0203ULL, 0x000000021d327812ULL, 0x000fc400078ef61cULL,
0x000000031d347812ULL, 0x000fe200078ef61cULL, 0x00000001311f7824ULL, 0x000fe200078e021eULL,
0x000000041d367812ULL, 0x140fe200078ef61cULL, 0x00000010322b7824ULL, 0x100fe200078e0203ULL,
0x000000051d3a7812ULL, 0x140fe400078ef61cULL, 0x000000061d3c7812ULL, 0x000fe200078ef61cULL,
0x00000010201c7824ULL, 0x100fe200078e0203ULL, 0x0000000326227211ULL, 0x000fe200078e20ffULL,
0x0000001024207824ULL, 0x100fe200078e0203ULL, 0x000000036dff7812ULL, 0x000fe2000780c0ffULL,
0x0000001028247824ULL, 0x000fc400078e0203ULL, 0x000000102a267824ULL, 0x100fe200078e0203ULL,
0x0000002031217210ULL, 0x040fe20007ffe0ffULL, 0x00000001311d7824ULL, 0x040fe200078e0200ULL,
0x000000032e007211ULL, 0x080fe200078e20ffULL, 0x000000102c287824ULL, 0x100fe200078e0203ULL,
0x000000033a2e7211ULL, 0x000fe200078e20ffULL, 0x00000010302a7824ULL, 0x100fe200078e0203ULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x00000010342c7824ULL, 0x100fe200078e0203ULL,
0x0000000031007210ULL, 0x040fe20007ffe0ffULL, 0x00000010362d7824ULL, 0x100fe200078e0203ULL,
0x0000002e312e7210ULL, 0x000fe20007ffe0ffULL, 0x000000103c2f7824ULL, 0x000fc400078e0203ULL,
0x000000103e307824ULL, 0x000fe400078e0203ULL, 0x0000000131037824ULL, 0x040fe400078e021cULL,
0x0000000131237824ULL, 0x040fe400078e0222ULL, 0x0000000131257824ULL, 0x040fe200078e0224ULL,
0x0000000a03007388ULL, 0x0007e20000000800ULL, 0x0000000131277824ULL, 0x040fe400078e0226ULL,
0x0000000131297824ULL, 0x040fe200078e0228ULL, 0x000000141f007388ULL, 0x0007e20000000800ULL,
0x00000001312a7824ULL, 0x000fc400078e022aULL, 0x00000001311c7824ULL, 0x040fe200078e022bULL,
0x0000001621007388ULL, 0x0007e20000000800ULL, 0x00000001312c7824ULL, 0x040fe400078e022cULL,
0x0000000131087824ULL, 0x042fe200078e022dULL, 0x0000000c23007388ULL, 0x0007e20000000800ULL,
0x00000001311e7824ULL, 0x040fe400078e022fULL, 0x0000000131307824ULL, 0x000fe200078e0230ULL,
0x0000000e25007388ULL, 0x0007e80000000800ULL, 0x0000001027007388ULL, 0x0007e80000000800ULL,
0x0000001229007388ULL, 0x0007e80000000800ULL, 0x0000000900007388ULL, 0x0007e80000000800ULL,
0x0000000b2a007388ULL, 0x0007e80000000800ULL, 0x000000151c007388ULL, 0x0007e80000000800ULL,
0x000000172c007388ULL, 0x0007e80000000800ULL, 0x0000000d08007388ULL, 0x0007e80000000800ULL,
0x0000000f2e007388ULL, 0x0007e80000000800ULL, 0x000000111e007388ULL, 0x0007e80000000800ULL,
0x0000001330007388ULL, 0x0007e80000000800ULL, 0x0230000402008388ULL, 0x0007e80000000c00ULL,
0x0232001802008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000783800720cULL, 0x000fe20003f26070ULL, 0x0236080076ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff74ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff7c7224ULL, 0x000fc600078e0038ULL,
0x00000001ff747807ULL, 0x000fce0000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffb75000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e002fULL, 0x000108e000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff347224ULL, 0x000fe400078e0066ULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x000007b000007944ULL, 0x000fea0003c00000ULL,
0x00000033002f7202ULL, 0x004fe20000000f00ULL, 0xffff8b9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x002fe200078e0066ULL, 0x0001096000307802ULL, 0x000fe20000000f00ULL,
0x000000ffff357224ULL, 0x000fe400078e002eULL, 0x0000001fff367424ULL, 0x000fc400078e00ffULL,
0xffffffffff377424ULL, 0x000fe400078e00ffULL, 0x0000073000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff317224ULL, 0x004fe200078e0033ULL, 0xffff8b3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e0005ULL, 0x000109e000287802ULL, 0x000fe20000000f00ULL,
0x00000002ff2a7424ULL, 0x000fe400078e00ffULL, 0x0000001fff277424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000067000007944ULL, 0x002fea0003c00000ULL,
0x0000002500047202ULL, 0x004fe20000000f00ULL, 0xfffff0d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff257224ULL, 0x000fe200078e002bULL, 0x00010a6000287802ULL, 0x000fe20000000f00ULL,
0x00000002ff2a7424ULL, 0x002fc400078e00ffULL, 0x0000001fff277424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x000005f000007944ULL, 0x004fea0003c00000ULL,
0x000000252b2e7209ULL, 0x004fe20007810000ULL, 0x00000002ff2a7424ULL, 0x002fe200078e00ffULL,
0x0000000600257202ULL, 0x000fe20000000f00ULL, 0x0000001fff277424ULL, 0x000fe200078e00ffULL,
0x00010ad000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x0000058000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e0007ULL, 0x00000002002a7802ULL, 0x002fe20000000f00ULL,
0x0000001fff277424ULL, 0x000fe200078e00ffULL, 0x00010b4000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x0000002507207209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e002cULL,
0x0000001f00277802ULL, 0x002fe20000000f00ULL, 0x00000001ff2a7424ULL, 0x000fe200078e00ffULL,
0x00010bb000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x000000252c047209ULL, 0x004fe20007810000ULL,
0x000000ffff257224ULL, 0x000fe200078e002eULL, 0xffffffff00307802ULL, 0x002fe20000000f00ULL,
0x00000001ff2a7424ULL, 0x000fe200078e00ffULL, 0x00010c2000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff277424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x000000252e057209ULL, 0x004fe20007810000ULL, 0x000000ffff257224ULL, 0x000fe200078e0006ULL,
0x00010c9000287802ULL, 0x000fe20000000f00ULL, 0x00000001ff2a7424ULL, 0x002fc400078e00ffULL,
0x0000001fff277424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fe400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x0000002506067209ULL, 0x004fe20007810000ULL,
0x00000001ff2a7424ULL, 0x002fe200078e00ffULL, 0x0000002000257202ULL, 0x000fe20000000f00ULL,
0x0000001fff277424ULL, 0x000fe200078e00ffULL, 0x00010d0000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff307424ULL, 0x000fe400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0xffffeeb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x000fe200078e0028ULL,
0x0000001e00377202ULL, 0x000fe20000000f00ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x00010d7000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff367424ULL, 0x000fc400078e00ffULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0033ULL,
0xfffff49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x002fe200078e002aULL,
0x0000001e00377202ULL, 0x000fe20000000f00ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x00010df000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff367424ULL, 0x000fc400078e00ffULL,
0x000002a000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff357224ULL, 0x002fe200078e00ffULL,
0x00010e5000307802ULL, 0x000fe20000000f00ULL, 0x00001c1fff367424ULL, 0x000fc400078e00ffULL,
0x000000ffff377224ULL, 0x000fe400078e001eULL, 0x000000ffff197224ULL, 0x004fe400078e0033ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x0000001e00377202ULL, 0x002fe20000000f00ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x00010eb000307802ULL, 0x000fe20000000f00ULL,
0x00001c1fff367424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x004fe400078e0033ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0033ULL,
0xfffff3d000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000097812ULL, 0x000fc800078ec0ffULL,
0x018000000900780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0900720cULL, 0x040fe40003f25070ULL,
0x008000000900780cULL, 0x000fe40003f02070ULL, 0x00000001ff097807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000009ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007077812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000009ff7212ULL, 0x000fda000780c0ffULL, 0x0080000007000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077202ULL, 0x00efc60000000f00ULL,
0xfffeefb008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000003000007348ULL, 0x000fe80003800000ULL, 0x0c00002a25257389ULL, 0x0002a200000e0027ULL,
0xfffeef7028007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff317424ULL, 0x000fe200078e00ffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0000003534337389ULL, 0x0002a200000e0036ULL,
0xfffeef3030007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000023680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001f0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000788ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000800ULL, 0x00000000000003a0ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ba0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000bc0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000bd0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000bf0ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c60ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000c68ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000c78ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000011180ULL, 0xa400001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000012010ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012010ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000012490ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000c60ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000113a0ULL, 0x00000000000113a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000012490ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_16_m_16_sm_80_cubin_len = 75120;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
