/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001ce40ULL, 0x000000000001cac0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45346a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x454536316a4c4532ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL,
0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL,
0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL,
0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL,
0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL,
0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL,
0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL,
0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL,
0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL,
0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001c2ULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000c000100000208ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002e3ULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c000100000331ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b002200000377ULL, 0x000000000001b150ULL, 0x0000000000000170ULL,
0x000b0022000003aaULL, 0x000000000001b2c0ULL, 0x0000000000000040ULL, 0x000b0022000003d5ULL,
0x000000000001b300ULL, 0x0000000000000050ULL, 0x000b0022000003ffULL, 0x000000000001b350ULL,
0x0000000000000130ULL, 0x000a00030000046dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000048dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000001b480ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001b15000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x006ad00400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808c0828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808c92ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001b15000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808e0828808081ULL, 0x90082880808f0828ULL,
0x2880809108288080ULL, 0x8094082880809308ULL, 0x082880809d082880ULL, 0x8080a608288080a2ULL,
0xaa08288080a80828ULL, 0x288080ba08288080ULL, 0x80ee08288080ed08ULL, 0x16288080d2082880ULL,
0x0000031028808280ULL, 0xd292000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL,
0x000000e000000000ULL, 0x0001b2c000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808e0828808081ULL, 0x90082880808f0828ULL, 0x2880809108288080ULL,
0x8094082880809308ULL, 0x082880809d082880ULL, 0x8080a208288080a1ULL, 0xa908288080a60828ULL,
0x288080aa08288080ULL, 0x80ed08288080ba08ULL, 0x08288080ee082880ULL, 0x80828016288080a8ULL,
0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x0000019800000000ULL, 0x0001b30000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808e0828808081ULL,
0x90082880808f0828ULL, 0x2880809108288080ULL, 0x8094082880809308ULL, 0x082880809d082880ULL,
0x8080a208288080a1ULL, 0xa808288080a60828ULL, 0x288080aa08288080ULL, 0x80ed08288080ba08ULL,
0x08288080ee082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL, 0x288080a992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000026800000000ULL, 0x0001b35000000000ULL,
0x0000013000000000ULL, 0x0000180400000000ULL, 0x80aa288080a90900ULL, 0x0000000000002880ULL,
0x0000001700082f04ULL, 0x00082304000000dbULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL,
0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001000082304ULL,
0x0008120400000000ULL, 0x0000000000000010ULL, 0x0000001000081104ULL, 0x0008230400000000ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000014ULL, 0x000c170400601903ULL,
0x0058000a00000000ULL, 0x000c17040021f000ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL,
0x0048000800000000ULL, 0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040061f000ULL,
0x0028000600000000ULL, 0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000e6000043104ULL, 0xffffffff01cc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000032001cc2804ULL, 0x0000056000000410ULL, 0x00002f0000001f30ULL,
0x000030b000002fa0ULL, 0x0000339000003220ULL, 0x00003700000034f0ULL, 0x0000375000003740ULL,
0x0000405000003780ULL, 0x00004fe000004f40ULL, 0x0000527000005100ULL, 0x00005540000053e0ULL,
0x0000578000005740ULL, 0x000057c000005790ULL, 0x00006d4000005e80ULL, 0x00006f0000006de0ULL,
0x000071e000007070ULL, 0x0000755000007340ULL, 0x000075a000007590ULL, 0x00007c70000075d0ULL,
0x00008c2000008b80ULL, 0x00008eb000008d40ULL, 0x0000918000009020ULL, 0x000093d000009390ULL,
0x00009410000093e0ULL, 0x00009be000009bd0ULL, 0x00009c0000009bf0ULL, 0x0000ca400000ca10ULL,
0x0000ca900000ca60ULL, 0x0000d6a00000d660ULL, 0x0000d7200000d6d0ULL, 0x0001886000018820ULL,
0x0001888000018870ULL, 0x00018900000188e0ULL, 0x0001892000018910ULL, 0x00019db000019d50ULL,
0x00019e8000019e20ULL, 0x00019f4000019ee0ULL, 0x0001a02000019fb0ULL, 0x0001a1000001a090ULL,
0x0001a1c00001a160ULL, 0x0001a2900001a230ULL, 0x0001a3500001a2f0ULL, 0x0001a4300001a3c0ULL,
0x0001a5100001a4a0ULL, 0x0001a5d00001a570ULL, 0x0001a6a00001a640ULL, 0x0001a7600001a700ULL,
0x0001a8400001a7d0ULL, 0x0001a9200001a8b0ULL, 0x0001a9e00001a980ULL, 0x0001aab00001aa50ULL,
0x0001ab700001ab10ULL, 0x0001ac500001abe0ULL, 0x0001ad300001acc0ULL, 0x0001ae200001adb0ULL,
0x0001af200001aea0ULL, 0x0001b0200001afa0ULL, 0x0001b1200001b0a0ULL, 0x0000040002003904ULL,
0x0001e600000000ffULL, 0x00000440003f0100ULL, 0x0001e6080000000fULL, 0x000004e0003f0120ULL,
0x0001e6880000000fULL, 0x00000e80003f0120ULL, 0x0001e600000000ffULL, 0x00000fe0003f0107ULL,
0x0001e68c00000008ULL, 0x00001070003f0102ULL, 0x0001e68800000008ULL, 0x00002bf0003f0101ULL,
0x0001e60800000016ULL, 0x00002c30003f0101ULL, 0x0001e60c0000000cULL, 0x00002e00003f0105ULL,
0x0001e60c0000000cULL, 0x00004010003f0105ULL, 0x0001e6880000001dULL, 0x00004c60003f0101ULL,
0x0001e62800000028ULL, 0x00004ca0003f0101ULL, 0x0001e62c0000002aULL, 0x00004e70003f0105ULL,
0x0001e62c0000002aULL, 0x00005e40003f0105ULL, 0x0000000000000028ULL, 0x00006a80003f0101ULL,
0x0001e64800000026ULL, 0x00006aa0003f0101ULL, 0x0001e64c00000026ULL, 0x00006c70003f0105ULL,
0x0001e64c00000026ULL, 0x00007c50003f0105ULL, 0x0000000000000021ULL, 0x000088d0003f0101ULL,
0x0001e66800000024ULL, 0x000088f0003f0101ULL, 0x0001e66c00000024ULL, 0x00008ac0003f0105ULL,
0x0001e66c00000024ULL, 0x00009a40003f0105ULL, 0x0001e6a00000000cULL, 0x0000f5c0003f0101ULL,
0x0001e600000000ffULL, 0x00010e20003f0101ULL, 0x0001e604000000ffULL, 0x00011030003f0105ULL,
0x0001e604000000ffULL, 0x000158b0003f0105ULL, 0x0000000000000099ULL, 0x00015bb0003f0101ULL,
0x0000000400000099ULL, 0x00015d80003f0105ULL, 0x0000000400000099ULL, 0x00019ba0003f0105ULL,
0x0001e60800000022ULL, 0x00019c00003f0101ULL, 0x0001e61000000022ULL, 0x00019c60003f0101ULL,
0x0001e61800000022ULL, 0x00019cd0003f0101ULL, 0x0001e62000000022ULL, 0x00033803003f0101ULL,
0x0000e52000301c04ULL, 0x0000e7e00000e550ULL, 0x0000ebc00000e9d0ULL, 0x0000efa00000edb0ULL,
0x0000f3900000f190ULL, 0x000110900000f540ULL, 0x0000040100019d10ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000314ULL, 0x0000001700000002ULL, 0x0000000000000244ULL, 0x0000001700000002ULL,
0x0000000000000184ULL, 0x0000001700000002ULL, 0x00000000000000ccULL, 0x0000001700000002ULL,
0x0000000000000044ULL, 0x0000001700000002ULL, 0x00000000000002ebULL, 0x0000001700000002ULL,
0x000000000000021bULL, 0x0000001700000002ULL, 0x000000000000015eULL, 0x0000001700000002ULL,
0x00000000000000a8ULL, 0x0000001700000002ULL, 0x000000000001e700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000137919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x0000000113020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c0013040625ULL, 0x000fe200078e0004ULL, 0x0000000602080981ULL, 0x0002a8000c1e1900ULL,
0x0000000604090981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x00005900ff157624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x00000000000a7919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff167624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e640000002300ULL,
0x0000590016167a24ULL, 0x000fe400078e02ffULL, 0x00000000000c7919ULL, 0x000e620000002100ULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00067810ULL, 0x010fcc0007ffe0ffULL,
0x0000000600077305ULL, 0x000864000021f000ULL, 0x000000ffff067224ULL, 0x010fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x002fc800078e0a07ULL, 0x000059000b0b7a24ULL, 0x000fc800078e02ffULL,
0x0000000b07077227ULL, 0x000fe400078e0006ULL, 0x0000000000067919ULL, 0x000e680000002200ULL,
0x00000400070b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff027224ULL, 0x000fc800078e0a0bULL,
0x0000040002007624ULL, 0x000fca00078e0215ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010b0b2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0bba12ULL, 0x000fc800078e33ffULL, 0x0000000b00047306ULL, 0x008ee20000209000ULL,
0x000000ff0b00720cULL, 0x000fce0003fa5070ULL, 0x0000000400047308ULL, 0x008ee40000001000ULL,
0x0ffffffe04027810ULL, 0x008fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000724000021f000ULL,
0x000000ffff027224ULL, 0x008fe400078e00ffULL, 0x000000030b007224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a00ULL, 0x0000000503007227ULL, 0x000fcc00078e0002ULL,
0x0000000a00007227ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a00ULL,
0x000000030b027224ULL, 0x000fe400078e020aULL, 0x000001000d037a24ULL, 0x002fe400078e0206ULL,
0x00001fff0d0d7589ULL, 0x000fe200000e0000ULL, 0x0000000b0200720cULL, 0x000fe20003f66070ULL,
0x00000000030f7a24ULL, 0x000fca00078e020cULL, 0x000000ff0f00720cULL, 0x040fe40003f25270ULL,
0x0000000f0f00780cULL, 0x000fca0003f44070ULL, 0x0000000102023824ULL, 0x000fe200078e0a0bULL,
0x0000000100003810ULL, 0x000fe40007ffe0ffULL, 0x000000030f00780cULL, 0x000fe40003f64070ULL,
0x0000000b0200720cULL, 0x000fe20003f86070ULL, 0x3fffff80ff049424ULL, 0x000fe200078e00ffULL,
0x00000005ff027819ULL, 0x000fe2000001160cULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fc400078e00ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x01e60004ff009388ULL, 0x000fe80000000a00ULL, 0x00001fff02027589ULL, 0x000e6200000e0000ULL,
0x0000000100004810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff00d212ULL, 0x000fe200078e33ffULL,
0x01e608060f00a388ULL, 0x000fe20000008a00ULL, 0x0000007f0f00780cULL, 0x000fc60003f84070ULL,
0x000000ffff037224ULL, 0x000fc800078e0a00ULL, 0x000000030b037224ULL, 0x000fe400078e020aULL,
0x3fffff60ff0ab424ULL, 0x000fe400078e00ffULL, 0x0000002003037824ULL, 0x000fe400078e00ffULL,
0xff317217ff0ec424ULL, 0x000fe400078e00ffULL, 0x7fffff60ff0bb424ULL, 0x000fc600078e00ffULL,
0x01e4000e0f00c388ULL, 0x000fe20000004800ULL, 0x000000040d057824ULL, 0x002fc600078e0202ULL,
0x01e6880a0f00b388ULL, 0x0003e40000008a00ULL, 0x00000004050a7824ULL, 0x002fe400078e00ffULL,
0x0000000108080824ULL, 0x004fe400078e0a09ULL, 0x00005800ff088624ULL, 0x000fe400078e00ffULL,
0x0000580013098a24ULL, 0x000fe400078e02ffULL, 0x00005a00080c7a24ULL, 0x000fc400078e02ffULL,
0x0000001609827224ULL, 0x000fe400078e02ffULL, 0x000000010c047824ULL, 0x040fe200078e0a03ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000030c00720cULL, 0x000fe20003f26070ULL,
0x00005a00001b7a24ULL, 0x000fe200078e0282ULL, 0x0000002004047817ULL, 0x000fc80003800000ULL,
0x000000ff04817207ULL, 0x000fe20000800000ULL, 0x00000004ff047e24ULL, 0x000fc6000f8e00ffULL,
0x000000208100780cULL, 0x000fda0003f05270ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00005a00000c7b06ULL, 0x000e620000209000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x000000ffff067224ULL, 0x000fcc00078e00ffULL, 0x0000000c000c7308ULL, 0x002e620000001000ULL,
0x00000004ff0b7819ULL, 0x004fc80000011605ULL, 0x000000020b107810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0e7824ULL, 0x000fe200078e020bULL, 0x0ffffffe0c077810ULL, 0x002fc60007ffe0ffULL,
0x000000010a127824ULL, 0x000fc600078e0210ULL, 0x0000000700077305ULL, 0x000e62000021f000ULL,
0x0000000103147824ULL, 0x000fe400078e0212ULL, 0x000000ffff0f7224ULL, 0x002fc800078e0a07ULL,
0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL, 0x0000000f070f7227ULL, 0x000fc800078e0006ULL,
0x0000000103067824ULL, 0x000fe400078e020eULL, 0x000000140f117227ULL, 0x000fc800078e00ffULL,
0x000000060f077227ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a07ULL,
0x000000ffff177224ULL, 0x000fe400078e0a11ULL, 0x00005a000f0c7a24ULL, 0x000fe400078e0206ULL,
0x00005a00170f7a24ULL, 0x000fc600078e0214ULL, 0x00005a000c007a0cULL, 0x000fe40003f06070ULL,
0x00005a000f007a0cULL, 0x000fd60003f46070ULL, 0x80005a000c0c0a10ULL, 0x000fe40007ffe0ffULL,
0x80005a000f0f2a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000c007a0cULL, 0x000fe40003f26070ULL,
0x00005a000f007a0cULL, 0x000fe40003f66070ULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000000111112810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff0c7a12ULL, 0x000fc600078e33ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x0000000111113810ULL, 0x000fe40007ffe0ffULL, 0x000000070c0f7207ULL, 0x040fe40004000000ULL,
0x000000110c117207ULL, 0x000fe20004000000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x0000000a81077217ULL, 0x000fe20007800000ULL, 0x000000ffff177224ULL, 0x000fe400078e0a0fULL,
0x000000ffff197224ULL, 0x000fc400078e0a11ULL, 0x00005a0017067a24ULL, 0x000fe400078e0206ULL,
0x00005a0019147a24ULL, 0x000fe400078e0214ULL, 0x000000011b067824ULL, 0x040fe400078e0206ULL,
0x000000011b147824ULL, 0x000fe400078e0214ULL, 0x0000000107077824ULL, 0x000fe400078e0a0aULL,
0x000000160f067224ULL, 0x080fe200078e0206ULL, 0x000000f00c0f7812ULL, 0x000fe200078ec0ffULL,
0x00000016110a7224ULL, 0x000fe200078e0214ULL, 0x000000070b00720cULL, 0x080fe20003f06070ULL,
0x000000100e117824ULL, 0x000fe200078e00ffULL, 0x000000071000720cULL, 0x000fe20003f26070ULL,
0x0000010006067825ULL, 0x000fc800078e00ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000f06067212ULL, 0x000fc600078efcffULL, 0x000000010e107824ULL, 0x100fe200078e0205ULL,
0x0000000f0a0a7212ULL, 0x000fe200078efcffULL, 0x00000001120e7824ULL, 0x000fe200078e0205ULL,
0x0000600006067a10ULL, 0x000fe20007f5e0ffULL, 0x00000010120f7824ULL, 0x000fe200078e00ffULL,
0xfffffff011107812ULL, 0x000fe400078ee210ULL, 0x000060000a0a7a10ULL, 0x000fe40007f7e0ffULL,
0xfffffff00f0e7812ULL, 0x000fe200078ee20eULL, 0x00000010100f7824ULL, 0x000fe200078e00ffULL,
0x0000610007077a10ULL, 0x000fc400017fe4ffULL, 0x000061000b0b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000100e117824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e8000c101c46ULL, 0x000000000a117faeULL, 0x0003e2000c901c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x00005a00000b7b06ULL, 0x000e620000209000ULL,
0x0000000000057919ULL, 0x000ea20000000000ULL, 0x000000ffff067224ULL, 0x000fcc00078e00ffULL,
0x0000000b000b7308ULL, 0x002e620000001000ULL, 0x0000000a050e7211ULL, 0x004fc800078fe0ffULL,
0x000000020e107810ULL, 0x000fe40007ffe0ffULL, 0x0ffffffe0b0c7810ULL, 0x002fc60007ffe0ffULL,
0x00000001030b7824ULL, 0x000fe200078e0210ULL, 0x0000000c00077305ULL, 0x000e64000021f000ULL,
0x000000ffff0f7224ULL, 0x002fc800078e0a07ULL, 0x00005a000f0f7a24ULL, 0x000fc800078e02ffULL,
0x0000000f070f7227ULL, 0x000fc800078e0006ULL, 0x0000000103067824ULL, 0x000fe400078e020eULL,
0x0000000b0f0c7227ULL, 0x000fc800078e00ffULL, 0x000000060f077227ULL, 0x000fc800078e00ffULL,
0x000000ffff0f7224ULL, 0x000fe400078e0a07ULL, 0x000000ffff127224ULL, 0x000fe400078e0a0cULL,
0x00005a000f0a7a24ULL, 0x000fe400078e0206ULL, 0x00005a00120f7a24ULL, 0x000fe400078e020bULL,
0x000000100e127824ULL, 0x000fe200078e00ffULL, 0x00005a000a007a0cULL, 0x000fe40003f06070ULL,
0x00005a000f007a0cULL, 0x000fd60003f46070ULL, 0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL,
0x80005a000f0f2a10ULL, 0x000fe40007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fe40003f26070ULL,
0x00005a000f007a0cULL, 0x000fe40003f66070ULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c2810ULL, 0x000fc40007ffe0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x00005a00ff0a7a12ULL, 0x000fc600078e33ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x000000010c0c3810ULL, 0x000fe40007ffe0ffULL, 0x000000070a077207ULL, 0x040fe40004000000ULL,
0x0000000c0a0a7207ULL, 0x000fc60004000000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0a07ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a0aULL, 0x00005a000f067a24ULL, 0x000fe400078e0206ULL,
0x00005a000c0b7a24ULL, 0x000fe400078e020bULL, 0x000000011b067824ULL, 0x040fe400078e0206ULL,
0x000000011b0b7824ULL, 0x000fc400078e020bULL, 0x00000010050c7824ULL, 0x000fe400078e00ffULL,
0x0000001607067224ULL, 0x080fe400078e0206ULL, 0x000000160a0b7224ULL, 0x000fe200078e020bULL,
0x000000f00c117812ULL, 0x000fe200078ec0ffULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x000001000b0a7825ULL, 0x000fe200078e00ffULL, 0x0000001106067212ULL, 0x000fc600078efcffULL,
0x000000010e0f7824ULL, 0x100fe200078e0205ULL, 0x000000110a0a7212ULL, 0x000fe200078efcffULL,
0x00000001100e7824ULL, 0x000fe200078e0205ULL, 0x0000600006067a10ULL, 0x000fe20007f1e0ffULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0xfffffff0120f7812ULL, 0x000fe400078ee20fULL,
0x000060000a0a7a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff0110e7812ULL, 0x000fe200078ee20eULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x0000610007077a10ULL, 0x000fc400007fe4ffULL,
0x000061000b0b7a10ULL, 0x000fe20000ffe4ffULL, 0x000000100e117824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060f7faeULL, 0x0003e8000b901c46ULL,
0x000000000a117faeULL, 0x0003e4000b901c46ULL, 0x00000000000a7919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff9a7424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600077300ULL, 0x000e7000000e0000ULL,
0x00000006000b7309ULL, 0x000ea20000000000ULL, 0x0000000a0700720cULL, 0x002fe20003f02070ULL,
0x000000ffff077224ULL, 0x004fc400078e0a0bULL, 0x00006600130a7625ULL, 0x000fd400078e009aULL,
0x01e60407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000060a067981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0d00720cULL, 0x000fe40003f05270ULL, 0x000000ff06077810ULL, 0x006fc80007ffe0ffULL,
0x00000008ff077819ULL, 0x000fce0000011607ULL, 0x0000e5b000008947ULL, 0x000fea0003800000ULL,
0x0000000213097824ULL, 0x000fe400078e00ffULL, 0x0000000802087824ULL, 0x000fe400078e00ffULL,
0x00000003ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e68c0b08ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000001040a7810ULL, 0x000fe20007ffe0ffULL, 0x00005900090b7624ULL, 0x002fe200078e0215ULL,
0x00000001ff207819ULL, 0x000fe20000011602ULL, 0x01e6880008ff7f8cULL, 0x0003e2000c80043fULL,
0x000000070a00720cULL, 0x000fe20003f06070ULL, 0x00000001000a7824ULL, 0x000fe200078e020bULL,
0x00000001020b7812ULL, 0x000fe200078ec0ffULL, 0x0000002020097824ULL, 0x000fc800078e00ffULL,
0x00000100040f7824ULL, 0x000fc800078e0209ULL, 0x000068000a257a24ULL, 0x000fe400078e020fULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1a7819ULL, 0x002fe20000011605ULL,
0x00000002201d7824ULL, 0x000fe200078e020bULL, 0x0000000f060d7217ULL, 0x000fe40007800000ULL,
0x000000041a0e7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1a187810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0fULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000010e0f7824ULL, 0x100fe200078e0205ULL, 0x000000081a127810ULL, 0x000fe20007ffe0ffULL,
0x000000080e1e7824ULL, 0x000fe200078e00ffULL, 0x000000200d1b7817ULL, 0x000fe20003800000ULL,
0x0000000118117824ULL, 0x000fe200078e0205ULL, 0x000000141a287810ULL, 0x000fe20007ffe0ffULL,
0x0000000818247824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL,
0x000000800b0c7824ULL, 0x000fe200078e020cULL, 0x0000001b0e00720cULL, 0x080fe20003f86070ULL,
0x00000001250f7824ULL, 0x040fe200078e021aULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000000101a1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112107824ULL, 0x040fe200078e0205ULL, 0x0000001b1200720cULL, 0x0c0fe20003f66070ULL,
0x0000000812137824ULL, 0x000fe200078e00ffULL, 0x0000001b1800720cULL, 0x080fe20003f46070ULL,
0x0000000125117824ULL, 0x000fe200078e020eULL, 0x0000001b1a00720cULL, 0x000fe20003fa6070ULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0xfffffff813227812ULL, 0x000fc400078ee210ULL,
0x000160001d1d7811ULL, 0x000fe200078e68ffULL, 0x0000000128157824ULL, 0x000fe200078e0205ULL,
0x000064000e147a10ULL, 0x000fe20007f1e0ffULL, 0x00000008282a7824ULL, 0x000fe400078e00ffULL,
0x0000010011107825ULL, 0x000fc600078e000cULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL,
0x000000011c137824ULL, 0x000fe200078e0205ULL, 0x0000640010167a10ULL, 0x000fe20007f3e0ffULL,
0x000000081c267824ULL, 0x000fe200078e00ffULL, 0x000065000f157a10ULL, 0x000fe200007fe4ffULL,
0x00000001250f7824ULL, 0x000fe200078e0212ULL, 0x0000650011177a10ULL, 0x000fe20000ffe4ffULL,
0x0000000125117824ULL, 0x000fe200078e0218ULL, 0xfffffff826267812ULL, 0x000fe200078ee213ULL,
0x000000011a127824ULL, 0x000fe200078e0205ULL, 0x0000001b1c00720cULL, 0x000fe20003f26070ULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x0000000125137824ULL, 0x000fe200078e021cULL,
0x00000007121c7812ULL, 0x000fe200078ec0ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x000064000e187a10ULL, 0x000fe40007f1e0ffULL, 0x0ffffff81c1c7812ULL, 0x000fe200078ef805ULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x0000640010107a10ULL, 0x000fe40007fde0ffULL,
0x000065000f197a10ULL, 0x000fe200007fe4ffULL, 0x00000001250f7824ULL, 0x000fe200078e0228ULL,
0x0000650011117a10ULL, 0x000fe200037fe4ffULL, 0x000000101c1f7824ULL, 0x000fe200078e021dULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x000000181a1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000650013137a10ULL, 0x000fe200037fe4ffULL,
0x000000101e217824ULL, 0x000fe200078e021dULL, 0x0000001c1a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e2000e901c46ULL,
0x000064000e1a7a10ULL, 0x000fe20007fde0ffULL, 0x0000000125237824ULL, 0x040fe200078e021cULL,
0x0000001b2800720cULL, 0x080fe20003f06070ULL, 0x0000000016217faeULL, 0x0005e2000e101c46ULL,
0x0000001b1c00720cULL, 0x080fe20003fa6070ULL, 0x0000000125257824ULL, 0x000fe200078e021eULL,
0x0000001b1e00720cULL, 0x000fc40003f86070ULL, 0x000065000f1b7a10ULL, 0x000fe200037fe4ffULL,
0x00000100230e7825ULL, 0x000fc800078e000cULL, 0x000000011c147824ULL, 0x102fe200078e0205ULL,
0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x000000081c1f7824ULL, 0x000fe400078e00ffULL,
0x000000011e157824ULL, 0x040fe200078e0205ULL, 0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x000000081e167824ULL, 0x004fe200078e00ffULL, 0xfffffff81f147812ULL, 0x000fe200078ee214ULL,
0x00000100250c7825ULL, 0x000fc600078e000cULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x0000001022157824ULL, 0x100fe200078e021dULL, 0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x0000001024177824ULL, 0x100fe400078e021dULL, 0x00000010261f7824ULL, 0x100fe200078e021dULL,
0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x000000102a217824ULL, 0x100fe200078e021dULL,
0x0000000018157faeULL, 0x0003e2000d901c46ULL, 0x0000001014237824ULL, 0x100fe400078e021dULL,
0x00000010161d7824ULL, 0x000fe200078e021dULL, 0x0000000010177faeULL, 0x0003e8000d101c46ULL,
0x00000000121f7faeULL, 0x0003e8000c901c46ULL, 0x000000001a217faeULL, 0x0003e8000c101c46ULL,
0x000000000e237faeULL, 0x0003e8000e901c46ULL, 0x000000000c1d7faeULL, 0x0003e2000e101c46ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x0000000805107811ULL, 0x042fe200078fe8ffULL,
0x00000002201b7824ULL, 0x000fe200078e020bULL, 0x00000004050e7811ULL, 0x000fc400078fe8ffULL,
0x0000000c05127811ULL, 0x040fe200078fe8ffULL, 0x00000001100f7824ULL, 0x140fe200078e0205ULL,
0x0000001405167811ULL, 0x040fe200078fe8ffULL, 0x0000000810147824ULL, 0x000fe200078e00ffULL,
0x0000001805187811ULL, 0x040fe200078fe8ffULL, 0x000000010e0d7824ULL, 0x000fe200078e0205ULL,
0x000000700c1a7812ULL, 0x000fe200078ec0ffULL, 0x000000080e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff814217812ULL, 0x000fe200078ee20fULL, 0x0000000812227824ULL, 0x000fe200078e00ffULL,
0x0000001005147811ULL, 0x040fe200078fe8ffULL, 0x0000000816267824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x00000001120d7824ULL, 0x100fe200078e0205ULL,
0x0000001c051c7811ULL, 0x040fe200078fe8ffULL, 0x00000001140f7824ULL, 0x140fe200078e0205ULL,
0x00000005050c7211ULL, 0x080fe200078fe8ffULL, 0x0000000814247824ULL, 0x000fe200078e00ffULL,
0x0000000516117210ULL, 0x000fe20007ffe0ffULL, 0x0000000118137824ULL, 0x000fe200078e0205ULL,
0xfffffff822227812ULL, 0x000fe200078ee20dULL, 0x0000000818287824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x00000001250f7824ULL, 0x000fe200078e020eULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000011c0e7824ULL, 0x040fe200078e0205ULL,
0x00000025050d7211ULL, 0x000fe200078fe8ffULL, 0x000000081c1f7824ULL, 0x000fe200078e00ffULL,
0x000160001b2b7811ULL, 0x000fe200078e68ffULL, 0x000000800b1a7824ULL, 0x000fe200078e021aULL,
0xfffffff826267812ULL, 0x000fe200078ee211ULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee213ULL, 0x0000000125117824ULL, 0x000fe200078e0210ULL,
0xfffffff81f2a7812ULL, 0x000fe200078ee20eULL, 0x00000001251d7824ULL, 0x040fe200078e021cULL,
0x0ffffff80c1c7812ULL, 0x000fe200078ef805ULL, 0x0000000125137824ULL, 0x000fc400078e0212ULL,
0x000001000d0c7825ULL, 0x000fc800078e001aULL, 0x0000000125157824ULL, 0x000fe200078e0214ULL,
0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x000001000f0e7825ULL, 0x000fc600078e001aULL,
0x000065000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x0000000125177824ULL, 0x000fe200078e0216ULL,
0x000064000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000010011107825ULL, 0x000fc600078e001aULL,
0x000065000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000125197824ULL, 0x000fe200078e0218ULL,
0x0000640010107a10ULL, 0x000fe20007f5e0ffULL, 0x0000010013127825ULL, 0x000fc600078e001aULL,
0x0000650011117a10ULL, 0x000fe200017fe4ffULL, 0x0000010015147825ULL, 0x000fe200078e001aULL,
0x0000640012127a10ULL, 0x000fc60007f7e0ffULL, 0x0000010017167825ULL, 0x100fe200078e001aULL,
0x0000640014147a10ULL, 0x000fe40007f1e0ffULL, 0x0000650013137a10ULL, 0x000fe20001ffe4ffULL,
0x0000010019187825ULL, 0x100fe200078e001aULL, 0x0000640016167a10ULL, 0x000fe40007f3e0ffULL,
0x0000650015157a10ULL, 0x000fe200007fe4ffULL, 0x000001001d1a7825ULL, 0x000fe200078e001aULL,
0x0000640018187a10ULL, 0x000fe40007f5e0ffULL, 0x0000650017177a10ULL, 0x000fe20000ffe4ffULL,
0x000000101c1d7824ULL, 0x100fe200078e022bULL, 0x000064001a1a7a10ULL, 0x000fe20007f7e0ffULL,
0x000000101e1f7824ULL, 0x100fe200078e022bULL, 0x0000650019197a10ULL, 0x000fe200017fe4ffULL,
0x0000001021217824ULL, 0x100fe200078e022bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x0000001022237824ULL, 0x100fe200078e022bULL,
0x000065001b1b7a10ULL, 0x000fe20001ffe4ffULL, 0x0000001024257824ULL, 0x100fe200078e022bULL,
0x000000000e1f7faeULL, 0x0003e2000b901c46ULL, 0x0000001026277824ULL, 0x000fc400078e022bULL,
0x0000001028297824ULL, 0x100fe200078e022bULL, 0x0000000010217faeULL, 0x0003e2000b901c46ULL,
0x000000102a2b7824ULL, 0x000fc600078e022bULL, 0x0000000012237faeULL, 0x0003e8000b901c46ULL,
0x0000000014257faeULL, 0x0003e8000b901c46ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000018297faeULL, 0x0003e8000b901c46ULL, 0x000000001a2b7faeULL, 0x0003e4000b901c46ULL,
0x000000070400720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff227424ULL, 0x000fe200078e00ffULL, 0x00000000006a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff257224ULL, 0x002fe200078e00ffULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00007b8000000947ULL, 0x000fea0003800000ULL, 0xff317217ff227424ULL, 0x000fe400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x00000001040c7810ULL, 0x040fe20007ffe0ffULL,
0x0000010004267824ULL, 0x000fe200078e0209ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000070c00720cULL, 0x000fe40003f06070ULL, 0x0000004026137810ULL, 0x000fca0007ffe0ffULL,
0x000068000a247a24ULL, 0x000fcc00078e0213ULL, 0x0000065000008947ULL, 0x020fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe20000011605ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x00000013060c7217ULL, 0x000fe20007800000ULL, 0x0000000220217824ULL, 0x000fe200078e020bULL,
0x000000041f157810ULL, 0x040fe20007ffe0ffULL, 0x000000011f1a7824ULL, 0x040fe200078e0205ULL,
0x000000081f177810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a13ULL,
0x0000000c1f1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115127824ULL, 0x100fe200078e0205ULL,
0x000000101f277810ULL, 0x000fe20007ffe0ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0x000000200c0c7817ULL, 0x000fe20003800000ULL, 0x0000000117137824ULL, 0x100fe200078e0205ULL,
0x000000141f2b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008176c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8192a7812ULL, 0x000fe200078ee212ULL, 0x0000001005127824ULL, 0x000fe200078e00ffULL,
0x0000000c1500720cULL, 0x080fe20003f86070ULL, 0x000000011b147824ULL, 0x000fe200078e0205ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee213ULL, 0x000000011f137824ULL, 0x000fe200078e0224ULL,
0x0000007012127812ULL, 0x000fe200078ec0ffULL, 0x000000081b197824ULL, 0x000fe200078e00ffULL,
0x000000071a1e7812ULL, 0x000fe200078ec0ffULL, 0x000000012b167824ULL, 0x100fe200078e0205ULL,
0x0000000c1f00720cULL, 0x080fe20003f66070ULL, 0x000000800b287824ULL, 0x000fe200078e0212ULL,
0xfffffff8196e7812ULL, 0x000fe200078ee214ULL, 0x0000000127147824ULL, 0x000fe200078e0205ULL,
0x0000000c1b00720cULL, 0x000fe20003f26070ULL, 0x0000010013127825ULL, 0x000fe200078e0028ULL,
0x0001700021217811ULL, 0x000fc400078e68ffULL, 0x0ffffff81e1e7812ULL, 0x000fe200078ef805ULL,
0x0000000827197824ULL, 0x000fe200078e00ffULL, 0x0000640012187a10ULL, 0x000fe20007f1e0ffULL,
0x000000082b1d7824ULL, 0x000fe200078e00ffULL, 0x000000181f6d7810ULL, 0x000fe20007ffe0ffULL,
0x000000102a237824ULL, 0x000fe200078e0221ULL, 0xfffffff819707812ULL, 0x000fe400078ee214ULL,
0x0000650013197a10ULL, 0x000fe200007fe4ffULL, 0x0000000115137824ULL, 0x100fe200078e0224ULL,
0x0000000c1700720cULL, 0x040fe20003f06070ULL, 0x0000000117157824ULL, 0x000fe200078e0224ULL,
0xfffffff81d727812ULL, 0x000fe200078ee216ULL, 0x0000010013127825ULL, 0x000fe200078e0028ULL,
0x0000001c1f6f7810ULL, 0x000fc60007ffe0ffULL, 0x0000010015147825ULL, 0x000fe200078e0028ULL,
0x00006400121a7a10ULL, 0x000fc60007f5e0ffULL, 0x000000011b177824ULL, 0x100fe200078e0224ULL,
0x00006400141c7a10ULL, 0x000fe20007fbe0ffULL, 0x000000012b1f7824ULL, 0x000fe200078e0224ULL,
0x00006500131b7a10ULL, 0x000fe200017fe4ffULL, 0x0000010017167825ULL, 0x000fe200078e0028ULL,
0x00006500151d7a10ULL, 0x000fe40002ffe4ffULL, 0x0000000c2700720cULL, 0x0c0fe20003f46070ULL,
0x0000000127137824ULL, 0x000fe200078e0224ULL, 0x0000640016167a10ULL, 0x000fe20007fde0ffULL,
0x000000101e157824ULL, 0x000fe200078e0221ULL, 0x0000000c2b00720cULL, 0x000fe20003fa6070ULL,
0x0000010013127825ULL, 0x000fe200078e0028ULL, 0x0000650017177a10ULL, 0x000fc400037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018157faeULL, 0x0003e2000d901c46ULL,
0x000000016d277824ULL, 0x000fe200078e0224ULL, 0x00006400121e7a10ULL, 0x000fe40007fde0ffULL,
0x000000001a237faeULL, 0x0005e2000e101c46ULL, 0x0000000c6f00720cULL, 0x080fe40003f66070ULL,
0x0000000c6d00720cULL, 0x040fe20003f86070ULL, 0x000000016d0c7824ULL, 0x040fe400078e0205ULL,
0x000000086d6d7824ULL, 0x000fc400078e00ffULL, 0x000001001f147825ULL, 0x002fe200078e0028ULL,
0x00006500131f7a10ULL, 0x000fe400037fe4ffULL, 0xfffffff86d0c7812ULL, 0x000fe200078ee20cULL,
0x000000016f1b7824ULL, 0x044fe200078e0224ULL, 0x0000640014187a10ULL, 0x000fe20007fde0ffULL,
0x000000016f147824ULL, 0x040fe400078e0205ULL, 0x000000086f6f7824ULL, 0x000fe200078e00ffULL,
0x0000650015197a10ULL, 0x000fe200037fe4ffULL, 0x0000010027127825ULL, 0x000fc600078e0028ULL,
0xfffffff86f1a7812ULL, 0x000fe200078ee214ULL, 0x000001001b147825ULL, 0x000fe200078e0028ULL,
0x0000640012127a10ULL, 0x000fc60007fde0ffULL, 0x000000106c1b7824ULL, 0x100fe200078e0221ULL,
0x0000650013137a10ULL, 0x000fe200037fe4ffULL, 0x000000106e237824ULL, 0x100fe200078e0221ULL,
0x0000640014147a10ULL, 0x000fe20007fde0ffULL, 0x0000001070277824ULL, 0x100fe200078e0221ULL,
0x000000001c1b7faeULL, 0x0003e2000c101c46ULL, 0x0000001072297824ULL, 0x100fe200078e0221ULL,
0x0000650015157a10ULL, 0x000fe200037fe4ffULL, 0x000000100c2b7824ULL, 0x100fe200078e0221ULL,
0x0000000016237faeULL, 0x0003e2000c901c46ULL, 0x000000101a217824ULL, 0x000fc600078e0221ULL,
0x000000001e277faeULL, 0x0003e8000d101c46ULL, 0x0000000018297faeULL, 0x0003e8000e901c46ULL,
0x00000000122b7faeULL, 0x0003e8000e101c46ULL, 0x0000000014217faeULL, 0x0003e2000d901c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000405157811ULL, 0x040fe200078fe8ffULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000805177811ULL, 0x000fc400078fe8ffULL,
0x0000000c05197811ULL, 0x000fe200078fe8ffULL, 0x00000001150c7824ULL, 0x100fe200078e0205ULL,
0x00000018051f7811ULL, 0x000fe200078fe8ffULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0x0000001c05737811ULL, 0x000fe200078fe8ffULL, 0x0000000117127824ULL, 0x140fe400078e0205ULL,
0x00000008171d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b147812ULL, 0x000fe200078ee20cULL,
0x0000000119137824ULL, 0x100fe200078e0205ULL, 0x00000010051b7811ULL, 0x000fe200078fe8ffULL,
0x0000000819187824ULL, 0x000fe200078e00ffULL, 0xfffffff81d167812ULL, 0x000fe200078ee212ULL,
0x000000081f1e7824ULL, 0x000fe200078e00ffULL, 0x00000014051d7811ULL, 0x000fe200078fe8ffULL,
0x000000011b0c7824ULL, 0x040fe200078e0205ULL, 0xfffffff818187812ULL, 0x000fe200078ee213ULL,
0x000000081b217824ULL, 0x000fc400078e00ffULL, 0x000000011d127824ULL, 0x140fe400078e0205ULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0xfffffff8211a7812ULL, 0x000fe200078ee20cULL,
0x000000011f137824ULL, 0x100fe400078e0205ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8231c7812ULL, 0x000fe200078ee212ULL, 0x0000000173217824ULL, 0x000fe200078e0205ULL,
0x0000000505127211ULL, 0x000fe200078fe8ffULL, 0x00000008732a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee213ULL, 0x0000000220137824ULL, 0x000fe200078e020bULL,
0x0000000712127812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x100fe200078e0224ULL,
0x000000700c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x100fe200078e0224ULL,
0x0001700013757811ULL, 0x000fe200078e68ffULL, 0x0000000119197824ULL, 0x000fe200078e0224ULL,
0x0ffffff812127812ULL, 0x000fe200078ef805ULL, 0x000000800b287824ULL, 0x000fe200078e020cULL,
0x0000002405137211ULL, 0x000fe200078fe8ffULL, 0x0000001014237824ULL, 0x000fe200078e0275ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee221ULL, 0x0000001012217824ULL, 0x000fc400078e0275ULL,
0x0000010013127825ULL, 0x000fc800078e0028ULL, 0x000000011b1b7824ULL, 0x000fe200078e0224ULL,
0x0000640012127a10ULL, 0x000fe20007f1e0ffULL, 0x0000001016277824ULL, 0x000fe400078e0275ULL,
0x0000010015147825ULL, 0x000fe200078e0028ULL, 0x0000650013137a10ULL, 0x000fc600007fe4ffULL,
0x000000011d1d7824ULL, 0x000fe200078e0224ULL, 0x0000640014147a10ULL, 0x000fe20007f3e0ffULL,
0x00000010182b7824ULL, 0x000fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x0003e2000b901c46ULL, 0x0000010017167825ULL, 0x000fe200078e0028ULL,
0x0000650015157a10ULL, 0x000fc60000ffe4ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0224ULL,
0x0000640016167a10ULL, 0x000fe20007f5e0ffULL, 0x0000010019187825ULL, 0x000fe200078e0028ULL,
0x0000000014237faeULL, 0x0003e4000b901c46ULL, 0x0000650017177a10ULL, 0x000fe200017fe4ffULL,
0x0000000173737824ULL, 0x000fe200078e0224ULL, 0x0000640018187a10ULL, 0x000fe20007f7e0ffULL,
0x000000101a6d7824ULL, 0x100fe400078e0275ULL, 0x000000101c6f7824ULL, 0x000fe200078e0275ULL,
0x0000650019197a10ULL, 0x000fe20001ffe4ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0028ULL,
0x0000000016277faeULL, 0x0003e6000b901c46ULL, 0x000000101e717824ULL, 0x000fe200078e0275ULL,
0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x000001001d1c7825ULL, 0x100fe200078e0028ULL,
0x00000000182b7faeULL, 0x0003e4000b901c46ULL, 0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0028ULL, 0x000064001c1c7a10ULL, 0x000fc60007f3e0ffULL,
0x0000010073287825ULL, 0x000fe200078e0028ULL, 0x000064001e1e7a10ULL, 0x000fe20007f5e0ffULL,
0x000000001a6d7faeULL, 0x0003e2000b901c46ULL, 0x000065001d1d7a10ULL, 0x000fe20000ffe4ffULL,
0x000000102a757824ULL, 0x000fe200078e0275ULL, 0x0000640028287a10ULL, 0x000fe40007f7e0ffULL,
0x000065001f1f7a10ULL, 0x000fe200017fe4ffULL, 0x000000001c6f7faeULL, 0x0003e2000b901c46ULL,
0x0000650029297a10ULL, 0x000fc60001ffe4ffULL, 0x000000001e717faeULL, 0x0003e8000b901c46ULL,
0x0000000028757faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe0080c7812ULL, 0x040fe400078ec0ffULL, 0x0000001008137812ULL, 0x002fca00078ec0ffULL,
0x000000010c0c7824ULL, 0x000fc800078e0213ULL, 0x000000080b167824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6080016167f8cULL, 0x000e64000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x0000000808157812ULL, 0x000fca00078ec0ffULL,
0x000000010c0c7824ULL, 0x000fca00078e0215ULL, 0x01e60c000c157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x006fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412197210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001914147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60c000c157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff807819ULL, 0x000fe20000011605ULL, 0x0000002002127824ULL, 0x000fc600078e00ffULL,
0x000000700c0c7812ULL, 0x000fe400078ec0ffULL, 0xffffff8012137812ULL, 0x000fe400078ec0ffULL,
0x0000000c80807812ULL, 0x000fc800078ec0ffULL, 0x0000001380137210ULL, 0x000fca0007ffe00cULL,
0x01e0000013157984ULL, 0x000e680000000800ULL, 0x01e2000013127984ULL, 0x0004e20000000800ULL,
0x000000221500720bULL, 0x002fe20003f1d000ULL, 0x00016e227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x000000ff1300720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff1b7224ULL, 0x000fd400078e0022ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000002ff177819ULL, 0x000fe40000011602ULL, 0x000000221500720bULL, 0x000fe40003f54000ULL,
0x000000021700720cULL, 0x000fe20003f25270ULL, 0x00016de27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000147806ULL, 0x000fc400010e0100ULL, 0x0000008002179824ULL, 0x000fe200078e020cULL,
0x00000022151b7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000180169824ULL, 0x000fca00078e0217ULL, 0x01e4001b16009388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f25270ULL, 0x000005e000009947ULL, 0x000fea0003800000ULL,
0x000000221b167221ULL, 0x002fe20000010100ULL, 0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b16167820ULL, 0x000fcc0000410000ULL,
0x0000001600167308ULL, 0x000e640000000800ULL, 0x0000001625257220ULL, 0x002fe40000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011605ULL,
0x00016d327f007947ULL, 0x000fea000b800000ULL, 0x00001f2916297589ULL, 0x0002a400000e0000ULL,
0x000000292c2c7220ULL, 0x084fe40000410000ULL, 0x000000292d2d7220ULL, 0x080fe40000410000ULL,
0x0000002930307220ULL, 0x080fe40000410000ULL, 0x0000002931317220ULL, 0x000fc40000410000ULL,
0x0000002934347220ULL, 0x080fe40000410000ULL, 0x0000002935357220ULL, 0x080fe40000410000ULL,
0x0000002938387220ULL, 0x080fe40000410000ULL, 0x0000002939397220ULL, 0x080fe40000410000ULL,
0x000000293c3c7220ULL, 0x080fe40000410000ULL, 0x000000293d3d7220ULL, 0x000fc40000410000ULL,
0x0000002940407220ULL, 0x080fe40000410000ULL, 0x0000002941417220ULL, 0x080fe40000410000ULL,
0x0000002944447220ULL, 0x080fe40000410000ULL, 0x0000002945457220ULL, 0x080fe40000410000ULL,
0x0000002948487220ULL, 0x080fe40000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0014ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000000805297811ULL, 0x000fe200078ff0ffULL, 0x00016c227f007947ULL, 0x000fea000b800000ULL,
0x00001f2916297589ULL, 0x00046400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe40000410000ULL,
0x000000292f2f7220ULL, 0x080fe40000410000ULL, 0x0000002932327220ULL, 0x080fe40000410000ULL,
0x0000002933337220ULL, 0x080fe40000410000ULL, 0x0000002936367220ULL, 0x080fe40000410000ULL,
0x0000002937377220ULL, 0x000fc40000410000ULL, 0x000000293a3a7220ULL, 0x080fe40000410000ULL,
0x000000293b3b7220ULL, 0x080fe40000410000ULL, 0x000000293e3e7220ULL, 0x080fe40000410000ULL,
0x000000293f3f7220ULL, 0x080fe40000410000ULL, 0x0000002942427220ULL, 0x080fe40000410000ULL,
0x0000002943437220ULL, 0x000fc40000410000ULL, 0x0000002946467220ULL, 0x080fe40000410000ULL,
0x0000002947477220ULL, 0x080fe40000410000ULL, 0x000000294a4a7220ULL, 0x080fe40000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000014ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000001005297811ULL, 0x000fe200078ff0ffULL,
0x00016b127f007947ULL, 0x000fea000b800000ULL, 0x00001f2916297589ULL, 0x00046400000e0000ULL,
0x000000294c4c7220ULL, 0x086fe40000410000ULL, 0x000000294d4d7220ULL, 0x080fe40000410000ULL,
0x0000002950507220ULL, 0x080fe40000410000ULL, 0x0000002951517220ULL, 0x080fe40000410000ULL,
0x0000002954547220ULL, 0x080fe40000410000ULL, 0x0000002955557220ULL, 0x000fc40000410000ULL,
0x0000002958587220ULL, 0x080fe40000410000ULL, 0x0000002959597220ULL, 0x080fe40000410000ULL,
0x000000295c5c7220ULL, 0x080fe40000410000ULL, 0x000000295d5d7220ULL, 0x080fe40000410000ULL,
0x0000002960607220ULL, 0x080fe40000410000ULL, 0x0000002961617220ULL, 0x000fc40000410000ULL,
0x0000002964647220ULL, 0x080fe40000410000ULL, 0x0000002965657220ULL, 0x080fe40000410000ULL,
0x0000002968687220ULL, 0x080fe40000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000014ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000001805297811ULL, 0x000fe200078ff0ffULL,
0x00016a127f007947ULL, 0x000fea000b800000ULL, 0x00001f2916297589ULL, 0x00046400000e0000ULL,
0x000000294e4e7220ULL, 0x086fe40000410000ULL, 0x000000294f4f7220ULL, 0x080fe40000410000ULL,
0x0000002952527220ULL, 0x080fe40000410000ULL, 0x0000002953537220ULL, 0x080fe40000410000ULL,
0x0000002956567220ULL, 0x080fe40000410000ULL, 0x0000002957577220ULL, 0x000fc40000410000ULL,
0x000000295a5a7220ULL, 0x080fe40000410000ULL, 0x000000295b5b7220ULL, 0x080fe40000410000ULL,
0x000000295e5e7220ULL, 0x080fe40000410000ULL, 0x000000295f5f7220ULL, 0x080fe40000410000ULL,
0x0000002962627220ULL, 0x080fe40000410000ULL, 0x0000002963637220ULL, 0x000fc40000410000ULL,
0x0000002966667220ULL, 0x080fe40000410000ULL, 0x0000002967677220ULL, 0x080fe40000410000ULL,
0x000000296a6a7220ULL, 0x080fe40000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001413ff7212ULL, 0x000fda00078230ffULL,
0x8000001b15151221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b15151820ULL, 0x000fc80000410000ULL, 0x00000015000d1308ULL, 0x000e640000000800ULL,
0x0000000d12121220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002512257221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x0000000dff0e723eULL, 0x000fe400000010ffULL, 0x00000002ff117819ULL, 0x000fe40000011605ULL,
0x000054100e127816ULL, 0x000fe2000000000eULL, 0x000168627f007947ULL, 0x000fea000b800000ULL,
0x00001f11120e7589ULL, 0x0002a400000e0000ULL, 0x0000000811297810ULL, 0x000fe20007ffe0ffULL,
0x000168b27f007947ULL, 0x000fea000b800000ULL, 0x0000001011137810ULL, 0x000fe20007ffe0ffULL,
0x00001f29120f7589ULL, 0x00066800000e0000ULL, 0x00001f1312107589ULL, 0x0006a400000e0000ULL,
0x0000001811297810ULL, 0x008fe20007ffe0ffULL, 0x000169427f007947ULL, 0x000fea000b800000ULL,
0x00001f2912117589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000420137824ULL, 0x000fe200078e00ffULL, 0x0000000805127812ULL, 0x002fe200078ec0ffULL,
0x0000040002157824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000220247824ULL, 0x000fe200078e020bULL, 0x00000004131e7812ULL, 0x000fe200078ec0ffULL,
0x0000028000007945ULL, 0x000fe20003800000ULL, 0x0000000712127812ULL, 0x000fe200078ef805ULL,
0x0000200024247824ULL, 0x000fe200078e00ffULL, 0x0000001e05147211ULL, 0x000fc400078fe0ffULL,
0x0000001012137812ULL, 0x040fe200078efcffULL, 0x0000000812167824ULL, 0x040fe200078e00ffULL,
0x0000001205177211ULL, 0x000fe200078fe0ffULL, 0x0000000112197824ULL, 0x000fe200078e0214ULL,
0xfffff00015157812ULL, 0x000fe200078ec0ffULL, 0x00000001141a7824ULL, 0x000fe200078e0213ULL,
0x0000000417187810ULL, 0x000fe20007ffe0ffULL, 0x00000008131d7824ULL, 0x000fe200078e00ffULL,
0xfffffff816197812ULL, 0x000fe200078ee219ULL, 0x00000008121f7824ULL, 0x000fe200078e00ffULL,
0x0000000217147810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81d1a7812ULL, 0x000fe200078ee21aULL,
0x00000008121d7824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe400078ee217ULL,
0x00000006171c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81d177812ULL, 0x000fe400078ee218ULL,
0x00012000151d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81f187812ULL, 0x000fc400078ee21cULL,
0xfffffff81f147812ULL, 0x000fe200078ee214ULL, 0x0000001019787824ULL, 0x100fe200078e021dULL,
0x00016000241c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101a287824ULL, 0x000fc800078e021dULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0x0000001016747824ULL, 0x100fe400078e021cULL,
0x0000001014707824ULL, 0x100fe200078e021cULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000001017207824ULL, 0x000fe200078e021cULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000e78787231ULL, 0x086fe400003400ffULL, 0x0000000e7a7a7231ULL, 0x000fe400003400ffULL,
0x0000000f79797231ULL, 0x000fc400003400ffULL, 0x0000000f7b7b7231ULL, 0x000fe400003400ffULL,
0x0000001028287231ULL, 0x088fe400003400ffULL, 0x000000102a2a7231ULL, 0x000fe400003400ffULL,
0x0000001129297231ULL, 0x080fe400003400ffULL, 0x000000112b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007070783bULL, 0x000f220000004200ULL,
0x00000010186c7824ULL, 0x000fe200078e021cULL, 0x000000021e1e7812ULL, 0x000fe200078efcffULL,
0x0000000813277824ULL, 0x000fe200078e00ffULL, 0x000000002020783bULL, 0x000ee20000004200ULL,
0x0000035000007945ULL, 0x000fe20003800000ULL, 0x0000001e051e7211ULL, 0x000fc400078fe0ffULL,
0x000000006c6c783bULL, 0x000ea60000004200ULL, 0x00000001121f7824ULL, 0x100fe200078e021eULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x00000001131e7824ULL, 0x000fca00078e021eULL,
0xfffffff8271e7812ULL, 0x000fca00078ee21eULL, 0x000000101e1e7824ULL, 0x000fe200078e021dULL,
0x000000707834723cULL, 0x092f700000041834ULL, 0x000000702854723cULL, 0x008b6e0000041854ULL,
0x0000000812707824ULL, 0x020fe200078e00ffULL, 0x00000020783c723cULL, 0x000f62000004183cULL,
0x0000000813717824ULL, 0x000fc600078e00ffULL, 0xfffffff870707812ULL, 0x000fe400078ee21fULL,
0x00000013051f7211ULL, 0x000fe400078fe0ffULL, 0x00000020285c723cULL, 0x000b62000004185cULL,
0x0000001070707824ULL, 0x000fca00078e021dULL, 0x00000000707c783bULL, 0x0002e20000000200ULL,
0x0000000813207824ULL, 0x020fe200078e00ffULL, 0x0000006c7844723cULL, 0x084f680000041844ULL,
0xfffffff820217812ULL, 0x000fe400078ee21fULL, 0x000000061f207810ULL, 0x000fe40007ffe0ffULL,
0x0000006c2864723cULL, 0x000b640000041864ULL, 0xfffffff871207812ULL, 0x000fca00078ee220ULL,
0x00000008136d7824ULL, 0x060fe200078e00ffULL, 0x000000227840723cULL, 0x000f620000041840ULL,
0x00000008136c7824ULL, 0x000fce00078e00ffULL, 0x000000222860723cULL, 0x040b6e0000041860ULL,
0x000000021f227810ULL, 0x060fe20007ffe0ffULL, 0x00000074284c723cULL, 0x000f62000004184cULL,
0x000000041f237810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86d227812ULL, 0x000fc400078ee222ULL,
0xfffffff86c237812ULL, 0x000fc600078ee223ULL, 0x000000762850723cULL, 0x000f640000041850ULL,
0x0000001023717824ULL, 0x000fcc00078e021cULL, 0x000000722858723cULL, 0x040f700000041858ULL,
0x0000006e2868723cULL, 0x000b640000041868ULL, 0x000000001e28783bULL, 0x0202ac0000000200ULL,
0x00000074782c723cULL, 0x040b6e000004182cULL, 0x0000001022747824ULL, 0x120fe200078e021cULL,
0x000000767830723cULL, 0x040f700000041830ULL, 0x000000727838723cULL, 0x040f700000041838ULL,
0x0000006e7848723cULL, 0x000b6e0000041848ULL, 0x0000001021787824ULL, 0x020fe200078e021cULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000e7c7c7231ULL, 0x08afe400003400ffULL,
0x0000000e7e7e7231ULL, 0x000fc400003400ffULL, 0x0000000f7d7d7231ULL, 0x080fe400003400ffULL,
0x0000000f7f7f7231ULL, 0x000fe400003400ffULL, 0x0000001028287231ULL, 0x084fe400003400ffULL,
0x000000102a2a7231ULL, 0x000fe400003400ffULL, 0x0000001129297231ULL, 0x080fe400003400ffULL,
0x000000112b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x00afea0003800000ULL,
0x00000010206c7824ULL, 0x000fe200078e021cULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x00000002021d7824ULL, 0x000fc600078e00ffULL, 0x000000007474783bULL, 0x000ee40000004200ULL,
0xfffffff81d1d7812ULL, 0x000fe400078ec0ffULL, 0x000000007170783bULL, 0x000f280000004200ULL,
0x000000006c6c783bULL, 0x000ea20000004200ULL, 0x000000787c2c723cULL, 0x042b70000004182cULL,
0x0000007a7c30723cULL, 0x040b700000041830ULL, 0x000000747c34723cULL, 0x048b700000041834ULL,
0x000000767c38723cULL, 0x040b700000041838ULL, 0x000000707c3c723cULL, 0x050b70000004183cULL,
0x000000727c40723cULL, 0x040b700000041840ULL, 0x0000006c7c44723cULL, 0x044b700000041844ULL,
0x0000006e7c48723cULL, 0x000b700000041848ULL, 0x00000078284c723cULL, 0x040b70000004184cULL,
0x0000007a2850723cULL, 0x040b700000041850ULL, 0x000000742854723cULL, 0x040b700000041854ULL,
0x000000762858723cULL, 0x040b700000041858ULL, 0x00000070285c723cULL, 0x040b70000004185cULL,
0x000000722860723cULL, 0x040b700000041860ULL, 0x0000006c2864723cULL, 0x040b700000041864ULL,
0x0000006e2868723cULL, 0x000b620000041868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001041e7810ULL, 0x000fe20007ffe0ffULL, 0x01e688001dff7f8cULL, 0x0003e2000c80043fULL,
0x00000080261f7810ULL, 0x000fc40007ffe0ffULL, 0x000000071e00720cULL, 0x000fc60003f06070ULL,
0x000068000a767a24ULL, 0x020fe200078e021fULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff747819ULL, 0x002fe20000011605ULL,
0x000000800b1e7824ULL, 0x000fe200078e020cULL, 0x0000001f061d7217ULL, 0x000fe40007800000ULL,
0x0000000474287810ULL, 0x040fe20007ffe0ffULL, 0x0000000174297824ULL, 0x140fe200078e0276ULL,
0x00000008746c7810ULL, 0x040fe20007ffe0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a1fULL,
0x0000000c74727810ULL, 0x000fe20007ffe0ffULL, 0x00000001281f7824ULL, 0x100fe200078e0205ULL,
0x00000010747a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0x000000201d1d7817ULL, 0x000fe20003800000ULL, 0x000000016c277824ULL, 0x000fe200078e0205ULL,
0x00000014747c7810ULL, 0x000fe20007ffe0ffULL, 0x000000086c6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a777812ULL, 0x000fe200078ee21fULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000001d2800720cULL, 0x0c0fe20003f86070ULL, 0x00000001282b7824ULL, 0x000fe200078e0276ULL,
0xfffffff86e7b7812ULL, 0x000fe200078ee227ULL, 0x0000000172277824ULL, 0x040fe200078e0205ULL,
0x0000001d7200720cULL, 0x0c0fe20003f46070ULL, 0x00000008726e7824ULL, 0x000fe200078e00ffULL,
0x0000001d6c00720cULL, 0x080fe20003f66070ULL, 0x0000010029287825ULL, 0x000fe200078e001eULL,
0x0000001d7400720cULL, 0x000fc40003fa6070ULL, 0xfffffff86e7d7812ULL, 0x000fe200078ee227ULL,
0x000001002b2a7825ULL, 0x000fe200078e001eULL, 0x00006400286e7a10ULL, 0x000fc60007f1e0ffULL,
0x000000017a6d7824ULL, 0x100fe200078e0205ULL, 0x000064002a707a10ULL, 0x000fe20007f3e0ffULL,
0x000000087a787824ULL, 0x000fe200078e00ffULL, 0x00006500296f7a10ULL, 0x000fe200007fe4ffULL,
0x000000016c297824ULL, 0x100fe200078e0276ULL, 0x000065002b717a10ULL, 0x000fe20000ffe4ffULL,
0x0000000174277824ULL, 0x000fe200078e0205ULL, 0xfffffff8787f7812ULL, 0x000fe200078ee26dULL,
0x00000001722b7824ULL, 0x000fe200078e0276ULL, 0x0000001d7a00720cULL, 0x000fe20003f26070ULL,
0x0000010029287825ULL, 0x000fe200078e001eULL, 0x0000000727787812ULL, 0x000fc600078ec0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e001eULL, 0x0000640028727a10ULL, 0x000fc60007f1e0ffULL,
0x000000017a6d7824ULL, 0x000fe200078e0276ULL, 0x000064002a2a7a10ULL, 0x000fe20007fde0ffULL,
0x000000017c277824ULL, 0x040fe200078e0205ULL, 0x0000650029737a10ULL, 0x000fe200007fe4ffULL,
0x000000087c7a7824ULL, 0x040fe200078e00ffULL, 0x000065002b2b7a10ULL, 0x000fe200037fe4ffULL,
0x000001006d6c7825ULL, 0x000fe200078e001eULL, 0x0000001d7c00720cULL, 0x000fe40003f06070ULL,
0xfffffff87a837812ULL, 0x000fe200078ee227ULL, 0x000000017c297824ULL, 0x000fe200078e0276ULL,
0x0ffffff878277812ULL, 0x000fe200078ef805ULL, 0x0000001077777824ULL, 0x000fe200078e021cULL,
0x000064006c6c7a10ULL, 0x000fe20007fde0ffULL, 0x0000010029287825ULL, 0x000fe200078e001eULL,
0x0000001874787810ULL, 0x000fc40007ffe0ffULL, 0x000065006d6d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001027277824ULL, 0x000fe200078e021cULL, 0x0000001c747a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000178797824ULL, 0x000fe200078e0276ULL, 0x0000640028747a10ULL, 0x000fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e277faeULL, 0x0003e2000e901c46ULL,
0x0000001d7800720cULL, 0x080fe40003fa6070ULL, 0x0000650029757a10ULL, 0x000fe200037fe4ffULL,
0x0000000070777faeULL, 0x0005e2000e101c46ULL, 0x0000001d7a00720cULL, 0x000fe20003f86070ULL,
0x0000010079287825ULL, 0x000fc800078e001eULL, 0x000000017a1d7824ULL, 0x000fe200078e0276ULL,
0x0000640028287a10ULL, 0x000fe20007fde0ffULL, 0x0000000178277824ULL, 0x142fe400078e0205ULL,
0x0000000878787824ULL, 0x000fe200078e00ffULL, 0x0000650029297a10ULL, 0x000fe200037fe4ffULL,
0x000000017a6e7824ULL, 0x040fe400078e0205ULL, 0x000000087a797824ULL, 0x000fe200078e00ffULL,
0xfffffff878777812ULL, 0x004fe200078ee227ULL, 0x000001001d1e7825ULL, 0x000fc600078e001eULL,
0xfffffff879797812ULL, 0x000fe200078ee26eULL, 0x000000107b1d7824ULL, 0x100fe200078e021cULL,
0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x000000107d277824ULL, 0x100fe400078e021cULL,
0x000000107f6f7824ULL, 0x100fe200078e021cULL, 0x000065001f1f7a10ULL, 0x000fe200037fe4ffULL,
0x0000001083717824ULL, 0x100fe200078e021cULL, 0x00000000721d7faeULL, 0x0003e2000d901c46ULL,
0x0000001077777824ULL, 0x100fe400078e021cULL, 0x0000001079797824ULL, 0x000fe200078e021cULL,
0x000000002a277faeULL, 0x0003e8000d101c46ULL, 0x000000006c6f7faeULL, 0x0003e8000c901c46ULL,
0x0000000074717faeULL, 0x0003e8000c101c46ULL, 0x0000000028777faeULL, 0x0003e8000e901c46ULL,
0x000000001e797faeULL, 0x0003e2000e101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000405297811ULL, 0x002fe200078fe8ffULL, 0x000000800b747824ULL, 0x000fe200078e020cULL,
0x00000008052b7811ULL, 0x040fe200078fe8ffULL, 0x000000ffff757224ULL, 0x000fe200078e00ffULL,
0x0000000c056d7811ULL, 0x000fe200078fe8ffULL, 0x00000001291d7824ULL, 0x100fe200078e0205ULL,
0x0000001805737811ULL, 0x000fe200078fe8ffULL, 0x0000000829287824ULL, 0x000fe200078e00ffULL,
0x00000010056f7811ULL, 0x000fe200078fe8ffULL, 0x000000012b1e7824ULL, 0x000fe200078e0205ULL,
0x0000001405717811ULL, 0x000fe200078fe8ffULL, 0x000000082b797824ULL, 0x000fe200078e00ffULL,
0xfffffff828777812ULL, 0x000fe200078ee21dULL, 0x000000016d1d7824ULL, 0x100fe200078e0205ULL,
0x000000036f7d7819ULL, 0x000fe200000006ffULL, 0x000000086d287824ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fe200078ee21eULL, 0x0000000173277824ULL, 0x000fc400078e0205ULL,
0x00000008736c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8287b7812ULL, 0x000fe200078ee21dULL,
0x000000016f1e7824ULL, 0x100fe200078e0205ULL, 0x00000005051d7211ULL, 0x000fe200078fe8ffULL,
0x00000001711f7824ULL, 0x040fe200078e0205ULL, 0xfffffff86c837812ULL, 0x000fe200078ee227ULL,
0x00000008712a7824ULL, 0x000fe200078e00ffULL, 0x0000001c05277811ULL, 0x000fe200078fe8ffULL,
0x0000000129297824ULL, 0x000fe200078e0276ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee21eULL,
0x000000012b2b7824ULL, 0x100fe200078e0276ULL, 0xfffffff82a7f7812ULL, 0x000fe200078ee21fULL,
0x000000016d6d7824ULL, 0x100fe200078e0276ULL, 0x000000071d1e7812ULL, 0x000fe200078ec0ffULL,
0x000000016f6f7824ULL, 0x100fe200078e0276ULL, 0x00000076051f7211ULL, 0x000fe200078fe8ffULL,
0x0000000171717824ULL, 0x000fc400078e0276ULL, 0x0000000173737824ULL, 0x100fe400078e0276ULL,
0x00000001271d7824ULL, 0x040fe400078e0276ULL, 0x0000000127767824ULL, 0x140fe400078e0205ULL,
0x0000000827857824ULL, 0x000fe200078e00ffULL, 0x0ffffff81e277812ULL, 0x000fe200078ef805ULL,
0x000001001f1e7825ULL, 0x000fc600078e0074ULL, 0xfffffff885857812ULL, 0x000fe200078ee276ULL,
0x0000010029287825ULL, 0x000fc800078e0074ULL, 0x000001002b2a7825ULL, 0x000fc800078e0074ULL,
0x000001006d6c7825ULL, 0x000fc800078e0074ULL, 0x0000001027277824ULL, 0x100fe400078e021cULL,
0x0000001077777824ULL, 0x100fe400078e021cULL, 0x0000001079797824ULL, 0x100fe400078e021cULL,
0x000000107b7b7824ULL, 0x100fe400078e021cULL, 0x000000107d7d7824ULL, 0x100fe400078e021cULL,
0x000000107f7f7824ULL, 0x000fc400078e021cULL, 0x0000001083837824ULL, 0x100fe400078e021cULL,
0x0000001085857824ULL, 0x000fe200078e021cULL, 0x000064001e1c7a10ULL, 0x000fe20007f1e0ffULL,
0x000001006f6e7825ULL, 0x100fe200078e0074ULL, 0x00006400281e7a10ULL, 0x000fe40007f3e0ffULL,
0x000064002a287a10ULL, 0x000fe20007f5e0ffULL, 0x0000010071707825ULL, 0x000fe200078e0074ULL,
0x000064006c2a7a10ULL, 0x000fc60007f7e0ffULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x000001001d747825ULL, 0x000fe200078e0074ULL, 0x000065001f1d7a10ULL, 0x000fe400007fe4ffULL,
0x00006500291f7a10ULL, 0x000fe40000ffe4ffULL, 0x000064006e6c7a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c277faeULL, 0x0003e2000b901c46ULL,
0x000065002b297a10ULL, 0x000fe400017fe4ffULL, 0x00006400706e7a10ULL, 0x000fe20007f3e0ffULL,
0x000000001e777faeULL, 0x0003e2000b901c46ULL, 0x000065006d2b7a10ULL, 0x000fc40001ffe4ffULL,
0x0000640072707a10ULL, 0x000fe20007f5e0ffULL, 0x0000000028797faeULL, 0x0003e2000b901c46ULL,
0x0000640074727a10ULL, 0x000fe40007f7e0ffULL, 0x000065006f6d7a10ULL, 0x000fe200007fe4ffULL,
0x000000002a7b7faeULL, 0x0003e2000b901c46ULL, 0x00006500716f7a10ULL, 0x000fe40000ffe4ffULL,
0x0000650073717a10ULL, 0x000fe200017fe4ffULL, 0x000000006c7d7faeULL, 0x0003e2000b901c46ULL,
0x0000650075737a10ULL, 0x000fc60001ffe4ffULL, 0x000000006e7f7faeULL, 0x0003e8000b901c46ULL,
0x0000000070837faeULL, 0x0003e8000b901c46ULL, 0x0000000072857faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0081e7812ULL, 0x042fe400078ec0ffULL,
0x00000010081f7812ULL, 0x000fc400078ec0ffULL, 0x0000000808287812ULL, 0x000fc800078ec0ffULL,
0x0000001e28287210ULL, 0x000fe20007ffe01fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6280028287f8cULL, 0x000e64000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x000000011e1e7824ULL, 0x000fc800078e021fULL, 0x000000080b2a7824ULL, 0x000fca00078e021eULL,
0x01e62c002a1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c277210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000271e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e62c002a1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020021c7824ULL, 0x000fca00078e00ffULL, 0xffffff801c1d7812ULL, 0x000fc800078ec0ffULL,
0x000000800c1d7810ULL, 0x000fca0007ffe01dULL, 0x00000001801d7824ULL, 0x000fca00078e021dULL,
0x01e000001d1c7984ULL, 0x000e680000000800ULL, 0x01e200001d1e7984ULL, 0x0004e20000000800ULL,
0x0000001b1c00720bULL, 0x002fe20003f1d000ULL, 0x000151f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x004fc800000e0100ULL, 0x000000ff1d00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff277224ULL, 0x000fd400078e001bULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x00000001021f7811ULL, 0x000fe400078ff0ffULL, 0x0000001b1c00720bULL, 0x000fe40003f34000ULL,
0x000000021f00720cULL, 0x000fe20003f05270ULL, 0x000151b27f007947ULL, 0x000fd4000b800000ULL,
0x00000000006e7806ULL, 0x000fc400008e0100ULL, 0x0000008002278824ULL, 0x000fe200078e020cULL,
0x0000001b1c1f8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000180288824ULL, 0x000fca00078e0227ULL, 0x01e4001f28008388ULL, 0x0003e20000000800ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001b1c287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff6eff7812ULL, 0x000fc6000780c0ffULL, 0x0000001b281f7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL, 0x0000001f00707308ULL, 0x000e640000000800ULL,
0x0000007025257220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011605ULL, 0x000150f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2970297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006eff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805297811ULL, 0x000fe200078ff0ffULL,
0x00014fe27f007947ULL, 0x000fea000b800000ULL, 0x00001f2970297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006eff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001005297811ULL, 0x000fe200078ff0ffULL, 0x00014ed27f007947ULL, 0x000fea000b800000ULL,
0x00001f2970297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006eff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001805297811ULL, 0x000fe200078ff0ffULL, 0x00014dd27f007947ULL, 0x000fea000b800000ULL,
0x00001f2970297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006e1dff7212ULL, 0x000fe400078030ffULL, 0x0000001b1c277209ULL, 0x000fd60007810000ULL,
0x800000271c1c0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c000d0308ULL, 0x000e640000000800ULL, 0x0000000d1e1e0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000251e257221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x0000000dff0e723eULL, 0x000fe400000010ffULL, 0x00000002ff1c7819ULL, 0x000fe40000011605ULL,
0x000054100e117816ULL, 0x000fe2000000000eULL, 0x00014c327f007947ULL, 0x000fea000b800000ULL,
0x00001f1c110e7589ULL, 0x0002a400000e0000ULL, 0x000000081c297810ULL, 0x000fe20007ffe0ffULL,
0x00014c827f007947ULL, 0x000fea000b800000ULL, 0x000000101c107810ULL, 0x000fe20007ffe0ffULL,
0x00001f29110f7589ULL, 0x00066a00000e0000ULL, 0x00001f1011107589ULL, 0x0006a400000e0000ULL,
0x000000181c297810ULL, 0x008fe20007ffe0ffULL, 0x00014d127f007947ULL, 0x000fea000b800000ULL,
0x00001f2911117589ULL, 0x0022e400000e0000ULL, 0x00002000021b7824ULL, 0x000fe200078e00ffULL,
0x00013000157c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000014000007945ULL, 0x000fe40003800000ULL, 0xffffc0001b1c7812ULL, 0x000fe200078ec0ffULL,
0x0000001019197824ULL, 0x000fc400078e027cULL, 0x000000101a1a7824ULL, 0x000fe400078e027cULL,
0x000020000b1c7824ULL, 0x000fe200078e021cULL, 0x000000001978783bULL, 0x0002e80000000200ULL,
0x000170001c1b7810ULL, 0x000fe40007ffe0ffULL, 0x000000001a1c783bULL, 0x0002a60000000200ULL,
0x0000001016747824ULL, 0x000fc400078e021bULL, 0x0000001014707824ULL, 0x100fe400078e021bULL,
0x00000010176c7824ULL, 0x000fe200078e021bULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000e78787231ULL, 0x08efe400003400ffULL, 0x0000000e7a7a7231ULL, 0x000fe400003400ffULL,
0x0000000f79797231ULL, 0x080fe400003400ffULL, 0x0000000f7b7b7231ULL, 0x000fe400003400ffULL,
0x000000101c1c7231ULL, 0x000fc400003400ffULL, 0x000000101e1e7231ULL, 0x000fe400003400ffULL,
0x000000111d1d7231ULL, 0x080fe400003400ffULL, 0x000000111f1f7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x0000001018287824ULL, 0x000fe200078e021bULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x0000000202197824ULL, 0x000fe200078e00ffULL,
0x000002e000007945ULL, 0x000fe20003800000ULL, 0x00000008131b7824ULL, 0x000fe200078e00ffULL,
0x000000007070783bULL, 0x000fe40000004200ULL, 0x0000000419197812ULL, 0x000fc400078ec0ffULL,
0x000000002828783bULL, 0x000f240000004200ULL, 0x00000002191a7812ULL, 0x000fe400078efcffULL,
0x000000006c6c783bULL, 0x000ee40000004200ULL, 0x0000001a051a7211ULL, 0x000fca00078fe0ffULL,
0x0000000112197824ULL, 0x100fe400078e021aULL, 0x00000001131a7824ULL, 0x000fca00078e021aULL,
0xfffffff81b1a7812ULL, 0x000fe400078ee21aULL, 0x00017000241b7810ULL, 0x000fe20007ffe0ffULL,
0x00000074782c723cULL, 0x04af70000004182cULL, 0x000000287844723cULL, 0x090f700000041844ULL,
0x000000281c64723cULL, 0x004b6e0000041864ULL, 0x0000000812287824ULL, 0x020fe200078e00ffULL,
0x0000002a7848723cULL, 0x000f680000041848ULL, 0xfffffff828197812ULL, 0x000fe200078ee219ULL,
0x000000101a287824ULL, 0x000fc600078e027cULL, 0x0000002a1c68723cULL, 0x000b620000041868ULL,
0x00000010197d7824ULL, 0x000fe400078e027cULL, 0x000000002828783bULL, 0x020e680000000200ULL,
0x000000007d7c783bULL, 0x000ea20000000200ULL, 0x000000767830723cULL, 0x040f700000041830ULL,
0x000000707834723cULL, 0x040f700000041834ULL, 0x000000727838723cULL, 0x040f700000041838ULL,
0x0000006c783c723cULL, 0x040f70000004183cULL, 0x0000006e7840723cULL, 0x000f700000041840ULL,
0x000000741c4c723cULL, 0x040f70000004184cULL, 0x000000761c50723cULL, 0x040f700000041850ULL,
0x000000701c54723cULL, 0x040f700000041854ULL, 0x000000721c58723cULL, 0x040f700000041858ULL,
0x0000006c1c5c723cULL, 0x040f70000004185cULL, 0x0000006e1c60723cULL, 0x000b6e0000041860ULL,
0x00000010211c7824ULL, 0x020fc400078e021bULL, 0x00000010221d7824ULL, 0x100fe400078e021bULL,
0x00000010231e7824ULL, 0x000fe200078e021bULL, 0x0000008000008947ULL, 0x000fce0003800000ULL,
0x0000000e7c7c7231ULL, 0x086fe400003400ffULL, 0x0000000e7e7e7231ULL, 0x000fe400003400ffULL,
0x0000000f7d7d7231ULL, 0x080fe400003400ffULL, 0x0000000f7f7f7231ULL, 0x000fe400003400ffULL,
0x0000001028287231ULL, 0x000fc400003400ffULL, 0x000000102a2a7231ULL, 0x000fe400003400ffULL,
0x0000001129297231ULL, 0x080fe400003400ffULL, 0x000000112b2b7231ULL, 0x000fc400003400ffULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x00000010201f7824ULL, 0x000fe200078e021bULL,
0x000000001c78783bULL, 0x000e680000004200ULL, 0x000000001d74783bULL, 0x000ea80000004200ULL,
0x000000001e70783bULL, 0x000ee80000004200ULL, 0x000000001f6c783bULL, 0x000f220000004200ULL,
0x000000787c2c723cULL, 0x042f70000004182cULL, 0x0000007a7c30723cULL, 0x040f700000041830ULL,
0x000000747c34723cULL, 0x044f700000041834ULL, 0x000000767c38723cULL, 0x040f700000041838ULL,
0x000000707c3c723cULL, 0x048f70000004183cULL, 0x000000727c40723cULL, 0x040f700000041840ULL,
0x0000006e7c48723cULL, 0x050f700000041848ULL, 0x0000006c7c44723cULL, 0x080f700000041844ULL,
0x0000006c2864723cULL, 0x040b6e0000041864ULL, 0x00000002ff6c7819ULL, 0x020fe20000011602ULL,
0x00000078284c723cULL, 0x040f70000004184cULL, 0x0000007a2850723cULL, 0x040f700000041850ULL,
0x000000742854723cULL, 0x040f700000041854ULL, 0x000000762858723cULL, 0x040f700000041858ULL,
0x00000070285c723cULL, 0x040f70000004185cULL, 0x000000722860723cULL, 0x040f700000041860ULL,
0x0000006e2868723cULL, 0x000b6e0000041868ULL, 0x0001e6906c287811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x000000c026297810ULL, 0x000fe20007ffe0ffULL,
0x0000000028ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000104267810ULL, 0x000fc60007ffe0ffULL,
0x000068000a7c7a24ULL, 0x000fe200078e0229ULL, 0x000000072600720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff6d7819ULL, 0x002fe20000011605ULL, 0x000000800b7a7824ULL, 0x000fe200078e020cULL,
0x0000002906267217ULL, 0x000fe20007800000ULL, 0x000000ffff7b7224ULL, 0x000fe200078e00ffULL,
0x000000046d2b7810ULL, 0x040fe40007ffe0ffULL, 0x000000086d6f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a29ULL, 0x000000106d797810ULL, 0x000fe20007ffe0ffULL,
0x000000012b287824ULL, 0x100fe200078e0205ULL, 0x000000146d7d7810ULL, 0x000fe20007ffe0ffULL,
0x000000082b717824ULL, 0x000fe200078e00ffULL, 0x0000002026267817ULL, 0x000fe20003800000ULL,
0x000000086f737824ULL, 0x000fe200078e00ffULL, 0x000000186d7f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001792a7824ULL, 0x100fe200078e0205ULL, 0xfffffff8717e7812ULL, 0x000fe200078ee228ULL,
0x000000016f287824ULL, 0x100fe200078e0205ULL, 0x0000000c6d717810ULL, 0x000fe20007ffe0ffULL,
0x0000000879757824ULL, 0x000fe200078e00ffULL, 0x000000262b00720cULL, 0x080fe20003fa6070ULL,
0x000000017d727824ULL, 0x100fe200078e0205ULL, 0xfffffff873847812ULL, 0x000fe200078ee228ULL,
0x0000000171297824ULL, 0x000fe200078e0205ULL, 0x000000266f00720cULL, 0x080fe20003f66070ULL,
0x0000000871867824ULL, 0x000fe200078e00ffULL, 0xfffffff875887812ULL, 0x000fe200078ee22aULL,
0x000000087d737824ULL, 0x000fe200078e00ffULL, 0x000000267100720cULL, 0x000fe20003f46070ULL,
0x000000012b2b7824ULL, 0x100fe200078e027cULL, 0xfffffff886867812ULL, 0x000fe200078ee229ULL,
0x000000016d297824ULL, 0x000fe200078e027cULL, 0xfffffff8738a7812ULL, 0x000fe200078ee272ULL,
0x000000016f6f7824ULL, 0x000fc400078e027cULL, 0x0000010029287825ULL, 0x000fc800078e007aULL,
0x0000000171717824ULL, 0x000fe200078e027cULL, 0x0000640028727a10ULL, 0x000fe20007f1e0ffULL,
0x000001002b2a7825ULL, 0x000fc600078e007aULL, 0x0000650029737a10ULL, 0x000fe200007fe4ffULL,
0x000001006f6e7825ULL, 0x100fe200078e007aULL, 0x000064002a747a10ULL, 0x000fe40007f3e0ffULL,
0x000000267d00720cULL, 0x000fe20003f06070ULL, 0x0000010071707825ULL, 0x000fe200078e007aULL,
0x000064006e767a10ULL, 0x000fe40007f9e0ffULL, 0x000065002b757a10ULL, 0x000fe20000ffe4ffULL,
0x0000000179297824ULL, 0x000fe200078e027cULL, 0x0000640070707a10ULL, 0x000fe20007fde0ffULL,
0x000000016d2a7824ULL, 0x000fe200078e0205ULL, 0x000065006f777a10ULL, 0x000fe200027fe4ffULL,
0x0000010029287825ULL, 0x000fe200078e007aULL, 0x0000650071717a10ULL, 0x000fc400037fe4ffULL,
0x000000072a6e7812ULL, 0x000fe200078ec0ffULL, 0x000000017d2b7824ULL, 0x100fe200078e027cULL,
0x0000001c6d7d7810ULL, 0x040fe40007ffe0ffULL, 0x000000266d00720cULL, 0x000fe20003f86070ULL,
0x000000017f6d7824ULL, 0x000fe200078e027cULL, 0x0000640028787a10ULL, 0x000fe20007fde0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e007aULL, 0x0ffffff86e6e7812ULL, 0x000fe400078ef805ULL,
0x0000007c7d6f7210ULL, 0x000fc40007ffe0ffULL, 0x000000267900720cULL, 0x000fe40003f26070ULL,
0x0000650029797a10ULL, 0x000fe200037fe4ffULL, 0x000001006d287825ULL, 0x000fe200078e007aULL,
0x000064002a2a7a10ULL, 0x000fc60007fde0ffULL, 0x000000106e6d7824ULL, 0x000fe200078e021bULL,
0x000065002b2b7a10ULL, 0x000fe200037fe4ffULL, 0x000001006f6e7825ULL, 0x000fe200078e007aULL,
0x000000267f00720cULL, 0x000fe40003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000726d7faeULL, 0x0003e2000e101c46ULL, 0x000000107e7b7824ULL, 0x000fe200078e021bULL,
0x0000640028287a10ULL, 0x000fe20007f9e0ffULL, 0x000000017d7a7824ULL, 0x000fc600078e0205ULL,
0x00000000747b7faeULL, 0x0005e2000e901c46ULL, 0x000000267d00720cULL, 0x000fe20003fa6070ULL,
0x000000017f267824ULL, 0x000fe200078e0205ULL, 0x0000650029297a10ULL, 0x000fe200027fe4ffULL,
0x000000087f7f7824ULL, 0x000fe200078e00ffULL, 0x000064006e6e7a10ULL, 0x000fe20007f9e0ffULL,
0x000000087d7d7824ULL, 0x000fe400078e00ffULL, 0x00000010846d7824ULL, 0x102fe200078e021bULL,
0xfffffff87f267812ULL, 0x000fe200078ee226ULL, 0x0000001086737824ULL, 0x100fe200078e021bULL,
0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL, 0x0000001088757824ULL, 0x104fe200078e021bULL,
0x000065006f6f7a10ULL, 0x000fe200027fe4ffULL, 0x000000108a7b7824ULL, 0x100fe200078e021bULL,
0x00000000766d7faeULL, 0x0003e2000d901c46ULL, 0x00000010267d7824ULL, 0x000fc400078e021bULL,
0x000000107a7f7824ULL, 0x000fe200078e021bULL, 0x0000000070737faeULL, 0x0003e8000d101c46ULL,
0x0000000078757faeULL, 0x0003e8000c901c46ULL, 0x000000002a7b7faeULL, 0x0003e8000c101c46ULL,
0x00000000287d7faeULL, 0x0003e8000f101c46ULL, 0x000000006e7f7faeULL, 0x0003e2000e901c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000004052b7811ULL, 0x002fe200078fe8ffULL,
0x000000800b787824ULL, 0x000fe200078e020cULL, 0x00000008056f7811ULL, 0x000fc400078fe8ffULL,
0x0000000c05717811ULL, 0x000fe200078fe8ffULL, 0x000000012b267824ULL, 0x100fe200078e0205ULL,
0x0000001405757811ULL, 0x000fe200078fe8ffULL, 0x000000082b297824ULL, 0x000fe200078e00ffULL,
0x0000001005737811ULL, 0x000fe200078fe8ffULL, 0x000000016f287824ULL, 0x100fe200078e0205ULL,
0x0000001805777811ULL, 0x000fe200078fe8ffULL, 0x000000086f6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8297a7812ULL, 0x000fe200078ee226ULL, 0x0000000171267824ULL, 0x100fe400078e0205ULL,
0x0000000175297824ULL, 0x000fe200078e0205ULL, 0xfffffff86d7e7812ULL, 0x000fe200078ee228ULL,
0x00000008716d7824ULL, 0x000fc400078e00ffULL, 0x0000000875887824ULL, 0x000fe400078e00ffULL,
0x0000000173287824ULL, 0x000fe200078e0205ULL, 0xfffffff86d847812ULL, 0x000fe200078ee226ULL,
0x0000000873797824ULL, 0x000fe200078e00ffULL, 0xfffffff888887812ULL, 0x000fe200078ee229ULL,
0x00000001772a7824ULL, 0x000fe200078e0205ULL, 0x0000001c05267811ULL, 0x000fe200078fe8ffULL,
0x00000008777b7824ULL, 0x000fe200078e00ffULL, 0xfffffff879867812ULL, 0x000fe200078ee228ULL,
0x000000ffff797224ULL, 0x000fe200078e00ffULL, 0x0000007c05297211ULL, 0x000fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x000fe200078e027cULL, 0xfffffff87b8a7812ULL, 0x000fe200078ee22aULL,
0x000000016f6f7824ULL, 0x000fc400078e027cULL, 0x0000000171717824ULL, 0x100fe400078e027cULL,
0x0000000173737824ULL, 0x100fe400078e027cULL, 0x0000000175757824ULL, 0x100fe400078e027cULL,
0x0000000177777824ULL, 0x100fe400078e027cULL, 0x00000001266d7824ULL, 0x040fe400078e027cULL,
0x00000001267b7824ULL, 0x000fc400078e0205ULL, 0x00000008267c7824ULL, 0x000fe200078e00ffULL,
0x0000000505267211ULL, 0x000fe200078fe8ffULL, 0x0000010029287825ULL, 0x000fc600078e0078ULL,
0x0000000726267812ULL, 0x000fe200078ec0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0078ULL,
0x0000640028287a10ULL, 0x000fe40007f1e0ffULL, 0x0ffffff826267812ULL, 0x000fe200078ef805ULL,
0x000001006f6e7825ULL, 0x100fe200078e0078ULL, 0x000064002a2a7a10ULL, 0x000fe40007f3e0ffULL,
0x0000650029297a10ULL, 0x000fe200007fe4ffULL, 0x0000010071707825ULL, 0x000fe200078e0078ULL,
0x000065002b2b7a10ULL, 0x000fc40000ffe4ffULL, 0x000064006e6e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010073727825ULL, 0x000fe200078e0078ULL, 0x0000640070707a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee27bULL, 0x0000010075747825ULL, 0x100fe200078e0078ULL,
0x0000640072727a10ULL, 0x000fe40007f5e0ffULL, 0x000065006f6f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010077767825ULL, 0x000fe200078e0078ULL, 0x0000650071717a10ULL, 0x000fc40000ffe4ffULL,
0x0000640074747a10ULL, 0x000fe20007f1e0ffULL, 0x000001006d787825ULL, 0x000fe200078e0078ULL,
0x0000650073737a10ULL, 0x000fe400017fe4ffULL, 0x0000640076767a10ULL, 0x000fe20007f3e0ffULL,
0x00000010266d7824ULL, 0x100fe200078e021bULL, 0x0000640078787a10ULL, 0x000fe20007f5e0ffULL,
0x000000107a7b7824ULL, 0x100fe200078e021bULL, 0x0000650075757a10ULL, 0x000fe200007fe4ffULL,
0x000000107e7d7824ULL, 0x100fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000286d7faeULL, 0x0003e2000b901c46ULL, 0x00000010847f7824ULL, 0x100fe200078e021bULL,
0x0000650077777a10ULL, 0x000fe20000ffe4ffULL, 0x0000001086837824ULL, 0x100fe200078e021bULL,
0x000000002a7b7faeULL, 0x0003e2000b901c46ULL, 0x0000001088857824ULL, 0x100fe200078e021bULL,
0x0000650079797a10ULL, 0x000fe200017fe4ffULL, 0x000000108a877824ULL, 0x100fe200078e021bULL,
0x000000006e7d7faeULL, 0x0003e2000b901c46ULL, 0x000000107c897824ULL, 0x000fc600078e021bULL,
0x00000000707f7faeULL, 0x0003e8000b901c46ULL, 0x0000000072837faeULL, 0x0003e8000b901c46ULL,
0x0000000074857faeULL, 0x0003e8000b901c46ULL, 0x0000000076877faeULL, 0x0003e8000b901c46ULL,
0x0000000078897faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001008297812ULL, 0x002fca00078ec0ffULL, 0x000000206c6c7824ULL, 0x000fc800078e0229ULL,
0x000000080b267824ULL, 0x000fe200078e026cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e64800266c7f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x01e64c00262b7984ULL, 0x000ee40000000800ULL, 0x800000002bff7812ULL, 0x00cfe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a286f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09006f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x0000006f2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e64c00262b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x004fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002267824ULL, 0x002fca00078e00ffULL, 0xffffff8026297812ULL, 0x000fc800078ec0ffULL,
0x000001000c297810ULL, 0x000fca0007ffe029ULL, 0x0000000180297824ULL, 0x000fca00078e0229ULL,
0x01e00000296e7984ULL, 0x000e680000000800ULL, 0x01e2000029707984ULL, 0x0004e20000000800ULL,
0x000000276e00720bULL, 0x002fe20003f1d000ULL, 0x000138027f007947ULL, 0x000fd8000b800000ULL,
0x00000000006d7806ULL, 0x004fc800000e0100ULL, 0x000000ff6d00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff267224ULL, 0x000fd400078e0027ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x0000000202297811ULL, 0x000fe400078ff0ffULL, 0x000000276e00720bULL, 0x000fe40003f34000ULL,
0x000000022900720cULL, 0x000fe20003f05270ULL, 0x000137c27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000267806ULL, 0x000fc400008e0100ULL, 0x0000008002298824ULL, 0x000fe200078e020cULL,
0x000000276e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000180298824ULL, 0x000fca00078e0229ULL, 0x01e4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000276e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff26ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002728287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800727308ULL, 0x000e640000000800ULL,
0x0000007225257220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011605ULL, 0x000137027f007947ULL, 0x000fea000b800000ULL,
0x00001f2972297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0026ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805297811ULL, 0x000fe200078ff0ffULL,
0x000135f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2972297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000026ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001005297811ULL, 0x000fe200078ff0ffULL, 0x000134e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2972297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000026ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001805297811ULL, 0x000fe200078ff0ffULL, 0x000133e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2972297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000266dff7212ULL, 0x000fe400078030ffULL, 0x000000276e267209ULL, 0x000fd60007810000ULL,
0x800000266e6e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e000d0308ULL, 0x000e640000000800ULL, 0x0000000d70700220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002570257221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000dff0e723eULL, 0x000fe400000010ffULL,
0x00000002ff6e7819ULL, 0x000fe40000011605ULL, 0x000054100e117816ULL, 0x000fe2000000000eULL,
0x000132327f007947ULL, 0x000fea000b800000ULL, 0x00001f6e110e7589ULL, 0x0002a400000e0000ULL,
0x000000086e297810ULL, 0x000fe20007ffe0ffULL, 0x000132827f007947ULL, 0x000fea000b800000ULL,
0x000000106e107810ULL, 0x000fe20007ffe0ffULL, 0x00001f29110f7589ULL, 0x00066a00000e0000ULL,
0x00001f1011107589ULL, 0x0006a400000e0000ULL, 0x000000186e297810ULL, 0x008fe20007ffe0ffULL,
0x000133127f007947ULL, 0x000fea000b800000ULL, 0x00001f2911117589ULL, 0x0022e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000202277824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000200002297824ULL, 0x002fe200078e00ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x00000008122b7824ULL, 0x000fe200078e00ffULL,
0x0000000427287812ULL, 0x000fe200078ec0ffULL, 0x00000008136c7824ULL, 0x000fe200078e00ffULL,
0xffffc000292a7812ULL, 0x000fc400078ec0ffULL, 0x0000002805277211ULL, 0x000fc600078fe0ffULL,
0x000020000b757824ULL, 0x000fe400078e022aULL, 0x0000000112287824ULL, 0x100fe400078e0227ULL,
0x0000000113297824ULL, 0x000fe200078e0227ULL, 0x0001400015277810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82b287812ULL, 0x000fe400078ee228ULL, 0xfffffff86c2a7812ULL, 0x000fe400078ee229ULL,
0x0001600075757810ULL, 0x000fe20007ffe0ffULL, 0x00000010286c7824ULL, 0x000fc400078e0227ULL,
0x000000102a2a7824ULL, 0x000fe400078e0227ULL, 0x0000001016707824ULL, 0x100fe400078e0275ULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x0000001014747824ULL, 0x100fe400078e0275ULL,
0x0000001017787824ULL, 0x000fe200078e0275ULL, 0x000000002a28783bULL, 0x000ee20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000e6c6c7231ULL, 0x086fe400003400ffULL,
0x0000000e6e6e7231ULL, 0x000fc400003400ffULL, 0x0000000f6d6d7231ULL, 0x080fe400003400ffULL,
0x0000000f6f6f7231ULL, 0x000fe400003400ffULL, 0x0000001028287231ULL, 0x088fe400003400ffULL,
0x000000102a2a7231ULL, 0x000fe400003400ffULL, 0x0000001129297231ULL, 0x080fe400003400ffULL,
0x000000112b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010187c7824ULL, 0x000fe200078e0275ULL, 0x000000007070783bULL, 0x000f220000004200ULL,
0x0001600024247810ULL, 0x000fe20007ffe0ffULL, 0x0000024000007945ULL, 0x000fe40003800000ULL,
0x000000007474783bULL, 0x000ee40000004200ULL, 0x0000001022227824ULL, 0x000fc400078e0224ULL,
0x000000007878783bULL, 0x000ea80000004200ULL, 0x000000007c7c783bULL, 0x000e640000004200ULL,
0x000000706c2c723cULL, 0x092f70000004182cULL, 0x00000070284c723cULL, 0x048b6e000004184cULL,
0x0000001019707824ULL, 0x120fe200078e0227ULL, 0x000000722850723cULL, 0x000f620000041850ULL,
0x000000101a277824ULL, 0x000fce00078e0227ULL, 0x000000742854723cULL, 0x040f700000041854ULL,
0x000000762858723cULL, 0x040f700000041858ULL, 0x00000078285c723cULL, 0x044f70000004185cULL,
0x0000007a2860723cULL, 0x040f700000041860ULL, 0x0000007c2864723cULL, 0x000f700000041864ULL,
0x000000726c30723cULL, 0x000b640000041830ULL, 0x000000007070783bULL, 0x020e6c0000000200ULL,
0x0000007e2828723cULL, 0x000b640000041868ULL, 0x000000002768783bULL, 0x0204ec0000000200ULL,
0x000000746c34723cULL, 0x040b6e0000041834ULL, 0x0000001023747824ULL, 0x120fe200078e0224ULL,
0x000000766c38723cULL, 0x040f700000041838ULL, 0x000000786c3c723cULL, 0x040f70000004183cULL,
0x0000007a6c40723cULL, 0x040f700000041840ULL, 0x0000007c6c44723cULL, 0x040f700000041844ULL,
0x0000007e6c48723cULL, 0x000b6e0000041848ULL, 0x00000010216c7824ULL, 0x020fe200078e0224ULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000e70707231ULL, 0x08efe400003400ffULL,
0x0000000e72727231ULL, 0x000fc400003400ffULL, 0x0000000f71717231ULL, 0x080fe400003400ffULL,
0x0000000f73737231ULL, 0x000fe400003400ffULL, 0x0000001068687231ULL, 0x080fe400003400ffULL,
0x000000106a6a7231ULL, 0x000fe400003400ffULL, 0x0000001169697231ULL, 0x080fe400003400ffULL,
0x000000116b6b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x00efea0003800000ULL,
0x0000001020787824ULL, 0x000fe200078e0224ULL, 0x000000006c6c783bULL, 0x000e680000004200ULL,
0x000000002220783bULL, 0x000ea80000004200ULL, 0x000000007474783bULL, 0x000ee80000004200ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x0000006c684c723cULL, 0x042f70000004184cULL,
0x0000006e6850723cULL, 0x040f700000041850ULL, 0x000000206854723cULL, 0x044f700000041854ULL,
0x000000226858723cULL, 0x040f700000041858ULL, 0x00000074685c723cULL, 0x048f70000004185cULL,
0x000000766860723cULL, 0x040f700000041860ULL, 0x000000786864723cULL, 0x010f700000041864ULL,
0x0000006c702c723cULL, 0x040f70000004182cULL, 0x0000006e7030723cULL, 0x040f700000041830ULL,
0x000000227038723cULL, 0x040f700000041838ULL, 0x00000074703c723cULL, 0x040f70000004183cULL,
0x000000767040723cULL, 0x040f700000041840ULL, 0x000000787044723cULL, 0x040f700000041844ULL,
0x0000007a7048723cULL, 0x080f700000041848ULL, 0x0000007a6868723cULL, 0x000f700000041828ULL,
0x000000207034723cULL, 0x000b6e0000041834ULL, 0x00000002ff207819ULL, 0x020fc80000011602ULL,
0x0001e69820217811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000030004047a10ULL, 0x000fe20007ffe0ffULL, 0x0000000021ff7f8cULL, 0x0003e6000c80043fULL,
0x000000070400720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000ba000000947ULL, 0x000fea0003800000ULL, 0x0000000104227810ULL, 0x042fe20007ffe0ffULL,
0x0000010004237824ULL, 0x000fc600078e0209ULL, 0x000000072200720cULL, 0x000fe20003f06070ULL,
0x000068000a767a24ULL, 0x000fd800078e0223ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff747819ULL, 0x100fe20000011605ULL, 0x000000800b227824ULL, 0x000fe200078e020cULL,
0x0000002306217217ULL, 0x000fe40007800000ULL, 0x0000000474287810ULL, 0x040fe20007ffe0ffULL,
0x0000000174297824ULL, 0x140fe200078e0276ULL, 0x00000008746c7810ULL, 0x000fe40007ffe0ffULL,
0x0000002123217210ULL, 0x000fe20007ffe1ffULL, 0x0000000128237824ULL, 0x100fe200078e0205ULL,
0x0000000c74727810ULL, 0x000fe20007ffe0ffULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0x0000002021217817ULL, 0x000fe20003800000ULL, 0x000000016c277824ULL, 0x000fe200078e0205ULL,
0x00000010747a7810ULL, 0x000fe20007ffe0ffULL, 0x000000086c6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a757812ULL, 0x000fe200078ee223ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000000212800720cULL, 0x0c0fe20003f86070ULL, 0x00000001282b7824ULL, 0x000fe200078e0276ULL,
0xfffffff86e7b7812ULL, 0x000fe200078ee227ULL, 0x0000000172277824ULL, 0x000fe200078e0205ULL,
0x00000014747c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008726e7824ULL, 0x040fe200078e00ffULL,
0x000000217200720cULL, 0x080fe20003f46070ULL, 0x0000010029287825ULL, 0x000fe200078e0022ULL,
0x000000216c00720cULL, 0x000fc40003f66070ULL, 0xfffffff86e7d7812ULL, 0x000fe200078ee227ULL,
0x000001002b2a7825ULL, 0x000fe200078e0022ULL, 0x00006400286e7a10ULL, 0x000fe40007f1e0ffULL,
0x000000217400720cULL, 0x080fe20003fa6070ULL, 0x000000017a6d7824ULL, 0x100fe200078e0205ULL,
0x000064002a707a10ULL, 0x000fe20007f3e0ffULL, 0x000000087a787824ULL, 0x000fe200078e00ffULL,
0x00006500296f7a10ULL, 0x000fe200007fe4ffULL, 0x000000016c297824ULL, 0x100fe200078e0276ULL,
0x000065002b717a10ULL, 0x000fe20000ffe4ffULL, 0x0000000174277824ULL, 0x000fe200078e0205ULL,
0xfffffff8787f7812ULL, 0x000fe200078ee26dULL, 0x00000001722b7824ULL, 0x000fe200078e0276ULL,
0x000000217a00720cULL, 0x000fe20003f26070ULL, 0x0000010029287825ULL, 0x000fe200078e0022ULL,
0x0000000727787812ULL, 0x000fc600078ec0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0022ULL,
0x0000640028727a10ULL, 0x000fc60007f1e0ffULL, 0x000000017a6d7824ULL, 0x000fe200078e0276ULL,
0x000064002a2a7a10ULL, 0x000fe20007fde0ffULL, 0x000000017c277824ULL, 0x040fe200078e0205ULL,
0x0000650029737a10ULL, 0x000fe200007fe4ffULL, 0x000000087c7a7824ULL, 0x040fe200078e00ffULL,
0x000065002b2b7a10ULL, 0x000fe200037fe4ffULL, 0x000001006d6c7825ULL, 0x000fe200078e0022ULL,
0x000000217c00720cULL, 0x000fe40003f06070ULL, 0xfffffff87a837812ULL, 0x000fe200078ee227ULL,
0x000000017c297824ULL, 0x000fe200078e0276ULL, 0x0ffffff878277812ULL, 0x000fe200078ef805ULL,
0x0000001075797824ULL, 0x000fe200078e0224ULL, 0x000064006c6c7a10ULL, 0x000fe20007fde0ffULL,
0x0000010029287825ULL, 0x000fe200078e0022ULL, 0x0000001874787810ULL, 0x000fc40007ffe0ffULL,
0x000065006d6d7a10ULL, 0x000fe200037fe4ffULL, 0x0000001027777824ULL, 0x000fe200078e0224ULL,
0x0000001c747a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000178277824ULL, 0x000fe200078e0276ULL,
0x0000640028747a10ULL, 0x000fe20007fde0ffULL, 0x000000107b7b7824ULL, 0x100fe200078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e777faeULL, 0x0003e2000e901c46ULL,
0x000000217800720cULL, 0x080fe20003fa6070ULL, 0x000000107d7d7824ULL, 0x000fe200078e0224ULL,
0x0000650029757a10ULL, 0x000fe200037fe4ffULL, 0x0000000070797faeULL, 0x0005e2000e101c46ULL,
0x000000217a00720cULL, 0x000fe20003f86070ULL, 0x0000010027287825ULL, 0x000fc400078e0022ULL,
0x00000000727b7faeULL, 0x0005e4000d901c46ULL, 0x000000017a217824ULL, 0x000fe200078e0276ULL,
0x0000640028287a10ULL, 0x000fe20007fde0ffULL, 0x0000000178277824ULL, 0x140fe200078e0205ULL,
0x000000002a7d7faeULL, 0x0005e2000d101c46ULL, 0x0000000878787824ULL, 0x000fe200078e00ffULL,
0x0000650029297a10ULL, 0x000fe200037fe4ffULL, 0x000000017a6e7824ULL, 0x042fe400078e0205ULL,
0x000000087a6f7824ULL, 0x000fe200078e00ffULL, 0xfffffff878277812ULL, 0x000fe200078ee227ULL,
0x0000010021227825ULL, 0x000fc600078e0022ULL, 0xfffffff86f217812ULL, 0x000fe200078ee26eULL,
0x000000107f7f7824ULL, 0x100fe200078e0224ULL, 0x0000640022227a10ULL, 0x000fe20007fde0ffULL,
0x0000001083837824ULL, 0x100fe400078e0224ULL, 0x0000001027277824ULL, 0x100fe200078e0224ULL,
0x0000650023237a10ULL, 0x000fe200037fe4ffULL, 0x0000001021217824ULL, 0x000fe200078e0224ULL,
0x000000006c7f7faeULL, 0x0005e8000c901c46ULL, 0x0000000074837faeULL, 0x0005e8000c101c46ULL,
0x0000000028277faeULL, 0x0005e8000e901c46ULL, 0x0000000022217faeULL, 0x0005e2000e101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000405297811ULL, 0x000fe200078fe8ffULL,
0x000000800b747824ULL, 0x000fe200078e020cULL, 0x00000008052b7811ULL, 0x040fe200078fe8ffULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x0000000c056d7811ULL, 0x000fe200078fe8ffULL,
0x0000000129217824ULL, 0x100fe200078e0205ULL, 0x0000001805737811ULL, 0x000fe200078fe8ffULL,
0x0000000829287824ULL, 0x000fe200078e00ffULL, 0x00000010056f7811ULL, 0x000fe200078fe8ffULL,
0x000000012b227824ULL, 0x000fe200078e0205ULL, 0x0000001405717811ULL, 0x000fe200078fe8ffULL,
0x000000082b797824ULL, 0x000fe200078e00ffULL, 0xfffffff828777812ULL, 0x000fe200078ee221ULL,
0x000000016d217824ULL, 0x000fc400078e0205ULL, 0x000000086d287824ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fe200078ee222ULL, 0x0000000173277824ULL, 0x040fe400078e0205ULL,
0x00000008736c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8287b7812ULL, 0x000fe200078ee221ULL,
0x000000016f227824ULL, 0x000fe200078e0205ULL, 0x0000000505217211ULL, 0x000fe200078fe8ffULL,
0x000000086f7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff86c837812ULL, 0x000fe200078ee227ULL,
0x0000000171237824ULL, 0x000fe200078e0205ULL, 0x0000001c05277811ULL, 0x000fe200078fe8ffULL,
0x00000008712a7824ULL, 0x000fe200078e00ffULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee222ULL,
0x0000000129297824ULL, 0x100fe200078e0276ULL, 0x0000000721227812ULL, 0x000fe200078ec0ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0276ULL, 0xfffffff82a7f7812ULL, 0x000fe200078ee223ULL,
0x000000016d6d7824ULL, 0x100fe200078e0276ULL, 0x0000007605237211ULL, 0x000fe200078fe8ffULL,
0x000000016f6f7824ULL, 0x000fc400078e0276ULL, 0x0000000171717824ULL, 0x100fe400078e0276ULL,
0x0000000173737824ULL, 0x100fe400078e0276ULL, 0x0000000127217824ULL, 0x040fe400078e0276ULL,
0x0000000127767824ULL, 0x140fe400078e0205ULL, 0x0000000827857824ULL, 0x000fe200078e00ffULL,
0x0ffffff822277812ULL, 0x000fe200078ef805ULL, 0x0000010023227825ULL, 0x000fc800078e0074ULL,
0x0000010029287825ULL, 0x000fe200078e0074ULL, 0x0000640022227a10ULL, 0x000fc60007f1e0ffULL,
0x000001002b2a7825ULL, 0x100fe200078e0074ULL, 0x0000640028287a10ULL, 0x000fe40007f3e0ffULL,
0x0000650023237a10ULL, 0x000fe200007fe4ffULL, 0x000001006d6c7825ULL, 0x100fe200078e0074ULL,
0x000064002a2a7a10ULL, 0x000fe40007f5e0ffULL, 0x0000650029297a10ULL, 0x000fe20000ffe4ffULL,
0x000001006f6e7825ULL, 0x100fe200078e0074ULL, 0x000064006c6c7a10ULL, 0x000fe40007f7e0ffULL,
0x000065002b2b7a10ULL, 0x000fe200017fe4ffULL, 0x0000010071707825ULL, 0x000fe200078e0074ULL,
0x000064006e6e7a10ULL, 0x000fc40007f1e0ffULL, 0x000065006d6d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000010073727825ULL, 0x100fe200078e0074ULL, 0x0000640070707a10ULL, 0x000fe40007f3e0ffULL,
0x000065006f6f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010021747825ULL, 0x000fe200078e0074ULL,
0xfffffff885217812ULL, 0x000fe400078ee276ULL, 0x0000640072727a10ULL, 0x000fe20007f5e0ffULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x0000640074747a10ULL, 0x000fe20007f7e0ffULL,
0x0000001077777824ULL, 0x100fe200078e0224ULL, 0x0000650071717a10ULL, 0x000fe20000ffe4ffULL,
0x0000001079797824ULL, 0x100fe200078e0224ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022277faeULL, 0x0003e2000b901c46ULL, 0x000000107b7b7824ULL, 0x100fe200078e0224ULL,
0x0000650073737a10ULL, 0x000fe200017fe4ffULL, 0x000000107d7d7824ULL, 0x100fe200078e0224ULL,
0x0000000028777faeULL, 0x0003e2000b901c46ULL, 0x000000107f7f7824ULL, 0x100fe200078e0224ULL,
0x0000650075757a10ULL, 0x000fe20001ffe4ffULL, 0x0000001083837824ULL, 0x100fe200078e0224ULL,
0x000000002a797faeULL, 0x0003e2000b901c46ULL, 0x0000001021217824ULL, 0x000fc600078e0224ULL,
0x000000006c7b7faeULL, 0x0003e8000b901c46ULL, 0x000000006e7d7faeULL, 0x0003e8000b901c46ULL,
0x00000000707f7faeULL, 0x0003e8000b901c46ULL, 0x0000000072837faeULL, 0x0003e8000b901c46ULL,
0x0000000074217faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x0000001008217812ULL, 0x004fc400078ec0ffULL, 0x0000000808247812ULL, 0x000fc600078ec0ffULL,
0x0000002020217824ULL, 0x000fc800078e0221ULL, 0x0000000124247824ULL, 0x000fe200078e0221ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6680024287f8cULL, 0x0002a4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01e66c0024237984ULL, 0x000ee40000000800ULL,
0x8000000023ff7812ULL, 0x00cfe40007804829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220277210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011423ULL, 0x0000002722227211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000222227819ULL, 0x000fc80000001223ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e66c0024237984ULL, 0x000ea40000000800ULL, 0x8000000023ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000302217811ULL, 0x000fca00078ff0ffULL,
0x0000008021217824ULL, 0x000fc800078e020cULL, 0x0000000180217824ULL, 0x000fca00078e0221ULL,
0x01e0000021237984ULL, 0x000ea80000000800ULL, 0x01e2000021207984ULL, 0x0006620000000800ULL,
0x000000262300720bULL, 0x004fe20003f1d000ULL, 0x00011dd27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000217806ULL, 0x008fc800000e0100ULL, 0x000000ff2100720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff227224ULL, 0x000fd400078e0026ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x0000000302277811ULL, 0x000fe400078ff0ffULL, 0x000000262300720bULL, 0x000fe40003f34000ULL,
0x000000022700720cULL, 0x000fe20003f05270ULL, 0x00011d927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400008e0100ULL, 0x0000008002278824ULL, 0x000fe200078e020cULL,
0x00000026230c8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000180278824ULL, 0x000fca00078e0227ULL, 0x01e4000c27008388ULL, 0x0005e20000000800ULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002623277209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x00000026270c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fcc0000410000ULL, 0x0000000c000c7308ULL, 0x000ea40000000800ULL,
0x0000000c25257220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011605ULL, 0x00011cd27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c297589ULL, 0x0004e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000805297811ULL, 0x000fe200078ff0ffULL,
0x00011bc27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c297589ULL, 0x0004e400000e0000ULL,
0x000000292e2e7220ULL, 0x08cfe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000022ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001005297811ULL, 0x000fe200078ff0ffULL, 0x00011ab27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c297589ULL, 0x0004e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001805297811ULL, 0x000fe200078ff0ffULL, 0x000119b27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c297589ULL, 0x0004e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000002221ff7212ULL, 0x000fe400078030ffULL, 0x0000002623227209ULL, 0x000fd60007810000ULL,
0x8000002223230221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL,
0x00000023000d0308ULL, 0x000ea40000000800ULL, 0x0000000d20200220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002520257221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000dff0c723eULL, 0x000fe400000010ffULL,
0x00000002ff117819ULL, 0x000fe40000011605ULL, 0x000054100c0c7816ULL, 0x000fe2000000000cULL,
0x000118027f007947ULL, 0x000fea000b800000ULL, 0x00001f110c0e7589ULL, 0x0002a400000e0000ULL,
0x0000000811297810ULL, 0x000fe20007ffe0ffULL, 0x000118527f007947ULL, 0x000fea000b800000ULL,
0x0000001011217810ULL, 0x000fe20007ffe0ffULL, 0x00001f290c0f7589ULL, 0x00066800000e0000ULL,
0x00001f210c107589ULL, 0x0006a400000e0000ULL, 0x0000001811297810ULL, 0x008fe20007ffe0ffULL,
0x000118e27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c117589ULL, 0x0022e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff207819ULL, 0x000fe20000011602ULL,
0x0000000812237824ULL, 0x000fe200078e00ffULL, 0x00000004ff217819ULL, 0x000fe20000011605ULL,
0x0000000813277824ULL, 0x000fe200078e00ffULL, 0x00000001200c7812ULL, 0x002fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000001016787824ULL, 0x000fc400078e021bULL, 0x000000040c0c7824ULL, 0x000fe200078e0221ULL,
0x0000000302217811ULL, 0x000fe200078ff0ffULL, 0x00000010147c7824ULL, 0x100fe400078e021bULL,
0x0000000112127824ULL, 0x100fe400078e020cULL, 0x00000001130c7824ULL, 0x000fe200078e020cULL,
0x0001200021137811ULL, 0x000fe200078e60ffULL, 0x00000010176c7824ULL, 0x000fe200078e021bULL,
0xfffffff823127812ULL, 0x000fe400078ee212ULL, 0xfffffff8270c7812ULL, 0x000fc600078ee20cULL,
0x0000001012127824ULL, 0x100fe400078e0213ULL, 0x000000100c0c7824ULL, 0x000fc600078e0213ULL,
0x000000001274783bULL, 0x0002e80000000200ULL, 0x000000000c28783bULL, 0x0002a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000e74747231ULL, 0x08cfe400003400ffULL,
0x0000000e76767231ULL, 0x000fe400003400ffULL, 0x0000000f75757231ULL, 0x080fe400003400ffULL,
0x0000000f77777231ULL, 0x000fc400003400ffULL, 0x0000001028287231ULL, 0x080fe400003400ffULL,
0x000000102a2a7231ULL, 0x000fe400003400ffULL, 0x0000001129297231ULL, 0x080fe400003400ffULL,
0x000000112b2b7231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001018707824ULL, 0x000fe200078e021bULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x0001500015157810ULL, 0x000fe20007ffe0ffULL, 0x0000022000007945ULL, 0x000fe40003800000ULL,
0x000000007c7c783bULL, 0x000e640000004200ULL, 0x0000001019197824ULL, 0x000fc400078e0215ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x000000101a157824ULL, 0x000fc600078e0215ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000001918783bULL, 0x000e680000000200ULL,
0x000000001514783bULL, 0x000ea20000000200ULL, 0x00000078742c723cULL, 0x058b70000004182cULL,
0x0000007a7430723cULL, 0x040b700000041830ULL, 0x0000007c7434723cULL, 0x042b700000041834ULL,
0x0000007e7438723cULL, 0x040b700000041838ULL, 0x0000006c743c723cULL, 0x040b70000004183cULL,
0x0000006e7440723cULL, 0x040b700000041840ULL, 0x000000707444723cULL, 0x044b700000041844ULL,
0x000000727448723cULL, 0x000b700000041848ULL, 0x00000078284c723cULL, 0x040b70000004184cULL,
0x0000007a2850723cULL, 0x040b700000041850ULL, 0x0000007c2854723cULL, 0x040b700000041854ULL,
0x0000007e2858723cULL, 0x040b700000041858ULL, 0x0000006c285c723cULL, 0x040b70000004185cULL,
0x0000006e2860723cULL, 0x040b700000041860ULL, 0x000000702864723cULL, 0x040b700000041864ULL,
0x000000722868723cULL, 0x000b620000041868ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000000e18187231ULL, 0x080fe400003400ffULL,
0x0000000e1a1a7231ULL, 0x000fc400003400ffULL, 0x0000000f19197231ULL, 0x080fe400003400ffULL,
0x0000000f1b1b7231ULL, 0x000fe400003400ffULL, 0x0000001014147231ULL, 0x080fe400003400ffULL,
0x0000001016167231ULL, 0x000fe400003400ffULL, 0x0000001115157231ULL, 0x080fe400003400ffULL,
0x0000001117177231ULL, 0x000fc400003400ffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000001c28783bULL, 0x020e620000004200ULL, 0x00000002020c7824ULL, 0x000fc600078e00ffULL,
0x000000001d6c783bULL, 0x000ea40000004200ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000001e70783bULL, 0x000ee80000004200ULL, 0x000000001f74783bULL, 0x000f220000004200ULL,
0x00000028182c723cULL, 0x042b70000004182cULL, 0x0000002a1830723cULL, 0x040b700000041830ULL,
0x0000006c1834723cULL, 0x044b700000041834ULL, 0x0000006e1838723cULL, 0x040b700000041838ULL,
0x00000070183c723cULL, 0x048b70000004183cULL, 0x000000721840723cULL, 0x040b700000041840ULL,
0x000000741844723cULL, 0x050b700000041844ULL, 0x000000761848723cULL, 0x000b700000041848ULL,
0x00000028144c723cULL, 0x040b70000004184cULL, 0x0000002a1450723cULL, 0x040b700000041850ULL,
0x0000006c1454723cULL, 0x040b700000041854ULL, 0x0000006e1458723cULL, 0x040b700000041858ULL,
0x00000070145c723cULL, 0x040b70000004185cULL, 0x000000721460723cULL, 0x040b700000041860ULL,
0x000000741464723cULL, 0x040b700000041864ULL, 0x000000761468723cULL, 0x000b620000041868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000070400720cULL, 0x000fe20003f06070ULL,
0x01e6a0000cff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff84a000007947ULL, 0x000fea000383ffffULL, 0x0000000000087919ULL, 0x000e640000002500ULL,
0x000000070800720cULL, 0x002fda0003f06070ULL, 0x0000057000000947ULL, 0x000fea0003800000ULL,
0x0180000025047810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000004047812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0025ULL,
0x00009b20000c7802ULL, 0x000fc40000000f00ULL, 0x0001163000007944ULL, 0x020fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002500047308ULL, 0x000e640000001000ULL,
0xbf80000004057423ULL, 0x002fc80000000025ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000504047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000f240000000000ULL, 0x00000002ff057819ULL, 0x010fe40000011606ULL,
0x0000001006077811ULL, 0x040fe400078ff0ffULL, 0x00000018060f7811ULL, 0x040fe400078ff0ffULL,
0x00000008060d7811ULL, 0x000fe200078ff0ffULL, 0x00001f0504057589ULL, 0x00cea800000e0000ULL,
0x00001f0f040a7589ULL, 0x002e6800000e0000ULL, 0x00001f0d04067589ULL, 0x000ee800000e0000ULL,
0x00001f0704077589ULL, 0x000f2200000e0000ULL, 0x0000002c052c7220ULL, 0x024fc40000410000ULL,
0x0000002d052d7220ULL, 0x040fe40000410000ULL, 0x0000003005307220ULL, 0x040fe40000410000ULL,
0x0000003105317220ULL, 0x040fe40000410000ULL, 0x0000003405347220ULL, 0x040fe40000410000ULL,
0x0000003505357220ULL, 0x040fe40000410000ULL, 0x0000003805387220ULL, 0x000fc40000410000ULL,
0x0000003905397220ULL, 0x040fe40000410000ULL, 0x0000003c053c7220ULL, 0x040fe40000410000ULL,
0x0000003d053d7220ULL, 0x040fe40000410000ULL, 0x0000004005407220ULL, 0x040fe40000410000ULL,
0x0000004105417220ULL, 0x040fe40000410000ULL, 0x0000004405447220ULL, 0x000fc40000410000ULL,
0x0000004505457220ULL, 0x040fe40000410000ULL, 0x0000004805487220ULL, 0x040fe40000410000ULL,
0x0000004905497220ULL, 0x000fe40000410000ULL, 0x0000004e0a4e7220ULL, 0x042fe40000410000ULL,
0x0000004f0a4f7220ULL, 0x040fe40000410000ULL, 0x000000520a527220ULL, 0x000fc40000410000ULL,
0x000000530a537220ULL, 0x040fe40000410000ULL, 0x000000560a567220ULL, 0x040fe40000410000ULL,
0x000000570a577220ULL, 0x040fe40000410000ULL, 0x0000005a0a5a7220ULL, 0x040fe40000410000ULL,
0x0000005b0a5b7220ULL, 0x040fe40000410000ULL, 0x0000005e0a5e7220ULL, 0x000fc40000410000ULL,
0x0000005f0a5f7220ULL, 0x040fe40000410000ULL, 0x000000620a627220ULL, 0x040fe40000410000ULL,
0x000000630a637220ULL, 0x040fe40000410000ULL, 0x000000660a667220ULL, 0x040fe40000410000ULL,
0x000000670a677220ULL, 0x040fe40000410000ULL, 0x0000006a0a6a7220ULL, 0x000fc40000410000ULL,
0x0000006b0a6b7220ULL, 0x000fe40000410000ULL, 0x000000062e2e7220ULL, 0x088fe40000410000ULL,
0x000000062f2f7220ULL, 0x080fe40000410000ULL, 0x0000000632327220ULL, 0x080fe40000410000ULL,
0x0000000633337220ULL, 0x080fe40000410000ULL, 0x0000000636367220ULL, 0x000fc40000410000ULL,
0x0000000637377220ULL, 0x080fe40000410000ULL, 0x000000063a3a7220ULL, 0x080fe40000410000ULL,
0x000000063b3b7220ULL, 0x080fe40000410000ULL, 0x000000063e3e7220ULL, 0x080fe40000410000ULL,
0x000000063f3f7220ULL, 0x080fe40000410000ULL, 0x0000000642427220ULL, 0x000fc40000410000ULL,
0x0000000643437220ULL, 0x080fe40000410000ULL, 0x0000000646467220ULL, 0x080fe40000410000ULL,
0x0000000647477220ULL, 0x080fe40000410000ULL, 0x000000064a4a7220ULL, 0x080fe40000410000ULL,
0x000000064b4b7220ULL, 0x000fe40000410000ULL, 0x000000074c4c7220ULL, 0x010fc40000410000ULL,
0x000000074d4d7220ULL, 0x080fe40000410000ULL, 0x0000000750507220ULL, 0x080fe40000410000ULL,
0x0000000751517220ULL, 0x080fe40000410000ULL, 0x0000000754547220ULL, 0x080fe40000410000ULL,
0x0000000755557220ULL, 0x080fe40000410000ULL, 0x0000000758587220ULL, 0x000fc40000410000ULL,
0x0000000759597220ULL, 0x080fe40000410000ULL, 0x000000075c5c7220ULL, 0x080fe40000410000ULL,
0x000000075d5d7220ULL, 0x080fe40000410000ULL, 0x0000000760607220ULL, 0x080fe40000410000ULL,
0x0000000761617220ULL, 0x080fe40000410000ULL, 0x0000000764647220ULL, 0x000fc40000410000ULL,
0x0000000765657220ULL, 0x080fe40000410000ULL, 0x0000000768687220ULL, 0x080fe40000410000ULL,
0x0000000769697220ULL, 0x000fc40000410000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000002c2d07723eULL, 0x020fe400000010ffULL, 0x0000002e2f2e723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000030310a723eULL, 0x000fc400000010ffULL,
0x00000034350c723eULL, 0x000fe400000010ffULL, 0x00000038390d723eULL, 0x000fe400000010ffULL,
0x0000003c3d0e723eULL, 0x000fe400000010ffULL, 0x00000040410f723eULL, 0x000fe400000010ffULL,
0x000000444510723eULL, 0x000fe400000010ffULL, 0x000000484911723eULL, 0x000fc400000010ffULL,
0x00000002ff1c7819ULL, 0x002fe40000011604ULL, 0x00000008042d7811ULL, 0x000fe400078ff0ffULL,
0x000000021c067810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1f7824ULL, 0x040fe200078e00ffULL,
0x000000011c057810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1e7824ULL, 0x040fe200078e00ffULL,
0x000000031c1a7810ULL, 0x040fe20007ffe0ffULL, 0x000000081c217824ULL, 0x040fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL, 0x000000081c247824ULL, 0x040fe200078e00ffULL,
0x000000041c1b7810ULL, 0x040fe20007ffe0ffULL, 0x000000081c297824ULL, 0x040fe200078e00ffULL,
0x000000061c067810ULL, 0x040fe20007ffe0ffULL, 0x000000081c2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1d7812ULL, 0x000fc400078ee205ULL, 0x000000051c057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe400078ee21aULL, 0xfffffff824237812ULL, 0x000fe200078ee21bULL,
0x000000081c1b7824ULL, 0x040fe200078e00ffULL, 0xffffffff1c1a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff829297812ULL, 0x000fe200078ee206ULL, 0x000000082d067824ULL, 0x000fe200078e00ffULL,
0xfffffff81e277812ULL, 0x000fe200078ee205ULL, 0x000020000b057824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21aULL, 0x00000004041a7824ULL, 0x040fe200078e00ffULL,
0x00000010042f7811ULL, 0x000fc400078ff0ffULL, 0xfffffff81b1b7812ULL, 0x000fe400078ee21cULL,
0xfffffff8062d7812ULL, 0x000fe200078ee22dULL, 0x0000100020067824ULL, 0x000fe200078e0205ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000082f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001804317811ULL, 0x000fe200078ff0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0206ULL,
0x000000323332723eULL, 0x000fe200000010ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0206ULL,
0xfffffff81c2f7812ULL, 0x000fe200078ee22fULL, 0x000000101f1f7824ULL, 0x100fe200078e0206ULL,
0x000000363736723eULL, 0x000fe200000010ffULL, 0x0000001021217824ULL, 0x100fe200078e0206ULL,
0x0000003a3b3a723eULL, 0x000fe200000010ffULL, 0x0000001023237824ULL, 0x000fe200078e0206ULL,
0x0000003e3f3e723eULL, 0x000fe200000010ffULL, 0x000000011b1c7824ULL, 0x000fe200078e021aULL,
0x000000424342723eULL, 0x000fe200000010ffULL, 0x0000001027277824ULL, 0x100fe200078e0206ULL,
0x000000464746723eULL, 0x000fe200000010ffULL, 0x000000011a1d7824ULL, 0x040fe200078e021dULL,
0x000000071c007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x100fe200078e0206ULL,
0x0000004a4b4a723eULL, 0x000fe200000010ffULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x0000000a1d007388ULL, 0x0003e20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0206ULL,
0x0000004c4d4c723eULL, 0x000fe200000010ffULL, 0x000000011a217824ULL, 0x040fe200078e0221ULL,
0x0000000c1f007388ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x100fe200078e0206ULL,
0x000000505150723eULL, 0x000fe200000010ffULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x0000000d21007388ULL, 0x000fe20000000800ULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x000000545554723eULL, 0x000fe200000010ffULL, 0x000000011a297824ULL, 0x040fe200078e0229ULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000011a2b7824ULL, 0x040fe200078e022bULL,
0x000000585958723eULL, 0x000fe200000010ffULL, 0x000000011a2d7824ULL, 0x000fe200078e022dULL,
0x0000000f27007388ULL, 0x000fe20000000800ULL, 0x00000008311e7824ULL, 0x000fe200078e00ffULL,
0x0000005c5d5c723eULL, 0x000fe200000010ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0206ULL,
0x0000001029007388ULL, 0x0005e20000000800ULL, 0x000000606160723eULL, 0x000fe200000010ffULL,
0x000000ff000a7306ULL, 0x002fe20000205400ULL, 0xfffffff81e317812ULL, 0x000fe200078ee231ULL,
0x000000112b007388ULL, 0x000fe20000000800ULL, 0x000000011a2f7824ULL, 0x000fe200078e022fULL,
0x000000646564723eULL, 0x000fc400000010ffULL, 0x0000002e2d007388ULL, 0x000fe20000000800ULL,
0x0000001031317824ULL, 0x000fe200078e0206ULL, 0x000000686968723eULL, 0x000fe200000010ffULL,
0x0000000109107824ULL, 0x004fe200078e0204ULL, 0x000400321d007388ULL, 0x000fe20000000800ULL,
0x0000004e4f12723eULL, 0x000fe200000010ffULL, 0x000000011a317824ULL, 0x000fe200078e0231ULL,
0x000000525313723eULL, 0x000fe200000010ffULL, 0x000400361f007388ULL, 0x000fe20000000800ULL,
0x000000565714723eULL, 0x000fe200000010ffULL, 0x00000010100e7824ULL, 0x000fe200078e0205ULL,
0x0000005a5b15723eULL, 0x000fe200000010ffULL, 0x0004003a21007388ULL, 0x000fe20000000800ULL,
0x0000005e5f16723eULL, 0x000fe200000010ffULL, 0x000000ff000d7306ULL, 0x000e620000209400ULL,
0x000000626317723eULL, 0x000fe200000010ffULL, 0x0004003e23007388ULL, 0x000fe20000000800ULL,
0x000000666718723eULL, 0x000fc400000010ffULL, 0x0000006a6b19723eULL, 0x000fe200000010ffULL,
0x0004004227007388ULL, 0x000fe40000000800ULL, 0x000000ff00077306ULL, 0x000ea4000020d400ULL,
0x0004004629007388ULL, 0x000fe80000000800ULL, 0x0004004a2b007388ULL, 0x000fe20000000800ULL,
0x0000000a0d00720bULL, 0x002fc60003f1d000ULL, 0x0000004c2f007388ULL, 0x000fe80000000800ULL,
0x000800501d007388ULL, 0x000fe80000000800ULL, 0x000800541f007388ULL, 0x000fe40000000800ULL,
0x0000000107070812ULL, 0x004fc400078efcffULL, 0x0008005821007388ULL, 0x000fe40000000800ULL,
0x00000007070a723eULL, 0x000fe400000010ffULL, 0x0008005c23007388ULL, 0x000fe80000000800ULL,
0x0008006027007388ULL, 0x000fe80000000800ULL, 0x0008006429007388ULL, 0x000fe80000000800ULL,
0x000800682b007388ULL, 0x000fe80000000800ULL, 0x0000001231007388ULL, 0x000fe80000000800ULL,
0x000c00131d007388ULL, 0x000fe80000000800ULL, 0x000c00141f007388ULL, 0x000fe80000000800ULL,
0x000c001521007388ULL, 0x0003e80000000800ULL, 0x000c001623007388ULL, 0x000fe80000000800ULL,
0x000c001727007388ULL, 0x000fe20000000800ULL, 0x00000300ff217624ULL, 0x002fc600078e00ffULL,
0x000c001829007388ULL, 0x000fe40000000800ULL, 0x000000012100780cULL, 0x000fe40003f05270ULL,
0x000c00192b007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000e2c7984ULL, 0x000e680000000c00ULL, 0x000400000e307984ULL, 0x000ea80000000c00ULL,
0x000800000e147984ULL, 0x000ee80000000c00ULL, 0x000c00000e187984ULL, 0x000f280000000c00ULL,
0x001000000e1c7984ULL, 0x000ee80000000c00ULL, 0x001400000e347984ULL, 0x000f280000000c00ULL,
0x001800000e387984ULL, 0x000f280000000c00ULL, 0x001c00000e287984ULL, 0x000f220000000c00ULL,
0x3f803f800a2f7831ULL, 0x002fc4000020002fULL, 0x3f803f800a2e7831ULL, 0x040fe4000020002eULL,
0x3f803f800a2d7831ULL, 0x040fe4000020002dULL, 0x3f803f800a2c7831ULL, 0x040fe4000020002cULL,
0x3f803f800a337831ULL, 0x044fe40000200033ULL, 0x3f803f800a327831ULL, 0x040fe40000200032ULL,
0x3f803f800a317831ULL, 0x000fc40000200031ULL, 0x3f803f800a307831ULL, 0x040fe40000200030ULL,
0x3f803f800a177831ULL, 0x048fe40000200017ULL, 0x3f803f800a167831ULL, 0x040fe40000200016ULL,
0x3f803f800a157831ULL, 0x040fe40000200015ULL, 0x3f803f800a147831ULL, 0x040fe40000200014ULL,
0x3f803f800a1b7831ULL, 0x010fc4000020001bULL, 0x3f803f800a1a7831ULL, 0x040fe4000020001aULL,
0x3f803f800a197831ULL, 0x040fe40000200019ULL, 0x3f803f800a187831ULL, 0x000fe40000200018ULL,
0x3f803f802f2f7831ULL, 0x000fe4000020001fULL, 0x3f803f802e2e7831ULL, 0x000fe4000020001eULL,
0x3f803f802d2d7831ULL, 0x000fc4000020001dULL, 0x3f803f802c2c7831ULL, 0x000fe4000020001cULL,
0x3f803f8033337831ULL, 0x000fe40000200037ULL, 0x3f803f8032327831ULL, 0x000fe20000200036ULL,
0x0000002c0e007388ULL, 0x000fe20000000c00ULL, 0x3f803f8031317831ULL, 0x000fe40000200035ULL,
0x3f803f8030307831ULL, 0x000fe40000200034ULL, 0x3f803f8017177831ULL, 0x000fc4000020003bULL,
0x3f803f8016167831ULL, 0x000fe2000020003aULL, 0x000400300e007388ULL, 0x000fe20000000c00ULL,
0x3f803f8015157831ULL, 0x000fe40000200039ULL, 0x3f803f8014147831ULL, 0x000fe40000200038ULL,
0x3f803f801b1b7831ULL, 0x000fe4000020002bULL, 0x3f803f801a1a7831ULL, 0x000fe2000020002aULL,
0x000800140e007388ULL, 0x000fe20000000c00ULL, 0x3f803f8019197831ULL, 0x000fc40000200029ULL,
0x3f803f8018187831ULL, 0x000fca0000200028ULL, 0x000c00180e007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000039b000008947ULL, 0x000fea0003800000ULL,
0x00000400ff0a7624ULL, 0x000fe200078e00ffULL, 0x00000000000f7919ULL, 0x000e620000002600ULL,
0x0000004010137810ULL, 0x000fc40007ffe0ffULL, 0x00006a000a0a7a24ULL, 0x000fe200078e02ffULL,
0x0000000000127919ULL, 0x000e620000002700ULL, 0x0000008010157810ULL, 0x000fe40007ffe0ffULL,
0x000003000a0d7a24ULL, 0x040fe200078e02ffULL, 0x0000000f0a0c7811ULL, 0x000fe200078e10ffULL,
0x000000000e1c7984ULL, 0x000ea20000000c00ULL, 0x000000c010177810ULL, 0x000fe40007ffe0ffULL,
0xfffffff00c247812ULL, 0x000fe200078ec0ffULL, 0x000400000e287984ULL, 0x000ee80000000c00ULL,
0x000000800d267824ULL, 0x040fe200078e0224ULL, 0x000800000e2c7984ULL, 0x000ea60000000c00ULL,
0x000000800d0d7824ULL, 0x000fe200078e0226ULL, 0x000c00000e307984ULL, 0x0008a80000000c00ULL,
0x0000007f0d0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000400120a7a24ULL, 0x002fc600078e020fULL,
0xffffff800d1a7812ULL, 0x000fe200078ec0ffULL, 0x000003000a0f7a24ULL, 0x000fc600078e02ffULL,
0x00006e001a0d7a10ULL, 0x000fe20007f1e0ffULL, 0x000000010f087824ULL, 0x000fca00078e0208ULL,
0x0000000d080c7211ULL, 0x000fe200078268ffULL, 0x00006f00ff0d7624ULL, 0x000fe200000e06ffULL,
0x0000000120ff7812ULL, 0x000fc8000780f802ULL, 0x0000000d080d7211ULL, 0x000fe400008f6cffULL,
0x00006e00240e7a10ULL, 0x010fc60007f3e0ffULL, 0x000010000b0c7825ULL, 0x000fc800078e000cULL,
0x00006f00ff1b7624ULL, 0x000fe400008e06ffULL, 0x0000001010107825ULL, 0x000fc800078e000cULL,
0x0000001013127825ULL, 0x000fc800078e000cULL, 0x0000001015147825ULL, 0x000fc800078e000cULL,
0x00000010170c7825ULL, 0x000fe200078e000cULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001004167824ULL, 0x00cfe200078e00ffULL, 0x00000001ff187819ULL, 0x000fe20000011604ULL,
0x0000008008177824ULL, 0x000fe200078e00ffULL, 0x00000019ff087819ULL, 0x000fe40000011608ULL,
0x0000007016197812ULL, 0x000fe400078ec0ffULL, 0x0000000c18167812ULL, 0x000fe400078ec0ffULL,
0x00006e0017187a10ULL, 0x000fc40007ebe026ULL, 0x0000000e19177210ULL, 0x000fe40007a3e017ULL,
0x0000001816187210ULL, 0x000fe40007c7e019ULL, 0x00006f0008197a10ULL, 0x000fe40002fec4ffULL,
0x0000001716167210ULL, 0x000fe40007fbe0ffULL, 0x0000001bff087210ULL, 0x000fe40000fe4408ULL,
0x00000019ff197210ULL, 0x000fc60001fe84ffULL, 0x000000ffff177224ULL, 0x000fca00028e0608ULL,
0x0000002216007986ULL, 0x0003e8000c101906ULL, 0x0000002518007986ULL, 0x0003e4000c101906ULL,
0x000000ff0400720cULL, 0x00cfe20000705670ULL, 0x0000001c10007986ULL, 0x000fe2000c101d06ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x0000002812007986ULL, 0x000fe8000c101d06ULL,
0x0000002c14007986ULL, 0x000fe8000c101d06ULL, 0x000000300c007986ULL, 0x000fe8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0xffffffff21117810ULL, 0x000fc60007ffe0ffULL,
0x00006e000a0c7625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x000000110c0c79a8ULL, 0x000ea400099ee1c6ULL, 0x000000110c00720cULL, 0x004fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000008ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff087984ULL, 0x004ea40000000000ULL,
0x000000ff0800720cULL, 0x004fda0003f05270ULL, 0x000034b000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe40000011604ULL,
0x0000000e0f0c7211ULL, 0x040fe400078038ffULL, 0x00000070080d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000001b0f087211ULL, 0x000fe400000f3cffULL,
0x0000000c0a0c7210ULL, 0x000fc8000791e00dULL, 0x00000008ff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c087981ULL, 0x000528000c1e1900ULL, 0x000080060c117981ULL, 0x000522000c1e1900ULL,
0x000000022100780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100060c137981ULL, 0x004522000c1e1900ULL, 0x000000042100780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180060c157981ULL, 0x004522000c1e1900ULL,
0x000000042100780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200060c177981ULL, 0x006322000c1e1900ULL, 0x000000062100780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280060c197981ULL, 0x002322000c1e1900ULL,
0x000000062100780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082100780cULL, 0x002fe20003f06070ULL, 0x000300060c1b7981ULL, 0x000318000c1e1900ULL,
0x000380060c1d0981ULL, 0x000324000c1e1900ULL, 0x00000007210a7810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff0a7819ULL, 0x000fc8000001160aULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x000000240f217211ULL, 0x000fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1f7224ULL, 0x010fe200078e0008ULL, 0x00006e0021217a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0f0e7211ULL, 0x000fe400000f3cffULL, 0x0000078021217810ULL, 0x000fc80007f5e0ffULL,
0x00006f00ff0e7a10ULL, 0x000fc400017e240eULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040a007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008100c7810ULL, 0x040fe40007ffe0ffULL,
0x00000001100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001f08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffc80060c1f7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001108087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffd00060c117981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000003100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffd80060c137981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001508087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffe00060c157981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000005100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001708087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffe80060c177981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xffff00060c197981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e100c7810ULL, 0x042fe40007ffe0ffULL,
0x00000007100d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xffff80060c1b7981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f100c7810ULL, 0x002fe40007ffe0ffULL,
0x0000001d08087209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011604ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c210c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0x000000060c1d7981ULL, 0x000326000c1e1900ULL,
0x0000040021217810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e060eULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x000ea40000000000ULL, 0x00000010040a7824ULL, 0x004fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x002fc80000011604ULL, 0x000000700a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c0d7812ULL, 0x000fca00078ec0ffULL, 0x000000010a0d7824ULL, 0x000fca00078e020dULL,
0x000000080d007388ULL, 0x0103e40000000800ULL, 0x000000070400780cULL, 0x000fe20003f04070ULL,
0x0000000120217824ULL, 0x000fe200078e020fULL, 0x00000002ff0a7819ULL, 0x000fe20000011602ULL,
0x000010000b087824ULL, 0x002fe200078e00ffULL, 0x00006e001a0c7a10ULL, 0x000fe20007f3e0ffULL,
0x0000001004557824ULL, 0x000fe200078e00ffULL, 0x000000010a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000220138824ULL, 0x000fe200078e020bULL,
0x0000002004157810ULL, 0x040fe20007ffe0ffULL, 0x00006f00ff0d7624ULL, 0x000fe200008e06ffULL,
0x00000001ff547819ULL, 0x000fe20000011604ULL, 0x0000000213298824ULL, 0x000fe200078e020aULL,
0x0000004004177810ULL, 0x000fe20007ffe0ffULL, 0x0000040002137824ULL, 0x000fe200078e00ffULL,
0x0000006004197810ULL, 0x040fe20007ffe0ffULL, 0x0000200021107825ULL, 0x000fe200078e000cULL,
0x00000080041b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000100013137812ULL, 0x000fe200078ec0ffULL, 0x0000400020027824ULL, 0x000fe200078e0205ULL,
0x0000000810107210ULL, 0x000fe20007f3e0ffULL, 0x0000000220258824ULL, 0x000fe200078e020bULL,
0x000000a0041d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102137824ULL, 0x000fe200078e0213ULL,
0x0000007055557812ULL, 0x000fe200078ec0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000000c54547812ULL, 0x000fe200078ec0ffULL, 0x0000001004277824ULL, 0x040fe200078e0213ULL,
0x000000c0041f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001015127825ULL, 0x100fe200078e0010ULL,
0x000000e004237810ULL, 0x000fe20007ffe0ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00006e00260e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000001017147825ULL, 0x100fe200078e0010ULL,
0x00006e0024517a10ULL, 0x000fe20007f5e0ffULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000001019167825ULL, 0x100fe200078e0010ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000000101b187825ULL, 0x000fe200078e0010ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000225258824ULL, 0x000fe200078e020aULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000101d1a7825ULL, 0x000fe200078e0010ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x00000001550a7824ULL, 0x000fe200078e0254ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000101f1c7825ULL, 0x100fe200078e0010ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000010231e7825ULL, 0x100fe200078e0010ULL,
0x000000000a0a7984ULL, 0x000e620000000800ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x000000ff00567202ULL, 0x000fe20000000f00ULL, 0x0000001004107825ULL, 0x000fc800078e0010ULL,
0x00006f00ff527624ULL, 0x000fe200008e06ffULL, 0x0000000e21228211ULL, 0x040fe200078238ffULL,
0x00006f00ff537624ULL, 0x000fe200010e06ffULL, 0x0000005121248211ULL, 0x040fe200078438ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000010277faeULL, 0x0005e2000b901c46ULL,
0x0000005221238211ULL, 0x000fe200008f3cffULL, 0x0000000829298824ULL, 0x000fe200078e0204ULL,
0x0000030020007a0cULL, 0x000fe20003f26070ULL, 0x0038000012277faeULL, 0x0007e2000b901c46ULL,
0x000000ffff507224ULL, 0x000fc600078e00ffULL, 0x0058000014277faeULL, 0x0009e2000b901c46ULL,
0x0000000825108824ULL, 0x004fe200078e0204ULL, 0x0000005321258211ULL, 0x000fe400010f3cffULL,
0x0078000016277faeULL, 0x0005e2000b901c46ULL, 0x0000000000127805ULL, 0x008fe2000001ff00ULL,
0x0000858010218811ULL, 0x000fe400078e20ffULL, 0x0098000018277faeULL, 0x0007e2000b901c46ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000001004148825ULL, 0x010fc400078e0022ULL,
0x00b800001a277faeULL, 0x0009e2000b901c46ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000001004168825ULL, 0x004fe400078e0024ULL, 0x00d800001c277faeULL, 0x0005e2000b901c46ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000818029198811ULL, 0x008fe400078e20ffULL,
0x00f800001e277faeULL, 0x0007e2000b901c46ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x010fc4000001ff00ULL, 0x0000000014218faeULL, 0x0009e8000b901c46ULL,
0x0000000016198faeULL, 0x0003e2000b901c46ULL, 0x00000000001c7805ULL, 0x004fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x010fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000000000167805ULL, 0x002fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000131000001947ULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe400078e00ffULL, 0x000000ffff577224ULL, 0x000fca00078e0020ULL,
0x0000000257587810ULL, 0x000fc80007ffe0ffULL, 0x0000030058007a0cULL, 0x000fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x00000001ff597819ULL, 0x100fe20000011658ULL,
0x000000010f6b7824ULL, 0x000fe200078e0258ULL, 0x000000070400780cULL, 0x040fe40003f44070ULL,
0x00000001595a7812ULL, 0x000fe200078ec0ffULL, 0x000020006b547825ULL, 0x000fe200078e000cULL,
0x00000020045d7810ULL, 0x040fe40007ffe0ffULL, 0x00000040045f7810ULL, 0x000fe20007ffe0ffULL,
0x0000080058597824ULL, 0x000fe200078e00ffULL, 0x0000000854547210ULL, 0x000fc40007f1e0ffULL,
0x0000006004617810ULL, 0x000fe40007ffe0ffULL, 0x0000100059597812ULL, 0x000fe200078ec0ffULL,
0x00000002206da824ULL, 0x100fe200078e020bULL, 0x0000008004637810ULL, 0x000fe20007ffe0ffULL,
0x00000002205ba824ULL, 0x000fe200078e020bULL, 0x000000a004657810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff557224ULL, 0x000fe200000e0655ULL, 0x000000c004677810ULL, 0x000fe20007ffe0ffULL,
0x0000000102597824ULL, 0x000fe200078e0259ULL, 0x000000e004697810ULL, 0x040fe20007ffe0ffULL,
0x000000026d6da824ULL, 0x100fe200078e025aULL, 0x0000000e6b68a211ULL, 0x000fe200078038ffULL,
0x000000025b6fa824ULL, 0x000fe200078e025aULL, 0x000000516b6aa211ULL, 0x000fe200078238ffULL,
0x0000001004597824ULL, 0x000fc400078e0259ULL, 0x00000010045a7825ULL, 0x000fc800078e0054ULL,
0x000000105d5c7825ULL, 0x100fe200078e0054ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800005a597faeULL, 0x0003e6000b901c46ULL, 0x000000105f5e7825ULL, 0x100fe200078e0054ULL,
0x003800005c597faeULL, 0x0005e6000b901c46ULL, 0x0000001061607825ULL, 0x100fe200078e0054ULL,
0x005800005e597faeULL, 0x0007e6000b901c46ULL, 0x0000001063627825ULL, 0x100fe200078e0054ULL,
0x0078000060597faeULL, 0x0007e6000b901c46ULL, 0x0000001065647825ULL, 0x100fe200078e0054ULL,
0x0098000062597faeULL, 0x0007e6000b901c46ULL, 0x0000001067667825ULL, 0x100fe200078e0054ULL,
0x00b8000064597faeULL, 0x0007e6000b901c46ULL, 0x0000001069547825ULL, 0x000fe200078e0054ULL,
0x000000526b69a211ULL, 0x040fe200000f3cffULL, 0x00d8000066597faeULL, 0x0007e2000b901c46ULL,
0x000000536b6ba211ULL, 0x000fe200008f3cffULL, 0x000000086d6da824ULL, 0x000fc400078e0204ULL,
0x000000086f6fa824ULL, 0x000fe200078e0204ULL, 0x00f8000054597faeULL, 0x0007e2000b901c46ULL,
0x000000100468a825ULL, 0x040fe200078e0068ULL, 0x000085806d6da811ULL, 0x000fe400078e20ffULL,
0x000081806f5da811ULL, 0x004fe200078e20ffULL, 0x00000010045aa825ULL, 0x002fe400078e006aULL,
0x00000000686dafaeULL, 0x0007e8000b901c46ULL, 0x000000005a5dafaeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff5a7224ULL, 0x008fe200078e0057ULL,
0x00000001ff597819ULL, 0x100fe20000011604ULL, 0x0000000220577824ULL, 0x000fe200078e020bULL,
0x00000002ff647819ULL, 0x000fe20000011604ULL, 0x000000405a547824ULL, 0x000fc400078e00ffULL,
0x0000001004557824ULL, 0x000fe200078e00ffULL, 0x00000002645c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000864627824ULL, 0x000fe200078e00ffULL, 0x0000008054547812ULL, 0x000fe200078ec0ffULL,
0x00000008645f7824ULL, 0x040fe200078e00ffULL, 0x0000007055557812ULL, 0x000fe200078ec0ffULL,
0x0000000864687824ULL, 0x040fe200078e00ffULL, 0x00000003645d7810ULL, 0x040fe20007ffe0ffULL,
0x0000010057577824ULL, 0x000fe200078e0054ULL, 0x0000000c59547812ULL, 0x000fe200078ec0ffULL,
0x00000008646a7824ULL, 0x000fe200078e00ffULL, 0xfffffff85f667812ULL, 0x000fe200078ee25cULL,
0x00000004045c7824ULL, 0x000fe200078e00ffULL, 0x0000005754597210ULL, 0x000fe20007ffe055ULL,
0x0000000864707824ULL, 0x040fe200078e00ffULL, 0x0000000164577810ULL, 0x040fe20007ffe0ffULL,
0x00000008646e7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00818000595b7984ULL, 0x000e620000000800ULL, 0xfffffff862627812ULL, 0x000fe200078ee257ULL,
0x000008005a577824ULL, 0x000fe200078e00ffULL, 0xfffffff868687812ULL, 0x000fe200078ee25dULL,
0x0085800059607984ULL, 0x0004e20000000800ULL, 0x0000000864727810ULL, 0x040fe20007ffe0ffULL,
0x00000008645d7824ULL, 0x000fe200078e00ffULL, 0x0000100057577812ULL, 0x000fe400078ec0ffULL,
0x0000000c5c6f7812ULL, 0x000fe400078ec0ffULL, 0xfffffff85d5c7812ULL, 0x000fe200078ee264ULL,
0x0000000872597824ULL, 0x004fe200078e00ffULL, 0x0000018002577810ULL, 0x000fc40007ffe057ULL,
0x0000001064747810ULL, 0x040fe40007ffe0ffULL, 0x0000001864767810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8595a7812ULL, 0x000fe200078ee272ULL, 0x000000105c597824ULL, 0x000fe200078e0257ULL,
0x00000004645f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000874637824ULL, 0x000fe200078e00ffULL,
0x0000000564617810ULL, 0x000fe20007ffe0ffULL, 0x0000000876657824ULL, 0x000fe200078e00ffULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee25fULL, 0x000000016f597824ULL, 0x000fe200078e0259ULL,
0xfffffff8635c7812ULL, 0x000fe200078ee274ULL, 0x000000105a5a7824ULL, 0x000fe200078e0257ULL,
0xfffffff8655e7812ULL, 0x000fc400078ee276ULL, 0x0000000059657984ULL, 0x0005220000000800ULL,
0x000000105c5c7824ULL, 0x100fe200078e0257ULL, 0x00000006645f7810ULL, 0x000fe20007ffe0ffULL,
0x000000105e5e7824ULL, 0x000fe200078e0257ULL, 0xfffffff86e6e7812ULL, 0x000fe200078ee261ULL,
0x000000016f5c7824ULL, 0x040fe200078e025cULL, 0xfffffff870707812ULL, 0x000fe200078ee25fULL,
0x000000016f5e7824ULL, 0x000fe400078e025eULL, 0x0000005b0a5b7221ULL, 0x002fe20000010100ULL,
0x000000005c6c7984ULL, 0x0003e20000000800ULL, 0x0000001066597824ULL, 0x004fc400078e0257ULL,
0x3fb8aa3b5b5d7820ULL, 0x000fe20000410000ULL, 0x000000005e6d7984ULL, 0x0005e20000000800ULL,
0x000000016f5b7824ULL, 0x040fe400078e025aULL, 0x00000010625a7824ULL, 0x000fe400078e0257ULL,
0x0000005d005d7308ULL, 0x000ee20000000800ULL, 0x000000005b6b7984ULL, 0x0005e20000000800ULL,
0x000000016f5a7824ULL, 0x040fe400078e025aULL, 0x000000016f597824ULL, 0x000fc400078e0259ULL,
0x000000106a5c7824ULL, 0x102fe200078e0257ULL, 0x000000005a667984ULL, 0x000fe20000000800ULL,
0x00000010705e7824ULL, 0x104fe400078e0257ULL, 0x00000010685b7824ULL, 0x000fe200078e0257ULL,
0x0000000059677984ULL, 0x000fe20000000800ULL, 0x000000016f5c7824ULL, 0x040fe400078e025cULL,
0x000000016f5b7824ULL, 0x000fe400078e025bULL, 0x000000605d5f7220ULL, 0x008fe20000410000ULL,
0xffffffff645d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000864607824ULL, 0x000fe200078e00ffULL,
0x000000005b687984ULL, 0x000fe20000000800ULL, 0x000000565f567221ULL, 0x000fc40000010000ULL,
0x000000016f5e7824ULL, 0x040fe200078e025eULL, 0x00001f645f617589ULL, 0x000e6200000e0000ULL,
0xfffffff860607812ULL, 0x000fe200078ee25dULL, 0x000000106e5d7824ULL, 0x000fe400078e0257ULL,
0x00001f725f627589ULL, 0x000ea400000e0000ULL, 0x000000016f5d7824ULL, 0x000fe400078e025dULL,
0x00001f745f637589ULL, 0x000ee200000e0000ULL, 0x0000001060577824ULL, 0x000fe200078e0257ULL,
0x00007610ff607816ULL, 0x010fc40000000065ULL, 0x00001f765f647589ULL, 0x0008e200000e0000ULL,
0x000000016f577824ULL, 0x000fc600078e0257ULL, 0x000000005c697984ULL, 0x000fe80000000800ULL,
0x000000005d6a7984ULL, 0x000ee20000000800ULL, 0x00005410ff5f7816ULL, 0x010fe20000000065ULL,
0x00000061604f7223ULL, 0x082fe2000001004fULL, 0x00005410ff607816ULL, 0x100fe2000000006bULL,
0x000000005e657984ULL, 0x000fe40000000800ULL, 0x000000615f507223ULL, 0x000fe20000010050ULL,
0x00007610ff5f7816ULL, 0x000fe2000000006bULL, 0x0000006260197223ULL, 0x084fe20000010019ULL,
0x00005410ff607816ULL, 0x000fe2000000006cULL, 0x00000000576b7984ULL, 0x000e640000000800ULL,
0x000000625f467223ULL, 0x000fe20000010046ULL, 0x00007610ff5f7816ULL, 0x000fe2000000006cULL,
0x0000006360257223ULL, 0x088fe20000010025ULL, 0x00005410ff607816ULL, 0x100fe2000000006dULL,
0x000400005a6c7984ULL, 0x000ea40000000800ULL, 0x000000635f3e7223ULL, 0x000fe2000001003eULL,
0x00007610ff5f7816ULL, 0x000fe2000000006dULL, 0x0000006460237223ULL, 0x080fe20000010023ULL,
0x00007610ff607816ULL, 0x000fe20000000066ULL, 0x00040000596d7984ULL, 0x000ee40000000800ULL,
0x000000645f367223ULL, 0x000fe20000010036ULL, 0x00005410ff5f7816ULL, 0x000fe20000000066ULL,
0x00000061604d7223ULL, 0x080fe2000001004dULL, 0x00007610ff607816ULL, 0x100fe20000000067ULL,
0x000400005b667984ULL, 0x000f240000000800ULL, 0x000000615f4e7223ULL, 0x000fe2000001004eULL,
0x00005410ff5f7816ULL, 0x000fc40000000067ULL, 0x000400005c677984ULL, 0x000ee20000000800ULL,
0x00000061604b7223ULL, 0x080fe2000001004bULL, 0x00007610ff607816ULL, 0x000fe20000000068ULL,
0x000000615f4c7223ULL, 0x080fe2000001004cULL, 0x00005410ff5f7816ULL, 0x000fe40000000068ULL,
0x000400005d687984ULL, 0x000f220000000800ULL, 0x0000006160497223ULL, 0x080fe20000010049ULL,
0x00005410ff607816ULL, 0x000fe2000000006aULL, 0x000000615f4a7223ULL, 0x000fe2000001004aULL,
0x00005410ff5f7816ULL, 0x000fc60000000069ULL, 0x00000061602f7223ULL, 0x080fe2000001002fULL,
0x00007610ff607816ULL, 0x000fe2000000006aULL, 0x000000615f307223ULL, 0x080fe20000010030ULL,
0x00007610ff5f7816ULL, 0x000fe20000000069ULL, 0x00040000576a7984ULL, 0x000fe40000000800ULL,
0x00000061601b7223ULL, 0x080fe2000001001bULL, 0x00005410ff607816ULL, 0x002fe2000000006bULL,
0x000400005e697984ULL, 0x000e620000000800ULL, 0x000000615f127223ULL, 0x000fe20000010012ULL,
0x00005410ff5f7816ULL, 0x000fc40000000065ULL, 0x00000061602d7223ULL, 0x080fe2000001002dULL,
0x00007610ff607816ULL, 0x000fe4000000006bULL, 0x000000615f2e7223ULL, 0x080fe2000001002eULL,
0x00007610ff5f7816ULL, 0x000fe20000000065ULL, 0x000c00005a6b7984ULL, 0x000fe20000000800ULL,
0x0000006160477223ULL, 0x000fc60000010047ULL, 0x000800005a657984ULL, 0x0006620000000800ULL,
0x000000615f487223ULL, 0x000fe20000010048ULL, 0x00005410ff5f7816ULL, 0x004fe4000000006cULL,
0x0008000059607984ULL, 0x000ea60000000800ULL, 0x000000625f2c7223ULL, 0x000fe2000001002cULL,
0x00007610ff5a7816ULL, 0x008fe2000000006cULL, 0x000800005c617984ULL, 0x000fe20000000800ULL,
0x00007610ff5f7816ULL, 0x000fc6000000006dULL, 0x000000625a457223ULL, 0x080fe20000010045ULL,
0x00005410ff5a7816ULL, 0x000fe2000000006dULL, 0x000c0000596c7984ULL, 0x0007e20000000800ULL,
0x000000625f447223ULL, 0x080fe20000010044ULL, 0x00005410ff5f7816ULL, 0x110fe40000000066ULL,
0x000000625a2b7223ULL, 0x080fe2000001002bULL, 0x00007610ff5a7816ULL, 0x000fe40000000066ULL,
0x000000625f2a7223ULL, 0x080fe2000001002aULL, 0x00007610ff597816ULL, 0x008fe20000000067ULL,
0x000800005b5f7984ULL, 0x000ee20000000800ULL, 0x000000625a437223ULL, 0x000fe20000010043ULL,
0x00005410ff5a7816ULL, 0x000fc40000000067ULL, 0x0000006259427223ULL, 0x080fe20000010042ULL,
0x00005410ff597816ULL, 0x100fe20000000068ULL, 0x000c00005c677984ULL, 0x000fe20000000800ULL,
0x000000625a297223ULL, 0x080fe20000010029ULL, 0x00007610ff5a7816ULL, 0x000fe40000000068ULL,
0x0000006259287223ULL, 0x080fe20000010028ULL, 0x00007610ff597816ULL, 0x002fe20000000069ULL,
0x000c00005b667984ULL, 0x000e620000000800ULL, 0x000000625a417223ULL, 0x000fe20000010041ULL,
0x00005410ff5a7816ULL, 0x000fc40000000069ULL, 0x0000006259407223ULL, 0x080fe20000010040ULL,
0x00005410ff597816ULL, 0x100fe2000000006aULL, 0x000800005d5b7984ULL, 0x000f220000000800ULL,
0x000000625a277223ULL, 0x080fe20000010027ULL, 0x00007610ff5a7816ULL, 0x000fe4000000006aULL,
0x0000006259267223ULL, 0x080fe20000010026ULL, 0x00005410ff597816ULL, 0x000fe20000000065ULL,
0x000800005e5c7984ULL, 0x000fe20000000800ULL, 0x000000625a3f7223ULL, 0x000fe2000001003fULL,
0x00007610ff5a7816ULL, 0x000fc40000000065ULL, 0x0000006359247223ULL, 0x080fe20000010024ULL,
0x00005410ff597816ULL, 0x000fe2000000006bULL, 0x000c00005d627984ULL, 0x000fe20000000800ULL,
0x000000635a3d7223ULL, 0x000fe2000001003dULL, 0x00007610ff5a7816ULL, 0x000fe4000000006bULL,
0x00000064591a7223ULL, 0x080fe2000001001aULL, 0x00005410ff597816ULL, 0x004fe20000000060ULL,
0x00080000575d7984ULL, 0x000ea20000000800ULL, 0x000000645a357223ULL, 0x000fc60000010035ULL,
0x0000006359227223ULL, 0x000fe20000010022ULL, 0x00007610ff597816ULL, 0x000fe20000000060ULL,
0x000c00005e657984ULL, 0x000fe20000000800ULL, 0x00005410ff5a7816ULL, 0x008fc6000000005fULL,
0x000c000057607984ULL, 0x0006a20000000800ULL, 0x00000063593c7223ULL, 0x080fe2000001003cULL,
0x00005410ff597816ULL, 0x000fe2000000006cULL, 0x000000635a217223ULL, 0x000fe20000010021ULL,
0x00007610ff5a7816ULL, 0x000fc6000000005fULL, 0x0000006459187223ULL, 0x000fe20000010018ULL,
0x00007610ff577816ULL, 0x008fe2000000006cULL, 0x000000635a3b7223ULL, 0x000fe2000001003bULL,
0x00005410ff5a7816ULL, 0x002fc60000000066ULL, 0x0000006457347223ULL, 0x080fe20000010034ULL,
0x00007610ff577816ULL, 0x000fe20000000061ULL, 0x000000645a177223ULL, 0x000fe20000010017ULL,
0x00007610ff5a7816ULL, 0x000fc60000000066ULL, 0x00000063573a7223ULL, 0x000fe2000001003aULL,
0x00005410ff577816ULL, 0x000fe20000000067ULL, 0x000000645a337223ULL, 0x000fe20000010033ULL,
0x00005410ff5a7816ULL, 0x000fc60000000061ULL, 0x0000006457167223ULL, 0x080fe20000010016ULL,
0x00007610ff577816ULL, 0x000fe20000000067ULL, 0x000000635a1f7223ULL, 0x080fe2000001001fULL,
0x00007610ff5a7816ULL, 0x010fe4000000005bULL, 0x00005410ff597816ULL, 0x004fe2000000005dULL,
0x0000006457327223ULL, 0x000fe20000010032ULL, 0x00005410ff577816ULL, 0x000fe2000000005bULL,
0x000000635a397223ULL, 0x080fe20000010039ULL, 0x00005410ff5a7816ULL, 0x000fe20000000062ULL,
0x00000063591c7223ULL, 0x000fc4000001001cULL, 0x00000063571e7223ULL, 0x080fe2000001001eULL,
0x00007610ff577816ULL, 0x000fe20000000062ULL, 0x000000645a157223ULL, 0x080fe20000010015ULL,
0x00005410ff5a7816ULL, 0x000fe4000000005cULL, 0x00007610ff597816ULL, 0x000fe20000000060ULL,
0x0000006457147223ULL, 0x080fe20000010014ULL, 0x00007610ff577816ULL, 0x000fe2000000005cULL,
0x000000635a1d7223ULL, 0x000fe2000001001dULL, 0x00005410ff5a7816ULL, 0x000fe20000000065ULL,
0x0000006459107223ULL, 0x000fc40000010010ULL, 0x0000006357387223ULL, 0x000fe40000010038ULL,
0x000000ffff577224ULL, 0x000fe200078e0058ULL, 0x00007610ff587816ULL, 0x000fe20000000065ULL,
0x000000645a117223ULL, 0x000fc60000010011ULL, 0x0000030057007a0cULL, 0x000fe20003f06070ULL,
0x0000006458317223ULL, 0x000fe20000010031ULL, 0x00007610ff587816ULL, 0x000fca000000005dULL,
0x0000006358377223ULL, 0x000fe20000010037ULL, 0x00005410ff587816ULL, 0x000fca0000000060ULL,
0x0000006458137223ULL, 0x000fe20000010013ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffed1000007947ULL, 0x000fea000383ffffULL, 0x000000ff0b00720cULL, 0x000fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x00000080200d8824ULL, 0x000fc800078e0255ULL,
0x00000001540d8824ULL, 0x000fe400078e020dULL, 0x0000000155547824ULL, 0x000fc600078e0254ULL,
0x008980560d008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0089800054027984ULL, 0x000e680000000800ULL, 0x008a0000540f7984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000f02027221ULL, 0x004fca0000010000ULL,
0x0180000002047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0002ULL,
0x0000d5a0000c7802ULL, 0x000fc40000000f00ULL, 0x0000dbb000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x00cfe200078e0004ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x00000002000d7308ULL, 0x000e640000001000ULL, 0xbf80000002047423ULL, 0x002fc8000000000dULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x000000040d087223ULL, 0x000fc4000000000dULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff517819ULL, 0x004fc40000011604ULL,
0x0000001004557811ULL, 0x040fe400078ff0ffULL, 0x0000000804537811ULL, 0x040fe200078ff0ffULL,
0x00001f5108027589ULL, 0x000ea200000e0000ULL, 0x0000001804577811ULL, 0x000fe200078ff0ffULL,
0x00000008515d7824ULL, 0x040fe200078e00ffULL, 0x0000000351527810ULL, 0x040fe20007ffe0ffULL,
0x00001f55080e7589ULL, 0x000ee200000e0000ULL, 0x0000000851597824ULL, 0x040fe400078e00ffULL,
0x00000008515b7824ULL, 0x040fe200078e00ffULL, 0x00001f53080c7589ULL, 0x000f2200000e0000ULL,
0x0000000851617824ULL, 0x000fc600078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fca00078ee252ULL,
0x000000105b5b7824ULL, 0x000fe400078e0206ULL, 0x00000012020d7220ULL, 0x044fe40000410000ULL,
0x00001f5708127589ULL, 0x00046200000e0000ULL, 0x0000005002507220ULL, 0x040fe40000410000ULL,
0x0000004f024f7220ULL, 0x040fe40000410000ULL, 0x0000004e024e7220ULL, 0x040fe40000410000ULL,
0x0000004d024d7220ULL, 0x040fe20000410000ULL, 0x000000504f4f723eULL, 0x000fe200000010ffULL,
0x0000004c024c7220ULL, 0x000fc40000410000ULL, 0x0000004b024b7220ULL, 0x040fe20000410000ULL,
0x0000004e4d4d723eULL, 0x000fe200000010ffULL, 0x0000004a024a7220ULL, 0x040fe40000410000ULL,
0x0000004902497220ULL, 0x040fe20000410000ULL, 0x0000004c4b4b723eULL, 0x000fe200000010ffULL,
0x0000003002307220ULL, 0x040fe40000410000ULL, 0x0000002f022f7220ULL, 0x040fe20000410000ULL,
0x0000004a4949723eULL, 0x000fe200000010ffULL, 0x0000001b020a7220ULL, 0x042fe20000410000ULL,
0x000000300d0d723eULL, 0x000fe200000010ffULL, 0x0000002e022e7220ULL, 0x000fc40000410000ULL,
0x00000048020f7220ULL, 0x040fe20000410000ULL, 0x0000000251487810ULL, 0x000fe20007ffe0ffULL,
0x0000002d022d7220ULL, 0x000fe20000410000ULL, 0x0000002f0a0a723eULL, 0x000fe200000010ffULL,
0x0000004702027220ULL, 0x000fe20000410000ULL, 0xfffffff859597812ULL, 0x000fe200078ee248ULL,
0x0000003c0e1b7220ULL, 0x008fe20000410000ULL, 0x00000001513c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000851477824ULL, 0x000fe200078e00ffULL, 0x0000002e0f0f723eULL, 0x000fe200000010ffULL,
0x000000190c197220ULL, 0x010fe20000410000ULL, 0x0000002d0202723eULL, 0x000fe200000010ffULL,
0x000000460c467220ULL, 0x040fe20000410000ULL, 0xfffffff847477812ULL, 0x000fe200078ee23cULL,
0x0000002c0c2c7220ULL, 0x000fc40000410000ULL, 0x000000450c457220ULL, 0x000fe20000410000ULL,
0x000000194619723eULL, 0x000fe200000010ffULL, 0x0000002b0c2b7220ULL, 0x040fe40000410000ULL,
0x000000440c447220ULL, 0x040fe20000410000ULL, 0x0000002c452c723eULL, 0x000fe200000010ffULL,
0x0000002a0c2a7220ULL, 0x040fe40000410000ULL, 0x000000430c437220ULL, 0x000fe20000410000ULL,
0x0000002b442b723eULL, 0x000fe200000010ffULL, 0x000000290c297220ULL, 0x000fc40000410000ULL,
0x000000420c427220ULL, 0x040fe20000410000ULL, 0x0000002a432a723eULL, 0x000fe200000010ffULL,
0x000000280c287220ULL, 0x040fe40000410000ULL, 0x000000410c417220ULL, 0x000fe20000410000ULL,
0x000000294229723eULL, 0x000fe200000010ffULL, 0x000000270c277220ULL, 0x040fe40000410000ULL,
0x000000400c407220ULL, 0x040fe20000410000ULL, 0x000000284128723eULL, 0x000fe200000010ffULL,
0x000000260c267220ULL, 0x000fc40000410000ULL, 0x0000003f0c3f7220ULL, 0x000fe20000410000ULL,
0x000000274027723eULL, 0x000fe200000010ffULL, 0x000000250e257220ULL, 0x040fe40000410000ULL,
0x0000003e0e3e7220ULL, 0x040fe20000410000ULL, 0x000000263f26723eULL, 0x000fe200000010ffULL,
0x000000240e247220ULL, 0x040fe40000410000ULL, 0x0000003d0e3d7220ULL, 0x000fe20000410000ULL,
0x000000253e25723eULL, 0x000fe200000010ffULL, 0x000000220e227220ULL, 0x000fc40000410000ULL,
0x000000210e217220ULL, 0x040fe20000410000ULL, 0x000000243d24723eULL, 0x000fe200000010ffULL,
0x0000003b0e087220ULL, 0x044fe20000410000ULL, 0x000000221b1b723eULL, 0x000fe200000010ffULL,
0x0000001f0e1f7220ULL, 0x040fe40000410000ULL, 0x0000003a0e3a7220ULL, 0x000fe20000410000ULL,
0x000000210808723eULL, 0x000fe200000010ffULL, 0x0000001e0e1e7220ULL, 0x040fe40000410000ULL,
0x000000390e397220ULL, 0x000fe20000410000ULL, 0x0000001f3a1f723eULL, 0x000fe200000010ffULL,
0x0000001d0e1d7220ULL, 0x000fc40000410000ULL, 0x000000380e387220ULL, 0x040fe20000410000ULL,
0x0000001e391e723eULL, 0x000fe200000010ffULL, 0x0000001c0e1c7220ULL, 0x040fe40000410000ULL,
0x000000370e377220ULL, 0x000fe20000410000ULL, 0x0000001d381d723eULL, 0x000fe200000010ffULL,
0x00000033120c7220ULL, 0x040fe40000410000ULL, 0x0000002312237220ULL, 0x040fe20000410000ULL,
0x0000001c371c723eULL, 0x000fe200000010ffULL, 0x0000003612367220ULL, 0x000fc40000410000ULL,
0x0000001a121a7220ULL, 0x040fe40000410000ULL, 0x0000003512357220ULL, 0x000fe20000410000ULL,
0x000000233623723eULL, 0x000fe200000010ffULL, 0x0000001812187220ULL, 0x040fe40000410000ULL,
0x00000034123b7220ULL, 0x040fe20000410000ULL, 0x0000001a351a723eULL, 0x000fe200000010ffULL,
0x0000001712177220ULL, 0x040fe40000410000ULL, 0x0000001612167220ULL, 0x040fe20000410000ULL,
0x000000183b18723eULL, 0x000fe200000010ffULL, 0x0000003212337220ULL, 0x040fe20000410000ULL,
0x0000000651327810ULL, 0x000fe20007ffe0ffULL, 0x0000001512157220ULL, 0x000fe20000410000ULL,
0x000000170c0c723eULL, 0x000fe200000010ffULL, 0x0000001412147220ULL, 0x040fe20000410000ULL,
0xfffffff861617812ULL, 0x000fe200078ee232ULL, 0x0000001112117220ULL, 0x040fe20000410000ULL,
0x000000163316723eULL, 0x000fe200000010ffULL, 0x00000031120e7220ULL, 0x040fe20000410000ULL,
0x0000000551317810ULL, 0x040fe20007ffe0ffULL, 0x0000001312137220ULL, 0x000fe20000410000ULL,
0x000000151414723eULL, 0x000fe200000010ffULL, 0x0000001012107220ULL, 0x000fe20000410000ULL,
0x0000000451127810ULL, 0x040fe20007ffe0ffULL, 0x00000008513c7824ULL, 0x040fe200078e00ffULL,
0x000000110e0e723eULL, 0x000fe200000010ffULL, 0x0000000851347824ULL, 0x000fe200078e00ffULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee212ULL, 0x0000000853327824ULL, 0x000fe200078e00ffULL,
0xfffffff83c5f7812ULL, 0x000fe200078ee231ULL, 0x00000008573c7824ULL, 0x000fe200078e00ffULL,
0xffffffff51127810ULL, 0x000fe20007ffe0ffULL, 0x0000001047477824ULL, 0x100fe200078e0206ULL,
0xfffffff834317812ULL, 0x000fe200078ee251ULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0xfffffff832537812ULL, 0x000fe200078ee253ULL, 0x0000000855347824ULL, 0x000fe200078e00ffULL,
0xfffffff83c577812ULL, 0x000fe200078ee257ULL, 0x0000001031317824ULL, 0x000fe200078e0206ULL,
0xfffffff851517812ULL, 0x000fe200078ee212ULL, 0x0000000404127824ULL, 0x000fe200078e00ffULL,
0xfffffff834557812ULL, 0x000fe200078ee255ULL, 0x0000001059597824ULL, 0x100fe200078e0206ULL,
0x000000131010723eULL, 0x000fe200000010ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0206ULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x000000105f5f7824ULL, 0x000fc400078e0206ULL,
0x0000001061617824ULL, 0x100fe400078e0206ULL, 0x0000001051517824ULL, 0x100fe400078e0206ULL,
0x0000001053537824ULL, 0x100fe400078e0206ULL, 0x0000001055557824ULL, 0x100fe400078e0206ULL,
0x0000001057577824ULL, 0x000fe400078e0206ULL, 0x0000000131067824ULL, 0x000fc400078e0212ULL,
0x0000000112477824ULL, 0x040fe400078e0247ULL, 0x0000000112227824ULL, 0x040fe200078e0259ULL,
0x0000004f06007388ULL, 0x000fe20000000800ULL, 0x00000001125b7824ULL, 0x040fe400078e025bULL,
0x0000000112307824ULL, 0x040fe200078e025dULL, 0x0000004d47007388ULL, 0x000fe20000000800ULL,
0x00000001125f7824ULL, 0x040fe400078e025fULL, 0x0000000112387824ULL, 0x040fe200078e0261ULL,
0x0000004b22007388ULL, 0x000fe20000000800ULL, 0x0000000112517824ULL, 0x000fc400078e0251ULL,
0x00000001122e7824ULL, 0x040fe200078e0253ULL, 0x000000495b007388ULL, 0x000fe20000000800ULL,
0x0000000112327824ULL, 0x040fe400078e0255ULL, 0x0000000112127824ULL, 0x000fe200078e0257ULL,
0x0000000d30007388ULL, 0x000fe80000000800ULL, 0x0000000a5f007388ULL, 0x0003e80000000800ULL,
0x0000000f38007388ULL, 0x000fe80000000800ULL, 0x0000000251007388ULL, 0x0005e20000000800ULL,
0x00000007070a723eULL, 0x002fc600000010ffULL, 0x000000192e007388ULL, 0x000fe80000000800ULL,
0x0004002c47007388ULL, 0x000fe20000000800ULL, 0x0000000109027824ULL, 0x004fc600078e0204ULL,
0x0004002b22007388ULL, 0x000fe20000000800ULL, 0x0000001002027824ULL, 0x000fc600078e0205ULL,
0x0004002a5b007388ULL, 0x000fe80000000800ULL, 0x0004002930007388ULL, 0x000fe80000000800ULL,
0x000400285f007388ULL, 0x000fe80000000800ULL, 0x0004002738007388ULL, 0x000fe80000000800ULL,
0x0004002651007388ULL, 0x000fe80000000800ULL, 0x0000002532007388ULL, 0x000fe80000000800ULL,
0x0008002447007388ULL, 0x000fe80000000800ULL, 0x0008001b22007388ULL, 0x000fe80000000800ULL,
0x000800085b007388ULL, 0x000fe80000000800ULL, 0x0008001f30007388ULL, 0x000fe80000000800ULL,
0x0008001e5f007388ULL, 0x000fe80000000800ULL, 0x0008001d38007388ULL, 0x000fe80000000800ULL,
0x0008001c51007388ULL, 0x000fe80000000800ULL, 0x0000002312007388ULL, 0x000fe80000000800ULL,
0x000c001a47007388ULL, 0x000fe80000000800ULL, 0x000c001822007388ULL, 0x000fe80000000800ULL,
0x000c000c5b007388ULL, 0x000fe80000000800ULL, 0x000c001630007388ULL, 0x000fe80000000800ULL,
0x000c00145f007388ULL, 0x000fe80000000800ULL, 0x000c000e38007388ULL, 0x000fe80000000800ULL,
0x000c001051007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000021c7984ULL, 0x000e680000000c00ULL, 0x0004000002187984ULL, 0x000ea80000000c00ULL,
0x00080000022c7984ULL, 0x000ee80000000c00ULL, 0x000c000002147984ULL, 0x000f280000000c00ULL,
0x0010000002247984ULL, 0x000ee80000000c00ULL, 0x0014000002287984ULL, 0x000f280000000c00ULL,
0x0018000002307984ULL, 0x000f280000000c00ULL, 0x001c000002347984ULL, 0x000f220000000c00ULL,
0x3f803f800a1f7831ULL, 0x002fc4000020001fULL, 0x3f803f800a1e7831ULL, 0x040fe4000020001eULL,
0x3f803f800a1d7831ULL, 0x040fe4000020001dULL, 0x3f803f800a1c7831ULL, 0x040fe4000020001cULL,
0x3f803f800a1b7831ULL, 0x044fe4000020001bULL, 0x3f803f800a1a7831ULL, 0x040fe4000020001aULL,
0x3f803f800a197831ULL, 0x000fc40000200019ULL, 0x3f803f800a187831ULL, 0x040fe40000200018ULL,
0x3f803f800a2f7831ULL, 0x048fe4000020002fULL, 0x3f803f800a2e7831ULL, 0x040fe4000020002eULL,
0x3f803f800a2d7831ULL, 0x040fe4000020002dULL, 0x3f803f800a2c7831ULL, 0x040fe4000020002cULL,
0x3f803f800a177831ULL, 0x010fc40000200017ULL, 0x3f803f800a167831ULL, 0x040fe40000200016ULL,
0x3f803f800a157831ULL, 0x040fe40000200015ULL, 0x3f803f800a147831ULL, 0x000fe40000200014ULL,
0x3f803f801f1f7831ULL, 0x000fe40000200027ULL, 0x3f803f801e1e7831ULL, 0x000fe40000200026ULL,
0x3f803f801d1d7831ULL, 0x000fc40000200025ULL, 0x3f803f801c1c7831ULL, 0x000fe40000200024ULL,
0x3f803f801b1b7831ULL, 0x000fe4000020002bULL, 0x3f803f801a1a7831ULL, 0x000fe2000020002aULL,
0x0000001c02007388ULL, 0x000fe20000000c00ULL, 0x3f803f8019197831ULL, 0x000fe40000200029ULL,
0x3f803f8018187831ULL, 0x000fe40000200028ULL, 0x3f803f802f2f7831ULL, 0x000fc40000200033ULL,
0x3f803f802e2e7831ULL, 0x000fe20000200032ULL, 0x0004001802007388ULL, 0x000fe20000000c00ULL,
0x3f803f802d2d7831ULL, 0x000fe40000200031ULL, 0x3f803f802c2c7831ULL, 0x000fe40000200030ULL,
0x3f803f8017177831ULL, 0x000fe40000200037ULL, 0x3f803f8016167831ULL, 0x000fe20000200036ULL,
0x0008002c02007388ULL, 0x000fe20000000c00ULL, 0x3f803f8015157831ULL, 0x000fc40000200035ULL,
0x3f803f8014147831ULL, 0x000fca0000200034ULL, 0x000c001402007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fc80000011604ULL,
0x000000810800720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000097b06ULL, 0x000ea20000209000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00005a00ff107a12ULL, 0x000fe200078e33ffULL, 0x0000000103027824ULL, 0x000fe200078e0208ULL,
0x0000002004137810ULL, 0x000fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fc600078e0204ULL,
0x0000000900097308ULL, 0x004ea40000001000ULL, 0x0ffffffe090a7810ULL, 0x004fcc0007ffe0ffULL,
0x0000000a00077305ULL, 0x0004e4000021f000ULL, 0x00000007040a7812ULL, 0x004fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x008fc800078e0a07ULL, 0x00005a000d0d7a24ULL, 0x000fc800078e02ffULL,
0x0000000d07117227ULL, 0x000fcc00078e0006ULL, 0x0000000211067227ULL, 0x000fc800078e00ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a06ULL, 0x00005a0007077a24ULL, 0x000fca00078e0202ULL,
0x00005a0007007a0cULL, 0x000fda0003f06070ULL, 0x80005a0007070a10ULL, 0x000fe40007ffe0ffULL,
0x0000000106060810ULL, 0x000fe40007ffe0ffULL, 0x00005a0007007a0cULL, 0x000fe40003f26070ULL,
0x0000000708077812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff007a0cULL, 0x000fe40003f05070ULL,
0x0ffffff807087812ULL, 0x000fca00078ef804ULL, 0x0000001008087824ULL, 0x000fe400078e0205ULL,
0x0000000106061810ULL, 0x000fc60007ffe0ffULL, 0x00000000080c7984ULL, 0x000ea20000000c00ULL,
0x0000000610077207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0200ULL, 0x00005a0009027a24ULL, 0x000fe400078e0202ULL,
0x000000080b097824ULL, 0x000fe400078e020aULL, 0x00005a0007077a24ULL, 0x000fca00078e0202ULL,
0x0000000782077210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff027224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x000fc800078240ffULL, 0x00005f0007077a11ULL, 0x000fe400008f4402ULL,
0x00000003ff027819ULL, 0x000fc60000011613ULL, 0x0000001009067825ULL, 0x000fe200078e0006ULL,
0x000000810200720cULL, 0x000fc80003f26070ULL, 0x0000000c06007986ULL, 0x0045f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103067824ULL, 0x104fe200078e0202ULL,
0x0000004004157810ULL, 0x000fe20007ffe0ffULL, 0x0000000113027824ULL, 0x000fc400078e0202ULL,
0x0000000611077227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x000000ff07097210ULL, 0x000fe40007ffe1ffULL, 0x0ffffff802027812ULL, 0x000fc600078ef813ULL,
0x00005a0009087a24ULL, 0x000fe400078e0206ULL, 0x0000001002027824ULL, 0x000fc600078e0205ULL,
0x00005a0008007a0cULL, 0x000fe40003f26070ULL, 0x00000000020c7984ULL, 0x0004e40000000c00ULL,
0x00000003ff027819ULL, 0x004fd20000011615ULL, 0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe40003f46070ULL,
0x0000000713087812ULL, 0x000fd600078ec0ffULL, 0x0000000107072810ULL, 0x000fc80007ffe0ffULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0200ULL, 0x00005a0009067a24ULL, 0x000fe400078e0206ULL,
0x000000080b097824ULL, 0x000fe400078e0208ULL, 0x00005a0007077a24ULL, 0x000fca00078e0206ULL,
0x0000000782077210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x000fc800078240ffULL, 0x00005f0007077a11ULL, 0x000fe400008f440aULL,
0x000000810200720cULL, 0x000fc60003f26070ULL, 0x0000001009067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103067824ULL, 0x104fe200078e0202ULL, 0x0000006004137810ULL, 0x000fe20007ffe0ffULL,
0x0000000115027824ULL, 0x000fe400078e0202ULL, 0x0000000611077227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc600078e0a07ULL,
0x0ffffff802027812ULL, 0x000fe200078ef815ULL, 0x00005a0009087a24ULL, 0x000fc800078e0206ULL,
0x0000001002027824ULL, 0x000fe200078e0205ULL, 0x00005a0008007a0cULL, 0x000fc80003f26070ULL,
0x00000000020c7984ULL, 0x0004e40000000c00ULL, 0x00000003ff027819ULL, 0x004fce0000011613ULL,
0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fe40003f46070ULL, 0x0000000715087812ULL, 0x000fd600078ec0ffULL,
0x0000000107072810ULL, 0x000fc80007ffe0ffULL, 0x0000000710077207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0200ULL,
0x00005a0009067a24ULL, 0x000fe400078e0206ULL, 0x000000080b097824ULL, 0x000fe400078e0208ULL,
0x00005a0007077a24ULL, 0x000fca00078e0206ULL, 0x0000000782077210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x000fc800078240ffULL,
0x00005f0007077a11ULL, 0x000fe400008f440aULL, 0x000000810200720cULL, 0x000fc60003f26070ULL,
0x0000001009067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0085ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103067824ULL, 0x104fe200078e0202ULL,
0x0000008004157810ULL, 0x000fe20007ffe0ffULL, 0x0000000113027824ULL, 0x000fe400078e0202ULL,
0x0000000611077227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc600078e0a07ULL, 0x0ffffff802027812ULL, 0x000fe200078ef813ULL,
0x00005a0009087a24ULL, 0x000fc800078e0206ULL, 0x0000001002027824ULL, 0x000fe200078e0205ULL,
0x00005a0008007a0cULL, 0x000fc80003f26070ULL, 0x00000000020c7984ULL, 0x0004e40000000c00ULL,
0x00000003ff027819ULL, 0x004fce0000011615ULL, 0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe40003f46070ULL,
0x0000000713087812ULL, 0x000fd600078ec0ffULL, 0x0000000107072810ULL, 0x000fc80007ffe0ffULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0200ULL, 0x00005a0009067a24ULL, 0x000fe400078e0206ULL,
0x000000080b097824ULL, 0x000fe400078e0208ULL, 0x00005a0007077a24ULL, 0x000fca00078e0206ULL,
0x0000000782077210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x000fc800078240ffULL, 0x00005f0007077a11ULL, 0x000fe400008f440aULL,
0x000000810200720cULL, 0x000fc60003f26070ULL, 0x0000001009067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103067824ULL, 0x104fe200078e0202ULL, 0x000000a004137810ULL, 0x000fe20007ffe0ffULL,
0x0000000115027824ULL, 0x000fe400078e0202ULL, 0x0000000611077227ULL, 0x000fc600078e00ffULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fc600078e0a07ULL,
0x0ffffff802027812ULL, 0x000fe200078ef815ULL, 0x00005a0009087a24ULL, 0x000fc800078e0206ULL,
0x0000001002027824ULL, 0x000fe200078e0205ULL, 0x00005a0008007a0cULL, 0x000fc80003f26070ULL,
0x00000000020c7984ULL, 0x0004e40000000c00ULL, 0x00000003ff027819ULL, 0x004fce0000011613ULL,
0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005a0008007a0cULL, 0x000fe40003f46070ULL, 0x0000000715087812ULL, 0x000fd600078ec0ffULL,
0x0000000107072810ULL, 0x000fc80007ffe0ffULL, 0x0000000710077207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a07ULL, 0x0000590007077a24ULL, 0x000fe400078e0200ULL,
0x00005a0009067a24ULL, 0x000fe400078e0206ULL, 0x000000080b097824ULL, 0x000fe400078e0208ULL,
0x00005a0007077a24ULL, 0x000fca00078e0206ULL, 0x0000000782077210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0007067a11ULL, 0x000fc800078240ffULL,
0x00005f0007077a11ULL, 0x000fe400008f440aULL, 0x000000810200720cULL, 0x000fc60003f26070ULL,
0x0000001009067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0085ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000103067824ULL, 0x104fe200078e0202ULL,
0x000000c004157810ULL, 0x000fe20007ffe0ffULL, 0x0000000113027824ULL, 0x000fe400078e0202ULL,
0x0000000611077227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc600078e0a07ULL, 0x0ffffff802027812ULL, 0x000fe200078ef813ULL,
0x00005a0009087a24ULL, 0x000fc800078e0206ULL, 0x0000001002027824ULL, 0x000fe200078e0205ULL,
0x00005a0008007a0cULL, 0x000fc80003f26070ULL, 0x00000000020c7984ULL, 0x0004e40000000c00ULL,
0x00000003ff027819ULL, 0x004fce0000011615ULL, 0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005a0008007a0cULL, 0x000fe40003f46070ULL,
0x0000000713087812ULL, 0x000fd600078ec0ffULL, 0x0000000107072810ULL, 0x000fc80007ffe0ffULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0200ULL, 0x00005a0009067a24ULL, 0x000fe400078e0206ULL,
0x000000080b097824ULL, 0x000fe400078e0208ULL, 0x00005a0007077a24ULL, 0x000fca00078e0206ULL,
0x0000000782077210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x000fc800078240ffULL, 0x00005f0007077a11ULL, 0x000fe400008f440aULL,
0x000000810200720cULL, 0x000fc60003f26070ULL, 0x0000001009067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000103067824ULL, 0x104fe200078e0202ULL, 0x000000e004137810ULL, 0x000fe20007ffe0ffULL,
0x0000000115027824ULL, 0x040fe200078e0202ULL, 0x0000000715047812ULL, 0x000fe200078ec0ffULL,
0x0000000611077227ULL, 0x000fc600078e00ffULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fc600078e0a07ULL, 0x0ffffff802027812ULL, 0x000fe200078ef815ULL,
0x00005a0009087a24ULL, 0x000fc800078e0206ULL, 0x0000001002027824ULL, 0x000fe200078e0205ULL,
0x00005a0008007a0cULL, 0x000fc80003f26070ULL, 0x00000000020c7984ULL, 0x0004e40000000c00ULL,
0x00000003ff027819ULL, 0x004fce0000011613ULL, 0x80005a0008081a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107071810ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0202ULL,
0x00005a0008007a0cULL, 0x000fda0003f46070ULL, 0x0000000107072810ULL, 0x000fc80007ffe0ffULL,
0x0000000710077207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a07ULL,
0x0000590007077a24ULL, 0x000fe400078e0200ULL, 0x00005a0009067a24ULL, 0x000fe400078e0206ULL,
0x000000080b097824ULL, 0x000fe400078e0204ULL, 0x00005a0007077a24ULL, 0x000fca00078e0206ULL,
0x0000000782077210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0007067a11ULL, 0x000fc800078240ffULL, 0x00005f0007077a11ULL, 0x000fe400008f4408ULL,
0x000000810200720cULL, 0x000fc60003f26070ULL, 0x0000001009067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000311087227ULL, 0x000fc800078e00ffULL, 0x000000ffff047224ULL, 0x000fe400078e0a08ULL,
0x0000000113027824ULL, 0x000fe400078e0202ULL, 0x00005a0004047a24ULL, 0x000fc600078e0203ULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x00005a0004007a0cULL, 0x000fe40003f26070ULL,
0xfffffff802027812ULL, 0x000fca00078ef813ULL, 0x0000001002057824ULL, 0x000fcc00078e0205ULL,
0x80005a0004041a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108081810ULL, 0x000fe40007ffe0ffULL,
0x00005a0004007a0cULL, 0x000fe40003f46070ULL, 0x0000000005047984ULL, 0x004eb60000000c00ULL,
0x0000000108082810ULL, 0x000fc80007ffe0ffULL, 0x0000000810097207ULL, 0x000fca0004000000ULL,
0x000000ffff027224ULL, 0x000fe400078e0a09ULL, 0x0000590009007a24ULL, 0x000fe400078e0200ULL,
0x00005a0002037a24ULL, 0x000fc800078e0203ULL, 0x00005a0000037a24ULL, 0x000fe200078e0203ULL,
0x0000000713007812ULL, 0x000fc800078ec0ffULL, 0x0000000382037210ULL, 0x000fe20007f1e0ffULL,
0x000000080b0b7824ULL, 0x000fc800078e0200ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4408ULL,
0x000000100b027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x004fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000001040e7810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff9c7624ULL, 0x000fe200078e00ffULL,
0x01e60000ff0a7f8cULL, 0x000e62000c80043fULL, 0x0000000213137824ULL, 0x000fe200078e00ffULL,
0x000000070e00720cULL, 0x000fe20003f06070ULL, 0x00000040029f7824ULL, 0x000fe200078e00ffULL,
0x0000001f9c9c7810ULL, 0x000fe20007ffe0ffULL, 0x0000590013007a24ULL, 0x000fe400078e0200ULL,
0x00000100040f7824ULL, 0x000fe200078e029fULL, 0x00000005ff9c7819ULL, 0x000fc6000001169cULL,
0x00006800002b7a24ULL, 0x000fc800078e020fULL, 0x00000c7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff2e7819ULL, 0x000fe40000011605ULL, 0x0000000f060d7217ULL, 0x000fe40007800000ULL,
0x000000042e107810ULL, 0x040fe20007ffe0ffULL, 0x000000012b0e7824ULL, 0x000fe200078e022eULL,
0x000000082e127810ULL, 0x040fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0fULL,
0x000000182e2c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001100f7824ULL, 0x100fe200078e0205ULL,
0x000000142e227810ULL, 0x000fe20007ffe0ffULL, 0x0000000810147824ULL, 0x040fe200078e00ffULL,
0x0000000d1000720cULL, 0x000fe20003fa6070ULL, 0x0000000112117824ULL, 0x000fe200078e0205ULL,
0x0000001c2e327810ULL, 0x000fe20007ffe0ffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff814237812ULL, 0x000fe200078ee20fULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000c2e147810ULL, 0x000fc40007ffe0ffULL, 0xfffffff816277812ULL, 0x000fe200078ee211ULL,
0x000000012b107824ULL, 0x000fe200078e0210ULL, 0x000000102e167810ULL, 0x000fe20007ffe0ffULL,
0x0000000114137824ULL, 0x100fe200078e0205ULL, 0x000000700e187812ULL, 0x100fe200078ef80cULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000000d1400720cULL, 0x080fe40003f46070ULL,
0x0000640018187a10ULL, 0x000fe20007f1e0ffULL, 0x00000001160e7824ULL, 0x000fe200078e0205ULL,
0x00000070101a7812ULL, 0x000fe200078ef80cULL, 0x00000008162d7824ULL, 0x000fe200078e00ffULL,
0x000065000f197a10ULL, 0x000fe200007fe4ffULL, 0x00000008141c7824ULL, 0x000fe200078e00ffULL,
0x000064001a1a7a10ULL, 0x000fe20007f3e0ffULL, 0x000000012b107824ULL, 0x000fe200078e0214ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20eULL, 0x000000012b0e7824ULL, 0x000fe200078e0212ULL,
0x00006500111b7a10ULL, 0x000fe20000ffe4ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000000d1200720cULL, 0x000fc40003f26070ULL, 0xfffffff81c297812ULL, 0x000fe200078ee213ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000d1600720cULL, 0x000fe40003f06070ULL,
0x00000070101e7812ULL, 0x000fe200078ef80cULL, 0x000000012b127824ULL, 0x040fe200078e0216ULL,
0x000000700e1c7812ULL, 0x000fe200078ef80cULL, 0x000000012b167824ULL, 0x040fe200078e022cULL,
0x000064001e1e7a10ULL, 0x000fe20007f9e0ffULL, 0x000000012b147824ULL, 0x000fe200078e0222ULL,
0x000064001c1c7a10ULL, 0x000fe20007f7e0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000202e267810ULL, 0x000fc40007ffe0ffULL, 0x000065000f1d7a10ULL, 0x000fe20001ffe4ffULL,
0x000000012b0e7824ULL, 0x000fe200078e0232ULL, 0x0000007016167812ULL, 0x100fe200078ef80cULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x00006500111f7a10ULL, 0x000fe400027fe4ffULL,
0x0000640016167a10ULL, 0x000fe20007fde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x100fe400078ef80cULL, 0x0000650017177a10ULL, 0x000fe200037fe4ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007014147812ULL, 0x000fc400078ef80cULL,
0x0000640012127a10ULL, 0x000fe20007f7e0ffULL, 0x000000012e107824ULL, 0x100fe200078e0205ULL,
0x000000700e207812ULL, 0x000fe200078ef80cULL, 0x000000012b0e7824ULL, 0x000fe200078e0226ULL,
0x0000640014147a10ULL, 0x000fe20007f9e0ffULL, 0x0000000122117824ULL, 0x100fe200078e0205ULL,
0x0000640020207a10ULL, 0x000fe20007fde0ffULL, 0x000000012c307824ULL, 0x040fe200078e0205ULL,
0x0000650013137a10ULL, 0x000fe20001ffe4ffULL, 0x000000082c317824ULL, 0x000fe200078e00ffULL,
0x0000650015157a10ULL, 0x000fc400027fe4ffULL, 0x0000000710107812ULL, 0x000fe400078ec0ffULL,
0x0000000d2e00720cULL, 0x080fe40003f86070ULL, 0x0000000d2200720cULL, 0x040fe20003f66070ULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x000065000f217a10ULL, 0x000fe200037fe4ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000242e287810ULL, 0x000fe40007ffe0ffULL,
0x0000200002247811ULL, 0x000fc400078e70ffULL, 0x0ffffff810257812ULL, 0x000fe200078ef805ULL,
0x000000012b107824ULL, 0x000fe200078e0228ULL, 0xfffffff8222f7812ULL, 0x000fe200078ee211ULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x000000282e2a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x000fe200078e0224ULL, 0x000000700e227812ULL, 0x000fe200078ef80cULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe400078ee230ULL,
0x0000640022227a10ULL, 0x000fe20007fde0ffULL, 0x000000012b0e7824ULL, 0x000fe200078e022aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018257faeULL, 0x0005e2000e101c46ULL,
0x0000007010107812ULL, 0x000fc400078ef80cULL, 0x0000000d2c00720cULL, 0x080fe40003f86070ULL,
0x0000002c2e2c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001023257824ULL, 0x004fe200078e0224ULL,
0x000065000f237a10ULL, 0x000fe200037fe4ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe40007fde0ffULL, 0x000000001a257faeULL, 0x0005e2000e901c46ULL,
0x0000000d3200720cULL, 0x040fe20003fa6070ULL, 0x0000000132197824ULL, 0x000fe200078e0205ULL,
0x000000700e187812ULL, 0x000fe200078ef80cULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fe200037fe4ffULL, 0x000000012b0e7824ULL, 0x000fe200078e022cULL,
0x0000640018187a10ULL, 0x000fe20007fde0ffULL, 0x000000001c277faeULL, 0x0007e2000c901c46ULL,
0xfffffff832337812ULL, 0x000fc400078ee219ULL, 0x000065000f197a10ULL, 0x000fe200037fe4ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000d2600720cULL, 0x000fc60003f26070ULL,
0x00000001261b7824ULL, 0x104fe200078e0205ULL, 0x000000700e1a7812ULL, 0x000fe200078ef80cULL,
0x0000000826267824ULL, 0x000fe400078e00ffULL, 0x0000001029257824ULL, 0x100fe200078e0224ULL,
0x000064001a1a7a10ULL, 0x000fe20007fde0ffULL, 0x00000001280e7824ULL, 0x000fe200078e0205ULL,
0x000000302e1c7810ULL, 0x008fe20007ffe0ffULL, 0x0000000828297824ULL, 0x000fe200078e00ffULL,
0xfffffff826277812ULL, 0x000fe200078ee21bULL, 0x000000102d1d7824ULL, 0x100fe200078e0224ULL,
0x000065000f1b7a10ULL, 0x000fe200037fe4ffULL, 0x000000102f0f7824ULL, 0x000fe200078e0224ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x000000001e257faeULL, 0x0005e2000d101c46ULL,
0x000000012b0e7824ULL, 0x000fe200078e021cULL, 0x0000000d2800720cULL, 0x000fe20003f46070ULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x00000000121d7faeULL, 0x0007e2000c101c46ULL,
0x0000001029297824ULL, 0x000fe200078e0224ULL, 0x000000382e267810ULL, 0x000fc40007ffe0ffULL,
0x00000000140f7faeULL, 0x0009e2000d901c46ULL, 0x0000003c2e287810ULL, 0x000fe40007ffe0ffULL,
0x0000000d1c00720cULL, 0x080fe20003f66070ULL, 0x00000010311f7824ULL, 0x104fe200078e0224ULL,
0x000000342e1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001033257824ULL, 0x000fe200078e0224ULL,
0x0000000d2800720cULL, 0x080fe20003f06070ULL, 0x000000012a137824ULL, 0x008fe200078e0205ULL,
0x00000000161f7faeULL, 0x0005e2000e101c46ULL, 0x0000000d2c00720cULL, 0x000fe20003f86070ULL,
0x000001000e0e7825ULL, 0x010fc400078e00ffULL, 0x0000000020257faeULL, 0x0007e2000e901c46ULL,
0x0000000d2a00720cULL, 0x0c0fe20003fa6070ULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x000000700e127812ULL, 0x000fe200078ef80cULL, 0x000000012b147824ULL, 0x000fe200078e021eULL,
0x0000000022277faeULL, 0x0009e2000c901c46ULL, 0x0000000d2600720cULL, 0x080fe20003f26070ULL,
0x000000012c0e7824ULL, 0x000fe200078e0205ULL, 0x0000640012127a10ULL, 0x000fe20007fde0ffULL,
0x0000000010297faeULL, 0x0003e2000d101c46ULL, 0x0000000d1e00720cULL, 0x000fe20003f46070ULL,
0x000000082c177824ULL, 0x004fe200078e00ffULL, 0xfffffff82a0d7812ULL, 0x000fe200078ee213ULL,
0x000000011e167824ULL, 0x100fe200078e0205ULL, 0x000065000f137a10ULL, 0x000fe200037fe4ffULL,
0x000000011c0f7824ULL, 0x040fe200078e0205ULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x000000081c1c7824ULL, 0x000fc400078e00ffULL, 0x000000081e1f7824ULL, 0x000fe400078e00ffULL,
0x0000010014107825ULL, 0x002fe200078e00ffULL, 0xfffffff81c1d7812ULL, 0x000fe400078ee20fULL,
0x00000005261c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000128057824ULL, 0x000fe200078e0205ULL,
0x0000007010147812ULL, 0x000fe200078ef80cULL, 0x000000012b107824ULL, 0x000fe200078e0226ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee216ULL, 0x0000000826217824ULL, 0x008fe200078e00ffULL,
0x0000640014147a10ULL, 0x000fe20007fde0ffULL, 0x00000100100e7825ULL, 0x000fc600078e00ffULL,
0x0000650011157a10ULL, 0x000fe200037fe4ffULL, 0x000000012b107824ULL, 0x000fe200078e0228ULL,
0x000000700e0e7812ULL, 0x000fe200078ef80cULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21cULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000064000e0e7a10ULL, 0x000fe40007fde0ffULL, 0xfffffff828237812ULL, 0x010fe200078ee205ULL,
0x000000100d057824ULL, 0x000fe200078e0224ULL, 0x00000070100c7812ULL, 0x000fe200078ef80cULL,
0x0000001017177824ULL, 0x100fe200078e0224ULL, 0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0224ULL, 0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0224ULL, 0x0000000018057faeULL, 0x0003e2000e901c46ULL,
0x0000001021217824ULL, 0x100fe200078e0224ULL, 0x00006500110d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001023237824ULL, 0x000fe200078e0224ULL, 0x000000001a177faeULL, 0x0003e8000e101c46ULL,
0x00000000121d7faeULL, 0x0003e8000d901c46ULL, 0x00000000141f7faeULL, 0x0003e8000d101c46ULL,
0x000000000e217faeULL, 0x0003e8000c901c46ULL, 0x000000000c237faeULL, 0x0003e2000c101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000c05167811ULL, 0x040fe400078fe8ffULL,
0x0000000405127811ULL, 0x000fc400078fe8ffULL, 0x0000000805147811ULL, 0x040fe200078fe8ffULL,
0x00000001160f7824ULL, 0x140fe200078e0205ULL, 0x00000018052e7811ULL, 0x040fe200078fe8ffULL,
0x0000000816187824ULL, 0x000fe200078e00ffULL, 0x0000001005267811ULL, 0x040fe200078fe8ffULL,
0x00000001120d7824ULL, 0x040fe200078e0205ULL, 0x0000001405287811ULL, 0x040fe200078fe8ffULL,
0x0000000812107824ULL, 0x000fe200078e00ffULL, 0xfffffff818337812ULL, 0x000fe200078ee20fULL,
0x00000001140e7824ULL, 0x040fe200078e0205ULL, 0x0000001c05307811ULL, 0x040fe200078fe8ffULL,
0x0000000814317824ULL, 0x000fe200078e00ffULL, 0xfffffff8102f7812ULL, 0x000fe200078ee20dULL,
0x000000012e0f7824ULL, 0x140fe200078e0205ULL, 0x0000002c051e7811ULL, 0x000fe200078fe8ffULL,
0x000000082e1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20eULL,
0x00000001260d7824ULL, 0x040fe200078e0205ULL, 0x00000028051c7811ULL, 0x040fe200078fe8ffULL,
0x0000000826187824ULL, 0x000fe200078e00ffULL, 0xfffffff81a397812ULL, 0x000fe200078ee20fULL,
0x00000001280e7824ULL, 0x040fe200078e0205ULL, 0x00000024051a7811ULL, 0x040fe200078fe8ffULL,
0x0000000828377824ULL, 0x000fe200078e00ffULL, 0xfffffff818357812ULL, 0x000fe200078ee20dULL,
0x0000000130107824ULL, 0x140fe200078e0205ULL, 0x0000002005187811ULL, 0x000fe200078fe8ffULL,
0x00000008303b7824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee20eULL,
0x000000011a0e7824ULL, 0x140fe200078e0205ULL, 0x0000003805247811ULL, 0x000fe200078fe8ffULL,
0x000000081a197824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x000000011e107824ULL, 0x140fe200078e0205ULL, 0x0000003c052a7811ULL, 0x000fe200078fe8ffULL,
0x000000081e1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee20eULL,
0x00000001180d7824ULL, 0x140fe200078e0205ULL, 0x0000002b050e7211ULL, 0x000fe200078fe8ffULL,
0x0000000818207824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x000000011c0f7824ULL, 0x000fc400078e0205ULL, 0x000000081c227824ULL, 0x000fe200078e00ffULL,
0xfffffff820177812ULL, 0x000fe200078ee20dULL, 0x0000000112107824ULL, 0x100fe200078e022bULL,
0x00000005050d7211ULL, 0x040fe200078fe8ffULL, 0x0000000114127824ULL, 0x100fe200078e022bULL,
0x0000003005207811ULL, 0x000fe200078fe8ffULL, 0x0000000126147824ULL, 0x000fe200078e022bULL,
0xfffffff8221b7812ULL, 0x000fe200078ee20fULL, 0x000000012b267824ULL, 0x000fe200078e0218ULL,
0x0000003405227811ULL, 0x000fe200078fe8ffULL, 0x0000000124187824ULL, 0x040fe200078e0205ULL,
0x000000070d2c7812ULL, 0x000fe200078ec0ffULL, 0x00000008241f7824ULL, 0x000fc400078e00ffULL,
0x000000012b277824ULL, 0x000fe200078e021aULL, 0x0ffffff82c2c7812ULL, 0x000fe200078ef805ULL,
0x000001000e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000120117824ULL, 0x040fe400078e0205ULL,
0x00000008201a7824ULL, 0x000fe400078e00ffULL, 0x000000012b297824ULL, 0x000fe200078e021eULL,
0xfffffff81f1e7812ULL, 0x000fe200078ee218ULL, 0x0000000128157824ULL, 0x000fe200078e022bULL,
0x000000700e187812ULL, 0x000fe200078ef80cULL, 0x0000000122137824ULL, 0x000fe200078e0205ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL, 0x000000012b287824ULL, 0x040fe200078e021cULL,
0x00002000020e7811ULL, 0x000fe200078e70ffULL, 0x000000012b347824ULL, 0x000fe200078e022aULL,
0x0000640018187a10ULL, 0x000fe20007f1e0ffULL, 0x000000012a057824ULL, 0x000fc400078e0205ULL,
0x00000008221c7824ULL, 0x000fe400078e00ffULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe400078ee213ULL,
0xfffffff82a1f7812ULL, 0x000fe200078ee205ULL, 0x000000101a457824ULL, 0x000fe200078e020eULL,
0x00000070101a7812ULL, 0x000fe200078ef80cULL, 0x0000010012127825ULL, 0x000fc600078e00ffULL,
0x000064001a1a7a10ULL, 0x000fe20007f3e0ffULL, 0x00000001160d7824ULL, 0x000fe400078e022bULL,
0x00000010193f7824ULL, 0x100fe200078e020eULL, 0x000065000f197a10ULL, 0x000fe200007fe4ffULL,
0x000000102c057824ULL, 0x100fe400078e020eULL, 0x000000102f2f7824ULL, 0x100fe400078e020eULL,
0x0000001031317824ULL, 0x100fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018057faeULL, 0x0005e2000b901c46ULL, 0x0000001033337824ULL, 0x000fc400078e020eULL,
0x0000001035357824ULL, 0x100fe400078e020eULL, 0x0000001037377824ULL, 0x100fe400078e020eULL,
0x0000001039397824ULL, 0x100fe400078e020eULL, 0x000000103b3b7824ULL, 0x100fe400078e020eULL,
0x00000010173d7824ULL, 0x100fe400078e020eULL, 0x000000101b417824ULL, 0x100fe200078e020eULL,
0x00006500111b7a10ULL, 0x000fe20000ffe4ffULL, 0x000000101d437824ULL, 0x000fc400078e020eULL,
0x000000101c477824ULL, 0x000fe200078e020eULL, 0x00000070121c7812ULL, 0x000fe200078ef80cULL,
0x000000101e497824ULL, 0x100fe200078e020eULL, 0x000000001a2f7faeULL, 0x0005e2000b901c46ULL,
0x000000101f4b7824ULL, 0x000fe200078e020eULL, 0x000064001c1c7a10ULL, 0x000fe20007f1e0ffULL,
0x000001000d0e7825ULL, 0x000fc600078e00ffULL, 0x00006500131d7a10ULL, 0x000fe200007fe4ffULL,
0x0000010014107825ULL, 0x000fe200078e00ffULL, 0x000000700e1e7812ULL, 0x000fc600078ef80cULL,
0x0000010015147825ULL, 0x000fe200078e00ffULL, 0x000064001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000001c317faeULL, 0x0005e4000b901c46ULL, 0x000000012e167824ULL, 0x100fe200078e022bULL,
0x000065000f1f7a10ULL, 0x000fe200007fe4ffULL, 0x000000012b2e7824ULL, 0x040fe200078e0220ULL,
0x0000007010207812ULL, 0x000fe200078ef80cULL, 0x0000000130237824ULL, 0x000fe400078e022bULL,
0x000000012b307824ULL, 0x000fe200078e0222ULL, 0x0000007014227812ULL, 0x000fe200078ef80cULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000640020207a10ULL, 0x000fe20007f3e0ffULL,
0x000000001e337faeULL, 0x0005e2000b901c46ULL, 0x0000640022227a10ULL, 0x000fe20007f1e0ffULL,
0x00000100230e7825ULL, 0x000fe200078e00ffULL, 0x0000650011217a10ULL, 0x000fc40000ffe4ffULL,
0x0000650015237a10ULL, 0x000fe200007fe4ffULL, 0x000000012b327824ULL, 0x000fe200078e0224ULL,
0x0000007016247812ULL, 0x100fe200078ef80cULL, 0x0000010026107825ULL, 0x000fe200078e00ffULL,
0x000000700e267812ULL, 0x100fe200078ef80cULL, 0x0000000020357faeULL, 0x0005e2000b901c46ULL,
0x0000640024247a10ULL, 0x000fe20007f5e0ffULL, 0x0000010027127825ULL, 0x000fe200078e00ffULL,
0x0000640026267a10ULL, 0x000fe20007f1e0ffULL, 0x0000000022377faeULL, 0x0005e2000b901c46ULL,
0x0000650017257a10ULL, 0x000fe200017fe4ffULL, 0x0000010028147825ULL, 0x000fe200078e00ffULL,
0x0000007010287812ULL, 0x000fc400078ef80cULL, 0x00000070122a7812ULL, 0x100fe200078ef80cULL,
0x0000010029167825ULL, 0x000fe200078e00ffULL, 0x00000070142c7812ULL, 0x100fe200078ef80cULL,
0x0000000024397faeULL, 0x0005e2000b901c46ULL, 0x0000640028287a10ULL, 0x000fe40007f3e0ffULL,
0x000065000f277a10ULL, 0x000fe200007fe4ffULL, 0x000001002e0e7825ULL, 0x000fe200078e00ffULL,
0x000064002a2a7a10ULL, 0x000fe40007f1e0ffULL, 0x000064002c2c7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000263b7faeULL, 0x0005e2000b901c46ULL, 0x0000650011297a10ULL, 0x000fe20000ffe4ffULL,
0x0000010030107825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x000fc400078ef80cULL,
0x00006500132b7a10ULL, 0x000fe200007fe4ffULL, 0x0000010032127825ULL, 0x000fe200078e00ffULL,
0x00006500152d7a10ULL, 0x000fe200017fe4ffULL, 0x00000000283d7faeULL, 0x0005e2000b901c46ULL,
0x0000640016167a10ULL, 0x000fe20007f1e0ffULL, 0x0000010034147825ULL, 0x000fe200078e00ffULL,
0x000000700e0d7812ULL, 0x100fe200078ef80cULL, 0x000000002a3f7faeULL, 0x0005e2000b901c46ULL,
0x00000070100e7812ULL, 0x100fe400078ef80cULL, 0x0000007012107812ULL, 0x000fe200078ef80cULL,
0x000000002c417faeULL, 0x0005e2000b901c46ULL, 0x0000650017177a10ULL, 0x000fc400007fe4ffULL,
0x0000007014127812ULL, 0x000fe400078ef80cULL, 0x000064000d0c7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000016437faeULL, 0x0005e2000b901c46ULL, 0x000064000e0e7a10ULL, 0x000fe40007f3e0ffULL,
0x0000640010107a10ULL, 0x000fe40007f5e0ffULL, 0x0000640012127a10ULL, 0x000fe40007f7e0ffULL,
0x000065000f0d7a10ULL, 0x000fc400007fe4ffULL, 0x00006500110f7a10ULL, 0x000fe40000ffe4ffULL,
0x0000650013117a10ULL, 0x000fe200017fe4ffULL, 0x000000000c457faeULL, 0x0005e2000b901c46ULL,
0x0000650015137a10ULL, 0x000fc60001ffe4ffULL, 0x000000000e477faeULL, 0x0005e8000b901c46ULL,
0x0000000010497faeULL, 0x0005e8000b901c46ULL, 0x00000000124b7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000c7805ULL, 0x006fc40000015200ULL,
0x01e60400ff057984ULL, 0x000e620000000800ULL, 0x0000009c099b7224ULL, 0x000fe400078e02ffULL,
0x00000001069e7824ULL, 0x000fc400078e0a08ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x8000000005ff7812ULL, 0x002fe2000780480bULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000062009b9a7625ULL, 0x000fe200078e009aULL,
0x00000008ff9e7819ULL, 0x000fe2000001169eULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140fULL,
0x0000000e05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x0000000205057819ULL, 0x000fc8000000120eULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000009d7919ULL, 0x000e620000000000ULL, 0x000000029c9c7824ULL, 0x000fe200078e00ffULL,
0x0001e68802997811ULL, 0x040fe200078e18ffULL, 0x0000002002227824ULL, 0x000fe200078e00ffULL,
0xffffffff08987810ULL, 0x040fe40007ffe0ffULL, 0x0000000908237810ULL, 0x000fc40007ffe0ffULL,
0x00000001040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000010004217824ULL, 0x000fe200078e029fULL,
0x0000000000007946ULL, 0x000fe40003800000ULL, 0x000000070a00720cULL, 0x000fe20003f06070ULL,
0x00006800001e7a24ULL, 0x000fd800078e0221ULL, 0x00000bb000008947ULL, 0x004fea0003800000ULL,
0x000000109d207824ULL, 0x002fe200078e00ffULL, 0x00000003ff267819ULL, 0x100fe2000001169dULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x00000021060e7217ULL, 0x000fe40007800000ULL,
0x0000007020207812ULL, 0x000fe200078ec0ffULL, 0x00000001260d7824ULL, 0x040fe200078e021eULL,
0x0000000426107810ULL, 0x000fe40007ffe0ffULL, 0x00000080200a7812ULL, 0x000fe400078efcffULL,
0x0000000826127810ULL, 0x000fe20007ffe0ffULL, 0x0000000110057824ULL, 0x000fe200078e029dULL,
0x0000001026187810ULL, 0x040fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e000aULL,
0x0000000c26167810ULL, 0x000fc40007ffe0ffULL, 0x00000014261c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000810247824ULL, 0x000fe200078e00ffULL, 0x000064000c147a10ULL, 0x000fe20007f1e0ffULL,
0x0000000112097824ULL, 0x100fe200078e029dULL, 0x0000001826307810ULL, 0x000fe20007ffe0ffULL,
0x0000000812287824ULL, 0x000fe200078e00ffULL, 0x000065000d157a10ULL, 0x000fe200007fe4ffULL,
0x00000001180f7824ULL, 0x000fe200078e029dULL, 0xfffffff824247812ULL, 0x000fe200078ee205ULL,
0x00000008182c7824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee209ULL,
0x00000001100d7824ULL, 0x000fe200078e021eULL, 0x0ffffff89d1f7812ULL, 0x000fe200078ec0ffULL,
0x000000010e057824ULL, 0x000fe200078e0a21ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee20fULL,
0x0000000116097824ULL, 0x000fe200078e029dULL, 0x0000001c26327810ULL, 0x000fe20007ffe0ffULL,
0x00000008162a7824ULL, 0x040fe200078e00ffULL, 0x000000051600720cULL, 0x080fe20003f66070ULL,
0x000001000d0c7825ULL, 0x000fe200078e000aULL, 0x000000051800720cULL, 0x000fc40003f06070ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL, 0x00000001120f7824ULL, 0x100fe200078e021eULL,
0x000000051000720cULL, 0x080fe20003f86070ULL, 0x0000000116117824ULL, 0x000fe200078e021eULL,
0x000064000c167a10ULL, 0x000fe20007f3e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e000aULL,
0x000000051200720cULL, 0x000fe40003f46070ULL, 0x000065000d177a10ULL, 0x000fe20000ffe4ffULL,
0x0000000118097824ULL, 0x100fe200078e021eULL, 0x000064000e187a10ULL, 0x000fe20007fbe0ffULL,
0x000000011c137824ULL, 0x000fe200078e021eULL, 0x0000002026347810ULL, 0x000fe20007ffe0ffULL,
0x00000100090c7825ULL, 0x000fe200078e000aULL, 0x000065000f197a10ULL, 0x000fc60002ffe4ffULL,
0x0000010011107825ULL, 0x000fe200078e000aULL, 0x000064000c1a7a10ULL, 0x000fc60007fbe0ffULL,
0x0000010013127825ULL, 0x000fe200078e000aULL, 0x0000640010107a10ULL, 0x000fe40007f3e0ffULL,
0x000065000d1b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000000130097824ULL, 0x000fe200078e021eULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x00000001260e7824ULL, 0x000fe200078e029dULL,
0x0000650011117a10ULL, 0x000fe20000ffe4ffULL, 0x00000100090c7825ULL, 0x000fe200078e000aULL,
0x0000650013137a10ULL, 0x000fe400037fe4ffULL, 0x000000051c00720cULL, 0x0c0fe20003f26070ULL,
0x000000011c0f7824ULL, 0x100fe200078e029dULL, 0x000000052600720cULL, 0x000fe20003fa6070ULL,
0x000000081c2e7824ULL, 0x000fe200078e00ffULL, 0x000064000c1c7a10ULL, 0x000fe20007fde0ffULL,
0x00000001302b7824ULL, 0x000fe200078e029dULL, 0x0000400002097811ULL, 0x000fc400078e70ffULL,
0x000000071f0e7812ULL, 0x000fe400078ef80eULL, 0x000065000d1d7a10ULL, 0x000fe200037fe4ffULL,
0x00000001320d7824ULL, 0x000fe200078e021eULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x000000100e277824ULL, 0x000fe400078e0209ULL, 0x000001000d0c7825ULL, 0x000fc600078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014277faeULL, 0x0003e2000e901c46ULL,
0x0000001024297824ULL, 0x000fe200078e0209ULL, 0x000064000c247a10ULL, 0x000fe20007fde0ffULL,
0x00000001340f7824ULL, 0x000fe200078e021eULL, 0x000000053000720cULL, 0x0c0fe20003fa6070ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x0000000016297faeULL, 0x0005e2000e101c46ULL,
0x00000001320c7824ULL, 0x040fe200078e029dULL, 0x000065000d257a10ULL, 0x000fe200037fe4ffULL,
0x000001000f0e7825ULL, 0x000fe200078e000aULL, 0x000000053200720cULL, 0x000fc40003f86070ULL,
0x0000002426147810ULL, 0x002fe20007ffe0ffULL, 0x000000102a277824ULL, 0x000fe200078e0209ULL,
0x0000000332157819ULL, 0x000fe400000006ffULL, 0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x00000001140d7824ULL, 0x000fe200078e021eULL, 0xfffffff830167812ULL, 0x004fe200078ee22bULL,
0x0000001028177824ULL, 0x000fe200078e0209ULL, 0xfffffff815307812ULL, 0x000fe200078ee20cULL,
0x0000000134157824ULL, 0x000fe200078e029dULL, 0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x000001000d0c7825ULL, 0x000fe200078e000aULL, 0x0000000018177faeULL, 0x0003e2000d101c46ULL,
0x000000051400720cULL, 0x000fc40003f46070ULL, 0x0000000114287824ULL, 0x000fe200078e029dULL,
0x0000000010277faeULL, 0x0005e2000d901c46ULL, 0x000000053400720cULL, 0x040fe20003f66070ULL,
0x0000000834347824ULL, 0x000fe200078e00ffULL, 0x00000034262a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000814297824ULL, 0x000fe200078e00ffULL, 0x000064000c147a10ULL, 0x000fe40007fde0ffULL,
0xfffffff8340c7812ULL, 0x000fe200078ee215ULL, 0x000000102c177824ULL, 0x102fe200078e0209ULL,
0x000065000d157a10ULL, 0x000fe200037fe4ffULL, 0x000000102e0d7824ULL, 0x100fe200078e0209ULL,
0xfffffff829287812ULL, 0x000fe200078ee228ULL, 0x000000100c277824ULL, 0x104fe200078e0209ULL,
0x00000028260c7810ULL, 0x000fe20007ffe0ffULL, 0x000000001a177faeULL, 0x0003e2000c101c46ULL,
0x0000001016117824ULL, 0x100fe200078e0209ULL, 0x0000002c26107810ULL, 0x000fe20007ffe0ffULL,
0x0000001030197824ULL, 0x000fe200078e0209ULL, 0x00000000120d7faeULL, 0x0005e2000c901c46ULL,
0x000000080c167824ULL, 0x000fe200078e00ffULL, 0x0000003026187810ULL, 0x000fc40007ffe0ffULL,
0x000000001c117faeULL, 0x0007e2000e901c46ULL, 0x000000050c00720cULL, 0x080fe40003fc6070ULL,
0x00000038262c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000024197faeULL, 0x0009e2000e101c46ULL,
0x0000003c26267810ULL, 0x000fe20007ffe0ffULL, 0x00000008101a7824ULL, 0x042fe200078e00ffULL,
0x000000051000720cULL, 0x080fe20003fa6070ULL, 0x000000010c0d7824ULL, 0x004fe200078e029dULL,
0x000000000e277faeULL, 0x0003e2000d901c46ULL, 0x0000001028137824ULL, 0x000fe200078e0209ULL,
0x000000051800720cULL, 0x080fe20003f86070ULL, 0x0000000110117824ULL, 0x008fe200078e029dULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x000000010c0d7824ULL, 0x000fe200078e021eULL,
0x0000000014137faeULL, 0x0005e2000d101c46ULL, 0x0000000118127824ULL, 0x000fe200078e029dULL,
0x000000052a00720cULL, 0x080fe20003f66070ULL, 0x000001000d0c7825ULL, 0x000fe200078e000aULL,
0x000000052c00720cULL, 0x000fc40003f26070ULL, 0x000000052600720cULL, 0x000fe20003f06070ULL,
0x00000001100f7824ULL, 0x002fe200078e021eULL, 0x000064000c107a10ULL, 0x000fe20007f5e0ffULL,
0x0000000818177824ULL, 0x000fe400078e00ffULL, 0x000001000f0e7825ULL, 0x000fc800078e000aULL,
0x0000000118057824ULL, 0x000fe200078e021eULL, 0xfffffff81a187812ULL, 0x000fe200078ee211ULL,
0x000000082a157824ULL, 0x004fe200078e00ffULL, 0xfffffff8171a7812ULL, 0x000fe200078ee212ULL,
0x000000012c177824ULL, 0x000fe200078e021eULL, 0x000065000d117a10ULL, 0x000fe200017fe4ffULL,
0x00000100050c7825ULL, 0x000fe200078e000aULL, 0x000064000e127a10ULL, 0x000fc60007f5e0ffULL,
0x000000012a0e7824ULL, 0x140fe200078e029dULL, 0x000065000f137a10ULL, 0x000fe200017fe4ffULL,
0x000000012a057824ULL, 0x000fe200078e021eULL, 0x000064000c147a10ULL, 0x000fe20007f5e0ffULL,
0x000000012c197824ULL, 0x010fe200078e029dULL, 0xfffffff8151c7812ULL, 0x000fe200078ee20eULL,
0x00000100050e7825ULL, 0x000fe200078e000aULL, 0x000065000d157a10ULL, 0x000fc600017fe4ffULL,
0x00000100170c7825ULL, 0x000fe200078e000aULL, 0x000064000e0e7a10ULL, 0x000fc60007f5e0ffULL,
0x0000000126057824ULL, 0x000fe200078e021eULL, 0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL,
0x000000082c1e7824ULL, 0x000fe200078e00ffULL, 0x000064000c0c7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000126177824ULL, 0x040fe400078e029dULL, 0x0000000826247824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee219ULL, 0x00000100050a7825ULL, 0x000fe200078e000aULL,
0x000065000d0d7a10ULL, 0x000fe400017fe4ffULL, 0xfffffff824247812ULL, 0x000fe200078ee217ULL,
0x0000001016057824ULL, 0x100fe200078e0209ULL, 0x000064000a0a7a10ULL, 0x000fe20007f5e0ffULL,
0x0000001018177824ULL, 0x000fc400078e0209ULL, 0x000000101a197824ULL, 0x100fe200078e0209ULL,
0x000065000b0b7a10ULL, 0x000fe200017fe4ffULL, 0x000000101c1b7824ULL, 0x100fe200078e0209ULL,
0x0000000010057faeULL, 0x0003e2000f101c46ULL, 0x000000101e1d7824ULL, 0x100fe400078e0209ULL,
0x0000001024097824ULL, 0x000fe200078e0209ULL, 0x0000000012177faeULL, 0x0003e8000e901c46ULL,
0x0000000014197faeULL, 0x0003e8000e101c46ULL, 0x000000000e1b7faeULL, 0x0003e8000d901c46ULL,
0x000000000c1d7faeULL, 0x0003e8000c901c46ULL, 0x000000000a097faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x000000049d0d7811ULL, 0x042fe200078fe8ffULL,
0x000000109d207824ULL, 0x040fe200078e00ffULL, 0x000000089d0f7811ULL, 0x040fe200078fe8ffULL,
0x000000ffff2f7224ULL, 0x000fe200078e00ffULL, 0x0000000c9d117811ULL, 0x000fe200078fe8ffULL,
0x000000010d057824ULL, 0x100fe200078e029dULL, 0x000000109d137811ULL, 0x000fe200078fe8ffULL,
0x000000080d0c7824ULL, 0x000fe200078e00ffULL, 0x000000149d157811ULL, 0x000fe200078fe8ffULL,
0x000000010f0a7824ULL, 0x000fe200078e029dULL, 0x000000189d177811ULL, 0x000fe200078fe8ffULL,
0x000000080f317824ULL, 0x000fe200078e00ffULL, 0xfffffff80c097812ULL, 0x000fe200078ee205ULL,
0x0000000111057824ULL, 0x100fe200078e029dULL, 0x0000001c9d197811ULL, 0x000fe200078fe8ffULL,
0x00000008110c7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20aULL,
0x00000001130a7824ULL, 0x000fe200078e029dULL, 0x000000209d1b7811ULL, 0x000fe200078fe8ffULL,
0x0000000813357824ULL, 0x000fe200078e00ffULL, 0xfffffff80c337812ULL, 0x000fe200078ee205ULL,
0x00000001150b7824ULL, 0x100fe200078e029dULL, 0x000000249d1d7811ULL, 0x000fe200078fe8ffULL,
0x00000008150e7824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20aULL,
0x0000000117057824ULL, 0x000fe200078e029dULL, 0x000000289d257811ULL, 0x000fe200078fe8ffULL,
0x00000008170c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e377812ULL, 0x000fe200078ee20bULL,
0x00000001190a7824ULL, 0x000fe200078e029dULL, 0x0000002c9d277811ULL, 0x000fe200078fe8ffULL,
0x00000008193b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c397812ULL, 0x000fe200078ee205ULL,
0x000000011b0b7824ULL, 0x100fe200078e029dULL, 0x000000309d297811ULL, 0x000fe200078fe8ffULL,
0x000000081b0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL,
0x000000011d057824ULL, 0x000fe200078e029dULL, 0x000000349d2b7811ULL, 0x000fe200078fe8ffULL,
0x000000081d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3d7812ULL, 0x000fe200078ee20bULL,
0x00000001250a7824ULL, 0x000fe200078e029dULL, 0x000000389d2d7811ULL, 0x000fe200078fe8ffULL,
0x0000000825417824ULL, 0x000fe200078e00ffULL, 0xfffffff80c3f7812ULL, 0x000fe200078ee205ULL,
0x00000001270b7824ULL, 0x100fe200078e029dULL, 0x0000003c9d4b7811ULL, 0x000fe200078fe8ffULL,
0x00000008270e7824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee20aULL,
0x0000000129057824ULL, 0x000fe200078e029dULL, 0x0ffffff89d1f7812ULL, 0x000fe200078ec0ffULL,
0x00000008290c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e437812ULL, 0x000fe200078ee20bULL,
0x000000012b0a7824ULL, 0x040fe200078e029dULL, 0x0000007020207812ULL, 0x000fe200078ec0ffULL,
0x000000082b477824ULL, 0x000fe200078e00ffULL, 0xfffffff80c457812ULL, 0x000fe200078ee205ULL,
0x000000012d0b7824ULL, 0x140fe200078e029dULL, 0x00000080202e7812ULL, 0x000fe200078efcffULL,
0x000000082d0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fe200078ee20aULL,
0x000000014b057824ULL, 0x000fe200078e029dULL, 0x0000009d9d0a7211ULL, 0x000fe200078fe8ffULL,
0x000000084b0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e497812ULL, 0x000fe200078ee20bULL,
0x000000010d0d7824ULL, 0x100fe200078e021eULL, 0x0000001e9d0b7211ULL, 0x000fe200078fe8ffULL,
0x000000010f0f7824ULL, 0x100fe200078e021eULL, 0xfffffff80c4d7812ULL, 0x000fe200078ee205ULL,
0x0000000111117824ULL, 0x100fe200078e021eULL, 0x00004000020c7811ULL, 0x000fe200078e70ffULL,
0x0000000113137824ULL, 0x000fe200078e021eULL, 0x000000071f057812ULL, 0x000fe200078ef80aULL,
0x000001000b0a7825ULL, 0x000fc800078e002eULL, 0x0000001005057824ULL, 0x100fe200078e020cULL,
0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001009097824ULL, 0x100fe400078e020cULL,
0x0000001031317824ULL, 0x100fe200078e020cULL, 0x000065000b0b7a10ULL, 0x000fe200007fe4ffULL,
0x0000001033337824ULL, 0x100fe400078e020cULL, 0x0000001035357824ULL, 0x100fe400078e020cULL,
0x0000001037377824ULL, 0x100fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e2000b901c46ULL, 0x0000001039397824ULL, 0x000fc400078e020cULL,
0x000000103b3b7824ULL, 0x100fe400078e020cULL, 0x000000103d3d7824ULL, 0x100fe400078e020cULL,
0x000000103f3f7824ULL, 0x100fe400078e020cULL, 0x0000001041417824ULL, 0x100fe400078e020cULL,
0x0000001043437824ULL, 0x100fe400078e020cULL, 0x0000001045457824ULL, 0x000fc400078e020cULL,
0x0000001047477824ULL, 0x100fe400078e020cULL, 0x0000001049497824ULL, 0x100fe400078e020cULL,
0x000000104d4d7824ULL, 0x000fe400078e020cULL, 0x000001000d0c7825ULL, 0x000fc800078e002eULL,
0x0000000115157824ULL, 0x000fe200078e021eULL, 0x000064000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e002eULL, 0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000117177824ULL, 0x000fe200078e021eULL, 0x000064000e0e7a10ULL, 0x000fe20007f5e0ffULL,
0x0000010011107825ULL, 0x000fe400078e002eULL, 0x000000000c097faeULL, 0x0003e2000b901c46ULL,
0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x0000000119197824ULL, 0x000fe200078e021eULL,
0x0000640010107a10ULL, 0x000fe20007f7e0ffULL, 0x0000010013127825ULL, 0x000fe400078e002eULL,
0x000000000e317faeULL, 0x0003e2000b901c46ULL, 0x0000650011117a10ULL, 0x000fe20001ffe4ffULL,
0x000000011b1b7824ULL, 0x000fe200078e021eULL, 0x0000640012127a10ULL, 0x000fe20007f1e0ffULL,
0x0000010015147825ULL, 0x000fc400078e002eULL, 0x0000000010337faeULL, 0x0003e2000b901c46ULL,
0x0000650013137a10ULL, 0x000fe200007fe4ffULL, 0x000000011d1d7824ULL, 0x000fe200078e021eULL,
0x0000640014147a10ULL, 0x000fe20007f3e0ffULL, 0x0000010017167825ULL, 0x000fe400078e002eULL,
0x0000000012357faeULL, 0x0003e2000b901c46ULL, 0x0000650015157a10ULL, 0x000fe20000ffe4ffULL,
0x0000000125257824ULL, 0x000fe200078e021eULL, 0x0000640016167a10ULL, 0x000fe20007f5e0ffULL,
0x0000010019187825ULL, 0x000fc400078e002eULL, 0x0000000014377faeULL, 0x0003e2000b901c46ULL,
0x0000650017177a10ULL, 0x000fe200017fe4ffULL, 0x0000000127277824ULL, 0x000fe200078e021eULL,
0x0000640018187a10ULL, 0x000fe20007f7e0ffULL, 0x000001001b1a7825ULL, 0x000fe400078e002eULL,
0x0000000016397faeULL, 0x0003e2000b901c46ULL, 0x0000650019197a10ULL, 0x000fe20001ffe4ffULL,
0x0000000129297824ULL, 0x000fe200078e021eULL, 0x000064001a1a7a10ULL, 0x000fe20007f1e0ffULL,
0x000001001d1c7825ULL, 0x000fc400078e002eULL, 0x00000000183b7faeULL, 0x0003e2000b901c46ULL,
0x000065001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x000000012b2b7824ULL, 0x000fe200078e021eULL,
0x000064001c1c7a10ULL, 0x000fe20007f3e0ffULL, 0x0000010025247825ULL, 0x000fe400078e002eULL,
0x000000001a3d7faeULL, 0x0003e2000b901c46ULL, 0x000065001d1d7a10ULL, 0x000fe20000ffe4ffULL,
0x000000012d2d7824ULL, 0x000fe200078e021eULL, 0x0000640024247a10ULL, 0x000fe20007f5e0ffULL,
0x0000010027267825ULL, 0x000fc400078e002eULL, 0x000000001c3f7faeULL, 0x0003e2000b901c46ULL,
0x0000650025257a10ULL, 0x000fe200017fe4ffULL, 0x000000014b4b7824ULL, 0x000fe200078e021eULL,
0x0000640026267a10ULL, 0x000fe20007f7e0ffULL, 0x0000010029287825ULL, 0x100fe400078e002eULL,
0x0000000024417faeULL, 0x0003e2000b901c46ULL, 0x0000650027277a10ULL, 0x000fe20001ffe4ffULL,
0x000001002b2a7825ULL, 0x000fe200078e002eULL, 0x0000640028287a10ULL, 0x000fc60007f1e0ffULL,
0x000001002d2c7825ULL, 0x100fe200078e002eULL, 0x000064002a2a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000026437faeULL, 0x0003e2000b901c46ULL, 0x0000650029297a10ULL, 0x000fe200007fe4ffULL,
0x000001004b2e7825ULL, 0x000fe200078e002eULL, 0x000064002c2c7a10ULL, 0x000fe40007f5e0ffULL,
0x000065002b2b7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000028457faeULL, 0x0003e2000b901c46ULL,
0x000064002e2e7a10ULL, 0x000fe40007f7e0ffULL, 0x000065002d2d7a10ULL, 0x000fe200017fe4ffULL,
0x000000002a477faeULL, 0x0003e2000b901c46ULL, 0x000065002f2f7a10ULL, 0x000fc60001ffe4ffULL,
0x000000002c497faeULL, 0x0003e8000b901c46ULL, 0x000000002e4d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000089d1e7812ULL, 0x040fe400078ec0ffULL,
0x00000004ff177819ULL, 0x102fe4000001169dULL, 0x000000071e1e7812ULL, 0x000fe400078ef89dULL,
0x000000079d0b7812ULL, 0x000fc600078ec0ffULL, 0x00000001171d7824ULL, 0x000fe400078e021eULL,
0x000000101e0a7824ULL, 0x000fca00078e00ffULL, 0xfffffff00a057812ULL, 0x000fca00078ee21dULL,
0x0000001005647824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000101e1a7812ULL, 0x040fe200078efcffULL,
0x00000008170a7824ULL, 0x040fe200078e00ffULL, 0x00000003ff1c7819ULL, 0x000fe2000001169dULL,
0x000000101e0d7824ULL, 0x000fe200078e00ffULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x0000000117177824ULL, 0x000fe200078e021aULL, 0xfffffff80a0b7812ULL, 0x000fe200078ee20bULL,
0x000000101a0e7824ULL, 0x000fe200078e00ffULL, 0x000000021d0a7810ULL, 0x000fe20007ffe0ffULL,
0x00004000021b7824ULL, 0x000fe200078e00ffULL, 0x000000011c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000080b187824ULL, 0x040fe200078e00ffULL, 0xfffffff00e097812ULL, 0x000fe200078ee217ULL,
0x000000080b247824ULL, 0x000fe200078e00ffULL, 0xfffffff00d107812ULL, 0x000fe200078ee20aULL,
0x000000080b727824ULL, 0x040fe200078e00ffULL, 0x000000100b7c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010093c7824ULL, 0x000fe200078e00ffULL, 0x000000200b097810ULL, 0x040fe20007ffe0ffULL,
0x0000001010547824ULL, 0x000fe200078e00ffULL, 0x000000300b0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c167824ULL, 0x040fe200078e027cULL, 0x0000000b0c057210ULL, 0x040fe20007ffe0ffULL,
0x000000010c157824ULL, 0x040fe200078e0209ULL, 0x000020001b197810ULL, 0x000fe20007ffe0ffULL,
0x000000010c147824ULL, 0x000fe200078e020aULL, 0xfffffff818187812ULL, 0x000fe200078ee205ULL,
0x000000087c0f7824ULL, 0x000fe200078e00ffULL, 0x00000002170d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x000000080a137824ULL, 0x000fe200078e00ffULL, 0xfffffff80f167812ULL, 0x000fe200078ee216ULL,
0x0000001018607824ULL, 0x000fe200078e0219ULL, 0xfffffff80c157812ULL, 0x000fe200078ee215ULL,
0x0000000809297824ULL, 0x000fe200078e00ffULL, 0xfffffff813147812ULL, 0x000fe200078ee214ULL,
0x00000010160c7824ULL, 0x000fe200078e0219ULL, 0xfffffff00e117812ULL, 0x000fe200078ee20dULL,
0x0000001015787824ULL, 0x100fe200078e0219ULL, 0x000000006060783bULL, 0x000e620000000200ULL,
0x0000001014687824ULL, 0x000fe200078e0219ULL, 0x0000000205137810ULL, 0x040fe20007ffe0ffULL,
0x000000087c257824ULL, 0x000fe200078e00ffULL, 0x000000000c0c783bULL, 0x000ea20000000200ULL,
0x0000002205107810ULL, 0x040fe20007ffe0ffULL, 0x000000080a2b7824ULL, 0x000fe200078e00ffULL,
0x0000001205127810ULL, 0x000fe20007ffe0ffULL, 0x000000007878783bULL, 0x000ee20000000200ULL,
0xfffffff824137812ULL, 0x000fe200078ee213ULL, 0x0000001011247824ULL, 0x000fe200078e00ffULL,
0x0000003205287810ULL, 0x000fe20007ffe0ffULL, 0x000000006868783bULL, 0x000f220000000200ULL,
0xfffffff829117812ULL, 0x000fe200078ee210ULL, 0x0000001013387824ULL, 0x100fe200078e0219ULL,
0xfffffff825127812ULL, 0x000fe200078ee212ULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0xfffffff82b107812ULL, 0x000fe200078ee228ULL, 0x0000001011747824ULL, 0x100fe200078e0219ULL,
0x0000002605877810ULL, 0x000fe20007ffe0ffULL, 0x00000010125c7824ULL, 0x100fe200078e0219ULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x0000001010287824ULL, 0x000fc400078e0219ULL,
0x000000087c887824ULL, 0x000fe200078e00ffULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x00000008098a7824ULL, 0x000fe400078e00ffULL, 0x000000080a8c7824ULL, 0x000fe200078e00ffULL,
0x000000005c5c783bULL, 0x000ea80000000200ULL, 0x000000007474783bULL, 0x000ee80000000200ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x00000060642c723cULL, 0x082f7000000418ffULL,
0x000000603c30723cULL, 0x000f7000000418ffULL, 0x000000626434723cULL, 0x080f7000000418ffULL,
0x000000623c60723cULL, 0x000f7000000418ffULL, 0x0000000c6440723cULL, 0x044f7000000418ffULL,
0x0000000e6444723cULL, 0x040f7000000418ffULL, 0x000000786448723cULL, 0x048f7000000418ffULL,
0x0000007a644c723cULL, 0x040f7000000418ffULL, 0x000000686450723cULL, 0x050f7000000418ffULL,
0x0000006a6464723cULL, 0x000f7000000418ffULL, 0x0000000c3c58723cULL, 0x040f7000000418ffULL,
0x0000000e3c0c723cULL, 0x000ff000000418ffULL, 0x00000038542c723cULL, 0x0a0ff0000004182cULL,
0x000000382430723cULL, 0x000ff00000041830ULL, 0x0000003a5434723cULL, 0x080ff00000041834ULL,
0x0000003a2438723cULL, 0x000ff00000041860ULL, 0x000000783c60723cULL, 0x040f7000000418ffULL,
0x0000007a3c78723cULL, 0x040f7000000418ffULL, 0x000000683c80723cULL, 0x040b6e00000418ffULL,
0x000000101a687824ULL, 0x060fe200078e00ffULL, 0x0000006a3c3c723cULL, 0x000b6200000418ffULL,
0x000000101a697824ULL, 0x000fcc00078e00ffULL, 0x000000101e6a7824ULL, 0x060fe200078e00ffULL,
0x0000005c5440723cULL, 0x040f700000041840ULL, 0x0000005e5444723cULL, 0x040ff00000041844ULL,
0x000000745448723cULL, 0x040ff00000041848ULL, 0x00000076544c723cULL, 0x040ff0000004184cULL,
0x000000285450723cULL, 0x040ff00000041850ULL, 0x0000002a5454723cULL, 0x000bee0000041864ULL,
0x000000101e677824ULL, 0x020fe200078e00ffULL, 0x0000005c2458723cULL, 0x000b620000041858ULL,
0x000000061d657810ULL, 0x000fc40007ffe0ffULL, 0x0000000617667810ULL, 0x000fe40007ffe0ffULL,
0xfffffff06a857812ULL, 0x000fe400078ee265ULL, 0x000000041d5c7810ULL, 0x020fe20007ffe0ffULL,
0x000000742460723cULL, 0x040fe20000041860ULL, 0x00000004175d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001085857824ULL, 0x000fe200078e00ffULL, 0xfffffff067647812ULL, 0x000fe200078ee25cULL,
0x000000087c677824ULL, 0x000fe200078e00ffULL, 0xfffffff068657812ULL, 0x000fe200078ee25dULL,
0x0000000809687824ULL, 0x000fe200078e00ffULL, 0xfffffff069867812ULL, 0x000fe200078ee266ULL,
0x0000005e245c723cULL, 0x040be2000004180cULL, 0x000000080a697824ULL, 0x000fe200078e00ffULL,
0x0000001605097810ULL, 0x000fe20007ffe0ffULL, 0x000000080b667824ULL, 0x000fe200078e00ffULL,
0x00000006050b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001064647824ULL, 0x000fe200078e00ffULL,
0xfffffff8880a7812ULL, 0x000fe200078ee209ULL, 0x00000010656c7824ULL, 0x000fe200078e00ffULL,
0x00000014050e7810ULL, 0x060fe20007ffe0ffULL, 0x000000762474723cULL, 0x000fe20000041878ULL,
0x00000034050c7810ULL, 0x000fe20007ffe0ffULL, 0x000000100a907824ULL, 0x000fe200078e0219ULL,
0xfffffff8670e7812ULL, 0x000fe200078ee20eULL, 0x000000006c6c783bULL, 0x000fe20000000200ULL,
0xfffffff8690c7812ULL, 0x000fc400078ee20cULL, 0x00000004050f7810ULL, 0x040fe20007ffe0ffULL,
0x000000100e707824ULL, 0x000fe200078e0219ULL, 0xfffffff8720b7812ULL, 0x000fe200078ee20bULL,
0x000000100c7d7824ULL, 0x000fe200078e0219ULL, 0xfffffff8660f7812ULL, 0x000fe200078ee20fULL,
0x000000282480723cULL, 0x040b620000041880ULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x00000024050d7810ULL, 0x000fe20007ffe0ffULL, 0x000000100b887824ULL, 0x000fe200078e0219ULL,
0x0000003605057810ULL, 0x000fe20007ffe0ffULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0xfffffff8680d7812ULL, 0x000fe200078ee20dULL, 0x000000100f687824ULL, 0x000fe200078e0219ULL,
0xfffffff88c057812ULL, 0x000fe200078ee205ULL, 0x000000007d7c783bULL, 0x000ea20000000200ULL,
0x00000010868c7824ULL, 0x000fe200078e00ffULL, 0xfffffff88a097812ULL, 0x000fe200078ee287ULL,
0x000000100d847824ULL, 0x100fe200078e0219ULL, 0x000000006868783bULL, 0x000ee20000000200ULL,
0x0000001005287824ULL, 0x120fe200078e0219ULL, 0x0000002a243c723cULL, 0x000b62000004183cULL,
0x0000001009947824ULL, 0x000fe200078e0219ULL, 0x000000008478783bULL, 0x000f280000000200ULL,
0x000000008584783bULL, 0x000fe80000000200ULL, 0x000000008c8c783bULL, 0x000fe80000000200ULL,
0x000000009090783bULL, 0x000ee80000000200ULL, 0x000000002824783bULL, 0x020ee80000000200ULL,
0x000000008888783bULL, 0x000ee80000000200ULL, 0x000000009494783bULL, 0x000f220000000200ULL,
0x000000706440723cULL, 0x082f700000041840ULL, 0x000000706c58723cULL, 0x000f700000041858ULL,
0x0000007c6450723cULL, 0x084f700000041850ULL, 0x0000007c6c80723cULL, 0x000f700000041880ULL,
0x00000068642c723cULL, 0x088f70000004182cULL, 0x000000686c30723cULL, 0x000f700000041830ULL,
0x0000006a6434723cULL, 0x080f700000041834ULL, 0x0000006a6c38723cULL, 0x000f700000041838ULL,
0x000000726444723cULL, 0x040f700000041844ULL, 0x000000786448723cULL, 0x050f700000041848ULL,
0x0000007a644c723cULL, 0x040f70000004184cULL, 0x0000007e6454723cULL, 0x000f700000041854ULL,
0x000000726c5c723cULL, 0x040f70000004185cULL, 0x000000786c60723cULL, 0x040f700000041860ULL,
0x0000007a6c74723cULL, 0x040f700000041874ULL, 0x0000007e6c3c723cULL, 0x000f70000004183cULL,
0x000000908440723cULL, 0x0a0f700000041840ULL, 0x000000908c58723cULL, 0x000b6e0000041858ULL,
0x0000030004907a10ULL, 0x020fe20007ffe0ffULL, 0x000000248450723cULL, 0x080f700000041850ULL,
0x000000248c80723cULL, 0x000b6e0000041880ULL, 0x0000000190247810ULL, 0x060fe20007ffe0ffULL,
0x0000010090257824ULL, 0x000fe200078e029fULL, 0x00000088842c723cULL, 0x000f64000004182cULL,
0x000000072400720cULL, 0x000fcc0003f06070ULL, 0x000000888c30723cULL, 0x000f700000041830ULL,
0x0000008a8434723cULL, 0x080f700000041834ULL, 0x0000008a8c38723cULL, 0x000f700000041838ULL,
0x000000928444723cULL, 0x040f700000041844ULL, 0x000000948448723cULL, 0x040f700000041848ULL,
0x00000096844c723cULL, 0x040f70000004184cULL, 0x000000268454723cULL, 0x000f700000041854ULL,
0x000000928c5c723cULL, 0x040f70000004185cULL, 0x000000948c60723cULL, 0x040f700000041860ULL,
0x000000968c74723cULL, 0x040f700000041874ULL, 0x000000268c3c723cULL, 0x000b6e000004183cULL,
0x0000680000277a24ULL, 0x020fe200078e0225ULL, 0x00000c4000008947ULL, 0x000fca0003800000ULL,
0x000000011c247824ULL, 0x040fe200078e029dULL, 0x000000081c647810ULL, 0x000fc40007ffe0ffULL,
0x0000002506297217ULL, 0x000fe40007800000ULL, 0x000000041c2a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001642b7824ULL, 0x040fe200078e029dULL, 0x000000071f267812ULL, 0x000fe200078ef824ULL,
0x00000008646e7824ULL, 0x000fe200078e00ffULL, 0x000000101c6c7810ULL, 0x040fe20007ffe0ffULL,
0x000000011c247824ULL, 0x040fe200078e0227ULL, 0x000000141c787810ULL, 0x000fe20007ffe0ffULL,
0x0000000129297824ULL, 0x000fe200078e0a25ULL, 0xfffffff86e6e7812ULL, 0x000fe200078ee22bULL,
0x000000012a287824ULL, 0x000fe200078e029dULL, 0x0000000c1c6a7810ULL, 0x000fe20007ffe0ffULL,
0x000000082a657824ULL, 0x040fe200078e00ffULL, 0x000000292a00720cULL, 0x080fe20003f46070ULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x000000296400720cULL, 0x000fc40003f66070ULL,
0xfffffff865287812ULL, 0x000fe200078ee228ULL, 0x000000016c2b7824ULL, 0x000fe200078e029dULL,
0x0000002024667212ULL, 0x000fe200078efcffULL, 0x000000086c727824ULL, 0x000fe200078e00ffULL,
0x000000181c7c7810ULL, 0x000fe20007ffe0ffULL, 0x000000012a2a7824ULL, 0x000fe200078e0227ULL,
0x0000640066667a10ULL, 0x000fe20007f1e0ffULL, 0x0000000178247824ULL, 0x000fe200078e029dULL,
0xfffffff872727812ULL, 0x000fe200078ee22bULL, 0x0000000878657824ULL, 0x000fe200078e00ffULL,
0x0000650025677a10ULL, 0x000fe200007fe4ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x000000296c00720cULL, 0x000fc40003f86070ULL, 0xfffffff8657a7812ULL, 0x000fe200078ee224ULL,
0x0000000164247824ULL, 0x100fe200078e0227ULL, 0x000000202a687212ULL, 0x000fe200078efcffULL,
0x000000016a647824ULL, 0x040fe200078e0227ULL, 0x000000296a00720cULL, 0x0c0fe20003fa6070ULL,
0x000000016a1f7824ULL, 0x000fe200078e029dULL, 0x0000640068687a10ULL, 0x000fe20007f1e0ffULL,
0x000000086a707824ULL, 0x000fe200078e00ffULL, 0x000000291c00720cULL, 0x000fe20003f26070ULL,
0x0000010064647825ULL, 0x000fe200078e00ffULL, 0x000065002b697a10ULL, 0x000fc400007fe4ffULL,
0xfffffff870707812ULL, 0x000fe200078ee21fULL, 0x000000016c2a7824ULL, 0x000fe200078e0227ULL,
0x00000020646c7212ULL, 0x080fe200078efcffULL, 0x0000010024247825ULL, 0x000fe200078e00ffULL,
0x000000201c847810ULL, 0x000fe40007ffe0ffULL, 0x000064006c6c7a10ULL, 0x000fe20007fde0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000020246a7212ULL, 0x080fe400078efcffULL,
0x00006500656d7a10ULL, 0x000fe200037fe4ffULL, 0x000000017c1f7824ULL, 0x000fe200078e029dULL,
0x000000202a247212ULL, 0x000fe200078efcffULL, 0x000000087c7e7824ULL, 0x000fe200078e00ffULL,
0x000064006a6a7a10ULL, 0x000fe20007f1e0ffULL, 0x00000001782a7824ULL, 0x100fe200078e0227ULL,
0x0000640024247a10ULL, 0x000fe20007fde0ffULL, 0x000000017c647824ULL, 0x000fe200078e0227ULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee21fULL, 0x00000010261f7824ULL, 0x100fe200078e0219ULL,
0x0000001c1c267810ULL, 0x000fe20007ffe0ffULL, 0x000000106e717824ULL, 0x000fe200078e0219ULL,
0x00006500256b7a10ULL, 0x000fe200007fe4ffULL, 0x00000001846f7824ULL, 0x100fe200078e029dULL,
0x000000297800720cULL, 0x080fe20003f06070ULL, 0x0000000126657824ULL, 0x040fe200078e029dULL,
0x000065002b257a10ULL, 0x000fe200037fe4ffULL, 0x0000000826787824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000661f7faeULL, 0x0003e2000c901c46ULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x000000297c00720cULL, 0x000fc40003f26070ULL,
0xfffffff878787812ULL, 0x000fe200078ee265ULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x000000202a2a7212ULL, 0x000fc600078efcffULL, 0x00000008847c7824ULL, 0x000fe200078e00ffULL,
0x000064002a2a7a10ULL, 0x000fe20007fde0ffULL, 0x00000010281f7824ULL, 0x002fe200078e0219ULL,
0x00000020646e7212ULL, 0x000fe200078efcffULL, 0x0000000126667824ULL, 0x140fe200078e0227ULL,
0x000065002b2b7a10ULL, 0x000fe400037fe4ffULL, 0x00000000681f7faeULL, 0x0003e2000d101c46ULL,
0x000000292600720cULL, 0x000fe20003f46070ULL, 0x0000000184267824ULL, 0x000fe200078e0227ULL,
0x000064006e6e7a10ULL, 0x000fe20007fde0ffULL, 0x0000010066667825ULL, 0x000fe200078e00ffULL,
0x000000006a717faeULL, 0x0005e2000d901c46ULL, 0xfffffff87c287812ULL, 0x000fc400078ee26fULL,
0x00006500656f7a10ULL, 0x000fe400037fe4ffULL, 0x0000002066647212ULL, 0x080fe200078efcffULL,
0x00000010701f7824ULL, 0x002fe200078e0219ULL, 0x000000241c707810ULL, 0x000fe20007ffe0ffULL,
0x0000010026687825ULL, 0x000fe200078e00ffULL, 0x0000640064647a10ULL, 0x000fe40007fde0ffULL,
0x000000006c1f7faeULL, 0x0003e2000e901c46ULL, 0x0000000170267824ULL, 0x040fe200078e029dULL,
0x000000297000720cULL, 0x040fe20003fa6070ULL, 0x00000008706b7824ULL, 0x004fe200078e00ffULL,
0x0000002068667212ULL, 0x000fe200078efcffULL, 0x00000001706a7824ULL, 0x000fe200078e0227ULL,
0x0000650067657a10ULL, 0x000fe200037fe4ffULL, 0x0000001072717824ULL, 0x000fe200078e0219ULL,
0xfffffff86b707812ULL, 0x000fe200078ee226ULL, 0x000001006a6a7825ULL, 0x000fe200078e00ffULL,
0x000000281c267810ULL, 0x000fc40007ffe0ffULL, 0x0000640066667a10ULL, 0x000fe20007fde0ffULL,
0x0000000024717faeULL, 0x0005e2000e101c46ULL, 0x000000206a6c7212ULL, 0x002fe200078efcffULL,
0x00000001261f7824ULL, 0x040fe200078e029dULL, 0x000000292600720cULL, 0x040fe20003f86070ULL,
0x0000000826727824ULL, 0x000fe200078e00ffULL, 0x0000002c1c6a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000126267824ULL, 0x100fe200078e0227ULL, 0x0000650069677a10ULL, 0x000fe400037fe4ffULL,
0x000064006c6c7a10ULL, 0x000fe20007fde0ffULL, 0x000000016a687824ULL, 0x000fe200078e0227ULL,
0xfffffff872727812ULL, 0x000fe200078ee21fULL, 0x0000010026247825ULL, 0x004fe200078e00ffULL,
0x000065006b6d7a10ULL, 0x000fc400037fe4ffULL, 0x000000301c7c7810ULL, 0x000fe20007ffe0ffULL,
0x000000107a1f7824ULL, 0x000fe200078e0219ULL, 0x0000002024247212ULL, 0x000fe200078efcffULL,
0x000000016a267824ULL, 0x100fe200078e029dULL, 0x000000298400720cULL, 0x080fe20003f66070ULL,
0x000000086a6b7824ULL, 0x000fe200078e00ffULL, 0x000000002a1f7faeULL, 0x0003e2000c101c46ULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x000000296a00720cULL, 0x000fe40003f06070ULL,
0xfffffff86b7a7812ULL, 0x000fe200078ee226ULL, 0x000000017c267824ULL, 0x000fe200078e029dULL,
0x0000640024247a10ULL, 0x000fe20007fde0ffULL, 0x000000087c717824ULL, 0x000fc400078e00ffULL,
0x000000017c6a7824ULL, 0x000fe200078e0227ULL, 0x0000650025257a10ULL, 0x000fe200037fe4ffULL,
0x000000107e1f7824ULL, 0x002fe200078e0219ULL, 0x00000020682a7212ULL, 0x000fe200078efcffULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0x000000341c7e7810ULL, 0x000fe40007ffe0ffULL,
0x000000006e1f7faeULL, 0x0003e2000c901c46ULL, 0x000000297c00720cULL, 0x000fe40003f26070ULL,
0x000064002a2a7a10ULL, 0x000fe20007fde0ffULL, 0x000000017e687824ULL, 0x000fe200078e0227ULL,
0xfffffff8717c7812ULL, 0x000fe200078ee226ULL, 0x0000001078717824ULL, 0x000fe200078e0219ULL,
0x000000381c267810ULL, 0x000fc40007ffe0ffULL, 0x00006500692b7a10ULL, 0x000fe200037fe4ffULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x000000206a6a7212ULL, 0x080fe200078efcffULL,
0x0000000064717faeULL, 0x0005e2000d101c46ULL, 0x0000003c1c6e7810ULL, 0x002fe20007ffe0ffULL,
0x00000010281f7824ULL, 0x100fe200078e0219ULL, 0x000064006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x00000010706f7824ULL, 0x000fe200078e0219ULL, 0x000000296e00720cULL, 0x080fe20003f46070ULL,
0x0000000126287824ULL, 0x140fe200078e0227ULL, 0x00000000661f7faeULL, 0x0003e2000d901c46ULL,
0x000000292600720cULL, 0x080fe20003f66070ULL, 0x000000016e277824ULL, 0x000fe200078e0227ULL,
0x0000002068687212ULL, 0x000fe200078efcffULL, 0x000000006c6f7faeULL, 0x0007e2000e901c46ULL,
0x000000297e00720cULL, 0x000fe20003fa6070ULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x000065006b6b7a10ULL, 0x000fc400037fe4ffULL, 0x0000640068687a10ULL, 0x000fe20007fde0ffULL,
0x000000017e1c7824ULL, 0x100fe200078e029dULL, 0x0000000326647819ULL, 0x044fe200000006ffULL,
0x00000001261f7824ULL, 0x102fe200078e029dULL, 0x0000002028287212ULL, 0x080fe200078efcffULL,
0x0000010027267825ULL, 0x000fe200078e00ffULL, 0x0000650069697a10ULL, 0x000fe400037fe4ffULL,
0x0000640028287a10ULL, 0x000fe20007fde0ffULL, 0x000000087e677824ULL, 0x000fe200078e00ffULL,
0x0000002026207212ULL, 0x000fe200078efcffULL, 0x000000016e657824ULL, 0x000fe200078e029dULL,
0xfffffff864647812ULL, 0x000fe200078ee21fULL, 0x000000086e667824ULL, 0x000fe200078e00ffULL,
0xfffffff8671c7812ULL, 0x000fe200078ee21cULL, 0x00000010721f7824ULL, 0x100fe200078e0219ULL,
0x0000650029297a10ULL, 0x000fe200037fe4ffULL, 0x000000107c677824ULL, 0x000fe200078e0219ULL,
0xfffffff866667812ULL, 0x000fe200078ee265ULL, 0x000000107a657824ULL, 0x100fe200078e0219ULL,
0x0000640020267a10ULL, 0x000fe20007fde0ffULL, 0x000000101c6d7824ULL, 0x108fe200078e0219ULL,
0x00000000241f7faeULL, 0x0003e2000e101c46ULL, 0x00000010646f7824ULL, 0x100fe200078e0219ULL,
0x0000650027277a10ULL, 0x000fe200037fe4ffULL, 0x0000001066197824ULL, 0x000fe200078e0219ULL,
0x000000002a657faeULL, 0x0003e8000c101c46ULL, 0x000000006a677faeULL, 0x0003e8000c901c46ULL,
0x00000000686d7faeULL, 0x0003e8000e901c46ULL, 0x00000000286f7faeULL, 0x0003e8000d901c46ULL,
0x0000000026197faeULL, 0x0003e2000d101c46ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x000000081c647810ULL, 0x040fe20007ffe0ffULL, 0x000000011c247824ULL, 0x040fe200078e029dULL,
0x0000000c1c687810ULL, 0x000fc40007ffe0ffULL, 0x000000041c287810ULL, 0x000fe20007ffe0ffULL,
0x0000000164297824ULL, 0x100fe200078e029dULL, 0x000000141c707810ULL, 0x000fe20007ffe0ffULL,
0x0000000864667824ULL, 0x000fe200078e00ffULL, 0x0000001c1c7c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001682b7824ULL, 0x100fe200078e029dULL, 0x000000101c6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008686a7824ULL, 0x000fe200078e00ffULL, 0x000000071f267812ULL, 0x000fe200078ef824ULL,
0x0000000128257824ULL, 0x000fe200078e029dULL, 0xfffffff866667812ULL, 0x000fe200078ee229ULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee22bULL,
0x0000000170247824ULL, 0x100fe200078e029dULL, 0x000000181c787810ULL, 0x000fe20007ffe0ffULL,
0x00000008702b7824ULL, 0x000fe200078e00ffULL, 0x000000241c887810ULL, 0x000fe20007ffe0ffULL,
0x000000017c297824ULL, 0x100fe200078e029dULL, 0x0000002c1c927810ULL, 0x000fe20007ffe0ffULL,
0x000000087c7e7824ULL, 0x000fe200078e00ffULL, 0x000000201c847810ULL, 0x000fe20007ffe0ffULL,
0x000000016c1f7824ULL, 0x000fe200078e029dULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee225ULL,
0x000000086c6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b727812ULL, 0x000fe200078ee224ULL,
0x0000000178257824ULL, 0x000fe200078e029dULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee229ULL,
0x00000008787a7824ULL, 0x000fe200078e00ffULL, 0x000000281c8c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000188247824ULL, 0x000fe200078e029dULL, 0xfffffff86e6e7812ULL, 0x000fe200078ee21fULL,
0x00000008882b7824ULL, 0x000fe200078e00ffULL, 0x000000301c967810ULL, 0x000fe20007ffe0ffULL,
0x0000000192297824ULL, 0x100fe200078e029dULL, 0x000000341ca07810ULL, 0x000fe20007ffe0ffULL,
0x0000000892947824ULL, 0x000fe200078e00ffULL, 0x000000381ca27810ULL, 0x000fe20007ffe0ffULL,
0x00000001841f7824ULL, 0x000fe200078e029dULL, 0x0000003c1ca47810ULL, 0x000fe20007ffe0ffULL,
0x0000000884867824ULL, 0x000fe200078e00ffULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee225ULL,
0x000000018c257824ULL, 0x040fe200078e029dULL, 0xfffffff82b8a7812ULL, 0x000fe200078ee224ULL,
0x000000088c8e7824ULL, 0x000fe200078e00ffULL, 0xfffffff894947812ULL, 0x000fe200078ee229ULL,
0x0000000164297824ULL, 0x000fe200078e0227ULL, 0xfffffff886867812ULL, 0x000fe200078ee21fULL,
0x00000001682b7824ULL, 0x000fe200078e0227ULL, 0xfffffff88e8e7812ULL, 0x000fe200078ee225ULL,
0x000000011c247824ULL, 0x000fc400078e0227ULL, 0x000000016c647824ULL, 0x100fe400078e0227ULL,
0x0000000170677824ULL, 0x100fe400078e0227ULL, 0x0000000178687824ULL, 0x100fe400078e0227ULL,
0x000000017c6b7824ULL, 0x100fe400078e0227ULL, 0x0000000128287824ULL, 0x100fe400078e0227ULL,
0x00000001846c7824ULL, 0x000fc400078e0227ULL, 0x00000001886f7824ULL, 0x100fe400078e0227ULL,
0x000000018c707824ULL, 0x100fe400078e0227ULL, 0x0000000192737824ULL, 0x100fe400078e0227ULL,
0x0000000196787824ULL, 0x100fe400078e0227ULL, 0x00000001a07b7824ULL, 0x040fe400078e0227ULL,
0x00000001a01f7824ULL, 0x000fc400078e029dULL, 0x00000008a07c7824ULL, 0x000fe400078e00ffULL,
0x00000001a27d7824ULL, 0x100fe400078e0227ULL, 0x00000001a47f7824ULL, 0x000fe200078e0227ULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee21fULL, 0x00000001a2277824ULL, 0x040fe400078e029dULL,
0x00000008a2847824ULL, 0x000fe400078e00ffULL, 0x0000010024247825ULL, 0x000fc600078e00ffULL,
0xfffffff884847812ULL, 0x000fe200078ee227ULL, 0x00000010261f7824ULL, 0x000fe200078e0219ULL,
0x0000002024247212ULL, 0x000fe200078efcffULL, 0x0000010028267825ULL, 0x000fc600078e00ffULL,
0x0000640024247a10ULL, 0x000fe20007f1e0ffULL, 0x0000010029287825ULL, 0x000fe200078e00ffULL,
0x0000002026267212ULL, 0x080fe400078efcffULL, 0x0000650025257a10ULL, 0x000fe200007fe4ffULL,
0x000000102a857824ULL, 0x100fe200078e0219ULL, 0x0000002028287212ULL, 0x080fe200078efcffULL,
0x000001002b2a7825ULL, 0x000fe200078e00ffULL, 0x0000640026267a10ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000241f7faeULL, 0x0003e2000b901c46ULL,
0x0000640028287a10ULL, 0x000fe20007f1e0ffULL, 0x0000001066877824ULL, 0x000fe200078e0219ULL,
0x000000202a2a7212ULL, 0x000fe200078efcffULL, 0x0000010067667825ULL, 0x000fe200078e00ffULL,
0x0000650029297a10ULL, 0x000fc400007fe4ffULL, 0x000064002a2a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000106a897824ULL, 0x000fe200078e0219ULL, 0x0000002066667212ULL, 0x080fe200078efcffULL,
0x00000001a4657824ULL, 0x040fe200078e029dULL, 0x000065002b2b7a10ULL, 0x000fe200007fe4ffULL,
0x00000008a4887824ULL, 0x000fe200078e00ffULL, 0x0000640066667a10ULL, 0x000fe20007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e00ffULL, 0x0000650027277a10ULL, 0x000fe40000ffe4ffULL,
0xfffffff888887812ULL, 0x000fe200078ee265ULL, 0x00000001961c7824ULL, 0x000fe200078e029dULL,
0x000000206a6a7212ULL, 0x080fe200078efcffULL, 0x0000000896697824ULL, 0x000fe200078e00ffULL,
0x0000650067677a10ULL, 0x000fe200007fe4ffULL, 0x000000106e8b7824ULL, 0x100fe200078e0219ULL,
0x000064006a6a7a10ULL, 0x000fe20007f1e0ffULL, 0x000001006f6e7825ULL, 0x000fe200078e00ffULL,
0xfffffff8691c7812ULL, 0x000fe200078ee21cULL, 0x0000000026857faeULL, 0x0003e2000b901c46ULL,
0x000065006b6b7a10ULL, 0x000fe200007fe4ffULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x000000206e6e7212ULL, 0x080fe200078efcffULL, 0x0000000028877faeULL, 0x0003e4000b901c46ULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x0000002064647212ULL, 0x080fe200078efcffULL,
0x000000002a897faeULL, 0x0003e2000b901c46ULL, 0x000064006e6e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000010728d7824ULL, 0x000fe200078e0219ULL, 0x0000002068687212ULL, 0x000fe200078efcffULL,
0x0000010073727825ULL, 0x000fe200078e00ffULL, 0x0000640064647a10ULL, 0x000fc40007f3e0ffULL,
0x0000640068687a10ULL, 0x000fe20007f5e0ffULL, 0x000001006c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002072727212ULL, 0x080fe400078efcffULL, 0x000065006f6f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010070707825ULL, 0x000fe200078e00ffULL, 0x000000206c6c7212ULL, 0x080fe400078efcffULL,
0x0000650065657a10ULL, 0x000fe20000ffe4ffULL, 0x000000107a8f7824ULL, 0x100fe200078e0219ULL,
0x0000002070707212ULL, 0x080fe200078efcffULL, 0x0000010078787825ULL, 0x000fe200078e00ffULL,
0x0000640072727a10ULL, 0x000fe20007f1e0ffULL, 0x00000000648b7faeULL, 0x0003e2000b901c46ULL,
0x0000650069697a10ULL, 0x000fe200017fe4ffULL, 0x000000107ca57824ULL, 0x100fe200078e0219ULL,
0x000064006c6c7a10ULL, 0x000fe20007f3e0ffULL, 0x000001007b7a7825ULL, 0x000fe200078e00ffULL,
0x0000002078787212ULL, 0x080fe200078efcffULL, 0x00000000668d7faeULL, 0x0003e2000b901c46ULL,
0x0000640070707a10ULL, 0x000fe20007f5e0ffULL, 0x000000107e917824ULL, 0x100fe200078e0219ULL,
0x000000207a7a7212ULL, 0x080fe200078efcffULL, 0x000001007d7c7825ULL, 0x000fe200078e00ffULL,
0x0000650073737a10ULL, 0x000fe200007fe4ffULL, 0x00000000688f7faeULL, 0x0003e2000b901c46ULL,
0x000065006d6d7a10ULL, 0x000fe20000ffe4ffULL, 0x000001007f7e7825ULL, 0x000fe200078e00ffULL,
0x000000207c7c7212ULL, 0x080fe200078efcffULL, 0x000000006a917faeULL, 0x0003e2000b901c46ULL,
0x0000640078787a10ULL, 0x000fe20007f1e0ffULL, 0x0000001086937824ULL, 0x100fe200078e0219ULL,
0x000000207e207212ULL, 0x000fe200078efcffULL, 0x000000108a957824ULL, 0x100fe200078e0219ULL,
0x0000650071717a10ULL, 0x000fe200017fe4ffULL, 0x000000108e977824ULL, 0x100fe200078e0219ULL,
0x000064007a7a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000001094a17824ULL, 0x100fe200078e0219ULL,
0x000064007c7c7a10ULL, 0x000fe20007f5e0ffULL, 0x000000101ca37824ULL, 0x100fe200078e0219ULL,
0x00006400207e7a10ULL, 0x000fe20007f7e0ffULL, 0x000000006c937faeULL, 0x0003e2000b901c46ULL,
0x0000650079797a10ULL, 0x000fe200007fe4ffULL, 0x0000001084a77824ULL, 0x100fe200078e0219ULL,
0x000065007b7b7a10ULL, 0x000fe20000ffe4ffULL, 0x000000006e957faeULL, 0x0003e2000b901c46ULL,
0x000065007d7d7a10ULL, 0x000fe200017fe4ffULL, 0x0000001088197824ULL, 0x000fe200078e0219ULL,
0x000065007f7f7a10ULL, 0x000fe20001ffe4ffULL, 0x0000000070977faeULL, 0x0003e8000b901c46ULL,
0x0000000072a17faeULL, 0x0003e8000b901c46ULL, 0x0000000078a37faeULL, 0x0003e8000b901c46ULL,
0x000000007aa57faeULL, 0x0003e8000b901c46ULL, 0x000000007ca77faeULL, 0x0003e8000b901c46ULL,
0x000000007e197faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000101e207824ULL, 0x000fe200078e00ffULL, 0x000000081d197810ULL, 0x002fe20007ffe0ffULL,
0x000000101a1f7824ULL, 0x000fe200078e00ffULL, 0x00000008171c7810ULL, 0x000fc40007ffe0ffULL,
0x000040001b1b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff020197812ULL, 0x000fe400078ee219ULL,
0xfffffff01f1c7812ULL, 0x000fe200078ee21cULL, 0x0000001016707824ULL, 0x100fe400078e021bULL,
0x0000001019197824ULL, 0x000fe400078e00ffULL, 0x000000101c1c7824ULL, 0x000fe400078e00ffULL,
0x00000010156c7824ULL, 0x000fc400078e021bULL, 0x0000001014687824ULL, 0x000fe200078e021bULL,
0x0000000a1d147810ULL, 0x000fe20007ffe0ffULL, 0x000000101e157824ULL, 0x000fe400078e00ffULL,
0x000000101a167824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001928783bULL, 0x000fe20000000200ULL, 0xfffffff015147812ULL, 0x000fe200078ee214ULL,
0x0000001012127824ULL, 0x100fe200078e021bULL, 0x0000000a17157810ULL, 0x000fe20007ffe0ffULL,
0x000000007070783bULL, 0x000e620000000200ULL, 0x0000001018247824ULL, 0x000fe400078e021bULL,
0xfffffff016157812ULL, 0x000fe200078ee215ULL, 0x000000001c64783bULL, 0x0004e20000000200ULL,
0x0000001014147824ULL, 0x000fe400078e00ffULL, 0x0000001013787824ULL, 0x000fe200078e021bULL,
0x000000002424783bULL, 0x000fe20000000200ULL, 0x0000001015157824ULL, 0x000fc400078e00ffULL,
0x0000001011887824ULL, 0x100fe200078e021bULL, 0x00000000147c783bULL, 0x0009e20000000200ULL,
0x00000010108c7824ULL, 0x100fe400078e021bULL, 0x000000100d1c7824ULL, 0x004fe200078e021bULL,
0x000000001210783bULL, 0x000ea20000000200ULL, 0x000000101e0d7824ULL, 0x000fc600078e00ffULL,
0x000000001584783bULL, 0x0008a40000000200ULL, 0x0000000c1d147810ULL, 0x010fe40007ffe0ffULL,
0x000000006c6c783bULL, 0x000f280000000200ULL, 0x000000006868783bULL, 0x000ea20000000200ULL,
0x000000101e157824ULL, 0x000fc600078e00ffULL, 0x000000007878783bULL, 0x000ea40000000200ULL,
0xfffffff015147812ULL, 0x000fe400078ee214ULL, 0x000000008888783bULL, 0x000f220000000200ULL,
0x000000702840723cULL, 0x082f660000041840ULL, 0x000000008c8c783bULL, 0x000e6a0000000200ULL,
0x000000706458723cULL, 0x008f700000041858ULL, 0x000000722844723cULL, 0x080f700000041844ULL,
0x00000072645c723cULL, 0x000f70000004185cULL, 0x000000107c40723cULL, 0x0a4ff00000041840ULL,
0x000000108458723cULL, 0x000bee0000041858ULL, 0x0000001014107824ULL, 0x020fe200078e00ffULL,
0x00000024282c723cULL, 0x000f62000004182cULL, 0x000000101a147824ULL, 0x000fc400078e00ffULL,
0x000000101a1a7824ULL, 0x000fca00078e00ffULL, 0x000000246430723cULL, 0x000bee0000041830ULL,
0x000000100f247824ULL, 0x020fe200078e021bULL, 0x0000000c170f7810ULL, 0x040fe20007ffe0ffULL,
0x000000262834723cULL, 0x000f620000041834ULL, 0x0000000e17177810ULL, 0x000fc40007ffe0ffULL,
0xfffffff0140f7812ULL, 0x000fe400078ee20fULL, 0xfffffff01a177812ULL, 0x000fc600078ee217ULL,
0x000000266438723cULL, 0x000b620000041838ULL, 0x000000100f707824ULL, 0x000fe200078e00ffULL,
0x000000002424783bULL, 0x020fe20000000200ULL, 0x0000001017177824ULL, 0x000fc800078e00ffULL,
0x000000007070783bULL, 0x000fe20000000200ULL, 0x0000006c2848723cULL, 0x050f660000041848ULL,
0x000000001714783bULL, 0x000fea0000000200ULL, 0x0000006e284c723cULL, 0x000f70000004184cULL,
0x0000006c6460723cULL, 0x040b6e0000041860ULL, 0x000000100a6c7824ULL, 0x120fe200078e021bULL,
0x0000006e6474723cULL, 0x040b6a0000041874ULL, 0x000000006c6c783bULL, 0x020fe60000000200ULL,
0x000000686480723cULL, 0x080f700000041880ULL, 0x000000682850723cULL, 0x040bee0000041850ULL,
0x000000100c687824ULL, 0x120fe200078e021bULL, 0x0000006a2854723cULL, 0x000be20000041854ULL,
0x000000100b0c7824ULL, 0x000fcc00078e021bULL, 0x000000100e287824ULL, 0x020fe200078e021bULL,
0x0000006a643c723cULL, 0x000b62000004183cULL, 0x0000000e1d0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000006868783bULL, 0x020fe60000000200ULL, 0xfffffff00d0e7812ULL, 0x000fe200078ee20eULL,
0x000000002828783bULL, 0x000fe40000000200ULL, 0x000000127c44723cULL, 0x000fe40000041844ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x000000100e647824ULL, 0x000fc600078e00ffULL,
0x000000000c0c783bULL, 0x000fe40000000200ULL, 0x00000012845c723cULL, 0x000be4000004185cULL,
0x000000001010783bULL, 0x020ea80000000200ULL, 0x000000006464783bULL, 0x000ee40000000200ULL,
0x000000787c2c723cULL, 0x040f70000004182cULL, 0x0000007a7c34723cULL, 0x000f700000041834ULL,
0x000000788430723cULL, 0x040f700000041830ULL, 0x0000007a8438723cULL, 0x000f700000041838ULL,
0x000000887c48723cULL, 0x040f700000041848ULL, 0x0000008a7c4c723cULL, 0x000f70000004184cULL,
0x000000888460723cULL, 0x040f700000041860ULL, 0x0000008a8474723cULL, 0x040f700000041874ULL,
0x0000008c8480723cULL, 0x042f700000041880ULL, 0x0000008e8484723cULL, 0x000bee000004183cULL,
0x00000010093c7824ULL, 0x120fe200078e021bULL, 0x0000008c7c50723cULL, 0x000f620000041850ULL,
0x00000010051b7824ULL, 0x000fc800078e021bULL, 0x000000003c3c783bULL, 0x000e660000000200ULL,
0x0000008e7c54723cULL, 0x000f620000041854ULL, 0x000000001b18783bULL, 0x000f2e0000000200ULL,
0x00000024102c723cULL, 0x044f70000004182cULL, 0x000000261034723cULL, 0x000f700000041834ULL,
0x000000247078723cULL, 0x040f700000041830ULL, 0x000000267038723cULL, 0x000f700000041838ULL,
0x000000281040723cULL, 0x040ff00000041840ULL, 0x0000002a1044723cULL, 0x040ff00000041844ULL,
0x0000001c1048723cULL, 0x040ff00000041848ULL, 0x0000001e104c723cULL, 0x000ff0000004184cULL,
0x000000287058723cULL, 0x040ff00000041858ULL, 0x0000001c7060723cULL, 0x040ff00000041860ULL,
0x0000002a705c723cULL, 0x040ff0000004185cULL, 0x0000001e7074723cULL, 0x040ff00000041874ULL,
0x000000687080723cULL, 0x080ff00000041880ULL, 0x000000681050723cULL, 0x020ff00000041850ULL,
0x0000006a7084723cULL, 0x080ff00000041884ULL, 0x0000006a1054723cULL, 0x000ff00000041854ULL,
0x0000000c6468723cULL, 0x048f70000004182cULL, 0x0000000e6470723cULL, 0x000f700000041834ULL,
0x0000000c1424723cULL, 0x040f700000041878ULL, 0x0000000e140c723cULL, 0x000f640000041838ULL,
0x3db504f368057820ULL, 0x020fc40000410000ULL, 0x3db504f369097820ULL, 0x000fe40000410000ULL,
0x3db504f36a6a7820ULL, 0x000fe40000410000ULL, 0x3db504f36b6b7820ULL, 0x000fe20000410000ULL,
0x0000006c6430723cULL, 0x000f620000041840ULL, 0x3db504f3700a7820ULL, 0x000fe40000410000ULL,
0x3db504f3710b7820ULL, 0x000fe40000410000ULL, 0x3db504f372207820ULL, 0x000fc40000410000ULL,
0x3db504f373737820ULL, 0x000fe20000410000ULL, 0x0000006e642c723cULL, 0x040b6e0000041844ULL,
0x3db504f324467820ULL, 0x020fe20000410000ULL, 0x0000003c6428723cULL, 0x002f620000041848ULL,
0x3db504f325477820ULL, 0x000fc40000410000ULL, 0x3db504f30c0c7820ULL, 0x000fe40000410000ULL,
0x3db504f30d0d7820ULL, 0x000fc60000410000ULL, 0x0000003e641c723cULL, 0x000b62000004184cULL,
0x3db504f330307820ULL, 0x000fe40000410000ULL, 0x3db504f331317820ULL, 0x000fe40000410000ULL,
0x3db504f332327820ULL, 0x000fe40000410000ULL, 0x3db504f30e4f7820ULL, 0x020fe20000410000ULL,
0x0000006c1434723cULL, 0x000f620000041858ULL, 0x3db504f333337820ULL, 0x000fe40000410000ULL,
0x3db504f32c2c7820ULL, 0x000fc40000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe40000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x0000003c1438723cULL, 0x040f620000041860ULL,
0x3db504f32f2f7820ULL, 0x000fe40000410000ULL, 0x3db504f328287820ULL, 0x000fe40000410000ULL,
0x3db504f3264c7820ULL, 0x000fe40000410000ULL, 0x3db504f3274e7820ULL, 0x000fe20000410000ULL,
0x0000006e146c723cULL, 0x000f62000004185cULL, 0x3db504f31c1c7820ULL, 0x000fc40000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe40000410000ULL, 0x3db504f31f447820ULL, 0x000fc60000410000ULL,
0x0000003e143c723cULL, 0x040f640000041874ULL, 0x3db504f3340e7820ULL, 0x020fe40000410000ULL,
0x3db504f335357820ULL, 0x000fe40000410000ULL, 0x3db504f3364d7820ULL, 0x000fe40000410000ULL,
0x000000181440723cULL, 0x010f620000041880ULL, 0x3db504f338387820ULL, 0x000fce0000410000ULL,
0x000000186410723cULL, 0x000b620000041850ULL, 0x3db504f36c6c7820ULL, 0x000fe40000410000ULL,
0x3db504f36d6d7820ULL, 0x000fe40000410000ULL, 0x3db504f36e6e7820ULL, 0x000fe40000410000ULL,
0x3db504f30f507820ULL, 0x020fe20000410000ULL, 0x0000001a1414723cULL, 0x000f620000041884ULL,
0x3db504f337517820ULL, 0x000fe40000410000ULL, 0x3db504f36f6f7820ULL, 0x000fc40000410000ULL,
0x3db504f3390f7820ULL, 0x000fe40000410000ULL, 0x3db504f33c487820ULL, 0x000fe20000410000ULL,
0x0000001a6464723cULL, 0x000b620000041854ULL, 0x3db504f33d3d7820ULL, 0x000fe40000410000ULL,
0x3db504f340407820ULL, 0x000fe40000410000ULL, 0x3db504f341497820ULL, 0x000fe40000410000ULL,
0x3db504f3291a7820ULL, 0x020fc40000410000ULL, 0x3db504f32a297820ULL, 0x000fe40000410000ULL,
0x3db504f32b2a7820ULL, 0x000fe40000410000ULL, 0x3db504f31e2b7820ULL, 0x000fe40000410000ULL,
0x3db504f310187820ULL, 0x000fe40000410000ULL, 0x3db504f3144a7820ULL, 0x000fe40000410000ULL,
0x3db504f311197820ULL, 0x000fc40000410000ULL, 0x3db504f312457820ULL, 0x000fe40000410000ULL,
0x3db504f313137820ULL, 0x000fe40000410000ULL, 0x3db504f364647820ULL, 0x000fe40000410000ULL,
0x3db504f3651b7820ULL, 0x000fe40000410000ULL, 0x3db504f366667820ULL, 0x000fe40000410000ULL,
0x3db504f367677820ULL, 0x000fc40000410000ULL, 0x3db504f33a547820ULL, 0x000fe40000410000ULL,
0x3db504f33b557820ULL, 0x000fe40000410000ULL, 0x3db504f33e567820ULL, 0x000fe40000410000ULL,
0x3db504f33f577820ULL, 0x000fe40000410000ULL, 0x3db504f342587820ULL, 0x000fe40000410000ULL,
0x3db504f343597820ULL, 0x000fc40000410000ULL, 0x3db504f3154b7820ULL, 0x000fe40000410000ULL,
0x3db504f316147820ULL, 0x000fe40000410000ULL, 0x3db504f3175a7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000099527f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1e7224ULL, 0x000fe200078e001cULL, 0x0000002c00127202ULL, 0x000fe20000000f00ULL,
0x000000ffff1c7224ULL, 0x000fe400078e001dULL, 0x000000ffff277224ULL, 0x000fc400078e002eULL,
0x000000ffff177224ULL, 0x000fe400078e0028ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0018ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0045ULL, 0x000000ffff377224ULL, 0x000fe400078e0046ULL,
0x000000ffff397224ULL, 0x000fe400078e0047ULL, 0x000000ffff107224ULL, 0x000fc400078e0030ULL,
0x000000ffff117224ULL, 0x000fe400078e0031ULL, 0x000000ffff157224ULL, 0x000fe400078e002dULL,
0x000000ffff187224ULL, 0x000fe400078e0019ULL, 0x000000ffff257224ULL, 0x000fe400078e0032ULL,
0x000000ffff267224ULL, 0x000fe400078e0033ULL, 0x000000ffff287224ULL, 0x000fc400078e002fULL,
0x000000ffff2c7224ULL, 0x000fe400078e0044ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0035ULL,
0x000000ffff437224ULL, 0x000fe400078e0038ULL, 0x000000ffff457224ULL, 0x000fe400078e0048ULL,
0x000000ffff467224ULL, 0x000fe400078e003dULL, 0x000000ffff477224ULL, 0x000fc400078e0040ULL,
0x000000ffff197224ULL, 0x000fe400078e0064ULL, 0x000000ffff167224ULL, 0x000fe400078e006aULL,
0x000000ffff1f7224ULL, 0x000fe400078e006bULL, 0x000000ffff247224ULL, 0x000fe400078e0073ULL,
0x000000ffff317224ULL, 0x000fe400078e0013ULL, 0x000000ffff347224ULL, 0x000fc400078e0066ULL,
0x000000ffff367224ULL, 0x000fe400078e0067ULL, 0x000000ffff3a7224ULL, 0x000fe400078e000cULL,
0x000000ffff3b7224ULL, 0x000fe400078e000dULL, 0x000000ffff3c7224ULL, 0x000fe400078e000eULL,
0x000000ffff417224ULL, 0x000fe400078e006cULL, 0x000000ffff427224ULL, 0x000fc400078e006dULL,
0x000000ffff447224ULL, 0x000fe400078e000fULL, 0x000000ffff487224ULL, 0x000fe400078e0051ULL,
0x000000ffff3d7224ULL, 0x000fe400078e006eULL, 0x000000ffff3e7224ULL, 0x000fe400078e006fULL,
0x000000ffff407224ULL, 0x000fe400078e0054ULL, 0x000000ffff307224ULL, 0x000fc400078e0055ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0056ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0057ULL,
0x000000ffff327224ULL, 0x000fe400078e0058ULL, 0x000000ffff337224ULL, 0x000fe400078e0059ULL,
0x000000ffff357224ULL, 0x000fe400078e0014ULL, 0x000000ffff387224ULL, 0x000fc400078e005aULL,
0x00000000000c7805ULL, 0x006fca0000015200ULL, 0x00000400990f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc40007804853ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000130e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400990f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804853ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000049d137824ULL, 0x000fe200078e00ffULL,
0x0000009e0400720cULL, 0x000fc80003f06070ULL, 0xfffffff0130d7812ULL, 0x000fca00078ec0ffULL,
0x0000008002147824ULL, 0x000fca00078e020dULL, 0x01e40000140c7984ULL, 0x0002a20000000c00ULL,
0x000021e000008947ULL, 0x000fea0003800000ULL, 0x00005a0000517b06ULL, 0x000ee20000209000ULL,
0x000000ffff527224ULL, 0x000fe200078e00ffULL, 0x000000039d047211ULL, 0x000fe400078ff0ffULL,
0x00000021065a7217ULL, 0x000fe40007800000ULL, 0x0000001004547810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff5f7a12ULL, 0x000fe200078e33ffULL, 0x000000015a217824ULL, 0x000fe200078e0a21ULL,
0x0000005100517308ULL, 0x008ee40000001000ULL, 0x0ffffffe51537810ULL, 0x008fcc0007ffe0ffULL,
0x0000005300537305ULL, 0x000ee4000021f000ULL, 0x000000ffff557224ULL, 0x008fc800078e0a53ULL,
0x00005a0055557a24ULL, 0x000fc800078e02ffULL, 0x0000005553597227ULL, 0x000fe200078e0052ULL,
0x0000000804527810ULL, 0x000fca0007ffe0ffULL, 0x0000005259567227ULL, 0x000fc800078e00ffULL,
0x0000000459517227ULL, 0x000fc800078e00ffULL, 0x000000ffff537224ULL, 0x000fe400078e0a56ULL,
0x000000ffff557224ULL, 0x000fe400078e0a51ULL, 0x00005a0053537a24ULL, 0x000fe400078e0252ULL,
0x00005a0055527a24ULL, 0x000fe200078e0204ULL, 0x0000001804047810ULL, 0x000fe20007ffe0ffULL,
0x0000005459587227ULL, 0x000fe200078e00ffULL, 0x00005a0053007a0cULL, 0x000fe40003fa6070ULL,
0x00005a0052007a0cULL, 0x000fe20003f06070ULL, 0x000000ffff577224ULL, 0x000fc400078e0a58ULL,
0x0000000459597227ULL, 0x000fc800078e00ffULL, 0x00005a0057547a24ULL, 0x000fe400078e0254ULL,
0x000000ffff577224ULL, 0x000fe400078e0a59ULL, 0x80005a0053535a10ULL, 0x000fe40007ffe0ffULL,
0x00005a0054007a0cULL, 0x000fe20003f26070ULL, 0x00005a0057577a24ULL, 0x000fe200078e0204ULL,
0x80005a0052520a10ULL, 0x000fe20007ffe0ffULL, 0x000000029d047824ULL, 0x000fe200078e00ffULL,
0x00005a0053007a0cULL, 0x000fc40003fc6070ULL, 0x00005a0057007a0cULL, 0x000fe40003f66070ULL,
0x00005a0052007a0cULL, 0x000fe40003f46070ULL, 0x0000000604047812ULL, 0x000fe400078ec0ffULL,
0x0000000151510810ULL, 0x000fe40007ffe0ffULL, 0x80005a0054541a10ULL, 0x000fe20007ffe0ffULL,
0x0000000104527824ULL, 0x000fe200078e0208ULL, 0x0000000156565810ULL, 0x000fc40007ffe0ffULL,
0x00005a0054007a0cULL, 0x000fe20003f86070ULL, 0x0000000123547824ULL, 0x000fe200078e0204ULL,
0x80005a0057573a10ULL, 0x000fe20007ffe0ffULL, 0x0000000152537824ULL, 0x100fe200078e0a21ULL,
0x00005a00ff007a0cULL, 0x000fe20003fa5070ULL, 0x0000000154557824ULL, 0x000fe200078e0a21ULL,
0x0000000151512810ULL, 0x000fe40007ffe0ffULL, 0x00005a0057007a0cULL, 0x000fe40003f46070ULL,
0x0000000156566810ULL, 0x000fc40007ffe0ffULL, 0x000000515f517207ULL, 0x000fe40006800000ULL,
0x000000215200720cULL, 0x000fe40003fc6070ULL, 0x0000005398537217ULL, 0x040fe40003800000ULL,
0x0000005598557217ULL, 0x040fe40003800000ULL, 0x0000005198517217ULL, 0x000fe40003800000ULL,
0x000000ff535d7207ULL, 0x000fc40003000000ULL, 0x000000565f537207ULL, 0x000fe20006800000ULL,
0x000000519c7a7224ULL, 0x000fe200078e02ffULL, 0x0000000158581810ULL, 0x000fe40007ffe0ffULL,
0x000000215400720cULL, 0x000fe40003f06070ULL, 0x00000004ff557819ULL, 0x000fe40000011655ULL,
0x0000000159593810ULL, 0x000fe40007ffe0ffULL, 0x0000005398537217ULL, 0x000fc40003800000ULL,
0x0000000158584810ULL, 0x000fe40007ffe0ffULL, 0x000000ff555b7207ULL, 0x000fe20000000000ULL,
0x000000539c7c7224ULL, 0x000fe200078e02ffULL, 0x0000000159592810ULL, 0x000fe40007ffe0ffULL,
0x000000585f517207ULL, 0x000fe20006800000ULL, 0x000000017a577824ULL, 0x000fe200078e025bULL,
0x0000007a5d557211ULL, 0x000fe400078fe0ffULL, 0x000000595f5f7207ULL, 0x000fe20006800000ULL,
0x000000015b597824ULL, 0x000fe200078e027cULL, 0x0000005198537217ULL, 0x040fe20003800000ULL,
0x0000000255547825ULL, 0x000fe200078e009aULL, 0x0000005f985f7217ULL, 0x000fc40003800000ULL,
0x00000010045a7812ULL, 0x000fe200078efcffULL, 0x0000000257567825ULL, 0x100fe400078e009aULL,
0x0000000654547981ULL, 0x000724000c1e9500ULL, 0x0000000259587825ULL, 0x000fe400078e009aULL,
0x0000000656517981ULL, 0x000324000c1e9500ULL, 0x000000539c7e7224ULL, 0x040fe400078e02ffULL,
0x0000005f9c807224ULL, 0x000fe200078e02ffULL, 0x0000000658537981ULL, 0x000522000c1e9500ULL,
0x0000000123687824ULL, 0x000fe200078e025aULL, 0x0000007c5d617211ULL, 0x000fe200078fe0ffULL,
0x000000015b657824ULL, 0x000fe200078e027eULL, 0x0000007e5d637211ULL, 0x000fc400078fe0ffULL,
0x000000805d5f7211ULL, 0x000fe200078fe0ffULL, 0x0000000168597824ULL, 0x004fe400078e0a21ULL,
0x000000015b677824ULL, 0x000fe400078e0280ULL, 0x0000000261607825ULL, 0x000fe200078e009aULL,
0x00000059985b7217ULL, 0x000fc60003800000ULL, 0x0000000265647825ULL, 0x100fe200078e009aULL,
0x0000000660567981ULL, 0x0022a6000c1e9500ULL, 0x0000000263627825ULL, 0x100fe200078e009aULL,
0x0000000664557981ULL, 0x0086a6000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fe200078e009aULL,
0x0000000662587981ULL, 0x0002a2000c1e9500ULL, 0x000000216800720cULL, 0x000fc40003f26070ULL,
0x000000015a5c7824ULL, 0x000fe200078e0208ULL, 0x00000004ff5b7819ULL, 0x000fe2000001165bULL,
0x0000000267667825ULL, 0x000fe200078e009aULL, 0x000000065e5e7981ULL, 0x0002a6000c1e9500ULL,
0x000000015c597824ULL, 0x040fe200078e0a21ULL, 0x000000215c00720cULL, 0x000fe20003f06070ULL,
0x0000000666577981ULL, 0x0006a2000c1e9500ULL, 0x000000ff5b5f7207ULL, 0x002fe40000800000ULL,
0x0000005998597217ULL, 0x000fc60003800000ULL, 0x000000015f677824ULL, 0x008fe200078e027cULL,
0x000000ff596b7207ULL, 0x000fe20000000000ULL, 0x000000017a637824ULL, 0x000fe200078e025fULL,
0x00000020046a7812ULL, 0x000fe200078efcffULL, 0x0000000267667825ULL, 0x100fe200078e009aULL,
0x0000007a6b617211ULL, 0x040fe400078fe0ffULL, 0x0000007c6b657211ULL, 0x000fe200078fe0ffULL,
0x0000000263627825ULL, 0x100fe200078e009aULL, 0x00000006665b7981ULL, 0x0002e6000c1e9500ULL,
0x0000000261607825ULL, 0x100fe200078e009aULL, 0x0000000662597981ULL, 0x0002e6000c1e9500ULL,
0x0000000265647825ULL, 0x000fc400078e009aULL, 0x0000000660607981ULL, 0x0002e4000c1e9500ULL,
0x0000000123667824ULL, 0x002fe400078e026aULL, 0x000000016a6c7824ULL, 0x000fe200078e0208ULL,
0x0000000664627981ULL, 0x0002e2000c1e9500ULL, 0x0000000166637824ULL, 0x100fe200078e0a21ULL,
0x0000007e6b697211ULL, 0x040fe400078fe0ffULL, 0x000000806b6f7211ULL, 0x000fe400078fe0ffULL,
0x0000006398677217ULL, 0x000fe20003800000ULL, 0x000000016c637824ULL, 0x000fc400078e0a21ULL,
0x000000015f717824ULL, 0x040fe400078e027eULL, 0x000000015f737824ULL, 0x000fe200078e0280ULL,
0x000000216600720cULL, 0x080fe20003f26070ULL, 0x0000000269687825ULL, 0x000fe200078e009aULL,
0x000000216c00720cULL, 0x000fe40003f06070ULL, 0x00000004ff677819ULL, 0x000fe20000011667ULL,
0x000000026f6e7825ULL, 0x100fe200078e009aULL, 0x0000006398637217ULL, 0x000fe20003800000ULL,
0x0000000668687981ULL, 0x0002e4000c1e9500ULL, 0x0000000271707825ULL, 0x000fc800078e009aULL,
0x0000000273727825ULL, 0x000fe200078e009aULL, 0x000000ff67677207ULL, 0x000fe20000800000ULL,
0x00000006705f7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff636d7207ULL, 0x000fc60000000000ULL,
0x0000000672617981ULL, 0x0002e8000c1e9500ULL, 0x000000066e6e7981ULL, 0x0002e2000c1e9500ULL,
0x0000000167777824ULL, 0x040fe400078e027cULL, 0x000000017a657824ULL, 0x002fe400078e0267ULL,
0x0000000167717824ULL, 0x000fe200078e027eULL, 0x0000007c6d6f7211ULL, 0x000fe200078fe0ffULL,
0x00000001677b7824ULL, 0x000fc400078e0280ULL, 0x0000000277767825ULL, 0x000fc800078e009aULL,
0x000000026f667825ULL, 0x000fe200078e009aULL, 0x0000000676697981ULL, 0x0002e2000c1e9500ULL,
0x0000003004b47812ULL, 0x000fc600078efcffULL, 0x0000000666ce7981ULL, 0x0002e2000c1e9500ULL,
0x0000007a6d797211ULL, 0x000fe200078fe0ffULL, 0x0000000265647825ULL, 0x000fe200078e009aULL,
0x0000007e6d737211ULL, 0x040fe400078fe0ffULL, 0x000000806d757211ULL, 0x000fe200078fe0ffULL,
0x0000000123767824ULL, 0x002fe200078e02b4ULL, 0x0000000664637981ULL, 0x0002e2000c1e9500ULL,
0x0000000279787825ULL, 0x000fc800078e009aULL, 0x0000000271707825ULL, 0x100fe400078e009aULL,
0x0000000678787981ULL, 0x0002e4000c1e9500ULL, 0x0000000273727825ULL, 0x100fe400078e009aULL,
0x0000000670817981ULL, 0x0002e4000c1e9500ULL, 0x000000027b647825ULL, 0x102fe400078e009aULL,
0x0000000672d27981ULL, 0x0002e4000c1e9500ULL, 0x0000000275747825ULL, 0x000fc400078e009aULL,
0x0000000664857981ULL, 0x0002e4000c1e9500ULL, 0x00000001766f7824ULL, 0x100fe400078e0a21ULL,
0x00000001b4b67824ULL, 0x000fe200078e0208ULL, 0x0000000674d67981ULL, 0x0002e4000c1e9500ULL,
0x0000006f98777217ULL, 0x000fe20003800000ULL, 0x00000001b66f7824ULL, 0x000fe200078e0a21ULL,
0x000000217600720cULL, 0x080fe40003f26070ULL, 0x00000021b600720cULL, 0x000fc40003f06070ULL,
0x00000004ff777819ULL, 0x000fe40000011677ULL, 0x0000006f986f7217ULL, 0x000fe40003800000ULL,
0x000000ff77797207ULL, 0x000fe40000800000ULL, 0x000000ff6f6f7207ULL, 0x000fc60000000000ULL,
0x000000017a757824ULL, 0x002fe200078e0279ULL, 0x0000007a6f777211ULL, 0x000fe200078fe0ffULL,
0x0000000179677824ULL, 0x000fe200078e027eULL, 0x0000007e6f657211ULL, 0x000fe200078fe0ffULL,
0x0000000275747825ULL, 0x000fc800078e009aULL, 0x0000000277767825ULL, 0x100fe200078e009aULL,
0x00000006747b7981ULL, 0x0002e6000c1e9500ULL, 0x0000000267667825ULL, 0x100fe200078e009aULL,
0x0000000676b87981ULL, 0x0002e6000c1e9500ULL, 0x0000000265647825ULL, 0x000fe200078e009aULL,
0x0000000666837981ULL, 0x0002e2000c1e9500ULL, 0x0000007c6f737211ULL, 0x000fc600078fe0ffULL,
0x0000000664d47981ULL, 0x0002e2000c1e9500ULL, 0x0000000179717824ULL, 0x000fe400078e027cULL,
0x0000000273727825ULL, 0x000fc800078e009aULL, 0x0000000271707825ULL, 0x000fe200078e009aULL,
0x0000000672d07981ULL, 0x0002e4000c1e9500ULL, 0x000000806f757211ULL, 0x002fe400078fe0ffULL,
0x00000006707f7981ULL, 0x0002e2000c1e9500ULL, 0x0000000179777824ULL, 0x000fe400078e0280ULL,
0x0000000275747825ULL, 0x000fc800078e009aULL, 0x0000000277767825ULL, 0x000fe200078e009aULL,
0x0000000674d87981ULL, 0x0002e8000c1e9500ULL, 0x0000000676877981ULL, 0x0002e2000c1e9500ULL,
0xfffffff05d647812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcc7424ULL, 0x000fc800078e00ffULL,
0x00000001215d7824ULL, 0x000fc800078e0264ULL, 0x0000000152647824ULL, 0x000fe200078e0a5dULL,
0x0000000104707812ULL, 0x002fc800078efcffULL, 0x00000064cc647219ULL, 0x000fe200000006ffULL,
0x0000000170667824ULL, 0x000fe200078e0208ULL, 0xfffffff06b727812ULL, 0x000fc600078ec0ffULL,
0x0000000166657824ULL, 0x100fe200078e0a5dULL, 0x00000008047a7812ULL, 0x040fe200078efcffULL,
0x00000001216b7824ULL, 0x000fe200078e0272ULL, 0x00000009047c7812ULL, 0x000fe400078efcffULL,
0x00000065cc727219ULL, 0x000fe200000006ffULL, 0x000000017a747824ULL, 0x100fe400078e0208ULL,
0x000000017c7e7824ULL, 0x000fe200078e0208ULL, 0xfffffff06d767812ULL, 0x000fe200078ec0ffULL,
0x0000000174677824ULL, 0x000fe200078e0a5dULL, 0xfffffff06f807812ULL, 0x000fc400078ec0ffULL,
0x0000007e5d5d7210ULL, 0x000fe20007ffe1ffULL, 0x00000001216d7824ULL, 0x040fe200078e0276ULL,
0x0000001104847812ULL, 0x000fe200078efcffULL, 0x0000000121757824ULL, 0x000fe200078e0280ULL,
0x00000067cc767219ULL, 0x040fe400000006ffULL, 0x0000005dcc807219ULL, 0x000fe200000006ffULL,
0x0000000184867824ULL, 0x000fe200078e0208ULL, 0x0000541054517816ULL, 0x010fc80000000051ULL,
0x0000005164ff7212ULL, 0x000fc800078ac0ffULL, 0x000000215200720cULL, 0x000fc80002fa1470ULL,
0x000000210400720cULL, 0x000fe40002fa1070ULL, 0x0000005172ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000005057808ULL, 0x000fe40002800000ULL, 0x0000541056537816ULL, 0x004fc80000000053ULL,
0x0000005364ff7212ULL, 0x080fe4000784c0ffULL, 0x0000541058557816ULL, 0x000fe40000000055ULL,
0x0000005372ff7212ULL, 0x000fe400078ac0ffULL, 0x0000005564ff7212ULL, 0x000fe4000788c0ffULL,
0x000000215200720cULL, 0x0c0fe40001741470ULL, 0x000000215200720cULL, 0x000fc40002781470ULL,
0x000000216600720cULL, 0x0c0fe40000f21470ULL, 0x000000216600720cULL, 0x080fe40002fa1470ULL,
0x000000210400720cULL, 0x0c0fe40001741070ULL, 0x000000210400720cULL, 0x080fe40002781070ULL,
0x000000217000720cULL, 0x0c0fe40000f21070ULL, 0x000000217000720cULL, 0x000fc40002fa1070ULL,
0x000054105e577816ULL, 0x000fe40000000057ULL, 0xff80000016167808ULL, 0x000fe40001000000ULL,
0xff80000037377808ULL, 0x000fe40002000000ULL, 0xff80000009097808ULL, 0x000fe40000800000ULL,
0xff8000001f1f7808ULL, 0x000fe40002800000ULL, 0x0000005176ff7212ULL, 0x000fc4000786c0ffULL,
0x0000005764ff7212ULL, 0x000fe4000780c0ffULL, 0x0000005572ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005772ff7212ULL, 0x000fe4000788c0ffULL, 0x0000005380ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005576ff7212ULL, 0x000fe200078ac0ffULL, 0x000000015c5d7824ULL, 0x100fe200078e0a6bULL,
0x000000215200720cULL, 0x080fe20000701470ULL, 0x0000000186657824ULL, 0x000fe200078e0a6bULL,
0x000000216600720cULL, 0x000fc40001741470ULL, 0x000000216600720cULL, 0x080fe40002781470ULL,
0x000000217400720cULL, 0x0c0fe40001f61470ULL, 0x000000217400720cULL, 0x080fe40002fa1470ULL,
0x000000217e00720cULL, 0x000fe40000f21470ULL, 0x00000018048a7812ULL, 0x040fe400078efcffULL,
0x0000001904927812ULL, 0x000fc400078efcffULL, 0x000000210400720cULL, 0x080fe40000701070ULL,
0x000000217000720cULL, 0x0c0fe40001741070ULL, 0x000000217000720cULL, 0x080fe40002781070ULL,
0x000000217a00720cULL, 0x0c0fe40001f61070ULL, 0x000000217a00720cULL, 0x080fe40002fa1070ULL,
0x000000217c00720cULL, 0x000fc40000f21070ULL, 0x0000005dcc827219ULL, 0x040fe400000006ffULL,
0x00000065cc887219ULL, 0x000fe400000006ffULL, 0x0000541060597816ULL, 0x008fe40000000059ULL,
0x00005410625b7816ULL, 0x000fe2000000005bULL, 0x000000018a8c7824ULL, 0x100fe200078e0208ULL,
0xff8000004c4c7808ULL, 0x000fe20000000000ULL, 0x0000000192947824ULL, 0x000fe200078e0208ULL,
0xff80000039397808ULL, 0x000fc40001000000ULL, 0xff8000004e4e7808ULL, 0x000fe40002000000ULL,
0xff8000000a0a7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40002800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0x0000005376ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005580ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005776ff7212ULL, 0x080fe4000788c0ffULL,
0x0000005780ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005988ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005b82ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018c677824ULL, 0x100fe200078e0a6bULL,
0x000000217400720cULL, 0x080fe20000701470ULL, 0x00000001946b7824ULL, 0x000fe200078e0a6bULL,
0x000000217400720cULL, 0x000fc40002781470ULL, 0x000000217e00720cULL, 0x0c0fe40001741470ULL,
0x000000217e00720cULL, 0x080fe40001f61470ULL, 0x000000215c00720cULL, 0x080fe40000f21470ULL,
0x000000218600720cULL, 0x080fe40002fa1470ULL, 0x000000217a00720cULL, 0x0c0fe40000701070ULL,
0x000000217a00720cULL, 0x000fc40002781070ULL, 0x000000217c00720cULL, 0x0c0fe40001741070ULL,
0x000000217c00720cULL, 0x080fe40001f61070ULL, 0x000000215a00720cULL, 0x080fe40000f21070ULL,
0x000000218400720cULL, 0x000fe40002fa1070ULL, 0x00000067cc8e7219ULL, 0x040fe400000006ffULL,
0x0000006bcc967219ULL, 0x000fc400000006ffULL, 0x00005410685f7816ULL, 0x000fe4000000005fULL,
0x000054106e617816ULL, 0x000fe40000000061ULL, 0xff80000020207808ULL, 0x000fe40000000000ULL,
0xff8000004f4f7808ULL, 0x000fe40002000000ULL, 0xff8000003b3b7808ULL, 0x000fe40001000000ULL,
0xff80000050507808ULL, 0x000fc40001800000ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x0000005982ff7212ULL, 0x080fe4000780c0ffULL,
0x000000598eff7212ULL, 0x000fe4000788c0ffULL, 0x0000005f82ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006182ff7212ULL, 0x000fc4000786c0ffULL, 0x0000005f88ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005b96ff7212ULL, 0x000fe200078ac0ffULL, 0x000000016c6f7824ULL, 0x000fe200078e0a6dULL,
0x000000215c00720cULL, 0x0c0fe40000701470ULL, 0x000000215c00720cULL, 0x0c0fe40001741470ULL,
0x000000215c00720cULL, 0x080fe40001f61470ULL, 0x000000218600720cULL, 0x000fc40000f21470ULL,
0x000000218c00720cULL, 0x080fe40002781470ULL, 0x000000219400720cULL, 0x080fe40002fa1470ULL,
0x0000002104a27812ULL, 0x000fe400078efcffULL, 0x000000215a00720cULL, 0x0c0fe40000701070ULL,
0x000000215a00720cULL, 0x0c0fe40001741070ULL, 0x000000215a00720cULL, 0x000fc40001f61070ULL,
0x000000218400720cULL, 0x080fe40000f21070ULL, 0x000000218a00720cULL, 0x080fe40002781070ULL,
0x000000219200720cULL, 0x000fe40002fa1070ULL, 0x0000006fcca07219ULL, 0x000fe400000006ffULL,
0x00005410ce697816ULL, 0x000fe20000000069ULL, 0x00000001a2a47824ULL, 0x000fe200078e0208ULL,
0xff80000010107808ULL, 0x000fc40000000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40001800000ULL, 0xff8000003f3f7808ULL, 0x000fe40000800000ULL,
0xff80000012127808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0x0000005b88ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006188ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005b8eff7212ULL, 0x000fe4000786c0ffULL, 0x0000005f96ff7212ULL, 0x040fe4000782c0ffULL,
0x0000006196ff7212ULL, 0x000fe4000788c0ffULL, 0x00000069a0ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a4717824ULL, 0x000fe200078e0a6dULL, 0x000000218600720cULL, 0x000fc40000701470ULL,
0x000000218600720cULL, 0x080fe40001741470ULL, 0x000000218c00720cULL, 0x080fe40001f61470ULL,
0x000000219400720cULL, 0x0c0fe40000f21470ULL, 0x000000219400720cULL, 0x080fe40002781470ULL,
0x000000216c00720cULL, 0x000fe40002fa1470ULL, 0x0000002804a87812ULL, 0x000fc400078efcffULL,
0x0000002904ae7812ULL, 0x000fe400078efcffULL, 0x000000218400720cULL, 0x0c0fe40000701070ULL,
0x000000218400720cULL, 0x080fe40001741070ULL, 0x000000218a00720cULL, 0x080fe40001f61070ULL,
0x000000219200720cULL, 0x0c0fe40000f21070ULL, 0x000000219200720cULL, 0x000fc40002781070ULL,
0x000000216a00720cULL, 0x000fe40002fa1070ULL, 0x00000071cca67219ULL, 0x000fe400000006ffULL,
0x0000541078637816ULL, 0x000fe40000000063ULL, 0x00005410d2817816ULL, 0x000fe40000000081ULL,
0x00005410d6857816ULL, 0x000fe20000000085ULL, 0x00000001a8aa7824ULL, 0x100fe200078e0208ULL,
0xff80000026267808ULL, 0x000fe20000000000ULL, 0x00000001aeb07824ULL, 0x000fe200078e0208ULL,
0xff80000048487808ULL, 0x000fc40001000000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0xff8000003e3e7808ULL, 0x000fe40002000000ULL,
0xff80000029297808ULL, 0x000fe40002800000ULL, 0x0000005180ff7212ULL, 0x000fe400078cc0ffULL,
0x0000005f8eff7212ULL, 0x000fc4000780c0ffULL, 0x000000618eff7212ULL, 0x000fe4000784c0ffULL,
0x00000063a0ff7212ULL, 0x040fe4000786c0ffULL, 0x00000081a0ff7212ULL, 0x040fe4000782c0ffULL,
0x00000085a0ff7212ULL, 0x000fe4000788c0ffULL, 0x00000081a6ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001aa737824ULL, 0x100fe200078e0a6dULL, 0x000000217e00720cULL, 0x080fe200037c1470ULL,
0x00000001b06d7824ULL, 0x000fe200078e0a6dULL, 0x000000218c00720cULL, 0x000fc40000701470ULL,
0x000000218c00720cULL, 0x080fe40001741470ULL, 0x000000216c00720cULL, 0x0c0fe40001f61470ULL,
0x000000216c00720cULL, 0x0c0fe40000f21470ULL, 0x000000216c00720cULL, 0x080fe40002781470ULL,
0x00000021a400720cULL, 0x080fe40002fa1470ULL, 0x000000217c00720cULL, 0x000fc400037c1070ULL,
0x000000218a00720cULL, 0x0c0fe40000701070ULL, 0x000000218a00720cULL, 0x080fe40001741070ULL,
0x000000216a00720cULL, 0x0c0fe40001f61070ULL, 0x000000216a00720cULL, 0x0c0fe40000f21070ULL,
0x000000216a00720cULL, 0x080fe40002781070ULL, 0x00000021a200720cULL, 0x000fc40002fa1070ULL,
0x00000073ccac7219ULL, 0x040fe400000006ffULL, 0x0000006dccb27219ULL, 0x000fe400000006ffULL,
0xff8000000b0b7808ULL, 0x000fe40003000000ULL, 0xff80000041417808ULL, 0x000fe40000000000ULL,
0xff8000003d3d7808ULL, 0x000fe40001000000ULL, 0xff80000017177808ULL, 0x000fc40001800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000040407808ULL, 0x000fe40002000000ULL,
0xff80000044447808ULL, 0x000fe40002800000ULL, 0x0000005996ff7212ULL, 0x000fe400078cc0ffULL,
0x00000063a6ff7212ULL, 0x080fe4000780c0ffULL, 0x00000063acff7212ULL, 0x000fc4000784c0ffULL,
0x00000069a6ff7212ULL, 0x040fe4000786c0ffULL, 0x00000085a6ff7212ULL, 0x000fe4000782c0ffULL,
0x00000069acff7212ULL, 0x000fe4000788c0ffULL, 0x00000081b2ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b6777824ULL, 0x000fe200078e0a75ULL, 0x000000219400720cULL, 0x080fe400037c1470ULL,
0x00000021a400720cULL, 0x000fc40000701470ULL, 0x00000021a400720cULL, 0x0c0fe40001f61470ULL,
0x00000021a400720cULL, 0x080fe40000f21470ULL, 0x00000021aa00720cULL, 0x0c0fe40001741470ULL,
0x00000021aa00720cULL, 0x080fe40002781470ULL, 0x00000021b000720cULL, 0x000fe40002fa1470ULL,
0x0000003104bc7812ULL, 0x000fc400078efcffULL, 0x0000003804c27812ULL, 0x040fe400078efcffULL,
0x0000003904c87812ULL, 0x000fe400078efcffULL, 0x000000219200720cULL, 0x080fe400037c1070ULL,
0x00000021a200720cULL, 0x0c0fe40000701070ULL, 0x00000021a200720cULL, 0x0c0fe40001f61070ULL,
0x00000021a200720cULL, 0x000fc40000f21070ULL, 0x00000021a800720cULL, 0x0c0fe40001741070ULL,
0x00000021a800720cULL, 0x080fe40002781070ULL, 0x00000021ae00720cULL, 0x000fe40002fa1070ULL,
0x00000077ccba7219ULL, 0x000fe400000006ffULL, 0x00005410b87b7816ULL, 0x000fe4000000007bULL,
0x00005410d4837816ULL, 0x000fe20000000083ULL, 0x00000001bcbe7824ULL, 0x100fe200078e0208ULL,
0xff80000015157808ULL, 0x000fe20003000000ULL, 0x00000001c2c47824ULL, 0x100fe200078e0208ULL,
0xff8000001a1a7808ULL, 0x000fe20000000000ULL, 0x00000001c8ca7824ULL, 0x000fe200078e0208ULL,
0xff8000002a2a7808ULL, 0x000fc40001800000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fe40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff80000046467808ULL, 0x000fe40002800000ULL, 0x00000063b2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000069b2ff7212ULL, 0x000fc4000780c0ffULL, 0x00000081acff7212ULL, 0x040fe4000786c0ffULL,
0x00000085acff7212ULL, 0x080fe4000782c0ffULL, 0x00000085b2ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007bbaff7212ULL, 0x040fe4000788c0ffULL, 0x00000083baff7212ULL, 0x000fe200078ac0ffULL,
0x00000001be797824ULL, 0x100fe200078e0a75ULL, 0x00000021aa00720cULL, 0x080fe20001f61470ULL,
0x00000001c47d7824ULL, 0x100fe200078e0a75ULL, 0x00000021aa00720cULL, 0x080fe20000f21470ULL,
0x00000001ca757824ULL, 0x000fe200078e0a75ULL, 0x00000021b000720cULL, 0x000fc400037c1470ULL,
0x00000021b000720cULL, 0x0c0fe40000701470ULL, 0x00000021b000720cULL, 0x080fe40001741470ULL,
0x00000021b600720cULL, 0x0c0fe40002781470ULL, 0x00000021b600720cULL, 0x000fe40002fa1470ULL,
0x00000079ccc07219ULL, 0x040fe400000006ffULL, 0x0000007dccc67219ULL, 0x000fc400000006ffULL,
0x00000021a800720cULL, 0x0c0fe40001f61070ULL, 0x00000021a800720cULL, 0x080fe40000f21070ULL,
0x00000021ae00720cULL, 0x0c0fe400037c1070ULL, 0x00000021ae00720cULL, 0x0c0fe40000701070ULL,
0x00000021ae00720cULL, 0x080fe40001741070ULL, 0x00000021b400720cULL, 0x000fc40002781070ULL,
0x00000021b400720cULL, 0x000fe40002fa1070ULL, 0x00000075cccc7219ULL, 0x000fe400000006ffULL,
0x00005410d07f7816ULL, 0x000fe4000000007fULL, 0xff80000045457808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40000800000ULL, 0xff8000001c1c7808ULL, 0x000fc40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff8000002f2f7808ULL, 0x000fe40001000000ULL,
0xff8000001d1d7808ULL, 0x000fe40002000000ULL, 0xff80000047477808ULL, 0x000fe40002800000ULL,
0x0000007bc0ff7212ULL, 0x080fe4000786c0ffULL, 0x0000007bc6ff7212ULL, 0x000fc4000782c0ffULL,
0x0000007bccff7212ULL, 0x000fe400078cc0ffULL, 0x0000007fbaff7212ULL, 0x080fe4000780c0ffULL,
0x0000007fc0ff7212ULL, 0x080fe4000784c0ffULL, 0x0000007fc6ff7212ULL, 0x000fe4000788c0ffULL,
0x00000083c0ff7212ULL, 0x000fe400078ac0ffULL, 0x00000021b600720cULL, 0x000fc40000701470ULL,
0x00000021be00720cULL, 0x0c0fe40001f61470ULL, 0x00000021be00720cULL, 0x0c0fe40001741470ULL,
0x00000021be00720cULL, 0x080fe40002fa1470ULL, 0x00000021c400720cULL, 0x080fe40000f21470ULL,
0x00000021ca00720cULL, 0x080fe400037c1470ULL, 0x00000021c400720cULL, 0x000fc40002781470ULL,
0x00000021b400720cULL, 0x080fe40000701070ULL, 0x00000021bc00720cULL, 0x0c0fe40001f61070ULL,
0x00000021bc00720cULL, 0x0c0fe40001741070ULL, 0x00000021bc00720cULL, 0x080fe40002fa1070ULL,
0x00000021c200720cULL, 0x080fe40000f21070ULL, 0x00000021c800720cULL, 0x000fc400037c1070ULL,
0x00000021c200720cULL, 0x000fe40002781070ULL, 0x00005410d8877816ULL, 0x000fe40000000087ULL,
0xff8000002e2e7808ULL, 0x000fe40000000000ULL, 0xff80000018187808ULL, 0x000fe40001800000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000049497808ULL, 0x000fc40002800000ULL,
0xff80000019197808ULL, 0x000fe40000800000ULL, 0xff8000001b1b7808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40002000000ULL, 0x0000007fccff7212ULL, 0x000fe4000780c0ffULL,
0x00000083c6ff7212ULL, 0x080fe4000786c0ffULL, 0x00000083ccff7212ULL, 0x000fc4000784c0ffULL,
0x00000087baff7212ULL, 0x080fe400078ac0ffULL, 0x00000087c0ff7212ULL, 0x080fe4000782c0ffULL,
0x00000087c6ff7212ULL, 0x080fe400078cc0ffULL, 0x00000087ccff7212ULL, 0x000fe4000788c0ffULL,
0x00000021b600720cULL, 0x080fe40002fa1470ULL, 0x00000021be00720cULL, 0x000fc40000f21470ULL,
0x00000021c400720cULL, 0x0c0fe40001f61470ULL, 0x00000021c400720cULL, 0x080fe400037c1470ULL,
0x00000021ca00720cULL, 0x0c0fe40000701470ULL, 0x00000021ca00720cULL, 0x0c0fe40001741470ULL,
0x00000021ca00720cULL, 0x080fe40002781470ULL, 0x00000021b400720cULL, 0x000fc40002fa1070ULL,
0x00000021bc00720cULL, 0x080fe40000f21070ULL, 0x00000021c800720cULL, 0x080fe40000701070ULL,
0x00000021c200720cULL, 0x0c0fe40001f61070ULL, 0x00000021c200720cULL, 0x080fe400037c1070ULL,
0x00000021c800720cULL, 0x0c0fe40001741070ULL, 0x00000021c800720cULL, 0x000fc40002781070ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff8000004a4a7808ULL, 0x000fe40001800000ULL,
0xff8000004b4b7808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40002800000ULL,
0xff80000033337808ULL, 0x000fe40000800000ULL, 0xff80000035357808ULL, 0x000fc40003000000ULL,
0xff80000038387808ULL, 0x000fc40002000000ULL, 0x000000160d00720bULL, 0x004fe40003f3e000ULL,
0x000000050c00720bULL, 0x000fe40003f1e000ULL, 0x000000370e00720bULL, 0x000fe40003f5e000ULL,
0x0000004c0f00720bULL, 0x000fe40003f7e000ULL, 0x0000000d16047208ULL, 0x000fe40004800000ULL,
0x0000000c050c7208ULL, 0x000fc40004000000ULL, 0x0000000e370e7208ULL, 0x000fe40005000000ULL,
0x0000000f4c0f7208ULL, 0x000fe40005800000ULL, 0x0000001f0400720bULL, 0x000fe40003f3e000ULL,
0x000000090c00720bULL, 0x000fe40003f1e000ULL, 0x000000390e00720bULL, 0x000fe40003f5e000ULL,
0x0000004e0f00720bULL, 0x000fc40003f7e000ULL, 0x000000041f217208ULL, 0x000fe40004800000ULL,
0x0000000c090d7208ULL, 0x000fe40004000000ULL, 0x0000000e39517208ULL, 0x000fe40005000000ULL,
0x0000000f4e047208ULL, 0x000fe40005800000ULL, 0x000000202100720bULL, 0x000fe40003f3e000ULL,
0x0000000a0d00720bULL, 0x000fc40003f1e000ULL, 0x0000003a5100720bULL, 0x000fe40003f5e000ULL,
0x0000004f0400720bULL, 0x000fe40003f7e000ULL, 0x0000002120217208ULL, 0x000fe40004800000ULL,
0x0000000d0a0c7208ULL, 0x000fe40004000000ULL, 0x000000513a0e7208ULL, 0x000fe40005000000ULL,
0x000000044f0d7208ULL, 0x000fc40005800000ULL, 0x000000242100720bULL, 0x000fe40003f3e000ULL,
0x0000000b0c00720bULL, 0x000fe40003f1e000ULL, 0x0000003b0e00720bULL, 0x000fe40003f5e000ULL,
0x000000500d00720bULL, 0x000fe40003f7e000ULL, 0x0000002124047208ULL, 0x000fe40004800000ULL,
0x0000000c0b0f7208ULL, 0x000fc40004000000ULL, 0x0000000e3b217208ULL, 0x000fe40005000000ULL,
0x0000000d500c7208ULL, 0x000fe40005800000ULL, 0x000000250400720bULL, 0x000fe40003f3e000ULL,
0x000000100f00720bULL, 0x000fe40003f1e000ULL, 0x0000003c2100720bULL, 0x000fe40003f5e000ULL,
0x0000004d0c00720bULL, 0x000fc40003f7e000ULL, 0x00000004250d7208ULL, 0x000fe40004800000ULL,
0x0000000f100e7208ULL, 0x000fe40004000000ULL, 0x000000213c047208ULL, 0x000fe40005000000ULL,
0x0000000c4d0f7208ULL, 0x000fe40005800000ULL, 0x000000110e00720bULL, 0x000fe40003f1e000ULL,
0x0000003f0400720bULL, 0x000fc40003f5e000ULL, 0x000000260d00720bULL, 0x000fe40003f3e000ULL,
0x000000480f00720bULL, 0x000fe40003f7e000ULL, 0x0000000e11217208ULL, 0x000fe40004000000ULL,
0x000000043f047208ULL, 0x000fe40005000000ULL, 0x0000000d260c7208ULL, 0x000fe40004800000ULL,
0x0000000f480e7208ULL, 0x000fc40005800000ULL, 0x000000122100720bULL, 0x000fe40003f1e000ULL,
0x000000410400720bULL, 0x000fe40003f5e000ULL, 0x000000270c00720bULL, 0x000fe40003f3e000ULL,
0x0000003d0e00720bULL, 0x000fe40003f7e000ULL, 0x0000002112527208ULL, 0x000fe40004000000ULL,
0x00000004410f7208ULL, 0x000fc40005000000ULL, 0x0000000c270d7208ULL, 0x000fe40004800000ULL,
0x0000000e3d217208ULL, 0x000fe40005800000ULL, 0x000000155200720bULL, 0x000fe40003f1e000ULL,
0x000000420f00720bULL, 0x000fe40003f5e000ULL, 0x000000280d00720bULL, 0x000fe40003f3e000ULL,
0x0000003e2100720bULL, 0x000fc40003f7e000ULL, 0x0000005215527208ULL, 0x000fe40004000000ULL,
0x0000000f420c7208ULL, 0x000fe40005000000ULL, 0x0000000d28047208ULL, 0x000fe40004800000ULL,
0x000000213e217208ULL, 0x000fe40005800000ULL, 0x000000175200720bULL, 0x000fe40003f1e000ULL,
0x000000430c00720bULL, 0x000fc40003f5e000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x000000402100720bULL, 0x000fe40003f7e000ULL, 0x00000052170d7208ULL, 0x000fe40004000000ULL,
0x0000000c43517208ULL, 0x000fe40005000000ULL, 0x00000004290f7208ULL, 0x000fe40004800000ULL,
0x0000002140217208ULL, 0x000fc40005800000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000445100720bULL, 0x000fe40003f5e000ULL, 0x0000002a0f00720bULL, 0x000fe40003f3e000ULL,
0x000000302100720bULL, 0x000fe40003f7e000ULL, 0x0000000d1a0d7208ULL, 0x000fe40004000000ULL,
0x00000051440c7208ULL, 0x000fc40005000000ULL, 0x0000000f2a047208ULL, 0x000fe40004800000ULL,
0x00000021300e7208ULL, 0x000fe40005800000ULL, 0x0000001e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000450c00720bULL, 0x000fe40003f5e000ULL, 0x0000002b0400720bULL, 0x000fe40003f3e000ULL,
0x0000002d0e00720bULL, 0x000fc40003f7e000ULL, 0x0000000d1e0d7208ULL, 0x000fe40004000000ULL,
0x0000000c45217208ULL, 0x000fe40005000000ULL, 0x000000042b0f7208ULL, 0x000fe40004800000ULL,
0x0000000e2d0e7208ULL, 0x000fe40005800000ULL, 0x0000001c0d00720bULL, 0x000fe40003f1e000ULL,
0x000000462100720bULL, 0x000fc40003f5e000ULL, 0x0000002c0f00720bULL, 0x000fe40003f3e000ULL,
0x0000002f0e00720bULL, 0x000fe40003f7e000ULL, 0x0000000d1c047208ULL, 0x000fe40004000000ULL,
0x00000021460c7208ULL, 0x000fe40005000000ULL, 0x0000000f2c0f7208ULL, 0x000fe40004800000ULL,
0x0000000e2f0d7208ULL, 0x000fc40005800000ULL, 0x0000001d0400720bULL, 0x000fe40003f1e000ULL,
0x000000470c00720bULL, 0x000fe40003f5e000ULL, 0x0000002e0f00720bULL, 0x000fe40003f3e000ULL,
0x000000320d00720bULL, 0x000fe40003f7e000ULL, 0x000000041d217208ULL, 0x000fe40004000000ULL,
0x0000000c470c7208ULL, 0x000fc40005000000ULL, 0x0000000f2e047208ULL, 0x000fe40004800000ULL,
0x0000000d320e7208ULL, 0x000fe40005800000ULL, 0x000000490c00720bULL, 0x000fe40003f5e000ULL,
0x000000182100720bULL, 0x000fe40003f1e000ULL, 0x000000310400720bULL, 0x000fe40003f3e000ULL,
0x000000330e00720bULL, 0x000fc40003f7e000ULL, 0x0000000c490f7208ULL, 0x000fe40005000000ULL,
0x0000002118527208ULL, 0x000fe40004000000ULL, 0x00000004310d7208ULL, 0x000fe40004800000ULL,
0x0000000e330e7208ULL, 0x000fe40005800000ULL, 0x0000004a0f00720bULL, 0x000fe40003f5e000ULL,
0x000000195200720bULL, 0x000fc40003f1e000ULL, 0x000000340d00720bULL, 0x000fe40003f3e000ULL,
0x000000350e00720bULL, 0x000fe40003f7e000ULL, 0x0000000f4a047208ULL, 0x000fe40005000000ULL,
0x0000005219527208ULL, 0x000fe40004000000ULL, 0x0000000d340d7208ULL, 0x000fe40004800000ULL,
0x0000000e350f7208ULL, 0x000fc40005800000ULL, 0x0000001b5200720bULL, 0x000fe40003f1e000ULL,
0x000000360d00720bULL, 0x000fe40003f3e000ULL, 0x0000004b0400720bULL, 0x000fe40003f5e000ULL,
0x000000380f00720bULL, 0x000fe40003f7e000ULL, 0x000000521b217208ULL, 0x000fe40004000000ULL,
0x0000000d36557208ULL, 0x000fc40004800000ULL, 0x000000044b577208ULL, 0x000fe40005000000ULL,
0x0000000f38567208ULL, 0x000fe20005800000ULL, 0x000025427f007947ULL, 0x000fea000b800000ULL,
0x0c401f0021047f89ULL, 0x0004e400000e0000ULL, 0x000000042100720bULL, 0x00cfc80003f1e000ULL,
0x0000002104597208ULL, 0x000fe20004000000ULL, 0x000025727f007947ULL, 0x000fea000b800000ULL,
0x0c401f0055047f89ULL, 0x000ea800000e0000ULL, 0x0c401f00570c7f89ULL, 0x000ee800000e0000ULL,
0x0c401f00560d7f89ULL, 0x000f2200000e0000ULL, 0x000000045500720bULL, 0x004fc40003f1e000ULL,
0x0000000c5700720bULL, 0x008fe40003f3e000ULL, 0x0000005504047208ULL, 0x000fe40004000000ULL,
0x000000570c0f7208ULL, 0x002fe40004800000ULL, 0x0000000d5600720bULL, 0x010fe20003f1e000ULL,
0x0c201f00590c7f89ULL, 0x000e6600000e0000ULL, 0x000000560d217208ULL, 0x000fe20004000000ULL,
0x0c201f0004517f89ULL, 0x000ea800000e0000ULL, 0x0c201f000f0e7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0021547f89ULL, 0x0002e400000e0000ULL, 0x0000000c5900720bULL, 0x002fc40003f1e000ULL,
0x000000510400720bULL, 0x004fe40003f3e000ULL, 0x000000590c0c7208ULL, 0x000fe40004000000ULL,
0x0000000e0f00720bULL, 0x008fe40003f5e000ULL, 0x00000004510d7208ULL, 0x000fe40004800000ULL,
0x0000000f0e0e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c047820ULL, 0x000fe20000410000ULL,
0x000000542100720bULL, 0x000fe20003f1e000ULL, 0x3f80000000047882ULL, 0x000fc40000000000ULL,
0x3fb8aa3b100f7823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b09097823ULL, 0x100fe40000010804ULL,
0x0000000f00537308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b11527823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b12127823ULL, 0x000fe20000010804ULL, 0x0000000900567308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0d0f7820ULL, 0x002fc40000410000ULL, 0x3fb8aa3b15577823ULL, 0x000fe40000010804ULL,
0x3fb8aa3b16167823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080fULL,
0x0000000a00517308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b25257823ULL, 0x000fc4000001080fULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080fULL, 0x0000000b00587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b29297823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080fULL,
0x00000052005a7308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x000fc4000001080fULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080fULL, 0x0000001200557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b360f7823ULL, 0x000fe4000001080fULL,
0x3fb8aa3b05057823ULL, 0x000fc40000010804ULL, 0x3fb8aa3b17107823ULL, 0x100fe20000010804ULL,
0x0000000f00627308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b1a117823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b1e157823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b1c527823ULL, 0x102fe20000010804ULL,
0x000000535a1c723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b1d097823ULL, 0x100fe20000010804ULL,
0x0000002e00597308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b180a7823ULL, 0x100fe20000010804ULL,
0x00000021540f7208ULL, 0x008fe20004000000ULL, 0x3fb8aa3b190b7823ULL, 0x100fe20000010804ULL,
0x000000039dff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b1b127823ULL, 0x000fc40000010804ULL,
0x3fb8aa3b0e047820ULL, 0x000fe20000410000ULL, 0x00000057005c7308ULL, 0x000ea20000000800ULL,
0x00000002ff2e7819ULL, 0x002fe4000001169dULL, 0x3fb8aa3b37377823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010804ULL, 0x000000012e187810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010804ULL, 0x0000000500057308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010804ULL, 0x000000042e1a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b3c3c7823ULL, 0x000fc40000010804ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010804ULL, 0x0000002b00577308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010804ULL, 0x000000555c1e723eULL, 0x004fe200000010ffULL,
0x3fb8aa3b43437823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b44447823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010804ULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b46467823ULL, 0x000fc40000010804ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010804ULL,
0x3fb8aa3b49497823ULL, 0x100fe40000010804ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010804ULL,
0x0000001f00197308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b4b047823ULL, 0x000fe40000010804ULL,
0x3fb8aa3b0f4b7820ULL, 0x000fe40000410000ULL, 0x000000082e2b7824ULL, 0x002fc400078e00ffULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe2000001084bULL, 0x00000020001b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe4000001084bULL, 0x3fb8aa3b50507823ULL, 0x100fe4000001084bULL,
0x000000082e1f7824ULL, 0x004fe400078e00ffULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe2000001084bULL,
0x0000002400247308ULL, 0x000e620000000800ULL, 0x000000161919723eULL, 0x008fe200000010ffULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe2000001084bULL, 0xfffffff81f547812ULL, 0x000fe200078ee218ULL,
0x3fb8aa3b48487823ULL, 0x100fe2000001084bULL, 0x000000022e187810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b3d3d7823ULL, 0x000fc4000001084bULL, 0x0000000400217308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b40407823ULL, 0x100fe4000001084bULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe4000001084bULL,
0x3fb8aa3b30307823ULL, 0x100fe4000001084bULL, 0x3fb8aa3b38387823ULL, 0x000fe2000001084bULL,
0x00000025001d7308ULL, 0x000fe20000000800ULL, 0x000000032e047810ULL, 0x004fe40007ffe0ffULL,
0x0000001b241b723eULL, 0x002fc400000010ffULL, 0xfffffff82b667812ULL, 0x000fe200078ee204ULL,
0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000002600267308ULL, 0x000e660000000800ULL, 0x3f8000000404783eULL, 0x000fca00000010ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000ffff5c7224ULL, 0x100fe400078e0004ULL,
0x000000ffff5d7224ULL, 0x000fca00078e0004ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000001d261d723eULL, 0x002fce00000010ffULL, 0x0000002a00207308ULL, 0x000ff00000000800ULL,
0x0000002c005e7308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000ff00000000800ULL,
0x00000039002a7308ULL, 0x000e700000000800ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000ea20000000800ULL, 0x000000372a24723eULL, 0x002fc400000010ffULL,
0x000000062e2a7810ULL, 0x040fe40007ffe0ffULL, 0xffffffff2e377810ULL, 0x000fc60007ffe0ffULL,
0x0000003f002c7308ULL, 0x0003f00000000800ULL, 0x0000004c00257308ULL, 0x0007e20000000800ULL,
0x000000082e3f7824ULL, 0x042fe200078e00ffULL, 0x0000003a3b26723eULL, 0x004fe200000010ffULL,
0x000000082e3b7824ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b333a7823ULL, 0x000fe2000001084bULL,
0xfffffff83f687812ULL, 0x000fe200078ee21aULL, 0x000000ffff3f7224ULL, 0x000fe200078e0004ULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0xfffffff81f4c7812ULL, 0x008fe400078ee218ULL,
0x000000055618723eULL, 0x000fe200000010ffULL, 0x000000ffff057224ULL, 0x000fe200078e0004ULL,
0x00000051581a723eULL, 0x000fe200000010ffULL, 0x000000082e567824ULL, 0x000fe200078e00ffULL,
0x00000027281f723eULL, 0x000fe200000010ffULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x000000052e287810ULL, 0x000fc40007ffe0ffULL, 0xfffffff856567812ULL, 0x000fe200078ee237ULL,
0x3fb8aa3b32377823ULL, 0x000fc8000001084bULL, 0x0000005000507308ULL, 0x000ea20000000800ULL,
0x000000254e25723eULL, 0x002fe400000010ffULL, 0xfffffff83b4e7812ULL, 0x000fe200078ee228ULL,
0x3fb8aa3b353b7823ULL, 0x000fc8000001084bULL, 0x0000003100607308ULL, 0x000e700000000800ULL,
0x00000034005b7308ULL, 0x000fe20000000800ULL, 0x0000004f5027723eULL, 0x004fce00000010ffULL,
0x0000004400347308ULL, 0x000fe20000000800ULL, 0x000000596035723eULL, 0x002fce00000010ffULL,
0x0000004500317308ULL, 0x000ff00000000800ULL, 0x0000004600367308ULL, 0x000e700000000800ULL,
0x0000004700397308ULL, 0x0005f00000000800ULL, 0x0000002900177308ULL, 0x000fe20000000800ULL,
0x000000041844723cULL, 0x004b6200000418ffULL, 0x000000313632723eULL, 0x002fcc00000010ffULL,
0x3fb8aa3b3e057823ULL, 0x020fe2000001084bULL, 0x0000003c00297308ULL, 0x000e620000000800ULL,
0x000000ffff3e7224ULL, 0x000fce00078e0004ULL, 0x0000003d002b7308ULL, 0x0005f00000000800ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x0000003e243c723cULL, 0x004f6200000418ffULL,
0x000000292c28723eULL, 0x002fc400000010ffULL, 0x000000082e2c7810ULL, 0x000fc80007ffe0ffULL,
0x0000004200427308ULL, 0x000ff00000000800ULL, 0x0000004d004d7308ULL, 0x000ff00000000800ULL,
0x0000004800487308ULL, 0x000e700000000800ULL, 0x0000000500167308ULL, 0x0004f00000000800ULL,
0x0000004900647308ULL, 0x0009e20000000800ULL, 0x000000ffff057224ULL, 0x004fe200078e0004ULL,
0x0000004d4829723eULL, 0x002fc400000010ffULL, 0x0000002b162b723eULL, 0x008fe200000010ffULL,
0x000000082e497824ULL, 0x010fc600078e00ffULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f167823ULL, 0x000fe2000001084bULL, 0x000000041c44723cULL, 0x000b620000041844ULL,
0x000000082e2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff849507812ULL, 0x000fe200078ee22aULL,
0x000000082c497824ULL, 0x000fe200078e00ffULL, 0x00000041422a723eULL, 0x000fe400000010ffULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x000000102e417810ULL, 0x000fe40007ffe0ffULL,
0xfffffff849487812ULL, 0x000fc400078ee22cULL, 0x0000005c283c723cULL, 0x020f62000004183cULL,
0xfffffff82f427812ULL, 0x000fe200078ee22eULL, 0x0000000841587824ULL, 0x000fe200078e00ffULL,
0x0000001500157308ULL, 0x000fe20000000800ULL, 0x000000575e2f723eULL, 0x000fc600000010ffULL,
0xfffffff858587812ULL, 0x000fe400078ee241ULL, 0x0000000c13417812ULL, 0x000fe400078ec0ffULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x00000010112c723eULL, 0x002fce00000010ffULL,
0x0000002d00337308ULL, 0x0003f00000000800ULL, 0x0000001600167308ULL, 0x000ea20000000800ULL,
0x00000017202d723eULL, 0x002fe200000010ffULL, 0x000000ffff177224ULL, 0x000fcc00078e0004ULL,
0x0000004300437308ULL, 0x000ff00000000800ULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x000000331633723eULL, 0x004fe200000010ffULL, 0x000000ffff167224ULL, 0x000fcc00078e0004ULL,
0x0000003000057308ULL, 0x0002b00000000800ULL, 0x0000000900097308ULL, 0x000fe20000000800ULL,
0x000000182e307810ULL, 0x002fe40007ffe0ffULL, 0x00000015522e723eULL, 0x000fc600000010ffULL,
0x0000000830117824ULL, 0x000fe400078e00ffULL, 0x0000000a000a7308ULL, 0x000e620000000800ULL,
0x000000400531723eULL, 0x004fe200000010ffULL, 0x0000005c2c44723cULL, 0x000f620000041844ULL,
0xfffffff811527812ULL, 0x000fe400078ee230ULL, 0x000000433430723eULL, 0x000fe200000010ffULL,
0x000000ffff437224ULL, 0x000fe400078e0004ULL, 0x0000000b000b7308ULL, 0x000fe80000000800ULL,
0x00000016303c723cULL, 0x020b68000004183cULL, 0x0000001200127308ULL, 0x000ea20000000800ULL,
0x000000090a34723eULL, 0x002fc400000010ffULL, 0x0001200002097811ULL, 0x000fca00078e60ffULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x00000010420a7824ULL, 0x100fe400078e0209ULL,
0x0000001054117824ULL, 0x100fe400078e0209ULL, 0x0000001066137824ULL, 0x100fe400078e0209ULL,
0x0000001068157824ULL, 0x100fe200078e0209ULL, 0x0000003800387308ULL, 0x000e620000000800ULL,
0x0000000b1236723eULL, 0x004fe200000010ffULL, 0x000000104c127824ULL, 0x000fc400078e0209ULL,
0x00000001410b7824ULL, 0x040fe400078e020aULL, 0x00000010480a7824ULL, 0x100fe200078e0209ULL,
0x000000396448723eULL, 0x000fe200000010ffULL, 0x0000004a004a7308ULL, 0x000ea20000000800ULL,
0x000000ffff427224ULL, 0x100fe200078e0004ULL, 0x000000180b007388ULL, 0x0007e20000000800ULL,
0x000000104e167824ULL, 0x020fe400078e0209ULL, 0x000000ffff397224ULL, 0x100fe400078e0004ULL,
0x0000000141117824ULL, 0x000fe200078e0211ULL, 0x0000003700107308ULL, 0x0009e20000000800ULL,
0x0000003b384b723eULL, 0x002fe200000010ffULL, 0x000000ffff387224ULL, 0x000fc400078e0004ULL,
0x0000001050177824ULL, 0x100fe200078e0209ULL, 0x0000001a11007388ULL, 0x0007e20000000800ULL,
0x0000000141127824ULL, 0x000fe400078e0212ULL, 0x0000003a00057308ULL, 0x000e620000000800ULL,
0x0000005b6237723eULL, 0x010fe200000010ffULL, 0x0000001056207824ULL, 0x000fe200078e0209ULL,
0x0000004a214a723eULL, 0x004fe200000010ffULL, 0x0000000141137824ULL, 0x040fe200078e0213ULL,
0x0000001c12007388ULL, 0x0007e20000000800ULL, 0x0000000141157824ULL, 0x000fc400078e0215ULL,
0x0000000141167824ULL, 0x040fe200078e0216ULL, 0x000000423444723cULL, 0x000f620000041844ULL,
0x0000000141177824ULL, 0x040fe200078e0217ULL, 0x0000001e13007388ULL, 0x0007e20000000800ULL,
0x0000000141207824ULL, 0x040fe400078e0220ULL, 0x00000001410a7824ULL, 0x000fe200078e020aULL,
0x0000002c15007388ULL, 0x0007e20000000800ULL, 0x000000100549723eULL, 0x002fe200000010ffULL,
0x00000010583a7824ULL, 0x100fe400078e0209ULL, 0x0000002e16007388ULL, 0x0007e20000000800ULL,
0x0000001052097824ULL, 0x000fc400078e0209ULL, 0x0000000141057824ULL, 0x040fe200078e023aULL,
0x00000038483c723cULL, 0x000f62000004183cULL, 0x0000003417007388ULL, 0x0007e20000000800ULL,
0x0000000141047824ULL, 0x000fc600078e0209ULL, 0x0000003620007388ULL, 0x0007e80000000800ULL,
0x000000190a007388ULL, 0x0007e20000000800ULL, 0x000000ffff457224ULL, 0x020fc600078e0046ULL,
0x0004001b11007388ULL, 0x0007e80000000800ULL, 0x0004001d12007388ULL, 0x0007e80000000800ULL,
0x0004001f13007388ULL, 0x0007e60000000800ULL, 0x000000ffff467224ULL, 0x000fe200078e003cULL,
0x0004002d15007388ULL, 0x0007e20000000800ULL, 0x000000ffff477224ULL, 0x000fc600078e003eULL,
0x0004002f16007388ULL, 0x0007e80000000800ULL, 0x0004003517007388ULL, 0x0007e80000000800ULL,
0x0004003720007388ULL, 0x0007e80000000800ULL, 0x0000002405007388ULL, 0x0007e80000000800ULL,
0x0008002611007388ULL, 0x0007e80000000800ULL, 0x0008002812007388ULL, 0x0007e80000000800ULL,
0x0008002a13007388ULL, 0x0007e80000000800ULL, 0x0008003015007388ULL, 0x0007e80000000800ULL,
0x0008003216007388ULL, 0x0007e80000000800ULL, 0x0008004817007388ULL, 0x0007e80000000800ULL,
0x0008004a20007388ULL, 0x0007e80000000800ULL, 0x0000002504007388ULL, 0x0007e80000000800ULL,
0x000c002711007388ULL, 0x0007e80000000800ULL, 0x000c002912007388ULL, 0x0007e80000000800ULL,
0x000c002b13007388ULL, 0x0007e80000000800ULL, 0x000c003115007388ULL, 0x0007e80000000800ULL,
0x000c003316007388ULL, 0x0007e80000000800ULL, 0x000c004917007388ULL, 0x0007e80000000800ULL,
0x000c004b20007388ULL, 0x0007e80000000800ULL, 0x01e0000c14008388ULL, 0x0007e80000000c00ULL,
0x01e2004414008388ULL, 0x0007e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6080022ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6100022ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6180022ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000079000720cULL, 0x000fe20003f06070ULL, 0x01e6200022ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff047224ULL, 0x008fd600078e0090ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff73f000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x00019d6000297802ULL, 0x000fc40000000f00ULL, 0x000015f000007944ULL, 0x008fea0003c00000ULL,
0x0000002800137202ULL, 0x000fe20000000f00ULL, 0xfffe919000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x00019dc000297802ULL, 0x000fc40000000f00ULL, 0x0000159000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0028ULL, 0xfffe91d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x00019e3000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000014d000007944ULL, 0x008fea0003c00000ULL, 0xfffe928000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x00019e9000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000147000007944ULL, 0x00afea0003c00000ULL, 0xfffe939000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x00019ef000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000141000007944ULL, 0x00afea0003c00000ULL, 0xfffe94a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x00019f5000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000013b000007944ULL, 0x00afea0003c00000ULL, 0xfffe95a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x00019fc000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0011ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000134000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0xfffe973000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x0001a03000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000012d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0x0000001011297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0012ULL,
0x0001a0a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000126000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0029ULL, 0xfffe96a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x0001a11000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000011f000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0029ULL,
0xfffe966000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001a17000297802ULL, 0x000fc40000000f00ULL,
0x000011e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0028ULL,
0xfffeadc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20004800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001a1d000297802ULL, 0x000fc40000000f00ULL,
0x0000118000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e0028ULL,
0xfffeae0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x0001a24000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000010c000007944ULL, 0x008fea0003c00000ULL,
0xfffeaec000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x0001a2a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000106000007944ULL, 0x00afea0003c00000ULL,
0xfffeafd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x0001a30000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000100000007944ULL, 0x00afea0003c00000ULL,
0xfffeb0e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x0001a36000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000fa000007944ULL, 0x00afea0003c00000ULL,
0xfffeb1e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001a3d000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e001cULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000f3000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0xfffeb36000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001a44000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ec000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0x000000101c297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001a4b000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000e5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0029ULL,
0xfffeb2d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001a52000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000de000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0029ULL, 0xfffeb29000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001a58000297802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff6d7224ULL, 0x000fe200078e0028ULL, 0xfffec7b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20004800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001a5e000297802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff267224ULL, 0x000fe200078e0028ULL, 0xfffec7f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x0001a65000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000cb000007944ULL, 0x008fea0003c00000ULL, 0xfffec8b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x0001a6b000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000c5000007944ULL, 0x00afea0003c00000ULL, 0xfffec9c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x0001a71000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000bf000007944ULL, 0x00afea0003c00000ULL, 0xfffecad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x0001a77000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000b9000007944ULL, 0x00afea0003c00000ULL, 0xfffecbd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001a7e000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e006eULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000b2000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0xfffecd6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001a85000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000ab000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0x000000106e297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001a8c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000a4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0029ULL, 0xfffeccd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001a93000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000009d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0029ULL,
0xfffecc9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x008fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001a99000297802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff217224ULL, 0x000fe200078e0028ULL,
0xfffee1e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20004800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001a9f000297802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0028ULL,
0xfffee22000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001aa6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000008a000007944ULL, 0x002fea0003c00000ULL,
0xfffee2e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001aac000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000084000007944ULL, 0x002fea0003c00000ULL,
0xfffee3f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001ab2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000007e000007944ULL, 0x002fea0003c00000ULL,
0xfffee50000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001ab8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000078000007944ULL, 0x002fea0003c00000ULL,
0xfffee60000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001abf000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0011ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000071000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0xfffee79000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001ac6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0x0000001011297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001acd000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0029ULL,
0xfffee70000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001ad4000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x006fea0003c00000ULL,
0x0000002900117202ULL, 0x004fe20000000f00ULL, 0xfffee6c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x000fe200078e0021ULL, 0x0001adc000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe400078e00ffULL, 0x0000001fff047424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0xffffda6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0f7224ULL, 0x002fe200078e0055ULL,
0x0001ae3000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe400078e00ffULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000045500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0057ULL, 0x0001aeb000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x00000055040d7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000045700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0056ULL, 0x0001af3000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x0000005704517208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000045600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0059ULL, 0x0001afb000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x0000005604217208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000045900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e000dULL, 0x0001b03000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x00000059040c7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000040d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0051ULL, 0x0001b0b000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x0000000d040d7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000045100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0f7224ULL, 0x002fe200078e0021ULL, 0x0001b13000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x00000051040e7208ULL, 0x000fe20004000000ULL,
0x0000001fff047424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff547224ULL, 0x006fe200078e0004ULL,
0xffffd84000007947ULL, 0x000fea000383ffffULL, 0x018000000a047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f800000040d7812ULL, 0x000fc800078ec0ffULL,
0x018000000d00780cULL, 0x000fda0003f05070ULL, 0x0000000a00048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0d00720cULL, 0x040fe40003f25070ULL,
0x008000000d00780cULL, 0x000fe40003f02070ULL, 0x00000001ff0d7807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x000000040dff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x040fe4000780c0ffULL,
0x800000000a0a7812ULL, 0x002fe400078ec0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x000000040dff7212ULL, 0x000fda000780c0ffULL, 0x008000000a040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e000aULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000a00047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff0d7424ULL, 0x000fc800078e00ffULL, 0xfffe4d400c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005b00007348ULL, 0x000fe80003800000ULL,
0x0c0000540f047389ULL, 0x0002a200000e0004ULL, 0xfffe4d0052007950ULL, 0x000fea0003c3ffffULL,
0x0000002b00007348ULL, 0x000fe80003800000ULL, 0x000000292a297389ULL, 0x0002a400000e006cULL,
0x000000ffff2a7224ULL, 0x002fc400078e0028ULL, 0x00000000ff2b7424ULL, 0x000fc800078e00ffULL,
0xfffe4cb02a007950ULL, 0x000fea0003c3ffffULL, 0x000000012800780cULL, 0x000fe20003f45070ULL,
0x0000002a00007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fd000078e00ffULL,
0x0000000000287806ULL, 0x000fc800050e0100ULL, 0x0000002a28287212ULL, 0x000fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fc800078e0029ULL, 0xfffe4c402a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004ccULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000628ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000868ULL,
0x0000000000000338ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ba0ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c60ULL,
0x00000000000006d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001330ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001340ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013d0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013d4ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001600ULL,
0x000000000001b480ULL, 0xdb00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ca80ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001cac0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001ce40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000013d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001b6b0ULL,
0x000000000001b6b0ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001ca80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001ce40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_32_sm_80_cubin_len = 118560;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
