/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014db0ULL, 0x0000000000014a30ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f34314944327961ULL, 0x6f6c66625f766e5fULL, 0x326a4c3236317461ULL, 0x61324545386a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL,
0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL,
0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL,
0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x6c65722e00687461ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL,
0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000000beULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000fcULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000135ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0001000001c6ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b00010000020cULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b000100000253ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000299ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000002e7ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000335ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b00010000037bULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000003d6ULL, 0x0000000000013680ULL, 0x0000000000000280ULL, 0x000400030000044cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000013900ULL, 0x000d00030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001368000000000ULL, 0x0001400400000000ULL, 0x0000288080810c00ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8d08288080840828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808d920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL,
0x0000006000000000ULL, 0x0001368000000000ULL, 0x0000028000000000ULL, 0x0000480400000000ULL,
0x8082288080840900ULL, 0x0900000010042880ULL, 0x288080842880808dULL, 0x0000001400082f04ULL,
0x0008230400000080ULL, 0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL,
0x0000000000000012ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000a00000000ULL,
0x000c17040021f000ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0xffffffff00b42904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000002e000b42804ULL, 0x0000083000000340ULL, 0x00002d3000001e10ULL, 0x00002e9000002db0ULL,
0x0000333000002fd0ULL, 0x0000381000003340ULL, 0x000046a000004630ULL, 0x000048e0000047a0ULL,
0x00004b0000004af0ULL, 0x00005d1000004f10ULL, 0x00005e8000005d80ULL, 0x0000625000005fc0ULL,
0x0000667000006260ULL, 0x00007560000074d0ULL, 0x0000777000007630ULL, 0x00007a1000007a00ULL,
0x00007f2000007f10ULL, 0x0000a0f00000a0c0ULL, 0x0000a8000000a7f0ULL, 0x00012b4000012a90ULL,
0x00012e2000012d70ULL, 0x000130f000012fb0ULL, 0x000133c000013350ULL, 0x0000055001f03904ULL,
0x0001b600000000ffULL, 0x0000063000040100ULL, 0x0001b60800000005ULL, 0x00000740003f0100ULL,
0x0001b68800000006ULL, 0x00000ea0003f0100ULL, 0x0001b60000000007ULL, 0x00000fc0003f0107ULL,
0x0001b68800000000ULL, 0x00002aa0003f0101ULL, 0x0001b60800000020ULL, 0x00002ae0003f0101ULL,
0x0001b60800000023ULL, 0x00002c50003f0109ULL, 0x0001b60800000023ULL, 0x000037c0003f0109ULL,
0x0001b68800000021ULL, 0x00004400003f0101ULL, 0x0001b62800000023ULL, 0x00004420003f0101ULL,
0x0001b62800000023ULL, 0x00004590003f0109ULL, 0x0001b62800000023ULL, 0x00004ee0003f0109ULL,
0x0001b69000000021ULL, 0x00005af0003f0101ULL, 0x0001b64800000021ULL, 0x00005b10003f0101ULL,
0x0001b64800000021ULL, 0x00005c80003f0109ULL, 0x0001b64800000021ULL, 0x00006640003f0109ULL,
0x0001b69800000021ULL, 0x000072b0003f0101ULL, 0x0001b66800000021ULL, 0x000072d0003f0101ULL,
0x0001b66800000021ULL, 0x00007440003f0109ULL, 0x0001b66800000021ULL, 0x00007ca0003f0109ULL,
0x0001b6a000000024ULL, 0x0000b770003f0101ULL, 0x0001b60000000007ULL, 0x0000cfb0003f0101ULL,
0x0001b60000000007ULL, 0x0000d170003f0109ULL, 0x0001b60000000007ULL, 0x00010ec0003f0109ULL,
0x0001b6880000004bULL, 0x00011130003f0101ULL, 0x0001b6880000004bULL, 0x000112a0003f0109ULL,
0x0001b6880000004bULL, 0x00013620003f0109ULL, 0x0001b6080000000eULL, 0x00013630003f0101ULL,
0x0001b6100000000eULL, 0x00013640003f0101ULL, 0x0001b6180000000eULL, 0x00013650003f0101ULL,
0x0001b6200000000eULL, 0x00033803003f0101ULL, 0x0000ae4000201c04ULL, 0x0000b1200000ae60ULL,
0x0000b5100000b310ULL, 0x0000d1a00000b6c0ULL, 0x000c050400013670ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001500080a04ULL, 0x0000000000600210ULL,
0x00000000000000ccULL, 0x0000001400000002ULL, 0x0000000000013680ULL, 0x0000000000000044ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x00000000000000a2ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008800ff027b82ULL, 0x000ea20000000a00ULL,
0x0000820000067ab9ULL, 0x000fce0000000a00ULL, 0x00008500ff0e7b82ULL, 0x000ee20000000800ULL,
0x000000ff0200720cULL, 0x004fe40003f45070ULL, 0x0000000000027919ULL, 0x000ea40000002700ULL,
0x000000ff0300720cULL, 0x000fda0003f45320ULL, 0x00008800ff042b82ULL, 0x000f220000000a00ULL,
0x0000000102032836ULL, 0x004fe40000000000ULL, 0x0000000402062825ULL, 0x010fc800078e0004ULL,
0x0000000403042825ULL, 0x000fe400078e0004ULL, 0x0000000606032981ULL, 0x000ea8000c1e1900ULL,
0x0000000604002981ULL, 0x0008a2000c1e1900ULL, 0x0000000e000a7306ULL, 0x008ee20000209000ULL,
0x000000ff0e00720cULL, 0x000fe20003f65070ULL, 0x00000000000579c3ULL, 0x000fe20000002600ULL,
0x0000000000127919ULL, 0x000f620000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000d7919ULL, 0x000f620000002200ULL, 0x00000000000f7919ULL, 0x000f240000002100ULL,
0x0000000a000a7308ULL, 0x008ee40000001000ULL, 0x0ffffffe0a087836ULL, 0x008fcc0000000000ULL,
0x0000000800097305ULL, 0x000724000021f000ULL, 0x000000ffff087224ULL, 0x008fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x012fc800078e0a09ULL, 0x0000000e0b0b7224ULL, 0x000fc800078e02ffULL,
0x0000000b09097227ULL, 0x000fe400078e0008ULL, 0x00000300ff0b7b82ULL, 0x000e620000000800ULL,
0x0000040000047ab9ULL, 0x000fc60000000800ULL, 0x0000000409097c27ULL, 0x000fc8000f8e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a09ULL, 0x000000040e057e24ULL, 0x000fe2000f8e0205ULL,
0x0000010000047ab9ULL, 0x000fc80000000800ULL, 0x0000000e0500720cULL, 0x000fda0003f06070ULL,
0x0000000105050824ULL, 0x000fe400078e0a0eULL, 0x0000000109090836ULL, 0x000fc60000000000ULL,
0x0000000e0500720cULL, 0x000fda0003f26070ULL, 0x0000000109091810ULL, 0x000fe40007ffe0ffULL,
0x0000000eff09b212ULL, 0x000fc800078e33ffULL, 0x0000000900067306ULL, 0x000ee20000209000ULL,
0x000000ff0900720cULL, 0x000fce0003f85070ULL, 0x0000000600067308ULL, 0x008ee40000001000ULL,
0x0ffffffe06047836ULL, 0x008fe40000000000ULL, 0x0000000412067c24ULL, 0x020fe2000f8e020dULL,
0x0000000000047ab9ULL, 0x000fc60000000800ULL, 0x0000000400057305ULL, 0x000722000021f000ULL,
0x00001fff12127589ULL, 0x000e6200000e0000ULL, 0x0000000406067c24ULL, 0x100fe2000f8e020fULL,
0x00000000000479c3ULL, 0x000f620000002500ULL, 0x00000005ff0f7819ULL, 0x000fc6000001160fULL,
0x0000007f0600780cULL, 0x000fe20003f64070ULL, 0x000000ffff047224ULL, 0x008fe400078e00ffULL,
0x00001fff0f0f7589ULL, 0x000e6200000e0000ULL, 0x0000000509077224ULL, 0x010fc800078e02ffULL,
0x000000ffff077224ULL, 0x000fc800078e0a07ULL, 0x0000000705057227ULL, 0x000fe400078e0004ULL,
0x00008400ff07ab82ULL, 0x000e640000000800ULL, 0x00000004ff4a7e24ULL, 0x020fe4000f8e00ffULL,
0x0000000505497c27ULL, 0x000fe4000f8e00ffULL, 0x000000000005b919ULL, 0x000ee40000008800ULL,
0x000000ffff047224ULL, 0x000fc800078e0a49ULL, 0x0000000509047e24ULL, 0x000fca000f8e0204ULL,
0x000000090400720cULL, 0x000fda0003f06070ULL, 0x0000000104040824ULL, 0x000fe400078e0a09ULL,
0x0000000149490836ULL, 0x000fe20000000000ULL, 0x000000ff0600720cULL, 0x000fe40003f05270ULL,
0x000000090400720cULL, 0x000fe40003f26070ULL, 0x000004000004b802ULL, 0x000fc80000000f00ULL,
0x000006540505b816ULL, 0x008fca0000000004ULL, 0x000000040604b824ULL, 0x040fe400078e0205ULL,
0x0000000149491810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff49c212ULL, 0x000fe400078e33ffULL,
0x0000000f0600780cULL, 0x040fe40003f24070ULL, 0x000000030600780cULL, 0x000fe20003f84070ULL,
0x000000ffff487224ULL, 0x000fc800078e0a49ULL, 0x0000000509487e24ULL, 0x000fe4000f8e0248ULL,
0xff317217ff09b424ULL, 0x000fe400078e00ffULL, 0x0000000100002824ULL, 0x004fcc00078e0a03ULL,
0x00008400ff00ab82ULL, 0x002e640000000800ULL, 0x0000000000240947ULL, 0x002fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000087882ULL, 0x000fe20000000000ULL, 0x7ffc000000097882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x01b60008043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000406057c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050812caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01b60804083f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000406067c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000060812caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01b68804083f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001048487824ULL, 0x000fe200078e00ffULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000070203a224ULL, 0x000fe200078e02ffULL, 0x01b400090400b388ULL, 0x0005e20000000800ULL,
0x0000000400057c24ULL, 0x002fe4000f8e02ffULL, 0x000000ffff0a7224ULL, 0x000fe400078e0a48ULL,
0x000000040e107c24ULL, 0x000fe2000f8e02ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000480500720cULL, 0x000fe20003f06070ULL, 0x0000001003097224ULL, 0x004fe200078e02ffULL,
0x00000010050a7446ULL, 0x000fe2000380000aULL, 0x0000000412057824ULL, 0x000fc400078e020fULL,
0x0000000449157c24ULL, 0x000fe2000f8e0209ULL, 0x000000ff0a0a7207ULL, 0x000fe40000000000ULL,
0x0000000105077819ULL, 0x000fe400000006ffULL, 0x000000100a00780cULL, 0x000fda0003f05270ULL,
0x0000000000c08947ULL, 0x000fea0003800000ULL, 0x00000004000c7d06ULL, 0x000e620008209000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00000004ff007c0cULL, 0x000fe2000bf45070ULL, 0x0000000000147919ULL, 0x000ee80000008800ULL,
0x0000000c000c7308ULL, 0x002e640000001000ULL, 0x0ffffffe0c057836ULL, 0x002fe20000000000ULL,
0x00000004ff067819ULL, 0x004fca0000011608ULL, 0x0000000500057305ULL, 0x000e62000021f000ULL,
0x00000001070d7824ULL, 0x000fe400078e0206ULL, 0x000000ffff117224ULL, 0x002fc800078e0a05ULL,
0x0000000411117c24ULL, 0x000fc8000f8e02ffULL, 0x0000001105117227ULL, 0x000fc800078e0004ULL,
0x0000000148047824ULL, 0x000fc800078e020dULL, 0x0000000411117227ULL, 0x000fc800078e00ffULL,
0x000000ffff137224ULL, 0x000fc800078e0a11ULL, 0x0000000413057c24ULL, 0x000fca000f8e0204ULL,
0x0000000405007c0cULL, 0x000fda000bf06070ULL, 0x8000000405050c36ULL, 0x000fe20008000000ULL,
0x0000000111110810ULL, 0x000fc80007ffe0ffULL, 0x0000000405007c0cULL, 0x000fda000bf26070ULL,
0x0000000111111836ULL, 0x000fe20000000000ULL, 0x00000004ff11ac12ULL, 0x000fca000f8e33ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a11ULL, 0x0000000405047c24ULL, 0x000fe2000f8e0204ULL,
0x00008c0000047ab9ULL, 0x000fc60000000a00ULL, 0x00000001150c7824ULL, 0x000fe200078e0204ULL,
0x000000070a047248ULL, 0x000fc60007fe0000ULL, 0x0000001011057224ULL, 0x000fe400078e020cULL,
0x00000010080c7824ULL, 0x000fe400078e00ffULL, 0x0000000104077824ULL, 0x000fe400078e0a07ULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f00c117812ULL, 0x000fe400078ec0ffULL,
0x000000070600720cULL, 0x000fe20003f06070ULL, 0x000000010d067824ULL, 0x040fe200078e0208ULL,
0x0000040000077802ULL, 0x000fe20000000f00ULL, 0x000000100d0d7824ULL, 0x000fe200078e00ffULL,
0x0000001104117212ULL, 0x000fc400078efcffULL, 0x0000065414077816ULL, 0x008fe40000000007ULL,
0x0000000411047c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff00d067812ULL, 0x000fe400078ee206ULL,
0x0000000505057c10ULL, 0x000fe40008ffe4ffULL, 0x00000007060d7211ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e2000c101c46ULL,
0x0000000000ac7947ULL, 0x000fea0003800000ULL, 0x0000000400067d06ULL, 0x000e620008209000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x00000004ff007c0cULL, 0x000fe2000bf45070ULL, 0x0000000000117919ULL, 0x000ee80000008800ULL,
0x0000000600067308ULL, 0x002e640000001000ULL, 0x0ffffffe060c7836ULL, 0x002fe20000000000ULL,
0x0000000708077211ULL, 0x004fca00078fe0ffULL, 0x0000000c00057305ULL, 0x0002a4000021f000ULL,
0x00000010080c7824ULL, 0x002fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x004fc800078e0a05ULL,
0x000000040d0d7c24ULL, 0x000fc8000f8e02ffULL, 0x0000000d05057227ULL, 0x000fc800078e0004ULL,
0x0000000148047824ULL, 0x000fc800078e0207ULL, 0x0000000405057227ULL, 0x000fc800078e00ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a05ULL, 0x000000040d067c24ULL, 0x000fca000f8e0204ULL,
0x0000000406007c0cULL, 0x000fda000bf06070ULL, 0x8000000406060c36ULL, 0x000fe40008000000ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x0000000406007c0cULL, 0x000fe2000bf26070ULL,
0x0000000107067824ULL, 0x000fd800078e0208ULL, 0x0000000105051810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff05ac12ULL, 0x000fca000f8e33ffULL, 0x000000ffff0d7224ULL, 0x000fc800078e0a05ULL,
0x000000040d047c24ULL, 0x000fe2000f8e0204ULL, 0x000000f00c0d7812ULL, 0x000fe200078ec0ffULL,
0x00008c0000047ab9ULL, 0x000fe40000000a00ULL, 0x0000000115047824ULL, 0x000fc800078e0204ULL,
0x0000001005047224ULL, 0x000fe200078e0204ULL, 0x0000040000107802ULL, 0x000fc60000000f00ULL,
0x0000010004047825ULL, 0x000fc600078e00ffULL, 0x0000000d04047212ULL, 0x000fe200078efcffULL,
0x00000010070d7824ULL, 0x000fe200078e00ffULL, 0x0000065411077816ULL, 0x008fe40000000010ULL,
0x0000000404047c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff00d067812ULL, 0x000fe400078ee206ULL,
0x0000000505057c10ULL, 0x000fc600087fe4ffULL, 0x00000010060d7824ULL, 0x000fca00078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040d7faeULL, 0x0003e4000b901c46ULL,
0x00000000070472caULL, 0x000fe200000e0000ULL, 0x00009200ff107b82ULL, 0x000ea20000000a00ULL,
0x0000000000007918ULL, 0x002fd60000000000ULL, 0x0001b60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000402107825ULL, 0x004fe200078e0010ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000610067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff1200720cULL, 0x000fe20003f05270ULL,
0x000000ff06057836ULL, 0x004fca0000000000ULL, 0x00000008ff057819ULL, 0x000fce0000011605ULL,
0x000000a400e08947ULL, 0x000fea0003800000ULL, 0x000000030f047819ULL, 0x000fe200000006ffULL,
0x00000004ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000001ff4f7819ULL, 0x000fe2000001160fULL,
0x0000000202037824ULL, 0x000fe200078e00ffULL, 0x0000940000047ab9ULL, 0x000fe20000000800ULL,
0x0000000107007824ULL, 0x000fe400078e0204ULL, 0x0000000e03027224ULL, 0x000fe400078e020eULL,
0x01b6880d00ff79a7ULL, 0x0003e2000850003fULL, 0x000000204f037824ULL, 0x000fc400078e00ffULL,
0x0000000149027824ULL, 0x000fe400078e0202ULL, 0x000001004a177824ULL, 0x000fc800078e0203ULL,
0x0000000402157c24ULL, 0x000fe4000f8e0217ULL, 0x000000014a007836ULL, 0x002fca0000000000ULL,
0x000000050000720cULL, 0x000fe40003f06070ULL, 0x000000010f007812ULL, 0x000fd600078ec0ffULL,
0x0000000400988947ULL, 0x000fea0003800000ULL, 0x000000700c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x00000003ff1d7819ULL, 0x000fe40000011608ULL,
0x0000000d000c7211ULL, 0x000fe200078e38ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x00000017060e7248ULL, 0x000fe20007fe0000ULL, 0x0000000115117824ULL, 0x000fe200078e021dULL,
0x000000081d257810ULL, 0x000fe20007ffe0ffULL, 0x000000041d137836ULL, 0x000fe40000000000ULL,
0x0000010011107825ULL, 0x000fc800078e000cULL, 0x000000ffff177224ULL, 0x000fe200078e0a17ULL,
0x0000000410187c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000113127824ULL, 0x140fe400078e0208ULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0x000000200e0e7446ULL, 0x000fe20003800017ULL,
0x0000000c1d277836ULL, 0x000fe40000000000ULL, 0x0000000115177824ULL, 0x000fe200078e0225ULL,
0xfffffff8191c7812ULL, 0x000fe200078ee212ULL, 0x000000011d127824ULL, 0x000fe200078e0208ULL,
0x0000000511197c10ULL, 0x000fe200087fe4ffULL, 0x000040004f117824ULL, 0x000fe200078e0207ULL,
0x0000000e1300720cULL, 0x080fe20003f26070ULL, 0x0000000115137824ULL, 0x000fe200078e0213ULL,
0x00000007121b7812ULL, 0x000fe200078ec0ffULL, 0x0000200000147824ULL, 0x000fe200078e0211ULL,
0x0000000e1d00720cULL, 0x080fe20003f06070ULL, 0x0000010013107825ULL, 0x000fe200078e000cULL,
0x0000000e2500720cULL, 0x000fc40003fa6070ULL, 0x0000000e2700720cULL, 0x000fe20003f86070ULL,
0x00000001151f7824ULL, 0x000fe200078e0227ULL, 0x00000004101a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000010017127825ULL, 0x000fc800078e000cULL, 0x000001001f167825ULL, 0x000fe200078e000cULL,
0x0000000412107c10ULL, 0x000fc6000ff7e0ffULL, 0x00013000141f7836ULL, 0x000fe20000000000ULL,
0x0ffffff81b147812ULL, 0x000fe200078ef808ULL, 0x000000101d297836ULL, 0x000fe20000000000ULL,
0x00000005111b7c10ULL, 0x000fe200097fe4ffULL, 0x000000101c237824ULL, 0x000fe200078e021fULL,
0x0000000416127c10ULL, 0x000fe2000ff5e0ffULL, 0x000000141d2b7836ULL, 0x000fe20000000000ULL,
0x0000000513117c10ULL, 0x000fe20009ffe4ffULL, 0x000000181d2d7836ULL, 0x000fe20000000000ULL,
0x0000000517137c10ULL, 0x000fe200097fe4ffULL, 0x0000000115177824ULL, 0x000fe200078e0229ULL,
0x0000001f14217211ULL, 0x000fe200078e20ffULL, 0x0000001c1d2f7836ULL, 0x000fe20000000000ULL,
0x0000000e2900720cULL, 0x080fe20003f66070ULL, 0x0000010017167825ULL, 0x000fe200078e000cULL,
0x0000000e2b00720cULL, 0x080fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018217faeULL, 0x0003e2000c101c46ULL, 0x0000000e2f00720cULL, 0x080fe20003f06070ULL,
0x0000000125147824ULL, 0x140fe200078e0208ULL, 0x0000000325257819ULL, 0x000fe200000006ffULL,
0x000000001a237faeULL, 0x0005e2000c901c46ULL, 0x0000000e2d00720cULL, 0x000fe20003f26070ULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8250e7812ULL, 0x000fe200078ee214ULL,
0x0000000129147824ULL, 0x040fe200078e0208ULL, 0x0000002d151d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000829297824ULL, 0x000fc400078e00ffULL, 0x0000000127197824ULL, 0x002fe200078e0208ULL,
0x0000000416187c10ULL, 0x000fe2000ffde0ffULL, 0x0000000115217824ULL, 0x000fe200078e022fULL,
0xfffffff8291c7812ULL, 0x000fe200078ee214ULL, 0x00000008271a7824ULL, 0x004fe400078e00ffULL,
0x00000001151b7824ULL, 0x000fe400078e022bULL, 0x000001001d147825ULL, 0x100fe200078e000cULL,
0xfffffff81a1a7812ULL, 0x000fe400078ee219ULL, 0x0000000517197c10ULL, 0x000fe2000b7fe4ffULL,
0x000001001b167825ULL, 0x000fc800078e000cULL, 0x000000012b1b7824ULL, 0x100fe200078e0208ULL,
0x0000000416167c10ULL, 0x000fe2000ffde0ffULL, 0x000000082d207824ULL, 0x000fe400078e00ffULL,
0x000000012f1d7824ULL, 0x100fe200078e0208ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee21bULL,
0x000000012d1b7824ULL, 0x000fe200078e0208ULL, 0x0000000517177c10ULL, 0x000fe2000b7fe4ffULL,
0x000000082f227824ULL, 0x000fe200078e00ffULL, 0x0000000414147c10ULL, 0x000fe2000ffde0ffULL,
0x00000100210c7825ULL, 0x000fe200078e000cULL, 0xfffffff820207812ULL, 0x000fc400078ee21bULL,
0xfffffff822227812ULL, 0x000fe200078ee21dULL, 0x000000100e1b7824ULL, 0x100fe200078e021fULL,
0x0000000515157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000101a1d7824ULL, 0x100fe200078e021fULL,
0x000000040c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x000000101e237824ULL, 0x100fe200078e021fULL,
0x0000001f1c217211ULL, 0x000fe200078e20ffULL, 0x0000001020257824ULL, 0x100fe200078e021fULL,
0x000000050d0d7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000010221f7824ULL, 0x000fe200078e021fULL,
0x00000000101b7faeULL, 0x0003e8000e901c46ULL, 0x00000000121d7faeULL, 0x0003e8000e101c46ULL,
0x0000000018217faeULL, 0x0003e8000d901c46ULL, 0x0000000016237faeULL, 0x0003e8000d101c46ULL,
0x0000000014257faeULL, 0x0003e8000c901c46ULL, 0x000000000c1f7faeULL, 0x0003e2000c101c46ULL,
0x0000000400647947ULL, 0x000fea0003800000ULL, 0x00000004080d7811ULL, 0x040fe200078fe8ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000808107811ULL, 0x040fe400078fe8ffULL,
0x0000001408147811ULL, 0x040fe200078fe8ffULL, 0x000000010d0e7824ULL, 0x140fe200078e0208ULL,
0x0000001008127811ULL, 0x000fe200078fe8ffULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x000000700c1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000110117824ULL, 0x100fe200078e0208ULL,
0x00000008080c7211ULL, 0x000fe200078fe8ffULL, 0x0000000810207824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee20eULL, 0x0000000114167824ULL, 0x100fe200078e0208ULL,
0x0000000c080e7811ULL, 0x000fe200078fe8ffULL, 0x0000000814197824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee211ULL, 0x0000000112137824ULL, 0x040fe200078e0208ULL,
0x000000080e117210ULL, 0x000fe20007ffe0ffULL, 0x0000000812247824ULL, 0x000fe200078e00ffULL,
0xfffffff819267812ULL, 0x000fe200078ee216ULL, 0x000000080e227824ULL, 0x000fe200078e00ffULL,
0x0000001c08167811ULL, 0x000fe200078fe8ffULL, 0x00000080001c7824ULL, 0x000fe200078e021dULL,
0x0000001808187811ULL, 0x000fe200078fe8ffULL, 0x0000000115197824ULL, 0x000fe200078e020eULL,
0xfffffff824247812ULL, 0x000fe200078ee213ULL, 0x00000008161d7824ULL, 0x000fe200078e00ffULL,
0x000000074f137211ULL, 0x000fe200078e70ffULL, 0x0000000118177824ULL, 0x040fe200078e0208ULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000000818287824ULL, 0x000fe200078e00ffULL,
0x000000070c117812ULL, 0x000fe200078ec0ffULL, 0x00002000001a7824ULL, 0x000fe200078e0213ULL,
0x00000008160c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000115137824ULL, 0x040fe200078e020dULL,
0x00000015080d7211ULL, 0x000fe200078fe8ffULL, 0x00000001151b7824ULL, 0x040fe200078e0212ULL,
0xfffffff81d2a7812ULL, 0x000fe200078ee20cULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee217ULL, 0x0000000115177824ULL, 0x000fe200078e0210ULL,
0x0ffffff8110e7812ULL, 0x000fe200078ef808ULL, 0x000001000d0c7825ULL, 0x000fc800078e001cULL,
0x0000010013107825ULL, 0x000fe200078e001cULL, 0x000000040c0c7c10ULL, 0x000fc6000ff1e0ffULL,
0x00000001151f7824ULL, 0x040fe200078e0214ULL, 0x0000000410107c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000115217824ULL, 0x040fe200078e0218ULL, 0x000000050d0d7c10ULL, 0x000fe200087fe4ffULL,
0x0000000115237824ULL, 0x000fe200078e0216ULL, 0x0000000511117c10ULL, 0x000fe20008ffe4ffULL,
0x0000010017127825ULL, 0x000fc800078e001cULL, 0x0000010019147825ULL, 0x000fe200078e001cULL,
0x0000000412127c10ULL, 0x000fc6000ff5e0ffULL, 0x000001001b167825ULL, 0x100fe200078e001cULL,
0x0000000414147c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000513137c10ULL, 0x000fe200097fe4ffULL,
0x000130001a2d7836ULL, 0x000fe20000000000ULL, 0x0000000416167c10ULL, 0x000fe2000ff1e0ffULL,
0x000001001f187825ULL, 0x100fe200078e001cULL, 0x0000000515157c10ULL, 0x000fe40009ffe4ffULL,
0x0000000517177c10ULL, 0x000fe200087fe4ffULL, 0x00000100211a7825ULL, 0x000fe200078e001cULL,
0x0000000418187c10ULL, 0x000fc6000ff3e0ffULL, 0x00000100231c7825ULL, 0x000fe200078e001cULL,
0x0000002d20237211ULL, 0x000fe400078e20ffULL, 0x000000041a1a7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100e1f7824ULL, 0x100fe200078e022dULL, 0x000000041c1c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000101e217824ULL, 0x100fe200078e022dULL, 0x0000000519197c10ULL, 0x000fe20008ffe4ffULL,
0x0000001022257824ULL, 0x100fe200078e022dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1f7faeULL, 0x0003e2000b901c46ULL, 0x0000001024277824ULL, 0x100fe200078e022dULL,
0x000000051b1b7c10ULL, 0x000fe200097fe4ffULL, 0x0000001026297824ULL, 0x100fe200078e022dULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x00000010282b7824ULL, 0x100fe200078e022dULL,
0x000000051d1d7c10ULL, 0x000fe20009ffe4ffULL, 0x000000102a2d7824ULL, 0x000fe200078e022dULL,
0x0000000012237faeULL, 0x0003e8000b901c46ULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000016277faeULL, 0x0003e8000b901c46ULL, 0x0000000018297faeULL, 0x0003e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0003e8000b901c46ULL, 0x000000001c2d7faeULL, 0x0003e4000b901c46ULL,
0x000000054a00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff527424ULL, 0x000fe200078e00ffULL, 0x00000000001e7805ULL, 0x002fe2000001ff00ULL,
0x000000ffff557224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fc4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000005c00e40947ULL, 0x000fec0003800000ULL, 0xff31721700527802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fce00078e00ffULL, 0x000000014a187836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x000001004a597824ULL, 0x000fc600078e0203ULL,
0x000000051800720cULL, 0x000fe20003f06070ULL, 0x00000040591b7836ULL, 0x000fc80000000000ULL,
0x0000000402257c24ULL, 0x000fe2000f8e021bULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000004009c8947ULL, 0x000fea0003800000ULL, 0x0000001008187824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x100fe20000011608ULL, 0x000000ffff247224ULL, 0x000fe200078e0a1bULL,
0x0000001b06197248ULL, 0x000fe20007fe0000ULL, 0x000040004f277824ULL, 0x000fe200078e0207ULL,
0x0000007018217812ULL, 0x000fe200078ec0ffULL, 0x00000004292b7836ULL, 0x000fe20000000000ULL,
0x00000025291b7210ULL, 0x000fe20007ffe0ffULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x0000002019247446ULL, 0x000fe20003800024ULL, 0x0000008000187824ULL, 0x000fe200078e0221ULL,
0x0000001c294d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000000242900720cULL, 0x040fe20003f26070ULL, 0x0000000129217824ULL, 0x000fc400078e0208ULL,
0x000001001b1a7825ULL, 0x000fc800078e0018ULL, 0x000000012b237824ULL, 0x000fe200078e0225ULL,
0x000000041a207c10ULL, 0x000fe2000ff1e0ffULL, 0x0000200000267824ULL, 0x000fe200078e0227ULL,
0x0000000721277812ULL, 0x000fe200078ec0ffULL, 0x000000082b287824ULL, 0x000fe200078e00ffULL,
0x000000051b217c10ULL, 0x000fe200087fe4ffULL, 0x00000100231a7825ULL, 0x000fe200078e0018ULL,
0x000000082b237210ULL, 0x000fe40007ffe0ffULL, 0x000000242b00720cULL, 0x080fe20003f06070ULL,
0x0001400026267836ULL, 0x000fe20000000000ULL, 0x000000041a227c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000c29437836ULL, 0x000fe20000000000ULL, 0x0ffffff827277812ULL, 0x000fe200078ef808ULL,
0x0000001029457836ULL, 0x000fe20000000000ULL, 0xfffffff8282b7812ULL, 0x000fe200078ee223ULL,
0x0000001429477836ULL, 0x000fe20000000000ULL, 0x000000051b237c10ULL, 0x000fe200097fe4ffULL,
0x00000008291b7836ULL, 0x000fe20000000000ULL, 0x000000244300720cULL, 0x080fe20003fa6070ULL,
0x0000001027277824ULL, 0x000fe200078e0226ULL, 0x000000244500720cULL, 0x080fe20003f86070ULL,
0x000000011b1a7824ULL, 0x040fe200078e0208ULL, 0x000000241b00720cULL, 0x0c0fe20003fc6070ULL,
0x000000081b417824ULL, 0x040fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e2000c901c46ULL, 0x000000011b1b7824ULL, 0x000fe200078e0225ULL,
0x000000244700720cULL, 0x000fe20003f66070ULL, 0x00000018294b7836ULL, 0x000fe20000000000ULL,
0xfffffff841417812ULL, 0x000fe200078ee21aULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x0000002545297210ULL, 0x000fc40007ffe0ffULL, 0x000000244b00720cULL, 0x080fe20003f46070ULL,
0x0000000145287824ULL, 0x100fe200078e0208ULL, 0x000000244d00720cULL, 0x000fe20003f26070ULL,
0x0000000143247824ULL, 0x000fe200078e0208ULL, 0x000000084b407210ULL, 0x000fe20007ffe0ffULL,
0x000000102b277824ULL, 0x002fe400078e0226ULL, 0x0000000143217824ULL, 0x040fe400078e0225ULL,
0x0000000843437824ULL, 0x000fe200078e00ffULL, 0x0000000022277faeULL, 0x0003e2000c101c46ULL,
0x000000041a1a7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010021207825ULL, 0x000fc400078e0018ULL,
0xfffffff843437812ULL, 0x000fe400078ee224ULL, 0x0000000845457824ULL, 0x000fe200078e00ffULL,
0x000000051b1b7c10ULL, 0x000fe200087fe4ffULL, 0x0000000147247824ULL, 0x000fe200078e0208ULL,
0x0000000420207c10ULL, 0x000fe2000ff1e0ffULL, 0x000000014b2b7824ULL, 0x000fe200078e0225ULL,
0xfffffff845457812ULL, 0x000fe200078ee228ULL, 0x0000010029227825ULL, 0x002fe200078e0018ULL,
0x0000000521217c10ULL, 0x000fc600087fe4ffULL, 0x0000000147297824ULL, 0x040fe200078e0225ULL,
0x0000000422227c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000847277824ULL, 0x000fe400078e00ffULL,
0x0000010029287825ULL, 0x100fe200078e0018ULL, 0x0000000523237c10ULL, 0x000fe400087fe4ffULL,
0xfffffff827477812ULL, 0x000fe200078ee224ULL, 0x000001002b2a7825ULL, 0x000fe200078e0018ULL,
0x0000000428247c10ULL, 0x000fc6000ff1e0ffULL, 0x000000014d277824ULL, 0x040fe200078e0225ULL,
0x0000000529257c10ULL, 0x000fe200087fe4ffULL, 0x000000014d427824ULL, 0x000fe200078e0208ULL,
0x000000042a287c10ULL, 0x000fe2000ff1e0ffULL, 0x000000084b4b7824ULL, 0x000fe400078e00ffULL,
0x000000084d4d7824ULL, 0x000fe200078e00ffULL, 0x000000052b297c10ULL, 0x000fe200087fe4ffULL,
0x0000010027187825ULL, 0x000fe200078e0018ULL, 0xfffffff84b4b7812ULL, 0x000fe400078ee240ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee242ULL, 0x0000001041277824ULL, 0x100fe200078e0226ULL,
0x0000000418187c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010432b7824ULL, 0x000fc400078e0226ULL,
0x0000001045417824ULL, 0x100fe200078e0226ULL, 0x000000264b457211ULL, 0x000fe200078e20ffULL,
0x0000001047437824ULL, 0x100fe200078e0226ULL, 0x0000000519197c10ULL, 0x000fe200087fe4ffULL,
0x000000104d477824ULL, 0x000fe200078e0226ULL, 0x000000001a277faeULL, 0x0003e8000f101c46ULL,
0x00000000202b7faeULL, 0x0003e8000e901c46ULL, 0x0000000022417faeULL, 0x0003e8000e101c46ULL,
0x0000000024437faeULL, 0x0003e8000d901c46ULL, 0x0000000028457faeULL, 0x0003e8000d101c46ULL,
0x0000000018477faeULL, 0x0003e2000c901c46ULL, 0x0000000400687947ULL, 0x000fea0003800000ULL,
0x0000000808237811ULL, 0x040fe200078fe8ffULL, 0x000040004f217824ULL, 0x000fe200078e0207ULL,
0x0000000408207811ULL, 0x040fe200078fe8ffULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000c08277811ULL, 0x040fe200078fe8ffULL, 0x0000000123197824ULL, 0x140fe200078e0208ULL,
0x00000014082b7811ULL, 0x040fe200078fe8ffULL, 0x0000000823227824ULL, 0x000fe200078e00ffULL,
0x0000001008297811ULL, 0x000fe200078fe8ffULL, 0x0000000120187824ULL, 0x100fe200078e0208ULL,
0x0000001808517811ULL, 0x000fe200078fe8ffULL, 0x0000000820437824ULL, 0x000fe200078e00ffULL,
0xfffffff822457812ULL, 0x000fe200078ee219ULL, 0x00000001271a7824ULL, 0x140fe200078e0208ULL,
0x0000001c08577811ULL, 0x000fe200078fe8ffULL, 0x0000000827477824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee218ULL, 0x000000012b197824ULL, 0x040fe200078e0208ULL,
0x0000000829187210ULL, 0x000fe20007ffe0ffULL, 0x000000082b227824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee21aULL, 0x00000008294b7824ULL, 0x000fc400078e00ffULL,
0x00000001511a7824ULL, 0x140fe200078e0208ULL, 0xfffffff8224d7812ULL, 0x000fe200078ee219ULL,
0x0000000851537824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL,
0x0000000157197824ULL, 0x040fe200078e0208ULL, 0x0000000408187819ULL, 0x040fe200000006ffULL,
0x0000000857227824ULL, 0x000fe200078e00ffULL, 0xfffffff853537812ULL, 0x000fe200078ee21aULL,
0x0000000123237824ULL, 0x100fe200078e0225ULL, 0x00000008081a7211ULL, 0x000fe200078fe8ffULL,
0x0000000127277824ULL, 0x100fe200078e0225ULL, 0xfffffff8225b7812ULL, 0x000fe200078ee219ULL,
0x0000000129297824ULL, 0x000fe200078e0225ULL, 0x0000007018197812ULL, 0x000fe200078ec0ffULL,
0x0000200000187824ULL, 0x000fe200078e0221ULL, 0x000000071a1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000120217824ULL, 0x000fe200078e0225ULL, 0x0000002551517210ULL, 0x000fe20007ffe0ffULL,
0x00014000181a7836ULL, 0x000fe20000000000ULL, 0x0ffffff81b417812ULL, 0x000fe200078ef808ULL,
0x0000008000187824ULL, 0x000fe200078e0219ULL, 0x00000025081b7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000001a4b4b7211ULL, 0x000fe200078e20ffULL,
0x0000001041417824ULL, 0x000fc400078e021aULL, 0x0000001043437824ULL, 0x100fe400078e021aULL,
0x0000001045457824ULL, 0x100fe400078e021aULL, 0x0000001047477824ULL, 0x100fe400078e021aULL,
0x000000104d4d7824ULL, 0x100fe400078e021aULL, 0x0000001053537824ULL, 0x100fe400078e021aULL,
0x000000105b5b7824ULL, 0x000fc400078e021aULL, 0x000001001b1a7825ULL, 0x000fc800078e0018ULL,
0x0000010021207825ULL, 0x000fe200078e0018ULL, 0x000000041a1a7c10ULL, 0x000fc6000ff1e0ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0225ULL, 0x0000000420207c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000157577824ULL, 0x000fe200078e0225ULL, 0x000000051b1b7c10ULL, 0x000fe200087fe4ffULL,
0x0000010023227825ULL, 0x000fe200078e0018ULL, 0x0000000521217c10ULL, 0x000fc60008ffe4ffULL,
0x0000010027247825ULL, 0x100fe200078e0018ULL, 0x0000000422227c10ULL, 0x000fe2000ff5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a417faeULL, 0x0003e4000b901c46ULL,
0x0000010029267825ULL, 0x100fe200078e0018ULL, 0x0000000424247c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000020437faeULL, 0x0003e2000b901c46ULL, 0x0000000523237c10ULL, 0x000fe200097fe4ffULL,
0x000001002b287825ULL, 0x100fe200078e0018ULL, 0x0000000426267c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000525257c10ULL, 0x000fe20009ffe4ffULL, 0x00000100512a7825ULL, 0x100fe200078e0018ULL,
0x0000000428287c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000022457faeULL, 0x0003e2000b901c46ULL,
0x0000000527277c10ULL, 0x000fe200087fe4ffULL, 0x0000010057187825ULL, 0x000fe200078e0018ULL,
0x000000042a2a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000024477faeULL, 0x0003e2000b901c46ULL,
0x0000000529297c10ULL, 0x000fc40008ffe4ffULL, 0x0000000418187c10ULL, 0x000fe2000ff7e0ffULL,
0x00000000264b7faeULL, 0x0003e2000b901c46ULL, 0x000000052b2b7c10ULL, 0x000fe400097fe4ffULL,
0x0000000519197c10ULL, 0x000fe20009ffe4ffULL, 0x00000000284d7faeULL, 0x0003e8000b901c46ULL,
0x000000002a537faeULL, 0x0003e8000b901c46ULL, 0x00000000185b7faeULL, 0x0003e4000b901c46ULL,
0xffffffe004187812ULL, 0x042fe200078ec0ffULL, 0x00000001ff217424ULL, 0x000fe200078e00ffULL,
0x0000001004197812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x00000007191b7210ULL, 0x000fca0007ffe018ULL, 0x0000000800207824ULL, 0x000fcc00078e021bULL,
0x01b60821202079a7ULL, 0x000e64000850003fULL, 0x0000000000187805ULL, 0x000fe40000015200ULL,
0x00000008041a7812ULL, 0x000fca00078ec0ffULL, 0x000000011b237824ULL, 0x000fc800078e021aULL,
0x01b60821230075a7ULL, 0x002ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ff00227202ULL, 0x000fce0000000f00ULL, 0x000000102200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a18257210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x000000251a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000122227836ULL, 0x000fce0000000000ULL, 0x01b60821230075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001008447824ULL, 0x000fe200078e00ffULL,
0x00000001ff4e7819ULL, 0x000fe20000011608ULL, 0x000000200f187824ULL, 0x000fe400078e00ffULL,
0x000000ffff517224ULL, 0x000fe200078e0052ULL, 0x0000007044447812ULL, 0x000fe400078ec0ffULL,
0xffffff8018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c4e4e7812ULL, 0x000fe400078ec0ffULL,
0x0000000744197210ULL, 0x000fca0007ffe018ULL, 0x0000000119197824ULL, 0x000fca00078e024eULL,
0x01b00000191b7984ULL, 0x000e680000000800ULL, 0x01b20000195c7984ULL, 0x0004a20000000800ULL,
0x000000521b00720bULL, 0x002fda0003f1d000ULL, 0x0000000000187806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff181a7812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x004fea0003800000ULL, 0x00000002ff187819ULL, 0x000fe4000001160fULL,
0x000000521b00720bULL, 0x0c0fe40003f34000ULL, 0x0000000f1800720cULL, 0x000fe40003f45270ULL,
0x000000521b517209ULL, 0x000fd20007810000ULL, 0x0000000000217806ULL, 0x000fe400008e0100ULL,
0x000000070f19a211ULL, 0x000fc800078e38ffULL, 0x000000194e18a210ULL, 0x000fe40007ffe044ULL,
0x0000991021197816ULL, 0x000fc600000000ffULL, 0x01b400511800a388ULL, 0x0003e20000000800ULL,
0x000000ff1900720cULL, 0x000fda0003f25270ULL, 0x0000000000b09947ULL, 0x002fea0003800000ULL,
0x0000005251187221ULL, 0x000fe20000010100ULL, 0x000000ff21ff7812ULL, 0x040fe4000782c0ffULL,
0x0000ff0021ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x0000001800197308ULL, 0x0002ac0000000800ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x00000002ff187819ULL, 0x002fcc0000011608ULL, 0x00001f1819187589ULL, 0x004e6400000e0000ULL,
0x000000182c2c7220ULL, 0x082fe20000410000ULL, 0x000000182d2d7220ULL, 0x080fe20000410000ULL,
0x0000001830307220ULL, 0x080fe20000410000ULL, 0x0000001831317220ULL, 0x080fe20000410000ULL,
0x0000001834347220ULL, 0x080fe20000410000ULL, 0x0000001835357220ULL, 0x080fe20000410000ULL,
0x0000001838387220ULL, 0x080fe20000410000ULL, 0x0000001839397220ULL, 0x080fe20000410000ULL,
0x000000183c3c7220ULL, 0x080fe20000410000ULL, 0x000000183d3d7220ULL, 0x080fe20000410000ULL,
0x0000001810107220ULL, 0x080fe20000410000ULL, 0x0000001811117220ULL, 0x080fe20000410000ULL,
0x0000001814147220ULL, 0x080fe20000410000ULL, 0x0000001815157220ULL, 0x080fe20000410000ULL,
0x000000181c1c7220ULL, 0x080fe20000410000ULL, 0x000000181d1d7220ULL, 0x000fce0000410000ULL,
0x0000001955557220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000808187811ULL, 0x002fcc00078ff0ffULL, 0x00001f1819187589ULL, 0x000e6400000e0000ULL,
0x000000182e2e7220ULL, 0x082fe20000410000ULL, 0x000000182f2f7220ULL, 0x080fe20000410000ULL,
0x0000001832327220ULL, 0x080fe20000410000ULL, 0x0000001833337220ULL, 0x080fe20000410000ULL,
0x0000001836367220ULL, 0x080fe20000410000ULL, 0x0000001837377220ULL, 0x080fe20000410000ULL,
0x000000183a3a7220ULL, 0x080fe20000410000ULL, 0x000000183b3b7220ULL, 0x080fe20000410000ULL,
0x000000183e3e7220ULL, 0x080fe20000410000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x0000001812127220ULL, 0x080fe20000410000ULL, 0x0000001813137220ULL, 0x080fe20000410000ULL,
0x0000001816167220ULL, 0x080fe20000410000ULL, 0x0000001817177220ULL, 0x080fe20000410000ULL,
0x000000181e1e7220ULL, 0x080fe20000410000ULL, 0x000000181f1f7220ULL, 0x000fce0000410000ULL,
0x0000ffff1aff7812ULL, 0x000fda0007826021ULL, 0x800000511b1b1221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b1b1b1820ULL, 0x000fc80000410000ULL,
0x0000001b000c1308ULL, 0x000ea40000000800ULL, 0x0000000c5c5c1220ULL, 0x004fce0000410000ULL,
0x00000007084c7812ULL, 0x040fe200078ec0ffULL, 0x000002000f187824ULL, 0x002fe200078e00ffULL,
0x00000008084d7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000004c4d217212ULL, 0x000fe400078efcffULL, 0x00000004ff1a7819ULL, 0x000fe40000011608ULL,
0x0000002108207211ULL, 0x000fe200078fe0ffULL, 0x0000000821197824ULL, 0x000fe200078e00ffULL,
0x000000084c527812ULL, 0x000fe200078ef808ULL, 0x000000044f537824ULL, 0x000fe200078e021aULL,
0xfffff80018187812ULL, 0x000fe200078ec0ffULL, 0x0000000220467836ULL, 0x000fe20000000000ULL,
0x00000003521a7819ULL, 0x040fe200000006ffULL, 0x0000000152537824ULL, 0x000fc400078e0253ULL,
0x000040004f4f7824ULL, 0x000fe200078e0207ULL, 0xfffffff819467812ULL, 0x000fe200078ee246ULL,
0x0000000821227824ULL, 0x040fe200078e00ffULL, 0xfffffff81a197812ULL, 0x000fe200078ee253ULL,
0x0000000420457836ULL, 0x000fe40000000000ULL, 0x0000000821477824ULL, 0x000fe400078e00ffULL,
0x00002000004f7824ULL, 0x000fe200078e024fULL, 0xfffffff822457812ULL, 0x000fe200078ee245ULL,
0x0000000107547824ULL, 0x000fe200078e0218ULL, 0xfffffff847477812ULL, 0x000fe200078ee220ULL,
0x000130004f4f7836ULL, 0x000fc40000000000ULL, 0x0000001019507824ULL, 0x000fe200078e0254ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1b7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x000000081b197836ULL, 0x000fe20000000000ULL,
0x000054100d187816ULL, 0x000fca000000000dULL, 0x00001f1b180d7589ULL, 0x0002a800000e0000ULL,
0x00001f19180e7589ULL, 0x0002e400000e0000ULL, 0x011000005018783bULL, 0x0022e20000000200ULL,
0x0000004f47247211ULL, 0x000fe200078e20ffULL, 0x0000001046407824ULL, 0x100fe400078e024fULL,
0x0000001045287824ULL, 0x000fe200078e024fULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000d18187232ULL, 0x08cfe40000200000ULL, 0x0000000d1a1a7232ULL, 0x000fe40000200000ULL,
0x0000000e19197232ULL, 0x080fe40000200000ULL, 0x0000000e1b1b7232ULL, 0x000fce0000200000ULL,
0x0000000821227824ULL, 0x000fe200078e00ffULL, 0x000000002828783bULL, 0x000f220000004200ULL,
0x00000006204b7836ULL, 0x000fe40000000000ULL, 0x0000000852527824ULL, 0x000fe200078e00ffULL,
0x000000002424783bULL, 0x000f620000004200ULL, 0x0000000253537836ULL, 0x000fe20000000000ULL,
0xfffffff8224b7812ULL, 0x000fe400078ee24bULL, 0x000000004040783bULL, 0x000fe60000004200ULL,
0x000000104b207824ULL, 0x000fcc00078e024fULL, 0x000000002020783bULL, 0x000f620000004200ULL,
0x0000002a1810723cULL, 0x018fec0000041810ULL, 0x00000028183c723cULL, 0x000fe2000004183cULL,
0x000000104d2b7812ULL, 0x000fc800078efe4cULL, 0x000000032b2a7819ULL, 0x000fe200000006ffULL,
0x00000024182c723cULL, 0x022fe2000004182cULL, 0x0000002b08287211ULL, 0x000fe400078fe0ffULL,
0xfffffff852297812ULL, 0x000fc600078ee253ULL, 0x000000261824723cULL, 0x000fe20000041830ULL,
0x0000000228537836ULL, 0x000fe40000000000ULL, 0x0000000428527836ULL, 0x000fe40000000000ULL,
0x0000001029297824ULL, 0x000fe200078e0254ULL, 0x000000201814723cULL, 0x000fe20000041814ULL,
0x000000082b317824ULL, 0x000fe200078e00ffULL, 0xfffffff82a537812ULL, 0x000fe200078ee253ULL,
0x0000000628577836ULL, 0x000fc60000000000ULL, 0xfffffff831527812ULL, 0x000fe200078ee252ULL,
0x000000082b217824ULL, 0x040fe200078e00ffULL, 0x000000401834723cULL, 0x000fe20000041834ULL,
0x000000082b207824ULL, 0x000fe400078e00ffULL, 0x0000001052307824ULL, 0x100fe200078e024fULL,
0xfffffff821547812ULL, 0x000fe400078ee228ULL, 0x000000421838723cULL, 0x000fe20000041838ULL,
0x0000001053407824ULL, 0x000fe200078e024fULL, 0x0000004f542a7211ULL, 0x000fc800078e20ffULL,
0x00000022181c723cULL, 0x000fe2000004181cULL, 0x011000002918783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000d18187232ULL, 0x08cfe40000200000ULL, 0x0000000d1a1a7232ULL, 0x000fe40000200000ULL,
0x0000000e19197232ULL, 0x080fe40000200000ULL, 0x0000000e1b1b7232ULL, 0x000fce0000200000ULL,
0xfffffff820577812ULL, 0x000fe200078ee257ULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x000000555c5c7221ULL, 0x000fe40000010000ULL,
0x0000001057207824ULL, 0x000fe200078e024fULL, 0x000000003030783bULL, 0x000f680000004200ULL,
0x000000002a28783bULL, 0x002e680000004200ULL, 0x000000002020783bULL, 0x000e620000004200ULL,
0x000000401834723cULL, 0x018fec0000041834ULL, 0x000000421838723cULL, 0x000fec0000041838ULL,
0x00000030183c723cULL, 0x020fec000004183cULL, 0x000000321810723cULL, 0x000fe20000041810ULL,
0x00000001ff307424ULL, 0x000fca00078e00ffULL, 0x00000028182c723cULL, 0x002fec000004182cULL,
0x0000002a1824723cULL, 0x000fe20000041824ULL, 0x000000020f287824ULL, 0x000fca00078e00ffULL,
0x000000201814723cULL, 0x000fe20000041814ULL, 0xfffffff828287812ULL, 0x000fca00078ec0ffULL,
0x000000221818723cULL, 0x000fe2000004181cULL, 0x0000000107217824ULL, 0x000fc800078e0228ULL,
0x01b6883021ff79a7ULL, 0x0003e4000850003fULL, 0x000000014a1c7836ULL, 0x000fe20000000000ULL,
0x00000080591f7810ULL, 0x000fc80007ffe0ffULL, 0x000000051c00720cULL, 0x000fe20003f06070ULL,
0x0000000402317c24ULL, 0x000fe2000f8e021fULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400888947ULL, 0x002fea0003800000ULL, 0x00000003ff417819ULL, 0x000fe20000011608ULL,
0x000000ffff407224ULL, 0x000fe200078e0a1fULL, 0x0000001f061d7248ULL, 0x000fe20007fe0000ULL,
0x00000080001c7824ULL, 0x000fe200078e0244ULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000441217836ULL, 0x000fe20000000000ULL, 0x000000201d407446ULL, 0x000fe20003800040ULL,
0x000000ffff1d7224ULL, 0x000fe400078e00ffULL, 0x00000001211e7824ULL, 0x040fe200078e0208ULL,
0x000000402100720cULL, 0x0c0fe20003f26070ULL, 0x00000008211f7824ULL, 0x000fe200078e00ffULL,
0x000000404100720cULL, 0x000fe20003f06070ULL, 0x0000000121217824ULL, 0x000fc400078e0231ULL,
0x0000000c415d7836ULL, 0x000fe20000000000ULL, 0xfffffff81f567812ULL, 0x000fe200078ee21eULL,
0x0000010021207825ULL, 0x000fe200078e001cULL, 0x00000008411e7210ULL, 0x000fe40007ffe0ffULL,
0x000000405d00720cULL, 0x000fe20003f86070ULL, 0x00000001411f7824ULL, 0x100fe200078e0231ULL,
0x000000071e337812ULL, 0x000fe200078ec0ffULL, 0x000000015d2b7824ULL, 0x000fe200078e0231ULL,
0x0000000420327c10ULL, 0x000fe2000ff7e0ffULL, 0x00000008415b7836ULL, 0x000fe20000000000ULL,
0x0ffffff833427812ULL, 0x000fe200078ef808ULL, 0x000001001f1e7825ULL, 0x000fe200078e001cULL,
0x0000000521337c10ULL, 0x000fc40009ffe4ffULL, 0x000000405b00720cULL, 0x000fe20003fa6070ULL,
0x000001002b2a7825ULL, 0x000fe200078e001cULL, 0x000000041e227c10ULL, 0x000fc6000ff5e0ffULL,
0x000000015b297824ULL, 0x000fe200078e0231ULL, 0x000000042a207c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001042437824ULL, 0x000fe200078e024fULL, 0x000000051f237c10ULL, 0x000fe200097fe4ffULL,
0x0000010029287825ULL, 0x000fe200078e001cULL, 0x000000052b217c10ULL, 0x000fe40009ffe4ffULL,
0x00000010412b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001056557824ULL, 0x000fe200078e024fULL,
0x00000004281e7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000014415f7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022437faeULL, 0x0003e2000c101c46ULL,
0x0000001841617836ULL, 0x000fe20000000000ULL, 0x00000005291f7c10ULL, 0x000fe200097fe4ffULL,
0x000000012b297824ULL, 0x040fe200078e0231ULL, 0x0000000032557faeULL, 0x0007e2000c901c46ULL,
0x0000001c41417836ULL, 0x000fe20000000000ULL, 0x000000402b00720cULL, 0x080fe20003f66070ULL,
0x000000015b287824ULL, 0x100fe200078e0208ULL, 0x000000405f00720cULL, 0x080fe20003f46070ULL,
0x000000015d2a7824ULL, 0x040fe200078e0208ULL, 0x000000035d5d7819ULL, 0x000fe200000006ffULL,
0x000000085b5b7824ULL, 0x000fe200078e00ffULL, 0x000000406100720cULL, 0x080fe20003f26070ULL,
0x0000010029227825ULL, 0x002fe200078e001cULL, 0x000000404100720cULL, 0x000fc40003f06070ULL,
0xfffffff85d407812ULL, 0x000fe200078ee22aULL, 0x000000015f297824ULL, 0x000fe200078e0231ULL,
0xfffffff85b327812ULL, 0x008fe200078ee228ULL, 0x000000012b2a7824ULL, 0x040fe200078e0208ULL,
0x0000000422227c10ULL, 0x000fe2000ffde0ffULL, 0x000000082b437824ULL, 0x000fe400078e00ffULL,
0x0000010029287825ULL, 0x000fe200078e001cULL, 0x0000000523237c10ULL, 0x000fe4000b7fe4ffULL,
0xfffffff843427812ULL, 0x000fe200078ee22aULL, 0x00000001612b7824ULL, 0x000fe200078e0231ULL,
0x0000000428287c10ULL, 0x000fe2000ffde0ffULL, 0x000000015f337824ULL, 0x000fc400078e0208ULL,
0x000000085f567824ULL, 0x000fe200078e00ffULL, 0x0000000529297c10ULL, 0x000fe2000b7fe4ffULL,
0x000001002b2a7825ULL, 0x000fc600078e001cULL, 0xfffffff856567812ULL, 0x000fe200078ee233ULL,
0x0000000141317824ULL, 0x000fe200078e0231ULL, 0x0000000861337210ULL, 0x000fe20007ffe0ffULL,
0x0000000861587824ULL, 0x000fe200078e00ffULL, 0x000000042a2a7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000141437824ULL, 0x040fe400078e0208ULL, 0x00000008415a7824ULL, 0x000fe200078e00ffULL,
0xfffffff858587812ULL, 0x000fe200078ee233ULL, 0x00000100311c7825ULL, 0x000fe200078e001cULL,
0x000000052b2b7c10ULL, 0x000fc4000b7fe4ffULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee243ULL,
0x0000001032317824ULL, 0x100fe200078e024fULL, 0x000000041c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000001040337824ULL, 0x100fe200078e024fULL, 0x0000004f58557211ULL, 0x000fe200078e20ffULL,
0x0000001042417824ULL, 0x100fe200078e024fULL, 0x000000051d1d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001056437824ULL, 0x100fe200078e024fULL, 0x000000001e317faeULL, 0x0003e2000e901c46ULL,
0x000000105a4f7824ULL, 0x000fc600078e024fULL, 0x0000000020337faeULL, 0x0003e8000e101c46ULL,
0x0000000022417faeULL, 0x0003e8000d901c46ULL, 0x0000000028437faeULL, 0x0003e8000d101c46ULL,
0x000000002a557faeULL, 0x0003e8000c901c46ULL, 0x000000001c4f7faeULL, 0x0003e2000c101c46ULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x00000008082b7811ULL, 0x000fe200078fe8ffULL,
0x0000008000287824ULL, 0x000fe200078e0244ULL, 0x0000000408417811ULL, 0x040fe200078fe8ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000c08237811ULL, 0x040fe200078fe8ffULL,
0x000000012b1d7824ULL, 0x140fe200078e0208ULL, 0x0000001808217811ULL, 0x040fe200078fe8ffULL,
0x000000082b587824ULL, 0x000fe200078e00ffULL, 0x000000312b2b7210ULL, 0x000fe20007ffe0ffULL,
0x00000001411c7824ULL, 0x140fe400078e0208ULL, 0x00000008411f7824ULL, 0x000fe200078e00ffULL,
0xfffffff858587812ULL, 0x000fe200078ee21dULL, 0x0000000823297824ULL, 0x000fe200078e00ffULL,
0x00000010081d7811ULL, 0x040fe200078fe8ffULL, 0x0000000121227824ULL, 0x100fe200078e0208ULL,
0xfffffff81f567812ULL, 0x000fe200078ee21cULL, 0x00000001231c7824ULL, 0x100fe200078e0208ULL,
0x00000014081f7811ULL, 0x040fe200078fe8ffULL, 0x000000081d337824ULL, 0x000fe200078e00ffULL,
0x000000081d1e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000821557824ULL, 0x000fe200078e00ffULL,
0xfffffff8295a7812ULL, 0x000fe200078ee21cULL, 0x000000011f207824ULL, 0x040fe200078e0208ULL,
0xfffffff8335e7812ULL, 0x000fe200078ee21eULL, 0x000000081f437824ULL, 0x000fe200078e00ffULL,
0x0000003108337211ULL, 0x040fe200078fe8ffULL, 0x0000000141417824ULL, 0x100fe200078e0231ULL,
0x000000ff00297202ULL, 0x000fe20000000f00ULL, 0x0000000123237824ULL, 0x100fe200078e0231ULL,
0x00000008081c7211ULL, 0x040fe200078fe8ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0231ULL,
0x0000001c081e7811ULL, 0x000fe200078fe8ffULL, 0x0000010033327825ULL, 0x000fe200078e0028ULL,
0xfffffff843607812ULL, 0x000fc400078ee220ULL, 0x000000071c437812ULL, 0x000fe200078ec0ffULL,
0x0000010041407825ULL, 0x000fe200078e0028ULL, 0xfffffff855627812ULL, 0x000fe400078ee222ULL,
0x0ffffff843427812ULL, 0x000fe200078ef808ULL, 0x000000011f1f7824ULL, 0x000fe200078e0231ULL,
0x0000000432327c10ULL, 0x000fe2000ff1e0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0028ULL,
0x0000000440407c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000533337c10ULL, 0x000fe200087fe4ffULL,
0x0000000121217824ULL, 0x000fe200078e0231ULL, 0x000000042a2a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000010023227825ULL, 0x000fe200078e0028ULL, 0x0000000541417c10ULL, 0x000fc40008ffe4ffULL,
0x000000052b2b7c10ULL, 0x000fe200097fe4ffULL, 0x000000011e317824ULL, 0x040fe200078e0231ULL,
0x0000000422227c10ULL, 0x000fe2000ff7e0ffULL, 0x000000011e557824ULL, 0x040fe400078e0208ULL,
0x000000081e647824ULL, 0x000fe200078e00ffULL, 0x0000000523237c10ULL, 0x000fe20009ffe4ffULL,
0x000001001d1c7825ULL, 0x000fc600078e0028ULL, 0xfffffff864647812ULL, 0x000fe200078ee255ULL,
0x000001001f1e7825ULL, 0x000fe200078e0028ULL, 0x000000041c1c7c10ULL, 0x000fc6000ff1e0ffULL,
0x0000010021207825ULL, 0x100fe200078e0028ULL, 0x000000041e1e7c10ULL, 0x000fe4000ff3e0ffULL,
0x000000051d1d7c10ULL, 0x000fe200087fe4ffULL, 0x0000010031287825ULL, 0x000fe200078e0028ULL,
0x0000000420207c10ULL, 0x000fe4000ff5e0ffULL, 0x000000051f1f7c10ULL, 0x000fe20008ffe4ffULL,
0x0000001042317824ULL, 0x100fe200078e024fULL, 0x0000000428287c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001056437824ULL, 0x100fe200078e024fULL, 0x0000000521217c10ULL, 0x000fe200097fe4ffULL,
0x0000001058557824ULL, 0x100fe200078e024fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032317faeULL, 0x0003e2000b901c46ULL, 0x000000105a5b7824ULL, 0x100fe200078e024fULL,
0x0000000529297c10ULL, 0x000fe20009ffe4ffULL, 0x000000105e5d7824ULL, 0x100fe200078e024fULL,
0x0000000040437faeULL, 0x0003e2000b901c46ULL, 0x00000010605f7824ULL, 0x000fc400078e024fULL,
0x0000001062617824ULL, 0x000fe200078e024fULL, 0x0000004f644f7211ULL, 0x000fe200078e20ffULL,
0x000000002a557faeULL, 0x0003e8000b901c46ULL, 0x00000000225b7faeULL, 0x0003e8000b901c46ULL,
0x000000001c5d7faeULL, 0x0003e8000b901c46ULL, 0x000000001e5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000020617faeULL, 0x0003e8000b901c46ULL, 0x00000000284f7faeULL, 0x0003e4000b901c46ULL,
0xffffffe0041c7812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010041d7812ULL, 0x040fe400078ec0ffULL, 0x00000008041e7812ULL, 0x000fe400078ec0ffULL,
0x000000071d1d7210ULL, 0x000fca0007ffe01cULL, 0x000000011d237824ULL, 0x000fc800078e021eULL,
0x01b62830233079a7ULL, 0x0002e6000850003fULL, 0x00000000001c7805ULL, 0x000fce0000015200ULL,
0x01b62831230075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff207224ULL, 0x000fce00078e00ffULL, 0x000000102000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c217210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000120207836ULL, 0x000fce0000000000ULL, 0x01b62831230075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000200f1c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff5a7224ULL, 0x000fc600078e0051ULL, 0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL,
0x00000080071d7810ULL, 0x000fc80007ffe01cULL, 0x0000001d4e1d7210ULL, 0x000fca0007ffe044ULL,
0x01b000001d1c7984ULL, 0x000ee80000000800ULL, 0x01b200001d5b7984ULL, 0x0009220000000800ULL,
0x000000511c00720bULL, 0x008fda0003f1d000ULL, 0x00000000001e7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff1e1f7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x016fea0003800000ULL, 0x000000010f1e7811ULL, 0x000fe400078ff0ffULL,
0x000000511c00720bULL, 0x000fe40003f14000ULL, 0x0000000f1e00720cULL, 0x000fd60003f25270ULL,
0x0000000000207806ULL, 0x000fe400000e0100ULL, 0x000000070f219211ULL, 0x000fe400078e38ffULL,
0x000000511c1d9209ULL, 0x000fe40007810000ULL, 0x000000214e229210ULL, 0x000fe40007ffe044ULL,
0x00009910201e7816ULL, 0x000fc600000000ffULL, 0x01b4001d22009388ULL, 0x0003e20000000800ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x000000511c1e7209ULL, 0x000fe40007810000ULL, 0x000000ff20ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0020ff7812ULL, 0x000fe2000782c0ffULL, 0x000000511e1d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1d1d7820ULL, 0x000fc80000410000ULL, 0x0000001d00217308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fca0000011608ULL,
0x00001f1e211d7589ULL, 0x006e6400000e0000ULL, 0x0000002c1d2c7220ULL, 0x042fe20000410000ULL,
0x0000002d1d2d7220ULL, 0x040fe20000410000ULL, 0x000000241d247220ULL, 0x040fe20000410000ULL,
0x000000251d257220ULL, 0x040fe20000410000ULL, 0x000000341d347220ULL, 0x040fe20000410000ULL,
0x000000351d357220ULL, 0x040fe20000410000ULL, 0x000000381d387220ULL, 0x040fe20000410000ULL,
0x000000391d397220ULL, 0x040fe20000410000ULL, 0x0000003c1d3c7220ULL, 0x040fe20000410000ULL,
0x0000003d1d3d7220ULL, 0x040fe20000410000ULL, 0x000000101d107220ULL, 0x040fe20000410000ULL,
0x000000111d117220ULL, 0x040fe20000410000ULL, 0x000000141d147220ULL, 0x040fe20000410000ULL,
0x000000151d157220ULL, 0x040fe20000410000ULL, 0x000000181d187220ULL, 0x040fe20000410000ULL,
0x000000191d197220ULL, 0x000fce0000410000ULL, 0x000000215c5c7220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000008081e7811ULL, 0x000fca00078ff0ffULL,
0x00001f1e211d7589ULL, 0x002e6400000e0000ULL, 0x0000002e1d2e7220ULL, 0x042fe20000410000ULL,
0x0000002f1d2f7220ULL, 0x040fe20000410000ULL, 0x000000261d267220ULL, 0x040fe20000410000ULL,
0x000000271d277220ULL, 0x040fe20000410000ULL, 0x000000361d367220ULL, 0x040fe20000410000ULL,
0x000000371d377220ULL, 0x040fe20000410000ULL, 0x0000003a1d3a7220ULL, 0x040fe20000410000ULL,
0x0000003b1d3b7220ULL, 0x040fe20000410000ULL, 0x0000003e1d3e7220ULL, 0x040fe20000410000ULL,
0x0000003f1d3f7220ULL, 0x040fe20000410000ULL, 0x000000121d127220ULL, 0x040fe20000410000ULL,
0x000000131d137220ULL, 0x040fe20000410000ULL, 0x000000161d167220ULL, 0x040fe20000410000ULL,
0x000000171d177220ULL, 0x040fe20000410000ULL, 0x0000001a1d1a7220ULL, 0x040fe20000410000ULL,
0x0000001b1d1b7220ULL, 0x000fce0000410000ULL, 0x0000ffff1fff7812ULL, 0x000fe40007806020ULL,
0x000000511c5a7209ULL, 0x000fd60007810000ULL, 0x8000005a1c1c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL, 0x0000001c000c0308ULL, 0x000ea40000000800ULL,
0x0000000c5b5b0220ULL, 0x004fce0000410000ULL, 0x00000001ff4f7819ULL, 0x000fe2000001160fULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000040004f1d7824ULL, 0x002fc800078e0207ULL,
0x00002000001d7824ULL, 0x000fc800078e021dULL, 0x000140001d557836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1d7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fc600000010ffULL, 0x000000081d1f7836ULL, 0x000fe20000000000ULL,
0x000054100d1c7816ULL, 0x000fca000000000dULL, 0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL,
0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL, 0x01180000501c783bULL, 0x0022e20000000200ULL,
0x0000001047517824ULL, 0x100fe400078e0255ULL, 0x0000001046407824ULL, 0x000fe200078e0255ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000d1c1c7232ULL, 0x08cfe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x080fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x000000005130783bULL, 0x0009620000004200ULL,
0x000000554b207211ULL, 0x080fe200078e20ffULL, 0x0000001045287824ULL, 0x000fe200078e0255ULL,
0x00000002ff5e7819ULL, 0x000fe2000001160fULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x0000001054587824ULL, 0x100fe200078e0255ULL, 0x0000005553567211ULL, 0x000fe400078e20ffULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x0000001052517824ULL, 0x010fc600078e0255ULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x000000301c2c723cULL, 0x02afec000004182cULL,
0x000000321c30723cULL, 0x000fec0000041824ULL, 0x000000201c14723cULL, 0x000fe20000041814ULL,
0x00000004ff267819ULL, 0x000fc40000011608ULL, 0x0000004d4c247212ULL, 0x000fc600078efcffULL,
0x000000044f5d7824ULL, 0x000fe200078e0226ULL, 0x000000401c34723cULL, 0x000fe20000041834ULL,
0x0000000824257824ULL, 0x040fe400078e00ffULL, 0x00000001245d7824ULL, 0x000fe400078e025dULL,
0x000008005e207824ULL, 0x000fe200078e0207ULL, 0x000000421c38723cULL, 0x000fe20000041838ULL,
0x000000025d247836ULL, 0x000fca0000000000ULL, 0xfffffff825257812ULL, 0x000fe200078ee224ULL,
0x000000281c3c723cULL, 0x010fe8000004183cULL, 0x0000001025207824ULL, 0x000fe400078e0220ULL,
0x0000002a1c10723cULL, 0x000fec0000041810ULL, 0x000000221c18723cULL, 0x000fe20000041818ULL,
0x01180000201c783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d1c1c7232ULL, 0x08cfe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x080fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x0000001057507824ULL, 0x000fe200078e0255ULL,
0x000000005840783bULL, 0x000f220000004200ULL, 0x000000c059597836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x0000005c5b5b7221ULL, 0x000fe20000010000ULL,
0x000000005628783bULL, 0x000f680000004200ULL, 0x000000005124783bULL, 0x000f680000004200ULL,
0x000000005020783bULL, 0x002e620000004200ULL, 0x000000401c2c723cULL, 0x018fec000004182cULL,
0x000000421c30723cULL, 0x000fe20000041830ULL, 0x00000001ff407424ULL, 0x000fca00078e00ffULL,
0x000000281c34723cULL, 0x020fec0000041834ULL, 0x0000002a1c38723cULL, 0x000fe20000041838ULL,
0x0000000402297c24ULL, 0x000fca000f8e0259ULL, 0x000000241c3c723cULL, 0x000fec000004183cULL,
0x000000261c10723cULL, 0x000fec0000041810ULL, 0x000000201c14723cULL, 0x002fec0000041814ULL,
0x000000221c18723cULL, 0x000fe20000041818ULL, 0x000000085e217824ULL, 0x000fc800078e0207ULL,
0x01b6904021ff79a7ULL, 0x0003e4000850003fULL, 0x000000014a1c7836ULL, 0x000fca0000000000ULL,
0x000000051c00720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000000400888947ULL, 0x002fea0003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0a59ULL,
0x00000059061d7248ULL, 0x000fe20007fe0000ULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x00000003ff287819ULL, 0x100fe40000011608ULL, 0x000000201d237446ULL, 0x000fe2000380001eULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x00000044001c7211ULL, 0x000fe200078e38ffULL,
0x00000001281e7824ULL, 0x040fe200078e0208ULL, 0x000000232800720cULL, 0x000fe20003f06070ULL,
0x0000000428227836ULL, 0x000fc40000000000ULL, 0x0000000128217824ULL, 0x100fe200078e0229ULL,
0x000000071e257812ULL, 0x000fe200078ec0ffULL, 0x0000000122247824ULL, 0x040fe200078e0208ULL,
0x000000232200720cULL, 0x040fe20003f26070ULL, 0x0000000822277824ULL, 0x040fe400078e00ffULL,
0x00000001221f7824ULL, 0x000fe200078e0229ULL, 0x0ffffff825227812ULL, 0x000fe200078ef808ULL,
0x0000010021207825ULL, 0x100fe200078e001cULL, 0xfffffff827247812ULL, 0x000fe400078ee224ULL,
0x0000005522277211ULL, 0x000fe200078e20ffULL, 0x000001001f1e7825ULL, 0x000fe200078e001cULL,
0x0000000420207c10ULL, 0x000fc6000ff5e0ffULL, 0x0000000828227836ULL, 0x000fe20000000000ULL,
0x000000041e1e7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000010242b7824ULL, 0x000fe200078e0255ULL,
0x0000000521217c10ULL, 0x000fe200097fe4ffULL, 0x0000000c28427836ULL, 0x000fe20000000000ULL,
0x0000002922257210ULL, 0x000fe20007ffe0ffULL, 0x00000010285c7836ULL, 0x000fe20000000000ULL,
0x000000051f1f7c10ULL, 0x000fe20009ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e2000c101c46ULL, 0x0000000122247824ULL, 0x140fe200078e0208ULL,
0x000000232200720cULL, 0x080fe20003fa6070ULL, 0x0000001428607836ULL, 0x000fe20000000000ULL,
0x000000001e2b7faeULL, 0x0007e2000c901c46ULL, 0x0000001828627836ULL, 0x000fe20000000000ULL,
0x000000234200720cULL, 0x080fe20003f86070ULL, 0x0000001c28287836ULL, 0x000fe20000000000ULL,
0x000000235c00720cULL, 0x080fe20003f66070ULL, 0x0000000160417824ULL, 0x040fe200078e0208ULL,
0x000000236000720cULL, 0x080fe20003f46070ULL, 0x0000000828647824ULL, 0x000fe200078e00ffULL,
0x000000236200720cULL, 0x080fe20003f26070ULL, 0x0000010025207825ULL, 0x002fe200078e001cULL,
0x000000232800720cULL, 0x000fc60003f06070ULL, 0x0000000822277824ULL, 0x000fe200078e00ffULL,
0x0000000420267c10ULL, 0x000fe2000ffde0ffULL, 0x00000001421f7824ULL, 0x108fe400078e0229ULL,
0x000000015c257824ULL, 0x000fe200078e0229ULL, 0xfffffff8272a7812ULL, 0x000fe200078ee224ULL,
0x000001001f1e7825ULL, 0x000fe200078e001cULL, 0x0000000521277c10ULL, 0x000fc6000b7fe4ffULL,
0x0000010025207825ULL, 0x000fe200078e001cULL, 0x000000041e1e7c10ULL, 0x000fc6000ffde0ffULL,
0x0000000142227824ULL, 0x140fe200078e0208ULL, 0x000000051f1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000842257824ULL, 0x000fe200078e00ffULL, 0x0000000420207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000160237824ULL, 0x000fe400078e0229ULL, 0x000000015c2b7824ULL, 0x000fe200078e0208ULL,
0xfffffff825427812ULL, 0x000fe200078ee222ULL, 0x0000010023227825ULL, 0x000fe200078e001cULL,
0x0000002962257210ULL, 0x000fe40007ffe0ffULL, 0x0000000521217c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000128297824ULL, 0x000fe200078e0229ULL, 0x0000000422227c10ULL, 0x000fe2000ffde0ffULL,
0x000000085c5c7824ULL, 0x000fc400078e00ffULL, 0x0000010025247825ULL, 0x100fe200078e001cULL,
0x0000000523237c10ULL, 0x000fe4000b7fe4ffULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee22bULL,
0x00000100291c7825ULL, 0x000fe200078e001cULL, 0x0000000424247c10ULL, 0x000fe4000ffde0ffULL,
0x00000008282b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000162297824ULL, 0x000fe200078e0208ULL,
0x0000000525257c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000860607824ULL, 0x000fe200078e00ffULL,
0x000000041c1c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000862627824ULL, 0x000fc600078e00ffULL,
0xfffffff860607812ULL, 0x000fe200078ee241ULL, 0x000000105c417824ULL, 0x100fe200078e0255ULL,
0xfffffff862287812ULL, 0x000fe200078ee229ULL, 0x000000102a297824ULL, 0x100fe200078e0255ULL,
0xfffffff8642a7812ULL, 0x000fe200078ee22bULL, 0x00000010422b7824ULL, 0x100fe200078e0255ULL,
0x000000051d1d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001060437824ULL, 0x100fe200078e0255ULL,
0x0000000026297faeULL, 0x0003e2000e901c46ULL, 0x0000001028597824ULL, 0x100fe400078e0255ULL,
0x000000102a5f7824ULL, 0x000fe200078e0255ULL, 0x000000001e2b7faeULL, 0x0003e8000e101c46ULL,
0x0000000020417faeULL, 0x0003e8000d901c46ULL, 0x0000000022437faeULL, 0x0003e8000d101c46ULL,
0x0000000024597faeULL, 0x0003e8000c901c46ULL, 0x000000001c5f7faeULL, 0x0003e2000c101c46ULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x0000000408277811ULL, 0x000fe200078fe8ffULL,
0x00000080001c7824ULL, 0x000fe200078e0244ULL, 0x00000008082b7811ULL, 0x040fe200078fe8ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000827667210ULL, 0x000fe20007ffe0ffULL,
0x00000008271d7824ULL, 0x000fe200078e00ffULL, 0x0000000c081f7811ULL, 0x040fe200078fe8ffULL,
0x000000012b647824ULL, 0x140fe200078e0208ULL, 0x0000001408237811ULL, 0x040fe200078fe8ffULL,
0x000000082b217824ULL, 0x000fe200078e00ffULL, 0xfffffff81d667812ULL, 0x000fe200078ee266ULL,
0x000000011f627824ULL, 0x140fe200078e0208ULL, 0x0000001808417811ULL, 0x040fe200078fe8ffULL,
0x000000081f1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff821647812ULL, 0x000fe200078ee264ULL,
0x0000000823437824ULL, 0x000fe200078e00ffULL, 0x0000001008217811ULL, 0x040fe200078fe8ffULL,
0x0000000141427824ULL, 0x140fe200078e0208ULL, 0xfffffff81d627812ULL, 0x000fe200078ee262ULL,
0x0000000841597824ULL, 0x000fe200078e00ffULL, 0x00000008235c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000121607824ULL, 0x140fe200078e0208ULL, 0x0000001c081d7811ULL, 0x040fe200078fe8ffULL,
0x0000000821257824ULL, 0x000fe200078e00ffULL, 0xfffffff8435c7812ULL, 0x000fe200078ee25cULL,
0x000000011f1f7824ULL, 0x100fe200078e0229ULL, 0xfffffff859427812ULL, 0x000fe200078ee242ULL,
0x000000011d437824ULL, 0x040fe200078e0229ULL, 0x0000002921217210ULL, 0x000fe20007ffe0ffULL,
0x000000011d597824ULL, 0x040fe200078e0208ULL, 0xfffffff825607812ULL, 0x000fe200078ee260ULL,
0x000000081d6a7824ULL, 0x000fe200078e00ffULL, 0x0000002908257211ULL, 0x000fe200078fe8ffULL,
0x000000ffff1d7224ULL, 0x000fc400078e00ffULL, 0x0000000123237824ULL, 0x100fe200078e0229ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee259ULL, 0x0000000127277824ULL, 0x100fe400078e0229ULL,
0x000000012b2b7824ULL, 0x100fe400078e0229ULL, 0x0000000141417824ULL, 0x000fe400078e0229ULL,
0x000001001f287825ULL, 0x000fc800078e001cULL, 0x00000100211e7825ULL, 0x000fc800078e001cULL,
0x0000010023207825ULL, 0x000fe200078e001cULL, 0x000000041e1e7c10ULL, 0x000fc6000ff5e0ffULL,
0x0000010025247825ULL, 0x000fe200078e001cULL, 0x000000051f1f7c10ULL, 0x000fc600097fe4ffULL,
0x0000010041227825ULL, 0x100fe200078e001cULL, 0x0000000808417211ULL, 0x000fe400078fe8ffULL,
0x0000000424247c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010027267825ULL, 0x100fe200078e001cULL,
0x0000000741417812ULL, 0x000fe400078ec0ffULL, 0x0000000525257c10ULL, 0x000fe200087fe4ffULL,
0x000001002b2a7825ULL, 0x100fe200078e001cULL, 0x0000000426267c10ULL, 0x000fe4000ff3e0ffULL,
0x0ffffff841687812ULL, 0x000fe200078ef808ULL, 0x00000100431c7825ULL, 0x000fe200078e001cULL,
0x0000000527277c10ULL, 0x000fc40008ffe4ffULL, 0x000000042a2a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001068417824ULL, 0x100fe200078e0255ULL, 0x0000000428287c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001064597824ULL, 0x100fe200078e0255ULL, 0x000000052b2b7c10ULL, 0x000fe200087fe4ffULL,
0x00000010625f7824ULL, 0x100fe200078e0255ULL, 0x0000000529297c10ULL, 0x000fe20008ffe4ffULL,
0x0000001060617824ULL, 0x100fe200078e0255ULL, 0x0000000420207c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024417faeULL, 0x0003e2000b901c46ULL,
0x0000005566437211ULL, 0x000fe200078e20ffULL, 0x000000105c637824ULL, 0x100fe200078e0255ULL,
0x0000000422227c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001042657824ULL, 0x100fe200078e0255ULL,
0x000000041c1c7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000026437faeULL, 0x0003e2000b901c46ULL,
0x0000000521217c10ULL, 0x000fe200087fe4ffULL, 0x000000106a677824ULL, 0x000fe200078e0255ULL,
0x0000000523237c10ULL, 0x000fe20008ffe4ffULL, 0x000000002a597faeULL, 0x0003e2000b901c46ULL,
0x000000051d1d7c10ULL, 0x000fc600097fe4ffULL, 0x00000000285f7faeULL, 0x0003e8000b901c46ULL,
0x000000001e617faeULL, 0x0003e8000b901c46ULL, 0x0000000020637faeULL, 0x0003e8000b901c46ULL,
0x0000000022657faeULL, 0x0003e8000b901c46ULL, 0x000000001c677faeULL, 0x0003e4000b901c46ULL,
0x000000205e5e7824ULL, 0x000fe200078e0207ULL, 0x00000010041d7812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x0000005e1d1d7210ULL, 0x000fca0007ffe0ffULL,
0x0000000800217824ULL, 0x000fc800078e021dULL, 0x01b64840214079a7ULL, 0x0002e6000850003fULL,
0x00000000001c7805ULL, 0x000fce0000015200ULL, 0x01b64841210075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff207224ULL, 0x000fce00078e00ffULL,
0x000000102000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fce0000015200ULL, 0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000231e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000120207836ULL, 0x000fce0000000000ULL,
0x01b64841210075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000200f1c7824ULL, 0x000fca00078e00ffULL, 0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL,
0x00000100071d7810ULL, 0x000fc80007ffe01cULL, 0x0000001d4e1d7210ULL, 0x000fca0007ffe044ULL,
0x01b000001d1f7984ULL, 0x000ee80000000800ULL, 0x01b200001d597984ULL, 0x0009220000000800ULL,
0x0000005a1f00720bULL, 0x008fda0003f1d000ULL, 0x00000000001c7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff1c1e7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x016fea0003800000ULL, 0x000000020f1c7811ULL, 0x000fe400078ff0ffULL,
0x0000005a1f00720bULL, 0x000fe40003f14000ULL, 0x0000000f1c00720cULL, 0x000fd60003f25270ULL,
0x0000000000217806ULL, 0x000fe400000e0100ULL, 0x000000800f1d9824ULL, 0x000fe200078e0207ULL,
0x0000005a1f1c9209ULL, 0x000fc80007810000ULL, 0x0000001d4e239210ULL, 0x000fe40007ffe044ULL,
0x00009910211d7816ULL, 0x000fc600000000ffULL, 0x01b4001c23009388ULL, 0x0003e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005a1f1d7209ULL, 0x000fe40007810000ULL, 0x000000ff21ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0021ff7812ULL, 0x000fe2000782c0ffULL, 0x0000005a1d1c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL, 0x0000001c00207308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x000fca0000011608ULL,
0x00001f1d201c7589ULL, 0x006e6400000e0000ULL, 0x0000002c1c2c7220ULL, 0x042fe20000410000ULL,
0x0000002d1c2d7220ULL, 0x040fe20000410000ULL, 0x000000301c307220ULL, 0x040fe20000410000ULL,
0x000000311c317220ULL, 0x040fe20000410000ULL, 0x000000341c347220ULL, 0x040fe20000410000ULL,
0x000000351c357220ULL, 0x040fe20000410000ULL, 0x000000381c387220ULL, 0x040fe20000410000ULL,
0x000000391c397220ULL, 0x040fe20000410000ULL, 0x0000003c1c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d1c3d7220ULL, 0x040fe20000410000ULL, 0x000000101c107220ULL, 0x040fe20000410000ULL,
0x000000111c117220ULL, 0x040fe20000410000ULL, 0x000000141c147220ULL, 0x040fe20000410000ULL,
0x000000151c157220ULL, 0x040fe20000410000ULL, 0x000000181c187220ULL, 0x040fe20000410000ULL,
0x000000191c197220ULL, 0x000fce0000410000ULL, 0x000000205b5b7220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000008081d7811ULL, 0x000fca00078ff0ffULL,
0x00001f1d201c7589ULL, 0x002e6400000e0000ULL, 0x0000002e1c2e7220ULL, 0x042fe20000410000ULL,
0x0000002f1c2f7220ULL, 0x040fe20000410000ULL, 0x000000321c327220ULL, 0x040fe20000410000ULL,
0x000000331c337220ULL, 0x040fe20000410000ULL, 0x000000361c367220ULL, 0x040fe20000410000ULL,
0x000000371c377220ULL, 0x040fe20000410000ULL, 0x0000003a1c3a7220ULL, 0x040fe20000410000ULL,
0x0000003b1c3b7220ULL, 0x040fe20000410000ULL, 0x0000003e1c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f1c3f7220ULL, 0x040fe20000410000ULL, 0x000000121c127220ULL, 0x040fe20000410000ULL,
0x000000131c137220ULL, 0x040fe20000410000ULL, 0x000000161c167220ULL, 0x040fe20000410000ULL,
0x000000171c177220ULL, 0x040fe20000410000ULL, 0x0000001a1c1a7220ULL, 0x040fe20000410000ULL,
0x0000001b1c1b7220ULL, 0x000fce0000410000ULL, 0x0000ffff1eff7812ULL, 0x000fe40007806021ULL,
0x0000005a1f5a7209ULL, 0x000fd60007810000ULL, 0x8000005a1f1f0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1f1f0820ULL, 0x000fc80000410000ULL, 0x0000001f000c0308ULL, 0x000ea40000000800ULL,
0x0000000c59590220ULL, 0x004fce0000410000ULL, 0x0000000d0f1c7819ULL, 0x042fe200000006ffULL,
0x000002000f1d7824ULL, 0x000fe200078e00ffULL, 0x0000004d4c5c7212ULL, 0x000fe200078efcffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffc0001c1c7812ULL, 0x000fe200078ec0ffULL,
0x000000085c207824ULL, 0x000fe200078e00ffULL, 0xfffff8001d1e7812ULL, 0x000fc600078ec0ffULL,
0x00000001071d7824ULL, 0x040fe200078e021cULL, 0xfffffff8205d7812ULL, 0x000fe200078ee25dULL,
0x00000001071e7824ULL, 0x000fe400078e021eULL, 0x00002000001d7824ULL, 0x000fe400078e021dULL,
0x000000105d1e7824ULL, 0x000fe400078e021eULL, 0x000130001d207836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1d7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fe400000010ffULL, 0x000000081d1f7810ULL, 0x000fe40007ffe0ffULL,
0x000054100d1c7816ULL, 0x000fca000000000dULL, 0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL,
0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL, 0x012000001e1c783bULL, 0x002e620000000200ULL,
0x0000001047407824ULL, 0x100fe400078e0220ULL, 0x0000001046287824ULL, 0x000fe200078e0220ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000d1c1c7232ULL, 0x086fe40000200000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000200000ULL, 0x0000000e1d1d7232ULL, 0x088fe40000200000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000200000ULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x0000001045247824ULL, 0x100fe200078e0220ULL, 0x00000002ff5d7819ULL, 0x000fe2000001160fULL,
0x000000104b207824ULL, 0x000fe200078e0220ULL, 0x000000002828783bULL, 0x000f680000004200ULL,
0x000000002424783bULL, 0x000f680000004200ULL, 0x000000002020783bULL, 0x000f620000004200ULL,
0x000000401c2c723cULL, 0x012fec000004182cULL, 0x000000281c34723cULL, 0x028fe20000041834ULL,
0x000000020f417824ULL, 0x000fca00078e00ffULL, 0x000000241c3c723cULL, 0x004fe2000004183cULL,
0x0000000441297812ULL, 0x000fc800078ec0ffULL, 0x0000000229297812ULL, 0x000fe200078efcffULL,
0x000000201c14723cULL, 0x000fe20000041814ULL, 0x000000074f257211ULL, 0x000fe400078e70ffULL,
0x0000002908297211ULL, 0x000fc600078fe0ffULL, 0x0000200000257824ULL, 0x000fe200078e0225ULL,
0x000000421c30723cULL, 0x000fe20000041830ULL, 0x000000015c297824ULL, 0x040fe400078e0229ULL,
0x000000085c5c7824ULL, 0x000fe400078e00ffULL, 0x000008005d217824ULL, 0x000fe200078e0207ULL,
0x0000002a1c38723cULL, 0x000fe20000041838ULL, 0x00013000255e7836ULL, 0x000fe20000000000ULL,
0xfffffff85c5c7812ULL, 0x000fc600078ee229ULL, 0x0000001052247824ULL, 0x100fe200078e025eULL,
0x000000261c10723cULL, 0x000fe20000041810ULL, 0x000000105c207824ULL, 0x000fe400078e0221ULL,
0x0000001053287824ULL, 0x100fe400078e025eULL, 0x0000001054407824ULL, 0x000fe200078e025eULL,
0x000000221c18723cULL, 0x000fe20000041818ULL, 0x01200000201c783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000d1c1c7232ULL, 0x084fe40000200000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000200000ULL,
0x0000000e1d1d7232ULL, 0x080fe40000200000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000200000ULL,
0x0000005e57207211ULL, 0x002fe200078e20ffULL, 0x000000004040783bULL, 0x000e620000004200ULL,
0x0000005b59597221ULL, 0x000fc60000010000ULL, 0x000000002828783bULL, 0x000ee80000004200ULL,
0x000000002424783bULL, 0x000f280000004200ULL, 0x000000002020783bULL, 0x000f620000004200ULL,
0x000000401c2c723cULL, 0x006fec000004182cULL, 0x000000421c30723cULL, 0x000fe20000041830ULL,
0x00000001ff407424ULL, 0x000fca00078e00ffULL, 0x000000281c34723cULL, 0x008fec0000041834ULL,
0x0000002a1c38723cULL, 0x000fec0000041838ULL, 0x000000241c3c723cULL, 0x010fec000004183cULL,
0x000000261c10723cULL, 0x000fec0000041810ULL, 0x000000201c14723cULL, 0x020fec0000041814ULL,
0x000000221c18723cULL, 0x000fe20000041818ULL, 0x000000085d217824ULL, 0x000fc800078e0207ULL,
0x01b6984021ff79a7ULL, 0x0003e4000850003fULL, 0x000000010b1e7824ULL, 0x000fca00078e024aULL,
0x000000051e00720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000000800f40947ULL, 0x002fea0003800000ULL, 0x000000011e1c7836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x000001001e1f7824ULL, 0x000fc600078e0203ULL,
0x000000051c00720cULL, 0x000fe20003f06070ULL, 0x0000000402277c24ULL, 0x000fd8000f8e021fULL,
0x0000000400888947ULL, 0x000fea0003800000ULL, 0x00000003ff297819ULL, 0x000fe20000011608ULL,
0x000000ffff267224ULL, 0x000fe200078e0a1fULL, 0x0000001f061d7248ULL, 0x000fe20007fe0000ULL,
0x00000080001c7824ULL, 0x000fe200078e0244ULL, 0x0000900000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000429257836ULL, 0x000fe20000000000ULL, 0x000000201d267446ULL, 0x000fe20003800026ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000000c29537810ULL, 0x000fe20007ffe0ffULL,
0x0000000825417824ULL, 0x000fe200078e00ffULL, 0x00000008251e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000129217824ULL, 0x100fe200078e0227ULL, 0x000000262500720cULL, 0x0c0fe20003f26070ULL,
0x0000000125257824ULL, 0x000fe200078e0227ULL, 0xfffffff841417812ULL, 0x000fe200078ee21eULL,
0x00000001291e7824ULL, 0x040fe200078e0208ULL, 0x000000262900720cULL, 0x000fe20003f06070ULL,
0x0000010021207825ULL, 0x000fe200078e001cULL, 0x00000014295b7810ULL, 0x000fc40007ffe0ffULL,
0x000000071e2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000829437836ULL, 0x000fe20000000000ULL,
0x0000000420207c10ULL, 0x000fe2000ff5e0ffULL, 0x0000010025247825ULL, 0x000fe200078e001cULL,
0x0ffffff82b2b7812ULL, 0x000fe400078ef808ULL, 0x0000000521217c10ULL, 0x000fe200097fe4ffULL,
0x0000001029577836ULL, 0x000fe20000000000ULL, 0x0000000424247c10ULL, 0x000fe2000ff7e0ffULL,
0x00000001431f7824ULL, 0x140fe200078e0227ULL, 0x000000264300720cULL, 0x080fe20003fa6070ULL,
0x0000000153237824ULL, 0x000fe200078e0227ULL, 0x0000000525257c10ULL, 0x000fe20009ffe4ffULL,
0x000000102b2b7824ULL, 0x000fe200078e025eULL, 0x000000265300720cULL, 0x000fe20003f86070ULL,
0x00000018295f7836ULL, 0x000fc40000000000ULL, 0x0000001c29617836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202b7faeULL, 0x0003e2000c101c46ULL,
0x0000000157297824ULL, 0x000fe400078e0227ULL, 0x000001001f1e7825ULL, 0x000fe200078e001cULL,
0x000000266100720cULL, 0x000fc60003f06070ULL, 0x0000010023227825ULL, 0x000fe200078e001cULL,
0x000000041e1e7c10ULL, 0x000fc6000ff5e0ffULL, 0x0000001041417824ULL, 0x000fe200078e025eULL,
0x0000000422227c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010029207825ULL, 0x002fe200078e001cULL,
0x000000051f1f7c10ULL, 0x000fe400097fe4ffULL, 0x0000000024417faeULL, 0x0003e2000c901c46ULL,
0x0000000143287824ULL, 0x140fe200078e0208ULL, 0x0000000523237c10ULL, 0x000fe20009ffe4ffULL,
0x0000000843437824ULL, 0x000fe200078e00ffULL, 0x000000265700720cULL, 0x080fe20003f66070ULL,
0x00000001532a7824ULL, 0x040fe200078e0208ULL, 0x0000000353537819ULL, 0x000fe200000006ffULL,
0x000000015b297824ULL, 0x040fe200078e0227ULL, 0x000000265b00720cULL, 0x000fc40003f46070ULL,
0x000000265f00720cULL, 0x000fe20003f26070ULL, 0x0000000157267824ULL, 0x100fe200078e0208ULL,
0x0000000420247c10ULL, 0x002fe4000ffde0ffULL, 0xfffffff843417812ULL, 0x000fe200078ee228ULL,
0x000000015b287824ULL, 0x000fe200078e0208ULL, 0xfffffff853437812ULL, 0x000fe200078ee22aULL,
0x0000000857537824ULL, 0x000fe200078e00ffULL, 0x0000000521257c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010029207825ULL, 0x000fe200078e001cULL, 0x00000027612b7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff853537812ULL, 0x000fe200078ee226ULL, 0x000000015f297824ULL, 0x000fe200078e0227ULL,
0x0000000420207c10ULL, 0x000fe2000ffde0ffULL, 0x000000085b577824ULL, 0x000fe200078e00ffULL,
0x0000005e53537211ULL, 0x000fe200078e20ffULL, 0x0000010029267825ULL, 0x000fe200078e001cULL,
0x0000000521217c10ULL, 0x000fe4000b7fe4ffULL, 0xfffffff857577812ULL, 0x000fe200078ee228ULL,
0x000000015f287824ULL, 0x040fe200078e0208ULL, 0x0000000426267c10ULL, 0x000fe2000ffde0ffULL,
0x000000085f297824ULL, 0x000fc400078e00ffULL, 0x00000001612a7824ULL, 0x040fe200078e0208ULL,
0x0000000527277c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000861617824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee228ULL, 0x000001002b1c7825ULL, 0x000fc600078e001cULL,
0xfffffff8612b7812ULL, 0x000fe200078ee22aULL, 0x0000001041417824ULL, 0x100fe200078e025eULL,
0x000000041c1c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000001043437824ULL, 0x100fe400078e025eULL,
0x0000001057577824ULL, 0x100fe200078e025eULL, 0x000000051d1d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001029297824ULL, 0x100fe200078e025eULL, 0x000000001e417faeULL, 0x0003e2000e901c46ULL,
0x000000102b2b7824ULL, 0x000fc600078e025eULL, 0x0000000022437faeULL, 0x0003e8000e101c46ULL,
0x0000000024537faeULL, 0x0003e8000d901c46ULL, 0x0000000020577faeULL, 0x0003e8000d101c46ULL,
0x0000000026297faeULL, 0x0003e8000c901c46ULL, 0x000000001c2b7faeULL, 0x0003e2000c101c46ULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x00000008081d7811ULL, 0x000fe200078fe8ffULL,
0x0000008000267824ULL, 0x000fe200078e0244ULL, 0x0000001008217811ULL, 0x040fe200078fe8ffULL,
0x0000900000047ab9ULL, 0x000fe20000000a00ULL, 0x000000031d1e7819ULL, 0x040fe200000006ffULL,
0x000000011d437824ULL, 0x100fe200078e0208ULL, 0x0000000408297811ULL, 0x040fe200078fe8ffULL,
0x00000008215f7824ULL, 0x000fe200078e00ffULL, 0x0000000c081f7811ULL, 0x040fe200078fe8ffULL,
0x000000011d1d7824ULL, 0x100fe200078e0227ULL, 0xfffffff81e437812ULL, 0x000fe200078ee243ULL,
0x00000001211e7824ULL, 0x100fe200078e0208ULL, 0x0000001408237811ULL, 0x040fe200078fe8ffULL,
0x0000000129417824ULL, 0x140fe200078e0208ULL, 0x0000001808257811ULL, 0x040fe200078fe8ffULL,
0x00000008291c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee21eULL,
0x000000081f5b7824ULL, 0x000fe200078e00ffULL, 0x0000001c081e7811ULL, 0x040fe200078fe8ffULL,
0x0000000123207824ULL, 0x100fe200078e0208ULL, 0xfffffff81c417812ULL, 0x000fe200078ee241ULL,
0x000000011f1c7824ULL, 0x100fe200078e0208ULL, 0x0000000825227210ULL, 0x000fe20007ffe0ffULL,
0x0000000823617824ULL, 0x000fe200078e00ffULL, 0x00000027082b7211ULL, 0x040fe200078fe8ffULL,
0x0000000825637824ULL, 0x000fe200078e00ffULL, 0x0000002723237210ULL, 0x000fe20007ffe0ffULL,
0x0000000129297824ULL, 0x100fe200078e0227ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee21cULL,
0x000000011f1f7824ULL, 0x100fe200078e0227ULL, 0x00000008081c7211ULL, 0x000fe200078fe8ffULL,
0x0000000121217824ULL, 0x100fe200078e0227ULL, 0xfffffff861617812ULL, 0x000fe200078ee220ULL,
0x0000000125257824ULL, 0x100fe200078e0227ULL, 0x000000071c577812ULL, 0x000fe200078ec0ffULL,
0x000000011e537824ULL, 0x040fe200078e0227ULL, 0xfffffff863637812ULL, 0x000fe200078ee222ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x0ffffff857577812ULL, 0x000fe200078ef808ULL,
0x000000011e427824ULL, 0x000fe200078e0208ULL, 0x0000005e41417211ULL, 0x000fe200078e20ffULL,
0x000001002b2a7825ULL, 0x000fc800078e0026ULL, 0x0000010029287825ULL, 0x000fe200078e0026ULL,
0x000000042a2a7c10ULL, 0x000fc6000ff1e0ffULL, 0x000000081e657824ULL, 0x000fe200078e00ffULL,
0x0000000428287c10ULL, 0x000fe2000ff3e0ffULL, 0x000001001d1c7825ULL, 0x100fe200078e0026ULL,
0x000000052b2b7c10ULL, 0x000fe400087fe4ffULL, 0x0000000529297c10ULL, 0x000fe20008ffe4ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0026ULL, 0x000000041c1c7c10ULL, 0x000fc6000ff5e0ffULL,
0x0000010021207825ULL, 0x100fe200078e0026ULL, 0x000000041e1e7c10ULL, 0x000fe4000ff7e0ffULL,
0x000000051d1d7c10ULL, 0x000fe200097fe4ffULL, 0x0000010023227825ULL, 0x100fe200078e0026ULL,
0x0000000420207c10ULL, 0x000fe4000ff1e0ffULL, 0x000000051f1f7c10ULL, 0x000fe20009ffe4ffULL,
0x0000010025247825ULL, 0x100fe200078e0026ULL, 0x0000000422227c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000521217c10ULL, 0x000fe200087fe4ffULL, 0x0000010053267825ULL, 0x000fe200078e0026ULL,
0xfffffff865537812ULL, 0x000fc400078ee242ULL, 0x0000000424247c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001057577824ULL, 0x100fe200078e025eULL, 0x0000000426267c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001043437824ULL, 0x100fe200078e025eULL, 0x0000000523237c10ULL, 0x000fe20008ffe4ffULL,
0x000000105b5b7824ULL, 0x100fe200078e025eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a577faeULL, 0x0003e2000b901c46ULL, 0x000000105f5f7824ULL, 0x100fe200078e025eULL,
0x0000000525257c10ULL, 0x000fe200097fe4ffULL, 0x0000001061617824ULL, 0x100fe200078e025eULL,
0x0000000028417faeULL, 0x0003e2000b901c46ULL, 0x0000001063637824ULL, 0x100fe200078e025eULL,
0x0000000527277c10ULL, 0x000fe20009ffe4ffULL, 0x0000001053537824ULL, 0x000fe200078e025eULL,
0x000000001c437faeULL, 0x0003e8000b901c46ULL, 0x000000001e5b7faeULL, 0x0003e8000b901c46ULL,
0x00000000205f7faeULL, 0x0003e8000b901c46ULL, 0x0000000022617faeULL, 0x0003e8000b901c46ULL,
0x0000000024637faeULL, 0x0003e8000b901c46ULL, 0x0000000026537faeULL, 0x0003e4000b901c46ULL,
0x000000075d1c7211ULL, 0x002fe200078e28ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001004217812ULL, 0x040fe400078ec0ffULL, 0x00000008041d7812ULL, 0x000fc800078ec0ffULL,
0x0000001c1d217210ULL, 0x000fc80007ffe021ULL, 0x01b66840214079a7ULL, 0x0002a6000850003fULL,
0x00000000001c7805ULL, 0x000fce0000015200ULL, 0x01b66841210075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff207224ULL, 0x000fce00078e00ffULL,
0x000000102000780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fce0000015200ULL, 0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000231e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000120207836ULL, 0x000fce0000000000ULL,
0x01b66841210075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000030f1c7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff527224ULL, 0x000fc800078e005aULL,
0x000000801c1d7824ULL, 0x000fca00078e0207ULL, 0x0000001d4e1d7210ULL, 0x000fca0007ffe044ULL,
0x01b000001d1f7984ULL, 0x000ea80000000800ULL, 0x01b200001d537984ULL, 0x0006e20000000800ULL,
0x0000005a1f00720bULL, 0x004fda0003f1d000ULL, 0x00000000001e7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff1e207812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x00afea0003800000ULL, 0x0000000f1c00720cULL, 0x000fe40003f25270ULL,
0x0000005a1f00720bULL, 0x000fd60003f14000ULL, 0x000000070f219211ULL, 0x000fe400078e38ffULL,
0x0000005a1f1d9209ULL, 0x000fe40007810000ULL, 0x000000214e449210ULL, 0x000fe40007ffe044ULL,
0x0000000000217806ULL, 0x000fc600000e0100ULL, 0x01b4001d44009388ULL, 0x0003e20000000800ULL,
0x00009910211e7816ULL, 0x000fc800000000ffULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005a1f1d7209ULL, 0x000fe40007810000ULL,
0x000000ff21ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0021ff7812ULL, 0x000fe2000782c0ffULL,
0x0000005a1d1d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1d1d7820ULL, 0x000fc80000410000ULL,
0x0000001d001e7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1d7819ULL, 0x002fcc0000011608ULL, 0x00001f1d1e1d7589ULL, 0x004e6400000e0000ULL,
0x0000002c1d2c7220ULL, 0x042fe20000410000ULL, 0x0000002d1d2d7220ULL, 0x040fe20000410000ULL,
0x000000301d307220ULL, 0x040fe20000410000ULL, 0x000000311d317220ULL, 0x040fe20000410000ULL,
0x000000341d347220ULL, 0x040fe20000410000ULL, 0x000000351d357220ULL, 0x040fe20000410000ULL,
0x000000381d387220ULL, 0x040fe20000410000ULL, 0x000000391d397220ULL, 0x040fe20000410000ULL,
0x0000003c1d3c7220ULL, 0x040fe20000410000ULL, 0x0000003d1d3d7220ULL, 0x040fe20000410000ULL,
0x000000101d107220ULL, 0x040fe20000410000ULL, 0x000000111d117220ULL, 0x040fe20000410000ULL,
0x000000141d147220ULL, 0x040fe20000410000ULL, 0x000000151d157220ULL, 0x040fe20000410000ULL,
0x000000181d187220ULL, 0x040fe20000410000ULL, 0x000000191d197220ULL, 0x000fce0000410000ULL,
0x0000001e59597220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008081d7811ULL, 0x002fcc00078ff0ffULL, 0x00001f1d1e1d7589ULL, 0x000e6400000e0000ULL,
0x0000002e1d2e7220ULL, 0x042fe20000410000ULL, 0x0000002f1d2f7220ULL, 0x040fe20000410000ULL,
0x000000321d327220ULL, 0x040fe20000410000ULL, 0x000000331d337220ULL, 0x040fe20000410000ULL,
0x000000361d367220ULL, 0x040fe20000410000ULL, 0x000000371d377220ULL, 0x040fe20000410000ULL,
0x0000003a1d3a7220ULL, 0x040fe20000410000ULL, 0x0000003b1d3b7220ULL, 0x040fe20000410000ULL,
0x0000003e1d3e7220ULL, 0x040fe20000410000ULL, 0x0000003f1d3f7220ULL, 0x040fe20000410000ULL,
0x000000121d127220ULL, 0x040fe20000410000ULL, 0x000000131d137220ULL, 0x040fe20000410000ULL,
0x000000161d167220ULL, 0x040fe20000410000ULL, 0x000000171d177220ULL, 0x040fe20000410000ULL,
0x0000001a1d1a7220ULL, 0x040fe20000410000ULL, 0x0000001b1d1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff20ff7812ULL, 0x000fe40007806021ULL, 0x0000005a1f527209ULL, 0x000fd60007810000ULL,
0x800000521f1f0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1f1f0820ULL, 0x000fc80000410000ULL,
0x0000001f000c0308ULL, 0x000ea40000000800ULL, 0x0000000c53530220ULL, 0x004fce0000410000ULL,
0x000000020f1d7824ULL, 0x002fe200078e00ffULL, 0x0000004d4c4c7212ULL, 0x000fe200078efcffULL,
0x000008001c207824ULL, 0x000fe200078e0207ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000041d1d7812ULL, 0x000fe200078ec0ffULL, 0x000000084c1e7824ULL, 0x000fe200078e00ffULL,
0x0000005545247211ULL, 0x000fe200078e20ffULL, 0x0000001047477824ULL, 0x100fe200078e0255ULL,
0x0000001d081d7211ULL, 0x000fe200078fe0ffULL, 0x0000001046407824ULL, 0x000fc800078e0255ULL,
0x000000014c1d7824ULL, 0x000fca00078e021dULL, 0xfffffff81e1d7812ULL, 0x000fca00078ee21dULL,
0x000000101d1d7824ULL, 0x000fe200078e0220ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fc600000010ffULL,
0x000000081f217836ULL, 0x000fe20000000000ULL, 0x000054100d1c7816ULL, 0x000fca000000000dULL,
0x00001f1f1c0d7589ULL, 0x0002a800000e0000ULL, 0x00001f211c0e7589ULL, 0x0002e400000e0000ULL,
0x011000001d1c783bULL, 0x002e620000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000d1c1c7232ULL, 0x086fe40000200000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000200000ULL,
0x0000000e1d1d7232ULL, 0x088fe40000200000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000200000ULL,
0x000000104b287824ULL, 0x000fe200078e0255ULL, 0x000000004744783bULL, 0x000f220000004200ULL,
0x000000105c207824ULL, 0x000fe400078e0220ULL, 0x0000005953557221ULL, 0x000fe20000010000ULL,
0x000000004040783bULL, 0x000f680000004200ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000002828783bULL, 0x000f680000004200ULL, 0x011000002020783bULL, 0x000f620000000200ULL,
0x000000441c2c723cULL, 0x012fec000004182cULL, 0x000000461c30723cULL, 0x000fec0000041830ULL,
0x000000401c34723cULL, 0x028fec0000041834ULL, 0x000000421c38723cULL, 0x000fec0000041838ULL,
0x000000241c3c723cULL, 0x004fec000004183cULL, 0x000000261c10723cULL, 0x000fec0000041810ULL,
0x000000281c14723cULL, 0x000fec0000041814ULL, 0x0000002a1c1c723cULL, 0x000fe20000041818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000d20207232ULL, 0x080fe40000200000ULL, 0x0000000d22227232ULL, 0x000fe40000200000ULL,
0x0000000e21217232ULL, 0x080fe40000200000ULL, 0x0000000e23237232ULL, 0x000fce0000200000ULL,
0x000000005124783bULL, 0x000e620000004200ULL, 0x0000004a0b4a7210ULL, 0x000fc60007ffe0ffULL,
0x000000005018783bULL, 0x000ea20000004200ULL, 0x000000054a00720cULL, 0x000fc60003f06070ULL,
0x000000005840783bULL, 0x000ee80000004200ULL, 0x000000005628783bULL, 0x000f220000004200ULL,
0x00000024203c723cULL, 0x002fec000004183cULL, 0x000000182014723cULL, 0x004fe20000041814ULL,
0x00000002ff247819ULL, 0x000fca000001160fULL, 0x0000000824247824ULL, 0x000fe200078e0207ULL,
0x00000040202c723cULL, 0x008fe2000004182cULL, 0x00000001ff197424ULL, 0x000fc800078e00ffULL,
0x01b6a01924ff79a7ULL, 0x0003e2000850003fULL, 0x000000422030723cULL, 0x000fec0000041830ULL,
0x000000282034723cULL, 0x010fec0000041834ULL, 0x0000002a2038723cULL, 0x000fec0000041838ULL,
0x000000262010723cULL, 0x000fec0000041810ULL, 0x0000001a201c723cULL, 0x000fe2000004181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffffa000248947ULL, 0x002fde000383ffffULL,
0x00000000000c7919ULL, 0x000e620000002500ULL, 0x000000ffff1b7224ULL, 0x000fe200078e0016ULL,
0x0000001500167202ULL, 0x000fe20000000f00ULL, 0x000000ffff067224ULL, 0x000fe400078e0017ULL,
0x000000ffff187224ULL, 0x000fe400078e0012ULL, 0x000000ffff087224ULL, 0x000fe400078e001fULL,
0x000000ffff197224ULL, 0x000fe400078e001eULL, 0x000000ffff1a7224ULL, 0x000fc400078e001dULL,
0x000000ffff297224ULL, 0x000fe400078e001cULL, 0x000000ffff177224ULL, 0x000fe400078e0014ULL,
0x000000ffff207224ULL, 0x000fe400078e0013ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe200078e0010ULL, 0x000000050c00720cULL, 0x002fda0003f06070ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x0180000055027836ULL, 0x000fca0000000000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000005500047202ULL, 0x000fe40000000f00ULL,
0x00007e80000d7802ULL, 0x000fce0000000f00ULL, 0x000000b800007944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000005500027308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000055ULL, 0x800000ff04057221ULL, 0x000fc80000010100ULL,
0x0000000502027223ULL, 0x000fce0000000002ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x00000002ff0d7819ULL, 0x002fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x008fea0003800000ULL, 0x00001f0d02047589ULL, 0x000e6800000e0000ULL,
0x00001f0502057589ULL, 0x000ea200000e0000ULL, 0x0000002c042c7220ULL, 0x042fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003804387220ULL, 0x040fe20000410000ULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000003c043c7220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x000fe20000410000ULL, 0x0000002e052e7220ULL, 0x044fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000000605067220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000000805087220ULL, 0x000fce0000410000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000000171616723eULL, 0x000fe200000010ffULL, 0x000000ff00287306ULL, 0x000ea20000202400ULL,
0x000000291a17723eULL, 0x000fe200000010ffULL, 0x00001000001a7824ULL, 0x000fe200078e0207ULL,
0x000000190807723eULL, 0x000fe200000010ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000008004f087824ULL, 0x000fe200078e021aULL, 0x0000002c2d1c723eULL, 0x000fc400000010ffULL,
0x00000030311d723eULL, 0x000fe400000010ffULL, 0x00000034351e723eULL, 0x000fe400000010ffULL,
0x00000038391f723eULL, 0x000fe400000010ffULL, 0x000000151215723eULL, 0x000fe400000010ffULL,
0x000000363712723eULL, 0x000fe400000010ffULL, 0x0000003a3b13723eULL, 0x000fc400000010ffULL,
0x0000001b0606723eULL, 0x000fe400000010ffULL, 0x000000010b00780cULL, 0x000fe40003f05270ULL,
0x00000003ff0d7819ULL, 0x102fe20000011602ULL, 0x0000000103297824ULL, 0x000fe200078e0202ULL,
0xfffffff8ff057812ULL, 0x000fe400078ee202ULL, 0x000000030d047812ULL, 0x000fe200078ec0ffULL,
0x00000010292a7824ULL, 0x000fe400078e021aULL, 0x0000000805117836ULL, 0x000fc40000000000ULL,
0x0000000805147824ULL, 0x040fe400078e00ffULL, 0x0000000805237824ULL, 0x000fe200078e00ffULL,
0x0000000311277819ULL, 0x040fe200000006ffULL, 0x0000000104057824ULL, 0x040fe400078e0205ULL,
0x00000001040e7824ULL, 0x000fe400078e0211ULL, 0x0000000405047836ULL, 0x000fe20000000000ULL,
0xfffffff814217812ULL, 0x000fe200078ee205ULL, 0x0000000811257824ULL, 0x000fe200078e00ffULL,
0x0000003c3d14723eULL, 0x000fe200000010ffULL, 0x0000000c05107836ULL, 0x000fe20000000000ULL,
0xfffffff823237812ULL, 0x000fc400078ee204ULL, 0xfffffff825257812ULL, 0x000fe200078ee20eULL,
0x00000010210e7824ULL, 0x100fe200078e0208ULL, 0xfffffff827277812ULL, 0x000fe400078ee210ULL,
0x000000182005723eULL, 0x000fe200000010ffULL, 0x0000001023187824ULL, 0x100fe200078e0208ULL,
0x0000002e2f10723eULL, 0x000fe200000010ffULL, 0x00000010271b7824ULL, 0x000fe200078e0208ULL,
0x000000323311723eULL, 0x000fe200000010ffULL, 0x0000001c0e007844ULL, 0x000fe20000000200ULL,
0x0000000825197211ULL, 0x000fc400078e20ffULL, 0x0000003e3f04723eULL, 0x000fe200000010ffULL,
0x0000001418007844ULL, 0x000fe80000000200ULL, 0x0000001019007844ULL, 0x000fe80000000200ULL,
0x000000041b007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000002a2c7984ULL, 0x000ea80000000c00ULL, 0x000400002a247984ULL, 0x000e680000000c00ULL,
0x000800002a307984ULL, 0x000ee80000000c00ULL, 0x000c00002a207984ULL, 0x000f220000000c00ULL,
0x0000002f282f7230ULL, 0x004fc40000200800ULL, 0x0000002e282e7230ULL, 0x040fe40000200800ULL,
0x0000002d282d7230ULL, 0x040fe40000200800ULL, 0x0000002c282c7230ULL, 0x040fe40000200800ULL,
0x0000002728277230ULL, 0x042fe40000200800ULL, 0x0000002628117230ULL, 0x040fe40000200800ULL,
0x0000002528257230ULL, 0x000fc40000200800ULL, 0x0000002428107230ULL, 0x000fe40000200800ULL,
0x000000332f2f7230ULL, 0x008fe40000200000ULL, 0x000000322e2e7230ULL, 0x000fe40000200000ULL,
0x000000312d2d7230ULL, 0x000fe40000200000ULL, 0x000000302c2c7230ULL, 0x000fe40000200000ULL,
0x0000002327237230ULL, 0x010fc40000200000ULL, 0x0000002211227230ULL, 0x000fe20000200000ULL,
0x0000002c2a007388ULL, 0x0003e20000000c00ULL, 0x0000002125217230ULL, 0x000fe40000200000ULL,
0x0000002010207230ULL, 0x000fca0000200000ULL, 0x000400202a007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000028001c8947ULL, 0x000fea0003800000ULL,
0x00000400ff177b82ULL, 0x000ea20000000800ULL, 0x0000000000187919ULL, 0x000ee20000002600ULL,
0x00000040291b7836ULL, 0x000fe20000000000ULL, 0x0000000000197919ULL, 0x000eea0000002700ULL,
0x00009600ff047b82ULL, 0x000ea20000000800ULL, 0x000400002a107984ULL, 0x00092e0000000c00ULL,
0x00009a00ff147b82ULL, 0x000f620000000a00ULL, 0x0000000417047224ULL, 0x004fc800078e02ffULL,
0x0000000b040e7224ULL, 0x040fe200078e02ffULL, 0x0000000f041f7811ULL, 0x000fe400078e10ffULL,
0x000000002a047984ULL, 0x0009240000000c00ULL, 0xfffffff01f1f7812ULL, 0x000fca00078ec0ffULL,
0x000000800e1d7824ULL, 0x000fc800078e021fULL, 0x000000800e167824ULL, 0x000fe400078e021dULL,
0x00000017190e7224ULL, 0x008fe400078e0218ULL, 0x0000007f16167836ULL, 0x000fe40000000000ULL,
0x0000000b0e1c7224ULL, 0x000fc600078e02ffULL, 0xffffff8016197812ULL, 0x000fe400078ec0ffULL,
0x0000000c1c0c7210ULL, 0x000fe40007ffe0ffULL, 0x0000001419177210ULL, 0x020fc80007f1e0ffULL,
0x000000170c167211ULL, 0x000fe200078260ffULL, 0x000000ffff177224ULL, 0x000fe200000e0615ULL,
0x000000014fff7812ULL, 0x000fc8000780f80fULL, 0x000000170c177211ULL, 0x000fe400008f64ffULL,
0x000000141f277210ULL, 0x000fe20007f3e0ffULL, 0x0000080000167825ULL, 0x000fc800078e0016ULL,
0x0000001029207825ULL, 0x002fc800078e0016ULL, 0x000000101b167825ULL, 0x000fc800078e0016ULL,
0x000000ffff1b7224ULL, 0x000fe200008e0615ULL, 0x0000000000400947ULL, 0x010fec0003800000ULL,
0x00000010021e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff227819ULL, 0x000fe20000011602ULL,
0x000000800c187824ULL, 0x000fe200078e00ffULL, 0x00000019ff0c7819ULL, 0x000fe4000001160cULL,
0x000000701e257812ULL, 0x000fe400078ec0ffULL, 0x0000001418247210ULL, 0x000fe40007ebe01dULL,
0x0000000c22237812ULL, 0x000fe400078ec0ffULL, 0x0000002725187210ULL, 0x000fc40007a3e018ULL,
0x000000150c1e7210ULL, 0x000fe40002fec4ffULL, 0x0000001823227210ULL, 0x000fe40007fbe0ffULL,
0x0000001bff0c7210ULL, 0x000fe40000fe440cULL, 0x0000002423247210ULL, 0x000fc60007c7e025ULL,
0x000000ffff237224ULL, 0x000fe200028e060cULL, 0x0000001eff257210ULL, 0x000fc80001fe84ffULL,
0x0000005222007986ULL, 0x0003e8000c101906ULL, 0x0000005524007986ULL, 0x0003e4000c101906ULL,
0x000000ff0200720cULL, 0x000fe20000705670ULL, 0x0000000420007986ULL, 0x0005e8000c101d06ULL,
0x0000001016007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fee0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009a00ff047b82ULL, 0x004ea20000000a00ULL,
0xffffffff0b077810ULL, 0x000fe20007ffe0ffULL, 0x000000040e047825ULL, 0x004fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000007040479a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000070400720cULL, 0x010fc80003f05270ULL,
0x00000001ff047807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000004ff007988ULL, 0x0007e60008000004ULL, 0x0000000000057919ULL, 0x004ea20000008800ULL,
0x00000400001e7802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000654051e7816ULL, 0x004fca000000001eULL,
0x000000001e047984ULL, 0x008ea40000000000ULL, 0x000000ff0400720cULL, 0x004fda0003f05270ULL,
0x0000002000c08947ULL, 0x000fea0003800000ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001002057824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fe40000011602ULL, 0x000000271c047211ULL, 0x000fe400078038ffULL,
0x0000007005077812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x0000001b1c057211ULL, 0x000fe400000f3cffULL, 0x0000000406047210ULL, 0x000fc8000791e007ULL,
0x00000005ff057210ULL, 0x000fca00007e24ffULL, 0x0000000604067981ULL, 0x000528000c1e1900ULL,
0x0000800604077981ULL, 0x000522000c1e1900ULL, 0x000000020b00780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x004fea0003800000ULL, 0x00010006040d7981ULL, 0x000522000c1e1900ULL,
0x000000040b00780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x004fea0003800000ULL,
0x0001800604117981ULL, 0x000522000c1e1900ULL, 0x000000040b00780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x004fea0003800000ULL, 0x0002000604137981ULL, 0x000522000c1e1900ULL,
0x000000060b00780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x004fea0003800000ULL,
0x0002800604177981ULL, 0x000522000c1e1900ULL, 0x000000060b00780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x004fea0003800000ULL, 0x000000080b00780cULL, 0x000fe20003f06070ULL,
0x00030006041b7981ULL, 0x000518000c1e1900ULL, 0x0003800604210981ULL, 0x000524000c1e1900ULL,
0x000000070b047836ULL, 0x004fca0000000000ULL, 0x00000003ff0c7819ULL, 0x000fc80000011604ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001f1c057211ULL, 0x040fe200078038ffULL, 0x000000ffff237224ULL, 0x012fe200078e0006ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000001405147210ULL, 0x000fe40007f3e0ffULL, 0x000000ff1c047211ULL, 0x000fe400000f3cffULL,
0x0000078014257810ULL, 0x000fc80007f5e0ffULL, 0x00000004ff157210ULL, 0x000fd200017e2415ULL,
0x000000040b007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x000000050c007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000002306067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0xfffc800604237981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fc80007f3e0ffULL, 0x00000015ff057210ULL, 0x000fca0000ffe4ffULL,
0xfffd000604077981ULL, 0x000328000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0xfffd8006040d7981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000001106067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0xfffe000604117981ULL, 0x000326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0xfffe800604137981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001706067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000402047819ULL, 0x002fe400000006ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0xffff000604177981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b06067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0xffff8006041b7981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000002106067209ULL, 0x000fca0007810000ULL,
0x000000080b007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011602ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000425047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0615ULL,
0x0000000604217981ULL, 0x000326000c1e1900ULL, 0x0000040025257810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x0000000402047819ULL, 0x006fe400000006ffULL, 0x00000001ff077819ULL, 0x010fe40000011602ULL,
0x0000007004057812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fc800078ec0ffULL,
0x0000001e07057210ULL, 0x000fca0007ffe005ULL, 0x0000000605007388ULL, 0x0003e40000000800ULL,
0x00009a00ff247b82ULL, 0x002e620000000a00ULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x000008000f1b7824ULL, 0x000fe200078e00ffULL, 0x00000002ff067819ULL, 0x000fe2000001160fULL,
0x000000014f147824ULL, 0x000fe200078e021cULL, 0x00000001ff227819ULL, 0x000fe20000011602ULL,
0x0000001002217824ULL, 0x000fe200078e00ffULL, 0x0000000106067812ULL, 0x000fe200078ec0ffULL,
0x0000006002117836ULL, 0x000fe20000000000ULL, 0x000008001b1b7812ULL, 0x000fe400078ee2ffULL,
0x00000000003a7805ULL, 0x000fc4000001ff00ULL, 0x0000007021217812ULL, 0x000fe400078ec0ffULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x0000000c22227812ULL, 0x000fe200078ec0ffULL,
0x000002004f0d8824ULL, 0x140fe200078e021eULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x000002004f058824ULL, 0x000fe200078e021eULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x0000000d000d8211ULL, 0x040fe200078e40ffULL,
0x0000010000078824ULL, 0x000fe200078e0205ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000002419187210ULL, 0x002fe20007f3e0ffULL, 0x0000008006178824ULL, 0x040fe200078e0207ULL,
0x000000241f1f7210ULL, 0x000fe20007f7e0ffULL, 0x0000008006278824ULL, 0x000fe200078e020dULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff197224ULL, 0x000fe200008e0625ULL,
0x000000241d1d7210ULL, 0x000fe20007f3e0ffULL, 0x000002000f0d7824ULL, 0x000fe200078e00ffULL,
0x0000001e22247210ULL, 0x000fe20007ffe021ULL, 0x000020004f077824ULL, 0x000fe200078e021eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000100014047825ULL, 0x000fe200078e0018ULL,
0x000008000d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000024247984ULL, 0x000e620000000800ULL,
0x0000000700207211ULL, 0x000fe200078e60ffULL, 0x00000040020f7836ULL, 0x000fe20000000000ULL,
0x0000001b04047210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200008e0625ULL,
0x0000001d14108211ULL, 0x000fe200078238ffULL, 0x00000001200d7824ULL, 0x000fe200078e020dULL,
0x00000025ff257210ULL, 0x000fe20001ffe4ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000001f14128211ULL, 0x000fe200078438ffULL, 0x0000002002077836ULL, 0x000fe20000000000ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000001002157824ULL, 0x000fe200078e020dULL,
0x0000002514138211ULL, 0x000fe200010f3cffULL, 0x000000100f0c7825ULL, 0x000fe200078e0004ULL,
0x0000000000347805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000010110e7825ULL, 0x100fe200078e0004ULL,
0x0000002314118211ULL, 0x000fe400008f3cffULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000b4f00720cULL, 0x000fe20003f26070ULL, 0x0000001007067825ULL, 0x000fc800078e0004ULL,
0x0000001002047825ULL, 0x000fc800078e0004ULL, 0x0000001002178824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004157faeULL, 0x000fe2000b901c46ULL,
0x0000001002108825ULL, 0x000fc600078e0010ULL, 0x0038000006157faeULL, 0x000fe2000b901c46ULL,
0x00000010022b8824ULL, 0x040fe200078e0227ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000001002128825ULL, 0x000fe200078e0012ULL, 0x005800000c157faeULL, 0x000fe6000b901c46ULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x007800000e157faeULL, 0x000fe8000b901c46ULL,
0x0458000010178faeULL, 0x000fe8000b901c46ULL, 0x04180000122b8faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000002a7805ULL, 0x004fe2000001ff00ULL,
0x0000000800b41947ULL, 0x002fec0003800000ULL, 0x00000003ff047819ULL, 0x100fe20000011602ULL,
0x000000ffff147224ULL, 0x000fe200078e004fULL, 0xfffffff8ff057812ULL, 0x000fe400078ee202ULL,
0x0000000304047812ULL, 0x000fe400078ec0ffULL, 0x00000002ff507819ULL, 0x000fe20000011602ULL,
0x0000000805077836ULL, 0x000fe20000000000ULL, 0x000000ff00267202ULL, 0x000fe20000000f00ULL,
0x00000008050c7824ULL, 0x040fe400078e00ffULL, 0x0000000805067824ULL, 0x000fe200078e00ffULL,
0x0000000504057210ULL, 0x000fe20007ffe0ffULL, 0x00000001044c7824ULL, 0x000fc400078e0207ULL,
0x00000008070d7824ULL, 0x040fe200078e00ffULL, 0xfffffff8064b7812ULL, 0x000fe200078ee205ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x00000004054d7836ULL, 0x000fe20000000000ULL,
0xfffffff80d4c7812ULL, 0x000fe200078ee24cULL, 0x0000000c054e7836ULL, 0x000fe40000000000ULL,
0x000002004f057824ULL, 0x000fe200078e021eULL, 0xfffffff80c4d7812ULL, 0x000fe200078ee24dULL,
0x0000000850477836ULL, 0x000fe20000000000ULL, 0xfffffff8074e7812ULL, 0x000fe200078ee24eULL,
0x0000010000527824ULL, 0x000fce00078e0205ULL, 0x00000002144a7836ULL, 0x000fca0000000000ULL,
0x0000000b4a00720cULL, 0x000fda0003f06070ULL, 0x00000000009c0947ULL, 0x000fea0003800000ULL,
0x000000011c167824ULL, 0x100fe200078e024aULL, 0x000000070200780cULL, 0x000fe20003f44070ULL,
0x0000004002537836ULL, 0x000fe20000000000ULL, 0x00000001ff067819ULL, 0x000fe2000001164aULL,
0x0000100016047825ULL, 0x000fe200078e0018ULL, 0x0000006002557810ULL, 0x000fe40007ffe0ffULL,
0x0000000106517812ULL, 0x000fe400078ec0ffULL, 0x0000001b040e7210ULL, 0x000fe20007f1e0ffULL,
0x000004004a047824ULL, 0x000fc800078e00ffULL, 0x000002004f07a824ULL, 0x000fe200078e021eULL,
0x0000001f160ca211ULL, 0x000fe200078238ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0605ULL,
0x0000080004057812ULL, 0x000fe400078ec0ffULL, 0x000000070052a211ULL, 0x000fe200078e40ffULL,
0x0000002002077836ULL, 0x000fe20000000000ULL, 0x0000001d1610a211ULL, 0x000fe200078038ffULL,
0x0000000120057824ULL, 0x000fe200078e0205ULL, 0x00000025160da211ULL, 0x040fe200008f3cffULL,
0x000000805117a824ULL, 0x000fe200078e0252ULL, 0x000000231611a211ULL, 0x000fe200000f3cffULL,
0x0000001002157824ULL, 0x000fc400078e0205ULL, 0x0000001002127825ULL, 0x000fc800078e000eULL,
0x0000001007047825ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000012157faeULL, 0x0003e6000b901c46ULL, 0x000000805151a824ULL, 0x000fe200078e0252ULL,
0x0038000004157faeULL, 0x0003e2000b901c46ULL, 0x0000001053067825ULL, 0x000fc800078e000eULL,
0x00000010550e7825ULL, 0x000fe200078e000eULL, 0x0058000006157faeULL, 0x0003e6000b901c46ULL,
0x000000100210a825ULL, 0x040fe200078e0010ULL, 0x007800000e157faeULL, 0x0003e6000b901c46ULL,
0x000000100217a824ULL, 0x040fe400078e0217ULL, 0x00000010020ca825ULL, 0x000fc600078e000cULL,
0x045800001017afaeULL, 0x0003e2000b901c46ULL, 0x000000100251a824ULL, 0x000fca00078e0251ULL,
0x041800000c51afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000004014047824ULL, 0x002fca00078e00ffULL, 0x0000008004047812ULL, 0x000fc800078ec0ffULL,
0x0000005221057210ULL, 0x000fe40007ffe004ULL, 0x0000000a14047819ULL, 0x000fc600000006ffULL,
0x0000000122517824ULL, 0x000fe200078e0205ULL, 0x0000080004057812ULL, 0x000fc800078ec0ffULL,
0x0000018020147810ULL, 0x000fe20007ffe005ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800051117984ULL, 0x000e620000000800ULL, 0x000000104b047824ULL, 0x100fe400078e0214ULL,
0x000000104d0c7824ULL, 0x100fe200078e0214ULL, 0x0045800051547984ULL, 0x000fe20000000800ULL,
0x000000104c107824ULL, 0x100fe400078e0214ULL, 0x000000104e147824ULL, 0x000fe200078e0214ULL,
0x000000000404783bULL, 0x000ea80000000200ULL, 0x000000000c0c783bULL, 0x000ee20000000200ULL,
0x0000001124157221ULL, 0x002fc60000010100ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x3fb8aa3b15577820ULL, 0x000fc60000410000ULL, 0x000000001414783bULL, 0x000f220000000200ULL,
0x0000763204517816ULL, 0x044fe20000000051ULL, 0x0001000004047824ULL, 0x000fe200078e00ffULL,
0x0000005700577308ULL, 0x000ea20000000800ULL, 0x0000763205537816ULL, 0x000fe20000000053ULL,
0x000100000d587824ULL, 0x008fe200078e00ffULL, 0x0000001006557819ULL, 0x000fe200000006ffULL,
0x0001000007567824ULL, 0x000fe200078e00ffULL, 0x0000001051517819ULL, 0x000fe200000006ffULL,
0x000100000e597824ULL, 0x000fe400078e00ffULL, 0x0001000053537824ULL, 0x000fc400078e00ffULL,
0x0000005457637220ULL, 0x004fe20000410000ULL, 0x0001000005547824ULL, 0x000fe200078e00ffULL,
0x0000763206057816ULL, 0x000fe40000000005ULL, 0x0000004663467221ULL, 0x000fe20000010000ULL,
0x00001f5063647589ULL, 0x000ea200000e0000ULL, 0x0000763207067816ULL, 0x000fe40000000006ULL,
0x000076320d577816ULL, 0x000fe20000000057ULL, 0x00001f4763637589ULL, 0x000ee200000e0000ULL,
0x000076320e0d7816ULL, 0x000fc4000000000dULL, 0x000076320c077816ULL, 0x040fe20000000007ULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x000076320f0e7816ULL, 0x040fe2000000000eULL,
0x000100000f0f7824ULL, 0x000fe200078e00ffULL, 0x00007632135d7816ULL, 0x042fe2000000005dULL,
0x00010000135e7824ULL, 0x000fe200078e00ffULL, 0x00007632105a7816ULL, 0x040fe2000000005aULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x0000763214137816ULL, 0x050fe20000000013ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00007632155f7816ULL, 0x040fe2000000005fULL,
0x0001000015607824ULL, 0x000fe200078e00ffULL, 0x00007632115b7816ULL, 0x000fe2000000005bULL,
0x0001000017627824ULL, 0x000fe200078e00ffULL, 0x00007632125c7816ULL, 0x040fe2000000005cULL,
0x0001000012127824ULL, 0x000fc400078e00ffULL, 0x0000006404397223ULL, 0x084fe20000010039ULL,
0x0001000005047824ULL, 0x000fe200078e00ffULL, 0x0000763216157816ULL, 0x000fe20000000015ULL,
0x0001000006057824ULL, 0x000fe400078e00ffULL, 0x00000063142b7223ULL, 0x008fe2000001002bULL,
0x000000ffff147224ULL, 0x000fe400078e004aULL, 0x00000064043f7223ULL, 0x080fe2000001003fULL,
0x00000064053e7223ULL, 0x080fe2000001003eULL, 0x000000100e057819ULL, 0x000fe200000006ffULL,
0x0001000007047824ULL, 0x000fe200078e00ffULL, 0x0000000b1400720cULL, 0x000fe20003f06070ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x0000763217617816ULL, 0x000fe20000000061ULL,
0x00000064043d7223ULL, 0x080fe2000001003dULL, 0x0000001011117819ULL, 0x000fe200000006ffULL,
0x00000064053a7223ULL, 0x000fe2000001003aULL, 0x000000105f5f7819ULL, 0x000fe200000006ffULL,
0x0001000057577824ULL, 0x000fc400078e00ffULL, 0x0000006451387223ULL, 0x080fe20000010038ULL,
0x000100000d047824ULL, 0x000fe400078e00ffULL, 0x0000006454377223ULL, 0x080fe20000010037ULL,
0x000100005a5a7824ULL, 0x000fe400078e00ffULL, 0x0000006453367223ULL, 0x080fe20000010036ULL,
0x000100005b5b7824ULL, 0x000fe400078e00ffULL, 0x0000006455447223ULL, 0x000fe20000010044ULL,
0x000100005c057824ULL, 0x000fc400078e00ffULL, 0x0000006456437223ULL, 0x080fe20000010043ULL,
0x000100005d5d7824ULL, 0x000fe400078e00ffULL, 0x000000640c417223ULL, 0x080fe20000010041ULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x0000006458457223ULL, 0x080fe20000010045ULL,
0x0001000015157824ULL, 0x000fe400078e00ffULL, 0x00000064573c7223ULL, 0x000fe2000001003cULL,
0x0001000061617824ULL, 0x000fc400078e00ffULL, 0x0000006459427223ULL, 0x080fe20000010042ULL,
0x00000064043b7223ULL, 0x080fe2000001003bULL, 0x000000640f407223ULL, 0x000fe20000010040ULL,
0x0000006310357223ULL, 0x080fe20000010035ULL, 0x000000635a2f7223ULL, 0x080fe2000001002fULL,
0x00000063112e7223ULL, 0x080fe2000001002eULL, 0x000000635b347223ULL, 0x080fe20000010034ULL,
0x0000006312337223ULL, 0x080fe20000010033ULL, 0x0000006305327223ULL, 0x080fe20000010032ULL,
0x000000635e2d7223ULL, 0x080fe2000001002dULL, 0x000000635d2c7223ULL, 0x080fe2000001002cULL,
0x00000063132a7223ULL, 0x080fe2000001002aULL, 0x0000006360317223ULL, 0x080fe20000010031ULL,
0x000000635f307223ULL, 0x080fe20000010030ULL, 0x0000006316297223ULL, 0x080fe20000010029ULL,
0x0000006315287223ULL, 0x080fe20000010028ULL, 0x0000006362277223ULL, 0x080fe20000010027ULL,
0x0000006361267223ULL, 0x000fe20000010026ULL, 0xfffffff400a48947ULL, 0x000fec000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000001002047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe20000011602ULL,
0x000049801e027836ULL, 0x000fc60000000000ULL, 0x0000007004077812ULL, 0x000fe400078ec0ffULL,
0x0000000c05067812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x000000804f1e7824ULL, 0x000fe400078e021eULL,
0x0000001004057824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011604ULL,
0x0000007005057812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000001e04057210ULL, 0x000fca0007ffe005ULL, 0x0049804605007388ULL, 0x0003e40000000800ULL,
0x0000000206027210ULL, 0x000fe20007ffe007ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000ea80000000800ULL, 0x0000800002057984ULL, 0x002e620000000800ULL,
0x00000004ff047221ULL, 0x004fc80000010000ULL, 0x0000000504047221ULL, 0x002fca0000010000ULL,
0x0180000004057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000a730000d7802ULL, 0x000fce0000000f00ULL,
0x0000008c00d47944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x008fe200078e0002ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000400057308ULL, 0x000e640000001000ULL,
0xbf80000004027423ULL, 0x002fc80000000005ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000205057223ULL, 0x000fce0000000005ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x00000002ff047819ULL, 0x102fe20000011602ULL, 0x0000000103037824ULL, 0x100fe200078e0202ULL,
0x00000008020c7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0405047589ULL, 0x000e6800000e0000ULL,
0x00001f0c050b7589ULL, 0x0004e200000e0000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0xfffffff8ff057812ULL, 0x004fca00078ee202ULL, 0x00000008050e7824ULL, 0x040fe400078e00ffULL,
0x0000000805197824ULL, 0x000fe400078e00ffULL, 0x0000003904397220ULL, 0x042fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000004404067220ULL, 0x040fe20000410000ULL,
0x0000003f043f7220ULL, 0x040fe20000410000ULL, 0x0000004304077220ULL, 0x040fe20000410000ULL,
0x0000003e043e7220ULL, 0x040fe20000410000ULL, 0x0000004104107220ULL, 0x040fe20000410000ULL,
0x0000003d043d7220ULL, 0x040fe20000410000ULL, 0x0000004504117220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000004204127220ULL, 0x040fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000004004137220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x000fe20000410000ULL, 0x000000030d047812ULL, 0x000fe200078ec0ffULL,
0x000000350b147220ULL, 0x048fe20000410000ULL, 0x0000002f0b2f7220ULL, 0x040fe20000410000ULL,
0x0000002e0b157220ULL, 0x040fe20000410000ULL, 0x000000340b347220ULL, 0x040fe20000410000ULL,
0x000000330b167220ULL, 0x040fe20000410000ULL, 0x000000320b0f7220ULL, 0x040fe20000410000ULL,
0x0000002d0b177220ULL, 0x040fe20000410000ULL, 0x0000002c0b2c7220ULL, 0x040fe20000410000ULL,
0x0000002b0b2b7220ULL, 0x040fe20000410000ULL, 0x0000002a0b2a7220ULL, 0x040fe20000410000ULL,
0x000000310b317220ULL, 0x040fe20000410000ULL, 0x000000300b307220ULL, 0x040fe20000410000ULL,
0x000000290b297220ULL, 0x040fe20000410000ULL, 0x000000280b287220ULL, 0x040fe20000410000ULL,
0x000000270b277220ULL, 0x040fe20000410000ULL, 0x000000260b267220ULL, 0x000fe20000410000ULL,
0x00000008050b7836ULL, 0x000fe20000000000ULL, 0x000000063f06723eULL, 0x000fe200000010ffULL,
0x0000000104057824ULL, 0x000fe200078e0205ULL, 0x000000073e07723eULL, 0x000fe200000010ffULL,
0x00000001040c7824ULL, 0x000fe200078e020bULL, 0x000000030b1b7819ULL, 0x000fe200000006ffULL,
0x0000000405047836ULL, 0x000fe20000000000ULL, 0x000000103d10723eULL, 0x000fe200000010ffULL,
0x000000080b187824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20cULL,
0x0000000c050b7836ULL, 0x000fe20000000000ULL, 0xfffffff80e057812ULL, 0x000fe200078ee205ULL,
0x00000010030c7824ULL, 0x000fe200078e021aULL, 0xfffffff819197812ULL, 0x000fe200078ee204ULL,
0x000000101b1b7824ULL, 0x100fe200078e0208ULL, 0xfffffff8181d7812ULL, 0x000fe200078ee20bULL,
0x00000010050b7824ULL, 0x100fe200078e0208ULL, 0x000000393804723eULL, 0x000fe200000010ffULL,
0x0000001019197824ULL, 0x000fe200078e0208ULL, 0x000000373605723eULL, 0x000fe200000010ffULL,
0x000000ff00037306ULL, 0x000e620000202400ULL, 0x000000113c11723eULL, 0x000fc400000010ffULL,
0x000000123b12723eULL, 0x000fe200000010ffULL, 0x000000040b007844ULL, 0x000fe20000000200ULL,
0x000000133a13723eULL, 0x000fe400000010ffULL, 0x000000081d087211ULL, 0x000fe400078e20ffULL,
0x000000142f14723eULL, 0x000fe200000010ffULL, 0x0000001019007844ULL, 0x000fe20000000200ULL,
0x000000153415723eULL, 0x000fe400000010ffULL, 0x000000160f16723eULL, 0x000fc400000010ffULL,
0x000000172c17723eULL, 0x000fe400000010ffULL, 0x0000002b2a1c723eULL, 0x000fe400000010ffULL,
0x00000031301d723eULL, 0x000fe200000010ffULL, 0x000000141b007844ULL, 0x000fe20000000200ULL,
0x00000029281e723eULL, 0x000fe400000010ffULL, 0x00000027261f723eULL, 0x000fca00000010ffULL,
0x0000001c08007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000c207984ULL, 0x000e680000000c00ULL, 0x000400000c287984ULL, 0x000ea80000000c00ULL,
0x000800000c247984ULL, 0x000ee80000000c00ULL, 0x000c00000c2c7984ULL, 0x000f220000000c00ULL,
0x0000002303237230ULL, 0x002fc40000200800ULL, 0x0000002203227230ULL, 0x040fe40000200800ULL,
0x0000002103217230ULL, 0x040fe40000200800ULL, 0x0000002003207230ULL, 0x040fe40000200800ULL,
0x0000002b032b7230ULL, 0x044fe40000200800ULL, 0x0000002a032a7230ULL, 0x040fe40000200800ULL,
0x0000002903297230ULL, 0x000fc40000200800ULL, 0x0000002803287230ULL, 0x000fe40000200800ULL,
0x0000002723237230ULL, 0x008fe40000200000ULL, 0x0000002622227230ULL, 0x000fe40000200000ULL,
0x0000002521217230ULL, 0x000fe40000200000ULL, 0x0000002420207230ULL, 0x000fe40000200000ULL,
0x0000002f2b2b7230ULL, 0x010fc40000200000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000200000ULL,
0x000000200c007388ULL, 0x0003e20000000c00ULL, 0x0000002d29297230ULL, 0x000fe40000200000ULL,
0x0000002c28287230ULL, 0x000fca0000200000ULL, 0x000400280c007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff4f00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000a0d00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000860000087ab9ULL, 0x000fe20000000800ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x0000000800077d06ULL, 0x000ea20008209000ULL,
0x00000008ff0b7c12ULL, 0x000fe2000f8e33ffULL, 0x0000850000097ab9ULL, 0x000fe20000000800ULL,
0x0000002002127836ULL, 0x000fe20000000000ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000702117812ULL, 0x000fc600078ec0ffULL, 0x0000000700077308ULL, 0x004ea40000001000ULL,
0x0ffffffe07087836ULL, 0x004fe20000000000ULL, 0x00000003ff077819ULL, 0x000fca0000011612ULL,
0x0000000800057305ULL, 0x000ea4000021f000ULL, 0x000000ffff037224ULL, 0x004fc800078e0a05ULL,
0x0000000803037c24ULL, 0x000fc8000f8e02ffULL, 0x0000000305107227ULL, 0x000fc800078e0004ULL,
0x0000000148037824ULL, 0x000fe400078e020dULL, 0x000000010d0d7824ULL, 0x000fe400078e0202ULL,
0x0000000310047227ULL, 0x000fc600078e00ffULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000ff04067210ULL, 0x000fe40007ffe1ffULL, 0x0ffffff80d0d7812ULL, 0x000fc600078ef802ULL,
0x0000000806057c24ULL, 0x000fe4000f8e0203ULL, 0x000000100d067824ULL, 0x000fc600078e021aULL,
0x0000000805007c0cULL, 0x000fe4000bf06070ULL, 0x00000000060c7984ULL, 0x002e760000000c00ULL,
0x8000000805050c36ULL, 0x000fc40008000000ULL, 0x0000000104040836ULL, 0x000fe20000000000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05070ULL, 0x0000000805007c0cULL, 0x000fda000bf26070ULL,
0x0000000104041836ULL, 0x000fca0000000000ULL, 0x000000040b047207ULL, 0x000fca0004000000ULL,
0x000000ffff087224ULL, 0x000fe400078e0a04ULL, 0x0000000904047c24ULL, 0x000fe4000f8e0249ULL,
0x0000000808037c24ULL, 0x000fc8000f8e0203ULL, 0x0000000804047c24ULL, 0x000fca000f8e0203ULL,
0x0000000409037210ULL, 0x000fc80007f3e0ffULL, 0x000000ffff087210ULL, 0x000fe40000ffe4ffULL,
0x0000000403047c11ULL, 0x000fc8000f8240ffULL, 0x0000000503057c11ULL, 0x000fe200088f4408ULL,
0x0000000800037824ULL, 0x000fe200078e0211ULL, 0x0000000a0700720cULL, 0x000fc60003f26070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000000c04007986ULL, 0x0023ea000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000148037824ULL, 0x100fe400078e0207ULL,
0x0000000112077824ULL, 0x000fe400078e0207ULL, 0x0000000310047227ULL, 0x002fc600078e00ffULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff067224ULL, 0x000fe400078e0a04ULL,
0x0000004002087836ULL, 0x000fe20000000000ULL, 0x0ffffff807077812ULL, 0x000fe200078ef812ULL,
0x0000000806057c24ULL, 0x000fc8000f8e0203ULL, 0x0000001007077824ULL, 0x000fe200078e021aULL,
0x0000000805007c0cULL, 0x000fc8000bf26070ULL, 0x00000000070c7984ULL, 0x0002a40000000c00ULL,
0x00000003ff077819ULL, 0x002fce0000011608ULL, 0x8000000805051c36ULL, 0x000fe20008000000ULL,
0x0000000104041810ULL, 0x000fc80007ffe0ffULL, 0x0000000805007c0cULL, 0x000fda000bf46070ULL,
0x0000000104042836ULL, 0x000fca0000000000ULL, 0x000000040b047207ULL, 0x000fca0004000000ULL,
0x000000ffff067224ULL, 0x000fe400078e0a04ULL, 0x0000000904047c24ULL, 0x000fe4000f8e0249ULL,
0x0000000806037c24ULL, 0x000fc8000f8e0203ULL, 0x0000000804047c24ULL, 0x000fe2000f8e0203ULL,
0x0000000712037812ULL, 0x000fc800078ec0ffULL, 0x0000000409057210ULL, 0x000fe20007f3e0ffULL,
0x0000000800037824ULL, 0x000fc800078e0203ULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x000fc8000f8240ffULL, 0x0000000505057c11ULL, 0x000fe400088f4406ULL,
0x0000000a0700720cULL, 0x000fe20003f26070ULL, 0x0000001003047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ee000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000748037210ULL, 0x000fe20007ffe0ffULL, 0x0000000108077824ULL, 0x000fc800078e0207ULL,
0x0000000310047227ULL, 0x002fe200078e00ffULL, 0x0000000707077812ULL, 0x000fc600078ec0ffULL,
0x000000ffff067224ULL, 0x000fe200078e0a04ULL, 0x0ffffff807077812ULL, 0x000fc600078ef808ULL,
0x0000000806057c24ULL, 0x000fe4000f8e0203ULL, 0x0000001007077824ULL, 0x000fc600078e021aULL,
0x0000000805007c0cULL, 0x000fe4000bf26070ULL, 0x00000000070c7984ULL, 0x0002b60000000c00ULL,
0x8000000805051c36ULL, 0x000fc40008000000ULL, 0x0000000104041836ULL, 0x000fc60000000000ULL,
0x0000000805007c0cULL, 0x000fda000bf46070ULL, 0x0000000104042836ULL, 0x000fca0000000000ULL,
0x000000040b047207ULL, 0x000fc80004000000ULL, 0x000000ff04067210ULL, 0x000fe20007ffe1ffULL,
0x0000000904047c24ULL, 0x000fc8000f8e0249ULL, 0x0000000806037c24ULL, 0x000fc8000f8e0203ULL,
0x0000000804047c24ULL, 0x000fe2000f8e0203ULL, 0x0000000708037812ULL, 0x000fc800078ec0ffULL,
0x0000000409057210ULL, 0x000fe20007f3e0ffULL, 0x0000000800037824ULL, 0x000fc800078e0203ULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc8000f8240ffULL,
0x0000000505057c11ULL, 0x000fe200088f4406ULL, 0x0000006002067836ULL, 0x000fe40000000000ULL,
0x0000001003027825ULL, 0x000fc600078e0004ULL, 0x00000003ff077819ULL, 0x002fc80000011606ULL,
0x0000000a0700720cULL, 0x000fe20003f26070ULL, 0x0000000c02007986ULL, 0x0043e2000c101d06ULL,
0x0000000148487824ULL, 0x000fd600078e0207ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000004810027227ULL, 0x002fe200078e00ffULL, 0x0000000706077210ULL, 0x000fe40007ffe0ffULL,
0x0000000706057812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200078e0a02ULL,
0x0000000707077812ULL, 0x000fc600078ec0ffULL, 0x0000000803037c24ULL, 0x000fe2000f8e0248ULL,
0xfffffff807077812ULL, 0x000fe200078ef806ULL, 0x0000000800057824ULL, 0x000fc600078e0205ULL,
0x0000000803007c0cULL, 0x000fe2000bf26070ULL, 0x0000001007077824ULL, 0x000fca00078e021aULL,
0x00000000070c7984ULL, 0x000e6e0000000c00ULL, 0x8000000803031c36ULL, 0x000fe40008000000ULL,
0x0000000102021836ULL, 0x000fc60000000000ULL, 0x0000000803007c0cULL, 0x000fda000bf46070ULL,
0x0000000102022836ULL, 0x000fca0000000000ULL, 0x000000020b027207ULL, 0x000fca0004000000ULL,
0x000000ffff037224ULL, 0x000fe400078e0a02ULL, 0x0000000902497c24ULL, 0x000fe4000f8e0249ULL,
0x0000000803487c24ULL, 0x000fc8000f8e0248ULL, 0x0000000849487c24ULL, 0x000fca000f8e0248ULL,
0x0000004809487210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0000000448027c11ULL, 0x000fc8000f8040ffULL, 0x0000000548037c11ULL, 0x000fc600080f4403ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000014a0a7836ULL, 0x000fe20000000000ULL,
0x0000000100107802ULL, 0x000fe20000000f00ULL, 0x0000000202047824ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000400f027824ULL, 0x000fe200078e00ffULL,
0x000000050a00720cULL, 0x000fe20003f06070ULL, 0x0000001f04047890ULL, 0x000fe2000fffe03fULL,
0x0000000e04497224ULL, 0x000fe200078e0249ULL, 0x0000940000057ab9ULL, 0x000fe20000000800ULL,
0x000001004a137824ULL, 0x000fe200078e0202ULL, 0x01b60010071079a7ULL, 0x0002a2000850003fULL,
0x000000053f047899ULL, 0x000fc40008011604ULL, 0x0000000549097c24ULL, 0x000fca000f8e0213ULL,
0x0000000c00248947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011608ULL,
0x0000900000087ab9ULL, 0x000fe20000000a00ULL, 0x00000013060a7248ULL, 0x000fe40007fe0000ULL,
0x0000000c0d197810ULL, 0x000fe20007ffe0ffULL, 0x000000040d157836ULL, 0x000fe40000000000ULL,
0x000000010a0a7824ULL, 0x000fe400078e0a13ULL, 0x0000000109147824ULL, 0x000fe200078e0215ULL,
0x0000000815047210ULL, 0x000fe20007ffe0ffULL, 0x0000000815297824ULL, 0x040fe200078e00ffULL,
0x0000000a1500720cULL, 0x080fe20003fa6070ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000a1900720cULL, 0x000fc40003f46070ULL, 0xfffffff829297812ULL, 0x000fe200078ee204ULL,
0x0000000109127824ULL, 0x040fe200078e020dULL, 0x0000007014147812ULL, 0x000fe200078ef80cULL,
0x000000080d177836ULL, 0x000fe40000000000ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000000814147c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001709167210ULL, 0x000fe20007ffe0ffULL,
0x000000100d1b7836ULL, 0x000fe20000000000ULL, 0x0000007012127812ULL, 0x000fe200078ef80cULL,
0x0000000109187824ULL, 0x000fe200078e0219ULL, 0x0000000915157c10ULL, 0x000fe20008ffe4ffULL,
0x00000001170e7824ULL, 0x140fe200078e0208ULL, 0x0000000812127c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000817337824ULL, 0x040fe200078e00ffULL, 0x0000000a1700720cULL, 0x080fe20003f26070ULL,
0x000000180d317836ULL, 0x000fe20000000000ULL, 0x0000000913137c10ULL, 0x000fe200087fe4ffULL,
0x0000000119047824ULL, 0x040fe200078e0208ULL, 0xfffffff833337812ULL, 0x000fe200078ee20eULL,
0x0000000819357824ULL, 0x000fe200078e00ffULL, 0x0000000a1b00720cULL, 0x000fe20003f06070ULL,
0x0000010016167825ULL, 0x000fc600078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee204ULL,
0x00000001091a7824ULL, 0x000fe200078e021bULL, 0x00000070161c7812ULL, 0x000fe200078ef80cULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000070f047211ULL, 0x000fe400078e70ffULL,
0x000000081c1c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000109227824ULL, 0x000fe200078e0231ULL,
0x00000070181e7812ULL, 0x000fe200078ef80cULL, 0x000000011b0e7824ULL, 0x040fe200078e0208ULL,
0x00000009171d7c10ULL, 0x000fe20009ffe4ffULL, 0x000000081b377824ULL, 0x000fe200078e00ffULL,
0x000000081e1e7c10ULL, 0x000fe2000ff9e0ffULL, 0x000001001a1a7825ULL, 0x000fc600078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee20eULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x000000701a167812ULL, 0x000fe400078ef80cULL, 0x00000009191f7c10ULL, 0x000fe2000a7fe4ffULL,
0x000000140d257836ULL, 0x000fe20000000000ULL, 0x00000070221a7812ULL, 0x000fe200078ef80cULL,
0x000000010d0e7824ULL, 0x000fe200078e0208ULL, 0x0000000816167c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000109207824ULL, 0x000fe200078e0225ULL, 0x000000081a1a7c10ULL, 0x000fe2000ff9e0ffULL,
0x0000001c0d3d7836ULL, 0x000fe20000000000ULL, 0x000000091b177c10ULL, 0x000fe20009ffe4ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x00000009231b7c10ULL, 0x000fc4000a7fe4ffULL,
0x000000070e237812ULL, 0x000fe200078ec0ffULL, 0x0000100004047836ULL, 0x000fe20000000000ULL,
0x0000007020187812ULL, 0x000fe200078ef80cULL, 0x000000200d2b7836ULL, 0x000fe20000000000ULL,
0x0000000a0d00720cULL, 0x000fe20003f86070ULL, 0x0000000109207824ULL, 0x000fe200078e023dULL,
0x0ffffff823237812ULL, 0x000fe200078ef808ULL, 0x00000001250e7824ULL, 0x040fe200078e0208ULL,
0x0000000818187c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000825397824ULL, 0x000fe200078e00ffULL,
0x0000002b09227210ULL, 0x000fe20007ffe0ffULL, 0x0000001023277824ULL, 0x000fe200078e0204ULL,
0x0000000921197c10ULL, 0x000fe20009ffe4ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fc400078ee20eULL, 0x0000000a2500720cULL, 0x080fe20003f66070ULL,
0x000000280d2f7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012277faeULL, 0x0007e2000e101c46ULL, 0x000000240d2d7836ULL, 0x000fe20000000000ULL,
0x0000007020207812ULL, 0x000fe200078ef80cULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000002f090e7210ULL, 0x000fe40007ffe0ffULL, 0x0000000820207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000109247824ULL, 0x000fe200078e022dULL, 0x0000007022227812ULL, 0x000fe200078ef80cULL,
0x0000000131267824ULL, 0x040fe200078e0208ULL, 0x0000000a3100720cULL, 0x000fe20003f86070ULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x0000000921217c10ULL, 0x000fc4000b7fe4ffULL,
0x0000000822227c10ULL, 0x000fe2000ffde0ffULL, 0x0000001029277824ULL, 0x108fe200078e0204ULL,
0x0000007024247812ULL, 0x000fe200078ef80cULL, 0x0000001033297824ULL, 0x000fe200078e0204ULL,
0x0000000923237c10ULL, 0x000fe2000b7fe4ffULL, 0x000001000e127825ULL, 0x000fe200078e00ffULL,
0x0000000014277faeULL, 0x0007e2000e901c46ULL, 0x0000000a3d00720cULL, 0x080fe40003fa6070ULL,
0x00000008313b7824ULL, 0x000fe200078e00ffULL, 0x000000001c297faeULL, 0x0009e2000c901c46ULL,
0x000000013d0e7824ULL, 0x100fe200078e0208ULL, 0x0000000a2b00720cULL, 0x000fe20003f26070ULL,
0x000000083d3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee226ULL,
0x0000002c0d317836ULL, 0x000fe20000000000ULL, 0x0000000824247c10ULL, 0x000fe2000ffde0ffULL,
0x000000300d337836ULL, 0x000fe20000000000ULL, 0x0000000435277211ULL, 0x008fe200078e20ffULL,
0x0000000109147824ULL, 0x000fe200078e0231ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee20eULL,
0x000000012b0e7824ULL, 0x000fe200078e0208ULL, 0x0000007012127812ULL, 0x000fe200078ef80cULL,
0x00000010371d7824ULL, 0x010fe200078e0204ULL, 0x000000001e277faeULL, 0x0007e2000d101c46ULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000a2d00720cULL, 0x040fe20003f46070ULL,
0x000000012d267824ULL, 0x000fe200078e0208ULL, 0x00000000161d7faeULL, 0x0009e2000c101c46ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000000925257c10ULL, 0x000fc4000b7fe4ffULL,
0x0000000812127c10ULL, 0x000fe2000ffde0ffULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20eULL, 0x000000340d357836ULL, 0x000fe20000000000ULL,
0x000000043b277211ULL, 0x008fe200078e20ffULL, 0x00000010391f7824ULL, 0x100fe200078e0204ULL,
0x0000007014147812ULL, 0x000fe200078ef80cULL, 0x000000103d297824ULL, 0x100fe200078e0204ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee226ULL, 0x0000000109167824ULL, 0x010fe200078e0233ULL,
0x0000000913137c10ULL, 0x000fe2000b7fe4ffULL, 0x00000000181f7faeULL, 0x0007e2000d901c46ULL,
0x0000000814147c10ULL, 0x000fe2000ffde0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000380d377810ULL, 0x000fe20007ffe0ffULL, 0x000000001a277faeULL, 0x0009e2000e101c46ULL,
0x0000000915157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0204ULL,
0x0000000a3100720cULL, 0x080fe20003f86070ULL, 0x000000102d2d7824ULL, 0x000fe200078e0204ULL,
0x0000000020297faeULL, 0x000fe2000e901c46ULL, 0x0000003c0d397836ULL, 0x000fe20000000000ULL,
0x0000000a2f00720cULL, 0x080fe20003fa6070ULL, 0x0000000109187824ULL, 0x008fe200078e0235ULL,
0x00000000222b7faeULL, 0x0007e2000c901c46ULL, 0x000000012f0d7824ULL, 0x000fe200078e0208ULL,
0x0000000a3300720cULL, 0x080fe20003f66070ULL, 0x000000082f0e7824ULL, 0x000fe200078e00ffULL,
0x00000070161a7812ULL, 0x010fe200078ef80cULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x00000000242d7faeULL, 0x0009e2000d101c46ULL, 0x0000000a3500720cULL, 0x000fc40003f46070ULL,
0x000000081a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000109167824ULL, 0x000fe200078e0237ULL,
0x0000000a3700720cULL, 0x080fe20003f26070ULL, 0x00000008311d7824ULL, 0x000fe200078e00ffULL,
0x0000000a3900720cULL, 0x000fe20003f06070ULL, 0x00000001310a7824ULL, 0x000fe200078e0208ULL,
0xfffffff80e0d7812ULL, 0x000fe200078ee20dULL, 0x00000008331f7824ULL, 0x000fe200078e00ffULL,
0x00000009171b7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x00000008330e7210ULL, 0x000fc40007ffe0ffULL, 0x0000007018187812ULL, 0x000fe200078ef80cULL,
0x0000000109097824ULL, 0x000fe200078e0239ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20aULL,
0x00000001350a7824ULL, 0x100fe200078e0208ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20eULL,
0x00000001370e7824ULL, 0x100fe200078e0208ULL, 0x0000000818187c10ULL, 0x000fe2000ffde0ffULL,
0x00000001391c7824ULL, 0x000fe200078e0208ULL, 0x0000007016167812ULL, 0x000fe200078ef80cULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x0000000919197c10ULL, 0x000fc4000b7fe4ffULL,
0x0000000337237819ULL, 0x008fe200000006ffULL, 0x0000000835217824ULL, 0x002fe200078e00ffULL,
0x0000000816167c10ULL, 0x000fe2000ffde0ffULL, 0x0000000839257824ULL, 0x010fe200078e00ffULL,
0x0000007008087812ULL, 0x000fe200078ef80cULL, 0x000000100d0d7824ULL, 0x100fe200078e0204ULL,
0xfffffff821217812ULL, 0x000fe200078ee20aULL, 0x000000101d1d7824ULL, 0x100fe200078e0204ULL,
0xfffffff823237812ULL, 0x000fe200078ee20eULL, 0x000000101f1f7824ULL, 0x100fe200078e0204ULL,
0xfffffff825257812ULL, 0x000fe200078ee21cULL, 0x0000001021217824ULL, 0x100fe200078e0204ULL,
0x0000000917177c10ULL, 0x000fe2000b7fe4ffULL, 0x00000000120d7faeULL, 0x0003e2000e901c46ULL,
0x0000000808087c10ULL, 0x000fe2000ffde0ffULL, 0x0000001025257824ULL, 0x000fe200078e0204ULL,
0x0000000423237211ULL, 0x000fe200078e20ffULL, 0x00000000141d7faeULL, 0x0003e2000e101c46ULL,
0x0000000909097c10ULL, 0x000fc6000b7fe4ffULL, 0x000000001a1f7faeULL, 0x0003e8000d901c46ULL,
0x0000000018217faeULL, 0x0003e8000d101c46ULL, 0x0000000016237faeULL, 0x0003e8000c901c46ULL,
0x0000000008257faeULL, 0x0003e2000c101c46ULL, 0x0000000800d47947ULL, 0x000fea0003800000ULL,
0x00000010081e7811ULL, 0x040fe200078fe8ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x0000001408207811ULL, 0x040fe400078fe8ffULL, 0x0000000408187811ULL, 0x000fe200078fe8ffULL,
0x000000011e0d7824ULL, 0x100fe200078e0208ULL, 0x0000000c081c7811ULL, 0x000fe200078fe8ffULL,
0x000000081e127824ULL, 0x000fe200078e00ffULL, 0x00000008081a7811ULL, 0x000fe200078fe8ffULL,
0x00000001200e7824ULL, 0x100fe200078e0208ULL, 0x000000031c297819ULL, 0x000fe200000006ffULL,
0x0000000820257824ULL, 0x000fe200078e00ffULL, 0xfffffff812277812ULL, 0x000fe200078ee20dULL,
0x0000000118047824ULL, 0x100fe200078e0208ULL, 0x00000024080d7811ULL, 0x000fe200078fe8ffULL,
0x00000008182d7824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee20eULL,
0x000000011c0a7824ULL, 0x100fe200078e0208ULL, 0x0000001c08247811ULL, 0x040fe200078fe8ffULL,
0x000000010d0e7824ULL, 0x140fe200078e0208ULL, 0x0000001808227811ULL, 0x000fe200078fe8ffULL,
0x000000080d157824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee204ULL,
0x000000011a047824ULL, 0x140fe200078e0208ULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x000000081a2b7824ULL, 0x000fe200078e00ffULL, 0x00000020080a7811ULL, 0x000fe200078fe8ffULL,
0x0000000824147824ULL, 0x000fe200078e00ffULL, 0x0000000824137210ULL, 0x000fe20007ffe0ffULL,
0x0000000122127824ULL, 0x140fe200078e0208ULL, 0xfffffff8150e7812ULL, 0x000fe200078ee20eULL,
0x0000000822237824ULL, 0x000fe200078e00ffULL, 0x0000002c08157811ULL, 0x000fe200078fe8ffULL,
0x000000080a317824ULL, 0x040fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL,
0x000000010a047824ULL, 0x100fe200078e0208ULL, 0x00000030082a7811ULL, 0x040fe200078fe8ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0xfffffff814337812ULL, 0x000fe200078ee213ULL,
0x0000000109327824ULL, 0x000fe200078e020dULL, 0x0000003408267811ULL, 0x000fe200078fe8ffULL,
0x000000012a147824ULL, 0x100fe200078e0208ULL, 0xfffffff823237812ULL, 0x000fe200078ee212ULL,
0x0000000115127824ULL, 0x100fe200078e0208ULL, 0x0000002808137811ULL, 0x000fe200078fe8ffULL,
0x000000082a1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee204ULL,
0x0000000126167824ULL, 0x140fe200078e0208ULL, 0x0000000313177819ULL, 0x040fe200000006ffULL,
0x00000008261d7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee212ULL,
0x0000000113047824ULL, 0x000fe200078e0208ULL, 0x0000000808127211ULL, 0x000fe200078fe8ffULL,
0x0000000109347824ULL, 0x040fe200078e0213ULL, 0xfffffff81b287812ULL, 0x000fe200078ee214ULL,
0x000000011a147824ULL, 0x100fe200078e0209ULL, 0xfffffff81d1b7812ULL, 0x000fe200078ee216ULL,
0x000000011c167824ULL, 0x100fe200078e0209ULL, 0xfffffff817177812ULL, 0x000fe200078ee204ULL,
0x00000001201a7824ULL, 0x100fe200078e0209ULL, 0x00000038081d7811ULL, 0x000fe200078fe8ffULL,
0x00000001221c7824ULL, 0x000fe200078e0209ULL, 0x0000003c081f7811ULL, 0x040fe200078fe8ffULL,
0x0000000109367824ULL, 0x040fe200078e0215ULL, 0x0000000908047211ULL, 0x000fe200078fe8ffULL,
0x00000001092a7824ULL, 0x040fe200078e022aULL, 0x0000000712217812ULL, 0x000fe200078ec0ffULL,
0x0000000109267824ULL, 0x040fe200078e0226ULL, 0x0000000918127210ULL, 0x000fe20007ffe0ffULL,
0x000000011e187824ULL, 0x100fe200078e0209ULL, 0x0000000a09207210ULL, 0x000fe20007ffe0ffULL,
0x00000001241e7824ULL, 0x000fe200078e0209ULL, 0x000000081d0a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000109247824ULL, 0x040fe200078e021dULL, 0x0ffffff821217812ULL, 0x000fe200078ef808ULL,
0x0000000109227824ULL, 0x000fc400078e021fULL, 0x000000011f0d7824ULL, 0x040fe400078e0208ULL,
0x000000081f2c7824ULL, 0x000fe400078e00ffULL, 0x0000010004087825ULL, 0x000fc600078e00ffULL,
0xfffffff82c1f7812ULL, 0x000fe200078ee20dULL, 0x000040000f047824ULL, 0x000fe200078e0207ULL,
0x0000007008087812ULL, 0x000fe200078ef80cULL, 0x000000081d1d7824ULL, 0x000fe400078e00ffULL,
0x00001000042c7836ULL, 0x000fe20000000000ULL, 0x0000000808087c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee20aULL,
0x0000000909097c10ULL, 0x000fe200087fe4ffULL, 0x00000010170a7824ULL, 0x000fe200078e022cULL,
0x0000007014147812ULL, 0x000fe200078ef80cULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000002c1d437211ULL, 0x000fc400078e20ffULL, 0x0000000814147c10ULL, 0x000fe2000ff1e0ffULL,
0x000000101b417824ULL, 0x100fe200078e022cULL, 0x0000007016167812ULL, 0x000fe200078ef80cULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000915157c10ULL, 0x000fe400087fe4ffULL,
0x0000000816167c10ULL, 0x000fe2000ff1e0ffULL, 0x000000101f457824ULL, 0x000fe200078e022cULL,
0x000000701a1a7812ULL, 0x000fe200078ef80cULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0x0000000917177c10ULL, 0x000fc400087fe4ffULL, 0x0000002c330d7211ULL, 0x000fe200078e20ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x000000081a1a7c10ULL, 0x000fe4000ff1e0ffULL,
0x000000701e1e7812ULL, 0x000fe200078ef80cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000701c1c7812ULL, 0x000fe400078ef80cULL, 0x000000091b1b7c10ULL, 0x000fe200087fe4ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x000000081e1e7c10ULL, 0x000fc4000ff1e0ffULL,
0x0000007012127812ULL, 0x000fe200078ef80cULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0x000000081c1c7c10ULL, 0x000fe4000ff5e0ffULL, 0x00000070323c7812ULL, 0x000fe200078ef80cULL,
0x000000100e047824ULL, 0x100fe200078e022cULL, 0x00000070343e7812ULL, 0x000fe200078ef80cULL,
0x00000010190e7824ULL, 0x000fe200078e022cULL, 0x000000091f1f7c10ULL, 0x000fe200087fe4ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000002c212f7211ULL, 0x000fc400078e20ffULL,
0x0000000812127c10ULL, 0x000fe2000ff3e0ffULL, 0x0000010036367825ULL, 0x000fe200078e00ffULL,
0x000000091d1d7c10ULL, 0x000fe200097fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082f7faeULL, 0x0007e2000b901c46ULL, 0x000000083c3c7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000007018187812ULL, 0x000fe400078ef80cULL,
0x000000083e3e7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e022cULL,
0x0000000913137c10ULL, 0x000fe20008ffe4ffULL, 0x0000010024387825ULL, 0x000fe200078e00ffULL,
0x00000009333d7c10ULL, 0x000fc400087fe4ffULL, 0x0000000818187c10ULL, 0x000fe2000ff3e0ffULL,
0x000001002a327825ULL, 0x000fe200078e00ffULL, 0x0000007036367812ULL, 0x000fe200078ef80cULL,
0x00000000122d7faeULL, 0x0007e2000b901c46ULL, 0x00000009353f7c10ULL, 0x000fe200097fe4ffULL,
0x0000010026347825ULL, 0x000fe200078e00ffULL, 0x0000007020207812ULL, 0x000fe400078ef80cULL,
0x0000000919197c10ULL, 0x000fe20008ffe4ffULL, 0x000000102b2b7824ULL, 0x000fe200078e022cULL,
0x0000000836367c10ULL, 0x000fe2000ff1e0ffULL, 0x00000100223a7825ULL, 0x000fe200078e00ffULL,
0x0000000820207c10ULL, 0x000fc4000ff3e0ffULL, 0x0000007032327812ULL, 0x000fe200078ef80cULL,
0x0000001029297824ULL, 0x100fe200078e022cULL, 0x0000007034347812ULL, 0x000fe200078ef80cULL,
0x0000001027277824ULL, 0x100fe200078e022cULL, 0x0000007038387812ULL, 0x000fe200078ef80cULL,
0x0000001025257824ULL, 0x100fe200078e022cULL, 0x0000000937377c10ULL, 0x000fe200087fe4ffULL,
0x0000001023237824ULL, 0x100fe200078e022cULL, 0x000000703a0c7812ULL, 0x000fe200078ef80cULL,
0x00000000142b7faeULL, 0x0007e2000b901c46ULL, 0x0000001031317824ULL, 0x100fe200078e022cULL,
0x0000000921217c10ULL, 0x000fe20008ffe4ffULL, 0x0000001028287824ULL, 0x000fe200078e022cULL,
0x0000000832327c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000016297faeULL, 0x0007e2000b901c46ULL,
0x0000000834347c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000838387c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000018277faeULL, 0x0007e2000b901c46ULL, 0x000000080c3a7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000933337c10ULL, 0x000fe200087fe4ffULL, 0x000000001a257faeULL, 0x0007e2000b901c46ULL,
0x0000000935357c10ULL, 0x000fe40008ffe4ffULL, 0x0000000939397c10ULL, 0x000fe200097fe4ffULL,
0x000000001c237faeULL, 0x0007e2000b901c46ULL, 0x000000093b3b7c10ULL, 0x000fc60009ffe4ffULL,
0x000000001e0d7faeULL, 0x0007e8000b901c46ULL, 0x0000000020317faeULL, 0x0007e8000b901c46ULL,
0x000000003c047faeULL, 0x0007e8000b901c46ULL, 0x000000003e0a7faeULL, 0x0007e8000b901c46ULL,
0x00000000360e7faeULL, 0x0007e8000b901c46ULL, 0x0000000032287faeULL, 0x0007e8000b901c46ULL,
0x0000000034417faeULL, 0x0007e8000b901c46ULL, 0x0000000038437faeULL, 0x0007e8000b901c46ULL,
0x000000003a457faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x00afe20000015200ULL, 0x01b60011070075a7ULL, 0x004e62000800017fULL,
0x00000001060d7824ULL, 0x000fe400078e0a00ULL, 0x0000000403037c24ULL, 0x000fc6000f8e02ffULL,
0x00000008ff0d7819ULL, 0x000fe2000001160dULL, 0x00008e00ff747b82ULL, 0x000ee40000000a00ULL,
0x0000000403747825ULL, 0x008fe200078e0074ULL, 0x00000000005c0947ULL, 0x006fec0003800000ULL,
0x000000ffff0a7224ULL, 0x000fce00078e00ffULL, 0x000000100a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001208047210ULL, 0x000fca0007f1e1ffULL, 0x0000000113127824ULL, 0x000fe200000e0e09ULL,
0x003d09000400780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400400780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011412ULL, 0x0000000403037211ULL, 0x000fca00078110ffULL,
0x000000ffff047224ULL, 0x000fca00000e0612ULL, 0x0000000203037819ULL, 0x000fc80000001204ULL,
0x000000030000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010a0a7836ULL, 0x000fce0000000000ULL, 0x01b60011070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000054a00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0x000000070f4b7211ULL, 0x040fe200078e18ffULL, 0xffffffff000c7836ULL, 0x000fe20000000000ULL,
0x0000000104057899ULL, 0x000fe2000800063fULL, 0x00000009000a7836ULL, 0x000fe40000000000ULL,
0x000000200f0e7824ULL, 0x000fd200078e0207ULL, 0x000000014a047836ULL, 0x000fe20000000000ULL,
0x0000940000047ab9ULL, 0x000fe20000000800ULL, 0x000001004a097824ULL, 0x004fc600078e0202ULL,
0x000000050400720cULL, 0x000fe20003f06070ULL, 0x0000000449137c24ULL, 0x000fd8000f8e0209ULL,
0x0000000800f48947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x102fe20000011608ULL,
0x0000001008717824ULL, 0x000fe200078e00ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000000804187810ULL, 0x000fe20007ffe0ffULL,
0x0000000404167836ULL, 0x000fe20000000000ULL, 0x0000000c041a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010041c7836ULL, 0x000fe20000000000ULL, 0x0000007071717812ULL, 0x000fe200078ec0ffULL,
0x0000000116037824ULL, 0x100fe200078e0208ULL, 0x0ffffff808707812ULL, 0x000fe200078ec0ffULL,
0x0000000816127824ULL, 0x000fe200078e00ffULL, 0x0000001804227810ULL, 0x000fe20007ffe0ffULL,
0x0000000118107824ULL, 0x140fe200078e0208ULL, 0x0000001c04267810ULL, 0x000fe20007ffe0ffULL,
0x00000008182b7824ULL, 0x000fe200078e00ffULL, 0xfffffff812297812ULL, 0x000fe200078ee203ULL,
0x000000011a037824ULL, 0x140fe200078e0208ULL, 0x0000000906127248ULL, 0x000fe20007fe0000ULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL,
0x000000011c177824ULL, 0x040fe200078e0208ULL, 0x0000008071107812ULL, 0x000fe200078efcffULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0xfffffff81e2d7812ULL, 0x000fe200078ee203ULL,
0x0000000118197824ULL, 0x100fe200078e0213ULL, 0x0000001209037210ULL, 0x000fe20007ffe1ffULL,
0x0000000104157824ULL, 0x100fe200078e0213ULL, 0xfffffff8202f7812ULL, 0x000fe200078ee217ULL,
0x0000000116177824ULL, 0x040fe200078e0213ULL, 0x000000031600720cULL, 0x080fe20003f86070ULL,
0x0000001404127836ULL, 0x000fe20000000000ULL, 0x000000031800720cULL, 0x080fe20003f26070ULL,
0x0000010017167825ULL, 0x000fe200078e0010ULL, 0x000000031a00720cULL, 0x000fc40003f46070ULL,
0x0000000322337819ULL, 0x000fe200000006ffULL, 0x0000010019187825ULL, 0x000fe200078e0010ULL,
0x0000000816247c10ULL, 0x000fc6000ff7e0ffULL, 0x0000010015147825ULL, 0x000fe200078e0010ULL,
0x0000000917257c10ULL, 0x000fc60009ffe4ffULL, 0x000000011c217824ULL, 0x100fe200078e0213ULL,
0x0000000814147c10ULL, 0x000fe2000ff1e0ffULL, 0x000000011a1d7824ULL, 0x100fe200078e0213ULL,
0x00000008181a7c10ULL, 0x000fe2000ffbe0ffULL, 0x00000001121b7824ULL, 0x000fe200078e0213ULL,
0x0000000915157c10ULL, 0x000fe200087fe4ffULL, 0x0000010021207825ULL, 0x000fe200078e0010ULL,
0x000000031c00720cULL, 0x000fc60003f06070ULL, 0x000001001b167825ULL, 0x100fe200078e0010ULL,
0x00000009191b7c10ULL, 0x000fe4000affe4ffULL, 0x0000000820187c10ULL, 0x000fe2000ffbe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0010ULL, 0x0000000816167c10ULL, 0x000fe4000ffde0ffULL,
0x0000000921197c10ULL, 0x000fe2000affe4ffULL, 0x0000000104217824ULL, 0x140fe200078e0208ULL,
0x000000081c1e7c10ULL, 0x000fe2000ff7e0ffULL, 0x000040000f6f7824ULL, 0x000fe200078e0207ULL,
0x000000030400720cULL, 0x080fe20003fa6070ULL, 0x0000000112207824ULL, 0x000fe200078e0208ULL,
0x0000000770217812ULL, 0x000fe200078ef821ULL, 0x000030006f5c7836ULL, 0x000fe20000000000ULL,
0x000000091d1f7c10ULL, 0x000fe20009ffe4ffULL, 0x00000001221d7824ULL, 0x000fe200078e0213ULL,
0x000000031200720cULL, 0x040fe20003f66070ULL, 0x0000000812317824ULL, 0x000fe200078e00ffULL,
0x0000000917177c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001021277824ULL, 0x000fc400078e025cULL,
0x000001001d1c7825ULL, 0x000fe200078e0010ULL, 0xfffffff831317812ULL, 0x000fe400078ee220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014277faeULL, 0x0003e2000e901c46ULL,
0x0000001029297824ULL, 0x000fe200078e025cULL, 0x000000081c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000126217824ULL, 0x000fe200078e0213ULL, 0x000000032200720cULL, 0x0c0fe20003fa6070ULL,
0x00000020042a7836ULL, 0x000fe20000000000ULL, 0x0000000024297faeULL, 0x0005e2000e101c46ULL,
0x0000000122127824ULL, 0x000fe200078e0208ULL, 0x000000091d1d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010021207825ULL, 0x000fe200078e0010ULL, 0x000000032600720cULL, 0x000fc60003f86070ULL,
0x0000000126287824ULL, 0x040fe200078e0208ULL, 0x0000000820207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000826157824ULL, 0x002fe400078e00ffULL, 0x000000012a237824ULL, 0x000fe200078e0213ULL,
0xfffffff833297812ULL, 0x004fe200078ee212ULL, 0x0000002404247836ULL, 0x000fe20000000000ULL,
0xfffffff815337812ULL, 0x000fe200078ee228ULL, 0x000000102b257824ULL, 0x000fe200078e025cULL,
0x0000000921217c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010023227825ULL, 0x000fe200078e0010ULL,
0x000000082a127210ULL, 0x000fc40007ffe0ffULL, 0x000000001a257faeULL, 0x0003e2000c901c46ULL,
0x000000102d277824ULL, 0x000fe200078e025cULL, 0x0000000822227c10ULL, 0x000fe2000ffde0ffULL,
0x0000000124157824ULL, 0x000fe200078e0213ULL, 0x000000032a00720cULL, 0x0c0fe20003f26070ULL,
0x000000082a2b7824ULL, 0x000fe200078e00ffULL, 0x000000001e277faeULL, 0x0005e2000d101c46ULL,
0x0000000124267824ULL, 0x040fe200078e0208ULL, 0x000000032400720cULL, 0x040fe20003f46070ULL,
0x00000008242d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee212ULL,
0x0000010015147825ULL, 0x000fe200078e0010ULL, 0x0000000923237c10ULL, 0x000fc4000b7fe4ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee226ULL, 0x000000102f1b7824ULL, 0x102fe200078e025cULL,
0x0000000814147c10ULL, 0x000fe2000ffde0ffULL, 0x0000001029257824ULL, 0x100fe200078e025cULL,
0x0000005c33277211ULL, 0x004fe200078e20ffULL, 0x00000010311f7824ULL, 0x100fe200078e025cULL,
0x0000000915157c10ULL, 0x000fe2000b7fe4ffULL, 0x0000002804127836ULL, 0x000fe20000000000ULL,
0x00000000181b7faeULL, 0x0003e2000c101c46ULL, 0x000000102b297824ULL, 0x100fe200078e025cULL,
0x0000003804287810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2b7824ULL, 0x000fe200078e025cULL,
0x00000000161f7faeULL, 0x0005e2000d901c46ULL, 0x0000002c041e7836ULL, 0x000fc40000000000ULL,
0x0000003004247836ULL, 0x000fe20000000000ULL, 0x000000001c257faeULL, 0x000fe2000e901c46ULL,
0x0000003404267836ULL, 0x000fe20000000000ULL, 0x000000031200720cULL, 0x080fe20003fa6070ULL,
0x0000003c042a7836ULL, 0x000fe20000000000ULL, 0x0000000020277faeULL, 0x0007e2000e101c46ULL,
0x0000000124197824ULL, 0x102fe200078e0213ULL, 0x000000031e00720cULL, 0x080fe20003f86070ULL,
0x0000000112047824ULL, 0x040fe200078e0208ULL, 0x0000000022297faeULL, 0x0003e2000c901c46ULL,
0x0000000112177824ULL, 0x004fe200078e0213ULL, 0x000000032400720cULL, 0x080fe20003f66070ULL,
0x0000010019187825ULL, 0x000fe200078e0010ULL, 0x00000000142b7faeULL, 0x0005e2000d101c46ULL,
0x000000032600720cULL, 0x000fc40003f46070ULL, 0x000000032800720cULL, 0x080fe20003f26070ULL,
0x0000000812217824ULL, 0x008fe200078e00ffULL, 0x000000032a00720cULL, 0x000fe20003f06070ULL,
0x0000000126037824ULL, 0x140fe200078e0213ULL, 0x0000000326277819ULL, 0x000fe200000006ffULL,
0x000000081e237824ULL, 0x002fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x00000001281f7824ULL, 0x000fe200078e0213ULL, 0x000000081e047210ULL, 0x000fe20007ffe0ffULL,
0x0000010017147825ULL, 0x004fc600078e0010ULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x000000011e177824ULL, 0x000fe200078e0213ULL, 0x0000000814147c10ULL, 0x000fe2000ffde0ffULL,
0x0000000124047824ULL, 0x000fe400078e0208ULL, 0x0000010017167825ULL, 0x000fe200078e0010ULL,
0x0000000915157c10ULL, 0x000fc6000b7fe4ffULL, 0x0000000824257824ULL, 0x000fe200078e00ffULL,
0x00000008161a7c10ULL, 0x000fe2000ffde0ffULL, 0x00000001261e7824ULL, 0x000fe400078e0208ULL,
0x000000082a297824ULL, 0x000fe200078e00ffULL, 0x00000009171b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010003167825ULL, 0x000fe200078e0010ULL, 0x00000008181c7c10ULL, 0x000fc6000ffde0ffULL,
0x000000012a037824ULL, 0x000fe200078e0213ULL, 0x00000009191d7c10ULL, 0x000fe2000b7fe4ffULL,
0x000001001f187825ULL, 0x100fe200078e0010ULL, 0x0000000816127c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff8251f7812ULL, 0x000fe200078ee204ULL, 0x0000010003107825ULL, 0x000fe200078e0010ULL,
0x0000000917137c10ULL, 0x000fe4000b7fe4ffULL, 0x0000000818167c10ULL, 0x000fe2000ffde0ffULL,
0x0000000128037824ULL, 0x140fe200078e0208ULL, 0xfffffff827257812ULL, 0x000fe200078ee21eULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000000919177c10ULL, 0x000fe2000b7fe4ffULL,
0x000000012a047824ULL, 0x000fe200078e0208ULL, 0x0000000810107c10ULL, 0x000fe2000ffde0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e025cULL, 0xfffffff828277812ULL, 0x000fe200078ee203ULL,
0x0000001021037824ULL, 0x100fe200078e025cULL, 0xfffffff829297812ULL, 0x000fe200078ee204ULL,
0x0000001025217824ULL, 0x100fe200078e025cULL, 0x0000005c23197211ULL, 0x000fe200078e20ffULL,
0x0000001027237824ULL, 0x100fe200078e025cULL, 0x0000000911117c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000014037faeULL, 0x0003e2000e901c46ULL, 0x0000001029257824ULL, 0x000fc600078e025cULL,
0x000000001a197faeULL, 0x0003e8000e101c46ULL, 0x000000001c1f7faeULL, 0x0003e8000d901c46ULL,
0x0000000012217faeULL, 0x0003e8000d101c46ULL, 0x0000000016237faeULL, 0x0003e8000c901c46ULL,
0x0000000010257faeULL, 0x0003e2000c101c46ULL, 0x0000000800a47947ULL, 0x000fea0003800000ULL,
0x0000000c081f7811ULL, 0x042fe200078fe8ffULL, 0x0000001008717824ULL, 0x040fe200078e00ffULL,
0x0000000408157811ULL, 0x040fe200078fe8ffULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x0000001808277811ULL, 0x040fe200078fe8ffULL, 0x000000011f477824ULL, 0x140fe200078e0208ULL,
0x00000008081b7811ULL, 0x040fe200078fe8ffULL, 0x000000081f107824ULL, 0x000fe200078e00ffULL,
0x00000024082d7811ULL, 0x040fe200078fe8ffULL, 0x00000001154f7824ULL, 0x140fe200078e0208ULL,
0x0000001408257811ULL, 0x040fe200078fe8ffULL, 0x0000000815047824ULL, 0x000fe200078e00ffULL,
0xfffffff810477812ULL, 0x000fe200078ee247ULL, 0x0000000127417824ULL, 0x140fe200078e0208ULL,
0x000000081b4d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000827107824ULL, 0x000fe200078e00ffULL,
0xfffffff8044f7812ULL, 0x000fe200078ee24fULL, 0x000000081b047824ULL, 0x000fe200078e00ffULL,
0x0000001008217811ULL, 0x040fe200078fe8ffULL, 0x0000000125437824ULL, 0x100fe200078e0208ULL,
0xfffffff810417812ULL, 0x000fe200078ee241ULL, 0x000000082d107824ULL, 0x000fe200078e00ffULL,
0x00000030081d7811ULL, 0x040fe200078fe8ffULL, 0x0000000121457824ULL, 0x140fe200078e0208ULL,
0x000000082d3b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000821127824ULL, 0x000fe200078e00ffULL,
0xfffffff8044d7812ULL, 0x000fe200078ee24dULL, 0x000000011d317824ULL, 0x100fe200078e0208ULL,
0x0000000325047819ULL, 0x000fe200000006ffULL, 0x0000000115157824ULL, 0x100fe200078e0213ULL,
0x00000020082b7811ULL, 0x040fe200078fe8ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0213ULL,
0xfffffff8103b7812ULL, 0x000fe200078ee23bULL, 0x000000011b1b7824ULL, 0x100fe200078e0213ULL,
0x0000001c08297811ULL, 0x040fe200078fe8ffULL, 0x000000012b3d7824ULL, 0x100fe200078e0208ULL,
0x000000031d107819ULL, 0x000fe200000006ffULL, 0x0000900000087ab9ULL, 0x000fe20000000a00ULL,
0xfffffff804437812ULL, 0x000fe200078ee243ULL, 0x000000082b047824ULL, 0x000fe200078e00ffULL,
0x0000002c08237811ULL, 0x040fe200078fe8ffULL, 0x00000001293f7824ULL, 0x140fe200078e0208ULL,
0xfffffff812457812ULL, 0x000fe200078ee245ULL, 0x0000000829127824ULL, 0x000fe200078e00ffULL,
0xfffffff810317812ULL, 0x000fe200078ee231ULL, 0x0000000123337824ULL, 0x100fe200078e0208ULL,
0x0000003c08107811ULL, 0x040fe200078fe8ffULL, 0x0000000125257824ULL, 0x100fe200078e0213ULL,
0x00000028082f7811ULL, 0x000fe200078fe8ffULL, 0x0000000127277824ULL, 0x100fe200078e0213ULL,
0xfffffff8043d7812ULL, 0x000fe200078ee23dULL, 0x0000000823047824ULL, 0x000fe200078e00ffULL,
0x0000007071717812ULL, 0x000fe200078ec0ffULL, 0x0000000110537824ULL, 0x100fe200078e0213ULL,
0xfffffff8123f7812ULL, 0x000fe200078ee23fULL, 0x000000012f357824ULL, 0x140fe200078e0208ULL,
0x0000000810377210ULL, 0x000fe20007ffe0ffULL, 0x000000082f127824ULL, 0x000fe200078e00ffULL,
0x0000003408197811ULL, 0x000fe200078fe8ffULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x0000008071167812ULL, 0x000fe200078efcffULL, 0x0000000129297824ULL, 0x000fe200078e0213ULL,
0x0000001308117211ULL, 0x040fe200078fe8ffULL, 0x0000000119037824ULL, 0x000fe200078e0208ULL,
0xfffffff804337812ULL, 0x000fe200078ee233ULL, 0x0000010015147825ULL, 0x000fe200078e0016ULL,
0x0000003808047811ULL, 0x000fc400078fe8ffULL, 0xfffffff812357812ULL, 0x000fe200078ee235ULL,
0x0000000819127824ULL, 0x000fe200078e00ffULL, 0xfffffff810377812ULL, 0x000fe200078ee237ULL,
0x0000010011107825ULL, 0x000fe200078e0016ULL, 0x0000001321217210ULL, 0x000fe40007ffe0ffULL,
0xfffffff812037812ULL, 0x000fe200078ee203ULL, 0x0000000104517824ULL, 0x100fe200078e0213ULL,
0x0000001323237210ULL, 0x000fe20007ffe0ffULL, 0x000000012b2b7824ULL, 0x100fe200078e0213ULL,
0x0000000810107c10ULL, 0x000fe2000ff1e0ffULL, 0x000000012d2d7824ULL, 0x100fe200078e0213ULL,
0x0000000814147c10ULL, 0x000fe2000ff3e0ffULL, 0x000000012f2f7824ULL, 0x100fe200078e0213ULL,
0x0ffffff808707812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x100fe200078e0213ULL,
0x0000000911117c10ULL, 0x000fe200087fe4ffULL, 0x0000000119197824ULL, 0x000fe200078e0213ULL,
0x0000000915157c10ULL, 0x000fe20008ffe4ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0016ULL,
0x000001001b1a7825ULL, 0x000fe200078e0016ULL, 0x000000081e1e7c10ULL, 0x000fc6000ff1e0ffULL,
0x0000010021207825ULL, 0x100fe200078e0016ULL, 0x000000081a1a7c10ULL, 0x000fe4000ff5e0ffULL,
0x000000091f1f7c10ULL, 0x000fe200087fe4ffULL, 0x0000010051127825ULL, 0x000fe200078e0016ULL,
0x0000000808517211ULL, 0x000fe400078fe8ffULL, 0x0000000820207c10ULL, 0x000fe2000ff3e0ffULL,
0x000040000f6f7824ULL, 0x000fe200078e0207ULL, 0x0000000770517812ULL, 0x000fe200078ef851ULL,
0x0000010029287825ULL, 0x000fe200078e0016ULL, 0x000000091b1b7c10ULL, 0x000fc400097fe4ffULL,
0x0000000921217c10ULL, 0x000fe20008ffe4ffULL, 0x0000010025247825ULL, 0x000fe200078e0016ULL,
0x0000000828287c10ULL, 0x000fc6000ff1e0ffULL, 0x000001002b2a7825ULL, 0x100fe200078e0016ULL,
0x0000000824247c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000929297c10ULL, 0x000fe200087fe4ffULL,
0x0000010027267825ULL, 0x100fe200078e0016ULL, 0x000000082a2a7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000925257c10ULL, 0x000fe200097fe4ffULL, 0x000030006f5c7836ULL, 0x000fe20000000000ULL,
0x0000000826267c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010023227825ULL, 0x000fe200078e0016ULL,
0x000000092b2b7c10ULL, 0x000fc40008ffe4ffULL, 0x0000005c4d4d7211ULL, 0x000fe200078e20ffULL,
0x000001002d2c7825ULL, 0x100fe200078e0016ULL, 0x0000000822227c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000927277c10ULL, 0x000fe20009ffe4ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0016ULL,
0x000000082c2c7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000923237c10ULL, 0x000fe200087fe4ffULL,
0x0000001051517824ULL, 0x000fe200078e025cULL, 0x000000081c1c7c10ULL, 0x000fe2000ff3e0ffULL,
0x000001002f2e7825ULL, 0x000fe200078e0016ULL, 0x000000092d2d7c10ULL, 0x000fc400097fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010517faeULL, 0x0003e2000b901c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e025cULL, 0x000000082e2e7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000104397824ULL, 0x040fe200078e0208ULL, 0x000000091d1d7c10ULL, 0x000fe20008ffe4ffULL,
0x0000001047477824ULL, 0x000fe200078e025cULL, 0x00000000144f7faeULL, 0x0003e2000b901c46ULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x0000005c3b3b7211ULL, 0x000fe200078e20ffULL,
0x0000010019187825ULL, 0x000fe200078e0016ULL, 0x000000001a4d7faeULL, 0x0003e2000b901c46ULL,
0x000000092f2f7c10ULL, 0x000fc40009ffe4ffULL, 0x0000001045457824ULL, 0x100fe200078e025cULL,
0x000000001e477faeULL, 0x0003e2000b901c46ULL, 0x0000001043437824ULL, 0x000fe200078e025cULL,
0xfffffff804397812ULL, 0x000fe200078ee239ULL, 0x0000010053167825ULL, 0x000fe200078e0016ULL,
0x0000000818187c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000020457faeULL, 0x0003e2000b901c46ULL,
0x0000000812127c10ULL, 0x000fe2000ff3e0ffULL, 0x0000001041417824ULL, 0x100fe200078e025cULL,
0x0000000816167c10ULL, 0x000fe2000ff5e0ffULL, 0x000000103f3f7824ULL, 0x100fe200078e025cULL,
0x0000000024437faeULL, 0x0003e2000b901c46ULL, 0x000000103d3d7824ULL, 0x100fe200078e025cULL,
0x0000000919197c10ULL, 0x000fe200087fe4ffULL, 0x0000001035357824ULL, 0x100fe200078e025cULL,
0x0000000026417faeULL, 0x0003e2000b901c46ULL, 0x0000001033337824ULL, 0x100fe200078e025cULL,
0x0000000913137c10ULL, 0x000fe20008ffe4ffULL, 0x0000001031317824ULL, 0x100fe200078e025cULL,
0x00000000283f7faeULL, 0x0003e2000b901c46ULL, 0x0000001003037824ULL, 0x100fe200078e025cULL,
0x0000000917177c10ULL, 0x000fe200097fe4ffULL, 0x0000001039397824ULL, 0x100fe200078e025cULL,
0x000000002a3d7faeULL, 0x0003e2000b901c46ULL, 0x0000001037377824ULL, 0x000fc600078e025cULL,
0x000000002c3b7faeULL, 0x0003e8000b901c46ULL, 0x000000002e357faeULL, 0x0003e8000b901c46ULL,
0x0000000022337faeULL, 0x0003e8000b901c46ULL, 0x000000001c317faeULL, 0x0003e8000b901c46ULL,
0x0000000018037faeULL, 0x0003e8000b901c46ULL, 0x0000000012397faeULL, 0x0003e8000b901c46ULL,
0x0000000016377faeULL, 0x0003e4000b901c46ULL, 0x00000004ff5e7819ULL, 0x100fe20000011608ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000708047812ULL, 0x000fe200078ec0ffULL,
0x000010006f6f7836ULL, 0x000fe20000000000ULL, 0x00000003ff037819ULL, 0x002fe40000011608ULL,
0x000000035e137819ULL, 0x000fe400000006ffULL, 0x00000008045d7812ULL, 0x000fe400078ef808ULL,
0x0000000103117812ULL, 0x000fc400078ec0ffULL, 0xfffffff8133c7812ULL, 0x000fe200078ee204ULL,
0x000000015e5e7824ULL, 0x000fe400078e025dULL, 0x000000105d137824ULL, 0x000fe400078e00ffULL,
0x00000001113b7824ULL, 0x040fe400078e023cULL, 0x000000083c727824ULL, 0x000fe200078e00ffULL,
0xfffffff013107812ULL, 0x000fe200078ee25eULL, 0x000000103c3a7836ULL, 0x000fe40000000000ULL,
0x000000203c397836ULL, 0x000fe20000000000ULL, 0xfffffff872727812ULL, 0x000fe200078ee23bULL,
0x00000001116e7824ULL, 0x040fe200078e023aULL, 0x000000033a137819ULL, 0x000fe200000006ffULL,
0x000000303c387836ULL, 0x000fe20000000000ULL, 0x0000006f72147211ULL, 0x000fe200078e20ffULL,
0x0000001010107824ULL, 0x000fe200078e0207ULL, 0xfffffff8136e7812ULL, 0x000fe200078ee26eULL,
0x00000001116d7824ULL, 0x000fe200078e0239ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000001116c7824ULL, 0x000fe200078e0238ULL, 0x000000001028783bULL, 0x0003e20000000200ULL,
0x0000000838117824ULL, 0x000fe200078e00ffULL, 0x0000000339407819ULL, 0x040fe200000006ffULL,
0x000000106e347824ULL, 0x000fe200078e026fULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x000000083c187824ULL, 0x000fe200078e00ffULL, 0xfffffff8116c7812ULL, 0x000fe200078ee26cULL,
0x000000023b6b7836ULL, 0x000fe20000000000ULL, 0x0000000339107819ULL, 0x002fe200000006ffULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x000000105d197824ULL, 0x000fc400078e00ffULL,
0x000000106c2c7824ULL, 0x100fe200078e026fULL, 0xfffffff8186b7812ULL, 0x000fe200078ee26bULL,
0x000000025e127836ULL, 0x000fe20000000000ULL, 0xfffffff8106d7812ULL, 0x000fe200078ee26dULL,
0x000000123b687836ULL, 0x000fe40000000000ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0xfffffff019127812ULL, 0x000fe200078ee212ULL, 0x000000083a117824ULL, 0x000fe400078e00ffULL,
0x000000106b547824ULL, 0x000fc400078e026fULL, 0x0000001012127824ULL, 0x000fe200078e0207ULL,
0xfffffff811687812ULL, 0x000fe200078ee268ULL, 0x000000106d307824ULL, 0x000fe400078e026fULL,
0x000000005454783bULL, 0x000fe20000000200ULL, 0x0000006f68107211ULL, 0x000fe200078e20ffULL,
0x000000223b667836ULL, 0x000fe40000000000ULL, 0x000000001220783bULL, 0x000f220000000200ULL,
0x0000000839197824ULL, 0x000fe400078e00ffULL, 0x000000323b677836ULL, 0x000fe20000000000ULL,
0x000000003030783bULL, 0x000f620000000200ULL, 0x000000343b627836ULL, 0x000fe20000000000ULL,
0xfffffff819667812ULL, 0x000fe200078ee266ULL, 0x000000243b637836ULL, 0x000fe20000000000ULL,
0x000000001010783bULL, 0x000f620000000200ULL, 0x000000043b697836ULL, 0x000fc40000000000ULL,
0x0000001066187824ULL, 0x100fe200078e026fULL, 0x000000142824723cULL, 0x004fe200000418ffULL,
0xfffffff840637812ULL, 0x000fe200078ee263ULL, 0x000000143b657836ULL, 0x000fe40000000000ULL,
0x000000363b5f7836ULL, 0x000fe20000000000ULL, 0x000000001818783bULL, 0x000ea20000000200ULL,
0x000000162814723cULL, 0x000fe200000418ffULL, 0x0000001063447824ULL, 0x000fe400078e026fULL,
0x000000063b647836ULL, 0x000fc40000000000ULL, 0x000000163b617836ULL, 0x000fe20000000000ULL,
0x000000342850723cULL, 0x002fe200000418ffULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x0000000839397824ULL, 0x000fe400078e00ffULL, 0x000000263b607836ULL, 0x000fe40000000000ULL,
0x000000362834723cULL, 0x000fe600000418ffULL, 0xfffffff839607812ULL, 0x000fc600078ee260ULL,
0x0000002c281c723cULL, 0x008fec00000418ffULL, 0x000000542024723cULL, 0x010fe20000041824ULL,
0x00000008382c7824ULL, 0x000fca00078e00ffULL, 0xfffffff82c677812ULL, 0x000fe200078ee267ULL,
0x000000562054723cULL, 0x000fe80000041814ULL, 0x00000010672c7824ULL, 0x000fe400078e026fULL,
0x000000302814723cULL, 0x020fec00000418ffULL, 0x000000322830723cULL, 0x000fec00000418ffULL,
0x0000002e2828723cULL, 0x000fe200000418ffULL, 0x000000002c2c783bULL, 0x000e6a0000000200ULL,
0x000000102050723cULL, 0x000fec0000041850ULL, 0x000000182014723cULL, 0x004fe20000041814ULL,
0x000000045e107836ULL, 0x000fe20000000000ULL, 0x000000045d117819ULL, 0x000fc800000006ffULL,
0xfffffff0113e7812ULL, 0x000fe200078ee210ULL, 0x000000105d197824ULL, 0x000fe200078e00ffULL,
0x000000122010723cULL, 0x000fe60000041834ULL, 0x000000103e3e7824ULL, 0x000fc800078e0207ULL,
0x0000000838357824ULL, 0x040fe200078e00ffULL, 0x0000000338387819ULL, 0x000fe200000006ffULL,
0x000000083c347824ULL, 0x000fe400078e00ffULL, 0x000000083a367824ULL, 0x000fe200078e00ffULL,
0xfffffff835627812ULL, 0x000fe200078ee262ULL, 0x000000083c357824ULL, 0x000fe200078e00ffULL,
0xfffffff834697812ULL, 0x000fe200078ee269ULL, 0x000000003e3c783bULL, 0x000ea20000000200ULL,
0xfffffff836657812ULL, 0x000fe200078ee265ULL, 0x0000001062407824ULL, 0x100fe200078e026fULL,
0x0000006f69587211ULL, 0x000fe200078e20ffULL, 0x000000065e347836ULL, 0x000fe20000000000ULL,
0xfffffff8385f7812ULL, 0x000fe200078ee25fULL, 0x00000010654c7824ULL, 0x100fe200078e026fULL,
0x0000002c201c723cULL, 0x002fe2000004181cULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0xfffffff019347812ULL, 0x000fe200078ee234ULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff835647812ULL, 0x000fe200078ee264ULL, 0x000000005858783bULL, 0x000ee20000000200ULL,
0x0000001a2018723cULL, 0x000fe20000041830ULL, 0x000000105f2c7824ULL, 0x000fe200078e026fULL,
0xfffffff83a617812ULL, 0x000fe200078ee261ULL, 0x000000004c4c783bULL, 0x000f220000000200ULL,
0x00000010346a7824ULL, 0x000fc400078e0207ULL, 0x0000002e2020723cULL, 0x000fe20000041828ULL,
0x0000001064387824ULL, 0x100fe200078e026fULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x0000001061347824ULL, 0x000fe200078e026fULL, 0x0000006f60307211ULL, 0x000fe400078e20ffULL,
0x000000006a28783bULL, 0x000b280000000200ULL, 0x000000003838783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000f220000000200ULL, 0x000000010b6a7824ULL, 0x020fc600078e024aULL,
0x000000003030783bULL, 0x000f620000000200ULL, 0x000000443c14723cULL, 0x004fec0000041814ULL,
0x000000463c18723cULL, 0x000fec0000041818ULL, 0x000000403c1c723cULL, 0x002fec000004181cULL,
0x000000423c20723cULL, 0x000fec0000041820ULL, 0x000000583c24723cULL, 0x008fec0000041824ULL,
0x0000005a3c54723cULL, 0x000fec0000041854ULL, 0x0000004c3c50723cULL, 0x010fec0000041850ULL,
0x0000004e3c10723cULL, 0x000fec0000041810ULL, 0x0000002c281c723cULL, 0x000fec000004181cULL,
0x0000002e282c723cULL, 0x000fec0000041820ULL, 0x000000382824723cULL, 0x000fe20000041824ULL,
0x000000016a207836ULL, 0x000fc40000000000ULL, 0x000001006a217824ULL, 0x000fc600078e0202ULL,
0x000000052000720cULL, 0x000fe20003f06070ULL, 0x0000003a2854723cULL, 0x000fe20000041854ULL,
0x00000004493f7c24ULL, 0x000fca000f8e0221ULL, 0x000000342850723cULL, 0x000fec0000041850ULL,
0x000000362810723cULL, 0x000fec0000041810ULL, 0x000000302814723cULL, 0x020fec0000041814ULL,
0x000000322818723cULL, 0x000fe20000041818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000c00108947ULL, 0x000fde0003800000ULL, 0x0000002106367248ULL, 0x000fe20007fe0000ULL,
0x0000000403297836ULL, 0x000fe20000000000ULL, 0x0000000803237210ULL, 0x000fe20007ffe0ffULL,
0x0000001003357836ULL, 0x000fe20000000000ULL, 0x0000003403417810ULL, 0x000fe20007ffe0ffULL,
0x0000000136367824ULL, 0x000fe200078e0a21ULL, 0x0000000770707812ULL, 0x000fe200078ef823ULL,
0x00000001293c7824ULL, 0x140fe400078e0208ULL, 0x0000000829317824ULL, 0x040fe200078e00ffULL,
0x000000362900720cULL, 0x080fe20003f46070ULL, 0x0000000103207824ULL, 0x140fe200078e023fULL,
0x000000360300720cULL, 0x000fe20003f26070ULL, 0x0000000129287824ULL, 0x000fe200078e023fULL,
0x0000000335297819ULL, 0x040fe200000006ffULL, 0x00000001353e7824ULL, 0x000fe200078e0208ULL,
0xfffffff8313c7812ULL, 0x000fe200078ee23cULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000000c03317810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8293e7812ULL, 0x000fe200078ee23eULL,
0x00000008032b7836ULL, 0x000fe20000000000ULL, 0x0000007120227212ULL, 0x080fe200078efcffULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x000000363100720cULL, 0x080fe40003fa6070ULL,
0x0000000822227c10ULL, 0x000fe2000ff1e0ffULL, 0x000000012b2a7824ULL, 0x040fe200078e023fULL,
0x000000362b00720cULL, 0x0c0fe20003f66070ULL, 0x000000012b427824ULL, 0x140fe200078e0208ULL,
0x0000007128307212ULL, 0x000fe200078efcffULL, 0x000000082b337824ULL, 0x000fe200078e00ffULL,
0x000000363500720cULL, 0x000fe20003f86070ULL, 0x0000000131407824ULL, 0x000fc400078e0208ULL,
0x0000000831237824ULL, 0x000fe200078e00ffULL, 0xfffffff833427812ULL, 0x000fe200078ee242ULL,
0x000001002a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff823407812ULL, 0x000fe200078ee240ULL,
0x0000001403337836ULL, 0x000fe20000000000ULL, 0x0000000921237c10ULL, 0x000fe200087fe4ffULL,
0x0000000131207824ULL, 0x000fe200078e023fULL, 0x0000000830307c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000133347824ULL, 0x040fe200078e0208ULL, 0x000000712a2a7212ULL, 0x000fe200078efcffULL,
0x0000000833377824ULL, 0x000fe200078e00ffULL, 0x0000000929317c10ULL, 0x000fe200087fe4ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x000000082a2a7c10ULL, 0x000fc4000ff1e0ffULL,
0xfffffff837347812ULL, 0x000fe200078ee234ULL, 0x0000000135287824ULL, 0x000fe200078e023fULL,
0x000000092b2b7c10ULL, 0x000fe200087fe4ffULL, 0x0000001070377824ULL, 0x000fe200078e026fULL,
0x0000007120207212ULL, 0x080fe200078efcffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x000000363300720cULL, 0x0c0fe40003f06070ULL, 0x0000000820207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000133337824ULL, 0x000fe200078e023fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022377faeULL, 0x0003e2000c901c46ULL, 0x0000001803397836ULL, 0x000fe20000000000ULL,
0x0000007128287212ULL, 0x000fe200078efcffULL, 0x00000020033d7836ULL, 0x000fe20000000000ULL,
0x0000000921217c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000839357824ULL, 0x000fe200078e00ffULL,
0x0000000828287c10ULL, 0x000fe2000ffde0ffULL, 0x000000083d447824ULL, 0x000fe200078e00ffULL,
0x0000000839387210ULL, 0x000fe20007ffe0ffULL, 0x0000001c033b7836ULL, 0x000fe20000000000ULL,
0x0000000929297c10ULL, 0x000fe2000b7fe4ffULL, 0x0000003803437836ULL, 0x000fe20000000000ULL,
0xfffffff835387812ULL, 0x000fe200078ee238ULL, 0x0000010033227825ULL, 0x002fe200078e00ffULL,
0x000000363900720cULL, 0x000fc40003f26070ULL, 0x000000083b3a7210ULL, 0x000fe20007ffe0ffULL,
0x000000013d337824ULL, 0x000fe200078e0208ULL, 0x0000007122327212ULL, 0x080fe200078efcffULL,
0x0000000139357824ULL, 0x000fe400078e023fULL, 0x000000103c377824ULL, 0x100fe200078e026fULL,
0x0000000832327c10ULL, 0x000fe2000ffde0ffULL, 0x000000083b397824ULL, 0x000fe200078e00ffULL,
0xfffffff8443c7812ULL, 0x000fe200078ee233ULL, 0x0000003c03457836ULL, 0x000fe20000000000ULL,
0x0000000923337c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010035227825ULL, 0x000fe200078e00ffULL,
0xfffffff8393a7812ULL, 0x000fe200078ee23aULL, 0x0000000030377faeULL, 0x0003e2000d101c46ULL,
0x000000363b00720cULL, 0x040fe20003f46070ULL, 0x0000001042397824ULL, 0x000fe200078e026fULL,
0x0000007122357212ULL, 0x000fe200078efcffULL, 0x000000013b227824ULL, 0x000fc400078e023fULL,
0x00000024033b7836ULL, 0x000fe20000000000ULL, 0x000000002a397faeULL, 0x0005e2000d901c46ULL,
0x000000363d00720cULL, 0x080fe40003f66070ULL, 0x0000000835307c10ULL, 0x002fe2000ffde0ffULL,
0x0000001040377824ULL, 0x000fe200078e026fULL, 0x0000003f3d357210ULL, 0x000fe20007ffe0ffULL,
0x000000013b407824ULL, 0x040fe200078e0208ULL, 0x0000000923317c10ULL, 0x000fe4000b7fe4ffULL,
0x0000000020377faeULL, 0x0003e2000e901c46ULL, 0x00000100222a7825ULL, 0x004fe200078e00ffULL,
0x000000363b00720cULL, 0x000fc60003fa6070ULL, 0x0000010035227825ULL, 0x000fe200078e00ffULL,
0x000000712a357212ULL, 0x000fc600078efcffULL, 0x000000013b2a7824ULL, 0x040fe200078e023fULL,
0x0000007122227212ULL, 0x080fe200078efcffULL, 0x000000083b397824ULL, 0x000fe200078e00ffULL,
0x0000000835207c10ULL, 0x002fe2000ffde0ffULL, 0x000000103e357824ULL, 0x000fe200078e026fULL,
0x0000002803377810ULL, 0x000fe20007ffe0ffULL, 0x00000030033b7836ULL, 0x000fe20000000000ULL,
0x000000092b217c10ULL, 0x000fe2000b7fe4ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000000822227c10ULL, 0x000fe2000ffde0ffULL, 0x0000000028357faeULL, 0x0003e2000e101c46ULL,
0xfffffff839407812ULL, 0x000fe200078ee240ULL, 0x00000001373e7824ULL, 0x040fe200078e0208ULL,
0x000000712a2a7212ULL, 0x000fe200078efcffULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0x0000000923237c10ULL, 0x000fc4000b7fe4ffULL, 0x000000363700720cULL, 0x0c0fe40003f86070ULL,
0xfffffff8393e7812ULL, 0x000fe200078ee23eULL, 0x0000001034397824ULL, 0x000fe200078e026fULL,
0x000000082a287c10ULL, 0x002fe2000ffde0ffULL, 0x00000001372a7824ULL, 0x000fe400078e023fULL,
0x0000002c03377836ULL, 0x000fe20000000000ULL, 0x000000092b297c10ULL, 0x000fe2000b7fe4ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000032397faeULL, 0x0003e4000c101c46ULL,
0x0000003f37347210ULL, 0x000fe20007ffe0ffULL, 0x0000000137427824ULL, 0x040fe200078e0208ULL,
0x000000712a2a7212ULL, 0x000fe200078efcffULL, 0x00000008373d7824ULL, 0x040fe200078e00ffULL,
0x000000363700720cULL, 0x000fe20003f06070ULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0x000000082a2a7c10ULL, 0x000fc4000ffde0ffULL, 0xfffffff83d427812ULL, 0x000fe200078ee242ULL,
0x000000013b377824ULL, 0x000fe200078e023fULL, 0x0000007134347212ULL, 0x000fe200078efcffULL,
0x0000001038397824ULL, 0x002fe200078e026fULL, 0x000000092b2b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010037327825ULL, 0x000fc600078e00ffULL, 0x0000000030397faeULL, 0x0003e2000c901c46ULL,
0x000000013b377824ULL, 0x040fe200078e0208ULL, 0x000000363b00720cULL, 0x000fe20003f26070ULL,
0x00000010403d7824ULL, 0x100fe200078e026fULL, 0x0000007132327212ULL, 0x000fe200078efcffULL,
0x0000000843387824ULL, 0x000fe200078e00ffULL, 0x0000000834307c10ULL, 0x002fe2000ffde0ffULL,
0x000000083b347824ULL, 0x000fe400078e00ffULL, 0x000000103a3b7824ULL, 0x000fe200078e026fULL,
0x0000000935317c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000141357824ULL, 0x000fe200078e023fULL,
0x0000000832327c10ULL, 0x000fe2000ffde0ffULL, 0x000000103c397824ULL, 0x000fe200078e026fULL,
0x00000000203b7faeULL, 0x0003e2000d101c46ULL, 0xfffffff834347812ULL, 0x000fc400078ee237ULL,
0x0000000933337c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000022397faeULL, 0x0005e2000d901c46ULL,
0x000000364300720cULL, 0x080fe40003f66070ULL, 0x000000364500720cULL, 0x080fe20003f46070ULL,
0x00000000283d7faeULL, 0x0007e2000e901c46ULL, 0x000000364100720cULL, 0x040fe20003fa6070ULL,
0x0000000141367824ULL, 0x000fe200078e0208ULL, 0x00000003453a7819ULL, 0x000fe200000006ffULL,
0x0000010035207825ULL, 0x002fe200078e00ffULL, 0x0000003f43357210ULL, 0x000fc60007ffe0ffULL,
0x0000000841417824ULL, 0x000fe200078e00ffULL, 0x0000007120377212ULL, 0x000fe200078efcffULL,
0x0000010035227825ULL, 0x004fc600078e00ffULL, 0x0000000837207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000145287824ULL, 0x008fe200078e023fULL, 0x0000007122227212ULL, 0x080fe200078efcffULL,
0x0000000143357824ULL, 0x100fe200078e0208ULL, 0x0000000921217c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000000822227c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff841367812ULL, 0x000fe200078ee236ULL, 0x0000000145377824ULL, 0x000fe200078e0208ULL,
0x0000007128287212ULL, 0x000fe200078efcffULL, 0x0000001034397824ULL, 0x100fe200078e026fULL,
0xfffffff838387812ULL, 0x000fe200078ee235ULL, 0x000000103e357824ULL, 0x100fe200078e026fULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee237ULL, 0x0000001042377824ULL, 0x100fe200078e026fULL,
0x0000000923237c10ULL, 0x000fe2000b7fe4ffULL, 0x00000010363b7824ULL, 0x100fe200078e026fULL,
0x0000000828287c10ULL, 0x000fe2000ffde0ffULL, 0x00000010383d7824ULL, 0x100fe200078e026fULL,
0x000000002a357faeULL, 0x0003e2000e101c46ULL, 0x000000103a6f7824ULL, 0x000fe200078e026fULL,
0x0000000929297c10ULL, 0x000fc4000b7fe4ffULL, 0x0000000030377faeULL, 0x0003e8000c101c46ULL,
0x0000000032397faeULL, 0x0003e8000c901c46ULL, 0x00000000203b7faeULL, 0x0003e8000e901c46ULL,
0x00000000223d7faeULL, 0x0003e8000d901c46ULL, 0x00000000286f7faeULL, 0x0003e2000d101c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x0000000c03347836ULL, 0x000fe20000000000ULL,
0x0000000403287810ULL, 0x000fe20007ffe0ffULL, 0x0000000803217836ULL, 0x000fe40000000000ULL,
0x00000001344f7824ULL, 0x140fe400078e0208ULL, 0x00000008342a7824ULL, 0x000fe200078e00ffULL,
0x0000000321297819ULL, 0x040fe200000006ffULL, 0x00000001217c7824ULL, 0x100fe400078e0208ULL,
0x0000000103237824ULL, 0x100fe200078e0208ULL, 0xfffffff82a4f7812ULL, 0x000fe200078ee24fULL,
0x00000014032b7836ULL, 0x000fe20000000000ULL, 0xfffffff8297c7812ULL, 0x000fe200078ee27cULL,
0x00000018032a7836ULL, 0x000fe20000000000ULL, 0x0000000770207812ULL, 0x000fe200078ef823ULL,
0x000000012b7a7824ULL, 0x000fc400078e0208ULL, 0x000000082b297824ULL, 0x000fe400078e00ffULL,
0x000000012a4c7824ULL, 0x140fe400078e0208ULL, 0x000000082a317824ULL, 0x000fe200078e00ffULL,
0xfffffff8297a7812ULL, 0x000fe200078ee27aULL, 0x0000001c03367836ULL, 0x000fe40000000000ULL,
0x0000002403707836ULL, 0x000fe20000000000ULL, 0xfffffff8314c7812ULL, 0x000fe200078ee24cULL,
0x0000001003327836ULL, 0x000fe20000000000ULL, 0x0000000336337819ULL, 0x040fe200000006ffULL,
0x0000000136787824ULL, 0x100fe200078e0208ULL, 0x0000000870767210ULL, 0x000fe20007ffe0ffULL,
0x0000002c03317836ULL, 0x000fe20000000000ULL, 0x00000008324e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000870297824ULL, 0x000fe200078e00ffULL, 0xfffffff833787812ULL, 0x000fe200078ee278ULL,
0x0000000832237824ULL, 0x000fe200078e00ffULL, 0x0000003f32327210ULL, 0x000fe20007ffe0ffULL,
0x00000028035a7836ULL, 0x000fe20000000000ULL, 0xfffffff829767812ULL, 0x000fe200078ee276ULL,
0x0000002003737836ULL, 0x000fe20000000000ULL, 0xfffffff8234e7812ULL, 0x000fe200078ee24eULL,
0x00000001313a7824ULL, 0x140fe200078e0208ULL, 0x0000003003297810ULL, 0x000fe20007ffe0ffULL,
0x0000000831357824ULL, 0x000fe200078e00ffULL, 0x0000003f31317210ULL, 0x000fe20007ffe0ffULL,
0x000000015a447824ULL, 0x000fc400078e0208ULL, 0x000000085a337824ULL, 0x000fe200078e00ffULL,
0xfffffff8353a7812ULL, 0x000fe200078ee23aULL, 0x00000001285b7824ULL, 0x140fe400078e0208ULL,
0x0000000828227824ULL, 0x000fe200078e00ffULL, 0xfffffff833447812ULL, 0x000fe200078ee244ULL,
0x0000000173467824ULL, 0x040fe400078e0208ULL, 0x0000000873237824ULL, 0x000fe200078e00ffULL,
0xfffffff8225b7812ULL, 0x000fe200078ee25bULL, 0x0000003803357836ULL, 0x000fc40000000000ULL,
0x0000003403337836ULL, 0x000fe20000000000ULL, 0xfffffff823467812ULL, 0x000fe200078ee246ULL,
0x0000000129307824ULL, 0x140fe200078e023fULL, 0x0000003f35427210ULL, 0x000fe20007ffe0ffULL,
0x00000001293c7824ULL, 0x000fe200078e0208ULL, 0x0000006f5b5b7211ULL, 0x080fe200078e20ffULL,
0x0000003c03227836ULL, 0x000fe20000000000ULL, 0x0000006f46467211ULL, 0x000fe200078e20ffULL,
0x0000000829297824ULL, 0x000fe400078e00ffULL, 0x0000000103237824ULL, 0x000fc400078e023fULL,
0x0000000121217824ULL, 0x100fe200078e023fULL, 0xfffffff8293c7812ULL, 0x000fe200078ee23cULL,
0x0000000128287824ULL, 0x100fe400078e023fULL, 0x0000000134347824ULL, 0x100fe400078e023fULL,
0x000000012b2b7824ULL, 0x100fe400078e023fULL, 0x000000012a2a7824ULL, 0x100fe400078e023fULL,
0x0000000136367824ULL, 0x000fc400078e023fULL, 0x0000000173737824ULL, 0x100fe400078e023fULL,
0x0000000170707824ULL, 0x100fe400078e023fULL, 0x000000015a5a7824ULL, 0x100fe400078e023fULL,
0x0000000133587824ULL, 0x100fe400078e023fULL, 0x00000001223f7824ULL, 0x040fe400078e023fULL,
0x0000000122387824ULL, 0x000fc400078e0208ULL, 0x0000000822377824ULL, 0x000fe400078e00ffULL,
0x0000010023227825ULL, 0x000fc600078e00ffULL, 0xfffffff837387812ULL, 0x000fe200078ee238ULL,
0x0000001020777824ULL, 0x000fe200078e026fULL, 0x0000007122227212ULL, 0x000fe200078efcffULL,
0x0000010021207825ULL, 0x000fc600078e00ffULL, 0x0000000822227c10ULL, 0x000fe2000ff1e0ffULL,
0x00000001353e7824ULL, 0x040fe400078e0208ULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x0000000923237c10ULL, 0x000fe200087fe4ffULL, 0x0000010028287825ULL, 0x000fc600078e00ffULL,
0xfffffff8353e7812ULL, 0x000fe200078ee23eULL, 0x000000103c417824ULL, 0x100fe200078e026fULL,
0x00000071203c7212ULL, 0x080fe200078efcffULL, 0x0000000133407824ULL, 0x040fe200078e0208ULL,
0x0000007128287212ULL, 0x080fe200078efcffULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x000000083c3c7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0x0000000828287c10ULL, 0x000fe2000ff1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022777faeULL, 0x0003e2000b901c46ULL, 0xfffffff833407812ULL, 0x000fe200078ee240ULL,
0x000000103a437824ULL, 0x000fe200078e026fULL, 0x00000009213d7c10ULL, 0x000fe20008ffe4ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x00000071343a7212ULL, 0x000fc400078efcffULL,
0x0000000929297c10ULL, 0x000fe200087fe4ffULL, 0x000001002b207825ULL, 0x000fe200078e00ffULL,
0x000000083a3a7c10ULL, 0x000fc6000ff1e0ffULL, 0x000000107c597824ULL, 0x100fe200078e026fULL,
0x0000007120377212ULL, 0x000fe200078efcffULL, 0x000000104f4f7824ULL, 0x100fe200078e026fULL,
0x00000009353b7c10ULL, 0x000fe200087fe4ffULL, 0x000000104e4e7824ULL, 0x100fe200078e026fULL,
0x00000000285b7faeULL, 0x0005e2000b901c46ULL, 0x000000107a4d7824ULL, 0x100fe400078e026fULL,
0x000000104c4c7824ULL, 0x100fe200078e026fULL, 0x000000003c597faeULL, 0x0007e2000b901c46ULL,
0x0000001078477824ULL, 0x000fc400078e026fULL, 0x0000001076457824ULL, 0x100fe200078e026fULL,
0x000000003a4f7faeULL, 0x0009e2000b901c46ULL, 0x0000001044447824ULL, 0x100fe400078e026fULL,
0x0000001040407824ULL, 0x100fe400078e026fULL, 0x000000103e3e7824ULL, 0x000fe200078e026fULL,
0x0000006f386f7211ULL, 0x000fe200078e20ffULL, 0x0000010036227825ULL, 0x002fe200078e00ffULL,
0x0000007132387212ULL, 0x000fe400078efcffULL, 0x0000000837367c10ULL, 0x000fe2000ff1e0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000838387c10ULL, 0x000fc4000ff3e0ffULL,
0x0000007122327212ULL, 0x080fe200078efcffULL, 0x000001005a287825ULL, 0x004fe200078e00ffULL,
0x0000000933397c10ULL, 0x000fe40008ffe4ffULL, 0x0000000921377c10ULL, 0x000fe200087fe4ffULL,
0x0000010073207825ULL, 0x000fe200078e00ffULL, 0x000000712a347212ULL, 0x080fe200078efcffULL,
0x00000000384e7faeULL, 0x0003e2000b901c46ULL, 0x0000000832327c10ULL, 0x000fe2000ff3e0ffULL,
0x0000010058587825ULL, 0x008fe200078e00ffULL, 0x0000000834347c10ULL, 0x000fe2000ff1e0ffULL,
0x00000000364d7faeULL, 0x0003e2000b901c46ULL, 0x0000000923337c10ULL, 0x000fe20008ffe4ffULL,
0x0000010070227825ULL, 0x000fe200078e00ffULL, 0x0000007120207212ULL, 0x000fc400078efcffULL,
0x000000092b357c10ULL, 0x000fe200087fe4ffULL, 0x00000100312a7825ULL, 0x000fe200078e00ffULL,
0x0000000820207c10ULL, 0x000fe4000ff1e0ffULL, 0x0000007122227212ULL, 0x080fe200078efcffULL,
0x00000100423c7825ULL, 0x000fe200078e00ffULL, 0x0000000921217c10ULL, 0x000fe200087fe4ffULL,
0x00000000344c7faeULL, 0x0003e2000b901c46ULL, 0x0000000822227c10ULL, 0x000fe2000ff1e0ffULL,
0x000001003f5a7825ULL, 0x000fe200078e00ffULL, 0x0000007128317212ULL, 0x000fe200078efcffULL,
0x0000000032477faeULL, 0x0003e2000b901c46ULL, 0x0000000923237c10ULL, 0x000fc400087fe4ffULL,
0x0000000831287c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x000000712a2a7212ULL, 0x080fe200078efcffULL, 0x0000000020467faeULL, 0x0003e2000b901c46ULL,
0x0000000929297c10ULL, 0x000fe400087fe4ffULL, 0x0000007130307212ULL, 0x080fe200078efcffULL,
0x0000000022457faeULL, 0x0003e2000b901c46ULL, 0x000000082a2a7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000830307c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000028447faeULL, 0x0003e2000b901c46ULL,
0x0000007158587212ULL, 0x000fc400078efcffULL, 0x000000713c3f7212ULL, 0x080fe400078efcffULL,
0x000000715a5a7212ULL, 0x000fe400078efcffULL, 0x0000000931317c10ULL, 0x000fe400087fe4ffULL,
0x000000092b2b7c10ULL, 0x000fe40008ffe4ffULL, 0x0000000858587c10ULL, 0x000fe4000ff1e0ffULL,
0x000000083f3c7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000002a437faeULL, 0x0003e2000b901c46ULL,
0x000000085a5a7c10ULL, 0x000fc4000ff5e0ffULL, 0x0000000959597c10ULL, 0x000fe200087fe4ffULL,
0x0000000030417faeULL, 0x0003e2000b901c46ULL, 0x000000093d3d7c10ULL, 0x000fe40008ffe4ffULL,
0x000000095b5b7c10ULL, 0x000fe200097fe4ffULL, 0x0000000058407faeULL, 0x0003e8000b901c46ULL,
0x000000003c3e7faeULL, 0x0003e8000b901c46ULL, 0x000000005a6f7faeULL, 0x0103e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000085e207836ULL, 0x002fe20000000000ULL,
0x0000005c6c307211ULL, 0x000fe200078e20ffULL, 0x000000105d217824ULL, 0x040fe400078e00ffULL,
0x00000010723c7824ULL, 0x100fe400078e025cULL, 0x000000106e407824ULL, 0x000fe200078e025cULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x0000000a5e287836ULL, 0x000fe40000000000ULL,
0x000000105d297824ULL, 0x000fc400078e00ffULL, 0x0000001020387824ULL, 0x100fe400078e0207ULL,
0x000000106d207824ULL, 0x100fe200078e025cULL, 0xfffffff029287812ULL, 0x000fe200078ee228ULL,
0x000000106b347824ULL, 0x100fe400078e025cULL, 0x0000001066667824ULL, 0x100fe400078e025cULL,
0x0000001028287824ULL, 0x000fe400078e0207ULL, 0x0000001069697824ULL, 0x000fe200078e025cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x0000001062587824ULL, 0x100fe400078e025cULL, 0x00000010644c7824ULL, 0x100fe200078e025cULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004040783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000005858783bULL, 0x000fe80000000200ULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x0000003c3824723cULL, 0x002fec0000041824ULL, 0x0000003e3854723cULL, 0x000fe20000041854ULL,
0x00000010683c7824ULL, 0x000fca00078e025cULL, 0x000000403850723cULL, 0x004fe20000041850ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x00000030381c723cULL, 0x008fe2000004181cULL,
0x000000105d407824ULL, 0x040fe200078e00ffULL, 0x000000045d5d7819ULL, 0x000fc800000006ffULL,
0x000000203814723cULL, 0x010fe20000041814ULL, 0x0000000c5e317810ULL, 0x000fe20007ffe0ffULL,
0x0000001067307824ULL, 0x000fe400078e025cULL, 0x0000000e5e5e7836ULL, 0x000fe20000000000ULL,
0xfffffff040407812ULL, 0x000fe200078ee231ULL, 0x000000223820723cULL, 0x000fe20000041818ULL,
0x000000006618783bULL, 0x000ea40000000200ULL, 0xfffffff05d5e7812ULL, 0x000fe200078ee25eULL,
0x0000001040407824ULL, 0x000fc400078e0207ULL, 0x000000423810723cULL, 0x000fe40000041810ULL,
0x000000105e447824ULL, 0x000fe400078e0207ULL, 0x000000004040783bULL, 0x000fe40000000200ULL,
0x00000032382c723cULL, 0x000fe4000004182cULL, 0x000000003030783bULL, 0x000ee80000000200ULL,
0x000000342838723cULL, 0x020fe20000041824ULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x000000006924783bULL, 0x000f220000000200ULL, 0x0000003c2850723cULL, 0x002fe20000041850ULL,
0x0000001065347824ULL, 0x000fca00078e025cULL, 0x000000362854723cULL, 0x000fe20000041854ULL,
0x00000010633c7824ULL, 0x100fe200078e025cULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x0000003e2810723cULL, 0x000fe20000041810ULL, 0x000000003c3c783bULL, 0x000f6a0000000200ULL,
0x000000182814723cULL, 0x004fec0000041814ULL, 0x0000001a2820723cULL, 0x000fe20000041820ULL,
0x0000001061187824ULL, 0x000fca00078e025cULL, 0x00000030281c723cULL, 0x008fe2000004181cULL,
0x000000001818783bULL, 0x000eaa0000000200ULL, 0x00000032282c723cULL, 0x000fec000004182cULL,
0x000000244038723cULL, 0x010fe20000041838ULL, 0x0000001060287824ULL, 0x000fca00078e025cULL,
0x000000264054723cULL, 0x000fe20000041854ULL, 0x0000005c5f247211ULL, 0x000fe200078e20ffULL,
0x000000002828783bULL, 0x000ee80000000200ULL, 0x000000344050723cULL, 0x002fe20000041850ULL,
0x000000002424783bULL, 0x000e6a0000000200ULL, 0x000000364010723cULL, 0x000fec0000041810ULL,
0x0000003c4014723cULL, 0x020fec0000041814ULL, 0x0000003e4020723cULL, 0x000fec0000041820ULL,
0x00000058401c723cULL, 0x000fec000004181cULL, 0x0000005a402c723cULL, 0x000fec000004182cULL,
0x000000184450723cULL, 0x004fec0000041850ULL, 0x0000004c4438723cULL, 0x000fe20000041838ULL,
0x00000001ff187424ULL, 0x000fca00078e00ffULL, 0x0000004e4454723cULL, 0x000fe20000041854ULL,
0x01b688184b1879a7ULL, 0x000eaa000850003fULL, 0x0000001a4410723cULL, 0x000fec0000041810ULL,
0x000000284414723cULL, 0x008fe20000041814ULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fc40000410000ULL, 0x0000002a4420723cULL, 0x000fe20000041820ULL,
0x3db504f3381b7820ULL, 0x000fe20000410000ULL, 0x3db504f339397820ULL, 0x000fe20000410000ULL,
0x3db504f33a3a7820ULL, 0x000fe20000410000ULL, 0x3db504f33b3b7820ULL, 0x000fe40000410000ULL,
0x00000024441c723cULL, 0x002fe2000004181cULL, 0x3db504f354547820ULL, 0x000fe20000410000ULL,
0x3db504f355557820ULL, 0x000fe20000410000ULL, 0x3db504f356567820ULL, 0x000fe20000410000ULL,
0x3db504f357577820ULL, 0x000fc40000410000ULL, 0x00000026442c723cULL, 0x000fe2000004182cULL,
0x3db504f3101a7820ULL, 0x000fe20000410000ULL, 0x3db504f311247820ULL, 0x000fe20000410000ULL,
0x3db504f312257820ULL, 0x000fc60000410000ULL, 0x3db504f314297820ULL, 0x000fe20000410000ULL,
0x3db504f313277820ULL, 0x000fe20000410000ULL, 0x3db504f3152a7820ULL, 0x000fe20000410000ULL,
0x3db504f316287820ULL, 0x000fe20000410000ULL, 0x3db504f317267820ULL, 0x000fe40000410000ULL,
0x3db504f3202b7820ULL, 0x000fe20000410000ULL, 0x3db504f321217820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fc60000410000ULL,
0x3db504f31c307820ULL, 0x000fe20000410000ULL, 0x3db504f31d317820ULL, 0x000fe20000410000ULL,
0x3db504f31e1e7820ULL, 0x000fe20000410000ULL, 0x3db504f31f1f7820ULL, 0x000fc60000410000ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x0000000000107805ULL, 0x000fe20000015200ULL, 0x01b688194b0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff147224ULL, 0x000fce00078e00ffULL,
0x000000101400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000114147836ULL, 0x000fce0000000000ULL,
0x01b688194b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000408107824ULL, 0x000fe200078e00ffULL, 0x000000070f117211ULL, 0x000fe400078e38ffULL,
0x0000000d4a00720cULL, 0x000fe40003f06070ULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x0000000111207824ULL, 0x000fca00078e0210ULL, 0x01b4000020107984ULL, 0x0002a20000000c00ULL,
0x0000001400208947ULL, 0x000fea0003800000ULL, 0x0000860000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x0000000400167d06ULL, 0x000ee20008209000ULL,
0x0000000906327248ULL, 0x000fe20007fe0000ULL, 0x0000000208337824ULL, 0x000fe200078e00ffULL,
0x00000004ff007c0cULL, 0x000fc6000bf85070ULL, 0x0000000132327824ULL, 0x000fe200078e0a09ULL,
0x0000000633337812ULL, 0x000fc600078ec0ffULL, 0x000000ffff5d7224ULL, 0x000fe400078e0a32ULL,
0x0000000133097824ULL, 0x000fe200078e0200ULL, 0x0000001600167308ULL, 0x008ee80000001000ULL,
0x0000005d09467246ULL, 0x000fe2000380000cULL, 0x0ffffffe16187836ULL, 0x008fc80000000000ULL,
0x0000001800157305ULL, 0x000ee4000021f000ULL, 0x000000ffff177224ULL, 0x008fc800078e0a15ULL,
0x0000000417177c24ULL, 0x000fc8000f8e02ffULL, 0x0000001715197227ULL, 0x000fe200078e0014ULL,
0x0000004808147211ULL, 0x000fca00078ff0ffULL, 0x0000001419157227ULL, 0x000fc800078e00ffULL,
0x000000ffff177224ULL, 0x000fc800078e0a15ULL, 0x0000000417167c24ULL, 0x000fe4000f8e0214ULL,
0x0000000814147836ULL, 0x000fc60000000000ULL, 0x0000000416007c0cULL, 0x000fe2000bf06070ULL,
0x0000001419347227ULL, 0x000fca00078e00ffULL, 0x000000ff34177210ULL, 0x000fca0007ffe1ffULL,
0x0000000417147c24ULL, 0x000fe2000f8e0214ULL, 0x000000330a177210ULL, 0x000fe20007ffe0ffULL,
0x8000000416160c36ULL, 0x000fe40008000000ULL, 0x0000000115150836ULL, 0x000fe20000000000ULL,
0x0000000414007c0cULL, 0x000fe4000bf46070ULL, 0x0000000416007c0cULL, 0x000fe4000bf26070ULL,
0x00000004ff167c12ULL, 0x000fe4000f8e33ffULL, 0x000000321700720cULL, 0x000fc40003f66070ULL,
0x0000005d17177246ULL, 0x000fc8000380000cULL, 0x00000004ff177819ULL, 0x000fe20000011617ULL,
0x8000000414142c36ULL, 0x000fe40008000000ULL, 0x0000000115151836ULL, 0x000fe20000000000ULL,
0x000000320900720cULL, 0x000fe20003f26070ULL, 0x0000000134342836ULL, 0x000fe20000000000ULL,
0x0000000414007c0cULL, 0x000fe4000bf06070ULL, 0x0000001516157207ULL, 0x000fe40006000000ULL,
0x000000ff17147207ULL, 0x000fc40001800000ULL, 0x000000150c157248ULL, 0x000fe40003fe0000ULL,
0x000000ff46467207ULL, 0x000fc60000800000ULL, 0x00000005155f7c24ULL, 0x000fe4000f8e02ffULL,
0x0000000134340836ULL, 0x000fe20000000000ULL, 0x0000001033377812ULL, 0x000fe200078efcffULL,
0x000000015f1d7824ULL, 0x000fe200078e0214ULL, 0x0000005f46197211ULL, 0x000fe400078fe0ffULL,
0x0000003416157207ULL, 0x000fe20006000000ULL, 0x0000000137357824ULL, 0x000fe400078e0200ULL,
0x000000021d1c7825ULL, 0x000fe200078e0074ULL, 0x000000150c157248ULL, 0x000fc60003fe0000ULL,
0x0000000219187825ULL, 0x000fe200078e0074ULL, 0x000000323500720cULL, 0x000fe20003f06070ULL,
0x000000061c4a7981ULL, 0x000724000c1e9500ULL, 0x0000000515617c24ULL, 0x000fe2000f8e02ffULL,
0x0000005d35347246ULL, 0x000fe2000380000cULL, 0x00000006185b7981ULL, 0x000b24000c1e9500ULL,
0x0000000114177824ULL, 0x000fe200078e0261ULL, 0x0000006146157211ULL, 0x000fe400078fe0ffULL,
0x000000ff34347207ULL, 0x000fe20000000000ULL, 0x0000000217167825ULL, 0x000fe200078e0074ULL,
0x000000370a1d7210ULL, 0x008fc60007ffe0ffULL, 0x0000000215147825ULL, 0x000fe200078e0074ULL,
0x00000020333f7812ULL, 0x000fe200078efcffULL, 0x0000000616427981ULL, 0x004ea2000c1e9500ULL,
0x0000005d1d187246ULL, 0x022fc6000380000cULL, 0x0000000614597981ULL, 0x0002a2000c1e9500ULL,
0x000000010a437824ULL, 0x000fe200078e023fULL, 0x000000321d00720cULL, 0x080fe40003f26070ULL,
0x00000004ff187819ULL, 0x000fe40000011618ULL, 0x0000005f34157211ULL, 0x002fe400078fe0ffULL,
0x0000005d433c7246ULL, 0x000fe4000380000cULL, 0x000000ff18187207ULL, 0x000fe20000800000ULL,
0x0000000215147825ULL, 0x000fe200078e0074ULL, 0x000000324300720cULL, 0x000fc60003f26070ULL,
0x000000013f417824ULL, 0x000fe200078e0200ULL, 0x00000006143d7981ULL, 0x0002e2000c1e9500ULL,
0x000000015f1d7824ULL, 0x000fe200078e0218ULL, 0x0000006134197211ULL, 0x000fe200078fe0ffULL,
0x0000000118177824ULL, 0x000fe200078e0261ULL, 0x000000324100720cULL, 0x000fe20003f06070ULL,
0x000000021d1c7825ULL, 0x000fe200078e0074ULL, 0x00000004ff147819ULL, 0x002fe4000001163cULL,
0x0000003033477812ULL, 0x000fe200078efcffULL, 0x0000000217167825ULL, 0x100fe200078e0074ULL,
0x000000ff14407207ULL, 0x000fe20000800000ULL, 0x000000061c367981ULL, 0x0002e2000c1e9500ULL,
0x0000005d413c7246ULL, 0x000fe2000380000cULL, 0x0000000219187825ULL, 0x000fc400078e0074ULL,
0x0000000616387981ULL, 0x000ae2000c1e9500ULL, 0x000000ff3c3c7207ULL, 0x000fe20000000000ULL,
0x000000015f157824ULL, 0x000fe400078e0240ULL, 0x000000010a637824ULL, 0x000fe200078e0247ULL,
0x0000000618437981ULL, 0x000ae2000c1e9500ULL, 0x0000005f3c1d7211ULL, 0x042fe200078fe0ffULL,
0x0000000215147825ULL, 0x000fe400078e0074ULL, 0x0000005d63447246ULL, 0x000fe4000380000cULL,
0x00000001474d7824ULL, 0x000fe200078e0200ULL, 0x0000006140177210ULL, 0x020fe20007ffe0ffULL,
0x000000021d1c7825ULL, 0x000fe200078e0074ULL, 0x00000006143e7981ULL, 0x000362000c1e9500ULL,
0x000000613c197211ULL, 0x000fc400078fe0ffULL, 0x000000326300720cULL, 0x080fe20003f26070ULL,
0x0000000217167825ULL, 0x100fe200078e0074ULL, 0x000000324d00720cULL, 0x000fe20003f06070ULL,
0x000000061c457981ULL, 0x000364000c1e9500ULL, 0x0000000219187825ULL, 0x000fe200078e0074ULL,
0x00000004ff147819ULL, 0x002fe20000011644ULL, 0x0000000616407981ULL, 0x000362000c1e9500ULL,
0x0000005d4d447246ULL, 0x000fc6000380000cULL, 0x00000006184f7981ULL, 0x000362000c1e9500ULL,
0x000000ff141c7207ULL, 0x000fe40000800000ULL, 0x000000ff44447207ULL, 0x000fc60000000000ULL,
0x000000015f157824ULL, 0x000fe200078e021cULL, 0x0000005f44177211ULL, 0x002fc600078fe0ffULL,
0x0000000215147825ULL, 0x000fc800078e0074ULL, 0x0000000217167825ULL, 0x000fe400078e0074ULL,
0x0000000614147981ULL, 0x000362000c1e9500ULL, 0x0000006144197211ULL, 0x000fc600078fe0ffULL,
0x0000000616177981ULL, 0x000f62000c1e9500ULL, 0x000000011c1d7824ULL, 0x000fe400078e0261ULL,
0x0000000219187825ULL, 0x000fc800078e0074ULL, 0x000000021d1c7825ULL, 0x000fe400078e0074ULL,
0x0000000618187981ULL, 0x000368000c1e9500ULL, 0x000000061c1d7981ULL, 0x000362000c1e9500ULL,
0xfffffff0465d7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff467424ULL, 0x000fc800078e00ffULL,
0x00000001324c7824ULL, 0x000fe200078e025dULL, 0x0000000133157812ULL, 0x002fc600078efcffULL,
0x0000000109637824ULL, 0x000fe200078e0a4cULL, 0x00000009335f7812ULL, 0x000fe400078efcffULL,
0x0000000015617210ULL, 0x000fe40007ffe0ffULL, 0x0000006346637219ULL, 0x000fe200000006ffULL,
0x000000015f197824ULL, 0x000fe400078e0200ULL, 0x0000000161657824ULL, 0x100fe400078e0a4cULL,
0x0000000119697824ULL, 0x000fe200078e0a4cULL, 0x00000018337b7812ULL, 0x000fc400078efcffULL,
0x0000006546657219ULL, 0x040fe400000006ffULL, 0x0000006946697219ULL, 0x000fe400000006ffULL,
0xfffffff034347812ULL, 0x000fe400078ec0ffULL, 0xfffffff044447812ULL, 0x000fe200078ec0ffULL,
0x000000017b1c7824ULL, 0x000fc800078e0200ULL, 0x00000001325a7824ULL, 0x000fe200078e0244ULL,
0x0000001933797812ULL, 0x040fe400078efcffULL, 0x00000011337d7812ULL, 0x040fe400078efcffULL,
0x00000021336d7812ULL, 0x040fe400078efcffULL, 0x00000028336b7812ULL, 0x000fe200078efcffULL,
0x0000000179167824ULL, 0x100fe400078e0200ULL, 0x000000016d737824ULL, 0x000fc400078e0200ULL,
0x000000016b717824ULL, 0x000fe400078e0200ULL, 0x000000014d647824ULL, 0x000fca00078e0a5aULL,
0x0000006446647219ULL, 0x000fe400000006ffULL, 0x000054105b4a7816ULL, 0x010fe4000000004aULL,
0x00000008335b7812ULL, 0x000fe400078efcffULL, 0x0000004a63ff7212ULL, 0x000fc6000780c0ffULL,
0x000000015b5d7824ULL, 0x000fe200078e0200ULL, 0x000000320900720cULL, 0x000fc60000701470ULL,
0x000000015d677824ULL, 0x000fe200078e0a4cULL, 0x000000323300720cULL, 0x000fc800007a1070ULL,
0x0000006746677219ULL, 0x000fe400000006ffULL, 0x0000541059427816ULL, 0x004fe40000000042ULL,
0x0000004a65ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004a67ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004a69ff7212ULL, 0x000fe4000788c0ffULL, 0xff8000001b1b7808ULL, 0x000fc40002800000ULL,
0xfffffff03c4a7812ULL, 0x000fe200078ec0ffULL, 0x00000001323c7824ULL, 0x000fe200078e0234ULL,
0x0000004263ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004267ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004269ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000135447824ULL, 0x000fe200078e0a3cULL,
0x000000320900720cULL, 0x080fe40001741470ULL, 0x000000325d00720cULL, 0x000fc400037c1470ULL,
0x000000321900720cULL, 0x080fe40002fa1470ULL, 0x0000001c3c4e7210ULL, 0x000fe40007ffe1ffULL,
0x000000323300720cULL, 0x080fe40001741070ULL, 0x000000325b00720cULL, 0x080fe400037c1070ULL,
0x000000325f00720cULL, 0x000fe40002fa1070ULL, 0x0000004265ff7212ULL, 0x000fc4000780c0ffULL,
0x0000004446447219ULL, 0x040fe400000006ffULL, 0x0000004e464e7219ULL, 0x000fe400000006ffULL,
0x000054103d3d7816ULL, 0x008fe40000000036ULL, 0x0000002933697812ULL, 0x000fe400078efcffULL,
0x0000541043437816ULL, 0x000fe40000000038ULL, 0x0000003133657812ULL, 0x000fc400078efcffULL,
0x0000003833637812ULL, 0x040fe400078efcffULL, 0x0000003933597812ULL, 0x000fe200078efcffULL,
0x00000001324a7824ULL, 0x000fe200078e024aULL, 0x000000007d427210ULL, 0x000fe40007ffe0ffULL,
0xff8000003a3a7808ULL, 0x000fe40001000000ULL, 0xff80000056567808ULL, 0x000fe40003000000ULL,
0xff80000057577808ULL, 0x000fc40002800000ULL, 0x0000003d44ff7212ULL, 0x040fe4000784c0ffULL,
0x0000004344ff7212ULL, 0x080fe400078cc0ffULL, 0x000000434eff7212ULL, 0x000fe200078ac0ffULL,
0x00000001696f7824ULL, 0x100fe200078e0200ULL, 0x0000000063777210ULL, 0x000fe20007ffe0ffULL,
0x0000000165677824ULL, 0x100fe200078e0200ULL, 0x000000326100720cULL, 0x080fe20000f21470ULL,
0x0000000159347824ULL, 0x000fe200078e0200ULL, 0x000000326100720cULL, 0x080fe20000701470ULL,
0x0000000116587824ULL, 0x100fe200078e0a3cULL, 0x000000325d00720cULL, 0x080fe20001f61470ULL,
0x00000001424c7824ULL, 0x000fe200078e0a3cULL, 0x000000321900720cULL, 0x080fe20002781470ULL,
0x00000001415c7824ULL, 0x000fe200078e0a4aULL, 0x000000323500720cULL, 0x000fc40001741470ULL,
0x000000323500720cULL, 0x080fe400037c1470ULL, 0x000000321c00720cULL, 0x080fe20002fa1470ULL,
0x00000001735e7824ULL, 0x100fe200078e0a4aULL, 0x000000675a667210ULL, 0x000fe20007ffe1ffULL,
0x0000000171607824ULL, 0x100fe400078e0a4aULL, 0x000000016f627824ULL, 0x000fe200078e0a4aULL,
0x000000321500720cULL, 0x080fe20000f21070ULL, 0x00000001773c7824ULL, 0x100fe200078e0a5aULL,
0x000000321500720cULL, 0x000fe20000701070ULL, 0x00000001344a7824ULL, 0x000fe200078e0a5aULL,
0x00000058465a7219ULL, 0x000fc400000006ffULL, 0x000000325b00720cULL, 0x080fe40001f61070ULL,
0x000000325f00720cULL, 0x080fe40002781070ULL, 0x000000323700720cULL, 0x0c0fe40001741070ULL,
0x000000323700720cULL, 0x080fe400037c1070ULL, 0x000000327b00720cULL, 0x000fe40002fa1070ULL,
0x0000004c464c7219ULL, 0x000fc400000006ffULL, 0x0000005c46587219ULL, 0x000fe400000006ffULL,
0x0000541045457816ULL, 0x020fe4000000003eULL, 0x000054104f4f7816ULL, 0x000fe40000000040ULL,
0xff80000039397808ULL, 0x000fe40000800000ULL, 0xff8000003b3b7808ULL, 0x000fe40000000000ULL,
0xff80000054547808ULL, 0x000fc40001800000ULL, 0xff80000055557808ULL, 0x000fe40002000000ULL,
0xff80000050507808ULL, 0x000fe40001000000ULL, 0xff80000052527808ULL, 0x000fe40003000000ULL,
0xff80000025257808ULL, 0x000fe40002800000ULL, 0x0000003d4cff7212ULL, 0x080fe4000782c0ffULL,
0x0000003d4eff7212ULL, 0x000fc4000780c0ffULL, 0x0000003d5aff7212ULL, 0x000fe4000786c0ffULL,
0x000000434cff7212ULL, 0x080fe4000788c0ffULL, 0x000000435aff7212ULL, 0x000fe4000784c0ffULL,
0x0000004558ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004f58ff7212ULL, 0x000fe400078ac0ffULL,
0x000000324200720cULL, 0x000fc40000f21470ULL, 0x000000324200720cULL, 0x080fe40002781470ULL,
0x000000321c00720cULL, 0x080fe40000701470ULL, 0x000000321600720cULL, 0x0c0fe40001f61470ULL,
0x000000321600720cULL, 0x080fe40001741470ULL, 0x000000324100720cULL, 0x0c0fe400037c1470ULL,
0x000000324100720cULL, 0x000fc40002fa1470ULL, 0x000000327d00720cULL, 0x0c0fe40000f21070ULL,
0x000000327d00720cULL, 0x080fe40002781070ULL, 0x000000327b00720cULL, 0x080fe40000701070ULL,
0x000000327900720cULL, 0x0c0fe40001f61070ULL, 0x000000327900720cULL, 0x080fe40001741070ULL,
0x000000323f00720cULL, 0x000fc400037c1070ULL, 0x000000323f00720cULL, 0x000fe40002fa1070ULL,
0x0000005e465e7219ULL, 0x040fe400000006ffULL, 0x0000006046607219ULL, 0x040fe400000006ffULL,
0x0000006246627219ULL, 0x000fe400000006ffULL, 0x0000541017147816ULL, 0x000fe40000000014ULL,
0xff80000051517808ULL, 0x000fc40000800000ULL, 0xff80000053537808ULL, 0x000fe40002000000ULL,
0xff8000001a1a7808ULL, 0x000fe40000000000ULL, 0xff80000024247808ULL, 0x000fe40001800000ULL,
0xff80000027277808ULL, 0x000fe40001000000ULL, 0xff80000029297808ULL, 0x000fe40003000000ULL,
0xff80000028287808ULL, 0x000fc40002800000ULL, 0x000000455eff7212ULL, 0x080fe4000782c0ffULL,
0x0000004560ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004562ff7212ULL, 0x000fe4000780c0ffULL,
0x0000004f5eff7212ULL, 0x080fe4000786c0ffULL, 0x0000004f60ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004f62ff7212ULL, 0x000fc400078cc0ffULL, 0x0000001464ff7212ULL, 0x000fe400078ac0ffULL,
0x000000327300720cULL, 0x0c0fe40000f21470ULL, 0x000000327300720cULL, 0x080fe40001f61470ULL,
0x000000327100720cULL, 0x0c0fe40002781470ULL, 0x000000327100720cULL, 0x080fe40001741470ULL,
0x000000326f00720cULL, 0x000fc40000701470ULL, 0x000000326f00720cULL, 0x080fe400037c1470ULL,
0x000000324d00720cULL, 0x080fe40002fa1470ULL, 0x000000326d00720cULL, 0x0c0fe40000f21070ULL,
0x000000326d00720cULL, 0x080fe40001f61070ULL, 0x000000326b00720cULL, 0x0c0fe40002781070ULL,
0x000000326b00720cULL, 0x000fc40001741070ULL, 0x000000326900720cULL, 0x0c0fe40000701070ULL,
0x000000326900720cULL, 0x080fe400037c1070ULL, 0x000000324700720cULL, 0x000fe40002fa1070ULL,
0x0000006646667219ULL, 0x040fe400000006ffULL, 0x0000003c463c7219ULL, 0x040fe400000006ffULL,
0x0000004a464a7219ULL, 0x000fc400000006ffULL, 0x00005410181d7816ULL, 0x000fe4000000001dULL,
0xff8000002a2a7808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40002000000ULL, 0xff80000022227808ULL, 0x000fe40001000000ULL,
0xff80000021217808ULL, 0x000fc40000000000ULL, 0xff80000023237808ULL, 0x000fe40003000000ULL,
0xff80000030307808ULL, 0x000fe40002800000ULL, 0x0000001466ff7212ULL, 0x080fe4000782c0ffULL,
0x000000143cff7212ULL, 0x080fe4000786c0ffULL, 0x000000144aff7212ULL, 0x000fe4000788c0ffULL,
0x0000001d64ff7212ULL, 0x000fc4000784c0ffULL, 0x0000001d66ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001d3cff7212ULL, 0x080fe400078cc0ffULL, 0x0000001d4aff7212ULL, 0x000fe400078ac0ffULL,
0x000000324d00720cULL, 0x080fe40001741470ULL, 0x000000326700720cULL, 0x0c0fe40000f21470ULL,
0x000000326700720cULL, 0x000fc40000701470ULL, 0x000000327700720cULL, 0x0c0fe40001f61470ULL,
0x000000327700720cULL, 0x080fe400037c1470ULL, 0x000000323400720cULL, 0x0c0fe40002781470ULL,
0x000000323400720cULL, 0x080fe40002fa1470ULL, 0x000000324700720cULL, 0x080fe40001741070ULL,
0x000000326500720cULL, 0x000fc40000f21070ULL, 0x000000326500720cULL, 0x080fe40000701070ULL,
0x000000326300720cULL, 0x0c0fe40001f61070ULL, 0x000000326300720cULL, 0x080fe400037c1070ULL,
0x000000325900720cULL, 0x0c0fe40002781070ULL, 0x000000325900720cULL, 0x000fe40002fa1070ULL,
0xff80000031317808ULL, 0x000fc40000800000ULL, 0xff8000002c2c7808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff8000001e1e7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40000000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fce0002800000ULL, 0x0000001b1000720bULL, 0x004fe20003f1e000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000303037812ULL, 0x000fe200078ec0ffULL,
0x000000ffff4a7224ULL, 0x000fe200078e006aULL, 0x000000101b107208ULL, 0x000fe40004000000ULL,
0xfffffff8ff047812ULL, 0x000fe400078ee204ULL, 0x000000391000720bULL, 0x000fc80003f1e000ULL,
0x0000001039097208ULL, 0x000fc80004000000ULL, 0x000000540900720bULL, 0x000fc80003f1e000ULL,
0x0000000954107208ULL, 0x000fc80004000000ULL, 0x000000551000720bULL, 0x000fc80003f1e000ULL,
0x0000001055097208ULL, 0x000fc80004000000ULL, 0x000000500900720bULL, 0x000fc80003f1e000ULL,
0x0000000950107208ULL, 0x000fc80004000000ULL, 0x000000511000720bULL, 0x000fc80003f1e000ULL,
0x0000001051097208ULL, 0x000fc80004000000ULL, 0x0000001a0900720bULL, 0x000fc80003f1e000ULL,
0x000000091a097208ULL, 0x000fc80004000000ULL, 0x000000240900720bULL, 0x000fc80003f1e000ULL,
0x0000000924107208ULL, 0x000fc80004000000ULL, 0x000000291000720bULL, 0x000fc80003f1e000ULL,
0x0000001029097208ULL, 0x000fc80004000000ULL, 0x0000002a0900720bULL, 0x000fc80003f1e000ULL,
0x000000092a107208ULL, 0x000fc80004000000ULL, 0x0000002b1000720bULL, 0x000fc80003f1e000ULL,
0x000000102b107208ULL, 0x000fe40004000000ULL, 0x0000003a1100720bULL, 0x000fe40003f1e000ULL,
0x000000211000720bULL, 0x000fc80003f3e000ULL, 0x0000001021097208ULL, 0x000fe40004800000ULL,
0x000000113a107208ULL, 0x000fe40004000000ULL, 0x000000300900720bULL, 0x000fe40003f3e000ULL,
0x0000003b1000720bULL, 0x000fe40003f1e000ULL, 0x0000000930147208ULL, 0x000fe40004800000ULL,
0x000000103b097208ULL, 0x000fc40004000000ULL, 0x000000311400720bULL, 0x000fe40003f3e000ULL,
0x000000560900720bULL, 0x000fe40003f1e000ULL, 0x0000001431117208ULL, 0x000fe40004800000ULL,
0x0000000956107208ULL, 0x000fe40004000000ULL, 0x0000002c1100720bULL, 0x000fe40003f3e000ULL,
0x000000571000720bULL, 0x000fc40003f1e000ULL, 0x000000112c147208ULL, 0x000fe40004800000ULL,
0x0000001057097208ULL, 0x000fe40004000000ULL, 0x0000002d1400720bULL, 0x000fe40003f3e000ULL,
0x000000520900720bULL, 0x000fe40003f1e000ULL, 0x000000142d147208ULL, 0x000fe40004800000ULL,
0x0000000952107208ULL, 0x000fc60004000000ULL, 0x0c401f0014117f89ULL, 0x000ea200000e0000ULL,
0x000000531000720bULL, 0x000fc80003f1e000ULL, 0x0000001053107208ULL, 0x000fc80004000000ULL,
0x000000251000720bULL, 0x000fc80003f1e000ULL, 0x0000001025107208ULL, 0x000fc80004000000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027097208ULL, 0x000fe40004000000ULL,
0x000000111400720bULL, 0x004fe40003f3e000ULL, 0x000000280900720bULL, 0x000fe40003f1e000ULL,
0x0000001411117208ULL, 0x000fe40004800000ULL, 0x0000000928097208ULL, 0x000fc60004000000ULL,
0x0c201f0011147f89ULL, 0x000ea200000e0000ULL, 0x000000260900720bULL, 0x000fc80003f1e000ULL,
0x0000000926097208ULL, 0x000fc80004000000ULL, 0x000000220900720bULL, 0x000fc80003f1e000ULL,
0x0000000922107208ULL, 0x000fc80004000000ULL, 0x000000231000720bULL, 0x000fc80003f1e000ULL,
0x0000001023097208ULL, 0x000fe40004000000ULL, 0x000000141100720bULL, 0x004fe40003f3e000ULL,
0x0000001e0900720bULL, 0x000fe40003f1e000ULL, 0x0000001114107208ULL, 0x000fe40004800000ULL,
0x000000091e147208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b10167820ULL, 0x000fe20000410000ULL,
0x0000001f1400720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b291c7823ULL, 0x100fe20000010816ULL,
0x000000141f097208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2b297823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b54547823ULL, 0x100fe20000010816ULL,
0x0000002e0900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010816ULL,
0x000000092e147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL,
0x0000001a00327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2a1d7823ULL, 0x100fe20000010816ULL,
0x0000002f1400720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2c2a7823ULL, 0x000fe20000010816ULL,
0x00000004ff2c7e24ULL, 0x000fc4000f8e00ffULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL,
0x000000142f147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010816ULL,
0x0000002400337308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b51517823ULL, 0x000fe20000010816ULL,
0x3f8000002c2c783eULL, 0x000fe200000010ffULL, 0x0c401f0014097f89ULL, 0x000ea800000e0000ULL,
0x000000ffff377224ULL, 0x000fe200078e002cULL, 0x0000001b001b7308ULL, 0x000ff00000000800ULL,
0x0000003900187308ULL, 0x000ff00000000800ULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x000000091400720bULL, 0x004fc80003f1e000ULL, 0x0000001409117208ULL, 0x000fc60004000000ULL,
0x0000005500557308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b30097823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b31307823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b2d167823ULL, 0x000fe20000010816ULL,
0x0c201f0011147f89ULL, 0x000ee200000e0000ULL, 0x000000ffff2d7224ULL, 0x000fc600078e002cULL,
0x0000002100347308ULL, 0x000ff00000000800ULL, 0x0000001600217308ULL, 0x0005f00000000800ULL,
0x0000005000507308ULL, 0x000fe20000000800ULL, 0x000000545516723eULL, 0x004fc400000010ffULL,
0x000000141100720bULL, 0x008fc80003f1e000ULL, 0x0000001114117208ULL, 0x000fe20004000000ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x0000001b1814723eULL, 0x000fc600000010ffULL,
0x3fb8aa3b112b7820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b56567823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b57577823ULL, 0x100fe2000001082bULL, 0x0000003a00157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b52527823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b53537823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b26357823ULL, 0x100fe2000001082bULL, 0x000000323326723eULL, 0x000fe200000010ffULL,
0x3fb8aa3b23327823ULL, 0x100fe2000001082bULL, 0x0000003b001a7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001082bULL, 0x0c401f0012237f89ULL, 0x000ee200000e0000ULL,
0x3fb8aa3b1f337823ULL, 0x100fe2000001082bULL, 0x3fb8aa3b2e2e7823ULL, 0x000fc8000001082bULL,
0x0000005600177308ULL, 0x000fe20000000800ULL, 0x000000151a15723eULL, 0x004fce00000010ffULL,
0x0000005700247308ULL, 0x000eb00000000800ULL, 0x0000002500317308ULL, 0x000fe20000000800ULL,
0x000000231200720bULL, 0x008fc80003f1e000ULL, 0x0000001223127208ULL, 0x000fe40004000000ULL,
0x000000172417723eULL, 0x004fe200000010ffULL, 0x0000002700367308ULL, 0x000ea20000000800ULL,
0x000000505124723eULL, 0x000fca00000010ffULL, 0x0000002c1418723cULL, 0x000fe400000418ffULL,
0x0000005200527308ULL, 0x000fea0000000800ULL, 0x3fb8aa3b222d7823ULL, 0x000fe2000001082bULL,
0x000000313627723eULL, 0x004fe400000010ffULL, 0x0000005300537308ULL, 0x000ea20000000800ULL,
0x000000ffff367224ULL, 0x000fc400078e002cULL, 0x3fb8aa3b1e317823ULL, 0x100fe2000001082bULL,
0x3fb8aa3b2f2b7823ULL, 0x000fe2000001082bULL, 0x0c401f0013227f89ULL, 0x000ee600000e0000ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x000000525325723eULL, 0x004fce00000010ffULL,
0x0000001d001d7308ULL, 0x000ea20000000800ULL, 0x000000362418723cULL, 0x000fee0000041818ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x000000221300720bULL, 0x008fe40003f3e000ULL,
0x0000001c1d1c723eULL, 0x004fca00000010ffULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x0000001322137208ULL, 0x000fe20004800000ULL, 0x000008000f227824ULL, 0x000fc800078e0207ULL,
0x0001100022227836ULL, 0x000fe40000000000ULL, 0x0000002900297308ULL, 0x000ee20000000800ULL,
0x0000002d321f723eULL, 0x004fce00000010ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000002c002d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff327224ULL, 0x000fe200078e002cULL,
0x00000029341e723eULL, 0x008fca00000010ffULL, 0x0000003500357308ULL, 0x000eb00000000800ULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x00000028351d723eULL, 0x004fce00000010ffULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x0000002c1c18723cULL, 0x000fee0000041818ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x00000008042d7836ULL, 0x000fe20000000000ULL,
0x000000093028723eULL, 0x004fcc00000010ffULL, 0x0000002b002b7308ULL, 0x000ea20000000800ULL,
0x0000000103097824ULL, 0x000fe400078e0204ULL, 0x0000000804307824ULL, 0x000fe400078e00ffULL,
0x0000000c092f7836ULL, 0x000fe20000000000ULL, 0x0000000409237810ULL, 0x000fe40007ffe0ffULL,
0x0000002a002a7308ULL, 0x000ee40000000800ULL, 0xfffffff830237812ULL, 0x000fc400078ee223ULL,
0x0000001c00307202ULL, 0x000fe20000000f00ULL, 0x000000ffff1c7224ULL, 0x000fe200078e001dULL,
0x0000002e2b2b723eULL, 0x004fe400000010ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x00000008042e7824ULL, 0x000fe400078e00ffULL, 0x0c201f0013047f89ULL, 0x000ea200000e0000ULL,
0x0000001023237824ULL, 0x000fe400078e0222ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001fULL,
0x0000002a212a723eULL, 0x008fe200000010ffULL, 0x0000003300367308ULL, 0x0007220000000800ULL,
0xfffffff82e217812ULL, 0x000fe200078ee209ULL, 0x00000001032e7824ULL, 0x000fc400078e022dULL,
0x0c201f0012037f89ULL, 0x000f6200000e0000ULL, 0x000000082d097824ULL, 0x000fe200078e00ffULL,
0x0000002221217211ULL, 0x000fe200078e20ffULL, 0x000000ffff1f7224ULL, 0x000fe400078e002bULL,
0x000000ffff337224ULL, 0x008fe200078e002cULL, 0xfffffff809097812ULL, 0x000fe200078ee22eULL,
0x000000082d2c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0016ULL,
0x0000002500167202ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0024ULL,
0x000000313629723eULL, 0x010fe200000010ffULL, 0x000000ffff317224ULL, 0x000fe200078e001eULL,
0xfffffff82c357812ULL, 0x000fe200078ee22fULL, 0x000000ffff2c7224ULL, 0x000fe200078e0014ULL,
0x000000041300720bULL, 0x004fe20003f3e000ULL, 0x000000ffff2f7224ULL, 0x000fc400078e0026ULL,
0x000000322818723cULL, 0x000fe20000041818ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000001304137208ULL, 0x000fe20004800000ULL, 0x000000ffff157224ULL, 0x000fe200078e0017ULL,
0x0000002c21007844ULL, 0x0005e20000000200ULL, 0x000000031200720bULL, 0x022fe20003f1e000ULL,
0x0000001009097824ULL, 0x000fe400078e0222ULL, 0x000000ffff327224ULL, 0x000fe200078e0028ULL,
0x0000001203127208ULL, 0x000fe20004000000ULL, 0x000000ffff337224ULL, 0x000fe200078e002aULL,
0x0000000308ff7812ULL, 0x000fe2000780c0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0027ULL,
0x0000000100037802ULL, 0x000fe20000000f00ULL, 0x0000001035357824ULL, 0x000fe200078e0222ULL,
0x0000003023007844ULL, 0x0005e20000000200ULL, 0x000000ffff1e7224ULL, 0x000fc600078e0029ULL,
0x0000001409007844ULL, 0x0005e80000000200ULL, 0x0000001c35007844ULL, 0x0005e20000000200ULL,
0x000000ffff197224ULL, 0x000fc600078e001aULL, 0x01b0001020008388ULL, 0x0005e80000000c00ULL,
0x01b2001820008388ULL, 0x0005e20000000a00ULL, 0x000000056a00720cULL, 0x000fe20003f06070ULL,
0x01b608030eff79a7ULL, 0x0005e2000850003fULL, 0x01b610030eff79a7ULL, 0x0005e2000850003fULL,
0x01b618030eff79a7ULL, 0x0005e2000850003fULL, 0x01b620030eff79a7ULL, 0x0005f2000850003fULL,
0xffffff9800e88947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000004027836ULL, 0x000fe20000000000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x7f80000002057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000400028308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000205ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000004047812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000205ff7212ULL, 0x000fda000780c0ffULL,
0x0080000004020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0004ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000400027308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x006fe400078e000dULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffffec804007950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000495ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000210ULL, 0x0000001400000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000000f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000918ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000096cULL, 0x0000000000000470ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000de0ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000de0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000e28ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000013900ULL, 0x0000001400000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014780ULL, 0x000000000000003cULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000147c0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000147c0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000014db0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000014db0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000e28ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013900ULL,
0x0000000000013900ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014780ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000147c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_16_sm_90_cubin_len = 85760;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
