/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017040ULL, 0x0000000000016cc0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x766e5f5f34314944ULL, 0x3174616f6c66625fULL, 0x6a4c45326a4c3236ULL, 0x4c49746132454538ULL,
0x534b524545453062ULL, 0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL,
0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x454536316a4c4536ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x34366a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL,
0x614d6e4974736e49ULL, 0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45346a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL,
0x6a4c4545346a4c6aULL, 0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x4c6a496365563349ULL, 0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL,
0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL,
0x70776f6c735f3233ULL, 0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL,
0x735f30376d735f61ULL, 0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL,
0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL,
0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL,
0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL,
0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL,
0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL,
0x612e6c65722e766eULL, 0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c0001000001c2ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000208ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c00010000024fULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000295ULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000002e3ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000331ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b0022000003bdULL, 0x0000000000015430ULL, 0x0000000000000190ULL,
0x000b0022000003f0ULL, 0x00000000000155c0ULL, 0x0000000000000040ULL, 0x000b00220000041bULL,
0x0000000000015600ULL, 0x0000000000000050ULL, 0x000b002200000445ULL, 0x0000000000015650ULL,
0x0000000000000130ULL, 0x000a0003000004b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000004d3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000503ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000015780ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001543000000000ULL, 0x0000040400000000ULL,
0x810c000001740400ULL, 0x00538c0400288080ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8508288080840828ULL, 0x2880808e08288080ULL, 0x8099082880808f08ULL,
0x082880809a082880ULL, 0x8080a608288080a5ULL, 0x8016288080860828ULL, 0x0000000310288082ULL,
0x8086920000000000ULL, 0x0000000022002880ULL, 0x00000044ffffffffULL, 0x0000007000000000ULL,
0x0001543000000000ULL, 0x0000019000000000ULL, 0x0000480400000000ULL, 0x8084288080850900ULL,
0x0900000010042880ULL, 0x2880808d28808084ULL, 0x8086090000000404ULL, 0x0000288080842880ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL,
0x808e082880808708ULL, 0x082880808f082880ULL, 0x80809a0828808099ULL, 0xa608288080a50828ULL,
0x2880808c08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880808cULL,
0x0000001cffffffffULL, 0x0000013800000000ULL, 0x000155c000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080840828ULL,
0x2880808608288080ULL, 0x8099082880808e08ULL, 0x082880809a082880ULL, 0x8080a608288080a5ULL,
0x80162880808f0828ULL, 0x0000000310288082ULL, 0x808f920000000000ULL, 0x0000000022002880ULL,
0x0000002cffffffffULL, 0x000001e000000000ULL, 0x0001560000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x808e2880808f0900ULL, 0x0000000000002880ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL, 0x8099082880808f08ULL,
0x082880809a082880ULL, 0x8080a608288080a5ULL, 0x80162880808e0828ULL, 0x0000000310288082ULL,
0x808e920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000029000000000ULL,
0x0001565000000000ULL, 0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001800082f04ULL,
0x0008230400000080ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL, 0x0000000000000018ULL,
0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0060016000000015ULL, 0x000c170400601903ULL, 0x0058000a00000000ULL,
0x000c17040021f000ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040011f000ULL, 0x0030000700000000ULL, 0x000c17040061f000ULL, 0x0028000600000000ULL,
0x000c17040021f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0x00000b2000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000033001542804ULL, 0x000005a0000003a0ULL, 0x00002ac000001af0ULL,
0x00002c8000002b60ULL, 0x00002ff000002de0ULL, 0x0000309000003020ULL, 0x0000374000003100ULL,
0x000046b000004610ULL, 0x00004940000047e0ULL, 0x00004b8000004b50ULL, 0x00004c6000004bf0ULL,
0x00005f80000050c0ULL, 0x0000615000006020ULL, 0x000064c0000062b0ULL, 0x00006560000064f0ULL,
0x00006a80000065d0ULL, 0x00007a2000007990ULL, 0x00007cb000007b50ULL, 0x00007ef000007ec0ULL,
0x00007fd000007f60ULL, 0x0000854000008530ULL, 0x0000a9a00000a930ULL, 0x0000b1000000b0c0ULL,
0x000139a000013960ULL, 0x000139c0000139b0ULL, 0x00013a3000013a10ULL, 0x00013a6000013a50ULL,
0x0001475000014700ULL, 0x00014820000147c0ULL, 0x0001490000014890ULL, 0x000149b000014960ULL,
0x00014a8000014a20ULL, 0x00014b6000014af0ULL, 0x00014c1000014bc0ULL, 0x00014ce000014c80ULL,
0x00014dc000014d50ULL, 0x00014e7000014e20ULL, 0x00014f4000014ee0ULL, 0x0001502000014fb0ULL,
0x0001511000015090ULL, 0x0001521000015190ULL, 0x0001531000015290ULL, 0x0001541000015390ULL,
0x0000044002003904ULL, 0x0001b600000000ffULL, 0x00000490003f0100ULL, 0x0001b60800000011ULL,
0x00000540003f0120ULL, 0x0001b68800000011ULL, 0x00000b80003f0120ULL, 0x0001b600000000ffULL,
0x00000ca0003f0107ULL, 0x0001b68c00000071ULL, 0x00000d30003f0102ULL, 0x0001b68800000071ULL,
0x000027b0003f0101ULL, 0x0001b60800000030ULL, 0x000027f0003f0101ULL, 0x0001b60c00000009ULL,
0x000029c0003f0105ULL, 0x0001b60c00000009ULL, 0x00003700003f0105ULL, 0x0001b6880000000cULL,
0x00004350003f0101ULL, 0x0001b6280000000bULL, 0x00004370003f0101ULL, 0x0001b62c0000000bULL,
0x00004540003f0105ULL, 0x0001b62c0000000bULL, 0x00005080003f0105ULL, 0x000000000000000cULL,
0x00005cc0003f0101ULL, 0x0001b64800000008ULL, 0x00005ce0003f0101ULL, 0x0001b64c00000008ULL,
0x00005eb0003f0105ULL, 0x0001b64c00000008ULL, 0x00006a60003f0105ULL, 0x000000000000000cULL,
0x000076e0003f0101ULL, 0x0001b6680000000aULL, 0x00007700003f0101ULL, 0x0001b66c0000000aULL,
0x000078d0003f0105ULL, 0x0001b66c0000000aULL, 0x000083a0003f0105ULL, 0x0000000000000000ULL,
0x0000c230003f0101ULL, 0x0001b600000000ffULL, 0x0000da80003f0101ULL, 0x0001b604000000ffULL,
0x0000dc90003f0105ULL, 0x0001b604000000ffULL, 0x00011ca0003f0105ULL, 0x0000000000000072ULL,
0x00011df0003f0101ULL, 0x0000000400000072ULL, 0x00011fc0003f0105ULL, 0x0000000400000072ULL,
0x00014550003f0105ULL, 0x0001b60800000073ULL, 0x000145b0003f0101ULL, 0x0001b61000000073ULL,
0x00014610003f0101ULL, 0x0001b61800000073ULL, 0x00014680003f0101ULL, 0x0001b62000000073ULL,
0x00033803003f0101ULL, 0x0000b94000201c04ULL, 0x0000bc000000b970ULL, 0x0000bff00000bdf0ULL,
0x0000dcf00000c1a0ULL, 0x00000401000146c0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000031cULL,
0x0000001800000002ULL, 0x000000000000026cULL, 0x0000001800000002ULL, 0x00000000000001ccULL,
0x0000001800000002ULL, 0x00000000000000fcULL, 0x0000001800000002ULL, 0x0000000000000044ULL,
0x0000001800000002ULL, 0x00000000000002f5ULL, 0x0000001800000002ULL, 0x0000000000000245ULL,
0x0000001800000002ULL, 0x00000000000001a7ULL, 0x0000001800000002ULL, 0x00000000000000d5ULL,
0x0000001800000002ULL, 0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002700ULL,
0x00005c00ff007a0cULL, 0x000fe20003f05070ULL, 0x0000460000067ab9ULL, 0x000fc60000000a00ULL,
0x00005d00ff007a0cULL, 0x000fda0003f05300ULL, 0x00000004ff040424ULL, 0x000fe200078e00ffULL,
0x0000000109020810ULL, 0x002fca0007ffe0ffULL, 0x00005c0002020625ULL, 0x000fc800078e0004ULL,
0x00005c0009040625ULL, 0x000fe200078e0004ULL, 0x00000006020d0981ULL, 0x0002a8000c1e1900ULL,
0x0000000604080981ULL, 0x0006a2000c1e1900ULL, 0x0000590000007b06ULL, 0x000f220000209000ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f65070ULL,
0x0000000000747919ULL, 0x000e620000002600ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x00005a00ff137624ULL, 0x000fc800078e00ffULL, 0x0000590013137a24ULL, 0x000fe200078e02ffULL,
0x0000000000007308ULL, 0x010f240000001000ULL, 0x0ffffffe00077810ULL, 0x010fcc0007ffe0ffULL,
0x0000000700077305ULL, 0x000f24000021f000ULL, 0x000000ffff0b7224ULL, 0x010fc800078e0a07ULL,
0x000059000b0b7a24ULL, 0x000fc800078e02ffULL, 0x0000000b07067227ULL, 0x000fe400078e0006ULL,
0x0000000000077919ULL, 0x000f280000002300ULL, 0x00000400060f7a27ULL, 0x000fc800078e00ffULL,
0x00005900ff067624ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x002fc800078e0a0fULL,
0x0000040003007624ULL, 0x000fca00078e0206ULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x8000590000001a10ULL, 0x000fe40007ffe0ffULL, 0x000000010f0f1810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f46070ULL, 0x000000010f0f2810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff0fba12ULL, 0x000fc800078e33ffULL, 0x0000000f00007306ULL, 0x000e620000209000ULL,
0x000000ff0f00720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002e4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000030f047224ULL, 0x008fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000f240000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000007403737227ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000e640000002100ULL, 0x000000ffff007224ULL, 0x000fc800078e0a73ULL,
0x000000000f007224ULL, 0x000fca00078e0274ULL, 0x0000000f0000720cULL, 0x040fe20003f66070ULL,
0x0000010007027a24ULL, 0x010fe400078e0204ULL, 0x00001fff07077589ULL, 0x000ff400000e0000ULL,
0x0000000100003824ULL, 0x000fe200078e0a0fULL, 0x0000000173733810ULL, 0x000fe20007ffe0ffULL,
0x0000000002117a24ULL, 0x102fe200078e0203ULL, 0x00000005ff027819ULL, 0x000fc40000011603ULL,
0x0000000f0000720cULL, 0x000fe40003f86070ULL, 0x000000ff1100720cULL, 0x040fe40003f25270ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000000f1100780cULL, 0x040fe40003f44070ULL,
0x000000031100780cULL, 0x000fcc0003f64070ULL, 0x0000000173734810ULL, 0x000fe40007ffe0ffULL,
0x0000000fff73d212ULL, 0x000fe200078e33ffULL, 0x3fffff80ff049424ULL, 0x000fe200078e00ffULL,
0x0000007f1100780cULL, 0x000fe20003f84070ULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe400078e0a73ULL, 0x3fffffc0ff0aa424ULL, 0x000fe200078e00ffULL,
0x01b60004ff009388ULL, 0x0007e20000000a00ULL, 0x0000000c0f747224ULL, 0x000fc400078e0274ULL,
0x7fffffc0ff0ba424ULL, 0x000fe400078e00ffULL, 0x0000001074747824ULL, 0x000fe400078e00ffULL,
0xff317217ff0ec424ULL, 0x000fe200078e00ffULL, 0x01b6080a1100a388ULL, 0x000fe20000008a00ULL,
0x3fffff60ff0cb424ULL, 0x000fc600078e00ffULL, 0x01b4000e1100c388ULL, 0x000fe20000004800ULL,
0x000000010d000824ULL, 0x004fe400078e0a08ULL, 0x00005800ff008624ULL, 0x000fe400078e00ffULL,
0x0000580009088a24ULL, 0x000fe400078e02ffULL, 0x00005a0000037a24ULL, 0x000fe400078e02ffULL,
0x7fffff60ff0db424ULL, 0x000fe400078e00ffULL, 0x0000000103047824ULL, 0x048fe200078e0a74ULL,
0x000000740300720cULL, 0x000fe20003f26070ULL, 0x0000001308767224ULL, 0x000fe200078e02ffULL,
0x01b6880c1100b388ULL, 0x000fe20000008a00ULL, 0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000001004047817ULL, 0x000fe20003800000ULL, 0x00005a0073127a24ULL, 0x000fc600078e0276ULL,
0x000000ff04757207ULL, 0x000fe20000800000ULL, 0x0000000407047824ULL, 0x002fe200078e0202ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107500780cULL, 0x000fe20003f05270ULL,
0x00000002040c7824ULL, 0x000fd800078e00ffULL, 0x000002c000008947ULL, 0x000fea0003800000ULL,
0x00005a0000057b06ULL, 0x000e620000209000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x00005a00ff007a0cULL, 0x000fcc0003f45070ULL, 0x0000000500057308ULL, 0x002e620000001000ULL,
0x00000004ff0d7819ULL, 0x004fca0000011604ULL, 0x000000010c0f7824ULL, 0x000fe200078e020dULL,
0x0ffffffe050a7810ULL, 0x002fc60007ffe0ffULL, 0x0000000174057824ULL, 0x000fe200078e020fULL,
0x0000000a000b7305ULL, 0x0002a4000021f000ULL, 0x000000ffff0a7224ULL, 0x002fe400078e00ffULL,
0x000000ffff117224ULL, 0x004fc800078e0a0bULL, 0x00005a0011117a24ULL, 0x000fc800078e02ffULL,
0x000000110b0e7227ULL, 0x000fe200078e000aULL, 0x0000000c750b7217ULL, 0x000fca0007800000ULL,
0x000000050e0e7227ULL, 0x000fc800078e00ffULL, 0x000000ffff107224ULL, 0x000fe400078e0a0eULL,
0x000000010b0c7824ULL, 0x000fe400078e0a0cULL, 0x00005a00100a7a24ULL, 0x000fca00078e0205ULL,
0x00005a000a007a0cULL, 0x000fda0003f06070ULL, 0x80005a000a0a0a10ULL, 0x000fe40007ffe0ffULL,
0x000000010e0e0810ULL, 0x000fe40007ffe0ffULL, 0x00005a000a007a0cULL, 0x000fe40003f26070ULL,
0x0000000c0d00720cULL, 0x000fe20003f06070ULL, 0x000000010f0c7824ULL, 0x040fe400078e0204ULL,
0x000000100f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff00f0c7812ULL, 0x000fc600078ee20cULL,
0x000000010e0e1810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff0eaa12ULL, 0x000fe200078e33ffULL,
0x000000100c0d7824ULL, 0x000fc800078e00ffULL, 0x000000ffff0a7224ULL, 0x000fc800078e0a0eULL,
0x00005a000a057a24ULL, 0x000fc800078e0205ULL, 0x0000000112057824ULL, 0x000fc800078e0205ULL,
0x000000130e0a7224ULL, 0x000fe400078e0205ULL, 0x0000001004057824ULL, 0x000fe400078e00ffULL,
0x000001000a0a7825ULL, 0x000fc600078e00ffULL, 0x000000f005117812ULL, 0x000fc800078ec0ffULL,
0x000000110a117212ULL, 0x000fc800078efcffULL, 0x00006000110a7a10ULL, 0x000fc80007f3e0ffULL,
0x000061000b0b7a10ULL, 0x000fca0000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c46ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00005a00000e7b06ULL, 0x000e620000209000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00005a00ff007a0cULL, 0x000fca0003f45070ULL,
0x0000000e000e7308ULL, 0x002e620000001000ULL, 0x0000000c040d7211ULL, 0x004fe400078fe0ffULL,
0x0ffffffe0e0b7810ULL, 0x002fcc0007ffe0ffULL, 0x0000000b000b7305ULL, 0x000e64000021f000ULL,
0x000000ffff057224ULL, 0x002fc800078e0a0bULL, 0x00005a0005057a24ULL, 0x000fc800078e02ffULL,
0x000000050b0a7227ULL, 0x000fc800078e000aULL, 0x0000000174057824ULL, 0x000fc800078e020dULL,
0x000000050a0a7227ULL, 0x000fc800078e00ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e0a0aULL,
0x00005a000c0b7a24ULL, 0x000fca00078e0205ULL, 0x00005a000b007a0cULL, 0x000fda0003f06070ULL,
0x80005a000b0b0a10ULL, 0x000fe40007ffe0ffULL, 0x000000010a0a0810ULL, 0x000fe40007ffe0ffULL,
0x00005a000b007a0cULL, 0x000fda0003f26070ULL, 0x000000010a0a1810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff0aaa12ULL, 0x000fca00078e33ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e0a0aULL,
0x00005a000c057a24ULL, 0x000fe400078e0205ULL, 0x000000010d0c7824ULL, 0x040fe400078e0204ULL,
0x0000000112057824ULL, 0x000fe400078e0205ULL, 0x000000100d0d7824ULL, 0x000fe400078e00ffULL,
0x000000130a0a7224ULL, 0x000fe400078e0205ULL, 0x0000001004057824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0c7812ULL, 0x000fe200078ee20cULL, 0x000001000a0a7825ULL, 0x000fc600078e00ffULL,
0x000000f0050f7812ULL, 0x000fe200078ec0ffULL, 0x000000100c0d7824ULL, 0x000fc600078e00ffULL,
0x0000000f0a0a7212ULL, 0x000fc800078efcffULL, 0x000060000a0a7a10ULL, 0x000fc80007f1e0ffULL,
0x000061000b0b7a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e8000b901c46ULL, 0x00000000000c7919ULL, 0x000ea20000000000ULL,
0x00000000000a7806ULL, 0x002fe200038e0000ULL, 0x00000004ff587424ULL, 0x000fc600078e00ffULL,
0x0000000a000b7300ULL, 0x000ea200000e0000ULL, 0x0000660009667625ULL, 0x000fce00078e0058ULL,
0x0000000a000d7309ULL, 0x000e620000000000ULL, 0x0000000c0b00720cULL, 0x004fe40003f02070ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff0b7224ULL, 0x002fd400078e0a0dULL,
0x01b6040bffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000666667981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0700720cULL, 0x000fe40003f05270ULL, 0x000000ff665c7810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff5c7819ULL, 0x000fce000001165cULL, 0x0000b55000008947ULL, 0x000fea0003800000ULL,
0x0000000209097824ULL, 0x000fe400078e00ffULL, 0x0000000802717824ULL, 0x000fe400078e00ffULL,
0x00000003ff007424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b68c0071ff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000103077810ULL, 0x000fe20007ffe0ffULL, 0x00005900096c7624ULL, 0x000fe200078e0206ULL,
0x00000001ff0b7819ULL, 0x002fe20000011602ULL, 0x01b6880071ff7f8cULL, 0x0003e2000c80043fULL,
0x0000005c0700720cULL, 0x000fe20003f06070ULL, 0x00000001736c7824ULL, 0x000fe200078e026cULL,
0x0000000102697812ULL, 0x000fe200078ec0ffULL, 0x000000200b707824ULL, 0x000fc800078e00ffULL,
0x0000010003097824ULL, 0x000fc800078e0270ULL, 0x000068006c227a24ULL, 0x000fe400078e0209ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff177819ULL, 0x102fe40000011604ULL,
0x0000000966007217ULL, 0x004fe40007800000ULL, 0x0000000417077810ULL, 0x040fe40007ffe0ffULL,
0x0000000c17157810ULL, 0x040fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a09ULL,
0x00000008170f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107067824ULL, 0x100fe200078e0204ULL,
0x00000010171f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000807197824ULL, 0x000fe200078e00ffULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x0000000115097824ULL, 0x000fe200078e0204ULL,
0x0000001417237810ULL, 0x000fe20007ffe0ffULL, 0x00000008150a7824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee206ULL, 0x000000010f087824ULL, 0x000fe200078e0204ULL,
0x0000007005067812ULL, 0x000fe200078ec0ffULL, 0x000000080f1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a1d7812ULL, 0x000fe200078ee209ULL, 0x00000001220d7824ULL, 0x040fe200078e0207ULL,
0x000000000700720cULL, 0x080fe20003f86070ULL, 0x0000008069067824ULL, 0x000fe200078e0206ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee208ULL, 0x0000000122097824ULL, 0x000fe200078e0217ULL,
0x000000000f00720cULL, 0x080fe20003f66070ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000000001500720cULL, 0x080fe20003f46070ULL, 0x000000011f057824ULL, 0x000fe200078e0204ULL,
0x000000001700720cULL, 0x000fe20003fa6070ULL, 0x0000010009087825ULL, 0x000fe200078e0006ULL,
0x0000001c17277810ULL, 0x000fc60007ffe0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0006ULL,
0x0000640008107a10ULL, 0x000fc60007f1e0ffULL, 0x000000081f0e7824ULL, 0x000fe200078e00ffULL,
0x000064000c127a10ULL, 0x000fe20007f3e0ffULL, 0x00000001230a7824ULL, 0x000fe200078e0204ULL,
0x0000650009117a10ULL, 0x000fe200007fe4ffULL, 0x0000000122097824ULL, 0x040fe200078e020fULL,
0x000065000d137a10ULL, 0x000fe20000ffe4ffULL, 0x00000001220d7824ULL, 0x000fe200078e0215ULL,
0xfffffff80e217812ULL, 0x000fe200078ee205ULL, 0x0000010009087825ULL, 0x000fe200078e0006ULL,
0x000000001f00720cULL, 0x000fc60003f26070ULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0x0000640008147a10ULL, 0x000fe20007f1e0ffULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x0000000117057824ULL, 0x000fe200078e0204ULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x00000001220f7824ULL, 0x000fe200078e021fULL,
0x0000650009157a10ULL, 0x000fe200007fe4ffULL, 0x000000020b0a7824ULL, 0x000fe200078e0269ULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0006ULL,
0x000065000d0d7a10ULL, 0x000fe400037fe4ffULL, 0x000130000a0a7811ULL, 0x000fe200078e68ffULL,
0x0000000122097824ULL, 0x040fe200078e0223ULL, 0x0ffffff805057812ULL, 0x000fe200078ef804ULL,
0x0000000122297824ULL, 0x000fe200078e0227ULL, 0x000064000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x0000010009087825ULL, 0x000fe200078e0006ULL, 0x00000018171f7810ULL, 0x000fc40007ffe0ffULL,
0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x0000001005057824ULL, 0x100fe200078e020aULL,
0x000000002300720cULL, 0x080fe20003f06070ULL, 0x0000001019197824ULL, 0x100fe200078e020aULL,
0x0000640008167a10ULL, 0x000fe20007fde0ffULL, 0x0000000122237824ULL, 0x000fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010057faeULL, 0x0003e2000e901c46ULL,
0x000000001f00720cULL, 0x080fe20003fa6070ULL, 0x000000101b1b7824ULL, 0x000fe200078e020aULL,
0x0000650009177a10ULL, 0x000fe200037fe4ffULL, 0x0000010023087825ULL, 0x000fe200078e0006ULL,
0x0000000012197faeULL, 0x0005e2000e101c46ULL, 0x000000002700720cULL, 0x000fc40003f86070ULL,
0x000000011f007824ULL, 0x000fe200078e0204ULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x0000010029067825ULL, 0x000fe200078e0006ULL, 0x00000000141b7faeULL, 0x0005e4000d901c46ULL,
0x0000650009097a10ULL, 0x000fe200037fe4ffULL, 0x000000081f057824ULL, 0x002fe200078e00ffULL,
0x0000640006067a10ULL, 0x000fe20007fde0ffULL, 0x0000000127107824ULL, 0x040fe400078e0204ULL,
0x0000000827117824ULL, 0x000fe200078e00ffULL, 0xfffffff805057812ULL, 0x000fe200078ee200ULL,
0x000000101d1d7824ULL, 0x100fe200078e020aULL, 0x0000650007077a10ULL, 0x000fe200037fe4ffULL,
0x0000001021217824ULL, 0x000fe200078e020aULL, 0xfffffff811117812ULL, 0x000fe200078ee210ULL,
0x0000001025257824ULL, 0x100fe200078e020aULL, 0x000000000c1d7faeULL, 0x0005e2000d101c46ULL,
0x0000001005057824ULL, 0x000fc400078e020aULL, 0x0000001011117824ULL, 0x000fe200078e020aULL,
0x000000000e217faeULL, 0x0005e8000c901c46ULL, 0x0000000016257faeULL, 0x0005e8000c101c46ULL,
0x0000000008057faeULL, 0x0005e8000e901c46ULL, 0x0000000006117faeULL, 0x0005e2000e101c46ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x00000008040d7811ULL, 0x042fe400078fe8ffULL,
0x0000000404077811ULL, 0x000fc400078fe8ffULL, 0x0000000c040f7811ULL, 0x040fe200078fe8ffULL,
0x000000010d067824ULL, 0x140fe200078e0204ULL, 0x0000001804157811ULL, 0x040fe200078fe8ffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x0000001404137811ULL, 0x040fe200078fe8ffULL,
0x0000000107007824ULL, 0x004fe200078e0204ULL, 0x0000007005167812ULL, 0x000fe200078ec0ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0xfffffff811187812ULL, 0x000fe200078ee206ULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0x0000001004117811ULL, 0x000fe200078fe8ffULL,
0x0000000815207824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee200ULL,
0x000000010f007824ULL, 0x000fc400078e0204ULL, 0x0000000111067824ULL, 0x040fe400078e0204ULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0xfffffff8171a7812ULL, 0x000fe200078ee200ULL,
0x0000000115097824ULL, 0x100fe200078e0204ULL, 0x0000000404007211ULL, 0x040fe200078fe8ffULL,
0x0000000113087824ULL, 0x040fe200078e0204ULL, 0x0000001c04177811ULL, 0x000fe200078fe8ffULL,
0x00000008131b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8191c7812ULL, 0x000fe200078ee206ULL,
0x000000020b067824ULL, 0x000fe200078e0269ULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x0000000122097824ULL, 0x000fe200078e0207ULL, 0xfffffff81b1e7812ULL, 0x000fe200078ee208ULL,
0x00000008171b7824ULL, 0x040fe200078e00ffULL, 0x0000000700057812ULL, 0x000fe200078ec0ffULL,
0x0000000117007824ULL, 0x000fe200078e0204ULL, 0x0000002204077211ULL, 0x000fe200078fe8ffULL,
0x0000000122197824ULL, 0x000fe200078e0217ULL, 0x0001300006257811ULL, 0x000fe200078e68ffULL,
0x0000008069167824ULL, 0x000fe200078e0216ULL, 0x0ffffff805057812ULL, 0x000fe200078ef804ULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0xfffffff81b007812ULL, 0x000fe200078ee200ULL,
0x00000001220d7824ULL, 0x000fc400078e020dULL, 0x00000001220f7824ULL, 0x000fe400078e020fULL,
0x0000010007067825ULL, 0x000fc800078e0016ULL, 0x0000000122117824ULL, 0x000fe200078e0211ULL,
0x0000640006067a10ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fc600078e0016ULL,
0x0000650007077a10ULL, 0x000fe200007fe4ffULL, 0x0000000122137824ULL, 0x000fe200078e0213ULL,
0x0000640008087a10ULL, 0x000fe20007f3e0ffULL, 0x000001000d0c7825ULL, 0x000fc600078e0016ULL,
0x0000650009097a10ULL, 0x000fe20000ffe4ffULL, 0x0000000122157824ULL, 0x000fe200078e0215ULL,
0x000064000c0c7a10ULL, 0x000fe20007f5e0ffULL, 0x000001000f0e7825ULL, 0x000fc600078e0016ULL,
0x000065000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x0000010011107825ULL, 0x000fe200078e0016ULL,
0x000064000e0e7a10ULL, 0x000fc60007f7e0ffULL, 0x0000010013127825ULL, 0x100fe200078e0016ULL,
0x0000640010107a10ULL, 0x000fe40007f1e0ffULL, 0x000065000f0f7a10ULL, 0x000fe20001ffe4ffULL,
0x0000010015147825ULL, 0x100fe200078e0016ULL, 0x0000640012127a10ULL, 0x000fe40007f3e0ffULL,
0x0000650011117a10ULL, 0x000fe200007fe4ffULL, 0x0000010019167825ULL, 0x000fe200078e0016ULL,
0x0000640014147a10ULL, 0x000fe40007f5e0ffULL, 0x0000650013137a10ULL, 0x000fe20000ffe4ffULL,
0x0000001005057824ULL, 0x100fe200078e0225ULL, 0x0000640016167a10ULL, 0x000fe20007f7e0ffULL,
0x000000100a197824ULL, 0x100fe200078e0225ULL, 0x0000650015157a10ULL, 0x000fe200017fe4ffULL,
0x00000010181b7824ULL, 0x100fe200078e0225ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000b901c46ULL, 0x000000101a1d7824ULL, 0x100fe200078e0225ULL,
0x0000650017177a10ULL, 0x000fe20001ffe4ffULL, 0x000000101c1f7824ULL, 0x100fe200078e0225ULL,
0x0000000008197faeULL, 0x0003e2000b901c46ULL, 0x000000101e217824ULL, 0x000fc400078e0225ULL,
0x0000001020237824ULL, 0x100fe200078e0225ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c46ULL,
0x0000001000257824ULL, 0x000fc600078e0225ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e4000b901c46ULL,
0x0000005c0300720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff087424ULL, 0x006fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000692000000947ULL, 0x000fea0003800000ULL, 0xff317217ff087424ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc400078e00ffULL, 0x0000000103097810ULL, 0x040fe20007ffe0ffULL,
0x0000010003007824ULL, 0x000fe200078e0270ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000005c0900720cULL, 0x000fe40003f06070ULL, 0x00000040000d7810ULL, 0x020fca0007ffe0ffULL,
0x000068006c097a24ULL, 0x000fcc00078e020dULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff417819ULL, 0x100fe40000011604ULL, 0x0000000d660c7217ULL, 0x000fe40007800000ULL,
0x0000000441317810ULL, 0x040fe20007ffe0ffULL, 0x0000000141387824ULL, 0x140fe200078e0204ULL,
0x0000000841357810ULL, 0x040fe20007ffe0ffULL, 0x000000010c307824ULL, 0x000fe200078e0a0dULL,
0x0000000c41397810ULL, 0x040fe20007ffe0ffULL, 0x00000010040c7824ULL, 0x000fe200078e00ffULL,
0x0000001041437810ULL, 0x000fe20007ffe0ffULL, 0x00000001310e7824ULL, 0x100fe200078e0204ULL,
0x0000001441457810ULL, 0x000fe20007ffe0ffULL, 0x00000008310f7824ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000135367824ULL, 0x040fe200078e0204ULL,
0x00000020303a7817ULL, 0x000fe20003800000ULL, 0x00000008350d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3c7812ULL, 0x000fe200078ee20eULL, 0x0000000139377824ULL, 0x000fe200078e0204ULL,
0x0000003a3100720cULL, 0x080fe20003f86070ULL, 0x00000008390e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d367812ULL, 0x000fe200078ee236ULL, 0x00000080690c7824ULL, 0x000fe200078e020cULL,
0x0000003a3900720cULL, 0x080fe20003f26070ULL, 0x00000001410f7824ULL, 0x040fe200078e0209ULL,
0xfffffff80e377812ULL, 0x000fe200078ee237ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000003a4100720cULL, 0x000fe20003f66070ULL, 0x0000000143337824ULL, 0x000fe200078e0204ULL,
0x0000001841477810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000001c41497810ULL, 0x000fc60007ffe0ffULL, 0x00000008433e7824ULL, 0x000fe200078e00ffULL,
0x000064000e327a10ULL, 0x000fe20007f1e0ffULL, 0x0000000145347824ULL, 0x040fe400078e0204ULL,
0x00000008453b7824ULL, 0x040fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee233ULL,
0x0000000145417824ULL, 0x100fe200078e0209ULL, 0x000065000f337a10ULL, 0x000fe200007fe4ffULL,
0x00000001310f7824ULL, 0x100fe200078e0209ULL, 0x0000003a3500720cULL, 0x040fe20003f06070ULL,
0x0000000135317824ULL, 0x100fe200078e0209ULL, 0xfffffff83b407812ULL, 0x000fe200078ee234ULL,
0x0000000139357824ULL, 0x000fe200078e0209ULL, 0x0000000738397812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x0000010031307825ULL, 0x000fe200078e000cULL,
0x000064000e387a10ULL, 0x000fc60007f5e0ffULL, 0x0000010035347825ULL, 0x000fe200078e000cULL,
0x00006400300e7a10ULL, 0x000fc60007fbe0ffULL, 0x000000020b3b7824ULL, 0x000fe200078e0269ULL,
0x0000640034307a10ULL, 0x000fe40007fde0ffULL, 0x0ffffff839347812ULL, 0x000fe400078ef804ULL,
0x000065000f397a10ULL, 0x000fe400017fe4ffULL, 0x000140003b3b7811ULL, 0x000fe400078e68ffULL,
0x00006500310f7a10ULL, 0x000fe40002ffe4ffULL, 0x0000650035317a10ULL, 0x000fe200037fe4ffULL,
0x0000000143357824ULL, 0x040fe200078e0209ULL, 0x0000003a4300720cULL, 0x080fe20003f46070ULL,
0x00000010343d7824ULL, 0x000fe200078e023bULL, 0x0000003a4500720cULL, 0x000fe20003fa6070ULL,
0x0000010035347825ULL, 0x000fc600078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000323d7faeULL, 0x0003e2000d901c46ULL, 0x000000103c3f7824ULL, 0x000fe200078e023bULL,
0x0000640034347a10ULL, 0x000fe20007fde0ffULL, 0x0000000147437824ULL, 0x100fe200078e0209ULL,
0x0000003a4900720cULL, 0x0c0fe20003f66070ULL, 0x0000000149097824ULL, 0x000fe200078e0209ULL,
0x00000000383f7faeULL, 0x0005e2000e101c46ULL, 0x0000650035357a10ULL, 0x000fe200037fe4ffULL,
0x00000001493c7824ULL, 0x100fe200078e0204ULL, 0x0000003a4700720cULL, 0x040fe20003f86070ULL,
0x00000001473a7824ULL, 0x000fc400078e0204ULL, 0x0000010041327825ULL, 0x002fc800078e000cULL,
0x0000000847477824ULL, 0x000fe200078e00ffULL, 0x0000640032327a10ULL, 0x000fe20007fde0ffULL,
0x0000010043387825ULL, 0x004fc600078e000cULL, 0x0000650033337a10ULL, 0x000fe200037fe4ffULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x0000640038387a10ULL, 0x000fe20007fde0ffULL,
0x00000100090c7825ULL, 0x000fe200078e000cULL, 0xfffffff8473a7812ULL, 0x000fe400078ee23aULL,
0xfffffff8493c7812ULL, 0x000fe200078ee23cULL, 0x0000001036097824ULL, 0x100fe200078e023bULL,
0x0000650039397a10ULL, 0x000fe200037fe4ffULL, 0x0000001037377824ULL, 0x100fe200078e023bULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000103e3d7824ULL, 0x100fe200078e023bULL,
0x000000000e097faeULL, 0x0003e2000c101c46ULL, 0x00000010403f7824ULL, 0x100fe200078e023bULL,
0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x000000103a417824ULL, 0x100fe200078e023bULL,
0x0000000030377faeULL, 0x0003e2000c901c46ULL, 0x000000103c3b7824ULL, 0x000fc600078e023bULL,
0x00000000343d7faeULL, 0x0003e8000d101c46ULL, 0x00000000323f7faeULL, 0x0003e8000e901c46ULL,
0x0000000038417faeULL, 0x0003e8000e101c46ULL, 0x000000000c3b7faeULL, 0x0003e2000d901c46ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000804337811ULL, 0x040fe400078fe8ffULL,
0x0000000c04357811ULL, 0x000fc400078fe8ffULL, 0x0000000404317811ULL, 0x040fe200078fe8ffULL,
0x00000001330d7824ULL, 0x140fe200078e0204ULL, 0x0000001404397811ULL, 0x040fe200078fe8ffULL,
0x0000000833307824ULL, 0x000fe200078e00ffULL, 0x00000018043b7811ULL, 0x040fe200078fe8ffULL,
0x00000001350e7824ULL, 0x140fe200078e0204ULL, 0x0000001004377811ULL, 0x000fe200078fe8ffULL,
0x0000000835417824ULL, 0x000fe200078e00ffULL, 0xfffffff8303f7812ULL, 0x000fe200078ee20dULL,
0x00000001310c7824ULL, 0x040fe200078e0204ULL, 0x0000001c04497811ULL, 0x000fe200078fe8ffULL,
0x00000008313d7824ULL, 0x000fe200078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee20eULL,
0x00000001390d7824ULL, 0x000fc400078e0204ULL, 0x0000000839307824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL, 0x000000013b0e7824ULL, 0x140fe400078e0204ULL,
0x000000083b477824ULL, 0x000fe200078e00ffULL, 0xfffffff830457812ULL, 0x000fe200078ee20dULL,
0x00000001370c7824ULL, 0x040fe200078e0204ULL, 0x00000004040d7211ULL, 0x040fe200078fe8ffULL,
0x0000000837437824ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fe200078ee20eULL,
0x000000020b0e7824ULL, 0x000fe200078e0269ULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001490f7824ULL, 0x000fe200078e0204ULL, 0xfffffff843437812ULL, 0x000fe200078ee20cULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x000140000e0e7811ULL, 0x000fe200078e68ffULL,
0x0000000849307824ULL, 0x000fe200078e00ffULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef804ULL,
0x0000000131317824ULL, 0x100fe200078e0209ULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000133337824ULL, 0x000fe200078e0209ULL, 0xfffffff8304b7812ULL, 0x000fe200078ee20fULL,
0x0000000135357824ULL, 0x100fe200078e0209ULL, 0x00000009040f7211ULL, 0x000fe200078fe8ffULL,
0x0000000137377824ULL, 0x000fc400078e0209ULL, 0x0000000139397824ULL, 0x100fe400078e0209ULL,
0x000000013b3b7824ULL, 0x100fe400078e0209ULL, 0x0000000149497824ULL, 0x000fe400078e0209ULL,
0x000000100d097824ULL, 0x000fe400078e020eULL, 0x00000080690c7824ULL, 0x000fe400078e020cULL,
0x000000ffff0d7224ULL, 0x000fc400078e00ffULL, 0x000000103d3d7824ULL, 0x100fe400078e020eULL,
0x000000103f3f7824ULL, 0x100fe400078e020eULL, 0x0000001041417824ULL, 0x100fe400078e020eULL,
0x0000001043437824ULL, 0x100fe400078e020eULL, 0x0000001045457824ULL, 0x100fe400078e020eULL,
0x0000001047477824ULL, 0x000fc400078e020eULL, 0x000000104b4b7824ULL, 0x000fe400078e020eULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x0000010031307825ULL, 0x000fe200078e000cULL,
0x000064000e0e7a10ULL, 0x000fc60007f1e0ffULL, 0x0000010033327825ULL, 0x100fe200078e000cULL,
0x0000640030307a10ULL, 0x000fe40007f3e0ffULL, 0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010035347825ULL, 0x100fe200078e000cULL, 0x0000640032327a10ULL, 0x000fe40007f5e0ffULL,
0x0000650031317a10ULL, 0x000fe20000ffe4ffULL, 0x0000010037367825ULL, 0x100fe200078e000cULL,
0x0000640034347a10ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000b901c46ULL, 0x0000650033337a10ULL, 0x000fe200017fe4ffULL,
0x0000010039387825ULL, 0x100fe200078e000cULL, 0x0000640036367a10ULL, 0x000fe20007f1e0ffULL,
0x00000000303d7faeULL, 0x0003e2000b901c46ULL, 0x0000650035357a10ULL, 0x000fe20001ffe4ffULL,
0x000001003b3a7825ULL, 0x100fe200078e000cULL, 0x0000640038387a10ULL, 0x000fe20007f3e0ffULL,
0x00000000323f7faeULL, 0x0003e2000b901c46ULL, 0x0000650037377a10ULL, 0x000fe200007fe4ffULL,
0x00000100490c7825ULL, 0x000fe200078e000cULL, 0x000064003a3a7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000034417faeULL, 0x0003e2000b901c46ULL, 0x0000650039397a10ULL, 0x000fc40000ffe4ffULL,
0x000064000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x0000000036437faeULL, 0x0003e2000b901c46ULL,
0x000065003b3b7a10ULL, 0x000fe400017fe4ffULL, 0x000065000d0d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000000038457faeULL, 0x0003e8000b901c46ULL, 0x000000003a477faeULL, 0x0003e8000b901c46ULL,
0x000000000c4b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe071097812ULL, 0x002fc400078ec0ffULL, 0x00000010710c7812ULL, 0x000fca00078ec0ffULL,
0x00000001090e7824ULL, 0x000fc800078e020cULL, 0x0000000869307824ULL, 0x000fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080030307f8cULL, 0x000e64000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x0000000871097812ULL, 0x000fca00078ec0ffULL,
0x000000010e097824ULL, 0x000fca00078e0209ULL, 0x01b60c00090f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x006fe40007804831ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c337210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09003300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000330e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60c00090f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010046f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff727819ULL, 0x000fe20000011604ULL, 0x0000002002097824ULL, 0x000fc600078e00ffULL,
0x000000706f6f7812ULL, 0x000fe400078ec0ffULL, 0xffffff8009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c72727812ULL, 0x000fc800078ec0ffULL, 0x0000000972097210ULL, 0x000fca0007ffe06fULL,
0x01b00000090d7984ULL, 0x000e680000000800ULL, 0x01b2000009327984ULL, 0x0004e20000000800ULL,
0x000000080d00720bULL, 0x002fe20003f1d000ULL, 0x00011c127f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0c347812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff097224ULL, 0x000fd400078e0008ULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe40000011602ULL, 0x000000080d00720bULL, 0x000fe40003f54000ULL,
0x000000020900720cULL, 0x000fe20003f25270ULL, 0x00011bc27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000337806ULL, 0x000fc400010e0100ULL, 0x00000080020f9824ULL, 0x000fe200078e026fULL,
0x000000080d097209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910330e7816ULL, 0x000fe200000000ffULL, 0x00000001720c9824ULL, 0x000fca00078e020fULL,
0x01b400090c009388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x0000000809087221ULL, 0x002fe20000010100ULL,
0x000000ff33ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800357308ULL, 0x000e640000000800ULL,
0x000000350a0a7220ULL, 0x002fc80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011604ULL, 0x00011b027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c350c7589ULL, 0x0002a400000e0000ULL, 0x0000000c2c2c7220ULL, 0x084fe40000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000c28287220ULL, 0x080fe40000410000ULL,
0x0000000c29297220ULL, 0x080fe40000410000ULL, 0x0000000c10107220ULL, 0x080fe40000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000c14147220ULL, 0x080fe40000410000ULL,
0x0000000c15157220ULL, 0x080fe40000410000ULL, 0x0000000c18187220ULL, 0x080fe40000410000ULL,
0x0000000c19197220ULL, 0x080fe40000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000c20207220ULL, 0x080fe40000410000ULL,
0x0000000c21217220ULL, 0x080fe40000410000ULL, 0x0000000c24247220ULL, 0x080fe40000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0033ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008040c7811ULL, 0x000fe200078ff0ffULL, 0x00011a027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c350c7589ULL, 0x00046400000e0000ULL, 0x0000000c2e2e7220ULL, 0x086fe40000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000c12127220ULL, 0x080fe40000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000c16167220ULL, 0x080fe40000410000ULL,
0x0000000c17177220ULL, 0x080fe40000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe40000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000c1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000c22227220ULL, 0x080fe40000410000ULL,
0x0000000c23237220ULL, 0x080fe40000410000ULL, 0x0000000c26267220ULL, 0x080fe40000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff34ff7812ULL, 0x000fda0007826033ULL, 0x800000090d0d1221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0d0d1820ULL, 0x000fc80000410000ULL,
0x0000000d00051308ULL, 0x000e640000000800ULL, 0x0000000532321220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000a320a7221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000010ffULL,
0x00000002ff087819ULL, 0x000fe40000011604ULL, 0x00005410060d7816ULL, 0x000fe20000000006ULL,
0x000118527f007947ULL, 0x000fea000b800000ULL, 0x00001f080d067589ULL, 0x0002a400000e0000ULL,
0x00000008080c7810ULL, 0x000fe20007ffe0ffULL, 0x000118a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d077589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010080c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x000030a0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0001256000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018080c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00003110000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x000124f000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff087819ULL, 0x002fe20000011604ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000007046d7812ULL, 0x040fe400078ec0ffULL, 0x00000008046e7812ULL, 0x000fe200078ec0ffULL,
0x000000040b0d7824ULL, 0x008fe200078e0208ULL, 0x000000086d0c7812ULL, 0x004fe200078ef804ULL,
0x0000020002087824ULL, 0x000fc800078e00ffULL, 0x000000010c0d7824ULL, 0x000fe200078e020dULL,
0xfffff80008317812ULL, 0x000fe200078ec0ffULL, 0x000000080c0e7824ULL, 0x000fca00078e00ffULL,
0xfffffff80e087812ULL, 0x000fca00078ee20dULL, 0x0000001008087824ULL, 0x000fc600078e0231ULL,
0x0000006d6e0f7212ULL, 0x000fe200078efcffULL, 0x000000020b5d7824ULL, 0x000fe200078e0269ULL,
0x011000000844783bULL, 0x000e620000000200ULL, 0x000000020d0d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000f040e7211ULL, 0x000fe200078fe0ffULL, 0x000000080f0b7824ULL, 0x040fe400078e00ffULL,
0x000000080f307824ULL, 0x040fe200078e00ffULL, 0x000000040e627810ULL, 0x040fe20007ffe0ffULL,
0x000000080f337824ULL, 0x000fe200078e00ffULL, 0x000000060e657810ULL, 0x000fe20007ffe0ffULL,
0x000020005d5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b647812ULL, 0x000fc400078ee20eULL,
0xfffffff833627812ULL, 0x000fe400078ee262ULL, 0x000130005d0b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff830657812ULL, 0x000fe400078ee265ULL, 0x000000020e637810ULL, 0x000fe20007ffe0ffULL,
0x0000001064507824ULL, 0x000fe200078e020bULL, 0x000000106e337812ULL, 0x000fe200078efe6dULL,
0x00000010624c7824ULL, 0x000fe200078e020bULL, 0xfffffff830637812ULL, 0x000fe200078ee263ULL,
0x0000001065487824ULL, 0x000fe200078e020bULL, 0x0000003304347211ULL, 0x000fe200078fe0ffULL,
0x000000005050783bULL, 0x000ea20000004200ULL, 0x000000080c0e7824ULL, 0x000fc400078e00ffULL,
0x00000010630c7824ULL, 0x000fe200078e020bULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x0000000833367824ULL, 0x040fe200078e00ffULL, 0xfffffff80e307812ULL, 0x000fe200078ee20dULL,
0x0000000833617824ULL, 0x040fe200078e00ffULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x0000000833377824ULL, 0x000fe200078e00ffULL, 0x00000004345f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001030307824ULL, 0x000fe200078e0231ULL, 0x00000006345e7810ULL, 0x000fe20007ffe0ffULL,
0x000000000c0c783bULL, 0x000fe20000004200ULL, 0xfffffff861617812ULL, 0x000fe200078ee234ULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0xfffffff8365f7812ULL, 0x000fe200078ee25fULL,
0x011000003030783bULL, 0x000f220000000200ULL, 0xfffffff8375e7812ULL, 0x000fe200078ee25eULL,
0x0000001061407824ULL, 0x100fe200078e020bULL, 0x0000000234607810ULL, 0x000fe20007ffe0ffULL,
0x000000105f387824ULL, 0x100fe200078e020bULL, 0x0000000644440231ULL, 0x082fe200003400ffULL,
0x000000105e347824ULL, 0x000fe200078e020bULL, 0xfffffff835607812ULL, 0x000fe200078ee260ULL,
0x000000004040783bULL, 0x000e620000004200ULL, 0x0000000646460231ULL, 0x000fc400003400ffULL,
0x0000000745450231ULL, 0x080fe200003400ffULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x00000010603c7824ULL, 0x000fe200078e020bULL, 0x0000000747470231ULL, 0x000fe400003400ffULL,
0x000000003434783bULL, 0x000e680000004200ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x00000050442c723cULL, 0x044f70000004182cULL, 0x000000524428723cULL, 0x040f700000041828ULL,
0x0000004c4418723cULL, 0x008f620000041818ULL, 0x0000000630300231ULL, 0x010fc400003400ffULL,
0x0000000632320231ULL, 0x000fe400003400ffULL, 0x0000000731310231ULL, 0x080fe400003400ffULL,
0x0000000733330231ULL, 0x000fe200003400ffULL, 0x0000004e441c723cULL, 0x040f70000004181cULL,
0x000000484420723cULL, 0x040f700000041820ULL, 0x0000004a4424723cULL, 0x040f700000041824ULL,
0x0000000c4410723cULL, 0x040f700000041810ULL, 0x0000000e440c723cULL, 0x000f700000041814ULL,
0x00000040302c723cULL, 0x062f70000004182cULL, 0x000000423028723cULL, 0x040f700000041828ULL,
0x000000383018723cULL, 0x040f700000041818ULL, 0x0000003a301c723cULL, 0x040f70000004181cULL,
0x000000343020723cULL, 0x040f700000041820ULL, 0x000000363024723cULL, 0x040f700000041824ULL,
0x0000003c3014723cULL, 0x040f700000041810ULL, 0x0000003e303c723cULL, 0x000b6e000004180cULL,
0x00000002020c7824ULL, 0x020fca00078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000001030f7810ULL, 0x000fe20007ffe0ffULL,
0x01b688000cff7f8cULL, 0x0003e2000c80043fULL, 0x00000080000d7810ULL, 0x000fe40007ffe0ffULL,
0x0000005c0f00720cULL, 0x000fc60003f06070ULL, 0x000068006c377a24ULL, 0x000fe200078e020dULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x102fe40000011604ULL, 0x0000000d660c7217ULL, 0x000fe40007800000ULL,
0x0000000439117810ULL, 0x040fe40007ffe0ffULL, 0x0000000839137810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x000fe200078e0a0dULL, 0x0000001039417810ULL, 0x000fe20007ffe0ffULL,
0x00000001110e7824ULL, 0x000fe200078e0204ULL, 0x0000000c393b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008110f7824ULL, 0x000fe200078e00ffULL, 0x000000200d407817ULL, 0x000fe20003800000ULL,
0x00000080690c7824ULL, 0x000fe200078e026fULL, 0x0000001439437810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xfffffff80f427812ULL, 0x000fe200078ee20eULL,
0x00000001390f7824ULL, 0x100fe200078e0237ULL, 0x000000401100720cULL, 0x0c0fe20003f86070ULL,
0x0000000111117824ULL, 0x000fe200078e0237ULL, 0x000000403b00720cULL, 0x080fe20003f46070ULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x000000401300720cULL, 0x000fc40003f66070ULL,
0x000000403900720cULL, 0x000fe20003fa6070ULL, 0x0000000113367824ULL, 0x140fe200078e0204ULL,
0x000064000e327a10ULL, 0x000fe20007f1e0ffULL, 0x0000000813317824ULL, 0x000fe200078e00ffULL,
0x0000001c39457810ULL, 0x000fe20007ffe0ffULL, 0x0000000141387824ULL, 0x040fe400078e0204ULL,
0x0000000841337824ULL, 0x000fe200078e00ffULL, 0xfffffff831367812ULL, 0x000fe200078ee236ULL,
0x0000010011107825ULL, 0x000fc600078e000cULL, 0xfffffff833387812ULL, 0x000fe200078ee238ULL,
0x000000013b3a7824ULL, 0x100fe200078e0204ULL, 0x000065000f337a10ULL, 0x000fe200007fe4ffULL,
0x000000083b317824ULL, 0x000fe200078e00ffULL, 0x0000640010307a10ULL, 0x000fe20007f3e0ffULL,
0x00000001390e7824ULL, 0x000fe400078e0204ULL, 0x00000001130f7824ULL, 0x000fe200078e0237ULL,
0xfffffff8313a7812ULL, 0x000fe200078ee23aULL, 0x0000000143347824ULL, 0x000fe200078e0204ULL,
0x000000070e357812ULL, 0x000fe200078ec0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000650011317a10ULL, 0x000fc40000ffe4ffULL, 0x000000404100720cULL, 0x080fe20003f26070ULL,
0x000000013b117824ULL, 0x000fe200078e0237ULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000008433b7824ULL, 0x000fe400078e00ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x000065000f0f7a10ULL, 0x000fe400007fe4ffULL, 0xfffffff83b447812ULL, 0x000fe200078ee234ULL,
0x0000000141137824ULL, 0x100fe200078e0237ULL, 0x0ffffff835347812ULL, 0x000fe200078ef804ULL,
0x0000000143357824ULL, 0x000fe200078e0237ULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x000000404300720cULL, 0x000fc40003f06070ULL,
0x0000001839437810ULL, 0x000fe20007ffe0ffULL, 0x00000010343b7824ULL, 0x100fe200078e020bULL,
0x0000650011117a10ULL, 0x000fe200037fe4ffULL, 0x0000001042417824ULL, 0x000fe200078e020bULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x0000010035347825ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000323b7faeULL, 0x0003e2000e901c46ULL,
0x000000404300720cULL, 0x0c0fe40003fa6070ULL, 0x0000000143397824ULL, 0x100fe200078e0237ULL,
0x0000650013137a10ULL, 0x000fe200037fe4ffULL, 0x0000000030417faeULL, 0x0005e2000e101c46ULL,
0x0000640034347a10ULL, 0x000fe20007fde0ffULL, 0x0000000145377824ULL, 0x040fe200078e0237ULL,
0x000000404500720cULL, 0x000fe20003f86070ULL, 0x0000000843407824ULL, 0x000fe200078e00ffULL,
0x0000650035357a10ULL, 0x000fe200037fe4ffULL, 0x0000000845427824ULL, 0x000fc400078e00ffULL,
0x0000010039327825ULL, 0x002fc800078e000cULL, 0x0000000143397824ULL, 0x100fe200078e0204ULL,
0x0000640032307a10ULL, 0x004fe20007fde0ffULL, 0x0000000145317824ULL, 0x000fe400078e0204ULL,
0x00000100370c7825ULL, 0x000fe200078e000cULL, 0xfffffff840327812ULL, 0x000fe400078ee239ULL,
0xfffffff842407812ULL, 0x000fe200078ee231ULL, 0x000000103a377824ULL, 0x100fe200078e020bULL,
0x0000650033317a10ULL, 0x000fe200037fe4ffULL, 0x0000001036337824ULL, 0x100fe200078e020bULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001038397824ULL, 0x000fc400078e020bULL,
0x00000010443b7824ULL, 0x100fe200078e020bULL, 0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001032417824ULL, 0x100fe200078e020bULL, 0x000000000e337faeULL, 0x0003e2000d901c46ULL,
0x00000010400b7824ULL, 0x000fc600078e020bULL, 0x0000000010377faeULL, 0x0003e8000d101c46ULL,
0x0000000012397faeULL, 0x0003e8000c901c46ULL, 0x00000000343b7faeULL, 0x0003e8000c101c46ULL,
0x0000000030417faeULL, 0x0003e8000e901c46ULL, 0x000000000c0b7faeULL, 0x0003e2000e101c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000404337811ULL, 0x042fe400078fe8ffULL,
0x00000008040f7811ULL, 0x000fc400078fe8ffULL, 0x0000001004137811ULL, 0x040fe200078fe8ffULL,
0x00000001330c7824ULL, 0x140fe200078e0204ULL, 0x0000000c04357811ULL, 0x040fe200078fe8ffULL,
0x0000000833117824ULL, 0x000fe200078e00ffULL, 0x0000001804397811ULL, 0x040fe200078fe8ffULL,
0x000000010f0d7824ULL, 0x040fe400078e0204ULL, 0x000000080f407824ULL, 0x000fe200078e00ffULL,
0xfffffff8113a7812ULL, 0x000fe200078ee20cULL, 0x0000000813447824ULL, 0x000fe200078e00ffULL,
0x0000001404117811ULL, 0x000fe200078fe8ffULL, 0x00000001350c7824ULL, 0x100fe200078e0204ULL,
0xfffffff840407812ULL, 0x000fe200078ee20dULL, 0x00000001130d7824ULL, 0x000fc400078e0204ULL,
0x0000000835317824ULL, 0x000fe400078e00ffULL, 0x0000000139107824ULL, 0x140fe200078e0204ULL,
0xfffffff844447812ULL, 0x000fe200078ee20dULL, 0x0000000839417824ULL, 0x000fe200078e00ffULL,
0x00000004040d7211ULL, 0x040fe200078fe8ffULL, 0x00000001110e7824ULL, 0x000fe200078e0204ULL,
0xfffffff831427812ULL, 0x000fe200078ee20cULL, 0x00000008113b7824ULL, 0x000fe200078e00ffULL,
0xfffffff841487812ULL, 0x000fe200078ee210ULL, 0x00000080690c7824ULL, 0x000fe200078e026fULL,
0x0000003704317211ULL, 0x040fe200078fe8ffULL, 0x0000000133337824ULL, 0x100fe200078e0237ULL,
0xfffffff83b467812ULL, 0x000fe200078ee20eULL, 0x000000010f0f7824ULL, 0x100fe200078e0237ULL,
0x000000070d417812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000001c040e7811ULL, 0x000fe200078fe8ffULL, 0x0000000135357824ULL, 0x000fe200078e0237ULL,
0x0ffffff841387812ULL, 0x000fe200078ef804ULL, 0x0000010031307825ULL, 0x000fc800078e000cULL,
0x0000000113137824ULL, 0x100fe200078e0237ULL, 0x0000640030307a10ULL, 0x000fe20007f1e0ffULL,
0x0000000111117824ULL, 0x100fe400078e0237ULL, 0x0000000139397824ULL, 0x100fe200078e0237ULL,
0x0000650031317a10ULL, 0x000fe200007fe4ffULL, 0x000000010e3b7824ULL, 0x000fe400078e0237ULL,
0x0000010033327825ULL, 0x000fc800078e000cULL, 0x000001000f367825ULL, 0x000fe200078e000cULL,
0x0000640032327a10ULL, 0x000fc60007f3e0ffULL, 0x0000010035347825ULL, 0x100fe200078e000cULL,
0x0000640036367a10ULL, 0x000fe40007f5e0ffULL, 0x0000650033337a10ULL, 0x000fe20000ffe4ffULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x0000640034347a10ULL, 0x000fe40007f7e0ffULL,
0x0000650037377a10ULL, 0x000fe200017fe4ffULL, 0x000000010e437824ULL, 0x000fe200078e0204ULL,
0x0000640012127a10ULL, 0x000fe20007f1e0ffULL, 0x000000080e4a7824ULL, 0x000fe200078e00ffULL,
0x0000650035357a10ULL, 0x000fe20001ffe4ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x0000650013137a10ULL, 0x000fc400007fe4ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee243ULL,
0x00000100390e7825ULL, 0x000fe200078e000cULL, 0x0000640010107a10ULL, 0x000fc60007f3e0ffULL,
0x000001003b0c7825ULL, 0x000fe200078e000cULL, 0x000064000e0e7a10ULL, 0x000fe40007f5e0ffULL,
0x0000650011117a10ULL, 0x000fe20000ffe4ffULL, 0x0000001038397824ULL, 0x100fe200078e020bULL,
0x000064000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000103a3b7824ULL, 0x100fe200078e020bULL,
0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x0000001040417824ULL, 0x100fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030397faeULL, 0x0003e2000b901c46ULL,
0x0000001042437824ULL, 0x100fe200078e020bULL, 0x000065000d0d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000001044457824ULL, 0x100fe200078e020bULL, 0x00000000323b7faeULL, 0x0003e2000b901c46ULL,
0x0000001046477824ULL, 0x000fc400078e020bULL, 0x0000001048497824ULL, 0x100fe200078e020bULL,
0x0000000036417faeULL, 0x0003e2000b901c46ULL, 0x000000104a0b7824ULL, 0x000fc600078e020bULL,
0x0000000034437faeULL, 0x0003e8000b901c46ULL, 0x0000000012457faeULL, 0x0003e8000b901c46ULL,
0x0000000010477faeULL, 0x0003e8000b901c46ULL, 0x000000000e497faeULL, 0x0003e8000b901c46ULL,
0x000000000c0b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe0710b7812ULL, 0x002fc400078ec0ffULL, 0x00000010710c7812ULL, 0x040fe400078ec0ffULL,
0x00000008710d7812ULL, 0x000fc800078ec0ffULL, 0x0000000b0d0b7210ULL, 0x000fe20007ffe00cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b628000b107f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01b62c000b0f7984ULL, 0x000ee40000000800ULL,
0x800000000fff7812ULL, 0x00cfe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000130e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b62c000b0f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020020b7824ULL, 0x002fca00078e00ffULL,
0xffffff800b0c7812ULL, 0x000fc800078ec0ffULL, 0x000000806f0b7810ULL, 0x000fca0007ffe00cULL,
0x00000001720b7824ULL, 0x000fca00078e020bULL, 0x01b000000b107984ULL, 0x000e680000000800ULL,
0x01b200000b117984ULL, 0x0004e20000000800ULL, 0x000000091000720bULL, 0x002fe20003f1d000ULL,
0x000103227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c127812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff0d7224ULL, 0x000fd400078e0009ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000001020b7811ULL, 0x000fe400078ff0ffULL,
0x000000091000720bULL, 0x000fe40003f34000ULL, 0x000000020b00720cULL, 0x000fe20003f05270ULL,
0x000102d27f007947ULL, 0x000fd4000b800000ULL, 0x00000000000b7806ULL, 0x000fc400008e0100ULL,
0x00000080020d8824ULL, 0x000fe200078e026fULL, 0x00000009100c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x00000001720f8824ULL, 0x000fe200078e020dULL,
0x000099100b0d7816ULL, 0x000fc800000000ffULL, 0x01b4000c0f008388ULL, 0x0003e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000009100c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0bff7812ULL, 0x000fc6000780c0ffULL, 0x000000090c0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c000d7308ULL, 0x000e640000000800ULL,
0x0000000d0a0a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011604ULL, 0x000102027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d0c7589ULL, 0x0002a400000e0000ULL, 0x0000000c2c2c7220ULL, 0x084fe40000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000c28287220ULL, 0x080fe40000410000ULL,
0x0000000c29297220ULL, 0x000fc40000410000ULL, 0x0000000c14147220ULL, 0x080fe40000410000ULL,
0x0000000c15157220ULL, 0x080fe40000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000c18187220ULL, 0x080fe40000410000ULL,
0x0000000c19197220ULL, 0x000fc40000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000000c20207220ULL, 0x080fe40000410000ULL,
0x0000000c21217220ULL, 0x080fe40000410000ULL, 0x0000000c24247220ULL, 0x080fe40000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000bff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008040c7811ULL, 0x000fe200078ff0ffULL, 0x000101027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d0c7589ULL, 0x00046400000e0000ULL, 0x0000000c2e2e7220ULL, 0x086fe40000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000c16167220ULL, 0x080fe40000410000ULL,
0x0000000c17177220ULL, 0x000fc40000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe40000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000c1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000c22227220ULL, 0x080fe40000410000ULL,
0x0000000c23237220ULL, 0x080fe40000410000ULL, 0x0000000c26267220ULL, 0x080fe40000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff12ff7812ULL, 0x000fe4000780600bULL, 0x00000009100d7209ULL, 0x000fd60007810000ULL,
0x8000000d10100221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL,
0x0000001000050308ULL, 0x000e640000000800ULL, 0x0000000511110220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000a11107221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000010ffULL,
0x00000002ff0a7819ULL, 0x000fe40000011604ULL, 0x0000541006097816ULL, 0x000fe20000000006ULL,
0x0000ff527f007947ULL, 0x000fea000b800000ULL, 0x00001f0a09067589ULL, 0x0002a400000e0000ULL,
0x000000080a0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000ffa27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c09077589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100a0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0009ULL,
0x00004c00000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00010a0000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180a0c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x00004c70000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0001099000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000001ff0b7819ULL, 0x000fe20000011602ULL,
0x01180000084c783bULL, 0x0008e20000000200ULL, 0x00000004ff0a7819ULL, 0x002fe40000011604ULL,
0x0000006e6d097212ULL, 0x008fe200078efcffULL, 0x000000020b0c7824ULL, 0x004fc400078e0269ULL,
0x000000040b0a7824ULL, 0x000fe400078e020aULL, 0x00000008090e7824ULL, 0x040fe200078e00ffULL,
0x000140000c0c7811ULL, 0x000fe200078e68ffULL, 0x00000001090a7824ULL, 0x000fe200078e020aULL,
0x00000002ff087819ULL, 0x010fc60000011602ULL, 0x0000001064307824ULL, 0x100fe200078e020cULL,
0x000000020a097810ULL, 0x000fe20007ffe0ffULL, 0x0000001063587824ULL, 0x100fe400078e020cULL,
0x0000001062547824ULL, 0x100fe200078e020cULL, 0xfffffff80e097812ULL, 0x000fe200078ee209ULL,
0x0000001065507824ULL, 0x000fe200078e020cULL, 0x000000003030783bULL, 0x000e620000004200ULL,
0x0001b690080c7811ULL, 0x040fe400078e18ffULL, 0x0000008008347824ULL, 0x000fe200078e0209ULL,
0x000000005858783bULL, 0x000ea20000004200ULL, 0x000140005d097810ULL, 0x000fc60007ffe0ffULL,
0x000000005454783bULL, 0x000fe20000004200ULL, 0x0001180034347811ULL, 0x000fe200078e20ffULL,
0x0000001061677824ULL, 0x100fe400078e0209ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000001060687824ULL, 0x100fe400078e0209ULL, 0x000000105f6a7824ULL, 0x100fe200078e0209ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x000000105e6b7824ULL, 0x000fe200078e0209ULL,
0x000000064c4c0231ULL, 0x000fc400003400ffULL, 0x000000006748783bULL, 0x000f220000004200ULL,
0x000000064e4e0231ULL, 0x000fe400003400ffULL, 0x000000074d4d0231ULL, 0x080fe200003400ffULL,
0x000000006844783bULL, 0x000f220000004200ULL, 0x000000074f4f0231ULL, 0x000fc600003400ffULL,
0x000000006a40783bULL, 0x000f280000004200ULL, 0x000000006b38783bULL, 0x000f220000004200ULL,
0x000000304c2c723cULL, 0x042f70000004182cULL, 0x000000324c28723cULL, 0x040f700000041828ULL,
0x000000584c14723cULL, 0x004f620000041814ULL, 0x0000000634340231ULL, 0x008fc400003400ffULL,
0x0000000636360231ULL, 0x000fe400003400ffULL, 0x0000000735350231ULL, 0x080fe400003400ffULL,
0x0000000737370231ULL, 0x000fe200003400ffULL, 0x0000005a4c3c723cULL, 0x040f70000004183cULL,
0x000000544c18723cULL, 0x040f700000041818ULL, 0x000000564c1c723cULL, 0x040f70000004181cULL,
0x000000504c20723cULL, 0x040f700000041820ULL, 0x000000524c24723cULL, 0x000f700000041824ULL,
0x00000048342c723cULL, 0x070b70000004182cULL, 0x0000004a3428723cULL, 0x040b700000041828ULL,
0x000000443414723cULL, 0x040b700000041814ULL, 0x00000046343c723cULL, 0x040b70000004183cULL,
0x000000403418723cULL, 0x040b700000041818ULL, 0x00000042341c723cULL, 0x040b70000004181cULL,
0x000000383420723cULL, 0x040b700000041820ULL, 0x0000003a3424723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000001030f7810ULL, 0x000fe20007ffe0ffULL,
0x000000000cff7f8cULL, 0x0003e2000c80043fULL, 0x000000c000417810ULL, 0x020fc40007ffe0ffULL,
0x0000005c0f00720cULL, 0x000fc60003f06070ULL, 0x000068006c117a24ULL, 0x000fe200078e0241ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff347819ULL, 0x102fe20000011604ULL, 0x0000008069387824ULL, 0x000fe200078e026fULL,
0x0000004166007217ULL, 0x000fe20007800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x00000010343a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000134337824ULL, 0x040fe200078e0211ULL,
0x0000000c34307810ULL, 0x000fe20007ffe0ffULL, 0x0000000100417824ULL, 0x000fe200078e0a41ULL,
0x00000004340e7810ULL, 0x000fe20007ffe0ffULL, 0x000000013a007824ULL, 0x100fe200078e0204ULL,
0x0000000834127810ULL, 0x000fe20007ffe0ffULL, 0x000000083a317824ULL, 0x000fe200078e00ffULL,
0x0000002041417817ULL, 0x000fe20003800000ULL, 0x00000001300c7824ULL, 0x000fe200078e0204ULL,
0x0000001434467810ULL, 0x000fe20007ffe0ffULL, 0x0000000830137824ULL, 0x000fe200078e00ffULL,
0xfffffff831007812ULL, 0x000fe200078ee200ULL, 0x000000010e427824ULL, 0x000fe200078e0204ULL,
0x000000413000720cULL, 0x080fe20003f46070ULL, 0x000000080e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8130c7812ULL, 0x000fe200078ee20cULL, 0x0000000112317824ULL, 0x140fe200078e0211ULL,
0x000000411200720cULL, 0x080fe20003f66070ULL, 0x0000000130137824ULL, 0x000fe200078e0211ULL,
0xfffffff80f427812ULL, 0x000fe200078ee242ULL, 0x0000000112407824ULL, 0x000fe200078e0204ULL,
0x000000410e00720cULL, 0x000fe20003fa6070ULL, 0x00000008120f7824ULL, 0x000fe200078e00ffULL,
0x0000001834487810ULL, 0x040fe20007ffe0ffULL, 0x0000010033327825ULL, 0x000fe200078e0038ULL,
0x0000001c344a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80f407812ULL, 0x000fe200078ee240ULL,
0x0000010031307825ULL, 0x000fe200078e0038ULL, 0x0000640032367a10ULL, 0x000fc60007f1e0ffULL,
0x0000010013127825ULL, 0x000fe200078e0038ULL, 0x0000640030327a10ULL, 0x000fe40007f9e0ffULL,
0x0000650033377a10ULL, 0x000fe200007fe4ffULL, 0x0000000146447824ULL, 0x000fe200078e0204ULL,
0x0000640012307a10ULL, 0x000fe20007fde0ffULL, 0x0000000846357824ULL, 0x000fe200078e00ffULL,
0x0000650031337a10ULL, 0x000fe200027fe4ffULL, 0x000000010e0f7824ULL, 0x100fe200078e0211ULL,
0x0000650013317a10ULL, 0x000fe200037fe4ffULL, 0x000000013a137824ULL, 0x000fe200078e0211ULL,
0xfffffff835447812ULL, 0x000fe200078ee244ULL, 0x000001000f0e7825ULL, 0x000fe200078e0038ULL,
0x000000413400720cULL, 0x000fc40003f86070ULL, 0x000000414600720cULL, 0x000fe20003f06070ULL,
0x0000000134357824ULL, 0x000fe200078e0204ULL, 0x000064000e0e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000010013127825ULL, 0x000fc600078e0038ULL, 0x0000000735457812ULL, 0x000fe200078ec0ffULL,
0x00000001463b7824ULL, 0x100fe200078e0211ULL, 0x000065000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000148357824ULL, 0x100fe200078e0211ULL, 0x0ffffff845467812ULL, 0x000fe200078ef804ULL,
0x000000014a437824ULL, 0x000fe200078e0211ULL, 0x000000413a00720cULL, 0x000fe20003f26070ULL,
0x000001003b3a7825ULL, 0x000fe200078e0038ULL, 0x0000640012127a10ULL, 0x000fc60007fde0ffULL,
0x0000010035347825ULL, 0x000fe200078e0038ULL, 0x0000650013137a10ULL, 0x000fe400037fe4ffULL,
0x000064003a3a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001046117824ULL, 0x000fe400078e0209ULL,
0x0000010043387825ULL, 0x000fe200078e0038ULL, 0x000065003b3b7a10ULL, 0x000fe400037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036117faeULL, 0x0003e2000e101c46ULL,
0x0000001042437824ULL, 0x100fe200078e0209ULL, 0x000000414800720cULL, 0x080fe20003fc6070ULL,
0x000000014a427824ULL, 0x100fe200078e0204ULL, 0x0000640034347a10ULL, 0x000fe20007f9e0ffULL,
0x000000084a457824ULL, 0x040fe200078e00ffULL, 0x000000000e437faeULL, 0x0005e2000e901c46ULL,
0x000000414a00720cULL, 0x000fe20003fa6070ULL, 0x0000000148417824ULL, 0x040fe200078e0204ULL,
0x0000650035357a10ULL, 0x000fe200027fe4ffULL, 0x0000000848487824ULL, 0x000fe200078e00ffULL,
0xfffffff845427812ULL, 0x000fe200078ee242ULL, 0x0000001040117824ULL, 0x102fe200078e0209ULL,
0x0000640038387a10ULL, 0x000fe20007f9e0ffULL, 0x0000001000377824ULL, 0x000fe200078e0209ULL,
0xfffffff848367812ULL, 0x000fe200078ee241ULL, 0x0000001044417824ULL, 0x100fe200078e0209ULL,
0x0000650039397a10ULL, 0x000fe200027fe4ffULL, 0x000000100c0f7824ULL, 0x104fe200078e0209ULL,
0x0000000032117faeULL, 0x0003e2000d901c46ULL, 0x0000001036437824ULL, 0x000fc400078e0209ULL,
0x0000001042457824ULL, 0x000fe200078e0209ULL, 0x00000000300f7faeULL, 0x0003e8000d101c46ULL,
0x0000000012377faeULL, 0x0003e8000c901c46ULL, 0x000000003a417faeULL, 0x0003e8000c101c46ULL,
0x0000000034437faeULL, 0x0003e8000f101c46ULL, 0x0000000038457faeULL, 0x0003e2000e901c46ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000004040f7811ULL, 0x042fe200078fe8ffULL,
0x00000080693a7824ULL, 0x000fe200078e026fULL, 0x0000000804137811ULL, 0x000fc400078fe8ffULL,
0x0000001404357811ULL, 0x040fe200078fe8ffULL, 0x000000010f467824ULL, 0x140fe200078e0204ULL,
0x0000001804377811ULL, 0x040fe200078fe8ffULL, 0x000000080f317824ULL, 0x000fe200078e00ffULL,
0x0000001c040e7811ULL, 0x040fe200078fe8ffULL, 0x0000000113447824ULL, 0x040fe400078e0204ULL,
0x0000000813337824ULL, 0x000fe200078e00ffULL, 0xfffffff831467812ULL, 0x000fe200078ee246ULL,
0x00000001350c7824ULL, 0x040fe200078e0204ULL, 0x0000000c04317811ULL, 0x040fe200078fe8ffULL,
0x0000000835417824ULL, 0x000fe200078e00ffULL, 0xfffffff833447812ULL, 0x000fe200078ee244ULL,
0x0000000137007824ULL, 0x100fe200078e0204ULL, 0x0000001004337811ULL, 0x000fe200078fe8ffULL,
0x0000000131427824ULL, 0x000fe200078e0204ULL, 0xfffffff8410c7812ULL, 0x000fe200078ee20cULL,
0x0000000831397824ULL, 0x000fc400078e00ffULL, 0x0000000133407824ULL, 0x040fe400078e0204ULL,
0x00000008333b7824ULL, 0x000fe200078e00ffULL, 0xfffffff839427812ULL, 0x000fe200078ee242ULL,
0x0000000837437824ULL, 0x000fe200078e00ffULL, 0x0000001104397211ULL, 0x000fe200078fe8ffULL,
0x000000010f0f7824ULL, 0x100fe200078e0211ULL, 0xfffffff83b407812ULL, 0x000fe200078ee240ULL,
0x0000000113137824ULL, 0x100fe200078e0211ULL, 0xfffffff843007812ULL, 0x000fe200078ee200ULL,
0x0000000131317824ULL, 0x000fc400078e0211ULL, 0x0000000133337824ULL, 0x100fe400078e0211ULL,
0x0000000135357824ULL, 0x100fe400078e0211ULL, 0x0000000137377824ULL, 0x100fe400078e0211ULL,
0x000000ffff3b7224ULL, 0x000fe400078e00ffULL, 0x000000010e117824ULL, 0x040fe400078e0211ULL,
0x000000010e417824ULL, 0x000fc400078e0204ULL, 0x000000080e4a7824ULL, 0x000fe400078e00ffULL,
0x0000010039387825ULL, 0x000fc600078e003aULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee241ULL,
0x000001000f0e7825ULL, 0x000fe200078e003aULL, 0x0000640038387a10ULL, 0x000fc60007f1e0ffULL,
0x0000010013127825ULL, 0x100fe200078e003aULL, 0x000064000e0e7a10ULL, 0x000fe40007f3e0ffULL,
0x0000650039397a10ULL, 0x000fe200007fe4ffULL, 0x0000010031307825ULL, 0x100fe200078e003aULL,
0x000065000f0f7a10ULL, 0x000fe40000ffe4ffULL, 0x0000640012127a10ULL, 0x000fe20007f1e0ffULL,
0x0000010033327825ULL, 0x100fe200078e003aULL, 0x0000640030307a10ULL, 0x000fe40007f3e0ffULL,
0x0000650013137a10ULL, 0x000fe200007fe4ffULL, 0x0000010035347825ULL, 0x000fe200078e003aULL,
0x0000640032327a10ULL, 0x000fc40007f5e0ffULL, 0x0000650031317a10ULL, 0x000fe20000ffe4ffULL,
0x0000010037367825ULL, 0x100fe200078e003aULL, 0x0000640034347a10ULL, 0x000fe40007f1e0ffULL,
0x0000650033337a10ULL, 0x000fe200017fe4ffULL, 0x00000100113a7825ULL, 0x000fe200078e003aULL,
0x0000000404117211ULL, 0x000fe400078fe8ffULL, 0x0000640036367a10ULL, 0x000fe20007f3e0ffULL,
0x0000001046417824ULL, 0x100fe200078e0209ULL, 0x0000000711117812ULL, 0x000fe200078ec0ffULL,
0x0000001044437824ULL, 0x100fe200078e0209ULL, 0x000064003a3a7a10ULL, 0x000fe20007f5e0ffULL,
0x0000001042457824ULL, 0x100fe200078e0209ULL, 0x0ffffff811487812ULL, 0x000fe200078ef804ULL,
0x0000001040477824ULL, 0x100fe200078e0209ULL, 0x0000650035357a10ULL, 0x000fe200007fe4ffULL,
0x000000100c497824ULL, 0x100fe200078e0209ULL, 0x0000650037377a10ULL, 0x000fe20000ffe4ffULL,
0x0000001048117824ULL, 0x100fe200078e0209ULL, 0x000065003b3b7a10ULL, 0x000fe200017fe4ffULL,
0x00000010004b7824ULL, 0x000fc400078e0209ULL, 0x000000104a4d7824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038117faeULL, 0x0003e8000b901c46ULL,
0x000000000e417faeULL, 0x0003e8000b901c46ULL, 0x0000000012437faeULL, 0x0003e8000b901c46ULL,
0x0000000030457faeULL, 0x0003e8000b901c46ULL, 0x0000000032477faeULL, 0x0003e8000b901c46ULL,
0x0000000034497faeULL, 0x0003e8000b901c46ULL, 0x00000000364b7faeULL, 0x0003e8000b901c46ULL,
0x000000003a4d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010710f7812ULL, 0x002fca00078ec0ffULL, 0x0000002008087824ULL, 0x000fc800078e020fULL,
0x0000000869087824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b64800080e7f8cULL, 0x0002a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01b64c0008117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x00cfe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003012117210ULL, 0x000fca0007f1e1ffULL,
0x0000000131307824ULL, 0x000fe200000e0e13ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011430ULL,
0x0000001100007211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0630ULL,
0x0000000200007819ULL, 0x000fc80000001211ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b64c0008117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002002007824ULL, 0x000fca00078e00ffULL, 0xffffff8000007812ULL, 0x000fc800078ec0ffULL,
0x000001006f0f7810ULL, 0x000fca0007ffe000ULL, 0x00000001720f7824ULL, 0x000fca00078e020fULL,
0x01b000000f007984ULL, 0x000ea80000000800ULL, 0x01b200000f117984ULL, 0x0006620000000800ULL,
0x0000000d0000720bULL, 0x004fe20003f1d000ULL, 0x0000ec127f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c137812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff087224ULL, 0x002fd400078e000dULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000002020f7811ULL, 0x000fe400078ff0ffULL, 0x0000000d0000720bULL, 0x000fe40003f34000ULL,
0x000000020f00720cULL, 0x000fe20003f05270ULL, 0x0000ebc27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400008e0100ULL, 0x00000080020f8824ULL, 0x000fe200078e026fULL,
0x0000000d000c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910080e7816ULL, 0x000fe200000000ffULL, 0x00000001720f8824ULL, 0x000fca00078e020fULL,
0x01b4000c0f008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000d000c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000d0c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00337308ULL, 0x000e640000000800ULL, 0x0000003310107220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011604ULL,
0x0000eaf27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c330c7589ULL, 0x0002a400000e0000ULL,
0x0000000c2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c28287220ULL, 0x080fe40000410000ULL, 0x0000000c29297220ULL, 0x000fc40000410000ULL,
0x0000000c14147220ULL, 0x080fe40000410000ULL, 0x0000000c15157220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c18187220ULL, 0x080fe40000410000ULL, 0x0000000c19197220ULL, 0x000fc40000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000000c20207220ULL, 0x080fe40000410000ULL, 0x0000000c21217220ULL, 0x080fe40000410000ULL,
0x0000000c24247220ULL, 0x080fe40000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008040c7811ULL, 0x000fe200078ff0ffULL,
0x0000e9f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c330c7589ULL, 0x0004e400000e0000ULL,
0x0000000c2e2e7220ULL, 0x08cfe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000c16167220ULL, 0x080fe40000410000ULL, 0x0000000c17177220ULL, 0x000fc40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000c1f1f7220ULL, 0x000fc40000410000ULL,
0x0000000c22227220ULL, 0x080fe40000410000ULL, 0x0000000c23237220ULL, 0x080fe40000410000ULL,
0x0000000c26267220ULL, 0x080fe40000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007806008ULL,
0x0000000d00087209ULL, 0x000fd60007810000ULL, 0x8000000800000221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b00000820ULL, 0x000fc80000410000ULL, 0x0000000000050308ULL, 0x000e640000000800ULL,
0x0000000511110220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000001011107221ULL, 0x000fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff00723eULL, 0x000fe400000010ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011604ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000e8427f007947ULL, 0x000fea000b800000ULL,
0x00001f0d00067589ULL, 0x0002a400000e0000ULL, 0x000000080d0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000e8927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c00077589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100d0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0000ULL, 0x00006570000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000f09000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180d0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0000ULL,
0x000065e0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000f02000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000006e6d0c7212ULL, 0x00cfe200078efcffULL,
0x0000200002007824ULL, 0x042fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000002020e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff117819ULL, 0x000fe20000011602ULL,
0x000000080c0f7824ULL, 0x000fe200078e00ffULL, 0xffffc00000007812ULL, 0x000fe200078ec0ffULL,
0x00000200020d7824ULL, 0x000fc600078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x0000200069007824ULL, 0x000fe200078e0200ULL, 0x000000040e0a7812ULL, 0x000fe400078ec0ffULL,
0xfffff8000d0e7812ULL, 0x000fe400078ec0ffULL, 0x000000020a0d7812ULL, 0x000fe200078efcffULL,
0x000000080c0a7824ULL, 0x000fe200078e00ffULL, 0x0001300000007810ULL, 0x000fe20007ffe0ffULL,
0x000000100f487824ULL, 0x000fe200078e020eULL, 0x0000000d040d7211ULL, 0x000fc600078fe0ffULL,
0x0000001063547824ULL, 0x100fe400078e0200ULL, 0x012000004848783bULL, 0x000e620000000200ULL,
0x0000001062507824ULL, 0x100fe400078e0200ULL, 0x00000010654c7824ULL, 0x100fe200078e0200ULL,
0x000000005454783bULL, 0x000ea20000004200ULL, 0x000000010c0d7824ULL, 0x000fe400078e020dULL,
0x00000010640c7824ULL, 0x000fe200078e0200ULL, 0x000000005050783bULL, 0x000fe40000004200ULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee20dULL, 0x000000004c4c783bULL, 0x000fe60000004200ULL,
0x000000100a007824ULL, 0x000fe200078e00ffULL, 0x000130005d0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000000c0c783bULL, 0x000fe40000004200ULL, 0x0000080011307824ULL, 0x000fe400078e0200ULL,
0x0000001060407824ULL, 0x100fe400078e020aULL, 0x000000105e347824ULL, 0x000fc400078e020aULL,
0x012000003030783bULL, 0x000ee20000000200ULL, 0x000000105f387824ULL, 0x100fe400078e020aULL,
0x0000001061447824ULL, 0x000fe200078e020aULL, 0x000000004040783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000f280000004200ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x0000000648480231ULL, 0x002fc600003400ffULL, 0x000000004444783bULL, 0x000e620000004200ULL,
0x000000064a4a0231ULL, 0x000fe400003400ffULL, 0x0000000749490231ULL, 0x080fe400003400ffULL,
0x000000074b4b0231ULL, 0x000fce00003400ffULL, 0x000000544814723cULL, 0x044f700000041814ULL,
0x00000056483c723cULL, 0x000f62000004183cULL, 0x0000000630300231ULL, 0x088fe400003400ffULL,
0x0000000632320231ULL, 0x000fca00003400ffULL, 0x000000504818723cULL, 0x000f620000041818ULL,
0x0000000731310231ULL, 0x080fe400003400ffULL, 0x0000000733330231ULL, 0x000fca00003400ffULL,
0x00000052481c723cULL, 0x040f70000004181cULL, 0x0000004c4820723cULL, 0x040f700000041820ULL,
0x0000004e4824723cULL, 0x040f700000041824ULL, 0x0000000c482c723cULL, 0x040f70000004182cULL,
0x0000000e480c723cULL, 0x000f700000041828ULL, 0x000000403014723cULL, 0x070f700000041814ULL,
0x00000042303c723cULL, 0x040f70000004183cULL, 0x000000383018723cULL, 0x040f700000041818ULL,
0x0000003a301c723cULL, 0x040f70000004181cULL, 0x000000343020723cULL, 0x040f700000041820ULL,
0x000000363024723cULL, 0x040f700000041824ULL, 0x00000044302c723cULL, 0x042f70000004182cULL,
0x000000463044723cULL, 0x000b6e000004180cULL, 0x0001b698110c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x00000300030f7a10ULL, 0x000fe20007ffe0ffULL,
0x000000000cff7f8cULL, 0x0003e6000c80043fULL, 0x0000005c0f00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000ba000000947ULL, 0x000fea0003800000ULL,
0x000000010f0d7810ULL, 0x042fe20007ffe0ffULL, 0x000001000f0f7824ULL, 0x000fc600078e0270ULL,
0x0000005c0d00720cULL, 0x000fe20003f06070ULL, 0x000068006c357a24ULL, 0x000fd800078e020fULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff347819ULL, 0x100fe40000011604ULL,
0x0000000f660c7217ULL, 0x000fe40007800000ULL, 0x00000004340e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000834307810ULL, 0x000fe20007ffe0ffULL, 0x000000010c417824ULL, 0x000fe200078e0a0fULL,
0x0000000c34327810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0d7824ULL, 0x100fe200078e0204ULL,
0x0000001034367810ULL, 0x000fe20007ffe0ffULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x0000002041417817ULL, 0x000fe20003800000ULL, 0x0000000130377824ULL, 0x000fc400078e0204ULL,
0x0000000830287824ULL, 0x000fe200078e00ffULL, 0xfffffff812437812ULL, 0x000fe200078ee20dULL,
0x00000080690c7824ULL, 0x000fe200078e026fULL, 0x000000410e00720cULL, 0x080fe20003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xfffffff828377812ULL, 0x000fe200078ee237ULL,
0x00000001340f7824ULL, 0x140fe200078e0235ULL, 0x000000413400720cULL, 0x080fe20003fa6070ULL,
0x000000010e137824ULL, 0x000fe200078e0235ULL, 0x000000413200720cULL, 0x0c0fe20003f46070ULL,
0x00000001323b7824ULL, 0x000fe200078e0204ULL, 0x000000413000720cULL, 0x000fe20003f66070ULL,
0x0000000832287824ULL, 0x000fc400078e00ffULL, 0x000001000f0e7825ULL, 0x000fc600078e000cULL,
0xfffffff8283b7812ULL, 0x000fe200078ee23bULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x000064000e287a10ULL, 0x000fc60007f1e0ffULL, 0x00000001340e7824ULL, 0x100fe200078e0204ULL,
0x00006400122a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000136397824ULL, 0x040fe200078e0204ULL,
0x000065000f297a10ULL, 0x000fe200007fe4ffULL, 0x0000000836387824ULL, 0x000fe200078e00ffULL,
0x00006500132b7a10ULL, 0x000fe20000ffe4ffULL, 0x00000001300f7824ULL, 0x100fe200078e0235ULL,
0x000000070e337812ULL, 0x000fe200078ec0ffULL, 0x0000000132137824ULL, 0x000fe200078e0235ULL,
0xfffffff838397812ULL, 0x000fe200078ee239ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000001434387810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff833337812ULL, 0x000fe200078ef804ULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x000000413600720cULL, 0x000fe40003f26070ULL,
0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000136317824ULL, 0x000fe200078e0235ULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x0000000138327824ULL, 0x000fe200078e0204ULL,
0x0000001834367810ULL, 0x000fe20007ffe0ffULL, 0x00000008384d7824ULL, 0x000fe200078e00ffULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010031307825ULL, 0x000fe200078e000cULL,
0x0000650013137a10ULL, 0x000fc400037fe4ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee232ULL,
0x0000001033497824ULL, 0x100fe200078e020aULL, 0x0000640030307a10ULL, 0x000fe20007fde0ffULL,
0x0000000138337824ULL, 0x040fe200078e0235ULL, 0x000000413800720cULL, 0x080fe20003f06070ULL,
0x00000010434b7824ULL, 0x000fe200078e020aULL, 0x0000001c34387810ULL, 0x000fe20007ffe0ffULL,
0x0000010033327825ULL, 0x000fe200078e000cULL, 0x0000650031317a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028497faeULL, 0x0003e2000e901c46ULL,
0x000000413600720cULL, 0x0c0fe20003fa6070ULL, 0x0000000136437824ULL, 0x100fe200078e0235ULL,
0x0000640032327a10ULL, 0x000fe20007fde0ffULL, 0x000000002a4b7faeULL, 0x0005e2000e101c46ULL,
0x0000000138357824ULL, 0x040fe200078e0235ULL, 0x000000413800720cULL, 0x000fe20003f86070ULL,
0x0000000136347824ULL, 0x040fe200078e0204ULL, 0x0000650033337a10ULL, 0x000fe200037fe4ffULL,
0x0000000836417824ULL, 0x000fc400078e00ffULL, 0x0000001037377824ULL, 0x000fe400078e020aULL,
0x0000010043287825ULL, 0x002fe200078e000cULL, 0xfffffff8412b7812ULL, 0x004fc600078ee234ULL,
0x00000001382a7824ULL, 0x000fe200078e0204ULL, 0x0000640028287a10ULL, 0x000fe20007fde0ffULL,
0x0000000838437824ULL, 0x000fe200078e00ffULL, 0x000000000e377faeULL, 0x0003e2000d901c46ULL,
0x00000100350c7825ULL, 0x000fe200078e000cULL, 0x0000650029297a10ULL, 0x000fe400037fe4ffULL,
0xfffffff843357812ULL, 0x000fe200078ee22aULL, 0x000000103b3b7824ULL, 0x100fe200078e020aULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001039397824ULL, 0x000fc400078e020aULL,
0x000000104d4d7824ULL, 0x100fe200078e020aULL, 0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x000000102b2b7824ULL, 0x100fe200078e020aULL, 0x00000000123b7faeULL, 0x0003e2000d101c46ULL,
0x0000001035357824ULL, 0x000fc600078e020aULL, 0x0000000030397faeULL, 0x0003e8000c901c46ULL,
0x00000000324d7faeULL, 0x0003e8000c101c46ULL, 0x00000000282b7faeULL, 0x0003e8000e901c46ULL,
0x000000000c357faeULL, 0x0003e2000e101c46ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000008040d7811ULL, 0x040fe200078fe8ffULL, 0x00000080692a7824ULL, 0x000fe200078e026fULL,
0x0000000404337811ULL, 0x040fe200078fe8ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x0000001004137811ULL, 0x040fe200078fe8ffULL, 0x000000010d0e7824ULL, 0x140fe200078e0204ULL,
0x0000000c040f7811ULL, 0x040fe200078fe8ffULL, 0x000000080d437824ULL, 0x000fe200078e00ffULL,
0x0000001404297811ULL, 0x040fe200078fe8ffULL, 0x00000001330c7824ULL, 0x040fe200078e0204ULL,
0x0000001804377811ULL, 0x040fe200078fe8ffULL, 0x0000000833417824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee20eULL, 0x00000001130e7824ULL, 0x040fe200078e0204ULL,
0x0000003504317211ULL, 0x000fe200078fe8ffULL, 0x00000008134b7824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x000fc400078e0204ULL,
0x000000080f497824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee20eULL,
0x0000000133337824ULL, 0x100fe200078e0235ULL, 0x0000001c040e7811ULL, 0x040fe200078fe8ffULL,
0x000000010d0d7824ULL, 0x100fe200078e0235ULL, 0xfffffff849497812ULL, 0x000fe200078ee20cULL,
0x000000010f0f7824ULL, 0x000fe200078e0235ULL, 0x00000004040c7211ULL, 0x000fe200078fe8ffULL,
0x0000000129127824ULL, 0x140fe400078e0204ULL, 0x00000008294d7824ULL, 0x000fe200078e00ffULL,
0x000000070c3b7812ULL, 0x000fe200078ec0ffULL, 0x0000000137287824ULL, 0x000fc400078e0204ULL,
0x00000008374f7824ULL, 0x000fe200078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee212ULL,
0x0000010031307825ULL, 0x000fe200078e002aULL, 0x0ffffff83b3b7812ULL, 0x000fe400078ef804ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee228ULL, 0x0000000113137824ULL, 0x100fe200078e0235ULL,
0x0000640030307a10ULL, 0x000fe20007f1e0ffULL, 0x0000000129297824ULL, 0x100fe400078e0235ULL,
0x0000000137377824ULL, 0x100fe200078e0235ULL, 0x0000650031317a10ULL, 0x000fe200007fe4ffULL,
0x000000010e397824ULL, 0x000fc400078e0235ULL, 0x0000010033327825ULL, 0x000fc800078e002aULL,
0x000001000d347825ULL, 0x000fe200078e002aULL, 0x0000640032327a10ULL, 0x000fc60007f3e0ffULL,
0x000001000f0c7825ULL, 0x000fe200078e002aULL, 0x0000640034347a10ULL, 0x000fe40007f5e0ffULL,
0x0000650033337a10ULL, 0x000fe20000ffe4ffULL, 0x000000010e367824ULL, 0x000fe200078e0204ULL,
0x000064000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000080e517824ULL, 0x000fe200078e00ffULL,
0x0000650035357a10ULL, 0x000fe200017fe4ffULL, 0x00000100130e7825ULL, 0x000fe200078e002aULL,
0x000065000d0d7a10ULL, 0x000fc60001ffe4ffULL, 0x0000010029127825ULL, 0x000fe200078e002aULL,
0x000064000e0e7a10ULL, 0x000fc60007f1e0ffULL, 0x0000010037287825ULL, 0x000fe200078e002aULL,
0x0000640012127a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff851377812ULL, 0x000fe200078ee236ULL,
0x00000100392a7825ULL, 0x000fe200078e002aULL, 0x0000640028287a10ULL, 0x000fe40007f5e0ffULL,
0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x000000103b3b7824ULL, 0x100fe200078e020aULL,
0x000064002a2a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001041417824ULL, 0x100fe200078e020aULL,
0x0000650013137a10ULL, 0x000fe20000ffe4ffULL, 0x0000001043437824ULL, 0x100fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303b7faeULL, 0x0003e2000b901c46ULL,
0x0000001049497824ULL, 0x100fe200078e020aULL, 0x0000650029297a10ULL, 0x000fe200017fe4ffULL,
0x000000104b4b7824ULL, 0x100fe200078e020aULL, 0x0000000032417faeULL, 0x0003e2000b901c46ULL,
0x000000104d4d7824ULL, 0x100fe200078e020aULL, 0x000065002b2b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000104f4f7824ULL, 0x100fe200078e020aULL, 0x0000000034437faeULL, 0x0003e2000b901c46ULL,
0x0000001037377824ULL, 0x000fc600078e020aULL, 0x000000000c497faeULL, 0x0003e8000b901c46ULL,
0x000000000e4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000124d7faeULL, 0x0003e8000b901c46ULL,
0x00000000284f7faeULL, 0x0003e8000b901c46ULL, 0x000000002a377faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x00000010710a7812ULL, 0x000fc400078ec0ffULL,
0x00000008710d7812ULL, 0x000fc600078ec0ffULL, 0x00000020110a7824ULL, 0x000fc800078e020aULL,
0x000000010d0a7824ULL, 0x000fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b668000a127f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b66c000a0f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000110e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b66c000a0f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000003020a7811ULL, 0x002fca00078ff0ffULL, 0x000000800a0d7824ULL, 0x000fc800078e026fULL,
0x00000001720d7824ULL, 0x000fca00078e020dULL, 0x01b000000d117984ULL, 0x000e680000000800ULL,
0x01b200000d0a7984ULL, 0x0004e20000000800ULL, 0x000000081100720bULL, 0x002fe20003f1d000ULL,
0x0000d4627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c127812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000003020d7811ULL, 0x000fe400078ff0ffULL, 0x000000081100720bULL, 0x000fe40003f34000ULL,
0x000000020d00720cULL, 0x000fe20003f05270ULL, 0x0000d4227f007947ULL, 0x000fd4000b800000ULL,
0x00000000000d7806ULL, 0x000fc400008e0100ULL, 0x00000080026f8824ULL, 0x000fe200078e026fULL,
0x00000008110c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100d0e7816ULL, 0x000fe200000000ffULL, 0x00000001726f8824ULL, 0x000fca00078e026fULL,
0x01b4000c6f008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000008110f7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL,
0x000000080f0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00137308ULL, 0x000e640000000800ULL, 0x0000001310107220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011604ULL,
0x0000d3527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c130c7589ULL, 0x0002a400000e0000ULL,
0x0000000c2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c44447220ULL, 0x080fe40000410000ULL, 0x0000000c45457220ULL, 0x000fc40000410000ULL,
0x0000000c14147220ULL, 0x080fe40000410000ULL, 0x0000000c15157220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c18187220ULL, 0x080fe40000410000ULL, 0x0000000c19197220ULL, 0x000fc40000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000000c20207220ULL, 0x080fe40000410000ULL, 0x0000000c21217220ULL, 0x080fe40000410000ULL,
0x0000000c24247220ULL, 0x080fe40000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008040c7811ULL, 0x000fe200078ff0ffULL,
0x0000d2527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c130c7589ULL, 0x00046400000e0000ULL,
0x0000000c2e2e7220ULL, 0x086fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c46467220ULL, 0x080fe40000410000ULL, 0x0000000c47477220ULL, 0x080fe40000410000ULL,
0x0000000c16167220ULL, 0x080fe40000410000ULL, 0x0000000c17177220ULL, 0x000fc40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000c1f1f7220ULL, 0x000fc40000410000ULL,
0x0000000c22227220ULL, 0x080fe40000410000ULL, 0x0000000c23237220ULL, 0x080fe40000410000ULL,
0x0000000c26267220ULL, 0x080fe40000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff12ff7812ULL, 0x000fe4000780600dULL,
0x0000000811087209ULL, 0x000fd60007810000ULL, 0x8000000811110221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100050308ULL, 0x000e640000000800ULL,
0x000000050a0a0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000100a0a7221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000010ffULL, 0x00000002ff107819ULL, 0x000fe40000011604ULL,
0x00005410060d7816ULL, 0x000fe20000000006ULL, 0x0000d0a27f007947ULL, 0x000fea000b800000ULL,
0x00001f100d067589ULL, 0x0002a400000e0000ULL, 0x00000008100c7810ULL, 0x000fe20007ffe0ffULL,
0x0000d0f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d077589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010100c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00007f70000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000d69000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018100c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x00007fe0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000d62000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002020c7824ULL, 0x00cfe200078e00ffULL,
0x0000006e6d6d7212ULL, 0x000fe200078efcffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000040c0d7812ULL, 0x002fe200078ec0ffULL, 0x000000086d0f7824ULL, 0x000fc600078e00ffULL,
0x0000000d040c7211ULL, 0x000fe400078fe0ffULL, 0x00000003020d7811ULL, 0x000fc600078ff0ffULL,
0x000000016d0c7824ULL, 0x000fe400078e020cULL, 0x000008000d0d7824ULL, 0x000fc600078e00ffULL,
0xfffffff80f0c7812ULL, 0x000fca00078ee20cULL, 0x000000100c107824ULL, 0x000fcc00078e020dULL,
0x011000001010783bULL, 0x000e620000000200ULL, 0x0000001064287824ULL, 0x100fe200078e0209ULL,
0x000110000d0d7810ULL, 0x000fe20007ffe000ULL, 0x0000001063507824ULL, 0x100fe200078e0209ULL,
0x000000006838783bULL, 0x000fe20000004200ULL, 0x00000010624c7824ULL, 0x100fe200078e0209ULL,
0x00000002ff007819ULL, 0x000fe20000011602ULL, 0x0000001065487824ULL, 0x000fe200078e0209ULL,
0x000000002828783bULL, 0x000ea20000004200ULL, 0x0000030003037a10ULL, 0x000fe40007ffe0ffULL,
0x0001b6a000007811ULL, 0x000fe200078e18ffULL, 0x000000005050783bULL, 0x000ee80000004200ULL,
0x000000004c4c783bULL, 0x000fe80000004200ULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x000000000d0c783bULL, 0x000f280000000200ULL, 0x000000006740783bULL, 0x000f280000004200ULL,
0x000000006a34783bULL, 0x000f280000004200ULL, 0x000000006b30783bULL, 0x000f220000004200ULL,
0x0000000610100231ULL, 0x002fc400003400ffULL, 0x0000000612120231ULL, 0x000fe400003400ffULL,
0x0000000711110231ULL, 0x080fe400003400ffULL, 0x0000000713130231ULL, 0x000fce00003400ffULL,
0x00000028102c723cULL, 0x044ff0000004182cULL, 0x000000501014723cULL, 0x008f620000041814ULL,
0x000000060c0c0231ULL, 0x090fe400003400ffULL, 0x000000060e0e0231ULL, 0x000fc400003400ffULL,
0x000000070d0d0231ULL, 0x000fc600003400ffULL, 0x0000002a1028723cULL, 0x000f620000041844ULL,
0x000000070f0f0231ULL, 0x000fce00003400ffULL, 0x00000052103c723cULL, 0x040f70000004183cULL,
0x0000004c1018723cULL, 0x040f700000041818ULL, 0x0000004e101c723cULL, 0x040f70000004181cULL,
0x000000481020723cULL, 0x040f700000041820ULL, 0x0000004a1024723cULL, 0x000f700000041824ULL,
0x000000380c10723cULL, 0x060b700000041814ULL, 0x000000400c2c723cULL, 0x040b70000004182cULL,
0x000000420c28723cULL, 0x040b700000041828ULL, 0x0000003a0c14723cULL, 0x040b70000004183cULL,
0x000000340c18723cULL, 0x040b700000041818ULL, 0x000000360c1c723cULL, 0x040b70000004181cULL,
0x000000300c20723cULL, 0x040b700000041820ULL, 0x000000320c24723cULL, 0x000b620000041824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000005c0300720cULL, 0x000fe20003f06070ULL,
0x0000000000ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff970000007947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000e620000002500ULL,
0x000000ffff077224ULL, 0x020fe400078e0014ULL, 0x000000ffff147224ULL, 0x000fe200078e0012ULL,
0x0000005c0300720cULL, 0x002fda0003f06070ULL, 0x0000033000000947ULL, 0x000fea0003800000ULL,
0x018000000a007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000849000067802ULL, 0x000fc40000000f00ULL,
0x0000cfa000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e000dULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000a00057308ULL, 0x000e640000001000ULL,
0xbf80000005007423ULL, 0x002fc8000000000aULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000005007223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000ea40000000000ULL, 0x00000002ff097819ULL, 0x004fe40000011605ULL,
0x0000000805057811ULL, 0x000fc600078ff0ffULL, 0x00001f0900047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000002c042c7220ULL, 0x044fe40000410000ULL,
0x0000002d042d7220ULL, 0x040fe40000410000ULL, 0x0000002804287220ULL, 0x040fe40000410000ULL,
0x0000002904297220ULL, 0x000fc40000410000ULL, 0x0000001004107220ULL, 0x040fe40000410000ULL,
0x0000001104117220ULL, 0x040fe40000410000ULL, 0x0000000704077220ULL, 0x040fe40000410000ULL,
0x0000001504157220ULL, 0x040fe40000410000ULL, 0x0000001804187220ULL, 0x040fe40000410000ULL,
0x0000001904197220ULL, 0x000fc40000410000ULL, 0x0000001c041c7220ULL, 0x040fe40000410000ULL,
0x0000001d041d7220ULL, 0x040fe40000410000ULL, 0x0000002004207220ULL, 0x040fe40000410000ULL,
0x0000002104217220ULL, 0x040fe40000410000ULL, 0x0000002404247220ULL, 0x040fe40000410000ULL,
0x0000002504257220ULL, 0x000fc40000410000ULL, 0x0000002e052e7220ULL, 0x048fe40000410000ULL,
0x0000002f052f7220ULL, 0x040fe40000410000ULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002b052b7220ULL, 0x040fe40000410000ULL, 0x0000001405147220ULL, 0x040fe40000410000ULL,
0x0000001305137220ULL, 0x000fc40000410000ULL, 0x0000001605167220ULL, 0x040fe40000410000ULL,
0x0000001705177220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe40000410000ULL,
0x0000001b051b7220ULL, 0x040fe40000410000ULL, 0x0000001e051e7220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x000fc40000410000ULL, 0x0000002205227220ULL, 0x040fe40000410000ULL,
0x0000002305237220ULL, 0x040fe40000410000ULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002705277220ULL, 0x000fc40000410000ULL, 0x00000000000d7919ULL, 0x000ea20000000000ULL,
0x0000001c1d0e723eULL, 0x000fe400000010ffULL, 0x00000018190c723eULL, 0x000fe200000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000141313723eULL, 0x000fc400000010ffULL,
0x000000161714723eULL, 0x000fe400000010ffULL, 0x000000071507723eULL, 0x000fe400000010ffULL,
0x0000001e1f16723eULL, 0x000fe400000010ffULL, 0x0000001a1b15723eULL, 0x000fe400000010ffULL,
0x000000101106723eULL, 0x000fe400000010ffULL, 0x000000242510723eULL, 0x000fc400000010ffULL,
0x00000002ff1d7819ULL, 0x004fe4000001160dULL, 0x000000262718723eULL, 0x000fe400000010ffULL,
0x000000011d007810ULL, 0x040fe20007ffe0ffULL, 0x000000081d197824ULL, 0x040fe200078e00ffULL,
0x000000061d1a7810ULL, 0x040fe20007ffe0ffULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0x000000021d097810ULL, 0x040fe20007ffe0ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8191c7812ULL, 0x000fe200078ee200ULL, 0x000000081d1b7824ULL, 0x040fe200078e00ffULL,
0x000000031d007810ULL, 0x040fe20007ffe0ffULL, 0x000000081d247824ULL, 0x000fe200078e00ffULL,
0x000000222317723eULL, 0x000fe200000010ffULL, 0x000000081d227824ULL, 0x040fe200078e00ffULL,
0x000000051d197810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81f267812ULL, 0x000fe200078ee21aULL,
0x000000081d1a7824ULL, 0x000fe200078e00ffULL, 0x00000020210f723eULL, 0x000fe200000010ffULL,
0x00000300ff217624ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee209ULL,
0x000000041d097810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81b207812ULL, 0x000fe200078ee200ULL,
0x0000100069007824ULL, 0x000fe200078e00ffULL, 0x0000002a2b12723eULL, 0x000fc400000010ffULL,
0xfffffff824247812ULL, 0x000fe200078ee219ULL, 0x000000040d197824ULL, 0x040fe200078e00ffULL,
0x000000080d2a7811ULL, 0x000fe400078ff0ffULL, 0xfffffff822227812ULL, 0x000fe200078ee209ULL,
0x000008000b097824ULL, 0x000fe200078e0200ULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee21dULL,
0x000000282905723eULL, 0x000fe200000010ffULL, 0x000000081d287824ULL, 0x040fe200078e00ffULL,
0xffffffff1d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000082a1d7824ULL, 0x000fe200078e00ffULL,
0x0000000c19197812ULL, 0x000fe200078ec0ffULL, 0x000000101a1a7824ULL, 0x000fe200078e0209ULL,
0xfffffff828287812ULL, 0x000fe200078ee21bULL, 0x000000101c1c7824ULL, 0x100fe200078e0209ULL,
0xfffffff81d2a7812ULL, 0x000fe200078ee22aULL, 0x000000101e1e7824ULL, 0x100fe200078e0209ULL,
0x0000002c2d04723eULL, 0x000fe200000010ffULL, 0x0000001020207824ULL, 0x100fe200078e0209ULL,
0x0000002e2f11723eULL, 0x000fe200000010ffULL, 0x0000001022227824ULL, 0x000fc400078e0209ULL,
0x000000011a1b7824ULL, 0x000fe400078e0219ULL, 0x0000001024247824ULL, 0x100fe400078e0209ULL,
0x00000001191c7824ULL, 0x040fe200078e021cULL, 0x000000041b007388ULL, 0x000fe20000000800ULL,
0x0000001026267824ULL, 0x100fe400078e0209ULL, 0x00000001191e7824ULL, 0x000fe200078e021eULL,
0x000000051c007388ULL, 0x000fe20000000800ULL, 0x0000001028287824ULL, 0x000fc400078e0209ULL,
0x0000000119207824ULL, 0x040fe200078e0220ULL, 0x000000061e007388ULL, 0x000fe20000000800ULL,
0x000000102a2a7824ULL, 0x000fe400078e0209ULL, 0x0000000119227824ULL, 0x040fe200078e0222ULL,
0x0000000720007388ULL, 0x000fe20000000800ULL, 0x00000001191d7824ULL, 0x040fe400078e0224ULL,
0x0000000119267824ULL, 0x040fe200078e0226ULL, 0x0000000c22007388ULL, 0x0005e20000000800ULL,
0x00000001191f7824ULL, 0x000fc400078e0228ULL, 0x00000001192a7824ULL, 0x000fe200078e022aULL,
0x0000000e1d007388ULL, 0x0007e20000000800ULL, 0x0000000170197824ULL, 0x000fc600078e020dULL,
0x0000000f26007388ULL, 0x0009e20000000800ULL, 0x00000010191a7824ULL, 0x000fe200078e0200ULL,
0x000000ff000c7306ULL, 0x004fe4000020d400ULL, 0x000000101f007388ULL, 0x000fe80000000800ULL,
0x000000112a007388ULL, 0x000fe40000000800ULL, 0x000000ff000e7306ULL, 0x008fe40000205400ULL,
0x000400121c007388ULL, 0x000fe80000000800ULL, 0x000400131e007388ULL, 0x000fe40000000800ULL,
0x000000ff000f7306ULL, 0x010ea40000209400ULL, 0x0004001420007388ULL, 0x000fe80000000800ULL,
0x0004001522007388ULL, 0x000fe80000000800ULL, 0x000400161d007388ULL, 0x000fe80000000800ULL,
0x0004001726007388ULL, 0x000fe20000000800ULL, 0x0000000e0f00720bULL, 0x004fc60003f1d000ULL,
0x000400181f007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000001a287984ULL, 0x000ea20000000c00ULL, 0x000000010c0c0812ULL, 0x000fc400078efcffULL,
0x000000012100780cULL, 0x000fe20003f05270ULL, 0x000400001a107984ULL, 0x000ee20000000c00ULL,
0x0000000c0c14723eULL, 0x000fc600000010ffULL, 0x000800001a2c7984ULL, 0x000f280000000c00ULL,
0x000c00001a047984ULL, 0x000e620000000c00ULL, 0x3f803f80142b7831ULL, 0x044fe4000020002bULL,
0x3f803f80142a7831ULL, 0x040fe4000020002aULL, 0x3f803f8014297831ULL, 0x040fe40000200029ULL,
0x3f803f8014287831ULL, 0x000fc40000200028ULL, 0x3f803f8014137831ULL, 0x048fe40000200013ULL,
0x3f803f8014127831ULL, 0x040fe40000200012ULL, 0x3f803f8014117831ULL, 0x040fe40000200011ULL,
0x3f803f8014107831ULL, 0x000fe40000200010ULL, 0x3f803f802b2b7831ULL, 0x010fe4000020002fULL,
0x3f803f802a2a7831ULL, 0x000fc4000020002eULL, 0x3f803f8029297831ULL, 0x000fe4000020002dULL,
0x3f803f8028287831ULL, 0x000fe4000020002cULL, 0x3f803f8013137831ULL, 0x002fe40000200007ULL,
0x3f803f8012127831ULL, 0x000fe20000200006ULL, 0x000000281a007388ULL, 0x000fe20000000c00ULL,
0x3f803f8011117831ULL, 0x000fe40000200005ULL, 0x3f803f8010107831ULL, 0x000fca0000200004ULL,
0x000400101a007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002a8000008947ULL, 0x000fea0003800000ULL, 0x00000400ff047624ULL, 0x000fe200078e00ffULL,
0x00000000001e7919ULL, 0x000e620000002600ULL, 0x00000040191b7810ULL, 0x000fc40007ffe0ffULL,
0x00006a0004047a24ULL, 0x000fe200078e02ffULL, 0x0000000000177919ULL, 0x000e660000002700ULL,
0x00000300040e7a24ULL, 0x040fe200078e02ffULL, 0x0000000f04157811ULL, 0x000fe200078e10ffULL,
0x000400001a107984ULL, 0x0004e60000000c00ULL, 0xfffffff015157812ULL, 0x000fe200078ec0ffULL,
0x000000001a047984ULL, 0x0004a80000000c00ULL, 0x000000800e0f7824ULL, 0x000fc800078e0215ULL,
0x000000800e0e7824ULL, 0x000fca00078e020fULL, 0x0000007f0e147810ULL, 0x000fe20007ffe0ffULL,
0x00000400171e7a24ULL, 0x002fc600078e021eULL, 0xffffff8014147812ULL, 0x000fe200078ec0ffULL,
0x000003001e0e7a24ULL, 0x000fc600078e02ffULL, 0x00006e0014167a10ULL, 0x000fe20007f1e0ffULL,
0x000000010e037824ULL, 0x000fc800078e0203ULL, 0x00006f00ff187624ULL, 0x000fe200000e06ffULL,
0x000000010bff7812ULL, 0x000fe4000780f802ULL, 0x0000001603167211ULL, 0x000fc800078260ffULL,
0x0000001803177211ULL, 0x000fe400008f64ffULL, 0x00006e00151f7a10ULL, 0x000fc60007f3e0ffULL,
0x0000080069167825ULL, 0x000fc800078e0016ULL, 0x00006f00ff207624ULL, 0x000fe400008e06ffULL,
0x0000001019187825ULL, 0x000fc800078e0016ULL, 0x000000101b167825ULL, 0x000fe200078e0016ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x000000100d1b7824ULL, 0x00cfe200078e00ffULL,
0x00000001ff1c7819ULL, 0x000fe2000001160dULL, 0x00000080031a7824ULL, 0x000fe200078e00ffULL,
0x00000019ff037819ULL, 0x000fe40000011603ULL, 0x000000701b1b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL, 0x00006e001a1c7a10ULL, 0x000fc40007ebe00fULL,
0x0000001f1b1a7210ULL, 0x000fe40007a3e01aULL, 0x0000001c1d1c7210ULL, 0x000fe40007c7e01bULL,
0x00006f00031b7a10ULL, 0x000fe40002fec4ffULL, 0x0000001a1d1a7210ULL, 0x000fe40007fbe0ffULL,
0x00000020ff037210ULL, 0x000fe40000fe4403ULL, 0x0000001bff1d7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff1b7224ULL, 0x000fca00028e0603ULL, 0x000000081a007986ULL, 0x0003e8000c101906ULL,
0x0000000a1c007986ULL, 0x0003e4000c101906ULL, 0x000000ff0d00720cULL, 0x00cfe20000705670ULL,
0x0000000418007986ULL, 0x000fe2000c101d06ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x0000001016007986ULL, 0x000fe8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0xffffffff21037810ULL, 0x000fc60007ffe0ffULL, 0x00006e001e047625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000003040479a8ULL, 0x000ea400099ee1c6ULL,
0x000000030400720cULL, 0x004fc80003f05270ULL, 0x00000001ff067807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000006ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff037984ULL, 0x000ee40000000000ULL, 0x000000ff0300720cULL, 0x008fda0003f05270ULL,
0x0000260000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x000000100d037824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x004fe4000001160dULL, 0x0000001f0e047211ULL, 0x000fe400078038ffULL,
0x0000007003057812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x000000200e037211ULL, 0x000fe400000f3cffULL, 0x0000000406047210ULL, 0x000fc8000791e005ULL,
0x00000003ff057210ULL, 0x000fca00007e24ffULL, 0x0000000604037981ULL, 0x000528000c1e1900ULL,
0x0000800604067981ULL, 0x000522000c1e1900ULL, 0x000000022100780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x0001000604087981ULL, 0x006322000c1e1900ULL,
0x000000042100780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x00018006040a7981ULL, 0x002322000c1e1900ULL, 0x000000042100780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000604107981ULL, 0x002322000c1e1900ULL,
0x000000062100780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800604127981ULL, 0x002322000c1e1900ULL, 0x000000062100780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082100780cULL, 0x002fe20003f06070ULL,
0x0003000604167981ULL, 0x000318000c1e1900ULL, 0x0003800604180981ULL, 0x000324000c1e1900ULL,
0x0000000721047810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff077819ULL, 0x000fc80000011604ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x000000150e117211ULL, 0x040fe200078038ffULL, 0x000000ffff177224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1a7224ULL, 0x010fe200078e0003ULL,
0x00006e0011117a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff0e137211ULL, 0x000fe400000f3cffULL,
0x0000078011117810ULL, 0x000fc80007f5e0ffULL, 0x00006f00ff137a10ULL, 0x000fc400017e2413ULL,
0x0000030017007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000407007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x0000000817047810ULL, 0x040fe40007ffe0ffULL, 0x0000000117057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001a03037209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0xfffc8006041a7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x0000000917047810ULL, 0x042fe40007ffe0ffULL, 0x0000000217057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000603037209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0xfffd000604067981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a17047810ULL, 0x042fe40007ffe0ffULL, 0x0000000317057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000803037209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0xfffd800604087981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b17047810ULL, 0x042fe40007ffe0ffULL, 0x0000000417057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000a03037209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0xfffe0006040a7981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c17047810ULL, 0x042fe40007ffe0ffULL, 0x0000000517057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001003037209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0xfffe800604107981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d17047810ULL, 0x042fe40007ffe0ffULL, 0x0000000617057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001203037209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0xffff000604127981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e17047810ULL, 0x042fe40007ffe0ffULL, 0x0000000717057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001603037209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0xffff800604167981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f17047810ULL, 0x002fe40007ffe0ffULL, 0x0000001803037209ULL, 0x000fe40007810000ULL,
0x0000030004007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x000000100d047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x0000000411047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0613ULL,
0x0000000604187981ULL, 0x000326000c1e1900ULL, 0x0000040011117810ULL, 0x000fe40007f3e0ffULL,
0x0000000817177810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x00000000000d7919ULL, 0x000ea40000000000ULL,
0x000000100d047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc8000001160dULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fca00078ec0ffULL,
0x0000000104047824ULL, 0x000fca00078e0205ULL, 0x0000000304007388ULL, 0x0103e40000000800ULL,
0x00006e0014047a10ULL, 0x002fe20007f3e0ffULL, 0x000000010b1d7824ULL, 0x000fe200078e020eULL,
0x000000070d00780cULL, 0x000fe20003f04070ULL, 0x0000080069087824ULL, 0x000fe200078e00ffULL,
0x00000002ff037819ULL, 0x000fe20000011602ULL, 0x00006f00ff057624ULL, 0x000fe200008e06ffULL,
0x00006e0015187a10ULL, 0x000fe20007f5e0ffULL, 0x0000020002107824ULL, 0x000fe200078e00ffULL,
0x0000000103037812ULL, 0x000fe200078ec0ffULL, 0x000010001d067825ULL, 0x004fe200078e0004ULL,
0x000000200d117810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000806067210ULL, 0x000fe20007f3e0ffULL, 0x000000020b1e8824ULL, 0x140fe200078e0269ULL,
0x0000080010107812ULL, 0x000fe200078ec0ffULL, 0x000000020b0a8824ULL, 0x000fe200078e0269ULL,
0x000000400d137810ULL, 0x040fe20007ffe0ffULL, 0x000000021e1e8824ULL, 0x100fe200078e0203ULL,
0x000000600d177810ULL, 0x000fe20007ffe0ffULL, 0x000000020a208824ULL, 0x000fe200078e0203ULL,
0x00000001ff037819ULL, 0x000fe2000001160dULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x00006e000f0a7a10ULL, 0x000fe20007f3e0ffULL, 0x000000100d027824ULL, 0x000fe200078e00ffULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x000020000b0f7824ULL, 0x000fe200078e0200ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x00006f00ff197624ULL, 0x000fe200008e06ffULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x000000010f107824ULL, 0x000fe200078e0210ULL,
0x0000000a1d148211ULL, 0x040fe200078238ffULL, 0x00006f00ff1b7624ULL, 0x000fe200010e06ffULL,
0x000000181d1c8211ULL, 0x040fe200078438ffULL, 0x00000001021a7824ULL, 0x000fe200078e0203ULL,
0x000000191d158211ULL, 0x000fe200008f3cffULL, 0x000000100d217824ULL, 0x000fe200078e0210ULL,
0x000003000b007a0cULL, 0x000fe20003f26070ULL, 0x0000001011107825ULL, 0x100fe200078e0006ULL,
0x0000001b1d1d8211ULL, 0x000fe200010f3cffULL, 0x000000001a1a7984ULL, 0x000e620000000800ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000001013127825ULL, 0x100fe200078e0006ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000001017167825ULL, 0x100fe200078e0006ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000100d067825ULL, 0x000fe200078e0006ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000081e1e8824ULL, 0x100fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000006217faeULL, 0x0005e2000b901c46ULL,
0x0000000820208824ULL, 0x000fc400078e020dULL, 0x000000100d148825ULL, 0x040fe200078e0014ULL,
0x000045801e238811ULL, 0x000fe200078e20ffULL, 0x0038000010217faeULL, 0x0007e2000b901c46ULL,
0x0000418020258811ULL, 0x000fe200078e20ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0058000012217faeULL, 0x0007e2000b901c46ULL,
0x000000100d068825ULL, 0x004fc600078e001cULL, 0x0078000016217faeULL, 0x0007e2000b901c46ULL,
0x00000000001c7805ULL, 0x000fc6000001ff00ULL, 0x0000000014238faeULL, 0x0005e8000b901c46ULL,
0x0000000006258faeULL, 0x0009e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000207805ULL, 0x008fe2000001ff00ULL, 0x0000000000227805ULL, 0x004fe2000001ff00ULL,
0x0000000000247805ULL, 0x010fe2000001ff00ULL, 0x00000c6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff1c7224ULL, 0x002fe400078e00ffULL, 0x000000ffff3e7224ULL, 0x000fca00078e000bULL,
0x000000023e3d7810ULL, 0x000fc80007ffe0ffULL, 0x000003003d007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x000000070d00780cULL, 0x040fe20003f44070ULL,
0x000000010e117824ULL, 0x100fe200078e023dULL, 0x00000001ff067819ULL, 0x000fe4000001163dULL,
0x000000600d417810ULL, 0x000fe20007ffe0ffULL, 0x0000100011027825ULL, 0x000fe200078e0004ULL,
0x0000000106067812ULL, 0x000fc800078ec0ffULL, 0x0000000802127210ULL, 0x000fe20007f1e0ffULL,
0x000004003d027824ULL, 0x000fe400078e00ffULL, 0x000000020b13a824ULL, 0x100fe200078e0269ULL,
0x000000181110a211ULL, 0x000fe200078238ffULL, 0x000000020b07a824ULL, 0x000fe200078e0269ULL,
0x0000080002027812ULL, 0x000fe200078ec0ffULL, 0x000000021342a824ULL, 0x100fe400078e0206ULL,
0x000000ffff137224ULL, 0x000fe200000e0603ULL, 0x0000000a1114a211ULL, 0x000fe200078038ffULL,
0x000000020740a824ULL, 0x000fe200078e0206ULL, 0x000000200d037810ULL, 0x000fe20007ffe0ffULL,
0x000000010f027824ULL, 0x000fe200078e0202ULL, 0x000000400d077810ULL, 0x000fe20007ffe0ffULL,
0x000000084040a824ULL, 0x000fe200078e020dULL, 0x000000191115a211ULL, 0x000fe200000f3cffULL,
0x000000100d3f7824ULL, 0x000fe200078e0202ULL, 0x0000001b1111a211ULL, 0x000fe200008f3cffULL,
0x000000100d167825ULL, 0x000fc800078e0012ULL, 0x000000084242a824ULL, 0x000fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000163f7faeULL, 0x0003e2000b901c46ULL,
0x0000001003027825ULL, 0x000fc600078e0012ULL, 0x000041804243a811ULL, 0x000fe200078e20ffULL,
0x0000001007067825ULL, 0x100fe200078e0012ULL, 0x00380000023f7faeULL, 0x0003e6000b901c46ULL,
0x0000001041127825ULL, 0x000fe200078e0012ULL, 0x000045804041a811ULL, 0x000fe200078e20ffULL,
0x00580000063f7faeULL, 0x0003e4000b901c46ULL, 0x000000100d14a825ULL, 0x040fe400078e0014ULL,
0x00780000123f7faeULL, 0x0003e4000b901c46ULL, 0x000000100d10a825ULL, 0x000fc400078e0010ULL,
0x000000001441afaeULL, 0x0003e8000b901c46ULL, 0x000000001043afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000403e027824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe2000001160dULL, 0x000000020b077824ULL, 0x000fe200078e0269ULL,
0x00000002ff147819ULL, 0x000fe2000001160dULL, 0x000000100d037824ULL, 0x000fe200078e00ffULL,
0x0000008002027812ULL, 0x000fc400078ec0ffULL, 0x0000000814487810ULL, 0x040fe20007ffe0ffULL,
0x0000000814177824ULL, 0x040fe200078e00ffULL, 0x0000000214167810ULL, 0x040fe20007ffe0ffULL,
0x0000010007067824ULL, 0x000fe200078e0002ULL, 0x0000007003027812ULL, 0x000fe200078ec0ffULL,
0x0000000814137824ULL, 0x000fe200078e00ffULL, 0x0000000c10037812ULL, 0x000fe200078ec0ffULL,
0x000000040d107824ULL, 0x000fe200078e00ffULL, 0xffffffff14447810ULL, 0x040fe20007ffe0ffULL,
0x00000008143f7824ULL, 0x040fe200078e00ffULL, 0x0000000603077210ULL, 0x000fe20007ffe002ULL,
0x0000000814407824ULL, 0x040fe200078e00ffULL, 0x0000000114067810ULL, 0x040fe20007ffe0ffULL,
0x0000000814457824ULL, 0x000fe200078e00ffULL, 0x0000000c10467812ULL, 0x000fe200078ec0ffULL,
0x0000000814477824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800007117984ULL, 0x000e620000000800ULL, 0xfffffff817177812ULL, 0x000fe200078ee206ULL,
0x000004003e067824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee214ULL,
0x0045800007157984ULL, 0x0004e20000000800ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL,
0x0000000814497824ULL, 0x000fe200078e00ffULL, 0x0000080006067812ULL, 0x000fe400078ec0ffULL,
0x00000004143e7810ULL, 0x000fe40007ffe0ffULL, 0x000001800f107810ULL, 0x000fe20007ffe006ULL,
0x0000000848077824ULL, 0x004fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fc400078ee23eULL,
0xfffffff849497812ULL, 0x000fe200078ee244ULL, 0x0000001013067824ULL, 0x000fe200078e0210ULL,
0xfffffff807077812ULL, 0x000fc600078ee248ULL, 0x0000000146067824ULL, 0x000fe400078e0206ULL,
0x0000001007077824ULL, 0x000fc600078e0210ULL, 0x0000000006167984ULL, 0x000ea20000000800ULL,
0x0000000146137824ULL, 0x000fe400078e0207ULL, 0x0000001017077824ULL, 0x000fc600078e0210ULL,
0x0000000013417984ULL, 0x0009e20000000800ULL, 0x000000111a117221ULL, 0x002fc80000010100ULL,
0x3fb8aa3b11127820ULL, 0x000fe20000410000ULL, 0x0000000314117810ULL, 0x000fc80007ffe0ffULL,
0xfffffff840437812ULL, 0x000fe200078ee211ULL, 0x0000001200127308ULL, 0x000ee20000000800ULL,
0x0000000146117824ULL, 0x000fe200078e0207ULL, 0x0000000514407810ULL, 0x000fe20007ffe0ffULL,
0x000000103f077824ULL, 0x100fe400078e0210ULL, 0x0000001043137824ULL, 0x010fe200078e0210ULL,
0x00000000113e7984ULL, 0x000fe60000000800ULL, 0x0000000146137824ULL, 0x000fe200078e0213ULL,
0x0004000011427984ULL, 0x0003e80000000800ULL, 0x0004000013447984ULL, 0x000fe20000000800ULL,
0x0000001512177220ULL, 0x008fe20000410000ULL, 0xfffffff847157812ULL, 0x000fe200078ee240ULL,
0x0000000146127824ULL, 0x000fe200078e0207ULL, 0x0000000614407810ULL, 0x000fe20007ffe0ffULL,
0x0000001045117824ULL, 0x002fe200078e0210ULL, 0x00001f1417077589ULL, 0x0002e200000e0000ULL,
0x0000003c173c7221ULL, 0x000fe20000010000ULL, 0xfffffff847477812ULL, 0x000fe200078ee240ULL,
0x0000000146117824ULL, 0x000fe200078e0211ULL, 0x00000000123f7984ULL, 0x000fe80000000800ULL,
0x0000000013407984ULL, 0x000fe20000000800ULL, 0x0000001015147824ULL, 0x002fc600078e0210ULL,
0x00001f4817067589ULL, 0x000e6200000e0000ULL, 0x0000001047157824ULL, 0x100fe400078e0210ULL,
0x0000001049107824ULL, 0x000fe200078e0210ULL, 0x0000000011177984ULL, 0x000fe20000000800ULL,
0x0000000146147824ULL, 0x040fe400078e0214ULL, 0x0000000146107824ULL, 0x040fe200078e0210ULL,
0x0004000012437984ULL, 0x0005220000000800ULL, 0x0000000146157824ULL, 0x000fc600078e0215ULL,
0x0004000011457984ULL, 0x0007220000000800ULL, 0x00005410ff127816ULL, 0x004fc60000000016ULL,
0x0000000014137984ULL, 0x000ea20000000800ULL, 0x00007610ff117816ULL, 0x008fe20000000016ULL,
0x0000000712397223ULL, 0x080fe20000010039ULL, 0x00005410ff127816ULL, 0x000fe2000000003eULL,
0x0000000015167984ULL, 0x000fe40000000800ULL, 0x0000000711387223ULL, 0x080fe20000010038ULL,
0x00005410ff117816ULL, 0x000fe20000000041ULL, 0x0000000712357223ULL, 0x000fe20000010035ULL,
0x0004000015467984ULL, 0x000fe60000000800ULL, 0x0000000611377223ULL, 0x002fe20000010037ULL,
0x00005410ff127816ULL, 0x000fc4000000003fULL, 0x00007610ff117816ULL, 0x000fe40000000041ULL,
0x0004000014417984ULL, 0x000e620000000800ULL, 0x0000000712317223ULL, 0x080fe40000010031ULL,
0x0000000611367223ULL, 0x000fe20000010036ULL, 0x0000000010127984ULL, 0x000ee20000000800ULL,
0x00007610ff117816ULL, 0x000fe2000000003eULL, 0x000000ffff3e7224ULL, 0x000fe400078e003dULL,
0x0004000010147984ULL, 0x0008640000000800ULL, 0x0000000711347223ULL, 0x000fe20000010034ULL,
0x00005410ff117816ULL, 0x000fc40000000042ULL, 0x000003003e007a0cULL, 0x000fe40003f06070ULL,
0x00005410ff107816ULL, 0x010fe20000000040ULL, 0x0000000611337223ULL, 0x000fe20000010033ULL,
0x00007610ff117816ULL, 0x000fc60000000042ULL, 0x00000007102d7223ULL, 0x000fe2000001002dULL,
0x00007610ff107816ULL, 0x000fe20000000040ULL, 0x0000000611327223ULL, 0x000fe20000010032ULL,
0x00007610ff117816ULL, 0x000fc6000000003fULL, 0x00000007102c7223ULL, 0x080fe2000001002cULL,
0x00005410ff107816ULL, 0x000fe20000000044ULL, 0x0000000711307223ULL, 0x000fe20000010030ULL,
0x00005410ff117816ULL, 0x000fc60000000043ULL, 0x00000006102b7223ULL, 0x080fe2000001002bULL,
0x00005410ff107816ULL, 0x000fe20000000017ULL, 0x00000006112f7223ULL, 0x000fe2000001002fULL,
0x00007610ff117816ULL, 0x000fc60000000043ULL, 0x0000000710297223ULL, 0x000fe20000010029ULL,
0x00007610ff107816ULL, 0x000fe20000000017ULL, 0x00000006112e7223ULL, 0x000fe2000001002eULL,
0x00007610ff117816ULL, 0x000fc60000000044ULL, 0x0000000710287223ULL, 0x000fe20000010028ULL,
0x00005410ff107816ULL, 0x100fe20000000045ULL, 0x00000006112a7223ULL, 0x000fe2000001002aULL,
0x00007610ff117816ULL, 0x000fc60000000045ULL, 0x0000000610277223ULL, 0x080fe20000010027ULL,
0x00005410ff107816ULL, 0x004fe20000000013ULL, 0x0000000611267223ULL, 0x000fe20000010026ULL,
0x00007610ff117816ULL, 0x002fc60000000041ULL, 0x0000000710257223ULL, 0x000fe20000010025ULL,
0x00007610ff107816ULL, 0x000fe20000000013ULL, 0x0000000611227223ULL, 0x000fe20000010022ULL,
0x00007610ff117816ULL, 0x000fc60000000046ULL, 0x0000000710247223ULL, 0x000fe20000010024ULL,
0x00005410ff107816ULL, 0x000fe20000000041ULL, 0x00000006111e7223ULL, 0x000fc8000001001eULL,
0x0000000610237223ULL, 0x000fe20000010023ULL, 0x00005410ff107816ULL, 0x000fca0000000016ULL,
0x0000000710217223ULL, 0x000fe20000010021ULL, 0x00007610ff107816ULL, 0x000fca0000000016ULL,
0x0000000710207223ULL, 0x000fe20000010020ULL, 0x00005410ff107816ULL, 0x000fca0000000046ULL,
0x00000006101f7223ULL, 0x000fe2000001001fULL, 0x00005410ff107816ULL, 0x008fca0000000012ULL,
0x00000007103b7223ULL, 0x000fe2000001003bULL, 0x00007610ff107816ULL, 0x000fca0000000012ULL,
0x00000007103a7223ULL, 0x000fe2000001003aULL, 0x00005410ff077816ULL, 0x000fca0000000014ULL,
0x00000006071d7223ULL, 0x000fe2000001001dULL, 0x00007610ff077816ULL, 0x000fca0000000014ULL,
0x00000006071c7223ULL, 0x000fe2000001001cULL, 0xfffff3c000008947ULL, 0x000fea000383ffffULL,
0x000000ff6900720cULL, 0x002fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x000000800b048824ULL, 0x000fc800078e0202ULL, 0x0000000103058824ULL, 0x000fe400078e0204ULL,
0x0000000102047824ULL, 0x000fc600078e0203ULL, 0x0049803c05008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800004027984ULL, 0x000e680000000800ULL,
0x004a000004037984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000302027221ULL, 0x004fca0000010000ULL, 0x0180000002037810ULL, 0x000fc80007ffe0ffULL,
0x7f80000003037812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0002ULL, 0x0000aff000067802ULL, 0x000fc40000000f00ULL,
0x0000a44000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e000dULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000003ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000ea20000000000ULL, 0x0000000c0c0c723eULL, 0x000fc600000010ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff067819ULL, 0x004fe4000001160dULL,
0x000000080d087811ULL, 0x000fe400078ff0ffULL, 0x0000000206057810ULL, 0x040fe20007ffe0ffULL,
0x00001f0603027589ULL, 0x000ea200000e0000ULL, 0x00000008060e7824ULL, 0x040fe200078e00ffULL,
0x0000000306077810ULL, 0x040fe20007ffe0ffULL, 0x0000000806107824ULL, 0x040fe200078e00ffULL,
0x00001f0803047589ULL, 0x00072200000e0000ULL, 0x0000000806127824ULL, 0x040fe200078e00ffULL,
0x00000004060a7810ULL, 0x042fe20007ffe0ffULL, 0x00000008060f7824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x0000000806167824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x0000000806187824ULL, 0x040fe200078e00ffULL,
0xfffffff80f147812ULL, 0x000fe200078ee20aULL, 0x00000008061a7824ULL, 0x040fe200078e00ffULL,
0x0000000106037810ULL, 0x008fe20007ffe0ffULL, 0x0000001010107824ULL, 0x100fe200078e0209ULL,
0x0000000606057810ULL, 0x000fe20007ffe0ffULL, 0x0000001012127824ULL, 0x000fe200078e0209ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000001014147824ULL, 0x000fe200078e0209ULL,
0x0000000506037810ULL, 0x000fc40007ffe0ffULL, 0xffffffff06077810ULL, 0x000fe20007ffe0ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0209ULL, 0xfffffff80f0a7812ULL, 0x000fe200078ee206ULL,
0x00000008080f7824ULL, 0x000fe200078e00ffULL, 0xfffffff816067812ULL, 0x000fe200078ee203ULL,
0x000000040d037824ULL, 0x000fe200078e00ffULL, 0xfffffff818167812ULL, 0x000fe200078ee205ULL,
0x0000003902397220ULL, 0x004fe20000410000ULL, 0xfffffff81a187812ULL, 0x000fe200078ee207ULL,
0x0000003802387220ULL, 0x040fe20000410000ULL, 0x0000000c03037812ULL, 0x000fe200078ec0ffULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0xfffffff80f087812ULL, 0x000fe200078ee208ULL,
0x0000003402347220ULL, 0x000fe20000410000ULL, 0x000000393838723eULL, 0x000fe200000010ffULL,
0x000000100a0a7824ULL, 0x000fc400078e0209ULL, 0x0000003102317220ULL, 0x000fe20000410000ULL,
0x000000353434723eULL, 0x000fe200000010ffULL, 0x0000003002307220ULL, 0x000fe40000410000ULL,
0x0000003704377220ULL, 0x050fe40000410000ULL, 0x0000003604367220ULL, 0x000fe20000410000ULL,
0x000000313030723eULL, 0x000fe200000010ffULL, 0x0000003304337220ULL, 0x040fe40000410000ULL,
0x0000003204327220ULL, 0x000fe20000410000ULL, 0x000000373636723eULL, 0x000fe200000010ffULL,
0x0000002f042f7220ULL, 0x000fc40000410000ULL, 0x0000002e042e7220ULL, 0x000fe20000410000ULL,
0x000000333232723eULL, 0x000fe200000010ffULL, 0x0000002b042b7220ULL, 0x040fe40000410000ULL,
0x0000002a042a7220ULL, 0x000fe20000410000ULL, 0x0000002f2e2e723eULL, 0x000fe200000010ffULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002604267220ULL, 0x000fe20000410000ULL,
0x0000002b2a2a723eULL, 0x000fe200000010ffULL, 0x0000002304237220ULL, 0x000fc40000410000ULL,
0x0000002204227220ULL, 0x000fe20000410000ULL, 0x000000272626723eULL, 0x000fe200000010ffULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001e041e7220ULL, 0x000fe20000410000ULL,
0x000000232222723eULL, 0x000fe200000010ffULL, 0x0000001d041d7220ULL, 0x000fe40000410000ULL,
0x0000002d022d7220ULL, 0x000fe20000410000ULL, 0x0000001f1e1e723eULL, 0x000fe200000010ffULL,
0x0000002c022c7220ULL, 0x000fc40000410000ULL, 0x0000001c04047220ULL, 0x000fe40000410000ULL,
0x0000002902297220ULL, 0x000fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000010ffULL,
0x0000002802287220ULL, 0x000fe20000410000ULL, 0x0000001d0404723eULL, 0x000fe200000010ffULL,
0x0000002502257220ULL, 0x040fe40000410000ULL, 0x0000002402247220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000010ffULL, 0x0000002102217220ULL, 0x000fc40000410000ULL,
0x0000002002207220ULL, 0x000fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000010ffULL,
0x000000010a057824ULL, 0x000fe400078e0203ULL, 0x0000003b023b7220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000010ffULL, 0x0000001006067824ULL, 0x100fe200078e0209ULL,
0x0000003805007388ULL, 0x0003e20000000800ULL, 0x0000001016167824ULL, 0x100fe400078e0209ULL,
0x0000001018187824ULL, 0x000fc400078e0209ULL, 0x0000001008087824ULL, 0x000fe400078e0209ULL,
0x0000000103077824ULL, 0x040fe400078e020eULL, 0x0000003a02027220ULL, 0x000fe40000410000ULL,
0x0000000103097824ULL, 0x040fe200078e0210ULL, 0x0000003407007388ULL, 0x000fe20000000800ULL,
0x00000001030f7824ULL, 0x040fe200078e0212ULL, 0x0000003b0202723eULL, 0x000fe200000010ffULL,
0x00000001031d7824ULL, 0x040fe200078e0214ULL, 0x0000003009007388ULL, 0x000fe20000000800ULL,
0x00000001031f7824ULL, 0x000fc400078e0206ULL, 0x0000000103217824ULL, 0x040fe200078e0216ULL,
0x0000002c0f007388ULL, 0x000fe20000000800ULL, 0x0000000103237824ULL, 0x040fe400078e0218ULL,
0x0000000103037824ULL, 0x000fe200078e0208ULL, 0x000000281d007388ULL, 0x000fe20000000800ULL,
0x0000000170057824ULL, 0x002fc600078e020dULL, 0x000000241f007388ULL, 0x000fe20000000800ULL,
0x0000001005057824ULL, 0x000fc600078e0200ULL, 0x0000002021007388ULL, 0x000fe80000000800ULL,
0x0000000223007388ULL, 0x000fe80000000800ULL, 0x0000003603007388ULL, 0x000fe80000000800ULL,
0x0004003207007388ULL, 0x000fe80000000800ULL, 0x0004002e09007388ULL, 0x000fe80000000800ULL,
0x0004002a0f007388ULL, 0x000fe80000000800ULL, 0x000400261d007388ULL, 0x000fe80000000800ULL,
0x000400221f007388ULL, 0x000fe80000000800ULL, 0x0004001e21007388ULL, 0x000fe80000000800ULL,
0x0004000423007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000005107984ULL, 0x000e680000000c00ULL, 0x0004000005187984ULL, 0x000ea80000000c00ULL,
0x0008000005147984ULL, 0x000ee80000000c00ULL, 0x000c0000052c7984ULL, 0x000f220000000c00ULL,
0x3f803f800c137831ULL, 0x002fc40000200013ULL, 0x3f803f800c127831ULL, 0x040fe40000200012ULL,
0x3f803f800c117831ULL, 0x040fe40000200011ULL, 0x3f803f800c107831ULL, 0x040fe40000200010ULL,
0x3f803f800c1b7831ULL, 0x044fe4000020001bULL, 0x3f803f800c1a7831ULL, 0x040fe4000020001aULL,
0x3f803f800c197831ULL, 0x000fc40000200019ULL, 0x3f803f800c187831ULL, 0x000fe40000200018ULL,
0x3f803f8013137831ULL, 0x008fe40000200017ULL, 0x3f803f8012127831ULL, 0x000fe40000200016ULL,
0x3f803f8011117831ULL, 0x000fe40000200015ULL, 0x3f803f8010107831ULL, 0x000fe40000200014ULL,
0x3f803f801b1b7831ULL, 0x010fc4000020002fULL, 0x3f803f801a1a7831ULL, 0x000fe2000020002eULL,
0x0000001005007388ULL, 0x000fe20000000c00ULL, 0x3f803f8019197831ULL, 0x000fe4000020002dULL,
0x3f803f8018187831ULL, 0x000fca000020002cULL, 0x0004001805007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x004fc8000001160dULL,
0x000000750600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00005a0000047b06ULL, 0x000ea20000209000ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x00005a00ff0c7a12ULL, 0x000fe400078e33ffULL, 0x000000200d0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000070d0a7812ULL, 0x002fe400078ec0ffULL, 0x0000000400047308ULL, 0x004e640000001000ULL,
0x0ffffffe04077810ULL, 0x002fcc0007ffe0ffULL, 0x0000000700037305ULL, 0x000e64000021f000ULL,
0x000000ffff057224ULL, 0x002fc800078e0a03ULL, 0x00005a0005057a24ULL, 0x000fc800078e02ffULL,
0x00000005030b7227ULL, 0x000fc800078e0002ULL, 0x0000000174027824ULL, 0x000fe400078e0206ULL,
0x0000000106067824ULL, 0x000fe400078e020dULL, 0x000000020b037227ULL, 0x000fc600078e00ffULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a03ULL,
0x00005a0005047a24ULL, 0x000fe200078e0202ULL, 0x0ffffff806057812ULL, 0x000fc800078ef80dULL,
0x00005a0004007a0cULL, 0x000fda0003f06070ULL, 0x80005a0004040a10ULL, 0x000fe40007ffe0ffULL,
0x0000000103030810ULL, 0x000fe40007ffe0ffULL, 0x00005a0004007a0cULL, 0x000fe20003f26070ULL,
0x0000001005047824ULL, 0x000fe200078e0200ULL, 0x00005a00ff007a0cULL, 0x000fca0003f05070ULL,
0x0000000004047984ULL, 0x000e6c0000000c00ULL, 0x0000000103031810ULL, 0x000fc80007ffe0ffULL,
0x000000030c087207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a08ULL,
0x0000590008037a24ULL, 0x000fe400078e0273ULL, 0x00005a0009027a24ULL, 0x000fe400078e0202ULL,
0x0000000869097824ULL, 0x000fe400078e020aULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x0000000376037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f4408ULL,
0x00000003ff087819ULL, 0x000fc6000001160fULL, 0x0000001009027825ULL, 0x000fe200078e0002ULL,
0x000000750800720cULL, 0x000fc80003f26070ULL, 0x0000000402007986ULL, 0x0023f2000c101d06ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x0000000174027824ULL, 0x102fe200078e0208ULL,
0x000000400d117810ULL, 0x000fe20007ffe0ffULL, 0x000000010f087824ULL, 0x000fc400078e0208ULL,
0x000000020b097227ULL, 0x000fc600078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a09ULL, 0x00005a0003037a24ULL, 0x000fca00078e0202ULL,
0x00005a0003007a0cULL, 0x000fda0003f26070ULL, 0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL,
0x0000000109091810ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe40003f46070ULL,
0x0ffffff808037812ULL, 0x000fca00078ef80fULL, 0x0000001003047824ULL, 0x000fcc00078e0200ULL,
0x0000000109092810ULL, 0x000fe20007ffe0ffULL, 0x0000000004047984ULL, 0x000e660000000c00ULL,
0x000000090c087207ULL, 0x000fca0004000000ULL, 0x000000ffff097224ULL, 0x000fe400078e0a08ULL,
0x0000590008037a24ULL, 0x000fe200078e0273ULL, 0x000000070f087812ULL, 0x000fe200078ec0ffULL,
0x00005a0009027a24ULL, 0x000fc800078e0202ULL, 0x00005a0003037a24ULL, 0x000fe400078e0202ULL,
0x0000000869097824ULL, 0x000fc600078e0208ULL, 0x0000000376037210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0003027a11ULL, 0x000fc800078240ffULL,
0x00005f0003037a11ULL, 0x000fe400008f440aULL, 0x00000003ff0a7819ULL, 0x000fc60000011611ULL,
0x0000001009027825ULL, 0x000fe200078e0002ULL, 0x000000750a00720cULL, 0x000fc80003f26070ULL,
0x0000000402007986ULL, 0x0023f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x0000000174027824ULL, 0x102fe200078e020aULL, 0x000000600d0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001110a7824ULL, 0x000fc400078e020aULL, 0x000000020b087227ULL, 0x000fc600078e00ffULL,
0x000000070a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a08ULL,
0x00005a0003037a24ULL, 0x000fca00078e0202ULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000108081810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f46070ULL, 0x0ffffff80a037812ULL, 0x000fca00078ef811ULL,
0x0000001003047824ULL, 0x000fcc00078e0200ULL, 0x0000000108082810ULL, 0x000fe20007ffe0ffULL,
0x0000000004047984ULL, 0x000e660000000c00ULL, 0x000000080c087207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a08ULL, 0x0000590008037a24ULL, 0x000fe200078e0273ULL,
0x0000000711087812ULL, 0x000fe200078ec0ffULL, 0x00005a0009027a24ULL, 0x000fc800078e0202ULL,
0x00005a0003037a24ULL, 0x000fe400078e0202ULL, 0x0000000869097824ULL, 0x000fc600078e0208ULL,
0x0000000376037210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078240ffULL, 0x00005f0003037a11ULL, 0x000fe400008f440aULL,
0x00000003ff0a7819ULL, 0x000fc6000001160dULL, 0x0000001009027825ULL, 0x000fe200078e0002ULL,
0x000000750a00720cULL, 0x000fc60003f26070ULL, 0x0000000174747824ULL, 0x000fe200078e020aULL,
0x0000000402007986ULL, 0x0023f2000c101d06ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x000000740b027227ULL, 0x002fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fe400078e0a02ULL,
0x000000010d0a7824ULL, 0x000fe400078e020aULL, 0x00005a0003037a24ULL, 0x000fc600078e0274ULL,
0x000000070a0a7812ULL, 0x000fe400078ec0ffULL, 0x00005a0003007a0cULL, 0x000fda0003f26070ULL,
0x80005a0003031a10ULL, 0x000fe40007ffe0ffULL, 0x0000000102021810ULL, 0x000fe40007ffe0ffULL,
0x00005a0003007a0cULL, 0x000fe40003f46070ULL, 0xfffffff80a037812ULL, 0x000fca00078ef80dULL,
0x0000001003047824ULL, 0x000fe200078e0200ULL, 0x000000070d007812ULL, 0x000fca00078ec0ffULL,
0x0000000102022810ULL, 0x000fe20007ffe0ffULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x0000000869697824ULL, 0x000fe400078e0200ULL, 0x000000020c027207ULL, 0x000fca0004000000ULL,
0x000000ffff097224ULL, 0x000fe400078e0a02ULL, 0x0000590002037a24ULL, 0x000fe400078e0273ULL,
0x00005a0009747a24ULL, 0x000fc800078e0274ULL, 0x00005a0003037a24ULL, 0x000fca00078e0274ULL,
0x0000000376037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e0003027a11ULL, 0x000fc800078040ffULL, 0x00005f0003037a11ULL, 0x000fca00000f4408ULL,
0x0000001069027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000002090a7824ULL, 0x000fe200078e00ffULL, 0x0000000103097810ULL, 0x000fe20007ffe0ffULL,
0x00005800ff0b7624ULL, 0x002fe200078e00ffULL, 0x01b60000ff067f8cULL, 0x000e62000c80043fULL,
0x0000004002757824ULL, 0x000fe200078e00ffULL, 0x0000005c0900720cULL, 0x000fe20003f06070ULL,
0x000059000a6b7a24ULL, 0x000fe200078e0273ULL, 0x0000001f0b097810ULL, 0x000fe20007ffe0ffULL,
0x00000100030d7824ULL, 0x000fc600078e0275ULL, 0x00000005ff097819ULL, 0x000fe20000011609ULL,
0x000068006b0b7a24ULL, 0x000fcc00078e020dULL, 0x00000c7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff177819ULL, 0x100fe40000011604ULL, 0x0000000d66167217ULL, 0x000fe40007800000ULL,
0x00000004170f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0c7824ULL, 0x000fe200078e0217ULL,
0x0000000817117810ULL, 0x040fe20007ffe0ffULL, 0x0000000116167824ULL, 0x000fe200078e0a0dULL,
0x0000001017157810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0e7824ULL, 0x000fe200078e020fULL,
0x0000000c17137810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0a7824ULL, 0x140fe200078e0204ULL,
0x000000160f00720cULL, 0x0c0fe20003fa6070ULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0x00000018172d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001110d7824ULL, 0x000fe200078e0204ULL,
0x0000001417217810ULL, 0x000fe20007ffe0ffULL, 0x0000000811107824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000161300720cULL, 0x000fc40003f46070ULL, 0xfffffff8102f7812ULL, 0x000fe200078ee20dULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x100fe400078ef805ULL,
0x0000001c17397810ULL, 0x000fe20007ffe0ffULL, 0x0000000115107824ULL, 0x140fe200078e0204ULL,
0x000064000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000815337824ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fe200078ef805ULL, 0x000000010b127824ULL, 0x000fe200078e0213ULL,
0x000065000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x00000001130a7824ULL, 0x000fe200078e0204ULL,
0xfffffff833337812ULL, 0x000fe200078ee210ULL, 0x000000010b107824ULL, 0x000fe200078e0211ULL,
0x000064000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000813317824ULL, 0x000fe200078e00ffULL,
0x000000161100720cULL, 0x000fe20003f26070ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000065000d0d7a10ULL, 0x000fc400007fe4ffULL, 0x000000161500720cULL, 0x000fe20003f06070ULL,
0x000000010b147824ULL, 0x000fe200078e0215ULL, 0x0000007010187812ULL, 0x000fe200078ef805ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe400078ee20aULL,
0x0000640018187a10ULL, 0x000fe20007f7e0ffULL, 0x000000010b1e7824ULL, 0x040fe200078e022dULL,
0x00000070121a7812ULL, 0x000fe200078ef805ULL, 0x000000010b1c7824ULL, 0x000fe200078e0221ULL,
0x0000650011197a10ULL, 0x000fe20001ffe4ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000064001a1a7a10ULL, 0x000fc40007f9e0ffULL, 0x0000002017277810ULL, 0x000fe20007ffe0ffULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0x0000007014107812ULL, 0x100fe400078ef805ULL,
0x00006500131b7a10ULL, 0x000fe200027fe4ffULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x000000701e147812ULL, 0x100fe400078ef805ULL, 0x0000640010107a10ULL, 0x000fe20007f7e0ffULL,
0x00000001171e7824ULL, 0x100fe200078e0204ULL, 0x000000701c127812ULL, 0x000fe200078ef805ULL,
0x000000010b1c7824ULL, 0x000fe200078e0239ULL, 0x0000640014147a10ULL, 0x000fe20007fde0ffULL,
0x0000000121207824ULL, 0x140fe200078e0204ULL, 0x0000640012127a10ULL, 0x000fe20007f9e0ffULL,
0x0000000821357824ULL, 0x000fe200078e00ffULL, 0x0000650015117a10ULL, 0x000fe20001ffe4ffULL,
0x000000012d247824ULL, 0x000fe200078e0204ULL, 0x000065001f157a10ULL, 0x000fe200037fe4ffULL,
0x000000082d377824ULL, 0x000fe200078e00ffULL, 0x000065001d137a10ULL, 0x000fe200027fe4ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x000000071e1f7812ULL, 0x000fc400078ec0ffULL,
0x000000161700720cULL, 0x000fe20003f86070ULL, 0x000000010b1e7824ULL, 0x000fe200078e0227ULL,
0x00001000020a7811ULL, 0x000fe400078e70ffULL, 0x0ffffff81f1f7812ULL, 0x000fe400078ef804ULL,
0x0000002417297810ULL, 0x040fe40007ffe0ffULL, 0x00000028172b7810ULL, 0x000fe20007ffe0ffULL,
0x000000101f237824ULL, 0x000fe200078e020aULL, 0x000000701c1c7812ULL, 0x000fe200078ef805ULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fc400078ee220ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c237faeULL, 0x0005e2000e101c46ULL,
0x000000010b207824ULL, 0x000fe200078e0229ULL, 0x000000162100720cULL, 0x080fe20003f66070ULL,
0x000000010b227824ULL, 0x000fe200078e022bULL, 0x000064001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x000000162d00720cULL, 0x080fe40003f86070ULL,
0x000000701e1e7812ULL, 0x000fe400078ef805ULL, 0x0000002c172d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001025237824ULL, 0x104fe200078e020aULL, 0x000065001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x000000102f257824ULL, 0x000fe200078e020aULL, 0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x00000100220c7825ULL, 0x000fe200078e00ffULL, 0x000000000e237faeULL, 0x0005e2000e901c46ULL,
0x000000163900720cULL, 0x000fc40003fa6070ULL, 0x0000000139227824ULL, 0x040fe200078e0204ULL,
0x0000000018257faeULL, 0x0007e2000c901c46ULL, 0x0000007020207812ULL, 0x000fe200078ef805ULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x00000030172f7810ULL, 0x000fe40007ffe0ffULL,
0x000065001f1f7a10ULL, 0x000fe400037fe4ffULL, 0xfffffff837377812ULL, 0x000fe200078ee224ULL,
0x0000001031237824ULL, 0x104fe200078e020aULL, 0x0000640020207a10ULL, 0x000fe20007fde0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e022dULL, 0x000000700c0c7812ULL, 0x100fe200078ef805ULL,
0x0000001033197824ULL, 0x008fe200078e020aULL, 0x000000001a237faeULL, 0x0005e2000d101c46ULL,
0xfffffff839397812ULL, 0x000fe200078ee222ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000162700720cULL, 0x080fe20003f26070ULL, 0x0000000010197faeULL, 0x0007e2000c101c46ULL,
0x000000162900720cULL, 0x000fe20003f46070ULL, 0x0000000127227824ULL, 0x100fe200078e0204ULL,
0x0000650021217a10ULL, 0x000fe200037fe4ffULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x000064000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000129247824ULL, 0x040fe200078e0204ULL,
0x000000700e0e7812ULL, 0x000fe200078ef805ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x0000003417317810ULL, 0x000fe20007ffe0ffULL, 0x00000010351b7824ULL, 0x004fe200078e020aULL,
0xfffffff827277812ULL, 0x000fe200078ee222ULL, 0x000000010b107824ULL, 0x008fe200078e022fULL,
0x000065000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x0000001037237824ULL, 0x000fe200078e020aULL,
0xfffffff829297812ULL, 0x000fe200078ee224ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x00000000121b7faeULL, 0x0005e2000d901c46ULL, 0x000064000e0e7a10ULL, 0x000fc40007fde0ffULL,
0x0000001039257824ULL, 0x100fe200078e020aULL, 0x0000000014237faeULL, 0x0007e2000e101c46ULL,
0x0000001027277824ULL, 0x100fe200078e020aULL, 0x000065000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x000000082b187824ULL, 0x000fe200078e00ffULL, 0x0000003817337810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e020aULL, 0x0000003c17357810ULL, 0x000fe20007ffe0ffULL,
0x000000001c257faeULL, 0x0009e2000e901c46ULL, 0x000000010b127824ULL, 0x004fe200078e0231ULL,
0x000000162b00720cULL, 0x080fe20003fa6070ULL, 0x000000082d1b7824ULL, 0x000fe200078e00ffULL,
0x000000001e277faeULL, 0x0005e2000c901c46ULL, 0x0000007010147812ULL, 0x008fe200078ef805ULL,
0x000000012b157824ULL, 0x100fe200078e0204ULL, 0x000000162d00720cULL, 0x0c0fe20003f86070ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000640014147a10ULL, 0x000fe20007fde0ffULL,
0x0000000020297faeULL, 0x0007e2000d101c46ULL, 0xfffffff818197812ULL, 0x000fe200078ee215ULL,
0x000000012d107824ULL, 0x100fe200078e0204ULL, 0x0000650011157a10ULL, 0x000fe200037fe4ffULL,
0x000000012f117824ULL, 0x140fe200078e0204ULL, 0x000000162f00720cULL, 0x0c0fe20003f66070ULL,
0x000000082f187824ULL, 0x000fe200078e00ffULL, 0x000000163100720cULL, 0x080fe20003f46070ULL,
0x00000001331a7824ULL, 0x040fe200078e0204ULL, 0x000000163300720cULL, 0x0c0fe20003f26070ULL,
0x00000008331f7824ULL, 0x004fe200078e00ffULL, 0x000000163500720cULL, 0x040fe20003f06070ULL,
0x0000000835217824ULL, 0x008fe200078e00ffULL, 0x0000007012167812ULL, 0x000fe200078ef805ULL,
0x000000010b127824ULL, 0x000fe200078e0233ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee210ULL,
0x0000001019197824ULL, 0x000fe200078e020aULL, 0xfffffff8181d7812ULL, 0x010fe200078ee211ULL,
0x0000010012107825ULL, 0x000fe200078e00ffULL, 0x0000640016167a10ULL, 0x000fc40007fde0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee21aULL, 0x000000010b127824ULL, 0x000fe200078e0235ULL,
0x0000650013177a10ULL, 0x000fe200037fe4ffULL, 0x0000000131187824ULL, 0x140fe200078e0204ULL,
0x0000007010107812ULL, 0x100fe200078ef805ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000000c197faeULL, 0x0005e4000e901c46ULL, 0x0000640010107a10ULL, 0x000fe20007fde0ffULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x0000007012057812ULL, 0x000fe200078ef805ULL,
0x0000000135047824ULL, 0x000fe200078e0204ULL, 0x0000650011117a10ULL, 0x000fe200037fe4ffULL,
0x000000101b1b7824ULL, 0x000fe200078e020aULL, 0xfffffff8310b7812ULL, 0x000fe200078ee218ULL,
0x000000101d1d7824ULL, 0x000fe200078e020aULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x000000101f1f7824ULL, 0x100fe200078e020aULL, 0x0000640005047a10ULL, 0x000fe20007fde0ffULL,
0x000000100b0b7824ULL, 0x100fe200078e020aULL, 0x000000000e1b7faeULL, 0x0005e2000e101c46ULL,
0x0000001021217824ULL, 0x000fe200078e020aULL, 0x0000650013057a10ULL, 0x000fc400037fe4ffULL,
0x00000000141d7faeULL, 0x0005e8000d901c46ULL, 0x00000000160b7faeULL, 0x0005e8000d101c46ULL,
0x00000000101f7faeULL, 0x0005e8000c901c46ULL, 0x0000000004217faeULL, 0x0005e2000c101c46ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000c04167811ULL, 0x040fe400078fe8ffULL,
0x0000000804147811ULL, 0x000fc400078fe8ffULL, 0x0000000404127811ULL, 0x000fe200078fe8ffULL,
0x00000001160d7824ULL, 0x100fe200078e0204ULL, 0x0000001804207811ULL, 0x000fe200078fe8ffULL,
0x00000008160e7824ULL, 0x000fe200078e00ffULL, 0x00000014041a7811ULL, 0x000fe200078fe8ffULL,
0x00000001140c7824ULL, 0x100fe200078e0204ULL, 0x0000001c04227811ULL, 0x000fe200078fe8ffULL,
0x0000000814277824ULL, 0x000fe200078e00ffULL, 0xfffffff80e257812ULL, 0x000fe200078ee20dULL,
0x00000001120a7824ULL, 0x000fe200078e0204ULL, 0x0000001004187811ULL, 0x000fe200078fe8ffULL,
0x0000000812297824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x00000001200d7824ULL, 0x000fe200078e0204ULL, 0x00000024040f7811ULL, 0x000fe200078fe8ffULL,
0x0000000820107824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20aULL,
0x000000011a0c7824ULL, 0x100fe200078e0204ULL, 0x0000002c04157811ULL, 0x000fe200078fe8ffULL,
0x000000081a217824ULL, 0x000fe200078e00ffULL, 0xfffffff8102f7812ULL, 0x000fe200078ee20dULL,
0x00000001220e7824ULL, 0x000fe200078e0204ULL, 0x0000002804137811ULL, 0x000fe200078fe8ffULL,
0x0000000822317824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20cULL,
0x00000001180a7824ULL, 0x000fe200078e0204ULL, 0x00000020040d7811ULL, 0x000fe200078fe8ffULL,
0x0000000818237824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20eULL,
0x000000010f0c7824ULL, 0x040fe200078e0204ULL, 0x00000038041b7811ULL, 0x040fe200078fe8ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee20aULL,
0x0000000115107824ULL, 0x040fe200078e0204ULL, 0x0000003c041d7811ULL, 0x040fe200078fe8ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee20cULL,
0x00000001130e7824ULL, 0x040fe200078e0204ULL, 0x00000004040c7211ULL, 0x040fe200078fe8ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0xfffffff8191e7812ULL, 0x000fe200078ee210ULL,
0x000000010d0a7824ULL, 0x040fe200078e0204ULL, 0x0000003404197811ULL, 0x000fe200078fe8ffULL,
0x000000080d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8171c7812ULL, 0x000fe200078ee20eULL,
0x00000001140e7824ULL, 0x100fe200078e020bULL, 0x0000003004177811ULL, 0x000fe200078fe8ffULL,
0x0000000116107824ULL, 0x000fe200078e020bULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL,
0x000000010b2e7824ULL, 0x000fe200078e020fULL, 0x0000000b040a7211ULL, 0x000fe200078fe8ffULL,
0x000000011a147824ULL, 0x100fe200078e020bULL, 0x000000070c1f7812ULL, 0x000fe200078ec0ffULL,
0x00000001120c7824ULL, 0x000fc400078e020bULL, 0x0000000118127824ULL, 0x100fe200078e020bULL,
0x0ffffff81f1f7812ULL, 0x100fe200078ef804ULL, 0x0000000120167824ULL, 0x100fe400078e020bULL,
0x0000000122187824ULL, 0x000fe400078e020bULL, 0x00000001190f7824ULL, 0x040fe400078e0204ULL,
0x00000008192a7824ULL, 0x000fe400078e00ffULL, 0x000000010b1a7824ULL, 0x000fc400078e020dULL,
0x000000010b307824ULL, 0x040fe200078e0213ULL, 0xfffffff82a137812ULL, 0x000fe200078ee20fULL,
0x000000010b327824ULL, 0x040fe200078e0215ULL, 0x00001000022a7811ULL, 0x000fe200078e70ffULL,
0x000000010b287824ULL, 0x040fe400078e0217ULL, 0x000000010b247824ULL, 0x040fe400078e0219ULL,
0x000000010b227824ULL, 0x040fe400078e021bULL, 0x000000010b207824ULL, 0x000fc400078e021dULL,
0x000001000a0a7825ULL, 0x000fc800078e00ffULL, 0x00000001170d7824ULL, 0x140fe200078e0204ULL,
0x000000700a0a7812ULL, 0x000fe200078ef805ULL, 0x0000000817267824ULL, 0x000fe400078e00ffULL,
0x000000011b157824ULL, 0x100fe200078e0204ULL, 0x000064000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x000000011d047824ULL, 0x040fe200078e0204ULL, 0xfffffff826267812ULL, 0x000fe200078ee20dULL,
0x000000081d177824ULL, 0x000fe200078e00ffULL, 0x000065000b0b7a10ULL, 0x000fe200007fe4ffULL,
0x000000081b2c7824ULL, 0x000fc400078e00ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe400078ee204ULL, 0xfffffff82c157812ULL, 0x000fe200078ee215ULL,
0x0000001011047824ULL, 0x000fe200078e022aULL, 0x000000700e0e7812ULL, 0x000fe200078ef805ULL,
0x0000010010107825ULL, 0x000fc600078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000010153f7824ULL, 0x100fe200078e022aULL, 0x0000007010107812ULL, 0x100fe200078ef805ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000065000f0f7a10ULL, 0x000fe400007fe4ffULL,
0x0000640010107a10ULL, 0x000fe20007f1e0ffULL, 0x0000001017417824ULL, 0x000fe200078e022aULL,
0x0000007014147812ULL, 0x000fe200078ef805ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000650011117a10ULL, 0x000fc400007fe4ffULL, 0x0000640014147a10ULL, 0x000fe20007f1e0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000007018187812ULL, 0x100fe400078ef805ULL,
0x0000650015157a10ULL, 0x000fe200007fe4ffULL, 0x000000101f2b7824ULL, 0x100fe200078e022aULL,
0x0000007016167812ULL, 0x100fe200078ef805ULL, 0x000000102f1f7824ULL, 0x100fe200078e022aULL,
0x0000640018187a10ULL, 0x000fe20007f1e0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000640016167a10ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2b7faeULL, 0x0005e2000b901c46ULL, 0x0000650019197a10ULL, 0x000fe200007fe4ffULL,
0x00000010311d7824ULL, 0x000fe200078e022aULL, 0x000000700c0c7812ULL, 0x000fe200078ef805ULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000650017177a10ULL, 0x000fc400017fe4ffULL,
0x000064000c0c7a10ULL, 0x000fe20007f3e0ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x000000702e387812ULL, 0x100fe400078ef805ULL, 0x000065000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x00000010133d7824ULL, 0x000fe200078e022aULL, 0x00000070303a7812ULL, 0x100fe200078ef805ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000640038387a10ULL, 0x000fe40007f1e0ffULL,
0x000064003a3a7a10ULL, 0x000fe20007f5e0ffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ef805ULL, 0x000065002f397a10ULL, 0x000fe200007fe4ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000640012127a10ULL, 0x000fe40007f3e0ffULL,
0x0000007032327812ULL, 0x100fe200078ef805ULL, 0x00000100282e7825ULL, 0x000fe200078e00ffULL,
0x00006500313b7a10ULL, 0x000fe400017fe4ffULL, 0x000000701a1a7812ULL, 0x000fe200078ef805ULL,
0x0000010024307825ULL, 0x000fe200078e00ffULL, 0x0000650013137a10ULL, 0x000fc40000ffe4ffULL,
0x0000640032327a10ULL, 0x000fe20007f1e0ffULL, 0x0000001029297824ULL, 0x100fe200078e022aULL,
0x000064001a1a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000010022347825ULL, 0x000fe200078e00ffULL,
0x000000702e2e7812ULL, 0x100fe400078ef805ULL, 0x0000007030307812ULL, 0x100fe200078ef805ULL,
0x0000001027277824ULL, 0x000fe200078e022aULL, 0x0000007034347812ULL, 0x000fe200078ef805ULL,
0x0000010020367825ULL, 0x000fe200078e00ffULL, 0x000000000c297faeULL, 0x0005e2000b901c46ULL,
0x0000650033337a10ULL, 0x000fc400007fe4ffULL, 0x0000001025257824ULL, 0x100fe200078e022aULL,
0x0000007036057812ULL, 0x000fe200078ef805ULL, 0x0000001023237824ULL, 0x100fe200078e022aULL,
0x000000000e277faeULL, 0x0005e2000b901c46ULL, 0x0000001021217824ULL, 0x100fe200078e022aULL,
0x000065001b1b7a10ULL, 0x000fe20000ffe4ffULL, 0x000000102d2d7824ULL, 0x100fe200078e022aULL,
0x000064002e2e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000010257faeULL, 0x0005e2000b901c46ULL,
0x0000640030307a10ULL, 0x000fe20007f3e0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e022aULL,
0x0000640034347a10ULL, 0x000fe20007f5e0ffULL, 0x0000000012237faeULL, 0x0005e2000b901c46ULL,
0x000000101e1e7824ULL, 0x100fe200078e022aULL, 0x0000640005367a10ULL, 0x000fe20007f7e0ffULL,
0x0000001026267824ULL, 0x000fe200078e022aULL, 0x0000000014217faeULL, 0x0005e2000b901c46ULL,
0x000065002f2f7a10ULL, 0x000fc400007fe4ffULL, 0x0000650031317a10ULL, 0x000fe20000ffe4ffULL,
0x00000000161f7faeULL, 0x0005e2000b901c46ULL, 0x0000650035357a10ULL, 0x000fe400017fe4ffULL,
0x0000650037377a10ULL, 0x000fe20001ffe4ffULL, 0x00000000181d7faeULL, 0x0005e8000b901c46ULL,
0x000000001a2d7faeULL, 0x0005e8000b901c46ULL, 0x0000000038047faeULL, 0x0005e8000b901c46ULL,
0x000000003a1c7faeULL, 0x0005e8000b901c46ULL, 0x00000000321e7faeULL, 0x0005e8000b901c46ULL,
0x000000002e267faeULL, 0x0005e8000b901c46ULL, 0x00000000303d7faeULL, 0x0005e8000b901c46ULL,
0x00000000343f7faeULL, 0x0005e8000b901c46ULL, 0x0000000036417faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x004fc40000015200ULL,
0x01b60400ff0b7984ULL, 0x000ea20000000800ULL, 0x0000000908597224ULL, 0x000fc400078e02ffULL,
0x00000001666f7824ULL, 0x000fe400078e0a00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x800000000bff7812ULL, 0x006fe20007804807ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000620059587625ULL, 0x000fe200078e0058ULL,
0x00000008ff6f7819ULL, 0x000fe2000001166fULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a040d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e05ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc8000001140bULL,
0x0000000d08087211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000208087819ULL, 0x000fc8000000120bULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000005c0300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00000002096c7824ULL, 0x000fe200078e00ffULL,
0x0001b68802727811ULL, 0x040fe200078e18ffULL, 0x0000002002737824ULL, 0x000fe200078e00ffULL,
0xffffffff00057810ULL, 0x040fe40007ffe0ffULL, 0x0000000900067810ULL, 0x000fc40007ffe0ffULL,
0x0000000103077810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007946ULL, 0x000fe60003800000ULL,
0x0000005c0700720cULL, 0x000fe20003f06070ULL, 0x0000010003077824ULL, 0x000fc800078e0275ULL,
0x000068006b0d7a24ULL, 0x004fd000078e0207ULL, 0x00000bb000008947ULL, 0x008fea0003800000ULL,
0x00000003ff1a7819ULL, 0x002fe20000011604ULL, 0x0000001004087824ULL, 0x000fc600078e00ffULL,
0x000000081a127810ULL, 0x040fe20007ffe0ffULL, 0x000000011a0f7824ULL, 0x040fe200078e020dULL,
0x000000041a107810ULL, 0x040fe40007ffe0ffULL, 0x000000101a167810ULL, 0x000fe20007ffe0ffULL,
0x00000001120b7824ULL, 0x100fe200078e0204ULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x00000008120c7824ULL, 0x000fe200078e00ffULL, 0x0000000c1a147810ULL, 0x000fe20007ffe0ffULL,
0x0000000110097824ULL, 0x100fe200078e0204ULL, 0x000000181a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008100a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c277812ULL, 0x000fe200078ee20bULL,
0x0000000116117824ULL, 0x000fe200078e0204ULL, 0x00000007660c7217ULL, 0x000fe20007800000ULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a257812ULL, 0x000fe200078ee209ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x00000080080a7812ULL, 0x000fe200078efcffULL,
0x000000010c1b7824ULL, 0x000fe200078e0a07ULL, 0xfffffff81c2b7812ULL, 0x000fe200078ee211ULL,
0x0000000110117824ULL, 0x000fe200078e020dULL, 0x000000141a0c7810ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e000aULL, 0x0000001b1000720cULL, 0x000fc40003f86070ULL,
0x0000001b1200720cULL, 0x080fe20003f46070ULL, 0x0000000114097824ULL, 0x000fe200078e0204ULL,
0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000814187824ULL, 0x040fe200078e00ffULL,
0x0000001b1400720cULL, 0x080fe20003f66070ULL, 0x0000010011107825ULL, 0x000fe200078e000aULL,
0x000065000f0f7a10ULL, 0x000fe400007fe4ffULL, 0xfffffff818297812ULL, 0x000fe200078ee209ULL,
0x0000000112137824ULL, 0x100fe200078e020dULL, 0x0000640010207a10ULL, 0x000fe20007f3e0ffULL,
0x0000000116097824ULL, 0x040fe200078e020dULL, 0x0000001b1600720cULL, 0x000fe20003f06070ULL,
0x0000010013127825ULL, 0x000fe200078e000aULL, 0x0000650011217a10ULL, 0x000fc40000ffe4ffULL,
0x0000001c1a247810ULL, 0x000fe20007ffe0ffULL, 0x0000000114157824ULL, 0x100fe200078e020dULL,
0x0000640012167a10ULL, 0x000fe20007fbe0ffULL, 0x000000010c1d7824ULL, 0x000fe200078e020dULL,
0x000000201a287810ULL, 0x000fe20007ffe0ffULL, 0x0000010009107825ULL, 0x100fe200078e000aULL,
0x0000650013177a10ULL, 0x000fe40002ffe4ffULL, 0x0ffffff804097812ULL, 0x000fe200078ec0ffULL,
0x0000010015147825ULL, 0x000fe200078e000aULL, 0x0000640010127a10ULL, 0x000fc60007fbe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e000aULL, 0x0000640014187a10ULL, 0x000fe40007f3e0ffULL,
0x0000650011137a10ULL, 0x000fe20002ffe4ffULL, 0x000000080c227824ULL, 0x000fe200078e00ffULL,
0x000064001c107a10ULL, 0x000fe20007fde0ffULL, 0x000000011a1c7824ULL, 0x140fe200078e0204ULL,
0x0000001b1a00720cULL, 0x080fe20003fa6070ULL, 0x00000001281f7824ULL, 0x100fe200078e020dULL,
0x0000650015197a10ULL, 0x000fe20000ffe4ffULL, 0x000000011e157824ULL, 0x000fe200078e020dULL,
0x000065001d117a10ULL, 0x000fe200037fe4ffULL, 0x000000010c1d7824ULL, 0x040fe200078e0204ULL,
0x0000001b0c00720cULL, 0x000fe20003f26070ULL, 0x0000010015147825ULL, 0x000fe200078e000aULL,
0x00003000020c7811ULL, 0x000fc400078e70ffULL, 0x0000000709237812ULL, 0x000fe200078ef81cULL,
0x000000081e2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8222d7812ULL, 0x000fe200078ee21dULL,
0x0000001025257824ULL, 0x100fe200078e020cULL, 0x0000640014147a10ULL, 0x000fe20007fde0ffULL,
0x0000001023237824ULL, 0x000fe400078e020cULL, 0x00000001241d7824ULL, 0x000fe200078e020dULL,
0x0000650015157a10ULL, 0x000fe200037fe4ffULL, 0x000000011e227824ULL, 0x040fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e237faeULL, 0x0003e2000e901c46ULL,
0x000001001d1c7825ULL, 0x000fe200078e000aULL, 0x0000001b1e00720cULL, 0x000fc40003fa6070ULL,
0x0000000020257faeULL, 0x0005e2000e101c46ULL, 0x000001001f1e7825ULL, 0x000fe200078e000aULL,
0x000064001c1c7a10ULL, 0x000fe40007fde0ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee222ULL,
0x0000000124267824ULL, 0x040fe200078e0204ULL, 0x000065001d1d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000824317824ULL, 0x000fe200078e00ffULL, 0x000064001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x0000001027237824ULL, 0x002fe200078e020cULL, 0x0000001b2400720cULL, 0x000fc40003f86070ULL,
0x000000241a207810ULL, 0x004fe20007ffe0ffULL, 0x0000001029257824ULL, 0x000fe200078e020cULL,
0x0000000016237faeULL, 0x0003e2000d101c46ULL, 0x0000000128217824ULL, 0x000fe200078e0204ULL,
0x000065001f1f7a10ULL, 0x000fe200037fe4ffULL, 0x00000001200f7824ULL, 0x000fe200078e020dULL,
0x0000000018257faeULL, 0x0005e2000d901c46ULL, 0x0000001b2800720cULL, 0x0c0fe20003f66070ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000001b2000720cULL, 0x000fe20003f46070ULL,
0x000001000f0e7825ULL, 0x000fe200078e000aULL, 0xfffffff831317812ULL, 0x000fc400078ee226ULL,
0xfffffff828277812ULL, 0x000fe200078ee221ULL, 0x0000000120227824ULL, 0x000fe200078e0204ULL,
0x0000002c1a167810ULL, 0x002fe20007ffe0ffULL, 0x0000000820297824ULL, 0x000fe200078e00ffULL,
0x000064000e207a10ULL, 0x000fe20007fde0ffULL, 0x000000102b177824ULL, 0x100fe200078e020cULL,
0x000000281a0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000102f197824ULL, 0x104fe200078e020cULL,
0x000065000f217a10ULL, 0x000fe200037fe4ffULL, 0x000000102d0f7824ULL, 0x000fe200078e020cULL,
0xfffffff829297812ULL, 0x000fe200078ee222ULL, 0x0000001031237824ULL, 0x100fe200078e020cULL,
0x0000000012177faeULL, 0x0003e2000c101c46ULL, 0x0000001027257824ULL, 0x000fe200078e020cULL,
0x000000301a187810ULL, 0x000fc40007ffe0ffULL, 0x00000000100f7faeULL, 0x0005e2000c901c46ULL,
0x000000341a227810ULL, 0x040fe40007ffe0ffULL, 0x000000381a247810ULL, 0x040fe20007ffe0ffULL,
0x0000000014197faeULL, 0x0007e2000e901c46ULL, 0x0000003c1a1a7810ULL, 0x000fe40007ffe0ffULL,
0x0000001b0e00720cULL, 0x080fe20003fc6070ULL, 0x000000001c237faeULL, 0x0009e2000e101c46ULL,
0x0000001b1600720cULL, 0x080fe20003fa6070ULL, 0x0000001029137824ULL, 0x002fe200078e020cULL,
0x0000001b1800720cULL, 0x080fe20003f86070ULL, 0x000000010e0f7824ULL, 0x144fe200078e0204ULL,
0x000000001e257faeULL, 0x0003e2000d901c46ULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x0000001b2200720cULL, 0x080fe20003f66070ULL, 0x0000000116117824ULL, 0x000fe200078e020dULL,
0x0000001b2400720cULL, 0x080fe20003f26070ULL, 0x0000000020137faeULL, 0x0005e2000d101c46ULL,
0x0000001b1a00720cULL, 0x000fe20003f06070ULL, 0x0000000118147824ULL, 0x008fe200078e0204ULL,
0xfffffff8101b7812ULL, 0x000fe200078ee20fULL, 0x000000010e0f7824ULL, 0x000fc400078e020dULL,
0x0000010011107825ULL, 0x000fc800078e000aULL, 0x000001000f0e7825ULL, 0x000fc800078e000aULL,
0x00000008181f7824ULL, 0x002fe200078e00ffULL, 0x000064000e0e7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000116127824ULL, 0x040fe400078e0204ULL, 0x00000008161d7824ULL, 0x010fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee214ULL, 0x0000000118157824ULL, 0x000fe200078e020dULL,
0x000065000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x0000000822217824ULL, 0x004fe200078e00ffULL,
0x0000640010147a10ULL, 0x000fe20007f5e0ffULL, 0x0000000122107824ULL, 0x000fe200078e0204ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee212ULL, 0x0000010015127825ULL, 0x000fe200078e000aULL,
0x0000650011157a10ULL, 0x000fc400017fe4ffULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x0000000122177824ULL, 0x100fe200078e020dULL, 0x0000640012167a10ULL, 0x000fe20007f5e0ffULL,
0x0000000124197824ULL, 0x000fe400078e020dULL, 0x0000010017107825ULL, 0x000fe200078e000aULL,
0x0000650013177a10ULL, 0x000fc600017fe4ffULL, 0x0000010019127825ULL, 0x000fe200078e000aULL,
0x0000640010107a10ULL, 0x000fc60007f5e0ffULL, 0x000000011a0d7824ULL, 0x000fe200078e020dULL,
0x0000650011117a10ULL, 0x000fe200017fe4ffULL, 0x0000000124187824ULL, 0x100fe200078e0204ULL,
0x0000640012127a10ULL, 0x000fe20007f5e0ffULL, 0x0000000824237824ULL, 0x000fe400078e00ffULL,
0x000000011a197824ULL, 0x040fe200078e0204ULL, 0x0000650013137a10ULL, 0x000fe200017fe4ffULL,
0x000000081a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee218ULL,
0x000001000d0a7825ULL, 0x000fc600078e000aULL, 0xfffffff81a257812ULL, 0x000fe200078ee219ULL,
0x000000101b0d7824ULL, 0x100fe200078e020cULL, 0x000064000a0a7a10ULL, 0x000fe20007f5e0ffULL,
0x000000101d197824ULL, 0x100fe400078e020cULL, 0x000000101f1b7824ULL, 0x100fe200078e020cULL,
0x000065000b0b7a10ULL, 0x000fe200017fe4ffULL, 0x00000010211d7824ULL, 0x100fe200078e020cULL,
0x000000000e0d7faeULL, 0x0003e2000f101c46ULL, 0x00000010231f7824ULL, 0x100fe400078e020cULL,
0x0000001025217824ULL, 0x000fe200078e020cULL, 0x0000000014197faeULL, 0x0003e8000e901c46ULL,
0x00000000161b7faeULL, 0x0003e8000e101c46ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x00000000121f7faeULL, 0x0003e8000c901c46ULL, 0x000000000a217faeULL, 0x0003e2000c101c46ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x0000000404117811ULL, 0x042fe400078fe8ffULL,
0x0000000c04157811ULL, 0x000fc400078fe8ffULL, 0x0000001404197811ULL, 0x040fe200078fe8ffULL,
0x0000000111087824ULL, 0x140fe200078e0204ULL, 0x00000018041b7811ULL, 0x040fe200078fe8ffULL,
0x00000008110b7824ULL, 0x000fe200078e00ffULL, 0x00000020041f7811ULL, 0x040fe200078fe8ffULL,
0x00000001190a7824ULL, 0x040fe200078e0204ULL, 0x0000000804137811ULL, 0x040fe200078fe8ffULL,
0x00000008190f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL,
0x0000000115087824ULL, 0x040fe200078e0204ULL, 0x0000002404217811ULL, 0x040fe200078fe8ffULL,
0x00000008150b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f2c7812ULL, 0x000fe200078ee20aULL,
0x000000011f0a7824ULL, 0x040fe200078e0204ULL, 0x0000002c04257811ULL, 0x040fe200078fe8ffULL,
0x000000081f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b127812ULL, 0x000fe200078ee208ULL,
0x000000011b087824ULL, 0x040fe200078e0204ULL, 0x0000001004177811ULL, 0x040fe200078fe8ffULL,
0x000000081b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f327812ULL, 0x000fe200078ee20aULL,
0x0000000113097824ULL, 0x040fe200078e0204ULL, 0x0000003004277811ULL, 0x040fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0xfffffff80b2e7812ULL, 0x000fe200078ee208ULL,
0x0000000121087824ULL, 0x140fe200078e0204ULL, 0x0000001c041d7811ULL, 0x000fe200078fe8ffULL,
0x00000008210b7824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee209ULL,
0x00000001250a7824ULL, 0x040fe200078e0204ULL, 0x0000002804237811ULL, 0x040fe200078fe8ffULL,
0x00000008250f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b147812ULL, 0x000fe200078ee208ULL,
0x0000000117097824ULL, 0x040fe200078e0204ULL, 0x0000003c043f7811ULL, 0x040fe200078fe8ffULL,
0x00000008172a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f187812ULL, 0x000fe200078ee20aULL,
0x0000000127087824ULL, 0x140fe200078e0204ULL, 0x0000003404297811ULL, 0x000fe200078fe8ffULL,
0x00000008270f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL,
0x000000011d097824ULL, 0x040fe200078e0204ULL, 0x00000038040b7811ULL, 0x040fe200078fe8ffULL,
0x000000081d307824ULL, 0x000fe200078e00ffULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee208ULL,
0x0000001004087824ULL, 0x000fe200078e00ffULL, 0x0000300002417811ULL, 0x000fe200078e70ffULL,
0x0000000823167824ULL, 0x040fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee209ULL,
0x0000000123097824ULL, 0x100fe200078e0204ULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x000000013f0c7824ULL, 0x000fc400078e0204ULL, 0x000000083f0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee209ULL, 0x0000000129097824ULL, 0x040fe400078e0204ULL,
0x00000008291c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f207812ULL, 0x000fe200078ee20cULL,
0x000000010b0a7824ULL, 0x040fe200078e0204ULL, 0x0000000d040f7211ULL, 0x000fe200078fe8ffULL,
0x000000080b2b7824ULL, 0x000fe200078e00ffULL, 0x00000080080c7812ULL, 0x000fe200078efcffULL,
0x0000000111117824ULL, 0x000fe200078e020dULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL,
0x0000000113137824ULL, 0x100fe200078e020dULL, 0xfffffff82b1e7812ULL, 0x000fe200078ee20aULL,
0x0000000115157824ULL, 0x100fe200078e020dULL, 0x00000004040a7211ULL, 0x040fe200078fe8ffULL,
0x0000000117177824ULL, 0x100fe200078e020dULL, 0x0ffffff804097812ULL, 0x000fe200078ec0ffULL,
0x0000000119197824ULL, 0x000fc400078e020dULL, 0x000000011b1b7824ULL, 0x100fe200078e020dULL,
0x00000007090a7812ULL, 0x000fe200078ef80aULL, 0x000000011d1d7824ULL, 0x100fe400078e020dULL,
0x000000011f1f7824ULL, 0x100fe400078e020dULL, 0x0000000121217824ULL, 0x100fe400078e020dULL,
0x0000000123237824ULL, 0x100fe400078e020dULL, 0x0000000125257824ULL, 0x000fc400078e020dULL,
0x0000000127277824ULL, 0x100fe400078e020dULL, 0x0000000129297824ULL, 0x100fe400078e020dULL,
0x000000010b0b7824ULL, 0x100fe400078e020dULL, 0x000000013f3f7824ULL, 0x000fe400078e020dULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000100e2d7824ULL, 0x000fc400078e0241ULL,
0x00000010102f7824ULL, 0x000fe400078e0241ULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x0000001012317824ULL, 0x000fe200078e0241ULL, 0x000064000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010011107825ULL, 0x000fc600078e000cULL, 0x000065000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000001014337824ULL, 0x000fe200078e0241ULL, 0x0000640010107a10ULL, 0x000fe20007f3e0ffULL,
0x0000010013127825ULL, 0x000fc600078e000cULL, 0x0000650011117a10ULL, 0x000fe20000ffe4ffULL,
0x0000010015147825ULL, 0x000fe200078e000cULL, 0x0000640012127a10ULL, 0x000fc60007f5e0ffULL,
0x0000001016357824ULL, 0x100fe200078e0241ULL, 0x0000640014147a10ULL, 0x000fe20007f7e0ffULL,
0x0000001018377824ULL, 0x000fe200078e0241ULL, 0x0000650013137a10ULL, 0x000fe200017fe4ffULL,
0x0000010017167825ULL, 0x000fe200078e000cULL, 0x0000650015157a10ULL, 0x000fc60001ffe4ffULL,
0x000000101a397824ULL, 0x000fe200078e0241ULL, 0x0000640016167a10ULL, 0x000fe20007f1e0ffULL,
0x0000010019187825ULL, 0x000fc600078e000cULL, 0x0000650017177a10ULL, 0x000fe200007fe4ffULL,
0x000000101c3b7824ULL, 0x000fe200078e0241ULL, 0x0000640018187a10ULL, 0x000fe20007f3e0ffULL,
0x000001001b1a7825ULL, 0x000fc600078e000cULL, 0x0000650019197a10ULL, 0x000fe20000ffe4ffULL,
0x000001001d1c7825ULL, 0x000fe200078e000cULL, 0x000064001a1a7a10ULL, 0x000fc60007f5e0ffULL,
0x000000100a2b7824ULL, 0x100fe200078e0241ULL, 0x000064001c1c7a10ULL, 0x000fe20007f7e0ffULL,
0x000000102a2a7824ULL, 0x100fe200078e0241ULL, 0x000065001b1b7a10ULL, 0x000fe200017fe4ffULL,
0x000000102c2c7824ULL, 0x100fe200078e0241ULL, 0x000065001d1d7a10ULL, 0x000fe20001ffe4ffULL,
0x000000102e2e7824ULL, 0x100fe200078e0241ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2b7faeULL, 0x0003e2000b901c46ULL, 0x0000001030307824ULL, 0x100fe400078e0241ULL,
0x0000001032327824ULL, 0x100fe200078e0241ULL, 0x00000000102d7faeULL, 0x0003e2000b901c46ULL,
0x000000101e3d7824ULL, 0x000fc400078e0241ULL, 0x0000001020417824ULL, 0x000fe200078e0241ULL,
0x00000000122f7faeULL, 0x0003e2000b901c46ULL, 0x000001001f1e7825ULL, 0x000fc600078e000cULL,
0x0000000014317faeULL, 0x0003e2000b901c46ULL, 0x0000010021207825ULL, 0x100fe200078e000cULL,
0x000064001e1e7a10ULL, 0x000fe40007f1e0ffULL, 0x00000000162a7faeULL, 0x0003e2000b901c46ULL,
0x0000010023227825ULL, 0x100fe200078e000cULL, 0x0000640020207a10ULL, 0x000fe40007f3e0ffULL,
0x000065001f1f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010025247825ULL, 0x100fe200078e000cULL,
0x0000640022227a10ULL, 0x000fe20007f5e0ffULL, 0x00000000182c7faeULL, 0x0003e2000b901c46ULL,
0x0000650021217a10ULL, 0x000fe20000ffe4ffULL, 0x0000010027267825ULL, 0x100fe200078e000cULL,
0x0000640024247a10ULL, 0x000fe20007f7e0ffULL, 0x000000001a2e7faeULL, 0x0003e2000b901c46ULL,
0x0000650023237a10ULL, 0x000fe200017fe4ffULL, 0x0000010029287825ULL, 0x100fe200078e000cULL,
0x0000640026267a10ULL, 0x000fe20007f1e0ffULL, 0x000000001c307faeULL, 0x0003e2000b901c46ULL,
0x0000650025257a10ULL, 0x000fe20001ffe4ffULL, 0x000001000b0a7825ULL, 0x100fe200078e000cULL,
0x0000640028287a10ULL, 0x000fe20007f3e0ffULL, 0x000000001e327faeULL, 0x0003e2000b901c46ULL,
0x0000650027277a10ULL, 0x000fe200007fe4ffULL, 0x000001003f0c7825ULL, 0x000fe200078e000cULL,
0x000064000a0a7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000020337faeULL, 0x0003e2000b901c46ULL,
0x0000650029297a10ULL, 0x000fc40000ffe4ffULL, 0x000064000c0c7a10ULL, 0x000fe20007f7e0ffULL,
0x0000000022357faeULL, 0x0003e2000b901c46ULL, 0x000065000b0b7a10ULL, 0x000fe400017fe4ffULL,
0x000065000d0d7a10ULL, 0x000fe20001ffe4ffULL, 0x0000000024377faeULL, 0x0003e8000b901c46ULL,
0x0000000026397faeULL, 0x0003e8000b901c46ULL, 0x00000000283b7faeULL, 0x0003e8000b901c46ULL,
0x000000000a3d7faeULL, 0x0003e8000b901c46ULL, 0x000000000c417faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000007040f7812ULL, 0x002fc400078ec0ffULL,
0x00000004ff0d7819ULL, 0x100fe40000011604ULL, 0x000000080f0a7812ULL, 0x000fca00078ef804ULL,
0x000000010d0b7824ULL, 0x000fe400078e020aULL, 0x000000100a0c7824ULL, 0x000fca00078e00ffULL,
0xfffffff00c0c7812ULL, 0x000fca00078ee20bULL, 0x000000100c2c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000080d367824ULL, 0x000fe200078e00ffULL, 0x00000003ff627819ULL, 0x000fe20000011604ULL,
0x00004000020c7824ULL, 0x000fe200078e00ffULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x000000100a127824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe400078ee20fULL,
0x0000000162107812ULL, 0x000fe400078ec0ffULL, 0x000010000c0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000836617824ULL, 0x040fe200078e00ffULL, 0x00000010360f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001100e7824ULL, 0x000fe200078e0236ULL, 0x0000003036357810ULL, 0x040fe20007ffe0ffULL,
0x0000000836147824ULL, 0x040fe200078e00ffULL, 0x0000002036347810ULL, 0x000fe20007ffe0ffULL,
0x0000000110607824ULL, 0x000fe200078e020fULL, 0xfffffff861617812ULL, 0x000fe200078ee20eULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0x000000020e5d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001105e7824ULL, 0x000fe200078e0235ULL, 0x000000020b117810ULL, 0x000fe20007ffe0ffULL,
0x00000010611c7824ULL, 0x000fe200078e020dULL, 0xfffffff813607812ULL, 0x000fe200078ee260ULL,
0x0000000835137824ULL, 0x000fe200078e00ffULL, 0xfffffff8145d7812ULL, 0x000fe200078ee25dULL,
0x00000001105f7824ULL, 0x000fe200078e0234ULL, 0xfffffff012117812ULL, 0x000fe200078ee211ULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0xfffffff8135e7812ULL, 0x000fe200078ee25eULL,
0x0000000834107824ULL, 0x000fe200078e00ffULL, 0x000000120e5b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001060387824ULL, 0x100fe200078e020dULL, 0x000000220e687810ULL, 0x000fe20007ffe0ffULL,
0x000000105e307824ULL, 0x000fe200078e020dULL, 0xfffffff8105f7812ULL, 0x000fe200078ee25fULL,
0x000000105d507824ULL, 0x100fe200078e020dULL, 0x000000320e647810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x000000003838783bULL, 0x000fe20000000200ULL,
0x000000105f107824ULL, 0x000fe200078e020dULL, 0x000000040b377810ULL, 0x000fe20007ffe0ffULL,
0x000000080f147824ULL, 0x000fe200078e00ffULL, 0x000000003030783bULL, 0x000ea20000000200ULL,
0x0000000834157824ULL, 0x000fe200078e00ffULL, 0x000000040e5a7810ULL, 0x000fc40007ffe0ffULL,
0x000000001128783bULL, 0x000fe20000000200ULL, 0xfffffff8145b7812ULL, 0x000fe400078ee25bULL,
0xfffffff815687812ULL, 0x000fe200078ee268ULL, 0x000000005050783bULL, 0x000ee20000000200ULL,
0x000000140e657810ULL, 0x040fe20007ffe0ffULL, 0x000000105b187824ULL, 0x100fe200078e020dULL,
0x000000240e697810ULL, 0x000fe20007ffe0ffULL, 0x000000001010783bULL, 0x000f220000000200ULL,
0x0000001068207824ULL, 0x000fe200078e020dULL, 0x000000340e6a7810ULL, 0x000fc40007ffe0ffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x000000060e677810ULL, 0x040fe40007ffe0ffULL,
0x000000160e637810ULL, 0x000fe20007ffe0ffULL, 0x000000002020783bULL, 0x000ee20000000200ULL,
0x0000001c2c54723cULL, 0x042f7000000418ffULL, 0x0000001e2c1c723cULL, 0x040f7000000418ffULL,
0x000000302c24723cULL, 0x044bee00000418ffULL, 0x0000000835317824ULL, 0x020fe200078e00ffULL,
0x000000382c14723cULL, 0x000f6800000418ffULL, 0xfffffff831647812ULL, 0x000fc800078ee264ULL,
0x0000003a2c38723cULL, 0x000f6200000418ffULL, 0x0000001064307824ULL, 0x000fce00078e020dULL,
0x000000502854723cULL, 0x048ff00000041854ULL, 0x000000522850723cULL, 0x000ff0000004181cULL,
0x000000102c1c723cULL, 0x050f7000000418ffULL, 0x000000122c10723cULL, 0x040f7000000418ffULL,
0x000000322c2c723cULL, 0x000b6400000418ffULL, 0x000000003030783bULL, 0x020e6c0000000200ULL,
0x000000182814723cULL, 0x040ff00000041814ULL, 0x0000001a2818723cULL, 0x040bee0000041838ULL,
0x000000100a387824ULL, 0x020fe200078e00ffULL, 0x00000020281c723cULL, 0x000be2000004181cULL,
0x0000000835397824ULL, 0x000fc400078e00ffULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0xfffffff038377812ULL, 0x000fe200078ee237ULL, 0x0000000834387824ULL, 0x000fe200078e00ffULL,
0xfffffff8396a7812ULL, 0x000fe200078ee26aULL, 0x0000000836217824ULL, 0x020fe400078e00ffULL,
0x000000080f207824ULL, 0x000fe200078e00ffULL, 0xfffffff838697812ULL, 0x000fe200078ee269ULL,
0x000000106a447824ULL, 0x000fe200078e020dULL, 0xfffffff8215a7812ULL, 0x000fe200078ee25aULL,
0x0000001037377824ULL, 0x000fe200078e00ffULL, 0xfffffff820657812ULL, 0x000fe200078ee265ULL,
0x0000001069487824ULL, 0x100fe200078e020dULL, 0x000000222820723cULL, 0x040be20000041810ULL,
0x000000004444783bULL, 0x000fe20000000200ULL, 0x000000100a397824ULL, 0x000fe200078e00ffULL,
0x000000060b387810ULL, 0x000fe20007ffe0ffULL, 0x00000010654c7824ULL, 0x100fe200078e020dULL,
0x000000003740783bULL, 0x000ea20000000200ULL, 0x0000000836367824ULL, 0x000fe200078e00ffULL,
0xfffffff039387812ULL, 0x000fe200078ee238ULL, 0x000000105a107824ULL, 0x020fe200078e020dULL,
0x000000004848783bULL, 0x000fe20000000200ULL, 0x000000302824723cULL, 0x002b620000041824ULL,
0x0000000834347824ULL, 0x000fe200078e00ffULL, 0xfffffff836677812ULL, 0x000fe200078ee267ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x00000010386d7824ULL, 0x000fc600078e00ffULL,
0x000000001010783bULL, 0x000ee20000000200ULL, 0x000000080f307824ULL, 0x020fe200078e00ffULL,
0x000000260e0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000322828723cULL, 0x000b62000004182cULL,
0x000000360e0e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010673c7824ULL, 0x000fe200078e020dULL,
0xfffffff830637812ULL, 0x000fe200078ee263ULL, 0x000000006d2c783bULL, 0x020fe20000000200ULL,
0xfffffff8340f7812ULL, 0x000fe400078ee20fULL, 0xfffffff8350e7812ULL, 0x000fe200078ee20eULL,
0x0000001063387824ULL, 0x100fe200078e020dULL, 0x000000003c3c783bULL, 0x000f220000000200ULL,
0x000000100f347824ULL, 0x000fc400078e020dULL, 0x000000100e307824ULL, 0x000fe400078e020dULL,
0x000000003838783bULL, 0x000f280000000200ULL, 0x000000003434783bULL, 0x000f280000000200ULL,
0x000000003030783bULL, 0x000f220000000200ULL, 0x000000444024723cULL, 0x044ff00000041824ULL,
0x0000004c4014723cULL, 0x042ff00000041814ULL, 0x000000104054723cULL, 0x048f700000041854ULL,
0x000000124050723cULL, 0x040f700000041850ULL, 0x0000004e4018723cULL, 0x040f700000041818ULL,
0x00000048401c723cULL, 0x040b6e000004181cULL, 0x0000030003487a10ULL, 0x020fe20007ffe0ffULL,
0x0000004a4020723cULL, 0x000b660000041820ULL, 0x0000000148117810ULL, 0x000fc80007ffe0ffULL,
0x0000005c1100720cULL, 0x000fe20003f06070ULL, 0x000000464028723cULL, 0x000f620000041828ULL,
0x0000010048117824ULL, 0x000fc800078e0275ULL, 0x000068006b4a7a24ULL, 0x020fc600078e0211ULL,
0x0000003c2c54723cULL, 0x050b700000041854ULL, 0x0000003e2c50723cULL, 0x040b700000041850ULL,
0x000000382c14723cULL, 0x040b700000041814ULL, 0x0000003a2c18723cULL, 0x040b700000041818ULL,
0x000000342c1c723cULL, 0x040b70000004181cULL, 0x000000362c20723cULL, 0x040b700000041820ULL,
0x000000302c24723cULL, 0x040b700000041824ULL, 0x000000322c28723cULL, 0x000b620000041828ULL,
0x00000c4000008947ULL, 0x000fce0003800000ULL, 0x0000000462137810ULL, 0x040fe20007ffe0ffULL,
0x0000000162327824ULL, 0x060fe200078e0204ULL, 0x00000008622f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000162107824ULL, 0x000fe200078e024aULL, 0x0000001166367217ULL, 0x000fe20007800000ULL,
0x00000001133c7824ULL, 0x040fe200078e0204ULL, 0x0000001062337810ULL, 0x040fe20007ffe0ffULL,
0x00000008132d7824ULL, 0x000fe200078e00ffULL, 0x0000000709327812ULL, 0x000fe200078ef832ULL,
0x000000012f427824ULL, 0x040fe200078e0204ULL, 0x0000001462097810ULL, 0x000fe20007ffe0ffULL,
0x000000082f317824ULL, 0x000fe200078e00ffULL, 0xfffffff82d3c7812ULL, 0x000fe200078ee23cULL,
0x0000000136367824ULL, 0x000fe200078e0a11ULL, 0x0000001c62377810ULL, 0x040fe20007ffe0ffULL,
0x00000001333e7824ULL, 0x000fe200078e0204ULL, 0xfffffff831427812ULL, 0x000fe200078ee242ULL,
0x00000008332d7824ULL, 0x000fe200078e00ffULL, 0x0000000c62317810ULL, 0x000fe20007ffe0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000361300720cULL, 0x000fc40003f46070ULL,
0xfffffff82d3e7812ULL, 0x000fe200078ee23eULL, 0x00000001132c7824ULL, 0x000fe200078e024aULL,
0x0000000810107212ULL, 0x000fe200078efcffULL, 0x00000001093a7824ULL, 0x000fe200078e0204ULL,
0x000000363100720cULL, 0x080fe20003fa6070ULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000640010107a10ULL, 0x000fe40007f1e0ffULL, 0x000000366200720cULL, 0x000fe20003f26070ULL,
0x0000000809357824ULL, 0x000fe200078e00ffULL, 0x000000082c2c7212ULL, 0x000fe200078efcffULL,
0x000000012f307824ULL, 0x000fe200078e024aULL, 0x0000650011117a10ULL, 0x000fe200007fe4ffULL,
0x0000000131407824ULL, 0x000fe200078e0204ULL, 0xfffffff8353a7812ULL, 0x000fe200078ee23aULL,
0x0000000831137824ULL, 0x040fe200078e00ffULL, 0x0000001862357810ULL, 0x000fe20007ffe0ffULL,
0x0000000131127824ULL, 0x000fe200078e024aULL, 0x000064002c2c7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x000000363300720cULL, 0x000fc40003f86070ULL,
0xfffffff813407812ULL, 0x000fe200078ee240ULL, 0x00000001332e7824ULL, 0x000fe200078e024aULL,
0x0000000830307212ULL, 0x000fe200078efcffULL, 0x0000000135347824ULL, 0x000fe200078e0204ULL,
0x000065002d2d7a10ULL, 0x000fe200007fe4ffULL, 0x0000000835337824ULL, 0x000fe200078e00ffULL,
0x0000640030307a10ULL, 0x000fe20007f1e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000362f00720cULL, 0x000fe40003f66070ULL, 0xfffffff833347812ULL, 0x000fe200078ee234ULL,
0x0000001032337824ULL, 0x000fe200078e020dULL, 0x0000650031317a10ULL, 0x000fe200007fe4ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000000812127212ULL, 0x000fc400078efcffULL,
0x000000360900720cULL, 0x040fe20003f06070ULL, 0x0000000109097824ULL, 0x000fe200078e024aULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010337faeULL, 0x0003e2000c901c46ULL, 0x000000082e2e7212ULL, 0x000fe200078efcffULL,
0x0000000137387824ULL, 0x000fe200078e0204ULL, 0x0000650013137a10ULL, 0x000fe400037fe4ffULL,
0x000064002e2e7a10ULL, 0x000fe40007fde0ffULL, 0x000000363500720cULL, 0x040fe20003f26070ULL,
0x0000000135357824ULL, 0x000fe200078e024aULL, 0x000065002f2f7a10ULL, 0x000fc400037fe4ffULL,
0x0000002062397810ULL, 0x040fe20007ffe0ffULL, 0x0000010009107825ULL, 0x002fe200078e00ffULL,
0x00000038623d7810ULL, 0x040fe40007ffe0ffULL, 0x0000003c623f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000837097824ULL, 0x000fe200078e00ffULL, 0x0000000810327212ULL, 0x000fe200078efcffULL,
0x00000001393b7824ULL, 0x040fe400078e0204ULL, 0x0000000839447824ULL, 0x000fe200078e00ffULL,
0x0000640032327a10ULL, 0x000fc40007fde0ffULL, 0xfffffff809387812ULL, 0x000fe200078ee238ULL,
0x000000103c097824ULL, 0x000fe200078e020dULL, 0x0000650011337a10ULL, 0x000fe200037fe4ffULL,
0x0000010035107825ULL, 0x000fe200078e00ffULL, 0xfffffff8443c7812ULL, 0x000fe400078ee23bULL,
0x000000002c097faeULL, 0x0003e2000d101c46ULL, 0x0000001042357824ULL, 0x000fe200078e020dULL,
0x000000363700720cULL, 0x040fe20003f46070ULL, 0x0000000137377824ULL, 0x000fe200078e024aULL,
0x0000000810107212ULL, 0x000fc400078efcffULL, 0x0000000030357faeULL, 0x0005e2000d901c46ULL,
0x000000363900720cULL, 0x040fe20003f66070ULL, 0x0000000139397824ULL, 0x000fe200078e024aULL,
0x0000640010107a10ULL, 0x000fe40007fde0ffULL, 0x00000024623b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001040097824ULL, 0x002fe200078e020dULL, 0x0000650011117a10ULL, 0x000fe200037fe4ffULL,
0x00000100392c7825ULL, 0x000fc600078e00ffULL, 0x0000000012097faeULL, 0x0003e2000e901c46ULL,
0x0000010037307825ULL, 0x004fe200078e00ffULL, 0x000000082c2c7212ULL, 0x000fe400078efcffULL,
0x000000363b00720cULL, 0x040fe20003fa6070ULL, 0x000000013b407824ULL, 0x040fe200078e0204ULL,
0x0000000830377212ULL, 0x000fe200078efcffULL, 0x000000013b307824ULL, 0x040fe400078e024aULL,
0x000000083b357824ULL, 0x000fe200078e00ffULL, 0x0000640037127a10ULL, 0x002fc80007fde0ffULL,
0xfffffff835407812ULL, 0x000fe200078ee240ULL, 0x000000103e357824ULL, 0x000fe200078e020dULL,
0x0000650031137a10ULL, 0x000fe200037fe4ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x000064002c2c7a10ULL, 0x000fe40007fde0ffULL, 0x0000002862377810ULL, 0x000fe20007ffe0ffULL,
0x000000002e357faeULL, 0x0003e2000e101c46ULL, 0x0000000830097212ULL, 0x000fe400078efcffULL,
0x000065002d2d7a10ULL, 0x000fe200037fe4ffULL, 0x00000001373e7824ULL, 0x040fe200078e0204ULL,
0x000000363700720cULL, 0x040fe20003f86070ULL, 0x0000000837397824ULL, 0x000fc400078e00ffULL,
0x0000000137307824ULL, 0x000fe200078e024aULL, 0x0000002c62377810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8393e7812ULL, 0x000fe400078ee23eULL, 0x00006400092e7a10ULL, 0x002fe20007fde0ffULL,
0x000000103a097824ULL, 0x000fe200078e020dULL, 0x0000003062397810ULL, 0x000fe20007ffe0ffULL,
0x0000000137357824ULL, 0x000fe200078e024aULL, 0x00006500312f7a10ULL, 0x000fe200037fe4ffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000000032097faeULL, 0x0003e2000c101c46ULL,
0x000000363700720cULL, 0x000fc40003f06070ULL, 0x00000001373a7824ULL, 0x040fe200078e0204ULL,
0x0000000830307212ULL, 0x080fe200078efcffULL, 0x00000008373b7824ULL, 0x000fe400078e00ffULL,
0x0000000139377824ULL, 0x040fe200078e024aULL, 0x0000640030307a10ULL, 0x000fe20007fde0ffULL,
0x0000000139427824ULL, 0x000fe200078e0204ULL, 0xfffffff83b3a7812ULL, 0x000fe200078ee23aULL,
0x0000010035327825ULL, 0x002fe200078e00ffULL, 0x00000034623b7810ULL, 0x000fe40007ffe0ffULL,
0x0000650031317a10ULL, 0x000fe200037fe4ffULL, 0x0000001034097824ULL, 0x000fe200078e020dULL,
0x0000000832327212ULL, 0x000fe200078efcffULL, 0x0000010037347825ULL, 0x000fc600078e00ffULL,
0x0000000010097faeULL, 0x0003e2000c901c46ULL, 0x0000001038377824ULL, 0x100fe200078e020dULL,
0x000000363900720cULL, 0x0c0fe20003f26070ULL, 0x0000000839397824ULL, 0x000fe400078e00ffULL,
0x000000013d387824ULL, 0x000fe200078e024aULL, 0x0000000012377faeULL, 0x0005e2000d101c46ULL,
0x000000363f00720cULL, 0x000fe40003f46070ULL, 0xfffffff839427812ULL, 0x000fe200078ee242ULL,
0x0000001040397824ULL, 0x100fe200078e020dULL, 0x0000640032107a10ULL, 0x002fe20007fde0ffULL,
0x000000103c097824ULL, 0x000fe200078e020dULL, 0x0000000834327212ULL, 0x000fe200078efcffULL,
0x000000013b347824ULL, 0x000fe200078e024aULL, 0x0000650033117a10ULL, 0x000fe200037fe4ffULL,
0x000000083f3c7824ULL, 0x000fe200078e00ffULL, 0x0000640032327a10ULL, 0x000fe20007fde0ffULL,
0x0000010034127825ULL, 0x004fe200078e00ffULL, 0x000000002c097faeULL, 0x0003e2000d901c46ULL,
0x000000363d00720cULL, 0x000fc40003f66070ULL, 0x0000650035337a10ULL, 0x000fe200037fe4ffULL,
0x000000002e397faeULL, 0x0005e2000e901c46ULL, 0x0000000812347212ULL, 0x000fe200078efcffULL,
0x000000013f377824ULL, 0x000fe200078e0204ULL, 0x000000363b00720cULL, 0x040fe20003fa6070ULL,
0x000000083b367824ULL, 0x000fe200078e00ffULL, 0x0000640034347a10ULL, 0x000fe20007fde0ffULL,
0x000000013f2c7824ULL, 0x002fc600078e024aULL, 0x0000650013357a10ULL, 0x000fe200037fe4ffULL,
0x0000010038127825ULL, 0x000fc800078e00ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000000812127212ULL, 0x000fc600078efcffULL, 0x000000013b097824ULL, 0x100fe200078e0204ULL,
0x0000640012127a10ULL, 0x000fe20007fde0ffULL, 0x000000013d2f7824ULL, 0x044fe200078e0204ULL,
0x000000082c087212ULL, 0x000fe200078efcffULL, 0x000000083d387824ULL, 0x000fe200078e00ffULL,
0xfffffff8362e7812ULL, 0x000fe200078ee209ULL, 0x0000001042397824ULL, 0x000fe200078e020dULL,
0x0000650013137a10ULL, 0x000fe400037fe4ffULL, 0xfffffff838367812ULL, 0x000fe200078ee22fULL,
0x000000103e2f7824ULL, 0x000fe200078e020dULL, 0xfffffff83c387812ULL, 0x000fe200078ee237ULL,
0x000000103a377824ULL, 0x100fe200078e020dULL, 0x0000640008087a10ULL, 0x000fe20007fde0ffULL,
0x000000102e3b7824ULL, 0x100fe200078e020dULL, 0x00000000302f7faeULL, 0x0003e2000e101c46ULL,
0x00000010363d7824ULL, 0x100fe200078e020dULL, 0x000065002d097a10ULL, 0x000fe200037fe4ffULL,
0x00000010380d7824ULL, 0x000fe200078e020dULL, 0x0000000010377faeULL, 0x0003e8000c101c46ULL,
0x0000000032397faeULL, 0x0003e8000c901c46ULL, 0x00000000343b7faeULL, 0x0003e8000e901c46ULL,
0x00000000123d7faeULL, 0x0003e8000d901c46ULL, 0x00000000080d7faeULL, 0x0003e2000d101c46ULL,
0x00000b1000007947ULL, 0x000fea0003800000ULL, 0x00000001626e7824ULL, 0x040fe200078e0204ULL,
0x0000000c62117810ULL, 0x040fe20007ffe0ffULL, 0x0000000162327824ULL, 0x060fe200078e024aULL,
0x00000004622d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000862137810ULL, 0x040fe20007ffe0ffULL,
0x00000001117a7824ULL, 0x000fe200078e0204ULL, 0x00000007096e7812ULL, 0x000fe200078ef86eULL,
0x0000000811337824ULL, 0x000fe200078e00ffULL, 0x0000001062097810ULL, 0x040fe20007ffe0ffULL,
0x000000012d4e7824ULL, 0x040fe200078e0204ULL, 0x00000028626d7810ULL, 0x040fe20007ffe0ffULL,
0x000000082d2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8337a7812ULL, 0x000fe200078ee27aULL,
0x0000000113787824ULL, 0x040fe200078e0204ULL, 0x0000001c62337810ULL, 0x040fe20007ffe0ffULL,
0x0000000813317824ULL, 0x000fe200078e00ffULL, 0xfffffff82f4e7812ULL, 0x000fe200078ee24eULL,
0x00000001097c7824ULL, 0x040fe200078e0204ULL, 0x00000014622f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000809357824ULL, 0x000fe200078e00ffULL, 0xfffffff831787812ULL, 0x000fe200078ee278ULL,
0x00000001332e7824ULL, 0x040fe200078e0204ULL, 0x0000001862317810ULL, 0x040fe20007ffe0ffULL,
0x0000000833397824ULL, 0x000fe200078e00ffULL, 0xfffffff8357c7812ULL, 0x000fe200078ee27cULL,
0x000000012f497824ULL, 0x040fe200078e0204ULL, 0x0000002462357810ULL, 0x040fe20007ffe0ffULL,
0x000000082f107824ULL, 0x000fe200078e00ffULL, 0xfffffff8392e7812ULL, 0x000fe200078ee22eULL,
0x0000000131767824ULL, 0x140fe200078e0204ULL, 0x0000002062717810ULL, 0x000fe20007ffe0ffULL,
0x0000000831377824ULL, 0x000fe200078e00ffULL, 0xfffffff810497812ULL, 0x000fe200078ee249ULL,
0x00000001352c7824ULL, 0x040fe200078e0204ULL, 0x0000002c624d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000835397824ULL, 0x000fe200078e00ffULL, 0xfffffff837767812ULL, 0x000fe200078ee276ULL,
0x000000016d107824ULL, 0x000fc400078e0204ULL, 0x000000086d3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8392c7812ULL, 0x000fe200078ee22cULL, 0x0000000171427824ULL, 0x040fe200078e0204ULL,
0x0000003462397810ULL, 0x040fe20007ffe0ffULL, 0x0000000871377824ULL, 0x000fe200078e00ffULL,
0xfffffff83b107812ULL, 0x000fe200078ee210ULL, 0x000000014d127824ULL, 0x040fe200078e0204ULL,
0x00000038623b7810ULL, 0x040fe20007ffe0ffULL, 0x000000084d3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff837427812ULL, 0x000fe200078ee242ULL, 0x00000001333e7824ULL, 0x000fe200078e024aULL,
0x0000003062377810ULL, 0x000fe20007ffe0ffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0xfffffff83d127812ULL, 0x000fc400078ee212ULL, 0x0000003c623d7810ULL, 0x000fe20007ffe0ffULL,
0x000000012d307824ULL, 0x100fe200078e024aULL, 0x0000000832327212ULL, 0x000fe200078efcffULL,
0x00000001093a7824ULL, 0x100fe400078e024aULL, 0x0000000139477824ULL, 0x040fe200078e024aULL,
0x0000640032327a10ULL, 0x000fe20007f1e0ffULL, 0x0000000139097824ULL, 0x040fe400078e0204ULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x0000650033337a10ULL, 0x000fe200007fe4ffULL,
0x000000013b467824ULL, 0x000fc400078e024aULL, 0x000000013b447824ULL, 0x000fe200078e0204ULL,
0xfffffff839097812ULL, 0x000fe200078ee209ULL, 0x0000000131367824ULL, 0x000fe400078e024aULL,
0x000000083b3b7824ULL, 0x000fe400078e00ffULL, 0x0000010030307825ULL, 0x000fc600078e00ffULL,
0xfffffff83b447812ULL, 0x000fe200078ee244ULL, 0x0000000113347824ULL, 0x100fe200078e024aULL,
0x0000000830307212ULL, 0x000fe200078efcffULL, 0x00000001113c7824ULL, 0x100fe400078e024aULL,
0x000000012f387824ULL, 0x100fe200078e024aULL, 0x0000640030307a10ULL, 0x000fe20007f1e0ffULL,
0x0000000171717824ULL, 0x100fe400078e024aULL, 0x0000000135707824ULL, 0x100fe200078e024aULL,
0x0000650031317a10ULL, 0x000fe200007fe4ffULL, 0x000000016d6d7824ULL, 0x000fc400078e024aULL,
0x000000014d4d7824ULL, 0x100fe400078e024aULL, 0x00000001374c7824ULL, 0x100fe400078e024aULL,
0x000000013d4a7824ULL, 0x040fe400078e024aULL, 0x000000013d407824ULL, 0x040fe400078e0204ULL,
0x000000083d3d7824ULL, 0x000fe400078e00ffULL, 0x0000010034347825ULL, 0x000fc600078e00ffULL,
0xfffffff83d407812ULL, 0x000fe200078ee240ULL, 0x0000001010137824ULL, 0x100fe400078e020dULL,
0x0000001009107824ULL, 0x100fe400078e020dULL, 0x0000001044097824ULL, 0x000fe200078e020dULL,
0x0000000834447212ULL, 0x000fe200078efcffULL, 0x000001003c3c7825ULL, 0x000fc600078e00ffULL,
0x0000640044447a10ULL, 0x000fe20007f1e0ffULL, 0x0000000137117824ULL, 0x040fe400078e0204ULL,
0x0000000837627824ULL, 0x000fe200078e00ffULL, 0x0000650035457a10ULL, 0x000fe200007fe4ffULL,
0x00000010422d7824ULL, 0x000fe200078e020dULL, 0x000000083c427212ULL, 0x080fe200078efcffULL,
0x0000010038387825ULL, 0x000fe200078e00ffULL, 0xfffffff862117812ULL, 0x000fe400078ee211ULL,
0x0000640042427a10ULL, 0x000fe20007f1e0ffULL, 0x000001003a3a7825ULL, 0x000fe200078e00ffULL,
0x00000008383f7212ULL, 0x000fc400078efcffULL, 0x000065003d437a10ULL, 0x000fe200007fe4ffULL,
0x0000010036367825ULL, 0x000fc800078e00ffULL, 0x000000104e4b7824ULL, 0x100fe200078e020dULL,
0x00000008363c7212ULL, 0x000fe200078efcffULL, 0x000000106e6e7824ULL, 0x100fe400078e020dULL,
0x0000001078627824ULL, 0x100fe400078e020dULL, 0x000000107a4f7824ULL, 0x100fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000326e7faeULL, 0x0003e2000b901c46ULL,
0x000000107c4e7824ULL, 0x100fe400078e020dULL, 0x0000001049497824ULL, 0x100fe200078e020dULL,
0x00000000304b7faeULL, 0x0005e2000b901c46ULL, 0x00000010762f7824ULL, 0x000fc400078e020dULL,
0x000000102e2e7824ULL, 0x100fe200078e020dULL, 0x0000000044627faeULL, 0x0007e2000b901c46ULL,
0x000000102c2c7824ULL, 0x100fe400078e020dULL, 0x0000001012127824ULL, 0x100fe200078e020dULL,
0x00000000424f7faeULL, 0x0007e2000b901c46ULL, 0x0000001011117824ULL, 0x000fe400078e020dULL,
0x000001003e347825ULL, 0x000fe200078e00ffULL, 0x000064003f3e7a10ULL, 0x000fc60007f1e0ffULL,
0x00000010400d7824ULL, 0x000fe200078e020dULL, 0x000000083a407212ULL, 0x080fe200078efcffULL,
0x000001004d327825ULL, 0x002fe200078e00ffULL, 0x00006500393f7a10ULL, 0x000fe400007fe4ffULL,
0x0000640040407a10ULL, 0x000fe20007f3e0ffULL, 0x0000010071387825ULL, 0x000fe200078e00ffULL,
0x000064003c3c7a10ULL, 0x000fe40007f1e0ffULL, 0x00000008343a7212ULL, 0x000fe200078efcffULL,
0x0000010047307825ULL, 0x004fe200078e00ffULL, 0x000065003b417a10ULL, 0x000fc40000ffe4ffULL,
0x00006500373d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010070367825ULL, 0x000fe200078e00ffULL,
0x000064003a3a7a10ULL, 0x000fe20007f3e0ffULL, 0x00000000404e7faeULL, 0x0007e2000b901c46ULL,
0x0000000838387212ULL, 0x080fe200078efcffULL, 0x0000010046467825ULL, 0x000fe200078e00ffULL,
0x00006500353b7a10ULL, 0x000fe20000ffe4ffULL, 0x000000003e497faeULL, 0x0007e2000b901c46ULL,
0x0000640038387a10ULL, 0x000fe20007f1e0ffULL, 0x000001006d347825ULL, 0x000fe200078e00ffULL,
0x0000000836367212ULL, 0x080fe200078efcffULL, 0x000000003c2f7faeULL, 0x0007e2000b901c46ULL,
0x00000008324d7212ULL, 0x000fe200078efcffULL, 0x000001004a4a7825ULL, 0x000fe200078e00ffULL,
0x0000650039397a10ULL, 0x000fe200007fe4ffULL, 0x000000003a2e7faeULL, 0x0007e2000b901c46ULL,
0x0000640036367a10ULL, 0x000fc40007f1e0ffULL, 0x000064004d327a10ULL, 0x000fe20007f3e0ffULL,
0x000001004c4c7825ULL, 0x000fe200078e00ffULL, 0x0000000834347212ULL, 0x080fe200078efcffULL,
0x00000000382d7faeULL, 0x0007e2000b901c46ULL, 0x0000650037377a10ULL, 0x000fe400007fe4ffULL,
0x0000640034347a10ULL, 0x000fe40007f1e0ffULL, 0x000000084c4c7212ULL, 0x000fe200078efcffULL,
0x00000000362c7faeULL, 0x0007e2000b901c46ULL, 0x0000650035357a10ULL, 0x000fc400007fe4ffULL,
0x000064004c4c7a10ULL, 0x000fe40007f1e0ffULL, 0x00000008306d7212ULL, 0x080fe200078efcffULL,
0x0000000034137faeULL, 0x0007e2000b901c46ULL, 0x0000000846467212ULL, 0x080fe400078efcffULL,
0x000000084a087212ULL, 0x000fe400078efcffULL, 0x000065004d4d7a10ULL, 0x000fe400007fe4ffULL,
0x0000650033337a10ULL, 0x000fc40000ffe4ffULL, 0x000064006d307a10ULL, 0x000fe40007f1e0ffULL,
0x0000640046467a10ULL, 0x000fe20007f3e0ffULL, 0x0000000032127faeULL, 0x0007e2000b901c46ULL,
0x00006400084a7a10ULL, 0x000fe40007f5e0ffULL, 0x0000650031317a10ULL, 0x000fe200007fe4ffULL,
0x000000004c117faeULL, 0x0007e2000b901c46ULL, 0x0000650047477a10ULL, 0x000fe40000ffe4ffULL,
0x000065004b4b7a10ULL, 0x000fe200017fe4ffULL, 0x0000000030107faeULL, 0x0007e8000b901c46ULL,
0x0000000046097faeULL, 0x0007e8000b901c46ULL, 0x000000004a0d7faeULL, 0x0007e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000100a097824ULL, 0x04afe200078e00ffULL,
0x000000080b087810ULL, 0x000fe20007ffe0ffULL, 0x000000100a3c7824ULL, 0x000fe200078e00ffULL,
0x000030000c0c7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff009087812ULL, 0x000fe400078ee208ULL,
0x0000000a0b097810ULL, 0x000fe20007ffe0ffULL, 0x0000001061107824ULL, 0x100fe400078e020cULL,
0x0000001060347824ULL, 0x100fe200078e020cULL, 0xfffffff03c097812ULL, 0x000fe200078ee209ULL,
0x000000105f307824ULL, 0x100fe400078e020cULL, 0x000000105e387824ULL, 0x000fe400078e020cULL,
0x0000001008087824ULL, 0x000fc400078e00ffULL, 0x000000105d407824ULL, 0x100fe400078e020cULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x000000105b447824ULL, 0x000fe200078e020cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001010783bULL, 0x000fe20000000200ULL,
0x000000106a6a7824ULL, 0x000fc600078e020cULL, 0x00000000082c783bULL, 0x0002a80000000200ULL,
0x000000003434783bULL, 0x000ee80000000200ULL, 0x000000003030783bULL, 0x000f220000000200ULL,
0x0000000c0b087810ULL, 0x042fe40007ffe0ffULL, 0x0000000e0b0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004040783bULL, 0x000fe80000000200ULL,
0x00000000093c783bULL, 0x0004680000000200ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x000000100a097824ULL, 0x004fc400078e00ffULL, 0x000000100a0a7824ULL, 0x000fc600078e00ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0xfffffff00a0d7812ULL, 0x000fe200078ee20bULL,
0x000000102c54723cULL, 0x040b6e0000041854ULL, 0x0000001068107824ULL, 0x120fe200078e020cULL,
0x000000122c50723cULL, 0x040b6a0000041850ULL, 0x000000001010783bULL, 0x020ea60000000200ULL,
0x000000342c14723cULL, 0x048b6e0000041814ULL, 0x0000001008347824ULL, 0x020fe200078e00ffULL,
0x000000362c18723cULL, 0x000b620000041818ULL, 0x0000001069087824ULL, 0x000fc800078e020cULL,
0x000000003434783bULL, 0x020fe60000000200ULL, 0x000000302c1c723cULL, 0x050b62000004181cULL,
0x000000000808783bULL, 0x000fec0000000200ULL, 0x000000105a307824ULL, 0x120fe200078e020cULL,
0x000000322c20723cULL, 0x040b6a0000041820ULL, 0x000000003030783bULL, 0x020fe60000000200ULL,
0x000000382c24723cULL, 0x042b6e0000041824ULL, 0x0000001065387824ULL, 0x120fe200078e020cULL,
0x0000003a2c28723cULL, 0x000b6a0000041828ULL, 0x000000003838783bULL, 0x020fe40000000200ULL,
0x00000010642c7824ULL, 0x100fe200078e020cULL, 0x000000403c54723cULL, 0x040b6a0000041854ULL,
0x000000002c2c783bULL, 0x000e640000000200ULL, 0x0000001063407824ULL, 0x120fe200078e020cULL,
0x000000423c50723cULL, 0x040b6a0000041850ULL, 0x000000004040783bULL, 0x020fe60000000200ULL,
0x000000443c14723cULL, 0x040ff00000041814ULL, 0x000000463c18723cULL, 0x040ff00000041818ULL,
0x000000103c1c723cULL, 0x044b6e000004181cULL, 0x000000100d107824ULL, 0x020fe200078e00ffULL,
0x000000123c20723cULL, 0x040b6a0000041820ULL, 0x000000001010783bULL, 0x020fe60000000200ULL,
0x0000002c3c24723cULL, 0x042b6e0000041824ULL, 0x00000010672c7824ULL, 0x120fe200078e020cULL,
0x0000002e3c28723cULL, 0x000b640000041828ULL, 0x000000006a3c783bULL, 0x020e680000000200ULL,
0x000000002c2c783bULL, 0x000fe40000000200ULL, 0x000000303454723cULL, 0x040bee0000041854ULL,
0x000000100f307824ULL, 0x120fe200078e020cULL, 0x000000323450723cULL, 0x000be20000041850ULL,
0x000000100e0c7824ULL, 0x000fc800078e020cULL, 0x000000003030783bULL, 0x020ea60000000200ULL,
0x00000008341c723cULL, 0x040f62000004181cULL, 0x000000000c0c783bULL, 0x000eee0000000200ULL,
0x000000383414723cULL, 0x040f700000041814ULL, 0x0000003a3418723cULL, 0x040ff00000041818ULL,
0x0000000a3420723cULL, 0x040ff00000041820ULL, 0x0000003c3424723cULL, 0x042ff00000041824ULL,
0x0000003e3428723cULL, 0x000ff00000041828ULL, 0x00000030101c723cULL, 0x064f70000004181cULL,
0x0000002c1054723cULL, 0x040f700000041854ULL, 0x0000002e1050723cULL, 0x040f700000041850ULL,
0x000000401014723cULL, 0x000f640000041814ULL, 0x3db504f31f0b7820ULL, 0x020fc40000410000ULL,
0x3db504f31c1c7820ULL, 0x000fe40000410000ULL, 0x3db504f31d1d7820ULL, 0x000fe40000410000ULL,
0x3db504f31e1e7820ULL, 0x000fe20000410000ULL, 0x000000421018723cULL, 0x000f620000041818ULL,
0x3db504f355317820ULL, 0x000fe40000410000ULL, 0x3db504f357307820ULL, 0x000fca0000410000ULL,
0x000000321020723cULL, 0x040b620000041820ULL, 0x3db504f3502f7820ULL, 0x000fe40000410000ULL,
0x3db504f3512d7820ULL, 0x000fe40000410000ULL, 0x3db504f3522e7820ULL, 0x000fe40000410000ULL,
0x3db504f354337820ULL, 0x020fe20000410000ULL, 0x0000000c1024723cULL, 0x008b620000041824ULL,
0x3db504f356327820ULL, 0x000fe40000410000ULL, 0x3db504f3532c7820ULL, 0x000fc40000410000ULL,
0x3db504f314147820ULL, 0x000fe40000410000ULL, 0x3db504f315157820ULL, 0x000fe20000410000ULL,
0x0000000e1028723cULL, 0x000b620000041828ULL, 0x3db504f316167820ULL, 0x000fe40000410000ULL,
0x3db504f317177820ULL, 0x000fe40000410000ULL, 0x3db504f318187820ULL, 0x000fe40000410000ULL,
0x3db504f319197820ULL, 0x000fc40000410000ULL, 0x3db504f31a1a7820ULL, 0x000fe40000410000ULL,
0x3db504f31b1b7820ULL, 0x000fe40000410000ULL, 0x3db504f320207820ULL, 0x000fe40000410000ULL,
0x3db504f321087820ULL, 0x000fe40000410000ULL, 0x3db504f3220c7820ULL, 0x020fe40000410000ULL,
0x3db504f3230d7820ULL, 0x000fc40000410000ULL, 0x3db504f3241f7820ULL, 0x000fe40000410000ULL,
0x3db504f325357820ULL, 0x000fe40000410000ULL, 0x3db504f3260e7820ULL, 0x000fe40000410000ULL,
0x3db504f3270f7820ULL, 0x000fe40000410000ULL, 0x3db504f328347820ULL, 0x000fe40000410000ULL,
0x3db504f3290a7820ULL, 0x000fc40000410000ULL, 0x3db504f32a107820ULL, 0x000fe40000410000ULL,
0x3db504f32b117820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ffff217224ULL, 0x000fe400078e0020ULL, 0x000000ffff207224ULL, 0x000fe400078e0008ULL,
0x0000000072087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff2a7224ULL, 0x000fe400078e0016ULL,
0x000000ffff297224ULL, 0x000fc400078e0015ULL, 0x000000ffff277224ULL, 0x000fe400078e0018ULL,
0x000000ffff257224ULL, 0x000fe400078e0019ULL, 0x000000ffff237224ULL, 0x000fe400078e001cULL,
0x000000ffff287224ULL, 0x000fe400078e0017ULL, 0x000000ffff267224ULL, 0x000fe400078e001aULL,
0x000000ffff247224ULL, 0x000fc400078e001bULL, 0x000000ffff167224ULL, 0x000fe400078e001eULL,
0x000000ffff2b7224ULL, 0x000fe400078e0014ULL, 0x000000ffff227224ULL, 0x000fe400078e001dULL,
0x000000ffff187224ULL, 0x000fe400078e000aULL, 0x000000ffff157224ULL, 0x000fe400078e000bULL,
0x000000ffff177224ULL, 0x000fc400078e000cULL, 0x000000ffff1e7224ULL, 0x000fe400078e000dULL,
0x000000ffff197224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000fULL,
0x000000ffff1b7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1c7224ULL, 0x000fc400078e0011ULL,
0x00000000000a7805ULL, 0x006fca0000015200ULL, 0x00000400720d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001140dULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x000000020c0c7819ULL, 0x000fc8000000120dULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400720d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004041d7824ULL, 0x000fe200078e00ffULL,
0x0000006f0300720cULL, 0x000fc80003f06070ULL, 0xfffffff01d097812ULL, 0x000fca00078ec0ffULL,
0x0000008002147824ULL, 0x000fca00078e0209ULL, 0x01b4000014087984ULL, 0x0002a20000000c00ULL,
0x000014e000008947ULL, 0x000fea0003800000ULL, 0x00005a00000e7b06ULL, 0x000ee20000209000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x0000007404037211ULL, 0x000fe400078ff0ffULL,
0x0000000766367217ULL, 0x000fe40007800000ULL, 0x00005a00ff007a0cULL, 0x000fc60003f85070ULL,
0x0000000136367824ULL, 0x000fe200078e0a07ULL, 0x0000000e000e7308ULL, 0x008ee40000001000ULL,
0x0ffffffe0e0f7810ULL, 0x008fcc0007ffe0ffULL, 0x0000000f000d7305ULL, 0x000724000021f000ULL,
0x00005a00ff0f7a12ULL, 0x008fe200078e33ffULL, 0x000000ffff117224ULL, 0x010fc800078e0a0dULL,
0x00005a0011117a24ULL, 0x000fc800078e02ffULL, 0x000000110d107227ULL, 0x000fe200078e000cULL,
0x00000008030d7810ULL, 0x000fca0007ffe0ffULL, 0x00000003100c7227ULL, 0x000fc800078e00ffULL,
0x0000000d100e7227ULL, 0x000fc800078e00ffULL, 0x000000ffff107224ULL, 0x000fe400078e0a0cULL,
0x000000ffff127224ULL, 0x000fe400078e0a0eULL, 0x00005a0010037a24ULL, 0x000fe400078e0203ULL,
0x00005a00120d7a24ULL, 0x000fc600078e020dULL, 0x00005a0003007a0cULL, 0x000fe40003f06070ULL,
0x00005a000d007a0cULL, 0x000fd60003f46070ULL, 0x80005a0003030a10ULL, 0x000fe40007ffe0ffULL,
0x80005a000d0d2a10ULL, 0x000fe40007ffe0ffULL, 0x00005a0003007a0cULL, 0x000fe20003f26070ULL,
0x0000000204037824ULL, 0x000fe200078e00ffULL, 0x00005a000d007a0cULL, 0x000fe40003f66070ULL,
0x000000010c0c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000603037812ULL, 0x000fc400078ec0ffULL,
0x000000010e0e2810ULL, 0x000fe40007ffe0ffULL, 0x0000001003397812ULL, 0x040fe200078efcffULL,
0x00000001060d7824ULL, 0x000fe400078e0203ULL, 0x000000010c0c1810ULL, 0x000fe20007ffe0ffULL,
0x0000000103077824ULL, 0x000fe200078e0200ULL, 0x000000010e0e3810ULL, 0x000fe20007ffe0ffULL,
0x000000010d107824ULL, 0x100fe200078e0a36ULL, 0x0000000c0f0c7207ULL, 0x040fe20006000000ULL,
0x00000001063d7824ULL, 0x000fe200078e0239ULL, 0x0000000e0f127207ULL, 0x000fe20006000000ULL,
0x00000001070e7824ULL, 0x000fe200078e0a36ULL, 0x0000000c05537217ULL, 0x000fc40003800000ULL,
0x0000001005107217ULL, 0x000fe40003800000ULL, 0x000000360700720cULL, 0x000fe20003f06070ULL,
0x000000536c537224ULL, 0x000fe200078e02ffULL, 0x0000000e050e7217ULL, 0x000fe40003800000ULL,
0x000000360d00720cULL, 0x000fe40003f26070ULL, 0x00000004ff107819ULL, 0x000fe40000011610ULL,
0x0000001205517217ULL, 0x000fc40003800000ULL, 0x000000ff0e3a7207ULL, 0x000fe20000000000ULL,
0x000000013d3e7824ULL, 0x000fe200078e0a36ULL, 0x000000ff10107207ULL, 0x000fe20000800000ULL,
0x000000516c517224ULL, 0x000fe200078e02ffULL, 0x000000533a117211ULL, 0x000fe400078fe0ffULL,
0x0000003e053f7217ULL, 0x000fe20003800000ULL, 0x0000000153137824ULL, 0x000fe200078e0210ULL,
0x000000363d00720cULL, 0x000fe20003f26070ULL, 0x00000001100f7824ULL, 0x000fe200078e0251ULL,
0x000000513a0d7211ULL, 0x000fe200078fe0ffULL, 0x0000000211107825ULL, 0x000fe200078e0058ULL,
0x00000004ff3f7819ULL, 0x000fc6000001163fULL, 0x0000000213127825ULL, 0x000fe200078e0058ULL,
0x0000000610387981ULL, 0x000726000c1e9500ULL, 0x0000000139417824ULL, 0x000fe200078e0200ULL,
0x0000000612377981ULL, 0x000322000c1e9500ULL, 0x000000020d0c7825ULL, 0x000fc800078e0058ULL,
0x000000020f0e7825ULL, 0x000fe200078e0058ULL, 0x000000ff3f107207ULL, 0x008fe20000800000ULL,
0x000000060c3c7981ULL, 0x0046a2000c1e9500ULL, 0x00000020033f7812ULL, 0x000fe200078efcffULL,
0x00000001413e7824ULL, 0x040fe200078e0a36ULL, 0x000000364100720cULL, 0x000fe20003f06070ULL,
0x000000060e3b7981ULL, 0x0002a4000c1e9500ULL, 0x0000000106477824ULL, 0x000fe400078e023fULL,
0x0000000153117824ULL, 0x000fc400078e0210ULL, 0x0000000147427824ULL, 0x000fe400078e0a36ULL,
0x00000002110c7825ULL, 0x008fc600078e0058ULL, 0x0000004205427217ULL, 0x000fe20003800000ULL,
0x000000013f437824ULL, 0x000fe200078e0200ULL, 0x0000003e053d7217ULL, 0x000fe40003800000ULL,
0x000000364700720cULL, 0x000fe20003f26070ULL, 0x000000060c3e7981ULL, 0x0006a2000c1e9500ULL,
0x00000004ff427819ULL, 0x000fe40000011642ULL, 0x000000ff3d3d7207ULL, 0x000fe40000000000ULL,
0x000000ff42447207ULL, 0x000fc40000800000ULL, 0x0000003003477812ULL, 0x000fe200078efcffULL,
0x00000001430c7824ULL, 0x008fe200078e0a36ULL, 0x000000533d0f7211ULL, 0x042fe200078fe0ffULL,
0x0000000110117824ULL, 0x000fe200078e0251ULL, 0x000000513d137211ULL, 0x000fe200078fe0ffULL,
0x00000001530d7824ULL, 0x000fe200078e0244ULL, 0x000000364300720cULL, 0x000fe40003f06070ULL,
0x0000000c050c7217ULL, 0x000fe20003800000ULL, 0x0000000106557824ULL, 0x000fe400078e0247ULL,
0x000000020f0e7825ULL, 0x000fe200078e0058ULL, 0x000000ff0c4a7207ULL, 0x000fc60000000000ULL,
0x0000000211107825ULL, 0x100fe200078e0058ULL, 0x000000060e457981ULL, 0x0002e6000c1e9500ULL,
0x0000000213127825ULL, 0x100fe200078e0058ULL, 0x0000000610407981ULL, 0x0002e6000c1e9500ULL,
0x000000020d0c7825ULL, 0x000fe200078e0058ULL, 0x0000000612497981ULL, 0x0002e6000c1e9500ULL,
0x0000000155467824ULL, 0x000fe200078e0a36ULL, 0x000000060c427981ULL, 0x0002e2000c1e9500ULL,
0x00000001474d7824ULL, 0x000fe200078e0200ULL, 0x000000534a0f7211ULL, 0x002fe200078fe0ffULL,
0x0000000144117824ULL, 0x000fe200078e0251ULL, 0x0000004605467217ULL, 0x000fc40003800000ULL,
0x000000514a137211ULL, 0x000fe200078fe0ffULL, 0x000000014d0c7824ULL, 0x000fe200078e0a36ULL,
0x000000365500720cULL, 0x080fe20003f26070ULL, 0x000000020f0e7825ULL, 0x000fe200078e0058ULL,
0x00000004ff467819ULL, 0x000fe40000011646ULL, 0x000000364d00720cULL, 0x000fe20003f06070ULL,
0x0000000211107825ULL, 0x100fe200078e0058ULL, 0x0000000c050c7217ULL, 0x000fe20003800000ULL,
0x000000060e4b7981ULL, 0x0002e4000c1e9500ULL, 0x0000000213127825ULL, 0x000fe200078e0058ULL,
0x000000ff46467207ULL, 0x000fe20000800000ULL, 0x0000000610447981ULL, 0x0002e2000c1e9500ULL,
0x000000ff0c4c7207ULL, 0x000fc60000000000ULL, 0x00000006124f7981ULL, 0x0002e2000c1e9500ULL,
0x00000001530d7824ULL, 0x000fe200078e0246ULL, 0x000000534c0f7211ULL, 0x002fc600078fe0ffULL,
0x000000020d0c7825ULL, 0x000fc800078e0058ULL, 0x000000020f0e7825ULL, 0x000fe400078e0058ULL,
0x000000060c0c7981ULL, 0x0002e2000c1e9500ULL, 0x000000514c117211ULL, 0x000fc600078fe0ffULL,
0x000000060e0f7981ULL, 0x0002e2000c1e9500ULL, 0x0000000146137824ULL, 0x000fe400078e0251ULL,
0x0000000211107825ULL, 0x000fc800078e0058ULL, 0x0000000213127825ULL, 0x000fe400078e0058ULL,
0x0000000610107981ULL, 0x0002e8000c1e9500ULL, 0x0000000612137981ULL, 0x0002e2000c1e9500ULL,
0xfffffff03a3a7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff467424ULL, 0x000fc800078e00ffULL,
0x00000001363a7824ULL, 0x000fe200078e023aULL, 0xfffffff03d127812ULL, 0x002fc600078ec0ffULL,
0x00000001073d7824ULL, 0x000fe200078e0a3aULL, 0x0000000103517812ULL, 0x040fe400078efcffULL,
0x0000000803537812ULL, 0x040fe200078efcffULL, 0x0000000136647824ULL, 0x000fe200078e0212ULL,
0x00000009030d7812ULL, 0x000fe400078efcffULL, 0x0000003d46127219ULL, 0x000fe200000006ffULL,
0x0000000151677824ULL, 0x100fe400078e0200ULL, 0x0000000153697824ULL, 0x000fc400078e0200ULL,
0x000000010d6d7824ULL, 0x000fe200078e0200ULL, 0xfffffff04a507812ULL, 0x000fe200078ec0ffULL,
0x00000001674a7824ULL, 0x100fe200078e0a3aULL, 0xfffffff04c5a7812ULL, 0x000fe200078ec0ffULL,
0x00000001694c7824ULL, 0x100fe400078e0a3aULL, 0x000000016d4e7824ULL, 0x000fe200078e0a3aULL,
0x0000001803577812ULL, 0x000fe400078efcffULL, 0x0000004a463a7219ULL, 0x040fe400000006ffULL,
0x0000004c463d7219ULL, 0x000fc400000006ffULL, 0x0000004e464a7219ULL, 0x040fe200000006ffULL,
0x0000000157777824ULL, 0x000fe400078e0200ULL, 0x00000001415e7824ULL, 0x100fe400078e0a64ULL,
0x0000000177627824ULL, 0x000fe200078e0a64ULL, 0x0000001103557812ULL, 0x040fe400078efcffULL,
0x00000019035b7812ULL, 0x000fe400078efcffULL, 0x0000005e465e7219ULL, 0x000fc400000006ffULL,
0x0000006246627219ULL, 0x000fe200000006ffULL, 0x0000000155717824ULL, 0x100fe400078e0200ULL,
0x000000015b797824ULL, 0x000fe400078e0200ULL, 0x0000000136507824ULL, 0x000fe400078e0250ULL,
0x0000000171607824ULL, 0x100fe400078e0a64ULL, 0x0000000179647824ULL, 0x000fe400078e0a64ULL,
0x0000000143687824ULL, 0x000fe200078e0a50ULL, 0x00000021035d7812ULL, 0x000fc400078efcffULL,
0x00000028035f7812ULL, 0x040fe400078efcffULL, 0x0000002903117812ULL, 0x000fe400078efcffULL,
0x0000006046607219ULL, 0x040fe400000006ffULL, 0x0000006446647219ULL, 0x040fe400000006ffULL,
0x0000006846687219ULL, 0x000fe200000006ffULL, 0x000000015d0e7824ULL, 0x100fe400078e0200ULL,
0x000000015f7d7824ULL, 0x000fc400078e0200ULL, 0x00000001117b7824ULL, 0x000fe400078e0200ULL,
0x00000001365a7824ULL, 0x000fe400078e025aULL, 0x000000010e707824ULL, 0x100fe400078e0a50ULL,
0x000000017d6e7824ULL, 0x100fe400078e0a50ULL, 0x000000017b6a7824ULL, 0x000fe400078e0a50ULL,
0x000000014d567824ULL, 0x000fe200078e0a5aULL, 0x0000003103617812ULL, 0x000fc400078efcffULL,
0x0000003803637812ULL, 0x040fe400078efcffULL, 0x0000003903657812ULL, 0x000fe400078efcffULL,
0x0000007046707219ULL, 0x040fe400000006ffULL, 0x0000006e466e7219ULL, 0x040fe400000006ffULL,
0x0000006a466a7219ULL, 0x040fe400000006ffULL, 0x0000005646567219ULL, 0x000fe200000006ffULL,
0x00000001614c7824ULL, 0x000fc400078e0200ULL, 0x00000001634e7824ULL, 0x100fe400078e0200ULL,
0x0000000165507824ULL, 0x000fe400078e0200ULL, 0x000000014c527824ULL, 0x100fe400078e0a5aULL,
0x000000014e547824ULL, 0x100fe400078e0a5aULL, 0x00000001505a7824ULL, 0x000fe200078e0a5aULL,
0x0000005246527219ULL, 0x040fe400000006ffULL, 0x0000005446547219ULL, 0x000fc400000006ffULL,
0x0000005a465a7219ULL, 0x000fe400000006ffULL, 0x0000541038377816ULL, 0x010fc80000000037ULL,
0x0000003712ff7212ULL, 0x000fc8000780c0ffULL, 0x000000360700720cULL, 0x080fe400007a1470ULL,
0x000054103c3b7816ULL, 0x004fe4000000003bULL, 0x000000360300720cULL, 0x000fe40002fa1070ULL,
0x0000003b12ff7212ULL, 0x080fe4000784c0ffULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0x0000003b3dff7212ULL, 0x000fc400078cc0ffULL, 0x0000003b4aff7212ULL, 0x000fe400078ac0ffULL,
0x000000360700720cULL, 0x080fe40001741470ULL, 0x000000366900720cULL, 0x080fe400037c1470ULL,
0x000000366d00720cULL, 0x080fe40002fa1470ULL, 0x000000360300720cULL, 0x080fe40001741070ULL,
0x000000365300720cULL, 0x000fc400037c1070ULL, 0x000000360d00720cULL, 0x000fe40002fa1070ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40002800000ULL, 0x000000373aff7212ULL, 0x080fe4000782c0ffULL,
0x000000373dff7212ULL, 0x000fc4000786c0ffULL, 0x000000374aff7212ULL, 0x000fe4000788c0ffULL,
0x0000003b3aff7212ULL, 0x000fe4000780c0ffULL, 0x0000541045457816ULL, 0x008fc8000000003eULL,
0x000000455eff7212ULL, 0x000fe4000784c0ffULL, 0x0000541049497816ULL, 0x000fc80000000040ULL,
0x000000495eff7212ULL, 0x080fe400078cc0ffULL, 0x0000004962ff7212ULL, 0x000fe400078ac0ffULL,
0x000000366700720cULL, 0x0c0fe40000f21470ULL, 0x000000366700720cULL, 0x080fe40000701470ULL,
0x000000366900720cULL, 0x080fe40001f61470ULL, 0x000000366d00720cULL, 0x000fc40002781470ULL,
0x000000364100720cULL, 0x0c0fe40001741470ULL, 0x000000364100720cULL, 0x080fe400037c1470ULL,
0x000000367700720cULL, 0x080fe40002fa1470ULL, 0x000000365100720cULL, 0x0c0fe40000f21070ULL,
0x000000365100720cULL, 0x080fe40000701070ULL, 0x000000365300720cULL, 0x000fc40001f61070ULL,
0x000000360d00720cULL, 0x080fe40002781070ULL, 0x000000363900720cULL, 0x0c0fe40001741070ULL,
0x000000363900720cULL, 0x080fe400037c1070ULL, 0x000000365700720cULL, 0x000fe40002fa1070ULL,
0x000054104b4b7816ULL, 0x000fe40000000042ULL, 0x000054104f4f7816ULL, 0x000fc40000000044ULL,
0xff80000031317808ULL, 0x000fe40000800000ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0xff8000002f2f7808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fc40003000000ULL,
0xff80000026267808ULL, 0x000fe40002800000ULL, 0x0000004560ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004562ff7212ULL, 0x080fe4000780c0ffULL, 0x0000004564ff7212ULL, 0x000fe4000786c0ffULL,
0x0000004960ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004964ff7212ULL, 0x000fc4000784c0ffULL,
0x0000004b68ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004f68ff7212ULL, 0x000fe400078ac0ffULL,
0x000000367100720cULL, 0x0c0fe40000f21470ULL, 0x000000367100720cULL, 0x080fe40002781470ULL,
0x000000367700720cULL, 0x080fe40000701470ULL, 0x000000367900720cULL, 0x000fc40001f61470ULL,
0x000000367900720cULL, 0x080fe40001741470ULL, 0x000000364300720cULL, 0x0c0fe400037c1470ULL,
0x000000364300720cULL, 0x080fe40002fa1470ULL, 0x000000365500720cULL, 0x0c0fe40000f21070ULL,
0x000000365500720cULL, 0x080fe40002781070ULL, 0x000000365700720cULL, 0x000fc40000701070ULL,
0x000000365b00720cULL, 0x0c0fe40001f61070ULL, 0x000000365b00720cULL, 0x080fe40001741070ULL,
0x000000363f00720cULL, 0x0c0fe400037c1070ULL, 0x000000363f00720cULL, 0x000fe40002fa1070ULL,
0x000054100f0f7816ULL, 0x000fe4000000000cULL, 0xff80000029297808ULL, 0x000fc40000800000ULL,
0xff80000028287808ULL, 0x000fe40002000000ULL, 0xff80000027277808ULL, 0x000fe40000000000ULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40001000000ULL,
0xff80000023237808ULL, 0x000fe40003000000ULL, 0xff80000016167808ULL, 0x000fc40002800000ULL,
0x0000004b70ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004b6eff7212ULL, 0x080fe4000788c0ffULL,
0x0000004b6aff7212ULL, 0x000fe4000780c0ffULL, 0x0000004f70ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004f6eff7212ULL, 0x080fe4000784c0ffULL, 0x0000004f6aff7212ULL, 0x000fc400078cc0ffULL,
0x0000000f56ff7212ULL, 0x000fe400078ac0ffULL, 0x000000360e00720cULL, 0x0c0fe40000f21470ULL,
0x000000360e00720cULL, 0x080fe40001f61470ULL, 0x000000367d00720cULL, 0x0c0fe40002781470ULL,
0x000000367d00720cULL, 0x080fe40001741470ULL, 0x000000367b00720cULL, 0x000fc40000701470ULL,
0x000000367b00720cULL, 0x080fe400037c1470ULL, 0x000000364d00720cULL, 0x080fe40002fa1470ULL,
0x000000365d00720cULL, 0x0c0fe40000f21070ULL, 0x000000365d00720cULL, 0x080fe40001f61070ULL,
0x000000365f00720cULL, 0x0c0fe40002781070ULL, 0x000000365f00720cULL, 0x000fc40001741070ULL,
0x000000361100720cULL, 0x0c0fe40000701070ULL, 0x000000361100720cULL, 0x080fe400037c1070ULL,
0x000000364700720cULL, 0x000fe40002fa1070ULL, 0x0000541010137816ULL, 0x000fe40000000013ULL,
0xff80000022227808ULL, 0x000fe40000800000ULL, 0xff80000015157808ULL, 0x000fc40001800000ULL,
0xff80000021217808ULL, 0x000fe40002000000ULL, 0xff80000017177808ULL, 0x000fe40001000000ULL,
0xff80000020207808ULL, 0x000fe40000000000ULL, 0xff8000001e1e7808ULL, 0x000fe40003000000ULL,
0xff8000001f1f7808ULL, 0x000fe40002800000ULL, 0x0000000f52ff7212ULL, 0x000fc4000782c0ffULL,
0x0000000f54ff7212ULL, 0x080fe4000786c0ffULL, 0x0000000f5aff7212ULL, 0x000fe4000788c0ffULL,
0x0000001356ff7212ULL, 0x080fe4000784c0ffULL, 0x0000001352ff7212ULL, 0x080fe4000780c0ffULL,
0x0000001354ff7212ULL, 0x080fe400078cc0ffULL, 0x000000135aff7212ULL, 0x000fc400078ac0ffULL,
0x000000364d00720cULL, 0x080fe40001741470ULL, 0x000000364c00720cULL, 0x0c0fe40000f21470ULL,
0x000000364c00720cULL, 0x080fe40000701470ULL, 0x000000364e00720cULL, 0x0c0fe40001f61470ULL,
0x000000364e00720cULL, 0x080fe400037c1470ULL, 0x000000365000720cULL, 0x000fc40002781470ULL,
0x000000365000720cULL, 0x080fe40002fa1470ULL, 0x000000364700720cULL, 0x080fe40001741070ULL,
0x000000366100720cULL, 0x0c0fe40000f21070ULL, 0x000000366100720cULL, 0x080fe40000701070ULL,
0x000000366300720cULL, 0x0c0fe40001f61070ULL, 0x000000366300720cULL, 0x000fc400037c1070ULL,
0x000000366500720cULL, 0x0c0fe40002781070ULL, 0x000000366500720cULL, 0x000fe40002fa1070ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff80000034347808ULL, 0x000fe40001800000ULL,
0xff80000018187808ULL, 0x000fe40002000000ULL, 0xff80000019197808ULL, 0x000fc40001000000ULL,
0xff8000001a1a7808ULL, 0x000fe40000000000ULL, 0xff8000001b1b7808ULL, 0x000fe40003000000ULL,
0xff8000001c1c7808ULL, 0x000fc40002800000ULL, 0x000000330800720bULL, 0x004fe40003f1e000ULL,
0x000000320900720bULL, 0x000fe40003f3e000ULL, 0x0000000833087208ULL, 0x000fe40004000000ULL,
0x0000000932097208ULL, 0x000fc40004800000ULL, 0x000000310800720bULL, 0x000fe40003f1e000ULL,
0x000000300900720bULL, 0x000fe40003f3e000ULL, 0x0000000831087208ULL, 0x000fe40004000000ULL,
0x0000000930097208ULL, 0x000fe40004800000ULL, 0x0000002f0800720bULL, 0x000fe40003f1e000ULL,
0x0000002e0900720bULL, 0x000fc40003f3e000ULL, 0x000000082f087208ULL, 0x000fe40004000000ULL,
0x000000092e097208ULL, 0x000fe40004800000ULL, 0x0000002d0800720bULL, 0x000fe40003f1e000ULL,
0x0000002c0900720bULL, 0x000fe40003f3e000ULL, 0x000000082d087208ULL, 0x000fe40004000000ULL,
0x000000092c097208ULL, 0x000fc40004800000ULL, 0x0000002b0800720bULL, 0x000fe40003f1e000ULL,
0x0000002a0900720bULL, 0x000fe40003f3e000ULL, 0x000000082b087208ULL, 0x000fe40004000000ULL,
0x000000092a097208ULL, 0x000fe40004800000ULL, 0x000000290800720bULL, 0x000fe40003f1e000ULL,
0x000000280900720bULL, 0x000fc40003f3e000ULL, 0x0000000829087208ULL, 0x000fe40004000000ULL,
0x0000000928097208ULL, 0x000fe40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x000000260900720bULL, 0x000fe40003f3e000ULL, 0x0000000827087208ULL, 0x000fe40004000000ULL,
0x0000000926097208ULL, 0x000fc40004800000ULL, 0x000000250800720bULL, 0x000fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x0000000825087208ULL, 0x000fe40004000000ULL,
0x0000000924097208ULL, 0x000fe40004800000ULL, 0x000000230800720bULL, 0x000fe40003f1e000ULL,
0x000000160900720bULL, 0x000fc40003f3e000ULL, 0x0000000823037208ULL, 0x000fe40004000000ULL,
0x0000000916087208ULL, 0x000fe40004800000ULL, 0x000000220300720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x00000003220c7208ULL, 0x000fe40004000000ULL,
0x0000000815087208ULL, 0x000fc40004800000ULL, 0x000000210c00720bULL, 0x000fe40003f1e000ULL,
0x000000170800720bULL, 0x000fe40003f3e000ULL, 0x0000000c21037208ULL, 0x000fe40004000000ULL,
0x0000000817077208ULL, 0x000fe40004800000ULL, 0x000000200300720bULL, 0x000fe40003f1e000ULL,
0x0000001e0700720bULL, 0x000fc40003f3e000ULL, 0x0000000320087208ULL, 0x000fe40004000000ULL,
0x000000071e0c7208ULL, 0x000fe40004800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x000000190c00720bULL, 0x000fe40003f3e000ULL, 0x000000081f087208ULL, 0x000fe40004000000ULL,
0x0000000c19037208ULL, 0x000fc40004800000ULL, 0x000000350800720bULL, 0x000fe40003f1e000ULL,
0x0000001a0300720bULL, 0x000fe40003f3e000ULL, 0x0000000835077208ULL, 0x000fe40004000000ULL,
0x000000031a087208ULL, 0x000fe40004800000ULL, 0x000000340700720bULL, 0x000fe40003f1e000ULL,
0x0000001b0800720bULL, 0x000fc40003f3e000ULL, 0x0000000734077208ULL, 0x000fe40004000000ULL,
0x000000081b037208ULL, 0x000fe40004800000ULL, 0x000000180700720bULL, 0x000fe40003f1e000ULL,
0x0000001c0300720bULL, 0x000fe40003f3e000ULL, 0x0000000718077208ULL, 0x000fe40004000000ULL,
0x000000031c0f7208ULL, 0x000fe20004800000ULL, 0x000016f27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0007037f89ULL, 0x0004e400000e0000ULL, 0x000000030700720bULL, 0x008fc80003f1e000ULL,
0x0000000703107208ULL, 0x000fe20004000000ULL, 0x000017227f007947ULL, 0x000fea000b800000ULL,
0x0c401f000f037f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b087f89ULL, 0x000e6200000e0000ULL, 0x000000030f00720bULL, 0x008fc40003f1e000ULL,
0x000000090a00720bULL, 0x010fe40003f3e000ULL, 0x0000000f03077208ULL, 0x006fe40004000000ULL,
0x0000000a090c7208ULL, 0x000fe40004800000ULL, 0x0c201f0010097f89ULL, 0x000e6200000e0000ULL,
0x000000080b00720bULL, 0x000fc60003f1e000ULL, 0x0c201f00070e7f89ULL, 0x000ea200000e0000ULL,
0x0000000b08037208ULL, 0x000fc60004000000ULL, 0x0c201f000c0d7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0003367f89ULL, 0x0002e400000e0000ULL, 0x000000091000720bULL, 0x002fe40003f1e000ULL,
0x0000000e0700720bULL, 0x004fe40003f3e000ULL, 0x0000001009087208ULL, 0x000fc40004000000ULL,
0x0000000d0c00720bULL, 0x008fe40003f5e000ULL, 0x000000070e097208ULL, 0x000fe40004800000ULL,
0x0000000c0d0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b08387820ULL, 0x000fe20000410000ULL,
0x3f80000000047882ULL, 0x000fe20000000000ULL, 0x0000000304ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010838ULL, 0x000000360300720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b27077823ULL, 0x002fc40000010838ULL, 0x00000033000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010838ULL,
0x0000000700337308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b2b2b7823ULL, 0x000fc40000010838ULL, 0x3fb8aa3b21217823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010838ULL, 0x0000003100317308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1f077823ULL, 0x102fe40000010838ULL, 0x3fb8aa3b091f7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b23277823ULL, 0x000fe40000010838ULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001081fULL,
0x0000002f000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x000fc4000001081fULL,
0x3fb8aa3b32327823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001081fULL, 0x0000002d002d7308ULL, 0x000e620000000800ULL,
0x0000000c310c723eULL, 0x004fe200000010ffULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b26267823ULL, 0x000fe4000001081fULL, 0x3fb8aa3b22227823ULL, 0x000fc40000010838ULL,
0x00000032000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b15157823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b17177823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe2000001081fULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x0000000e2d0e723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b18187823ULL, 0x000fc40000010838ULL,
0x3fb8aa3b353a7823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b340b7823ULL, 0x000fe40000010838ULL,
0x0000002e000f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fce000001081fULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x0000000d300d723eULL, 0x004fce00000010ffULL,
0x0000002000427308ULL, 0x0005f00000000800ULL, 0x00000025003e7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b24207823ULL, 0x004fe2000001081fULL, 0x0000000f2c0f723eULL, 0x002fe200000010ffULL,
0x00000004ff247e24ULL, 0x000fe2000f8e00ffULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x3f8000002424783eULL, 0x000fe200000010ffULL, 0x00000021002f7308ULL, 0x000fe80000000800ULL,
0x000000ffff257224ULL, 0x008fc400078e0024ULL, 0x000000ffff327224ULL, 0x000fe400078e0024ULL,
0x0000002b002b7308ULL, 0x000fe60000000800ULL, 0x000000240c10723cULL, 0x000f6a00000418ffULL,
0x00000029003c7308ULL, 0x0003f00000000800ULL, 0x0000002a00217308ULL, 0x000fe20000000800ULL,
0x00000002ff297819ULL, 0x002fca0000011604ULL, 0x00000008292c7824ULL, 0x040fe400078e00ffULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x0000000829307824ULL, 0x040fe400078e00ffULL,
0x0000000829347824ULL, 0x040fe400078e00ffULL, 0x0000000829387824ULL, 0x000fc600078e00ffULL,
0x0000002600237308ULL, 0x0005f00000000800ULL, 0x00000020002e7308ULL, 0x0007220000000800ULL,
0x000000212821723eULL, 0x002fe200000010ffULL, 0x3fb8aa3b1a267823ULL, 0x104fe2000001081fULL,
0x0000002f421a723eULL, 0x000fe200000010ffULL, 0x3fb8aa3b1b287823ULL, 0x000fc8000001081fULL,
0x0000002200407308ULL, 0x0003e20000000800ULL, 0x0000002b3c20723eULL, 0x008fe400000010ffULL,
0x000000232e23723eULL, 0x010fca00000010ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000333e22723eULL, 0x002fe200000010ffULL, 0x000000ffff337224ULL, 0x000fcc00078e0024ULL,
0x000000242010723cULL, 0x020b620000041810ULL, 0x0000001600167308ULL, 0x000fec0000000800ULL,
0x3fb8aa3b19257823ULL, 0x020fe2000001081fULL, 0x0000000129197810ULL, 0x040fe20007ffe0ffULL,
0x0000001500157308ULL, 0x000e620000000800ULL, 0x00000008291f7824ULL, 0x000fc400078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fca00078ee219ULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ea20000000800ULL, 0x000000161519723eULL, 0x002fe400000010ffULL,
0x0000000329167810ULL, 0x000fc40007ffe0ffULL, 0x0000000229157810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81f2e7812ULL, 0x000fe200078ee216ULL, 0x00000018002a7308ULL, 0x0003e20000000800ULL,
0x0000000829167824ULL, 0x040fe200078e00ffULL, 0xffffffff291f7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff816167812ULL, 0x000fe400078ee229ULL, 0x000000171e1b723eULL, 0x004fe200000010ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x000000274018723eULL, 0x002fe200000010ffULL,
0x00000008291e7824ULL, 0x040fe200078e00ffULL, 0x0000000429177810ULL, 0x040fe40007ffe0ffULL,
0x0000000829277810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x000000321810723cULL, 0x000b620000041810ULL,
0xfffffff830307812ULL, 0x000fe200078ee217ULL, 0x00000008273c7824ULL, 0x000fe200078e00ffULL,
0x0000000529157810ULL, 0x000fc40007ffe0ffULL, 0x0000000629177810ULL, 0x040fe40007ffe0ffULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x0000000829327824ULL, 0x020fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe400078ee217ULL, 0xfffffff838387812ULL, 0x000fe400078ee21fULL,
0xfffffff832327812ULL, 0x000fe400078ee215ULL, 0x0000003a003a7308ULL, 0x000ea20000000800ULL,
0x000000252629723eULL, 0x002fe200000010ffULL, 0x000000ffff257224ULL, 0x000fe200078e0024ULL,
0x0000000c1d267812ULL, 0x000fc400078ec0ffULL, 0xfffffff83c3c7812ULL, 0x000fc600078ee227ULL,
0x0000000b000b7308ULL, 0x000e700000000800ULL, 0x00000028002b7308ULL, 0x0005f00000000800ULL,
0x0000001c001c7308ULL, 0x000ee20000000800ULL, 0x000000073a28723eULL, 0x004fc400000010ffULL,
0x0000000b2a2a723eULL, 0x002fe400000010ffULL, 0x0001100002077811ULL, 0x000fca00078e58ffULL,
0x00000010160b7824ULL, 0x100fe400078e0207ULL, 0x000000102c157824ULL, 0x100fe400078e0207ULL,
0x000000101e167824ULL, 0x100fe200078e0207ULL, 0x0000002b1c2b723eULL, 0x008fe200000010ffULL,
0x000000102e177824ULL, 0x100fe400078e0207ULL, 0x00000010301c7824ULL, 0x000fe400078e0207ULL,
0x00000001260b7824ULL, 0x000fc400078e020bULL, 0x000000242810723cULL, 0x000b620000041810ULL,
0x00000010321d7824ULL, 0x000fe400078e0207ULL, 0x0000000126157824ULL, 0x000fe200078e0215ULL,
0x0000000c0b007388ULL, 0x0003e20000000800ULL, 0x00000010341e7824ULL, 0x100fe400078e0207ULL,
0x0000000126167824ULL, 0x000fe200078e0216ULL, 0x0000000e15007388ULL, 0x0005e20000000800ULL,
0x00000010381f7824ULL, 0x000fe400078e0207ULL, 0x0000000126177824ULL, 0x000fe200078e0217ULL,
0x0000002016007388ULL, 0x0005e20000000800ULL, 0x000000103c077824ULL, 0x000fe200078e0207ULL,
0x00000003360b7208ULL, 0x002fe20004800000ULL, 0x00000001261c7824ULL, 0x040fe200078e021cULL,
0x0000002217007388ULL, 0x0005e20000000800ULL, 0x00000001261d7824ULL, 0x000fc400078e021dULL,
0x00000001261e7824ULL, 0x040fe200078e021eULL, 0x000000181c007388ULL, 0x0005e20000000800ULL,
0x00000001261f7824ULL, 0x040fe400078e021fULL, 0x0000000126247824ULL, 0x020fe200078e0207ULL,
0x0000001a1d007388ULL, 0x0005e20000000800ULL, 0x000000ffff117224ULL, 0x000fc600078e0012ULL,
0x000000281e007388ULL, 0x0005e80000000800ULL, 0x0000002a1f007388ULL, 0x0005e80000000800ULL,
0x0000000d24007388ULL, 0x0005e80000000800ULL, 0x0004000f15007388ULL, 0x0005e80000000800ULL,
0x0004002116007388ULL, 0x0005e80000000800ULL, 0x0004002317007388ULL, 0x0005e80000000800ULL,
0x000400191c007388ULL, 0x0005e80000000800ULL, 0x0004001b1d007388ULL, 0x0005e80000000800ULL,
0x000400291e007388ULL, 0x0005e80000000800ULL, 0x0004002b1f007388ULL, 0x0005e80000000800ULL,
0x01b0000814008388ULL, 0x0005e80000000c00ULL, 0x01b2001014008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080073ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100073ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180073ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000005c4800720cULL, 0x000fe20003f06070ULL,
0x01b6200073ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff037224ULL, 0x000fd600078e0048ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff96a000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014710000e7802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x008fea0003c00000ULL, 0xfffee3b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20005000000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014760000e7802ULL, 0x000fc40000000f00ULL, 0x00000ef000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff337224ULL, 0x000fe200078e000cULL, 0xfffee3f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0035ULL, 0x000147d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000e3000007944ULL, 0x008fea0003c00000ULL, 0xfffee4b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0035ULL, 0x00014830000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000dd000007944ULL, 0x00afea0003c00000ULL, 0xfffee5b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x000148a0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00000d6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xfffee74000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00014910000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000cf000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xfffee70000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014970000e7802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x008fea0003c00000ULL, 0xfffefca000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x000149c0000e7802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000cULL, 0xfffefce000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00014a30000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000bd000007944ULL, 0x008fea0003c00000ULL, 0xfffefdb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00014a90000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000b7000007944ULL, 0x00afea0003c00000ULL, 0xfffefeb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x00014b00000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e000aULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00000b0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff004000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x00014b70000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000a9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff000000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014bd0000e7802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x002fea0003c00000ULL, 0xffff13b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014c20000e7802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e000cULL, 0xffff13f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0033ULL, 0x00014c90000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000097000007944ULL, 0x000fea0003c00000ULL, 0xffff14c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0033ULL, 0x00014cf0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000091000007944ULL, 0x002fea0003c00000ULL, 0xffff15c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0000ULL, 0x00014d60000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x000008a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff175000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0000ULL, 0x00014dd0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000083000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff171000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014e30000e7802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x008fea0003c00000ULL, 0xffff2b6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014e80000e7802ULL, 0x000fc40000000f00ULL, 0x000007d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0xffff2b9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0x00014ef0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000071000007944ULL, 0x008fea0003c00000ULL, 0xffff2c6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0x00014f50000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x00afea0003c00000ULL, 0xffff2d6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00014fc0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0010ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff2ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00015030000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff2eb000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x000150a0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0036ULL, 0xffffe8b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e000fULL, 0x00015120000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff367424ULL, 0x000fc400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x000000360f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x000151a0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000f36097208ULL, 0x000fe20004000000ULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x000000360a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000bULL,
0x00015220000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000a360f7208ULL, 0x000fe20004000000ULL, 0x0000001fff367424ULL, 0x000fc400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x000000360b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0010ULL,
0x000152a0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000b36037208ULL, 0x000fe20004000000ULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x000000361000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0009ULL,
0x00015320000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000001036087208ULL, 0x000fe20004000000ULL, 0x0000001fff367424ULL, 0x000fc400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000360900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000fULL,
0x000153a0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000936097208ULL, 0x000fe20004000000ULL, 0x0000001fff367424ULL, 0x000fe400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000360f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0003ULL,
0x00015420000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000f360a7208ULL, 0x000fe20004000000ULL, 0x0000001fff367424ULL, 0x000fc400078e00ffULL,
0xffffffffff117424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffe6a000007947ULL, 0x000fea000383ffffULL, 0x018000000a047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000a00048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000a057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000a00047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff0d7224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e0006ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffeaa4004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000001100007348ULL, 0x000fe80003800000ULL,
0x0c00000e07367389ULL, 0x0002a200000e0036ULL, 0xfffeaa000c007950ULL, 0x000fea0003c3ffffULL,
0x0000003000007348ULL, 0x000fe80003800000ULL, 0x0000000c0e0c7389ULL, 0x0002a400000e0031ULL,
0x000000ffff0e7224ULL, 0x002fc400078e000fULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea9b00e007950ULL, 0x000fea0003c3ffffULL, 0x000000010c00780cULL, 0x000fe20003f45070ULL,
0x0000000f00007348ULL, 0x000fd80003800000ULL, 0x00000000000c7806ULL, 0x000fc800050e0100ULL,
0x0000000f0c0c7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea9500e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000512ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000670ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c8ULL,
0x0000000000000330ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bf8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cb8ULL,
0x00000000000005d0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001288ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001298ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001328ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000132cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000015780ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016c80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016cc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000017040ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001328ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015958ULL,
0x0000000000015958ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016c80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000017040ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_bf16_d_128_beam_1_kvt_bf16_nqpkv_0_m_16_sm_80_cubin_len = 94496;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
