# HugeCTR Support Matrix

> The support matrix for HugeCTR is no longer maintained.
> See the [Merlin Support Matrix](https://nvidia-merlin.github.io/Merlin/main/support_matrix/index.html)
> page for information about containers that include HugeCTR.

**Note**: From v3.4, we don't provide standalone containers for HugeCTR development. Instead you will be able to develop HugeCTR with Merlin containers. Please find the how-to [here](../../docs/hugectr_contributor_guide.md). For the information of v3.3 and before please refer to the document below.

-----------

**Important**: Content that is included in <<>> brackets indicates new content from the previously published version.

<div align="center"><a name="md_cap_train">Table 1: Support matrix for the HugeCTR training (Dockerfile.train) container</a></div>

| Release Version                                              | <div style="width:320px">v3.3</div>                          | <div style="width:320px">v3.2.1</div>                        | <div style="width:320px">v3.2</div>                          | <div style="width:320px">v3.1</div>                          | <div style="width:340px">v3.0</div>                          | <div style="width:340px">v2.3</div>                          |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| **DGX**                                                      |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| DGX System                                                   | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br>DGX-2<br>DGX A100<br>DGX Station                    | DGX-1<br>DGX-2<br>DGX A100<br>DGX Station                    |
| **NVIDIA Certified Systems**                                 |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| [NVIDIA Driver](http://www.nvidia.com/Download/index.aspx?lang=en-us) | Release v3.3 is based on [NVIDIA CUDA 11.5.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 495 or later. However, if you are running on a Data Center GPU (for example, T4 or any other Tesla board), you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), 460.27 (or later R460), or 470.57 (or later R470). The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.2.1 is based on [NVIDIA CUDA 11.4.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 470 or later.<br/><br/>However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.2 is based on [NVIDIA CUDA 11.3.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 465.19.01 or later.<br/><br/>However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.1 is based on [NVIDIA CUDA 11.3.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 465.19.01 or later.<br/><br/>However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.0 is based on [NVIDIA CUDA 11.1.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 455.23.<br><br>However, if you are running on Tesla (for example, T4 or any other Tesla board), you may use NVIDIA driver release 418.xx, 440.30, or 450.51.<br><br>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v2.3 is based on [NVIDIA CUDA 11.0.221](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 450.51.<br><br>However, if you are running on Tesla (for example, T4 or any other Tesla board), you may use NVIDIA driver release 418.xx or 440.30.<br><br>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> |
| GPU Model                                                    | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) |
| **Base Container Image**                                     | [nvcr.io/nvidia/tensorflow:21.11-tf2-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tensorflow) | [nvcr.io/nvidia/tensorflow:21.09-tf2-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tensorflow) | [nvcr.io/nvidia/tensorflow:21.06-tf2-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tensorflow) | [nvcr.io/nvidia/tensorflow:21.06-tf2-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tensorflow) | [nvidia/cuda:11.1.1-cudnn8-devel-ubuntu20.04](https://hub.docker.com/layers/nvidia/cuda/11.1.1-cudnn8-devel-ubuntu20.04/images/sha256-a47bd681dcfcdaa2f8bd35a1646875418ebc966a414d402ed8ca068137ff2e04?context=explore) | [nvidia/cuda:11.0-cudnn8-devel-ubuntu18.04](https://hub.docker.com/layers/nvidia/cuda/11.0-cudnn8-devel-ubuntu18.04/images/sha256-11777cee30f0bbd7cb4a3da562fdd0926adb2af02069dad7cf2e339ec1dad036?context=explore) |
| Container OS                                                 | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | \<\<[Ubuntu 20.04](http://releases.ubuntu.com/20.04/)\>\>    | [Ubuntu 18.04](http://releases.ubuntu.com/18.04/)            |
| [CUDA](http://docs.nvidia.com/cuda/index.html)               | [11.5.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) | \<\<[11.4.2](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | [11.3.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) | \<\<[11.3.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | \<\<[11.1.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | [11.0.221](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) |
| [cuBLAS](https://docs.nvidia.com/cuda/cublas/index.html)     | [11.7.3.1](https://docs.nvidia.com/cuda/cublas/index.html)   | \<\<[11.6.1.51](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | [11.5.1.109](https://docs.nvidia.com/cuda/cublas/index.html) | \<\<[11.5.1.109](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | \<\<[11.3.0.106](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | [11.2.0.252](https://docs.nvidia.com/cuda/cublas/index.html) |
| [cuDNN](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) | [8.3.0.96](https://docs.nvidia.com/deeplearning/cudnn/release-notes/) | \<\<[8.2.4.15](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | [8.2.1](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) | \<\<[8.2.1](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | \<\<[8.0.5](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | [8.0.4](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) |
| [NCCL](https://docs.nvidia.com/deeplearning/nccl/archives/index.html) | [2.11.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/) | \<\<[2.11.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html)\>\> | [2.9.9](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html) | \<\<[2.9.9](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html)\>\> | \<\<[2.8.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html)\>\> | [2.7.8](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html) |
| [TensorFlow](https://www.tensorflow.org/)                    | [2.6.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.6.0) | \<\<[2.6.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.6.0)\>\> | [2.5.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.5.0) | \<\<[2.5.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.5.0)>> | \<\<[2.4.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.4.0)>> | nightly-gpu                                                  |
| [HPC-X](https://developer.nvidia.com/networking/hpc-x)       | [2.9.0](https://developer.nvidia.com/networking/hpc-x)       | \<\<[2.9.0](https://developer.nvidia.com/networking/hpc-x)\>\> | [2.8.2](https://developer.nvidia.com/networking/hpc-x)       | \<\<[2.8.2](https://docs.mellanox.com/display/HPCXv281)\>\>  | —                                                            | —                                                            |
| **Packages**                                                 |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| [hwloc](https://www.open-mpi.org/projects/hwloc/)            | —<a href="#md_idx_2">*</a>                                   | —<a href="#md_idx_2">*</a>                                   | [2.5.0](https://www.open-mpi.org/projects/hwloc/doc/)        | \<\<[2.5.0](https://www.open-mpi.org/projects/hwloc/doc/)\>\> | \<\<[2.4.0](https://www.open-mpi.org/projects/hwloc/doc/)\>\> | [2.2.0](https://www.open-mpi.org/projects/hwloc/doc/)        |
| [UCX](https://www.openucx.org/)                              | —                                                            | —                                                            | [1.9.0](https://github.com/openucx/ucx/releases/tag/v1.9.0)  | [1.9.0](https://github.com/openucx/ucx/releases/tag/v1.9.0)  | \<\<[1.9.0](https://github.com/openucx/ucx/releases/tag/v1.9.0)>> | [1.8.0](https://github.com/openucx/ucx/releases/tag/v1.8.0)  |
| [OpenMPI](https://www.open-mpi.org/)                         | —                                                            | —                                                            | [4.1.0](https://www.open-mpi.org/software/ompi/v4.1/)        | [4.1.0](https://www.open-mpi.org/software/ompi/v4.1/)        | \<\<[4.1.0](https://www.open-mpi.org/software/ompi/v4.1/)>\> | [4.0.3](https://www.open-mpi.org/software/ompi/v4.0/)        |
| [rapidsai/rmm](https://htmlpreview.github.io/?https://github.com/XiaoleiShi-NV/HugeCTR/blob/master/docs/software_stack_src/index.html#libraries) | —                                                            | \<\<[21.10.01](https://github.com/rapidsai/rmm/releases/tag/v21.10.01)\>\> | [21.06](https://github.com/rapidsai/rmm/releases/tag/v21.06.00) | \<\<[21.06](https://github.com/rapidsai/rmm/releases/tag/v21.06.00)>> | \<\<[0.18](https://github.com/rapidsai/rmm/releases/tag/v0.18.0)>> | [0.16](https://github.com/rapidsai/rmm/releases/tag/v0.16.0) |
| [rapidsai/cudf](https://htmlpreview.github.io/?https://github.com/XiaoleiShi-NV/HugeCTR/blob/master/docs/software_stack_src/index.html#libraries) | —                                                            | \<\<[21.10.01](https://github.com/rapidsai/cudf/releases/tag/v21.10.01)\>\> | [21.06](https://github.com/rapidsai/cudf/releases/tag/v21.06.00) | \<\<[21.06](https://github.com/rapidsai/cudf/releases/tag/v21.06.00)>> | \<\<[0.18](https://github.com/rapidsai/cudf/releases/tag/v0.18.0)>> | [0.16](https://github.com/rapidsai/cudf/releases/tag/v0.16.0) |
| [RocksDB](https://github.com/facebook/rocksdb)               | [6.25.3](https://github.com/facebook/rocksdb/releases/tag/v6.25.3) | \<\<[6.25.3](https://github.com/facebook/rocksdb/releases/tag/v6.25.3)\>\> | \<\<[6.22.1](https://github.com/facebook/rocksdb/releases/tag/v6.22.1)\>\> | —                                                            | —                                                            | —                                                            |
| [Hiredis](https://github.com/redis/hiredis)                  | [1.0.2](https://github.com/redis/hiredis/releases/tag/v1.0.2) | \<\<[1.0.2](https://github.com/redis/hiredis/releases/tag/v1.0.2)\>\> | \<\<[1.0.0](https://github.com/redis/hiredis/releases/tag/v1.0.0)\>\> | —                                                            | —                                                            | —                                                            |
| [redis-plus-plus](https://github.com/sewenew/redis-plus-plus) | [1.3.2](https://github.com/sewenew/redis-plus-plus/releases/tag/1.3.2) | \<\<[1.3.2](https://github.com/sewenew/redis-plus-plus/releases/tag/1.3.2)\>\> | —                                                            | —                                                            | —                                                            | —                                                            |
| Kafka                                                        | 1.8.2                                                        |                                                              |                                                              |                                                              |                                                              |                                                              |
| Python libs                                                  | pandas<br/>sklearn<br/>ortools<br/>mpi4py<br/>onnx<br/>onnxruntime | pandas<br/>sklearn<br/>ortools<br/>mpi4py<br/>onnx<br/>onnxruntime | numpy<br/>pandas<br/>sklearn<br/>ortools<br/>jupyterlab<br/>onnx<br/>onnxruntime | numpy<br/>pandas<br/>sklearn<br/>ortools<br/>jupyter         | numpy<br>pandas<br>sklearn<br>ortools<br>jupyter             | numpy<br>pandas<br>sklearn<br>ortools<br>jupyter             |

<br></br>

<div align="center"><a name="md_cap_infer">Table 2: Support matrix for the inference (Dockerfile.inference) container</a></div>

| Container Image                                              | <div style="width:320px">v3.3</div>                          | <div style="width:320px">v3.2.1</div>                        | <div style="width:320px">v3.2</div>                          | <div style="width:320px">v3.1</div>                          | <div style="width:320px">v3.0</div>                          |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| **DGX**                                                      |                                                              |                                                              |                                                              |                                                              |                                                              |
| DGX System                                                   | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br>DGX-2<br>DGX A100<br>DGX Station                    |
| **NVIDIA Certified Systems**                                 |                                                              |                                                              |                                                              |                                                              |                                                              |
| [NVIDIA Driver](http://www.nvidia.com/Download/index.aspx?lang=en-us) | Release v3.3 is based on [NVIDIA CUDA 11.5.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 495 or later. However, if you are running on a Data Center GPU (for example, T4 or any other Tesla board), you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), 460.27 (or later R460), or 470.57 (or later R470).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.2.1 is based on [NVIDIA CUDA 11.4.2](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 470 or later. However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.2 is based on [NVIDIA CUDA 11.4.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 470 or later. However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.1 is based on [NVIDIA CUDA 11.3.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 465.19.01.<br/><br/>However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.0 is based on [NVIDIA CUDA 11.2.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](http://www.nvidia.com/Download/index.aspx?lang=en-us) release 460.27.04 or later.<br/><br/>However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51(or later R450).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> |
| GPU Model                                                    | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/> | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/> | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) |
| **Base Container Image**                                     | [nvcr.io/nvidia/tensorflow:21.11-tf2-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tensorflow) | [nvcr.io/nvidia/tritonserver:21.09-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tritonserver) | [nvcr.io/nvidia/tritonserver:21.08-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tritonserver) | [nvcr.io/nvidia/tritonserver:21.04-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tritonserver) | [nvcr.io/nvidia/tritonserver:21.02-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tritonserver) |
| Container OS                                                 | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            |
| [CUDA](http://docs.nvidia.com/cuda/index.html)               | [11.5.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) | \<\<[11.4.2](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | \<\<[11.4.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | \<\<[11.3.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | [11.2.0](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) |
| [cuBLAS](https://docs.nvidia.com/cuda/cublas/index.html)     | [11.7.3.1](https://docs.nvidia.com/cuda/cublas/index.html)   | \<\<[11.6.1.51](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | \<\<[11.5.4](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | \<\<[11.5.1.101](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | [11.3.1.68](https://docs.nvidia.com/cuda/cublas/index.html)  |
| [cuDNN](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) | [8.3.0.96](https://docs.nvidia.com/deeplearning/cudnn/release-notes/) | \<\<[8.2.4.15](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | \<\<[8.2.2.26](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | \<\<[8.2.0.41](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | [8.1.0.77](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) |
| [NCCL](https://docs.nvidia.com/deeplearning/nccl/archives/index.html) | [2.11.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/) | \<\<[2.11.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html)\>\> | \<\<[2.10.3](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html)\>\> | \<\<[2.9.6](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html)\>\> | [2.8.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html) |
| **Packages**                                                 |                                                              |                                                              |                                                              |                                                              |                                                              |
| [rapids/rmm](https://htmlpreview.github.io/?https://github.com/XiaoleiShi-NV/HugeCTR/blob/master/docs/software_stack_src/index.html#libraries) | 21.08                                                        | \<\<[21.10.01](https://github.com/rapidsai/rmm/releases/tag/v21.10.01)\>\> | [21.06](https://github.com/rapidsai/rmm/releases/tag/v21.06.00) | \<\<[21.06](https://github.com/rapidsai/rmm/releases/tag/v21.06.00)>> | [0.18](https://github.com/rapidsai/rmm/releases/tag/v0.18.0) |
| [rapids/cudf](https://htmlpreview.github.io/?https://github.com/XiaoleiShi-NV/HugeCTR/blob/master/docs/software_stack_src/index.html#libraries) | 21.08                                                        | \<\<[21.10.01](https://github.com/rapidsai/cudf/releases/tag/v21.10.01)\>\> | [21.06](https://github.com/rapidsai/cudf/releases/tag/v21.06.00) | \<\<[21.06](https://github.com/rapidsai/cudf/releases/tag/v21.06.00)>> | —                                                            |
| [RocksDB](https://github.com/facebook/rocksdb)               | [6.25.3](https://github.com/facebook/rocksdb/releases/tag/v6.25.3) | \<\<[6.25.3](https://github.com/facebook/rocksdb/releases/tag/v6.25.3)\>\> | \<\<[6.22.1](https://github.com/facebook/rocksdb/releases/tag/v6.22.1)\>\> | —                                                            | —                                                            |
| [Hiredis](https://github.com/redis/hiredis)                  | 1.0.2                                                        | \<\<[1.0.2](https://github.com/redis/hiredis/releases/tag/v1.0.2)\>\> | \<\<[1.0.0](https://github.com/redis/hiredis/releases/tag/v1.0.0)\>\> | —                                                            | —                                                            |
| [redis-plus-plus](https://github.com/sewenew/redis-plus-plus) | 1.3.2                                                        | \<\<[1.3.2](https://github.com/sewenew/redis-plus-plus/releases/tag/1.3.2)\>\> | —                                                            | —                                                            | —                                                            |
| [RapidJSON](https://github.com/Tencent/rapidjson)            | \<\<[1.1.0](https://github.com/Tencent/rapidjson/releases/tag/v1.1.0)\>\> | \<\<[1.1.0](https://github.com/Tencent/rapidjson/releases/tag/v1.1.0)\>\> | —                                                            | —                                                            | —                                                            |
| Python libs                                                  | pandas<br/>sklearn<br/>nvidia-pyindex<br/>tritonclient       | pandas<br/>sklearn<br/>nvidia-pyindex<br/>tritonclient       | pandas<br/>sklearn<br/>nvidia-pyindex<br/>tritonclient       | pandas<br/>sklearn                                           | pandas<br>sklearn                                            |

<br></br>

<div align="center"><a name="md_cap_plugin">Table 3. Software stack for embedding TF plugin image (Dockerfile.tf-plugin)</a></div>

| Container Image                                              | <div style="width:320px">v3.3</div>                          | <div style="width:320px">v3.2.1</div>                        | <div style="width:320px">v3.2</div>                          | <div style="width:320px">v3.1</div>                          | <div style="width:320px">v3.0</div>                          |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| **DGX**                                                      |                                                              |                                                              |                                                              |                                                              |                                                              |
| DGX System                                                   | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br/>DGX-2<br/>DGX A100<br/>DGX Station                 | DGX-1<br>DGX-2<br>DGX A100<br>DGX Station                    |
| **NVIDIA Certified Systems**                                 |                                                              |                                                              |                                                              |                                                              |                                                              |
| [NVIDIA Driver](http://www.nvidia.com/Download/index.aspx?lang=en-us) | Release v3.3 is based on [NVIDIA CUDA 11.4](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 470 or later. However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.2.1 is based on [NVIDIA CUDA 11.4.2](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 470 or later. However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51 (or later R450), or 460.27 (or later R460).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.2 is based on [NVIDIA CUDA 11.2.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 460.32.03 or later. However, if you are running on Data Center GPUs (formerly Tesla), for example, T4, you may use NVIDIA driver release 418.40 (or later R418), 440.33 (or later R440), 450.51(or later R450).<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.0 is based on [CUDA 11.1.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 455.23.<br/><br/>However, if you are running on Tesla (for example, T4 or any other Tesla board), you may use NVIDIA driver release 418.xx, 440.30, or 450.51.<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> | Release v3.0 is based on [CUDA 11.1.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html), which requires [NVIDIA Driver](https://www.nvidia.com/Download/index.aspx?lang=en-us) release 455.23.<br/><br/>However, if you are running on Tesla (for example, T4 or any other Tesla board), you may use NVIDIA driver release 418.xx, 440.30, or 450.51.<br/><br/>The CUDA driver's compatibility package only supports particular drivers. <a href="#md_idx_1">1</a> |
| GPU Model                                                    | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br/>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br/>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br/>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) | [NVIDIA Ampere GPU Architecture](https://www.nvidia.com/en-us/data-center/nvidia-ampere-gpu-architecture)<br>[Turing](https://www.nvidia.com/en-us/geforce/turing/)<br>[Volta](https://www.nvidia.com/en-us/data-center/volta-gpu-architecture/)<br>[Pascal](https://www.nvidia.com/en-us/data-center/pascal-gpu-architecture/) |
| **Base Container Image**                                     | [nvcr.io/nvidia/tensorflow:21.10-tf2-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tensorflow) | [nvcr.io/nvidia/tensorflow:21.09-tf2-py3](https://ngc.nvidia.com/catalog/containers/nvidia:tensorflow) | [nvidia/cuda:11.2.1-cudnn8-devel-ubuntu20.04](https://hub.docker.com/layers/nvidia/cuda/11.1.1-cudnn8-devel-ubuntu20.04/images/sha256-a47bd681dcfcdaa2f8bd35a1646875418ebc966a414d402ed8ca068137ff2e04?context=explore) | [nvidia/cuda:11.1.1-cudnn8-devel-ubuntu20.04](https://hub.docker.com/layers/nvidia/cuda/11.1.1-cudnn8-devel-ubuntu20.04/images/sha256-a47bd681dcfcdaa2f8bd35a1646875418ebc966a414d402ed8ca068137ff2e04?context=explore) | [nvidia/cuda:11.1.1-cudnn8-devel-ubuntu20.04](https://hub.docker.com/layers/nvidia/cuda/11.1.1-cudnn8-devel-ubuntu20.04/images/sha256-a47bd681dcfcdaa2f8bd35a1646875418ebc966a414d402ed8ca068137ff2e04?context=explore) |
| Container OS                                                 |                                                              |                                                              | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            | [Ubuntu 20.04](http://releases.ubuntu.com/20.04/)            |
| [CUDA](http://docs.nvidia.com/cuda/index.html)               | [11.4.2](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) | \<\<[11.4.2](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | \<\<[11.2.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html)\>\> | [11.1.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) | [11.1.1](https://docs.nvidia.com/cuda/cuda-toolkit-release-notes/index.html) |
| [cuBLAS](https://docs.nvidia.com/cuda/cublas/index.html)     | [11.6.5.2](https://docs.nvidia.com/cuda/cublas/index.html)   | \<\<[11.6.1.51](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | \<\<[11.4.1.1026](https://docs.nvidia.com/cuda/cublas/index.html)\>\> | [11.3.0.106](https://docs.nvidia.com/cuda/cublas/index.html) | [11.3.0.106](https://docs.nvidia.com/cuda/cublas/index.html) |
| [cuDNN](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) | [8.2.4.15](https://docs.nvidia.com/deeplearning/cudnn/release-notes/) | \<\<[8.2.4.15](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | \<\<[ 8.1.1](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html)\>\> | [8.0.5](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) | [8.0.5](https://docs.nvidia.com/deeplearning/cudnn/release-notes/index.html) |
| [NCCL](https://docs.nvidia.com/deeplearning/nccl/archives/index.html) | [2.11.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/) | \<\<[2.11.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html)\>\> | [2.8.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html) | [2.8.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html) | [2.8.4](https://docs.nvidia.com/deeplearning/nccl/release-notes/index.html) |
| **Packages**                                                 |                                                              |                                                              |                                                              |                                                              |                                                              |
| [rapids/rmm](https://htmlpreview.github.io/?https://github.com/XiaoleiShi-NV/HugeCTR/blob/master/docs/software_stack_src/index.html#libraries) | —                                                            | —                                                            | [21.06](https://github.com/rapidsai/rmm/releases/tag/v21.06.00) | \<\<[21.06](https://github.com/rapidsai/rmm/releases/tag/v21.06.00)>> | [0.18](https://github.com/rapidsai/rmm/releases/tag/v0.18.0) |
| [TensorFlow](https://www.tensorflow.org/)                    | [2.6.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.6.0) | [2.6.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.6.0) | [2.6.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.6.0) | [2.4.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.4.0) | [2.4.0](https://github.com/tensorflow/tensorflow/releases/tag/v2.4.0) |
| Python libs                                                  | —                                                            | —                                                            | numpy<br/>pandas<br/>sklearn<br/>ortools<br/>jupyter<br/>nvtx-plugins | numpy<br/>pandas<br/>sklearn<br/>ortools<br/>jupyter<br/>nvtx-plugins | numpy<br>pandas<br>sklearn<br>ortools<br>jupyter<br>nvtx-plugins |

<a name="md_idx_1">1</a> For a complete list of supported drivers, see [CUDA Application Compatibility](https://docs.nvidia.com/deploy/cuda-compatibility/index.html#cuda-application-compatibility). For more information, see [CUDA Compatibility and Upgrades](https://docs.nvidia.com/cuda/cuda-c-best-practices-guide/index.html#cuda-compatibility-and-upgrades).

<a name="md_idx_2">*</a> The "—" means this component is shipped by other packages or the base docker image, or it is not required anymore.  The corresponding changes in dockerfiles are they will not be installed explicitly.

