/*
 * Copyright (c) 2023, NVIDIA CORPORATION.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <core23/details/host_launch_helpers.hpp>

namespace HugeCTR {

namespace core23 {

void copy_wrapper(void* user_data) {
  CopyParams<uint8_t, uint8_t>* params = static_cast<CopyParams<uint8_t, uint8_t>*>(user_data);
  std::copy(params->src, params->src + params->size, params->dst);
  delete params;
}

}  // namespace core23
}  // namespace HugeCTR