using SparseArrays
using Test

include(joinpath(DATA_DIR, "psy_data", "data_5bus_pu.jl"))
include(joinpath(DATA_DIR, "psy_data", "data_14bus_pu.jl"))

# The 5-bus case from PowerModels data is modified to include 2 phase shifters

RTS = PSB.build_system(PSB.PSITestSystems, "test_RTS_GMLC_sys");

# mixed up ids for data_5bus_pu
Br5NS_ids = [2, 3, 5, 1, 4, 6]
Bu5NS_ids = [1, 3, 4, 5, 2]

#PTDFs obtained from Matpower
S5_slackB4 = [
    0.1939 -0.4759 -0.3490 0 0.1595
    0.4376 0.2583 0.1895 0 0.3600
    0.3685 0.2176 0.1595 0 -0.5195
    0.1939 0.5241 -0.3490 0 0.1595
    0.1939 0.5241 0.6510 0 0.1595
    -0.3685 -0.2176 -0.1595 0 -0.4805
]

S14_slackB1 = [
    0 -0.8380 -0.7465 -0.6675 -0.6106 -0.6291 -0.6573 -0.6573 -0.6518 -0.6477 -0.6386 -0.6309 -0.6323 -0.6433
    0 -0.1620 -0.2535 -0.3325 -0.3894 -0.3709 -0.3427 -0.3427 -0.3482 -0.3523 -0.3614 -0.3691 -0.3677 -0.3567
    0 0.0273 -0.5320 -0.1513 -0.1031 -0.1188 -0.1427 -0.1427 -0.1380 -0.1346 -0.1269 -0.1204 -0.1215 -0.1308
    0 0.0572 -0.1434 -0.3167 -0.2158 -0.2487 -0.2986 -0.2986 -0.2888 -0.2817 -0.2655 -0.2519 -0.2543 -0.2738
    0 0.0774 -0.0711 -0.1994 -0.2917 -0.2616 -0.2160 -0.2160 -0.2249 -0.2314 -0.2463 -0.2587 -0.2564 -0.2387
    0 0.0273 0.4680 -0.1513 -0.1031 -0.1188 -0.1427 -0.1427 -0.1380 -0.1346 -0.1269 -0.1204 -0.1215 -0.1308
    0 0.0799 0.3067 0.5026 -0.3012 -0.0389 0.3584 0.3584 0.2808 0.2240 0.0948 -0.0137 0.0061 0.1607
    0 0.0030 0.0113 0.0186 -0.0111 -0.2075 -0.6338 -0.6338 -0.4469 -0.4043 -0.3076 -0.2264 -0.2412 -0.3569
    0 0.0017 0.0066 0.0108 -0.0065 -0.1211 -0.1658 -0.1658 -0.2608 -0.2360 -0.1795 -0.1321 -0.1408 -0.2083
    0 -0.0047 -0.0179 -0.0294 0.0176 -0.6714 -0.2004 -0.2004 -0.2924 -0.3597 -0.5128 -0.6415 -0.6181 -0.4348
    0 -0.0028 -0.0108 -0.0177 0.0106 0.1979 -0.1207 -0.1207 -0.1760 -0.2873 -0.5402 0.1683 0.1452 -0.0356
    0 -0.0004 -0.0016 -0.0026 0.0016 0.0291 -0.0177 -0.0177 -0.0259 -0.0161 0.0061 -0.5211 -0.1697 -0.0887
    0 -0.0014 -0.0056 -0.0091 0.0055 0.1017 -0.0620 -0.0620 -0.0904 -0.0563 0.0213 -0.2886 -0.5936 -0.3104
    0 0 0 0 0 0 0 -1.0000 0 0 0 0 0 0
    0 0.0030 0.0113 0.0186 -0.0111 -0.2075 0.3662 0.3662 -0.4469 -0.4043 -0.3076 -0.2264 -0.2412 -0.3569
    0 0.0028 0.0108 0.0177 -0.0106 -0.1979 0.1207 0.1207 0.1760 -0.7127 -0.4598 -0.1683 -0.1452 0.0356
    0 0.0019 0.0071 0.0117 -0.0070 -0.1307 0.0797 0.0797 0.1163 0.0724 -0.0274 -0.1902 -0.2367 -0.6008
    0 0.0028 0.0108 0.0177 -0.0106 -0.1979 0.1207 0.1207 0.1760 0.2873 -0.4598 -0.1683 -0.1452 0.0356
    0 -0.0004 -0.0016 -0.0026 0.0016 0.0291 -0.0177 -0.0177 -0.0259 -0.0161 0.0061 0.4789 -0.1697 -0.0887
    0 -0.0019 -0.0071 -0.0117 0.0070 0.1307 -0.0797 -0.0797 -0.1163 -0.0724 0.0274 0.1902 0.2367 -0.3992
]

SRTS_GMLC = [
    4.3622133e-01 -5.0667922e-01 9.5577219e-02 -2.4803183e-01 2.2677242e-01 -1.1462705e-01 -6.3832228e-03 -9.2586105e-03 -3.6226097e-02 9.9311880e-03 -2.0064389e-03 -4.2092103e-03 0.0000000e+00 6.9688071e-03 2.6008884e-02 1.9576891e-02 2.1306964e-02 2.2112779e-02 1.4259349e-02 9.6353986e-03 2.2861035e-02 2.2250187e-02 7.0922262e-03 5.2364366e-02 3.2160772e-03 3.2799419e-03 1.2059153e-03 3.4601686e-03 3.6381080e-03 3.8833320e-03 3.8413949e-03 3.8413949e-03 3.6077558e-03 4.0750340e-03 4.3148064e-03 4.6472541e-03 4.8299042e-03 4.3254387e-03 3.5979639e-03 4.3403745e-03 4.6377944e-03 4.3746589e-03 5.0875328e-03 5.7372356e-03 4.1303189e-03 4.3297890e-03 6.0945721e-03 2.6917529e-03 1.4962539e-02 1.4977176e-02 1.4501844e-02 1.5018481e-02 1.5059261e-02 1.5115463e-02 1.5105851e-02 1.5105851e-02 1.5052305e-02 1.5159398e-02 1.5031209e-02 1.5473681e-02 1.5477894e-02 1.4566971e-02 1.3567224e-02 1.3914828e-02 1.3012992e-02 1.2536577e-02 1.4928667e-02 1.5810266e-02 1.2899443e-02 1.2944075e-02 1.6295145e-02 1.3921298e-02 1.6852627e-02
    2.4269538e-01 2.2009340e-01 -1.9957646e-01 9.3061431e-02 1.5524446e-01 1.0217173e-01 1.2947746e-02 1.8866403e-02 -1.0964748e-02 6.4707034e-02 4.2097980e-03 8.8083642e-03 0.0000000e+00 -1.4541938e-02 -5.4315692e-02 -4.0883663e-02 -4.4498466e-02 -4.6182130e-02 -2.9782017e-02 -2.0128411e-02 -4.7745532e-02 -4.6469229e-02 -1.4818928e-02 -1.0934673e-01 -6.8268141e-03 -6.9587647e-03 -2.6736264e-03 -7.3311304e-03 -7.6987703e-03 -8.2054267e-03 -8.1187807e-03 -8.1187807e-03 -7.6360599e-03 -8.6015016e-03 -9.0924447e-03 -9.7882127e-03 -1.0164671e-02 -9.1030737e-03 -7.5659408e-03 -9.1180051e-03 -9.7301352e-03 -9.1824726e-03 -1.0682178e-02 -1.2042328e-02 -8.6739288e-03 -9.0890851e-03 -1.2790410e-02 -5.7125214e-03 -3.1278559e-02 -3.1309074e-02 -3.0318090e-02 -3.1395188e-02 -3.1480208e-02 -3.1597378e-02 -3.1577340e-02 -3.1577340e-02 -3.1465706e-02 -3.1688974e-02 -3.1421723e-02 -3.2344201e-02 -3.2352983e-02 -3.0453869e-02 -2.8369573e-02 -2.9094265e-02 -2.7214097e-02 -2.6220856e-02 -3.1207941e-02 -3.3045920e-02 -2.6977367e-02 -2.7070417e-02 -3.4056809e-02 -2.9107755e-02 -3.5219059e-02
    3.2108329e-01 2.8658582e-01 1.0399924e-01 1.5497040e-01 -3.8201688e-01 1.2455322e-02 -6.5645232e-03 -9.6077920e-03 4.7190845e-02 -7.4638222e-02 -2.2033590e-03 -4.5991538e-03 0.0000000e+00 7.5731313e-03 2.8306808e-02 2.1306773e-02 2.3191502e-02 2.4069351e-02 1.5522668e-02 1.0493012e-02 2.4884497e-02 2.4219042e-02 7.7267014e-03 5.6982360e-02 3.6107369e-03 3.6788228e-03 1.4677111e-03 3.8709618e-03 4.0606623e-03 4.3220947e-03 4.2773858e-03 4.2773858e-03 4.0283040e-03 4.5264675e-03 4.7776383e-03 5.1409586e-03 5.3347665e-03 4.7776351e-03 3.9679769e-03 4.7776305e-03 5.0923408e-03 4.8078137e-03 5.5946448e-03 6.3050921e-03 4.5436099e-03 4.7592961e-03 6.6958380e-03 3.0207685e-03 1.6316020e-02 1.6331898e-02 1.5816247e-02 1.6376707e-02 1.6420947e-02 1.6481915e-02 1.6471489e-02 1.6471489e-02 1.6413400e-02 1.6529577e-02 1.6390514e-02 1.6870519e-02 1.6875089e-02 1.5886898e-02 1.4802349e-02 1.5179438e-02 1.4201105e-02 1.3684279e-02 1.6279274e-02 1.7235654e-02 1.4077924e-02 1.4126342e-02 1.7761663e-02 1.5186457e-02 1.8366432e-02
    2.4080509e-01 2.6931740e-01 2.9751975e-02 -3.6772482e-01 1.5271603e-01 1.1161979e-01 -2.2476600e-03 -3.2011897e-03 -7.0499542e-02 6.1517943e-02 -6.1082246e-04 -1.2972551e-03 0.0000000e+00 2.1759675e-03 8.0920727e-03 6.0907439e-03 6.6277845e-03 6.8779215e-03 4.4340888e-03 2.9935191e-03 7.1101916e-03 6.9205749e-03 2.2012058e-03 1.6297777e-02 9.2504000e-04 9.4588195e-04 2.6903303e-04 1.0046981e-03 1.0627678e-03 1.1427955e-03 1.1291095e-03 1.1291095e-03 1.0528625e-03 1.2053566e-03 1.2866477e-03 1.3890553e-03 1.4492878e-03 1.2978706e-03 1.0837801e-03 1.3136361e-03 1.4123167e-03 1.3291785e-03 1.5434691e-03 1.7433240e-03 1.2519787e-03 1.3150018e-03 1.8532442e-03 7.7511879e-04 4.6337015e-03 4.6382907e-03 4.4892553e-03 4.6512414e-03 4.6640278e-03 4.6816491e-03 4.6786356e-03 4.6786356e-03 4.6618468e-03 4.6954244e-03 4.6552322e-03 4.7939648e-03 4.7952856e-03 4.5096753e-03 4.1962153e-03 4.3052026e-03 4.0224417e-03 3.8730669e-03 4.6230812e-03 4.8994973e-03 3.9868395e-03 4.0008334e-03 5.0515262e-03 4.3072315e-03 5.2263185e-03
    1.9541625e-01 2.2400338e-01 6.5825244e-02 1.1969298e-01 7.4056390e-02 -2.2624684e-01 -4.1355628e-03 -6.0574209e-03 3.4273445e-02 -5.1586755e-02 -1.3956165e-03 -2.9119552e-03 0.0000000e+00 4.7928396e-03 1.7916812e-02 1.3486147e-02 1.4679179e-02 1.5234857e-02 9.8252597e-03 6.6418795e-03 1.5750844e-02 1.5329612e-02 4.8910204e-03 3.6066589e-02 2.2910372e-03 2.3340599e-03 9.3688224e-04 2.4554705e-03 2.5753402e-03 2.7405365e-03 2.7122854e-03 2.7122854e-03 2.5548933e-03 2.8696775e-03 3.0281586e-03 3.2581988e-03 3.3806164e-03 3.0275681e-03 2.5141839e-03 3.0267385e-03 3.2254776e-03 3.0454804e-03 3.5440636e-03 3.9939116e-03 2.8783401e-03 3.0147872e-03 4.2413279e-03 1.9166341e-03 1.0328838e-02 1.0338885e-02 1.0012588e-02 1.0367239e-02 1.0395234e-02 1.0433814e-02 1.0427216e-02 1.0427216e-02 1.0390459e-02 1.0463973e-02 1.0375977e-02 1.0679717e-02 1.0682608e-02 1.0057296e-02 9.3710089e-03 9.6096249e-03 8.9905504e-03 8.6635105e-03 1.0305585e-02 1.0910769e-02 8.9126034e-03 8.9432415e-03 1.1243619e-02 9.6140668e-03 1.1626308e-02
    8.8439908e-02 7.2933636e-02 4.2286907e-01 -3.4057479e-02 4.7862486e-02 2.2026530e-02 -2.8071840e-02 -4.0755515e-02 -1.2167225e-01 5.8529187e-03 -8.8861976e-03 -1.8631594e-02 0.0000000e+00 3.0828242e-02 1.1507567e-01 8.6617574e-02 9.4273043e-02 9.7838725e-02 6.3091688e-02 4.2634396e-02 1.0114971e-01 9.8446746e-02 3.1382886e-02 2.3168106e-01 1.4278715e-02 1.4560649e-02 5.4047446e-03 1.5356270e-02 1.6141793e-02 1.7224348e-02 1.7039215e-02 1.7039215e-02 1.6007802e-02 1.8070628e-02 1.9127132e-02 2.0598708e-02 2.1404619e-02 1.9169015e-02 1.5942338e-02 1.9227851e-02 2.0539772e-02 1.9376363e-02 2.2535347e-02 2.5411431e-02 1.8296055e-02 1.9177978e-02 2.6993277e-02 1.1950244e-02 6.6215433e-02 6.6280170e-02 6.4177822e-02 6.6462858e-02 6.6643227e-02 6.6891800e-02 6.6849290e-02 6.6849290e-02 6.6612460e-02 6.7086119e-02 6.6519152e-02 6.8476166e-02 6.8494797e-02 6.4465874e-02 6.0044091e-02 6.1581507e-02 5.7592776e-02 5.5485640e-02 6.6065619e-02 6.9964846e-02 5.7090559e-02 5.7287962e-02 7.2109422e-02 6.1610126e-02 7.4575107e-02
    1.5425547e-01 1.4715976e-01 3.7755447e-01 1.2711891e-01 1.0738197e-01 8.0145200e-02 4.1019586e-02 5.9621918e-02 1.1070750e-01 5.8854115e-02 1.3095996e-02 2.7439959e-02 0.0000000e+00 -4.5370181e-02 -1.6939136e-01 -1.2750124e-01 -1.3877151e-01 -1.4402085e-01 -9.2873705e-02 -6.2762807e-02 -1.4889525e-01 -1.4491597e-01 -4.6201813e-02 -3.4102779e-01 -2.1105529e-02 -2.1519414e-02 -8.0783710e-03 -2.2687401e-02 -2.3840564e-02 -2.5429775e-02 -2.5157996e-02 -2.5157996e-02 -2.3643862e-02 -2.6672129e-02 -2.8219577e-02 -3.0386921e-02 -3.1569289e-02 -2.8272089e-02 -2.3508279e-02 -2.8345856e-02 -3.0269907e-02 -2.8558835e-02 -3.3217525e-02 -3.7453758e-02 -2.6969984e-02 -2.8267063e-02 -3.9783687e-02 -1.7662765e-02 -9.7493992e-02 -9.7589244e-02 -9.4495913e-02 -9.7858045e-02 -9.8123435e-02 -9.8489177e-02 -9.8426630e-02 -9.8426630e-02 -9.8078166e-02 -9.8775094e-02 -9.7940876e-02 -1.0082037e-01 -1.0084778e-01 -9.4919743e-02 -8.8413664e-02 -9.0675772e-02 -8.4806873e-02 -8.1706496e-02 -9.7273560e-02 -1.0301077e-01 -8.4067926e-02 -8.4358379e-02 -1.0616623e-01 -9.0717882e-02 -1.0979417e-01
    2.4080509e-01 2.6931740e-01 2.9751975e-02 6.3227518e-01 1.5271603e-01 1.1161979e-01 -2.2476600e-03 -3.2011897e-03 -7.0499542e-02 6.1517943e-02 -6.1082246e-04 -1.2972551e-03 0.0000000e+00 2.1759675e-03 8.0920727e-03 6.0907439e-03 6.6277845e-03 6.8779215e-03 4.4340888e-03 2.9935191e-03 7.1101916e-03 6.9205749e-03 2.2012058e-03 1.6297777e-02 9.2504000e-04 9.4588195e-04 2.6903303e-04 1.0046981e-03 1.0627678e-03 1.1427955e-03 1.1291095e-03 1.1291095e-03 1.0528625e-03 1.2053566e-03 1.2866477e-03 1.3890553e-03 1.4492878e-03 1.2978706e-03 1.0837801e-03 1.3136361e-03 1.4123167e-03 1.3291785e-03 1.5434691e-03 1.7433240e-03 1.2519787e-03 1.3150018e-03 1.8532442e-03 7.7511879e-04 4.6337015e-03 4.6382907e-03 4.4892553e-03 4.6512414e-03 4.6640278e-03 4.6816491e-03 4.6786356e-03 4.6786356e-03 4.6618468e-03 4.6954244e-03 4.6552322e-03 4.7939648e-03 4.7952856e-03 4.5096753e-03 4.1962153e-03 4.3052026e-03 4.0224417e-03 3.8730669e-03 4.6230812e-03 4.8994973e-03 3.9868395e-03 4.0008334e-03 5.0515262e-03 4.3072315e-03 5.2263185e-03
    3.2108329e-01 2.8658582e-01 1.0399924e-01 1.5497040e-01 6.1798312e-01 1.2455322e-02 -6.5645232e-03 -9.6077920e-03 4.7190845e-02 -7.4638222e-02 -2.2033590e-03 -4.5991538e-03 0.0000000e+00 7.5731313e-03 2.8306808e-02 2.1306773e-02 2.3191502e-02 2.4069351e-02 1.5522668e-02 1.0493012e-02 2.4884497e-02 2.4219042e-02 7.7267014e-03 5.6982360e-02 3.6107369e-03 3.6788228e-03 1.4677111e-03 3.8709618e-03 4.0606623e-03 4.3220947e-03 4.2773858e-03 4.2773858e-03 4.0283040e-03 4.5264675e-03 4.7776383e-03 5.1409586e-03 5.3347665e-03 4.7776351e-03 3.9679769e-03 4.7776305e-03 5.0923408e-03 4.8078137e-03 5.5946448e-03 6.3050921e-03 4.5436099e-03 4.7592961e-03 6.6958380e-03 3.0207685e-03 1.6316020e-02 1.6331898e-02 1.5816247e-02 1.6376707e-02 1.6420947e-02 1.6481915e-02 1.6471489e-02 1.6471489e-02 1.6413400e-02 1.6529577e-02 1.6390514e-02 1.6870519e-02 1.6875089e-02 1.5886898e-02 1.4802349e-02 1.5179438e-02 1.4201105e-02 1.3684279e-02 1.6279274e-02 1.7235654e-02 1.4077924e-02 1.4126342e-02 1.7761663e-02 1.5186457e-02 1.8366432e-02
    1.9541625e-01 2.2400338e-01 6.5825244e-02 1.1969298e-01 7.4056390e-02 7.7375316e-01 -4.1355628e-03 -6.0574209e-03 3.4273445e-02 -5.1586755e-02 -1.3956165e-03 -2.9119552e-03 0.0000000e+00 4.7928396e-03 1.7916812e-02 1.3486147e-02 1.4679179e-02 1.5234857e-02 9.8252597e-03 6.6418795e-03 1.5750844e-02 1.5329612e-02 4.8910204e-03 3.6066589e-02 2.2910372e-03 2.3340599e-03 9.3688224e-04 2.4554705e-03 2.5753402e-03 2.7405365e-03 2.7122854e-03 2.7122854e-03 2.5548933e-03 2.8696775e-03 3.0281586e-03 3.2581988e-03 3.3806164e-03 3.0275681e-03 2.5141839e-03 3.0267385e-03 3.2254776e-03 3.0454804e-03 3.5440636e-03 3.9939116e-03 2.8783401e-03 3.0147872e-03 4.2413279e-03 1.9166341e-03 1.0328838e-02 1.0338885e-02 1.0012588e-02 1.0367239e-02 1.0395234e-02 1.0433814e-02 1.0427216e-02 1.0427216e-02 1.0390459e-02 1.0463973e-02 1.0375977e-02 1.0679717e-02 1.0682608e-02 1.0057296e-02 9.3710089e-03 9.6096249e-03 8.9905504e-03 8.6635105e-03 1.0305585e-02 1.0910769e-02 8.9126034e-03 8.9432415e-03 1.1243619e-02 9.6140668e-03 1.1626308e-02
    -6.4726124e-02 -6.5386049e-02 -4.4253394e-02 -6.7371266e-02 -6.8966744e-02 -7.1435176e-02 6.0699165e-01 -2.5620199e-01 -6.8996956e-02 -7.3357034e-02 -3.0951415e-02 -2.8221459e-02 0.0000000e+00 -1.8675725e-02 -2.3950979e-03 -1.4313044e-03 1.2651720e-03 2.5211077e-03 4.2097084e-03 9.1149369e-03 3.6873338e-03 2.7352702e-03 1.1812813e-02 -1.8252823e-02 1.7483390e-01 1.7257567e-01 2.4591256e-01 1.6620291e-01 1.5991103e-01 1.5123999e-01 1.5272287e-01 1.5272287e-01 1.6098427e-01 1.4446147e-01 1.2893206e-01 1.3127910e-01 1.2337116e-01 1.1058856e-01 8.2274156e-02 8.4820305e-02 7.0551447e-02 7.3517950e-02 9.0842295e-02 9.6078808e-02 7.6272560e-02 7.4023799e-02 9.8958891e-02 1.4426743e-01 4.8568716e-02 4.8485546e-02 5.1186511e-02 4.8250840e-02 4.8019113e-02 4.7699762e-02 4.7754376e-02 4.7754376e-02 4.8058640e-02 4.7450112e-02 4.8178516e-02 4.5664267e-02 4.5640331e-02 5.0816440e-02 5.6497271e-02 5.4522094e-02 5.9646566e-02 6.2353683e-02 4.8761188e-02 4.3751704e-02 6.0291784e-02 6.0038172e-02 4.0996488e-02 5.4485326e-02 3.7828729e-02
    6.4726124e-02 6.5386049e-02 4.4253394e-02 6.7371266e-02 6.8966744e-02 7.1435176e-02 3.9300835e-01 2.5620199e-01 6.8996956e-02 7.3357034e-02 3.0951415e-02 2.8221459e-02 0.0000000e+00 1.8675725e-02 2.3950979e-03 1.4313044e-03 -1.2651720e-03 -2.5211077e-03 -4.2097084e-03 -9.1149369e-03 -3.6873338e-03 -2.7352702e-03 -1.1812813e-02 1.8252823e-02 -1.7483390e-01 -1.7257567e-01 -2.4591256e-01 -1.6620291e-01 -1.5991103e-01 -1.5123999e-01 -1.5272287e-01 -1.5272287e-01 -1.6098427e-01 -1.4446147e-01 -1.2893206e-01 -1.3127910e-01 -1.2337116e-01 -1.1058856e-01 -8.2274156e-02 -8.4820305e-02 -7.0551447e-02 -7.3517950e-02 -9.0842295e-02 -9.6078808e-02 -7.6272560e-02 -7.4023799e-02 -9.8958891e-02 -1.4426743e-01 -4.8568716e-02 -4.8485546e-02 -5.1186511e-02 -4.8250840e-02 -4.8019113e-02 -4.7699762e-02 -4.7754376e-02 -4.7754376e-02 -4.8058640e-02 -4.7450112e-02 -4.8178516e-02 -4.5664267e-02 -4.5640331e-02 -5.0816440e-02 -5.6497271e-02 -5.4522094e-02 -5.9646566e-02 -6.2353683e-02 -4.8761188e-02 -4.3751704e-02 -6.0291784e-02 -6.0038172e-02 -4.0996488e-02 -5.4485326e-02 -3.7828729e-02
    -1.3618622e-02 -1.5906772e-02 -5.1766335e-02 -6.7706110e-02 1.5641282e-02 3.1023690e-02 3.0509306e-01 3.7430219e-01 -1.1012446e-01 4.5933888e-02 -1.4833310e-02 -1.2786309e-02 0.0000000e+00 -1.1489196e-02 -9.2693204e-03 -6.7915108e-03 -5.9820024e-03 -5.6049583e-03 -2.3239828e-03 1.5608241e-03 -5.2548459e-03 -5.5406646e-03 3.6974679e-03 -2.5369020e-02 8.6308017e-02 8.5160505e-02 1.2242633e-01 8.1922216e-02 7.8725025e-02 7.4318874e-02 7.5072393e-02 7.5072393e-02 7.9270388e-02 7.0874398e-02 6.3045093e-02 6.4113936e-02 6.0108275e-02 5.3881652e-02 3.9968183e-02 4.1009198e-02 3.3791479e-02 3.5354532e-02 4.3784460e-02 4.6197732e-02 3.6805938e-02 3.5621064e-02 4.7525031e-02 7.1206880e-02 1.9609173e-02 1.9563098e-02 2.1059416e-02 1.9433072e-02 1.9304697e-02 1.9127778e-02 1.9158034e-02 1.9158034e-02 1.9326594e-02 1.8989474e-02 1.9393005e-02 1.8000126e-02 1.7986866e-02 2.0854399e-02 2.4001546e-02 2.2907310e-02 2.5746237e-02 2.7245964e-02 1.9715802e-02 1.6940577e-02 2.6103684e-02 2.5963184e-02 1.5414204e-02 2.2886941e-02 1.3659285e-02
    -5.1107502e-02 -4.9479277e-02 7.5129412e-03 3.3484331e-04 -8.4608026e-02 -1.0245887e-01 3.0189859e-01 3.6949581e-01 4.1127509e-02 -1.1929092e-01 -1.6118104e-02 -1.5435150e-02 0.0000000e+00 -7.1865295e-03 6.8742224e-03 5.3602064e-03 7.2471744e-03 8.1260660e-03 6.5336912e-03 7.5541127e-03 8.9421797e-03 8.2759348e-03 8.1153446e-03 7.1161966e-03 8.8525885e-02 8.7415162e-02 1.2348624e-01 8.4280693e-02 8.1186005e-02 7.6921117e-02 7.7650477e-02 7.7650477e-02 8.1713884e-02 7.3587071e-02 6.5886963e-02 6.7165163e-02 6.3262884e-02 5.6706904e-02 4.2305973e-02 4.3811107e-02 3.6759968e-02 3.8163418e-02 4.7057835e-02 4.9881076e-02 3.9466622e-02 3.8402735e-02 5.1433859e-02 7.3060553e-02 2.8959542e-02 2.8922448e-02 3.0127094e-02 2.8817768e-02 2.8714416e-02 2.8571984e-02 2.8596342e-02 2.8596342e-02 2.8732045e-02 2.8460639e-02 2.8785511e-02 2.7664141e-02 2.7653465e-02 2.9962040e-02 3.2495725e-02 3.1614784e-02 3.3900329e-02 3.5107719e-02 2.9045386e-02 2.6811126e-02 3.4188100e-02 3.4074988e-02 2.5582284e-02 3.1598386e-02 2.4169445e-02
    1.5070383e-01 1.5624100e-01 1.8771064e-01 2.5882846e-01 1.0217740e-01 7.7086352e-02 1.3428625e-01 1.6110985e-01 3.4283709e-01 5.1938262e-02 -1.2621395e-01 8.9854058e-02 0.0000000e+00 -6.6668659e-02 3.2854477e-02 1.6978300e-02 2.2834029e-02 2.5561448e-02 2.2926835e-02 2.8099474e-02 2.8094051e-02 2.6026528e-02 3.0944425e-02 9.1520662e-02 5.0178605e-02 4.9755704e-02 6.3489532e-02 4.8562275e-02 4.7383993e-02 4.5760164e-02 4.6037864e-02 4.6037864e-02 4.7584979e-02 4.4490748e-02 4.1448311e-02 4.2156319e-02 4.0647801e-02 3.7671055e-02 3.0136106e-02 3.2364910e-02 3.1462364e-02 3.1126747e-02 3.4110259e-02 3.5627954e-02 3.0815101e-02 3.1069517e-02 3.6462686e-02 4.2771820e-02 3.2036423e-02 3.2029117e-02 3.2266370e-02 3.2008501e-02 3.1988146e-02 3.1960094e-02 3.1964892e-02 3.1964892e-02 3.1991618e-02 3.1938165e-02 3.2002148e-02 3.1781297e-02 3.1779194e-02 3.2233863e-02 3.2732866e-02 3.2559367e-02 3.3009499e-02 3.3247292e-02 3.2053330e-02 3.1613298e-02 3.3066175e-02 3.3043898e-02 3.1371280e-02 3.2556137e-02 3.1093025e-02
    1.6492254e-01 1.7010327e-01 2.1314407e-01 2.7168314e-01 1.1404240e-01 8.7583656e-02 1.4048731e-01 1.6923564e-01 3.5486665e-01 6.1366488e-02 1.0188362e-01 -1.2256922e-01 0.0000000e+00 8.8183673e-02 8.1043941e-02 6.8938507e-02 7.2084796e-02 7.3550240e-02 4.2274960e-02 1.9089266e-02 7.4911010e-02 7.3800128e-02 6.3371346e-03 1.3108916e-01 5.1333167e-02 5.0911332e-02 6.4610574e-02 4.9720908e-02 4.8545593e-02 4.6925854e-02 4.7202854e-02 4.7202854e-02 4.8746074e-02 4.5659634e-02 4.2010562e-02 4.3945380e-02 4.2314381e-02 3.6677482e-02 2.6858195e-02 2.9185775e-02 2.4281203e-02 2.4933327e-02 3.3753018e-02 3.7724533e-02 2.5538870e-02 2.5044527e-02 3.9908866e-02 4.1160423e-02 5.8421885e-02 5.8452441e-02 5.7460124e-02 5.8538671e-02 5.8623806e-02 5.8741133e-02 5.8721068e-02 5.8721068e-02 5.8609284e-02 5.8832853e-02 5.8565242e-02 5.9488961e-02 5.9497754e-02 5.7596086e-02 5.5508986e-02 5.6234653e-02 5.4351956e-02 5.3357379e-02 5.8351172e-02 6.0191624e-02 5.4114907e-02 5.4208082e-02 6.1203872e-02 5.6248161e-02 6.2367686e-02
    2.2548160e-01 2.2352140e-01 7.5764066e-02 1.3097679e-01 2.9769557e-01 3.3654859e-01 1.4245290e-01 1.7279237e-01 5.5192229e-02 3.7245827e-01 -1.2559278e-01 9.6308138e-02 0.0000000e+00 -7.5980674e-02 2.0981092e-03 -6.2874831e-03 -2.4303770e-03 -6.3385568e-04 6.1237806e-03 1.6916184e-02 1.0343427e-03 -3.2751244e-04 2.2852006e-02 3.0005947e-02 4.6628017e-02 4.6127669e-02 6.2376610e-02 4.4715685e-02 4.3321620e-02 4.1400416e-02 4.1728971e-02 4.1728971e-02 4.3559414e-02 3.9898528e-02 3.6561100e-02 3.6874410e-02 3.5143529e-02 3.2760182e-02 2.6057243e-02 2.7420796e-02 2.6182537e-02 2.6150830e-02 2.8279532e-02 2.9026259e-02 2.6121389e-02 2.6145424e-02 2.9436958e-02 3.9816584e-02 1.4414502e-02 1.4389707e-02 1.5194926e-02 1.4319736e-02 1.4250653e-02 1.4155448e-02 1.4171729e-02 1.4171729e-02 1.4262437e-02 1.4081021e-02 1.4298175e-02 1.3548620e-02 1.3541484e-02 1.5084600e-02 1.6778185e-02 1.6189340e-02 1.7717061e-02 1.8524114e-02 1.4471883e-02 1.2978442e-02 1.7909415e-02 1.7833808e-02 1.2157049e-02 1.6178378e-02 1.1212668e-02
    2.3991043e-01 2.3758853e-01 1.0157336e-01 1.4402144e-01 3.0973592e-01 3.4720103e-01 1.4874560e-01 1.8103823e-01 6.7399569e-02 3.8202583e-01 1.0587570e-01 -1.1925440e-01 0.0000000e+00 8.1160116e-02 5.0999733e-02 4.6440609e-02 4.7548233e-02 4.8064130e-02 2.5757838e-02 7.7728206e-03 4.8543178e-02 4.8152101e-02 -2.1189392e-03 7.0159199e-02 4.7799642e-02 4.7300375e-02 6.3514219e-02 4.5891440e-02 4.4500387e-02 4.2583332e-02 4.2911178e-02 4.2911178e-02 4.4737667e-02 4.1084688e-02 3.7131660e-02 3.8689911e-02 3.6834738e-02 3.1751925e-02 2.2730891e-02 2.4194679e-02 1.8895250e-02 1.9865882e-02 2.7917011e-02 3.1153821e-02 2.0767184e-02 2.0031395e-02 3.2934067e-02 3.8181372e-02 4.1189897e-02 4.1203524e-02 4.0761003e-02 4.1241978e-02 4.1279943e-02 4.1332265e-02 4.1323317e-02 4.1323317e-02 4.1273467e-02 4.1373167e-02 4.1253827e-02 4.1665757e-02 4.1669678e-02 4.0821635e-02 3.9890898e-02 4.0214507e-02 3.9374923e-02 3.8931395e-02 4.1158363e-02 4.1979108e-02 3.9269212e-02 3.9310763e-02 4.2430517e-02 4.0220531e-02 4.2949516e-02
    3.8134449e-01 3.8192970e-01 3.6283892e-01 3.8354584e-01 3.8524627e-01 3.8751217e-01 2.9454569e-01 3.3387978e-01 3.8486928e-01 3.8928576e-01 6.1236993e-01 2.0122406e-01 0.0000000e+00 4.9352451e-01 3.2538983e-01 3.2657499e-01 3.2152955e-01 3.1917954e-01 2.6755971e-01 2.1624208e-01 3.1699738e-01 3.1877881e-01 1.8801738e-01 3.3957716e-01 1.7744319e-01 1.7702108e-01 1.9072949e-01 1.7582986e-01 1.7465375e-01 1.7303293e-01 1.7331012e-01 1.7331012e-01 1.7485437e-01 1.7176586e-01 1.6655243e-01 1.7161238e-01 1.6965921e-01 1.5723573e-01 1.2917544e-01 1.4414798e-01 1.4798977e-01 1.4322869e-01 1.5590445e-01 1.6612747e-01 1.3880768e-01 1.4241683e-01 1.7175013e-01 1.5249477e-01 2.4857300e-01 2.4869980e-01 2.4458201e-01 2.4905762e-01 2.4941090e-01 2.4989777e-01 2.4981451e-01 2.4981451e-01 2.4935064e-01 2.5027838e-01 2.4916788e-01 2.5300101e-01 2.5303750e-01 2.4514621e-01 2.3648544e-01 2.3949671e-01 2.3168415e-01 2.2755698e-01 2.4827956e-01 2.5591683e-01 2.3070047e-01 2.3108712e-01 2.6011732e-01 2.3955277e-01 2.6494676e-01
    -5.1590598e-03 -2.1673111e-03 -9.9364212e-02 6.2594110e-03 1.4626695e-02 2.6122774e-02 -1.7806537e-02 2.2440452e-05 1.3160034e-02 3.5110770e-02 1.3582334e-01 -1.5061860e-02 0.0000000e+00 -6.3617385e-01 -2.9043724e-01 -3.1588418e-01 -3.0112590e-01 -2.9425195e-01 -2.3850910e-01 -1.7122642e-01 -2.8786899e-01 -2.9307980e-01 -1.3422095e-01 -2.1805055e-01 -8.0636572e-02 -8.1137702e-02 -6.4863346e-02 -8.2551895e-02 -8.3948140e-02 -8.5872350e-02 -8.5543281e-02 -8.5543281e-02 -8.3709975e-02 -8.7376587e-02 -8.8543016e-02 -9.2581655e-02 -9.3867881e-02 -8.6804491e-02 -7.2982092e-02 -8.4362278e-02 -9.0344867e-02 -8.5951110e-02 -9.3514662e-02 -1.0147326e-01 -8.1871194e-02 -8.5201886e-02 -1.0585048e-01 -6.9906361e-02 -2.0212207e-01 -2.0228097e-01 -1.9712072e-01 -2.0272938e-01 -2.0317210e-01 -2.0378223e-01 -2.0367789e-01 -2.0367789e-01 -2.0309659e-01 -2.0425919e-01 -2.0286756e-01 -2.0767109e-01 -2.0771682e-01 -1.9782775e-01 -1.8697439e-01 -1.9074801e-01 -1.8095759e-01 -1.7578558e-01 -2.0175435e-01 -2.1132509e-01 -1.7972488e-01 -1.8020941e-01 -2.1658899e-01 -1.9081825e-01 -2.2264107e-01
    3.5571527e-01 3.5694296e-01 3.1699517e-01 3.6037528e-01 3.6385961e-01 3.6859078e-01 2.8336829e-01 3.1923306e-01 3.6318600e-01 3.7229139e-01 2.0122406e-01 5.8411701e-01 0.0000000e+00 2.1440318e-01 2.3852832e-01 2.3291672e-01 2.3275504e-01 2.3267974e-01 2.3268472e-01 2.3248298e-01 2.3260982e-01 2.3266690e-01 2.3237202e-01 2.6825494e-01 1.7536209e-01 1.7493806e-01 1.8870881e-01 1.7374142e-01 1.7255997e-01 1.7093177e-01 1.7121022e-01 1.7121022e-01 1.7276150e-01 1.6965895e-01 1.6553897e-01 1.6838760e-01 1.6665520e-01 1.5902664e-01 1.3508387e-01 1.4987837e-01 1.6093381e-01 1.5439233e-01 1.5654838e-01 1.6234839e-01 1.4831809e-01 1.5327687e-01 1.6553839e-01 1.5539931e-01 2.0101320e-01 2.0107176e-01 1.9917027e-01 2.0123699e-01 2.0140013e-01 2.0162495e-01 2.0158650e-01 2.0158650e-01 2.0137230e-01 2.0180070e-01 2.0128791e-01 2.0305794e-01 2.0307479e-01 1.9943080e-01 1.9543148e-01 1.9682201e-01 1.9321437e-01 1.9130855e-01 2.0087770e-01 2.0440439e-01 1.9276013e-01 1.9293868e-01 2.0634407e-01 1.9684789e-01 2.0857418e-01
    4.9117704e-02 5.0748840e-02 -2.2777447e-03 5.5329299e-02 5.9918712e-02 6.6193905e-02 5.8646195e-03 3.1040811e-02 5.9080226e-02 7.1100931e-02 6.5352621e-03 1.7405938e-01 0.0000000e+00 -4.5059396e-02 -1.0648465e-01 -1.1753761e-01 -1.1312202e-01 -1.1106537e-01 -1.6465192e-01 -2.0562089e-01 -1.0915563e-01 -1.1071467e-01 -2.2815383e-01 -6.7006585e-02 -7.6229286e-02 -7.6726350e-02 -6.0584017e-02 -7.8129071e-02 -7.9513989e-02 -8.1422589e-02 -8.1096189e-02 -8.1096189e-02 -7.9277756e-02 -8.2914623e-02 -8.6396747e-02 -8.5752308e-02 -8.7506079e-02 -9.0597235e-02 -8.5494788e-02 -9.6497920e-02 -1.1775736e-01 -1.0959312e-01 -9.4878351e-02 -9.3470031e-02 -1.0201204e-01 -1.0820095e-01 -9.2695455e-02 -7.6057515e-02 -1.0140142e-01 -1.0141579e-01 -1.0094914e-01 -1.0145634e-01 -1.0149638e-01 -1.0155155e-01 -1.0154212e-01 -1.0154212e-01 -1.0148955e-01 -1.0159468e-01 -1.0146884e-01 -1.0190323e-01 -1.0190736e-01 -1.0101308e-01 -1.0003160e-01 -1.0037285e-01 -9.9487489e-02 -9.9019777e-02 -1.0136817e-01 -1.0223366e-01 -9.9376014e-02 -9.9419830e-02 -1.0270968e-01 -1.0037920e-01 -1.0325698e-01
    -1.4149328e-01 -1.4035201e-01 -1.7743344e-01 -1.3713875e-01 -1.3394421e-01 -1.2955803e-01 -1.4980241e-01 -1.4151986e-01 -1.3450742e-01 -1.2612869e-01 -1.0373373e-01 -1.2820525e-01 0.0000000e+00 -1.6853005e-01 -2.5032610e-01 -2.5955345e-01 -2.5454112e-01 -2.5220653e-01 -3.1195521e-01 -3.5752195e-01 -2.5003870e-01 -2.5180844e-01 -3.8258366e-01 -2.2271122e-01 -1.8174277e-01 -1.8206302e-01 -1.7166290e-01 -1.8296676e-01 -1.8385903e-01 -1.8508869e-01 -1.8487840e-01 -1.8487840e-01 -1.8370683e-01 -1.8604998e-01 -1.8765925e-01 -1.8851240e-01 -1.8951195e-01 -1.8874955e-01 -1.6985081e-01 -1.9028115e-01 -2.2008376e-01 -2.0737200e-01 -1.9215543e-01 -1.9378524e-01 -1.9556823e-01 -2.0520439e-01 -1.9468163e-01 -1.7053731e-01 -2.2396059e-01 -2.2400892e-01 -2.2243954e-01 -2.2414529e-01 -2.2427994e-01 -2.2446549e-01 -2.2443376e-01 -2.2443376e-01 -2.2425697e-01 -2.2461055e-01 -2.2418732e-01 -2.2564821e-01 -2.2566212e-01 -2.2265456e-01 -2.1935375e-01 -2.2050141e-01 -2.1752386e-01 -2.1595091e-01 -2.2384876e-01 -2.2675949e-01 -2.1714896e-01 -2.1729632e-01 -2.2836040e-01 -2.2052278e-01 -2.3020101e-01
    -1.2144696e-01 -1.2077534e-01 -1.4273247e-01 -1.1894014e-01 -1.1694992e-01 -1.1433903e-01 -2.7228361e-01 -2.0536730e-01 -1.1743729e-01 -1.1229416e-01 -8.2672282e-02 -8.6453679e-02 0.0000000e+00 -1.2354225e-01 -1.8575575e-01 -1.8095483e-01 -1.9117428e-01 -1.9593419e-01 -1.8780036e-01 -1.9375299e-01 -2.0035410e-01 -1.9674585e-01 -1.9702694e-01 -1.6945668e-01 -4.6545194e-01 -4.6597785e-01 -4.4889880e-01 -4.6746197e-01 -4.6892725e-01 -4.7094660e-01 -4.7060126e-01 -4.7060126e-01 -4.6867731e-01 -4.7252522e-01 -4.8024935e-01 -4.7148762e-01 -4.7417365e-01 -4.9498808e-01 -5.6588988e-01 -5.1569249e-01 -4.7099267e-01 -4.9500698e-01 -4.9539174e-01 -4.7773891e-01 -5.1730599e-01 -4.9910191e-01 -4.6802986e-01 -5.2156862e-01 -3.2645320e-01 -3.2621953e-01 -3.3380818e-01 -3.2556010e-01 -3.2490903e-01 -3.2401178e-01 -3.2416523e-01 -3.2416523e-01 -3.2502009e-01 -3.2331037e-01 -3.2535690e-01 -3.1829284e-01 -3.1822559e-01 -3.3276843e-01 -3.4872934e-01 -3.4317987e-01 -3.5757762e-01 -3.6518356e-01 -3.2699397e-01 -3.1291929e-01 -3.5939043e-01 -3.5867788e-01 -3.0517821e-01 -3.4307656e-01 -2.9627805e-01
    -5.1590598e-03 -2.1673111e-03 -9.9364212e-02 6.2594110e-03 1.4626695e-02 2.6122774e-02 -1.7806537e-02 2.2440452e-05 1.3160034e-02 3.5110770e-02 1.3582334e-01 -1.5061860e-02 0.0000000e+00 3.6382615e-01 -2.9043724e-01 -3.1588418e-01 -3.0112590e-01 -2.9425195e-01 -2.3850910e-01 -1.7122642e-01 -2.8786899e-01 -2.9307980e-01 -1.3422095e-01 -2.1805055e-01 -8.0636572e-02 -8.1137702e-02 -6.4863346e-02 -8.2551895e-02 -8.3948140e-02 -8.5872350e-02 -8.5543281e-02 -8.5543281e-02 -8.3709975e-02 -8.7376587e-02 -8.8543016e-02 -9.2581655e-02 -9.3867881e-02 -8.6804491e-02 -7.2982092e-02 -8.4362278e-02 -9.0344867e-02 -8.5951110e-02 -9.3514662e-02 -1.0147326e-01 -8.1871194e-02 -8.5201886e-02 -1.0585048e-01 -6.9906361e-02 -2.0212207e-01 -2.0228097e-01 -1.9712072e-01 -2.0272938e-01 -2.0317210e-01 -2.0378223e-01 -2.0367789e-01 -2.0367789e-01 -2.0309659e-01 -2.0425919e-01 -2.0286756e-01 -2.0767109e-01 -2.0771682e-01 -1.9782775e-01 -1.8697439e-01 -1.9074801e-01 -1.8095759e-01 -1.7578558e-01 -2.0175435e-01 -2.1132509e-01 -1.7972488e-01 -1.8020941e-01 -2.1658899e-01 -1.9081825e-01 -2.2264107e-01
    1.0994552e-01 1.0464858e-01 2.7666069e-01 8.9697477e-02 7.4945340e-02 5.4608131e-02 4.9946407e-02 5.3404725e-02 7.7454054e-02 3.8709864e-02 -3.3463483e-03 1.5844518e-02 0.0000000e+00 -6.6215245e-02 6.1488645e-01 -1.5453108e-01 1.0753847e-01 2.2960240e-01 -1.0882551e-01 -6.9081539e-02 3.4294747e-01 2.5041677e-01 -4.7222356e-02 4.8675197e-01 4.6663005e-02 4.6848684e-02 4.0818716e-02 4.7372670e-02 4.7890006e-02 4.8602963e-02 4.8481037e-02 4.8481037e-02 4.7801761e-02 4.9160313e-02 4.6635949e-02 5.4045441e-02 5.3914239e-02 3.8457989e-02 2.1180538e-02 2.6969902e-02 1.1551321e-02 1.3988053e-02 4.3963679e-02 5.8740876e-02 1.6250733e-02 1.4403565e-02 6.6868335e-02 2.8620325e-02 2.1288963e-01 2.1313064e-01 2.0530375e-01 2.1381077e-01 2.1448228e-01 2.1540769e-01 2.1524943e-01 2.1524943e-01 2.1436773e-01 2.1613113e-01 2.1402036e-01 2.2130618e-01 2.2137554e-01 2.0637615e-01 1.8991416e-01 1.9563785e-01 1.8078809e-01 1.7294337e-01 2.1233188e-01 2.2684843e-01 1.7891837e-01 1.7965329e-01 2.3483253e-01 1.9574440e-01 2.4401210e-01
    2.2154978e-02 2.1255592e-02 5.0446890e-02 1.8710717e-02 1.6218316e-02 1.2768535e-02 -4.4634107e-03 3.1085961e-03 1.6626724e-02 1.0072126e-02 8.2211719e-03 5.7977204e-03 0.0000000e+00 1.0422532e-02 1.0786110e-01 1.3514919e-02 -1.2315499e-01 -1.8681163e-01 7.9759025e-03 3.1593661e-03 -2.4592136e-01 -1.9766637e-01 5.1027114e-04 8.6110121e-02 -3.3884267e-02 -3.4184049e-02 -2.4448543e-02 -3.5030035e-02 -3.5865285e-02 -3.7016369e-02 -3.6819516e-02 -3.6819516e-02 -3.5722811e-02 -3.7916221e-02 -3.7427763e-02 -4.2216181e-02 -4.2741764e-02 -3.3365039e-02 -2.2344408e-02 -2.7657879e-02 -2.0910614e-02 -2.1273444e-02 -3.8590602e-02 -4.8097317e-02 -2.1610358e-02 -2.1335314e-02 -5.3326011e-02 -2.3141545e-02 -1.5519181e-01 -1.5535994e-01 -1.4989983e-01 -1.5583441e-01 -1.5630286e-01 -1.5694844e-01 -1.5683803e-01 -1.5683803e-01 -1.5622295e-01 -1.5745311e-01 -1.5598062e-01 -1.6106327e-01 -1.6111166e-01 -1.5064794e-01 -1.3916391e-01 -1.4315681e-01 -1.3279748e-01 -1.2732494e-01 -1.5480272e-01 -1.6492960e-01 -1.3149315e-01 -1.3200584e-01 -1.7049938e-01 -1.4323114e-01 -1.7690313e-01
    2.2154978e-02 2.1255592e-02 5.0446890e-02 1.8710717e-02 1.6218316e-02 1.2768535e-02 -4.4634107e-03 3.1085961e-03 1.6626724e-02 1.0072126e-02 8.2211719e-03 5.7977204e-03 0.0000000e+00 1.0422532e-02 1.0786110e-01 1.3514919e-02 -1.2315499e-01 -1.8681163e-01 7.9759025e-03 3.1593661e-03 -2.4592136e-01 -1.9766637e-01 5.1027114e-04 8.6110121e-02 -3.3884267e-02 -3.4184049e-02 -2.4448543e-02 -3.5030035e-02 -3.5865285e-02 -3.7016369e-02 -3.6819516e-02 -3.6819516e-02 -3.5722811e-02 -3.7916221e-02 -3.7427763e-02 -4.2216181e-02 -4.2741764e-02 -3.3365039e-02 -2.2344408e-02 -2.7657879e-02 -2.0910614e-02 -2.1273444e-02 -3.8590602e-02 -4.8097317e-02 -2.1610358e-02 -2.1335314e-02 -5.3326011e-02 -2.3141545e-02 -1.5519181e-01 -1.5535994e-01 -1.4989983e-01 -1.5583441e-01 -1.5630286e-01 -1.5694844e-01 -1.5683803e-01 -1.5683803e-01 -1.5622295e-01 -1.5745311e-01 -1.5598062e-01 -1.6106327e-01 -1.6111166e-01 -1.5064794e-01 -1.3916391e-01 -1.4315681e-01 -1.3279748e-01 -1.2732494e-01 -1.5480272e-01 -1.6492960e-01 -1.3149315e-01 -1.3200584e-01 -1.7049938e-01 -1.4323114e-01 -1.7690313e-01
    -1.5425547e-01 -1.4715976e-01 -3.7755447e-01 -1.2711891e-01 -1.0738197e-01 -8.0145200e-02 -4.1019586e-02 -5.9621918e-02 -1.1070750e-01 -5.8854115e-02 -1.3095996e-02 -2.7439959e-02 0.0000000e+00 4.5370181e-02 1.6939136e-01 1.2750124e-01 1.3877151e-01 1.4402085e-01 9.2873705e-02 6.2762807e-02 1.4889525e-01 1.4491597e-01 4.6201813e-02 -6.5897221e-01 2.1105529e-02 2.1519414e-02 8.0783710e-03 2.2687401e-02 2.3840564e-02 2.5429775e-02 2.5157996e-02 2.5157996e-02 2.3643862e-02 2.6672129e-02 2.8219577e-02 3.0386921e-02 3.1569289e-02 2.8272089e-02 2.3508279e-02 2.8345856e-02 3.0269907e-02 2.8558835e-02 3.3217525e-02 3.7453758e-02 2.6969984e-02 2.8267063e-02 3.9783687e-02 1.7662765e-02 9.7493992e-02 9.7589244e-02 9.4495913e-02 9.7858045e-02 9.8123435e-02 9.8489177e-02 9.8426630e-02 9.8426630e-02 9.8078166e-02 9.8775094e-02 9.7940876e-02 1.0082037e-01 1.0084778e-01 9.4919743e-02 8.8413664e-02 9.0675772e-02 8.4806873e-02 8.1706496e-02 9.7273560e-02 1.0301077e-01 8.4067926e-02 8.4358379e-02 1.0616623e-01 9.0717882e-02 1.0979417e-01
    -1.5874377e-02 -1.4942799e-02 -4.5209892e-02 -1.2319562e-02 -9.7127601e-03 -6.1327126e-03 -2.1635013e-02 -1.5308664e-02 -1.0171400e-02 -3.3336749e-03 9.3146661e-03 2.9848038e-04 0.0000000e+00 3.3154964e-02 -1.0470826e-01 6.6644906e-02 -6.3251440e-01 -4.9239207e-01 4.5402753e-02 2.6931316e-02 -3.6227847e-01 -4.6849837e-01 1.6772026e-02 -8.2167713e-02 -4.9713305e-02 -5.0074886e-02 -3.8332424e-02 -5.1095271e-02 -5.2102706e-02 -5.3491084e-02 -5.3253650e-02 -5.3253650e-02 -5.1930862e-02 -5.4576439e-02 -5.3221994e-02 -6.0528119e-02 -6.1004731e-02 -4.6371649e-02 -2.9479184e-02 -3.6748544e-02 -2.4738984e-02 -2.5938520e-02 -5.3456023e-02 -6.7984266e-02 -2.7052376e-02 -2.6143066e-02 -7.5974799e-02 -3.2833173e-02 -2.2740396e-01 -2.2765390e-01 -2.1953714e-01 -2.2835922e-01 -2.2905559e-01 -2.3001528e-01 -2.2985116e-01 -2.2985116e-01 -2.2893681e-01 -2.3076551e-01 -2.2857656e-01 -2.3613221e-01 -2.3620414e-01 -2.2064925e-01 -2.0357760e-01 -2.0951327e-01 -1.9411355e-01 -1.8597830e-01 -2.2682556e-01 -2.4187972e-01 -1.9217459e-01 -1.9293672e-01 -2.5015951e-01 -2.0962376e-01 -2.5967904e-01
    1.2066083e-01 1.1742407e-01 2.2250637e-01 1.0827645e-01 9.9284794e-02 8.6863618e-02 5.3774883e-02 6.8735830e-02 1.0078549e-01 7.7154308e-02 1.2316232e-01 4.8417698e-04 0.0000000e+00 2.6445594e-01 4.2915747e-01 4.6293984e-01 4.3892697e-01 4.2774252e-01 -3.9273736e-01 -2.6723928e-01 4.1735695e-01 4.2583534e-01 -1.9821533e-01 3.5086913e-01 1.5739738e-02 1.5785868e-02 1.4287794e-02 1.5916046e-02 1.6044572e-02 1.6221698e-02 1.6191406e-02 1.6191406e-02 1.6022648e-02 1.6360164e-02 1.1314927e-02 2.1991905e-02 2.1051089e-02 -1.9748536e-03 -2.2322370e-02 -2.0643832e-02 -5.4054562e-02 -4.6024537e-02 3.9050407e-03 2.5251886e-02 -3.8568085e-02 -4.4655255e-02 3.6992651e-02 -8.4528630e-03 2.3817152e-01 2.3850357e-01 2.2772017e-01 2.3944061e-01 2.4036576e-01 2.4164074e-01 2.4142270e-01 2.4142270e-01 2.4020795e-01 2.4263745e-01 2.3972936e-01 2.4976730e-01 2.4986286e-01 2.2919765e-01 2.0651737e-01 2.1440311e-01 1.9394406e-01 1.8313610e-01 2.3740309e-01 2.5740306e-01 1.9136808e-01 1.9238060e-01 2.6840305e-01 2.1454991e-01 2.8105008e-01
    -1.3731336e-02 -1.2925521e-02 -3.9106556e-02 -1.0656421e-02 -8.4015375e-03 -5.3047964e-03 -1.8714286e-02 -1.3241995e-02 -8.7982606e-03 -2.8836287e-03 8.0571862e-03 2.5818553e-04 0.0000000e+00 2.8679044e-02 -9.0572642e-02 5.7647844e-02 3.1787504e-01 -4.9091914e-01 3.9273382e-02 2.3295589e-02 -3.1337087e-01 -6.5251092e-02 1.4507802e-02 -7.1075072e-02 -4.3002009e-02 -4.3314777e-02 -3.3157547e-02 -4.4197410e-02 -4.5068841e-02 -4.6269788e-02 -4.6064408e-02 -4.6064408e-02 -4.4920196e-02 -4.7208620e-02 -4.6037025e-02 -5.2356823e-02 -5.2769092e-02 -4.0111476e-02 -2.5499494e-02 -3.1787491e-02 -2.1399221e-02 -2.2436820e-02 -4.6239460e-02 -5.8806390e-02 -2.3400305e-02 -2.2613752e-02 -6.5718201e-02 -2.8400695e-02 -1.9670443e-01 -1.9692062e-01 -1.8989962e-01 -1.9753072e-01 -1.9813308e-01 -1.9896322e-01 -1.9882125e-01 -1.9882125e-01 -1.9803034e-01 -1.9961217e-01 -1.9771873e-01 -2.0425437e-01 -2.0431658e-01 -1.9086160e-01 -1.7609462e-01 -1.8122898e-01 -1.6790822e-01 -1.6087123e-01 -1.9620411e-01 -2.0922596e-01 -1.6623102e-01 -1.6689026e-01 -2.1638798e-01 -1.8132455e-01 -2.2462237e-01
    -2.1430408e-03 -2.0172778e-03 -6.1033354e-03 -1.6631409e-03 -1.3112226e-03 -8.2791620e-04 -2.9207267e-03 -2.0666697e-03 -1.3731389e-03 -4.5004610e-04 1.2574799e-03 4.0294851e-05 0.0000000e+00 4.4759201e-03 -1.4135615e-02 8.9970623e-03 4.9610556e-02 -1.4729289e-03 6.1293717e-03 3.6357277e-03 -4.8907593e-02 -4.0324728e-01 2.2642235e-03 -1.1092641e-02 -6.7112962e-03 -6.7601097e-03 -5.1748773e-03 -6.8978616e-03 -7.0338653e-03 -7.2212964e-03 -7.1892428e-03 -7.1892428e-03 -7.0106664e-03 -7.3678192e-03 -7.1849692e-03 -8.1712961e-03 -8.2356387e-03 -6.2601726e-03 -3.9796899e-03 -4.9610535e-03 -3.3397628e-03 -3.5017002e-03 -7.2165631e-03 -9.1778759e-03 -3.6520707e-03 -3.5293139e-03 -1.0256598e-02 -4.4324783e-03 -3.0699535e-02 -3.0733276e-02 -2.9637514e-02 -3.0828495e-02 -3.0922505e-02 -3.1052063e-02 -3.1029906e-02 -3.1029906e-02 -3.0906469e-02 -3.1153344e-02 -3.0857836e-02 -3.1877849e-02 -3.1887559e-02 -2.9787649e-02 -2.7482976e-02 -2.8284291e-02 -2.6205329e-02 -2.5107071e-02 -3.0621450e-02 -3.2653762e-02 -2.5943569e-02 -2.6046457e-02 -3.3771534e-02 -2.8299208e-02 -3.5056671e-02
    -6.8656678e-03 -6.4627604e-03 -1.9553278e-02 -5.3282105e-03 -4.2007687e-03 -2.6523982e-03 -9.3571430e-03 -6.6209973e-03 -4.3991303e-03 -1.4418144e-03 4.0285931e-03 1.2909276e-04 0.0000000e+00 1.4339522e-02 -4.5286321e-02 2.8823922e-02 1.5893752e-01 2.5454043e-01 1.9636691e-02 1.1647794e-02 -1.5668544e-01 -3.2625546e-02 7.2539012e-03 -3.5537536e-02 -2.1501004e-02 -2.1657388e-02 -1.6578773e-02 -2.2098705e-02 -2.2534420e-02 -2.3134894e-02 -2.3032204e-02 -2.3032204e-02 -2.2460098e-02 -2.3604310e-02 -2.3018513e-02 -2.6178412e-02 -2.6384546e-02 -2.0055738e-02 -1.2749747e-02 -1.5893745e-02 -1.0699610e-02 -1.1218410e-02 -2.3119730e-02 -2.9403195e-02 -1.1700153e-02 -1.1306876e-02 -3.2859101e-02 -1.4200347e-02 -9.8352213e-02 -9.8460310e-02 -9.4949812e-02 -9.8765362e-02 -9.9066542e-02 -9.9481609e-02 -9.9410626e-02 -9.9410626e-02 -9.9015168e-02 -9.9806084e-02 -9.8859363e-02 -1.0212718e-01 -1.0215829e-01 -9.5430801e-02 -8.8047312e-02 -9.0614488e-02 -8.3954110e-02 -8.0435617e-02 -9.8102053e-02 -1.0461298e-01 -8.3115508e-02 -8.3445132e-02 -1.0819399e-01 -9.0662277e-02 -1.1231119e-01
    -6.8656678e-03 -6.4627604e-03 -1.9553278e-02 -5.3282105e-03 -4.2007687e-03 -2.6523982e-03 -9.3571430e-03 -6.6209973e-03 -4.3991303e-03 -1.4418144e-03 4.0285931e-03 1.2909276e-04 0.0000000e+00 1.4339522e-02 -4.5286321e-02 2.8823922e-02 1.5893752e-01 2.5454043e-01 1.9636691e-02 1.1647794e-02 -1.5668544e-01 -3.2625546e-02 7.2539012e-03 -3.5537536e-02 -2.1501004e-02 -2.1657388e-02 -1.6578773e-02 -2.2098705e-02 -2.2534420e-02 -2.3134894e-02 -2.3032204e-02 -2.3032204e-02 -2.2460098e-02 -2.3604310e-02 -2.3018513e-02 -2.6178412e-02 -2.6384546e-02 -2.0055738e-02 -1.2749747e-02 -1.5893745e-02 -1.0699610e-02 -1.1218410e-02 -2.3119730e-02 -2.9403195e-02 -1.1700153e-02 -1.1306876e-02 -3.2859101e-02 -1.4200347e-02 -9.8352213e-02 -9.8460310e-02 -9.4949812e-02 -9.8765362e-02 -9.9066542e-02 -9.9481609e-02 -9.9410626e-02 -9.9410626e-02 -9.9015168e-02 -9.9806084e-02 -9.8859363e-02 -1.0212718e-01 -1.0215829e-01 -9.5430801e-02 -8.8047312e-02 -9.0614488e-02 -8.3954110e-02 -8.0435617e-02 -9.8102053e-02 -1.0461298e-01 -8.3115508e-02 -8.3445132e-02 -1.0819399e-01 -9.0662277e-02 -1.1231119e-01
    6.0330416e-02 5.8712034e-02 1.1125319e-01 5.4138225e-02 4.9642397e-02 4.3431809e-02 2.6887442e-02 3.4367915e-02 5.0392744e-02 3.8577154e-02 6.1581161e-02 2.4208849e-04 0.0000000e+00 1.3222797e-01 2.1457873e-01 2.3146992e-01 2.1946349e-01 2.1387126e-01 3.0363132e-01 -1.3361964e-01 2.0867848e-01 2.1291767e-01 -9.9107666e-02 1.7543457e-01 7.8698690e-03 7.8929338e-03 7.1438969e-03 7.9580229e-03 8.0222859e-03 8.1108488e-03 8.0957032e-03 8.0957032e-03 8.0113242e-03 8.1800822e-03 5.6574637e-03 1.0995953e-02 1.0525544e-02 -9.8742680e-04 -1.1161185e-02 -1.0321916e-02 -2.7027281e-02 -2.3012269e-02 1.9525203e-03 1.2625943e-02 -1.9284043e-02 -2.2327628e-02 1.8496326e-02 -4.2264315e-03 1.1908576e-01 1.1925178e-01 1.1386009e-01 1.1972030e-01 1.2018288e-01 1.2082037e-01 1.2071135e-01 1.2071135e-01 1.2010398e-01 1.2131873e-01 1.1986468e-01 1.2488365e-01 1.2493143e-01 1.1459883e-01 1.0325869e-01 1.0720156e-01 9.6972028e-02 9.1568051e-02 1.1870154e-01 1.2870153e-01 9.5684038e-02 9.6190300e-02 1.3420152e-01 1.0727495e-01 1.4052504e-01
    6.0330416e-02 5.8712034e-02 1.1125319e-01 5.4138225e-02 4.9642397e-02 4.3431809e-02 2.6887442e-02 3.4367915e-02 5.0392744e-02 3.8577154e-02 6.1581161e-02 2.4208849e-04 0.0000000e+00 1.3222797e-01 2.1457873e-01 2.3146992e-01 2.1946349e-01 2.1387126e-01 3.0363132e-01 -1.3361964e-01 2.0867848e-01 2.1291767e-01 -9.9107666e-02 1.7543457e-01 7.8698690e-03 7.8929338e-03 7.1438969e-03 7.9580229e-03 8.0222859e-03 8.1108488e-03 8.0957032e-03 8.0957032e-03 8.0113242e-03 8.1800822e-03 5.6574637e-03 1.0995953e-02 1.0525544e-02 -9.8742680e-04 -1.1161185e-02 -1.0321916e-02 -2.7027281e-02 -2.3012269e-02 1.9525203e-03 1.2625943e-02 -1.9284043e-02 -2.2327628e-02 1.8496326e-02 -4.2264315e-03 1.1908576e-01 1.1925178e-01 1.1386009e-01 1.1972030e-01 1.2018288e-01 1.2082037e-01 1.2071135e-01 1.2071135e-01 1.2010398e-01 1.2131873e-01 1.1986468e-01 1.2488365e-01 1.2493143e-01 1.1459883e-01 1.0325869e-01 1.0720156e-01 9.6972028e-02 9.1568051e-02 1.1870154e-01 1.2870153e-01 9.5684038e-02 9.6190300e-02 1.3420152e-01 1.0727495e-01 1.4052504e-01
    6.0330416e-02 5.8712034e-02 1.1125319e-01 5.4138225e-02 4.9642397e-02 4.3431809e-02 2.6887442e-02 3.4367915e-02 5.0392744e-02 3.8577154e-02 6.1581161e-02 2.4208849e-04 0.0000000e+00 1.3222797e-01 2.1457873e-01 2.3146992e-01 2.1946349e-01 2.1387126e-01 3.0363132e-01 3.6638036e-01 2.0867848e-01 2.1291767e-01 -9.9107666e-02 1.7543457e-01 7.8698690e-03 7.8929338e-03 7.1438969e-03 7.9580229e-03 8.0222859e-03 8.1108488e-03 8.0957032e-03 8.0957032e-03 8.0113242e-03 8.1800822e-03 5.6574637e-03 1.0995953e-02 1.0525544e-02 -9.8742680e-04 -1.1161185e-02 -1.0321916e-02 -2.7027281e-02 -2.3012269e-02 1.9525203e-03 1.2625943e-02 -1.9284043e-02 -2.2327628e-02 1.8496326e-02 -4.2264315e-03 1.1908576e-01 1.1925178e-01 1.1386009e-01 1.1972030e-01 1.2018288e-01 1.2082037e-01 1.2071135e-01 1.2071135e-01 1.2010398e-01 1.2131873e-01 1.1986468e-01 1.2488365e-01 1.2493143e-01 1.1459883e-01 1.0325869e-01 1.0720156e-01 9.6972028e-02 9.1568051e-02 1.1870154e-01 1.2870153e-01 9.5684038e-02 9.6190300e-02 1.3420152e-01 1.0727495e-01 1.4052504e-01
    6.0330416e-02 5.8712034e-02 1.1125319e-01 5.4138225e-02 4.9642397e-02 4.3431809e-02 2.6887442e-02 3.4367915e-02 5.0392744e-02 3.8577154e-02 6.1581161e-02 2.4208849e-04 0.0000000e+00 1.3222797e-01 2.1457873e-01 2.3146992e-01 2.1946349e-01 2.1387126e-01 3.0363132e-01 3.6638036e-01 2.0867848e-01 2.1291767e-01 -9.9107666e-02 1.7543457e-01 7.8698690e-03 7.8929338e-03 7.1438969e-03 7.9580229e-03 8.0222859e-03 8.1108488e-03 8.0957032e-03 8.0957032e-03 8.0113242e-03 8.1800822e-03 5.6574637e-03 1.0995953e-02 1.0525544e-02 -9.8742680e-04 -1.1161185e-02 -1.0321916e-02 -2.7027281e-02 -2.3012269e-02 1.9525203e-03 1.2625943e-02 -1.9284043e-02 -2.2327628e-02 1.8496326e-02 -4.2264315e-03 1.1908576e-01 1.1925178e-01 1.1386009e-01 1.1972030e-01 1.2018288e-01 1.2082037e-01 1.2071135e-01 1.2071135e-01 1.2010398e-01 1.2131873e-01 1.1986468e-01 1.2488365e-01 1.2493143e-01 1.1459883e-01 1.0325869e-01 1.0720156e-01 9.6972028e-02 9.1568051e-02 1.1870154e-01 1.2870153e-01 9.5684038e-02 9.6190300e-02 1.3420152e-01 1.0727495e-01 1.4052504e-01
    2.1430408e-03 2.0172778e-03 6.1033354e-03 1.6631409e-03 1.3112226e-03 8.2791620e-04 2.9207267e-03 2.0666697e-03 1.3731389e-03 4.5004610e-04 -1.2574799e-03 -4.0294851e-05 0.0000000e+00 -4.4759201e-03 1.4135615e-02 -8.9970623e-03 -4.9610556e-02 1.4729289e-03 -6.1293717e-03 -3.6357277e-03 4.8907593e-02 -5.9675272e-01 -2.2642235e-03 1.1092641e-02 6.7112962e-03 6.7601097e-03 5.1748773e-03 6.8978616e-03 7.0338653e-03 7.2212964e-03 7.1892428e-03 7.1892428e-03 7.0106664e-03 7.3678192e-03 7.1849692e-03 8.1712961e-03 8.2356387e-03 6.2601726e-03 3.9796899e-03 4.9610535e-03 3.3397628e-03 3.5017002e-03 7.2165631e-03 9.1778759e-03 3.6520707e-03 3.5293139e-03 1.0256598e-02 4.4324783e-03 3.0699535e-02 3.0733276e-02 2.9637514e-02 3.0828495e-02 3.0922505e-02 3.1052063e-02 3.1029906e-02 3.1029906e-02 3.0906469e-02 3.1153344e-02 3.0857836e-02 3.1877849e-02 3.1887559e-02 2.9787649e-02 2.7482976e-02 2.8284291e-02 2.6205329e-02 2.5107071e-02 3.0621450e-02 3.2653762e-02 2.5943569e-02 2.6046457e-02 3.3771534e-02 2.8299208e-02 3.5056671e-02
    2.8285253e-02 2.7820901e-02 4.2795188e-02 2.6466997e-02 2.5259299e-02 2.3499493e-02 -9.0162908e-02 -4.1743223e-02 2.5358288e-02 2.2126546e-02 2.5963857e-02 4.6338299e-02 0.0000000e+00 5.0866500e-02 7.2346722e-02 8.5848783e-02 7.1263834e-02 6.4470613e-02 1.3065551e-01 1.6961788e-01 5.8162623e-02 6.3312232e-02 1.9104718e-01 6.1151328e-02 -2.4223232e-01 -2.4300350e-01 -2.1795913e-01 -2.4517978e-01 -2.4732845e-01 -2.5028959e-01 -2.4978319e-01 -2.4978319e-01 -2.4696194e-01 -2.5260443e-01 -2.6274107e-01 -2.5227280e-01 -2.5596694e-01 -2.8132164e-01 -2.7766797e-01 -3.0742290e-01 -3.9189568e-01 -3.6298966e-01 -2.8312874e-01 -2.6200338e-01 -3.3614835e-01 -3.5806060e-01 -2.5038443e-01 -2.5504769e-01 -8.7190499e-02 -8.6921145e-02 -9.5668507e-02 -8.6161025e-02 -8.5410552e-02 -8.4376302e-02 -8.4553174e-02 -8.4553174e-02 -8.5538565e-02 -8.3567784e-02 -8.5926796e-02 -7.7784133e-02 -7.7706615e-02 -9.4469992e-02 -1.1286797e-01 -1.0647115e-01 -1.2306729e-01 -1.3183458e-01 -8.7813841e-02 -7.1590095e-02 -1.2515690e-01 -1.2433555e-01 -6.2667034e-02 -1.0635207e-01 -5.2407912e-02
    3.6530297e-03 3.7168944e-03 1.6643453e-03 3.9059607e-03 4.0664085e-03 4.3069208e-03 2.7424491e-02 1.7585039e-02 4.0607866e-03 4.4943771e-03 1.4472614e-03 1.4538430e-03 0.0000000e+00 -5.6128705e-05 -2.3935006e-03 -2.1680338e-03 -2.8395417e-03 -3.1523094e-03 -2.0922495e-03 -2.0263500e-03 -3.4427365e-03 -3.2056426e-03 -1.9901053e-03 -8.5621380e-04 3.9837132e-01 -5.4439177e-01 5.3394195e-02 -2.8535904e-01 1.8983332e-01 -1.5103694e-01 -4.9651294e-02 -4.9651294e-02 -7.3237750e-02 -2.6064837e-02 -3.6113939e-02 -3.8329718e-02 -3.3936174e-02 -2.4948513e-02 -2.8173675e-03 -9.2637470e-03 -6.0663526e-03 -5.2441771e-03 -1.4699383e-02 -1.9426023e-02 -4.4807284e-03 -5.1039796e-03 -2.2025675e-02 1.8477993e-02 -1.2196955e-02 -1.2180732e-02 -1.2707562e-02 -1.2134952e-02 -1.2089753e-02 -1.2027463e-02 -1.2038116e-02 -1.2038116e-02 -1.2097463e-02 -1.1978768e-02 -1.2120845e-02 -1.1630435e-02 -1.1625766e-02 -1.2635378e-02 -1.3743438e-02 -1.3358175e-02 -1.4357715e-02 -1.4885745e-02 -1.2234497e-02 -1.1257385e-02 -1.4483566e-02 -1.4434099e-02 -1.0719974e-02 -1.3351003e-02 -1.0102095e-02
    -7.6290223e-03 -7.7623980e-03 -3.4758346e-03 -8.1572458e-03 -8.4923265e-03 -8.9946148e-03 -5.7273571e-02 -3.6724763e-02 -8.4805857e-03 -9.3861003e-03 -3.0224746e-03 -3.0362196e-03 0.0000000e+00 1.1721973e-04 4.9986096e-03 4.5277427e-03 5.9301261e-03 6.5833131e-03 4.3694739e-03 4.2318488e-03 7.1898440e-03 6.6946948e-03 4.1561551e-03 1.7881251e-03 3.2170087e-01 2.9881139e-01 -1.1150895e-01 1.7097342e-01 2.3234490e-01 1.7816542e-01 1.0306119e-01 1.0306119e-01 6.6287204e-02 1.3983519e-01 7.5420697e-02 8.0048150e-02 7.0872631e-02 5.2102713e-02 5.8838173e-03 1.9346498e-02 1.2669029e-02 1.0951990e-02 3.0698333e-02 4.0569493e-02 9.3575962e-03 1.0659200e-02 4.5998632e-02 -3.8589619e-02 2.5472237e-02 2.5438358e-02 2.6538593e-02 2.5342750e-02 2.5248357e-02 2.5118269e-02 2.5140516e-02 2.5140516e-02 2.5264458e-02 2.5016575e-02 2.5313289e-02 2.4289112e-02 2.4279362e-02 2.6387845e-02 2.8701927e-02 2.7897341e-02 2.9984790e-02 3.1087532e-02 2.5550640e-02 2.3510031e-02 3.0247619e-02 3.0144310e-02 2.2387696e-02 2.7882363e-02 2.1097312e-02
    3.9759926e-03 4.0455035e-03 1.8114893e-03 4.2512851e-03 4.4259180e-03 4.6876939e-03 2.9849079e-02 1.9139725e-02 4.4197991e-03 4.8917232e-03 1.5752132e-03 1.5823766e-03 0.0000000e+00 -6.1091021e-05 -2.6051090e-03 -2.3597088e-03 -3.0905844e-03 -3.4310038e-03 -2.2772244e-03 -2.2054988e-03 -3.7471074e-03 -3.4890521e-03 -2.1660497e-03 -9.3191131e-04 2.7992781e-01 2.4558038e-01 5.8114754e-02 1.1438562e-01 -4.2217822e-01 -2.7128474e-02 -5.3409901e-02 -5.3409901e-02 6.9505465e-03 -1.1377035e-01 -3.9306758e-02 -4.1718433e-02 -3.6936457e-02 -2.7154200e-02 -3.0664498e-03 -1.0082751e-02 -6.6026764e-03 -5.7078127e-03 -1.5998950e-02 -2.1143470e-02 -4.8768678e-03 -5.5552203e-03 -2.3972956e-02 2.0111625e-02 -1.3275282e-02 -1.3257626e-02 -1.3831032e-02 -1.3207798e-02 -1.3158603e-02 -1.3090806e-02 -1.3102401e-02 -1.3102401e-02 -1.3166995e-02 -1.3037806e-02 -1.3192444e-02 -1.2658677e-02 -1.2653596e-02 -1.3752467e-02 -1.4958489e-02 -1.4539166e-02 -1.5627075e-02 -1.6201787e-02 -1.3316143e-02 -1.2252646e-02 -1.5764052e-02 -1.5710211e-02 -1.1667722e-02 -1.4531360e-02 -1.0995217e-02
    1.1364119e-03 1.1562795e-03 5.1775703e-04 1.2150956e-03 1.2650089e-03 1.3398293e-03 8.5314169e-03 5.4704860e-03 1.2632600e-03 1.3981446e-03 4.5022495e-04 4.5227240e-04 0.0000000e+00 -1.7460939e-05 -7.4458815e-04 -6.7444826e-04 -8.8334597e-04 -9.8064409e-04 -6.5087269e-04 -6.3037219e-04 -1.0709924e-03 -9.9723539e-04 -6.1909692e-04 -2.6635742e-04 2.2900249e-01 2.5755728e-01 1.6610267e-02 -3.7936591e-01 1.4119498e-01 1.0026230e-01 -1.5877401e-02 -1.5877401e-02 -8.2043177e-02 5.0288375e-02 -1.1234596e-02 -1.1923897e-02 -1.0557120e-02 -7.7611708e-03 -8.7644786e-04 -2.8818360e-03 -1.8871666e-03 -1.6313980e-03 -4.5727946e-03 -6.0431933e-03 -1.3938987e-03 -1.5877843e-03 -6.8519126e-03 5.7482730e-03 -3.7943203e-03 -3.7892737e-03 -3.9531638e-03 -3.7750321e-03 -3.7609713e-03 -3.7415936e-03 -3.7449075e-03 -3.7449075e-03 -3.7633697e-03 -3.7264453e-03 -3.7706436e-03 -3.6180831e-03 -3.6166308e-03 -3.9307085e-03 -4.2754119e-03 -4.1555614e-03 -4.4665059e-03 -4.6307693e-03 -3.8059992e-03 -3.5020320e-03 -4.5056566e-03 -4.4902679e-03 -3.3348500e-03 -4.1533304e-03 -3.1426357e-03
    2.5166178e-03 2.5606150e-03 1.1465882e-03 2.6908651e-03 2.8013996e-03 2.9670915e-03 1.8893075e-02 1.2114553e-02 2.7975266e-03 3.0962325e-03 9.9703644e-04 1.0015706e-03 0.0000000e+00 -3.8667766e-05 -1.6489124e-03 -1.4935856e-03 -1.9561957e-03 -2.1716653e-03 -1.4413768e-03 -1.3959778e-03 -2.3717442e-03 -2.2084072e-03 -1.3710084e-03 -5.8985637e-04 1.6936883e-01 1.9805095e-01 3.6783927e-02 9.4006874e-02 4.8638345e-02 -2.5129924e-01 -3.3773892e-02 -3.3773892e-02 8.8054271e-03 -7.6353212e-02 -2.4879343e-02 -2.6405821e-02 -2.3379054e-02 -1.7187342e-02 -1.9409197e-03 -6.3819109e-03 -4.1791861e-03 -3.6127791e-03 -1.0126589e-02 -1.3382830e-02 -3.0868297e-03 -3.5161952e-03 -1.5173763e-02 1.2729720e-02 -8.4026343e-03 -8.3914584e-03 -8.7543978e-03 -8.3599200e-03 -8.3287820e-03 -8.2858696e-03 -8.2932082e-03 -8.2932082e-03 -8.3340934e-03 -8.2523231e-03 -8.3502016e-03 -8.0123519e-03 -8.0091356e-03 -8.7046699e-03 -9.4680258e-03 -9.2026135e-03 -9.8912092e-03 -1.0254975e-02 -8.4284975e-03 -7.7553532e-03 -9.9779096e-03 -9.9438308e-03 -7.3851238e-03 -9.1976728e-03 -6.9594595e-03
    1.6162834e-02 1.6445404e-02 7.3638976e-03 1.7281928e-02 1.7991829e-02 1.9055976e-02 1.2133969e-01 7.7805024e-02 1.7966955e-02 1.9885377e-02 6.4034097e-03 6.4325299e-03 0.0000000e+00 -2.4834152e-04 -1.0590046e-02 -9.5924683e-03 -1.2563556e-02 -1.3947397e-02 -9.2571602e-03 -8.9655881e-03 -1.5232392e-02 -1.4183369e-02 -8.8052234e-03 -3.7883189e-03 -7.9009323e-02 -9.3907199e-02 2.3624268e-01 -1.9919281e-01 -1.1555519e-01 -1.3904898e-01 -2.1940092e-01 -2.1940092e-01 -2.8541094e-01 -1.5339090e-01 -1.5978617e-01 -1.6958988e-01 -1.5015064e-01 -1.1038472e-01 -1.2465446e-02 -4.0987459e-02 -2.6840584e-02 -2.3202868e-02 -6.5037438e-02 -8.5950463e-02 -1.9824988e-02 -2.2582564e-02 -9.7452627e-02 8.1755903e-02 -5.3965440e-02 -5.3893663e-02 -5.6224621e-02 -5.3691110e-02 -5.3491127e-02 -5.3215525e-02 -5.3262657e-02 -5.3262657e-02 -5.3525240e-02 -5.3000075e-02 -5.3628694e-02 -5.1458873e-02 -5.1438217e-02 -5.5905246e-02 -6.0807856e-02 -5.9103261e-02 -6.3525727e-02 -6.5861994e-02 -5.4131545e-02 -4.9808314e-02 -6.4082556e-02 -6.3863687e-02 -4.7430537e-02 -5.9071529e-02 -4.4696732e-02
    4.0934267e-02 4.1178247e-02 3.3413661e-02 4.1932093e-02 4.2482589e-02 4.3384585e-02 2.1439509e-01 1.4167220e-01 4.2549415e-02 4.4085557e-02 2.1525530e-02 1.8752710e-02 0.0000000e+00 1.9041286e-02 1.7983754e-02 1.5551515e-02 1.7228510e-02 1.8009602e-02 9.4169257e-03 4.0825000e-03 1.8734902e-02 1.8142794e-02 1.1485659e-03 2.3829267e-02 2.2587629e-01 2.2014292e-01 4.0633581e-01 2.0396332e-01 1.8798905e-01 1.6597441e-01 1.6973925e-01 1.6973925e-01 1.9071388e-01 1.4876462e-01 1.0627481e-01 1.1835893e-01 9.7652112e-02 5.1898881e-02 -6.3924893e-02 -2.4486348e-02 -3.1041834e-02 -3.9363093e-02 4.8934758e-03 3.0441148e-02 -4.7089976e-02 -4.0782036e-02 4.4492368e-02 -2.6461296e-01 3.0868961e-02 3.0846475e-02 3.1576704e-02 3.0783020e-02 3.0720371e-02 3.0634032e-02 3.0648797e-02 3.0648797e-02 3.0731058e-02 3.0566537e-02 3.0763467e-02 3.0083719e-02 3.0077247e-02 3.1476652e-02 3.3012512e-02 3.2478507e-02 3.3863951e-02 3.4595843e-02 3.0920997e-02 2.9566641e-02 3.4038391e-02 3.3969825e-02 2.8821745e-02 3.2468566e-02 2.7965315e-02
    1.1364119e-03 1.1562795e-03 5.1775703e-04 1.2150956e-03 1.2650089e-03 1.3398293e-03 8.5314169e-03 5.4704860e-03 1.2632600e-03 1.3981446e-03 4.5022495e-04 4.5227240e-04 0.0000000e+00 -1.7460939e-05 -7.4458815e-04 -6.7444826e-04 -8.8334597e-04 -9.8064409e-04 -6.5087269e-04 -6.3037219e-04 -1.0709924e-03 -9.9723539e-04 -6.1909692e-04 -2.6635742e-04 2.2900249e-01 2.5755728e-01 1.6610267e-02 6.2063409e-01 1.4119498e-01 1.0026230e-01 -1.5877401e-02 -1.5877401e-02 -8.2043177e-02 5.0288375e-02 -1.1234596e-02 -1.1923897e-02 -1.0557120e-02 -7.7611708e-03 -8.7644786e-04 -2.8818360e-03 -1.8871666e-03 -1.6313980e-03 -4.5727946e-03 -6.0431933e-03 -1.3938987e-03 -1.5877843e-03 -6.8519126e-03 5.7482730e-03 -3.7943203e-03 -3.7892737e-03 -3.9531638e-03 -3.7750321e-03 -3.7609713e-03 -3.7415936e-03 -3.7449075e-03 -3.7449075e-03 -3.7633697e-03 -3.7264453e-03 -3.7706436e-03 -3.6180831e-03 -3.6166308e-03 -3.9307085e-03 -4.2754119e-03 -4.1555614e-03 -4.4665059e-03 -4.6307693e-03 -3.8059992e-03 -3.5020320e-03 -4.5056566e-03 -4.4902679e-03 -3.3348500e-03 -4.1533304e-03 -3.1426357e-03
    3.9759926e-03 4.0455035e-03 1.8114893e-03 4.2512851e-03 4.4259180e-03 4.6876939e-03 2.9849079e-02 1.9139725e-02 4.4197991e-03 4.8917232e-03 1.5752132e-03 1.5823766e-03 0.0000000e+00 -6.1091021e-05 -2.6051090e-03 -2.3597088e-03 -3.0905844e-03 -3.4310038e-03 -2.2772244e-03 -2.2054988e-03 -3.7471074e-03 -3.4890521e-03 -2.1660497e-03 -9.3191131e-04 2.7992781e-01 2.4558038e-01 5.8114754e-02 1.1438562e-01 5.7782178e-01 -2.7128474e-02 -5.3409901e-02 -5.3409901e-02 6.9505465e-03 -1.1377035e-01 -3.9306758e-02 -4.1718433e-02 -3.6936457e-02 -2.7154200e-02 -3.0664498e-03 -1.0082751e-02 -6.6026764e-03 -5.7078127e-03 -1.5998950e-02 -2.1143470e-02 -4.8768678e-03 -5.5552203e-03 -2.3972956e-02 2.0111625e-02 -1.3275282e-02 -1.3257626e-02 -1.3831032e-02 -1.3207798e-02 -1.3158603e-02 -1.3090806e-02 -1.3102401e-02 -1.3102401e-02 -1.3166995e-02 -1.3037806e-02 -1.3192444e-02 -1.2658677e-02 -1.2653596e-02 -1.3752467e-02 -1.4958489e-02 -1.4539166e-02 -1.5627075e-02 -1.6201787e-02 -1.3316143e-02 -1.2252646e-02 -1.5764052e-02 -1.5710211e-02 -1.1667722e-02 -1.4531360e-02 -1.0995217e-02
    2.5166178e-03 2.5606150e-03 1.1465882e-03 2.6908651e-03 2.8013996e-03 2.9670915e-03 1.8893075e-02 1.2114553e-02 2.7975266e-03 3.0962325e-03 9.9703644e-04 1.0015706e-03 0.0000000e+00 -3.8667766e-05 -1.6489124e-03 -1.4935856e-03 -1.9561957e-03 -2.1716653e-03 -1.4413768e-03 -1.3959778e-03 -2.3717442e-03 -2.2084072e-03 -1.3710084e-03 -5.8985637e-04 1.6936883e-01 1.9805095e-01 3.6783927e-02 9.4006874e-02 4.8638345e-02 7.4870076e-01 -3.3773892e-02 -3.3773892e-02 8.8054271e-03 -7.6353212e-02 -2.4879343e-02 -2.6405821e-02 -2.3379054e-02 -1.7187342e-02 -1.9409197e-03 -6.3819109e-03 -4.1791861e-03 -3.6127791e-03 -1.0126589e-02 -1.3382830e-02 -3.0868297e-03 -3.5161952e-03 -1.5173763e-02 1.2729720e-02 -8.4026343e-03 -8.3914584e-03 -8.7543978e-03 -8.3599200e-03 -8.3287820e-03 -8.2858696e-03 -8.2932082e-03 -8.2932082e-03 -8.3340934e-03 -8.2523231e-03 -8.3502016e-03 -8.0123519e-03 -8.0091356e-03 -8.7046699e-03 -9.4680258e-03 -9.2026135e-03 -9.8912092e-03 -1.0254975e-02 -8.4284975e-03 -7.7553532e-03 -9.9779096e-03 -9.9438308e-03 -7.3851238e-03 -9.1976728e-03 -6.9594595e-03
    0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 1.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00
    -1.1339186e-03 -1.1537425e-03 -5.1662106e-04 -1.2124296e-03 -1.2622334e-03 -1.3368897e-03 -8.5126987e-03 -5.4584835e-03 -1.2604884e-03 -1.3950770e-03 -4.4923714e-04 -4.5128010e-04 0.0000000e+00 1.7422630e-05 7.4295450e-04 6.7296850e-04 8.8140788e-04 9.7849253e-04 6.4944465e-04 6.2898914e-04 1.0686426e-03 9.9504742e-04 6.1773860e-04 2.6577303e-04 3.0452310e-02 2.8451035e-02 -1.6573824e-02 -2.2476562e-02 6.1547086e-02 7.7997880e-02 5.1477914e-01 5.1477914e-01 -6.4181052e-02 9.3739325e-02 1.1209946e-02 1.1897735e-02 1.0533957e-02 7.7441425e-03 8.7452490e-04 2.8755132e-03 1.8830261e-03 1.6278187e-03 4.5627617e-03 6.0299344e-03 1.3908404e-03 1.5843007e-03 6.8368793e-03 -5.7356611e-03 3.7859954e-03 3.7809599e-03 3.9444904e-03 3.7667496e-03 3.7527196e-03 3.7333845e-03 3.7366911e-03 3.7366911e-03 3.7551128e-03 3.7182693e-03 3.7623707e-03 3.6101449e-03 3.6086957e-03 3.9220843e-03 4.2660315e-03 4.1464440e-03 4.4567062e-03 4.6206092e-03 3.7976487e-03 3.4943484e-03 4.4957711e-03 4.4804161e-03 3.3275332e-03 4.1442179e-03 3.1357406e-03
    1.1339186e-03 1.1537425e-03 5.1662106e-04 1.2124296e-03 1.2622334e-03 1.3368897e-03 8.5126987e-03 5.4584835e-03 1.2604884e-03 1.3950770e-03 4.4923714e-04 4.5128010e-04 0.0000000e+00 -1.7422630e-05 -7.4295450e-04 -6.7296850e-04 -8.8140788e-04 -9.7849253e-04 -6.4944465e-04 -6.2898914e-04 -1.0686426e-03 -9.9504742e-04 -6.1773860e-04 -2.6577303e-04 -3.0452310e-02 -2.8451035e-02 1.6573824e-02 2.2476562e-02 -6.1547086e-02 -7.7997880e-02 4.8522086e-01 4.8522086e-01 6.4181052e-02 -9.3739325e-02 -1.1209946e-02 -1.1897735e-02 -1.0533957e-02 -7.7441425e-03 -8.7452490e-04 -2.8755132e-03 -1.8830261e-03 -1.6278187e-03 -4.5627617e-03 -6.0299344e-03 -1.3908404e-03 -1.5843007e-03 -6.8368793e-03 5.7356611e-03 -3.7859954e-03 -3.7809599e-03 -3.9444904e-03 -3.7667496e-03 -3.7527196e-03 -3.7333845e-03 -3.7366911e-03 -3.7366911e-03 -3.7551128e-03 -3.7182693e-03 -3.7623707e-03 -3.6101449e-03 -3.6086957e-03 -3.9220843e-03 -4.2660315e-03 -4.1464440e-03 -4.4567062e-03 -4.6206092e-03 -3.7976487e-03 -3.4943484e-03 -4.4957711e-03 -4.4804161e-03 -3.3275332e-03 -4.1442179e-03 -3.1357406e-03
    1.0003868e-02 1.0118277e-02 6.4521204e-03 1.0461443e-02 1.0740038e-02 1.1168519e-02 6.4283364e-02 4.1685292e-02 1.0742461e-02 1.1502190e-02 4.6057928e-03 4.0069497e-03 0.0000000e+00 2.2596562e-03 -8.0704089e-04 -1.0361070e-03 -1.4241033e-03 -1.6048200e-03 -2.2875816e-03 -3.3758204e-03 -1.7726283e-03 -1.6356358e-03 -3.9743517e-03 1.9430420e-03 1.0165322e-01 1.0766031e-01 1.2392746e-01 2.1159801e-01 5.6208572e-02 3.2909083e-02 1.5293617e-01 1.5293617e-01 2.9671235e-01 9.1599963e-03 -1.7503340e-01 4.0282450e-02 -5.6371015e-02 -1.1316454e-01 -1.0031245e-02 -2.6253526e-02 -1.7470146e-02 -1.5587687e-02 -2.2090665e-02 -1.8470786e-02 -1.3839689e-02 -1.5266689e-02 -1.6479853e-02 4.0718081e-02 -8.7010400e-03 -8.6882009e-03 -9.1051533e-03 -8.6519690e-03 -8.6161969e-03 -8.5668983e-03 -8.5753291e-03 -8.5753291e-03 -8.6222988e-03 -8.5283594e-03 -8.6408043e-03 -8.2526755e-03 -8.2489805e-03 -9.0480248e-03 -9.9249839e-03 -9.6200727e-03 -1.0411146e-02 -1.0829048e-02 -8.7307522e-03 -7.9574301e-03 -1.0510749e-02 -1.0471599e-02 -7.5321029e-03 -9.6143967e-03 -7.0430909e-03
    6.1614598e-03 6.3296634e-03 9.1291320e-04 6.8231503e-03 7.2545671e-03 7.8903967e-03 5.7075049e-02 3.6131734e-02 7.2272656e-03 8.3862546e-03 1.7986048e-03 2.4265725e-03 0.0000000e+00 -2.5080361e-03 -9.7846389e-03 -8.5578410e-03 -1.1141390e-02 -1.2344728e-02 -6.9710067e-03 -5.5911507e-03 -1.3462113e-02 -1.2549922e-02 -4.8322300e-03 -5.7319454e-03 7.8792259e-02 8.4440808e-02 1.1235167e-01 1.8736671e-01 3.0978306e-02 6.3021158e-03 1.2656464e-01 1.2656464e-01 2.7165248e-01 -1.8523198e-02 1.5222583e-02 -2.0989849e-01 -9.3802788e-02 2.7627886e-03 -2.4361240e-03 -1.4740256e-02 -9.3745787e-03 -7.6187604e-03 -4.2956806e-02 -6.7492936e-02 -5.9883576e-03 -7.3193578e-03 -8.0987807e-02 4.1050435e-02 -4.5272724e-02 -4.5213776e-02 -4.7128141e-02 -4.5047423e-02 -4.4883182e-02 -4.4656836e-02 -4.4695545e-02 -4.4695545e-02 -4.4911198e-02 -4.4479891e-02 -4.4996162e-02 -4.3214136e-02 -4.3197171e-02 -4.6865846e-02 -5.0892252e-02 -4.9492305e-02 -5.3124381e-02 -5.5043106e-02 -4.5409143e-02 -4.1858567e-02 -5.3581692e-02 -5.3401940e-02 -3.9905751e-02 -4.9466245e-02 -3.7660536e-02
    5.7628607e-03 5.8022321e-03 4.5478830e-03 5.9233203e-03 6.0132655e-03 6.1591214e-03 3.2284847e-02 2.1174195e-02 6.0224792e-03 6.2725081e-03 2.9350801e-03 2.3194799e-03 0.0000000e+00 2.3604847e-03 2.0566480e-03 1.5533149e-03 1.9663522e-03 2.1587322e-03 1.9229621e-04 -9.9119827e-04 2.3373709e-03 2.1915369e-03 -1.6421202e-03 3.0004351e-03 2.2102157e-01 2.1937147e-01 6.1609683e-02 1.2772923e-01 2.9525808e-01 3.3528729e-01 2.1239916e-01 2.1239916e-01 5.2683617e-02 3.7211471e-01 -1.3423185e-01 8.6928105e-02 -1.6432258e-02 -8.4863113e-02 -6.7946292e-03 -1.5511796e-02 -1.0440047e-02 -9.5175521e-03 -4.7568963e-03 4.5951901e-03 -8.6609493e-03 -9.3602480e-03 9.7388376e-03 1.9119871e-02 5.8241204e-03 5.8176591e-03 6.0274919e-03 5.7994252e-03 5.7814228e-03 5.7566131e-03 5.7608559e-03 5.7608559e-03 5.7844936e-03 5.7372182e-03 5.7938065e-03 5.5984793e-03 5.5966198e-03 5.9987418e-03 6.4400748e-03 6.2866271e-03 6.6847376e-03 6.8950484e-03 5.8390732e-03 5.4498959e-03 6.7348633e-03 6.7151607e-03 5.2358483e-03 6.2837707e-03 4.9897512e-03
    1.8636683e-03 1.9576289e-03 -1.0731844e-03 2.2312595e-03 2.4762856e-03 2.8325537e-03 2.4970005e-02 1.5538565e-02 2.4553349e-03 3.1105246e-03 8.6406607e-05 7.1574736e-04 0.0000000e+00 -2.4776661e-03 -7.0536239e-03 -6.0795778e-03 -7.8945402e-03 -8.7398938e-03 -4.5603420e-03 -3.2392675e-03 -9.5248650e-03 -8.8840437e-03 -2.5126765e-03 -4.7879758e-03 1.9782276e-01 1.9580882e-01 4.9862822e-02 1.0313983e-01 2.6965496e-01 3.0828711e-01 1.8563791e-01 1.8563791e-01 2.7253408e-02 3.4402240e-01 5.8835799e-02 -1.6695009e-01 -5.4417210e-02 3.2777428e-02 9.1273485e-04 -3.8283795e-03 -2.2248411e-03 -1.4308583e-03 -2.5931404e-02 -4.5151425e-02 -6.9358863e-04 -1.2954682e-03 -5.5722436e-02 1.9457136e-02 -3.1288032e-02 -3.1247703e-02 -3.2557412e-02 -3.1133893e-02 -3.1021528e-02 -3.0866673e-02 -3.0893156e-02 -3.0893156e-02 -3.1040695e-02 -3.0745617e-02 -3.1098823e-02 -2.9879653e-02 -2.9868047e-02 -3.2377963e-02 -3.5132621e-02 -3.4174850e-02 -3.6659728e-02 -3.7972420e-02 -3.1381363e-02 -2.8952243e-02 -3.6972596e-02 -3.6849619e-02 -2.7616228e-02 -3.4157021e-02 -2.6080169e-02
    -2.5968048e-03 -2.4465680e-03 -7.3101315e-03 -2.0162496e-03 -1.6102237e-03 -1.0367370e-03 1.5498423e-02 8.4314496e-03 -1.6638628e-03 -5.8882197e-04 -3.1067830e-03 -1.1162293e-03 0.0000000e+00 -7.7660397e-03 -1.6888914e-02 -1.4311186e-02 -1.8526835e-02 -2.0490355e-02 -9.6459421e-03 -5.5892082e-03 -2.2313623e-02 -2.0825174e-02 -3.3580046e-03 -1.3260058e-02 5.4143138e-02 5.4778320e-02 3.4150599e-02 5.6570807e-02 5.8340546e-02 6.0779478e-02 6.0362384e-02 6.0362384e-02 5.8038671e-02 6.2686097e-02 2.7192762e-01 -1.3847956e-01 -3.6686695e-01 1.6277709e-01 9.4932882e-03 9.4465870e-03 7.0854567e-03 7.6947731e-03 -4.8300812e-02 -9.8515942e-02 8.2605670e-03 7.7986739e-03 -1.2613426e-01 1.8834539e-02 -7.1222384e-02 -7.1131751e-02 -7.4075084e-02 -7.0875984e-02 -7.0623463e-02 -7.0275456e-02 -7.0334971e-02 -7.0334971e-02 -7.0666537e-02 -7.0003404e-02 -7.0797170e-02 -6.8057308e-02 -6.8031224e-02 -7.3671805e-02 -7.9862399e-02 -7.7709982e-02 -8.3294293e-02 -8.6244329e-02 -7.1432127e-02 -6.5973123e-02 -8.3997408e-02 -8.3721039e-02 -6.2970671e-02 -7.7669914e-02 -5.9518657e-02
    1.8363533e-02 1.8367077e-02 1.8310135e-02 1.8401013e-02 1.8363527e-02 1.8364378e-02 8.1069788e-02 5.4428038e-02 1.8428803e-02 1.8363520e-02 1.0647656e-02 7.4426589e-03 0.0000000e+00 1.2386181e-02 1.8138521e-02 1.4828394e-02 1.9069084e-02 2.1044267e-02 7.5506567e-03 1.2221895e-03 2.2878365e-02 2.1381076e-02 -2.2584674e-03 1.8203535e-02 2.6853165e-01 2.7225346e-01 1.5138654e-01 2.8275643e-01 2.9312611e-01 3.0741689e-01 3.0497295e-01 3.0497295e-01 2.9135729e-01 3.1858861e-01 4.1880714e-01 2.6569012e-01 2.9406368e-01 -3.6080474e-01 -2.6319162e-02 -5.1211908e-02 -3.4995650e-02 -3.2800012e-02 2.1453251e-02 8.4640346e-02 -3.0761205e-02 -3.2425611e-02 1.1939325e-01 4.1003412e-02 6.8345464e-02 6.8261209e-02 7.0997422e-02 6.8023440e-02 6.7788689e-02 6.7465171e-02 6.7520497e-02 6.7520497e-02 6.7828732e-02 6.7212263e-02 6.7950172e-02 6.5403111e-02 6.5378863e-02 7.0622522e-02 7.6377489e-02 7.4376537e-02 7.9567884e-02 8.2310330e-02 6.8540448e-02 6.3465589e-02 8.0221522e-02 7.9964601e-02 6.0674416e-02 7.4339288e-02 5.7465317e-02
    4.3291356e-03 4.3824085e-03 2.6742894e-03 4.5417735e-03 4.6723369e-03 4.8720789e-03 2.8491411e-02 1.8441737e-02 4.6722772e-03 5.0276513e-03 1.9531734e-03 1.7324007e-03 0.0000000e+00 8.2772563e-04 -7.0679315e-04 -7.5326050e-04 -1.0114251e-03 -1.1316702e-03 -1.2040684e-03 -1.5960752e-03 -1.2433263e-03 -1.1521744e-03 -1.8116790e-03 5.7410654e-04 9.5350017e-02 9.6631468e-02 5.5015962e-02 1.0024773e-01 1.0381810e-01 1.0873854e-01 1.0789707e-01 1.0789707e-01 1.0320908e-01 1.1258505e-01 -7.1008791e-02 3.1247159e-01 -2.9939618e-01 -4.6181921e-02 -4.1969173e-03 -1.1306081e-02 -7.5068037e-03 -6.6692167e-03 -1.0689593e-02 -1.0153517e-02 -5.8914574e-03 -6.5263912e-03 -9.8586755e-03 1.8235472e-02 -5.3019225e-03 -5.2944015e-03 -5.5386481e-03 -5.2731772e-03 -5.2522223e-03 -5.2233436e-03 -5.2282823e-03 -5.2282823e-03 -5.2557967e-03 -5.2007679e-03 -5.2666370e-03 -5.0392750e-03 -5.0371105e-03 -5.5051828e-03 -6.0188969e-03 -5.8402829e-03 -6.3036858e-03 -6.5484888e-03 -5.3193276e-03 -4.8663230e-03 -6.3620324e-03 -6.3390985e-03 -4.6171705e-03 -5.8369580e-03 -4.3307120e-03
    3.6959926e-03 3.9048838e-03 -2.8345605e-03 4.5126363e-03 5.0585157e-03 5.8508715e-03 5.3553643e-02 3.3228563e-02 5.0103233e-03 6.4691280e-03 -6.8162011e-05 1.4099191e-03 0.0000000e+00 -5.8134278e-03 -1.6131470e-02 -1.3884158e-02 -1.8024505e-02 -1.9952952e-02 -1.0327280e-02 -7.2343430e-03 -2.1743652e-02 -2.0281791e-02 -5.5332274e-03 -1.1094028e-02 1.8126500e-01 1.8361816e-01 1.0719853e-01 1.9025880e-01 1.9681516e-01 2.0585069e-01 2.0430548e-01 2.0430548e-01 1.9569681e-01 2.1291415e-01 1.4506717e-01 3.1067982e-01 1.5117619e-01 8.1722138e-02 2.6735282e-03 -7.2625551e-03 -4.0926161e-03 -2.3804020e-03 -5.8198616e-02 -1.0249084e-01 -7.9048885e-04 -2.0884348e-03 -1.2685157e-01 4.2272099e-02 -7.1258834e-02 -7.1167078e-02 -7.4146905e-02 -7.0908139e-02 -7.0652488e-02 -7.0300166e-02 -7.0360418e-02 -7.0360418e-02 -7.0696096e-02 -7.0024740e-02 -7.0828348e-02 -6.8054514e-02 -6.8028107e-02 -7.3738626e-02 -8.0005977e-02 -7.7826873e-02 -8.3480423e-02 -8.6467038e-02 -7.1471178e-02 -6.5944488e-02 -8.4192256e-02 -8.3912461e-02 -6.2904808e-02 -7.7786308e-02 -5.9409993e-02
    1.7323307e-03 1.9358405e-03 -4.6358421e-03 2.5255240e-03 3.0621133e-03 3.8353419e-03 4.3989834e-02 2.6873187e-02 3.0084144e-03 4.4388293e-03 -1.1536096e-03 6.1617148e-04 0.0000000e+00 -6.9383141e-03 -1.7595707e-02 -1.5064447e-02 -1.9538260e-02 -2.1622025e-02 -1.0850010e-02 -7.1852834e-03 -2.3556949e-02 -2.1977349e-02 -5.1696836e-03 -1.2685952e-02 1.4949316e-01 1.5140979e-01 8.9166561e-02 1.5681854e-01 1.6215864e-01 1.6951802e-01 1.6825945e-01 1.6825945e-01 1.6124775e-01 1.7527115e-01 2.0091882e-01 1.7399203e-01 3.3373686e-01 1.1659517e-01 5.2963709e-03 -1.8594938e-03 -4.2134697e-04 1.0255564e-03 -5.8990405e-02 -1.0866946e-01 2.3691096e-03 1.2722827e-03 -1.3599294e-01 3.7070011e-02 -7.6524306e-02 -7.6426152e-02 -7.9613732e-02 -7.6149161e-02 -7.5875685e-02 -7.5498800e-02 -7.5563253e-02 -7.5563253e-02 -7.5922334e-02 -7.5204172e-02 -7.6063807e-02 -7.3096583e-02 -7.3068335e-02 -7.9176988e-02 -8.5881295e-02 -8.3550265e-02 -8.9597978e-02 -9.2792818e-02 -7.6751455e-02 -7.0839446e-02 -9.0359440e-02 -9.0060137e-02 -6.7587841e-02 -8.3506872e-02 -6.3849369e-02
    1.8363533e-02 1.8367077e-02 1.8310135e-02 1.8401013e-02 1.8363527e-02 1.8364378e-02 8.1069788e-02 5.4428038e-02 1.8428803e-02 1.8363520e-02 1.0647656e-02 7.4426589e-03 0.0000000e+00 1.2386181e-02 1.8138521e-02 1.4828394e-02 1.9069084e-02 2.1044267e-02 7.5506567e-03 1.2221895e-03 2.2878365e-02 2.1381076e-02 -2.2584674e-03 1.8203535e-02 2.6853165e-01 2.7225346e-01 1.5138654e-01 2.8275643e-01 2.9312611e-01 3.0741689e-01 3.0497295e-01 3.0497295e-01 2.9135729e-01 3.1858861e-01 4.1880714e-01 2.6569012e-01 2.9406368e-01 6.3919526e-01 -2.6319162e-02 -5.1211908e-02 -3.4995650e-02 -3.2800012e-02 2.1453251e-02 8.4640346e-02 -3.0761205e-02 -3.2425611e-02 1.1939325e-01 4.1003412e-02 6.8345464e-02 6.8261209e-02 7.0997422e-02 6.8023440e-02 6.7788689e-02 6.7465171e-02 6.7520497e-02 6.7520497e-02 6.7828732e-02 6.7212263e-02 6.7950172e-02 6.5403111e-02 6.5378863e-02 7.0622522e-02 7.6377489e-02 7.4376537e-02 7.9567884e-02 8.2310330e-02 6.8540448e-02 6.3465589e-02 8.0221522e-02 7.9964601e-02 6.0674416e-02 7.4339288e-02 5.7465317e-02
    -5.7353454e-02 -5.6742057e-02 -7.6617310e-02 -5.5024897e-02 -5.3305186e-02 -5.0953205e-02 -7.2858868e-02 -6.3722688e-02 -5.3618719e-02 -4.9114038e-02 -4.2275417e-02 -4.1772708e-02 0.0000000e+00 -7.0391172e-02 -1.1567648e-01 -1.0988711e-01 -1.2100496e-01 -1.2618331e-01 -1.0761615e-01 -1.0564140e-01 -1.3099178e-01 -1.2706632e-01 -1.0455529e-01 -1.0087918e-01 -2.6406802e-01 -2.6937680e-01 -9.6972393e-02 -2.8435823e-01 -2.9914952e-01 -3.1953388e-01 -3.1604784e-01 -3.1604784e-01 -2.9662649e-01 -3.3546920e-01 -3.7918835e-01 -3.5924728e-01 -3.7932022e-01 -4.4068808e-01 2.2145906e-01 -5.2708055e-01 -2.3407678e-01 -1.1880065e-01 -4.7974351e-01 -4.3858086e-01 -1.1758534e-02 -9.9143739e-02 -4.1594141e-01 1.0082351e-01 -2.6522841e-01 -2.6497966e-01 -2.7305803e-01 -2.6427767e-01 -2.6358459e-01 -2.6262944e-01 -2.6279279e-01 -2.6279279e-01 -2.6370281e-01 -2.6188276e-01 -2.6406135e-01 -2.5654143e-01 -2.5646985e-01 -2.7195117e-01 -2.8894209e-01 -2.8303449e-01 -2.9836138e-01 -3.0645815e-01 -2.6580408e-01 -2.5082111e-01 -3.0029117e-01 -2.9953264e-01 -2.4258048e-01 -2.8292452e-01 -2.3310597e-01
    -1.1579618e-02 -1.1427516e-02 -1.6350749e-02 -1.0991573e-02 -1.0581071e-02 -1.0000618e-02 7.4851726e-03 1.3797939e-05 -1.0634579e-02 -9.5472807e-03 -9.4356671e-03 -1.2964131e-02 0.0000000e+00 -1.7054898e-02 -2.6047762e-02 -2.7758102e-02 -2.6470408e-02 -2.5870640e-02 -3.5383642e-02 -4.2014546e-02 -2.5313712e-02 -2.5768367e-02 -4.5661544e-02 -2.2374116e-02 1.2246185e-02 1.1770939e-02 2.7204702e-02 1.0429791e-02 9.1056644e-03 7.2808427e-03 7.5929150e-03 7.5929150e-03 9.3315284e-03 5.8543016e-03 2.6069047e-03 3.0592987e-03 1.3993411e-03 -1.2005606e-03 7.4363084e-02 -6.5491427e-03 -1.3397886e-01 -2.0778471e-01 -5.3773772e-03 -4.3584507e-03 -2.7631872e-01 -2.2037010e-01 -3.7980411e-03 5.6497458e-02 -1.5177916e-02 -1.5196699e-02 -1.4586726e-02 -1.5249704e-02 -1.5302036e-02 -1.5374156e-02 -1.5361823e-02 -1.5361823e-02 -1.5293109e-02 -1.5430536e-02 -1.5266037e-02 -1.5833843e-02 -1.5839248e-02 -1.4670301e-02 -1.3387369e-02 -1.3833434e-02 -1.2676148e-02 -1.2064785e-02 -1.5134449e-02 -1.6265767e-02 -1.2530435e-02 -1.2587709e-02 -1.6887992e-02 -1.3841737e-02 -1.7603383e-02
    -1.1579618e-02 -1.1427516e-02 -1.6350749e-02 -1.0991573e-02 -1.0581071e-02 -1.0000618e-02 7.4851726e-03 1.3797939e-05 -1.0634579e-02 -9.5472807e-03 -9.4356671e-03 -1.2964131e-02 0.0000000e+00 -1.7054898e-02 -2.6047762e-02 -2.7758102e-02 -2.6470408e-02 -2.5870640e-02 -3.5383642e-02 -4.2014546e-02 -2.5313712e-02 -2.5768367e-02 -4.5661544e-02 -2.2374116e-02 1.2246185e-02 1.1770939e-02 2.7204702e-02 1.0429791e-02 9.1056644e-03 7.2808427e-03 7.5929150e-03 7.5929150e-03 9.3315284e-03 5.8543016e-03 2.6069047e-03 3.0592987e-03 1.3993411e-03 -1.2005606e-03 7.4363084e-02 -6.5491427e-03 -1.3397886e-01 -2.0778471e-01 -5.3773772e-03 -4.3584507e-03 -2.7631872e-01 -2.2037010e-01 -3.7980411e-03 5.6497458e-02 -1.5177916e-02 -1.5196699e-02 -1.4586726e-02 -1.5249704e-02 -1.5302036e-02 -1.5374156e-02 -1.5361823e-02 -1.5361823e-02 -1.5293109e-02 -1.5430536e-02 -1.5266037e-02 -1.5833843e-02 -1.5839248e-02 -1.4670301e-02 -1.3387369e-02 -1.3833434e-02 -1.2676148e-02 -1.2064785e-02 -1.5134449e-02 -1.6265767e-02 -1.2530435e-02 -1.2587709e-02 -1.6887992e-02 -1.3841737e-02 -1.7603383e-02
    -4.0934267e-02 -4.1178247e-02 -3.3413661e-02 -4.1932093e-02 -4.2482589e-02 -4.3384585e-02 -2.1439509e-01 -1.4167220e-01 -4.2549415e-02 -4.4085557e-02 -2.1525530e-02 -1.8752710e-02 0.0000000e+00 -1.9041286e-02 -1.7983754e-02 -1.5551515e-02 -1.7228510e-02 -1.8009602e-02 -9.4169257e-03 -4.0825000e-03 -1.8734902e-02 -1.8142794e-02 -1.1485659e-03 -2.3829267e-02 -2.2587629e-01 -2.2014292e-01 -4.0633581e-01 -2.0396332e-01 -1.8798905e-01 -1.6597441e-01 -1.6973925e-01 -1.6973925e-01 -1.9071388e-01 -1.4876462e-01 -1.0627481e-01 -1.1835893e-01 -9.7652112e-02 -5.1898881e-02 6.3924893e-02 2.4486348e-02 3.1041834e-02 3.9363093e-02 -4.8934758e-03 -3.0441148e-02 4.7089976e-02 4.0782036e-02 -4.4492368e-02 -7.3538704e-01 -3.0868961e-02 -3.0846475e-02 -3.1576704e-02 -3.0783020e-02 -3.0720371e-02 -3.0634032e-02 -3.0648797e-02 -3.0648797e-02 -3.0731058e-02 -3.0566537e-02 -3.0763467e-02 -3.0083719e-02 -3.0077247e-02 -3.1476652e-02 -3.3012512e-02 -3.2478507e-02 -3.3863951e-02 -3.4595843e-02 -3.0920997e-02 -2.9566641e-02 -3.4038391e-02 -3.3969825e-02 -2.8821745e-02 -3.2468566e-02 -2.7965315e-02
    -5.1260183e-03 -4.9658692e-03 -1.0093690e-02 -4.4838521e-03 -4.0971576e-03 -3.4982569e-03 7.5192563e-02 4.1715627e-02 -4.0891295e-03 -3.0319842e-03 -7.0925232e-03 -2.0410037e-02 0.0000000e+00 -1.6756705e-02 -2.0251199e-02 -3.0332579e-02 -1.8323018e-02 -1.2729334e-02 -5.9888225e-02 -8.5588787e-02 -7.5351991e-03 -1.1775498e-02 -9.9724096e-02 -1.6403097e-02 2.1773995e-01 2.1946162e-01 1.6354972e-01 2.2432020e-01 2.2911712e-01 2.3572790e-01 2.3459736e-01 2.3459736e-01 2.2829888e-01 2.4089583e-01 2.5752726e-01 2.4615420e-01 2.5316825e-01 2.8372276e-01 1.2894180e-01 3.2052119e-01 -3.4014660e-01 -2.2144092e-01 2.9388349e-01 2.7072028e-01 -1.1121421e-01 -2.0119920e-01 2.5798051e-01 1.4205277e-01 1.1754633e-01 1.1731454e-01 1.2484196e-01 1.1666043e-01 1.1601462e-01 1.1512461e-01 1.1527682e-01 1.1527682e-01 1.1612478e-01 1.1442886e-01 1.1645887e-01 1.0945182e-01 1.0938511e-01 1.2381059e-01 1.3964271e-01 1.3413802e-01 1.4841959e-01 1.5596415e-01 1.1808274e-01 1.0412163e-01 1.5021777e-01 1.4951097e-01 9.6443018e-02 1.3403554e-01 8.7614679e-02
    -3.3863902e-02 -3.3409110e-02 -4.8213485e-02 -3.2140032e-02 -3.0844502e-02 -2.9090570e-02 -6.6981643e-02 -5.1010277e-02 -3.1100787e-02 -2.7718534e-02 -2.4535238e-02 -1.3920012e-02 0.0000000e+00 -4.1248286e-02 -7.7286758e-02 -6.4726140e-02 -8.3612855e-02 -9.2409706e-02 -4.0177268e-02 -1.8830422e-02 -1.0057821e-01 -9.3909747e-02 -7.0896571e-03 -6.6272550e-02 -2.1327632e-01 -2.1658497e-01 -1.0913557e-01 -2.2592200e-01 -2.3514053e-01 -2.4784489e-01 -2.4567225e-01 -2.4567225e-01 -2.3356807e-01 -2.5777642e-01 -2.1790848e-01 -3.3971137e-01 -3.3842479e-01 -8.5215579e-02 6.6198102e-02 1.0118635e-01 7.1074174e-02 6.9840254e-02 -7.5217375e-01 -6.2466080e-01 6.8694472e-02 6.9629846e-02 -5.5452867e-01 -2.2584686e-04 -3.1442928e-01 -3.1403299e-01 -3.2690256e-01 -3.1291466e-01 -3.1181053e-01 -3.1028888e-01 -3.1054911e-01 -3.1054911e-01 -3.1199887e-01 -3.0909935e-01 -3.1257005e-01 -3.0059014e-01 -3.0047609e-01 -3.2513925e-01 -3.5220730e-01 -3.4279597e-01 -3.6721308e-01 -3.8011197e-01 -3.1534637e-01 -2.9147715e-01 -3.7028742e-01 -3.6907901e-01 -2.7834908e-01 -3.4262078e-01 -2.6325533e-01
    2.0032738e-02 1.9769603e-02 2.8286796e-02 1.9015421e-02 1.8305252e-02 1.7301069e-02 -1.2949349e-02 -2.3870435e-05 1.8397822e-02 1.6516796e-02 1.6323704e-02 2.2427947e-02 0.0000000e+00 2.9504973e-02 4.5062628e-02 4.8021517e-02 4.5793806e-02 4.4756206e-02 6.1213701e-02 7.2685165e-02 4.3792721e-02 4.4579275e-02 7.8994470e-02 3.8707220e-02 -2.1185901e-02 -2.0363725e-02 -4.7064135e-02 -1.8043539e-02 -1.5752799e-02 -1.2595858e-02 -1.3135743e-02 -1.3135743e-02 -1.6143544e-02 -1.0127942e-02 -4.5099451e-03 -5.2925868e-03 -2.4208601e-03 2.0769698e-03 -1.2864814e-01 1.1330017e-02 2.3178343e-01 -5.7053245e-01 9.3028626e-03 7.5401197e-03 -3.8696862e-01 -1.4375972e-01 6.5706111e-03 -9.7740602e-02 2.6257795e-02 2.6290289e-02 2.5235036e-02 2.6381987e-02 2.6472522e-02 2.6597291e-02 2.6575953e-02 2.6575953e-02 2.6457079e-02 2.6694827e-02 2.6410244e-02 2.7392548e-02 2.7401900e-02 2.5379621e-02 2.3160149e-02 2.3931840e-02 2.1929735e-02 2.0872079e-02 2.6182597e-02 2.8139777e-02 2.1677652e-02 2.1776737e-02 2.9216226e-02 2.3946205e-02 3.0453853e-02
    3.1264967e-03 3.0854293e-03 4.4147023e-03 2.9677246e-03 2.8568890e-03 2.7001669e-03 -2.0209966e-03 -3.7254436e-06 2.8713364e-03 2.5777658e-03 2.5476301e-03 3.5003154e-03 0.0000000e+00 4.6048223e-03 7.0328957e-03 7.4946876e-03 7.1470101e-03 6.9850727e-03 9.5535834e-03 1.1343927e-02 6.8347022e-03 6.9574591e-03 1.2328617e-02 6.0410112e-03 -3.3064700e-03 -3.1781536e-03 -7.3452696e-03 -2.8160437e-03 -2.4585294e-03 -1.9658275e-03 -2.0500870e-03 -2.0500870e-03 -2.5195127e-03 -1.5806614e-03 -7.0386426e-04 -8.2601065e-04 -3.7782209e-04 3.2415136e-04 -2.0078033e-02 1.7682685e-03 3.6174293e-02 -1.3898127e-02 1.4518918e-03 1.1767817e-03 -6.0393946e-02 -4.1550007e-01 1.0254711e-03 -1.5254314e-02 4.0980374e-03 4.1031087e-03 3.9384160e-03 4.1174200e-03 4.1315497e-03 4.1510222e-03 4.1476921e-03 4.1476921e-03 4.1291395e-03 4.1662447e-03 4.1218300e-03 4.2751376e-03 4.2765971e-03 3.9609812e-03 3.6145897e-03 3.7350271e-03 3.4225598e-03 3.2574920e-03 4.0863013e-03 4.3917571e-03 3.3832174e-03 3.3986815e-03 4.5597578e-03 3.7372691e-03 4.7529134e-03
    1.0016369e-02 9.8848014e-03 1.4143398e-02 9.5077103e-03 9.1526260e-03 8.6505346e-03 -6.4746743e-03 -1.1935218e-05 9.1989112e-03 8.2583978e-03 8.1618521e-03 1.1213973e-02 0.0000000e+00 1.4752486e-02 2.2531314e-02 2.4010758e-02 2.2896903e-02 2.2378103e-02 3.0606850e-02 3.6342583e-02 2.1896361e-02 2.2289637e-02 3.9497235e-02 1.9353610e-02 -1.0592950e-02 -1.0181863e-02 -2.3532068e-02 -9.0217695e-03 -7.8763997e-03 -6.2979289e-03 -6.5678715e-03 -6.5678715e-03 -8.0717721e-03 -5.0639709e-03 -2.2549725e-03 -2.6462934e-03 -1.2104300e-03 1.0384849e-03 -6.4324068e-02 5.6650084e-03 1.1589172e-01 2.1473378e-01 4.6514313e-03 3.7700599e-03 -1.9348431e-01 -7.1879860e-02 3.2853056e-03 -4.8870301e-02 1.3128897e-02 1.3145144e-02 1.2617518e-02 1.3190994e-02 1.3236261e-02 1.3298645e-02 1.3287977e-02 1.3287977e-02 1.3228539e-02 1.3347414e-02 1.3205122e-02 1.3696274e-02 1.3700950e-02 1.2689810e-02 1.1580075e-02 1.1965920e-02 1.0964868e-02 1.0436039e-02 1.3091299e-02 1.4069888e-02 1.0838826e-02 1.0888368e-02 1.4608113e-02 1.1973103e-02 1.5226926e-02
    1.0016369e-02 9.8848014e-03 1.4143398e-02 9.5077103e-03 9.1526260e-03 8.6505346e-03 -6.4746743e-03 -1.1935218e-05 9.1989112e-03 8.2583978e-03 8.1618521e-03 1.1213973e-02 0.0000000e+00 1.4752486e-02 2.2531314e-02 2.4010758e-02 2.2896903e-02 2.2378103e-02 3.0606850e-02 3.6342583e-02 2.1896361e-02 2.2289637e-02 3.9497235e-02 1.9353610e-02 -1.0592950e-02 -1.0181863e-02 -2.3532068e-02 -9.0217695e-03 -7.8763997e-03 -6.2979289e-03 -6.5678715e-03 -6.5678715e-03 -8.0717721e-03 -5.0639709e-03 -2.2549725e-03 -2.6462934e-03 -1.2104300e-03 1.0384849e-03 -6.4324068e-02 5.6650084e-03 1.1589172e-01 2.1473378e-01 4.6514313e-03 3.7700599e-03 -1.9348431e-01 -7.1879860e-02 3.2853056e-03 -4.8870301e-02 1.3128897e-02 1.3145144e-02 1.2617518e-02 1.3190994e-02 1.3236261e-02 1.3298645e-02 1.3287977e-02 1.3287977e-02 1.3228539e-02 1.3347414e-02 1.3205122e-02 1.3696274e-02 1.3700950e-02 1.2689810e-02 1.1580075e-02 1.1965920e-02 1.0964868e-02 1.0436039e-02 1.3091299e-02 1.4069888e-02 1.0838826e-02 1.0888368e-02 1.4608113e-02 1.1973103e-02 1.5226926e-02
    -1.6931951e-02 -1.6704555e-02 -2.4106743e-02 -1.6070016e-02 -1.5422251e-02 -1.4545285e-02 -3.3490821e-02 -2.5505139e-02 -1.5550393e-02 -1.3859267e-02 -1.2267619e-02 -6.9600059e-03 0.0000000e+00 -2.0624143e-02 -3.8643379e-02 -3.2363070e-02 -4.1806428e-02 -4.6204853e-02 -2.0088634e-02 -9.4152110e-03 -5.0289105e-02 -4.6954874e-02 -3.5448285e-03 -3.3136275e-02 -1.0663816e-01 -1.0829248e-01 -5.4567787e-02 -1.1296100e-01 -1.1757027e-01 -1.2392244e-01 -1.2283612e-01 -1.2283612e-01 -1.1678404e-01 -1.2888821e-01 -1.0895424e-01 -1.6985569e-01 -1.6921239e-01 -4.2607789e-02 3.3099051e-02 5.0593176e-02 3.5537087e-02 3.4920127e-02 1.2391312e-01 -3.1233040e-01 3.4347236e-02 3.4814923e-02 -2.7726434e-01 -1.1292343e-04 -1.5721464e-01 -1.5701649e-01 -1.6345128e-01 -1.5645733e-01 -1.5590526e-01 -1.5514444e-01 -1.5527455e-01 -1.5527455e-01 -1.5599943e-01 -1.5454968e-01 -1.5628503e-01 -1.5029507e-01 -1.5023805e-01 -1.6256962e-01 -1.7610365e-01 -1.7139799e-01 -1.8360654e-01 -1.9005598e-01 -1.5767318e-01 -1.4573858e-01 -1.8514371e-01 -1.8453950e-01 -1.3917454e-01 -1.7131039e-01 -1.3162766e-01
    -1.6931951e-02 -1.6704555e-02 -2.4106743e-02 -1.6070016e-02 -1.5422251e-02 -1.4545285e-02 -3.3490821e-02 -2.5505139e-02 -1.5550393e-02 -1.3859267e-02 -1.2267619e-02 -6.9600059e-03 0.0000000e+00 -2.0624143e-02 -3.8643379e-02 -3.2363070e-02 -4.1806428e-02 -4.6204853e-02 -2.0088634e-02 -9.4152110e-03 -5.0289105e-02 -4.6954874e-02 -3.5448285e-03 -3.3136275e-02 -1.0663816e-01 -1.0829248e-01 -5.4567787e-02 -1.1296100e-01 -1.1757027e-01 -1.2392244e-01 -1.2283612e-01 -1.2283612e-01 -1.1678404e-01 -1.2888821e-01 -1.0895424e-01 -1.6985569e-01 -1.6921239e-01 -4.2607789e-02 3.3099051e-02 5.0593176e-02 3.5537087e-02 3.4920127e-02 1.2391312e-01 -3.1233040e-01 3.4347236e-02 3.4814923e-02 -2.7726434e-01 -1.1292343e-04 -1.5721464e-01 -1.5701649e-01 -1.6345128e-01 -1.5645733e-01 -1.5590526e-01 -1.5514444e-01 -1.5527455e-01 -1.5527455e-01 -1.5599943e-01 -1.5454968e-01 -1.5628503e-01 -1.5029507e-01 -1.5023805e-01 -1.6256962e-01 -1.7610365e-01 -1.7139799e-01 -1.8360654e-01 -1.9005598e-01 -1.5767318e-01 -1.4573858e-01 -1.8514371e-01 -1.8453950e-01 -1.3917454e-01 -1.7131039e-01 -1.3162766e-01
    -1.6931951e-02 -1.6704555e-02 -2.4106743e-02 -1.6070016e-02 -1.5422251e-02 -1.4545285e-02 -3.3490821e-02 -2.5505139e-02 -1.5550393e-02 -1.3859267e-02 -1.2267619e-02 -6.9600059e-03 0.0000000e+00 -2.0624143e-02 -3.8643379e-02 -3.2363070e-02 -4.1806428e-02 -4.6204853e-02 -2.0088634e-02 -9.4152110e-03 -5.0289105e-02 -4.6954874e-02 -3.5448285e-03 -3.3136275e-02 -1.0663816e-01 -1.0829248e-01 -5.4567787e-02 -1.1296100e-01 -1.1757027e-01 -1.2392244e-01 -1.2283612e-01 -1.2283612e-01 -1.1678404e-01 -1.2888821e-01 -1.0895424e-01 -1.6985569e-01 -1.6921239e-01 -4.2607789e-02 3.3099051e-02 5.0593176e-02 3.5537087e-02 3.4920127e-02 1.2391312e-01 1.8766960e-01 3.4347236e-02 3.4814923e-02 -2.7726434e-01 -1.1292343e-04 -1.5721464e-01 -1.5701649e-01 -1.6345128e-01 -1.5645733e-01 -1.5590526e-01 -1.5514444e-01 -1.5527455e-01 -1.5527455e-01 -1.5599943e-01 -1.5454968e-01 -1.5628503e-01 -1.5029507e-01 -1.5023805e-01 -1.6256962e-01 -1.7610365e-01 -1.7139799e-01 -1.8360654e-01 -1.9005598e-01 -1.5767318e-01 -1.4573858e-01 -1.8514371e-01 -1.8453950e-01 -1.3917454e-01 -1.7131039e-01 -1.3162766e-01
    -1.6931951e-02 -1.6704555e-02 -2.4106743e-02 -1.6070016e-02 -1.5422251e-02 -1.4545285e-02 -3.3490821e-02 -2.5505139e-02 -1.5550393e-02 -1.3859267e-02 -1.2267619e-02 -6.9600059e-03 0.0000000e+00 -2.0624143e-02 -3.8643379e-02 -3.2363070e-02 -4.1806428e-02 -4.6204853e-02 -2.0088634e-02 -9.4152110e-03 -5.0289105e-02 -4.6954874e-02 -3.5448285e-03 -3.3136275e-02 -1.0663816e-01 -1.0829248e-01 -5.4567787e-02 -1.1296100e-01 -1.1757027e-01 -1.2392244e-01 -1.2283612e-01 -1.2283612e-01 -1.1678404e-01 -1.2888821e-01 -1.0895424e-01 -1.6985569e-01 -1.6921239e-01 -4.2607789e-02 3.3099051e-02 5.0593176e-02 3.5537087e-02 3.4920127e-02 1.2391312e-01 1.8766960e-01 3.4347236e-02 3.4814923e-02 -2.7726434e-01 -1.1292343e-04 -1.5721464e-01 -1.5701649e-01 -1.6345128e-01 -1.5645733e-01 -1.5590526e-01 -1.5514444e-01 -1.5527455e-01 -1.5527455e-01 -1.5599943e-01 -1.5454968e-01 -1.5628503e-01 -1.5029507e-01 -1.5023805e-01 -1.6256962e-01 -1.7610365e-01 -1.7139799e-01 -1.8360654e-01 -1.9005598e-01 -1.5767318e-01 -1.4573858e-01 -1.8514371e-01 -1.8453950e-01 -1.3917454e-01 -1.7131039e-01 -1.3162766e-01
    -3.1264967e-03 -3.0854293e-03 -4.4147023e-03 -2.9677246e-03 -2.8568890e-03 -2.7001669e-03 2.0209966e-03 3.7254436e-06 -2.8713364e-03 -2.5777658e-03 -2.5476301e-03 -3.5003154e-03 0.0000000e+00 -4.6048223e-03 -7.0328957e-03 -7.4946876e-03 -7.1470101e-03 -6.9850727e-03 -9.5535834e-03 -1.1343927e-02 -6.8347022e-03 -6.9574591e-03 -1.2328617e-02 -6.0410112e-03 3.3064700e-03 3.1781536e-03 7.3452696e-03 2.8160437e-03 2.4585294e-03 1.9658275e-03 2.0500870e-03 2.0500870e-03 2.5195127e-03 1.5806614e-03 7.0386426e-04 8.2601065e-04 3.7782209e-04 -3.2415136e-04 2.0078033e-02 -1.7682685e-03 -3.6174293e-02 1.3898127e-02 -1.4518918e-03 -1.1767817e-03 6.0393946e-02 -5.8449993e-01 -1.0254711e-03 1.5254314e-02 -4.0980374e-03 -4.1031087e-03 -3.9384160e-03 -4.1174200e-03 -4.1315497e-03 -4.1510222e-03 -4.1476921e-03 -4.1476921e-03 -4.1291395e-03 -4.1662447e-03 -4.1218300e-03 -4.2751376e-03 -4.2765971e-03 -3.9609812e-03 -3.6145897e-03 -3.7350271e-03 -3.4225598e-03 -3.2574920e-03 -4.0863013e-03 -4.3917571e-03 -3.3832174e-03 -3.3986815e-03 -4.5597578e-03 -3.7372691e-03 -4.7529134e-03
    -4.7994347e-04 -4.6530675e-04 -9.3984786e-04 -4.2367624e-04 -3.8353973e-04 -3.2751203e-04 5.1583098e-04 1.5344835e-04 -3.8958513e-04 -2.8373350e-04 -4.3473385e-04 -2.0074885e-04 0.0000000e+00 -9.1142722e-04 -1.8737235e-03 -1.5810679e-03 -2.0452352e-03 -2.2614301e-03 -1.0355590e-03 -5.6120340e-04 -2.4621824e-03 -2.2982957e-03 -3.0030782e-04 -1.5199312e-03 1.9828906e-03 1.9991130e-03 1.4722835e-03 2.0448929e-03 2.0900918e-03 2.1523819e-03 2.1417293e-03 2.1417293e-03 2.0823820e-03 2.2010767e-03 2.1617274e-03 2.4466826e-03 2.4724688e-03 1.9089618e-03 1.2518278e-03 1.5538864e-03 1.1234214e-03 1.1559154e-03 2.2049308e-03 2.7710563e-03 1.1860884e-03 1.1614563e-03 3.0824253e-03 1.3353459e-03 4.1904366e-01 -5.2388405e-01 7.9248272e-02 -2.6531591e-01 2.0941777e-01 -1.3208463e-01 -3.0590872e-02 -3.0590872e-02 -5.3575061e-02 -7.6066832e-03 -1.8783595e-02 -2.0836883e-02 -1.7018953e-02 -8.9444632e-03 1.1408584e-02 4.8771744e-03 6.6496029e-03 7.4370426e-03 -1.3926053e-04 -4.5013778e-03 8.7125639e-03 7.9016890e-03 -6.9005423e-03 3.7109180e-02 -6.5237005e-03
    1.0023185e-03 9.7175107e-04 1.9627873e-03 8.8480953e-04 8.0098804e-04 6.8397926e-04 -1.0772664e-03 -3.2046300e-04 8.1361331e-04 5.9255176e-04 9.0790233e-04 4.1924582e-04 0.0000000e+00 1.9034333e-03 3.9131021e-03 3.3019174e-03 4.2712888e-03 4.7227922e-03 2.1626713e-03 1.1720226e-03 5.1420454e-03 4.7997827e-03 6.2716573e-04 3.1742388e-03 -4.1410877e-03 -4.1749668e-03 -3.0747310e-03 -4.2705740e-03 -4.3649678e-03 -4.4950550e-03 -4.4728081e-03 -4.4728081e-03 -4.3488665e-03 -4.5967497e-03 -4.5145721e-03 -5.1096753e-03 -5.1635276e-03 -3.9866942e-03 -2.6143291e-03 -3.2451513e-03 -2.3461641e-03 -2.4140249e-03 -4.6047986e-03 -5.7871006e-03 -2.4770385e-03 -2.4255965e-03 -6.4373666e-03 -2.7887492e-03 2.7852854e-01 2.5598288e-01 -1.6550285e-01 1.2911514e-01 1.9144455e-01 1.3858522e-01 6.3255228e-02 6.3255228e-02 2.5223456e-02 1.0128700e-01 3.9227840e-02 4.3515946e-02 3.5542545e-02 1.8679703e-02 -2.3825797e-02 -1.0185538e-02 -1.3887094e-02 -1.5531591e-02 2.9083303e-04 9.4007206e-03 -1.8195402e-02 -1.6501963e-02 1.4411159e-02 -7.7499168e-02 1.3624159e-02
    -5.2237507e-04 -5.0644432e-04 -1.0229394e-03 -4.6113329e-04 -4.1744831e-04 -3.5646723e-04 5.6143538e-04 1.6701465e-04 -4.2402819e-04 -3.0881826e-04 -4.7316849e-04 -2.1849697e-04 0.0000000e+00 -9.9200613e-04 -2.0393786e-03 -1.7208495e-03 -2.2260536e-03 -2.4613622e-03 -1.1271123e-03 -6.1081916e-04 -2.6798629e-03 -2.5014870e-03 -3.2685791e-04 -1.6543077e-03 2.1581971e-03 2.1758538e-03 1.6024475e-03 2.2256811e-03 2.2748760e-03 2.3426731e-03 2.3310788e-03 2.3310788e-03 2.2664845e-03 2.3956730e-03 2.3528448e-03 2.6629928e-03 2.6910588e-03 2.0777323e-03 1.3625013e-03 1.6912649e-03 1.2227426e-03 1.2581094e-03 2.3998678e-03 3.0160443e-03 1.2909500e-03 1.2641402e-03 3.3549413e-03 1.4534033e-03 3.0242779e-01 2.6790117e-01 8.6254580e-02 1.3620076e-01 -4.0086232e-01 -6.5005901e-03 -3.2664356e-02 -3.2664356e-02 2.8351606e-02 -9.3680317e-02 -2.0444245e-02 -2.2679063e-02 -1.8523592e-02 -9.7352395e-03 1.2417212e-02 5.3083633e-03 7.2374915e-03 8.0945485e-03 -1.5157250e-04 -4.8993428e-03 9.4828380e-03 8.6002741e-03 -7.5106164e-03 4.0389987e-02 -7.1004581e-03
    -1.4930442e-04 -1.4475112e-04 -2.9237494e-04 -1.3180039e-04 -1.1931442e-04 -1.0188490e-04 1.6046858e-04 4.7735865e-05 -1.2119507e-04 -8.8265949e-05 -1.3524027e-04 -6.2450461e-05 0.0000000e+00 -2.8353363e-04 -5.8289198e-04 -4.9185049e-04 -6.3624714e-04 -7.0350266e-04 -3.2214947e-04 -1.7458337e-04 -7.6595421e-04 -7.1497108e-04 -9.3422014e-05 -4.7283161e-04 6.1685250e-04 6.2189910e-04 4.5800902e-04 6.3614066e-04 6.5020148e-04 6.6957913e-04 6.6626526e-04 6.6626526e-04 6.4780304e-04 6.8472748e-04 6.7248639e-04 7.6113240e-04 7.6915418e-04 5.9385419e-04 3.8942799e-04 4.8339467e-04 3.4948238e-04 3.5959086e-04 6.8592644e-04 8.6204102e-04 3.6897730e-04 3.6131456e-04 9.5890404e-04 4.1540944e-04 2.3543340e-01 2.6393698e-01 2.4653148e-02 -3.7313075e-01 1.4728745e-01 1.0615813e-01 -9.9479420e-03 -9.9479420e-03 -7.5926360e-02 5.6030476e-02 -5.8433419e-03 -6.4820941e-03 -5.2943838e-03 -2.7825108e-03 3.5490681e-03 1.5172280e-03 2.0686084e-03 2.3135711e-03 -4.3322213e-05 -1.4003224e-03 2.7103698e-03 2.4581168e-03 -2.1466726e-03 1.1544203e-02 -2.0294418e-03
    -3.3063905e-04 -3.2055563e-04 -6.4747292e-04 -2.9187585e-04 -2.6422531e-04 -2.2562713e-04 3.5536240e-04 1.0571248e-04 -2.6839006e-04 -1.9546755e-04 -2.9949357e-04 -1.3829839e-04 0.0000000e+00 -6.2789359e-04 -1.2908315e-03 -1.0892174e-03 -1.4089881e-03 -1.5579274e-03 -7.1340951e-04 -3.8662003e-04 -1.6962282e-03 -1.5833246e-03 -2.0688581e-04 -1.0470996e-03 1.3660381e-03 1.3772139e-03 1.0142745e-03 1.4087523e-03 1.4398904e-03 1.4828028e-03 1.4754641e-03 1.4754641e-03 1.4345790e-03 1.5163492e-03 1.4892410e-03 1.6855502e-03 1.7033146e-03 1.3151076e-03 8.6239978e-04 1.0704918e-03 7.7393904e-04 7.9632457e-04 1.5190043e-03 1.9090153e-03 8.1711113e-04 8.0014176e-04 2.1235213e-03 9.1993646e-04 1.8361026e-01 2.1217897e-01 5.4595124e-02 1.0781484e-01 6.2130316e-02 -2.3824276e-01 -2.0642930e-02 -2.0642930e-02 2.2351299e-02 -6.3637159e-02 -1.2940253e-02 -1.4354789e-02 -1.1724569e-02 -6.1619524e-03 7.8595161e-03 3.3599463e-03 4.5809944e-03 5.1234715e-03 -9.5938320e-05 -3.1010554e-03 6.0021940e-03 5.4435722e-03 -4.7538698e-03 2.5564977e-02 -4.4942587e-03
    -2.1235104e-03 -2.0587502e-03 -4.1583580e-03 -1.8745560e-03 -1.6969720e-03 -1.4490774e-03 2.2822948e-03 6.7893239e-04 -1.7237198e-03 -1.2553792e-03 -1.9234804e-03 -8.8821352e-04 0.0000000e+00 -4.0326108e-03 -8.2902917e-03 -6.9954368e-03 -9.0491456e-03 -1.0005700e-02 -4.5818319e-03 -2.4830451e-03 -1.0893929e-02 -1.0168812e-02 -1.3287123e-03 -6.7249373e-03 8.7733016e-03 8.8450779e-03 6.5141201e-03 9.0476312e-03 9.2476138e-03 9.5232162e-03 9.4760840e-03 9.4760840e-03 9.2135016e-03 9.7386664e-03 9.5645652e-03 1.0825350e-02 1.0939441e-02 8.4462038e-03 5.5387134e-03 6.8751723e-03 4.9705794e-03 5.1143492e-03 9.7557188e-03 1.2260542e-02 5.2478497e-03 5.1388648e-03 1.3638195e-02 5.9082395e-03 1.2455494e-02 -3.1707802e-03 3.5063407e-01 -1.1051194e-01 -2.8903773e-02 -5.5194431e-02 -1.3506807e-01 -1.3506807e-01 -1.9841336e-01 -7.1722779e-02 -8.3108038e-02 -9.2192812e-02 -7.5300378e-02 -3.9574788e-02 5.0477294e-02 2.1579064e-02 2.9421176e-02 3.2905204e-02 -6.1615839e-04 -1.9916351e-02 3.8548749e-02 3.4961032e-02 -3.0531458e-02 1.6418961e-01 -2.8864120e-02
    3.1258290e-03 3.0305013e-03 6.1211452e-03 2.7593656e-03 2.4979600e-03 2.1330566e-03 -3.3595611e-03 -9.9939539e-04 2.5373332e-03 1.8479310e-03 2.8313827e-03 1.3074593e-03 0.0000000e+00 5.9360442e-03 1.2203394e-02 1.0297354e-02 1.3320434e-02 1.4728492e-02 6.7445033e-03 3.6550676e-03 1.6035974e-02 1.4968594e-02 1.9558780e-03 9.8991761e-03 -1.2914389e-02 -1.3020045e-02 -9.5888511e-03 -1.3318205e-02 -1.3612582e-02 -1.4018271e-02 -1.3948892e-02 -1.3948892e-02 -1.3562368e-02 -1.4335416e-02 -1.4079137e-02 -1.5935025e-02 -1.6102969e-02 -1.2432898e-02 -8.1530425e-03 -1.0120324e-02 -7.3167434e-03 -7.5283740e-03 -1.4360517e-02 -1.8047642e-02 -7.7248881e-03 -7.5644613e-03 -2.0075561e-02 -8.6969886e-03 2.6607305e-01 2.5915366e-01 4.8386307e-01 2.3962708e-01 2.2034832e-01 1.9377965e-01 1.9832330e-01 1.9832330e-01 2.2363681e-01 1.7300978e-01 1.2233588e-01 1.3570876e-01 1.1084292e-01 5.8254491e-02 -7.4303091e-02 -3.1764601e-02 -4.3308270e-02 -4.8436795e-02 9.0699142e-04 2.9317072e-02 -5.6744151e-02 -5.1462995e-02 4.4942616e-02 -2.4168878e-01 4.2488279e-02
    -1.4930442e-04 -1.4475112e-04 -2.9237494e-04 -1.3180039e-04 -1.1931442e-04 -1.0188490e-04 1.6046858e-04 4.7735865e-05 -1.2119507e-04 -8.8265949e-05 -1.3524027e-04 -6.2450461e-05 0.0000000e+00 -2.8353363e-04 -5.8289198e-04 -4.9185049e-04 -6.3624714e-04 -7.0350266e-04 -3.2214947e-04 -1.7458337e-04 -7.6595421e-04 -7.1497108e-04 -9.3422014e-05 -4.7283161e-04 6.1685250e-04 6.2189910e-04 4.5800902e-04 6.3614066e-04 6.5020148e-04 6.6957913e-04 6.6626526e-04 6.6626526e-04 6.4780304e-04 6.8472748e-04 6.7248639e-04 7.6113240e-04 7.6915418e-04 5.9385419e-04 3.8942799e-04 4.8339467e-04 3.4948238e-04 3.5959086e-04 6.8592644e-04 8.6204102e-04 3.6897730e-04 3.6131456e-04 9.5890404e-04 4.1540944e-04 2.3543340e-01 2.6393698e-01 2.4653148e-02 6.2686925e-01 1.4728745e-01 1.0615813e-01 -9.9479420e-03 -9.9479420e-03 -7.5926360e-02 5.6030476e-02 -5.8433419e-03 -6.4820941e-03 -5.2943838e-03 -2.7825108e-03 3.5490681e-03 1.5172280e-03 2.0686084e-03 2.3135711e-03 -4.3322213e-05 -1.4003224e-03 2.7103698e-03 2.4581168e-03 -2.1466726e-03 1.1544203e-02 -2.0294418e-03
    -5.2237507e-04 -5.0644432e-04 -1.0229394e-03 -4.6113329e-04 -4.1744831e-04 -3.5646723e-04 5.6143538e-04 1.6701465e-04 -4.2402819e-04 -3.0881826e-04 -4.7316849e-04 -2.1849697e-04 0.0000000e+00 -9.9200613e-04 -2.0393786e-03 -1.7208495e-03 -2.2260536e-03 -2.4613622e-03 -1.1271123e-03 -6.1081916e-04 -2.6798629e-03 -2.5014870e-03 -3.2685791e-04 -1.6543077e-03 2.1581971e-03 2.1758538e-03 1.6024475e-03 2.2256811e-03 2.2748760e-03 2.3426731e-03 2.3310788e-03 2.3310788e-03 2.2664845e-03 2.3956730e-03 2.3528448e-03 2.6629928e-03 2.6910588e-03 2.0777323e-03 1.3625013e-03 1.6912649e-03 1.2227426e-03 1.2581094e-03 2.3998678e-03 3.0160443e-03 1.2909500e-03 1.2641402e-03 3.3549413e-03 1.4534033e-03 3.0242779e-01 2.6790117e-01 8.6254580e-02 1.3620076e-01 5.9913768e-01 -6.5005901e-03 -3.2664356e-02 -3.2664356e-02 2.8351606e-02 -9.3680317e-02 -2.0444245e-02 -2.2679063e-02 -1.8523592e-02 -9.7352395e-03 1.2417212e-02 5.3083633e-03 7.2374915e-03 8.0945485e-03 -1.5157250e-04 -4.8993428e-03 9.4828380e-03 8.6002741e-03 -7.5106164e-03 4.0389987e-02 -7.1004581e-03
    -3.3063905e-04 -3.2055563e-04 -6.4747292e-04 -2.9187585e-04 -2.6422531e-04 -2.2562713e-04 3.5536240e-04 1.0571248e-04 -2.6839006e-04 -1.9546755e-04 -2.9949357e-04 -1.3829839e-04 0.0000000e+00 -6.2789359e-04 -1.2908315e-03 -1.0892174e-03 -1.4089881e-03 -1.5579274e-03 -7.1340951e-04 -3.8662003e-04 -1.6962282e-03 -1.5833246e-03 -2.0688581e-04 -1.0470996e-03 1.3660381e-03 1.3772139e-03 1.0142745e-03 1.4087523e-03 1.4398904e-03 1.4828028e-03 1.4754641e-03 1.4754641e-03 1.4345790e-03 1.5163492e-03 1.4892410e-03 1.6855502e-03 1.7033146e-03 1.3151076e-03 8.6239978e-04 1.0704918e-03 7.7393904e-04 7.9632457e-04 1.5190043e-03 1.9090153e-03 8.1711113e-04 8.0014176e-04 2.1235213e-03 9.1993646e-04 1.8361026e-01 2.1217897e-01 5.4595124e-02 1.0781484e-01 6.2130316e-02 7.6175724e-01 -2.0642930e-02 -2.0642930e-02 2.2351299e-02 -6.3637159e-02 -1.2940253e-02 -1.4354789e-02 -1.1724569e-02 -6.1619524e-03 7.8595161e-03 3.3599463e-03 4.5809944e-03 5.1234715e-03 -9.5938320e-05 -3.1010554e-03 6.0021940e-03 5.4435722e-03 -4.7538698e-03 2.5564977e-02 -4.4942587e-03
    0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 1.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00 0.0000000e+00
    1.4897684e-04 1.4443353e-04 2.9173345e-04 1.3151122e-04 1.1905264e-04 1.0166136e-04 -1.6011650e-04 -4.7631131e-05 1.2092916e-04 8.8072291e-05 1.3494355e-04 6.2313442e-05 0.0000000e+00 2.8291155e-04 5.8161310e-04 4.9077135e-04 6.3485119e-04 7.0195915e-04 3.2144266e-04 1.7420033e-04 7.6427368e-04 7.1340241e-04 9.3217043e-05 4.7179420e-04 -6.1549910e-04 -6.2053463e-04 -4.5700413e-04 -6.3474495e-04 -6.4877491e-04 -6.6811005e-04 -6.6480345e-04 -6.6480345e-04 -6.4638174e-04 -6.8322516e-04 -6.7101093e-04 -7.5946245e-04 -7.6746663e-04 -5.9255125e-04 -3.8857357e-04 -4.8233408e-04 -3.4871560e-04 -3.5880190e-04 -6.8442149e-04 -8.6014967e-04 -3.6816776e-04 -3.6052182e-04 -9.5680017e-04 -4.1449801e-04 2.4035511e-02 2.2085338e-02 -2.4599058e-02 -2.8698051e-02 5.5467976e-02 7.2114986e-02 5.0886269e-01 5.0886269e-01 -7.0284448e-02 8.8009822e-02 5.8305214e-03 6.4678721e-03 5.2827678e-03 2.7764059e-03 -3.5412813e-03 -1.5138992e-03 -2.0640698e-03 -2.3084951e-03 4.3227163e-05 1.3972501e-03 -2.7044232e-03 -2.4527236e-03 2.1419627e-03 -1.1518874e-02 2.0249891e-03
    -1.4897684e-04 -1.4443353e-04 -2.9173345e-04 -1.3151122e-04 -1.1905264e-04 -1.0166136e-04 1.6011650e-04 4.7631131e-05 -1.2092916e-04 -8.8072291e-05 -1.3494355e-04 -6.2313442e-05 0.0000000e+00 -2.8291155e-04 -5.8161310e-04 -4.9077135e-04 -6.3485119e-04 -7.0195915e-04 -3.2144266e-04 -1.7420033e-04 -7.6427368e-04 -7.1340241e-04 -9.3217043e-05 -4.7179420e-04 6.1549910e-04 6.2053463e-04 4.5700413e-04 6.3474495e-04 6.4877491e-04 6.6811005e-04 6.6480345e-04 6.6480345e-04 6.4638174e-04 6.8322516e-04 6.7101093e-04 7.5946245e-04 7.6746663e-04 5.9255125e-04 3.8857357e-04 4.8233408e-04 3.4871560e-04 3.5880190e-04 6.8442149e-04 8.6014967e-04 3.6816776e-04 3.6052182e-04 9.5680017e-04 4.1449801e-04 -2.4035511e-02 -2.2085338e-02 2.4599058e-02 2.8698051e-02 -5.5467976e-02 -7.2114986e-02 4.9113731e-01 4.9113731e-01 7.0284448e-02 -8.8009822e-02 -5.8305214e-03 -6.4678721e-03 -5.2827678e-03 -2.7764059e-03 3.5412813e-03 1.5138992e-03 2.0640698e-03 2.3084951e-03 -4.3227163e-05 -1.3972501e-03 2.7044232e-03 2.4527236e-03 -2.1419627e-03 1.1518874e-02 -2.0249891e-03
    1.1193578e-04 1.0852210e-04 2.1919790e-04 9.8812742e-05 8.9451822e-05 7.6384650e-05 -1.2030571e-04 -3.5788298e-05 9.0861772e-05 6.6174315e-05 1.0139167e-04 4.6820053e-05 0.0000000e+00 2.1256944e-04 4.3700292e-04 3.6874774e-04 4.7700408e-04 5.2742656e-04 2.4152032e-04 1.3088779e-04 5.7424743e-04 5.3602461e-04 7.0039894e-05 3.5448900e-04 -4.6246363e-04 -4.6624714e-04 -3.4337627e-04 -4.7692426e-04 -4.8746586e-04 -5.0199358e-04 -4.9950912e-04 -4.9950912e-04 -4.8566772e-04 -5.1335053e-04 -5.0417320e-04 -5.7063245e-04 -5.7664650e-04 -4.4522145e-04 -2.9196004e-04 -3.6240828e-04 -2.6201221e-04 -2.6959069e-04 -5.1424940e-04 -6.4628517e-04 -2.7662785e-04 -2.7088298e-04 -7.1890483e-04 -3.1143872e-04 1.3249727e-01 1.3812696e-01 1.6665036e-01 2.4099963e-01 8.4558674e-02 5.9810059e-02 1.8008497e-01 1.8008497e-01 3.2524181e-01 3.4928128e-02 -1.5184034e-01 6.3827267e-02 -3.4143632e-02 -9.2985511e-02 5.9410857e-03 -1.0308491e-02 -4.4650847e-03 -1.7345192e-03 -5.2323554e-03 -8.1832428e-04 6.7405417e-04 -1.3459542e-03 1.6093928e-03 6.6824679e-02 1.5215031e-03
    -2.2357738e-03 -2.1675899e-03 -4.3781973e-03 -1.9736580e-03 -1.7866856e-03 -1.5256855e-03 2.4029526e-03 7.1482542e-04 -1.8148475e-03 -1.3217472e-03 -2.0251688e-03 -9.3517059e-04 0.0000000e+00 -4.2458023e-03 -8.7285735e-03 -7.3652637e-03 -9.5275456e-03 -1.0534670e-02 -4.8240591e-03 -2.6143159e-03 -1.1469857e-02 -1.0706405e-02 -1.3989572e-03 -7.0804637e-03 9.2371186e-03 9.3126895e-03 6.8585012e-03 9.5259511e-03 9.7365062e-03 1.0026679e-02 9.9770549e-03 9.9770549e-03 9.7005906e-03 1.0253519e-02 1.0070214e-02 1.1397652e-02 1.1517775e-02 8.8927282e-03 5.8315279e-03 7.2386412e-03 5.2333584e-03 5.3847288e-03 1.0271473e-02 1.2908718e-02 5.5252871e-03 5.4105405e-03 1.4359203e-02 6.2205896e-03 1.3942714e-01 1.4472458e-01 1.8403781e-01 2.4665964e-01 8.9292984e-02 6.3268625e-02 1.8376171e-01 1.8376171e-01 3.3013402e-01 3.7389391e-02 6.8719480e-02 -1.5603430e-01 -4.1168362e-02 5.3404618e-02 4.4543995e-02 3.1890884e-02 3.3890799e-02 3.4644799e-02 4.6161019e-03 -1.9101100e-02 3.7880641e-02 3.6312380e-02 -3.2145560e-02 9.7390260e-02 -3.0390076e-02
    6.9020691e-04 6.6915783e-04 1.3515956e-03 6.0928899e-04 5.5156865e-04 4.7099519e-04 -7.4181676e-04 -2.2067413e-04 5.6026254e-04 4.0803727e-04 6.2519093e-04 2.8869701e-04 0.0000000e+00 1.3107239e-03 2.6946026e-03 2.2737345e-03 2.9412537e-03 3.2521636e-03 1.4892378e-03 8.0706685e-04 3.5408656e-03 3.3051800e-03 4.3187281e-04 2.1858137e-03 -2.8515958e-03 -2.8749253e-03 -2.1172916e-03 -2.9407614e-03 -3.0057620e-03 -3.0953413e-03 -3.0800219e-03 -3.0800219e-03 -2.9946745e-03 -3.1653694e-03 -3.1087811e-03 -3.5185753e-03 -3.5556585e-03 -2.7452788e-03 -1.8002541e-03 -2.2346448e-03 -1.6155928e-03 -1.6623225e-03 -3.1709119e-03 -3.9850573e-03 -1.7057143e-03 -1.6702908e-03 -4.4328372e-03 -1.9203615e-03 2.2748513e-01 2.2564984e-01 7.3902177e-02 1.3348500e-01 3.0049787e-01 3.3981599e-01 2.1704948e-01 2.1704948e-01 5.8011421e-02 3.7608753e-01 -1.3151717e-01 8.9804515e-02 -1.4201193e-02 -8.3613564e-02 -7.6776930e-03 -1.6320401e-02 -1.2520082e-02 -1.0695214e-02 -5.1423695e-03 4.5776579e-03 -9.7834915e-03 -1.0859146e-02 9.9236730e-03 2.3228275e-02 9.3817365e-03
    -1.6921979e-03 -1.6405913e-03 -3.3137414e-03 -1.4938094e-03 -1.3522949e-03 -1.1547509e-03 1.8187310e-03 5.4103240e-04 -1.3736099e-03 -1.0003954e-03 -1.5327965e-03 -7.0780581e-04 0.0000000e+00 -3.2135352e-03 -6.6064258e-03 -5.5745727e-03 -7.2111465e-03 -7.9734123e-03 -3.6512023e-03 -1.9787064e-03 -8.6812304e-03 -8.1033940e-03 -1.0588336e-03 -5.3590151e-03 6.9913300e-03 7.0485276e-03 5.1910176e-03 7.2099397e-03 7.3693033e-03 7.5889272e-03 7.5513682e-03 7.5513682e-03 7.3421197e-03 7.7606167e-03 7.6218777e-03 8.6265806e-03 8.7174986e-03 6.7306701e-03 4.4137287e-03 5.4787355e-03 3.9609901e-03 4.0755584e-03 7.7742056e-03 9.7702665e-03 4.1819432e-03 4.0950946e-03 1.0868100e-02 4.7081993e-03 2.3451741e-01 2.3234496e-01 9.1546586e-02 1.3922866e-01 3.0530215e-01 3.4332567e-01 2.2078055e-01 2.2078055e-01 6.2975932e-02 3.7858517e-01 9.2302152e-02 -1.3330624e-01 -2.1329736e-02 6.4939966e-02 3.1495703e-02 2.6502610e-02 2.6402638e-02 2.6221729e-02 4.8516315e-03 -1.3975306e-02 2.7972947e-02 2.7355715e-02 -2.4330122e-02 5.4245564e-02 -2.3001442e-02
    -4.2720327e-03 -4.1417496e-03 -8.3656953e-03 -3.7711916e-03 -3.4139318e-03 -2.9152227e-03 4.5914716e-03 1.3658616e-03 -3.4677426e-03 -2.5255449e-03 -3.8696166e-03 -1.7868889e-03 0.0000000e+00 -8.1127199e-03 -1.6678231e-02 -1.4073270e-02 -1.8204877e-02 -2.0129252e-02 -9.2176312e-03 -4.9953368e-03 -2.1916173e-02 -2.0457397e-02 -2.6730749e-03 -1.3529084e-02 1.7649940e-02 1.7794338e-02 1.3104967e-02 1.8201830e-02 1.8604151e-02 1.9158602e-02 1.9063782e-02 1.9063782e-02 1.8535525e-02 1.9592040e-02 1.9241787e-02 2.1778207e-02 2.2007733e-02 1.6991892e-02 1.1142665e-02 1.3831324e-02 9.9997049e-03 1.0288938e-02 1.9626346e-02 2.4665495e-02 1.0557511e-02 1.0338258e-02 2.7437027e-02 1.1886069e-02 1.2279170e-01 1.2330639e-01 1.0659176e-01 1.2475884e-01 1.2619286e-01 1.2816912e-01 1.2783115e-01 1.2783115e-01 1.2594825e-01 1.2971405e-01 3.3809656e-01 -7.2124587e-02 -3.0094018e-01 2.2788981e-01 7.3726694e-02 7.3075559e-02 6.8614818e-02 6.6197983e-02 1.5789336e-02 -3.4024772e-02 6.8798899e-02 6.8726543e-02 -6.1422531e-02 8.6177396e-02 -5.8068218e-02
    5.0741754e-03 4.9194295e-03 9.9364888e-03 4.4792934e-03 4.0549522e-03 3.4626026e-03 -5.4535941e-03 -1.6223240e-03 4.1188669e-03 2.9997565e-03 4.5961992e-03 2.1224060e-03 0.0000000e+00 9.6360132e-03 1.9809837e-02 1.6715752e-02 2.1623135e-02 2.3908843e-02 1.0948389e-02 5.9332914e-03 2.6031286e-02 2.4298602e-02 3.1749876e-03 1.6069387e-02 -2.0963999e-02 -2.1135510e-02 -1.5565635e-02 -2.1619516e-02 -2.2097379e-02 -2.2755937e-02 -2.2643313e-02 -2.2643313e-02 -2.2015867e-02 -2.3270760e-02 -2.2854741e-02 -2.5867414e-02 -2.6140038e-02 -2.0182392e-02 -1.3234879e-02 -1.6428377e-02 -1.1877310e-02 -1.2220851e-02 -2.3311507e-02 -2.9296837e-02 -1.2539854e-02 -1.2279432e-02 -3.2588769e-02 -1.4117870e-02 2.3719070e-01 2.4047041e-01 1.3396078e-01 2.4972578e-01 2.5886369e-01 2.7145693e-01 2.6930330e-01 2.6930330e-01 2.5730498e-01 2.8130161e-01 3.7854593e-01 2.2575637e-01 2.5259535e-01 -4.0448888e-01 -7.5463302e-02 -9.9704451e-02 -8.5599984e-02 -7.8627716e-02 -2.6164060e-02 3.7784106e-02 -7.7908336e-02 -8.0931643e-02 7.2955597e-02 3.8755591e-03 6.8971457e-02
    -4.0286226e-05 -3.9057626e-05 -7.8890381e-05 -3.5563182e-05 -3.2194142e-05 -2.7491204e-05 4.3298606e-05 1.2880381e-05 -3.2701590e-05 -2.3816455e-05 -3.6491352e-05 -1.6850763e-05 0.0000000e+00 -7.6504766e-05 -1.5727946e-04 -1.3271409e-04 -1.7167607e-04 -1.8982336e-04 -8.6924328e-05 -4.7107145e-05 -2.0667442e-04 -1.9291784e-04 -2.5207695e-05 -1.2758230e-04 1.6644289e-04 1.6780459e-04 1.2358278e-04 1.7164734e-04 1.7544131e-04 1.8066991e-04 1.7977574e-04 1.7977574e-04 1.7479415e-04 1.8475733e-04 1.8145436e-04 2.0537337e-04 2.0753785e-04 1.6023735e-04 1.0507783e-04 1.3043249e-04 9.4299458e-05 9.7026990e-05 1.8508084e-04 2.3260115e-04 9.9559698e-05 9.7492089e-05 2.5873731e-04 1.1208830e-04 1.1030062e-01 1.1141418e-01 7.5250876e-02 1.1455666e-01 1.1765926e-01 1.2193506e-01 1.2120383e-01 1.2120383e-01 1.1713004e-01 1.2527763e-01 -5.9462511e-02 3.2417589e-01 -2.8827810e-01 -3.5978399e-02 4.1449497e-03 -2.9888138e-03 -5.2166283e-04 6.2426181e-04 -1.9625088e-03 -1.0700697e-03 1.7340253e-03 8.4739641e-04 -5.7922823e-04 3.1082937e-02 -5.4759631e-04
    -3.8876854e-03 -3.7691236e-03 -7.6130484e-03 -3.4319041e-03 -3.1067863e-03 -2.6529453e-03 4.1783850e-03 1.2429774e-03 -3.1557559e-03 -2.2983261e-03 -3.5214740e-03 -1.6261256e-03 0.0000000e+00 -7.3828327e-03 -1.5177720e-02 -1.2807122e-02 -1.6567016e-02 -1.8318259e-02 -8.3883371e-03 -4.5459151e-03 -1.9944413e-02 -1.8616881e-02 -2.4325830e-03 -1.2311896e-02 1.6062006e-02 1.6193413e-02 1.1925936e-02 1.6564244e-02 1.6930368e-02 1.7434936e-02 1.7348647e-02 1.7348647e-02 1.6867916e-02 1.7829379e-02 1.7510637e-02 1.9818860e-02 2.0027736e-02 1.5463161e-02 1.0140179e-02 1.2586944e-02 9.1000490e-03 9.3632602e-03 1.7860598e-02 2.2446384e-02 9.6076706e-03 9.4081430e-03 2.4968566e-02 1.0816701e-02 2.6364393e-01 2.6565536e-01 2.0033352e-01 2.7133163e-01 2.7693587e-01 2.8465924e-01 2.8333843e-01 2.8333843e-01 2.7597992e-01 2.9069693e-01 2.2048414e-01 3.8648357e-01 2.2578000e-01 1.5432298e-01 7.1894749e-02 6.1382307e-02 6.0815099e-02 6.0242267e-02 1.1430242e-02 -3.2006336e-02 6.4119563e-02 6.2820699e-02 -5.5896454e-02 1.2055289e-01 -5.2843922e-02
    -4.3123189e-03 -4.1808072e-03 -8.4445857e-03 -3.8067548e-03 -3.4461259e-03 -2.9427139e-03 4.6347703e-03 1.3787420e-03 -3.5004442e-03 -2.5493614e-03 -3.9061080e-03 -1.8037397e-03 0.0000000e+00 -8.1892246e-03 -1.6835510e-02 -1.4205984e-02 -1.8376553e-02 -2.0319076e-02 -9.3045555e-03 -5.0424440e-03 -2.2122847e-02 -2.0650315e-02 -2.6982826e-03 -1.3656667e-02 1.7816383e-02 1.7962142e-02 1.3228550e-02 1.8373478e-02 1.8779592e-02 1.9339272e-02 1.9243558e-02 1.9243558e-02 1.8710319e-02 1.9776797e-02 1.9423241e-02 2.1983580e-02 2.2215271e-02 1.7152129e-02 1.1247743e-02 1.3961757e-02 1.0094004e-02 1.0385965e-02 1.9811427e-02 2.4898096e-02 1.0657071e-02 1.0435750e-02 2.7695764e-02 1.1998158e-02 2.3309232e-01 2.3472057e-01 1.8184263e-01 2.3931550e-01 2.4385212e-01 2.5010418e-01 2.4903498e-01 2.4903498e-01 2.4307828e-01 2.5499168e-01 2.7863405e-01 2.5205130e-01 4.1078172e-01 1.9191141e-01 7.7871644e-02 7.0086746e-02 6.8093155e-02 6.6822245e-02 1.3826827e-02 -3.5094842e-02 7.0532924e-02 6.9573940e-02 -6.2001760e-02 1.1726033e-01 -5.8615814e-02
    5.0741754e-03 4.9194295e-03 9.9364888e-03 4.4792934e-03 4.0549522e-03 3.4626026e-03 -5.4535941e-03 -1.6223240e-03 4.1188669e-03 2.9997565e-03 4.5961992e-03 2.1224060e-03 0.0000000e+00 9.6360132e-03 1.9809837e-02 1.6715752e-02 2.1623135e-02 2.3908843e-02 1.0948389e-02 5.9332914e-03 2.6031286e-02 2.4298602e-02 3.1749876e-03 1.6069387e-02 -2.0963999e-02 -2.1135510e-02 -1.5565635e-02 -2.1619516e-02 -2.2097379e-02 -2.2755937e-02 -2.2643313e-02 -2.2643313e-02 -2.2015867e-02 -2.3270760e-02 -2.2854741e-02 -2.5867414e-02 -2.6140038e-02 -2.0182392e-02 -1.3234879e-02 -1.6428377e-02 -1.1877310e-02 -1.2220851e-02 -2.3311507e-02 -2.9296837e-02 -1.2539854e-02 -1.2279432e-02 -3.2588769e-02 -1.4117870e-02 2.3719070e-01 2.4047041e-01 1.3396078e-01 2.4972578e-01 2.5886369e-01 2.7145693e-01 2.6930330e-01 2.6930330e-01 2.5730498e-01 2.8130161e-01 3.7854593e-01 2.2575637e-01 2.5259535e-01 5.9551112e-01 -7.5463302e-02 -9.9704451e-02 -8.5599984e-02 -7.8627716e-02 -2.6164060e-02 3.7784106e-02 -7.7908336e-02 -8.0931643e-02 7.2955597e-02 3.8755591e-03 6.8971457e-02
    -9.3866250e-03 -9.1003634e-03 -1.8381330e-02 -8.2861635e-03 -7.5011826e-03 -6.4054057e-03 1.0088505e-02 3.0011078e-03 -7.6194172e-03 -5.5491952e-03 -8.5024256e-03 -3.9262003e-03 0.0000000e+00 -1.7825486e-02 -3.6645857e-02 -3.0922166e-02 -4.0000245e-02 -4.4228534e-02 -2.0253227e-02 -1.0975888e-02 -4.8154803e-02 -4.4949543e-02 -5.8733520e-03 -2.9726468e-02 3.8780922e-02 3.9098197e-02 2.8794586e-02 3.9993550e-02 4.0877540e-02 4.2095795e-02 4.1887455e-02 4.1887455e-02 4.0726753e-02 4.3048157e-02 4.2278571e-02 4.7851661e-02 4.8355982e-02 3.7335041e-02 2.4482962e-02 3.0390557e-02 2.1971620e-02 2.2607131e-02 4.3123534e-02 5.4195688e-02 2.3197248e-02 2.2715498e-02 6.0285373e-02 2.6116391e-02 2.2408342e-02 1.7029534e-02 1.9170803e-01 1.8504932e-03 -1.3135904e-02 -3.3789137e-02 -3.0257120e-02 -3.0257120e-02 -1.0579587e-02 -4.9934652e-02 -9.3280375e-02 -7.4976483e-02 -9.5118874e-02 -1.5317027e-01 5.3516880e-01 -2.3730132e-01 2.4335031e-02 1.4545199e-01 -1.9371118e-01 -1.5580670e-01 2.6856356e-01 1.7256622e-01 -1.3495924e-01 4.0505106e-01 -1.2758905e-01
    6.2562270e-03 6.0654323e-03 1.2251238e-02 5.5227646e-03 4.9995713e-03 4.2692312e-03 -6.7240330e-03 -2.0002516e-03 5.0783752e-03 3.6985631e-03 5.6669042e-03 2.6168298e-03 0.0000000e+00 1.1880765e-02 2.4424626e-02 2.0609760e-02 2.6660340e-02 2.9478513e-02 1.3498865e-02 7.3154779e-03 3.2095389e-02 2.9959069e-02 3.9146150e-03 1.9812822e-02 -2.5847656e-02 -2.6059121e-02 -1.9191718e-02 -2.6655878e-02 -2.7245061e-02 -2.8057033e-02 -2.7918174e-02 -2.7918174e-02 -2.7144561e-02 -2.8691786e-02 -2.8178854e-02 -3.1893343e-02 -3.2229476e-02 -2.4883969e-02 -1.6318002e-02 -2.0255440e-02 -1.4644182e-02 -1.5067752e-02 -2.8742026e-02 -3.6121665e-02 -1.5461068e-02 -1.5139980e-02 -4.0180467e-02 -1.7406690e-02 1.2183235e-01 1.2106206e-01 1.4607752e-01 1.1888829e-01 1.1674211e-01 1.1378439e-01 1.1429021e-01 1.1429021e-01 1.1710820e-01 1.1147222e-01 1.0780813e-01 1.0534262e-01 1.0298090e-01 1.0571238e-01 1.9526406e-01 1.0276836e-01 -3.3821650e-02 -9.6944391e-02 9.7309083e-02 9.2561885e-02 -1.6265385e-01 -1.1201461e-01 8.9950926e-02 1.7663008e-01 8.5038664e-02
    6.2562270e-03 6.0654323e-03 1.2251238e-02 5.5227646e-03 4.9995713e-03 4.2692312e-03 -6.7240330e-03 -2.0002516e-03 5.0783752e-03 3.6985631e-03 5.6669042e-03 2.6168298e-03 0.0000000e+00 1.1880765e-02 2.4424626e-02 2.0609760e-02 2.6660340e-02 2.9478513e-02 1.3498865e-02 7.3154779e-03 3.2095389e-02 2.9959069e-02 3.9146150e-03 1.9812822e-02 -2.5847656e-02 -2.6059121e-02 -1.9191718e-02 -2.6655878e-02 -2.7245061e-02 -2.8057033e-02 -2.7918174e-02 -2.7918174e-02 -2.7144561e-02 -2.8691786e-02 -2.8178854e-02 -3.1893343e-02 -3.2229476e-02 -2.4883969e-02 -1.6318002e-02 -2.0255440e-02 -1.4644182e-02 -1.5067752e-02 -2.8742026e-02 -3.6121665e-02 -1.5461068e-02 -1.5139980e-02 -4.0180467e-02 -1.7406690e-02 1.2183235e-01 1.2106206e-01 1.4607752e-01 1.1888829e-01 1.1674211e-01 1.1378439e-01 1.1429021e-01 1.1429021e-01 1.1710820e-01 1.1147222e-01 1.0780813e-01 1.0534262e-01 1.0298090e-01 1.0571238e-01 1.9526406e-01 1.0276836e-01 -3.3821650e-02 -9.6944391e-02 9.7309083e-02 9.2561885e-02 -1.6265385e-01 -1.1201461e-01 8.9950926e-02 1.7663008e-01 8.5038664e-02
    -3.1258290e-03 -3.0305013e-03 -6.1211452e-03 -2.7593656e-03 -2.4979600e-03 -2.1330566e-03 3.3595611e-03 9.9939539e-04 -2.5373332e-03 -1.8479310e-03 -2.8313827e-03 -1.3074593e-03 0.0000000e+00 -5.9360442e-03 -1.2203394e-02 -1.0297354e-02 -1.3320434e-02 -1.4728492e-02 -6.7445033e-03 -3.6550676e-03 -1.6035974e-02 -1.4968594e-02 -1.9558780e-03 -9.8991761e-03 1.2914389e-02 1.3020045e-02 9.5888511e-03 1.3318205e-02 1.3612582e-02 1.4018271e-02 1.3948892e-02 1.3948892e-02 1.3562368e-02 1.4335416e-02 1.4079137e-02 1.5935025e-02 1.6102969e-02 1.2432898e-02 8.1530425e-03 1.0120324e-02 7.3167434e-03 7.5283740e-03 1.4360517e-02 1.8047642e-02 7.7248881e-03 7.5644613e-03 2.0075561e-02 8.6969886e-03 -2.6607305e-01 -2.5915366e-01 -4.8386307e-01 -2.3962708e-01 -2.2034832e-01 -1.9377965e-01 -1.9832330e-01 -1.9832330e-01 -2.2363681e-01 -1.7300978e-01 -1.2233588e-01 -1.3570876e-01 -1.1084292e-01 -5.8254491e-02 7.4303091e-02 3.1764601e-02 4.3308270e-02 4.8436795e-02 -9.0699142e-04 -2.9317072e-02 5.6744151e-02 5.1462995e-02 -4.4942616e-02 -7.5831122e-01 -4.2488279e-02
    1.5923125e-02 1.5437521e-02 3.1181412e-02 1.4056343e-02 1.2724730e-02 1.0865894e-02 -1.7113768e-02 -5.0909688e-03 1.2925299e-02 9.4134504e-03 1.4423202e-02 6.6602616e-03 0.0000000e+00 3.0238498e-02 6.2164683e-02 5.2455224e-02 6.7854942e-02 7.5027656e-02 3.4356828e-02 1.8619093e-02 8.1688034e-02 7.6250749e-02 9.9633380e-03 5.0426885e-02 -6.5786528e-02 -6.6324742e-02 -4.8846074e-02 -6.7843586e-02 -6.9343154e-02 -7.1409756e-02 -7.1056336e-02 -7.1056336e-02 -6.9087364e-02 -7.3025308e-02 -7.1719812e-02 -8.1173795e-02 -8.2029308e-02 -6.3333788e-02 -4.1531996e-02 -5.1553422e-02 -3.7271848e-02 -3.8349904e-02 -7.3153175e-02 -9.1935570e-02 -3.9350957e-02 -3.8533734e-02 -1.0226589e-01 -4.4302884e-02 2.1854771e-01 2.1950209e-01 1.8850815e-01 2.2219537e-01 2.2485447e-01 2.2851906e-01 2.2789236e-01 2.2789236e-01 2.2440090e-01 2.3138383e-01 2.4384595e-01 2.3105600e-01 2.3561074e-01 2.6663009e-01 1.2756646e-01 2.9863639e-01 -3.9206521e-01 -2.4673939e-01 2.6895084e-01 2.4313731e-01 -1.2985318e-01 -2.3291918e-01 2.2893988e-01 1.5065380e-01 2.1643736e-01
    -2.0235575e-02 -1.9618455e-02 -3.9626254e-02 -1.7863213e-02 -1.6170960e-02 -1.3808697e-02 2.1748679e-02 6.4697526e-03 -1.6425849e-02 -1.1962889e-02 -1.8329428e-02 -8.4640559e-03 0.0000000e+00 -3.8427971e-02 -7.9000704e-02 -6.6661639e-02 -8.6232052e-02 -9.5347348e-02 -4.3661666e-02 -2.3661689e-02 -1.0381155e-01 -9.6901691e-02 -1.2661702e-02 -6.4083966e-02 8.3603451e-02 8.4287429e-02 6.2075025e-02 8.6217621e-02 8.8123315e-02 9.0749614e-02 9.0300477e-02 9.0300477e-02 8.7798250e-02 9.2802705e-02 9.1143642e-02 1.0315804e-01 1.0424525e-01 8.0486437e-02 5.2780079e-02 6.5515601e-02 4.7366158e-02 4.8736184e-02 9.2965202e-02 1.1683442e-01 5.0008351e-02 4.8969801e-02 1.2996249e-01 5.6301405e-02 4.1051336e-02 3.7997854e-02 1.3716065e-01 2.9380903e-02 2.0873312e-02 9.1487303e-03 1.1153812e-02 1.1153812e-02 2.2324501e-02 -1.6876763e-05 4.1419600e-02 -8.0276112e-02 -7.8134258e-02 1.7571075e-01 3.3213903e-01 3.6435784e-01 3.3080026e-01 3.1356366e-01 -4.8882607e-01 -3.6115991e-01 3.2050840e-01 3.2455375e-01 -2.9094352e-01 2.5827282e-01 -2.7505495e-01
    1.5621816e-02 1.5145401e-02 3.0591374e-02 1.3790358e-02 1.2483943e-02 1.0660282e-02 -1.6789929e-02 -4.9946337e-03 1.2680717e-02 9.2353220e-03 1.4150275e-02 6.5342311e-03 0.0000000e+00 2.9666303e-02 6.0988356e-02 5.1462627e-02 6.6570940e-02 7.3607927e-02 3.3706703e-02 1.8266768e-02 8.0142272e-02 7.4807876e-02 9.7748043e-03 4.9472670e-02 -6.4541666e-02 -6.5069696e-02 -4.7921773e-02 -6.6559799e-02 -6.8030991e-02 -7.0058488e-02 -6.9711755e-02 -6.9711755e-02 -6.7780041e-02 -7.1643468e-02 -7.0362676e-02 -7.9637764e-02 -8.0477088e-02 -6.2135339e-02 -4.0746096e-02 -5.0577889e-02 -3.6566562e-02 -3.7624219e-02 -7.1768916e-02 -9.0195896e-02 -3.8606328e-02 -3.7804570e-02 -1.0033074e-01 -4.3464552e-02 2.1908758e-01 2.1987501e-01 1.9430266e-01 2.2209718e-01 2.2429114e-01 2.2731470e-01 2.2679763e-01 2.2679763e-01 2.2391690e-01 2.2967835e-01 2.4079179e-01 2.2857662e-01 2.3250550e-01 2.6170860e-01 1.4402114e-01 2.9109173e-01 5.6098254e-01 -2.4207041e-01 2.6277446e-01 2.3815075e-01 -7.6908455e-02 1.7382326e-01 2.2460771e-01 1.6306994e-01 2.1234177e-01
    3.0130924e-04 2.9212028e-04 5.9003792e-04 2.6598459e-04 2.4078682e-04 2.0561255e-04 -3.2383948e-04 -9.6335106e-05 2.4458214e-04 1.7812832e-04 2.7292657e-04 1.2603043e-04 0.0000000e+00 5.7219540e-04 1.1763265e-03 9.9259685e-04 1.2840018e-03 1.4197292e-03 6.5012551e-04 3.5232435e-04 1.5457619e-03 1.4428735e-03 1.8853371e-04 9.5421511e-04 -1.2448617e-03 -1.2550462e-03 -9.2430183e-04 -1.2837869e-03 -1.3121628e-03 -1.3512686e-03 -1.3445810e-03 -1.3445810e-03 -1.3073226e-03 -1.3818393e-03 -1.3571357e-03 -1.5360310e-03 -1.5522197e-03 -1.1984491e-03 -7.8589938e-04 -9.7553227e-04 -7.0528568e-04 -7.2568547e-04 -1.3842589e-03 -1.7396734e-03 -7.4462813e-04 -7.2916405e-04 -1.9351513e-03 -8.3833219e-04 -5.3986641e-04 -3.7292159e-04 -5.7945074e-03 9.8198053e-05 5.6333853e-04 1.2043635e-03 1.0947385e-03 1.0947385e-03 4.8399682e-04 1.7054801e-03 3.0541604e-03 2.4793793e-03 3.1052350e-03 4.9214969e-03 -1.6454675e-02 7.5446600e-03 4.6952250e-02 -4.6689867e-03 6.1763777e-03 4.9865669e-03 -5.2944721e-02 -4.0674244e-01 4.3321710e-03 -1.2416144e-02 4.0955891e-03
    -6.4068816e-03 -6.2114925e-03 -1.2546257e-02 -5.6557569e-03 -5.1199647e-03 -4.3720374e-03 6.8859527e-03 2.0484192e-03 -5.2006663e-03 -3.7876272e-03 -5.8033674e-03 -2.6798450e-03 0.0000000e+00 -1.2166863e-02 -2.5012789e-02 -2.1106059e-02 -2.7302340e-02 -3.0188378e-02 -1.3823928e-02 -7.4916401e-03 -3.2868270e-02 -3.0680506e-02 -4.0088819e-03 -2.0289930e-02 2.6470087e-02 2.6686644e-02 1.9653869e-02 2.7297771e-02 2.7901142e-02 2.8732667e-02 2.8590464e-02 2.8590464e-02 2.7798222e-02 2.9382706e-02 2.8857422e-02 3.2661358e-02 3.3005585e-02 2.5483194e-02 1.6710952e-02 2.0743206e-02 1.4996825e-02 1.5430595e-02 2.9434155e-02 3.6991502e-02 1.5833382e-02 1.5504562e-02 4.1148043e-02 1.7825856e-02 -1.2156242e-01 -1.2087560e-01 -1.4318027e-01 -1.1893739e-01 -1.1702378e-01 -1.1438657e-01 -1.1483758e-01 -1.1483758e-01 -1.1735020e-01 -1.1232496e-01 -1.0933521e-01 -1.0658231e-01 -1.0453352e-01 -1.0817313e-01 -1.8703672e-01 -1.0654069e-01 1.0345526e-02 9.9278884e-02 -1.0039727e-01 -9.5055169e-02 -3.1087378e-01 -1.8461417e-01 -9.2117012e-02 -1.7042201e-01 -8.7086458e-02
    -6.4068816e-03 -6.2114925e-03 -1.2546257e-02 -5.6557569e-03 -5.1199647e-03 -4.3720374e-03 6.8859527e-03 2.0484192e-03 -5.2006663e-03 -3.7876272e-03 -5.8033674e-03 -2.6798450e-03 0.0000000e+00 -1.2166863e-02 -2.5012789e-02 -2.1106059e-02 -2.7302340e-02 -3.0188378e-02 -1.3823928e-02 -7.4916401e-03 -3.2868270e-02 -3.0680506e-02 -4.0088819e-03 -2.0289930e-02 2.6470087e-02 2.6686644e-02 1.9653869e-02 2.7297771e-02 2.7901142e-02 2.8732667e-02 2.8590464e-02 2.8590464e-02 2.7798222e-02 2.9382706e-02 2.8857422e-02 3.2661358e-02 3.3005585e-02 2.5483194e-02 1.6710952e-02 2.0743206e-02 1.4996825e-02 1.5430595e-02 2.9434155e-02 3.6991502e-02 1.5833382e-02 1.5504562e-02 4.1148043e-02 1.7825856e-02 -1.2156242e-01 -1.2087560e-01 -1.4318027e-01 -1.1893739e-01 -1.1702378e-01 -1.1438657e-01 -1.1483758e-01 -1.1483758e-01 -1.1735020e-01 -1.1232496e-01 -1.0933521e-01 -1.0658231e-01 -1.0453352e-01 -1.0817313e-01 -1.8703672e-01 -1.0654069e-01 1.0345526e-02 9.9278884e-02 -1.0039727e-01 -9.5055169e-02 -3.1087378e-01 -1.8461417e-01 -9.2117012e-02 -1.7042201e-01 -8.7086458e-02
    -1.0117787e-02 -9.8092276e-03 -1.9813127e-02 -8.9316064e-03 -8.0854802e-03 -6.9043487e-03 1.0874339e-02 3.2348763e-03 -8.2129245e-03 -5.9814445e-03 -9.1647140e-03 -4.2320279e-03 0.0000000e+00 -1.9213985e-02 -3.9500352e-02 -3.3330819e-02 -4.3116026e-02 -4.7673674e-02 -2.1830833e-02 -1.1830845e-02 -5.1905776e-02 -4.8450845e-02 -6.3308512e-03 -3.2041983e-02 4.1801725e-02 4.2143714e-02 3.1037513e-02 4.3108810e-02 4.4061658e-02 4.5374807e-02 4.5150239e-02 4.5150239e-02 4.3899125e-02 4.6401352e-02 4.5571821e-02 5.1579020e-02 5.2122626e-02 4.0243218e-02 2.6390040e-02 3.2757801e-02 2.3683079e-02 2.4368092e-02 4.6482601e-02 5.8417210e-02 2.5004175e-02 2.4484900e-02 6.4981245e-02 2.8150703e-02 2.0525668e-02 1.8998927e-02 6.8580325e-02 1.4690451e-02 1.0436656e-02 4.5743651e-03 5.5769062e-03 5.5769062e-03 1.1162251e-02 -8.4383816e-06 2.0709800e-02 -4.0138056e-02 -3.9067129e-02 8.7855374e-02 1.6606952e-01 1.8217892e-01 1.6540013e-01 1.5678183e-01 2.5558696e-01 -1.8057995e-01 1.6025420e-01 1.6227688e-01 -1.4547176e-01 1.2913641e-01 -1.3752748e-01
    -1.0117787e-02 -9.8092276e-03 -1.9813127e-02 -8.9316064e-03 -8.0854802e-03 -6.9043487e-03 1.0874339e-02 3.2348763e-03 -8.2129245e-03 -5.9814445e-03 -9.1647140e-03 -4.2320279e-03 0.0000000e+00 -1.9213985e-02 -3.9500352e-02 -3.3330819e-02 -4.3116026e-02 -4.7673674e-02 -2.1830833e-02 -1.1830845e-02 -5.1905776e-02 -4.8450845e-02 -6.3308512e-03 -3.2041983e-02 4.1801725e-02 4.2143714e-02 3.1037513e-02 4.3108810e-02 4.4061658e-02 4.5374807e-02 4.5150239e-02 4.5150239e-02 4.3899125e-02 4.6401352e-02 4.5571821e-02 5.1579020e-02 5.2122626e-02 4.0243218e-02 2.6390040e-02 3.2757801e-02 2.3683079e-02 2.4368092e-02 4.6482601e-02 5.8417210e-02 2.5004175e-02 2.4484900e-02 6.4981245e-02 2.8150703e-02 2.0525668e-02 1.8998927e-02 6.8580325e-02 1.4690451e-02 1.0436656e-02 4.5743651e-03 5.5769062e-03 5.5769062e-03 1.1162251e-02 -8.4383816e-06 2.0709800e-02 -4.0138056e-02 -3.9067129e-02 8.7855374e-02 1.6606952e-01 1.8217892e-01 1.6540013e-01 1.5678183e-01 2.5558696e-01 -1.8057995e-01 1.6025420e-01 1.6227688e-01 -1.4547176e-01 1.2913641e-01 -1.3752748e-01
    -1.0117787e-02 -9.8092276e-03 -1.9813127e-02 -8.9316064e-03 -8.0854802e-03 -6.9043487e-03 1.0874339e-02 3.2348763e-03 -8.2129245e-03 -5.9814445e-03 -9.1647140e-03 -4.2320279e-03 0.0000000e+00 -1.9213985e-02 -3.9500352e-02 -3.3330819e-02 -4.3116026e-02 -4.7673674e-02 -2.1830833e-02 -1.1830845e-02 -5.1905776e-02 -4.8450845e-02 -6.3308512e-03 -3.2041983e-02 4.1801725e-02 4.2143714e-02 3.1037513e-02 4.3108810e-02 4.4061658e-02 4.5374807e-02 4.5150239e-02 4.5150239e-02 4.3899125e-02 4.6401352e-02 4.5571821e-02 5.1579020e-02 5.2122626e-02 4.0243218e-02 2.6390040e-02 3.2757801e-02 2.3683079e-02 2.4368092e-02 4.6482601e-02 5.8417210e-02 2.5004175e-02 2.4484900e-02 6.4981245e-02 2.8150703e-02 2.0525668e-02 1.8998927e-02 6.8580325e-02 1.4690451e-02 1.0436656e-02 4.5743651e-03 5.5769062e-03 5.5769062e-03 1.1162251e-02 -8.4383816e-06 2.0709800e-02 -4.0138056e-02 -3.9067129e-02 8.7855374e-02 1.6606952e-01 1.8217892e-01 1.6540013e-01 1.5678183e-01 2.5558696e-01 3.1942005e-01 1.6025420e-01 1.6227688e-01 -1.4547176e-01 1.2913641e-01 -1.3752748e-01
    -1.0117787e-02 -9.8092276e-03 -1.9813127e-02 -8.9316064e-03 -8.0854802e-03 -6.9043487e-03 1.0874339e-02 3.2348763e-03 -8.2129245e-03 -5.9814445e-03 -9.1647140e-03 -4.2320279e-03 0.0000000e+00 -1.9213985e-02 -3.9500352e-02 -3.3330819e-02 -4.3116026e-02 -4.7673674e-02 -2.1830833e-02 -1.1830845e-02 -5.1905776e-02 -4.8450845e-02 -6.3308512e-03 -3.2041983e-02 4.1801725e-02 4.2143714e-02 3.1037513e-02 4.3108810e-02 4.4061658e-02 4.5374807e-02 4.5150239e-02 4.5150239e-02 4.3899125e-02 4.6401352e-02 4.5571821e-02 5.1579020e-02 5.2122626e-02 4.0243218e-02 2.6390040e-02 3.2757801e-02 2.3683079e-02 2.4368092e-02 4.6482601e-02 5.8417210e-02 2.5004175e-02 2.4484900e-02 6.4981245e-02 2.8150703e-02 2.0525668e-02 1.8998927e-02 6.8580325e-02 1.4690451e-02 1.0436656e-02 4.5743651e-03 5.5769062e-03 5.5769062e-03 1.1162251e-02 -8.4383816e-06 2.0709800e-02 -4.0138056e-02 -3.9067129e-02 8.7855374e-02 1.6606952e-01 1.8217892e-01 1.6540013e-01 1.5678183e-01 2.5558696e-01 3.1942005e-01 1.6025420e-01 1.6227688e-01 -1.4547176e-01 1.2913641e-01 -1.3752748e-01
    -3.0130924e-04 -2.9212028e-04 -5.9003792e-04 -2.6598459e-04 -2.4078682e-04 -2.0561255e-04 3.2383948e-04 9.6335106e-05 -2.4458214e-04 -1.7812832e-04 -2.7292657e-04 -1.2603043e-04 0.0000000e+00 -5.7219540e-04 -1.1763265e-03 -9.9259685e-04 -1.2840018e-03 -1.4197292e-03 -6.5012551e-04 -3.5232435e-04 -1.5457619e-03 -1.4428735e-03 -1.8853371e-04 -9.5421511e-04 1.2448617e-03 1.2550462e-03 9.2430183e-04 1.2837869e-03 1.3121628e-03 1.3512686e-03 1.3445810e-03 1.3445810e-03 1.3073226e-03 1.3818393e-03 1.3571357e-03 1.5360310e-03 1.5522197e-03 1.1984491e-03 7.8589938e-04 9.7553227e-04 7.0528568e-04 7.2568547e-04 1.3842589e-03 1.7396734e-03 7.4462813e-04 7.2916405e-04 1.9351513e-03 8.3833219e-04 5.3986641e-04 3.7292159e-04 5.7945074e-03 -9.8198053e-05 -5.6333853e-04 -1.2043635e-03 -1.0947385e-03 -1.0947385e-03 -4.8399682e-04 -1.7054801e-03 -3.0541604e-03 -2.4793793e-03 -3.1052350e-03 -4.9214969e-03 1.6454675e-02 -7.5446600e-03 -4.6952250e-02 4.6689867e-03 -6.1763777e-03 -4.9865669e-03 5.2944721e-02 -5.9325756e-01 -4.3321710e-03 1.2416144e-02 -4.0955891e-03
    -2.8435579e-02 -2.7568386e-02 -5.5683888e-02 -2.5101872e-02 -2.2723873e-02 -1.9404357e-02 3.0561834e-02 9.0914720e-03 -2.3082049e-02 -1.6810577e-02 -2.5757010e-02 -1.1893921e-02 0.0000000e+00 -5.4000028e-02 -1.1101393e-01 -9.3674745e-02 -1.2117562e-01 -1.3398468e-01 -6.1354558e-02 -3.3250048e-02 -1.4587881e-01 -1.3616889e-01 -1.7792568e-02 -9.0052529e-02 1.1748184e-01 1.1844298e-01 8.7229511e-02 1.2115534e-01 1.2383328e-01 1.2752382e-01 1.2689268e-01 1.2689268e-01 1.2337649e-01 1.3040888e-01 1.2807752e-01 1.4496048e-01 1.4648826e-01 1.1310173e-01 7.4168001e-02 9.2064302e-02 6.6560211e-02 6.8485409e-02 1.3063723e-01 1.6417890e-01 7.0273092e-02 6.8813694e-02 1.8262682e-01 7.9116263e-02 5.3778758e-01 5.3837378e-01 5.1933680e-01 5.4002804e-01 5.4166130e-01 5.4391215e-01 5.4352722e-01 5.4352722e-01 5.4138271e-01 5.4567174e-01 5.4053779e-01 5.5825876e-01 5.5842746e-01 5.2194514e-01 4.8190543e-01 4.9582689e-01 4.5970852e-01 4.4062817e-01 5.3643100e-01 5.7173892e-01 4.5516089e-01 4.5694839e-01 5.9115827e-01 4.9608604e-01 6.1348531e-01
    2.8435579e-02 2.7568386e-02 5.5683888e-02 2.5101872e-02 2.2723873e-02 1.9404357e-02 -3.0561834e-02 -9.0914720e-03 2.3082049e-02 1.6810577e-02 2.5757010e-02 1.1893921e-02 0.0000000e+00 5.4000028e-02 1.1101393e-01 9.3674745e-02 1.2117562e-01 1.3398468e-01 6.1354558e-02 3.3250048e-02 1.4587881e-01 1.3616889e-01 1.7792568e-02 9.0052529e-02 -1.1748184e-01 -1.1844298e-01 -8.7229511e-02 -1.2115534e-01 -1.2383328e-01 -1.2752382e-01 -1.2689268e-01 -1.2689268e-01 -1.2337649e-01 -1.3040888e-01 -1.2807752e-01 -1.4496048e-01 -1.4648826e-01 -1.1310173e-01 -7.4168001e-02 -9.2064302e-02 -6.6560211e-02 -6.8485409e-02 -1.3063723e-01 -1.6417890e-01 -7.0273092e-02 -6.8813694e-02 -1.8262682e-01 -7.9116263e-02 4.6221242e-01 4.6162622e-01 4.8066320e-01 4.5997196e-01 4.5833870e-01 4.5608785e-01 4.5647278e-01 4.5647278e-01 4.5861729e-01 4.5432826e-01 4.5946221e-01 4.4174124e-01 4.4157254e-01 4.7805486e-01 5.1809457e-01 5.0417311e-01 5.4029148e-01 5.5937183e-01 4.6356900e-01 4.2826108e-01 5.4483911e-01 5.4305161e-01 4.0884173e-01 5.0391396e-01 3.8651469e-01
    -2.8435579e-02 -2.7568386e-02 -5.5683888e-02 -2.5101872e-02 -2.2723873e-02 -1.9404357e-02 3.0561834e-02 9.0914720e-03 -2.3082049e-02 -1.6810577e-02 -2.5757010e-02 -1.1893921e-02 0.0000000e+00 -5.4000028e-02 -1.1101393e-01 -9.3674745e-02 -1.2117562e-01 -1.3398468e-01 -6.1354558e-02 -3.3250048e-02 -1.4587881e-01 -1.3616889e-01 -1.7792568e-02 -9.0052529e-02 1.1748184e-01 1.1844298e-01 8.7229511e-02 1.2115534e-01 1.2383328e-01 1.2752382e-01 1.2689268e-01 1.2689268e-01 1.2337649e-01 1.3040888e-01 1.2807752e-01 1.4496048e-01 1.4648826e-01 1.1310173e-01 7.4168001e-02 9.2064302e-02 6.6560211e-02 6.8485409e-02 1.3063723e-01 1.6417890e-01 7.0273092e-02 6.8813694e-02 1.8262682e-01 7.9116263e-02 5.3778758e-01 5.3837378e-01 5.1933680e-01 5.4002804e-01 5.4166130e-01 5.4391215e-01 5.4352722e-01 5.4352722e-01 5.4138271e-01 5.4567174e-01 5.4053779e-01 5.5825876e-01 5.5842746e-01 5.2194514e-01 4.8190543e-01 4.9582689e-01 4.5970852e-01 4.4062817e-01 5.3643100e-01 5.7173892e-01 4.5516089e-01 4.5694839e-01 5.9115827e-01 4.9608604e-01 -3.8651469e-01
]

RTS_branchnames = [
    "A1",
    "A2",
    "A3",
    "A4",
    "A5",
    "A6",
    "A7",
    "A8",
    "A9",
    "A10",
    "A11",
    "AB1",
    "A12-1",
    "A13-2",
    "A14",
    "A15",
    "A16",
    "A17",
    "A18",
    "A19",
    "A20",
    "A21",
    "A22",
    "AB2",
    "A23",
    "A24",
    "A25-1",
    "A25-2",
    "A26",
    "A27",
    "A28",
    "A29",
    "A30",
    "A31-1",
    "A31-2",
    "A32-1",
    "A32-2",
    "A33-1",
    "A33-2",
    "A34",
    "AB3",
    "B1",
    "B2",
    "B3",
    "B4",
    "B5",
    "B6",
    "B7",
    "B8",
    "B9",
    "B10",
    "B11",
    "B12-1",
    "B13-2",
    "B14",
    "B15",
    "B16",
    "B17",
    "B18",
    "B19",
    "B20",
    "B21",
    "B22",
    "B23",
    "B24",
    "B25-1",
    "B25-2",
    "B26",
    "B27",
    "B28",
    "B29",
    "B30",
    "B31-1",
    "B31-2",
    "B32-1",
    "B32-2",
    "B33-1",
    "B33-2",
    "B34",
    "C1",
    "C2",
    "C3",
    "C4",
    "C5",
    "C6",
    "C7",
    "C8",
    "C9",
    "C10",
    "C11",
    "C12-1",
    "C13-2",
    "C14",
    "C15",
    "C16",
    "C17",
    "C18",
    "C19",
    "C20",
    "C21",
    "C22",
    "C23",
    "C24",
    "C25-1",
    "C25-2",
    "C26",
    "C27",
    "C28",
    "C29",
    "C30",
    "C31-1",
    "C31-2",
    "C32-1",
    "C32-2",
    "C33-1",
    "C33-2",
    "C34",
    "CA-1",
    "CB-1",
    "C35",
]

Lodf_5 = [
    -1.0000 0.3448 0.3071 -1.0000 -1.0000 -0.3071
    0.5429 -1.0000 0.6929 0.5429 0.5429 -0.6929
    0.4571 0.6552 -1.0000 0.4571 0.4571 1.0000
    -1.0000 0.3448 0.3071 -1.0000 -1.0000 -0.3071
    -1.0000 0.3448 0.3071 -1.0000 -1.0000 -0.3071
    -0.4571 -0.6552 1.0000 -0.4571 -0.4571 -1.0000
]

Lodf_14 = [
    -1.0 1.0 -0.207667 -0.272435 -0.360507 -0.207667 -0.289868 -0.0293549 -0.0215445 0.0596783 0.036132 0.00397419 0.010449 0.0 -0.0293549 -0.036132 -0.030043 -0.036132 0.00397419 0.030043
    1.0 -1.0 0.207667 0.272435 0.360507 0.207667 0.289868 0.0293549 0.0215445 -0.0596783 -0.036132 -0.00397419 -0.010449 0.0 0.0293549 0.036132 0.030043 0.036132 -0.00397419 -0.030043
    -0.168846 0.168846 -1.0 0.2854 0.206769 -1.0 -0.24584 -0.0248961 -0.018272 0.0506136 0.0306438 0.00337054 0.00886189 0.0 -0.0248961 -0.0306438 -0.0254797 -0.0306438 0.00337054 0.0254797
    -0.353359 0.353359 0.455286 -1.0 0.432724 0.455286 -0.51449 -0.0521023 -0.0382395 0.105923 0.0641309 0.00705382 0.018546 0.0 -0.0521023 -0.0641309 -0.0533236 -0.0641309 0.00705382 0.0533236
    -0.477795 0.477795 0.337047 0.442166 -1.0 0.337047 0.470461 0.0476435 0.034967 -0.0968588 -0.0586427 -0.00645017 -0.0169589 0.0 0.0476435 0.0586427 0.0487603 0.0586427 -0.00645017 -0.0487603
    -0.168846 0.168846 -1.0 0.2854 0.206769 -1.0 -0.24584 -0.0248961 -0.018272 0.0506136 0.0306438 0.00337054 0.00886189 0.0 -0.0248961 -0.0306438 -0.0254797 -0.0306438 0.00337054 0.0254797
    -0.493344 0.493344 -0.514609 -0.675106 0.60415 -0.514609 -1.0 0.414888 0.304499 -0.843463 -0.510671 -0.0561692 -0.147681 0.0 0.414888 0.510671 0.424613 0.510671 -0.0561692 -0.424613
    -0.0182249 0.0182249 -0.0190105 -0.0249395 0.0223183 -0.0190105 0.151345 -1.0 0.63899 0.631469 0.38232 0.0420518 0.110563 0.0 -1.0 -0.38232 -0.317892 -0.38232 0.0420518 0.317892
    -0.0106362 0.0106362 -0.0110947 -0.0145549 0.0130252 -0.0110947 0.0883261 0.508114 -1.0 0.368531 0.223126 0.0245418 0.0645258 0.0 0.508114 -0.223126 -0.185525 -0.223126 0.0245418 0.185525
    0.0288612 -0.0288612 0.0301052 0.0394945 -0.0353434 0.0301052 -0.239671 0.491886 0.36101 -1.0 -0.605446 -0.0665936 -0.175089 0.0 0.491886 0.605446 0.503416 0.605446 -0.0665936 -0.503416
    0.0173795 -0.0173795 0.0181287 0.0237826 -0.021283 0.0181287 -0.144324 0.296202 0.217392 -0.602177 -1.0 0.0656897 0.172713 0.0 0.296202 1.0 -0.496584 1.0 0.0656897 0.496584
    0.00255259 -0.00255259 0.00266262 0.00349304 -0.0031259 0.00266262 -0.0211974 0.0435042 0.0319291 -0.0884437 0.0877169 -1.0 0.652198 0.0 0.0435042 -0.0877169 0.222319 -0.0877169 -1.0 -0.222319
    0.00892907 -0.00892907 0.00931395 0.0122188 -0.0109345 0.00931395 -0.0741493 0.15218 0.111689 -0.30938 0.306837 0.867717 -1.0 -2.15106e-16 0.15218 -0.306837 0.777681 -0.306837 0.867717 -0.777681
    -6.61382e-17 9.64509e-18 5.48592e-17 -6.02441e-17 2.63164e-17 -1.62578e-16 2.76856e-16 -2.60945e-17 1.1176e-16 -1.20015e-16 8.48088e-17 -3.99129e-17 8.9178e-17 -1.0 4.83884e-16 -3.55242e-16 -1.16564e-16 -1.05406e-17 1.28408e-16 1.1685e-17
    -0.0182249 0.0182249 -0.0190105 -0.0249395 0.0223183 -0.0190105 0.151345 -1.0 0.63899 0.631469 0.38232 0.0420518 0.110563 0.0 -1.0 -0.38232 -0.317892 -0.38232 0.0420518 0.317892
    -0.0173795 0.0173795 -0.0181287 -0.0237826 0.021283 -0.0181287 0.144324 -0.296202 -0.217392 0.602177 1.0 -0.0656897 -0.172713 0.0 -0.296202 -1.0 0.496584 -1.0 -0.0656897 -0.496584
    -0.0114817 0.0114817 -0.0119766 -0.0157118 0.0140605 -0.0119766 0.0953466 -0.195684 -0.143618 0.397823 -0.394554 0.132283 0.347802 9.71445e-17 -0.195684 0.394554 -1.0 0.394554 0.132283 1.0
    -0.0173795 0.0173795 -0.0181287 -0.0237826 0.021283 -0.0181287 0.144324 -0.296202 -0.217392 0.602177 1.0 -0.0656897 -0.172713 0.0 -0.296202 -1.0 0.496584 -1.0 -0.0656897 -0.496584
    0.00255259 -0.00255259 0.00266262 0.00349304 -0.0031259 0.00266262 -0.0211974 0.0435042 0.0319291 -0.0884437 0.0877169 -1.0 0.652198 -1.38778e-16 0.0435042 -0.0877169 0.222319 -0.0877169 -1.0 -0.222319
    0.0114817 -0.0114817 0.0119766 0.0157118 -0.0140605 0.0119766 -0.0953466 0.195684 0.143618 -0.397823 0.394554 -0.132283 -0.347802 1.38778e-16 0.195684 -0.394554 1.0 -0.394554 -0.132283 -1.0
]

Ybus5_matpower = Matrix{Complex{Float64}}(undef, 5, 5)
Ybus5_matpower[1, 1] = 22.2506856885351 - 222.484376885351im
Ybus5_matpower[2, 1] = -3.52348402099997 + 35.2348402099996im
Ybus5_matpower[4, 1] = -3.2569046378322 + 32.569046378322im
Ybus5_matpower[5, 1] = -15.470297029703 + 154.70297029703im
Ybus5_matpower[1, 2] = -3.52348402099997 + 35.2348402099996im
Ybus5_matpower[2, 2] = 12.6910674460091 - 126.897854460091im
Ybus5_matpower[3, 2] = -9.16758342500917 + 91.6758342500917im
Ybus5_matpower[2, 3] = -9.16758342500917 + 91.6758342500917im
Ybus5_matpower[3, 3] = 12.5012501250125 - 124.999871250125im
Ybus5_matpower[4, 3] = -3.33366670000333 + 33.3366670000333im
Ybus5_matpower[1, 4] = -3.2569046378322 + 32.569046378322im
Ybus5_matpower[3, 4] = -3.33366670000333 + 33.3366670000333im
Ybus5_matpower[4, 4] = 9.92423803783887 - 99.2323503783887im
Ybus5_matpower[5, 4] = -3.33366670000333 + 33.3366670000333im
Ybus5_matpower[1, 5] = -15.470297029703 + 154.70297029703im
Ybus5_matpower[4, 5] = -3.33366670000333 + 33.3366670000333im
Ybus5_matpower[5, 5] = 18.8039637297063 - 188.020637297063im

Ybus14_matpower = Matrix{Complex{Float64}}(undef, 14, 14)
Ybus14_matpower[1, 1] = 6.02502905576822 - 19.4470702055144im
Ybus14_matpower[2, 1] = -4.99913160079803 + 15.2630865231796im
Ybus14_matpower[5, 1] = -1.02589745497019 + 4.23498368233483im
Ybus14_matpower[1, 2] = -4.99913160079803 + 15.2630865231796im
Ybus14_matpower[2, 2] = 9.52132361081478 - 30.2721153987791im
Ybus14_matpower[3, 2] = -1.1350191923074 + 4.78186315175772im
Ybus14_matpower[4, 2] = -1.68603315061494 + 5.11583832587208im
Ybus14_matpower[5, 2] = -1.7011396670944 + 5.19392739796971im
Ybus14_matpower[2, 3] = -1.1350191923074 + 4.78186315175772im
Ybus14_matpower[3, 3] = 3.12099490223296 - 9.82238012935164im
Ybus14_matpower[4, 3] = -1.98597570992556 + 5.06881697759392im
Ybus14_matpower[2, 4] = -1.68603315061494 + 5.11583832587208im
Ybus14_matpower[3, 4] = -1.98597570992556 + 5.06881697759392im
Ybus14_matpower[4, 4] = 10.5129895220362 - 38.6541712076078im
Ybus14_matpower[5, 4] = -6.84098066149567 + 21.5785539816916im
Ybus14_matpower[7, 4] = 0 + 4.88951266031734im
Ybus14_matpower[9, 4] = 0 + 1.8554995578159im
Ybus14_matpower[1, 5] = -1.02589745497019 + 4.23498368233483im
Ybus14_matpower[2, 5] = -1.7011396670944 + 5.19392739796971im
Ybus14_matpower[4, 5] = -6.84098066149567 + 21.5785539816916im
Ybus14_matpower[5, 5] = 9.56801778356026 - 35.5336394560448im
Ybus14_matpower[6, 5] = 0 + 4.25744533525338im
Ybus14_matpower[5, 6] = 0 + 4.25744533525338im
Ybus14_matpower[6, 6] = 6.57992340746622 - 17.3407328099191im
Ybus14_matpower[11, 6] = -1.95502856317726 + 4.09407434424044im
Ybus14_matpower[12, 6] = -1.52596744045097 + 3.1759639650294im
Ybus14_matpower[13, 6] = -3.09892740383799 + 6.10275544819312im
Ybus14_matpower[4, 7] = 0 + 4.88951266031734im
Ybus14_matpower[7, 7] = 0 - 19.5490059482647im
Ybus14_matpower[8, 7] = 0 + 5.67697984672154im
Ybus14_matpower[9, 7] = 0 + 9.09008271975275im
Ybus14_matpower[7, 8] = 0 + 5.67697984672154im
Ybus14_matpower[8, 8] = 0 - 5.67697984672154im
Ybus14_matpower[4, 9] = 0 + 1.8554995578159im
Ybus14_matpower[7, 9] = 0 + 9.09008271975275im
Ybus14_matpower[9, 9] = 5.32605503946736 - 24.2825063752679im
Ybus14_matpower[10, 9] = -3.90204955244743 + 10.3653941270609im
Ybus14_matpower[14, 9] = -1.42400548701993 + 3.0290504569306im
Ybus14_matpower[9, 10] = -3.90204955244743 + 10.3653941270609im
Ybus14_matpower[10, 10] = 5.78293430614783 - 14.7683378765214im
Ybus14_matpower[11, 10] = -1.8808847537004 + 4.40294374946052im
Ybus14_matpower[6, 11] = -1.95502856317726 + 4.09407434424044im
Ybus14_matpower[10, 11] = -1.8808847537004 + 4.40294374946052im
Ybus14_matpower[11, 11] = 3.83591331687766 - 8.49701809370096im
Ybus14_matpower[6, 12] = -1.52596744045097 + 3.1759639650294im
Ybus14_matpower[12, 12] = 4.01499202727289 - 5.42793859120161im
Ybus14_matpower[13, 12] = -2.48902458682192 + 2.25197462617221im
Ybus14_matpower[6, 13] = -3.09892740383799 + 6.10275544819312im
Ybus14_matpower[12, 13] = -2.48902458682192 + 2.25197462617221im
Ybus14_matpower[13, 13] = 6.72494614846623 - 10.6696935494707im
Ybus14_matpower[14, 13] = -1.13699415780633 + 2.31496347510535im
Ybus14_matpower[9, 14] = -1.42400548701993 + 3.0290504569306im
Ybus14_matpower[13, 14] = -1.13699415780633 + 2.31496347510535im
Ybus14_matpower[14, 14] = 2.56099964482626 - 5.34401393203596im;

Ybus5_phaseshifter = Matrix{Complex{Float64}}(undef, 5, 5)
Ybus5_phaseshifter[1, 1] = 22.2506856885351 - 222.484376885351im
Ybus5_phaseshifter[2, 1] = -3.52348402099997 + 35.2348402099996im
Ybus5_phaseshifter[4, 1] = -3.2569046378322 + 32.569046378322im
Ybus5_phaseshifter[5, 1] = -15.470297029703 + 154.70297029703im
Ybus5_phaseshifter[1, 2] = -3.52348402099997 + 35.2348402099996im
Ybus5_phaseshifter[2, 2] = 12.6910674460091 - 126.897854460091im
Ybus5_phaseshifter[3, 2] = -9.16758342500917 + 91.6758342500917im
Ybus5_phaseshifter[2, 3] = -9.16758342500917 + 91.6758342500917im
Ybus5_phaseshifter[3, 3] = 15.5249840932695 - 155.234154243353im
Ybus5_phaseshifter[4, 3] = -5.2406741041314 + 63.5995622292464im
Ybus5_phaseshifter[1, 4] = -3.2569046378322 + 32.569046378322im
Ybus5_phaseshifter[3, 4] = -7.45707433936553 + 63.377922205723im
Ybus5_phaseshifter[4, 4] = 12.9479720060959 - 129.466633371616im
Ybus5_phaseshifter[5, 4] = -3.33366670000333 + 33.3366670000333im
Ybus5_phaseshifter[1, 5] = -15.470297029703 + 154.70297029703im
Ybus5_phaseshifter[4, 5] = -3.33366670000333 + 33.3366670000333im
Ybus5_phaseshifter[5, 5] = 18.8039637297063 - 188.020637297063im;

Ybus3_matpower = Matrix{Complex{Float64}}(undef, 3, 3)
Ybus3_matpower[1, 1] = 1.379310344827586 - 16.551724137931036im
Ybus3_matpower[2, 1] = -0.689655172413793 + 8.275862068965518im
Ybus3_matpower[3, 1] = -0.689655172413793 + 8.275862068965518im
Ybus3_matpower[1, 2] = -0.689655172413793 + 8.275862068965518im
Ybus3_matpower[2, 2] = 1.379310344827586 - 16.551724137931036im
Ybus3_matpower[3, 2] = -0.689655172413793 + 8.275862068965518im
Ybus3_matpower[1, 3] = -0.689655172413793 + 8.275862068965518im
Ybus3_matpower[2, 3] = -0.689655172413793 + 8.275862068965518im
Ybus3_matpower[3, 3] = 1.379310344827586 - 16.351724137931036im
