<h1 align="center"><i>Bmono</i></h1>
<p align="center">Mono font that <i>SuperB</i></p>
<p align="center"><img src="https://user-images.githubusercontent.com/43980777/115989432-85c1d300-a5e8-11eb-9eb9-974865659754.png"></p>
<p align="center"><a href="https://github.com/NNBnh/bmono/blob/main/LICENSE"><img src="https://img.shields.io/badge/license-ofl--1.1-%23FFC387.svg?labelColor=585858&style=for-the-badge&logoColor=FFFFFF" alt="License: OFL-1.1"></a> <a href="https://github.com/be5invis/Iosevka/releases/tag/v11.2.2"><img src="https://img.shields.io/badge/iosevka_version-11.2.2-%23FFC387.svg?labelColor=585858&style=for-the-badge&logoColor=FFFFFF" alt="Iosevka version: 11.2.2"></a></p>

## 💡 About
**Bmono** is a *SuperB* mono font, it's a custom build of [**Iosevka**](https://github.com/be5invis/Iosevka). It focuses on **simplicity**, **readability** and **style**.

### ✨ Features
- **Simplicity**:
  - `dollar = "open"`, `cent = "open"` and `percent = "rings-connected"`: makes the symbols less cluttered with less overlap
- **Consistency**:
  - `asterisk = "penta-low"` and `caret = "low"`: make it the same height as other math symbols(`-`, `+`, `=`, ...)
  - `bar = "force-upright"` and `disables = [ "logic" ]`: so the textart/ASCII-art doesn't look weird on italic
- **Readability**:
  - Extended width: make the font wider
  - `l = "serifed-tailed"`: makes it easier to distinguish from `1` and `I` (`1lI`)
  - `zero = "dotted"`: makes it easier to distinguish from `O` (`0O`) but more simple than `slashed`
- **Style**:
  - Curly style (`ss20`): make the font curly
  - `capital-g = "toothless-rounded-serifless-hooked"` and `eight = "two-circles"`: rounding off those symbols
  - `paren = "large-contour"`: make `()` and `(-)` look more like a circle than an ellipse
- **Functionality**:
  - Discretionary ligatures: to get more ligatures, make it comparable to [Fira Code](https://github.com/tonsky/FiraCode)

> ### 👋 Good bye
>
> When I create this project, my goal is to make a Iosevka font that fix the [ligatures on Kitty bug](https://github.com/be5invis/Iosevka/issues/1326) and come with some tiny tweak to make it slicker. But now the [Kitty bug had been fixed](https://github.com/be5invis/Iosevka/pull/1403), you can tweak the font by using [stylistic sets/character variants](https://github.com/be5invis/Iosevka/issues/1376), plus I'm too lazy to maintain this project. So I decided to archive this project, thank you everyone following this project and 400~ people whom had download and use Bmono. Stay fresh!

## 📥 Installation

<p align="center"><a href="https://bulletproof.italic.space/lettering?preload=https%3A%2F%2Fraw.githubusercontent.com%2FNNBnh%2Fbmono%2Fmain%2Fdist%2Fbmono%2Fttf%2Fbmono-regular.ttf"><img src="https://img.shields.io/badge/try_out-%23FFC387.svg?labelColor=585858&style=for-the-badge&logoColor=FFFFFF" alt="Try out"></a> <a href="https://github.com/NNBnh/bmono/releases"><img src="https://img.shields.io/github/downloads/NNBnh/bmono/total?color=FFC387&labelColor=585858&style=for-the-badge&logoColor=FFFFFF" alt="Downloads"></a></p>

### 📦 Package manager
For [Arch Linux](https://archlinux.org), you can install through [AUR](https://aur.archlinux.org):
```sh
paru -Suy ttf-bmono
```

For [Nix/NixOS](https://nixos.org), you can install [Bmono's NUR package](https://nur.nix-community.org/repos/nnb).

> **Note** If you can and want to port Bmono to other package managers, feel free to do so.

## 🔰 Tutorial
[Learn how to build your own Iosevka custom font](https://github.com/NNBnh/dotfiles/wiki/font)

## 💌 Credits
Special thanks to:
- [**Iosevka**](https://github.com/be5invis/Iosevka) by [Belleve](https://github.com/be5invis)
- [**Iosevka docker**](https://github.com/avivace/iosevka-docker) by [Antonio Vivace](https://github.com/avivace)

<br><br><br><br>

---

> <h1 align="center">Made with ❤️ by <a href="https://github.com/NNBnh"><i>NNB</i></a></h1>
>
> <p align="center"><a href="https://www.buymeacoffee.com/nnbnh"><img src="https://img.shields.io/badge/buy_me_a_coffee%20-%23FFC387.svg?logo=buy-me-a-coffee&logoColor=333333&style=for-the-badge" alt="Buy Me a Coffee"></a></p>
