## Change Log

See also [releases](https://github.com/NLog/NLog.Web/releases) and [milestones](https://github.com/NLog/NLog.Web/milestones).

Date format: (year/month/day)

### Version 5.3.15 (2024/11/21)

- **NLog.Web.AspNetCore**
  - [#1066](https://github.com/NLog/NLog.Web/pull/1066) UseNLog Allow fallback to only EnvironmentName for NLog config (#1066) (@snakefoot)
  - [#1067](https://github.com/NLog/NLog.Web/pull/1067) Updated dependency NLog.Extensions.Logging v5.3.15 (#1067) (@snakefoot)

### Version 5.3.14 (2024/09/23)

- **NLog.Web.AspNetCore**
  - [#1055](https://github.com/NLog/NLog.Web/pull/1055) UseNLog should fallback after checking ContentRoot for NLog.config (#1055) (@snakefoot)
  - [#1055](https://github.com/NLog/NLog.Web/pull/1055) Updated dependency NLog.Extensions.Logging v5.3.14 (#1055) (@snakefoot)

### Version 5.3.13 (2024/09/12)

- **NLog.Web.AspNetCore**
  - [#1053](https://github.com/NLog/NLog.Web/pull/1053) AspNetRequestUrlRenderer - Mark Properties-option as DefaultParameter (#1053) (@snakefoot)
  - [#1054](https://github.com/NLog/NLog.Web/pull/1054) Updated dependency NLog.Extensions.Logging v5.3.13 (#1054) (@snakefoot)

- **NLog.Web**
  - [#1053](https://github.com/NLog/NLog.Web/pull/1053) AspNetRequestUrlRenderer - Mark Properties-option as DefaultParameter (#1053) (@snakefoot)
  - [#1054](https://github.com/NLog/NLog.Web/pull/1054) Updated dependency NLog v5.3.4 (#1054) (@snakefoot)

### Version 5.3.12 (2024/08/12)

- **NLog.Web.AspNetCore**
  - [#1051](https://github.com/NLog/NLog.Web/pull/1051) Updated dependency NLog.Extensions.Logging v5.3.12 (#1051) (@snakefoot)

- **NLog.Web**
  - [#1051](https://github.com/NLog/NLog.Web/pull/1051) Updated dependency NLog v5.3.3 (#1051) (@snakefoot)

### Version 5.3.11 (2024/05/07)

- **NLog.Web.AspNetCore**
  - [#1037](https://github.com/NLog/NLog.Web/pull/1037) Updated dependency NLog.Extensions.Logging v5.3.11 (#1037) (@snakefoot)

### Version 5.3.10 (2024/04/30)

- **NLog.Web.AspNetCore**
  - [#1035](https://github.com/NLog/NLog.Web/pull/1035) Updated dependency NLog.Extensions.Logging v5.3.10 (#1035) (@snakefoot)

- **NLog.Web**
  - [#1035](https://github.com/NLog/NLog.Web/pull/1035) Updated dependency NLog v5.3.2 (#1035) (@snakefoot)

### Version 5.3.9 (2024/04/27)

- **NLog.Web.AspNetCore**
  - [#1031](https://github.com/NLog/NLog.Web/pull/1031) Updated dependency NLog.Extensions.Logging v5.3.9 (#1031) (@snakefoot)

- **NLog.Web**
  - [#1031](https://github.com/NLog/NLog.Web/pull/1031) Updated dependency NLog v5.3.1 (#1031) (@snakefoot)

### Version 5.3.8 (2023/12/29)

- **NLog.Web.AspNetCore**
  - [#1012](https://github.com/NLog/NLog.Web/pull/1012) UseNLog includes EnvironmentName when loading NLog config (#1012) (@snakefoot)
  - [#1020](https://github.com/NLog/NLog.Web/pull/1020) Updated dependency NLog.Extensions.Logging v5.3.8 (#1020) (@snakefoot)

- **NLog.Web**
  - [#1020](https://github.com/NLog/NLog.Web/pull/1020) Updated dependency NLog v5.2.8 (#1020) (@snakefoot)

### Version 5.3.7 (2023/12/06)

- **NLog.Web.AspNetCore**
  - [#1010](https://github.com/NLog/NLog.Web/pull/1010) Added target platform for NET 8.0 (#1010) (@snakefoot)
  - [#1011](https://github.com/NLog/NLog.Web/pull/1011) Updated dependency NLog.Extensions.Logging v5.3.7 (#1011) (@snakefoot)

- **NLog.Web**
  - [#1011](https://github.com/NLog/NLog.Web/pull/1011) Updated dependency NLog v5.2.7 (#1011) (@snakefoot)

### Version 5.3.5 (2023/10/15)

- **NLog.Web.AspNetCore**
  - [#992](https://github.com/NLog/NLog.Web/pull/992) Updated dependency NLog.Extensions.Logging v5.3.5 (#992) (@snakefoot)

- **NLog.Web**
  - [#992](https://github.com/NLog/NLog.Web/pull/992) Updated dependency NLog v5.2.5 (#992) (@snakefoot)

### Version 5.3.4 (2023/09/06)

- **NLog.Web.AspNetCore**
  - [#983](https://github.com/NLog/NLog.Web/pull/983) Updated dependency NLog.Extensions.Logging v5.3.4 (#983) (@snakefoot)

- **NLog.Web**
  - [#983](https://github.com/NLog/NLog.Web/pull/983) Updated dependency NLog v5.2.4 (#983) (@snakefoot)

### Version 5.3.3 (2023/08/06)

- **NLog.Web.AspNetCore**
  - [#975](https://github.com/NLog/NLog.Web/pull/975) Extended AspNetUserClaimLayoutRenderer to handle multi-values (#975) (@bakgerman)
  - [#979](https://github.com/NLog/NLog.Web/pull/979) Better diagnostics when missing HttpModule or MiddleWare (#979) (@bakgerman)
  - [#973](https://github.com/NLog/NLog.Web/pull/973) Updated XML docs for LoadConfigurationFromAppSettings (#973) (@snakefoot)
  - [#978](https://github.com/NLog/NLog.Web/pull/978) Updated dependency NLog.Extensions.Logging v5.3.3 (#978) (@snakefoot)

- **NLog.Web**
  - [#975](https://github.com/NLog/NLog.Web/pull/975) Extended AspNetUserClaimLayoutRenderer to handle multi-values (#975) (@bakgerman)
  - [#979](https://github.com/NLog/NLog.Web/pull/979) Better diagnostics when missing HttpModule or MiddleWare (#979) (@bakgerman)
  - [#978](https://github.com/NLog/NLog.Web/pull/978) Updated dependency NLog v5.2.3 (#978) (@snakefoot)

### Version 5.3.2 (2023/07/04)

- **NLog.Web.AspNetCore**
  - [#962](https://github.com/NLog/NLog.Web/pull/962) NLogRequestPostedBodyMiddleware - Fixed handling of Stream.Position (#962) (@snakefoot)
  - [#964](https://github.com/NLog/NLog.Web/pull/964) Updated dependency NLog.Extensions.Logging v5.3.2 (#964) (@snakefoot)

- **NLog.Web**
  - [#964](https://github.com/NLog/NLog.Web/pull/964) Updated dependency NLog v5.2.2 (#964) (@snakefoot)

### Version 5.3.1 (2023/07/01)

- **NLog.Web.AspNetCore**
  - [#958](https://github.com/NLog/NLog.Web/pull/958) NLogRequestPostedBodyMiddleware - Fixed handling of Stream.CanSeek (#958) (@snakefoot)
  - [#959](https://github.com/NLog/NLog.Web/pull/959) Updated dependency NLog.Extensions.Logging v5.3.1 (#959) (@snakefoot)

- **NLog.Web**
  - [#959](https://github.com/NLog/NLog.Web/pull/959) Updated dependency NLog v5.2.1 (#959) (@snakefoot)
  - [#952](https://github.com/NLog/NLog.Web/pull/952) AspNetRequestHasPostedBodyLayoutRenderer - Available for NLog.Web (#952) (@snakefoot)

### Version 5.3.0 (2023/05/30)

- **NLog.Web.AspNetCore**
  - [#943](https://github.com/NLog/NLog.Web/pull/943) UseNLog - Replaced dynamic assembly loading with registration methods (#943) (@snakefoot)
  - [#943](https://github.com/NLog/NLog.Web/pull/943) Updated to NLog.Extensions.Logging v5.3 (#943) (@snakefoot)
  - [#934](https://github.com/NLog/NLog.Web/pull/934) AspNetLayoutRenderers - Items-property is standard, and Names-option is obsolete (#934) (@snakefoot)
  - [#936](https://github.com/NLog/NLog.Web/pull/936) aspnet-request-endpoint - EndPoint Routing DisplayName (#936) (@snakefoot)
  - [#932](https://github.com/NLog/NLog.Web/pull/932) NLogRequestPostedBodyMiddleware - Check HttpRequest CanHaveBody (#932) (@snakefoot)
 
- **NLog.Web**
  - [#943](https://github.com/NLog/NLog.Web/pull/943) RegisterNLogWeb - Replaced dynamic assembly loading with registration methods (#943) (@snakefoot)
  - [#943](https://github.com/NLog/NLog.Web/pull/943) Updated to NLog v5.2 (#943) (@snakefoot)
  - [#934](https://github.com/NLog/NLog.Web/pull/934) AspNetLayoutRenderers - Items-property is standard, and Names-option is obsolete (#934) (@snakefoot)
  - [#942](https://github.com/NLog/NLog.Web/pull/942) AspNetBufferingTargetWrapper - Register for initial request, when loading NLog config (#942) (@snakefoot)

### Version 5.2.3 (2023/03/28)

- **NLog.Web.AspNetCore**
  - [#929](https://github.com/NLog/NLog.Web/pull/929) Updated dependency NLog.Extensions.Logging v5.2.3 (#929) (@snakefoot)

- **NLog.Web**
  - [#929](https://github.com/NLog/NLog.Web/pull/929) Updated dependency NLog v5.1.3 (#929) (@snakefoot)

### Version 5.2.2 (2023/02/17)

- **NLog.Web.AspNetCore**
  - [#917](https://github.com/NLog/NLog.Web/pull/917) AspNetQueryStringLayoutRenderer - Added Exclude-option for consistency (#917) (@snakefoot)
  - [#918](https://github.com/NLog/NLog.Web/pull/918) AspNetRequestFormLayoutRenderer - Added Items-option for consistency (#918) (@snakefoot)
  - [#921](https://github.com/NLog/NLog.Web/pull/921) AspNet Response HttpStatusCode LayoutRenderer as Enum.ToString (#921) (@bakgerman)
  - [#923](https://github.com/NLog/NLog.Web/pull/923) AspNet Request-Ip with support for CheckForwardedForHeaderOffset (#923) (@bakgerman)  
  - [#924](https://github.com/NLog/NLog.Web/pull/924) AspNetBufferingTargetWrapper - BufferGrowLimit cealing BufferSize (#924) (@snakefoot)
  - [#927](https://github.com/NLog/NLog.Web/pull/927) Updated dependency NLog.Extensions.Logging v5.2.2 (#927) (@snakefoot)

- **NLog.Web**
  - [#917](https://github.com/NLog/NLog.Web/pull/917) AspNetQueryStringLayoutRenderer - Added Exclude-option for consistency (#917) (@snakefoot)
  - [#918](https://github.com/NLog/NLog.Web/pull/918) AspNetRequestFormLayoutRenderer - Added Items-option for consistency (#918) (@snakefoot)
  - [#921](https://github.com/NLog/NLog.Web/pull/921) AspNet Response HttpStatusCode LayoutRenderer as Enum.ToString (#921) (@bakgerman)
  - [#924](https://github.com/NLog/NLog.Web/pull/924) AspNetBufferingTargetWrapper - BufferGrowLimit cealing BufferSize (#924) (@snakefoot)
  - [#927](https://github.com/NLog/NLog.Web/pull/927) Updated dependency NLog v5.1.2 (#927) (@snakefoot)

### Version 5.2.1 (2022/12/29)

- **NLog.Web.AspNetCore**
  - [#900](https://github.com/NLog/NLog.Web/pull/900) Introduced NLogBufferingTargetWrapperMiddleware to support AspNetBufferingWrapper (#900) (@bakgerman)
  - [#898](https://github.com/NLog/NLog.Web/pull/898) Created README.md for the NLog.Web.AspNetCore nuget-package (#898) (@bakgerman)
  - [#895](https://github.com/NLog/NLog.Web/pull/895) Add ObjectPath to AspNetApplicationValueLayoutRenderer (#895) (@snakefoot)
  - [#904](https://github.com/NLog/NLog.Web/pull/904) Added common Items-property for LayoutRenderers that can output multiple values. Ex Headers/Cookies (#904) (@snakefoot)
  - [#915](https://github.com/NLog/NLog.Web/pull/915) Updated dependency NLog.Extensions.Logging v5.2.1 (#915) (@snakefoot)

- **NLog.Web**
  - [#900](https://github.com/NLog/NLog.Web/pull/900) Extend AspNetBufferingWrapper to allow use with other integrations than NLogHttpModule (#900) (@bakgerman)
  - [#898](https://github.com/NLog/NLog.Web/pull/898) Created README.md for the NLog.Web nuget-package (#898) (@bakgerman)
  - [#895](https://github.com/NLog/NLog.Web/pull/895) Add ObjectPath to AspNetApplicationValueLayoutRenderer (#895) (@snakefoot)
  - [#904](https://github.com/NLog/NLog.Web/pull/904) Added common Items-property for LayoutRenderers that can output multiple values. Ex Headers/Cookies (#904) (@snakefoot)
  - [#906](https://github.com/NLog/NLog.Web/pull/906) Skip unnecessary allocation of HttpContextWrapper for all ASP.NET layout-renderers  (#906) (@snakefoot)
  - [#915](https://github.com/NLog/NLog.Web/pull/915) Updated dependency NLog v5.1.1 (#915) (@snakefoot)

### Version 5.2.0 (2022/11/27)

- **NLog.Web.AspNetCore**
  - [#885](https://github.com/NLog/NLog.Web/pull/885) Changed LoadConfigurationFromAppSettings to prioritize current directory (#885) (@snakefoot)
  - [#887](https://github.com/NLog/NLog.Web/pull/887) Changed AspNetAppBasePathLayoutRenderer to prioritize current directory (#887) (@snakefoot)
  - [#890](https://github.com/NLog/NLog.Web/pull/890) Add ObjectPath to AspNetItemValueLayoutRenderer as better alternative to EvaluateAsNestedProperties (#890) (@bakgerman)
  - [#894](https://github.com/NLog/NLog.Web/pull/894) Add ObjectPath to AspNetSessionValueLayoutRenderer as better alternative to EvaluateAsNestedProperties (#894) (@snakefoot)
  - [#889](https://github.com/NLog/NLog.Web/pull/889) Use CallerArgumentExpressionAttribute in helper method for throwing ArgumentNullException (#889) (@bakgerman)
  - [#891](https://github.com/NLog/NLog.Web/pull/891) Skip allocating RouteData when only need to lookup single value (#891)  (@snakefoot)
  - [#878](https://github.com/NLog/NLog.Web/pull/878) + [#879](https://github.com/NLog/NLog.Web/pull/879) Use RegisterConfigSettings instead of ConfigSettingLayoutRenderer (#878 + #879) (@snakefoot)
  - [#894](https://github.com/NLog/NLog.Web/pull/894) Updated dependency NLog.Extensions.Logging v5.2.0 (#894) (@snakefoot)

- **NLog.Web**
  - [#890](https://github.com/NLog/NLog.Web/pull/890) Add ObjectPath to AspNetItemValueLayoutRenderer as better alternative to EvaluateAsNestedProperties (#890) (@bakgerman)
  - [#894](https://github.com/NLog/NLog.Web/pull/894) Add ObjectPath to AspNetSessionValueLayoutRenderer as better alternative to EvaluateAsNestedProperties (#894) (@snakefoot)
  - [#889](https://github.com/NLog/NLog.Web/pull/889) Use CallerArgumentExpressionAttribute in helper method for throwing ArgumentNullException (#889) (@bakgerman)
  - [#894](https://github.com/NLog/NLog.Web/pull/894) Updated dependency NLog v5.1.0 (#894) (@snakefoot)

### Version 5.1.5 (2022/10/26)

- **NLog.Web.AspNetCore**
  - [#876](https://github.com/NLog/NLog.Web/pull/876) Introduced NET6 since LTS (#876) (@snakefoot)
  - [#876](https://github.com/NLog/NLog.Web/pull/876) Updated NLog.Extensions.Logging to v5.1.0 (#876) (@snakefoot)

- **NLog.Web**
  - [#876](https://github.com/NLog/NLog.Web/pull/876) Updated dependency NLog v5.0.5 (#876) (@snakefoot)

### Version 5.1.4 (2022/09/01)

- **NLog.Web.AspNetCore**
  - [#865](https://github.com/NLog/NLog.Web/pull/865) Added embedded resource ILLink.Descriptors.xml (#865) (@snakefoot)
  - [#865](https://github.com/NLog/NLog.Web/pull/865) Updated NLog.Extensions.Logging to v5.0.4 (#865) (@snakefoot)

- **NLog.Web**
  - [#865](https://github.com/NLog/NLog.Web/pull/865) Updated dependency NLog v5.0.4 (#863) (@snakefoot)

### Version 5.1.2 (2022/09/01)

- **NLog.Web.AspNetCore**
  - [#861](https://github.com/NLog/NLog.Web/pull/861) Loading NLog.config from ContentRootPath as last fallback (#861) (@snakefoot)
  - [#858](https://github.com/NLog/NLog.Web/pull/858) Updated Microsoft.AspNetCore.Abstractions to match Microsoft.AspNetCore.Http (#858) (@snakefoot)
  - [#863](https://github.com/NLog/NLog.Web/pull/863) Updated NLog.Extensions.Logging to v5.0.3 (#863) (@snakefoot)

- **NLog.Web**
  - [#863](https://github.com/NLog/NLog.Web/pull/863) Updated dependency NLog v5.0.3 (#863) (@snakefoot)

### Version 5.1.1 (2022/08/17)

- **NLog.Web.AspNetCore**
  - [#836](https://github.com/NLog/NLog.Web/pull/836) Fixed offset by one in AspNetRequestDurationLayoutRenderer (#836) (@snakefoot)
  - [#840](https://github.com/NLog/NLog.Web/pull/840) Added option LowercaseKeys for ${aspnet-request-querystring} (#840) (@czd890)
  - [#845](https://github.com/NLog/NLog.Web/pull/845) Added ${aspnet-request-has-posted-body} Layout Renderer (#845) (@bakgerman)
  - [#845](https://github.com/NLog/NLog.Web/pull/845) Added ${aspnet-request-stream-id} Layout Renderer (#845) (@bakgerman)
  - [#850](https://github.com/NLog/NLog.Web/pull/850) + [#853](https://github.com/NLog/NLog.Web/pull/853)  Improved re-Entrancy scope lock for Session Value Layout Render (#850) (@bakgerman)
  - [#854](https://github.com/NLog/NLog.Web/pull/854) Updated dependency NLog.Extensions.Logging v5.0.2 (#854) (@snakefoot)
  - [#856](https://github.com/NLog/NLog.Web/pull/856) Added option Properties for ${aspnet-request-url} instead of booleans (#856) (@bakgerman)

- **NLog.Web**
  - [#836](https://github.com/NLog/NLog.Web/pull/836) Fixed offset by one in AspNetRequestDurationLayoutRenderer (#836) (@snakefoot)
  - [#840](https://github.com/NLog/NLog.Web/pull/840) Added option LowercaseKeys for ${aspnet-request-querystring} (#840) (@czd890)
  - [#854](https://github.com/NLog/NLog.Web/pull/854) Updated dependency NLog v5.0.2 (#854) (@snakefoot)
  - [#856](https://github.com/NLog/NLog.Web/pull/856) Added option Properties for ${aspnet-request-url} instead of booleans (#856) (@bakgerman)

### Version 5.1.0 (2022/07/18)

- **NLog.Web.AspNetCore**
  - [#828](https://github.com/NLog/NLog.Web/pull/828) Reverted default value for ShutdownOnDispose to false (#828) (@snakefoot)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-request-trailers} Layout Renderer (#815) (@bakgerman)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-response-trailers} Layout Renderer (#815) (@bakgerman)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-response-https-compression} Layout Renderer (#815) (@bakgerman)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-request-tracking-consent} Layout Renderer (#815) (@bakgerman)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-request-tls-token-binding} Layout Renderer (#815) (@bakgerman)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-request-inherent-keep-alive} Layout Renderer (#815) (@bakgerman)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-request-http-transport-type} Layout Renderer (#815) (@bakgerman)
  - [#815](https://github.com/NLog/NLog.Web/pull/815) Added ${aspnet-request-bidirectional-stream} Layout Renderer (#815) (@bakgerman)
  - [#811](https://github.com/NLog/NLog.Web/pull/811) Added ${aspnet-request-servervariable} Layout Renderer (#811) (@bakgerman)
  - [#802](https://github.com/NLog/NLog.Web/pull/802) Added ${aspnet-request-tls-handshake} Layout Renderer (#802) (@bakgerman)
  - [#796](https://github.com/NLog/NLog.Web/pull/796) Added ${aspnet-request-connection-id} Layout Renderer (#796) (@bakgerman)
  - [#796](https://github.com/NLog/NLog.Web/pull/796) Added ${aspnet-response-has-started} Layout Renderer (#796) (@bakgerman)
  - [#789](https://github.com/NLog/NLog.Web/pull/789) Added ${aspnet-response-cookie} Layout Renderer (#789) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-client-certificate} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-is-web-socket} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-local-ip} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-local-port} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-remote-port} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-web-socket-requested-protocols} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-response-contenttype} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-response-headers} Layout Renderer (#784) (@bakgerman)
  - [#781](https://github.com/NLog/NLog.Web/pull/781) NLogRequestPostedBodyMiddleware - Restore support for ${aspnet-request-posted-body} (#781) (@bakgerman)
  - [#783](https://github.com/NLog/NLog.Web/pull/783) NLogRequestLoggingMiddleware - Added support for custom ShouldLogRequest-delegate (#783) (@snakefoot)

- **NLog.Web**
  - [#811](https://github.com/NLog/NLog.Web/pull/811) Added ${aspnet-request-servervariable} Layout Renderer (#811) (@bakgerman)
  - [#796](https://github.com/NLog/NLog.Web/pull/796) Added ${aspnet-response-has-started} Layout Renderer for NET46 (#796) (@bakgerman)
  - [#789](https://github.com/NLog/NLog.Web/pull/789) Added ${aspnet-response-cookie} Layout Renderer (#789) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-client-certificate} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-is-web-socket} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-local-ip} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-local-port} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-remote-port} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-request-web-socket-requested-protocols} Layout Renderer for NET46 (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-response-contenttype} Layout Renderer (#784) (@bakgerman)
  - [#784](https://github.com/NLog/NLog.Web/pull/784) Added ${aspnet-response-headers} Layout Renderer (#784) (@bakgerman)
  - [#785](https://github.com/NLog/NLog.Web/pull/785) NLogRequestPostedBodyModule - Restore support for ${aspnet-request-posted-body} (#785) (@bakgerman)
  - [#792](https://github.com/NLog/NLog.Web/pull/792) Added ${aspnet-user-claim} Layout Renderer for NET46 (#792) (@snakefoot)

### Version 5.0.0 (2022/05/17)

- **NLog.Web.AspNetCore**
  - [#749](https://github.com/NLog/NLog.Web/pull/749) Include ContentRootPath when scanning for NLog.config candidate (#749) (@snakefoot)
  - [#747](https://github.com/NLog/NLog.Web/pull/747) NLogRequestLogging - Added DurationThresholdMs + ExcludeRequestPaths (#747) (@snakefoot)
  - [#734](https://github.com/NLog/NLog.Web/pull/734) LogManager.Setup() - Added support for RegisterAspNetLayoutRenderer (#734) (@snakefoot)
  - [#735](https://github.com/NLog/NLog.Web/pull/735) Changed format Culture to InvariantCulture to match default NLog Culture (#735) (@snakefoot)
  - [#736](https://github.com/NLog/NLog.Web/pull/736) Added sample for ASP.NET Core 6.0 on .NET 6 (#736) (@ThomasArdal)
  - [#740](https://github.com/NLog/NLog.Web/pull/740) Added ${aspnet-request-routeparameters} (#740) (@ThomasArdal)
  - [#741](https://github.com/NLog/NLog.Web/pull/741) Changed from Convert.ToString to IValueFormatter to be like NLog default (#741) (@snakefoot)
  - [#701](https://github.com/NLog/NLog.Web/pull/701) Replaced platform NetCoreApp3.0 with NetCoreApp3.1 and added Net5.0 (#701) (@snakefoot)
  - [#683](https://github.com/NLog/NLog.Web/pull/683) Dropped support for ASP.NET Core 1 and NetStandard1.5 + Net452 (#683) (@304NotModified)
  - [#691](https://github.com/NLog/NLog.Web/pull/691) Enabled ShutdownOnDispose by default to follow lifetime of the ServiceProvider (#691) (@snakefoot)
  - [#700](https://github.com/NLog/NLog.Web/pull/700) Added W3CExtendedLogLayout for writing W3C Extended Logs (#700) (@snakefoot)
  - [#697](https://github.com/NLog/NLog.Web/pull/697) Replaced SingleAsArray with OutputFormat = JsonArray + JsonDictionary (#697) (@snakefoot)

- **NLog.Web**
  - [#734](https://github.com/NLog/NLog.Web/pull/734) LogManager.Setup() - Added support for RegisterNLogWeb + RegisterAspNetLayoutRenderer (#734) (@snakefoot)
  - [#735](https://github.com/NLog/NLog.Web/pull/735) Changed format Culture to InvariantCulture to match default NLog Culture (#735) (@snakefoot)
  - [#740](https://github.com/NLog/NLog.Web/pull/740) Added ${aspnet-request-routeparameters} (#740) (@ThomasArdal)
  - [#741](https://github.com/NLog/NLog.Web/pull/741) Changed from Convert.ToString to IValueFormatter to be like NLog default (#741) (@snakefoot)
  - [#701](https://github.com/NLog/NLog.Web/pull/701) Added platform Net46 (#701) (@snakefoot)
  - [#700](https://github.com/NLog/NLog.Web/pull/700) Added W3CExtendedLogLayout for writing W3C Extended Logs (#700) (@snakefoot)
  - [#697](https://github.com/NLog/NLog.Web/pull/697) Replaced SingleAsArray with OutputFormat = JsonArray + JsonDictionary (#697) (@snakefoot)

See also [List of major changes in NLog 5](https://nlog-project.org/2021/08/25/nlog-5-0-preview1-ready.html)

### Version 5.0-rc2 (2022/01/19)

- **NLog.Web.AspNetCore**
  - [#749](https://github.com/NLog/NLog.Web/pull/749) Include ContentRootPath when scanning for NLog.config candidate (#749) (@snakefoot)
  - [#747](https://github.com/NLog/NLog.Web/pull/747) NLogRequestLogging - Added DurationThresholdMs + ExcludeRequestPaths (#747) (@snakefoot)

### Version 5.0-rc1 (2021/12/20)

- **NLog.Web.AspNetCore**
  - [#734](https://github.com/NLog/NLog.Web/pull/734) LogManager.Setup() - Added support for RegisterAspNetLayoutRenderer (#734) (@snakefoot)
  - [#735](https://github.com/NLog/NLog.Web/pull/735) Changed format Culture to InvariantCulture to match default NLog Culture (#735) (@snakefoot)
  - [#736](https://github.com/NLog/NLog.Web/pull/736) Added sample for ASP.NET Core 6.0 on .NET 6 (#736) (@ThomasArdal)
  - [#740](https://github.com/NLog/NLog.Web/pull/740) Added ${aspnet-request-routeparameters} (#740) (@ThomasArdal)
  - [#741](https://github.com/NLog/NLog.Web/pull/741) Changed from Convert.ToString to IValueFormatter to be like NLog default (#741) (@snakefoot)

- **NLog.Web**
  - [#734](https://github.com/NLog/NLog.Web/pull/734) LogManager.Setup() - Added support for RegisterNLogWeb + RegisterAspNetLayoutRenderer (#734) (@snakefoot)
  - [#735](https://github.com/NLog/NLog.Web/pull/735) Changed format Culture to InvariantCulture to match default NLog Culture (#735) (@snakefoot)
  - [#740](https://github.com/NLog/NLog.Web/pull/740) Added ${aspnet-request-routeparameters} (#740) (@ThomasArdal)
  - [#741](https://github.com/NLog/NLog.Web/pull/741) Changed from Convert.ToString to IValueFormatter to be like NLog default (#741) (@snakefoot)

### Version 5.0-preview 3 (2021/10/28)

- **NLog.Web.AspNetCore**
  - [#701](https://github.com/NLog/NLog.Web/pull/701) Replaced platform NetCoreApp3.0 with NetCoreApp3.1 and added Net5.0 (#701) (@snakefoot)
  - [#683](https://github.com/NLog/NLog.Web/pull/683) Dropped support for ASP.NET Core 1 and NetStandard1.5 + Net452 (#683) (@304NotModified)
  - [#691](https://github.com/NLog/NLog.Web/pull/691) Enabled ShutdownOnDispose by default to follow lifetime of the ServiceProvider (#691) (@snakefoot)
  - [#700](https://github.com/NLog/NLog.Web/pull/700) Added W3CExtendedLogLayout for writing W3C Extended Logs (#700) (@snakefoot)
  - [#697](https://github.com/NLog/NLog.Web/pull/697) Replaced SingleAsArray with OutputFormat = JsonArray + JsonDictionary (#697) (@snakefoot)

- **NLog.Web**
  - [#701](https://github.com/NLog/NLog.Web/pull/701) Added platform Net46 (#701) (@snakefoot)
  - [#700](https://github.com/NLog/NLog.Web/pull/700) Added W3CExtendedLogLayout for writing W3C Extended Logs (#700) (@snakefoot)
  - [#697](https://github.com/NLog/NLog.Web/pull/697) Replaced SingleAsArray with OutputFormat = JsonArray + JsonDictionary (#697) (@snakefoot)

### Version 4.15 (2022/06/04)
- **NLog.Web.AspNetCore**
  - Bump NLog.Extensions.Logging from 1.7.4 to 1.7.5

- **NLog.Web**
  - Bump NLog from 4.7.11 to 4.7.15

### Version 4.14 (2021/08/28)
- **NLog.Web.AspNetCore**
  - [#677](https://github.com/NLog/NLog.Web/pull/677) Bump NLog.Extensions.Logging from 1.7.3 to 1.7.4 (#677) (@dependabot[bot])

- **NLog.Web**
  - [#674](https://github.com/NLog/NLog.Web/pull/674) Bump NLog from 4.7.10 to 4.7.11  (#674) (@dependabot[bot])

### Version 4.13 (2021/07/14)
- **NLog.Web.AspNetCore**
  - [#670](https://github.com/NLog/NLog.Web/pull/670) NLogAspNetCoreOptions - Added LoggingConfigurationSectionName (#670) (@snakefoot)
  - [#670](https://github.com/NLog/NLog.Web/pull/670) Bump NLog.Extensions.Logging to 1.7.3 (#670) (@snakefoot)
  - [#669](https://github.com/NLog/NLog.Web/pull/669) Updated xml-docs for AddNLog-methods to instead use AddNLogWeb (#669) (@snakefoot)

- **NLog.Web**
  - [#655](https://github.com/NLog/NLog.Web/pull/655) Bump NLog to 4.7.10 (#664) (@dependabot[bot])

### Version 4.12 (2021/03/29)
- **NLog.Web.AspNetCore**
  - [#657](https://github.com/NLog/NLog.Web/pull/657) NLogAspNetCoreOptions - Added ReplaceLoggerFactory and RemoveLoggerFactoryFilter (#657) (@snakefoot)
  - [#659](https://github.com/NLog/NLog.Web/pull/659) AspNetLayoutRendererBase.Register should cache IHttpContextAccessor (#659) (@304NotModified)
  - [#656](https://github.com/NLog/NLog.Web/pull/656) Bump NLog.Extensions.Logging to 1.7.2 (#656) (@dependabot[bot])

- **NLog.Web**
  - [#659](https://github.com/NLog/NLog.Web/pull/659) AspNetLayoutRendererBase.Register should cache IHttpContextAccessor (#659) (@304NotModified)
  - [#655](https://github.com/NLog/NLog.Web/pull/655) Bump NLog to 4.7.9  (#655) (@dependabot[bot])

### Version 4.11 (2021/02/27)
- **NLog.Web.AspNetCore**
  - [#644](https://github.com/NLog/NLog.Web/pull/644) Added readme.txt for the NuGet packages (#644) (@304NotModified)
  - [#639](https://github.com/NLog/NLog.Web/pull/639) Enable deterministic build (#639) (@304NotModified)
  - [#642](https://github.com/NLog/NLog.Web/pull/642) Added SourceLink (#642) (@304NotModified)
  - [#631](https://github.com/NLog/NLog.Web/pull/631) AspNetLayoutRendererBase - Added more debug-info when failing to lookup HttpContext (#631) (@snakefoot)
  - [#630](https://github.com/NLog/NLog.Web/pull/630) HttpContext - Extended ObjectDisposedException handling (#630) (@snakefoot)
  - [#631](https://github.com/NLog/NLog.Web/pull/631) AspNetLayoutRendererBase - Added more debug-info when failing to lookup HttpContext (#631) (@snakefoot)
  - [#626](https://github.com/NLog/NLog.Web/pull/626) Add AddNLogWeb with NLog LogFactory and NLogAspNetCoreOptions for better isolation (#626) (@snakefoot)
  - [#641](https://github.com/NLog/NLog.Web/pull/641) Bump NLog.Extensions.Logging from 1.7.0 to 1.7.1 (#641) (@dependabot[bot])

- **NLog.Web**
  - [#644](https://github.com/NLog/NLog.Web/pull/644) Added readme.txt for the NuGet packages (#644) (@304NotModified)
  - [#639](https://github.com/NLog/NLog.Web/pull/639) Enable deterministic build (#639) (@304NotModified)
  - [#642](https://github.com/NLog/NLog.Web/pull/642) Added SourceLink (#642) (@304NotModified)
  - [#635](https://github.com/NLog/NLog.Web/pull/635) Fix AssemblyVersionLayoutRenderer on ASP.NET to work with async=true (#634, #635) (@snakefoot)
  - [#631](https://github.com/NLog/NLog.Web/pull/631) AspNetLayoutRendererBase - Added more debug-info when failing to lookup HttpContext (#631) (@snakefoot)
  - [#636](https://github.com/NLog/NLog.Web/pull/636) Bump NLog from 4.7.6 to 4.7.8 (#629, #636) (@dependabot[bot])

### Version 4.10 (2020/12/30)
- **NLog.Web.AspNetCore**
  - [#614](https://github.com/NLog/NLog.Web/pull/614) ASPNETCORE_ENVIRONMENT takes now precedence over DOTNET_ENVIRONMENT (#614) (@snakefoot)
  - [#616](https://github.com/NLog/NLog.Web/pull/616) Move to PackageIcon and PackageLicenseExpression for NuGet package (#616) (@snakefoot, @304NotModified)
  - [#609](https://github.com/NLog/NLog.Web/pull/609) Added support for HttpContext.User claim lookup using ${aspnet-user-claim} (#609) (@snakefoot)
  - [#602](https://github.com/NLog/NLog.Web/pull/602) Introduced AddNLogWeb to avoid conflict with AddNLog from NLog.Extension.Logging (#602) (@snakefoot)
  - Updated NLog.Extensions.Logging dependency (Various pull requests)

- **NLog.Web**
  - [#616](https://github.com/NLog/NLog.Web/pull/616) Move to PackageIcon and PackageLicenseExpression for NuGet package (#616) (@snakefoot, @304NotModified)
  - Updated NLog dependency (Various pull requests)

### Version 4.9.3 (2020/08/01)
- **NLog.Web.AspNetCore**
  - [#549](https://github.com/NLog/NLog.Web/pull/549) ${aspnet-request-posted-body}: Use Async reading to prevent "Synchronous operations are disallowed" (#549) (@304NotModified)
  - [#570](https://github.com/NLog/NLog.Web/pull/570) ${aspnet-session} - added ValueType to handle integer session values (#570) (@304NotModified)
  - [#540](https://github.com/NLog/NLog.Web/pull/540) LogManager.Setup() - SetupBuilderExtension with LoadConfigurationFromAppSettings (#540) (@snakefoot)
  - [#567](https://github.com/NLog/NLog.Web/pull/567) Bump NLog.Extensions.Logging to 1.6.4 (#567) (@dependabot-preview[bot])

  - [#574](https://github.com/NLog/NLog.Web/pull/574) Create Dependabot config file (#574) (@dependabot-preview[bot])
  - [#553](https://github.com/NLog/NLog.Web/pull/553) Various code improvements (#553) (@304NotModified)

- **NLog.Web**
  - [#540](https://github.com/NLog/NLog.Web/pull/540) LogManager.Setup() - SetupBuilderExtension with LoadConfigurationFromAppSettings (#540) (@snakefoot)
  - [#565](https://github.com/NLog/NLog.Web/pull/565) Bump NLog from 4.7.0 to 4.7.2 (#565) (@dependabot-preview[bot])

  - [#574](https://github.com/NLog/NLog.Web/pull/574) Create Dependabot config file (#574) (@dependabot-preview[bot])
  - [#553](https://github.com/NLog/NLog.Web/pull/553) Various code improvements (#553) (@304NotModified)

### Version 4.9.2 (2020/04/20)
- **NLog.Web.AspNetCore**
  - [#546](https://github.com/NLog/NLog.Web/pull/546) ${aspnet-request-ip}: make ForwardedForHeader configurable (@304NotModified)
  - [#530](https://github.com/NLog/NLog.Web/pull/530) ${aspnet-request-url} Added UseRawTarget option (@sm-g, @304NotModified)

- **NLog.Web**
  - [#546](https://github.com/NLog/NLog.Web/pull/546) ${aspnet-request-ip}: make ForwardedForHeader configurable (@304NotModified)

### Version 4.9.1 (2020/03/25)
- **NLog.Web.AspNetCore**
  - [#524](https://github.com/NLog/NLog.Web/pull/524) ${aspnet-traceidentifier} should automatically check Activity.Current.Id for .NET Core 3 (@snakefoot)
  - [#527](https://github.com/NLog/NLog.Web/pull/527) Improved AddNLog with LoggingConfiguration to handle custom LogFactory (@snakefoot)

- **NLog.Web**
  - Updated dependencies

### Version 4.9.0 (2019/10/11)
This version adds support for ASP.NET Core 3 and some nice renderers has been added and improved!

- **NLog.Web.AspNetCore**
  - [#496](https://github.com/NLog/NLog.Web/pull/496) Support ASP.NET Core 3 (@snakefoot, @304NotModified)
  - [#491](https://github.com/NLog/NLog.Web/pull/491) Added example with ASP.NET Core 3 (@304NotModified)
  - [#477](https://github.com/NLog/NLog.Web/pull/477) Added ${aspnet-response-statuscode} - rendering response status code (@304NotModified, @ThomasArdal)
  - [#473](https://github.com/NLog/NLog.Web/pull/473) Added ${aspnet-request-headers} - rendering headers for ASP.NET and ASP.NET Core (@ThomasArdal)
  - [#472](https://github.com/NLog/NLog.Web/pull/472) ${aspnet-request-cookie} - Added Exclude option (@snakefoot)
  - [#465](https://github.com/NLog/NLog.Web/pull/465) ${aspnet-request-cookie} (without cookienames) will render all cookies (@304NotModified)
  - [#494](https://github.com/NLog/NLog.Web/pull/494) Added AddNLog with functor to create/initialize LogFactory for NLogLoggingProvider (@snakefoot)
  - [#483](https://github.com/NLog/NLog.Web/pull/483) AddNLog-methods for ILoggingBuilder (@snakefoot)

- **NLog.Web**
  - [#477](https://github.com/NLog/NLog.Web/pull/477) Added ${aspnet-response-statuscode} - rendering response status code (@304NotModified, @ThomasArdal)
  - [#473](https://github.com/NLog/NLog.Web/pull/473) Added ${aspnet-request-headers} - rendering headers for ASP.NET and ASP.NET Core (@ThomasArdal)
  - [#472](https://github.com/NLog/NLog.Web/pull/472) ${aspnet-request-cookie} - Added Exclude option (@snakefoot)
  - [#465](https://github.com/NLog/NLog.Web/pull/465) ${aspnet-request-cookie} (without cookienames) will render all cookies (@304NotModified)

### Version 4.8.6 (2019/09/30)
- **NLog.Web.AspNetCore**
  - [#487](https://github.com/NLog/NLog.Web/pull/487) Fixed: Mixing AddDebug() with a file based NLog configuration no longer works (@snakefoot)

### Version 4.8.5 (2019/09/07)
- **NLog.Web.AspNetCore**
  - [#459](https://github.com/NLog/NLog.Web/pull/459) Fixed double logging when mixing UseNLog with AddNLog (@snakefoot)

- **NLog.Web**
  - Updated dependencies

### Version 4.8.4 (2019/07/02)
- **NLog.Web.AspNetCore**
  - [#436](https://github.com/NLog/NLog.Web/pull/436) Better checking for availability of session (@Defee, @snakefoot)

- **NLog.Web**
  - [#442](https://github.com/NLog/NLog.Web/pull/442) Fixed Nuget-Package generation to include dependencies and release notes (@snakefoot)
  - [#436](https://github.com/NLog/NLog.Web/pull/436) Better checking for availability of session (@Defee, @snakefoot)

### Version 4.8.3 (2019/06/05)
- **NLog.Web.AspNetCore + NLog.Web**
  - [#428](https://github.com/NLog/NLog.Web/pull/428) Added AspNetLayoutRendererBase.Register for registering lambdas with httpcontext (@304NotModified)
  - [#431](https://github.com/NLog/NLog.Web/pull/431) Fix NotSupportedException with ${aspnet-request-posted-body} (@304NotModified)

### Version 4.8.2 (2019/05/06)
- **NLog.Web.AspNetCore**
  - [#401](https://github.com/NLog/NLog.Web/pull/401) Fixed that ${aspnet-request-posted-body} could lead to "A non-empty request body is required." in ASP.NET Core 2 (@snakefoot, @304NotModified)
  - [#401](https://github.com/NLog/NLog.Web/pull/401) Added MaxContentLength option to ${aspnet-request-posted-body} (@snakefoot, @304NotModified)

- **NLog.Web**
  - [#401](https://github.com/NLog/NLog.Web/pull/401) Added MaxContentLength option to ${aspnet-request-posted-body} (@snakefoot, @304NotModified)

### Version 4.8.1 (2019/03/18)
- **NLog.Web.AspNetCore**
  - [#339](https://github.com/NLog/NLog.Web/pull/339) Added ${aspnet-request-posted-body} - log posted request body/payload (@304NotModified)

- **NLog.Web**
  - [#339](https://github.com/NLog/NLog.Web/pull/339) Added ${aspnet-request-posted-body} - log posted request body/payload (@304NotModified)

### Version 4.8.0 (2019/01/30)
- **NLog.Web.AspNetCore**
  - [#335](https://github.com/NLog/NLog.Web/pull/335)   (@snakefoot)
  - Updated Microsoft.AspNetCore to ver. 2.1 (Long-Term-Support)
  - ${configsetting} layout renderer now depends on UseNLog-call to provide IConfiguration using IServiceProvider
  - NLogLoggerProvider options now binds to IConfiguration (Using section Logging:NLog)
  - UseNLog-call now also available for IHostBuilder

- **NLog.Web**
  - [#334](https://github.com/NLog/NLog.Web/pull/334) Added ${aspnet-request-contenttype} for NLog.Web (@snakefoot)

### Version 4.7.1 (2019/01/06)
- **NLog.Web.AspNetCore**
  - [#326](https://github.com/NLog/NLog.Web/pull/326) Added ThreadSafe-attribute for LayoutRenderer to optimize async Precalculate (@snakefoot)
  - [#325](https://github.com/NLog/NLog.Web/pull/325) ${AspNetRequestIp} added CheckForwardedForHeader to check for X-Forwarded-For header (@Giorgi)
  - [#322](https://github.com/NLog/NLog.Web/pull/322) Check that Content-Type is correct before accessing the Form (@mcliment)
  - [#333](https://github.com/NLog/NLog.Web/pull/333) Enabled SymbolPackageFormat=snupkg (@snakefoot)

- **NLog.Web**
  - [#330](https://github.com/NLog/NLog.Web/pull/330) aspnet-traceidentifier: Support for ASP.NET (non-core) - requires IIS ETW (@snakefoot)
  - [#326](https://github.com/NLog/NLog.Web/pull/326) Added ThreadSafe-attribute for LayoutRenderer to optimize async Precalculate (@snakefoot)
  - [#325](https://github.com/NLog/NLog.Web/pull/325) ${AspNetRequestIp} added CheckForwardedForHeader to check for X-Forwarded-For header (@Giorgi)

### Version 4.7 (2018/09/22)
- **NLog.Web.AspNetCore + NLog.Web**
  - [#315](https://github.com/NLog/NLog.Web/pull/315) Added ${configsetting} for reading appsettings.json etc - via NLog.Extensions.Logging (@304NotModified) (ASP.NET Core only)
  - [#313](https://github.com/NLog/NLog.Web/pull/313) Added ${aspnet-request-form} (@DrewBrasher)
  - [#317](https://github.com/NLog/NLog.Web/pull/317) Make separators layoutable for (${aspnet-request-querystring} and ${aspnet-request-cookie}) (@304NotModified)
  - [#314](https://github.com/NLog/NLog.Web/pull/314) Better missing HttpContext reporting & Skip null-check of HttpContextAccessor.HttpContext in DoAppend (@snakefoot)
  - [#312](https://github.com/NLog/NLog.Web/pull/312) Removed dependency on Microsoft.AspNetCore.Http.Extensions (@snakefoot) ASP.NET Core only)

### Version 4.6 (2018/08/05)
- **NLog.Web.AspNetCore + NLog.Web**
  - [#306](https://github.com/nlog/nlog.web/pull/306) Inherits AssemblyVersionLayoutRenderer from NLog implementation, so it has all NLog's features  (@alexangas)
  - [#307](https://github.com/nlog/nlog.web/pull/307) Added "ValuesOnly" property to Cookie and QueryString layout renderers + support for multivalue cookie keys in ASP.NET core (@alexangas)
  - [#303](https://github.com/nlog/nlog.web/pull/303) Improve error-handling during startup / shutdown for all layout renders using httpcontext

### Version 4.5.4 (2018/05/10)
- **NLog.Web.AspNetCore**
  - [#285](https://github.com/nlog/nlog.web/pull/285) Update NLog dependency (@304NotModified)

### Version 4.5.3 (2018/04/29)
- **NLog.Web.AspNetCore**
  - [#283](https://github.com/nlog/nlog.web/pull/283) Avoid assembly lookup on static class initialization (@snakefoot)

- **NLog.Web**
  - [#275](https://github.com/nlog/nlog.web/pull/275) ${aspnet-request-ip} handle emtpy Request on HttpContext (@304NotModified)

### Version 4.5.2 (2018/04/12)
- **NLog.Web.AspNetCore**
  - [#273](https://github.com/nlog/nlog.web/pull/273) Added public method to configure the NLog ServiceLocator (@snakefoot)
  - [#272](https://github.com/nlog/nlog.web/pull/272) Improved registration of hidden assemblies for callsite handling (@snakefoot)

### Version 4.5.1 (2018/04/02)
- **NLog.Web.AspNetCore**
  - [#268](https://github.com/nlog/nlog.web/pull/268) Improved ConfigureNLog for better out-of-the-box experience (@snakefoot)

### Version 4.5.0-aspnetcore (2018/03/27)
- [#257](https://github.com/nlog/nlog.web/pull/257) ConfigureNLog should not be used together with UseNLog (@snakefoot)
- [#256](https://github.com/nlog/nlog.web/pull/256) ASP.NET Core2 Example - Updated with NLog.LogManager.Shutdown() (@snakefoot)
- [#253](https://github.com/nlog/nlog.web/pull/253) ASP.NET Core2 Example - Updated blackhole configuration + ${aspnet-appbasepath} + ${aspnet-webrootpath} (@snakefoot)
- [#252](https://github.com/nlog/nlog.web/pull/252) Configured xunit DisableTestParallelization to make tests more stable (@snakefoot)
- [#250](https://github.com/nlog/nlog.web/pull/250) Removed System.ValueTuple as dependency for .NET Core app 1, add file version to assembly (@snakefoot)
- [#249](https://github.com/nlog/nlog.web/pull/249) Automatically register NLog.Web LayoutRenders for NetCoreApp1 (@snakefoot)
- [#245](https://github.com/nlog/nlog.web/pull/245) Use LogManager.LoadConfiguration + RC3 (@snakefoot)
- [#236](https://github.com/nlog/nlog.web/pull/236) AspNetCore 4.5 RC2 - Update changelog and version (@304NotModified)
- [#232](https://github.com/nlog/nlog.web/pull/232) Updated dependencies (@304NotModified)
- [#233](https://github.com/nlog/nlog.web/pull/233) Better hide assemblies for ${callsite} (@304NotModified)
- [#231](https://github.com/nlog/nlog.web/pull/231) Made ServiceLocator public (@304NotModified)
- [#226](https://github.com/nlog/nlog.web/pull/226) ASP.NET core: 4.5 rc1 + changelog (@304NotModified)
- [#223](https://github.com/nlog/nlog.web/pull/223) .NET 4.6.1 + ASP.NET Core 2 support (@304NotModified)
- [#224](https://github.com/nlog/nlog.web/pull/224) Fix assembly-version (@304NotModified)
- [#212](https://github.com/nlog/nlog.web/pull/212) Beta4 (@304NotModified)
- [#207](https://github.com/nlog/nlog.web/pull/207) Fix ${callsite} from configure (@304NotModified)

### Version 4.5.0-aspnetcore-beta02 (2017/10/13)
- [#205](https://github.com/nlog/nlog.web/pull/205) Register NLogProvider instead of NLogFactory (@304NotModified)
- [#204](https://github.com/nlog/nlog.web/pull/204) Improve ASP.NET core 2 example - add callsite (@304NotModified)
- [#202](https://github.com/nlog/nlog.web/pull/202) Fix ${callsite} in Asp.net core 2 (@304NotModified)

### Version 4.5.1-aspnet4 (2017/10/12)
- [#198](https://github.com/nlog/nlog.web/pull/198) Refactor code (@304NotModified)

### Version 4.5.0-aspnetcore-beta01 (2017/10/12)
- [#197](https://github.com/nlog/nlog.web/pull/197) versions and changelog, updated dependencies: NLog.Web 4.5.1 and NLog.Web.AspNetCore 4.5.0-beta01 (@304NotModified)
- [#195](https://github.com/nlog/nlog.web/pull/195) add ConfigureNLog on ILoggingBuilder (@304NotModified)
- [#191](https://github.com/nlog/nlog.web/pull/191) Added  NLogBuilder and  ASP.NET Core 2 example (@304NotModified)
- [#190](https://github.com/nlog/nlog.web/pull/190) Fix error reporting, fix introduced bug (@304NotModified)
- [#188](https://github.com/nlog/nlog.web/pull/188) Auto register NLog.Web.AspNetCore (ASP.NET 2 only) (@304NotModified)
- [#186](https://github.com/nlog/nlog.web/pull/186) Register HttpContextAccessor by default (@304NotModified)
- [#181](https://github.com/nlog/nlog.web/pull/181) Add UseNLog for ASP.NET Core 2 (@304NotModified)
- [#182](https://github.com/nlog/nlog.web/pull/182) Codecov tweaks (@304NotModified)
- [#180](https://github.com/nlog/nlog.web/pull/180) Fix IHttpContextAccessor warning (@304NotModified)
- [#178](https://github.com/nlog/nlog.web/pull/178) ASP.NET Core 2 support (@304NotModified)
- [#179](https://github.com/nlog/nlog.web/pull/179) rename NETSTANDARD_1plus => ASP_NET_CORE (@304NotModified)
- [#156](https://github.com/nlog/nlog.web/pull/156) Remove unneeded path in build script (@304NotModified)
- [#164](https://github.com/nlog/nlog.web/pull/164) Add IncludeScheme option to ${aspnet-request-url} (@BlaikiC)
- [#162](https://github.com/nlog/nlog.web/pull/162) Update AssemblyVersionLayoutRenderer docs for .NET core (@Valeriy1991)
- [#155](https://github.com/nlog/nlog.web/pull/155) fix xUnit warnings (@304NotModified)
- [#154](https://github.com/nlog/nlog.web/pull/154) deploy to Nuget from AppVeyor (@304NotModified)

### Version 4.4.1-aspnetcore (2017/06/16)
- [#152](https://github.com/nlog/nlog.web/pull/152) Run test for asp.net core on full and core framework, fix unit test build (@johnkors)
- [#150](https://github.com/nlog/nlog.web/pull/150) Update vulnerable dependency (@johnkors)

### Version 4.5.0-aspnet4 (2017/05/14)

#### Features

- [#66](https://github.com/nlog/nlog.web/pull/66) ${Assembly-version} working for asp.net (core) (@304NotModified)
- [#140](https://github.com/nlog/nlog.web/pull/140) Added ${aspnet-request-ip} (@304NotModified)
- [#143](https://github.com/nlog/nlog.web/pull/143) added ${aspnet-user-isAuthenticated} (@304NotModified)
- [#125](https://github.com/nlog/nlog.web/pull/125) Added ${aspnet-environment} (@grokky1)
- [#123](https://github.com/nlog/nlog.web/pull/123) Added Culture option to ${aspnet-item} and {aspnet-session} (@sbebrys)

#### Improvements

- [#141](https://github.com/nlog/nlog.web/pull/141) Improve performance with many threads 2 (@304NotModified)
- [#133](https://github.com/nlog/nlog.web/pull/133) Improve performance with many threads (@304NotModified)

#### Fixes

- [#132](https://github.com/nlog/nlog.web/pull/132) Fix invalid JSON format for ${aspnet-request-cookie} and ${aspnet-request-querystring}, added extra formatting options, consistent rendering of multiple values (@304NotModified)


### Version 4.4.0-aspnetcore (2017/05/14)

#### Features

- [#66](https://github.com/nlog/nlog.web/pull/66) ${Assembly-version} working for asp.net (core) (@304NotModified)
- [#140](https://github.com/nlog/nlog.web/pull/140) Added ${aspnet-request-ip} (@304NotModified)
- [#143](https://github.com/nlog/nlog.web/pull/143) added ${aspnet-user-isAuthenticated} (@304NotModified)
- [#126](https://github.com/nlog/nlog.web/pull/126) Add ${aspnet-request-contenttype} (ASP.NET Core only) (@304NotModified)
- [#125](https://github.com/nlog/nlog.web/pull/125) Added ${aspnet-environment} (@grokky1)
- [#123](https://github.com/nlog/nlog.web/pull/123) Added Culture option to ${aspnet-item} and {aspnet-session} (@sbebrys)

#### Improvements

- [#144](https://github.com/nlog/nlog.web/pull/144) Limit dependecies (@304NotModified)
- [#142](https://github.com/nlog/nlog.web/pull/142) ignore ObjectDisposedException in aspnet-user renderers (@304NotModified)
- [#141](https://github.com/nlog/nlog.web/pull/141) Improve performance with many threads 2 (@304NotModified)
- [#133](https://github.com/nlog/nlog.web/pull/133) Improve performance with many threads (@304NotModified)

#### Fixes

- [#132](https://github.com/nlog/nlog.web/pull/132) Fix invalid JSON format for ${aspnet-request-cookie} and ${aspnet-request-querystring}, added extra formatting options, consistent rendering of multiple values (@304NotModified)
- [#125](https://github.com/nlog/nlog.web/pull/125) fix ${iis-site-name} for ASP.NET Core (@grokky1)

### Version 4.3.2-aspnetcore (2017/02/17)
- [#112](https://github.com/nlog/nlog.web/pull/112) NLog.Web.AspNetCore 4.3.2 (@304NotModified)

### Version 4.4.0-aspnet4 (2017/02/17)
- [#110](https://github.com/nlog/nlog.web/pull/110) Enabled strong naming with correct version (@304NotModified)
- [#111](https://github.com/nlog/nlog.web/pull/111) Update nlog version (@304NotModified)
- [#106](https://github.com/nlog/nlog.web/pull/106) Update assemblyinfo & strong name version to 4.0.0.0 (@304NotModified)
- [#108](https://github.com/nlog/nlog.web/pull/108) Added mvc tag (@304NotModified)

### Version 4.3.1 (2017/02/10)
- [#98](https://github.com/nlog/nlog.web/pull/98) support for empty 'QueryStringKeys' for ${all-querystrings{aspnet-request-querystring} (@304NotModified)
- [#100](https://github.com/nlog/nlog.web/pull/100) Fixing missing name for ${aspnet-request-cookie} (@304NotModified)
- [#99](https://github.com/nlog/nlog.web/pull/99) Add ${aspnet-traceidentifier} (ASP.NET Core only) (@304NotModified)
- [#97](https://github.com/nlog/nlog.web/pull/97) Update dependencies and version number (@304NotModified)
- [#95](https://github.com/nlog/nlog.web/pull/95) Adding a link to some ASP.NET Core examples (@damienbod)
- [#91](https://github.com/nlog/nlog.web/pull/91) Update AssemblyInfo (@304NotModified)

### Version 4.3.0-aspnetcore (2017/01/18)
- [#89](https://github.com/nlog/nlog.web/pull/89) Update NLog.Extensions.Logging dependecy (@304NotModified)
- [#80](https://github.com/nlog/nlog.web/pull/80) Update README.md for 4.3 (@304NotModified)
- [#88](https://github.com/nlog/nlog.web/pull/88) Move ASP.NET helpers from nlog.extensions.logging, (@304NotModified)
- [#87](https://github.com/nlog/nlog.web/pull/87) Renames #2, allow aspnet-request-host in non-core ASP.NET (@304NotModified)
- [#86](https://github.com/nlog/nlog.web/pull/86) renames for consistency (@304NotModified)
- [#78](https://github.com/nlog/nlog.web/pull/78) added null checks (@304NotModified)
- [#77](https://github.com/nlog/nlog.web/pull/77) Upgrade to NLog 4.4 (@304NotModified)
- [#68](https://github.com/nlog/nlog.web/pull/68) Readme - make core vs non-core clearer (@timabell)
- [#54](https://github.com/nlog/nlog.web/pull/54) Additional aspnet renderers & unit tests for .net core (@304NotModified, @Page-Not-Found)
- [#61](https://github.com/nlog/nlog.web/pull/61) Upgrade RC2 to RTM. .Net Core. (@Page-Not-Found)
- [#59](https://github.com/nlog/nlog.web/pull/59) Upgrade to ASP.NET Core RC2 (@304NotModified)

### Version 4.2.1-aspnet4 (2016/05/12)
- [#57](https://github.com/nlog/nlog.web/pull/57) Package both nupkg + build scripts (@304NotModified)
- [#56](https://github.com/nlog/nlog.web/pull/56) Suppressing exception thrown when accessing HttpContext.Request (@vegar)

### 4.2.2 (2016/04/15)
- [#48](https://github.com/nlog/nlog.web/pull/48) Update LICENSE (@304NotModified)
- [#41](https://github.com/nlog/nlog.web/pull/41) DNX: Prevent stackoverflowException in ${aspnet-session} (@304NotModified)
- [#52](https://github.com/nlog/nlog.web/pull/52) Extra null check (@304NotModified)
- [#50](https://github.com/nlog/nlog.web/pull/50) Add dotnet5.4 framework (@304NotModified)
- [#37](https://github.com/nlog/nlog.web/pull/37) fix syntax of readme.md (@petemounce)

### Version 4.2.1 (2016/02/16)
- [#36](https://github.com/nlog/nlog.web/pull/36) Update README for aspnet5 (@304NotModified)
- [#35](https://github.com/nlog/nlog.web/pull/35) Fix aspnet5 (@304NotModified)
- [#33](https://github.com/nlog/nlog.web/pull/33) Less dependencies (@304NotModified)
- [#30](https://github.com/nlog/nlog.web/pull/30) Added ASP.NET 5 compatible package (@304NotModified)

### Version 4.2.0 (2016/02/07)
- [#27](https://github.com/nlog/nlog.web/pull/27) Add ability to render Headers (@petemounce)
- [#22](https://github.com/nlog/nlog.web/pull/22) Introducing ASP.NET Layout Renderer base class (@epignosisx)
- [#25](https://github.com/nlog/nlog.web/pull/25) Add info about configuration of NLog.Web in web.config to README.md (@muromek)

### Version 4.1.0 (2015/11/24)
- [#18](https://github.com/nlog/nlog.web/pull/18) Added Codecov (@304NotModified)
- [#17](https://github.com/nlog/nlog.web/pull/17) MsTest  => xUnit2 (@304NotModified)
- [#16](https://github.com/nlog/nlog.web/pull/16) Added Culture tests and use current culture (can be set) (@304NotModified)
- [#15](https://github.com/nlog/nlog.web/pull/15) Aspnet-item renderer (@304NotModified, @dafanasiev)

### Version 4.0.0 (2015/10/22)
- [#13](https://github.com/nlog/nlog.web/pull/13) Improved config for release (@304NotModified)
- [#7](https://github.com/nlog/nlog.web/pull/7) Enable Strong name signing (@304NotModified)
- [#8](https://github.com/nlog/nlog.web/pull/8) added unit tests project + tests for session (@304NotModified)

### 2.0.0 (2015/06/11)
- [#3](https://github.com/nlog/nlog.web/pull/3) Added support for logging nested properties of session items. (@Giorgi)
- [#2](https://github.com/nlog/nlog.web/pull/2) Move stuff from extended (@kichristensen)
- [#1](https://github.com/nlog/nlog.web/pull/1) Add IIS web site name layout renderer (@kichristensen)
