# Form 组件
封装后的 Form 组件，提供校验和检测是否填写完成等功能，分为一下几个组件：

  1. Form 
  1. Input
  1. Select
  1. CheckBox
  
## Form 组件
Form 在 willMount 时会收集所有 class name 符合 /^_Field/ 的 child 组件，为它们注入 `handleFieldChange` 方法。同时根据这些收集的组件来做一个 `state` 的初始化。`Form` 的 state 结构如下：
```
{
  'isValidate': 'boole',  // 决定是否能提交
  'errorMsgList': '',         // 存放提交时所有的错误信息
  'isComplete': 'boole',   // 是否所有必填项填写完毕
  'data': {
    'name': {             // 每条表单的属性
      'value': 'value',   // 表单的值        
      'validate': /[a-z]/,  // 校验方法
      'isError': 'boole', // 是否通过校验
      'errorMsg': '',         // 错误信息
      'shouldRsa': 'boole',   // 是否需要加密（未完成）
      'required': 'boole'     // 是否为必填项
    },
    'name1': {
      'value': 'value',
      'validate': function (value) {
        return true
      },
      'isValidate': 'boole',
      'errorMsg': '',
      'shouldRsa': 'boole',
      'required': 'boole'
    }
  }
}
```

## Props

### Form
属性名 | 描述 | 类型 | 默认值
--- | --- | --- | ---
onFieldChange(fieldData) | 子表单修改时的方法 | Function | 无
onChange(state) | 表单发生变化时的方法 | Function | 无
onSubmit(isValidate, state, pureData) | 提交方法 | Function | 无

### `onFieldChange(fieldData:object)`
被 Form 收集的自表单修改时调用的方法，`fieldData` 的具体值由变动的子表单决定，一般至少会包含 `name` 和 `value` 字段。

### `onChange(state:object)`
Form 发生任何更新时会调用的方法，`state` 为整个 Form 的 `state`. 
任何更新指的是所有的变化，无论是 Form 下面 child 的变化，还是子表单更新或者其他的变化。

### `onSubmit(isValidate:bool, state:object, pureData:object)`
Form 提交的时候触发的方法。

参数名|描述|类型|默认值
---|---|---|---
isValidate| 表单是否通过校验| bool | false
state | 整个 State 对象 | object | {}
pureData | 处理过后的 name:value 格式的数据，以供提交到后端使用 | object | {}

有两个途径来触发 Form 的提交方法：

1. 【推荐】跟原生 html 一样，在 Form 内部放一个 type='submit' 的 button, 点击后触发 `onSubmit` 方法
1. 给 Form 组件设置一个 ref 来拿到 Form 组件的实例，然后可以手动调用 `this.[ref].formSubmit` 来触发 `onSubmit` 方法

## 子表单
任何 class 的名字符合 /^_Field/ 的组件都可以被 Form 收集并注入 `handleFieldChange` 方法，只要子组件在合适的时机调用这个方法并传入合适的参数,就可以被 Form 组件所管理。

属性名 | 描述 | 类型 
--- | --- | --- 
handleFieldChange(fieldData:object) | Form组件注入的函数，传入的参数必须有 `name` 和 `value` 字段 | Function 

这里我预先实现了三个常用的组件：
* Input
* Select
* CheckBox

### 公用的 Props
上面三个组件基本 Props 都是相同的。

属性名 | 描述 | 类型 | 默认值
--- | --- | --- | ---
name | Name，必填项 | String | 无
value | 值，如果需要外部控制的话，可以传入，也可以不传 | any | 无
onChange | 变动时调用的方法 | Function | ()=>{}
disabled | 是否被禁用 | Bool | false
shouldRsa(未完成) | 是否需要 Rsa 加密 | Bool | false
required | 是否为必填项 | Bool | true

## Input

属性名 | 描述 | 类型 | 默认值
--- | --- | --- | ---
type | Input 类型 | String | 无
onChange(e) | 输入时调用的方法，参数为传统的 Event 对象 | Function | ()=>{}
onFocus(e) | Focus 时调用的方法，参数为传统的 Event 对象 | Function | ()=>{}
onBlur(e) | Focus 时调用的方法，参数为传统的 Event 对象 | Function | ()=>{}
validate | 校验函数，输入时调用的方法，来决定当前填写是否正确 | Function || RegExp | ()=> true
errorMsg | 校验错误时的报错信息 | String | 表单填写错误
isError | 当前填写的内容是否错误 | Bool | false
formatter | 用来格式化显示输出的函数 | func | data=> data
parser | 用来解析格式化显示输出的数据 | func | data=> data

## Select
属性名 | 描述 | 类型 | 默认值
--- | --- | --- | ---
data | 用来渲染子选项的数据，格式为 `[{name:'name',value:'value',disabled:false}]` | Array | []
value | 值，传入的话，会选中和 data 中 value 相同的选项 | any | 无
onChange(e) | 选项变化时调用的方法，参数为传统的 Event 对象 | Function | ()=>{}

## CheckBox

属性名 | 描述 | 类型 | 默认值
--- | --- | --- | ---
value | 值，标识是否选中 |Bool | 无
onChange(e) | 选项变化时调用的方法，参数为传统的 Event 对象 | Function | ()=>{}
