/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2022 abel533@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package com.github.pagehelper.test.basic;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.mapper.UserMapper;
import com.github.pagehelper.model.User;
import com.github.pagehelper.util.MybatisHelper;
import org.apache.ibatis.session.SqlSession;
import org.junit.Test;

import java.util.List;

import static org.junit.Assert.assertEquals;

public class OffsetTest {
    @Test
    public void testOffset() {
        SqlSession sqlSession = MybatisHelper.getSqlSession();
        UserMapper userMapper = sqlSession.getMapper(UserMapper.class);
        try {
            PageHelper.startPage(1, 6);
            List<User> list = userMapper.selectAll();
            assertEquals(6, list.size());
            assertEquals(183, ((Page<?>) list).getTotal());

            PageHelper.offsetPage(6, 20);
            list = userMapper.selectAll();
            PageInfo<User> pageInfo = new PageInfo<User>(list);
            System.out.println(pageInfo.toString());
            assertEquals(2, ((Page<?>) list).getPageNum());
            assertEquals(20, list.size());
            assertEquals(183, ((Page<?>) list).getTotal());

            PageHelper.offsetPage(1, 180);
            list = userMapper.selectAll();
            pageInfo = new PageInfo<User>(list);
            System.out.println(pageInfo.toString());
            assertEquals(2, ((Page<?>) list).getPageNum());
            assertEquals(180, list.size());
            assertEquals(183, ((Page<?>) list).getTotal());

            PageHelper.offsetPage(0, Integer.MAX_VALUE);
            list = userMapper.selectAll();
            pageInfo = new PageInfo<User>(list);
            System.out.println(pageInfo.toString());
            assertEquals(1, ((Page<?>) list).getPageNum());
            assertEquals(183, list.size());
            assertEquals(183, ((Page<?>) list).getTotal());
        } finally {
            sqlSession.close();
        }
    }

    @Test
    public void testPageNum() {
        SqlSession sqlSession = MybatisHelper.getSqlSession();
        UserMapper userMapper = sqlSession.getMapper(UserMapper.class);
        try {
            PageHelper.offsetPage(5, 5);
            List<User> list = userMapper.selectAll();
            assertEquals(2, ((Page<?>) list).getPageNum());
            assertEquals(5, list.size());
            assertEquals(183, ((Page<?>) list).getTotal());

            PageHelper.offsetPage(15, 5);
            list = userMapper.selectAll();
            assertEquals(4, ((Page<?>) list).getPageNum());
            assertEquals(5, list.size());
            assertEquals(183, ((Page<?>) list).getTotal());
        } finally {
            sqlSession.close();
        }
    }
}
