# Overview
[Covid 19](https://covid-19-website.herokuapp.com/) is a website to keep track of live COVID-19 data using APIs for both India and the World.

You can visit our site using this [link](https://covid-19-website.herokuapp.com/)

### Covid 19 website give daily update
 - *Country wise*
 - *Indian state wise*
 - *India's day to day*
 
 ### API used for
 - [India](https://api.covid19india.org/data.json)
 - [World](https://api.covid19api.com/summary)

### HTML, CSS, BOOTSTRAP, JAVASCRIPT is used for frontend program
### NodeJS is used for backend program
### It is hosted free on Heroku.
_ _ _

## Requirements

- [Node.js](https://nodejs.org/) v12 or higher.
- [VS Code](https://code.visualstudio.com/) editor with [recommended extensions](.vscode/extensions.json)

## Getting Started

Just clone the repo and run `npm install` followed by `node app.js`:

```bash
$ git clone --origin=upstream --branch=main --single-branch \
    https://github.com/Mustafiz04/Covid-19-website/ covid19
$ cd ./covid19                  # Change current directory to the newly created one
$ npm install                   # install the all the necessary module
$ node app.js                   # Launch Node.js API and web application
```

<br>

## How to Contribute in this repo.

Contributing to open-source is easy.

1. ### Star and Fork the Repo

   Give a star ⭐ and Click on **fork** button in the right corner.It will create a copy of repositiry in your account.

    - Check here [How to fork](https://docs.github.com/en/github/getting-started-with-github/fork-a-repo)

2. ### Clone the Repo

   You can **clone** your repository in your local pc with use of **[Github_Desktop](https://desktop.github.com/)** application or for your [Terminal/bash](https://git-scm.com/downloads).

   For **Terminal** -

   ```bash
   git clone <url_name>
   ```

   - [Cloning the Repository](https://docs.github.com/en/github/creating-cloning-and-archiving-repositories/cloning-a-repository)
   
3. ### Create a new **branch**

   ```bash
   git checkout -b <branch_name>
   ```
   - [Creating a branch](https://git-scm.com/book/en/v2/Git-Branching-Basic-Branching-and-Merging)
    
4. ### Upload your Code or Change

    Make what change you want to make in Repo. It can be spelling mistake, code correction or anything.

    You can also upload your program to respective folder. It can be anything "Hello world program", "Rock Paper Scissors",etc.

    `All Repository are open for contributions.`

5. ### Push it and Make a PR

    Push it to your repository and Issue a PR(Pull Request) in main repository.

    - [Push your first code](https://docs.github.com/en/github/importing-your-projects-to-github/adding-an-existing-project-to-github-using-the-command-line)

And, that's it!

[Click here for detailed explanation](CONTRIBUTING.md)

_ _ _

## How to Update

In the case when you kept the original Node.js Starter Kit git history, you can
always pull and merge updates from the "upstream" repository back into your
project by running:

```bash
$ git fetch upstream            # Fetch Node.js Starter Kit (upstream) repository
$ git checkout main             # Switch to the main branch (or, master branch)
$ git merge upstream/main       # Merge upstream/master into the local branch
```
**Or**
```bash
$ git checkout main             # Switch to the main branch (or, master branch)
$ git pull origin main          # Fetch and Merge upstream/master into the local branch
```


<br>


# HacktoberFest-2020

Open source is changing the world - one pull request at a time. 


- [HacktoberFest-2020](#hacktoberfest-2020)
  - [What is Hacktoberfest?](#what-is-hacktoberfest)
  - [Why Should I Contribute?](#-why-should-i-contribute)
  - [What Can I Contribute?](#what-can-i-contribute)
  - [How to Contribute in this repo.](#how-to-contribute-in-this-repo)

## What is Hacktoberfest?

Hacktoberfest is a month long virtual festival event to celebrate open source contributions presented by Digital Ocean and DEV. It is the easiest way to get into open source!

During the entire month of October 2020, all you have to do is contribute to any open source projects and open at least 4 pull requests. Yes, any project and any kind of contributions.

## Why Should I Contribute?

The Hacktoberfest’s simple plain objective is:
Support open source and earn a limited edition T-shirt!
But, it’s not just about the t-shirts or stickers. Its about supporting open source. Its about celebrating open source, and giving it back. If you’ve never contributed to open source before, this is the perfect time to get started because Hacktoberfest provides a large list of available contribution opportunities.

## What Can I Contribute?

Hacktoberfest® is open to everyone in our global community. Whether you’re a developer, student learning to code. You can contribute to anything from code to simple fix, new feature to grammar mistake.

## What if my pull requests aren’t accepted?

Even if your pull requests aren’t accepted, they should still count toward your 4 pull requests necessary to earn the shirt. The only exception would be if the project maintainer chooses to mark your pull request as “invalid”. They may do this if they perceive your pull request to be low effort, or if it contains plagiarism.

## What kinds of pull requests count toward earning the Hacktoberfest shirt?
Any pull request made to a public repo on GitHub will count. The pull request must contain commits you personally made yourself — not automated commits from bots.

You can contribute to any open source project hosted on Github.com and contribute anything between October 1 to October 31 midnight in 2020. You will find plenty of issues labeled with hacktoberfest or good-first-issue etc on Github. These will be the simple ones most probably and easy to fix.


---
## References

- [Hacktoberfest presented by DigitalOcean](https://hacktoberfest.digitalocean.com/)
- [A participation guide for Hacktoberfest](https://dev.to/zenika/a-participation-guide-for-hacktoberfest-19c1)
- [What is Hacktoberfest and How can a beginner contribute?](https://medium.com/@bawantharathnayaka/what-is-hacktoberfest-and-how-can-a-beginner-contribute-39cf2081804e)
- [Hacktoberfest 2019: How you can get your free shirt — even if you’re new to coding](https://www.freecodecamp.org/news/hacktoberfest-2018-how-you-can-get-your-free-shirt-even-if-youre-new-to-coding-96080dd0b01b/)
