# Contributing Guidelines

First off, thanks for taking the time to contribute! 😄

Contributions are handled in the form of Pull Requests.
* You fork this repository
* create a new branch
* make relevant changes
* and submit a Pull Request

once that's done we'll be able to review your PRs and merge them to the master branch.

Always submit a PR against a "Claimed Issue" that's been assigned to you. If an issue doesn't exist, please raise one first and wait for it to be labelled as "Available", and then have it assigned to you. PRs without having accepted issues mentioned will be closed.

## Process Flow

- When a new issue is created, "Status: Review Needed" and "Type: Bug or Type: Enhancement" label is automatically added to it.
- Mods periodically check "Status: Review Needed" and add appropriate Priority and Status labels. If the issue is clear, set the status label as "Status: Available".

<p align="center">
  <img src="https://storage.googleapis.com/jrmyphlmn/images/github/label%20change.png" width="50%">
</p>

- People looking to contribute, filter issues by ["Status:Available"](https://github.com/covid19india/covid19india-react/issues?q=is%3Aissue+is%3Aopen+label%3A%22Status%3A+Available%22) and comment "/claim" on the issue they would like to be assigned to work on.

<p align="center">
<img src="https://storage.googleapis.com/jrmyphlmn/images/github/filter.png" width="50%">
</p>
<h6 align="center">Filter by label "Available"</h6>
<p align="center">
<img src="https://storage.googleapis.com/jrmyphlmn/images/github/claim.png" width="50%">
</p>
<h6 align="center">use /claim to have the issue assigned to you</h6>

- Finally submit the pull request.

## Formatting

Format your PR titles likewise:

> [Tag]: Describe change in present tense

Tag can be:

- Feat (new feature)
- Fix (bug fix)
- Refactor (refactoring code)
- Style (formatting, no code change)
- Doc (changes to documentation)
- Test (adding or refactoring tests; no production code change)

Remember to:

- Capitalize the subject line
- Use the imperative mood in the subject line
