Clear-Host
Import-Module PS-Menu
$line = "---------------------------------------------------------------------------------------------------"
Write-Host @"
$line
 __    __     __  __     _____     ______     __         ______     ______     ______     ______    
/\ "-./  \   /\ \/\ \   /\  __-.  /\  == \   /\ \       /\  __ \   /\___  \   /\  __ \   /\  == \   
\ \ \-./\ \  \ \ \_\ \  \ \ \/\ \ \ \  __<   \ \ \____  \ \  __ \  \/_/  /__  \ \ \/\ \  \ \  __<   
 \ \_\ \ \_\  \ \_____\  \ \____-  \ \_____\  \ \_____\  \ \_\ \_\   /\_____\  \ \_____\  \ \_\ \_\ 
  \/_/  \/_/   \/_____/   \/____/   \/_____/   \/_____/   \/_/\/_/   \/_____/   \/_____/   \/_/ /_/ 
$line
"@ -ForegroundColor "blue"                                                                                                    

$dir = Split-Path -Parent $PSCommandPath
$dir_utilities = $dir.Replace("tools\CssUtilitiesGenerator", "src\MudBlazor\Styles\utilities")
$dir_docs_utilities = $dir.Replace("tools\CssUtilitiesGenerator", "src\MudBlazor.Docs\Pages\CSS Utilities\AutoGenerated")
$dir_generated_css = "$dir\css\"
$dir_generated_output = "$dir\output\"

$utility_categorys = @()

$outputToDocs = $False

function GenerateUtilities
{
    Get-ChildItem -Path $dir_utilities -Directory | ForEach-Object { $utility_categorys += $_.Name }

    if(Test-Path -Path $dir_generated_css -IsValid)
    {
        Remove-Item -Path "$dir_generated_css\*.*" -Recurse

    }

    if(Test-Path -Path $dir_generated_output -IsValid)
    {
        Remove-Item -Path "$dir_generated_output\*.*" -Recurse
    }

    Write-Host "Root" -ForegroundColor "blue"

    foreach($category in $utility_categorys) {
        Write-Host "|-- $category" -ForegroundColor "blue"

        $path = $dir_utilities + "\" + $category 
        
        $utilities = @()
        Get-ChildItem -Path $path | ForEach-Object { $utilities += $_.Name.Replace("_","").Replace(".scss","");}

        foreach($utility in $utilities)
        {
            Write-Host "|   |-- $utility" -ForegroundColor "blue" -NoNewline
            $generated_file = "$dir_generated_css\$category\$utility.css"
            $generated_razor = "$dir_generated_output\$category\$utility.razor"

            sass "$path\_$utility.scss" $generated_file --no-source-map 

            ((Get-Content -Path $generated_file -Raw) -Replace "@media[^{]+\{([\s\S]+?})\s*}","") | Set-Content -Path $generated_file

            $razorOutput = "<DocsClassTable>"

            $classDictonary = @{}
            $currentSelection = New-Object System.Collections.Generic.List[string]

            foreach($class in Get-Content -Path $generated_file){
                if($class.Length -gt 1)
                {
                    $className = $class
                    if($className.StartsWith(".") -and $className.EndsWith(","))
                    {
                        $currentSelection.Add($className.Replace(".","").Replace(",",""));
                    }
                    elseif($className.StartsWith(".") -and $className.EndsWith(" {"))
                    {
                        $currentSelection.Add($className.Replace(".","").Replace("{",""));

                    }
                    else{
                        foreach ($header in $currentSelection){
                            if (!$classDictonary.ContainsKey($header)){
                                $classDictonary[$header] = New-Object System.Collections.Generic.List[string]
                            }
                    
                            $classDictonary[$header].Add($className.Replace(" !important;",";")); 
                        }
                    }
                }
                if($class.StartsWith("}")){
                    $currentSelection = New-Object System.Collections.Generic.List[string]
                }
            }

            foreach($class in $classDictonary.GetEnumerator() | Where-Object {!$_.Name.StartsWith("mud-") } | Sort-Object -Property Name){
                $razorOutput += "<tr><td>$($class.Name)</td><td>"
                $propCount = 1
                foreach ($property in $class.Value){

                    if($propCount -eq 2)
                    {
                        $razorOutput += "<br/>"
                        $propCount = 1
                    }
                    $razorOutput += $property
                    $propCount += 1
                }
                $razorOutput += "</td></tr>"
            }
            $razorOutput += "</DocsClassTable>"

            
            if($outputToDocs)
            {
                $title = (Get-Culture).TextInfo.ToTitleCase($utility)
                $title = $title.Replace("-","")
                $categoryTitle = (Get-Culture).TextInfo.ToTitleCase($category)
                $fileName = "DocsAutoGen" + "_" + $categoryTitle + "_" + $title + ".razor"
                $razorOutput | Out-File "$dir_docs_utilities\$fileName"
            }
            else
            {
                if((Test-Path -Path "$dir_generated_output\$category") -eq $False)
                {
                    $newdit = New-Item -Path $dir_generated_output  -Name $category -ItemType "directory"
                }
    
                $razorOutput | Out-File $generated_razor
            }

           
            $check = ([char]8730)
            Write-Host " $check" -ForegroundColor "green"

        }
    }
    Write-Host "Done" -ForegroundColor "green"
    $line
}



function InputMenu
{
    Write-Host " Choice where you want to save the generated output" -ForegroundColor "blue"
    Write-Host $Line -ForegroundColor "blue"
    $userInput = menu @("Tools", "Docs", "Exit")
    Write-Host $Line -ForegroundColor "blue"
    if($userInput -eq "Tools")
    {
        $outputToDocs = $False
        GenerateUtilities
    }
    elseif($userInput -eq "Docs"){
        $outputToDocs = $True
        GenerateUtilities
    }
    elseif($userInput -eq "Exit"){
        Exit
    }
}

InputMenu