﻿// Copyright (c) MudBlazor 2021
// MudBlazor licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using MudBlazor.Utilities;

namespace MudBlazor
{
#nullable enable
    /// <summary>
    /// Represents a dark color palette.
    /// </summary>
    public class PaletteDark : Palette
    {
        /// <inheritdoc />
        public override MudColor Black { get; set; } = "#27272f";

        /// <inheritdoc />
        public override MudColor Primary { get; set; } = "#776be7";

        /// <inheritdoc />
        public override MudColor Info { get; set; } = "#3299ff";

        /// <inheritdoc />
        public override MudColor Success { get; set; } = "#0bba83";

        /// <inheritdoc />
        public override MudColor Warning { get; set; } = "#ffa800";

        /// <inheritdoc />
        public override MudColor Error { get; set; } = "#f64e62";

        /// <inheritdoc />
        public override MudColor Dark { get; set; } = "#27272f";

        /// <inheritdoc />
        public override MudColor TextPrimary { get; set; } = "rgba(255,255,255, 0.70)";

        /// <inheritdoc />
        public override MudColor TextSecondary { get; set; } = "rgba(255,255,255, 0.50)";

        /// <inheritdoc />
        public override MudColor TextDisabled { get; set; } = "rgba(255,255,255, 0.2)";

        /// <inheritdoc />
        public override MudColor ActionDefault { get; set; } = "#adadb1";

        /// <inheritdoc />
        public override MudColor ActionDisabled { get; set; } = "rgba(255,255,255, 0.26)";

        /// <inheritdoc />
        public override MudColor ActionDisabledBackground { get; set; } = "rgba(255,255,255, 0.12)";

        /// <inheritdoc />
        public override MudColor Background { get; set; } = "#32333d";

        /// <inheritdoc />
        public override MudColor BackgroundGray { get; set; } = "#27272f";

        /// <inheritdoc />
        public override MudColor Surface { get; set; } = "#373740";

        /// <inheritdoc />
        public override MudColor DrawerBackground { get; set; } = "#27272f";

        /// <inheritdoc />
        public override MudColor DrawerText { get; set; } = "rgba(255,255,255, 0.50)";

        /// <inheritdoc />
        public override MudColor DrawerIcon { get; set; } = "rgba(255,255,255, 0.50)";

        /// <inheritdoc />
        public override MudColor AppbarBackground { get; set; } = "#27272f";

        /// <inheritdoc />
        public override MudColor AppbarText { get; set; } = "rgba(255,255,255, 0.70)";

        /// <inheritdoc />
        public override MudColor LinesDefault { get; set; } = "rgba(255,255,255, 0.12)";

        /// <inheritdoc />
        public override MudColor LinesInputs { get; set; } = "rgba(255,255,255, 0.3)";

        /// <inheritdoc />
        public override MudColor TableLines { get; set; } = "rgba(255,255,255, 0.12)";

        /// <inheritdoc />
        public override MudColor TableStriped { get; set; } = "rgba(255,255,255, 0.2)";

        /// <inheritdoc />
        public override MudColor Divider { get; set; } = "rgba(255,255,255, 0.12)";

        /// <inheritdoc />
        public override MudColor DividerLight { get; set; } = "rgba(255,255,255, 0.06)";

        /// <inheritdoc />
        public override MudColor Skeleton { get; set; } = "rgba(255,255,255, 0.11)";
    }
}
