﻿// Copyright (c) MudBlazor 2021
// MudBlazor licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace MudBlazor;

/// <summary>
/// Indicates a pagination behavior.
/// </summary>
public enum Page
{
    /// <summary>
    /// Navigate to the first page of results.
    /// </summary>
    First,

    /// <summary>
    /// Navigate to the previous page of results.
    /// </summary>
    Previous,

    /// <summary>
    /// Navigate to the next page of results.
    /// </summary>
    Next,

    /// <summary>
    /// Navigate to the last page of results.
    /// </summary>
    Last
}
