﻿using System.Diagnostics.CodeAnalysis;

namespace MudBlazor
{
    [ExcludeFromCodeCoverage]
    public static class Colors
    {
        public static partial class Red
        {
            public static string Default { get; } = "#F44336";
            public static string Lighten5 { get; } = "#FFEBEE";
            public static string Lighten4 { get; } = "#FFCDD2";
            public static string Lighten3 { get; } = "#EF9A9A";
            public static string Lighten2 { get; } = "#E57373";
            public static string Lighten1 { get; } = "#EF5350";
            public static string Darken1 { get; } = "#E53935";
            public static string Darken2 { get; } = "#D32F2F";
            public static string Darken3 { get; } = "#C62828";
            public static string Darken4 { get; } = "#B71C1C";
            public static string Accent1 { get; } = "#FF8A80";
            public static string Accent2 { get; } = "#FF5252";
            public static string Accent3 { get; } = "#FF1744";
            public static string Accent4 { get; } = "#D50000";
        }

        public static class Pink
        {
            public static string Default { get; } = "#E91E63";
            public static string Lighten5 { get; } = "#FCE4EC";
            public static string Lighten4 { get; } = "#F8BBD0";
            public static string Lighten3 { get; } = "#F48FB1";
            public static string Lighten2 { get; } = "#F06292";
            public static string Lighten1 { get; } = "#EC407A";
            public static string Darken1 { get; } = "#D81B60";
            public static string Darken2 { get; } = "#C2185B";
            public static string Darken3 { get; } = "#AD1457";
            public static string Darken4 { get; } = "#880E4F";
            public static string Accent1 { get; } = "#FF80AB";
            public static string Accent2 { get; } = "#FF4081";
            public static string Accent3 { get; } = "#F50057";
            public static string Accent4 { get; } = "#C51162";
        }

        public static class Purple
        {
            public static string Default { get; } = "#9C27B0";
            public static string Lighten5 { get; } = "#F3E5F5";
            public static string Lighten4 { get; } = "#E1BEE7";
            public static string Lighten3 { get; } = "#CE93D8";
            public static string Lighten2 { get; } = "#BA68C8";
            public static string Lighten1 { get; } = "#AB47BC";
            public static string Darken1 { get; } = "#8E24AA";
            public static string Darken2 { get; } = "#7B1FA2";
            public static string Darken3 { get; } = "#6A1B9A";
            public static string Darken4 { get; } = "#4A148C";
            public static string Accent1 { get; } = "#EA80FC";
            public static string Accent2 { get; } = "#E040FB";
            public static string Accent3 { get; } = "#D500F9";
            public static string Accent4 { get; } = "#AA00FF";
        }

        public static class DeepPurple
        {
            public static string Default { get; } = "#673AB7";
            public static string Lighten5 { get; } = "#EDE7F6";
            public static string Lighten4 { get; } = "#D1C4E9";
            public static string Lighten3 { get; } = "#B39DDB";
            public static string Lighten2 { get; } = "#9575CD";
            public static string Lighten1 { get; } = "#7E57C2";
            public static string Darken1 { get; } = "#5E35B1";
            public static string Darken2 { get; } = "#512DA8";
            public static string Darken3 { get; } = "#4527A0";
            public static string Darken4 { get; } = "#311B92";
            public static string Accent1 { get; } = "#B388FF";
            public static string Accent2 { get; } = "#7C4DFF";
            public static string Accent3 { get; } = "#651FFF";
            public static string Accent4 { get; } = "#6200EA";
        }

        public static class Indigo
        {
            public static string Default { get; } = "#3F51B5";
            public static string Lighten5 { get; } = "#E8EAF6";
            public static string Lighten4 { get; } = "#C5CAE9";
            public static string Lighten3 { get; } = "#9FA8DA";
            public static string Lighten2 { get; } = "#7986CB";
            public static string Lighten1 { get; } = "#5C6BC0";
            public static string Darken1 { get; } = "#3949AB";
            public static string Darken2 { get; } = "#303F9F";
            public static string Darken3 { get; } = "#283593";
            public static string Darken4 { get; } = "#1A237E";
            public static string Accent1 { get; } = "#8C9EFF";
            public static string Accent2 { get; } = "#536DFE";
            public static string Accent3 { get; } = "#3D5AFE";
            public static string Accent4 { get; } = "#304FFE";
        }

        public static class Blue
        {
            public static string Default { get; } = "#2196F3";
            public static string Lighten5 { get; } = "#E3F2FD";
            public static string Lighten4 { get; } = "#BBDEFB";
            public static string Lighten3 { get; } = "#90CAF9";
            public static string Lighten2 { get; } = "#64B5F6";
            public static string Lighten1 { get; } = "#42A5F5";
            public static string Darken1 { get; } = "#1E88E5";
            public static string Darken2 { get; } = "#1976D2";
            public static string Darken3 { get; } = "#1565C0";
            public static string Darken4 { get; } = "#0D47A1";
            public static string Accent1 { get; } = "#82B1FF";
            public static string Accent2 { get; } = "#448AFF";
            public static string Accent3 { get; } = "#2979FF";
            public static string Accent4 { get; } = "#2962FF";
        }

        public static class LightBlue
        {
            public static string Default { get; } = "#03A9F4";
            public static string Lighten5 { get; } = "#E1F5FE";
            public static string Lighten4 { get; } = "#B3E5FC";
            public static string Lighten3 { get; } = "#81D4FA";
            public static string Lighten2 { get; } = "#4FC3F7";
            public static string Lighten1 { get; } = "#29B6F6";
            public static string Darken1 { get; } = "#039BE5";
            public static string Darken2 { get; } = "#0288D1";
            public static string Darken3 { get; } = "#0277BD";
            public static string Darken4 { get; } = "#01579B";
            public static string Accent1 { get; } = "#80D8FF";
            public static string Accent2 { get; } = "#40C4FF";
            public static string Accent3 { get; } = "#00B0FF";
            public static string Accent4 { get; } = "#0091EA";
        }

        public static class Cyan
        {
            public static string Default { get; } = "#00BCD4";
            public static string Lighten5 { get; } = "#E0F7FA";
            public static string Lighten4 { get; } = "#B2EBF2";
            public static string Lighten3 { get; } = "#80DEEA";
            public static string Lighten2 { get; } = "#4DD0E1";
            public static string Lighten1 { get; } = "#26C6DA";
            public static string Darken1 { get; } = "#00ACC1";
            public static string Darken2 { get; } = "#0097A7";
            public static string Darken3 { get; } = "#00838F";
            public static string Darken4 { get; } = "#006064";
            public static string Accent1 { get; } = "#84FFFF";
            public static string Accent2 { get; } = "#18FFFF";
            public static string Accent3 { get; } = "#00E5FF";
            public static string Accent4 { get; } = "#00B8D4";
        }

        public static class Teal
        {
            public static string Default { get; } = "#009688";
            public static string Lighten5 { get; } = "#E0F2F1";
            public static string Lighten4 { get; } = "#B2DFDB";
            public static string Lighten3 { get; } = "#80CBC4";
            public static string Lighten2 { get; } = "#4DB6AC";
            public static string Lighten1 { get; } = "#26A69A";
            public static string Darken1 { get; } = "#00897B";
            public static string Darken2 { get; } = "#00796B";
            public static string Darken3 { get; } = "#00695C";
            public static string Darken4 { get; } = "#004D40";
            public static string Accent1 { get; } = "#A7FFEB";
            public static string Accent2 { get; } = "#64FFDA";
            public static string Accent3 { get; } = "#1DE9B6";
            public static string Accent4 { get; } = "#00BFA5";
        }

        public static class Green
        {
            public static string Default { get; } = "#4CAF50";
            public static string Lighten5 { get; } = "#E8F5E9";
            public static string Lighten4 { get; } = "#C8E6C9";
            public static string Lighten3 { get; } = "#A5D6A7";
            public static string Lighten2 { get; } = "#81C784";
            public static string Lighten1 { get; } = "#66BB6A";
            public static string Darken1 { get; } = "#43A047";
            public static string Darken2 { get; } = "#388E3C";
            public static string Darken3 { get; } = "#2E7D32";
            public static string Darken4 { get; } = "#1B5E20";
            public static string Accent1 { get; } = "#B9F6CA";
            public static string Accent2 { get; } = "#69F0AE";
            public static string Accent3 { get; } = "#00E676";
            public static string Accent4 { get; } = "#00C853";
        }

        public static class LightGreen
        {
            public static string Default { get; } = "#8BC34A";
            public static string Lighten5 { get; } = "#F1F8E9";
            public static string Lighten4 { get; } = "#DCEDC8";
            public static string Lighten3 { get; } = "#C5E1A5";
            public static string Lighten2 { get; } = "#AED581";
            public static string Lighten1 { get; } = "#9CCC65";
            public static string Darken1 { get; } = "#7CB342";
            public static string Darken2 { get; } = "#689F38";
            public static string Darken3 { get; } = "#558B2F";
            public static string Darken4 { get; } = "#33691E";
            public static string Accent1 { get; } = "#CCFF90";
            public static string Accent2 { get; } = "#B2FF59";
            public static string Accent3 { get; } = "#76FF03";
            public static string Accent4 { get; } = "#64DD17";
        }

        public static class Lime
        {
            public static string Default { get; } = "#CDDC39";
            public static string Lighten5 { get; } = "#F9FBE7";
            public static string Lighten4 { get; } = "#F0F4C3";
            public static string Lighten3 { get; } = "#E6EE9C";
            public static string Lighten2 { get; } = "#DCE775";
            public static string Lighten1 { get; } = "#D4E157";
            public static string Darken1 { get; } = "#C0CA33";
            public static string Darken2 { get; } = "#AFB42B";
            public static string Darken3 { get; } = "#9E9D24";
            public static string Darken4 { get; } = "#827717";
            public static string Accent1 { get; } = "#F4FF81";
            public static string Accent2 { get; } = "#EEFF41";
            public static string Accent3 { get; } = "#C6FF00";
            public static string Accent4 { get; } = "#AEEA00";
        }

        public static class Yellow
        {
            public static string Default { get; } = "#FFEB3B";
            public static string Lighten5 { get; } = "#FFFDE7";
            public static string Lighten4 { get; } = "#FFF9C4";
            public static string Lighten3 { get; } = "#FFF59D";
            public static string Lighten2 { get; } = "#FFF176";
            public static string Lighten1 { get; } = "#FFEE58";
            public static string Darken1 { get; } = "#FDD835";
            public static string Darken2 { get; } = "#FBC02D";
            public static string Darken3 { get; } = "#F9A825";
            public static string Darken4 { get; } = "#F57F17";
            public static string Accent1 { get; } = "#FFFF8D";
            public static string Accent2 { get; } = "#FFFF00";
            public static string Accent3 { get; } = "#FFEA00";
            public static string Accent4 { get; } = "#FFD600";
        }

        public static class Amber
        {
            public static string Default { get; } = "#FFC107";
            public static string Lighten5 { get; } = "#FFF8E1";
            public static string Lighten4 { get; } = "#FFECB3";
            public static string Lighten3 { get; } = "#FFE082";
            public static string Lighten2 { get; } = "#FFD54F";
            public static string Lighten1 { get; } = "#FFCA28";
            public static string Darken1 { get; } = "#FFB300";
            public static string Darken2 { get; } = "#FFA000";
            public static string Darken3 { get; } = "#FF8F00";
            public static string Darken4 { get; } = "#FF6F00";
            public static string Accent1 { get; } = "#FFE57F";
            public static string Accent2 { get; } = "#FFD740";
            public static string Accent3 { get; } = "#FFC400";
            public static string Accent4 { get; } = "#FFAB00";
        }

        public static class Orange
        {
            public static string Default { get; } = "#FF9800";
            public static string Lighten5 { get; } = "#FFF3E0";
            public static string Lighten4 { get; } = "#FFE0B2";
            public static string Lighten3 { get; } = "#FFCC80";
            public static string Lighten2 { get; } = "#FFB74D";
            public static string Lighten1 { get; } = "#FFA726";
            public static string Darken1 { get; } = "#FB8C00";
            public static string Darken2 { get; } = "#F57C00";
            public static string Darken3 { get; } = "#EF6C00";
            public static string Darken4 { get; } = "#E65100";
            public static string Accent1 { get; } = "#FFD180";
            public static string Accent2 { get; } = "#FFAB40";
            public static string Accent3 { get; } = "#FF9100";
            public static string Accent4 { get; } = "#FF6D00";
        }

        public static class DeepOrange
        {
            public static string Default { get; } = "#FF5722";
            public static string Lighten5 { get; } = "#FBE9E7";
            public static string Lighten4 { get; } = "#FFCCBC";
            public static string Lighten3 { get; } = "#FFAB91";
            public static string Lighten2 { get; } = "#FF8A65";
            public static string Lighten1 { get; } = "#FF7043";
            public static string Darken1 { get; } = "#F4511E";
            public static string Darken2 { get; } = "#E64A19";
            public static string Darken3 { get; } = "#D84315";
            public static string Darken4 { get; } = "#BF360C";
            public static string Accent1 { get; } = "#FF9E80";
            public static string Accent2 { get; } = "#FF6E40";
            public static string Accent3 { get; } = "#FF3D00";
            public static string Accent4 { get; } = "#DD2C00";
        }

        public static class Brown
        {
            public static string Default { get; } = "#795548";
            public static string Lighten5 { get; } = "#EFEBE9";
            public static string Lighten4 { get; } = "#D7CCC8";
            public static string Lighten3 { get; } = "#BCAAA4";
            public static string Lighten2 { get; } = "#A1887F";
            public static string Lighten1 { get; } = "#8D6E63";
            public static string Darken1 { get; } = "#6D4C41";
            public static string Darken2 { get; } = "#5D4037";
            public static string Darken3 { get; } = "#4E342E";
            public static string Darken4 { get; } = "#3E2723";
        }

        public static class BlueGray
        {
            public static string Default { get; } = "#607D8B";
            public static string Lighten5 { get; } = "#ECEFF1";
            public static string Lighten4 { get; } = "#CFD8DC";
            public static string Lighten3 { get; } = "#B0BEC5";
            public static string Lighten2 { get; } = "#90A4AE";
            public static string Lighten1 { get; } = "#78909C";
            public static string Darken1 { get; } = "#546E7A";
            public static string Darken2 { get; } = "#455A64";
            public static string Darken3 { get; } = "#37474F";
            public static string Darken4 { get; } = "#263238";
        }
        public static class Gray
        {
            public static string Default { get; } = "#9E9E9E";
            public static string Lighten5 { get; } = "#FAFAFA";
            public static string Lighten4 { get; } = "#F5F5F5";
            public static string Lighten3 { get; } = "#EEEEEE";
            public static string Lighten2 { get; } = "#E0E0E0";
            public static string Lighten1 { get; } = "#BDBDBD";
            public static string Darken1 { get; } = "#757575";
            public static string Darken2 { get; } = "#616161";
            public static string Darken3 { get; } = "#424242";
            public static string Darken4 { get; } = "#212121";
        }

        public static class Shades
        {
            public static string Black { get; } = "#000000";
            public static string White { get; } = "#FFFFFF";
            public static string Transparent { get; } = "transparent";
        }
    }
}
