# MudBlazor Roadmap

MudBlazor continues to thrive with over 11M downloads on [NuGet](https://www.nuget.org/packages/MudBlazor/) and thousands of members on [Discord](https://discord.gg/mudblazor).

With the release of v7, we've made significant progress in ensuring the library remains healthy and robust.
We've not only introduced numerous new features and bug fixes, but also built a more stable foundation for future development.
This groundwork positions us to continue moving the project forward to meet the needs of the community.

## Migration From An Older Version

The release of v7 addressed several long-standing needs for breaking changes and removed all obsolete APIs from v6.
This was a significant step forward and our primary goal for v8 is to build on that success while minimizing breaking changes to ensure a smoother transition for everyone.

Each major release is accompanied by a migration guide to help you adjust with as little disruption as possible.
For more details, please refer to the [v7.0.0 Migration Guide](https://github.com/MudBlazor/MudBlazor/issues/8447) and upcoming [v8.0.0 Migration Guide](https://github.com/MudBlazor/MudBlazor/issues/9953).
In addition we have a [built-in analyzer](https://mudblazor.com/features/analyzers) that identifies parameters that have been removed or renamed.

To align with Microsoft's .NET support policies, we've officially dropped support for .NET 6 and .NET 7.
Going forward, MudBlazor will focus on supporting .NET 8 and .NET 9.

For users who aren't ready to upgrade, we will continue to support v6.x and v7.x for a while longer with the help of community contributions.

## Looking Ahead

You can expect v8 to be production-ready by the end of the year and regular preview releases will allow the community to provide feedback and stay updated on our progress.

We are passionate about improving the library but can't make firm promises about release timelines or specific features as the MudBlazor team is made up of volunteers who contribute to the project in their personal time.

Our goal is to keep MudBlazor stable, performant, and evolving with thoughtful enhancements, but the pace of development depends on the availability of contributors.
We appreciate your support as we continue to work on keeping MudBlazor the premiere UI library for Blazor.

## Get Involved

MudBlazor thrives thanks to the contributions of our amazing community. Whether you specialize in C#, Blazor, JavaScript, CSS, documentation, testing, or design, your help is always welcome in improving this project.

If you’re interested in contributing, please check out [our contribution guidelines](https://github.com/MudBlazor/MudBlazor/blob/dev/CONTRIBUTING.md) to get started. You can also open an issue, start a discussion, or tag a member of the team in relevant GitHub issues to collaborate with us.
