<?php
/*
 * @copyright 2021 Daniel Engelschalk <hello@mrkampf.com>
 */

namespace Proxmox\Api\Cluster\Ha\Groups;

use Proxmox\Helper\PVEPathClassBase;
use Proxmox\PVE;
use Proxmox\API;

/**
 * Class Group
 * @package Proxmox\Api\Cluster\Ha\Groups
 */
class Group extends PVEPathClassBase
{
    /**
     * Group constructor.
     * @param PVE|API $pve
     * @param string $parentAdditional
     */
    public function __construct(PVE|API $pve, string $parentAdditional)
    {
        parent::__construct($pve, $parentAdditional);
    }

    /**
     * Read ha group configuration.
     * @link https://pve.proxmox.com/pve-docs/api-viewer/#/cluster/ha/groups/{group}
     * @return array|null
     */
    public function get(): ?array
    {
        return $this->getPve()->getApi()->get($this->getPathAdditional());
    }

    /**
     * Update ha group configuration.
     * @link https://pve.proxmox.com/pve-docs/api-viewer/#/cluster/ha/groups/{group}
     * @param $params array
     * @return array|null
     */
    public function put(array $params = []): ?array
    {
        return $this->getPve()->getApi()->put($this->getPathAdditional(), $params);
    }

    /**
     * Delete ha group configuration.
     * @link https://pve.proxmox.com/pve-docs/api-viewer/#/cluster/ha/groups/{group}
     * @return array|null
     */
    public function delete(): ?array
    {
        return $this->getPve()->getApi()->delete($this->getPathAdditional());
    }

}