import pickle
import tensorflow as tf
from p3detector.preprocess import Preprocess
import os


class PredictionModel:

    def __init__(self):
        file_selector = open(os.path.join(os.getcwd(), 'resources', 'p3detector_model', 'dictionary.pkl'), 'rb')
        file_vectorizer = open(os.path.join(os.getcwd(), 'resources', 'p3detector_model', 'vectorizer.pkl'), 'rb')
        self._selector = pickle.load(file_selector)
        self._vectorizer = pickle.load(file_vectorizer)
        self._model = tf.keras.models.load_model(
            os.path.join(os.getcwd(), 'resources', 'p3detector_model', 'policy_finder_mlp_model.h5'))

    # It is highly recommend to use the preprocess phase
    def preprocess_data(self, path):
        if path.endswith(".xml"):
            return Preprocess.preprocess_xml(path)
        else:
            return Preprocess.preprocess_page(path)

    # Call first preprocess_data
    def predict(self, data):
        assert type(data) == list, 'allowed type: list'
        data = self._vectorizer.transform(data)
        data = self._selector.transform(data).astype('float32')
        return self._model.predict(data)


if __name__ == '__main__':
    obj = PredictionModel()
    result = obj.predict([""""Page info www.pixelrush.org/money_privacy.html Page manager More options 1Money | Privacy Policy Privacy Policy of 1Money application Latest update: February 07, 2019 This Application collects some Personal Data from its Users. Policy summary Personal Data collected for the following purposes and using the following services: Access to third-party accounts Facebook account access Permissions: Email Analytics Google Analytics for Firebase Personal Data: Application opens, Application updates, Cookies, device information, first launches, geography/region, In-app purchases, number of sessions, number of Users , operating systems, session duration, unique device identifiers for advertising (Google Advertiser ID or IDFA, for example) and Usage Data Content performance and features testing (A/B testing) Firebase Remote Config Personal Data: various types of Data as specified in the privacy policy of the service Hosting and backend infrastructure Firebase Realtime Database Personal Data: Usage Data and various types of Data as specified in the privacy policy of the service Infrastructure monitoring Crashlytics Personal Data: various types of Data as specified in the privacy policy of the service Registration and authentication Firebase Authentication Personal Data: email address, profile picture, social media accounts and username Facebook Authentication Personal Data: various types of Data as specified in the privacy policy of the service Further information about Personal Data The Service is not directed to children under the age of 13 Users declare themselves to be adult according to their applicable legislation. Minors may use this Application only with the assistance of a parent or guardian. Under no circumstance persons under the age of 13 may use this Application. Contact information Owner and Data Controller PixelRush, Russia, 198260, Sankt-Peterburg, ul. Soldata Korzuna 5 244 Owner contact email: support@pixelrush.org Full policy Owner and Data Controller PixelRush, Russia, 198260, Sankt-Peterburg, ul. Soldata Korzuna 5 244 Owner contact email: support@pixelrush.org Types of Data collected Among the types of Personal Data that this Application collects, by itself or through third parties, there are: Email address, Username, Profile picture, Social media accounts, Application opens, Application updates, Cookies, device information, first launches, geography/region, In-app purchases, number of sessions, number of Users , operating systems, session duration, unique device identifiers for advertising (Google Advertiser ID or IDFA, for example) and Usage Data. Complete details on each type of Personal Data collected are provided in the dedicated sections of this privacy policy or by specific explanation texts displayed prior to the Data collection. Personal Data may be freely provided by the User, or, in case of Usage Data, collected automatically when using this Application. Unless specified otherwise, all Data requested by this Application is mandatory and failure to provide this Data may make it impossible for this Application to provide its services. In cases where this Application specifically states that some Data is not mandatory, Users are free not to communicate this Data without consequences to the availability or the functioning of the Service. Users who are uncertain about which Personal Data is mandatory are welcome to contact the Owner. Any use of Cookies – or of other tracking tools – by this Application or by the owners of third-party services used by this Application serves the purpose of providing the Service required by the User, in addition to any other purposes described in the present document and in the Cookie Policy, if available. Users are responsible for any third-party Personal Data obtained, published or shared through this Application and confirm that they have the third party's consent to provide the Data to the Owner. Mode and place of processing the Data Methods of processing The Owner takes appropriate security measures to prevent unauthorized access, disclosure, modification, or unauthorized destruction of the Data. The Data processing is carried out using computers and/or IT enabled tools, following organizational procedures and modes strictly related to the purposes indicated. In addition to the Owner, in some cases, the Data may be accessible to certain types of persons in charge, involved with the operation of this Application (administration, sales, marketing, legal, system administration) or external parties (such as third-party technical service providers, mail carriers, hosting providers, IT companies, communications agencies) appointed, if necessary, as Data Processors by the Owner. The updated list of these parties may be requested from the Owner at any time. Legal basis of processing The Owner may process Personal Data relating to Users if one of the following applies: • Users have given their consent for one or more specific purposes. Note: Under some legislations the Owner may be allowed to process Personal Data until the User objects to such processing (“opt-out”), without having to rely on consent or any other of the following legal bases. This, however, does not apply, whenever the processing of Personal Data is subject to European data protection law; • provision of Data is necessary for the performance of an agreement with the User and/or for any pre-contractual obligations thereof; • processing is necessary for compliance with a legal obligation to which the Owner is subject; • processing is related to a task that is carried out in the public interest or in the exercise of official authority vested in the Owner; • processing is necessary for the purposes of the legitimate interests pursued by the Owner or by a third party. In any case, the Owner will gladly help to clarify the specific legal basis that applies to the processing, and in particular whether the provision of Personal Data is a statutory or contractual requirement, or a requirement necessary to enter into a contract. Place The Data is processed at the Owner's operating offices and in any other places where the parties involved in the processing are located. Depending on the User's location, data transfers may involve transferring the User's Data to a country other than their own. To find out more about the place of processing of such transferred Data, Users can check the section containing details about the processing of Personal Data. Users are also entitled to learn about the legal basis of Data transfers to a country outside the European Union or to any international organization governed by public international law or set up by two or more countries, such as the UN, and about the security measures taken by the Owner to safeguard their Data. If any such transfer takes place, Users can find out more by checking the relevant sections of this document or inquire with the Owner using the information provided in the contact section. Retention time Personal Data shall be processed and stored for as long as required by the purpose they have been collected for. Therefore: • Personal Data collected for purposes related to the performance of a contract between the Owner and the User shall be retained until such contract has been fully performed. • Personal Data collected for the purposes of the Owner’s legitimate interests shall be retained as long as needed to fulfill such purposes. Users may find specific information regarding the legitimate interests pursued by the Owner within the relevant sections of this document or by contacting the Owner. The Owner may be allowed to retain Personal Data for a longer period whenever the User has given consent to such processing, as long as such consent is not withdrawn. Furthermore, the Owner may be obliged to retain Personal Data for a longer period whenever required to do so for the performance of a legal obligation or upon order of an authority. Once the retention period expires, Personal Data shall be deleted. Therefore, the right to access, the right to erasure, the right to rectification and the right to data portability cannot be enforced after expiration of the retention period. The purposes of processing The Data concerning the User is collected to allow the Owner to provide its Services, as well as for the following purposes: Registration and authentication, Content performance and features testing (A/B testing), Infrastructure monitoring, Hosting and backend infrastructure, Analytics and Access to third-party accounts. Users can find further detailed information about such purposes of processing and about the specific Personal Data used for each purpose in the respective sections of this document. Facebook permissions asked by this Application This Application may ask for some Facebook permissions allowing it to perform actions with the User's Facebook account and to retrieve information, including Personal Data, from it. This service allows this Application to connect with the User's account on the Facebook social network, provided by Facebook Inc. For more information about the following permissions, refer to the Facebook permissions documentation and to the Facebook privacy policy . The permissions asked are the following: Basic information By default, this includes certain User’s Data such as id, name, picture, gender, and their locale. Certain connections of the User, such as the Friends, are also available. If the User has made more of their Data public, more information will be available. Email Provides access to the User's primary email address. Detailed information on the processing of Personal Data Personal Data is collected for the following purposes and using the following services: Access to third-party accounts This type of service allows this Application to access Data from your account on a third-party service and perform actions with it. These services are not activated automatically, but require explicit authorization by the User. Facebook account access (this Application) This service allows this Application to connect with the User's account on the Facebook social network, provided by Facebook, Inc. Permissions asked: Email. Place of processing: United States – Privacy Policy . Privacy Shield participant. Analytics The services contained in this section enable the Owner to monitor and analyze web traffic and can be used to keep track of User behavior. Google Analytics for Firebase (Google LLC, Google Ireland Limited) Google Analytics for Firebase or Firebase Analytics is an analytics service provided by Google LLC or by Google Ireland Limited, depending on the location this Application is accessed from. In order to understand Google's use of Data, consult Google's partner policy . Firebase Analytics may share Data with other tools provided by Firebase, such as Crashlytics, Authentication, Remote Config or Notifications. The User may check this privacy policy to find a detailed explanation about the other tools used by the Owner. This Application uses identifiers for mobile devices (including Android Advertising ID or Advertising Identifier for iOS, respectively) and technologies similar to cookies to run the Firebase Analytics service. Users may opt-out of certain Firebase features through applicable device settings, such as the device advertising settings for mobile phones or by following the instructions in other Firebase related sections of this privacy policy, if available. Personal Data collected: Application opens, Application updates, Cookies, device information, first launches, geography/region, In-app purchases, number of sessions, number of Users , operating systems, session duration, unique device identifiers for advertising (Google Advertiser ID or IDFA, for example) and Usage Data. Place of processing: United States – Privacy Policy ; Ireland – Privacy Policy . Privacy Shield participant. Content performance and features testing (A/B testing) The services contained in this section allow the Owner to track and analyze the User response concerning web traffic or behavior regarding changes to the structure, text or any other component of this Application. Firebase Remote Config (Google LLC, Google Ireland Limited) Firebase Remote Config is an A/B testing and configuration service provided by Google LLC or by Google Ireland Limited, depending on the location this Application is accessed from. Personal Data collected: various types of Data as specified in the privacy policy of the service. Place of processing: United States – Privacy Policy ; Ireland – Privacy Policy . Privacy Shield participant. Hosting and backend infrastructure This type of service has the purpose of hosting Data and files that enable this Application to run and be distributed as well as to provide a ready-made infrastructure to run specific features or parts of this Application. Some of these services work through geographically distributed servers, making it difficult to determine the actual location where the Personal Data are stored. Firebase Realtime Database (Google LLC, Google Ireland Limited) Firebase Realtime Database is a hosting and backend service provided by Google LLC or by Google Ireland Limited, depending on the location this Application is accessed from. Personal Data collected: Usage Data and various types of Data as specified in the privacy policy of the service. Place of processing: United States – Privacy Policy . Privacy Shield participant. Infrastructure monitoring This type of service allows this Application to monitor the use and behavior of its components so its performance, operation, maintenance and troubleshooting can be improved. Which Personal Data are processed depends on the characteristics and mode of implementation of these services, whose function is to filter the activities of this Application. Crashlytics (Google LLC, Google Ireland Limited) Crashlytics is a monitoring service provided by Google LLC or by Google Ireland Limited, depending on the location this Application is accessed from. Personal Data collected: Various types of data as specified in the privacy policy of the service Place of processing: United States – Privacy Policy ; Ireland – Privacy Policy . Registration and authentication By registering or authenticating, Users allow this Application to identify them and give them access to dedicated services. Depending on what is described below, third parties may provide registration and authentication services. In this case, this Application will be able to access some Data, stored by these third-party services, for registration or identification purposes. Firebase Authentication (Google LLC, Google Ireland Limited) Firebase Authentication is a registration and authentication service provided by Google LLC or by Google Ireland Limited, depending on the location this Application is accessed from. To simplify the registration and authentication process, Firebase Authentication can make use of third-party identity providers and save the information on its platform. Personal Data collected: Email address, Profile picture, Social media accounts and Username. Place of processing: United States – Privacy Policy ; Ireland – Privacy Policy . Privacy Shield participant. Facebook Authentication (Facebook, Inc.) Facebook Authentication is a registration and authentication service provided by Facebook, Inc. and is connected to the Facebook social network. Personal Data collected: various types of Data as specified in the privacy policy of the service. Place of processing: United States – Privacy Policy . Privacy Shield participant. Further information about Personal Data The Service is not directed to children under the age of 13 Users declare themselves to be adult according to their applicable legislation. Minors may use this Application only with the assistance of a parent or guardian. Under no circumstance persons under the age of 13 may use this Application. The rights of Users Users may exercise certain rights regarding their Data processed by the Owner. In particular, Users have the right to do the following: • Withdraw their consent at any time. Users have the right to withdraw consent where they have previously given their consent to the processing of their Personal Data. • Object to processing of their Data. Users have the right to object to the processing of their Data if the processing is carried out on a legal basis other than consent. Further details are provided in the dedicated section below. • Access their Data. Users have the right to learn if Data is being processed by the Owner, obtain disclosure regarding certain aspects of the processing and obtain a copy of the Data undergoing processing. • Verify and seek rectification. Users have the right to verify the accuracy of their Data and ask for it to be updated or corrected. • Restrict the processing of their Data. Users have the right, under certain circumstances, to restrict the processing of their Data. In this case, the Owner will not process their Data for any purpose other than storing it. • Have their Personal Data deleted or otherwise removed. Users have the right, under certain circumstances, to obtain the erasure of their Data from the Owner. • Receive their Data and have it transferred to another controller. Users have the right to receive their Data in a structured, commonly used and machine readable format and, if technically feasible, to have it transmitted to another controller without any hindrance. This provision is applicable provided that the Data is processed by automated means and that the processing is based on the User's consent, on a contract which the User is part of or on pre-contractual obligations thereof. • Lodge a complaint. Users have the right to bring a claim before their competent data protection authority. Details about the right to object to processing Where Personal Data is processed for a public interest, in the exercise of an official authority vested in the Owner or for the purposes of the legitimate interests pursued by the Owner, Users may object to such processing by providing a ground related to their particular situation to justify the objection. Users must know that, however, should their Personal Data be processed for direct marketing purposes, they can object to that processing at any time without providing any justification. To learn, whether the Owner is processing Personal Data for direct marketing purposes, Users may refer to the relevant sections of this document. How to exercise these rights Any requests to exercise User rights can be directed to the Owner through the contact details provided in this document. These requests can be exercised free of charge and will be addressed by the Owner as early as possible and always within one month. Additional information about Data collection and processing Legal action The User's Personal Data may be used for legal purposes by the Owner in Court or in the stages leading to possible legal action arising from improper use of this Application or the related Services. The User declares to be aware that the Owner may be required to reveal personal data upon request of public authorities. Additional information about User's Personal Data In addition to the information contained in this privacy policy, this Application may provide the User with additional and contextual information concerning particular Services or the collection and processing of Personal Data upon request. System logs and maintenance For operation and maintenance purposes, this Application and any third-party services may collect files that record interaction with this Application (System logs) use other Personal Data (such as the IP Address) for this purpose. Information not contained in this policy More details concerning the collection or processing of Personal Data may be requested from the Owner at any time. Please see the contact information at the beginning of this document. How “Do Not Track” requests are handled This Application does not support “Do Not Track” requests. To determine whether any of the third-party services it uses honor the “Do Not Track” requests, please read their privacy policies. Changes to this privacy policy The Owner reserves the right to make changes to this privacy policy at any time by giving notice to its Users on this page and possibly within this Application and/or - as far as technically and legally feasible - sending a notice to Users via any contact information available to the Owner. It is strongly recommended to check this page often, referring to the date of the last modification listed at the bottom. Should the changes affect processing activities performed on the basis of the User’s consent, the Owner shall collect new consent from the User, where required. Definitions and legal references Personal Data (or Data) Any information that directly, indirectly, or in connection with other information — including a personal identification number — allows for the identification or identifiability of a natural person. Usage Data Information collected automatically through this Application (or third-party services employed in this Application), which can include: the IP addresses or domain names of the computers utilized by the Users who use this Application, the URI addresses (Uniform Resource Identifier), the time of the request, the method utilized to submit the request to the server, the size of the file received in response, the numerical code indicating the status of the server's answer (successful outcome, error, etc.), the country of origin, the features of the browser and the operating system utilized by the User, the various time details per visit (e.g., the time spent on each page within the Application) and the details about the path followed within the Application with special reference to the sequence of pages visited, and other parameters about the device operating system and/or the User's IT environment. User The individual using this Application who, unless otherwise specified, coincides with the Data Subject. Data Subject The natural person to whom the Personal Data refers. Data Processor (or Data Supervisor) The natural or legal person, public authority, agency or other body which processes Personal Data on behalf of the Controller, as described in this privacy policy. Data Controller (or Owner) The natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of Personal Data, including the security measures concerning the operation and use of this Application. The Data Controller, unless otherwise specified, is the Owner of this Application. This Application The means by which the Personal Data of the User is collected and processed. Service The service provided by this Application as described in the relative terms (if available) and on this site/application. European Union (or EU) Unless otherwise specified, all references made within this document to the European Union include all current member states to the European Union and the European Economic Area. Cookies Small sets of data stored in the User's device. Legal information This privacy statement has been prepared based on provisions of multiple legislations, including Art. 13/14 of Regulation (EU) 2016/679 (General Data Protection Regulation). This privacy policy relates solely to this Application, if not stated otherwise within this document."
 """])
    print((1-float(result))*100)
