---
title: 1.0.0-beta.6
tag_name: v1.0.0-beta.6
link: https://github.com/phenomic/phenomic/releases/tag/v1.0.0-beta.6
author: MoOx
prerelease: true
---

## Erratum

Check out [beta.7](../v1.0.0-beta.7/) which includes bugfixes related to this
release.

## 🚨 Breaking change

- [Upgrade from babel 6 to babel 7](https://github.com/phenomic/phenomic/commit/bb0ce41b4fde26fbe4230601f3c39a6a442e873e)
  ([+fixup](https://github.com/phenomic/phenomic/commit/09525f2058788030132026050a7cf55cab61527a)).
  ⚠️ If you were using phenomic without any custom babel config, this update
  should be transparent for you.
- Reason users: you will night to replace `*.js` by `*.bs.js` for some files Eg:
  `import { createContainer } from "@phenomic/preset-react-app/lib/es6/src/phenomicPresetReactApp.js";`
  to
  `import { createContainer } from "@phenomic/preset-react-app/lib/es6/src/phenomicPresetReactApp.bs.js";`

## 😋 Fixes

- [plugin-bundler-webpack: Fix: Add apollo support (defined as external dependency to avoid SSR issues with in memory cache)](https://github.com/phenomic/phenomic/commit/7b7afcb797ea4c991cfed0bc71f9afa8b218afa4)
- [plugin-renderer-react: Fix: provide same props for getInitialProps during SSR and CSR (pathname+params)](https://github.com/phenomic/phenomic/commit/b4fb5d826dc23a282a7eb82674c8f0fd13da8320).
  We previously send too many props during SSR to `getInitialProps()`, different
  from CSR)
- [plugin-renderer-react: fix issue with "class" prop generated from markdown in BodyRenderer](https://github.com/phenomic/phenomic/commit/80157cb0d443667adf8db6372b9143b844756e03)

## 👍 Improvements

- [core: Failing URLs during static pre-rendering do not crash the entire build anymore](https://github.com/phenomic/phenomic/commit/cd75f861db108a5e37a8a6f45b1d2ae7a2fc0f11)
- [core: Better error reporting about errors like `window is not defined` during static build with a tip on how to fix it](https://github.com/phenomic/phenomic/commit/94ae4f71b1dfbc7f335c2253b022ec6562ca9707)
- [core: CLI output is now more sweet](https://github.com/phenomic/phenomic/commit/9656d92de1a8a7c469e62a2931c70df0e8cca2a5).
  Here is a before/after.  
  ![phenomic-cli-beta 6](https://user-images.githubusercontent.com/157534/49691182-147b4580-fb3d-11e8-9ec9-235d71377051.jpg)
- [core: avoid deprecated Buffer warning](https://github.com/phenomic/phenomic/commit/22ff8f904443b42c4b861a587fab0b7db134aa88)
- [plugin-bundler-webpack: Hide annoying warning `Critical dependency: the request of a dependency is an expression`](https://github.com/phenomic/phenomic/commit/931f60f157fb6f7e926b80639a1550bdb779e00a)
- [plugin-bunder-webpack: errors/warnings are now rendered using native webpack output](https://github.com/phenomic/phenomic/commit/73399f13c06f132a123735b25274b8009efdb3f5)
- [plugin-bundler-webpack: development mode is now showing "minimal" output by default](https://github.com/phenomic/phenomic/commit/389346045df23b216f81ed5ca17b5bb6c83e9af8)
- [plugin-bundler-webpack: cache is now enabled for babel-loader](https://github.com/phenomic/phenomic/commit/31530cdc8980adb667357198d9df1472da2f7784)
- [plugin-bundler-webpack: allow config to be exported as es6 (export default)](https://github.com/phenomic/phenomic/commit/629fd542b6b17ff3aaefe3bd1de346b472e156b0)

## 🥳 Internal

- Refactoring of webpack bundler plugin in order to prepare future SSR rendering
  enabled in dev mode
- Reason code (generated as javascript) used in the core codebase (experimental)
- Multiple other minors improvements...
