---
title: 1.0.0-beta.3
tag_name: v1.0.0-beta.3
link: https://github.com/phenomic/phenomic/releases/tag/v1.0.0-beta.3
author: MoOx
prerelease: true
---

# Hopefully, the last beta

We are very close to our final and stable release for v1. Why we didn't ship
this version already? Some people like to move fast & break things. But we
wanted to have a correct design for the v1 so future majors version won't break
too much things.

What we did for v0.x was an experiment and we learned a lot of things by running
this in production on moderate websites. We have spent a lot of brain energy to
make a scalable & flexible solution with a small API surface.

We have designed an architecture that follow React way of thinking, by offering
a [centralized lifecycle](/en/packages/core/docs/writing-plugins/). With that in
mind we have adjusted our goal and make React & Webpack, 2 core pieces of v0.x,
first class plugins in our v1.x. This opens up lot of nice things to support
React or Webpack alternatives.

## Documentation is a work in progress 🎉

First thing to celebrate, we started to work on our website! You can now find
[documentation for the core](/en/packages/core/docs/) and the
[react preset tutorial](/en/packages/preset-react-app/docs/)! More things will
follow!

## 2 small breaking changes

Below you will find 2 small breaking changes, **very easy to adjust** (that will
probably consist of adding `content` in front of all your current existing query
to our content api or to adjust your configuration).

[🚨 `@phenomic/core`: `content` options now supports multiples entries and globs ](https://github.com/phenomic/phenomic/commit/05ef940603981bb9971b02234a31e601d29067f7)
(+
[fixup](https://github.com/phenomic/phenomic/commit/c79b572fa9c54cf88419dac1f6367e3cd5a5c0ef))
by @MoOx

**All your previous queries won't work with this breaking change** but don't
worry, it's very easy to adjust your code.

We are sorry to add a breaking change now, but it's for the better.

**Solution 1 (recommended)**: You will have to add "content/" in front of all
your `path` in your queries. Why? It's for being more explicit and also be able
to support multiples sources (multiples folders) to avoid duplicate names
without a weird configuration. The upgrade is pretty easy.

For example

```js
const HomeContainer = withPhenomicApi(Home, props => ({
  posts: query({
    path: "posts",
  }),
}));
```

Will become

```js
const HomeContainer = withPhenomicApi(Home, props => ({
  posts: query({
    path: "content/posts",
  }),
}));
```

**Solution 2 (for lazy people)**: You can keep the previous behavior very easily
by using this value for `content` option:
`"": {root: "content", globs: ["**/*"]}`. You can throw that in your
`package.json` in a `phenomic` like this:

```json
  "phenomic": {
    "content": {
      "": {root: "content", globs: ["**/*"]}
    },
    "presets": ["@phenomic/preset-react-app"]
  }
```

[🚨 `@phenomic/plugin-rss-feed`: now lookup in `content/posts` by default. ](https://github.com/phenomic/phenomic/commit/05ef940603981bb9971b02234a31e601d29067f7)
by @MoOx

To get previous behavior back, just use this configuration (adjust to match
yours):

```json
  "phenomic": {
    "presets": ["@phenomic/preset-react-app"],
    "plugins": [
      [
        "@phenomic/plugin-rss-feed",
        {
          "feeds": {
            "feed.xml": {
              "query": {
                "path": "content/posts"
              }
            }
          }
        }
      ]
    ]
  },
```

## Bugfixes

[🐛 `@phenomic/plugin-renderer-react`: Handle scroll like it should (to top or to the hash if any) ](https://github.com/phenomic/phenomic/commit/d4824c531073e31fa1b74f45bbdaf7db1ba642e3)
by @MoOx

[🐛`phenomic/plugin-collector-files`: correctly clean extensions from filename for id (not only md|json but all extensions by the plugin loaded at runtime) ](https://github.com/phenomic/phenomic/commit/b924d0bca097ba31e9f38c0c0a35c68fa98865ae)
by @MoOx

## Tons of small improvements

As we started to actively working on our documentation, we have added tons of
small improvements.

[✨ `@phenomic/plugin-renderer-react`: add render + callback option to createApp/renderApp for custom rendering ](https://github.com/phenomic/phenomic/commit/ce083d92f7abced22dbc8a2884649a92f47cdf41)
by @MoOx

This commit allows you to use a custom render() function. This way to render the
app is required by some solutions that needs a custom wrapper for styles
pre-rendering (eg: react-native-web).

[🎉 examples/react-native-web-app ](https://github.com/phenomic/phenomic/commit/dd9d19f6e3a5dba60e7262311c8eb060d8661070)
by @MoOx

[✨ `@phenomic/core`: add socketPort option (and switch to 3334 since 1415 can be used by dbstar) ](https://github.com/phenomic/phenomic/commit/645c89977f955b619c7bb9018f08f0d3259a379a)
by @MoOx

[✨`@phenomic/core`: Improve error shown from database access ](https://github.com/phenomic/phenomic/commit/4df49e34e6eeef33e0676f5293933d67db8daa3c)
by @MoOx

[✨ `@phenomic/core`: Improve error message from database not found entry ](https://github.com/phenomic/phenomic/commit/fc729aa0dee61d2fc81b5b294f583f705bf40bf6)
by @MoOx

[🔥 Add a new helper to extract meta from body nodes (title + headings list) ](https://github.com/phenomic/phenomic/commit/da0d4da4d5a39c865dd68d78a14ee3533adcb943)
(+
[fixup](https://github.com/phenomic/phenomic/commit/1b68eff0c6a0e299da3e3c7a9c897cc4338525aa))
by @MoOx

This helper is used in `@phenomic/plugin-transform-markdown` and
`@phenomic/plugin-transform-asciidoc` to **automatically add a `title` meta**
even if you don't have frontmatter. Pretty cool for files that you don't
control. This helper also returns a list of headings in your content, which is
pretty convenient to make a **table of content** at the top of you page or in a
sidebar.

[✨ `@phenomic/plugin-transform-markdown`: add title fallback extracted from markdown body if no title is in the frontmatter + add a list of markdown headings ](https://github.com/phenomic/phenomic/commit/3f35a51dc09f5a00cb2ad3d268d820563addbcab)
(+
[fixup](https://github.com/phenomic/phenomic/commit/1b68eff0c6a0e299da3e3c7a9c897cc4338525aa))
by @MoOx

[✨ `@phenomic/plugin-transform-asciidoc`: add title fallback extracted from markdown body if no title is in the frontmatter + add a list of markdown headings ](https://github.com/phenomic/phenomic/commit/3f35a51dc09f5a00cb2ad3d268d820563addbcab)
(+
[fixup](https://github.com/phenomic/phenomic/commit/1b68eff0c6a0e299da3e3c7a9c897cc4338525aa))
by @MoOx

[✨ `@phenomic/plugin-transform-json`: add title fallback ](https://github.com/phenomic/phenomic/commit/3f35a51dc09f5a00cb2ad3d268d820563addbcab)
by @MoOx

[✨ `@phenomic/core`: better display in case of error during start/build ](https://github.com/phenomic/phenomic/commit/ef32bb098a9a561aa483d2267a355c20f3a69beb)
by @MoOx

[✨ `@phenomic/core`: add options to sort db results ](https://github.com/phenomic/phenomic/commit/a1f869ab5669083073dcdb310a1c86bfa87b213b)
by @MoOx

This feature is pretty awesome and allows you to add custom order to your query.
As a good example, we wanted to sort our showcase with the following algorithm:

- Sites with a flag `curated` first
- Sites with many tags
- Sites with tags "blog" at the end.

In order to do so, we have introduced this option and we hope you will like it.
You can check out the
[documentation for `db.sortFunctions`](/en/packages/core/docs/configuration/#dbsortfunctions)
and take a look to the
[one we use for the showcase](https://github.com/phenomic/phenomic/blob/801c2ad9720cb17cb599597f0dc1e020e1b581b9/website/phenomic.config.js#L32-L52).

[✨ `@phenomic/cli`: add preview command ](https://github.com/phenomic/phenomic/commit/88c10b94c26830b2c2397da2fc2477f6175e5626)
by @MoOx

[✨ `@phenomic/core`: add preview command to build & serve results ](https://github.com/phenomic/phenomic/commit/c2e0ecc9c7d6d75b4817eb7551dc690e4280081f)
by @MoOx

Now you can run

```console
phenomic preview
```

This will build and serve the website, to mimic production (as you will have the
pre-rendered files and the client side reconciliation).
