---
title: 1.0.0-beta.2
tag_name: v1.0.0-beta.2
link: https://github.com/phenomic/phenomic/releases/tag/v1.0.0-beta.2
author: MoOx
prerelease: true
---

# Stable 1.0.0, we are almost there!

This release is probably the penultimate before the stable release. It brings us
2 majors things:

- 🎉 For React users, 2 methods, supported via the new `withInitialProps` HOC,
  allows you to consume any kind of data (not just Phenomic API but any kind of
  REST APIs, GraphQL APIs for CMS etc) via `static async getInitialProps()`.
  This API, inspired by Next.js is not alone as it comes with another new method
  for the pre-rendering step, called `static async getAllPossibleUrls()`.
- 💪 We adjusted 2 transform plugins (markdown and asciidoc) so you can directly
  pass to those the [unified](https://unifiedjs.github.io) plugins you want to
  use.

This release is an important step for us as it brings us our missing pieces to
be happy with Phenomic current state. Stay tuned for the final release, that
will be done at the same time as we will publish documentations on the website.

🤩 We also created a new
[react-app-blog](https://github.com/phenomic/phenomic/tree/master/examples/react-app-blog)
example that you can use as a good starting point to create any site (not only a
blog - and we plan to push more examples when we will hit stable 1.0.0). This
starter includes some pages, some posts, and the usage of our new fresh API to
create pages from github data (but you can just use this and replace with any
kind of API) to generate client side and static generated pages from those data!
For the architecture, we used something simple, with a few components for
header/footer with differents layouts etc. We also included a standard error
page (used for 404). For the styling, we didn't wanted to do something too
opinionated and also something too old school (CSS in dedicated files since we
all love CSS-in-JS), so we took an simple approach in the middle, with a CSS
style tags per components. This allows CSS lover to just extract the CSS in
files, and CSS-in-JS lovers to easily convert in places the styles. Remember
that we have
[plenty of examples to know how to handle CSS via any kind of solutions](https://github.com/phenomic/phenomic/tree/master/examples).
You will find a visual preview at the end of this post.

## Details

[⚠️ `@phenomic/plugin-renderer-react`: `createContainer` is now `withPhenomicApi`(you will get a warning until you update your import)](https://github.com/phenomic/phenomic/commit/a4e12968f9d8d871e82e24d14c5b11cd4d1b6f59)
by @MoOx Not a breaking change yet, but will be during stable 1.0.0 release.

[🐛 `@phenomic/plugin-collector-files`: fix edge case when you request an index file with an id (db was not correctly filled)](https://github.com/phenomic/phenomic/commit/a8648fcf5de98d21024d5853f56b7f9cdf08859f)
by @MoOx

[🐛 `@phenomic/core`: fix edge case when you request an empty id (for `index`)](https://github.com/phenomic/phenomic/commit/17f830a6a4a35956ec67d665b9e6036932c2bb70)
by @MoOx

[🐛 `@phenomic/core`: fix time log between pre-rendering and after build hook](https://github.com/phenomic/phenomic/commit/4888896f4614e2cf45130358adde771ccd1dbf5e)
by @MoOx

[🐛 `@phenomic/plugin-transform-markdown`: code is now highlighted without failing if language is not recognized](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx

[🚨`@phenomic/plugin-transform-markdown`: remark/rehype plugins order have been changed a bit](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx This should only affect you if you were relying on (previously broken)
code highlight.

[🚨/✨ `@phenomic/plugin-transform-asciidoc`: plugin have been update to work like markdown.](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx Previously we never tested this plugin on a real project so we are not
sure it has ever worked correctly 😁.

[✨ `@phenomic/plugin-transform-markdown`: you can now specifiy options for highlighting language unsupported by default](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx

[✨ `@phenomic/plugin-transform-markdown`: you can now choose between json/html mode for the rendering via `output` option](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx

[✨ `@phenomic/plugin-transform-markdown`: new `plugins` option to replace unified/remark/rehype plugins](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx

[✨ `@phenomic/plugin-transform-asciidoc`: you can now choose between json/html mode for the rendering via `output` option](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx

[✨ `@phenomic/plugin-transform-asciidoc`: new `plugins` option to replace unified/remark/rehype plugins](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx

[✨ `@phenomic/helpers-transform`: new package that exposes stuff shared across transform plugin](https://github.com/phenomic/phenomic/commit/dd24918679b4acb5316b261bf3e032f8f305263c)
by @MoOx

[✨ `@phenomic/plugin-renderer-react`: `withInitialProps` HOC that supports `static async getInitialProps({pathname, params})` and `static async getAllPossibleUrls({path})`](https://github.com/phenomic/phenomic/commit/a4e12968f9d8d871e82e24d14c5b11cd4d1b6f59)
by @MoOx This allows to generate pages with any source of data (fetch from any
kind of REST, Grapql APIs). Inspired by Next.js.\
You can check our [example of usage in our react-app-blog example](https://github.com/phenomic/phenomic/commit/955abe1bf398109188587f2f30395352cdb7fb2a#diff-bd62372cd295cbc2187ac3152a4745bcR24)

[✨ `@phenomic/plugin-renderer-react`: `withPhenomicApi` HOC (previously named `createContainer`)](https://github.com/phenomic/phenomic/commit/a4e12968f9d8d871e82e24d14c5b11cd4d1b6f59)
by @MoOx

[🎉 examples/react-app-blog: a sweet starter to discover phenomic with react and make a blog in a few minutes](https://github.com/phenomic/phenomic/commit/4e52d7c409c422d01856af24b9845c2cb4ee621c)
by @MoOx

## Preview of the homepage of the new react-app-blog example

[![preview](https://user-images.githubusercontent.com/157534/38459800-d22f4932-3aae-11e8-9af8-b2169c87f7ee.png)](https://github.com/phenomic/phenomic/tree/master/examples/react-app-blog)
